﻿USE sofia;
DROP TABLE IF EXISTS sofia.vid_vpl;
CREATE TABLE vid_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES vid_vpl WRITE;
INSERT INTO vid_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Aho mwaluko, Nguluwi nakalumba kilanga na isi. ");
INSERT INTO vid_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Isi nayali kota kugunuche na nayalihela chinhu. Jiza nayali igubiche mazi menji, na Muhe wa Nguluwi nayali yekale yenele mchanya mwa mazi menji. ");
INSERT INTO vid_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Na Nguluwi nakalonga, “Kuwe kubunguzuche,” baho kubunguzuka. ");
INSERT INTO vid_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Nguluwi nakona kubunguzuka kunoga. Hamba Nguluwi kalekaniza kubunguzuka na jiza. ");
INSERT INTO vid_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Nguluwi nakaluchema lumuli “Nemisi” na jiza nakaichema “Nechilo.” Iwa matinazo na iwa mitondo, zuwa lya mwaluko. ");
INSERT INTO vid_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Nguluwi nakalonga, “Hawe honhu hagati ha mazi, ugawanuse mazi banzi mbili.” ");
INSERT INTO vid_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Nguluwi nakadita honhu aho, kalekaniza mazi gawele kuchanya na mazi gawele hasi, iwa hihyo. ");
INSERT INTO vid_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Nguluwi nakahachema “Ulanga.” Iwa matinazo na iwa mitondo, zuwa lya keli. ");
INSERT INTO vid_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Nguluwi nakalonga, “Mazi gawele hasi ha ulanga, gawe honhu hamwe, isi ili kigongo ilawile.” Iwa hihyo. ");
INSERT INTO vid_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Nguluwi nakahachema honhu aho kigongo “Isi” na nhing'hano ya mazi kahachema “Bahali”. Nakona kuta inoga. ");
INSERT INTO vid_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Hamba Nguluwi nakalonga, “Isi nayote mizuchila, mizuchila jilingulela nyhule na migodi jilingulela mafuza gawele na nyhule, nyhule zilingulela mizuchila ja nhanzi yiyo.” Iwa hihyo. ");
INSERT INTO vid_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Lelo isi yota mizuchila jilingulela nyhule za chila nhanzi na migodi jilingulela mafuza gawele na nyhule za chila nhanzi, Nguluwi nakona kota inoga. ");
INSERT INTO vid_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Iwa matinazo, iwa mitondo, zuwa lya kadatu. ");
INSERT INTO vid_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Nguluwi nakalonga, “Mimwemwesa jiwe kilanga, jilekanize nemisi na nechilo, jilajile mihela ja mnvina na zuwa na miyaka, ");
INSERT INTO vid_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","na lumwemwese kilanga na kuimwemwesela isi.” Iwa hihyo. ");
INSERT INTO vid_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Lelo Nguluwi nakadita mimwemwesa mili mikulu, ula ukulu ulangaze nemisi, na ula udodo ulangaze nechilo, nakadita na nhondwe kahi. ");
INSERT INTO vid_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Nguluwi nakawika mimwemwesa jiwele kilanga jimwemwesele isi, ");
INSERT INTO vid_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","iwe ilangaza nemisi na nechilo, na kulekaniza lumuli na jiza. Nguluwi nakona kota inoga. ");
INSERT INTO vid_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Iwa matinazo, iwa mitondo, zuwa lya kane. ");
INSERT INTO vid_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Nguluwi nakalonga, “Mazi nagalavye vilundo vya vilumbigwe viwele na ukomu, na kilanga kumemezwe videje vilinguguluka kuulanga.” ");
INSERT INTO vid_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Lelo Nguluwi nakalumba migongolo ming'hangala ja bahali, chila chilumbigwe cha mli bahali na nhanzi zawo. Nakalumba chila videje na nhanzi zawo. Nguluwi nakona kota inoga. ");
INSERT INTO vid_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Nguluwi nakavitambichiza, nakalonga, “Mlele miyonjeze, mmemeze mazi ga bahali, navyo videje vyonjezeche kuli isi.” ");
INSERT INTO vid_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Iwa matinazo, iwa mitondo, zuwa lya kahano. ");
INSERT INTO vid_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Kahi Nguluwi nakalonga, “Isi nailavye vilumbigwe vyeng'ha viwele vikomu, vyakudimigwa hakaye, vilingutambala, na vilingikala kisolo chila chilumbigwe kwa nhanzi zawo.” Iwa hihyo. ");
INSERT INTO vid_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Lelo Nguluwi nakalumba nhanzi zeng'ha za migongolo ja kisolo na ja kufujigwa na vilingutambala. Nguluwi nakona kota inoga. ");
INSERT INTO vid_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Hamba Nguluwi nakalonga, “Tumdite munhu kwa kiwhana na hetwe, yalongoze somba mli bahali na videje vya kilanga na migongolo ja kufujigwa hakaye hali isi yeng'ha na vilumbigwe vyeng'ha vilingutambala.” ");
INSERT INTO vid_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Lelo Nguluwi nakalumba munhu kwa kiwhana na heye, ena, kwa kiwhana na heye Nguluwi nakamlumba. Nakawalumba mlume na mdala. ");
INSERT INTO vid_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Nguluwi nakawatambichiza na kuwalonjela, “Muwe na wana mwonjezeche na mkaimemeze isi yeng'ha na kuilongoza, mlongoze somba ziwele mbahali na videje kuli ulanga na chila chilumbigwe chikomu chilingujenda muisi.” ");
INSERT INTO vid_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Hamba Nguluwi nakalonga, “Mlole ndanguwapa chila izuchila muisi lilingulela nyhule, na chila igodi lilingulela mafuza gawele na nyhule, mafuza gake na nyhule zake zowa chilyo cha hemwe. ");
INSERT INTO vid_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Na ajo migongolo jeng'ha na videje vyeng'ha viwele kuli ulanga na vilumbigwe vilingutambala, ena chila chilumbigwe chiwele na ukomu, chilyo chawo chowa mahamba geng'ha ga mizuchila.” Iwa hihyo. ");
INSERT INTO vid_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Nguluwi nakona chila chinhu choyaditile kota ndo chinoga ng'hatu. Iwa matinazo, iwa mitondo, zuwa lya sita. ");
INSERT INTO vid_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Ahyo ndo kilanga kweng'ha na isi lovigongomanyigwe hamwe na vinhu vyeng'ha viwele mgati. ");
INSERT INTO vid_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Zuwa lya saba Nguluwi nakasinda mijito ja heye joyaditile, zuwa alyo lya saba Nguluwi nakesela kwa jila mijito jeng'ha joyakolile. ");
INSERT INTO vid_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Nguluwi nakalitambichiza zuwa lya saba na kulidita liwe lyelile, kwa vila zuwa alyo Nguluwi nakesela kwa jila mijito ja heye jeng'ha ja kulumba. ");
INSERT INTO vid_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Ahyo ndo vyoiwele kilanga na isi yeng'ha lovilumbigwe. Mhela wula Mkulu Nguluwi loyazilumbile isi na kilanga, ");
INSERT INTO vid_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","kwali kuduhu mizuchila kuli isi ne migodi hajizuchile kwa vila Mkulu Nguluwi nahaitowele nhonya isi, na hakuwele munhu wa kulima. ");
INSERT INTO vid_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Na baho mazi nagalawa hasi gainweza isi yeng'ha. ");
INSERT INTO vid_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Lelo Mkulu Nguluwi nakamlumba mlume kwa misanga, kamputila kumenyhelo lweselo lwa ukomu, na ayo mlume nakawa chilumbigwe chiwele na ukomu. ");
INSERT INTO vid_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Hamba Mkulu Nguluwi nakalumba kamgunda ako Edeni, nzingo ya kolilawilaga isanya na mumo nakumuwika mlume yamlumbile. ");
INSERT INTO vid_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Mkulu Nguluwi kazoteza kuli misanga chila nhanzi ya migodi jinojile jilingulela mafuza ganojile kwa chilyo. Hagati ha kamgunda nakanyala mgodi wa ukomu na mgodi wa uwanzi wa ganojile na gehile. ");
INSERT INTO vid_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Kwali na lwanda ako Edeni luwele lubohoka mazi na kukanweza ako kamgunda, kulawila ako lwanda alo nalugawanuka kuwa nzanda zine. ");
INSERT INTO vid_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Itagwa lya lwanda lwa mwaluko lyali Pishoni, alo lwanguzunguluta honhu heng'ha ha Havila kuwele na zahabu. ");
INSERT INTO vid_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Zahabu ya honhu aho inoga ng'hatu. Ako kahi hana unhunyhililo ulinguchemigwa bedola na maganga ga sendi nyinji galingupulika galinguchemigwa shohamu. ");
INSERT INTO vid_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Itagwa lya lwanda lwa keli ndo Gihoni, alo lwanguzunguluta honhu heng'ha ha Kushi. ");
INSERT INTO vid_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Itagwa lya lwanda lwa kadatu ndo Tigili, nalo lwangubohochela nzingo ya kolilawilaga isanya honhu heng'ha ha Ashulu, na itagwa lya lwanda lwa kane ndo Eyufulate. ");
INSERT INTO vid_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Lelo Mkulu Nguluwi nakamhola ayo mlume, kamuwika kuli kala kamgunda ka Edeni, yalime na kulolela. ");
INSERT INTO vid_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Mkulu Nguluwi nakamlajiza ayo mlume, “Hegwe koweza kulya mafuza goneche kuli kamgunda, ");
INSERT INTO vid_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","ila mafuza ga mgodi wa uwanzi wa ganojile na gehile, uleche kulya. Mina loulya mafuza ga mgodi awo, ndangukomya, zuwa alyo hegwe kobagama.” ");
INSERT INTO vid_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Hamba Mkulu Nguluwi nakalonga, “Hainojile ayu mlume yapone yaliyeka. Ndomditila mtanzi yatanganiche.” ");
INSERT INTO vid_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Lelo kulawila kuli misanga, Mkulu Nguluwi nakalumba chila igongolo na videje vya kilanga, hamba kamigalila ayo mlume yalole kowachemela matagwa gachi na matagwa yawapele ndo gawa matagwa gawo. ");
INSERT INTO vid_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Lelo ayo mlume nakajipa matagwa migongolo jeng'ha jila ja kufujigwa na ja kisolo na videje vya kilanga. Ila hakuwele na mtanzi yatanganiche kwa Adamu. ");
INSERT INTO vid_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Lelo Mkulu Nguluwi nakamdita ayo mlume yebatigwe na usinjizi lukami. Loyawele muusinjizi nakahola lubavu lwake lumwe na kuhagubika honhu hala kwa iwunde. ");
INSERT INTO vid_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Na alo lubavu Mkulu Nguluwi yaluholile kulawa kwa yula mlume, kaudita kuwa mdala, kamigala kwa ayo mlume. ");
INSERT INTO vid_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Ndo hala yula mlume yalonjile, “Ena! Ayu ndo izeje kulawa mizeje jangu. Na iwunde kulawila miwunde ja heni. Ayu kochemigwa, ‘Mdala,’ kwa vila kalavigwa kuli mlume.” ");
INSERT INTO vid_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Ndo mina mlume kangumlekaga mhaza na mayake, na kilumba hamwe na mdala wa heye, na hewo weli wowa lukuli lumwe. ");
INSERT INTO vid_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Ayo mlume na mdala wa heye weng'ha wali mwazi, ila nahawawene soni. ");
INSERT INTO vid_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Izoka lyali isugu kusinda migongolo jeng'ha ja kisolo jilumbigwe na Mkulu Nguluwi. Lelo izoka nalimlonjela ayo mdala, “Hambi Nguluwi nakalonga yokomya, mleche kulya mafuza ga mgodi woneche kuli kamgunda?” ");
INSERT INTO vid_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Mdala nakalidichila alyo izoka, “Toweza kulya mafuza ga mgodi woneche kuli kamgunda, ");
INSERT INTO vid_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","ila Nguluwi nakalonga, ‘Mleche kulya mafuza ga mgodi uwele hagati ha kamgunda, kahi mleche kuudoliza, leka mleche kubagama.’ ” ");
INSERT INTO vid_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Izoka nalimlonjela mdala, “Ndangukomya hambagama hebu. ");
INSERT INTO vid_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Nguluwi nakalonga ahyo kwa vila nakavizela kota wone mulye mafuza ga mgodi awo mogubulilwa meho, na hemwe mowa kota Nguluwi, movizela ganojile na gehile.” ");
INSERT INTO vid_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Lelo mdala loyawene kota mgodi awo unoga kwa chilyo, wangunojeza hameho, na kota unoga kwa kuwa na luhala, kabawa ifuza lya igodi, nakalya. Nakamha mlume wa heye na heye, kahi kalya. ");
INSERT INTO vid_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Baho du meho gawo nagagubuligwa, wavizela kota wamwazi, ahyo nawehonela mahamba ga igodi lya ikuyu, weditila salule ya kuvala mchuno. ");
INSERT INTO vid_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Matinazo, mhela wa kwesela mlubehelo, ayo mlume na mdala wa heye wahulika Mkulu Nguluwi yojenda mli kamgunda, na hewo wevisa hagati ha migodi jiwele mumo, leka Mkulu Nguluwi yaleche kuwona. ");
INSERT INTO vid_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Ila Mkulu Nguluwi nakamchema ayo mlume, “Kwa kohi?” ");
INSERT INTO vid_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Na heye nakamwidichila, “Nyhulika kujendajenda kwa hegwe kuli kamgunda, nandumba na kivisa kwa vila nandali mwazi.” ");
INSERT INTO vid_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Mkulu Nguluwi nakamuuza, “Yali kohi yakulonjele kota kwa mwazi? Ndaze, kulya ifuza lya mgodi wondikulonjele uleche kulya?” ");
INSERT INTO vid_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Ayo mlume nakamwidichila, “Mdala youmhele yekale hamwe na heni ndo yamhele ifuza lya mgodi awo, na heni ndiya.” ");
INSERT INTO vid_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Aho Mkulu Nguluwi nakamuuza ayo mdala, “Kudita choni hegwe?” Mdala nakamwidichila, “Izoka nalimbada, na heni ndiya.” ");
INSERT INTO vid_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Hamba Mkulu Nguluwi nakalilonjela izoka, “Kwa vila nakudita ahyo, nakupanjilwa kusinda migongolo jeng'ha ja kufujigwa, na migongolo jeng'ha ja kisolo. Kwa lida kotambala, na kulya nhimbwisi mazuwa gose ga ukomu wa hegwe. ");
INSERT INTO vid_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Ndowika ung'honyo hagati ha hegwe na ayo mdala, hagati ha lulelo lwako na lulelo lwake, heye kochitowa chitwi cha hegwe, na hegwe kochitowa chisigino cha heye.” ");
INSERT INTO vid_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Hamba nakamlonjela mdala, “Ndokonjezela usungu wa kuponda, kwa usungu koponda wana, kowa na maya na mlume wa hegwe, ila heye kowa na ludali lwa kukulongoza.” ");
INSERT INTO vid_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Hamba nakamlonjela Adamu, “Kwa vila hegwe nakumhulichiza mdala wa hegwe, nakulya mafuza ga mgodi wondiwalajize mleche kulya, ahyo, kwa wihe wa hegwe isi ipanjilwa. Kwa kitunya kochipalila chilyo cha hegwe, mazuwa gose ga ukomu wa hegwe. ");
INSERT INTO vid_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Isi yokulelela miwa na migugu, na hegwe yokugana kulya mizuchila. ");
INSERT INTO vid_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Kwa chituguti kopala chilyo, mbaka louhiluka kuli misanga koulawile, mina hegwe kwa misanga, na kuli misanga kohiluka.” ");
INSERT INTO vid_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Adamu nakamchemela mdala wa heye itagwa, “Hawa,” kwa vila nayali mamo wa wanhu weng'ha. ");
INSERT INTO vid_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Mkulu Nguluwi nakawagongomanyila Adamu na mdala wa heye ivalo lya igozi, kawavaliza. ");
INSERT INTO vid_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Hamba Mkulu Nguluwi nakalonga, “Sambi munhu kawa kota yumwe wa hetwe, kavizela ganojile na gehile. Igana kumlemeza kulya alila ifuza lya mgodi wa ukomu, kwa vila wone yalye, kochikala mazuwa gose.” ");
INSERT INTO vid_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Lelo Mkulu Nguluwi nakamuwinga Adamu kunze mwa kamgunda ka Edeni, leka yakalime mmisanga moyalawile. ");
INSERT INTO vid_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Nakamuwinga kunze, na kuwawika wamizi wahilisi nzingo kolilawilaga isanya kuli kamgunda ka Edeni na sengo ya chiluli ilinguhinduka ako na ako, nakwamila nzila ilingulutila kuli mgodi wa ukomu. ");
INSERT INTO vid_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Adamu nakawasa na mdala wa heye, na heye nakawa na himila, nakamponda Kaini. Hawa nakalonga, “Ndimponda mwana msongolo kwa utanzi wa Mkulu Nguluwi.” ");
INSERT INTO vid_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Hamba nakamponda mkulugwe Abeli nayawele mdima ming'holo na Kaini nayali mlimi. ");
INSERT INTO vid_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Mhela udo hela, Kaini nakamlavila Mkulu Nguluwi nhambiko ya mbena ya kumgunda, ");
INSERT INTO vid_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","na heye Abeli nakamlavila Mkulu Nguluwi nhambiko ya lulelo lwa mwaluko lwa ming'holo na vihande vya mafuta. Mkulu Nguluwi nakanojezwa na Abeli na nhambiko ya heye, ");
INSERT INTO vid_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","ila nahanojezwe na Kaini na nhambiko ya heye. Lelo Kaini nakazudila ng'hatu na kumeho kwa heye nakwali kukwisimbale. ");
INSERT INTO vid_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Mkulu Nguluwi nakamlonjela Kaini, “Lekachoni kwanguzudila, na lekachoni kumeho kwa hegwe kukwisimbala? ");
INSERT INTO vid_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Ndaze, wone udite ganojile hukundigwa hebu? Na wone huditile ganojile, lelo gehile gangusunjilila hali lwizi, wangukugana kukulongoza, ila kwanguganigwa kuusumya.” ");
INSERT INTO vid_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Hamba Kaini nakamlonjela Abeli mng'holoze, “Tuche honhu kutali na mgunda.” Lelo lowali kumgunda Kaini nakamvada Abeli mng'holoze na kumkopola. ");
INSERT INTO vid_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Mkulu Nguluwi nakamuuza Kaini, “Mng'holozo Abeli kakohi?” Kaini nakamwidichila, “Heni sivizelele. Ndaze, heni nda mwamizi wa mng'holozangu?” ");
INSERT INTO vid_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Mkulu Nguluwi nakalonga, “Nakudita choni? Danda ya mng'holozo ya kota luzi lulingundilila kulawa kuli misanga. ");
INSERT INTO vid_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Lelo hegwe nakupanjilwa na kuwinjigwa mchanya mwa misanga jiwele ngubochela danda ya mng'holozo youmkopole. ");
INSERT INTO vid_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Wone ulime misanga hajikugalila kahi mbena ng'oo. Kowa munhu wa kulubaluba, yalihela honhu hatanganiche ha kikala.” ");
INSERT INTO vid_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Kaini nakamlonjela Mkulu Nguluwi, “Utaguso wa heni wowa ukulu ng'hatu, siweza kwimilila hebu. ");
INSERT INTO vid_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Ulole, lehano kumbinga kuli misanga jiwele na mboto na kutali na meho ga hegwe. Lelo ndowa munhu wa kulubaluba, yalihela honhu hatanganiche ha kikala muisi, na yoneche yombona kong'hopola.” ");
INSERT INTO vid_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Ila Mkulu Nguluwi nakamwidichila, “Hebu! Yokukopola hegwe Kaini, kohilulilwa mala saba.” Lelo Mkulu Nguluwi nakamuwika Kaini ulajilo wa kumdita munhu yoneche yomona yaleche kumkopola. ");
INSERT INTO vid_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Hamba Kaini nakoka kumwando kwa Mkulu Nguluwi, kawa yochikala kuli isi ya Nodi nzingo ya kolilawilaga isanya mwa kamgunda ka Edeni. ");
INSERT INTO vid_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Kaini nakawasa na mdala wa heye, na heye kawa na himila, nakamponda Enoki. Kaini nakazenga muji nakauchema Enoki itagwa lya mwana wa heye. ");
INSERT INTO vid_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Enoki nakawa mhaza wa Iladi, na heye Iladi nakawa mhaza wa Mehuyaeli, na Mehuyaeli nakawa mhaza wa Mesushaeli, na heye Mesushaeli nakawa mhaza wa Lameki. ");
INSERT INTO vid_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Lameki nakahola wadala weli, yumwenga nakachemigwa Ada, na yunji Sila. ");
INSERT INTO vid_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Ada nakamponda Yabali yawele mhaza wa wadimi walingikala mli mihema. ");
INSERT INTO vid_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Mng'holoze nayali Yubali, ayo nayali mhaza wa hewo wawele towa ching'weleng'wele na mluli. ");
INSERT INTO vid_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Sila na heye nakamponda Tubali-kaini, yawele mponzi wa vinhu vyeng'ha vya shaba na chuma. Lumbulye Tubali-kaini nakachemigwa Naama. ");
INSERT INTO vid_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Lameki nakawalonjela wadala wa heye, “Ada na Sila mhulichize lizi lya heni. Mhulichize gondilonga hemwe wadala wa Lameki. Heni nandimkopola munhu kwa chiwalo cha kung'wanyula, ena, nandimkopola msongolo kwa kundumiza. ");
INSERT INTO vid_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Wone Kaini kohilusilwa mala saba, ndangukomya Lameki kohilusilwa mala makumi saba na saba.” ");
INSERT INTO vid_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Adamu nakawasa kahi na Hawa mdala wa heye, na heye nakaponda mwana mlume, kamchema Seti. Yolonga, “Nguluwi kengalila mwana honhu ha Abeli yakopoligwe na Kaini.” ");
INSERT INTO vid_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Seti na heye nakamponda mwana mlume, nakamchema Enoshi. Aho ndo wanhu waluche kumlanda Mkulu kwa itagwa lya Mkulu Nguluwi. ");
INSERT INTO vid_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Ayi ndo mbuli ya lulelo lwa Adamu. Mhela Nguluwi loyamlumbile munhu, nakamlumba kwa kiwhana na heye. ");
INSERT INTO vid_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Nakawalumba mlume na mdala, hamba nakawatambichiza na kuwapa itagwa “Munhu.” ");
INSERT INTO vid_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Adamu loyali na miyaka miya imwe na makumi gadatu, nakawa na mwana msongolo yewhanile na heye, nakamchema Seti. ");
INSERT INTO vid_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Kulawila aho, Adamu nakekala miyaka miya nane, na kuwa na wana wanji walume na wadala. ");
INSERT INTO vid_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Adamu nakabagama loyawele na miyaka miya tisa na makumi gadatu. ");
INSERT INTO vid_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Mhela Seti loyawele na miyaka miya imwe na jihano, nakawa mhaza wa Enoshi. ");
INSERT INTO vid_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Loyampatile Enoshi, Seti nakekala miyaka miya nane na saba, na kuponda wana wanji walume na wadala. ");
INSERT INTO vid_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Seti nakabagama loyawele na miyaka miya tisa na kumi na mili. ");
INSERT INTO vid_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Mhela Enoshi loyali na miyaka makumi tisa, nakawa mhaza wa Kenani. ");
INSERT INTO vid_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Loyampondile Kenani, Enoshi nakekala miyaka miya nane na kumi na jihano, na kuwa wana wanji walume na wadala. ");
INSERT INTO vid_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Enoshi nakabagama loyali na miyaka miya tisa na jihano. ");
INSERT INTO vid_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Mhela Kenani loyali na miyaka makumi saba, nakampata Mahalaleli. ");
INSERT INTO vid_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Loyampondile Mahalaleli, Kenani nakekala miyaka miya nane na makumi gane, nakawa wana wanji walume na wadala. ");
INSERT INTO vid_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Kenani nakabagama loyali na miyaka miya tisa na kumi. ");
INSERT INTO vid_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Mhela Mahalaleli loyawele na miyaka makumi sita na jihano, nakawa mhaza wa Yaledi. ");
INSERT INTO vid_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Loyampondile Yaledi, Mahalaleli nakekala miyaka miya nane na makumi gadatu, nakawa wana wanji walume na wadala. ");
INSERT INTO vid_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Mahalaleli nakabagama loyawele na miyaka miya nane makumi tisa na jihano. ");
INSERT INTO vid_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Mhela Yaledi loyawele na miyaka miya imwe na makumi sita na mili, nakawa mhaza wa Enoki. ");
INSERT INTO vid_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Loyampondile Enoki, Yaledi nakekala miyaka miya nane, nakawa wana wanji walume na wadala. ");
INSERT INTO vid_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Yaledi nakabagama loyawele na miyaka miya tisa na makumi sita na mili. ");
INSERT INTO vid_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Mhela Enoki loyali na miyaka makumi sita na jihano, nakawa mhaza wa Metusela. ");
INSERT INTO vid_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Enoki na Nguluwi wali weganile. Loyampondile Metusela, Enoki nakekala miyaka miya jidatu nakawa na wana walume na wadala. ");
INSERT INTO vid_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Enoki nakekala miyaka jidatu na makumi sita na jihano. ");
INSERT INTO vid_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Enoki nayali weganile na Nguluwi, nakaheluka hela, ndo mina Nguluwi nakamhola. ");
INSERT INTO vid_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Mhela Metusela loyawele na miyaka miya imwe na makumi nane na saba, nakawa mhaza wa Lameki. ");
INSERT INTO vid_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Loyampondile Lameki, Metusela nakekala miyaka miya saba na makumi nane na mili, nakawa na wana wanji walume na wadala. ");
INSERT INTO vid_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Metusela nakabagama loyawele na miyaka miya tisa na makumi sita na tisa. ");
INSERT INTO vid_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Mhela Lameki loyawele na miyaka miya imwe na makumi nane na mili, nakampata mwana msongolo. ");
INSERT INTO vid_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Nakamchema mwana ayo Nuhu, yolonga, “Mwana ayu ndo yotuhembuliza kwa mijito jing'hang'hale yotulingukola kwa moko ga hetwe kuli isi yaipanjile Mkulu Nguluwi.” ");
INSERT INTO vid_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Loyampatile Nuhu, Lameki nakekala miyaka miya jihano na makumi tisa na jihano, nakawa na wana wanji walume na wadala. ");
INSERT INTO vid_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Lameki nakabagama loyawele na miyaka miya saba na makumi saba na saba. ");
INSERT INTO vid_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Nuhu loyafichile miyaka miya jihano, nakawa mhaza wa Shemu na Hamu na Yafeti. ");
INSERT INTO vid_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Wanhu lowaluche konjezeka muisi na kuponda wahinza, ");
INSERT INTO vid_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","wahilisi wa Nguluwi nawawona awo wahinza wa wanhu ndo wenolije ng'hatu, wawahola wala wawaganile na kuwa wadala wawo. ");
INSERT INTO vid_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Aho Mkulu Nguluwi nakalonga, “Muhe wa heni hauchikala mgati mwa munhu mazuwa gose, mina heye ndo wa kubagama hela. Lelo hochikala lukami miyaka miya imwe na makumi meli.” ");
INSERT INTO vid_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Mhela awo na kuli mazuwa ago nakwali na minhu muisi jiwele ndo lulelo lwa wahilisi wa Nguluwi na wahinza wa wanhu. Awo ndo wanhu wawele na mong'ho na lutogo aho katali, nawachemigwa Wanefili. ");
INSERT INTO vid_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Mkulu Nguluwi loyawene winji wa wihe wa wanhu muisi, na kota chila choyochijesa mnhumbula mwa heye mhela weng'ha ndo wihe yeka mhela weng'ha, ");
INSERT INTO vid_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Mkulu Nguluwi nakawa na masinzo ng'hatu kwa kumlumba munhu muisi. Mkulu Nguluwi nakejesa ng'hatu mnhumbula ya heye, ");
INSERT INTO vid_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","ahyo Mkulu Nguluwi nakalonga, “Ndomwajiliza munhu yondimlumbile muisi, ndokwajiliza migongolo na vilumbigwe vilingutambala na videje vya kilanga. Ndina masinzo ng'hatu kwa vila nandiwalumba muisi.” ");
INSERT INTO vid_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Ila Nuhu nakaganigwa na Mkulu Nguluwi. ");
INSERT INTO vid_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Ayi ndo mbuli ya Nuhu yawele yanojile yaliyeka na ndo yawele hela nongwa mhela wa heye. Nayali weganile na Nguluwi. ");
INSERT INTO vid_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Nuhu nayali na wana wadatu wasongolo, Shemu na Hamu na Yafeti. ");
INSERT INTO vid_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Nguluwi nakayona isi kota yiha ng'hatu na kumema wihe na kitowa. ");
INSERT INTO vid_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Ena, Nguluwi nakayona isi yiha ng'hatu, kwa vila chila munhu nakawinza nzila ya heye yihile. ");
INSERT INTO vid_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Nguluwi nakamlonjela Nuhu, “Nyamula kuwabagamiza wanhu weng'ha kwa vila waimemeza isi kitowa. Ena, ndowabagamiza ng'hatu hamwe na isi. ");
INSERT INTO vid_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Lelo widitile safina kwa mbao zinojile za mgofu. Ugawanule vihengo mgati na ubakalize lusila kwa mgati na kunze. ");
INSERT INTO vid_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Koidita iwe kota hino, utali wa mita miya imwe na makumi gadatu na zidatu na ugazi wa mita makumi meli na mbili na mita kumi na zidatu kuluta kuchanya. ");
INSERT INTO vid_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Safina ayo iwe na vinduwiko vidatu. Hagati mwa safina ayo kuwe na chiswiswili cha fudi sentimita makumi gane na zine kwa nzingo za hafungo mwa chinduwiko acho na lwizi hafungo. ");
INSERT INTO vid_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Ndochigala nhonya yobohoka na kubagamiza vinhu vyeng'ha viwele vikomu muisi. Chila chilumbigwe chiwele na muhe muisi chobagama. ");
INSERT INTO vid_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Ila ndowika ilagano na hegwe. Kokwinjila mli safina, hegwe hamwe na mdala wa hegwe na wanago na wadala wawo. ");
INSERT INTO vid_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Nagwe kokwinjiza mli safina chila chilumbigwe vili chilume na chidala, leka viwe vikomu hamwe na hegwe. ");
INSERT INTO vid_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","“Wokuya kwa hegwe chila nhanzi ya videje vya kilanga, chila igongolo na chila nhanzi ya chilumbigwe chilingutambala, vili vili, leka kuviwika viwe vikomu. ");
INSERT INTO vid_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Kahi uhole vilyo vyeng'ha vilinguligwa, uwiche kwa mbuli ya chilyo cha hemwe na vilumbigwe avyo.” ");
INSERT INTO vid_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Nuhu nakadita geng'ha kota Nguluwi vyoyalajize. ");
INSERT INTO vid_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Mkulu Nguluwi nakamlonjela Nuhu, “Winjile mgati mwa safina hegwe hamwe na ivyazi lyako lyeng'ha, mina kwa wanhu weng'ha walingikala mhela awu wa hegwe, ndikona hegwe uliyeka utanganiche heni. ");
INSERT INTO vid_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Uhole hamwe na hegwe migongolo jeng'ha johajikokomoche na jikokomoche, ilume na idala, saba saba, ila migongolo johambe jiliche, uhole mili ilume na idala. ");
INSERT INTO vid_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Vivila uhole videje vya kilanga chilume na chidala, saba saba, leka kuzileka nhanzi zawo ziwe na ukomu muisi. ");
INSERT INTO vid_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Logopuluta mazuwa saba, ndowatowela nhonya mazuwa makumi gane nemisi na nechilo, na chila chilumbigwe ndichilumbile muisi chobagama.” ");
INSERT INTO vid_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Nuhu nakadita geng'ha kota Mkulu Nguluwi vyoyalajize. ");
INSERT INTO vid_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Nuhu nayali na miyaka miya sita mhela nhonya loitowile na mazi kumema muisi. ");
INSERT INTO vid_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Nuhu na mdala wa heye na wanage na wadala wawo nawenjila mgati mwa safina leka kuibilima nhonya imemeze mazi. ");
INSERT INTO vid_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Migongolo jilingulika na migongolo hajilingulika na videje na vilumbigwe vyeng'ha vilingutambala, ");
INSERT INTO vid_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","vili vili, idala na ilume, navinjila mgati mwa safina hamwe na Nuhu kota Nguluwi vyoyalajize. ");
INSERT INTO vid_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Logapulute mazuwa saba, mazi ga nhonya nagaluka kuigubika isi. ");
INSERT INTO vid_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Nuhu loyawele na miyaka miya sita, logali mazuwa ga kumi na saba ga mwezi wa keli, zuwa alyo nzasa zeng'ha za mazi gawele nyang'ha za hasi nazilavya mazi, na mazi kulawa kilanga nagabohoka. ");
INSERT INTO vid_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Nhonya naitowa hasi mazuwa makumi gane nemisi na nechilo. ");
INSERT INTO vid_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Zuwa lilyo nhonya loyaluche kutowa, Nuhu na mdala wa heye na wanage, Shemu na Hamu na Yafeti, hamwe na wadala wawo, nawenjila mgati mwa safina. ");
INSERT INTO vid_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Nawenjila hewo weng'ha hamwe na migongolo ja kisolo nhanzi zeng'ha na nhanzi zeng'ha za migongolo ja haluga na nhanzi zeng'ha za migongolo jilingutambala na videje chila nhanzi na nhanzi zeng'ha za vilumbigwe viwele na mabawa. ");
INSERT INTO vid_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Vili vili vya chila nhanzi ya vilumbigwe vikomu navinjila mgati mwa safina hamwe na Nuhu. ");
INSERT INTO vid_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Chila nhanzi nawenjila ilume na idala kota Nguluwi vyoyamlajize Nuhu. Hamba Mkulu Nguluwi nakahinda lwizi lwa safina kumbele kwa Nuhu. ");
INSERT INTO vid_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Nhonya naitowa mazuwa makumi gane. Mazi nagonjezeka na kwinula safina, nayelela mchanya mwa isi. ");
INSERT INTO vid_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Mazi nagalutilila konjezeka muisi na safina nayelela mchanya mwake. ");
INSERT INTO vid_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Mazi ago gawa menji ng'hatu mchanya muisi, gavigubika vidunda vyeng'ha viling'wemang'wema muisi. ");
INSERT INTO vid_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Nagamema mbaka kuvigubika vidunda chasi cha fudi kumi na zihano. ");
INSERT INTO vid_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Vilumbigwe vyeng'ha navibagama, videje na migongolo ja kudimigwa na migongolo ja kisolo na vilumbigwe vyeng'ha muisi vilingujenda mchilundo na wanhu weng'ha, ");
INSERT INTO vid_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","ena, chila chilumbigwe chiwele na muhe muisi nachibagama. ");
INSERT INTO vid_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Nguluwi nakachibagamiza chila chilumbigwe muisi, wanhu na migongolo na vilumbigwe vilingutambala na videje vya kilanga. Vyeng'ha navibagamizwa muisi. Nuhu yaliyeka ndo nayaponile hamwe na wala nawawele mgati mwa safina. ");
INSERT INTO vid_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Mazi ago nagekala muisi kwa mazuwa miya imwe na makumi gahano. ");
INSERT INTO vid_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Hamba Nguluwi nakamkumbuka Nuhu na migongolo jeng'ha ja kisolo na jifujigwe haluga jiwele hamwe na heye mgati mwa safina. Lelo Nguluwi nakegala mbeho mchanya mwa isi, mazi nagaluka kuswina. ");
INSERT INTO vid_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Nzasa za mazi gawele nyang'ha na mazi kulawa kilanga nagadinyigwa. Nhonya naidinyigwa, ");
INSERT INTO vid_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","mazi nagalutilila kuswina mhole mhole muisi. Mazuwa miya na makumi gahano logakolile, mazi nagaswina lukami. ");
INSERT INTO vid_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Zuwa lya kumi na saba, mwezi wa saba, safina naima mchanya mwa vidunda vya Alalati. ");
INSERT INTO vid_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Mazi nagalutilila kuswina mhole mhole, na zuwa ya mwaluko ya mwezi wa kumi, vinhembenhembe vya vidunda navyaluka koneka. ");
INSERT INTO vid_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Mazuwa makumi gane logakwete, Nuhu nakachumula itubuli lyoyawichile kuli yila safina, ");
INSERT INTO vid_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","nakalilavya ibondwa kunze, ila naliguluka aku na kula mbaka mazi logakalile muisi. ");
INSERT INTO vid_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Hamba Nuhu nakailavya ng'hunda leka ilole kota mazi gaswina mchanya mwa isi. ");
INSERT INTO vid_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Ila kwa vila mazi nagang'hali gagubiche isi yeng'ha, ayo ng'hunda haiwene honhu ha kudulika, naihiluka kwa Nuhu kuli safina. Nuhu nakagolola moko, kaibata na kuihilusa mgati mwa safina. ");
INSERT INTO vid_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Nuhu nakabeteza mazuwa ganji saba, hamba nakailavya kahi ayo ng'hunda kunze mwa safina. ");
INSERT INTO vid_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Ng'hunda ayo naimhiluchila Nuhu matinazo iwele na iputi lidodi lya mzeituni mumlomo mwake. Kwa chiwalo acho Nuhu nakavizela kota mazi gali gaswinile muisi. ");
INSERT INTO vid_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Hamba nakabeteza mazuwa ganji saba, nakailavya kahi ayila ng'hunda zuwa ali, ng'hunda nahaihiluche ng'oo. ");
INSERT INTO vid_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Nuhu loyawele na miyaka miya sita na umwe, zuwa lya mwaluko mwezi wa mwaluko, mazi nagakala muisi. Nuhu nakagubula chigubiko cha safina na loyalolile, nakona kota isi naikala. ");
INSERT INTO vid_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Zuwa lya makumi meli na saba ga mwezi wa keli, isi naikala ng'hatu. ");
INSERT INTO vid_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Aho Nguluwi nakamlonjela Nuhu, ");
INSERT INTO vid_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“Ulawe kuli safina, hegwe hamwe na mdala wa hegwe na wanago na wadala wawo. ");
INSERT INTO vid_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Ulavye kahi vilumbigwe vyeng'ha viwele na muhe vya chila nhanzi viwele hamwe na hegwe, videje na migongolo na chila chilumbigwe chilingutambala, vikalele kwa winji muisi, wonjezeche na kwenela honhu heng'ha muisi.” ");
INSERT INTO vid_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Lelo Nuhu nakalawa kuli safina hamwe na wanage na mdala wa heye hamwe na wadala wa wanage. ");
INSERT INTO vid_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Migongolo jeng'ha na vilumbigwe vyeng'ha vilingutambala na videje vyeng'ha, nawalawa kuli safina kwa nhanzi zawo. ");
INSERT INTO vid_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Nuhu nakamzenjela Mkulu Nguluwi honhu ha kulavila nhambiko, nakahola yumwe kwa chila nhanzi ya migongolo johajikokomoche na chideje chohachikokomoche, nakumlavila Nguluwi nhambiko za kulakazwa hala. ");
INSERT INTO vid_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Kunhunyhilila goya kwa nhambiko ayo na kumnojeza Mkulu Nguluwi, na heye nakalonga mnhumbula mwake, “Siwila kahi kuipanjila isi kwa mbuli ya wanhu, ndivizela kota majesa ga heye ndo wihe kulawila udodo. Na sivibagamiza kahi vilumbigwe vyeng'ha kota vyonditile. ");
INSERT INTO vid_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","“Kota vyoichikala isi, mihela ja kunyala na mbena, na ja mbeho na ivuche, na luhela na chipalangule, na nechilo na nemisi, hagomala.” ");
INSERT INTO vid_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Nguluwi nakamtambichiza Nuhu na wanage, yowalonjela, “Mkalele, mwonjezeche, mkaimemeze isi yeng'ha. ");
INSERT INTO vid_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Migongolo jeng'ha na videje vyeng'ha vya kilanga na vilumbigwe vyeng'ha vilingutambala muisi na somba zeng'ha za kuli bahali zowa na woga na zowadumba hemwe. Weng'ha wawichigwa hali ludali lwa hemwe. ");
INSERT INTO vid_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Migongolo jeng'ha jiwele na muhe jowa ndiya ya hemwe, ndanguwapani kota vila londiwapele mizuchila jititime ja nyhule za ndiya ya hemwe. ");
INSERT INTO vid_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Ila mleche kulya miwunde jiwele na danda, kwa vila ukomu wamumo mli danda. ");
INSERT INTO vid_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Danda ya ukomu wa hemwe ndoitagusa, kwa chila igongolo na wanhu. Yomkopola miyage, ndoutagusa ukomu wa heye. ");
INSERT INTO vid_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","“Yalingubohola danda ya munhu, danda ya heye yoboholigwa na munhu, mina kwa kiwhana na Nguluwi, munhu nakalumbigwa. ");
INSERT INTO vid_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Namwe mponde na mkonjezeche, mponde kwa winji, mkonjezeche muisi.” ");
INSERT INTO vid_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Hamba Nguluwi nakamlonjela Nuhu na mwanage, ");
INSERT INTO vid_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“Ndanguwika ilagano lyangu namwe na lulelo lwenu, ");
INSERT INTO vid_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","na vilumbigwe vyeng'ha viwele vikomu na videje na migongolo ja kudima haluga na ja kisolo, weng'ha walawile mli safina hamwe na hemwe. ");
INSERT INTO vid_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Ndangwaluchiza ilagano lyangu na hemwe, kuta vilumbigwe vyeng'ha vikomu havibagamizwa ng'oo kwa nhonya, na hailawila kahi nhonya kota ila ya kuiwifya isi.” ");
INSERT INTO vid_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Kahi Nguluwi nakalonga, “Achi ndo chilajilo cha ilagano londidita kwa heni na hemwe na chila chilumbigwe chikomu chiwele hamwe na hemwe kwa lulelo lweng'ha lulinguya, ");
INSERT INTO vid_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","ndanguwika upinde wa heni kuli ng'hungugu kilanga. Nawo wowa ulajilo wa ilagano lya heni na isi. ");
INSERT INTO vid_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Hala hondiigubika isi kwa ng'hungugu, na awo upinde wa nhonya howokoneka kuli ng'hungugu, ");
INSERT INTO vid_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","ndokumbuchila ilagano lyangu na hemwe na vilumbigwe vyeng'ha viwele vikomu. Mazi hagomema ng'oo na kuvibagamiza vilumbigwe vyeng'ha viwele vikomu. ");
INSERT INTO vid_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Awo upinde houlawila kung'ungugu, ndowona na kukumbuchila ilagano alyo lya mazuwa gose kwa heni na vilumbigwe vyeng'ha viwele vikomu muisi.” ");
INSERT INTO vid_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Nguluwi nakamlonjela Nuhu, “Awu ulajilo wa ilagano lonyhaluchize na vilumbigwe vyeng'ha viwele vikomu muisi.” ");
INSERT INTO vid_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Wana wa Nuhu walawile mli safina nawali Shemu na Hamu na Yafeti. Hamu nayali mhaza wa Kanaani. ");
INSERT INTO vid_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Awo ndo wana wadatu wa Nuhu, na kulawa kwa hewo wanhu nawenela isi yeng'ha. ");
INSERT INTO vid_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Nuhu yawele mlimi, nayali yaluche kuwa mlimi wa mgunda wa zabibu. ");
INSERT INTO vid_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Nakanwa divai kulawa kuli zabibu zoyalimile, nakagala, hamba nakawasa mwazi mli chibumuli cha heye. ");
INSERT INTO vid_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Hamu, mhaza wa Kanaani, nakawona umwazi wa mhaza wa heye, nakalawa kunze na kuwalonjela wang'holoze weli. ");
INSERT INTO vid_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Ila Shemu na Yafeti nawahola nguwo, watandazula mmayega mwawo, nawaluta chimbelembele na kuugubika umwazi wa mhaza wa hewo. Nawalola kufungo, nahawauwene umwazi wa mhaza wa hewo. ");
INSERT INTO vid_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Nuhu loyalilimche na kuvizela choyaditilwe na mwanage mdodo, ");
INSERT INTO vid_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","nakalonga, “Kanaani yapanjilwe! Kowa chitumagwa wa vitumagwa kwa wang'holoze.” ");
INSERT INTO vid_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Kahi nakalonga, “Shemu nayatambichizwe na Mkulu Nguluwi, Nguluwi wa Shemu, Kanaani nayawe chitumagwa wa heye. ");
INSERT INTO vid_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Nguluwi nayamtambichize Yafeti, yekale kuli chibumuli cha Shemu, Kanaani nayawe mpogozi wa heye.” ");
INSERT INTO vid_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Loimalile nhonya ya mazi tendema, Nuhu nakekala miyaka miya zidatu na makumi gahano, ");
INSERT INTO vid_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","hamba Nuhu nakabagama loyawele na miyaka miya tisa na makumi gahano. ");
INSERT INTO vid_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Ayi ndo mbuli ya lulelo lwa Nuhu, Shemu na Hamu na Yafeti. Awa wadatu nawali na wana loimalile nhonya ya mazi tendema. ");
INSERT INTO vid_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Wana walume wa Yafeti nawali Gomeli na Magogu na Madai na Yavani na Tubali na Mesheki na Tilasi. ");
INSERT INTO vid_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Wana wa Gomeli nawali Ashikenasi na Lifazi na Togoma. ");
INSERT INTO vid_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Wana wa Yavani nawali Elisha na Talishishi na Kitimu na Dodanimu. ");
INSERT INTO vid_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Awa ndo wanhu wa mwaluko ng'hatu wenele honhu ha mwhani, chila wanhu kwa isi za hewo na kwa ulonzi wawo na kwa lukolo lwawo na kwa nhanzi za hewo. ");
INSERT INTO vid_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Wana wa Hamu nawali Kushi na Misili na Puti na Kanaani. ");
INSERT INTO vid_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Wana walume wa Kushi nawali Seba na Havila na Sabuta na Lahama na Sabuteka. Wana walume wa Lahama nawali Sheba na Dedani. ");
INSERT INTO vid_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Kushi nayali mhaza wa Nimulodi yawele na mong'ho wa mwaluko muisi yeng'ha. ");
INSERT INTO vid_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Nayali mpelembi yawele na mong'ho hamwando ha Mkulu Nguluwi, ndo mina kwali na ulonzi ulingulonga, “Nayakudite uwe kota Nimulodi mpelembi yawele na mong'ho hamwando ha Mkulu Nguluwi.” ");
INSERT INTO vid_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Miji ja mwaluko ja undewa wa heye, najali Babiloni na Eleki na Akadi na Kalinehi, kuli isi ya Shinali. ");
INSERT INTO vid_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Kulawila ako, Nimulodi nakaluta Ashulu, nakazenga miji ja Ninawi na Lehoboti-ili na Kala na ");
INSERT INTO vid_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","Leseni uwele hagati ha Ninawi na muji ukulu wa Kala. ");
INSERT INTO vid_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Misili nayali sekulu wa Waludi na Waanamu na Walehabi na Wanafutuhi ");
INSERT INTO vid_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","na Wapatilusi na Wakasiluhimu, wawele mwaluko wa Wafilisti na Wakafutoli. ");
INSERT INTO vid_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Kanaani nayali sekulu wa Sidoni, mlelwa wa heye wa mwaluko, na Heti ");
INSERT INTO vid_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","na kahi sekulu wa hewo Wayebusi na Waamoli na Wagiligashi ");
INSERT INTO vid_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","na Wahivi na Waaliki na Waasini ");
INSERT INTO vid_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","na Waaluvadi na Wasemali na Wahamati. Hamba wanhu wa nhanzi zinjizinji za Kanaani nawasambaluka, ");
INSERT INTO vid_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","ahyo na honhu ha isi ya hewo nayali kulawila Sidoni kulutila kusini mbaka Gelali mbaka Gasa, na kulutila kolilawilaga isanya mbaka Sodoma na Gomola na Adima na Seboimu mbaka Lasha. ");
INSERT INTO vid_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Awo ndo walelwa wa Hamu kota lukolo lwa hewo na ulonzi wa hewo na isi za hewo na wanhu wa isi za hewo. ");
INSERT INTO vid_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Shemu, mkulugwe Yafeti, nayali mwana wa Ebeli. ");
INSERT INTO vid_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Wana wa Shemu nawali Elamu na Ashulu na Alufakisadi na Ludi na Alamu. ");
INSERT INTO vid_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Wana walume wa Alamu nawali Usi na Huli na Gaseli na Mashi. ");
INSERT INTO vid_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Alufakisadi nakampata Shela, Shela nakampata Ebeli. ");
INSERT INTO vid_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Ebeli nayali na wana weli, wa mwaluko nakamchema Pelegi kwa vila mhela awo wanhu wa isi nawasambaluka, na wa keli nakamchema Yokitani. ");
INSERT INTO vid_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Yokitani nayali mhaza wa Alimodadi na Shelefu na Hasalimaweti na Yela ");
INSERT INTO vid_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","na Hadolamu na Usali na Dikila ");
INSERT INTO vid_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","na Obali na Abimaeli na Sheba ");
INSERT INTO vid_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","na Ofili na Havila na Yobabu. Awo weng'ha nawali wana wa Yokitani. ");
INSERT INTO vid_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Isi nawekale nayenela kulawila Mesha kwa nzila ya Sefali kuli isi ya vidunda mwa kolilawilaga isanya. ");
INSERT INTO vid_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Awo ndo walelwa wa Shemu na wanhu wa isi za hewo na ulonzi wa hewo na kuli isi za hewo na undewa wa hewo. ");
INSERT INTO vid_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Ayi ndo mbuli ya lukolo lwa wana wa Nuhu, kwa ivyazi lya hewo na ulonzi wa hewo. Kulawa kwa wanhu awo nawenela kuli nhanzi zeng'ha loimalile nhonya ya mazi tendema. ");
INSERT INTO vid_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Mwaluko wanhu weng'ha muisi nawali na ulonzi umwe, nawali wolonga luzi lulula. ");
INSERT INTO vid_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Lelo naiwa wanhu lowenule majendo kulawila kolilawilaga isanya, nawafika kuli isi ya chiwala ako Shinali, nawekala. ");
INSERT INTO vid_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Hamba nawelonjelela, “Lelo, natudite matufali, tugasome goya na chiluli.” Nawali na matufali honhu ha maganga na lami honhu ha ilongo. ");
INSERT INTO vid_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Nawalonga, “Twizenjele muji na ilingo chinduwiko chake chofika mbaka kilanga leka tupegwe itagwa na kutogoligwa, tuleche kusambaluka isi yeng'ha.” ");
INSERT INTO vid_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Ndo baho Mkulu Nguluwi nakedulika hasi kulola honhu hao na ilingo lowazenjile wanhu wa isi. ");
INSERT INTO vid_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Mkulu Nguluwi nakalonga, “Mlole wanhu wano wa isi imwe na weng'ha wana ulonzi umwe, awu ndo mwaluko hela wa gala gowodita. Lyoneche lowogana kudita, woweza kudita. ");
INSERT INTO vid_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Lelo natwiduliche hasi na kuubananga ulonzi wa hewo, leka walemwele kuvizela chowolonga hewo kwa hewo.” ");
INSERT INTO vid_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Ahyo, Mkulu Nguluwi nakawasambalula honhu heng'ha muisi, na hewo nawaleka kuuzenga ula muji. ");
INSERT INTO vid_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Muji awo nauchemigwa Babeli, kwa vila ako ndo Mkulu Nguluwi koyatigule ulonzi wa hewo wa isi yeng'ha na kulawa ako nakawasambalula wanhu chila honhu muisi. ");
INSERT INTO vid_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Ayi ndo mbuli ya lulelo lwa Shemu. Miyaka mili kulawa ila nhonya ya mazi tendema, Shemu naloyali na miyaka miya imwe, nakamponda Alufakisadi. ");
INSERT INTO vid_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Loyampondile Alufakisadi, Shemu nakekala miyaka miya jihano, na kuponda wana wanji walume na wadala. ");
INSERT INTO vid_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Alufakisadi naloyawele na miyaka makumi gadatu na jihano, nakamponda Shela. ");
INSERT INTO vid_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Loyampondile Shela, Alufakisadi nakekala miyaka miya zine na zidatu, na kuponda wana wanji walume na wadala. ");
INSERT INTO vid_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Shela naloyawele na miyaka makumi gadatu, nakamponda Ebeli. ");
INSERT INTO vid_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Loyampondile Ebeli, Shela nakekala miyaka miya zine na zidatu, na kuponda wana wanji walume na wadala. ");
INSERT INTO vid_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Ebeli naloyawele na miyaka makumi gadatu na gane, nakamponda Pelegi. ");
INSERT INTO vid_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Loyampondile Pelegi, Ebeli nakekala miyaka miya zine na makumi gadatu, na kuponda wana wanji walume na wadala. ");
INSERT INTO vid_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Pelegi naloyawele na miyaka makumi gadatu, nakamponda Leu. ");
INSERT INTO vid_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Naloyampondile Leu, Pelegi nakekala miyaka miya mbili na tisa, na kuponda wana wanji walume na wadala. ");
INSERT INTO vid_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Leu naloyawele na miyaka makumi gadatu na meli, nakamponda Selugi. ");
INSERT INTO vid_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Naloyampondile Selugi, Leu nakekala miyaka miya mbili na saba, na kuponda wana wanji walume na wadala. ");
INSERT INTO vid_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Selugi naloyawele na miyaka makumi gadatu, nakamponda Naholi. ");
INSERT INTO vid_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Naloyampondile Naholi, Selugi nakekala miyaka miya mbili na kuponda wana wanji walume na wadala. ");
INSERT INTO vid_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Naholi naloyawele na miyaka makumi meli na tisa, nakamponda Tela. ");
INSERT INTO vid_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Naloyampondile Tela, Naholi nakekala miyaka miya imwe na kumi na tisa, na kuponda wana wanji walume na wadala. ");
INSERT INTO vid_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Tela naloyawele na miyaka makumi saba, nakamponda Abulamu na Naholi na Halani. ");
INSERT INTO vid_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Ayi ndo mbuli ya lulelo lwa Tela, mhaza wa hewo Abulamu, Naholi na Halani. Halani nayali mhaza wa Loti. ");
INSERT INTO vid_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Ayo Halani nakabagama hali mhaza wa heye Tela, loyali yochikala ako Chalideya nakoyapondigwe Uli. ");
INSERT INTO vid_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Abulamu na Naholi nawahesa. Mdala wa Abulamu nakachemigwa Salai. Mdala wa Naholi nakachemigwa Milika, mhinza wa Halani nayawele kahi mhaza wa Isika. ");
INSERT INTO vid_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Salai nahapondile mwana kwa vila nayali mhende. ");
INSERT INTO vid_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Tela nakamhola Abulamu mwanage na Loti mzukulu wa heye, nayawele mwana wa Halani, na Salai mchewake Abulamu, nawoka weng'ha hamwe kulawa Uli, muji wa Wakalidayo, kuluta kuli isi ya Kanaani. Ila lowafichile Halani, nawekala. ");
INSERT INTO vid_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Tela nakabagama ako Halani naloyawele na miyaka miya mbili na jihano. ");
INSERT INTO vid_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Lelo Mkulu Nguluwi nakamlonjela Abulamu, “Uche kuli isi ya hegwe, uwaleche wang'holozo na ng'handa ya mhaza wa hegwe, ulute kuli isi yondikulajila. ");
INSERT INTO vid_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","“Ndokudita hegwe uwe nhanzi iwele na ukulu, ndokutambichiza na kulikwiniza itagwa lyako, leka nagwe uwe utambichizo kwa wanji. ");
INSERT INTO vid_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Yokutambichiza, ndomtambichiza, yokupanjila, ndompanjila. Kwa kukolela hegwe, ndozitambichiza nhanzi za isi zeng'ha.” ");
INSERT INTO vid_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Lelo Abulamu nakoka kota Mkulu Nguluwi vyonayamlajize, na Loti nakaluta hamwe na heye. Abulamu nayali na miyaka makumi saba na jihano loyalawile Halani. ");
INSERT INTO vid_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Abulamu nakamhola mdala wa heye Salai, na Loti mwana wa mng'holoze, hamwe na lufufu lwao lweng'ha na wanhu weng'ha nawawaholile ako Halani, nawoka kuluta isi ya Kanaani. Nalowenjile isi ya Kanaani, ");
INSERT INTO vid_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Abulamu nakakola hagati ha isi mbaka Shekemu, honhu Helile hawele na igodi likulu lya Mole. Mhela awo, Wakanaani nawali ndo wenyeng'haye wa isi ayo. ");
INSERT INTO vid_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Ndo Mkulu Nguluwi nakamlawila Abulamu, nakamlonjela, “Lulelo lwako ndowapa isi ayi.” Lelo Abulamu nakazenga honhu ha kulavila nhambiko kwa mbuli ya Mkulu Nguluwi yamlawile. ");
INSERT INTO vid_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Hamba Abulamu nakoka, nakalutila kuli isi ya vidunda kolilawilaga isanya mwa Beteli, nakazenga chibumuli hagati mwa muji wa Beteli nzingo ya kolizinjilaga isanya, na muji wa Ayi nzingo ya kolilawilaga isanya. Aho kahi nakamzenjela Mkulu Nguluwi honhu ha kulavila nhambiko na kumlanda kwa itagwa lyake. ");
INSERT INTO vid_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Hamba Abulamu nakalutilila na majendo ubanzi wa Negebu. ");
INSERT INTO vid_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Mhela awo, nzala nailawila muisi. Nayali nzala ya maduga, ahyo Abulamu naimgana kuluta Misili na kikala ako kwa mhela uchefu. ");
INSERT INTO vid_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Loyawele behi na Misili, Abulamu nakamlonjela Salai mchewake, “Ndivizela kota hegwe kwa mdala ulinguwakwega wanhu kwa vila kunoga lukami. ");
INSERT INTO vid_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Wamisili lowokona wolonga, ‘Ayu ndo mchewake,’ hamba wong'hopola ila hegwe wokuleka mkomu. ");
INSERT INTO vid_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Lelo walonjele kota hegwe kwa lumbu wa heni leka mbuli zindutile goya, wandeche ndiwe mkomu kwa mbuli ya hegwe.” ");
INSERT INTO vid_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Lelo Abulamu loyafichile muisi ya Misili, wenyeng'haye wa ako nawamona Salai kota ndo mdala yanojile lukami. ");
INSERT INTO vid_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Wakulu wa chitala wa Falao lowamuwene Salai, nawamtogola kwa Falao. Lelo Salai nakahilikwa haluga ha Falao. ");
INSERT INTO vid_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Lelo, kwa mbuli ya heye, Falao nakamuwika Abulamu, nakabochela ming'holo na misenga na idogowi ilume na vitumagwa walume na wadala na idogowi idala na ngamiya. ");
INSERT INTO vid_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Ila Mkulu Nguluwi nakamgaza Falao na wanhu weng'ha wawele mng'handa ya heye kwa kuwadita wawe na matamwa makulu kwa mbuli ya Salai, mchewake Abulamu. ");
INSERT INTO vid_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Falao nakamchema Abulamu, nakamuuza, “Ndo chinhu chachi achi chounditile? Lekachoni nahundonjele kota Salai ka mchewako? ");
INSERT INTO vid_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Lekachoni nakulonga ka lumbu wa hegwe mbaka nandimhola yawe mchewangu? Lelo mchewako ndo ayo, umhole ulute.” ");
INSERT INTO vid_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Hamba Falao nakawalajiza wanhu wa heye, na hewo wamleche Abulamu yalute mnzila yawele na mchewake na lufufu lwake lweng'ha. ");
INSERT INTO vid_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Abulamu nakahiluka kulawila Misili, nakenjila nzingo ya Negebu nayali na mchewake na lufufu lwa heye lweng'ha hamwe na Loti. ");
INSERT INTO vid_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Mhela awo, Abulamu nayali na lufufu ng'hatu. Nayali na migongolo minji na sendi na zahabu. ");
INSERT INTO vid_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Nakalutilila na majendo kulawila honhu ha Negebu mbaka Beteli. Nakafika honhu naloyali yawichile kambi ya chibumuli aho mwaluko, hagati ha Beteli na Ayi, ");
INSERT INTO vid_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","na nayali yazenjile honhu ha kulavila nhambiko. Aho Abulamu nakamlanda Mkulu Nguluwi kwa itagwa lyake. ");
INSERT INTO vid_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Kahi, Loti nayawele yelongoze na Abulamu, nayali na ming'holo na misenga na mihema. ");
INSERT INTO vid_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Nawali na migongolo minji lukami, mbaka isi ila nailemwela kuwahega Abulamu na Loti kikala hamwe. ");
INSERT INTO vid_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Lelo nakulawila kilewa kwa wadimi wa Abulamu na wadimi wa Loti. Mhela awo, Wakanaani na Wapelisi ndo nawali wochikala mli isi ayo. ");
INSERT INTO vid_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Lelo Abulamu nakamlonjela Loti, “Kowa hela nongwa hali hetwe na kuleche kulawila kilewa kwa wadimi wa hegwe na wadimi wa heni, kwa vila hetwe twa ivyazi limwe. ");
INSERT INTO vid_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Ulole isi ayi yeng'ha kumwando kwa hegwe. Na tibagule. Wone ulute kumoso, heni ndoluta kudilo, houluta kudilo, heni ndoluta kumoso.” ");
INSERT INTO vid_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Loti nakenula meho ga heye, nakalyona ibindi lya lwanda lwa Yolodani, nakalyona kuta lina mazi ga kuhega chila honhu, kota kamgunda ka Mkulu Nguluwi na kota isi ya Misili nzingo ya Soali. Ayi nayali Mkulu Nguluwi naloyawele yang'hali kuibagamiza miji ja Sodoma na Gomola. ");
INSERT INTO vid_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Lelo Loti nakehagulila ibindi lya lwanda lwa Yolodani, nakalutilila kolilawilaga isanya, na hino ndo nawebagule. ");
INSERT INTO vid_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Abulamu nakapona muisi ya Kanaani na Loti nakekala hagati ha miji jiwele mibindi, nakaluta kikala behi na Sodoma. ");
INSERT INTO vid_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Wanhu wa Sodoma nawali wehile na wadita gehile wakulu kwa Mkulu Nguluwi. ");
INSERT INTO vid_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Loti loyebagule na Abulamu, Mkulu Nguluwi nakamlonjela Abulamu, “Winule meho ga hegwe kulawila aho houli ulole nzingo zeng'ha, kasikazini na kusini na kolilawilaga isanya na kolizinjilaga isanya. ");
INSERT INTO vid_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Isi ayi yeng'ha youlinguyona ndokupa hegwe na walelwa wa hegwe iwe ya hemwe mazuwa gose. ");
INSERT INTO vid_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Walelwa wa hegwe ndowadita wawe wenji kota vila sangalaza za isi hazilinguwazigwa na walelwa wa hegwe hawoweza kuwazigwa. ");
INSERT INTO vid_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Lelo winuche uijendele isi ayi kwa ugazi na utali, kwa vila ndokupa hegwe.” ");
INSERT INTO vid_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Baho, Abulamu nakang'umbula ihema, nakaluta kikala habehi na igodi likulu lya Mamle kula Hebuloni, ako nakamzenjela Mkulu Nguluwi honhu ha kulavila nhambiko. ");
INSERT INTO vid_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Mhela awo, mndewa Amlafeli wa Shinali na mndewa Alioko wa Elasali na mndewa Kedolilaomeli wa Elamu na mndewa Tidali wa Goiimu, ");
INSERT INTO vid_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","nawetowa ngondo na Bela mndewa wa Sodoma na Bilisha mndewa wa Gomola na Shinabu mndewa wa Adima na Shemebeli mndewa wa Seboimu na mndewa wa Bela itagwa linji Soali. ");
INSERT INTO vid_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Wandewa awo wahano nawawakungajiza hamwe wamizi wa hewo kuli ibindi lya Sidimu, liwele ndo Bahali ya Mwino. ");
INSERT INTO vid_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Mhela wa miyaka kumi na mili nawali womhulichiza mndewa Kedolilaomeli, ila louwele mwaka wa kumi na midatu, nawamhinduka. ");
INSERT INTO vid_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Loufichile mwaka wa kumi na jine, mndewa Kedolilaomeli na wala wandewa wayage nawoya kuwatowa wanhu wa Lefaimu ako Ashitaloti-kalinaimu na Wasusimu ako Hamu na Waemi ako Shawe-kiliataimu ");
INSERT INTO vid_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","na Waholi ako kuli isi ya vidunda vya Seili, nawawawinga mbaka Elipalani, mu mbaka mwa kuchiwala. ");
INSERT INTO vid_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Hamba nawahiluka kumbele mbaka Enimishipati, ilinguchemigwa Kadeshi, na nawaitowa isi yeng'ha ya Waamaleki na kuwasumya Waamoli nawekale Hasasoni-tamali. ");
INSERT INTO vid_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Ndo mndewa wa Sodoma na mndewa wa Gomola na mndewa wa Adima na mndewa wa Seboimu na mndewa wa Bela, itagwa linji Soali, nawenjila kuli ngondo kuli ibindi lya Sidimu kitowa ");
INSERT INTO vid_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","na Kedolilaomeli mndewa wa Elamu na Tidali mndewa wa Goiimu na Amlafeli mndewa wa Shinali na Alioko mndewa wa Elasali, wandewa wane wochitowa na wandewa wahano. ");
INSERT INTO vid_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Ibindi lya Sidimu nalyali limemile minila ja lami, lelo wandewa wa Sodoma na Gomola nalowawele woibilima ngondo, nawatumbuchila mumo, ila wanji nawabilimila kuli isi ya vidunda. ");
INSERT INTO vid_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Lelo wala wasumile, nawahola lufufu lweng'ha lwa Sodoma na Gomola na vilyo vyeng'ha na kuka. ");
INSERT INTO vid_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Nawamibata Loti, mwana wa mng'holoze Abulamu nayawele yochikala Sodoma, hamwe na lufufu lwake, na kuka. ");
INSERT INTO vid_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Munhu yumwe yesukule na kubilima, nakaluta kumlonjela yula Muebulaniya Abulamu nayawele yochikala behi na miyaloni ya Mwamoli Mamle. Mamle nayali mng'holoze Eshikoli na Aneli. Weng'ha nawali wawichile ilagano na Abulamu. ");
INSERT INTO vid_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Abulamu loyahuliche kota mpwage kaholigwa kuli upogozi, nakawachema hamwe wamizi wa heye walanguswe kitowa ngondo na wazidahe miya zidatu na kumi na nane nawapondigwe mng'handa mwake, na kuwawinza wala wang'honyo mbaka Dani. ");
INSERT INTO vid_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Ako nakawagawanula wamizi kuli vilundo. Nechilo nakawatowa wang'honyo wa heye, nakawasumya na kuwawinga mbaka Hoba, kasikazini mwa Damasiko. ");
INSERT INTO vid_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Lelo Abulamu nakahiluka na lufufu lweng'ha naluholigwe na wang'honyo, na kumgombola Loti mpwage na lufufu lwake, hamwe na wadala na wanhu wanji waholigwe kuli upogozi. ");
INSERT INTO vid_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Abulamu loyahiluche nayamtowile Kedolilaomeli na wayage, mndewa wa Sodoma nakalawa kuluta kumbochela kuli ibindi lya Shawe, naliwele nguchemigwa ibindi lya mndewa. ");
INSERT INTO vid_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Na heye Melikisedeki, mndewa wa Salemu, nayawele mtambika wa Nguluwi yawele kuchanya, nakegala ibumunda na divai, ");
INSERT INTO vid_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","nakamtambichiza Abulamu yolonga, “Abulamu nayatambichizwe na Nguluwi Yawele kuchanya, yalumbile kilanga na isi. ");
INSERT INTO vid_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Nayatogoligwe Nguluwi Yawele kuchanya, nayawawichile wang'honyo wa hegwe mmoko mwako.” Na heye Abulamu nakamha Melikisedeki ndolendole ya heye honhu hamwe ha kumi ha lufufu lwake naloyawele nalo. ");
INSERT INTO vid_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Lelo mndewa wa Sodoma, nakamlonjela Abulamu, “Mumhe heni awo wanhu, ila wiholele lufufu lweng'ha gwegwe baho.” ");
INSERT INTO vid_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Ila Abulamu nakamlonjela mndewa wa Sodoma, “Ndangilaha kwa Mkulu Nguluwi, Nguluwi Yawele kuchanya, yalumbile kilanga na isi, ");
INSERT INTO vid_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","kota sihola ne uzi ama ng'weso ya makwamba, na choneche cha hegwe, uleche kuya kidaya na kulonga kota ndimdita Abulamu yawe na lufufu. ");
INSERT INTO vid_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Lelo sihola choneche leka vila vinhu wasongolo wa heni navyowadile na chasi cha wala nawawele hamwe na heni, Aneli na Eshikoli na Mamle nawawele waganigwe kupegwa.” ");
INSERT INTO vid_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Lozipulute mbuli azo, ulonzi wa Mkulu Nguluwi naumuyila Abulamu aku yolota, “Abulamu, uleche kudumba. Heni nda ngwamo ya hegwe. Heni nda hamwe na hegwe na acho chinhu chikulu ng'hatu kwa hegwe!” ");
INSERT INTO vid_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Ila Abulamu nakalonga, “Gwaa Mkulu Nguluwi, konipa choni hanga ndilutilila kikala ne mwana, na mhalizi wa heni ndo Elieseli wa Damasiko?” ");
INSERT INTO vid_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Abulamu nakalonga, “Ulole, humhele mwana, chitumagwa yapondigwe mng'handa ya heni ndo kowa mhalizi wa heni.” ");
INSERT INTO vid_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Ndo baho Mkulu Nguluwi nakamlonjela, “Ayu howa mhalizi wa hegwe. Mwanago wa kuponda gwegwe ndo kowa mhalizi wa hegwe.” ");
INSERT INTO vid_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Aho Mkulu Nguluwi nakamigala Abulamu kunze na kumlonjela, “Ulole kilanga. Usiwaze nhondwe, wone koweza kuziwaza. Ahyo ndo vyoiwa lulelo lwa hegwe louwa lwinji.” ");
INSERT INTO vid_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Abulamu nakamtogola Mkulu Nguluwi, na kwa chiwalo acho Mkulu Nguluwi nakamtawiza Abulamu kota katanganika. ");
INSERT INTO vid_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Mkulu Nguluwi nakamlonjela Abulamu, “Heni ndo Mkulu Nguluwi ndikugale hegwe kulawila Uli, muji wa Wakalidayo, leka ndikupe isi ayi uihalile.” ");
INSERT INTO vid_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Ila Abulamu nakamlonjela, “Gwaa Mkulu Nguluwi, ndovizela ndaze kota ndoihalila isi ayi?” ");
INSERT INTO vid_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Mkulu Nguluwi nakamlonjela, “Ndigalile isenga ilogota idala liwele na miyaka jidatu, mhene ndala iwele na miyaka jidatu, ing'holo ilume liwele na miyaka jidatu, na ng'hunda na ibofu lya ng'hunda.” ");
INSERT INTO vid_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Abulamu nakamigalila ajo jeng'ha, nakajidumula chila igongolo vihande vili, na kuviwika goya banzi mbili kudilo na kumoso, vichilola, ila videje nahavidumule vihande vili. ");
INSERT INTO vid_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Na ndapo lowaiwinzile vihande vila Abulamu nakawa yowawinga. ");
INSERT INTO vid_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Isanya loluwele luzibila, Abulamu nakebatika na usinjizi lukami, kudumba na jiza totolo navimgubika. ");
INSERT INTO vid_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Aho Mkulu Nguluwi nakamlonjela Abulamu, “Uvizele ng'hatu kota walelwa wa hegwe wochikala kota wajenzi kuli isi yohaiwele ya hewo, wowa wapogozi na wogazigwa kwa mhela wa miyaka miya zine. ");
INSERT INTO vid_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Lelo ndowatagusa wanhu wa nhanzi ya isi ilinguwadita wapogozi, na hamba wala wawele muupogozi wolawa wawele na lufufu lwinji. ");
INSERT INTO vid_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Ila hegwe kobagama goya ng'hatu houchikala kwa mhela wa kuhega. ");
INSERT INTO vid_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Walelwa wa hegwe wohiluka aha kuli lulelo lwa kane, kwa vila wihe wa Waamoli hauwele wa kuhega kutagusigwa.” ");
INSERT INTO vid_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Loifichile matinazo kwali na jiza, Nguluwi nakalajiza chiya chilingufung'ha iyosi na chiluli chilingwaka navyoneka vikola hagati ha vila viwunde. ");
INSERT INTO vid_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Mkulu Nguluwi kadita ilagano na Abulamu aku yolonga, “Walelwa wa hegwe ndanguwapa isi ayi, kulawila lwanda lwa Naili lwa Misili mbaka lula lwanda lukulu lwa Eyufulate, ");
INSERT INTO vid_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","ndo ila iwele isi ya Wakeni na Wakenisi na Wakadimoni ");
INSERT INTO vid_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","na Wahiti na Wapelisi na Walefayi ");
INSERT INTO vid_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","na Waamoli na Wakanaani na Wagiligashi na Wayebusi.” ");
INSERT INTO vid_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Lelo Salai, mdala wa Abulamu, nayang'hali kumpondela mwana wa heye. Ila nayali na chitumagwa mdala nayali yochemigwa Hagali, kulawa Misili. ");
INSERT INTO vid_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Lelo Salai nakamlonjela Abulamu, “Kuvizela kota Mkulu Nguluwi hamhele lulelo lwa kuponda wana. Umhole Hagali chitumagwa wa heni mdala, hanji ndopata wana kwa kukolela heye.” Abulamu nakakunda ulonzi wa Salai. ");
INSERT INTO vid_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Hamba, Salai nakampa Abulamu Hagali, chitumagwa wa heye mdala yalawile Misili yawe mchewake. Aga nagalawila Abulamu nayekalile Kanaani kwa mhela wa miyaka kumi. ");
INSERT INTO vid_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Abulamu nakamhola Hagali, na heye Hagali nakawa na himila. Ila baho du loyawene kahola himila, Hagali nakaluka kumbeza mkulu wake Salai. ");
INSERT INTO vid_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Salai nakamlonjela Abulamu, “Hegwe yokuwala kwa wihe wondilinguditigwa! Heni nandikupa chitumagwa wa heni mdala, ila loyaholile himila du, heni ndiwa siwele munhu hameho hake. Mkulu Nguluwi nayataguse mbuli ya hegwe na heni!” ");
INSERT INTO vid_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Ila Abulamu nakamlonjela Salai, “Chitumagwa wa hegwe mdala ka hasi ha ludali lwako, mditile kota louvigana.” Lelo Salai nakamgaza Hagali mbaka nakanyeleduka. ");
INSERT INTO vid_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Mhilisi wa Mkulu Nguluwi nakamfika Hagali hawele na nzasa ya mazi kuchiwala, nzasa iwele mnzila kulutila Shuli. ");
INSERT INTO vid_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Mhilisi nakamuuza, “Hagali, chitumagwa mdala wa Salai, kwangulawa kohi na kwanguza kohi?” Hagali nakamwidichila, “Ndangumbilima Salai mkulu wa heni.” ");
INSERT INTO vid_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Yula mhilisi wa Mkulu Nguluwi nakamlonjela Hagali, “Hiluche kwa mkulu wa hegwe Salai na umhulichize heye.” ");
INSERT INTO vid_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Kwa ago geng'ha, mhilisi wa Mkulu Nguluwi nakamlonjela Hagali, “Ndokonjezela lulelo lwako mbaka walemwele kuwazigwa kwa winji wa hewo.” ");
INSERT INTO vid_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Hamba ayo mhilisi wa Mkulu Nguluwi nakamlonjela, “Hegwe kuna himila na koponda mwana mlume, komchema itagwa lyake Ishimaeli, mina Mkulu Nguluwi nakalola kugaya kwa hegwe. ");
INSERT INTO vid_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Ishimaeli kochikala kota idogowi lya kisolo, kowa mng'honyo wa chila munhu, na chila munhu kowa yamwihilwe. Kochikala yawele mwihe wa ivyazi lyake.” ");
INSERT INTO vid_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Lelo Hagali nakampa itagwa Mkulu Nguluwi loyasimile na heye ako, “Hegwe ndo Nguluwi yalingumbona heni” Kwa vila nakejesa, “Ndangukomya aha ndimona heye yalingumbona heni.” ");
INSERT INTO vid_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Ndo mina lila izimbo lyanguchemigwa Beeli-lahai-loi. Izimbo ali lya hagati ha Kadeshi na Beledi. ");
INSERT INTO vid_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Hagali nakampondela Abulamu mwana mlume. Abulamu nakamchema mwana ayo Ishimaeli. ");
INSERT INTO vid_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Abulamu nayali na miyaka makumi nane na sita, mhela Hagali naloyampondile Ishimaeli. ");
INSERT INTO vid_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Mhela Abulamu naloyawele na miyaka makumi tisa na tisa, Mkulu Nguluwi nakamlawila, na kumlonjela, “Heni nda Nguluwi yawele na mong'ho. Uwinze ulongozi wa heni na kikala goya ulihela nongwa. ");
INSERT INTO vid_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Leka mbiche ilagano lya heni na hegwe na kukonjezela ng'hatu lulelo lwako.” ");
INSERT INTO vid_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Aho Abulamu nakafugama. Na heye Nguluwi nakamlonjela, ");
INSERT INTO vid_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“Ndanguwika ilagano ali na hegwe. Kowa mhaza wa nhanzi nyinji. ");
INSERT INTO vid_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Kulawila sambi, huchemigwa kahi Abulamu, ila kochemigwa Abulahamu, mina ndikudita uwe mhaza wa nhanzi nyinji. ");
INSERT INTO vid_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Ndokudita uwe na wana wenji ng'hatu, kwa hegwe ndolavya nhanzi nyinji na wandewa wolawa kwa heye. ");
INSERT INTO vid_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Ndolibatilila ilagano lya heni na hegwe, lulelo lwa hegwe na lulelo lwawo lweng'ha mazuwa gose ne kuduma, kahi ndowa Nguluwi wa hegwe na Nguluwi wa lulelo lwako mazuwa gose. ");
INSERT INTO vid_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Ndokupa hegwe na lulelo lwako isi ayi youlingikala kota mjenzi, mina isi yeng'ha ya Kanaani iwe ya hemwe mazuwa gose, na heni ndowa Nguluwi wa hewo.” ");
INSERT INTO vid_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Hamba Nguluwi nakamlonjela Abulahamu, “Kwa banzi ya hegwe, hegwe kolibatilila ilagano lya heni, hegwe na lulelo lwako lweng'ha na lulelo lwao lweng'ha. ");
INSERT INTO vid_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Ali ndo ilagano loulibatilila kuli heni na hegwe na lulelo lwako, chila mlume hali hemwe imgana yenjile ikumbi. ");
INSERT INTO vid_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Mokwinjila ikumbi, na ayi ndo yowa ulajilo wa ilagano lya heni na hemwe. ");
INSERT INTO vid_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Chila mwana mlume wa mazuwa nane hali hemwe imgana yenjile ikumbi. Chila mlume kuli lulelo lwenu, yawe munhu yapondigwe mng'handa mwenu ama yaguligwe kwa sendi za hemwe kulawa kwa mjenzi yohawele lulelo lwenu. ");
INSERT INTO vid_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Ena, chila yumwe wa hewo yapondigwe kuli ng'handa ya hegwe na yaguligwe kwa sendi za hegwe ndangukomya, imgana yenjile ikumbi. Acho ndo chilajilo cha ilagano lyangu kuli ng'huli za hemwe, ilagano lya mazuwa gose ne kuduma. ");
INSERT INTO vid_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Mlume yoneche yohenjile ikumbi kobaguligwa na wanhu wa heye, kwa vila nakabena ilagano lya heni.” ");
INSERT INTO vid_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Hamba Nguluwi nakamlonjela Abulahamu, “Nakuwala mdala wa hegwe, humchema kahi itagwa lyake Salai, ila itagwa lyake lyowa Sala. ");
INSERT INTO vid_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Ndomtambichiza, na heye kokupondela mwana mlume. Ena ndomtambichiza Sala, na heye kowa mamo wa nhanzi nyinji na wandewa wa isi wolawa kwa heye.” ");
INSERT INTO vid_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Aho Abulahamu nakafugama, nakaseka mnhumbula mwa heye yochijesa, “Hambi, yokomya ng'hatu mwana kupondigwa na ng'hongoloka wa miyaka miya? Na ndaze, Sala yawele na miyaka makumi tisa, koweza kuponda mwana?” ");
INSERT INTO vid_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Lelo Abulahamu nakamlonjela Nguluwi, “Na uwe ukundile ilagano alyo na uwe uliwichile kwa Ishimaeli.” ");
INSERT INTO vid_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Nguluwi nakamwidichila, “Hebu, ila mdala wa hegwe Sala kokupondela mwana mlume, nagwe komchema Isaka. Ndoliwika goya ilagano lyangu kwa heye na walelwa wa heye, naliwe ilagano lya mazuwa gose. ");
INSERT INTO vid_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","“Na mbuli ya Ishimaeli, nyhulika kulanda kwa hegwe. Ndomtambichiza, na kowa na wana wenji na kumonjezela ng'hatu. Ishimaeli kowa mhaza wa wandewa kumi na weli, na heni ndomdita yawe mhaza wa nhanzi ng'hulu. ");
INSERT INTO vid_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Ila ilagano lyangu lyotawizwa kwa Isaka yawele kokupondela Sala mwaka ukuya mhela kota awu.” ");
INSERT INTO vid_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Lelo Nguluwi loyasindile kulonga, nakamleka Abulahamu, nakaheluka kilanga. ");
INSERT INTO vid_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Aho, Abulahamu nakamwinjiza ikumbi mwanage Ishimaeli, na kuwenjiza ikumbi walume weng'ha nawapondigwe mng'handa mwake na waguligwe kwa sendi za heye, nakawenjiza ikumbi weng'ha zuwa lilila kota Nguluwi navyoyamlajize. ");
INSERT INTO vid_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Abulahamu nayali na miyaka makumi tisa na tisa naloyenjizwe ikumbi. ");
INSERT INTO vid_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","Na Ishimaeli mwanage nayali na miyaka kumi na midatu naloyenjizwe ikumbi. ");
INSERT INTO vid_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","27","Abulahamu na mwanage Ishimaeli, hamwe na walume weng'ha wa ng'handa ya heye na wanhu weng'ha nawapondigwe mng'handa mwake na wala waguligwe kwa sendi za heye nawenjizwa ikumbi zuwa lilila. ");
INSERT INTO vid_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Mkulu Nguluwi nakamlawila Abulahamu hali miyaloni ja Mamle. Abulahamu nayali yekale hali lwizi lwa chibumuli cha heye mhela wa ivuche lya nemisi, ");
INSERT INTO vid_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","na loyenule meho ga heye, nakawona wanhu wadatu wemile kutali hado na heye. Baho loyawawene, nakalawa yobilima kuluta kuwabochela. Loyafichile kenamiza mbaka hasi, ");
INSERT INTO vid_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","na kulonga, “Wakulu, wone mlingungana ndanguwalanda mleche kukola hondili chitumagwa wa hemwe. ");
INSERT INTO vid_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Mochigalilwa mazi mado leka muhovuje magulu na kwesela hali migodi mlubehelo. ");
INSERT INTO vid_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Mhela homukwesela, ndowa nditeleka ndiya, mulye, leka muwe na mong'ho wa kulutilila na majendo, mina muya kwa heni chitumagwa wa hemwe.” Na hewo nawalonga, “Goya, udite kota vyoulonjile.” ");
INSERT INTO vid_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Abulahamu nakahiluka himahima kuli chibumuli nakamlonjela Sala, “Uwiche goya himahima vijemo vidatu vya utimbo unojile, utimbe, na usome mibumunda.” ");
INSERT INTO vid_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Hamba Abulahamu nakalawa himahima nakuluta kuli misenga, nakahagula ilogota limwe linenehe goya, nakamha chitumagwa yumwe yeyohaje kulidumula na kuliteleka. ");
INSERT INTO vid_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Kahi Abulahamu nakahola mtindi na matombo na ajila miwunde ja ibuguma jiwele jisomigwe goya, na kuwawichila wajenzi awo chilyo, na heye nakema behi na hewo kuwaditila nalowali wolya hasi ha igodi. ");
INSERT INTO vid_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Awala wajenzi nawamuuza, “Mdala wa hegwe Sala kakohi?” Abulahamu nakawedichila, “Kamchibumuli.” ");
INSERT INTO vid_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Yumwe wa hewo nakalonga, “Ndangukomya ndokuhiluchila mhela kota awu mwaka ukuya, na mdala wa hegwe Sala kowa na mwana mlume.” Sala nayali yohulichiza kuli lwizi lwa ihema naluwele kumbele kwa heye. ");
INSERT INTO vid_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Abulahamu na Sala nawali walalile, na heye Sala mbuli zila za wadala nazali zidumile katali. ");
INSERT INTO vid_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Lelo Sala nakaseka mgati mwa nhumbula yolonga, “Heni ndala, na mkulu wa heni Abulahamu hihyo. Ndaze, londiwa ndalile hino, ndoweza kusangalala na kuwa na wana?” ");
INSERT INTO vid_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Aho Mkulu Nguluwi nakamuuza Abulahamu, “Lekachoni Sala nakaseka na kiwuza vyoiwa yawe na mwana vyoyawele yalalile? ");
INSERT INTO vid_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Ndaze, hana mbuli yoneche haiditikwa kwa Mkulu Nguluwi? Ndokuhiluchila mhela uwichigwe, mhela kota awu mwaka ukuya, na Sala kowa na mwana mlume.” ");
INSERT INTO vid_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Ila Sala, nayawele yodumba, nakabela yolonga, “Sisechile!” Mkulu Nguluwi nakamlonjela, “Hebu, kuseka nakuseka.” ");
INSERT INTO vid_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Hamba wala wanhu nawoka, nawaulola muji wa Sodoma, na heye Abulahamu nakawasindichiza. ");
INSERT INTO vid_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Lelo Mkulu Nguluwi nakejesa, “Ndaze, ndimvise Abulahamu mbuli ilibehi kuidita? ");
INSERT INTO vid_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Heye Abulahamu kowa mhaza wa wanhu wa nhanzi ng'hulu na kwa heye nhanzi za isi zeng'ha zotambichizwa. ");
INSERT INTO vid_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Ndimhagula heye leka yawalajize walelwa wa heye kibatilila nzila ya Mkulu Nguluwi, wawe watanganiche na kutagusa goya, ahyo Mkulu Nguluwi komigalila Abulahamu kota navyoyalagane.” ");
INSERT INTO vid_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Lelo Mkulu Nguluwi nakalonga, “Hana kung'ung'utilwa lukami kwa muji wa Sodoma na Gomola na gehile ga hewo makulu ng'hatu. ");
INSERT INTO vid_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Lelo ndodulika kuluta ako ndikelolele nene kota kukomya nawadita kota vila chililo vyochimbuyile. Ndangugana kuvizela.” ");
INSERT INTO vid_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Kulawa baho, wala wanhu nawebatilila nzila ya kuluta Sodoma, ila Abulahamu nayang'hali yemile hali Mkulu Nguluwi. ");
INSERT INTO vid_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Lelo Abulahamu nakamhejelela Mkulu Nguluwi, na kumuuza, “Ndaze, kwangukomya kowakopola wanhu wanojile hamwe na wehile? ");
INSERT INTO vid_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Hanji wamumo wanhu wanojile makumi gahano amo mli muji. Ndaze, koubagamiza muji weng'ha huuleka hebu kwa wala makumi gahano wanojile wawele amo? ");
INSERT INTO vid_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Ndangijesa kota hudita ahyo hebu. Kuwakopola wanhu wanojile hamwe na wehile, wanojile kuditilwa kota wehile. Hebu! Mtagusa wa isi yeng'ha holeka kutagusa gawele goya.” ");
INSERT INTO vid_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Mkulu Nguluwi, nakamlonjela, “Hondiwafika wanhu wanojile makumi gahano kula Sodoma, ena ndouleka muji weng'ha uwe goya kwa mbuli ya hewo.” ");
INSERT INTO vid_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Abulahamu nakalonga, “Njeza kowa na nhunmbula ikangele ya kulongasa na Mkulu, hanga heni siwele chinhu, nda kota misanga na mivu hela. ");
INSERT INTO vid_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Hanji wabaho wanhu wanojile makumi gane na wahano kwa wala makumi gahano. Ndaze, koubagamiza muji weng'ha kwa vila wapuka wanhu wahano?” Mkulu Nguluwi nakamwidichila, “Siubagamiza muji wone kowa na wanhu wanojile makumi gane na wahano.” ");
INSERT INTO vid_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Abulahamu nakonjezela kulonga, “Hanji wanhu makumi gane wawele amo.” Nguluwi nakamwidichila, “Kwa mbuli ya wanhu wanojile makumi gane, sidita ahyo.” ");
INSERT INTO vid_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Abulahamu nakonjezela kulonga, “Mkulu, ndangulanda uleche kunzudila, na heni ndolonga kahi. Hanji wowabaho wanhu wanojile makumi gadatu.” Mkulu Nguluwi nakamwidichila, “Sidita ahyo hondiwafika awo wanhu makumi gadatu.” ");
INSERT INTO vid_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Abulahamu nakalonga, “Nanjeza kulonga na Mkulu kwa nhumbula ikangale. Hanji wowa baho wanhu wanojile makumi meli.” Nguluwi nakamwidichila, “Kwa mbuli ya awo wanhu makumi meli wanojile, siubagamiza hebu.” ");
INSERT INTO vid_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Hamba Abulahamu nakalonga, “Mkulu, ndangulanda uleche kunzudila, ila ndolonga kahi kamwe hela. Ndaze, wone wawe wanhu wanojile kumi, yowa ndaze?” Mkulu Nguluwi nakamwidichila, “Kwa mbuli ya awo wanojile kumi, siubagamiza muji awo.” ");
INSERT INTO vid_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Mkulu Nguluwi loyasindile kulonga na Abulahamu, nakoka, na heye Abulahamu nakahiluka kaye. ");
INSERT INTO vid_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Wala wahilisi weli nawafika muji wa Sodoma matinazo. Loti nayawele yekalise hali lwizi lwa muji wa Sodoma, loyawawene nakenuka kuwabochela, nakenamiza mbaka hasi ");
INSERT INTO vid_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","na kulonga, “Wakulu wa heni, muye hakaye hangu heni chitumagwa wa hemwe. Moweza kuhovuga magulu na kuwasa kwa heni nechilo ya lehano. Lufuku ng'hanu hananya moweza kulutilila na majendo ga hemwe.” Ila hewo nawalonga, “Hebu, hetwe towasa honhu hawele hagati ha muji.” ");
INSERT INTO vid_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Loti nakawadedeza lukami, hamba nawamkundila, nawagaluka na kwinjila mng'handa mwake. Loti nakawawichila chilyo, nakapanila mibumunda johajiwichigwe usaso, nawalya. ");
INSERT INTO vid_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Ila nalowang'hali kuwasa nechilo, walume weng'ha wa muji wa Sodoma na wasongolo na wasekulu, nawaizunguluta ng'handa ya Loti. ");
INSERT INTO vid_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Nawamchema Loti na kumuuza, “Wakohi wala walume wezile kwa hegwe? Walavye kunze. Twangugana kuwasa nawo.” ");
INSERT INTO vid_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Loti nakalawa kunze, nakapajila lwizi kumbele kwa heye, ");
INSERT INTO vid_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","nakawalonjela, “Wang'holozangu, ndanguwadedeza mleche kudita wihe awo. ");
INSERT INTO vid_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Mlole, ndanawo wahinza weli wang'hali wasa na mlume. Mng'hundize ndiwape awo wahinza muwadite kota vyomgana. Ila mleche kuwaditila chinhu choneche chila walume awa kwa vila awa ndo wajenzi wawele hali wamizi wa heni.” ");
INSERT INTO vid_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Ila hewo nawalonga, “Hejela! Hegwe nakuya hano kota mjenzi na sambi kwangidita mtagusa. Lelo tokudita vibi kusinda awo wajenzi wa hegwe.” Aho nawamkundujiza Loti kumbele behi na kuubegula lwizi lwa heye. ");
INSERT INTO vid_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Ila wala wajenzi nawagolola moko gawo, nawamkwega Loti mng'handa na kupajila lwizi. ");
INSERT INTO vid_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Hamba wawatowa kwa lumwemwesa lung'ang'ale kumeho na walemwela kulola walume weng'ha nawawele hali lwizi, wakulu kwa wadodo, mbaka nawapala kohi hawele na lwizi nahawauwene. ");
INSERT INTO vid_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Wala wanhu weli nawamlonjela Loti, “Ndaze, kwanaye munhu yunji ahano, hanji wakasano ama wasongolo ama wahinza wa hegwe ama wanhu wanji wa ivyazi lyako walingikala hano, walavye honhu aha himahima, ");
INSERT INTO vid_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","kwa vila twahabehi kuubagamiza muji awu, mina chililo nachimfichile Mkulu Nguluwi kulawa kwa wanhu wa muji awu ndo kukulu ng'hatu, leka heye katulajiza tuye kuwabagamiza.” ");
INSERT INTO vid_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Lelo Loti nakawalutila wakasano wa heye, nakawalonjela, “Himahima! Mlawe honhu aha, mina Mkulu Nguluwi koubagamiza muji awu.” Ila hewo nawamona kota munhu msechezi hela. ");
INSERT INTO vid_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Lufuku, wahilisi nawamhimiliza Loti wolonga, “Ulilimche, muhole mdala wa hegwe na awa wahinza wa hegwe weli mleche kubagama mhela muji awo hougazigwa.” ");
INSERT INTO vid_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Loti nakawa yogogoma. Ila kwa vila Mkulu Nguluwi vyoyamonele isungu Loti, wala wahilisi nawamibata heye na mdala wa heye na wahinza wa heye weli, na kumlavya kunze ha muji ula. ");
INSERT INTO vid_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Nalowawalavile kunze ha muji, mhilisi yumwe nakawalonjela, “Mbilime kwa kuulohola ukomu wa hemwe. Mleche kulola kumbele ama kwima mibindi. Mbilimile kuchidunda, mleche kubagamizwa.” ");
INSERT INTO vid_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Loti nakawalonjela, “Hebu, wakulu wa heni! ");
INSERT INTO vid_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Ndangukomya kota heni chitumagwa wa hemwe ndina igano lya kwimilila hameho henu, na hemwe miwonela isungu ng'hatu kwa kuulohola ukomu wa heni, ila kuchidunda kwa kutali lukami. Ibagamizo ali lyofika nding'hali fika ako, nani ndobagama. ");
INSERT INTO vid_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Mlole, kula kuna muji mdodo uwele behi ndoweza kubilimila ako. Lelo mng'hundize mbilimile ako. Ula ndo muji mdodo hela, na ako ndowa mkomu.” ");
INSERT INTO vid_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Na heye nakamwidichila, “Goya, ndikukundiza kulanda kwa hegwe. Siubagamiza muji wouchemile. ");
INSERT INTO vid_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Udite himahima. Ubilimile ako, na heni siweza kudita chinhu choneche mbaka houfika ako.” Lelo muji awo nauchemigwa Soali, ulinguzeleka kota udodo. ");
INSERT INTO vid_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Isanya nalyali lilawile mhela Loti loyafichile hali muji wa Soali. ");
INSERT INTO vid_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Ndo Mkulu Nguluwi nakalagaza hasi chiluli ching'ang'ale cha chikwatilo kulawa kilanga kwa muji wa Sodoma na Gomola, ");
INSERT INTO vid_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","nakajibagamiza miji ajo na ibindi lyeng'ha na wanhu weng'ha na mizuchila jeng'ha kuli misanga. ");
INSERT INTO vid_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Ila mdala wa Loti nayawele kumbele kwa Loti, nakalola kumbele, nakagaluka ibiwi lya mwino. ");
INSERT INTO vid_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Loiwele lufuku, Abulahamu nakaluta honhu hoyawele yemile kumwando kwa Mkulu Nguluwi. ");
INSERT INTO vid_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Loyali aho, nakalola hasi nzingo za Sodoma na Gomola na honhu heng'ha ha ibindi, kwa kona iyosi likwina, iyosi kota itanuli ling'hangala. ");
INSERT INTO vid_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Nguluwi loyajibagamize miji ja kibindi koyawele yochikala Loti, nakamkumbuka Abulahamu kwa kumlavya Loti kuli miji ajo, leka Loti yaleche kubagama hamwe na hewo. ");
INSERT INTO vid_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Loti nakadumba kikala kuli muji wa Soali, lelo nakoka muji awo, heye hamwe na wahinza wa heye weli, nawaluta kikala mipalika kuchidunda. ");
INSERT INTO vid_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Nalowawele ako, mhinza mkulu nakamlonjela lumbulye, “Mhaza wa hetwe nakalala, na kuduhu mlume muisi wa kuwasa na hetwe kota vyoilinguganigwa kuli chihendo. ");
INSERT INTO vid_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Lelo tumgalize mhaza kwa divai, leka tuwase na heye na kukangaza lulelo kwa kuponda wana na heye.” ");
INSERT INTO vid_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Nechilo ayo nawamgaliza mhaza wa hewo kwa divai, na yula mhinza mkulu nakaluta kuwasa na heye. Ila mhaza wa heye nahavizelele mhela mhinza wa heye loyawasile na heye na loyochile. ");
INSERT INTO vid_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Mitondo, yula mhinza wa mwaluko nakamlonjela yula mdodo, “Haucha nechilo heni nambasa na mhaza, lehano kahi tumgalize na divai, hamba hegwe uwase na heye, leka hetwe twesa tukangaze lulelo kwa kuponda wana kwa mhaza wa hetwe.” ");
INSERT INTO vid_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Lelo nechilo ayo kahi nawamgaliza mhaza wa hewo kwa divai, hamba yula mhinza nakaluta kuwasa naye. Ila mhaza wa heye nahavizelele mhela mhinza wa heye hoyawasile na heye, na loyochile. ");
INSERT INTO vid_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Lelo wahinza weng'ha weli wa Loti nawawa na himila kwa kuwasa na mhaza wa hewo. ");
INSERT INTO vid_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Yula mhinza wa mwaluko nakaponda mwana mlume, nakamchema Moabu. Ayo ndo mhaza wa Wamoabu mbaka lehano. ");
INSERT INTO vid_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Yula mhinza mdodo kahi nakaponda mwana mlume, nakamchema Beni-ami. Ayo ndo mhaza wa Waamoni mbaka lehano. ");
INSERT INTO vid_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Kulawila Mamle, Abulahamu nakenula majendo kulutila Negebu, nakadita luga lwake hagati ha Kadeshi na Shuli, hamba nakaluta kikala ako Gelali kwa mhela uchefu. ");
INSERT INTO vid_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Loyawele ako, Abulahamu nakalonga kota mchewake Sala ka lumbulye. Lelo mndewa Abimeleki wa Gelali nakamhesa Sala. ");
INSERT INTO vid_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Ila Nguluwi nakamuyila Abimeleki nechilo loyali yolota, nakamlonjela, “Hegwe kobagama kwa mbuli ya mdala youmholile, kwa vila kana mlume wake.” ");
INSERT INTO vid_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Abimeleki nayang'hali wasa na Sala, nakedichila, “Mkulu, kowakopola wanhu wohawawele na nongwa? ");
INSERT INTO vid_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Heye Abulahamu ndo yalonjile kota ayu mdala ka lumbulye. Kahi na heye Sala nakalonga kota Abulahamu kalumbu wa heye. Heni ndita vyonditile kwa nhumbula igoloche ndahela nongwa.” ");
INSERT INTO vid_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Nguluwi nakamlonjela koyali yolota, “Goya. Ndivizela kota kudita ahyo kwa nhumbula igoloche, na heni ndo ndikulemeze kudita gehile ago, ndo mina sikukundiza umdolize ayo mdala. ");
INSERT INTO vid_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Lelo umhiluse ayo mdala kwa mlume wa heye. Abulahamu ndo mloli wa heni, na heye kokulandila nagwe kowa mkomu. Ila wone humhiluse, uvizele ng'hatu kota hegwe kobagama hamwe na wanhu wa hegwe weng'ha.” ");
INSERT INTO vid_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Abimeleki nakalilimka lufuku, nakawachema vitumagwa wa heye weng'ha na kuwalonjela mbuli nazoyaziwene koyali yolota, na hewo nawadumba ng'hatu. ");
INSERT INTO vid_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Baho, Abimeleki nakamchema Abulahamu, na kumuuza, “Nakutuditila choni? Lekachoni nakunyambuza heni kudita gehile na sambi Nguluwi kangugana kungaza heni na undewa wa heni? Kunditila mbuli zohaziganigwa kuditigwa.” ");
INSERT INTO vid_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Abimeleki nakalutilila kumuuza Abulahamu, “Chinhu chachi chikuditile kudita hino?” ");
INSERT INTO vid_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Abulahamu nakamwidichila, “Nandita hino kwa vila nandijesa kota kuduhu munhu ne yumwe yalingumdumba Nguluwi honhu hano, na kota mwahang'hopole leka mumhole mchewangu. ");
INSERT INTO vid_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Kuleka kwa ago, ndangukomya, heye ka lumbulyangu, mhaza wa heye na mhaza wa heni ndo yumwe, ila hatihanzile mamo, ndo mina kawa mchewangu. ");
INSERT INTO vid_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Mhela Nguluwi loyanditile ndiileche ng'handa ya mhaza wa heni na kuluta kuujenzi, nandimlonjela mchewangu, ‘Honeche hotuluta, dedede ulajile igano kwa heni kwa kulonga kota heni nda lumbulyo.’ ” ");
INSERT INTO vid_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Abimeleki nakamhilusila Abulahamu mchewake Sala, nakamha na ming'holo na misenga na vitumagwa walume na wadala. ");
INSERT INTO vid_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Abimeleki nakamlonjela Abulahamu, “Ulole, isi ayi yeng'ha ya heni. Lelo uhagule heng'ha hala uhaganile, wikale.” ");
INSERT INTO vid_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Hamba nakamlonjela Sala, “Ulole, heni ndimha mng'holozo migwala maelufu menji leka kuwalajila wawele hamwe na hegwe kota kwahela nongwa, nakutawizwa kota kwahela nongwa” ");
INSERT INTO vid_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Hamba Abulahamu nakamlanda Nguluwi, na heye kamlohola Abimeleki na mchewake na vitumagwa wa heye mdala, mbaka nawaweza kuponda kahi wana. ");
INSERT INTO vid_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","Aho mwaluko Mkulu Nguluwi nayali yawalemeze wadala weng'ha wa ng'handa ya Abimeleki kuponda wana kwa mbuli ya Sala mchewake Abulahamu. ");
INSERT INTO vid_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Mkulu Nguluwi nakamkumbuka Sala, nakamditila kota vyoyelahile. ");
INSERT INTO vid_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Abulahamu naloyali yalalile, Sala nakahola himila, nakampondela mwana msongolo, mhela wuwula Nguluwi woyalonjile. ");
INSERT INTO vid_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Abulahamu nakamchema ayo mwana yampondile Sala itagwa lyake, Isaka. ");
INSERT INTO vid_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Isaka loyafichile mazuwa nane, Abulahamu nakamwinjiza ikumbi kota Nguluwi vyoyalajize. ");
INSERT INTO vid_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Abulahamu nayali na miyaka miya imwe, mhela mwanage Isaka naloyapondigwe. ");
INSERT INTO vid_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Na heye Sala nakalonga, “Nguluwi kangalila lusele, yoneche yohulika mbuli azi, koseka hamwe na heni.” ");
INSERT INTO vid_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Hamba nakonjezela, “Yalikohi nayahamlonjele Abulahamu kota heni Sala ndokonyeza wana? Na ndimpondela mwana msongolo kuli ulalilo wa heye.” ");
INSERT INTO vid_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Isaka nakalutilila kukula, na zuwa loyalechile kong'ha, Abulahamu nakadita mnvina ng'hulu. ");
INSERT INTO vid_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Hamba Sala nakamona Ishimaeli, mwana wa Abulahamu yapondigwe na Hagali Mmisili, yoseka. ");
INSERT INTO vid_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Sala nakamlonjela Abulahamu, “Umuwinje chitumagwa ayo mdala hamwe na mwanage. Kwa vila hohalila hamwe na mwana wa heni Isaka.” ");
INSERT INTO vid_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Mbuli ayi naimigalila masinzo lukami Abulahamu kwa vila Ishimaeli na heye nayali mwanage. ");
INSERT INTO vid_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Ila Nguluwi nakamlonjela Abulahamu, “Uleche kisinza kwa mbuli ya mwana ayu, na ayo chitumagwa wa hegwe mdala. Lyoneche loyokulonjela Sala, udite, ndangukomya walelwa wa hegwe wondikulahile wolawa kwa Isaka. ");
INSERT INTO vid_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Na mbuli ya ayo mwana wa chitumagwa wa hegwe mdala ndomdita yawe mhaza wa nhanzi ng'hulu kwa vila heye naye ka mwana wa hegwe.” ");
INSERT INTO vid_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Ahyo lufuku, Abulahamu nakahola chilyo na kajilo ka mazi, nakamha Hagali na kumdwika mmayega, na kumuwinga hamwe na mwanage. Hagali nakoka, kawa yojendajenda mchihulo Beeli-sheba. ");
INSERT INTO vid_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Nayali mazi nalogamalile mli kala kajilo, Hagali nakamuwasiliza mwanage hasi migodi. ");
INSERT INTO vid_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Heye nakaluta hafungo, kekala utali wa kota magulu miya imwe hino, yolonga mnhumbula mwa heye, “Inoga ndeche kumona mwanangu yobagama.” Naloyawele yekalise aho nakaluka kulila. ");
INSERT INTO vid_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Nguluwi nakamhulika mwana ayo yolila, na mhilisi wa Nguluwi nakamchema Hagali kulawila kilanga, na kumlonjela, “Kuna nongwa yachi Hagali? Uleche kudumba, Nguluwi nakahulika lizi ya mwana ako kouwele. ");
INSERT INTO vid_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Wime na umwinule mwana mibate goya mmoko mwa hegwe, mina ndomdita yawe mhaza wa nhanzi ng'hulu.” ");
INSERT INTO vid_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Nguluwi nakamgubula Hagali meho, na heye nakalyona izimbo lya mazi. Nakaluta kamemeza mazi mkajilo, na kumnweza mwanage. ");
INSERT INTO vid_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Nguluwi kawa hamwe na ayo mwana, na heye nakalutilila kukula. Nakekala kuchihulo nakawa mlasa msale. ");
INSERT INTO vid_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Nayali yochikala kuli chihulo cha Palani, na mayake nakamhesela mdala kulawa isi ya Misili. ");
INSERT INTO vid_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Mhela awo, Abimeleki hamwe na Fikoli, mkulu wa wamizi wa heye, nakamlutila Abulahamu na kumlonjela, “Nguluwi kahamwe na hegwe kwa chila chinhu choulingudita. ");
INSERT INTO vid_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Lelo ndilahile kwa itagwa lya Nguluwi kota hunditila uhadi heni ama wana wa heni ama walelwa wa heni. Kota heni vyombele nojile kwa hegwe, hihyo nagwe uwe na igano lya kwimilila kwa heni na kwa isi ino youlingikala.” ");
INSERT INTO vid_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Abulahamu nakalonga, “Ndangilaha.” ");
INSERT INTO vid_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Mhela awo Abulahamu nayali yomng'ung'utila Abimeleki mbuli ya izimbo lya mazi vitumagwa wa Abimeleki lowali wambochile. ");
INSERT INTO vid_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Abimeleki nakamlonjela, “Heni sivizelele yalikohi yaditile hino, mbaka lehano hegwe hundonjele, na heni nasinahulika mbuli azi mbaka lehano.” ");
INSERT INTO vid_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Abulahamu nakahola ing'holo na isenga nakamha Abimeleki nawo weli nawadita ilagano hewo kwa hewo. ");
INSERT INTO vid_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Abulahamu nakabagula ming'holo myana midala saba. ");
INSERT INTO vid_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Abimeleki nakamuuza Abulahamu, “Lekachoni kwangubagula ajo ming'holo myana midala saba?” ");
INSERT INTO vid_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Abulahamu nakamwidichila, “Aji ming'holo myana midala saba ndangukupa kwa moko wa heni baha kota ulolezi kota heni ndo mbawile izimbo alino.” ");
INSERT INTO vid_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Lelo izimbo alyo nalichemigwa Beeli-sheba, mina weng'ha weli nawawika ilagano kwa kilaha honhu aho. ");
INSERT INTO vid_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Ahyo nawadita ilagano ako Beeli-sheba. Abimeleki na Fikoli, mkulu wa wamizi wa heye, nakoka na kuhiluka kuli isi ya Wafilisti. ");
INSERT INTO vid_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Abulahamu nakanyala igodi lilinguchemigwa tamalisiki ako Beeli-sheba, nakalanda kwa itagwa lya Mkulu Nguluwi wa mazuwa gose. ");
INSERT INTO vid_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Abulahamu nakekala isi ya Wafilisti mihela minji. ");
INSERT INTO vid_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Loupulute mhela udo hela, Nguluwi nakamjeza Abulahamu. Nguluwi nakamchema, “Abulahamu!” Na heye nakedichila, “Ena ndanguhulichiza.” ");
INSERT INTO vid_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Nguluwi nakamlonjela, “Umuhole mwanago Isaka, mwanago wa udewele umganile, ulute mbaka isi ya Molia, ukamlavye nhambiko ya kulakazwa kuchanya mwa chidunda chimwenga chondikulajila.” ");
INSERT INTO vid_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Hamitondo iyage, Abulahamu nakalilimka lufuku, kalilambalika goya idogowi lyake, nakawahola vitumagwa wa heye weli hamwe na Isaka mwanage. Nakatema ngodi kwa mbuli ya nhambiko ya kulakazwa, hamba nakaluka majendo kuluta honhu hoyalonjelwe na Nguluwi. ");
INSERT INTO vid_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Zuwa lya kadatu, Abulahamu nakenula meho nakahona honhu aho kwa kutali. ");
INSERT INTO vid_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Abulahamu nakawalonjela wala vitumagwa wa heye, “Betezeni bahano na ali idogowi. Heni na mwana wa heni toluta mbaka kula tukamfugamile Nguluwi, hamba towahiluchilani.” ");
INSERT INTO vid_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Abulahamu nakamdwika zila ngodi mwanage Isaka, heye yuye nakahola chiluli na chimaje mmoko, na kuka hamwe. ");
INSERT INTO vid_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Isaka nakamchema mhaza wa heye Abulahamu, “Mhaza!” Na heye nakedichila, “Ena, ndabahano mwanangu.” Isaka nakamuuza mhaza wa heye, “Chiluli na ngodi twanazo, ila ing'holo lya nhambiko ya kulakazwa lya kohi?” ");
INSERT INTO vid_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Abulahamu nakamwidichila, “Mwana wa heni, Nguluwi heye kotigalila ing'holo lyana lya nhambiko ya kulakazwa.” Nawalutilila na majendo. ");
INSERT INTO vid_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Nalowafichile honhu hala Nguluwi hoyamlajize, Abulahamu nakazenga honhu ha kulavila nhambiko na kuwika goya ngodi hachanya hake. Hamba nakamuwopa mwanage Isaka na kumuwasiliza mchanya hali ngodi kuli honhu ha kulavila nhambiko. ");
INSERT INTO vid_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Abulahamu nakagolola moko, kahola chimaje yamdumule mwanage. ");
INSERT INTO vid_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Ila mhilisi wa Mkulu Nguluwi nakamchema kulawa kilanga, “Abulahamu, Abulahamu!” Na heye nakedichila, “Ena, ndanguhulichiza.” ");
INSERT INTO vid_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Mhilisi nakamlonjela, “Uleche kumlumiza mwana na uleche kumdita choneche. Sambi ndivizela kota kwangumdumba Nguluwi, kwa vila hundemeze mwanago wa udewele.” ");
INSERT INTO vid_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Ndo baho Abulahamu nakenula meho, nakona ing'holo ilume, ligwilizwe mbalati kuli miwa hali chisosolo. Nakaluta, kalihola alila ing'holo, na kulilavya nhambiko ya kulakazwa honhu ha mwanage. ");
INSERT INTO vid_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Lelo Abulahamu nakahachema honhu aho, “Mkulu Nguluwi kotigalila.” Kota vyoilingulonjigwa mazuwa aga, “Kuli chidunda cha Mkulu Nguluwi kotigalila.” ");
INSERT INTO vid_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Mhilisi wa Mkulu Nguluwi nakamchema Abulahamu lwa keli kulawa kilanga, ");
INSERT INTO vid_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","na kumlonjela, “Mkulu Nguluwi kangulonga hino, ndilaha nene baha, kwa vila kudita hino, nahundemeze mwanago wa udewele, ");
INSERT INTO vid_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","ndangukomya ndokutambichiza, na walelwa wa hegwe ndowonjeza kota nhondwe za kilanga, na kota sangalaza mfungo mwa bahali. Walelwa wa hegwe woihalila miji ja wang'honyo wa hewo. ");
INSERT INTO vid_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Kulawa kwa walelwa wa hegwe wanhu wa isi zeng'ha wotambichizwa kwa vila hegwe nakwidichila ilajizo lyangu.” ");
INSERT INTO vid_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Abulahamu nakawahiluchila wala vitumagwa wa heye, nawo nawoka hamwe kuhiluka Beeli-sheba, Abulahamu nakekala ako. ");
INSERT INTO vid_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Logalawile ago geng'ha Abulahamu nakahulika mbuli kota Milika kahi kampondela Naholi mng'holoze, wana walume. ");
INSERT INTO vid_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Usi mlelwa wa mwaluko na Busi mng'holoze na Kemueli mhaza wa Alamu ");
INSERT INTO vid_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","na Kesedi na Haso na Pilidashi na Yidilafu na Betueli. ");
INSERT INTO vid_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Betueli nakamponda Lebeka. Milika nakampondela Naholi, mng'holoze Abulahamu, wana awo nane. ");
INSERT INTO vid_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Kulawila aho, Leuma mha wa Naholi nayawele kota mchewake, kahi nakampondela wana, Teba na Gahamu na Tahashi na Maaka. ");
INSERT INTO vid_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Sala nakekala miyaka miya imwe na makumi meli na saba. ");
INSERT INTO vid_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Nakabagama ako Kiliati-aliba, ako Hebuloni kuli isi ya Kanaani. Abulahamu nakalombocheza na kumditila matanga mchewake Sala. ");
INSERT INTO vid_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Abulahamu nakauleka mtufi wa mchewake, nakalawa kuluta kulongasa na Wahiti, nakawalonjela, ");
INSERT INTO vid_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“Heni ndangikala kota mjenzi hali hemwe. Mnguzile honhu ha kubawa chilaga leka nditile mtufi wa mchewangu na wanhu wa heni wabagame hamba.” ");
INSERT INTO vid_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Wahiti nawamwidichila Abulahamu, ");
INSERT INTO vid_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“Ena mkulu wa hetwe, tuhulichize, hegwe kwa chilongozi uhaguligwe na Nguluwi hali hetwe. Umtile mchewako kuli chilaga choneche wihagulile, kuduhu yoneche yokulemeza chilaga kwa hetwe, na kukulemeza kutila mtufi wa mchewako na wanhu wa hegwe wabagame.” ");
INSERT INTO vid_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Aho Abulahamu nakema na kinamiza hamwando ha wanhu wa isi yila ya Wahiti, ");
INSERT INTO vid_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","na kuwalonjela, “Wone mlingung'hundiza ndiutile mtufi wa mchewangu na wanhu wa heni wabagame, dedede mlandeni Efuloni mwana Sohali, kwa mbuli ya heni, ");
INSERT INTO vid_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","yanguzile alila ipalika lyake lya Makipela liwele mmbaka mwa mgunda wa heye. Mumdedeze yanguzile ndilidite vilaga vya heni, yanguzile kwa sendi zakuhega namwe mlibaha.” ");
INSERT INTO vid_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Efuloni heye nayali bahala howawele Wahiti awo nawawele wating'hane hali lwizi lwa muji. Efuloni Mhiti, nakamwidichila Abulahamu, kumwando kwa Wahiti weng'ha. ");
INSERT INTO vid_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“Hebu mkulu, dedede unyhulichize. Ndangukupa mgunda weng'ha na ipalika liwele mumo, kahi ndangukupa hamwando ha Wahiti wayangu. Utile amo mtufi wa mchewako na wanhu wa hegwe wabagame.” ");
INSERT INTO vid_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Abulahamu nakenamiza kahi hamwando ha wanhu wa isi yila ya Wahiti, ");
INSERT INTO vid_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","na kumlonjela Efuloni, leka wanhu weng'ha wahuliche, “Ndangukulanda, dedede unyhulichize. Ndolavya sendi za kuhega mgunda wa hegwe, na ndangukulanda ubochela sendi azo leka ndiutile amo mtufi wa mchewangu na wanhu wa hegwe wabagame.” ");
INSERT INTO vid_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Efuloni nakamwidichila Abulahamu, ");
INSERT INTO vid_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“Mkulu, unyhulichize, mgunda wanguguzigwa kwa migwala miya zine ndo chinhu chachi hali heni na hegwe? Utile mtufi wa mchewako na wanhu wa hegwe wabagame.” ");
INSERT INTO vid_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Abulahamu nakekundiza na Efuloni, nakampimila chasi cha sendi zoyalonjile hawele na Wahiti weng'ha, migwala miya zine, kota naviwele vipimilo vya wawele nguguza vinhu mhela awo. ");
INSERT INTO vid_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Lelo mgunda wa Efuloni nauwele ako Makipela, kolilawilaga isanya mwa Mamle, ipalika na migodi jeng'ha hamwe na honhu heng'ha, liwa lya heye, ");
INSERT INTO vid_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","Abulahamu hamwando ha Wahiti weng'ha naweting'hane mlwizi lwa muji. ");
INSERT INTO vid_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Kulawila aho, Abulahamu nakamtila Sala mchewake kuli ipalika alyo naloliwele kuli mgunda wa Makipela, kolilawilaga isanya mwa Mamle, Hebuloni kuli isi ya Kanaani. ");
INSERT INTO vid_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Mgunda na ipalika liwele amo nalitawizwa na Wahiti liwe lyake Abulahamu yawatile amo wanhu wa heye wabagame. ");
INSERT INTO vid_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Abulahamu lelo nayali yalalile yawele na miyaka minji, na heye Mkulu Nguluwi nakamtambichiza kwa chila mbuli. ");
INSERT INTO vid_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Zuwa limwe Abulahamu nakamlonjela chitumagwa wa heye yawele yalalile kusinda weng'ha na mwamizi wa lufufu lwake lweng'ha, “Dedede uwiche moko ga hegwe hasi ha mahaza ga heni, kulajila kota kwangilaha ");
INSERT INTO vid_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","nani ndokulahiza kwa Mkulu Nguluwi, Nguluwi wa kilanga na isi, kota hambe humgalile mwana wa heni mdala yoneche hali wadala wa Wakanaani wondilingikala nawo. ");
INSERT INTO vid_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Ndilahile kota koluta mbaka kuli isi ya heni, kwa ivyazi lyangu, ukampalile mdala kwa mwana wa heni Isaka.” ");
INSERT INTO vid_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Chitumagwa nakamlonjela, “Hanji mdala ayo kolema kilongoza na heni kuya akuno, wone iwe ahyo, ndaze, ingana ndimhiluse mwanago kuli isi koulawile?” ");
INSERT INTO vid_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Abulahamu nakamlonjela, “Hebu! Wilolele ng'hatu uleche kumhilusa mwana wa heni ako. ");
INSERT INTO vid_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Mkulu Nguluwi, Nguluwi wa kilanga, yandavile kaye kwa mhaza wa heni na kulawa kuli isi yomvumbuche, na yalingulonga na heni, nakandilahila kota kowapa walelwa wa heni isi ayi. Heye komlajiza mhilisi wa heye kumwando mwa hegwe leka umigalile mdala mwana wa heni kulawa ako. ");
INSERT INTO vid_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Wone mdala ayo kolema kiwinza na hegwe mbaka kuno, lelo chilaho cha heni, hachikubata hebu, ila kwa vyeng'ha vila, uleche kumhilusa mwana wa heni ako”. ");
INSERT INTO vid_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Lelo chitumagwa ayo nakawika moko wa heye hasi ha mahaza ga Abulahamu, mkulu wa heye, nakilaha kwa mbuli ayo. ");
INSERT INTO vid_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Hamba, ayo chitumagwa nakahola ngamiya kumi wa mkulu wa heye na kuka yawele na ndolendole zinojile za vinjivinji. Kenula majendo kuluta kuli muji loyekale Naholi, kuli isi ya Mesopotamiya. ");
INSERT INTO vid_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Loyafichile, nakawafugamiza ngamiya wa heye hafungo mwa izimbo liwele hafungo mwa muji. Nayali matinazo mhela uwele wadala nawalutaga kudeha mazi kuli izimbo. ");
INSERT INTO vid_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Na heye nakalanda, “Hegwe Mkulu Nguluwi, Nguluwi wa mkulu wa heni Abulahamu, ndangukulanda sumye, na umditile igano lya kwimilila mkulu wa heni Abulahamu. ");
INSERT INTO vid_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Nda ahano hafungo mwa nzasa hawele wahinza wa wenyeng'haye wa muji huyaga kudeha mazi. ");
INSERT INTO vid_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Lelo mhinza yondimlonjela, yenenule chiya cha heye cha mazi yangalile mazi nyinwe, na heye nakangalila hamwe na kuwanweza ngamiya wa heni, na yawe ndo youmuhagulile chitumagwa wa hegwe Isaka. Mbuli ayo yondajila kota kumditila igano lya kwimilila mkulu wa heni.” ");
INSERT INTO vid_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Naloyang'hali kusinda kulanda, baho du Lebeka, mhinza wa Betueli, mwanage Milika, mchewake Naholi, mng'holoze Abulahamu, nakafika yaholile chiya cha heye mmayega. ");
INSERT INTO vid_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Mhinza ayo nakanoga lukami nayali na kumeho kunojile ng'hatu, na chigoli hanating'hana na mlume yoneche. Lelo nakedulisa minzasa, na kudeha mazi na chiya lochimemile, nakakwina na kuka. ");
INSERT INTO vid_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Ndo yula chitumagwa nakaluta himahima kuza ting'hana na heye, na kumlonjela, “Dedede, ndangulanda mazi ga kunwa kulawa mchiya cha hegwe.” ");
INSERT INTO vid_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Mhinza nakamwidichila, “Goya ung'we mkulu wa heni.” Na baho nakanenula chiya cha heye, na kibatilila leka yamnweze. ");
INSERT INTO vid_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Loyampele mazi, nakamlonjela, “Ndowawichila mazi na ngamiya wa hegwe nawo, wanwe mbaka ng'halu imale.” ");
INSERT INTO vid_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Lelo nakadita himahima, na kuwajidila ngamiya mazi ga chiya cha heye mibato, na kubilimila kuli izimbo kudeha mazi ganji na kuwanweza ngamiya wa heye weng'ha. ");
INSERT INTO vid_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Yula chitumagwa nayali yomlola ne kulonga chinhu, yavizele kota Mkulu Nguluwi nakatambichiza majendo ga heye ama hebu. ");
INSERT INTO vid_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Ngamiya lowanwele mazi, yula munhu nakamvaliza yula mhinza pete ndodo ya dhahabu ya kuvala mmenyhelo iwele na itunyo lya gilamu sita na banjili mbili za dhahabu ziwele na gilamu miya imwe na makumi meli chila imwe. ");
INSERT INTO vid_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Nakamuuza, “Dedede undonjele, hegwe kwa mhinza wa whaani? Ndaze, hana honhu ha kuwasa hakaye ha mhaza wa hegwe?” ");
INSERT INTO vid_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Lebeka nakedichila, “Heni nda mhinza wa Betueli, mwana Milika, mchewake Naholi. ");
INSERT INTO vid_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Kwa hetwe kuna misolo na honhu ha kudimila hakulu na honhu ha kuhega kuwasa wajenzi.” ");
INSERT INTO vid_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Ndo yula munhu nakenamiza mutwi wa heye, na kumfugamila Mkulu Nguluwi, ");
INSERT INTO vid_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","yolonga, “Yatogoligwe Mkulu Nguluwi, Nguluwi wa mkulu wa heni Abulahamu, yawele hambe yasemwe igano lya kwimilila na makundo ga heye kwa mkulu wa heni. Mkulu Nguluwi kandongoza heni ndute mbaka kwa ivyazi lya mkulu wa heni!” ");
INSERT INTO vid_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Hamba yula mdala nakabilima kuza kuwalonjela mbuli yila ivyazi lya mayake. ");
INSERT INTO vid_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Lebeka nayali na mkulugwe yalinguchemigwa Labani. Labani nakalawa yobilima kuza ting'hana na yula munhu kuli nzasa. ");
INSERT INTO vid_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","Labani nayali yaiwene ila pete na banjili mmoko mwa lumbulye na kuhulika mbuli Lebeka nazoyalonjelwe na ayo munhu. Labani nakamfika ayo munhu yemile behi na ngamiya wa heye hafungo mwa nzasa. ");
INSERT INTO vid_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Labani nakamlonjela, “Uye haluga hetu hegwe utambichizwe na Mkulu Nguluwi. Ndaze kwangwima kunze? Heni mina mbika goya ng'handa na honhu kwa mbuli ya awa ngamiya wa hegwe.” ");
INSERT INTO vid_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Lelo chitumagwa ayo wa Abulahamu nakenjila mng'handa. Labani nakawachumula ngamiya na kuwagalila misolo, nakamgalila heye na wanhu wa heye mazi ga kuhovujila magulu. ");
INSERT INTO vid_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Ndiya loipile, yula munhu nakalonga, “Silya mbaka londilonga nachonganile kulonga.” Labani nakamlonjela, “Lelo utulonjele.” ");
INSERT INTO vid_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Yula munhu nakalonga, “Heni nda chitumagwa wa Abulahamu. ");
INSERT INTO vid_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Mkulu Nguluwi nakamtambichiza ng'hatu mkulu wa heni, na heye kawa munhu yawele na lufufu. Nakamgalila vilundo vya ming'holo na vilundo vya migongolo jinji jilingudimigwa minji na sendi na zahabu na vitumagwa wadala na walume na ngamiya na midogowi. ");
INSERT INTO vid_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Sala, mchewake mkulu wa heni kuli ulalilo weng'ha ula, nakampondela mkulu wa heni mwana, na mkulu wa heni nakamha ayo mwana lufufu lwake lweng'ha. ");
INSERT INTO vid_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Mkulu wa heni nakandita ndilahe yolonga, ‘Humholela mwana wa heni mhinza yoneche kuli wahinza wa Wakanaani ndilingikala kuli isi ya hewo. ");
INSERT INTO vid_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Ila koluta kuli isi ya heni, kwa wang'holozangu, leka ukampalile mdala mwana wa heni Isaka.’ ");
INSERT INTO vid_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Na heni nandimlonjela mkulu wa heni, ‘Hanji mdala ayo kolema kilongoza na heni kuya kuno.’ ");
INSERT INTO vid_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Ila heye nakalonga, ‘Gwaa Mkulu Nguluwi yalingundongoza mli ukomu wa heni, komlajiza mhilisi wa heye yalute hamwe nagwe na kukudita usumye kuli majendo ga hegwe, nagwe kumholela mwana wa heni mdala kulawa kwa ivyazi lyangu na ng'handa ya mhaza wa heni. ");
INSERT INTO vid_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Wone houfika kwa ivyazi lyangu na hawokupa ayo mhinza, lelo huchibatigwa hebu na kilaha kwa heni.’ ");
INSERT INTO vid_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","“Lehano lofichile kuli nzasa, nandanda, ‘Gwaa Mkulu Nguluwi, Nguluwi wa mkulu wa heni Abulahamu, ndangulanda usumye goya lehano kuli majendo ga heni. ");
INSERT INTO vid_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Nda ahano hafungo mwa nzasa. Mhinza yokuya kudeha mazi ndo yondimlanda yangalile mazi mado ga kunwa kulawa mchiya cha heye, ");
INSERT INTO vid_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","na heye nakanjidila na kuwadehela mazi ngamiya wa heni, lelo ayo na ndo yahaguligwe na Mkulu Nguluwi yawe mdala wa mwana wa mkulu wa heni.’ ");
INSERT INTO vid_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","“Londing'hali sinda kulanda mnhumbula ya heni, baho du Lebeka nakafika na chiya cha heye cha mazi mmayega, nakidulisa kuli nzasa na kudeha mazi. Na heni nandimlonjela, ‘Dedede ndangulanda mazi ga kunwa.’ ");
INSERT INTO vid_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Na heye nakenenula chiya himahima kulawa mmayega mwa heye, na kulonga, ‘Lelo unwe mkulu wa heni. Nandowawichila mazi na ngamiya wa hegwe kahi.’ Lelo heni nyinwa na ngamiya wa heni nawo nakawapa mazi. ");
INSERT INTO vid_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Ndo nambuza, ‘Ndaze, hegwe kwa mhinza wa whaani?’ Nakandonjela, ‘Heni nda mhinza wa Betueli, mwana Milika, mchewake Naholi.’ Aho ndo hondimpele pete ndodo ya kuwika mmenyhelo na kumvaliza banjili mmoko. ");
INSERT INTO vid_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Hamba nandimfugamila na kumtogola Mkulu Nguluwi, Nguluwi wa mkulu wa heni Abulahamu, yawele yondongoza kwa nzila igoloche mbaka kwa mhinza wa lukolo lwa mkulu wa heni kwa mbuli ya mwanage. ");
INSERT INTO vid_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Lelo mndonjele kota mkunda kumditila igano lya kwimilila na makundo kwa mkulu wa heni, wone hebu, lelo mlonje, nani ndovizela cha kudita.” ");
INSERT INTO vid_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Loyahuliche ago, Labani na Betueli nawamwidichila, “Mbuli ayi nailawa kwa Mkulu Nguluwi, hetwe hatuweza kulonga choneche. ");
INSERT INTO vid_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Lebeka ayu baha, umhole ulute. Na yawe mdala wa mwana wa mkulu wa hegwe kota Mkulu Nguluwi navyoyalonjile.” ");
INSERT INTO vid_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Chitumagwa wa Abulahamu loyahuliche ulonzi awo, nakamwinamila Mkulu Nguluwi. ");
INSERT INTO vid_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Hamba nakalavya vinhu vilingupulika na zahabu na nguwo, nakamha Lebeka. Kahi nakawapa wakulugwe na mayake Lebeka vinoliga vya sendi nyinji. ");
INSERT INTO vid_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Chitumagwa wa Abulahamu na wanhu woyoyile nawo walya na kunwa na kuwasa kuko. Lowalilimche mitondo, chitumagwa yula nakalonga, “Ndangulanda kuhiluka kwa mkulu wa heni.” ");
INSERT INTO vid_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Ila mkulugwe na mayake Lebeka nawalonga, “Umleche mhinza yekale na hetwe mhela udo hela, kota mazuwa kumi hino, hamba koluta.” ");
INSERT INTO vid_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Ila heye nakalonga, “Dedede, mleche kung'hawiza, kwa vila Mkulu Nguluwi mina kagadita goya majendo ga heni, ndangulanda mng'hundize nyhiluche kwa mkulu wa heni.” ");
INSERT INTO vid_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Na hewo wedichila, “Lelo tumcheme mhinza tumuuze.” ");
INSERT INTO vid_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Nawamchema Lebeka na kumuuza, “Ndaze, koluta na munhu ayu?” Na heye nakedichila, “Ndoluta.” ");
INSERT INTO vid_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Lelo nawamleka Lebeka yalute na chitumagwa wa Abulahamu na wanhu wa heye. Chitumagwa mdala yamhembulize lumbulye Lebeka kulawila yavumbuche naye nakalutasa na heye. ");
INSERT INTO vid_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Lelo nawamtambichiza Lebeka wolonga, “Hegwe lumbuliyetu. Uwe mamo wa maelufu kwa maelufu, walelwa wa hegwe waihalile miji ja wang'honyo wa hewo.” ");
INSERT INTO vid_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Hamba Lebeka na vitumagwa wadala wa heye nawakwina ngamiya na kumuwinza chitumagwa ayo wa Abulahamu, na hewo weng'ha woka. ");
INSERT INTO vid_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Mhela awo, Isaka nayali yochile Beeli-lahai-loi, nakawa yochikala ako nzingo ya Negebu. ");
INSERT INTO vid_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Zuwa limwe matinazo, Isaka nakaluta kumgunda kijesa. Lelo nakalola nakona ngamiya wanguya. ");
INSERT INTO vid_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Na heye Lebeka loyalolile na kumona Isaka, nakedulika kulawa kuli ngamiya, ");
INSERT INTO vid_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","na kumuuza chitumagwa wa Abulahamu, “Ka whaani yula yalingujenda kula kumgunda, kanguya kutubochela?” Yula chitumagwa nakalonga, “Ka mkulu wa heni.” Lelo Lebeka nakahola igubiko lyake na kigubika kumeho. ");
INSERT INTO vid_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Yula chitumagwa nakamsimila Isaka geng'ha goyagaditile. ");
INSERT INTO vid_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Lelo Isaka nakamhola Lebeka mng'handa mwa chibumuli cha Sala mayake, kawa mchewake. Isaka nakamgana Lebeka kwa kumhembuliza loyabagame mayake. ");
INSERT INTO vid_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Abulahamu namkahola mdala yunji, itagwa lyake lyali Ketula. ");
INSERT INTO vid_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Ketula nakampondela Abulahamu wana awa, Simulani na Yokishani na Medani na Midiani na Ishibaki na Shua. ");
INSERT INTO vid_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Yokishani nayali mhaza wa Sheba na Dedani, na walelwa wa Dedani wali Ashulu na Aletushi na Aleumi. ");
INSERT INTO vid_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Wana wa Midiani wali Efa na Efeli na Enoki na Abida na Elidaa. Weng'ha awo wali walelwa wa Ketula. ");
INSERT INTO vid_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Abulahamu nakamhaliza Isaka lufufu lwake lweng'ha. ");
INSERT INTO vid_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Ila wana wa wahawake wanji wa Abulahamu nakawapa ndolendole, na mhela loyali yang'hali mkomu, nakawahilika kuli isi ya kolilawilaga isanya, kutali na mwanage Isaka. ");
INSERT INTO vid_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Abulahamu nakekala miyaka miya imwe makumi saba na jihano. ");
INSERT INTO vid_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Abulahamu nakabagama naloyekale kwa mihela minji lukami na ja kuhega, nakaza kilumba na wasekulu wa heye wamlongole. ");
INSERT INTO vid_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Isaka na Ishimaeli, wanage Abulahamu, wamtila mhaza wa hewo kuli ipalika lya Makipela, behi na Mamle kuli mgunda nauwele wa Efuloni, mwana wa Sohali Mhiti. ");
INSERT INTO vid_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Abulahamu nayali yagulile mgunda awo kwa Wahiti, kuko du ndo kowatiligwe Abulahamu na mdala wa heye Sala. ");
INSERT INTO vid_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Loyabagame Abulahamu, Nguluwi nakamtambichiza Isaka mwanage. Na heye Isaka kawa yochikala behi na nzasa ya Beeli-lahai-loi. ");
INSERT INTO vid_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Ayi ndo mbuli ya walelwa wa Ishimaeli mwanage Abulahamu yapondigwe na Hagali Mmisili nayawele chitumagwa mdala wa Sala. ");
INSERT INTO vid_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Aga ndo matagwa gawo kota vyowapondigwe, Nebayoti mlelwa wa mwaluko, na wanji ndo Kedali na Adibeli na Mibisamu ");
INSERT INTO vid_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","na Mishima na Duma na Masa ");
INSERT INTO vid_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","na Hadadi na Tema na Yetuli na Nafishi na Kadema. ");
INSERT INTO vid_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Awo ndo wana wa Ishimaeli, nawawele vilongozi wa nhanzi kumi na mbili, howali kikala na vijiji vya hewo navizeleka kwa matagwa gawo. ");
INSERT INTO vid_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Ishimaeli nayali na miyaka miya imwe makumi gadatu na saba nakabagama, nakaza kilumba na wasekulu wa heye wamlongole. ");
INSERT INTO vid_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Walelwa wa Ishimaeli nawekala kuli honhu hawele hagati ha Havila na Shuli, behi na Misili, kulutilila Ashulu. Nawekala wehilwe na ivyazi linji lya Abulahamu. ");
INSERT INTO vid_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Ayi ndo mbuli ya walelwa wa Isaka mwana wa Abulahamu. ");
INSERT INTO vid_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Isaka naloyawele na miyaka makumi gane, nakamhola Lebeka mhinza wa Betueli, Mwalamu wa Padani-alamu. Lebeka nayali lumbulye Labani. ");
INSERT INTO vid_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Lebeka nayali mhende, lelo Isaka nakamlanda Mkulu Nguluwi. Na heye Mkulu Nguluwi nakakunda kulanda kwa heye, Lebeka nakawa na himila. ");
INSERT INTO vid_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Himila ayo nayali ya wanyambili. Wana awo nawali wochilewa mmunda mwa Lebeka, na heye nakalonga, “Wone hino ndo vyozili mbuli azi, ya choni kuwa mkomu?” Lelo nakaluta kumuuza Mkulu Nguluwi. ");
INSERT INTO vid_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Mkulu Nguluwi nakamlonjela, “Wanhu wa nhanzi mbili za mmunda mwa hegwe, nhanzi mbili zopondigwa na hegwe, zochibagula. Imwe yowa na ludali kusinda yinji, mkulugwe kowa chitumagwa wa mdodowe.” ");
INSERT INTO vid_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Mazuwa ga kuponda logafichile, Lebeka nakaponda wanyambili. ");
INSERT INTO vid_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Wa mwaluko nayali mdung'hu lukuli lweng'ha kota ikoti idung'hu ligongomanyigwe kwa milaika ja migongolo, ahyo nawamchema Esau. ");
INSERT INTO vid_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Wa keli nakapondigwa yamibate Esau chisigino, ahyo nawamha itagwa lya Yakobo. Isaka nayali yawele na miyaka makumi sita mhela Esau na Yakobo lowapondigwe. ");
INSERT INTO vid_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Wana awo nawakula, Esau kawa mpelembi ng'hatu, yaganile kikala kisolo, na Yakobo nakawa munhu yaholile na yawele ngugana kikala haluga. ");
INSERT INTO vid_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Lelo Isaka nakamgana Esau kwa vila yaliyogana kulya upelembi wa heye woyali yochigala, ila Lebeka nakamgana Yakobo. ");
INSERT INTO vid_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Zuwa limwe, Yakobo loyawele yoteleka chilyo, Esau nakahiluka haluga kulawa kuupelembi yawele na nzala lukami. ");
INSERT INTO vid_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Ahyo Esau nakamlonjela Yakobo, “Ndangubagama na nzala, dedede, umhe muhuzi awo udung'hu nyinwe, mina nhoka.” Ahyo Esau nakachemigwa Edomu izeleche kota ndung'hu. ");
INSERT INTO vid_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Yakobo nakedichila, “Tandi unguzile honhu ha uhalizi wa hegwe wa ulelwa wa hegwe wa mwaluko.” ");
INSERT INTO vid_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Esau nakalonga, “Goya! Ndahabehi kubagama, hachi ya heni ya ulelwa wa mwaluko yonhanza choni?” ");
INSERT INTO vid_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Yakobo nakamlonjela, “Wilahe tandi.” Aho Esau nakelaha na kumguzila Yakobo honhu ha uhalizi wa ulelwa wa mwaluko. ");
INSERT INTO vid_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Ndo Yakobo nakamha Esau ibumunda na muhuzi wa mpanda. Esau nakalya na kanwa, hamba koka, kaluta nakoyalawile. Ahyo ndo Esau navyoyaibezile hachi ya heye ya ulelwa wa mwaluko. ");
INSERT INTO vid_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Hamba nailawila nzala muisi yila, nzala ilivinji na aho katali mhela wa ukomu wa Abulahamu. Isaka nakaluta Gelali kwa Abimeleki mndewa wa Wafilisti. ");
INSERT INTO vid_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Mkulu Nguluwi nakamlawila Isaka na kumlonjela, “Uleche kuluta Misili, ila wikale kuli isi yondikulonjela. ");
INSERT INTO vid_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Wikale kuujenzi kuli isi ayo, na heni ndowa hamwe na hegwe na kukutambichiza. Ndokwimilila ilagano nalondimpele mhaza wa hegwe Abulahamu, ahyo ndokupa hegwe na lulelo lwako isi azi zeng'ha. ");
INSERT INTO vid_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Ndokonjezela lulelo lwako luwe kota nhondwe za kilanga na kuwapa isi azi zeng'ha. Kwa kukolela lulelo lwako, wanhu wa isi zeng'ha muisi wotambichizwa. ");
INSERT INTO vid_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Kwa vila Abulahamu nakanyhulichiza heni, nakakunda mizilo ja heni na malajizo ga heni na malanguso ga heni na utaguso wa heni.” ");
INSERT INTO vid_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Lelo Isaka nakekala ako Gelali. ");
INSERT INTO vid_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Wanhu wa ako nalowamuuzile mbuli za mchewake, heye nakedichila, “Ayu ka lumbulyangu.” Nakadumba kulonga kota kamchewake kwa kudumba kota wanhu wa isi yila wahamkopole kwa chiwalo cha Lebeka, mina Lebeka nakanoga lukami. ");
INSERT INTO vid_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Naloyekale ako kwa miyaka minji, Abimeleki mndewa wa Wafilisti nakasunjilila mitubuli nakamona Isaka yomkumbatila mchewake Lebeka. ");
INSERT INTO vid_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Abimeleki nakamchema Isaka na kumlonjela, “Hambi ayu kamchewako. Lekachoni nakulonga kalumbulyo?” Isaka nakedichila, “Kwa vila nandumba kota ndahakopoligwe kwa chiwalo cha heye.” ");
INSERT INTO vid_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Abimeleki nakamuuza, “Ndo mbuli yachi youtuditile? Yumwe wa wanhu wa heni yahawasile na mchewako, ndangijesa nagwe wahatwambuze kudita gehile.” ");
INSERT INTO vid_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Ndo baho Abimeleki nakawalonjela wanhu weng'ha yolonga, “Yoneche yomdoliza munhu ayu ama mchewake, ndangukomya kokopoligwa.” ");
INSERT INTO vid_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Mhela awo Isaka nakanyala nyhadikwa kuli isi yila, nakabeta vya kuhega ng'hatu, mina Mkulu Nguluwi nakamtambichiza, ");
INSERT INTO vid_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","na heye nakawa munhu yawele na lufufu. Nakalutilila kuwa na lufufu mbaka kawa yawele na lufufu ng'hatu. ");
INSERT INTO vid_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Kwa vila nayali yawele na chilundo cha ming'holo na misenga na vitumagwa wenji, Wafilisti nawamonela fihi. ");
INSERT INTO vid_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Wafilisti wali watilile mizimbo jeng'ha ja mazi jila vitumagwa wa Abulahamu, mhaza wa heye, nawabawile mhela naloyang'hali mkomu. ");
INSERT INTO vid_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Ndo baho Abimeleki nakamlonjela Isaka, “Uche hetu, kwa vila hegwe kuna ludali luhejile kusinda hetwe.” ");
INSERT INTO vid_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Lelo Isaka nakoka ako, nakazenga kambi kuli ibindi lya Gelali, nakekala ako. ");
INSERT INTO vid_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Isaka nakadikula jila mizimbo najibawigwe na mhaza wa heye Abulahamu naloyawele yang'hali mkomu, mizimbo jila Wafilisti nawatilile mhela Abulahamu naloyabagame. Nakajipa matagwa gagala nayajipele mhaza wa heye. ");
INSERT INTO vid_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Ila vitumagwa wa Isaka nalowabawile kuli ibindi, nawaifika nzasa ilingulavya mazi, ");
INSERT INTO vid_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","wadimi wa aho Gelali nawelewa na wadimi wa Isaka wolonga, “Mazi aga ndo ga hetwe.” Ahyo Isaka nakalichema izimbo alyo Eseki. Izeleche kilewa. ");
INSERT INTO vid_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Hamba nawabawa izimbo linji, nalyo kahi nawelewela, ahyo Isaka nakalichema izimbo alyo Sitina. Izeleche kota ung'honyo. ");
INSERT INTO vid_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Hamba Isaka nakaluta honhu hanji na kubawa izimbo linji. Ila alyo nahawalewele, ahyo Isaka nakalichema Lehoboti yolonga, “Lelo Mkulu Nguluwi katulechela honhu, natwe tokonjezeka kuli isi ayi.” ");
INSERT INTO vid_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Kulawa ako, Isaka nakaluta Beeli-sheba. ");
INSERT INTO vid_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Nechilo yiyo Mkulu Nguluwi nakalawila na kumlonjela, “Heni nda Nguluwi wa mhaza wa hegwe Abulahamu. Uleche kudumba kwa vila nda hamwe na hegwe, ndokutambichiza na kukonjezela lulelo lwako kwa mbuli ya Abulahamu, chitumagwa wa heni.” ");
INSERT INTO vid_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Ahyo Isaka nakazenga honhu ha kulavila nhambiko ako na nakamfugamila Mkulu Nguluwi nakachimika ihema na kwesela kwa mhela udo ako, na vitumagwa wa heye nawabawa izimbo. ");
INSERT INTO vid_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Abimeleki nakalawa Gelali yawele hamwe na Ahusati munhu wa heye wa habehi ng'hatu, na Fikoli mkulu wa wamizi, nakamlutila Isaka. ");
INSERT INTO vid_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Isaka nakawauza, “Lekachoni muya kwa heni, hanga mlingunzudila na mmbinga kwa hemwe?” ");
INSERT INTO vid_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Hewo nawamwidichila, “Natona hazelu kota Mkulu Nguluwi kahamwe na hegwe. Ahyo natikundiza yangugana tuwiche chilaho hamwe na hegwe na kuwika ilagano, ");
INSERT INTO vid_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","kota hotudumya, hetwe hihyo hotukudumya. Natukuditila ganojile, natukuleka ulute goya, ne kukuditila chinhu choneche chihile. Na sambi hegwe kwa mtambichizwa wa Mkulu Nguluwi.” ");
INSERT INTO vid_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Lelo Isaka nakawawichila chilyo cha mnvina, nawo walya na kunwa. ");
INSERT INTO vid_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Mitondo, nawalilimka ng'hanu hananya na kilaha. Hamba Isaka nakawasindichiza na kilaga nawo goya. ");
INSERT INTO vid_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Zuwa lilila vitumagwa wa Isaka nawamuyila na kumlonjela mbuli ya lila izimbo nalowali wabawile, wolonga, “Tugafika mazi.” ");
INSERT INTO vid_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Lelo Isaka nakalichema izimbo ali Shiba, kwa vila itagwa lya muji awo ndo Beeli-sheba mbaka lehano. ");
INSERT INTO vid_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Esau naloyali na miyaka makumi gane, nakahesa wadala weli Wahiti, Yuditi mhinza wa Beeli, na Basemati mhinza wa Eloni. ");
INSERT INTO vid_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Wadala awo nawawadita Isaka na Lebeka wekale kwa usungu. ");
INSERT INTO vid_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Isaka nakalala lukami na meho gali hambe galole. Lelo nakamchema Esau mwanage mkulu, nakamlonjela, “Mwana wa heni.” Na heye nakedichila, “Ena mhaza, ndanguhulichiza.” ");
INSERT INTO vid_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Isaka nakalonga, “Ulole, heni ndala lukami, ne zuwa lya kubagama siizelele. ");
INSERT INTO vid_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Lelo uhole misale na upinde wa hegwe, ulute kisolo kapelembe igongolo. ");
INSERT INTO vid_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Hamba unditile ndiya inonile, undigalile ndiye, nene baha ndikutambichize nding'hali kubagama.” ");
INSERT INTO vid_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Hambi, mhela awo Isaka naloyali yolongasa na mwanage Esau, Lebeka nayali yohulichiza. Ahyo, Esau naloyalutile kisolo kupelemba igongolo na kuligala, ");
INSERT INTO vid_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Lebeka nakamlonjela mwanage Yakobo, “Nandimhulika mhaza wa hegwe yomlonjela mkulugo Esau, ");
INSERT INTO vid_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","yampelembile igongolo na yamditile chilyo chinonile ng'hatu, leka yalye, hamba yamtambichize hali Mkulu Nguluwi naloyang'hali kubagama. ");
INSERT INTO vid_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Lelo mwana wa heni, uhulichize ulonzi wa heni na uwinze kota vyondilikulajiza. ");
INSERT INTO vid_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Ulute hali chilundo cha mhene, ukengalile vinyehe vya mhene vili vinojile, ndimditile mhaza wa hegwe chilyo chinojile, chila choyogana. ");
INSERT INTO vid_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Hamba komhilichila mhaza wa hegwe yalye, leka yakutambichize loyang'hali kubagama.” ");
INSERT INTO vid_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Ila Yakobo nakamlonjela mayake Lebeka, “Ukumbuchile kota mkulu wangu Esau kamema milaika mlukuli, ila heni ndahela. ");
INSERT INTO vid_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Hanji mhaza kogana kwabasa mlukuli lwangu, nani ndokoneka kota ndangumhada, ahyo ndochigalila kipanjila honhu ha utambichizo.” ");
INSERT INTO vid_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Mayake nakamlonjela, “Kupanjilwa kwa hegwe na kuye kwa heni, mwana wa heni, hegwe udite vyondilikukulajiza. Ulute ukengalile avyo vinyehe.” ");
INSERT INTO vid_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Lelo Yakobo nakaluta, nakahola vila vinyehe na kimigalila mayake, na heye nakadita chilyo chinonile ng'hatu, chila nachoyaganile mhaza wa heye Isaka. ");
INSERT INTO vid_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Hamba Lebeka nakahola nguwo za Esau zinojile lukami, zoyawele nazo mwanage mkulu, nakumvaliza mwanage mdodo Yakobo. ");
INSERT INTO vid_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Kahi nakamvaliza migozi ja vila vinyehe mmoko na honhu hadechedeche msingo ya heye. ");
INSERT INTO vid_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Hamba Lebeka nakamha Yakobo chila chilyo chinonile na ibumunda nalyoyamditile. ");
INSERT INTO vid_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Lelo Yakobo nakenjila mng'handa mwa mhaza wa heye, na kumchema, “Mhaza” Na heye nakedichila, “Ena. Kwa whaani hegwe mwana wa heni?” ");
INSERT INTO vid_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Yakobo nakamwidichila mhaza wa heye, “Nda heni Esau, mlelwa wa hegwe wa mwaluko. Ndita kota vyoundajize. Dedede mhaza, wikale ulye upelembi wa heni leka unhambichize.” ");
INSERT INTO vid_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Ila Isaka nakamuuza, “Iwa ndaze kupelemba himahima hino, mwana wa heni?” Yakobo nakamwidichila, “Mkulu Nguluwi, Nguluwi wa hegwe, nakandita sumye.” ");
INSERT INTO vid_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Ndo baho Isaka nakamlonjela Yakobo, “Lelo mwana wa heni uhejele behi ndikwabase leka ng'hunde kota hegwe kwa heye mwana wa heni Esau ama hebu.” ");
INSERT INTO vid_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Yakobo nakamhejelela mhaza wa heye Isaka, na heye nakamwabasa na kulonga, “Luzi ndo lwa Yakobo, ila moko ndo ga Esau.” ");
INSERT INTO vid_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Nahamzelele kwa vila moko ga heye gali na milaika minji kota ja Esau mkulugwe, ahyo nakewika goya kumtambichiza. ");
INSERT INTO vid_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","Nakamuuza kahi, “Kwangukomya ng'hatu hegwe ndo kwa mwana wa heni Esau?” Na heye nakamwidichila, “Ena.” ");
INSERT INTO vid_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Mhaza wa heye nakalonga, “Ndigalile alyo liwunde ndiye upelembi wa hegwe, mwana wa heni, ndikutambichize.” Aho Yakobo nakamhilichila ndiya, naye nakalya, nakamhilichila divai kahi, nakanwa. ");
INSERT INTO vid_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Ndo mhaza wa heye Isaka, nakamlonjela, “Uhejele habehi mwana wa heni, unonele.” ");
INSERT INTO vid_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Lelo Yakobo nakamhejelela mhaza wa heye na kumnonela, na mhaza wa heye loyahuliche kunhunyhilila kwa mivalo ja heye, nakamtambichiza yolonga, “Kunhunyhilila kwa mwana wa heni, ndo kota kunhunyhilila kwa mgunda woyautambichize Mkulu Nguluwi! ");
INSERT INTO vid_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Nguluwi yakujidile nhungwi ya kilanga, yakupe misanga jiwele na mboto, nyhule na zabibu kwa winji. ");
INSERT INTO vid_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Nhanzi za wanhu ziwe chitumagwa kwa hegwe, na wanhu wa isi wakinamizile. Uwe chilongozi wa wang'holozo, na lulelo lwa mayako lukinamizile. Chila yokupanjila, nayapanjilwe, chila yokutambichiza, yatambichizwe!” ");
INSERT INTO vid_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Isaka loyasindile kumtambichiza Yakobo, na heye Yakobo loyali yokuka hela kumwando ha mhaza wa heye Isaka, Esau mkulugwe Yakobo, nakahiluka kulawa kuupelembi. ");
INSERT INTO vid_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Esau kahi nakadita chilyo chinonile, na kumhilichila mhaza wa heye, na kumlonjela, “Ena mhaza, winuche ulye upelembi wa heni mwanago, leka unhambichize” ");
INSERT INTO vid_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Isaka nakauza, “Hegwe kwa whaani?” Na heye nakamwidichila, “Nda heni mwanago Esau, mlelwa wa hegwe wa mwaluko.” ");
INSERT INTO vid_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Aho Isaka nakakakama lukami, nakalonga, “Ka whaani lelo yula yapelembile na kingalila upelembi, nani mina ndiya, kahi mina ndimtambichiza hegwe hunoya? Ena na kotambichizwa.” ");
INSERT INTO vid_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Esau loyahuliche ulonzi wa mhaza wa heye, nakaluka kulila kwa usungu. Hamba nakamlonjela mhaza wa heye, “Mhaza wa heni, dedede unhambichize na heni!” ");
INSERT INTO vid_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Ila Isaka nakalonga, “Mng'holozo nakoya chiuhadi, naye kahola utambichizo wa hegwe.” ");
INSERT INTO vid_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Esau nakalonga, “Ndo mina kanguchemigwa Yakobo. Kwa vila nakahola honhu hangu lwa keli. Mwaluko nakahola honhu hangu ha ulelwa wa mwaluko, na sambi kahola utambichizo wa heni.” Hamba nakamuuza mhaza wa heye, “Ndaze, hauponile utambichizo woneche ula?” ");
INSERT INTO vid_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Isaka nakamwidichila, “Mina ndimdita Yakobo yawe chilongozi wa hegwe, na ndimpa wang'holozo weng'ha wawe vitumagwa wa heye. Ndimpa nyhule na divai. Ndikuditile choni lelo hegwe mwana wa heni?” ");
INSERT INTO vid_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Esau nakamlonjela mhaza wa heye, “Mhaza, hambi kwanawo utambichizo umwe hela? Unhambichize na heni kahi, mhaza.” Aho Esau nakalila kwa lizi likulu. ");
INSERT INTO vid_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Ndo Isaka mhaza wa heye, nakamlonjela, “Honhu hako ha kuchikala kowa kutali na ulongo uwele na mboto, na kutali na nhungwi ya kilanga. ");
INSERT INTO vid_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Kochikala kwa kitowa ngondo kwa ipanga, na kowa chitumagwa wa mng'holozo, ila lougana kumhinduka, kowa kutali na ulongozi wa heye.” ");
INSERT INTO vid_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Esau baho nakamzudila Yakobo kwa chiwalo cha utambichizo nayapegwe na mhaza wa heye. Esau nakejesa, “Mazuwa ga kuwasiliza chililo cha mhaza gahabehi, mbuli ayo hoimala, baho hondimkopola mdodowangu Yakobo.” ");
INSERT INTO vid_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Ila Lebeka naloyavizelele nachoyogana kudita mwanage mkulu, nakamchema mwanage mdodo Yakobo, na kumlonjela, “Wilolele, mng'holozo Esau kangisangalaza kwa kiwika goya yogana yakukopole. ");
INSERT INTO vid_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Lelo mwana wa heni uhulichize ulonzi wa heni. Uche ubilimile kwa kalumbu Labani akula Halani. ");
INSERT INTO vid_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Wikale na heye kwa mhela udo, mbaka kuzudila kwa mng'holozo hokumala. ");
INSERT INTO vid_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Kuzudila kwa heye hokuhola, na heye hoyowa yasemwile goumditile, ndomlajiza munhu yakuhiluse. Lekachoni filigwe na hemwe mweng'ha weli zuwa imwe?” ");
INSERT INTO vid_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Lebeka nakamlonjela Isaka, “Heni nhoka kikala na awa wadala weli Wahiti wa Esau. Wone Yakobo yohesa yumwe wa wadala awa Wahiti, fola mbagame.” ");
INSERT INTO vid_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Ahyo Isaka nakamchema Yakobo, nakamtambichiza na kumlajiza yolonga, “Uleche kuhesa mdala yoneche Mkanaani. ");
INSERT INTO vid_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Ulute Padani-alamu, hakaye ha sekulu wa hegwe Betueli, kahole yumwe wa wala wahinza wa kolo wa hegwe Labani. ");
INSERT INTO vid_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Nguluwi yawele na mong'ho yakutambichize uwe na walelwa wenji na konjezeka, leka uwe nhanzi ya wanhu wenji. ");
INSERT INTO vid_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Leka yakutambichize hegwe hamwe na walelwa wa hegwe kota navyoyamtambichize Abulahamu, uihole isi youwelengikala kota mjenzi, isi yila Nguluwi yampele Abulahamu!” ");
INSERT INTO vid_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Lelo Isaka nakamlajiza Yakobo, na heye nakaluta Padani-alamu kwa Labani, mwana wa Betueli, Mwalamu. Labani kalumbu wa Lebeka na Lebeka ndo nayawele mayawo Yakobo na Esau. ");
INSERT INTO vid_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Esau nakavizela kota Isaka nakamtambichiza Yakobo na kumlajiza yalute yakahese ako Padani-alamu, na kota loyamtambichize, nakamlemeza yaleche kuhesa mdala Mkanaani. ");
INSERT INTO vid_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Nakavizela kahi kota Yakobo nayali yowahulichiza mayake na mhaza wa heye, nakaluta Padani-alamu. ");
INSERT INTO vid_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Lelo Esau nakavizela kota mhaza wa heye, hawaganile wadala wa Kanaani. ");
INSERT INTO vid_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Ahyo, Esau nakaluta kwa Ishimaeli, mwana wa Abulahamu, nakaza konjeza mdala yunji kwa kumhesa Mahalati mhinza wa Ishimaeli, lumbulyake Nebayoti. ");
INSERT INTO vid_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Yakobo nakoka Beeli-sheba, nakaluta Halani. ");
INSERT INTO vid_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Loyafichile honhu hamwe, nakawasa baho kwa vila isanya nalyali lilutile. Nakahola iganga limwe lya honhu aho, nakawika hasi hali mutwi wa heye, nakawasa. ");
INSERT INTO vid_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Nakalota, na kuli kulota ako, nakona chikwinilo chimizwe muisi na kuduma kwa chikwinilo ufika mbaka kilanga. Wahilisi wa Nguluwi nawali wokwina na kidulika kuli chikwinilo acho. ");
INSERT INTO vid_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Mkulu Nguluwi nakema kuli chikwinilo acho, nakamlonjela, “Heni ndo Mkulu Nguluwi, Nguluwi wa Abulahamu mhaza wa hegwe na Nguluwi wa Isaka. Isi youlinguwasila ndokupa hegwe na lulelo lwako. ");
INSERT INTO vid_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Lulelo lwako lowa lwinji kota sangalaza za muisi na wokwenela chila honhu, kolizibilaga isanya na kolilawilaga isanya na kasikazini na kusini. Kwa kukolela hegwe na lulelo lwako, lukolo lweng'ha muisi lotambichizwa. ");
INSERT INTO vid_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Heni nda hamwe na hegwe, ndokwamila koneche kouluta na kukuhilusa kuli isi ayi. Sikuleka mbaka hondigongomanya ilagano lyondikupele.” ");
INSERT INTO vid_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Ndo Yakobo nakalilimka muusinjizi nakalonga, “Ndangukomya Mkulu Nguluwi ka honhu aha, nani nasivizelele.” ");
INSERT INTO vid_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Yakobo nakadumba nakalonga, “Honhu aha hangudumbiza kota choni. Ne majesa aha ndo ng'handa ya Nguluwi na lwizi lwa kilanga.” ");
INSERT INTO vid_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Yakobo nakalilimka lufuku nakahola lila iganga nayaliwichile hasi ha mutwi, nakalimiza kota izengo na kulijidila mafuta. ");
INSERT INTO vid_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Nakahachema honhu aho Beteli, ila itagwa lya katali lya muji awo nalyali Lusu ");
INSERT INTO vid_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Hamba Yakobo nakelaha yolonga, “Wone hegwe Nguluwi kowa hamwe na heni, na kunyamila kuli majendo ga heni, umha chilyo na nguwo, ");
INSERT INTO vid_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","leka nyiluche kaye goya, lelo hegwe Mkulu Nguluwi kowa ndo Nguluwi wa heni. ");
INSERT INTO vid_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Nalyo iganga ali lyonyimize aha kota izengo, lyowa ng'handa ya hegwe Nguluwi nani ndokupa honhu hamwe ha kumi ha vinhu vyeng'ha vyoumha.” ");
INSERT INTO vid_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Yakobo nakalutilila na majendo ga heye, nakaluta kuli isi ya wanhu wa kolilingulawila isanya. ");
INSERT INTO vid_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Hamba nakona izimbo kuli chiwala, na hafungo hali izimbo alyo kwali na vilundo vidatu vya ming'holo jilingwesela. Ming'holo najali jing'wezwa mazi ga izimbo alyo ligubichigwe na iganga ikulu. ");
INSERT INTO vid_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Vilundo vyeng'ha hoviting'hana hala, wadimi nawoyaga na kulavya iganga alyo kwa kitanza leka wachumule izimbo alyo na kunweza mazi migongolo, hamba nawagubikaga kahi izimbo alyo kwa iganga lilyo. ");
INSERT INTO vid_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Yakobo nakawauza wadimi, “Wang'holozangu, mwangulawila kohi?” Nawamwidichila, “Twangulawila Halani.” ");
INSERT INTO vid_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Na heye nakawauza, “Ndaze, mumzela Labani mwana wa Naholi?” Nawamwidichila, “Twangumzela.” ");
INSERT INTO vid_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Nakalutilila kuwauza, “Ndaze, kalamka?” Na hewo nawamwidichila, “Kalamka, na mhinza wa heye Laheli yula kula kanguya na ming'holo ja heye!” ");
INSERT INTO vid_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Yakobo nakawalonjela, “Ndangona ing'hali nemisi, hauwa mhela wa kujikungajiza ming'holo hamwe. Lelo mjinweze mazi ming'holo, mlute mkajidime.” ");
INSERT INTO vid_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Hewo nawamwidichila, “Hatulingudita ahyo mbaka vilundo vyeng'ha hoviting'hana hamwe na iganga lilavigwa kuli izimbo, aho ndo tojinweza mazi ming'holo.” ");
INSERT INTO vid_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Yakobo loyawele yolonga na wala wadimi, Laheli nayawele mdimi nakafika na ming'holo ja mhaza wa heye. ");
INSERT INTO vid_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Yakobo loyamuwene Laheli, mhinza wa Labani, kalumbu wa mamo wa heye, na loyajiwene ming'holo ja Labani, kolo wa heye, nakaluta kulihejeza lila iganga liwele hala kuli izimbo, nakachinweza mazi chilundo cha ming'holo ja kolo wa heye Labani. ");
INSERT INTO vid_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Hamba Yakobo nakamnonela Laheli na kulila kwa kusangalala. ");
INSERT INTO vid_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Hamba Yakobo nakamlonjela Laheli, kota heye ka yumwe wa lukolo lwa mhaza wa heye, mwana wa Lebeka. Laheli nakabilima hakaye kumlonjela mhaza wa heye. ");
INSERT INTO vid_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Labani loyahuliche mbuli za Yakobo, mwana wa lumbulye, nakabilima kumbochela, na kamkumbatila nakamnonela na kumbochela hakaye ha heye. Yakobo nakamsimila Labani chila chinhu chilawile. ");
INSERT INTO vid_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Labani nakalonga, “Ndikomya, hegwe wa lukolo lwangu, danda imwe na heni!” Yakobo nakekala na heye kwa mhela wa mwezi umwe. ");
INSERT INTO vid_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Zuwa limwe Labani nakamlonjela Yakobo, “Hegwe wa lukolo lwangu, ila ayo yahela mana kota konditila mijito hihi hela. Ndonjele, kwangugana ndikulipe sendi zilinga?” ");
INSERT INTO vid_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Lelo Labani nayali na wahinza weli, mkulu yachemigwe Lea na mdodo yachemigwe Laheli. ");
INSERT INTO vid_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Lea nayali yanojile, ila Laheli nayali yanojile lukami. ");
INSERT INTO vid_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Yakobo nayali yomgana Laheli, ahyo nakamlonjela Labani, “Ndokukolela mijito kwa mhela wa miyaka saba leka ungalile mhinza mdodo wa hegwe Laheli.” ");
INSERT INTO vid_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Labani nakamlonjela, “Yowa goya kukugalila hegwe Laheli, kusinda kumgalila munhu yunji yoneche. Ulutilile kikala na heni.” ");
INSERT INTO vid_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Lelo Yakobo nakamkolela mijito Labani kwa mhela wa miyaka saba kwa chiwalo cha Laheli, ila mhela ula kwa heye nawali kota mazuwa mado, kwa vila nayali yomgana Laheli. ");
INSERT INTO vid_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Hamba Yakobo nakamlonjela Labani, “Mhela wa heni wenela, ahyo ngalile mchewangu.” ");
INSERT INTO vid_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Lelo Labani nakawika goya mnvina na kuwalalika wanhu weng'ha wa ako. ");
INSERT INTO vid_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Ila matinazo, Labani nakamhola Lea, mhinza mkulu wa heye, nakamhilika kwa Yakobo. Yakobo nakawasa na heye. ");
INSERT INTO vid_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Ila Labani nakamlavya Silipa, mpogozi wa heye, yawe mpogozi wa Lea. ");
INSERT INTO vid_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Lokubwemwenzuche, Yakobo nakavizela kota nayali Lea! Lelo nakamuuza Labani, “Nakunditila mbuli yachi? Ndaze, nasikukolile hegwe mijito kwa chiwalo cha Laheli? Lekachoni nakundeteleza?” ");
INSERT INTO vid_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Labani nakedichila, “Hatuditaga ahyo kuli isi ya hetwe ayi, chihendo cha hetwe changulemeza kulongola kuhesigwa mhinza mdodo, aku mkulu yang'hali kuhesigwa. ");
INSERT INTO vid_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Mgongomanyile mnvina Lea kwa mazuwa geng'ha saba, natwe tokugalila Laheli kwa kutukolela mijito mhela wa miyaka saba jinji.” ");
INSERT INTO vid_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Yakobo nakakunda. Yakobo loyamgongomanyile Lea kwa mazuwa saba, Labani nakamgalila Laheli, mhinza wa heye mdodo yawe mchewake. ");
INSERT INTO vid_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Labani nakamlavya Biliha mpogozi wa heye, yawe mpogozi wa Laheli. ");
INSERT INTO vid_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Lelo Yakobo nakawasa na Laheli kahi. Ila Yakobo nakamgana ng'hatu Laheli kusinda Lea, nakamkolela mijito Labani kwa miyaka saba jinji. ");
INSERT INTO vid_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Mkulu Nguluwi loyawene Lea kanguzudilwa, nakamdita yawe na mwana, ila Laheli nayali mhende. ");
INSERT INTO vid_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Lea nakawa na himila, nakaponda mwana msongolo, nakamchema Lubeni, kwa vila nakalonga, “Mkulu Nguluwi nakona kugazika kwa heni, sambi mlume wa heni kongana.” ");
INSERT INTO vid_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Lea nakawa na himila kahi, nakaponda mwana msongolo, nakamchema Simeoni, kwa vila nayali yolonga, “Mkulu Nguluwi nakangalila mwana yunji msongolo kwa vila nakahulika vyondilinguzudilwa.” ");
INSERT INTO vid_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Nakawa na himila kahi, nakaponda mwana msongolo, nakamchema Lawi, kwa vila nayali yolonga, “Mhela uno mlume wa heni kochilumba hamwe na heni, kwa vila ndimpondela wana wasongolo wadatu.” ");
INSERT INTO vid_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Lea nakawa na himila kahi, nakaponda mwana msongolo, nakamchema Yuda, kwa vila nayali yolonga, “Mhela uno ndomtogola Mkulu Nguluwi.” Hamba Lea nakaleka kuponda. ");
INSERT INTO vid_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Laheli loyawene kota hambe yaponde mwana kwa Yakobo, nakamwonela fihi lumbulyake Lea, nakamlonjela Yakobo, “Ngalile wana, wone huditile ahyo, ndobagama.” ");
INSERT INTO vid_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Yakobo nakazudizwa na Laheli na kumlonjela, “Ndaze, heni ndiwa honhu ha Nguluwi yakulemeze kuwa na wana?” ");
INSERT INTO vid_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Laheli nakamwidichila, “Mpogozi wa heni Biliha kabaha. Uwase na heye leka yawe na wana honhu ha heni, nani kahi ndiwe na wana kwa kulawa kwa heye.” ");
INSERT INTO vid_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Ahyo Laheli nakamgalila Yakobo mpogozi wa heye Biliha, yawe kota mchewake, na heye nakawasa na heye. ");
INSERT INTO vid_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Biliha nakawa na himila nakampondela Yakobo mwana msongolo. ");
INSERT INTO vid_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Laheli nakalonga, “Nguluwi nakanhagusa goya, nakahulika chililo cha heni na kungalila mwana msongolo.” Nakamchema mwana ayo Dani. ");
INSERT INTO vid_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Biliha mpogozi wa Laheli, nakawa na himila kahi na nakampondela Yakobo mwana wa keli msongolo. ");
INSERT INTO vid_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Aho Laheli nakalonga, “Natitowa lukami na lumbulyangu, nani sumya.” Ahyo nakamchema mwana ayo Nafutali. ");
INSERT INTO vid_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Lea loyawene nakaleka kuponda, nakamhola mpogozi wa heye Silipa, nakamgalila Yakobo leka yawe kota mchewake. ");
INSERT INTO vid_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Silipa nakampondela Yakobo mwana msongolo. ");
INSERT INTO vid_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Lea nakalonga, “Mbuli zangundutila goya.” Ahyo nakamchema mwana ayo Gadi. ");
INSERT INTO vid_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Silipa mpogozi wa Lea, nakampondela Yakobo mwana wa keli msongolo. ");
INSERT INTO vid_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Lea nakalonga, “Ndangusangalala! Lelo wadala wonyhema heni kusangalala.” Ahyo, nakamchema mwana ayo Asheli. ");
INSERT INTO vid_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Nawali mhela wa mbena ya ngano, Lubeni nakaluta kisolo na ako nakahola ifuza lilinguchemigwa mituletule, nakamgalila mayake, Lea. Laheli nakamlonjela Lea, “Dedede, ngalile jimwe ja ajo mituletule ja mwanago.” ");
INSERT INTO vid_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Ila Lea nakalonga, “Ndaze, kwangujesa ndo mbuli ndodo kumhola mlume wa heni, na sambi kwangugana kuhola mituletule ja mwana wa heni?” Laheli nakamwidichila, “Loungalila mituletule ja mwanago, Yakobo kowasa kwa hegwe lehano.” ");
INSERT INTO vid_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Lelo matinazo Yakobo loyawele yohiluka kulawa kumgunda, Lea nakalawa kumbochela, nakamlonjela, “Ndimha mituletule ja mwanangu, ahyo kwanguganigwa kuwasa na heni.” Ahyo Yakobo nakawasa kwa Lea nechilo ayo. ");
INSERT INTO vid_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Nguluwi nakahulichiza kulanda kwa Lea, na heye nakawa na himila nakampondela Yakobo mwana wa kahano msongolo. ");
INSERT INTO vid_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Lea nakalonga, “Nguluwi nakangalila chonolo cha heni kwa vila nandimpa mlume wa heni mpogozi wa heni.” Lelo nakamchema mwana ayo Isakali. ");
INSERT INTO vid_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Lea nakawa na himila kahi nakampondela Yakobo mwana wa sita msongolo. ");
INSERT INTO vid_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Lea nakalonga, “Nguluwi nakangalila ndolendole inojile. Lelo mlume wa heni konyhulichiza kwa vila nandimpondela mwana wa sita msongolo.” Ahyo nakamchema mwana ayo Sebuluni. ");
INSERT INTO vid_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Hamba nakaponda mwana mhinza nakamchema Dina. ");
INSERT INTO vid_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Hamba Nguluwi nakamkumbuchila Laheli, nakahulichiza kulanda kwa heye nakamdita yawe na wana. ");
INSERT INTO vid_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Laheli nakawa na himila, nakaponda mwana msongolo, nakalonga, “Nguluwi nakambusila soni ya heni.” ");
INSERT INTO vid_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Ahyo nakamchema mwana ayo Yusufu, yolonga, “Mkulu Nguluwi nayanyonjezele mwana yunji msongolo.” ");
INSERT INTO vid_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Laheli loyampondile Yusufu, Yakobo nakamlonjela Labani, “Ng'hundize nyiluche hakaye hangu, hali isi ya heni. ");
INSERT INTO vid_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Ngalile wadala wa heni na wana wa heni wapondigwe kwa kukukolela mijito hegwe, mbuche na hewo. Kwanguvizela kota nandikukolela mijito goya.” ");
INSERT INTO vid_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Ila Labani nakamlonjela, “Ng'hundize kwa uganililo nani ndonje. Ndivizela kwa kulagula kota Mkulu Nguluwi nakamha utambichizo kwa chiwalo cha hegwe. ");
INSERT INTO vid_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Ulonje sendi zilinga, nani ndokugalila.” ");
INSERT INTO vid_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Yakobo nakamlonjela, “Hegwe kwanguvizela ndaze vyondikukolele mijito, na ndaze vyondijilolele migongolo ja hegwe. ");
INSERT INTO vid_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Kwa vila londing'hali kuya kuno nawali na lufufu ludo hela ila kulawa lofichile, lufufu lwa hegwe lonjezeka ng'hatu, na Mkulu Nguluwi nakakutambichiza chila hondilinguluta. Ila sambi ndowalolela nili wang'holozangu?” ");
INSERT INTO vid_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Labani nakamuuza, “Ndikugalile choni?” Yakobo nakamwidichila, “Humha chinhu choneche. Ndolutilila kujilolela migongolo ja hegwe wone konditila mbuli ayi. ");
INSERT INTO vid_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Ng'hundize ng'hole hagati hali migongolo ja hegwe jeng'ha lehano, ndibagule hali ilundo chila ing'holo lyana liwele na usalagwe na utoletole na chila ing'holo lyana lititu na chila mhene iwele na usalagwe na utoletole. Azo ndo zowa sendi za heni. ");
INSERT INTO vid_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Ahyo, mazuwa galinguya, kutanganika kwa heni kokoneka hazelu hala hondipegwa sendi za heni. Mhene yoneche yohaiwele na utoletole ama ing'holo lyana lyoneche lyohaliwele lititu likoneka hali ilundo lya heni, alyo lyowa lihizigwa.” ");
INSERT INTO vid_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Labani nakalonga, “Goya! Na iwe kota vyoulonjile.” ");
INSERT INTO vid_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Ila Labani zuwa lilyo nakaluta kujibagula mipongo jeng'ha jiwele usalagwe na utoletole na mhene zinji ndala ziwele na utoletole na usalagwe na uzelu na chila ing'holo lyana lititu na nakaziwika hali wamizi wa wanage leka jiwe ja Yakobo. ");
INSERT INTO vid_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Migongolo ja Labani na migongolo ja Yakobo najibaguligwa kwa utali wa kujenda mazuwa gadatu. Yakobo nakapona bahala yodima migongolo ja Labani jiponile. ");
INSERT INTO vid_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Lelo Yakobo nakahola fito za migodi jidatu jilivinji nakajibadula mibadu leka misitali mizelu joneche kuli fito azo. ");
INSERT INTO vid_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Nakazimiza fito azo zoyazibadule hali migongolo hali mibuli ja kunwezela mazi, honhu hawele migongolo najuya kunwa mazi, ");
INSERT INTO vid_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","migongolo milume najikwina midala najiwa na nyinda hali fito azo, najilela migongolo jinji jiwele na usalagwe na utoletole. ");
INSERT INTO vid_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Yakobo nakajibagula ajo ming'holo myana, hamba nakajilajila kuli migongolo jiwele na usalagwe na mititu kuli chilundo cha Labani. Kwa nzila ino, Yakobo nakawa na chilundo cha heye yuye, na hambe yahanzile na chilundo cha Labani. ");
INSERT INTO vid_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Naiwa chila mhela wa migongolo jinenehe kuhola nyinda, Yakobo nakawikaga fito azo kumwando mwa ajo migongolo hali mibuli ja kunwezela mazi, leka wahole nyinda hali fito azo. ");
INSERT INTO vid_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Ila nahawichile fito azo kumwando mwa migongolo jiwele ng'hochele lojali jihola nyinda. Baho du, migongolo jigandile najali ja Labani, na migongolo jinenehe najali ja Yakobo. ");
INSERT INTO vid_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Lelo Yakobo nakawa na lufufu lukami, nakawa na vilundo vikulu vya migongolo na wakolamijito wa heye wadala na walume na ngamiya na midogowi. ");
INSERT INTO vid_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Lelo Yakobo nakahulika kota wana wasongolo wa Labani nawali wolonga, “Yakobo nakahola chila chinhu cha mhaza wa hetwe, na ndo kawa na lufufu.” ");
INSERT INTO vid_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Yakobo kahi nakavizela kota Labani sambi hamganile heye kota aho hamwande. ");
INSERT INTO vid_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Hamba Mkulu Nguluwi nakamlonjela Yakobo, “Uhiluche kuli isi ya wasekulu wa hegwe na ivyazi lyako, nani ndowa hamwe na hegwe.” ");
INSERT INTO vid_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Lelo Yakobo nakagana Laheli na Lea wachemigwe, na hewo nawaluta ako kuchiwala koyawele yodima ming'holo. ");
INSERT INTO vid_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Yakobo nakawalonjela, “Ndangona kota mhaza wa hemwe hambe yangane heni kota aho hamwande. Ila Nguluwi wa mhaza wa heni kahamwe na heni. ");
INSERT INTO vid_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Hemwe mvizela kota nandimkolela mijito mhaza wa hemwe kwa mong'ho wa heni weng'ha ");
INSERT INTO vid_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Ila heye nakanyhada na kugalula sendi za heni mala kumi. Ila Nguluwi nahamkundize heye kundumiza heni. ");
INSERT INTO vid_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Hala mhaza wa hemwe hoyali yolonga, ‘Migongolo jiwele na usalagwe ndo jowa sendi za hegwe,’ lelo chilundo cheng'ha nachilela migongolo jiwele na usalagwe. Na hala hoyali yolonga, ‘Migongolo jiwele na misitali ndo jowa sendi za hegwe,’ lelo chilundo cheng'ha nachilela migongolo jiwele na misitali. ");
INSERT INTO vid_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Ahi ndo Nguluwi navyoyaholile migongolo ja mhaza wa hemwe, na kungalila heni. ");
INSERT INTO vid_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","“Mhela wa migongolo kuhola nyinda nandota ulotezi, na kuli ulotezi awo nandota mipongo jeng'ha najikwinha mhene ndala jiwele na usalagwe na utoletole. ");
INSERT INTO vid_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Mhilisi wa Nguluwi nakalonga na heni kuli ulotezi awo, nakanyhema, ‘Yakobo,’ nani nyhidichila, ‘Ena.’ ");
INSERT INTO vid_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Na heye nakandonjela, ‘Ulole mipongo jeng'ha jangukwinha mhene ndala ziwele na misitali na ziwele na usalagwe na utoletole. Mbuli ayi naiwa kota ahi kwa vila nandola vyoyakuditile Labani. ");
INSERT INTO vid_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Heni nda yula Nguluwi yakulawilile kula Beteli, honhu hala houliwichile lila izengo lyoulijidile mafuta na hala houwichile ilagano kwa kilaha. Lelo uche kuli isi ayi uhiluche kuli isi ya nhanzi ya hegwe.’ ” ");
INSERT INTO vid_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Laheli na Lea nawamwidichila Yakobo, “Hetwe twahela honhu ha lufufu ama uhalizi woneche hali ng'handa ya mhaza wa hetwe. ");
INSERT INTO vid_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Heye kangutona hetwe kota wajenzi, lelo ndo nakatuguza, nakatumiya lufufu lweng'ha loyapatile kwa kutuguza. ");
INSERT INTO vid_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Lufufu lweng'ha luwele Nguluwi nakahola kulawa kwa mhaza wa hetwe ndo wa hetwe na wana wa hetwe. Ahyo, udite vila vyoulajizwe na Nguluwi.” ");
INSERT INTO vid_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Lelo Yakobo nakenuka na kiwika goya kwa majendo kwa kuwakwiniza wana wa heye na wadala wa heye mchanya mwa ngamiya. ");
INSERT INTO vid_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","Nakajihola migongolo ja heye jeng'ha na lufufu lwa heye lweng'ha loyapatile ako Padani-alamu, nakaluka majendo ga kuhiluka kuli isi ya Kanaani kwa Isaka mhaza wa heye. ");
INSERT INTO vid_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Mhela awo Labani nayali yalutile kujitema milaika ming'holo ja heye. Ahyo Laheli nakahiza jimalukolo ja milungu ja mhaza wa heye. ");
INSERT INTO vid_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Yakobo nakadeta kwa Labani Mwalamu kwa kuka ne kumzelesa. ");
INSERT INTO vid_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Lelo Yakobo nakahola lufufu lwa heye lweng'ha, na kuka. Loyalochile lwanda lwa Eyufulate, nakaluta Gileadi isi ya vidunda. ");
INSERT INTO vid_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Logakolile mazuwa gadatu, Labani nakahulika kota Yakobo nakoka ne kumlonjela. ");
INSERT INTO vid_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Lelo Labani nakawahola wang'holoze, nakamuwinza Yakobo kwa majendo ga mazuwa saba, nakamfika kuli isi ya vidunda vya Gileadi. ");
INSERT INTO vid_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Ila nechilo, Nguluwi nakamlawila Labani Mwalamu kuli ulotezi, nakamlonjela, “Ulolele, uleche kumpanjila ne kumtambichiza Yakobo.” ");
INSERT INTO vid_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Lelo Labani nakamfichila Yakobo. Mhela awo Yakobo nakesela kuli isi ya vidunda kwa mhela udo. Na heye Labani na wang'holoze nawesela hala kahi kuli vidunda vya Gileadi. ");
INSERT INTO vid_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Ahyo, Labani nakamlonjela Yakobo, “Nakudita choni? Lekachoni nakunyhada, nakuwahola wahinza wa heni kota wapogozi wa kuli ngondo? ");
INSERT INTO vid_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Lekachoni nakuka kwa uviso, nakunyhada nahundonjele hebu leka ndikulaje kwa kusangalala na nzimbo na ngoma na ving'hweleng'hwele? ");
INSERT INTO vid_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Hambe hung'hundize heni kuwanonela wahinza wa heni na wazukulu wa heni? Ndikomya nakudita chinhu cha upoka. ");
INSERT INTO vid_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Heni ndoweza kukuditila wihe, ila Nguluwi wa mhaza wa hegwe nakandawila nechilo ya kuya lehano, nakandonjela, ‘Ulolele, uleche kumlonjela Yakobo ulonzi woneche ula, linojile ama lihile.’ ");
INSERT INTO vid_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Ndivizela nakuka ne kulonga kwa vila nawali ugana ng'hatu kuhiluka kaye kwa mhaza wa hegwe, ila lekachoni nakuhiza jimalukolo ja milungu ja heni?” ");
INSERT INTO vid_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Yakobo nakamwidichila Labani, “Nandumba kwa vila ndali ndijesa kota wahambochile wahinza wa hegwe. ");
INSERT INTO vid_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Ila youmfika na jimalukolo ja milungu ja hegwe umkopole. Ulajile chinhu choneche chiwele cha hegwe hali wano wang'holozetu, uhole.” Yakobo nayali havizelele kota Laheli nayali yahizile jimalukolo ja milingu ja Labani. ");
INSERT INTO vid_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Lelo Labani najikapala jimalukolo ja milungu jake kuli ihema lya Yakobo na lya Lea na lya wadala wa wapogozi weli, ila nahajiwene. Hamba nakalawa kuli ihema lya Lea na kwinjila kuli ihema lya Laheli. ");
INSERT INTO vid_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Laheli nayali yaholile jimalukolo ajo, nakavisa hali chigoda cha kikalila mli ngamiya na kikala mchanya mwake. Labani nakapala mli ihema lyeng'ha, ila nahajiwene. ");
INSERT INTO vid_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Aho, Laheli nakamlonjela mhaza wa heye, “Dedede mhaza wa heni, uleche kuzudila, heni siweza hebu kwima kumwando kwa hegwe kwa vila ndina mbuli za chidala.” Labani nakapala jimalukolo ja milungu ja heye nahajiwene. ");
INSERT INTO vid_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Aho Yakobo nakazudila, naketwanza na Labani yolonga, “Lekachoni wali umbinga, ndita gehile gachi? ");
INSERT INTO vid_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Ndaze, nakona choni lousakule mhomolo za heni zeng'ha? Chiwiche kumwando mwa wang'holozangu na wang'holozo, leka wataguse hali hetwe weli. ");
INSERT INTO vid_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Nandikala na hegwe kwa mhela wa miyaka makumi meli, na mhela awo weng'ha ming'holo ja hegwe na mhene za hegwe zeng'ha haziwifile nyinda, nani sidile ing'holo ilume lya chilundo cha hegwe. ");
INSERT INTO vid_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Heni sikugalile ne zuwa limwe igongolo lya hegwe likopoligwe na migongolo ja kisolo, ila nandihilusa nene baha. Hegwe nakungana ndikuhilusile ne kijesa kota nakahizigwa nemisi ama nechilo. ");
INSERT INTO vid_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Ahyo nemisi ndikangaza isanya likali na nechilo mbeho naimhutila heni nasipatile kuwasa ne hado. ");
INSERT INTO vid_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Kwa miyaka makumi meli aga geng'ha nandikala hakaye kwa hegwe. Nandikukolela mijito kwa mhela wa miyaka kumi na gane kwa chiwalo cha wahinza wa hegwe weli, na miyaka jinji sita nandima migongolo ja hegwe. Ila hegwe, nakugalula msahala wa heni mala kumi. ");
INSERT INTO vid_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Kota Nguluwi wa mhaza wa heni Abulahamu, Nguluwi yamditile mhaza wa heni Isaka yakakame, wone nahawele ubanzi wa heni, ndikomya nakugana kundeka heni ndute ne chinhu. Ila Nguluwi nakona kugazika kwa heni na mijito yong'holile kwa moko ga heni, nakakung'hanuchila nechilo ya kuya lehano.” ");
INSERT INTO vid_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Aho Labani nakamwidichila Yakobo, “Wahinza wano ndo wahinza wa heni, na wana wano ndo wana wa heni, migongolo jino ndo migongolo ja heni na vyeng'ha vyoulinguvyona hano ndo vya heni. Ila heni ndoweza kudita choni lehano kuwalapa wano wahinza wa heni na wana wa hewo wawapondile? ");
INSERT INTO vid_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Lelo natudite ilagano heni na hegwe leka liwe ulolezi wa heni na hegwe.” ");
INSERT INTO vid_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Lelo Yakobo nakahola iganga, nakalimiza kota izengo. ");
INSERT INTO vid_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Kahi Yakobo nakawalonjela wang'holoze, “Mkungajize maganga.” Na hewo nawakungajiza na kudita chibugulu. Hamba nawalya chilyo behi na chibugulu acho cha maganga. ");
INSERT INTO vid_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Labani nakachichema chibugulu acho cha maganga Yegali-sahaduta, ila Yakobo nakachichema Galeedi. ");
INSERT INTO vid_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Labani nakalonga, “Chibugulu achi cha maganga ndo ulolezi wa heni na hegwe lehano.” Ahyo, ndo mina chibugulu acho nakachichema Galeedi, ");
INSERT INTO vid_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","na chibugulu chila kahi nachichemigwa Misipa aku yolonga, “Mkulu Nguluwi nayatwamile lotuwele kutali ne kiwona. ");
INSERT INTO vid_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Wone uwagaze wahinza wa heni, ama louhesa wadala wanji kusinda wano, ne kuvizela munhu yunji, lelo uvizele kota kuduhu yawele mlolezi hali hetwe ila ndo Nguluwi yuye.” ");
INSERT INTO vid_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Hamba Labani nakamlonjela Yakobo, “Ulole chibugulu achi cha maganga na izengo lyondilimize hali hegwe na heni. ");
INSERT INTO vid_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Chibugulu chino ndo ulolezi na izengo ali ndo ulolezi kota heni hambe ndoche chibugulu chino kuya kwa hegwe kukuditila wihe, na huweza kuloka chibugulu chino kuya kwa heni kunditila wihe. ");
INSERT INTO vid_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Nguluwi wa Abulahamu na Nguluwi wa Naholi, kotagusa hali hetwe.” Lelo Yakobo nakelaha kwa Nguluwi yamditile Isaka mhaza wa heye yakakame. ");
INSERT INTO vid_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Hamba Yakobo nakalavya nhambiko ako kuli isi ya vidunda na kuwalalika wang'holoze walye chilyo. Lowasindile kulya nawapona kuko nechilo. ");
INSERT INTO vid_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Lufuku Labani nakenuka, nakawanonela wazukulu wa heye na wahinza wa heye na nakawatambichiza. Hamba nakoka kuhiluka kaye. ");
INSERT INTO vid_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Yakobo nakalutilila na majendo ga heye. Lelo wahilisi wa Nguluwi naweting'hana na heye. ");
INSERT INTO vid_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Yakobo loyawawene, nakalonga, “Ayi ndo kambi ya Nguluwi!” Ahyo, nakahachema honhu aho Mahanaimu. ");
INSERT INTO vid_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Yakobo nakawalajiza wahilisi wamlongole kwa mng'holoze Esau, ako Seili hali isi ya Edomu. ");
INSERT INTO vid_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Nakawagalila malajizo gano, “Momulonjela hino mkulu wa heni Esau. Chitumagwa wa hegwe Yakobo kangulonga hino, ‘Nandikala kuli isi ya ujenzi kwa Labani mbaka sambi. ");
INSERT INTO vid_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Ndina misenga na midogowi na milundo ja ming'holo na vitumagwa walume na wadala. Ndangukulajizila usenga awu, mkulu wa heni, leka ndiwe na uganililo hali hegwe.’ ” ");
INSERT INTO vid_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Awo wahilisi nawaluta, hamba nawahiluka na kumlonjela Yakobo, “Natufika kwa mng'holozo Esau, na heye kamzila kuya kukubochela, yawele na walume miya zine.” ");
INSERT INTO vid_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Lelo Yakobo nakadumba ng'hatu na nakawa na lunhwinhwi. Nakawabagula wanhu wowawele hamwe na heye kuli vilundo vili na ming'holo na migongolo jinji na ngamiya ako kuli kambi ");
INSERT INTO vid_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","yojesa, “Wone Esau kokuya na kubagamiza chilundo chimwe, chilundo chiyage chonyeleduka kuli kambi.” ");
INSERT INTO vid_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Hamba Yakobo nakamlanda Nguluwi yolonga, “Hegwe Nguluwi wa mhaza wa heni Abulahamu na Nguluwi wa mhaza wa heni Isaka. Hegwe Mkulu Nguluwi youndonjele kota nyhiluche hali isi ya heni hawele na ivyazi lya heni, nakundonjela kunditila ganojile, ");
INSERT INTO vid_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","hambe nganigwe ne hado madito ga hegwe ga igano lya kwimilila na makundo goundajile heni chitumagwa wa hegwe. Londochile lwanda Yolodani, nandali hela chinhu ila ng'hweku hela, ila sambi ndanazo kambi mbili. ");
INSERT INTO vid_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Ndangukulanda undohole sambi kulawa kwa mng'holozangu Esau, mina ndangudumba kota kotutowa na kutubagamiza hetwe tweng'ha, wadala hamwe na wana. ");
INSERT INTO vid_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Hegwe nakundonjela ukomya konditila ganojile na kudita lulelo lwa heni luwe lwinji kota sangalaza ya mli bahali yohailinguwazika.” ");
INSERT INTO vid_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Lelo Yakobo nakawasa baho nechilo ayo. Hamba nakabagula honhu ha lufufu lwa heye hawe ndolendole kwa mng'holoze Esau. ");
INSERT INTO vid_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","Mhene ndala miya mbili na mipongo makumi meli na ming'holo midala miya mbili na ming'holo milume makumi meli ");
INSERT INTO vid_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","na ngamiya makumi gadatu walingonyeza hamwe na wana na misenga makumi gane na mibuguma kumi hamwe na midogowi midala makumi meli na milume kumi. ");
INSERT INTO vid_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Nakawagalila vitumagwa wa heye chila yumwe na ilundo lya heye, nakawalonjela, “Mlongole kuno mleka honhu hagati kulawa chilundo chimwe na chiyage kuli majendo ga hemwe.” ");
INSERT INTO vid_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Nakamlajiza yula chitumagwa yalongole, “Louting'hana na mng'holozangu Esau, wone yakuuze, ‘Hegwe kwa chitumagwa wa whaani? Kwanguluta kohi? Na migongolo jino ja whaani?’ ");
INSERT INTO vid_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","Nagwe komwidichila, ‘Alu ndo lufufu lwa chitumagwa wa hegwe Yakobo, na ndo ndolendole ya hegwe mkulu wa heni Esau. Kahi Yakobo yuye ka kumbele kanguya.’ ” ");
INSERT INTO vid_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Nakalavya ilajizo lilyo kwa chilundo cha keli na cha kadatu na wanji weng'ha yolonga, “Momlonjela Esau ulonzi wuwo lomting'hana na heye. ");
INSERT INTO vid_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Kupuluta kwa geng'ha, momlonjela, ‘Chitumagwa wa hegwe Yakobo ka kumbele, kanguya.’ ” Yakobo nakadita ahyo yojesa, “Hanji ndomdita yasindamale kwa ndolendole ino yoilongole, hamba ndoweza kiwona meho kwa meho, hanji kombochela heni.” ");
INSERT INTO vid_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Lelo nakalongola ndolendole ya heye, ila heye nakawika kambi. ");
INSERT INTO vid_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Nechilo yiyo Yakobo nakenuka, nakawahola wadala wa heye weli na wapogozi wa heye wadala weli na wana wa heye kumi na yumwe, nawakola chiloko cha Yaboki. ");
INSERT INTO vid_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Loyawalajize kuloka lwanda alo wala wawele na heye na lufufu lwa heye lweng'ha, ");
INSERT INTO vid_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Yakobo nakasigala yaliyeka. Munhu yumwe nakoya, nawetowa mbaka lufuku. ");
INSERT INTO vid_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Munhu ayo loyawene kota howeza kumsumya Yakobo, nakamdoliza Yakobo kuli chuno, na heye nakatweguka loyawele yochitowa. ");
INSERT INTO vid_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Hamba yula munhu nakamlonjela Yakobo, “Ndeche ndute, mina kubwemwenzuka sambi.” Ila Yakobo nakamlonjela, “Sikuleka ng'oo mbaka unhambichize!” ");
INSERT INTO vid_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Na heye nakamuuza, “Itagwa lyako lyachi?” Heye nakamwidichila, “Yakobo.” ");
INSERT INTO vid_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Yula munhu nakamlonjela, “Hochemigwa Yakobo kahi, ila Isilaeli, kwa vila nakwimilila kitowa na Nguluwi.” ");
INSERT INTO vid_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Aho, Yakobo nakamlonjela, “Dedede, ndangukulanda undonjele itagwa lya hegwe.” Ila heye nakamlonjela, “Ya choni kumbuza itagwa lya heni?” Hamba nakamtambichiza Yakobo. ");
INSERT INTO vid_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Yakobo nakahachema honhu aho Penieli, yolonga, “Nandimona Nguluwi meho kwa meho, na hambe mbagame.” ");
INSERT INTO vid_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Isanya nalyali lyaluka kulawa mhela Yakobo loyochile Penueli, nayali yodudila kwa chiwalo cha chigudi cha heye. ");
INSERT INTO vid_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Ndo mina mbaka lehano Waisilaeli hambe walye idanha lya honhu ha chigudi, mina yula munhu nakamdoliza Yakobo hali midanha ha chigudi cha heye. ");
INSERT INTO vid_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Lelo Yakobo nakalola, nakamona Esau hamwe na walume miya zine. Aho, nakawabagula wana wa heye kwa Lea na Laheli na wala wapogozi wa heye wadala weli. ");
INSERT INTO vid_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Nakawawika wapogozi wadala na wana wa hewo kumwando, hamba Lea na wana wa heye na kumbele ng'hatu nawali Laheli na mwana wa heye Yusufu. ");
INSERT INTO vid_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Hamba heye nakalongoza, nakaluta kwa kufugama mala saba, mbaka loyafichile habehi na mng'holoze. ");
INSERT INTO vid_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Lelo Esau nakaluta kwa kubilima kumbochela Yakobo, nakamkumbatila kuli singo na kumnonela, na weng'ha weli nawalila. ");
INSERT INTO vid_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Esau loyalolile na kuwona wala wadala na wana, nakauza, “Awa wawele na hegwe ndo wanhu wachi?” Yakobo nakedichila, “Wano ndo wana wawele Nguluwi yangalile heni chitumagwa wa hegwe kwa kunoga kwa heye.” ");
INSERT INTO vid_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Hamba wala wapogozi nawahejela hamwe na wana wa hewo, nawenamiza kwa kuhulichiza. ");
INSERT INTO vid_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Na heye Lea kahi nakoya hamwe na wana wa heye, nakenamiza kwa kuhulichiza. Hamba, Laheli na Yusufu nawoya, nawenamiza kwa kuhulichiza. ");
INSERT INTO vid_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Aho, Esau nakauza, “Kuting'hana heni na chilundo chino mnzila kuna mana yachi?” Yakobo nakamwidichila, “Ndali nditumbila kuwa na uganililo kulawa kwa hegwe mkulu wa heni.” ");
INSERT INTO vid_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Ila Esau nakalonga, “Ndina lufufu lwa kuhega mng'holozangu. Lufufu lwa hegwe na lupone kwa hegwe.” ");
INSERT INTO vid_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Yakobo nakamlonjela, “Hebu, kota kukomya, nakukunda kumbochela heni, lelo ndangukudedeza ubochele ndolendole ya heni. Ndikomya, sangalala kukona hegwe kota ndimona Nguluwi, kwa vila nakumbochela goya. ");
INSERT INTO vid_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Lelo ndangukudedeza ubochele ndolendole kota utambichizo kulawa kwa heni yondikugalile, kwa vila nani kahi Nguluwi nakambonela isungu heni na kwa vila nandali na chinhu cha kuhega.” Ahi ndo Yakobo vyoyamdedeze ng'hatu Esau, na heye nakabochela ndolendole ya heye. ");
INSERT INTO vid_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Esau nakalonga, “Natulutilile na majendo ga hetwe, heni ndokulongola.” ");
INSERT INTO vid_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Ila Yakobo nakamlonjela, “Mkulu wa heni, hegwe kuvizela kota wana wano ndo vyali na kahi migongolo jino jangonyeza, na heni ndanguganigwa kujilolela, kota migongolo jino johilikwa kwa kubilima kwa zuwa limwe, jeng'ha jobagama. ");
INSERT INTO vid_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Lelo mkulu wa heni ulongole, nani ndokuya mholemhole kota migongolo na wana vyowalingujenda mbaka londifika kwa mkulu wa heni ako Seili.” ");
INSERT INTO vid_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Aho Esau nakalonga, “Inoga ndikulechele wanhu wamwe wa heni.” Ila Yakobo nakalonga, “Lekachoni kuganigwa kudita ahyo? Ihega kota heni mhegwa uganililo wa hegwe, mkulu wa heni.” ");
INSERT INTO vid_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Lelo zuwa alyo Esau nakaluka majendo ga kuhiluka Seili. ");
INSERT INTO vid_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Ila Yakobo nakaheluka nakafika Sukoti, na ako nakezenjela ng'handa na vibumuli kwa chiwalo cha migongolo ja heye. Kwa chiwalo acho, honhu aho nahachemigwa Sukoti. ");
INSERT INTO vid_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Kulawila nzila ilingukolela Padani-alamu Yakobo nakafika goya kuli muji wa Shekemu, kuli isi ya Kanaani, nakawika kambi behi na muji awo. ");
INSERT INTO vid_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Honhu aho ha misanga hawele yesele kwa mhela udo nakagula kulawa kwa lulelo lwa Hamoli, mhaza wa Shekemu kwa migwala miya imwe ja sendi. ");
INSERT INTO vid_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Ako, nakazenga honhu ha kulavila nhambiko na kuhachema Nguluwi ndo Nguluwi wa Isilaeli. ");
INSERT INTO vid_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Zuwa limwe Dina, mhinza wa Yakobo na Lea, nakoka kuwajendela wadala wa isi ayo. ");
INSERT INTO vid_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Lelo Shekemu mwana wa Hamoli, Muhivi, nayawele mkulu wa isi ayo, loyamuwene Dina, nakambata na kuwasa na heye kwa lupichi na kumdita yone soni. ");
INSERT INTO vid_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Ila Shekemu nakanojezwa ng'hatu na ayo mhinza, nakamgana na nakaluka kumdedeza. ");
INSERT INTO vid_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Ahyo, Shekemu nakadogola na Hamoli mhaza wa heye, nakamlonjela, “Ndangulanda ndigalile ayo mhinza ndimhole yawe mchewangu.” ");
INSERT INTO vid_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Yakobo nakahulika kota mhinza wa heye Dina, nakaditikwa yawe mwavu na Shekemu, ila kwa vila wana wa heye nawali wodima migongolo, nakanyamalila mbaka lowahiluche. ");
INSERT INTO vid_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Hamoli mhaza wa Shekemu nakaluta kwa Yakobo leka yadogole na heye, ");
INSERT INTO vid_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","na mhela wuwo wana walume wa Yakobo nawali wohiluka kulawa kudima migongolo. Lowahuliche ago, wasongolo awo nawona usungu ng'hatu na kuzudila ng'hatu, kwa vila Shekemu nayali yawabasile soni wanhu wa Isilaeli kwa kuwasa na mhinza wa Yakobo, mina mbuli ayo nailemezigwa ng'hatu. ");
INSERT INTO vid_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Ila Hamoli nakawalonjela, “Nhumbula ya mwana wa heni Shekemu nainojezwa ng'hatu na mhinza wa hemwe. Lelo dedede mumkundize yamhole. ");
INSERT INTO vid_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Tihole. Hetwe towahola wahinza wa hemwe, namwe mowahola wahinza wa hetwe. ");
INSERT INTO vid_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Ahyo mochikala hamwe na hetwe, mowa milejehe mli isi ayi. Mochikala amu, mgule na kuguza vinhu na muwe na honhu ha isi ayi.” ");
INSERT INTO vid_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Na kahi, Shekemu nakawalonjela mhaza wa Dina na wang'holoze, “Dedede, ndangulanda uganililo hali hemwe, nani ndowagalila choneche chomlonga. ");
INSERT INTO vid_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Mndonjele chasi choneche cha kulavya na ndolendole ya kuhesa, hanji na iwe ng'hulu ndaze, nani ndolavya, leka hela ndimhole mhinza ayu.” ");
INSERT INTO vid_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Lelo wana walume wa Yakobo nawamwidichila kwa kumhada Shekemu na mhaza wa heye Hamoli, kwa vila Shekemu nakamdita lumbulyawo Dina yawe mwavu. ");
INSERT INTO vid_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Nawawalonjela, “Hambe tumlavye lumbulyetu kwa munhu yohambe yenjile ikumbi. Kudita ahyo ndo kibasa soni kwa hetwe. ");
INSERT INTO vid_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Tochikundiza na wone modita chinhu achi hela. Muwe kota hetwe kwa kumwinjiza ikumbi chila mlume hali hemwe. ");
INSERT INTO vid_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Aho ndo towagalila wahinza wa hetwe na kuwahola wahinza wa hemwe, tochikala hamwe na hemwe na kuwa lukolo lumwe. ");
INSERT INTO vid_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Ila wone hatikundize na hetwe na kwinjila ikumbi, hetwe tomhola mhinza wa hetwe na kuka na heye.” ");
INSERT INTO vid_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Chowalonjile nachali chinoga kwa Hamoli na mwanage Shekemu. ");
INSERT INTO vid_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Msongolo ayo nahalemile kudita ahyo, kwa vila navyoyanojezwe na mhinza wa Yakobo. Na kahi, Shekemu ndo nayali yotogoligwa ng'hatu kusinda weng'ha hakaye ha mhaza wa heye. ");
INSERT INTO vid_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Lelo Hamoli na mwanage Shekemu nawaluta hali lwizi lwa muji, honhu ha nhing'hano, nawalonga na wanhu wa hewo, wolonga, ");
INSERT INTO vid_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","“Wanhu wano tigana na hetwe. Hamba tuwabochele na kikala hali isi ya hetwe na kuguza na kugula vinhu, kwa vila twanayo isi ihejile kikala hetwe na hewo, hamba towahola wahinza wa hewo na hewo wowahola wahinza wa hetwe. ");
INSERT INTO vid_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Ila hewo wokunda kikala na hetwe na towa lukolo lumwe wone hetwe tokunda kudita ahi. Tomwinjiza ikumbi chila mlume hali hetwe kota hewo navyowenjile ikumbi. ");
INSERT INTO vid_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Ndaze, hamlingona kota migongolo ja hewo na lufufu lwawo lweng'ha vyowa vya hetwe? Lelo tikundize na hewo leka wekale hamwe na hetwe.” ");
INSERT INTO vid_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Walume weng'ha wowating'hane hala hali lwizi lwa muji awo, nawekundiza na Hamoli na mwanage Shekemu. Hamba walume weng'ha nawenjila ikumbi. ");
INSERT INTO vid_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Mazuwa gadatu hamba, wala wenjile ikumbi wowawele wang'hali na usungu ng'hatu, wana weli wa Yakobo, Simeoni na Lawi kalumbu wa Dina, nawahola mipanga ja hewo wauvada muji, baho du na kuwakopola walume weng'ha. ");
INSERT INTO vid_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Nawawakopola kwa mipanga Hamoli na mwanage Shekemu, nawamlavya Dina hali ng'handa ya Shekemu, nawoka. ");
INSERT INTO vid_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Kukopola ako lokupulute, wasongolo wanji wa Yakobo nawenjila hali muji awo na kuhola chila chinhu, kwa vila lumbulyawo nayali yaditikwe yawe mwavu. ");
INSERT INTO vid_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Nawahola ming'holo na mhene na misenga na midogowi na choneche chiwele kuli muji ama kumgunda. ");
INSERT INTO vid_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Nawawebata wana na wadala weng'ha na kuhola lufufu lweng'ha na choneche chiwele mli ng'handa za hewo. ");
INSERT INTO vid_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Hamba, Yakobo nakawalonjela Simeoni na Lawi, “Hemwe namungalila kugaya kwa kundita heni nzudilwe na wenyeng'haye wa isi ayi ya Wakanaani na Wapelisi. Heni ndahela wanhu wenji, wone wating'hane kuya kunhowa heni wong'hopola heni hamwe na wang'holozangu.” ");
INSERT INTO vid_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Hewo nawedichila, “Hambi nakakundigwa kumditila lumbulyetu kota mng'hondwa?” ");
INSERT INTO vid_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Zuwa limwe Nguluwi nakamlonjela Yakobo, “Waluche majendo, ulute kikala Beteli na kunzenjela honhu ha kulavila nhambiko heni Nguluwi yondikulawile mhela loumbilime mkulugo Esau.” ");
INSERT INTO vid_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Lelo Yakobo nakawalonjela wang'holoze na wanhu weng'ha wowali na heye, “Mtajile kutali jimalukolo ja milungu cha chijenzi jomlinajo, mihovuje na kuvala nguwo zinji. ");
INSERT INTO vid_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Hamba, toluta Beteli leka ndimzenjele honhu ha kulavila nhambiko Nguluwi yanhanzile zuwa lya kugaya, Nguluwi nayawele na heni heng'ha hondutile.” ");
INSERT INTO vid_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Lelo nawamha Yakobo jimalukolo jeng'ha ja milungu mijenzi najowali najo hamwe na vipuli navyowavalile mmakutu, na heye nakavitila hasi ha mwaloni nauwele behi na Shekemu. ");
INSERT INTO vid_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Yakobo na wanage nalowawele mlimajendo, Nguluwi nakawadumbiza ng'hatu wenyeng'haye wa miji jeng'ha ja habehi mbaka hawajezile kuwawinza. ");
INSERT INTO vid_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Yakobo hamwe na wanhu weng'ha nawoyawele nawo nawafika Lusu ichemigwe kahi Beteli kuli isi ya Kanaani. ");
INSERT INTO vid_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Nakazenga honhu ha kulavila nhambiko na kuhachema honhu aho Eli-beteli kwa vila aho ndo honhu Nguluwi nayelajile kwa heye mhela naloyali yombilima mkulugwe. ");
INSERT INTO vid_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Debola chitumagwa wa Lebeka nakabagama, nakatiligwa hasi ha igodi lilinguchemigwa mwaloni nzingo ya kusini mwa Beteli. Lelo Yakobo nakahachema honhu aho Aloni-bakuti ilinguzeleka ibuyu lya kuzapila. ");
INSERT INTO vid_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Yakobo naloyahiluche kulawa Padani-alamu, Nguluwi nakamlawila kahi na kumtambichiza. ");
INSERT INTO vid_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Nguluwi nakamlonjela, “Itagwa lyako ndo Yakobo, ila huchemigwa ahyo kahi, sambi kochemigwa Isilaeli.” Lelo Yakobo nakachemigwa Isilaeli. ");
INSERT INTO vid_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Kahi Nguluwi nakamlonjela, “Heni ndo Nguluwi yawele na mong'ho. Uwe na wana wenji na mwonjezeche, kwa hegwe wolawila wanhu wenji wa nhanzi na nhanzi nyinji na wandewa. ");
INSERT INTO vid_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Isi yondiwapele Abulahamu na Isaka, ndokupa hegwe na wanago.” ");
INSERT INTO vid_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Lelo loyasindile kulonga na Yakobo, Nguluwi nakamleka. ");
INSERT INTO vid_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Yakobo nakemiza izengo honhu aho Nguluwi naloyalongase na heye, nakamjidila nhambiko ya chakunwa na mafuta. ");
INSERT INTO vid_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Lelo Yakobo nakahachema honhu aho loyalongase na Nguluwi, Beteli. ");
INSERT INTO vid_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Yakobo na ivyazi lya heye lyeng'ha nawalutilila na majendo ga hewo kulawila Beteli. Nalowali utali umwenga wang'hali kufika Efulata, Laheli nakebatikwa na usungu ung'hang'hale wa kuponda. ");
INSERT INTO vid_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Naye loyawele mli usungu awo, mkunga nakamlonjela, “Uleche kugozola, kuponda mwana yunji mlume.” ");
INSERT INTO vid_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Laheli aku yawele behi kubagama, nakamchema ayo mwana itagwa lya Beni-oni. Ila mhaza wa mwana nakamchema Benjamini. ");
INSERT INTO vid_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Laheli nakabagama na kutiligwa hafungo mwa nzila ilinguluta Efulata. Ayo ndo Betelehemu. ");
INSERT INTO vid_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Yakobo nakemiza izengo mchanya mwa chilaga cha Laheli liwele baho mbaka lehano. ");
INSERT INTO vid_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Isilaeli nakalutilila na majendo na kwesela naloyapulute Migidoli-edeli izeleche kota ilingo lya Edeli. ");
INSERT INTO vid_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Mhela Isilaeli naloyali yochikala muisi ayo, mwanage Lubeni, nakawasa na Biliha, mpogozi yawele kota mchewake mhaza wa heye, na heye Isilaeli nakahulika mbuli azo. Yakobo nayali na wana kumi na weli. ");
INSERT INTO vid_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Wana wa Lea nawali Lubeni, mlelwa wa mwaluko wa Yakobo, na Simeoni na Lawi na Yuda na Isakali na Sebuluni. ");
INSERT INTO vid_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Wana wa Laheli nawali Yusufu na Benjamini. ");
INSERT INTO vid_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Wana wapondigwe na Biliha, chitumagwa mdala wa Laheli, nawali Dani na Nafutali. ");
INSERT INTO vid_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Na wana wapondigwe na Silipa, chitumagwa mdala wa Lea, nawali Gadi na Asheli. Awo ndo wana wa Yakobo nayawapatile naloyawele kula Padani-alamu. ");
INSERT INTO vid_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Yakobo nakoka nakuluta Mamle kwa mhaza wa heye Isaka, ako Kiliati-aliba, ako Hebuloni, honhu hawele Abulahamu na Isaka nawekale kota wajenzi. ");
INSERT INTO vid_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Isaka nayali na miyaka miya imwe na makumi nane, ");
INSERT INTO vid_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","nakabagama yawele yalalile lukami na nakaza kilumba na wasekulu wa heye wamlongole. Wana wa heye Esau na Yakobo nawamtila. ");
INSERT INTO vid_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Ayi ndo mbuli ya walelwa wa Esau, ahyo ndo Edomu. ");
INSERT INTO vid_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Esau nakahesa wadala Wakanaani, Ada mhinza Eloni Mhiti na Oholibama mhinza wa Ana na kahi mzukulu wa Sibeoni Muhivi ");
INSERT INTO vid_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","na Basemati mhinza wa Ishimaeli, lumbulye Nebayoti. ");
INSERT INTO vid_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Ada nakampondela Esau Elifasi, na heye Basemati nakampondela Leueli. ");
INSERT INTO vid_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Oholibama nakampondela Yeushi na Yalamu na Kola. Awo ndo wana wa Esau woyawapatile naloyekale kuli isi ya Kanaani. ");
INSERT INTO vid_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Hamba Esau nakawahola wachewake na wanage walume na wadala na wanhu weng'ha wa haluga hake, na misenga na migongolo ja heye jinji na vinhu vya heye vyeng'ha navyoyapalile kuli isi ya Kanaani, nakahamila honhu hanji, kutali na mng'holoze Yakobo. ");
INSERT INTO vid_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Nakadita ahyo kwa vila vinhu vya hewo navyali vinji mbaka nawalemwela kikala hamwe. Isi nayowekale kota wajenzi nayali ndodo kwa winji wa vinhu navyowali navyo na misenga. ");
INSERT INTO vid_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Ahyo, Esau nakaluta kikala kuli isi ya vidunda vya Seili. Itagwa linji lya Esau ndo Edomu. ");
INSERT INTO vid_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Ayi ndo mbuli ya wana wa Esau, mhaza wa Edomu kuli vidunda vya Seili. ");
INSERT INTO vid_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Wana wa Esau wali Elifasi yapondigwe na Ada mchewake, na Leueli yapondigwe na Basemati mchewake yunji. ");
INSERT INTO vid_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Wana wa Elifasi wali Temani na Omali na Sefo na Gatamu na Kenasi. ");
INSERT INTO vid_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Elifasi nayali na mhawake itagwa lyake Timuna. Ayu nakampondela mwana itagwa lyake Amaleki. Wano nawali wana wa mchewake Esau nayachemigwe Ada ");
INSERT INTO vid_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Basemati mchewake Esau, nakamponda Leueli. Wana wa Leueli wali Nahati na Sela na Shama na Misa. ");
INSERT INTO vid_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Oholibama mhinza wa Ana, mhinza wa Sibeoni, nakampondela Esau wana wadatu, Yeushi na Yalamu na Kola. ");
INSERT INTO vid_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Awa ndo wakulu wa nhanzi ilawile kwa Esau. Elifasi, nayawele mlelwa wa mwaluko wa Esau nakawaponda Temani na Omali na Sefo na Kenasi ");
INSERT INTO vid_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","na Kola na Gatamu na Amaleki, chila yumwe wa hewo nayali mkulu wa nhanzi ya heye. Awo weng'ha ndo wana wa Elifasi kuli isi ya Edomu, nawalawile kwa Ada mchewake Esau. ");
INSERT INTO vid_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Leueli, mwanage Esau, nakawaponda Nahati na Sela na Shama na Misa. Chila yumwe nayali mkulu wa nhanzi ya heye. Awo weng'ha ndo wana wa Leueli kuli isi ya Edomu nawalawile kwa Basemati mchewake Esau. ");
INSERT INTO vid_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Wana wa Oholibama mchewake Esau nawali, Yeushi na Yalamu na Kola, chila yumwe nayali mkulu wa nhanzi ya heye. Awo weng'ha ndo wana wa Oholibama mhinza wa Ana, mchewake Esau. ");
INSERT INTO vid_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Lelo awo ndo walelwa wa Esau mina ndo Edomu, chila yumwe nayawele mkulu wa nhanzi ya heye. ");
INSERT INTO vid_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Awa ndo walelwa wa Seili Mholi, na ndo wenyeng'haye wa isi ayo, Lotani na Shobali na Sibeoni na Ana ");
INSERT INTO vid_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","na Dishoni na Eseli na Dishani, chila yumwe nayali mkulu wa nhanzi ya heye mli wala Waholi wa lulelo lwa Seili, kuli isi ya Edomu. ");
INSERT INTO vid_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Wana wa Lotani nawali Holi na Hemani, na lumbulye Lotani nayachemigwe Timuna. ");
INSERT INTO vid_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Wana wa Shobali nawali Alivani na Manahasi na Ebali na Shefo na Onamu. ");
INSERT INTO vid_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Wana wa Sibeoni nawali Aya na Ana. Ana nandoyaziwene nzasa za mazi gapwituche kuchiwala, naloyali yodima midogowi ja mhaza wa heye Sibeoni. ");
INSERT INTO vid_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Wana wa Ana nawali Dishoni na mhinza yumwe itagwa lyake Oholibama. ");
INSERT INTO vid_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Wana walume wa Dishoni nawali Hemdani na Eshibani na Itilani na Kelani. ");
INSERT INTO vid_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Wana walume wa Eseli nawali Bilihani na Saawani na Akani. ");
INSERT INTO vid_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Wana walume wa Dishani nawali Usi na Alani. ");
INSERT INTO vid_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Lelo awo ndo wakulu wa Waholi, Lotani na Shobali na Sibeoni na Ana ");
INSERT INTO vid_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","na Dishoni na Eseli na Dishani, chila yumwe wa hewo yawele mkulu wa nhanzi ya Waholi kuli isi ya Seili. ");
INSERT INTO vid_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Awa ndo wandewa nawalongoze isi ya Edomu, lokung'hali kuduhu mndewa ne yumwe yalongoze Waisilaeli. ");
INSERT INTO vid_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Bela, mwana Beoli, nakalongoza isi ya Edomu yawele na ng'handa ya undewa kuli muji wa Dinaba. ");
INSERT INTO vid_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Bela loyabagame, Yobabu mwana wa Sela kulawa Bosila nakalongoza honhu hake. ");
INSERT INTO vid_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Yobabu loyabagame, Hushamu wa isi ya Watemani, nakalongoza honhu hake. ");
INSERT INTO vid_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Hushamu loyabagame, Hadadi mwana wa Bedadi nakalongoza honhu hake, ng'handa ya heye ya undewa nayali kuli muji wa Aviti. Ayu ndo nayawatowile na kuwasumya Wamidiani kuli isi ya Moabu. ");
INSERT INTO vid_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Hadadi loyabagame, Samula kulawila Masileka, nakalongoza honhu hake. ");
INSERT INTO vid_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Samula loyabagame, Shauli kulawila Lehoboti, muji uwele behi na lwanda lwa Eyufulate, nakalongoza honhu hake. ");
INSERT INTO vid_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Shauli loyabagame, Baali-hanani, mwana wa Akiboli, nakalongoza honhu hake. ");
INSERT INTO vid_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Baali-hanani loyabagame, Hadadi nakalongoza honhu hake, na itagwa lya muji wa heye liwa Pau. Mchewake Akiboli nayali Mehetabeli, mhinza wa Matiledi na mzukulu wa Mesahabu. ");
INSERT INTO vid_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Wakulu wa nhanzi zilawile kwa Esau, kota nhanzi za hewo na honhu hao ha kikala, wali Timuna na Aluva na Yeteti ");
INSERT INTO vid_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","na Oholibama na Ela na Pinoni ");
INSERT INTO vid_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","na Kenasi na Temani na Mibisali ");
INSERT INTO vid_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","na Magidieli na Ilamu. Awo ndo wakulu wa Edomu, wachemigwa kulawa honhu hawo kuli honhu ha isi nazowekale. Esau nayali sekulu wa Waedomu. ");
INSERT INTO vid_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Yakobo nakalutilila kikala kuli isi ya Kanaani, moyali ngikala mhaza wa heye kota mjenzi. ");
INSERT INTO vid_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Ayi ndo mbuli ya lukolo lwa Yakobo, Yusufu naloyali msongolo wa miyaka kumi na saba, nayali yodima ming'holo na mhene hamwe na wang'holoze, wana wa Biliha na Silipa wadala wa mhaza wa heye. Yusufu nayali yomlonjela mhaza wa heye mbuli za wihe wa wang'holoze. ");
INSERT INTO vid_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Isilaeli nakamgana lukami Yusufu kusinda wana weng'ha, kwa vila nakapondigwa mhela wa ulalilo wa heye na nakamhonela Yusufu ikanzu lya chiuyeng'ha linoligwe ng'hatu. ");
INSERT INTO vid_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Ila wang'holoze vyowawene kota mhaza wa hewo nakamgana Yusufu kusinda hewo, nawamzudila ne kulonga na heye goya. ");
INSERT INTO vid_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Nechilo imwe, Yusufu nakalota, ila loyawasimile wang'holoze, hewo nawamzudila ng'hatu. ");
INSERT INTO vid_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Nakawalonjela, “Mhulichize vyondotile. ");
INSERT INTO vid_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Nandota kota tweng'ha twali kumgunda tukoweleza nyhinza na baho du nyhinza ya heni nazima wima. Nyhinza za hemwe, nazikungajiza na kuzunguluta na kinamizila nyhinza ya heni.” ");
INSERT INTO vid_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Wang'holoze nawamuuza, “Ndaze, kwangugana kutulonjela kota kotulongoza? Ama kowa na ludali kwa hetwe?” Lelo walutilila kumzudila ng'hatu kwa mbuli ya kulota na ulonzi wa heye. ");
INSERT INTO vid_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Hamba Yusufu nakalota kahi, nakawasimila wang'holoze yolonga, “Mhulichize, ndota kahi, nambona nhondwe kumi na imwe na isanya na nyelezi, nazinamizila heni.” ");
INSERT INTO vid_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Loyamsimile mhaza na wang'holoze kulota ako, mhaza wa heye nakamng'hanuchila yolonga, “Ndo kulota kwachi ako koulotile? Ndaze, yotulapa heni na mayako na wang'holozo kuya na kinamiza hasi hamwando ha hegwe kukutogola?” ");
INSERT INTO vid_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Wang'holoze nawamonela fihi, ila mhaza wa heye nakalutilila kijesa mbuli ayo. ");
INSERT INTO vid_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Zuwa limwe, wang'holoze Yusufu nawaluta kudima misenga ja mhaza wa heye behi na Shekemu. ");
INSERT INTO vid_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Isilaeli nakamlonjela Yusufu, “Kuvizela kota wang'holozo wangudima migongolo kula Shekemu. Lelo ndangugana ndikulajize kwa hewo.” Yusufu nakedichila, “Heni nda goya.” ");
INSERT INTO vid_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Mhaza wa heye nakamlonjela, “Ulute ukawalole wang'holozo na migongolo wone wawele wakomu hamba uye undonjele.” Yakobo nakamlajiza Yusufu kulawila ibindi lya Hebuloni. Yusufu naloyawele behi na Shekemu, ");
INSERT INTO vid_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","munhu yumwe nakamfika yolubaluba mchiwala, nakamuuza, “Kwangupala choni?” ");
INSERT INTO vid_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Yusufu nakamwidichila, “Ndanguwapala wang'holozangu, dedede, undonjele honhu howali ngudima migongolo.” ");
INSERT INTO vid_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Yula munhu nakamlonjela, “Ndangijesa kota mina woka, kwa vila nandiwahulika wolonga kota wanguluta Dotani.” Lelo Yusufu nakawawinza wang'holoze nakawafika ako Dotani. ");
INSERT INTO vid_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Wang'holoze lowamuwene yang'hali kutali, hanoya behi, nawaheha wogana wamkopole. ");
INSERT INTO vid_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Nawalongasa, “Mloleni! Yula yalingulota kanguya. ");
INSERT INTO vid_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Natumkopole na kumtoza mli izimbo lilihela mazi, hamba tolonga kota nakadakuligwa na igongolo ling'hang'hale lya kisolo. Hamba tolola ako kulota kwa heye kowa ndaze.” ");
INSERT INTO vid_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Ila Lubeni loyahuliche luzi alo, nakagana kumlohola mli moko gawo, nakawalonjela wang'holoze, “Dedede, tuleche kumkopola. ");
INSERT INTO vid_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Mleche kubohola danda. Ila mumjele amu mli ideho hano mchiwala, ila mleche kumlumiza.” Nakalonga ahyo leka yamlohole mmoko mwa hewo, na hamba yamhiluse kwa mhaza wa heye. ");
INSERT INTO vid_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Yusufu loyawafichile wang'holoze, nawamvula ikanzu lya chiuyeng'ha linoligwe. ");
INSERT INTO vid_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Hamba wamibata na kumtoza kuli ideho, ila ideho lila nahaliwele na mazi. ");
INSERT INTO vid_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Lowekalise kulya, nawona majendo ga Waishimaeli wojenda kulawila Gileadi kuza Misili. Ngamiya wa hewo nawapapa ubani na mafuta ga mono na manemane. ");
INSERT INTO vid_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Aho Yuda nakawalonjela wang'holoze, “Topegwa choni wone tumkopole mng'holozetu, na kuvisa kukopola kwa heye?. ");
INSERT INTO vid_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Inoga tumguze kwa awa Waishimaeli, ila tuleche kudita chinhu chiwala ukomu wa heye, kwa vila heye ka mng'holozetu na twaivyazi limwe.” Wang'holoze nawakunda ga heye. ");
INSERT INTO vid_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Waguzaji na wagulaji Wamidiani lowafichile honhu hala, awo wang'holoze wamlavya Yusufu kuli ideho na wamguza kwa Waishimaeli kwa migwala makumi meli, nawo nawamhola Yusufu mbaka Misili. ");
INSERT INTO vid_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Lubeni loyahiluche kuli lila ideho, nahamuwene Yusufu kahi, nakadega nguwo zoyavalile kwa masinzo. ");
INSERT INTO vid_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Nakawalutila wang'holoze na kuwalonjela, “Msongolo ka haduhu, nani ndute kohi?” ");
INSERT INTO vid_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Nawalidumula singo ipongo limwe, nawahola ikanzu lya Yusufu na kwinjiza mli danda ya ila mhene. ");
INSERT INTO vid_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Hamba wamhilichila lila ikanzu mhaza wa hewo, na kumlonjela, “Natulokota ikanzu ali, lole tandi, liwhana kota lya mwanago ama hebu.” ");
INSERT INTO vid_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Mhaza wa hewo nakalizela lila ikanzu, nakalonga, “Ena ng'hatu! Ndangijesa kota ne lunhwinhwi igongolo ling'hang'hale lya kisolo nalimdakula. Ndangukunda Yusufu kadumuligwa viwundewunde.” ");
INSERT INTO vid_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Aho Yakobo nakadega nguwo zoyavalile kwa masinzo na kuvala igunila mchuno kwa kulajila masinzo. Nakamlilila mwanage kwa mhela wa mazuwa menji. ");
INSERT INTO vid_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Wanage walume na wadala nawoya kumhembuliza, ila heye nakalema kuhembulizwa yolonga, “Mndeche ndolutilila kulombocheza kwa mbuli ya mwana wa heni, mbaka hondibagama na kuluta kuli isi ya wabagame koyawele mwana wa heni”. Yakobo nandovyoyamlilile mwanage. ");
INSERT INTO vid_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Mhela awo kula Misili wala Wamidiani nawamguza Yusufu kwa munhu nayachemigwe Potifa, nayawele mng'hangala wa chimwe cha vilundo vya wamizi vya Falao. ");
INSERT INTO vid_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Mhela awo Yuda nakebagula na wang'holoze, nakaluta kikala na munhu yumwe Mwadulami itagwa lyake Hila. ");
INSERT INTO vid_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Loyali ako, Yuda nakamona mhinza wa Shua, Mkanaani, nakamhesa na kuwasa na heye. ");
INSERT INTO vid_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Mhinza wa Shua nakebata himila, nakaponda mwana mlume, Yuda nakamchema Eli. ");
INSERT INTO vid_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Nakahola himila inji, nakaponda mwana mlume, nakamchema Onani. ");
INSERT INTO vid_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Hamba nakaponda mwana yunji mlume, nakamchema Shela. Mhela Shela loyapondigwe, Yuda nayali Kesibu. ");
INSERT INTO vid_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Hamba Yuda nakamhesela mwanage wa mwaluko Eli, kwa mdala yachemigwe Tamali. ");
INSERT INTO vid_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Ila Eli, mlelwa wa mwaluko wa Yuda, nayali na wihe hameho ha Mkulu Nguluwi, ahyo Mkulu Nguluwi nakamkopola. ");
INSERT INTO vid_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Yuda nakamlonjela Onani, “Mhole mdala wa mng'holozo yabagame, ahyo kota vyoilinguganigwa kudita leka umpondele mng'holozo wana kulawa kwa mlamugo.” ");
INSERT INTO vid_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Ila Onani nakavizela kota awo wana hawowa wa heye. Ahyo, loyawasile na mdala wa mng'holoze nakabohola hasi nyhadikwa za lulelo, yolema kumpondela mng'holoze wana. ");
INSERT INTO vid_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Chinhu achi chihile ng'hatu hali meho ga Mkulu Nguluwi, nakamkopola Onani kahi. ");
INSERT INTO vid_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Ndo Yuda nakamlonjela Tamali, mdala wa mwanage, “Uhiluche kaye kwa mhaza wa hegwe, upone kuko ne kuhesigwa mbaka mwana wa heni Shela hoyowa msongolo.” Yuda nakadumba Shela kota kobagama kota wang'holoze. Lelo Tamali nakahiluka kaye kwa mhaza wa heye. ");
INSERT INTO vid_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Hamba mhinza wa Shua, mdala wa Yuda nakabagama. Yuda loyasindile kuwasiliza matanga, nakaluta na mganwa wa heye Hila, Mwadulami, nawaluta Timuna kwa wadumula milaika ja ming'holo ja heye. ");
INSERT INTO vid_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Tamali loyahuliche kota mgosi wa heye nayali mnzila kuluta Timuna kudumula milaika ja ming'holo ja heye, ");
INSERT INTO vid_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","nakavula nguwo za mlekwa, na kigubika nguwo lukuli na kumeho, hamba kaza kikala honhu hawele na lwizi lwa Enaimu, chijiji nachiwele mnzila kuza Timuna. Nakadita ahyo, kwa vila nakona kota Shela nayali msongolo ila heye Tamali nahahesigwe yawe mdala wa heye. ");
INSERT INTO vid_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Yuda nakamfika Tamali aho, nakejesa kota kamdala mng'hondwa, kwa vila nakegubika kumeho. ");
INSERT INTO vid_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Aho ne kuvizela kota ayo nayali mdala wa mwanage, nakamlutila hala hafungo mwa nzila na kumlonjela, “Ndagugana kuwasa nagwe.” Tamali nakamuuza, “Komha choni hondikunda?” ");
INSERT INTO vid_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Yuda nakamwidichila, “Ndokupa kanyehe ka mhene mli chilundo cha heni.” Tamali nakamlonjela, “Wilahe na undechele chinhu kota chilajilo cha kungalila ako kanyehe.” ");
INSERT INTO vid_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Yuda nakamuuza, “Kwangugana ndikupe choni chiwe ulajilo?” Na heye nakamwidichila, “Umhe ayo pete iwele na ulajilo wa hegwe na ng'weso ya pete ayo na ayo ng'hweku ndivibate.” Yuda nakamha vinhu avyo vyeng'ha, nakawasa naye. Baho Tamali nakebata himila ya heye. ");
INSERT INTO vid_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Tamali nakahiluka kaye, nakavula nguwo nazoyavalile nakuvala kahi nguwo za heye za ulekwa. ");
INSERT INTO vid_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Mhela Yuda loyamlajize Mwadulami yamhilichile kala kanyehe yula mdala leka yahiluse vinhu vyoyampele kota ulajilo, Hila nahamfichile. ");
INSERT INTO vid_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Hila nakawauza wenyeng'haye wa Enaimu, “Kakohi yula mdala mng'hondwa nayawele hafungo mwa nzila behi na hano?” Wamwidichila, “Enaimu hakuwele na mdala mng'hondwa.” ");
INSERT INTO vid_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Ayo munhu nakahiluka kwa Yuda, nakamlonjela, “Simuwene. Kahi wenyeng'haye wa ako nawandonjela kota hakuwele na mdala mng'hondwa yoneche ako.” Wadala wanji nawali wodita ung'hondwa kota honhu ha kujifugamila jimalukolo jawo ");
INSERT INTO vid_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Yuda nakalonga, “Leche yahole vinhu avyo, hanji kotudita tusechigwe. Hegwe baho kona kota nandimigalila kanyehe, ila humuwene.” ");
INSERT INTO vid_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Lojikwete myezi jidatu, Yuda nakahulika kota, “Tamali mdala wa mwanage, kagaluka mng'hondwa, kahi kana himila kwa kudita ung'hondwa.” Yuda nakalajiza, “Mlavyeni kunze yasomigwe na chiluli.” ");
INSERT INTO vid_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Lowali womlavya kunze, Tamali nakalajiza usenga kwa mgosi wa heye yolonga, “Yawele na vinhu avi ndo yamhele himila. Lelo ndangugana umzele munhu yawele na pete ayi na ng'weso na ng'hweku ayi.” ");
INSERT INTO vid_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Yuda nakavizela vinhu avyo, nakalonga, “Tamali ndo yatanganiche kusinda heni, mina ndangukomya, simhesile heye kwa mwana wa heni Shela.” Kulawila zuwa alyo, Yuda hawasile kahi na Tamali. ");
INSERT INTO vid_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Mhela wa kuponda Tamali loufichile, naizeleka kota kana wanyambili. ");
INSERT INTO vid_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Usungu wa kuponda lowaluche, mwana yumwe nakalavya moko kunze, na heye mkunga kauwoha ng'weso ndung'hu, yolonga, “Ayu ndo yapondigwe mwaluko.” ");
INSERT INTO vid_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Ila mwana ayo loyahiluse moko mgati, mng'holoze nakatoma kupondigwa. Mkunga nakalonga, “Ndaze hegwe kupondigwa kwa lupichi?” Ahyo, nakachemigwa Pelesi. ");
INSERT INTO vid_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Hamba mng'holoze nakapondigwa yawele na ng'weso ndung'hu mmoko, na heye nakachemigwa Sela. ");
INSERT INTO vid_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Yusufu loyaholigwe mbaka Misili, Mmisili yumwe nayachemigwe Potifa yawele chilongozi wa Falao na chilongozi wa chilundo cha heye cha wamizi, nakamgula kulawa kwa Waishimaeli wamigale Misili. ");
INSERT INTO vid_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Mkulu Nguluwi, nayali hamwe na heye Yusufu, nakamdita yasumye ng'hatu. Yusufu nayali yochikala mli ng'handa ya mkulu wa heye Mmisili. ");
INSERT INTO vid_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Ayu mkulu wa heye nakavizela kota Mkulu Nguluwi nayali hamwe na Yusufu na ndo heye yaditile yasumye geng'ha yalingudita Yusufu. ");
INSERT INTO vid_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Yusufu nakaganika ng'hatu hali Potifa na ndo yawele chitumagwa wa heye nakadita yawe chilongozi wa ng'handa ya heye na lufufu lweng'ha. ");
INSERT INTO vid_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Kulawila mhela Potifa loyamditile Yusufu yawe mwamizi wa ng'handa ya heye na mwamizi wa lufufu lwake, Mkulu Nguluwi nakaitambichiza ng'handa ya ayo Mmisili kwa mbuli ya Yusufu. Utambichizo wa Mkulu Nguluwi uwa kwa chila chinhu choyawele nacho haluga na kumgunda. ");
INSERT INTO vid_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Kwa mbuli ayo, Potifa nakamha ludali lwa vinhu vya heye vyeng'ha, na heye Potifa, nakaleka kudita choneche chila ila kulya chilyo cha heye yeka. Yusufu nayali msongolo yanojile na wa kuganigwa. ");
INSERT INTO vid_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Loukwete mhela udo hela, mdala wa Potifa nakanojezwa na heye Yusufu nakamlonjela, “Uwase na heni.” ");
INSERT INTO vid_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Ila Yusufu nakalema na kumlojela ayo mdala wa Potifa, “Hebu! Mkulu wa heni kamha ludali lwa chila chinhu hano haluga, na kwa vila ndahano, kahela lunhwinhwi kuwala chinhu choneche. ");
INSERT INTO vid_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Ahano haluga heye kahela ludali kusinda heni. Heye handemeze kibata choneche ila hegwe kwa vila kwa mchewake. Lelo yowa ndaze ndite wihe ukulu na gehile hali Nguluwi.” ");
INSERT INTO vid_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Ayo mdala nakalutilila kumlanda Yusufu chila zuwa, ila Yusufu nahamhulichize na kukunda kikala behi na heye ama kuwasa na heye. ");
INSERT INTO vid_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Zuwa limwe Yusufu nakenjila mng'handa kukola mijito kota vyoilinguganigwa, nayali yeka kwa vila walume wanji nawakolasa hamwe mijito nawali haduhu haluga. ");
INSERT INTO vid_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Mdala wa Potifa nakamibata ikanzu lyake na kumlonjela, “Uwase na heni.” Ila Yusufu nakamlechela lila ikanzu mmoko mwa heye nakabilimila kunze. ");
INSERT INTO vid_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Aho yula mdala loyawene Yusufu nakamlechela igolole mmoko mwa heye nakabilimila kunze, ");
INSERT INTO vid_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","nakawachema vitumagwa wa ng'handa ya heye na kuwalonjela, “Loleni! Ayu Muebulaniya yotugalilwe kangutubasa soni. Nakoya kwa heni yogana kimbata kwa lupichi, ila heni nanhowa iyowe.” ");
INSERT INTO vid_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Loyahuliche nditowa iyowe, nakalileka igolole lyake, na kubilimila kunze. ");
INSERT INTO vid_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Yula mdala nakaliwika behi na heye lila igolole mbaka mlume wa heye loyahiluche haluga. ");
INSERT INTO vid_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Nakamsimila mbuli ila yolonga, “Ayu chitumagwa Muebulaniya umigale kwa hetwe, nakambuyila kumbasa soni.” ");
INSERT INTO vid_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Ila baho du lonhowile iyowe, nakalileka igolole lyake na kubilimila kunze. ");
INSERT INTO vid_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Mkulu wa Yusufu loyahuliche ulonzi wa mchewake, kota chitumagwa wa heye ndovyoyaditile, nakazudila lukami. ");
INSERT INTO vid_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Nakamhola Yusufu na kumhindila mchinweng'ho, honhu nahowahindilwe wanhu wawele na nongwa kwa mndewa. Ahyo Yusufu nakapona hala mchinweng'ho. ");
INSERT INTO vid_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Ila mbaka amo mchinweng'ho, Mkulu Nguluwi nayali hamwe na Yusufu, yomditila igano lya kwimilila mbaka kumdita yaganigwe hali mkulu wa chinweng'ho. ");
INSERT INTO vid_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Ayo mkulu wa chinweng'ho nakamuwika Yusufu yawe chilongozi wa weng'ha wawele mchinweng'ho. Chila chinhu chiditikwe amo, nachiditikwa kwa ludali lwake. ");
INSERT INTO vid_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Ayo mkulu wa chinweng'ho nahajesile chinhu choneche chila choyapegwe Yusufu, kwa vila Mkulu Nguluwi nayali hamwe na Yusufu na nakasumya chila chinhu choyaditile. ");
INSERT INTO vid_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Mhela wunji lozikwete mbuli azo, vilongozi weli wa mndewa wa Misili nawamditila wihe mndewa. Vilongozi awo wali mlolela vyakunwa mkulu na mgongomanya mibumunda mkulu wa mndewa. ");
INSERT INTO vid_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Falao nakazudizwa ng'hatu na awo vilongozi weli, ");
INSERT INTO vid_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","nakawahindila mgati mwa chinweng'ho cha mkulu wa chilundo cha wamizi honhu nahoyahindilwe Yusufu. ");
INSERT INTO vid_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Mkulu wa chilundo cha wamizi nakamhagula Yusufu yawe chitumagwa wa hewo. Nawo nawekala mchinweng'ho mhela umwenga. ");
INSERT INTO vid_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Nechilo imwe, yula mlolela vyakunwa mkulu, na yula mgongomanya mibumunda mkulu wa mndewa wa Misili, chila yumwe nakalota ilivinji na chila ulotezi nawali na utang'huzi ulivinji. ");
INSERT INTO vid_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Yusufu loyalutile kwa hewo lufuku kuwalola, weng'ha weli wali na lunhwinhwi. ");
INSERT INTO vid_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Yusufu nakawauza awo vilongozi wa Falao nawawele mchinweng'ho hamwe na heye, mng'handa mwa mkulu wa heye, “Ndaze, lehano mwangoneka mna masinzo?” ");
INSERT INTO vid_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Nawamwidichila, “Tuna masinzo kwa vila kuduhu munhu ne yumwe yatutang'ulile vyotulotile.” Yusufu nakawalonjela, “Ndaze, kutang'hula kulota aku haiwa mijito ja Nguluwi? Lelo mndonjele kulota kwa hemwe.” ");
INSERT INTO vid_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Mlolela vyakunwa mkulu wa mndewa nakamsimila Yusufu vyoyalotile yolonga, “Nandota hino, nambona mzabibu kumwando kwa heni, ");
INSERT INTO vid_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","nawo wali na nhagala zidatu. Baho du, lowaluche kutitima mahamba, uluwa ubahula, na ving'honyo vyake viwa zabibu zipile. ");
INSERT INTO vid_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Mmoko mwangu ndali na chizombe cha Falao, ng'hama zabibu mli chizombe acho, na ndimha Falao.” ");
INSERT INTO vid_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Yusufu nakamlonjela ayo chitumagwa, “Kutang'hula kwa vyoulotile ndo hino, zila nhagala zidatu ndo mazuwa gadatu. ");
INSERT INTO vid_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Logopuluta mazuwa gadatu, Falao kokwinula nakolawa mchinweng'ho na kukuhilusa kahi mli ulongozi louwele nawo. Koweza kahi kumha Falao chizombe mmoko kota vyowali udita aho katali. ");
INSERT INTO vid_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Ila dedede, uleche kusemwa ndiyago mhela mbuli hozikulutila goya, unhowanhile na kunyhema hali Falao nani ndawe amu mchinweng'ho. ");
INSERT INTO vid_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Mina heni nyholigwa kuli isi ya Waebulaniya na hano Misili siditile choneche chindapa mbichigwe mchinweng'ho.” ");
INSERT INTO vid_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Yula mgongomanya mibumunda mkulu, loyawene utang'huzi ula unoga, nakamlonjela Yusufu, “Na heni nandota, ndidwiche kumutwi nyhelo zidatu za mibumunda. ");
INSERT INTO vid_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Kuli luhelo lwa kuchanya, mwali na vilyo vinji vitelechigwe kwa mbuli ya mnvina ya Falao. Ila videje vyali vidobola na kulya kuli luhelo alo naluwele kumutwi wa heni.” ");
INSERT INTO vid_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Yusufu nakamlonjela, “Ulaguzi wa vyoulotile ndo awu, zila nyhelo zidatu ndo mazuwa gadatu. ");
INSERT INTO vid_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Logopuluta mazuwa gadatu, Falao kokulavya mchinweng'ho, kowinula mutwi wa hegwe na kuniniza lukuli mchanya mli igodi, navyo videje vyolya lukuli lwako.” ");
INSERT INTO vid_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Kuli zuwa lya kadatu, iwele ndo zuwa lya mnvina ya kukumbuchila kupondigwa kwa Falao nakawawichila chilyo wakulu wa heye weng'ha. Nakawalavya mchinweng'ho mlolela vyakunwa mkulu na mgongomanya mibumunda mkulu, nakawawika hali wakulu wanji wa heye. ");
INSERT INTO vid_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Hamba nakamhilusila ukulu yula mlolela vyakunwa, leka yamigalile Falao chizombe. ");
INSERT INTO vid_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Ila yula mgongomanya mibumunda nakamniniza kuli igodi, kota Yusufu navyoyatang'ule kulota kwa hewo. ");
INSERT INTO vid_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Ahyo, yula mlolela vyakunwa nakamsemwa Yusufu, honhu ha kumkumbuka. ");
INSERT INTO vid_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Lojikwete miyaka mili, Falao nakalota, nakewona yemile hafungo mwa lwanda lwa Naili, ");
INSERT INTO vid_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","nakona misenga saba jinenehe na kunojeza jilawa mlwanda lwa Naili na kuya kulya misolo. ");
INSERT INTO vid_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Hamba misenga jinji saba jigandile na jihile ng'hatu najilawa mlwanda lwa Naili, juya na kwima behi na jila misenga jinenehe hafungo mwa lwanda. ");
INSERT INTO vid_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Ajo misenga jigandile lukami najiwalya jila misenga jinenehe, aho Falao nakalilimka. ");
INSERT INTO vid_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Loyawasile kahi, nakalota lwa keli, nakona miso mikulu saba ja uhemba na jititime jizuchile mli ibeleje limwe. ");
INSERT INTO vid_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Hamba logakwete ago, miso jinji saba mizisili jikalile kwa ivuche lya mbeho kulawa kugunuche nalilawila. ");
INSERT INTO vid_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Ajo miso saba, najimela jila miso saba jitiliwale jinenehe na jiwele na nyhule nyinji. Falao loyalilimche, nakavizela kota nayali yolota. ");
INSERT INTO vid_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Lokubwemwenzuche, Falao yawele na lunhwinhwi lukami, nakawachema wahawi weng'ha wa Misili na wawele wasomile lukami na kuwalonjela navyoyalotile, ila kuduhu ne yumwe yadahile kutang'ula vyoyalotile. ");
INSERT INTO vid_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Ndo yula mlolela vyakunwa mkulu nakamlonjela Falao kata, “Lehano ndangukumbuchila hala londitile gehile ga heni. ");
INSERT INTO vid_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Mhela wula loutuzudile hetwe vitumagwa wa Falao, heni na mgongomanya mibumunda, nakutuhindila mng'handa mwa ngome ya mkulu wa chilundo cha wamizi. ");
INSERT INTO vid_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Nechilo imwe natulota, chila yumwe nakalota ilivinji na chila ulotezi nawali na utang'huzi ulivinji. ");
INSERT INTO vid_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Lelo msongolo yumwe Muebulaniya, chitumagwa wa mkulu wa wamizi, nayali hamwe na hetwe mchinweng'ho. Lotumsimile kulota kwa hetwe, na heye nakatutang'ulila chila yumwe wa hetwe choyalotile. ");
INSERT INTO vid_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Na iwa kota vila vyoyatutang'ulile. Heni nanyiluswa kuli mijito ja heni na yula mgongomanya mibumunda nakaninizwa kuli igodi.” ");
INSERT INTO vid_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Lelo Falao nakahilika wanhu, nakamchema Yusufu, nawamigala himahima kulawila kuchinweng'ho. Nakabeya mnvili na kuvala nguwo zinji na kwinjila kwa Falao. ");
INSERT INTO vid_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Falao nakamlonjela Yusufu, “Ndota ila kuduhu munhu yadahile kutang'hula. Nanyhulika lutogo lwa hegwe kota wone munhu yakulonjele kulota kwa heye koweza kutang'hula.” ");
INSERT INTO vid_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Yusufu nakamwidichila Falao, “Ndahela uwanzi awo, ila Nguluwi kokwidichila vitanganiche.” ");
INSERT INTO vid_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Aho Falao nakamlonjela Yusufu, “Nandota kota nanyhima hafungo mwa lwanda lwa Naili, ");
INSERT INTO vid_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","nambona misenga saba jinojile na jinonile jilawa mlwanda lwa Naili na kulya misolo. ");
INSERT INTO vid_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Awo nawawinzwa na misenga jinji saba jigandile lukami. Heni sinajona misenga jifandile kota ajo kuli isi ya Misili. ");
INSERT INTO vid_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Lelo jila misenga jigandile lukami jiwadakula jila misenga saba jinenehe lukami. ");
INSERT INTO vid_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Ila lojiwadakule jila misenga jinenehe, munhu yoneche howeza kuvizela kota najiwadakula jiyawo, kwa vila najali jigandile hihila kota mwaluko. Aho nandilimka kulawa kuli kuwasa. ");
INSERT INTO vid_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Kahi nandota, mbona miso saba jimemile nyhule jitiliwale kuli ibeleje limwe. ");
INSERT INTO vid_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Hamba najiwinzigwa na miso minji saba jilihela chinhu, jigandile na jikalile kwa ivuche lya mbeho ya kugunuche. ");
INSERT INTO vid_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Jila mizuchila jigandile jimela jila mizuchila saba jitiliwale. Lelo heni nandiwalonjela wahawi kulota aku ila kuduhu munhu yadahile kundonjela goya.” ");
INSERT INTO vid_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Aho Yusufu nakamlonjela Falao, “Kulota kwa hegwe kweng'ha kwangulajila mana imwe. Nguluwi nakakugubulila mbuli zoyalingugana kudita behi hihi. ");
INSERT INTO vid_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Jila misenga saba jinonile, ndo miyaka saba, na jila mizuchila saba jinonile ndo miyaka saba kahi, kulota kwa hegwe kuna mana imwe. ");
INSERT INTO vid_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Jila misenga jigandile lukami, jiwadakule jila misenga jinonile, na jila miso saba jilihela chinhu jikalizwe na ivuche lya mbeho kula kugunuche, izeleche kota ndo miyaka saba ja nzala. ");
INSERT INTO vid_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Kota vyondikulonjele, hegwe Falao, Nguluwi nakakugubulila mbuli zoyalingugana kudita behi hihi. ");
INSERT INTO vid_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Kowa na miyaka saba ja kiguta kuli isi yeng'ha ya Misili. ");
INSERT INTO vid_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Ila hamba kowa na miyaka saba ja nzala, na kiguta kuleche kukumbuchilwa. Nzala ayo yoigaza isi ino. ");
INSERT INTO vid_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Kiguta ako kuleche kukumbuchilwa ng'hatu kwa vila nzala yoikuya yowa ng'hulu lukami. ");
INSERT INTO vid_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Kulota kwa hegwe nakuya mala mbili kwa nhelo mbili zilingiwhana kukulajila kota Nguluwi nakamula kwa kukomya kudita ahyo, na heye kodita mbuli ayo behi hihi. ");
INSERT INTO vid_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","“Lelo inoga sambi, hegwe Falao, umlajize munhu yawele na uwanzi na luhala, umhe mijito na ludali lwa kuilolela isi yeng'ha ya Misili. ");
INSERT INTO vid_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Kahi, gwaa Falao, wahagule wamizi wanji hano muisi, uwalonjele wakungajize chinhu chimwe kuli chila vinhu vihano vya mbena yeng'ha ya Misili kuli mhela uno wa miyaka saba ya kiguta. ");
INSERT INTO vid_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Uwalonjele awo wamizi wakungajize chilyo cheng'ha kuli miyaka saba ilinguya ya mbena kwa winji. Nyhule azo ziwichigwe hali ludali lwa wamizi wa hegwe, gwaa Falao, iwe ng'hano ya chilyo kwa miji jeng'ha, nawo wailolele nyhule ayo. ");
INSERT INTO vid_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Chilyo acho chowa ng'hano ya hamba kwa isi ya Misili leka ileche kubagama kwa nzala ya miyaka saba ilinguya.” ");
INSERT INTO vid_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Kwamula koyamule Yusufu nakoneka kunoga hali Falao na wakulu wa heye weng'ha. ");
INSERT INTO vid_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Ahyo Falao nakawauza wakulu wa heye, “Munhu ayu kana muhe wa Nguluwi. Ndaze, towa na munhu yunji kahi kota ayu?” ");
INSERT INTO vid_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Hamba Falao nakamlonjela Yusufu, “Kwa vila Nguluwi nakakugubulila aga geng'ha, kuduhu munhu yawele na luhala na nyhala kota hegwe. ");
INSERT INTO vid_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Hegwe ndo munhu yoilongoza isi ya heni, na wanhu wa heni weng'ha wowa hali ulongozi wa hegwe. Heni hela ndo mkulu kuleka hegwe kwa vila ndangukalisa hali chigoda cha undewa. ");
INSERT INTO vid_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Lelo Yusufu ndangukuwika sambi uwe mkulu wa isi yeng'ha ya Misili.” ");
INSERT INTO vid_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Aho Falao nakailavya pete iwele ulajilo wa heye hali chidole cha heye na kumvika Yusufu, nakamvika na ivalo lya heye lya kitani inojile na ugasi wa dhahabu kuli singo ya heye. ");
INSERT INTO vid_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Falao nakamkwinhiza kuli mutuka ya heye ya keli ya falasi na wamizi nawelongoza kumwando kwa Yusufu wotowa iyowe na kulonga, “Mumfugamile!” Ahi ndo Falao vyoyampele Yusufu ulongozi mkulu hali isi yeng'ha ya Misili. ");
INSERT INTO vid_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Kupuluta kwa aga, Falao nakamlonjela Yusufu, “Heni ndo Falao. Ndangulonga, munhu yoneche hali isi yeng'ha ya Misili yaleche kudita chinhu choneche ne kukundizwa na hegwe.” ");
INSERT INTO vid_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Falao nakamgalila Yusufu itagwa lya Chimisili, Safenati-paneya. Nakamhesela Asenati mhinza wa Potifela, mtambika wa muji wa Oni. Lelo Yusufu nakaluka kijendela isi yeng'ha ya Misili. ");
INSERT INTO vid_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Yusufu nayali na miyaka makumi gadatu loyaluche kumkolela mijito Falao, mndewa wa Misili. Nakalawa kaye kwa Falao na kuijendela isi yeng'ha ya Misili. ");
INSERT INTO vid_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Kuli miyaka ila saba ya kiguta, migunda ja Misili najilavya mbena nyinji lukami. ");
INSERT INTO vid_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Yusufu nakakungajiza chilyo cheng'ha mhela ula wa miyaka saba ya kiguta na kuwika ng'hano kuli miji ja Misili. Kuli chila muji nakawika ng'hano kulawa kuli migunda ja behi na muji awo. ");
INSERT INTO vid_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Yusufu nakawika nyhule mng'hano kwa winji ng'hatu naiwa nyinji kota sangalaza ya bahali, mbaka nailemwela kuwazika. ");
INSERT INTO vid_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Kung'hali kwaluka miyaka ja nzala, Yusufu nayali na wana walume weli kwa mchewake Asenati, mhinza wa Potifela, mtambika wa muji wa Oni. ");
INSERT INTO vid_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Yusufu nakamchema wana wa heye wa mwaluko Manase, yolonga, “Nguluwi nakandita ndisemwe kugaya kwa heni kweng'ha na wang'holoze mhaza wa heni.” ");
INSERT INTO vid_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Mwana wa heye wa keli nakamchema Efulaimu, yolonga, “Nguluwi nakangalila mwana kuli isi ya kugaya kwa heni.” ");
INSERT INTO vid_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Miyaka jila saba ja kiguta hala Misili najikola. ");
INSERT INTO vid_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","Najaluka miyaka saba ja nzala kota navyoyalonjile Yusufu hala hamwande. Isi zinji zeng'ha nazali na nzala, ila isi yeng'ha ya Misili nayali na chilyo. ");
INSERT INTO vid_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Wanhu wa Misili lowaluche kona nzala, nawamlilila Falao yawagalile chilyo. Na heye Falao nakawalonjela Wamisili weng'ha, “Mlute kwa Yusufu, loyawalonjelani mkole mumhulichize.” ");
INSERT INTO vid_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Nzala nailutilila kuwa ng'hulu na kwenela isi yeng'ha. Aho Yusufu nakachumula ng'hano zeng'ha, nakawaguzila Wamisili chilyo. ");
INSERT INTO vid_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Wanhu kulawa chila honhu muisi nawoya Misili kwa Yusufu kugula chilyo, kwa vila nzala nayali ng'hulu kuli isi yeng'ha. ");
INSERT INTO vid_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Yakobo naloyahuliche kota kwali na nyhule ako Misili, nakawalonjela wanage, “Lekachoni mwangikalisa mchilola hela? ");
INSERT INTO vid_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Nanyhulika kota Misili kuna nyhule. Mlute ako mkagule nyhule tuleche kubagama kwa nzala.” ");
INSERT INTO vid_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Ahyo, wang'holoze kumi wa Yusufu nawaluta Misili kugula nyhule. ");
INSERT INTO vid_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Ila Yakobo nahamlechile Benjamini mng'holoze Yusufu yalute hamwe na hewo mina nakadumba kota koweza kugazigwa. ");
INSERT INTO vid_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Lelo wana wa Isilaeli nawafika Misili wawele na wanhu wanji walutile kugula chilyo, mina kuli isi ya Kanaani nako kwali na nzala. ");
INSERT INTO vid_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Mhela awo Yusufu nayali ndo chilongozi ako Misili. Heye ndo yawele na ludali lwa kuwaguzila wanhu chilyo. Wakulugwe nawoya kumwinamila mbaka hali magulu ga Yusufu kwa kufugama. ");
INSERT INTO vid_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Yusufu loyawawene wakulugwe nakawazela, ila heye nakawadita kota wajenzi, nakalonga nawo aku yang'hang'hale. Nakawauza, “Mlawila kohi hemwe?” Nawamwidichila, “Tulawila isi ya Kanaani, tuya kugula chilyo.” ");
INSERT INTO vid_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Hanga Yusufu nakawazela wakulugwe, hewo nahawamzelele. ");
INSERT INTO vid_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Yusufu nakakumbuchila navyoyalotile katali kwa mbuli ya wakulugwe, nakawalonjela, “Hemwe muya kutupugajiza. Muya kulola isi ya hetwe vyoiwele na kubowala” ");
INSERT INTO vid_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Hewo wamwidichila, “Hebu, mkulu wa hetwe. Hetwe vitumagwa wa hegwe tuya kugula chilyo. ");
INSERT INTO vid_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Hetwe twa lukolo, wana wa mhaza yumwe. Hetwe twa vitumagwa wa hegwe na twa wanhu tutanganiche, na hatuwele wapugajizi hebu.” ");
INSERT INTO vid_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Ila Yusufu nakalonga, “Hebu! Hemwe muya kulola kubowala kwa isi ya hetwe.” ");
INSERT INTO vid_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Nawamlonjela, “Hetwe, vitumagwa wa hegwe, twa kumi na mbili, wana wa munhu yumwe, wenyeng'haye wa isi ya Kanaani. Mdodo wa hetwe nakapona na mhaza kaye, na mng'holozetu yunji kabagama.” ");
INSERT INTO vid_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Ila Yusufu nakawalonjela, “Kota navyondonjile, hemwe mwa wapugajizi hela. ");
INSERT INTO vid_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Ahi ndo vyomjezigwa, ndangilaha kwa itagwa lya Falao, kota hamlawa aha mbaka mdodo wa hemwe hoyokuya. ");
INSERT INTO vid_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Mumlajize yumwe wa hemwe yakamigale ayo mng'holozenu mdodo, hanga wayenu wanji wombeteza mchinweng'ho. Aho ndo ulonzi wa hemwe wozeleka kukomya kokuli. Wone hebu, ndangilaha kwa itagwa lya Falao kota hemwe mwa wapugajizi.” ");
INSERT INTO vid_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Hamba nakawawika weng'ha mchinweng'ho kwa mhela wa mazuwa gadatu. ");
INSERT INTO vid_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Zuwa lya kadatu, Yusufu nakawalonjela, “Kwa vila heni ndangumdumba Nguluwi, mdite hino leka muwe wakomu. ");
INSERT INTO vid_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Wone mkomya hemwe mtanganika, yumwe wa hemwe yapone mchinweng'ho na wanji wawegalile nyhule wang'holozenu wawele na nzala. ");
INSERT INTO vid_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Hamba mmigale kwa heni mdodo wa hemwe. Ayi yotawiza kukomya kwa ulonzi wa hemwe, namwe hamkopoligwa.” Lelo nawakunda kudita ahyo. ");
INSERT INTO vid_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Hamba walongasa hewo kwa hewo, “Twangukomya hetwe tumditila vibi mng'holozetu. Hanga natumona yawele na ching'oni mnhumbula, hetwe nahatumhulichize hala nahoyatulandile. Ndo mina kugaya aku kweng'ha kutuyila.” ");
INSERT INTO vid_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Lubeni nakawalonjela, “Ndaze, hemwe nasiwalonjelani tuleche kumditila gehile mng'holozetu? Ila hemwe nahamnyhulichize. Lelo twangugazigwa kwa mbuli ya danda ya heye.” ");
INSERT INTO vid_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Hewo nahawavizelele kota Yusufu nakavizela geng'ha ago gowalonjile, mina naloyalonjile na hewo nayali kwa nzila ya munhu yavizelele ulonzi ula. ");
INSERT INTO vid_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Yusufu nakaluta hafungo, nakaluka kulila. Loyanyamalile, nakahiluka kulongasa na hewo. Hamba nakamibata Simeoni na kumuwopa pingu hali meho ga hewo. ");
INSERT INTO vid_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Yusufu nakalajiza mihako jawo jiwichigwe nyhule, chila yumwe yahilusilwe migwala ja heye mli mhako wa heye na wapegwe ndiya ya mnzila. Nawaditilwa mbuli azo zeng'ha. ");
INSERT INTO vid_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Wawadwika midogowi jawo mihako jawo ja nyhule na kuka. ");
INSERT INTO vid_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Naiwa lowafichile honhu ha kuwasa wajenzi ako kunzila, yumwe wa hewo nakagubula igunila lyake leka yalipe chilyo idogowi lyake, nakabubuwala kona migwala hamlomo mwa igunila. ");
INSERT INTO vid_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Nakawalonjela wang'holoze, “Migwala ja heni jeng'ha jihiluswa. Azino hano hamlomo mwa igunila lyangu!” Lowahuliche ago, nawagozola. Nawelola aku wokakama na kiwuza, “Ndo mbuli yachi ayi yatuditile Nguluwi?” ");
INSERT INTO vid_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Lowafichile isi ya Kanaani kwa mhaza wa hewo Yakobo, nawamsimila geng'ha gayawafichile nawamlonjela, ");
INSERT INTO vid_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","“Mndewa wa isi ila nakalonga natwe kwa kung'hang'hala, na kijesa kota hetwe twangupugajiza gali mli isi ya heye. ");
INSERT INTO vid_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Ila hetwe natumlonjela kota hetwe twa wanhu watanganiche na hatulingupugajiza isi ya wanhu. ");
INSERT INTO vid_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Natumlonjela hetwe twa kumi na weli wa mhaza yumwe, na yumwe wa hetwe nakabagama na yula mdodo ka kaye kuli isi ya Kanaani hamwe na mhaza wa hetwe. ");
INSERT INTO vid_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Ndo chilongozi wa isi ila nakatulonjela, ‘Ahi ndo vyondiwazela kota hemwe mwangukomya kota mwa wanhu wa kukomya, mlecheni kwa heni yumwe wa hemwe, namwe mponile muhiliche chilyo kaye kwa wanhu wa hemwe wawele na nzala. ");
INSERT INTO vid_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Hamba mmigale kwa heni ayo mdodo wa hemwe na aho ndovizela kota hemwe hamuwele wasunjilila wa isi ya wanhu ila mwa wanhu mtanganiche. Homdita ahyo ndomlechela mng'holozenu, namwe mokundigwa muwe mguza na kugula vinhu kuli isi ayi.’ ” ");
INSERT INTO vid_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Lowali wojida nyhule mli migunila jawo, nawabubuwala kona chila yumwe wa hewo kahilusilwa mhako wa sendi mgati mwa igunila lya heye. Lowawene ago, weng'ha hamwe na mhaza wa hewo nawamema majesa. ");
INSERT INTO vid_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Mhaza wa hewo Yakobo, nakawalonjela, “Mwangumboka wana wa heni! Yusufu haduhu, Simeoni haduhu, sambi mwangugana kumhola Benjamini. Nongwa zeng'ha azo zifika heni!” ");
INSERT INTO vid_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Aho Lubeni nakamlonjela mhaza wa heye, “Wone ndemwele kumhilusa Benjamini, wakopole wana wa heni weli. Mleche Benjamini mmoko mwa heni, nani ndomlolela na kumhilusa kwa hegwe.” ");
INSERT INTO vid_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Ila mhaza wa heye nakamwidichila, “Mwana wa heni holuta na hemwe, mng'holoze mina nakabagama, na heye yeka ndo yaponile. Heni ndala ndina mbuliza hekwa, wone msongolo ayu yafichigwe na nongwa yoneche mlimajendo yomkwaluka, mweng'ha monyilika kuli isi ya wabagame mbele ng'hongoloka na mbuliza na memile masinzo.” ");
INSERT INTO vid_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Hamba nzala nailutilila kung'hang'hala ng'hatu kuli isi ila ya Kanaani. ");
INSERT INTO vid_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Chila chilyo nachowagulile kula Misili nalochimalile, Yakobo nakawalonjela wanage, “Mlute kahi Misili mkatugulile chilyo.” ");
INSERT INTO vid_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Ila Yuda nakamlonjela mhaza wa heye, “Yula munhu nakatulonjela yang'ang'ale yolonga, ‘Siwabochela wone hamuyile na mng'holozo mdodo.’ ");
INSERT INTO vid_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Wone kokunda Benjamini tulutase, lelo toluta kukugulila chilyo. ");
INSERT INTO vid_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Ila wone hulingukunda tulutase hamwe, hatuluta hebu ako, kwa vila yula munhu nakatulonjela hazelu, ‘Hammbona homkuya ne mdodowenu.’ ” ");
INSERT INTO vid_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Isilaeli nakalonga, “Lekachoni mnyinjize kuli magazo kwa kumlonjela ayo munhu kota mwanaye mng'holozenu yunji?” ");
INSERT INTO vid_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Nawamwidichila, “Yula munhu nakatuuza yakangaze ng'hatu kwa mbuli ya ivyazi lya hetwe yolonga, ‘Ndaze, mhaza wa hemwe yang'hali mkomu? Ndaze, mwanaye mng'holozenu yunji?’ Ahyo natumwidichila kota vyoyatuuzile. Hatulinguvizela kota kotulonjela, ‘Mmigale mng'holozenu.’ ” ");
INSERT INTO vid_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Yuda nakamlonjela, Yakobo mhaza wa heye, “Ung'hundize heni ndute na heye leka tuche himahima, tuche tukakugulile chilyo, tuleche bagama na nzala hamwe na hegwe na wana wa hetwe. ");
INSERT INTO vid_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Nene baha ndowa mwamizi wa heye. Hegwe kondanda heni. Wone simhiluse umone kwa meho gako, nongwa yeng'ha iwe kwa heni mazuwa gose. ");
INSERT INTO vid_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Wone nahatukawile, natwali tulutile na kuhiluka lwa keli.” ");
INSERT INTO vid_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Aho Yakobo mhaza wa hewo nakawalonjela, “Lelo, kwa yangulapigwa iwe ahyo, lelo mdite ahi, mhole gamwe ga chilyo cha isi ya hetwe mli mihako ja hemwe, mumhilichile ayo chilongozi ndolendole. Mumholele mafuta mado ga mkwaju na hanombwa nyindo na ifunyizi na manemane na kungu na ng'weme. ");
INSERT INTO vid_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Mhole na migwala mala ya keli na zila zilingulapigwa, kwa vila mwanguganigwa kuhilusa migwala jila jiwichigwe mmigunila ja hemwe, hanji nazihiluswa ne kuvizela. ");
INSERT INTO vid_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Mumhole na mng'holozenu mlutase kwa ayo munhu. ");
INSERT INTO vid_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Mkulu Nguluwi Yawele na Mong'ho yawonele isungu hali munhu ayo yawalechele yula mng'holozenu yunji na Benjamini wahiluche hamwe na hemwe. Heni loindapa kifiligwa na wana wa heni ena.” ");
INSERT INTO vid_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Aho nawahola zila ndolendole na migwala jonjezeche lwa keli, nawaluta Misili hamwe na mng'holozo Benjamini. Lowafichile nawaluta na kwima hali Yusufu. ");
INSERT INTO vid_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Yusufu loyamuwene Benjamini hamwe na hewo, nakamlonjela chitumagwa wa ng'handa ya heye, “Wahiliche wanhu awa hakaye hangu, ukome igongolo limwe na kugongomanya goya, mina wanhu awa wolya chilyo cha nemisi hamwe na heni.” ");
INSERT INTO vid_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Chitumagwa ayo nakadita kota navyoyalajizwe, nakawahilika wala wajenzi kaye kwa Yusufu. ");
INSERT INTO vid_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Lowawene wahilikwe kuli ng'handa ya Yusufu nawamema majesa, nawalonga hewo kwa hewo, “Tigaligwa kuno kwa mbuli ya jila migwala jotuhilusilwe mli migunila ja hetwe nalotuyile hala ha mwaluko leka yawe na cha kusinjizila kututowa na kutusukula midogowi ja hetwe na kutudita wapogozi wa heye.” ");
INSERT INTO vid_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Nawamhejelela yula mkola mijito wa kukundigwa wa ng'handa ya Yusufu, walongasa wawele mlwizi lwa ng'handa, ");
INSERT INTO vid_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","nawamlonjela, “Dedede, mkulu. Hetwe natuya hano hamwaluko kugula chilyo. ");
INSERT INTO vid_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","Lotufichile honhu ha kuwasa wajenzi ako kunzila, natudohola migunila jetu, natububuwala kufika migwala ja chila yumwe wa hetwe jali hamlomo mwa igunila lyake ne kudolizwa. Lelo tujihilusa migwala ajo. ");
INSERT INTO vid_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Tigala na migwala jinji kugulila chilyo. Hatuvizelele yalikohi yawichile migwala ja hetwe mmigunila ja hetwe.” ");
INSERT INTO vid_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Yula chitumagwa nakawedichila, “Mikale goya, na mleche kudumba. Nguluwi wa hemwe, Nguluwi wa mhaza wa hemwe, ndo yawahilusile migwala mli migunila ja hemwe. Heni nambochela migwala ja hemwe.” Hamba nakawegalila Simeoni mng'holozawo. ");
INSERT INTO vid_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Ayo chitumagwa nakawabochela mng'handa ya Yusufu, nakamha mazi ga kuhovuga magulu gawo, na midogowi jawo jipegwa chilyo. ");
INSERT INTO vid_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Nawo nawawika goya ndolendole za hewo za kumha Yusufu, kwa vila nawahulika kota wolya hamwe na heye nemisi yila. ");
INSERT INTO vid_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Yusufu loyoyile kaye, nawamigalila zila ndolendole nazowawele nazo, nawamfugamila mbaka hanyi kumwando kwa heye. ");
INSERT INTO vid_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Nakawauza mbuli za hewo, nakalonga, “Namsimila mbuli za mhaza wa hemwe. Ndaze, kalamka? Yang'hali mkomu?” ");
INSERT INTO vid_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Nawamwidichila, “Chitumagwa wa hegwe, mhaza wa hetwe, kagoya yang'hali mkomu.” Nawenamiza na kumfugamila. ");
INSERT INTO vid_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Yusufu naloyenule meho nakumona Benjamini, mng'holoze, mwana wa mayake, nakalonga, “Ayu ndo mng'holozenu mdodo namndonjele mbuli za heye? Nguluwi nayakuditile ganojile mwana wa heni!” ");
INSERT INTO vid_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Baho du Yusufu nakoka honhu aho, kwa vila mihozi najigana kumlawa kwa isungu lya mng'holoze, nakenjila mng'handa na kulila. ");
INSERT INTO vid_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Naloyehovuje kumeho, nakalawa aku yochikangaza, nakalajiza ndiya igaligwe. ");
INSERT INTO vid_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Yusufu nakawichilwa ndiya ya uyeka, na wang'holoze wawichilwa ha uyeka, hihyo na Wamisili wadile hamwe na heye, nawawichilwa kwa uyeka, kwa vila izudizo kwa Wamisili kulya hamwe na Waebulaniya. ");
INSERT INTO vid_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Wang'holoze Yusufu nawekala kumwando kwa heye kota vyoiwele ukulu wa chila yumwe, kwaluchila yapondigwe mwaluko, mbaka wa kuduma, wawa wochilola kwa kububuwala. ");
INSERT INTO vid_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Ndiya nayali iholigwa kulawila mchisaga cha Yusufu na kuhilikwa kwa hewo, ila Benjamini nakapegwa kahano mzidi wa chila chowapegwe wang'holoze. Nawanwa na kusangalala hamwe na heye. ");
INSERT INTO vid_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Hamba Yusufu nakamlajiza chitumagwa wa ng'handa ya heye yolonga, “Uwiche chilyo mli migunila ja wanhu awa kota vyowohega kupika. Hamba, uwiche migwala ja chila yumwe hamlomo mwa igunila lyake. ");
INSERT INTO vid_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Mli igunila lya yula mdodo kusinda weng'ha, uwiche chila chizombe cha heni chauyeng'ha, hamwe na migwala ja heye.” Ayo chitumagwa nakadita kota navyoyalajizwe na Yusufu. ");
INSERT INTO vid_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Lokuchele nawalonjelwa kwaluka majendo hamwe na midogowi jawo. ");
INSERT INTO vid_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Lowalutile honhu hado kulawila kuli muji, Yusufu nakamlajiza chitumagwa wa ng'handa ya heye, “Himahima! Wawinze wala wanhu, na houwafika, uwauze, ‘Lekachoni mhilusa gehile kwa ganojile gomditilwe? ");
INSERT INTO vid_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Lekachoni lomhizile chizombe cha mkulu wa heni, choyanwelaga na kulagulila? Mdita wihe ng'hatu kwa kudita ahyo.’ ” ");
INSERT INTO vid_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Yula chitumagwa naloyawafichile nakawalonjela ulonzi awu. ");
INSERT INTO vid_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Ila hewo nawamuuza, “Mkulu, iwa ndaze kutulonjela ulonzi kota awo? Hetwe vitumagwa wa hegwe, hatujeza kudita mbuli kota ayo! ");
INSERT INTO vid_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Ukumbuchile mkulu, migwala natujifichile mmilomo mwa migunila ja hetwe natujihilusa kuli isi ya Kanaani. Yowa ndaze kahi tuhize sendi ama zahabu mli ng'handa ya mkulu wa hegwe? ");
INSERT INTO vid_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Lelo wone yoneche yumwe wa hetwe kana chizombe acho yakopoligwe, na hetwe tweng'ha towa wapogozi wa hegwe.” ");
INSERT INTO vid_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Ayo mkulu nakalonga, “Goya, iwe kota vyoulonjile. Yoneche yokoneka na chizombe acho, kowa mpogozi wa heni, ila wanji weng'ha hamuwa na nongwa.” ");
INSERT INTO vid_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Chila yumwe nakawika hanyi igunila lyake na kulidohola himahima. ");
INSERT INTO vid_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Yula chitumagwa nakapekulapekula migunila geng'ha yokwaluchila lya mkulu wawo na kumalila kwa mdodo ng'hatu. Chizombe nachoneka mli igunila lya Benjamini. ");
INSERT INTO vid_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Aho nawadadula nguwo za hewo kwa masinzo. Chila munhu nakawika igunila lyake mli idogowi na kuhiluka mujini. ");
INSERT INTO vid_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Yuda na wang'holoze nawafika kuli ng'handa ya Yusufu, nawamfika yang'hali baho haluga. Nawamfugamila chiundewa, ");
INSERT INTO vid_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","na heye Yusufu nakawauza, “Lekachoni namdita ahyo? Ndaze hamvizelele kota heni ndina ludali lwa kulagula?” ");
INSERT INTO vid_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Yuda nakamwidichila, “Tukulonjele choni mkulu? Tulonje choni kulajila kota twahela wihe? Nguluwi nakawika hazelu wihe wa hetwe, hetwe wapogozi wa hegwe, hamwe na yula yoneche na chizombe cha hegwe.” ");
INSERT INTO vid_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Ila Yusufu nakalonga, “Hebu! Heni siweza kudita ahyo! Yula yoneche na chizombe cha heni ndo kowa chitumagwa wa heni. Hemwe wanji mhiluche goya kwa mhaza wa hemwe.” ");
INSERT INTO vid_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Ndo baho Yuda nakamhejelela Yusufu na kumlonjela, “Mkulu, ndangukulanda ung'hundize heni chitumagwa wa hegwe, ndigombele hali hegwe kwa ulonzi udo hela, dedede ndangukulanda uleche kuzudila, kwa vila hegwe ndo kota Falao yuye. ");
INSERT INTO vid_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Mkulu, hegwe nakutuuza kota twanaye mhaza ama mng'holozetu, ");
INSERT INTO vid_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","natwe natukulonjela kota twanaye mhaza, naye kalala, na twanaye mng'holozetu yunji mdodo yapondigwe mhela wa ulalilo wa mhaza wa hetwe. Mkulugwe ayo msongolo mina kabagama, na ayo mwana mdodo ndo yaponile wa mayake na mhaza wa heye kangumgana lukami msongolo ayo. ");
INSERT INTO vid_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Mkulu, nakutulajiza hetwe vitumagwa wa hegwe kumigala mdodo wa hetwe leka umone. ");
INSERT INTO vid_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Natukulonjela kota ayo msongolo hochileka na mhaza wa heye, kwa vila hoyodita ahyo, mhaza wa heye kobagama. ");
INSERT INTO vid_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Ila hegwe mkulu nakutulonjela wone hatuyile na mdodo wa hetwe hutubochela kahi. ");
INSERT INTO vid_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","“Nalotuhiluche kaye kwa chitumagwa wa hegwe, mhaza wa hetwe, natumlonjela vyoutulajize mkulu. ");
INSERT INTO vid_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Na heye naloyatulonjele tuye kahi kuno kugula chilyo, ");
INSERT INTO vid_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","natumlonjela, ‘Hatuluta, hanji wone mdodo wa hetwe koluta hamwe na hetwe, wone holuta hamwe na hetwe hatubocheligwa hebu na yula munhu.’ ");
INSERT INTO vid_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Lelo mhaza wa hetwe chitumagwa wa hegwe, nakatulonjela, ‘Mvizela kota mchewangu Laheli nakamhondela wana weli. ");
INSERT INTO vid_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Yumwe nakaga, nani nandonga, ndangona kota kebatigwa na kudumulangwa viundeunde na igongolo lya kisolo, mina sinamona mbaka sambi. ");
INSERT INTO vid_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Lomumhola ayu kahi kulawa kwa heni, wone yafichigwe na nongwa, monyhilika kuli isi ya wanhu wabagame mbele ng'hongoloka na mbuliza na memile masinzo.’ ");
INSERT INTO vid_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","Lelo mkulu, hondihiluka kwa mhaza wa heni chitumagwa wa hegwe ne msongolo ayu, hanga ukomu wa mhaza wangitumbila ukomu wa msongolo yuno, ");
INSERT INTO vid_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","wone hambe yamone msongolo ayu hamwe na hetwe, kobagama. Lelo hino, hetwe vitumagwa wa hegwe, tomhilika mhaza wa hetwe kuli isi ya wanhu wabagame yawele ng'hongoloka na mbuliza nayamemile masinzo. ");
INSERT INTO vid_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Kwa ago geng'ha, heni baha nandilavya kuwa honhu ha msongolo ayu kwa mhaza wa heni, ndilonga, ‘Wone simhiluse Benjamini kwa hegwe, nongwa yeng'ha na iwe kwa heni mazuwa gose.’ ");
INSERT INTO vid_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Lelo gwaa mkulu, ndangukudedeza, heni chitumagwa wa hegwe ndiwe mkomu, ndiwe chitumagwa wa hegwe honhu ha msongolo ayu. Mlechele heye yahiluche kaye hamwe na wang'holoze. ");
INSERT INTO vid_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Ndoweza ndaze kumhiluchila mhaza ne msongolo ayu? Sikwimilila kulola nongwa yoimfika mhaza wa heni.” ");
INSERT INTO vid_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Aho Yusufu nakalemwela kilemeza hali wanhu weng'ha wowawele hamwe na heye, nakalila. Hamba nakawalonjela walawe kunze. Ahyo Yusufu nayali yaliyeka loyawelengizelesa hali wang'holozake. ");
INSERT INTO vid_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Ila nakalila kwa lizi ng'hulu mbaka Wamisili nawamhulika, na wanhu wa kuli ng'handa ya Falao kahi nawamhulika. ");
INSERT INTO vid_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Yusufu nakawalonjela wang'holozake, “Heni nda Yusufu. Ndaze, mhaza wa heni yang'hali mkomu?” Ila wang'holozake nawabubuwala hali heye, mbaka nawalemwela kumwidichila. ");
INSERT INTO vid_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Yusufu nakawalonjela wang'holozake, “Dedede, mhejele habehi na heni.” Lowamhejelele, nakawalonjela, “Heni nda mng'holozenu Yusufu, mumguzile Misili. ");
INSERT INTO vid_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Ila sambi mleche kona soni ne kilonjeleza kwa kunguza heni. Nguluwi ndo yengalile heni kuno ndiwalongole, leka ndiulohole ukomu wa wanhu. ");
INSERT INTO vid_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Awu ndo mwaka wa keli hela wa nzala muisi, ing'hali miyaka jihano jiyage aho wanhu howeza kulima ne kubeta mbena. ");
INSERT INTO vid_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Nguluwi nakangala kuno ndiwalongoze leka nyamile ukomu wa hemwe mpone muwele wakomu muisi na kuwalohola kwa ulohozi ukulu. ");
INSERT INTO vid_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Ahyo, hemwe hamingale heni kuno, ila ndo Nguluwi. Ndo yanditile kota mhaza kwa Falao, yalingulolela ng'handa ya heye yeng'ha na chilongozi wa isi yeng'ha ya Misili. ");
INSERT INTO vid_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Lelo mdite himahima, mlute kwa mhaza na kumlonjela, ‘Yusufu, mwana wa hegwe, kangulonga, Nguluwi nakandita ndiwe mkulu wa isi yeng'ha ya Misili. Lelo mleche kukawa kuya kwa heni. ");
INSERT INTO vid_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Kochikala habehi na heni honhu ha Gosheni, hegwe na wanago na wazukulu wa hegwe na migongolo ja hegwe na lufufu lwa hegwe lweng'ha. ");
INSERT INTO vid_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Louwa Gosheni, heni ndokulolela hegwe na wang'holozo hamwe na migongolo ja hegwe leka mleche kubagama kwa nzala, kwa vila jing'hali miyaka jihano jinji ja nzala.’ ” ");
INSERT INTO vid_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Hamba Yusufu nakalonga, “Hemwe mwemwe namona kwa meho ga hemwe na mng'holozangu Benjamini kahi nakona kwa meho ga heye kota ndo heni Yusufu ndiwelengulongasa na hemwe. ");
INSERT INTO vid_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Ingana ndimlonjele mhaza wa heni choni chondidayila kuno Misili na geng'ha gomgawene. Lelo mdite himahima mumgale mhaza wa heni kuno.” ");
INSERT INTO vid_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Hamba Yusufu nakamnonela Benjamini mng'holoze, nakalila, na Benjamini na heye nakalila kuno wekumbatize. ");
INSERT INTO vid_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Loyawele yang'hali yolila, Yusufu nakawakumbatiza wang'holozake na kuwanonela. Aho ndo wang'holozake waluka kudawala na heye. ");
INSERT INTO vid_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Mbuli ila loifichile hali ng'handa ya Falao, kota wang'holoze Yusufu nawoya, Falao nakasangalala lukami na vitumagwa wa heye. ");
INSERT INTO vid_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Ahyo, Falao nakamlonjela Yusufu, “Walonjele wang'holozo wajipiche mhomolo midogowi, wahiluche mli isi ya Kanaani, ");
INSERT INTO vid_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","wamgale hano mhaza wa hewo na wang'holozawo weng'ha. Heni ndowagalila honhu hanojile ng'hatu ha isi ya Misili, ako wosangalala kwa chila chinhu cha isi ino namwe molya vihande vya mafuta ga isi. ");
INSERT INTO vid_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Walonjele kahi wahole kulawa hano mimutuka ja kukwejigwa ja kuvigala vyali vya hewo vyeng'ha na wadala wa hewo na wamgale mhazawo. ");
INSERT INTO vid_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Walonjele waleche kujesa lufufu lwa hewo mina honhu hanojile kusinda kweng'ha hali isi ya Misili yowa ya hewo.” ");
INSERT INTO vid_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Lelo wanhu wa Isilaeli nawadita kota vyowalajizwe. Yusufu nakawagalila mimutuka kota vyoyalajize Falao na chilyo cha mnzila. ");
INSERT INTO vid_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Nakawagalila chila yumwe wa hewo nguwo za kugalula, ila nakamgalila Benjamini migwala miya zidatu na mivalo jihano ja kugalula. ");
INSERT INTO vid_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Kahi nakamgalila mhaza wa heye ndolendole zino kwa chiwalo cha majendo ga heye, midogowi kumi jipichile vinhu vinojile, midogowi midala kumi mbena zinojile za Misili na mibumunda na vilyo vinji. ");
INSERT INTO vid_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Lelo Yusufu nawelagana na wang'holoze. Lowawele wokuka, nakawakanya yolonga, “Mleche kitwanza mzila.” ");
INSERT INTO vid_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Lelo nawalawa Misili na kuhiluka hakaye kwa mhaza wa hewo Yakobo, kuli isi ya Kanaani. ");
INSERT INTO vid_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Nawamlonjela mhaza wa hewo, “Yusufu ka mkomu. Heye ndo chilongozi wa isi yeng'ha ya Misili.” Aho mhaza wa hewo nakabubuwala, nahakundile ulonzi wa hewo. ");
INSERT INTO vid_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Ila, lowamsimile geng'ha gowalajizwe na Yusufu na loyajiwene mimutuka jila joyagalilwe na Yusufu leka jimhole, nhumbula ya heye naimema kusangalala lukami. ");
INSERT INTO vid_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Isilaeli nakalonga, “Lelo nang'hunda, mwana wa heni Yusufu kamkomu. Ndoluta ndikamone londiwele nding'hali kubagama.” ");
INSERT INTO vid_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Lelo Isilaeli nakaluka majendo ga heye hamwe na lufufu lwa heye lweng'ha. Loyafichile Beeli-sheba, nakamlavila nhambiko Nguluwi wa Isaka, mhaza wa heye. ");
INSERT INTO vid_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Nguluwi nakalonga na Isilaeli kuli ulotezi nechilo, nakamchema, “Yakobo! Yakobo!” Yakobo nakedichila, “Ena ndanguhulichiza.” ");
INSERT INTO vid_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Nguluwi nakamlonjela, “Heni ndo Nguluwi, Nguluwi wa mhaza wa hegwe. Uleche kudumba kuka Misili, louwa kuko, ndokudita uwe nhanzi ng'hulu. ");
INSERT INTO vid_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Na heni ndokuka hamwe na hegwe kuko Misili na kukuhilula kuno. Loubagama, moko wa Yusufu ndo wokugosa.” ");
INSERT INTO vid_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Lelo Yakobo nakoka Beeli-sheba. Wana wa heye nawamhola heye na vyali vya hewo hamwe na wadala wa hewo hali mimutuka jiwele Falao yajigale kumhola. ");
INSERT INTO vid_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Nawahola kahi migongolo ja hewo na lufufu lwa hewo lweng'ha lowapatile kuli isi ya Kanaani, nawaluta Misili. Yakobo nakahola lukolo lwa heye lweng'ha. ");
INSERT INTO vid_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","Wana wa heye na wazukulu wa heye walume na wadala, weng'ha nakawagala Misili. ");
INSERT INTO vid_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Walelwa wa Isilaeli nawalutile Misili hamwe na heye nawali Lubeni, mlelwa wa heye wa mwaluko ");
INSERT INTO vid_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","hamwe na wana wa Lubeni, Enoki na Palu na Hesiloni na Kalimi. ");
INSERT INTO vid_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Simeoni na wanage, Yemueli na Yamini na Ohadi na Yakini na Sohali na Shauli nayapondigwe na mdala nayawele Mkanaani. ");
INSERT INTO vid_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Lawi na wanage, Gelishoni na Kohati na Melali. ");
INSERT INTO vid_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Yuda na wanage, Eli na Onani na Shela na Pelesi na Sela, ila Eli na Onani nawabagama kuli isi ya Kanaani. Wana wa Pelesi nawali Hesiloni na Hamuli. ");
INSERT INTO vid_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Isakali na wanage, Tola na Puva na Yashubu na Shimuloni. ");
INSERT INTO vid_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Sebuluni na wanage, Seledi na Eloni na Yaleeli. ");
INSERT INTO vid_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Awo ndo wana Lea nayampondele Yakobo kula Padani-alamu, hamwe na Dina mhinza wa heye. Weng'ha wasongolo na wahinza wa heye nawali wanhu makumi gadatu na zidatu. ");
INSERT INTO vid_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Gadi na wanage, Sifioni na Hagi na Shuni na Esiboni na Eli na Alodi na Aleli. ");
INSERT INTO vid_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Asheli na wanage, Imuna na Ishiva na Ishivi na Belia na Sela na lumbuli yao. Belia na wanage, Hebeli na Malikieli. ");
INSERT INTO vid_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Awa kumi na sita ndo wana wa Yakobo na Silipa, mpogozi yawele Labani nayampele Lea mhinza wa heye. ");
INSERT INTO vid_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Laheli nakampondela Yakobo wana weli, Yusufu na Benjamini. ");
INSERT INTO vid_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Ako Misili, Asenati mhinza wa Potifela, nayawele mtambika wa muji wa Oni, nakampondela Yusufu wana weli, Manase na Efulaimu. ");
INSERT INTO vid_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Wana wa Benjamini nawali, Bela na Bekeli na Ashibeli na Gela na Naamani na Ehi na Loshi na Mupimu na Hupimu na Alidi. ");
INSERT INTO vid_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Wanhu awo kumi na wane ndo wana na wazukulu wa Yakobo na Laheli mchewake. ");
INSERT INTO vid_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Dani na Hushimu mwanage. ");
INSERT INTO vid_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Nafutali na wanage, Yaseeli na Guni na Yeseli na Shilemu. ");
INSERT INTO vid_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Awo saba ndo wana wa Yakobo na Biliha, mpogozi wa chidala yawele Labani nayampele mhinza wa heye Laheli. ");
INSERT INTO vid_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Weng'ha walelwa wa Yakobo nayalutile nawo Misili, ne kuwaza wadala wa wana wa heye, nawali makumi sita na sita. ");
INSERT INTO vid_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Ako kuli isi ya Misili Yusufu nayali yapatile wana weli. Ahyo, wanhu weng'ha wa lukolo lwa Yakobo nawali makumi saba. ");
INSERT INTO vid_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Yakobo nakamlongola mwanage Yuda kwa Yusufu yomlanda wewone ako Gosheni, na hewo nawafika ako Gosheni. ");
INSERT INTO vid_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Yusufu nakakwina mutuka wa heye wa falasi, nakaluta kumbochela Isilaeli, mhaza wa heye ako Gosheni. Loyamfichile mhaza wa heye, nakamkumbatila na kulila hado hela. ");
INSERT INTO vid_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Isilaeli nakamlonjela Yusufu, “Wone mbagame sambi, haiwele chinhu, kwa vila ndikona na ndivizela kota kwa mkomu.” ");
INSERT INTO vid_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Yusufu nakawalonjela wang'holoze na ivyazi lyeng'ha lya mhaza wa heye, “Ndanguluta kumlonjela Falao kota wang'holozangu na ivyazi lyeng'ha lya mhaza wa heni nawawele ako Kanaani, woya kwa heni. ");
INSERT INTO vid_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Ndomlonjela kota hemwe mwa wadimi kwa vila namwali mdima migongolo, muya hamwe na mhene na ming'holo na misenga na lufufu lwenu lweng'ha. ");
INSERT INTO vid_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Lelo wone Falao yowachema na kuwauza, ‘Mwangukola mijito yachi?’ ");
INSERT INTO vid_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","Mlonje, ‘Mkulu, hetwe vitumagwa wa hegwe, hetwe twa wadimi kulawila lotuwele wana mbaka sambi, kwa vila ndo lowali wasekulu wa hetwe,’ mlonje ahyo leka mkundigwe kikala kuli honhu ha Gosheni, kwa vila kwa wanhu wa Misili, wadimi weng'ha wa ming'holo ndo izudizo.” ");
INSERT INTO vid_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Lelo Yusufu nakaluta kwa Falao, nakamlonjela, “Mhaza wa heni na wang'holozangu hamwe na ming'holo na misenga na lufufu lwao lweng'ha woya kuli isi ya Kanaani. Lelo wafichila ako Gosheni.” ");
INSERT INTO vid_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Yusufu nayali yawaholile wang'holoze wahano yakamlajile Falao. ");
INSERT INTO vid_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Falao nakawauza, “Mwangukola choni?” Nawamwidichila, “Mkulu hetwe vitumagwa wa hegwe twa wadimi, kota navyowawele wasekulu wa hetwe.” ");
INSERT INTO vid_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Hamba nawamlonjela Falao, “Hetwe vitumagwa wa hegwe tuya kikala kota wajenzi kuli isi ayi, kwa vila hana nzala lukami ako Kanaani na kuduhuli honhu ha kudimila migongolo. Ahyo mkulu, hetwe twangulanda utukundize kikala ako Gosheni.” ");
INSERT INTO vid_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Falao nakamlonjela Yusufu, “Mhaza wa hegwe na wang'holozo wakuyila hegwe. ");
INSERT INTO vid_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Isi yeng'ha ya Misili ya hali ulongozi wa hegwe, wamhe mhaza na wang'holozo honhu hanojile kuli isi ayi. Wekale ako Gosheni. Na wone wamumo wanhu wawanzi wahagule wawe wololela migongolo ja heni.” ");
INSERT INTO vid_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Hamba Yusufu nakamigala mhaza wa heye Yakobo yamlamse Falao, na heye Yakobo nakamtambichiza Falao. ");
INSERT INTO vid_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Falao nakamuuza Yakobo, “Kuna miyaka jilinga?” ");
INSERT INTO vid_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Yakobo nakamwidichila Falao, “Miyaka joyamhele Nguluwi kota mwinula majendo ndo miyaka miya imwe na makumi gadatu. Miyaka ajo ndo mido na imemile magazo, kahi haifichile kota miyaka najowekale wasekulu wa hetwe kota wanhu wawele kwinula majendo.” ");
INSERT INTO vid_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Hamba Yakobo nakamtambichiza Falao na kuka. ");
INSERT INTO vid_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Lelo Yusufu nakawapa mhaza wa heye na wang'holoze honhu ha Lamesesi liwele na mboto ng'hatu kuli isi ya Misili hawe honhu ha kikala hewo, na hewo nawahalila kota vyoyalajize Falao. ");
INSERT INTO vid_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Yusufu nayali yowapa chilyo mhaza wa heye na wang'holoze na ivyazi lyeng'ha lya mhaza wa heye kota winji wa hewo vyouwele. ");
INSERT INTO vid_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Hamba chilyo nachajilila ng'hatu kuli isi yeng'ha. Nzala naing'ang'ala ng'hatu mbaka iwadita wanhu weng'ha kuli isi ya Misili na Kanaani kuganda. ");
INSERT INTO vid_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Yusufu nakakungajiza migwala jeng'ha ja isi ya Misili na Kanaani kwa chilyo choyaguzile na kuhilika migwala ajo kwa mndewa Falao. ");
INSERT INTO vid_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Wanhu weng'ha wa isi ya Misili na Kanaani lowesilwe migwala jeng'ha, Wamisili weng'ha nawamuyila Yusufu na kumlonjela, “Tugalile hetwe chilyo. Lekachoni tubagame aku ulola? Ulole migwala jeng'ha jimala.” ");
INSERT INTO vid_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Yusufu nakamlonjela, “Wone migwala jeng'ha jimalile, lelo mungalile migongolo jenu nani ndowapa chilyo.” ");
INSERT INTO vid_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Ndo baho wamigalila Yusufu migongolo jawo, falasi na misenga na ming'holo na mhene na midogowi kwa kugula chilyo. Mhela awo Yusufu nayali yowapa chilyo kwa kulavya migongolo. ");
INSERT INTO vid_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Mhela uyage nawamuyila kahi na kumlonjela, “Mkulu, twangukomya kuta migwala ja hetwe jeng'ha jimala, na migongolo jeng'ha jiwa ja hegwe. Lelo mkulu, hetwe vitumagwa wa hegwe twahela chinhu chotuweza kukugalila, ila ng'huli za hetwe na migunda ja hetwe. ");
INSERT INTO vid_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Ya choni hetwe kubagama aku hali hegwe na migunda ja hetwe jiwe vibi? Utugule hetwe hamwe na migunda ja hetwe tuwe wapogozi wa Falao, leka tulye chilyo. Tugalile chilyo tuleche kubagama, tugalile na nyhadikwa kwa chiwalo cha kunyala kuli migunda ja hetwe.” ");
INSERT INTO vid_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Ahyo, Yusufu nakaigula isi yeng'ha ya Misili iwe ya Falao. Chila munhu yalingikala Misili, nakaganigwa kuguza mgunda wa heye kwa vila nzala navyoiwele ing'ang'ale. Ahyo, isi yeng'ha nayali ya Falao. ");
INSERT INTO vid_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Yusufu nakawadita wanhu wawe wapogozi, kulawila nzingo imwe mbaka nzingo iyage ya isi ya Misili. ");
INSERT INTO vid_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Migunda jiwele Yusufu hambe hagulile ndo jila najiwele ja watambika. Awo nawalajizwa waleche kuguza migunda jawo kwa vila hewo nawali wochikala kwa kupegwa chilyo na Falao. ");
INSERT INTO vid_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Hamba Yusufu nakawalonjela wanhu, “Lole, mina ndiwagula hemwe mweng'ha na migunda ja hemwe kuwa lufufu lwa Falao. Mopegwa nyhadikwa namwe monyala kuli migunda ja hemwe. ");
INSERT INTO vid_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Mhela wa mbena, imwe ya zihano za nyhadikwa momha Falao. Honhu hane hasigale, howa nyhadikwa na chilyo kwa ivyazi lya hemwe na wana wa hemwe.” ");
INSERT INTO vid_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Nawamwidichila wata, “Mkulu, kulohola ukomu wa hetwe. Kwa vila kutulajila uganililo, hetwe towa wapogozi wa Falao.” ");
INSERT INTO vid_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Ndo Yusufu nayawichile ilajizo limwe liwele lyabahala mbaka lehano kuli isi ya Misili kota chila munhu yalavye honhu hamwe ha kahano ya mbena ya heye kwa Falao. Migunda ja watambika jiliyeka ndo hajiguligwe na kuditikwa jiwe ja Falao. ");
INSERT INTO vid_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Lelo wanhu wa Isilaeli nawekala ako Gosheni kuli isi ya Misili. Lowawele ako, nawawa na lufufu lwinji, kiponda na konjezeka lukami. ");
INSERT INTO vid_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Yakobo nakekala kuli isi ya Misili kwa miyaka kumi na saba mbaka naloyawele na miyaka miya imwe na makumi gane na saba. ");
INSERT INTO vid_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Mhela wa kubagama kwa heye louwele habehi, Yakobo nakamchema mwanage Yusufu nakamlonjela, “Lelo wone ukomya kuna igano lya kwimilila, uwiche moko wa hegwe mihaza jangu, na kilaha kota konditila goya na kondajila makundo, uleche kutila lukuli lwangu akuno Misili, ");
INSERT INTO vid_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","ila ukatile lukuli lwangu kota vyoiwele kwa wasekulu wa heni. Uhole lukuli lwangu kulawa Misili na kuza kutila kuli vilaga vya hewo.” Yusufu nakamwidichila, “Ndodita kota vyoulonjile.” ");
INSERT INTO vid_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Yakobo nakamlonjela, “Wilahe.” Yusufu nakelaha. Hamba Isilaeli nakafugama banzi ya kumitwi mwa chinanda cha heye na kuta malumbo Nguluwi. ");
INSERT INTO vid_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Logapulute ago, Yusufu nakalonjelwa kota mhaza wa heye kangutamika. Ahyo, nakawahola wanage weli, Manase na Efulaimu, nakaluta nawo kwa mhaza wa heye. ");
INSERT INTO vid_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Yakobo vyoyalonjelwe kota mwanage Yusufu koya kumlola, naketatamula kwinuka na kikalisa mchinanda. ");
INSERT INTO vid_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Yakobo nakamlonjela Yusufu, “Nguluwi yawele na mong'ho nakandawila nalondali kula Lusu kuli isi ya Kanaani, nakanhambichiza. ");
INSERT INTO vid_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","Nakandonjela, ‘Ulole, ndokudita hegwe uwe na lulelo na lonjezeche, ndokudita uwe sekulu wa nhanzi nyinji ng'hulu. Isi ayi ndowapa lulelo lwa Waisilaeli weng'ha, waihalile mazuwa gose.’ ” ");
INSERT INTO vid_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Yakobo nakalutilila kulonga, “Wanago weli uwapondile aha Misili mhela londing'hali kuya, wowa wana wa heni. Manase na Efulaimu wowa wana wa heni kota vyowawele Lubeni na Simeoni. ");
INSERT INTO vid_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Ila wana wouwaponda hamba wowa wa hegwe, kwa itagwa lya ivyazi lya hewo, wowa kuli uhalizi wa wang'holozawo. ");
INSERT INTO vid_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Ndangwamula ahyo kwa chiwalo cha mayako, Laheli. Lombele ndihiluka, kulawila Padani heye nakabagama kuli isi ya Kanaani, lotuwele behi kufika Efulata, nakandechela masinzo. Lelo nandimtila baho du, hafungo mwa nzila ilinguluta Efulata, mina ndo Betelehemu.” ");
INSERT INTO vid_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Isilaeli loyawawene wana wa Yusufu, nakawauza, “Awa wanhu wachi?” ");
INSERT INTO vid_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Yusufu nakamwidichila mhaza wa heye, “Awa ndo wana wa heni woyamhele Nguluwi lombele aku.” Isilaeli nakalonga, “Dedede, uwegale behi ndiwatambichize.” ");
INSERT INTO vid_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Meho ga Isilaeli nagali hambe galole goya kwa chiwalo cha ulalilo. Lelo Yusufu nakawahejeza wanage behi nayekale mhaza wa heye, na heye nakawanonela na kuwakumbatila. ");
INSERT INTO vid_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Hamba Isilaeli nakamlonjela Yusufu, “Nasijesile kota ndokona kumeho kwa hegwe kahi, ila Nguluwi kamha utambichizo mbaka kuwona wana wa hegwe.” ");
INSERT INTO vid_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Aho Yusufu nakawosa wanage kuli mafugamilo ga mhaza wa heye, hamba nakenamiza kwa kuhulichiza. ");
INSERT INTO vid_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Yusufu nakawenula wanage weli, Efulaimu kuli moko wa heye wa kudilo yomhinduchiza kuli moko wa kumoso wa mhaza wa heye na Manase kuli moko wa heye wa kumoso yomhinduliza kuli moko wa kudilo kwa mhaza wa heye Isilaeli, nakawahejeza kwa mhaza wa heye. ");
INSERT INTO vid_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Ila Isilaeli nakaipinjiza moko kwa kuwika wa kudilo kawika kuli mutwi wa Efulaimu hanga nayali mdodo na moko wa kumoso nakawika kuli mutwi wa Manase nayawele mlelwa wa mwaluko. ");
INSERT INTO vid_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Hamba Isilaeli nakamtambichiza Yusufu yolonga, “Nguluwi yawele wasekulu wa heni, Abulahamu na Isaka nawali womhulichiza kuli ukomu wa hewo, Nguluwi ndo mdimi wa heni mbaka lehano, ");
INSERT INTO vid_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","na mhilisi nayawele yandohole kuli wihe weng'ha, na yawatambichize wasongolo awa! Wochemigwa wana wa heni kwa lulelo lwa wasekulu wa heni Abulahamu na Isaka, na hewo wonjezeche kwa winji muisi.” ");
INSERT INTO vid_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Yusufu loyawene kota mhaza wa heye kawika moko wa heye wa kudilo kuli mutwi wa Efulaimu nahanojezwe hebu. Lelo nakebata moko wa mhaza wa heye yogana kusa kuli mutwi wa Efulaimu yauwiche kuli mutwi wa Manase. ");
INSERT INTO vid_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Yusufu nakamlonjela mhaza wa heye, “Haiwele ahyo mhaza. Ayu ahano ndo mlelwa wa mwaluko. Dedede, uwiche moko wa hegwe wa kudilo kuli mutwi wa heye.” ");
INSERT INTO vid_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Ila mhaza wa heye nakalema yolonga, “Ndivizela mwanangu, ndivizela. Wana wa Manase kahi wowa nhanzi ng'hulu. Ila mng'holoze mdodo kowa mkulu kusinda heye na walelwa wa heye wowa nhanzi nyinji.” ");
INSERT INTO vid_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Lelo Isilaeli nakawatambichiza zuwa ahyo yolonga, “Waisilaeli wowa wotambichiza kwa matagwa ga hemwe, wolonga, ‘Nguluwi yakuditile ganojile kota Efulaimu na Manase.’ ” Ndo Isilaeli navyoyamuwichile Efulaimu kumwando kwa Manase. ");
INSERT INTO vid_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Hamba Isilaeli nakamlonjela Yusufu, “Kota vyoulingumbona heni, ndahabehi kubagama. Ahyo, Nguluwi kowa hamwe na hemwe na kuwahiluseni kuli isi ya wasekulu wa hemwe. ");
INSERT INTO vid_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Mzidi wa ago, ndikupa hegwe uwele mkulu kusinda wang'holozo, honhu hakulu hachemigwe Shekemu. Hondiwasukule Waamoli kwa ipanga na upinde wa heni wa msale.” ");
INSERT INTO vid_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Yakobo nakawachema wanage, nakalonga, “Mikungajize hamwe ndiwalonjele mbuli ziwafika hamba. ");
INSERT INTO vid_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","“Mikungajize mhulichize hemwe wana wa Yakobo, mnyhulichize heni Isilaeli mhaza wa hemwe. ");
INSERT INTO vid_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","“Hegwe Lubeni ndo mlelwa wa heni wa mwaluko, ludali lwangu na ifuza lya usongolo wa heni. Hegwe kuna ukulu na mong'ho ng'hatu. ");
INSERT INTO vid_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Hegwe kwanguwifya kota mazi gamemile tendema. Ila huwa wa mwaluko kahi, kwa vila nakukwina mchinhanda cha heni mhaza wa hegwe, hegwe nakuchidita chikokomoche kwa kuwasa na mchewangu, ena, hegwe nakuchikwina! ");
INSERT INTO vid_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","“Simeoni na Lawi mwa lukolo, wangukopola kwa migoha jawo, ");
INSERT INTO vid_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","ila heni sikunda kihanza na nongwa za hewo, hegwe nhumbula ya heni, uleche kihanza mli nhing'hano za hewo, mina mli kuzudila kwa hewo, nawawakopola wanhu, kwa ujuvi wa hewo nawakanha idanha lya isenga. ");
INSERT INTO vid_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","“Ndangupanjila kuzudila kwa Simeoni na Lawi, mina ndo kung'ang'ala lukami, na ng'alazi ya hewo yahela isungu. Ndowasambalula kuli isi ya Yakobo, ndoweneza kuli isi ya Isilaeli. ");
INSERT INTO vid_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","“Hegwe Yuda, wang'holozo wokutogola. Wang'honyo wa hegwe kowadinga singo, na wang'holozo wofugama kumwando kwa hegwe. ");
INSERT INTO vid_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Hegwe Yuda mwanangu ndo kota isimba, yebatile igongolo na kukwina kuchanya. Kota vila isimba lilingigolola na kuwasa hasi, isimba liwele na mong'ho, yalikohi yojeza kulililimla? ");
INSERT INTO vid_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Idela lya undewa halikuka kwa Yuda, ne ng'hweku ya ulongozi hali heye, mbaka hoyofika yula yawichilwe, yawele kohulichizwa na nhanzi zeng'ha. ");
INSERT INTO vid_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Kowa na zabibu nyinji, kolikoweleza idogowi lya heye hali mzabibu, na idogowi lyana kuli mzabibu unojile, leka jilye. Kwa vila mzabibu naulela lukami, kohovuga nguwo za heye mli divai, na mivalo ja heye mli divai ndung'hu kota danda. ");
INSERT INTO vid_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Meho ga heye nagoneka ganoga kota divai inojile, mizino ja heye mizelu kota itombo. ");
INSERT INTO vid_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","“Sebuluni kochikala honhu hawele mwhani, kumwhani kwa heye kowa honhu hakwimizila meli. Isi ya heye yobakana na Sidoni. ");
INSERT INTO vid_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","“Isakali ndo kota idogowi liwele na mong'ho, lilinguwasa hagati ha mitunyo ja heye. ");
INSERT INTO vid_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","“Nakona kota kambi inoga, na kota isi ndo yakunojeza, nakenamiza mhungo ya heye kupapa itunyo, nakawa mpogozi kukola mijito kwa lupichi. ");
INSERT INTO vid_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","“Dani kowa mhanyisi wa wanhu wa heye, kota yumwe wa lukolo lwa Isilaeli. ");
INSERT INTO vid_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","“Dani kowa kota izoka mnzila, izoka liwele na dunga hafungo mwa nzila, lilinguluma chisigino cha falasi, na heye yakwinile falasi kangugwa lung'ata. ");
INSERT INTO vid_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","Hegwe Mkulu Nguluwi, ndangukubeteza undohole. ");
INSERT INTO vid_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","“Gadi, kovadigwa na wabokaji, ila heye kowawinza kumbele na kuwadumya. ");
INSERT INTO vid_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Isi ya Asheli yolavya mbena kwa winji, na heye kolavya chilyo chinonile kwa mndewa. ");
INSERT INTO vid_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","“Nafutali ndo kota ibala lilejehe, lilingulela wana wanojile. ");
INSERT INTO vid_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","“Yusufu ndo kota igodi lilingulela, igodi lilingulela hafungo mwa nzasa, nhagala za igodi zitanda mlukanzi. ");
INSERT INTO vid_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Walasa misale nawamvada vibi ng'hatu, wamtozela msale wogana kumgaza lukami. ");
INSERT INTO vid_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Ila upinde wa heye ung'hali ukakamale, na moko ga heye nagapegwa uwanzi, kwa ludali lwa Nayawele na Mong'ho wa Yakobo, kwa chiwalo cha Mdimi, Italawe lya Isilaeli, ");
INSERT INTO vid_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","kwa Nguluwi wa mhaza wa hegwe yokutanza, kwa Nguluwi yawele na mong'ho yokutambichiza, uwe na utambichizo wa nhonya kulawa kuchanya kilanga, utambichizo wa kuli mazi menji gawele hasi, utambichizo wa lulelo lwa wachimai na migongolo. ");
INSERT INTO vid_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Utambichizo wa mhaza wa hegwe usumye utambichizo wa vidunda vya mazuwa gose, uwe unojile kusinda vidunda vya katali. Utambichizo awo uwe mchanya mwa mutwi wa Yusufu, mli chihanga cha heye nayabaguligwe kota chilongozi kwa wang'holoze. ");
INSERT INTO vid_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","“Benjamini ndo libwa lya kisolo ling'ang'ale, lufuku lyangulya lyolibate, na matinazo kangugawa upelembi.” ");
INSERT INTO vid_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Azo ndo nhanzi kumi na mbili za Isilaeli na awo ndo ulonzi woyawalonjele mhaza wa hewo loyawatambichize, chila yumwe wa hewo kota vyoyaganigwe. ");
INSERT INTO vid_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Hamba Isilaeli nakawalajiza wana wa heye ahi, “Heni ndahabehi kubagama na kilumba na wasekulu wa heni. Mkatile lukuli lwangu hamwe na wasekulu wa heni kuli chilaga chiwele kuli mgunda wa Efuloni Mhiti, ");
INSERT INTO vid_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","kula Makipela, kolilawilaga isanya kwa Mamle kuli isi ya Kanaani. Abulahamu nakagula ipalika na mgunda awo kwa Efuloni Mhiti liwe lya heye kutilila wanhu wabagame. ");
INSERT INTO vid_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Ako ndo kowatiligwe Abulahamu na mchewake Sala, ako ndo kowatiligwe Isaka na mchewake Lebeka na ako ndo kondimtilile Lea. ");
INSERT INTO vid_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Ipalika alyo na mgunda wake naliguligwa kwa Wahiti.” ");
INSERT INTO vid_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Yakobo loyasindile kuwalajiza wanage, nakahilusa magulu ga heye mchinhanda, muhe nauleka lukuli nakelumba na wasekulu wa heye. ");
INSERT INTO vid_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Aho Yusufu nakamkumbatila mhaza wa heye yolila na kumnonela. ");
INSERT INTO vid_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Hamba Yusufu nakawalajiza wateleka mikwandi wambakalize Isilaeli, mhaza wa heye mikwandi leka yaleche kola, na hewo nawadita hihyo. ");
INSERT INTO vid_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Kota navyoiwele, mazuwa makumi gane nagaganigwa kwa kubakaliza mikwandi. Na hewo Wamisili nawalombocheza kubagama kwa Yakobo kwa mazuwa makumi saba. ");
INSERT INTO vid_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Kulombocheza lokumalile, Yusufu nakawalonjela wakulu wa ng'handa ya Falao, “Wone ndiwe ng'undigwe hali hemwe, dedede, mlonje na Falao kwa chiwalo cha igano lya heni, ");
INSERT INTO vid_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","kota mhaza wa heni navyoyanganile heni ndilahe, yolonga, ‘Heni ndahabehi kubagama. Yokugana kuza kutila lukuli lwa heni kuli chilaga nachonyongole kuli isi ya Kanaani.’ Lelo ndangumlanda yamhe mhumhu ndute ndikatile lukuli lwa mhaza wa heni, hamba ndohiluka.” ");
INSERT INTO vid_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Falao nakedichila, “Ulute ukatile lukuli lwa mhaza wa hegwe kota navyoyakulahile.” ");
INSERT INTO vid_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Lelo Yusufu nakoka kuza kumtila mhaza wa heye yelongoze na wakulu weng'ha wa Falao na wasekulu wa ng'handa ya Falao, hamwe na wasekulu wa isi yeng'ha ya Misili. ");
INSERT INTO vid_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Hihyo du, Yusufu yelongoze na ivyazi lya heye lyeng'ha na wang'holoze na ivyazi lyeng'ha lya mhaza wa heye Yakobo. Kula Gosheni nawapona wana wa hewo yeng'ha hamwe na ming'holo na mhene na misenga ja hewo. ");
INSERT INTO vid_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Kahi nawali hamwe na wakwina falasi na mutuka, nachali chilundo chikulu ng'hatu. ");
INSERT INTO vid_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Lowafichile kuli luga lwa kupembulila nyhule lwa Atadi, kumwambu mwa lwanda lwa Yolodani, weng'ha nawalila kwa lizi na usungu ng'hatu. Yusufu nakamditila mhaza wa heye nhanga lukolo kwa mazuwa saba. ");
INSERT INTO vid_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Wakanaani wenyeng'haye wa isi ayo, lowawene kulombocheza kuditilwe kuli luga lwa kupembulila nyhule lwa Atadi, nawalonga, “Kulombocheza aku ndo kwa Wamisili, kukulu ng'hatu.” Ahyo, honhu hala nahachemigwa Abeli-misili, naho ha hamwambu mwa lwanda lwa Yolodani. ");
INSERT INTO vid_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Wana wa Yakobo nawamditila mhaza wa hewo kota navyoyawalajize. ");
INSERT INTO vid_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Nawamhola mbaka isi ya Kanaani, nawamtila kuli ipalika naliwele kuli mgunda kula Makipela, nzingo ya kolilawilaga isanya ya Mamle. Ipalika hamwe na mgunda awo Abulahamu nayali yagulile kwa Efuloni Mhiti, leka hawe honhu ha kutilila wanhu wa ivyazi lya heye. ");
INSERT INTO vid_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Loyasindile kumtila mhaza wa heye, Yusufu nakahiluka Misili hamwe na wang'holoze na wanhu weng'ha nawelongoze na heye kuza kumtila mhaza wa heye. ");
INSERT INTO vid_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Loyabagame mhaza wa hewo, wang'holoze Yusufu nawadogola, “Hanji Yusufu kotuzudila na kilipizila gehile geng'ha gotumditile.” ");
INSERT INTO vid_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Ahyo, nawamuhilichila Yusufu usenga, wolonga, “Mhaza wa hegwe naloyang'hali kubagama, nakalajiza ahi, ");
INSERT INTO vid_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","‘Umlonjele Yusufu kwa chiwalo cha heni, dedede, uwalechele wang'holozo gala gehile geng'ha gowakuditile.’ Lelo dedede utulechele wihe wotukuditile hetwe vitumagwa wa Nguluwi wa mhaza wa hegwe.” Yusufu loyahuliche usenga awu, nakalila. ");
INSERT INTO vid_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Hamba wang'holoze nawamuyila, wenamiza hasi hali heye, nawalonga, “Ulole, hetwe twa vitumagwa wa hegwe.” ");
INSERT INTO vid_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Ila Yusufu nakawalonjela, “Mleche kudumba, ndaze, heni nda honhu ha Nguluwi? ");
INSERT INTO vid_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Hemwe namgana kunditila vibi, ila Nguluwi nakagana ganojile, leka wanhu wenji wawe wakomu kota vyomlingona. ");
INSERT INTO vid_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Lelo mleche kudumba. Heni ndowapani chilyo hamwe na wana wa hemwe.” Lelo nakawahembuliza na kulongasa na hewo goya. ");
INSERT INTO vid_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Yusufu nakalutilila kikala kuli isi ya Misili hamwe na ivyazi lyeng'ha lya mhaza wa heye. Nakekala kwa miyaka miya imwe na kumi. ");
INSERT INTO vid_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Yusufu nakawona wana na wazukulu wa mwanage Efulaimu na kahi nakawabochela kota wanage wana wa Makili mwana wa Manase. ");
INSERT INTO vid_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Hamba Yusufu nakawalonjela wang'holoze, “Heni lelo ndahabehi kubagama. Ila Nguluwi kowajendela na kuwatanza. Kowalavya kuli isi ayi na kuwahilika kuli isi yawelahile Abulahamu na Isaka na Yakobo.” ");
INSERT INTO vid_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Hamba Yusufu nakawalajiza wana wa Isilaeli yochilaha na kulonga, “Nguluwi hoyokuya kuwatanza, mhole na mizeje ja lukuli lwangu kulawila aku.” ");
INSERT INTO vid_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Lelo Yusufu nakabagama kula Misili, yawele na miyaka miya imwe na kumi. Na hewo nawaubakaliza lukuli lwake mikwandi luleche kola, nawauwika mitusi kula Misili.");
INSERT INTO vid_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Ayi ndo mbuli ya matagwa ga wana wa Yakobo nayachemigwe Isilaeli nawalutile na heye, Misili chila yumwe na ivyazi lyake, ");
INSERT INTO vid_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","nawali Lubeni na Simeoni na Lawi na Yuda ");
INSERT INTO vid_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","na Isakali na Sebuluni na Benjamini ");
INSERT INTO vid_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","na Dani na Nafutali na Gadi na Asheli. ");
INSERT INTO vid_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Lulelo lweng'ha lwa Yakobo lwali na wanhu makumi saba. Mhela awo Yusufu nayali mina yalongole kikala ako Misili. ");
INSERT INTO vid_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Hamba Yusufu nakabagama, hihyo du na wang'holoze na lulelo lula lweng'ha. ");
INSERT INTO vid_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","Ila lulelo lwa Yakobo na lwonjezeka lukami, Waisilaeli nawawa wenji wawele na mong'ho heko, nawenela chila honhu muisi ya Misili. ");
INSERT INTO vid_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Lelo nakalawila mndewa yunji ako Misili nahamzelele Yusufu. ");
INSERT INTO vid_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","Na heye nakawalonjela wanhu wa heye, “Mlole Waisilaeli vyowawele wenji na vyowawele na mong'ho kusinda hetwe. ");
INSERT INTO vid_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Lelo twangulapigwa kupala nzila ya kuwadita waleche konjezeka, wone haiwele ahyo, wone ilawile ngondo wochilumba na wang'honyo wa hetwe na kuka muisi ino ne kuhiluka kahi.” ");
INSERT INTO vid_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Wamisili nawawahagula walolezi wawemilile Waisilaeli na kuwadita vibi kwa kuwakoleza mijito kwa lupichi ne kwesela. Waisilaeli nawakola mijito ja kumzenjela Mndewa Falao miji ja kuwichila ng'hano, Pisomu na Lamesesi. ");
INSERT INTO vid_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Ila navyowalutilile kuwatunya, ndo vyowalutilile konjezeka na kwenela muisi. Ahyo Wamisili nawawadumba ng'hatu wanhu wa Isilaeli. ");
INSERT INTO vid_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","Lelo Wamisili nawawatumajiza Waisilaeli kwa lupichi aku wang'ang'ale. ");
INSERT INTO vid_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","Wawadita wekale kwa kugaya na mijito jing'ang'ale kwa kugongomanya chokaa na mitufali, na mbuli zeng'ha za kumgunda. Mli mijito jeng'ha, Wamisili nawawatumajiza Waisilaeli kwa lupichi aku wang'ang'ale. ");
INSERT INTO vid_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Hamba mndewa wa Misili nakawalonjela wahunga, Shifula na Pua, nawawele wowakolela mijito wadala Waebulaniya, ");
INSERT INTO vid_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","“Homuwakolela mijito wadala wa Chiebulaniya mhela wa kuponda, wone mwana hoyopondigwa yawe mlume, mumkopole. Ila wone yawe mdala, mlecheni yekale.” ");
INSERT INTO vid_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Ila kwa vila wahunga awo nawali womdumba Nguluwi, hawaditile kota vyowalajizwe na mndewa wa Misili, ila hewo nawawaleka wana walume wa Waisilaeli wekale. ");
INSERT INTO vid_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Mndewa wa Misili nakawachema wahunga awo, na kuwauza, “Lekachoni namdita ahyo? Lekachoni muwalechile wakomu wana walume?” ");
INSERT INTO vid_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Hewo nawamwidichila Falao, “Wadala wa Chiebulaniya hawawele kota wadala wa Misili. Hewo ndo nawali na mong'ho, mhunga hanafika, hewo wawaga mina wapondile.” ");
INSERT INTO vid_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","Nguluwi nakawatambichiza wahunga awo, nawo Waisilaeli nawalutilila konjezeka na kuwa na mong'ho ng'hatu. ");
INSERT INTO vid_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","Kwa vila wahunga awo nawali womdumba Nguluwi, Nguluwi nakawatambichiza leka waponde wana wawo. ");
INSERT INTO vid_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Hamba Falao nakawalajiza wanhu weng'ha wa heye, yolonga, “Chila mwana mlume yoleleka kwa Waebulaniya mumtaje mlwanda lwa Naili, ila chila mwana mdala mlecheni yawe mkomu.” ");
INSERT INTO vid_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Kwali na munhu yumwe wa lukolo lwa Walawi nayahesile mdala yumwe na heye yawele wa lukolo wa Walawi. ");
INSERT INTO vid_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","Lelo mamo ayu nakapata himila, nakamponda mwana mlume. Loyawene kota mwana chali ayu nakanoga ng'hatu, nakamvisa kwa mhela wa myezi jidatu. ");
INSERT INTO vid_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Ila kwa vila nakalemwela kumvisa kwa mhela uyage, nakadita chinhu kota chidoto cha minyi na kubakaliza chinhu kota lami, nakamuwika yula mwana mgati. Hamba nakachiwika chidoto hafungo mwa lwanda lwa Naili hali mikuluwili. ");
INSERT INTO vid_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Lumbulye mwana ayo nakevisa behi na honhu aho leka yalole choni chimfika mng'holoze. ");
INSERT INTO vid_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Lelo mhinza wa Falao nakedulika kulwanda yoje, na vitumagwa wa heye wadala wawa wojendajenda hafungo mwa lwanda lwa Naili. Mhinza wa Falao nakachona chila chidoto hali mikuluwili, nakamlajiza mpogozi wa heye yakachihole. ");
INSERT INTO vid_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Loyachigubule nakamona yula mwana chali, yolila. Nakamonela isungu, nakalonga, “Ayu ndo yumwe wa wana wa Waebulaniya.” ");
INSERT INTO vid_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Baho du lumbulye yula mwana nakalawila, nakamlonjela mhinza wa Falao, “Ndaze, ndute ndikamcheme munhu wa kumonyeza mwana ayu hali wadala wa Chiebulaniya?” ");
INSERT INTO vid_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Mhinza wa Falao nakamlonjela, “Ena, luta.” Lelo ayo mhinza nakaluta, nakamchema mayake ayo mwana. ");
INSERT INTO vid_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Mhinza wa Falao nakamlonjela yula mdala, “Umhole mwana ayu na kumonyeza honhu hangu, nani ndokupa sendi kwa mijito ajo.” Lelo ayo mdala nakamhola mwana ayo, nakamlela. ");
INSERT INTO vid_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Mwana naloyawele yakulile, mayake nakamhilika kwa mhinza wa Falao, naye nakamhola na kumdita mwanage. Mhinza wa Falao nakalonga, “Ndimlavya mmazi,” ahyo, nakamha mwana ayo itagwa lya Musa. Itagwa lya Musa lyanguzeleka kota kulavya. ");
INSERT INTO vid_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Zuwa limwe, Musa naloyawele msongolo, nakawalutila Waebulaniya wayage leka kulola vyowogaya. Lelo nakamona Mmisili yumwe yomtowa Muebulaniya yumwe wa nhanzi ya Musa. ");
INSERT INTO vid_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Musa nakalola aku na kula, naloyawene kota kuduhu munhu habehi, nakamkopola yula Mmisili na kumvisa mmisanga. ");
INSERT INTO vid_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Hamitondo, Musa nakalawa kahi, nakawona Waebulaniya weli wochitowa. Lelo nakamlonjela yula yawifile, “Lekachoni kwangumtowa muyago?” ");
INSERT INTO vid_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Na heye nakamwidichila, “Yalihi yakuwichile hegwe kuwa chilongozi na mtagusa wa hetwe? Ndaze, kwangugana kung'hopola kota vyoumkopole yula Mmisili?” Ahyo, Musa nakadumba na kijesa, “Hanji mbuli ayi izeleka.” ");
INSERT INTO vid_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Na heye Falao naloyahuliche mbuli ayo nakagana kumkopola Musa. Ila Musa nakambilima Falao, nakaluta kikala kuli isi ya Midiani. Zuwa imwe, Musa nayali yekale hafungo ha izimbo lya mazi. ");
INSERT INTO vid_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","Lelo wahinza saba wa mtambika wa ako Midiani nawoya kudeha mazi na kumemeza mibato kwa mbuli ya chilundo cha mhene na ming'holo ja mhaza wa hewo. ");
INSERT INTO vid_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Wadimi wanji nawoya na kuwawinga awo wahinza. Ila Musa nakawatanza wahinza awo na kujinweza migongolo ja hewo. ");
INSERT INTO vid_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Lowamhiluchile mhaza wa hewo Leueli, heye nakawauza, “Lekachoni lehano namhiluka himahima ahyo?” ");
INSERT INTO vid_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Hewo nawamwidichila, “Mmisili yumwe nakatulohola mmoko mwa wala wadimi, na heye yuye nakadeha mazi nakujinweza migongolo ja hetwe.” ");
INSERT INTO vid_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Mhaza wa hewo nakawauza wahinza wa heye, “Kakohi? Lekachoni mumleka ako? Mumcheme yoye yalye chilyo.” ");
INSERT INTO vid_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Musa nakakunda kikala kwa ayo munhu. Lelo ayo munhu nakamha Musa mhinza wa heye nayachemigwe Sipola yawe mdala wa heye. ");
INSERT INTO vid_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Sipola nakampondela Musa mwana mlume. Musa nakalonga, “Nang'hundizwa kikala kuli isi ayo ya chiunjenzi,” ahyo nakamchema ayo mwana Gelishomu. ");
INSERT INTO vid_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Lojipulute miyaka jimwenga, mndewa wa Misili nakabagama. Waisilaeli nawang'ung'uta na kulila vyowawele kuli upogozi na kulila kwa hewo nakumlutila Nguluwi. ");
INSERT INTO vid_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Nguluwi nakahulika chowali wong'ung'utila hewo, na heye nakakumbuchila ilagano lyoyaditile na Abulahamu na Isaka na Yakobo. ");
INSERT INTO vid_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Nguluwi nakawalola Waisilaeli, na heye nakawona vyowali na kuvizela usungu wa hewo. ");
INSERT INTO vid_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Zuwa limwe, Musa nayali yodima chilundo cha ming'holo ja mgosi wa heye, Yesilo, mtambika wa Midiani. Musa nakachihilika chila chilundo ubanzi wa kolizibilaga isanya mwa kuchiwala, nakachifichila chidunda cha Holebu, chidunda cha Nguluwi. ");
INSERT INTO vid_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Lelo mhilisi wa Mkulu Nguluwi nakamlawila mlilapi lya chiluli hagati na chisosolo. Musa nakalola, nakabubuwala kona chisosolo chikwaka chiluli na hambe chilakale. ");
INSERT INTO vid_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Lelo Musa nakelonjelela, “Achi ndo chinduzanduza. Chisosolo kwaka na hambe chilakale? Tandi ndute behi, ndole goya.” ");
INSERT INTO vid_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Mkulu Nguluwi loyamuwene Musa yogalamka kuchilola chisosolo, nakamchema hala mchisosolo, “Musa! Musa!” Musa nakedichila, “Ena! Heni nda baha.” ");
INSERT INTO vid_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Nguluwi nakamlonjela, “Uleche kuhejela habehi. Uvule makwamba gako kwa vila honhu aha howimile ndo helile.” ");
INSERT INTO vid_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Hamba Nguluwi nakamlonjela, “Heni nda Nguluwi wa mhaza wa hegwe Abulahamu na Nguluwi wa Isaka na Nguluwi wa Yakobo.” Musa nakagubika meho gake kwa vila nakadumba kumlola Nguluwi. ");
INSERT INTO vid_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Hamba Mkulu Nguluwi nakamlonjela, “Ndangukomya mbona ng'hatu kugaya kwa wanhu wa heni wawele Misili na nyhulika chililo cha hewo chambuzwe na walolezi wa Wamisili. Ndigazela magazo ga hewo, ");
INSERT INTO vid_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","ahyo mbuya leka ndiwagombole mmoko mwa Wamisili. Ndowalavya amo muisi na kuwahilika kuli isi inojile na ng'hulu, isi iwele na mboto, isi ya Wakanaani na Wahiti na Waamoli na Wapelisi na Wahivi na Wayebusi. ");
INSERT INTO vid_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Ena, chililo cha Waisilaeli chimbuyila, mbona Wamisili vyowalinguwagaza. ");
INSERT INTO vid_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Lelo ulute ndangukulajiza kwa Falao leka uwalavye wanhu wa heni, Waisilaeli muisi ya Misili.” ");
INSERT INTO vid_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Ila Musa nakamlonjela Nguluwi, “Heni nda whaani mbaka ndimlutile Falao na kuwalavya Waisilaeli kuli isi ya Misili?” ");
INSERT INTO vid_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Nguluwi nakamlonjela, “Heni ndowa hamwe na hegwe. Houwalavile wanhu wa Isilaeli kulawa Misili na kuya kufugamila heni mchidunda chichi. Awu wowa ndo ulajilo kota ndo heni Nguluwi ndikulajize hegwe.” ");
INSERT INTO vid_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Aho, Musa nakamlonjela Nguluwi, “Lelo londiwalutila Waisilaeli na kuwalonjela, ‘Nguluwi wa wasekulu wa hemwe nakanhuma kwa hemwe,’ nawo howombuza, ‘Itagwa lyake lyani,’ ndowalonjela choni?” ");
INSERT INTO vid_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Nguluwi nakamwidichila Musa, “HENI NDO NDIWELE.” Na kahi nakalonga, “Walonjele ahi wanhu wa Waisilaeli, ‘Yula yalinguchemigwa, HENI NDIWELE, kandajiza kwa hemwe.’ ” ");
INSERT INTO vid_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Nguluwi nakamlonjela Musa, “Walonjele ahi Waisilaeli, ‘Mkulu Nguluwi, Nguluwi wa wasekulu wa hemwe na Nguluwi wa Abulahamu na Nguluwi wa Isaka na Nguluwi wa Yakobo, nakandajiza kwa hemwe. Ali ndo itagwa lyangu mazuwa gose, na ahyo ndo vyondiwa ndikumbuchilwa mli lulelo lweng'ha.’ ");
INSERT INTO vid_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","Luta ukawakungajize wasekulu wa Isilaeli na kuwalonjela, ‘Mkulu Nguluwi, Nguluwi wa wasekulu wa hemwe, Nguluwi wa Abulahamu na Nguluwi wa Isaka na Nguluwi wa Yakobo, nakandawila na kulonga, “Ndiwalolani na kona isungu kwa kuzona mbuli zomlinguditilwa kuli isi ya Misili. ");
INSERT INTO vid_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","Ndangilaha kota ndowalavya mli kugaya kwa hemwe ako Misili na kuwahilika kuli isi ya Wakanaani na Wahiti na Waamoli na Wapelisi na Wahivi na Wayebusi, ndowahilika kuli isi iwele na mboto.” ’ ");
INSERT INTO vid_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","“Hewo wokuhulichiza, nagwe hamwe na wasekulu wa Waisilaeli momlutila mndewa wa Misili na kumlonjela, ‘Mkulu Nguluwi, Nguluwi wa Waebulaniya, nakatulawila. Lelo utukundize twinule majendo ga mazuwa gadatu kuchiwala, tukamlavile nhambiko Mkulu Nguluwi, Nguluwi wa hetwe.’ ");
INSERT INTO vid_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Ndivizela kota mndewa wa Misili howakundiza muche mbaka yavizele kota heni ndina ludali ng'hatu kusinda heye. ");
INSERT INTO vid_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Lelo ndowalajila ludali lwa heni kwa kuitowa isi ya Misili kwa vinduzanduza vyondiza dita ako. Hamba mndewa kowalechela muche. ");
INSERT INTO vid_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","Kahi ndogana mbone Wamisili wowakunda Waisilaeli, na homkuka Misili, hamkuka moko hela. ");
INSERT INTO vid_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Chila mdala wa Chiebulaniya komlanda wekalase behi na heye Mmisili ama mjenzi yawele mng'handa ya heye, yamhe vinhu vilingupulika vya sendi na zahabu hamwe na nguwo. Ahyo mowavika wana wa hemwe wasongolo na wadala. Ahyo ndo Waisilaeli vyowaholile lufufu lwa Wamisili.” ");
INSERT INTO vid_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Musa nakamlonjela Mkulu Nguluwi, “Ila Waisilaeli hawokunda ne kunyhulichiza, hanji wolonga kota hegwe Nguluwi hundawile hebu.” ");
INSERT INTO vid_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Aho Mkulu Nguluwi nakamuuza Musa, “Kibata choni mmoko mwa hegwe?” Musa nakamwidichila, “Ng'weku.” ");
INSERT INTO vid_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","Mkulu Nguluwi nakamlonjela, “Ulagaze hanyi.” Musa nakalagaza ng'hweku hanyi, nayo naigaluka kuwa izoka. Musa nakaibilima. ");
INSERT INTO vid_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Ila Mkulu Nguluwi nakamlonjela Musa, “Ugolole moko wa hegwe, ulibate mchila.” Musa nakagolola moko wa heye, nakalibata, izoka naligaluka kuwa ng'hweku kahi mmoko mwa heye. ");
INSERT INTO vid_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","Mkulu Nguluwi nakamlonjela, “Ahyo, kwa chinduzanduza achi, Waisilaeli woweza kukunda kota heni nda Mkulu Nguluwi, Nguluwi wa wasekulu wa hewo na Nguluwi wa Abulahamu na Nguluwi wa Isaka na Nguluwi wa Yakobo, ndikulawila.” ");
INSERT INTO vid_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Kahi, Mkulu Nguluwi nakamlonjela, “Winjize moko wa hegwe mli ikanzu lya hegwe.” Musa nakadita hiho, ila loyalavile kunze, baho uwa na uswema. ");
INSERT INTO vid_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Hamba Nguluwi nakamlonjela, “Winjize kahi moko wa hegwe mli ikanzu lya hegwe.” Musa nakenjiza moko wa heye mli ikanzu lya heye. Loyaulavile kunze, baho du uwa goya kota vyoluwele lukuli lwa heye aho hamwande. ");
INSERT INTO vid_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Nguluwi nakamlonjela Musa, “Wone hawokwidichila ama kukunda ulajilo wa mwaluko, hanji wokunda ulajilo lwa keli. ");
INSERT INTO vid_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Ila wone hawakundile ne ulajilo awu weng'ha wili, ama kukunda ulonzi wa hegwe, kogadeha mazi ga lwanda lwa Naili na kugabohola mchanya mwa isi ng'havu. Mazi ago gowa danda mchanya mwa isi ng'havu.” ");
INSERT INTO vid_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Ila Musa nakamlonjela Mkulu Nguluwi, “Dedede Mkulu wa heni, heni sidahile kulonga goya kulawila hamwande, hanga na hala houlonjile na heni chitumagwa wa hegwe, heni sidahile kulonga goya ng'hatu.” ");
INSERT INTO vid_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Aho Mkulu Nguluwi nakamuuza, “Whaani yalumbile umyango wa munhu? Whaani yomdita munhu yalemwele kulonga na kuhulika? Whaani yomdita munhu yalole ama yawe hambe yalole? Ndaze, hawele Mkulu Nguluwi? ");
INSERT INTO vid_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Lelo ulute. Heni ndoulongoza umyango wa hegwe na kukulangusa cha kulonga.” ");
INSERT INTO vid_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Ila Musa nakalonga, “Hegwe Mkulu wa heni, dedede ndangukulanda, umlajize munhu yunji.” ");
INSERT INTO vid_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Ndo baho kuzudila kwa Mkulu Nguluwi lolwachile kwa Musa, nakamlonjela, “Ndaze, kuduhu mng'holozo Aluni yawele Mlawi? Ndivizela heye kaweza kulonga goya. Kahi kanguya kuting'hana na hegwe, baho du hoyokona kosangalala ng'hatu mnhumbula. ");
INSERT INTO vid_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Hegwe kolonga na heye na kumlonjela geng'ha goyolonga. Heni ndowatanzani na kuwalangusa mbuli za kudita. ");
INSERT INTO vid_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","Aluni kodawala na Waisilaeli honhu hako. Heye kowa yolonga honhu ha hegwe, nagwe kowa kota Nguluwi kwa heye. ");
INSERT INTO vid_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Kochibata mmoko mwako ng'hweku ayi ndo ikutanza kudita ula ulajilo.” ");
INSERT INTO vid_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Musa nakahiluka kwa Yesilo, mgosi wa heye, nakamlonjela, “Dedede ung'hundize nyhiluche Misili kwa wang'holozangu, ndikalole wone wawele wakomu.” Yesilo nakamlonjela, “Lute goya.” ");
INSERT INTO vid_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Musa loyali yang'hali muisi ya Midiani, Mkulu Nguluwi nakamlonjela, “Uhiluche Misili kwa vila wala weng'ha nawaganile kukukopola nawabagama.” ");
INSERT INTO vid_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Lelo Musa nakamhola mchewake na wanage, nakawakwiniza midogowi, nakaluka majendo ga kuhiluka Misili. Mmoko mwa heye nakahola yila ng'hweku yalonjelwe na Nguluwi yaihole. ");
INSERT INTO vid_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Mkulu Nguluwi nakamlonjela Musa, “Loufika Misili, uwe uvizelele kota kudita hali Falao vinduzanduza vyeng'ha vyondikupele ludali lwa kudita. Ila heni ndoidita nhumbula ya Falao iwe igagadale, na heye howalechela Waisilaeli woche. ");
INSERT INTO vid_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Nagwe komlonjela Falao kota Mkulu Nguluwi kangulonga ahi, ‘Isi ya Isilaeli ndo mlelwa wa heni wa mwaluko mlume. ");
INSERT INTO vid_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","Nani ndangukulonjela, Mleche mwanangu yoche leka yakafugamile heni. Wone uleme kumlechela yoche, ulole ndomkopola mlelwa wa hegwe wa mwaluko mlume.’ ” ");
INSERT INTO vid_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Loyali yang'hali mnzila kuhiluka Misili, Musa nayali honhu ha kuwasa wajenzi, Mkulu Nguluwi nakating'hana na heye nakajeza kumkopola. ");
INSERT INTO vid_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","Aho Sipola nakahola iganga linoleche, nakalidumula igovi lya mwanage na kumdoliza nalyo Musa mmagulu yolonga, “Hegwe ndo mkasano wa danda”. ");
INSERT INTO vid_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","Aho Mkulu Nguluwi nakamleka Musa yawele mkomu. Sipola nayali yalonjile, “Mkasano wa danda,” kwa mbuli ya kwinjiza ikumbi. ");
INSERT INTO vid_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Mkulu Nguluwi nakamlonjela Aluni, “Ulute kuchiwala ukating'hane na Musa.” Aluni nakaluta nakating'hana na Musa kuli chidunda cha Nguluwi, nakamnonela. ");
INSERT INTO vid_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Na heye Musa nakamlonjela Aluni ulonzi weng'ha woyalonjelwe na Mkulu Nguluwi yalonje, na ulajilo weng'ha woyalajizwe na Nguluwi yadite. ");
INSERT INTO vid_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Hamba Musa na Aluni nawaluta ako Misili, wawakungajiza wasekulu weng'ha wa Waisilaeli. ");
INSERT INTO vid_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Aluni nakawalonjela ulonzi weng'ha Mkulu Nguluwi woyamlonjele Musa na kudita ula ulajilo hali wanhu weng'ha. ");
INSERT INTO vid_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","Wanhu weng'ha nawakunda. Nalowahuliche kuta Mkulu Nguluwi koya kuwatanza Waisilaeli na kuta nakona isungu kwa kugaya kwa hewo, weng'ha nawamfugamila Nguluwi. ");
INSERT INTO vid_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Hamba, Musa na Aluni nawamlutila Falao, nawamlonjela, “Mkulu Nguluwi, Nguluwi wa Isilaeli kangulonga hino, ‘Uwaleche wanhu wa heni woche, wakanditile mnvina kuchiwala.’ ” ");
INSERT INTO vid_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Ila Falao nakawauza, “Ndo yalikohi ayo Mkulu Nguluwi, mbaka nani ndimhulichize na kuwaleka Waisilaeli woche? Heni simzelele ayo Mkulu Nguluwi, na siwalechela hebu Waisilaeli woche.” ");
INSERT INTO vid_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Musa na Aluni nawamlonjela, “Nguluwi wa Waebulaniya nakating'hana na hetwe. Twangukudedeza utuleche tuche kuchiwala kwa majendo ga mazuwa gadatu tukamlavile nhambiko Mkulu Nguluwi, Nguluwi wa hetwe. Wone haiwa kota ahyo, kotukopola kwa matamwa gehile ama ngondo.” ");
INSERT INTO vid_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Ila mndewa wa Misili nakawedichila, “Hemwe Musa na Aluni, lekachoni mwangujeza kuwalavya wanhu kuli mijito ja hewo? Hemwe wapogozi weng'ha mhiluche kuli mijito ja hemwe.” ");
INSERT INTO vid_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Kahi Falao nakalonga, “Awa wanhu wa hemwe ndo wenji kusinda wenyeng'haye, mwangugana waleche kukola mijito!” ");
INSERT INTO vid_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Zuwa lilyo Falao nakawalajiza walolezi wa wakolamijito hamwe na vilongozi wanji, nakalonga, ");
INSERT INTO vid_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","“Mleche kuwapa misolo ja kugongomanyila mitufali kota vyoiwele mazuwa gapulute. Hewo wawo woluta kikungajizila misolo wawo. ");
INSERT INTO vid_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Ila hisabu ya mitufali galinguditikwa iwe yiyila, naileche kuwa nyindo, ne itufali limwe, kwa vila wanhu awa ndo wagata ndo mina wangutowa iyowe. ‘Utuleche tuche tukamlavile nhambiko Nguluwi wa hetwe.’ ");
INSERT INTO vid_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Muwonjezele wanhu awa mijito iwele itunyo leka walavye chituguti waleche kuhulichiza ulonzi wa udesi.” ");
INSERT INTO vid_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Lelo vilongozi wa walolezi na walolezi wa Waisilaeli wayao nawalawa kunze na kuwalonjela wanhu, “Falao kangulonga ahi, ‘Siwagalilani misolo, ");
INSERT INTO vid_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Mlute mwemwe baho mikekungajizile misolo honeche homuweza kujona, na mijito ya hemwe haipunguzigwa hebu.’ ” ");
INSERT INTO vid_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Baho wanhu weng'ha nawasambaluka chila honhu muisi ya Misili wopala misolo jisigale ja kudidichila mitufali. ");
INSERT INTO vid_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Na hewo walolezi nawalutilila kulonga, “Mgomanjize mijito ya chila zuwa kota vila katali nalomwali migalilwa misolo.” ");
INSERT INTO vid_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Walolezi wa Falao nawawazapa walolezi wa Waisilaeli wayao wolonga, “Lekachoni hamligongomanya mijito iwazigwe na kweneza hisabu yiyila ya mitufali kota aho hamwande vyomlajizwe?” ");
INSERT INTO vid_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Ahyo ndo walolezi wa wakolamijito wa Waisilaeli howalutile kwa Falao, wamlilila nakulonga, “Lekachoni kwangutuditila ahi hetwe vitumagwa wa hegwe? ");
INSERT INTO vid_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Hatulingupegwa kahi misolo jeng'ha jila, na aku twangukolezwa lupichi kuditika mitufali. Kahi hetwe vitumagwa wa hegwe twangutowigwa, aku wawifile, ndo wanhu wa hegwe.” ");
INSERT INTO vid_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Ila Falao nakalonga, “Wagata hemwe, hemwe mwa wagata, ndo mina mwangulonga, ‘Tuleche tuche tukamlavile nhambiko Mkulu Nguluwi.’ ");
INSERT INTO vid_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Mlute lelo mkakole mijito, mina hampegwa misolo joneche jila na mogongomanya hisabu yiyila ya mitufali.” ");
INSERT INTO vid_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Lelo awo walolezi wa Waisilaeli sambi nawona kota wa mmagazo, kwa vila nawalonjelwa, “Hamkusilwa ne hado hisabu ya mitufali ya chila zuwa.” ");
INSERT INTO vid_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Nalowochile kwa Falao, nawating'hana na Musa na Aluni, nawali wowabeteza. ");
INSERT INTO vid_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","Lelo nawawalonjela Musa na Aluni, “Mkulu Nguluwi nayayone mbuli ayi, na kuwatagusa hemwe kwa vila mtudita hetwe tuzudilwe na Falao na vitumigwa wa heye, hemwe muwapa chiwalo cha kutukopola.” ");
INSERT INTO vid_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Hamba Musa nakamgalamchila kahi Mkulu Nguluwi, na kulonga, “Hegwe Mkulu Nguluwi, lekachoni ulinguwaditila wanhu awa wihe? Lekachoni nakunhuma heni hano? ");
INSERT INTO vid_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Kulawila londali ndilonga na Falao kwa itagwa lya hegwe, heye nakawaditila wihe wanhu awa. Hegwe hunadita chinhu choneche cha kuwagombola wanhu wa hegwe.” ");
INSERT INTO vid_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Ila Mkulu Nguluwi nakamlonjela Musa, “Lelo kolola vyondimditila Falao, mina kwa moko, kowakundiza walute na kwa moko kowawinga kulawa isi ya heye.” ");
INSERT INTO vid_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Nguluwi nakamlonjela Musa, “Heni nda Mkulu Nguluwi. ");
INSERT INTO vid_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Nandimlawila Abulahamu na Isaka na Yakobo lonzeleche kota Nguluwi yawele na mong'ho, ila itagwa lyangu Mkulu Nguluwi nahalizeleche kwa hewo. ");
INSERT INTO vid_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Kahi nambika ilagano lya heni na hewo lya kuwapa isi ya Kanaani, isi yowekale kota wajenzi. ");
INSERT INTO vid_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Lelo nanyhulika kung'ung'uta kwa Waisilaeli, nawawele wotunywa na Wamisili, nani ndilikumbuka ilagano lyangu. ");
INSERT INTO vid_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","Lelo walonjele Waisilaeli, ‘Heni nda Mkulu Nguluwi na ndowalavya hemwe kuli itunyo lya Wamisili, nani ndowalohola kuli upogozi wa hewo na kuwagombola kwa moko wa heni ugoloche na kuwagaza lukami Wamisili, ");
INSERT INTO vid_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","nani ndowaditani hemwe muwe wanhu wa heni, nani ndiwe Nguluwi wa hemwe, na movizela kota heni nda Mkulu Nguluwi, Nguluwi wa hemwe, ndiwele ndiwalohole kuli itunyo lya Wamisili. ");
INSERT INTO vid_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Nani ndowegala mbaka kuli isi yila iwele nandilaha ndowapa Abulahamu na Isaka na Yakobo, ndowapa isi ayi iwe ya hemwe. Heni nda Mkulu Nguluwi.’ ” ");
INSERT INTO vid_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Musa nakawalonjela Waisilaeli ulonzi awo, ila nahawamuhulichize kwa chiwalo cha usungu wa nhumbula na kwa chiwalo cha itunyo lya upogozi. ");
INSERT INTO vid_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Hamba Mkulu Nguluwi nakamlonjela Musa, ");
INSERT INTO vid_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","“Ulute kwa Falao, mndewa wa Misili, umlonjele uwaleche Waisilaeli woche kuli isi ya heye.” ");
INSERT INTO vid_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Ila Musa nakamwidichila Mkulu Nguluwi, “Ulole, Waisilaeli hawalingunyhulichiza heni. Lelo yowa ndaze ayo Falao yanyhulichize heni, ndilingulemwela kulonga goya?” ");
INSERT INTO vid_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Ila Mkulu Nguluwi, nakalonga na Musa na Aluni, nakawalajiza walute kwa Falao, mndewa wa Misili na kuwalavya Waisilaeli kuli isi ya Misili. ");
INSERT INTO vid_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Ayi ndo mbuli ya matagwa ga wakulu wa lukolo lwawo. Wana walume wa Lubeni, mlelwa wa mwaluko wa Isilaeli nawali, Enoki na Palu na Hesiloni na Kalimi. Alo nalwali lukolo lwa Lubeni. ");
INSERT INTO vid_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Wana walume wa Simeoni nawali, Yemueli na Yamini na Ohadi na Yakini na Sohali na Shauli mwana wa mdala kulawa Kanaani, alo ndo lukolo lwa Simeoni. ");
INSERT INTO vid_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Aga ndo matagwa ga wana walume wa Lawi, vivila na lukolo lwawo, Gelishoni na Kohati na Melali. Lawi nakekala kwa miyaka miya imwe na makumi gadatu na saba. ");
INSERT INTO vid_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Wana walume wa Gelishoni nawali, Libuni na Shimei, vivila na lukolo lwawo. ");
INSERT INTO vid_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Wana walume wa Kohati nawali, Amulamu na Ishali na Hebuloni na Usieli. Kohati nakekala kwa miyaka miya imwe na makumi gadatu na zidatu. ");
INSERT INTO vid_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Wana walume wa Melali nawali Mahuli na Mushi. Awo ndo wasekulu wa lukolo lwa Walawi. ");
INSERT INTO vid_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Amulamu nakamhesa Yokebedi, lumbu wa mhaza wa heye, na heye nakampondela Aluni na Musa. Amulamu nakekala miyaka miya imwe na makumi gadatu na saba. ");
INSERT INTO vid_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Na wana walume wa Ishali nawali, Kola na Nefegi na Sikili. ");
INSERT INTO vid_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Wana walume wa Usieli nawali, Mishaeli na Elisafani na Sitili. ");
INSERT INTO vid_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Aluni nakamhesa Elisheba, mhinza wa Aminadabu, lumbulye Nashoni, na heye nakampondela wana walume, Nadabu na Abihu na Eleasali na Itamali. ");
INSERT INTO vid_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Na hewo wana walume wa Kola nawali, Asili na Elikana na Abiasafu, nawawele wasekulu wa lukolo lwa Kola. ");
INSERT INTO vid_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Eleasali mwana wa Aluni nakamhesa yumwe wa wahinza wa Putieli, na heye nakampondela Finehasi. Awa ndo nawali wakulu wa lukolo lwa Lawi. ");
INSERT INTO vid_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","Aluni na Musa ndo wawo nawalonjelwe na Mkulu Nguluwi, “Muwalavye wanhu wa Isilaeli kuli isi ya Misili, vilundo kwa vilundo.” ");
INSERT INTO vid_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Ndo wawo Musa na Aluni nawadogole na Falao mndewa wa Misili, mbuli ya kuwalavya Waisilaeli kuli isi ya Misili. ");
INSERT INTO vid_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","Zuwa lila Mkulu Nguluwi naloyalonjile na Musa kuli isi ya Misili, ");
INSERT INTO vid_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","nakamlonjela Musa, “Heni ndo Mkulu Nguluwi. Mlonjele Falao, mndewa wa Misili, ulonzi weng'ha wondikulonjela.” ");
INSERT INTO vid_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Ila Musa nakamlonjela Mkulu Nguluwi, “Kuvizela kota sidahile kulonga goya, lelo Falao konyhulichiza ndaze?” ");
INSERT INTO vid_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Mkulu Nguluwi nakamlonjela Musa, “Ulole, heni ndikudita uwe kota Nguluwi kwa Falao, na heye mng'holozo Aluni kowa yolonga honhu ha hegwe. ");
INSERT INTO vid_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Mlonjele mng'holozo Aluni mbuli yeng'ha yondikulajiza, na heye Aluni mng'holozo, komlonjela Falao yawaleche Waisilaeli walawe kuli isi ya heye. ");
INSERT INTO vid_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Ila ndoidita nhumbula ya Falao iwe igagadale. Na nyonjeze vinduzanduza na kububuwaza kwa heni kuli isi ya Misili, ");
INSERT INTO vid_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","ila Falao hokuhulichiza, na aho ndougolola moko wa heni uwele na ludali na kuigaza ng'hatu isi ya Misili, na kuwalavya wanhu wa heni, nhanzi za Isilaeli kulawila Misili. ");
INSERT INTO vid_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Mhela wondiugolola moko wa heni kwa isi ya Misili na kuwalavya Waisilaeli hali hewo. Aho ndo Wamisili wovizela kota heni nda Mkulu Nguluwi.” ");
INSERT INTO vid_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Lelo Musa na Aluni nawadita ahyo, ena, nawadita kota Mkulu Nguluwi navyoyawalajize. ");
INSERT INTO vid_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Musa nayali na miyaka makumi nane, na Aluni nayali na miyaka makumi nane na gadatu mhela awo nawalongase na Falao. ");
INSERT INTO vid_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Mkulu Nguluwi nakawalonjela Musa na Aluni, ");
INSERT INTO vid_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","“Falao hoyowalonjela mtawize mbuli ayo kwa kudita vinduzanduza, hegwe komlonjela Aluni yaihole ng'hweku ya heye, na yaitoze hali Falao, nayo yogaluka izoka.” ");
INSERT INTO vid_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Lelo Musa na Aluni nawamlutila Falao na kudita kota navyowalajizwe na Mkulu Nguluwi. Aluni nakatoza ng'hweku ya heye hali Falao na vitumigwa wa heye, nayo naigaluka izoka. ");
INSERT INTO vid_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Ila Falao nakawachema wanhu wa heye wawele na nyhala na wahawi, awo wahawi wa Misili nawadita hihyo kwa uhawi wa hewo. ");
INSERT INTO vid_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Chila yumwe nakatoza ng'hweku ya heye hasi naigaluka izoka. Ila ng'hweku ya Aluni naizimela ng'hweku za hewo. ");
INSERT INTO vid_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Kwa ago geng'ha, nhumbula ya Falao naipona igagadale, nahawawahulichize, naiwa kota navyoyalonjile Mkulu Nguluwi. ");
INSERT INTO vid_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Hamba Mkulu Nguluwi nakamlonjela Musa, “Nhumbula ya Falao igagadala. Kangulema ng'hatu kuwalechela Waisilaeli woche. ");
INSERT INTO vid_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Lelo ulute ukating'hane na heye mitondo, mhela hoyoluta kuli lwanda lwa Naili. Umbeteze Falao hafungo mwa lwanda. Uhole mmoko mwa hegwe ayila ng'hweku naigaluche izoka. ");
INSERT INTO vid_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","Hamba mlonjele ahi, ‘Mkulu Nguluwi, Nguluwi wa Waebulaniya, kandajiza kwa hegwe, na heye kangulonga ahi, “Waleche wanhu wa heni walute leka wafugamile heni kuchiwala, ila mbaka sambi hegwe kwangulema kuhulichiza.” ");
INSERT INTO vid_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Lelo Mkulu Nguluwi kangulonga kota sambi komzela heye ndo Mkulu Nguluwi. Ndogatowa mazi ga lwanda lwa Naili kwa ng'hweku ayi, na mazi gogaluka kuwa danda. ");
INSERT INTO vid_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Somba ziwele mlwanda wa Naili zofa na lwanda lweng'ha lonhung'ha vibi na Wamisili wozudizwa na mazi gake.’ ” ");
INSERT INTO vid_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Mkulu Nguluwi nakamlonjela Musa, “Umlonjele Aluni yahole ng'hweku ya heye na kuigolola mchanya mwa mazi ga Misili na mchanya mwa isi yeng'ha na mchanya mwa nzanda zeng'ha na nyhinda na mizimbo na milamba jawo jeng'ha, nago gowa danda. Kowa na danda isi yeng'ha na kuli vinhu vyeng'ha vya kuwichila mazi, vya mbao na vya maganga.” ");
INSERT INTO vid_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Musa na Aluni nawadita kota Mkulu Nguluwi navyoyawalajize. Aluni nakenula ng'hweku ya heye kuchanya hali Falao na vitumigwa wa heye, nakagatowa mazi ga lwanda lwa Naili na mazi geng'ha nagagaluka kuwa danda. ");
INSERT INTO vid_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Somba nazibagama, lwanda nalunhung'ha vibi ng'hatu mbaka Wamisili walemwela kunwa mazi ga lwanda Naili. Isi yeng'ha naimema danda. ");
INSERT INTO vid_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Ila wahawi wa Misili kwa uhawi wawo nawadita hiho. Ahyo nhumbula ya Falao naipona igagadale na heye nahawahulichize Musa na Aluni, iwa kota Mkulu Nguluwi navyoyalonjile. ");
INSERT INTO vid_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Lelo Falao, nakahiluka kaye na gala galawile nahagajesile. ");
INSERT INTO vid_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Wamisili weng'ha nawabawabawa hafungo mwa lwanda lwa Naili leka wadehe mazi, kwa vila nawalemwela kunwa mazi ga lwanda alo. ");
INSERT INTO vid_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Mazuwa saba nagapuluta kulawa Mkulu Nguluwi loyaugazile lwanda lwa Naili. ");
INSERT INTO vid_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Hamba Mkulu Nguluwi nakamlonjela Musa, “Mlute kwa Falao mkamlonjele Mkulu Nguluwi kangulonga ahi, ‘Uwaleche Waisilaeli woche leka kuli isi ya Misili wakafugamile heni. ");
INSERT INTO vid_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Ila wone uleme kuwaleka woche, lelo ndoitowa isi ya hegwe kwa kuwegalila mibula. ");
INSERT INTO vid_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Lwanda lwa Naili lomema mibula najo jokwinjila mbaka mgati mwa ng'handa ya hegwe, chihengo cha hegwe cha kuwasa, mchinanda mwa hegwe na kuli ng'handa za vitumagwa na wanhu wa hegwe. Mibula ajo jokwinjila kuli chiko na visaye vya hemwe vya kutimbulila utimbo. ");
INSERT INTO vid_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Mibula jokwina mchanya mwa lukuli lwa hegwe na mli ng'huli za wanhu wa hegwe na vitumagwa wa hemwe.’ ” ");
INSERT INTO vid_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Mkulu Nguluwi nakamlonjela Musa, “Mlonjele Aluni yagolole moko wa heye na ng'hweku ya heye mchanya mwa nzanda na mchanya mwa nyinda na mizimbo, najo mibula jolawila na kwenela chila honhu mli isi ya Misili.” ");
INSERT INTO vid_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Lelo Aluni nakagolola moko wa heye mchanya mwa mazi geng'ha ga Misili najo mibula najikwina mchanya na kuigubika isi yeng'ha ya Misili. ");
INSERT INTO vid_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Ila nawo wahawi nawadita uhawi kota awo na kujigala mibula kuli isi ya Misili. ");
INSERT INTO vid_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Hamba Falao nakawachema Musa na Aluni, nakawalonjela, “Mumdedeze Mkulu Nguluwi, leka yanyusile mibula aji, heni na wanhu wa heni, nani ndowaleka Waisilaeli walute na kumlavila nhambiko Mkulu Nguluwi.” ");
INSERT INTO vid_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Musa nakamwidichila Falao, “Goya! Ndonjele du mhela ulingugana ndikulandile kwa Mkulu Nguluwi na ndikulandile vitumagwa wa hegwe na wanhu wa hegwe, ndomlanda yakopole mibula aji jiwele kuli ng'handa za hemwe, jopona hela kuli lwanda lwa Naili.” ");
INSERT INTO vid_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","Falao nakamlonjela, “Mitondo.” Musa nakalonga, “Ndodita kota vyoulonga, leka uvizele kota kuduhu yoneche yalingiwhana na Mkulu Nguluwi, Nguluwi wa hetwe. ");
INSERT INTO vid_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Mibula jokuka kwa hegwe na kuli ng'handa za hegwe na kwa vitumagwa wa hegwe na kwa wanhu wa hegwe, jopona hela kuli lwanda lwa Naili.” ");
INSERT INTO vid_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Lelo Musa na Aluni nawoka haluga ha Falao na Musa nakamlilila Mkulu Nguluwi yamusile Falao kumema kwa mibula ajo najoyamigalile. ");
INSERT INTO vid_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","Mkulu Nguluwi nakadita kota Musa navyoyamlandile, mibula najifa mng'handa na mluga na kuli vipepela vya ng'handa na kuli migunda. ");
INSERT INTO vid_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Wanhu nawakungajiza mibula ajo chilundo kwa chilundo, isi yeng'ha nainung'ha nyee. ");
INSERT INTO vid_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Ila Falao loyawene kota isi ihola, nakawa na nhumbula igagadale kahi, nahawahuliche ng'oo Musa na Aluni, kota Mkulu Nguluwi navyoyalonjile. ");
INSERT INTO vid_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Hamba Mkulu Nguluwi nakamlonjela Musa, “Mlonjele Aluni yagolole ng'hweku ya heye na kutowa nhimbwisi nayo yogaluka kuwa sewe kweng'ha kuli isi ya Misili.” ");
INSERT INTO vid_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Musa na Aluni nawadita ahyo. Aluni nakagolola ng'hweku ya heye na kuitowa nhimbwisi, nayo naigaluka kuwa sewe na kuwakwina wanhu na migongolo. Nhimbwisi yeng'ha mli isi ya Misili naigaluka sewe. ");
INSERT INTO vid_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Wahawi wa Misili kwa uhawi wa hewo, nawajeza kuigalusa nhimbwisi iwe sewe, ila nawalemwela. Sewe azo nazenela kwa wanhu na migongolo. ");
INSERT INTO vid_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Wahawi nawamlonjela Falao, “Aji mijito ja moko wa Nguluwi.” Ila nhumbula ya Falao nailutilila kugagadala na nakalema kuwahulichiza Musa na Aluni. Naiwa kota Mkulu Nguluwi navyoyalonjile. ");
INSERT INTO vid_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Hamba Mkulu Nguluwi nakamlonjela Musa, “Mitondo ulilimche lufuku umlutile Falao mhela hoyoluta kulwanda umlonjele kota Mkulu Nguluwi kangulonga ahi, ‘Uwalechele wanhu wa heni woche leka wafugamile heni. ");
INSERT INTO vid_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Wone kolema kuwalechela walute, lelo ndokugalila vilundo vya ng'honzi hegwe na vitumagwa wa hegwe weng'ha. Wokwinjila mli ng'handa za hemwe zeng'ha za Wamisili zomema vilundo vya ng'honzi, hihyo du, na isi yeng'ha wanhu howawele. ");
INSERT INTO vid_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","Ila zuwa alyo honhu ha Gosheni walingikala wanhu wa heni ndoyamila, amo ng'honzi azo haziwa mumo. Aho ndo houvizela kota heni Mkulu Nguluwi nda hali isi ayi. ");
INSERT INTO vid_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Ndowaditila uganililo wanhu wa heni na ulajilo wowafika wanhu wa hegwe. Ulajilo awo woditikwa mitondo.’ ” ");
INSERT INTO vid_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Mkulu Nguluwi nakadita kota navyoyalonjile. Vilundo vikulu vya ng'honzi navigwa mng'handa ya Falao na ng'handa za vitumagwa wa heye. Wanhu weng'ha wa isi ayo nawagazigwa ng'hatu na ng'honzi azo. ");
INSERT INTO vid_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Ndo Falao nakawachema Musa na Aluni, nakalonga, “Moweza kuluta kumlavila nhambiko Nguluwi wa hemwe, ila mumu kuli isi ya Misili.” ");
INSERT INTO vid_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Ila Musa nakamwidichila, “Hebu, hainojile kudita ahyo, mina nhambiko zotumlavila Mkulu Nguluwi, Nguluwi wa hetwe, zowazudiza Wamisili. Ndaze, Wamisili howotona tulavya nhambiko zoziwele izudizo kwa hewo, hawotutowa kwa maganga? ");
INSERT INTO vid_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Yotulapa kwinula majendo kwa mazuwa gadatu kuza kuchiwala tukamlavile nhambiko Mkulu Nguluwi, Nguluwi wa hetwe, kota vyoyotulajiza.” ");
INSERT INTO vid_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Lelo Falao nakalonga, “Ndowaleka mlute kumlavila nhambiko Mkulu Nguluwi, Nguluwi wa hemwe, kuchiwala. Ila mleche kuluta kutali ng'hatu. Mndandile na heni.” ");
INSERT INTO vid_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Musa nakamwidichila Falao, “Baho du, hondikuleka, ndomlanda Mkulu Nguluwi yose vilundo avi vya ng'honzi mng'handa ya hegwe na vitumagwa wa hegwe na wanhu wa hegwe mitondo. Ila hegwe uleche kutubada kahi kuwalemeza wanhu kuluta kumlavila nhambiko Mkulu Nguluwi.” ");
INSERT INTO vid_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","Lelo Musa nakoka haluga ha Falao, nakamlanda Mkulu Nguluwi. ");
INSERT INTO vid_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","Mkulu Nguluwi nakadita kota Musa navyoyamlandile, zila ng'honzi nazuka kulawa kwa Falao na vitumagwa na wanhu wa heye, nahaiponile ne ng'honzi imwe. ");
INSERT INTO vid_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Ila mhela awu kahi, Falao nayali na nhumbula igagadale, nahawakundize Waisilaeli kuka. ");
INSERT INTO vid_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Hamba Mkulu Nguluwi nakamlonjela Musa, “Winjile hegwe kwa Falao umlonjele kota heni Mkulu Nguluwi, Nguluwi wa Waebulaniya ndangulonga, ‘Uwaleche wanhu wa heni woche leka wakafugamile heni. ");
INSERT INTO vid_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Wone uleme kuwalechela woche na houlutilila kuwebatilila, ");
INSERT INTO vid_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","ndogolola moko wa heni na kuwegalila matamwa gehile ng'hatu kuli migongolo ja hemwe jeng'ha, misenga na falasi na midogowi na ngamiya na mhene na ming'holo. ");
INSERT INTO vid_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Na ndojibagula migongolo ja Waisilaeli na migongolo ja Wamisili leka igongolo ne limwe lya Waisilaeli lileche kubagama.’ ” ");
INSERT INTO vid_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Kahi Mkulu Nguluwi nakawika mhela yolonga, “Mitondo heni Mkulu Nguluwi ndodita mbuli ayo muisi ya Misili.” ");
INSERT INTO vid_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Loifichile mitondo Mkulu Nguluwi nakadita choyalonjile. Migongolo jeng'ha ja Wamisili najibagama, ila kuduhuli igongolo ne limwe lya Waisilaeli libagame. ");
INSERT INTO vid_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Falao nakauza mbuli ilingulapa migongolo ja Waisilaeli, nakalonjelwa kuduhuli igongolo lya hewo ne limwe libagame. Na ahyo, Falao nayali yang'hali na nhumbula igagadale, na hawakundize Waisilaeli woche. ");
INSERT INTO vid_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Mkulu Nguluwi nakawalonjela Musa na Aluni, “Mhole miganza ja mivu ja itanulu, hamba Musa mhombe mchanya honhu hawele Falao yolola. ");
INSERT INTO vid_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Mivu ajo jowa nhimbwisi nzisili ikwenela kuli isi yeng'ha ya Misili. Yokwambuza mipu jotumbuka na jowa vilonda kwa wanhu na migongolo chila honhu muisi ya Misili.” ");
INSERT INTO vid_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Lelo nawahola mivu kulawa kuli itanulu, nawamlutila Falao, na heye Musa nakajihomba mchanya, na mipu najilawila kwa wanhu wa Misili na migongolo ja hewo. ");
INSERT INTO vid_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Wahawi nawo nawali wokugula ajo mipu, ahyo nahawawezile kwima hali Musa, kwa vila Wamisili weng'ha nawali na mipu. ");
INSERT INTO vid_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Ila Mkulu Nguluwi nakamdita Falao yawe na nhumbula igagadale, na heye hawahulichize kota hila Mkulu Nguluwi navyoyamlonjele Musa. ");
INSERT INTO vid_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Baho du, Mkulu Nguluwi nakamlonjela Musa, “Mitondo winuche kung'hali lufuku mlutile Falao, umlonjele kota heni Mkulu Nguluwi, Nguluwi wa Waebulaniya, kangulonga ahi, ‘Waleche wanhu wa heni woche leka wakafugamile heni. ");
INSERT INTO vid_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Lelo ndokigalila magazo ga heni geng'ha kwa hegwe na vitumagwa wa hegwe na chila munhu kuli isi ya hegwe. Hamba kovizela kota kuduhuli yoneche kuli isi yeng'ha yawele kota heni. ");
INSERT INTO vid_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Wone nandiwegalile matamwa hegwe na wanhu wa hegwe, hemwe mwahawele mbagame katali. ");
INSERT INTO vid_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Ila ndikuleka wikale leka ndiulajile ludali lwa heni. Kwa ahyo isi yeng'ha yovizela kota heni nda whaani. ");
INSERT INTO vid_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Ila ung'hali kidaya hali wanhu wa heni, na hambe uwaleche woche. ");
INSERT INTO vid_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","Ahyo, mitondo mhela kota uno, ndochigala nhonya ng'hulu ng'hatu ya maganga ndo haina lawila muisi ya Misili, kwalawa mwaluko mbaka lehano. ");
INSERT INTO vid_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Kwa ahyo ulajize migongolo ja hegwe na choneche chiwele ako kumgunda viwichigwe honhu hanojile, kwa vila nhonya ya maganga yomtowa chila munhu na igongolo liwele kumgunda na jing'hali hiluka haluga, jeng'ha jobagama.’ ” ");
INSERT INTO vid_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Vitumigwa wanji wa Falao nawadumba choyalonjile Mkulu Nguluwi, ahyo nawawahilika wapogozi na migongolo ja hewo haluga honhu hanojile. ");
INSERT INTO vid_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Ila wala wabezile ulonzi wa Mkulu Nguluwi nakawaleka wapogozi wa heye na migongolo ja heye kumgunda. ");
INSERT INTO vid_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Hamba, Mkulu Nguluwi nakamlonjela Musa, “Ugolole moko wa hegwe kuchanya kilanga, leka nhonya ya maganga itowe chila honhu muisi ya Misili. Imtowe munhu na igongolo na chila chilyo kumgunda.” ");
INSERT INTO vid_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Lelo Musa nakagolola ng'hweku ya heye kulola kilanga. Na heye Mkulu Nguluwi nekegala nhonya ya maganga na limlungu na chiluli na lumwemwesa isi. Mkulu Nguluwi nakegala nhonya ya maganga muisi ya Misili, ");
INSERT INTO vid_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","nhonya ng'hulu ya maganga itowile ng'hatu kweng'ha na chiluli chilutilile, iwele kuduhuli munhu yoneche wa isi ya Misili yayonile kulawila aho mwaluko. ");
INSERT INTO vid_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Nhonya ayo ya maganga na ibenangabenanga chila chinhu kuli migunda na chila honhu muisi ya Misili, migongolo na wanhu. Nhonya ya maganga naibenangabenanga vilyo vyeng'ha na migodi kumgunda. ");
INSERT INTO vid_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Mbuli ayo nayali ikoleche kweng'ha muisi ya Misili, ila honhu ha Gosheni mowekale Waisilaeli, amo mwali mduhuli nhonya ya maganga. ");
INSERT INTO vid_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Lelo Falao nakawalajiza Musa na Aluni wachemigwe, nakawalonjela, “Mhela awu ndita gehile. Mkulu Nguluwi kana hachi, heni na wanhu wa heni tudita vibi. ");
INSERT INTO vid_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Mumlande Mkulu Nguluwi kwa ahyo limlungu ali na nhonya ya maganga vyonjezeka lukami. Heni ndowalekani muche na wala homchikala kahi.” ");
INSERT INTO vid_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Musa nakamlonjela, “Baho du vyondilawa kunze kwa muji ndokwinula moko na kumlanda Mkulu Nguluwi. Limlungu lyoleka na kowa kuduhuli nhonya ya maganga kahi leka uvizele kota isi ayi yeng'ha ndo ya heye Mkulu Nguluwi. ");
INSERT INTO vid_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Ila ndivizela kota hegwe na vitumagwa wa hegwe mng'hali hambe mumdumbe Mkulu Nguluwi.” ");
INSERT INTO vid_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","(Katani na mizuchila ja uhemba jeng'ha najali jiwifigwe, kwa vila uhemba nawali na miso na katani nayali ilavile uluwa. ");
INSERT INTO vid_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Ila uwele na ngano haviwifigwe hebu kwa vila avyo vyangudawila kukangala). ");
INSERT INTO vid_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Lelo Musa nakoka haluga ha Falao, nakalawa kunze kwa muji. Hamba nakenula moko ga heye kumlanda Mkulu Nguluwi. Limlungu na nhonya ya maganga navileka, nhonya naileka kutowa muisi. ");
INSERT INTO vid_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Ila Falao vyoyawene kota nhonya na nhonya ya maganga na limlungu vileka, nakawila kahi kudita gehile ga heye, nayali na nhumbula igagadale, heye hamwe na vitumagwa wa heye. ");
INSERT INTO vid_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Lelo kota Mkulu Nguluwi vyoyalonjile kukolela Musa, Falao nayali na nhumbula igagadale nakalema kuwakundiza Waisilaeli woche. ");
INSERT INTO vid_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Mkulu Nguluwi nakamlonjela Musa, “Ulute kwa Falao. Heni ndiwadita Falao na vitumagwa wa heye wawe na nhumbula zigagadale leka ndite ulajilo awu hali hewo, ");
INSERT INTO vid_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","leka hemwe muwasimile wana wa hemwe na wazukulu wa hemwe, vila vyondiwaditile Wamisili wawe wapoka kwa kudita ulajilo awo hali hewo. Ahyo movizela kota heni nda Mkulu Nguluwi.” ");
INSERT INTO vid_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Lelo Musa na Aluni nawamlutila Falao na kumlonjela, “Mkulu Nguluwi, Nguluwi wa Waebulaniya, kangulonga ahi, ‘Mbaka hanili kolema kinamiza hali heni? Waleche wanhu wa heni woche leka wakafugamile heni. ");
INSERT INTO vid_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Wone kolema kuwalechela wanhu wa heni woche, lelo mitondo ndochigala nzije kuli isi ya hegwe. ");
INSERT INTO vid_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","Isi yeng'ha ya Misili yowa jiza kwa vila nzije azo zogubika isi. Wolya chila chinhu chiponile mli yila nhonya ya maganga, kahi hawoleka choneche mchanya mwa migodi jilingota mmigunda. ");
INSERT INTO vid_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Nzije azo zomema kuli ng'handa ya hegwe na ng'handa za vitumagwa hegwe na ng'handa za Wamisili weng'ha. Nzije zowa nyinji lukami mbaka wasekulu wa hemwe wobubuwala mina hawanazona nzije kota azo kulawila vyowavumbuche mbaka lehano.’ ” Lelo Musa nakalawa kwa Falao. ");
INSERT INTO vid_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Vitumagwa wa Falao nawamuuza, “Ndaze, munhu ayu kotugaza mbaka hanili? Waleche wanhu awa walute wakamfugamile Mkulu Nguluwi, Nguluwi wa hewo. Ndaze, hulingona kota isi ya Misili yanguwifigwa?” ");
INSERT INTO vid_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Aho, Musa na Aluni nawachemigwa wahiluche kwa Falao, na heye nakawalonjela, “Mlute mkamfugamile Mkulu Nguluwi, Nguluwi wa hemwe. Ila ndanguuza, walihi wolutasa hamwe na hemwe?” ");
INSERT INTO vid_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Musa nakamwidichila, “Chila munhu, wasongolo na wasekulu, tokuka na wana wa hetwe walume na wadala, ming'holo na mhene na misenga, mina itulapa tumditile mnvina Mkulu Nguluwi.” ");
INSERT INTO vid_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Kwa kuwabeza, Falao nakawalonjela, “Mkulu Nguluwi yawe hamwe na hemwe kota vyondiwakundiza mlute hamwe na wana wa hemwe. Yangoneka kota mwanacho chinhu chihile mnhumbula za hemwe. ");
INSERT INTO vid_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Hebu! Walume yeka ndo woluta kumfugamila Mkulu Nguluwi, mina alyo ndomliganile.” Aho Musa na Aluni nawawinjigwa kwa Falao. ");
INSERT INTO vid_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Mkulu Nguluwi nakamlonjela Musa, “Ugolole moko wa hegwe kuli isi ya Misili, nzije zilawile leka zinjile na kudakula mizuchila jeng'ha muisi na vyeng'ha viponile kuli yila nhonya ya maganga.” ");
INSERT INTO vid_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Lelo Musa nakagolola ng'hweku ya heye mchanya mwa isi ya Misili. Mkulu Nguluwi nakegala mbeho kulawa kolilawilaga isanya, naiputa mli isi nemisi yeng'ha na nechilo. Lokubunguzuche, yila mbeho naigala nzije. ");
INSERT INTO vid_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Azo nzije nazenela chila honhu kuli isi yeng'ha ya Misili. Nzije azo nazali chilundo chikulu lukami, chiwele hachinalawila na hachilawila kahi. ");
INSERT INTO vid_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Nazigubika isi yeng'ha ya Misili, mbaka isi nayoneka kota iwa jiza. Nazilya mizuchila jeng'ha kuli misanga na mafuza geng'ha gaponile mhela wa yila nhonya ya maganga. Nakwali kuduhu ne ihamba limwe liponile mli migodi ne mizuchila honeche kuli isi yeng'ha ya Misili. ");
INSERT INTO vid_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Aho Falao nakawachema Musa na Aluni himahima nakawalonjela, “Ndita gehile kwa Mkulu Nguluwi, Nguluwi wa hemwe na kwa hemwe. ");
INSERT INTO vid_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Ahyo, sambi ndanguwadedeza mmbusile gehile ga heni, kamwe ayi hela, mkandandile kwa Mkulu Nguluwi, Nguluwi wa hemwe, yambusile igayo ali lihile.” ");
INSERT INTO vid_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Lelo Musa nakoka kwa Falao, nakaluta kumlanda Mkulu Nguluwi. ");
INSERT INTO vid_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Na heye Mkulu Nguluwi, nakegala mbeho ng'hulu iputa kulawila kolizibilaga isanya, naizinula nzije zila na kuzikundujizila kuli Bahali ya Shamu. Na kuduhu ne nzije imwe iponile kuli isi yeng'ha ya Misili. ");
INSERT INTO vid_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Ila Mkulu Nguluwi, nakamdita Falao yawe na nhumbula igagadale, nahawalechele Waisilaeli woche. ");
INSERT INTO vid_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Mkulu Nguluwi nakamlonjela Musa, “Ugolole moko wa hegwe kuchanya kilanga, leka jiza totolo ilawile mli isi ya Misili, jiza totolo iwele munhu yomlapa kwabasa.” ");
INSERT INTO vid_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Lelo Musa nakagolola moko wa heye kuchanya kilanga, nakuwa jiza totolo kuli isi yeng'ha ya Misili kwa mhela wa mazuwa gadatu. ");
INSERT INTO vid_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Wanhu wali hambe wewone ne kuka kuza honhu hanji, nawapona baho howawele kwa mhela wa mazuwa gadatu. Ila Waisilaeli weng'ha nawali na lumuli ako Gosheni nakowali wochikala. ");
INSERT INTO vid_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Hamba Falao nakamchema Musa, nakamlonjela, “Mlute mkamfugamile Mkulu Nguluwi. Wana wa hemwe kahi woweza kuluta hamwe na hemwe. Ila ming'holo na mhene na misenga ja hemwe jipone baha.” ");
INSERT INTO vid_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Ila Musa nakamlonjela, “Yokulapa utukundize kuhola migongolo ja nhambiko na nhambiko za kulakaza leka tukamlavile nhambiko Mkulu Nguluwi, Nguluwi wa hetwe. ");
INSERT INTO vid_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Migongolo ja hetwe kahi yotulapa tujihole, kuduhu igongolo ne limwe lyopona kumbele, kwa vila mli migongolo ja hetwe, tomfugamila Mkulu Nguluwi, Nguluwi wa hetwe, na hatuvizelele ndo igongolo lyachi lyotumlavila Mkulu Nguluwi nhambiko mbaka hotufika ako.” ");
INSERT INTO vid_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Ila Mkulu Nguluwi nakamdita Falao yawe na nhumbula igagadale, nakalema kuwalechela Waisilaeli woche. ");
INSERT INTO vid_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Falao nakamlonjela Musa, “Uche kumeho kwa heni. Wilolele ng'hatu. Uleche kuya kumbona kahi, mina zuwa lyoukuya kahi kumeho kwa heni, kobagama.” ");
INSERT INTO vid_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Musa na heye nakamlonjela, “Kota vyoulonjile sikuya kukona kahi.” ");
INSERT INTO vid_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Mkulu Nguluwi nakamlonjela Musa, “Kung'hali igayo limwe lyondimgalila Falao na isi ya Misili. Hamba kuwalechelani muche hano. Kahi hoyowalechelani muche, yuye kowawinga muche ng'hatu hano. ");
INSERT INTO vid_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Uwalonjele Waisilaeli sambi wahuliche kota chila yumwe wa hewo, mdala kwa mlume, kanguganigwa kumlanda miyage yowalingikalasa habehi, vinhu vya sendi na zahabu.” ");
INSERT INTO vid_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","Mkulu Nguluwi nakawadita Wamisili wanojezwe hali Waisilaeli. Kahi Musa yuye nakawa munhu mkulu ng'hatu kuli isi ya Misili na hali vitumagwa wa Falao. ");
INSERT INTO vid_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Musa nakamlonjela Falao, “Mkulu Nguluwi kangulonga ahi, ‘Nechilo ng'hatu lehano, ndokolela hagati ha isi ya Misili. ");
INSERT INTO vid_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","Hondikola chila mlelwa mlume wa mwaluko muisi ya Misili kobagama, kwaluchila mlelwa wa mwaluko wa Falao, yawele ndo yalingikala kuli chigoda cha undewa mbaka mlelwa wa mwaluko wa mpogozi mdala wa hegwe yalingubalasa nyhule kwa iganga lya lwala. Na mbaka walelwa wa mwaluko wa migongolo jilingudimigwa najo jeng'ha jobagama. ");
INSERT INTO vid_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Kowa na chililo chikulu kweng'ha muisi ya Misili, chililo chowa hachinalawila na hachilawila kahi. ");
INSERT INTO vid_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Ila kowa goya na tulu ng'hatu kuli Waisilaeli na migongolo ja hewo, leka uvizele kota heni Mkulu Nguluwi ndivizela kubagula hali Waisilaeli na Wamisili.’ ” ");
INSERT INTO vid_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Musa nakasinda kwa kumlonjela Falao, “Vitumagwa wa hegwe awano wombuyila na kinamizila heni, wolonga kota mbuche muisi ya Misili, heni hamwe na wanhu weng'ha walingumbinza. Logopuluta ago, ndokuka.” Hamba Musa aku yawele yazudile, nakoka kwa Falao. ");
INSERT INTO vid_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Mkulu Nguluwi nakamlonjela Musa, “Falao hokuhulichiza, leka vinduzanduza vya heni vyonjezeche muisi ya Misili.” ");
INSERT INTO vid_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Lelo Musa na Aluni nawadita vinduzanduza avyo vyeng'ha hali Falao. Ila Mkulu Nguluwi nakamdita Falao yawe na nhumbula igagadale, nakalema kuwakundiza Waisilaeli woche muisi ya heye. ");
INSERT INTO vid_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Mkulu Nguluwi nakawalonjela Musa na Aluni, nalowali wang'hali muisi ya Misili, ");
INSERT INTO vid_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“Mwezi awu wowa mwezi wa mwaluko wa mwaka kwa hemwe. ");
INSERT INTO vid_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Mlonje na Waisilaeli weng'ha, mkawalonjele kota zuwa lya kumi lya mwezi awu chila munhu kohola ing'holo lyana limwe kwa chila ng'handa imwe. ");
INSERT INTO vid_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Wone iwe wanhu wa ng'handa imwe wawe wachefu kwa ing'holo lyana, lelo wochitanza na walingikalasa habehi na ng'handa ya hewo, hamba wahole igongolo limwe lya kuhega kulya hewo weng'ha. ");
INSERT INTO vid_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Ing'holo lyana alyo liwe lilihela nongwa, liwe ilume lya mwaka umwe. Lyoweza kuwa ing'holo lyana ama chinyehe chiwele na mwaka umwe. ");
INSERT INTO vid_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Namwe moliwika igongolo alyo mbaka zuwa lya kumi na zine lya mwezi uno. Zuwa alyo Waisilaeli weng'ha wojidumula singo migongolo ajo mhela wa kuzinga kwa isanya. ");
INSERT INTO vid_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Hamba wohola danda ya migongolo ajo na kuibakaliza kuli chibatilila lwizi na kuli mhajilo za kuchanya, kuli zila ng'handa zomudila migongolo ajo. ");
INSERT INTO vid_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Wolya miwunde ajo nechilo yiyo loibanichigwe mchiluli, wolya hamwe na ibumunda lyohaliwichigwe usaso kahi hamwe na chiboga chiwele na usungu. ");
INSERT INTO vid_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Mleche kulya ndodi ama ihemswe kwa mazi, ila isomigwe yeka mchiluli hamwe na mutwi na magulu na miwunde jake ja mgati. ");
INSERT INTO vid_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Kahi mleche kuleka usanyango woneche mbaka mitondo, ila chila chisigale mbaka mitondo mochisoma kwa chiluli. ");
INSERT INTO vid_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Na ahi ndo vyomuzangulya igongolo alyo. Mowa muwohigwe vyuno vya hemwe kwa misali na mvalile makwamba mmagulu na mibate ng'hweku za hemwe mmoko mwa hemwe, kiwika goya kwa kwinula majendo. Kahi molya kwa kukobanya. Na ayo ndo Pasaka ya Mkulu Nguluwi. ");
INSERT INTO vid_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","“Mina nechilo yiyo ndokola hagati ha isi ya Misili na kuwakopola walelwa wa mwaluko wa isi ya Misili na wanhu na migongolo. Ndojitagusa milungu jeng'ha ja Misili. Heni ndo Mkulu Nguluwi. ");
INSERT INTO vid_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Na yila danda yowa ulajilo kwa hemwe kuli zila ng'handa zomuwa mgati. Nani hondikona yila danda, ndokola na igayo halifika hebu, hala hondiwa ndiitowa isi ya Misili. ");
INSERT INTO vid_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","Zuwa lino lyowa lya kukumbuchila kwa hemwe, moidita iwe mnvina kwa Mkulu Nguluwi kwa ivyazi lya hemwe lyeng'ha kota ilajizo lya mazuwa gose kwa hemwe.” ");
INSERT INTO vid_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","Mkulu Nguluwi nakalonga, “Molya mibumunda johajiwichigwe usaso kwa mhela wa mazuwa saba na zuwa lya mwaluko lya mazuwa ago saba, mokusa usaso kuli ng'handa za hemwe. Munhu yoneche yolya chinhu chiwichigwe usaso kuli mhela wa mazuwa saba, imgana kubaguligwa hali Waisilaeli. ");
INSERT INTO vid_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Zuwa lya mwaluko na zuwa lya kuduma kuli mazuwa ago saba, mowa na nhing'hano yelile. Kuli mazuwa ago meli hamkundizwa kukola mijito yoneche ila ndo mijito ja kuwika goya chilyo. ");
INSERT INTO vid_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","Moidita mnvina ayo ya mibumunda johajiwichigwe usaso kota kukumbuchila kuli zuwa lila lyondiwalavile hemwe, vilundo vya Waisilaeli kulawa isi ya Misili. Mvina ayo yoditikwa zuwa lino na lulelo lwa hemwe lweng'ha lulinguya, kota ilajizo lya mazuwa gose. ");
INSERT INTO vid_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Lelo molya mibumunda johajiwichigwe usaso kwaluchila matinazo ya zuwa lya kumi na zine lya mwezi wa mwaluko, mbaka mhela wa kuzinga kwa isanya wa zuwa lya makumi meli na imwe. ");
INSERT INTO vid_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","Mhela wa mazuwa saba kuleche koneka usaso mli ng'handa za hemwe. Munhu yoneche yula yawe mjenzi ama mwenyeng'haye wone yolya acho chiwichigwe usaso, munhu ayo kobaguligwa hali Waisilaeli weng'ha. ");
INSERT INTO vid_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Mleche kulya chinhu choneche chiwichigwe usaso. Honeche hala homchikala, molya mibumunda johajiwichigwe usaso.” ");
INSERT INTO vid_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Aho ndo Musa nakawachema wasekulu weng'ha wa Isilaeli na kuwalonjela, “Chila yumwe wa hemwe kwa winji wa ivyazi lyake, yahagule ing'holo lyana yalidumule singo kwa mbuli ya mnvina ya Pasaka. ");
INSERT INTO vid_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Mohola nhagala za isopolo na kuwika mli danda mgati mwa chisaye na kubakaliza mli vibatilila lwizi za ng'handa za hemwe. Munhu yoneche yaleche kulawa kunze mwa ng'handa nechilo ayo ila mbaka mitondo. ");
INSERT INTO vid_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Mina heye Mkulu Nguluwi kokola kuno yowakopola Wamisili. Ila hoyokona danda ibakalizwe mli vibatilila lwizi vya ng'handa za hemwe, kokola na homkundiza hebu yalingukopola yenjile kuli ng'handa za hemwe kuwakopola. ");
INSERT INTO vid_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","Namwe mowika mbuli ayi kuwa kota ilajizo kwa hemwe na kwa wana wa hemwe mazuwa gose. ");
INSERT INTO vid_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Yowa ahyo homkwinjila isi ayo, Mkulu Nguluwi yowapani kota navyoyelahile, ndo modita mnvina ayi. ");
INSERT INTO vid_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Hamba wana wa hemwe howowauza, ‘Mbuli ayi yangutulangusa choni?’ ");
INSERT INTO vid_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","Hemwe mowedichila, ‘Ayi ndo nhambiko ya Pasaka kwa Mkulu Nguluwi, kwa vila nakazikola ng'handa za Waisilaeli naloyawagazile Wamisili, ila hetwe nahatugazile.’ ” Hamba, Waisilaeli nawenamiza vitwi na kumfugamila Mkulu Nguluwi. ");
INSERT INTO vid_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Hamba, Waisilaeli nawaluta na kudita kota navyowalonjelwe na Musa na Aluni kwa kuwinza mzilo woyawapele Mkulu Nguluwi. ");
INSERT INTO vid_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Nechilo ng'hatu, Mkulu Nguluwi nakawakopola walelwa wa mwaluko weng'ha wa Misili. Weng'ha nawabagama, kulawila mlelwa wa mwaluko wa Falao yawelengikala kuli chigoda cha undewa mbaka mlelwa wa mwaluko na wawele mchinweng'ho na walelwa wa mwaluko wa migongolo najibagama. ");
INSERT INTO vid_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Lelo nechilo yila Falao na vitumagwa wa heye na wenyeng'haye wa heye nawenuka. Nakwali na chililo chikulu kweng'ha kuli isi ya Misili, mina nakwali kuduhu ng'handa ne imwe isowile munhu yabagame. ");
INSERT INTO vid_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Aho Falao nakawachema Musa na Aluni nechilo yiyo, nakawalonjela, “Mwinuche! Muche hali wanhu wa heni. Mlute hemwe na awo Waisilaeli mkamfugamile Mkulu Nguluwi kota vyomlonjile. ");
INSERT INTO vid_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Mhole vilundo vya ming'holo na mhene na migongolo, muche, mndandile na heni utambichizo.” ");
INSERT INTO vid_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Wamisili nawawahimiliza Waisilaeli woche himahima, wolonga, “Ndakomya tobagama weng'ha!” ");
INSERT INTO vid_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Wanhu nawahola utimbo wa hewo wa mibumunda jing'hali wichigwa usaso na visaye vya kufinanjila nawavijela mgati mwa nguwo za hewo na kupika mmayega. ");
INSERT INTO vid_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Waisilaeli nawadita kota ula ulonzi wa Musa, nawawalanda Wamisili vinhu vya sendi na zahabu na nguwo. ");
INSERT INTO vid_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","Mkulu Nguluwi nakawadita Wamisili wakunde kuwapa Waisilaeli vinhu vyeng'ha navyowalandile. Ahyo ndo vyowaholile lufufu lwa Wamisili. ");
INSERT INTO vid_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Waisilaeli nawoka kuli muji wa Lamesesi, nawenula majendo kwa magulu kuza Sukoti. Nawali walume wafichile lachi sita ne kuwaza wana na wadala. ");
INSERT INTO vid_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Nakwali kahi na chilundo cha wanhu wanji nawehanza hamwe na kuza hamwe na ming'holo na misenga na mhene minji lukami. ");
INSERT INTO vid_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Na hewo nawadita mibumunda johajiwichigwe usaso ja ula utimbo wauholile nalowalawile Misili, mina, nahauwichigwe usaso, kwa vila nawawinjigwa woche Misili, waleche kukawila, na hewo nawali wang'hali kiwichila goya chilyo cha mmajendo. ");
INSERT INTO vid_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Waisilaeli nawali wekale Misili kwa miyaka miya zine na makumi gadatu. ");
INSERT INTO vid_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","Kuli zuwa lya kuduma lya miyaka miya zine na makumi gadatu, zuwa lilyo ndo vilundo vyeng'ha vya wanhu wa Mkulu Nguluwi navyuka muisi ya Misili. ");
INSERT INTO vid_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Nechilo yiyo Mkulu Nguluwi nakawemilila leka yawose Waisilaeli muisi ya Misili. Ahyo, nechilo yila ya kuwemilila, yanguganigwa kukumbuchilwa na Waisilaeli weng'ha na lulelo lwao lweng'ha, kwa katogo ka Mkulu Nguluwi. ");
INSERT INTO vid_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","Mkulu Nguluwi nakawalonjela Musa na Aluni, “Aga ndo malajizo kwa mbuli ya mnvina ya Pasaka. Mjenzi yoneche yaleche kulya chilyo cha Pasaka. ");
INSERT INTO vid_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","Ila mpogozi yaguligwe kwa sendi, loyowa yenjile ikumbi, kokundizwa kulya. ");
INSERT INTO vid_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","Mjenzi yoneche yawele mmajendo ama yawelengukola mijito ya kupegwa sendi halingukundizwa kulya chilyo acho. ");
INSERT INTO vid_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","Ing'holo lyana lya Pasaka lyoligwa kuli ng'handa imwe. Hamlinguganigwa kulavya miwunde joneche kunze na ng'handa yoyadumuligwe singo ne kumbena chizeje cha ing'holo lyana lya Pasaka. ");
INSERT INTO vid_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Waisilaeli weng'ha wadite mnvina ayo. ");
INSERT INTO vid_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","Mjenzi yoneche yalingikala hamwe na hemwe wone yogana kumditila Mkulu Nguluwi mnvina ya Pasaka, yomlapa tandi walume wa ng'handa ya heye wenjile ikumbi, aho kowazigwa kuwa kota mwenyeng'haye na kukundigwa kihanza. Mlume yoneche yohambe yenjile ikumbi, yaleche kulya chilyo cha mnvina ayo ya Pasaka. ");
INSERT INTO vid_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Malajizo gagala gomkundiza mwenyeng'haye Muisilaeli na wajenzi walingikala hali hemwe”. ");
INSERT INTO vid_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Waisilaeli weng'ha nawebatilila malajizo ago na kudita kota Mkulu Nguluwi navyoyawalajize Musa na Aluni. ");
INSERT INTO vid_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","Zuwa lilyo Mkulu Nguluwi nakawalavya Waisilaeli kuli isi ya Misili kwa vilundo. ");
INSERT INTO vid_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Mkulu Nguluwi nakamlonjela Musa, ");
INSERT INTO vid_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","“Nyhagulile walelwa weng'ha wa mwaluko walume wa Waisilaeli wawe wa heni, na chila yaleleche mwaluko kwa migongolo ndo wa heni.” ");
INSERT INTO vid_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Musa nakawalonjela wanhu, “Mkumbuche zuwa ali lyomlawile Misili nakomuwele wapogozi. Ali ndo zuwa Mkulu Nguluwi lyoyawalavile amo kwa moko wa heye uwele na mong'ho. Kuli zuwa ali, mleche kulya mibumunda jiwele na usaso ne hado. ");
INSERT INTO vid_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Zuwa ali, mwezi wa mwaluko wa Abibu, molawa muisi ya Misili. ");
INSERT INTO vid_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","Na mhela Mkulu Nguluwi yowahilikani mbaka kuli isi ya Wakanaani na Wahiti na Waamoli na Wahivi na Wayebusi, isi yoyawelahile wasekulu wa hemwe kota kowapa hemwe, isi iwele na mboto, yowalapa mdite mnvina kuli zuwa ali chila mhela kuli mwezi wa mwaluko. ");
INSERT INTO vid_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","Kwa mhela wa mazuwa saba molya mibumunda johajiwichigwe usaso na kuli zuwa lya saba modita mnvina ya katogo kwa Mkulu Nguluwi. ");
INSERT INTO vid_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Kwa mhela awo wa mazuwa saba, molya mibumunda johajiwichigwe usaso. Kuleche kuwa na mibumunda jiwichigwe usaso na usaso woneche ula hali hemwe na kuli isi ya hemwe yeng'ha. ");
INSERT INTO vid_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","Zuwa alyo mowalonjela wana wa hemwe kota mwangudita ahyo kwa chiwalo cha mbuli yawaditile Mkulu Nguluwi lomuchile muisi ya Misili. ");
INSERT INTO vid_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","Mnvina ayo yowa ya kukumbuchila kota ulajilo kuli moko ga hemwe ama kuli vihanga vya hemwe, leka iwakumbuse kulonga malajizo ga Mkulu Nguluwi. Mina, Mkulu Nguluwi kawalavya kuli isi ya Misili kwa moko uwele na mong'ho. ");
INSERT INTO vid_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Ahyo mobatilila ilajizo ali kwa kudita mnvina ayi kwa mhela uwichigwe chila mhela.” ");
INSERT INTO vid_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","Musa nakalutilila kuwalonjela wanhu, “Yowa aho kahi hala Mkulu Nguluwi hoyowegala hemwe kuli isi ya Wakanaani, iwele kowapa kota navyoyawalahile hemwe na wasekulu wa hemwe, ");
INSERT INTO vid_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","ahyo komlavila Mkulu Nguluwi chila mlelwa wa mwaluko mlume. Na chila mlelwa wa mwaluko mlume wa igongolo, wowa ndo wa Mkulu Nguluwi. ");
INSERT INTO vid_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Chila mlelwa wa mwaluko wa idogowi, komgombola kwa kulavya ing'holo lyana na wone ulema kumgombola komkopola kwa kumpobosola singo. Na chila mlelwa wa mwaluko wa munhu kuli wanago komgombola. ");
INSERT INTO vid_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","Wone hamba mwanago hoyokuuza chiwalo cha mbuli ayi, komlonjela, ‘Kwa mong'ho wa moko wa heye, Mkulu Nguluwi nakatulavya Misili, kotuwele wapogozi. ");
INSERT INTO vid_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Lelo Falao navyoyawele na nhumbula igagadale nakalema kutulechela tuche, Mkulu Nguluwi nakawakopola walelwa weng'ha wa mwaluko nawawele Misili, yawele munhu ama igongolo. Kwa chiwalo acho, ndangumlavila Mkulu Nguluwi chila mlelwa wa mwaluko, wawe walume ila walelwa wa mwaluko weng'ha wawele wana wa heni, ndanguwagombola.’ ");
INSERT INTO vid_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Mbuli ayo yowa ndo ya kukumbuchila kota vila chinhu chiwopigwe mmoko mwako na mchihanga cha hegwe, kwa vila Mkulu Nguluwi nakatulavya Misili kwa moko wa heye uwele na mong'ho.” ");
INSERT INTO vid_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Falao naloyawalechele wanhu awo walute, Nguluwi nahawalongoze kuli nzila ya isi ya Wafilisti, hanga nayali habehi. Mina Nguluwi nakalonga kota waleche kugozola aho wanhu awa lowoting'hana na ngondo na kuhiluka Misili. ");
INSERT INTO vid_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Ila Nguluwi nakawazungulusa awo wanhu kwa nzila ya kuchiwala hafungofungo mwa Bahali ya Shamu. Waisilaeli nawakwina kulawila kuli isi ya Misili wawele goya kitowa ngondo. ");
INSERT INTO vid_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Musa nakajihola jila mizeje ja Yusufu hamwe na heye, mina Yusufu nakawadita Waisilaeli welahe yolonga kota Nguluwi hoyokuya kuwatanza hemwe kuli isi ya Misili, namwe mohola mizeje ja heni kulawila hali hemwe. ");
INSERT INTO vid_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Nawo nawenula majendo kulawila Sukoti nawawika kambi ako Etamu kuwele mbaka ya hala kuchiwala. ");
INSERT INTO vid_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Mkulu Nguluwi na heye nakawalongola nemisi mgati mwa ng'hungugu iwhanile na izengo leka iwalongoze nzila, na nechilo mgati mwa chiluli chiwhanile na izengo, leka kuwalangazila, wawe wojenda nemisi na nechilo. ");
INSERT INTO vid_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Lila izengo lya ng'hungugu nahalyuchile nemisi ne lila izengo lya chiluli nahalyuchile nechilo, kumwando kwa awo wanhu. ");
INSERT INTO vid_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Mkulu Nguluwi nakalonga na Musa, nakamlonjela, ");
INSERT INTO vid_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","“Walonjela Waisilaeli, wahiluche na kuwika kambi ya hewo kumwando kwa Pi-hahiloti, hagati mwa muji wa Migidoli na bahali, mlola Baali-sefoni, mochiwika goya kumwando kwake behi na Bahali ya Shamu. ");
INSERT INTO vid_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Na heye Falao kolonga mbuli ya Waisilaeli kota walemezwa kuli isi yila, na kula kuchiwala kuwalemeza waleche kulawa. ");
INSERT INTO vid_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Nani ndoidita nhumbula ya Falao iwe igagadale, na heye kowawinza kumbele, nani ndobochela ukulu ng'hatu kwa kumbagamiza heye Falao na wamizi wa heye weng'ha na Wamisili wovizela kota heni ndo Mkulu Nguluwi.” Lelo nawadita ahyo. ");
INSERT INTO vid_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Falao nakalonjelwa kota wala Waisilaeli mina wabilima, na nhumbula ya Falao na nhumbula za vitumagwa wa heye nazigaluswa, “Ndo choni chotuditile kwa kuwalechela wanhu awa walute na waleche kuwa wapogozi wa hetwe kahi?” ");
INSERT INTO vid_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Nakawika goya mutuka ya heye ya kukwejigwa na falasi, na kawahola wanhu wa heye hamwe na heye, ");
INSERT INTO vid_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","kahi nakahola mituka ja heye jiwele goya miya sita na mituka jinji jeng'ha ja Wamisili na walolezi wakwine mchanya mwa mituka ajo zeng'ha. ");
INSERT INTO vid_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Mkulu Nguluwi nakaidita nhumbula ya Falao iwe igagadale, na heye nakawawinza Waisilaeli, kwa vila Waisilaeli nawoka kwa nhumbula zikangale. ");
INSERT INTO vid_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Wamisili nawawinza kumbele kwa hewo, falasi zeng'ha na mituka jeng'ha ja Falao na wamizi weng'ha wakwinile falasi na chilundo cha wamizi, nawo nawawafika Waisilaeli wawele wawichile kambi hala behi na bahali, behi na Pi-hahiloti, wochilola na Baali-sefoni. ");
INSERT INTO vid_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Falao loyawele yowahejelela, Waisilaeli lowahinduche kumbele na kuwona Wamisili wokuya, nawadumba heko, Waisilaeli nawamlilila Mkulu Nguluwi. ");
INSERT INTO vid_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Nawamlonjela Musa, “Ndaze, kwa vila nakwali kuduhu vilaga Misili ndo kutulavya ako leka tubagame aku kuchiwala? Lekachoni kutuditila aga, kwa kutulavya kuli isi ya Misili? ");
INSERT INTO vid_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Ulonzi awu ndo hauwele ula wotukulonjele akula Misili, natulonga kota utuleche tuwe wapogozi wa Wamisili? Mina fola kuwa wapogozi kwa Wamisili kusinda kubagama aku kuchiwala.” ");
INSERT INTO vid_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Musa nakawedichila, nakawalonjela, “Mleche kudumba! Mwime nzinzili mlole ulohozi wa Mkulu Nguluwi woyowaditila lehano, mina Wamisili awa mlinguwona lehano, hamuwona kahi mazuwa gose. ");
INSERT INTO vid_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Mkulu Nguluwi kowa hamwe na hemwe na kowatowanila, hemwe mwanguganigwa kunyamalila tulu.” ");
INSERT INTO vid_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Mkulu Nguluwi nakamlonjela Musa, “Lekachoni kwangundilila heni? Walonjele Waisilaeli walutilile kuza kumwando. ");
INSERT INTO vid_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Nagwe winule ng'hweku ya hegwe na ugolole moko wa hegwe mchanya mwa bahali na kuigawanula, nawo Waisilaeli wokola hagati mwa bahali kuli isi isowile mazi. ");
INSERT INTO vid_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Nani ulole, ndozidita nhumbula za Wamisili ziwe zigagadale, nawo wokwinjila na kuwawinza, nani ndobochela ukulu kwa kumbagamiza Falao na chilundo cheng'ha cha wamizi wa heye na wakwina falasi na wakwina mituka weng'ha. ");
INSERT INTO vid_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Na wanhu wa isi ya Misili wonzela kota heni nda Mkulu Nguluwi, hondichiholela ukulu kwa Falao na mituka ja heye na wakwina falasi wa heye.” ");
INSERT INTO vid_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Hamba mhilisi wa Nguluwi nayalongole kumwando kwa chilundo cha walolezi wa Isilaeli, nakoka nakaluta kumbele kwa hewo na lila izengo lya ng'hungugu nalyuka aho kumwando nalima kumbele kwa hewo, ");
INSERT INTO vid_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","nalima hagati mwa chilundo cha walolezi wa Misili na wamizi wa Isilaeli, na yila ng'hungugu nailavya jiza ubanzi umwe nalilavya lumuli ubanzi uyage mhela wa nechilo, Wamisili nahawahejelele ne hado nechilo yeng'ha. ");
INSERT INTO vid_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Musa nakagolola moko wa heye mchanya mwa bahali, Mkulu Nguluwi nakaidita bahali ihiluche kumbele kwa mbeho ng'hulu ilingulawa kolilawilaga isanya nechilo yeng'ha, nakaidita bahali iwe isi isowile mazi, mazi nagagawanuka. ");
INSERT INTO vid_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","Waisilaeli nawakola hagati ha bahali hali isi isowile mazi, aku mazi gawele lukanzi kwa hewo ubanzi wa kumoso na kudilo. ");
INSERT INTO vid_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Na wala Wamisili nawawawinza, nawenjila mgati kuli bahali, falasi zeng'ha za Falao na mituka ja heye na wakwina falasi wa heye. ");
INSERT INTO vid_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Na vyoiwele lufuku, Mkulu Nguluwi nakawalola walolezi wa Misili kuli lila izengo lya chiluli na ya ng'hungugu na nakachidita chilundo cha walolezi wa Wamisili chiwe na lunhwinhwi lukami. ");
INSERT INTO vid_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","Nakagananahiza maguludumu ga mituka ja hewo mbaka jali jijenda mholemhole, Wamisili nawalonga, “Tuwabilime Waisilaeli, mina Mkulu Nguluwi kanguwatanza.” ");
INSERT INTO vid_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Hamba Mkulu Nguluwi nakamlonjela Musa, “Ugolole moko wa hegwe mchanya mwa bahali, leka mazi gahiluche kahi gawagubiche Wamisili na mituka ja hewo na falasi wa hewo.” ");
INSERT INTO vid_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Musa nakaugolola moko wa heye mchanya mwa bahali, nalokubwemwenzuche, bahali naihiluka kota vyoiwele hamwande, Wamisili nawajeza kugabilima mazi, ila Mkulu Nguluwi nakawadumya awo Wamisili mli bahali. ");
INSERT INTO vid_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Gala mazi nagahiluka na kugubika mituka na wakwina falasi na chilundo cheng'ha cha wamizi cha Falao chinjile kuli bahali kumbele kwa hewo. Nahakuponile munhu ne yumwe. ");
INSERT INTO vid_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Ila Waisilaeli nawaluta kuli isi isowile mazi hagati ha bahali na ago mazi nagali kota lukanzi ubanzi wa hewo wa kudilo na ubanzi wa kumoso. ");
INSERT INTO vid_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Ndo Mkulu Nguluwi navyoyawalohole Waisilaeli zuwa lila mmoko mwa Wamisili. Waisilaeli nawawona Wamisili wabagame mfungo mwa bahali. ");
INSERT INTO vid_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Waisilaeli nawalona lula ludali lukulu lwa Mkulu Nguluwi kwa Wamisili, ahyo awo wanhu nawamdumba na kumkunda Mkulu Nguluwi na Musa chitumagwa wa heye. ");
INSERT INTO vid_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Hamba Musa na Waisilaeli nawamwimbila Mkulu Nguluwi lwimbo alu aku wolonga, “Ndomwimbila Mkulu Nguluwi, kwa vila nakenuligwa kwa katogo, falasi na wakwina falasi nakawatoza mbahali. ");
INSERT INTO vid_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","Mkulu Nguluwi ndo mong'ho na chiwalo cha lwimbo lwangu, heye ndo ulohozi wa heni. Heye ndo Nguluwi wa heni, nani ndomtogola. Ndo Nguluwi wa mhaza wa heni, nani ndomha ukulu. ");
INSERT INTO vid_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","Mkulu Nguluwi ka mtowa ngondo, Mkulu Nguluwi ndo itagwa lyake. ");
INSERT INTO vid_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","“Mituka ja Falao na wamizi wa heye nakawatoza mbahali, vilongozi wa heye wanojile kusinda weng'ha, nawazibila mli Bahali ya Shamu. ");
INSERT INTO vid_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Bahali iwele na mazi nyang'ha iwagubichiza, nawazibila mbaka hasi mwa bahali kota maganga. ");
INSERT INTO vid_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","Mkulu Nguluwi, moko wa hegwe wa kudilo uwa na mong'ho, uwabenanga wang'honyo mvihande vidodo. ");
INSERT INTO vid_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","Kwa ukulu wa hegwe, kuwagwisa walingukulema, kuzudila kwa hegwe kwangupulika na kuwalakaza kota mibeleje jikalile. ");
INSERT INTO vid_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Kwa muhe wa hegwe, mazi nagakwinizwa, nhigu nayima ngwalinga ifandile kota chidunda, Mazi nyang'ha nagebatana kota lukanzi hagati mwa bahali. ");
INSERT INTO vid_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","Mng'honyo nakalonga, ‘Ndowawinza na ndowapata, ndowagawila lufufu lwa hewo na kuhola geng'ha gondilingugana, ndohola ipanga lya heni na moko wa heni wowasumya.’ ");
INSERT INTO vid_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Nakuputa kwa mbeho ya hegwe, bahali naiwagubichiza. Nawazibila kota iganga mgati mwa mazi gawele na mleta. ");
INSERT INTO vid_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","“Gwaa Mkulu Nguluwi, yalikohi yawele kota hegwe kuli milungu? Yalikohi yawele kota hegwe yawele yelile mkulu, ulingudumbiza kwa madito makulu, ulingudita mbuli za kububuwaza? ");
INSERT INTO vid_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Nakugolola moko wa hegwe wa kudilo uwele na mong'ho na isi naiwamela Wamisili weng'ha. ");
INSERT INTO vid_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","“Gwegwe kwa igano lya hegwe lya kwimilila, nakuwalongoza wanhu wouwagombole, kwa mong'ho wa hegwe nakuwalongoza mbaka koulingikala helile. ");
INSERT INTO vid_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Wanhu wa isi zeng'ha wagahulika ago nawakakama, wenyeng'haye wa Ufilisti wenjililwa na chinhu cha kudumbiza chiwagalile usungu. ");
INSERT INTO vid_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Vilongozi wa Edomu nawadumba ng'hatu, wanhu wa Moabu wangukakama, wanhu walingikala Kanaani, nawagozola. ");
INSERT INTO vid_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Kudumba na kukakama kuwagwila, kwa chiwalo cha ukulu wa ludali lwako, hewo wanyamalila tulu kota iganga, mbaka howoloka wanhu wa hegwe Mkulu Nguluwi, ena, mbaka howoloka wanhu wa hegwe wouwagombole. ");
INSERT INTO vid_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Nakuwegala na kuwemiza kuli chidunda cha hegwe, honhu hala nahouditile ha kikala gwegwe baho Mkulu Nguluwi, hala honhu helile uhawichile goya, Mkulu kwa moko ga hegwe. ");
INSERT INTO vid_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","Hegwe, gwa Mkulu Nguluwi, hegwe ndo mndewa mazuwa gose na mazuwa gose.” ");
INSERT INTO vid_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Mina falasi wa Falao na mituka ja heye na wakwina falasi wa heye nawenjila mgati mwa bahali, Mkulu Nguluwi nakagahilusa mazi ga bahali gawagubiche, ila Waisilaeli nawakola kuli isi isowile mazi hagati mwa bahali. ");
INSERT INTO vid_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Miliamu mdala mloli, nayawele lumbu wa Aluni nakahola kagoma kake mmoko, na wadala wanji weng'ha nawamuwinza wawele na vigoma vya hewo aku wovina. ");
INSERT INTO vid_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Miliamu nakawalongoza kwa kwimba, “Mmwimbile Mkulu Nguluwi kwa vila kasumya kwa katogo, falasi na wakwina falasi kawatoza mbahali.” ");
INSERT INTO vid_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Hamba, Musa nakawalongoza Waisilaeli kulawila kuli Bahali ya Shamu na kuza mbaka kuchiwala kwa Shuli. Nawenula majendo kwa mhela wa mazuwa gadatu kuchiwala ne kona mazi goneche. ");
INSERT INTO vid_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Lowafichile honhu halinguchemigwa Mala, hawajezile kunwa mazi ga Mala kwa vila nagali na usungu. Kwa chiwalo acho, honhu aho nahachemigwa Mala. ");
INSERT INTO vid_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Lelo wanhu weng'ha nawamng'ung'utila Musa wolonga, “Lelo tonwa choni?” ");
INSERT INTO vid_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Aho Musa nakamlilila Mkulu Nguluwi, na heye nakamlajila nhagala ya igodi, na Musa nakazwika mli mazi ago na baho mazi ago nagawa ganojile. Ako Nguluwi nakawapa Waisilaeli ilajizo na mzilo, leka yawajeze hewo, ");
INSERT INTO vid_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","nakawalonjela, “Wone molihulichiza goya lizi lya heni Mkulu Nguluwi, Nguluwi wa hemwe, na kudita gawele goya kwa heni, na kibatilila mzilo na malajizo ga heni geng'ha, lelo heni siwagalila gala matamwa gondiwegalile Wamisili. Kwa vila, heni ndo Mkulu Nguluwi ndilinguwosela hemwe matamwa.” ");
INSERT INTO vid_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Hamba Waisilaeli nawafika ako Elimu kuwele na nzasa kumi na mbili na mitende makumi saba. Nawawika kambi ako behi na mazi. ");
INSERT INTO vid_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Waisilaeli weng'ha nawoka, nawafika kuchiwala nakuchemigwe Sini hagati mwa Elimu na Sinai. Ali nalyali zuwa lya kumi na kahano lya mwezi wa keli kulawila nalowochile muisi ya Misili. ");
INSERT INTO vid_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Lelo Waisilaeli weng'ha nawawang'ung'utila Musa na Aluni ako kuchiwala, ");
INSERT INTO vid_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","Waisilaeli weng'ha nawalonga, “Fola Mkulu Nguluwi nahatukopole nalotuwele muisi ya Misili nakotikale, nakotudile miwunde na mibumunda mbaka natiguta. Ila hemwe mtugala aku kuchiwala kuikopola nhanzi ayi yeng'ha kwa nzala.” ");
INSERT INTO vid_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Hamba Mkulu Nguluwi nakamlonjela Musa, “Heni ndowadulisila mibumunda kulawila kilanga. Chila zuwa wanhu wolawa na kukungajiza chilyo cha zuwa alyo hela. Kwa nzila ayi ndowajeza ndole kota wowinza malajizo ga heni ama hawowinza hebu. ");
INSERT INTO vid_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Ila zuwa lya sita mhela howowika goya chilyo chowakungajize, chasi acho chowa mala keli ya chilyo cha chila zuwa.” ");
INSERT INTO vid_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Lelo Musa na Aluni nawawalonjela wanhu weng'ha wa Isilaeli, “Mhela wa kuzinga kwa isanya, movizela kota Mkulu Nguluwi ndo yawalavile muisi ya Misili. ");
INSERT INTO vid_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","Kahi, mitondo lufuku, mowona ukulu wa Mkulu Nguluwi kwa vila kagahulika gomwali mng'ung'uta. Hetwe twa whaani mbaka mtung'ung'utile?” ");
INSERT INTO vid_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Kahi Musa nakalonga, “Mhela wa kuzinga kwa isanya Mkulu Nguluwi kowegalila miwunde mulye na mitondo lufuku kowegalila mibumunda mulye migute, mina heye nakahulika vila navyomwali mumng'ung'utila. Hetwe twa whaani mbaka mtung'ung'utile? Hambe mtung'ung'utile hetwe, ila mwangumng'ung'utila Mkulu Nguluwi.” ");
INSERT INTO vid_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Hamba Musa nakamlonjela Aluni, “Walonjele Waisilaeli weng'ha wekungajize hamwe kumwando kwa Mkulu Nguluwi, mina kagahulika gomwali mgang'ung'utila.” ");
INSERT INTO vid_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Mhela Aluni loyali yolonga na Waisilaeli weng'ha, nawalola ako kuchiwala na baho ukulu wa Mkulu Nguluwi nawoneka kuli ng'hungugu. ");
INSERT INTO vid_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Mkulu Nguluwi nakamlonjela Musa, ");
INSERT INTO vid_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","“Nyhulika kung'ung'uta kwa Waisilaeli. Lelo walonjela kota mhela wa kuzinga kwa isanya wolya miwunde, na mitondo wolya mibumunda. Aho ndo vyomvizela kota heni ndo Mkulu Nguluwi, Nguluwi wa hemwe.” ");
INSERT INTO vid_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Lelo kuli mhela wa kuzinga kwa isanya nazuya ng'wale nyinji, nazigubika honhu howawichile kambi Waisilaeli. Mitondo lufuku nakulawila nhungwi naigubika kambi zeng'ha. ");
INSERT INTO vid_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Nhungwi ayo loyuchile, vinhu vidodo vizisili navipona ako kuchiwala, vifandile kota ng'hunguyosi. ");
INSERT INTO vid_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Waisilaeli lowawene chinhu acho naweuza, “Choni achi?” Nahawachizelele nachali chinhu chachi. Lelo Musa nakawalonjela, “Aji ndo mibumunda Mkulu Nguluwi yawapele mulye. ");
INSERT INTO vid_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Mkulu Nguluwi nakalajiza mdite ahi, chila munhu nayakungajize chilyo cha kuhega kulya kuli ivyazi lya heye. Kolokota chasi cha lita mbili kwa chila munhu mihema lya heye.” ");
INSERT INTO vid_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Lelo Waisilaeli nawadita ahyo na iwa kota wanji nawalokota kwa winji na wanji chido. ");
INSERT INTO vid_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Ila weng'ha lowapimile chipimilo chowalokote kuli chijemo, nawafika kota yalokote chinji nahawele na nyonjeza na yalokote chido nahapunguchilwe. Chila yumwe nakalokota chasi choyoweza kulya. ");
INSERT INTO vid_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Musa nakawalonjela wanhu, “Munhu yoneche yaleche kulya na kuwika chinji mbaka mitondo.” ");
INSERT INTO vid_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Ila wanhu nahawamuhulichize Musa. Wamwe wa hewo nawasigaza chilyo mbaka mitondo. Ila mitondo chilyo acho nachiwa cholile na chilavya mhikomhiko na kunhung'ha. Musa nakazudizwa ng'hatu na wanhu. ");
INSERT INTO vid_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Lelo chila mitondo nawakungajiza chila munhu cha kuhega kulya. Isanya vyoliwa ling'ang'ale, chila chilyo chinji chisigale hafungo mwa nzila nachisungulumka. ");
INSERT INTO vid_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Kuli zuwa lya sita, hewo nawakungajiza chilyo acho keli, lita zine kwa chila munhu. Lelo wasekulu wa Waisilaeli weng'ha nawaluta kwa Musa, nawamlonjela mbuli azo. ");
INSERT INTO vid_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","Musa nakawalonjela, “Awu ndo mzilo wa Mkulu Nguluwi. Mitondo ndo zuwa lya kwesela, ndo zuwa lya kwesela lyelile lya Mkulu Nguluwi. Lelo mlute mkateleche ama kuhemsa chila chilyo chomlingugana lehano na chilyo chochisigala mchiwiche mbaka mitondo.” ");
INSERT INTO vid_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Lelo nawadita ahyo na kuleka chilyo chiyage mbaka mitondo kota Musa vyoyalonjile. Mitondo nawachona kota hacholile ne kuwa na mhikomhiko na kunhung'ha. ");
INSERT INTO vid_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Lelo Musa nakawalonjela, “Mulye chilyo acho chisigale kwa vila lehano ndo zuwa lya kwesela lya Mkulu Nguluwi. Lehano hamchifika chilyo ako kunze. ");
INSERT INTO vid_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Kwa mazuwa sita mowa mkungajiza chilyo achi, ila zuwa lya saba liwele ndo Zuwa lya Kwesela chowa haduhu.” ");
INSERT INTO vid_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Kuli zuwa lya saba wanhu wamwe nawalawa kuzapala chilyo, ila nahawachiwene. ");
INSERT INTO vid_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Aho Mkulu Nguluwi nakamlonjela Musa, “Mbaka hanili mochikala ne kibatilila mzilo na malajizo ga heni? ");
INSERT INTO vid_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Mvizele kota heni Mkulu Nguluwi ndiwapa Zuwa lya Kwesela, ndo mina nandiwapa chilyo cha mazuwa meli mli zuwa lya sita. Lelo mwesele chila munhu hakaye hake, munhu yoneche yaleche kulawa kuli zuwa lya saba.” ");
INSERT INTO vid_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Ahyo, wanhu nawesela zuwa lya saba. ");
INSERT INTO vid_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Waisilaeli nawachema chilyo acho “Mana.” Chilyo acho nachali kota nyhule za uhemba mzelu na ulyelyelye wake nawali kota ibumunda lizisili liwichigwe hanombwa. ");
INSERT INTO vid_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Musa nakawalonjela, “Ali ndo ilajizo lya Mkulu Nguluwi. Mhole chasi cha lita mbili za mana na kuwika kwa chiwalo cha walelwa wa hemwe, leka wone chilyo chondiwapele kuchiwala mhela londiwalavile kuli isi ya Misili.” ");
INSERT INTO vid_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Musa nakamlonjela Aluni, “Uhole chiya ujele mgati lita mbili za mana, ukawiche kumwando kwa Mkulu Nguluwi, iwe kwa chiwalo cha kukumbuchila kwa walelwa wa hemwe.” ");
INSERT INTO vid_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Lelo Aluni nakawika mana kuli honhu ha kulavila nhambiko kumwando kwa vibao vya maganga ga ulolezi leka gawichigwe kota vila Mkulu Nguluwi navyoyamlajize Musa. ");
INSERT INTO vid_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Waisilaeli nawalya mana kwa mhela wa miyaka makumi gane mbaka nalowafichile kuli isi iwele na wanhu, isi naiwele mli mbaka mwa Kanaani kowaditile honhu ha kikala hewo. ");
INSERT INTO vid_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","Chilyo cha mana chasi cha lita mbili nazali honhu ha kumi ha chipimilo cha mana nachichemigwe efa. ");
INSERT INTO vid_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Kulawila kuchiwala kuwelenguchemigwa Sini, Waisilaeli weng'ha nawenula majendo kulawa honhu hamwe mbaka hayage kota navyoyalajize Mkulu Nguluwi, wanhu nawawika kambi ako Lefidimu. Ila ako nahakuwele na mazi ga kunwa. ");
INSERT INTO vid_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Ahyo, wanhu nawamng'ung'utila Musa wolonga, “Utupe hetwe mazi ga kunwa.” Musa nakawauza, “Lekachoni mwangung'ung'utila heni? Lekachoni mwangumjeza Mkulu Nguluwi?” ");
INSERT INTO vid_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Ila weng'ha nawali na ng'halu, nawamng'ung'utila Musa wolonga, “Lekachoni nakutulavya kula Misili utukopole kwa ng'halu hetwe weng'ha na wana wa hetwe na migongolo ja hetwe?” ");
INSERT INTO vid_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Lelo Musa nakamlilila Mkulu Nguluwi yolonga, “Ndowaditila choni wanhu awa? Wahabehi kunhowa kwa maganga na kung'hopola!” ");
INSERT INTO vid_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Mkulu Nguluwi nakamlonjela Musa, “Ukole kumwando kwa wanhu awa, uwahola wasekulu wa hewo wamwe, uhole kahi mmoko mwako yila ng'hweku youtowile lwanda lwa Naili, na ulute. ");
INSERT INTO vid_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Ulole, heni ndokwima kumwando kwa hegwe mitalawe hala Holebu, nagwe kolitowa alyo italawe na mazi golawa leka wanhu weng'ha wanwe.” Lelo Musa nakadita ahyo hali wasekulu wa Waisilaeli. ");
INSERT INTO vid_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Honhu aho Musa nakahachema Masa na Meliba kwa vila Waisilaeli nawamng'ung'utila na kumjeza Mkulu Nguluwi wolonga, “Ndaze, ndo kukomya Mkulu Nguluwi ka hali hetwe?” ");
INSERT INTO vid_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Waamaleki nawoya na kitowa na Waisilaeli ako Lefidimu. ");
INSERT INTO vid_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Musa nakamlonjela Yoshua, “Uhagule walume ulute kitowa na Waamaleki. Mitondo ndokwima mchanya mwa chidunda, ndichibata ng'hweku yila ya Nguluwi mmoko mwangu.” ");
INSERT INTO vid_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Lelo Yoshua nakadita kota Musa navyoyamlonjele, nakaluta kitowa na Waamaleki. Musa na Aluni na Huli nawakwina kuchinhembenhembe mwa chidunda. ");
INSERT INTO vid_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Naiwa mhela weng'ha Musa loyokwinula moko mchanya, Waisilaeli nawawasumya Waamaleki, naloyaduliche moko hasi, Waamaleki nawawasumya Waisilaeli. ");
INSERT INTO vid_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Ila kwa mhela udo, moko ga Musa nagatoka ng'hatu. Ahyo, Aluni na Huli nawahola iganga nawaliwika behi na Musa na heye nakekalisa mchanya mwa iganga alyo. Hamba, nawajibata na kwinula moko gake, yumwe nakenula moko wa kudilo na yunji nakenula moko wa kumoso. Ahyo moko ga Musa nagapona gawele genuligwe kuchanya mbaka isanya loliswele. ");
INSERT INTO vid_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Ahyo Yoshua nakawasumya Waamaleki kwa ipanga. ");
INSERT INTO vid_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Hamba Mkulu Nguluwi nakamlonjela Musa, “Wandiche mbuli ayi kuli chitabu, iwe ya kukumbuchila na uhilulile kulonga mmakutu ga Yoshua kwa vila ndowosa ng'hatu Waamaleki muisi yeng'ha.” ");
INSERT INTO vid_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Musa nakazenga honhu ha kulavila nhambiko na kuhachema honhu aho, “Mkulu Nguluwi kandita heni sumye,” ");
INSERT INTO vid_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","yolonga, “Namwinula moko kuchanya kuli chigoda cha undewa cha Mkulu Nguluwi. Kochitowa ngondo na Waamaleki mazuwa gose.” ");
INSERT INTO vid_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Yesilo mtambika wa Midiani, mgosi wa Musa, nakahulika mbuli zeng'ha Mkulu Nguluwi zoyamditile Musa na Waisilaeli loyawalavile kuli isi ya Misili. ");
INSERT INTO vid_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","Ahyo, Yesilo nakoya kwa Musa yomigala Sipola mchewake Musa, yawele Musa nayamlechile kumbele kwa mhaza wa heye, ");
INSERT INTO vid_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","hamwe na wana weli walume wa Musa. Mwana wa mwaluko nakachemigwa Gelishomu. Musa nakamha itagwa ali kwa vila Musa nakalonga, “Nandali mjenzi kuli isi ya chijenzi.” ");
INSERT INTO vid_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","Mwana wa keli nakachemigwa Elieseli kwa vila Musa nakalonga, “Nguluwi wa mhaza wa heni ndo yanhanzile ndeche kukopoligwa na Falao.” ");
INSERT INTO vid_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Yesilo mgosi wa Musa nakoya hamwe na mhinza wa heye, mina mchewake Musa hamwe na wanage, nakamfika Musa kuchiwala nakoyawichile kambi kuli chidunda cha Nguluwi. ");
INSERT INTO vid_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","Musa loyalonjelwe kota mgosi wa heye hamwe na mchewake na wanage weli wanguya, ");
INSERT INTO vid_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","lelo Musa nakalawa kuza kumbochela mgosi wa heye, nakamwinamila na kumnonela. Welamsa na kiwuza mbuli za chila yumwe, hamba nawenjila mli ihema lya Nguluwi. ");
INSERT INTO vid_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Musa nakamlonjela mgosi wa heye mbuli zeng'ha Mkulu Nguluwi nazoyamditile Falao na Wamisili kwa chiwalo cha Waisilaeli. Nakamlonjela kahi mbuli za kugaya nakuwafichile mmajendo na vila Mkulu Nguluwi navyoyawalohole. ");
INSERT INTO vid_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Yesilo nakasangalazwa na geng'ha goyaditile Mkulu Nguluwi kwa chiwalo cha Waisilaeli, kwa kuwalohola mmoko mwa Wamisili. ");
INSERT INTO vid_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","Yesilo nakalonga, “Nayatambichizwe Mkulu Nguluwi yawele yakulohole hegwe mmoko mwa Wamisili na kulawa kwa Falao, na yawalohole wanhu kulawa mmoko mwa Wamisili. ");
INSERT INTO vid_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Lelo ndivizela kota Mkulu Nguluwi ndo mkulu kusinda milungu jeng'ha, kwa vila nakawalohola wanhu awa mmoko mwa Wamisili nawawele wochidaya.” ");
INSERT INTO vid_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Aho Yesilo, mgosi wa Musa, nakamlavila Mkulu Nguluwi nhambiko ya kulakaza na nhambiko zinji. Na heye Aluni nakoya hamwe na wasekulu wa Isilaeli leka kulya chilyo hamwe na Yesilo, hali Nguluwi. ");
INSERT INTO vid_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Hamitondo, Musa nakekala kuwatagusa Waisilaeli, nawo nawema wamzungulute, kulawila hamitondo mbaka mhela wa kuzinga kwa isanya. ");
INSERT INTO vid_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Yesilo mgosi wa Musa, loyawene mbuli zeng'ha Musa nazoyawaditile Waisilaeli, nakamuuza, “Lekachoni kwanguwaditila wanhu mbuli azi? Lekachoni kwanguwa mtagusa uliyeka kuno wanhu wano wokuzunguluta kulawa mitondo mbaka mhela wa kuzinga kwa isanya?” ");
INSERT INTO vid_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Musa nakamwidichila mgosi wa heye, “Kwa vila wanhu wanguya kwa heni kuuza choyogana Nguluwi. ");
INSERT INTO vid_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Wone wawe na kilewa koneche kula, wanguya kwa heni, nani ndangutagusa hali hewo weli na kuwatang'ulila malajizo na mzilo wa Nguluwi.” ");
INSERT INTO vid_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Lelo Yesilo nakamlonjela Musa, “Hainojile vyoulingudita. ");
INSERT INTO vid_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Kochitunya gwegwe baho na awa wanhu, mina mbuli ayi inamana lukami. Huweza hebu kuidita uliyeka. ");
INSERT INTO vid_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Uhulichize vyondilingukulonjela, ndangijesa ahi, na Nguluwi yawe hamwe na hegwe. Hegwe kolongasa na Nguluwi honhu ha wanhu na kochigala nongwa za hewo kwa Nguluwi. ");
INSERT INTO vid_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","Hihyo du, kowalangusa wanhu malajizo na mizilo ja Nguluwi, na uwalajile ndaze vyowalinguganigwa kikala na mijito yowalinguganigwa kudita. ");
INSERT INTO vid_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Ila kwa chiwalo cha mbuli zinji, uhagule wanhu walume wadahile mumo mli wanhu weng'ha, wanhu walingumdumba Nguluwi na wanhu watanganiche na walinguzudila kupegwa chinhu choneche chila leka kubena malajizo. Uwape awo ulongozi, wawe wowemilila wanhu mli vilundo vya wanhu elufu imwe na vilundo vya wanhu miya imwe na vilundo vya makumi gahano na vilundo vya wanhu kumi. ");
INSERT INTO vid_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Awo ndo wowa na nhing'hano chila zuwa kutagusa nongwa za wanhu. Nongwa ng'hulu wokigalila hegwe, ila zila ndodondodo wotagusa wawo. Kwa nzila ayi, koweza kuzona mbuli azi za ubewe kwa vila wochitanza na hegwe kuli mbuli azo. ");
INSERT INTO vid_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Wone udite ahyo, na wone ndo vyoyalingugana Nguluwi, koweza kwimilila na wanhu awa weng'ha wohiluka kaye kwa hewo goya.” ");
INSERT INTO vid_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Musa nakahulichiza ulonzi awo wa mgosi wa heye na kudita kota vyoyalonjile. ");
INSERT INTO vid_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","Lelo Musa nakawahagula wanhu wawele walume wawele na mong'ho hali Waisilaeli, nakawadita kuwa vilongozi wa vilundo vya wanhu elufu imwe na vilundo vya wanhu miya imwe na vilundo vya wanhu makumi gahano na vilundo vya wanhu kumi. ");
INSERT INTO vid_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Na hewo wawa wowatagusa nongwa za hewo chila mhela. Nongwa ng'hulu nawamigalila Musa, ila zila ndodo nawetagusila wawo. ");
INSERT INTO vid_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Loyasindile kudita ahyo, Musa na mgosi wa heye nawelaga. Heye Yesilo nakahiluka muisi ya heye. ");
INSERT INTO vid_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","Zuwa lya mwaluko lya mwezi wa kadatu kulawila lowalawile Misili, Waisilaeli nawafika kuchiwala ako Sinai. ");
INSERT INTO vid_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","Nalowochile Lefidimu na lowafichile kuchiwala ako Sinai, nawawika kambi kumwando mwa chidunda cha Sinai. ");
INSERT INTO vid_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Lelo Musa nakakwina kuchanya kuchidunda kwa Nguluwi. Aho Mkulu Nguluwi nakamchema Musa kulawila ako kuchanya kuchidunda, nakamlonjela, “Ahi ndo vyouwalonjela walelwa wa Yakobo, awo Waisilaeli, ");
INSERT INTO vid_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","‘Mwemwe baho mona vyondiwaditile Wamisili na vila vyondiwaholile hemwe kota ikungule lilinguhola wana wa heye kwa mbawa, ndiwegala hemwe kwa heni. ");
INSERT INTO vid_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Lelo wone mhuliche lizi lyangu na kibata ilagano lya heni, mowa wanhu wa heni mhaguligwe hali isi zeng'ha, kwa vila isi zeng'ha ndo za heni. ");
INSERT INTO vid_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","Mowa undewa wa watambika na nhanzi yelile kwa heni.’ Awo ndo ulonzi womuwalonjela Waisilaeli.” ");
INSERT INTO vid_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Lelo Musa nakahiluka, nakawakungajiza hamwe wasekulu wa Waisilaeli na kuwalonjela ulonzi awo nagowalajizwe na Mkulu Nguluwi. ");
INSERT INTO vid_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Wanhu weng'ha nawedichila hamwe wolonga, “Mbuli zeng'ha nazoyalonjile Mkulu Nguluwi tozidita.” Musa nakamhilusila Mkulu Nguluwi kwidichila ako kwa wanhu. ");
INSERT INTO vid_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Mkulu Nguluwi nakamlonjela Musa, “Heni ndokuyila kuli ng'hungugu itisile leka Waisilaeli wahuliche hondilonga na hegwe na wokukunda hegwe mazuwa gose.” Hamba Musa nakamlonjela Mkulu Nguluwi vila wanhu navyowalonjile. ");
INSERT INTO vid_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","Mkulu Nguluwi nakamlonjela Musa, “Ulute kwa wanhu ukawelize leka wawe welile lehano na mitondo. Uwalonjele wakanze nguwo za hewo. ");
INSERT INTO vid_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","Wekale goya kwa zuwa lya kadatu, mina zuwa alyo lya kadatu heni Mkulu Nguluwi ndodulika mchanya mwa chidunda cha Sinai hali wanhu weng'ha. ");
INSERT INTO vid_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Kahi kowawichila wanhu mbaka kuzunguluta chidunda. Uwalonjele kota welolele ng'hatu waleche kukwina kuchanya mchidunda ne kuhejelela mbaka uwichigwe. Yoneche yohejelela na kudoliza chidunda kobagama. ");
INSERT INTO vid_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Munhu yaleche kumdoliza munhu ayo yadolize chidunda, mina kobagama kwa kutowigwa na maganga ama msale, yawe munhu ama igongolo, hopona hebu. Mhela mhalamhanda hoipembigwa kwa kulutilila, wanhu weng'ha wokwina kuchidunda.” ");
INSERT INTO vid_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Lelo Musa nakedulika mchidunda na kuwalutila wanhu, nakaweliza, na hewo nawakanza nguwo za hewo. ");
INSERT INTO vid_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","Hamba nakawalonjela wanhu, “Haucha muwe mwimile goya, na mlume yoneche yaleche kumhejelela mdala.” ");
INSERT INTO vid_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Lelo zuwa lya kadatu mitondo, nakulawila kubuma na lumwemwesa na ng'hungugu itisile mchanya mwa chidunda. Naihulikwa lizi ng'hulu ng'hatu ya mhalamhanda naiwaditile wanhu weng'ha wakakame hala honhu nahowawichile kambi. ");
INSERT INTO vid_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Hamba Musa nakawalongoza wanhu kulawa hala nahowawichila kambi, nawaluta kuting'hana na Nguluwi. Weng'ha nawaluta na kikala goya hanyiga ha chidunda. ");
INSERT INTO vid_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Chidunda cha Sinai nachali chigubikwe kwa iyosi kwa vila Mkulu Nguluwi nakedulika mchanya mwake kuli chiluli. Iyosi alyo lya chiluli nalikwina kuchanya kota iyosi lya itanuli ikulu na chidunda cheng'ha chali chitigasika. ");
INSERT INTO vid_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Lizi lya mhalamhanda nalilutilila konjezeka. Musa nakalonga na Nguluwi, na heye Nguluwi nakamwidichila kwa kubuma. ");
INSERT INTO vid_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Mkulu Nguluwi nakedulika mchanya mwa chidunda cha Sinai, nakamchema Musa kulawila ako kuchanya, na heye Musa nakakwina kuchidunda. ");
INSERT INTO vid_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","Hamba Mkulu Nguluwi nakamlonjela Musa, “Widuliche hasi ukawakanye wanhu weng'ha waleche kuya kundola, mina wone wojeza kudita ahyo wenji wa hewo wobagama. ");
INSERT INTO vid_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Na hewo watambika wawele wonyhejelela wanguganigwa wedite welile, wone haiwa ahyo, heni Mkulu Nguluwi ndowagaza.” ");
INSERT INTO vid_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Musa nakamlonjela Mkulu Nguluwi, “Wanhu wano hawoweza kukwina kuchidunda cha Sinai kwa vila gwegwe baho nakutukanya tuwiche mbaka kuzunguluta chidunda na kuchidita chiwe chelile.” ");
INSERT INTO vid_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Mkulu Nguluwi nakalonga, “Widuliche hasi hamba uhiluche na Aluni. Ila uleche kuwakundiza watambika na wanhu wanji waloche mbaka na kuya kwa heni, wone wodita ahyo ndowagaza.” ");
INSERT INTO vid_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Lelo Musa nakedulika na kuwalonjela Waisilaeli mbuli zeng'ha nazoyalajizwe. ");
INSERT INTO vid_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Nguluwi nakalonga ulonzi awu weng'ha, nakalonga, ");
INSERT INTO vid_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","“Heni ndo Mkulu Nguluwi, Nguluwi wa hegwe, ndikulavile kulawila Misili, nakouwele mpogozi. ");
INSERT INTO vid_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","“Uleche kuwa na milungu jiyage ila heni. ");
INSERT INTO vid_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","“Uleche kiditila jimalukolo ja milungu ja udesi, ama chihongoligwe chifandile na chiwele kilanga ama kuli isi ama mmazi hasi ha isi. ");
INSERT INTO vid_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Uleche kujifugamila milungu ja udesi ne kujikolela mijito, kwa vila heni Mkulu Nguluwi, Nguluwi wa hegwe, nda Nguluwi yawele na fihi. Ndanguwagaza wana kwa wihe wa wahaza wa hewo, na lulelo lwa kadatu na lwa kane lwa awo walingunzudila. ");
INSERT INTO vid_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","Ila ndanguwalajila igano lya kwimilila maelufu ga wala wawele na igano kwa heni na kibata malajizo ga heni. ");
INSERT INTO vid_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","“Uleche kulichema hela itagwa lya heni Mkulu Nguluwi, Nguluwi wa hegwe. Mina heni Mkulu Nguluwi sileka kumgaza yalingulichema hela itagwa lya heni. ");
INSERT INTO vid_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","“Ukumbuchile Zuwa lya Kwesela na kulidita liwe lyelile, mina ndo lya chiuyeng'ha. ");
INSERT INTO vid_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Mazuwa sita ukole mijito na udite mbuli za hegwe zeng'ha. ");
INSERT INTO vid_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","Ila zuwa lya saba ndo zuwa lya kwesela lya Mkulu Nguluwi, Nguluwi wa hegwe. Zuwa alyo uleche kukola mijito joneche, hegwe ne mwanago mlume ne mhinza wa hegwe ne wapogozi wa hegwe wadala ne chitumagwa wa hegwe mlume ne migongolo ja hegwe ja kudimigwa ne mjenzi yawele mng'handa mwa hegwe. ");
INSERT INTO vid_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Mina kwa mazuwa sita heni Mkulu Nguluwi nandizilumba ulanga na isi, bahali na vyeng'ha vilimumo, hamba nanyhesela zuwa lya saba. Ahyo, heni Mkulu Nguluwi nandilitambichiza Zuwa lya Kwesela na ndilidita liwe yelile. ");
INSERT INTO vid_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","“Wahulichize mhaza na mayako leka wikale na ukomu wa kulutilila kuli isi yondilingukupa heni Mkulu Nguluwi na Nguluwi wa hegwe. ");
INSERT INTO vid_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","“Uleche kukopola. ");
INSERT INTO vid_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","“Uleche kuwasa na mdala ama mlume wa munhu yunji. ");
INSERT INTO vid_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","“Uleche kuhiza. ");
INSERT INTO vid_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","“Uleche kulavya ulolezi wa udesi kwa yawele habehi na hegwe. ");
INSERT INTO vid_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","“Uleche kuigana ng'hatu ng'handa ya muyago, ne mchewake ne mpogozi wa heye mlume ama mdala ne isenga lyake ne idogowi ne choneche chiwele cha muyago.” ");
INSERT INTO vid_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Wanhu nalowahuliche kubuma kwa limlungu na kuhulika lizi ya mhalamanda na kuchanya mwa chidunda chiwele chifung'ha iyosi, weng'ha nawadumba na kukakama. Weng'ha nawema kutali, ");
INSERT INTO vid_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","nawamlonjela Musa, “Ulonje na hetwe gwegwe baho, natwe tokuhulichiza, ila Mkulu Nguluwi yaleche kulonga na hetwe, ama tobagama.” ");
INSERT INTO vid_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Musa nakawalonjela, “Mleche kudumba, mina Nguluwi koya kuwajeza leka mumdumbe heye na mleche kudita gehile.” ");
INSERT INTO vid_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Wanhu weng'ha nawema kutali mhela Musa nayahejelele ayila ng'hungugu itisile moyawele Nguluwi. ");
INSERT INTO vid_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","Mkulu Nguluwi nakamlonjela Musa, “Walonjele Waisilaeli, ‘Miwonela mwemwe baho kota heni nandonga na hemwe kulawila kilanga. ");
INSERT INTO vid_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","Mleche kiditila vinhu vya sendi viwhanile kota milungu viwe hamwe na heni na mleche kiditila mwemwe vinhu vya zahabu viwhanile kota milungu. ");
INSERT INTO vid_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","Hemwe monzenjela honhu ha kulavila nhambiko ha ilongo iwele mchanya mwake monhambichila migongolo ja hemwe kota nhambiko za kulakazwa na nhambiko ya kikala goya. Honhu honeche hondiwakumbusa wanhu itagwa lya heni, baho du heni baha ndokuyilani na kuwatambichiza. ");
INSERT INTO vid_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","Wone mwaluche kunzenjela honhu ha kulavila nhambiko ha maganga, mleche kuditila kwa maganga ga kuhongola, mina wone mditichile vinhu vya kuhongolela maganga mohadita hakokomoche. ");
INSERT INTO vid_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Na mleche kudita honhu ha kulavila nhambiko hawele na honhu ha kukwinila, leka yaleche koneka umwazi wa heye yalingukwina mchanya mwake.’ ");
INSERT INTO vid_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","“Aga ndo malajizo gouwapa Waisilaeli. ");
INSERT INTO vid_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","Hougula mpogozi Muebulaniya, kukukolela mijito kwa mihela sita, ila mhela wa saba kowa yelejehe na kuka, ne kulavya sendi. ");
INSERT INTO vid_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","Wone nakaguligwa hanahola mdala, kokuka yaliyeka. Ila wone nakoya na mchewake, kokuka na mchewake. ");
INSERT INTO vid_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","Wone mkulu wa heye nakamhesela mdala, nakampondela mwana mdala ama mlume, lelo ayo mdala na wanage wowa wanhu wa ayo mkulu wa heye na ayo mpogozi kokuka yaliyeka. ");
INSERT INTO vid_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","Ila wone mpogozi ayo wone yalonje kota kangumgana mkulu wa heye na mchewake na wana wa heye na halingugana kuka na kilejeha, ");
INSERT INTO vid_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","lelo, mkulu wa heye komigala hali Nguluwi. Hamba komhilika kuli lwizi ama mhajilo na kumtubula ikutu lyake kwa vibatililo. Hamba heye kowa mpogozi wa mkulu wa heye mazuwa gose. ");
INSERT INTO vid_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","“Munhu yomguza mhinza wa heye yawe mpogozi, ayo howa yelejehe kota wapogozi walume. ");
INSERT INTO vid_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","Wone mkulu wa heye nakamgula ayo mhinza yawe yumwe wa wadala wa heye, hamba wone nahanojezwe na heye na kumleka, mhaza wa heye koweza kumgombola ayo mpogozi. Ayo mkulu howeza kumguza kwa wanhu wa isi zinji, kwa vila nakabena ilagano na mdala yula. ");
INSERT INTO vid_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","Wone mwanage mlume yagane kumhesela ayo mpogozi, mkulu komditila mpogozi ayo kota mhinza wa heye. ");
INSERT INTO vid_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","Wone ayo mkulu yohesa mdala yunji, yomgana yalutilile kumwenezela mdala wa mwaluko kwa chilyo na nguwo na kuponda wana na heye. ");
INSERT INTO vid_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","Wone ayo mkulu kolemwela kumditila mbuli azo zidatu, lelo mdala kokuka na kowa yelejehe, ne kuganigwa kulavilwa chinhu choneche. ");
INSERT INTO vid_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","“Yomtowa munhu na kumkopola, imgana yakopoligwe. ");
INSERT INTO vid_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","Ila wone haganile kumkopola, wone Nguluwi nakakundiza mbuli ayi ilawile, lelo ayo yakopole koweza kubilimila honhu hondiwahagulilani. ");
INSERT INTO vid_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","Wone munhu nakagana kumkopola miyage kwa ujuvi, hanga na wone yabilimile kuli honhu ha kulavila nhambiko kwa kilohola, komlavya ako kuli honhu ha kulavila nhambiko ha heni na kumkopola. ");
INSERT INTO vid_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","“Yomtowa mhaza wa heye ama mayake imgana yakopoligwe. ");
INSERT INTO vid_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","“Yomibata munhu kwa lupichi leka yamguze ama kumdita mpogozi imgana yakopoligwe. ");
INSERT INTO vid_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","“Yompanjila mhaza wa heye ama mayake imgana yakopoligwe. ");
INSERT INTO vid_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","“Wanhu weli howochilewa, hamba yumwe yomtowa miyage iganga ama ngumi ne kumkopola, ila kamng'wanyula hela na kumdita yogule na kuwasa mchinanda, ");
INSERT INTO vid_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","wone ayo yatowigwe yowa goya na kujeza kujenda kwa ng'hweku, ayo yamng'wenyule kolechelwa. Ila, komha chasi kwa mhela woyajilize mchinanda na yamuguze mbaka yawe goya ng'hatu. ");
INSERT INTO vid_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","“Munhu yomtowa mpogozi wa heye mlume ama mdala kwa ng'obwa na kumkopola, imgana yagazigwe. ");
INSERT INTO vid_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","Ila mpogozi ayo wone yawe mkomu zuwa limwe ama mazuwa meli, mkulu wa heye hogazigwa hebu, kwa vila mpogozi ndo nayali wa heye. ");
INSERT INTO vid_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","“Walume wone wetowe na kumlumiza mdala yawele na himila, na himila ya heye haitenguche ne kulawila chinhu chinji ng'hatu, yula yamlumize koganigwa kumha chinhu choyogana mlume wa mdala ayo na kota watagusa vyowotagusa. ");
INSERT INTO vid_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","Ila wone kuwe na kuwifya kunji, lelo yamhilusile ukomu kwa ukomu ");
INSERT INTO vid_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","na iziho kwa iziho na izino kwa izino na moko kwa moko na mgulu kwa mgulu ");
INSERT INTO vid_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","na kusomigwa chiluli kwa kusomigwa chiluli na chilonda kwa chilonda na kutowa kwa kutowa. ");
INSERT INTO vid_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","“Munhu wone yamtowe mpogozi wa heye mlume ama mdala na kuwifya iziho lyake, yamlechele yalute yelejehe kwa chiwalo cha iziho lyake. ");
INSERT INTO vid_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","Hihyo du, wone yamtowe na kumbena izino mpogozi wa heye mlume ama mdala, yamlechele yawe yelejehe kwa chiwalo cha izino lyake. ");
INSERT INTO vid_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","“Wone isenga limtowe munhu kwa mbalati na kumkopola, munhu mlume ama mdala, isenga alyo lyokopoligwa kwa kutowigwa kwa maganga na miwunde jake hajiligwa hebu. Munhu nayawele na isenga alyo, howa na nongwa hebu. ");
INSERT INTO vid_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","Ila wone isenga alyo nalizowela kutowa wanhu kwa mbalati, na heye yawele na isenga alyo kalonjelwa na halikowele hebu, wone isenga alyo likopole munhu mlume ama mdala, litowigwe kwa maganga na heye munhu yakopoligwe. ");
INSERT INTO vid_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","Ila, munhu ayo wone yoganigwa kulavya chinhu kwa kilohola ukomu wa heye, yalavye chasi chichila choyolonjelwa kulavya. ");
INSERT INTO vid_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","Isenga wone limtowe mbalati mwana mlume ama mdala wa munhu yunji, nongwa ayi yotagusigwa kwa nzila yiyo. ");
INSERT INTO vid_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","Wone isenga alyo limtowe mbalati mpogozi mlume ama mdala, yawele na isenga alyo kumhilusila mkulu wa ayo mpogozi sendi zihejile kwa gilamu miya zidatu na makumi gahano ga sendi na alyo isenga likopoligwe kwa kutowigwa kwa maganga. ");
INSERT INTO vid_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","“Wone munhu yoleka ikulubila mwazi ama wone yobawa ikulubila hamba yaleche kuligubika, hamba isenga ama idogowi linjile amo, ");
INSERT INTO vid_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","ayo yawele na ikulubila alyo, yalavye sendi kwa yawele na isenga ibuguma na igongolo lifile lyowa lya heye. ");
INSERT INTO vid_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","“Isenga lya munhu wone lilumize isenga lya munhu yunji na kulikopola, lelo hewo woliguza alyo isenga liwele likomu na kigawila chochiguzigwa na vivila wochigawila lila isenga lifile. ");
INSERT INTO vid_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","Ila wone alyo isenga nalizowela kutowa wanji kwa mbalati na munhu yalifujile halikowele, yuye kohilusa isenga kwa isenga ibuguma na lila lifile lyowa lya heye. ");
INSERT INTO vid_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","“Wone munhu yohiza isenga ama ing'holo na kulidumula singo ama kuliguza, kolapigwa kulavya misenga jihano kwa chila isenga na ming'holo jine kwa chila ing'holo. ");
INSERT INTO vid_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","Wone mhizi yobatigwa yobena ng'handa mhela wa nechilo, na kutowigwa mbaka kubagama, yamkopole kowa hela nongwa ya kukopola. ");
INSERT INTO vid_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","Ila wone mhizi ayo yebatigwe nemisi na kukopoligwa, yamkopole kowa na nongwa. Ayo mhizi koganigwa kuhilusa chinhu. Wone yawe hela chinhu cha kulavya, lelo heye yuye koguzigwa leka kulipila uhizi wa heye. ");
INSERT INTO vid_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","Wone igongolo lihizigwe lyokoneka kwa yula yahizile liwele likomu, mhizi ayo kohilusa keli, liwe isenga ama idogowi ama ing'holo. ");
INSERT INTO vid_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","“Wone munhu yodimila migongolo ja heye kuli mgunda wa zabibu ama kulechela igongolo lyake kudima kuli mgunda wa munhu yunji, kohilusa kuwifya ako kwa chilyo chinojile cha mgunda wa heye yuye ama mgunda wa heye wa zabibu. ");
INSERT INTO vid_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","“Wone munhu yobwina chiluli na kusoma migodi ja miwa na kulutilila kulakaza migunila ja nyhule ama nyhule za munhu yunji zing'hali benigwa, ama mgunda weng'ha ulakale, yula yabwinile chiluli acho, yalavye chinhu kwa kuwifya ako kweng'ha. ");
INSERT INTO vid_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","“Wone munhu yomlechela miyage sendi ama lufufu lunji yamuwichile goya, hamba yahizilwe mng'handa mwake, mhizi yoneche wone yebatiche yahiluse keli. ");
INSERT INTO vid_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","Ila wone mhizi hambe yebatiche, yawele na ng'handa kohejelela hali Nguluwi leka yelahe kota haditile uhizi wa lufufu lwa miyage. ");
INSERT INTO vid_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","Wone howa na kitwanza kwa chiwalo cha isenga ama idogowi ama ing'holo ama cha kuvala ama chinhu choneche chajilile chiwele chila yumwe hali hewo weli yolonga cha heye, wala wanhu wogaligwa hali Nguluwi. Yula yawele Nguluwi yolonga kota kana nongwa, komhilusila miyage keli. ");
INSERT INTO vid_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","“Wone munhu yomlechela miyage idogowi ama isenga ama ing'holo ama igongolo linji lyoneche yamlolele goya na igongolo alyo libagame ama kulumila ama kuholigwa ne munhu yoneche kona, ");
INSERT INTO vid_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","chilaho hali Mkulu Nguluwi cholamula hali hewo kulajila kota ayo yalechelwe haditile uhizi wa lufufu lwa miyage. Yawele na igongolo alyo kokunda chilaho acho na ayo miyage holavya chinhu choneche chila. ");
INSERT INTO vid_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","Ila wone izeleche kota nalihizigwa kwa heye, yamhilusile miyage yawele na isenga ibuguma. ");
INSERT INTO vid_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","Wone alyo igongolo nalikopoligwa na migongolo ja kisolo, ayo munhu yawele yalechelwe yaligale igongolo alyo likopoligwe, kota ulolezi. Holavya chinhu choneche kwa chiwalo cha igongolo likopoligwe na migongolo ja kisolo. ");
INSERT INTO vid_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","“Wone munhu yaziche igongolo kwa miyage, hamba igongolo alyo lilumile ama kubagama, mhela yawele na igongolo nayali haduhu, yula yaziche yamhilusile miyage chenele. ");
INSERT INTO vid_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","Ila wone heye yawele na igongolo nayalibaho, lelo yula yaziche holavya chinhu choneche. Wone nalyali igongolo lyazichwe kwa sendi, sendi azo zohega kwa kwajilila kwa igongolo alyo. ");
INSERT INTO vid_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","“Wone munhu yomhada mhinza hanating'hana na mlume na hanabanichilwa na kuwasa na heye, yalavye sendi za kumhesa mhinza ayo yawe mchewake. ");
INSERT INTO vid_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","Mhaza wa ayo mhinza wone yolema ng'hatu mhinza wa heye kuholigwa, munhu ayo kolavya sendi zihejile kwa kumhola mhinza hanating'hana na mlume. ");
INSERT INTO vid_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","“Uleche kumleka mdala yawele mhawi yapone mkomu. ");
INSERT INTO vid_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","“Yalingudita ung'hondwa na migongolo kanguganigwa yakopoligwe. ");
INSERT INTO vid_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","“Yalingumlavila nhambiko mlungu yunji honhu ha Mkulu Nguluwi yaliyeka, imgana yabagamizwe ng'hatu. ");
INSERT INTO vid_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","“Mleche kumbada na kumgaza mjenzi, mina hemwe mwali wajenzi kuli isi ya Misili. ");
INSERT INTO vid_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","Mleche kumgaza mdala yafililwe na mlume wa heye ama mwana mchiwa. ");
INSERT INTO vid_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","Wone muwabunze awo na wone hewo wondilila, ndangukomya ndohulichiza chililo cha hewo, ");
INSERT INTO vid_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","na kuzudila kwa heni kokwaka. Nani ndowakopolani kwa ipanga, na wadala wa hemwe wowa walekwa na wana wa hemwe wowa wachiwa. ");
INSERT INTO vid_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","“Houmha sendi munhu yoneche hali wanhu wa heni wawele wazunwa, uleche kuwa kota yodayi na uleche kugana nyonjeza. ");
INSERT INTO vid_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","Wone kuhola igolole lya muyago na kuliwika poni, umhilusile isanya halinazinga, ");
INSERT INTO vid_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","kwa vila alyo ndo igolole lya heye liliyeka, ndo lyondichigubika na lilyo. Ama kwangijesa kowasila choni? Hoyondilila ndomhulichiza, mina heni ndo mbele na isungu. ");
INSERT INTO vid_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","“Uleche kumliga Nguluwi, ne kumpanjila mkulu wa wanhu wa hegwe. ");
INSERT INTO vid_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","“Uleche kukawila kundavila honhu hangu kuli winji wa chilyo cha hegwe na divai ya hegwe. Momha walelwa wa hemwe wa mwaluko walume. ");
INSERT INTO vid_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","Modita hihyo du kwa chiwalo cha walelwa wa mwaluko wa misenga na ming'holo ja hemwe. Momleka chila mlelwa wa mwaluko na mayake kwa mazuwa saba na zuwa lya nane mondavila. ");
INSERT INTO vid_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","“Hemwe mowa wanhu wa chiuyeng'ha kwa heni. Ahyo hamulya miwunde ja igongolo likopoligwe na igongolo lya kisolo. Miwunde ajo motozela mibwa. ");
INSERT INTO vid_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","“Uleche kulonga mbuli za udesi. Uleche kihanza na munhu yawele na wihe leka uwe mlolezi mwihe. ");
INSERT INTO vid_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","Uleche kuwinza chilundo cha wanhu kudita wihe, na uleche kihanza na chilundo cha wanhu kulavya ulolezi hali honhu ha kutagusila leka kuwajiliza wanhu. ");
INSERT INTO vid_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","Uleche kudita uganililo kuli utaguso wa wazunwa. ");
INSERT INTO vid_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","“Houlyona isenga ama idogowi lya mwihe wa hegwe lyajilile, komhilusila yuye. ");
INSERT INTO vid_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","Houlyona idogowi lya munhu yalingukuzudila ligwile na itunyo lyake, uleche kulileka na kuka, ila ulitanze kwinuka. ");
INSERT INTO vid_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","“Uleche kwajiliza hachi ilingumlapa mnzunwa kuli utaguso wa heye. ");
INSERT INTO vid_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","Wikale kutali na ulonjelezi wa udesi na uleche kuwakopola walihela nongwa na watanganiche, mina heni simlechela munhu mwihe. ");
INSERT INTO vid_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","Uleche kubochela chinhu chilingwambuza kubena malajizo, mina chinhu acho changuwajiliza wawele na nyhala na kwajiliza mbuli za wanhu wawele na hachi. ");
INSERT INTO vid_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","“Uleche kumbunza mjenzi, hemwe mvizela ndaze ujenzi vyouli, mina namwali wajenzi kuli isi ya Misili. ");
INSERT INTO vid_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","“Kwa mhela wa miyaka sita konyala nyhule kuli migunda ja hegwe na kubena chilyo cha heye. ");
INSERT INTO vid_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","Ila kuli mwaka wa saba, kojileka migunda ja hegwe ne kunyala nyhadikwa, leka wazunwa hali wanhu wa hegwe wapegwe chilyo chiponile amo na migongolo ja kisolo jilye. Kodita hihyo kuli migunda ja hegwe ja zabibu na mizeituni. ");
INSERT INTO vid_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","“Kwa mazuwa sita kokola mijito ja hegwe, ila zuwa lya saba kokwesela, leka ibuguma na idogowi jesele, na wana wa mpogozi wa hegwe mdala na wajenzi welejehe na kwesela. ");
INSERT INTO vid_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","“Wibate geng'ha gondonjile. Uleche kugachema ng'oo matagwa ga milungu jinji, ago galeche kuhulikwa kumlomo wa hegwe. ");
INSERT INTO vid_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","“Kadatu chila mwaka modita mnvina kwa ukulu wa heni. ");
INSERT INTO vid_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","Molutilila kuwa na mnvina ya mibumunda jiwele hela usaso, kota vyondiwalajize, molya mibumunda johajiwichigwe usaso kwa mazuwa saba mhela uwichigwe kuli mwezi wa Abibu, kwa vila kuli mwezi awo namlawa Misili. Munhu yoneche yaleche kuya behi na heni moko yeka. ");
INSERT INTO vid_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","Molutilila kuwa na mnvina ya mbena ya mwaluko ya mijito ya hemwe iwele mnyalile mli migunda ja hemwe. Molutilila kuwa na mnvina ya kukungajiza mbena kuduma kwa mhela homkungajiza chilyo cha mijito ya hemwe. ");
INSERT INTO vid_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","Kadatu kwa chila mhela, walume weng'ha wokuya kilajila hali Mkulu, Mkulu Nguluwi. ");
INSERT INTO vid_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","“Uleche kulavya danda ya nhambiko ya heni hamwe na mibumunda jiwichigwe usaso na uleche kugaleka mafuta ga igongolo lya mnvina ya heni gapone mbaka mitondo. ");
INSERT INTO vid_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","“Mbena ya mwaluko ya hegwe inojile kochigala kaye kwa heni Mkulu Nguluwi, Nguluwi wa hegwe. “Uleche kuhemsa mhene nyana kuli itombo lya mayake. ");
INSERT INTO vid_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","“Mlole, heni ndangumlajiza mhilisi yawalongole mmajendo leka yawamileni na kuwahilikani kuli isi yondiwawichileni. ");
INSERT INTO vid_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Mumuhulichize na kibatilila choyolonga, na mleche kumhinduka, mina howosela gehile ga hemwe hebu kwa vila kana ludali lwa heni mgati mwake. ");
INSERT INTO vid_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","Ila wone momhulichiza goya na kudita geng'ha goyolonga, heni ndowa mwihe wa wehile wa hemwe na mtwanzi wa watwanzi wa hemwe. ");
INSERT INTO vid_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","“Mhilisi wa heni hoyowalongoza na kuwahilikani kuli isi ya Waamoli na Wahiti na Wapelisi na Wakanaani na Wahivi na Wayebusi, nani ndowabagamiza awo weng'ha, ");
INSERT INTO vid_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","mleche kufugamila hali milungu ja hewo na kujikolela mijito ne kujiditila chinhu ne kuwinza mbuli za hewo. Ila mowabagamiza ng'hatu na kubenanga mizengo ja milungu ja hewo. ");
INSERT INTO vid_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","Mofugamila heni Mkulu Nguluwi, Nguluwi wa hemwe, nani ndowatambichiza kwa chilyo na mazi na kusa matamwa hali hemwe. ");
INSERT INTO vid_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","Kuduhu mdala yoneche yowifya himila za hewo ne kuwa mhende kuli isi ya hemwe. Nani ndowegalila ukomu wa kulutilila. ");
INSERT INTO vid_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","Ndowegalila ukabuso wa heni kumwando kwa hemwe na kuwatigula wanhu weng'ha womting'hana nawo na wala wehile wa hemwe ndowadita wagaluche na kuwabilima. ");
INSERT INTO vid_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","Ndowegalila ukabuso wa heni kota midondola kumwando kwa hemwe jiwe jiwawinga Wahivi na Wakanaani na Wahiti. ");
INSERT INTO vid_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","Siwawinga wanhu kwa mhela umwe, isi ileche kupona ne chinhu na migongolo ja kisolo jonjezeche ng'hatu na kuwalumiza. ");
INSERT INTO vid_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","Ila ndowosa hadohado mbaka aho homkonjezeka na kuihalila isi ayo. ");
INSERT INTO vid_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","Mbaka ya isi ya hemwe yowa kulawila Bahali ya Shamu mbaka bahali ya Mediteleniyani na kulawila kuchiwala mbaka lwanda lwa Eyufulate, mina ndowawika wenyeng'haye wa isi ayo mmoko mwa hemwe, namwe mowawinga Wafilisti woche. ");
INSERT INTO vid_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","Mleche kudita ilagano lyoneche na hewo ne milungu ja hewo. ");
INSERT INTO vid_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","Mleche kuwakundiza wekale muisi ya hemwe, waleche kuwadita hemwe mnditile gehile, mina wone moiditila milungu ja hewo, ndangukomya ayo yowa chinhu cha kuwagwiliza.” ");
INSERT INTO vid_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Mkulu Nguluwi nakamlonjela Musa, “Muye kwa heni, hegwe na Aluni na Nadabu na Abihu, hamwe na wasekulu makumi saba wa Isilaeli, mfugamile kwa kutali. ");
INSERT INTO vid_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","Hegwe Musa uliyeng'ha ndo kohejelela kwa heni, ila wanji waleche kuya behi na Mkulu Nguluwi, na wanhu waleche kukwina chidunda hamwe na hegwe.” ");
INSERT INTO vid_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Lelo Musa nakaluta na kuwalonjela wanhu weng'ha ulonzi na malajizo geng'ha Mkulu Nguluwi goyamlonjele. Wanhu weng'ha nawedichila kwa lizi limwe, “Mbuli zeng'ha zoyalonjile Mkulu Nguluwi tozidita.” ");
INSERT INTO vid_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Musa nakandika ulonzi weng'ha Mkulu Nguluwi nawoyamlonjele. Hamba nakalilimka mitondo ng'hatu, nakazenga honhu ha kulavila nhambiko hasi ha chidunda na kwimiza mizengo kumi na mili na kiwhana na nhanzi kumi na mbili za Isilaeli. ");
INSERT INTO vid_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","Hamba nakawalajiza wasongolo wa Waisilaeli wamlavile Mkulu Nguluwi nhambiko za kulakazwa na kumlavila nhambiko za kikala goya za milogota milume. ");
INSERT INTO vid_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Musa nakadeha nusu ya danda ya migongolo ajo na kuwika kuli mikuwe, na nusu iyaje nakaboholela hala honhu ha kulavila nhambiko. ");
INSERT INTO vid_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Hamba nakahola chitabu cha ilagano lya Mkulu Nguluwi, nakasoma ulonzi awo weng'ha hali wanhu, nawo nawalonga, “Ago geng'ha goyalonjile Mkulu Nguluwi togadita, natwe towa wanhu wa kuhulichiza.” ");
INSERT INTO vid_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Musa nakahola ayila danda na kuwaboholela wanhu, yolonga, “Ayi ndo danda ya ilagano lya Mkulu Nguluwi yaliditile na hemwe kwa ulonzi awu weng'ha.” ");
INSERT INTO vid_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Hamba, Musa na Aluni na Nadabu na Abihu na wasekulu makumi saba wa Isilaeli nawakwina kuchidunda, ");
INSERT INTO vid_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","nawamona Nguluwi wa Isilaeli. Hasi ha magulu ga heye kwali na honhu hasilibwe kota maganga ga yakuti ilingupulika, iwele buluu kota ulanga. ");
INSERT INTO vid_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Na Nguluwi hawagazile awo vilongozi wa wanhu wa Isilaeli. Nawamona Nguluwi, walya na kunwa. ");
INSERT INTO vid_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Mkulu Nguluwi nakamlonjela Musa, “Uye kwa heni kuchanya kuchidunda, umbeteze ako. Heni ndokupa vibao vya maganga viwele na malajizo na mizilo jonyandiche kwa chiwalo cha kuwalangusa Waisilaeli.” ");
INSERT INTO vid_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Lelo Musa nawaluka hamwe na Yoshua chitumagwa wa heye, nakaluta kuli chidunda cha Nguluwi. ");
INSERT INTO vid_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","Musa nakawalonjela wala wasekulu, “Mtubeteze aha mbaka hotuwahiluchila. Aluni na Huli wa hamwe na hemwe, yoneche yawele na mbuli yawalutile awo.” ");
INSERT INTO vid_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Lelo Musa nakaluta kuchidunda na ng'hungugu naigubika chidunda. ");
INSERT INTO vid_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","Ukulu wa Mkulu Nguluwi naudulika mchanya mchidunda cha Sinai na ng'hungugu naigubika chidunda kwa mhela wa mazuwa sita. Zuwa lya saba Nguluwi nakamchema Musa kulawila hagati ha yila ng'hungugu. ");
INSERT INTO vid_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","Ukulu wa Mkulu Nguluwi nawoneka hali meho ga wanhu wa Isilaeli kota chiluli chilingwaka mchanya mwa chidunda. ");
INSERT INTO vid_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Musa nakenjila mgati mwa yila ng'hungugu, nakakwina kuchidunda. Nakekala ako kwa mhela wa mazuwa makumi gane, nemisi na nechilo. ");
INSERT INTO vid_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","Mkulu Nguluwi nakamlonjela Musa, ");
INSERT INTO vid_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","“Uwalonjele Waisilaeli walavye nhambiko. Kobochela kulawa kwa munhu yoneche yolavya kwa yoneche yalingugana kulavya. ");
INSERT INTO vid_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","Kobochela vinhu kota zahabu na sendi na shaba ");
INSERT INTO vid_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","na sufu ya buluu na ya zambalau na ndung'hu na kitani inojile itawigwe kwa milaika ja mhene ");
INSERT INTO vid_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","na migozi ja ing'holo ilume jiwichigwe lanji ndung'hu na migozi ja migongolo jinji jilingikala mbahali na mbao za msonobali ");
INSERT INTO vid_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","na mafuta kwa chiwalo cha chenje na ndugwa kwa chiwalo cha mafuta ga kubakala na kwa chiwalo cha ubani uwele na unhunyhililo unojile ng'hatu, ");
INSERT INTO vid_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","na maganga galingupulika ga salidoniki na maganga ganji galingupulika kwa chiwalo cha kunoliga, chizibao cha mmhambaga na chihako cha mmhambaga. ");
INSERT INTO vid_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","Wanhu wanzenjele ihema lya Nguluwi leka ndiwe ndichikala hamwe na hewo. ");
INSERT INTO vid_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Mogomanjiza ihema alyo lya Nguluwi na vinhu vya mumo vyeng'ha kota vila ng'hatu vyondiwalajilani. ");
INSERT INTO vid_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","“Waisilaeli wagongomanjize isanduku lya mbao za msonobali na liwele na ulefu wa sentimita miya imwe na kumi na ugazi wa sentimita makumi sita na sita na fudi ya sentimita makumi sita na sita. ");
INSERT INTO vid_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","Kolibakaliza isanduku alyo zahabu inojile mgati na kunze na kuliditila mfungo mwake zahabu zingo zeng'ha. ");
INSERT INTO vid_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","Hamba koligongomanyila pete zine za zahabu na uwiche kuli chila mgulu. Hamba uwiche pete mbili kuli chila ubanzi. ");
INSERT INTO vid_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","Kogongomanjiza mipichilo kwa msonobali na kubakaliza zahabu. ");
INSERT INTO vid_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","Mipichilo ajo jokola kuli pete azo ziwele banzi mbili za alyo isanduku kwa chiwalo cha kulipika. ");
INSERT INTO vid_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","Mipichilo ajo ja isanduku jopona kuli pete, ileche kulavigwa mhela weng'ha ula. ");
INSERT INTO vid_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","Mgati mwa isanduku alyo kowika vibao vya maganga vya ulolezi. ");
INSERT INTO vid_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","“Hamba kogongomanya chigubiko cha uhanyisi cha zahabu inojile, ulefu yowa sentimita miya imwe na kumi na ugazi sentimita makumi sita na sita. ");
INSERT INTO vid_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","Kogongomanyizila kwa kuponda vilumbigwe vifandile kota wahilisi vili kwa zahabu, uviwiche mchanya, mwiso mwa nzingo mbili za acho chigubiko. ");
INSERT INTO vid_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","Chilumbigwe chifandile kota mhilisi chimwe chila mwiso wa chigubiko. Uviwiche vilumbigwe avyo kuli mwisho mwa chigubiko acho, ila viwe chinhu chimwe na acho chigubiko. ");
INSERT INTO vid_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","Chilumbigwe acho chifandile kota mhilisi chochilola chila chiyage na mbawa zawo zigoloche zigubiche chigubiko acho, kumeho kwa avyo vilumbigwe kowa kulola chigubiko acho. ");
INSERT INTO vid_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","Mgati mwa isanduku kowika vibao vili vya maganga na kuchiwika chigubiko acho mchanya mwake. ");
INSERT INTO vid_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","Ndoting'hana na hegwe ako, na kulawa mchanya mwa chigubiko acho, hagati ha vilumbigwe avyo vifandile kota wahilisi viwele mchanya mwa isanduku lya ilagano, ndolongasa na hegwe na kukugalila mizilo jeng'ha kwa chiwalo cha Waisilaeli. ");
INSERT INTO vid_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","“Kogongomanya chisaga cha mbao za msonobali uwele na ulefu wa sentimita makumi nane na nane, ugazi wa sentimita makumi gane na zine na fudi ya sentimita makumi sita na sita. ");
INSERT INTO vid_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","Chisaga acho kochibakaliza zahabu inojile na kuchizungulusila isali lya zahabu. ");
INSERT INTO vid_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","Hamba kochizungulusila chibao chiwele na ugazi wa sentimita nane na kuzungulusila isali lya zahabu. ");
INSERT INTO vid_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","Koigongomanyila pete zine za zahabu na kuziwika mli zingo za magulu gake. ");
INSERT INTO vid_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","Pete azo zowa behi na isali na zowa kwa chiwalo cha kubatilila mipichilo. Mipichilo ajo jowa kwa chiwalo cha kupichila acho chisaga. ");
INSERT INTO vid_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","Kogongomanyiza mipichilo ja msonobali na kuibakaliza zahabu, mipichilo jowa kwa chiwalo cha kupichila acho chisaga. ");
INSERT INTO vid_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","Kogongomanya nyhelo na vizombe vya kuwichila ubani mchisaga na kahi vibuyu na visaye vya kujidila nhambiko za kunwa. Uvidite vinhu avyo vyeng'ha kwa zahabu inojile. ");
INSERT INTO vid_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","Mazuwa gose kowika mibumunda jelile hali chisaga kumwando kwa heni chila mhela. ");
INSERT INTO vid_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","“Kogongomanya chinhu cha kuwichila chenje kwa zahabu inojile. Igongomanywe kwa kuponda, chikalilo chake na mitumba jake na vizombe vyake na uluwa wake vyowa chinhu chimwe. ");
INSERT INTO vid_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","Nhagala sita zolawilila kuli chinhu cha kuwichila chenje, nhagala zidatu ubanzi umwe na nhagala zidatu ubanzi uyage. ");
INSERT INTO vid_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","Kuli nhagala hana vizombe vidatu viwhanile na mitumba na uluwa ulinguchemigwa alimondi. Kuli nhagala ilinguya kahi hana vizombe vidatu viwhanile na mitumba na uluwa ulinguchemigwa alimondi. Nhagala zeng'ha sita ziwhana vivila kuli chinhu cha kuwichila chenje. ");
INSERT INTO vid_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","Na kuli ufito kowa na vizombe vine viwhanile na uluwa ulinguchemigwa alimondi hamwe na itumba lyake na uluwa wake. ");
INSERT INTO vid_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","Honhu halingulawilizila chila jozi ya nhagala zila sita, hasi hake kowa na itumba limwe limwe. ");
INSERT INTO vid_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","Mitumba ajo na nhagala zake jowa chinhu chimwe na chinhu acho cha kuwichila chenje acho, na cheng'ha chopondigwa kwa chihande chimwe cha zahabu inojile. ");
INSERT INTO vid_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","Kogongomanya kahi vyenje saba kwa chiwalo chinhu acho cha kuwichila chenje na kuchiwika mchanya mwake leka chiwe chimwemwesela kumwando. ");
INSERT INTO vid_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","Ugongomanye kahi vinhu vya kuzimila vyenje na nyhelo zake kwa zahabu inojile. ");
INSERT INTO vid_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","Kogongomanya chinhu acho cha kuwichila chenje na vinhu vinji viyage kwa kilogilamu makumi gadatu na zihano za zahabu inojile. ");
INSERT INTO vid_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","Ulole goya kota nakuvigongomanya kota vila navyoulajilwe kula kuchidunda. ");
INSERT INTO vid_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","“Kwa ago geng'ha, kogongomanya ihema lya Nguluwi kwa mipaziya kumi ja kitani itawigwe, na kwa sufu ya lanji ya buluu na zambalau na ndung'hu. Mipaziya ajo jeng'ha kovinoliga kwa vilumbigwe vifandile kota wahilisi, utawigwe goya. ");
INSERT INTO vid_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","Chila ipaziya lyowa na ulefu wa mita kumi na mbili na ugazi wa mita mbili. Mipaziya ajo jeng'ha jiwe chipimilo chimwe. ");
INSERT INTO vid_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Kolumbiza mipaziya jihano liwe limwe na jihano jiyage kahi liwe ipaziya limwe. ");
INSERT INTO vid_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","Kohonela vibatililo vya buluu mlupembo mwa ipaziya lya mwiso lya chihande cha mwaluko, hihyo kohonela vibatililo mwiso mwa lupembo lwa kunze lya chihande chinji cha ipaziya. ");
INSERT INTO vid_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","Kowika vibatililo makumi gahano kuli ipaziya limwe na vibatililo vinji makumi gahano kuli ipaziya lya keli, vibatililo vyeng'ha viwe vichilola. ");
INSERT INTO vid_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","Hamba kogongomanya ngwamo makumi gahano za zahabu leka kulumbizila vila vihande vili vya mipaziya, ahyo ihema lya Nguluwi lyowa chinhu chimwe. ");
INSERT INTO vid_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","“Kahi kogongomanya chigubiko cha ihema lya Nguluwi kwa mipaziya kumi na limwe lya milaika ja mhene. ");
INSERT INTO vid_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","Chila ipaziya lyowa na ulefu wa mita kumi na zidatu, na ugazi wa mita mbili. Mipaziya jeng'ha ajo kumi na limwe jowa na chipimilo chichila. ");
INSERT INTO vid_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","Kolumbiza mipaziya jihano hamwe na mipaziya sita hamwe. Ipaziya lya sita kolibina hali ihema lya Nguluwi. ");
INSERT INTO vid_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","Hamba kodita vibatililo makumi gahano mlupembo lwa ipaziya lya mwiso kwa chihande cha mwaluko na vibatililo makumi gahano mlupembo lwa chihande cha keli. ");
INSERT INTO vid_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","Kodita ngwamo za shaba makumi gahano na kuzinjiza kuli zila ngwamo leka kulumbiza vila vihande vili vya mipaziya na ahyo kudita ipaziya limwe lya ihema. ");
INSERT INTO vid_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","Yila nusu ya ipaziya liponile kolibina lininile ubanzi weng'ha wa kumbele mwa ihema alyo. ");
INSERT INTO vid_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","Ulefu wa ipaziya iwele ya nyonjeza kolibina nusu mita kwa ubanzi umwe na nusu mita iyage ubanzi wunji, leka lininile banzi mbili za ihema kota chigubiko. ");
INSERT INTO vid_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","Kogongomanyiza kahi chigubiko cha ihema ligongomanyigwe kwa igozi lya ing'holo ilume liwichigwe lanji ndung'hu na chigubiko cha igozi lya igongolo linji lilingikala mbahali. ");
INSERT INTO vid_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","“Kogongomanya fulemu za msonobali kwa chiwalo cha kwimiza ihema lya Nguluwi. ");
INSERT INTO vid_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","Chila fulemu yowa na ulefu wa mita zine na ugazi wa sentimita makumi sita na sita. ");
INSERT INTO vid_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","Chila fulemu yowa ilumbizwe na ndimi mbili za kulumbizila. Kozidita fulemu zeng'ha ziwe zilumbigwe na ndimi mbili. ");
INSERT INTO vid_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","Lelo kogongomanya azo fulemu kota hino, fulemu makumi meli kwa chiwalo cha ubanzi wa kusini, ");
INSERT INTO vid_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","na vikalilo makumi gane ga sendi hasi mwa azo fulemu makumi meli, ndimi mbili hasi ha chila fulemu leka kibatilila zila ndimi mbili ziwe hasi ha fulemu yinji leka kibatilila vibatililo vyake vili. ");
INSERT INTO vid_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","Ubanzi wa kasikazini mwa ihema lya Nguluwi, kogongomanya fulemu makumi meli, ");
INSERT INTO vid_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","na vikalilo vyake makumi gane vya sendi, vikalilo vili hasi ya chila fulemu. ");
INSERT INTO vid_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","Kwa ubanzi wa kumbele, uwele kolizibilaga isanya, kogongomanya fulemu sita. ");
INSERT INTO vid_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","Kogongomanya kahi fulemu mbili kwa chiwalo cha nzingo za ihema ubanzi wa kumbele. ");
INSERT INTO vid_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","Fulemu azo za nzingo zilekane hasi ila zileche kibatanizwa kwa kuchanya hali pete ya mwaluko. Fulemu zeng'ha za nzingo ziditigwe hihyo leka zidite nzingo mbili. ");
INSERT INTO vid_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","Ahyo kowa na fulemu nane hamwe na vikalilo vyake kumi imwe na sita vya sendi, vikalilo vili hasi ha chila fulemu. ");
INSERT INTO vid_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","“Kogongomanya migamba ja msonobali, migamba jihano kwa chiwalo cha fulemu za ubanzi umwe wa ihema lya Nguluwi, ");
INSERT INTO vid_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","na migamba jihano kwa chiwalo cha fulemu ya ubanzi wa keli wa ihema na migamba jihano kwa chiwalo cha fulemu za ubanzi wa kumbele mwa ihema lya Nguluwi, uwele kolizinjila isanya. ");
INSERT INTO vid_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","Mgamba wa hagati ufichile nusu ya fulemu ya ihema wokola hagati kulawila mwiso awu mbaka mwiso uyage wa ihema. ");
INSERT INTO vid_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","Fulemu zeng'ha kozibakaliza zahabu na kuziditila pete za zahabu kwa kibatilila ajo migamba, nazo kahi kozibakaliza zahabu. ");
INSERT INTO vid_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","Ahyo kogongomanya ihema lya Nguluwi kwa kuwinza vyondikulajile kuchidunda. ");
INSERT INTO vid_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","“Kogongomanya ipaziya lya lanji ya buluu na zambalau na ndung'hu na kitani inojile itawigwe. Ipaziya alyo kolitawa kwa uwanzi kwa kuvinoliga kwa vilumbigwe vifandile kota wahilisi. ");
INSERT INTO vid_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","Kolinhinhiza ipaziya kuli mizengo jine ja msonobali zibakalizwe zahabu, ziwele ngwamo za zahabu na vikalilo vine vya sendi. ");
INSERT INTO vid_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","Kolinhinhiza ipaziya alyo kuli ngwamo, hamba uligale lila isanduku lya ilagano amo mgati, kumbele mwa ipaziya alyo. Ipaziya alyo lyogawaniza Honhu Helile na Honhu Helile Ng'hatu. ");
INSERT INTO vid_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","Mgati mwa Honhu Helile Ng'hatu kowika chigubiko cha uhanyisi mchanya mwa isanduku lya ilagano. ");
INSERT INTO vid_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","Achila chisaga kochiwika ubanzi wa kunze mwa ipaziya alyo, na chila chinhu cha kuwichila chenje kochiwika ubanzi wa kusini mwa ihema lya Nguluwi, lichilola na chisaga. Chisaga acho chowa ubanzi wa kasikazini. ");
INSERT INTO vid_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","“Kwa chiwalo cha lwizi lwa ihema kogongomanya ipaziya lya lanji ya buluu na zambalau na ndung'hu na kitani inojile itawigwe kwa uwanzi. ");
INSERT INTO vid_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","Kwa chiwalo cha ipaziya, kogongomanya mizengo jihano ja msonobali na kubakaliza zahabu. Mizengo ajo jowa na ngwamo za zahabu na chila limwe lyowa na chikalilo cha shaba. ");
INSERT INTO vid_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","“Kogongomanya honhu ha kulavila nhambiko kwa mbao za msonobali. Honhu ha kulavila nhambiko aho howa ha mlaba, ulefu mita mbili na lobo na ugazi mita mbili na lobo na fudi yowa mita imwe na lobo. ");
INSERT INTO vid_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","Nagwe udite mbalati imwe kuli chila nzingo, azo mbalati zowa chinhu chimwe na honhu ha kulavila nhambiko, nagwe kohagubika honhu heng'ha kwa shaba. ");
INSERT INTO vid_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","Kogongomanya visaye vyake vya kusila mivu na mihuka na visaye vyake na mibano jake na visaye vya kuholela makala, na vinhu vyeng'ha kovidita kwa shaba. ");
INSERT INTO vid_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","Hamba kogongomanya utandawala wa shaba uwele na pete zine za shaba kuli nzingo zake. ");
INSERT INTO vid_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","Utandawala awo kouwika hafungo halinguzunguluta honhu ha kulavila nhambiko ubanzi wa hasi leka awo utandawala ufiche hagati ha honhu ha kulavila nhambiko. ");
INSERT INTO vid_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","Nagwe udite mipichilo ja msonobali kwa chiwalo cha honhu ha kulavila nhambiko, najo kojibakaliza shaba. ");
INSERT INTO vid_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","Na mipichilo ajo jokwinjizwa mli pete chila nzingo ya honhu ha kulavila nhambiko mhela wa kupika. ");
INSERT INTO vid_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","Kogongomanya honhu ha kulavila nhambiko kwa mbao na hawe na lukweme mgati kota vila navyondikulajile kula kuchidunda. ");
INSERT INTO vid_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","“Kogongomanya lugagala lwa ihema lya Nguluwi. Kuli ubanzi wa kusini mwa lugagala kowa na ipaziya ligongomanyigwe kwa kitani inojile itawigwe uwele na ulefu wa mita makumi gane na zine kwa ubanzi umwe. ");
INSERT INTO vid_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","Ipaziya alyo lyobatililwa na mizengo makumi meli ga shaba jiwele na vikalilo vya shaba. Ila fito za mizengo ajo na vibatililo vyowa vya sendi. ");
INSERT INTO vid_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","Hihyo du ubanzi wa kasikazini, ulefu wa ipaziya wowa mita makumi gane na zine, na mizengo jake makumi meli ja shaba, ila fito za mizengo na vibatililo zake vyowa vya sendi. ");
INSERT INTO vid_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","Ubanzi wa kolizibilaga isanya wa lugagala kowa na ipaziya liwele na ulefu wa mita makumi meli na mbili, na mizengo jake kumi na vikalilo vyake kumi. ");
INSERT INTO vid_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","Ubanzi wa kolilawilaga isanya kuwele na lwizi, lugagala lowa na ugazi wa mita makumi meli na mbili. ");
INSERT INTO vid_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","Ipaziya lizidahe lya ubanzi umwe wa lwizi lyowa na ugazi wa mita sita na nusu, hamwe na mizengo jidatu na vikalilo vyake vidatu. ");
INSERT INTO vid_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","Vivila kuli ubanzi uyage wa lwizi ipaziya lyowa na mita sita na nusu, hamwe na mizengo jidatu na vikalilo vyake vidatu. ");
INSERT INTO vid_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","Lwizi alo lwa lugagala lowa na ipaziya liwele na ulefu wa mita tisa, ligongomanyigwe kwa sufu ya lanji ya buluu na zambalau na ndung'hu na kitani inojile itawigwe goya. Ipaziya alyo lyobatigwa na mizengo jine jiwele na vikalilo vine. ");
INSERT INTO vid_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","Mizengo jeng'ha kuzunguluta lugagala jolumbizwa kwa fito za sendi na ngwamo zake zowa za sendi na vikalilo vyake vyowa vya shaba. ");
INSERT INTO vid_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","Lugagala alo lowa na ulefu wa mita makumi gane na zine na ugazi wa mita makumi meli na mbili na fudi ya mita mbili na lobo. Ipaziya lyake lyowa lya kitani inojile na vikalilo vyake vya shaba. ");
INSERT INTO vid_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","Vinhu vyeng'ha vya ihema lya Nguluwi vya kuditila chila chinhu, hamwe na vigingi vyeng'ha na vila vya lugagala vyeng'ha vyowa vya shaba. ");
INSERT INTO vid_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","“Kowalonjela Waisilaeli wakugalile mafuta ganojile ga mzeituni gakamigwe, kwa chiwalo cha vyenje, leka kuwe na chenje chilingwaka chila mhela. ");
INSERT INTO vid_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","Ayo yowa mgati mwa ihema lya Nguluwi kunze mwa ipaziya alyo kumwando kwa isanduku lya ilagano, Aluni na wanage wochilolela hali heni kulawila mhela wa kuzinga kwa isanya mbaka mitondo hali Mkulu Nguluwi. Ilajizo alino lyanguganigwa liwinzwe mazuwa gose na Waisilaeli weng'ha, lulelo kwa lulelo. ");
INSERT INTO vid_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","“Nagwe Musa, umigale kwa heni mng'holozo Aluni, hamwe na wanage, Nadabu na Abihu na Eleasali na Itamali, kulawa kuli Waisilaeli, leka wang'holele mijito kota watambika. ");
INSERT INTO vid_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","Komhonela mng'holozo Aluni nguwo zelile leka yawe yokoneka yawele na ukulu na yanojile. ");
INSERT INTO vid_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","Walajize wawanzi weng'ha wala ndiwapele uwanzi wamhonele Aluni nguwo yelile leka yawichigwe yawe wa chiuyeng'ha kwa chiwalo cha mijito ja utambika wa heni. ");
INSERT INTO vid_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","Walonjele wamgongomanyile mivalo jelile ajino, chihako cha mmhambaga na chizibao na ijoho na ikanzu linoligwe na chipembelo na isali lya kuvala mchuno. Aluni mng'holozo na wanage wogavala leka wang'holele mijito kota watambika. ");
INSERT INTO vid_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","Awo wawanzi wobochela zahabu na nguwo ya lanji ya buluu na zambalau na ya lanji ndung'hu na nguwo ya kitani inojile. ");
INSERT INTO vid_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","“Wogongomanya chizibao kwa ng'weso za zahabu na sufu ya lanji ya buluu na zambalau na ndung'hu na kitani inojile, itawigwe na kunoligwa chiuwanzi. ");
INSERT INTO vid_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","Chowa na ng'weso mbili za kuwohela mmayega, zohonelwa hamwe mli lupembo lwake lwili. ");
INSERT INTO vid_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","Isali lya kibatilila loditikwa kwa vinhu vivyo, kwa ng'weso za zahabu na sufu ya buluu na zambalau na ndung'hu na kuwa chinhu chimwe na chizibao acho. ");
INSERT INTO vid_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","“Hamba kohola maganga galingupulika meli galinguchemigwa salidoniki goukwandichila mchanya mwake matagwa ga wana wa Isilaeli. ");
INSERT INTO vid_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","Matagwa sita kuli iganga limwe na matagwa gayage sita kuli iganga liyage, kwa kuwinza vyowapondigwe. ");
INSERT INTO vid_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","Kogandika gala matagwa ga nhanzi za Waisilaeli mchanya mwa gala maganga kota vila yalinguchola muhuli, hamba uganolige na ugenjize mli vibatililo vya zahabu. ");
INSERT INTO vid_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","Maganga ago meli gowichigwa mchanya mwa mayega kuli vihande vya chizibao kota vila ukumbuso wa nhanzi kumi na mbili za Isilaeli. Ahyo Aluni kovala matagwa ago mchanya mmayega ga heye hali heni Mkulu Nguluwi, gawe kota vila ukumbuso. ");
INSERT INTO vid_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","Kochigongomanyila vibatililo vili vya zahabu, ");
INSERT INTO vid_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","na mikufu mili ja zahabu inojile ya kutawigwa kota vila ng'weso. Nagwe kojilumbaniza mikufu ajo na vila vibatililo. ");
INSERT INTO vid_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","“Kogongomanya chihako cha mmhambaga cha utaguso, chiditikwe kwa uwanzi ng'hatu kiwhana kota vyochiditikwe chila chizibao, kwa zahabu na kwa sufu ya lanji ya buluu na ya zambalau na ndung'hu na kitani inojile itawigwe. ");
INSERT INTO vid_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","Chihako acho chiwele chibinigwe chowa mlaba, sentimita makumi meli na mbili. ");
INSERT INTO vid_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","Chonoligwa kwa misitali jine ja maganga ga sendi nyinji. Msitali wa mwaluko gowa maganga ga akiki na topazi na alimasi ndung'hu, ");
INSERT INTO vid_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","msitali wa keli gowa maganga ga zumalidi na yakuti ya samawati na alimasi, ");
INSERT INTO vid_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","msitali wa kadatu gowa maganga ga yasinto na agate na ametisto, ");
INSERT INTO vid_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","na msitali wa kane gowa maganga ga zabalajadi na shohamu na yasipi, geng'ha gowichigwa vibatililo vya zahabu. ");
INSERT INTO vid_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","Lelo kowa na maganga kumi na meli gacholigwe matagwa kumi na meli ga Waisilaeli. Chila limwe lyowa na itagwa limwe kota muhuli, kwa kulajila zila nhanzi kumi na mbili. ");
INSERT INTO vid_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","“Kwa chiwalo cha chila chihako cha mmhambaga, kogongomanya mikufu ja zahabu inojile itawigwe kota ng'weso. ");
INSERT INTO vid_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","Vivila kodita pete mbili za zahabu kwa chiwalo cha chihako cha mmhambaga na kuziwika mli nzingo mbili za chihako acho, ");
INSERT INTO vid_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","na mikufu mili ja zahabu ujiwohe mli pete azo za chihako acho cha mmhambaga. ");
INSERT INTO vid_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","Mwaluko na mwiso wa mikufu mili ja zahabu kozibatiza kuli vila vibatililo vili leka zichibate na chihande cha mmayega cha chihako ubanzi wa kumwando. ");
INSERT INTO vid_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","Kahi kogongomanya pete mbili za zahabu na kuziwika mli nzingo mbili za hanyi, banzi ya mgati mwa chihako cha mmhambaga behi na chizibao. ");
INSERT INTO vid_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","Hamba kogongomanya pete mbili zinji za zahabu na kuziwika kuli honhu heli ha hanyi, kumwando mwa vihande vya chizibao mmayega, honhu chihako cha mmhambaga hochilinguting'hana, mchanya mwa isali litawigwe kwa uwanzi ng'hatu. ");
INSERT INTO vid_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","Chihako cha mmhambaga chowohigwa kuli chizibao kwa kuting'haniza pete zake na chizibao kwa ng'weso ya lanji ya buluu, leka chihako acho cha mmhambaga chikale goya kuli lila isali litawigwe kwa uwanzi. ");
INSERT INTO vid_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","“Aluni hoyokwinjila kuli honhu helile, kovala chihako cha mmhambaga cha utaguso chicholigwe matagwa ga nhanzi za Waisilaeli, kwa mbuli ayo, heni Mkulu Nguluwi siwasemwa hewo ng'oo. ");
INSERT INTO vid_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","Mojela Ulimu na Sumimu kuli chila chihako cha mmhambaga cha lwamulilo, na azo zowa mchanya mwa nhumbula ya Aluni, aho hoyokwinjila mgati kumwando kwa Mkulu Nguluwi. Aluni kohola utaguso wa hewo wana wa Isilaeli mchanya mwa nhumbula ya heye, kumwando kwa Mkulu Nguluwi chila mhela. ");
INSERT INTO vid_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","“Kohona ijoho lya kuvalila chihako kwa sufu ya lanji ya buluu. ");
INSERT INTO vid_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","Lyowa na honhu ha kwinjizila mutwi hagati na honhu aho kozungulusilwa ng'weso itawigwe leka ileche kudejeka. ");
INSERT INTO vid_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","Kuli lupindo lwa kunyhiga kuzunguluta banzi zeng'ha, konoligwa kwa mafuza gachemigwe makomamanga ga lanji ya buluu na zambalau na ndung'hu, kowa kahi na nhogo za zahabu hagati mwa ago makomamanga, ");
INSERT INTO vid_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","komamanga na nhogo, komamanga na nhogo, kuzunguluta ijoho lyeng'ha. ");
INSERT INTO vid_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","Aluni kovala ijoho alyo kukola mijito ya heye ya utambika na lizi lya nhogo za heye lyohulikwa mhela hoyokwinjila kuli honhu helile kumwando kwa Mkulu Nguluwi na mhela hoyolawa, nhogo azo zohulikwa na heye hokopoligwa hebu. ");
INSERT INTO vid_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","“Hamba kodita chibati cha zahabu inojile na kwandika mchanya mwake kota munhu vyoyalingwandika muhuli, ‘Yelile kwa Mkulu Nguluwi.’ ");
INSERT INTO vid_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","Chibati acho kochiwoha kumwando mwa chipembelo kwa ng'weso ya buluu. ");
INSERT INTO vid_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","Aluni kochivala chibati acho kuli chihanga cha heye, kwa acho chibati kohola nongwa ya wihe uwele hanji ukoligwe na Waisilaeli kuli kumlavila Mkulu Nguluwi nhambiko, nani ndozikunda nhambiko za hewo zelile. Kochivala acho chibati kwa chila mhela. ");
INSERT INTO vid_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","“Komgongomanyila Aluni ikanzu linoligwe kwa kitani inojile na kumtawila chipembelo cha kitani inojile na isali litawigwe goya. ");
INSERT INTO vid_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","“Kowagongomanyila wana wa Aluni mijoho na misali na kofia leka woneche wana ukulu na kunoga. ");
INSERT INTO vid_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","Komvaliza Aluni na wang'holoze mivalo ajo, hamba uwabakalize mafuta na kuwawika kuli mijito yelile na kuwadita wawe wa chiuyeng'ha leka wakole mijito kota watambika. ");
INSERT INTO vid_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","Vivila kowahonela lupati za kitani ziwagubika mchuno mbaka mmahaza, leka wagubiche umwazi wa hewo. ");
INSERT INTO vid_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","Aluni na wanage wovala lupati chila howokwinjila kuli ihema lya Nguluwi, ama howohejelela kuli honhu ha kulavila nhambiko, kuwatanza watambika kuli honhu ha kulavila nhambiko mgati mwa honhu helile. Kwa nzila ayo hawolajila umwazi wa hewo ne kuwa na nongwa na kukopoligwa. Alyo lyowa ilajizo lya mazuwa gose lya Aluni na walelwa wa heye. ");
INSERT INTO vid_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","“Azi ndo mbuli zouwaditila Aluni na wanage leka kuwawika wawe wa chiuyeng'ha wanditile kota watambika. Kohola ilogota ilume limwe na ming'holo milume mili jilihela nongwa yoneche yila, ");
INSERT INTO vid_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","mibumunda johajiwichigwe usaso, miandazi jilihela usaso jivujigwe kwa mafuta na mibumunda mizisili johajiwichigwe usaso, ila jibakalizigwe mafuta. Vyeng'ha avi viwe viditikwe kwa utimbo unojile wa ngano. ");
INSERT INTO vid_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","Hamba ujiwiche ajo mibumunda mgati mwa chidoto chimwe na kundavila mhela umwe na lila ilogota na jila ming'holo milume mili. ");
INSERT INTO vid_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","“Hamba uwahiliche Aluni na wanage hali lwizi lwa ihema lya Nguluwi na kuwahovuga kwa mazi. ");
INSERT INTO vid_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","Hamba kohola zila nguwo za chiutambika umvalize Aluni, ikanzu na ijoho na chizibao na chihako cha mmhambaga na kumuwoha lila isali litawigwe kwa uwanzi ng'hatu. ");
INSERT INTO vid_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","Kahi komvaliza chila chipembelo chelile kumutwi na kuwika mchanya mwa acho chipembelo chibati cha zahabu. ");
INSERT INTO vid_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","Lousinda kudita ago, kohola gala mafuta ga kubakala, umjidile Aluni kumutwi mwake. ");
INSERT INTO vid_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","“Hamba kowegala wana wa Aluni na kuwavaliza mikanzu. ");
INSERT INTO vid_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","Kowawoha misali mchuno mwao na kuwavaliza kofiya za hewo. Ahyo ndo vyouwadita Aluni na wanage wawe wakola mijito yelile. Awo wowa watambika mazuwa gose. ");
INSERT INTO vid_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","“Hamba koligala lila ilogota ilume kumwando kwa ihema lya Nguluwi. Aluni na wanage wowika moko ga hewo mchanya mwa mutwi wa alyo ilogota, ");
INSERT INTO vid_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","na kulidumula singo kumwando kwa Mkulu Nguluwi, hali lwizi lwa ihema lya Nguluwi. ");
INSERT INTO vid_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","Kohola chasi cha danda ya ilogota alyo na kubakaliza mli mbalati za honhu ha kulavila nhambiko kwa chidole cha hegwe na danda yeng'ha isigale koibohola hasi ha honhu ha kulavila nhambiko. ");
INSERT INTO vid_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","Hamba kohola mafuta geng'ha galingugubika mitumbu na honhu hanojile ng'hatu ha chini hamwe na figo mbili na mafuta gake, uvilakaze vyeng'ha mchanya mwa honhu ha kulavila nhambiko. ");
INSERT INTO vid_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","Ila miwunde ja ilogota alyo hamwe na migozi na midohe jake kovihola na kuvilakaza kwa chiluli kunze mwa kambi. Ayi yowa nhambiko ya kusa gehile. ");
INSERT INTO vid_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","“Hamba kolihola limwe lya jila ming'holo milume na kumlonjela Aluni na wanage wawiche moko gawo mchanya mwa mutwi wake. ");
INSERT INTO vid_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","Nagwe kolidumula singo na danda yake koboholela kuli honhu ha kulavila nhambiko kuli banzi zake zeng'ha. ");
INSERT INTO vid_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","Hamba kolidumula alyo ing'holo ilume kuli vihandevihande, kohovuga mitumbu jake na magulu gake ugawiche geng'ha hamwe na mutwi na vihande vinji. ");
INSERT INTO vid_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","Hamba kolilakaza ing'holo ilume lyeng'ha mchanya mwa honhu ha kulavila nhambiko, leka kundavila nhambiko ya kulakaza, kunhunyhilila kwa nhambiko yoilingulavigwa kwa chiluli yonojeza heni Mkulu Nguluwi. ");
INSERT INTO vid_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","“Kolihola lila ing'holo ilume linji, na heye Aluni na wanage wowika moko ga hewo mchanya mwa mutwi wake. ");
INSERT INTO vid_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","Nagwe kolidumula singo na kuhola chasi cha danda na kumbakaliza Aluni na wanage kuli makutu ga hewo ga kudilo na vidole vikuluwawo vya moko ga hewo ga kudilo na vidole vikuluwawo vya magulu ga hewo ga kudilo. Danda isigale koimizila kuli honhu ha kulavila nhambiko banzi zeng'ha. ");
INSERT INTO vid_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","Hamba kohola chasi cha danda iwele mchanya mwa honhu ha kulavila nhambiko hamwe na gala mafuta ga kubakala, ummizile Aluni na nguwo za heye, uwamizile kahi wanage na nguwo za hewo. Aluni na wanage wowa welile kwa heni hamwe na nguwo za hewo zeng'ha. ");
INSERT INTO vid_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","“Hamba kohola mafuta ago ga ing'holo ilume na mchila wake na mafuta galingugubika mitumbu na honhu hanojile ng'hatu ha chini na figo zake mbili na mafuta gake hamwe na chima cha kudilo. Ing'holo alyo ndo ing'holo lya kuwichigwa kwa mijito yelile. ");
INSERT INTO vid_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","Kulawila kuli chila chidoto cha mibumunda johajiwichigwe usaso jiwele kumwando kwa heni Mkulu Nguluwi, kohola ibumunda limwe na liandazi limwe liwichigwe mafuta na ibumunda lizisili limwe. ");
INSERT INTO vid_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","Vyeng'ha avi komigalila Aluni na wana wa heye kuli moko ga hewo na wovinula kuchanya kwa ulajilo wa kundavila nhambiko ya kwinula kuchanya heni Mkulu Nguluwi. ");
INSERT INTO vid_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","Hamba kovihola kahi kulawa mmoko mwawo na kuvilakaza mchanya mwa honhu ha kulavila nhambiko hamwe na ila nhambiko ya kulakazwa, viwe kunhunyhilila kunojile kuwele konojeza heni Mkulu Nguluwi. Ayo ndo nhambiko yoilingulavigwa kwa chiluli. ");
INSERT INTO vid_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","“Hamba kohola mhambaga ya alyo ing'holo lya kumuwika Aluni kuli mijito yelile, na kwinula kuchanya kwa ulajilo wa kundavila nhambiko ya kwinula kuchanya heni Mkulu Nguluwi. Ayo mhambaga yowa honhu ha hegwe. ");
INSERT INTO vid_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","Uwiche chiuyeng'ha vihande vya ing'holo ilume vilavigwe kwa mijito yelile ya utambika. Avi ndo mhambaga iwele ndo nhambiko ya kwinula kuchanya na chima chiwichigwe chiuyeng'ha. Mhambaga ndo kwa Aluni na chima ndo kwa wanage. ");
INSERT INTO vid_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","Ahyo Waisilaeli wohola vihande avyo mazuwa gose kulawa kuli nhambiko za hewo za kikala goya zowalingundavila heni Mkulu Nguluwi na kumgalila Aluni na wana wa heye. Ayo ndo nhambiko ya hewo kwa Mkulu Nguluwi. ");
INSERT INTO vid_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","“Aluni hoyobagama, mivalo ja heye jelile wopegwa lulelo lwa heye, na hewo wogavala zuwa lya hewo lya kubakalizwa mafuta na kuwawika kuli mijito yelile. ");
INSERT INTO vid_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","Mwana wa Aluni hoyowa mtambika honhu ha mhaza wa heye kojivala mivalo ajo mazuwa saba kuli ihema lya Nguluwi, leka kukolela mijito kuli honhu helile. ");
INSERT INTO vid_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","“Kohola iwunde lya alyo ing'holo ilume lya kuliwika kwa mijito yelile na kulihemsila kuli honhu hawichigwe chiuyeng'ha. ");
INSERT INTO vid_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","Hamba Aluni na wana wa heye, wolya iwunde alyo lya ing'holo ilume hali lwizi lwa ihema lya Nguluwi hamwe na jila mibumunda jisigale hamwande mli chidoto. ");
INSERT INTO vid_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","Wolya miwunde ajo jilavigwe kwa chiwalo cha uhanyisi na kuwawika kuli mijito yelile na kwa chiwalo cha kuwawika chiuyeng'ha, ila munhu yunji yaleche kukundigwa kulya miwunde ajo kwa vila ndo jelile. ");
INSERT INTO vid_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","Wone iwunde lyoneche ama mibumunda ajo vyosigala mbaka mitondo, lelo kojilakaza kwa chiluli, wanhu waleche kulya mina ndo chinhu chelile. ");
INSERT INTO vid_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","“Ahyo ndo vyouwaditila Aluni na wana wa heye kwa chiwalo cha vyeng'ha vila vyondikulonjele, kowawika kwa chiwalo cha mijito yelile kwa mazuwa saba, ");
INSERT INTO vid_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","na chila zuwa kolavya ibuguma liwe nhambiko ya gehile kwa chiwalo cha uhanyisi na kwa kudita ahyo kohadita honhu ha kulavila nhambiko hawe helile, hamba kohajidila mafuta leka kuhawika hawe honhu ha chiuyeng'ha. ");
INSERT INTO vid_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","Kwa mazuwa saba kohaditila uhanyisi honhu ha kulavila nhambiko na kuhawika hawe ha chiuyeng'ha. Hamba, honhu ha kulavila nhambiko howa helile ng'hatu na choneche chidoliza chowa chelile. ");
INSERT INTO vid_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","“Chila zuwa, mhela weng'ha woukuya, kolavila nhambiko ya ming'holo myana milume mili jiwele na mwaka umwe mchanya mwa honhu ha kulavila nhambiko. ");
INSERT INTO vid_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","Ing'holo lyana limwe kolilavya mitondo na liyage kolilavya mhela wa kuzinga kwa isanya. ");
INSERT INTO vid_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","Hamwe na ing'holo lyana lya mwaluko, kolavya utimbo unojile kilo imwe ihanzigwe na lita imwe ya mafuta ganojile na lita imwe ya divai kota nhambiko ya chakunwa. ");
INSERT INTO vid_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","Hihyo na lila ing'holo lyana liyage lya mhela wa kuzinga kwa isanya kolilavila nhambiko hamwe na nhambiko ya nyhule na chakunwa kota vyouditile mitondo, kunhunyhilila kwa ayo nhambiko yoilingulavigwa kwa chiluli yonojeza heni Mkulu Nguluwi. ");
INSERT INTO vid_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","Nhambiko ayi ya kulakazwa yolavigwa mazuwa gose, lulelo mbaka lulelo, kumwando kwa heni Mkulu Nguluwi, kumwando mwa ihema lya Nguluwi kuwele heni ndoting'hana na hemwe na kulongasa na hemwe. ");
INSERT INTO vid_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","Aho ndo honditing'hana na Waisilaeli na ukulu wa heni wohadita hawe helile. ");
INSERT INTO vid_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","Ihema lya Nguluwi na honhu ha kulavila nhambiko ndovidita viwe vya chiuyeng'ha, hihyo Aluni na wana wa heye ndowawika wawe wa chiuyeng'ha leka wang'holele mijito kota watambika. ");
INSERT INTO vid_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","Ndochikala hagati ha Waisilaeli, na heni ndowa Nguluwi wa hewo. ");
INSERT INTO vid_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","Aho ndo wovizela kota heni nda Mkulu Nguluwi, Nguluwi wa hewo, ndiwegale hewo kulawa isi ya Misili, leka ndikale hagati ha hewo. Heni ndo Mkulu Nguluwi, Nguluwi wa hewo. ");
INSERT INTO vid_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","“Kogongomanya honhu ha kulavila nhambiko kwa mbao za msonobali leka hawe honhu ha kufunyizila ubani. ");
INSERT INTO vid_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","Honhu ha kulavila nhambiko aho hawe ha mlaba, ulefu na ugazi viwe sentimita makumi gane na zihano na fudi yake iwe sentimita makumi tisa. Mbalati zake za kuchanya zolawilila zeng'ha ziwa chinhu chimwe na honhu ha kulavila nhambiko. ");
INSERT INTO vid_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","Heng'ha kohabakaliza zahabu inojile, ubanzi wa kuchanya na banzi zake zeng'ha za mlubavu na mbalati zake, kahi kohazungulusila msitali wa isali lya zahabu. ");
INSERT INTO vid_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","Kogongomanya pete mbili za zahabu na kuziwika hasi ha lusila lwake kuli banzi mbili zilingilola, azo pete zobatilila mipichilo mhela wa kupika. ");
INSERT INTO vid_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","Mipichilo ajo jiwe ja msonobali na jibakalizwe zahabu. ");
INSERT INTO vid_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","Aho honhu ha kulavila nhambiko hawichigwe kumwando mwa ipaziya lilingugubika isanduku lya ilagano, kumwando kwa chigubiko cha uhanyisi. Aho ndo honditing'hana na hegwe. ");
INSERT INTO vid_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","Chila zuwa Aluni hoyokwinjila kuwika goya vyenje viwele aho, kofunyiza ubani ulingunhunyhilila lukami hali honhu ha kulavila nhambiko. ");
INSERT INTO vid_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","Kahi kofunyiza ubani mhela wa kuzinga kwa isanya hoyobwina vyenje hali Mkulu Nguluwi. Nhambiko ayi ya ubani yolavigwa mazuwa gose ne kuleka kuli lulelo lwenu lweng'ha. ");
INSERT INTO vid_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","Kuli honhu aho ha kulavila nhambiko, mfunyize ubani ukundigwe hela na mleche kulavya nhambiko ya kulakazwa ne nhambiko ya nyhule ne kujida mchanya mwa honhu aho ha kulavila nhambiko ya chakunwa mchanya. ");
INSERT INTO vid_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","Aluni kanguganigwa kudita uhanyisi mchanya mwa mbalati za honhu ha kulavila nhambiko aho mala imwe kwa mwaka. Kokusa gehile kwa danda ya nhambiko mala imwe chila mwaka kuli lulelo lwa hemwe lweng'ha mina honhu ha kulavila nhambiko aho ndo helile ng'hatu kwa heni Mkulu Nguluwi.” ");
INSERT INTO vid_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","Mkulu Nguluwi nakamlonjela Musa, ");
INSERT INTO vid_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","“Chila houwawaza Waisilaeli, chila yumwe kolipa chasi cha sendi kwa chiwalo cha muhe wa heye hali Mkulu Nguluwi leka kuleche kuwa na matamwa gehile hali hewo mhela wa kuwazigwa. ");
INSERT INTO vid_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","Chila yumwe yowazigwa imgana kuhilula chasi cha sendi chilinguganigwa kwa chipimilo cha ihema lya Nguluwi. Ayi ndo nhambiko ya heye yondavila heni Mkulu Nguluwi. ");
INSERT INTO vid_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Chila yumwe hoyowazigwa, kulawa miyaka makumi meli na kulutilila, kondavila nhambiko ayo ya Mkulu Nguluwi. ");
INSERT INTO vid_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","Yawele na lufufu yaleche kulavya ng'hatu ne mzunwa yaleche kulavya kupungula kwa nusu ya chasi chilinguganigwa, leka vyowolavya ayo nhambiko ya Mkulu Nguluwi, leka kudita uhanyisi kwa chiwalo cha ukomu wa hewo. ");
INSERT INTO vid_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","Hegwe kobochela sendi ayo ya kusa gehile kulawa kwa Waisilaeli, nagwe koiditila mijito ja ihema lya Nguluwi, leka iwe kukumbuchila kwa Waisilaeli hali Mkulu Nguluwi, kwa chiwalo cha kudita uhanyisi kwa ukomu wa hemwe.” ");
INSERT INTO vid_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","Mkulu Nguluwi nakamlonjela Musa, ");
INSERT INTO vid_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","“Kogongomanya likuwe lya shaba lya kuhovujila liwele na chikalilo cha shaba, uliwiche hagati mwa ihema lya Nguluwi na honhu ha kulavila nhambiko na kuwika mazi mgati mwake. ");
INSERT INTO vid_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","Aluni na wana wa heye wohovuga moko na magulu kwa mazi ago, ");
INSERT INTO vid_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","lowang'hali kwinjila mgati mwa ihema lya Nguluwi ama kuwa behi na honhu ha kulavila nhambiko leka kundavila nhambiko heni Mkulu Nguluwi, nhambiko zozilavigwa kwa chiluli. Wodita ahyo waleche kubagama. ");
INSERT INTO vid_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","Igana wahovuje moko na magulu ga hewo waleche kubagama. Ali lyowa ndo ilajizo kwa hewo mazuwa gose, kulawa Aluni na lulelo lwa heye na lulelo lweng'ha.” ");
INSERT INTO vid_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","Mkulu Nguluwi nakamlonjela Musa, ");
INSERT INTO vid_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","“Kohola ndugwa zinojile ng'hatu za kuhanzanya, manemane ya mazi kilo sita na mdalasini ulingunhunyhilila goya kilo zidatu na maguwa gawele na kunhunyhilila goya kilo zidatu ");
INSERT INTO vid_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","na mafuta ga mzeituni na mdalasini yinji kilo sita. Avyo vyeng'ha viwinze chipimilo cha ihema lya Nguluwi, uhole kahi lita zine za mafuta. ");
INSERT INTO vid_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","Kwa vinhu avyo, kogongomanya mafuta gelile na uhanzanye kota vyoyalingudita mgongomanyi wa mafuta galingunhunyhilila goya. Mafuta ago ga kubakala gowa gelile. ");
INSERT INTO vid_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","Hamba kojidila mafuta ago kuli ihema lya Nguluwi na isanduku lya ilagano ");
INSERT INTO vid_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","na chisaga na vinhu vyeng'ha na chinhu cha kuwichila chenje na vinhu vyeng'ha na honhu ha kulavila nhambiko ha kufunyizila ubani ");
INSERT INTO vid_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","na honhu ha kulavila nhambiko za kulakazwa na vinhu vyeng'ha na likuwe na chikalilo chake. ");
INSERT INTO vid_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","Koviwika viwe vya chiuyeng'ha leka viwe vyelile ng'hatu. Choneche chividoliza vinhu avyo, chowa chelile. ");
INSERT INTO vid_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","Hamba mbakalize mafuta Aluni na wana wa heye na kuwawika wawe wa chiuyeng'ha leka wang'holele mijito yelile kota watambika. ");
INSERT INTO vid_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","Walonjele Waisilaeli kota aga ndo gowa mafuta ga heni gelile ga kubakaliza kuli lulelo lwa hemwe lweng'ha. ");
INSERT INTO vid_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","Mafuta aga galeche kujidilwa munhu yoneche wa hihi hela na galeche kugongomanywa mafuta ganji kota aga, aga ndo mafuta gelile na igana mgalolele kota gelile kwa hemwe. ");
INSERT INTO vid_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","Yoneche yogongomanya mafuta kota aga, ama kumbakaliza munhu yohambe yaganigwe kubakalizwa mafuta aga, munhu ayo kobaguligwa kutali na wanhu wa heye.” ");
INSERT INTO vid_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","Mkulu Nguluwi nakamlonjela Musa, “Kohola vipimilo vyoviwhanile na ndugwa zilingunhunyhlila kota azi, unhomvu wa natafi na unhomvu wa shekeleti na unhomvu wa kelibena na ubani uli goya. ");
INSERT INTO vid_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","Kogongomanya ubani kwa vinhu avyo kota vyoulingugongomanyigwa na wagongomanyi wa unhunyhililo, uwichigwe mwino leka uwe unojile na welile. ");
INSERT INTO vid_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","Hamba koubalasa na kuwa utimbo, kouwika kumwando mwa isanduku lya ilagano mgati mwa ihema lya Nguluwi, honhu honditing'hana na hegwe. Awo wowa ubani welile ng'hatu kwa hemwe. ");
INSERT INTO vid_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","Mleche kudita ubani wa mhanzanyo awo kwa mijito ja hemwe kwa vila ubani awo wowa welile kwa hemwe hali heni Mkulu Nguluwi. ");
INSERT INTO vid_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Yoneche yochigongomanyila ubani wa kota awo na kuudita kota unhunyhililo wa heye, kobaguligwa kutali na wanhu wa heye.” ");
INSERT INTO vid_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","Mkulu Nguluwi nakamlonjela Musa, ");
INSERT INTO vid_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","“Heni ndimhagula Besaleli, mwana wa Uli, mzukulu wa Huli, wa nhanzi ya Yuda, ");
INSERT INTO vid_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","na kummemeza Muhe wa heni. Ndimha udaho na kuzowela na nyhala na uwanzi na kugongomanya vinhu, ");
INSERT INTO vid_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","leka yavumbule mijito ja uwanzi na kukola mijito ja kuponda zahabu na sendi na shaba. ");
INSERT INTO vid_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","Ndimha uwanzi wa kuhongola maganga ga kunoliga na kuhongola mbao na uwanzi wa chila mbuli ya kugongomanya vinhu. ");
INSERT INTO vid_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","Vivila ndimhagula Oholiabu mwana wa Ahisamachi, wa nhanzi ya Dani, yakole mijito hamwe na heye. Hihyo du ndiwapa udaho ukulu wanhu wanji kwa chiwalo cha mijito jinjijinji, leka wagongomanye vinhu vyeng'ha vyondajize viditikwe. ");
INSERT INTO vid_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","Wagongomanye ihema lya Nguluwi na isanduku lya ilagano na chigubiko cha uhanyisi mchanya mwake, hamwe na vinhu vyake vyeng'ha, ");
INSERT INTO vid_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","chisaga na vinhu vyake na chinhu cha kuwichila chenje chinojile na vinhu vyake na honhu ha kulavila nhambiko ha kufunyizila ubani ");
INSERT INTO vid_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","na honhu ha kulavila nhambiko za kulakazwa na vinhu vyake vyeng'ha na likuwe lya mazi hamwe na chikalilo chake ");
INSERT INTO vid_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","na mivalo jitawigwe goya, jiwele ndo mivalo jelile ja mtambika Aluni na mivalo ja wanage wawele ndo wowa wokola mijito ja utambika, ");
INSERT INTO vid_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","mafuta ga kubakala na ubani uwele na unhunyhililo unojile kwa chiwalo cha honhu helile. Vinhu avyo vyeng'ha vyoditigwa kota vila vyondikulajize.” ");
INSERT INTO vid_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","Mkulu Nguluwi nakamlonjela Musa, ");
INSERT INTO vid_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","“Uwalonjele Waisilaeli ahi, ‘Ndangukomya hemwe molidita Zuwa lya Kwesela lya heni kwa vila awo ndo ulajilo hali heni na hemwe kwa lulelo lweng'ha kota heni, Mkulu Nguluwi, ndo ndilinguwadita hemwe muwe wa chiuyeng'ha na mwelile. ");
INSERT INTO vid_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","Molidita Zuwa lya Kwesela, nalyo lyowa lyelile kwa hemwe. Yoneche yoleka kuwinza ilajizo lya zuwa alyo, yomgana yakopoligwe. Na munhu yokola mijito yoneche zuwa alyo kowinjigwa kutali na wanhu wa heye. ");
INSERT INTO vid_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","Mokola mijito ja hemwe kwa mhela wa mazuwa sita, ila zuwa lya saba ndo zuwa lya kwesela ng'hatu, ndo zuwa lya chiuyeng'ha lya heni Mkulu Nguluwi. Munhu yoneche yokola mijito zuwa alyo imgana yabagame. ");
INSERT INTO vid_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","Ahyo Waisilaeli wolyamila Zuwa lya Kwesela na wolidita kuli lulelo lwao lweng'ha kota ilagano lya mazuwa gose. ");
INSERT INTO vid_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","Mbuli ayi yowa ulajilo wa kulutilila hali Waisilaeli na heni mazuwa gose, mina heni Mkulu Nguluwi nandita ulanga na isi kwa mhela wa mazuwa sita, ila zuwa lya saba nandeka kukola mijito, nanyhesela.’ ” ");
INSERT INTO vid_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","Mkulu Nguluwi loyasindile kulonga na Musa kuchidunda cha Sinai, nakamha Musa vila vibao vili vya maganga ga ulolezi, viwele heye Nguluwi nakavyandika jila mizilo kwa chidole cha heye yuye. ");
INSERT INTO vid_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Wanhu lowawene Musa nakakawila kuhiluka kulawila kuchidunda, nawekungajiza hali Aluni na kumlonjela, “Lole, utugongomanyile jimalukolo ja milungu jojitulongoza. Mina hatuvizelele gamfichile ayo Musa yatulavile kuli isi ya Misili.” ");
INSERT INTO vid_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Aluni nakawedichila, “Mhole vipuli vya zahabu mmakutu ga wadala wa hemwe na wana wa hemwe, mndigalile.” ");
INSERT INTO vid_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Lelo wanhu weng'ha nawalavya vipuli vyeng'ha vya zahabu mmakutu mwa hewo, nawamigalila Aluni. ");
INSERT INTO vid_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Na heye nakavihola kavihemsa mbaka visungumluka, nakadita limalukolo lya ilogota ilume lya kuponda. Wanhu nawalonga, “Gwaa Isilaeli, ayu ndo mlungu wa hetwe yatulavile kuli isi ya Misili.” ");
INSERT INTO vid_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Aluni naloyawene ahyo, nakalizenjela limalukolo alyo ilogota ilume honhu ha kulavila nhambiko, kahi nakadamla, “Mitondo kowa na mnvina kwa chiwalo cha Mkulu Nguluwi.” ");
INSERT INTO vid_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Mitondo wanhu nawalilimka lufuku nawalavya nhambiko za kulakazwa na nhambiko ya kikala goya. Wanhu nawekala hasi kulya na kunwa, hamba nawema na kuvina. ");
INSERT INTO vid_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Mkulu Nguluwi nakamlonjela Musa, “Uduliche hanyi mina wanhu wa hegwe uwegalile kulawila isi ya Misili wekovulila wawo, ");
INSERT INTO vid_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","waileka yila nzila yondiwalajize, weditila ilogota ilume lya kuponda, na hewo walifugamila na kulilavila nhambiko wolonga, ‘Gwaa Isilaeli, ayu ndo mlungu wa hetwe yatulavile isi ya Misili!’ ” ");
INSERT INTO vid_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Mkulu Nguluwi nakamlonjela Musa, “Ndiwazela wanhu awa, hewo wana nhumbula zigagadale. ");
INSERT INTO vid_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Sambi, uleche kujeza kundemeza. Undeche ndiwadumye kwa kuzudila ng'hatu, leka kulawila kwa hegwe ndodita nhanzi ng'hulu.” ");
INSERT INTO vid_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Ila Musa nakamdedeza Mkulu Nguluwi, Nguluwi wa heye, nakalonga, “Gwaa Mkulu Nguluwi, lekachoni kuzudila kwa hegwe kwangwaka lukami kwa wanhu wa hegwe, uwalavile kuli isi ya Misili kwa ludali lukulu na moko uwele na mong'ho? ");
INSERT INTO vid_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Houdita ahyo, ndangukomya Wamisili wolonga, ‘Nakawalavya Misili kwa kugana kwihile leka yawakopolele kuchidunda na kuwabagamiza ng'hatu muisi.’ Gwaa Mkulu Nguluwi, usindamale na kuleka mbuli ayo yihile youlingugana kudita kwa wanhu wa hegwe. ");
INSERT INTO vid_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Uwakumbuche vitumagwa wa hegwe, Abulahamu na Isaka na Isilaeli wawele uwalahile gwegwe baho, ulonga, ‘Ndowonjezela walelwa wa hemwe kota nhondwe za kilanga na isi ayi yondilagane na hewo kota ndowapa lulelo lwenu waihalile mazuwa gose.’ ” ");
INSERT INTO vid_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Lelo Mkulu Nguluwi nakaleka kuwaditila wanhu wa heye mbuli yihile nayawele yalonjile. ");
INSERT INTO vid_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Hamba Musa nakedulika kulawila kuchidunda yawele na vibao vili vya ulolezi mmoko mwa heye, vyandichigwe mizilo ja Nguluwi banzi zeng'ha. ");
INSERT INTO vid_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","Vibao avyo navyali mijito ya Nguluwi na gandichigwe ago nakandika Nguluwi yuye. ");
INSERT INTO vid_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Yoshua loyahuliche iyowe lya wanhu, nakamlonjela Musa, “Kuna iyowe lya ngondo kuli kambi.” ");
INSERT INTO vid_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Ila Musa nakamwidichila, “Haliwele iyowe lya kusumya ama kulemwela, ila iyowe lyoulinguhulika ndo iyowe lya wanhu walingwimba.” ");
INSERT INTO vid_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Baho du loyahejelele kambi nalowaliwene lila ilogota ilume na wanhu wovina, baho du Musa nakazudila ng'hatu, nakavitaga hasi vila vibao vya ulolezi kulawila kuli moko ga heye na kuvibena hala hasi ha chidunda. ");
INSERT INTO vid_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Lelo nakalihola lila ilogota ilume, nakalisoma kwa chiluli, nakalihondanga mbaka liwa mivu, nakatijiliza mivu jila kuli mazi na kuwakola lupichi Waisilaeli wanwe. ");
INSERT INTO vid_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Musa nakamuuza Aluni, “Nawakudita choni wanhu awa mbaka uwalongoze kuli mbuli yihile ng'hulu kota ayo?” ");
INSERT INTO vid_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Aluni nakamwidichila, “Ndangukulanda hegwe mkulu wa heni, uleche kuzudila. Kuwazela wanhu awa vyowemile goya kuli kudita wihe. ");
INSERT INTO vid_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Nawoya nakundonjela, ‘Tuditile milungu jojitulongoza kwa vila hatuvizelele gamfichile ayo Musa yatulavile muisi ya Misili.’ ");
INSERT INTO vid_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Nani ndiwalonjela chila yumwe yawele na vipuli vya zahabu nayegale. Lelo wengalila, nani ndivisungulumla mchiluli na ali ilogota ilume nalilawila.” ");
INSERT INTO vid_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Lelo Musa loyawene kota wanhu nawabelenhuka na kudita vyowaganile kwa vila Aluni nakawakundiza kudita vyowaganile na kigalila soni hali wang'honyo wa hewo. ");
INSERT INTO vid_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","Musa nakema hali lwizi lwa kambi na kuuza, “Yalihi yawele ubanzi wa Mkulu Nguluwi? Yeze kwa heni.” Wana weng'ha wa Lawi nawekungajiza hamwe hali heye. ");
INSERT INTO vid_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","Nakawalonjela, “Mkulu Nguluwi, Nguluwi wa Isilaeli, kangulonga ahi, ‘Chila munhu yekowele ipanga lya heye mchuno, yazungulute chila honhu hali kambi, kulawila lwizi lumwe kuza luyage hali kambi na chila yumwe yamkopole mng'holoze na yowalingigana na yowalingikalasa habehi.’ ” ");
INSERT INTO vid_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Wana wa Lawi nawadita kota Musa navyoyawalajize. Zuwa alyo nawakopoligwa wanhu wafichile elufu zidatu. ");
INSERT INTO vid_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Musa nakalonga, “Lehano, mwemwe baho miwika kwa mijito yelile kumkolela mijito Mkulu Nguluwi, kwa vila hamlechile kitwanza na wana wa hemwe ama wang'holozenu. Nguluwi kanguwatambichiza hemwe lehano.” ");
INSERT INTO vid_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Mitondo iyaje Musa nakawalonjela wanhu, “Mdita gehile vikulu ng'hatu! Lelo ndomlutila Mkulu Nguluwi kuchanya kuchidunda, hanji ndoweza kuwaditila hemwe uhanyisi.” ");
INSERT INTO vid_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Ahyo Musa nakahiluka kwa Mkulu Nguluwi, nakamlonjela, “Ndangisinza! Wanhu awa wadita gehile vikulu ng'hatu, weditila wawo mlungu wa zahabu. ");
INSERT INTO vid_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Ila lelo, ndangukulanda uwosele gehile ga hewo. Wone huwosele, ndangukudedeza umbuse heni mli chitabu cha hegwe nachowandiche matagwa ga wanhu wa hegwe.” ");
INSERT INTO vid_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Ila Mkulu Nguluwi nakamlonjela Musa, “Ndomusa mli chitabu cha heni munhu yoneche yaditile gehile. ");
INSERT INTO vid_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Ila sambi ulute ukawalongoze wanhu mbaka honhu hondikulonjele. Ulole, mhilisi wa heni kokulongola. Ila, zuwa hondikuya kwa hewo, ndowagaza kwa chiwalo cha gehile ga hewo.” ");
INSERT INTO vid_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Mkulu Nguluwi nakawahilichila wanhu utamwa wihile, kwa vila nawamlanda Aluni yawaditile lila ilogota ilume lya zahabu. ");
INSERT INTO vid_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","Mkulu Nguluwi nakamlonjela Musa, “Waluche majendo wuche aha, hegwe na wanhu awo uwalavile kuli isi ya Misili, mlute kuli isi yondimlahile Abulahamu na Isaka na Yakobo, ndilonga, ‘Ndowapa walelwa wa hemwe isi ayi.’ ");
INSERT INTO vid_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","Ndomlajiza mhilisi yawalongoze, ndowawinga Wakanaani na Waamoli na Wahiti na Wapelisi na Wahivi na Wayebusi. ");
INSERT INTO vid_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","Mlute kuli ayo isi iwele na mboto. Ila kwa vila hemwe ndo muwele na nhumbula zigagadale, siluta hamwe na hemwe, leka ndeche kuwabagamiza mnzila.” ");
INSERT INTO vid_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Wanhu nawalila lowahuliche mbuli ayo yihile, kuduhu ne yumwe yavalile vinoligo vya heye. ");
INSERT INTO vid_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","Nawadita ahyo kwa vila Mkulu Nguluwi nakamlonjela Musa, “Uwalonjele Waisilaeli, ‘Hemwe mwa wanhu wawele na nhumbula zigagadale, wone ndute hamwe na hemwe kwa mhela udo hela, ndowabagamiza. Ahyo, mvule vinoligo vya hemwe leka ndivizele mbuli ya kuwaditila.’ ” ");
INSERT INTO vid_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","Lelo Waisilaeli nawavula vinoligo vya hewo hala kuchidunda cha Holebu. ");
INSERT INTO vid_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Musa nayali na chihendo cha kulihola ihema linji na kulimiza hanze, kutali chidodo na kambi. Ihema alyo nakalipa itagwa, ihema lya nhing'hano. Munhu yoneche yaganile kumlanda Mkulu Nguluwi, nakaluta hala kuli ihema alyo hanze ha kambi. ");
INSERT INTO vid_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Chila mhela Musa loyalawile kuluta kuli ihema alyo, chila munhu nakema hali lwizi lwa ihema lya heye na kumlola Musa mbaka hoyokwinjila mgati mwa alyo ihema. ");
INSERT INTO vid_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Mhela Musa loyenjile mgati mwa alyo ihema, izengo lya ng'hungugu naligwa kuli lwizi lwa ihema, na Mkulu Nguluwi nakalongasa na heye. ");
INSERT INTO vid_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Wanhu weng'ha lowaliwene izengo lya ng'hungugu liwele hala, chila yumwe wa hewo nakafugama hali lwizi lwa ihema lya heye. ");
INSERT INTO vid_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Ahyo ndo Mkulu Nguluwi navyoyali yolongasa na Musa hazelu, kota munhu yalingulonga na miyage yeganile na heye. Hamba Musa nakahiluka kahi kuli kambi. Na heye msongolo, Yoshua, na mwana wa Nuni, yawele chitumagwa wa heye nahochile hali ihema. ");
INSERT INTO vid_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Musa nakamlonjela Mkulu Nguluwi, “Ulole, hegwe kwangundonjela, ‘Uwalongoze wanhu awa,’ ila hunanzelesa ndo yalihi youmlajiza yanhanze. Ila nakulonga kota kwangunzela kwa itagwa na kahi kota nojezwa na hegwe. ");
INSERT INTO vid_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Lelo ndangukudedeza wone kunojezwa na heni, undajile lelo nzila za hegwe leka ndikuzele hegwe, leka kota kowa unojezwe na heni. Ndangulanda ukumbuche kahi kota nhanzi ayi ndo wanhu wa hegwe.” ");
INSERT INTO vid_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","Nguluwi nakalonga, “Heni baha ndoluta hamwe na hegwe na ndokudita usindamale.” ");
INSERT INTO vid_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Musa nakalonga, “Wone gwegwe baho huluta hamwe na heni, lelo uleche kutusa honhu aha. ");
INSERT INTO vid_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Mina ndovizela ndaze kota kunojezwa na heni, heni na wanhu wa hegwe, wone hulinguluta hamwe na hetwe? Houluta hamwe na hetwe yotudita tuwe wanhu wa chiuyeng'ha hali wanhu weng'ha wa isi.” ");
INSERT INTO vid_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","Mkulu Nguluwi nakamlonjela Musa, “Kwa vila heni nojezwa na hegwe, nani ndangukuzela kwa itagwa lyako, mbuli yiyino nayoulonjile ndoidita.” ");
INSERT INTO vid_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Musa nakalonga, “Ndangukudedeza undajile ukulu wa hegwe.” ");
INSERT INTO vid_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Mkulu Nguluwi nakamwidichila, “Ndokola hali hegwe na kukulajila kunoga kwa heni kweng'ha kuno ndiliwikula itagwa lyangu, ‘Mkulu Nguluwi.’ Ndomonela isungu munhu yula yondigana kumonela isungu, ndochisinza kwa munhu yula yondilingugana ndisinze. ");
INSERT INTO vid_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","Ila huweza kumbona kumeho mina kuduhu munhu yoneche yombona na kuwa mkomu.” ");
INSERT INTO vid_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","Hamba Mkulu Nguluwi nakamlonjela Musa, “Kuna honhu behi na heni hawele houkwima mchanya mwa italawe, ");
INSERT INTO vid_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","na ukulu wa heni houwa ukola, ndokuwika mli mhalika mitalawe na kukugubika kwa moko ga heni, mbaka hondiwa ng'holile. ");
INSERT INTO vid_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","Hamba ndokusa moko wa heni nagwe kochona chigosi cha heni, ila kumeho kwa heni hukona hebu.” ");
INSERT INTO vid_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Mkulu Nguluwi nakamlonjela Musa, “Uhongole vibao vili vya maganga kota vila vya mwaluko, nani ndovyandika ulonzi ula louwele kuli vila vibao vya mwaluko vyouvibenile. ");
INSERT INTO vid_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Uwe goya mitondo, uye kiting'hana na heni hala kuli kuchidunda cha Sinai. ");
INSERT INTO vid_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Munhu yoneche yaleche kuya na hegwe, na yaleche koneka honeche mchidunda, ne ming'holo ama misenga jileche kudimigwa habehi.” ");
INSERT INTO vid_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Lelo Musa nakahongola vibao vili vya maganga kota vila vya mwaluko. Nakoka mitondo lufuku, nakakwina mchidunda cha Sinai, kota Mkulu Nguluwi navyoyamlonjele. Nakahola vila vibao vili vya maganga mmoko mwake. ");
INSERT INTO vid_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Mkulu Nguluwi nakadulika kuli ng'hungugu nakema hamwe na Musa, nakawikula itagwa lyake, “Mkulu Nguluwi.” ");
INSERT INTO vid_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Hamba Mkulu Nguluwi nakakola hali Musa yowikula kahi, “Mkulu Nguluwi, heni Mkulu Nguluwi, ndo Nguluwi yawele na isungu na yalingutambichiza, halinguzudila himahima, kamema igano lya kwimilila na wa kitumbila. ");
INSERT INTO vid_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","Heni ndanguwaditila igano lya kwimilila maelufu ga lulelo lulinguya, ndiwosela wehile wihe na kubelenhuka na gehile, ila kwa vyoneche vila sileka kumgaza yawele na nongwa, ndanguwagaza wana na wazukulu wa wehile na lulelo lwa kadatu na lwa kane.” ");
INSERT INTO vid_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Baho Musa nakenamiza hasi himahima, nakamfugamila Nguluwi. ");
INSERT INTO vid_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","Hamba nakalonga, “Gwaa Mkulu wa heni, wone ulingunojezwa na heni, ndangukulanda tulutase hamwe na hetwe. Wanhu awa ndo wawele na nhumbula zigagadale, ila utusile wihe wa hetwe na gehile ga hetwe, utubochele kota wanhu wa gwegwe baho.” ");
INSERT INTO vid_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Mkulu Nguluwi nakamlonjela Musa, “Sambi ndangudita ilagano. Hali wanhu wa hegwe weng'ha ndodita vinduzanduza hali hewo viwele havinalawila kuli isi yeng'ha ne kuli nhanzi yoneche. Na wanhu weng'ha mlingikala hali hewo wogona madito ga heni makulu. Mina ndodita mbuli za vinduzanduza vya kudumbiza hamwe na hegwe. ");
INSERT INTO vid_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","“Wibatilile mizilo jondikupa lehano. Lole, ndowawinga hali hegwe Waamoli na Wakanaani na Wahiti na Wapelisi na Wahivi na Wayebusi. ");
INSERT INTO vid_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Wilolele uleche kudita ilagano na walingikala isi youlinguluta, mina alyo lyowa idiwa hali hegwe. ");
INSERT INTO vid_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","Ila kozabomola honhu ha kulavila nhambiko ha hewo na kubena mizengo ja milungu ja hewo na mizengo jawo ja mlungu wa Ashela. ");
INSERT INTO vid_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","Mleche kumfugamila mlungu yunji, kwa vila heni Mkulu Nguluwi, ndanguzeleka kwa itagwa, ‘Yawele na Fihi,’ heni ndo Nguluwi yawele na fihi. ");
INSERT INTO vid_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","Mleche kiwichila malagano goneche na wanhu wa isi, kwa vila hala howofugamila jimalukolo kota wang'hondwa na kujilavila nhambiko, wokuchema hegwe kihanza na hewo na kokwejigwa kulya chowalingulavya kwa milungu ja hewo. ");
INSERT INTO vid_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","Wone wana wa hegwe wawahole wahinza wa wanhu awo, na awo wahinza wangufugamila milungu jawo kota wang'hondwa, wowabada wasongolo wa hegwe kuwinza milungu ja hewo. ");
INSERT INTO vid_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","“Uleche kiditila milungu ja chuma. ");
INSERT INTO vid_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","“Kodita mnvina ya mibumunda johajiwichigwe usaso. Kwa mhela wa mazuwa saba kolya mibumunda johajiwichigwe usaso mhela uwichigwe kuli mwezi wa Abibu, kota vyondikulajize, kwa vila kuli mwezi awo wa Abibu, nakulawa Misili. ");
INSERT INTO vid_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","Chila chochileleche mwaluko chilume ndo cha heni, hamwe na milume jeng'ha ja migongolo ja haluga na jileleche mwaluko ja misenga na ming'holo. ");
INSERT INTO vid_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","Ila idogowi lileleche mwaluko, koligombola kwa kundavila ing'holo. Wone huligombola, kolibena singo. Wana wa hegwe walume wapondigwe mwaluko, kowagombola. Munhu yoneche yaleche kuya hali heni ne chinhu. ");
INSERT INTO vid_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","“Mazuwa sita kokola mijito ja hegwe, ila zuwa lya saba, kokwesela, hanga uwe mhela wa lilima ama mbena. ");
INSERT INTO vid_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","Kodita mnvina ya mbena, kwaluka kwa mhela wa mbena ya ngano na kudita mnvina ya kukungajiza mbena kuduma kwa mhela. ");
INSERT INTO vid_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","Mala zidatu kwa mhela wanhu weng'ha walume wa hegwe wokuya kufugamila heni, Mkulu Nguluwi, Nguluwi wa Isilaeli. ");
INSERT INTO vid_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","Lelo ndowawinga wanhu wa isi zinji hali hegwe na konjeza isi ya hegwe, kuduhu ne yumwe yojeza kuhola isi ya hegwe hali heni Mkulu Nguluwi houluta mhela wa mnvina azo zidatu. ");
INSERT INTO vid_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","“Uleche kundavila danda ya nhambiko ya heni hamwe na usaso, na miwunde ja nhambiko ya mnvina ya Pasaka ileche kupona mbaka hamitondo. ");
INSERT INTO vid_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","“Mbena ya mwaluko ya hegwe inojile kochigala kaye kwa heni Mkulu Nguluwi, Nguluwi wa hegwe. “Uleche kuhemsa kanyehe kuli itombo lya mayake.” ");
INSERT INTO vid_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","Mkulu Nguluwi nakamlonjela Musa, “Wandiche ulonzi awu, mina kwa ulonzi awu, nandita ilagano na hegwe na wanhu wa Isilaeli.” ");
INSERT INTO vid_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Musa nakekala ako kuchidunda hamwe na Mkulu Nguluwi kwa mazuwa makumi gane, nemisi na nechilo, hadile chilyo ne kunwa mazi. Nakandika malajizo geng'ha na jila mizilo kumi. ");
INSERT INTO vid_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Musa loyali yodulika kuli chidunda cha Sinai yawele na vila vibao vili vya ulolezi mmoko mwake, nahavizelele kota kumeho kwa heye nakulangazuka kwa vila nayali yodawala na Mkulu Nguluwi. ");
INSERT INTO vid_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Aluni na wanhu wa Isilaeli weng'ha nalowamuwene Musa, nawadumba kumhejelela, kwa vila kumeho kwa heye nakwali kupulika. ");
INSERT INTO vid_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Ila Musa nakamchema Aluni na vilongozi wa Waisilaeli weng'ha nawalute behi na heye, hamba nakalongasa na hewo. ");
INSERT INTO vid_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Hamba Waisilaeli weng'ha nawoya behi na heye, na heye nakawapa mizilo jeng'ha Mkulu Nguluwi najoyampele kula kuchidunda cha Sinai. ");
INSERT INTO vid_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Musa loyasindile kulonga na wanhu, nakagubika kumeho kwa heye kwa chibende. ");
INSERT INTO vid_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Ila naiwa kota chila mhela Musa hoyoluta kulonga na Mkulu Nguluwi, nayali yokusa chila chibende mbaka hoyolawa kunze. Na hoyolawa kunze nakawalonjela Waisilaeli mbuli yeng'ha yoyalajizwe, ");
INSERT INTO vid_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","na hewo Waisilaeli nawakona kumeho kwa heye vyokulangazuche. Ndo Musa loyagubiche kumeho kwa heye mbaka hoyoluta kulonga na Mkulu Nguluwi. ");
INSERT INTO vid_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Musa nakawakungajiza Waisilaeli weng'ha, nakawalonjela, “Azi ndo mbuli ziwele Mkulu Nguluwi yawalajize mdite. ");
INSERT INTO vid_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","Kwa mazuwa sita mokola mijito ja hemwe, ila zuwa lya saba ndo zuwa lya kwesela ng'hatu liwichigwe lyelile kwa chiwalo cha Mkulu Nguluwi. Yoneche yokola mijito zuwa alyo imgana yakopoligwe. ");
INSERT INTO vid_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","Mleche kubwina chiluli kuli ng'handa za hemwe Zuwa lya Kwesela.” ");
INSERT INTO vid_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Musa nakawalonjela Waisilaeli weng'ha, “Ayi ndo mbuli iwele Mkulu Nguluwi yawalajize mkole. ");
INSERT INTO vid_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","Molavya kuli lufufu lwa hemwe nhambiko ya kumha Mkulu Nguluwi. Chila munhu yawele na nhumbula inojile komigalila Mkulu Nguluwi nhambiko, zahabu na sendi na shaba ");
INSERT INTO vid_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","na sufu ya buluu na ya zambalau na ndung'hu na kitani inojile itawigwe na milaika ja mhene ");
INSERT INTO vid_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","na migozi ja ing'holo ilume liwichigwe lanji ndung'hu na migozi ja migongolo jinji jilingikala mbahali na mbao za msonobali ");
INSERT INTO vid_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","na mafuta kwa chiwalo cha chenje, ndugwa kwa chiwalo cha mafuta ga kubakala na kwa chiwalo cha ubani uwele na unhunyhililo unojile ng'hatu ");
INSERT INTO vid_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","na maganga galingupulika ga salidoniki na maganga ganji galingupulika kwa chiwalo cha kunoliga, chihako cha mmhambaga na chizibao cha mtambika. ");
INSERT INTO vid_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","“Chila munhu yawele na uwanzi hali hemwe kokuya kugongomanya vinhu vyeng'ha vyoyalajize Mkulu Nguluwi. ");
INSERT INTO vid_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","Kugongomanya ihema lya Nguluwi na chigubiko chake na ipaziya lyake na ngwamo zake na fulemu zake na vikalilo vyake ");
INSERT INTO vid_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","na isanduku lya ilagano hamwe na vipichilo vyake na chigubiko cha uhanyisi na ipaziya lya honhu helile ng'hatu ");
INSERT INTO vid_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","na chisaga na mipichilo jake hamwe na vinhu vyake vyeng'ha na mibumunda jelile jiwichigwe hali Mkulu Nguluwi ");
INSERT INTO vid_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","na vinhu vya kuwichila vyenje hamwe na vinhu vyake vyeng'ha na vyenje vyake na mafuta gake ");
INSERT INTO vid_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","na honhu ha kulavila nhambiko ha ubani hamwe na mipichilo jake na mafuta ga kubakala na ubani uwele na unhunyhililo unojile na ipaziya lya lwizi lwa ihema lya Nguluwi ");
INSERT INTO vid_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","na honhu ha kulavila nhambiko za kulakazwa hamwe na utandawala wa shaba na mipichilo jake hamwe na vinhu vyake vyeng'ha na likuwe na chikalilo chake ");
INSERT INTO vid_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","na utandawala wa lugagala na mizengo jake na vikalilo vyake na ipaziya lya lwizi lwa lugagala ");
INSERT INTO vid_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","na vigingi vya ihema lya Nguluwi na za lugagala hamwe na ng'weso zake ");
INSERT INTO vid_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","na mivalo jitawigwe goya ng'hatu kwa chiwalo cha mijito ja honhu helile, jiwele ndo mivalo jelile ja mtambika Aluni na ja wanage kwa chiwalo cha mijito ja hewo ja utambika.” ");
INSERT INTO vid_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","Lelo Waisilaeli weng'ha nawoka hali Musa. ");
INSERT INTO vid_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","Lelo chila munhu yawele na nhumbula inojile na kwinjilwa na isungu nakamlavila nhambiko Mkulu Nguluwi kwa chiwalo cha ihema lya Nguluwi na mijito ja ihema na mivalo ja watambika. ");
INSERT INTO vid_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","Ahyo weng'ha wawele na nhumbula zinojile, walume kwa wadala, nawegala vipuli vya mmenyhelo na vipuli vya mmakutu na pete za muhuli na banjili na chila chinhu cha zahabu, chila munhu nakamlavila Mkulu Nguluwi nhambiko ya kwinula kuchanya vinhu vya zahabu. ");
INSERT INTO vid_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","Chila munhu nakegala choneche nachoyawele nacho kota vila sufu ya lanji ya buluu na zambalau na ndung'hu ama kitani inojile ama milaika ja mhene ama igozi lya ing'holo ilume liwichigwe lanji ndung'hu ama migozi ja migongolo jinji jilingikala mbahali. ");
INSERT INTO vid_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Chila munhu yawezile kulavya sendi ama shaba nakegala kwa Mkulu Nguluwi kota nhambiko ya heye. Kahi munhu yoneche yawele na mbao za msonobali kwa mijito yoneche, nakegala kahi. ");
INSERT INTO vid_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","Wadala weng'ha wawele na uwanzi wa kutawa nawegala vinhu vyowatawile kwa sufu ya lanji ya buluu na zambalau na ndung'hu na kitani inojile itawigwe. ");
INSERT INTO vid_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","Na wadala weng'ha nawenjilwe na isungu nawatawa milaika ja mhene. ");
INSERT INTO vid_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","Vilongozi nawegala vipuli vya lanji na maganga galinguchemigwa salidoniki na maganga kwa chiwalo cha chihako cha mmhambaga na chizibao. ");
INSERT INTO vid_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","Nawegala kahi ndugwa na mafuta kwa chiwalo cha vyenje na mafuta ga kubakala na ubani ulingununyhilila ng'hatu. ");
INSERT INTO vid_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","Waisilaeli weng'ha, walume kwa wadala wawele wakwejigwe mnhumbula ya hewo kigala choneche kwa chiwalo cha mijito ya Mkulu Nguluwi nayali yamlajize Musa ikoleche, nawegala vinhu avyo kota nhambiko ya kunuwila kwa wawo na kumha Mkulu Nguluwi. ");
INSERT INTO vid_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Musa nakawalonjela Waisilaeli, “Mlole, Mkulu Nguluwi nakamhagula Besaleli mwanage Uli, mwanage Huli wa nhanzi ya Yuda. ");
INSERT INTO vid_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","Nakamemeza Muhe wa Nguluwi, kamha uwanzi na luhala na nyhala na uwanzi wa kugongomanya vinhu, ");
INSERT INTO vid_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","leka yavumbule mijito ja uwanzi na kukola mijito ja kuponda zahabu na sendi na shaba. ");
INSERT INTO vid_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","Ndimha uwanzi wa kuhongola maganga ga kunoliga na kuhongola mbao na uwanzi wa chila mbuli ya kugongomanya vinhu kwa uwanzi. ");
INSERT INTO vid_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","Kahi Mkulu Nguluwi nakamlongoza heye na Oholiabu mwanage Ahisamachi wa nhanzi ya Dani, waweze kuwalangusa wanji. ");
INSERT INTO vid_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","Nakawapa uwanzi wa kudita chila mijito ya uwanzi ama ilinguditigwa na wanhu walinguhongola ama walinguvumbula vinhu ama wawanzi wa kutawa kwa sufu ya lanji ya buluu na zambalau na ndung'hu na kitani inojile itawigwe kwa uwanzi woneche wa muwanzi. ");
INSERT INTO vid_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","“Besaleli na Oholiabu, hamwe na chila mlume yawele yapegwe uwanzi na luhala lwa kuvizela mbuli ya kukola mijito zeng'ha na Mkulu Nguluwi kuli kuzenga ihema lya Nguluwi, kokola mijito kwa geng'ha Mkulu Nguluwi nayamlajize.” ");
INSERT INTO vid_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","Musa nakawachema Besaleli na Oholiabu na chila mgongomanyi yawele yapegwe uwanzi na Mkulu Nguluwi na chila munhu yawele yatumigwe na nhumbula ya heye kukola mijito kwa kugana hela. ");
INSERT INTO vid_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","Awo nawabochela kulawila kwa Musa vinhu vyeng'ha navilavigwe na Waisilaeli kwa chiwalo cha mijito ya ihema lya Nguluwi. Wanhu nawalutilila kumigalila nhambiko za kunuwila kwa hewo chila mitondo. ");
INSERT INTO vid_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","Wanhu weng'ha wawele na uwanzi nawawele wokola mijito ga chila mbuli za kuzenga ihema lya Nguluwi nawaluta, chila yumwe kuli mijito ya heye, nawamlutila ");
INSERT INTO vid_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","Musa na kumlonjela, “Wanhu wegala vinhu vinji ng'hatu mzidi wa vila vilinguganigwa kwa mijito yoyatulajize Mkulu Nguluwi tuikole.” ");
INSERT INTO vid_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","Lelo Musa nakalajiza na mbuli ayo naiwikuligwa kuli kambi yeng'ha, “Munhu yoneche, yawe mlume ama mdala, yaleche kigala nhambiko yonzezeche kwa chiwalo cha ihema lya Nguluwi.” Wanhu nawalemezwa kigala vinhu, ");
INSERT INTO vid_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","mina vila navyowegale navihega kwa mijito ayo na kusigala. ");
INSERT INTO vid_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","Walume weng'ha wawele na uwanzi nawagongomanya ihema lya Nguluwi kwa mipaziya kumi ja kitani inojile itawigwe na kwa sufu ya lanji ya buluu na zambalau na ndung'hu na kunoliga kwa vilumbigwe vifandile kota wahilisi. ");
INSERT INTO vid_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","Ulefu wa chila ipaziya nawali mita kumi na mbili na ugazi mita mbili. Mipaziya jeng'ha jali na chipimilo chimwe. ");
INSERT INTO vid_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","Nakalumbaniza mipaziya jihano na kudita ipaziya limwe na kudita hihyo kwa jila jinji jihano. ");
INSERT INTO vid_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","Nakagongomanya vibatililo vya lanji ya buluu mlupembo lwa ipaziya lya mwiso kuli chihande cha mwaluko na vibatililo vinji kuli ipaziya lya mwiso hali chihande cha keli. ");
INSERT INTO vid_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","Nakajela vibatililo makumi gahano kuli ipaziya lya mwaluko na vibatililo makumi gahano kuli ipaziya lya keli. Vibatililo vyeng'ha navyali vichilola. ");
INSERT INTO vid_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","Hamba nakadita ngwamo za zahabu makumi gahano hamwe kuli kilumba na mipaziya mili kuli chihande chimwe. ");
INSERT INTO vid_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","Hamba nakadita kahi chigubiko cha ihema lya Nguluwi kwa mipaziya kumi na limwe lya milaika ja mhene. ");
INSERT INTO vid_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","Chila ipaziya lyali na ulefu wa mita kumi na zidatu na ugazi wa mita mbili. Mipaziya jeng'ha kumi na limwe najali na chipimilo chichila. ");
INSERT INTO vid_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","Lelo nakajilumbiza mipaziya jihano na mipaziya sita hamwe. ");
INSERT INTO vid_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","Hamba nakadita vibatililo makumi gahano mlupembo mwa ipaziya lya mwiso lya chihande cha mwaluko na vibatililo makumi gahano mlupembo mwa chihande cha keli. ");
INSERT INTO vid_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","Hamba nakadita ngwamo makumi gahano vya shaba leka kulumbizila vila vihande vili vya mipaziya na ahyo kudita ipaziya limwe lya ihema. ");
INSERT INTO vid_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","Hamba nakadita chigubiko cha igozi lya ing'holo ilume liwichigwe lanji ndung'hu na mchanya mwake chigubiko chinji cha igozi lya igongolo linji lilingikala mbahali. ");
INSERT INTO vid_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","Hamba nakaligongomanyila fulemu za msonobali kwa chiwalo cha kwimiza ihema lya Nguluwi. ");
INSERT INTO vid_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","Chila fulemu nayali na ulefu wa mita zine na ugazi wa sentimita makumi sita na sita. ");
INSERT INTO vid_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","Chila fulemu nayali na ndimi mbili za kulumbizila. Fulemu zeng'ha za ihema nakaziditila ndimi. ");
INSERT INTO vid_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","Fulemu azo za ihema naziditikwa hino, fulemu makumi meli, ubanzi wa kusini, ");
INSERT INTO vid_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","na vikalilo makumi gane vya sendi hasi ya azo fulemu makumi meli, vikalilo vili hasi ha chila fulemu leka kwimizila zila ndimi zake mbili. ");
INSERT INTO vid_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","Na ubanzi wa keli ula uwele kasikazini mwa ihema, nakaugongomanyila kahi fulemu makumi meli, ");
INSERT INTO vid_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","na vikalilo vyake makumi gane ga sendi na vikalilo vili hasi ha chila fulemu. ");
INSERT INTO vid_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","Ubanzi wa kumbele uwele kolizinjilaga isanya mwa ihema, nakaugongomanyila fulemu sita. ");
INSERT INTO vid_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","Nakagongomanya kahi fulemu mbili kwa chiwalo cha nzingo za ihema, ubanzi wake wa kumbele. ");
INSERT INTO vid_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","Fulemu azo mbili za kuli nzingo nazilekana hasi ila nazibatigwa kuchanya kuli pete ya mwaluko. Fulemu mbili kwa chiwalo cha azo nzingo mbili naziditikwa kota ahyo. ");
INSERT INTO vid_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","Ahyo nakwali na fulemu nane na vikalilo vyake vya sendi kumi na sita, vikalilo vili hasi ya chila fulemu. ");
INSERT INTO vid_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","Nakadita kahi migamba ja msonobali na migamba jihano kwa chiwalo cha fulemu ya banzi imwe ya ihema, ");
INSERT INTO vid_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","migamba jihano kwa chiwalo cha ubanzi wa keli wa ihema na migamba jihano kwa chiwalo cha fulemu za ubanzi wa kumbele mwa ihema, iwele kolizibilaga isanya. ");
INSERT INTO vid_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","Nakadita mgamba wa hagati ufichile nusu ya fulemu ya ihema uwele winjile hagati kulawila mwiso mbaka mwiso. ");
INSERT INTO vid_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","Fulemu zeng'ha nakazibakaliza zahabu, nakazidita na pete za zahabu za kibatilila mgamba ziwele kahi yazibakalize zahabu. ");
INSERT INTO vid_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","Nakagongomanya ipaziya lya lanji ya buluu na zambalau na ndung'hu na kitani inojile itawigwe. Ipaziya alyo nalitawigwa kwa kunoligwa kwa vilumbigwe vifandile kota wahilisi kwa uwanzi ng'hatu. ");
INSERT INTO vid_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","Nakagongomanya mizengo jine ajo ja msonobali, nakajibakaliza zahabu na kujiwichila ngwamo za zahabu. Vivila nakagongomanya vikalilo vine vya sendi. ");
INSERT INTO vid_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","Hihyo du, kwa chiwalo cha lwizi lwa ihema, nakagongomanya ipaziya lya lanji ya buluu na zambalau na ndung'hu na kitani inojile itawigwe, nalyo ipaziya nalitawigwa goya. ");
INSERT INTO vid_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","Nakagongomanya mizengo jake jihano jiwele na fito. Honhu ha kuchanya na vibatililo vyake nakavibakaliza zahabu, ila vikalilo vyake vihano navyali vya shaba. ");
INSERT INTO vid_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","Besaleli nakagongomanya isanduku lya ilagano kwa mbao za msonobali, ulefu wake nawali sentimita miya imwe na kumi, ugazi nawali sentimita makumi sita na sita, na wimo wake nawali sentimita makumi sita na sita. ");
INSERT INTO vid_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","Nakalibakaza zahabu inojile kunze na mgati na kudita mfungo mwake mweng'ha kuwe kwa zahabu. ");
INSERT INTO vid_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","Hamba nakagongomanya pete zine za zahabu, imwe kwa chila mgulu. Hamba nakawika pete imwe kuli chila ubanzi. ");
INSERT INTO vid_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","Nakagongomanya mipichilo ja msonobali na kubakaliza zahabu. ");
INSERT INTO vid_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","Mipichilo ajo nakajiwika mli zila pete ziwele kuli banzi mbili za isanduku, kwa chiwalo cha kupichila. ");
INSERT INTO vid_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","Nakagongomanya chigubiko cha uhanyisi cha zahabu inojile, ulefu wake nawali sentimita miya imwe na kumi na ugazi wake nawali sentimita makumi sita na sita. ");
INSERT INTO vid_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","Nakagongomanya kwa kuponda vilumbigwe vili vya zahabu vifandile kota wahilisi mwiso wa chigubiko acho, ");
INSERT INTO vid_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","chilumbigwe chifandile kota mhilisi, chimwe mwiso awu na chiyage mwiso uyage. Nakagongomanya vilumbigwe vifandile kota wahilisi kuli mwiso wa chigubiko acho, viwele chinhu chimwe na chigubiko. ");
INSERT INTO vid_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","Vilumbigwe avyo vifandile kota wahilisi navyali vichilola na mbawa zake hozigonzoligwa nazali zigubika chigubiko cha isanduku, meho gawo golola chigubiko cha isanduku. ");
INSERT INTO vid_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","Vivila nakagongomanya chisaga cha msonobali chiwele na ulefu wa sentimita makumi nane na nane na ugazi wa sentimita makumi gane na zine na wimo wake nawali sentimita makumi sita na sita. ");
INSERT INTO vid_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","Nakabakaliza zahabu inojile na kuchizungulusila isali lya zahabu. ");
INSERT INTO vid_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","Hamba nakachizungulusila chibao chiwele na ugazi wa sentimita nane na kuzungulusila isali lya zahabu. ");
INSERT INTO vid_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","Nakagongomanya pete zine za zahabu na kuzijela kuli nzingo zake zine honhu magulu hogalinguduma. ");
INSERT INTO vid_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","Pete azo nazali behi na isali na nazali kwa chiwalo cha kubatilila mipichilo. Mipichilo ajo najali kwa chiwalo cha kupichila acho chisaga. ");
INSERT INTO vid_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","Nakagongomanya mipichilo ja msonobali ja kupichila, nakaibakaliza zahabu. ");
INSERT INTO vid_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","Nakagongomanya vinhu vya zahabu inojile vya kuwichila mchanya mwa visaga, na nyhelo zake na vizombe vya kuwichila ubani na vibuyu na visaye kwa chiwalo cha kujidila nhambiko ya chakunwa. ");
INSERT INTO vid_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","Nakagongomanya chinhu cha kuwichila chenje kwa zahabu inojile. Chikalilo chake na mitumba jake na vizombe vyake na ufito wake na uluwa wake navyali chinhu chimwe. ");
INSERT INTO vid_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","Nhagala sita nazilawilila kuli chinhu cha kuwichila chenje, nhagala zidatu banzi imwe na nhagala zidatu banzi iyaje. ");
INSERT INTO vid_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","Kuli nhagala hana vizombe vidatu viwhanile na mitumba na uluwa ulinguchemigwa alimondi. Kuli nhagala ilinguya kahi hana vizombe vidatu viwhanile na mitumba na uluwa ulinguchemigwa alimondi. Nhagala zeng'ha sita naziwhana vivila kuli chinhu cha kuwichila chenje. ");
INSERT INTO vid_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","Na kuli ufito nakwali na vizombe vine viwhanile na uluwa ulinguchemigwa alimondi hamwe na itumba lyake na uluwa wake. ");
INSERT INTO vid_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","Honhu halingulawilizila chila jozi ya nhagala zila sita, hasi hake nakwali na itumba limwe limwe. ");
INSERT INTO vid_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","Mitumba ajo na nhagala zake nazali chinhu chimwe na chinhu acho cha kuwichila chenje acho, na cheng'ha nachipondigwa kwa zahabu inojile. ");
INSERT INTO vid_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","Nakagongomanya vyenje saba na vinhu vyake vya kuzimila vyenje na nyhelo zake kwa zahabu inojile. ");
INSERT INTO vid_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","Nakagongomanya chinhu acho cha kuwichila chenje na vinhu vyake kwa kilo makumi gadatu na zihano za zahabu inojile. ");
INSERT INTO vid_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","Nakagongomanya honhu ha kulavila nhambiko ha kufunyizila ubani kwa mbao za msonobali. Honhu ha kulavila nhambiko aho hali ha mlaba, sentimita makumi gane na gahano kwa sentimita makumi gane na gahano na fudi yake sentimita makumi tisa. Mbalati za honhu ha kulavila nhambiko zali chinhu chimwe na honhu ha kulavila nhambiko aho. ");
INSERT INTO vid_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","Heng'ha nakabakaliza zahabu inojile na nzingo yake ya kuchanya na banzi zake za mlubavu na mbalati zake kahi nakaziditila msitali wa zahabu. ");
INSERT INTO vid_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","Nakagongomanya pete mbili za zahabu hasi ha msitali kuli banzi mbili zilingilola. Pete azo nazali zibatilila mipichilo ja kupichila. ");
INSERT INTO vid_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","Nakagongomanya mipichilo mili ja msonobali na kuibakaliza zahabu. ");
INSERT INTO vid_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","Nakagongomanya mafuta gelile ga kubakala na ubani uwele na unhunyhililo unojile kota mgongomanyi wa unhunyhililo. ");
INSERT INTO vid_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","Nakagongomanya honhu ha kulavila nhambiko za kulakazwa kwa mbao za msonobali kwa chiwalo cha nhambiko ya kulakazwa. Honhu ha kulavila nhambiko nahali ha mlaba, mita mbili na lobo kwa mita mbili na lobo na fudi yake nawali mita imwe na lobo. ");
INSERT INTO vid_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","Kuli chila nzingo ya honhu ha kulavila nhambiko aho nakagongomanya mbalati imwe, azo mbalati nazali chinhu chimwe na honhu ha kulavila nhambiko, honhu heng'ha nakahabakaliza kwa shaba. ");
INSERT INTO vid_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","Nakagongomanya vinhu vyeng'ha vya honhu ha kulavila nhambiko, nakagongomanya visaye vyake vya kusila mivu na mihuka na visaye vyake na mibano jake na visaye vya kuholela makala, na vinhu vyeng'ha nakagongomanya kwa shaba. ");
INSERT INTO vid_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","Nakagongomanya utandawala wa shaba na kujela hasi mbaka hagati ha honhu ha kulavila nhambiko. ");
INSERT INTO vid_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","Kuli nzingo nakagongomanya pete zine za shaba za kuholela aho honhu ha kulavila nhambiko, pete imwe kuli chila nzingo. ");
INSERT INTO vid_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","Nakagongomanya mipichilo ja msonobali na kujibakaliza shaba. ");
INSERT INTO vid_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","Nakajijela jila mipichilo kuli pete naziwele hafungo mwa honhu ha kulavila nhambiko leka kupichila. Honhu ha kulavila nhambiko aho hagongomanyigwe kwa mbao hawele na lukweme mgati. ");
INSERT INTO vid_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","Hamba nakagongomanya likuwe lya shaba na chikalilo chake cha shaba, shaba ayo nailawila kuli vilolelo vya wadala wawele vitumagwa hali lwizi lwa ihema lya Nguluwi. ");
INSERT INTO vid_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","Hamba nakagongomanya lugagala. Mipaziya ja ubanzi wa kusini mwa lugagala najali ja kitani itawigwe viwele na utali wa mita makumi gane na zine, ");
INSERT INTO vid_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","navyo najibatigwa kwa mizengo makumi meli jiwele na vikalilo makumi meli ja shaba. Ila fito za mizengo ajo na vibatililo vyake navyali vya sendi. ");
INSERT INTO vid_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","Ubanzi wa kasikazini utali wa ipaziya nawali mita makumi gane na zine na mizengo jake makumi meli ja shaba, ila fito za mizengo ajo na vibatililo vyake navyali vya sendi. ");
INSERT INTO vid_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","Ubanzi wa kolizinjilaga isanya nawali na ipaziya liwele na utali wa mita makumi meli na mbili na mizengo jake kumi na vikalilo vyake kumi. Fito za mizengo ajo na vibatililo vyake navyali vya sendi. ");
INSERT INTO vid_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","Ubanzi wa kolilawilaga isanya, nakwali na lwizi, ubanzi awo nawali na ugazi wa mita makumi meli na mbili. ");
INSERT INTO vid_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","Ipaziya lya ubanzi umwe wa lwizi nawali na ugazi wa mita sita na nusu, hamwe na mizengo jidatu na vikalilo vyake vidatu. ");
INSERT INTO vid_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","Ubanzi wunji hihyo nawali na ipaziya liwele na ugazi wa mita sita na nusu hamwe na mizengo jidatu na vikalilo vyake vidatu. ");
INSERT INTO vid_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","Mipaziya jeng'ha kuzunguluta lugagala najali ja kitani inojile itawigwe. ");
INSERT INTO vid_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","Vikalilo vyeng'ha vya mizengo navyali vya shaba, ila ngwamo za mizengo ajo na vibatililo vyake navyali vya sendi. Honhu hake ha kuchanya nahali ha sendi kahi mizengo jeng'ha najibatililwa na fito za sendi. ");
INSERT INTO vid_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","Ipaziya lya lwizi lwa lugagala naligongomanyigwa kwa sufu ya lanji ya buluu na zambalau na ndung'hu na kitani inojile itawigwe kwa uwanzi, nalyo nalyali na utali wa mita tisa na wimo wa mita mbili, kota navyoliwele ipaziya lya lugagala. ");
INSERT INTO vid_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","Kahi mizengo jake najali jine na vikalilo vine vya shaba. Ngwamo zake nazali za sendi na honhu hake ha kuchanya na fito zake navyali vya sendi. ");
INSERT INTO vid_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","Vigingi vyeng'ha vya ihema na vya lugagala hafungo mwa ihema navyali vya shaba. ");
INSERT INTO vid_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","Avi ndo vinhu navizenjile ihema lya Nguluwi, mina ihema lya ulolezi. Vinhu avi naviwazigwa na Walawi kwa malajizo ga Musa, hali ulongozi wa Itamali mwana wa mtambika Aluni. ");
INSERT INTO vid_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","Besaleli mwana wa Uli, mwana wa Huli wa nhanzi ya Yuda, nakadita chila chinhu Mkulu Nguluwi nayamlajize Musa. ");
INSERT INTO vid_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","Nakatanzigwa na Oholiabu mwana wa Ahisamachi wa nhanzi ya Dani, muwanzi wa kunoliga, kuchola na kutawa uzi wa sufu wa lanji ya buluu na zambalau na ndung'hu na kitani inojile itawigwe. ");
INSERT INTO vid_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","Zahabu yeng'ha naiwele nhambiko ya kwinula kuchanya, nawamlavile Mkulu Nguluwi kwa chiwalo cha kuzenjela ihema lya Nguluwi nayali na itunyo lya kilo miya nane na makumi saba na saba na gilamu miya zidatu kulawila kuli chipimilo cha ihema lya Nguluwi. ");
INSERT INTO vid_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","Sendi kulawa kuli Waisilaeli weng'ha wawazigwe, nayali na itunyo lya kilo elufu zidatu na kumi na saba na gilamu miya saba na makumi gahano kulawila na vipimilo vya ihema lya Nguluwi. ");
INSERT INTO vid_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","Chila munhu nayawazigwe kulawila miyaka makumi meli na kulutilila nakaganigwa kulavya nhambiko ya sendi gilamu zihano na walume weng'ha nawawazigwe nawali miya sita elufu na elufu zidatu na miya zihano na makumi gahano. ");
INSERT INTO vid_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","Kilo elufu zidatu za sendi nazigongomanya vila vikalilo miya imwe vya ihema lya Nguluwi na lila ipaziya, mina kilo makumi gadatu kwa chila chikalilo. ");
INSERT INTO vid_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","Zila kilo kumi na saba na gilamu makumi saba na zihano zisigale, nazigongomanya ngwamo za mizengo na kubakaliza honhu ha kuchanya ha mizengo na kuditichila fito zake. ");
INSERT INTO vid_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","Nhambiko za kwinula kuchanya za shaba Waisilaeli nazowamlavile Mkulu Nguluwi nazali na itunyo lya kilo elufu mbili na miya zine na makumi meli na zihano. ");
INSERT INTO vid_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","Besaleli nakahola shaba ayo na kugongomanyila vikalilo vya lwizi lwa ihema lya Nguluwi na honhu ha kulavila nhambiko ha shaba hamwe na utandawala wake wa shaba na vinhu vyeng'ha vya honhu ha kulavila nhambiko, ");
INSERT INTO vid_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","vikalilo vya lugagala luzungulute ihema lya Nguluwi na vya lwizi lwa lugagala na vigingi vyeng'ha vya ihema lya Nguluwi na vya lugagala. ");
INSERT INTO vid_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","Kwa sufu ya lanji ya buluu na ya zambalau na ndung'hu, nawatawa mivalo ja kuvala mhela wa kudita mijito ja honhu helile. Nawamhonela Aluni mivalo jelile kota Mkulu Nguluwi navyoyamlajize Musa. ");
INSERT INTO vid_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","Nawagongomanya chizibao kwa ng'weso ya zahabu na kwa sufu ya lanji ya buluu na zambalau na ndung'hu na kwa kitani inojile itawigwe. ");
INSERT INTO vid_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","Nawaponda zahabu na kuidumula kuli ng'weso nzisili leka zitawigwe hamwe na sufu ya lanji ya buluu na ya zambalau na ndung'hu na kitani inojile zitawigwe kwa uwanzi. ");
INSERT INTO vid_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","Chizibao acho nachigongomanyigwa kwa ng'weso mbili za kuwohela mmayega zihonigwe hamwe. ");
INSERT INTO vid_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","Isali nalitawigwa kwa uwanzi mchanya mwake leka kuwohela uwe chinhu chimwe na chizibao acho na uditikwa kwa vinhu hihyo, ng'weso ya zahabu na sufu ya buluu na zambalau na ndung'hu na kitani inojile itawigwe kota Mkulu Nguluwi navyoyamalajize Musa. ");
INSERT INTO vid_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","Hamba nawawika maganga galingupulika galinguchemigwa salidoniki, nakaganoliga na kugenjiza mli vibatililo vya zahabu, navyo navicholigwa kota munhu yacholile muhuli na matagwa kumi na meli ga Waisilaeli. ");
INSERT INTO vid_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","Nawagawika maganga ago galingupulika mmayega mwa chila chizibao leka kulajila nhanzi kumi na mbili za Isilaeli kota Mkulu Nguluwi navyoyamlajize Musa. ");
INSERT INTO vid_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","Wawanzi nawagongomanya chihako cha mmhambaga kota vila navyowagongomanyile chila chizibao kwa ng'weso ya zahabu na sufu ya lanji ya buluu na zambalau na ndung'hu na kwa kitani inojile ibotigwe. ");
INSERT INTO vid_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","Chihako acho nachali cha mlaba, sentimita makumi meli na mbili kwa sentimita makumi meli na mbili, nacho nachibinigwa. ");
INSERT INTO vid_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","Chihako acho nachinoligwa kwa misitali jine ja maganga ga sendi nyinji. Msitali wa mwaluko gali maganga ga akiki na topazi na alimasi ndung'hu, ");
INSERT INTO vid_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","msitali wa keli gali maganga ga zumalidi na yakuti ya samawati na alimasi, ");
INSERT INTO vid_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","msitali wa kadatu gali maganga ga yasinto na agate na ametisto, ");
INSERT INTO vid_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","na msitali wa kane gali maganga ga zabalajadi na shohamu na yasipi, geng'ha nagawichigwa vibatililo vya zahabu. ");
INSERT INTO vid_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","Lelo nakwali na maganga kumi na meli gacholigwe matagwa kumi na meli ga Waisilaeli. Nagali gacholigwe kota vyowalinguchola muhuli, chila limwe nalicholigwa itagwa honhu ha nhanzi kumi na mbili za Isilaeli. ");
INSERT INTO vid_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","Nawachigongomanyila chila chihako cha mmhambaga mikufu ja zahabu inojile itawigwe kota ng'weso. ");
INSERT INTO vid_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","Vivila nawagongomanya vibatililo vili vya zahabu inojile na pete mbili za zahabu kwa chiwalo cha chihako cha mmhambaga na kuviwika mli nzingo mbili za chihako acho. ");
INSERT INTO vid_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","Mikufu ajo mili ja zahabu nawawoha kuli pete azo kuli nzingo za chihako cha mmhambaga. ");
INSERT INTO vid_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","Zila nzingo mbili za mikufu ya zahabu nawazijela mli vila vibatililo vili na kuvibatiliza na vila vili vya mmayega mwa chizibao banzi ya kumwando. ");
INSERT INTO vid_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","Nawagongomanya pete mbili za zahabu na kuziwika kuli nzingo mbili hasi banzi ya mgati mwa chihako acho cha mmhambaga behi na chizibao. ");
INSERT INTO vid_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","Nawagongomanya pete zinji mbili za zahabu na kuzijela kumwando kuli banzi ya hasi ya vihande vya chihako acho, honhu hovilinguting'hana na lila isali litawigwe kwa uwanzi ng'hatu. ");
INSERT INTO vid_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","Nawawoha chihako cha mmhambaga kuli chizibao kwa kuting'haniza pete zake na chizibao kwa ng'weso ya lanji ya buluu leka chihako acho chileche kuhejela ila chikalile lila isali litawigwe kwa uwanzi, kota Mkulu Nguluwi vyoyamlajize Musa. ");
INSERT INTO vid_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","Nakagongomanya ijoho lya kuvala mgati mwa chizibao cha sufu ya lanji ya buluu. ");
INSERT INTO vid_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","Ijoho alyo nalyali na honhu ha kwinjizila mutwi hagati, nalyo nalizungulisilwa isali litawigwe leka lileche kudejeka. ");
INSERT INTO vid_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","Kuli lupindo lwa hasi mwa ijoho nawatawa unoligo wa makomamanga ga sufu ya lanji ya buluu na zambalau na ndung'hu na kitani inojile ya kutawa. ");
INSERT INTO vid_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","Hamba nawagongomanya nhogo za zahabu inojile na chila komamanga nawawika nhogo kuli lupindo lwa ijoho. ");
INSERT INTO vid_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","Ahyo, nhogo na komamanga na nhogo na komamanga, navilongola kuzunguluta lupindo alo lwa ijoho alyo, kota Mkulu Nguluwi navyoyamlajize Musa. ");
INSERT INTO vid_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","Hamba nawawatawila Aluni na wanage ijoho lya kitani inojile, ");
INSERT INTO vid_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","chipembelo cha kitani inojile na kofia za kitani inojile na lupati lwa kitani inojile itawigwe, ");
INSERT INTO vid_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","na misali ja kitani inojile itawigwe kwa sufu ya lanji ya buluu na zambalau na ndung'hu na kutawigwa vinojile ng'hatu kota vila Mkulu Nguluwi navyoyamlajize Musa. ");
INSERT INTO vid_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","Hamba nawagongomanya chibati cha zahabu inojile kwa chiwalo cha chipembelo chelile na kuchola mchanya mwake kota navyowacholile muhuli, “Yelile kwa Mkulu Nguluwi.” ");
INSERT INTO vid_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","Hamba nawaliwoha kumwando kwa chila chipembelo kwa ng'weso ya lanji ya buluu, kota Mkulu Nguluwi navyoyamlajize Musa. ");
INSERT INTO vid_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","Lelo mijito jeng'ha ja ihema lya Nguluwi najimala. Waisilaeli nawadita geng'ha kota Mkulu Nguluwi navyoyamlajize Musa. ");
INSERT INTO vid_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","Nawamigalila Musa ihema lya Nguluwi hamwe na vinhu vyesa, ngwamo na fulemu zake na migamba jake na mizengo na vibatililo vyake ");
INSERT INTO vid_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","na chigubiko cha migozi ja ing'holo ilume liwichigwe lanji ndung'hu na igozi lya igongolo linji lilingikala mbahali na ipaziya lya honhu helile ");
INSERT INTO vid_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","na isanduku lya ilagano na mipichilo jake na chigubiko cha uhanyisi ");
INSERT INTO vid_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","na chisaga na vinhu vyake vyesa na mibumunda jelile ");
INSERT INTO vid_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","na chinhu cha kuwichila chenje cha zahabu inojile na vyenje vyake na vinhu vyake vyesa hamwe na mafuta kwa chiwalo cha vyenje avyo ");
INSERT INTO vid_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","na honhu ha kulavila nhambiko ha zahabu na mafuta ga kubakala na ubani uwele na unhunyhililo unojile na ipaziya lya lwizi lwa ihema ");
INSERT INTO vid_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","na honhu ha kulavila nhambiko ha shaba na utandawala wake wa shaba na mipichilo jake na vinhu vyake vyesa na likuwe na chikalilo chake ");
INSERT INTO vid_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","na mipaziya ja lugagala na mizengo jake na vikalilo vyake na ipaziya lya lwizi lwa lugagala na ng'weso zake na vigingi vyake na vinhu vyesa naviganigwe kuli mijito ja ihema lya Nguluwi, ndo mina kahi lyanguchemigwa ihema lya nhing'hano ");
INSERT INTO vid_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","na mivalo jeng'ha jitawigwe goya kwa chiwalo cha mijito ja honhu helile, mina ndo mivalo jelile ja mtambika Aluni na ga wanage kwa chiwalo cha mijito ja utambika. ");
INSERT INTO vid_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","Waisilaeli nawadita chila chinhu kota Mkulu Nguluwi navyoyamlajize Musa. ");
INSERT INTO vid_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","Musa nakalola chila chinhu, nakakunda kota nawadita chila chinhu kota Mkulu Nguluwi navyoyalajize. Ahyo, Musa nakawatambichiza. ");
INSERT INTO vid_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","Mkulu Nguluwi nakamlonjela Musa, ");
INSERT INTO vid_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","“Kuli zuwa lya mwaluko lya mwezi wa mwaluko, kokwimiza ihema lya Nguluwi. ");
INSERT INTO vid_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","Mgati mwa ihema alyo kowika lila isanduku lya ilagano, hamba uwiche ipaziya kumwando mwake. ");
INSERT INTO vid_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","Kokwinjiza chisaga na kuwika vinhu vyake mchanya. Kokwinjiza chila chinhu cha kuwichila chenje na kuwika chenje chake mchanya mwake. ");
INSERT INTO vid_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","Honhu ha kulavila nhambiko ha zahabu ha kufunyizila ubani kohawika kumwado kwa isanduku lya ilagano, hamba koniniza ipaziya kuli lwizi lwa ihema lya Nguluwi. ");
INSERT INTO vid_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","Hala honhu ha kulavila nhambiko za kulakazwa kohawika kumwado kwa lwizi lwa ihema lya Nguluwi. ");
INSERT INTO vid_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","Likuwe koliwika mlugagala, hagati ha ihema lya Nguluwi na honhu ha kulavila nhambiko na kulimemeza mazi. ");
INSERT INTO vid_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","Kokwimiza lugagala na kuniniza ipaziya kuli lwizi lwake. ");
INSERT INTO vid_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","“Hamba, kohola mafuta ga kubakaliza na kulibakaliza ihema lya Nguluwi hamwe na vinhu vyake vyeng'ha na kuliwika liwe lya chiuyeng'ha na vinhu vyake vyeng'ha, nalyo lyowa lyelile. ");
INSERT INTO vid_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Hamba, kohawika hawe ha chiuyeng'ha honhu ha kulavila nhambiko za kulakazwa na vinhu vyake vyeng'ha kwa kuhabakaliza mafuta, naho howa helile ng'hatu. ");
INSERT INTO vid_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","Likuwe na chikalilo chake kahi koviwika viwe vya chiuyeng'ha na vyelile kwa kuvibakaliza mafuta kwa mijito yiyo du. ");
INSERT INTO vid_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","“Komchema Aluni na wanage woye hali lwizi lwa ihema lya Nguluwi, hamba uwahovuje. ");
INSERT INTO vid_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","Umvalize Aluni jila mivalo jelile, kombakaliza mafuta na kumdita yawe wa chiuyeng'ha, leka yaweze kukola mijito kota mtambika. ");
INSERT INTO vid_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","Uwacheme wanage na kuwavaliza jila mikanzu. ");
INSERT INTO vid_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","Hamba uwabakalize mafuta kota navyoumbakalize mhaza wa hewo, leka na hewo kahi wakole mijito kota watambika. Kubakalizwa mafuta aku kowenjiza kuli utambika wa mazuwa gose kuli lulelo lwao lweng'ha.” ");
INSERT INTO vid_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Lelo Musa nakadita geng'ha kota navyoyalajizwe na Mkulu Nguluwi. ");
INSERT INTO vid_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","Mli zuwa lya mwaluko lya mwezi wa mwaluko mwaka wa keli nalowalawile Misili, ihema lya Nguluwi nalimizwa. ");
INSERT INTO vid_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Musa nakawika vikalilo vyake, nakenula fulemu zake, nakebatiliza mipichilo jake na kwimiza mizengo jake. ");
INSERT INTO vid_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","Nakagonzola ipaziya mchanya mwa ihema na kuwika chigubiko cha ihema mchanya mwake kota Mkulu Nguluwi navyoyamlajize Musa. ");
INSERT INTO vid_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Hamba nakahola vila vibao vili vya maganga na kuviwika kuli lila isanduku. Nakajikoleza jila mipichilo kuli pete za isanduku na kuchiwika chigubiko cha uhanyisi mchanya mwake. ");
INSERT INTO vid_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","Hamba nakaliwika lila isanduku lya ilagano mgati mwa ihema na kuniniza ipaziya kumwando kwa isanduku. Ipaziya nalivisa isanduku lya ilagano kota Musa vyoyalajizwe na Mkulu Nguluwi. ");
INSERT INTO vid_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","Nakawika chisaga mgati mwa ihema lya Nguluwi, ubanzi wa kasikazini, honhu ha kunze mwa ipaziya ");
INSERT INTO vid_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","na mchanya mwake nakawika goya mibumunda hali Mkulu Nguluwi, kota Musa vyoyalajizwe na Mkulu Nguluwi. ");
INSERT INTO vid_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","Nakachiwika chinhu cha kuwichila chenje mgati mwa ihema lya Nguluwi, ubanzi wa kusini, chichilola na chisaga. ");
INSERT INTO vid_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","Amo, hali Mkulu Nguluwi, nakemiza vyenje vyake, kota Musa navyoyalajizwe na Mkulu Nguluwi. ");
INSERT INTO vid_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","Nakahawika hala honhu ha kulavila nhambiko ha zahabu kuli ihema lya Nguluwi, kumwando mwa ipaziya ");
INSERT INTO vid_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","na kufunyiza ubani uwele kununyhilila goya mchanya mwake, kota Musa navyoyalajizwe na Mkulu Nguluwi. ");
INSERT INTO vid_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","Nakaniniza ipaziya hali lwizi lwa ihema lya Nguluwi, ");
INSERT INTO vid_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","nakawika honhu ha kulavila nhambiko za kulakazwa hali lwizi lwa ihema lya Nguluwi. Nakalavya mchanya mwake nhambiko ya kulakaza na nhambiko ya nyhule, kota Musa navyoyalajizwe na Mkulu Nguluwi. ");
INSERT INTO vid_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","Nakaliwika likuwe mlugagala, hagati ha ihema lya Nguluwi na honhu ha kulavila nhambiko na kujela mazi ga kihovujila. ");
INSERT INTO vid_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","Musa na Aluni na wana wa Aluni, weng'ha nawahovuga moko na magulu ga hewo amo. ");
INSERT INTO vid_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","Chila lowenjile mng'handa mwa ihema lya Nguluwi ama lowahejelele hala honhu ha kulavila nhambiko, nawahovuga moko na magulu ga hewo kota Musa navyoyalajizwe na Mkulu Nguluwi. ");
INSERT INTO vid_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Mwiso Musa nakemiza lugagala kuzungulusila ihema lya Nguluwi na honhu ha kulavila nhambiko na kuwika ipaziya hali lwizi lwa lugagala. Ahyo, Musa nakasinda mijito yeng'ha. ");
INSERT INTO vid_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Hamba, yila ng'hungugu naigubika lila ihema lya Nguluwi na ukulu wa Mkulu Nguluwi naulimemeza ihema. ");
INSERT INTO vid_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","Musa nakalemwela kwinjila mgati mwa ihema lya Nguluwi kwa vila yila ng'hungugu naikala mchanya mwake na ukulu wa Mkulu Nguluwi naumema amo. ");
INSERT INTO vid_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Kuli majendo gawo geng'ha ga Waisilaeli, ng'hungugu yila loyinuligwe kulawila mchanya mwa ihema, nawenula majendo. ");
INSERT INTO vid_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","Wone ng'hungugu ayo hayinuligwe hewo nahawaluche majendo, nawabeteza mbaka mhela loyinuligwe. ");
INSERT INTO vid_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Kuli majendo ga hewo geng'ha, Waisilaeli nawaweza kuyona yila ng'hungugu ya Mkulu Nguluwi mchanya mwa ihema mhela wa nemisi na chila chiluli chikwaka mgati mwake nechilo.");
INSERT INTO vid_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","Mkulu Nguluwi nakamchema Musa kuli ihema lya heye na kudawala na heye, nakamlonjela, ");
INSERT INTO vid_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","“Walonjele Waisilaeli kota hana munhu kangugana kumlavila Mkulu Nguluwi nhambiko ya igongolo, kolihagula igongolo alyo kulawa kuli chilundo cha misenga ama ming'holo ama mhene. ");
INSERT INTO vid_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","“Wone munhu yalingulavya nhambiko ya kulakazwa, kolihagula isenga ibuguma lilihela nongwa kulawa kuli chilundo. Komlavila hali lwizi lwa ihema lya Nguluwi leka yakundigwe na Mkulu Nguluwi. ");
INSERT INTO vid_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","Kowika moko wa heye mchanya mwa mutwi wa isenga lya nhambiko ya kulakazwa, iwele yokundigwa kwa chiwalo cha kumditila uhanyisi. ");
INSERT INTO vid_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","Hamba, kolidumula singo alyo isenga hali Mkulu Nguluwi. Na hewo watambika wawele ndo walelwa wa Aluni, woihola danda na kuboholela banzi zeng'ha za honhu ha kulavila nhambiko hali lwizi lwa ihema lya Nguluwi. ");
INSERT INTO vid_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","Ayo munhu yegale isenga alyo kwa nhambiko ya kulakazwa, koliwambula na kudumula vipuli. ");
INSERT INTO vid_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","Awo watambika wawele ndo walelwa wa Aluni, wowika goya ngodi mchanya mwa honhu ha kulavila nhambiko na kubwina chiluli. ");
INSERT INTO vid_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","Hamba, walelwa wa Aluni wawele ndo watambika wohola vipuli vya iwunde na mutwi na mafuta na kuviwika mchanya mwa ngodi na mchanya mwa honhu ha kulavila nhambiko za kulakazwa kwa chiluli. ");
INSERT INTO vid_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","Ila mitumbu na magulu ga isenga alyo, munhu ayo kovihovuga kwa mazi. Mtambika koilakaza nhambiko ya kulakazwa hali honhu ha kulavila nhambiko kwa chiluli chiwele na unhunyhililo unojile wa kumnojeza Mkulu Nguluwi. ");
INSERT INTO vid_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","“Wone nhambiko ya heye ya kulakazwa koilavya kulawa kuli chilundo cha ming'holo ama mhene, ila kohagula ilume lilihela nongwa. ");
INSERT INTO vid_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","Kolidumulila singo kuli ubanzi wa kasikazini mwa honhu ha kulavila nhambiko hali Mkulu Nguluwi, awo watambika wawele ndo walelwa wa Aluni woboholela danda hali banzi zeng'ha za honhu ha kulavila nhambiko za kulakazwa. ");
INSERT INTO vid_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","Ila ayo munhu yegale igongolo alyo, kolidumula vipuli, kovilekaniza mutwi hamwe na mafuta ga ing'holo, na mtambika koviwika hali ngodi zilingwaka chiluli, hali honhu ha kulavila nhambiko. ");
INSERT INTO vid_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","Ila mitumbu na magulu ga ing'holo kogahovuga kwa mazi. Mtambika koilakaza yeng'ha hali honhu ha kulavila nhambiko. Ahyo ndo nhambiko ya kulakazwa kwa chiluli chiwele na unhunyhililo unojile na kumnojeza Mkulu Nguluwi. ");
INSERT INTO vid_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","“Wone komlavila Mkulu Nguluwi nhambiko ya kulakazwa ya videje, lelo kochigala nhambiko ya heye ya ng'hunda ya kisolo ama ng'hunda ya kufujigwa. ");
INSERT INTO vid_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","Mtambika kochigala chideje acho hali honhu ha kulavila nhambiko, kopobosola mutwi wa chideje na kuchilakaza hali honhu ha kulavila nhambiko. Danda ya chideje acho yokamigwa na kumizilwa hafungo ha honhu ha kulavila nhambiko. ");
INSERT INTO vid_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","Kolyusa lifu lyake hamwe na vinhu vya mgati mwa lifu na kuvitaga kuli ubanzi wa kolilawilaga isanya hali honhu ha kulavila nhambiko halinguwichigwa mivu. ");
INSERT INTO vid_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","Kochibata mabawa na kuchidadula, ila yaleche kuchidumula vipuli vili. Ila, mtambika kochilakaza hali honhu ha kulavila nhambiko, mchanya mwa ngodi. Ayo ndo nhambiko ya kulakazwa kwa chiluli chiwele na unhunyhililo unojile na kumnojeza Mkulu Nguluwi.” ");
INSERT INTO vid_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","“Munhu yoneche wone yochigala nhambiko ya nyhule kwa Mkulu Nguluwi, nhambiko ayo iwe ya utimbo unojile. Kojida mafuta na kuwika ubani mchanya mwa utimbo. ");
INSERT INTO vid_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","Hamba, kowegalila awo walelwa wa Aluni wawele ndo watambika. Kohola chiganza chimwe cha utimbo unojile hamwe na mafuta na ubani na koulakaza hali honhu ha kulavila nhambiko leka iwe nhambiko ya kukumbuchila kwa Mkulu Nguluwi. Ayo ndo nhambiko iwele na unhunyhililo unojile wa kumnojeza Mkulu Nguluwi kwa chiluli. ");
INSERT INTO vid_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","Honhu hasigale ha nhambiko ayo, ndo ya Aluni na walelwa wa heye. Aho ndo honhu helile ng'hatu ha nhambiko yalingulavilwa Mkulu Nguluwi kwa chiluli. ");
INSERT INTO vid_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","“Wone munhu yomlavila Nguluwi nhambiko ya nyhule ibanichigwe mchiko, ayo yowa ya mibumunda hajiwichigwe usaso wa utimbo unojile uhanzigwe na mafuta ga mzeituni, ama ga mibumunda mizisili johajiwichigwe usaso na jibakalizwe mafuta ga mzeituni. ");
INSERT INTO vid_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","Ila wone nhambiko youlingulavya ndo ibumunda litelechigwe migaye, ayo yowa ya utimbo unojile ulihela usaso uhanzigwe na mafuta ga mzeituni. ");
INSERT INTO vid_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","Mibumunda ajo jomogoligwa na kujidilwa mafuta, ayo ndo nhambiko ya nyhule. ");
INSERT INTO vid_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","Wone nhambiko youlingulavya ndo ya mibumunda jitelechigwe msufuliya, ayo yowa ya utimbo unojile na uwichigwa mafuta ga mzeituni. ");
INSERT INTO vid_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","Kochigala nhambiko ya nyhule igongomanyigwe na vinhu avi hali Mkulu Nguluwi, na kumha mtambika na heye kochigala hali honhu ha kulavila nhambiko. ");
INSERT INTO vid_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","Mtambika kohola honhu ha nhambiko ayo iwele ndo ya kukumbuchila na kuilakaza kwa chiluli mchanya mwa honhu ha kulavila nhambiko. Ayo ndo unhunyhililo unojile wa kumnojeza Mkulu Nguluwi. ");
INSERT INTO vid_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","Honhu hasigale ha nhambiko ya nyhule ndo ha Aluni na walelwa wa heye. Aho ndo honhu helile ng'hatu ha nhambiko ilingulavigwa kwa Mkulu Nguluwi kwa chiluli. ");
INSERT INTO vid_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","“Nhambiko yoneche ya nyhule youmgalila Mkulu Nguluwi yanguganigwa iwe igongomanyilwe ne usaso, ahyo hailingukundigwa kuwika usaso ne hanombwa kuli nhambiko zoyalingulavilwa Mkulu Nguluwi kwa chiluli. ");
INSERT INTO vid_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","Koweza kumgalila Mkulu Nguluwi mbena ya hegwe ya mwaluko kota nhambiko. Ila ago hogolavilwa hali honhu ha kulavila nhambiko kota unhunyhililo wa kumnojeza. ");
INSERT INTO vid_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","Kolakaza nhambiko za hegwe zeng'ha za nyhule na mwino. Ndangukomya uwiche mwino kuli nhambiko ya hegwe ya nyhule, ahyo mwino ndo ulajilo wa ilagano lyoyaditile Nguluwi hamwe na hemwe. Kowika mwino kuli nhambiko zeng'ha. ");
INSERT INTO vid_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","“Wone umlavila Mkulu Nguluwi nhambiko ya nyhule za mbena za hegwe za mwaluko, koilavya nyhule ayo inyale ibalasigwe na kutelechigwa kwa chiluli. ");
INSERT INTO vid_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","Kowika mafuta ga mzeituni na ubani, ayo ndo nhambiko ya nyhule. ");
INSERT INTO vid_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","Mtambika kolakaza honhu ha nhambiko ayo ya nyhule ibalaswe na mafuta hamwe na ubani wa heye weng'ha, ndo yowa nhambiko ya kukumbuchila, ayo ndo nhambiko yalingulavilwa Mkulu Nguluwi kwa chiluli. ");
INSERT INTO vid_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","“Wone munhu kangulavya nhambiko ya kikala goya hali Mkulu Nguluwi, nhambiko ya heye ndo isenga ibuguma ama idala kulawa kuli chilundo, lelo igongolo alyo lileche kuwa na nongwa. ");
INSERT INTO vid_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","Kowika moko wa heye mchanya mwa mutwi mwa igongolo alyo na kulidumula singo hali lwizi lwa ihema lya Nguluwi. Awo watambika wawele ndo walelwa wa Aluni, woboholela danda ayo honhu ha kulavila nhambiko banzi zeng'ha. ");
INSERT INTO vid_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","Mafuta geng'ha galingugubika mitumbu ja igongolo lya nhambiko ayo ya kikala goya kogalakaza kota nhambiko yalingulavilwa Mkulu Nguluwi kwa chiluli. ");
INSERT INTO vid_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","Kolavya kahi zila figo mbili na mafuta gake hamwe na hala honhu hanojile ng'hatu ha chini. ");
INSERT INTO vid_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","Walelwa wa Aluni woilakaza honhu ha kulavila nhambiko mchanya mwa nhambiko ya kulakazwa iwele mchanya mwa ngodi, ayo ndo nhambiko ilingulavigwa kwa chiluli iwele na unhunyhililo unojile ulingumnojeza Mkulu Nguluwi. ");
INSERT INTO vid_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","“Wone nhambiko ayo ya kikala goya youlingumlavila Mkulu Nguluwi ndo kulawa kuli chilundo cha ming'holo ama mhene, lelo lihaguligwe ilume ama idala lilihela nongwa. ");
INSERT INTO vid_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","Wone munhu yolavya ing'holo lyana liwe nhambiko ya heye, lelo kolilavila hali Mkulu Nguluwi. ");
INSERT INTO vid_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","Kowika moko wa heye mchanya mwa mutwi wa ing'holo alyo na kulidumula singo hali ihema lya Nguluwi. Watambika wawele ndo walelwa wa Aluni, woboholela danda ayo hali honhu ha kulavila nhambiko banzi zeng'ha. ");
INSERT INTO vid_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","Hamba, kulawa kuli nhambiko ya kikala goya yalingulavilwa Mkulu Nguluwi kwa chiluli, komlavila mafuta na mafuta ga mumchila uwele udumuligwe habehi ng'hatu na chigudi cha mgongosango na mafuta geng'ha galingugubika mitumbu, ");
INSERT INTO vid_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","na zila figo mbili na mafuta hamwe na honhu hanojile ng'hatu ha chini. ");
INSERT INTO vid_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","Mtambika kovilakaza avyo vyeng'ha mchanya mwa honhu ha kulavila nhambiko kota chilyo choyalingulavilwa Mkulu Nguluwi kwa chiluli. ");
INSERT INTO vid_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","“Wone nhambiko ya heye ndo mhene, lelo komlavila hali Mkulu Nguluwi. ");
INSERT INTO vid_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","Kowika moko wa heye mchanya mwa mutwi wa igongolo alyo na kulidumula singo hali ihema lya Nguluwi. Walelwa wa Aluni woboholela danda honhu ha kulavila nhambiko banzi zeng'ha. ");
INSERT INTO vid_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","Hamba kolavya kulawa kuli nhambiko ya kikala goya kwa Mkulu Nguluwi kwa chiluli, mafuta geng'ha galingugubika mitumbu, ");
INSERT INTO vid_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","na zila figo mbili na mafuta, hamwe na honhu hanojile ng'hatu ha chini. ");
INSERT INTO vid_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","Mtambika kovilakaza mchanya mwa honhu ha kulavila nhambiko kota chilyo chilingulavigwa kwa chiluli, kulavya unhunyhililo wa kumnojeza Mkulu Nguluwi. Mafuta geng'ha ndo ga Mkulu Nguluwi. ");
INSERT INTO vid_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","Ndo mina ilajizo lya mazuwa gose kwa lulelo lweng'ha na honhu honeche holulingukala. Mleche kulya mafuta ne danda.” ");
INSERT INTO vid_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","Mkulu Nguluwi nakamlonjela Musa, ");
INSERT INTO vid_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","“Walonjele wanhu wa Isilaeli kota wone munhu nakadita gehile ne kunuwila, na nakadita chinhu chilemezwe na mzilo wa Mkulu Nguluwi, kodita mbuli azi. ");
INSERT INTO vid_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","“Wone mtambika mkulu yawele yabakalizwe mafuta ndo yaditile gehile, ahyo nakawenjiza wanhu mli nongwa. Lelo ayo komlavila Mkulu Nguluwi ilogota ilume lilihela nongwa, liwe nhambiko ya gehile. ");
INSERT INTO vid_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","Koligala alyo ilogota hali lwizi lwa ihema lya Nguluwi, hali Mkulu Nguluwi, na heye kowika moko wa heye mchanya mwa mutwi wa alyo ilogota na kulidumula singo hali Mkulu Nguluwi. ");
INSERT INTO vid_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","Ayo mtambika mkulu yabakalizwe mafuta kohola chasi cha danda na kwinjila nayo mgati mwa ihema lya Nguluwi. ");
INSERT INTO vid_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","Kozabika chidole cha heye kuli danda ayo na kumizila mala saba hali Mkulu Nguluwi kumwando kwa ipaziya lya honhu helile. ");
INSERT INTO vid_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","Mtambika mkulu kohola honhu ha danda na kuzibakaliza mbalati za honhu ha kulavila nhambiko ha kufunyizila ubani wa unhunyhililo unojile hali Mkulu Nguluwi kuli ihema lya Nguluwi. Danda isigale kobohola hanyi hali chikalilo cha honhu ha kulavila nhambiko za kulakazwa hawele habehi na lwizi lwa ihema lya Nguluwi. ");
INSERT INTO vid_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","Hamba kokusa mafuta geng'ha ga alyo ilogota ilume, na mafuta geng'ha galingugubika mitumbu ");
INSERT INTO vid_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","na figo mbili na mafuta gawele mchanya na gala gawele mchuno na honhu hanojile ng'hatu ha chini, ");
INSERT INTO vid_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","kota vila mafuta galingusigwa kulawa kuli isenga lya nhambiko ya kikala goya. Hamba mtambika mkulu kohola na kulakaza hali honhu ha kulavila nhambiko za kulakazwa. ");
INSERT INTO vid_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","Ila igozi lya alyo ilogota ilume na miunde na mutwi na magulu na mitumbu na midohe, ");
INSERT INTO vid_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","liwele ndo ilogota ilume lyeng'ha lisigale lyoholigwa na kulilakaza kunze mwa kambi hali honhu habaguligwe hawele nguboholigwa mivu hali honhu hanojile. Lyolakazwa kwa chiluli mchanya mwa ngodi aho honhu ha kuboholela mivu. ");
INSERT INTO vid_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","“Wone Waisilaeli weng'ha nawadita gehile ne kunuwila, kwa kudita chinhu chilemezigwe na mzilo wa Mkulu Nguluwi, wana nongwa. ");
INSERT INTO vid_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","Hamba gehile ago hogozeleka, Waisilaeli weng'ha wolavya ilogota ilume liwe nhambiko ya gehile. Waisilaeli weng'ha woligala hali ihema lya Nguluwi. ");
INSERT INTO vid_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","Wasekulu wa Waisilaeli weng'ha wowika moko ga hewo hali mutwi wa alyo ilogota ilume, hamba lyodumuligwa singo hali Mkulu Nguluwi. ");
INSERT INTO vid_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","Yula mtambika mkulu yahaguligwe kwa kubakalizwa mafuta kochigala honhu ha danda ya alyo ilogota mgati mwa ihema lya Nguluwi. ");
INSERT INTO vid_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","Kozabika chidole cha heye kuli ayo danda na kuimizila hali ipaziya mala saba hali Mkulu Nguluwi. ");
INSERT INTO vid_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","Hamba, honhu ha danda kobakaliza mbalati kuli honhu ha kulavila nhambiko hawele kuli ihema lya Nguluwi hali Mkulu Nguluwi. Danda isigale kobohola hanyi hali chikalilo cha honhu ha kulavila nhambiko za kulakazwa habehi na lwizi lwa ihema lya Nguluwi. ");
INSERT INTO vid_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","Mafuta geng'ha ga ilogota alyo kohola na kugalakaza hali honhu ha kulavila nhambiko. ");
INSERT INTO vid_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","Lelo kolidita alyo ilogota ilume kota vyoyaliditile alila liyage lya nhambiko ya gehile. Lelo kwa nzila ayi, mtambika mkulu kanguwaditila wanhu uhanyisi, na hewo wolechelwa. ");
INSERT INTO vid_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","Hamba kolajiza ilogota alyo kugaligwa kunze mwa kambi na kulilakaza kwa chiluli kota vyoyaliditile alila liyage. Ayo ndo nhambiko ya gehile ga Waisilaeli weng'ha. ");
INSERT INTO vid_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","“Wone chilongozi nakadita gehile ne kunuwila vyoyodita chinhu chilemezwe na choyalonjile Mkulu Nguluwi, Nguluwi wa heye, ayo kana nongwa, ");
INSERT INTO vid_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","hoyovizela gehile goyaditile, kochigala nhambiko ya heye ya ipongo lilihela nongwa. ");
INSERT INTO vid_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","Kowika moko wa heye mchanya mwa mutwi wa ipongo na kulidumulila singo honhu ha kudumulila singo nhambiko za kulakazwa hali Mkulu Nguluwi, ayo ndo nhambiko ya gehile. ");
INSERT INTO vid_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","Mtambika mkulu kozabika chidole cha heye kuli danda ya nhambiko ya gehile na kubakaliza mbalati kuli honhu ha kulavila nhambiko za kulakazwa. Danda isigale koibohola hanyi hali chikalilo cha honhu aho ha kulavila nhambiko. ");
INSERT INTO vid_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","Mafuta geng'ha ga ipongo alyo kogalakaza hali honhu ha kulavila nhambiko kota vyoyaditile kuli mafuta ga isenga lya nhambiko ya kikala goya. Kwa nzila ayi, mtambika kangumditila uhanyisi chilongozi ayo, na kolechelwa gehile ga heye. ");
INSERT INTO vid_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","“Wone munhu wa hihi hela nakadita gehile ne kunuwila, kwa kudita chinhu chilemezigwe na mzilo wa Mkulu Nguluwi, ayo kana nongwa. ");
INSERT INTO vid_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","Hamba naloyalonjelwe kota nakadita gehile, kochigala nhambiko ya mhene ndala ilihela nongwa kwa chiwalo cha gehile goyaditile. ");
INSERT INTO vid_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","Kowika moko wa heye mchanya mwa mutwi wa mhene ayo ya nhambiko ya gehile, na kuidumula singo honhu ha nhambiko ya kulakazwa. ");
INSERT INTO vid_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","Mtambika kozabika chidole cha heye kuli danda na kubakaliza mbalati kuli honhu ha kulavila nhambiko za kulakazwa. Danda isigale koibohola hanyi hali chikalilo chake. ");
INSERT INTO vid_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","Mafuta geng'ha ga mhene ayo kogosa kota vyoyosile mafuta ga migongolo ja nhambiko ya kikala goya, na heye mtambika kogalakaza hali honhu ha kulavila nhambiko, na unhunyhililo unojile womnojeza Mkulu Nguluwi. Lelo kwa nzila ayi, mtambika komditila uhanyisi munhu ayo, na kolechelwa. ");
INSERT INTO vid_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","“Wone munhu ayo kochigala ing'holo lyana kwa chiwalo cha nhambiko ya gehile, lelo kochigala ing'holo lyana idala lilihela nongwa. ");
INSERT INTO vid_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","Kowika moko wa heye mchanya mwa mutwi wa ing'holo lyana alyo lya nhambiko ya gehile na kulidumula singo honhu ha nhambiko ya kulakazwa. ");
INSERT INTO vid_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","Hamba mtambika kozabika chidole cha heye kuli danda ya nhambiko ya gehile na kubakaliza mbalati honhu ha kulavila nhambiko za kulakazwa. Danda isigale koibohola hanyi hali chikalilo chake. ");
INSERT INTO vid_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","Hamba kokusa mafuta geng'ha kota vyoyosile mafuta ga ing'holo lyana lya nhambiko ya kikala goya na mtambika kogalakaza hali honhu ha kulavila nhambiko hamwe na nhambiko zilingulavigwa kwa Mkulu Nguluwi kwa chiluli. Kwa nzila ayi, mtambika komditila uhanyisi ayo munhu na heye kolechelwa gehile ga heye.” ");
INSERT INTO vid_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","“Wone munhu yoneche yoganigwa kulavya ulolezi kuli chitala kuwala mbuli yoyawene ama yoyahuliche na heye wone yaleme kulonga chinhu, lelo ago ndo gehile na koganigwa kugazigwa kwa chiwalo cha gehile ga heye. ");
INSERT INTO vid_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","Ama kota munhu yoneche hali hemwe nakawa yakokomoche ne kunuwila kwa kudoliza chinhu choneche chikokomoche, uwe mtufi wa igongolo lya kisolo ama lya kufujigwa ama vilumbigwe vilingutambala, kowa yakokomoche na kahi kowa na nongwa. ");
INSERT INTO vid_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","Ama munhu wone yadolize chinhu chikokomoche cha munhu ama chinhu choneche chilingumdita munhu yawe yakokomoche ne heye kuvizela, lelo loyovizela kowa na nongwa. ");
INSERT INTO vid_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","Ama wone munhu yelahe kudita choneche chila ne kijesa, chinojile ama chihile, kota yula halinguvizela, lelo loyovizela kowa na nongwa. ");
INSERT INTO vid_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","Lelo wone munhu yawe na nongwa kuwala mbuli zoneche zila, imgana yalonje kwa mlomo wa heye gehile ga heye goyaditile ");
INSERT INTO vid_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","na kumigalila Mkulu Nguluwi nhambiko kwa kilipiza kwa gehile ga heye goyaditile. Kochigala ing'holo idala ama mhene ndala yamlavye nhambiko ya gehile. Mtambika komditila uhanyisi kwa gehile ga heye. ");
INSERT INTO vid_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","“Ila wone yolemwela kulavya ing'holo lyana kwa kilipiza kwa chiwalo cha gehile ga heye goyaditile, lelo komigalila Mkulu Nguluwi ng'hunda mbili za kisolo ama ng'hunda mbili za kufujigwa, imwe kwa chiwalo cha nhambiko ya gehile, na iyage kwa chiwalo cha nhambiko ya kulakazwa. ");
INSERT INTO vid_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","Kozigala ng'hunda azo kwa mtambika, na heye mtambika koilavya imwe iwe nhambiko ya gehile kwa kuipobosola singo ne kusa mutwi. ");
INSERT INTO vid_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","Honhu ha danda ya nhambiko ya gehile, koimizila hafungo ha honhu ha kulavila nhambiko na ila iyage koikamila hanyi hali chikalilo cha honhu ha kulavila nhambiko. Ayo ndo nhambiko ya gehile. ");
INSERT INTO vid_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","Hamba koilavya ila ng'hunda ya keli iwe nhambiko ya kulakazwa kwa chiwalo cha utaguso. Mtambika komditila uhanyisi munhu ayo kwa chiwalo cha gehile goyaditile, na heye kolechelwa. ");
INSERT INTO vid_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","“Wone yolemwela kulavya ng'hunda mbili za kisolo ama za kufujigwa kota nhambiko ya heye ya gehile goyaditile, lelo kochigala utimbo unojile kilo imwe. Ila howika mafuta ne ubani kwa vila ndo nhambiko ya gehile. ");
INSERT INTO vid_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","Komigalila mtambika na mtambika kohola utimbo awo unojile chiganza chimwe na kulakaza mchanya ha honhu ha kulavila nhambiko kota honhu ha kukumbuchila, hamwe na nhambiko zoyalingulavilwa Mkulu Nguluwi kwa chiluli. Ayo ndo nhambiko ya gehile. ");
INSERT INTO vid_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","Lelo mtambika komditila uhanyisi ayo munhu kwa chiwalo cha gehile, na heye kolechelwa. Utimbo usigale wowa wa heye mtambika kota vyoilinguditigwa kuwala nhambiko ya nyhule.” ");
INSERT INTO vid_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","Mkulu Nguluwi nakamlonjela Musa, ");
INSERT INTO vid_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","“Wone munhu yoneche kangudita gehile ne kunuwila kuwala kuleka kulavya vinhu vyelile vyoyalingulavilwa Mkulu Nguluwi, komigalila ing'holo ilume lilihela nongwa kulawa kuli chilundo. Ing'holo ilume lyopimigwa kwa kuwinza chipimilo cha sendi za ihema lya Nguluwi. Ayo ndo nhambiko ya nongwa. ");
INSERT INTO vid_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","Ayo munhu kahi kolipizila vinhu vyoyalechile kulavya kuwala vinhu vyelile na konjezela honhu ha kahano ha vinhu vya heye na kumha mtambika. Lelo mtambika komditila uhanyisi kwa chiwalo cha gehile kwa alyo ing'holo ilume liwele nhambiko ya nongwa, na heye kolechelwa. ");
INSERT INTO vid_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","“Munhu yoneche wone yodita gehile ne kunuwila kwa kubena mzilo woneche wa Mkulu Nguluwi, heye kana nongwa na kogazigwa kwa chiwalo cha nongwa za heye. ");
INSERT INTO vid_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","Komigalila mtambika ing'holo ilume lilihela nongwa kuli chilundo ama kuguligwa kwa sendi zilingiwhana na lila ing'holo kwa nhambiko ya nongwa. Na mtambika komditila uhanyisi kwa nongwa yoyaditile ne kunuwila na heye kolechelwa. ");
INSERT INTO vid_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","Ayo ndo nhambiko ya nongwa, kukomya heye kana nongwa hali Mkulu Nguluwi.” ");
INSERT INTO vid_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","Mkulu Nguluwi nakamlonjela Musa, ");
INSERT INTO vid_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","“Wone munhu yoneche nakadita gehile na kumhinduka Mkulu Nguluwi kwa kumhada yalihabehi na heye kuwala ng'hano ama honhu ha yoyawichilwe, ama kumboka ama kumbunza miyage, ");
INSERT INTO vid_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","ama wone yalokote chinhu chajilile, nakalonga kota nahachiwene, ama nakelaha udesi kwa choneche chiwelenguwadita wanhu wawe na gehile, ");
INSERT INTO vid_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","munhu ayo loyowa yodita gehile na kuwa na nongwa, imgana yahilule choyahizile ama choyapatile kwa kubunza, ama ng'hano yoyapegwe, ama chinhu chajilile choyachiwene, ");
INSERT INTO vid_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","ama choneche choyelahile kwa udesi. Kohilusa chila chinhu chenele na konjeza honhu ha kahano kwa yula yoyabunzigwe zuwa lila du loyovizela nongwa ya heye. ");
INSERT INTO vid_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","Hamba komigalila mtambika ing'holo ilume ama ipongo lilihela nongwa yamlavile Mkulu Nguluwi nhambiko ya nongwa, ama kuguligwa kwa sendi zilingiwhana na lila ing'holo kwa nhambiko ya nongwa. ");
INSERT INTO vid_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","Mtambika komditila uhanyisi hali Mkulu Nguluwi, na heye kolechelwa gehile goyaditile.” ");
INSERT INTO vid_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","Mkulu Nguluwi nakamlonjela Musa, ");
INSERT INTO vid_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","“Walonjele Aluni na walelwa wa heye ulonzi awu, ‘Aga ndo malajizo galinguwala nhambiko ya kulakazwa. Nhambiko ya kulakazwa yowa mchiluli mchanya mwa honhu ha kulavila nhambiko nechilo yeng'ha mbaka mitondo na chiluli chikolezwe, chileche kuzima. ");
INSERT INTO vid_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","Hamba mtambika vyonayali yavalile ivalo lya heye lya kitani na lupati lwa heye lwa kitani kohola mivu ja yila nhambiko ya kulakazwa kwa chiluli kulawa hali honhu ha kulavila nhambiko na kujiwika hafungo ha honhu ha kulavila nhambiko. ");
INSERT INTO vid_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","Hamba kovala mivalo jinji ja heye na kojihilika ajila mivu honhu hawele habaguligwe kunze mwa kambi hali honhu hanojile. ");
INSERT INTO vid_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","Chiluli cha honhu ha kulavila nhambiko changuganigwa chilutilile kwaka, na hachiganigwe kuzimigwa. Chila zuwa mitondo mtambika kowika ngodi hali chiluli acho na mchanya mwake kowika nhambiko za kulakazwa, yang'hali lakaza mafuta ga igongolo lya nhambiko ya kikala goya. ");
INSERT INTO vid_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","Chiluli cholutilila kwaka mazuwa gose hali honhu ha kulavila nhambiko ne kuzimigwa. ");
INSERT INTO vid_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","“ ‘Aga ndo malajizo galinguwala nhambiko ya nyhule. Walelwa wa Aluni womlavila Mkulu Nguluwi nhambiko ayo kumwando kwa honhu ha kulavila nhambiko. ");
INSERT INTO vid_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","Yumwe wa watambika kohola chiganza chimwe cha utimbo unojile wa nhambiko ya nyhule hamwe na mafuta ga mzeituni na ubani weng'ha na kuvilakaza hali honhu ha kulavila nhambiko kota honhu ha kukumbuchila, leka kunhunyhilila kunojile kumnojeze Mkulu Nguluwi. ");
INSERT INTO vid_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","Utimbo unojile usigale wolya Aluni na walelwa wa heye watambika ne kuwichigwa usaso. Wolya hali honhu helile, hali lugagala lwa ihema lya Nguluwi. ");
INSERT INTO vid_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","Uleche kubanichigwa hamwe na usaso. Ndiwapa hewo honhu aho kulawa nhambiko ilavigwe kwa chiluli. Ayo ndo nhambiko yelile ng'hatu kota vyozili nhambiko za gehile na nhambiko za nongwa. ");
INSERT INTO vid_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","Walelwa walume wa Aluni ndo waliyeka wakundigwe kulya honhu aho kota vyoilajizwe mazuwa gose kulawa kuli nhambiko yalingulavilwa Mkulu Nguluwi kwa chiluli. Imgana munhu yawe yelile kuweza kudoliza vinhu avyo.’ ” ");
INSERT INTO vid_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","Mkulu Nguluwi nakamlonjela Musa, ");
INSERT INTO vid_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","“Zuwa lya kubakalizwa mafuta Aluni na walelwa wa heye wanguganigwa kumlavila Mkulu Nguluwi nhambiko ya nyhule ya kilo imwe ya utimbo unojile kota nhambiko ya chila zuwa, nusu imwe ya utimbo awo koilavya mitondo na nusu iyage matinazo. ");
INSERT INTO vid_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","Utimbo awo wohanzigwa na mafuta na kubanichigwa migaye, hamba kougala uwele mvipuli na kumlavila Mkulu Nguluwi kota nhambiko ya nyhule, na unhunyhililo wa nhambiko ayo womnojeza Mkulu Nguluwi. ");
INSERT INTO vid_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","Mtambika yawele mlelwa wa Aluni, yawele yabakalizwe mafuta kibata mijito ja heye komlavila Mkulu Nguluwi nhambiko ayo, alyo ndo ilajizo lya mazuwa gose. Nhambiko yeng'ha yolakazwa. ");
INSERT INTO vid_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","Nhambiko yoneche ya nyhule ilavigwe na mtambika yolakazwa yeng'ha, haiwa ya kulya hebu.” ");
INSERT INTO vid_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","Mkulu Nguluwi nakamlonjela Musa, ");
INSERT INTO vid_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","“Mlonjele Aluni na mwanage kota aga ndo malajizo ga nhambiko kuwala nhambiko ya gehile. Honhu hala hawele igongolo lya nhambiko ya kulakazwa hudumulilwa singo, ndo honhu holidumuligwa singo igongolo lya nhambiko ya gehile hali Mkulu Nguluwi. Ayo ndo nhambiko yelile ng'hatu. ");
INSERT INTO vid_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","Mtambika yawelengulavila nhambiko ayo ndo yolya. Yolika honhu helile, kuli lugagala lwa ihema lya Nguluwi. ");
INSERT INTO vid_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","Choneche chidoliza iwunde alyo chowa chelile, ivalo lyoneche wone limizilwe danda ya nhambiko ayo, lelo ivalo alyo lihovujigwe hali honhu helile. ");
INSERT INTO vid_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","Miwunde ja nhambiko ayo wone jitelechigwe mchiya, chiya acho chotuligwa. Ila wone chinhu acho ndo cha shaba, lelo chokwanguligwa na kuhovujigwa goya kwa mazi. ");
INSERT INTO vid_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","Walingukundigwa kulya ndo walume wa lukolo lwa watambika waliyeng'ha, ayo ndo nhambiko yelile ng'hatu. ");
INSERT INTO vid_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","Ila kota danda ya nhambiko yoneche ya gehile igaligwa mgati mwa ihema lya Nguluwi leka kudita uhanyisi hali honhu helile, nhambiko ayo hailinguganigwa kuligwa ila ilakazwe kwa chiluli.” ");
INSERT INTO vid_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","“Aga ndo malajizo galinguwala nhambiko ya nongwa. Nhambiko ayo ndo yelile ng'hatu. ");
INSERT INTO vid_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","Igongolo lya nhambiko ya nongwa lyodumuligwa singo honhu hojilingudumuligwa singo migongolo ja nhambiko ya kulakazwa, na danda yoboholigwa hali honhu ha kulavila nhambiko banzi zeng'ha. ");
INSERT INTO vid_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","Mafuta geng'ha na mafuta ga mchila na gala mafuta galingugubika mitumbu golavigwa, ");
INSERT INTO vid_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","na zila figo mbili hamwe na mafuta ga zila figo gawele mchuno na hala honhu hanojile ng'hatu ha chini. ");
INSERT INTO vid_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","Mtambika kovilakaza hali honhu ha kulavila nhambiko kota nhambiko yalingulavilwa Mkulu Nguluwi kwa chiluli. Ayo ndo nhambiko ya nongwa. ");
INSERT INTO vid_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","Walingukundigwa kulya nhambiko ayo ndo walume wa lukolo lwa watambika wali yeng'ha, ayo ndo nhambiko yelile ng'hatu. Yolika hali honhu helile. ");
INSERT INTO vid_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","Malajizo aga ndo gamwe kuwala nhambiko ya nongwa na nhambiko ya gehile. Mtambika yalingudita uhanyisi, ayo ndo kolihola iwunde lya nhambiko. ");
INSERT INTO vid_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","Mtambika yalingulavya nhambiko ya kulakazwa ya munhu yunji, kohola igozi lya igongolo lilavigwe. ");
INSERT INTO vid_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","Nhambiko yoneche ya nyhule ibanichigwe mchiko ama msufuliya ama migaye yowa ya mtambika yalinguilavya. ");
INSERT INTO vid_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","Chila nhambiko ya nyhule, iwe ihanzigwe na mafuta ama hebu, yowa ya walelwa wa Aluni na weng'ha wagawilwe kota winji wa hewo vyouwele. ");
INSERT INTO vid_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","“Aga ndo malajizo galinguwala nhambiko za kikala goya ziwele munhu koweza kumlavila Mkulu Nguluwi. ");
INSERT INTO vid_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","Wone munhu yolavya nhambiko yakuta malumbo Nguluwi, lelo koilavya hamwe na mibumunda johajiwichigwe usaso gahanzigwe na mafuta ga mzeituni, mibumunda mizisili jibachigwe mafuta ga mzeituni na mibumunda ja utimbo unojile uhanzigwe na mafuta ga mzeituni. ");
INSERT INTO vid_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","Hamwe na nhambiko ayo ya heye ya kikala goya yakuta malumbo Nguluwi, kochigala mibumunda jiwichigwe usaso. ");
INSERT INTO vid_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","Kwa chiwalo cha mibumunda ajo, komlavila Mkulu Nguluwi ibumunda limwe kulawa chila nhambiko, mibumunda ajo jowa ja heye mtambika yalingubohola danda ya nhambiko za kikala goya hali honhu ha kulavila nhambiko. ");
INSERT INTO vid_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","Iwunde lya nhambiko ayo ya kikala goya lyakuta malumbo Nguluwi, yolika zuwa lilila lilavigwe, holeka ne honhu mbaka mitondo. ");
INSERT INTO vid_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","Ila wone nhambiko ayo ya kikala goya ndo ya kutawiza kilaha ama ya kunuwila, yolika mazuwa gago vyoilavigwa na honhu hasigale hoganigwa kulika zuwa lya keli. ");
INSERT INTO vid_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","Ila miwunde joneche ja nhambiko ayo isigale mbaka zuwa lya kadatu jolakazwa kwa chiluli. ");
INSERT INTO vid_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","Wone iwunde lyoneche lya nhambiko ya kikala goya ilika zuwa lya kadatu, munhu yailavile hokundigwa, ne nhambiko haiwazigwa. Iwunde alyo ndo likokomoka na munhu yolya miwunde alyo, koganigwa kugazigwa. ");
INSERT INTO vid_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","Iwunde lyoneche lidoliza chinhu chikokomoche jileche kulika. Iwunde alyo lyolakazwa kwa chiluli. “Weng'ha welile woweza kulya iwunde ");
INSERT INTO vid_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","lilavigwe nhambiko ya kikala goya kwa Mkulu Nguluwi. Ila munhu yoneche yawele yakokomoche, wone yalye iwunde alyo, kobaguligwa na wanhu wa heye. ");
INSERT INTO vid_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","Munhu yoneche yodoliza chinhu choneche chikokomoche ama chinhu cha munhu chikokomoche ama igongolo likokomoche ama chilumbigwe choneche chikokomoche ndo chilinguzudiza, hamba wone yalye iwunde lya nhambiko ya kikala goya yalavigwe Mkulu Nguluwi, munhu ayo kobaguligwa na wanhu wa heye.” ");
INSERT INTO vid_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","Mkulu Nguluwi nakamlonjela Musa, ");
INSERT INTO vid_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","“Walonjele Waisilaeli ahi. Mleche kulya mafuta ga isenga ama ga ing'holo ama ga mhene. ");
INSERT INTO vid_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","Mafuta ga igongolo lyoneche libagame lilyo ama ga igongolo likopoligwe na igongolo lya kisolo woweza kuwichigwa kwa kugongomanyila mbuli zinji, mleche kulya. ");
INSERT INTO vid_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","Munhu yoneche wone yalye mafuta ga igongolo lilavigwe nhambiko kwa Mkulu Nguluwi kwa chiluli, kobaguligwa na wanhu wa heye. ");
INSERT INTO vid_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","Kahi, mleche kulya danda yoneche ila, iwe ya chideje ama ya igongolo honhu honeche homlingikala. ");
INSERT INTO vid_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","Munhu yoneche wone yalye danda yoneche, kobaguligwa na wanhu wa heye.” ");
INSERT INTO vid_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","Mkulu Nguluwi nakamlonjela Musa, ");
INSERT INTO vid_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","“Walonjele wanhu wa Isilaeli kota munhu yoneche wone yalavye nhambiko ya kikala goya, komha Mkulu Nguluwi honhu ha nhambiko ayo. ");
INSERT INTO vid_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","Komigalila kwa moko ga heye yuye kota nhambiko kwa chiluli. Kochigala mafuta hamwe na mhambaga iwele kokwinula kuchanya kwa ulajilo wa kumlavila nhambiko Mkulu Nguluwi. ");
INSERT INTO vid_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","Mtambika kolakaza mafuta geng'ha hali honhu ha kulavila nhambiko, ila iwunde lya mmhambaga lyowa lya Aluni na wanage watambika. ");
INSERT INTO vid_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","Chima cha kudilo cha igongolo lya nhambiko za hemwe za kikala goya momha mtambika. ");
INSERT INTO vid_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","Chima acho chowa ndo cha walelwa wa mtambika Aluni yalingulavya danda na mafuta ga nhambiko ya kikala goya. ");
INSERT INTO vid_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","Heni, Mkulu Nguluwi, ndiwalajiza wanhu wa Isilaeli wawiche goya iwunde alyo lya mmhambaga liwele ndo lya nhambiko ya kwinula kuchanya na chima acho cha igongolo lya nhambiko za hewo za kikala goya, yapegwe mtambika Aluni na wanage, mina honhu aho wawichilwa awo watambika mazuwa gose. ");
INSERT INTO vid_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","Aho ndo honhu habaguligwe kwa chiwalo cha Aluni na wanage kulawa kuli nhambiko yalingulavilwa Mkulu Nguluwi kwa chiluli, kwaluchila zuwa lowahaguligwe wawe watambika wa Mkulu Nguluwi. ");
INSERT INTO vid_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","Vyowahaguligwe kwa kubakalizwa mafuta, Mkulu Nguluwi nakawalajiza Waisilaeli wawape honhu aho ha nhambiko, ayo yowa ya hewo mazuwa gose.” ");
INSERT INTO vid_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","Lelo ago ndo malajizo galinguwala nhambiko ya kulakazwa na nhambiko ya nyhule na nhambiko ya gehile na nhambiko ya nongwa na nhambiko ya kuwichigwa kwa mijito yelile na nhambiko ya kikala goya. ");
INSERT INTO vid_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","Mkulu Nguluwi nakamha Musa malajizo ago mchidunda cha Sinai zuwa lila navyoyawalonjele Waisilaeli wamigalile nhambiko za hewo, kuchiwala ako Sinai. ");
INSERT INTO vid_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","Mkulu Nguluwi nakamlonjela Musa, ");
INSERT INTO vid_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","“Umcheme Aluni na wanage na uhole ivalo linojile na mafuta ga kubakala na ibuguma lya nhambiko ya gehile na ming'holo milume mili na chidoto cha mibumunda johajiwichigwe usaso. ");
INSERT INTO vid_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","Hamba uwakungajize Waisilaeli weng'ha hali lwizi lwa ihema lya Nguluwi.” ");
INSERT INTO vid_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","Musa nakadita kota vyoyalajizwe na Mkulu Nguluwi. Nakawakungajiza Waisilaeli weng'ha hali lwizi lwa ihema lya Nguluwi. ");
INSERT INTO vid_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","Musa nakawalonjela ahi Waisilaeli weng'ha, “Ayi ndo mbuli iwele Mkulu Nguluwi yoyalajize iditigwe.” ");
INSERT INTO vid_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","Aho Musa nakewegala Aluni na wanage na kuwahovuga kwa mazi. ");
INSERT INTO vid_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","Hamba nakamvaliza Aluni ikanzu na kuliwoha kwa isali, nakamvaliza ijoho, nakamvaliza chizibao na kuchiwoha mchuno mwa heye kwa isali litawigwe goya. ");
INSERT INTO vid_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","Hamba nakamuwika chila chihako cha mmhambaga na kujela azo Ulimu na Sumimu mgati mwa acho chihako cha mmhambaga. ");
INSERT INTO vid_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","Hamba nakamvaliza Aluni chipembelo kumutwi na mchanya mwa chipembelo acho mchihanga nakawika vinoligo vya zahabu, acho ndo chibati chelile, kota Mkulu Nguluwi vyoyamlajize Musa. ");
INSERT INTO vid_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","Hamba Musa nakahola mafuta ga kubakala, nakabakaliza hali ihema lya Nguluwi na vinhu vyeng'ha viwele mgati mwake leka kuvidita viwe vya chiuyeng'ha. ");
INSERT INTO vid_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","Nakamizila honhu ha mafuta aho hali honhu ha kulavila nhambiko mala saba, nakabakaliza mafuta honhu ha kulavila nhambiko na vinhu vyeng'ha na likuwe na chikalilo chake, na kuviwika viwe vya chiuyeng'ha. ");
INSERT INTO vid_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","Ahyo Musa nakamjidila Aluni mafuta kumutwi kwa kumdita yawe wa chiuyeng'ha. ");
INSERT INTO vid_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","Hamba Musa nakawegala wana wa Aluni na kuwavaliza mijoho na kuwawoha misali mchuno, na kuwavaliza kofia kota navyoyalajizwe na Mkulu Nguluwi. ");
INSERT INTO vid_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","Baho du Musa nakaligala ibuguma lya nhambiko ya gehile, na heye Aluni na wanage nawawika moko ga hewo mchanya mwa ibuguma alyo. ");
INSERT INTO vid_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","Musa nakalidumula singo alyo isenga ibuguma, nakahola danda na kubakaliza mbalati zeng'ha za honhu ha kulavila nhambiko kwa chidole cha heye leka kuhadita hawe helile. Hamba nakahola danda isigale kaijida hanyi hali chikalilo cha honhu ha kulavila nhambiko. Ahyo nakaviwika viwe vya chiuyeng'ha kwa kuhaditila uhanyisi. ");
INSERT INTO vid_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","Hamba, Musa nakahola mafuta geng'ha gawele mmitumbu na honhu hanojile ng'hatu ha chini hamwe na figo zeng'ha mbili na mafuta na kuvilakaza hali honhu ha kulavila nhambiko. ");
INSERT INTO vid_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","Ila iwunde lya ibuguma alyo na igozi na midohe jake, nakavilakaza kwa chiluli kunze mwa kambi kota Musa vyoyalajizwe na Mkulu Nguluwi. ");
INSERT INTO vid_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","Hamba Musa nakaligala ing'holo ilume lya nhambiko ya kulakazwa. Aluni na wanage nawawika moko ga hewo mchanya mmutwi mwa ing'holo alyo. ");
INSERT INTO vid_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","Musa kalidumula singo na danda ya ing'holo alyo nakabohola hali honhu ha kulavila nhambiko banzi zeng'ha. ");
INSERT INTO vid_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","Nakalidumula alyo ing'holo ilume kuli vipuli, Musa nakavilakaza hamwe na mutwi wa ing'holo na mafuta gake. ");
INSERT INTO vid_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","Vyonayahovuje mitumbu na magulu kwa mazi na kahi Musa nakalilakaza ing'holo ilume lyeng'ha hali honhu ha kulavila nhambiko kota nhambiko ya kulakazwa. Ayo ndo nhambiko ilingulavigwa kwa Mkulu Nguluwi kwa chiluli, iwele na unhunyhililo unojile wa kumnojeza Mkulu Nguluwi. Musa nakadita kota vyoyalajizwe na Mkulu Nguluwi. ");
INSERT INTO vid_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","Hamba nakaligala ing'holo ilume liyage, kwa chiwalo cha kuwawika kwa mijito yelile. Aluni na wanage nawawika moko ga hewo mchanya mwa mutwi wa ing'holo alyo. ");
INSERT INTO vid_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","Musa nakalidumula singo. Nakahola danda ya ing'holo alyo na kumbakaliza Aluni kuli ikutu lyake lya kudilo na chidole chikuluwawo moko wa kudilo na chidole chikuluwawo cha mgulu wa heye wa kudilo. ");
INSERT INTO vid_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","Wana wa Aluni nawo nawoya, Musa nakawabakaliza chasi cha danda kuli makutu ga hewo ga kudilo na kuli vidole vikuluwawo vya kuli moko ga hewo ga kudilo na kuli vidole vikuluwawo vya magulu ga hewo ga kudilo. Danda yinji nakaibohola hali honhu ha kulavila nhambiko banzi zeng'ha. ");
INSERT INTO vid_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","Hamba nakosa mafuta gake na mchila uwele na mafuta na mafuta geng'ha gawele kuli mitumbu na honhu hanojile ng'hatu ha chini na figo mbili na mafuta gake na chima cha kudilo cha ing'holo alyo ilume. ");
INSERT INTO vid_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","Hamba kuli lila likowe lya mibumunda liwichigwe hali Mkulu Nguluwi nakalavya ibumunda limwe lyohaliwichigwe usaso, ibumunda limwe liwele na mafuta na ibumunda limwe lizisili, vyeng'ha nakaviwika mchanya mwa vihande vya mafuta na chila chima cha kudilo. ");
INSERT INTO vid_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","Musa nakaviwika kuli moko ga Aluni na wana wa heye, na hewo nawenula kuchanya kwa ulajilo wa kumlavila nhambiko Mkulu Nguluwi. ");
INSERT INTO vid_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","Hamba Musa nakavihola vinhu avyo kulawa kuli moko ga hewo na kuvilakaza mchanya mwa honhu ha kulavila nhambiko hamwe na nhambiko ya kulakazwa. Ayi ndo nhambiko ya kuwichigwa kwa mijito yelile, iwele na unhunyhililo unojile ulingumnojeza Mkulu Nguluwi, ndo nhambiko ilingulavigwa kwa chiluli. ");
INSERT INTO vid_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","Hamba Musa nakahola ila mhambaga na kwinula kuchanya kwa ulajilo kwa kumlavila nhambiko Mkulu Nguluwi. Honhu aho ha lila ing'holo ilume lya kuwichigwa kwa mijito yelile ndo lya Musa, kota vyoyalajizwe na Mkulu Nguluwi. ");
INSERT INTO vid_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","Hamba Musa nakahola mafuta ga kubakaliza na danda kulawa kuli honhu ha kulavila nhambiko nakawamizila Aluni na wana wa heye na mivalo ja hewo kahi. Ahyo Musa nakamdita Aluni yawe wa chiuyeng'ha, heye hamwe na wanage kahi na mivalo ja hewo. ");
INSERT INTO vid_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","Musa nakawalonjela Aluni na wana wa heye, “Mtogose lila iwunde hali lwizi lwa ihema lya Nguluwi, mulye baho hamwe na ibumunda kulawa kuli likowe liwele na nhambiko ya kuwichigwa kwa mijito yelile. Mdite kota vyondajizwe na Mkulu Nguluwi, nakalonga, ‘Honhu aho holika na Aluni na wana wa heye.’ ");
INSERT INTO vid_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","Iwunde lyoneche ama ibumunda lyoneche lisigale lyoganigwa kulakazwa kwa chiluli. ");
INSERT INTO vid_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","Hamlawa kunze mwa lwizi lwa ihema lya Nguluwi kwa mhela weng'ha wa mazuwa saba, mina mbaka mhela wa hemwe wa kuwichigwa kwa mijito yelile houmala, mhela wa kuwichigwa kuli mijito yelile wohola mazuwa saba. ");
INSERT INTO vid_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","Mkulu Nguluwi nakalajiza tudite kota navyotuditile lehano leka tuwaditile hemwe uhanyisi. ");
INSERT INTO vid_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","Mowa baho kuli lwizi lwa ihema lya Nguluwi nemisi na nechilo kwa mhela wa mazuwa saba, kuno mdita mbuli zoyalajize Mkulu Nguluwi. Lomdita vinji mobagama. Ahyo ndo vyondajizwe na Mkulu Nguluwi.” ");
INSERT INTO vid_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","Lelo Aluni na wana wa heye nawadita mbuli zeng'ha zoyalajize Mkulu Nguluwi kwa kukolela Musa. ");
INSERT INTO vid_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","Zuwa lya nane, Musa nakamchema Aluni na wanage hamwe na wasekulu wa Isilaeli. ");
INSERT INTO vid_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","Musa nakamlonjela Aluni, “Uhole isenga ibuguma kwa chiwalo cha nhambiko ya gehile na ing'holo ilume kwa chiwalo cha nhambiko ya kulakazwa, migongolo jeng'ha jiwe jilihela nongwa. Hamba walavye nhambiko hali Mkulu Nguluwi. ");
INSERT INTO vid_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","Walonjele Waisilaeli kota wahole ipongo limwe kwa chiwalo cha nhambiko ya gehile, na isenga ilogota limwe na ing'holo lyana limwe jeng'ha jiwe ja mwaka umwe na jilihela nongwa kwa chiwalo cha nhambiko ya kulakazwa, ");
INSERT INTO vid_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","isenga ibuguma limwe na ing'holo ilume limwe kwa chiwalo cha nhambiko ya kikala goya, womlavila Mkulu Nguluwi nhambiko ya nyhule ihanzigwe na mafuta, ndo mina lehano Mkulu Nguluwi kokulawilani.” ");
INSERT INTO vid_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","Waisilaeli nawegala vyeng'ha avyo hali ihema lya Nguluwi kota Musa vyoyawalonjele Waisilaeli weng'ha nawaluta kwima hali Mkulu Nguluwi. ");
INSERT INTO vid_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","Musa nakawalonjela, “Awo ndo ulonzi uwele Mkulu Nguluwi nakawalonjela waligongomanye leka ukulu wa heye woneche kwa hemwe.” ");
INSERT INTO vid_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","Aho Musa nakamlonjela Aluni, “Ulute hali honhu ha kulavila nhambiko, ulavile aho nhambiko ya gehile na nhambiko ya kulakazwa na kudita uhanyisi kwa chiwalo cha hegwe na kwa chiwalo cha wanhu. Ulavye nhambiko ya wanhu na kudita uhanyisi kwa chiwalo cha hewo kota Mkulu Nguluwi vyoyalajize.” ");
INSERT INTO vid_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","Lelo Aluni nakaluta habehi na honhu ha kulavila nhambiko, nakalidumula singo alila isenga ibuguma ilogota yalilavile liwe nhambiko ya gehile ga heye yuye. ");
INSERT INTO vid_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","Wana wa Aluni nawamigalila danda, na heye nakadoliza na chidole cha heye mli danda ayo na nakabakaliza mbalati za honhu ha kulavila nhambiko. Danda isigale nakajida hanyi hali chikalilo cha honhu ha kulavila nhambiko. ");
INSERT INTO vid_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","Ila mafuta na figo na honhu hanojile ng'hatu ha chini kulawa kuli nhambiko ya gehile, nakavilakaza vyeng'ha hali honhu ha kulavila nhambiko kota Mkulu Nguluwi vyoyamlajize Musa. ");
INSERT INTO vid_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","Ila lila iwunde na igozi nakalilakaza kwa chiluli kunze mwa kambi. ");
INSERT INTO vid_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","Hamba Aluni nakalidumula singo igongolo lya nhambiko ya kulakazwa. Wanage nawamgalila danda, na heye nakabohola hali honhu ha kulavila nhambiko banzi zeng'ha. ");
INSERT INTO vid_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","Hamba nawamigalila nhambiko ya kulakazwa, vipuli hamwe na mutwi, na heye nakavilakaza hali honhu ha kulavila nhambiko. ");
INSERT INTO vid_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","Nakahovuga mitumbu na magulu na kujilakaza hamwe na yila nhambiko ya kulakazwa hali honhu ha kulavila nhambiko. ");
INSERT INTO vid_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","Hamba Aluni nakaigala nhambiko kumwando kwa wanhu. Nakaihola mhene ya nhambiko ya gehile, nakaidumula singo na kulavya nhambiko ya gehile, kota vyoyaditile kwa lila igongolo lilongole. ");
INSERT INTO vid_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","Hamba nakaihejeza kumwando yila nhambiko ya kulakazwa nakalavya nhambiko ayo kota vyoitagusigwe. ");
INSERT INTO vid_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","Hamba nakaihejeza kumwando nhambiko ya nyhule na kujela chiganza chimwe na kulakaza hali honhu ha kulavila nhambiko hamwe na nhambiko ya kulakazwa kwa chila mitondo. ");
INSERT INTO vid_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","Hamba Aluni nakalidumula singo kahi isenga ibuguma na lila ing'holo ilume lya nhambiko ya kikala goya kwa chiwalo cha wanhu. Wanage nawamigalila danda na kubohola honhu ha kulavila nhambiko banzi zeng'ha. ");
INSERT INTO vid_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","Mafuta ga isenga ibuguma alyo na ing'holo ilume na mchila wa ing'holo na mafuta gagubiche mitumbu na figo na honhu hanojile ng'hatu ha chini, ");
INSERT INTO vid_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","ahyo nawawika avyo mchanya mwa mhambaga, na heye nakavilakaza hali honhu ha kulavila nhambiko. ");
INSERT INTO vid_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","Ila zila mbavu na chila chima cha kudilo, Aluni nakavinula mchanya navyo viwe ulajilo wa kumlavila Mkulu Nguluwi, kota Musa vyoyalajize. ");
INSERT INTO vid_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","Aluni vyoyasindile kulavya nhambiko zeng'ha, nhambiko ya gehile na nhambiko ya kulakazwa na nhambiko za kikala goya, nakawenulila wanhu moko na kawatambichiza, hamba nakedulika hanyi. ");
INSERT INTO vid_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","Hamba Musa na Aluni nawenjila mli ihema lya Nguluwi. Navyowalawile kunze, nawawatambichiza wanhu na ukulu kwa Mkulu Nguluwi nawoneka kwa wanhu weng'ha. ");
INSERT INTO vid_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","Mkulu Nguluwi nakadulisa chiluli, nachilakaza nimwa nhambiko ya kulakazwa na vihande vya mafuta gawele hali honhu ha kulavila nhambiko. Wanhu weng'ha vyowawene chila chiluli nawatowa iyowe na kufugama. ");
INSERT INTO vid_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","Nawo Nadabu na Abihu wawele ndo wana wa Aluni, nawahola chila yumwe chifunyizi, nawawika chiluli na ubani, nawamlavila Mkulu Nguluwi chiluli chiwele hachikundigwe na hambe yawalajize hewo. ");
INSERT INTO vid_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","Lelo chiluli chilawila hali Mkulu Nguluwi, nachiwalakaza awo wasongolo, na wabagama hali heye. ");
INSERT INTO vid_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","Aho, Musa nakamlonjela Aluni, “Kwa mbuli alyo Mkulu Nguluwi nakakulajila chilingulapa chila choyalonjile, ‘Ndochilajila kota nda yelile hali wala wawele habehi na heni, ndotogoligwa hali wanhu weng'ha!’ ” Aluni nakanyamalila tulu. ");
INSERT INTO vid_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","Lelo Musa nakawachema Mishaeli na Elisafani, wanage Usieli, mhaza mdodo wa Aluni, nakawalonjela woye kusa mitufi ja wang'holozawo kuli ihema lya Nguluwi na kujihilika kunze mwa kambi. ");
INSERT INTO vid_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","Nawahola mitufi ja wang'holozawo na kujihilika kunze mwa kambi kuno wawele wavalile mikanzu ja hewo, kota Musa vyoyawalonjele. ");
INSERT INTO vid_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","Hamba Musa nakamlonjela Aluni na wanage, Eleasali na Itamali, “Mleche kuleka mnvili za hemwe zizuzumuche na mleche kudega mivalo ja hemwe kwa kulombocheza, wone hamditile ahyo, mobagama na kuwagalila wanhu weng'ha kuzudila kwa Mkulu Nguluwi. Ila wang'holozenu wawele ndo Waisilaeli weng'ha, wanguweza kulombocheza kwa chiwalo cha chiluli acho choyegale Mkulu Nguluwi. ");
INSERT INTO vid_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","Mleche kulawa kunze kwa lwizi lwa ihema lya Nguluwi, wone mdite ahyo mobagama kwa vila mafuta ga kubakala ga Mkulu Nguluwi ga mchanya mwa hemwe.” Aluni na wanage nawadita kota Musa vyoyalonjile. ");
INSERT INTO vid_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","Mkulu Nguluwi nakalongasa na Aluni, nakamlonjela, ");
INSERT INTO vid_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","“Vyomkwinjila mgati mwa ihema lya Nguluwi, hegwe hamwe na wanago mleche kunwa divai ne ujimbi woneche. Wone munwe mobagama. Ilajizo ali lyowa lya mazuwa gose kuli lulelo lwa hemwe. ");
INSERT INTO vid_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","Hamba mwanguganigwa mbagule kuli mbuli za chiuyeng'ha na zila mbuli za hihi hela na kuli zila mbuli zikokomoche na zelile. ");
INSERT INTO vid_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","Hegwe kowalangusa Waisilaeli gala malajizo yalonjile Mkulu Nguluwi kwa kukolela Musa.” ");
INSERT INTO vid_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","Musa nakamlonjela Aluni na wanage waponile, Eleasali na Itamali, “Mhole hala honhu ha nhambiko ya nyhule hasigale kulawa kuli nhambiko yalingulavilwa Mkulu Nguluwi kwa chiluli, mgongomanye ibumunda lilihela usaso na mulye habehi na honhu ha kulavila nhambiko, kwa vila ndo helile ng'hatu. ");
INSERT INTO vid_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","Kolya hali honhu helile kwa vila ayo ndo hachi ya hegwe hamwe na wanago kulawa kuli nhambiko yalingulavilwa Mkulu Nguluwi kwa chiluli. Alyo ndo ilajizo. ");
INSERT INTO vid_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","Ila mhambaga yinuligwe kuchanya kota ulajilo wa kumlavila Mkulu Nguluwi na chima chilingulavigwa nhambiko, mwanguweza kulya honhu honeche helile. Kolya hegwe na wana wa hegwe walume na wadala. Vinhu avyo kupegwa kota hachi ya hegwe na wapondigwe na hegwe kulawa nhambiko ya kikala goya ya wanhu wa Isilaeli. ");
INSERT INTO vid_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","Chila chima chilavigwe na mhambaga ya nhambiko ya kwinula kuchanya, wovigala hamwe na vihande vya mafuta na nhambiko ilavigwe kwa Mkulu Nguluwi kwa chiluli. Ahyo vyowa vya hegwe hamwe na wanago, ndo hachi ya hemwe mazuwa gose kota Mkulu Nguluwi vyoyalajize.” ");
INSERT INTO vid_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","Lelo Musa nakauza chiwalo cha mhene ilavigwe nhambiko ya gehile, hamba nakavizela kota nailakazwa. Ahyo kawakalalila ng'hatu Eleasali na Itamali wawele ndo wana wa Aluni waponile, nakawauza, ");
INSERT INTO vid_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","“Lekachoni hamdile nhambiko ya gehile hali honhu helile? Kwa vila ayo ndo chinhu chelile, na mwali mpegwe ayo leka kusa nongwa ya Waisilaeli weng'ha na kuwaditila uhanyisi hali Mkulu Nguluwi. ");
INSERT INTO vid_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","Kahi, kwa vila danda ya nhambiko haigaligwe mgati mwa honhu helile, ndangukomya yangoneka namganigwa kulya mgati mwa honhu helile kota vyondajize.” ");
INSERT INTO vid_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","Aluni nakamlonjela Musa, “Ulole, lehano walavya nhambiko ya hewo ya gehile na nhambiko ya kulakazwa hali Mkulu Nguluwi, hamba ahyo mbuli ayi ifika heni! Ahyo nandiwe ndile yila nhambiko ya gehile aga lehano, ndaze, naikundigwe hali Mkulu Nguluwi?” ");
INSERT INTO vid_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","Musa vyoyahuliche ago, nakakunda. ");
INSERT INTO vid_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","Mkulu Nguluwi nakawalonjela Musa na Aluni, ");
INSERT INTO vid_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","“Muwalonjele Waisilaeli ahi, ");
INSERT INTO vid_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","‘Hali migongolo jeng'ha hano muisi, mkundizwa kulya igongolo lyoneche liwele na kwato zigawanuche honhu heli na lilinguhelula. ");
INSERT INTO vid_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","Ila mleche kulya igongolo lyoneche liwelenguhelula ila kwato zake hazigawanuche honhu heli, ama liwele kwato zake zigawanuka ila hambe lihelule. Mleche kulya ngamiya, alyo lyanguhelula ila kwato zake hazigawanuche honhu heli. Kwa hemwe alyo ndo likokomoka. ");
INSERT INTO vid_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","Mleche kulya pelele, alyo lyanguhelula ila kwato za alyo hazigawanuche, kwa hemwe alyo ndo likokomoka. ");
INSERT INTO vid_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","Sungula mleche kulya, alyo lyanguhelula ila kwato za alyo hazigawanuche, kwa hemwe alyo ndo likokomoka. ");
INSERT INTO vid_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","Igubi mleche kulya, lina kwato zigawanuka ila hambe lihelule, kwa hemwe alyo ndo likokomoka. ");
INSERT INTO vid_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","Ila migongolo ajo ndo jikokomoka mleche kulya miwunde ja ajo migongolo na mleche kudoliza mitufi jawo. ");
INSERT INTO vid_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","“ ‘Somba yoneche ya mbahali ama kulwanda iwele na msepe na ukalagatu, mwanguweza kulya. ");
INSERT INTO vid_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","Ila choneche chilingikala mbahali ama kulwanda, chilihela msepe ne ukalagatu, ndo vilumbigwe vyeng'ha vilingutambala mmazi na vilumbigwe viyage vyeng'ha vilingikala mmazi ndo vizudizo kwa hemwe. ");
INSERT INTO vid_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","Vilumbigwe avyo vyowa vizudizo kwa hemwe. Mleche kulya migongolo ajo ne kudoliza mitufi jawo kwa vila ndo vizudizo. ");
INSERT INTO vid_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","Choneche chilingikala mmazi chilihela msepe ne ukalagatu ndo vizudizo kwa hemwe. ");
INSERT INTO vid_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","“ ‘Videje vyeng'ha ndo vizudizo kwa hemwe. Mleche kulya ikungule na ndapo na ng'hwazi ");
INSERT INTO vid_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","na chilutema na chila nhanzi ya kozi ");
INSERT INTO vid_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","na chila nhanzi ya ibondwa ");
INSERT INTO vid_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","na mbuni na chimtolo na idudumizi na chila nhanzi ya chilutema ");
INSERT INTO vid_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","na ituwe na mnandi na ituwe ikulu ");
INSERT INTO vid_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","na mumbi na chingowe na mdeli ");
INSERT INTO vid_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","na isakulang'hola na jila jeng'ha jiwhanile na ikoyogo na chigong'honda na ipalabutwa. ");
INSERT INTO vid_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","“ ‘Minhu jeng'ha jiwele na mabawa na jiwelengujenda kwa magulu gane, ajo ndo uzudizo kwa hemwe. ");
INSERT INTO vid_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","Ila jinji jiwele na mabawa na jangujenda kwa magulu gane ga kunyonzochela misanga moweza kulya. ");
INSERT INTO vid_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","Ajo ndo jila jiwhanile na nzije na jila jiwhanile na misenene na jila jiwhanile na ndede na jila jiwhanile na inwanwachi. ");
INSERT INTO vid_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","Ila minhu jiyage jeng'ha jiwele na mabawa na magulu gane ndo uzudizo kwa hemwe. ");
INSERT INTO vid_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","“ ‘Kudoliza migongolo jinji jangumdita munhu yawe yakokomoche, yoneche yodoliza mitufi jawo kowa yakokomoche mbaka matinazo. ");
INSERT INTO vid_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","Wone munhu yapiche honhu ha mitufi ja heye kowa yakokomoche mbaka matinazo, na mivalo ja heye yanguganigwa jihovujigwe. ");
INSERT INTO vid_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","Munhu yoneche yodoliza igongolo liwele na kwato zigawanuche ila hambe lihelule, munhu ayo kowa yakokomoche. ");
INSERT INTO vid_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","Migongolo jeng'ha jilingujenda kwa viganza vya hewo jiwele na magulu gane, ndo jikokomoka kwa hemwe, na yoneche yodoliza itufi lya igongolo kota alyo kowa yakokomoche mbaka matinazo. ");
INSERT INTO vid_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","Munhu yoneche yopika itufi, kowa yakokomoche mbaka matinazo, na heye kohovuga ivalo lya heye. Ajo ndo jikokomoka kwa hemwe. ");
INSERT INTO vid_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","“ ‘Vilumbigwe vilingutambala viyage ndo vikokomoka kwa hemwe, chilukwili na igule, jila jiwhanile na limdunhu, ");
INSERT INTO vid_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","igugulu lidodo na ichenje na jimdusu na igologonzi na liluwivu. ");
INSERT INTO vid_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","Ajo jeng'ha jilingutambala ndo jikokomoka kwa hemwe na yoneche yodoliza mitufi ajo, kowa yakokomoche mbaka matinazo. ");
INSERT INTO vid_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","Wone mitufi ja vilumbigwe avyo jogwila chinhu choneche, chiwe chinhu cha mbao ama ivalo ama igozi ama igunila ama chinhu chinji chilingutumika kwa choneche chila, chinhu acho chowa chikokomoche mbaka matinazo. Lelo kuchidita chiwe hachikokomoche, yanguganigwa kuchihovuga kwa mazi, hamba chowa chelile. ");
INSERT INTO vid_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","Wone itufi lya heye ligwile chinhu cha ilongo, lelo chinji chiwele mgati mwa chinhu acho ndo chikokomoka na changuganigwa chituligwe. ");
INSERT INTO vid_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","Chilyo ama chakunwa chinji chiwele mgati mwa chinhu acho chowa chikokomoka. ");
INSERT INTO vid_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","Chila chinhu chochigwililwa na chipuli choneche cha mitufi ajo chowa chikokomoka. Wone ndo itanuli ama chiko changuganigwa chibenigwe. Vyowa vikokomoka na vyolutilila kuwa vikokomoka kwa hemwe. ");
INSERT INTO vid_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","Ahyo, ideho ama nzasa ya mazi vyowa havikokomoche. Ila wone munhu yenjile na kudoliza itufi, kowa yakokomoche. ");
INSERT INTO vid_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","Na chipuli choneche cha itufi hochigwila nyhadikwa za kunyala, nyhadikwa azo zowa hazikokomoche. ");
INSERT INTO vid_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","Ila wone nyhadikwa azo naziwichigwa mli mazi na choneche cha mitufi kuzigwila, lelo nyhadikwa azo ndo zikokomoka kwa hemwe. ");
INSERT INTO vid_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","“ ‘Hanga igongolo lyoneche likundigwe kulya libagame lilyo, munhu yoneche yodoliza itufi alyo, kowa yakokomoche mbaka matinazo. ");
INSERT INTO vid_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","Munhu yoneche yolya vipuli vya itufi alyo kohovuga mivalo ja heye na kowa yakokomoche mbaka matinazo. Na yoneche yopika itufi alyo, kohovuga ivalo lya heye, na heye kowa yakokomoche mbaka matinazo. ");
INSERT INTO vid_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","“ ‘Chilumbigwe chinji chilingutambala muisi ndo uzudizo kwa hemwe, ndangukomya mleche kulya. ");
INSERT INTO vid_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","Chila chilingutambala kwa munda na chila chilingujenda kwa magulu gane ama chilingujenda kwa magulu menji, mina ndo vyeng'ha vilingutambala mmisanga, ndangukomya mleche kulya kwa mina ndo uzudizo kwa hemwe. ");
INSERT INTO vid_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","Ahyo mleche kiditila uzudizo kwa kulya vilumbigwe vilingutambala leka mleche kuwa mkokomoche kwa kukolela avyo. ");
INSERT INTO vid_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","Kwa vila heni Mkulu Nguluwi, mbele Nguluwi wa hemwe, miwiche chiuyeng'ha na muwe mwelile kwa vila heni nda yelile. Mleche kiwika muwe mkokomoche kwa chinhu choneche chilingitambala mchanya mwa isi. ");
INSERT INTO vid_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","Kwa vila heni nda Mkulu Nguluwi ndiwalavile kuli isi ya Misili leka ndiwe Nguluwi wa hemwe, ahyo muwe mwelile kwa vila heni nda yelile. ");
INSERT INTO vid_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","“ ‘Ahyo lelo, aga ndo malajizo galingulapa migongolo na videje na chila chilumbigwe chiwele mmazi na chila chilingutambala muisi, ");
INSERT INTO vid_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","leka kubagula chinhu chikokomoche na hachiwele chikokomoche, chilinguligwa na hambe chiligwe.’ ” ");
INSERT INTO vid_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","Mkulu Nguluwi nakamlonjela Musa, ");
INSERT INTO vid_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","“Walonjele wanhu wa Isilaeli ahi, ‘Mdala wone yawe na himila, na wone nakaponda mwana mlume, kowa yakokomoche kwa mhela wa mazuwa saba kota mazuwa ga heye galinguwala mbuli za chidala kota vyoziwele. ");
INSERT INTO vid_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","Mwana ayo kokwinjila ikumbi kuli zuwa lya heye lya nane. ");
INSERT INTO vid_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","Hamba mamo wa mwana ayo kolutilila kuwa yakokomoche kwa chiwalo cha mbuli za chidala kwa mhela wa mazuwa makumi gadatu na zidatu. Mhela awo yaleche kudoliza choneche chiwichigwe chelile ne kwinjila kuli ihema lya Nguluwi mbaka zuwa lya kwelizwa kwa heye vyoyikwenela. ");
INSERT INTO vid_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","Ila wone yaponde mwana mdala, lelo kowa yakokomoche kwa mhela wa juma mbili kota vyoili vyoyowa kuli zuwa za mbuli za chidala vyozili. Kolutilila kwelizwa kwa mhela wa mazuwa makumi sita na sita. ");
INSERT INTO vid_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","“ ‘Mazuwa ga kwelizwa kwa heye hogokwenela, yawe yapondile mwana mlume ama mdala, komigalila mtambika hali lwizi lwa ihema lya Nguluwi ing'holo lyana lya mwaka umwe kwa chiwalo cha nhambiko ya kulakazwa na ng'hunda ya kisolo ama ng'hunda ya kufujigwa, kwa chiwalo cha nhambiko ya gehile. ");
INSERT INTO vid_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","Mtambika komlavila Mkulu Nguluwi na kumditila uhanyisi. Hamba mdala ayo kowa yelizwe kuli mbuli za chidala. Ago ndo malajizo galingulapa mdala yunji yawele nguponda mwana mlume ama mdala. ");
INSERT INTO vid_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","“ ‘Wone hambe yaweze kulavya ing'holo lyana, lelo kochigala ng'hunda mbili za kufujigwa ama ng'hunda mbili za kisolo, kwa chiwalo cha nhambiko ya kulakazwa na iyage kwa chiwalo cha nhambiko ya gehile. Mtambika komditila mamo ayo uhanyisi, na heye kowa yelile.’ ” ");
INSERT INTO vid_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","Mkulu Nguluwi nakawalonjela Musa na Aluni, ");
INSERT INTO vid_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","“Wone munhu yoneche kowa na kutuna ama chilonda ama baka ama utamwa wa ngozi mlukuli lwa heye, nayoneka kota ndo utamwa wa ngozi ya lukuli, lelo ayo kogaligwa kwa mtambika Aluni ama yumwe wa walelwa wa Aluni, yawele mtambika. ");
INSERT INTO vid_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","Mtambika kohakagula honhu hawele na utamwa, na wone mnvili za honhu aho zigaluka ziwa nzelu, na wone utamwa awo woneche wa mgati mwa ngozi ya lukuli lwa heye, lelo awo ndo utamwa wa ngozi ya lukuli. Mtambika wone yasinde kumkagula, ahyo kolonga kota munhu ayo kakokomoka. ");
INSERT INTO vid_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","Wone liwe baka hela, hanga liwe lizelu halinjile ng'hatu mgati mwa ngozi na mnvili za honhu aho hazigaluche kuwa nzelu, lelo mtambika komhindila mchihengo munhu ayo kwa mhela wa mazuwa saba. ");
INSERT INTO vid_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","Zuwa lya saba, mtambika komkagula kahi munhu ayo vyonayali, kota mtambika vyoyamkagule na wone utamwa awo hawenele mli ngozi ya heye, lelo mtambika komhindila mchihengo munhu ayo kwa mazuwa gayage saba. ");
INSERT INTO vid_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","Mtambika komkagula kahi munhu ayu zuwa lya saba. Wone honhu ha utamwa habilabila na utamwa hawenele, lelo mtambika komlonjela munhu ayo kota ka yanojile na acho ndo chilonda hela. Munhu ayo kohovuga mivalo ja heye, na heye kowa yelizwe. ");
INSERT INTO vid_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","Ila wone chilonda acho chenele mli ngozi, ila munhu ayo yang'hali kilajila kwa mtambika kwa chiwalo cha kwelizwa kwa heye, lelo kokuya kahi kwa mtambika. ");
INSERT INTO vid_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","Mtambika komkagula kahi, na wone chilonda chila nachenela mli ngozi, lelo mtambika komlonjela munhu ayo ka yakokomoche, na awo ndo utamwa wa ngozi ya lukuli. ");
INSERT INTO vid_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","“Wone munhu yawe na utamwa wa ngozi ya lukuli, kohilikwa kwa mtambika. ");
INSERT INTO vid_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","Mtambika komkagula na wone kokona kutuna kuzelu kulinguzidita mnvili za heye ziwe nzelu na kutuna ako nakugaluka kuwa chilonda chidodi, ");
INSERT INTO vid_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","awo ndo utamwa wa ngozi ya lukuli wa mihela minji. Mtambika kodamla kota munhu ayo kakokomoka. Kuduhu chiwalo cha kumhindila mchihengo munhu kwa kumkagula. Heye ndo kakokomoka. ");
INSERT INTO vid_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","Wone utamwa wa ngozi ya lukuli umibate na kwenela lukuli lweng'ha, kulawa minhosi mbaka mizayo kota vyoyokona mtambika, ");
INSERT INTO vid_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","aho mtambika komkagula. Wone mtambika yone kota utamwa wa ngozi ya lukuli nawenela lukuli lweng'ha, lelo kodamla kota munhu ayo kela kwa vila lukuli lugaluka luwa luzelu. Ahyo munhu ayo kela. ");
INSERT INTO vid_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","Ila wone lukuli lwa munhu ayo naloneka luna chilonda chidodi, lelo munhu ayo kowa yakokomoche. ");
INSERT INTO vid_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","Mtambika kokagula acho chilonda chidodi na kudamla kota kakokomoka, kwa vila awo ndo utamwa wa ngozi ya lukuli. ");
INSERT INTO vid_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","Ila wone acho chilonda chipona na chigaluka kahi chiwa chizelu, munhu ayo kohiluka kwa mtambika. ");
INSERT INTO vid_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","Mtambika komkagula, na wone yone kota chigaluka chiwa chizelu, lelo kodamla kota munhu ayo kela. Ahyo kela. ");
INSERT INTO vid_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","“Wone munhu yawe na lipu, na alyo lipu lipona, ");
INSERT INTO vid_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","ila honhu hala honalyali lipu hagaluka hawa hatunile na hawa hazelu ama hadung'hu ila hazelu hado, yanguganigwa yalajilwe mtambika. ");
INSERT INTO vid_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","Mtambika komkagula ayo munhu. Wone mtambika yone hagaluka na hadidimila na mnvili za honhu aho zigaluka kuwa nzelu, lelo mtambika kodamla kota munhu ayo kakokomoka na awo ndo utamwa wa ngozi ya lukuli, ulawile kuli lipu. ");
INSERT INTO vid_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","Ila wone mtambika yamkagule ayo munhu na kona kota mnvili za honhu aho hawele hazelu na hadidimile hebu, ila habilabila, lelo komhindila mchihengo ayo munhu kwa mhela wa mazuwa saba. ");
INSERT INTO vid_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","Wone utamwa awo wokwenela mli ngozi, lelo mtambika kodamla kota munhu ayo kakokomoka na yula kana utamwa. ");
INSERT INTO vid_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","Ila wone habilebile ha bahala, na henele hebu, lelo ayo ndo ng'hovu ya lipu hela. Mtambika kodamla kota munhu ayo kela. ");
INSERT INTO vid_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","“Ama, kwa vila hana honhu halakale na chila chilonda chidodi chigaluka chiwa chidung'huwale hado ama chizelu, ");
INSERT INTO vid_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","mtambika komkagula. Wone yone kota mnvili zigaluka ziwa nzelu na hadidimila, lelo awo ndo utamwa wa ngozi ya lukuli. Utamwa awo wa ngozi ya lukuli ulawilila hala honhu halakale. Mtambika kodamla kota munhu ayo kakokomoka, kwa vila kanawo utamwa wa ngozi ya lukuli. ");
INSERT INTO vid_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","Ila wone mtambika yone mnvili za honhu aho haziwele nzelu na honhu aho hambe hadidimile ila habilabila, lelo mtambika komhindila mchihengo munhu ayo kwa mhela wa mazuwa saba. ");
INSERT INTO vid_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","Zuwa lya saba mtambika komlola. Wone wenele mli ngozi, lelo mtambika kodamla kota munhu ayo ka yakokomoche, kwa vila kanawo utamwa wa ngozi ya lukuli. ");
INSERT INTO vid_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","Ila wone hala honhu habilebile hapona hihila na henele hebu, ako ndo kutuna kulawile na kulakala. Lelo mtambika kodamla kota munhu ayo kela, kwa vila aho habilabila kwa kulakala. ");
INSERT INTO vid_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","“Wone munhu yoneche mlume ama mdala, kana utamwa wa ngozi kumutwi ama mchilevu, ");
INSERT INTO vid_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","mtambika koukagula utamwa awo. Wone mtambika yokona kota hadidimila na mnvili zina lanji ya manjano na nzisili, lelo kodamla kota munhu ayo ka yakokomoche, kwa vila awo ndo utamwa wa kizada wa ngozi ya lukuli wa mutwi ama wa mchilevu. ");
INSERT INTO vid_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","Wone mtambika yokagula wula utamwa wa kizada na yokona kota haduhu honhu hadidimile na mnvili haziwele nhitu, lelo mtambika komhindila mchihengo munhu ayo kwa mhela wa mazuwa saba. ");
INSERT INTO vid_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","Zuwa lya saba mtambika kokagula wula utamwa wa kizada. Wone utamwa awo wa kizada hawanele na haduhu mnvili ziwele na lanji ya njano ne kudidimila, ");
INSERT INTO vid_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","munhu ayo kobeya mnvili ama lulevu lwa heye. Ila honhu hala hawele na utamwa awo wa kizada hobeya hebu. Hamba mtambika komhindila mchihengo munhu ayo kwa mhela wa mazuwa saba gayage, ");
INSERT INTO vid_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","na kuli zuwa lya saba, mtambika kokagula wula utamwa wa kizada. Wone mtambika yokona utamwa awo hawenele kuli ngozi na hawinjile mgati mwa ngozi, lelo kodamla kota munhu ayo kela. Munhu ayo kohovuga ivalo lya heye, na heye kowa yelizwe. ");
INSERT INTO vid_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","Ila hala du vyonayelizwe, utamwa awo wa kizada nawonjezeka, ");
INSERT INTO vid_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","munhu ayo kokaguligwa na mtambika na vyonawonjezeche mli ngozi, mtambika hopala mnvili ziwele na lanji ya njano, munhu ayo kowa yakokomoche. ");
INSERT INTO vid_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","Ila wone mtambika yawone kota wula utamwa wa kizada na mnvili nhitu zota honhu aho, lelo utamwa awo wa kizada upona, lelo munhu ayo ndo kela. Mtambika kodamla kota munhu ayo kela. ");
INSERT INTO vid_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","“Wone munhu yoneche, yawe mlume ama mdala, kana mabaka mazelu mlukuli lwa heye, ");
INSERT INTO vid_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","mtambika komkagula munhu ayo. Ila wone mtambika yokona mabaka ago ndo mazelu hado hela, awo ndo utamwa wa kizada wa hihi hela, munhu ayo ndo kela. ");
INSERT INTO vid_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","“Wone mlume yawe na chibuje, heye kowa yanojile kwa vila kana chibuje hela. ");
INSERT INTO vid_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","Wone chibuje acho nachilawile kuli chihanga, munhu ayo kana chibuje hela ndo kela. ");
INSERT INTO vid_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","Ila wone kuli mutwi hali chibuje ama hali chihanga hali chibuje hana mabaka gadung'huwale na uzelu, awo ndo utamwa wa ngozi ya lukuli ulingulawila kuli chibuje cha heye kumutwi ama kuli chihanga cha heye. ");
INSERT INTO vid_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","Mtambika komkagula. Wone mtambika yokona kota ako kutuna ndo kudung'huwala na kuzelu kuli chibuje ama kuli chihanga cha heye, na kwangoneka kota utamwa wa ngozi ya lukuli, ");
INSERT INTO vid_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","lelo munhu ayo kana utamwa wa ngozi ya lukuli, heye kakokomoka. Mtambika kodamla kota munhu ayo kakokomoka kwa chiwalo cha utamwa wa heye wa kumutwi kwa heye. ");
INSERT INTO vid_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","“Yoneche yawele na utamwa wa ngozi ya lukuli, kovala mivalo jidejeche na mnvili za heye zowa zizuzumuche, na mlomo wa heye wa kuchanya kougubika na kokwiniza lizi yolonga, ‘Heni ng'hokomoka, heni ng'hokomoka.’ ");
INSERT INTO vid_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","Kolutilila kuwa yakokomoche kwa mhela weng'ha yawele na utamwa awo. Heye kakokomoka na heye kochikala yaliyeng'ha kunze mwa kambi. ");
INSERT INTO vid_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","“Wone kuna mbuli ya lungwi kuli ivalo, liwe lya sufu ama kitani, ");
INSERT INTO vid_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","ivalo alyo liwe libotigwe ama litawigwe kwa kitani ama sufu ama ivalo lya igozi lyoneche lila, ");
INSERT INTO vid_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","ila lungwi alo luna lanji ya udedemu ama udung'huwale kuli ivalo alyo, lelo ivalo alyo lina lungwi. Ahyo yangumlapa kumlajila mtambika. ");
INSERT INTO vid_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","Mtambika kokagula lungwi alo na kuliwika ivalo alyo hafungo kwa mhela wa mazuwa saba. ");
INSERT INTO vid_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","Kuli zuwa lya saba, kokagula lungwi alo. Wone lungwi alo lwenela kuli mivalo ajo, liwe libotigwe ama litawigwe ama lya igozi ama lya igozi lyoneche lya vinji, alyo lina lungwi. Ahyo ivalo alyo ndo likokomoka. ");
INSERT INTO vid_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","Mtambika kolilakaza kwa chiluli ivalo alyo kwa vila lina lungwi. ");
INSERT INTO vid_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","“Wone mtambika yokona kota lungwi halwenele kuli ivalo, ");
INSERT INTO vid_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","lelo kolonga ivalo alyo lihovujigwe na kuwichigwa hafungo kwa mhela uyage wa mazuwa saba. ");
INSERT INTO vid_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","Hamba, mtambika kolikagula ivalo alyo holimalile kuhovujigwa. Wone lungwi alo halugaluche lanji na wone halwenele, lelo ivalo alyo ndo likokomoka. Kolilakaza kwa chiluli ivalo alyo, luwe lungwi lwa kumbele ama kumwando mwa ivalo alyo. ");
INSERT INTO vid_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","“Wone mtambika yokona kota lula lungwi lubilabila holimalile kuhovujigwa, lelo kokusa hala honhu hawele na lungwi. ");
INSERT INTO vid_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","Hamba wone lungwi lwoneche lwa hihila kahi kuli ivalo litawigwe ama libotigwe ama kuli chinhu choneche cha igozi, lelo lungwi lwenela. Ahyo ivalo alyo kolilakaza kwa chiluli. ");
INSERT INTO vid_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","Ila alyo ivalo liwele na lungwi kulawa holihovujigwe, yolapa kuhovujigwa mala ya keli, ahyo lyowa lyelizwe.” ");
INSERT INTO vid_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","Ago ndo malajizo kwa chiwalo cha lungwi lulingulawila kuli ivalo lya sufu ama kitani ama ivalo litawigwe ama libotigwe ama lya igozi linji. Kwa nzila ayo woweza kugawanula ivalo lyelizwe na lila ivalo likokomoche. ");
INSERT INTO vid_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","Mkulu Nguluwi nakamlonjela Musa, ");
INSERT INTO vid_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","“Aga ndo malajizo galingumlapa munhu yawele na utamwa wa ngozi ya lukuli kuli mazuwa ga kwelizwa kwa heye. Houkuka utamwa awo, kochigaligwa kwa mtambika. ");
INSERT INTO vid_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","Mtambika koluta kumkagula ayo munhu kunze mwa kambi. Wone utamwa awo wuka, ");
INSERT INTO vid_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","aho mtambika kolajiza kota wanhu wegale videje vili vikomu vikundigwe, chihande cha igodi lichemigwe mwelezi na sufu ya lanji ndung'hu na nhagala ya isopolo kwa chiwalo cha kwelizwa kwa munhu ayo. ");
INSERT INTO vid_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","Mtambika kolajiza chideje chimwe chipobosoligwe singo mchanya mwa chiya chiwele na mazi ganojile ga nzasa. ");
INSERT INTO vid_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","Mtambika kohola chila chideje chisigale chiwele chikomu na chihande chila cha igodi lya mwelezi na sufu ya lanji ndung'hu na yila nhagala ya isopolo na kuviwika vyeng'ha kuli danda ya chila chideje chipobosoligwe. ");
INSERT INTO vid_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","Hamba, kommizila mala saba yula yawele ngwelizwa utamwa wa ngozi, na heye kodamla kota yula munhu kela. Hamba kahi kochilechele chila chideje chiwele chikomu chiguluche kuza kuli migunda kunze kwa muji. ");
INSERT INTO vid_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","Munhu ayo kohovuga mivalo ja heye na kubeya mnvili za heye zeng'ha na koga na heye kowa kela. Hamba kohiluka kuli kambi, ila kochikala kunze kuli ihema lya heye kwa mhela wa mazuwa saba. ");
INSERT INTO vid_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","Zuwa lya saba kobeya mnvili za heye zeng'ha na lulevu na ngohe za meho ga heye na lukuli lweng'ha. Hamba kohovuga mivalo ja heye, kokoga kwa mazi na heye kowa kela. ");
INSERT INTO vid_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","“Zuwa lya nane kochigala ming'holo myana mili milume jilihela nongwa na ing'holo idala liwele na mwaka umwe lilihela nongwa na kilo zidatu za utimbo unojile uhanzigwe na mafuta ga mzeituni kwa chiwalo cha nhambiko ya nyhule hamwe na mafuta honhu hamwe ha kadatu ha lita. ");
INSERT INTO vid_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","Mtambika yalingumweliza munhu ayo, komwimiza munhu ayo hali Mkulu Nguluwi, habehi na lwizi lwa ihema lya Nguluwi hamwe na vinhu vyoyegale. ");
INSERT INTO vid_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","Mtambika kohola ing'holo lyana ilume limwe na kumlavila nhambiko ya nongwa hamwe na gala mafuta ga mzeituni. Hamba kovinula kuchanya kota ulajilo wa kumlavila nhambiko Mkulu Nguluwi. ");
INSERT INTO vid_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","Hamba kolidumula singo alyo ing'holo lyana hali honhu ha kulavila nhambiko, walingudumulila singo migongolo ja nhambiko ya gehile na nhambiko ya kulakazwa. Nhambiko ayi ya nongwa, kota vyoili nhambiko ya gehile, ndo yowa ya heye mtambika ndo nhambiko yelile ng'hatu. ");
INSERT INTO vid_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","Mtambika kohola danda nyindo ya nhambiko ya nongwa na kumbakaliza munhu yalinguganigwa kwelizwa kuli ikutu lya heye lya kudilo na chidole chikuluwawo cha moko wa heye wa kudilo na chidole chikuluwawo cha mgulu wa heye wa kudilo. ");
INSERT INTO vid_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","Hamba mtambika kohola honhu hado ha gala mafuta ga mzeituni na kugajida mli chiganza cha moko wa heye wa kumoso. ");
INSERT INTO vid_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","Kozabika chidole cha moko wa heye wa kudilo kuli mafuta ago na kumizila mala saba hali Mkulu Nguluwi. ");
INSERT INTO vid_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","Chasi cha mafuta gasigale kuli chiganza cha heye, kombakaliza munhu ayo yalingwelizwa, kuli ikutu lya heye lya kudilo na chidole chikuluwawo cha moko wa heye wa kudilo na chidole chikuluwawo cha mgulu wa heye wa kudilo na honhu hahala hoyambakalize danda ya nhambiko ya nongwa. ");
INSERT INTO vid_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","Gala mafuta gasigale kombakaliza kumutwi mwa munhu ayo yalinguganigwa kwelizwa. Ahyo mtambika komditila uhanyisi hali Mkulu Nguluwi. ");
INSERT INTO vid_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","Mtambika komlavila nhambiko ya gehile na kumditila uhanyisi munhu ayo yalingwelizwa, lelo kumusila kukokomoka kwa heye. Hamba, kolidumula singo ing'holo lyana lya nhambiko ya kulakazwa. ");
INSERT INTO vid_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","Mtambika komlavila ayo nhambiko ya kulakazwa na nhambiko ya nyhule hali honhu ha kulavila nhambiko. Ahyo mtambika komditila uhanyisi munhu ayo, na heye kowa kela. ");
INSERT INTO vid_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","“Ila wone iwe munhu ayo ka mzunwa, kolemwela kulavya vinhu avyo, lelo kochigala ing'holo ilume limwe liwe nhambiko ya nongwa, iwele yoditilwa ulajilo wa kulavya nhambiko ya kwinula kuchanya leka kumditila uhanyisi munhu ayo. Kochigala kilo imwe ya utimbo unojile uhanzanywe hamwe na mafuta ga mzeituni kwa chiwalo cha nhambiko ya nyhule hamwe na mafuta honhu ha kadatu ha lita. ");
INSERT INTO vid_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","Kochigala kahi ng'hunda mbili za kisolo ama ng'hunda mbili za kufujigwa vyoyoweza, imwe yowa kwa chiwalo cha nhambiko ya gehile na iyage kwa chiwalo cha nhambiko ya kulakazwa. ");
INSERT INTO vid_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","Zuwa lya nane komigalila mtambika vinhu avyo hali lwizi lwa ihema lya Nguluwi kwa chiwalo cha kwelizwa kwa heye hali Mkulu Nguluwi. ");
INSERT INTO vid_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","Mtambika kolihola alyo ing'holo lyana ilume lya nhambiko ya nongwa hamwe na gala mafuta ga mzeituni na kwinula kuchanya kota ulajilo wa kumlavila nhambiko Mkulu Nguluwi. ");
INSERT INTO vid_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","Kolidumula singo alyo ing'holo lyana ilume lya nhambiko ya nongwa. Mtambika kohola danda nyindo na kumbakaliza ayo munhu yalingwelizwa kuli ikutu lya heye lya kudilo na kuli chidole chikuluwawo cha moko wa heye wa kudilo na chidole chikuluwawo cha mgulu wa heye wa kudilo. ");
INSERT INTO vid_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","Mtambika kojida mafuta ago mado kuli chiganza cha moko wa heye wa kumoso. ");
INSERT INTO vid_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","Hamba komizila mafuta hali Mkulu Nguluwi kwa chidole cha heye cha kudilo mado gawele amo mli chiganza cha heye cha kumoso mala saba. ");
INSERT INTO vid_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","Mtambika kombakaliza mafuta munhu ayo yalingwelizwa kuli ikutu lya heye lya kudilo na kuli chidole chikuluwawo cha moko wa heye wa kudilo na chidole chikuluwawo cha mgulu wa heye wa kudilo. Kombakaliza honhu hahala honayambakalize yila danda ya nhambiko ya nongwa. ");
INSERT INTO vid_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","Mafuta gasigale mmoko mwa heye kombakaliza kumutwi munhu ayo yalingwelizwa, lelo komditila uhanyisi hali Mkulu Nguluwi. ");
INSERT INTO vid_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","Hamba, mtambika kolavya ng'hunda mbili za kisolo ama ng'hunda mbili za kufujigwa kota munhu ayo vyoyoweza kigala. ");
INSERT INTO vid_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","Ng'hunda zowa baho kwa chiwalo cha nhambiko ya gehile na iyage kwa chiwalo cha nhambiko ya kulakazwa. Hamwe na azo, kolavya nhambiko ya nyhule, na heye mtambika komditila uhanyisi munhu ayo yalingwelizwa, hali Mkulu Nguluwi. ");
INSERT INTO vid_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","Ago ndo malajizo galingumlapa munhu yawele na utamwa wa ngozi, yohambe yaweze kulavya nhambiko zila za kwelizwa.” ");
INSERT INTO vid_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","Mkulu Nguluwi nakawalonjela Musa na Aluni, ");
INSERT INTO vid_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","“Homkwinjila kuli isi ya Kanaani yondilinguwapani iwe ya hemwe, na hewo ndodita lungwi kuli lukanzi lwa ng'handa yoneche kuli isi yomchikala hemwe, ");
INSERT INTO vid_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","Lelo yawele na ng'handa ayo yangumlapa yamlonjele mtambika kota lungwi loneka kuli ng'handa ya heye. ");
INSERT INTO vid_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","Mtambika kolajiza vinhu vyeng'ha viwele mng'handa amo vilavigwe hanze yang'hali heye yuye kwaluka kukagula, leka vyeng'ha vileche kudamligwa kota vikokomoka. Hamba mtambika kokwinjila mgati mwa ng'handa ayo kukagula. ");
INSERT INTO vid_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","Kokagula lungwi alo, holukoneka mlukanzi na lwambuza mabaka ga lanji idedemuche ama ndung'hu na koneka kota lwinjila mbaka mgati mwa lukanzi, ");
INSERT INTO vid_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","lelo mtambika kolawa kunze na kuhinda ng'handa ayo kwa mhela wa mazuwa saba. ");
INSERT INTO vid_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","Zuwa lya saba mtambika kohiluka na kukagula kahi mgati mwa ng'handa ayo. Wone lungwi alo lwenela mlukanzi lwa ng'handa ayo, ");
INSERT INTO vid_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","mtambika kolajiza kota maganga gawele hali honhu hawele na lungwi gosigwe na kutajigwa honhu hakokomoche kunze kwa muji. ");
INSERT INTO vid_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","Lukanzi lweng'ha lwa mgati mwa ng'handa lusilibwe loganduligwa na ibiwi lyake lyotajigwa honhu hakokomoche kunze kwa muji. ");
INSERT INTO vid_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","Hamba wohola maganga manyale na kuzenga honhu howagandule na hewo woisiliba ng'handa ayo kahi. ");
INSERT INTO vid_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","“Wone lungwi alo lolawila kahi lokumalile kulavya maganga ago na kugandula hasilibwe na kusiliba kahi, ");
INSERT INTO vid_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","yangumlapa mtambika yoye kukagula goya. Wone lungwi lwenele kuli ng'handa ayo lelo alo ndo lungwi, ng'handa ayo ikokomoka. ");
INSERT INTO vid_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","Ng'handa ayo yangulapigwa ibomoligwe na maganga gake na migodi jake na kusilibwe kwake, vyohilichigwa honhu hakokomoche kunze kwa muji. ");
INSERT INTO vid_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","Kupuluta kwa ago, yoneche yokwinjila mgati mwa ng'handa ayo mhela vyoiwa ihindigwe, kowa yakokomoche mbaka matinazo. ");
INSERT INTO vid_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","Yoneche yowasa kuli ng'handa ayo ama kulya chilyo mgati mwa ng'handa ayo, yangumlapa yahovuje mivalo ja heye. ");
INSERT INTO vid_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","“Ila wone ufiche mhela wa kukagula ayo ng'handa, wone mtambika yokona kota lungwi halwenele mhela wa kusiliba, lelo mtambika kodamla kota ng'handa ayo ndo yela kwa vila lungwi lumala. ");
INSERT INTO vid_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","Leka kuyeliza ng'handa ayo, mtambika kohola videje vili hamwe na vihande vya igodi lichemigwe mwelezi na sufu ndung'hu na nhagala ya isopolo. ");
INSERT INTO vid_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","Kochipobosola chideje chimwe mchanya mwa chiya chiwele na mazi ganojile ga nzasa. ");
INSERT INTO vid_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","Kohola chihande cha igodi lichemigwe mwelezi na nhagala ya isopolo na sufu ndung'hu hamwe na chila chideje chiyage chiwele chikomu na kuvinjiza vyeng'ha kuli danda ya chila chideje chipobosoligwe singo na kuli mazi ganojile ga nzasa. Hamba komizila ng'handa ayo mala saba. ");
INSERT INTO vid_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","Ahyo ndo vyoyokweliza ng'handa ayo kwa danda ya chideje na mazi ganojile ga nzasa na chideje chikomu na chihande cha igodi lichemigwe mwelezi na nhagala ya isopolo na sufu ndung'hu. ");
INSERT INTO vid_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","Chila chideje chikomu kochilechela chiguluche kumgunda kunze kwa muji. Ahyo ndo vyoyoiditila uhanyisi ng'handa ayo, nayo ndo yowa yela.” ");
INSERT INTO vid_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","Aga ndo malajizo kuli mbuli ya utamwa wa ngozi, kwa utamwa wa ngozi wa kizada, ");
INSERT INTO vid_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","lungwi kuli ivalo ama mgati mwa ng'handa, ");
INSERT INTO vid_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","kutuna ama chilonda ama baka, ");
INSERT INTO vid_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","lelo kolajila ndo chinhu chachi chiwele chikokomoche na chelizwe. Ago ndo malajizo galinguwala mbuli ya utamwa wa ngozi ama lungwi. ");
INSERT INTO vid_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","Mkulu Nguluwi nakawalonjela Musa na Aluni, ");
INSERT INTO vid_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","“Walonjele Waisilaeli ahi, ‘Mlume yoneche jimlawa mifila, ajo jomdita yawe yakokomoche. ");
INSERT INTO vid_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","Aga ndo malajizo galinguwala kukokomoka ako, mhela weng'ha vyojimlawa mifila ama mifila vyojiwa jilemezigwa mgati mwa heye, munhu ayo kakokomoka. ");
INSERT INTO vid_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","Chinhanda choneche choyowasila ama choyokalisila, chowa chikokomoche. ");
INSERT INTO vid_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","Munhu yoneche yodoliza chinhanda cha munhu ayo yangumlapa yahovuje ivalo alyo na koga, na heye kowa yakokomoche mbaka matinazo. ");
INSERT INTO vid_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","Munhu yoneche yochikalisila chinhu choneche choyekalisile ayo munhu yalingulawa mifila, yangumlapa yahovuje ivalo na koga, na kowa yakokomoche mbaka matinazo. ");
INSERT INTO vid_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","Munhu yoneche yomdoliza munhu ayo yalingulawa mifila, yangumlapa yahovuje mivalo ajo na koga, na heye kowa yakokomoche mbaka matinazo. ");
INSERT INTO vid_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","Wone munhu yalingulawa mifila, yomtemela mite munhu, ayo munhu yatemelwe mite yomlapa yahovuje mivalo ja heye na koga, ila heye kowa yakokomoche mbaka matinazo. ");
INSERT INTO vid_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","Lutemvu loneche lwa kikalisila mchanya mwa igongolo, loyekalisile munhu yalingulawa mifila, lyowa likokomoche. ");
INSERT INTO vid_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","Munhu yoneche yodoliza chinhu choneche choyekalisile munhu ayo, kowa yakokomoche mbaka matinazo. Munhu yoneche yopika chinhu chila, yangumlapa yahovuje mivalo ja heye na koga na heye kowa yakokomoche mbaka matinazo. ");
INSERT INTO vid_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","Munhu yoneche yalingulawa mifila, wone yamdolize munhu ne kuhovuga moko wa heye tandi, munhu yadolizwe kohovuga ivalo na koga, na kowa yakokomoche mbaka matinazo. ");
INSERT INTO vid_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","Wone chinhu choneche chilumbigwe kwa ilongo chidolizwe na munhu yalingulawa mifila yanguganigwa chituligwe. Ila chinhu choneche cha mbao yangulapigwa kuhovujigwa kwa mazi. ");
INSERT INTO vid_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","“ ‘Mlume yoneche yalingulawa mifila, wone yawe mkomu kwa utamwa wa heye, yangumlapa ayo munhu yabeteze mazuwa saba kung'hali kusigwa ukokomoche wa heye. Kohovuga mivalo ja heye na koga kwa mazi ganojile ga nzasa, na heye kowa kela. ");
INSERT INTO vid_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","Zuwa lya nane, yangumlapa yegale ng'hunda mbili za kisolo ama ng'hunda za kufujigwa hali Mkulu Nguluwi hali lwizi lwa ihema lya Nguluwi na kumha mtambika. ");
INSERT INTO vid_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","Mtambika kozilavya ng'hunda azo. Imwe kwa chiwalo cha nhambiko ya gehile na iyage kwa chiwalo cha nhambiko ya kulakazwa na heye mtambika komditila uhanyisi munhu ayo hali Mkulu Nguluwi na kumusila ukokomoche wa heye wa kulawa mifila. ");
INSERT INTO vid_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","“ ‘Wone mlume yoneche yalingulawa migonye, yangumlapa yoje mazi lukuli lweng'ha, na heye kowa yakokomoche mbaka matinazo. ");
INSERT INTO vid_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","Ivalo lyoneche lilagalilwe na migonye ama igozi lyoneche idolizwe na migonye ajo, yangumlapa yaihovuje kwa mazi, na yowa yakokomoche mbaka matinazo. ");
INSERT INTO vid_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","Wone mlume yawase na mdala, migonye jilawa, lelo yanguwalapa weng'ha weli woje mazi, na hewo wowa wakokomoche mbaka matinazo. ");
INSERT INTO vid_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","“ ‘Mdala yoneche yawele kuli mbuli za chidala, kanguwa yakokomoche kwa mihela ja mazuwa saba. Munhu yoneche yomdoliza mdala ayo, kowa yakokomoche mbaka matinazo. ");
INSERT INTO vid_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","Chinhu choneche choyowasila ama kikalisila mhela nayali yakokomoche, chowa chikokomoche. ");
INSERT INTO vid_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","Munhu yoneche yodoliza chinhanda choyalinguwasila ayo mdala, yangumlapa yahovuje mivalo ja heye na koga mazi, na heye kowa yakokomoche mbaka matinazo. ");
INSERT INTO vid_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","Munhu yoneche yodoliza chinhu choneche choyalingikalisila mdala ayo, yangumlapa yahovuje mivalo ja heye na koga mazi, na heye kowa yakokomoche mbaka matinazo. ");
INSERT INTO vid_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","Mlume yoneche yodoliza chinhu choyowasila ama kikalisila ayo mdala, kowa yakokomoche mbaka matinazo. ");
INSERT INTO vid_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","Wone mlume yowasa na mdala ayo na wone danda ya mbuli ya chidala ya mdala ayo imlagalile mlume ayo, lelo mlume ayo kowa yakokomoche kwa mhela wa mazuwa saba. Chinhanda choneche choyowasila ayo mlume chowa chikokomoche. ");
INSERT INTO vid_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","“ ‘Wone mdala kowa na mbuli azo za chidala kwa mhela wa mazuwa menji kusinda vyonayali, ama mbuli azo zangumlawila mhela hauwele wa heye kulawilwa na mbuli azo, lelo kolutilila kuwa yakokomoche mhela weng'ha wa mbuli ayo. ");
INSERT INTO vid_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","Chinhanda choneche choyowasila mhela awo, ama chigoda choneche choyosikalisila, chowa chikokomoche kota vila mhela wa kukokomoka kwa heye kwa mbuli za chidala. ");
INSERT INTO vid_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","Munhu yoneche yodoliza vinhu avyo, kowa yakokomoche na yangumlapa yahovuje mivalo ja heye na koga, na heye kowa yakokomoche mbaka matinazo. ");
INSERT INTO vid_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","Wone mbuli azo zimale, mdala ayo kowa yang'hali yobeteza mazuwa saba leka yawe kela, na mhela awo kowa kela. ");
INSERT INTO vid_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","Zuwa lya nane kohola ng'hunda mbili za kisolo ama ng'hunda mbili za kufujigwa na kumgalila mtambika hali lwizi lya ihema lya Nguluwi. ");
INSERT INTO vid_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","Mtambika kolavya imwe kwa chiwalo cha nhambiko ya gehile na iyage kwa chiwalo cha nhambiko ya kulakazwa. Ahyo mtambika komditila uhanyisi mdala ayo hali Mkulu Nguluwi na kumusila kukokomoka kwa heye kwa mbuli za chidala. ");
INSERT INTO vid_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","“ ‘Ahi ndo vyomuwalonjela Waisilaeli webagule kulawa kuli kukokomoka kwa hewo, waleche kulidita liwe likokomoche ihema lya Nguluwi lya heni liwele hali hewo. Wone wadite hino wobagama.’ ” ");
INSERT INTO vid_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","Ago ndo malajizo galingumlapa mlume ayo yalingulawa mifila na migonye na kuwa yakokomoche. ");
INSERT INTO vid_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","Malanguso aga kahi ganguwala mdala yawele kuli mbuli za chidala na kuwa yakokomoche. Malanguso aga ganguwala mlume ayo ama mdala yoneche yalingulawa mifila, na kahi ganguwala mlume yalinguwasa na mdala yawele yakokomoche. ");
INSERT INTO vid_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","Mkulu Nguluwi nakalongasa na Musa, hala wana weli wa Aluni nalowabagame mhela ula nalowamhejelele Mkulu Nguluwi. ");
INSERT INTO vid_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","Mkulu Nguluwi nakamlonjela Musa, “Mlonjele mng'holozo Aluni yaleche kwinjila hali honhu helile ng'hatu, kumbele kwa ipaziya mhela wohaukundigwe. Yaleche kwinjila honhu aho kwa vila hondilawila hali ng'hungugu mchanya hali chigubiko cha uhanyisi, chiwele ndo isanduku. Wone hambe yahulichize, kobagama. ");
INSERT INTO vid_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","“Aluni kokwinjila honhu helile ng'hatu yawele na ilogota ilume kwa chiwalo cha nhambiko ya gehile na ing'holo ilume kwa chiwalo cha nhambiko ya kulakazwa. ");
INSERT INTO vid_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","Kokoga lukuli lweng'ha kuli mazi, hamba kovala mivalo jelile. Kovala ikanzu lya kitani, mchanya mwa ivalo lya mgati mwa lupati lwa kitani na kiwoha isali lya kitani na kovala chipembelo cha kitani. ");
INSERT INTO vid_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","Kohola mipongo mili kulawa kuli Waisilaeli weng'ha kwa chiwalo cha nhambiko ya gehile na ing'holo ilume limwe kwa chiwalo cha nhambiko ya kulakazwa. ");
INSERT INTO vid_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","“Aluni kolavya alyo ilogota kota nhambiko ya gehile kwa chiwalo cha heye yuye, na kudita uhanyisi kwa chiwalo cha heye yuye na ivyazi lyake. ");
INSERT INTO vid_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","Hamba, jila mipongo mili kojiwika hali Mkulu Nguluwi hali lwizi lwa ihema lya Nguluwi. ");
INSERT INTO vid_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","Aluni kojitowela simbi mipongo ajo kwa maganga meli, iganga limwe kwa chiwalo cha Mkulu Nguluwi na iganga lisigale ndo kwa chiwalo cha Azazeli. ");
INSERT INTO vid_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","Aluni koligala alyo ipongo liwele kwa simbi ya heye naliganigwa kwa chiwalo cha Mkulu Nguluwi na kumlavila nhambiko ya gehile. ");
INSERT INTO vid_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","Ila alyo ipongo lihaguligwe kwa simbi kwa chiwalo cha Azazeli, lyolavigwa liwele likomu hali Mkulu Nguluwi, leka kudita uhanyisi. Mtambika kolileka lilute kuchiwala kwa Azazeli. ");
INSERT INTO vid_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","“Aluni kolavya ilogota ilume kwa nhambiko ya gehile kwa chiwalo cha heye yuye, na kudita uhanyisi kwa chiwalo cha heye yuye na kwa chiwalo cha ivyazi lya heye, hamba kolidumula singo ilogota alyo kwa nhambiko ya gehile. ");
INSERT INTO vid_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","Hamba kohola chila chifunyizi chimemile makala ga chiluli kulawa kuli honhu ha kulavila nhambiko hali Mkulu Nguluwi na viganza vili vya ubani ubalaswe goya na kuvigala hali honhu helile ng'hatu. ");
INSERT INTO vid_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","Leka yaleche kubagama, kougala ubani awo hali Mkulu Nguluwi na kujela kuli chiluli leka iyosi lya ubani awo ugubiche chigubiko cha uhanyisi cha isanduku lya ilagano. ");
INSERT INTO vid_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","Kohola chasi cha danda ya lila ilogota ilume na kumizila kwa chidole cha heye kolilawilaga isanya mchanya mwa chigubiko cha uhanyisi, hamba komizila hali isanduku lya ilagano mala saba kwa chidole cha heye. ");
INSERT INTO vid_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","“Hamba kolidumula singo lila ipongo lya nhambiko ya gehile kwa chiwalo cha wanhu weng'ha. Danda ya mhene ayo koigala mgati mwa honhu helile ng'hatu na kudita kota vyoyaditile kwa danda ya lila ilogota ilume, komizila hawele na chigubiko cha uhanyisi na ubanzi wa kumwando. ");
INSERT INTO vid_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","Ahyo kodita uhanyisi kwa chiwalo cha honhu helile ng'hatu, kwa chiwalo cha mbuli zikokomoche zowaditile Waisilaeli na kwa chiwalo cha gehile ga hewo geng'ha. Ndo vyoyodita kahi kwa chiwalo cha ihema lya Nguluwi liwele hali wanhu awo wawele wakokomoche. ");
INSERT INTO vid_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","Mhela Aluni yodita uhanyisi kwa chiwalo cha heye yuye na kwa chiwalo cha ivyazi lya heye na wanhu weng'ha wa Isilaeli, munhu yunji yaleche kuwa mgati mwa ihema lya Nguluwi mbaka vyoyosinda mijito na kulawa mgati. ");
INSERT INTO vid_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","Hamba kolawa na kuza kuli honhu ha kulavila nhambiko hawele na Mkulu Nguluwi na kudita uhanyisi. Kohola chasi cha danda ya lila ilogota ilume na lila ipongo na kuzibakaliza mbalati za honhu ha kulavila nhambiko banzi zeng'ha. ");
INSERT INTO vid_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","Komizila danda ayo hali honhu ha kulavila nhambiko kwa chidole cha heye mala saba na ahyo koyeliza kulawa kukokomoka kwa wanhu wa Isilaeli na kuidita iwe yelile. ");
INSERT INTO vid_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","“Aluni vyonayasindile kuhaditila uhanyisi honhu helile ng'hatu na ihema lya Nguluwi na honhu ha kulavila nhambiko, aho ndo kolilavya lila ipongo liwele likomu kwa chiwalo cha Azazeli. ");
INSERT INTO vid_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","Aluni kowika moko ga heye mchanya mwa mutwi wa alyo ipongo likomu na kulonga kwa mlomo gehile geng'ha ga wanhu wa Isilaeli na kuhinduka kwa hewo kweng'ha na wihe wa hewo weng'ha, leka kugawika ago kuli ipongo. Hamba kolileka alyo ipongo leka lilute kuchiwala, lyohilichigwa ako na munhu yoneche yula yahaguligwe kudita ahyo. ");
INSERT INTO vid_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","Kolileka alyo ipongo lilute kuchiwala, liwele liholile wihe wa hewo weng'ha. ");
INSERT INTO vid_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","“Hamba Aluni kohiluka mgati mwa ihema lya Nguluwi, kovula jila mivalo ja kitani joyavalile vyoyenjile honhu helile ng'hatu na kuzileka mumo. ");
INSERT INTO vid_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","Kochihovuga mumo mgati kwa mazi hali honhu hanji helile na kuvala mivalo ja heye ja hihi hela. Kolawa na kilavila nhambiko ya heye ya kulakazwa, na nhambiko ya kulakazwa kwa wanhu wa Isilaeli, leka kudita uhanyisi kwa chiwalo cha heye yuye na kwa chiwalo cha wanhu weng'ha. ");
INSERT INTO vid_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","Mafuta ga nhambiko ya gehile kogalakaza mchanya mwa honhu ha kulavila nhambiko. ");
INSERT INTO vid_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","Yula munhu yalihiliche lila ipongo kwa Azazeli, kohovuga mivalo ja heye tandi na koga, aho ndo kokundigwa kwinjila kuli kambi ayo. ");
INSERT INTO vid_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","Lila ilogota ilume na mhene yajilavile nhambiko ya gehile iwele danda ya hewo naihilichigwa mgati mwa honhu helile ng'hatu kwa kudita uhanyisi, johilichigwa kunze mwa kambi na kulakazwa kwa chiluli. Migozi na miunde na midowe, vyeng'ha vyolakazwa. ");
INSERT INTO vid_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","Munhu ayo yojilakaza kohovuga mivalo jake na koga, ndo vyoyoweza kwinjila kuli kambi. ");
INSERT INTO vid_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","“Ali ndo ilajizo lilinguwalapa mliwinze mazuwa gose. Zuwa lya kumi lya mwezi wa saba, hemwe mwemwe na wajenzi walingikala na hemwe, yanguwalapani mwesele kulya zuwa alyo na kuleka kukola mijito. ");
INSERT INTO vid_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","Mina kwa zuwa alyo uhanyisi woditigwa kwa chiwalo cha hemwe leka kuweliza hemwe, namwe mokwelizwa kulawa kuli gehile ga hemwe geng'ha hali Mkulu Nguluwi. ");
INSERT INTO vid_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","Zuwa alyo ndo zuwa lya kwesela ng'hatu na hemwe mwesele kulya. Malajizo ago ndo ga mazuwa gose. ");
INSERT INTO vid_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","Mtambika Mkulu yabakalizwe mafuta na kuwichigwa kwa mijito ya chiuyeng'ha yawe honhu ha mhaza wa heye, ndo yodita uhanyisi yawele yavalile mivalo jelile ja kitani. ");
INSERT INTO vid_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","Kodita uhanyisi kwa chiwalo cha honhu helile ng'hatu na kwa chiwalo cha ihema lya Nguluwi na honhu ha kulavila nhambiko na watambika na kwa chiwalo cha wanhu weng'ha wa Isilaeli. ");
INSERT INTO vid_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","Ali, lelo ndo ilajizo lya mazuwa gose, na yanguganigwa mliwinze leka kudita uhanyisi kwa chiwalo cha wanhu wa Isilaeli kamwe kwa mwaka kwa chiwalo cha gehile ga hewo gowaditile.” Musa nakadita geng'ha kota vyoyalajizwe na Mkulu Nguluwi. ");
INSERT INTO vid_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","Mkulu Nguluwi nakamlonjela Musa, ");
INSERT INTO vid_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","“Mlonjele Aluni na wanage na wanhu weng'ha wa Isilaeli achi ndo chinhu choyalajize Mkulu Nguluwi. ");
INSERT INTO vid_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","Wone munhu yoneche hali Waisilaeli yodumula singo isenga ibuguma ama ing'holo lyana ama mhene, mgati ama kunze mwa kambi, ");
INSERT INTO vid_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","ne kuligala igongolo alyo kuli lwizi lwa ihema lya Nguluwi leka kumlavila Mkulu Nguluwi, munhu ayo kowa na nongwa ya kubohola danda, kabohola danda na kobaguligwa na wanhu wa heye. ");
INSERT INTO vid_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","Chiwalo cha malajizo aga ndo kota Waisilaeli wanguganigwa kigala migongolo jiwele ngudumuligwa singo kumgunda leka wejigale kwa Mkulu Nguluwi kwa mtambika kuli lwizi lwa ihema lya Nguluwi na kudumuligwa singo na kumlavila Mkulu Nguluwi nhambiko ya kikala goya. ");
INSERT INTO vid_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","Lelo mtambika kobohola danda hali honhu ha kulavila nhambiko ha Mkulu Nguluwi hawele hali lwizi lwa ihema lya Nguluwi na kugalakaza gala mafuta gawe gonhunyhilila goya kwa kumnojeza Mkulu Nguluwi. ");
INSERT INTO vid_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","Ahyo Waisilaeli woleka ng'hatu kujilavila nhambiko jimalukolo ja milungu ja udesi jiwhanile kota mhene, jowalingujifugamila kota wang'hondwa. Ilajizo ali ndo lya mazuwa gose kwa lulelo lweng'ha. ");
INSERT INTO vid_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","“Walonjele kota munhu yoneche hali Waisilaeli ama mjenzi yalingikala hali hewo, yalingulavya nhambiko ya kulakazwa ama nhambiko, ");
INSERT INTO vid_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","ila halingigala hali lwizi lwa ihema lya Nguluwi leka kumlavila Mkulu Nguluwi, munhu ayo kobaguligwa na wanhu wa heye. ");
INSERT INTO vid_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","“Wone munhu yoneche hali Waisilaeli ama mjenzi yalingikala hali hewo kangulya danda yoneche, heni ndomlema munhu ayo yadile danda na kumbagula kutali na wanhu wa heye. ");
INSERT INTO vid_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","Yowa ahyo kwa chiwalo cha ukomu wa chilumbigwe cha amo mli danda. Ndiwalajiza kuilavila danda hali honhu ha kulavila nhambiko leka kudita uhanyisi kwa chiwalo cha ukomu wa hemwe, kwa vila danda yangudita uhanyisi mina ukomu awo wa mli danda. ");
INSERT INTO vid_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","Ndo mina ndiwalonjela Waisilaeli ahi, ‘Munhu yoneche hali hemwe ama mjenzi yalingikala hali hemwe yanguganigwa yaleche kulya danda.’ ");
INSERT INTO vid_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","“Munhu yoneche hali Waisilaeli ama mjenzi yalingikala hali hewo yoluta kupelemba migongolo ama videje vya uligo, yangumlapa yabohole danda hanyi na kuigubika kwa misanga. ");
INSERT INTO vid_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","Mina ukomu wa chila chilumbigwe wamumo mli danda. Ndo mina ndiwalonjela Waisilaeli kota waleche kulya danda ya chilumbigwe choneche kwa vila ukomu wa chilumbigwe choneche ndo danda. Yoneche yolya danda ayo kobaguligwa. ");
INSERT INTO vid_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","“Munhu yoneche yawele mwenyeng'haye ama mjenzi, yalingulya choneche chibagame chicho ama chikopoligwe na igongolo lya kisolo, yangumlapa yahovuje mivalo ja heye na koga, na heye kowa yakokomoche mbaka matinazo. Kulawila aho, kowa kela. ");
INSERT INTO vid_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","Ila wone hahovuje mivalo ja heye na koga, yomlapa munhu ayo kugazigwa kwa chiwalo cha wihe wa heye.” ");
INSERT INTO vid_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","Mkulu Nguluwi nakamlonjela Musa, ");
INSERT INTO vid_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","“Walonjele wanhu wa Isilaeli kota heni ndo Mkulu Nguluwi, Nguluwi wa hemwe. ");
INSERT INTO vid_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","Ndangukulonjelani mleche kudita kota vyowalingudita wanhu wa isi ya Misili konamwali mikale, na mleche kudita kota vyowalingudita wanhu wa isi ya Kanaani kondiwahiliche. Ndangukulonjelani mleche kuwinza vyowalingudita hewo. ");
INSERT INTO vid_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","Hemwe mowinza utaguso na kibatilila malajizo ga heni. Heni ndo Mkulu Nguluwi, Nguluwi wa hemwe. ");
INSERT INTO vid_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","Lelo leka munhu yalohole ukomu wa heye, mwangulapigwa kuwinza malajizo na utaguso wa heni. Heni ndo Mkulu Nguluwi. ");
INSERT INTO vid_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","“Munhu yoneche wa Isilaeli hambe yakundizwe kuwasa na mng'holoze wa habehi. Heni ndo Mkulu Nguluwi. ");
INSERT INTO vid_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","Ndangukulonjela uleche kumbasa soni mhaza wa hegwe kwa kuwasa na mayako yakupondile. Uleche kumbasa soni, heye ndo mayako. ");
INSERT INTO vid_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","Ndangukulonjela uleche kumbasa soni mhaza wa hegwe kwa kuwasa na yumwe wa wadala wa mhaza wa hegwe. ");
INSERT INTO vid_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","Ndangukulonjela uleche kuwasa na lumbu wa hegwe, yawe mhinza wa mayako ama mhinza wa mhaza wa hegwe ama kulawa ng'handa yinji mihanzile mhaza. ");
INSERT INTO vid_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","Ndangukulonjela uleche kuwasa na mzukulugo mdala, mwana wa mwanago mlume ama wa mhinza wa hegwe, mina kwangibasa soni gwegwe baho. ");
INSERT INTO vid_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","Ndangukulonjela uleche kuwasa na mhinza yavumbuche na mayako yunji yahesigwe na mhaza wa hegwe yagaligwe kulawa kuli ivyazi lya mhaza wa hegwe, kwa vila mhinza ayo ka lumbu wa hegwe. ");
INSERT INTO vid_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","Ndangukulonjela uleche kuwasa na lumbu wa mhaza wa hegwe, ayo ka mng'holoze mhaza wa hegwe. ");
INSERT INTO vid_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","Ndangukulonjela uleche kuwasa na lumbu wa mayako, kwa vila ayo ka mng'holoze mayako. ");
INSERT INTO vid_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","Ndangukulonjela uleche kumbasa soni mhaza mkulu wa hegwe kwa kuwasa na mdala wa heye, ayo ka mayako. ");
INSERT INTO vid_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","Ndangukulonjela uleche kuwasa na mche wa mwanago, ayo ndo mkweyo. Uleche kuwasa na heye. ");
INSERT INTO vid_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","Ndangukulonjela uleche kuwasa na mdala wa kalumbu wa hegwe mkulu ama mdodo, ahyo kombasa soni mng'holozo. ");
INSERT INTO vid_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","Wone kowasa na mdala, lelo ndangukulonjela uleche kuwasa na heye mhinza wa heye ne wazukulu wa heye. Awo ndo wang'holozo. Kuwahazanya ndo kudita gehile. ");
INSERT INTO vid_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","Ndangukulonjela uleche kumuhola lumbu wa mchewako mhela mchewako yang'hali mkomu, ayo yokwambuza kilewa. ");
INSERT INTO vid_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","“Ndangukulonjela uleche kuwasa na mdala yawele kuli mhela wa mbuli za chidala. ");
INSERT INTO vid_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","Ndangukulonjela uleche kuwasa na mdala wa nayali habehi na hegwe na ahyo kiwika gwegwe uwe ukokomoche. ");
INSERT INTO vid_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","“Ndangukulonjela uleche kumlavya mwanago yoneche yawe nhambiko kwa mlungu Moleki, mina kudita ahyo kwangubeza itagwa lya heni Nguluwi wa hegwe. Heni ndo Mkulu Nguluwi. ");
INSERT INTO vid_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","“Ndangukulonjela uleche kuwasa na mlume miyago kota mdala. Alyo ndo izudizo. ");
INSERT INTO vid_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","Ndangukulonjela uleche kuwasa na igongolo leka uleche kuwa ukokomoche, mlume ama mdala yoneche yaleche kudita ahyo, kudita ahyo ndo kwajilila. ");
INSERT INTO vid_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","“Uleche kiwika uwe ukokomoche kwa kudita mbuli ayo kwa vila kwa chiwalo cha mbuli ayo ndanguwawinga wanhu wawele habehi na hemwe kwa vila hewo wangudita ahyo na kiwika wakokomoche. ");
INSERT INTO vid_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","Isi ya hewo naiwa ikokomoche na heni nandiigaza, na isi naiwadeka wanhu wa hewo. ");
INSERT INTO vid_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","Ila hemwe na wajenzi walingikala na hemwe mwanguganigwa kibatilila gala malajizo na utaguso wondiwalonjele, mleche kudita mazudizo ago. ");
INSERT INTO vid_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","Mazudizo ago nawadita wanhu nawekale kuli isi ya Kanaani, hewo wawalongole hemwe, nawo nawaidita isi iwe ikokomoche. ");
INSERT INTO vid_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","Lelo hemwe mleche kudita mbuli ayo, ama isi ayo yowadeka kota isi vyoiwadechile wanhu wawalongole hemwe. ");
INSERT INTO vid_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","Wanhu weng'ha walingudita mazudizo ago yanguwalapa wabaguligwe na wanhu wa hewo. ");
INSERT INTO vid_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","Lelo mibatilile goya geng'ha gondiwalonjele, mleche kuwinza geng'ha gomgazowele ga kuzudiza gaditigwe na wala wawalongole kikala muisi. Mleche kuwa mkokomoche kwa ago. Heni ndo Mkulu Nguluwi, Nguluwi wa hemwe.” ");
INSERT INTO vid_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","Mkulu Nguluwi nakamlonjela Musa, ");
INSERT INTO vid_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","“Walonjele Waisilaeli weng'ha kota yanguwalapa wawe welile kwa vila heni ndo Mkulu Nguluwi, Nguluwi wa hemwe, nda yelile. ");
INSERT INTO vid_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","Chila yumwe wa hemwe yangumlapa yawahulichize mayake na mhaza wa heye na kibata Zuwa lya Kwesela lya heni. Heni ndo Mkulu Nguluwi, Nguluwi wa hemwe. ");
INSERT INTO vid_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","Mleche kujigalamchila jimalukolo ja milungu, na mleche kigongomanyila jimalukolo ja milungu ja kuponda. Heni ndo Mkulu Nguluwi, Nguluwi wa hemwe. ");
INSERT INTO vid_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","“Lomumlavila Mkulu Nguluwi nhambiko ya kikala goya, momlavila kota vyoilinguganigwa leka mkundigwe. ");
INSERT INTO vid_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","Nhambiko ayo yanguganigwa iliche zuwa lilyo ilavigwe ama zuwa lya keli. Choneche chisigale mbaka zuwa lya kadatu yanguganigwa chilakazwe kwa chiluli. ");
INSERT INTO vid_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","Wone honhu ha iwunde lyolika zuwa lya kadatu, mbuli ayo ndo ikokomoka na nhambiko ayo hoikundigwa hebu. ");
INSERT INTO vid_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","Yoneche yolya iwunde alyo kogazigwa kwa chiwalo cha nongwa ya heye, kwa vila nakachibeza chinhu chelile cha Mkulu Nguluwi. Munhu ayo kobaguligwa na wanhu wa heye. ");
INSERT INTO vid_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","“Vyoubeta mbena ya isi ya hemwe, mleche kubeta ng'hatu mbaka kuli mbaka mwa mgunda, na mleche kuhiluka kumbele kukungajiza visigale. ");
INSERT INTO vid_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","Mleche kuwila kukungajiza chila chinhu kuli mgunda wa zabibu na mleche kulokoteza zabibu zigwile hanyi, mowalechela wazunwa na wajenzi. Heni nda Mkulu Nguluwi, Nguluwi wa hemwe. ");
INSERT INTO vid_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","“Mleche kuhiza, mleche kudeta ne kilonjela udesi. ");
INSERT INTO vid_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","Mleche kilaha udesi kwa itagwa lya heni na kulibeza itagwa lya Nguluwi wa hemwe. Heni ndo Mkulu Nguluwi. ");
INSERT INTO vid_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","“Mleche kumbunza yalihabehi na hegwe ne kumuhizila. Msahala wa munhu yakukolele mijito uleche kikala kwa hegwe nechilo yeng'ha mbaka lufuku. ");
INSERT INTO vid_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","Mleche kumpanjila yohambe yahuliche ne kuwika iganga kumwando kwa yohambe yalole, ila mumdumbe Nguluwi wa hemwe. Heni ndo Mkulu Nguluwi. ");
INSERT INTO vid_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","“Vyomumtagusa munhu yoneche, mtaguse kwa hachi, mleche kumganilila mzunwa ne kumdumba yawele na lufufu. Ila yanguwalapa kumtagusa goya yalihabehi na hemwe. ");
INSERT INTO vid_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","Ndanguwalonjela mleche kukolakola kuno muwalonjeleza udesi wanhu wa hemwe. Mleche kwambuza ukomu wa yalihabehi na hemwe kwinjila kuli nongwa ya kubagama kwa ulonzi wa hemwe. Heni ndo Mkulu Nguluwi. ");
INSERT INTO vid_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","“Mleche kuwazudila wang'holozenu mnhumbula za hemwe, ila mikanye na walihabehi na hemwe leka mleche kudita gehile. ");
INSERT INTO vid_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","Mleche kulipizila ama kuwazudila walelwa wa wanhu wa hemwe ila muwagane walihabehi na hemwe kota vyomlingigana mwemwe baho. Heni ndo Mkulu Nguluwi. ");
INSERT INTO vid_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","“Yanguwalapa kibatilila malajizo ga heni. Mleche kuleka migongolo ja hemwe jikwinigwe na migongolo ja nhanzi iyage. Mleche kunyala nyhadikwa za nhanzi mbili kumigunda ja hemwe. Mleche kuvala ivalo litawigwe kwa nhanzi mbili za uzi. ");
INSERT INTO vid_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","“Wone mlume yawase na mdala mpogozi yabanichilwe na mlume yunji, ila yang'hali kugomboligwa ne kilejeha, ulolezi ukoleche. Ila waleche kukopoligwa kwa vila mdala ayo nayang'hali kilejeha. ");
INSERT INTO vid_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","Mlume ayo kochigala nhambiko ya nongwa ya heye ya ing'holo ilume hali lwizi lwa ihema lya Nguluwi na kumlavila Mkulu Nguluwi. ");
INSERT INTO vid_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","Mtambika komditila uhanyisi kwa ing'holo ilume alyo hali Mkulu Nguluwi kokusilwa gehile ago goyaditile. ");
INSERT INTO vid_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","“Vyomluta kuli isi ya Kanaani na kunyala nyhadikwa zeng'ha za migodi ja mafuza, mafuza ago hamulya hebu, hamkundizwa kulya kwa mhela wa miyaka jidatu. ");
INSERT INTO vid_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","Kuli mwaka wa kane, mafuza geng'ha gowa gelile, golavigwa kuwa nhambiko ya katogo kwa Mkulu Nguluwi. ");
INSERT INTO vid_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","Ila mafuza ga kwaluchila mwaka wa kahano ago moweza kulya, na mbena kwa hemwe yokonjezeka. Heni ndo Mkulu Nguluwi, Nguluwi wa hemwe. ");
INSERT INTO vid_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","“Mleche kulya iwunde lyoneche liwele na danda. Mleche kulagula ne kudita uhawi. ");
INSERT INTO vid_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","Mleche kubeya mnvili za hafungo mwa makutu ga hemwe ne lulevu lwa hemwe lwa hafungo. ");
INSERT INTO vid_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","Mleche kitemanga mlukuli lwa hemwe kwa chiwalo cha wabagame na kiwika ulajilo mlukuli. Heni ndo Mkulu Nguluwi. ");
INSERT INTO vid_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","“Mleche kumuwifya muhinza wa hegwe kwa kumdita yawe mng'hondwa, isi yeng'ha ileche kugwila kuli ung'hondwa na ahyo kumema wihe. ");
INSERT INTO vid_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","Mochibatilila Zuwa lya Kwesela na kuhadumba honhu ha heni helile. Heni ndo Mkulu Nguluwi. ");
INSERT INTO vid_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","“Mleche kuwalutila walaguzi wa midimu ne wahawi leka muwalande wawalagulile na ahyo mowa mkokomoche. Heni ndo Mkulu Nguluwi, Nguluwi wa hemwe. ");
INSERT INTO vid_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","“Homchikala kumwando kwa wasekulu, yanguwalapa mwime leka kuwahulichiza. Namwe mumdumbe Nguluwi wa hemwe. Heni ndo Mkulu Nguluwi. ");
INSERT INTO vid_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","“Wone kuwe na mjenzi kuli isi ya hemwe, mleche kumditila vibi. ");
INSERT INTO vid_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","Ayo mjenzi yalingikala na hemwe kowa kwa hemwe kota mwenyeng'haye, namwe momgana kota vyomlingigana mwemwe baho, kwa vila namwe mwali wajenzi kuli isi ya Misili. Heni ndo Mkulu Nguluwi, Nguluwi wa hemwe. ");
INSERT INTO vid_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","“Mleche kutagusa vibi kuli vipimilo vya utali ne itunyo ne kumema. ");
INSERT INTO vid_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","Yanguwalapa muwe na vipimilo vya hachi. Heni nda Mkulu Nguluwi, Nguluwi wa hemwe, ndiwalavile kuli isi ya Misili. ");
INSERT INTO vid_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","Yanguwalapa kibata na kudita malajizo na utaguso weng'ha wa heni. Heni ndo Mkulu Nguluwi.” ");
INSERT INTO vid_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","Mkulu Nguluwi nakamlonjela Musa, ");
INSERT INTO vid_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","“Walonjele Waisilaeli kota munhu yoneche hali Waisilaeli ama mjenzi yalingikala na hemwe, yomlavya mwana wa heye yoneche kwa mlungu Moleki kota nhambiko, yangumlapa munhu ayo yabagame. Wanhu wa aho womkopola kwa kumtowa kwa maganga. ");
INSERT INTO vid_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","Heni ndomlema munhu ayo na kumbagula na wanhu wa heye kwa vila nakamlavya yumwe wa wanage, yawe nhambiko kwa mlungu Moleki, ahyo nakuhadita hawe hakokomoche honhu hangu helile na kulibeza itagwa lya heni lyelile. ");
INSERT INTO vid_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","Wone wanhu wa honhu aho womdinyila meho na kuleka kumkopola munhu ayo, ");
INSERT INTO vid_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","heni ndomlema munhu ayo na lukolo lwa heye. Ndowabagula hewo kulawa kuli wanhu wa hewo, yuye hamwe na weng'ha walingumlutila mlungu Moleki kota wang'hondwa. ");
INSERT INTO vid_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","“Wone munhu yoneche yowalutila walaguzi wa midimu na wahawi kota wang'hondwa, ayo hokundigwa na heni, ndomlema munhu ayo na kumbagula na wanhu wa heye. ");
INSERT INTO vid_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","Ahyo midite mwemwe muwe chiuyeng'ha, kwa vila heni nda Mkulu Nguluwi, Nguluwi wa hemwe. ");
INSERT INTO vid_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","Mibatilile malajizo ga heni na kugakolela. Heni nda Mkulu Nguluwi ndilinguweliza. ");
INSERT INTO vid_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","Munhu yoneche yalingumpanjila mhaza wa heye ama mayake, kobagama. Kana nongwa ilingumuwala kubagama. ");
INSERT INTO vid_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","“Wone mlume yadite ung'hondwa na mdala wa yalibehi na heye, ndangukomya yanguwalapa weng'ha weli wabagame. ");
INSERT INTO vid_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","Wone mlume yawase na yumwe wa wadala wa mhaza wa heye, kangumbasa soni mhaza wa heye, weng'ha weli ndangukomya yanguwalapa wabagame. Mlume ayo na mdala ayo, hewo wana nongwa ilinguwalapa wabagame. ");
INSERT INTO vid_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","Wone mlume yoneche yowasa na mdala wa mwanage, weng'ha weli yowalapa wabagame. Wajilila kwa kudita ung'hondwa wihile, wana nongwa ilinguwalapa kubagama. ");
INSERT INTO vid_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","Wone mlume yoneche yowasa na mlume miyage kota mdala, lelo weng'ha weli nawadita izudizo na yowagana wabagame, ahyo wana nongwa ilinguwalapa wabagame. ");
INSERT INTO vid_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","Wone mlume yohesa mdala na kahi yomhesa mamo wa mdala ayo, awo ndo wihe, weng'ha wadatu yanguwalapa walakazwe kwa chiluli leka kudumya wihe hali hemwe. ");
INSERT INTO vid_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","Wone mlume yoneche yowasa na igongolo, ndangukomya yangumlapa yabagame, na igongolo alyo nalyo libagame. ");
INSERT INTO vid_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","Wone mdala yolihejelela igongolo na kuwasa nalyo yangumlapa mdala ayo yabagame na igongolo nalyo libagame. Ahyo, wana nongwa ilinguwalapa kubagama. ");
INSERT INTO vid_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","“Wone mlume yoneche yomhesa lumbulye yapondigwe na mhaza wa heye ama mayake, na mhinza ayo nakekundiza na ayo mlume ayo yawele kalumbu wa heye, na kuwasa na heye, awo ndo wihe. Yanguwagana wabaguligwe na wayao wewhanile miyaka kwa vila nawadita mbuli ya soni. Mlume ayo kogazigwa kwa chiwalo cha gehile ga heye. ");
INSERT INTO vid_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","Wone mlume yawase na mdala yawele kuli mhela wa mbuli za chidala, weng'ha weli yanguwagana wabaguligwe na wanhu wa hewo. Mlume ayo nakawasa na mdala yakokomoche kwa kuwa na danda, na ayo mdala nakawasa na mlume na kuno yolawa danda. ");
INSERT INTO vid_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","Uleche kuwasa na mayako mkulu ne lumbu wa mhaza wa hegwe, mina ako ndo kuwabasa soni wang'holozo wali habehi na hegwe. Weng'ha walingudita ago wangulapigwa wagazigwe kwa chiwalo cha wihe wa hewo. ");
INSERT INTO vid_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","Wone munhu yawase na mdala wa mhaza wa heye mkulu ama mdodo, kangumbasa soni mhaza wa heye mkulu ama mdodo, weng'ha weli wowa na gehile, weng'ha weli wobagama ne wana. ");
INSERT INTO vid_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","Wone mlume yamhole mdala wa mkulugwe ama mdodowe, kangumbasa soni mng'holoze, ako ndo kukokomoka, weng'ha weli wobagama ne wana. ");
INSERT INTO vid_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","“Hemwe mweng'ha mwanguganigwa kibata na kukolela mijito malajizo na utaguso wa heni weng'ha, ila wone haiwa ahyo, isi yila yondilinguwahilika yowalema. ");
INSERT INTO vid_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","Mleche kuwinza vihendo vya wanhu wa isi yondilinguwawinga hali hemwe, kwa vila nawadita ago geng'ha, nani nandiwazudila ng'hatu. ");
INSERT INTO vid_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","Ila, mina nandiwalonjela, ‘Moihalila isi ya hewo, nani ndanguwapa isi ayo iwe ya hemwe, isi iwele na mboto.’ Heni nda Mkulu Nguluwi, Nguluwi wa hemwe yawabagule na isi zinji. ");
INSERT INTO vid_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","Lelo yangumgana yabagule igongolo linojile na likokomoche na chideje chinojile na chiwele chikokomoche. Mleche kidita muwe mkokomoche kwa kudoliza igongolo ama chideje ama choneche chilingutambala muisi chiwele ndichibagule chiwe chikokomoche. ");
INSERT INTO vid_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","Muwe mwelile kwa vila heni Mkulu Nguluwi nda yelile, na heni ndo ndiwabagulani hemwe na isi zinji leka muwe wa heni. ");
INSERT INTO vid_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","“Mlume ama mdala yoneche wone yawe mlaguzi wa midimu ama mhawi, imgana yabagame kwa kumtowa kwa maganga. Weng'ha wana nongwa ilinguwalapa wabagame.” ");
INSERT INTO vid_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","Mkulu Nguluwi nakamlonjela Musa, “Walonjele watambika wawele ndo walelwa wa Aluni kota haleche kuwa na munhu yoneche hali hewo yochidita yakokomoche kwa kudoliza mitufi ja wanhu wa lukolo lwa heye, ");
INSERT INTO vid_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","ila mtufi wa mng'holoze wa habehi kota mayake ama mhaza wa heye ama mwana wa heye ama mhinza wa heye ama mkulugwe ama mdodowe ");
INSERT INTO vid_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","ama lumbu wa heye yawele wa ivyazi lya heye lya habehi na heye yang'hali kuhesigwa, koweza kidita yakokomoche kwa chiwalo cha lumbu wa heye. ");
INSERT INTO vid_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","Heye mtambika yaleche kidita yakokomoche kwa wang'holoze kukolela kuhesa. Kwa kudita ahi, kangibeza heye yuye. ");
INSERT INTO vid_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","Walelwa wa Aluni nawaleche kubeya mnvili za honeche kumutwi kwa hewo ne lulevu lwawo ne kutema sale kuli ng'huli za hewo. ");
INSERT INTO vid_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","Wowa welile hali Nguluwi wa hewo waleche kulibeza itagwa lya Nguluwi wa hewo. Mina hewo ndo walingulavya zila nhambiko zoyalingupegwa Mkulu Nguluwi kwa chiluli na nhambiko yalingupegwa Nguluwi wa hewo. Lelo iwagana wawe welile. ");
INSERT INTO vid_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","Kwa vila mtambika nakawichigwa chiuyeng'ha na Nguluwi wa heye, yaleche kuhesa mdala yawele mng'hondwa ne mdala yawifigwe ne kupegwa kalatasi ya luleko. ");
INSERT INTO vid_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","Komzela mtambika kota nakaditigwa yawe yelile, mina heye ndo yalingulavya nhambiko ya ibumunda lya Nguluwi wa hegwe. Komzela kota ka yelile, mina heni Mkulu Nguluwi ndikwelize hegwe, nda yelile. ");
INSERT INTO vid_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","Mhinza wa mtambika yoneche yochibeza heye yuye kwa kudita ung'hondwa, heye kangumuwifya mhaza wa heye, kolakazwa kwa chiluli. ");
INSERT INTO vid_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","“Mtambika mkulu yoneche hali wang'holoze, yawele nakajidilwa mafuta kumutwi kwa heye, na kuwichigwa chiuyeng'ha leka yavale mivalo jelile, yaleche mnvili za heye ziwe zizuzumuche na yaleche kudadula mivalo ja heye kwa kulombocheza. ");
INSERT INTO vid_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","Yaleche kuhejelela mtufi ne kidita yakokomoche kwa mtufi hanga ka mhaza wa heye ama mamo wa heye. ");
INSERT INTO vid_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","Kwa vila kwelizwa kwa kubakaliza mafuta ga Nguluwi kwa mchanya mwa heye, lelo nayaleche kuka honhu helile na kuhadita hawe hakokomoche. Heni nda Mkulu Nguluwi. ");
INSERT INTO vid_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","Mtambika mkulu komhesa mdala yohanating'hana na mlume. ");
INSERT INTO vid_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","Hambe yakundigwe kumhesa mdala yafililwe na mlume wa heye ne mdala yapegwe kalatasi ya luleko na mlume wa heye ne mdala yawifigwe ne mdala mng'hondwa. Imlapa yahese mdala yohanating'hana na mlume kulawa wanhu wa heye yuye, ");
INSERT INTO vid_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","lelo yaleche kuwadita wana wa heye yuye wawe wakokomoche. Heni nda Mkulu Nguluwi ndimditile yawe yelile.” ");
INSERT INTO vid_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","Mkulu Nguluwi nakamlonjela Musa, ");
INSERT INTO vid_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","“Mlonjele Aluni kota mlelwa wa hegwe yoneche kuli ivyazi lyeng'ha lilinguya yawele na nongwa mli lukuli lwa heye, hambe yakundigwe kuhejelela na kundavila nhambiko ya ibumunda heni Nguluwi wa heye. ");
INSERT INTO vid_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","Munhu yoneche yawele na nongwa yaleche kuhejela kundavila nhambiko. Yawe yohambe yalole ama yaziliche vitomo ama yawele vibi kumeho ama yawele na chitomo chitomoche lukami ");
INSERT INTO vid_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","ama yawele na moko ama mgulu ulumile, ");
INSERT INTO vid_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","yawele na chiduhi ama munhu yawele chifude ama yawele na njele ama yawele na utamwa wa kizada ama yawele na utamwa wa ngozi ama yalumile mhumbu. ");
INSERT INTO vid_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","Mlelwa yoneche wa mtambika Aluni yawele na nongwa mli lukuli lwa heye, yaleche kuhejela kumlavila nhambiko kwa chiluli Mkulu Nguluwi. Hambe yalavye nhambiko ya ibumunda kwa Nguluwi wa heye. ");
INSERT INTO vid_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","Munhu ayo koweza kulya ibumunda lya Nguluwi wa heye na vinhu vyelile na vinhu vyelile ng'hatu. ");
INSERT INTO vid_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","Ila yaleche kulihejelela lila ipaziya ne hala honhu ha kulavila nhambiko kwa vila kana nongwa, leka yaleche kuhadita honhu aho helile hawe hawifigwe, kwa vila heni Mkulu Nguluwi ndo ndilinguwadita wawe welile.” ");
INSERT INTO vid_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","Musa nakawalonjela Aluni na wana wa heye na Waisilaeli weng'ha mbuli zila zeng'ha. ");
INSERT INTO vid_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","Mkulu Nguluwi nakamlonjela Musa, ");
INSERT INTO vid_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","“Walonjele Aluni na wana wa heye watambika kota welolele vinhu vyelile viwele Waisilaeli nawaviwika viwe vya chiuyeng'ha, leka waleche kulibeza itagwa lya heni lyelile. Heni ndo Mkulu Nguluwi. ");
INSERT INTO vid_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","Walonjele kota yumwe wa wana wa hewo kuli lulelo lwa hewo lweng'ha yovihejelela vinhu vyelile viwele Waisilaeli nawaviwika viwe vya chiuyeng'ha kwa heni Mkulu Nguluwi, kuno yawele yakokomoche, munhu ayo kobaguligwa na heni. Heni ndo Mkulu Nguluwi. ");
INSERT INTO vid_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","Wone munhu yoneche wa ivyazi lya Aluni yowa na utamwa wa ngozi ama mifila jilingumlawa, yaleche kulya vinhu vyelile mbaka hoyowa yelile. Munhu yoneche wone yamdolize munhu yawele yakokomoche kwa kudoliza mtufi ama munhu yalingulawa migonye, ");
INSERT INTO vid_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","ama wone yadolize chilumbigwe choneche chilingutambala chilingumwambuza munhu yawe yakokomoche ama munhu yawele yoweza kumdita munhu yawe yakokomoche kwa vilivinji hela, ");
INSERT INTO vid_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","munhu ayo, kowa yakokomoche mbaka matinazo na hambe yakundigwe kulya vinhu vyelile mbaka aho hoyoluta koga. ");
INSERT INTO vid_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","Isanya holizinga aho ndo kowa kela. Hamba koweza kulya vinhu vyelile kwa vila acho ndo chilyo cha heye. ");
INSERT INTO vid_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","Mtambika yaleche kulya iwunde lyoneche lya igongolo libagame liliyeka ama kukopoligwa na igongolo lya kisolo, leka yaleche kidita yawe yakokomoche. Heni ndo Mkulu Nguluwi. ");
INSERT INTO vid_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","Ahyo iwagana watambika wahulichize ilajizo lya heni, leka waleche kudita gehile na kukopoligwa kwa kubeza ilajizo. Heni Mkulu Nguluwi ndo ndilinguwadita wawe welile. ");
INSERT INTO vid_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","“Munhu yohawele wa lukolo lwa watambika, hambe yakundigwe kulya chilyo chelile. Mjenzi wa mtambika ama mkola mijito wa heye hambe yakundigwe kulya kahi. ");
INSERT INTO vid_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","Ila wone mtambika yamgule mpogozi leka yawe wa heye, lelo ayo mpogozi kokundigwa kulya na kahi wala wapondigwe haluga hake. ");
INSERT INTO vid_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","Wone mhinza wa mtambika nakahesigwa na munhu yohawele mtambika, hambe yakundigwe kulya nhambiko ya vinhu vyelile. ");
INSERT INTO vid_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","Ila wone mhinza wa mtambika ka mlekwa ama nakapegwa kalatasi ya luleko na kahi kahela mwana, na heye nakahiluka haluga kwa mhaza wa heye, na kikala na heye kota vyoiwele hamwande, lelo koweza kulya chilyo cha mhaza wa heye. Ila ivyazi lya mtambika liliyeka ndo lyokundigwa kulya chilyo acho. ");
INSERT INTO vid_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","Wone munhu yunji yolya vilyo avyo vyelile ne kuvizela, lelo kokonjeza honhu hamwe ha kahano kuli vila vinhu vyoyadile na kumhilusila mtambika. ");
INSERT INTO vid_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","Mtambika yaleche kuvibeza vinhu vyelile viwele Waisilaeli nawamlavila Mkulu Nguluwi ");
INSERT INTO vid_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","na ahyo kwambuza wanhu wawe na nongwa na kugazigwa kwa chiwalo cha kulya vilyo avyo vyelile. Heni Mkulu Nguluwi ndo ndilinguvidita vinhu avyo viwe vyelile.” ");
INSERT INTO vid_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","Mkulu Nguluwi nakamlonjela Musa, ");
INSERT INTO vid_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","“Mlonjele Aluni na wana wa heye watambika na Waisilaeli weng'ha kota munhu yoneche hali hemwe ama mjenzi yoneche yalingikala hali isi ya Isilaeli, yolavya nhambiko ya heye ya kulakazwa, iwe ya kutawiza kilaha ama nhambiko ya kunuwila kwa heye kwa kumlavila Mkulu Nguluwi, ");
INSERT INTO vid_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","leka yakundigwe, kolavya ibuguma limwe ama ing'holo ilume ama ipongo limwe lilihela nongwa. ");
INSERT INTO vid_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","Ilemezigwa kulavya choneche chiwele na nongwa, hambe chikundigwe kwa hemwe. ");
INSERT INTO vid_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","Munhu yoneche hoyomlavila Mkulu Nguluwi nhambiko ya kikala goya leka yatawize kilaha ama nhambiko ya kunuwila kulawa kuli chilundo cha heye cha migongolo, leka yakundigwe, igana liwe igongolo linojile, igongolo alyo liwe lilihela nongwa yoneche. ");
INSERT INTO vid_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","Uleche kumlavila Mkulu Nguluwi igongolo lyoneche liwele hambe lilole na chete na libeneche honhu honeche na lilingulavya mifila na liwele na utamwa wa kizada ama chilonda, na uleche kujilavya jiwe nhambiko kwa Mkulu Nguluwi kwa chiluli mchanya mwa honhu ha kulavila nhambiko. ");
INSERT INTO vid_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","Ibuguma ama ing'holo lyana liwele na chitomo chimwe chisoloche ama chifupi kusinda vyoilinguganigwa yokulapa kumlavila nhambiko ya kunuwila ya kumlavila Mkulu Nguluwi, ila uleche kulilavya liwe nhambiko ya kutawiza kilaha. ");
INSERT INTO vid_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","Igongolo liwele lilumile mhumbu ama ihondigwe ama isaluligwe ama idumuligwe, mleche kumlavila Mkulu Nguluwi. Uleche kudita chinhu cha ahyo muisi ya hegwe. ");
INSERT INTO vid_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","Na uleche kubochela kulawa kwa wajenzi migongolo jiwele ahyo na kumlavila Nguluwi wa hegwe kota nhambiko. Migongolo ajo jina nongwa kwa vila jidumuligwa na hojikundigwa kwa kugana hemwe.” ");
INSERT INTO vid_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","Mkulu Nguluwi nakamlonjela Musa, ");
INSERT INTO vid_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","“Wone isenga ama ing'holo ama mhene ileleche, lyopona na mayake kwa mazuwa saba. Ila kwaluchila zuwa lya nane lyoweza kulavigwa kwa Mkulu Nguluwi kwa chiluli. ");
INSERT INTO vid_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","Ila uleche kulidumula singo ibuguma ama ing'holo zuwa limwe hamwe na lyana lyake. ");
INSERT INTO vid_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","Homumlavila Mkulu Nguluwi nhambiko ya kuta malumbo, koilavya leka ukundigwe. ");
INSERT INTO vid_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","Igongolo alyo lyanguganigwa liliche zuwa lilyo, mleche kusigaza mbaka zuwa lya keli. Heni ndo Mkulu Nguluwi. ");
INSERT INTO vid_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","“Ahyo mochibatilila malajizo na kudita vyondonjile heni. Heni ndo Mkulu Nguluwi. ");
INSERT INTO vid_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","Mleche kulibeza itagwa lya heni lyelile, kwa vila lyanguganigwa lizeleche kota lyelile hali wanhu wa Isilaeli. Heni Mkulu Nguluwi ndo ndilinguwadita hemwe muwe mwelile. ");
INSERT INTO vid_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","Heni ndo ndiwalavile kulawa kuli isi ya Misili leka ndiwe Nguluwi wa hemwe. Heni ndo Mkulu Nguluwi.” ");
INSERT INTO vid_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","Mkulu Nguluwi nakamlonjela Musa, ");
INSERT INTO vid_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","“Walonjele Waisilaeli kota kuli mnvina za Mkulu Nguluwi, ziwele mozidamla kota mowa na nhing'hano yelile, mnvina zonandonjile ndo azi. ");
INSERT INTO vid_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","Kowa na mazuwa sita ga kukola mijito. Ila zuwa lya saba ndo zuwa lya kwesela, hamkola mijito na mowa kuli nhing'hano yelile. Zuwa alyo lya saba hamkola mijito hebu, alyo ndo zuwa lya kwesela kwa Mkulu Nguluwi kuli honhu homlingikala hemwe mweng'ha. ");
INSERT INTO vid_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","“Mnvina ziyage za Mkulu Nguluwi ndo mowa na nhing'hano yelile mozidamla kuli mhela uyage uwichigwe. ");
INSERT INTO vid_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","“Mhela wa kuzinga kwa isanya, kuli zuwa lya kumi na gane lya mwezi wa mwaluko, mogongomanya mnvina ya Pasaka ya Mkulu Nguluwi. ");
INSERT INTO vid_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","Zuwa lya kumi na kahano lya mwezi uwo, ndo lya mnvina kwa Mkulu Nguluwi, mnvina ya mibumunda johajiwichigwe usaso. Kwa mhela wa mazuwa saba, molya mibumunda johajiwichigwe usaso. ");
INSERT INTO vid_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","Kuli zuwa lya mwaluko mowa na nhing'hano yelile. Zuwa alyo mleche kukola mijito ja chila zuwa. ");
INSERT INTO vid_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","Kwa mhela wa mazuwa saba momlavila Mkulu Nguluwi nhambiko kwa chiluli. Kuli zuwa lya saba modita nhing'hano yelile. Mleche kukola mijito ja chila zuwa.” ");
INSERT INTO vid_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","Mkulu Nguluwi nakamlonjela Musa, ");
INSERT INTO vid_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","“Walonjele Waisilaeli kota vyomkwinjila kuli isi yondiwapa na kubeta mbena, momigalila mtambika chizabala cha mbena ya mwaluko. ");
INSERT INTO vid_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","Mtambika kodita ulajilo wa kwinula kuchanya chizabala acho hali Mkulu Nguluwi leka ukundigwe, loimalile Zuwa lya Kwesela, mtambika kokwinula kuchanya. ");
INSERT INTO vid_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","Zuwa alyo vyomwinula kuchanya kwa ulajilo wa kulavya acho chizabala, momlavila Mkulu Nguluwi nhambiko ya kulakazwa ya ing'holo lyana ilume lya mwaka umwe lilihela nongwa. ");
INSERT INTO vid_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","Hamwe na nhambiko ayo, molavya nhambiko ya nyhule ya kilo mbili za utimbo unojile uhanzigwe na mafuta ga mzeituni, gawele ndo ga kumlavila Mkulu Nguluwi kwa chiluli na kunhunyhilila kwake kwangunojeza na nhambiko ya heye ya chakunwa ndo lita imwe ya divai. ");
INSERT INTO vid_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","Namwe mleche kulya mibumunda ne nyhule zikalanjigwe ne nyhule ndodi, mbaka zuwa lyomumlavila nhambiko Mkulu Nguluwi wa hemwe. Ali ndo ilajizo loyalajize liwinzigwe mazuwa gose kuli lulelo lwa hemwe honhu honeche homchikala. ");
INSERT INTO vid_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","“Mowaliza majuma saba genele kwaluchila zuwa lila loimalile Zuwa lya Kwesela, lomigale chizabala cha nhambiko ya kwinula kuchanya. ");
INSERT INTO vid_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","Loifichile zuwa lya makumi gahano, zuwa lya keli ya Zuwa lya Kwesela lya saba, momlavila Mkulu Nguluwi nhambiko iyage ya nyhule zinyale. ");
INSERT INTO vid_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","Chila ivyazi kulawa kuli ng'handa za hewo, lyochigala mibumunda mili ja nhambiko ya kwinula kuchanya kwa ulajilo hali Mkulu Nguluwi. Ibumunda lyanguganigwa liwe ligongomanyigwe kwa kilo mbili za utimbo unojile uwichigwe usaso, na awo momlavila Mkulu Nguluwi uwe nhambiko ya mbena ya mwaluko. ");
INSERT INTO vid_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","Hamwe na ago, molavya ming'holo myana saba ja mwaka umwe jilihela nongwa na ilogota ilume limwe na ming'holo milume mili. Migongolo ajo jowa nhambiko ya kulakazwa hamwe na nhambiko ya nyhule na nhambiko ya cha kunwa. Nhambiko azo zolavigwa kwa chiluli na unhunyhililo awo womnojeza Mkulu Nguluwi. ");
INSERT INTO vid_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","Molavya ipongo limwe lya nhambiko ya gehile na ming'holo myana milume mili ja mwaka umwe kwa chiwalo cha nhambiko ya kikala goya. ");
INSERT INTO vid_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","Mtambika kovinula kuchanya vinhu avyo kwa ulajilo hali Mkulu Nguluwi, hamwe na ibumunda lya mbena ya mwaluko na jila ming'holo myana mili. Vinhu avyo ndo vyelile kwa Mkulu Nguluwi na avyo vyowa vya mtambika. ");
INSERT INTO vid_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","Zuwa lilyo mowikula kota hana nhing'hano yelile. Mleche kukola mijito ja chila zuwa. Ali ndo ilajizo lya kuwinza mazuwa gose kuli lulelo lwa hemwe lweng'ha, kuli kikala kwa hemwe. ");
INSERT INTO vid_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","“Hombeta mbena za hemwe kumgunda, lelo mleche kubeta mbaka kuli mbaka ja migunda ja hemwe na mleche kuhiluka kumbele kukungajiza gasigale. Mowalechela wazunwa na wajenzi. Heni ndo Mkulu Nguluwi, Nguluwi wa hemwe.” ");
INSERT INTO vid_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","Mkulu Nguluwi nakamlonjela Musa, ");
INSERT INTO vid_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","“Walonjele wanhu wa Isilaeli kota zuwa lya mwaluko lya mwezi wa saba mokwesela, zuwa lya kukumbuchila vyoiwikuligwa lizi lya mhalamhanda na kudita nhing'hano yelile. ");
INSERT INTO vid_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","Mleche kukola mijito ya chila zuwa na yanguganigwa mumlavile nhambiko Mkulu Nguluwi kwa chiluli.” ");
INSERT INTO vid_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","Mkulu Nguluwi nakamlonjela Musa, ");
INSERT INTO vid_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","“Zuwa lya kumi mwezi awo wa saba ndo Zuwa lya Uhanyisi. Zuwa alyo ndo zuwa lya nhing'hano yelile. Mokwesela kulya na kumlavila nhambiko Mkulu Nguluwi kwa chiluli. ");
INSERT INTO vid_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","Mleche kukola mijito ja hemwe joneche zuwa alyo. Zuwa alyo ndo Zuwa lya Uhanyisi, ndo zuwa ya kusa gehile hali Mkulu Nguluwi, Nguluwi wa hemwe. ");
INSERT INTO vid_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","Munhu yoneche yula yohambe yesele kulya zuwa alyo yanguganigwa yabaguligwe kutali na wanhu wa heye. ");
INSERT INTO vid_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","Munhu yoneche yokola mijito joneche zuwa alyo, ndomkopola kulawila kwa wanhu wa heye. ");
INSERT INTO vid_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","Mleche kukola mijito, ali ndo ilajizo lya kuwinza mazuwa gose kuli lulelo lwa hemwe, na kuli luga lwa hemwe lweng'ha. ");
INSERT INTO vid_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","Mokwesela zuwa alyo, namwe mokwesela kulya. Zuwa lya kwesela ndo zuwa lya tisa lya mwezi awo kwaluchila matinazo mbaka matinazo zuwa lya kumi.” ");
INSERT INTO vid_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","Mkulu Nguluwi nakamlonjela Musa, ");
INSERT INTO vid_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","“Walonjele Waisilaeli kota kwaluchila zuwa lya kumi na zihano lya mwezi awo wa saba, momditila Mkulu Nguluwi mnvina ya vibumuli kwa mhela wa mazuwa saba. Ayo ndo mnvina ya Mkulu Nguluwi. ");
INSERT INTO vid_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","Zuwa lya mwaluko lya mazuwa ago saba, mowa na nhing'hano yelile na mleche kukola mijito ja chila zuwa. ");
INSERT INTO vid_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","Kwa mhela wa mazuwa saba molavya nhambiko kwa Mkulu Nguluwi kwa chiluli. Zuwa lya nane mowa na nhing'hano yelile na kumlavila nhambiko Mkulu Nguluwi kwa chiluli. Nhing'hano ayo ndo yelile. Zuwa alyo mleche kukola mijito ja chila zuwa. ");
INSERT INTO vid_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","“Azo ndo mnvina za Mkulu Nguluwi ziwichigwe, ziwele mowikula kuwe na nhing'hano yelile ya Mkulu Nguluwi, nhambiko zilingulavigwa kwa chiluli na nhambiko ya kulakazwa na nhambiko za nyhule na nhambiko na nhambiko za cha kunwa, chila imwe na zuwa yake iwichigwe. ");
INSERT INTO vid_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","Nhambiko azo ndo hamwe na zila zomuwele ngumlavila Mkulu Nguluwi Zuwa lya Kwesela hamwe na ndolendole ya hemwe na hamwe na nhambiko ya kutawiza kilaha kwa hemwe na hamwe na nhambiko za hemwe za kunuwila zomlingumlavila Mkulu Nguluwi. ");
INSERT INTO vid_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","“Aho hombeta migunda ja hemwe modita mnvina ya Mkulu Nguluwi kwa mhela wa mazuwa saba, kwaluchila zuwa lya kumi na zihano lya mwezi wa saba. Zuwa lya mwaluko lyowa Zuwa lya Kwesela na kahi zuwa lya nane. ");
INSERT INTO vid_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","Kuli zuwa lya mwaluko mohola mafuza ga igodi linojile na nhagala za mitende na nhagala ziwele na mahamba menji na nhagala za migodi jilingota hafungo ha lwanda, na hemwe modita mnvina hali Mkulu Nguluwi, Nguluwi wa hemwe kwa mazuwa saba. ");
INSERT INTO vid_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","Chila mwaka yangulapigwa kuwe na mnvina ayi kwa mhela wa mazuwa saba kwa Mkulu Nguluwi. Ali ndo ilajizo lya kuwinza mazuwa gose kuli lulelo lwa hemwe. Modita ahi kuli mwezi wa saba. ");
INSERT INTO vid_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","Kwa mhela wa mazuwa saba mochikala kuli vibumuli. Waisilaeli weng'ha wochikala kuli vibumuli mhela awo. ");
INSERT INTO vid_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","Mbuli ayo yoluzelesa lulelo lwenu kota vyondiwalavile wanhu wa Isilaeli kuli isi ya Misili, nandiwadita wekale kuli vibumuli. Heni ndo Mkulu Nguluwi, Nguluwi wa hemwe.” ");
INSERT INTO vid_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","Musa nakawalonjela Waisilaeli mnvina za Mkulu Nguluwi ziwichigwe. ");
INSERT INTO vid_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","Mkulu Nguluwi nakamlonjela Musa, ");
INSERT INTO vid_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","“Walajize wanhu wa Isilaeli wakigalile mafuta ganojile ga mzeituni kwa chiwalo cha chenje leka chenje acho chilutilile kwaka chila mhela. ");
INSERT INTO vid_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","Aluni kowika chenje acho mgati mwa alyo ihema lya Nguluwi, kunze kwa ipaziya lya isanduku lya ilagano leka chiwe chikwaka kwaluchila matinazo mbaka mitondo hali Mkulu Nguluwi chila mhela. Ali ndo ilajizo lya kuliwinza mazuwa gose kuli lulelo lwa hemwe. ");
INSERT INTO vid_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","Kowika avyo vyenje kuli chinhu cha kuwichila vyenje cha zahabu inojile, viwe vikwaka chila mhela hali Mkulu Nguluwi. ");
INSERT INTO vid_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","“Uhole utimbo unojile kilo makumi meli na gane na kuteleka mibumunda kumi na mili. ");
INSERT INTO vid_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","Mibumunda ajo jowichigwa hali msitali wa keli mchanya mwa chisaga cha zahabu inojile hali Mkulu Nguluwi, chila msitali mibumunda sita. ");
INSERT INTO vid_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","Chila msitali kowika ubani, leka kuwe kukumbuchila kwa mibumunda ajo, nhambiko ya kumlavila Mkulu Nguluwi kwa chiluli. ");
INSERT INTO vid_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","Chila Zuwa lya Kwesela Aluni koiwika goya kuli honhu hali Mkulu Nguluwi kwa chiwalo cha wanhu wa Isilaeli kota ilagano lya mazuwa gose. ");
INSERT INTO vid_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","Aluni na walelwa wa heye weng'ha waliyeng'ha ndo wangukundigwa kulya mibumunda ajo. Wolya kuli honhu hanji helile kwa vila ajo ndo jelile ng'hatu kuli nhambiko zilingulavigwa kwa Mkulu Nguluwi kwa chiluli. Ayi ndo hachi kwa hewo mazuwa gose.” ");
INSERT INTO vid_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","Zuwa limwe nakulawila kilewa ako kuli kambi hali Muisilaeli yumwe na msongolo yumwe wa mamo Muisilaeli yalinguchemigwa Shelemoti, ila mhaza nayali Mmisili. ");
INSERT INTO vid_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","Hamba yula msongolo Muisilaeli yawele mayake nakachemigwa Shelemoti, mhinza wa Dibuli wa nhanzi ya Dani, nakalibeza na kulipanjila itagwa lya Nguluwi. Lelo wanhu nawamhilika msongolo kwa Musa, ");
INSERT INTO vid_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","nawamibata mbaka aho hoyogubulilwa vyoyalingugana Mkulu Nguluwi. ");
INSERT INTO vid_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","Hamba, Mkulu Nguluwi nakamlonjela Musa, ");
INSERT INTO vid_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","“Mumlavye kunze mwa kambi ayo msongolo yapanjile, na wala weng'ha wamhuliche yopanjila wawiche moko ga hewo mchanya mwa mutwi wa heye, na Waisilaeli weng'ha wamkopole kwa kumtowa kwa maganga. ");
INSERT INTO vid_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","Nagwe uwalonjele Waisilaeli kota munhu yoneche yompanjila Nguluwi wa heye yanguganigwa yagazigwe kwa chiwalo cha gehile ga heye. ");
INSERT INTO vid_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","Munhu yoneche yawe mwenyeng'haye ama mjenzi yawele ngulibeza itagwa lya Mkulu Nguluwi, Waisilaeli weng'ha womkopola kwa kumtowa kwa maganga. ");
INSERT INTO vid_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","Munhu yoneche yalingumkopola munhu yunji, yangumlapa na heye yakopoligwe. ");
INSERT INTO vid_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","Munhu yoneche yalingulikopola igongolo yangumlapa yahilule chinhu kwa chiwalo cha kukopola ako, ukomu kwa ukomu. ");
INSERT INTO vid_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","Munhu yoneche yomlumiza munhu wa habehi na heye, yangumlapa na heye yalumizwe kota vyoyamlumize munhu wa habehi na heye, ");
INSERT INTO vid_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","wone nakambena izeje miyage, na heye kobenigwa izeje na iziho kwa iziho na izino kwa izino. Chila munhu yomlumiza miyage yangumlapa na heye yalumizwe kota vyoyaditile heye. ");
INSERT INTO vid_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","Yawele yolikopola igongolo yomlapa yahilule chinhu, ila munhu yoneche yomkopola miyage, yomlapa na heye yakopoligwe. ");
INSERT INTO vid_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","Utaguso awu weng'ha wanguganigwa kuwinzigwa na wanhu weng'ha, mjenzi ama mwenyeng'haye. Heni ndo Mkulu Nguluwi, Nguluwi wa hemwe.” ");
INSERT INTO vid_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","Lelo Musa nakawalonjela Waisilaeli ago geng'ha. Nawamuhilika yula munhu yampanjile Mkulu Nguluwi kunze mwa kambi, nawamkopola kwa kumtowa kwa maganga. Ahyo ndo Waisilaeli vyowaditile kota Mkulu Nguluwi vyoyamlajize Musa. ");
INSERT INTO vid_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","Mkulu Nguluwi nakamlonjela Musa ako kuli chidunda cha Sinai, ");
INSERT INTO vid_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","“Walonjele Waisilaeli kota homkwinjila kuli isi yondiwapele heni Mkulu Nguluwi, chila mwaka wa saba isi yokwesezwa ileche kulimigwa kwa chiwalo cha Mkulu Nguluwi. ");
INSERT INTO vid_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","Kwa mhela wa miyaka sita molima migunda na mohalila mizabibu ja hemwe na kubeta vilyo vya hemwe. ");
INSERT INTO vid_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","Ila mwaka wa saba wowa ndo mwaka wa kwesela kwa isi, ndo mwaka wa kwesela kwa Mkulu Nguluwi. Mleche kunyala choneche na kuhalila mizabibu ja hemwe. ");
INSERT INTO vid_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","Choneche chikota chiliyeka mleche kuchibeta ne kubawa zabibu kulawa kuli mizabibu johajidahulilwe. Awo wowa ndo mwaka wa kweseza migunda. ");
INSERT INTO vid_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","Ahyo mhela awo wa kwesela kwa isi wokupani chilyo hemwe na vitumagwa wa hemwe walume na wadala na wakolamijito na wajenzi walingikala hali hemwe. ");
INSERT INTO vid_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","Isi yojipa chilyo migongolo ja hemwe na migongolo ja kisolo jiwelengikala hali hemwe. ");
INSERT INTO vid_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","“Mowaliza miyaka saba mala saba na jeng'ha ndo miyaka makumi gane na tisa. ");
INSERT INTO vid_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","Hamba, kuli zuwa lya kumi lya mwezi wa saba, liwele ndo Zuwa lya Uhanyisi, momlajiza munhu kupemba mhalamhanda kuli isi yeng'ha. ");
INSERT INTO vid_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","Mwaka wa makumi gahano moudita uwe wa chiuyeng'ha kwa kuwikula kilejeha kwa wapogozi weng'ha muisi. Mwaka awo wowa wa kukumbuchila kwa miyaka makumi gahano. Chila yumwe wa hemwe kohiluka hali honhu ha heye ha isi na chila yumwe kohiluka kuli lukolo lwa heye. ");
INSERT INTO vid_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","Kwa vila mwaka awo ndo wa kukumbuchila kwa miyaka makumi gahano, mleche kunyala nyhadikwa ama kubeta choneche chilingota chiliyeka ne kubawa zabibu kulawa mizabibu johamdahulile. ");
INSERT INTO vid_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","Mwaka awo ndo wa mhela wa kukumbuchila miyaka makumi gahano kwa hemwe, wowa mwaka welile. Ahyo molya gala galingota galiyeka kumgunda. ");
INSERT INTO vid_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","“Kuli mwaka awo, chila munhu kohiluka kuli honhu ha heye ha isi. ");
INSERT INTO vid_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","Uleche kubunza hougula ama kuguza mgunda kwa munhu wa habehi. ");
INSERT INTO vid_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","Bei ya mgunda yolapa iwichigwe kwa kiwhana na miyaka jiwele isi ing'hali kulavya mbena, kung'hali fika kuli mhela wa kukumbuchila miyaka makumi gahano. ");
INSERT INTO vid_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","Wone miyaka jilingulapigwa ndo minji kokonjeza bei na wone miyaka ajo ndo mido kopungula bei, kwa vila bei ya heye yopimigwa kuli mbena zoyalingukuguzila. ");
INSERT INTO vid_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","Mleche kibunza mwemwe baho, ila mumdumbe Nguluwi wa hemwe. Heni ndo Mkulu Nguluwi, Nguluwi wa hemwe. ");
INSERT INTO vid_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","“Muwinze malajizo na utaguso wa heni, leka mlutilile kikala kwa kikala goya kuli isi. ");
INSERT INTO vid_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","Isi yolavya vilyo na hemwe molya na kiguta na kikala goya amo muisi. ");
INSERT INTO vid_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","Ila hanji mouza, ‘Tolya choni kuli mwaka wa saba, wone hambe tukundizwe kunyala ama kubeta vilyo vya hetwe?’ ");
INSERT INTO vid_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","Heni ndoitambichiza isi kuli mwaka wa sita na ayo yowapani hemwe chilyo cha kuhega kwa miyaka jidatu. ");
INSERT INTO vid_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","Homnyala kuli mwaka wa nane, mowa mulya chilyo cha katali na molutilila kulya hela mbaka mwaka wa tisa homkwaluka kahi kubeta. ");
INSERT INTO vid_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","“Isi ileche kuguzigwa kwa mazuwa gose, kwa vila ayo ndo lufufu lwa Nguluwi, na hemwe ndo mwa wajenzi na mli mmajendo muisi ya heni. ");
INSERT INTO vid_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","Ndo mina mowa na mumhu ya kuigombola isi, kuli isi ya hemwe yeng'ha. ");
INSERT INTO vid_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","“Wone mng'holozo yawe mzunwa, nakaguza mgunda wa heye, lelo mng'holozo wa habehi yawele na mijito ja kuigombola, koigombola. ");
INSERT INTO vid_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","Wone munhu ayo kahela mng'holoze yawele na mijito ja kuigombola, ila hamba kawa na lufufu na kuwa na ludali lwa kuugombola mgunda wa heye, ");
INSERT INTO vid_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","lelo kowaliza miyaka jilinguganigwa kwaluchila hoyaguzile na kuhilusa sendi za heye, na yula munhu yaugulile mgunda awo ndo yangumlapa yamuhilusile. ");
INSERT INTO vid_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","Ila wone yawe hela lufufu lwa kuhega kuugombola, lelo wopona mmoko mwa yula yaugulile mbaka mwaka wa kukumbuchila kwa miyaka makumi gahano. Kuli mwaka awo, ndo yangulapigwa mgunda awo ulechigwe na kuhilusilwa yula munhu yauguzile. ");
INSERT INTO vid_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","“Ila wone munhu yaguze ng'handa ya heye ya kikala iwele mgati mwa muji uzenjigwe lukanzi, koweza kuigombola kwa mhela wa mwaka umwe kwaluchila hoyaiguzile. Kwa mwaka awo weng'ha kowa na hachi ya kuigombola. ");
INSERT INTO vid_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","Wone ng'handa iwele kuli muji uzenjigwe lukanzi haigomboligwe kwa mhela wa mwaka umwe, lelo yowa ya yula yagulile mazuwa gose kuli ivyazi lya hewo lyeng'ha, na hoihilula ng'oo kuli mwaka wa kukumbuchila miyaka makumi gahano. ");
INSERT INTO vid_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","Ila ng'handa za vijiji viwele havizungulusilwe lukanzi, zowalizwa hamwe na migunda ja isi, ng'handa azo zoweza kugomboligwa ila yanguganigwa zihiluswe kwa yuye kuli mwaka wa kukumbuchila miyaka makumi gahano. ");
INSERT INTO vid_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","Ahyo ng'handa ziwele kuli miji jowawelenajo Walawi, Walawi woweza kuzigombola mhela woneche. ");
INSERT INTO vid_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","Wone yumwe wa Walawi hambe yadite hachi ya heye ya kugombola, lelo ng'handa iguzigwe ndo yanguganigwa ihiluswe kwa yuye kuli mwaka wa kukumbuchila miyaka makumi gahano, kwa vila ng'handa ziwele kuli muji wawelengikala Walawi nawapegwa kota honhu hawo kulawila kwa wanhu wa Isilaeli. ");
INSERT INTO vid_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","Ila migunda ja miji jowawelenajo hewo Walawi kwa hamwe, jileche kuguzigwa, kwa vila ajo migunda ndo uhalizi wa hewo Walawi mazuwa gose.” ");
INSERT INTO vid_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","“Wone mng'holozo kawa mzunwa na hambe yaweze kilolela yuye yawele hamwe na hegwe, yanguganigwa umlolele na yalutilile kikala na hegwe, umditile kota mjenzi ama munhu yawele mmajendo yawele kwa hegwe. ");
INSERT INTO vid_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","Uleche kugana yakuhilusile nyonjeza. Ila umdumbe Nguluwi, leka heye mng'holozo yekale hamwe na hegwe. ");
INSERT INTO vid_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","Uleche kumwazika sendi leka yakuhilusile na nyonjeza ama kumha chilyo leka yakonjeze mzidi. ");
INSERT INTO vid_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","Heni ndo Mkulu Nguluwi, Nguluwi wa hegwe, ndikulavile kuli isi ya Misili, leka ndikupe isi ya Kanaani, leka ndiwe Nguluwi wa hegwe. ");
INSERT INTO vid_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","“Wone mng'holozo yalingikala habehi na hegwe nakawa mzunwa, wone yeguze kwa hegwe, uleche kumdita yakukolele mijito kota mpogozi. ");
INSERT INTO vid_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","Kochikala na hegwe kota chitumagwa yalingukola mijito ama kota mjenzi. Kokukolela mijito mbaka mwaka wa kukumbuchila miyaka makumi gahano. ");
INSERT INTO vid_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","Mwaka awo yanguganigwa yawe yelejehe yahiluche na wana wa heye na honhu ha uhalizi wa wasekulu wa heye. ");
INSERT INTO vid_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","Kwa vila Waisilaeli ndo vitumagwa wa heni nandiwalavile kuli isi ya Misili, lelo waleche kuguzigwa kota wapogozi. ");
INSERT INTO vid_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","Uleche kumlongoza mng'holozo kwa kung'ang'ala, leka umdumbe Nguluwi wa hegwe. ");
INSERT INTO vid_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","Ila kwa chiwalo cha wapogozi wadala na walume, moweza kuwagula kulawa kwa wanhu wa isi iyage ya habehi. ");
INSERT INTO vid_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","Moweza kahi kugula wapogozi kulawa kwa wajenzi walingikala hamwe na hemwe na wanhu wa hewo wapondigwe muisi ya hemwe, na hewo wowa wapogozi wa hemwe. ");
INSERT INTO vid_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","Awo wapogozi moweza kuwahilika kwa wana leka wawe uhalizi wa hewo na lufufu lwa hewo mazuwa gose. Awo moweza kuwadita wawe wapogozi wa hemwe, ila ayo mng'holozo Muisilaeli, mleche kumlongoza kwa kung'ang'ala. ");
INSERT INTO vid_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","“Wone mjenzi ama munhu yawele mmajendo yawelengikala hali hemwe nakawa na lufufu, na mng'holozo nakawa mzunwa na kiguza yuye kwa ayo mjenzi ama ayo munhu yawele mmajendo ama kwa yumwe wa wanhu wa hewo, ");
INSERT INTO vid_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","koweza kugomboligwa loyeguzile, munhu yumwe wa wang'holozo koweza kumgombola. ");
INSERT INTO vid_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","Kolo wa heye koweza kumgombola, ama mwanage kolo ama mng'holoze wa habehi kuli lukolo lwa heye, koweza kahi kigombola heye yuye wone yapate lufufu. ");
INSERT INTO vid_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","Wone heye yawe hamwe na yula yagulile, kowaliza jila miyaka hoyeguzile mbaka mwaka wa kukumbuchila miyaka makumi gahano. Bei ya kugomboligwa kwa heye leka yawe yelejehe, yochiwhana na bei ya mijito ja miyaka jisigale. ");
INSERT INTO vid_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","Wone hisabu ya miyaka mbaka mwaka wa kukumbuchila kwa miyaka makumi gahano ndo ng'hulu, lelo kohilula chasi cha bei yoyalipilwe. ");
INSERT INTO vid_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","Wone miyaka mido jipungula kung'halifika kukumbuchila kwa miyaka makumi gahano, kowaliza chasi cha bei isigale kuli miyaka ajo na kumha ayo chasi acho. ");
INSERT INTO vid_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","Mhela weng'ha loyawele kwa mkulu wa heye ndo yanguganigwa yaditilwe kota chitumagwa wa msahala chila mwaka. Hamkundigwa kumditila kwa kung'ang'ala. ");
INSERT INTO vid_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","Ila wone munhu ayo hagomboligwe kwa nzila azo, lelo yapegwe kilejeha kwa heye na wana wa heye kuli mwaka wa kukumbuchila kwa miyaka makumi gahano. ");
INSERT INTO vid_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","Kwa vila Waisilaeli ndo vitumagwa wa heni, nandiwalavile kuli isi ya Misili. Heni ndo Mkulu Nguluwi, Nguluwi wa hemwe. ");
INSERT INTO vid_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","“Mleche kigongomanyila jimalukolo ja milungu ja udesi, mleche kwimiza jimalukolo ja hewo ja kuhongola ne izengo ne jimalukolo ja maganga gahongoligwe muisi ya hemwe na kujifugamila. Heni ndo Mkulu Nguluwi, Nguluwi wa hemwe. ");
INSERT INTO vid_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","Mibatilile Zuwa lya Kwesela lya heni na kuhadumba honhu ha heni helile. Heni ndo Mkulu Nguluwi. ");
INSERT INTO vid_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","“Wone muwinze malajizo ga heni na kibatilila utaguso wa heni na kugadita, ");
INSERT INTO vid_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","ndowatowela nhonya mhela unojile, leka isi ilele vilyo vinji, na migodi ja kuli migunda jolela mafuza gake. ");
INSERT INTO vid_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","Kubena vilyo kolutilila mbaka mhela wa kubawa zabibu na kubawa zabibu mbaka mhela wa kunyala nyhadikwa. Mowa na vilyo vinji na kikala goya muisi ya hemwe. ");
INSERT INTO vid_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","“Ndowaditani mikale goya muisi na muwe muwasile goya leka mleche kudumba choneche. Ndojusa migongolo jing'ang'ale kuli isi na isi ya hemwe haiwa na ngondo. ");
INSERT INTO vid_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","Mowawinga wang'honyo wa hemwe na kuwakopola kwa ipanga. ");
INSERT INTO vid_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","Wanhu wahano wa hemwe wowawinga wang'honyo miya imwe na miya imwe wa hemwe wowawinga wang'honyo elufu kumi. Wang'honyo wa hemwe wobagama hali hemwe kwa ipanga. ");
INSERT INTO vid_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","Ndowatambichizani na kuwadita muwe na wana wenji na konjezeka, nani ndolitawiza ilagano lya heni na hemwe. ");
INSERT INTO vid_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","Mhela wa kubena mowa mng'hali mulya vilyo vya katali, kahi yowalapa kusa visigale leka muwe na honhu ha kuwika vilyo vinyale. ");
INSERT INTO vid_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","Ndowika honhu ha kikala ha heni hali hemwe, na siwabeza hebu. ");
INSERT INTO vid_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","Ndojenda hali hemwe na ndowa Nguluwi wa hemwe na hemwe mowa wanhu wa heni. ");
INSERT INTO vid_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","Heni ndo Mkulu Nguluwi, Nguluwi wa hemwe, nandiwalavile kuli isi ya Misili leka mleche kuwa wapogozi wa Wamisili. Heni nandiwalavya kuli upogozi kuli isi ya Misili na kuwadita muwe milejehe. ");
INSERT INTO vid_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","“Ila wone hamnyulichiza na kuwinza malajizo gondajize, ");
INSERT INTO vid_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","na wone mleme malajizo ga heni na kuzudila utaguso wa heni mnhumbula, moleka kuhulichiza malanguso ga heni geng'ha na kubena ilagano lya heni, ");
INSERT INTO vid_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","lelo heni ndowasubula kwa kuwagalila kudumba ng'hatu kwa kutinusa na lugandaganda na utamwa wouwatosolani meho na kuwadita muwe ng'hochele. Monyala nyhadikwa za hemwe ne kubena chinhu kwa vila wang'honyo wa hemwe ndo wolya. ");
INSERT INTO vid_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","Heni ndowalema, namwe motoweka na wang'honyo wa hemwe, molongozwa na wala walinguwazudilani. Mokabuswa na kubilima na hanji kowa haduhu munhu yoneche yalinguwabilimisa. ");
INSERT INTO vid_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","Na wone iwe mgaziche ahyo, mng'hali hamnyulichiza hebu, lelo ndowapa magazo mala saba kwa chiwalo cha gehile ga hemwe. ");
INSERT INTO vid_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","Kidaya kwa hemwe ndokubena ng'hatu kwa kudita isi iwehela nhonya na isi ya hemwe iwe igagadale kota shaba. ");
INSERT INTO vid_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","Molavya mong'ho hela mina migunda jenu hajilavya vilyo na isi ya hemwe hailela mafuza hebu. ");
INSERT INTO vid_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","“Wone mlutilile kulema kunyhulichiza chondilajiza, ndokonjezela kahi magazo ga hemwe mala saba vyoilinguganigwa na winji wa gehile ga hemwe. ");
INSERT INTO vid_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","Ndojigala migongolo jing'ang'ale hali hemwe na jowanyasulilani wana wa hemwe na kulya migongolo ja hemwe, na kudumya winji wa hemwe na kuli nzila za hemwe zowa na uchiwa. ");
INSERT INTO vid_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","“Wone iwe mng'hali mlema kungalamchila heni, lelo mwangonjeza kitowa na heni, ");
INSERT INTO vid_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","lelo, nani ndokonjeza kitowa na hemwe na kuwatowani mala saba ng'hatu kwa chiwalo cha gehile ga hemwe. ");
INSERT INTO vid_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","Ndokugalilani ipanga liwele lya kuhilusa chibida chilingulapa ilagano lyombenile. Wone hemwe mobilimila kuli muji wa hemwe, ndowahilichila matamwa gehile na kuwawika mmoko wa wang'honyo wa hemwe. ");
INSERT INTO vid_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","Chilyo cha hemwe ndochipunguza na wadala kumi woteleka chiko chimwe hela. Wowagawila kwa chipimilo. Na vyomulya mowa hamigute hebu. ");
INSERT INTO vid_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","“Na wone galawile ago geng'ha, kuno mng'hali mlema kunyhulichiza na mlutilila kitowa na heni, ");
INSERT INTO vid_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","lelo heni ndochitowa na hemwe kwa kuzudila ng'hatu, na kuwatowa nene baha mala saba kwa chiwalo cha gehile ga hemwe. ");
INSERT INTO vid_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","Mowa na nzala ng'hatu, ahyo molya miwunde ja wana wa hemwe walume na wadala. ");
INSERT INTO vid_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","Ndohawifya honhu ha hemwe ha kusalila ako kuchidunda na kuhabomola honhu ha kulavila nhambiko ha hemwe ha kufunyizila ubani na kutaga mitufi ja hemwe mchanya mwa jimalukolo ja milungu ja hemwe. Nhumbula ya heni yowazudilani ng'hatu. ");
INSERT INTO vid_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","Muji wa hemwe ndoubomola na honhu ha hemwe ha kufugamila jimalukolo, ndohadita hawe na uchiwa na kunhunyhilila kunojile kwa nhambiko za hemwe sikukunda hebu. ");
INSERT INTO vid_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","Ndoidita isi ya hemwe iwe iwifigwe ng'hatu, mbaka wang'honyo walinguhamila amo wobubuwala. ");
INSERT INTO vid_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","Ndowasambalulani hemwe hali wanhu wa isi zimwenga na kusomola ipanga hali hemwe. Isi ya hemwe yowa ya uchiwa na miji ja hemwe jowa jiwifigwe. ");
INSERT INTO vid_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","“Vyomuwa kuli isi ya wang'honyo wa hemwe, aho ndo isi vyoisechelela kwesela mhela vyouwa hali uchiwa. Isi yokwesela na kusechelela. ");
INSERT INTO vid_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","Isi vyoiwa hali uchiwa yokwesela, kwesela ako kuwele hakunalawila kuli mwaka wa saba vyonamwali mchikala hala kuli isi yila. ");
INSERT INTO vid_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","Kuli wamwe wa hemwe wopona wakomu, ndowegalila kudumba mnhumbula za hewo, kuli isi ayi wang'honyo wa hewo. Ihamba liwembeluswa lyowadita wabilime. Wobilima kota munhu yalingubilima ngondo. Wobilima na kugwa kuno haduhu munhu yalinguwabilimisa. ");
INSERT INTO vid_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","Wochigwila vibi kota munhu yalingubilima ngondo kuno haduhu yalinguwabilimisa. Mowahela mong'ho wa kitowa na wang'honyo wa hemwe. ");
INSERT INTO vid_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","Mobagama hali wanhu na isi za wang'honyo wa hemwe, zowamela. ");
INSERT INTO vid_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","Wone wayenu wamwe wasigale kuli isi za wang'honyo wa hemwe, wowa ng'hochele na kumala kwa chiwalo cha gehile ga hewo na kwa chiwalo cha gehile ga wasekulu wa hewo. ");
INSERT INTO vid_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","“Ila wone walonje kwa milomo ja hewo gehile na gehile ga wasekulu wa hewo hali gehile gowaditile kwa heni na kuli kitowa kwa hewo na heni, ");
INSERT INTO vid_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","ahyo nanditowile na hewo na kuwahilika kuli isi ya wang'honyo wa hewo, wone iwe kukomya, nhumbula za hewo zigagadala wone wadedeze na kukunda kugazigwa kwa chiwalo cha gehile ga hewo, ");
INSERT INTO vid_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","lelo aho nani ndolikumbuchila ilagano lya heni na Abulahamu na Isaka na Yakobo, na kuikumbuchila yila isi. ");
INSERT INTO vid_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","Mhela vyowowa kunze kwa isi ya hewo, isi ayo yosechelela kwesela kwa hewo vyokuwa kuli uchiwa. Mhela awo hewo wa kukunda kugazigwa kwa chiwalo cha gehile ga hewo kwa vila nawalema kuhulichiza utaguso wa heni na kubeza malajizo ga heni. ");
INSERT INTO vid_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","Ila, hamwe na ago geng'ha, lowowa kuli isi ya wang'honyo wa hewo, heni siwaleka hebu ne kuwazudila ne kuwakopola ng'hatu ne kuleka lila ilagano lya heni, Mkulu Nguluwi, Nguluwi wa hewo. ");
INSERT INTO vid_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","Ila kwa chiwalo cha hewo ndokumbuchila ilagano lyonditile na wasekulu wa hewo na londiwalavile kuli isi ya Misili, kuno isi zeng'ha zilolela, leka heni ndiwe Nguluwi wa hewo. Heni nda Mkulu Nguluwi.” ");
INSERT INTO vid_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","Aga ndo malajizo na mizilo na utaguso gawele Mkulu Nguluwi nakamha wanhu wa Isilaeli kula kuchidunda cha Sinai kwa kukolela Musa. ");
INSERT INTO vid_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","Mkulu Nguluwi nakamlonjela Musa, ");
INSERT INTO vid_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","“Walonjele Waisilaeli kota wone munhu yawiche chilaho cha kumlavila munhu Mkulu Nguluwi, munhu ayo koweza kusa chilaho cha heye kwa kulipiza chasi cha sendi zoziganigwe kota ahi. ");
INSERT INTO vid_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","Mlume yawele na miyaka makumi meli mbaka miyaka makumi sita kogomboligwa kwa sendi migwala makumi gahano kwa kuwinza chipimilo cha ihema lya Nguluwi. ");
INSERT INTO vid_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","Wone yawe mdala, kogomboligwa kwa sendi migwala makumi gadatu. ");
INSERT INTO vid_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","Wone munhu ayo yawe wa miyaka jihano mbaka miyaka makumi meli kogomboligwa kwa sendi migwala makumi meli wone yawe mlume na migwala kumi ja sendi wone yawe mdala. ");
INSERT INTO vid_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","Wone yawe mwana wa mwezi umwe mbaka miyaka jihano, kogomboligwa kwa sendi migwala jihano ja sendi wone yawe mlume na migwala jidatu ja sendi wone yawe mdala. ");
INSERT INTO vid_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","Wone munhu ayu kana miyaka makumi sita na mzidi, kogomboligwa kwa sendi migwala kumi na jihano ja sendi wone yawe mlume na migwala kumi ja sendi wone yawe mdala. ");
INSERT INTO vid_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","Ila wone iwe munhu ayo ndo mzunwa na hambe yaweze kuhilusa sendi za heye zoyawele ngudaigwa, lelo munhu ayo kohilikwa kwa mtambika. Mtambika komlola goya na kwamula chasi cha sendi choyalinguganigwa kulavya kuli ludali lwa heye lwa kilaha. ");
INSERT INTO vid_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","“Wone kilaha kwa heye kwangulapa igongolo liwele wanhu humlavila Mkulu Nguluwi nhambiko, lelo chila nhambiko kota igongolo alyo, yowa chinhu chelile. ");
INSERT INTO vid_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","Hambe ikundigwe kuligalula igongolo alyo kwa yunji yoneche yula, yanojile kwa yehile ama yehile kwa yanojile. Wone yagalule kwa igongolo liyage, jeng'ha mili jowa jelile. ");
INSERT INTO vid_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","“Wone choyelahile acho changulapa igongolo likokomoche, liwele hambe liwe lya kumlavila Mkulu Nguluwi, lelo munhu yalilavile, koligala kwa mtambika, ");
INSERT INTO vid_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","na heye mtambika kolonga chasi cha sendi ya heye kota vyoiwele kunoga ama kwiha kwa heye. Ndo vyoiwa yuye mtambika vyoyolonga. ");
INSERT INTO vid_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","Ila wone iwe yuye yogana kugombola, lelo kokonjeza chasi cha sendi honhu ha kahano ha bei ya igongolo alyo. ");
INSERT INTO vid_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","“Wone munhu yaiwiche ng'handa ya heye iwe ya chiuyeng'ha kwa Mkulu Nguluwi, mtambika kolonga bei ya heye kota vyoiwele kunoga ama kwiha kwa heye. Ndo vyoiwa yuye mtambika vyoyolonga. ");
INSERT INTO vid_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","Wone ayo munhu yaiwichile chiuyeng'ha, yagane kugombola ayo ng'handa, lelo kokonjeza honhu ha kahano ha chasi cha sendi za heye, na alo lowa lufufu lwa heye. ");
INSERT INTO vid_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","“Wone munhu yauwiche chiuyeng'ha mgunda wa heye kwa Mkulu Nguluwi, lelo sendi za heye zopimigwa kota nyhadikwa zila zinyaligwe kuli mgunda awo, kwa chila kilo makumi meli ga shayili, sendi ya ayo yowa migwala kumi. ");
INSERT INTO vid_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","Wone yaudite mgunda wa heye uwe wa chiuyeng'ha kuli mwaka wa mnvina ya kukumbuchila miyaka makumi gahano, bei yake yanguganigwa iwe iwhanile na chipimilo cha hemwe chenele. ");
INSERT INTO vid_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","Ila wone yauwiche uwe wa chiuyeng'ha, hamba houpuluta mwaka awo, lelo mtambika kolonga bei ya awo mgunda kota vyoiwele miyaka jisigale kufichila mwaka wa mnvina ya kukumbuchila kwa miyaka makumi gahano na bei ya heye ipunguzigwe. ");
INSERT INTO vid_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","Wone gwegwe ugana kugombola, lelo ndo yomlapa yonjezele chasi cha honhu ha kahano ha sendi ya awo mgunda, na hamba lowa lufufu lwa heye. ");
INSERT INTO vid_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","Ila wone yolema kugombola na kuguzigwa kwa munhu yunji, lelo mgunda awo uleche kugomboligwa kahi. ");
INSERT INTO vid_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","Kuli mwaka wa mnvina ya kukumbuchila kwa miyaka makumi gahano, mgunda awo wolechelwa leka uwe wa Mkulu Nguluwi mazuwa gose. Wowa wa watambika. ");
INSERT INTO vid_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","“Wone munhu nakaulavya kwa Mkulu Nguluwi mgunda woyagulile, mina hauwele wa heye kwa uhalizi, ");
INSERT INTO vid_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","mtambika kolonga bei ya mgunda awo kota vila vyoiwele miyaka jisigale kafichila mwaka wa mnvina ya kukumbuchila kwa miyaka makumi gahano na munhu ayo kolonjelwa yalavye chasi cha sendi kota ndo chinhu chelile kwa Mkulu Nguluwi. ");
INSERT INTO vid_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","Ila kuli mwaka wa mnvina ya kukumbuchila kwa miyaka makumi gahano, mgunda awo ndo yanguganigwa uhilulwe kwa yauguzile ama kwa walelwa wa hewo. ");
INSERT INTO vid_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","Chila chasi cha sendi chopimigwa kwa chipimilo cha ihema lya Nguluwi, chiwele ngugawigwa kuli vihande makumi meli. ");
INSERT INTO vid_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","“Lileleche mwaluko kwa migongolo, lyowa lya Mkulu Nguluwi, homuwika munhu yoneche yawe wa chiuyeng'ha, liwe isenga ama ing'holo, alyo ndo lya Mkulu Nguluwi. ");
INSERT INTO vid_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","Wone ndo igongolo likokomoche, lilyo koligula kwa kulawila kuli chipimilo na kokonjeza honhu ha kahano ha sendi za igongolo alyo. Wone haligomboligwe, lelo lyoguzigwa kuli chipimilo cha hemwe chenele. ");
INSERT INTO vid_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","“Ila chinhu choneche chiwichigwe chiwe cha chiuyeng'ha kwa Mkulu Nguluwi, chiwe ndo munhu ama igongolo ama chinhu choupegwe kwa kuhalila, hachiguzigwa ne kugomboligwa hebu. Choneche chiwichigwe chiwe chiuyeng'ha kwa Mkulu Nguluwi ndo chelile ng'hatu. ");
INSERT INTO vid_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","Munhu yoneche yawichigwe yawe wa chiuyeng'ha kwa kukopoligwa, yaleche kugomboligwa, yanguganigwa yabagame. ");
INSERT INTO vid_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","“Honhu ha kumi ha mbena hawe nyhule ama mafuza ga igodi, geng'ha ndo lufufu lwa Mkulu Nguluwi, ndo vyelile kwa Mkulu Nguluwi. ");
INSERT INTO vid_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","Wone munhu yogana kuhagombola honhu ha kumi ha heye, kolipa sendi ya heye na konjeza honhu ha kahano ha sendi. ");
INSERT INTO vid_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","Na ndolendole yoneche ya isenga ama ya ing'holo, chila lilingukola hasi ha ng'hweku, honhu ha kumi ndo helile kwa Mkulu Nguluwi. ");
INSERT INTO vid_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","Munhu yoneche yohambe yakundizwe kuuza kota igongolo alyo ndo linoga ama liha na igongolo alyo haligalamulwa hebu kwa linji. Wone ligalamulwe kwa linji, migongolo jeng'ha mili jowa jelile, hajigomboligwa.” ");
INSERT INTO vid_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","Ago ndo malajizo gawele Mkulu Nguluwi nayamlajize Musa yawalonjele Waisilaeli, kuchidunda cha Sinai.");
INSERT INTO vid_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","Nalyali zuwa lya mwaluko lya mwezi wa keli, mwaka wa keli kuli wanhu wa Isilaeli kulawila Misili, Mkulu Nguluwi nakalonga na Musa mgati mwa ihema lya Nguluwi kuchiwala ako Sinai, nakamlonjela ahi, ");
INSERT INTO vid_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","“Hegwe na Aluni muwawaze Waisilaeli weng'ha, ivyazi limwe mbaka liyage kwa kuwinza lukolo lwa hewo kota vyogali matagwa gawo chila mlume yumwe mbaka yunji, ");
INSERT INTO vid_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","wala weng'ha kuli Isilaeli walinguweza kuluta kuza kitowa ngondo, wawele na miyaka kwaluchila makumi meli na mzidi, hegwe na Aluni mowawika kuli kuwazigwa kwa vilundo vilundo. ");
INSERT INTO vid_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","Kahi mlume yumwe wa chila nhanzi kowa hamwe na hemwe, chila yumwe yawele chilongozi wa ivyazi lya heye. ");
INSERT INTO vid_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","Ayi ndo mbuli ya matagwa ga walume walingukutanza, “kwa nhanzi ya Lubeni, Elisuli mwana wa Shedeuli, ");
INSERT INTO vid_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","kwa nhanzi ya Simeoni, Shelumieli mwana wa Suli-shadai, ");
INSERT INTO vid_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","kwa nhanzi ya Yuda, Nashoni mwana wa Aminadabu, ");
INSERT INTO vid_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","kwa nhanzi ya Isakali, Netaneli mwana wa Suali, ");
INSERT INTO vid_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","kwa nhanzi ya Sebuluni, Eliabu mwana wa Heloni, ");
INSERT INTO vid_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","kuli wana wa Yusufu, kwa nhanzi ya Efulaimu, Elishama mwana wa Amihudi, kwa nhanzi ya Manase, Gamalieli mwana wa Pedasuli, ");
INSERT INTO vid_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","kwa nhanzi ya Benjamini, Abidani mwana wa Gideoni, ");
INSERT INTO vid_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","kwa nhanzi ya Dani, Ahieseli mwana wa Amishadai, ");
INSERT INTO vid_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","kwa nhanzi ya Asheli, Pagieli mwana wa Okilani, ");
INSERT INTO vid_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","kwa nhanzi ya Gadi, Eliasafu mwana wa Deueli, ");
INSERT INTO vid_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","kwa nhanzi ya Nafutali, Ahila mwana wa Enani.” ");
INSERT INTO vid_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","Awa ndo vilongozi wahaguligwe kulawa kuli Waisilaeli weng'ha, kota vilongozi wakulu wa nhanzi ya hewo na vilongozi wa ng'holo za Isilaeli. ");
INSERT INTO vid_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","Lelo Musa na Aluni nawawahola vilongozi awo wachemigwe matagwa ga hewo, ");
INSERT INTO vid_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","na kwaluchila zuwa lya mwaluko lya mwezi wa keli, nawawakungajiza Waisilaeli weng'ha walume wawele wawazigwe chila yumwe kulawa ivyazi lya heye na lukolo lwa heye. Kwa kuwinza matagwa ga walume wawele na miyaka makumi meli na mzidi wawazigwe yumwe yumwe, ");
INSERT INTO vid_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","kota Mkulu Nguluwi vyoyamlajize Musa. Musa kawawaliza walume awo kula kuchiwala ako Sinai. ");
INSERT INTO vid_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","Walume walawile kuli nhanzi ya Lubeni, yawele yavumbuche wa mwaluko kwa Isilaeli, kwa kuwinza vyowavumbuche hewo, kulawa ng'holo za hewo na kulawa ivyazi lya hewo, kwa kuwinza matagwa ga hewo yumwe yumwe, chila mlume yawele na miyaka makumi meli na mzidi, yoweza kwinjila kuli kitowa ngondo, ");
INSERT INTO vid_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","nawali walume makumi gane na sita elufu na miya zihano (46,500). ");
INSERT INTO vid_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","Kulawa nhanzi ya Simeoni kwa kuwinza vyowavumbuche hewo kuli ng'holo za hewo na kulawa kuli ivyazi lya hewo kuli winji wa matagwa gawo yumwe yumwe, chila mlume yawele na miyaka makumi meli na mzidi, yalinguweza kuza kitowa ngondo, ");
INSERT INTO vid_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","nawali walume makumi gahano na tisa elufu na miya zidatu (59,300). ");
INSERT INTO vid_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","Kulawila kuli nhanzi ya Gadi kwa kuwinza vyowavumbuche hewo kuli ng'holo za hewo na kuli ivyazi lya hewo na kuli winji wa matagwa ga hewo, wawele na miyaka makumi meli na mzidi, walinguweza kuza kitowa ngondo, ");
INSERT INTO vid_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","nawali walume makumi gane na gahano elufu miya sita na makumi gahano (45,650). ");
INSERT INTO vid_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","Kulawila kuli nhanzi ya Yuda kwa kuwinza vyowavumbuche kuli ng'holo za hewo na kuli ivyazi lya hewo kuli winji wa matagwa ga hewo, wawele na miyaka makumi meli na mzidi, walinguweza kwinjila kuli kitowa ngondo, ");
INSERT INTO vid_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","nawali wanhu makumi saba na gane elufu na miya sita (74,600). ");
INSERT INTO vid_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","Kulawila kuli nhanzi ya Isakali kwa kuwinza vyowavumbuche hewo kuli ng'holo za hewo na kuli ivyazi lya hewo kuli winji wa matagwa ga hewo, wawele na miyaka makumi meli na mzidi, walinguweza kuza kitowa ngondo, ");
INSERT INTO vid_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","nawali wanhu makumi gahano na gane elufu na miya zine (54,400). ");
INSERT INTO vid_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","Kulawila nhanzi ya Sebuluni kwa kuwinza vyowavumbuche hewo kuli ng'holo za hewo na kuli ivyazi lya hewo kuli winji wa matagwa ga hewo, wawele na miyaka makumi meli na mzidi, walinguweza kuza kitowa ngondo, ");
INSERT INTO vid_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","nawali wanhu makumi gahano na saba elufu na miya zine (57,400). ");
INSERT INTO vid_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","Kulawila nhanzi ya Efulaimu, mwanage Yusufu, kwa kuwinza vyowavumbuche kuli ng'holo za hewo na kuli ivyazi lya hewo kuli winji wa matagwa ga hewo, wawele na miyaka makumi meli na mzidi, walinguweza kuza kitowa ngondo, ");
INSERT INTO vid_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","nawali wanhu makumi gane elufu na miya zihano (40,500). ");
INSERT INTO vid_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","Kulawila kuli nhanzi ya Manase, mwanage Yusufu, kwa kuwinza vyowavumbuche kuli ng'holo za hewo na kuli ivyazi lya hewo kuli winji wa matagwa ga hewo, wawele na miyaka makumi meli na mzidi walinguweza kuza kitowa ngondo, ");
INSERT INTO vid_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","nawali wanhu makumi gadatu na meli elufu na miya mbili (32,200). ");
INSERT INTO vid_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","Kulawila kuli nhanzi ya Benjamini, kwa kuwinza vyowavumbuche kuli ng'holo za hewo na kuli ivyazi lya hewo kuli winji wa matagwa ga hewo, wawele na miyaka makumi meli na mzidi, walinguweza kuza kitowa ngondo, ");
INSERT INTO vid_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","nawali walume elufu makumi gadatu na gahano na miya zine (35,400). ");
INSERT INTO vid_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","Kulawila nhanzi ya Dani kwa kuwinza kota vyowavumbuche kuli ng'holo za hewo na kuli ivyazi lya hewo kwa kuwinza winji wa matagwa ga hewo, wawele na miyaka makumi meli na mzidi, walinguweza kuza kitowa ngondo, ");
INSERT INTO vid_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","nawali walume elufu makumi sita na meli na miya saba (62,700). ");
INSERT INTO vid_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","Kulawa nhanzi ya Asheli, kwa kuwinza kota vyowavumbuche kuli ng'holo za hewo na kuli ivyazi lya hewo kwa winji wa matagwa ga hewo, wawele na miyaka makumi meli na mzidi, walinguweza kuza kitowa ngondo, ");
INSERT INTO vid_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","nawali walume elufu makumi gane na yumwe na miya zihano (41,500). ");
INSERT INTO vid_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","Kulawila nhanzi ya Nafutali, kwa kuwinza kota vyowavumbuche kuli ng'holo za hewo na kuli ivyazi lya hewo kwa winji wa matagwa ga hewo, wawele na miyaka makumi meli na mzidi, walinguweza kuza kitowa ngondo, ");
INSERT INTO vid_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","nawali walume elufu makumi gahano na gadatu na miya zine (53,400). ");
INSERT INTO vid_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","Awa ndo walume wawele wawazigwe na Musa na Aluni hamwe na utanzi wa wala vilongozi kumi na weli wa Isilaeli, chila chilongozi yalawile honhu ha lukolo lwa heye. ");
INSERT INTO vid_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","Awo ndo walume weng'ha wa Isilaeli kuwinza ivyazi lya hewo wawele na miyaka makumi meli na mzidi, walinguweza kuza kitowa ngondo kuli isi ya Isilaeli, ");
INSERT INTO vid_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","nawali walume lachi sita na elufu zidatu na miya zihano na makumi gahano (603,550). ");
INSERT INTO vid_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","Ila Walawi hawawazigwe hamwe na zila nhanzi ziyage, ");
INSERT INTO vid_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","kwa vila Mkulu Nguluwi nakamlonjela Musa, ");
INSERT INTO vid_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","“Uleche nhanzi ya Walawi na uleche kuwawaza hali wanhu wa Isilaeli, ");
INSERT INTO vid_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","ila kowabagula wawe wololela ihema lya Nguluwi lya ulolezi, vinhu vyake vyeng'ha na chila chinhu chiwele amo mgati mwake. Wowa wolipika hamwe na vinhu vyake vyeng'ha. Wokola mijito mumo mgati na kuwika kambi kwa kuzunguluta. ");
INSERT INTO vid_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","Kahi mhela wa ihema kung'humbuligwa Walawi na ndo wong'humbula na mhela wa ihema kuwichigwa Walawi ndo wolimiza, na mjenzi yohejelela kokopoligwa. ");
INSERT INTO vid_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","Waisilaeli wanji weng'ha wowika kambi za hewo kwa vilundo vilundo, chila munhu hali chilundo cha heye na hasi ha bendela ya heye. ");
INSERT INTO vid_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","Ila Walawi wowika kambi kwa kuzunguluta ihema lya Nguluwi lya ulolezi kuno wololela leka munhu yoneche yaleche kuhejelela na kwambuza ng'halazi ya heni iwe kwa Waisilaeli weng'ha, lelo Walawi wowika goya ihema lya Nguluwi lya ulolezi.” ");
INSERT INTO vid_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","Ahyo Waisilaeli nawadita kota Mkulu Nguluwi vyoyamlajize Musa. ");
INSERT INTO vid_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","Mkulu Nguluwi nakawalonjela Musa na Aluni, ");
INSERT INTO vid_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","“Waisilaeli wowika kambi, chila munhu kochikala hali bendela ya heye, hali ulajilo wa ivyazi lya heye. Wowika kambi kuzunguluta ihema lya Nguluwi. ");
INSERT INTO vid_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","“Wala wawele wowika kambi nzingo ya kolilawila isanya, wowa chilundo cha wanhu wawele hasi ha bendela ya Yuda na chilongozi wa hewo kowa Nashoni mwana wa Aminadabu, ");
INSERT INTO vid_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","chilundo cha heye kwa kuwawaza ndo walume elufu makumi saba na gane na miya sita (74,600). ");
INSERT INTO vid_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","Wala wawele wowinza wanhu wa Yuda kuwika kambi, wowa nhanzi ya Isakali, chilongozi wa hewo nayawele Netaneli mwana wa Suali, ");
INSERT INTO vid_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","chilundo cha heye kwa kuwawaza ndo walume elufu makumi gahano na zine na miya zine (54,400). ");
INSERT INTO vid_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","Hamba nhanzi za Sebuluni, chilongozi wa hewo nayali Eliabu mwana wa Heloni, ");
INSERT INTO vid_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","chilundo cha heye kwa kuwaza ndo walume elufu makumi gahano na saba na miya zine (57,400). ");
INSERT INTO vid_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","Wanhu weng'ha wa wowa kuli kambi ya Yuda ndo kwa vilundo vya hewo ndo walume lachi imwe na elufu makumi nane na sita na miya zine (186,400). Awo ndo wolongola kwaluka majendo. ");
INSERT INTO vid_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","“Kwa ubanzi wa kusini, wala wawele hasi ha bendela ya chilundo cha Lubeni kwa vilundo vya hewo, chilongozi wa hewo yawele Elisuli mwana wa Shedeuli, ");
INSERT INTO vid_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","chilundo cha heye kwa kuwazigwa ndo walume elufu makumi gane na sita na miya zihano (46,500). ");
INSERT INTO vid_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","Baho du wala wowika kambi hafungo ha wanhu wa Lubeni ndo wanhu wa nhanzi ya Simeoni, chilongozi wa hewo kowa Shelumieli mwana wa Suli-shadai, ");
INSERT INTO vid_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","chilundo cha heye kwa kuwazigwa ndo walume elufu makumi gahano na tisa na miya zidatu (59,300). ");
INSERT INTO vid_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","Nhanzi ya Gadi, chilongozi wa hewo ndo Eliasafu mwana wa Leueli, ");
INSERT INTO vid_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","chilundo cha heye kwa kuwazigwa ndo walume elufu makumi gane na gahano na miya sita na makumi gahano (45,650), ");
INSERT INTO vid_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","walume vyowowa kuli kambi ya Lubeni kwa vilundo vya hewo ndo wanhu lachi imwe na elufu makumi gahano na imwe na miya zine na makumi gahano (151,450). Awa ndo wowa kuli chilundo cha keli kuli majendo. ");
INSERT INTO vid_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","“Hamba, nhanzi ya Walawi naiwa hagati ha nhanzi zinji kuno wohola alyo ihema lya Nguluwi wojenda. Chila nhanzi yojenda kwa kuwinza honhu hake kwa bendela. ");
INSERT INTO vid_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","“Kuli ubanzi wa kolilinguzinjila isanya, wala wawele hasi ha bendela ya chilundo cha Efulaimu wochikala mkambi kuli vilundo vya hewo, chilongozi wa hewo ndo Elishama mwana wa Amihudi, ");
INSERT INTO vid_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","chilundo cha heye kuli kuwaliza ndo walume elufu makumi gane na miya zihano (40,500). ");
INSERT INTO vid_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","Nhanzi ya Manase yowinza nhanzi ya Efulaimu. Chilongozi ndo Gamalieli, mwana wa Pedasuli, ");
INSERT INTO vid_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","chilundo cha heye kuli kuwaliza ndo walume elufu makumi gadatu na mbili na miya mbili (32,200). ");
INSERT INTO vid_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","Hamba nhanzi ya Benjamini, chilongozi ndo Abidani, mwana wa Gideoni, ");
INSERT INTO vid_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","chilundo cha heye kuli kuwaliza ndo walume elufu makumi gadatu na gahano na miya zine (35,400). ");
INSERT INTO vid_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","Wanhu nawawele kuli kambi ya Efulaimu kuli vilundo vya hewo ndo walume lachi imwe na elufu nane na miya imwe (108,100). Chilundo achi cha nhanzi ya Efulaimu chowa chilundo cha kadatu kuli majendo. ");
INSERT INTO vid_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","“Kuli ubanzi wa kasikazini, wowika kambi kuli vilundo lya hewo wala wawele hasi ha bendela ya Dani, chilongozi wa hewo ndo Ahieseli, mwana wa Amishadai, ");
INSERT INTO vid_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","chilundo cha heye kuli kuwaliza ndo walume elufu makumi sita na mbili na miya saba (62,700). ");
INSERT INTO vid_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","Baho du wowika kambi kulawila aho wowa wanhu wa nhanzi ya Asheli, chilongozi wa hewo ndo Pagieli mwana wa Okilani, ");
INSERT INTO vid_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","chilundo cha heye kuli kuwaliza ndo walume elufu makumi gane na imwe na miya zihano (41,500). ");
INSERT INTO vid_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","Baho du wanhu wa nhanzi ya Nafutali, chilongozi wa heye nayali Ahila mwana wa Enani, ");
INSERT INTO vid_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","chilundo cha heye kuli kuwaliza ndo walume elufu makumi gahano na gadatu na miya zine (53,400). ");
INSERT INTO vid_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","Weng'ha wowa kuli honhu howawichile kambi ya hewo walume lachi imwe na elufu makumi gahano na saba na miya sita (157,600). Chilundo achi cha Dani chowa chilundo cha mwiso kuli majendo, kulawa bendela imwe mbaka iyage.” ");
INSERT INTO vid_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","Awo ndo Waisilaeli wawalizwe kulawila kuli ivyazi lya hewo, kuli kambi ya chilundo cha hewo, weng'ha nawali lachi sita na elufu zidatu na miya zihano na makumi gahano (603,550). ");
INSERT INTO vid_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","Ila Walawi hawawazigwe hali wanhu wa Isilaeli kota Mkulu Nguluwi vyoyamlajize Musa. ");
INSERT INTO vid_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","Ahyo ndo Waisilaeli vyowaditile chila chinhu kota Mkulu Nguluwi vyoyamlajize Musa. Nawawika kambi kwa kuwinza bendela za hewo na walutilila na majendo chila yumwe na lukolo wa heye na ivyazi lya heye. ");
INSERT INTO vid_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","Awa ndo wana wa Aluni na Musa mhela Mkulu Nguluwi loyalonjile na Musa mchidunda cha Sinai. ");
INSERT INTO vid_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","Aga ndo matagwa ga wana wa Aluni. Nawali Nadabu, mlelwa wa heye wa mwaluko na Abihu na Eleasali na Itamali. ");
INSERT INTO vid_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","Aga ndo matagwa ga wana wa Aluni nawawichigwe kwa mijito yelile na kubakalizwa mafuta wawe watambika. ");
INSERT INTO vid_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","Ila Nadabu na Abihu nawabagama hali Mkulu Nguluwi, mhela lowamlavile Mkulu Nguluwi chiluli chohachikundigwe kuli chiwala cha Sinai. Hewo nawali hela wana, ahyo Eleasali na Itamali nawakola mijito kota watambika mhela wa ukomu wa Aluni Mhaza wa hewo. ");
INSERT INTO vid_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","Mkulu Nguluwi nakamlonjela Musa, ");
INSERT INTO vid_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","“Uwegale habehi wanhu wa nhanzi ya Lawi, uwawiche kumwando kwa mtambika Aluni waze kumkolela mijito. ");
INSERT INTO vid_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","Wowakolela mijito Aluni na Waisilaeli weng'ha hala kuli ihema lya Nguluwi howokola mijito ya ihema lya Nguluwi. ");
INSERT INTO vid_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","Wololela vinhu vyeng'ha vya ihema lya Nguluwi na kuwatanza Waisilaeli howokola mijito ja hewo kuli ihema lya Nguluwi. ");
INSERT INTO vid_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","Aluni na walelwa wa heye wopegwa Walawi, awo walavigwa hali Waisilaeli wawakolele mijito.” ");
INSERT INTO vid_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","Kowahagula Aluni na wana wa heye leka wazengukola mijito ja hewo ja utambika, ila wone munhu nyunji hoyojeza kukola mijito ja utambika, kokopoligwa. ");
INSERT INTO vid_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","Mkulu Nguluwi nakalutilila kumlonjela Musa, ");
INSERT INTO vid_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","“Ulole, ndiwahagula Walawi kuli wanhu wa Isilaeli weng'ha honhu hali chila mlelwa wa mwaluko mlume kuli chila ivyazi lya Isilaeli. Walawi ndo wa heni, ");
INSERT INTO vid_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","kwa vila chila mlelwa wa mwaluko wa Isilaeli ndo wa heni. Mhela londiwakopole walelwa wa mwaluko wa Misili nandimdita chila mlelwa wa mwaluko wa wanhu na wa migongolo yawe wa chiuyeng'ha, hewo wowa ndo wa heni. Heni ndo mbele Mkulu Nguluwi.” ");
INSERT INTO vid_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","Hamba Mkulu Nguluwi nakamlonjela Musa kuli chiwala cha Sinai, ");
INSERT INTO vid_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","“Wawaze wana wa Lawi weng'ha kwa kuwinza lukolo lwawo na ivyazi lya hewo, chila mlume yawele na mwezi umwe na mzidi.” ");
INSERT INTO vid_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","Lelo Musa nakawawaza kota vyoyalajizwe na lizi lya Mkulu Nguluwi. ");
INSERT INTO vid_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","Awa ndo wali wana wa Lawi, Gelishoni na Kohati na Melali. ");
INSERT INTO vid_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","Aga ndo matagwa ga wana walume wa Gelishoni kwa kuwinza ng'holo za hewo, Libuni na Shimei. ");
INSERT INTO vid_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","Wana walume wa Kohati kwa kuwinza ng'holo za hewo nawali, Amulamu na Ishali na Hebuloni na Usieli. ");
INSERT INTO vid_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","Wana walume wa Melali kwa kuwinza ng'holo za hewo, nawali Mahuli na Mushi. Ali nalyali ivyazi lya Walawi kulawa kuli ng'holo za hewo. ");
INSERT INTO vid_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","Ivyazi lya Walibuni na Washimei nalilawa kwa Gelishoni, azi ndo nazali ng'holo za Wagelishoni. ");
INSERT INTO vid_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","Hisabu ya hewo kwa kuwaza walume weng'ha kwaluchila nawawele na mwezi umwe na mzidi ndo elufu saba na miya zihano (7,500). ");
INSERT INTO vid_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","Ng'holo za Wagelishoni naiwalapa kuwika kambi kuli ubanzi wa kolizinjilaga isanya, kumbele kwa ihema lya Nguluwi, ");
INSERT INTO vid_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","na heye Eliasafu mwana wa Laeli yawele mkulu wa lukolo lwa Wagelishoni. ");
INSERT INTO vid_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","Mijito ja wana wa Gelishoni najali kulolela ihema lya Nguluwi hamwe na chigubiko cha ihema lya Nguluwi na ipaziya lya lwizi lwa ihema lya Nguluwi ");
INSERT INTO vid_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","na mipaziya ja lugagala naluwele lulinguzunguluta ihema lya Nguluwi na honhu ha kulavila nhambiko na ipaziya lya lwizi lwa lugagala na ng'weso zake. Mijito jeng'ha jilingulapa vinhu avi najali ja hewo. ");
INSERT INTO vid_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","Ng'holo za Waamulamu na Waishali na Wahebuloni na Wausieli nazilawa kwa Kohati, ali ndo nalyali ivyazi lya Wakohati. ");
INSERT INTO vid_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","Kota vyoliwazigwe kwa walume weng'ha kwaluchila na wawele na mwezi umwe na mzidi, nawali elufu nane na miya sita (8,600), nawali wololela honhu helile. ");
INSERT INTO vid_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","Ng'holo za wana wa Kohati nayali ilapigwa kuwika kambi ubanzi wa kusini mwa ihema lya Nguluwi, ");
INSERT INTO vid_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","na heye Elisafani mwana wa Usieli, yawele mkulu wa lukolo alo lwa ivyazi lya Wakohati. ");
INSERT INTO vid_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","Mijito ja hewo jali kulilolela isanduku lya ilagano na visaga na chinhu cha kuwichila chenje na honhu ha kulavila nhambiko na vinhu vyowalingukolela mijito honhu helile na ipaziya, mijito jeng'ha jilingulapa vinhu avi najali ja hewo. ");
INSERT INTO vid_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","Na heye Eleasali mwana wa mtambika Aluni nakawichigwa kuwa mng'hangala wa wakulu wa Walawi mlolezi wa wanhu weng'ha walingukola mijito honhu helile. ");
INSERT INTO vid_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","Ng'holo za Wamahili na Wamushi nazilawila kwa Melali. ");
INSERT INTO vid_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","Weng'ha kwa kuwazigwa kwa kwaluchila walume wawele na mwezi umwe na mzidi nawali wanhu elufu sita na miya mbili (6,200). ");
INSERT INTO vid_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","Mkulu wa lukolo lwa ivyazi lya Melali nayali Sulieli mwana wa Abihaili, awa nawaganigwa kuwika kambi ubanzi wa kasikazini mwa ihema lya Nguluwi. ");
INSERT INTO vid_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","Awo wana wa Melali nawapegwa mijito ja kulolela fulemu za ihema lya Nguluwi, mhajilo na mizengo na mambo na vinhu vyeng'ha vya kibatilila ihema, mijito jeng'ha jilinguwala vinhu avi, najali ja hewo. ");
INSERT INTO vid_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","Na kahi nawaganigwa kulolela mizengo ja lugagala luzungulute ihema lya Nguluwi na vigingi na ng'weso zake. ");
INSERT INTO vid_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","Musa na Aluni na wana wawo, nawaganigwa kuwika kambi hali ihema lya Nguluwi ubanzi wa kolilawilaga isanya. Nawaganigwa hewo kukola mijito ja utambika kuli ihema lya Nguluwi kwa chiwalo cha Waisilaeli. Munhu yunji yoneche yahejele habehi naiganigwa yakopoligwe. ");
INSERT INTO vid_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","Hisabu ya Walawi kwa kuwinza ivyazi lya hewo, walume weng'ha kwaluchila wana wawele na mwezi umwe na mzidi wawele Musa na Aluni nawawawazile kwa ilajizo lya Mkulu Nguluwi, nawali wanhu elufu makumi meli na mbili (22,000). ");
INSERT INTO vid_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","Mkulu Nguluwi nakamlonjela Musa, “Wawaze kwa matagwa walelwa wa mwaluko walume weng'ha wa Waisilaeli kwaluchila wawele na mwezi umwe na mzidi. ");
INSERT INTO vid_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","Nagwe kowabagula Walawi kwa chiwalo cha heni Mkulu Nguluwi wawe honhu ha walelwa wa mwaluko wa Waisilaeli, kahi kobagula kwa chiwalo cha heni migongolo jeng'ha ja Walawi jiwe honhu ha walelwa wa mwaluko wa migongolo ja wanhu wa Isilaeli.” ");
INSERT INTO vid_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","Lelo Musa nakawawaza walelwa wa mwaluko weng'ha wa wanhu wa Isilaeli kota Mkulu Nguluwi vyoyamlajize. ");
INSERT INTO vid_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","Walelwa weng'ha wa mwaluko walume kuli kuwazigwa kwa matagwa, wawele na mwezi umwe na mzidi, nawali elufu makumi meli na mbili na miya mbili na makumi saba na zidatu (22,273). ");
INSERT INTO vid_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","Mkulu Nguluwi nakamlonjela Musa, ");
INSERT INTO vid_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","“Lelo wabagule Walawi weng'ha wawe wa heni honhu ha walelwa wa mwaluko wa Waisilaeli. Kahi, ujibagule misenga ja Walawi weng'ha honhu ha walelwa wa mwaluko wa misenga ja Waisilaeli. Hewo Walawi ndo wa heni. Heni nda Mkulu Nguluwi. ");
INSERT INTO vid_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","Kwa chiwalo cha kuwagombola walelwa wa mwaluko walume wa wanhu wa Isilaeli miya mbili na makumi saba na wadatu (273), wawele mzidi wa walume Walawi, ");
INSERT INTO vid_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","kobochela kwa chila mlume sendi migwala jihano, kwa kuwinza chipimilo cha honhu helile, ");
INSERT INTO vid_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","na sendi azo kwa chiwalo cha kuwagombola awo wawele mzidi kwa Walawi komha Aluni na wanage.” ");
INSERT INTO vid_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","Musa nakahulichiza, nakahola sendi azo za kuwagombola awo wawele mzidi wa wagomboligwe na Walawi, ");
INSERT INTO vid_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","nakabochela kulawila walelwa wa mwaluko wa Isilaeli sendi chasi cha migwala elufu imwe na miya zidatu na makumi sita na gahano (1,365), kwa kuwinza chipimilo cha honhu helile, ");
INSERT INTO vid_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","Musa nakawapa Aluni na wanage sendi azo za kuwagombola kota Mkulu Nguluwi vyoyamlajize. ");
INSERT INTO vid_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","Mkulu Nguluwi nakawalonjela Musa na Aluni, ");
INSERT INTO vid_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","“Muwawaze walelwa wa Kohati, yumwe wa lukolo lwa Lawi kwa kuwinza wanhu wa hewo na ivyazi lya hewo, ");
INSERT INTO vid_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","kowawaza walume weng'ha wawele na miyaka makumi gadatu mbaka makumi gahano walinguganigwa kilumba na mijito ja ihema lya Nguluwi. ");
INSERT INTO vid_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","Ahyo ndo vyojiwa mijito ja wana wa Kohati kuli ihema lya Nguluwi, kuli vinhu vyelile ng'hatu. ");
INSERT INTO vid_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","“Mhela wa kubena kambi, watambika, Aluni na wanage, wokwinjila kuli ihema na kutelemla ipaziya liwele hali isanduku lya ilagano, hamba woligubika kwa ipaziya alyo. ");
INSERT INTO vid_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","Mchanya mwake wowika chigubiko cha migozi ja migongolo jilingikala mbahali, mchanya mwake migozi ajo kahi wowika chibende cha lanji ya buluu inojile. Hamba wokwinjiza mipichilo ja kuliholela isanduku alyo. ");
INSERT INTO vid_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","“Mchanya mwa chisaga cha kulavila mibumunda jelile, wowika chibende cha buluu chiwele mchanya mwa acho kowichigwa luhelo na visaye vya ubani na chizombe kwa chiwalo cha kulavila nhambiko za kunwa. Mazuwa gose kowa na ibumunda mchanya mwa chisaga. ");
INSERT INTO vid_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","Hamba, wogubika vinhu avyo vyeng'ha kwa chibende chidung'hu na mchanya mwake wowika chigubiko cha igozi lya igongolo lilingikala mbahali. Hamba wokwinjiza mipichilo jake ja kuliholela. ");
INSERT INTO vid_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","“Wohola chibende cha buluu chiwele ndo chowogubika chinhu cha kuwichila chenje na chenje chake na vinhu vya kibatila ikala na luhelo na vinhu vyeng'ha vilinguganigwa kuwichila mafuta. ");
INSERT INTO vid_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","Wochiwika hamwe na vinhu vyake vyeng'ha mgati mwa igozi lya igongolo lilingikala mbahali na kuchiwika mchanya mwa fulemu ya kupichila. ");
INSERT INTO vid_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","“Hamba wowika chibende cha buluu mchanya mwa honhu ha kulavila nhambiko ha zahabu na kuigubika kwa igozi lya igongolo lilingikala mbahali mchanya mwake. Hamba wokwinjiza mipichilo ja kupichila. ");
INSERT INTO vid_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","Wovihola vinhu vyeng'ha vilinguganigwa honhu helile, woviwopa kwa chibende cha buluu na kuvigubika kwa igozi lya igongolo lilingikala mbahali, hamba woviwika mchanya mwa fulemu ya kupichila. ");
INSERT INTO vid_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","Wokusa mivu hali honhu ha kulavila nhambiko ha shaba na mchanya mwake wowika chibende cha zambalau. ");
INSERT INTO vid_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","Mchanya mwake wowika vinhu vyeng'ha vilinguganigwa kuli mijito ja honhu ha kulavila nhambiko, makala na mibano na mihuka na visaye. Hamba, mchanya mwake wowika chigubiko cha igozi lya igongolo lilingikala mbahali na kwinjiza mipichilo jake ja kupichila. ");
INSERT INTO vid_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","Aluni na wanage lowagubiche honhu helile hamwe na vinhu vyake vyeng'ha, wawa wewichile goya kwa kwaluka majendo. Hamba wanhu wa nhanzi ya Kohati wokuya na kuvipika. Ila hewo, hambe wakundizwe ng'hatu kuvidoliza vinhu avyo vyelile, leka waleche kubagama. Ayo ndo mijito ja nhanzi ya Kohati chila mhela ihema lya Nguluwi holikusigwa na kuhilichigwa honhu hanji. ");
INSERT INTO vid_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","Eleasali, mwana wa mtambika Aluni, kanguganigwa kulolela mafuta ga chenje na ubani wa kununyhilila na nhambiko za nyhule ya chila zuwa na mafuta ga kubakaliza leka yalolele chila chinhu kuli ihema alyo na honhu helile na vinhu vyake.” ");
INSERT INTO vid_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","Hamba Mkulu Nguluwi nakawalonjela Musa na Aluni, ");
INSERT INTO vid_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","“Mleche kuleka nhanzi ya ng'holo za Kohati hali Walawi zidumigwe. ");
INSERT INTO vid_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","Lelo kwa kuwalemeza waleche kubagama kwa kuvihejelela vinhu avyo vyelile ng'hatu kodita ahi. Aluni na wanage wokwinjila na kumlonjela chila yumwe wa hewo vyoyalonjelwe kudita mijito ja heye. ");
INSERT INTO vid_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","Ila walelwa wa Kohati hawokwinjila ng'oo kuvilola vinhu vyelile ng'hatu, wone wadite ahyo, wobagama.” ");
INSERT INTO vid_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","Mkulu Nguluwi nakamlonjela Musa, ");
INSERT INTO vid_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","“Wawaze walelwa wa Gelishoni, kwa ivyazi na ng'holo za hewo, ");
INSERT INTO vid_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","kowawaza walume weng'ha wawele na miyaka makumi gadatu mbaka makumi gahano walinguganigwa kihanza kuli mijito ja ihema lya Nguluwi. ");
INSERT INTO vid_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","Awu ndo uchitumagwa wa ivyazi lya Wagelishoni kuli mijito na kupika mhomolo. ");
INSERT INTO vid_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","Hewo wopika mipaziya na ihema lya Nguluwi na chigubiko chake na chigubiko cha migozi ja migongolo jilingikala mbahali jiwele mchanya mwake na ipaziya lya lwizi lwa kwinjila kuli ihema lya Nguluwi, ");
INSERT INTO vid_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","na mipaziya ja lugagala na ipaziya lya kwinjila kuli lugagala lulinguzunguluta ihema lya Nguluwi na honhu ha kulavila nhambiko na ng'weso zake na vinhu vyeng'ha vya kukolela mijito. Wagelishoni wokola mijito na mbuli zeng'ha zilinguwala vinhu avi. ");
INSERT INTO vid_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","Aluni na wanage wowalajiza kukola mijito jeng'ha ja Wagelishoni kwa vinhu vyowopika na mijito jowodita. Kowawichila vinhu vyeng'ha vila viwele vyowalinguganigwa kupika. ");
INSERT INTO vid_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","Ajo ndo mijito ja walelwa wa Gelishoni kuli ihema lya Nguluwi, wokola mijito hali ulongozi wa Itamali mwana wa mtambika Aluni. ");
INSERT INTO vid_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","“Na kahi kowawaza walelwa wa Melali, kwa kuwinza ng'holo za hewo na ivyazi lya hewo. ");
INSERT INTO vid_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","Kowawaza walume weng'ha wawele na miyaka makumi gadatu mbaka makumi gahano, walinguganigwa kukola mijito kuli ihema lya Nguluwi. ");
INSERT INTO vid_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","Awo, ndo wowa na mijito ja kupika fulemu na mhajilo na mizengo na msisi wa ihema lya Nguluwi ");
INSERT INTO vid_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","na mizengo ja lugagala lwa kuzunguluta nzingo zeng'ha za ihema lya Nguluwi na vikalilo na vigingi na ng'weso hamwe na vinhu vyake vyeng'ha na vinhu viyage vyeng'ha. Nagwe kowawichila vinhu vyowalinguganigwa kupika kwa kuwinza matagwa ga hewo, chila munhu na mhomolo ya heye. ");
INSERT INTO vid_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","Ajo ndo jowa mijito ja walelwa wa Melali kuli kukola mijito ja hewo jeng'ha mgati mwa ihema lya Nguluwi, hali ulongozi wa Itamali mwana wa mtambika Aluni.” ");
INSERT INTO vid_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","Lelo Musa na Aluni na vilongozi wa Waisilaeli weng'ha wowawaza walelwa wa Kohati, kwa kuwinza ng'holo na ivyazi lya hewo. ");
INSERT INTO vid_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","Nawawandika wanhu weng'ha wawele na miyaka makumi gadatu mbaka makumi gahano, chila yoweza kwinjila kuli kukola mijito ja ihema lya Nguluwi. ");
INSERT INTO vid_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","Wanhu wa ivyazi lya hewo nawali elufu mbili na miya saba na makumi gahano (2,750). ");
INSERT INTO vid_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","Awa ndo wanhu wa ivyazi lya Kohati, wawele ngukola mijito kuli ihema lya Nguluwi, liwele Musa na Aluni nawawawaza kota Mkulu Nguluwi vyonayamlajize Musa. ");
INSERT INTO vid_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","Walelwa wa Gelishoni kwa kuwinza ng'holo za hewo, ");
INSERT INTO vid_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","wawele na miyaka makumi gadatu mbaka makumi gahano, wawele woweza kukola mijito kuli ihema lya Nguluwi, ");
INSERT INTO vid_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","nawali wanhu elufu mbili na miya sita na makumi gahano (2,650) kwa kuwinza ng'holo za hewo na ivyazi lya hewo. ");
INSERT INTO vid_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","Awa ndo nawawele walelwa wa Gelishoni weng'ha kwa kuwinza ng'holo za hewo na ivyazi lya hewo, wakolile mijito kuli ihema lya Nguluwi, wawele Musa na Aluni nawawawaza kota Mkulu Nguluwi vyoyawalajize. ");
INSERT INTO vid_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","Walelwa wa Melali kwa kuwinza ivyazi lya hewo, ");
INSERT INTO vid_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","wawele na miyaka makumi gadatu mbaka makumi gahano, wawele woweza kukola mijito kuli ihema lya Nguluwi, ");
INSERT INTO vid_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","nawali wanhu elufu zidatu na miya mbili (3,200). ");
INSERT INTO vid_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","Awa ndo walelwa wa Melali kwa kuwinza ng'holo za hewo wawele Musa na Aluni nawawawaza kota Mkulu Nguluwi vyoyamlajize Musa. ");
INSERT INTO vid_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","Ahyo, Walawi weng'ha wandichigwe na Musa na Aluni na vilongozi wa wanhu wa Isilaeli, kwa kuwinza ivyazi lyawo na ng'holo za hewo, ");
INSERT INTO vid_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","wawele na miyaka makumi gadatu mbaka makumi gahano, wawele woweza kukola mijito ja kulilolela na kulipika ihema lya Nguluwi, ");
INSERT INTO vid_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","nawali wanhu elufu nane na miya zihano na makumi nane (8,580). ");
INSERT INTO vid_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","Kwa mzilo wa Mkulu Nguluwi, nawawazigwa na Musa. Chila munhu nakapegwa mijito ja heye na itunyo lya heye, kota Mkulu Nguluwi navyoyamlajize Musa. ");
INSERT INTO vid_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","Mkulu Nguluwi nakamlonjela Musa, ");
INSERT INTO vid_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","“Walonjele Waisilaeli wamlavye kunze mwa kambi chila munhu yakokomoche na chila munhu yawele na utamwa wa ngozi na yalingulawa mifila na chila yawele yakokomoche kwa kudoliza mtufi. ");
INSERT INTO vid_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","Mowalavya kunze mwa kambi wanhu awo weng'ha, wawe walume ama wadala, leka waleche kuidita ikokomoche kambi ya heni yondilingikala hali hewo.” ");
INSERT INTO vid_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","Waisilaeli nawadita ahyo, nawawalavya kunze mwa kambi. Kota Mkulu Nguluwi vyoyamlajize Musa, ndo Waisilaeli vyowaditile. ");
INSERT INTO vid_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","Hamba Mkulu Nguluwi nakamlonjela Musa, ");
INSERT INTO vid_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","“Walonjele Waisilaeli kota munhu yoneche, mlume ama mdala, wone yomditila munhu gehile, kuno kahela makundo kwa Mkulu Nguluwi wa heye, munhu ayo kana nongwa, ");
INSERT INTO vid_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","yomlapa yalonje kwa mlomo wa heye gehile ga heye goyaditile. Na imgana kulavya chinhu chenele kwa gala goyaditile, yokonjeza honhu ha kahano ha chinhu acho, komha chinhu acho munhu yula yamditile gehile. ");
INSERT INTO vid_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","Ila wone munhu ayo yaditilwe gehile yabagame na kahela mng'holoze wa habehi wa kubochela chinhu acho, lelo chinhu acho kwa chiwalo cha nongwa ayo cholavigwa kwa Mkulu Nguluwi kwa chiwalo cha watambika. Kuhilusa kuno ndo hamwe na ing'holo ilume liwele lyolavigwa kwa chiwalo cha uhanyisi na kwa chiwalo cha gehile ga heye. ");
INSERT INTO vid_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","Chila ndolendole zelile za Waisilaeli za kumlavila mtambika, zowa za ayo mtambika. ");
INSERT INTO vid_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","Chila chinhu chelile cha kuhilikwa kwa mtambika chowa cha heye.” ");
INSERT INTO vid_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","Mkulu Nguluwi nakamlonjela Musa, ");
INSERT INTO vid_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","“Walonjele Waisilaeli ahi. Wone mdala wa munhu yoneche nakapaluka na kumdita yaleche kukundigwa kwa mlume wa heye, ");
INSERT INTO vid_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","nakawasa na munhu yunji ne mlume wa heye kuvizela, nakedita yakokomoche ila haduhu munhu yachiwene chinhu acho chikoleka kwa vila hebatigwe hebu. ");
INSERT INTO vid_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","Lelo wone mlume wa heye yenjilwe na majesa na kona fihi kwa mdala wa heye yeditile yakokomoche, ama wone nakawa na fihi kwa mdala wa heye hanga mdala wa heye naheditile yakokomoche, ");
INSERT INTO vid_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","lelo ayo mlume komigala ayo mdala kwa mtambika kigala nhambiko ilinguganigwa, iwele ndo kilo imwe ya utimbo wa shayili, ila ne kujida mafuta ama ubani, kwa vila ndo nhambiko ya fihi, nhambiko ilingulavigwa kulajila kota kana nongwa ama hebu. ");
INSERT INTO vid_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","“Mtambika komigala ayo mdala behi, na kumwimiza hali Mkulu Nguluwi. ");
INSERT INTO vid_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","Hamba mtambika kojida mazi gelile mli chisaye na kuhola nhimbwisi kulawa hasi mli ihema lya Nguluwi na kujela mli mazi ago. ");
INSERT INTO vid_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","Mtambika komuwika mdala ayo hali Mkulu Nguluwi na kumgubula mnvili na kumha nhambiko ayo ya nyhule ya kulajila nongwa, iwele ndo nhambiko ya fihi. Mtambika heye kochibatilila chila chisaye chiwele na mazi galingigala kupanjilwa. ");
INSERT INTO vid_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","Hamba mtambika komlonjela ayo mdala yelahe kwa kulonga, ‘Wone huwasile na mlume yunji kidita ukokomoche hali ludali lwa mlume wa hegwe, lelo hupanjilwa hebu na mazi gano. ");
INSERT INTO vid_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","Ila wone uhinduche uwele hali ludali lwa mlume wa hegwe, kiyambuza ukokomoche kwa kuwasa na mlume yunji uwele hali ludali lwa mlume wa hegwe, ");
INSERT INTO vid_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","Mkulu Nguluwi nayakugaze na kilaha kwa kukupanjila hali wanhu wa hegwe, uwe mhende na lida lya hegwe litutume. ");
INSERT INTO vid_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","Mazi aga galingigala kupanjilwa genjile mlida lya hegwe na kukudita uleche kuponda na lida lya hegwe litutume.’ Na heye mdala kokwidichila, ‘Ena, Ena.’ ");
INSERT INTO vid_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","“Hamba mtambika kokwandika kupanjilwa aku kuli igozi na kuhovuga maandiko ago kuli mazi gausungu, ");
INSERT INTO vid_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","na heye komnweza mdala mazi ago galingigala kupanjilwa na kumigalila usungu lukami, ");
INSERT INTO vid_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","hamba mtambika kohola yila nhambiko ya nyhule ya fihi mmoko mwa mlume wa ayo mdala na kwinula kuchanya hali Mkulu Nguluwi na kuigala honhu ha kulavila nhambiko. ");
INSERT INTO vid_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","Hamba mtambika kohola honhu ha nhambiko ayo ya nyhule kwa kukumbuchila na kuilakaza hali honhu ha kulavila nhambiko. Hamba komnweza ayo mdala ago mazi gausungu. ");
INSERT INTO vid_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","Wone yanwe, wone yeditile yakokomoche, na kumdita yawe hambe yakundigwe kwa mlume wa heye, mazi ago galingigala kupanjilwa gomgalila usungu ung'hang'hale ng'hatu, lida lya heye lyotutuma na kowa mhende. Mdala ayo kowa yapanjilwe kuli wanhu wa heye. ");
INSERT INTO vid_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","Ila wone mdala ayo heditile yakokomoche na kela, lelo hokwabuka na koweza kuponda wana. ");
INSERT INTO vid_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","“Lelo aga ndo malajizo kuwala kutagusa fihi, wone mdala ka hali ludali lwa mlume wa heye, kopaluka na kidita yakokomoche, ");
INSERT INTO vid_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","ama mhela mlume hoyokona fihi, na kangijesa kota mchewake nakawasa na mlume yunji. Komwimiza mdala ayo hali Mkulu Nguluwi na mtambika kodita mbuli zeng'ha za malajizo aga. ");
INSERT INTO vid_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","Mlume wa heye kowa hela nongwa yoneche, ila mdala kogazigwa kwa nongwa ya heye.” ");
INSERT INTO vid_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","Mkulu Nguluwi nakamlonjela Musa, ");
INSERT INTO vid_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","“Uwape Waisilaeli malajizo gondonjile, wone mlume ama mdala kochilaha chilaho cha Mnazili kwa chiwalo cha kiwika chiuyeng'ha kwa Mkulu Nguluwi, ");
INSERT INTO vid_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","lelo, yaleche kunwa divai ama ujimbi ama chakunwa choneche cha zabibu ama kunwa mazi ga zabibu ne kulya zabibu zipile ama zikalile. ");
INSERT INTO vid_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","Mhela weng'ha hoyowa mchilaho, yaleche kulya chinhu choneche chilingulawa kuli zabibu, kulawila ipeche mbaka ibanzi. ");
INSERT INTO vid_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","“Zuwa lyeng'ha lya chilaho cha heye cha kibagula, hobeya hebu mnvili za heye mbaka mhela wa chilaho cha heye hali Mkulu Nguluwi hochimala. Kowa yelile na kozileka mnvili za heye zikule. ");
INSERT INTO vid_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","Zuwa lyeng'ha lyoyowa yebagule kwa Mkulu Nguluwi, munhu ayo yaleche kuwa habehi na mtufi, ");
INSERT INTO vid_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","hanga uwe wa mhaza ama wa mamo na lumbu ama kalumbu wa heye, hochidita yakokomoche kwa kibagula kwa Mkulu Nguluwi kwa kilaha. ");
INSERT INTO vid_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","Mhela weng'ha hoyowa Mnazili kowa yelile kwa Mkulu Nguluwi. ");
INSERT INTO vid_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","“Wone munhu wa habehi na Mnazili yabagame baho du na wone yamhejelele, Mnazili kowa yakokomoche. Zuwa lya saba hoyokwelizwa, kobeya mnvili za heye. ");
INSERT INTO vid_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","Kuli zuwa lya nane kohilika ng'hunda mbili za kufujigwa ama ng'hunda mbili za kisolo kwa mtambika hawele na lwizi lwa ihema lya Nguluwi. ");
INSERT INTO vid_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","Mtambika kolavya ng'hunda imwe iwe nhambiko ya gehile na ng'hunda iyage iwe kwa nhambiko ya kulakazwa, na heye komditila uhanyisi, kwa vila nakadita gehile kwa chiwalo cha kuhejelela mtufi. Zuwa lilyo du, koudita mutwi wa heye uwe welile ");
INSERT INTO vid_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","na kibagula kwa Mkulu Nguluwi na kwaluka chilaho kahi. Kolavya ing'holo ilume lya mwaka umwe liwe nhambiko ya nongwa. Mazuwa ago ga mwaluko hagowazigwa kwa vila nayali yakokomoche. ");
INSERT INTO vid_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","“Aga ndo malajizo ga Mnazili hoyosinda mhela wa heye wa kibagula. Kochigaligwa hali lwizi lwa ihema lya Nguluwi, ");
INSERT INTO vid_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","na kumlavila Mkulu Nguluwi nhambiko za heye, ing'holo ilume limwe lya mwaka umwe lilihela nongwa kwa chiwalo cha nhambiko ya kulakazwa, ing'holo idala limwe lya mwaka umwe lilihela nongwa kwa chiwalo cha nhambiko ya gehile, na ing'holo ilume limwe lilihela nongwa kwa chiwalo cha nhambiko ya kikala goya. ");
INSERT INTO vid_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","Kahi kolavya chidoto cha mibumunda jilihela usaso, kuwika goya kwa utimbo unojile na mafuta na mibumunda mizisili jibakalizwe mafuta hamwe na nhambiko za nyhule na za kunwa. ");
INSERT INTO vid_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","“Mtambika komlavila Mkulu Nguluwi vinhu vyeng'ha avi hamwe na nhambiko ya heye ya gehile na nhambiko ya heye ya kulakazwa. ");
INSERT INTO vid_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","Mtambika komlavila Mkulu Nguluwi alyo ing'holo ilume kota nhambiko ya kikala goya, komlavya hamwe na chidoto cha mibumunda jilihela usaso na nhambiko ya nyhule na nhambiko ya kunwa. ");
INSERT INTO vid_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","Aho hali lwizi lwa ihema lya Nguluwi Mnazili ayo kobeya mnvili za mutwi wa heye za kibagula na kuziwika kuli chiluli chiwele hasi ha nhambiko ya kikala goya. ");
INSERT INTO vid_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","“Baho du mtambika kohola iyega lya lila ing'holo ilume liwele lihemsigwe hamwe na ibumunda limwe lyohaliwichigwe usaso kulawa kuli chidoto na ibumunda limwe lizisili na kahi haliwichigwe usaso na kumha Mnazili mmoko naloyabeyile mnvili za heye. ");
INSERT INTO vid_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","Hamba mtambika kolavya vinhu avyo kota nhambiko ya kwinula kuchanya hali Mkulu Nguluwi, vyeng'ha avi ndo honhu helile ha mtambika, hamwe na mhambaga yinuligwe kuchanya na chima chilavigwe kota ndolendole. Hamba, Mnazili koweza kunwa divai. ");
INSERT INTO vid_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","“Alyo ndo ilajizo kuwala Mnazili. Ila wone nakelaha kulavya mzidi wa malajizo ga Mnazili, koganigwa kudita kota vyoyalagane.” ");
INSERT INTO vid_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","Mkulu Nguluwi nakamlonjela Musa, ");
INSERT INTO vid_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","“Mlonjele Aluni na wanage kota ahyo ndo vyomuwatambichiza Waisilaeli. Mowalonjela, ");
INSERT INTO vid_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","“ ‘Mkulu Nguluwi nayawatambichize na kuwamila, ");
INSERT INTO vid_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","Mkulu Nguluwi nayawalole kwa isungu na kwa uganililo, ");
INSERT INTO vid_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","Mkulu Nguluwi nayawalajile kunoga kwa heye na kuwapani kikala goya.’ ");
INSERT INTO vid_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","“Ahyo ndo vyowolonga itagwa lya heni hali Waisilaeli, nani ndowatambichiza.” ");
INSERT INTO vid_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","Zuwa Musa loyasindile kwimiza ihema lya Nguluwi na kulibakaliza mafuta na kulidita liwe lyelile hamwe na vinhu vyake vyeng'ha na kubakaliza mafuta na kuhadita hawe helile honhu ha kulavila nhambiko na vinhu vyake vyeng'ha, ");
INSERT INTO vid_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","vilongozi wa Isilaeli na wakulu wa lukolo na vilongozi wa nhanzi iwele wawalolele na wanhu wala wawazigwe, ");
INSERT INTO vid_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","nawamigalila Mkulu Nguluwi nhambiko za hewo, mutuka imwe kwa chila vilongozi weli na isenga lilume kwa chila chilongozi. Nawavilavya vinhu avyo hali ihema lya Nguluwi, ");
INSERT INTO vid_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","Mkulu Nguluwi nakamlonjela Musa, ");
INSERT INTO vid_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","“Ubochele nhambiko azi leka zikole mijito kwa chiwalo cha ihema lya Nguluwi, uwape Walawi, chila yumwe kota mijito ja heye joyakolile.” ");
INSERT INTO vid_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","Lelo Musa nakahola mituka na misenga milume nakawapa Walawi. ");
INSERT INTO vid_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","Wagelishoni nawapegwa mituka mili na misenga milume jine, kwa mijito ja kupika vinhu vya ihema lya Nguluwi. ");
INSERT INTO vid_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","Wamelali nawapegwa mituka jine na misenga milume nane kwa mijito ja kupika vinhu vya ihema lya Nguluwi, hali ulongozi wa Itamali mwana wa mtambika Aluni. ");
INSERT INTO vid_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","Ila Musa hawapele choneche Wakohati kwa vila hewo nawali na mijito ja kulolela goya vinhu vyelile viwele naviganigwa kupichigwa mmayega. ");
INSERT INTO vid_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","Vilongozi awo wolavya nhambiko kwa chiwalo cha kuhawika honhu ha kulavila nhambiko kwa mijito yelile, zuwa lila navyohabakalizwe mafuta, nawalavya nhambiko za hewo hali honhu ha kulavila nhambiko. ");
INSERT INTO vid_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","Mkulu Nguluwi nakamlonjela Musa, “Chila zuwa chilongozi yumwe kolavya nhambiko ya heye kwa chiwalo cha kuhawika honhu ha kulavila nhambiko kwa mijito yelile.” ");
INSERT INTO vid_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","Lelo yula yalavile nhambiko zuwa lya mwaluko, nayali Nashoni mwana wa Aminadabu, wa nhanzi ya Yuda. ");
INSERT INTO vid_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","Nhambiko ya heye nayali luhelo lumwe lugongomanyigwe kwa sendi na luwele na itunyo lya kilo imwe na nusu na chisaye chimwe chigongomanyigwe kwa sendi chiwele na itunyo lya gilamu miya nane kwa kuwinza chipimilo cha ihema lya Nguluwi. Luhelo na chisaye navyali vimemezwe utimbo unojile uhanzigwe na mafuta kwa chiwalo cha nhambiko ya nyhule. ");
INSERT INTO vid_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","Kahi nakegala chisaye chimwe cha zahabu chiwele na itunyo lya gilamu miya imwe na kumi chiwele chimemezwe ubani ");
INSERT INTO vid_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","na ilogota ilume limwe na ing'holo lilume limwe na ing'holo lyana lilume limwe lya mwaka umwe kwa chiwalo cha nhambiko ya kulakazwa, ");
INSERT INTO vid_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","na ipongo limwe kwa chiwalo cha nhambiko ya gehile, ");
INSERT INTO vid_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","na misenga milume mili na ming'holo milume jihano na mipongo jihano na ming'holo myana milume jihano ja mwaka umwe kwa chiwalo cha nhambiko ya kikala goya. Ayo ndo nayali nhambiko ya Nashoni, mwana wa Aminadabu. ");
INSERT INTO vid_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","Zuwa lya keli nayali Netaneli mwana wa Suali, chilongozi wa nhanzi ya Isakali. ");
INSERT INTO vid_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","Nhambiko ya heye nayali luhelo lumwe lugongomanyigwe kwa sendi na luwele na itunyo lya kilo imwe na nusu na chisaye chimwe chigongomanyigwe kwa sendi chiwele na itunyo lya gilamu miya nane kwa kuwinza chipimilo cha ihema lya Nguluwi. Luhelo na chisaye navyali vimemezwe utimbo unojile uhanzigwe na mafuta kwa chiwalo cha nhambiko ya nyhule. ");
INSERT INTO vid_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","Kahi nakegala chisaye chimwe cha zahabu chiwele na itunyo lya gilamu miya imwe na kumi chiwele chimemezwe ubani ");
INSERT INTO vid_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","na ilogota ilume limwe na ing'holo lilume limwe na ing'holo lyana lilume limwe lya mwaka umwe kwa chiwalo cha nhambiko ya kulakazwa, ");
INSERT INTO vid_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","na ipongo limwe kwa chiwalo cha nhambiko ya gehile, ");
INSERT INTO vid_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","na misenga milume mili na ming'holo milume jihano na mipongo jihano na ming'holo myana milume jihano ja mwaka umwe kwa chiwalo cha nhambiko ya kikala goya. Ayo ndo iwele nhambiko ya Netaneli, mwana wa Suali. ");
INSERT INTO vid_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","Zuwa lya kadatu nayali Eliabu mwana wa Heloni, chilongozi wa nhanzi ya Sebuluni. ");
INSERT INTO vid_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","Nhambiko ya heye nayali luhelo lumwe lugongomanyigwe kwa sendi na luwele na itunyo lya kilo imwe na nusu na chisaye chimwe chigongomanyigwe kwa sendi chiwele na itunyo lya gilamu miya nane kwa kuwinza chipimilo cha ihema lya Nguluwi. Luhelo na chisaye navyali vimemezwe utimbo unojile uhanzigwe na mafuta kwa chiwalo cha nhambiko ya nyhule. ");
INSERT INTO vid_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","Kahi nakegala chisaye chimwe cha zahabu chiwele na itunyo lya gilamu miya imwe na kumi chiwele chimemezwe ubani ");
INSERT INTO vid_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","na ilogota ilume limwe na ing'holo lilume limwe na ing'holo lyana lilume limwe lya mwaka umwe kwa chiwalo cha nhambiko ya kulakazwa, ");
INSERT INTO vid_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","na ipongo limwe kwa chiwalo cha nhambiko ya gehile, ");
INSERT INTO vid_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","na misenga milume mili na ming'holo milume jihano na mipongo jihano na ming'holo myana milume jihano ja mwaka umwe kwa chiwalo cha nhambiko ya kikala goya. Ayo ndo iwele nhambiko ya Eliabu, mwana wa Heloni. ");
INSERT INTO vid_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","Zuwa lya kane nayali Elisuli mwana wa Shedeuli, chilongozi wa nhanzi ya Lubeni. ");
INSERT INTO vid_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","Nhambiko ya heye nayali luhelo lumwe lugongomanyigwe kwa sendi na luwele na itunyo lya kilo imwe na nusu na chisaye chimwe chigongomanyigwe kwa sendi chiwele na itunyo lya gilamu miya nane kwa kuwinza chipimilo cha ihema lya Nguluwi. Luhelo na chisaye navyali vimemezwe utimbo unojile uhanzigwe na mafuta kwa chiwalo cha nhambiko ya nyhule. ");
INSERT INTO vid_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","Kahi nakegala chisaye chimwe cha zahabu chiwele na itunyo lya gilamu miya imwe na kumi chiwele chimemezwe ubani ");
INSERT INTO vid_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","na ilogota ilume limwe na ing'holo lilume limwe na ing'holo lyana lilume limwe lya mwaka umwe kwa chiwalo cha nhambiko ya kulakazwa, ");
INSERT INTO vid_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","na ipongo limwe kwa chiwalo cha nhambiko ya gehile, ");
INSERT INTO vid_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","na misenga milume mili na ming'holo milume jihano na mipongo jihano na ming'holo myana milume jihano ja mwaka umwe kwa chiwalo cha nhambiko ya kikala goya. Ayo ndo iwele nhambiko ya Elisuli, mwana wa Shedeuli. ");
INSERT INTO vid_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","Zuwa lya kahano nayali Shelumieli mwana wa Suli-shadai, chilongozi wa nhanzi ya Simeoni. ");
INSERT INTO vid_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","Nhambiko ya heye nayali luhelo lumwe lugongomanyigwe kwa sendi na luwele na itunyo lya kilo imwe na nusu na chisaye chimwe chigongomanyigwe kwa sendi chiwele na itunyo lya gilamu miya nane kwa kuwinza chipimilo cha ihema lya Nguluwi. Luhelo na chisaye navyali vimemezwe utimbo unojile uhanzigwe na mafuta kwa chiwalo cha nhambiko ya nyhule. ");
INSERT INTO vid_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","Kahi nakegala chisaye chimwe cha zahabu chiwele na itunyo lya gilamu miya imwe na kumi chiwele chimemezwe ubani ");
INSERT INTO vid_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","na ilogota ilume limwe na ing'holo lilume limwe na ing'holo lyana lilume limwe lya mwaka umwe kwa chiwalo cha nhambiko ya kulakazwa, ");
INSERT INTO vid_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","na ipongo limwe kwa chiwalo cha nhambiko ya gehile, ");
INSERT INTO vid_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","na misenga milume mili na ming'holo milume jihano na mipongo jihano na ming'holo myana milume jihano ja mwaka umwe kwa chiwalo cha nhambiko ya kikala goya. Ayo ndo iwele nhambiko ya Shelumieli, mwana wa Suli-shadai. ");
INSERT INTO vid_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","Zuwa lya sita nayali Eliasafu mwana wa Deueli, chilongozi wa nhanzi ya Gadi. ");
INSERT INTO vid_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","Nhambiko ya heye nayali luhelo lumwe lugongomanyigwe kwa sendi na luwele na itunyo lya kilo imwe na nusu na chisaye chimwe chigongomanyigwe kwa sendi chiwele na itunyo lya gilamu miya nane kwa kuwinza chipimilo cha ihema lya Nguluwi. Luhelo na chisaye navyali vimemezwe utimbo unojile uhanzigwe na mafuta kwa chiwalo cha nhambiko ya nyhule. ");
INSERT INTO vid_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","Kahi nakegala chisaye chimwe cha zahabu chiwele na itunyo lya gilamu miya imwe na kumi chiwele chimemezwe ubani ");
INSERT INTO vid_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","na ilogota ilume limwe na ing'holo lilume limwe na ing'holo lyana lilume limwe lya mwaka umwe kwa chiwalo cha nhambiko ya kulakazwa, ");
INSERT INTO vid_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","na ipongo limwe kwa chiwalo cha nhambiko ya gehile, ");
INSERT INTO vid_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","na misenga milume mili na ming'holo milume jihano na mipongo jihano na ming'holo myana milume jihano ja mwaka umwe kwa chiwalo cha nhambiko ya kikala goya. Ayo ndo iwele nhambiko ya Eliasafu, mwana wa Deueli. ");
INSERT INTO vid_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","Zuwa lya saba nayali Elishama mwana wa Amihudi, chilongozi wa nhanzi ya Efulaimu. ");
INSERT INTO vid_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","Nhambiko ya heye nayali luhelo lumwe lugongomanyigwe kwa sendi na luwele na itunyo lya kilo imwe na nusu na chisaye chimwe chigongomanyigwe kwa sendi chiwele na itunyo lya gilamu miya nane kwa kuwinza chipimilo cha ihema lya Nguluwi. Luhelo na chisaye navyali vimemezwe utimbo unojile uhanzigwe na mafuta kwa chiwalo cha nhambiko ya nyhule. ");
INSERT INTO vid_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","Kahi nakegala chisaye chimwe cha zahabu chiwele na itunyo lya gilamu miya imwe na kumi chiwele chimemezwe ubani ");
INSERT INTO vid_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","na ilogota ilume limwe na ing'holo lilume limwe na ing'holo lyana lilume limwe lya mwaka umwe kwa chiwalo cha nhambiko ya kulakazwa, ");
INSERT INTO vid_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","na ipongo limwe kwa chiwalo cha nhambiko ya gehile, ");
INSERT INTO vid_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","na misenga milume mili na ming'holo milume jihano na mipongo jihano na ming'holo myana milume jihano ja mwaka umwe kwa chiwalo cha nhambiko ya kikala goya. Ayo ndo iwele nhambiko ya Elishama, mwana wa Amihudi. ");
INSERT INTO vid_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","Zuwa lya nane nayali Gamalieli mwana wa Pedasuli, chilongozi wa nhanzi ya Manase. ");
INSERT INTO vid_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","Nhambiko ya heye nayali luhelo lumwe lugongomanyigwe kwa sendi na luwele na itunyo lya kilo imwe na nusu na chisaye chimwe chigongomanyigwe kwa sendi chiwele na itunyo lya gilamu miya nane kwa kuwinza chipimilo cha ihema lya Nguluwi. Luhelo na chisaye navyali vimemezwe utimbo unojile uhanzigwe na mafuta kwa chiwalo cha nhambiko ya nyhule. ");
INSERT INTO vid_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","Kahi nakegala chisaye chimwe cha zahabu chiwele na itunyo lya gilamu miya imwe na kumi chiwele chimemezwe ubani ");
INSERT INTO vid_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","na ilogota ilume limwe na ing'holo lilume limwe na ing'holo lyana lilume limwe lya mwaka umwe kwa chiwalo cha nhambiko ya kulakazwa, ");
INSERT INTO vid_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","na ipongo limwe kwa chiwalo cha nhambiko ya gehile, ");
INSERT INTO vid_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","na misenga milume mili na ming'holo milume jihano na mipongo jihano na ming'holo myana milume jihano ja mwaka umwe kwa chiwalo cha nhambiko ya kikala goya. Ayo ndo iwele nhambiko ya Gamalieli, mwana wa Pedasuli. ");
INSERT INTO vid_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","Zuwa lya tisa nayali Abidani mwana wa Gideoni, chilongozi wa nhanzi ya Benjamini. ");
INSERT INTO vid_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","Nhambiko ya heye nayali luhelo lumwe lugongomanyigwe kwa sendi na luwele na itunyo lya kilo imwe na nusu na chisaye chimwe chigongomanyigwe kwa sendi chiwele na itunyo lya gilamu miya nane kwa kuwinza chipimilo cha ihema lya Nguluwi. Luhelo na chisaye navyali vimemezwe utimbo unojile uhanzigwe na mafuta kwa chiwalo cha nhambiko ya nyhule. ");
INSERT INTO vid_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","Kahi nakegala chisaye chimwe cha zahabu chiwele na itunyo lya gilamu miya imwe na kumi chiwele chimemezwe ubani ");
INSERT INTO vid_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","na ilogota ilume limwe na ing'holo lilume limwe na ing'holo lyana lilume limwe lya mwaka umwe kwa chiwalo cha nhambiko ya kulakazwa, ");
INSERT INTO vid_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","na ipongo limwe kwa chiwalo cha nhambiko ya gehile, ");
INSERT INTO vid_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","na misenga milume mili na ming'holo milume jihano na mipongo jihano na ming'holo myana milume jihano ja mwaka umwe kwa chiwalo cha nhambiko ya kikala goya. Ayo ndo iwele nhambiko ya Abidani, mwana wa Gideoni. ");
INSERT INTO vid_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","Zuwa lya kumi nayali Ahieseli mwana wa Amishadai, chilongozi wa nhanzi ya Dani. ");
INSERT INTO vid_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","Nhambiko ya heye nayali luhelo lumwe lugongomanyigwe kwa sendi na luwele na itunyo lya kilo imwe na nusu na chisaye chimwe chigongomanyigwe kwa sendi chiwele na itunyo lya gilamu miya nane kwa kuwinza chipimilo cha ihema lya Nguluwi. Luhelo na chisaye navyali vimemezwe utimbo unojile uhanzigwe na mafuta kwa chiwalo cha nhambiko ya nyhule. ");
INSERT INTO vid_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","Kahi nakegala chisaye chimwe cha zahabu chiwele na itunyo lya gilamu miya imwe na kumi chiwele chimemezwe ubani ");
INSERT INTO vid_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","na ilogota ilume limwe na ing'holo lilume limwe na ing'holo lyana lilume limwe lya mwaka umwe kwa chiwalo cha nhambiko ya kulakazwa, ");
INSERT INTO vid_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","na ipongo limwe kwa chiwalo cha nhambiko ya gehile, ");
INSERT INTO vid_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","na misenga milume mili na ming'holo milume jihano na mipongo jihano na ming'holo myana milume jihano ja mwaka umwe kwa chiwalo cha nhambiko ya kikala goya. Ayo ndo iwele nhambiko ya Ahieseli, mwana wa Amishadai. ");
INSERT INTO vid_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","Zuwa lya kumi na imwe nayali Pagieli mwana wa Okilani, chilongozi wa nhanzi ya Asheli. ");
INSERT INTO vid_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","Nhambiko ya heye nayali luhelo lumwe lugongomanyigwe kwa sendi na luwele na itunyo lya kilo imwe na nusu na chisaye chimwe chigongomanyigwe kwa sendi chiwele na itunyo lya gilamu miya nane kwa kuwinza chipimilo cha ihema lya Nguluwi. Luhelo na chisaye navyali vimemezwe utimbo unojile uhanzigwe na mafuta kwa chiwalo cha nhambiko ya nyhule. ");
INSERT INTO vid_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","Kahi nakegala chisaye chimwe cha zahabu chiwele na itunyo lya gilamu miya imwe na kumi chiwele chimemezwe ubani ");
INSERT INTO vid_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","na ilogota ilume limwe na ing'holo lilume limwe na ing'holo lyana lilume limwe lya mwaka umwe kwa chiwalo cha nhambiko ya kulakazwa, ");
INSERT INTO vid_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","na ipongo limwe kwa chiwalo cha nhambiko ya gehile, ");
INSERT INTO vid_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","na misenga milume mili na ming'holo milume jihano na mipongo jihano na ming'holo myana milume jihano ja mwaka umwe kwa chiwalo cha nhambiko ya kikala goya. Ayo ndo iwele nhambiko ya Pagieli, mwana wa Okilani. ");
INSERT INTO vid_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","Zuwa lya kumi na mbili nayali Ahila mwana wa Enani, chilongozi wa nhanzi ya Nafutali. ");
INSERT INTO vid_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","Nhambiko ya heye nayali luhelo lumwe lugongomanyigwe kwa sendi na luwele na itunyo lya kilo imwe na nusu na chisaye chimwe chigongomanyigwe kwa sendi chiwele na itunyo lya gilamu miya nane kwa kuwinza chipimilo cha ihema lya Nguluwi. Luhelo na chisaye navyali vimemezwe utimbo unojile uhanzigwe na mafuta kwa chiwalo cha nhambiko ya nyhule. ");
INSERT INTO vid_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","Kahi nakegala chisaye chimwe cha zahabu chiwele na itunyo lya gilamu miya imwe na kumi chiwele chimemezwe ubani ");
INSERT INTO vid_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","na ilogota ilume limwe na ing'holo lilume limwe na ing'holo lyana lilume limwe lya mwaka umwe kwa chiwalo cha nhambiko ya kulakazwa, ");
INSERT INTO vid_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","na ipongo limwe kwa chiwalo cha nhambiko ya gehile, ");
INSERT INTO vid_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","na misenga milume mili na ming'holo milume jihano na mipongo jihano na ming'holo myana milume jihano ja mwaka umwe kwa chiwalo cha nhambiko ya kikala goya. Ayo ndo iwele nhambiko ya Ahila, mwana wa Enani. ");
INSERT INTO vid_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","Ndolendole zeng'ha za nhambiko za vilongozi wa Isilaeli kwa chiwalo cha honhu ha kulavila nhambiko kuli zuwa lya kubakalizwa mafuta, nyhelo kumi na mbili zigongomanyigwe kwa sendi nyinji na visaye kumi na vili vigongomanyigwe kwa sendi nyinji na visaye vya zahabu kumi na vili. ");
INSERT INTO vid_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","Chila chisaye chigongomanyigwe kwa sendi, nachali na itunyo lya kilo imwe na nusu na chila chisaye nachali na itunyo lya gilamu miya nane. Avyo vinhu vyeng'ha navyali na itunyo lya kilo makumi meli na saba na gilamu miya sita kwa kuwinza chipimilo cha ihema lya Nguluwi. ");
INSERT INTO vid_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","Zila nyhelo zigongomanyigwe kwa zahabu kumi na mbili ziwele zimemile ubani, chila imwe iwele na itunyo lya gilamu miya imwe na kumi kwa kuwinza chipimilo cha ihema lya Nguluwi, vyeng'ha navyali na itunyo lya kilo imwe na gilamu miya zidatu na makumi meli. ");
INSERT INTO vid_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","Migongolo jeng'ha ja nhambiko ya kulakazwa najali milogota milume kumi na mili na ming'holo milume kumi na mili hamwe na nhambiko ya nyhule na mipongo kumi na mili kwa chiwalo cha nhambiko ya gehile, ");
INSERT INTO vid_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","na kwa chiwalo cha nhambiko ya kikala goya. Migongolo jilavigwe najali mibuguma makumi meli na jine na ming'holo milume makumi sita na mibebelu makumi sita na ming'holo myana milume ja mwaka umwe, makumi sita. Ayo ndo nayali nhambiko ilavigwe kwa chiwalo cha honhu ha kulavila nhambiko nalohamalile kubakalizwa mafuta. ");
INSERT INTO vid_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","Mhela Musa vyoyenjile mgati mwa ihema lya Nguluwi leka yadawale na Mkulu Nguluwi, nakahulika lizi lilawila kuchanya kwa chigubiko cha uhanyisi, chiwele mchanya mwa isanduku lya ilagano, kulawila hagati mwa vila vilumbigwe vili vifandile kota wahilisi. Lelo, nakadawala na heye. ");
INSERT INTO vid_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","Mkulu Nguluwi nakamlonjela Musa, ");
INSERT INTO vid_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","“Mlonjele Aluni kota mhela hoyowika vila vyenje saba kuli chinhu cha kuwichila vyenje, yaviwiche goya leka vimwemwesele ubanzi wa kumwando.” ");
INSERT INTO vid_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","Aluni nakadita ago, nakaviwika vyenje avyo leka vimwemwesele ubanzi wa kumwando mwa chinhu cha kuwichila vyenje, kota Mkulu Nguluwi vyoyamlajize Musa. ");
INSERT INTO vid_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","Chinhu acho cha kuwichila vyenje nachali chigongomanyigwe kwa uwanzi ukulu kwa zahabu, ipondigwe kulawila kuli chikalilo mbaka kuli uluwa, kota Mkulu Nguluwi navyoyamlajize Musa. ");
INSERT INTO vid_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","Kahi Mkulu Nguluwi nakamlonjela Musa, ");
INSERT INTO vid_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","“Wabagule Walawi kulawila Waisilaeli, uwelize. ");
INSERT INTO vid_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","Ahi ndo vyouweliza, wamizile mazi ga kuwelizila na uwalonjele webeye mnvili lukuli lweng'ha na wahovuje mivalo ja hewo leka welizwe. ");
INSERT INTO vid_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","Hamba wolavya ilogota ilume limwe hamwe na nhambiko ya heye ya nyhule, iwele ndo utimbo unojile uhanzigwe na mafuta, nagwe kolavya ilogota ilume liyage kwa chiwalo cha nhambiko ya gehile. ");
INSERT INTO vid_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","Hamba kokungajiza Waisilaeli weng'ha na kuwegala Walawi hali ihema lya Nguluwi. ");
INSERT INTO vid_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","Houwegala Walawi hali heni Mkulu Nguluwi, Waisilaeli wowawichila moko Walawi, ");
INSERT INTO vid_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","hamba Aluni kowalavya awo Walawi hali heni Mkulu Nguluwi kota ndolendole ya chiuyeng'ha kulawila kwa Waisilaeli wang'holele mijito. ");
INSERT INTO vid_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","Hamba Walawi wowika moko ga hewo mchanya mwa mitwi ja mibuguma ajo, limwe kolilavya liwe nhambiko ya gehile na alyo liyage kolilavya liwe nhambiko ya kulakazwa ilavigwe kwa heni Mkulu Nguluwi, leka kuwaditila uhanyisi Walawi. ");
INSERT INTO vid_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","“Hamba, kowemiza Walawi hali Aluni na wanage na kuwalavya hali heni Mkulu Nguluwi kota ndolendole ya chiuyeng'ha. ");
INSERT INTO vid_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","Ahi ndo vyouwabagula Walawi hali Waisilaeli leka wawe wa heni. ");
INSERT INTO vid_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","Housinda kuweliza Walawi na kuwalavya kota ndolendole ya chiuyeng'ha, wokwinjila mli ihema lya Nguluwi. ");
INSERT INTO vid_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","Hewo wawichigwa wawe wa heni ng'hatu, ndiwahola hewo honhu ha walelwa wa mwaluko wa Isilaeli. ");
INSERT INTO vid_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","Mina walelwa weng'ha wa mwaluko kuli wanhu wa Isilaeli ndo wa heni, wanhu na migongolo, kwa vila kuli mazuwa ga mwaluko londiwakopole walelwa weng'ha wa mwaluko kuli isi ya Misili, nandiwawika chiuyeng'ha kwa chiwalo cha heni. ");
INSERT INTO vid_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","Sambi ndanguwahola Walawi honhu ha walelwa wa mwaluko wa Isilaeli, ");
INSERT INTO vid_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","na ndimha awo Walawi, Aluni na wanage kota ndolendole kulawila kwa Waisilaeli, leka wakole mijito kuli ihema lya Nguluwi kwa chiwalo cha Waisilaeli na kuwamila leka haleche kulawila igayo hali wanhu wa Isilaeli wone wohahejelela honhu helile.” ");
INSERT INTO vid_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","Ahyo, Musa na Aluni na Waisilaeli weng'ha, wowawika Walawi wawe wa chiuyeng'ha, kota Mkulu Nguluwi vyoyamlajize Musa. ");
INSERT INTO vid_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","Walawi naweweliza gehile ga hewo na kuhovuga nguwo za hewo, na heye Aluni nakawalavya kota ndolendole ya chiuyeng'ha hali Mkulu Nguluwi. Aluni kahi, nakadita uhanyisi kwa chiwalo cha kuweliza hewo. ");
INSERT INTO vid_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","Hamba Walawi nawenjila na kukola mijito ja hewo kuli ihema lya Nguluwi hali Aluni na wanage, kota Mkulu Nguluwi vyoyamlajize Musa kuwala awo Walawi, na ndo vyowawaditile. ");
INSERT INTO vid_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","Mkulu Nguluwi nakamlonjela Musa, ");
INSERT INTO vid_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","“Chila Mlawi yawele na miyaka makumi meli na gahano na mzidi, kokola mijito ja uchitumagwa kuli ihema lya Nguluwi ");
INSERT INTO vid_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","na koleka mijito ajo loyowa na miyaka makumi gahano. ");
INSERT INTO vid_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","Hamba kahi, koweza kuwatanza Walawi wayage kuli ihema lya Nguluwi kwa kulyamila, ila hambe yakundigwe kukola mijito yoneche. Ahyo ndo vyouwalajiza Walawi kukola mijito.” ");
INSERT INTO vid_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","Hamba, loufichile mwezi wa mwaluko wa mwaka wa keli hala Waisilaeli lowalawile Misili. Mkulu Nguluwi nakalongasa na Musa kuchiwala ako Sinai. Nakamlonjela, ");
INSERT INTO vid_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","“Waisilaeli wanguganigwa waidite mnvina ya Pasaka kuli mhela uwichigwe. ");
INSERT INTO vid_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","Ayi yowa zuwa lya kumi na kane lya mwezi awu, mhela wa kuzinga kwa isanya wodita ahyo kwa kuwinza mizilo na malajizo geng'ha.” ");
INSERT INTO vid_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","Ahyo, Musa nakawalonjela wanhu wa Isilaeli kota wangulapigwa kudita mnvina ya Pasaka. ");
INSERT INTO vid_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","Lelo nawaidita mnvina ya Pasaka mhela wa kuzinga kwa isanya, zuwa lya kumi na kane lya mwezi wa mwaluko kuchiwala ako Sinai. Waisilaeli nawadita geng'ha kota Mkulu Nguluwi vyoyamlajize Musa. ");
INSERT INTO vid_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","Ila wanhu wamwe nawawele hala nawalemwela kulya chilyo cha Pasaka ayo kwa vila nawali wadolize mtufi, nawawa wakokomoche. Awo nawawalutila Musa na Aluni, ");
INSERT INTO vid_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","Wawalonjela, “Hetwe twa wanhu wakokomoche kwa vila natudoliza mtufi, lelo lekachoni tulemezwe kumlavila Mkulu Nguluwi nhambiko za heye kwa mhela uwichigwe hamwe na Waisilaeli wanji?” ");
INSERT INTO vid_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","Musa nakawedichila, “Mbeteze mbaka hala hondipegwa malajizo ga kuwawala hemwe kulawila kwa Mkulu Nguluwi.” ");
INSERT INTO vid_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","Na heye Mkulu Nguluwi nakamlonjela Musa, ");
INSERT INTO vid_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","“Yumwe wa hemwe ama yumwe wa walelwa wa hemwe wone yawe yokokomoche kwa kudoliza mtufi ama yawe kutali mmajendo, ila yoweza kuidita mnvina ya Pasaka kwa Mkulu Nguluwi. ");
INSERT INTO vid_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","Munhu kota ayo kokundizwa kudita ahyo mwezi umwe hamba, mhela wa kuzinga kwa isanya kuli zuwa lya kumi na kane lya mwezi wa keli. Koidita kwa kulya mibumunda jilihela usaso na mboga ziwele usungu. ");
INSERT INTO vid_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","Waleche kusigaza chilyo choneche mbaka lufuku, kahi waleche kubena izeje ne limwe lya migongolo ja Pasaka. Woidita mnvina ayi ya pasaka kwa kuwinza malajizo galinguganigwa. ");
INSERT INTO vid_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","Ila yula munhu yoneche yelizwe ama hawele mmajendo, wone haiditile mnvina ya Pasaka, kobaguligwa na wanhu wa heye kwa vila handavile nhambiko Mkulu Nguluwi kwa mhela uganigwe. Koganigwa yagazigwe kwa chiwalo cha gehile ga heye. ");
INSERT INTO vid_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","“Wone hana mjenzi yalingikala behi na hemwe na kangugana kuidita mnvina ya Pasaka kwa Mkulu Nguluwi, munhu ayo koganigwa yadite ahyo kwa kuwinza malajizo geng'ha ga Pasaka. Chila munhu kowinza malajizo gagala galinguganigwa, yawe mjenzi ama mwenyeng'haye.” ");
INSERT INTO vid_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","Zuwa lila ihema lya Nguluwi loliwichigwe, ng'hungugu naidulika na kugubika ihema lya Nguluwi. Mhela wa kuzinga kwa isanya mbaka lufuku ng'hungugu ayo nayoneka kota chiluli. ");
INSERT INTO vid_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","Ahyo ndo vyonaiwele chila zuwa, ng'hungugu naigubika ihema nemisi, na nechilo nayoneka kota chiluli. ");
INSERT INTO vid_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","Chila mhela ng'hungugu yila chila loyinuligwe mchanya mwa ihema, Waisilaeli nawoka na kuza kuwika kambi honhu hanji yila ng'hungugu hoigwile. ");
INSERT INTO vid_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","Nawaheluka mmajendo kwa kulajizwa na Mkulu Nguluwi, wanhu wa Isilaeli nawawika kambi kahi kwa kulajizwa na Mkulu Nguluwi. Mhela weng'ha ng'hungugu ayo loyali mchanya mwa ihema, wanhu nawekala honhu aho. ");
INSERT INTO vid_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","Hanga yila ng'hungugu iwe yikale mchanya mwa ihema kwa mazuwa menji, Waisilaeli nawamhulichiza Mkulu Nguluwi, na hewo hawochile. ");
INSERT INTO vid_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","Mhela wunji ng'hungugu naikala mchanya mwa ihema lya Nguluwi kwa mhela wa mazuwa mado hela, ila chila mhela Waisilaeli nawapona bahala kuli kambi, nawoka hala Mkulu Nguluwi navyoyawalajize. ");
INSERT INTO vid_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","Mala yinji ng'hungugu naiwa mchanya mwa ihema lya Nguluwi kulawa matinazo mbaka mitondo. Ng'hungugu yila loyinuligwe nawenula majendo, hanga naiwele mchanya nemisi na nechilo, ng'hungugu loyinuligwe, nawenula majendo. ");
INSERT INTO vid_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","Wone iwe mazuwa meli ama mwezi ama mwaka ama mzidi, mhela weng'ha ng'hungugu loiwele mchanya mwa ihema lya Nguluwi, Waisilaeli hawochile, ila loyinuligwe na hewo nawoka. ");
INSERT INTO vid_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","Kwa kulajizwa na Mkulu Nguluwi nawawika kambi na kwa kulajizwa na Mkulu Nguluwi nawaheluka mmajendo. Nawebatilila ilajizo lya Mkulu Nguluwi kota navyoyalajize kwa kukolela Musa. ");
INSERT INTO vid_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","Mkulu Nguluwi nakamlonjela Musa, ");
INSERT INTO vid_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","“Ugongomanye mhalamhanda mbili kwa sendi, ziwele zipondigwe. Mhalamhanda azo mozikolela mijito ja kuwachema Waisilaeli weng'ha na kwa chiwalo cha kuka homuwichile kambi. ");
INSERT INTO vid_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","Mhalamhanda zeng'ha mbili wone zipembigwe hamwe, Waisilaeli weng'ha wochikungajiza hali hegwe hali lwizi lwa ihema lya Nguluwi. ");
INSERT INTO vid_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","Ila wone ipembigwe mhalamhanda imwe, aho vilongozi wa nhanzi ya Isilaeli yeka ndo wowa wolapigwa kikungajiza behi na hegwe. ");
INSERT INTO vid_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","Ulajilo awo wone ulavigwe kwa kupemba mhalamhanda hado hado kwa kulutilila, wenyeng'haye wa kambi za kolilawila isanya wokwaluka majendo. ");
INSERT INTO vid_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","Wone ulajilo awo utowigwe lwa keli, wala wawele kuli kambi za kusini wokwaluka kuka. Ulajilo awo wa mhalamhanda wotowigwa chila mhela wa kwaluka majendo. ");
INSERT INTO vid_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","Ila mhela wa kuwachema Waisilaeli weng'ha weting'hane hamwe, mhalamhanda zopembigwa kwa kulutilila lukami kota vyowazowele, ila zileche kupembigwa hado hado. ");
INSERT INTO vid_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","Walelwa walume wa Aluni, watambika, ndo wopemba mhalamhanda azo. Ilajizo ali moliwinza kuli lulelo wa hemwe weng'ha mazuwa gose. ");
INSERT INTO vid_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","“Mhela wa kitowa ngondo muisi ya hemwe na wang'honyo, molavya ulajilo kwa kupemba mhalamhanda azi hado hado leka Mkulu Nguluwi, Nguluwi wa hemwe yawakumbuche na kuwalohola na wala wang'honyo wa hemwe. ");
INSERT INTO vid_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","Hihila na mazuwa ga hemwe ga kusangalala, kota hila mnvina za kulawa kwa nyelezi na mnvina zinji, mopemba mhalamhanda azi mhela lomlavya nhambiko za hemwe za kulakaza na nhambiko za hemwe za kikala goya. Aho heni Mkulu Nguluwi wa hemwe ndowakumbukani. Heni nda Mkulu Nguluwi, Nguluwi wa hemwe.” ");
INSERT INTO vid_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","Loifichile zuwa lya makumi meli lya mwezi wa keli, mwaka wa keli kulawila Waisilaeli lowochile Misili, ng'hungugu iwele mchanya kuli ihema lya Nguluwi nayinuka, ");
INSERT INTO vid_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","na hewo Waisilaeli waluka majendo ga hewo kulawila kuli chiwala ako Sinai. Ng'hungugu ayo nayidulika kuli chiwala ako Palani. ");
INSERT INTO vid_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","Aho mwaluko Waisilaeli nawaluka majendo kota Mkulu Nguluwi vyoyamlajize Musa. ");
INSERT INTO vid_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","Wala wawele hali bendela ya chilundo cha nhanzi ya Yuda, nawalongola, chilundo chimwe hamba chiyage. Chilongozi wa hewo nayali Nashoni mwana wa Aminadabu. ");
INSERT INTO vid_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","Netaneli mwana wa Suali, nayali chilongozi wa chilundo cha nhanzi ya Isakali. ");
INSERT INTO vid_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","Na heye Eliabu mwana wa Heloni, nayali chilongozi wa chilundo cha nhanzi ya Sebuluni. ");
INSERT INTO vid_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","Hamba, ihema lya Nguluwi naliduliswa, na wanhu wa ng'holo za Gelishoni na za Melali ndo nawalipapile, nawaluka kuka. ");
INSERT INTO vid_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","Hamba, wanhu wonawali hali bendela ya chilundo chilongozwe na nhanzi ya Lubeni, nawawinza chilundo chimwe mbaka chiyage. Chilongozi wa hewo nayali Elisuli mwana wa Shedeuli. ");
INSERT INTO vid_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","Shelumieli mwana wa Suli-shadai, nakailongoza nhanzi ya Simeoni. ");
INSERT INTO vid_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","Eliasafu mwana wa Deueli, nakailongoza nhanzi ya Gadi. ");
INSERT INTO vid_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","Hamba nawawawinza wanhu wa lukolo lwa Kohati, nawali wapapile vinhu vyelile. Lowafichile, ihema lya Nguluwi nalyali liwichigwe goya. ");
INSERT INTO vid_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","Kumbele kwa hewo, nawawinza wanhu wawele hali bendela ya chilundo chilongozwe na nhanzi ya Efulaimu, chilundo chimwe kumbele kwa chiyage. Chilongozi wa hewo nayali Elishama, mwana wa Amihudi. ");
INSERT INTO vid_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","Gamalieli mwana wa Pedasuli nakailongoza nhanzi ya Manase, ");
INSERT INTO vid_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","na heye Abidani mwana wa Gideoni, nakailongoza nhanzi ya Benjamini. ");
INSERT INTO vid_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","Mwiso, wala wawele hali bendela ya chilundo chilongozwe na nhanzi ya Dani, wawele wokwamila kumbele mwa vilundo vyeng'ha, nawaluka majendo, chilundo chimwe kumbele kwa chiyage. Awa nawalongozwa na Ahieseli mwana wa Amishadai. ");
INSERT INTO vid_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","Pagieli, mwana wa Okilani, nakailongoza nhanzi ya Asheli. ");
INSERT INTO vid_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","Ahila mwana wa Enani, nakailongoza nhanzi ya Nafutali. ");
INSERT INTO vid_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","Ahi lelo, ndo Waisilaeli navyowawele mmajendo na ndo vyowewichile goya kuli vilundo vya hewo, chila mhela lowaluche majendo. ");
INSERT INTO vid_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","Musa nakamlonjela Hobabu mwana wa Leueli, mgosi wa heye Mmidiani, “Hetwe twangwaluka majendo kuluta honhu hawele Mkulu Nguluwi nakalonga, ‘Ndowapani hemwe honhu aho.’ Lelo tulute hamwe, natwe tokuditila ganojile, mina Mkulu Nguluwi nakalonga kotupa hetwe Waisilaeli utambichizo.” ");
INSERT INTO vid_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","Ila Hobabu nakalonga, “Heni hatuchiwinza na hemwe, ila ndohiluka kuli isi ya heni na kwa nhanzi ya heni.” ");
INSERT INTO vid_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","Musa nakamlonjela, “Ndangulanda uleche kutuleka, mina hegwe kuvizela honhu hotuweza kuwasa hagunuche, na koweza kutulongoza nzila. ");
INSERT INTO vid_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","Wone koluta hamwe na hetwe, choneche chinojile choyotuditila Mkulu Nguluwi, ndo chicho tokuditila na hegwe nagwe.” ");
INSERT INTO vid_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","Lelo wanhu nawaluka majendo kulawila Sinai, chidunda cha Mkulu Nguluwi, majendo ga mazuwa gadatu. Isanduku lya ilagano lya Mkulu Nguluwi naliwalongola leka kuwapalila honhu ha kuwasa. ");
INSERT INTO vid_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","Chila lowaluche majendo kulawa kowawichile kambi imwe mbaka iyage, ng'hungugu ya Mkulu Nguluwi nayali mchanya mwa hewo nemisi. ");
INSERT INTO vid_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","Chila mhela isanduku holyaluche majendo kuluta kumwando, Musa nakalonga, “Winuche, gwa Mkulu Nguluwi, wang'honyo wa hegwe wasambaluche, na awo walingukuzudila wakubilime kulawa hali hegwe.” ");
INSERT INTO vid_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","Chila mhela vyolimile, Musa nakalonga, “Uwahiluchile, gwa Mkulu Nguluwi, wano maelufu na maelufu ga Isilaeli.” ");
INSERT INTO vid_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","Wanhu nawaluka kumng'ung'utila Mkulu Nguluwi kwa gala magazo ga hewo. Mkulu Nguluwi navyoyahuliche, nayali yazudile, nakawahilichila chiluli. Chiluli acho nachali chikwaka hali hewo na kuwifya nzingo imwe ya yila kambi. ");
INSERT INTO vid_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","Wanhu nawamlilila Musa, na heye nakamlanda Mkulu Nguluwi na chiluli acho nachizima. ");
INSERT INTO vid_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","Lelo honhu aho hochemigwa Tabela, kwa vila acho chiluli cha Mkulu Nguluwi nachali chikwaka hali wanhu wamwe. ");
INSERT INTO vid_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","Hali Waisilaeli nakwali na chilundo chiyage chihanzile na hewo, nachali na maya lukami. Waisilaeli kwa mala iyage nawalila, wolonga. “Wone natwahawele na miwunde ja kulya! ");
INSERT INTO vid_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","Twangukumbuchila somba zotudile kula Misili ne kugula, matango na mitikiti na mboga na vitunguu na vitunguu saumu. ");
INSERT INTO vid_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","Ila sambi ludali lumala na kuduhu ndiya iyage ila ayi mana hela!” ");
INSERT INTO vid_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","Mana nayali kota nyhule za uhemba, lanji yake nayali nzelu hado. ");
INSERT INTO vid_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","Wanhu nawazunguluta zunguluta na kukungajiza, hamba nawazibalasa kwa maganga ga kubalasila ama kuzitwanga kwa ituli, hamba nawatogosa mchiya na kugongomanya mibumunda. Unojenoje wake nawali kota wa mibumunda jikalanjigwe kwa mafuta. ");
INSERT INTO vid_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","Nhungwi vyoyigwile kuli kambi mhela wa nechilo, mana kahi nayigwa hamwe na ayo nhungwi. ");
INSERT INTO vid_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","Musa nakahulika wanhu wolila kuli ng'holo zeng'ha, chila munhu hali lwizi lwa ihema lya heye. Lelo Mkulu Nguluwi nakazudila ng'hatu na heye Musa nakagaya mnhumbula ya heye. ");
INSERT INTO vid_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","Aho ndo Musa navyoyamlonjele Mkulu Nguluwi, “Lekachoni ulingunditila vibi heni chitumagwa wa hegwe? Lekachoni hambe umhe heni uganililo ila kumha heni itunyo lya kuwalolela wanhu weng'ha wano? ");
INSERT INTO vid_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","Ndaze, ndo heni ndiwapondile, na kundonjela ndiwapape mmhambaga ya heni kota mamo yalingupapa chali cha heye na kuwegala mbaka kuli isi youwalahile kuwapa wasekulu wa hewo? ");
INSERT INTO vid_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","Ndopata kohi miunde ja kuwalisa wanhu awa weng'ha? Mina wangulila hali heni wolonga, ‘Utugalile miwunde tulye!’ ");
INSERT INTO vid_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","Siweza hebu kuwalolela wanhu awa weng'ha ndiliyeka, alyo ndo itunyo likulu ng'hatu kwa heni. ");
INSERT INTO vid_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","Wone iwe ahyo ndo vyoulingundita, fola ung'hopole hela. Wone mhegwe uganililo hali hegwe, lelo undavile magazo aga.” ");
INSERT INTO vid_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","Lelo Mkulu Nguluwi nakamlonjela Musa, “Muwakungajize wasekulu makumi saba wa Isilaeli, wawele hegwe kuwazela kota wangukundigwa na wanhu wawe vilongozi, uwegale kuli ihema lya Nguluwi, weme habehi na hegwe. ");
INSERT INTO vid_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","Ndodulika ako na kulongasa na hegwe, ndohola honhu ha muhe wondikupele, ndiwape wanhu awo. Na hewo wopapa itunyo lya kuwalolela wanhu awo hamwe na hegwe, leka uleche kupapa itunyo alyo uliyeka. ");
INSERT INTO vid_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","Lelo uwalonjele wanhu kota wewelize kwa vila hamitondo molya miwunde. Mkulu Nguluwi nakahulika mlila na kulonga kota haduhuli wa kuwapa miwunde, na kota hemwe namwali mulya vinojile ng'hatu lomwali Misili. Lelo Mkulu Nguluwi kowapani miwunde, na hemwe yanguwalapani mulye. ");
INSERT INTO vid_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","Molya miwunde haiwele kwa zuwa limwe hela ama mazuwa meli ama gahano ama kuli mazuwa makumi meli, ");
INSERT INTO vid_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","ila kwa mhela wa mwezi umwe. Molya mbaka jowalawila kumhenyhelo na kujizudila. Geng'ha ago ndo kwa vila mumlema Mkulu Nguluwi yawele bahano hali hemwe, na kulila hali heye mlonga, ‘Lekachoni natulawa Misili?’ ” ");
INSERT INTO vid_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","Ila Musa nakamlonjela Mkulu Nguluwi, “Winji wa wanhu ndilinguwalongoza hano ndo lachi sita walingujenda kwa magulu, na hegwe kwangulonga, ‘Ndowapani miwunde ja kuhega mwezi weng'ha!’ ");
INSERT INTO vid_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","Ndaze, kudumuligwa singo ing'holo na isenga johega? Ndaze, somba zeng'ha mbahali zilowigwe kwa chiwalo cha hewo?” ");
INSERT INTO vid_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","Mkulu Nguluwi nakamwidichila Musa, “Ndaze, ludali lwa heni lupunguka? Kokona lelo ulonzi wa heni wowa wa kukomya kwa hegwe ama hebu.” ");
INSERT INTO vid_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","Lelo Musa nakaluta na kuwalonjela wanhu gala goyalonjile Mkulu Nguluwi. Hamba, nakawakungajiza wasekulu makumi saba kulawila kuli wala wasekulu vilongozi wa hewo, nakawawika hafungo kuzunguluta ihema. ");
INSERT INTO vid_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","Aho, Mkulu Nguluwi nakadulika kuli ng'hungugu na kulongasa na heye. Hamba nakalavya honhu ha muhe wonayampele Musa, nakamha chila yumwe wa wala wasekulu makumi saba. Lowenjilwe na muhe awo, wasekulu awo nawaluka kulonga kota waloli, ila hawahiluchile kudita ahyo. ");
INSERT INTO vid_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","Wasekulu weli hali wala makumi saba wahaguligwe, Elidadi na Medadi, nawali waponile kuli kambi, wayawo nalowalutile kuli ihema. Muhe nauwoyela mumo kuli ihema, nawaluka kulonga kota waloli honhu howawele. ");
INSERT INTO vid_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","Msongolo yumwe nakalawa yobilima na kumlonjela Musa, “Elidadi na Medadi wangulonga kota waloli kuli kambi.” ");
INSERT INTO vid_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","Aho, Yoshua, mwana wa Nuni, nayawele yomtanza Musa kulawila usongolo wa heye, nakamlonjela Musa, “Mkulu wa heni, walemeze.” ");
INSERT INTO vid_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","Ila Musa nakamlonjela, “Ndaze, kwangona fihi kwa chiwalo cha heni? Ila ndahaganile wone Mkulu Nguluwi nayawapele wanhu wa heye weng'ha muhe wa heye na hewo nawalonga kota waloli.” ");
INSERT INTO vid_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","Hamba Musa nakahiluka kuli kambi hamwe na wala wasekulu wa Isilaeli. ");
INSERT INTO vid_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","Hamba Mkulu Nguluwi nekegala mbeho baho du, naigala ng'wale kulawa mbahali na kuwadita wagwe hafungo ha yila kambi, majendo ga zuwa imwe ahi chila ubanzi kuzunguluta kambi, nawelunda hasi habehi mita imwe ahi kuluta kuchanya. ");
INSERT INTO vid_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","Lelo zuwa alyo lyeng'ha, na zuwa lilinguya wanhu nawakola mijito ja kukungajiza ng'wale, kuduhuli munhu yakungajize hasi ha kilo elufu imwe. Nawaziwika hali isanya chila honhu hafungo mwa kambi leka zikale. ");
INSERT INTO vid_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","Lokuwele kung'hali na miwunde kwa winji wanhu nawawele wang'hali kusinda kulya, Mkulu Nguluwi nakawazudila wanhu, nakawatowa kwa igayo ikulu ng'hatu. ");
INSERT INTO vid_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","Ahyo honhu aho nahapegwa itagwa Kibuloti-hataava, kwa vila ako ndo kowawatilile wanhu wawele na maya lukami. ");
INSERT INTO vid_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","Kulawila ako Kibuloti-hataava, wanhu nawaluka majendo mbaka Haseloti, nawawika kambi na kikala ako. ");
INSERT INTO vid_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","Hamba Miliamu na Aluni nawaluka kumlonga vibi Musa kwa chiwalo cha mdala Mkushi yonayali yamhesile. ");
INSERT INTO vid_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","Nawalonga, “Hambi Mkulu Nguluwi nakalonga kwa kukolela Musa yaliyeka? Ndaze, halonjile kwa kukolela hetwe tweng'ha?” Mkulu Nguluwi nakahulika ulonzi awo. ");
INSERT INTO vid_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","Musa nayali munhu yaholondale lukami kusinda wanhu wanji wawele muisi. ");
INSERT INTO vid_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","Baho du, Mkulu Nguluwi nakawalonjela Musa na Aluni na Miliamu, “Mlawe, muye hali ihema lya Nguluwi, hemwe wadatu.” Lelo weng'ha wadatu nawaluta kuli ihema lya Nguluwi. ");
INSERT INTO vid_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","Aho Mkulu Nguluwi nakadulika kuli izengo lya ng'hungugu, nakema hali lwizi lwa ihema, nakawachema Aluni na Miliamu. Weng'ha weli nawahejela kumwando. ");
INSERT INTO vid_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","Hamba Mkulu Nguluwi nakawalonjela, “Muhulichize ulonzi wa heni. Wone hana mloli hali hemwe, heni Mkulu Nguluwi ndizelesaga kwa heye kuli uloli na kulongasa na heye kuli kulota. ");
INSERT INTO vid_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","Ila kwa chitumagwa wa heni Musa, haiwa ahyo kwa vila heye ndo wa kukundigwa kuli ng'handa ya heni yeng'ha. ");
INSERT INTO vid_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","Heni ndangulonga na heye hazelu ne uviso. Heye kangumbona vyondili heni Mkulu Nguluwi. Lekachoni, lelo hamdumbile kumlonga vibi Musa, chitumagwa wa heni?” ");
INSERT INTO vid_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","Aho Mkulu Nguluwi nayali na ng'halazi kwa chiwalo cha hewo, nakoka. ");
INSERT INTO vid_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","Ng'hungugu vyoyuchile mchanya mwa ihema lya Nguluwi, Miliamu nakoneka kana utamwa wa ngozi wa lanji nzelu chwee. Aluni loyahinduche na kumlola Miliamu, nakabubuwala kona kota kana utamwa wa ngozi. ");
INSERT INTO vid_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","Aho Aluni nakamlonjela Musa, “Gwa mkulu wa heni, uleche kutugaza kwa vila natudita mbuli ya chipoka na kudita gehile. ");
INSERT INTO vid_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","Uleche kumdita Miliamu yawe kota mwana yapondigwe kuno yabagame, yawele nusu ya lukuli lwa heye lolile.” ");
INSERT INTO vid_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","Musa nakamlilila Mkulu Nguluwi yolonga, “Ndangukulonjela, gwa Nguluwi, umlohole!” ");
INSERT INTO vid_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","Ila Mkulu Nguluwi nakamlonjela Musa, “Hanji wone mhaza wa heye nayamtemele mite kumeho, ndaze, halingona soni kwa mazuwa saba? Lelo mlavye kunze mwa kambi yekale ako kwa mhela wa mazuwa saba, hamba komkundiza yahiluche kuli ihema.” ");
INSERT INTO vid_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","Ahyo, Miliamu nakawinjigwa kunze mwa kambi kwa mhela wa mazuwa saba. Wanhu hawaluche kahi majendo mbaka Miliamu hoyahilulwe kahi kuli kambi. ");
INSERT INTO vid_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","Hamba, wanhu nawaluka majendo kulawila Haseloti, nawawika kambi kuli chiwala ako Palani. ");
INSERT INTO vid_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","Mkulu Nguluwi nakamlonjela Musa, ");
INSERT INTO vid_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","“Uwalajize walume walute kuipugajiza isi ya Kanaani iwele yondiwapa wanhu wa Isilaeli. Komlajiza mlume yumwe kulawila chila nhanzi, yawele chilongozi kuli nhanzi ya heye.” ");
INSERT INTO vid_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","Lelo kwa chiwalo cha ilajizo lya Mkulu Nguluwi, Musa nakawatuma walume kulawila kuchiwala ako Palani. Walume weng'ha watumigwe nawali vilongozi wa nhanzi zilivinji za wanhu wa Isilaeli. ");
INSERT INTO vid_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","Aga ndo matagwa ga wanhu awo. Kulawa kuli nhanzi ya Lubeni, nayali Shamuwa mwana wa Sakuli. ");
INSERT INTO vid_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","Kulawa kuli nhanzi ya Simeoni, nayali Shafati mwana wa Holi. ");
INSERT INTO vid_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","Kulawa kuli nhanzi ya Yuda, nayali Kalebu, mwana wa Yefune. ");
INSERT INTO vid_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","Kulawa kuli nhanzi ya Isakali, nayali Igali mwana wa Yusufu. ");
INSERT INTO vid_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","Kulawa kuli nhanzi ya Efulaimu, nayali Hoshea mwana wa Nuni. ");
INSERT INTO vid_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","Kulawa kuli nhanzi ya Benjamini, nayali Paliti mwana wa Lafu. ");
INSERT INTO vid_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","Kulawa kuli nhanzi ya Sebuluni, nayali Gadieli mwana wa Sodi. ");
INSERT INTO vid_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","Kulawa kuli nhanzi ya Manase, iwele nailawile kuli nhanzi ya Yusufu, nayali Gadi mwana wa Susi. ");
INSERT INTO vid_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","Kulawa kuli nhanzi ya Dani, nayali Amieli mwana wa Gemali. ");
INSERT INTO vid_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","Kulawa kuli nhanzi ya Asheli, nayali Setuli mwana wa Mikaeli. ");
INSERT INTO vid_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","Kulawa kuli nhanzi ya Nafutali, nayali Nabi mwana wa Wofusi. ");
INSERT INTO vid_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","Kulawa kuli nhanzi ya Gadi, nayali Geueli mwana wa Maki. ");
INSERT INTO vid_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","Ago ndo matagwa ga wanhu wawele Musa nakawalajiza kuluta kuipugajiza isi ya Kanaani. Musa nakamha Hoshea mwana wa Nuni itagwa linyale, nakamchema Yoshua. ");
INSERT INTO vid_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","Vyoyawalajize kuza kuipugajiza isi ya Kanaani, Musa nakawalonjela, “Mlute kula kumwambu Negebu, mbaka kuli isi ya vidunda, ");
INSERT INTO vid_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","mkailole isi vyoili. Mlole kahi wone wanhu walingikala amo ndo wawele na mong'ho ama ng'hochele ama wenji ama wado. ");
INSERT INTO vid_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","Mpugajize kota isi ayo inoga ama yiha, miji jowalingikala ndo kambi ama ndo ng'handa zizungulutwe na lukanzi. ");
INSERT INTO vid_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","Mpugajize kahi isi ayo kota ina lufufu ama yahela lufufu, ina migodi ama yahela. Muwe msindamala na vyomuhiluka muhole mafuza gamwe ga isi ayo.” Awo nawali mhela wa kwaluka kupya kwa zabibu. ");
INSERT INTO vid_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","Lelo wanhu awo nawaluta na kuipugajiza isi kulawila kuli chiwala ako Sini mbaka Lehobu, habehi na nzila ya kwinjilila Hamati. ");
INSERT INTO vid_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","Nawaluta mbaka Negebu nawakola mbaka muji wa Hebuloni. Amo nawawafika Waahimani na Washeshai na Watalimai, walelwa wa Anaki. Muji wa Hebuloni nawali uzenjigwe miyaka saba loung'hali kuzenjigwa muji wa Soani uwele muisi ya Misili. ");
INSERT INTO vid_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","Lowafichile kuli ibindi lya Eshikoli, wanhu awo nawadumula chizabala cha zabibu chiwele na mafuza menji na acho nachiholigwa na wanhu weli mzegamzega. Nawahola kahi makomamanga ganji na tini. ");
INSERT INTO vid_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","Honhu aho nahachemigwa ibindi lya Eshikoli kwa chiwalo cha chizabala cha zabibu chiwele wanhu awa wa Isilaeli nawachihola kulawila honhu aho. ");
INSERT INTO vid_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","Lowasindile kuipugajiza isi kwa mhela wa mazuwa makumi gane, wanhu awo nawahiluka. ");
INSERT INTO vid_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","Nawawalutila Musa na Aluni na Waisilaeli weng'ha ako Kadeshi, kuli chiwala ako Palani, nawalonga mbuli zowaziwene na kuwalajila mafuza ga isi. ");
INSERT INTO vid_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","Nawamlonjela Musa, “Natufika isi youtulajize tuipugajize, ayo ndo isi iwele na mboto, na ali ndo ifuza lyake. ");
INSERT INTO vid_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","Ila wenyeng'haye wa isi ayo ndo wawele na mong'ho lukami, na miji ja hewo ndo mikulu ng'hatu na jina lukanzi lukulu. Natuwona kuko kahi walelwa wa Anaki, wawele ng'wemang'wema lukami. ");
INSERT INTO vid_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","Waamaleki wangikala kuli honhu ha Negebu, Wahiti na Wayebusi na Waamoli wangikala kuli honhu ha vidunda, na Wakanaani wangikala habehi na bahali ya Mediteleniyani na habehi na hafungo ha lwanda lwa Yolodani.” ");
INSERT INTO vid_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","Ila Kalebu nakawadita wanhu wenyamalile tulu hali Musa, nakalonga, “Tuche himahima tukaihole isi ayo. Kwa vila twanalo ludali lwa kuhega ng'hatu kwa kuwasumya.” ");
INSERT INTO vid_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","Ila wanhu wowawele welongoze na heye kuipugajiza isi nawalonga, “Hatuweza kitowa na wanhu awo, hewo wana mong'ho lukami kusinda hetwe.” ");
INSERT INTO vid_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","Ahyo naweneza mbuli zihile hali Waisilaeli kuwala isi yowaipugajize, wolonga, “Isi ayo yotuipugajize yanguwakopola wanhu wake. Kahi wanhu weng'ha wotuwawene ako ndo wang'wemang'wema ng'hatu. ");
INSERT INTO vid_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","Ako natuwona wanhu wawele ng'wemang'wema, walelwa wa Anaki. Hetwe natiwona kota ndede hali hewo, hanji hihyo du vyowatuwene hetwe.” ");
INSERT INTO vid_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","Waisilaeli weng'ha nawaluka kulila ng'hatu, wanhu nawalila nechilo yila. ");
INSERT INTO vid_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","Waisilaeli weng'ha nawawang'ung'utila Musa na Aluni kuno wolonga, “Fola natwahabagame Misili. Fola natwahabagame bahano kuchiwala. ");
INSERT INTO vid_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","Lekachoni Mkulu Nguluwi kangutuhilika kuli isi ayo? Tobagama kuli ngondo, na wadala wa hetwe na wana wa hetwe woholigwa na wang'honyo wa hetwe. Fola tuhiluche Misili!” ");
INSERT INTO vid_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","Lelo nawaluka kilonjela wawo, “Tuhagule chilongozi na tuhiluche ako Misili.” ");
INSERT INTO vid_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","Lelo Musa na Aluni nawagwa chifunama hali Waisilaeli weng'ha. ");
INSERT INTO vid_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","Yoshua mwana wa Nuni na Kalebu mwana wa Yefune, nawawele hali wala wanhu wowalutile kuipugajiza isi ayo, nawadega mivalo ja hewo kwa masinzo ");
INSERT INTO vid_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","na kuwalonjela Waisilaeli weng'ha, “Isi yotulutile kuipugajiza ndo inoga lukami. ");
INSERT INTO vid_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","Wone Mkulu Nguluwi nakanojezwa na hetwe, kotuhilika ako na kotukundiza kikala kuli isi iwele na mboto. ");
INSERT INTO vid_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","Ila mleche kumhinduka Mkulu Nguluwi ne kuwadumba wenyeng'haye wa isi ayo. Kwa vila hewo ndo chinhu chido hela kwa hetwe, hawokwamilwa hebu, na heye Mkulu Nguluwi ka hamwe na hetwe, mleche kuwadumba.” ");
INSERT INTO vid_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","Ila Waisilaeli weng'ha nawagana kujeza kuwatowa na maganga. Baho du, ukulu wa Mkulu Nguluwi naulawila mchanya mwa ihema lya Nguluwi, hali Waisilaeli weng'ha. ");
INSERT INTO vid_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","Hamba Mkulu Nguluwi nakamlonjela Musa, “Wanhu wano wombeza mbaka nili? Na woleka kung'hunda heni mbaka nili, hanga ndita vinduzanduza hali hewo? ");
INSERT INTO vid_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","Ndowagaza kwa matamwa gehile na hawowa wanhu wa heni, ila ndokudita uwe nhanzi yinji ng'hulu, iwele na mong'ho kusinda weng'ha.” ");
INSERT INTO vid_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","Ila Musa nakamlonjela Mkulu Nguluwi, “Aho ndo Wamisili wohulika mbuli ayo kota hegwe nakuwegala wanhu wa hegwe kwa ludali lwa hegwe hali hewo, ");
INSERT INTO vid_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","wowalonjela wanhu wa isi ayi. Mina wanhu wano nawahulika kota hegwe, gwa Mkulu Nguluwi, kwa hamwe na hetwe, mina hegwe, gwa Mkulu Nguluwi, kwangoneka hazelu hala ng'hungugu ya hegwe hoyikwima mchanya mwa hetwe, na kota hegwe kulongolaga nemisi kwa izengo lya ng'hungugu na nechilo kwa izengo lya chiluli. ");
INSERT INTO vid_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","Lelo wone uwakopole wanhu wa hegwe weng'ha kwa mhela umwe, isi ziwele nazihulika lutogo lwa hegwe zolonga, ");
INSERT INTO vid_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","‘Mkulu Nguluwi nakawakopola wanhu wa heye kula kuchiwala kwa vila nakalemwela kuwahilika kuli isi yoyelahile kota kowapa.’ ");
INSERT INTO vid_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","Lelo ndangukudedeza, Mkulu, utulajile ludali lwa hegwe kwa kudita kota navyoulagane na hetwe vila vyoulonjile, ");
INSERT INTO vid_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","‘Heni Mkulu Nguluwi silinguzudila himahima, ndo yawele na igano lya kwimilila, na ndangulechela wihe na nongwa. Ila sileka hebu kuwagaza wawele na nongwa, wana na wazukulu wa wehile mbaka lulelo lwa kadatu na lwa kane kwa gehile ga wahaza wa hewo.’ ");
INSERT INTO vid_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","Ndangukudedeza uwalechele gehile ga wanhu wano, kwa igano lya hegwe lya kwimilila kota navyouwalechele kulawa vyowalawile Misili mbaka sambi.” ");
INSERT INTO vid_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","Mkulu Nguluwi nakedichila, “Nandiwalechela kota vyoulandile. ");
INSERT INTO vid_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","Ila ndangukomya, kota vyombele mkomu na kota isi yeng'ha hoimema ukulu wa heni Mkulu Nguluwi, ");
INSERT INTO vid_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","haduhu ne yumwe wa hewo yawezile kuwona ukulu wa heni na vinduzanduza vya heni vyonditile Misili na kuchiwala hamba yolutilila kunjeza mala azi zeng'ha ne kuhulichiza lizi lya heni, ");
INSERT INTO vid_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","koyona isi yila yondiwalahile wasekulu wa hewo. Na kahi wala walingumbeza heni kahi hawoyona. ");
INSERT INTO vid_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","Ila kwa vila chitumagwa wa heni Kalebu ka vinji, na nakanyhulichiza vinojile, ndomfichiza kuli isi ayo na yenjile na walelwa wa heye woihalila isi ayo. ");
INSERT INTO vid_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","Kwa vila Waamaleki na Wakanaani wangikala kuli ibindi lya isi ayo, mitondo mgaluche kumbele mlute kuchiwala kukolela nzila ya hafungo mwa Bahali ya Shamu.” ");
INSERT INTO vid_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","Hamba Mkulu Nguluwi nakawauza Musa na Aluni, ");
INSERT INTO vid_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","“Waisilaeli weng'ha wehile wolutilila kung'ung'utila heni mbaka nili? Nhoka na kung'ung'utilwa na Waisilaeli. ");
INSERT INTO vid_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","Lelo wedichile ahi. Kota vyondili mkomu, ndangulonga heni Mkulu Nguluwi, ndowaditila gagala gondihuliche mlonga. ");
INSERT INTO vid_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","Mobagama na mitufi ja hemwe jotozigwa mumu kuchiwala. Kwa vila na mng'ung'utila heni, haduhu ne yumwe yawazigwe hali hemwe yawele na miyaka kwaluchila miyaka makumi meli na kulutilila, ");
INSERT INTO vid_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","yokwinjila kuli isi ayo yondilahile kota mochikala ako, ila Kalebu mwana wa Yefune na Yoshua mwana wa Nuni. ");
INSERT INTO vid_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","Hemwe namlonga kota wana wa hemwe woholigwa kuli upogozi, ila heni ndowahilika wana wa hemwe kuli isi yomuibezile, leka waizele na hawe haluga hawo. ");
INSERT INTO vid_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","Ila hemwe mobagama mumu kuchiwala. ");
INSERT INTO vid_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","Wana wa hemwe wowa wadimi na kugazika amu kuchiwala kwa mhela wa miyaka makumi gane kwa chiwalo cha hemwe kuleka kukunda mbaka munhu wa hemwe wa mwiso hoyobagama kuchiwala. ");
INSERT INTO vid_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","Kwa chiwalo cha nongwa za hemwe, mogazika kwa mhela wa miyaka makumi gane, kota gala mazuwa makumi gane gompugajize isi yila, mwaka umwe kwa chila zuwa limwe, movizela kota heni nzudila. ");
INSERT INTO vid_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","Heni Mkulu Nguluwi ndonga. Ndangukomya, ndowadita hihyo Waisilaeli weng'ha wating'hane hano kundeuza. Kuli chiwala achi, wobagama weng'ha.” ");
INSERT INTO vid_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","Wala wanhu wawele Musa yawalajize kuza kuipugajiza isi yila, wawele wahiluche na kwambuza Waisilaeli weng'ha wamng'ung'utile Mkulu Nguluwi kwa kigala mbuli yihile ilinguwala isi, ");
INSERT INTO vid_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","nawabagama kwa igayo hali Mkulu Nguluwi. ");
INSERT INTO vid_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","Ila Yoshua mwana wa Nuni na Kalebu mwana wa Yefune, nawapona wawele wakomu hali wala wanhu wowalutile kuipugajiza isi. ");
INSERT INTO vid_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","Na heye Musa nakawalonjela Waisilaeli weng'ha na hewo nawamlilila kwa usungu lukami. ");
INSERT INTO vid_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","Nawalilimka lufuku, nawaluta kuli chinhembenhembe cha isi ya vidunda, wolonga, “Tukomya kota natudita gehile. Lelo twa goya ng'hatu kuza honhu hawele Mkulu Nguluwi nayalagane na hetwe.” ");
INSERT INTO vid_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","Ila Musa nakalonga, “Lelo lekachoni mwangubena ilajizo lya Mkulu Nguluwi? Ahyo hamsinda hebu! ");
INSERT INTO vid_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","Mleche kuka ako kuchidunda leka mleche kutowigwa na wang'honyo wa hemwe, mina Mkulu Nguluwi kahaduhu hali hemwe. ");
INSERT INTO vid_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","Homchitowa na Waamaleki na Wakanaani, mobagama kuli ngondo, kwa vila namleka kumuwinza Mkulu Nguluwi, heye nahawele hamwe na hemwe.” ");
INSERT INTO vid_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","Lelo hewo nawaluta kuli isi ya vidunda, ila isanduku lya ilagano lya Mkulu Nguluwi na hambe lilawe kuli kambi, ne Musa nahochile kuli kambi. ");
INSERT INTO vid_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","Ahyo Waamaleki na Wakanaani, nawawele wochikala kuli isi ayo ya vidunda, nawadulika, nawawatowa na kuwasumya. Nawawawinga mbaka kuli muji wa Holima. ");
INSERT INTO vid_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","Mkulu Nguluwi nakamlonjela Musa, ");
INSERT INTO vid_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","“Walonjele Waisilaeli kota lomfika kuli isi yondilinguwapa iwele mochikala, ");
INSERT INTO vid_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","mondavila nhambiko heni Mkulu Nguluwi kwa chiluli kulawa kuli migongolo ja hemwe, nhambiko ya kulakazwa ama nhambiko yinji, leka munhu yetawize kilaha kwa heye nakoyalahile ama kulavya nhambiko ya kunuwila kwa heye ama nhambiko ya mnvina za hemwe kuli mhela uwichigwe, na kudita unhunyhililo unojile wa kunojeza heni Mkulu Nguluwi, ");
INSERT INTO vid_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","lelo, yula yalingulavya nhambiko ya heye, komigalila kahi Mkulu Nguluwi nhambiko ya nyhule ya kilo imwe ya utimbo unojile na uhanzigwe na lita imwe ya mafuta, ");
INSERT INTO vid_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","hamwe na divai ya nhambiko ya chakunwa, lita imwe na vinhu vyowa hamwe na chila ing'holo lyana lya nhambiko ya kulakazwa ama nhambiko yinji. ");
INSERT INTO vid_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","Mhela wa kulavya nhambiko ya ing'holo ilume, kilo mbili za utimbo unojile na lita imwe na nusu ya mafuta vyolavigwa kota nhambiko ya nyhule, ");
INSERT INTO vid_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","hamwe na nhambiko ya chakunwa lita imwe na nusu ya divai na kudita kunhunyhilila kunojile kwa nhambiko, kumnojeza Mkulu Nguluwi. ");
INSERT INTO vid_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","Mhela lomumlavila Mkulu Nguluwi ilogota ilume kwa chiwalo cha nhambiko ya kulakazwa ama nhambiko yinji leka kutawiza chilaho ama kwa chiwalo cha nhambiko za kikala goya, ");
INSERT INTO vid_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","hamwe na ibuguma, munhu ayo kolavya nhambiko ya nyhule ya utimbo unojile wa kilo zidatu na lita mbili za mafuta, ");
INSERT INTO vid_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","hamwe na nhambiko ya chakunwa lita mbili za divai na kudita kunhunyhilila kunojile kwa nhambiko yalingulavilwa Mkulu Nguluwi kwa chiluli. ");
INSERT INTO vid_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","“Kodita kota ahi kwa chila ibuguma ama ing'holo ilume na ing'holo lyana ilume ama chinyehe. ");
INSERT INTO vid_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","Udite hino kwa chila chimwe kota vyovilingulavigwa. ");
INSERT INTO vid_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","Chila munhu Muisilaeli kowinza malajizo ago mhela hoyolavya nhambiko yalingulavilwa Mkulu Nguluwi kwa chiluli, kunhunyhilila kulingumnojeza Mkulu Nguluwi. ");
INSERT INTO vid_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","Wone hana mjenzi yoneche yalingikala hamwe na hemwe kwa mhela ama kwa mazuwa gose, hoyogana kulavya nhambiko ya heye kwa chiluli, kunhunyhilila kumnojeze Mkulu Nguluwi, munhu ayo kodita kota vyomlingudita hemwe. ");
INSERT INTO vid_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","Kuli lulelo lweng'ha lulinguya, malajizo gagala gomlinguwinza, ndo gago goyalinguganigwa kuwinza mjenzi yoneche yalingikala na hemwe na Waisilaeli weng'ha mazuwa gose, hali Mkulu Nguluwi mowa chinhu chimwe, ");
INSERT INTO vid_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","hemwe na heye mowa hali malajizo gagala.” ");
INSERT INTO vid_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","Mkulu Nguluwi nakamlonjela Musa, ");
INSERT INTO vid_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","“Walonjele Waisilaeli kota homkwinjila kuli isi yondilinguwahilika, ");
INSERT INTO vid_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","chila homulya chilyo cha isi ayo, mobagula chasi chimwenga na kumha heni Mkulu Nguluwi. ");
INSERT INTO vid_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","Homteleka mibumunda ja utimbo wa mwaluko, jolavigwa kota ndolendole kulawa kuli honhu ha kuyugululila nyhule. ");
INSERT INTO vid_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","Mondavila heni Mkulu Nguluwi ndolendole ayi ya mibumunda ja nyhule za mwaluko kuli lulelo lwa hemwe lweng'ha lulinguya. ");
INSERT INTO vid_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","“Ila wone moleka kuwinza mizilo ajo jeng'ha ne kunuwila, jiwele heni Mkulu Nguluwi jondiwapele hemwe kwa kukolela Musa, ");
INSERT INTO vid_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","na wone kuli mazuwa galinguya walelwa wa hemwe woleka kuwinza geng'ha gawele heni Mkulu Nguluwi gondimlajize Musa, ");
INSERT INTO vid_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","lelo nongwa ayo yowa naiditigwa ne kunuwila na ne nhanzi ya wanhu kuvizela, Waisilaeli weng'ha wolavya ilogota ilume leka liwe nhambiko ya kulakazwa, kunhunyhilila kunojile kwa kumnojeza Mkulu Nguluwi, hamwe na nhambiko ya heye ya nyhule na ya chakunwa kota malajizo ga heye vyogalingulonga. Hihyo du wanhu wolavya ipongo limwe liwe nhambiko ya gehile. ");
INSERT INTO vid_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","Mtambika kodita uhanyisi kwa chiwalo cha Waisilaeli weng'ha, na hewo wolechelwa kwa vila haiwele nongwa iditigwe kwa kunuwila, na wegala nhambiko ya hewo, nhambiko yalingulavilwa Mkulu Nguluwi kwa chiluli, kota nhambiko na nhambiko ya gehile kwa chiwalo cha nongwa ya hewo. ");
INSERT INTO vid_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","Waisilaeli weng'ha hamwe na wajenzi wowalingikala na hewo, wolechelwa kwa vila weng'ha nawali kuli nongwa ayo. ");
INSERT INTO vid_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","“Wone munhu yumwe yodita gehile ne kunuwila, kolavya mhene ndala ya mwaka umwe leka iwe nhambiko ya gehile. ");
INSERT INTO vid_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","Mtambika kodita uhanyisi hali Mkulu Nguluwi, kwa chiwalo cha ayo munhu yaditile gehile ne kunuwila, na heye kulechelwa nongwa ya heye. ");
INSERT INTO vid_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","Mowinza ilajizo lilyo limwe kwa chila munhu wone yodita gehile ne kunuwila, yawe mwenyeng'haye Muisilaeli ama mjenzi yalingikala hamwe na hemwe. ");
INSERT INTO vid_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","“Ila munhu yoneche yodita gehile kwa kunuwila yuye, kangumbeza Mkulu Nguluwi, yawe mwenyeng'haye ama mjenzi, kanguganigwa yabaguligwe kutali na wanhu wa heye. ");
INSERT INTO vid_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","Mina nakalema gala goyalonjile Mkulu Nguluwi na kubena mizilo jake. Munhu ayo kobaguligwa kutali ng'hatu, na kogazigwa kwa chiwalo cha nongwa ya heye.” ");
INSERT INTO vid_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","Zuwa limwe Waisilaeli lowawele kuchiwala, nawamona munhu yumwe yolokota ngodi kuli Zuwa lya Kwesela. ");
INSERT INTO vid_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","Lelo munhu ayo nakegaligwa hali Musa na Aluni na Waisilaeli weng'ha. ");
INSERT INTO vid_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","Hewo nawamuwika hali wamizi kwa vila nahailonjigwe hazelu ndaze vyoyalinguganigwa kuditilwa munhu kota ayo. ");
INSERT INTO vid_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","Ahyo, Mkulu Nguluwi nakamlonjela Musa, “Munhu ayo imgana yabagame, Waisilaeli weng'ha womtowa kwa maganga hanze ha kambi.” ");
INSERT INTO vid_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","Lelo Waisilaeli weng'ha nawamlavya hanze ha kambi, nawamtowa kwa maganga mbaka nakabagama, kota Mkulu Nguluwi navyoyamlajize Musa. ");
INSERT INTO vid_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","Hamba Mkulu Nguluwi nakamlonjela Musa, ");
INSERT INTO vid_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","“Walonjele wanhu wa Isilaeli, uwalajize weditile usabuli kuli lupembo lwa nguwo za hewo, na kuwika ng'weso za buluu mchanya mwa chila usabuli. Walonjele wadite ahyo kuli chila lulelo lwawo lweng'ha. ");
INSERT INTO vid_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","Usabuli awo wowa chinhu cha kukumbuchila kwa hemwe. Chila homuwona, mokumbuchila mizilo jeng'ha ja heni Mkulu Nguluwi na kujiwinza leka mleche kuwinza maya ga meho na nhumbula za hemwe gomzowele kugadita, kota ung'hondwa. ");
INSERT INTO vid_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","Usabuli awo wowakumbusa mizilo ja heni jeng'ha na mojiwinza jeng'ha ne kuleka, namwe mowa welile kwa heni Nguluwi wa hemwe. ");
INSERT INTO vid_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","Heni ndo Mkulu Nguluwi, Nguluwi wa hemwe, ndiwalavile hemwe kulawa isi ya Misili ndiwe Nguluwi wa hemwe. Heni ndo Mkulu Nguluwi, Nguluwi wa hemwe.” ");
INSERT INTO vid_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","Hamba Kola mwana wa Ishali, mwana wa Kohati, mwana wa Lawi, nakawahola wanhu hamwe na wanhu wadatu wa lukolo lwa Lubeni, Datani na Abilamu, mwana wa Eliabu na Oni, mwana wa Peleti, ");
INSERT INTO vid_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","awo weng'ha nawelumbile na vilongozi wang'hangala miya mbili na makumi gahano wahaguligwe na Waisilaeli weng'ha, nawamlema Musa. ");
INSERT INTO vid_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","Nawekungajiza hali Musa na Aluni, wawalonjela, “Hemwe ihega! Wanhu weng'ha ndo welile na chila munhu kuli Waisilaeli weng'ha wano ndo welile, na Mkulu Nguluwi kahamwe na hetwe. Lelo lekachoni mwangidita mwa wang'hangala wa wanhu wa Mkulu Nguluwi?” ");
INSERT INTO vid_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","Musa loyahuliche ago, naketoza hanyi chifunama. ");
INSERT INTO vid_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","Hamba nakamlonjela Kola na wanhu weng'ha walingumuwinza heye, “Mitondo, Mkulu Nguluwi kolajila yalihi yawele wa heye na yalihi yawele yelile, na heye yomhagula. Munhu yohaguligwa kohejezwa habehi na Mkulu Nguluwi. ");
INSERT INTO vid_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","Lelo mdite ahi. Hegwe na wanhu weng'ha walingukuwinza hegwe, mohola vifunyizi, ");
INSERT INTO vid_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","muwiche chiluli na ubani mgati, hamba movihilika hali Mkulu Nguluwi. Hamba tokona yalihi yahaguligwe na Mkulu Nguluwi kowa yelile. Hemwe Walawi ihega!” ");
INSERT INTO vid_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","Musa nakalutilila kumlonjela Kola, “Mhulichize, hemwe Walawi. ");
INSERT INTO vid_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","Ndaze, mwangona ndo mbuli nyindo kwa hemwe kota Nguluwi wa Isilaeli nakawabagula hemwe hali Waisilaeli weng'ha, leka muwe habehi na heye, mkole mijito kuli ihema lya Mkulu Nguluwi na kukola mijito na kuwakolela mijito Waisilaeli weng'ha? ");
INSERT INTO vid_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","Nakawapa mijito ja chiuyeng'ha habehi na heye, hemwe hamwe na Walawi wang'holozenu weng'ha. Lelo mwangugana kuhola na utambika kahi? ");
INSERT INTO vid_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","Ahyo hegwe na wanhu weng'ha mwangumbelenhuka Mkulu Nguluwi. Hemwe mlingumng'ung'utila Aluni, ila ndangukomya kota mwangumng'ung'utila Nguluwi.” ");
INSERT INTO vid_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","Musa nakalajiza usenga kwa Datani na Abilamu wana wa Eliabu leka wachemigwe, ila hewo nawalonga, “Hatukuya hebu! ");
INSERT INTO vid_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","Ndaze, ndo mbuli nyindo kota kutulavya Misili, isi iwele na mboto, leka uye utukopole aku kuchiwala? Kahi, kwangidita kota kwa mng'hangala wa hetwe! ");
INSERT INTO vid_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","Mzidi wa ago, hambe utugale kuli isi iwele na mboto, na kahi hambe utugalile uhalizi wa migunda na migunda ja mizabibu. Vyoulingijesa koweza kutuhada? Hatukuya hebu!” ");
INSERT INTO vid_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","Musa nakazudila ng'hatu, nakamlonjela Mkulu Nguluwi “Uleche kukunda nhambiko za wanhu wano. Heni siholile idogowi lya munhu yoneche, ne kumlumiza munhu.” ");
INSERT INTO vid_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","Musa nakamlonjela Kola, “Mitondo uye na wanhu weng'ha walingukuwinza hegwe hali Mkulu Nguluwi. Aluni naye kowa baha. ");
INSERT INTO vid_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","Chila yumwe wa hemwe yahole chifunyizi cha heye, na kuwika ubani, hamba kochihilika hali Mkulu Nguluwi, vifunyizi avyo vyowa miya mbili na makumi gahano, hegwe nagwe na Aluni, chila yumwe kowa na chifunyizi cha heye.” ");
INSERT INTO vid_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","Lelo chila yumwe wa hewo nakahola chifunyizi cha heye, nakawika chiluli na ubani, hamba nawaluta kwima hali lwizi lwa ihema lya Nguluwi, hamwe na Musa na Aluni. ");
INSERT INTO vid_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","Na heye Kola nakawakungajiza wanhu weng'ha hamwe, nawawabelenhuka Musa na Aluni, nawema hali Musa na Aluni hali lwizi lwa ihema lya Nguluwi. Ndo ukulu wa Mkulu Nguluwi naulawila hali Waisilaeli weng'ha. ");
INSERT INTO vid_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","Aho Mkulu Nguluwi nakawalonjela Musa na Aluni, ");
INSERT INTO vid_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","“Mibagule na Waisilaeli weng'ha wano, leka ndiwadumye sambi baha.” ");
INSERT INTO vid_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","Ila Musa na Aluni nawetoza hanyi chifunama kuno wolonga, “Hegwe Nguluwi, Nguluwi uwapele ukomu wanhu weng'ha. Ndaze, wone munhu yumwe nakadita gehile, kowazudila Waisilaeli weng'ha?” ");
INSERT INTO vid_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","Mkulu Nguluwi nakamlonjela Musa, ");
INSERT INTO vid_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","“Walonjele Waisilaeli weng'ha woche habehi na mihema ja Kola na Datani na Abilamu.” ");
INSERT INTO vid_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","Lelo Musa nakaluta kwa Datani na Abilamu, yowinzigwa na wasekulu wa Isilaeli. ");
INSERT INTO vid_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","Loyafichile, nakawalonjela Waisilaeli weng'ha, “Dedede, muche hali ihema lya wanhu wawele na wihe na mleche kudoliza chinhu cha hewo choneche, wone muye modumigwa hamwe na hewo kwa chiwalo cha gehile ga hewo geng'ha.” ");
INSERT INTO vid_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","Wanhu nawoka kuli mihema ja Kola na Datani na Abilamu. Datani na Abilamu nawalawa kuli mihema ja hewo na kwima hali lwizi lwa mihema ja hewo wawele na wachewawo na wana wa hewo weng'ha mbaka wala walingong'a. ");
INSERT INTO vid_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","Aho Musa nakawalonjela wanhu, “Ahyo ndo vyomvizela kota Mkulu Nguluwi ndo yandajize kudita mbuli ayi yeng'ha, na haiwele kwa kunuwila kwa heni. ");
INSERT INTO vid_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","Wone wanhu wano wobagama kota wanhu wanji weng'ha, ne kugazigwa na Mkulu Nguluwi, lelo mvizele kota Mkulu Nguluwi handajize. ");
INSERT INTO vid_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","Ila wone Mkulu Nguluwi yadite mbuli iwele hainaditigwa, misanga jigubuche na kumela wanhu awa hamwe na chila chinhu cha hewo, walute kuli isi ya wabagame wawele wakomu, lelo movizela kota wanhu wano nawambeza Mkulu Nguluwi.” ");
INSERT INTO vid_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","Baho du vyoyasindile kulonga mbuli ayo yeng'ha, hasi howemile Datani na Abilamu nahagubuka ");
INSERT INTO vid_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","na kuwamela wanhu awo na wanhu wa ivyazi lya hewo, hamwe na wanhu weng'ha walinguwawinza Kola na lufufu lwa hewo lweng'ha. ");
INSERT INTO vid_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","Lelo hewo hamwe na vyeng'ha viwele vya hewo nawadulika kuli isi ya wabagame kuno wawele wang'hali wakomu. Misanga najiwagubika, wanhu weng'ha nawabagama. ");
INSERT INTO vid_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","Waisilaeli wawele habehi vyowahuliche wala walingudulika vyowotowa iyowe, nawadwina wolonga, “Tubilime, leka misanga jileche kutumela na hetwe natwe.” ");
INSERT INTO vid_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","Hamba Mkulu Nguluwi nakahilika chiluli nakawalakaza wala wanhu miya mbili na makumi gahano walutile kufunyiza ubani. ");
INSERT INTO vid_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","Vyogapulute ago, Mkulu Nguluwi nakamlonjela musa, ");
INSERT INTO vid_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","“Mlonjele Eleasali mwana wa mtambika Aluni yavilavye avyo vifunyizi hali chiluli, yakabohole kutali chiluli chiwele mgati, mina vifunyizi avyo ndo vyelile. ");
INSERT INTO vid_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","Naviwa vyelile kwa vila wanhu awa nawavigala hali honhu ha kulavila nhambiko ha Mkulu Nguluwi. Lelo vihole vifunyizi vya wanhu awo wabagame kwa chiwalo cha gehile ga hewo, vipondigwe na viwe vizisili leka viwe chigubiko cha honhu ha kulavila nhambiko. Ali ndo nalyali ikanyo kwa Waisilaeli weng'ha.” ");
INSERT INTO vid_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","Lelo mtambika Eleasali nakahola vifunyizi avyo vya shaba kulawa kwa wala wanhu walakazwe, nakaviponda na viwa chigubiko cha honhu ha kulavila nhambiko. ");
INSERT INTO vid_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","Ali nalyali ikanyo kwa Waisilaeli weng'ha kota munhu yoneche yohawele mtambika, mina hawele wa lukolo lwa Aluni, yaleche kuluta honhu ha kulavila nhambiko na kumfunyizila Mkulu Nguluwi ubani. Wone yoluta kobagama kota Kola na walingumuwinza heye. Aga geng'ha nagaditigwa kota Mkulu Nguluwi vyoyamlajize Eleasali kwa kukolela Musa. ");
INSERT INTO vid_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","Hamitondo, Waisilaeli weng'ha nawawang'ung'utila Musa na Aluni kuno wolonga, “Muwakopola wanhu wa Mkulu Nguluwi.” ");
INSERT INTO vid_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","Waisilaeli weng'ha vyowekungajize hali Musa na Aluni leka walavye kung'ung'uta kwa hewo, nawagaluchila ihema lya Nguluwi, nawona ng'hungugu igubiche ihema lya Nguluwi na ukulu wa Mkulu Nguluwi nawali ulawile aho. ");
INSERT INTO vid_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","Musa na Aluni nawaluta, nawema hali ihema lya Nguluwi, ");
INSERT INTO vid_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","na Mkulu Nguluwi nakamlonjela Musa, ");
INSERT INTO vid_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","“Wibagule na Waisilaeli weng'ha wano, leka ndiwakopole sambi baha.” Ila hewo nawetoza hanyi chifunama. ");
INSERT INTO vid_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","Musa nakamlonjela Aluni, “Uhole chifunyizi cha hegwe, uwiche chiluli kulawa kuli honhu ha kulavila nhambiko, hamba uwiche ubani na kahi ulute nacho himahima kuli Waisilaeli weng'ha kuwaditila uhanyisi. Kuzudila kwa Mkulu Nguluwi mina nakuwafichila na igayo nalyaluka kuwagaza.” ");
INSERT INTO vid_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","Lelo Aluni nakadita kota vyoyalajizwe na Musa. Nakahola chifunyizi cha heye na kubilima mbaka hagati ha wanhu wawele wekungajize hamwe. Vyoyawene kota igayo mina nalyaluka, nakawika ubani mli chifunyizi na kuwaditila uhanyisi wanhu weng'ha. ");
INSERT INTO vid_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","Navyoyaditile ahyo, igayo alyo nalileka, na heye nakasigala hagati kwa wala wabagame na wawele wakomu. ");
INSERT INTO vid_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","Wanhu wabagame kwa igayo alyo nawali elufu kumi na gane na miya saba (14,700), ne kuwawaza wala nawabagame kwa chiwalo cha kuhinduka kwa Kola. ");
INSERT INTO vid_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","Vyolimalile igayo alyo, Aluni nakahiluka kwa Musa hali lwizi lwa ihema lya Nguluwi. ");
INSERT INTO vid_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","Hamba Mkulu Nguluwi nakamlonjela Musa, ");
INSERT INTO vid_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","“Walonjele Waisilaeli wakigalile ng'hweku kumi na mbili, chilongozi yumwe wa chila nhanzi, ng'hweku imwe. Wandiche itagwa lya chila yumwe wa hewo kuli ng'hweku ya heye, ");
INSERT INTO vid_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","na itagwa lya Aluni wandiche mchanya mwa ng'hweku ya nhanzi ya Lawi. Howa na ng'hweku imwe kwa chila chilongozi wa nhanzi. ");
INSERT INTO vid_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","Zihiliche ng'hweku azo kuli ihema lya Nguluwi na kuziwika hali isanduku lya ilagano, honhu hawele heni nditing'hanaga na hegwe. ");
INSERT INTO vid_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","Ng'weku ya munhu yondimhagula yozuka. Kwa nzila ayi, kung'ung'uta kwa Waisilaeli kwa chiwalo cha hemwe, ndokudita kumale.” ");
INSERT INTO vid_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","Musa nakadawala na wanhu wa Isilaeli. Vilongozi wa hewo weng'ha nawamha chila yumwe ng'hweku ya heye kota vyoiwele nhanzi ya heye, ahyo nazali ng'hweku kumi na mbili, na ng'hweku ya Aluni nayali hali azo. ");
INSERT INTO vid_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","Musa nakaziwika ng'hweku azo hali Mkulu Nguluwi kuli ihema lya Nguluwi. ");
INSERT INTO vid_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","Hamitondo kung'hali lufuku, Musa nakaluta kuli ihema lya Nguluwi. Amo, nakaifika ng'hweku ya Aluni wa nhanzi ya Lawi, izuka na kulavya mitumba jibahule uluwa na kulela mafunza gapile ga igodi lilinguchemigwa mlozi. ");
INSERT INTO vid_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","Hamba Musa nakazilavya ng'hweku zeng'ha aho, kulawila hali Mkulu Nguluwi, nakawalajila Waisilaeli weng'ha, na chila chilongozi nakahola ng'hweku ya heye yuye. ");
INSERT INTO vid_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","Mkulu Nguluwi nakamlonjela Musa, “Ihilule ng'hweku ya Aluni hali isanduku lya ilagano. Ayo yowichigwa goya honhu aho, na ndo chinhu cha kukanya kwa wala wahinduche wone hawalechile kung'ung'uta, wobagama.” ");
INSERT INTO vid_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","Musa kadita kota vyoyalajizwe na Mkulu Nguluwi. ");
INSERT INTO vid_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","Waisilaeli nawamlonjela Musa, “Ulole lelo! Twangubagama! Tumala! Weng'ha tumala. ");
INSERT INTO vid_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","Chila munhu yolihejelela ihema lya Nguluwi, kobagama. Ndaze, tobagama tweng'ha?” ");
INSERT INTO vid_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","Lelo Mkulu Nguluwi nakamlonjela Aluni, “Nongwa zeng'ha zilinguwala mijito ja ihema lya Nguluwi, zowa za hegwe na wanago na lukolo lwa hegwe lwa Kohati, na nongwa zeng'ha zilinguwala utambika zowa za hegwe gwegwe na wanago. ");
INSERT INTO vid_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","Hegwe na wang'holozo, nhanzi ya Walawi, nhanzi ya mhaza wa hegwe, uwegale behi na hegwe leka welumbe na hegwe na kukola mijito kota watambika, ila hegwe na wanago mowa hali ihema lya Nguluwi lya ulolezi. ");
INSERT INTO vid_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","Awo wokola mijito jowopegwa kulawa kwa hegwe na kweneza gowalonjelwe hewo galingulapa ihema lya Nguluwi. Ila hambe wakundizwe kuvihejelela vinhu vya ihema lya Nguluwi na waleche kuhahejelela honhu ha kulavila nhambiko, leka waleche kubagama, na hegwe kahi kobagama. ");
INSERT INTO vid_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","Hewo wochilumba na hegwe na kweneza goya mijito ja hewo jowalinguganigwa ilinguwala mijito jeng'ha ja ihema lya Nguluwi, na haleche kuwa na munhu yunji yohejelela honhu aho. ");
INSERT INTO vid_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","Hemwe mokola mijito ja ihema lya Nguluwi na honhu ha kulavila nhambiko, leka ng'halazi ya heni ileche kuwalawila kahi Waisilaeli. ");
INSERT INTO vid_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","Heni ndiwahagule wang'holozenu Walawi hali Waisilaeli kota ndolendole kwa hemwe. Hewo nawabaguligwa kwa chiwalo cha heni Mkulu Nguluwi, leka wakole mijito ja ihema lya Nguluwi. ");
INSERT INTO vid_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","Ila hegwe uliyeka na wana wa hegwe mokola mijito jeng'ha ja utambika kwa chiwalo cha honhu ha kulavila nhambiko na vyeng'ha viwele kuli kumbele kwa ipaziya lya honhu helile. Ajo ndo mijito ja hemwe, kwa vila ndiwapa ndolendole ya utambika. Munhu yunji yoneche wone yovihejelela vinhu vya ihema lya Nguluwi, kobagama.” ");
INSERT INTO vid_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","Mkulu Nguluwi nakamlonjela Aluni, “Ndanguwika kwa hegwe ndolendole azi zowamhele Waisilaeli, vinhu vyeng'ha vyelile vyowamhele. Vinhu vyeng'ha viwichigwe chiuyeng'ha na Waisilaeli. Ndanguwika vinhu vyeng'ha kwa hegwe na walelwa wa hegwe kwa honhu ha hemwe, na ayo ndo hachi ya hemwe mazuwa gose. ");
INSERT INTO vid_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","Kuli vinhu vyelile ng'hatu vyohambe vilakazwe kwa chiluli, avi vyowa vya hemwe. Nhambiko za nyhule na nhambiko za gehile na nhambiko za nongwa, chila chinhu chowondavila wanhu kota nhambiko yelile chowa cha hegwe na wanago. ");
INSERT INTO vid_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","Molya vinhu avyo kota vinhu vyelile ng'hatu, na ndo walume hela ndo wolya, vinhu avyo ndo vyelile kwa hemwe. ");
INSERT INTO vid_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","“Kahi, vinhu viyage vyeng'ha vyowondavila Waisilaeli kota nhambiko za kwinula kuchanya, vyowa vya hegwe. Ndokupa hegwe na wanago na wahinza wa hegwe viwe vya hemwe mazuwa gose. Munhu yoneche yelizwe kuli nhanzi ya hegwe koweza kulya vinhu avyo. ");
INSERT INTO vid_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","“Ndangukupa vinhu vyeng'ha vinojile vilingulawila kuli mbena ya mwaluko iwele Waisilaeli hundavila heni Mkulu Nguluwi. Mafuta ganojile na divai na nyhule. ");
INSERT INTO vid_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","Mbena zeng'ha za mwaluko za mafuza gapile ga migunda ja hewo gawele wongalila heni Mkulu Nguluwi, gowa ga hegwe. Chila munhu yelizwe kuli ivyazi lya hegwe koweza kulya. ");
INSERT INTO vid_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","Chila chinhu chibaguligwe kwa chiwalo cha Nguluwi kuli isi ya Isilaeli chowa cha hemwe. ");
INSERT INTO vid_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","“Chila mlelwa wa mwaluko yawele Waisilaeli wondavila heni Mkulu Nguluwi, wone yowa mlelwa wa mwaluko wa munhu ama igongolo, yowa wa hegwe. Ila kwanguganigwa kuwagombola walelwa wa mwaluko weng'ha wa wanhu, na chila mlelwa wa mwaluko wa igongolo likokomoche yanguganigwa ligomboligwe. ");
INSERT INTO vid_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","Walelwa awo wa mwaluko wawele wa mwezi umwe kwa kulavigwa sendi vihande vihano, kwa kuwinza chipimilo cha ihema lya Nguluwi. ");
INSERT INTO vid_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","Ila walelwa wa mwaluko wa misenga ama ming'holo myana ama mhene, hewo huwagombola hebu kwa vila hewo ndo welile. Danda ya hewo koimizila kuli honhu ha kulavila nhambiko na mafuta gawo kogalakaza gawe nhambiko yalingulavilwa kwa chiluli gawele ndo kunhunyhilila kunojile kulingumnojeza Mkulu Nguluwi. ");
INSERT INTO vid_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","Miwunde ja hewo koweza kulya kota hila vyoudile mhambaga yinuligwe kuchanya na chima cha kudilo. ");
INSERT INTO vid_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","“Ndanguwika kwa hegwe Mkulu Nguluwi na wana wa hegwe na wahinza wa hegwe, vinhu vyeng'ha viwele wanhu wa Isilaeli nawandavilaga, avyo ndo vya hemwe mazuwa gose. Ali ndo ilagano lya mazuwa gose na halibenigwa hali heni, liwele ndo kwa chiwalo cha hegwe na walelwa wa hegwe.” ");
INSERT INTO vid_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","Mkulu Nguluwi nakamlonjela Aluni, “Hegwe hauwa na uhalizi woneche kuli isi ayo, ne kuwa na honhu ha hegwe hali hewo. Heni ndo honhu ha hegwe na uhalizi wa hegwe hali Waisilaeli.” ");
INSERT INTO vid_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","Mkulu Nguluwi nakalonga, “Kwa Walawi, hewo nandiwapa zaka zeng'ha ziwele Waisilaeli nawandavilaga ziwe uhalizi wa hewo. Aga ndo gowa kuhilusila kwa hewo kwa chiwalo cha mijito jowalingukola kwa kulilolela ihema lya Nguluwi. ");
INSERT INTO vid_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","Kulawila sambi, wanhu wanji wa Isilaeli waleche kuhejela habehi na ihema lya Nguluwi leka waleche kutagusigwa kwa gehile ga hewo na kigalila kubagama. ");
INSERT INTO vid_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","Ila Walawi waliyeka ndo wokola mijito kuli ihema lya Nguluwi na nongwa zeng'ha zilingulapa ihema lya Nguluwi, zowa za hewo. Alyo ndo ilajizo lya mhela weng'ha kuli lulelo lwa hemwe lweng'ha. Walawi hawowa na uhalizi kuli isi ya Isilaeli, ");
INSERT INTO vid_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","kwa vila zaka ziwele Waisilaeli zowalingundavila heni Mkulu Nguluwi ndiwapa hewo Walawi ziwe uhalizi wa hewo. Ndo mina ndilonga kota hewo hawowa na uhalizi hali Waisilaeli.” ");
INSERT INTO vid_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","Hamba, Mkulu Nguluwi nakamlonjela Musa, ");
INSERT INTO vid_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","“Kowalonjela Walawi malajizo aga. Hombochela zaka ziwele Mkulu Nguluwi nakawapa kulawa kwa Waisilaeli iwe ndo uhalizi wa hemwe, mondavila heni Mkulu Nguluwi honhu hamwe ha kumi ha zaka ayo. ");
INSERT INTO vid_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","Nhambiko ya hemwe yokundigwa iwe kota mbena ya mwaluko ama kota zabibu zoyalingundavila mlimi. ");
INSERT INTO vid_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","Lelo ahyo ndo vyomundavila heni Mkulu Nguluwi nhambiko za zaka zombochela kulawa kwa Waisilaeli. Zaka azo zomndavila heni Mkulu Nguluwi momha mtambika Aluni. ");
INSERT INTO vid_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","Nhambiko yila yomuilavile kwa Mkulu Nguluwi, iwe inojile kusinda zeng'ha kulawa kuli zaka zombochela. ");
INSERT INTO vid_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","Ahyo, kowalonjela kota, homsinda kundavila honhu hanojile kusinda heng'ha, honhu hohosigala howa ha hemwe Walawi, kota vyoiwele kwa mlimi yawele nakaholaga chisigale hoyasindile kulavya zaka za heye za nyhule na za zabibu. ");
INSERT INTO vid_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","Na hemwe moweza kulya chilavigwe honhu honeche hala hamwe na ivyazi lya hemwe mina ndo ndolendole za hemwe kwa chiwalo cha mijito ja hemwe ja ihema lya Nguluwi. ");
INSERT INTO vid_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","Mowahela nongwa yoneche wone mulye vinhu avyo, wone mumlavila Mkulu Nguluwi honhu hanojile kusinda heng'ha, namwe hamzibeza zaka zelile za Isilaeli ama mobagama.” ");
INSERT INTO vid_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","Mkulu Nguluwi nakawalonjela Musa na Aluni, ");
INSERT INTO vid_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","“Aji ndo mizilo ja malajizo gawele heni Mkulu Nguluwi ndangugalavya. Walonjele Waisilaeli wawegalile isenga idala idung'hu liwele hela nongwa, na hambe yakoweligwe ngwamo ne hado. ");
INSERT INTO vid_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","Hemwe momha mtambika Eleasali isenga alyo. Lyolavigwa hanze ha kambi na kudumuligwa singo hali mtambika ayo. ");
INSERT INTO vid_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","“Hamba mtambika Eleasali kohola chasi cha danda na kumiza kwa chidole mala saba, kuno yolola kuli ubanzi wa kumwando mwa ihema lya Nguluwi. ");
INSERT INTO vid_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","Isenga alyo lyeng'ha lyolakazwa hali mtambika. Chila chinhu cholakazwa, igozi na miwunde na danda na mitumbu. ");
INSERT INTO vid_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","Hamba mtambika kohola igodi lilinguchemigwa mwelezi na nhagala ya isopolo na sufu ndung'hu na kuviwika kuli chiluli acho. ");
INSERT INTO vid_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","Hamba kahi, mtambika kohovuga mivalo ja heye na koga, hamba koweza kwinjila kuli kambi, ila kowa yakokomoche mbaka matinazo. ");
INSERT INTO vid_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","Munhu yolilakaza isenga alyo kahi kohovuga mivalo ja heye na koga, ila na heye kahi kowa yakokomoche mbaka matinazo. ");
INSERT INTO vid_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","Munhu yawele yelizwe kohola mivu ja isenga alyo na kugahilika kuli honhu helizwe kunze mwa kambi. Gowichigwa goya kwa Waisilaeli weng'ha kugongomanya mazi ga kusa kukokomoka, leka kusa gehile. ");
INSERT INTO vid_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","Munhu yoyokusa mivu ja isenga alyo imgana yahovuje mivalo ja heye, ila kowa yakokomoche mbaka matinazo. Ilajizo ali ndo lya mazuwa gose na lyowawala Waisilaeli na wajenzi wowochikala hamwe na hewo. ");
INSERT INTO vid_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","“Wone munhu kodoliza itufi lya munhu yoneche, kowa yakokomoche kwa mazuwa saba. ");
INSERT INTO vid_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","Zuwa lya kadatu na lya saba munhu ayo kochiyeliza kwa gala mazi ga kweliza, na heye kokwelizwa. Ila wone yoleka kiyeliza kuli zuwa lya kadatu na lya saba, munhu ayo kopona yawele yakokomoche. ");
INSERT INTO vid_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","Yalingudoliza mtufi, wone yoleka kiyeliza, kolidita liwe likokomoche ihema lya Mkulu Nguluwi, na heye kobaguligwa na wanhu wa Isilaeli. Munhu ayo kopona yawele yakokomoche kwa vila hambe yamizilwe mazi ga kweliza. ");
INSERT INTO vid_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","“Na ali ndo ilajizo lya kuwinzigwa wone wanhu wobagama mgati mwa ihema. Chila munhu hoyokwinjila mgati mwa ihema alyo ama yawele mgati mwa ihema alyo, kowa yakokomoche kwa mazuwa saba. ");
INSERT INTO vid_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","Chila chisaye na chijilo chiwele mwanzi chilihela chigubiko mchanya mwake, chowa chikokomoche. ");
INSERT INTO vid_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","Munhu yoneche yodoliza lukuli lwa yakopoligwe ama yabagame hela hanze ha ng'handa, ama yodoliza izeje lya munhu ama chilaga, kowa yakokomoche kwa mazuwa saba. ");
INSERT INTO vid_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","“Kwa chiwalo cha wala weditile wakokomoche wohola mivu ja isenga idung'hu liwele ndo nhambiko ya kusa gehile ilakazwe, mivu ajo johanzanyigwa na mazi ga kulwanda kuli chiya. ");
INSERT INTO vid_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","Munhu yunji yohawele yakokomoche, kohola nhagala ya isopolo, hamba koiwika kuli mazi ago, hamba kahi kolimizila ihema na vinhu vyeng'ha viwele mgati mwa ihema na wanhu wawele mgati. Kommizila kahi munhu yoyadolize izeje lya munhu ama lukuli lwa munhu yakopoligwe ama yabagame hela ama yoyadolize chilaga. ");
INSERT INTO vid_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","Kuli zuwa lya kadatu na lya saba, munhu yula yohawele yakokomoche kommizila munhu yakokomoche mazi ago, ahyo kuli zuwa lya saba, komweliza munhu ayo yakokomoche. Yula yawele yakokomoche kohovuga mivalo ja heye na koga, na matinazo kowa yelizwe hali Nguluwi. ");
INSERT INTO vid_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","“Ila wone munhu yawe yakokomoche na hambe yelizwe, munhu ayo kobaguligwa kuli Waisilaeli weng'ha, kwa vila kangulidita ihema lya Mkulu Nguluwi liwe likokomoche. Kwa vila hambe yamizilwe mazi ga kweliza, ka yakokomoche. ");
INSERT INTO vid_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","Wanhu woliwinza ilajizo ali kulawila sambi na mhela weng'ha. Munhu yomizila mazi ga kweliza kohovuga mivalo ja heye, na heye yalingudoliza mazi ago kowa yakokomoche mbaka matinazo. ");
INSERT INTO vid_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","Choneche choyodoliza munhu yakokomoche chowa chikokomoche, na yoneche yalingudoliza chinhu acho kowa yakokomoche mbaka matinazo.” ");
INSERT INTO vid_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","Waisilaeli weng'ha nawafika kuchiwala ako Sini mwezi wa mwaluko, nawawika kambi ako Kadeshi. Lowawele ako Miliamu nakabagama, nakatiligwa. ");
INSERT INTO vid_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","Honhu aho nahali haduhu mazi. Ahyo, Waisilaeli weng'ha nawekungajiza kuwabelenhuka Musa na Aluni. ");
INSERT INTO vid_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","Nawetwanza weng'ha wolonga, “Fola twahabagame hamwe na wang'holozetu hali ihema lya Mkulu Nguluwi! ");
INSERT INTO vid_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","Lekachoni mtugala aku kuchiwala hetwe wanhu wa Mkulu Nguluwi? Ndaze, mtugala aku leka tubagame hetwe na migongolo ja hetwe? ");
INSERT INTO vid_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","Lekachoni kahi namtulavya kula Misili na kutugala hano honhu hehile hino? Hano hakuwele honhu ha nyhule ne tini ne zabibu ne makomamanga. Na mazi ga kunwa kahi haduhu!” ");
INSERT INTO vid_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","Aho, Musa na Aluni nawoka kuli nhing'hano ayo ya wanhu, nawaluta kwima kuli lwizi lwa ihema lya Nguluwi, nawagwa chifunama. Lelo ukulu wa Mkulu Nguluwi nauwalawila, ");
INSERT INTO vid_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","na heye Mkulu Nguluwi nakamlonjela Musa, ");
INSERT INTO vid_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","“Uhole yila ng'hweku ya hegwe, hamba hegwe na Aluni mng'holozo, muwakungajize Waisilaeli weng'ha. Hamba, ulilonjele italawe liwele kumwando kwa hewo lilavye mazi. Ena, kolidita italawe lilavye mazi, leka nhanzi yeng'ha ya wanhu na migongolo ja hewo jinwe mazi.” ");
INSERT INTO vid_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","Musa nakaihola yila ng'hweku hali Mkulu Nguluwi kota navyoyalajizwe. ");
INSERT INTO vid_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","Hamba Musa na Aluni nawaikungajiza nhanzi ya wanhu weng'ha hali italawe, Musa nakawalonjela, “Mhulichize ng'hatu hemwe mlingubelenhuka. Ndaze, tuwalavile mazi kulawa kuli italawe ali?” ");
INSERT INTO vid_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","Hamba Musa nakenula moko wa heye, nakalitowa lila italawe mala mbili kwa ng'hweku ya heye. Mazi nagalawa kwa winji, Waisilaeli weng'ha nawanwa hamwe na migongolo ja hewo. ");
INSERT INTO vid_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","Ila Mkulu Nguluwi nakawalonjela Musa na Aluni, “Kwa vila hemwe namwali hambe mng'hunde ne kumha ukulu hali meho ga Waisilaeli, kwa chiwalo acho hamuwenjiza wanhu weng'ha wano kuli isi yila yondiwapele.” ");
INSERT INTO vid_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","Ago ndo mazi ga Meliba, honhu hawele Waisilaeli nawawele womng'ung'utila Mkulu Nguluwi, na heye nakelajila kota ka yelile hali hewo. ");
INSERT INTO vid_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","Musa nakahilika wasenga kulawa Kadeshi kwa Mndewa wa Edomu, nakawalonjela, “Wang'holozo, Waisilaeli, wangulonga hino, ‘Hegwe kuvizela ndaze vyotugaziche. ");
INSERT INTO vid_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","Vila wasekulu wa hetwe navyowalutile Misili, kuwele natikala ako kwa mhela winji na vila Wamisili navyowawagazile wasekulu wa hetwe na vyowatugazile hetwe. ");
INSERT INTO vid_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","Natumlilila Mkulu Nguluwi, na heye nakahulika kulila kwa hetwe, nakatugalila mhilisi yatulavile Misili. Lelo twa hano Kadeshi, muji uwele behi ng'hatu na isi ya hegwe. ");
INSERT INTO vid_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","Dedede utukundize tukole kuli isi ya hegwe. Hatubiga hebu migunda ja hemwe ne jila ja mizabibu ne kunwa mazi ga mizimbo ja hemwe. Tokola kuli nzila ng'hulu ya mndewa na kuka ne kuhinduka kumoso ne kudilo, mbaka hotulawa kuli isi ya hegwe.’ ” ");
INSERT INTO vid_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","Ila mndewa wa Edomu nakawedichila, “Hebu! Hamkola hebu kuli isi ya heni, wone mkole tolawa na kuwatowa kwa ipanga.” ");
INSERT INTO vid_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","Waisilaeli nawamlonjela, “Hetwe towinza nzila ng'hulu, wone hetwe na migongolo ja hetwe tonwa mazi ga hemwe tohilula. Chotulingulanda dedede utukundize hela, tukole kwa magulu hambe tugane choneche chinji.” ");
INSERT INTO vid_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","Ila mndewa wa Edomu nakalema ng'hatu na kulonga kahi, “Hamkola hebu.” Hamba Waedomu wawele na mong'ho nawalawa kitowa na hewo. ");
INSERT INTO vid_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","Lelo mndewa wa Edomu nakalema kuwakundiza Waisilaeli kukola kuli mbaka ja heye. Waisilaeli nawagaluka na kukola nzila yinji. ");
INSERT INTO vid_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","Waisilaeli weng'ha nawali mmajendo kulawa Kadeshi, nawafika kuli chidunda cha Holi. ");
INSERT INTO vid_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","Lelo Mkulu Nguluwi nakawalonjela Musa na Aluni ako kuli chidunda cha Holi, kuli mbaka mwa isi ya Edomu, ");
INSERT INTO vid_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","“Aluni kobagama, hambe yenjile kuli isi yondiwapele wanhu wa Isilaeli, kwa vila hemwe weli namuubelenhuka mzilo wa heni kula Meliba. ");
INSERT INTO vid_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","Uwahole Aluni na mwanage Eleasali, uwegale kuchanya kuli chidunda cha Holi. ");
INSERT INTO vid_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","Hamba, umvule Aluni mivalo ja heye ja utambika, umvalize mwanage Eleasali. Aluni kobagama yawele ako kuli chidunda.” ");
INSERT INTO vid_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","Musa nakadita kota navyoyalajizwe na Mkulu Nguluwi. Weng'ha wadatu nawakwina kuli chidunda cha Holi hali Waisilaeli weng'ha. ");
INSERT INTO vid_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","Hamba Musa nakamvula Aluni mivalo ja heye ja utambika, nakamvaliza mwanage Eleasali. Na heye Aluni nakabagama bahala kuchidunda acho. Hamba Musa na Eleasali nawadulika kulawa kuchidunda acho. ");
INSERT INTO vid_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","Waisilaeli weng'ha vyowahuliche kota Aluni nakabagama, nawawasiliza matanga kwa mhela wa mazuwa makumi gadatu. ");
INSERT INTO vid_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","Mndewa yumwe Mkanaani wa Aladi nayawele yochikala ako Negebu, navyoyahuliche mbuli ayi kota Waisilaeli nawali wokuya kwa nzila ya Atalimu, nakaluta kuwatowa, nakawahola wamwe wa hewo. ");
INSERT INTO vid_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","Aho Waisilaeli nawamlahila Mkulu Nguluwi wolonga, “Wone kowawika wanhu wano kuli moko ga hetwe, lelo tojidumya ng'hatu miji ja hewo.” ");
INSERT INTO vid_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","Mkulu Nguluwi nakahulika kulanda kwa hewo, nakawadita wawasumye Wakanaani. Waisilaeli nawawadumya ng'hatu Wakanaani hamwe na miji ja hewo. Ahyo honhu aho nahachemigwa Holima. ");
INSERT INTO vid_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","Waisilaeli nawaluka majendo kulawa chidunda cha Holi, nawakola nzila ilingulutila Bahali ya Shamu leka waizungulute isi ya Edomu. Ila lowawele mnzila, wanhu nawagozola. ");
INSERT INTO vid_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","Lelo nawaluka kuwang'ung'utila Nguluwi na Musa, wolonga, “Lekachoni namtulavya kula Misili leka tubagame aku kuchiwala? Aku kwa haduhu mazi ne chilyo, natwe natutoka kwa mana ayi chakachaka.” ");
INSERT INTO vid_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","Aho Mkulu Nguluwi nakegala mizoka jiwele na dunga hali wanhu, najiwaluma wanhu wenji mbaka Waisilaeli wenji kahi nawabagama. ");
INSERT INTO vid_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","Lelo wanhu nawamlutila Musa, nawamlonjela, “Natudita gehile kwa kuwang'ung'utila hegwe na Mkulu Nguluwi. Mlande Mkulu Nguluwi yatusile mizoka aji.” Ahyo, Musa nakawalandila wanhu. ");
INSERT INTO vid_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","Ahyo, na heye Mkulu Nguluwi nakamlonjela Musa, “Gongomanya izoka lya shaba, lininize mchanya mwa igodi. Munhu yoneche yolumigwa na izoka, yolilola izoka alyo lya shaba, kowa mkomu.” ");
INSERT INTO vid_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","Lelo Musa nakagongomanya izoka lya shaba, nakalininiza kuli izengo. Chila munhu yoyalumigwe na izoka loyalilolile izoka alyo lya shaba, nakawa mkomu. ");
INSERT INTO vid_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","Waisilaeli nawalutilila na majendo ga hewo, nawawika kambi ako Oboti. ");
INSERT INTO vid_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","Kulawa ako Oboti, nawali mmajendo mbaka nawafika Iye-Abalimu, kuli kuchiwala ubanzi wa kolilawilaga isanya mwa Moabu. ");
INSERT INTO vid_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","Kulawa ako nawaluta na kuwika kambi ya hewo kuli ibindi lya Seledi. ");
INSERT INTO vid_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","Kulawa ako nawaluta mbaka kasikazini mwa lwanda lwa Alinoni, nawawika kambi ya hewo, kuwele mazi nagabubujikaga kulawa isi ya Waamoli na kukola kuli kuchiwala. Lwanda lwa Alinoni nalwali ndo mbaka hali Wamoabu na Waamoli. ");
INSERT INTO vid_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","Kwa chiwalo acho, nayandichigwa kuli chitabu cha ngondo ya Mkulu Nguluwi. “Muji wa Wahebu kuli isi ya Sufa, na mibindi ja Alinoni ");
INSERT INTO vid_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","na kuli viduliko vya mibindi ulingifika mbaka kuli muji wa Ali, na kulutila kuli mbaka mwa Moabu.” ");
INSERT INTO vid_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","Kulawa ako, Waisilaeli nawali mmajendo mbaka Beeli, mina ndo izimbo liwele Mkulu Nguluwi nakamlonjela Musa, “Wakungajize wanhu hamwe na heni ndowapa mazi.” ");
INSERT INTO vid_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","Aho Waisilaeli nawemba lwimbo alu. “Bogome mazi gwa izimbo! Muyimbile! ");
INSERT INTO vid_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","Izimbo lyolibawigwe na wakulu, libawigwe ng'hatu na vilongozi kwa ng'hweku za hewo na mikongojo.” Kulawa kuchiwala, nawali mmajendo mbaka ako Matana, ");
INSERT INTO vid_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","kulawa Matana nawaluta mbaka Nahalieli na kulawa Nahalieli nawaluta mbaka Bamoti, ");
INSERT INTO vid_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","na kulawa Bamoti nawaluta mbaka kuli ibindi lilingwinjila isi ya Moabu, kuli chinhembenhembe cha chidunda cha Pisiga, chilingulola kuli kuchiwala. ");
INSERT INTO vid_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","Waisilaeli nawamhilichila usenga mndewa wa Waamoli yalinguchemigwa Sihoni, usenga awu, ");
INSERT INTO vid_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","“Utukundize tukole kuli isi ya hegwe, hatuluta hebu kula kufungo na kwinjila kuli migunda ama kuli migunda ja mizabibu ne kunwa mazi ga mizimbo ja hemwe. Tokola kuli nzila ng'hulu hela ya mndewa mbaka hotuloka isi ya hegwe.” ");
INSERT INTO vid_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","Ila Sihoni hambe yawakundize wanhu wa Isilaeli wakole kuli isi ya heye. Nakawakungajiza wanhu wa heye, nakaluta Yahasi kuchiwala kuwatowa Waisilaeli. ");
INSERT INTO vid_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","Ila Waisilaeli nawamkopola, nawaihola isi ya heye kulawa lwanda lwa Alinoni mbaka Yaboki, mina mbaka wa isi ya Waamoni nawali ukwamililwa ng'hatu. ");
INSERT INTO vid_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","Waisilaeli nawajihola miji aji jeng'ha na hewo nawekala kuli miji ja Waamoli hamwe na muji wa Heshiboni na vijiji vyake vyeng'ha. ");
INSERT INTO vid_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","Heshiboni nawali muji wa Sihoni, yawele mndewa wa Waamoli, yetowile na mndewa wa Moabu iwele aho hamwande, Sihoni nakaihola isi ya heye yeng'ha mbaka kuli lwanda lwa Alinoni. ");
INSERT INTO vid_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","Ndo mina walingwimba wa hetwe wangwimba. “Muye Heshiboni na kuzenga. Muji wa Sihoni nauzenjigwe na kwimizwa nzinzili. ");
INSERT INTO vid_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","Mina chiluli nachilawa Heshiboni, milapi ja chiluli najilawa kuli muji wa Sihoni, nakuudumya muji wa Ali wa Moabu, na kuvidumya vidunda vya lwanda lwa Alinoni. ");
INSERT INTO vid_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","Mochona wanhu wa Moabu! Namdumigwa, hemwe wanhu wa mlungu Kemoshi! Nakuwadita wana wa hegwe walume wawe wajenzi, wahinza wa hegwe nakuwaleka waholigwe wapogozi wa ngondo kwa Sihoni, mndewa wa Amoli. ");
INSERT INTO vid_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","Ila lelo walelwa wa hewo nawadumigwa, kulawa Heshiboni mbaka Diboni, kulawa Nashimu mbaka Nofa, behi na Medeba.” ");
INSERT INTO vid_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","Lelo Waisilaeli nawekala kuli isi ya Waamoli. ");
INSERT INTO vid_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","Hamba Musa nakalajiza wanhu kuupugajiza muji wa Yaseli, nawauhola hamwe na vijiji vyake vyeng'ha, nawawawinga Waamoli nawawele wochikala amo. ");
INSERT INTO vid_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","Waisilaeli nawahinduka na kuluta kuli nzila ya kuluta Bashani. Mndewa Ogu wa Bashani nakalawa na wanhu wa heye kuwatowa ako Edileyi. ");
INSERT INTO vid_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","Ila Mkulu Nguluwi nakamlonjela Musa, “Uleche kumdumba mina ndimuwika mmoko mwako hamwe na wanhu wa heye weng'ha na isi ya heye yeng'ha. Komditila kota vyoumditile Sihoni, mndewa wa Waamoli, yawele yochikala ako Heshiboni.” ");
INSERT INTO vid_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","Lelo Waisilaeli nawamkopola Ogu na wana wa heye weng'ha na wanhu wa heye weng'ha na kuwadumya, haponile ne munhu yoneche. Hamba nawaihola isi ya heye. ");
INSERT INTO vid_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","Waisilaeli nawaluka majendo kahi, nawaluta kuwika kambi ya hewo kuli ibalalika lya Moabu, kolilawilaga isanya mwa lwanda lwa Yolodani, lichilola na muji wa Yeliko. ");
INSERT INTO vid_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","Mndewa Balaki mwana wa Sipoli, nakazona mbuli zeng'ha ziwele Waisilaeli zowawaditile Waamoli. ");
INSERT INTO vid_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","Heye hamwe na Wamoabu nawawadumba ng'hatu Waisilaeli. Nawawadumba kwa chiwalo cha winji wa hewo. ");
INSERT INTO vid_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","Lelo Wamoabu nawawalonjela vilongozi wa Midiani, “Lung'hongola alu lyowifya chila chinhu hafungo mwa hetwe kota ibuguma vyolilingulya misolo kumgunda.” Ahyo, Balaki mwana wa Sipoli, nayawele mndewa wa Moabu mhela awo, ");
INSERT INTO vid_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","nakahilika usenga kwa Balaamu mwana wa Beoli, ako Petoli kota kuwele hafungo mwa lwanda mbaka kuli isi ya wanhu wa heye, yolonga, “Hana wanhu walawile Misili, nawo nawenela chila honhu hano muisi, na kahi wangikala behi na heni. ");
INSERT INTO vid_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","Uye lelo uwapanjile wanhu wano kwa chiwalo cha heni, mina wana mong'ho kusinda heni. Wone uwapanjile, hanji ndoweza kuwasumya na kuwawinga waleche kwinjila kuli isi ya heni, kwa vila ndivizela wone hegwe umtambichize munhu nakatambichizagwa na wone umpanjile munhu nakapanjilagwa.” ");
INSERT INTO vid_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","Lelo wakulu wa Moabu na Midiani nawahola sendi na kumha mlaguzi, nawoka kuluta kwa Balaamu. Nalowafichile, nawamha Balaamu usenga wa Balaki. ");
INSERT INTO vid_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","Balaamu nakawalonjela, “Muwase kuno nechilo ayi, nani ndowalonjela choyondonjela Mkulu Nguluwi.” Lelo wala vilongozi wa Moabu nawawasa kwa Balaamu. ");
INSERT INTO vid_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","Hamba Nguluwi nakamuyila Balaamu, nakamuuza, “Wanhu wachi wano nawekale na hegwe?” ");
INSERT INTO vid_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","Balaamu nakamwidichila Nguluwi, “Balaki, mndewa wa ako Moabu, mwana wa Sipoli, nakangalila usenga kota ");
INSERT INTO vid_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","hana wanhu walingulawa Misili, nawenela chila honhu hano muisi. Nakandanda ndikawapanjile wala wanhu leka hanji koweza kitowa na hewo na kuwawinga.” ");
INSERT INTO vid_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","Nguluwi nakamlonjela Balaamu, “Uleche kuka hamwe na wanhu wano ne kuwapanjila, mina nawatambichizwa.” ");
INSERT INTO vid_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","Lelo hamitondo Balaamu nakenuka, nakawalonjela wakulu wa Balaki, “Mhiluche kuli isi ya hemwe, kwa vila Mkulu Nguluwi hambe yagane kung'hundiza kuka hamwe na hemwe.” ");
INSERT INTO vid_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","Lelo wakulu wa Moabu nawoka, nawahiluka kwa Balaki, nawamlonjela, “Balaamu nakalema kuya hamwe na hetwe.” ");
INSERT INTO vid_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","Hamba, Balaki nakalajiza wakulu wanji, wenji lukami na wakulu ng'hatu kusinda wala wa mwaluko. ");
INSERT INTO vid_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","Na hewo nawafika kwa Balaamu, nawamlonjela, “Balaki mwana wa Sipoli, nakalonga hino, ‘Uleche kukunda kulemezwa na chinhu choneche na kulema kuya kwa heni. ");
INSERT INTO vid_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","Ndokulipa vinojile ng'hatu na choneche choundanda ndokuditila goya. Uye uwapanjile wanhu wano.’ ” ");
INSERT INTO vid_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","Ila Balaamu nakawedichila, “Hanga Balaki komha heni ng'handa ya heye imemile sendi na zahabu, heni siweza kuleka kuhulichiza ilajizo lya Mkulu Nguluwi, Nguluwi wa heni, kwa mbuli yoneche, ndodo ama ng'hulu. ");
INSERT INTO vid_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","Ila dedede, muwase hano nechilo ayi kota wala wayenu, nani ndovizela kahi choyondonjela Mkulu Nguluwi.” ");
INSERT INTO vid_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","Lelo Nguluwi nakamuyila Balaamu nechilo ayo, nakamlonjela, “Wone wanhu wano nawoya kukuchema, uche hamwe na hewo, ila udite chila chondikulonjela hela.” ");
INSERT INTO vid_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","Balaamu nakalilimka mitondo, nakaliwika goya idogowi lya heye, nakoka hamwe na hewo wakulu wa Moabu. ");
INSERT INTO vid_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","Nguluwi nakazudila ng'hatu kwa vila Balaamu nayali yoluta, ahyo mhilisi wa Mkulu Nguluwi nayali yatatamale mnzila kumlemeza kukola. Mhela awo Balaamu nayali yakwinile idogowi lya heye yawele na vitumagwa wa heye weli. ");
INSERT INTO vid_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","Lelo idogowi nalimona mhilisi ayo wa Mkulu Nguluwi yemile mnzila, yebatile ipanga lisomoligwe kuli yala yake. Ahyo nalileka nzila, naliluta hafungo. Balaamu nakalitowa idogowi alyo na kumhilula mnzila. ");
INSERT INTO vid_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","Hamba mhilisi ayo wa Mkulu Nguluwi nakalongola kumwando, nakema honhu hawele na nzila nzisili, hagati mwa migunda ja zabibu na lukanzi banzi zeng'ha mbili. ");
INSERT INTO vid_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","Lila idogowi lolimuwene yula mhilisi wa Mkulu Nguluwi, nalikundujiza lilyo mlukanzi na kumlumiza mgulu wa Balaamu baho. Lelo Balaamu nakalitowa kahi alyo idogowi. ");
INSERT INTO vid_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","Hamba mhilisi wa Mkulu Nguluwi nakalongola kahi na kwima hali honhu hazisili halihela honhu ha kukola, ne kumoso ne kudilo. ");
INSERT INTO vid_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","Idogowi lila lolimuwene yula mhilisi wa Mkulu Nguluwi, naliwasa hanyi. Balaamu nakazudila ng'hatu, nakalitowa na ng'hweku ya heye. ");
INSERT INTO vid_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","Aho, Mkulu Nguluwi nakalidita lila idogowi lilonje, idogowi nalimlonjela Balaamu, “Nandikuditila choni mbaka kunhowa heni mala zidatu azi?” ");
INSERT INTO vid_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","Balaamu nakalilonjela lila idogowi, “Hegwe nakumbeza heni. Wone nandali ndibatile ipanga, ndahawele ndikukopole sambi baha.” ");
INSERT INTO vid_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","Idogowi lila nalimlonjela Balaamu, “Ndaze, heni ndahawele idogowi lya hegwe likupapile kuli mhela weng'ha wa kikala kwa hegwe mbaka zuwa lya lehano? Ndaze, nanjeza kukuditila kota ahi aho hamwande?” Balaamu nakalidichila, “Hebu.” ");
INSERT INTO vid_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","Aho, Mkulu Nguluwi nakamdita Balaamu yalole, na heye nakamona mhilisi wa Mkulu Nguluwi yemile mnzila, yebatile ipanga lisomoligwe kuli yala yake. Balaamu naketoza hanyi chifunama. ");
INSERT INTO vid_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","Mhilisi wa Mkulu Nguluwi nakamlonjela Balaamu, “Lekachoni nakulitowa idogowi lya hegwe mala zidatu azi? Mbuya kukulemeza, kwa vila kulutilila na majendo ndo kwajilila. ");
INSERT INTO vid_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","Idogowi lya hegwe limbona heni mala azi zidatu nalikola hafungo mwa heni. Wone nahalikolile kutali na heni, ndahawele ndikukopola hegwe na kulileka idogowi ali.” ");
INSERT INTO vid_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","Balaamu nakamlonjela mhilisi wa Mkulu Nguluwi, “Ndita gehile mina hambe ndivizele kota nakwima mnzila kundemeza heni. Lelo wone hauganile heni ndutilile na majendo ago, ndohiluka haluga.” ");
INSERT INTO vid_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","Ila mhilisi wa Mkulu Nguluwi nakamlonjela Balaamu, “Ulute na wanhu wano, ila kolonga chila chondikulonjela hela,” Lelo Balaamu nakalutilila na majendo hamwe na wala vilongozi wa Balaki. ");
INSERT INTO vid_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","Balaki naloyahuliche kota Balaamu kanguya, nakalawa kuka kumbochela kuli muji wa Ali, muji nalouwele hafungo mwa lwanda lwa Alinoni kuli mbaka wa Moabu. ");
INSERT INTO vid_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","Balaki nakamlonjela Balaamu, “Lekachoni nahuyile kwa heni mala imwe hala hondikuchemile? Ndaze, nakujesa kota siweza kukulipa vinojile?” ");
INSERT INTO vid_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","Balaamu nakamwidichila Balaki, “Lelo mbuya. Ila, ndaze, ndina ludali lwa kulonga choneche chila? Mbuli yondonjela Mkulu Nguluwi ndo yoganigwa kulonga.” ");
INSERT INTO vid_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","Lelo Balaamu nakaluta hamwe na Balaki, nawafika kuli muji wa Kiliati-husoti. ");
INSERT INTO vid_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","Balaki nakalavya nhambiko ya isenga na ing'holo ako, nakawapa miwunde ajo Balaamu hamwe na vilongozi wawele hamwe na heye. ");
INSERT INTO vid_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","Hamitondo hake, Balaki nakamhola Balaamu, nakoka na heye mbaka Bamoti-baali, nalowawele ako, Balaamu nakawona Waisilaeli wamwe. ");
INSERT INTO vid_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","Balaamu nakamlonjela Balaki, “Nzenjele honhu saba ha kulavila nhambiko hamba ungalile mibuguma saba na ming'holo milume saba.” ");
INSERT INTO vid_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","Balaki nakadita kota Balaamu navyoyalonjile. Lelo nawalavya mchanya mwa chila honhu ha kulavila nhambiko ibuguma limwe na ing'holo ilume limwe. ");
INSERT INTO vid_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","Hamba Balaamu nakamlonjela Balaki, “Upone hano behi na nhambiko ya hegwe ya kulakazwa, nani ndute. Hanji Mkulu Nguluwi koting'hana na heni. Choneche choyondajila ndokuya kukulonjela.” Lelo Balaamu nakaluta yaliyeka mchanya mwa chinhembenhembe cha chidunda. ");
INSERT INTO vid_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","Nguluwi nakating'hana na heye. Balaamu nakamlonjela, “Mbika goya honhu saba ha kulavila nhambiko na kulavya nhambiko ya ibuguma limwe na ing'holo ilume limwe mchanya mwa honhu ha kulavila nhambiko.” ");
INSERT INTO vid_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","Mkulu Nguluwi nakamha Balaamu ulonzi woyalinguganigwa kulonga na kumlonjela yahiluche kwa Balaki. ");
INSERT INTO vid_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","Balaamu nakahiluka na nakamfika yemile bahala habehi na nhambiko ya heye ya kulakazwa, hamwe na vilongozi weng'ha wa Moabu. ");
INSERT INTO vid_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","Balaamu nakamha Balaki ulonzi wa heye, nakalonga, “Balaki nakengala hano kulawa Alamu, ena, mndewa wa Moabu nakengala kulawa vidunda vya kolilawilaga isanya. ‘Uye uwapanjile wanhu wa Yakobo kwa chiwalo cha heni, ena, uye uwalonje vibi Waisilaeli!’ ");
INSERT INTO vid_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","Ila ndompanjila ndaze munhu yawele Mkulu Nguluwi hambe yampanjile? Ndowalonga ndaze vibi wanhu wawele Mkulu Nguluwi hambe yawalonje vibi? ");
INSERT INTO vid_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","Kulawa kuli vinhembenhembe vya mitalawe nandiwona, kulawa mchanya mwa vidunda ndanguwasunjilila. Awo wanhu walingikala waliyeka, hawalingilola kota wanhu wa isi zinji. ");
INSERT INTO vid_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","Yalihi yoweza kuwawaza wanhu wa Yakobo kwa ndaze navyowawele wenji lukami, ama yoweza kuwaza honhu ha kane ha Waisilaeli? Hondibagama ndiwe kota munhu yatanganiche, kota Waisilaeli.” ");
INSERT INTO vid_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","Aho Balaki nakamlonjela Balaamu, “Nakunditila choni? Ndikugala hano leka uwapanjile wang'honyo wa heni, ila hegwe kwanguwatambichiza!” ");
INSERT INTO vid_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","Balaamu nakamlonjela Balaki, “Ndanguganigwa kulonga ulonzi wa Mkulu Nguluwi hela.” ");
INSERT INTO vid_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","Hamba Balaki nakamlonjela Balaamu, “Tulute honhu hanji hawele koweza kuwona, ila kowona wamwenga wa hewo hela, howeza kuwona weng'ha. Hamba, aho kowapanjila kwa chiwalo cha heni.” ");
INSERT INTO vid_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","Ahyo Balaki nakamhola Balaamu kuli mgunda wa Sofimu, mchanya mwa chinhembenhembe cha chidunda cha Pisiga. Aho nakazenga honhu saba ha kulavila nhambiko na kulavya nhambiko mchanya mwake, nhambiko ya ibuguma limwe na ing'holo ilume limwe. ");
INSERT INTO vid_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","Balaamu nakamlonjela Balaki, “Upone hano behi na nhambiko ya hegwe ya kulakazwa, nani ndute kula kumwambu kiting'hana na Mkulu Nguluwi.” ");
INSERT INTO vid_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","Mkulu Nguluwi nakating'hana na Balaamu, nakamha ulonzi woyolonga, na kumlonjela yahiluche kwa Balaki. ");
INSERT INTO vid_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","Lelo Balaamu nakahiluka, nakamfika Balaki yemile habehi na nhambiko ya heye ya kulakazwa hamwe na vilongozi weng'ha wa Moabu. Balaki nakamuuza, “Mkulu Nguluwi nakakulonjela choni?” ");
INSERT INTO vid_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","Aho, Balaamu nakamlavila Balaki ulonzi wa heye. “Wime Balaki, uhuliche, unyhulichize gwa mwana wa Sipoli. ");
INSERT INTO vid_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","Nguluwi hawele munhu, yalonje udesi, ne munhu yagaluse kijesa kwa heye! Ndaze, kolagana na wanhu chinhu na yaleche kudita, ama yalonje chinhu na yaleche kweneza? ");
INSERT INTO vid_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","Ulole, mhegwa mzilo wa kutambichiza, na heye nakatambichiza, heni siweza hebu kugalusa. ");
INSERT INTO vid_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","“Mkulu Nguluwi hawonile wihe wa wana wa Yakobo, ne kulema kwa hewo wana wa Isilaeli. Mkulu Nguluwi, Nguluwi wa hewo ka hamwe na hewo, heye nakabochelaga lutogo lwa wandewa. ");
INSERT INTO vid_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","Nguluwi nayawaholile kulawa Misili, naketwanza na wang'honyo wa hewo kota ibogo. ");
INSERT INTO vid_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","Ndangukomya, uhawi hauweza hebu kuwasumya wanhu wa Yakobo, ne upanjilo kwa wanhu wa Isilaeli. Lelo wanhu wolonga, kuwala Isilaeli, ‘Mlole vinduzanduza vyoyaditile Nguluwi!’ ");
INSERT INTO vid_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","Ulole, kota isimba idala nawenuka, kota isimba ilume wangwima, Waisilaeli hawokwesela mbaka webate chila chowalinguwinga, na kunwa danda ya chila chowalinguwinga.” ");
INSERT INTO vid_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","Aho Balaki nakamlonjela Balaamu, “Lelo uleche kuwapanjila ne kuwatambichiza!” ");
INSERT INTO vid_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","Ila Balaamu nakamwidichila Balaki, “Ndaze, sikulonjele heni kota nachoyalonjile Mkulu Nguluwi ndo chondiganigwa kudita?” ");
INSERT INTO vid_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","Balaki nakamlonjela Balaamu, “Uye, ndokuhilika honhu hanji. Hanji Nguluwi konojezwa leka uwapanjile wanhu awo kulawa ako kwa chiwalo cha heni.” ");
INSERT INTO vid_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","Ahyo, Balaki nakamhola Balaamu mbaka kuli chinhembenhembe cha chidunda cha Peoli, hawele wone munhu yeme aho, koweza kuchona chiwala. ");
INSERT INTO vid_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","Balaamu nakamlonjela Balaki, “Nzenjele hano honhu saba ha kulavila nhambiko, umbichile goya mibuguma saba na ming'holo milume saba.” ");
INSERT INTO vid_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","Balaki nakadita kota navyoyalonjelwe na Balaamu, hamba nakalavya nhambiko ya ibuguma limwe na ing'holo ilume limwe mchanya mwa chila honhu ha kulavila nhambiko. ");
INSERT INTO vid_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","Lelo Balaamu nakavizela kota Mkulu Nguluwi nakagana kuwatambichiza Waisilaeli, ahyo nahalutile kulagula kahi, nayali yolola kuchiwala. ");
INSERT INTO vid_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","Balaamu nakalola, nakawona Waisilaeli wawichile kambi, chila nhanzi hali honhu hake. Hamba muhe wa Nguluwi naumuyila, ");
INSERT INTO vid_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","na heye nakadamla ulonzi awu wa chiuloli, “Ulonzi wa heni Balaamu mwana wa Peoli ulonzi wa munhu yagubuligwe meho, ");
INSERT INTO vid_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","ulonzi wa munhu yahuliche ulonzi wa Nguluwi, munhu yalolile ulaguzi wa Nguluwi yawele na mong'ho, munhu yalingufugama na kona hazelu. ");
INSERT INTO vid_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","“Mihema ja hegwe jinoga ndaze hemwe wanhu wa Yakobo, ena, kambi za hemwe zinoga ndaze hemwe wanhu wa Isilaeli! ");
INSERT INTO vid_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","“Avi ndo kota mibindi jilingubogoma mazi, kota kagunda hafungo mwa lwanda, kota mitembwe joyanyalile Mkulu Nguluwi, kota igodi lya mwelezi hafungo mwa mazi. ");
INSERT INTO vid_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","Viya vya hewo vyowa na mazi menji, nyhadikwa ya hewo yonyaligwa hali honhu hawele na mazi ga kuhega. Mndewa wa hewo kowa mkulu kusinda Agagi, na undewa wa heye wowa ukulu ng'hatu. ");
INSERT INTO vid_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","“Nguluwi nakawahola kulawa Misili, na heye naketwanza ng'hatu na wang'honyo wa hewo, kota ibogo. Kozidumya nhanzi zoziwele wang'honyo wa hewo, kobenanga mizeje ja hewo, kowahoma kwa misale ja heye. ");
INSERT INTO vid_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","Kowasa hasi kota isimba, yalihi yojeza kumlilimla? “Yoneche yokutambichiza, kotambichizwa, yoneche yokupanjila, kopanjilwa.” ");
INSERT INTO vid_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","Balaki nakazudila ng'hatu kwa chiwalo cha Balaamu, nakafumbata moko ga heye kwa kuzudila na kumlonjela, “Ndikuchema leka uwapanjile wang'honyo wa heni, ila mala zidatu zeng'ha azi kwanguwatambichiza! ");
INSERT INTO vid_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","Lelo lute hali honhu ha hegwe. Nangana ndikupe ndolendole nyinji, ila Mkulu Nguluwi nakakulemeza kubochela ndolendole azo.” ");
INSERT INTO vid_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","Balaamu nakamwidichila Balaki, “Ndaze, siwalonjela hebu wala wasenga wouwalajize kwa heni ");
INSERT INTO vid_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","kota hanga naumhe ng'handa ya hegwe imemile sendi na zahabu, heni siweza kubelenhuka ilajizo lya Mkulu Nguluwi, kwa kudita mbuli yoneche, ihile ama inojile kwa kunuwila nene baha. Nandonga kota choyolonga Mkulu Nguluwi ndo chondilonga heni. ");
INSERT INTO vid_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","“Lelo ndanguhiluka kwa wanhu wa heni, ila nding'hali kuka, leka ndikulonjele mbuli ziwele wanhu wano vyowowaditila wanhu wa hegwe mazuwa galinguya.” ");
INSERT INTO vid_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","Lelo Balaamu nakalonga ulonzi awu, “Ulonzi wa heni Balaamu mwana wa Beoli, ulonzi wa munhu yagubuligwe meho, ");
INSERT INTO vid_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","ulonzi wa munhu yoyahuliche ulonzi wa Nguluwi, na munhu yavizelele uwanzi wa Nguluwi yawele kuchanya, munhu yalingona ulaguzi wa Nguluwi yawele na Mong'ho, munhu yalingufugama na kona hazelu. ");
INSERT INTO vid_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","“Ndangumona, ila haiwele sambi, ndangumlola, ila ka kutali. Nhondwe yolawila kwa walelwa wa Yakobo, kolawila mndewa hali Waisilaeli. Kwa ng'hweku ya heye kowasubula vilongozi wa Wamoabu, kowadumya walelwa weng'ha wa Seti. ");
INSERT INTO vid_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","Edomu yowa ya heye, Seili yowa ya heye, Isilaeli yowa na kusumya kukulu. ");
INSERT INTO vid_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","Yumwe wa walelwa wa Yakobo kolongoza na heye kowadumya wawele wopona kuli muji.” ");
INSERT INTO vid_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","Hamba Balaamu nakawalola Waamaleki, nakalonga, “Waamaleki ndo wanhu wa isi ya mwaluko wawele na mong'ho kusinda weng'ha, ila mwiso wodumigwa ng'hatu.” ");
INSERT INTO vid_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","Hamba Balaamu nakawalola Wakeni, nakalavya ulonzi awu, “Ng'handa za hemwe za goya, hemwe Wakeni, kota chimvulila mchanya ng'hatu mwa italawe. ");
INSERT INTO vid_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","Ila modumigwa, hemwe Wakeni. Mbaka Ashulu hoyowahola hemwe kuwa wapogozi wa ngondo.” ");
INSERT INTO vid_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","Balaamu nakalavya ulonzi kahi, “Hambi! Yalihi yochikala, hala Mkulu Nguluwi hoyodita mbuli azo? ");
INSERT INTO vid_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","Meli zofika kulawa Kitimu, wozitowa Ashulu na Ebeli, na hewo kahi wodumigwa.” ");
INSERT INTO vid_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","Ahyo, Balaamu nakoka, nakahiluka haluga ha heye, Balaki kahi nakoka. ");
INSERT INTO vid_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","Waisilaeli nalowawele ako Shitimu, walume nawaluka kudita ung'hondwa na wadala wa Moabu. ");
INSERT INTO vid_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","Wadala awo nawawalalika Waisilaeli wehanze kuli nhambiko yowaiwichile kwa chiwalo cha milungu ja hewo, na hewo Waisilaeli nawalya na kujifugamila milungu ja hewo. ");
INSERT INTO vid_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","Ahyo ndo Waisilaeli navyowehanzile na mlungu Baali wa Peoli, na Mkulu Nguluwi nakawazudila ng'hatu. ");
INSERT INTO vid_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","Lelo Mkulu Nguluwi nakamlonjela Musa, “Wahole vilongozi weng'ha wa wanhu, uwakopole hali heni hali isanya, leka ng'halazi ya heni kwa hemwe ikole.” ");
INSERT INTO vid_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","Musa nakawalonjela walamuzi wa Isilaeli, “Chila yumwe wa hemwe yamkopole munhu yoneche hali hemwe yehanzile na mlungu Baali wa Peoli.” ");
INSERT INTO vid_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","Mhela wuwo munhu yumwe Muisilaeli nakamigala mdala yumwe Mmidiani haluga ha heye, hali Musa na Waisilaeli weng'ha, lowawele wolombocheza hali lwizi lwa ihema lya Nguluwi. ");
INSERT INTO vid_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","Lelo Finehasi mwana wa Eleasali, mwana wa mtambika Aluni, naloyawene mbuli ayo, nakenuka na kulawa kuli Waisilaeli weng'ha, nakahola umbaji ");
INSERT INTO vid_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","na kumuwinza yula Muisilaeli mbaka kuli ihema, nakawahoma umbaji weng'ha weli kuli munda. Utamwa wihile louwagazile nauwadumya Waisilaeli nausumigwa. ");
INSERT INTO vid_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","Wanhu wabagame kwa chiwalo cha utamwa ula nawali elufu makumi meli na gane (24,000). ");
INSERT INTO vid_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","Mkulu Nguluwi nakamlonjela Musa, ");
INSERT INTO vid_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","“Finehasi mwana wa Eleasali, mwana wa mtambika Aluni, nakalemeza ng'halazi ya heni kwa chiwalo cha Waisilaeli hali hemwe, ndo heye yawele na fihi kota yondiwelenayo heni. Ndo mina hambe ndiwadumye hebu Waisilaeli weng'ha kwa ng'halazi ya heni. ");
INSERT INTO vid_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","Lelo mlonjele kota ndangudita ilagano lya kikala goya na heye. ");
INSERT INTO vid_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","Ndangulagana na heye na walelwa wa heye wowa watambika mazuwa gose kwa vila nakona fihi kwa chiwalo cha heni, Nguluwi wa heye, nakawaditila uhanyisi Waisilaeli.” ");
INSERT INTO vid_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","Ayo Muisilaeli nayabagame hamwe na mdala Mmidiani nayali yochemigwa Simuli mwana wa Salu, chilongozi wa ivyazi limwenga kuli nhanzi ya Simeoni. ");
INSERT INTO vid_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","Na ayu mdala Mmidiani nayakopoligwe nayali yochemigwa Kosibi mhinza wa Suli, nayawele chilongozi wa nhanzi imwenga ako Midiani. ");
INSERT INTO vid_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","Mkulu Nguluwi nakamlonjela Musa, ");
INSERT INTO vid_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","“Waditile Wamidiani kota wang'honyo na kuwadumya, ");
INSERT INTO vid_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","kwa vila nawawaditila hemwe kota wang'honyo kwa uhadi wa hewo, nawawahada kuwala mbuli ya Peoli, na kwa chiwalo cha Kosibi, mhinza wa chilongozi wa Midiani, nayakopoligwe mhela wa utamwa wihile naloulawile ako Peoli.” ");
INSERT INTO vid_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","Navyoumalile awo utamwa, Mkulu Nguluwi nakawalonjela Musa na Eleasali mwana wa mtambika Aluni, ");
INSERT INTO vid_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","“Muwawaze wanhu weng'ha wa Waisilaeli weng'ha, chila munhu kota navyoiwele ivyazi lya heye. Muwawaze wanhu weng'ha wawele na miyaka makumi meli na mzidi wawele woweza kuza kitowa ngondo.” ");
INSERT INTO vid_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","Musa na mtambika Eleasali nawalongasa na wanhu kuli isi iwele na ibalalika lya Moabu, kumwambu mwa lwanda lwa Yolodani ilingilola na Yeliko, nawawalonjela, ");
INSERT INTO vid_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","“Muwawaze wanhu wawele na miyaka makumi meli na mzidi, kota Mkulu Nguluwi vyoyamlajize Musa.” Waisilaeli walawile Misili ndo awa. ");
INSERT INTO vid_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","Nhanzi ya Lubeni, mwana wa mwaluko kwa Yakobo, ng'holo za Hanoki na Palu ");
INSERT INTO vid_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","na Hesiloni na Kalimi. ");
INSERT INTO vid_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","Ng'holo za nhanzi ya Lubeni nawawazigwe, nawali walume elufu makumi gane na gadatu na miya saba na makumi gadatu (43,730). ");
INSERT INTO vid_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","Mlelwa wa Palu nayali Eliabu ");
INSERT INTO vid_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","na wana wa Eliabu, wawele ndo Nemueli na Datani na Abilamu. Awa weli, Datani na Abilamu ndo nawali wahaguligwe hali Waisilaeli weng'ha, ila nawawalema Musa na Aluni, na kihanza na wanhu walingumuwinza Kola mhela nalowambelenhuche Mkulu Nguluwi. ");
INSERT INTO vid_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","Mhela awo misanga najigubuka najiwamela, nawabagama hamwe na Kola na wala wanhu weng'ha walingumuwinza heye. Chiluli navyochiwalakaze wanhu miya mbili na makumi gahano, nawali ulanguso kwa wanhu. ");
INSERT INTO vid_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","Ila walelwa wa Kola nahawabagame. ");
INSERT INTO vid_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","Nhanzi ya Simeoni ndo ng'holo za Nemueli na Yamini na Yakini ");
INSERT INTO vid_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","na Sela na Shauli. ");
INSERT INTO vid_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","Azo ndo ng'holo za nhanzi ya Simeoni, walume weng'ha nawali elufu makumi meli na mbili na miya mbili (22,200). ");
INSERT INTO vid_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","Nhanzi ya Gadi ndo ng'holo za Sefoni na Hagi na Shuni ");
INSERT INTO vid_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","na Osini na Eli ");
INSERT INTO vid_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","na Alodi na Aleli. ");
INSERT INTO vid_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","Azo ndo ng'holo za nhanzi ya Gadi, nawali walume elufu makumi gane na miya zihano (40,500). ");
INSERT INTO vid_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","19","Na wana wa Yuda nawali Eli na Onani. Awa nawabagama kuli isi ya Kanaani. ");
INSERT INTO vid_vpl VALUES ("NU26_20","005_26_20","NUM","26","20","20","Nhanzi ya Yuda ndo ng'holo za Shela na Pelesi na Sela. ");
INSERT INTO vid_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","Walelwa wa Pelesi ndo ng'holo za Hesiloni na Hamuli. ");
INSERT INTO vid_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","Azo ndo ng'holo za Yuda, nawali walume elufu makumi saba na sita na miya zihano (76,500). ");
INSERT INTO vid_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","Nhanzi ya Isakali ndo ng'holo za Tola na Puva ");
INSERT INTO vid_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","na Yashubu na Shimuloni. ");
INSERT INTO vid_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","Azo ndo ng'holo za Isakali, nawali walume elufu makumi sita na gane na miya zidatu (64,300). ");
INSERT INTO vid_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","Nhanzi ya Sebuluni ndo ng'holo za Seledi na Eloni na Yaleeli. ");
INSERT INTO vid_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","Azo ndo ng'holo za Sebuluni, nawali walume elufu makumi sita na miya zihano (60,500). ");
INSERT INTO vid_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","Nhanzi ya Yusufu mhaza wa hewo Manase na Efulaimu. ");
INSERT INTO vid_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","Nhanzi ya Manase ndo ng'holo za Makili na Gileadi. Gileadi nayali mwana wa Makili. ");
INSERT INTO vid_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","Walelwa wa Gileadi ndo ng'holo za Yeseli na Heleki ");
INSERT INTO vid_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","na Asilieli na Shekemu ");
INSERT INTO vid_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","na Shemida na Hefeli. ");
INSERT INTO vid_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","Selofehadi, mwana wa Hefeli hapatile wana walume ila wadala hela, na hewo ndo Mala na Noa na Hogula na Milika na Tilisa. ");
INSERT INTO vid_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","Azo ndo ng'holo za Manase, nawali walume elufu makumi gahano na mbili na miya saba (52,700). ");
INSERT INTO vid_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","Nhanzi ya Efulaimu ndo ng'holo za Shutihela na Bekeli na Tahani. ");
INSERT INTO vid_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","Lukolo lwa Elani nalulawa kwa Shutihela. ");
INSERT INTO vid_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","Azo ndo ng'holo za Efulaimu, nawali walume elufu makumi gadatu na mbili na miya zihano (32,500). Zeng'ha azo nazilawila kwa Yusufu. ");
INSERT INTO vid_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","Nhanzi ya Benjamini ndo ng'holo za Bela na Ashibeli na Ahilamu ");
INSERT INTO vid_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","na Shefufamu na Hufamu. ");
INSERT INTO vid_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","Ng'holo za Alidi na Naamani, nazilawila kwa Bela. ");
INSERT INTO vid_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","Azo ndo ng'holo za Benjamini, nawali walume elufu makumi gane na zihano na miya sita (45,600). ");
INSERT INTO vid_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","Nhanzi ya Dani nayali ya lukolo lwa Shuhamu. ");
INSERT INTO vid_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","Lukolo nalwali na walume elufu makumi sita na gane na miya zine (64,400). ");
INSERT INTO vid_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","Nhanzi ya Asheli ndo ng'holo za Imuna na Ishivi na Belia. ");
INSERT INTO vid_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","Ng'holo za Hebeli na Malikieli nazilawila kwa Belia. ");
INSERT INTO vid_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","Asheli nayali na mhinza yalinguchemigwa Sela. ");
INSERT INTO vid_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","Azo ndo ng'holo za nhanzi ya Asheli, nawali walume elufu makumi gahano na zidatu na miya zine (53,400). ");
INSERT INTO vid_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","Nhanzi ya Nafutali ndo ng'holo za Yaseeli na Guni ");
INSERT INTO vid_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","na Yeseli na Shilemu. ");
INSERT INTO vid_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","Azi ndo ng'holo za nhanzi ya Nafutali, walume nawali elufu makumi gane na zihano na miya zine (45,400). ");
INSERT INTO vid_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","Walume Waisilaeli wawazigwe nawali lachi sita na elufu imwe na miya saba na makumi gadatu (601,730). ");
INSERT INTO vid_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","Hamba Mkulu Nguluwi nakamlonjela Musa, ");
INSERT INTO vid_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","“Nhanzi azi zopegwa isi iwe uhalizi wa hewo wawo, kwa chiwalo cha winji wa matagwa ga hewo wawo. ");
INSERT INTO vid_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","Nhanzi ng'hulu yopegwa honhu hawo hakulu na nhanzi ndodo yopegwa honhu hawo hadodo. Chila nhanzi yopegwa honhu hake ha uhalizi kwa chiwalo cha winji wa wanhu vyowali. ");
INSERT INTO vid_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","Na ako kugawilwa kwa isi koditigwa kwa kutowa simbi. Chila nhanzi yohalila kwa chiwalo cha matagwa ga lukolo lwa hewo. ");
INSERT INTO vid_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","Uhalizi wa chila nhanzi woditigwa kwa kutowa simbi, chila nhanzi yopegwa kwa chiwalo cha ukulu ama udodo wake.” ");
INSERT INTO vid_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","Azi ndo ng'holo za Walawi ziwazigwe na walelwa wa hewo Gelishoni na Kohati na Melali. ");
INSERT INTO vid_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","Hamwe na ng'holo za Libuni na Hebuloni na Mahili na Mushi na Kola. Kohati nayali mhaza wa Amulamu. ");
INSERT INTO vid_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","Mchewake Amulamu nakachemigwa Yokebedi mwana wa heye Lawi, yavumbuche Misili. Ayu nakampondela Amulamu wana weli walume, Aluni na Musa, na mhinza yumwe, Miliamu. ");
INSERT INTO vid_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","Aluni nayali na wana walume wane, Nadabu na Abihu na Eleasali na Itamali. ");
INSERT INTO vid_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","Nadabu na Abihu nawabagama vyowamlavile Mkulu Nguluwi nhambiko ya chiluli, yohaikundigwe. ");
INSERT INTO vid_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","Walawi walume wawele na mwezi umwe na mzidi nawali elufu makumi meli na gadatu (23,000). Awa nahawawazigwe hamwe na Waisilaeli wanji kwa vila hewo nahawapeligwe isi kota uhalizi woneche hali hewo. ");
INSERT INTO vid_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","Awo ndo walume Waisilaeli wawazigwe na Musa na mtambika Eleasali kuli isi iwele na ibalalika lya Moabu, kumwambu mwa lwanda lwa Yolodani ilingilola na Yeliko. ");
INSERT INTO vid_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","Hali hewo hali haduhuli ne munhu yumwe hali wala wawazigwe na Musa na mtambika Aluni na ndo nawawazigwe aho mwaluko kuchiwala ako Sinai. ");
INSERT INTO vid_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","Mkulu Nguluwi nakalonga kota weng'ha wobagama wawele ako kuchiwala, na kukomya, haduhu ne yumwe wa hewo yasigale yawele mkomu, ila Kalebu mwana wa Yefune na Yoshua mwana wa Nuni. ");
INSERT INTO vid_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","Mhela awo, Mala na Noa na Hogula na Milika na Tilisa, wahinza wa Selofehadi, nawahejela. Na heye Selofehadi nayali mwana wa Hefeli, mwana wa Gileadi, mwana wa Makili, mwana wa Manase mwana wa Yusufu. ");
INSERT INTO vid_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","Lelo wahinza weng'ha awo wahano nawamlutila Musa, nawema hali heye na mtambika Eleasali na vilongozi weng'ha wa Waisilaeli weng'ha, hali lwizi lwa ihema lya Nguluwi, nawalonga, ");
INSERT INTO vid_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","“Mhaza wa hetwe nakabagama kuchiwala, nahawele kuli wala wanhu weng'ha welumbile kumditila vibi Mkulu Nguluwi, kuli chilundo cha Kola, ila nakabagama kwa gehile ga heye yuye. Nahawele na mwana yoneche mlume. ");
INSERT INTO vid_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","Lelo lekachoni itagwa lya mhaza wa hetwe lyusigwe kuli lukolo lwa heye kwa vila haduhu mwana mlume? Twangugana uhalizi hamwe na wang'holoze mhaza wa hetwe.” ");
INSERT INTO vid_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","Musa nakegala mbuli ya hewo hali Mkulu Nguluwi. ");
INSERT INTO vid_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","Mkulu Nguluwi nakamlonjela Musa, ");
INSERT INTO vid_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","“Chowalingulonga wahinza wa Selofehadi ndo cha kukomya, wagawile uhalizi hamwe na wang'holoze mhaza wa hewo, wahole uhalizi wa heye. ");
INSERT INTO vid_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","Hamba walonjele Waisilaeli kota munhu yoneche wone yabagame ne kuleka mwana mlume, uhalizi wa heye kopegwa mwana wa heye mdala. ");
INSERT INTO vid_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","Ila wone kahela mhinza, uhalizi wa hewo wopegwa wang'holoze walume. ");
INSERT INTO vid_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","Na wone kahela wang'holoze walume, uhalizi wa heye woluta kwa wang'holoze wa mhaza wa heye, mkulu ama mdodo. ");
INSERT INTO vid_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","Na wone mhaza wa heye kahela wang'holoze walume, lelo uhalizi wa heye wowa wa wanhu wa nhanzi ya heye ya habehi, na wowa wa heye. Ali ndo lyowa ilajizo na mzilo kwa Waisilaeli, kota vila heni Mkulu Nguluwi vyondikulajize, hegwe Musa.” ");
INSERT INTO vid_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","Mkulu Nguluwi nakamlonjela Musa, “Ukwine mchanya mwa chidunda achi cha vigongo vya Abalimu leka uilole isi yondiwapele Waisilaeli. ");
INSERT INTO vid_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","Louyona, nagwe kobagama kota vila mng'holozo Aluni navyoyabagame, ");
INSERT INTO vid_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","kwa vila hambe mhulichize mzilo wa heni kula kuchiwala Sini. Mhela Waisilaeli weng'ha lowamng'ung'utile kwa chiwalo cha heni kula Meliba, humhele ukulu hali hewo lowaganile wapegwe mazi.” Meliba ndo nzasa ya mazi ako Kadeshi kuli kuchiwala ako Sini. ");
INSERT INTO vid_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","Na heye Musa nakamlanda Mkulu Nguluwi yolonga, ");
INSERT INTO vid_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","“Gwa Mkulu Nguluwi, Nguluwi uwele mwaluko wa ukomu wa weng'ha, ndangukulanda umhagule munhu wa kuwalongoza Waisilaeli weng'ha, ");
INSERT INTO vid_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","yawele kowalongola kuwalongoza kuli mbuli za hewo zeng'ha, leka Waisilaeli weng'ha wa Mkulu Nguluwi waleche kuwa kota ming'holo jilihela mdimi.” ");
INSERT INTO vid_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","Mkulu Nguluwi nakamlonjela Musa, “Mhole Yoshua mwana wa Nuni, munhu yawele muhe wa Mkulu Nguluwi ka mgati mwa heye, hamba umuwichile moko, ");
INSERT INTO vid_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","na kumwimiza hali mtambika Eleasali na Waisilaeli weng'ha, umhe mijito ajo. ");
INSERT INTO vid_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","Umhe honhu ha ludali lwa hegwe leka Waisilaeli weng'ha wamhulichize. ");
INSERT INTO vid_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","Heye komtumbila mtambika Eleasali yawele komlonjela choni chondilingugana kwa Ulimu na Sumimu. Kwa nzila ayi, Eleasali kowalongoza Yoshua na Waisilaeli weng'ha kuli mbuli za hewo zeng'ha” ");
INSERT INTO vid_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","Musa nakadita kota navyoyalajizwe na Mkulu Nguluwi. Nakamhola Yoshua na kumwimiza hali mtambika Eleasali na Waisilaeli weng'ha. ");
INSERT INTO vid_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","Hamba nakamuwichila moko kwa kumdita yawe chilongozi kota Musa navyoyalajizwe na Mkulu Nguluwi. ");
INSERT INTO vid_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","Mkulu Nguluwi nakamlonjela Musa, ");
INSERT INTO vid_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","“Walonjele Waisilaeli kota hemwe mondavila kwa mhela wa nhambiko zilinguganigwa, vilyo vya kulakazwa kwa chiluli, viwele na unhunyhililo unojile wa kunojeza heni. ");
INSERT INTO vid_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","Walonjele kota nhambiko yowondavila heni Mkulu Nguluwi kwa chiluli, yowa ming'holo myana mili milume ja mwaka umwe jilihela nongwa yoneche, kwa chiwalo cha nhambiko ya kulakazwa ya chila zuwa. ");
INSERT INTO vid_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","Ing'holo lyana limwe lyolavigwa mitondo na lya keli lyolavigwa mhela wa kuzinga kwa isanya, ");
INSERT INTO vid_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","chila limwe lyolavigwa hamwe na nhambiko ya nyhule ya kilo imwe ya utimbo unojile uhanzigwe hamwe na lita imwe ya mafuta ganojile gahondigwe. ");
INSERT INTO vid_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","Ayi ndo nhambiko ya kulakazwa ilingulavigwa chila zuwa, iwele nailajizwe hala kuli chidunda cha Sinai kota unhunyhililo unojile, nhambiko yalingulavilwa Mkulu Nguluwi kwa chiluli. ");
INSERT INTO vid_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","Nhambiko ya chakunwa yoilingulavigwa na chila ing'holo lyana, ndo lita imwe ya divai. Koijida nhambiko ayi ya chakunwa hali honhu helile ha Mkulu Nguluwi. ");
INSERT INTO vid_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","Mhela wa kuzinga kwa isanya kolilavya lila ing'holo lyana liyage hamwe na nhambiko ya nyhule na ya chakunwa kota yoilavigwe mitondo, kolavya kota nhambiko yalingulavilwa Mkulu Nguluwi kwa chiluli, nhambiko iwele na unhunyhililo unojile wa kumnojeza Mkulu Nguluwi. ");
INSERT INTO vid_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","“Zuwa lya Kwesela, molavya nhambiko ya ming'holo myana mili milume ja mwaka umwe jilihela nongwa, nhambiko ya nyhule ya kilo mbili za utimbo unojile uhanzigwe na mafuta, na nhambiko yake ya chakunwa. ");
INSERT INTO vid_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","Nhambiko ayi ya kulakazwa yolavigwa chila Zuwa lya Kwesela ne kuwaza yila nhambiko ya chila zuwa hamwe na nhambiko yake ya chakunwa. ");
INSERT INTO vid_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","“Kuli mwaluko wa chila mwezi, momlavila Mkulu Nguluwi nhambiko ya kulakazwa. Milogota milume mili, ing'holo ilume limwe na ming'holo myana saba milume ja mwaka umwe, jeng'ha jiwe jilihela nongwa. ");
INSERT INTO vid_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","Molavya nhambiko ya nyhule ya utimbo unojile kilo zidatu, uhanzigwe na mafuta kwa chila ilogota ilume na molavya kahi kilo mbili za utimbo unojile uhanzigwe na mafuta kwa chila ing'holo ilume, ");
INSERT INTO vid_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","na kilo imwe ya utimbo unojile uhanzigwe na mafuta kwa chila ing'holo lyana. Nhambiko azi za kulakazwa ziwele na unhunyhililo wa kumnojeza Mkulu Nguluwi, ndo nhambiko zilingulavigwa Mkulu Nguluwi kwa chiluli. ");
INSERT INTO vid_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","Chipimilo cha nhambiko ya chakunwa chilinguganigwa ndo lita mbili za divai kwa chila ilogota ilume na lita imwe na nusu kwa chila ing'holo ilume na lita imwe kwa chila ing'holo lyana. Ayo ndo nhambiko ya kulakazwa ya chila mwezi kuli mwaka. ");
INSERT INTO vid_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","Kahi momlavila Mkulu Nguluwi nhambiko ya gehile, ipongo limwe, ne kuwaza yila nhambiko ya kulakazwa ya chila zuwa na nhambiko yake ya chakunwa. ");
INSERT INTO vid_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","“Zuwa lya kumi na kane lya mwezi wa mwaluko ndo mnvina ya Pasaka ya Mkulu Nguluwi. ");
INSERT INTO vid_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","Zuwa lya kumi na zihano lya mwezi wuwo ndo mnvina. Kwa mhela wa mazuwa saba, molya mibumunda jilihela usaso. ");
INSERT INTO vid_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","Kuli zuwa lya mwaluko kowa na nhing'hano yelile. Zuwa alyo hamkola mijito hebu. ");
INSERT INTO vid_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","Molavya nhambiko ya kulakazwa kwa Mkulu Nguluwi kwa chiluli, milogota milume mili na ing'holo ilume limwe na ming'holo myana saba milume ja mwaka umwe, jeng'ha jiwe jilihela nongwa. ");
INSERT INTO vid_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","Nhambiko ya nyhule yoiwa hamwe na ayo, yowa ya utimbo unojile uhanzigwe na mafuta, kilo zidatu kwa chila ilogota ilume na kilo mbili kwa chila ing'holo ilume, ");
INSERT INTO vid_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","na kilo imwe kwa chila limwe lya jila ming'holo myana saba. ");
INSERT INTO vid_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","Molavya kahi ipongo limwe liwe nhambiko ya gehile leka kuwaditila uhanyisi. ");
INSERT INTO vid_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","Molavya vinhu avi ne kuwaza yila nhambiko ya kulakazwa ilingulavigwa mitondo ya chila zuwa. ");
INSERT INTO vid_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","Hihyo du, kwa mhela wa mazuwa saba, molavya nhambiko ya chilyo yalingulavilwa Mkulu Nguluwi kwa chiluli, ndo iwele na unhunyhililo unojile wa kumnojeza Mkulu Nguluwi. Ayi moilavya ne kuwaza yila nhambiko ya kulakazwa ya chila zuwa na nhambiko yake ya chakunwa. ");
INSERT INTO vid_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","Kuli zuwa lya saba modita nhing'hano yelile na mleche kukola mijito. ");
INSERT INTO vid_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","“Kuli zuwa lya mwaluko lya mnvina ya mbena lomumlavila Mkulu Nguluwi mbena za mwaluko za nyhule za hemwe, modita nhing'hano yelile na mleche kukola mijito. ");
INSERT INTO vid_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","Molavya nhambiko ya kulakazwa, unhunyhililo unojile wa kumnojeza Mkulu Nguluwi, milogota milume mili na ing'holo ilume limwe na ming'holo myana milume saba ja mwaka umwe. ");
INSERT INTO vid_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","Nhambiko ya nyhule yoiwa hamwe na ayo yowa ya utimbo unojile uhanzigwe na mafuta, kilo zidatu kwa chila ilogota ilume na kilo mbili kwa chila ing'holo ilume ");
INSERT INTO vid_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","na kilo imwe kwa chila ing'holo lyana. ");
INSERT INTO vid_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","Molavya kahi ipongo limwe kuwaditila uhanyisi. ");
INSERT INTO vid_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","Molavya vinhu avi ne kuwaza yila nhambiko ya kulakazwa ya chila zuwa hamwe na nhambiko yake ya chakunwa. Jeng'ha jiwe jilihela nongwa. ");
INSERT INTO vid_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","“Zuwa lya mwaluko lya mwezi wa saba modita nhing'hano yelile na mleche kukola mijito. Alyo ndo zuwa lya kutowa mhalamanda. ");
INSERT INTO vid_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","Molavya nhambiko ya kulakaza, kunhunyhilila goya komnojeza Mkulu Nguluwi, ilogota ilume limwe na ing'holo ilume limwe na ming'holo myana milume saba ja mwaka umwe, jeng'ha jiwe jilihela nongwa yoneche. ");
INSERT INTO vid_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","Molavya kahi nhambiko ya heye ya utimbo unojile uhanzigwe na mafuta, kilo zidatu kwa ilogota ilume na kilo mbili kwa ing'holo ilume ");
INSERT INTO vid_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","na kilo imwe kwa chila ing'holo lyana. ");
INSERT INTO vid_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","Kahi molavya ipongo limwe liwe nhambiko ya gehile kwa kuwaditila uhanyisi. ");
INSERT INTO vid_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","Molavya vinhu avi ne kuwaza yila nhambiko ya kulakazwa ya mwezi unyale na nhambiko yake ya nyhule na nhambiko zake za chakunwa kota vyoilajizwe kuwa unhunyhililo unojile ulingunojeza, ndo nhambiko yalingulavilwa Mkulu Nguluwi kwa chiluli. ");
INSERT INTO vid_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","“Zuwa lya kumi lya mwezi wa saba, modita nhing'hano yelile. Zuwa alyo yowagana mwesele kulya ne kukola mijito joneche. ");
INSERT INTO vid_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","Momlavila Mkulu Nguluwi nhambiko ya kulakazwa na kunhunyhilila kwa kumnojeza Mkulu Nguluwi. Ilogota ilume limwe na ing'holo ilume limwe na ming'holo myana saba milume ja mwaka umwe, jeng'ha jiwe jilihela nongwa yoneche. ");
INSERT INTO vid_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","9","Kuleka vinhu avyo, molavya kahi nhambiko ya utimbo unojile uhanzanywe na mafuta kilo zidatu hamwe na alyo ilogota ilume na kilo mbili hamwe na lila ing'holo ilume ");
INSERT INTO vid_vpl VALUES ("NU29_10","005_29_10","NUM","29","10","10","na kilo imwe kwa chila ing'holo lyana. ");
INSERT INTO vid_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","Molavya kahi ipongo limwe kwa nhambiko ya gehile ne kuwaza yila nhambiko ya uhanyisi hamwe na nhambiko ya kulakazwa ya chila zuwa na nhambiko yake ya nyhule na nhambiko zake za kunwa. ");
INSERT INTO vid_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","“Zuwa lya kumi na kahano lya mwezi wa saba, modita nhing'hano yelile. Hamkola mijito zuwa alyo. Modita mnvina kwa chiwalo cha Mkulu Nguluwi kwa mazuwa saba. ");
INSERT INTO vid_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","Molavya nhambiko ya kulakazwa, iwele ndo nhambiko yalingulavilwa Mkulu Nguluwi kwa chiluli, iwele na kunhunyhilila goya kulingumnojeza Mkulu Nguluwi na milogota milume kumi na jidatu na ming'holo milume mili na ming'holo myana ja mwaka umwe kumi na jine, jeng'ha jiwe jilihela nongwa yoneche. ");
INSERT INTO vid_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","Nhambiko yoiwa hamwe na ayo, yowa utimbo unojile uhanzigwe na mafuta, kilo zidatu kwa chila ilogota ilume na kilo mbili kwa chila ing'holo ilume ");
INSERT INTO vid_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","na kilo imwe kwa chila ing'holo lyana. ");
INSERT INTO vid_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","Molavya kahi ipongo limwe kwa nhambiko ya gehile, ne kuwaza yila nhambiko ya chila zuwa ya kulakazwa hamwe na nhambiko yake ya nyhule na nhambiko yake ya chakunwa. ");
INSERT INTO vid_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","17","“Zuwa lya keli, molavya milogota milume kumi na mili na ming'holo milume mili na ming'holo myana milume kumi na jine ja mwaka umwe jilihela nongwa yoneche. ");
INSERT INTO vid_vpl VALUES ("NU29_18","005_29_18","NUM","29","18","18","Molavya kahi nhambiko ya nyhule na nhambiko ya chakunwa hamwe na jila milogota milume na ming'holo na ming'holo milume myana kwa winji wa hewo vyoilajizwe. ");
INSERT INTO vid_vpl VALUES ("NU29_19","005_29_19","NUM","29","19","19","Molavya kahi ipongo limwe kwa nhambiko ya kulakazwa ya chila zuwa hamwe na nhambiko yake ya nyhule na nhambiko yake ya chakunwa. ");
INSERT INTO vid_vpl VALUES ("NU29_20","005_29_20","NUM","29","20","20","“Zuwa lya kadatu, molavya mibuguma kumi na limwe na ming'holo milume mili na ming'holo myana kumi na jine ja mwaka umwe jilihela nongwa yoneche. ");
INSERT INTO vid_vpl VALUES ("NU29_21","005_29_21","NUM","29","21","21","Molavya kahi nhambiko ya nyhule na nhambiko za chakunwa hamwe na ajo mibuguma na ming'holo milume na ming'holo myana kota vyoilajizwe. ");
INSERT INTO vid_vpl VALUES ("NU29_22","005_29_22","NUM","29","22","22","Hihyo du, molavya ipongo limwe kwa nhambiko ya gehile ne kuwaza yila nhambiko ya kulakazwa hamwe na nhambiko yake ya nyhule na nhambiko yake ya chakunwa. ");
INSERT INTO vid_vpl VALUES ("NU29_23","005_29_23","NUM","29","23","23","“Zuwa lya kane, molavya mibuguma kumi na ming'holo milume mili na ming'holo myana kumi na jine ja mwaka umwe jilihela nongwa yoneche. ");
INSERT INTO vid_vpl VALUES ("NU29_24","005_29_24","NUM","29","24","24","Molavya kahi nhambiko ya nyhule na nhambiko za chakunwa hamwe na ajo mibuguma na ming'holo milume na ming'holo myana kwa winji wa hewo kota vyoilajizwe. ");
INSERT INTO vid_vpl VALUES ("NU29_25","005_29_25","NUM","29","25","25","Molavya kahi ipongo limwe kwa nhambiko ya gehile ne kuwaza nhambiko ya chila zuwa ya kulakazwa hamwe na nhambiko yake ya nyhule na nhambiko yake ya chakunwa. ");
INSERT INTO vid_vpl VALUES ("NU29_26","005_29_26","NUM","29","26","26","“Zuwa lya kahano, molavya mibuguma tisa na ming'holo milume mili na ming'holo myana milume kumi na jine ja mwaka umwe jilihela nongwa yoneche. ");
INSERT INTO vid_vpl VALUES ("NU29_27","005_29_27","NUM","29","27","27","Molavya kahi nhambiko ya nyhule na nhambiko za chakunwa hamwe na mibuguma na ming'holo na ming'holo milume myana kota vyoilajizwe. ");
INSERT INTO vid_vpl VALUES ("NU29_28","005_29_28","NUM","29","28","28","Molavya kahi ipongo limwe kwa nhambiko ya gehile ne kuwaza yila nhambiko ya chila zuwa ya kulakazwa hamwe na nhambiko yake ya nyhule na nhambiko yake ya chakunwa. ");
INSERT INTO vid_vpl VALUES ("NU29_29","005_29_29","NUM","29","29","29","“Zuwa lya sita, molavya mibuguma nane na ming'holo milume mili na ming'holo myana milume kumi na jine ja mwaka umwe jiwele jilihela nongwa yoneche. ");
INSERT INTO vid_vpl VALUES ("NU29_30","005_29_30","NUM","29","30","30","Molavya kahi nhambiko ya nyhule na nhambiko za chakunwa hamwe na ajo mibuguma na ming'holo milume na ming'holo myana kota vyoilajizwe. ");
INSERT INTO vid_vpl VALUES ("NU29_31","005_29_31","NUM","29","31","31","Molavya kahi ipongo limwe lya nhambiko ya gehile hamwe na nhambiko ya kulakazwa na nhambiko yake ya nyhule na nhambiko zake za chakunwa. ");
INSERT INTO vid_vpl VALUES ("NU29_32","005_29_32","NUM","29","32","32","“Zuwa lya saba, molavya mibuguma saba na ming'holo milume mili na ming'holo myana milume kumi na jine ja mwaka umwe, jilihela nongwa yoneche. ");
INSERT INTO vid_vpl VALUES ("NU29_33","005_29_33","NUM","29","33","33","Molavya kahi nhambiko ya nyhule na nhambiko za chakunwa hamwe na ajo mibuguma na ming'holo milume na ming'holo myana kwa winji wa hewo kota vyoilajizwe. ");
INSERT INTO vid_vpl VALUES ("NU29_34","005_29_34","NUM","29","34","34","Molavya kahi ipongo limwe kwa nhambiko ya gehile ne kuwaza yila nhambiko ya kulakazwa ya chila zuwa, hamwe na nhambiko yake ya nyhule na nhambiko yake ya chakunwa. ");
INSERT INTO vid_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","“Zuwa lya nane, mowa na nhing'hano ng'hulu. Mleche kukola mijito zuwa alyo. ");
INSERT INTO vid_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","Ila molavya nhambiko ya kulakazwa, nhambiko yalingulavilwa Mkulu Nguluwi kwa chiluli, na unhunyhililo unojile ulingumnojeza Mkulu Nguluwi, ibuguma limwe na ing'holo ilume limwe na ming'holo myana milume saba ja mwaka umwe jilihela nongwa yoneche. ");
INSERT INTO vid_vpl VALUES ("NU29_37","005_29_37","NUM","29","37","37","Molavya kahi nhambiko ya nyhule na nhambiko za chakunwa hamwe na alyo ibuguma na ing'holo ilume na jila ming'holo myana kwa winji wa migongolo kota vyoilajizwe. ");
INSERT INTO vid_vpl VALUES ("NU29_38","005_29_38","NUM","29","38","38","Hamba kahi molavya ipongo limwe kwa nhambiko ya gehile ne kuwaza yila nhambiko ya chila zuwa ya kulakazwa hamwe na nhambiko yake ya nyhule na nhambiko yake ya chakunwa. ");
INSERT INTO vid_vpl VALUES ("NU29_39","005_29_39","NUM","29","39","39","“Aga ndo malajizo galinguwala nhambiko za kulakazwa na nhambiko za nyhule na nhambiko za chakunwa na nhambiko za kikala goya zomlingumlavila Mkulu Nguluwi mhela wa mnvina za hemwe zoziwichigwe. Ne kuwaza nhambiko azo ziwele momlavila Mkulu Nguluwi kweneza kilaha kwa hemwe na nhambiko za hemwe za kunuwila.” ");
INSERT INTO vid_vpl VALUES ("NU29_40","005_29_40","NUM","29","40","40","Lelo Musa nakawalonjela Waisilaeli chila chinhu kota Mkulu Nguluwi navyoyamlajize. ");
INSERT INTO vid_vpl VALUES ("NU30_1","005_30_1","NUM","30","1","1","Hamba, Musa nakalongasa na vilongozi wa nhanzi za Isilaeli, nakawalonjela, “Awu ndo ulonzi woyalonjile Mkulu Nguluwi. ");
INSERT INTO vid_vpl VALUES ("NU30_2","005_30_2","NUM","30","2","2","“Wone munhu yochilaha kwa Mkulu Nguluwi ama kiwika milagano kwa chilaho, imgana yeneze kilagana kwa heye, na imgana kahi yagakolele mijito gala geng'ha goyalonjile heye. ");
INSERT INTO vid_vpl VALUES ("NU30_3","005_30_3","NUM","30","3","3","“Mhinza yawele yang'hali mbaka sambi kangikala haluga ha mhaza wa heye, yochilaha kwa Mkulu Nguluwi ama kiwika milagano, ");
INSERT INTO vid_vpl VALUES ("NU30_4","005_30_4","NUM","30","4","4","na wone mhaza wa heye nakahulika kiwika milagano, wone yoleka kumlemeza, lelo vilaho vya heye vyoyawichile vyopona bahala na kulagana kwa heye kahi kopona bahala. ");
INSERT INTO vid_vpl VALUES ("NU30_5","005_30_5","NUM","30","5","5","Ila wone mhaza wa heye yohulika kilaha ako, na yomlemeza, lelo kilaha kwa heye na kulagana kwa heye hambe vipone bahala. Mkulu Nguluwi komlechela kwa vila mhaza wa heye nakalemeza mbuli ayo. ");
INSERT INTO vid_vpl VALUES ("NU30_6","005_30_6","NUM","30","6","6","“Wone mhinza ayo kohesigwa hala du nahoyalahile na kulagana ne kijesa goya tandi na kiwika heye yuye milagano, ");
INSERT INTO vid_vpl VALUES ("NU30_7","005_30_7","NUM","30","7","7","hamba mlume wa heye yahuliche chilaho acho na wone yaleche kumlemeza, lelo kilaha kwa heye kopona bahala na kulagana kwa heye kahi kopona bahala. ");
INSERT INTO vid_vpl VALUES ("NU30_8","005_30_8","NUM","30","8","8","Ila wone mlume wa heye yahuliche chilaho acho na wone yamlemeze, lelo ayo mlume wa heye kokusa chilaho cha mchewake na ulonzi wa heye woyaulavile ne kujesa goya, na Mkulu Nguluwi komlechela. ");
INSERT INTO vid_vpl VALUES ("NU30_9","005_30_9","NUM","30","9","9","“Ila kilaha ama kulagana koneche koyawichile mdala yafililwe na mlume wa heye ama mdala yapegwe luleko, ahyo chilaho ama kulagana kwa ayo mdala vyopona bahala. ");
INSERT INTO vid_vpl VALUES ("NU30_10","005_30_10","NUM","30","10","10","“Wone mdala yahesigwe yochilaha ama kulagana kwa kilaha kuno yawele haluga ha mlume wa heye, ");
INSERT INTO vid_vpl VALUES ("NU30_11","005_30_11","NUM","30","11","11","hamba wone mlume wa heye yahuliche mbuli ayo ila wone yaleche kumlemeza ne kumlonjela chinhu, lelo chilaho cha heye cheng'ha chopona bahala na kulagana kwa heye kweng'ha kahi kopona bahala. ");
INSERT INTO vid_vpl VALUES ("NU30_12","005_30_12","NUM","30","12","12","Ila wone mlume yahuliche mbuli za heye, hamba yazileme, lelo hambe yaganigwe kugongomanyiza kilaha ama kulagana kwa heye, haimganile kweneza, mlume wa heye nakazilemeza na Mkulu Nguluwi komlechela mdala ayo. ");
INSERT INTO vid_vpl VALUES ("NU30_13","005_30_13","NUM","30","13","13","Mlume wa heye koweza kutawiza ama kulemeza kilaha ama kulagana koneche kula. ");
INSERT INTO vid_vpl VALUES ("NU30_14","005_30_14","NUM","30","14","14","Ila wone mlume wa heye hambe yalonje chinhu choneche chila kulawa zuwa lyoyohulika mbuli za kilaha ama kulagana kwa mdala wa heye, lelo mlume ayo kowa nakatawiza chilaho na kulagana ako. ");
INSERT INTO vid_vpl VALUES ("NU30_15","005_30_15","NUM","30","15","15","Ila wone yolemeza mhela umwenga loyahuliche mbuli za heye, lelo heye mlume kowa na nongwa kwa chiwalo cha mchewake.” ");
INSERT INTO vid_vpl VALUES ("NU30_16","005_30_16","NUM","30","16","16","Aga ndo malajizo gawele Mkulu Nguluwi nayamlajize Musa kwa chiwalo cha mdala na mlume wa heye na mhaza na mhinza wa heye, wone mhinza ayo yawe yang'hali kwalama na kangikala kwa mhaza wa heye. ");
INSERT INTO vid_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","Mkulu Nguluwi nakalongasa na Musa, nakamlonjela, ");
INSERT INTO vid_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","“Wahilulile chibida Wamidiani kwa mbuli zowawaditile Waisilaeli, hamba hegwe kobagama.” ");
INSERT INTO vid_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","Lelo Musa nakalongasa na wamizi, nakawalonjela, “Muwawiche goya wanhu walume walute kuza kitowa ngondo na Wamidiani kuwahilulila chibida kwa chiwalo cha Mkulu Nguluwi. ");
INSERT INTO vid_vpl VALUES ("NU31_4","005_31_4","NUM","31","4","4","Kulawila chila nhanzi ya Isilaeli, mohilika wamizi elufu imwe kuli kitowa ngondo.” ");
INSERT INTO vid_vpl VALUES ("NU31_5","005_31_5","NUM","31","5","5","Lelo wamizi elufu imwe nawalavigwa kulawila chila nhanzi hali wanhu wa maelufu ya Waisilaeli, walume wawichigwe goya kitowa ngondo nawali elufu kumi na mbili (12,000). ");
INSERT INTO vid_vpl VALUES ("NU31_6","005_31_6","NUM","31","6","6","Musa nakawahilika kuli kitowa ngondo hali ulongozi wa Finehasi mwana wa mtambika Eleasali, yawele na vinhu vya honhu helile na mhalamhanda za kulajila ulajilo. ");
INSERT INTO vid_vpl VALUES ("NU31_7","005_31_7","NUM","31","7","7","Nawaitowa isi ya Midiani, kota Mkulu Nguluwi vyoyamlajize Musa, nawawakopola walume weng'ha. ");
INSERT INTO vid_vpl VALUES ("NU31_8","005_31_8","NUM","31","8","8","Hali wanhu awo wakopoligwe, nakwali na wandewa wahano wa Midiani, Evi na Lekemu na Suli na Huli na Leba. Vivila nawamkopola Balaamu mwana wa Beoli. ");
INSERT INTO vid_vpl VALUES ("NU31_9","005_31_9","NUM","31","9","9","Waisilaeli nawawahola wadala wa Midiani na wana wa hewo na misenga na ming'holo na lufufu lwa hewo lweng'ha. ");
INSERT INTO vid_vpl VALUES ("NU31_10","005_31_10","NUM","31","10","10","Miji ja hewo jeng'ha na howalingikala hewo heng'ha nawahalakaza heng'ha kwa chiluli. ");
INSERT INTO vid_vpl VALUES ("NU31_11","005_31_11","NUM","31","11","11","Nawahola vinhu vyeng'ha hamwe na wanhu na migongolo, ");
INSERT INTO vid_vpl VALUES ("NU31_12","005_31_12","NUM","31","12","12","hewo nawawegala wanhu na migongolo na vinhu vyeng'ha na kuviwika hali Musa na mtambika Eleasali na hali Waisilaeli weng'ha aho hawele na kambi kuli isi iwele na ibalalika lya Moabu, hawele habehi na lwanda lwa Yolodani ilingilola na Yeliko. ");
INSERT INTO vid_vpl VALUES ("NU31_13","005_31_13","NUM","31","13","13","Musa na mtambika Eleasali na vilongozi weng'ha wa Waisilaeli weng'ha nawalawa kuli kambi, nawaluta kuwabochela wamizi. ");
INSERT INTO vid_vpl VALUES ("NU31_14","005_31_14","NUM","31","14","14","Musa nakazudizwa na wakulu wa wamizi na wamizi wemilile vilundo vya wamizi maelufu menji na vilundo vya wamizi mamiya ga wowahiluche kulawa kitowa ngondo. ");
INSERT INTO vid_vpl VALUES ("NU31_15","005_31_15","NUM","31","15","15","Musa nakawauza, “Lekachoni namuwaleka wadala awa weng'ha wawele wakomu? ");
INSERT INTO vid_vpl VALUES ("NU31_16","005_31_16","NUM","31","16","16","Mkumbuchile kota wadala ndo wawinzile ulonzi wa Balaamu, nawawambuza Waisilaeli wamleme Mkulu Nguluwi kula Peoli mbaka matamwa gehile nagawoyela Waisilaeli weng'ha wa heye Mkulu Nguluwi. ");
INSERT INTO vid_vpl VALUES ("NU31_17","005_31_17","NUM","31","17","17","Ahyo lelo, muwakopole wana weng'ha walume na chila mdala yawele nakawasa na mlume. ");
INSERT INTO vid_vpl VALUES ("NU31_18","005_31_18","NUM","31","18","18","Ila mleche kuwakopola wahinza weng'ha wawele hawanawasa na mlume, muwaleche wawele wakomu kwa chiwalo cha hemwe mwemwe. ");
INSERT INTO vid_vpl VALUES ("NU31_19","005_31_19","NUM","31","19","19","Wala weng'ha wawele hali hemwe wawele nawakopole munhu ama kudoliza mtufi yanguwalapa wekale kunze mwa kambi kwa mhela wa mazuwa saba, weyelize hamwe na Wamidiani wa hemwe kuli zuwa lya kadatu na zuwa lya saba. ");
INSERT INTO vid_vpl VALUES ("NU31_20","005_31_20","NUM","31","20","20","Iwagana kahi welize chila ivalo na chila chinhu chigongomanyigwe kwa igozi na kwa milaika ja mhene ama kwa igodi.” ");
INSERT INTO vid_vpl VALUES ("NU31_21","005_31_21","NUM","31","21","21","Mtambika Eleasali nakawalonjela walume wahiluche kulawila kuli kitowa ngondo, “Ali ndo ilajizo liwele Mkulu Nguluwi nalyoyampele Musa. ");
INSERT INTO vid_vpl VALUES ("NU31_22","005_31_22","NUM","31","22","22","Zahabu na sendi na shaba na chuma na bati na madini galinguchemigwa lisasi, ");
INSERT INTO vid_vpl VALUES ("NU31_23","005_31_23","NUM","31","23","23","ndo vinhu vyeng'ha viwele vilingwimilila chiluli, vyokwelizwa kwa kuvikoleza kuli chiluli. Ahyo, yanguganigwa kahi vyelizwe na mazi ga kweliza. Vinhu viyage vyeng'ha vila vyohambe vimilile chiluli vyokwelizwa kwa mazi ga kweliza. ");
INSERT INTO vid_vpl VALUES ("NU31_24","005_31_24","NUM","31","24","24","Zuwa lya saba yangukulapa mhovuje mivalo ja hemwe, ndo vyomuwa mwelile na kukundigwa kwinjila kuli kambi.” ");
INSERT INTO vid_vpl VALUES ("NU31_25","005_31_25","NUM","31","25","25","Mkulu Nguluwi nakalongasa na Musa, nakamlonjela, ");
INSERT INTO vid_vpl VALUES ("NU31_26","005_31_26","NUM","31","26","26","“Hegwe na mtambika Eleasali, hamwe na vilongozi wa ng'holo za nhanzi ya Waisilaeli, muwaze vinhu navyomholile kuli ngondo na Waisilaeli weng'ha na migongolo. ");
INSERT INTO vid_vpl VALUES ("NU31_27","005_31_27","NUM","31","27","27","Mgawe vinhu avyo kuli vilundo vili, chilundo cha mwaluko ndo cha wamizi walutile kuli kitowa ngondo na chilundo chiyage kwa chiwalo cha Waisilaeli weng'ha. ");
INSERT INTO vid_vpl VALUES ("NU31_28","005_31_28","NUM","31","28","28","Ila kwa chila chilundo cha wamizi walutile kuli kitowa ngondo, ubagule ndolendole kwa chiwalo cha Mkulu Nguluwi. Chinhu chimwe kulawila kuli vinhu miya zihano, wawe wanhu ama isenga ama idogowi ama ing'holo ama mhene, ");
INSERT INTO vid_vpl VALUES ("NU31_29","005_31_29","NUM","31","29","29","umhe mtambika Eleasali iwe ndolendole kwa Mkulu Nguluwi. ");
INSERT INTO vid_vpl VALUES ("NU31_30","005_31_30","NUM","31","30","30","Kulawila kuli chilundo cha nhanzi yeng'ha ya wanhu wa Isilaeli, uhole honhu hamwe ha chila makumi gahano, wawe wanhu ama misenga ama midogowi ama ming'holo ama mhene. Ahyo mowapa Walawi wawele walinguganigwa kukola mijito kuli ihema lya Mkulu Nguluwi.” ");
INSERT INTO vid_vpl VALUES ("NU31_31","005_31_31","NUM","31","31","31","Musa na mtambika Eleasali nawadita kota Mkulu Nguluwi vyoyamlajize Musa. ");
INSERT INTO vid_vpl VALUES ("NU31_32","005_31_32","NUM","31","32","32","Vinhu navyowaholile kuli ngondo, navyali, ming'holo lachi sita na elufu makumi saba na zihano (675,000) ");
INSERT INTO vid_vpl VALUES ("NU31_33","005_31_33","NUM","31","33","33","na misenga elufu makumi saba na mbili (72,000) ");
INSERT INTO vid_vpl VALUES ("NU31_34","005_31_34","NUM","31","34","34","na midogowi elufu makumi sita na imwe (61,000) ");
INSERT INTO vid_vpl VALUES ("NU31_35","005_31_35","NUM","31","35","35","na wadala wawele hawanating'hana na mlume elufu makumi gadatu na mbili (32,000). ");
INSERT INTO vid_vpl VALUES ("NU31_36","005_31_36","NUM","31","36","36","Nusu yake, honhu hawele habaguligwe na wamizi walutile kuli ngondo, nayali ming'holo lachi zidatu na elufu makumi gadatu na saba na miya zihano (337,500), ");
INSERT INTO vid_vpl VALUES ("NU31_37","005_31_37","NUM","31","37","37","kuli awo miya sita na makumi saba na wahano (675) walavigwe kwa Mkulu Nguluwi. ");
INSERT INTO vid_vpl VALUES ("NU31_38","005_31_38","NUM","31","38","38","Misenga ja wamizi wa ngondo najali elufu makumi gadatu na sita (36,000), na kuli ajo makumi saba na mili (72) najilavigwa ndolendole kwa Mkulu Nguluwi. ");
INSERT INTO vid_vpl VALUES ("NU31_39","005_31_39","NUM","31","39","39","Midogowi ajo najali elufu makumi gadatu na miya zihano (30,500) na kuli ajo makumi sita na imwe (61) najilavigwa ndolendole kwa Mkulu Nguluwi. ");
INSERT INTO vid_vpl VALUES ("NU31_40","005_31_40","NUM","31","40","40","Wanhu nawali elufu kumi na sita (16,000), na hali awo honhu ha Mkulu Nguluwi nahali wanhu makumi gadatu na mbili (32). ");
INSERT INTO vid_vpl VALUES ("NU31_41","005_31_41","NUM","31","41","41","Lelo Musa nakamha mtambika Eleasali ndolendole ayo ilavigwe kwa Mkulu Nguluwi, kota Mkulu Nguluwi vyoyamlajize Musa. ");
INSERT INTO vid_vpl VALUES ("NU31_42","005_31_42","NUM","31","42","42","Nusu ya keli yowapegwe Waisilaeli, iwele Musa nayaibagule kulawa yila nusu yowapegwe wamizi walutile kuli kitowa ngondo, ");
INSERT INTO vid_vpl VALUES ("NU31_43","005_31_43","NUM","31","43","43","najali ming'holo lachi zidatu na elufu makumi gadatu na saba na miya zihano (