﻿USE sofia;
DROP TABLE IF EXISTS sofia.vgr_vpl;
CREATE TABLE vgr_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES vgr_vpl WRITE;
INSERT INTO vgr_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","అబ్రాహామ్ను గోత్ను బుజు దావీద్నొ ఛియ్యోహుయోతె యేసు క్రీస్తు గోత్ను వరసా. ");
INSERT INTO vgr_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","అబ్రాహామ్ను ఇస్సాకునా ఫైదాకర్యొ, ఇస్సాకు యాకోబ్నా ఫైదాకర్యొ, యాకోబ్‍ యూదనా బుజు ఇను భైయ్యేనా ఫైదాకర్యొ; ");
INSERT INTO vgr_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","యూదాను బావన్‍ తామారుకనా పెరెసునాబి, జెరహునా ఫైదాకర్యొ; పెరెసు ఛియ్యో ఎస్రోమునా ఫైదాకర్యొ, ");
INSERT INTO vgr_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","ఆరామ్‍నె అమ్మీనాదాబ్నా ఫైదాకర్యొ, అమ్మినాదాబ్నె నయస్సోనా ఫైదాకర్యొ ");
INSERT INTO vgr_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","నయస్సోనె సల్మాను ఫైదాకర్యొ, సల్మానె రాహాబుకనా బోయాజునా ఫైదాకర్యొ బోయాజు రూతుకనా ఓబేద్నా ఫైదాకర్యొ, ఓబేద్నూ ఆయా రూతు ఓబేద్నె యెష్షయినా ఫైదాకర్యొ; ");
INSERT INTO vgr_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","యెష్షయి రాజొహుయోతె దావీద్నా ఫైదాకర్యొ. ఉరియా బావణ్నితరా ర్హాయ్‍తెదె ఇనకనా దావీద్నె సొలొమోన్నా ఫైదాకర్యొ. ");
INSERT INTO vgr_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","సొలొమోన్నె రెహబామునా ఫైదాకర్యొ; రెహబానె అబీయానా ఫైదాకర్యొ, అబీయానె ఆసానా ఫైదాకర్యొ; ");
INSERT INTO vgr_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","ఆసానె యెహోషాపాత్న ఫైదాకర్యొ, యెహోషపాతు యెహోరామనా ఫైదాకర్యొ, యెహోరామనె ఉజ్జియానా ఫైదాకర్యొ; ");
INSERT INTO vgr_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","ఉజ్జియానె యోతామ్ నా ఫైదాకర్యొ, యోతామ్నె ఆహాజ్నా ఫైదాకర్యొ, ఆహాజ్నె హిజియానా ఫైదాకర్యొ; ");
INSERT INTO vgr_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","హిజ్కియానె మనష్షేనా ఫైదాకర్యొ, మనష్షేనె ఆమోస్నా ఫైదాకర్యొ, ఆమోన్నా యోషియ్నా ఫైదాకర్యొ; ");
INSERT INTO vgr_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","ఇష్రాయేల్నా బబులోన్‍ దేఖ్మా లీన్జావనా ధన్మా యోషియానె యెకొన్యానా ఇవ్నా భైయ్యావ్నా ఫైదాకర్యొ. ");
INSERT INTO vgr_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","బబులోన్మా జావనపాసల్ యెకొన్యానె షయల్తీయేలునా ఫైదాకర్యొ, షయల్తీయేలు జెరుబ్బాబెలునా ఫైదాకర్యొ. ");
INSERT INTO vgr_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","జెరుబ్బాబేలునె అబీహూదునా ఫైదాకర్యొ అబీహూదునె ఎల్యాకీమునా ఫైదాకర్యొ, ఎల్యాకీమ్నె అజోరునా ఫైదాకర్యొ ");
INSERT INTO vgr_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","అజోరునె సాదోకునా ఫైదాకర్యొ, సాదోక్నె ఆకీమ్నా ఫైదాకర్యొ, ఆకీమ్నె ఎలీహూదునా ఫైదాకర్యొ, ");
INSERT INTO vgr_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","ఎలీహూద్నె ఎలియాజరునా ఫైదాకర్యొ, ఎలియాజరునె మత్తాతునా ఫైదాకర్యొ, మత్తాతునే యాకోబునా ఫైదాకర్యొ, ");
INSERT INTO vgr_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","యాకోబ్నె యోసేప్నా ఫైదాకర్యొ, యోసేప్ను బావన్ మరియ. మరియా క్రీస్తుకరి బోలతె యేసు ఫైదాహుయు. ");
INSERT INTO vgr_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","అమ్ అబ్రాహామ్‍తూ నిఖిన్, దావీద్‍తోడి అక్కు చౌధ పిఢి, దావీద్తూ నిఖీన్ యూదుల్ బబులోన్‍మా జావన ధన్తోడి హాఃరు చౌధ పిఢి. బబులోన్‍ జావనుధన్తూ నిఖీన్ క్రీస్తుతోడి చౌధ పిఢి. ");
INSERT INTO vgr_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","యేసుక్రీస్తు ఫైదాహుయోతె కింకతొ, యేసుక్రీస్తును ఆయ మరియతీబి యోసేపునా హఃగాయ్ హుయు. య్హా హుయుకొయింతె అగాఢి ఇని బావన్ పవిత్రాత్మతి బేజినిహుయిన్‍ థి. ");
INSERT INTO vgr_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","ఇను భావ్రిహుయోతె యోసేప్నె హాఃచెళొ అద్మిహుయీన్బి యోబాయికోన చార్మా ఇను నామ్ బద్నామ్ నాకర్నుకరి, కినాబి మాలంకొయినితింమ్ బావన్నా బెంధేనుకరి సోఛిలిదొ. ");
INSERT INTO vgr_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","ఇనె ఆ వాతెహాఃరు సోఛ్తొ రవ్వమా, హదేక్ దేవ్ను దూత హోఃనెమా ఇనకనా ఆయిన్ దావీద్నొ ఛియ్యోహుయోతె యోసేప్, తారి బావన్‍హుయీతె మరియానా బావన్‍తరా ఖందెకరనా నొకొఢర్. యో బేజిణిహుయితె పవిత్రాత్మతీస్‍ హుయి. ");
INSERT INTO vgr_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","యో ఏక్ ఛియ్యోనా ఫైదాకర్సె; ఇను అద్మియేనా ఇవ్ను పాప్‍మతూ యోస్ బచ్ఛావ్సె, అనహాఃజె ఇనా యేసుకరి నామ్ బేంద్చెకరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","ప్రభు ఇను ప్రవక్తనా బారెమా బోల్యెతె వాతె హాఃఛి హువాతిమ్‍ ఆ హాఃరు హుయు. ఇమ్మానుయేల్ కతొ మూలభాషమా దేవ్ అప్నకేడె ఛాకరి అర్థం, ");
INSERT INTO vgr_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","హదేక్ కవ్వారిచొగ్రి బేజిని ర్హహీన్ ఏక్‌ ఛియ్యోనా ఫైదాకర్సె, ఇనునామ్ ఇమ్మానుయేల్‍ కరి, నామ్ బేంద్చు ");
INSERT INTO vgr_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","యోసేపునె లిందర్‍మతూ హొషార్‍హుయిన్ దేవ్ను దూత ఇన ఆజ్ఞదిదోతిమ్ కరీన్, ఇను బావన్నా కందె కర్లిదొ ");
INSERT INTO vgr_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","ఇను బావన్ ఛియ్యోనా ఫైదాకరతోడి ఇనకనా గయోకొయిని; ఇను ఛియ్యాన యేసుకరి నామ్ బేంద్యు. ");
INSERT INTO vgr_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","హేరోద్‍ రాజొథోతె ధన్మా యూదయాదేహ్‍ఃమనూ బేత్లెహేమ్‍ గాంమ్మా యేసు ఫైదాహువదీన్, హదేక్ ధన్‍నిక్లతె దేహ్ఃమను జ్ఞానుల్ యెరూషలేమ్మా ఆయిన్, ");
INSERT INTO vgr_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","యూదుల్నా రాజొ ఫైదాహుయోతె కెజ్గ ఛా? ధన్‍నికతెబాజు హమె ఇను సుక్కర్నా దేఖిన్ ఇన హమె హఃలామ్‍ కరనాటేకె ఆయాకరి బోల్యు. ");
INSERT INTO vgr_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","హేరోద్‍ రాజొ ఆ వాతె హఃమ్జొతెదె యోబి ఇనకేడె యెరూషలేమ్ను హాఃరుబి గబ్రాయ్‍గయూ. ");
INSERT INTO vgr_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","ఇనటేకె రాజొ ప్రధాన యాజకుడ్నా అద్మిమతూ షాస్ర్తుల్నా హాఃరనా యేక్‍ జొగొలాయిన్‍, క్రీస్తు కెజ్గ ఫైదాహుసేకరి ఇవ్నా పుఛ్చాయో. ");
INSERT INTO vgr_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","ఇనటేకె ఇవ్నె యూదయ దేహ్ఃమా బేత్లెహేంమ్మస్; కిమ్కతొ యూదయా దేహ్ః బేత్లహేమ్‍ తూ యూదా ప్రధానుల్మా కెత్రూబి కంజోర్‍వాలొ కాహె. ");
INSERT INTO vgr_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","ఇస్రాయేల్నా మారు అద్మియేన ఛలావాలొ మోటొ బేత్లెహేమ్ మతూ ఆవ్సెకరి ప్రవక్తనాహాతె లిఖ్కైరూస్‍కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","తెదె హేరోద్ యోజ్ఞానుల్నా ఆహ్రేతి బులాయిన్, యోసుక్కర్ దెఖ్కాయుతె ధన్మా ఇవ్నహాతె పరిష్కారమ్‍ మాలంకర్లీన్ ");
INSERT INTO vgr_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","తుమె జైయిన్, యోలడ్కన బన్తూ జత్తన్తి పుఛ్చాయిన్, మాలంహుంస్కరా, మేబి ఆయిన్, ఇనా హఃలామ్ కరనటేకె మన సమాచార్‍ లావోకరి బోలిన్ ఇవ్నా బేత్లెహేంమ్మా మొక్లొ. ");
INSERT INTO vgr_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","ఇవ్నె రాజొను వాత్ హఃమ్జీన్ నికీన్ జంకరమా, హదేక్ తూర్పును బాజుతి ఇవ్నె దేఖ్యతె సుక్కర్ యోలఢ్కుఛాతె జొగొమా ఉప్పర్ ఆయిన్ ఉబ్రతోడి, ఇవ్నా అగాఢి చాలీన్ గయూ. ");
INSERT INTO vgr_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","ఇవ్నె యోసుక్కర్ దేఖిన్, కెత్రూకి ఖుషితి. ");
INSERT INTO vgr_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","ఘేర్మా ఆయిన్‍ ఆయాహుయితె మరియనాబి యోలఢ్కనా దేఖిన్, డుక్నిఫర్‍ బేసిన్‍ ఇన హఃలామ్ కరీన్‍, ఇవ్ను పెట్టియే కాఢీన్ మోల్నుహుయూతె ఘేణు, ఊద్నికాడి, బోళంనా కాణుకల్నితరా ఇనాదిదూ. ");
INSERT INTO vgr_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","పాసల్తి హేరోద్‍కనా నొకొజవొకరి హొఃనెమా దేవ్ను దూత ఆయిన్ బోలమా ఇవ్నె బుజేక్ వాటేతి ఫరీన్ ఇవ్ను దేహ్ఃమా గయూ. ");
INSERT INTO vgr_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","ఇవ్నె చల్జావన పాసల్తి హదేక్‍ హేరోదురాజొ యోలఢ్కనా మర్రాఖినాక్నుకరి ధూండనా వళోజాస్‍ అనటేకె తూ ఉట్టీన్‍ యోలఢ్కనా ఇను ఆయానకేడె లీజైయిన్‍ ప్రభూవును దూత్ హొఃనెమా ఆయిన్ బోల్యొ. ఐగుప్తుమా మిలాలిజైన్‍ “మే తారేతి మాలంకరావతోడి ఎజ్గాస్‍ ర్హాకరి” ఇనేతి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","తెదె యో వుట్టిన్, రాత్నువహఃత్‍మా ఆయనా లఢ్కనా బులాలీన్ ఐగుప్తుమా జైయిన్, ");
INSERT INTO vgr_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","“మారొ ఛియ్యోనా ఐగుప్తుమాతొ బులాయోకరి” ప్రవాక్తనా బారెమా ప్రభువు బోల్యొతె వాత్‍ పూర్తిహువ హఃర్కు హేరోద్ను మరణ్‍తోడి ఐగుప్తుమా ఎజ్గస్‍ ర్హయ్యా. ");
INSERT INTO vgr_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","యోజ్ఞానుల్‍ ఇన మోసం కర్యూకరి హేరోద్ మాలంకరీన్ ఘణు చంఢాల్తి, ఇనె జ్ఞానుల్‍బారెమా వివరంతి మాలంకర్యొతె ధన్నాబట్టీన్‍ బేత్లెహేమ్‍ మతూ ధరీన్‍ హరేక్‍ ఇలాహోఃమాబి, భే వరహ్ః మొదుల్తూ ధరీన్ అడ్డాణి లఢ్కాలగూ మరధ్ లఢ్కా హాఃరనా మారినాక్యు. ");
INSERT INTO vgr_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","యిర్మియా ప్రవక్తబోలెతె వాతె హాఃచిహుయు. ");
INSERT INTO vgr_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","ఇనటేకె రామమా హఃయర్మా రొవ్వానూ హఃమ్జాయు రొవ్వాను యో ఘణు రోధనాహుయు. లఢ్కనాటేకె రాహేల్ రొవ్తూ, ఇవ్నె నార్హావమా ఖందెకరవాలు, ఓదార్చువాల కోన్బి కోథూని కరి. ");
INSERT INTO vgr_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","హేరోదు మర్జావదీన్ పాసల్తి ప్రభును దూత ఐగుప్తుమా యోసేపును హొఃనెమా దెఖ్కాయిన్‍, ");
INSERT INTO vgr_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","హదేక్‍ తూ ఉట్టీన్ లఢ్కనా ఇని ఆయనా బులాలీన్ ఇస్రాయేల్ దేహ్ఃమా జవోకరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","షానకతొ యోచొగ్రనా మార్రాక్నుకరి దేఖుకరతె ఇవ్నె మరిగయాకరి బోల్యొ. తెదె యోఛియ్యోనా ఇని ఆయానా బులాలీన్ ఇస్రాయేల్నా దేహ్‍ఃమా ఆయో. ");
INSERT INTO vgr_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","హుయితొ అర్కెలాయు ఇను భాహుయోతె హేరోద్నాబదుల్ యూదా దేహ్ఃనా ఏలుకరస్‍కరి మాలంకరీన్ ఎజ్గ జానుకరి సోచిన్‍ దేవ్నివాతె హొఃనెమా ఆయిన్, తూ గలిలయమాను ఇలాహోఃమా జైయిన్ నజరేతుకరి గాంమ్మా ఆయిన్‍ ఎజ్గ జియ్యో. ");
INSERT INTO vgr_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","“యో నజరేయుడ్‍వాలొకరి బొలావ్సేకరి” ప్రవక్తల్‍ బోల్యొతె వాతె నేరవెర్నుతిమ్‍ అమ్‍ హుయు. ");
INSERT INTO vgr_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","యోధన్మా బాప్తిస్మమ్‌ దెవ్వాళొ యోహాన్ ఆయిన్, ");
INSERT INTO vgr_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","స్వర్గంను రాజ్యం ఖందేస్ ఆయురూస్. దిల్ బద్లాయ్‍లెవోకరి, యూదయాను జాఢిమా ప్రచార్‍ కరూకరమా, ");
INSERT INTO vgr_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","ప్రవక్తాహుయూతె యెషయ బారెమా బోల్యొతె యోహాన్‍ ఆస్‍ ప్రభువును వాట్న హఃడక్ కరోకరి, ఇని మారగ్‍నా హూఃదు కరోకరి; జాఢిమా చిక్రుకరతె యేక్ను ఆవాజ్. ");
INSERT INTO vgr_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","ఆ యోహాన్ ఊట్ను చాంబ్డనా లుంగ్డానితరా పేర్తొ థొ. బుజు కంబర్నా చాంబ్డను పట్టితి బాంద్తొ థొ చిడ్డావ్నా, జాఢిను షేత్ ఇను ఖావను. ");
INSERT INTO vgr_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","త్యొ వహఃత్‍మా యెరూషలేమ్‌ను హాఃరు యూదయాను హాఃరుబి, యొర్దాన్ నదికనూ హాఃమెను ఇలాహోఃను హాఃరుబి ఇనకనా ఆయిన్ ");
INSERT INTO vgr_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","ఇవ్ను పాప్‍నా నమ్తూహుయీన్‍ యొర్దాన్‍ నదిమా ఇనహాతె బాప్తిస్మమ్‍ లెంకర్తు థూ. ");
INSERT INTO vgr_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","ఇనె పరిసయ్యుల్‍మాబి, సద్దూకయ్యుల్‍మాబి, కెత్రూకిజణు బాప్తిస్మమ్ లేవనటేకె ఆవనుదేఖిన్‍ హాఃప్నా లఢ్కా, ఆంకరతే దేవ్ను చంఢాల్‍మతూ బఛ్చావనటేకె తుమ్న అక్కల్ బోల్యొతె యోకోన్‌ ");
INSERT INTO vgr_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","ఇనటేకె దిల్ బద్లాలేవను హుయ్తె ఫలంనా ఫలించొ. ");
INSERT INTO vgr_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","అబ్రాహామ్‍నే హమ్న భా కరి సోఛిన్‍ ఆ షిక్చామతూ బఛ్చిజాసుకరి నొకొసోఛొ; హుయ్తొ దేవ్‍ ఆ పత్రావ్‍తీబి అబ్రాహామ్‍నా లఢ్కావ్నా ఫైదకరావ్సెకరి తుమారేతి బోలుకరూస్‍. ");
INSERT INTO vgr_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","హంకేస్ కురాఢి జాఢను పేధడ్ ఫర్ బెందీన్ ఛా అనటేకె కెహు జాఢు అష్యల్ను ఫల్‍ పికకొయిన్తే హర్యేక్‍ జాఢవ్‍నా ఖత్రాయిన్‍ ఆగ్మా నఖావ్సే. ");
INSERT INTO vgr_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","మే తుమ్న దిల్‍ బద్లావనా హాఃజె పానిమా బాప్తిస్మమ్‍ దెంక్రూస్ పన్కి మారొ పీట్పాసల్ వలావతె యో మారెతీబి ఘణు కువ్వత్‍వాలొ; ఇను చెప్లెను గాట్నబీ చోఢనా మన యోగ్యత కొయిని; ఇనె పవిత్రాత్మమాబి ఆగ్తీబి తుమ్నా బాప్తిస్మమ్ దిసె. ");
INSERT INTO vgr_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","ఇను హుఃబ్డు ఇన హాత్మ ఛా, ఇను ఖలుమా అష్యల్‍తి జాడిన్, ఘౌనా కొట్టిమా నాఖిన్, ఉజావకొయింతె ఆగ్మా పొట్టు నాఖిన్‍ భళ్లాకి నాఖిదెవోకరి ఇవ్నేతి బోల్చె. ");
INSERT INTO vgr_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","త్యొ వహఃత్‍ యేసు బాప్తిస్మమ్‍ లేవనటేకె గలిలయమతూ యోర్దాన్ నదినూ కందెచ్ఛాతె యోహాన్‍కనా ఆయో. ");
INSERT INTO vgr_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","అనటేకె యోహాన్ మే తారహాతె బాప్తిస్మమ్‍ లేవనుచ్ఛాని తూ మారకనా వలావస్నా? కరి యోహాన్ పుఛ్చాయో. ");
INSERT INTO vgr_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","యేసు హంకె అమ్‍హువదా నీతియావత్తు అమ్నితరా కరనూచ్ఛాకరి, అప్నా జరగనూ హుయిన్ఛాకరి ఇనేతి పాచుపరాయిన్‍ బోల్యొ. తెదెయో ఇంనితరా కర్యొ. ");
INSERT INTO vgr_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","యేసు బాప్తిస్మమ్‍ లిదొతెదేస్‍ పానిమతూ కనారీన ఆయో హదేక్ ఆకాష్‍ ఖొలాయిన్, దేవ్ను ఆత్మా ఉప్పర్తూ పర్యావ్నితరా ఉత్రీన్ ఇనఫర్ ఆవనూ దేక్యొ. ");
INSERT INTO vgr_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","ఆకాష్‍మతూ ఏక్ ఆవాజ్ ఆయూ, అనేస్‍ మారొ లాఢ్‍నొ ఛియ్యో మే అనకనా ఘణు ఖుషీ హుంక్రూస్‍. ");
INSERT INTO vgr_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","తెదె యేసునా సైతాన్‍తి పరీక్షాకరనా దేవ్ను ఆత్మాతి జాఢిమా లీన్గయు. ");
INSERT INTO vgr_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","ఛాలిహ్ః ధన్, రాత్ పస్తు రవ్వమా పాసల్తి ఇన భుక్‍ లగ్యు; ");
INSERT INTO vgr_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","యోసైతాన్ ఇనకనా ఆయిన్, తూ దేవ్నొ ఛియ్యోహుయోతో ఆ పత్రావ్‍నా రోటహోనుతిమ్‍ ఆజ్ఞ దాకరి బోలమా; ");
INSERT INTO vgr_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","అనటేకె యేసు బోల్యొ, అద్మియే రొట్టావ్‍తీస్, జీవకొయిని పన్కి, దేవ్ను మ్హోడమతూ ఆవతె హర్యేక్‍ వాక్యంతీబి జీవ్సెకరి లేఖనాల్మా లిఖ్కైరూస్కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","ఎజాత్నొ యోసైతాన్‍ పరిసుద్ధ యెరూషలేమ్‍నా బులైలీన్‍‍, మందీర్నుచోఛ్నా ఉఫ్పర్ ఇనా ఉబ్బారి రాఖిన్; ");
INSERT INTO vgr_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","తూ దేవ్నొ ఛియ్యో హుయ్యోతొ ఫహాడ్‍పర్తూ హేట్‍కూద్‍, ఇనె తారటేకె ఇను దూతల్నా ఆజ్ఞదిసె; తెదె తార గోఢన యేఢినాబీ పత్రొ లగ్చెకొయినితిమ్ ఇవ్నె తునా హాతేతి పల్లిసేకరి లిఖ్కారూస్‍కరి బోలమా. ");
INSERT INTO vgr_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","ఇనటేకె యేసు భా హుయోతె తారొ దేవ్నా నాపరీక్షాకర్నూకరి బుజేక్‍జొగొ లిఖ్కాయ్‍రూస్కరి ఇనేతి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","ఇనబాద్‍మా యో సైతాన్ మోటు ఫహాడ్పర్ లీజైయిన్ హదేక్ ఆ ములక్‍ను రాజ్యంహాఃరు ఇను మహిమన వతాలీన్. ");
INSERT INTO vgr_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","తూ గుడ్గెమేటిహుయీన్‍ మన హఃలామ్‍కర్ ఆహాఃరు తున దీస్కరి ఇనేతి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","యేసు ఇనేతి అమ్‍ బోల్యొ సైతాన్ మారకంతూ చలోజా ప్రభుహుయోతె తారొ దేవ్నాస్‍నా హాఃలామ్ కర్నూకరి లిఖ్కాయ్‍రూస్‍ కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","తెదె యోసైతాన్ ఇనా బెందీన్ జావమా దేవ్నా దూతల్ ఆయిన్ ఇనా సేవకరలగ్యూ. ");
INSERT INTO vgr_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","తెదె యోహాన్నా ధరీన్ బాంధి రాక్యూస్‍కరి యేసు ఆవాతె హఃమ్జొతెదె పాచుఫరీన్ గలిలయమా గయో. ");
INSERT INTO vgr_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","నజరేతునా బెందీన్, ఎజ్గతు జెబూలూను నఫ్తాలికరి నంగర్ను ఇలాహోఃమా ధర్యావ్నుసేడె కపెర్నహూమ్‍‍మా ఆయిన్ జింకరతొ థొ. ");
INSERT INTO vgr_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","జెబులూన్‍ నంగర్ను నఫ్తాలిను నంగర్ను, యోర్దాన్నా పార్ఛాతె ధర్యావ్ను కనారి కెత్రూకి అద్మిజీవనా గలిలయమా అంధారమాజింకరతె అద్మిహాఃరు మోటు ఉజాలు దేక్యు. ");
INSERT INTO vgr_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","మర్జావను జొగొమా మరణ్ను ఛాలమాహొ బేషిన్ రయ్యూతె ఇవ్నా హాఃరఫర్ ఉజాలు నిక్ల్యు, ");
INSERT INTO vgr_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","ప్రవక్త హుయోతె యేషయా బోల్యొతె వాతె బొలాయుతిమ్ అమ్ హుయు. ");
INSERT INTO vgr_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","తెప్తుధరీన్ యేసు స్వర్గంను రాజ్యం హాఃమేస్‍ ఆయ్రూస్‍, అనటేకె పాప్‍నా బెందీన్‍ దిల్ బద్లాయ్‍ లెవోకరి బోల్తొహుయీన్ ప్రచార్‍ కరనూ సురుకర్యొ. ");
INSERT INTO vgr_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","యేసు గలిలయమా ధర్యావ్ను కనారీనా చాలీన్ జంకరమా పేతుర్‍కరి, సీమోన్ ఇను భైహుయోతె అంద్రెయకరి, భే భైయ్యె ధర్యావ్మా జాళు నాఖను దేక్యొ ఇవ్నె మాస్లధరవాలు ");
INSERT INTO vgr_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","తెదె తుమె మారకేడె ఆవొ, మే తుమ్నా అద్మియేనా ధరవారళ షికారినితర కరూస్కరి ఇవ్నెతి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","తెదేస్ ఇవ్నె ఇవ్ను జాళియా హాఃరు బెందీన్ ఇనకేడె గయూ ");
INSERT INTO vgr_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","ఇనె ఎజ్గతూ జైయిన్‍ జెబెదయ్‍నొ ఛియ్యో యాకోబ్, ఇను భై హుయోతె యోహాన్‍కరి బుజు బేజనా ఇన భైయ్యాబి ఇన భా హుయోతె జెబెదయకనా ఢోంగమా జాళి అష్యల్ కరుకరతె దేఖిన్, ఇవ్నా బులాయో ");
INSERT INTO vgr_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","తెదేస్ ఇవ్నె ఇవ్ను ఢోంగనాబి భా కనా బెందీన్, ఇనకేడె గయా. ");
INSERT INTO vgr_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","యేసు ఇవ్ను యూదుల్ను న్యావ్‍నుజొగొ మందీర్‍మా బోధకర్తొ, దేవ్ని రాజ్యంను సువార్తనా ప్రచార్‍ కర్తొ, అజు అద్మియేమాతూతె హర్యేక్‍ జబ్బునా, రోగ్నా, అష్యల్ కర్తో గలిలయమా హాఃరు పర్యొ. ");
INSERT INTO vgr_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","ఇను హాఃబర్‍ సిరియా దేహ్క్ హాఃరు ప్హైలాయి గయు. కెహూ కెహూకి రోగ్తిబి, వేదనతీబి, ముర్జాంగుతె రోగ్ హాఃరవ్నా, భూత్‍ ధర్రాక్యుతె ఇవ్నా, జూఠపఢుగ్యూతె ఇవ్నా ఇనకనా బులాలీన్ ఆవమా, యో ఇవ్నా అష్యల్ కర్యొ. ");
INSERT INTO vgr_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","గలిలయనూ, దెకపొలి యేరూషలేమ్ను, యూదయాను, జొగొమచ్ఛాతె హాఃరు యోర్దానునా యోబాజుతూ నిఖీన్ కెత్రూకి అద్మిహాఃరు ఇన జొడ్మా గయూ. ");
INSERT INTO vgr_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","ఇనె యో అద్మి హాఃరవనా దేఖిన్ ఫహాడ్ ఫర్ చఢీన్‍ బేసి రవ్వమా, ఇను సిష్యుల్‍ హాఃరు ఇనకన ఆయు ");
INSERT INTO vgr_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","తెదె యో మోఢు పాఢిన్‍ అమ్ బోలలగ్యొ. ");
INSERT INTO vgr_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","ఆత్మయతమ విషయంమా దీనుల్ హువ్వాలు ఇవ్నె భాగ్యవంతుల్; స్వర్గంను రాజ్యం ఇవ్ను హుసె. ");
INSERT INTO vgr_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","బాధ పడుకరుతె ఇవ్నె భాగ్యవంతుల్; ఇవ్నె ఓదార్చబడ్సె. ");
INSERT INTO vgr_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","నిధానంతి రవ్వాలు భాగ్యవంతుల్; ఇవ్నె ధర్తి అక్కునా కోన్డిలీసె. ");
INSERT INTO vgr_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","నీతినటేకె భుక్కె రవ్వాలు భాగ్యవంతుల్; ఇవ్నె తృప్తితి హుయీన్‍ ర్హాసె. ");
INSERT INTO vgr_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","పార్లెంఫర్‍ గోర్తి రవ్వాలు భాగ్యవంతుల్; ఇవ్నె గోర్న పొంద్సె. ");
INSERT INTO vgr_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","దిల్మా‌ సుద్దితి రవ్వాలు భాగ్యవంతుల్; ఇవ్నె దేవ్న దేక్చె. ");
INSERT INTO vgr_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","సమాధానం కరవాలు భాగ్యవంతుల్; ఇవ్నె దేవ్ని ఛియ్యాకరి బొలావ్సె. ");
INSERT INTO vgr_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","దేవ్ను నీతినా నిమిత్తమ్‍ హఃతాంకరతె ఇవ్నె భాగ్యవంతుల్; స్వర్గంను రాజ్యం ఇవ్ను హుసె. ");
INSERT INTO vgr_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","తుమే మారకేడె ఆవనుబారెమా అద్మియే తుమ్న నిందకరీన్‍ హఃతావాను, తుమారఫర్ చహాడ్తి ఖరబ్‍ వాతె బోల్యుతెదె తుమె ధన్యుల్. ");
INSERT INTO vgr_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","ఖుషి కుషల్తి రవ్వొ, స్వర్గంమా తుమారు ఫాయిదో జాహఃత్ హుసె. అమ్నితరా ఇవ్నె తుమ్న జమానేతూ ఛాతె ప్రవక్తలనాబి హింసకర్యు. ");
INSERT INTO vgr_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","తుమె ములక్మా మీట్నితరా హుయిన్ ఛా. మీట్మఛాతె ఖారును గుణం గయూతొ యో ఖారు కినేతి ఆవ్సె? తెదె యోబాదర్ నాఖిదీన్ అద్మియేను గోడతి కుంద్లనటేకెస్ పన్కి, ష్యానబి కామె ఆవ్సె కొయిని. ");
INSERT INTO vgr_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","తుమె ఆ ములక్మా ఉజాళునితరా హుయిన్ ఛా. పహాడ్ఫర్ ఛాతె నంగర్నా లపాఢన హుసేకొయిని. ");
INSERT INTO vgr_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","అద్మియే దివ్వొనా బాలిన్ ఇనా మంచన హేట్ బేంద్చెకొయిని, పన్కి యోఘర్మా ఛాతె హాఃరవ్నా ఉజాళు రవ్వానటేకె దీపస్తంబంఫరస్‍ బేంద్చె. ");
INSERT INTO vgr_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","ఇంనితరా అద్మియే తుమారు ఛాల్ దేఖిన్, స్వర్గంమా ఛాతె తారొ భానా మహిమపర్చునుతిమ్‍ ఇవ్నా హాఃమె తుమారు ఉజాళు ప్రకాష్‍హువదా. ");
INSERT INTO vgr_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","ధర్మషాస్ర్తంనాతోబి, ప్రవక్తల్నూ వచనాల్తోబి, మరైయినాఖనా ఆయోకరి సోచ్చొనొకొ కర్రావ్నాటేకెస్ ఆయోగాని, మరైయినాఖనటేకె మే ఆయోకొయిని. ");
INSERT INTO vgr_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","ఆకాష్‍బి, ధర్తి మట్టిజాసె పన్కి, ధర్మషాస్ర్తం హాఃరుబి హువతోడి ఇన్మతూ ఏక్ న్హాను పొల్లుబి, ఏక్ సున్నాతోబి మట్సెకొయినికరి హాఃఛితి తుమారేతి బోలుకరూస్. ");
INSERT INTO vgr_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","అనటేకె ఆ ఆజ్ఞమా ఛాతె ఆ న్హానుషూ ఏక్నతోబి మీరీన్‍, అంనితరా కోణ్ బోధించస్కీ, యో స్వర్గంమా హాఃరంతీబి నాన్హోకరి బొలావ్సె; పన్కి యోహాఃరు మాలంకరీన్ కోన్‍ బోధించస్కి యో స్వర్గంను రాజ్యంమా ఘను మహాన్‍ బొలావ్సె. ");
INSERT INTO vgr_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","సానటేకెకతొ షాస్ర్తుల్ను నీతితీబి, పరిసయ్యుల్ నీతితీబి, తుమారు నీతి జాహఃత్‍కరి నాసోచతొ తుమే స్వర్గంను రాజ్యంమా జాసుకొయినికరి తుమారేతి బోలుకరూస్. ");
INSERT INTO vgr_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","అద్మినా నామర్రాక్ను నొకొకరొ మర్రాఖవాలొ షిక్చనా గురిహుసేకరి జమానమా బొలాయుతె వాతె తుమె హాఃమ్జని. ");
INSERT INTO vgr_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","మే తుమారేతి బోలుకరూస్ షాత్కతొ కోన్బిహొ ఇను భై ఫర్ చంఢాల్‍ హువతె హర్యేక్‍ జణు విమర్షమా ఆవ్సేకరి, ఇన భై నాదేఖిన్ పాల్తు అద్మికరి బోలవాలొ మహాసభమా ఆవ్సె; ద్రోహీకరి బోలవాలొ నరకంమా జాసె. ");
INSERT INTO vgr_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","అనటేకె థూ బలిపీఠంనా హాఃమె అర్పణనా దేవాను వహఃత్‍ తార భైనా తారఫర్ ఛండాల్తి ఛాసుకి యెజ్గా తునా హఃయల్ ఆయుతొతెదె ");
INSERT INTO vgr_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","ఎజ్గ బలిపీఠంనా హాఃమెస్ తారు అర్పణనా బెందిన్, తూ అగాఢి జైయిన్ తార భైతి మలీన్ సమాధానంహుయిన్‍; ఇన పాసల్‍ ఆయిన్‍ తారు బలి అర్పణనా దిజొ. ");
INSERT INTO vgr_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","తారొ దుష్మన్తి తూ వాట్పర్ రవ్వాన వహఃతాస్‍ ఎగ్గిస్‍ ఇనేతి మలీన్ రాజిపడ్జొ నైహితొ ఏక్తార తారొ దుష్మన్ తున నెయ్యోకనా ధరాయ్‍ దిసె, నెయ్యో తునా బంట్రౌతునా ధర్యాయ్ దిసె, తెదె తున ఠాణమా నాఖిదిసె. ");
INSERT INTO vgr_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","తుమె పేఢ్నూతె జుల్మానం పేఢతోడి ఎజ్గతూ తూ భాదర్ ఆయిస్కొయినికరి, తారేతి హాఃఛితి బోలుకరూస్. ");
INSERT INTO vgr_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","వ్యభిచార్ నొకొకరోకరి బొలాయుతె వాతె తుమె హఃమ్జీ రాక్యస్‍ కొయిన్నా. ");
INSERT INTO vgr_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","మే తుమారేతి బోలుకరూస్ సాత్కతొ ఏక్ రాండ్నా ఛోర్ ఢోళతి దేఖవాల కోన్బి హర్యేక్‍ జణూ తెదేస్ ఇను దిల్మా యోరాండ్తి వ్యభిచార్‍ కరవాలొ హుయ్రోస్‍. ");
INSERT INTO vgr_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","తారు ఖవ్వాహాత్ ఢోళొ గలత్కరిహుయూతొ ఇనకాఢీన్ తారకంతు దూర్ ఫేకినాక్ తారు ఆంగ్తాన్‍ అక్కూ నరకంమా పడ్జాయ్‍కొయినీ తింమ్ తార ఏక్‍ భాగ్‍ నికిజావను తున అష్యల్ కాహెనా. ");
INSERT INTO vgr_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","తారు ఖవ్వాహాత్ తునా పాపంనా కరావనా కారణ్‌హుయుతొ ఇనా కత్రీన్‍ తారకంతూ ఫేకినాక్‍ తారు ఆంగ్తాన్‍ అక్కు నరకం పడ్జాయ్‍ కొయినితింమ్, తారు ఆంగ్తాన్‍మా ఏక్‍ భాగ్‍ నికిజావను తున అష్యలస్‍ కాహెనా. ");
INSERT INTO vgr_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","ఇను బావన్నా బేందవాలొ యోబాయికోన తలాక్ను కాగత్ దేనూకరి బోల్యురాక్యుస్‍ కాహేనా ");
INSERT INTO vgr_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","మే తుమారేతి బోలుకరూస్ సాత్కతొ వ్యభిచార్ను కారణం కాహేతింమ్‍ ఇను బావన్నా బేందావవాలు హర్యేక్‍ జనూబి యోబాయ్కోన వ్యభిచార్నితరా కరూకరస్ బుజు బెంద్యోతె బాయ్కోన య్హా కరవాలు వ్యభిచార్ కరూకరస్. ");
INSERT INTO vgr_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","బుజు తూ ఝూటి ఒట్టునా నాకర్నూతిమ్ తారు ఒట్టు ప్రభువునా హాఃమే ప్హేడ్నుకరి జమానమా బోల్యుతె వాతె తుమె హాఃమ్జకొయిన్నా, ");
INSERT INTO vgr_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","మే తుమరేతి బోలుకరూస్ సాత్కతో కెత్రూబి ఒట్టు నొకొబేంద్చు; ఆకాష్‍ఫర్‍ ఒట్టు నొకొబేంద్చు; యోదేవ్ని సింహాసనమ్. ");
INSERT INTO vgr_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","జమీన్‍ఫర్‍ ఒట్టు కరి నొకొబోలొ యో ఇను గోడను పీఠ, యెరూషలేమ్‍ఫర్ ఒట్టు నొకొబేంచ్చు; యో మహారాజొను నంగర్‍ ");
INSERT INTO vgr_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","తార ముఢ్య్కాఫర్ హాత్ బేందీన్ ఒట్టు నొకొబేందొ, తూ ఏక్ కేహ్క్ తోబి ధోలుతోబి, ఖాళుతోబి కరీస్‍కొయిని. ");
INSERT INTO vgr_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","తుమారు వాతె, హాఃఛికతొ హాఃఛికరి న్హైతో, కాహేకతొ కాహెకరీ ర్హాను; ఆహాఃరు బెందీన్ ఆయుతొ యో దుష్టుడ్‍ను కంతూ ఆయుతేస్. ");
INSERT INTO vgr_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","ఢోళొనా బదుల్ ఢోళొకరి, ధాత్నా బదుల్ ధాత్కరీ బోలాయుతేవాతే తుమే హఃమ్జని. ");
INSERT INTO vgr_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","సానకతో మే తుమారేతి సాత్ బోలుకరూస్ హానికరవాలొనా, తార ఖవ్వాహాత్నూ గాల్ఫర్ మార్యూతొ, తూ ఢవ్వాత్నూ గాల్బీ వతాల్జొ. ");
INSERT INTO vgr_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","కోన్బి తారఫర్ లఢాయ్‍కరీన్ తారు కుడ్తా, లుంగ్డా చినాయ్‍లిదుతో, తూ పేరిరాక్యొతె ఉప్పర్నూ టవల్నాబి కాఢీన్ ఇన దినాఖి దిజొ. ");
INSERT INTO vgr_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","కోన్బి తుమ్నా ఏక్ మైల్ దూర్ ఆవ్కరి, తున జబర్దేస్తి కర్యూతొతెదె, తూ ఇనకేడె భే మైల్‍ పర్లాంగ్ దూర్ జాజొ. ");
INSERT INTO vgr_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","తారకనా మాంగతె ఇనదిజొ, తుమారకనా ఉధార్ మాంగ్యూతొ ఇనకంతూ తారు మ్హోడు నొకొపర్యాషు. ");
INSERT INTO vgr_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","తారు “సహోదరుల్నా ఫ్యార్‍కరీన్‍, తారు వైరియేనా ద్వేషించ్కరి” బోల్యొతె వాతె తుమె హఃమ్జి రాక్యస్ కొయిన్నా. ");
INSERT INTO vgr_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","మే తుమారేతి సాత్ బోలుకరూస్ కతొ, తుమ్నా హింసించుకరతె ఇవ్నటేకె ప్రార్థన కరొ. తుమార వైరియేనా ఫ్యార్‍కరొ. ");
INSERT INTO vgr_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","అనటేకె స్వర్గంమా ఛాతె తారొ భాన ఛియ్యాహుయిన్ ర్హాసు. యో అష్యల్ అద్మిఫర్బి, ఖర్రాబ్ అద్మిఫర్బి ఇను సూర్యోదయ్‍ను ఉజాలు నాఖిన్, నీతితిఛాతె అద్మిఫర్బి, అవినీతితి ఛాతె దుర్నితి అద్మిఫర్బి పానినా వర్హాంకరస్. ");
INSERT INTO vgr_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","తుమె తుమ్న ఫ్యార్‍ కరవాలనస్ ఫ్యార్‍ కర్యతొ, తుమ్న షాను ఫాయిదొ మల్సె. సుంకరూల్బి ఇమ్మస్ కరూకరస్ని కాహెనా. ");
INSERT INTO vgr_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","తుమార భైయ్‍నాబి, ఇవ్నస్ హఃలామ్ కర్యాతొతెదె తుమె జాహఃత్ సాత్కరూకరస్? అన్యుల్ను అద్మి హాఃరుబి యోస్ కరూకురస్ కోయిన్నా. ");
INSERT INTO vgr_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","తారో స్వర్గంనో భా పరిపూర్ణడ్‍, అనటేకె తుమేబి పరిపూర్ణుల్‍హుయిన్ ర్హాసు. ");
INSERT INTO vgr_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","అద్మియేన దెఖ్కావ్నుకరి, ఇవ్నాహాఃమె తారు నీతికార్యంన కరకొయినితిమ్‍ జత్తన్తి ర్హవొ; న్హైతొ స్వర్గంమా ఛాతె తార భాకనా తుమ్నా ఫాయిదొ మల్సెకొయిని. ");
INSERT INTO vgr_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","అనహాఃజె తూ ధర్మంకరనా వహఃత్, అద్మియేకనా మహాన్‍ కమావ్నుకరి, చోర్ భక్తుల్ యూదుల్ను ప్రార్థనజొగొమా గల్లీమాహొ, కరతిమ్ తారు అగాడి పుంగి ఫూఖిష్‍నొకొ; ఇవ్నె ఇవ్ను పాయిదోనా పొందిరాక్యూస్‍‍కరి, హాఃఛితి తుమారేహూః బోలుకరూస్. ");
INSERT INTO vgr_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","థూ హుయుతో ధర్మం కరనీవహఃత్, తారు ధర్మం కినాబి మాలంకొయినితిమ్ ర్హానుతిమ్‍, తారు ఖవ్వాహాత్ కరుకరతె, తార ఢవ్వాహాత్నబి మాలంకొయినితిమ్ ర్హాను. ");
INSERT INTO vgr_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","ఇంహుయుతో ఆహ్‍ఃరేతి దేఖుకరతె తార భా తునా జాహఃత్‍ ఫాయిదొ దిసె. ");
INSERT INTO vgr_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","బుజ తుమె ప్రార్థనకరని వహఃత్‍ వేషదారుని ఘోని నొకొర్హాషు; అద్మిహాఃరౌన దెఖ్కావ్నూకరి, న్యావ్‍ కరనుజొగొమా, గల్లియమాహో, ఉబ్రీన్ ప్రార్థనా కరనూ ఇవ్నా ఇష్టమ్; ఇవ్నే ఇవ్నూ ఫాయిదో లీరాక్యస్‍కరి, తుమారితి హాఃఛితి బోలుకరూస్; ");
INSERT INTO vgr_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","హుయుతొ తూ ప్రార్థనా కరనివహఃత్‍ తార ఘర్మా జైయిన్, ధర్వాజుమూచిన్, రహష్యంతీ కినా మాలంకొయినితిమ్, తారో భానా ప్రార్థనాకర్; తెదె ఆహ్‍ఃరేతి ఛాతె తారో భా తునా ఫాయిదో దిసే. ");
INSERT INTO vgr_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","బుజూ తుమె ప్రార్థనా కరని వహఃత్‍ అన్యుల్ కరతేతిమ్ తుమె ప్రార్థన నొకొకరో; జాహఃత్తి వాతెబోల్యతొ ఇవ్నివాతే హఃమ్జావ్సేకరి ఇవ్నె సోచిలెంకరస్; తుమె ఇవ్నిఘోని నొకొర్హవొ. ");
INSERT INTO vgr_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","తుమె తార భాకనా మాంగని అగాడీస్ తుమ్నా సాత్ హోనుకీ ఇన మాలం. ");
INSERT INTO vgr_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","అనటేకె తుమె అమ్ ప్రార్థనా కరో, స్వర్గంమా ఛాతె మారొ భా, తారు నామ్ మహిమ హువదా, ");
INSERT INTO vgr_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","తారు రాజ్యంమ్‍ ఆవదా, తారు చిత్తమ్ స్వర్గంమా హుంకరతెతిమ్ ధర్తిఫర్బీ హువదా. ");
INSERT INTO vgr_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","హమ్నా హర్ ధన్నూ ఖానూ ఆజ్నా ధన్నె హమ్నా ధిజొ. ");
INSERT INTO vgr_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","హమే ఏక్నూ గలత్నా మాప్‍ కర్యతిమ్, హమారు గలత్నాబి మాప్‍ కర్జొ. ");
INSERT INTO vgr_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","హమ్నా సోధనమా ఆవకొయినీతిమ్, దుష్మన్‍కంతూ హమ్నా బఛ్చావ్. ");
INSERT INTO vgr_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","అద్మియేను కర్రాబ్‍కామ్న తూ క్చమించితొతెదె, స్వర్గంమా ఛాతె తారొ భానా తారు కర్రాబ్‍కామ్నా మాప్‍ కర్సె. ");
INSERT INTO vgr_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","తుమె అద్మిను కర్రాబ్‍కామ్నా నామాప్‍ కర్యొతొ తెదె, తారో భా తుమారు కర్రాబ్‍కామ్నా మాప్‍ కర్సెకొయిని. ");
INSERT INTO vgr_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","తుమె పస్తు రవ్వని వహఃత్‍ వేషదారుని ఘోని బాధతీ నొకొరవ్వొ; ఇవ్నే పస్తూ కరూకరస్‍కరి అద్మియేవ్నా మాలంహోనుకరి ఇవ్నే ఇవ్ను మ్హోడనా ముర్జాలీన్ ర్హాస్‍; ఇవ్నే ఇవ్ను పాయిదో లీన్ ఛాకరి హాఃఛితి బోలుకరూస్. ");
INSERT INTO vgr_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","పస్తూ రవ్వాని వహఃత్‍ అద్మియేనా దెఖ్కావ్నూకరి కాహెతిమ్‍, ఆహ్‍ఃరేతి ఛాతె తారో భానస్ దెఖ్కావ్నూకరి, తూ పస్తూ కరనివహఃత్‍ తారు మాతనా తేల్ లగాఢీన్, తారు మ్హోడనా ధొహిలా. ");
INSERT INTO vgr_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","తెదె ఆహ్‍ఃరేతీ దేకుకరతే తారో భా తునా ప్రతిఫల్ దిసే. ");
INSERT INTO vgr_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","తుమారటేకె జమీన్‍ఫర్‍ ధవ్లత్నా నొకొకమాయిలేవొ; అజ్గ జాఢవాలుబీ, ఛిళం ఖైనాక్చె, చొట్టా దేఖిరాఖీన్ లపాఢిలిసె. ");
INSERT INTO vgr_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","తుమారటేకె స్వర్గంమా దవ్లత్నా కమాయ్‍లెవో, ఎజ్గా జాఢవాలుబీ, చెత్తనా పాడినాకవాలుబికొయిని, చొట్టాదేఖిన్ పాడ్చెబికొయిని, లపాడ్చెకొయిని. ");
INSERT INTO vgr_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","తారు ధవ్లత్ కెజ్గా ర్హాస్కి, కెదేబి తారు దిల్‍ ఎజ్గాస్ ర్హాసె. ");
INSERT INTO vgr_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","ఆంగ్తానా ఉజాళు ఢోళొస్, ఇనటేకె తారు ఢోళొ అష్యల్ ర్హహితో తారు దిల్బీ ఉజాళుహూయిన్‍ ర్హాసే. ");
INSERT INTO vgr_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","పన్కి తారో ఢోళొ అంధారుహుయుతొ తారు ఆంగ్ అక్కు అంధారుహుయిన్ ర్హాసె; తారమా ఛాతె ఉజాలు అంధారుహుయీన్ ర్హహితో తెదె యోఅంధారు ఘను మోటుహుయీన్‍ ర్హాసే. ");
INSERT INTO vgr_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","కోన్బి కామ్‍ కరవాల భే మాలిక్‍ధార్నా ఎక్కస్‍ చోట్‍ కామ్ కరనా కోహోయిని; ఏక్నా చంఢాల్తి దేఖ్యొతొ, బుజేక్నా ఫ్యార్‍తి దేక్చె. తుమె దేవ్‍కన బుజు రఫ్యాకనా, కామ్ కరవాలను ఘోని ర్హాసుకొయిని. ");
INSERT INTO vgr_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","ఇనటేకె మే తుమారేతి సాత్ బోలుకరుస్‍కతో, సాత్ ఖాసూకి, సాత్ పీషుకి కరి, తుమారు జాన్‍టెకేబి, సాత్ పేర్సూకీకరి, తుమారు ఆంగ్తాన్నాటేకెతోబి చింతపడొనొకొ; ఖానుతీబి జాన్‍ మహాన్‍ కాహేనా? లుంగ్డాతీబి, ఆంగ్తాన్‌ మహాన్‍ కాహేనా? ");
INSERT INTO vgr_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","ఆకాష్‍ను జిన్వార్నా దేక్కొ; యో బింజ్లొనా గాఢకొయిని, వాఢకొయిని, బాణమా లపాఢకొయిని, రైహితోబి తారొ స్వర్గంమా ఛాతె భా ఇవ్నా పాలుకరస్; తుమె ఇవ్నాతీబి ఘణు స్రేష్ఠుల్‍ కాహెనా? ");
INSERT INTO vgr_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","తుమారమా కోణ్ చింతపడనూ బారెమా ఇనటేకె ఇను యెత్తు ఆయుస్సు జాహఃత్‍ కర్లిసేనా? ");
INSERT INTO vgr_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","లుంగ్డనటేకె తుమె చింతపడతె ష్యాన? జాఢినూ పూల్ కింమ్ ఒధుకరస్కి హఃయల్ కరో, యోమిన్హత్ కరకొయిని, ఒడకకొయినీ; ");
INSERT INTO vgr_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","హుయుతోబి ఇను సమస్తంను మోల్నులుంగ్డా అందంతి ఛాతె సొలొమోన్బీ ఏక్నూ జోడనూతరబి అలంకరించొ కొయిని; ");
INSERT INTO vgr_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","ఆజ్ రహీన్ కాల్ చుల్లమా నాక్చుతే జాఢినూ న్హాను గాహ్క్ నా దేవ్ అమ్ అలంకరించి రాక్యొతెదె, అల్పవిష్వాసీ, తుమ్న బుజూ కఛ్చితనంతి లుంగ్డాన పెరావ్సేని కాహేనా. ");
INSERT INTO vgr_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","అనటేకె సాత్ ఖాసుకీ సాత్ పీసుకీ, సాత్ పేర్సూకీకరి చింతపడొనొకొ; అన్యుల్ అద్మియే ఆహాఃరవ్నాటేకెస్ విచారించుకరస్. ");
INSERT INTO vgr_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","ఆహాఃరు హోనుకరి స్వర్గంమా ఛాతె తార భానా మాలం. ");
INSERT INTO vgr_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","ఇనటేకె తుమె దేవ్నూ రాజ్యంనా, ఇను నీతినా అగాడి ధూండో; తెదె యోహాఃరు తుమ్నా దెవ్వాసే. ");
INSERT INTO vgr_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","అనటేకె కాల్నాధన్‍టేకె చింతపడొనొకొ; కాల్నధన్ ఇను సంగతులనాటేకె చింతాహుసే; కెహూధన్ను యోధన్నస్‍ భైష్‍. ");
INSERT INTO vgr_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","తుమె న్యావ్నా నొకొతీర్చొ, తెదె తుమారబారెమా న్యావ్ కర్సేకొయిని. ");
INSERT INTO vgr_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","తుమె అలాదవ్‍ఫర్ న్యావ్ బోల్యొతొ తుమారఫర్‍బి న్యావ్ బోల్చె. తుమె మోజీన్ నాక్చు తిమ్మస్‍ తుమ్న మోజీన్ నాక్చె. ");
INSERT INTO vgr_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","తారు ఢోళమ ఛాతె పెల్కు ఛాకరి మాలంకరకొయింతిమ్ తార భైనా ఢోళమా పడ్యుతె నల్సు దేఖతె సే? ");
INSERT INTO vgr_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","తార డోళమా పెల్కురవ్వాని వహఃత్‍ తూ భై నా దేఖిన్ తారొ భైని డోళమనూ పెల్కునా కన్నాకనా తున తేటగా దెఖ్కావ్సె. ");
INSERT INTO vgr_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","కపాటి, అగాడి తార ఢోళమా ఛాతె పెల్కునా కన్నాకి ధా తెదె తున అష్యల్తి దెఖావ్సె, తార భైనా ఢోళమాఛాతె నల్సునా కాఢినాఖిస్. ");
INSERT INTO vgr_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","పరిసుద్ధంతి ఛాతె కెహూబి కుత్ర్యావ్నా నొకొనాఖొ, తుమార ముత్యాల్నా ఢూకర్‍కనా నొకొనాఖొ; ఇంకర్యతొ యో ఏక్తార ఇనా గోడతి ఖుంద్లీన్‍ తుమారఫర్ పఢీన్ తుమ్న చీరినాక్చె. ");
INSERT INTO vgr_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","మాంగొ తుమ్న దెవ్వాసె. ధూండొ తుమ్న మల్సె, తలుపు ఠోకొ తుమ్న తలుపు కొలావ్సె. ");
INSERT INTO vgr_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","మాంగాతె హర్యేక్‍ జణూ పొంద్చె, ధూండవాలనా మల్సె, ఠోకవాలనా తలుపు కొలావ్సె. ");
INSERT INTO vgr_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","తుమారమ కెహూ అద్మితోబి ఇను ఛియ్యో యో రోటొమాంగ్యోతొ ఇన పత్రొదిసేనా? ");
INSERT INTO vgr_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","మాస్లు మాంగ్యతో హాఃప్నా దిసేనా? ");
INSERT INTO vgr_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","తుమె కర్రాబ్‍వాల రహీన్బి తుమార ఛియ్యావ్నా అష్యల్ రాచు దేనుకరి సోచిన్, స్వర్గంమా ఛాతె తార భానా మాంగతె ఇవ్నా ఇనతీబి జాహఃత్ ఖఛ్చితనంగా అష్యల్ను రాచు కేహుబి దిసె. ");
INSERT INTO vgr_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","ఇనటేకె అద్మియే తుమ్న ష్యాత్ కర్నూకరి సోచస్కి, తుమె ఇమ్మాస్ ఇవ్నా కరొ. ఆ మేషె ధర్మషాస్ర్తంమాబి బుజు ప్రవక్తల్ బోధించుతె అర్థం ఆస్. ");
INSERT INTO vgr_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","ఇర్కాట్ను వాట్మా జవొ, నాషనంనూ వాట్మా జావను ఛీదుహుయిన్ ఛా. యోవాట్మా జవ్వాలు కెత్రూకి జణు; ");
INSERT INTO vgr_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","జీవంమా జావనువాట్ ఇర్కాట్నుబి పహఃను యోవాట్ ముస్కల్తి ఛా, ఇన మాలంకరవాలు థోడుజణూస్. ");
INSERT INTO vgr_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","జూటి ప్రవక్తల్తి జాగ్రుత్తి రవ్వొ. ఇవ్నె మ్హేంఢను చాంబ్డు పెర్రాఖీన్‍ మైహీ హఢొను స్వభావం, హుయీన్‍ తుమారకన ఆవ్సె. పన్కి ఇవ్నె పేర్యాక్యుతె భారి హఢొనుజోడ్ను. ");
INSERT INTO vgr_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","ఇవ్నాటేకె కల్గుతె ఫలంనాటేకె తుమె ఇవ్న మాలంకర్సు. కాఠొను ఢాగ్మ ద్రాక్చాపండుతోబి గుత్తితోబి, పల్లేర్ను జాఢమతూ అంజూరంనూ పండనాతోబి తోడ్చెనా? ");
INSERT INTO vgr_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","ఇమ్మస్ హర్యేక్ అష్యల్ జాఢునా అష్యల్న పండాలగ్సె, కామే ఆవకొయింతె జాఢన ఖర్రాబ్ పండ లగ్సె. ");
INSERT INTO vgr_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","అష్యల్ జాఢనా ఖర్రాబ్ పంఢా లాగ్సేకొయిని, ఖర్రాబ్ జాఢనా అష్యల్ పంఢా లాగ్సెకొయిని. ");
INSERT INTO vgr_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","అష్యల్నా పంఢా లాగకొయింతె జాఢనా కత్రీన్ ఆగ్మా నఖావ్సె. ");
INSERT INTO vgr_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","ఇనటేకె తుమె ఇవ్ను ఫలంన దేఖిన్ ఇవ్నా మాలంకర్సు. ");
INSERT INTO vgr_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“ప్రభూ, ప్రభూ, కరి మన బులావతె హర్యేక్ అద్మిబి స్వర్గంను రాజ్యంమా జాసేకొయిని” పన్కి “స్వర్గంమా ఛాతె మారు భాను చిత్తమ్న కోణ్ కరస్కి, ఇవ్నేస్ జాసె.” ");
INSERT INTO vgr_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","త్యొ న్యావ్ను ధన్మా కెత్రీకిజణు మనదేఖిన్ ప్రభూ, ప్రభూ, కరి తారునామ్తి హమే దేవ్నువాతె ప్రచార్ కర్యాకొయిన్నా? తారు నామ్తి భూత్‍నా మొక్లిదిదాకొయిన్నా? తారు నామ్తి కెత్రూకి ఆష్చర్యంనా కర్యకొయిన్నా? కరి బోల్చు ");
INSERT INTO vgr_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","తెదె మే తుమ్నా కెదేబి మాలంకొయిని కర్రాబ్‍ కామ్ కరవాలా మారకంతూ హట్ జవోకరి ఇవ్నేతి బోలిస్. ");
INSERT INTO vgr_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","అనటేకె ఆ మారు వాతె హఃమ్జిన్‌, బోల్యొతిమ్‍ కరవాలొ హర్యేక్ జనూబి బండోఫర్ ఇను ఘర్ బాంద్యోతె అక్కల్ వాలనిఘోణి పోలిన్‍ ర్హాసె. ");
INSERT INTO vgr_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","పాని పడ్సె, వాజ్లు ఆవ్సె, వ్యారొ ఘర్ ఫర్ మార్యుతోబి, ఇను బేస్నా బండోఫర్ బాందిరాక్యోస్ ఇనటేకె యో పడ్యుకొయిని ");
INSERT INTO vgr_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","వాతె బుజు ఆ మారు వాతె హమ్జీన్ ఇంనితరా కరకొయింతె హర్యేక్‍ జణూ ఇను ఘర్నా రేతిమా బాంద్యుతె అక్కల్‍కొయింతే ఇనింతరా ర్హాసె. ");
INSERT INTO vgr_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","పాని ఆవ్సె, వాజులు ఆవ్సె, వ్యారొ ఘర్ ఫర్ వాగ్చె, తెదె యో ఖంక్రిగు; ఇను యోస్‍ మహాన్ కరి బోల్యు. ");
INSERT INTO vgr_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","తెదె యేసు ఆవాతె బోలిన్, హుయిజావదీన్ అద్మిహాఃరుబి యోబొల్యొతె వాతేనా అష్యంహుయుగు. ");
INSERT INTO vgr_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","సానకతొ యో ఇవ్న ధర్మషాస్ర్తుల్నితరా కాహెతిమ్‍ అధికార్‍వాలో బోల్యొతిమ్‍ ఇవ్నా బోధించొ. ");
INSERT INTO vgr_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","యో పహాడ్‍పర్తు ఉత్రీన్ ఆయో తెదె కెత్రూకి అద్మిహాఃరు ఇనకేడె గయూ. ");
INSERT INTO vgr_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","హదేక్ కొహోడ్వాలు ఆయిన్, ఇన హఃలామ్ కరీన్ “మాలిక్‍ తున ఇష్టం హుయూతొ మన హుఃద్రీస్” కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","ఇనటేకె యో ఇనూ హాత్‍ చీదుకరీన్ ఇన ఛీమిన్ “మన ఇష్టమస్” తూ అష్యల్ హూకరి బోలమా, తెదేస్ యో కొహోడ్తూ అష్యల్ హుయు. ");
INSERT INTO vgr_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","తెదె యేసు “కినేతీబి సాత్బి నొకొబోలీస్” బాబు; పన్కి తూ జైయిన్, ఇవ్న సాక్చ్యాం వాళొహూయిన్ తారు ఆంగ్తాన్ అక్కనా యజమాన్నునా దెఖ్కాయిన్‍, మోషె బోలిరాక్యుతె చందా దిజోకరి ఇనేతి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","యేసు కపెర్నహూమ్మా గయోతెదె ఏక్ రోమా అధికారి ఇనకన ఆయిన్; ");
INSERT INTO vgr_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","మాలిక్‍, మారు దాసుడ్‍ జూఠపఢీన్‍ బాధ పడుతూహుయిన్, ఘేర్మ ఛాకరి బోలిన్ ఇన భీక్ మాంగ్యొ. ");
INSERT INTO vgr_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","యేసు మే ఆయిన్, ఇన అష్యల్ కరీస్‍కరి బోలమా ");
INSERT INTO vgr_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","యో రోమ అధికారి “మాలిక్‍ నొకొ” తూ మార ఘర్మా ఆవనా యెత్రె యోగ్యతా మన కోయిని “తూ ఏక్‍ వాత్ బోల్యొతోబి, తెదె మారొ దాసుడ్‍ అష్యల్ హుసె.” ");
INSERT INTO vgr_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","మేబి అధికార్నా తగ్గించిలిన్‍ రవ్వాలొ; మార హాత్నహేట్ దాసుల్‍ ఛా; మే ఏక్నా జాకతొ జాసె, ఏక్నా ఆవ్కతో ఆవ్సె, మారొ దాసుడ్నా ఆకామ్ కర్కతో కర్సెకరి జవాబ్ దిదొ. ");
INSERT INTO vgr_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","యేసు ఆవాత్ హఃమ్జీన్ అష్యంహుయీన్‍, కేడె వలావతే ఇవ్నా దేఖిన్ “ఇస్రాయేల్‍మా కినాకనబీ మే ఎత్రే విష్వాస్‍ ఛాకరీ దేఖ్యొకోయిని” కరి హాఃఛితీ తుమారేతి బోలుకరూస్‍. ");
INSERT INTO vgr_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","కెత్రూకి జనూ ధన్‍ నికతే బాజూతి ఓంద్యె ధన్‍ ఢుబతె బాజూతి అద్మియే ఆయిన్ అబ్రాహామ్‍నాకేడె, ఇస్సాక్నాకేడె, యాకోబ్నకేడె, స్వర్గంను రాజ్యంమా బేక్చు పన్కి ");
INSERT INTO vgr_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","రాజ్యంను సంబంధించుహూయు బ్హాధర్ను అంధారమా దక్లినఖావ్సె; ఎజ్గ రొవ్వానుబి దాత్‍, ఛావ్తాహూయిన్‍, ర్హాసేకరి తుమారేతి బోలుకరూస్కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","తెదె యేసు హాంకె జా; తూ విష్వాస్ కర్యోతిమ్ తున హూవదాకరి సతాధిపతితీ బోల్యొ. యో వహాఃత్మాస్‍ ఇను దాసుడ్‍ అష్యల్ హుయో. ");
INSERT INTO vgr_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","పాసల్తి యేసు, పేతుర్ను ఘేర్కన జైయిన్, తావ్తి హుఃతితే ఇన అత్తెన దేఖీన్. ");
INSERT INTO vgr_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","యేసు పేతుర్ని అత్తేను హాత్ ఛీమమా తావ్ ఇన బేందిదు తెదె యో ఉట్టీన్ ఇనా సేవ కరలగి. ");
INSERT INTO vgr_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","హాఃజెహుయు తెదె భూత్‍ ధర్యాక్యూతె అద్మీ హాఃరవ్నా, యేసుకనా బులాయిలీన్ ఆయు. ");
INSERT INTO vgr_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","ఇను వాత్నాబారెమా భూత్న బోలిమోక్లిదీన్‍, రోగ్ హాఃరవ్నా స్వస్థత కర్యొ. అనటేకె ఇనేస్‍ అప్ను కంజోర్‍నా హఃమాలిలీన్‍ అప్ను రోగ్నా భరించోకరి ప్రవక్తహుయోతె యేషయా బోల్యోతె వాత్ హాఃఛిహువనాటేకె అమ్‍హుయు. ");
INSERT INTO vgr_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","యేసు ఇనకన‌ ఛాతె జనాభోనా గుంపును దేఖిన్ గలిలయనాసేడె జియ్యెకరి ఆజ్ఞదిదొ. ");
INSERT INTO vgr_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","తెదె ఏక్ షాస్ర్తి ఆయిన్ “బోధకుడ్‍ తూ కెజ్గ గయోతోబి మే ఎజ్గ ఆయిస్కరి” బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","తెదె యేసు న్హోరినా ఖాడొ, ఆకాష్‍ను జిన్వార్నా జొగొ ర్హాసె పన్కి, అద్మినో ఛియ్యోనా ముడ్క్యూ జుకాయిన్‍ ర్హవాన జొగోబి కొయినీకరి ఇనేతి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","సిష్యుల్మా అజెక్‍జణొ “ప్రభూ మే అగాఢి జైయిన్, మార భాన గాఢీన్ ఆవనా మన చుట్టి దా కరి ఇన బోలమా.” ");
INSERT INTO vgr_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","“యేసు ఇన దేఖిన్ మారకేడె ఆవొ; మర్యూహుయు ఇవ్నె మరీహుయూనా గాఢిలేవదాకరి బోల్యొ.” ");
INSERT INTO vgr_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","ఇనె ఢోంగమా బేసీన్ జావమా ఇను సిష్యుల్బి ఇనకేడె గయు. ");
INSERT INTO vgr_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","తెదేస్‍ ధర్యావ్మా తుఫాన్ ఆయూతెదె, యో ఢోంగ పానిను జుఖాళాతి డఫ్పాయ్‍ గయు. తెదె యో హుఃయీన్ రవ్వమా ");
INSERT INTO vgr_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","ఇవ్నె ఇనకనా ఆయిన్ “ప్రభూ, మర్జావనూ స్థితిమా ఛియ్యే హమ్న బఛ్చావ్‍కరి” ఇనా ఉట్యాడు. ");
INSERT INTO vgr_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","అనటేకే యో విష్వాస్‍ కొయింతె అద్మియే, షానటేకె ఢరూకరస్‍ కరి ఇవ్నేతి బోలిన్, ఉట్టీన్ వ్యాయ్రోన ధర్యావ్నా గట్టితి గుర్కావమా తెదె సోపొహుయ్‍గు. ");
INSERT INTO vgr_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","యో అద్మి హాఃరు అష్యంహుయీన్ యో కెజాత్నోకి, వ్యాయ్రో, ధర్యావ్బి అనూ వాత్ హఃమ్జుకరస్ కరి బొల్లిదు. ");
INSERT INTO vgr_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","యో పార్లిబాజు కనారీనా ఛాతె గదరేనీయుల్ను ఇలాహొఃమా, భూత్‍ ధర్యాక్యూతె బేజన ఢోంగమతూ నిఖీన్ ఇన అగాడి ఆయు. ఇవ్నే హాఃరవ్తి ఘణు ఖీజ్‍ ర్హావమా కోన్బి యో వాట్మా జావన కోహుయూని. ");
INSERT INTO vgr_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","ఇవ్నె హదేక్ “దేవ్నొ ఛియ్యా, తారేతి హమ్నా షానుకామ్, ధన్ ఆయూబికొయిని తెదేస్ హమ్నా బాధకరనాటేకె తూ అజ్గ ఆయోనా, కరి గట్టీతి చిక్రాణ్ బేంద్యు.” ");
INSERT INTO vgr_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","ఇవ్నా దూర్ మోటు ఢూకర్నూ మందో చర్తూ ర్హావమాస ");
INSERT INTO vgr_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","యో భూత్‍, తూ హమ్నా మోక్లిదిదోతొ యో ఢూకర్ను మందమా హక్లినాక్‍ కరి ఇనా బతిమాల్‍లీదు. ");
INSERT INTO vgr_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","యో ఢూకర్‍యేవ్నా “జవోకరీ బోలమా” ఇవ్నె అద్మి హాఃరవ్నా బెందీన్ యో ఢూకర్‍యేమా గయూ, హాదేక్ యో మందహాఃరు భాదర్ నిఖీన్ ధర్యావ్నామహీ మిలావ్తూ జైయిన్, పానిమాపడీన్ మరిగయూ. ");
INSERT INTO vgr_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","ఇవ్నా చరాంకరతె ఇవ్నె మిలావ్తుహుయిన్ నంగర్మాజైయిన్, జరుగ్యూతె కార్యం హాఃరూబి భూత్‍ బేంద్యుతె ఇవ్ను సంగతిబి బోల్యు. ");
INSERT INTO vgr_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","హాదేక్ యో నంగర్మా హాఃరూబి యేసుకనా ఆయిన్, ఇన ఇలాహొఃనా బేందీన్ జాకరి ఇనా బతిమాల్యు. ");
INSERT INTO vgr_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","బాద్మా యేసు డోంగచఢీన్ ధర్యావ్ దాటీన్ ఇను అస్లి గాంమ్మా జావమా. ");
INSERT INTO vgr_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","థోడు జణు మంచోఫర్ హుఃతూతె ఏక్ ఝూటపడ్యుగుతె ఇనా చాధ్రిపర్ హుఃవాడిలీన్ ఇనకనా లీన్ ఆయు. యేసు ఇవ్ను విస్వాస్నా దేఖిన్, యోఝూటపడ్యుగుతె ఇనేతి హిమ్మత్తిరా, తారుపాప్‍ హాఃరు క్చమాహుయీన్‍ ఛా కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","ఆ హఃమ్జీన్ థోడుజణు షాస్ర్తుల్‍మా ఇవ్నేస్ ఆ దేవ్నా బద్నామ్ దూషణ కరూకరస్కరి సోచిలీదు. ");
INSERT INTO vgr_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","ఇవ్నె సాత్ సోచుకరస్కి, యేసునా మాలంహుయు. యో ఇవ్నేతి తుమార ధిల్మమా ఖర్రాబ్ హఃయల్నా ష్యాన సోచుకరాస్‍? ");
INSERT INTO vgr_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","తారు పాప్ హాఃరు క్చమాహుయీన్‍ ఛాకరి బోలనూ హల్కుకి న్హైతొ, ఉట్టీన్ చాల్కరి బోలను హల్కునా? ");
INSERT INTO vgr_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","హుయుతోబి పాప్‍నా క్చమాకరను అధికార్ ధర్తీఫర్‍ అద్మిను ఛియ్యోన ఛాకరి తుమ్న మాలంకర్లేనుకరి ఇవ్నేతి బోలీన్, “ఝూటపడ్యుతే తూ ఉట్ తారు ఛాద్రిపల్లీన్ ఘర్కనా జా కరి బోల్యొ.” ");
INSERT INTO vgr_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","ఝూటొపడ్యుతె అద్మి ఉట్టీన్ ఇన ఘర్కనా గయో. ");
INSERT INTO vgr_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","అద్మిహాఃరు యోదేఖిన్ ఢరిజైన్‍, అద్మియేనా అజాత్ను అధికార్‍ దిదోతె దేవ్నా మహిమపర్చు. ");
INSERT INTO vgr_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","యేసు ఎజ్గతూ నిఖీన్ జంకరమా, సుంకపు మెట్టుకనా బేసిన్‍ఛాతె మత్తయ కరి ఏక్జణనా దేఖిన్, మారకేడె ఆవ్కరి ఇన బోలమా యో వుట్టీన్ ఇనకేడె గయో. ");
INSERT INTO vgr_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","యేసు, మత్తయన ఘర్మా ధాన్నటేకె బేసిన్ రవ్వమా, హదేక్ సుంకరల్, పాపిమాబి కెత్రూకిజణూ ఆయిన్, యేసు ఇను‌ సిష్యుల్‍కనా బేసిన్‍ థొ. ");
INSERT INTO vgr_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","పరిసయ్యుల్ యో దేఖిన్, తుమార బోధకుడ్‍ సుంకరుల్‍తీ, పాప్ కరవాలతీ మలీన్ ష్యానటేకె ధాన్ ఖంకరస్ కరి ఇన సిష్యుల్నా పుఛ్చాయో. ");
INSERT INTO vgr_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","యో ఆవాతె హఃజీన్ “రోగ్వాలనా ఇవ్నటేకెస్ పన్కి, అష్యల్‍ఛాతె ఇవ్నాటేకె వైద్యుడ్‍ అవసరం కొయిని” కాహెనా ఇవ్నేతి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","తుమెజైన్ అష్యల్తి లేఖనాల్నా మాలంకరోకరి బోల్యొ. కతొ మే పాప్‍వాలన బులానాటేకె ఆయోగాని, నీతితిఛ్చాతె ఇవ్నా బులావనా కోఆయోని; ఇనటేకె గోరస్ మన హోనుతే పన్కి, బలిన మాంగుకోయిని, కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","తెదె బాప్తిస్మమ్‍ దేయ్తె యోహాన్‍ను సిష్యుల్‍ యేసుకనా ఆయిన్, పరిసయ్యుల్బీ, హమేబి మాములిగా పస్తురయ్యేస్, పన్కి తార సిష్యుల్ పస్తుతి కోర్హాయిని, అనా కారణం సాత్కరి యేసునా పుఛ్చావమా. ");
INSERT INTO vgr_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","యేసు బోల్యొ, య్హానొ నౌవ్రొ ఇనకేడె ర్హవయెత్రె ధన్‍ ఘేర్‍మా ఛాతె ఇవ్నె పస్తుతి ర్హాసెనా? ర్హాసెకొయిని. పన్కి, య్హానొ నౌవ్రొ ఇవ్నాకంతూ నిఖీన్ జావనూ ధన్ ఆవ్సే తెదె ఇవ్నె పస్తుతి ర్హాసె. ");
INSERT INTO vgr_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","కోన్బి ఫాటిగూతె జూను లుంగ్డన ఉఫ్పర్ నవూలుంగ్డు గాలీన్ సివ్సేనా, ఇమ్ కర్యూతొ అజు జర ఫాటిజాసె, ఇమ్మస్ కాహేతిమ్ యో అజు జర మోట్టు హుసె. ");
INSERT INTO vgr_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","బుజు జూను చాంబ్డను సంఛిమా ద్రాక్చాను రహ్ః కోనాఖని, నాఖ్యతొ తెదె చాంబ్డను సంఛిమా ఫాటీన్ ద్రాక్చా రహ్క్ హాఃరు పడీజాసె, చాంబ్డనుసంఛిమా ఖర్రాబ్ హూసె, కతొ నవూ ద్రాక్చాను రహ్‍ః నవీ చాంబ్డనుసంఛిమా నాక్యతెదె యోబి కర్రాబ్ హుసెకొయినితిమ్ ర్హాసెకరి బోల్యు. ");
INSERT INTO vgr_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","యో ఆవాతె హాఃరు బోల్తూరవ్వమా, హాదేక్ ఏక్ యూద మాలిక్‍ ఆయిన్, యో డుక్నేఫర్‍ బేసిన్‍ ఇన హఃలామ్ కరీన్ మారి ఛోరి హంకేస్ మరీగయి, తూ ఆయిన్ తారుహాత్ ఇనా ఉఫ్పర్ బేంద్యొతొ మారిఛోరి జివ్సె. ");
INSERT INTO vgr_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","యేసు ఉట్టీన్ ఇనకేడె గయో, ఇన సిష్యుల్బి ఇనకేడె గయా. ");
INSERT INTO vgr_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","త్యొ వహఃత్‍, హదేక్ భార వరహ్‍ఃక్తి ల్హొహిపడతె రోగ్వాలి ఏక్ బాయికొ థి. ");
INSERT INTO vgr_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","తెదె యో బాయికొ, మే యేసును లుంగ్డనా ఛీమితొ బైయిస్, మన అష్యల్ హుసేకరి ఇనూ యోస్ సోచిలీన్, యేసును లుంగ్డను ఛేడొనా ఛీమమా. ");
INSERT INTO vgr_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","యేసు పీటె ఫరీన్ యో బైయికోన దేఖిన్ ఛోరి, హిమ్మత్తి ర్హా తారు విష్వాస్‍ తున అష్యల్ కర్యు, తెదేస్‍ యో బాయికొ హుఃద్రిగి. ");
INSERT INTO vgr_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","యేసు యో మాలిక్ను ఘెర్మా గయోతెదె, ఎజ్గ ఢుంక్కా వజ్జాడవాలుబి గలబా కరుకరతే ఇవ్నా ర్హావనూ దేక్యొ. ");
INSERT INTO vgr_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","ఇవ్నెతి, ఆన్హాని ఛొగ్రి హుఃతీస్ పన్కి, మరికొయినీకరి ఇవ్నా బోలమా ఇవ్నే ఇనా ఛింగాయూ. ");
INSERT INTO vgr_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","తెదె జనభో హాఃరనా బోలిమోక్లిదీన్, యేసు మైహీజైయీన్, ఇను హాత్ ధరూస్కరా యో న్హాని చొగ్రి ఉట్టీ. ");
INSERT INTO vgr_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","ఆ హాఃబర్‍ హాఃరు దేఖ్‍ః అక్కు ప్హైలాయ్‍ గయూ. ");
INSERT INTO vgr_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","యేసు ఇజ్గతూ జంకరమా కాణు అద్మి బేజణ ఇనకేడె ఆయిన్, దావీద్నొ ఛియ్యో హామారఫర్ గోర్ కర్కరి ఛిక్రాణ్ మ్హేల్యు. ");
INSERT INTO vgr_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","యో ఘేర్మా గయో తెదె, ఇన పాసల్ యో కాణు అద్మి యేసుకన ఆయు, యేసు మే తుమ్నా అష్యల్ కరీస్‍కరి తుమె నమ్ము కరస్నా? కరి ఇవ్నా పూఛ్చావమా. తెదె ఇవ్నె, హో ప్రభు కరి ఇనేతి బోల్యా. ");
INSERT INTO vgr_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","తెదె యో ఇవ్నా ఢోళన ఛీమిన్ బోల్యొ “తుమారు నమ్మకంతీ తుమ్నా నయంహువదా” ఎత్రమ ఇవ్నా ఢోళా దేఖ్కావలగ్యూ. ");
INSERT INTO vgr_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","తెదె యేసు “ఆ కీనాబి నామాలం పడ్నుతిమ్‍ దేఖిలెవొ” కరి ఇవ్నా ధాంకైయిన్ బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","హుయితోబి ఇవ్నె జైన్ యో దేహ్ః అక్కు ఇను మహాన్‍ ప్హైలాయిగయూ. ");
INSERT INTO vgr_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","యేసుబీ ఇనా సిష్యుల్ జాతుర్హావమా, థోడుజణు ముక్కు భూత్‍ ధరిరాఖ్యుతె ఏక్ అద్మినా యేసుకన లీన్ ఆయూ. ");
INSERT INTO vgr_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","భూత్‍నా హాక్లీ హుయిజావదీన్‍ యో ముక్కు అద్మి బోలానిక్తనా అద్మిహాఃరు అష్యంహుయిగు, ఇస్రాయేల్మా ఆమ్ జోక్ను కెదేబి కోజరుగ్యుని కరి బోల్లిదా. ");
INSERT INTO vgr_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","హుయితొ పరిసయ్యుల్, ఆ భూత్‍నొ మాలిక్‍ వాలోతి సహకారంతీ ఆ భూతేవ్నా హకాలుకరస్ కరి బోల్యా. ");
INSERT INTO vgr_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","యేసు ఇవ్నా యూదుల్ను న్యావ్‍నుజొగొమా బుజు గాంమ్మా, దేహ్ఃమా, దేవ్నువాతె బోల్తొ, రాజ్యంను సువార్త ప్రచార్‍ కర్తొ, హర్యేక్‍ రకంమ్ను రోగ్నా స్వస్థత కర్తో సమస్తం నంగర్‍మ్మాబి గాంమ్మాబి ఫర్తో కర్తొ ర్హయో. ");
INSERT INTO vgr_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","జనాభొ కాపరికోయిన్తే మ్హేండనితరా థకిజైన్, చెద్రిజైన్ ర్హావను దేఖిన్ యేసు ఇవ్నాఫర్ గోర్‍కర్యొ. ");
INSERT INTO vgr_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","ఇన పాషల్తి ఇనా సిష్యుల్తీ “పంట అష్యల్తీ పిక్కాయు పన్కి, వాఢవాలు, జోఢవాలు, కామ్ కరవాలుస్ కంఛా. ");
INSERT INTO vgr_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","ఇనటేకె, ఖేథర్మా కామ్‍ కరవాలన బోలీమోకల్ కరి ప్రభువునా భీక్‍ మాంగను కరి ఇన సిష్యుల్తి బోల్యొ.” ");
INSERT INTO vgr_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","యేసు ఇన భారజణ సిష్యుల్నా బులాయిన్, దుష్మన్నా హక్లనటేకె హర్ రకంమ్నూ రోగఢిఫర్ వ్యాధుల్ ఫర్ అష్యల్ కరనటేకె ఇవ్నా హక్కు దిదొ. ");
INSERT INTO vgr_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","యో బ్హారజణనా అపొస్తలుకరి నామ్ కెహూకతో, అగాఢి పేతుర్‍కరి బొలైయిలెవ్వాలొ సీమోన్, ఇనొ భై హుయోతె అంద్రెయ; జెబెదాయినొ ఛియ్యోహుయోతె యాకోబ్, ఇనొ భై యోహాన్. ");
INSERT INTO vgr_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","ఫిలిప్పు, బర్తొలొమయి; తోమా, సుంకరిహుయోతె మత్తయ, అల్ఫయినొ ఛియ్యో యాకోబ్, తద్దయికరి బుజేక్ నామ్ లెబ్బయి. ");
INSERT INTO vgr_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","కనానీయుడ్‍హుయోతె సీమోన్, యేసునా ధరైయిదిదోతె ఇస్కరియోతు యూదా. ");
INSERT INTO vgr_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","యేసు యో భారజణనా బోలిమొకల్తొ, దేఖిన్ ఇవ్నా ఆజ్ఞాదిదోతె సలహాదిదొతె సాత్కతొ, తుమె అన్యజనుల్ను వాట్పర్ నొకొజవొ, సమరయుల్ను కెహూ హఃయర్‍మాహో నొకొజాసు పన్కి, ");
INSERT INTO vgr_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","నాష్‍హుంకరతె ఇస్రాయేల్ను జాత్ను మ్హేంఢవ్‍కనస్‍ జవొ. ");
INSERT INTO vgr_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","జాతాహుయిన్, స్వర్గంను రాజ్యం ఖందె ఆయ్రూస్‍కరి బోల్తహుయిన్ జవొ. ");
INSERT INTO vgr_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","రోగ్నా అష్యల్ కరొ, మరిగుతె ఇవ్నా ఉట్టాడొ కొహోడ్వాలవ్నా సుధ్దీకరొ, భూత్‍యేవ్నా హకాలొ, ఛుక్కెస్‍ మల్యూ తుమేబి ఛుక్కేస్ దెవొ. ");
INSERT INTO vgr_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","తుమారు సంఛిమా ఘేణుహొ, రూపుహొ, రాగిహొ, జావనాటేకె సంఛితీబి, బే కుడ్తాతోబి, చెప్లెతోబి, హాత్మను లాక్డుతోబి, నొకొలీజాసు. ");
INSERT INTO vgr_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","కామ్ కరవాలన ఇన కూలినా ఉప్పర్ ఇన హక్కు కొయిన్నా? ");
INSERT INTO vgr_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","బుజు తుమె కెహూ నంగర్మాతోబి, గాంమ్మతోబి గయాతెదె, ఇన్మా కోణ్ యోగ్యుల్కి మాలంకర్లీన్, ఇజ్గతూ నిఖిన్ జావతోడి ఇన ఘేర్మాస్ ర్హవ్వొ. ");
INSERT INTO vgr_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","యో ఘేర్మా గయాతెదె, యోఘేర్వాలన అఛ్చుహువదాకరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","యో ఘర్ సమాధానం పడ్నుకరి అర్హత ర్హైతొ తుమారు సమాధానం ఇవ్నఫర్ ర్హాసె. ");
INSERT INTO vgr_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","కోన్బి తుమ్న ఖందె నాకరీన్‍, తుమారు వాతేవ్నా నాఖంజుతొ, తుమె యో ఘేర్‍నాహో యోనంగర్‍నాహో, బెందిన్ జావనివహఃత్ తుమారు గోఢాను ధుమ్మునా జట్కీ దెవో. ");
INSERT INTO vgr_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","న్యావ్ను ధన్నె యో అద్మినుగతి నంగర్ను గతితీబి సొదొమా గొమొఱ్ఱా దేహ్ఃనుగతి ఇమ్‍ ర్హాసేకరి హాఃఛితి తుమారేతి బోలుకరూస్‍. ");
INSERT INTO vgr_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","హదేక్ హఢనా ఇచ్మా మ్హేండవ్ను చెల్కవ్నా బోలిమోక్లొతిమ్, మేబి తుమ్నా బోలిమోక్లుకరూస్, ఇనటేకె హాఃప్నితరా అఖ్కల్‍వాల హుయిన్ పర్యావ్నితరా కపటం కొయినితిమ్‍ ర్హవొ. ");
INSERT INTO vgr_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","అద్మియేన లీన్ జాగ్రుత్తి ర్హవొ; ఇవ్నె తుమ్నా న్యావ్‍కరతె సభమా ధర్యైయిదీన్, తుమ్నా ఠాణమా ధర్యాయ్‍దిసె, ఇవ్నా యూదుల్ను న్యావ్ను జొగొమా తుమ్నా కొల్డావ్‍తి మార్సే. ");
INSERT INTO vgr_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","రాజొకనబి, అన్యజనుల్నాకనబి అధికారియేకనా, లీన్ గయోతొ మారు సువార్తనాహాఃజె తుమ్నా లీన్‍ జాసె. ");
INSERT INTO vgr_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","ఇవ్నె తుమ్నా ధర్యైదిసె తెదె, కిమ్ వాతె బోల్ను? సాత్తోబి బోల్నుకరి చింతా నొకొపడొ; తుమె సాత్ బోల్నుకి తమ్నా యో వహఃత్మా మాలంపడ్సె. ");
INSERT INTO vgr_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","తుమారొ భాను ఆత్మ తుమారమా రైయిన్ వాతె బొల్సె పన్కి, వాతె బోలవాల తుమె కాహె. ");
INSERT INTO vgr_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","భైయ్యే భైయ్యేనస్, భా, ఛియ్యోనా మర్రాఖి దేవనటేకె దిసె; లడ్కా ఇన ఆయా, భా ఫర్ పాచుఫరీన్ ఇవ్నా మర్రాఖిదిసె. ");
INSERT INTO vgr_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","తుమె మారు నామ్‍మా నిమిత్తంతి హాఃరవ్నా హాతె ఖర్రాబ్ బొలైయిలీసు; ఆఖరితోడి కోన్‍ సహీంచస్కీ యో బఛ్చిజాసె. ");
INSERT INTO vgr_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","ఇవ్నె తుమ్న నంగర్మా హింసించూతెదె బుజేక్ హఃయర్మా మిలైయిలేవొ; దేవ్నొ ఛియ్యో ఇంమితరా తుమె ఇస్రాయేల్ నగరంమా సంచారం ర్హవొకరి మే తూమరేతి హాఃఛితి బోలుకరూస్‍. ");
INSERT INTO vgr_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","సిష్యుడ్ బోధకుడ్తి జాహాఃత్‍ కాహె; దాసుడ్‍ యజమానితీబి జాహాఃత్ కాహె. ");
INSERT INTO vgr_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","సిష్యుడ్ ఇను బోధకుడ్‍నితరాబి, దాసుడ్‍ ఇను యజమానితరా ర్హైతొ బైస్. ఘేర్ను యజమానినా “బయెల్జేబు” కరి నామ్ మ్హేలిన్ ర్హైతొ “యో ఘేర్వాలనా అజు కెత్రు ఖర్రాబ్‍ నామ్‍ బోల్సెకి కొయిన్నా.” ");
INSERT INTO vgr_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","ఇనటేకె తుమె ఇవ్నా దేఖిన్ నొకొఢర్సు, లపాఢిరాక్యుతె కెహూబి బ్హాధర్ పడ్సెకొయిననితిమ్‍ కోర్హాసెని, రహస్యంగాఛాతె కెహూబి మాలంకొయినితిమ్‍ కోర్హాసేని. ");
INSERT INTO vgr_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","మే తుమ్నా అంధారమా బోల్యొతె, తుమె ఉజాలమా బోలొ; కాన్మా తుమ్నా బోలిరాక్యొయో ఘర్నవుప్పర్‍ ప్రచార్‍కరొ. ");
INSERT INTO vgr_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","బుజు ఆత్మన మారకొయినితిమ్‍, ఆంగ్తాన్నా మారవాలన ఢరినొకొజాసు; పన్కి ఆత్మనబి, అంగ్తాన్నా నరకంమా నాక్చేతె దేవ్నా దేఖిన్‍ ఢరొ. ");
INSERT INTO vgr_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","బే పిచ్కిలి ఏక్‍ కాసునా ఎచైయిజాస్ కాహేనా, హుయితొ తార భాన మాలంకొయినితిమ్ ఏక్ పిచికీలిబి జమీన్ ఫర్ కోపడని. ");
INSERT INTO vgr_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","తుమారు మాథపర్ ఛాతె కేఖ్నుహాఃరు గణాయ్‍ రూస్‍. ");
INSERT INTO vgr_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","ఇనటేకె తుమె నొకొఢరొ. తుమె కెత్రూకి పిచిక్లియోతీబి స్రేష్టుల్‍ కాహెనా ");
INSERT INTO vgr_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","పన్కి, అద్మియేన ఇచ్మా మన ఒప్పిలెవ్వాలొ కోన్కి, స్వర్గంమా ఛాతె మారొ భాన హాఃమె మేబి ఇవ్నా ఒప్పిలీస్. ");
INSERT INTO vgr_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","అద్మియేమా కోన్‍ మన మాలంకోయిని కరి బోలాస్కి స్వర్గంమా ఛాతె మార భానహాఃమె మేబి మాలంకొయినికరి బోలిస్. ");
INSERT INTO vgr_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","మే జమీన్‍ఫర్ సమధానం దేవనటేకె ఆయోకరి నొకొర్హైజవొ, విబేధాలుటేకె పన్కి సమాధానంనా మోక్లనటేకె మే కోఆయోని. ");
INSERT INTO vgr_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","ఏక్ అద్మినబి ఛియ్యోనాబి ఇనూ భానా, ఛోరినాబి ఇని ఆయానా, ఒవ్నాబి ఇని హాఃకునా ఇచ్మా దుష్మన్‍ కరావనాటేకె ఆయో. ");
INSERT INTO vgr_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","ఏక్ అద్మిను ఘేర్‍వాలుస్ ఇన ఉఫ్పర్ వైరి హుసె. ");
INSERT INTO vgr_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","భానహో, ఆయానహో మారెతీబి జాహఃత్ ఫ్యార్ కరవాలు మన యోగ్యడ్‍కాహె ఛియ్యానహో, ఛోరినహో మారెతీబి జాహఃత్ ఫ్యార్ కరవాలు మన యోగ్యడ్‍కాహె. ");
INSERT INTO vgr_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","ఇను సిలువనా పల్లీన్ మారకేడె ఆవకొయింతె ఇను మన సిష్యుడు కాహె. ");
INSERT INTO vgr_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","ఇను జాన్న బఛ్చాయ్‍ లెవ్వాలు, ఇన గమైయ్‍లిసె పన్కి, మార నిమిత్తంతి ఇన జాన్న బేందనా హఠకొయినీకి ఇన బఛ్చాయ్‍ లీసె. ");
INSERT INTO vgr_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","తుమ్న ఖందెకరవాలు మన ఖందెకర్సె; మన ఖందెకరవాలూ మనస్ కాహెతిమ్ మన బోలిమోక్లొతె భా నాబి ఖందె కర్సె. ");
INSERT INTO vgr_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","ప్రవక్త కరి ప్రవక్తనా ఖందెకరవాలొ ప్రవక్తను ఫలంమల్సె; బుజు నీతి మంతూడ్కరీ నీతిమంతుడ్న ఖందె కర్లీదాతో నీతీమంతుడ్ను ఫలంమల్సె. ");
INSERT INTO vgr_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","బుజూ సిష్యుడ్కరి కోణ్ ఆ అడ్డాణి లడ్కామా ఏక్జననా ఏక్ గ్లాహ్క్ పాని పీయ్యాన దీదూతో యో ఇను ఫాయిదొ గమైలీసె కొయినికరి మే హాఃఛితి తుమ్నా బోలుకరూస్. ");
INSERT INTO vgr_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","యేసు ఇను బ్హారఅద్మి సందేషంనా లావాలు ఆజ్ఞదీన్‍ బోలను పాసల్తి, ఇను పాసల్తి ఇవ్నా నంగర్మా బోధించనాటేకె గయో. ");
INSERT INTO vgr_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","క్రీస్తు కరూకరతె కార్యాయల్నాటెకె యోహాన్ ఠాణమా హంమ్జీన్, ఆవ్సెతె ఇనే తూస్నా, హమే అజేక్నాటేకె దేక్తారయ్యానా? ");
INSERT INTO vgr_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","కరి ఇన “పూఛ్చావనాటేకె” ఇన సిష్యుల్నా బోలిమొక్లొ. ");
INSERT INTO vgr_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","అనటేకే యేసు ఇవ్నా దేఖిన్ తుమె జైన్, హంజుతె ఇనాబి దేక్యూతె ఇన యోహాన్‍తీ బోలొ. ");
INSERT INTO vgr_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","కాణు అద్మిను ఢోళా దెఖ్కాంకరస్, లంగ్డు అద్మి ఛాలుకరస్, కోడ్నుఅద్మి అషల్ హుంక్రస్, మరీగుతె అద్మి జీవ్తూర్హంకరస్‍, గరీబ్నా సువర్త ప్రచార్‍ హుంకరస్‍. ");
INSERT INTO vgr_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","బుజు మారు వాతెఫర్‍ అనుమానం పడకొయింతెవాలు ధన్యుడ్ కరి జవాబ్ దిదొ. ");
INSERT INTO vgr_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","ఇవ్నె జంకరమా యేసు యోహాన్నా లీన్ అద్మియేన అంనితరా బోల్యొ, తుమె సాత్ దేఖనటేకె జాడిమా గయా? వ్యారొనా హలుకరతె గాహ్ఃనా దేఖనా గయానా? ");
INSERT INTO vgr_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","పార్‍ సాత్ దేఖాన గయాతా మోల్ను లుంగ్డా పేరక్యూతే అద్మినా? హదేక్ మోల్ను లుంగ్డా పేరవాలు రాజొగ్రుహాంమ ర్హాస్ కాహేనా? ");
INSERT INTO vgr_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","బుజూ సాత్తోబి దేహాఃనటేకె గయా? ప్రవక్తనా? హో పన్కీ ప్రవక్తతీబి మోటోకరి తుమారేతి బోలుకురూస్. ");
INSERT INTO vgr_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","హదేక్ మే మార దూతనా తారేహూః అగాడి బోలిమోక్లుకరూస్ యో తారా వాట్నా హూఃదు కర్షే, కరి ఇనా గురించి లిఖ్యారూస్కి యోస్ యోహాన్. ");
INSERT INTO vgr_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","రాంఢె ఫైదాకరియేతె హాఃరవ్‍మా బాప్తిస్మమ్‍ దెవ్వాలొ యోహాన్‍కంతిబి మహాన్‍వాలొ హుసె. ");
INSERT INTO vgr_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","బాప్తిస్మమ్‍ దెవ్వాలొ యోహాన్ను ధన్తూధరీర్‍ హంకేలగు స్వర్గంను రాజ్యంమా బలత్కారంతి ధరాయ్‍జంకరాస్‍, బలత్కారంతి ఇనా కోండిలెంకరస్‍. ");
INSERT INTO vgr_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","యోహాన్ను ధన్తోడి ప్రవక్తల్‍ హాఃరుజనూబి, ప్రచార్‍ కర్తూహుయీన్ ఆయు. మోషే ధర్మషాస్ర్తరంబి ప్రచార్‍ కర్తూహుయీన్ ఆయు. ");
INSERT INTO vgr_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","ఆ హాఃబర్‍ అంగీకరించన తుమ్నా మనస్సు ర్హైతో ఆవ్సేతె ఏలీయా, ఆస్‍. ");
INSERT INTO vgr_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","హఃజనాటేకె కాణ్‍ రవ్వాలు ఖంచె. ");
INSERT INTO vgr_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","ఆ పిఢియేను అద్మినా కినేతి పోల్చును? బజార్ను గల్లిమా బేసీన్‍ ర్హహీన్‍ ");
INSERT INTO vgr_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","హాఃమె పుంగితి గీద్‍ బోలుకరియేస్‍ పన్కి, తుమె ఖేలవాలహుయిన్‍; హమె రొంకిరియేస్‍ కొయిని పన్కి తుమె రొయ్యాకొయిని హాఃరు దేక్యతొ అడ్డాణి లఢ్కానితరా ఏక్తీ ఏక్త్ బొల్లేవాలంతరా ఛా. ");
INSERT INTO vgr_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","యోహాన్ ఖాద్యోకొయిని తిమ్‍ పీద్టొ కొయినితిమ్‍ ర్హావమా భూత్‍ ధర్యుహుయు అద్మికరి ఇవ్నె బోలుకరాస్‍. ");
INSERT INTO vgr_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","అద్మినో ఛియ్యో ఖాతొహుయీన్, పీతొహుయిన్, ఆయొ. ఇనటేకె హదేక్ ఆ తిండిబోత్బి, పియ్యావాలుబి, ఖవ్వాలనబి, సుంకరూల్నబి పాప్ కరవలానొ దోస్థకరి ఇవ్నె బోలుకరాస్‍. పన్కి అఖ్కల్నా అక్కల్కరి ఇను కామ్నలీన్ న్యావ్‍ పోంద్సెకరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","పాసల్తి కెహూ నంగర్మా యేసు హర్యేక్ మహత్కార్యంనా కర్యోకి థోడు యో నంగర్‍వాలు దిల్ నాబద్లావమా, ఇనటేకె యేసు ఇవ్నా అమ్‍ గుర్కావనిక్లోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","అయ్యో కొరజీనా నంగర్‍ అయ్యో బేత్సయిదా నంగర్ మే తూమారమా కార్యొతె అద్భుతంనా తూర్, సీదోన్ నంగర్మా కర్యొహోత్తొ ఇవ్నె కెదేస్కి చైయినుపట్టొ బాంధిలీన్, రాక్నా లోతిలీన్ దిల్ బాద్లాయిలీన్ ర్హైయ్యాహోత్ని. ");
INSERT INTO vgr_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","పన్కి, మే బోలుకరతె సాత్కతో న్యావ్‍ను ధన్నె ధన్నే తూర్‍సీదోన్ నంగర్తీబీ భరీంచ్యకోయిన్తే స్థితిమా ర్హాసెకొయినీ. ");
INSERT INTO vgr_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","బుజు, ఓ కపెర్నహూమ్ నంగర్‍వలా తూ ఆకాష్తీబీ హెచ్చించి బడీష్నా? తూ పాతాళ లోకంమా ఉత్రీన్‍ జైస్‍, తూమారమా కార్యూతే అద్భుతంనా సోదొమనంగర్మా కర్యొహోత్తొ, యో హాంకెలగు ఉబ్రీన్ ర్హైయిహోత్. ");
INSERT INTO vgr_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","పన్కి మే తుమ్నా బోలుకరతె సాత్కతొ న్యావ్ను ధన్నె సొదొమా నంగర్తీబి తుమె హఃలావ కొయింతే స్థితిమా ర్హాషు. ");
INSERT INTO vgr_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","యో సమయంమా యేసు బుజూ ఆమ్నితరా బోల్యొ భా, ఆకాష్‍నా, ధర్తినాబీ ప్రభూ, తూ జ్ఞాన్‍ వాలనబీ అక్కల్‍వాలనబి ఆ హాఃబర్నా లపాఢిరాఖీన్‍ అన పడా వాలనా బయల్పర్చోకరి తున స్తుతించుకరూస్‍. ");
INSERT INTO vgr_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","హోలా భా, తూ ఆమ్కర్నుకరి తార నజర్మా అనుకూలం హుయీన్‍ ఛా. ");
INSERT INTO vgr_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","మారో భా మన హాఃరు దీరాక్యోస్, భాన తప్ప మార గురించి కీనాబి మాలంకొయిని; ఛియ్యో కాహెతిమ్ కోన్బి ఛియ్యో కినాబి ఇనా మాలంకరావ్నుకరి భాన గురించీ బోలునూస్ కరి ఉద్దేష్యంతి మే ఏనిలిదోతే ఇవ్నా తప్ప, భాన గురించీ మాలంకొయినీ. ");
INSERT INTO vgr_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","ప్రయాసా పఢీన్ భోజొనా పాడుకరతె సమస్తాజనూల్‍ మే తుమ్నా ఆరామ్నా దీస్కరి బోల్యొ. ఆత్మల్నా విస్రాంతి కలగ్సె. ");
INSERT INTO vgr_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","మే సాత్వీకుబి హల్కుదిల్వాలొ హుయ్రోస్‍. అనటేకే తుమారఫర్‍ మారు కాఢినా పల్లీన్‍ సిఖొ. తెదె జాన్నా ఆరామ్‍ మల్చే. ");
INSERT INTO vgr_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","కింకతొ మారు కాఢి హుల్కుబి, మారు కాఢి ఢోవను సులభంమస్. మే దిదోతె భోజొ హాల్కుతి ఛా. ");
INSERT INTO vgr_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","యో ధన్మా యేసు ఆరమ్ కారనుధన్నే ఖేథర్మాకరి జంకరమా ఇన సిష్యుల్నా భుక్ లాగమ మొక్కజొన్నన బుట్టు తోఢిన్ ఖాధ్య. ");
INSERT INTO vgr_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","పరిసయ్యుల్ ఆ దేఖిన్ హదేక్, ఆరామ్ కరనధన్నె కరకొయింతె కామ్ కరూకరస్కరి యేసున బోలమా. ");
INSERT INTO vgr_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","యేసు ఇవ్నేతి అమ్ బోల్యొ, దావీద్‍బి ఇనకేడె ఛాతె ఇవ్నా భుక్ లాగమా ఇను షాత్ కర్యతె ఇన గురించి తుమె పడ్యా కొయిన్నా? ");
INSERT INTO vgr_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","యో దేవ్ను మందిరంమా జైన్, యోబి ఇనకేడె ఛాతె ఇవ్నేబి నాఖానుతే సముఖంనూ రోటా ఖాద్యా. ");
INSERT INTO vgr_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","బుజు యాజకుల్ ఆరమ్ కరను ధన్నె దేవ్ను ఆలయంమా జైన్, ఆరమ్ కరను ధన్నె అతిక్రమించాతోబి నిర్దోసుల్‍హుయిన్ ఛాకరి తుమె ధర్మషాస్ర్తంమా పడ్యాకొయిన్నా? ");
INSERT INTO vgr_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","దేవ్ను ఆలయంతీబి మహాన్‍వాలొ యో అజ్గ ఛాకరి తుమారేతి బోలుకురూస్. ");
INSERT INTO vgr_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","బుజ గోర్నాస్ కోరిలెంక్రూస్ పన్కి బలినా మే కొకోరూని, కరి వాక్యభాగమస్‍ తుమ్నా మాలంరైయితొ నిర్దోసినబి దోసినా న్యావ్‍ కోకర్యాహోత్ని. ");
INSERT INTO vgr_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","అద్మినో ఛియ్యో ఆరామ్ను ధన్నే ప్రభూ హుయిన్ ఛాకరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","యో ఇజ్గతూ నికిజైన్ ఇవ్నా యూదుల్ను న్యానుజొగొ గయోతెదె ఎజ్గ ఏక్ హాత్ హుఃకైయి గయూతె అద్మితూ ");
INSERT INTO vgr_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","ఇవ్నె ఇనఫర్ జూటి వాత్‍ఫర్‍ పహ్కావును కరి సోచిలీన్‍ అమ్ బోల్యు, ఆరమ్ కరతెధన్నే స్వస్థతకరను న్యాయంన్నా? కరి ఇన పుచ్చాయా. ");
INSERT INTO vgr_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","ఇనటేకె యేసు తుమారమా కెహూ ఏక్ అద్మినా హుయుతోబి మ్హేండాను చెల్కు ర్హైయితొ, ఆరామ్‍నూ ధన్నే యో ఖాడమా పడిగూ ఇన ధరీన్ బ్హాధర్ కోకాడ్సున్నా? ");
INSERT INTO vgr_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","మ్హేండనాతబి అద్మిస్‍నా కెత్రూకి విలువు ఛా కాహెనా ఇనటేకె ఆరామ్ కరనధన్నే మేల్‍కరను ధర్మమాస్, కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","యేసు యో అద్మితి తారుహాత్ హఃడక్ కరి బోల్యొ. యోహాత్ హూఃదు కరమా ఇన బెంమ్మాను హాత్నుతరా అష్యల్ హుయు. ");
INSERT INTO vgr_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","తెదేస్ పరిసయ్యుల్ బాదర్ జైన యేసున కింతోబి మార్నుకరి ఇనా విరోధంతీ బారెమా సోచలగ్యు. ");
INSERT INTO vgr_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","యేసు యో సంగతి హాఃరు మాలంకర్లీన్ ఇజ్గాతు ఛలిగయో, ఘను అద్మి ఇన కేడెజావమా. ");
INSERT INTO vgr_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","యేసు ఇవ్నా హాఃర్వన అష్యల్ కరీన్, మన ఆవాత్ కినాబీ నొకొబొల్సూకరి ఆజ్ఞదిదొ. ");
INSERT INTO vgr_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","ప్రవక్త హుయోతే యెషయా బారేమా దేవ్ బోల్యొతె ఆ వాక్యం హాఃచిహువనటేకె ఆమ్నీతర జరిగ్యూ. ");
INSERT INTO vgr_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","యోసాత్కతొ, హదేక్‍ ఆ మారొ సేవకుడ్ అన మే చూణిరాక్యోస్‍, అనే మన కెత్రేకి లాఢ్‍ వాలొ హుయ్రోస్‍. అనఫర్ మార ఆత్మనా రాఖిస్‍. ఆ అన్యుజనుల్నా న్యాయంనా ప్రచార్‍ కర్సె. ");
INSERT INTO vgr_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","అనే లఢైయె కోకరని, ఛిక్రాన్ కోమ్హేలని, గల్లియేమా అను ఆవాజ్‍‍ కినాబి హఃమ్జావ్సె కొయిని. ");
INSERT INTO vgr_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","న్యాయం హువతోడి నలిగూతె రెల్లునా అనె తోడ్సెకొయిని, ఉజైయి జంకరతె దివ్వొనాబి యో ఉజావ్సెకొయిని. ");
INSERT INTO vgr_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","అన నామ్‍ఫర్ అన్యుజణుల్‍ హాఃరు నిరీక్చణ కల్గి ర్హాసె. ");
INSERT INTO vgr_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","తెదె భూత్‍ ధర్యకూతె, కాణొడోళవాలుబి, ముక్కు హుయోతె ఏక్జనొ యేసుకనా లీన్ ఆయా. ");
INSERT INTO vgr_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","ఇనటేకె యో అద్మి హాఃరు అష్యంహుయీన్‍ ఆ దావీద్‍నొ ఛియ్యో కాహెనా, కరి బోల్లెంకర్తు థూ. ");
INSERT INTO vgr_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","పరిసయ్యుల్ యోవాత్ ఖంజీన్ అనే భూత్‍నొ మాలిక్‍ హుయోతె బయెల్జేబుల్‍ బారెమాస్‍ ఆ భూత్‍యేవ్నా హాకాలుకరస్ పన్కి బుజేక్ను జణనూ కాహే. ");
INSERT INTO vgr_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","యేసు ఇవ్ను సోచుతె ఇనా గ్రహించిన్‍ ఇవ్నెతె అమ్‍ బోల్యొ, కేహూ రాజ్యంతోబి, ఇనూ యోస్‍ అలాదు హుయుగుతొ హాఃరాబ్‍ హుయుజాస్‍. ఇనూ యోస్‍ అలాదు హుయుగుతొ కెహు నంగర్‍బి కెహు ఘేర్‍బి హుబర్సే కొయిని. ");
INSERT INTO vgr_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","సైతన్ సైతాన్‍ హాకల్యొతొ యో అలాదు హుయిజాసె, తెదె ఇన రాజ్యం కిమ్ తోబీ వుభార్ సే? ");
INSERT INTO vgr_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","మే బయెల్జేబు బారెమా భూత్‍‍నేవన హకాలుకురుస్తో తుమార ఛియ్యో కినవల్లా హకాలుకరస్? తుమె బోలుకరతే జూటీకరి తుమార అద్మీస్ రుజూవు కరూకరస్. ");
INSERT INTO vgr_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","బయెల్జేబ్ కాహె దేవ్ను ఆత్మానహాఃజె హుయుతొ దేవ్నవలనా భూత్‍యేవ్నా హకాలుకర్తో హసేతొ దేవ్ను రాజ్యం తుమారకనా ఆయ్రూస్‍. ");
INSERT INTO vgr_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","ఏక్జను ఏత్రేస్ కాహేతీమ్ అగాడి కువ్వత్‍వాలన బంధించకొయింతె తెదె కింనితరా యోకువ్వత్‍ వాలన ఘేర్‍ జైన్ ఇను హాఃమాన్ లపాఢిలిసె? ఇంనితరా భన్నాకి దిదూతోస్ ఇనూ ఘర్‍ లపాఢిజైయ్‍. ");
INSERT INTO vgr_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","మారేతి రైయికొయింతె అద్మి మన దుష్మన్‍ నీతర ర్హాసె. మారేతి మలిజైయిన్ నార్హవ్వాలు చెదరిజాసె. ");
INSERT INTO vgr_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","ఇనటేకె మే తుమారేతి బోలుకరూతె సాత్కతొ అద్మియెకర్యూతె పాప్‍ హాఃరు దేవ్నదూషణనా దేవ్ క్చమాకర్సె పన్కి, పవిత్రాత్మనా విషయంమా దూషించుతొ ఇవ్నా క్చమించెకొయిని. ");
INSERT INTO vgr_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","అద్మినో ఛియ్యోనా విరూద్ధంతి వాతె బోలవాలనా దేవ్ను క్చమాపనా మల్సె, పన్కి పవిత్రాత్మనా విరూధ్దంతి వాతె బోలవాలనా ఆ ములక్మాతోబి ఆవ్సెతె పిఢిమాతోబి క్చమాపనా కోమల్సెని. ");
INSERT INTO vgr_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","జాఢు అష్యల్ ర్హైతొ ఇను పండబీ అష్యల్కరి ఎంచొ న్హైతొ, ఝాడు ఖర్రాబ్‍ ర్హైతో ఇను ఫలంబి ఖర్రాబ్కరి ఎంచొ. ఝాడు ఇను పండాటేకె మాలంకరజాయ్. ");
INSERT INTO vgr_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","హాఃప్‍నా లడ్కా, తుమె ఖర్రాబ్వాల హుయీన్‍, కిమ్ అష్యల్ వాతె బోలాతిం బోల్సు? దిల్మా షాత్ఛాకి యోస్ బాఖమతూ వాతెబోల్సె కాహేనా. ");
INSERT INTO vgr_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","అష్యల్ అద్మిమా అష్యలాస్ ర్హాస్, ఇనటేకె ఇన్మతూ అష్యలాస్ ఆభాదర్నికస్‍. దుస్మన్‍ మ ఖరాబ్ రాస్ కరి ఇన మైయితీ ఖరాబస్ భాదర్ నికాస్. ");
INSERT INTO vgr_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","మే తుమారేతి బోలుకురుతె సాత్కతొ అద్మియే బోలాతె హర్యేక్‍ ఖర్రాబ్ వాతేవ్నా లీన్ న్వావ్నా ధన్నె లెక్క బొల్ను పడ్సె. ");
INSERT INTO vgr_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","తారు వాతేవన లీనస్ నీతిమంతుడ్ కరి న్వావ్‍ లీసు, తారు వాతేవ్నా లీన్‍ అపరాధికరి న్యావ్‍ లీసు. ");
INSERT INTO vgr_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","తెదె షాస్ర్తుల్మాబి పరిసయ్యుల్మా థోడుజణు “బోధకుడ్‍ తరా బంన్తూ ఏక్‍ హాఃనద్ దేక్ను” కరి హమే ఛియ్యో, కరి ఇనేతి బోల్యా. ");
INSERT INTO vgr_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","యేసు బోల్యొ వ్యభిచారుల్ హుయాతె గలీజ్ పిఢిను అద్మియే కెహూ, అద్భుతంనా మాంగుకరాస్, ప్రవక్త హుయోతె యోననా లీన్, హాఃనద్నా పన్కి బుజూ కెహుబీ హాఃనద్ ఇవ్నా కోఅనుగ్రహించూని. ");
INSERT INTO vgr_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","యోనా కిమ్ తీన్రాత్, తీన్‍ధన్ మోటు మాస్లాన పేట్మా ర్హయోకి ఇమ్మస్ అద్మినొ ఛియ్యో తీన్‍రాత్, తీన్‍ధన్ భూగర్భంమా ర్హాసె. ");
INSERT INTO vgr_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","నీనెవె నంగర్‍ వాలు యోననూ ప్రకటననా హఃమ్జీన్ దిల్ బద్లాయిలీదు. ఇనటేకె న్యావ్‍ తీర్చన వహాఃత్మా, నీనెవెవాలు ఆ ఫిడీను ఇవ్నఫర్ ఉబ్రీన్ ఇన నేరంనా నాక్చె. హదేక్ యోనతీబి మోటొజణొ అజ్గ ఛా. ");
INSERT INTO vgr_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","దక్షీణ్‍ దేహ్ఃమాఛాతె షీబా రాణి సొలోమోను జ్ఞానంనా హఃమ్జనాటేకె ఘను దూర్తి ఆయి, ఇనటేకె న్యావ్‍ బోలన ధన్నే యో బాయికో ఆ పిఢీను అద్మిహుః మలీన్ ఉబ్రీన్‍ ఆ పిఢివాలు నేరస్థుల్ కరి బోల్సె, పన్కి హాంకె సొలొమోన్‍తీబి మోటొ అద్మి అజ్గ ఛా. ");
INSERT INTO vgr_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","దుష్టాత్మా ధరిరాక్యుతె ఏక్ అద్మిమతూ నికిజావదీన్ బ్హాదర్ నికీగుతె సైతాన్ ఆరామ్ కరనటేకె పానికొయింతె జొగొమా పర్తూ ర్హంకరా, పన్కి ఇన ఆరామ్‍కరన కోమలని. ");
INSERT INTO vgr_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","ఇన ఆరామ్‍ నామలమా, మే బెందీన్ ఆయోతె మార ఘేర్‍కన జైయిస్‍కరి సోచిలీన్‍ ఆయిన్‍, యో ఘర్మా కోన్బి కొయిననితిమ్‍ ఇన ఝాడీన్ హఃద్రిరాక్యుతె దేఖిన్‍, జైయిన్‍ ఇనేతీబి బుుజూ ఖర్రాబ్‍హుయ్తె హాఃత్‍ భూత్‍నా కేడెలీన్‍ ఆవస్‍ ఇవ్నె ఇన్మా పేషిన్ ఎజ్గాస్‍‍ జీవ్ను జీవ్సె. ");
INSERT INTO vgr_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","అనటేకే యో అద్మిను ఆఖరీనుస్తితి అగాడిను స్థితితీబి ఖర్రాబ్‍హుసె. ఇమ్మస్‍ ఆ దుష్టపీఢివాలనా సంభవించెకరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","బుజబి యేసు అద్మియేమా వాతెబోల్తొ ర్హానమా హదేక్ యేసుని ఆయాబి ఇనొ భైయ్యేబి ఇనేతి వాతె బోల్నుకరి బ్హాధర్ ఉబ్రిన్‍ ఛా. ");
INSERT INTO vgr_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","తెదె ఏక్జణు యేసుతి, హదేక్‍ తారి ఆయాబి, తారొ భైయ్యే తారేతి వాతె బోల్నుకరి బ్హాధర్ ఉబ్రీన్‍ ఛాకరి ఇనేతి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","అనటేకే ఇనేతి ఆ హాఃబర్ బోల్యొతె ఇనా దేఖిన్‍, కోణ్ మారి ఆయా? కోణ్ మార భైయ్యే? కరి బోలిన్‍ ");
INSERT INTO vgr_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","ఇను సిష్యుల్‍ బాజు హాత్‍ వతాలీన్‍, హదేక్ మార ఆయాబి, మార భైయ్యే, భేన్‍ ");
INSERT INTO vgr_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","స్వర్గంమా ఛాతె మారో భాన మర్జీతి కరవాలోస్‍, మారా భైయ్యే, మారి భేనె, మారి ఆయా, కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","యోధన్నె యేసు ఘేర్తి నిఖీన్ ధర్యావ్నా కనారె బేసిన్ థొ. ");
INSERT INTO vgr_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","ఘణు అద్మిహాఃరు ఎక్కాస్‍ధమ్ కేడెమలీన్ ఆవమా యేసు డోంగా ఛడీన్‍ బేసిగొ యోఅద్మిహాఃరు కనారీవుబ్రీన్ ర్హావమా. ");
INSERT INTO vgr_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","యేసు ఇవ్నా బ్హణెదేఖిన్ ఘణు సంగతుల్ ఇవ్నా ఉపమానంనీతరా బోలను ఛా కింకతొ, హదేక్ బింజోలా పికావాలు పికావనటేకె గయూ. ");
INSERT INTO vgr_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","యో బింజోల ఛిడ్కని వహఃత్ థోడుబింజోలు వాట్నాసేడే పడ్యు, ఉఫర్ ఉడతే జిన్వార్‍ ఆయిన్ ఖైయినాకిదేస్. ");
INSERT INTO vgr_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","థోడు బింజోలు పత్రావ్ని జొగోమా పడ్యు మాటి ఘణు నార్హావమా యోబింజోలు పుట్యు. ");
INSERT INTO vgr_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","పన్కి ధన్నూ నికతే చంద్రమా ఆవమా ఇను టడ్కోను అంచ్మా ఝడ్‍, బలీన్ హుఃఖైయి గయూ. ");
INSERT INTO vgr_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","థోడు బింజోలు కాఠొనా డాగ్మా పడ్యు కాఠన ఝాడు వదీన్ ఇన దాబినాఖిదేస్. ");
INSERT INTO vgr_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","పన్కి థోడు బింజోలు అష్యల్ జమీన్పర్ పడీన్, ఏక్‍ డోఢిక్‍ భాగ్, ఏక్‍ తీనిహ్‍ః భాగ్‍, ఏక్‍ ఖొః భాగ్‍నితరా ఫలించె. ");
INSERT INTO vgr_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","కాణ్‍ రవ్వాలు హంజ్చెకరి బోల్యొ. భర్తికర్యూ. ");
INSERT INTO vgr_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","పాసల్తి సిష్యుల్ ఆయిన్ తు ఉపమానంనితరా ఇవ్నా వాతె బోలుకరతె సే? కరి పుఛ్చావమా. ");
INSERT INTO vgr_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","ఇవ్నెతి అమ్ బోల్యొ స్వర్గంను రాజ్యం రహస్యాల్ మాలంకరను జ్ఞానంనా తుమ్నా మలీరూస్ పన్కి, ఇవ్నా అనుగ్రహీంచుకొయిని. ");
INSERT INTO vgr_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","కల్గితె ఇవ్నస్‍ దెవ్వావ్సె, ఇవ్నా జాహఃత్‍ మల్సె కొయింతే ఇవ్నకనా ఛాతె హాఃరుబి ఇవ్నకంతూ కన్నాకిదిసె. బుజూ ఇవ్నే హఃమ్జీన్‍బి హఃమ్జకొయినీతిమ్‍ దేఖిన్‍బీ దేఖ కొయినీతిమ్‍ గ్రహించకొయినితిమ్‍ ఛా. ");
INSERT INTO vgr_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","అనహాఃజేస్ మే ఉపమానంనితరా బోధించుకరూస్‍. దేఖ్యొ పన్కి దేఖకొయినితింమ్‍ ర్హాస్‍. ");
INSERT INTO vgr_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","యెషయా బోల్యొతె వాత్ అవ్నబారెమా నెరవేరుకరాస్‍. ఇవ్ను కాణ్‍తి హఃమ్జీన్‍బి హఃమ్జకొయిని, ఇవ్నె ఇవ్ను ఢోళనా మూఛిరాక్యస్‍. దిల్‍ బద్లాయ్‍ లీన్‍ మార బారెమా స్వస్థత హువకొయిని తిమ్‍ ఇవ్ను దిల్ ఘట్ హుయిగు, ");
INSERT INTO vgr_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","ఇనటేకె ఇవ్నె హంజన హుయుతో హఃమ్‍జ్సే పన్కి అర్థం కోకరని, దేఖనా హుయుతో దేక్చె పన్కి, కెత్రేబి మాలంకరకొయిని. ");
INSERT INTO vgr_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","ఇనటేకేస్ దేఖుకరతే తుమారు డోళా కెత్రూకి ధన్యంహుయు, హంజుకరతె తుమారు కాణ్‍ కెత్రూకి ధన్యంహుయు. ");
INSERT INTO vgr_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","పన్కి, కెత్రూకి ప్రవక్తల్, నీతిమంతుల్ తుమె దేఖుకరతె ఇన దేక్నకరి సోచిన్‍ దేఖ్యాకొయిని, తుమె హంజతె ఇనా హంజ్నూకరి సోచీన్‍ హంజ్యకొయినీకరి తుమారితీతి హాఃఛితీ బోలుకరూస్. ");
INSERT INTO vgr_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","ఖేథర్మా బింజోలా చిడ్కనవాలనూటేకె ఏక్ ఉపమానం ఇను హఃమ్జొ. ");
INSERT INTO vgr_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","కోన్బి దేవ్ను రాజ్యంనూవాతె హాఃజిన్‍బి హఃజకొయినీతిం ర్హావమా దుష్మన్‍ ఆయిన్ ఇన దిల్మా హఃజుహుయు వాక్యంనా పల్లిజాసె వాట్నా సేడె పడ్యూతె బింజోలాను జోక్ను. ");
INSERT INTO vgr_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","పత్రన జోగోపర్ పడ్యుయుతే బింజోలాన జోడ్ను సందేషం హఃజీన్ ఎగ్గీస్ ఖుషితి ఇనా ఒప్పిలీసె. ");
INSERT INTO vgr_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","హుయుతోబి ఇన్మా జఢే జమీన్నా నాలగ్గమా థోడధన్ ర్హాసె. పన్కి వాక్యంనటేకె మిన్హత్‍, హింసల్ ఆయుతో అభ్యంతరం హుసె. ");
INSERT INTO vgr_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","కాఠొను ఢాగ్మా పడితే బించోలానితర అద్మియే వాక్యమ్నాహఃజవాళోస్ పన్కి, ఆ ములక్‍ను హాఃజె, రప్యాను, ఆహ్క్ ఇనా వాక్యంనా బఢదేకొయినీ, ఇనటెకె యోదేవ్నా బందేస్. ");
INSERT INTO vgr_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","అనటేకే అష్యల్ జొగొమా పఢ్యుతే బింజోలను జోక్నూ అద్మియే హాఃరూ వాక్మంమ్నా క్హాంజీన్ అర్థమ్ కర్లిసె. ఇంమ్ను అద్మి జీతిన్ ఏక్జనొ ఖోః భాగ్‍నితరా, ఏక్జనొ తీనిక్‍ భాగ్‍నితరా బుజేక్జనో డొఢీహాంతరా బడ్చె. ");
INSERT INTO vgr_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","యో బుజేక్ ఉపమానంనా ఇవ్నేతిబోల్యొ. సాత్కతో స్వర్గంనురాజ్యం ఏక్ బింజోలా ఇనుఖేతర్మా అష్యల్ బింజోలా నాక్యొతె ఇంమ్ను జోక్ను. ");
INSERT INTO vgr_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","ఏక్‍ రాతె, అద్మిహాఃరు ఖుఃతూర్హావనూ వహాఃత్మా వైరి ఆయిన్ యో ఘౌవును ఖేథర్మా గురుకుల్ను బింజొలాన చిడ్కినాకిదేస్. ");
INSERT INTO vgr_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","ఘౌ పుట్టీన్ వధ్యూ తెదె యో న్హాను గాహ్క్ మెక్కల్‍బి వధ్యూతే దేఖ్కాయూ. ");
INSERT INTO vgr_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","యో ఖేథర్నొ మాలీక్ను దాసుడ్‍ జైన్ మాలిక్‍ తూ తార ఖేథర్మా అష్యల్ గౌనా బింజోలా నాక్యోతోనొ బుజూ గురుకుల్ను జాఢు కిమ్ పుట్యు కరి పుఛ్చాయో. ");
INSERT INTO vgr_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","ఆ హాఃరు వైరి కర్యుతె కామ్ కరి బోలమా యో దాసుడ్‍, హామెజైన్ ఇన వుక్డి నాఖిదేవనూ తున ఇష్టమాస్నా? కరి ఇన పుఛ్చాయ్యో. ");
INSERT INTO vgr_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","ఇనటేకె యో ఇమ్ నొకొకరో గురుకుల్నా వుఖడనీ వహాఃత్, ఘౌను జఢేబి వుక్డాయ్‍ జాసె. ");
INSERT INTO vgr_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","ఘౌ వాఢను ధన్‍తోడి, బేన వధాదేవొ వాఢను ధన్మా గురుకుల్నా అలాదు కుప్పొకరీన్ ఇన బల్లాకి దేవనటేకె ఇన కాఠనితరా భాందొ బుజు ఘౌనా అలాదు కరీన్ బాణమా నాఖొ. ఇవ్నెతి బోలీస్‍కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","యేసు బుజేక్ ఉపమనంబి సిష్యుల్తి బోల్యొ, స్యర్గంను రాజ్యం ఏక్జనొ ఇను ఖేథర్మా నాక్యూతె రాయిను బింజోలాను జోక్ను. ");
INSERT INTO vgr_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","యో బింజోలన దేఖాన న్హానుసు, పన్కి యో మొల్కా ఉట్టీన్ మోటు వధ్యుతో ఖావను చట్టిను రాచునూ జాఢ అక్కావ్‍మా యో ఘను మోటుహుయిన్, ఆకాష్‍ను జీన్వార్ ఇనా ఢాలియేఫర్‍ బేసీన్ ఇన జీవస్ ఎత్రెమోటు హువస్. ");
INSERT INTO vgr_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","యో బుజేక్ ఉపమానంబీ బోల్యొ, స్వర్గంను రాజ్యం ఖాటు ఆటాను జోక్ను, ఏక్ బైయికో యో ఖాటు ఆటనా లీన్ తీన్ షేర్ అష్యల్ ఆఠొమా మలైనాకి తెదె యో అష్యల్ ఆఠొబీ ఖాటు హుయిజాస్. ");
INSERT INTO vgr_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","యేసు ఇవ్నా హాఃరుబి ఉపమానంతీస్ బోల్యొ, ఉపమానం కొయినితిమ్‍ ఇవ్నా ఏక్ వాత్బీ బోల్యొ కొయిని. ");
INSERT INTO vgr_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","ఇమ్ ప్రవక్త బోలుతె వాతె హాఃరుబి హాఃచి హుయూ, మే ఉపమానంతీస్ బోలిన్ ఆ “ములాక్ పైయిదా హుయుతాప్ తూ లపీరుతే వాతె హాఃరుబి తుమ్నా మాలం కరైస్.” ");
INSERT INTO vgr_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","తెదె యేసు జనాభో హాఃర్వన బోలిమోక్లిదీన్ యో ఘేర్నా మహీ జావమా తెదె ఇన సిష్యుల్ ఇనకన ఆయిన్, ఖేతార్ మను గురుకుల్ను గురించీ ఉపమానంను అర్థంనా హామ్నా బోల్ని. ");
INSERT INTO vgr_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","ఇనటేకె యేసు అమ్ బోల్యొ, ఆష్యల్ బింజోలాన నాటవాలొ అద్మినో ఛియ్యో. ");
INSERT INTO vgr_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","ధేర్ మనూ ములక్‍నా, అష్యల్ బింజోలా రాజ్యంను అద్మిని తరా, గురుకుల్ ను దుష్టనీ సమబంధుల్‍. ");
INSERT INTO vgr_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","ఇవ్నా పీకాయుతే వైరియో సైతాన్‍ వాడవాలు అంతంధన్నె కోతవాడవాలు దేవ దూతల్. ");
INSERT INTO vgr_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","కలుపు మొక్కలు కిమ్ వాడ్యైయి హొఃతీన్‍ ఆగ్మా బలీజంకారస్కి, ఇమ్మాస్ యుగంతంమా జరగ్సే. ");
INSERT INTO vgr_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","అద్మియేనో ఛియ్యో ఇన దేవ దూతల్‍నా బోలిమోక్లసె, ఇవ్నే ఇనా రాజ్యంమాతూ ఆటంకం కరాబ్ కరవాలనా, కేత్రుకీ ధుర్నీతీన హాఃరవ్నా జోడ్‍కరిన్ ");
INSERT INTO vgr_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","ఆగ్నుగుడంమా నాకీదిసె. ఇజ్గా రోవ్వానుబీ దాత్ చావను ర్హాసే. ");
INSERT INTO vgr_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","తెదె నీతిమంతుల్ ఇవ్నా భాన రాజ్యంమా ధన్నూ చంద్రమానితరా ఛమక్సే, కాణ్‍ రవ్వాలు హంజిలేను. ");
INSERT INTO vgr_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","స్వర్గంను రాజ్యం ఖేథర్మా లపాడీ రాఖతే ధవ్లత్నితర ఛా, ఏక్ అద్మి ఇన మాలంకరీన్‍ లపాఢీదీన్‍, యోమల్యుతే ఖుషితి జైన్, ఇనకనా ఛాతె హాఃరుబి ఏఛీన్ యో ఖేతర్నా లీసె. ");
INSERT INTO vgr_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","బుజూ స్వర్గం రాజ్యం, అష్యల్ను ముత్యాల్నా లేనుకరి దూండు కరతె అద్మినితరా ఛా. ");
INSERT INTO vgr_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","యో మోల్ హుయుతే ముత్యంనా మాలంకరీన్‍, జైన్‍ ఇనకన ఛాతే హాఃరు ఏచీనకీదీన్ ఇన లీలేస్. ");
INSERT INTO vgr_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","బుజు స్వర్గంనురాజ్యం ధర్యవ్‍మా నాక్యూరుతే హర్యేక్ రకంనూ మాస్లాన ధర్యుతే ఝాల్‍నీతరా ఛా. ");
INSERT INTO vgr_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","ఝాల్ మాస్లావుతీ భారైగుతే కనారీన లీన్ఆయిన్ అష్యల్ మాస్లా గంపొమా నాఖీన్ ఖర్రాబ్ మాస్లా బాధర్ బిర్‍కైదేస్. ");
INSERT INTO vgr_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","ఇమ్మాస్ యూగంను అంతంబీహుసే దేవ్ను దూతల్ ఆయిన్ నీతిమంతుల్ మాతూ దుష్టుల్నా అలాదుకరీన్, ");
INSERT INTO vgr_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","అవ్నా ఆగ్ను గుండంమా బీర్‍కైదేస్, ఎజ్గా రొవ్వానుబి దాత్‍ఛావను ర్హాసే కొయిని. ");
INSERT INTO vgr_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","“ఆహాఃరునా తుమె గ్రహీంచు కరస్నా” కరి ఇవ్నా పుఛ్చావమా, ఇవ్నే హో గ్రహీంచుసు కరి బోల్య. ");
INSERT INTO vgr_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","యేసు, స్వర్గంనురాజ్యంమా సిష్యుడ్‍నీతర చేర్యొతె హర్యేక్ షాస్ర్తిబీ ఇను ఘర్మా నిలువాగదిమతూ జూణు రాఛునా కన్నాకిదీన్‍, నవూ రా‍ఛునా లేవతె మాలిక్‍నీతర ఛా కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","యేసు ఆ ఉపమానం బోలి హుయిజావదీన్ ఇనబాద్‍మా, యో ఎజ్గతూ నిఖీన్ చలిగొ. ");
INSERT INTO vgr_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","బుజు ఇను హుఃద్ను నంగర్‍మా ఆయో. యూదుల్‍ న్యానుజొగొ ఇవ్నా బోధించుకర్తో థొ. అనటేకే హఃజుతె ఇవ్నె అష్యంహుయీన్‍, అద్భుతం, ఆ జ్ఞానం, అనకన కెజ్గతూ ఆయూ. ");
INSERT INTO vgr_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","ఆ వడ్లవాలనొ ఛియ్యో కాహేనా? కరి ఆయాను నామ్ మరియా కహెనా యాకోబ్, యోషెపు, సీమోను యూదా కరి బోలవాలనొ భై కాహేనా? ");
INSERT INTO vgr_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","అన భేనెహాఃరి అప్నకేడె మలీన్ ర్హాయిహుయు కాహేనా? అనా ఆ కార్యల్‍ హాఃరు కెజ్గాతూ ఆంకారస్ కరి బొల్లీన్, ఇన వాత్ బన్తి అభ్యంతరంహుయు. ");
INSERT INTO vgr_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","హుయుతో యేసు ప్రవక్త ఇను దేహ్ః మాబి ఇను ఘర్మా తప్ప, బుజు కెజ్గాబిహో నామ్ ఘనహీనుడ్ పొంద్సెకొయినికరి ఇవ్నేతి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","ఇవ్ను అవిష్వాస్‍సంనా దేఖిన్ యో ఎజ్గా కెత్రూకి అద్భుతంనా కోకర్యోని. ");
INSERT INTO vgr_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","యో వహఃత్ మా చార్ దేక్నూ అధిపతిహుయోతే హేరోద్ యేసునటేకే ఆవాతే హాఃరు మాలంకరీన్. ");
INSERT INTO vgr_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","హఃజీన్ ఆ బాప్తిస్మమ్‍ దెవ్వాలొ యోహాన్; ఇనే మర్రన్మాతీ ఉట్టీన్ ఛా, ఇనటేకేస్ అద్భుతంనా ఇన కందే కామ్ హాఃరు హువుంకరస్ కరి ఇన అధికరుల్తి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","సానకతో, తు తార భైయిహుయోతే ఫిలిప్పును బావన్‍నా హేరోదియనా రాఖిలేవను న్యాయం కాహెకరి. ");
INSERT INTO vgr_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","యోహాన్ హేరోద్నా బోలమా, యో బైయికోనటేకె యోహాన్ న ధర్లీన్ భాందీచిన్ ఠాణమా నాఖిన్ రాక్యు. ");
INSERT INTO vgr_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","హేరోదు అన మారక్ను కరి సోచ్యో పన్కి అద్మిహాఃరు అన నేయ్యోకరీ ఎంచీరాక్యు, అనహాఃజే హేరోద్‍ ఢారీగయో. ");
INSERT INTO vgr_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","హుయుతో హేరోద్ను ఫైదాహుయోతె ధన్ ఆయుతెదె హేరోదియనీ ఛోరి ఇవ్నా ఇచ్మా ఖేల్ కేలీన్ హేరోద్న హాషిఖుసాల్ కరి. ");
INSERT INTO vgr_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","ఇనటేకె యో బైయికో సాత్ మంగితోబీ దీస్ కరి యో ఒట్టునాకీన్ వాగ్దానం కర్యో. ");
INSERT INTO vgr_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","తెదె హేరోద్‍ని ఛోరి, ఇని ఆయాకన జైన్ సాత్ మాంగునుకరి పుఛ్చావస్, “బాప్తిస్మమ్‍ దెవ్వాలొ యోహాన్నూ ముడ్క్యూ ఏక్ థాలిమా మ్హేలీన్ దాకరీ బోల్” కరి బోలి. ");
INSERT INTO vgr_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","రాజొ ఆ హాఃజీన్ ఘాణు బాధపడస్, యోకర్యోతే ఒట్టునాటేకె, ఇనేతి ఖానుకావన బెట్టుతె ఇవ్న హాఃజె ఆజ్ఞదిదొ. ");
INSERT INTO vgr_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","ఏక్ భట్టుడున మొక్లిన్ ఠాణమా ఛాతె యోహాన్‍ను ముడ్క్యానా కత్రాయ్ నాక్యు. ");
INSERT INTO vgr_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","యో ముడుక్యునా థాలిమాబేందీన్ లాయిన్ యోచొగ్రినా దిదూ. యోచొగ్రి యోథాలీనా లీన్ ఇని ఆయానా లీన్ఆయి. ");
INSERT INTO vgr_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","ఎజాత్నూ యోహాన్నూ సిష్యుల్ ఆయిన్ ముర్దునా లీజైయిన్, ఇన ఘాగ్దీన్ పాచుపరిన్ యేసుకనా ఆయిన్ ఇనబోల్యూ. ");
INSERT INTO vgr_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","యేసునే యోహాఃబర్‍ హఃజీన్ డోంగా చఢీన్ జాఢిమా జొగొమా ఎకేలోస్‍ గయో. అద్మిహాఃరు యోహాన్నా హుయూతె ఆవాత్ ఖంజీన్, యోమాలంకర్లిన్ నంగర్తూనిఖీన్ గోడతీచాలిన్ ఇనకేడె గయూ. ");
INSERT INTO vgr_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","యో ఆయిన్ యోమోటు గుమ్మల్ హాఃరవ్నా దేఖిన్, ఇవ్నపర్ గోర్ హుయిన్, ఇవ్నెమా రోగ్ వాలనా స్వస్థతకర్యో. ");
INSERT INTO vgr_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","హాఃజే హుయుతెదె సిష్యుల్ ఇనకనా ఆయిన్ ఆ జాఢినూజొగొ, హంకేస్ ధన్ డుబిగయూ, ఆ అద్మిహాఃరు గామ్మా జైయిన్ ఖావనూ రాచుహాఃరూ లేవనటేకె ఇవ్నా మొక్లిదాకరి బోల్యూ. ");
INSERT INTO vgr_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","యేసునే ఇవ్నే జావనా అవసరం కొయినీ పన్కి, “తుమేస్ ఇవ్నా ఖాణు నాకో” కరి ఇవ్నేతీ బోలమా ");
INSERT INTO vgr_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","ఇవ్నే హంకె అప్నకనా పాచ్ రోటా భే మాస్లా తప్ప బుజు కాయిబీ కొయినీకరీ ఇనేతి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","ఇనటేకె యో ఇన మారకనా లీన్ ఆవోకరీ బోలిన్; ");
INSERT INTO vgr_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","ఎజ్గా న్హాను గాహ్క్ బేసిన్ ర్హాకరి అద్మి హఃరౌనా బోలిన్, యో పాచ్ రోటనా, భే మాస్లనా ధరీన్ ఆకాష్‍ భణే దేఖిన్ ఆషీర్వాద్‍ కరీన్, యోరోటవ్నా తోడిన్ ఇన సిష్యుల్‍నా దిదో ఇవ్నే అద్మిహాఃరౌన భాగ్ పాడిన్ దిదూ. ");
INSERT INTO vgr_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","ఇవ్నేహాఃరు పేట్ భరిన్ ఖైన్ పాసల్తీ మిల్గిగయుతే భార టోక్రా టుక్డవ్నా భరీన్‍ పాడ్యు. ");
INSERT INTO vgr_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","బాయ్‍కా, చొగ్రాకాహేతింమ్ ఖాదుతే అద్మి బరాభర్ పాచ్‍హజార్‍ మరద్మాన. ");
INSERT INTO vgr_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","ఎగ్గీస్ యోఅద్మియేనా ఇను బోలిమొక్లను ఎత్రస్మా ఇను సిష్యులు ఢోంగచఢిన్ ఇనతీబి అగాడి హింకలిబాజు కనారికనా జానుకరి యో ఇవ్నా జబర్‍దస్తీ కర్యొ. ");
INSERT INTO vgr_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","యో అద్మి హాఃరవ్నా బోలిమొక్లినాఖీన్, యేసు ప్రార్థనా కరనటేకె ఎకేలోస్ పహాఃడ్ చఢీ జైయిన్, హాఃజే హువమా ఎకేలో థొ. ");
INSERT INTO vgr_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","తెదె యో పడవా దర్యావ్ను ఒడ్డునూ కనారినా దూర్ ర్హావమా, హాఃమేను వ్యాయ్రో ఆవమా యోపడవా పానిను జుకాళమా దూర్‍ మార్తూరంకరా. ");
INSERT INTO vgr_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","బరోభర్‍ తీన్‍తూ ధరీన్‍ చో బజతోడి వ్హానెకత్రేస్ చార్ బజాన యో ధర్యావ్నుఉప్పర్ చాల్తోహుయిన్ ఇవ్ను ఖందే ఆవమా; ");
INSERT INTO vgr_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","చాలిన్ వలావతె సిష్యుల్ దేఖిన్ భూత్‍కరి ఢరిజాయిన్ ఛిక్రాన్ బేంద్యూ. ");
INSERT INTO vgr_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","ఎగ్గీస్ యేసునే ఢర్‍నొకొ హిమ్మత్‍ లాయిలెవో, మేస్, ఢరొనొకొకరి ఇవ్నేతి బోలమా, ");
INSERT INTO vgr_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","పేతుర్నె దేవ్ తూస్ హుయోతొ పానిమాచాలిన్ తారకనా ఆవనా మన సెలవ్‍ దాకరి ఇనేతి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","యో ఆవ్కరి బోలుస్కరా పేతుర్నె ఢోంగ ఉత్రీన్ యేసుకనా జావనా పానిమా చాల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","పన్కి వ్యారొ ఆవమా ఢరిజైయిన్, పానిమా ఢుబిజాతూహుయీన్‍ ప్రభూ! మన బఛ్చావ్‍కరి! గట్టితి ఛిక్రాన్ బేంద్యొ. ");
INSERT INTO vgr_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","యేసునే ఎగ్గీస్ హాత్‍ధరిన్ ఉట్టాడీన్ “విష్వాసంకొయింతే అద్మి సానటేకె అవిస్వాస్ కరోకరి ఇనేతి బోల్యొ.” ");
INSERT INTO vgr_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","ఇవ్నె పడవా చడ్యా తెదె వ్యారో ఉబ్రిగూ. ");
INSERT INTO vgr_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","ఎజాత్నూ ఢోంగమా రవ్వాలు ఆయిన్ తూ హాఃఛిస్ దేవ్నొ ఛియ్యోకరి బోలిన్ ఇన మొక్యూ. ");
INSERT INTO vgr_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","ఇవ్నె బే జనా జైయిన్ గెన్నేసరెతుకరి దేక్మా ఆయూ. ");
INSERT INTO vgr_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","ఎజ్గాను అద్మి హాఃరు ఇన హఃనద్‍కరిన్, అస్పిస్ ఛాతె యోదేహ్క్ హాఃరవనా ఆవ్కరి బోల్కిరి మొక్లీన్, రోగ్ హాఃరవనా ఇనకన బులాయ్న; ");
INSERT INTO vgr_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","“అవ్నా తారు లుంగ్డాను కనారినాతోబి ఛీమదా” కరి ఇనేతి బతిమాల్యు; ఛీమ్యుతె హాఃరూబి అష్యల్‍హుయూ. ");
INSERT INTO vgr_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","తెదె త్యొ వహఃత్మా యెరూషలేమ్తూ షాస్ర్తుల్‍బీ పరిసయ్యుల్బీ యేసుకనా ఆయిన్; ");
INSERT INTO vgr_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","తార సిష్యుల్ హాత్ దొవ్వకొయినితిమ్ ఖాణు ఖంకరస్నీ, ఇవ్నెహాఃరు షానటేకె మోటవ్ను అద్మికంతు ఆయుతె ఆచరాల్నా ఇవ్నేషాన మీరిజంకరస్‌కరి పుఛ్చాయా. ");
INSERT INTO vgr_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","ఇనటేకె ఇనె తుమేబి తుమార ఆచరాల్నాటేకె దేవ్ని ఆజ్ఞనా మీరి జంకరతే షాన కరూకరస్‍? ");
INSERT INTO vgr_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","ఆయ, భాన గౌరవందా కరిబి, బుజూ ఆయానా హుయూతోబి భా నాహుయుతోబి ధూర్ కరవాలనా మర్రాఖను దంఢ్‍ నాక్నుకరి! బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","పన్కి ఏక్జను ఇను భానా హుయుతోబి, ఆయానా హుయుతోబి దేఖిన్‍ మార బారెమా తుమ్నా కెహూ ప్రయోజనం హువస్కి యో దేవ్నూకరి బోల్యతో తెదె ఇనే ఇను భానా హుయుతోబి, ఆయానా హుయుతోబి ఘనపర్చనూ అవసరంకొయినికరి బోలుకరస్‍. ");
INSERT INTO vgr_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","తుమె తుమారు ఆచారంను నిమిత్తంటేకె దేవ్ను వాక్యంనా గౌరవం దిదాకొయినికరి బోలుకరూస్. తుమార ఆచారాల్నాటేకె దేవ్ని ఆజ్ఞనా నొకోకరి బోలుకరస్. ");
INSERT INTO vgr_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","తుమె మోసంకరవాలా, యెషయా తుమారటేకె అగాడిస్ అష్యల్తి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","ఆ అద్మిహాఃరు ఇవ్నా వోటోవ్తి గౌరవందెంకరస్. పన్కి ఇవ్ని ");
INSERT INTO vgr_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","ఇవ్ని ఆరాధనా హాఃరు పాల్తుహుయుగు! దిల్ మాత్రం మారేహుః దూర్‍హుయిన్ ఛా. ఇవ్నె భోలతె బోధ అద్మియే ఫైదాకర్యుతె ఆజ్ఞతి సమాన్, కరిబోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","అద్మిహాఃరవ్నా బులాయిన్ తుమె హంమ్జీన్ మాలంకరొ. ");
INSERT INTO vgr_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","అద్మినా బాకమా జాయితె కెహూబి ఇనా గలీజ్ కోహుసేని. ఇన మోఢమతీ ఆవతే వాతేస్ ఇన గలీజ్ కర్సేకరి ఇనేతి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","తెదె ఇను సిష్యుల్ ఆయిన్ తుమే బోల్యతే యోవాత్ హఃమ్జీన్ పరిసయ్యుల్నే చంఢాల్ హుయుకరి తుమ్న మాలంన్నా? కరి పుఛ్చాయా. ");
INSERT INTO vgr_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","యేసునే ఇనుపేడ్తొ “స్వర్గం మా ఛాతె మారొ భా ఘాడ్యోకొయింతే హర్యేక్ జాఢబి ఝడేతీ ఉక్డి నఖాసే. ");
INSERT INTO vgr_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","ఇవ్నా జోలిన నొకొజవో; ఇవ్నే ఖాణహుయీన్ ఛా, పన్కి అలాదవ్నా వాట్ వతాలుకరస్, ఏక్ ఖాణో బుజేక్ ఖాణోనా వాట్ వతాళోతో భే ఖాణా ఖాఢమా కంఖర్సే” కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","అనటేకె పేతుర్నే ఆ ఉపమానంనా హమ్నా హఃమ్జావకరుకు బోల్కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","యేసు అమ్‍ బోల్యొ, “తుమేబి హంకె అలాదవ్తీబి అఖ్కల్ కొయింతిమ్ ఛానా” ");
INSERT INTO vgr_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","మ్హోఢవాటేతి జాయితే పాల్తుహాఃరుబీ పేట్‍మతూ జామీన్ ఫర్ మ్హెదాయ్‍ జాసే పన్కి. ");
INSERT INTO vgr_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","మ్హోఢమతూ భాదర్ ఆవతే హాఃరుబీ దిల్మతూ నికీన్ ఆవాస్‍తే యోస్ అద్మినా గలీజ్ కరస్కరీ తుమె మాలంకోకరన్నా ");
INSERT INTO vgr_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","హఃరాబ్ హఃయాల్, అద్మినా మర్రాకను, బాయికవ్నా ఖర్రాబ్‍ కరను, చోర్ కరను, జూటి సాబుత్‍ బోలాను, దేవ్‍ఫర్ ఇంజాన్‍ నాఖాను, బుజు దేవ్నదూషణనూ హాఃరుబీ దిల్ మతూస్ ఆవాస్. ");
INSERT INTO vgr_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","ఆస్ అద్మినా గలీజ్ కరీదేస్ పన్కి హాత్ ధోవకోయిని తిమ్‍ ధాన్ ఖాదతో అద్మినా గలీజ్ కరకోయినీ కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","యేసు ఎజ్గతొ నిఖీన్ తూర్ సిదోను కరి ఇలాహోఃమా జావమా. ");
INSERT INTO vgr_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","హాదేక్ యో ఇలాహోఃమతూ నిఖీన్ కనాను బాయికొ ఏక్జని ఆయిన్, ఓ ప్రభూ, దావీద్‍నొ ఛియ్యో మారఫర్ గోర్‍కర్, మారి ఛోరి భూత్‍ ధరీన్, ఘనూ బాధ పడుకరస్ కరి ఛిక్రాన్ మ్హేలి. ");
INSERT INTO vgr_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","ఇనహాఃజె యేసు యోబాయికోతి ఏక్ వాత్బి బోల్యొకొయిని తెదె యో సిష్యుల్ ఆయిన్, ఆబాయికొ అప్నకేడె ఆయిన్ ఛిక్రుకరస్‍ ఇనటేకె ఆబాయికొనా మొక్లీదా ఇన బతిమాలమా. ");
INSERT INTO vgr_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","ఇనే ఇస్రాయేల్ను ఘర్నువాల హుయిన్ నాషనం హుయితే యోబాయికొనా ఘేర్ కనస్ పన్కి బుజు కీనకానబీ మే బోలిమొక్లొకోయినీ కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","హుయుతోబీ యోబాయికొ ఆయిన్ ఇన హఃలామ్ కరీన్ ఓ ప్రభూ మన మద్దత్‍కర్ కరి పుఛ్చాయి. ");
INSERT INTO vgr_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","అనటేకె యేసు, లడ్కావును రోటనా లీన్ కుత్రావ్నా నాఖను అష్యల్ కాహే బోలమా. ");
INSERT INTO vgr_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","యో బాయికో హాఃఛీస్ ప్రభూ, కుత్రాను చెల్కబీ ఇను మాలిక్నూ భల్లమతూ హేట్ పడ్యుతే రోటానా టుక్డా పాడీన్‍ ఖాస్నీ బోలి. ");
INSERT INTO vgr_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","ఇనటేకె యేసు ఆయా, తారి విష్వాస్‍ గొప్పహుయుహు; తూ కోరితిమ్మస్‍ తున హుసే, కరి ఇనేతి బోల్యొ, యో వహాఃతాస్ ఇని ఛోరి అష్యల్ హుయి. ");
INSERT INTO vgr_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","యేసు ఇజ్గతూ నికీన్, గలిలయ ధర్యవ్‍ను కనారినా ఆయిన్, ఇజ్గ బేసీన్ ర్హావమా. ");
INSERT INTO vgr_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","ఘణు అద్మియేహాఃరు ఇనకనా లంగ్డు అద్మినా, కాణూ అద్మినా, ముక్కు అద్మినా, రోగాఢిబర్యూ అద్మినబి ఛాతే హాఃరవ్నాబి లీన్ ఆయిన్, ఇన గోఢకన ఉభార్ కాడిదీదు; యేసు ఇవ్నా అష్యల్ కర్యొ. ");
INSERT INTO vgr_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","ముక్కువాలు వాతెబోలనూ దేఖిన్, రొగాఢిబర్యూ అష్యల్ హువను దేఖిన్, లంగ్డు చాలను దేఖిన్, కాణునా దెఖ్కావను దేఖిన్, అద్మిహాఃరు అష్యంహుయిగు, ఇస్రాయేల్ దేవ్నా మహిమపర్చు. ");
INSERT INTO vgr_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","తేదెస్ యేసు ఇన సిష్యుల్‍నా బులైయిన్, ఆ అద్మిహాఃరు హంకేతిలీన్ తీన్ రోజ్‍తోడి మారకనస్ ఛా; ఇవ్నా ఖావనా కాయిబీకొయిని ఇనటేకె ఇవ్నాఫర్ గోర్‍ పడుకురూస్, ఇవ్నే వాట్మా ఢోళఫరీన్ పడిజాసుకీ కరి అవ్నా భుక్కేస్ బోలిమొక్లను మన మనస్సుకొయినీ కరి ఇవ్నేతి బోలమా. ");
INSERT INTO vgr_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","ఇన సిష్యుల్, అత్రే అద్మీయేను డంఢార్‍ బరీన్‍ ఖావనా హోనుతె యెత్రె రోటా ఝాడీను జొగొమా అప్నా కెజ్గతూ ఆవ్సేకరి ఇనేతి బోల్యా. ");
INSERT INTO vgr_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","యేసు, తుమారకన కెత్రా రోటా ఛాకరీ పుఛ్చావమా ఇవ్నే, హాఃత్ రోటాబీ ధరసు న్హానా మాస్లాబీ ఛాకరి బోల్యా. ");
INSERT INTO vgr_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","తెదె యేసు, జమీన్‍ఫర్ బేహొఃకరి అద్మియేనా ఆజ్ఞదిదో. ");
INSERT INTO vgr_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","యో హాఃత్ రోటాన లీన్ యోథోడు మాస్లనా పల్లీన్ కృతజ్ఞతాస్తుతుల్‍ కరీన్, ఇనా తోడీన్ ఇన సిష్యుల్నా దీదొ, సిష్యుల్ అద్మియేనా వడ్డించు. ");
INSERT INTO vgr_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","ఇవ్నెహాఃరు డంఢార్‍ భరీన్‍ ఖైయిన్‍ బాద్మా మిగిల్యూతె టుక్డా హాఃత్ గంపాభరీన్ పాడ్యు. ");
INSERT INTO vgr_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","బాయికాబీ లడ్కా కహేతిమ్‍ ఖాద్యుతె ఇవ్నె ఛార్ హజార్ అద్మి మరధ్మాన. ");
INSERT INTO vgr_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","పాసల్తి యేసు అద్మియేహాఃరనా బోలీమొక్లిదీన్, ఢొంగాఫర్ చఢీన్ మగదాను ఇలాహొఃమా ఆయో. ");
INSERT INTO vgr_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","తెదె పరిసయ్యుల్బి, సద్దూకయ్యూల్, యేసునా పరీక్చించూనుకరీ ఆయిన్, ఆకాష్‍మతూ దేవ్‍ తునా అనుమతి దీన్‍ మొక్లొకరి ఏక్ అధ్బుతంనా హమ్నా వతాల్కరీ ఇవ్నా పుఛ్చావమా. ");
INSERT INTO vgr_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","యేసు అమ్ బోల్యొ, హాఃజ్‍హుయూతెదే తుమె ఆకాష్‍ లాళ్‍ ఛా. అనటేకే వర్హను పడ్చెకోయినీకరి. ");
INSERT INTO vgr_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","వ్హానె ఆకాష్‍నా దేఖిన్‍ లాళ్నితరా మబ్బునితరా ఛా. అనటేకే ఆజ్‍ పాని వరక్సేకరీ తుమె బోల్చు కాహేనా. తుమె ఆకాష్‍ను ఖాయాల్మా పడ్చూ పన్కి, ఆ కాలంమా దెఖాంకరతే అద్బూతాల్నా అర్థం కోకరనీతెసే? ");
INSERT INTO vgr_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","వ్యభిచారుల్‍హుయాతే ఖరాబ్‍ పిఢిను అద్మి హాఃచి వతాల్ కరి మాంగుకరస్నా, పన్కి యోననా లీనాస్ సాబుతస్‍ పన్కి బుజు కెహూ సాబుత్బీ ఇవ్నా అనుగ్రహించి రాక్యుకొయినీకరీ ఇవ్నేతి బోలిన్, ఇనే ఇవ్నా బెంధీన్ చలీగయో. ");
INSERT INTO vgr_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","తెదె ఇన సిష్యుల్ కనారీనా ఆయిన్‍ రోటాలీన్ ఆవను భులిగయా. ");
INSERT INTO vgr_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","తెదె యేసు, దేఖిలేవొ, పరిసయ్యుల్‍నూ సద్దూకయ్యూల్ కరి బోలవలాను ఇవ్ను ఖాటు ఆటనుగురించీ జత్తన్తీ రవ్వోకరీ ఇవ్నేతీ బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","ఇనటేకె ఇవ్నే అప్నె రోటా కోలాయని కాహెనా ఇవ్నమా ఇవ్నేస్ ఇవ్నే సోచిలెంకరుతు థూ. ");
INSERT INTO vgr_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","యేసు యో వాత్ మాలం కర్లీన్, విష్వాస్‍ కొయింతే అద్మియే, అప్నా కనా రోటకొయిని కరి తుమారమా తుమె సే సోచీలేవుకరస్? ");
INSERT INTO vgr_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","తుమె ఉజుబీ మాలం కోకర్యనీసూ? పాఛ్‍ రోటా పాఛ్ హజార్ అద్మియేనా దిదోతెదె తుమె మిగ్లిగూతె రోటాన కెత్రగంపా పాఢ్యాకి యోబీ మాలంకొయిని. ");
INSERT INTO vgr_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","హాఃత్ రోటా ఛార్ హజార్ అద్మియేనా భాగ్‍పాడీన్‍ దిదోతెదె కెత్రా గంప పడ్యకీ యోబీ తుమ్నా హఃనద్‍ కొయిన్నా. ");
INSERT INTO vgr_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","మే రోటాన గురీంచీ బోల్యోకోయినీ కరి తూమేసే మాలంకోకర్యనీసూ? పరిసయ్యుల్బీ సద్దూకయ్యుల్‍ కరి బొలవలాను పొంగ్యుతె ఖాటు ఆటొను గూర్చినాస్‍ జాగ్రుత్ ప పడొకరీ బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","తెదె ఖాటు రోటాను పొంగ్యుతె ఆటోనా గూర్చీన్‍ కాహెపన్కి, పరిసయ్యుల్ సద్దూకయ్యూల్ కరి బోలతె బోధనాగూర్చీన్‍ జాగ్రుత్తీ ర్హానుకరి యేసు ఇవ్నేతి బోల్యొకరి ఇవ్నె మాలంకర్లీదు. ");
INSERT INTO vgr_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","యేసు ఫిలీప్పు హుయోతే కైసరయ ఇలాహోఃమా ఆయిన్, అద్మినొఛియ్యో కోన్కరీ అద్మియే బొల్లెంకరస్‍కరి ఇనా సిష్యుల్తీ పుఛ్చావమా; ");
INSERT INTO vgr_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","ఇవ్నె థోడుజను బాప్తిస్మమ్‍ దెవ్వాలొ యోహాన్ కరి, థోడుజను ఎలీయాకరిబీ, థోడుజణు యిర్మీయా కరి, నైయితో ప్రవక్తమా ఏక్ కరి బొల్లెంకరస్‍కరి బోల్యు. ");
INSERT INTO vgr_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","ఇనటేకె యో, తుమెహుయ్తో మే కోన్కరి బొల్లెంకరస్కరి ఇవ్నాపుఛ్చాయో. ");
INSERT INTO vgr_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","అనటేకె సీమోన్ పేతుర్ థూ జీవ్తొహుయోతె దేవ్ ఛియ్యోహుయోతె క్రీస్తుకరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","అనటేకె యేసు సీమోన్‍ బర్ యోనా, ఛియ్యా తూ భాగ్యవంతుడ్‍ స్వర్గంమాఛాతె మారొ భా ఆ సంగతి తునా భార్‍బోల్యు పన్కీ నరుడ్‍ తునా బయల్‍ పర్చుకొయిని. ");
INSERT INTO vgr_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","బుజు థూ పేతుర్; ఆ బండాఫర్ మారు సంఘంనా బాందీస్ పాతాళంనూ ములక్ను ధర్వాజు ఇనూ హాఃమె ఉబర్సేకొయినికరి మే తుమారేతి బోలుకరూస్‍ ");
INSERT INTO vgr_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","స్వర్గం రాజ్యంనూ బీగంనుగుత్తీ తునాదీస్, తూ జమీన్ ఫర్ కినా బందీంచీస్కి యోస్ స్వర్గంమా బందీంచ్సే, కినా చోడీస్కి యో స్వర్గంమా చొడావ్సేకరి ఇనేతి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","యో వహఃత్ యో క్రీస్తుకరి కినేతీబి నోకోబోల్సుకరి యో ఇన సిష్యుల్నా గట్తీ ఆజ్ఞదిదొ. ");
INSERT INTO vgr_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","తెప్తూలీన్‍ ఇను యేరుషలేంమా జైయిన్ మోట్వానహాతే ప్రధాన యాజకుడ్నా హాతెబి షాస్ర్తుల్‍ నాహాతేతి కెత్రూకి మిన్హత్‍ పొందీన్‍ మరిజైన్, తీన్మనూ ధన్నే జీవీన్ ఉట్టీస్తె యేసు ఇన సిష్యుల్నా మాలం కరావను సురుకరమా ");
INSERT INTO vgr_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","పేతుర్ ఇను హాత్ ధరీలీన్, ప్రభూ యోతునా దూర్ హుయిజావదా, యోతునా కెదేబీ కోహుసేనికరి యేసునా గుర్కావనీక్యో. ");
INSERT INTO vgr_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","ఇనటేకే యేసు పేతుర్ బణే ఫరీన్, సైతాన్ మార హాఃమెతూ నికిజా! తూ మన ఆటంకం పరుచుకరస్! తూ అద్మీయెను హాఃబర్‍ గురీంచీ సోచుకరస్ పన్కి, దేవ్ ను హాఃబర్ నా టేకె కాహే కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","తెదె యేసు ఇన సిష్యుల్ భణె దేఖీన్, మారకేడె అవునుకరీ ఛాతె ఇవ్నే యో ఇను హాఃరూస్ బెందీన్, ఇను సిలువనా పల్లీన్ మారకేడె ఆవొ. ");
INSERT INTO vgr_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","కోన్బి ఇన జాన్నా బఛైయ్‍ లేనుకరి సోచిలేవ్వాలు ఇన గమైయిలీసె, పన్కి మారహాఃజె ఇను జాన్నా గమైయిలెవ్వాలు ఇన బచైయిలీసె. ");
INSERT INTO vgr_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","ఏక్ అద్మి దేహ్ః అక్కు కమైయిలీన్, ఇన జాన్నా గమైయిలిదొతో ఇన షాను ప్రయోజనం? ఏక్ అద్మి ఇను జాన్నా బదుల్‍ యోసాత్ దిసే? ");
INSERT INTO vgr_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","అద్మినోఛియ్యో ఇనో భా మహిమానితరా హుయిన్ ఇను దూతల్తీ ఆవుంకరస్, తెదె యో హర్యేక్‍జణు కర్యూతె కామ్నలీన్ ప్రతిఫలం దిసే. ");
INSERT INTO vgr_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","అజ్గ ఉబ్రిఛాతె థోడుజణు అద్మినొఛియ్యో దేవ్‍ని రాజ్యంతీ ఆవను దేఖతోడి మరణ్‍నా కోదేక్సెనికరి హాఃఛితీ తుమారేతి బోలుకురూస్. ");
INSERT INTO vgr_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","ఛొ రోజ్ హుయిగూ ఇన పాస్సల్ యేసు పేతుర్న యాకోబ్ను ఇనో భై యోహాన్నా కేడెలీన్, ఏక్ ఊచు ఫహాడ్ ఫర్ ఎకేలోస్‍ జైన్ ఇవ్నహాఃమె ఇను రూప్నా బద్లిగు. ");
INSERT INTO vgr_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","ఇను మ్హోడు ధన్ను సూర్యుడ్నితరా ఛంక్యూ; ఇను లుంగ్డా ఉజాలనీతరా ధోలుహుయుగు. ");
INSERT INTO vgr_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","హదేక్ మోషబీ ఏలియాబి ఇవ్నా దెఖైయిన్ ఇనేతి వాతె బోలుకర్తా థా. ");
INSERT INTO vgr_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","తెదె పేతుర్ ప్రభూ, అప్నె అజ్గ ర్హావను అష్యలాస్; తున ఇష్టంహుసెతో తున ఏక్, మోషెనా ఏక్, ఏలియానా ఏక్, కరి తీన్ ఢేరొ నాకియేస్కరీ యేసుతి బోలమా. ");
INSERT INTO vgr_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","యో బుజు ఇవ్నేతి వాతె బోలుకరతెదె ఛంమ్కుకరతే ఏక్ మబ్బూ ఇవ్నా ఢాపీనాఖిదిదూ; హదేక్ ఆ మారొ లాఢ్‍నొ ఛియ్యో, అనకనా మే ఖుషి హుంక్రూస్, అనూ వాతె హఃమ్జోకరి ఏక్‍ ఆవాజ్ యోమబ్బుమతూ ఆయూ. ");
INSERT INTO vgr_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","సిష్యుల్ ఆవాత్ హఃమ్జిన్‍ ఉందేమోఢె పడిజైయిన్ ఢరీజావమా ");
INSERT INTO vgr_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","యేసు ఇవ్నకనా ఆయిన్, ఇవ్నా ఛీమిన్, ఉట్టో ఢరొనొకొ కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","ఇవ్నె ఢోళాపాఢీన్ దేక్యుతెదె, యేసు తప్ప బుజూ కోన్బి కోదేఖ్కాయుని. ");
INSERT INTO vgr_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","ఇవ్నె ఫహాడ్ ఉత్రీన్ ఆంకరతెదె, అద్మియేనో ఛియ్యో మరణ్‍ మతూ జీవతోడి ఆ దర్సనం గూర్చి తుమె కీనాబి నొకొబోల్చుకరి యేసు ఇవ్నా ఆజ్ఞదిదొ. ");
INSERT INTO vgr_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","తెదె ఇను సిష్యుల్, ఇంహుయుతో ఏలీయా అగాఢి ఆవ్నుకరి షాస్ర్తియే షాన బోలుకరాస్కరి ఇన పుఛ్చాయా. ");
INSERT INTO vgr_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","యేసునే అమ్ బోల్యొ ఏలీయా ఆయిన్ ధర్తిహాఃరు తయార్‍ కర్సేకరి బోలుకురతే వాత్ హాఃఛిస్; ");
INSERT INTO vgr_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","హుయుతోబి ఏలీయా అగాఢీస్‍ ఆర్యోస్; ఇవ్నే ఇనా మాలంకరకొయినితిమ్‍ ఇవ్నా ఇష్టం హుయుతిమ్‍ ఇనజోరెమా కర్యు. అద్మినొఛియ్యోబీ ఇంమ్మస్ ఇవ్నహాతె మిన్హత్ పొంద్చెకరీ తుమారేతి బోలుకరూస్. ");
INSERT INTO vgr_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","తెదె యేసు బాప్తిస్మమ్‍ దెవ్వాలొ యోహాన్నా గూర్చిన్ అప్నెతి బోలుకరస్కరి, సిష్యుల్ మాలంకర్యూ. ");
INSERT INTO vgr_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","ఇవ్నే అద్మియేకనా ఫరీన్‍ ఆయుతెదె ఏక్జనో ఇనకనా ఆయిన్ గుడ్గ్యామేట్ హుయిన్; ");
INSERT INTO vgr_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","ప్రభూ, మారో ఛియ్యానా కరణించ్; యో మిర్గిను రోగ్తి ఘనూ తర్పుడూకరస్‍; కిమ్కతో ఆగ్మతోబి, పానిమాతోబి బార్‍బార్‍ పడ్జంకరస్. ");
INSERT INTO vgr_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","తార సిష్యుల్‍కనా బులాలిగయోతోబి ఇవ్నే ఇనా హూఃదు కర్యకొయినికరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","అనటేకె యేసు బోల్యొ, విష్వాస్‍ కొయింతె మూర్ఖంను అద్మియే, బుజు కెత్రధన్ తుమారకేడె ర్హైస్? కెత్రధన్తోడి తుమ్నా సహింఛీస్‍? ఇన మారకనా లీన్‍ ఆవొకరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","తెదెస్ యేసు యో భూత్నా ఢరావమా యో ఇనా బెందీన్ చలిగు; యో వహాఃత్‍మాస్ యో న్హాను చొగ్రు అష్యల్ హుయు. ");
INSERT INTO vgr_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","పాసల్తీ సిష్యుల్ మలీన్‍ ఏకాంతమా యేసుకనా ఆయిన్‍, హమే సే ఇనా హాకల్యా కొయింతే? కరి పుఛ్చాయా. ");
INSERT INTO vgr_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","ఇనటేకె యేసు తుమ్న హాఃఛి విస్వాస్‍కొయిని ఇనటేకె ఇనా హాకల్యాకొయిని తుమ్నా రాయ్ను బింజ్లోను యెత్రే విష్వాస్‍ ర్హైతో బైష్‍ తుమె ఆ ఫహాడ్నా అజ్గతూ నిఖీన్‍ ఎజ్గా జా కరి బోలుస్‍కరా జాసె; ");
INSERT INTO vgr_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","తుమ్నా హోయ్‍కొయింతె కెహూబికొయినికరి తుమారేతి బోలుకరూస్‍కరి ఇవ్నేతి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","తెదె ఇవ్నె గలిలయమా పరూకరాతెదె యేసు అద్మినొఛియ్యో అద్మినో హాత్మా ధరాయ్‍ దేవనాజంకరస్‍, ");
INSERT INTO vgr_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","ఇవ్నే ఇనా మర్రాకి దిసే, తీన్మను ధన్నే యో జివీన్‍వుట్సేకరి ఇవ్నా బోలమా, ఇవ్నే ఘణు బాధపడ్యు. ");
INSERT INTO vgr_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","ఇవ్నే కపెర్నహూమునా ఆయాతెదె అరషెకెల్‍కరి మందిర్ను పైయిసా వసూల్ కరవాలు పేతుర్‍కనా ఆయిన్, తారో బోధకుడ్ మందిరంను పైయిసా బాందకొయిన్నా? కరి పుఛ్చావమా, బాంద్చేనికరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","యో ఘేర్మా జైన్ యోవాత్ బోలాన అగాడీస్, యేసు యోవాత్ కాఢీన్, సీమోన్ తునా సాత్ సోచ్చాంకరస్? రాజొ సుంకాల్‍నా పన్నుల్నా కీనకంతూ వసూల్ కర్సే? ఇనా హుఃద్నో ఛియ్యాకనకీ న్హైయితో అన్యుల్ కనా? కరి పుచ్ఛాయో. ");
INSERT INTO vgr_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","ఇనే “అన్యుల్‍ కంతూస్‍” కరి జవాబ్నా బోల్యొ. యేసు “ఇమ్ హుయుతో ఛియ్యా ప్హేడన అవసరం కొయినీకరి! ");
INSERT INTO vgr_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","పన్కి అప్నె ఇవ్నా ఆటంకం కరనా మన ఇష్టంకొయిని. థూ ధర్యావ్నా కందెజైయిన్, ఝాల్ నాక్! అగాఢి ధర్యోతె మాస్లనా మోఢుఛీరిన్ దేఖ్యతో తున ద్రాక్మాను ను బిల్లు మల్సే; ఇన లీన్ తారటేకెబి, మారటేకెబి, తూ ఇవ్నా దిజోకరి” ఇనేతి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","యో ధనుమా సిష్యుల్ యేసుకనా ఆయిన్, స్వర్గంను రాజ్యంమా కోన్ మహాన్‍ అద్మికరి పుఛ్చాయా. ");
INSERT INTO vgr_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","యేసు ఏక్ న్హాన లడ్కనా ఇన ఖందె బులాయిన్, ఇవ్నా ఇచ్మా వుభార్ కాడీన్ ఆమ్ బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","తుమె దిల్‍ బద్లాలీన్‍, న్హాను లడ్కానితరా హుయాతోస్ పన్కి, స్వర్గంను రాజ్యంమా కోజాసునికరి మే తుమారేతి హాఃఛితి బోలుకురూస్. ");
INSERT INTO vgr_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","న్హైతొ ఆన్హాను లడ్కనితరా ఇనుయోస్ తగ్గించిలెవ్వాలొ కోన్కి యోస్ స్వర్గంను రాజ్యంమా మహాన్‍హుయిన్ ర్హాసె. ");
INSERT INTO vgr_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","బుజు అమ్ను న్హాను లడ్కనా మారునామ్తి ఖందెకరవాలు మనబీ ఖందె కర్సె. ");
INSERT INTO vgr_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","మారఫర్‍ విష్వాస్‍ రాఖవాలు ఆన్హాను లడ్కామతీ ఎక్నా హాఃతావవాలో కోన్కి, ఇన గుద్దినా మోటు ఫత్రో భాందిలీన్, ఘణు ఘదర్ను ధర్యావ్మా నఖైజావనూ ఇన అష్యల్. ");
INSERT INTO vgr_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","ఠోకర్‍నుబారెమా ములక్నా మిన్హత్‍; ఠోకర్‍ ఆవ్సేకొయినితిమ్ ర్హాసెకొయిని పన్కి, కినబారెమా ఠోకర్‍ ఆవస్కి యోఅద్మినా మిన్హత్‍. ");
INSERT INTO vgr_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","పన్కి, తారహాత్తోబి తారు గోఢతోబి తునా పాపంనా కరావనా గయూతో, ఇనా కత్రినాఖిదీన్ దూర్ ఫేకిదా; భే హాత్ ర్హైన్ భే గోడా ర్హైన్ నిత్యం ఉజ్జావకొయింతె ఆగ్మాఫేకైయి జావనూతీబి లంగ్డొహుయీన్ జీవంమా జావను తున అష్యల్. ");
INSERT INTO vgr_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","తారు డోళొ తునా ఠోకర్‍ కామ్ వాతల్యుతో తూ యినా వుక్డీన్ తారకంతూ దూర్ బిర్కైయిదా, బే ఢోళొ ర్హైన్ నరకంను ఆగ్‍మా ఫెకైయి జావనుతీబి, ఏక్ ఢోళో ర్హైన్ జీవంను జావను తున మేల్. ");
INSERT INTO vgr_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","ఆ న్హాన లడ్కావ్నా కీనాబీ ఎక్నా ఆఠఢోలాకు నోకొదేక్సు, మే బోలుకురూతె సాత్‍కతొ స్వర్గంమా ఛాతె అనా దూతల్‍ స్వర్గంమా ఛాతె మారొ భాను మ్హోడు కెదేబి దేకుతుస్ ర్హాసు. ");
INSERT INTO vgr_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","తుమ్నా సాత్ సొచాంకరస్? నషించుకరతె ఇనా బఛ్చావనటేకె అద్మినో ఛియ్యో ఆయో. ");
INSERT INTO vgr_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","ఏక్ అద్మికనా ఖొః మ్హేంఢ ర్హావమా ఇన్మతూ ఏక్ గమైగుతో, ఏక్కమ్ ఖొః మ్హేంఢనా! ఫహాడ్ ఫర్ మ్హేందీన్ జైన్ గమైగుతె ఇనా కోదూండ్‍సేనా? ");
INSERT INTO vgr_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","యో ఇనా దూండిలీదొతో ఎక్కమ్ ఖొః మ్హేంఢలీన్ ఖుషీ హువనుతీబి యో ఏక్నలీన్ ఘను ఖుషి హుసేకరి హాఃఛితీ బోలుకురూస్. ");
INSERT INTO vgr_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","ఇమ్మస్ ఆన్హాన లడ్కమతూ ఏక్జనూబి చుక్కాయి గయూతో స్వర్గం రాజ్యంమా ఛాతె తుమారో భాను చిత్తమ్‍ కాహే. ");
INSERT INTO vgr_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","బుజు తారొ భై! తార బారెమా గలత్‍ కర్యొవుసేతో తూ జైన్, తుహో యోహో ఎకేలాస్ ర్హయాతెదె ఇనా ఢరావ్; ఇనె తారు వాత్న హఃమ్జొతొ తారొ భైనా కమైయిలీదొ. ");
INSERT INTO vgr_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","ఇనె తుమారు వాతెనా నాహమ్జుతో, బే తీన్‍ జణనా తుమారకేడె లీన్ జవొ, సానకతొ హర్యేక్ వాత్నా నిర్ణయించనాటేకె లేఖనాల్‍ బోల్యుతిమ్‍ ఏక్ న్హైతో బే జణా సాబుత్‌నితరా ర్హాసు. ");
INSERT INTO vgr_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","యో ఇవ్నివాత్ నాహఃమ్జతో ఆ హాఃబర్‍ సంఘంనా బోల్; యో సంఘంను వాతేబి నాహమ్జోతొ ఇనా తునా అన్యునిగోణి సుంకరిగోణి ఎంచిలెవొ. ");
INSERT INTO vgr_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","జమీన్‍ ఫర్ తుమె కినా బంధించస్కీ, యో స్వర్గంమాబీ బాంధించబడ్సే. జమీన్ ఫర్ తుమె కెహూ చోడస్కి, యో స్వర్గంమా చొడావ్సేకరి, తుమారేతి హాఃఛితి బోలుకురూస్. ");
INSERT INTO vgr_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","బుజు తుమారమా బేజనా మలీన్‍ ప్రార్థనా కర్యొతొ మాంగను కినాబారెమా హుయుతోబి జమీన్‍ఫర్ ఏక్ హుయాతొతెదె, యోస్వర్గంమాఛాతె మార భాన బారెమా ఇవ్నా మల్చేకరి తుమారేతి హాఃఛితి బోలుకురూస్. ");
INSERT INTO vgr_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","కింమ్కతో భేజనా తీన్జనా కెజ్గ మారు నామ్మా కెజ్గా మాలీన్ రాస్కి ఎజ్గా మే ఇవ్నా ఇచ్మా రహీస్‍కరీ బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","త్యో వహఃత్మా పేతుర్ ఇనకనా ఆయిన్ ప్రభూ, మారో భై! మారబారెమా గలత్నుకామ్ కర్యొతో మే కెత్రాచోట్ ఇనా క్చమకర్నూ? హాఃత్ చోటస్నా? కరి పుఛ్చాయో. ");
INSERT INTO vgr_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","అనటేకె యేసునే ఇనేతి అమ్ బోల్యొ, హాఃత్ చోట్స్ కాహే, హాఃత్ఫర్‍ హఃడ్తినీక్‍ కరి తారెతీ బోలుకరూస్. ");
INSERT INTO vgr_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","ఇనహాఃజె స్వర్గంను రాజ్యం, ఇను దాసుల్‍కనా లేక్క దేఖవాలనుతరా ఏక్ రాజొతి పోలీన్‍ ఛా. ");
INSERT INTO vgr_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","యో లెక్కా దేక్నుకరి దేక్యొతెదే ఇన ధహ్క్ హజార్ తలాంతుల్నా లీన్, ఎక్జనా ఇన హాఃమె లీన్ ఆయూ. ");
INSERT INTO vgr_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","ఉధార్ ఫేడనాటేకె ఇనకనా కైయిబినార్హావమా ఇనో మాలిక్ ఇనా, ఇని బావన్నా ఇనా లడ్కావ్నా ఇనకనా ఛాతె హాఃరుబీ ఏఛీన్ ఉధార్ భాందొకరి ఆజ్ఞదిదో. ");
INSERT INTO vgr_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","అనహాఃజే యో దాసుడ్‍ ఇనా హాఃమె డుక్నిమేటే నాఖీన్ హాఃలామ్ కరీన్, మార బ్హణె జర హాఃమాలీలా, తారు హాఃరు మే ప్హేడీస్, బోలమా. ");
INSERT INTO vgr_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","యో దాసుడ్‍నొ మాలీక్ ఇనఫర్ గోర్ కరీన్, ఉధార్ హాఃరు క్చమాకరీన్‍ ఇనా బెందిదొ. ");
INSERT INTO vgr_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","పన్కి యో దాసుడ్‍ భాదర్ జైన్, ఇనేతి మాలిన్ కామ్‍కరతె దాసుడ్నా దేక్యొ ఇనా ఖొః! దేనారంల్ ఉధార్‍ఛాతె ఇనా గర్ధన్ ధర్లీన్‍, మారు ఉధార్ ఫేడ్కరీ ఢరాయో. ");
INSERT INTO vgr_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","ఇనటేకె ఇనా కేడెఛాతె దాసుడ్, ఢుక్నేమేట్‍ నాఖీన్, మారమడ్తీ జర హాఃమాలిలా, మే పేఢిదీస్‍కరీ బతిమాల్యొ పన్కి. ");
INSERT INTO vgr_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","యో ఓప్పీలేవదీన్ దేవనూ కేత్రుఛాకి యో దేవతోడీ ఇనా ఠాణమా ఘలాయో. ");
INSERT INTO vgr_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","అజు ఇనకేడెఛాతె దాసుల్ హుయుతే హాఃరు దేఖిన్, ఘణు బాధపడీన్, ఆయిన్, జరుగ్యుతె హాఃరు ఇన మాలీక్నా బోల్యు. ");
INSERT INTO vgr_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","తెదె ఇనో మాలిక్ ఇనా బులైయిన్, గలీజ్ దాసుడ్‍, తూ మన బతిమాల్లిదోకరి అనటేకె మే తారు ఉధార్ హాఃరు క్చమాకరిన్‍ మ్హేందిదొ. ");
INSERT INTO vgr_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","మే తునా గోర్‍ కర్యొతె ప్రకారం, తూబితో తారకేడె ఛాతె దాసుడ్‍నబి గోర్‍ కరీన్‍ బెందేనుతూని కరి ఇనేతి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","ఇనటేకె ఇనో మాలిక్ చంఢాల్‍హుయిన్, యో దేవను ఉధార్న దేవతోడి చిత్రహింసా కరతె ఇనా ధరైయ్‍దేస్. ");
INSERT INTO vgr_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","తుమారమా హర్యేక్ జణు తుమార భైయ్యోవ్నా దిల్‍భర్తితీ నా క్చమ కర్యతొ, స్వర్గంమాఛాతె మారొ భా తుమ్నాబి ఇంనితరస్‍ కర్సే. ");
INSERT INTO vgr_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","యేసునే ఆవాత్‍హాఃరు బోలిన్‍హువమా పాస్సల్తి గలిలయమాతు యోర్దాన్ను పార్‍ఛాతె యూదయ ఇలాహొఃమా ఆయో. ");
INSERT INTO vgr_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","కెత్రూకి అద్మిహాఃరు ఇనకేడె ఆవమా, యో ఎజ్గా ఇవ్నా హుఃద్రాయో కర్యొ. ");
INSERT INTO vgr_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","థోడు పరిసయ్యుల్ ఇనా పరీక్చాకర్నుకరి ఇనకనా ఆయిన్ బోలలాగ్యు, కెహూ కారణంతీబి మరద్మానొ ఇని బావన్నా బెందేవాను న్యాయమాస్నా? కరి పుఛ్చావమా? ");
INSERT INTO vgr_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","యో ఇవ్నేతి అగాఢితూ సృజించ్యొతె ఇన అద్మితూ ఇవ్నా మర్దామానోకరీ, రాండ్కరీ, సృష్టించొకరి. బోల్యొతె లేఖనాల్మా బోలిరాక్యుతే తుమె పఢ్యాకొయినా? ");
INSERT INTO vgr_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","అనటేకె మరద్మానో ఆయా, భాన బెందీన్ ఇని భావన్నా కందెకర్సే, ఇవ్నె భేజణా ఏక్‍హుయిన్ ఏక్ ఆంగ్తాన్‌నితరా ర్హాసే. ");
INSERT INTO vgr_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","అనటేకె ఇవ్నె భేజనా ఎక్కస్ ఆంగ్‍హుయిన్ రంకరస్, ఇనటేకె దేవ్ మలాయోతె ఇవ్నా అద్మియే అలాదు నాకర్నుకరీ బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","అనటేకె ఇవ్నె ఇమ్‍హుయితో తలాక్ను కాగత్‍ దీన్ యోరాండ్నా బేందాకరి మోషే షాన ఆజ్ఞదిదోకరీ పరిసయ్యులు ఇనా పుఛ్చావమా. ");
INSERT INTO vgr_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","ఇనె తుమారు దిల్ను కట్టీన్‍టేకె తుమారు బావన్నా బెందేవనా మోషే ఆజ్ఞదిదోకరి బోల్యొ, పన్కి ఆదిమతూ ఇమ్నితరా కోహుయుని. ");
INSERT INTO vgr_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","బుజు మే తుమారేతి బోలుకురూస్! బుజు వ్యభిచార్నాటేకెస్ తప్ప, అజు కారణ్‍ కాహెతిమ్‍ ఇని బావన్నా బెందీన్ బుజేక్నా య్హా! కరవాలో వ్యభిచార్ కరూకరస్‍కరి తుమారేతి బోలుకరూస్‍కరి ఇవ్నేతి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","ఇను సిష్యుల్, బావన్ బావ్రినఛాతె సంబంధ్న్ అజాత్ను జోడ్ను ర్హహీతో య్హా! కర్లేవను అష్యల్ కాహేకరి ఇనేతి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","అనటేకె యేసునే బోల్యొ, దీరాక్యొతె గలత్‍ బుజు కోన్బి ఆవాత్‍ హాఃమ్చెకొయిని. ");
INSERT INTO vgr_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","య్హా కరకొయింతెటేకెబి కారణం ఛా. ఆయాను పెట్మతూ కొజ్జానిఘోని ఫైదాహుయూతె ఛా, అద్మినటేకె కొజ్జానితరా హుయుతే కొజ్జానియే ఛా! స్వర్గంనూ రాజ్యంనటేకె ఇవ్ను యోస్ కొజ్జానిఘోని కర్లీన్ ఛాతె కొజ్జానియేఛా. ఆవాతేనా హఃమ్జవాలొ ఒప్పవాలో ఒప్పిలేవదా! కరి ఇవ్నెతి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","తెదె ఇనె ఇవ్నఫర్‍ హాత్ బెందీన్ ప్రార్థనా కర్నూకరి, థోడుజణు అడ్డాణి లాడ్కన ఇనకనా బూలైలీన్ ఆయూ. ఇను సిష్యుల్, బులైయిలీన్ ఆయూతె ఇవ్నా గుర్కావమా; ");
INSERT INTO vgr_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","యేసునె అడ్డాణి లడ్కావ్‍నా కాయ్‍బి, నొకొకరొ ఇవ్నా మారకనా ఆవదేవొ; స్వర్గంను రాజ్యం అవ్నింతర ఛాకరి ఇవ్నేతి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","ఇవ్నఫర్ హాత్ మ్హేలిన్, ఎజ్గతూ ఉట్టీన్ గయో. ");
INSERT INTO vgr_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","హదేక్ ఏక్జణో ఇనకనా ఆయిన్ బోధకుడ్, మే నిత్యజీవంమా జావనటేకె మే కెహూ అష్యల్ కార్యమ్నా కర్నూ? కరి పుఛ్చాయో. ");
INSERT INTO vgr_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","ఇనటేకె యేసు అష్యల్ కర్యామ్నా బారెమా మనషాన పుఛ్చాంకరస్? అష్యల్ యో ‍ఎక్కస్‍ జణొ, తూ జీవంమా జానుకరీ దేఖ్యతొ ఆజ్ఞల్నా పాటించునూకరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","కెహూ ఆజ్ఞల్‍కరి ఇనా పుఛ్చావమా యేసునే బోల్యొ, మర్రాకనూ నాకర్ను, ఖర్రాబ్‍ నాకర్ను, చోర్కామ్ నొకొకరో, చాఢీనువాత్ సాక్చ్యాం బోలొనొకొ; ");
INSERT INTO vgr_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","ఆయా భాన సన్మానంకరొ. తారింతరాస్ తార బగల్యేనా ఫ్యార్‍కరనూ ఆహాఃరూస్ కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","అనటేకె యో కవ్వారు ఆహాఃరు కరూకరుస్‍. బుజుబీ మన షాత్‍ కంహుయీన్‍ ఛా! కరి ఇనేతి పుఛ్చాయో. ");
INSERT INTO vgr_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","అనటేకె యేసునే బోల్యొ, తూ పరిపూర్ణడ్‍ హోనుకతొ తూ జైన్ తార ఆస్తినా ఏఛీన్‍ గరీబ్ అద్మియేనా దిజో, తెదె స్వర్గంమా తునా ధవ్లత్ మాల్సె; తూ ఆయిన్‍ మారకేడె ఛాల్‍కరి ఇనేతి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","హోగాని యో కవ్వారు జాహఃత్‍ దవ్లాత్‍వాలో, ఇనటేకె యోవాత్ హఃమ్జీన్ ముర్జాయిన్‍ చలిగో. ");
INSERT INTO vgr_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","ఇనపాసల్ యేసు ఇను సిష్యుల్తీ, ధౌలత్ వాలో దేవ్‍నూ రాజ్యంమా జావనూ హుసే కోయిని, ");
INSERT INTO vgr_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","మే బుజు బోలుకరూస్, ధవ్లత్ వాలో దేవునిరాజ్యంమా జావనూ, బదుల్ వూట్ హూఃయ్‍నుచిల్లామా జావనూ హల్కూకరి బోలుకరూస్. ");
INSERT INTO vgr_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","సిష్యుల్ ఆ హఃమ్జిన్ ఘనూ అష్యంహుయు. బుజు బఛ్చీన్‍ ర్హాసెతె కోణ్? కరి పుఛ్చావమా ");
INSERT INTO vgr_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","తెదె యేసు ఇవ్నాదేఖిన్, ఆ అద్మి హఃరౌనా సాద్యంకాహే పన్కి దేవ్నా ధర్తిమా ఛాతే మొత్తంబీ సాద్యమస్ కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","పేతురు హదేక్ హమే ధర్తీనుమొత్తం బెందీన్, తారకేడె వలాయస్‍నీ? హమ్నాషాత్ మల్సేకరి పుఛ్చావమా ");
INSERT INTO vgr_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","యేసు ఇవ్నేతి అమ్ హాఃఛితి బోల్యొ, నవూ యుగంమా అద్మినొ ఛియ్యో తెజోమంతమైనూ సింహాసంనావుప్పర్ బేషిన్ ర్హాషే. తెదె మారకేడె చాలుకరతే తుమేబి భార సింహాసనంవుప్పర్ బేషిన్ ఇస్రాయేల్నూ అద్మి హాఃరనా భారా గోత్నా న్యావ్‍ కర్చు. ");
INSERT INTO vgr_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","మార నిమిత్తం భైయ్యెనహో, భేనెయేవ్నాహో, భానహో, ఆయానహో, లడ్కానహో, జమీన్నహో, ఘేర్నాహో, బెందేతె హర్యేక్ జణనా ఖోః! రెట్లు మల్సే; అత్రేస్ కాహేతిమ్‍ నిత్య జీవంనా కమాయ్‍లిసే. ");
INSERT INTO vgr_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","పన్కి అగాఢి ఛాతె ఇవ్నమా ఘనూ అద్మియే పీటెజాసె, పీటెఛాతె ఇవ్నమా ఘనూఅద్మియే అగాఢిహుసే! కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","కిమ్కతో స్వర్గంను రాజ్యం ఏక్ ఘర్ను మాలిక్నా తోట్మనూ ఘోని పోలిసన్ ఛా! ఏక్‍ ధన్నె యో ఇను ద్రాక్చను బాగ్‍మా కామ్ కరవాలనా బులావనాటేకె వ్యానేస్ నిఖీన్. ");
INSERT INTO vgr_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","ఏక్ ధన్నా ఏక్‍ దేనారంకరి కామ్కరవాలనా బోలిన్‍, ఇవ్నా ద్రాక్చనూ బాగ్‍మా మొక్లొ. ");
INSERT INTO vgr_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","పాసల్తీ యో బరాబ్బర్ నౌ బజానా బజార్‍ను గల్లిమా జైన్ ఎజ్గా చుక్కేస్ ఉబ్రీన్ ఛాతె ఇవ్నా దేఖిన్. ");
INSERT INTO vgr_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","తుమేబి మారు ద్రాక్చాను బాగ్‍మా జైన్ కామ్ కరొ, తుమ్న కేత్రదేనుకీ ఎత్రా దీస్‍కరి బోలిన్ ఇవ్నేతి బోలమా, ఇవ్నే గయూ. ");
INSERT INTO vgr_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","బరాబ్బార్ భారబజేనా, అజు తీన్ బజేనా, యో బుజూ ఇమ్మస్ కర్యో. ");
INSERT INTO vgr_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","బుజుపాచు పరీన్ బరాబ్బర్ పాచ్ బజేనా జైన్, బుజు థోడుఅద్మి బజార్ను గల్లిమా ఉబ్రీన్ ర్హావను దేఖిన్, అజ్గ తుమె షాన ధన్నక్కో చుక్కేస్ ఉబ్రీన్ ర్హాస్‍కరి పుఛ్చావమా. ");
INSERT INTO vgr_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","ఇవ్నే, కోన్బి హామ్న కామ్నా కోబులైలి గయూనికరి బోలమా, అనటేకె యో తుమేబి మార ద్రాక్చను బాగ్మా జైన్ కామ్ కరోకరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","హాఃజెహుయుతెదె యో ద్రాక్చను బాగ్‍మా మాలిక్ ఇను దాసుడ్ను మాలిక్నా దేఖిన్, కామ్ కర్యుతె ఇవ్నా బులైయిన్ పాసల్ ఆయుతె ఇవ్నేతి ధరీన్, అగాడి ఆయుతే ఇవ్నాలగు కామ్నా పైసా దా! కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","బరాబ్బర్‍ పాచ్ బజతోడి కామ్‍కర్యుతె అద్మి ఆయిన్, ఏక్నా యేక్ దేనారంనా ఎత్ర దిదూ. ");
INSERT INTO vgr_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","అగాడి ఖేథర్మా ఆయిన్ కామ్‍కర్యుతె ఇవ్నే హామ్నా ఘనూ రాప్యా మల్సేకరి సోచ్యా, పన్కి ఇవ్నబీ ఏక్నా యేక్ దేనారం మల్యు. ");
INSERT INTO vgr_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","ఇవ్నే ఇవ్నా భన్కిలీన్, ఆఖరీనా ఆయూతె ఇవ్నా ఎక్కాస్ గంటో ఎత్రేస్ కామ్ కర్యుతోబి, ");
INSERT INTO vgr_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","ధనక్కో మిన్హత్ కరీన్ తడ్కోనుమార్ ఖైన్, భరీంచతే హమారేతి ఇవ్నేతి బరాబ్బారస్, కర్యోనికరి యో ఘర్ వాలనఫర్ గాళేదీదు. ");
INSERT INTO vgr_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","అనహాఃజె ఇవ్నమా ఏక్జననా దేఖిన్ దోస్థ్, మే తున అన్యాయం కర్యొకొయిన్ని, తూ మారకనా ఏక్ దేనారంనా ఒప్పిలిదోని? ");
INSERT INTO vgr_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","తార రఫ్యానా తూ లీన్ జా; తునా దిదో తిమ్మాస్ పాసల్తీ ఆయుతే ఇవ్నా పైష్యా దేవనా మన ఇష్టంహుయు. ");
INSERT INTO vgr_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","మన ఇష్టం ఆయుతీమ్ మార సొంతపైస్యానా ఖర్చుకరను న్యాయం కాహేనా? మే అష్యల్ వాలోకరిరీ తునా పేట్మా చంఢాల్తి ఛానా? కరి పుఛ్చాయో! ");
INSERT INTO vgr_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","అమ్ని తరస్ అగాడిను అద్మి పీటెహుసె, పీటెనూఅద్మి అగాఢిహుసే. ");
INSERT INTO vgr_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","యేసునే యేరుషలేమ్నా జానుకరీథొ తెదె, యో ఇను భార సిష్యుల్నా కోణ్ కొయింతే తెదె బులైలిజంకరమా మారగ్ ఫర్ ఇవ్నేతి అమ్ బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","హదేక్ యేరుషలేమ్‍మా జంకరూస్; ఎజ్గా అద్మినో ఛియ్యోనా ముఖ్యంనో యాజకుల్‍బి షాస్ర్తుల్‍బి ఇనా ధార్యైదీసె, ఇవ్నే ఇనా మరణ్‍ను దంఢ్ దీసె. ");
INSERT INTO vgr_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","ఇనా ఛింగవానటేకెబీ కొల్డాతీ మరానటేకెబి, సిలువానాఖానటేకె యూదుల్‍ కాహెతె ఇవ్నా హాఃరవ్‍కనా ఇనా ధర్రాయ్‍దిసే; పన్కి తీన్మను ధన్నే యో బుజూ పాచో జీవుట్సే. ");
INSERT INTO vgr_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","తెదె జెబెదయినొ బావ్వన్‍ ఇను ఛియ్యోనాలీన్ యేసునా హాఃమె ఆయిన్, హఃలామ్ కరీన్ మాంగనికీ. ");
INSERT INTO vgr_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","తూ సాత్‍ కరూకరస్‍కరి ఇన పుఛ్చావమా! ఇన హాఃజె యో బైయికో తారు రాజ్యంమా ఆ మార బే ఛియ్యావ్‍మా ఏక్ జణనా తారు ఖవ్వాత్ బ్హనే ఏక్‍ జణనా తార డవ్హాత్ బ్హనే ఏక్ జణనా భేకనా అనుమతిదా! కరి ఇనేతి బోలి. ");
INSERT INTO vgr_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","అనటేకె యేసు బోల్యొ, తుమే సాత్ పుఛ్చాంకరస్కి తుమ్నా మాలంకొయిని, మే పీయిస్తే మిన్హత్‍ గిన్నిమాను తుమె పీషునా? కరి పుఛ్చావమా! ఇవ్నే పీసుకరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","యేసునే తుమె మారు మిన్హత్‍ గిన్నిమాను పీసు పన్కి మార ఖవ్హాత్ బ్హనేగాని డవ్హాత్ బ్హనేగాని బేహాఃడనూ మారహాత్మా కొయిని, మార భా కినా లీరాక్యోస్‍కి ఇన్నాస్ యో మ్హేల్సెకరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","ర్హైగుతే ధహ్ః అద్మి సిష్యుల్ యోవాత్ హఃమ్జీన్ యోబేజణ భైయ్యేఫర్ చంఢాల్‍కాద్యు. ");
INSERT INTO vgr_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","అనటేకె యేసు ఇవ్నా ఖందే బులైయిన్ యూదుల్‍ కాహెతె, యొక్క రాజుల్‍ ఇవ్నాఫర్‍ అధికారం వతాల్తూ ర్హాస్, మోట్టా ఇవ్నఫర్ అధికారం కర్నూకరి ర్హాస్, ఆ వాత్ తుమ్న మాలుంనా. ");
INSERT INTO vgr_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","తుమారమా ఇంనితరా నార్హాను; తుమారమా కోణ్ మహాన్‍వాలొహుయీన్‍ ర్హానుకరి సోచస్కి యో తుమ్నా సేవకర వాలంతరా ర్హాను. ");
INSERT INTO vgr_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","తుమారమా కోణ్ ముక్యంవాలనితరా ర్హానుకరి సోచస్కి యో తుమ్న దాసుడ్‍ హుయీన్ ర్హాను. ");
INSERT INTO vgr_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","ఇమ్మస్ అద్మినో ఛియ్యో సేవ కర్యైయిలేవనాటేకె కోఆయోని పన్కి, సేవ కరనాటేకె కెత్రూకి అద్మినాహాఃజె ఇను జాన్ దేవనాటేకె ఆయోకరీ బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","యేసు, సిష్యుల్‍ యెరికోతూ నిఖీన్, జంకరమా ఎజ్గను అద్మిహాఃరు ఇనకేడె గయూ. ");
INSERT INTO vgr_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","హదేక్ మారగ్నసేడె బేసీన్ ఛాతె బేజణా కాణాఅద్మీ యేసునే హింకడ్ జంకరస్‍కరి హఃమ్జీన్ దావీద్‍నో ఛియ్యో ప్రభూ, హమారఫర్ గోర్ కర్కరి ఛిక్రాన్‍ మ్హేంద్యా. ");
INSERT INTO vgr_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","గచ్చూప్‍ ర్హా! కరి జనాబొహాఃరు బోలీన్ గుర్కాయు, పన్కి ఇవ్నె ప్రభువా, దావీద్‍నొ ఛియ్యో, హమ్నా కనికరించ్‍కరీ అజు జరా గట్తీ ఛిక్రాన్ మ్హేంద్యు. ");
INSERT INTO vgr_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","యేసునే ఉబ్రీన్ ఇవ్న బులైయిన్ మే తుమ్నా సాత్ కర్నూకరీ పుఛ్చావమా! ");
INSERT INTO vgr_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","ఇవ్నె ప్రభూ హమార ఢోళనా నయంకర్ కరి బోల్యు. ");
INSERT INTO vgr_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","అనహఃజే యేసు ఇవ్నా వుప్పర్ గోర్‍కరీన్‍ ఇవ్నా ఢోళానా ఛిమ్యో; తెదేస్ ఇవ్నా ఢోళా కొలైయిగయూ, బుజు యేసునాకేడె గయా. ");
INSERT INTO vgr_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","యేసు, యెరూషలేమ్‍నూ కందెఛ్చాతె ఒలీవానుజాఢు పహాడ్నా కందెఛ్చాతె బేత్పగే గామ్‍మా ఆయెతెదె యేసు ఇను సిష్యుల్‍మా భే జణనా (అగాడి మొక్లొ) దేఖిన్; ");
INSERT INTO vgr_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","తుమ్నా హాఃమెఛ్చాతె గాంమ్మా జవో; గయాతెదే బాందిరాక్యుతే ఏక్ ఘదెఢు ఇనకేడెఛ్చాతె ఘదెఢను చెల్కూ తుమ్న దెఖావ్సే; ఇన చోడిలీన్ మారకనా హకలిలీన్ ఆవోకరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","కోన్బి తుమారితి సాత్బి బోల్యుతొ; ఆ ప్రభునాటేకె హోనుకరి బోలొ, ఎగ్గీస్ యో ఇనబోలి మొకలసేకరి బోలిన్ ఇవ్నా మొక్లొ. ");
INSERT INTO vgr_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","ప్రవక్త బోల్యొతె వాతె హువనటేకె అమ్‍ హుయు. యోసాత్కతో, ");
INSERT INTO vgr_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","హదేక్ తారొ రాజొ సాత్వికుడ్ హుయిన్, భోజొపాఢతే న్హాను ఘదెఢను చెల్కానావుప్పర్ బేసిన్ తారకనా వలావస్ కరి, సీయోన్ని ఛోరితీ బోలొ కరిబొలతె. ");
INSERT INTO vgr_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","తెదె సిష్యుల్ జైయిన్, యేసు ఇవ్నా ఆజ్ఞ దిదోతింమ్ ఇమ్మస్ కరీన్‍; ");
INSERT INTO vgr_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","యోఘదెడనా ఇను చెల్కాన హకలీన్ ఆయిన్ ఇనవుప్పర్ లుంగ్డనాఖమా యోలుంగ్డాఫర్ బేసిగో. ");
INSERT INTO vgr_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","ఎజ్గఛ్చాతె అద్మిమా ఘనూజణు లుంగ్డాన వాట్‍ లాంబు నాక్యు. థోడుజనూ జాఢనూ ఢాళియేనా కత్రిన్ వాట్ఫర్ లాంబు నాక్యు. ");
INSERT INTO vgr_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","జనాభో హాఃరవ్‍మా అగాఢి వలావతే ఇవ్నె, పాసల్తీ వలావతె ఇవ్నె దావీద్‍నా ఛియ్యోనా ప్రభువును నామ్తి, వలావతె యో స్తుతింపబడనుహువదా. స్వర్వోన్నతను హుయూతె జొగొమా హోసన్నా! జయహో! కరి ఛిక్రాన్ మ్హేంద్యా. ");
INSERT INTO vgr_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","ఇనె యెరూషలేమ్ను నంగర్మా ఆయోతెదె నంగర్నూ హాఃరుజణుబీ ఆ కోన్కరి గబ్రాయిగయూ. ");
INSERT INTO vgr_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","ఆ గలిలయమాఛ్చాతె నజరేతుతూ ఆయోతె ప్రవక్తహుయేతె యేసుకరి హాఃరుజణు బోల్యు. ");
INSERT INTO vgr_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","యేసు దేవ్ను ఆలయంమా జైయిన్, దంధొ కరుకరతే ఇవ్నా హాఃరవ్నా మొక్లిధీన్, రఫ్యా బద్లావతే ఇవ్నూ బల్లావ్నా, పర్వావ్నా ఏచుకరతే పీఠల్నా హేట్ దక్లిదీన్‍; ");
INSERT INTO vgr_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","మారు మందిరం ప్రార్థనా మందిరం బోలావ్సె; కరి లిఖ్కైరూస్, పన్కి తుమె ఇనా చోర్‍ కరతే గుహనీతరా కర్యాస్‍కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","కాణూబి, లంగ్డువాలుబీ, దేవ్నుమందిరంమా ఇనకనా ఆవమా ఇనే ఇవ్నా నయం కర్యో. ");
INSERT INTO vgr_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","హుయ్తో, అస్లి యాజకుల్‍, షాస్ర్తుల్‍ సిష్యుల్ యో కర్యోతె అద్భుతాల్‍నా, దావీద్‍నో ఛియ్యోనా జయహోకరీ దేవ్ను మందిరంమా ఛిక్రాన్ బేందుకరతే అడ్డాణి లడ్కావ్నా దేఖిన్ చంఢాల్ హుయిన్. ");
INSERT INTO vgr_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","అవ్నే బోలుకరతే తూ హఃమ్జుకరస్నా? కరి ఇనా పుఛ్చావమా, అనహఃజే యేసు హఃమ్జుకరూస్; లడ్కావ్‍నాటేకెబి అడ్డాణి లడ్కావ్‍నాహో మోఢవాటే స్తుతి బోల్యొయోకరి వాత్ తుమే కెదేబీ లేఖనంమా పఢ్యాకొయినిసూ? కరి ఇవ్నేతి బోలిన్‍ ");
INSERT INTO vgr_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","ఇవ్నా బెందీన్, నంగర్మాతూ నికీన్ బేతనియ జైన్ ఎజ్గా ర్హయో. ");
INSERT INTO vgr_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","వ్హానేకత్రే నంగర్మాతూ బుజు జంకరమా! ఇనా బుఖ్ లాగ్యూ. ");
INSERT INTO vgr_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","తెదె యేసునా, వాట్నాహాఃమె ఛాతె ఏక్ అంజురంను జాఝనా దేఖిన్; ఇనాకనా జావమా, యో జాఢనా దేఖమా ఖాలీ పాళొతప్ప, బుజు కాయిబీ దెఖ్కాయుకొయిని. ఇనటేకె ఇనా దేఖిన్ బుజుకెదేబి తునా పంఢా లాగ్సెకొయినీ; కరి బోల్యొ. తెదేస్ యో జాడూ ఖూకాయిజైన్ మరిగయూ. ");
INSERT INTO vgr_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","సిస్యుల్ ఇన దేఖిన్ అష్యంహుయీన్ అంజురంను జాఢు కెత్రే ఎగ్గీస్ కిమ్‍ హుఃఖ్కాయిగుకరి బొల్లీదు. ");
INSERT INTO vgr_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","అనహాఃజే యేసు; తుమె విష్వాసంతి ర్హైయిన్, సందేహ్‍ పడకొయినితిమ్ ఆ అంజురంనూ జాఢునా హుయుతిమ్ కరను యోస్ కాహే. ఆ ఫహాడ్నా దేఖిన్‍ తూ ఉటీజైన్ ధర్యావ్‍మా పడిజైస్‍కరీ బోల్యొతో తెదె ఇమ్మస్ హుసె, కరి తుమారేతి హాఃఛితి బోలుకురూస్. ");
INSERT INTO vgr_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","బుజు తుమె ప్రార్థనకరనూ వహఃత్ తుమె సాత్ మాంగస్‍కీ, యో తుమ్నా మాల్సేకరీ నమ్యాతెదె తుమె యోహాఃరు లీరాక్యస్‍కరీ ఇవ్నేతి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","యో దేవ్ను మంధిరంమా మ్హైయ్ దేవ్నువాతె బోల్తొ ర్హావమా ప్రధనాయాజకుల్‍బి అద్మియేనా మోటొబి, ఇనకనా ఆయిన్ కెహూ అధికారంను బారెమా తూ ఆకార్యంనా కరూకరస్? ఆ హక్కుహాఃరు తున కోణ్ దిదూకరీ పుఛ్చావమా! ");
INSERT INTO vgr_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","యేసు మేబీ తుమ్న ఏక్ వాత్ పుఛ్చావుస్; యో మారేతి బోల్యొతొతెదె మేబి కెహూ అధికార్తి ఆ కార్యాల్ కరూకరస్కి యో తుమారేతి బోలుస్‍. ");
INSERT INTO vgr_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","యోహాన్ దిదోతె బాప్తిస్మమ్‍ కెజ్గతు ఆయు? పరలోకంతూ ఆయుకి న్హైతొ అద్మియేతూ ఆయునా? కరి పుఛ్చాయో, ఇవ్నే, దేవ్కరి జవాబ్‍ దిదాతొ, బుజు ఇమ్ హుయుతో ఇనా ష్యాన నంమ్యకొయిని? కరి బోల్సె, ");
INSERT INTO vgr_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","అద్మియేకరి జవాబ్ బోల్యతో, అద్మియే హాఃరు యోహాన్ ఏక్ ప్రవక్తకరీ ఇనటేకె ఇవ్నే సాత్‍కర్సేకి, కరి ఇన ఢర్తి మలీన్ వాతె బొల్లీదు. ");
INSERT INTO vgr_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","ఇనాటేకె ఇవ్నె, హమ్నా మాలంకొయినీకరీ జవాబ్‍ బోల్య, యేసు మేబీ, కోణ్ ఆ కెహూ అధికార్తి కరూకరాస్కి, తుమ్నా కోబోలునీ, కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","తుమ్న సాత్ సొఛ్చావుంకరస్? ఏక్ అద్మినా భే! ఛియ్యా థా. యో మోటా ఛియ్యాకనా ఆయిన్ ఛియ్యా, తూ జైన్ అంగూర్ను బాగ్‍మా కామ్కర్‍కరి బోలమా. ");
INSERT INTO vgr_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","ఇనె కోజవ్నికరి బోల్యు, అజు జరగడ్తీ దిల్ బాద్లైయిలీన్ జాస్. ");
INSERT INTO vgr_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","ఇను బెంమ్మనూకనా ఆయిన్‍ ఇమ్నితరసబోలమా యో మాలిక్‍, జైయిస్‍ కరి బోల్యు పన్కి కోజాయిని. ఇవ్నా భేహెమా కోణ్ మార వాత్‍ఫర్ చాలుకరాస్. ");
INSERT INTO vgr_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","ఇనటేకె ఇవ్నే మోటొ ఛియ్యోస్‍కరి బోల్యా. యేసు సుంకరూర్బి ఇవ్నేతి అమ్ బోల్యొ, మే తుమ్నా హాఃఛిస్ బోలుకురూస్, సుకరూల్బి వేష్యుల్బి తుమారేతి అగాఢి దేవ్ను రాజ్యంమా జాషె. ");
INSERT INTO vgr_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","యోహాన్‍ను నీతి వాట్‍ఫర్‍తూ తుమారకనా ఆయు, తుమె ఇనా నమ్యాకొయిని; బుజు సుంకరూల్బి వేష్యల్‍బి ఇన నంమ్యా; తుమె యో దేఖిన్‍బి ఇనా నంమ్యతీమ్ పష్చాతాపమ్‍ కోపడ్యుని. ");
INSERT INTO vgr_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","బుజేక్ ఉపమానం హఃమ్జొ, ఘేర్నొ మాలిక్ ఏక్ థొ. యో ఏక్ అంగూర్ను బాగ్‍ నాక్యొ, ఇనా అష్పీస్ భీత్ బంధాయో, ఇన్మా అంగూర్ను రహ్క్ కాఢనటేకె ఏక్ టొట్టి బంధాయో, కావ్లినా బాగ్‍ రవ్వాలనా దీన్ దేహ్క్ మా యాత్రకరనా చలీగయో. ");
INSERT INTO vgr_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","బాగ్‍ పిఖ్కాయుతెదె తోడను ధన్‍మా ఇను బాగ్ లీన్ ఆవనాటేకె యో కావ్లివాలకనా ఇనా దాసుల్‍నా బోలిమోక్లొ. ");
INSERT INTO vgr_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","యో కావ్లివాలు ఇనా దాసుల్‍నా ధరీన్ ఏక్నా మార్యొ, బుజేక్నా మర్రాకిదీదా, బుజేక్ జణనా ఫత్రాంతీ మార్యు. ");
INSERT INTO vgr_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","బుజేక్ చోట్ యో అగాఢితీబి జాహఃత్ అలాదు దాసుల్‍నా బోలిమోక్లమా, ఇవ్నే ఇవ్నబీ ఇమ్నీతరస్ కర్యూ. ");
INSERT INTO vgr_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","అనటేకె, యో మార ఛియ్యోనా సన్మానం కర్సేకరి సోచిలీన్‍ ఇన ఛియ్యాన ఇవ్నకనా మొక్లో. ");
INSERT INTO vgr_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","హుయుతోబి యో కావ్లివాల ఇనా దేఖిన్ ఆ వారసుడ్; అనా మర్రాఖిదీన్ ఇను ఆస్థిమొత్తం లీలియే, ఇవ్నమా ఇవ్నే బొల్లీన్‍ ");
INSERT INTO vgr_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","ఇనా ధర్లీన్ అంగూర్ను బాగ్‍మా బాధర్ లీజైన్ మర్రాఖిదేస్. ");
INSERT INTO vgr_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","అనటేకె యో అంగూర్ను బాగ్‍నో మాలీక్ ఆయోతెదె, యో కావ్లివాలనా సాత్ కర్సెకరీ పుఛ్చావమా. ");
INSERT INTO vgr_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","ఇనటేకె ఇవ్నే దుర్మార్గుల్నా కఠీన్‍తీ మర్రాఖిదీన్, ఇను ఇనూ ధన్మాబీ ఇనా పండంవ్నా ఫేడాహఃర్కు అలాదుకావ్లివాలనా యో అంగూర్ను బాగ్‍నా గుత్తనాదిసేకరి ఇనేతి బోల్యు. ");
INSERT INTO vgr_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","బుజు యేసు ఇవ్న దేఖిన్, ఘర్ భాందవాలు కామె ఆవకొయింతె భండోస్ మూలనా ముడ్క్యాను బండొహోస్, ఆ ప్రభూ బారెమాస్‍ హుయు. ఆ అప్న ఢోలనా అష్యంహువస్‍కరీ వాత్ తుమె లేఖనాల్‍మా కెదేబీ పఢ్యాకొయిన్నా? ");
INSERT INTO vgr_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","అనటేకె దేవ్ను రాజ్యం తుమారకంతూ ఛినైయిల్‍దు, ఇను ఫలం అద్మియేనా దిసేకరి తుమారేతి బోలుకరూస్‍. ");
INSERT INTO vgr_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","బుజు ఆ బండఫర్ పడ్యుతే అద్మి టుక్డహుయి జాసే, పన్కి కినావుప్పర్ ఆబండో పడస్కి యో మహ్లినాక్సె. ");
INSERT INTO vgr_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","ప్రధానా (నెయ్యో) యాజకుల్‍బీ, పరిసయ్యుల్‍బి, యేసు బోల్యొతె ఉపమానంనా హఃమ్జీన్, అప్నబారెమాస్‍ బోల్యుకరి లైహిగు. ");
INSERT INTO vgr_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","ఇవ్నె ఇనా ధర్లేవనాటేకె వహఃత్నా ధూండు కర్తథా, పన్కి అద్మిహాఃరు ఇనా ఏక్ ప్రవక్తకరీ యెంచిలీదు ఇనటేకె ఇవ్నా దేఖిన్ ఢరీగు. ");
INSERT INTO vgr_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","యేసు ఇవ్నా హాఃరవ్నా జవ్వాబ్ దేతోహుయిన్, బుజుపాచు ఉపమానంనీతరా అమ్ బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","స్వర్గంను రాజ్యం, ఇను ఛియ్యానా య్హాను ఖాణు బనాయోతిమ్ ఏక్ రాజనా పోలిన్‍ ఛా. ");
INSERT INTO vgr_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","యో య్హానా బులాయ్‍ మంగాయుహూ ఆవదేవనాటేకె యో ఇను దాసుల్‍నా బోలిమొక్లొతెదె ఇవ్నే కోఆయుని. ");
INSERT INTO vgr_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","పన్కి, ఇనే హాదేక్ మే ఖానునా తయార్‍ కరిరాక్యోస్‍; డాంఢవ్నా బల్సీగూతే డాఢనా కత్రిరాక్యూస్‍; హాఃరుస్‍ బనైయిన్ తయార్ హుయిన్ ఛ్చా! య్హానూ ఘర్కనా ఖాణు ఖావాన ఆవోకరీ బులాయూతె ఇవ్నేతి బోల్కరి అలాదు దాసుల్నా బోలిమొక్లా పన్కి ");
INSERT INTO vgr_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","ఇవ్నే లెక్క కర్యుకొయిని, ఏక్జనో ఇను ఖేతర్‍మా బుజేక్జనో దంధొకరనా గయా. ");
INSERT INTO vgr_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","ఛాతె ఇవ్నే ఇనా దాసుల్నా ధర్లీన్ అవామానంనా కరీన్ మర్రాఖిదేస్. ");
INSERT INTO vgr_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","అనహాఃజే రాజొ చంఢాల్‍హుయిన్ ఇను సైనికుల్‍నా మొక్లీన్, యో అద్మినా మర్రాఖవాలనా మర్రాఖిదీన్, ఇను నంగర్మా బల్లాకిదీదు. ");
INSERT INTO vgr_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","తెదెయో, య్హాను ఖాణు ఛా పన్కి తయార్‍ హుయూతె దాసుల్‍ ఇవ్నె యోగ్యాత కాహే. ");
INSERT INTO vgr_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","అనటేకె రాజోను గల్లియేమా జైన్ తుమ్న కోణ్ దెఖ్కావస్కి ఇవ్నా హాఃరవ్నా య్హాను ఖాణు ఖావనా బులావోకరి ఇను దాసుల్తీ బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","యో దాసుల్‍ గల్లిమా ఫర్ జైన్ కర్రాబ్ అద్మినాహో అష్యల్ అద్మినాహో తుమ్నా దెఖ్కావతే హాఃరవ్నా గుమ్మల్నితరా బ్హరాయు ఇనటేకె య్హాను ఖాణు ఖావనా ఆయుతే ఇవ్నేతి య్హాను పందీర్‍ బ్హారైయిగు. ");
INSERT INTO vgr_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","రాజొ బెసీరూతె ఇవ్నా దేక్నుకరి మహిజైయిన్, ఇజ్గా ఛాతె ఇవ్నమా ఏక్జను య్హాను లుంగ్డా కోపేర్యునికరీ దేక్యూ. ");
INSERT INTO vgr_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","దోస్త్! తూ య్హానా లుంగ్డా పేర్యొకొయినితిమ్‍ మైహికీమ్ ఆయోకరి ఇనా పుఛ్చావమా యో సోపోతు. ");
INSERT INTO vgr_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","తెదెస్ రాజో క్హంజీన్, హాత్ గోడా భాందీన్ బాధర్ అంధారమా పేకీదేవో; ఇజ్గా రోవనుబీ దాత్ చావను ర్హాసెకరీ ప్రచార్‍కర వాలంతి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","పన్కి బులైయి రాక్యుతే అద్మియే ఘనుజణు, పన్కి బులాయుతే అద్మి దాసుల్‍స్కరీ బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","తెదె పరిసయ్యుల్ జైన్, వాతేవాతేమా ఇనా పహాఃనుకరీ సోచుతూహుయిన్, యేసునా ప్రస్నా నాఖ్యు. ");
INSERT INTO vgr_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","తెదే ఇవ్నే పరిసయ్యూల్ నుబి బుజు థోడా సిష్యుల్నాబుజు హేరొద్‍ను బాజును బొలిమోక్లి. బోధకుడ్, తూ హాఃఛికరి, దేవ్ను మారగ్నా ఛాతె తిమ్మాస్ బోలాస్ కరి హామ్నా మాలం, తు కీనాబీ గురీ కోరాఖానీ కరి మోమాటం కోయినీతే అద్మికరి హామ్నా మాలం. ");
INSERT INTO vgr_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","తునా సాత్ సోఛ్చాంకరస్? రోమను కామ్ దేవను న్యాయమాస్ నా? కాహేనా? హమారేతి బోల్‍కరి పుఛ్చావనాటేకె హేరోద్తిబి ఇనా సిష్యుల్నా ఇనాకన బోలిమొక్ల్యా. ");
INSERT INTO vgr_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","యేసు ఇవ్నా గాలీజ్ హాఃయల్ మాలం కరిలీన్, ఉపర్ను పేరాహాఃను అద్మి! మన షాన త్హార్‍ హఃతాంకరాస్‍. ");
INSERT INTO vgr_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","పన్నుభాందతే దేనారం యో మన వతాలోకరి ఇవ్నేతి బోలమా, ఇవ్నె ఏక్ దేనారంనా లాయు. ");
INSERT INTO vgr_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","తెదె యేసు, ఆ రూపంబి ఉపర్ను రాతా కినూకరీ పుఛ్చావమా, ఇవ్నే రోమా చక్రవతినుకరి బోల్యా. ");
INSERT INTO vgr_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","ఇనటేకె యేసు, ఇమ్ హుయుతో రోమాను రోమానా, దేవ్ను దేవ్నాస్ దెవోకరి, ఇవ్నెతి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","ఇవ్నే ఇను వాత్ హఃమ్జీన్ హాషంకైయిన్ ఇనా బేందీన్ చాలిగయూ. ");
INSERT INTO vgr_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","యోస్ ధన్నే మరీగూతె పాచ్చుఫరిన్‍ పునరుత్థానం కొయినీకరి బోలనటేకె సదూకయ్యుల్ యేసుకనా ఆయూ. ");
INSERT INTO vgr_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","బోధకుడ్. ఎక్జను లడ్కా కోయినికరి మరీజాస్ తో ఇనో భై ఇని బావన్నా య్హా! కరిలీన్ ఇనా భైనా లడ్కా ఫైయిదాకరి దేవజైయికరి మోషే బోల్యొని. ");
INSERT INTO vgr_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","హామారమా హాఃత్‍జణా భైయియేత్హా అగాడీను య్హా కర్లీన్ లడ్కా కొయినితిమ్‍ మరీగయో; ఇనా లడ్కా కోయినికరి ఇనో భై ఇని బావనా రాఖిలిదో. ");
INSERT INTO vgr_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","బెంమ్మనోబి తీన్ మానోబీ ఖాంత్మనా వాలకనబీ లడ్కా కొయినికరి మరీగయా. ");
INSERT INTO vgr_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","హాఃర్వానా ఫీటె యో బాయికోబి మరీగయి, ");
INSERT INTO vgr_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","పునరుత్థానంమా యో హాఃత్ జణమా యో బాయికో కినా బావన్నితరా ర్హాసె? యో బాయికొ ఆ హాఃత్ జణబీ బావన్‍నితరా పుఛ్చాయో? ");
INSERT INTO vgr_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","అనటేకె లేఖనంనాహో దేవ్ని థాఖత్నాహో మాలంకొయింతె తుమె తొందరపడూకరస్‍. ");
INSERT INTO vgr_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","మర్యుతే అద్మి జీవివుట్టీన్‍ కోన్బి య్హా కర్షెకొయిని, య్హా కరనా దెవ్వాసెకొయిని; ఇవ్నే స్వర్గంమా ఛాతే దేవ్నుదూతల్‍నితరా ర్హాసె. ");
INSERT INTO vgr_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","మరణ్‍నూ పునరుత్థానంను బారెమా, సాత్‍ లిఖ్కాయ్‍‍రూస్‍కరి తుమె పడ్యాకొయిన్నా? కరి పుఛ్చాయో. ");
INSERT INTO vgr_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","మే అబ్రాహామ్‍నో దేవ్, ఇస్సాక్‍నొ దేవ్‍కరి, యాకోబ్ దేవ్‍హుయూన్ ఛా. ");
INSERT INTO vgr_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","యో జీవిన్‍ ఛాతె ఇవ్నస్ దేవ్ పన్కి, మర్యాహుయునా దేవ్ కాహెకరి ఇవ్నేతి బోల్యొ, అద్మియే ఇను వాత్ హఃమ్జీన్ అష్యంహుయు. ");
INSERT INTO vgr_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","తెదె సద్దూకయ్యుల్‍నూ మ్హోడు ముఛ్చాయోకరి పరీసయ్యుల్ హఃమ్జీన్‍ జావనటేకె మలీన్‍ ఆయా. ");
INSERT INTO vgr_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","ఇవ్నమా ఏక్జను ధర్మషాస్త్రం దేఖ్ను ఇనా హఃతావ్తూ హుయీన్. ");
INSERT INTO vgr_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","బోధకుడ్, ధర్మాషాస్ర్తంమా ముఖ్యమ్‍ను ఆజ్ఞ కెహూ కరి పుఛ్చాయో. ");
INSERT INTO vgr_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","ఇనటేకె యేసు, తారు పూర్ణ ఆత్మతి తారు పూర్ణ దిల్తీ తారు దేవ్‍హుయోతె ప్రభువునా ఫ్యార్‍ కర్నూకరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","ఆస్‍ ముఖ్యంబి, వుజు అస్లి ఆజ్ఞ. ");
INSERT INTO vgr_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","తున తూ కింమ్‍ ఫ్యార్‍ కరస్కి, ఇమ్మస్‍ తార అగల్నా, బగల్నాబి ఫ్యార్ కర్నూ, ఆ బెంమ్మను ఆజ్ఞబి ఇనింతరస్‍ జోక్నుస్‍. ");
INSERT INTO vgr_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","ఆ బేహె ఆజ్ఞబి మోషె ధర్మషాస్ర్తం ప్రవక్తనూ బోధ భరోసాహుయిన్ ఛా! కరి ఇనేతి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","తేదె థోడు పరిసయ్యుల్ మలీన్ ఆవమా, యేసు ఇవ్నా పుచ్ఛాయో. ");
INSERT INTO vgr_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","క్రీస్తునా బారెమా తుమ్న షాత్ సొఛ్చాంకరాస్? ఇనె కినొ ఛియ్యోకరి పుఛ్చాయో. ఇవ్నే యో దావీద్‍నో ఛియ్యోకరి బోల్యా. ");
INSERT INTO vgr_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","ఇనటేకె యో ఇంహుయూతొ మే తార వైరియేనా తార గోఢనహేట్ రాఖతోడి. ");
INSERT INTO vgr_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","తూ మార ఖవ్వాహాత్ మాండిఫర్‍ బేహ్ఃకరి ప్రభూ మారొ ప్రభుతి బోల్యొ, కరి దావీద్ యో ప్రభుకరి ఇని ఆత్మతి కిమ్ బోలుకరస్. ");
INSERT INTO vgr_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","దావీద్‍ ఇనా ప్రభుకరి బోల్యొతొ, యోకిమ్ ఇనా ఛియ్యో హోను? కరి పుఛ్చావమా కోన్బి బుజేక్ వాత్ కొబోల్యని. ");
INSERT INTO vgr_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","బుజు యో ధన్తూ కోన్బి ఇనా ఏక్ ప్రష్నబి కోపుఛ్చాయుని. ");
INSERT INTO vgr_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","తెదె యేసు అద్మినుపాంబల్‍నబీ ఇను సిష్యుల్తీబి అమ్ బోల్యు ");
INSERT INTO vgr_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","మోషే నియమ షాస్ర్తంనా హాక్కుతి బోలనుకరి నియామషాస్ర్తుల్బి, పరిసయ్యాల్బి అధికారం ఛాకరి బోధించుకరస్‍. ");
INSERT INTO vgr_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","అనటేకె ఇవ్నే బోలతెహాఃరనబి కర్నూకరి బొలాస్‍ పన్కి, ఇవ్నే బోలస్ పన్కి, కరకొయినీ. తుమే ఇవ్ను కామ్నామాత్రం కరొనొకొ ");
INSERT INTO vgr_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","ఢ్హొవ్వాన హువకొయింతె యెత్రె వజణ్నా బాంధీన్ అద్మిను భుజ్‍నవుప్పర్ ఇవ్నే బెంద్చే. పన్కి ఇవ్నే పల్లిజావనా ఇవ్నా చిట్టాంగ్లి ఏత్రె మద్దత్‍కరనా తయార్‍ హువకొయిని. ");
INSERT INTO vgr_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","అద్మియేన దెఖ్కానుకరి ఇవ్ను కామ్ హాఃరుబి కరస్; బుజు ఇవ్ను హాత్నా దేవ్ను వాక్యం భాదింలీన్‍, బుజు ఇవ్ను ముడ్క్యానా వాక్యంను పట్టి భాందిన్‍ లుంగ్డాను మోటా కరీన్‍ పేరస్‍; ");
INSERT INTO vgr_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","ధాన్ ఖావను బంతియేమా మాహాన్‍ జోగోమా రాహ్నుకరి యూదుల్ను ప్రార్థనా న్యావ్ను ఉచు జోగొమా స్తానం హోనుకరి సోఛస్‍. ");
INSERT INTO vgr_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","సంత గల్లీయమా హఃలామ్ కరాయ్‍లేనుకరి అద్మియేనహాతె గురువు బొలాయ్‍లేనుకరి ఇవ్నా ఘాను ఇష్టం. ");
INSERT INTO vgr_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","తుమె గురుకరి బొలాయిలేవో నొకొ, తుమె హాఃరుజణు భైయేయ్. ఇనటేకె తుమ్నా ఎక్కస్ జణొ గురువు, ");
INSERT INTO vgr_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","బుజు జమీన్‍ఫర్ కినాబి భా కరి నామ్ నొకొబేంద్చు. స్వర్గంమాఛ్చాతె దేవ్ ఎక్కాస్ జణొ తుమారొ భా. ");
INSERT INTO vgr_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","ఎత్రేస్ కాహేతిమ్, తుమె గురువుల్కరి బొలాయ్ లేవొనొకొ; క్రీస్తు ఎక్కస్ జణొ తుమ్నా గురువు. ");
INSERT INTO vgr_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","తుమారమా హాఃరతీబి గొప్పవాలో తుమ్నా ప్రచార్‍ కరవాలొహుయిన్ ర్హాను. ");
INSERT INTO vgr_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","ఇను యోస్ హెఛ్చించిలీన్ ర్హవ్వాలో తగ్గించిబడ్చే ఇనుయోస్ తగ్గించిలీన్ ర్హవ్వాలో హెఛ్చించి బడ్చే. ");
INSERT INTO vgr_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","నియామషాస్ర్తం పండితువాలా, పరిసయ్యుల్‍వాలా, తుమె ఘను మిన్హత్‍, దేవ్ను రాజ్యంనా అద్మియే నా జానుతిమ్‍ దార్వాజు మూఛినాక్చూ తుమె ఇన్మా జాయ్‍ కొయిని, జాయ్తె ఇవ్నా జావకోదేయిని. ");
INSERT INTO vgr_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","ఇవ్నే, విధువారాల్‍నా దవ్లాత్‍నా లూటిలేంకరస్‍, బుజు అద్మియేనా వతాలనాటేకె మోటు ప్రార్థన కరస్‍, ఇనటేకె తుమ్నా మోటు షిక్చా ఆవ్సె. ");
INSERT INTO vgr_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","వేషధారూల్‍హుయాతె నియామషాస్ర్తుల్, పరిసయ్యుల్‍వాలా, ఇవ్ను తుమ్నా మలావనా గుంపుమటేకె ప్రాయిత్నిచాస్‍, తుమె ధర్యావ్నాబి, జమీన్నా ఫరీన్‍ ఆవస్‍ ఇనే మలీన్‍ ర్హావనీ వహఃత్‍ ఇనె తుమారతీబి బెంమ్మానుతరా నరక పాత్రునితరా కర్సే. ");
INSERT INTO vgr_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","అయ్యో, కాణుహుయీన్‍ అలాదవ్నా వాట్‍ వతాలవాలా తుమ్నా షిక్చా తక్చెకొయిని. తుమె బోలస్‍ కాహేనా కోన్బి మందిరమం తోడుకరి ఒట్టు మేంమ్లిదుతొ ఇన్మా కాయ్బి కొయిని పన్కి, మందిరంమా ఛాతె ఘేణు ఫర్‍ ఒట్టు మేంల్లిదుతో తుమే ఇనా కట్టూబడీన్‍ ర్హానుకరి బోల్చు. ");
INSERT INTO vgr_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","బుధ్దికొయింతెవాలా, ఖాణావాలా కెహూ గొప్పా? ఘేణూకి, ఘేణునా పరిసుద్ధ్‌ కరతె మందిరంనా? ");
INSERT INTO vgr_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","బుజు బలిపీఠంతోడుకరి ఏక్జనో ఒట్టు మేంమ్లిదుతొ ఇన్మా కాయ్బి కొయిని పన్కి, బలిపీఠంను వుఫ్పర్‍ఛాతె అర్పణనా తోడుకరి ఒట్టు మేంల్లిదుతో తుమే ఇనా కట్టుబడీన్‍ ర్హానుకరి బోల్చు. ");
INSERT INTO vgr_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","బుధ్దికొయింతెవాలా, ఖాణావాలా కెహూ గొప్పా? అర్పణ కార్యుతేకి, అర్పణనా పరిసుద్ధ్‌కరతె బలిపీఠంనా ");
INSERT INTO vgr_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","బలిపీఠం తోడుకరి ఒట్టు మేందవాలొ, ఇనా తోడుకరిబీ ఇనఫ్పర్‍ఛాతె యోహాఃరు తోడ్నుకరి ఒట్టు మ్హేందిలెంకరస్‍. ");
INSERT INTO vgr_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","బుజు మందిరంమ్‍ ఒట్టు మ్హేందిలేవాలొ, ఇనా దేవ్ ఫర్‍ ఒట్టు మ్హేందిలెంకరాస్‍. ");
INSERT INTO vgr_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","బుజు పరలోకంఫర్‍ ఒట్టు మ్హేందవాలొ దేవ్ని సింహాసనంఫర్‍ ఇనఫర్‍ బెట్టతెయిన ఒట్టు మ్హేందిలెంకరస్‍. ");
INSERT INTO vgr_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","అయ్యో, వేషధారుల్‍హుయాతె షాస్త్రుల్‍, పరిసయ్యూల్‍, తుమె పుదీనామాబి, సోపుమా, జీలకర్రమాబి ధహ్ః మనుభాగ్‍ ఫేడస్‍ పన్కి, ధర్మషాస్ర్తంమా ముఖ్యంనుహూయ్తె విషయాల్నాబి, న్యాయంబి, కనికరంనాబి, విష్వాస్‍నా బెందిదా; ఆహాఃరు కరకొయినితిమ్‍ యోహాఃరు కరూకరస్‍. ");
INSERT INTO vgr_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","ఖాణుహుయాతె నియమాషాస్ర్తంమా తుమారు తుమేస్‍ కెహూ ముఖ్యంహుయూతె కెహూకి ఇనా అనుసరించస్‍, పన్కి ఘణు ముఖ్యంహుయూతె ఇనా తుమె బెందెంకరస్‍ న్హాను విషయాల్నా నాపట్టించకొయినితిమ్‍, మోటు విషయాల్నా గలిలేంకరతె తుమేస్‍. ");
INSERT INTO vgr_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","అయ్యో, వేషధారూల్‍హుయాతె నియమషాస్ర్తల్‍, పరిసయ్యూల్‍, తుమె గిన్నినాబి తాంబ్యొనాబి బ్హాధర్‍ దొవ్వాస్‍ పన్కి, యో మహీ లపాడనూ ఆహ్ఃతి బరైరూస్. ");
INSERT INTO vgr_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","కాణు హుయితే పరిసయ్యూడ్‍, గిన్నెమాబి తాంబ్యొమాబి బ్హాధర్‍ దొవ్వాను అగాడి ఇను మ్హైను దొవ్జొ. ");
INSERT INTO vgr_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","అయ్యో, వేషధారూల్‍ హుయుతె నియమషాస్త్రుల్‍, పరిసయ్యూల్‍, తుమె సున్నొ మార్యుతె సమాధినితరా పోలిన్‍ ఛా. యో బ్హాధర్‍ అష్యలస్‍ దెఖ్కావస్‍ పన్కి, మహీ మర్యుగూతె ఇవ్ను హడ్‍క్యాతి, సమస్తంహూయుతె గంధతీ భరాయిన్‍ ఛా. ");
INSERT INTO vgr_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","ఇమ్మస్‍ తుమె బార్లు అద్మినా నీతిమంతునిఘోని దెఖ్కాంకరాస్‍ పన్కి, మ్హైయీ వేషధారూణహుయూతె పాప్‍తీబి కరాబ్‍కామ్‍తీబి బ్హరాయిన్ ఛా. ");
INSERT INTO vgr_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","అయ్యో, వేషధారణలతోను, నియమషాస్రూల్‍, పరిసయ్యూల్‍, తుమ్నా మిన్హత్‍ ప్రవక్తల్నూ ఘొరాఢవ్నా బంధాంతూహుయిన్‍, నీతిమంతుల్ను గొరాఢవ్నా అలంకరిచిలెంకరస్‍ కరూకరాస్‍. ");
INSERT INTO vgr_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","అప్నె అప్ను భాను భానా ధన్మా ర్హైయ్యాతొతెదె ప్రవక్త్ లను మరణ్‍ను విషయంమా ఇవ్నేతి మలీజావాలహుయీన్‍ ర్హయ్యావోత్‍ కొయినీకరి బొల్లిసు. ");
INSERT INTO vgr_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","అనటేకేస్‍ తుమె ప్రవక్త్ లనా మార్యూతె ఇవ్ను ఛియ్యాహుయీన్ఛాక‍రి తుమారఫ్పర్‍ తుమేస్‍ సాబుత్‍ బొల్లెంకరాస్‍. ");
INSERT INTO vgr_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","తుమేబి తుమారు భాను భా కామ్నా పూర్తికరొ. ");
INSERT INTO vgr_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","హాఃప్‍వాలా, హాఃప్ను సంతాన్‍వాలా, నర్కంనూ ఢన్డ్ మతూ తుమె కింమ్నితరా బఛ్చిజాసు? ");
INSERT INTO vgr_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","అనటేకే హదేక్‍ మే తుమారకనా ప్రవక్తల్నా, జ్ఞానుల్నా, నియమషాస్ర్తుల్నా, మొక్లుకరూస్‍ తుమే ఇవ్నామా థోడుజననా సిలువునా నాక్చె, థోడుజననా మర్రాక్చె, థోడుజననా తుమారు యూదుల్‍ ప్రార్థనకరాను జొగొమా కొల్డాతీ మారీన్‍, హఃయర్‍మతూ నిఖీన్‍ హఃయర్మా థోడుజననా నక్హాడ్చె. ");
INSERT INTO vgr_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","నీతమంతుడ్‍హుయోతె హేబెల్‍ ల్హొయితూ ధరీన్‍ బలిపీఠంనాబీ, మందిరంనాబి ఇచ్మా తుమె మర్రాక్యతె బరకీయ ఛియ్యోహుయోతె జెకర్యా ల్హొయితోడి జమీన్‍ఫర్‍ చిడ్కాయూతె నీతిమంతుల్నూ ల్హొయిహాఃరు తుమారఫర్‍ ఆవ్సె. ");
INSERT INTO vgr_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","ఆహాఃరూబి ఆ పిఢీను వాలఫర్‍ ఆవ్సెకరీ తుమారీతి హాఃఛితి బోలుకరూస్‍. ");
INSERT INTO vgr_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","యెరూషలేమ్, ప్రవక్తల్నా మర్రాక్తాహుయీన్బి తారకనా మొక్లొతెయివ్నా పత్రావ్తీ మార్తాహుయీన్ రవ్వాలా, కుక్డి ఇను లడ్కావ్నా కిమ్‍ పాక్డిమా హేట్‍ చెరాయ్‍లేస్కి ఇమ్మాస్‍ మేబి తార లఢ్కావ్నా కెత్రూకిచోట్‍ చేరాయ్‍లేనుకరీ దేక్యొ పన్కి, తుమె ఇష్టపడ్యాకొయిని. ");
INSERT INTO vgr_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","హదేక్‍ తుమారు మంరంనా ఖాలీతి వ్యర్థంతి తుమ్నా బెందాయిన్‍ ఛా. ");
INSERT INTO vgr_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","హంకేతు నిఖీన్‍ ప్రభువునూ నామ్తీ వలావతేయో స్తుతించబడదాకరి తుమె బోలతోడి మన దేక్చూకొయినీకరి తుమారీతి బోలుకరూస్‍. ");
INSERT INTO vgr_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","యేసు దేవ్ను ఆలయంమతూ నిఖిన్ జంకరమా, ఇను సిష్యుల్ యో దేవ్ను ఆలయంనా బాంది రాక్యుతె ఇనా వతాలనాటేకె ఆయా. ");
INSERT INTO vgr_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","ఇనటేకె యో, తుమె ఆహాఃరు దేకుకరస్ని కాహెనా; ఆ బంఢొఫర్ బంఢొ ఏక్తోబి అజ్గ ఉబర్సెకొయినితిమ్‍ పడ్జాసేకరి తుమారేతి హాఃఛితి బోలుకరూస్‍కరి ఇవ్నేతి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","పన్కి, యేసు ఒలీవను ఫహాడ్‍ఫర్ బేసిన్తొతెదె సిష్యుల్‍మా హాఃరుజణూ మలీన్ ఇనకనా ఆయిన్, ఆకెదె హుసె? తూ ఆవనూ ఆ యుగసమాప్తినాబి సూచన కెహూ? హమారేతి బోల్‍కరి పుఛ్చాయా. ");
INSERT INTO vgr_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","యేసు ఇవ్నేతి అమ్ బోల్యొ, కోన్బి తుమ్న మోసం కరకొయినితిమ్ దేఖిలెవొ. ");
INSERT INTO vgr_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","సానకతొ కెత్రూకి జణు మారనామ్తి ఆయిన్, మేస్ క్రీస్తుకరి బోల్తూహుయీన్ ఘనుజణునా మోసం కర్సె. ");
INSERT INTO vgr_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","బుజు లఢాయ్‍నాటేకె, లఢాయ్‍ను వాతేనాటేకె తుమె హఃమ్సు; తుమె గబ్రాసునొకొతింమ్ ర్హహో. ఆహాఃరూ హువనూస్‍ ఛా పన్కి, అంతం ఎగ్గీస్‍ ఆవ్సెకొయిని. ");
INSERT INTO vgr_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","అద్మినా వుప్పర్ అద్మీ, రాజ్యంనా ఉప్పర్ రాజ్యమ్ ఉట్సె. ");
INSERT INTO vgr_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","ఎజ్గయెజ్గా ఖాల్, భూకంపాల్బి హుసె; ఆహాఃరు జనావనూధన్ హుయూతె సురూహుంకరస్‍. ");
INSERT INTO vgr_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","తెదె జెద్మియే తుమ్న మిన్హత్‍ కరనా ధరాయ్‍దీన్‍ మర్రాక్చె. జనభో హాఃరు తుమ్న కెత్రూకి హింస కరాయిన్ మర్రాక్చె. తుమె మారు నామ్‍మా కెత్రూకి అద్మినహాతె దుష్మన్‍ హుసు. ");
INSERT INTO vgr_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","త్యొ వహఃత్ ఘనుజణూ విష్వాస్‍నా ఏక్నా యేక్ ధరాయ్ దీన్, ఏక్నా యేక్ దుష్మాన్ హుసే. ");
INSERT INTO vgr_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","గ్హనుజణు ఝాడ్‍ ప్రవక్తల్ ఆయిన్, కెత్రూకిజణవ్నా మోసంకర్సే. ");
INSERT INTO vgr_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","అధర్మం కర్రాబ్‍కామ్ జాహాఃత్ హువమా కెత్రూకి అద్మియేనూ ఫ్యార్‍ కంమ్ హుసే. ");
INSERT INTO vgr_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","హంకెతూ నికీన్‍ అంతమ్ విష్వాస్‍వాలనితరా ఆఖిరితోడీ కోణ్ హఃమాలిలీన్‍ రాహ్‍స్కి యోస్‍ బఛ్చావ్సె. ");
INSERT INTO vgr_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","బుజు యోరాజ్యం సువార్త అద్మియే హాఃరవ్నా హాఃఛిహుయీన్‍ ర్హాసె సువార్త ములక్ అక్కుబీ ప్రచార్‍హుసె; ఇనపాసల్‍ అంతమ్ ఆవ్సె. ");
INSERT INTO vgr_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","అనహాఃజె ప్రవక్తహుయోతె దానియేల్ను బారెమా బోల్యొహుయూతె నాష్‍ హుయుతె ఉజ్జాడ్ను రాచు, పవిత్రంను జొగొమా ఉబ్రనూ తుమె దేక్చూ. ఫడవాలొ మాలంకర్సె. ");
INSERT INTO vgr_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","తెదె యూదయమా రవ్వాలు ఫహాడ్ నావుప్పర్ మిలాయ్‍లేవనూ అష్యల్‍. ");
INSERT INTO vgr_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","ఘర్నవుప్పర్‍ రవ్వాలు ఇను ఘర్మతూ సాత్బి లీజావనటేకె ఉత్రీన్ నా ఆవును; ");
INSERT INTO vgr_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","ఖేథర్‍మా రవ్వాలొ, ఇను లుంగ్డా లీజావనాటేకె ఘర్కనా నా ఆవును. ");
INSERT INTO vgr_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","అయ్యో, త్యొధన్మా బేజిని బాయ్కోనా, చెరావళి దూద్‍ దెవ్వాలియేనా మిన్హత్. ");
INSERT INTO vgr_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","తెదె మోటు మిన్హత్ హుసె. అనటేకె టండ్నా ధన్మాహో న్హైతో ఆరామ్‍నా ధన్మాహో మిలైయ్‍జావను పరిస్థితి నాఆవునుకరి ప్రార్థనకరొ. ");
INSERT INTO vgr_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","ఆ ములక్ మొదుల్తూ, హంకెలగూబి ఇమ్నూ మిన్హత్‍ కోహుయుని, ఉజూ కెదేబి కోహుసెని. ");
INSERT INTO vgr_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","పన్కి దేవ్ యోధన్నా కంమ్‍‍ నాహుయూతొ యోవహఃత్తో, కోన్బి జివీన్ కోరైయిహోత్ని. పన్కి యో చూనిరాక్యొతె ఇవ్నటేకె యోధన్ను ఇషాబ్నా కంకర్యొ. ");
INSERT INTO vgr_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","యో ధన్మా క్రీస్తు అజ్గఛాకరి ఛా, యెజ్గ ఛా కరి బోల్యుతొ నొకొనమ్సు. ");
INSERT INTO vgr_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","షానకతొ చ్హాడ్‍ క్రీస్తుబీ, చ్హాడ్‍ ప్రవక్తల్‍బీ ఆయిన్, సాధ్య్ హుయుతొ అద్మియేనా దేవ్ ఎంచిరాక్యొతె ఇవ్నాబి, మోసంకర్నూకరి మోటు సూచక క్రియల్నా, మహాత్కార్యాల్‍నా దెఖాల్సె. ");
INSERT INTO vgr_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","హఃజొ! ఆహాఃరు అగాఢీస్ మే తుమారేతి బోలి రాక్యొస్. ");
INSERT INTO vgr_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","ఇనటేకె కోన్బి, హదేక్‍ ఝాడిమా ఛాకరి, తుమ్న బోల్యుతోబి నొకొజాసు, హదేక్ మ్హైయ్ను ఘేర్మా ఛాకరి బోల్యుతోబి నొకొనమ్సు. ");
INSERT INTO vgr_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","ఇజ్లియే జంకతె ఇమ్‍ ధన్‍నికతె బాజుతీ నిఖీన్, ధన్‍డుభతే బాజుతోడి, వాజ్లు, జంఖనూ ఆవాజ్ కింమ్ దెఖ్కావస్కి ఇమ్మాస్ అద్మినొఛియ్యో ఆవ్సే. ");
INSERT INTO vgr_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","ముర్దా కెజ్గరాస్కి ఎజ్గా గరధ్‍ గుమ్మల్తి బ్హరావ్సే. ");
INSERT INTO vgr_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","యోధన్మా మిన్హత్ హువదీన్, తెదేస్ రాత్‍ సూర్యుడ్నా అంధారు కర్సె, చందమామ ఇనూ ఉజాలునా దిసెకొయిని, ఆకాష్ మతూ షుక్కర్ పడిజాసే, ఆకాష్‍మాను షక్తిహాఃరూ హల్జాసె. ");
INSERT INTO vgr_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","తెదె అద్మినొ ఛియ్యోను సూచనా ఆకాష్‍మా దెఖావ్సె. తెదె అద్మినొ ఛియ్యో థాఖత్‍ మోటు మహిమాతీబి ఆకాష్ను మబ్బుమాతో హుయీన్‍ ఆవను దేఖిన్‍, జమీన్‍ఫర్‍ ఛాతె హర్యేక్‍ గోత్వాలు ఇవ్నె ఛాతి కూటిమర్లిసె. ");
INSERT INTO vgr_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","బుజు దేవ్ మోటు పీపాను ఆవాజ్తి ఇను దూతల్నా మొకల్సే. యోధూతల్ ఆకాష్‍హాఃరు ఫరీన్, కతొ ఆఖడతూ నిఖీన్ యోఖడతోడి చార్హే బాజుతూ దేవ్నానమ్మతె అద్మి హాఃరవనా జోడ్‍ కర్సె. ");
INSERT INTO vgr_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","హదేక్ అంజురంనూ జాఢు దేఖిన్ ఏక్ నీతిన సిఖొ. అంజూరంనూ జాఢను గోబ్ కవ్లుహుయీన ఇగూర్ బేంద్యుతో, తెదె తడ్కను ధన్ కందెఛ్చాకరి తుమె మాలంకర్చు. ");
INSERT INTO vgr_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","ఇమ్మస్ తుమె ఆహాఃరుహువనూ దేక్చుతెదె ఘనూ యోకందెఛ్చాకరీ, ధర్వాజన సేడెఛ్చాకరీ మాలంకరొ. ");
INSERT INTO vgr_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","హదేక్ ఆహాఃరు హువతోడి ఆ ఫిడి మట్సెకొయినికరి తుమారేతి హాఃఛితి బోలుకరూస్. ");
INSERT INTO vgr_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","హదేక్ ఆకాష్‍తోబి జమీన్‍తోబి మట్సె పన్కి, మారివాతె కెత్రేబి మట్సెకొయిని. ");
INSERT INTO vgr_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","హుయుతొ యోధన్‍తోబి న్హైతొ, యోఘంటొతోబి కెహూ అద్మిహుయుతోబి స్వర్గంఛాతె దూతనతోబి, ఛియ్యోనబి మాలంకొయిని. భానస్ మాలం. ");
INSERT INTO vgr_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","నోవహును ధన్ కింమ్‍ తూకి ఇమ్మస్ అద్మినుఛియ్యోనూ ఆవనూబి ఇమ్మస్ ర్హాసె. ");
INSERT INTO vgr_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","నోవహున ధన్మా ఢోంగమా జావతోడి, పానినూ తుఫాన్ ఆవకొయింతె అగాఢి, ఇవ్నే ఖాతు, పీతూహుయిన్, య్హా కర్లేతూహుయిన్‍ య్హానా దేతూహుయిన్ జింకర్తా థా. ");
INSERT INTO vgr_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","పానినూ తుఫాన్ ఆయిన్, హాఃరవ్నా మర్లిజావతోడి, ఇమ్ హుసెకరి కోన్బిమాలం కర్యుకొయిని. అద్మినొఛియ్యో ఆవ్సేతె ఇమ్మాస్ ర్హాసె. ");
INSERT INTO vgr_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","యోధన్మా భేజనా ఖేథర్మా‍ ర్హాసె, ఏక్జణనా ఇనకేడె బులాలిజాసె, ఏక్నా బెందీన్ జాసె. ");
INSERT INTO vgr_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","భే రాండె ఘట్టీనా పరావ్తూహుయీన్ ర్హాసె, ఏక్ రాండ్నా ఇనకేడె బులాలిజాసె, ఏక్నా బెందాన్ జాసె. ");
INSERT INTO vgr_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","అనటేకె కెహొధన్ తుమార ప్రభూ ఆవస్కీ, తుమ్నా మాలంకొయిని, ఇనటేకె హొషార్తి ర్హవొ. ");
INSERT INTO vgr_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","కెహూ వహఃత్నా చొట్టు ఆవ్సేకరి ఘేర్ను మాలిక్నా మాలంరైయితొ, యో హొసార్తీ రైయిన్, ఇను ఘేర్నా చోర్‍హువది‍సెకొయినితిమ్‍ కావ్లి ర్హాస్‍కరి తుమ్న మాలం. ");
INSERT INTO vgr_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","తుమ్న మాలంకొయింతె వహఃత్‍మాస్‍ అద్మినొఛియ్యో ఆవ్సె, అనటేకె తుమేబి సిద్ధంహుయిన్ ర్హవొ. ");
INSERT INTO vgr_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","ఏక్ మాలిక్ ఇనా ఘేర్మా కామ్ కరతె అద్మినా బరోభర్‍ వహఃత్నా ధాన్ నాఖనటేకె నియమించాస్‍ ఇవ్నఫర్‍ రాక్యొతె నమ్మకంవాలొబి బుద్ధి మంతుడ్‍హుయోతె దాసుడ్‍ కోన్‍? ");
INSERT INTO vgr_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","మాలిక్ ఆయోతెదె కెహూ దాసుడ్‍ అంనితరా కరూకరతె ఇను మాలంకరస్కి యోదాసుడ్ ధన్యుడ్. ");
INSERT INTO vgr_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","ఇనె ఇన ఆస్థిమొత్తంఫర్‍ ఇనా మ్హేల్సెకరి మే తుమారేతి హాఃఛితి బోలుకరూస్. ");
INSERT INTO vgr_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","బుజు దుష్టుడ్‍హుయోతె ఏక్ దాసుడ్‍ మారొ మాలిక్ ఘనూ ధేర్‍ కరూకరస్‍కరి ఇనూ దిల్మా లైయిజైన్. ");
INSERT INTO vgr_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","ఇనా కేడెను దాసుల్‍నా మారను సురుకరీన్, పియ్యావాలవ్తీ ఖాతొ పీతొ ర్హంకరమా ");
INSERT INTO vgr_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","యో దాసుడ్‍ మాలమస్‍కొయింతె ధన్మాతోబి యో నాలైయిజానుతే వహఃత్మాతోబి యోమాలిక్ ఆయిన్, ");
INSERT INTO vgr_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","ఇనా దేఖిన్‍ మర్రాఖిదీన్ వేషధారునాకేడె ఇనా భాగ్నా నియమించె. ఇజ్గ రోవనూబి దాత్ చావనూబి ర్హాసె. ");
INSERT INTO vgr_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","స్వర్గంనూ రాజ్యం, ఇవ్ను దివ్వోవ్నా ధర్లీన్ నౌవ్రొనా మలనాటేకె నిక్‍ల్యూతె ధహ్ః అద్మి కమారీయేనితరా ఛా. ");
INSERT INTO vgr_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","అన్మా పాచ్జనియే అక్కల్ కొయింతెవాలు, పాచ్జనియే అక్కల్ ఛాతెవాలు. ");
INSERT INTO vgr_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","అక్కల్ కొయింతే ఇవ్నే దివ్వొనా ధర్లీన్‍ పన్కి, ఇవ్నకేడె తేల్నాలీన్‍ గయూకొయిని. ");
INSERT INTO vgr_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","అక్కల్‍ఛాతె ఇవ్నె ఇవ్ను దివ్వొనాబీ ఇవ్నాకేడె సీషిమా తేల్నా లీన్‍గయూ. ");
INSERT INTO vgr_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","నౌవ్రొ ధేర్‍ హువమా ఇవ్నె హాఃరుబి టుమీన్‍, లిందర్‍లెంకరా. ");
INSERT INTO vgr_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","అధిరాత్ను వహఃత్‍మా హదేక్‍ నౌవ్రొ వలోవాస్‍ ఆయిన్‍ మలోకరి ఆవాజ్‍ హఃమ్జాయు. ");
INSERT INTO vgr_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","తెదె యో కమారిహాఃరిజణి, ఉట్టీన్‍ ఇవ్ను దివ్వోవా అచ్చుకర్లీదు పన్కి, ");
INSERT INTO vgr_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","తెదె అక్కల్ కొయింతే యో కమారీయే హమారు దివ్వొ ఉజ్జాయ్‍ జంకరస్‍ అనటేకె తుమారు తేల్మా ధరాసు హమ్నాదా కరి అక్కల్ ఛాతె కమారీయేతి మాంగియే. ");
INSERT INTO vgr_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","అనటేకె అక్కల్‍వాలి కమారీయే హమ్నబీ, తుమ్నబీ తేల్‍ పూర్సేకొయిని, తుమె యేచతే ఇవ్నాకనా జైయిన్‍ లీలెవోకరి బోల్యు. ");
INSERT INTO vgr_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","ఇవ్నే లీలావనాటేకె జాతురవ్వామా నైవ్రో ఆయో, తెదె తయార్‍హుయీన్‍ ఛాతె పాచ్‍జణీ ఇవ్నే ఇనకేడె య్హానూ ఖాణు ఖావనా మహీ గయూ; తెదె తల్పు ముఛ్చాయ్ గయూ. ");
INSERT INTO vgr_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","ఇనపాసల్‍ ర్హైగితే కమారీయే ఆయిన్‍ హఃయేబ్‍, హమ్నా తల్పు కాఢ్కరి గట్టీతి పుఛ్చావమా ");
INSERT INTO vgr_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","తెదె ఇనె “తుమె మాలంకొయినీకరి తుమారేతి హాఃఛితి బోలుకరూస్‍కరి” బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","యో ధన్‍తోబి, కెహూభజాకి తుమ్నా మాలంకొయిని అనటేకె హొసార్తీ రవ్వొ. ");
INSERT INTO vgr_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","ఏక్‍ అద్మి ఇవ్ను దాసుల్నా బులాయిన్‍ ఇనూ దవ్లత్నా ఇవ్న దీన్‍, యో దేహ్క్ యాత్రనటేకె తయార్‍హుయీన్‍ జావంతరా ఛా. ");
INSERT INTO vgr_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","యో ఏక్జణనా పాచ్‍ హజార్‍ ఘేణను నాణెమ్ అజేక్నా బే హజార్‍ ఘేణను నాణెంనా, బుజేక్నా ఏక్‍ హజార్‍ ఘేణను నాణెమ్ కినూ సామర్థంతీ తిమ్‍ ఇవ్నా దీన్‍ ఎగ్గీస్‍ యో దేహ్క్ మా ప్రయాణంహుయీన్‍ గయో. ");
INSERT INTO vgr_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","పాచ్‍ హజార్‍ ఘేణను నాణెమ్ లీదోతె యో జైన్‍ ధందొకరీన్‍, బుజు పాచ్‍ తలాంతుల్నా కమాయో. ");
INSERT INTO vgr_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","ఇంమ్మస్‍ బే ఘేణను నాణెమ్ లీదోహూ, బుజు బే తలాంతుల్నా కమాయో. ");
INSERT INTO vgr_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","పన్కి, ఏక్‍ హజార్‍ ఘేణను నాణెమ్ లిదొతె ఇనే జైన్‍, జమీన్‍ కోందిన్‍ ఇను యజమానుని ఫైష్యానా లఫాడ్యొ. ");
INSERT INTO vgr_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","గ్హనూ ధన్‍ హుయ్‍జావనా పాసల్‍, యో దాసుడ్‍ను మాలిక్‍ ఆయిన్‍, ఇవ్నకనా ఇషాబ్‍ దేఖిలిదొ. ");
INSERT INTO vgr_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","తెదె పాచ్‍ తలాంతుల్‍ లిదోతె యో బుజూ పాచ్‍ ఘేణను నాణెమ్ లాయిన్ హఃయేబ్‍, తూ మన పాచ్‍ తలాంతుల్నా దీరాక్యోతోని యోకాహేతిమ్‍ బుజు పాచ్‍ ఘేణను నాణెమ్ కమాయ్‍ లాయోకరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","ఇను మాలీక్‍ షభాస్‍, నమ్మకంతి అషల్ దాసుడ్‍, తు ఆ ధరాసుమాస్‍ నమ్మకంతి ర్హయో, తునా హాఃరంఫర్‍ హక్కు దీస్‍, తారు మాలిక్ను ఖుషిమా తూబి భాగ్‍ హూకరి ఇనేతి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","ఇమ్మస్‍ బే హజార్‍ ఘేణను నాణెమ్ లిదుతె యో ఆయిన్‍ హాఃయేబ్‍, తూ మనా బే తలాంతుల్‍ దిదో థోని యోస్‍ కాహెతిమ్‍ మే వుజు బే ఘేణను నాణెమ్‍నా కమైయిలీన్‍ ఆయోకరి బొల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","ఇను మాలిక్‍, షభాస్‍ నమ్మకం ఛాతే అష్యల్ దాసుడ్‍, తూ ఆ దరాసుమాస్‍ నమ్మకంతి ర్హయో, తునా హాఃరంఫర్ తునా హాక్కు దెంకరూస్‍, తారు మాలిక్ను ఖుషిమా భాగ్‍ హూకరి ఇనేతి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","పాసల్తి ఏక్‍ హజార్‍ ఘేణను నాణెమ్ లిదుతే యో ఆయిన్‍, హఃయేబ్‍ తూ పిఖ్కావకొయినితె జొగొమా వడావాలో, వాఢకొయినితే జొగొమా పంటా పీకావాలొ గ్హట్‍జాన్‍ వాలొకరి మన మాలం. ");
INSERT INTO vgr_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","ఇనటేకె మే ఢరిజైన్‍, తారు ఘేణనూ నాణెమ్ లీన్‍జైన్‍ జమీన్‍మా గాడ్దిదొ, అలా తారు తునస్‍ లీలాకరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","ఇనెటేకె ఇనో మాలిక్‍ ఇనా దేఖిన్‍ తూ సోమరిహుయోతే గలీజ్‍ దాసుడ్‍, మే పిఖ్కావ కొయినితె జోగొమా పంట వాడవాలొకరి, చిఢ్క కొయింతే జొగొమా పంటా హోఃతవాలొకరి తున మాలంమాస్నా? ");
INSERT INTO vgr_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","ఇంహుయితో తూ మారు పైసా వడ్డి వాలంకనా దీరాక్నుతూ, మే ఆయిన్‍ మార పైసాన వడ్డీతి ధరీన్‍ లిదోహోత్ని కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","యో ఘేణను నాణెమ్ ఇనకంతూ లీలిన్‍ ధహ్ః ఘేణను నాణెమ్ ఛాతెవాలన దినాక్‍. ");
INSERT INTO vgr_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","ఛాతె హర్యేక్‍ జనవ్‍నాబి బుజు దెవ్వాసె, ఇనా సమృద్ధి మల్సె; పన్కి కొయింతే ఇనకంతూ ఇనకనా ఛాతె థోడుబి లీలిసె. ");
INSERT INTO vgr_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","కామె ఆవకొయింతె యో దాసుడ్‍నా భాదర్‍ ఛాతె అంధారమా ధక్లిదెవొ, ఎజ్గ రొవ్వానుబి దాత్‍ ఛావనూస్‍ ర్హాసె. ");
INSERT INTO vgr_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","తెదె అద్మియేనొ ఛియ్యో ఇను మహిమాతీ ఇనాకెడే సమస్త దూతల్తి ఆయోతెదె యో ఇను మహిమాను రాజా సింహాసనం ఫర్‍ బేషిన్‍ ర్హాసె. ");
INSERT INTO vgr_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","తెదె సమస్తంను దేహ్ఃను అద్మియే ఇనహాఃమె ఇక్కట్‍హుయిన్ వుబ్రిర్హాసే, మ్హేండా చరావ్వలు ఇను బోక్డియేమాతు మ్హేండాన అలాదు కరాతిమ్‍ యోబి ఇవ్నా అలాదు కర్సే. ");
INSERT INTO vgr_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","ఇను ఖవ్వాత్‍ బ్హనె మ్హేండవ్నా నీతిమంతుల్‍ డవ్వాహాత్‍ బ్హనె బోక్డియేవ్నా అలాదవ్నా ఉభారిరాక్చె. ");
INSERT INTO vgr_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","తెదె రాజో ఇను హఃవ్వాహాత్ను బాజుమా ఛాతె ఇవ్నా దేఖిన్‍ “మార భాన హాతెహూః ఆషీర్వాదించ బడ్యతెవాలా ఆవో; ములక్‍ ఫైయిదాహుయితే ధరీన్‍ తుమారటేకె తయార్‍హుయ్రూతె రాజ్యంనా” పొందులెవొ. ");
INSERT INTO vgr_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","“మే భుక్కె థో, తుమె మనా ఖాణు దిదా, తరాహ్ః లాగ్యు, తుమే మనా పాని పిఢాయు, ఏకేలోస్‍ థో తెదె మనా ఖందె కర్యథా, ");
INSERT INTO vgr_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","ఉగ్హాడొ థో మనా లుంగ్డా దిదా, రోగ్వాలొ హుయిన్‍ థో, మనా దేహఃన ఆయా; ఠాణమా థో తెదె మారకనా ఆయాకరి బోల్యొ.” ");
INSERT INTO vgr_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","ఇనటేకె నీతిమంతుల్‍ ప్రభూ, కెదె తునా భూక్క్ లగ్గను దేఖిన్‍ తునా ధాన్‍ కఢాయా? కెదె తరహ్ః లగ్గను దేఖిన్ తున పాని దిదా. ");
INSERT INTO vgr_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","కెదె ఎకేలొ ర్హావను దేఖిన్‍ తున హాందె కరిలిదా? ఉగ్హాడొ హుయిన్‍ థొ తెదె తునా దేఖిన్‍ లుంగ్డా దిదా? ");
INSERT INTO vgr_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","కెదె రోగ్వాలొ హుయిన్‍ ర్హావనుబి, ఠాణమా ర్హావనూబి హామె దేఖిన్‍ తారనక ఆయా థా? కరి ఇనేతి పుఛ్చావ్‍సు. ");
INSERT INTO vgr_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","ఇనటేకె రాజొ, దీనుల్నితరా ఛాతె ఆమార భైయ్యేమా కినాబి ఏక్ జాన్న ఆ కర్యాతో మనా కరాంతరస్‍కరి తుమారేతి ఖఛ్చితనంతీ బోలుకరూస్‍కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","తెదె యో డవ్వాహాత్ను బాజు ఛాతె ఇవ్నా దేఖిన్‍, షపించబడెతెవాల, మన బెందీన్‍ సైతాన్నా‍బి ఇనూ దూతల్నాబి సిద్ధంకరీన్‍ ఛాతె నిత్యా ఆగ్మా జవొ. ");
INSERT INTO vgr_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","మన భుక్క్ లాగిథు తుమే మన ధాన్‍ కోఖడాయాని, తరాహ్ః లాగి థూ తుమే మనా పాని కోదిదాని. ");
INSERT INTO vgr_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","ఎకేలోస్‍ థో, తుమే మనా కందె కోకర్యని; ఉగ్హాడొహుయీన్ థొ, తుమె మన లుంగ్డా కోదిదాని రోగ్‍వాలో హుయిన్‍ ఠాణమా థొ, తుమె మన దేఖన కోఆయాని కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","అనటేకే ఇవ్నె ప్రభూ, హమె కెదేబి తూ భుక్కేతి ర్హావనుతోబి, తరహ్క్ తి ర్హావనుతోబి, అలాదు దేహ్క్ ర్హావనూతోబి, లుంగ్డాకొయినితిమ్‍ ర్హావనూతోబి, రోగ్‍హుయీన్‍ ర్హవ్వానుతోబి, ఠాణమా ర్హవ్వానూతోబి, దేఖిన్‍, కెదేబి తునా సేవ కర్యాకొయిన్నాతిమ్‍ హుయ్‍గాకరి ఇనా పుఛ్చాయా. ");
INSERT INTO vgr_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","ఇనటేకె యో న్హాను హుయ్తె అవ్నమా ఏక్నాతోబి తుమె అంనితరా కర్యాకొయిని, అనటేకె మన కర్యొకొయినీకరీ తుమారేతి హాఃఛితి బోలుకరూస్‍కరి ఇవ్నేతి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","అవ్నే నిత్యంషిక్చనాబి నీతిమంతుల్‍ నిత్యజీవంమా జాసె. ");
INSERT INTO vgr_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","తెదె యేసు ఆవాతెహాఃరు బోలిహుయిజావదీన్, ఇన పాసల్తి ఇనే ఇనా సిష్యుల్నా దేఖిన్. ");
INSERT INTO vgr_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","భే ధన్నా పాస్సల్ పస్కాపండగా ఆవ్సెకరిబి, తెదె అద్మినొ ఛియ్యో, సిలువా నాకనటేకె దెవైయిజాసేకరి తుమ్న మాలంహుసే బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","యో వహఃత్‍మా ప్రధాన యాజకుల్‍బి అద్మియేను మోట్టోబీ కయప కరి ప్రధాన యాజకుడ్‍ను ఇను మహేల్మా ఇక్కట్‍హుయీన్. ");
INSERT INTO vgr_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","యేసునా (కింధర్నూకరి కుట్రతి) ధర్లీన్ మర్రాఖి దేనుకరి ఆయిన్ సోచిలీదు. ");
INSERT INTO vgr_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","హుయుతోబి అద్మియేమా ఛిక్రాన్ నాహోనుతిమ్‍ పండాగమా నొకొకరీ బొల్లిదా. ");
INSERT INTO vgr_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","యేసు బేతనియమా ఖోడ్తి ర్హయ్యోతె సీమోన్నా ఘేర్మ థోతెదె, ");
INSERT INTO vgr_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","ఏక్ బైయికో గ్హణు మోల్ను అత్తర్ను బుడ్డి, లీన్ ఇనకనా ఆయిన్, యో ధాన్ ఖావనటేకె బేక్హుకరతో తెదె ఇనా ముఢ్క్యాఫర్ నాఖి. ");
INSERT INTO vgr_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","సిష్యుల్ దేఖిన్ చంఢాల్ హుయీన్‍, అత్రే నష్టంషాన కర్నూ? ఇనే బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","అన ఘను మోల్మా యేచీన్ గరీబ్నా దేవజైయినీకరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","యేసు ఆవాత్ మాలంకర్లీన్, ఆ బాయికొ మారవాత్ మడ్తీ అష్యల్ కార్యమ్‍ కరిహుయి. ఆ బైయికోనా తుమె కిమ్ ఢరాంకరస్ కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","గరీబ్‍ హామేస తుమారకేడె ర్హాసే, పన్కి మే తుమారకేడె కోరైయిస్నీకరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","ఆ బైయికో యో అత్తర్నా మార ఉఫ్పర్ నాఖీన్ మార భూస్తాపన్ నమొత్తంతీ కర్సేకరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","ములక్మా ఆ సువార్తనా కెజ్గా ప్రచార్‍ కర్షేకి ఎజ్గా యో బైయికో కరితే హాఃరుబీ ఇని గుర్తునీతరా బొలైయిలీసే, కరి మే తుమారేతి క్హాఛితనంతి బోలుకరూస్‍కరి ఇవ్నేతి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","తెదె భ్హార జన మతూ ఏక్జను ఇస్కారెతు యూద నెయ్యోకనా జైన్. ");
INSERT INTO vgr_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","మే ఇనా తుమ్నా ధరైయిదిదోతొ తుమె మన సాత్ దీసుకరీ పుఛ్చాయో, ఇనటేకె ఢోడీఖ్ రూఫణా బిల్లా భోజొతుంచీన్‍ ఇనా దీదూ. ");
INSERT INTO vgr_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","తెదె ఇనే ఇనా ధరైయిదేవాను వహఃత్ ధూండుకర్తో థొ. ");
INSERT INTO vgr_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","ఖాటు రోటాను పండగమా అగాను ధన్నె, సిష్యుల్ యేసుకనా ఆయిన్, పస్కా పండగాను ఖావనాటేకె హమె తారటేకె కెజ్గా తయార్‍కర్ను ర్హైజంకరస్‍కరి పుఛ్చాయా. ");
INSERT INTO vgr_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","ఇనటేకె యేసు, తుమె గమ్మాఛాతె ఫలాని అద్మికనా జైయిన్ మారధన్ ఖందె ఆయ్రూస్‍; మార సిష్యుల్తీబి తార ఘేర్మా పస్కాపండగా ఖావనహాఃజె బోధకుడ్ బోలుకరస్‍కరి ఇనేతి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","యేసు ఇవ్నా ఆజ్ఞదిదోతిమ్ సిష్యుల్ పస్కానా సి‍ద్దంకర్యా. ");
INSERT INTO vgr_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","హాఃమ్జె హుయితెదె యో ఇను సిష్యుల్తి మలీన్ ధాన్ ఖావనటేకె బెట్టొ. ");
INSERT INTO vgr_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","ఇవ్నె ధాన్ కంకరాతెదె యోబోల్యొ, తుమారమా ఏక్జనూ మన ధరైయిదిసేకరి మే తుమారేతి హాఃఛితి బోలుకురూస్. ");
INSERT INTO vgr_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","ఇనటేకె ఇవ్నె ఘనూ బాధపడీన్; హర్యేక్ జణు ప్రభూ, యో మేస్ నా? కరి పుఛ్చావమా. ");
INSERT INTO vgr_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","మారకేడె మలీన్ కోణ్ మార గిన్నిమా ధాన్ ఖాస్కి యోస్ మన ధరైయ్‍ దెవ్వాలోకరి, బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","అద్మినొ ఛియ్యానా బారెమా లిఖైయ్రూస్ తిమ్ యో జంకరస్, పన్కి కినహాతె అద్మినొఛియ్యో ధరైయిజాస్కి యో అద్మినా మిన్హత్‍; యో అద్మి ఫైదా నాహుయుహోత్ థో అష్యల్ రైయుహోత్‍కరి ఇనా బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","ఇనా ధరైయిదెవ్వాలొ యూదా బోధకుడ్‍, యో మేస్ నా? కరి పుఛ్చావమా ఇనే తూ బోల్యొ తిమ్మాస్‍కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","ఇవ్నే ధాన్ ఖావుంకరమా “యేసు ఏక్ రోటో పలీన్, ఇనా ఆషీర్వాద్‍ దీన్, తోడీన్ ఇనా సిష్యుల్నాదీన్ తుమె లీన్‍ ఖవో ఆ మారు ఆంగ్తాన్‌కరి” బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","బుజు యో గిన్నినా పల్లీన్ కృతజ్ఞతాస్తుతులు కరి బోలిన్ ఇవ్నదీన్, అన్మను తుమె హాఃరుజణు పీవొ ఆ మారు ల్హొయి. ");
INSERT INTO vgr_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","ఆ మారు ల్హొయ్‍కతో పాప్‍ క్చమాహువనా హారేక్ జీవాన్నటేకె, చువ్వాడుకరతే ఏక్ నవూ నిబంధన ల్హొయికరీ బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","మార భాను రాజ్యంమా తుమారేతి మే ఆమారు దేవ్ను నవూ నిబంధననా ద్రాక్చాను రహ్క్ పియ్యాను ధన్ ఆవతోడి, బుజూ ఇన కోపీస్నికరి మే తుమారేతి హాఃఛితి బోలుకరూస్. ");
INSERT INTO vgr_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","తెదె ఇవ్నె కీర్తననూ గీధ్ బోల్తుహుయీన్, ఒలీవను ఫహాడ్కన గయా. ");
INSERT INTO vgr_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","తెదె యేసు ఇవ్న దేఖిన్, ఆజ్ రాతె తుమెహాఃర మార వాత్ బ్హంతి దీనుల్ నొకొహుసు, కిమ్ కతో మ్హేంఢా చరావాలనా మార్సే యో మ్హేంఢను గుంబాల్‍ చెద్రిజాసేకరి లిఖ్కైరూస్ కాహేనా. ");
INSERT INTO vgr_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","మే ఉట్టీన్ తుమారేతి అగాఢి గలిలయానా జైయిస్‍కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","ఇనటేకె పేతుర్ తారివాత్ బారెమా హాఃరుజణు అభ్యాతరం పడ్యుతోబి, మే కెదేబి అభ్యాతరం కోపఢీస్నికరి ఇనేతి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","యేసు ఇనా దేఖిన్, ఆజ్ రాతె ముర్గు వాహఃనా అగాఢీస్ తూకతొ మన మాలంకొయినీ కరి తీన్ చోట్ బోలీస్‍కరి మే తారేతి హాఃఛితి బోలుకురూస్. ");
INSERT INTO vgr_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","పేతుర్ యేసునా దేఖిన్, తారకేడె మనాబి మరణ్‍ ఆయుతోబి, తూకతొ మన మాలంకొయినికరి కోబోలిస్ని; ఇవ్ని తరాస్ సిష్యుల్ బోల్యా. ");
INSERT INTO vgr_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","తెదె యేసు ఇవ్నాకేడె మలీన్ గెత్సేమనేకరి బులావతె గాంమ్మా ఆయిన్, మే ఎజ్గా జైన్ ప్రార్థనా కర్లీన్ ఆవతోడీ తుమె అజ్గ బేహొఃకరి సిష్యుల్తి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","పేతుర్బి జెబెదాయినొ బే! ఛియ్యోనాకేడె బులైలి జైన్, బాధపడనూబి చింతహువనూబి సోచను సురుకర్యొ. ");
INSERT INTO vgr_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","తెదె యేసు బోల్యొ, మరీజైయియెత్రే మారు జాన్‍ ఘను దుఃఖంమా డుబీన్‍, తుమె అజ్గ ర్హైయిన్ మారకేడె హొసార్తి రహోకరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","థోడుదూర్ జైన్, డుక్నిఫర్‍ ఊంద మ్హోడెహూఃయిన్‍ బేసిన్, మారొ భా! తునా నచ్చుతె ఆ గిన్ని అనా మారకంతూ కన్నాక్, మారి ఇష్టంకాహే తారి చిత్తప్రకార్‍ హువదాకరి ప్రార్థనా కర్యొ. ");
INSERT INTO vgr_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","యో బుజు సిష్యుల్‍కనా ఆయిన్, ఇవ్నె లింధర్‍ లేవను దేఖిన్ ఏక్ ఘంటొతోబి తుమె మారకేడె హొసార్తి కోర్హాహిన్నా. ");
INSERT INTO vgr_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","తుమె సోధనమా నాపడ్నుతిమ్ హొసార్తి రైయిన్ ప్రార్థన కరొ, ఆత్మ సిధ్దమాస్ పన్కి, ఆంగ్‍ కంజోర్‍కరి పేతుర్తి బోలీన్. ");
INSERT INTO vgr_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","బుజు బెంమ్మని చోట్ జైన్, “మారో భా, మే ఆ గిన్నిమాను మిన్హత్ పీదొతోస్‍, పన్కి ఆ మారకంతూ నికిజావను సాధ్యం నాహుయుతొతెదె తారి చిత్తమాస్ హువదా” కరి ప్రార్థనా కర్యొ. ");
INSERT INTO vgr_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","ఫరీన్‍ ఆయిన్, ఇవ్నె బుజూ హూఃయిజావను దేక్యొ, కింకతో ఇవ్నా ఢోళమా నిందర్‍ భరైయిన్ తూ. ");
INSERT INTO vgr_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","యో బుజు ఇవ్నా బెందీన్ జైన్‍, యోస్ వాతేనా బోలీన్ తీన్మను తరా ప్రార్థనకర్యొ. ");
INSERT INTO vgr_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","తెదె యో ఇనా సిష్యుల్‍కనా ఆయిన్, హంకె నింధర్ లీన్‍ తహ్ః తోడిలెవొ, హదేక్ యో వహఃత్ ఆయిత్రూ, అద్మినొఛియ్యో పాప్‍వాలనా హాతె ధరాయ్‍ జంకరస్. ");
INSERT INTO vgr_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","ఉట్టొ జియ్యే “హదేక్ మన ధరైదెవ్వాలో కందేస్ ఛా” కరి ఇవ్నెతి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","యో బుజుబి వాతె బోలుకర్తొ థొ. తెదె బ్హారజన సిష్యుల్‍మతూ ఏక్జణు యూదా ఆయో. ఇనా కేడెస్ గ్హను అద్మియే ఛర్యేబి, కొయ్తా పల్లీన్, ప్రధాన యాజక్‍ కంతూబీ, అద్మియేనొ మోట్టొకంతూ ఆవాస్. ");
INSERT INTO vgr_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","ఇనా ధరైయిదేవాలొ మే కినా బుఛ్చ దీస్కి ఇనేస్‍ యేసు; ఇనా ధర్లేవొకరి ఇవ్నా గుర్తు బోలిన్‍ ");
INSERT INTO vgr_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","తెదేస్ యేసుకనా ఆయిన్ బోధకుడ్‍, తున అచ్చుహుదాకరి బోలిన్ ఇనా బుఛ్చదిదొ. ");
INSERT INTO vgr_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","యేసు చెలికాడా తూ కరనాటేకె ఆయోతే కామ్ కరిలాకరీ ఇనేతి బోలమా ఇవ్నే ఇనా క్హందె ఆయిన్, ఉఫ్పర్ పఢీన్ ధర్లిదా, ");
INSERT INTO vgr_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","హదేక్ యేసునాకేడె ఛాతె ఇవ్నమా ఏక్జను హాత్ ఛీదుకరీన్‍, ప్రధాన యాజకుడ్‍ను దాసుడ్‍నా మారిన్, ఛరితీ ఇను కాణ్ కత్రినాక్యొ. ");
INSERT INTO vgr_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","యేసు తారి ఛరి పాచుపరాయిన్‍ ఘల్లా, ఛరి ధర్యుతే ఇవ్నె హాఃరుబి ఛరితీస్ నాష్‍హుసె. ");
INSERT INTO vgr_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","తునా మాలంకొయినిసు మే మార భాతి మాంగ్యొతొ యో హంకేస్, బ్హారహజార్‍హూఃబి జాహఃత్ దూతల్నా హంకేస్‍ మారకనా మోక్లావ్సె కొయినికరి తూ సోచుకరస్నా? ");
INSERT INTO vgr_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","మే ఏక్తార నామాంగ్యొతొ, లేఖనాల్‍ కిమ్ నెరవేర్సెకరి ఇవ్నేతి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","త్యొ వహఃత్‍ఫర్ యేసు అద్మిహాఃరౌన దేఖిన్ చోర్‍ దాంఢా, చొట్టావ్నాఫర్‍ ఆవతెతిమ్‍ ఛరియేంతి, లట్టాంవ్తి, మన ధరనాటేకె ఆయనా? మే ధరోజ్ దేవల్మా బేసిన్ దేవ్ను ఆలయంమా దేవ్నివాత్ బోధకర్యొతెదె తుమె మన ధర్యాకొయిని. ");
INSERT INTO vgr_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","పన్కి, ప్రవక్తల్‍ను లేఖనాల్‍ జరుగ్నూతిమ్‍ ఆహాఃరు హుయూకరి బోల్యొ. తెదె సిష్యుల్ హాఃరు ఇన బెందీన్ మిలైలీదు. ");
INSERT INTO vgr_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","యేసున ధర్యూతె ఇవ్నే ప్రధాన యాజకుడ్‍ హుయోతె నెయ్యంకనా, కయపకనా ఇనలీన్ జావమా; ఎజ్గా నియమ షాస్ర్తుల్ మోటుజనూబి భరాయిన్‍ థూ. ");
INSERT INTO vgr_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","పేతుర్ అస్లినెయ్యోవ్ని ఘర్నా హాఃమెతోడి జైయిన్, ఇన దూర్తూ మహేల్మా జైయిన్ మహీజైన్, సాత్ హువస్కి దేక్నూకరి సిపాయ్తీమలిన్ బేసిగయూ. ");
INSERT INTO vgr_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","ప్రధాన యాజకుడ్‍బీ, అద్మియేనొ మోట్టొ యేసునా మర్రాఖి‍‍ దేనుకరి ఇనామ్హన్తి జూటి సాక్చ్యంనా దూండుకర్తు థూ ");
INSERT INTO vgr_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","పన్కి జూటి సాక్చ్యంవాలు ఘనూజణు ఆయుతోబి జూటి సాబుత్‍ కోమల్యుని (తుదుకు) బేజాన ఆయిన్. ");
INSERT INTO vgr_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","యో దేవాలయంనా పొన్నాకీన్‍ తీన్ ధన్మా భాంద్సేకరీ బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","ప్రధానయాజకుడ్‍ తూ ఉట్టీన్, జవాబ్ సాత్బి బోలకొయిన్నా? అవ్నె తారఫర్ బోలుకరతె సాక్చ్యం సాత్కరి పుఛ్చావమా? యేసు సోపొ థొ. ");
INSERT INTO vgr_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","ఇనటేకె ప్రధానయాజకుడ్‍ ఇనా దేఖిన్, తూ దేవ్నొఛియ్యోహుయోతె క్రీస్తుహుయోతొ యోవాతె హమారేతి బోల్కరి జీవంహుయోతె దేవ్ను తొడ్కరి మాంగిలెంకురూస్. ఇనటేకె యేసు తూ బోల్యొ తిమ్మస్. ");
INSERT INTO vgr_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","ఆ హంకెతూ లీన్ అద్మినొఛియ్యో సర్వషక్తిను థాఖత్‍నీ మాంఢిఫర్ భేహఃనూబి, ఆకాష్‍మా మబ్బుఫర్ ఆవనూబి తుమె దేక్చుకరి బోలమా. ");
INSERT INTO vgr_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","ప్రధానయాజకుడ్‍ ఇవ్ను లుంగ్డా ఫాడిలీన్ అనే దేవ్నదూషణ కరూకరస్‍, అప్నబుజు సాక్చ్యాంతి షానుకామ్? హదేక్ ఆ దూషణ తుమెహాంకె హఃమ్జా. ");
INSERT INTO vgr_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","తునా సాత్ సొఛ్చాంకరస్‍కరి పుఛ్చాయో. ఇనటేకె ఇవ్నె అనే మరణ్‍నా నాక్నుకరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","తెదె ఇవ్నే ఇనా మ్హోడఫర్ తూఖిన్ ఇన గుద్యూ. ");
INSERT INTO vgr_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","థోడుజణు ఇన హాత్తి మారీన్, క్రీస్తు తునా మార్యుతె కోన్కి గుర్తు ధర్కరీ బోల్యు. ");
INSERT INTO vgr_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","పేతుర్ మహేల్మాను బ్హాధర్ బేసీన్ థొ తెదె ఏక్ న్హాని చొగ్రి ఇనాకనా ఆయిన్, గలిలయాహుయోతే యేసుతి మలీన్ థోని. ");
INSERT INTO vgr_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","ఇనటేకె యో, మే కోథోని; తూ బోలితె వాత్‍ హాఃరి మన మాలంకొయినికరి హాఃరవ్నా హాఃమె బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","ఇనె దేవడీ తోడి జావదీన్ ఇన పాస్సల్ బుజేక్ న్హానిచొగ్రి ఇన దేఖిన్ ఆబీ నజరేతుహుయోతె యేసునకేడె థొకరీ ఇజ్గనూ అద్మియేనా బోలమా, ");
INSERT INTO vgr_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","మే ఒట్టూ బెందీన్‍ మే కోథోని యో అద్మి మన మాలంకొయినికరి బుజేక్ చోట్ బోలమా. ");
INSERT INTO vgr_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","థోడు వహఃత్ హువనా పాసల్‍ ఎజ్గఛాతె థోడుజణు పేతుర్‍కన ఆయిన్‍, హాఃఛిస్ తూబి ఇవ్నమా ఏక్జనోస్‍; తారి వాతె తున లీన్ సాక్చ్యాం దెంకరూస్‍కరి ఇనేతి బోల్యా. ");
INSERT INTO vgr_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","ఇనటేకె యో అద్మి కోన్కి మన మాలంకోయినికరి బోలిన్‍ సపించనాటేకెబి ఒట్టు బేంది లేవనాబి సురుకర్యొ. ");
INSERT INTO vgr_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","తెదేస్‍ ముర్గు వాష్యు. ఇనటేకె ముర్గు వాహఃనా అగాఢి తూ, మన మాలంకొయినికరి తీన్ ఛోట్ బోలిస్‍కరి యేసు ఇనేతి బోల్యొతె వాత్ పేతుర్ హఃయాల్ కరీన్ బ్హాధర్ జైయిన్ బాధపడీ రొయ్యో. ");
INSERT INTO vgr_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","వ్యాణె హఃత్రెహుయుతెదె ప్రధాన యాజకుడ్‍బి, అద్మియేనూ మోటాహాఃరబి యేసునా మరాయ్‍ నాక్నూకరి ఇనా విరోధంతి సోచిన్‍. ");
INSERT INTO vgr_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","ఇనా ధర్లీన్ బాందీన్‍ లీజైయిన్, రోమా అధిపతిహుయోతె పొంతిపిలాతుకనా ధరాయ్‍దిదు. ");
INSERT INTO vgr_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","తెదె ఇనా ధారయ్‍దిదోతె యూదా, ఇనా సిక్ష్యానాఖను దేఖిన్ పక్షాత్తాపమ్‍ పడీన్, యో ఢోడీహ్ః రూపాణు నాణెంనా ప్రధానయాజకుడ్‍కనబీ, మోటొకనబీ బుజు లాయిన్. ");
INSERT INTO vgr_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","మే కెహూ తప్పు కరకొయింతె వాలనా ధార్యాయిదీన్, పాపంకర్యోకరి బోల్యొ, ఇవ్నె, ఇనేతి హామ్న సే? తూస్ ధేహఃలానికరి బోలమా. ");
INSERT INTO vgr_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","యో, యో రూపనూ నాణ్నాల్నా దేవాలయంమా ఫేఖిదీన్‍, జైయిన్ గళమా పాహొఃతి ఉరినాఖిల్దొ. ");
INSERT INTO vgr_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","ప్రధానయాజకుడ్‍ యో రూపంనూ నాణ్యాల్నా లీన్, అద్మినా మర్రాఖనాహుయుతె దవ్లత్‍, ఇనటేకె అవ్నా హుండిని పెట్టీమా నా నాక్నుకరి బొల్లిదా. ");
INSERT INTO vgr_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","ఇనటేకె ఇవ్నె సోఛిన్ యో నాణ్యంనా పరదేసూల్నా దీన్, ఖోందీన్ గాడనటేకె (కుమ్మరీ) ఇన ఖేథర్ లిదా. ");
INSERT INTO vgr_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","ఇనటేకె హంకెలగుబి యోఖేథర్ “ల్హొయినూ ఖేథర్‍కరి బొలాంకరస్‍.” ");
INSERT INTO vgr_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","తెదె మోల్తి భందాయుతెయిను, కతొ ఇస్రాయేల్మా థోడుజణు మోల్తి భందాయుతె డోఢిహ్ః రూపణు నాణ్యాల్నా లీన్, తెదె ప్రవక్తా హుయోతె యిర్మియా బోల్యొతే వాత్‍ నెరవేర్యు. ");
INSERT INTO vgr_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","ప్రభువు మన నియమించొతె ప్రకారంతి యో నాణ్యాల్‍నా కుంబ్హార్‍ ఇను ఖేథర్‍ లెవ్వానటేకె దిదా. ");
INSERT INTO vgr_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","యేసున రోమా అధికారినా హాఃమె ఉబ్రిగయో; తెదె యోఅధికార్, తూ యూదల్నా రాజోనా? కరి ఇన పుఛ్చావమా, యేసు ఇన దేఖిన్ తూ బోల్యొతిమ్మాస్, కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","ప్రధాన యాజకుడ్‍బి, మోట్టజణ ఆయిన్ ఇనఫర్‍ నేరంనా నాక్యూతెదెతోబి యో సాత్బిజవాబ్ దిదొకొయిని. ");
INSERT INTO vgr_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","అనటేకె పిలాతు ఇనేతి అవ్నె తారఫర్ కెత్రూకి నేరంనా నాకుకరతే తూ హఃజొకొయిన్నా? కరి ఇనా పుఛ్చాయో. ");
INSERT INTO vgr_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","పన్కి, ఏక్ వాతెతోబి ఇనా జవాబ్ దిదోకొయిని, అనటేకె అధిపతి ఘనూ అష్యంహుయో. ");
INSERT INTO vgr_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","అద్మి కోరతిమ్ ఏక్ ఖైదీన బేందను పండగమా అధిపతిన ఏక్ అలవాట్‍. ");
INSERT INTO vgr_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","యోధన్మా బరబ్బాకరి ఏక్నామ్‍ హుయోతె బరబ్బాకరి ఏక్ చోర్ ఠాణమా థొ. ");
INSERT INTO vgr_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","ఇనటేకె అద్మిహాఃరు ఆయిన్ ఇక్కట్‍హువమా, పిలాతు మే కినా బేంద్నుకరి తుమె బోలుకరస్‍కరి పుఛ్చావమా? బరబ్బానా, న్హైతో క్రీస్తుకరిబోలతె యేసునా? కరి ఇవ్నా పుఛ్చాయో. ");
INSERT INTO vgr_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","సానకతో ఇవ్నె ఒప్పకొయినితిమ్‍ అసూయతి ఇనా ధర్యాయుకరి పిలాతు మాలంకరీన్ థొ. ");
INSERT INTO vgr_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","ఇనె న్యాయపీఠంనుప్పర్‍ బేసిన్‍ ర్హయ్యోతెదె ఇని బావన్ “తూ యో నీతిమంతుని జోలినా నొకొజైయిస్; ఆ రాతె మే ఇనబారేమా హొఃనెమా బాధపడికరి ఇనకనా ఆ సమాచార్నా మొక్లి.” ");
INSERT INTO vgr_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","అస్లియాజకుడ్‍బి మోటాబి, బరబ్బాన బెందేనుకరి పుఛ్చావనా, యేసునా మర్రాక్నూకరి అద్మిహాఃరౌన ఉసిలగాడ్యూ. ");
INSERT INTO vgr_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","పిలాతు ఆ బే మా మే కినా బెందేవనా తుమె కోరుకరస్కరి ఇవ్నా పుఛ్చావమా ఇవ్నె బరబ్బానాస్ మ్హెందొవోకరి బోల్యు. ");
INSERT INTO vgr_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","అనటేకె పిలాతు ఇంహుయుతో క్రీస్తుకరి బోలతె యేసునా సాత్కరియేకరి ఇవ్నా పుఛ్చావమా, సిలువనాఖొకరి హాఃరుజణుబి బోల్యు. ");
INSERT INTO vgr_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","పిలాతు షానా? ఆ కెహూ తప్పునుకామ్ కర్యొకరి పుఛ్చావమా, ఇవ్నే సిలువనాఖ్‍ కరి అజు జాహఃత్‍ ఛిక్ర్యూ. ");
INSERT INTO vgr_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","పిలాతు అవ్నే ఘట్ ఛిక్రూకరస్నీ పన్కి, మారబారెమా ప్రయోజనమ్‍ కాయ్‍కొయినికరి మాలంకరీన్, పాని లీలిన్ అద్మిహాఃరౌన హఃమే హాత్ ధొయిలీన్ ఆ నీతి మంతునిటేకె మరణ్‍ను విషయంమాహో మే బాద్యుడుకాహె, తుమేస్ దేఖిలెవోకరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","అనటేకె జనాభొ హాఃరు ఇనూ మరణ్‍ హమారఫర్, హమార లడ్కావ్‍ఫర్ ఆవదా! కరిబోల్యు. ");
INSERT INTO vgr_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","తెదెయో ఇవ్నె కోర్యుతిమ్‍ బరబ్బాన ఇవ్నా చొఢాయిన్‍, యేసునా లట్టావ్తి, కొల్డావ్తి మరాయిన్, సిలువ నాఖనా దెవ్వాడొ. ");
INSERT INTO vgr_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","తెదె రోమా అధికారినూ సైనికుల్ (సిఫాయి) యేసునా అధికార్ను భవనంనా లీజైయిన్ ఇనకనా సైనికుల్ హాఃరవ్నా గుంపు కర్యూ. ");
INSERT INTO vgr_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","ఇవ్నె ఇను లుంగ్డానా కన్నాఖి దీన్, ఇనా లాల్ లుంగ్డనా పెరాయిన్; ");
INSERT INTO vgr_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","కాఠొను ఢాలినా కిరీటంనితరా పొరాయిన్ ఇన ముఢ్క్యాఫర్ పెరాయిన్ ఏక్ భాలో, ఇన ఖవ్వాహాత్ దీన్, ఇనహాఃమె గుడ్గామేట్ హుయిన్‍ యూదుల్నా రాజొ, తున అచ్చుకరి ఇనా ఘేళికాఢ్యు. ");
INSERT INTO vgr_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","ఇనఫర్ తూఖిన్, యోలాంబి లాక్డినా ఇన మాతఫర్ మార్యు. ");
INSERT INTO vgr_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","ఇన ఛింగావనా పాసల్ ఇనవుప్పర్ ఛాతె యోలుంగ్డనా కన్నాఖిదీన్ ఇనూ లుంగ్డనాపెరాయిన్, సిలువ నాకనటేకె బులాలీన్ గయ్యూ. ");
INSERT INTO vgr_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","ఇవ్నె జాతూ రవ్వమా కురేనీయుడుహుయోతె సీమోన్‍కరి ఏక్జనో దెఖ్కావమా, యేసును సిలువనా ఢొవ్వాడనాటేకె ఇనా జబర్‍దేస్తి కర్యూ. ");
INSERT INTO vgr_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","ఇవ్నె కపాలజొగొనా అర్థంహూవతిమ్‍, గొల్గొతాకరి బోలతె జొగొమా ఆయిన్; ");
INSERT INTO vgr_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","వగ్గర్ మలాయుతె ద్రాక్చాను రహ్‍ఃనా పిఢాయు పన్కి యో చాఖి దేఖిన్ పియ్యాన కోహుయుని. ");
INSERT INTO vgr_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","ఇవ్నె ఇన సిలువా నాఖీన్ పాసల్తూ చిట్టినాఖీన్ ఇనా లుంగ్డాన భాగ్ పాడిలీదు. ");
INSERT INTO vgr_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","తెదె ఇవ్నె బేసీన్‍ ఇనా కావ్లీ థా. ");
INSERT INTO vgr_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","ఆ యూదుల్‍నా రాజొహుయోతె యేసు! కరి ఇనఫర్ నాక్యుతె ఖర్రాబ్ నేరంనా లిఖ్కిన్ ఇన ముఢ్క్యాఫర్ బేంద్యు. ");
INSERT INTO vgr_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","బుజు ఖవ్వాహాత్ను బాజూ ఏక్నా, ఢవ్వాహాత్నూ బాజు ఏక్నా భే బందిపోటు చొట్టావ్‍నా ఇనకేడె సిలువా నాక్యు. ");
INSERT INTO vgr_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","యో మారగ్ను వాటె జంకరతె హాఃరు కుజ్జావ్‍తూ జాతూ ఇనా దూషణకర్తూ ఇమ్మస్‍ హోను! ");
INSERT INTO vgr_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","దేవాలయాంన నాషనం కరీన్ తీన్మనుధన్‍మా బాందవాలో! తారు తూస్ బఛ్చాయిలా, తూ దేవ్నొ ఛియ్యోహుయోతో యో సీలువ ఉప్పర్తీ ఉత్రీన్‍ ఆవ్‍! కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","అస్లీ యాజకుడ్‍బి షాస్ర్తుల్మా, బుజు మోట్టావ్తి మలీన్, ఇన ఇమ్మస్ గేలికాడుతూ. ");
INSERT INTO vgr_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","యో అలాదవ్నా బఛ్చావస్ పన్కి ఇను యోస్ కోబఛ్చుకరస్‍ని, యో ఇస్రాయేల్‍నా అద్మియేన రాజొహుయోతొ యో సిలువ ఉత్రీన్ ఆవ్‍కరి బోల్, తెదె ఇన హమె నమ్సూ. ");
INSERT INTO vgr_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","యో దేవ్న నమ్మాస్, మే దేవ్నొ ఛియ్యోకరి బోల్యొ, దేవ్ ల్హైగోతొ ఇన బఛ్చావూసే. ");
INSERT INTO vgr_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","ఇనకేడె సిలువ నాక్యుతె (దోపీడీ) చొట్టాబీ ఇన ఇమ్మాస్ ఘేలికాడ్యు. ");
INSERT INTO vgr_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","ధొప్పారె భారబజతూ లీన్ తీన్ బజతోడి యో దేహ్క్ అక్కూ అంధారు హుయ్గు. ");
INSERT INTO vgr_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","లగబగూ తీన్ బజానా యేసు జోరేహూః, ఏలీ, ఏలీ, లామా సబక్తానీ? కరి గట్టీతి ఛిక్రాన్‍బేంద్యొ, కతొ మారో దేవ్, మారో దేవ్, మనసే ఎకేలోస్ బేంద్యొతె? కరి అర్థం. ");
INSERT INTO vgr_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","ఇజ్గ ఉబ్రీన్ ఛాతె థోడుజణు ఆ హఃమ్జీన్‍, యో ఏలియాన బూలవుంకరస్‍ కరి బోల్యా. ");
INSERT INTO vgr_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","ఎగ్గీస్‍ ఇవ్నమా ఏక్జణు మిలావుతూ జైన్ ఏక్ స్పాంజి లీన్ ఆయిన్‍ చిరకమా డుభాడీన్‍, భాల్నా లగాడీన్‍ ఖాటు ద్రాక్చను రాహ్ఃమా డుబాడీన్ ఇన ఏక్ లాక్డీమా లాగాడీన్ యేసునా పీయ్యానటేకె దిదా. ");
INSERT INTO vgr_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","పన్కి థోడుజణు గచ్చూప్‍ ర్హవో! ఇన బఛ్చావనటేకె ఏలీయా ఆవస్కీ దేఖియే! కరి బోల్యా. ");
INSERT INTO vgr_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","యేసు బుజేక్ చోట్ మోటు ఛిక్రాన్ బేందీన్ ఇను జాన్ మ్హేందిదొ. ");
INSERT INTO vgr_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","తెదె దేవాలయంను ఉప్పర్తీలీన్ హేట్లగూ బే భాగ్ ఫాట్యు; జమీన్ హలీగు; బండొ పుట్టీగయు. ");
INSERT INTO vgr_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","గోరాడ కొలైయిగయు, దేవ్ మరిగూతే పరిసుద్దుల్‍నా కెత్రూకిజణనా జివాడ్యొ. ");
INSERT INTO vgr_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","ఇవ్నె గొర్రాఢమతూ భాదార్ ఆయూ, యేసు జీవీన్ ఆయో తెదె పవిత్ర నంగర్‍మా జైయిన్ గ్హనూ అద్మినా దేఖ్కాయో. ");
INSERT INTO vgr_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","యేసునా కావిలీ కాహుఃకరతే ఇవ్నేబి షతాధిపతి, సైనికుల్బీ భూకంపంబి జర్యూతె హాఃరనా దేఖిన్ గ్హణు ఢరిగూ, ఆ హాఃఛిస్ దేవ్నొ ఛియ్యోస్‍కరి బొల్లిదు. ");
INSERT INTO vgr_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","యెసునా ఉపచార్‍ కర్తూహుయీన్‍ గలిలయమతూ (సేవ) కరనటేకె ఇనకేడె జంకర్తూతె కెత్రూకి బాయికా దూర్తూ దేకుకర్తూ థూ. ");
INSERT INTO vgr_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","ఇవ్నమా మగ్దలేనె మరియబి, యాకోబు, యోసేపు కరి బోలావాలానీ ఆయా మరియ, జెబెదయి ఛియ్యాని ఆయబీ థి. ");
INSERT INTO vgr_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","హాఃమ్జెహుయిగు తెదె, యోసేపుకరి ఏక్ దవ్లత్‍వాలో అరిమతయియ గామ్తి ఆయూ, యోసేపుబి యేసునా సిష్యుల్ మతూ ఏక్. ");
INSERT INTO vgr_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","యో పీలాతుకన జైయిన్, యేసునూ సవ్‍నాదా కరి మాంగ్యొ, పిలాతున దా కరి ఆజ్ఞదిదో. ");
INSERT INTO vgr_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","యోసేపు యోఆంగ్తాన్‍నా లీన్ ఏక్ నవూ లుంగ్డుతీ లప్‍ట్యో. ");
INSERT INTO vgr_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","ఏక్ మోటు బంఢోనాధక్లిన్ ఇనటేకె బనాయోతే ఏక్ నవూ సమాధిమా ఇనరాక్యొ. ఏక్ మోటొపత్రొనా యోసు సమాధినా వాట్నా హాఃమె ఆడె నాఖిదీన్, చలిగయూ. ");
INSERT INTO vgr_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","మగ్దలేన్ మరియ, బుజేక్ మరియబీ యోగొరాఢనా హాఃమేస్ బేసిన్ థా. ");
INSERT INTO vgr_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","పాసల్నా ధన్ కతొ సిద్ధంహువతె ధన్‍తోడి అజేక్‍ ధన్నె ప్రధాన యాజకుడ్‍బి పరిసయ్యుల్బి పిలాతుకనా మలీన్‍ ఆయిన్‍; ");
INSERT INTO vgr_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","హఃయాబ్‍ పాసల్ను ధన్నె చ్హాడ్‍ బోలవాలు పరియ్యల్ యాజకుడ్‍, హాఃరూ పిలాతురాజొకనా ఆయిన్ మళ్యా. మాలిక్! యో మోసంకరవాలో జివీన్ ర్హావమా తీన్ ధన్మా మే బుజుపాచు జివీన్ ఉట్టీన్ ఆయిస్. కరిబోల్యొతె మన హఃయల్‍ ఛా. ");
INSERT INTO vgr_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","అనటేకె తీన్ ధన్తోడి యోగొరాఢనా జత్తన్తి కావ్లి ర్హవ్వోకరి, ఆజ్ఞదెవో. ఇంమ్ నాకర్యతో ఇను సిష్యుల్ ఆయిన్ ఇను ముర్దునా చోర్ కరిన్, యో జివ్తొఛ్చాకరి, ఇను అద్మితి బోలజై. ఆ ఆక్రీను మోషం మొదుల్నూ మోషంతిబీ ఘనూ ఘోరంగా ర్హాసేకరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","అనటేకె పిలాతునె, భట్టుల్నా బులాలిజవో, ఇవ్నే సమాధినా జత్తన్తి కావ్లీరావదా ఇవ్ను బాద్యతకరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","ఇవ్నె జైయిన్‍ కావ్లివాలనాకేడె రాఖిలీన్‍, బండాఫర్‍ ముద్రనాఖీన్‍ సమాధినా జత్తన్ కర్యూ. ");
INSERT INTO vgr_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","ఆరామ్ను ధన్‍హుయిగు తెదె పాసల్‍ ఆదివారంనా, వ్యానే హఃత్రే మగ్దలేన మరియబి, బుజేక్ మరియబీ, సమాధిన దేఖన ఆయు. ");
INSERT INTO vgr_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","తెదేస్‍ ఏక్ భూకంపమ్‍ ఆయూ, హదేక్‍ ప్రభువును దూత స్వర్గంమతూ ఉత్రి ఆయిన్, యో బంఢాన ధక్లిదీన్ ఇనఫర్ బేసిగు. ");
INSERT INTO vgr_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","యో దూతను రూప్‍ జంకనితరా తూ, ఇను లుంగ్డా భరప్ ఎత్రె ధ్హోలు ర్హహీన్ థూ. ");
INSERT INTO vgr_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","ఇన దేఖిన్ ఢర్జావమా కావ్లివాలు కాప్తూహుయీన్‍ మరిగయూతె ఇవ్నితరా థా. ");
INSERT INTO vgr_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","దూత యోబాయికోవ్నా దేఖిన తుమె ఢర్‍నొకొ, సిల్వఫర్ నాక్యతె యేసునా తుమె ధూండుకరస్ కరి మన మాలం; ");
INSERT INTO vgr_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","యో అజ్గకొయిని యో బోల్యొ తిమ్మస్ ఇనే ఉట్టీన్ ఛా; ఆవో ప్రభువునా రాక్యుతే జొగొదేఖిన్ ");
INSERT INTO vgr_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","ఎగ్గీస్ జైయిన్, ఇనె మరణ్‍మతూ ఉట్టీన్‍ ఛాకరి, ఇను సిష్యుల్నా మాలంకరావొ హదేక్ యో గలిలయమాహీ తుమారేతి అగాఢి జంకరస్, ఎజ్గ తుమె ఇనా దేక్చూ హదేక్ మే తుమారేతి గుర్తు బోలుకరూస్‍కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","ఇవ్నె ఢర్తూ, కెత్రూకి ఖుషితి సమాధికంతూ ఎగ్గీస్ జైయిన్, ఇన సిష్యూల్నా యో వర్తమానంనా బోలనా మిలాతూ జంకరమా! ");
INSERT INTO vgr_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","యేసు ఇవ్నా అగాఢి జైయిన్, తుమ్న అచ్చుహువదాకరి బోల్యొ. ఇవ్నె ఇనకనా ఆయిన్, ఇన ఘోడధరిన్ ఇన హఃలామ్ కరమా ");
INSERT INTO vgr_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","యేసు ఢరనొకొ తుమె జైయిన్, మార భైయ్యా గలిలయమా జానుకరి ఇవ్నె ఎజ్గా మనదేక్చెకరి బోల్కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","ఇవ్నె జంకరమా కావ్లివాలతి థోడుజణు నంగర్మా ఆయిన్ జరిగ్యూతె సంగతుల్‍హాఃరు అస్లియాజకుడ్‍నా బోల్యు. ");
INSERT INTO vgr_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","అనటేకె ఇవ్నె మోటావ్‍తి మలీన్ ఆయిన్ యోసోఛిన్ యోసైనికుల్నా ఘనూ దవ్లత్‍దీన్! ");
INSERT INTO vgr_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","బుజు హమే హుఃయీన్‍ ర్హావమా, ఇను సిష్యుల్ రాత్నువహఃత్‍మా ఆయిన్, ఇన పల్లీన్ గయూకరి, తుమె బోలొ. ");
INSERT INTO vgr_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","పిలాతును కాన్మా హఃమ్జాయుతొ తెదె హమె ఇన సోపొకరీన్, తుమ్న షానుకష్టం కొయినితిమ్ హమె దేక్చూకరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","తెదె ఇవ్నె యో దవ్లత్‍లీన్ ఇవ్నా బోల్యాతిమ్ కర్యూ. ఆవాత్ యూదల్మా హఃమ్జాయిన్ హంకెతోడిబీ, బొల్లెంకరస్‍. ");
INSERT INTO vgr_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","గ్యారజణ సిష్యుల్ యేసు ఎంచిరాక్యొతె గలిలయమా జైన్, యేసు బోల్యొతె ఫహాడ్‍ఫర్ గయా. ");
INSERT INTO vgr_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","ఎజ్గ యేసునా దేఖిన్ ఇనా హాఃమె హాఃలామ్‍ కర్యా పన్కి, థోడుజణు సందేహం కర్యూ. ");
INSERT INTO vgr_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","తెదె యేసూ ఇవ్నాకన ఆయిన్ బోల్యొ “స్వర్గంమాతోబి, ధర్తీఫర్‍తోబి మన సర్వాధికారమ్‍ దెవ్వాయ్‍రూస్. ");
INSERT INTO vgr_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","ఇనటేకె తుమె హాఃరసమస్త ములక్‍మా జైన్‍, అద్మియేనా సిష్యుల్నితరా కరొ భాన నామ్‍హో, ఛియ్యానూ నామ్ హో, పవిత్రాత్మానా నామ్తి, ఇవ్నా బాప్తిస్మమ్‍ దెవో. ");
INSERT INTO vgr_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","మే తుమ్నా కెహూ సంగతుల్నా ఆజ్ఞదిదోతె యోహాఃరు మాలంకర్నూకరి ఇవ్నా భోదించొ, హాదేక్ యుగసమాప్తీతోడి తుమారకేడె మే రైయిస్‍కరి ఇవ్నేతి బోల్యొ.”");
INSERT INTO vgr_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","దేవ్నొ ఛియ్యోహుయోతె యేసు క్రీస్తును సువార్త సురుహుంక్రస్. ");
INSERT INTO vgr_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","కెత్రూకి వరహ్క్ నా అగాఢి! ప్రవక్తాహుయూతె యెషయానా హాతె లేఖనాల్‍మా లిఖ్కాయ్రూతిమ్ “హదేక్, మార దూతనా తారేహూః అగాఢి బోలిమొక్లుకరూస్” “ఇనే తారా వాట్నా హూఃదు కర్షే కరిబోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","జాఢిను జొగొమా, ఛిక్రాన్‍ మ్హేందుకరతే ఏక్ను ఆవాజ్! ప్రభును వాట్నా హూఃదు కరొ, ఇన వాట్నా హఃడక్ కరొ.” ");
INSERT INTO vgr_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","బాప్తిస్మమ్‌ దెవ్వాళొ యోహాన్‍ జాఢిమా రహీన్‍, పాప్‍ మాప్‍హువనాటేకె దిల్‍ బద్లాయ్‍లేనుకరి బోల్తొహుయూన్ బాప్తిస్మమ్‍నాటేకె ప్రచార్‍కర్తొ ర్హయో. ");
INSERT INTO vgr_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","తెదె యూదయ దేహ్క్ ను హాఃరుజనూ, బుజు యేరుషలేమ్‍నూ హఃయర్ను ఇవ్నె హాఃరుజనూ బాప్తిస్మమ్‍ దెవ్వాళొ యోహాన్‍కనా ఆయిన్, ఇవ్ను పాపల్నా ఒప్పిలేతుహుయీన్, యోర్దాన్‍‍ నదిమా ఇన హాతెహూః బాప్తిస్మమ్ లీదు. ");
INSERT INTO vgr_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","యోహాన్ ఊట్ను కేహ్‍క్తి కర్యుతె లుంగ్డాన పేరిన్‍, కంబర్నా చాంమ్డును పట్టి బ్హాంధిలేతొథొ. జాఢిను షేత్నా, చిడ్డావ్నా ఖావాను ఖాణు. ");
INSERT INTO vgr_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","ఇనె అమ్ బోల్యొ, “మారొ పాసల్ మారేతీబి షక్తివాలొ వళోవాస్. మే జుఖిన్ ఇని చెప్లె కాఢనబీ యెత్రె లాయక్‍ కొయిని” కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","“మే తుమ్నా పానిమా బాప్తిస్మమ్‍ దెంక్రూస్ పన్కి, యో తుమ్న పరిసుద్ధాత్మమా బాప్తిస్మమ్ దిసె” కరి బోలిన్‍ ప్రచార్‍కర్తొ ర్హయ్యో. ");
INSERT INTO vgr_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","యోధన్మా యేసు గలిలయమాను నజరేతుకంతూ ఆయిన్, యోహాన్నాహాతె యోర్దాన్ నదిమా బాప్తిస్మమ్‍ లిదొ. ");
INSERT INTO vgr_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","తెదేస్‍ యేసు పానిమతూ బ్హాధర్ ఆంక్రమా, ఆకాష్ ఫాటీన్ ఎజ్గతూ పవిత్రాత్మ ఏక్ పర్యావ్నితరా ఇనావుప్పర్ ఉత్రీన్ ఆయుతె దేక్యొ. ");
INSERT INTO vgr_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","బుజూ ఆకాష్‍మతూ ఏక్ ఆవాజ్ ఆయూ, “తూస్ మారొ లాఢ్‍ ఛియ్యో, మే తారకనా ఘణూ ఖుషీహుంక్రూస్.” ");
INSERT INTO vgr_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","తెదేస్ పవిత్రాత్మా యేసునా జాఢినుజొగొమా లీన్ గయూ. ");
INSERT INTO vgr_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","యో జాఢిమా చాలిహ్ః ధన్ ర్హాతొ, సైతన్నా హాతె కెత్రేకి హఃతావ్‍ణి పడ్యొ. యో జాన్వార్‍నా ఇచ్మాబి జివీన్ ర్హయ్యొ బుజు దేవ్నుదూతల్ ఇన సేవా కర్తూరయ్యూ. ");
INSERT INTO vgr_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","యోహాన్నా లీజైన్ ఠాణమాగల్ దేవమా, యేసు గలిలయమా జైయిన్‍, దేవ్ను సువార్తనా ప్రచార్‍ కర్యొ. ");
INSERT INTO vgr_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","యో అమ్ బోల్యొ “దేవ్‍నూ రాజ్యం ఆంక్రస్ యోవహఃత్‍ కందేస్ ఆయుత్రు, తుమె దిల్ బద్లాలీన్ దేవ్ను సువార్తనా నమ్మో” కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","యేసు గలిలయ ధర్యావ్‍ను కనారిన జాతొహుయిన్ ర్హావమా, మాస్లా ధరవాళ్ల సీమోన్‍బి, ఇను భై హుయోతె అంద్రెయ ధర్వావ్‍మా ఝాళ్ నాఖను ధేక్యొ. ");
INSERT INTO vgr_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","యో ఇవ్నెతి అమ్ బోల్యొ. “మారకేడె ఆవొ, మే తుమ్న అద్మినా ధరను ఝాళ్నితర కరూస్‍కరి బోల్యొ.” ");
INSERT INTO vgr_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","తెదేస్ ఇవ్నె ఝాళ్‍ మ్హేందీన్ ఇనకేడె గయూ. ");
INSERT INTO vgr_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","యో జరా అగాఢి జైయిన్‍ జెబెదయ్‍నొ ఛియ్యో యాకోబ్‍బి, ఇనొ భై హుయోతె యోహాన్, ఇవ్నె ఢోంగమా రైహీన్ ఇవ్ను ఝాళ్‍ అష్యల్ కరుకరతె దేక్యొ. ");
INSERT INTO vgr_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","యేసు ఇవ్నా దేఖిన్ బులాయో తెదేస్ ఇను భా హుయోతె జెబెదయిను ఢోంగమా కూలిన కామ్ కరూకరతె ఇవ్నకనస్ మ్హెందీన్ యేసునాకేడె గయా. ");
INSERT INTO vgr_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","యేసు ఇను సిష్యుల్తి మలీన్ కపెర్నహూమ్‍ నంగర్‍మా జావమా, యోధన్నె ఆరామ్‍కరను ధన్ ఆవమా, యో న్యావ్‍నుజొగొమా జైయిన్ దేవ్ని వాతేనా బోధించొ. ");
INSERT INTO vgr_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","యో బోల్యొతె వాతె హంమ్జీన్, ఎజ్గఛాతె హాఃరుజణు అష్యంహుయుగు. సానకతొ యో షాస్ర్తుల్‍నితరా కహేతిమ్ అధికార్‍ఛాతె ఇవ్నింతరా బోధించొ. ");
INSERT INTO vgr_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","యోవొహఃత్ ఇవ్నూ న్యావ్నుజొగొమా వ్వాయిరోను ఛంద్ ‍ధర్యూతె ఏక్ అద్మి రయ్యోథొ. ");
INSERT INTO vgr_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","యో అమ్ బోల్యొ, “నజరేత్నొ యేసు, హమారేతి తునా ష్యానుకామ్? హమ్న నాష్‍ కరనటేకె ఆయోనా? తూ కోన్కి హమ్నా మాలం తూ దేవ్నొ పరిసుద్ధుడ్‍” కరి ఛిక్రాణ్ మ్హేంద్యూ. ");
INSERT INTO vgr_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","ఇనటేకె యేసు, “గఛ్చూప్‍తి ర్హా? కరి బోలిన్, ఇన బెందీన చలోజా” కరి గుర్‍ఖైన్‍ బోలమా. ");
INSERT INTO vgr_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","యో వ్వాయిరోనుఛంద్‍ ఇన తర్పైఢీన్ మోటు ఛిక్రాణ్ మ్హేల్తూహుయీన్ ఇనా మ్హైతి బ్హాధర్ నిక్లిగు. ");
INSERT INTO vgr_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","అద్మిహాఃరు గ్హనూ అష్యంహుయు. ఆసాత్కి? “ఆసాని నవీబోధ? ఇనె అధికార్‍తి వాత్ బోలుకరస్, వ్యారోను ఛంద్నా ఆజ్ఞా దిదొతో యోభి వాత్‍ హఃమ్జుకరాస్” కరి యేక్నూ ఏక్‍ వాత్ బొల్లీదు. ");
INSERT INTO vgr_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","తెదేస్ యోవాతె గలిలయమా ఛ్చాతె యోదేహ్క్ అఖ్కునా ఇన గురించి ప్హైలాయిగయూ. ");
INSERT INTO vgr_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","యేసు ఇను సిష్యుల్ న్యావ్‍నుజొగొతూ జైయిన్‍ యాకోబ్‍తీ, బుజు యోహాన్‍తీ సీమోన్ అంద్రెయకరి ఇవ్ను ఘర్మా గయా. ");
INSERT INTO vgr_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","సీమోన్‍ని అత్తె తావ్తీ మంచొఫర్‍ క్హూతి రవ్వమా, తెదేస్‍ ఇవ్నే ఇనా బారెమా యేసునా బోల్యా. ");
INSERT INTO vgr_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","యో బాయికోకనా హఃదె ఆయిన్, హాత్‍ ధరీన్ ఉట్టాఢీన్ బెహాఃడ్యొ; తెదె యోబాయికోన తావ్‍ మ్హేందమా, యో తెదేస్ ఇవ్నా సేవ కరలగి. ");
INSERT INTO vgr_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","యో ధన్నె హాఃమ్జెహువదీన్, ఎజ్గఛాతె అద్మిహాఃరు కెత్రూకి రొగాఢివాలనా భూత్‍ దర్రాక్యూతె అద్మియేనా యేసుకనా బులాయిలీన్ ఆయు. ");
INSERT INTO vgr_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","యో గామ్ను ఘణూ అద్మి యోఛాతె గ్హేర్‍నా హాఃమె మలీన్‍ థూ. ");
INSERT INTO vgr_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","యో కెత్రూకి రొగ్హాడితి హఃతుకరతె హాఃరవ్నా యేసు అష్యల్ కరీన్, కెత్రూకి భూత్‍మతూ చొఢాయ్యో, యో ఇవ్నా వాతె బోలదిదోకొయిని, సానకతో యో కోన్కి భూత్‍నా మాలం. ");
INSERT INTO vgr_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","యేసు వ్హానె హఃత్రేస్ ఘర్ బెంధీన్ బుజు రాత్ రవ్వామస్‍ కోణ్ కొయింతె జంగల్‍నుజొగొమా జైయిన్, ఎజ్గ ప్రార్థనా కరుకరా. ");
INSERT INTO vgr_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","పన్కి, యేసునటేకె సీమోన్‍ బుజు ఇనకేడె ఛాతె హాఃరుజణూ ధూండన గయూ. ");
INSERT INTO vgr_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","ఇనా కెదె దేఖ్యకి, ఇనేతి “హాఃరు తారటేకె దూంఢు కరియేస్” కరిబోలమా. ");
INSERT INTO vgr_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","తెదె యేసు ఇవ్నె బోల్యుతె వాత్‍నా పేడ్‍తొ హూయిన్, “ఆవో అలధా గామేవ్‍మా జైన్ ప్రచార్ కరియే, మే ఆయోతేబి అనస్‍టేకె కరి” బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","యో గలిలయ జొగొమా హాఃరుఫరీన్ న్యావ్‍నుజొగొమా ప్రచార్‍ కర్తొ, భూత్‍మతూ చొఢావ్తొ ర్హయో. ");
INSERT INTO vgr_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","ఏక్ కొహోడ్తి బాధ పడుకరతె అద్మి ఇన క్హామె ఆయిన్, డుక్నిఫర్ బేసిన్, “తున ఇష్టంహుయూతో మే హుఃద్రీస్” కరి ఇనేతి బోలిన్‍ బతిమాల్లిదొ. ");
INSERT INTO vgr_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","తెదె యేసు ఇనఫర్‍ గోర్‍హుయీన్‍, ఇనా హాత్ ఛీదుకరీన్ ఛీమిన్ “మన ఇష్టమస్, తూ అష్యల్‍హూ కరి బోలీన్ ఇనా ఛీమ్యో.” ");
INSERT INTO vgr_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","తెదేస్ కొహోడ్నురోగ్ ఇనా మ్హెందీన్ జావమా, ఇనె హుఃద్రీన్‍ హుయొ. ");
INSERT INTO vgr_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","ఇనా బోలి మోక్లొతొ హుయిన్, ");
INSERT INTO vgr_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“హదేక్ కినేతీబి సాత్బి నొకొబోలీస్; పన్కి తూ సుధ్ద్ హుయోకరి జైయిన్ తార యాజకుడ్‍నా బోల్జొ, మోషే ఆజ్ఞాదిదోతె కానుకల్నా తూ అషల్ హుయోకరి క్హాఛి సాబుత్ కరైలాకరి జొరేక్హు బొల్యొ.” ");
INSERT INTO vgr_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","హుయుతోబి యో జైయిన్, హాఃరవ్నా బోల్దెవనబీ, యో సంగతినా ప్రచార్‍ కరనబీ సురుకర్యొ ఇనటెకేస్ యేసునా యోగామ్మా జావన కోహుయుని, గామ్నా బ్హాదర్ జాఢిను జొగొమా రవ్వామా, అనటేకే చార్‍ బాజుతీ అద్మిహాఃరు ఇనకనా ఆయు. ");
INSERT INTO vgr_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","థోడు ధన్‍నా పాసల్ యేసు బుజు కపెర్నహూమ్‍ నంగర్‍మా గయో యో ఘేర్‍కనా ఆయ్రోస్‍కరి అద్మిహాఃరవ్నా మాలంహుయు. ");
INSERT INTO vgr_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","అనటేకె అద్మిహాఃరు మలీన్ ఆవమా, ఉబ్రీన్‍ రవ్వాన ఇవ్నా దర్వాజూణు జొగొబీ కొయిని. యో ఇవ్నా వాక్యంనా బోధించుకరమా ");
INSERT INTO vgr_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","తెదేస్ థోడుజణు ఏక్ జూఠొబర్యూ అద్మినా ఛార్‍ జణనాహాతె డ్హొవాఢిలీన్ ఇనకనా ఆయు. ");
INSERT INTO vgr_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","పన్కి గ్హణు అద్మిరవ్వామా ఇవ్నె ఇనా యేసుకనా లీన్‍జావనా కోహుయిని. ఇనటేకె ఇవ్నే యేసు ఛాతేస్ యోఘర్‍నా ఉప్పర్ ధరాషు కప్పుకాఢీన్ జూఠొపడ్యుతె అద్మినా యో హుఃతొత్తె ఛాద్రి హాఃమెస్ ఇన యేసునా హాఃమే ఉత్తార్యూ. ");
INSERT INTO vgr_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","యేసు ఇవ్ను విష్వాస్ దేఖిన్ జూఠొపడ్యొతీ మారో “ఛియ్యా తారు పాప్‍ మాప్‍హుయ్రూస్” కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","షాస్ర్తుల్‍మా థోడుజణు ఎజ్గా బేసిన్‍ రయ్యూతు. ");
INSERT INTO vgr_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“ఇవ్నె అనే అమ్ షాన బోలుకరస్? దేవ్నా దూషించిను కాహేనా దేవ్ ఏక్జనో తప్ప బుజు కోన్‍బి పాప్‍నా మాప్‍కరవాలొ కోణ్” కరి ఇవ్ను దిల్మా సోఛిల్దూ. ");
INSERT INTO vgr_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","యేసు ఇనా ఆత్మమా మాలంకర్లిదొకి ఇవ్నె ఇవ్నా దిల్‍నా మైహీ సాత్ సోచుక్రాస్‍కరి యో ఇవ్నేతి అమ్ బొల్యొ. “తుమె ఆ లపుట్‍ను సంగతిన తుమార ధిల్‍మా సాన సోచిలెంకస్. ");
INSERT INTO vgr_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","ఆ జూఠొపడ్యుతె అద్మితి, కెహూ హాల్కు? జూఠొపడ్యుతె అద్మినా తారు పాప్‍మ్నా మాప్‍కర్సేకరి బోలను హల్కునా? న్హైతొ, తూ ఉట్టీన్ తారు ఛాద్రిపల్లీన్ ఛాల్కరి బోలను హల్కునా? ");
INSERT INTO vgr_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","పన్కి, ధర్తిమా పాప్‍నా మాప్‍కరనూ అధికార్‍ అద్మినఛియ్యోనాస్ ఛా” కరి తుమె మాలంకర్లేనుకరి, ఇవ్నేతి బోలిన్‍. ");
INSERT INTO vgr_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","యో “జూఠొ పడ్యునా దేఖిన్, తూ ఉట్టీన్ తారిఛాద్రి పల్లీన్ ఘర్‍కన జా” కరి తారేహూః బోలు కరూస్‍కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","తెదేస్‍ జూఠొపడ్యుతె ఇనె ఉట్టీన్, ఛాద్రిపల్లీన్, ఇవ్నె హాఃరవ్నా హాఃమేస్ చాలిన్‍ గయో, అనటేకె ఎజ్గఛాతె ఇవ్నెహాఃరు అష్యంహుయు, “హమే అమ్నూ జోడ్ను కార్యల్‍నా కెదేబి కోదేఖ్యని” కరి బోల్తూహుయీన్‍ దేవ్‍న మహిమపరిచా. ");
INSERT INTO vgr_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","అజు యేసు గలిలయ దర్యావ్‍న కనారినా జాతోర్హంకరా, గ్హణు అద్మినా గళ్లో ఇనకనా ఆవమా, యో ఇవ్నా దేవ్‍ను వాతె బోలాను సురుకర్యొ. ");
INSERT INTO vgr_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","ఇజ్గాతి నిఖీన్ అగాఢి చాల్తొహుయీన్, జంక్రతొ థొ అల్పయినొ ఛియ్యోహుయోతె లేవి పన్ను వసూల్‍కరవాలో బేసిన్‍ర్హావను దేక్యొ, యేసు ఇనేతి, “మరాకేడె ఆవ్” కరి బోలమా, లేవి ఉట్టీన్ ఇనకేడె గయో. ");
INSERT INTO vgr_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","ఇన పాసల్ యేసు, లేవినా ఘర్‍మా ధాన్‍ఖావన బేసీన్‍ ర్హావమా, సుంకరల్, పాపిమాబి కెత్రూకిజణూ ఆయిన్ యేసుతి, ఇను సిష్యుల్‍తీబి బేసిన్‍ ర్హైయుతు. అజాత్నూ కెత్రూకిజణూ; ఇవ్నెహాఃరు ఇన కేడెగయూ. ");
INSERT INTO vgr_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","పరిసయ్యుల్‍మా ఛాతె షాస్ర్తుల్‍న యో సుంకరుల్‍కేడె, పాప్‍కర్యూహు ఇవ్నెతీబి, పన్ను వసూల్‍కరతె ఇవ్నేతి బేసిన్‍ ధాన్‍ ఖంక్రతె దేఖిన్, యో సుంకరుల్‍తీబి “పాప్ కర్యూతె బుజు పన్ను వసూల్‍ కరవాలతీ ష్యాన మలీన్ ధాన్ ఖంకరస్ కరి” ఇను సిష్యుల్తి పుఛ్చావమా. ");
INSERT INTO vgr_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","ఆవాత్‍ హఃమ్జిన్ యేసు ఇవ్నేతి బొల్యొ, రొగాఢి వాలవ్‍నా వైద్యుడుని అవసరం ర్హాస్ పన్కి, “అష్యల్‍తి ర్హావాలనా అవసరం కోర్హాయిని, మే పాప్‍కర్యూహువాలనా బులావనాటేకె ఆయో” పన్కి, నీతిమంతుడ్‍నా బులావనాటేకె కోఆయోని, కరి ఇవ్నేతి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","యోహాన్‍నా సిష్యుల్‍బి, పరిసయ్యుల్‍బి, పస్తుతీ ర్హాస్. ఇవ్నె యేసునా ఖందె ఆయిన్, “యోహాన్‍నా సిష్యుల్బీ బుజు పరిసయ్యుల్‍న సిష్యుల్ పస్తుర్హాస్ పన్కి, తార సిష్యుల్ సే! కోర్హైయ్‍ని?” అన హేతువుషాత్‍ కరి ఇనె పుఛ్చాయా. ");
INSERT INTO vgr_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","యేసు ఇవ్నేతి బోల్యొ, “నౌరో ఇవ్నేతి ర్హావయెత్రధన్ య్హానా ఘర్మానూ హాఃరూ ఉపవాస్ ర్హాసెనా? నౌరొ ఇవ్నేతి ర్హావయెత్రధన్ య్హాన ఘర్మాను హాఃరు ఉపవాస్ ర్హాసెకొయిని.” ");
INSERT INTO vgr_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","పన్కి, “ఇవ్నకంతి నౌరొనా లీన్ జావాను ధన్ ఆవ్సే, తెదె యోధన్నే ఇవ్నె ఉపవాస్ కర్సే” కరి యేసు బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","ఫాటిగుతే “జూణు లుంగ్డఫర్ నవూలుంగ్డూ గాలీన్ కోన్బి సివ్సేనా? ఇమ్ కర్యుతొ జూణులుంగ్డఫర్, నవూలుంగ్డు, సివితో అజు జరా కెఛాయిన్ మోటువుసే.” ");
INSERT INTO vgr_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","జూణు చాంబ్డనూ సంఛిమ నవూ ద్రాక్చను రహ్‍క్నా కోన్బి నాఖకొయిని; ఇమ్ నాక్యుతో, నవూ ద్రాక్చాను రహ్క్ యో జూణు సంఛినా పాటహఃర్కూ కరస్. పాటిగుతే సంఛిబి ద్రాక్చాబి బే మలాయుతో కర్రాబ్ హుసే; ఇనటేకెస్ “నవూ ద్రాక్చాను రహ్క్ నవూ సంఛిమస్ నాక్నూ” కరి ఇనే బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","బుజు ఆరమ్నుధనే యేసు ఖేథర్‍మతూ జవుంకర్తొ థొ. ఇనా సిష్యుల్ మారగ్‍ఫర్‍ జాతూ ఖావనటేకె మొక్కజొన్నల్నా తోడలగ్యూ. ");
INSERT INTO vgr_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","అనటేకె యోదేఖిన్ పరిసయ్యుల్ యేసునా బోల్యా, “హదేక్ ఇవ్నే ధర్మషాస్ర్తమ్‍తిమ్ ఆరమ్‍కరను ధన్ నాకర్నూతె కామ్ ఇవ్నే కింమ్‍ కరూకరస్?” కరి ఇనేతి పుఛ్చాయ్యా. ");
INSERT INTO vgr_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","యేసు ఇవ్నేతి అమ్‍ బోల్యొ, “దావీద్‍నాకేడె ఛాతె ఇవ్నె బుఖ్కేతి ర్హావమా, తెదె ఇవ్నా ధాన్ హోనుకరీ, తెదె దావిదు సాత్‍కార్యొకి తుమె కెదేబి పడ్యాకొయినిసూ?” ");
INSERT INTO vgr_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","అబ్యాతార్‍ ప్రధానయాజకుడ్‍ హుయిన్‍ ధన్మా దావిద్‍నొ దేవ్ను మందిరంమా జైయిన్ దేవ్నా హాఃమెస్ బేందిరాక్యుతె రొటొనా పల్లీన్, యోఖైయిన్ ఇనా కెడెఛ్చాతె ఇవ్నా దిదొ. ధర్మషాస్ర్తమ్‍నితరా “ఆ రొటొనా యాజకుల్ తప్పా అజు కొన్బీ నా ఖాణు” కరి బొల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","బుజు యేసు ఇవ్నేతి అమ్ బొల్యొ ఆరామ్‍న ధన్ అద్మినటేకెస్‍ బాణాయు పన్కి, ఆరామ్‍న ధన్‍టేకె అద్మినా బనాయుకొయిని. ");
INSERT INTO vgr_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","అనటేకె అద్మినొఛియ్యో ఆరామ్ను ధన్నేనా వుప్పర్‍బీ ప్రభువుహుయిన్‍ ఛాకరి ఇవ్నెతి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","తెదె యేసు న్యావ్‍నుజొగొమా అజు పేసిజావమా, ఇజ్గా హాత్ పడిగుతే ఏక్ అద్మి ఎజ్గ థూ. ");
INSERT INTO vgr_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","ఎజ్గాను అద్మియే ఇనఫర్ నింధనాక్నుకరి ఆరామ్‍కరను ధన్ ఇనా అష్యల్ కరాస్‍షికి కరి దేఖూకర్తుతూ. ");
INSERT INTO vgr_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","యేసు బోల్యొ, తూ ఆయిన్ “హాఃరవ్నా ఇచ్మా ఉబ్రిరా! కరి హత్‍పఢిగయుతె అద్మినా బోల్యొ.” ");
INSERT INTO vgr_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","తెదె యో ఇవ్నా దేఖిన్, “ఆరామ్ కరనధన్నె తునా అష్యల్ కరను ధర్మంకి, న్హైతొ కర్రాబ్ కరను ధర్మం, ఏక్ జాన్‍నా బఛ్చావాను ధర్మంకి, జాన్‍నా మర్రాఖను ధర్మం” కరి పుఛ్చావమా, అనటేకె ఇవ్నె గఛ్చూప్ థూ. ");
INSERT INTO vgr_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","యో ఇవ్ను ఘట్ జాన్నా దేఖిన్ బాధపడిన్‍, చంఢాల్తి ఇవ్నె మ్హణి దేఖిన్, యో హాత్ పఢ్యుగుతే అద్మినా తారుహాత్ హఃడక్‍కరి ఇన బోల్యొ. యో ఇమ్ కరమా “ఎగ్గీస్ అష్యల్ హూయ్‍గొ.” ");
INSERT INTO vgr_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","ఇన పాసల్ న్యావ్‍నుజొగొమతూ పరిసయ్యుల్ బ్హాధర్ ఆయిన్ హేరోదీయల్తీ మలీన్, కిమ్‍బి అన మర్రాయ్‍ నాక్నుకరి ఇన బారెమా వైరిహాఃలె సోఛిలీదు. ");
INSERT INTO vgr_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","యేసు ఇను సిష్యుల్తి మలీన్ ధర్యావ్‍కన జొంకరమా, గలిలయమతూ, ఆయుతె గనూఅద్మి ఇనకేడె గయూ, ");
INSERT INTO vgr_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","బుజు యేసు కరుకరతే కెత్రూకి మోటుకామ్‍న హఃమ్జీన్, యూదయకంతూ, యెరూషలేమ్‍కంతూ, ఇదుమయకంతూ బుజు యొర్దాన్‍నదినాపార్‍తూ తూరు సిదొను, దేహ్క్ మతూ, కెత్రూకిజణు గళ్లొ గళ్లొనితర ఇనకనా ఆయూ. ");
INSERT INTO vgr_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","అద్మియే గుమ్మనితరా బ్హరాయ్‍రావను దేఖిన్, యో ఇవ్నమా నాపిఛ్చాయి జాణుతిమ్ యో ఇనా సిష్యుల్‍తి, మారనటేకె ఏక్ డొంగాన బనావోకరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","సానకతో యో రోగ్‍వాళ హాఃరవ్‍నా అష్యల్‍ కర్యొ. ఇనటేకె కెత్రూకి రోగ్తి ఛాతె హాఃరు ఇనా ఛీమ్నుకరి ఇనాఫర్ పఢ్తూర్హయూ. ");
INSERT INTO vgr_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","ఛంద్‍ ధర్రాక్యుతే ఇవ్నే ఇనా దేకూస్‍కరా ఇనహాఃమె డుక్నిఫర్‍ జుఖీన్ తూ “దేవ్నొ ఛియ్యోకరి ఛిక్రాన్ మేంద్యూ.” ");
INSERT INTO vgr_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","తెదె యేసు, మే కోన్కి, కినాబి నొకొ బోల్చూకరి, భూత్తీ ఖఛ్చితంగా ఆజ్ఞదిదొ. ");
INSERT INTO vgr_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","తెదె యేసు పహాఢ్ చఢీన్, ఇన ఇష్టహుయుతె ఇవ్నా బులావమా, ఇవ్నె ఇనకనా ఆయూ. ");
INSERT INTO vgr_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","బుజు ఇవ్నే ఇనేతి మలీన్‍ ర్హానుతిమ్‍బి భూత్‍నా నహాఃడను “యో భారఅద్మిన యెంచిలీన్, ఇవ్నా అపోస్తల్” కరి నామ్ బెందీన్, మారకేడె ర్హాణుకరి, సువార్తన బోల్నుకరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","అధికార్‍వాలా హుయీన్‍ సువార్త ప్రచార్‍కరనా ఇవ్నా భూత్‍ నహాఃడ్నూకరి ఇనే భాహారజణనా నియమించొ. ");
INSERT INTO vgr_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","ఇవ్నే కోన్‍కతో పేతుర్‍కరి నామ్‍ బేంద్యొతె సీమోన్‍. ");
INSERT INTO vgr_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","జెబెదయినొ బే ఛియ్యో; యాకోబ్‍, ఇనొ భై యోహాన్, ఇవ్నా బొయనేర్గెసు కరి నామ్ మ్హేల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","అంద్రెయ, ఫిలిప్పు, బర్తొలొమయి, మత్తయ, తోమా, అల్ఫయినొ ఛియ్యో యాకోబ్‍, తద్దయి, కనానీయుడుకరి బులావతే సీమోన్, ");
INSERT INTO vgr_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","యేసునా ధర్రాయ్‍దిదోతే ఇస్కరియోతు యూదా. ");
INSERT INTO vgr_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","ఇనా పాసల్ యేసు ఘర్మా ఆయోతెదె బుజు జనాభో బ్హారాయి‍న్ ఆయూ. అనటేకె యూవ్నా ఖాను ఖవానబీ వహఃత్‍ కోమల్యుని. ");
INSERT INTO vgr_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","ఇను ఘర్‍నూ అద్మియే, గామ్ వాలనూ వాత్న హాఃమ్జీన్, “ఇను హఃయల్ బదిలిగు” కరి ఇన బులాలిజావన ఆయు. ");
INSERT INTO vgr_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","బుజు “యెరూషలేమ్ ఆయుతే షాస్ర్తుల్‍, బోలవాలు బోల్యా బయల్జెబూల్‍కరి బోలతె భూత్‍నొ మాలిక్‍ను మద్దత్‍తీస్‍ నహాఃడుకరస్” కరి బోల్యు. ");
INSERT INTO vgr_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","తెదె యేసు ఇవ్నాబారెమా ఉపమానంగోనితరా బోల్యొ, “సైతాన్, సేతాన్‍నా కిమ్ హక్కల్సే కరి బొల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","ఏక్ రాజ్యమ్ ఇనూ యోస్‍ దుష్మతీ అలాదు ర్హైతొ యోరాజ్యం కోఉబర్సేని.” ");
INSERT INTO vgr_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","ఏక్ ఘర్‍వాలు ఇమ్మస్ ఇన ఉప్పర్ యోస్ దుష్మన్‍తి అలాదు హుయుగుతో, యోఘేర్ ఉబ్బారిరాఖనాకోసేని. ");
INSERT INTO vgr_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","సైతాన్ ఇను యోస్‍ విరోధంతీ ఉబ్రీన్‍ అలాదు హుయిగుతొ తెదె ఇనె ఉబ్రాన హువకొయినితిమ్ పఢిజాసె. ");
INSERT INTO vgr_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“కోణ్‍బి కువ్వాత్ వాలను ఘర్‍మా ఛోర్‍కరనా కోహుసేని. యోకువ్వత్ వాలనా బాంద్యతోస్ పన్కి, ఇనా ఘర్‍మా ఇనురాచ్చు దౌవ్లత్‍నా పల్లిజవనా హుసె. ");
INSERT INTO vgr_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“మే ఖఛ్చితనంతి బోలుకరూస్, అద్మియే కరతే చ్హాడినా కెహూ పాప్‍నబీ, ఇవ్నూ దూషించవాలనాతోబి, మాప్‍కర్సే.” ");
INSERT INTO vgr_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","పన్కి “పరిసుద్ధాత్మనా దుషించవాలనా కోన్బి కెదేబి మాప్‍ కర్సేకొయిని.” నిత్యంను పాప్‍ కరవాలొహుయీన్‍ ర్హాసేకరి తుమారేతి ఖఛ్చితంగా బోలుకరూస్‍కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","సానకతొ ఇనే షాస్ర్తుల్ ఇన అపవిత్రాత్మ దర్యుతే వాలోకరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","యేసుని ఆయాబి బుజు ఇనా భైయ్యే ఆయిన్, బాధర్ వుబ్రిన్ యేసునా, బులావ్‍కరి ఏక్జణనా బోలిమోక్లు. యేసునా ఆష్పీస్ అద్మినొ గల్లోస్ బర్యాగు. ");
INSERT INTO vgr_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","ఇవ్నే ఇనా బొల్యా, “హదేక్ తారి ఆయా, బుజు భేనె‍, భైయ్యే బాధర్ వుబ్రిన్ తారటేకె దూంఢుకరాస్‍కరి ఇవ్నేతి” బోల్యా. ");
INSERT INTO vgr_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","ఇనటేకె యేసు ఇవ్నా బోల్యొకి, “కోణ్ మారి ఆయా కోన్‍ మార భైయ్యేకరి బోల్యు.” ");
INSERT INTO vgr_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","ఇనా ఆష్పిస్ బెట్యుతే ఇవ్నభనె “దేఖిన్, హదేక్‍ అవ్నేస్ మారి ఆయా, మార భైయ్యే కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","దేవ్ను వాత్‍ఫర్ చాలవాలుస్ మార భైయ్యే, మారి ‍భేనె, మారి ఆయా” కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","బుజు యేసు ధర్యావ్‍నా సేడె బోలను సురుకర్యొ, ఇనా ఆష్పీస్ గ్హణు అద్మి భర్యాయిజావమా యో ఢోంగఫర్ చఢీన్ బెట్టొ థొ, జనమ్ ధర్యావ్‍న కనారి జమీన్‍ఫర్‍ ఉభిర్యూ థూ. ");
INSERT INTO vgr_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","యో కెత్రూకి ఉపమానంతీ దేవ్ను వాతెనా బోల్తూహుయిన్, ఇవ్నేతి అమ్ బొల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","హంమ్జో; ఏక్ ఖేథర్ వాలు బింజొలా ఛిడ్కనటేకె ఖేథర్‍మా గయో. ");
INSERT INTO vgr_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","బుజు యో బింజొలానా ఖేథర్‍మా ఛిడ్కమా థోడు బింజొలా వాట్‍నా సేడె పడ్యు ఉప్పర్ ఉడతే జిన్వార్‍ ఆయిన్ బింజొలాన ఖైయినాకిదేస్. ");
INSERT INTO vgr_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","థోడు బింజొలా మాట్టికొయితె ఖేథర్‍మా పడ్యు; ఎజ్గా మాట్టి కమ్ ర్హావమా, థోడు బింజొలా మొల్కా పుట్యూ. ");
INSERT INTO vgr_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","పన్కి వ్హాను హూస్‍కరా తఢ్కో పడమా, జఢే మహీజైయిన్‍ నార్హావమా హుఃకైజాస్. ");
INSERT INTO vgr_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","థోడు బింజొలా కాఠన జాఢమ పడ్యూ; మొల్కా పుట్టాస్ పన్కి కాఠాన జిగ్రాబి వధీన్ యోమొల్కనా మోటా కోహువదేయిని. ");
INSERT INTO vgr_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","పన్కి “థోడు బింజోలు అష్యల్‍ ఖేథర్‍ఫర్ పడ్యు, యో పుట్టీన్ వధీన్ డోఢీహ్ః భాగ్, తీనీహ్ః భాగ్, ఖొః భాగ్, ఫాయ్‍దోనా దేస్.” ");
INSERT INTO vgr_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","బుజు యేసు ఇమ్ బోలిన్, “హఃమ్జనటేకె కాణ్‍ రవ్వాలు హఃమ్చే” కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","యో ఎకేలొ రయ్యోతెదె భ్హారజన సిష్యుల్తిబీ ఇనకేడె బర్హైన్‍ యో వాతె హఃమ్జుతె ఇవ్నేబి యో ఉపమానంనా బారెమాఇనా (బతిమాల్యూ) పుఛ్చాయూ. ");
INSERT INTO vgr_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","యేసు ఇవ్నేతి అమ్ బోల్యొ, “దేవ్‍ను రాజ్యంను వాతె మాలంకర్లేవనా రహాస్యంనూ అక్కల్ తుమ్న దేవావ్ రూస్.” పణ్కి అలాదవ్‍నా ఆవాత్ ఉపమానాంనితర బోలస్. ");
INSERT INTO vgr_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","పన్కి బాధర్‍ఛాతె ఇవ్నే ఏక్తార దేవ్‍నిబాజు ఫరీన్‍ పాప్‍మాప్ పొంద్చేకరి, హాఃరు ఉపమానంనా బోధించుకరస్‍కరి ఇవ్నేతి “ఇవ్నే దేఖీన్‍బి దేఖకొయినితిమ్, హాఃరు హఃమ్జీన్‍బీ హఃమ్జాకొయినితిమ్ ర్హాస్, పన్కీ ఏక్ వొహఃత్ కోణ్ దేవ్ మ్హణి ఫరాస్‍కీ ఇవ్నూ పాప్ మాప్‍హుసే” కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","యేసు ఇవ్నేతి అమ్ బొల్యొ “తుమ్ నా ఉపమానంనూ వాతె అర్థం” కొహుయినిస్యు? బుజు బాకిను ఉపమానం కిమ్ మాలంహూసే? ");
INSERT INTO vgr_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","ఖేథర్ నాఖవాళొ దేవ్ని వాక్యం నాక్హూకరస్. ");
INSERT INTO vgr_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","వాట్నాసేడే పడ్యూతె బింజోలానూ జోణ్‍నూ కోన్‍కతో, థోడు అద్మి వాక్యమ్ ఇవ్‍ణె హఃమ్జస్ పన్కి తెదేస్ సైతాన్ ఆయిన్ ఇవ్నమా ఛాతే వాక్యమ్‍నా పల్లిఛల్‍జాస్. ");
INSERT INTO vgr_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","థోడు ఫత్రొను జమీన్‍ఫర్ ఫడ్యూతె బింజొలానూ జోడ్నూ కోన్‍కతో, థోడు అద్మి వాక్యమ్‍న హఃమ్జుస్‍కర ఖుషీతీ ఓప్పిలెవ్వాలు. ");
INSERT INTO vgr_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","పన్కీ ఇవ్నమా జఢ్ నారవ్వమా థోడుధన్ ర్హాసేగాని, వాక్యమ్ ఇవ్నమా జాహఃత్ నాభడమా మిన్హత్‍, హింసల్ ఆయుతో కల్గితో ఇవ్నే దేవ్నా మ్హెందేస్. ");
INSERT INTO vgr_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","థోడుజణు కాఠాన జాఢమా ఫడ్యూతె బింజొలనూ జోణ్‍నూ. ");
INSERT INTO vgr_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","ఇవ్నె వాక్యంన హఃమ్జసే. పన్కి ఆ ములక్‍ను హఃయల్, ధన్ దౌవ్లత్‍నా ఆహ్క్, బుజు కెత్రూకి బాధల్ ఆహాఃరు వాక్యమ్నా ధాబి దేవమా యో ఫలింఛ కొయిని. ");
INSERT INTO vgr_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","“థోడుజణు అష్యల్ ఖేథర్‍ఫర్ పడ్యూతే ఇవ్నె వాక్మంమ్నా హఃమ్జీన్, ఇనా ఒప్పిలీన్ ఢోడీఖ్హ్ భాగ్, తీనీఖ్హ్ భాగ్, ఖోః భాగ్‍నీతరా ఫలించేకరి బోల్యొ.” ");
INSERT INTO vgr_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","బుజు యో ఇవ్నేతి “అమ్ బొల్యొ, తుమారమా కోన్బి దివ్వొనా భాళీన్ దీపస్తంభంఫర్ మ్హేలస్ పన్కి, మంచొనాహేట్ తోబి షేర్నూ ఢబ్బానా హేట్ మ్హేంధాకొయిని. ");
INSERT INTO vgr_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","లఫిర్యూతె కెహూబి బాధర్ పడ్‍స్యేకొయినితింమ్‍ ర్హాసేకొయిని; కయ్యూ వాతేబి బాధర్ పఢ్‍స్యే పన్కీ లఫి ర్హాసే కొయిని.” ");
INSERT INTO vgr_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","హాఃమ్జనటేకె కినాబీ కాణ్‍ రవ్వాలు జోఢీన్ హఃమ్జోకరీ బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","యేసు బుజుబి తుమె “సాత్ హఃమ్జుకరస్కి ఇనా జత్తన్‍తి దేఖిలేవొ, తుమె ఏక్న కిమ్ మోజీన్ దేంక్రస్‍కి దేవ్బి తుమ్నా ఇమ్మస్ మోజైన్ దిసె, అజు గ్హణు దెవ్వాసే. ");
INSERT INTO vgr_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","కినకనా ఛాకీ యువ్నా బుజు దెవ్వావ్సె, కొయింతేవాలకంతూ ఇవ్నకనా ఛాతే యోబి లేవయ్ జాస్యే కరి బోల్యొ.” ");
INSERT INTO vgr_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","బుజు యేసు అమ్ బొల్యొ, “దేవ్‍నూ రాజ్యం అమ్‍ఛా, ఏక్ జణో ఖేథర్‍మా బింజోలా ఛిడ్‍క్యో. ");
INSERT INTO vgr_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","యో కెత్రాకీ రాత్ నూధన్నూ క్హుత్యుతోబి, హోషార్ హూయోతోబి మొల్కల్ మ్హేల్‍తూ హుయిన్ కిమ్ ఆవాస్కి ఇనా మాలంకోహూవని. ");
INSERT INTO vgr_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","ఖేథర్‍ఫర్ అగాఢి మొల్కా పుట్టీన్, ఇనబాద్ మా పిందియే, ఇనబాద్‍మా బింజ్లొబీ భరైన్ పిక్యూ. ");
INSERT INTO vgr_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","ఖేథర్ ఫికీన్ వాఢను ధన్ ఆవమా యో ఖేథర్ వాడవళొ ధరాతి ధరీన్ ఖేథర్ వాఢస్ కరి బోల్యొ.” ");
INSERT INTO vgr_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","యేసు బుజు అమ్ బోల్యొ, “దేవ్ను రాజ్యంనా కినేతి పోల్చు? ఇనా కెహూ ఉపమానంతీ పోల్చిన్ బోల్ను? ");
INSERT INTO vgr_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","యో రాయ్‍ను బింజొలొనితరా పొలీన్ ఛా. ఖేథర్‍ఫర్ గాడ్యుతే హాఃరు బింజ్లాతిబి న్హాను బింజ్లొ. జమీన్‍ఫర్ ఛాతే జాఢ హారతీబి మోటు జాఢు హూవస్. ");
INSERT INTO vgr_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","పన్కి యో బింజొలో మొల్‍కా పుట్టీన్, ఖావనూ ఛట్టీనూ రాఛనూ జాఢ అక్కతి మోటు జాఢు హూయిన్ ఇను డాలియేబి మోటు వధీన్, ఇనా ఛాళమా ఆకాష్‍ను జిన్‍వార్ ఆయిన్ మ్హాళొ భంద్లీన్ జివాస్”కరి బోల్యు. ");
INSERT INTO vgr_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","ఇవ్నా హఃమ్జనా కెత్రే షక్తిఛాకీ యేత్రు దేవ్ని వాతేనా ఇమ్‍ను కెత్రూకి ఉపమానంతి దేవ్నూ వాతేనా బొల్తో ర్హయో. ");
INSERT INTO vgr_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","ఇవ్నె ఉపమానంనా బొల్యొకోయినితిమ్ కెహూ వాత్బి కోబొల్యొని, పన్కి యో ఇనా సిష్యుల్తి ఎకేలొ ర్హావనూ వొహఃత్ ఇవ్నెహాఃరు వివరించీన్ బోల్తొరయ్యో. ");
INSERT INTO vgr_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","యో ధన్నే హఃమ్జే యేసు ఇనా సిష్యుల్తి అమ్ బోల్యొ, “ఆవో ధర్యావ్నా ఫార్ జియ్యే” కరి బొలమా, ");
INSERT INTO vgr_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","ఇవ్నే ఎజ్గా ఛాతె అద్మిహాఃరవ్‍నా మ్హేందీన్ ఢోంగమా ఛాతె యేసునాకేడె బులైలీన్ గయూ, బుజు థోడు ఢోంగ ఇవ్నాకేడె ఆయు. ");
INSERT INTO vgr_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","ఎత్రస్‍మా మోటు వ్యాయ్రోన , తుఫాన్ ఆయిన్ జుఖాలొ యోఛాతె డోంగఫర్ పఢీన్ పానీ భరైగయూ. ");
INSERT INTO vgr_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","త్యో వహఃత్ యేసు ఢోంగమా పీటేను బాజుమా జైన్ షీనారులీన్ హుఃయిగొ థో. ఇవ్నే జైన్ ఇనా ఉట్టాడీన్ అమ్ బొల్యా “బోధకుడ్, హమే డుబిజౌంక్రేస్‍తోబి తున చింత కొయినిసూ?” కరి ఇనేతి బొల్యా. ");
INSERT INTO vgr_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","తెదె యేసు ఉట్టీన్ యో వాయిరోనా గుర్‍ఖైన్, జుకాళోతి బోల్యొ “షోపో హూయిజా, కరి బోలమా తుఫాన్ వాయిరో ఏక్ ధమ్ షాంతీహుయిగు.” ");
INSERT INTO vgr_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","తెదె యేసు సిష్యుల్‍తీ బోల్యొ, “తుమె ష్యాన యెత్రే ఢరూకరాస్? అజూన్‍బి తుమ్నా విస్వాష్ కొయిన్నా” కరి ఇవ్నేతి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","ఇవ్నే గ్హణు ఢరీజైన్, ఇవ్నమా ఇవ్నేస్ “ఆ కోన్కి వాయిరో తుఫాన్బి ఇని వాత్ హఃమ్జుకరస్” కరి సోఛిల్దొ. ");
INSERT INTO vgr_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","యేసు సిష్యుల్‍తి మలీన్ గలిలయధర్యావ్‍నా దాటీన్ గెరాసేనుల్‍ ఇలాహొఃమా ఆయూ. ");
INSERT INTO vgr_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","యేసు ఢోంగమతూ ఉత్రూస్‍కరా, ఛంద్‍ ధర్రాక్యూతే అద్మి గోరాఢమతూ బాధర్ ఆయిన్ ఇనా హాఃమె ఆయొథొ. ");
INSERT INTO vgr_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","యో గొరాఢవ్‍మా రవ్వాలు, లొఢాను హఃమ్‍ఖల్తి ఇనా బాంధీన్‍ ధర్రాకనా కినాహాత్ కోహుయూని. ");
INSERT INTO vgr_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","కెత్రూకి చోట్ ఇనా హాత్నా గోఢనా, లోఢను హఃమ్‍ఖల్తీ బాంద్యుతోబి, యో హఃమ్‍ఖల్‍నా తోఢిన్, టుక్డా టుక్డానితరా కర్నాక్‍తు థూ. అనటేకె ఇనా బాంధన కినా హాత్‍బి కోహోతు థూని. ");
INSERT INTO vgr_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","యో రాత్ను ధన్ను గోరాడ‍వ్‍మా, ఫహాడ్‍మా ఛిక్రాన్ మేల్తూహుయిన్ ఇనుయోస్ భండవ్‍తి మారిలేతు థూ. ");
INSERT INTO vgr_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","యో దూర్‍తీస్ యేసునా దేఖిన్, మిలావ్తూ హుయీన్ ఆయిన్ ఇనా హఃలామ్‍కరీన్‍; ");
INSERT INTO vgr_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","“యేసూ! సర్వోన్నతహుయోతే దేవ్నొ ఛియ్యో! మారేతి తున ష్యాను కామ్? మన కాయిబి నకొకర్కరి దేవ్నా నామ్‍తి బోలుకరూస్‍.” ");
INSERT INTO vgr_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","సానకతో యేసు ఇనేతి బోల్యొ, ఓ ఛంద్‍తీ ఆ అద్మినా బెందీన్‍ జా కరి ఇనేతి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","తెదె యేసు ఇనా పుఛ్చాయో, “తారు నామ్ సాత్? తెదె యో మారు నామ్ సెనా కరి బోల్యొ, కతొ హమె కెత్రూకి జణా.” ");
INSERT INTO vgr_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","ఇవ్నేయేసునా గ్హడీ ఘడి బతిమాలీన్ ఆ దేహ్ఃతి హమ్నా నకొనహాఃడ్‍కరి బోల్యు. ");
INSERT INTO vgr_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","ఎజ్గా ఏక్ పహాడ్నా బాజు ఢూకర్ను మోటుపాంబల్‍ ఛరుకర్తూ థూ. ");
INSERT INTO vgr_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","ఇనటేకె యో ఢూకర్‍మాతోబి, “హమ్నా బోలీమోకల్‍కరి యో భూత్‍ యేసునా బతిమాలిదూ.” ");
INSERT INTO vgr_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","తెదె యేసు ఇనేతి అద్మినా మ్హేందీన్ యో ఢూకర్‍మా జవోకరీ బోలమా, ఇమ్మస్ ఇవ్నే జైన్ ఢూకరేమా పేసిగయూ. ఢూకర్‍మా పేసిజావదీన్‍ లగభగ్‍ బే హాజార్ ఎత్రు గళ్ల్లో యో పాహాడ్‍తీ నాహూఃతూ హుయిన్ ధర్యావ్‍మా పఢీన్ జాన్‍ గొఠాయిన్‍ మరీగయూ. ");
INSERT INTO vgr_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","యో ఢూకర్‍నా ఛరాంతెవాల యోహాఃరు దేఖిన్ మిలైలీన్‍ జైన్ హాఃయార్‍మా, గామేవ్‍మా జైన్ హాఃర అద్మియేనా బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","జనమ్ జరుగ్యూతే ఇనా దేఖానటేకె యేసుకనా ఆయిన్ యో సేనాను భూత్‍న ధర్రాక్యుథూతె యో అద్మి అష్యల్ హుయీన్ లుంగఢా పేర్లీన్, భెటొతే ఇనా దేఖీన్ ఢరీగయూ. ");
INSERT INTO vgr_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","హుయుతే హాఃరు దేక్యూతె అద్మియే, భూత్‍ ధర్యుతే అద్మి ఇన హుయూతె, బుజు ఢూకర్నా హూయుతే హాఃరు ఆయూతె గామ్‍వాలనా బోలమా. ");
INSERT INTO vgr_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","ఇవ్నె యేసునా ఆ ఇలాహొఃనా మ్హేందీన్ ఛలోజాకరి బతిమాల్యు. ");
INSERT INTO vgr_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","తెదె యేసు ఢోంగ చఢుకరతో భూత్‍ ధర్రాక్యుతె అద్మి ఇనకనా జైన్ “మే తారకేడె రహీస్‍కరి ఇనా బతిమాల్లిదొ.” ");
INSERT INTO vgr_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","పన్కి, యేసు ఇన బులాలిజావన కోవొప్పేని నొకోఆవ్ పన్ని “తూ తార ఘర్‍వాలకనా జైయిన్, తారఫర్ దెఖ్కాడేతె గోర్‍నా, బుజు ప్రభువు కర్యోతె కార్యాల్‍హాఃరు తుమారు అద్మియేనా బోల్” కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","యో జైన్, యేసు ఇనా కర్యొతె హాఃరు దెకపొలిమా ప్రచార్ సురుకరమా, అద్మిహాఃరు అష్యం హూయ్గు. ");
INSERT INTO vgr_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","తెదె యేసు బుజు డొంగాఛడీన్ ధర్యావ్‍నా ఫార్తూ నిఖీన్ కెదె హంకడ్ ఆయోకి, తెదె మోటూఅద్మిను పాంబల్ ఇనకనా ఆయిన్ బారైగయూ. ");
INSERT INTO vgr_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","యో ధర్యావ్‍నూ కనారినా రవ్వమా, న్యావ్‍నుజొగొనూ అధికారుల్మా యాయిర్‍ కరి ఏక్జణో ఆయిన్ ఇనా దేహీఃన్ గోడఫర్ పఢీన్. ");
INSERT INTO vgr_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","“మారి ఛోరి మరణ్‍ జీవన్‍మా ఛా; తూ ఆయిన్ ఇనవుఫర్ హాత్‍బేంద్యొతో యో జీవహఃర్కూ ఇనా కెత్రూకి బతిమాల్లీదొ.” ");
INSERT INTO vgr_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","తెదె యేసు ఇనకేడె గయో; అధ్మీయేను పాంబల్ ఇనాకేడె జైన్, ఇనవుప్పర్ పడుకర్తూ థూ. ");
INSERT INTO vgr_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","భార వరహ్‍ఃక్తి ల్హొయి బేందుకరతె రోగ్వాలి బాయ్‍కొ కెత్రూకి వైదుగుల్‍నా హాతె గ్హనూ బాధపిడీన్ ");
INSERT INTO vgr_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","ఇనకనఛ్చాతె రఫ్యాహాఃరు ఖర్చుకరీన్ వతాలితోబి, జర్రాబి హుఃద్రికొయినీకరి అజుఘను చింతమా పడిగయీ. ");
INSERT INTO vgr_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","యో యేసుని వాతె హఃమ్జీన్, “ఇను లుంగ్డాన ఛేడొఛీమితోబి, భైస్ మే అష్యల్ హూయిజైస్” కరి ధిల్మా సోఛీన్ ");
INSERT INTO vgr_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","అద్మిను పాంబల్‍మతూ ఫీటె ఆయిన్ ఇను లుంగ్డనా ఛీమి. ");
INSERT INTO vgr_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","తెదేస్‍ యేసు ఛీమమా, యో హూఃదుహుయిగి. బాయికోను ల్హొయిజావనూ బంద్ హుయ్గు. ఇనా ఆంగ్తాన్ మతూ యోరోగ్ చలీగయూకరి మాలంకర్లీది. ");
INSERT INTO vgr_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","తెదేస్ యేసు ఇనకంతూ థాఖత్‍ బ్హాధర్ గయూకరీ ఇను యోస్‍ మాలంకర్లీన్, అద్మియేన బ్హనె ఫరీన్‍, “మార లుంగ్డనా కోణ్ ఛీమ్యుకరి పుఛ్చాయో.” ");
INSERT INTO vgr_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","ఇన సిష్యుల్ “అద్మినో గల్లొ హాఃరు తారవుఫర్ పడుకరతె దేఖుకరస్‍ని” మన ఛీమ్యుతె కోన్‍కరి పుఛ్చాంకరస్‍నా? కరి బోల్యా. ");
INSERT INTO vgr_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","యో ఆకామ్‍ కర్యుతె కోన్కరి బాయ్కొనా మాలంకర్నూకరి యో ఆస్పీస్ దేక్యొ. ");
INSERT INTO vgr_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","తెదె యోబాయికొ ఇనా హుయూతె మాలంకరీన్, ఢరీన్, కాప్తీహుయీన్ ఆయిన్, యేసునా హాఃమె గుడ్గీఫర్ పడీన్, ఇనా జరుగ్యూతె హాఃఛిన ఇనేతి బోలి. ");
INSERT INTO vgr_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","ఇనాటేకె యేసు అమ్ బొల్యొ, “ఛోరి, తారు విష్వాస్‍ తున రోగ్‍మతూ స్వస్థ్ కర్యు సమాధానంతి ఘర్‍కనా జా” తారి భాద ఛలీగు తునా స్వస్థతహువదాకరి యో బాయికోతి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","యేసు బుజుబి వాతె బోలుకరతొ తెదె, థోడుజణు న్యావ్‍నుజొగొ అధికార్‍కంతూ హఃబర్ బోలవాలో ఆయిన్ తారి ఛోరి మరీగయీ, తూ బోధకుడ్‍నా షాన మిన్హత్‍ మ్హేంధస్‍ కరి బోల్యా. ");
INSERT INTO vgr_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","యేసు ఇవ్నె బోల్యతే వాతెనా హఃమ్జొ కొయినితిమ్ “ఢర్‍నొకొ నమ్మకంతి ర్హా” కరి న్యావ్‍నుజొగొను మందిర్ను అధికారితి బోలిన్‍. ");
INSERT INTO vgr_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","యేసు పేతురునా, యాకోబ్‍నా, బుజు యాకోబ్‍నొ భై, యోహాన్‍కరి ఇవ్నా తప్ప బుజు కినాబి ఇనకేడె కోబులాలి గయోని. ");
INSERT INTO vgr_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","న్యావ్‍నుజొగొ అధికార్ను ఘర్‍కనా ఆవమా, యోఘర్ ‍వాళు హాఃరు భరైన్ రోతూహూయిన్, బాధ పడుకరతో యేసు దేఖిన్; ");
INSERT INTO vgr_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","యో ఘర్‍మా జైన్ “తుమె ష్యాన రొంక్రాస్? ఆ ఛొగిరి హుఃతీస్ పన్కి మరిగికొయిని” కరి ఇవ్నేతి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","ఇనటేకె ఇవ్నే ఇన ఘేళికర్యు, ఇనటేకె యేసు ఇవ్నా హాఃరవ్‍నా బాధర్ బోలిమోక్లీన్, యో ఛొగిరీనూ ఆయనా, భానా బుజు ఇనాకేడెఛ్చాతె సిష్యుల్ మలీన్, యో ఛొగిరి హుఃతితే జొగొమా గయా. ");
INSERT INTO vgr_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","యో ఛొగిరీనూ హాత్ ధరీన్ “తలీతాకుమీ” కతొ ఇను అర్థం “ఓ ఛోరి మే తారేతీ బోలుకరూస్ ఉట్” కరి. ఇనేతి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","తెదేస్ యోఛొగిరి ఉట్టీన్ ఛాలనిక్లి, “యోభ్హార వరక్హ్ ని థీ.” తెదేస్ ఇవ్నే ధేఖిన్ గ్హణు అష్యం హూయ్గు. ");
INSERT INTO vgr_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","ఆహుయూతె హాఃరు కినాబి నొకొబోలొకరి గుర్కైన్ ఆజ్ఞదీన్‍ బోల్యొ. “యో ఛొగిరినా ష్యాత్‍బి ఖఢావో కరి బోల్యొ.” ");
INSERT INTO vgr_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","యేసు యోజొగొన బెందీన్ మొదుల్ను దేహ్క్ ఆవమా, ఇనా సిష్యుల్ ఇనకేడె గయా. ");
INSERT INTO vgr_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","ఆరామ్‍ను ధన్ ఆయుతేదె యో న్యావ్‍కరను జొగొమా బోధించొ. ఘను అద్మిహాఃరు ఇనివాతె హఃమ్జీన్ అష్యంహుయు, “ఆ సంగతిహాఃరు అన కెజ్గాతు ఆయూ? అన దీరాక్యుతె అక్కల్ కెజాత్నూ? అనహాత్ అత్రె అద్భుతాల్‍ కరూకరస్? ఆసాత్?” ");
INSERT INTO vgr_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","ఆ మరియనో ఛియ్యో కాహేనా? అనె యాకోబ్‍నా, యోషేపు, యూదా, బుజు సీమోన్‍కరి భైయ్యాహుయాతె కుంభార్‍ కాహేసు? ఇను “భేనె హాఃరి అప్నెతి మలీన్ ర్హయూతె కాహేసు?” కరి బోల్తొహుయిన్ ఇన విషయంబన్తి ఘేళికర్యూ. ");
INSERT INTO vgr_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","ఇనటేకె యేసు ఇవ్నేతి బొల్యొ, “కెహూ ప్రవక్తబీ ఇను దేహ్ఃమహొ, ఇనా బంధువుల్‍మహో, ఇనా ఘేర్‍మా తప్ప బుజు కెజ్గబి ఇజ్జత్ కొయినితిమ్ కోరాయినీ” కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","అనటేకె థోడు అద్మి రొగాఢిన ఉఫర్‍హాత్ మ్హేలీన్ ఇవ్నా అష్యల్ కరను తప్ప, బుజు కెహూబి అద్భుతాల్‍నా యో ఇజ్గ కోకరని, యో ఇవ్నా అవిష్వాసంనా దేఖిన్ అష్యంహుయుగు. ");
INSERT INTO vgr_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","ఇనబాద్‍మా ఆష్పీస్ ఛాతె గాంమ్మా, దేవ్నువాతె బోల్తొ ర్హయ్యో. ");
INSERT INTO vgr_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","ఇను భారజణ సిష్యుల్నా ఖందేబులాయిన్, ఇవ్నా బేజణా కరీన్ బోలిమోక్లిదేతూ, ఛంద్‍ఫర్ ఇవ్నా అధికార్‍ దీన్; ");
INSERT INTO vgr_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","ఇవ్నా అమ్ బోల్యొ, “జావని వహఃత్ హాత్నిలాక్డి తప్ప కెహూబి నొకొలీన్ జాస్యు, ధాన్‍హో, రోటనహో, పైసాని సంఛిహొ, సంఛిహో నొకొలీన్‍జాసు.” ");
INSERT INTO vgr_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","బద్లావనా అజేక్ కుడ్తాబి, నాలీన్‍జైన్ చెప్పల్ ఫేర్లిజవోకరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","“బుజు యో ఇవ్నేతి బోల్యొ, తుమె ఏక్న ఘర్‍కన గయాతో ఎజ్గతూ నికీన్ జావతోడి, యోఘర్‍మస్ ర్హహొ. ");
INSERT INTO vgr_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","ఏక్ గామ్‍వాలు తుమ్న నాచేర్చాయుతో, న్హైతొ తుమారు వాతేవ్నా నాహఃమ్జితొ, తుమె యోగామ్ మ్హేందీన్ జావనా అగాఢి ఇవ్నఫర్ సాబుత్‍నితరా రవ్వానటేకె గోఢను లాగిర్యూతె ధుళ్‍నా జట్కినాకొ.” ");
INSERT INTO vgr_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","పన్కి ఇవ్నే నిఖిన్‍ అద్మియేనా ప్రక్చాతాపంనాటేకె దిల్ బద్లాయి లేనుకరి బోల్యా. ");
INSERT INTO vgr_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","కెత్రూకి భూత్‍నా హకల్తొహుయీన్‍, గ్హణు రొగాఢిబర్యూ అద్మియేనా తేల్‍ లగాఢీన్‍ అష్యల్ కరుకరా. ");
INSERT INTO vgr_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","యేసును నామ్ బ్హఢను హుయుథూ, అనటేకె హేరోద్‍ రాజొనా ఆవాతేహాఃరు మాలంపడ్యు, బాప్తిస్మమ్‍ దెవ్వాలొ యోహాన్ మరణ్‍మతూ ఉట్యోస్‍. ఇనటేకె ఇనకన అద్భుతాల్‍ను కువ్వాత్ ఇవ్నమా ఛాకరి థోడుజను బోల్యా. ");
INSERT INTO vgr_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","అలాదుజణు “యో ఏలియా” కరి బుజు, “యో ప్రవక్త కరి, అగాఢిను జమానమా ప్రవక్తమా ఆ ఏక్జనో” కరి అజు థోడుజను బోల్యు. ");
INSERT INTO vgr_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","పన్కి హేరోద్‍ హఃమ్జీన్, “మే ముడ్క్యూ కత్రాయోతె యోహాన్; ఇనే మరణ్‍మతూ జివీన్‍ ఉట్యోస్‍” కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","ఇనటేకె హేరోదియనా బందీచ్‍కరీ ఆజ్ఞాదేవమా, యోహాన్నా బంధించీ ఠాణమా గలైయిదిదూ, హేరోద్‍ అమ్ కర్యొ సానకతొ యో ఇనా భైయ్‍హూయోతే ఫిలీప్పుని బావన్ హేరోదియనా య్హా కర్లిదొ. ");
INSERT INTO vgr_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","యోహాన్ హేరోద్‍తి, “తారి భైని బావన్నా రాఖిలేవనూ న్యాయం కాహెకరి” బోల్తొ ర్హాతొ థొ. ");
INSERT INTO vgr_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","ఇనటేకె హేరోదియానె యోహాన్‍నా వ్యతిరేకంగా మారైనాక్నుకరి దేఖి పన్కి, బాయ్కోనుహాత్ కోహుయుని, హేరోదియనాటేకె యోహాన్నా ఠాణమా గల్దేస్. ");
INSERT INTO vgr_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","యోహాన్ నీతిమంతుడ్‍బి బుజు, పరిసుద్ధుడ్‍ భ్హరాయిరోతె అద్మికరి హేరోద్‍నా మాలం, ఇనటేకె ఇనేతి ఢరీన్ బచ్చావ్‍తో ర్హాతొ థొ. హేరోద్ యోహాన్ని వాతె హఃమ్జోతెదె గ్హణు సోఛ్చానిక్యొ, ర్హైయ్‍తొబీ ఇనివాతే హఃమ్జానటేకె అష్యల్ లాగ్తుథూ. ");
INSERT INTO vgr_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","తెదె ఏక్‍ ధన్నె హేరోద్‍ను ఫైధాహుయోతె ధన్ ఆవమా, ప్రముక్య ప్రధానుల్‍నా, సైనాధిపతుల్నా, గలిలయమనూ ప్రముక్యుల్నా ఖాణు ఖడావనా బులాయో. తెదె హేరోదీయనా మోకా మళాస్. ");
INSERT INTO vgr_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","తెదె హేరోద్‍కనా ఆయూతే ఇవ్నా దిల్ భైలావనాటేకె హేరోదియని ఛోరి ఆయిన్ ఖేలీన్‍, హేరోద్‍ బుజు ఇనకేడె అయుతె హాఃరవ్‍నా ఖుషీకరి. అనటేకె హేరోద్రాజొ ఇనేతి బోల్యొ, “తునసాత్ హోనుకి మాంగిలా! మే దీస్” కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","కెత్రూకిచోట్ “తూ సాత్‍ మాంగితోబి దీస్, మారు రాజ్యంమతి ఆదుభాగ్‍దా! కతోబి దీస్” కరి వాత్ దిదొ. ");
INSERT INTO vgr_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","యో ఇని ఆయాకన జైయిన్ “మే సాత్ మాంగ్నుకరీ పుఛ్చావమా ఇనే బోలి, బాప్తిస్మమ్‍ దేవ్వాళొ యోహాన్ను ముడ్క్యూ” మాంగ్‍జో కరి బోలీ. ");
INSERT INTO vgr_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","తెదేస్ యో రాజొకన మిలావ్‍తిహుయిన్ ఆయిన్, “బాప్తిస్మమ్‍ దెవ్వాళొ యోహాన్ను ముడుక్యునా ఏక్ థాలిమ మ్హేలిన్ హాంకేస్ లాయిదెవో” కరి బోలి. ");
INSERT INTO vgr_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","తెదె రాజొనా గ్హనూ బాధపడ్యొ, పన్కి యో వాత్‍దేవమా ఇనటేకె యోరాజొ ఇనా కొయినికరి బోలన కోహుయూని. ");
INSERT INTO vgr_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","తెదేస్ రాజొ యోహాన్నూ ముడ్యానా లీన్ ఆవొకరీ సైనికుల్నా బోలిమొక్లొ, సైనికుల్ ఠాణమా జైన్ ఇను ముడ్క్యానా కత్రినాఖీన్‍, ");
INSERT INTO vgr_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","యో ముడుక్యునా ఏక్ థాలిమ మ్హేలీన్ ఆయిన్, ఇన బహుమతినితరా దిదొ. యోచొగ్రి జైన్ ఇని ఆయాన దిదీ. ");
INSERT INTO vgr_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","తెదె యోహాన్నూ సిష్యుల్ ఆవాత్ హఃమ్జీన్ ఇజ్గా జైన్ యోహాన్నూ ముర్దునా సమాధికర్యు. ");
INSERT INTO vgr_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","అపొస్తుల్ యేసున ఆష్పీస్‍ భ్హరాయిన్ ఇవ్నే కర్యుతే కామ్నుహాఃరు బోధించతె సువార్తన హాఃరుబి ఇనేతి బొల్యా. ");
INSERT INTO vgr_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","ఇవ్నకన గణుఅద్మి ఆవ్తూ, జాతుర్హావమా ఇవ్నా ఖాణు ఖవానబి సమయంబి కోమల్యుని, ఇనటేకె యేసు ఇవ్నేతి బొల్యొ, “మారకెడె ఆవో కోణ్ కొయింతెజొగొ జైయిన్ థోడు ఆరామ్ కర్‍లేవొ” కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","ఇనటేకె ఇవ్నే ఏక్ డోంగాచఢీన్ కోణ్ కోయింతె జాఢినుజొగె గయ్యా. ");
INSERT INTO vgr_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","పన్కి, యేసు ఇన సిష్యుల్ జావను గ్హణు అద్మిహాఃరు దేక్యు, యో కోన్కి ఇవ్నే మాలంకరీలీన్, హాఃరు హఃయర్‍తి చాల్తూహుయీన్‍ జైయిన్, ఇవ్నేతిబి అగాఢి యోజొగమా ఆయూ. ");
INSERT INTO vgr_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","యేసు డొంగా ఉత్రీన్ యోమోటూ జనభోన దేక్యొ, ఇవ్నె కాపరికొయింతే మ్హేండనితర రవ్వామా, ఇవ్నఫర్‍ గోర్‍హుయీన్‍, ఇవ్నా కెత్రూకి సంగతుల్‍నా బోధించను సురుకర్యొ. ");
INSERT INTO vgr_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","గ్హణు ధన్‍డుబమా ఇనా పా‍సల్ ఇను సిష్యుల్ ఇనకన ఆయిన్, ఆ జాఢినుజొగొ “హంకెతొడి గ్హణు ధన్ డుబీగయూ; ");
INSERT INTO vgr_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","తెదె అష్పీస్ ఛాతే క్హయర్‍మహొ, గామ్‍మాహో, ఇవ్నే జైయిన్, ధాన్‍నాటేకె సాత్‍బి మోల్‍ల్యావనా ఇవ్నా బోలి మోక్లిదాకరి బోల్యా.” ");
INSERT INTO vgr_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","ఇనటేకె యేసు, తుమె ఇవ్నా ధాన్ నాఖొకరీ బోలమ, ఇవ్నే బొల్యా, హామే జైయిన్ “బేఖ్హో దేనారంనా రొట్టామోల్లీన్ ఇవ్నా భాగ్ పాఢీన్ బేంద్‍చున్నా?” కరి ఇనేతి పుఛ్చావమా. ");
INSERT INTO vgr_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","అనటేకె యేసు “తుమారకనా కెత్రా రోటఛ్చా? జైయిన్ దేహొఃకరీ ఇవ్నేతి బోల్యొ.” ఇవ్నే జైయిన్ దేఖిన్ ఆయిన్, “ఫాచ్ రొట్టా, బే మాస్లా ఛాకరి బోల్యా.” ");
INSERT INTO vgr_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","తెదె యేసు బోల్యొ, హాఃరవ్నా న్హాను గాహ్క్ ను బల్డమా వరసమా బేహాఃడొ, కరి సిష్యుల్‍తి ఆజ్ఞదీన్ బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","ఇవ్నె ఖొః అద్మియేనూ పాంబల్‍, అడైహ్ అద్మి పాంబల్‍నితరా బేసిగు. ");
INSERT INTO vgr_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","తెదె యేసు, “పాచ్ రొట్టాన, బే మస్లాన పల్లీన్, ఆకాష్‍మ్హణీ దేఖిన్ ఆసీర్వాదించీన్‍, యోరొట్టాన తోఢిన్‍ ఇవ్నా నాఖానటేకె ఇన సిష్యుల్‍నా దేవమా” యో బే మాస్లన హాఃరవ్‍నా నాఖిదీదు. ");
INSERT INTO vgr_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","ఇవ్నే థక్ తోఢిన్ ఖైయిన్ హుయిజావదీన్, ");
INSERT INTO vgr_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","పాస్సల్‍తి మిగ్లిగుతే మాస్లాహొ రోట్టాన టుక్డాహో భార టోక్రా భరీన్ పాడ్యు. ");
INSERT INTO vgr_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","యో రోట్టాబి మాస్లా ఖాద్యుతె ఇవ్నె నకోతోబి పాచ్‍హజార్‍ మరద్మాన. ");
INSERT INTO vgr_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","ఎగ్గీస్ యోఅద్మియేనా బోలిమోక్లిదేవమస్‍, ఇన సిష్యుల్తి తుమె మారేతి అగాఢి డొంగాచఢీన్ ధర్యావ్నా పార్లిబాజు ఛాతె బేత్సయిదాన జవొకరీ బోలిమోక్లిదీన్, ");
INSERT INTO vgr_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","ఇనా పాసల్‍తి యో ప్రార్థనా కరనటేకె ఫహాడ్‍కన గయో. ");
INSERT INTO vgr_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","ధన్‍ డుభ్యుతెదె ఇన సిష్యుల్ ఢోంగమా జౌంగ్రథాతె ఇవ్నే దర్యావ్ను ఇఛ్మా థా. యేసు కనారినవుఫ్పర్‍ ఎకేళొ థొ. ");
INSERT INTO vgr_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","తెదె ఇవ్నా వ్యారొ హాఃమెతూ ఆవమా, ఢోంగ ఛలావనా ఇవ్నా గ్హణు మ్హినత్‍లాగమా ఇనె దేఖిన్‍, తెదె వ్హాణే హఃత్రేహుంకరతో ఛార్‍బజానా యో ధర్యావ్‍న ఉఫ్పర్‍కరీ చాల్తొహుయీన్ ఇవ్నాకన ఆయిన్‍, ఇవ్నా దాటీన్ ఛల్ జానూకరి ల్హైయిగో. ");
INSERT INTO vgr_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","యో ధర్యావ్‍నావుప్ఫర్ ఛాలను ఇవ్నే దేఖిన్, “భూత్‍ కరి ల్హైజైయిన్” ఛిక్రాన్ మ్హేల్యు. ");
INSERT INTO vgr_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","హాఃరుజణు ఇన దేఖిన్ తోందరాపడమా, ఎగ్గీస్‍ యేసు ఇవ్నేతి అమ్ బొల్యొ, “ఢరొనొకొ హిమ్మత్‍ లాయిలేవొ మేస్” కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","ఫాసల్‍తి యో ఢోంగఫర్ బేసిన్ ఇవ్నకన గయ్యోతెదె, వ్యాయిరో రుకీగు, ఇనటేకె సిష్యుల్ గ్హణు అష్యంహుయిగు. ");
INSERT INTO vgr_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","హుయితోబి ఇవ్నా యోరోట్టాన పంచ్యుతే అధ్బుతంనా బారెమా కోమాలంకర్యుని. ");
INSERT INTO vgr_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","ఇవ్నె పార్లిబాజు జైయిన్‍ గెన్నెసరేతును కందె ఆయిన్‍ ఢోంగనా ఎజ్గ ఉభ్ర్యూ. ");
INSERT INTO vgr_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","ఇవ్నె డోంగ ఉత్రూస్‍కరా, జనాభోఇన గుర్తు ధరీన్‍; ");
INSERT INTO vgr_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","యో హఃయర్ అస్పీష్‍ను అద్మి మిలావుతూహుయిన్ జైయిన్, యోఛ్చాకరి హఃమ్జుతె జొగొకనా రొగాఢి బర్యావ్‍నా మంఛ్చోఫర్ ఢొహిలీన్ పల్లీన్‍ ఆవనా సురుకర్యూ. ");
INSERT INTO vgr_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","గామ్‍మహో, నంగర్‍మహో, గామ్డామహో యో కెజ్గ జాస్కి ఇజ్గను అద్మిహాఃరు బజార్‍మా రొగ్హాఢి భర్యావ్‍న గల్లియమా మ్హేలిన్, ఇవ్నా తారు లుంగ్డాను కనారిన చేడొస్ ఛీమదాకరి ఇన బాతిమల్లిదా, ఇన ఛిమ్యోతె హాఃరుజణు అష్యల్ హుయిగు. ");
INSERT INTO vgr_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","యెరూషలేమ్‍తూ ఆయుతే పరిసయ్యుల్‍బి షాస్ర్తుల్‍మా థోడుజణు మలీన్‍ ఇనకనా ఆవమా; ");
INSERT INTO vgr_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","యేసునా సిష్యుల్‍మా థోడుజణు గలీజ్‍ హాతేతి, కతొ ధొయ్యాకొయింతే హాతెతీ ధాన్ ఖావాను ఇవ్నె దేక్యా. ");
INSERT INTO vgr_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","పరిసయ్యుల్‍హో యూదల్‍ హాఃరుజణు జమానాను ఆచారంతీ హాత్ దొయ్యితోస్‍ పన్కీ ధాన్ కోఖాయిని, ");
INSERT INTO vgr_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","బుజు ఇవ్నే బజార్‍తి ఆయుతో పాని దొవ్వాను కోయింతిమ్‍ ధాన్ కోఖాయిని, ఆబీ కాహేతిమ్ ఇవ్నే కెత్రూకి ఆచరంనా పట్టీంచవాలు గిన్నినాహో, కేళినాహో, పిథల్‍న రాచ్చవ్‍నహో, పానిమా ద్హోవనుబి తోడుబోత్‍ కెత్రూకి ఆచారాల్‍నా ఇవ్నేచాల్‍తుథూ. ");
INSERT INTO vgr_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","తెదె పరిసయ్యుల్‍బి షాస్ర్తుల్‍నె బోల్యా, “తార సిష్యుల్ ష్యానా మోటావ్ని ఆచరంతి కోచాలంతే, గలీజ్ హాతేతి ధాన్ ఖంక్రస్‍కరి ఇన పుఛ్చాయో.” ");
INSERT INTO vgr_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","అనటేకె యేసు ఇవ్నేతి అమ్ బోల్యొ ఆ అద్మిహాఃరు ఇవ్న “హోటేవ్‍తి చోర్‍భక్తి మన ఘనపరచస్” పన్కి ఇవ్ను దిల్ మరేతి గ్హణు దూర్‍ ఛా. ");
INSERT INTO vgr_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","ఇవ్నె అద్మియే కర్యూతె పద్దతినా దేవ్ను పద్దతికరి బోధకర్తూ, ఇనటేకె మన పాల్తుతీ ఆరాధించుకరి లిఖైర్యూతిమ్ చోర్‍దాంఢహుయతె తుమార బారెమా యెషయా ప్రవచించొతె హాఃఛీస్. ");
INSERT INTO vgr_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","“తుమె దేవ్‍ను ఆజ్ఞాన మ్హేందీన్, అద్మియేను ఆచారంన పాటించుకరస్.” ");
INSERT INTO vgr_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","బుజు యేసు అమ్ బోల్యొ, “తుమె దేవ్‍ను ఆజ్ఞహాఃరు బెందీన్ తూమారు సొంతంను ఆచార్‍నా పట్టించునుకరి దేకుకరస్. ");
INSERT INTO vgr_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","‘తార ఆయ, భాన తూ ఘనపరుచునుకరి, భానహో ఆయనహో షబర్‍దెవ్వాలాన మర్రణ్‍ను సిక్చ నాక్నూకరి’ మోషే బొల్యొ కాహేనా. ");
INSERT INTO vgr_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","హుయితోబి తుమారమా ఏక్జను ఇన భానహో ఆయానహో దేఖీన్, మారేతి తున ఫాయిదొహువతెయో కెహూకియో యోకొర్బాను కతో దేవ్ను అర్పించనుకరి బోల్యుతెదె, ");
INSERT INTO vgr_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","ఇన భానహో, ఆయానహొ, ఇనా సాత్‍బి నాకరదేనూతిమ్, ");
INSERT INTO vgr_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","తుమె బనాయూతే తుమారు పారంపర్యాచారంటేకె, దేవ్ను వాక్యమ్‍నా పాల్తు కరూకరస్. అజాత్నూ కెత్రూకి తుమె కర్‍స్యూకరీ బోల్యొ.” ");
INSERT INTO vgr_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","తెదె యేసు అద్మియేను మోటుగల్లొనా బుజు ఇనకనా బులాయిన్, “తుమెహాఃరు మార వాత్‍నా హంమ్జీన్ కరో. ");
INSERT INTO vgr_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","బ్హాధర్‍తీనిఖీన్‍ మ్హహీ జైతే క్హయూబి అద్మినా అపవిత్రంతీ కరతె కయ్యూబి కోయిని, ");
INSERT INTO vgr_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","పన్కీ మ్హయితి బ్హార్‍ ఆవాతేస్‍ అద్మినా అపవిత్రంతీ కరస్‍కరీ బోల్యొ.” ");
INSERT INTO vgr_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","యేసు అద్మియేను మోటోగల్లొ మ్హేందీన్ గ్హేర్‍మా ఆయోతెదె, ఇను సిష్యల్‍ ఆ ఉపమానంనా గూర్చి ఇన పుఛ్చావమా, ");
INSERT INTO vgr_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","యో ఇవ్నేతీ అమ్ బొల్యొ, “తుమె అత్రె అక్కల్‍కోయినితిమ్ ఛాసు? బ్హాధర్‍తి నిఖీన్‍ అద్మినా మ్హాయి గయూతె కెహూబి ఇన అపవిత్ర్ కోకర్‍సేనికరి తుమె మాలంకోకర్యనీసూ?” ");
INSERT INTO vgr_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","ఇనటేకె “యో ఇనా దిల్మా జాయ్‍కొయినితిమ్ పేట్‍మస్ జైన్ ఎజ్గతు బ్హాధర్ ఆవస్; అంనితర యో ధాన్‍ఖావను రాఛహాఃరు గంధ కరనూస్.” ");
INSERT INTO vgr_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","బుజు అమ్ బోల్యొ, “అద్మినా మ్హైతూ నిఖీన్ బ్హాధర్ ఆవాతెహాఃరు అద్మినా అపవిత్ర్ కరూకరస్‍. ");
INSERT INTO vgr_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","మ్హైతూ కతొ, అద్మియేను దిల్‍మతూ కర్రాబ్ సోచనూబి, చోర్నుకామ్, ");
INSERT INTO vgr_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","అద్మియేనా మర్రాక్ దేవనూ, వ్యభిఛార్, హఃమ్జతె యేక్నా మోసంకరను, కుట్ర, నిందానాఖను, చ్హాడికొయింతె వాత్ మళైన్ బోలను, కర్రాబ్‍ డోళా, హంఖార్, అక్కల్‍కొయింతె ఆవస్‍. ");
INSERT INTO vgr_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","ఆ హాఃరు అద్మినా దిల్మ‍తూ బ్హాధర్ ఆయిన్ అద్మినా అపవిత్రా కరూకరస్‍ కరి యో బోల్యొ.” ");
INSERT INTO vgr_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","యేసు ఎజ్గతూ నిఖీన్ తూరు సిదోను కరి ఇలాహోఃమా జైయిన్‍, ఏక్ ఘర్‍మా గయో, ఆవాత్ కినాబి నామాలంపన్నూ కరి ల్హైయిగో, పన్కి యో కినాబి మాలం నాపన్నూ తిమ్ ర్హవనా కోహూయుని. ");
INSERT INTO vgr_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","ఛంద్‍ ధరాక్యుతె ఏక్ న్హానిఛొగ్రిని ఆయా, యో ఇను గూర్చి హఃమ్జీన్, తెదేస్ ఆయిన్ ఇన గోఢనావుఫర్ పడిగి. ");
INSERT INTO vgr_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","అన్యుల్ని ఏక్ బాయికొ సురోఫేనికయనూ జాత్మ ఫైదాహుయితే గ్రీసు దేహ్ఃవాళి యోబాయికోనా చొగ్రీమతూ భూత్‍నా బ్హాదర్ నహాఃడ్‍కరీ ఇనేతి బతిమాల్‍ది. ");
INSERT INTO vgr_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","యేసు ఇనేతి బోల్యొ, ఇనామ్హణె దేఖిన్ “అగఢి లఢ్కా పేట్ భరీన్ ఖానూ; లఢ్కానూ రోట్టనాలీన్ కుత్ర్యాను చెల్కానా నాఖను అష్యల్ కాహె.” ");
INSERT INTO vgr_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","ఇనటేకె యో ఇనేతి, హాఃఛీస్ ప్రభూ “కుత్రాన చేల్కబి ధాన్ ఖావనా బల్లనా హేట్ బేసీన్, లడ్కా ఖాతివొహోఃత్ నాఖతె రోట్టనా కుత్ర్యా పాఢీన్ ఖాస్ని” కరి ఇనేతి బోలి. ");
INSERT INTO vgr_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","ఇనటేకె యో ఇనేతి బోల్యొ, “తూ తార ఘర్‍కనా జా! భూత్‍ తారి ఛోరిమతూ మ్హెందీన్ ఛలీగు.” ");
INSERT INTO vgr_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","యోబాయికో ఘేర్‍కనా ఆయిన్, ఇని ఛోరీన భూత్‍ మ్హేందీన్ జావను బుజు మంచఫర్ ఖూత్తిర్హావను దేకి. ");
INSERT INTO vgr_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","యేసు బుజు తూరుదేహ్‍ఃనా మ్హేందీన్ సీదోనుతూ దెకపొలి ఇలాహొఃనా ఉప్పర్‍తూ గలిలయనూ దర్యావ్‍కనా ఆయా. ");
INSERT INTO vgr_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","తెదె ఇజ్గాను థోడుజణు భైరుబి నత్తితీ హుయ్రూతె ఏక్జణనా లీన్ ఆయిన్, ఇన ఉప్పర్ హాత్ మ్హేల్‍కరి ఇన బతిమాల్లిదు. ");
INSERT INTO vgr_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","తెదె యో జణభోను గళ్లొమతూ ఇనా కోన్‍కొయింతె జొగొమా బులాలిజైయిన్, ఇన కాణ్‍మా అంగ్లి గ్హాలీన్ థూకిన్, ఇన జీబ్‍నా ఛీమ్యో. ");
INSERT INTO vgr_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","ఆకాష్‍ మ్హణీ డోలొపాఢీన్ దేఖిన్ ఎఫ్పతా కరి ఇనేతి బోల్యొ, ఎఫ్పతా కతో ఆవాత్‍ను అర్థం కొలైజాకరీ. ");
INSERT INTO vgr_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","తెదె ఇన కాన్ ఖుల్లాయ్‍గయూ, ఇను జీబ్ను న్హార్‍ హలీన్‍ ఇనే అష్యల్తి వాతె బోలాలగ్యూ. ");
INSERT INTO vgr_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","తెదె యో, ఆవాత్ కినేతీబి నొకొబోలిస్ కరి ఇనేతి బోల్యొ. హుయితోబి అజు ఘను ప్రచార్ కర్యొ. ");
INSERT INTO vgr_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","ఆ సమస్తంనా అష్యల్ కర్రాక్యోస్ బైర్యూ అద్మియేన హఃమ్జ హాఃర్కూ, ముక్కుఅద్మి వాత్‍బోలహఃర్కు కరూకరస్‍‍‍ కరి బొల్లేతూహుయిన్, అష్యమ్ హుయు. ");
INSERT INTO vgr_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","యోధన్‍మా బుజేక్‍చోట్ గ్హను అద్మియే ఇక్కట్‍హువమా, ఇవ్నా ఖావనాటేకె కాయిబి నార్హావమా, యేసు ఇను సిష్యుల్‍న ఖందె బులాయిన్. ");
INSERT INTO vgr_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“అద్మిహాఃరు హంకెతోడి తీన్‍ధన్‍తూ మారకనా ఛా; ఇవ్నా ఖావనటేకె సాత్బి నార్హావమా మే ఇవ్నఫర్‍ గోర్‍ పడుకరూస్. ");
INSERT INTO vgr_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","మే ఇవ్నా ఘర్‍కనా భుక్కేస్ బోలిమోక్లి దిదోతొ ఇవ్నా వాట్‍ఫర్‍ షుస్తూహుయీన్ పడిజాసె ఇవ్నమా థోడుజణు దూర్‍తి ఆయుకరి ఇవ్నేతి బోల్యొ.” ");
INSERT INTO vgr_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","ఇనటేకె ఇన సిష్యుల్ బోల్యా, “ఆ జాఢిమా కాయ్‍బీ మలకొయింతే జొగోమా జైయిన్ కెజ్గాతు రోట్టాలాయిన్, అవ్నా పేట్‍బ్హరి ఖడావ్సేకరి ఇన పుఛ్చాయో.” ");
INSERT INTO vgr_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","తెదె యేసు పుఛ్చాయో, “తుమారకనా కెత్రరోట్ట ఛాకరీ పుఛ్చావమ ఇవ్నె హాఃత్ రోట్టా” కరి బోల్యా. ");
INSERT INTO vgr_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","తెదెయో బుజు, అద్మియేన జమీన్‍ఫర్ బెహాఃడ్కరి ఆజ్ఞదీన్‍, యోహాఃత్ రోట్టన పల్లీన్ కృతజ్ఞతాస్తుతుల్‍ కరీన్ ఇనా తోడీన్ సెర్దీన్‍నాఖనటేకె ఇన సిష్యుల్‍నా దిదొ, ఇవ్నె అద్మియేనా వడ్డించా. ");
INSERT INTO vgr_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","థోడు న్హాన మస్లబీ ఇవ్నకన ర్హావమా యో ఆసీర్వాదించీన్‍ ఇనబీ నాహోఃకరి సిష్యుల్నా బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","అద్మియేహాఃరు పేట్ బరీన్ ధాన్ ఖయీన్ హుయిజావదీన్ మిగ్లిగూతె రోట్వాను టుక్డవ్‍నా ఇనా సిష్యుల్ హాఃత్ గంపబరీన్‍ పాడ్యు. ");
INSERT INTO vgr_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","ధాన్ ఖాద్యుతె ఇవ్నె బరాబ్బర్‍ చార్ హజార్ అద్మి. తెదె యేసు అద్మియేనా బోలిమోక్లిదేవదీన్; ");
INSERT INTO vgr_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","తెదేస్ యేసు ఇన సిష్యుల్‍తి మలీన్ ఢోంగఫర్ ఛడీన్ దల్మనూతాకరి ఇలాహొఃమా ఆయో. ");
INSERT INTO vgr_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","యత్రమా పరిసయ్యుల్ ఆయిన్ యేసుతి పరీక్చకర్నూకరీ, ఉద్యేష్యంతి ఆకాష్‍మతూ ఏక్ అధ్బుతంన వతాల్‍కరి పుఛ్చాయు. ");
INSERT INTO vgr_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","యో ఇనా ఆత్మమా దిల్నా హల్కు కర్లీన్, ఆ పిఢిను అద్మియే అద్భుతంనా ష్యాన మాంగుకరుస్? మే ఖఛ్చితనంతీ బోలుకరూస్ ఆపిఢిను అద్మియేనా కెహూబి అధ్బుతం కోదెవ్వావ్‍రూనికరి ఖఛ్చితనంతీ తుమారేతి బోలుకరూస్‍ బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","తెదె ఇవ్నా మ్హెందీన్ బుజు ఢోంచడీన్ హీంకల్‍ని బాజు గయో. ");
INSERT INTO vgr_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","సిష్యుల్ ఖావనటేకె రోట్టలావను భులిగు; ఢోంగమా ఇవ్నాకన ఏక్ రోటొ తప్ప బుజు కాయిబి కోథూని. ");
INSERT INTO vgr_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","యో బోల్యొ, “దేఖిలెవొ పరిసయ్యుల్‍ను ఖాటు ఆటో బుజు హేరోద్‍ను ఖాటు ఆటోనా లీన్, జత్తన్‍తి ర్హవోకరి” ఇవ్నేతి గుర్‍కాయిన్‍ బోలమా; ");
INSERT INTO vgr_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","ఇవ్నె అప్నకన ఖావనా “రోట్ట కొయినికరి ఇవ్నమా ఇవ్నేస్ సోచిలిదు.” ");
INSERT INTO vgr_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","యేసు యోమాలంకర్లీన్, ఇవ్నా పుఛ్చాయో, అప్నకన రోట్ట కొయినికరి తుమె షాన సోచుకరస్ “తుమె వుజున్‍బి మాలంకొయిన్నా?” అర్థం కోహూయునిసూ? అత్రె ఖంజోర్‍నా? తుమె కఠీన్ దిల్‍వాలహుయీన్‍ ఛాసు? ");
INSERT INTO vgr_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","తుమ్న డోళర్హయిన్‍బి దేఖకొయిన్నా? ఖాన్ ర్హహీన్‍బి హఃమ్జకొయిన్నా? తుమె హఃయల్ కొకర్లేన్నా? ");
INSERT INTO vgr_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","“మే యో ఫాచ్ హజార్ అద్మినా, ఫాచ్ రోట్ట తోఢీన్ బాగ్‍పాడీన్‍ దిదొ తెదె తుమె మిగ్లుతె టుక్డా కెత్రు టోక్రా పాడ్యుకరి పుఛ్చాయో, ఇవ్నే భ్హారకరి ఇనేతి బోల్యా.” ");
INSERT INTO vgr_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","బుజు “మే ఛార్ హజార్ అద్మియేన హాఃత్ రోట్టనా తోఢీన్‍ దిదో తెదె తుమె కెత్రూ టోక్రా టుక్డవ్నా పడ్యుకటి బోలమా ఇవ్నె హాఃత్‍కరి బోల్యా.” ");
INSERT INTO vgr_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","అనటేకె యో “తుమె అజూన్‍బి మాలంకోకర్యనిసూ” కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","యేసు ఇనా సిష్యుల్తి బేత్సయిదామ ఆయా, తెదె ఇజ్గణుహాఃరు ఏక్ కాణు అద్మినా బులాలి ఆయిన్, ఇన ఛీమ్నుకరి ఇవ్నే ఇన బతిమాల్లిదా. ");
INSERT INTO vgr_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","యేసు యోకాణు అద్మినా హాత్‍ధరీన్ గామ్‍ను బ్హాదర్ లీన్‍జైన్ ఇన డోళఫర్ థూకీన్, హాత్ మ్హేలిన్ “తున సాత్‍బి దెహాఃమ్‍కరస్‍న్నా” కరి ఇన పుఛ్చాయో. ");
INSERT INTO vgr_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","“యో డోళొపాఢిన్ అద్మిహాఃరు మన దెహాఃమ్‍కరస్; పన్కి ఇవ్నె జాఢనిఘోని చాలంతరస్‍ మన దేహాఃమ్‍క్రస్” కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","అజు యోబుజేక్ చోట్ ఇను ఢోళఫర్ హాత్ మ్హేందీన్ ఛీమమా, తెదె ఇనా ఢోళనూ నజార్ ఆయిన్ సమస్తంను అష్యల్‍తి దెఖ్కాయు. ");
INSERT INTO vgr_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","తెదె యేసు ఇనేతి, “తూ గామ్మా నొకొజైస్‍తిమ్, ఘేర్ కనా జాకరి బోలిమోక్లిదిదొ.” ");
INSERT INTO vgr_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","యేసు ఇన సిష్యల్‍తి ఫిలిప్పుహుయూతె కైసరియమా కరి గామ్మా జావనిక్యా. మారగ్నాఫర్ ఛాల్తీవోఖ్హత్ యో ఇనా సిష్యుల్తి, “జనాల్‍హాఃరు మే కోన్‍కరీ అద్మిహాఃరు బోలుకరస్” కరి ఇన సిష్యల్‍తి పుఛ్చాయో. ");
INSERT INTO vgr_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","అనటేకె ఇవ్నె బోల్యా, “థోడుజణూ బాప్తిస్మమ్‍ దెవ్వాళొ యోహాన్ కరి, థోడుజణూ ఏలియాకరి, బుజు థోడుజణు ప్రవక్తమ ఏక్ కరి” బోల్లెంక్రస్. ");
INSERT INTO vgr_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","ఇనటేకె యో ఇవ్నేతి, తుమెహూయ్తొ “మే కోన్‍కరి బొల్లేంక్రస్‍కరి పుఛ్చావమా. పేతుర్ బోల్యొ, తూ క్రీస్తుకరి” ఇనేతి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","తెదె యో, “ఆవాత్ కినేతీబి నొకొబోల్చుకరి ఇవ్నా ఢరాయిన్ ఆజ్ఞ బోల్యొ.” ");
INSERT INTO vgr_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","బుజు “అద్మినొఛియ్యో కెత్రూకి మిన్హత్‍ పొందీన్‍ మోటవ్నాహాతె, ప్రధాన యాజకుడ్‍నాహాతె, షాస్ర్తుల్‍హాతె ధక్లై జైయిన్‍ మరీజైన్ తీన్మను ధన్నే పాసల్‍తీ జివీన్ ఉట్సె” ఇనె ఇవ్నా బోధించను సురుకర్యొ. ");
INSERT INTO vgr_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","యో ఇవ్నేతి ఆవాతెహాఃరు ఖుల్లకరీన్ బోల్యొ. పేతుర్ యేసునా హాత్‍ధర్లీన్‍ ఇనా గుర్‍కైన్‍ బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","అనటేకె యో పీటెఫరీన్ ఇన సిష్యుల్న భనె దేఖిన్, పేతుర్నా గుర్‍కైన్‍ ఓ సైతాన్! మార పీటె జా! తూ అద్మియేను రీతిగా సోచుకరస్ పన్కి “దేవ్ని రీతిగా కోసోచుకరరి కరి పేతురునా గుర్కాయు.” ");
INSERT INTO vgr_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","అజు యేసు ఇన సిష్యుల్నా అద్మిహాఃరవ్నా ఖందె బులాయిన్, “మారకేడె ఆవవాలూ ఇనుయోస్ పరీక్చించిలీన్ ఇను సిలువనా పల్లీన్ మారకేడె ఆవ్నూ. ");
INSERT INTO vgr_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","ఇను జాన్నా బఛ్చాయ్‍లేనుకరి దేఖవాళు ఇన జాన్నా గమాయ్ లలిషె; పన్కి మారటేకె సువార్తనటేకె ఇను జాన్న మ్హేందవాలూ ఇనా బఛ్చాయ్ లీషె. ");
INSERT INTO vgr_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","ఏక్జనొ ములక్‍హాఃరు కమాయ్‍లీన్‍ ఇనుజాన్నా మ్హేంది దిదూతో ఇన ఫైదొషాత్? ");
INSERT INTO vgr_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","అద్మి ఇను జాన్నా బఛ్చాయ్ లేవనా హాఃజే సాత్ దిసే? ");
INSERT INTO vgr_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","కోన్బి, వ్యభిచార్ పాప్‍కర్యూతె ఆపిఢినూ అవ్నమా మన బారెమా మారివాత్‍ బోలనటేకె కోణ్ సెరామ్ ఖాస్కీ, ఇన బారెమా‍ అద్మినఛియ్యో ఇనొ భా మహిమమా హుయోతెదె పరిసుద్ధుడ్‍ను దేవ్ను దూతల్‍కేడె ఆయోతెదె సెరామ్ కాషెకరి బోల్యొ.” ");
INSERT INTO vgr_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","యేసు ఇవ్నేతి బోల్యొ, “ఖఛ్చితనంతి తుమారేతి బోలుకరూస్. అజ్గ ఉబ్రీన్‍ఛాతె థోడుజణూ దేవ్‍ని రాజ్యంనా థాఖత్‍తీ ఆవ్సెతె దేఖతోడి మర్సెకొయిని.” ");
INSERT INTO vgr_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","ఛొ రోజ్ పాసల్, యేసు పేతుర్‍నా, యాకోబ్‍నా, బుజు యోహాన్నాకేడె లీజైన్, ఏక్ వూచు పహాఢ్‍ఫర్ కోన్‍కొయింతె జొగొమా ఎకేలనా బులాలిజైయిన్‍, ఇవ్నహాఃమె ఇను రూపంనా బద్లాయ్‍లిదొ. ");
INSERT INTO vgr_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","ఎత్రస్‍మా ఇను లుంగ్డా చంఖీన్ ధోళు హుయ్గు, ధర్తిమా కెహూ ధోబిబీ ఎత్రే ధోళుహుయూతిమ్ ధోవ్సెకొయిని. ");
INSERT INTO vgr_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","బుజు మోషే, ఏలియాబి, యేసుతి వాతెబోలుకరతొ ఇను సిష్యుల్ దేక్యా. ");
INSERT INTO vgr_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","ఇనటేకె పేతుర్ యేసుతి బోల్యొ, “బోధకుడ్! అప్నె అజ్గరవ్వాను అచ్చు; హమే తున ఏక్, మోషెనా ఏక్, ఏలియానా ఏక్, తీన్ మందిరాల్నా బ్హాందియేస్‍కరి బోల్యు. ");
INSERT INTO vgr_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","యో సాత్ బోలుకరస్కి ఇనాస్ మానెలంకొయిని, షానకతొ ఇవ్ గ్హణు ఢరిగయా.” ");
INSERT INTO vgr_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","తెదె ఏక్ మబ్బు ఆయిన్ ఇవ్నఫర్ ఢపావమా “ఆ మారొ లాఢ్నొ ఛియ్యో అని వాతే హఃమ్జోకరి యోమబ్బుమతూ ఏక్ ఆవాజ్ ఆయూ.” ");
INSERT INTO vgr_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","ఎగ్గీస్ ఇవ్నె అష్పీస్ ఫరీన్ దేక్యుతెదె యేసు తప్ప బుజు కోన్బి ఇవ్నా దెఖ్కాయుకొయిని. ");
INSERT INTO vgr_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","ఇనబాద్మ ఇవ్నె యో ఫహాడ్ ఉత్రీన్ ఆవ్తివొహఃత్, యేసు ఇవ్న ఆజ్ఞదీన్, “అద్మినొఛియ్యో మరణ్‍మతూ జివీన్ ఉట్టతోడి, తుమె హంకె దేక్యతె సాత్‍బి కినాబి నొకొబోల్చు” కరి ఇవ్నేతి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","“మరణ్‍మతూ జివీన్ ఉట్టనుకతో సాత్” కరి ఇవ్నమా ఇవ్నేస్ బోల్తుహుయీన్, యోవాత్న దిల్మా రాఖిల్‍దూ. ");
INSERT INTO vgr_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","ఇవ్నె ఇనేతి బోల్యొ “ఏలియా అగాఢి ఆవ్నుకరి, షాస్ర్తుల్‍ ష్యాన బోలుకరస్?” ");
INSERT INTO vgr_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","ఇనటేకె ఇనె, “ఏలియా అగాఢి ఆయిన్ సమస్తంనా అచ్చు కర్సెతె వాత్ హాఃఛిస్; హుయుతోబి అద్మినొఛియ్యో కెత్రూకి ష్రమపడ్సేకరి లేఖనంమా షాన లిఖ్కైరూస్, ");
INSERT INTO vgr_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","ఏలియా ఆయోకరి ఇన బారెమా పరిసుధ్దవాక్యంమా లిఖ్కైయ్‍రూతె తిమ్, ఇవ్నె ఇష్టమ్ ఆవతిమ్ ఇనబారెమా కర్యుకరి తుమారేతి బోలుకరూస్‍కరి ఇవ్నెతి బోల్యొ.” ");
INSERT INTO vgr_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","ఇవ్నె ఇన సీష్యుల్‍కనా ఆయిన్, ఇవ్నకనా గ్హనూ జణమ్ భరైన్ ర్హావను బుజు షాస్ర్తుల్‍ ఇవ్న వాత్‍నా వాత్ పరావనూ ఇవ్నే దేక్యా. ");
INSERT INTO vgr_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","ఎగ్గీస్ అద్మినుగళ్లొ హాఃరూ యేసున దేఖిన్, అష్యంహుయీన్, ఇనకన మిలావ్తూ ఆయిన్ హఃలామ్ కర్యు. ");
INSERT INTO vgr_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","తెదె యో ఇన సిష్యుల్తి “తుమె కినబారెమా ఇవ్నేతి వాదించుకరస్” కరి ఇవ్న పుఛ్చావమా! ");
INSERT INTO vgr_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","అద్మినా గళ్లొమా యేక్జనో “బోధకుడ్, మే మార ఛియ్యాన లీన్ ఆయో, ముక్కొ భూత్‍ ధర్యాక్యుతె మార ఛియ్యాన తారకన లీన్ ఆయో” ");
INSERT INTO vgr_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","యో ఇన కెజ్గ ధరస్కి యెజ్గా పడ్జాస్; తెదె యో మ్హోడమతీ బుర్గు మ్హేలిన్, దాత్‍ ఛాయిన్‍, అజు అక్డాయిన్ పడ్జాస్, యో భూత్‍నా హఖల్కరి తార సిష్యుల్‍నా బోల్యొ, పన్కి ఇవ్నా హాత్ కోహుయునికరి ఇనేతి బోల్యు. ");
INSERT INTO vgr_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","ఇనటేకె యో, “విష్వాస్‍కరకొయింతె ఆ ఫీడిను అద్మియే, మే కెత్రధన్ తుమారకేడె ర్హైస్? కెత్రలగూ మే తుమ్నా హఃమాలీస్? యోఛొగ్రనా మారకనలీన్ ఆవొకరి ఇవ్నేతి బోల్యొ.” ");
INSERT INTO vgr_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","ఇవ్నె యో ఛొగ్రనా ఇనకన లీన్ ఆయు, యో భూత్‍ ఇన దేక్తస్ యో చొగ్రనా థర్పాడాయు, ఇనహాఃజె యో ఖేథర్‍ఫర్‍ పడీన్ బురుగు మ్హేల్తూహుయిన్ పొల్లాడుకర్తు థూ. ");
INSERT INTO vgr_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","తెదె యేసు యో చొగ్రాను భాన అమ్‍హుయిన్ కెత్రధన్ హుంకరస్‍కరి పుఛ్చావమా, యో “అఢ్డానిఫర్‍తూస్‍కరి బోల్యొ.” ");
INSERT INTO vgr_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","యో “భూత్‍ ఇనా మర్రాక్నుకరి, కెత్రూకిచోట్ పానిమా, ఆగ్మా నాకిదిదూ. తార హాత్ హూయితో తూ హమారఫర్ దయకరీన్ నయం కర్కరి, యో బోల్యు.” ");
INSERT INTO vgr_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","ఇనటేకె యేసు! ఇనేతి బోల్యొ, “ఒహో! నమ్మాను తారహాత్‍ హుయోతో, సమస్తమ్ సాధ్యమస్‍” కరి ఇనేతి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","ఎగ్గీస్ యోచొగరాను భా బోల్యొ, మే నమ్ము కరూస్. “మారమా అజు అవిష్వాస్‍ నాహోణుతిమ్ సహాయమ్ కర్కరీ” బాధతి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","యేసు అద్మినపాంబల్ మిలాతూహుయిన్ ఇన ఖందె ఆవను యేసు దేఖిన్‍ “ముక్కొ భూత్‍ ఇనా బెందీన్‍ చలోజా! బుజు కెదేబి ఇనకన నొకొపేహీఃస్‍కరి ఆజ్ఞాపించుక రూస్‍కరి” బోలిన్‍ ముక్కొ ఛంద్‍నా గుర్కైనా బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","తెదె యో ఛంద్‍ ఛిక్రాన్ బేంతూ ఇన కెత్రూకి తర్ఫడైన్ ఇనా బెందీన్ చలీగయూ. “యో మర్జావనితరా ర్హావమా” ఘను అద్మి మరిగయోకరీ ల్హైయిగు. ");
INSERT INTO vgr_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","పన్కి, యేసు ఇనహాత్ ధరిన్ ఉట్టాడమా యో ఉట్టీన్ ఉబ్ర్యూ. ");
INSERT INTO vgr_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","యో ఘర్‍మా జావదీన్, ఇను సిష్యుల్ హమే షానటేకె “భూత్‍నా హాకల్యాకొయింతె షే?” కరి కోణ్ కొయిననితె ఇనా పుఛ్చాయా. ");
INSERT INTO vgr_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","తెదె “యో బోల్యొ ప్రార్థనా తీస్” పన్కి, బుజు కినేతిబి అజాత్ను “భూత్‍నా హక్లనా కోహుయినికరి బోల్యొ.” ");
INSERT INTO vgr_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","యేసు ఇన సిష్యుల్ ఎజ్గతూ నిఖీన్ గలిలయమా ఇచ్మతూ జంకరమా! అ కినాబి మాలంహువనూ ఇన ఇష్టంకొయిని, ");
INSERT INTO vgr_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","కిమ్ కతొ యో ఇన సిష్యుల్నా అమ్ బోధించ్యొ, “అద్మినొఛియ్యో అద్మియోనా హాత్మా ధరై జాస్యేకరి, ఇవ్నె ఇనా మర్రాక్‍స్యే, మరిజైన్ తీన్మనూ ధన్నె పాస్సల్ యో ఉట్సేకరి” ఇవ్నేతి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","యేసు బోల్యొతె వాతె ఇవ్నా అర్థం కోపడ్యుని యోవాత్నా పుఛ్చావనాటేకె ఇవ్నే ఢరూకర్తు థూ. ");
INSERT INTO vgr_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","యేసు ఇనా సిష్యుల్ కాపేర్నహుమ ఛాతె నంగర్మా ఆయ్యా, యో, “కోణ్ గ్హణు మోటోకరి మారగ్‍ఫర్ ఏక్నుయేక్ బోల్లిదు.” ");
INSERT INTO vgr_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","షానకతో యో ఘేర్మా గయ్యో తెదె, మారగ్‍ఫర్ తుమె కోన్ మోటు కరి, వాధించుకర్తూ థూ తూకరి పుఛ్చావమా ఇవ్నె సోపొ థూ. ");
INSERT INTO vgr_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","తెదె యో బేసిన్, భారజన సిష్యుల్నా బులాయిన్, కోణ్ మోటొ ర్హాణూకరీ సోచస్కి ఇవ్నే హాఃరవ్‍తీ తగ్గించిలీన్, హాఃరవ్తీ తగ్గీన్ తగ్యైలీన్ హాఃరవ్నా సేవకర వాలంతరా ర్హానుకరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","తెదె ఏక్ న్హాన లడ్కనా పల్లిన్ ఇవ్న ఇచ్మా ఉబ్బార కాఢీన్ ఇన పల్లిన్ ధప్పాయ్ లీన్, ");
INSERT INTO vgr_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","అమ్‍ “కోన్బి ఆ అడ్డాణి లడ్కావ్‍నా కోణ్ కందెకరస్‍కి ఇవ్నె మన కందెకర్సే, బుజూ కోణ్ మన కందెకరస్కి మనస్ కాహేతిమ్ మన బోలిమోక్లొతె ఇనాబి కందెకర్సేకరి బోల్యొ.” ");
INSERT INTO vgr_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","ఎత్రస్మా యోహాన్ యేసున బోల్యొ, “బోధకుడ్ ఏక్జనూ తార నామ్మా భూత్‍నా నహాఃడను దేక్యొ, యో అప్నమ ఏక్ కాహె అనటేకె ఇన ఆటంకం కర్యా” కరి బోల్యా. ");
INSERT INTO vgr_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","ఇనటేకె యేసు అమ్ బోల్యొ, “ఇవ్న ఆటంకం నకొపర్చొ; మార నామ్తి అద్భుతాల్‍ కరీన్ మన వ్యతిరేకంగా కోన్బికొయిని.” ");
INSERT INTO vgr_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","మారేక్హు వైరీకొయినితిమ్ రవ్వాలో యో మారొబాజు రవ్వాలోస్. ");
INSERT INTO vgr_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","మే ఖఛ్చితనంతీ బోలుకరూస్, కోన్బి క్రీస్తును నామ్తి తుమ్న పియ్యాన గీలాహ్క్ పాని దేస్కి, యో ప్రతిఫల్ ఇనా మల్‍స్యేకరి బోలుకరూస్. ");
INSERT INTO vgr_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“మారఫర్‍ విష్వాస్‍ రాఖవాలు ఆ అఢ్యాణి లఢ్కమా ఏక్నా కోణ్ అడ్డుర్హాస్కి, యో ఇన గుధ్దినా ఘట్టినూ బండో బాందిలీన్ ధర్యావ్‍మా నఖైజావను ఇనా కెత్రూకి మేల్.” ");
INSERT INTO vgr_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","తారహాత్ తునా పాపంనా కరావనా గయుతో యో హాత్నా కత్రినాక్‍ ");
INSERT INTO vgr_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","తూ బే హాత్ ర్హహీన్ నరకంమా ఉజ్జావకొయింతె ఆగ్మా పఢనూబదుల్, ఏక్ హాత్తి నిత్యజీవంమా జావను మేల్. ");
INSERT INTO vgr_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","తారొగోడొ తునా పాపంనా కరావనా గయూతో, తూ ఇనా కత్రినాక్‍ ");
INSERT INTO vgr_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","భే గోడర్హహీన్ నరకంమా జావనూ బదుల్, ఏక్ గోడొనూ లంగ్డో ర్హహీన్ నిత్యజీవంమా జావను మేల్. ");
INSERT INTO vgr_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","తారు డోళొ తునా పాపంనా కరావనా గయూతొ, ఇనవుక్డీన్ పేకిదా; భే ఢోళా ర్హహీన్ నరకంమా పఢనూబదుల్, ఏక్ డోళొర్హహీన్, దేవ్ని రాజ్యంమా జావను అష్యల్. ");
INSERT INTO vgr_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","నరకంమా పఢ్యుతె ఇవ్నా భాళుకరతే ఆగ్ ఉజావ్సెకొయిని, ఖంగ్రతే కీడు మర్సెకొయిని. ");
INSERT INTO vgr_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“మీట్‍ బలినా కిమ్ పరీక్చించస్‍కీ, ఆగ్‍బి ఇమ్మస్ హర్యేక్ జణనా పరీక్చింఛే.” ");
INSERT INTO vgr_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“మీట్ అష్యలస్, పన్కి ఇన్మఛాతె ఖారు నార్హహీతో యో ఖారు పాచు కినేతి ఆవ్సె? ఇనటేకె తుమె ఏక్నా యేక్తి మీట్నజోడనా సమాధానంతీ రహోకరీ బోల్యొ.” ");
INSERT INTO vgr_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","యేసు ఎజ్గతూ ఉట్టిన్‍ యో ఇలాహొఃనా మ్హెంధీన్ యూదయ ఇలాహొఃమా, యోర్దాను నదినా దాటిన్ ఆయో. ఇనకనా అద్మియోనుగళ్లొ అజు భరైగు, ఇనుకంతూ ఆవమా ఇవ్నా బోల్తొర్హయోతిమ్ అజు బోలను సురుకర్యొ. ");
INSERT INTO vgr_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","థోడుజణు పరిసయ్యుల్ ఇనకన ఆయిన్, ఇన హఃతావనటేకె అమ్ బోల్యా, “ఏక్ మరద్మానొ ఇని బావన్న మ్హేంన్‍దేవనూ ధర్మషాస్ర్తమ్‍తీ న్యాయమస్‍నా?” కరి ఇన పుఛ్చాయా. ");
INSERT INTO vgr_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","ఇనటేకె యో, “మోషే తుమ్న ఇను ఆజ్ఞదేవమా ష్యాత్ బోల్యుకరి పుఛ్చావమా.” ");
INSERT INTO vgr_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","ఇవ్నె బోల్యా, “తలాక్ను కాగత్‍ లిఖ్కాయిన్ దీన్ యోబాయికోన బోలిమోక్లిదాకరి మోషే బోల్యొకరి బోలమా.” ");
INSERT INTO vgr_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","యేసు ఇవ్నేతి బోల్యొ, “తుమారు దిల్ను కట్టినంనాబట్టీన్‍ మోషే ఆజ్ఞనా తుమ్నా లిఖీన్ దిదూ. ");
INSERT INTO vgr_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","పన్కి దేవ్ ములక్నూ సృష్టినా బనావనా అగాఢి ఏక్ మరద్మానో రాంఢ్నా బానాయో. ");
INSERT INTO vgr_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","ఇనటేకె మరద్మానొ ఇన ఆయా భాన మ్హేందీన్ ఇని బావన్నా ఖందెకర్సె. ");
INSERT INTO vgr_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","ఇవ్నె భేజణ ఏక్ ఆంగ్‍హుయిన్ ర్హాసె, ఇనటేకె ఇవ్నె బుజు కెదేబి బే జణాంతర నారైన్ ఏక్ ఆంగ్‍ హూయిన్ ర్హాసె. ");
INSERT INTO vgr_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","ఇనటేకె దేవ్ జోడ్‍కర్యొతె ఇవ్నా అద్మియే కోన్‍బి అలాదు నాకర్నుకరి ఇవ్నెతి బోల్యొ.” ");
INSERT INTO vgr_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","ఘేర్‍కన ఆయుతెదె యోవాత్‍న బారెమా ఇనా సిష్యుల్ యేసునా అజేక్ చోట్ పుచ్ఛాయ. ");
INSERT INTO vgr_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","ఇనటేకె యోబోల్యొ, “ఇని బావణ్‍న మ్హెందీన్, అజేక్ జణిన య్హాకరి లెవ్వాలొ, యో మ్హెందిదొతే యోబాయికోన బారెమా వ్యభిచార్ కరవాలొంతరాహుసెసే. ");
INSERT INTO vgr_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","అజు బాయికొ ఇను బావ్రిన మ్హెందీన్ అజేక్‍న య్హా కర్లిదీతొ, యో వ్యభిఛార్ కరకరావాలింతర హుసేకరి ఇవ్నెతి బోల్యొ.” ");
INSERT INTO vgr_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","థోడుజణు ఇవ్నా లఢ్కావ్‍నఫర్ హాత్ మ్హెంద్‍‍కరి యేసుకనాలీన్ ఆయూ; పన్కి ఇను సిష్యుల్ ఇవ్న గుర్‍కైన్‍. ");
INSERT INTO vgr_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","యో ఇవ్నా దేఖిన్ ఛండాల్‍హుయీన్ అమ్ బోల్యొ, “అఢ్యాణి లడ్కవ్‍నా మారకన ఆవధా, ఇవ్నా ఉబ్రకాడొనొకొ, దేవ్ను రాజ్యం అమ్‍జోక్” అనటేకెస్. ");
INSERT INTO vgr_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","మే ఖఛ్చితనంతీ బోలుకరూస్‍, “అఢ్యాణి లఢ్కవ్‍ని దిల్నితరా దేవ్వు రాజ్యంన కోణ్ కోవొప్పానికి ఇన్మా కోజాసేని” ");
INSERT INTO vgr_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","యో లాఢ్కా‍వ్‍నా పల్లీన్ దఫాయిలీన్ ఇవ్నా ఉప్పర్ హాత్ మ్హేలిన్ ఆషీర్వాద్‍ దిదో. ");
INSERT INTO vgr_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","యేసు ఎజ్గతూ నిఖీన్ మారగ్‍ఫర్ జాతుర్హావమా ఏక్జను మిలవ్తూహుయిన్ ఆయిన్‍ ఇనహాఃమె డుక్నెమేట్‍ నాఖీన్, “అష్యల్ బోధకుడ్ మే నిత్యంజీవంమా జాణుకతొ మే సాత్ కర్నుకరి” ఇన పుఛ్చాయో. ");
INSERT INTO vgr_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","ఇనటేకె యేసు, “మన అష్యల్ అద్మికరి కిమ్ బోలు కరస్?” “దేవ్ ఎక్కస్‍ జణోస్‍ పన్కి అజు కోన్బి అచ్చుహుయోహో కొయిని.” ");
INSERT INTO vgr_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","తున ఆజ్ఞ మాలంకొయిన్నా? మర్రాఖనూ నాకర్నూ, వ్యభిచార్‍ నాకర్నూ, ఛోర్ కామ్ నాకర్నూ, “జూటి సాక్చ్యామ్ నాబోల్ను, అలాదవ్నా మోసం నాకర్నూ, తారా ఆయ భాన ఇమాన్ కర్నూ” కరి ఇనేతి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","ఇనటేకె యో, “బోధకుడ్ ఆ హాఃరు మే అఢ్యాణి ఫర్తూస్ ఆహాఃరు కరుకరూస్ని” కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","యేసు ఇనా దేఖిన్ ఫ్యార్‍ కరీన్, అజుబీ తున ఏక్ జరూర్ ఛా, “తూ జైన్ తారకన ఛాతె హాఃరూ యేఛిన్‍ గరీబ్‍నా ధా. పరలోకంమా తున దవ్లత్‍ మల్సె; తూ ఆయిన్‍ మారకేడె ఆవ్కరి బోల్యొ.” ");
INSERT INTO vgr_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","యో ఘనూ ఆస్తీవాలు అనటేకె యో వాత్నా హఃమ్జీన్ మ్హోడు ముర్‍జైలీన్ దుఃఖ్‍ పడ్తోహుయీన్ ఛలేగొ. ");
INSERT INTO vgr_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","తెదె యేసు ఆష్పీస్ దేఖిన్, “దవ్లత్‍వాలు దేవ్‍నూ రాజ్యంమా జానుకతో ఘనూ కష్టంకరి బోల్యొ.” ");
INSERT INTO vgr_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","ఇని వాతేవ్‍న హఃమ్జీన్ ఇన సిష్యుల్ హష్యంహుయీన్, ఇనటేకె యేసు ఇవ్నేతి అమ్ బోల్యొ, “లఢ్కవ్‍నా ఇనా దవ్లత్ ఫర్ భరోసా కరవాళు దేవ్‍నూ రాజ్యంమా జావను ఘణు కష్టం. ");
INSERT INTO vgr_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","దవ్లత్‍వాలు దేవునిరాజ్యంమా జావను బదుల్‍ ఏక్ ఊట్ హుఃయినూ చిళ్లమా పేహఃను హల్కుకరి బోల్యొ.” ");
INSERT INTO vgr_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","యోవాత్ హఃమ్జుతె ఇను సిష్యుల్ ఘనూ హాష్యంహుయీన్, ఇమ్ హుస్యేతొ “బుజు కోణ్ రక్చింఛాబడ్‍స్యే” కరి పుఛ్చావమా. ");
INSERT INTO vgr_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","యేసు ఇవ్నా దేఖిన్ బోల్యొ, “ఆ అద్మియేనా అసాధ్యం పన్కి, దేవ్‍న సమస్తమ్‍బి సాధ్యమస్” బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","తెదె పేతుర్నే, “హాదేక్ మే సమస్తమ్‍బి హాఃరు మ్హెందీన్ తారకేడెస్ ఆయోకరి ఇనేతి బోల్యొ.” ");
INSERT INTO vgr_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","అనటేకె యేసు ఖఛ్చితనంతి బోల్యొ, “మార నిమిత్తం సువార్తన హాఃజె ఘర్‍నతోబి, భైయ్యేనా ‍భేనెనా, ఆయా భానబీ, లాడ్కానబీ, జామీన్ నాబీ, బెందెవ్వాలు, యో ");
INSERT INTO vgr_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","హాంకె నా పొందతోబి, ఆవ్సెతె హింసల్‍మతూ ఘర్‍న, భై భయ్యావ్‍నా, భేనె భేనెనా, ఆయా, భానా లడ్కావ్నా, జమీన్నా, ఆవ్‍స్యేతె ములక్‍మా నిత్యంను జీవం మళ్‍స్యేకరి తుమారేతి మే ఖచ్చితంగా బోలుకరూస్. ");
INSERT INTO vgr_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","బుజు అగాఢి ర్హావాలు పీటెజాసే, పీటే ర్హావాళు అగాఢిహుసే కరి బోల్యొ.” ");
INSERT INTO vgr_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","యేసు ఇను సిష్యుల్ బయలుదేరిన్ యెరూషలేమ్మా జంకరా యేసు ఇవ్నేతి అగాఢి జాతొ ర్హావమా ఇవ్నే అష్యంహుయు, ఇనకేడె జంకరతెహాఃరు ఢరీగయు, తెదె యో బుజు భారజణ సిష్యుల్‍నా బులాయిలీన్, ఇన జరగజాసెతె ఇవ్నా బోలాలగ్యొ. ");
INSERT INTO vgr_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","హదేక్ “అప్నె యేరుషలేమ్‍మా జంకరియేస్ అద్మినొఛియ్యో ప్రధాన యాజకుడ్‍న బుజు షాస్ర్తుల్‍న హాత్మ దెవాయిజాసె ఇవ్నె ఇనా మర్రాఖిదేవాను షిక్చదీన్‍ ఇనా అన్యజనాభోనా హాత్మా దేవాయిజాసె. ");
INSERT INTO vgr_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","ఇవ్నె ఇనా ఇజ్జత్ కాఢీన్ ఇనప్పర్ థూఖిన్, కమ్మియేను కోల్డతి మారీన్ మర్రాఖిదిసె తీన్ ధన్ హువదీన్ అజు జీవిన్ వుట్సే” కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","జెబెదయినొ ఛియ్యో హుయోతె యాకోబ్‍ బుజు యోహాన్ ఇనా ఖందెఆయిన్, “బోధకుడ్! హమె తారకన సాత్ మాంగ్యతోబి హమ్నకర్?” కరి బోలమా. ");
INSERT INTO vgr_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","“మే తుమ్న సాత్ కర్నూకరి కోరుకరాస్‍?” కరి పుఛ్చావమా. ");
INSERT INTO vgr_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","ఇవ్నె జవాబ్‍ బోల్యా, “తూ మహిమమా రవ్వాని వొహొఃత్ ఖవ్వాహాత్ మ్హణీ ఏక్జణనా, తార ఢవ్వాహాత్ మ్హణి ఏక్జణనా బేసీన్ ర్హావహఃర్కూ హామ్న దయాకర్” కరి ఇన బోల్యా. ");
INSERT INTO vgr_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","యేసు, “తుమె సాత్ మాంగుకరస్‍కీ తుమ్న మాలంకొయిని మే పీదొతె గిన్నిమనూ తుమె పీస్యునా, మేలీదొతె బాప్తిస్మమ్‍ లేవనూ తుమ్న హాత్ హుసెసూ?” కరి ఇవ్నేతి పుఛ్చావమా. ");
INSERT INTO vgr_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","ఇవ్నె హామరా హాత్ హుస్యేకరి బోలమా, తెదె యేసు బోల్యొ, “మే పీవుంకరుతే గిన్నిమా తుమేబీ పీస్యూ, మే లిదోతె బాప్తిస్మమ్‍ తుమేబీ లీసు.” పన్కి, ");
INSERT INTO vgr_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","మార ఖావ్వాహాత్ని బాజు, ఢవ్వాత్ను బాజు, బెహాఃడిదేవానూ మారహాత్మా కొయిని, పన్కి దేవ్ కినా దెవ్వానుఛాకి ఇవ్నస్ దెవ్వావ్ స్యే ఇవ్నేతి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","మిగ్లితె ధహ్క్ జణా సిష్యుల్ ఆవాత్‍ హఃమ్జీన్, యాకోబ్‍, బుజూ యోహాన్‍నా ఉఫ్పర్ చంఢాల్‍పడలగ్యూ. ");
INSERT INTO vgr_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","యేసు ఇవ్న ఖందె బులాయిన్, ఇవ్నేతి అమ్ బోల్యొ, అన్యజనాభోమా అధికార్‍వాలకరి యెంచుహుయూతె ఇవ్నా, ఇవ్నఫర్ హఃర్కార్‍ కర్సె ఇవ్నమా మోటా ఇవ్నఫర్ అధికార్ చలావ్సెకరి తుమ్న మాలంహుసె. ");
INSERT INTO vgr_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","తుమారమా ఇమ్ నార్హాను, తుమారమా కోన్బి మోటోహుయీన్ ర్హానుకతో యో తుమార హేట్ సేవకర వాలంతరా హుయీన్‍ ర్హాను. ");
INSERT INTO vgr_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","బుజు తూమరమా కోణ్ అగాఢి హుయిన్ ర్హానుకరి దేఖస్‍కీ యో హాఃరవ్నా దాసుడ్‍ హుయీన్ ర్హాను. ");
INSERT INTO vgr_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","అద్మినఛియ్యో, “సేవా కర్యాయ్‍ లేవనటేకె కోఆయోని, పన్కి హాఃరవ్‍నా సేవ కరనాటేకె, బుజు హాఃరవ్నా చొఢావ్నటేకె ఇను జాన్నా దెవ్వానటేకె ఆయోకరి” బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","ఇవ్నె యెరికో నంగర్‍మా ఆయు. యో ఇన సిష్యుల్‍తీబి మోట్టూ గుంబాల్‍తీబి మలీన్ యెరికోతీ నిఖీన్ ఆవుంకరమా, తీమయినో ఛియ్యోహుయోతె బర్తిమయికరీ కాణు మాంగిఖావాలు మారగ్నసేడె బేసీన్ థూ. ");
INSERT INTO vgr_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","ఆ “నజరేత్నో యేసుకరి హాఃమ్జీన్, తెదె యో దావీద్నొనొ ఛియ్యో యేసు, మారఫర్ గోర్ కర్కరి ఛిక్రాణ్ మ్హేలనూ సురుకర్యూ.” ");
INSERT INTO vgr_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","షోపొర్హాకరి కెత్రూకి జణు ఇనా గుర్కాయు, పన్కి యో “ఓ దావీద్‍నో ఛియ్యో మన గోర్ కర్కరి” అజు జాహఃత్ ఛక్రాణ్ మ్హేల్యూ. ");
INSERT INTO vgr_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","తెదె యేసు ఉబ్రీన్, “ఇన బులావో” కరి బోలమా యోకాణు అద్మినా ఇనకనా లాయిన్ “ఢర్‍నొకొ తిమ్ ఉట్టిన్ ఉభర్, తున యో బులాంక్రస్.” ");
INSERT INTO vgr_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","యోకాణొ ఓడ్రాక్యొతె లుంగ్డనా ఖనాకీన్, ఎగ్గీస్ ఉట్టీన్ యేసునా కందేగయో. ");
INSERT INTO vgr_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","యేసునె మే తునసాత్ కర్నూ? కరి పుఛ్ఛావమా, “యో ఖాణొ డోలవాలు బోధకుడ్ మనదేఖనా ఢోళనూ నజార్ దాకరి బోల్యొ.” ");
INSERT INTO vgr_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","ఇనటేకె యేసు ఇనేతి “తూ జా తారువిస్వాస్ తునా అష్యల్ కర్యూ” కరి బోల్యొ. తెదేస్ ఇన ఢోళనూ నజార్ ఆవమా యో యేసునకేడె గయో. ");
INSERT INTO vgr_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","యేసు ఇనా సిష్యుల్తి మలీన్ యెరూషలేమ్నూ నంగర్‍న హాఃమె ఒలీవాను ఫహాడ్‍నా కందెఛ్చాతె బేత్పగే, బుజూ బేతనియకరి, గామ్నా ఆయుతెదె, యేసు ఇను సిష్యుల్‍మా “బే జణనా బులాయిన్‍ అమ్‍ బోల్యొ” ");
INSERT INTO vgr_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","తురామ “హాఃమెఛాతె, గామ్మాజవొ; ఇన్మా జంకరస్‍కరా ఎగ్గీస్ హాఃమే బాందిరాక్యుతె ఏక్ ఘదెడునూ చెల్కూ, దెఖావ్‍సే; ఇనఫర్ కెహూ అద్మిబి హాంకెతోడి కెదేబి బేసికోరాక్యుని.” ఇనచోఢిన్ హాకాలిలీన్ ఆవో. ");
INSERT INTO vgr_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","కోన్‍బి తుమె అన సానటేకె లీన్ జంకరస్కరి పుఛ్చాయుతో, హమార యజమానినా ఆ ఘదేడనూ చెల్కు హోనుకరి బోల్యొ, తెదేస్ యో అద్మి ఇనలీన్ జవొ బోల్చెకరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","ఇవ్నె జావమా ఇవ్న ఘర్న బ్హాదర్ బాంధిరాక్యుతె ఏక్ ఘదేఢను చెల్కు దెఖ్కాయు; ఇన ఛోడ్‍తూ ర్హావమా. ");
INSERT INTO vgr_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","ఎజ్గ ఉబ్రీన్ ఛాతె థోడుజణు, తుమె సాత్ కరుకరాస్? “ఘదేఢన చెల్కన సాన ఛోడుకరస్కరీ” ఇవ్నా పుఛ్చావమా. ");
INSERT INTO vgr_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","ఇనటేకె సిష్యుల్, యేసు ఆజ్ఞపించొతిమ్ ఇవ్నా బోలమా ఇవ్నె ఇనలీన్ జావదీదు. ");
INSERT INTO vgr_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","ఇవ్నె ఘదెఢన చెల్కాన బులాయ్‍లీన్ యేసుకన ఆయిన్, ఇవ్నా లుంగ్డా ఇన ఉప్పర్ నాహఃమా యో ఇనఉప్పర్ చఢీన్ బెట్టొ. ");
INSERT INTO vgr_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","కెత్రూకి జణు వాట్‍ఫర్ లుంగ్డా బిఛ్చాయు, తోడుజణు ఝాడిమా కత్రతె షింధోలినూ డాలియేనా మారగ్‍ఫర్ నాఖ్యు. ");
INSERT INTO vgr_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","బుజు యేసునా అగాఢి, పాస్సల్‍బి జంకరతె హాఃరు, దేవ్నా “హోసన్నా కరి, ప్రభున నామ్‍త్తి ఆవవాళొ స్తుతించబడి హువదా” ");
INSERT INTO vgr_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","ఆంకరతే అప్నొ భా హుయోతె “దావీద్‍నూ రాజ్యం ఆసీర్వాదించీన్‍ ధన్యహూసె. సర్యోన్నతనూ జొగొమా హోసన్నా కరి గట్ ఛిక్రాన్ మ్హేల్యు.” ");
INSERT INTO vgr_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","ఇనె యెరూషలేమ్ను మంధిర్‍మా జైన్ ఆస్పీస్ ఫరీన్, సమస్తంనా దేఖిన్‍, తేదెస్ హాఃజె హూవమా భ్హారజణ సిష్యుల్నాకేడె బేతనియమా గయో! ");
INSERT INTO vgr_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","బుజేక్ ధన్ ఇవ్నె బేతనియతూ జంకరమా “యేసున భుక్ లాగ్యు.” ");
INSERT INTO vgr_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","ఏక్ అంజురంను ఝాడనా దూర్ తీస్ దేఖిన్, యోఝాడన సాత్‍బి లగ్యుసూకీ కరి ఎజ్గ ఆయో, ఝాడకన ఆయిన్ ఢూండమా ఏక్ పండుబీ కోతూని పాళొతప్ప సాత్బి కోదెఖ్కాయుని; సానకతో ఝాడనపండా లగ్గనూధన్ కాహే. ");
INSERT INTO vgr_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","అనటెకె యేసు యో జాఢహూః, “హంకేతు బుజుకెదేబి తారపంఢా కోన్బి ఖాసెకొయినికరి” షపించొ తెదె బోలమా, యోవాతె ఇన సిష్యుల్‍ హఃమ్జు. ");
INSERT INTO vgr_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","ఇవ్నె యెరూషలేమ్మా ఆయొతెదె యేసు ఆలయంమా జైయిన్, ధందొకరూకరతె ఇవ్నా మొక్లినాఖను సురుకర్యొ. రఫ్యా బద్లాంకరతె ధందొను బల్లల్నా, పర్యావ్నా యేచుకరతె ధందోవాలనా బల్లాల్నా, పేకినాక్యొ. ");
INSERT INTO vgr_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","మందిర్‍మతూ కెహూ హాఃమన్నా బాధర్ కినాబి లావదిదోకొయిని. ");
INSERT INTO vgr_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","బుజు యో అమ్ బోధించొ, “మారు మంధీర్ ధర్తీఫర్‍ ఛాతె జాత్‍ అద్మిహాఃరవ్నా ప్రార్థనాకరనూ మంధీర్‍ బొలావ్సె” కరి లిఖ్కాయ్‍ రూస్ కొయిన్నా? బుజు తుమె ఇనా ఛోర్ ర్హావను గుహనితరా కర్యాక్యూస్ కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","ఎజ్గఛాతె ప్రధానయాజకుడ్‍ షాస్ర్తుల్‍, యో వాత్నా హఃమ్జీన్, అద్మిహాఃరూబి ఇను బోధన ఘనూ అష్యంహువనూ దేఖిన్‍ యో ఢరిగయూ, ఇనకింమ్ మార్నకరి బే జనా దేక్తా ర్హాతథా. ");
INSERT INTO vgr_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","ధన్‍ డుబాదీన్‍ ‍తెదె యో నంగర్‍మతూ బాదర్‍ చల్‍జంకరతొ థొ. ");
INSERT INTO vgr_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","వ్హానేస్ ఇవ్నె యోవాట్‍ఫర్ జంకరమా యో అంజురంనూ ఝాడనూ జఢ్తూ నికీక్‍ హుఃకాయిజావనూ దేక్యా! ");
INSERT INTO vgr_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","తెదె పేతుర్‍, యో బోల్యొతె వాతెన హాఃయల్ కరీన్ “బోధకుడ్! హదేక్ తూ షపించిదిదోతే అంజురంను ఝాడు హుఃకాయి గయూకరి ఇనేతి బోల్యొ.” ");
INSERT INTO vgr_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","ఇనటేకె “యేసునె ఇవ్నేతి అమ్ బోల్యొ! తుమె దేవ్నావుప్పర్ విస్వాస్‍ రాఖొ” ");
INSERT INTO vgr_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","కోన్బి ఆ పహాడ్నా దేఖిన్‍ తూ ఉట్టీయిన్ ధర్యావ్‍మా పడ్జాకరి బోలిన్‍, ఇను దిల్మా అవిష్వాస్ కొయినితిమ్ ఇనె బోల్యొతె హుసేకరి నమ్యుతొ యో ఇమ్మస్ హుసెకరి తుమారేతి ఖఛ్చితనంతి బోలుకరూస్‍. ");
INSERT INTO vgr_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","ఇనటేకె తుమె ప్రార్థనకరనూ వొహొఃత్ కెహూ మాంగ్యుతోబి యోతుమ్నా మల్‍స్యేకరి నమ్మో; తెదె యోతుమ్నా మల్సేకరి ఖఛ్చితంగా తుమారేతి బోలుకరూస్. ");
INSERT INTO vgr_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","తుమె కినఫర్బీ చంఢాల్తి ర్హయతొతెదె తుమె ఉబ్రీన్‍ ప్రార్థన కరనూవొహోఃత్ ఇన మాప్‍కరొ. ");
INSERT INTO vgr_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","తెదె “స్వర్గంమా ఛాతె తారొ భా తారు పాప్‍న క్చమాకర్సె.” ");
INSERT INTO vgr_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","యేసు ఇన సిష్యుల్‍తి యెరూషలేమ్ ఫరీన్ ఆయా. ఇవ్నె దేవ్ను మంధిర్‍మా ఫర్తొ ర్హావమా, ప్రధాన యాజకుడ్‍బి షాస్ర్తుల్‍బి, మోటా హాఃరుజణూ ఇనకనా ఆయిన్‍. ");
INSERT INTO vgr_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","తూ “కెహూ హక్కుతి ఆ కార్యాల్నా కరూకరస్? ఆహాఃరు కరనా అధికార్‍ తున కోన్‍దిదూ?” కరి పూఛ్చాయ్యా. ");
INSERT INTO vgr_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","ఇనటేకె యేసు “మేబి తుమ్నా ఏక్ ప్రస్నా పుఛ్చాంవుస్?” ఇన తుమె బోల్యాతో, తెదె కెహూ అధికార్‍తి మే కరూకరూస్కి యో తుమ్న బోలూస్. ");
INSERT INTO vgr_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","“యోహాన్ దిదోతె బాప్తిస్మమ్‍ పరలోకంతి ఆయూకి, న్హైతొ అద్మితి ఆయూ మారేతి బోలొ? కరి బోల్యొ.” ");
INSERT INTO vgr_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","అనటేకె ఇవ్నె, అప్నె స్వర్గంతూ ఆయుకరి బోల్యతొ ఇమ్ హుస్యేతో, ");
INSERT INTO vgr_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","తుమె సానటేకె నమ్యకొయినికరి పుఛ్చావ్సె “అద్మినటేకె హుయూకరి బోలియేనాకరి ఇవ్నామ ఇవ్నే సోచలగ్యు, పన్కి హాఃరుజణు యోహాన్ హాఃఛిస్ ప్రవక్తకరీ సోఛ్చె.” ");
INSERT INTO vgr_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","పన్కి అద్మినా ఢరీన్, యోవాత్ “హామ్న మాలంకొయినికరి” యేసుతి బోల్య. ఇనటేకె యేసు బోల్యొ, కెహూ అధికార్‍తీ ఆ హాఃరు కరుకరూస్కి, “మే బీ తుమారేతి కోబోలిస్‍ని” కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","తెదె యేసు ఇవ్నా ఉపమానం బోల్తొహుయీన్‍ అమ్ బోల్యొ; కిమ్కతొ “ఏక్ అద్మి అంగూర్ను బాగ్‍ నాఖిన్ ఇన ఆస్పీస్ భీత్ బాంద్యు, ద్రాక్చనపంఢనా ఖుంద్లావనాటేకె ఏక్ తోట్టి బణాయో, ఇజ్గాస్ ఏక్ పాకనా బంధాయో, ఇన పాసల్తూ యో ద్రాక్చను ఖేథర్‍మా థోడు అద్మిన పాల్నాదీన్ యాత్రఫరనా దేహ్ఃమా చలీగయో. ");
INSERT INTO vgr_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","ద్రాక్చనూ టోట్మా ఫండ తోడనూ ధన్ ఆవదీన్, యో మాలిక్‍ ఇను భాగ్‍ లావనటేకె ఏక్ దాసుడ్‍నా ఇవ్నకనా బోలిమొక్లొమా. ");
INSERT INTO vgr_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","పన్కి యోఖేథర్ వాలు ఇన ధరీన్ మారీన్ ఖాలిహాతెహూః బోలిమోక్లిదిదు. ");
INSERT INTO vgr_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","ఇన పాస్సల్‍తి యో బుజేక్ దాసుడ్‍నబి బోలిమోక్లొ, ఇవ్నె ఇనాబి ముడ్క్యాఫర్‍ మారిన్ ఇను ఇజ్జత్ కాడీన్ బోలిమొక్లమా. ");
INSERT INTO vgr_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","యో బుజేక్ దాసుడ్‍‍నా బోలిమొక్లమా, ఇవ్నే ఇనా మర్రాకిదిదూ, యో బుజు ఘను అద్మియేనా బోలిమొక్లమా, యో ఖేథర్‍వాలా థోడుజణనా మార్యు, థోడుజణనా మర్రాక్యు. ");
INSERT INTO vgr_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","మొక్లనటేకె ఇనా లాఢ్నొ ఛియ్యో తప్ప బుజు కోన్‍కొయిని, ఇన ఛియ్యాన ఇమాన్‍ దిసేకరి” సోఛిన్ ఇన బోలిమొక్లొ. ");
INSERT INTO vgr_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","పన్కి యో ఖేథర్‍వాలా బోల్య, ఆ భాగ్‍నూ వారసుడ్ ఆంక్రస్ ఇన ఏక్జణనా మర్రాఖిదియే ఆవొ, ఇమ్ కర్యతొ ఛాతెహాఃరు దవ్లత్‍ అప్ను హుసెకరి ఇవ్నె ఇవ్నేస్ బొల్లిదా. ");
INSERT INTO vgr_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","ఇనా ధరీన్ మర్రాఖిదీన్ ద్రాక్చనుభాగ్‍ బాధర్ షవంనా నాఖిదిదు. ");
INSERT INTO vgr_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","తెదె యోద్రాక్చా భాగ్‍ను “మాలిక్‍ సాత్ కర్సె? యో ఆయిన్ పాల్నాదిదొతె వాళనా మర్రాఖిదీన్ ఆలదనా కావ్లినా దిసె.” ");
INSERT INTO vgr_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","పవిత్ర్ గ్రంథం అమ్‍బోలి లిఖ్కాయ్‍రూస్, ఆ తుమె కోపడ్యానిసూ? ఘేర్ బాందవాలు కామ్ ఆవకొయినితిమ్‍ ధక్లై జాయితె ఫత్రొ ఘేర్ బాందను కోణనా ఘను ముఖ్యంనూ ఫత్రొహుసె. ");
INSERT INTO vgr_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","ఆ ప్రభు బారెమాస్‍ హుయు, అప్నె డోళబర్తి దేక్యా అప్న డోళనా ఘను అష్యమ్. ");
INSERT INTO vgr_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","ఆ ఉపమానల్ హాఃరు అప్నస్ బోలుకరస్కరి ప్రధానయాజకుడ్‍బీ షాస్ర్తుల్ మాలంకరీన్, ఇన ధరనాటేకె ఆహ్రేతి దేఖుకరమా, పన్కి అద్మియేను జనాభోనా దేఖిన్ ఢరిగయూ. ");
INSERT INTO vgr_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","ఇన పాసల్ యేసునా కెహూ వాత్మాబి ధర్నుకరి, పరిసయ్యల్, హేరోదీయుల్ థోడుజణనా ఇనకనా మొక్లూ. ");
INSERT INTO vgr_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","ఇవ్నె ఇనకనా ఆయిన్, “బోధకుడ్ తూ హాఃఛివాళొహుయోతె అద్మికరి, తూ కినాబి యెంఛకొయినికరి హమ్న మాలం; తూ షరమ్‍ కొయినితిమ్‍ దేవ్ని వాట్నా సత్యంతి బోధించవాలొ.” రోమాను హఃర్కార్‍ను కైసర్‍నా పన్నుబాందనూ న్యాయమస్‍నా కాహెనా? ");
INSERT INTO vgr_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","హమే “పన్నూ బాంద్నుకి కొయిని?” కరి పుఛ్చాయు. ఇనె ఇవ్ను చోర్‍ ఆషనా మాలంకరీన్‍ “తుమె మనషాన ఫహాఃవ్నుకరి సోచుకరస్‍? ఏక్ దేనారం లావోకరి బోల్యొ; ");
INSERT INTO vgr_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","ఇవ్నె లాయిన్, ఇన దెఖ్కాడమా కినూ నామ్‍ఫర్ కినూ పోలిను ఛాపో ఛాకరి పుఛ్చావమా? కైసర్‍ను కరి బోల్యు.” ");
INSERT INTO vgr_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","తెదె యేసు ఇవ్నేతి “కైసరునూ దేనుతె కైసర్‍నా దెవో, దేవ్నా దేనుతె దేవ్నా దెవోకరి బోల్యొ.” ఇవ్నె యోవాత్ హఃమ్జీన్ అష్యం హుయూ. ");
INSERT INTO vgr_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","తెదె సద్దూకయ్యుల్ యేసుకనా ఆయిన్ మరిగయూతె అద్మి పాచు జీవిన్‍ ఉట్సేనాకరి ప్రస్నించా, ");
INSERT INTO vgr_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“బోధకుడ్, భైని రాండ్‍ జీవిన్‍ రవ్వామా ఏక్జనొ లఢ్కకొయినితిమ్‍ మరిగయోతెదె ఇన భైని బావణ్‍నా య్హా కర్లీన్‍ ఇను భైనా లఢ్కాహువతిమ్ కర్నూకరి మోషె హమ్నా లిఖ్కిన్ దీరాక్యోస్. ");
INSERT INTO vgr_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","ఏక్ వొహోఃత్ హాఃత్‍జణ భైయ్యేరాస్, యువ్నమా మోటా భైనా ఏక్ రాండ్‍తి య్హా కర్లీన్, తెదె యో లఢ్కాకొయినితిమ్ మరిగయో. ");
INSERT INTO vgr_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","బెంమ్మనొ యోబాయికోనా య్హా కర్లిదొ, యోబి లఢ్కా కొయినితిమ్ మరీగయో; ఇమ్మస్ తీన్‍మనోబి మరీగయో. ");
INSERT INTO vgr_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","అమ్మస్ యో హాఃత్‍జణా యోబాయికోనా య్హా కర్లీన్ లఢ్కాకొయిని తిమ్మస్ మరిగయా, తెదె యో బాయికోబి ఇవ్నాపీటె మరిగి. ");
INSERT INTO vgr_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","మరిగూతె ఇవ్నమా పాచు జీవిన్‍ ఉట్యతో యోహాఃత్‍ జణమా యోబాయికో కినా బావన్నితరా ర్హాసె? యోబాయికో హాఃత్ జణానబి బావన్‍హుయీని కాహెనా? కరి పుఛ్చాయా.” ");
INSERT INTO vgr_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","ఇనటేకె యేసు అమ్ బోల్యొ, “తుమె తోందర పడుకరస్ పవిత్ర్ గ్రంథంమహో, దేవ్ను థాఖత్‍నహో మాలంనాకరమా అనహాఃజెస్‍ గబ్రాంకరాస్‍. ");
INSERT INTO vgr_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","ఇవ్నే మరణ్‍మతూ జీవిన్‍ ఉట్సేతెదె య్హా కర్షెకొయిని, ఇవ్నె య్హానా దిసెకొయిని, రాండె, మరద్మానొకరి కోర్హాసేని పన్కి, ఇవ్నే స్వర్గంమా ఛాతె దేవ్ను దూతల్‍నితరా ర్హాసె. ");
INSERT INTO vgr_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","అజు ఇవ్నె ఉట్సేకరి మరిగూతె బారెమహో మోషే గ్రంథంమా లిఖ్కాయ్‍రూతె డాగ్‍ను గురించి భాగంమా తుమె పడ్యా కొయినిసూ? యో భాగంమా దేవ్ మే అబ్రాహామ్‍నొ దేవ్‍, ఇస్సాక్‍నొ దేవ్‍, యాకోబ్‍నొ దేవ్, కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","యో జీవిర్యూతె అద్మియేనా దేవ్ పన్కి మర్యాహూయుతెనూ దేవ్ కాహె, ఇనటేకె తుమె ఘణు గలత్ సోచుకరస్, కరి ఇవ్నా బోల్యొ.” ");
INSERT INTO vgr_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","షాస్ర్తుల్‍మా ఏక్జనొ ఆయిన్‍, వాదించుకరతే ఖ్హ్హంమ్‍జీన్, యేసు “అష్యల్ను వాతె బోలుకరస్, ఆజ్ఞ హాఃరమా కెహూ ఆజ్ఞ ముఖ్యంను? కరి యేసున పుఛ్చాయో.” ");
INSERT INTO vgr_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","యేసు అమ్ బోల్యొ, “ముఖ్యంను ఆజ్ఞమా అజు ఘను ప్రాముఖ్యంను ఫ్హైలు ఆజ్ఞ, ఓ ఇస్రాయేల్‍నూ అద్మియే హఃమ్జో; అప్నా ప్రభుహుయోతె దేవ్ ఎక్కస్ ప్రభూ.” ");
INSERT INTO vgr_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","తూ తారపూర దిల్‍తి, పూర ఆత్మతి, పూర అక్కల్తి, తారొ కువ్వాత్తి, భాహుయోతె ప్రభువునా ఫ్యార్‍ కర్నూకరి అస్లీ ఆజ్ఞ. ");
INSERT INTO vgr_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","బెంమ్మను ముఖ్యంను ఆజ్ఞ కెహూకతొ తారు తునస్ కిమ్ ఫ్యార్‍ కర్లేస్కి తార అగల్ బగల్ వాళనాబి ఇమ్మస్ ఫ్యార్ కరనూస్‍ ఆ బెంమ్మని ఆజ్ఞ; అనేతి ముఖ్యంను ఖయూబికొయినికరి ఇనేతి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","యో షాస్ర్తుల్‍తి యేసుతి బోల్యొ, బోధకుడ్! తూ అష్యల్‍తి బోల్యొ “యోదేవ్ ఎక్కస్ తప్ప బుజు కోణ్బి కొయిని” కరి, బోల్యొతె వాత్ హాఃఛిస్‍. ");
INSERT INTO vgr_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","ఇన ఫ్యార్‍ కరవాలు, తారు పూరదిల్తి, పూర అఖ్కల్తి, పూర కువ్వాత్తి, ఫ్యార్ కర్నూకరి బుజు ఏక్జణొ ఇనింతరస్ పార్లేవ్‍నా ఫ్యార్ కరవాలొ, ఆజ్ఞ హాఃరవ్‍మాతిబి, బలిదేవనుతీబి జాహాఃత్ కరి ఇనేతి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","యేసు యో అఖ్కల్తి బోల్యొకరి సోఛిన్ ఇనేతి, “తూ దేవ్ని రాజ్యంనా దూర్ కొయిని” కరి ఇనేతి బోల్యొ. ఇనపాసల్ ఇన సాత్బి పుఛ్చావనా కినాబి హిమ్మత్ కోపూర్యుని. ");
INSERT INTO vgr_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","ఏక్‍ వహఃత్‍ యేసు మందిర్‍మా బోల్తోహూయిన్, అమ్ బోల్యొ “క్రీస్తు దావీద్‍నో ఛియ్యోకరీ కిమ్ షాస్ర్తుల్‍ బోలుకరస్?” ");
INSERT INTO vgr_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","దావీద్‍నె పరిసుద్ధాత్మాతి అమ్ బోల్యొ, “ప్రభు మార ప్రభుతీ బోల్యొ మే తార వైరియేనా తారా గోఢకనా బెఖ్హాడాతోడీ తూ మారా ఖవ్వాత్నీమాండిపర్ బేహ్ః” కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","“దావీద్‍ ఇనూ యోస్ ప్రభుకరి బోల్యొతొ, బుజు యో కిమ్ ఇన ఛియ్యోహుసేకరి, పుఛ్చాయో? ఎజ్గఛాతె అద్మిహాఃరు యోవాతె ఖుషీతి హఃమ్జు.” ");
INSERT INTO vgr_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","అజు యేసు ఇవ్న అమ్ బోధిస్తొహుయీన్ బోల్యొ “షాస్ర్తుల్‍తి జత్తన్‍తి రహో. ఇవ్నె లాంబ లుంగ్డా పేర్లిన్ ఫర్తాహూయిన్, సంతనూ గల్లియేమా అద్మిహాఃరూ దేఖిన్ హఃలామ్ కర్నూకరి దేఖస్.” ");
INSERT INTO vgr_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","ఇవ్నె న్యావ్‍నుజొగొమా అగాఢి బేహ్ఃనూకరి, విందుల్మా అగాఢీస్ ర్హానూకరి దేక్తురాస్. ");
INSERT INTO vgr_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","విధవరాల్ను ఘర్నా డుబావ్తూహుయీన్ కాయిబి మాలంకొయినితిమ్ ఉప్పర్ మాత్రం మోటు ప్రార్థనాకర్తూ ర్హాస్, ఇవ్నె అజు ఘణు సిక్చ ర్హాసే. ");
INSERT INTO vgr_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","యేసు మందిరంమా హుంఢినహాఃమె బేసిన్ అద్మిహాఃరు కాణుకల్‍ నాఖనూ దేక్తూ ర్హయో, ధవ్లత్‍వాలబి కెత్రూకిజణూ ఇన్మా కానుక నాకుకర్తు థూ. ");
INSERT INTO vgr_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","ఏక్ గరీబ్ విధవరాల్ ఆయిన్‍ బే రాగినూ బిళ్ళ నాఖనూ దేఖ్యొ. ");
INSERT INTO vgr_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","యో ఇను సిష్యుల్నా బులైన్ బోల్యొ, “మే ఖఛ్చితనంతి బోలుకరూస్ హుంఢిమా పైష్యా నాక్యుతె హాఃరేతిబి ఆ గరీబ్ విధవరాల్ జాహఃత్ నాఖి. ");
INSERT INTO vgr_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","ఇవ్నె హాఃరు ఛాతె థోడమతూ లాయిన్ నాక్యు పన్కి, కతో ఆబాయికొ ఇనకనా జీవనటేకె ఛాతె దవ్లత్‍ హాఃరూబి లాయిన్‍ నాఖిదిదీ కరి బోల్యొ.” ");
INSERT INTO vgr_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","యేసు మంధిర్‍మతూ జాతో ర్హావమా, తెదె సిష్యుల్మా ఏక్ జణూ, “బోధకుడ్‍! ఆ ఫత్రా కెజాత్నూకి అధ్బుతంనూ, ఫత్రాంతీ భందైర్యూతె మిద్దియే కెజాత్నూకి దేక్కరి బోల్యా.” ");
INSERT INTO vgr_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","ఇనటేకె యేసు బోల్యొ, “ఆ మోటు బాంది రాఖ్యుతె దేఖుకరస్ని, ఫత్రోఫర్ ఫత్రో ఉబార్సే కొయినితిమ్ పడిజాసె.” ");
INSERT INTO vgr_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","యేసు దేవ్ను మంధిర్‍నా హాఃమె ఛాతె ఒలీవా పహాడ్ ఫర్ బేసీన్ ర్హావమా ఇనకేడె ఇన సిష్యుల్ పేతుర్, యాకోబ్‍, యోహాన్, బుజు అంద్రెయబి థా. ");
INSERT INTO vgr_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","ఇవ్నె ఇనా పుఛాయా, “ఆ హాఃరు కెదేహుసె కెహూ గుర్తుర్హాసె.” యో హమ్నబోల్. ");
INSERT INTO vgr_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","యేసు ఇవ్నెతి అమ్ బోల్యొ, “కోన్బి తుమ్న మోసంకరకొయినితిమ్ జత్తన్ ర్హవొ.” ");
INSERT INTO vgr_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","కెత్రూకి జణు మారనామ్తి ఆయిన్, “యో మేస్ క్రీస్తుకరి బోలిన్ కెత్రూకి జనభోవ్నా మోసంకర్సె.” ");
INSERT INTO vgr_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","తుమె యుధ్దాల్నా బారెమాబి లఢాయినూ బాటమా సమాచార్నా హాఃమ్జతెదె, గబ్రావుసూనొకొ; అమ్ హూవనూస్‍ ఛా పన్కి అంతమ్ అత్రే జల్దీస్ ఆవ్సెకొయిని. ");
INSERT INTO vgr_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","అద్మినఫర్‍ అద్మి, రాజ్యంను ఉప్పర్‍ రాజ్యం విరుధ్దంతి ఉట్సె, ఎజ్గా యెజ్గా జమీన్ హాల్సె, ఖాల్ ఆవ్సె, కతొ జణనూ ధరత్నూ జోణ్ను వేదననా సురూహుసె. ");
INSERT INTO vgr_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“తుమార బారెమా తుమె జతన్తి ర్హహో.” ఇవ్నె తుమ్న సభల్మా ధరావ్సె; భందైన్ న్యావ్నుజొగొమా ఉభర్‍స్యూ న్యావ్‍ను జొగొమా తుమే కొల్డావ్తి మార్ ఖాసూ, మారటేకె తుమె రాజొనాహాఃమె మోట్టావ్ను హాఃమెబి ఉబ్రీన్ సాక్చ్యాం బోలను ఛా. ");
INSERT INTO vgr_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","హర్యేక్‍ అద్మియేనా అగాఢి సువార్తనా ప్రచార్ కరీన్‍ బొలావ్నూ. ");
INSERT INTO vgr_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","ఇవ్నె తుమ్న బాంధింలీన్ పుఛ్చావనాటేకె లీన్ జావను వొహఃత్, తుమె సాత్ బోల్నుకరి అగాఢీస్ ఛింత నొకొహుసూ, యో వహఃత్‍మా తుమ్న సాత్ సోచ్చావస్కీ యోస్ బోలొ, సానకాతొ తెదె వాతెబోలుకరతె తుమె కాహె పరిసుద్ధాత్మాస్‍ తుమారమతూ వాతెబోల్సె. ");
INSERT INTO vgr_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","భైయ్యే భైయ్యేనస్ మరైనాక్నుకరి దేక్సె, ఇమ్మస్ భా బీ ఇనా ఛియ్యో మరణ్‍నా కారణ్ హుసే, లఢ్కా ఆయా భానా మరౌనూకరి దేక్సె. ");
INSERT INTO vgr_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","మారు నామ్‍మా హాఃరవ్నహాతె గాళెఖాసూ, పన్కి ధర్తీను ఆఖరితోడి కోణ్ సహీంచీన్‍ ర్హాస్కి దేవ్ ఇవ్నా బఛ్చావ్సె. ");
INSERT INTO vgr_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“కెదె తుమె ఉజ్జాడ్‍హుయూతె యో కర్రాబ్ రాచ్చు ఉబ్రాకొయింతె జొగొమా ఉబ్రాను తుమె దేఖ్యాతెదె పఢవాళు అర్థంకర్నూ” యూదయమా ర్హవ్వలు ఫహాడ్‍కనా మిలాలిజవొ. ");
INSERT INTO vgr_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","ఘర్నఉప్పర్‍ ర్హవ్వాళు ఘర్‍మతూ కెహూబి లీన్ జానుకరి ఉత్రీన్ ఇన్మా జైన్ లీన్ నా ఆవ్ను. ");
INSERT INTO vgr_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","ఖేథర్మా ర్హావ్వాళు ఇను లుంగ్డా లేవానటేకె ఇన ఘేర్ కన నాఆవ్నూ. ");
INSERT INTO vgr_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","ఆయో! యో ధన్మా బేజిణి వాళునహో చెరాళి బాయికోహో, ఇవ్నా కెత్రె కష్టం ర్హాస్కి కాహేనా. ");
INSERT INTO vgr_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","“ఇమ్నూ ట్హండ్నా ధన్ నా ఆవునూ కరి దేవ్ నా ప్రార్థనకరో.” ");
INSERT INTO vgr_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","యో మీన్హాత్ నూ ధన్, దేవ్ బాణాయోతే జామానేతూ హంకెతోడిన ఇమ్నూ మిన్హత్ కోహుయుని, బుజు కెదేబి ఆవ్సెకొయిని. ");
INSERT INTO vgr_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","పన్కి దేవ్ యోధన్నా, కమ్‍నా కర్యొహోత్‍థొతెదె కోన్బి భచ్యూహోత్ కొయిని, యో ఏర్పఛిరాక్యొతె ఛోతె హాఃచెలవాలనసటేకె యోధన్నా కమ్ కర్సె. ");
INSERT INTO vgr_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","పన్కి త్యొధన్‍మా హదేక్ క్రీస్తు అజ్గఛాకరి, ఎజ్గఛాకరి, కోన్‍బి తుమ్హారేతి బోల్యుతొ నొకొనంస్యూ. ");
INSERT INTO vgr_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","కతొ, చ్హాడ్‍ క్రీస్తు, ఛాడ్‍ ప్రవక్తల్ ఆయిన్, అద్భుతంనాబి ఆక్చర్యంనా కరీన్ చూనిరాక్యొతె అద్మియేనా కోసిస్ కరీన్ ఇవ్నా మోసం కర్నూకరి సూచక క్రియల్నా, మహాన్‍కార్యాల్‍నా వతాల్సె. ");
INSERT INTO vgr_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","ఇనటేకె తుమె జత్తన్‍ ర్హహొ; హదేక్ సమాస్తంహాఃరు తుమార అగాఢి బోలిరాక్యొస్. ");
INSERT INTO vgr_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","త్యొధన్‍మా కష్టల్ హాఃరు హుయిజావదీన్ రాత్‍ సూర్యుడ్‍నా అంధారు కర్సె, చందమామ ఇనూ ఉజాలునా దిసెకొయిని, ");
INSERT INTO vgr_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","ఆకాష్ మతూ షుక్కర్ పడిజాసె. ఆకాష్‍మాను షక్తిహాఃరు హల్సె. ");
INSERT INTO vgr_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","తెదె అద్మినొ ఛియ్యో మోటు థాఖత్తి, ప్రభావంతి ఇను మహిమమా మబ్బునావుప్పర్ ఆవనూ అద్మిహాఃరు దేక్చె. ");
INSERT INTO vgr_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","తెదె యో ఇన దేవ్ను దూతల్‍న్నా మొక్లిన్ ధర్తినూ చార్ బాజుమతూ ఏర్పరాక్యొతె ఇవ్నా ఏక్ జొగె కర్సె. ");
INSERT INTO vgr_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“అంజురంనూ ఝాడనదేఖిన్ ఏక్ ఉపమాన్నా సిఖొ.” ఇనుఢాలి బుజు కవ్లూ ఇగూర్ మ్హెంద్యుతొ తడ్కను ధన్ ఆయిత్రుకరి మాలంకర్చు. ");
INSERT INTO vgr_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","ఇమ్మస్ “ఆహాఃరుహువనూ దేఖ్యతెదె యోకందేస్ ధర్వాజనూ హాఃమేస్ ఛాకరి తుమె మాలంకర్సు.” ");
INSERT INTO vgr_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","మే ఖఛ్చితనంతీ బోలుకరూస్, “ఆహాఃరు హువతోడి ఆపిఢి ఉజ్జాడ్‍హుసె కొయిని.” ");
INSERT INTO vgr_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","ఆకాష్‍తోబి ధర్తితోబి మట్సే పన్కి మారివాతె మట్సెకొయినికరి. ");
INSERT INTO vgr_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","యో ధన్నా బారెమా యో వహఃత్‍నా బారెమా భానా తప్ప బుజు దేవ్ను దూతల్‍నాబి మాలంకొయిని. ");
INSERT INTO vgr_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","జత్తన్తి ర్హహొ; హొషార్తి ర్హహిన్, యో కెహూవహఃత్నా ఛా తుమ్న మాలంకొయిని. ");
INSERT INTO vgr_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","ఏక్‍ అద్మి ఇను దాసుల్‍నా అధికార్‍ దీన్‍ దూర్‍నూ దేహ్క్ మా మ్హెందిగయోతే ఇనూ జోడ్ను. ఏక్ మాలిక్ ఇన దాసుడ్‍నా కామ్ కరనాటేకె ఉబ్బారిరాఖిన్, హర్యేక్ జణనా కామ్ ధీన్ హొషార్తీరహోకరీ ద్వారపాలనా ఆజ్ఞదేవను, ఘర్ బేందీన్ దేహ్క్ గయో తిమ్మాస్. ");
INSERT INTO vgr_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","ఇనాటేకె తయార్‍ ర్హవో, “ఘర్‍నా మాలిక్ ధన్ డుబానా ఆవస్కి, వ్హానేక్హాత్రేస్ ఆవస్కి, ఆ అధిరాత్ మా ఆవస్కి, ముర్గువాఖ్హదీన్ ఆవస్కి, కెదెఆవస్కి తుమ్న మాలంకొయిని.” ");
INSERT INTO vgr_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","యో అకాష్మమత్తుమా “యో ఆవానూ వహాఃత్ తుమే లిందర్‍ రవ్వాను నాదేక్నుతిమ్ యో వహాఃత్ హొషార్‍తి ర్హహో.” ");
INSERT INTO vgr_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","“మే తుమారేతి బోలుకరుతె హాఃరెతీబి బోలుకరూస్ జత్తన్‍తి ర్హహొ.” ");
INSERT INTO vgr_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","బే ధన్‍న పాసల్‍ పస్కాపండగ, కతొ ఖాటు రోట్టను పండగఆయు. తెదె ప్రధాన యాజకుడ్‍, షాస్ర్తుల్‍ యేసునా ఆహ్‍ఃరేతి కింమ్‍ ధర్లీన్‍ మర్రాక్నుకరి కుట్రకరీన్‍ సోచుకరమా, ");
INSERT INTO vgr_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","పన్కి, పండగనూ ధన్నే అద్మియేమా లఢాయ్‍హుసే నొకొకరి ఇవ్నె బొల్లిదు. ");
INSERT INTO vgr_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","త్యొ వహఃత్‍మా యేసు బేతనియమా ఖొహోఢ్తి ఛాతె సీమోన్నా ఘర్‍మా ధాన్ ఖావనా బేషీన్ రవ్వమా, ఏక్ బాయికొ ఘర్‍మా ఆయిన్, మోల్నుహుయీతె అష్యల్ను అంగర్నూ జాఢెహూఃతి బనాయుతె మోల్నురాచు అత్తర్ని బుడ్డి ఇనకేడె లాయిన్ మూతనా పోఢీన్ యేసునా ముడ్క్యాఫర్ నాఖి. ");
INSERT INTO vgr_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","ఆ దేఖిన్ ఎజ్గఛాతె త్హోడుజణు చంఢాల్ హుయిన్ యో “అత్తర్నా చుక్కె నుక్సాన్ ష్యాన కరుకరాస్? ");
INSERT INTO vgr_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","ఆ అత్తర్నా బుఢ్డీనా ఏఛతొ తీన్ ఖొః దేనారం ఆవ్సె. యోరఫ్యాతి ఘరీబ్ అద్మినా దెవ్వానుతూ” కరి బాయ్‍కోన బారెమా బన్కిలిద. ");
INSERT INTO vgr_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","ఇనటేకె యేసు అమ్ బోల్యొ, “అన రాండ్ను జోలిన నొకొజవొ; అన బారెమా తుమె సాన ఛింత కరుకరాస్, ఆ మారటేకె అష్యల్ను కార్యమ్‍ కరూకరస్. ");
INSERT INTO vgr_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","గరీబ్ కెదేబి తుమారకనస్ ర్హాసె. తుమ్న లాఢ్‍హుయు తెదె ఇవ్నా మద్దత్ కరజాయ్; పన్కి మే కెదేబి తుమారకేడె ర్హైస్‍కొయిని. ");
INSERT INTO vgr_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","యో ఇను తాహఃత్ ఎత్రే మిన్హత్ కరీన్, మన సమాధి కరానటేకె యోమారు ఆంగ్తన్నా అగఢీస్ అభిషేకించి. ");
INSERT INTO vgr_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","ములక్‍మా యో కెజ్గ సువార్తనా ప్రచార్ కరస్కి, ఎజ్గా ఆ కరీతె హాఃరు హఃయల్ ర్హావనాటేకె కరి ప్రషించబడ్‍సే” కరి తుమారేతి ఖఛ్చితనంతి బోలుకరూస్‍కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","యో భారజణ సిష్యుల్మా ఏక్జణొ ఇస్కరియోతు యూదా, ప్రధాన యాజకుడ్‍నా హాత్మా ఇన దర్యాయ్‍ దేవనాటేకె ఇవ్నకనా గయో. ");
INSERT INTO vgr_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","ఇవ్నె యోహఃమ్జీన్, ఘనూ ఖుషీహుయిన్ ఇనా రఫ్యా దిసూకరి వాత్‍దిదు. ఇనటేకె యూదా యేసునా కెదె ధరావ్నుకరి సమయంనాటేకె దేకుకర్తొ థొ. ");
INSERT INTO vgr_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","ఖాటు కొయింతె రోట్టను పండగమా అగాఢిను ధన్నె ఇవ్నె పస్కా మ్హేండనా బలిదేవనటేకె, సిష్యుల్ యేసుతి “పస్కాపండుగనా కెజ్గ జైన్ ధాన్ బనాయేకరి?” ఇన పుఛ్చాయ. ");
INSERT INTO vgr_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","తెదె ఇనె అమ్ బోల్యొ, “తుమె భేజనా నంగర్మా జవొ; ఎజ్గ పానినూకేళి పల్లిన్ ఉల్యావుతె ఏక్ అద్మి తుమ్న దెఖ్కావ్సె. ");
INSERT INTO vgr_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","యో కెహూ ఘర్‍కనా జాస్కి ఇనకేడె జవొ, యోఘర్ మాలిక్నా దేఖిన్ ‘మే మార సిష్యుల్తి మలీన్ పస్కానా ఖావనటేకె హమ్నగది కెజ్గఛాకి’ బోధకుడ్‍ పుఛ్చాంకరస్‍కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","యో అక్కురాఛతి భరైరూతె మిద్దినవుప్పర్‍నూ మేడగది తుమ్న వతాల్సె. అప్నటేకె ఎజ్గ పష్కానా బనావో” కరి, ఇన బే సిష్యుల్నా బోలిమొక్లూ. ");
INSERT INTO vgr_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","సిష్యుల్ నంగర్‍మా ఆయిన్ యో బోల్యొతిమ్‍ కరీన్, ఇవ్నె పస్కాపండగను ధన్ బనాయా. ");
INSERT INTO vgr_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","తెదె హాఃమ్జె హువమా యో ఇన భారజణ సిష్యుల్తి మలీన్ ఆయొ. ");
INSERT INTO vgr_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","ఇవ్నే హాఃరుజణు బేసీన్ ధాన్ ఖాతూ వొహఃత్ యేసు బోల్యొ, “ఆహాఃఛీస్‍ తుమారమా ఏక్జణొ కతొ మారకేడె బేసీన్ ధాన్ ఖంకరతే తుమారమా ఏక్జణు, మన ధరాయ్ దిసేకరి” ఖఛ్చితనం తుమారేతి బోలుకరూస్‍కరి ఇవ్నేతి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","ఇవ్నా ఘణు బాధ పడీన్, “మేతొ కాహేకున్నా ప్రభుకరి యేక్ కంతూ యేక్ ఇనా పుఛ్చావనిక్యూ.” ");
INSERT INTO vgr_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","యేసు, “తుమార భారజణమా ఏక్జణు కతో మారకేడె గీన్నిమా హాత్ గ్హాలవాలూస్ మన ధోఖకర్సె. ");
INSERT INTO vgr_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","వాక్యంమా లిఖ్కైరూస్ తిమ్ అద్మినో ఛియ్యో మరిజాసె, పన్కి అజు కినహాతె అద్మినఛియ్యో ధరైజాసేకీ యోఅద్మిన గ్హణూ మిన్హత్‍, యో అద్మినటేకె అష్యల్ హోతుకి యో నాఫైదాహూయు హోత్తొ, అష్యల్ హోతు” కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","ఇవ్నె ధాన్ ఖంక్రతొ “అన లేవొ” “ఆ మారు ఆంగ్తాన్‍” కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","తెదేస్ యో గిన్నినా పాడీన్ కృతజ్ఞతాస్తుతుల్‍ బోలీన్ ఇన ఇవ్నా దిదొ, ఇవ్నెహాఃరు ఇన్మనూ పీదు. ");
INSERT INTO vgr_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","తెదె యో, “ఆ మారు నవూ నిబంధన ల్హొయి హాఃరవ్నాటేకె ఛొడ్డాంవ్‍కరూతె మారు ల్హొయి.” ");
INSERT INTO vgr_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","ఆ “మే దేవ్‍నూ రాజ్యంమా జైన్ నవూ ద్రాక్చను రక్హ్ పియ్యతోడి, హంకె తప్ప బుజుకెదేబి ద్రాక్చాను రహ్క్ కోపీస్నీ” కరి తుమారేతి ఖఛ్చితనంతి బోలుకరూస్. ");
INSERT INTO vgr_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","తెదె ఇవ్నె గీత్ బోల్తూహుయిన్ ఒలీవాన పహాడ్కనా గయ్యా. ");
INSERT INTO vgr_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","తెదె యేసు ఇవ్నెతి బోల్యొ, మ్హేండను కాపరిన మార్చు; ఆవ్నే హాఃరూబి చేద్రిజాస్యు; తుమె హాఃరు మన మ్హేంద్యుసు, లేఖనంమా లీఖ్కైరూతిమ్; మ్హేంఢన కాపరినా మారిస్; మ్హేంఢహాఃరు మిలాలిసేకరి. ");
INSERT INTO vgr_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","మే ఉట్యోస్‍కరి ఆయో తెదె “తుమ్హారేహూః అగాఢి గలిలయమా జైస్” కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","ఇనటేకె పేతుర్ “హాఃరు మ్హేందిన్‍ చలిగుతోబి మే తున కోమ్హెందీస్ని” కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","యేసు ఇన దేఖిన్ “తూ ఆజ్ రాతె ముర్గు బే ఛోట్ వాహాఃనా అగాఢి తీన్ ఛోట్ మే కోన్కి మాలంకొయిని బోలిస్” కరి ఖఛ్చితనంతీ బోలుకరూస్‍. ");
INSERT INTO vgr_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","తెదె పేతుర్ అజు ఘణు ఖఛ్చితంగా అమ్ బోల్యొ, “తారకేడె మరిగొతోబి మర్ జైయిస్ పన్కి తూకోన్కి మాలంకొయినికరి కోబోలిస్‍ని” అజు అలాదు సిష్యుల్బి బోల్యా. ");
INSERT INTO vgr_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","ఇవ్నె గెత్సేకరి ఏక్ జోగొమా గయా తెదె యేసు ఇనసిష్యాల్తి, “మే ప్రార్థన కరీన్ ఆవతోడి తుమె అజ్గాస్ బేసిన్ ర్హహో” కరి బోలిన్, ");
INSERT INTO vgr_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","యేసు ఇనకేడె పేతుర్నా, యాకోబ్‍నా, యోహాన్నా కెడెబులాలిజైన్, యో గ్హనూ దుఃఖపడనూ ఛింతపడనుబీ సురుకర్యొ. ");
INSERT INTO vgr_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","తెదెయో ఇవ్నేతి, మార జాన్ మర్జవనా యెత్రే దుఃఖంతీ డుబీన్‍రంక్రస్; తుమె అజ్గాస్ ర్హైహీన హోషార్తి ర్హహొకరి బోలిన్, ");
INSERT INTO vgr_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","యో ధరాషు దూర్మజైయిన్ పార్ గుడ్గేఫర్ బేసిన్, సాధ్య హుయుతో “మిన్హత్ సమయ్” నా ఆవునుకరి ప్రార్థన కర్యొ. ");
INSERT INTO vgr_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","యేసు, “ఓ మార భా తున ధర్తీ హాఃరూబి సాధ్యమస్; ఆ దుఃఖంనా మారకంతూ కన్నాక్. హూయితోబి ఆ మారు ఇష్టం కాహె పన్కి, తారు చిత్తమస్ హువదా” కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","యో బుజు ఆయిన్ ఇనా సిష్యుల్నా దేఖమా హాఃరుజణు హుఃత్యూతె దేక్యొ. తెదె యో పేతుర్తి అమ్ బోల్యొ, “సీమోన్, తూ హుఃతోస్నా? ఏక్ ఘంటోతోబి హొషార్తి కోర్హైనిషూ?” ");
INSERT INTO vgr_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","తుమె హొషార్తీ రహీన్, “సోధనమా నాపణ్నూతిమ్ ప్రార్థన కరో; ఆత్మా సిద్దం పన్కి, ఆంగ్ తన్ ఖంజోర్.” ");
INSERT INTO vgr_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","పరీన్ జైన్ అనేతిఅగాడి బోల్యెతే వాత్నస్‍ ఇమ్మాస్ బోల్తొ ప్రార్థనకర్ఒ. ");
INSERT INTO vgr_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","యో పరీన్ ఆయిన్ ఇవ్నా దేఖమా, ఇవ్నె హుఃతు థూ; కింమ్‍కతొ ఇవ్నా ఢోళా కాడకొయింతె తరబీ లిందర్మా ఇన సాత్ బోల్నుకి ఇన సిష్యుల్నా మాలంకోహుయుని. ");
INSERT INTO vgr_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","యేసు తీన్మనుచోట్‍ ఆయిన్ బోల్యొ, హంకె తుమె హుఃయీన్‍ ఆరామ్‍ లీలెవొ. బుజు బైస్, యోవహఃత్‍ ఆయ్‍త్రూ హదేక్ అద్మినొఛియ్యో పాప్‍కర్యూహుయునా హాత్మా ధరాయ్ జంక్రస్. ");
INSERT INTO vgr_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","ఉట్టొ జియ్యే “హదేక్ మన ధరైదెవ్వాలో కందేస్ ఛా” కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","ఎగ్గీస్, యేసు బుజున్బి వాతె బోల్తొరవ్వామా, భారసిష్యుల్‍హుయోతె ఏక్జనొ ఇస్కరియోతు యూదా ఆయో. ఇనకేడె ఘనూజణు సైనికుల్ను గళ్లొ లట్టావ్నా, ఛర్యావ్నా ధర్లీన్‍, ప్రధానయాజకుడ్‍కంతూ, షాస్ర్తుల్‍కంతూ, మోట్టావ్‍కంతూ ఆయూ. ");
INSERT INTO vgr_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","ఇన ధరాయిదెవ్వాలొ, “మే కినా బుఛ్చా దీస్కి యోస్ యేసు; ఇన ధర్లీన్ జాగ్రుతి లీన్‍జవొ” కరి గుర్తునితరా బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","యో ఆయిన్‍ ఎగ్గీస్‍ ఇనకన జైయిన్ “బోధకుడ్” కరి బులైన్, ఇన బుఛ్చా దేవమా ");
INSERT INTO vgr_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","తెదె ఇవ్నె ఇనావుప్పర్‍పఢీన్‍ ధర్లీన్‍ బాందినాక్యు. ");
INSERT INTO vgr_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","ఇన బాజూ ఉబ్రీన్ థూతె యేక్జణు ఇని ఛరి కాడీన్ ప్రధానయాజకుడ్‍ను దాసుడ్నా మారిన్‍ ఇను కాణ్ కత్రినాక్యు. ");
INSERT INTO vgr_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","ఇనటేకె యో ఇవ్నేతి బోల్యొ, “తుమె ఛోర్‍ ఫర్ ఆయాతిమ్ ఛరీయేతి లట్టాపల్లీన్ మన ధర్లేవనా ఆయునా? ");
INSERT INTO vgr_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","మే హర్యేక్‍ రోజ్ మందిర్‍మా తూమరకేడె ర్హైహీన్‍ బోధకర్తో ర్హయో, పన్కి తెదె తుమె మన ధర్యకొయిని, పన్ని పవిత్ర్ గ్రంథం నెరవేర్నుతిమ్‍ జరగనూస్ పడ్సె”కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","తెదె సిష్యుల్ హాఃరుజణు ఇనా మ్హెందీన్ మిలాయిలీదు. ");
INSERT INTO vgr_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","ఏక్ కవ్వారు చొగ్రు ఇన ఆంగ్‍ఫర్‍ కంభర్నా బాందిరాక్యుతే లుంగ్డా తప్ప కాయిబీ కోతూని, ఇనె యేసునాడె జంమ్‍కరమా, ఇవ్నె ఇన ధర్లిదు. ");
INSERT INTO vgr_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","పన్కి, యో ఇనా ఉప్పర్ పేరిరాక్యొతె, యో లుంగ్డనా మ్హేందీన్ వుగ్గాడోహుయీన్ మీలాయిలీదు. ");
INSERT INTO vgr_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","ఇవ్నె యేసునా ప్రధాన యాజకుడ్‍కనా బులాలీన్ గయూ. ప్రధానయాజకుడ్‍, అధికారుల్, షాస్ర్తుల్‍ హాఃరూజణు ఇనకేడె ఆయు. ");
INSERT INTO vgr_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","పేతుర్‍నె దూర్‍తి ఇనకేడె జాతోహుయిన్ ప్రధాన యాజకుడ్‍నా ఘర్‍ను మ్హైను జొగొమా ఆయో, భటుల్తి మలీన్ ఆగ్‍సేకన హాఃమ్‍జె యోబి బేషిగయో. ");
INSERT INTO vgr_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","ప్రధానయాజకుడ్‍బి, మహసభల్నూ అద్మిహాఃరుబి, యేసునా మర్రాక్నుకరి జూటి సాబుత్ బోల్నుకరి దేఖ్యా పన్కి ఇవ్నా కాయిబి సాబుత్ కోమల్యుని. ");
INSERT INTO vgr_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","కెత్రూకిజణూ ఇనఫర్ జూటి సాబుత్ బోల్యు, పన్కి ఇవ్నె బోల్యుతె యేక్బీ హాఃఛి కోహుయుని. ");
INSERT INTO vgr_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","తెదె థోడుజణు ఉట్టీన్ యేసుఫర్, అమ్ జూటి సాబుత్ బోల్యు; ");
INSERT INTO vgr_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“అద్మిను హాతెహూః బాంద్యుతె దేవ్ను మంధిరంనా పోఢినాఖిన్, తీన్ ధన్మా బుజేక్ మంధిర్‍నా బాందీస్‍ కరి” బోలనూ హమే హఃమ్జ. ");
INSERT INTO vgr_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","పన్కి ఇమ్‍బి ఇవ్ను యో సాబుత్ యేక్‍బి సమాన్‍హుయుకొయిని. ");
INSERT INTO vgr_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","ప్రధానయాజకుడ్‍ ఉట్టీన్ ఇవ్నహాఃమె ఉబ్రీన్ యేసుతి పుఛ్చాయో, అవ్నె తారఫర్ కెత్రూకి జూటి సాబుత్ బోలుకరస్ని. “ఇవ్ని వాత్నా తూ సాత్బీ బోలకొయిన్నా” ");
INSERT INTO vgr_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","పన్కి యేసునే కెహూవాత్ కోబోల్యొనితింమ్ గఛ్చూత్తి ర్హయో. ప్రధాన యాజకుడ్‍ “పరమాత్మనొ ఛియ్యోహుయోతె క్రీస్తు తూస్‍నా?” స్తుతించబడు కరతె “దేవ్నొ ఛియ్యో తూస్‍నా?” కరి పుఛ్ఛావమా. ");
INSERT INTO vgr_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","యేసునె బోల్యొ “ఓహో మేస్” “సర్వ థాఖత్‍వాలొ హుయోతె దేవ్ని ఖవ్వాత్నిమాండిఫర్ అద్మినొ ఛియ్యో బేసిన్ ర్హావనూ, యో స్వర్గంమా మబ్బునూఫర్ బేసిన్ ఆవాను తుమె దేక్చు.” ");
INSERT INTO vgr_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","ప్రముక్‍ యాజకుడ్‍ ఇను లుంగ్డా పాఢిలీన్ ఇవ్నేతి “అప్నా అజు ష్యానూ సాబుత్ హోనూ? కరి పుఛ్చాయో. ");
INSERT INTO vgr_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","అనె దేవ్నా నిందా కరనూ తుమె హంమ్జిరాక్యస్‍ని; తుమ్న సాత్ తోచుకరస్కి బోలొ?” కరి అక్కావనా పుఛ్చావమా అక్కుజణు ఇనేతి వ్యతిరేకంగా మరణ్‍నా అర్హుడ్ కరి ఇనఫర్‍ నేరంనా నాక్యు. ");
INSERT INTO vgr_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","థోడుజణూ ఇనఫర్ తూక్తాహూయిన్, ఇన ఢోళన లుంగ్డాతీబాందీన్, హాతేహూః గుద్తాహూయిన్, “కోణ్ మార్యుకి బోల్” కరి గేళికాడ్యు; కావ్లివాలా లీజైన్ మార్యు. ");
INSERT INTO vgr_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","యో ఘర్నూ హేట్ ఛాతె ప్రాంగణంమా ర్హాతి వొహఃత్ ప్రధాన యాజకుడ్‍నా కామ్ కరవాలిమా ఏక్జని ఆయిన్; ");
INSERT INTO vgr_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","పేతుర్‍ ఆగ్ షేకుకరాతే దేఖిన్; ఇనేతి “తూబి నజరేయుడ్ హుయోతె యేసుకేడె రయ్యోతె కాహేనా?” కరి పుఛ్చాయి. ");
INSERT INTO vgr_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","తెదెయో, కాహే తూ సాత్ బోలుకరస్కి మన మాలంకొయిని, కరి బోలిన్ పార్లిబాజుమా జావమా, తెదేస్ ముర్గువాషూ. ");
INSERT INTO vgr_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","యో దాసి బుజు పెతుర్నా దేఖిన్, అస్పీస్ ఛాతె ఇవ్నా దేఖిన్ “ఇవ్నమా ఏక్జనో” కరి బోలి. ");
INSERT INTO vgr_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","యో అజుబీ ఇమ్మస్ బోల్యొ, “యో హాఃఛి కాహెకరి బోల్యొ, బుజు జరాఘడీమా కందెఛాతె ఇవ్నే ఇనా దేఖిన్ ఆ హాఃఛీస్, ఇవ్నమతూ ఏక్జణోస్” సానకతో తూ గలిలయవాలొస్. ");
INSERT INTO vgr_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","ఇనటేకె “యో ఒట్టులెతో హుయిన్, గాళెదేతొ హుయీన్‍ యోకోన్కి మాలంకొయిని, తుమె బోలుకరతె షాత్కీ మన మనమాలంకొయిని, కరిబోలిన్ చురుకర్యో.” ");
INSERT INTO vgr_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","ఎత్రామస్ బెంమ్మనూ వొఖ్హోత్ ముర్గు చిక్ర్యూ. తెదెయో “ముర్గు బే ఛోట్ ఛిక్రాన అగాఢి తూ మే కోన్కి మాలంకొయినికరి తీన్ ఛోట్ బోలూస్కరా, యేసు బోల్యుతె వాత్ పేతుర్ హాఃయల్ కర్లీన్” మాతుకూట్టిన్ రోవనిక్ల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","వ్హానె కత్రేస్ ప్రధాన యాజకుడ్‍, అధికారుల్, షాస్ర్తుల్‍, మహాసభమా హాఃరు మలీన్ ఏక్ హూఃజ్ కరీన్ యేసునధరీన్ బాందిలీ జైన్ ఇన పిలాతుకనా ధర్యాయిదిదు. ");
INSERT INTO vgr_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","పిలాతు, “యూదుల్న రాజొ! తూస్‍నా?” కరి ఇన పుచ్ఛావమా యేసు సమాధనం దిదో తూ బోల్యొతిమ్మస్! కరి ఇనేతి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","ప్రధాన యాజకుడ్‍ ఇనఫర్ కెత్రూకి చాఢీహాఃరు నాఖమా! ");
INSERT INTO vgr_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","ఇనటేకె పిలాతు బుజు ఇనమ్హని దేఖిన్ “తూ సాత్బి బోలకొయిన్నా, తారఫర్ అవ్నె కెత్రూకి జూటి బోలుకరతె ధేక్” కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","యేసు తెదెబి సాత్బి బోల్యొకొయిని, ఆ దేఖిన్ పిలాతు ఘను అష్యమ్ హుయో. ");
INSERT INTO vgr_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","పస్కా పండగనా ధన్నేఅద్మి కోరతిమ్ పిలాతు ఏక్ ఛోర్నా చుట్కార్ కరస్‍. ");
INSERT INTO vgr_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","బరబ్బా కరి ఏక్జణొ అధికారుల్నా ఎదిరించీన్‍, యో లడ్డాయ అల్లర్నీ ఒహఃత్‍మా హత్య్ కరవాళమాబి ఆ ఏక్జణొ యో బంధించిహుయీన్‍ ఠాణమా థొ. ");
INSERT INTO vgr_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","అద్మిహాఃరు పిలాతుకన ఆయిన్ హార్ వరహ్ః మ్హేంద్యాతె తిమ్ ఆ వరహ్ఃమాబి ఇమ్మస్ ఏక్న మ్హేంద్‍కకి బోల్య. ");
INSERT INTO vgr_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","పిలాతు ఇవ్నేతి బోల్యొ, “తుమారటేకె యూదుల్నా రాజొనా ఛుట్కార్ కరునా?” ");
INSERT INTO vgr_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","ప్రధాన యాజకుడ్‍ ఇనా దుష్మన్‍తి ధరాయోకరి పిలాతునా మాలం, ఇనటేకె మే యూదనొరాజొ తుమ్న మ్హేందుస్యూ? కరి పుఛ్చాయో. ");
INSERT INTO vgr_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","పన్కి ప్రధాన యాజకుడ్‍ బరబ్బానా మ్హేంధాకరి పిలాతునా బోలొకరీ అద్మిహాఃరనా ఉషిదిదూ. ");
INSERT INTO vgr_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","ఇనటేకె పిలాతు, ఇమ్ హూసేతొ “యూదుల్ను రాజొకరీ బులాంకరతే అన సాత్ కర్నూ?” కరి పుఛ్చాయో. ");
INSERT INTO vgr_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","ఇవ్నె, ఇన “సిలువ నాఖొ” కరి, ఘట్ ఖైకార్ మ్హేంద్యూ. ");
INSERT INTO vgr_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","ఇనటేకె పిలాతునె సానహాఃజే? యో “స్యాను తప్పు కామ్ కర్యో” కరి ఇవ్నా పుఛ్చావమా, ఇవ్నేబుజు ఘణు ఛికర్తాహుయిన్ “ఇనా సిలువమా నక్కావో” కరి. ");
INSERT INTO vgr_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","ఇనటేకె పిలాతునె, ఇవ్నే బోలాతిమ్ ఇవ్నాహాఃరవనా ఖుషీ కరావ్నూకరి బరబ్బానా మ్హేందీన్, యేసునా కొల్డాతి మరైన్ సిలువనా ధర్యాయ్ దిదొ. ");
INSERT INTO vgr_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","తెదె సైనికుల్ యేసునా ప్రేతోర్యకరి హఃర్కార్‍ మంధీర్నా ప్రాంగణంమా బులాలిజైయిన్‍, సైనికుల్‍ హాఃరవ్నా గళ్లొకరనబాద్మా; ");
INSERT INTO vgr_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","ఇన బైంగని రంగ్ను లుంగ్డా పెరైన్, ఇనా మాతఫర్ కాటొను కిరీటంనా పెరాయు. ");
INSERT INTO vgr_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","తెదె ఇవ్నే, ఇనా క్హలామ్ కర్తూహుయిన్, “యూదనా రాజొ! జయం” కరి ఇన బులావ్తూహూయిన్ చిక్రాన్ మ్హేంద్యు. ");
INSERT INTO vgr_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","బుజు ఇన ముడ్‍క్యాపర్ లట్టొతి మారీన్, మ్హోడఫర్ థూఖీన్, గుడ్‍గ్యాఫర్ బేసిన్ ఇనా క్హాలామ్ కర్యూ. ");
INSERT INTO vgr_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","ఇన గేళికాఢిన్ పాసల్తీ, పేరాక్యోతె బైంగని రంగ్ను లుంగ్డనా కనాఖిధీన్, ఇన లుంగ్డానయిన పెరాయిన్, తెదె సిలువ నాకనాటెకె బులాలిగయూ. ");
INSERT INTO vgr_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","కురేనె నంగార్నోహుయోతె సీమోన్ కరి ఏక్జనో గామ్‍తూ నికీన్‍ యో వాట్ఫర్ కరి జంకరమా, అనే అలెగ్జాండర్‍ బుజూ రూఫస్‍ కరి ఇవ్నా భా, భటులు ఇనా బలవంతమ్‍ కరీన్‍ సీలువన ఢోవాడ్యు. ");
INSERT INTO vgr_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","ఇవ్నే యేసున గొల్గొతాకరి బోలతెజొగోమా లీన్ ఆయ్యా. గొల్గొతా కతో “కోప్డీ కరి” అర్థం. ");
INSERT INTO vgr_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","ఎజ్గా ఇవ్నే ఇనా ద్రాక్చనూ రఖ్హ్ మా బోళము మాలాయి పీలాకరీ దీదూ, పన్కీ యో కోపిధోని. ");
INSERT INTO vgr_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","ఇన పాస్సల్‍తీ ఇవ్నే, ఇనా సిలువన ఛడయ్యా, ఇనా లుంగ్డాన భాగ్ కర్లేవానటేకె చీట్లు నాఖీన్, యోకినా ఆవ్నుకి ఇవ్నే పల్లీదూ. ");
INSERT INTO vgr_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","ఇనా సిలువ నాఖ్య్హూతేదే వ్హాణేన నౌవ్ బాజూకర్ తుత్హూ. ");
INSERT INTO vgr_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","ఇన ఉఫర్ “యూదులనో రాజొ యేసు” కరి ఏక్ పలకపర్ లీఖ్హీన్ ముఢ్ క్యాఫర్ ట్యాంగాయు. ");
INSERT INTO vgr_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","ఇనకేడె భేజణ బందిపోటు ఛోట్టావ్నా, ఏక్న ఖవ్వాత్ మ్హానె, బుజేక్ జాణనా ఢవ్వాత్ మ్హానె సీలువా నాఖ్య్హూ. ");
INSERT INTO vgr_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","లేఖనంనేరవేరుతిమ్ ఇవ్నే న్యాయంనా వ్యతిరేకంతి కరవాళు. ");
INSERT INTO vgr_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","తెదె యో వాట్ఫర్ జావ్వలూ ఇనా స్యభర్‍ కాడీన్, ఇవ్నే ఇవ్నూ “మూడ్‍క్యూ హాలావ్తూహూయిన్, బుజూ మందీరంనా పోడీన్ తీన్ ధన్మా బ్హాందవాలా, ");
INSERT INTO vgr_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","సీలువను ఉఫ్పర్‍తూ వుత్రీన్, తున తూస్ నాభఛాయ్‍లేనూనా?” కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","ఇమ్ షాస్ర్తుల్‍బి ప్రధాన యాజకుడ్‍బి గేలికాడుతూ, “ఆ అలాదవ్నా బఛ్చావాలో పన్కీ ఇను యోస్ బఛ్చాయ్‍లేకొయినీ.” ");
INSERT INTO vgr_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","ఇస్రాయేల్‍నో రాజొహుయోతె క్రీస్తు హంకే సిలువాఫర్‍తీ ఉత్రీన్ ఆవజై. తెదె అప్నె దేఖీన్ నమ్మియే కరి ఏక్నూ ఏక్ బొల్లిదు. ఇనకేడె సిలువ నాఖ్య్హూతే ఇవ్నేబి ఇన నిందించు. యేసు మర్ జావను. ");
INSERT INTO vgr_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","దొప్పార్ తూ నాకీన్ తీన్ బజేతోడి యోదేహ్‍ః క్హారూబీ అంధారు హుయ్ గు. ");
INSERT INTO vgr_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","తీన్ బజేనా యేసు ఘట్టేతీ, “ఏలోయీ, ఏలోయీ, లామా సబక్తానీ” కతో, మారోదేవ్ మారాదేవ్ మనసాన హాత్‍మ్హేందిదో కరి చిక్రాన్‍ బ్హేంద్యొ. ");
INSERT INTO vgr_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","కంమ్దె వుబ్రీన్ ఛాతే థోడుజణు యో వాతె హఃమ్జీన్, “యోదేక్‍ ఏలియాన బూలవుంకరస్” కరి బోల్యా. ");
INSERT INTO vgr_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","ఏక్జణు మిలావ్తూహుయిన్‍ జైయిన్‍ ఏక్ ఖ్హూత్తర్ను ఖాటు ద్రాక్చనూ రహ్క్నా ఢుబాయిన్ లాక్డాన ఆట్కాయిన్ పియ్యాదేకరీ మ్హోడకనా లీన్‍ గయ్యో; బుజేక్ జనో, “వూబీరాహో ఏలియా ఆయిన్ ఇన హేట్ వుత్రావస్సికీ దేఖియే.” ");
INSERT INTO vgr_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","తెదె యేసు మోటు ఛిక్రాణ్ మ్హేలీన్ జాన్ మ్హేల్యో. ");
INSERT INTO vgr_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","తెదె మందిరంమను భ్హీత్ ఉపర్తీలీన్ హేట్లగూ బేభాగ్‍ చీర్యాయిగూ. ");
INSERT INTO vgr_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","యేసునా హాఃఛి వూబ్రీన్ ఛాతే సతాధిపతి ఇన ఛీక్రాణ్ క్హంజీన్, యో మర్జావనూ దేఖీన్, “హాఃఛిస్, ఆ అద్మి దేవ్నొ ఛియ్యోస్” కరి బోల్యొ. త్హోడూ రాండే దూర్తీ వూఉబ్రీన్ దేఖ్హూకర్తుత్హూ. ");
INSERT INTO vgr_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","ఇవ్నామా మగ్దలెనె మరియబీ, న్హాన యాకోబ్ బుజూ యోసేపున బోలాతే ఇవ్నీ ఆయ్యా హూయితే మరీయాబీ, బుజూ సలోమే త్హా. ");
INSERT INTO vgr_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","యో గలిలయమా రయ్యోతెదె ఆవ్నే యేసున కేడేర్హైతూ, ఇన సేవాకర్తూ రాతుథూ, ఆవ్నేస్ కాహేతిమ్ ఇన కేడె యెరూషలేమ్‍తీ ఆయూతే బగల్ను బాయికాబి కెత్రూకిజనూ ఇవ్నమా రయ్యూతూ. ");
INSERT INTO vgr_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","యో ధన్ క్హారుజనూ మలానుధన్ కతో ఆరమ్‍ధన్ కరతే అగాఢిను ధన్; ");
INSERT INTO vgr_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","అనటెకె క్హాంజ్‍హువమా, తెదె అరిమతయియ యోసేపు, పిలాతూకన జైయిన్, యేసును షవంనా మాంగ్యో, యో ఘానత పోందోతె ఇనమా ఏక్ థో, దేవ్ని రాజ్యంనటేకె ఎదుర్ దేఖవాలో. ");
INSERT INTO vgr_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","యేసు తెదేస్ మరిగోనాకరీ క్హాంమ్‍జీన్ పిలాతు హాష్యమ్ హుయిగో, ఏక్‍ షతాధిపతినా ఇనకన బూలాయిన్, “యేసు తెదేస్ మరీగొసూ?” కరి ఇన పూచ్ఛాయో. ");
INSERT INTO vgr_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","యో షతాధిపతి యోవిషయం మాలంకరీన్, యెసేపునా యోషవంనా దినాకిధిదో. ");
INSERT INTO vgr_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","యెసేపు ధోళుక్హాదు లుంగ్డనా మోల్ లీన్ యేసుషవంనా ఉత్తారీన్ ఆంతన్నా లుంగ్డాతీ లప్టీన్, బంఢోకాఢిరాక్యూతే సమాధిమా ఇన మ్హైబెంధీన్ బంఢోనా మూచినాక్యూ. ");
INSERT INTO vgr_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","మగ్దలేన మరియబి, యోసేపు ఆయా మరియబి, షవంఛాతే జొగొనా దేక్యా. ");
INSERT INTO vgr_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","ఆరామ్నుధన్ హుయ్‍జావంతరస్‍ మగ్దలేనె మరియబి, యాకోబ్‍ని ఆయా మరియ, అజు ఇని భ్హేన్ సలోమేబి ఆయిన్‍, ఛందన్ను జాఢను తేల్‍నా ఇన లగాఢ్నుకరి లీదు. ");
INSERT INTO vgr_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","ఇవ్నె ఆదివార్‍నా వ్వానె హఃత్రెస్‍ ఉట్టీజైయిన్ చంద్రమా నిక్యోతెదె సమాధికనా ఆంకరమా. ");
INSERT INTO vgr_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","ఇవ్నె ఆదివార్నా ధన్నె వ్హానేస్ ఉట్టీన్ సమాధికనా ఆంక్రమా, “సమాధికంతూ కోన్ అప్నటేకె సమాధినూ బంఢోనా కాడ్సెకరి” ఏక్నాయేక్ బొల్లిదీయే. ");
INSERT INTO vgr_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","ఇవ్నె ఆయిన్ ఢోళొపాఢిన్ దేఖమా, యో సమాధినూ బంఢో కాఢైర్యూతె దేక్యా. ");
INSERT INTO vgr_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","తెదె ఇవ్నె సమాధిమా జైయిన్, ధోలుహుయూతె లాంబు లుంగ్డాన పేర్రాఖిన్ కవ్వాత్ బ్హనె బేసిన్ ఛాతె ఇనదేఖిన్ హాఃరు ఢరిగయూ. ");
INSERT INTO vgr_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","“యోకవ్వారు ఛొగ్రు ఢర్నొకొ, సిలువ నక్కాయోతె నజరేత్ యేసునటేకె దూండు కరస్నా? యో జివీన్ ఉట్యోస్‍ అజ్గాకొయిని; ఇవ్నె ఇన హుఃడాయ్ రాక్యుతె జొగొదేఖొ. ");
INSERT INTO vgr_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","తుమె జైయిన్ యో తుమారేతిబి అగాఢి గలిలయమా జంకరస్కరి, యో తుమారేతి బోల్యొతిమ్ ఎజ్గా తుమె ఇన దేక్చుకరి సిష్యుల్‍తీబి పేతుర్తీబి బోలొకరి బోల్యొ.” ");
INSERT INTO vgr_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","ఇవ్నె బ్హాధర్ ఆయిన్‍, కాప్తుహుయిన్ గబ్రాయ్‍ జైయిన్ సమాధికంతూ మిలాయ్‍లీదు. ఇవ్నె ఢరిజావమా ఇనటేకె ఇవ్నె కినాబి ష్యాత్బి‍ బోల్యాకొయిని. ");
INSERT INTO vgr_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","యేసు ఆదివార్నా వ్హానే హఃత్రేస్ ఉట్టీన్, యో హాఃత్ భూత్‍నా మొక్లొతె మగ్దలేని మరియనా అగాఢి దెఖ్కాయో. ");
INSERT INTO vgr_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","ఇనకేడె రవ్వాలు ఇవ్నె దుఃఖ్‍క్తి రొంక్రమా యోరాండ్ జైయిన్ ఆసంగతినా మాలం కరాయి పన్కి; ");
INSERT INTO vgr_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","యోజివీన్‍ ఛాకరి, యోబాయికోన దెఖ్కాయోకరి ఇవ్నె హఃమ్జ్యూ పన్కి ఇనివాతెనా నమ్యకొయిని. ");
INSERT INTO vgr_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","ఇన పాసల్తి ఇవ్నమా భేజణ ఏక్ గామ్ చాలిన్‍ జంక్రమా, బుజేక్ పెరాహోఃమా దెఖ్కాయో. ");
INSERT INTO vgr_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","ఇవ్నె జైన్ బుజు హాఃరవ్నా బోలమా, ఇవ్నేబి అవ్ని వాతెన నమ్యూకొయిని. ");
INSERT INTO vgr_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","పాసల్తి గ్యారజణ సిష్యుల్ ధాన్ ఖావనా బేసిన్ ఖంక్రతొ యో ఇవ్నా ప్రత్యక్చహుయో, ఇనె జివీన్ పాఛొ ఉట్టీన్‍ ఆయోకరి థోడుజణు బోల్యుతోబి తుమె అవిష్వాస్‍కరతె బారెమా, అనటేకె యేసు నమ్మకొయింతె ఇవ్నా గుర్ఖాయో. ");
INSERT INTO vgr_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","“బుజు తుమె ధర్తిమా జైన్, ములక్ హాఃరవ్‍మా సువార్తనా ప్రచార్ కరొకరీ బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","నమ్మిన్ బాప్తిస్మమ్‍ లెవ్వాళొ బఛ్చిజాసె; నమ్మకొయింతె ఇవ్నా షిక్చ నాక్చె. ");
INSERT INTO vgr_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","బుజు నమ్మతె ఇవ్నా ఆ హాఃణత్ దెఖ్కావ్సె; యోష్యాత్ కతొ మార నామ్‍తి భూత్‍నా నహాఃడ్‍స్యూ; ఇవ్నా ఆవకొయింతె నవూ భాషనూ వాతె బోల్చు, ");
INSERT INTO vgr_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","తుమార హాతెతీ హాఃప్నా పాఢీన్ ధర్చూ, మర్జావను సాత్ పీదతోబి యో ఇన సాత్బి హుసెకొయిని, రోగ్ వాలంఫర్ హాత్ మ్హేంద్యతెదె యో అష్యల్ హుసె” కరి ఇవ్నెతి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","యేసు ఇవ్నేతి ఆవాత్ బోలిన్, ఇనపాసల్ స్వర్గంమా జైయిన్ దేవ్ను ఖవ్వాత్ని మాండిఫర్ బెట్టొ. ");
INSERT INTO vgr_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","ఇనపాసల్తి సిష్యుల్ జైన్ వాక్యంనా ప్రచార్ కర్యా. దేవ్ ఇవ్నకేడె మద్దత్‍నితరా ర్హహీన్, ఇవ్నె ప్రచార్ కర్యతె వాతె హాఃఛికరి రుజువు కరనటేకె అద్భుతాల్నా కరివతాళ్యా వాక్యంమా స్థిరమ్‍కస్తూ రయ్యా, ఆమేన్.");
INSERT INTO vgr_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","అచ్చు నామ్‍కమాయోతె థెయొఫిలా కెత్రూకి అద్మియే ఇవ్నా ఇచ్మా ఆ జర్యూగూతే అక్కు సంగతుల్నా లిఖ్కానా హాఃజె జోడ్‍హూయ ");
INSERT INTO vgr_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","అగాఢితూ ధరీన్‍ డోళాతి దేఖీన్‍ బోల్యుయుతే సంగతుల్నా అప్నమా యో వార్త లిఖ్కానాహఃజే జోడ్‍హూయ ఇనటేకె తునా బోలాయుతే సంగతుల్‍ హఃఛిహూయుకరి తూమ్న మాలంకరవనాటేకె, ");
INSERT INTO vgr_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","షానకతో అగాఢితూ ధరీన్‍ ఆహాఃరు మే ఏన్‍ కరీన్ అషల్‍కరి షొఛిచ్‍ క్రమంతి ఆ సంగతుల్నా తుమ్నా లిఖ్కాయ్రూస్‍ ");
INSERT INTO vgr_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","తుమె కెహూ ఖంజకి సంపూర్ణహుయూకరి సత్యహుయుతెకరి తుమె మాలంకరనాటేకె మే లిక్కుకరూస్‍. ");
INSERT INTO vgr_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","హేరోదు రాజొ యూదయ దెఖ్నా ఏలుకరతె ధన్మా జేకర్యాకరి ఏక్‍ యాజకుడ్‍ ర్హాతొ థొ. అబీయా కరి బోల్యొతే యాజక షాఖనా సంబంధించు హుయు ఇని బావణ్‍ అహరోన్ ఛోరియమా ఏక్జని ఇనూ నామ్‍ ఎలీసబెతు. ");
INSERT INTO vgr_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","అవ్నె బేజణ ప్రభునూ ఖారు అగినాన్ చాల్తుహూయిన్‍ న్యాయ్‍ విదుల్‍మహో ఖర్రాబ్‍నామ్ నాఆవ్నూతిమ్‍ నీతిమంతుల్‍హు‍యిన్‍ రయు. ");
INSERT INTO vgr_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","ఎలీసబెతు వాంజిణీ, అజు అవ్నె బే జణా బుఢహూయిగా పన్నీ లడ్కా కోపైదాహూయిని. ");
INSERT INTO vgr_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","జేకర్యా ఇనూ షాఖనా సంబందించు హూయు ఇనూ యాజక ధర్మమ్ కరుకర్తొతో, యో ఇనూ యాజక కామ్‍కర్తోరవమా. ");
INSERT INTO vgr_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","ఆలయంమా దేవ్నా దివ్వో నాఖనటేకె నామ్‍లిక్కీన్‍ చీటినాకమా జేకర్యయాను నామ్‍ ఆయు. ");
INSERT INTO vgr_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","యో దివ్వో బాలుకర్తొతొ బ్హాధర్‍ ఆయురుతే జనం అక్కుజణు ప్రార్థన కరుకర్తుతూ. ");
INSERT INTO vgr_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","దివ్వోబాలనా జోగును హఃవాత్‍మ్హని ఉబ్రీన్‍ ఏక్‍ దేవ్ను స్వర్గ్ దూత జేకర్యానా దెఖాయో. ");
INSERT INTO vgr_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","జేకర్యా దూతనా దేక్కూస్‍కర గబ్రాయిన్‍ అజు ఇన ఢర్‍లగ్యు. ");
INSERT INTO vgr_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","దేవ్నూదూత ఇనేతి, “జెకర్యా ఢర్‍నకొ తారి ప్రార్థన హఃమ్‍జాయు తారి భావణ్‍ ఎలీసబెతు ఏక్‍ ఛోగర్వానా యో ఛొగర్వానా యోహాను కరి నామ్‍ మ్హెంధ్‍జొ” కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","యో పైధాహుయోతొ తూ గణు ఖుషి హుయిస్‍ తుబి ఎజ్గాను అద్మీయె అక్కుజణు ఖుషి హూసే. ");
INSERT INTO vgr_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","యో దేవ్నూ డోలామా ఘాణు మోటొహుయిన్‍ ర్హాసే. యో ద్రాక్చనూ రహ్ఃతి బనాయుతె ధారు, షేంది కోపిషేని. యిని ఆ యాను పెట్మాతు అయూతే ధరీన్‍ పవిత్రాత్మతి భరైన్‍ ర్హాసే. ");
INSERT INTO vgr_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","ఇష్రాయేల్‍ అద్మియేనూ దేవ్‍కనా ఆ గణు అద్మియేనా బూలాయిలావ్‍సే. ");
INSERT INTO vgr_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","భానూ దిల్‍న లడ్కాబణే ఫరావనటేకె, దేవ్నా నమ్మకోయిన్తె అద్మియేనా నీతీమంతుల్‍ను మార్గమ్మా కమావహఃరూకు కరనటేకె, దేవ్‍నూ రాకడనా అద్మియేనా సిద్దపరచనటేకె ఆ ఏలియామా ఛాతే ఆత్మ బలంతీ ప్రభుతి అగడీ జాసే కరీబోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","జెకర్యా దేవదూతతీ, “తూ బోల్యొతిం హూసేకరీ సాబుత్‍ ష్యాత్? మేబి మారీ బావణ్‍ గణు బుడ హూయిగ” కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","దేవదూత ఆం బోల్యొ, మారూ నామ్‍ గాబ్రియేల్‍ మే దేవ్ను ఖామే ఉబ్రీన్‍ రవ్వాలొ, తూన ఆ అచ్చు వాతే బోల్‍కరీ మన బోలిమోక్‍ల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","బుజు జత్తన్‍ తూ మారి వాతే నమ్ముకర కొయిని, యినటేకె తూ ముక్కో హూయిజైస్‍ థోడ ధన్‍కేడె ఆ వాతే హాఃఛి హూసె, త్యో వహఃత్‍తోడి తున వాతె ఆవ్సె కొయిని. ");
INSERT INTO vgr_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","తెదె యో వహఃత్‍మా భార్‍ ఆయ్రూతె అద్మియే హాఃరు జేకర్యానా హాఃజె దేక్తాహుయిన్‍ ఆలయంమా యో ఆత్రె ధేర్‍ కరమా యూవ్నే ఖారు హాషంహూయా. ");
INSERT INTO vgr_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","తేదె జేకర్యా భార్‍ ఆయో కాని ఇవ్నేతి వాతే బోలానా కోహూయిని. ఆలయంమా యినదేవ్‍నూ దర్షన్‍ హూయు కరి ఎజ్గా రవ్వాళు మాలంకర్లిదు. తేదె యో ఇవ్నా హాత్నూ ఇషార కర్తోహుయిన్‍ ముఖ్కొ హుయి ర్హయో. ");
INSERT INTO vgr_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","జేకర్యా కామ్‍నూ ధన్‍ హాఃరా హూయిజవమా యో యిను ఘర్‍కన చలిగయో. ");
INSERT INTO vgr_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","తోడదన్‍నా బాద్‍మా జేకర్యాని బావణ్‍ ఎలీసబెతు భేజిని హూయి. ఫాచ్‍మైనతోడీ యో ధర్వాజుబి కోదాటిని. ");
INSERT INTO vgr_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“ప్రభు మన ఆ వయసుమా బేజిన్‍ హూవనా కృప దిదో; చార్‍ అద్మీయేమా త్హూతే మారు షరంనా కణ్నక్‍దిదో” కరి యో బోలి. ");
INSERT INTO vgr_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","ఎలీసబెత్‍ ఛోమ్హైనని బేజినితి. తేదె దేవ్‍నె గాబ్రియేల్‍ దూతనా గలిలయమా నజరేతుకరీ ఏక్‍ గామ్‍మా; ");
INSERT INTO vgr_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","దావీదును వంషంనో యోసేపు కరి ఏక్‍ అద్మీతి యో ఛోగిరినా హఃగాయి హుయ్రూథూ, యో ఛోగిరినూ నామ్‍ మరియ ఇనా ఆ సందేసంనా బోలిమోక్లొ. ");
INSERT INTO vgr_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","యో దేవదూత‍‍‍‍ ఇనకనా జైన్ తునా అఛ్చు హువధా! ప్రభూ తారకేడె ఛాకరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","మరియ దేవదూతను వాత్న హాఃమ్‍జీన్‍ ఢరిజైన్‍ ఆ వాతేనా మత్లబ్‍ ష్యాత్‍ కరి అష్యంహుయు. ");
INSERT INTO vgr_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","ఆ దేఖిన్‍ దేవదూత యినేతి అమ్‍ బోల్యొ ఢర్నకొ మరియ! దేవ్‍ తున కృప కరి రాక్యోస్‍. ");
INSERT INTO vgr_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","తూ బేజిని హూయిన్‍ ఏక్‍ ఛొగ్రనా ఫైదాకరీస్‍, యిన యేసు కరి నామ్‍ మ్హేంద్‍జొ. ");
INSERT INTO vgr_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","యో ఘణు మోటొ హూయిన్‍ సర్వోన్నతుని దేవ్ను ఛియ్యోకరి బోలావ్సె. ప్రభువు హుయోతె దేవ్ ఇనా జమాననూ దావీదును రాజునితర సింహసన్‍నా యిన దిసె. ");
INSERT INTO vgr_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","యాకోబును ఇస్రాయేల్‍ వంషం అక్కవ్‍నా యేసు ఎల్లకాలం ఏల్‍సే. ఇని రాజ్యం కేదేబి అంతం కోహూసేని కరి ఇనేతి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","మన అజూన్‍బి య్హా కోహూయిని! ఆ కీమ్‍ హూసే? కరి మరియ దేవదూతనా పూచాయ్‍. ");
INSERT INTO vgr_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","యో దేవదూత ఆం బోల్యొ, పవిత్రాత్మ తార ఉప్పర్‍ ఆవ్‍సే తేదే సర్వోన్నతుని దేవ్‍ని షక్తి తున కమ్మిలిసె. ఇనటేకె తునా ఫైదాహుసేతె లఢుకు పవిత్రంగా ర్హసే. యో లఢుకు దేవ్‍నూ చియ్యో కరి బోలావ్‍సే. ");
INSERT INTO vgr_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","తారు హాఃమ్దేను హాఃగు హాఃల్‍ ఎలీసబెతు ఇని బుఢీ ఉంబర్‍మా ఆయా హుంక్రస్‍ వామ్జినికరి బోలాయ్‍తే యో హంకె ఛోమైనని బేజిని హుయ్‍రీస్‍. ");
INSERT INTO vgr_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","దేవ్‍నా హూవకోయిన్తే కాయిబికొయినికరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","తెదె మరియ, “మే ప్రభునా సేవ కరవాలి. తూ బోల్యొతిమ్ హూవదా” కరిపాచు పరీన్‍ బోలి. తెదె దేవదూత ఇనకంతూ చలేగొ. ");
INSERT INTO vgr_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","ఎగ్గీస్‍ యో ధన్నువ్‍మా మరియ యూదా ఫాడ్‍నూ గాంమ్మా గయా. ");
INSERT INTO vgr_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","యో ఎజ్గ ఎలీసబెతుతి మలీన్‍, వందనాల్‍ బోలి. ");
INSERT INTO vgr_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","యిని వాత్ హఃమ్జుస్‍కర ఎలీసబెత్‍నూ పేట్మాను లఢూకు ఆనంధంతి కూధనిక్ల్యు. తేదె ఎలీసబెతు పవిత్రాత్మతీ భారైగయి. ");
INSERT INTO vgr_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","యో చీక్రీన్‍ బాయికోవ్‍మా తు ఆషీర్వదించబడి, తారు పెట్నూ లఢూకుబి ఆషీర్వదింపబణ్‍నూ. ");
INSERT INTO vgr_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","మారు ప్రభుని ఆయా మారకనా ఆవాను మనా కిమ్‍ కృప కరుకరస్‍? ");
INSERT INTO vgr_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","హాదేక్‍ తారి వాతె మార కాన్మా పఢూస్‍కర మారు పెట్మనూ లఢ్కు ఖుషీతి ఉఢిన్‍ కూద్యు. ");
INSERT INTO vgr_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","ప్రభు బోల్యొతిమ్‍ నమ్మి, యినటేకె తూ గణు ధన్యురాల్‍ కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","తెదె మరియ అమ్‍ బోలి; మారు దిల్‍ ప్రభునా స్తుతి కరూకరస్‍. ");
INSERT INTO vgr_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","యో ఇనూ దాసిరాల్నూ దీన స్థితినా ప్రాప్తి కర్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","మారు ఆత్మ మన బచవాళో దేవ్‍కనా ఆనంద్‍ హుంక్రస్‍; హంకెతూ ధరీన్‍ హాఃరు పిఢినూబి మన ధన్యురాల్‍ కరి బోల్సె. ");
INSERT INTO vgr_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","దేవ్‍ సర్వషక్తి సంపన్నుడు. యోమన కెత్రుకి అష్యల్ కర్యొ! ఇను నామ్ ఘణు పవిత్రం, ఇను నామ్‍ ఘణు పరిషుద్ధంను. ");
INSERT INTO vgr_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","ఇనా దేఖిన్‍ ఢరవాళనా ఇనె కెత్రూ జమానామాబి గోర్‍ దెఖాడ్సె. ");
INSERT INTO vgr_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","ఇను థాకత్ను హతేహూః హంఖర్యేనూ హఃయల్‍యేవ్నా మహాఃళ్‍ నాక్‍దీసె. ");
INSERT INTO vgr_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","రాజ్యల్‍ యువ్ను సింహసన్ మాతు ఉత్రాయి నాగ్దిసే గరీబ్‍నురాల్‍ అద్మీయేనా ఊచుజొగోమ బెహాఃడ్సె. ");
INSERT INTO vgr_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","భుక్కే ర్హావ్వాలు అద్మియేనూ అవసరాల్‍ అక్కు తీరహఃరుకు దేక్చె. దౌవ్లత్‍ వాళోనా ఖాళి హతేతి బోలిమోకల్సె. ");
INSERT INTO vgr_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","సజమానమతు ధరీన్‍ అప్నా పితరుల్‍తి అబ్రాహామ్ను ఇన లఢ్కావ్‍తి బోల్యొతిమ్‍, దేవ్ను మర్జితీ జీవిహూయు ఇస్రాయేల్‍ అద్మియేనా మధ్దత్‍ కర్యొ, నాబుల్‍ తిమ్‍ యువ్నా ఉప్పర్‍ మధ్దత్‍ కరో కరి బోలి. ");
INSERT INTO vgr_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","తేదె మరియ ఎలీసబెత్‍ నా ఘర్మా తిన్‍ మైహిన రైన్‍, ఇనాబాద్మా ఇను ఘర్‍కనా ఛలీగి. ");
INSERT INTO vgr_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","ఎలీసబెతునా జణాను ధన్‍ ఆవమా యో లడ్కాన ఫైదాకరి. ");
INSERT INTO vgr_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","యూవ్నూ మాయమాత్ర, ఆజు బాజుల్యు ఎలీసబెత్‍నా ప్రభు గణు కనికరించ్యో కరి ఖుషీ హూయు. ");
INSERT INTO vgr_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","ఆట్మను ధన్నె యూవునే యో చోగర్యాన సున్నతీ కరనటేకె ఆయిన్‍, జెకర్యా యిను భానుస్‍ నామ్‍ మ్హేంధ్‍నూ కరిలైగో. ");
INSERT INTO vgr_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","పన్కి యిని ఆయా “యో నామ్‍ నకోకరీ! యోహానుకరి నామ్‍ మ్హేంధో” కరి బోలి. ");
INSERT INTO vgr_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","యూవ్నె, తూమ్హరా అద్మీయేమా ఆనామ్‍ కీనాబి కోయిన్‍ని కరి బోలి. ");
INSERT INTO vgr_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","యో ఛోగర్వానా భాతీ తూ క్హయూ నామ్‍ మ్హేంద్నూ కరి షోచుకరస్ కరి‍ ఇనా ఇషార కరీన్‍ బొల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","యినే ఏక్‍ పల్కునా మంగాయిన్‍ ఇన ఉపర్‍, “యిన యోహను కరి నామ్‍ మ్హేందొ” కరి లిఖ్యొ. ఆ దేఖీన్‍ అక్కుజణు ఆష్చర్యంహూయుగు. ");
INSERT INTO vgr_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","తేదెస్‍ యినూ మ్హోఢు, జీబ్‍ కదిలీన్‍ అసేల్‍హూయిన్‍, దేవ్‍నా స్తుతించిన్‍ వాతే బోలనిక్లో. ");
INSERT INTO vgr_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","హంకళ్యు, హింకళ్యూమా ఢర్‍, భక్తీమా భరాయిగయు. యూదయ ఫాఢ్‍నూ జోగొ మొత్తంమా ఆవాతె ఫైలాయ్‍గయు. ");
INSERT INTO vgr_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","ఆ వాతే ఖ్హాంజుతే ప్రతి ఏక్‍ జణు లహిగయు, ఆ లఢూకు కేవుడోమోటొ హూవస్‍కి! కరి బోల్యు. ఆ ఛోగర్వానా దేవ్‍నుహాత్‍ కేడెరసే. ");
INSERT INTO vgr_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","యోహాన్నో భా జేకర్యా పవిత్రాత్మతి భారైన్‍ దేవ్‍ని వాతేనా ఆం బోలిన్‍ బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","యిను జానమ్‍న స్వేఛ్చ దీన్‍, భచవన ఆయోతే ప్రభునా స్తుతించో! ఇస్రాయేల్‍ అద్మీయేనూ దేవ్‍నా స్తుతించో! ");
INSERT INTO vgr_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","గణు మోటు షక్తిఛాతె యిన, సేవ కరవాళోహుయోతే దావీదునూ, వంషంమతూ అప్నాటేకె బోలిమోకల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","తో జమానమా పవిత్రల్‍ను ప్రవక్తల్‍ నా హతేఖ్హూ ఆవాతె బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","దేవ్‍ వైరిమతూ, అప్నదూషించ వళానుహత్‍మతు అప్నా బచ్ఛావ్‍షే. ");
INSERT INTO vgr_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","అప్న భానా, నానోవ్నా, ఒఢోవ్నా కరుణించుస్కరి బోల్యొ. యో పవిత్రంనూ నిబంధననా బులీస్‍కోయిని కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","వైరియేమతూ బఛ్చావ్సెకరి బోలిన్‍, అప్నా భా అబ్రాహామ్ను వాత్‍ ధిదో. ");
INSERT INTO vgr_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","అప్నే కెయూబి ఢర్‍ కోయినితిమ్‍ దేవ్నా సేవ కర్‍నూ. ");
INSERT INTO vgr_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","జీవితం అక్కు ఇనా హాఃమె పవిత్రంతీ, న్యాయంగా, యినటేకెస్‍ జీవ్నుకరి ఇనూ ఉద్దేష్యం. ");
INSERT INTO vgr_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","ఓ ఛోగర్వా! తు సర్వోన్నత్‍ని ఏక్‍ ప్రవక్త కరి బోలావ్‍సే! ప్రభుతీ అగడీస్‍ జైన్‍ యినీ వాట్‍నా కడ్‍సే. ");
INSERT INTO vgr_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","ప్రభు ఇవ్ను పాపంనా ధోయ్‍తోస్‍ ఇవ్నే బఛ్చాను మల్సేకరి; అఖ్కల్‍నా యో అద్మీయేనా బోల్‍దీసే. ");
INSERT INTO vgr_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","అప్నో దేవ్‍ యిను కనీకరంతి పరలోకంమతూ ఏక్‍ కృపమయుడ్‍నా నీతి సుర్యుడ్‍నా బోలిమోక్లీన్‍. ");
INSERT INTO vgr_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","మరణ్‍మనూ అంధారమా ఛాతె అప్న ఉప్పర్‍ ఏక్‍ ఉజళునుతర భల్‍తూర్వాహన టేకె కరీన్‍ అప్నా అచ్చు షాంతినూ వాట్‍ఫర్‍ చలావ్సె! ");
INSERT INTO vgr_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","యో ఛొగ్రు మోటొహుయిన్‍ ఆత్మమా కువ్వాత్‍వాలొ హుయీన్‍, ఇష్రాయేలు అద్మీయేనా బోధించాను వోహాఃత్‍ ఆవతోడి యోహను జాఢీస్‍మా జీవ్‍తో ర్హయో. ");
INSERT INTO vgr_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","యో ధన్నువ్‍మా ములక్‍ ఆ ఖ్కమా జనాభాను గణ్తీ లిఖ్కావనటేకె రోమాను రాజు హుయోతే ఔగస్తుర్‍ ఏక్‍ వచన్ దిదో. ");
INSERT INTO vgr_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","కురేనియ సిరీయ దేహఃనా ఏలుకరతే ధన్‍మా ఆస్‍ ఫైలీ భార్‍ జనాభను గణ్తి. ");
INSERT INTO vgr_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","యినటేకె ప్రతి ఏక్‍జణు జాబితమా నామ్‍ లిఖ్కావనా యూవును సోంత గామ్‍మాగయూ. ");
INSERT INTO vgr_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","యోసేపు దావీదునో జాత్మ ఫైధాహూయోతే యినటేకె యో గలీలయమా నజరేతు కరి ఏక్‍ క్హాయర్‍మాతు యూదయ దేఖ్‍ఃమను దావీదు ఖాయర్‍మా గయో. యిన బేత్లెహేము కరి బోల్తుతూ. ");
INSERT INTO vgr_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","యో వోహాఃత్‍మా యోసేపునా మరియతి హఃగాయి హుయిరైన్‍, బేజిన్‍బి హుయిరీతి జానబ లేక్కాన లిఖ్కావనటేకె లీన్‍ గయో. ");
INSERT INTO vgr_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","యూవునే ఎజ్గా రవ్హాదీన్‍ మరియనా జణావను ధన్‍ ఆయు. ");
INSERT INTO vgr_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","యో ఏక్‍ ఛోగరనా జణీన్‍ యూవనా సత్రంమా జోగోబి నామళమా యో ఛోగరనా లుంగఢతి లప్‍టిన్‍ ఢామ్ఢ్హాని తోట్టిమా క్హాఢయిరాక్యు. ");
INSERT INTO vgr_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","యో దేహ్‍ఃమా థోడు జణు బోకఢ చరవళు యూవునే బోకఢవ్‍నా ఖేతర్‍మా రాత్‍నూ కాపల కరూకర్తుథూ. ");
INSERT INTO vgr_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","ప్రభును దూత యూవ్నా కనా ఆయిన్‍ ప్రభును మహిమ యూవ్నా ఆష్పీస్‍ ప్రకాషించమా యూవ్నే గణు ఢరీ గయా. ");
INSERT INTO vgr_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","కాని యో దూత యూవ్నేతి, “ఢరోనకో అద్మీఖారవ్‍నా మోటు ఖుషీహూవను అచ్చువాతే మే తూమ్నా మాలమ్కరావ్‍ కరుస్‍. ");
INSERT INTO vgr_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","ఆజస్‍‍ దావీదు క్హాయర్‍మా భచవవాళో తూమార టేకె పైధాహూయిరూస్‍. యోస్‍ అప్నో ప్రభుహూయోతే క్రీస్తు. ");
INSERT INTO vgr_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","యో తూమ్‍నా ఏక్‍ క్హాణత్‍ బోలుస్‍. డాంఢోని తొట్టిమా ఏక్‍ లఢూకు ధోళు లుంగఢుమా లఫ్‍టైన్‍ క్హుతోర్హవానూ తూమే దేక్చు” కరి బోల్యు. ");
INSERT INTO vgr_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","తేదెస్‍ పరలోకంమతూ గ్హణు దేవదూతల్‍బి దెఖైయిన్‍ యో దేవదూతతి మలీన్‍ దేవ్నా స్తుతి స్తుహూయిన్‍ ఆమ్‍ బోల్యు. ");
INSERT INTO vgr_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“మహోన్నత జోగొమా ఛాతే దేవ్‍నా మహిమబి, ఇనా ఇష్టంహుయుతె జనంనా జమీన్‍ పర్‍ సమాధాన్‍ హూను” కరి దేవ్‍నా స్తోత్రం కర్యు. ");
INSERT INTO vgr_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","తేదే దేవదూతల్‍ యూవనా మ్హేంధిన్‍ పరలోకంమా చల్‍జావదీన్‍, భోకఢచరవాళు “జరుగ్యుతే వాత్‍నా అప్నా ప్రభు బోల్యొ. బేత్లెహేము జైన్‍ యినదేఖిన్‍ ఆయే” కరి బోల్లీదూ. ");
INSERT INTO vgr_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","యూవునే జల్దీస్‍ ఏజ్గాతూ జైన్‍ మరీయనా యోసేపునా, అజు తొట్టీమా ఖుఢయ్‍రాక్యూతే అఢ్డాని లఢక్వానా దేక్యూ. ");
INSERT INTO vgr_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","యో లఢక్వానా దేఖీన్‍, ఇన గురించిన్‍ యూవ్నేతి బోలాయుతే వాతేనా అద్మీక్హారవ్‍తీ బోల్యు. ");
INSERT INTO vgr_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","యో భోకఢ ఛరవవాళు బోల్యుతే వాతేనా, క్హామ్జూతే అక్కుజణు హష్యం హూయుగు. ");
INSERT INTO vgr_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","పన్కి మరియ ఆ క్హారూ వాతే దీల్‍మా జతన్‍తీ లఫళ్ళిన్‍ యో వాతేనా గురించిన్‍ సోస్తీర్హహీ. ");
INSERT INTO vgr_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","బోకఢచరవవాళు యూవునే ష్యాత్‍ ఖామ్జూకీ, ష్యాత్‍ దేక్యుకీ యోహఃరు దూత బోల్యుతీమ్మస్‍ హూయుకరీన్‍ యోవాత్‍నా గురించిన్‍ వాతే బోల్‍లేతూ హూయిన్‍ దేవ్‍నా స్తూతిస్తు హూయిన్‍, యిన మహిమకర్తు హూయిన్‍ పాచుఫరీన్‍ చల్యుగు. ");
INSERT INTO vgr_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","యో ఛోగరనా ఆట్‍మనూ ధన్నే సున్నతి కరవాను ధన్‍ ఆయుతేదె, బేజీని హూవన ఆగడీస్‍ దేవదూత యేసు కరి నామ్‍ మ్హేంధో కరి బోల్యుతిమ్మస్‍ యోస్‍ నామ్‍ మ్హేందు. ");
INSERT INTO vgr_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","మోషే ధర్మషాస్త్రంమా కిమ్ఛాకీ ఇం మరయబి యోసేపు యూవునే పరీసుద్ద హూవనూ ధన్‍ హూయిజావదీన్‍, యూవునే యో ఛోగర్వాన ప్రభునా ఆర్పించనటేకె యోరుషలేమ్‍నా గయు. ");
INSERT INTO vgr_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","ప్రభునూ ధర్మషాస్త్రంమా లీఖ్యుతిం. సాత్‍కాతో ఫైలేటు ఛోగరనా ప్రభువ్నా పవిత్రుకరి బోల్ను. ");
INSERT INTO vgr_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","అజు ప్రభునూ ధర్మషాస్త్రంమా బోల్యుతీమ్‍; ఇవ్నే బే పర్యావొనాహో, బే హీలోయ్‍నాహో, జైన్‍ బలి దేనూకరీ ఇవ్నే ఇనా యెరూషలేమ్‍ బులైలిగయు. ");
INSERT INTO vgr_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","అజ్గ యేరూషలేంమా సుమాయోను కరి ఏక్‍ అధ్మీ ర్హాస్‍. యో భక్తీతీ నీతి మంతతి భక్తీమా భరైన్‍, ఇష్రాయేల్‍నా దేవ్‍ కేదె బఛ్చావుషే కరి కావల్‍ కాసీలీన్‍ ర్హతుథూ. ఇనావుఫర్‍ పవిత్రాత్మ థూ. ");
INSERT INTO vgr_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","యో ప్రభు హూయోతే క్రీస్తునా ధేఖాతోడీ మర్‍సేకోయిని కరి పవిత్రాత్మ యిన మాలంకరాయో. ");
INSERT INTO vgr_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","పవిత్రాత్మ యినా ఉపర్‍ ఆవమా యో మందిరంమా గయో. మరియబి, యోసేపు యోస్‍ సమయంమా ధర్మషాస్త్రం బోల్యుతిం కరనాటేకె లఢక్వానా బులాలిన్‍ ఎజ్గా ఆయూ. ");
INSERT INTO vgr_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","సుమెయోను యో లఢక్వానా ధేఖీన్‍, ఇన హతేతీ పళ్లీన్‍ దేవ్‍నా ఆంబోలిన్‍ స్తుతించనా సురుకర్యో ");
INSERT INTO vgr_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","ప్రభూ తారు వాత్‍ ప్రకార్‍ తార సేవ కరుకరూతే మన షాంతీతి జావదేంగ్రస్‍. ");
INSERT INTO vgr_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","ష్యానకతో తూ హమారటేకె బోలిమోకల్యోతే రక్చణనా మార ఢోలాతీ ధేక్యో. ");
INSERT INTO vgr_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","తూ యిన లోకంమా ఛాతే అన్యుల్‍నా అక్కవ్‍నా హాఃమే యెంచ్యో. ");
INSERT INTO vgr_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","అన్యుల్‍నా ఏక్‍ ఉజళునుతరబి, అజు తారు ఇష్రాయేల్‍నా మహిమనితర. ");
INSERT INTO vgr_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","యేసునూ ఆయా భా సుమెయోన్‍ బోల్యోతే వాత్‍నా ఖామ్జిన్‍ ఆష్చర్యపఢు. ");
INSERT INTO vgr_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","యినబాద్‍మా యూవునా సుమాయోను ఆషీర్వదించిన్‍ యేసుని ఆయాతీ ఆంబోల్యో, క్హారవ్‍ను దీల్‍నూ సోచ్‍ భాదర్‍ ఫడాఖార్‍కు “ఆ లఢక్వానా టేకె కేత్రూకీ ఇష్రాయేలిలు గణు అభివ్రుద్ది హూసే అజు కెత్రూకిజణు పఢీజావనా కారణ్‍నా ఆలఢుకు ఏక్‍ చిహ్నం. ");
INSERT INTO vgr_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","బుజు ఏక్‍ ఛరీ తారు దిల్మామా టోఛవ్‍సే.” ");
INSERT INTO vgr_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","యో మందిరంమా, “అన్న” కరి ఏక్ ప్రవక్తీ తీ. యో పనూయేలుని ఛోరీ, ఆషేరు జాత్‍ని. య్హా హూయిన్‍ ఖాత్‍ వరఖ్‍ఃమా భావూరీ కోయిన్‍తిమ్ హూయిగి. ");
INSERT INTO vgr_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","తెదె యిన ఛారుఫర్‍ ఛారీఖ్‍ః వరఖ్‍ః. యో మందిరం నా మ్హెందీన్‍ భాధర్‍ జైబి కోయిని. కేదెబి ప్రార్దన, ఉపాస్‍ కర్తీ ర్హతీతి. ");
INSERT INTO vgr_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","మరియబి, యోసేపు ఏజ్గా రావానూటేమ్పర్‍ యో అవ్‍ణకన ఆయిన్‍, దేవ్‍నా మహిమ కరీన్‍, ఛుట్‍కార్‍ హూవనాటేకె దేక్హూకరతే యూవనా ఖ్హారనా, యో లఢక్వానూ వాతే బోలి. ");
INSERT INTO vgr_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","యత్రమా మరియ, యేసేపు ప్రభు ధర్మషాస్త్రం బోలాతిం కరీన్‍ హూయిజావదీన్‍, యూవ్నే యూవ్నూ గలీలయమానూ నజరేతునా గామ్నా ఫాచు ఫరీన్‍ చలిగయు. ");
INSERT INTO vgr_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","యో ఛొగ్రు మోటొహుయిన్‍ అఖ్కాల్తీ, కువ్వాత్ లేతొర్హయో, దేవ్ను కృప ఇనఫర్‍ ర్హయూ. ");
INSERT INTO vgr_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","యూవునే పస్కాపండగనా ఇన ఆయ, భా హార్‍ వరహ్‍ఃనా యెరూషలేమ్‍నా జాతుర్హాస్‍. ");
INSERT INTO vgr_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","యినటేకె యూవునే యేసునా బ్హార వరఖ్మా యో పండగ కరానా ఖాజె అధాత్‍ ప్రకార్‍ యెరూషలేమ్‍నా గయు. ");
INSERT INTO vgr_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","ఏజ్గా పండగ హూయిజావదిన్‍ యూవునే పాచు ఫరీన్‍ యూవునూ గామ్‍మా ఛల్‍జౌంగ్రతో, యేసు యెరూషలెమా ఏజ్గాస్‍ రైగో. కానీ యో వాత్‍ యిని ఆయా భానా మాలంకోహూయిని. ");
INSERT INTO vgr_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","యూవునే అప్నా అద్మీయే మాస్‍ ఛాకరీ లహిజైన్‍ ఏక్‍ ధన్‍ని పయనంతోడీ ఛలీగూ. యూవనమా కోయిని కరి మాలంహూవమా, యూవునూ అద్మీయేమా, దోస్తుల్‍మా ఢూండు. ");
INSERT INTO vgr_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","యూవ్నాకనాబీ నాదేఖావమా అజు పాచూ ఫరీన్‍ యెరూషలేమ్‍నా గయు. ");
INSERT INTO vgr_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","తీన్‍ రోజ్‍ ఢూంఢమా యో మందిర్‍మా దేఖాయో. యో ఏజ్గా దేవ్‍నూ వాతే బోల్‍దేంగ్రతే యూవనా ఇచ్మా భేసీన్‍ యూవ్‍ని వాతే ఖామ్జూతోహూయిన్‍, యూవ్నా పాచు ప్రష్నల్‍ పుఛావ్‍తూహూయిన్‍ థో. ");
INSERT INTO vgr_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","యిని వాతేనా క్హామ్జీన్‍ ఇనూ ఛాతుర్నా దేఖిన్‍, అక్కుజనూ అష్చర్యం హూయుగు. ");
INSERT INTO vgr_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","ఇని ఆయా భా యిన దేఖిన్‍ గణు హాషంహూయిన్‍, ఇని ఆయా ఛియ్యా హామ్నా ఆం ష్యాన కర్యో లా? మేబి, తార భా దిగుల్‍ పడీన్‍ ఖారీ జోగో ఢూండ్యా! కరి బోలమా, ");
INSERT INTO vgr_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","యో “తూమే షాన మన ఢూండుకరాస్‍. మే మారు భాను ఘేర్మా ర్హనూ కరి తూమ్‍నా మాలంకోయిన్‍నా?” కరి యూవ్నేతి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","యో బోల్యొతే వాతే యువ్నా అర్థమ్ కోహూయిని. ");
INSERT INTO vgr_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","ఇన బాద్‍మా యో యిని ఆయా భాన కేడె నజరేతునా ఛల్‍జైయిన్‍ యూవ్నా లోబడి ర్హయో. కాని యిని ఆయా జరుగుకరతే కరు దీల్‍మా గల్లీన్‍ సోస్తిరహీ. ");
INSERT INTO vgr_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","యేసు అఖ్కల్‍మా, ఉంబర్‍మా, దేవ్ను కృపమా, అద్మీయేనూ కృపమా బడ్తొహుయీన్‍ మోటొహూయో. ");
INSERT INTO vgr_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","తిబెరి కైసరు రాజ్యంనా ఏలుకరతే ఫంధ్రానూ వరఖ్ మా యూదయ దేక్హనా పోంతి పిలాతు అధిపతి, గలీలయ దేహ్క్ నా హేరోదు సామంతరాజో, ఇతూరయ త్రకోనియ దేహ్కేవ్నా ఇనో భైయ్‍ హూయొతే ఫిలిప్పు సామంతరాజో, అబిలేనె దేహ్క్ లుసానియా అధిపతి. ");
INSERT INTO vgr_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","అన్నబి కయప ప్రధాన యాజకుల్‍నితర ర్హయూతో ధన్‍మా జమ్గాళ్‍మా ఛాతే ‍జెకర్యానూ ఛీయ్యో యోహను కనా దేవ్‍ని వాక్యం ఆయు. ");
INSERT INTO vgr_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","యిన బాద్‍మా యో యొర్దాను నధ్దీను అష్పిష్ ఛాతే గామ్‍ అక్కు ఫరీన్‍ “పాప్‍ కరను బేందేవో, దీల్‍ బద్లాయ్‌లీన్‍ బాప్తిస్మమ్‌ లేనూ తెదె తుమ్నా క్చామాకర్సే” కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","ఆ వాతేనా యెషయా ప్రవక్తాహుయూతె యెషయ పుస్తకంమా అమ్‍ లిఖ్కాయ్‍రూస్‍. “ప్రభును మారగ్‍ సిద్దంకరో, యినీ వాట్‍నా హఃఢక్‍ కరో, ");
INSERT INTO vgr_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","ఖాడ అక్కు మూఛినాఖో, ప్రతేక్‍ ఫాడ్బి ఠగర్‍ అక్కు సఫా హూయిజాసె; బింగూ వాట్‍ అక్కు హూఃదు కరో, ఖర్‍దొమ్కుడూ వాట్‍ సఫా కరో. ");
INSERT INTO vgr_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","అద్మియే హాఃరు దేవ్‍ దీసేతె బఛ్చాడ్సెతె యువ్నా ఢోలతీ దేక్సె” కరి జంగాళ్‍మా కైఖార్ మ్హేందుకరతే యేక్ను ఆవాజ్‍. ఇమ్‍ ప్రవక్త హుయోతే యెషయా వాక్యంనూ గ్రంథంమా లిఖైర్యుతిమ్‍ యో ఇమ్మస్‍ హూయు. ");
INSERT INTO vgr_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","ఇనా హాతే బాప్తిసమ్ లేవనటేకె గుంభల్తి భరైన్‍ ఆయుతే యూవ్నా మ్హణీ ధేఖిన్‍, “హాఃప్నా లఢ్కా, ఆవాజాసేతే చంఢాల్‍మతూ బచ్చావనటేకె తుమ్న అక్కల్‍ బోల్యొతె కోన్‍? ");
INSERT INTO vgr_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","అంను కామ్‍ కరోకి ‘అబ్రాహామ్ను మారో భా’ కరి భడాయి బోల్యాతొ ఫైధో కోయిని. ఆ ఫాత్రోమాతుబీ అబ్రాహమ్‍నూ లఢ్కావ్‍నా దేవ్‍నే భణావ్‍సే, కరి తూమారెతి బోలుకరూస్‍. ");
INSERT INTO vgr_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","హంకేస్ కురాఢి జాఢను పేధడ్ ఫర్ మ్హేంధాయ్‍రూస్‍, ఇనటేకె ఫండ దేకోయిన్తే ఝాఢనా ఖత్రాయిన్‍ ఆగ్మా నఖావ్సే” కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","ఇనఖాజే అద్మీయే ఇమ్‍హూసేతో హమే ష్యాత్‍ కర్‍నూ? కరి ఇనా పుఛాయూ. ");
INSERT INTO vgr_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","యోహాన్‍, “బే కుడ్తా ర్హవాళు అస్సల్‍ కుడ్తాతాబి కొయింతే యఇన ఏక్‍ దేనూ. ధాన్‍ ర్హవాళుబి ఇమ్మస్‍ కర్నూ” కరి యూవ్నేతి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","సుంకర్లుబి బాప్తిస్మమ్‍ లేవనాటేకె ఆయిన్‍ “బోధకుడ్‍ హమే ష్యాత్‍ కర్‍నూ” కరి పుఛవమా, ");
INSERT INTO vgr_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","యో కేత్రా లేనూ కరి ఛాకీ ఇనేతి గణు నకో లీస్యు కరి యో యూవ్నేతీ బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","సైనికుల్‍బి ఆయిన్‍, హమే ష్యాత్‍ కర్‍నూ కరి యిన పుఛాయ. ఇనఖాజే యో ఆం బోల్యొ, “కీనాబి బాధ నకో దీన్‍, కీనాఫర్‍బి ఇంజామ్‍ నా నాఖీన్‍ తూమారు షమ్‍ల్మంతీస్‍ ఖుషితి ర్హవో” కరి యూవ్నేతి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","జనాల్‍ ఏదుర్‍ దేక్తూహుయిన్‍, ఆ క్రీస్తుస్‍ హుసెకరి ర్హైజీన్‍ దిల్‍మా సోస్తు రంగర్తో, ");
INSERT INTO vgr_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","తేదె యోహాన్‍ యూవ్నా ఆంబోల్యొ “మే తూమ్‍నా పాణీమా బాప్తిస్మమ్‍ దెంక్రూస్‍, పన్కి మారేతి షక్తివాళో ఏక్‍జణో ఆవ్‍మ్కరాస్‍ యిని చేప్పల్ కాఢనాబి అర్హత మన కోయిని యో తూమ్‍నా పవిత్రాత్మతీ, ఆగ్‍మా బాప్తిస్మమ్‍ దీసే.” ");
INSERT INTO vgr_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","ఇను హుఃబ్డు ఇనా హాత్మ ధర్లీన్‍, యీనేతీ దాణవ్‍నా అషల్ కరీన్‍, అషల్ ఘౌను బానల్‍మా రాఖిన్‍, పొట్టునా ఉజావకొయింతె ఆగ్మ నాఖిన్‍ భళ్లాకి నాగ్దిసే. ");
INSERT INTO vgr_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","యో బుజున్‍బి యూవ్నా ఝథావ్‍తోహుయిన్‍, యూవ్నా కేత్రూకీ క్రీస్తును అచ్చూ వార్త ప్రచార్‍ కర్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","సామంతరాజోహుయోతే హేరోదు కర్యోతే కేత్రుకీ దుష్కార్యముల్‍నా గూర్చి, యిని భైని భావణ్‍ హేరోదియనూ గూర్చి, యినటేకె హేరోదునా యోహాన్‍ గుర్‍కావమా, ");
INSERT INTO vgr_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","యో ఖారు బైస్‍ కోహుయినితిమ్‍ యోహన్‍నాబి ధరీన్‍ కఛేరిమా గ్హల్‍దిదూ. ");
INSERT INTO vgr_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","అద్మీయే బాప్తిస్మమ్‍ లీధాతేదె యేసు బి ఆయిన్‍ బాప్తిస్మమ్‍ లీన్‍ ప్రార్దన కరుకరతో పరలోకం కోలైగూ. ");
INSERT INTO vgr_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","పవిత్రాత్మ ఏక్ ఫర్యావోనూ రూపం మా ఆయిన్‍ యినఫర్‍ ఉత్రి ఆయు. తేదె “తూ మారో లాఢ్‍నో ఛియ్యో, మే తూనా ప్యార్‍ కరూకరుస్‍. తార కనా మే గణూ ఖ్హూషీ హూంగ్రూస్‍” కరి ఆకాష్‍మతూ ఏక్ ఆవాజ్ ఆయూ. ");
INSERT INTO vgr_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","యేసు దేవ్‍ని కామ్ కరను సూరు కర్యో తేదె యిన భరోభ్బర్‍ ఢోఢీఖ్ వరఖ్నో థో. యో యోసేపునో ఛీయ్యో బోల్యొ. యోసేపు హేలీనో ఛియ్యో, ");
INSERT INTO vgr_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","హేలీ మత్తతునో ఛియ్యో, మత్తతు లేవినో ఛియ్యో. లేవి మేల్కీనో ఛియ్యో. మేల్కీ యన్ననో ఛియ్యో. యన్న యోసేపునో ఛియ్యో. ");
INSERT INTO vgr_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","యోసేపు మత్తతీయనో ఛియ్యో, మత్తతీయ ఆమోసునో ఛియ్యో. ఆమోసు నాహోమునో‌ ఛియ్యో. నాహోమ్‍ ఎస్లినో ఛియ్యో. ఎస్లి నగ్గయినో ఛియ్యో. ");
INSERT INTO vgr_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","నగ్గయి మయతునో ఛియ్యో. మయతు మత్తతీయనో ఛియ్యో. మత్తతీయ సిమియనో ఛియ్యో. సిమియ యోసెఖునో ఛియ్యో. యోసెఖు యోదానో ఛియ్యో. ");
INSERT INTO vgr_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","యోదా యోహాన్ననో ఛియ్యో. యోహన్న రేసానో ఛియ్యో. రేసా జేరుబ్బాబేలునో ఛియ్యో. జేరుబ్బాబేల్‍ షయల్తీయేలునో ఛియ్యో, షయల్తీయేల్‍ నేరినో ఛియ్యో, ");
INSERT INTO vgr_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","నేరి మెల్కీనో ఛియ్యో, మెల్కీ అద్దినో ఛియ్యో, అద్ది కోసామునో ఛియ్యో, కోసాము ఎల్మదామునో ఛియ్యో, ఎల్మదాము ఏరునోఛియ్యో. ");
INSERT INTO vgr_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","ఏరు యెహోషువనో ఛియ్యో. యెహోషువ ఎలీయెజెర్‍నో ఛియ్యో. ఎలీయాజెరు యోరీమునో ఛియ్యో. యోరీము మత్తతునో ఛియ్యో. మత్తతు లేవినో ఛియ్యో. ");
INSERT INTO vgr_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","లేవి షిమ్యోనునో ఛియ్యో. షిమ్యోను యూదనా ఛియ్యో, యూదా యోసేపునో ఛియ్యో. యోసేపు యోనామునో ఛియ్యో, యోనాము ఎల్యాకీమునో ఛియ్యో. ");
INSERT INTO vgr_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","ఎల్యాకీము మెలెయానో ఛియ్యో. మెలెయా మెన్నాను ఛియ్యో. మెన్నా మత్తతానో ఛియ్యో. మత్తతా నాతానునో ఛియ్యో. నాతాను దావీదునో ఛియ్యో. ");
INSERT INTO vgr_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","దావీదు యెష్షయినో ఛియ్యో. యెష్షయి ఓబేదునో ఛియ్యో. ఓబేదు బోయాజునో ఛియ్యో. బోయాజు సల్మానునో ఛియ్యో. సల్మాను నయస్సోనునో ఛియ్యో, ");
INSERT INTO vgr_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","నయస్సోను అమ్మినాదాబ్‍ను ఛియ్యో. అమ్మినాదాద్‍ అరామునో ఛియ్యో. అరాము ఎస్రోమునో ఛియ్యో. ఎస్రోము పెరెసునోఛియ్యో. పెరెసు యూదనా ఛియ్యో. ");
INSERT INTO vgr_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","యూదా యాకోబునో ఛియ్యో. యాకోబు ఇస్సాకునో ఛియ్యో. ఇస్సాకు అబ్రాహామ్‍నో ఛియ్యో. అబ్రాహామ్ను తెరహునో ఛియ్యో, తెరహు నాహోరునో ఛియ్యో, ");
INSERT INTO vgr_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","నాహోరు సెరూగునోఛియ్యో, సెరూగు రయూనో ఛియ్యో, రయూ పెలెగునో ఛియ్యో, పెలెగు హెబెరునోఛియ్యో, హెబెరు షేలహునో ఛియ్యో, ");
INSERT INTO vgr_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","షేలహు కేయినానునో ఛియ్యో, కేయినాను అర్పక్చదునో ఛియ్యో, అర్పక్చదు షేమునో ఛియ్యో, షేము నోవహునో ఛియ్యో, నోవహు లెమెకునో ఛియ్యో, ");
INSERT INTO vgr_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","లెమెకు మెతుషేలనో ఛియ్యో, మెతుషేల హనోకునో ఛియ్యో, హనోకు యెరెదునో ఛియ్యో, యెరెదు మహలలేలునో ఛియ్యో, మహలలేలు కేయినానునో ఛియ్యో, ");
INSERT INTO vgr_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","కేయినాను ఎనోషునో ఛియ్యో, ఎనోషు షేతునో ఛియ్యో, షేతు ఆదామ్నో ఛియ్యో, ఆదామ్‍ దేవ్‍నో ఛియ్యో. ");
INSERT INTO vgr_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","యేసు పరీసుద్దాత్మతీ భరైన్‍ యొర్దాను నద్దీనూ ఫరీన్‍ ఆయిన్‍, ఛాళీహ్‌ః ధన్‍తోఢీ దేవ్‍నీ ఆత్మమ ఝాడిమా జోగోమా ఛాల్యయో. ");
INSERT INTO vgr_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","తేదె యో ఛాళీఖ్ ధన్‍ ఉపాస్‍ హూయిజావదీన్‍, యిన భుక్‍లగనిక్‍ల్యు. యో వోఖాత్‍మా సైతాన్‍ ఆయిన్‍ యిన చొధీంచొ. ");
INSERT INTO vgr_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","సైతాన్‍ యినేతి, “తూ దేవ్నొ ఛియ్యోహుయోతోస ఆ పత్రానా రోటొ హూయిజాకరీ బోల్‍” కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","ఇనక్హాజే యేసు ఇనేతి, అద్మి జీవ్నుకతో రోటొతీస్‍ కాహే, దేవ్ని మోఢమతూ ఆవతె హర్యేక్‍ వాక్యంతీబి జీవ్సెకరి లేఖనాల్మా లిఖ్కైరూస్కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","ఇనబాద్‍మా యో సైతాన్ యెరూషలేమ్‍నా బులైలీన్‍ జైన్‍ ఏక్‍ క్చాణంమా ఆ ములక్‍ను రాజ్యంహాఃరు ఇన దెఖ్కాడ్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","యేసుతీ, “ఆ అధికార్‍ క్హారూ అజు ఆ రాజ్యల్ను మహిమబి తునా దీస్‍; యో హాఃరు మన దేవాయ్‍రూస్‍, మే యో కీనా దేనూ కరి ఛాకీ ఇనాస్‍ దీస్‍. ");
INSERT INTO vgr_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","ఇనటేకె తూ మన ఖాలమ్‍ కర్యోతొ ఖారు తారు హుయిజాసే” కరి ఇనేతి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","ఇనటేకె యేసు, తారొ దేవ్‍ హూయిరోతే ప్రభునస్‍ హఃలామ్‍ కర్‍నూ కరి ధర్మసాత్రంమా లిఖ్కాయ్‍రూస్‍ కరి యిన ఫాసు పరీన్‍ బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","ఇనబాద్‍మా యోసైతాన్‍ ఇన యెరూషలేమ్‍నా బులైలీన్‍‍, మందీర్నుచోఛ్నా ఉఫ్పర్ ఇనా ఉబ్బారి రాఖిన్, “తూ దేవ్నొ ఛియ్యో హుయ్యోతొ ఫహాడ్‍పర్తూ హేట్‍కూద్‍. ");
INSERT INTO vgr_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","ధర్మసాత్రంమా బోల్యుతిమ్‍ తునా బఛ్చావనా ఇనె తారటేకె ఇను దూతల్నా ఆజ్ఞదిసె. ");
INSERT INTO vgr_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","తెద తార గోఢన యేఢినాబీ పత్రొ లగ్చెకొయినితిమ్ ఇవ్నె తునా హాతేతి పల్లిసేకరి ధర్మసాత్రంమా లిఖ్కాయ్‍రూస్‍ కరి” ఇనేతి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","ఇనటేకె యేసు “తారొ దేవ్‍ హూయోతే ప్రభునా పరీక్చా నాకర్నూకరీ బోలాయ్‍రూస్‍ కరి ఫాచూ పరీన్‍ బోల్యొ.” ");
INSERT INTO vgr_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","తేదె యో సైతాన్‍ షుధించనూ హూయిజవాదిన్‍ థోడా వహాఃత్‍తోడి యేసునా మ్హేంధీన్‍ ఛలెగొ. ఇవ్నె తునా హాతేతి పల్లిసేకరి ");
INSERT INTO vgr_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","తేదె యేసు పవిత్రాత్మనూ బలంతి ఫాచు గలీలయమా ఆయో. యినలిన్‍ వార్త అష్పీష్ను గామ్‍నా అద్మీయే ఖారనా ఫైలాయుగయు. ");
INSERT INTO vgr_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","యో ఖారహాతే ఘావతన లీన్‍, యూవ్నూ న్యావ్‍నుజొగొమా ప్రచార్‍ కర్తొ హుయిన్‍ ఆయో. ");
INSERT INTO vgr_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","యినబాద్‍మా యో మోటో హూయోతే గామ్‍ నజరేతునా ఆయో. ఆరామ్‍ నూ ధన్నే వాఢీకీ హూయుతిమ్ యో ధన్నేబీ సమాజమందిరంనా జైన్‍, ఫడనాటేకె బిరాయోతో, ");
INSERT INTO vgr_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","ప్రవక్తనూ యెషయా గ్రంథంనా యినా హత్‍మా దేవాయు, యో గ్రంథంనా పఢమా యో లిఖ్కాయిరూతె జొగొ దేఖిన్. ");
INSERT INTO vgr_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“ప్రభునూ ఆత్మ మార ఉఫర్‍ ఛా, గరీబ్‍నా యినీ వాతే బోల్‍దేవనాటేకె యో మన ఎన్నీలిదో. బందీహూయిరూతే యువ్నా ముక్తీనూ వాతే బోల్‍ధా కరి, కాణవ్‍నా ఢోలా ఆవ్‍నూ కరి, హింసింపబడుకరతే యువ్నా, ఛుట్కార్ కరనాటేకె మన బోలీమోకల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","ప్రభు యో దయ దెఖ్కాడనూ వరహ్‍ః, ప్రచార్‍ కరనటేకె మన బోలీమోకల్‍ రాక్యోస్‍.” ");
INSERT INTO vgr_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","యినబాద్‍మా యేసు గ్రంధం ముచినాకీన్‍ లాయి దీదూతే యిన దీనక్‍దీన్‍ ఆయిన్‍ బేసీగో. ఏజ్గానూ అద్మిహాఃరు జణు యినాస్‍ టర్కీన్‍ దేక్తూర్హయు. ");
INSERT INTO vgr_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","తేదె యో యూవ్నేతి, ఆజ్‍ తూమే ఖామ్జీ ర్హయాతే ఆ వాక్యం ఖాఛ్చీహూయు కరి బోలానిక్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","తేదె ఖారు జణు యిన గుర్చీ సాక్చ్యం బోల్తుహుయిన్‍, ఇనా మ్హోఢాతి ఆయుతే వాతేనా గోర్నీ వాతేనా హాషంహుయిన్‍, “ఆ యోసేపునో ఛియ్యో కాహేనా?” కరి బోల్లేంగ్రతో, ");
INSERT INTO vgr_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","యేసు యూవునేతీ ఆం బోల్యొ రోగ్‍నా అసేల్‍ కరవాళో! తారు తూస్‍ అసేల్‍ కర్‍లా! కరి ఉపామనం బోలిన్‍, కపెర్నహూముమా కర్యోతే అధ్బుతాల్‍ హమే ఖామ్జ్యాకీ, యో కామ్‍ తారు సోంత గామ్‍మాబి కర్‍ కరి తూమే మారేతి కఛ్చితంగా బోల్‍స్యు కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","బుజు యో ఆ వాత్‍ ఖ్హాఛ్చీ బోలుకరుస్‍, క్వయూ ప్రవక్తనబి యినూ సోంత గామ్‍నూ అద్మీయే ఒప్పకోయినీ. ");
INSERT INTO vgr_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","ఏలీయా ప్రవక్తనూ ధన్‍మా తీన్‍ వరఖ్ ఛో మైహిన వాజూళు ముచజైన్‍ యో దేఖ్ అఖ్హామా మోటు ఖాళ్‍ ఆయు తేదె ఇష్రాయేల్‍మా కేత్రుకీ విధవరాల్‍ భాయికా ర్హయుతోబి, ");
INSERT INTO vgr_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","సీదోనుమా సారెపతు గామ్‍మా ఛాతే ఏక్‍ విధవరాల్‍ భాయికొ కనాస్‍ తప్ప, పన్కీ కీనా కనాబి కో బోలీమోక్‍లాగయోని. ");
INSERT INTO vgr_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","బుజు ప్రవక్త హూయోతె ఏలీషానూ ధన్‍మాబి ఇష్రాయేల్‍మా కేత్రుకీ ఖ్హోఢ్‍లగ్యూహూయు అద్మీయే రైతోబి, సిరియ దేహ్క్ ను నయమాన్‍ పన్కి బుజు కోన్‍బి ఖుదు హుయు కోయిని కరి తూమారేతి కఛ్చితంగా బోలుకరూస్‍. ");
INSERT INTO vgr_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","సమాజమందింరంమా ఛాతే ఖారు ఆ వాత్‍ ఖామ్జీన్‍, ఛండాల్తీ హుయీన్‍; ");
INSERT INTO vgr_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","యూవునే ఉటీన్‍ యిన యో ఖాయార్‍మతూ నఖాడ్‍దీన్‍, ఇనా హేట్‍ పట్‍కై దేనూ కరి, యూవ్ను గామ్‍ ఫాఢ్‍నూ కనారీనా భంధైర్యూతే ఫాడ్నూకనారీతోడి ఇనా బులాలీన్‍ గయూ. ");
INSERT INTO vgr_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","పన్కి యేసు యూవనామతూ నీక్లీన్‍ ఇని వాట్‍ యో దూర్‍ ఛలేగో. ");
INSERT INTO vgr_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","తేదె యో ఎజ్గాతో గలీలయమా ఛాతే కపెర్నహూమ్‍కరి ఎక్‍ ఖాయార్నా ఆయిన్‍, ఆరామ్‍నూ ధన్నే యూవ్నా బోధించనూ సురుకర్యో. ");
INSERT INTO vgr_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","ఇని వాక్యం అధికారంతి బోలామా హమ్జవాళు హాఃరు అష్యంహుయుగు. ");
INSERT INTO vgr_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","యో సమాజమందిర్‍మా దుష్టాత్‍మా ధర్యోహూయు ఏక్‍ అద్మి థూ, యో గ్హాట్‍తీ చిక్రుయు. ");
INSERT INTO vgr_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","తేదె యో “ఓ నజరేయుడ్‍నో యేసు! హమారేతీ తునా ష్యే? హమ్‍నా ఉజ్జఢ్‍ కరనా ఆయోనా? తూ కోన్‍కీ హమ్‍నా మాలం. తూ దేవ్‍నో పరిసుధ్ధుడ్‍” కరి ఛిక్రాణ్‍ మ్హేందూ. ");
INSERT INTO vgr_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","ఇనఖాజే యేసు, “తూ గఛ్చుఫ్‍ ర్హా, ఆనా మ్హేంధిన్‍ భాధర్‍ ఆవ్‍” ఇనా గూర్‍క్హావమా, తేదె యో ధర్యోహూయు అద్మినా హేట్‍ ఫట్‍కాయిన్‍, ష్యాత్‍బీ నాకర్‍నూ తీమ్ యిన మ్హేంధీన్‍ భాధర్‍ ఛలీగు. ");
INSERT INTO vgr_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","ఇనఖాజే ఏజ్గానూ ఖారు ఆష్చర్యం హూయిన్‍, ఆ కీమ్‍నూ వాత్‍? ఆ అధికార్‍తి బలంతి దుష్టాత్మా ఆజ్ఞా దేవుస్‍ కరా యో భార్‍ ఛల్‍జౌంగ్రస్‍ కరి యూవ్నే ఏక్నా ఏక్‍ బోల్లీదు. ");
INSERT INTO vgr_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","ఎత్రమా అష్పీష్ను గామ్‍మా ర్హవ్వళు ఖారనా ఆ వాతే ఫైలాయ్‍గయు. ");
INSERT INTO vgr_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","తేదె యో పార్థనా జొగో కన్‍తూ వుటీన్‍, సీమోన్‍నూ ఘర్‍కనా గయో. సీమోన్‍నీ అత్తేనా గణు తావ్‍తి ర్హవమా తేదె యో వాత్‍ యేసు కనా మనవి కర్యు. ");
INSERT INTO vgr_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","యో యినసేడె భిరిన్‍, తావ్‍తి యిన మ్హేందీన్‍ నీఖ్కాళ్‍కరీ గుర్ఖావమా యో తావ్‍ యిన మ్హేందీదూ; యగ్గిస్‍ యో ఉటీన్‍ అక్కావ్‍నా ఉపచార్‍ కరి. ");
INSERT INTO vgr_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","హాఃజ్‍ హూంగ్రతే వోఖాత్‍మా కేత్రుకీ రొగాఢివాలనా బాధపడుకరాతే రోగ్‍వాళనా, జనాల్‍ యూవ్నా హాఃరవ్‍నా ఇనకనా బులాయిలీన్ ఆయు; తేదె యో హార్‍ ఏక్నాఫర్‍ హత్‍ మ్హేంధీన్‍ యూవ్నా హాఃరనా హూఃదు కర్యో. ");
INSERT INTO vgr_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","ఏత్రెస్‍ కాహేతిం అపవిత్రాత్మల్‍ “తూ దేవ్‍నో ఛీయ్యో” కరి ఘట్‍ ఛికర్‍తూహూయిన్‍ కేత్రుకీ అద్మీయేనా మ్హేంధిన్‍ భార్‍ ఛలీగు. యో క్రీస్తు కరి యూవ్నా మాలంహూయిరూస్‍ ఇనటేకె యో యూవ్నా గుర్‍ఖైన్‍ వాతే బోలకోదిదోని. ");
INSERT INTO vgr_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","వ్యాణుహుయు తేదె యేసు నిఖీన్‍ జంగల్‍నుజొగొమా గయో. జనాభో హాఃరు యిన దూండ్తూ హుయిన్‍ యో ఛాతే జొగో ఆయిన్‍, హమ్నా మ్హేంధిన్‍ నాజానుతిమ్ భిరవమా, ");
INSERT INTO vgr_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","కానీ యేసు, “దేవ్‍నూ రాజ్యంను సువార్తనా అలాధ ఖాయారేవ్‍మాబి ప్రచార్‍ కర్నూ. ఇనటేకెస్‍ మే దేవ్నాహాతే బోలీమోక్‍లాయిరోస్‍” కరి యూవ్నేతి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","ఇనబాద్‍మా యో యూదయా న్యావ్‍నుజొగొమా ప్రచార్‍ కర్తోర్హయో. ");
INSERT INTO vgr_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","ఏక్‍ ధన్నే యేసు గెన్నేసరేతునా పాణీనూ కీనాల్‍నా సేడే యేసు భిరోతో, అద్మీయే హాఃరు యినీ వాతే ఖామ్జన టేకె ఏక్‍నా ఏక్‍ ధకల్‍లేతూ హూయిన్‍ యినా ఉఫర్‍ పడ్తూర్హయు. ");
INSERT INTO vgr_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","తేదె యేసు ధర్యావ్‍నా సేడె భే డోంగనా దేక్యో. మాస్లా ధర్హవళు యినమాతు ఉత్రీన్‍ యూవునూ ఝాళీ దొమ్కర్తూ. ");
INSERT INTO vgr_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","ఇనె ఇవ్నకనా జైన్‍, సీమోన్‍కరి బోలతె యిను ఢోంగమా ఛడీన్‍ కనారీ కన్‍తూ జరమై ధకల్‍ కరి బోలీన్‍ ఇనామా బేసీన్‍, జనాల్నాబోధించ్యో. ");
INSERT INTO vgr_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","ఇనె బోధించనూ హూయిజావమా సీమోన్‍తీ, “తారు డోంగనా ఘధర్‍ ఛాతే జోగో లీన్‍జైన్‍, మాస్లా ధరానాటేకె మాస్లాను ఝాళినాక్‍,” కరి సీమోన్‍తి బోలామా, ");
INSERT INTO vgr_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","సీమోను, ఓ మాలిక్‍ హమే రాత్‍ అక్కు గణు కోషీస్‍ కర్యా, పన్కి కాయిబి కోమల్యునీ హూయితోబి తూ బోల్యొతిమ్ ఝాళి నాకీయేస్‍ కరి ఇనేతి బోల్యు. ");
INSERT INTO vgr_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","ఇవ్నే ఇం కరమా కేత్రూకీ మాస్లానా ధర్యూ, యినటేకె యూవును ఝాళి యో బోజోనా ఫాటి జౌంకరాతు, ");
INSERT INTO vgr_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","యినటేకె యూవునే బాజుమా ఛాతే అజేక్‍ డోంగనూ అద్మీయేనా మధత్‍ కరాన బులావమా, ఇవ్నే ఆయిన్‍ యో బేహే డోంగల్‍ మాస్లాతీ భారైజైన్‍, యో బోజోనా డూబిజవయేత్రు మాస్లునా భర్యు. ");
INSERT INTO vgr_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","సీమోను పేతురు యో అక్కు దేఖీన్‍ యేసునా గోడఫర్‍పఢీన్‍, “మే ఏక్‍ పాపి, ప్రభు మరకన్‍తూ ఛల్‍జా” కరి బోల్యో. ");
INSERT INTO vgr_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","కిమ్కతో యోబీ యినకేడె ఛాతే యూవునే ధర్యూతే మాస్లాను కుప్పనా దేఖీన్‍ గణు ఆష్చర్య పడ్యు. ");
INSERT INTO vgr_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","ఇమ్మస్‍ సీమోన్‍నూ కేడె భాగ్‍ ర్హవాళు జెబెదయనా ఛీయ్యా యాకోబు, యోహానుబి ఆష్చర్యపడు. యేసు సీమోన్‍తీ, “ఢరోనకో, హంకేతూ తూమే అద్మీయేనా దేవ్నూ రాజ్యమ్‍నా కిమ్‍ చాలవునుకీ తుమ్నా బోధీన్‍సే” హుయిరస్‍ కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","ఇవ్నె ఢోంగల్‍నా పాణీమాతు భార్‍ లీ ఆయిన్‍, సమస్తంనా మ్హేంధీన్‍, ఇనకేడె గయూ. ");
INSERT INTO vgr_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","యో ఏక్‍ హఃయర్‍మా థో తేదె, ఖోడ్‍తి భరైర్యుతే ఏక్‍ జణు యేసునా ధేఖిన్‍, ఆయిన్‍ గోడాఫర్‍పఢీ హఃలమ్‍ కరీన్‍, ప్రభు తూనా ఇష్టం హుసేతో మన హుఃద్రీస్, కరి బోలీన్‍ బతీమాలు. ");
INSERT INTO vgr_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","తేదె యో యిన హతేఖ్హూ ఛీమిన్ మన ఇష్టమస్ తూ సుద్దిహువను మన ఇష్టమస్‍ కరి బోలీన్‍, తూ సుధ్దుడ్‍ హూ కరి బోలుస్‍కరా, యినూ క్వోఢ్‍ యిన మ్హేంధీన్‍ ఛలీగు. ");
INSERT INTO vgr_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","తేదె యో తూ ఆ వాతే కినేతీబి సాత్బి నొకొబోలీస్‍తిమ్‍ జైన్‍, యూవనా సాక్చం హూయిరైన్‍, తారు ఆంగ్‍తన్‍నా యాజకుడ్నా దేఖడీన్‍, తూ అసేల్‍ హూయిరోతే యినఖజె మోషే మ్హేల్‍రాక్యోతే కానుకల్‍నా అర్పించ్‍ కరి ఆజ్ఞాపించొ. ");
INSERT INTO vgr_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","పన్కి యేసునూ గూరీంచీన్‍ ఖభార్‍ బుజు గణు ఫైలాయిగయు. జనాల్‍ఖారు ఇనూ వార్త ఖమ్జానాటేకె, అజు యూవునూ రోగ్‍ అసేల్‍ కర్‍లేవనా కరి భరై ఆవ్‍తూర్హయూ. ");
INSERT INTO vgr_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","యేసు ప్రార్థనకరనా టేకె ఝాఢీను జొగొమా జౌంగర్తో. ");
INSERT INTO vgr_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","ఏక్‍ ధన్నే యో దేవ్‍నీ వాతే బోధించుకరాతో, గలీలయ యూదయ దేహ్‍ఃను హరేక్‍ గామ్‍మతూ, యోరూషలేమ్‍మతూ ఆయూతే పరిసయ్యుల్‍బి ధర్మషాస్త్రం బోలవాలబి బెట్టూ ర్హవమా, యో రోగుల్‍నా అసేల్‍ కరనూ ప్రభునూ థాకత్‍ యిన థూ. ");
INSERT INTO vgr_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","థోఢు అద్మీయే ఏక్‍ జుటోపడిహుయినా మంచోఖమేస్‍ పళ్లీన్‍ యేసుకనా ఆయిన్‍ మ్హేందనా కోషీస్‍ కర్యా, ");
INSERT INTO vgr_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","పణ్కీ జనాల్‍ ఖారు గుంబల్‍తీ భరైర్హవామా, ఇనా మై లీజవానా కోహూయిని. యినటేకె ఘర్‍నా ఉఫర్‍ చఢీన్‍ ఫెంకుల్‍కాఢీన్‍, ఏజ్గాతూ జుటోపడిహుయినా మంచో ఖమేస్‍ హేట్‍ యేసు కనా ఉత్రాయూ. ");
INSERT INTO vgr_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","యో యూవునూ విష్వాసమ్‍ ధేఖీన్‍, ఓ సహోదరుడ్‍ తారు పాప్‍ అక్కు దోవయ్‍గయు కరి యినేతీ బోలామా, ");
INSERT INTO vgr_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","షాస్ర్తుల్‍బి, పరీసయ్యుల్‍ దేవా దూషణ కరూకరతే ఆ కోన్‍? దేవ్ ఏక్జనో తప్ప పాప్‍నా ధోవవాళో కరి సోఛానీక్లు. ");
INSERT INTO vgr_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","యేసు యూవునూ దిల్‍ను వాతే మాలంకరీన్‍, తూమే తూమార్వా దీల్‍మా ష్యాత్‍ సోచుకరస్‍? ");
INSERT INTO vgr_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","తారు పాప్‍ మాప్‍ హుయు కరి బోలాను సులభంకీ? తూ ఉటీన్‍ ఛాల్‍కరీ బోలాను సులాభం? ");
INSERT INTO vgr_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","కానీ పాప్‍నా మాప్‍ కరాన జమీన్‍ ఫర్‍ అద్మినా ఛీయ్యోనా అధికారం ఛాకరీ తూమే మాలంకర్‍నూకరీ యూవునేతీ బోలిన్‍, మిర్గిభర్యాన తూ ఉటీన్‍ తారు మంఛో పళ్లిన్‍ తార ఘర్‍కనా జా కరి బోలుకరూస్‍, ");
INSERT INTO vgr_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","తెదేస్‍ యో ఉటీన్‍ అక్కవ్‍నా ఖామే ఎగిస్‍ యో క్హుత్యోతె మంఛో పళ్లీన్‍ దేవ్‍నా స్తుతిస్తూ హూయిన్‍ ఘర్‍కనా ఛల్యేగొ. ");
INSERT INTO vgr_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","దేఖీహూయు అక్కజణు ఆష్చర్యపఢీన్‍ ఆజ్‍ గణు మోటు అధ్బుతం దేఖ్యాకరీ దేవ్‍నా స్తుతిస్తూ హుయిన్ ఢర్‍మా భరైగయూ. ");
INSERT INTO vgr_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","యిన బాద్‍మా యో ఏజ్గాతో నీక్లీన్‍ ఛాల్తోహూయిన్‍, లేవి కరి బోలాతే పన్నుల్‍ భంధవవాళో, ఏక్‍ జోగో బేసీన్‍ పన్నులు భంధవ్‍కరతే యేసునే దేఖీన్‍, మార కేడె ఆవ్‍ కరి యినేతీ బోలామా, ");
INSERT INTO vgr_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","యో ఉటీన్‍ సమస్తంనా మ్హేందీన్‍ యేసునా కేడె గయో. ");
INSERT INTO vgr_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","తేదె యో లేవి యిన ఘర్‍కనా యేసునాటేకె మోటు విందు కర్యో. యిన భరోబర్‍ కెత్రూకిజనూ పన్నుల్‍ వసూల్‍ కరవళనాబీ, అలాధ అద్మీయేబి ఖాణు ఖావనా భెఠా. ");
INSERT INTO vgr_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","పరిసయ్యుల్‍బి, యూవునూ షాస్ర్తుల్‍బి ఖ్హాణు కౌంగ్రతే యూవనా దేఖిన్‍, పన్ను వసూల్‍ కరావళతీ పాపుల్‍తీ బేసీన్‍ కిమ్ ఖంకరస్ కరి యేసునా సిష్యుల్‍నా ఉఫర్‍ గోణీగీల్‍దూ. ");
INSERT INTO vgr_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","తేదె యో, రోగ్‍తి ఛాతే అద్మీనస్‍ వైద్యుడ్‍నూ అవసరం కానీ, అసేల్‍ ఛాతే అద్మినా కాహే. ");
INSERT INTO vgr_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","మే నీతిగా ర్హవ్వాళాన టేకే కాహేగానీ, పాపుల్ను దీల్‍ భద్లావనాటేకె ఆయో కరి ఇవ్నేతి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","తేదె యూవునే, యోహాన్‍నూ సిష్యుల్‍ ఉపాస్‍ రైన్‍ ప్రార్థన కర్తూ ర్హాస్‍. పరిసయ్యు‍ల్‍నూ సిష్యుల్‍బీ ఇమ్మస్‍ కరాస్‍. కానీ తార సిష్యుల్‍ ఖాతు ఫీతూస్‍ ర్హాస్‍ కరి యేసుతీ బోల్యా. ");
INSERT INTO vgr_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","యినఖాజె యేసు, ససనౌరో ర్హవ్వా ఏత్రధన్‍ యిన ఘర్ను అద్మీయేనా హతేఖు తూమే ఉపాస్‍ ర్హాకఢ్‍స్యునా? ఇమ్‍ కోకర్సేనీ ");
INSERT INTO vgr_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","పన్కి యో నౌరో యూవనాకన్‍తూ ఛల్‍జావనూ ధన్‍ ఆవ్‍సే; తేదె యో ధన్‍మా ఉపాస్‍ ర్హసే కరి యూవునేతీ బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","యేసునే యూవునేతీ ఉపమాన్‍ బోల్యొ. కిమ్కతో కోన్‍బి జూను లుంగఢనా నవా లుంగఢమా మళైన్‍ కోసివానీ. ఏత్రేస్‍కాహే నవా లుంగఢామనూ టుక్డోనా జూనా లుంగఢామా మళావ కోయిని ఇమ్‍ కర్యతో జును లుంగ్డు క్హేచాయిన్‍ ఫాటీజాసే. ");
INSERT INTO vgr_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","కోన్‍బి జూను సంఛిమా నవూ ద్రాక్చాను రహ్ కోనాఖని. ఇం నాఖ్యతో నవూ రఖ్ యో జూని సంఛినా ఫీగిళిజాసే. రఖ్ ఛూయిజైన్‍ సంఛీ ఫాటీజాసే. ");
INSERT INTO vgr_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","నవూ ద్రాక్చనూ రఖ్నా నవూ సంఛీమస్‍ నాక్‍నూ. ");
INSERT INTO vgr_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","జూను ద్రాక్చరఖ్నా పిదూహూయు అద్మి నవూ రఖ్నా కోరవాళు కోన్‍బి కోయిని. యో జూనుస్‍ అసేల్‍ ఛాకరీ బోల్‍సే. ");
INSERT INTO vgr_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","ఏక్‍ ఆరామ్‍నా ధన్నేయేసుబి కేతర్‍మా కరి పఢీన్‍ ఛాల్తహూయిన్‍ జౌంగ్రతో, యిన సిష్యుల్‍ కేతర్‍మాను కంకుల్‍నా తోఢీన్‍ మహ్‍ఃళిన్‍ ఖ్హావనిక్లు. ");
INSERT INTO vgr_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","తేదె పరిసయ్యుల్‍మా థోఢుజణూ దేఖిన్‍, ఆరామ్‍నా ధన్నేధర్మస్త్రమా నాకర్‍నూతే కామ్‍ ష్యాన కరుకరస్‍? యూవనా పూఛావమా. ");
INSERT INTO vgr_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","యేసు యూవునేతీ ఆమ్‍ బోల్యొ దావీదుబి యిన కేడె ర్హవ్వావళు యూవునా బుక్‍లగ్గామా ఇవ్నే ష్యాత్‍ కర్యుకీ యోబి పఢ్యాకోయిన్‍నా? ");
INSERT INTO vgr_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","యో దేవ్ను మందిరంమా జైన్‍, యాజకుడు తప్ప అజు కోన్‍బీ నాఖానుతే దేవ్‍నూ జోగోమా మ్హేంధీయూ రోటనా పళ్ళీన్‍ ఖైన్‍, యినా కేడె ఛాతే యూవనాబి ధిదోని కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","యినటేకె అద్మినో ఛియ్యో ఆరామ్ను ధన్నేబి యాజమానిస్‍ కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","అజేక్‍ ఆరామ్‍నా ధన్నే యో సమాజమందీరంమా జైన్‍ దేవ్‍ వాతే బోలీదేంగ్‍రతో, ఏజ్గా ఖ్హావాత్‍ పఢీగయూ హూయు ఏక్‍ జణో తో. ");
INSERT INTO vgr_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","షాస్ర్తుల్‍బి, పరీసయ్యల్‍ యేసు ఫర్‍ ఇంజామ్‍ నాక్‍నూ కరి బోలీన్‍, ఆరామ్‍ను ధన్నే అసేల్‍ కర్‍సేషీకి కరి కావల్‍ కాసీరూతూ. ");
INSERT INTO vgr_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","కాని యో యూవునే ష్యాత్‍ సోచుకరతే మాలంకర్లీన్‍, హత్‍పఢిగయుతే అద్మినా తూ వూటీన్‍ అద్మీఅక్కానా ఇఛ్మా హీభర్‍ కరీన్‍ బోలామా, యో వూటీన్‍ బిర్హయో. ");
INSERT INTO vgr_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","తేదె యేసు, ఆరామ్ కరనధన్నే అష్యల్ కరనూ న్యాయంకీ క్హరాబ్‍ కరనూ న్యాయం? ఏక్‍ అద్మినా భఛావనూ న్యాయమ్కీ మర్‍క్‍దేవనూ న్యాయం? కరి తూమ్‍నా పూఛావ్‍మ్గ్రూస్‍ కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","యేసు యూవనా మణీ ఏక్‍ వఖాత్‍ ఆష్పిష్‍ ఫరీన్‍ దేఖీన్‍, తారు హాత్‍ హఃఢక్‍ కర్కరి బోలామా యో ఇం కరమా యిను హత్‍ అష్యల్ హుయు. హూయిగు. ");
INSERT INTO vgr_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","తేదె ఏజ్గా ర్హవ్వావళనా గణు కీజ్‍ ఆయిన్‍ యేసునా ష్యాత్‍ కరీయే కరి ఏక్‍నా ఎక్‍ బొల్లీదూ. ");
INSERT INTO vgr_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","యో ధన్నవ్‍మా యేసు ప్రార్థన కరనా టేకె ");
INSERT INTO vgr_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","వ్హాణుహూవదీన్‍ యో యిన సిష్యుల్‍నా బులైన్ యూవనమా భారజణాన ఏర్పర్‍ఛీన్‍ యూవునా అపోస్తులు కరి నామ్‍ మ్హేందొ ");
INSERT INTO vgr_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","యూవునే కోన్‍ కతో సీమోన్‍నా యేసు పేతురు కరి నామ్‍ మ్హేంధొ యినో నానో భై అంద్రెయ యాకోబు యోహాను ఫిలిప్పు బర్తొలొమయి ");
INSERT INTO vgr_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","మత్తయ తోమా అల్ఫయి నో ఛీయ్యో యాకోబు జెలోతె కరి బూలావతే సీమోను ");
INSERT INTO vgr_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","యాకోబు నో ఛీయ్యో యూదా ఇస్కరియోతు యూదా ఆస్‍ యేసునా ద్రోహాం కర్సేతే ");
INSERT INTO vgr_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","తేదె యేసు సిష్యుల్‍తీ మలీన్‍ ఫాఢ్‍ఫర్‍తు హేట్‍ ఉత్రిఆయిన్‍ మైదాన్‍మా హీబిర్యొతొ యిన సిష్యుల్‍నూ మోటు గుంపుల్‍ బుజు యూదయ దేఖుతూ యోరుషలేమ్‍మతు ధర్యవ్‍నా సేడెనూ తూరు సీదోను ఖాయరే మాతు కేత్రూకీ జణు అద్మీయే ఆయూ ");
INSERT INTO vgr_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","యేసు బోలాతే వాతే ఖమ్జానా టేకె అజు యూవునూ రోగ్‍నా అసేల్‍ కర్‍లేవనా టేకె అపవిత్రాత్మ ధర్యుహుయు కేత్రుకీ జణు ఆయిన్‍ అసేల్‍ హూయు ");
INSERT INTO vgr_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","రోగ్‍వాళనా అసేల్‍ కరనూ షక్తి యేసు మతూ భార్‍ ఆయిన్‍ యూవునా అసేల్‍ కరుకరమా యూవునే అక్కు జణు యిన ఛీమ్‍నూ కరి కోషీస్‍ కర్యు ");
INSERT INTO vgr_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","తేదె యేసు సిష్యుల్‍నా ధేఖీన్‍, యూవ్నేతి అమ్‍ బోల్యొ గరీబ్‍ హూయుర్హతే తూమే ధన్యుల్‍, దేవ్‍నూ రాజ్యం తూమారు. ");
INSERT INTO vgr_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","హాంకె భుక్కేతిఛాతె తుమె భాగ్యవంతుల్, తుమే త్రుప్తి హుస్యు. హంకే రొంక్రతే తుమే ధన్యుల్, తేదె తుమే హాక్తూ ర్హాసు. ");
INSERT INTO vgr_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","అద్మినో ఛియ్యోనా హాఃజే అద్మీయే తూమ్‍నా ధూషింఛిన్ తూమ్నా దూర్‍ కరీన్‍ తూమారఫర్‍ ఇంజామ్‍ నాఖిన్ తూమారు నామ్‍ క్హారబ్‍ కరి బోల్యు తేదె తుమె ధన్యుల్ ");
INSERT INTO vgr_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","యో ధన్నువ్‍మా తూమే సంతోసిమ్ఛో వుజు కుదో సానకతో స్వర్గంమా తుమ్నా ఫాయిదో మల్సె, జమానమాభీ ఆవ్నా పితరుల్‍బి హాఃరూబి ప్రవక్తల్‍తీ అమ్మస్‍ కర్యు ");
INSERT INTO vgr_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","ఓ ధన్‍దౌలత్‍వాళా, తుమ్నా ష్యాత్‍ హోను కతో యిన తుమే హాంకెతోడి, అనుభవించిరాక్యస్ తుమ్నా మిన్హత్‍ ఆవ్సే. ");
INSERT INTO vgr_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","పేట్‍ భరైహూయా అద్మీయే తుమ్నా భుక్‍లగ్సే హాంకె ఆహుఃకరతె, అద్మియే తుమే దుఃఖ్‍పఢ్‍స్యు, అజు తుమె రోవ్‍స్యు. ");
INSERT INTO vgr_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","అద్మియే హాఃరు తూమ్నా హఃరాయు తేదె తుమ్నా మిన్హత్‍, యూవునూ పితరూల్‍బి ఇమ్మస్‍ జూఠ ప్రవక్తల్‍నా హఃరాయు. ");
INSERT INTO vgr_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","మారీ వాతే ఖంజుకరతే తూమ్నా మే ష్యాత్‍ బోలుకరూస్‍కతో తూమారు వైరేవ్‍నా ఫ్యార్‍ కరొ తూమ్నా ధూషించవాళానా అచ్చు కరొ ");
INSERT INTO vgr_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","తమ్నా షభర్‍ దేవవాళనా దీవింఛొ బాధపెట్టతే యూవ్నా హాఃజె తూమే ప్రార్థన కరొ ");
INSERT INTO vgr_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","ఏక్‍ గాల్ఫర్ మారవాళనా బెంమ్మనూ గాల్‍ఫర్‍బి మార్‍కరీ బోలొ తారు ఉఫర్లు టూవల్‍ పళ్ళిజావళాన తారఖ్హూఢతు పళ్ళీనాజానుతిమ్‍ ఆడునకోబోల్‍స్యు ");
INSERT INTO vgr_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","మాంగతే ప్రతేక్‍నా ధేవో తార కన్‍తూ ష్యాత్‍భీ లీన్‍ గయూతే అద్మీకన్‍తూ అజూపాసూ యో రాఛూ నకో మమ్గో ");
INSERT INTO vgr_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","ఫార్లు తూన ష్యాత్ కర్నూకరి సోచస్కి తుమేబి యూవనా ఇమ్మాస్‍ కరొ. ");
INSERT INTO vgr_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","తూమ్నా తుమ్న ఫ్యార్‍ కరవాలనస్ ఫ్యార్‍ కర్యతొ ఇన్మా ఫైదో ష్యాత్? పాపుల్‍బి యూవనా ఫ్యార్ కరవళానస్‍ ఫ్యార్‍ కరస్‍ కాహేనా ");
INSERT INTO vgr_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","తూమ్నా అషల్ కరవళానస్‍ తూమె అషల్ కర్యతో ఇన్మా ఫైదో ష్యాత్ పాపుల్‍బి ఇమ్మస్‍ కరస్‍ కాహేనా ");
INSERT INTO vgr_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","కీనాబి వూధర్‍ దీధాతో యూవునే పాచూ ఫరీన్‍ దీనాసే కరి ఆహ్‍ఃకర్యతో ఇన్మా ఫైదో ష్యాత్ పాపుల్‍బి ఇవ్నే దిదొతే వూధర్‍ అక్కు పాచు ఫరీన్‍ దీసేకరీనస్‍ దేస్‍ కాహేనా ");
INSERT INTO vgr_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","తూమే కీమ్నా వైరేవ్‍నా టేకెబి నీరాహ్‍ః నాహూనూతిమ్ తుమారు వైరేవ్‍నా ఫ్యార్‍ కరో అషల్ కరో వూధర్‍ దేవో తేదె తూమ్నా ఫైదోమళ్‍సే సర్వోన్నత్‍ దేవ్నూ ఛీయ్యో హూయిరసు యో కరాబ్‍ అద్మీనాబీ కృతజ్ఞత కోయిన్తే అద్మీయేనాబి అషల్ కరవాళో హూయిరోస్ ");
INSERT INTO vgr_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","యినటేకె తూమార భా కనికర్‍ హుయిన్‍ కీమ్‍ ఛాకీ తూమేభి కనికర్‍హుయిన్‍ ర్హవో ");
INSERT INTO vgr_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","న్యావ్నా నొకొతీర్చొ, తెదె దేవ్‍ తుమారబారెమా న్యావ్ కర్సేకొయిని కీనాఫర్‍భి ఇంజామ్‍ నకో నాకో తేదె తూమారఫర్‍బి దేవ్‍ ఇంజామ్‍ నాక్‍స్యే కోయిని తూమే మాప్‍ కరో తేదె దేవ్‍ తూమారు తప్పుల్‍బీ ఇమ్మస్‍ మాప్‍ హూస్యే ");
INSERT INTO vgr_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","తూమే ధ్వేవొ తేదె తూమ్‍నాబి దేవావ్‍సే దాభీన్ గీఛ్‍ కరీన్ భరైన్‍ హేట్‍ పడయేత్రు తూమార ఖోళమా నాక్‍సే తూమే కీనేతీ మోజీన్ దేంక్రస్‍కి దేవ్బి యోస్‍ మోజీన్‍ తూమ్‍నా దేవావ్‍స్యే ");
INSERT INTO vgr_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","అజు యేసు ఏక్‍ ఉపమాన్‍ బోలో ఏక్‍ ఖాణో అద్మి అజేక్‍ ఖాణోన వాట్‍ వత్తాల్‍సేనా ఇంకర్యతో భే జణబి ఖ్హాఢమా పఢ్‍సే కాహేనా ");
INSERT INTO vgr_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","ఏక్‍ సిష్యుడ్ ఇను గురువుతీబి మోటొ కాహే పన్కి యిను సిక్చ అక్కు పూర్తి హూవదీన్‍ తేదె యినేతి భరోభర్‍హూసే ");
INSERT INTO vgr_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","తూ తారు ఢోళమ ఛాతె పెల్కునా నాధేక్‍నూ తిమ్తారు భైని ఢోళమానూ ధరాసు నల్సు నాకీమ్‍ దేఖుకరాస్ యిన ఢోలామాను పెల్కు గల్లీన్ ");
INSERT INTO vgr_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","తారు భై ని డోళమా ధరాసు పెల్కు కాఢ్‍కరి కిమ్బోలూ కరస్ ఓ కపటి అద్మి అగాఢి తార డోళమనూ పెల్కునా కళ్ళా తేదె తారొ భైని డోళమనూ పెల్కునా కన్నాకనా తున తేటగా దెఖ్కావ్సె ");
INSERT INTO vgr_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","ఖయు అఛ్చు ఝాఢనా కామే అవకోయిన్తే పంఢా వుటకోయిని కామేఅవకోయిన్తే ఝాఢనా అష్యల్ పంఢా పుట్సెకోకొయిని. ");
INSERT INTO vgr_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","ఖయూబి ఝాఢ యిను పంఢతీస్‍ ఫళానూ ఝాఢు కరి మాలంహూవస్ కాఠనూ ఝాఢమతూ గుల్లర్‍నా పంఢ కోరిమ్తి నూ ఝాఢనా ద్రాక్చనాపంఢా తోడియేకోయిని ");
INSERT INTO vgr_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","అష్యల్ అద్మీయేనూ దిల్‍మా అచ్చు గుణ్‍ భరైరస్ యినటేకె యినమాతూ అష్యల్ వాతె అష్యల్ వాతె భాధర్‍ ఆవస్ ఖరాబ్‍ అద్మీయేనూ దీల్‍మా ఖరాబ్‍ గుణ్‍ భరైరస్ యినటేకె ఇన్మాతూ కరాబస్‍ భాధర్‍ ఆవస్ దీల్‍మా సాత్‍ ఛాకీ యోస్‍ వాత్‍ మోఢాతీ బోలాస్ ");
INSERT INTO vgr_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","మే బోలుతిమ్ నాకరీన్ ప్రభువా ప్రభువా కరి మన ష్యాన బులావస్ ");
INSERT INTO vgr_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","మారకనా ఆయిన్‍ మారీ వాతె హఃమ్జిన్‌ యిన భరోభ్బర్‍ ఛాలవళు ప్రతీ ఏక్‍ జణు కీనిన్‍తర రసేకతో తూమ్‍నా బోలుస్ ");
INSERT INTO vgr_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","యో ఘర్‍ భాంద్నూకరీ అసేల్‍నితర ఖ్హాఢకొమ్ధీన్ భంఢనాఉఫర్‍ బేస్‍ నాకీన్‍ భాంధూహూయు అద్మీని జోన్‍నూ కరి బోలాజై కేవోడో మోటొ వాయిరో పాణీను తుఫాన్‍ ఆయిన్‍ యో ఘర్‍నా మారీతోబి యోఘర్‍నా జరభి హల్‍సేకోయిని. సానకతో యో ఘట్‍ భాందాయిరుస్ ");
INSERT INTO vgr_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","మారు వాతె హమ్జీన్ ఇంనితరా కరకొయింతె అద్ముయే యూవ్నూ ఘర్‍ హఃఢకొన్‍ధీన్‍ బేస్‍మట్టం నాక్యూ కోయినితిమ్ ఖాళీ జమీన్‍ఫర్‍ ఘర్‍ భాంధీహూయు అద్మీను జోన్‍నూ కరి బోలాజై పాణీను తుఫాన్‍ అయిన్‍ యో ఘర్‍నా మారామ యో ఘర్‍ పుటీపడ్యు జైన్‍ నాసానం హుయిజాస్ ");
INSERT INTO vgr_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","యేసు ఇని వాతే అక్కు అద్మీయన బోలిహూయి జావదీన్ ఏజ్గాతూ కపెర్నహూమ్మా ఆయో ");
INSERT INTO vgr_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","ఏజ్గా ఏక్‍ షతాధిపతినా ఇష్టంను యిన హేట్‍ కామ్‍ కరవాళు రోగ్‍తీ మరణ్‍జీవన్‍మా త్హూ ");
INSERT INTO vgr_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","యో షతాధిపతి యేసును గురీంచిన్‍ వాతే ఖ్హాంజీన్ యో ఆయిన్‍ మార దాస్‍నా అసేల్‍ కర్‍నూ కరి యిన బతిమాలనాటేకె యూదుల్‍నా మోటా అద్మీయన ఇన కనా బోలిమోకిల్యొ ");
INSERT INTO vgr_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","ఇవ్నే యేసు కనా ఆయిన్ తారేతీ ఆ అసేల్‍ హువన యిన అర్హత ఛా. కరి ఇవ్నే యేసు బాతిమాలిలిదు ");
INSERT INTO vgr_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","యో అపుణు జనాల్‍నా ఫ్యార్‍ కరీన్ ప్రార్థనను జొగోన భాంద్యుతేబి యోస్‍ కరి ఇనేతి బోలిన్‍ యిన బతిమాల్యు ");
INSERT INTO vgr_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","తేదె యేసు యువునా కేడె జైన్ యో ఘర్‍నా షేడే జావధీన్ షతాధిపతి ధేఖిన్‍ యిన దోస్తుల్‍నా తూమే యిన కనా జైన్ ప్రభు తూన ఎత్రె ష్రమ నకో మార ఘర్‍మా యినూ గోడొ మ్హేంధనా మన ఎత్రే అర్హత కోయిని ");
INSERT INTO vgr_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","యినటేకె మే తారకనా ఆవనాభి ఏత్రే అర్హత మన ఛాకరీ సోచుకరుకోయిని యినటేకె తు ఖాళి తారి వాతేతి హూఖంధా తేదె తెదె మారొ దాసుడ్‍ అసేల్‍ హూయిజాసే ");
INSERT INTO vgr_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","మేబి అధికార్నా తగ్గించిలిన్‍ రవ్వాలొ; మార హాత్నహేట్ దాసుల్‍ ఛా; మే ఏక్నా జాకతొ జాసె, ఏక్నా ఆవ్కతో ఆవ్సె, మారొ దాసుడ్నా ఆకామ్ కర్కతో కర్సెకరి మే బోల్యొతిమ్ బోల్కరి ఇవ్నా మొక్‍ల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","షతాధిపతి బోలిమోకల్యొతే వాతే ఖామ్జీన్‍ ఆష్చర్యం హూయిన్ యిన కేడె ఆంకూరతే అద్మీయే మణీ ఫరీన్‍ ధేఖిన్ అత్రే విష్వాసం ఇష్రాయేల్‍ మాభి కేదెస్‍ ధేక్యోకొయిని కరి తుమారేతి బోలుకరూస్‍. ");
INSERT INTO vgr_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","బోలిమోక్‍లాయుతే యూవునే పాచు ఫరీన్‍ ఆయిన్ యో దాసుడు అసేల్‍ హూయిరూతే యిన ధేక్యు ");
INSERT INTO vgr_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","యినబాద్‍మా యేసు నాయీకరి బోలాతే ఏక్‍ ఖాయార్‍నా గయో, యిన సిష్యుల్‍బి అజు గణు జనాల్‍ యిన కేడె జాతుర్హయు ");
INSERT INTO vgr_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","యో హఃయర్‍మా జౌస్‍కర తోఢు అద్మీయే మరీగయూ హూయు ఎక్‍ ఛోగర్వాన పళ్ళీన్‍ జాతువోఖాత్‍ ధేఖీన్ యిని అయాన యో ఎక్కస్‍ ఛీయ్యో యో విధవరాల్‍న కెడే గామ్‍ను అక్కు జణు యిన కేడె త్హూ ");
INSERT INTO vgr_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","ప్రభు యిన దేఖిన్‍ గోర్‍ కరీన్‍ నకొరోవ్‍ కరి యిన బోలిన్ యో చొగ్రుకనా జైన్‍ కావడ్‍నా ఛీమమా పళ్లి జంక్రతె అద్మియే ఉబ్రీగయు యో ");
INSERT INTO vgr_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","ఓ అడ్డాణి ఛోగర్వా తూ వూట్‍కరీ తారేతి బోలుకరూస్ కరి బోలామా ");
INSERT INTO vgr_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","యో మరీగయుతే ఛోగురు ఉటి బేసీన్‍ వాత్‍ బోలానీక్యు యేసు యో ఛోగర్వానా యిని ఆయాన అప్ప ");
INSERT INTO vgr_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","యూవునే హాఃరు ఢరీజైన్ అప్నమా ఏక్‍ మోటో ప్రవక్త ఆయ్‍రోస్‍కరీ దేవ్‍ యిన అద్మీయేనా భఛవనటేకె ఆయ్‍రోస్‍ కరి బోలిన్‍ దేవ్‍నా స్తుతించు ");
INSERT INTO vgr_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","యేసును వాతే అక్కు యూదయను గామ్‍మా అజు అష్పీష్ను గామేవ్‍మా ఫైలాయుగయు ");
INSERT INTO vgr_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","యోహాన్‍నా సిష్యుల్‍ ఆ సంగతి క్హారు ఇనా మాలంకర్యాయు తేదె యో సిష్యుల్‍మా బేజణన బూలైన్ ");
INSERT INTO vgr_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","హమరటేకె ఆవజాసెతె తూస్నా నైతో అజేక్‍నాటేకె ఎదురు దేక్‍నూనా కరి ప్రభునా పుఛాయ్‍ ఆవోకరీ బోలీమోకల్యొ ");
INSERT INTO vgr_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","యూవ్నే యేసుకనా ఆయిన్ బాప్తిస్మమ్‍ దేవవాళో యోహాన్ తునా ఆమ్‍ పూచ్ఛావ్‍‍కరీ హామారేతి బోల్యొ ఆవజాసేతె తూస్‍కీ అజు కీనాబిటేకే ఎదురు దేక్నూ కరి బోల్యు. ");
INSERT INTO vgr_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","తేదే యేసు యోవక్హత్‍ఫరస్‍ రోగ్‍వాళానా బాధపడుకరతే యూవునా అపవిత్రాత్మల్‍ ధర్యుహూయు కెత్రూకిజనునా అషల్ కరీన్ అజు ఘాణు అద్మీయేనా ధేఖనా చూప్‍ దీదో ");
INSERT INTO vgr_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","తేదె యో అమ్‍ బోల్యొ తూమె జైన్‍ దేఖ్యాతే హఃమ్జతే అక్కు వాతేనా యోహాన్‍తీ బోలొ, ఖాణుఅద్మి దేకుకరాస్ లంగ్ఢు ఛాలకరాస్ ఖోడ్‍వాళు అష్యల్ హూంక్రస్ భైరు క్హంజుకరాస్ మరీగయూహు ఉట్టూకరాస్ గరీబ్నా దేవ్ని సువార్త ప్రచార్‍ హుంక్రస్ ");
INSERT INTO vgr_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","మారు వాతెఫర్‍ అగఢీ పాసళ్‍ హూవకోయిన్తే యో ధన్యుడ్ కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","తేదె యోహాన్నా దూతల్‍ ఛల్‍ జావధీన్ యేసు ఏజ్గా ఆయ్‍రూతే యువ్నేతి యోహాన్‍నూ గురించి అమ్‍ బోలాలగ్యొ తుమే ష్యాత్‍ దేక్నూన ఝాఢీమా గయా వాయిరమా హలుకరతే ఢాలీనా ధేఖానా గయానా ");
INSERT INTO vgr_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","అజుష్యాత్‍ ధేఖనా గయా భారీమోల్‍నా లుంగ్‍ఢా పేర్‍రాక్యుతే అద్మీయేనా ఇంనూ భారీ మోల్‍నూ లుంగ్‍ఢా ఫేర్లీన్ సుఖ్‍తి జీవావాళు రాజౌను ఘర్‍మా ర్హాస్ ");
INSERT INTO vgr_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","అజు ష్యాత్‍ ధేఖ్హానా గయా ప్రవక్తన్‍నా క్హాచీస్‍ ప్రవక్తతీబి మోటోకరీ తూమారేతీ బోలుకరూస్ ");
INSERT INTO vgr_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","హాధేక్‍ మే మార దూతనా తారేహూః అగాఢి బోలి మోక్లుకరూస్; యో తారా వాట్నా హూఃదు కర్షే కరి కీనా గురించీ లిఖ్కాయ్‍ రూస్కి యోస్‍ ఆ యోహాన్. ");
INSERT INTO vgr_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","రాంఢె ఫైదాకరియేతె హాఃరవ్‍మా యోహాన్‍తీ మోటు కోన్‍బికోయిని పన్కి, దేవ్‍ని రాజ్యంమా తగ్గించిలీన్‍ ర్హవ్వాలు యోహాన్‍ తీబి మోటు కరి బోలుకరూస్. ");
INSERT INTO vgr_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","అద్మీ హాఃరూబి పన్నుల్‍ భందవవాళుబి యోహాన్‍ బోలాతే దేవ్‍ని వాతే ఖమ్జీన్ న్యాయమంతుడ్నో దేవ్‍కరీ ఒప్పిలేతూహూయిన్‍ యోహాన్‍నా హాత్‍మా బాప్తిస్మమ్‍ లీదు. ");
INSERT INTO vgr_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","పన్కీ పరిసయ్యుల్‍బి షాస్త్రుల్‍ ఇన హతేఖూ బాప్తిస్మమ్‍ నాలీన్ అజు యూవనాటేకెను దేవ్‍నూ సంకల్పంనా ఒప్యుకోయిని ");
INSERT INTO vgr_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","ఇనటేకె ఆ పిఢియేను అద్మీయేనా మే కీనేతి మాళవ్ యూవునే కీనిన్‍త్రా ఛా. ");
INSERT INTO vgr_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","బజార్‍ని గల్లీయేమా బేసీన్‍ పుమ్గీ పూక్యతోబి తూమే కో ఖేల్యానీ ఇనటేకె గీత్‍ బోల్యాతోబీ తూమే రొయ్యాకొయిని కరి ఏక్తీ ఏక్‍ బోల్లీన్‍ ఖేల్లేతె అఢ్డానీ లఢ్‍కావ్నితర తూమే ఛా. ");
INSERT INTO vgr_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","బాప్తిస్మమ్‍ దేవ్వళో యోహాన్ రోటొ నాఖ్హాను తిమ్ ద్రాక్చను రహ్‍ పిదోకొయిని ఇనటేకె తూమే భూత్‍ ధర్యుహుయు అద్మికరి తూమే బోలుకరాస్. ");
INSERT INTO vgr_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","అద్మినో ఛియ్యో ఖాతొహుయీన్, పీతొహుయిన్, ఆయో. ఇన తూమే తిండిపోత్‍ కరి పియ్యాళు కరి పన్నుల్‍ భంధవవాళునుబి పాపుల్‍తీ ఖాగ్‍ కరావాళు కరి బోలుకరాస్. ");
INSERT INTO vgr_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","హూయితోబి దేవ్ను అఖ్కాల్‍నా ఇన లాయిలేవ్వాళు అద్మీతీస్‍ యో అఖ్కల్‍ సాబుత్‍ హువ్సె. ");
INSERT INTO vgr_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","పరిసయ్యుల్‍మా ఏక్‍ జనొ యేసునా మారకేడె ధాన్‍ ఖానూ కరి ఇనా పుఛాయో తేదె యో ఇన ఘర్‍కనా జైన్ ఖాణు ఖావనాటేకె భేక్హామా ");
INSERT INTO vgr_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","యో గామ్మా ఏక్‍ పాపేలీ భాయికో యేసు ఏక్‍ పరిసయ్యుడ్‍ను ఘేరె ఆయిరోస్కరీ మాలంకరీన్ ఏక్‍ మోల్నూ అత్తర్‍నూ సీషి లీన్‍ ఆయిన్ ");
INSERT INTO vgr_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","పీటేతూ ఆయిన్‍ ఇన గోఢకనా బీరిన్ యేసునా గోఢానా ఇనీ ఆంజూతీ భీజైన్‍ కేహ్‍ఃతీ నూఛ్చీన్ ఇన గోఢనా బుఛ్చా దీన్ ఇన ఉఫర్‍ అత్తర్‍ లగఢీ ");
INSERT INTO vgr_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","ఇన బూలాయోతే పరీసయ్యుడు యో భాయికో కరీతే యిన దేఖిన్ ఆ ప్రవక్త రైయిహోత్‍తో ఇన కోన్‍ ఛీమ్యుకీ యో కీమ్‍నికీ మాలంకర్లీదోహోత్ కరి ఇన దీల్‍మా సోఛీల్దొ. ");
INSERT INTO vgr_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","ఇనఖాజే యేసు సీమోన్‍ మే తారేతీ ఏక్‍ వాత్‍ బోల్‍నూకరీ దేకుకరూస్‍ కరి ఇనేతి బోలామా యో భోధకుడ్ బోల్‍ కరి బోల్యొ s ");
INSERT INTO vgr_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","తేదె యేసు ఉధర్‍ దేవవాళో ఏక్జణన భేజణ ఉధర్‍లీధా హూయా థా. ఏక్జనొ పాఛ్‍ఖో దేనారమ్‍లు, అజేక్‍ జనో ఆఢైహ్‍ః దేనారమ్‍లు ఉధార్‍ లీరాఖ్యుతూ. ");
INSERT INTO vgr_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","యో ఉధార్‍ భాంధనా యూవనా కనా కాయికోతూని. యినటేకె యో యూవనా భే జణనా మాప్‍ కర్‍దిదో. ఇనటేకె యూవనామా కోన్‍ గణు ఇన ఫ్యార్‍ కర్సేకి బోల్‍ కరి బొల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","తేదె సీమోన్‍ ఇనేతి గణు ఉధార్‍ లీదోహూయో వాళోస్‍ కరి సోచావ్‍మ్గరాస్‍ కరి చుకరూస్‍, కరీబోలామా తేదె యేసు తూ భరోభ్బర్‍ బోల్యొకరీ యినేతి బోలిన్‍, ");
INSERT INTO vgr_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","తేదె యో భాయికో మణీ ఫరీన్‍, ఆ భాయికో నా దేకుకరస్‍న్నా? మే తార ఘర్‍కనా ఆయో. తూ మన గోఢో ధోవనా పాణీబి కోదిదోని, పన్కీ ఆ మార గోఢనా ఇని ఆంజూతీ ధో‍యిన్‍ ఇన ఖేహ్‍ఃతీ నుచ్చి. ");
INSERT INTO vgr_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","తూ మన బుఛ్చా దిదోకోయిని తిమాస్‍ బుల్యాయో, పన్కీ మే మై ఆయో తేప్తూ యో మార గోఢనా బుఛ్చాస్‍ దీయేజస్‍. ");
INSERT INTO vgr_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","తూ మార మూఢ్‍క్యానా తేల్‍బీ లగాఢ్యో కోయిని, కాని ఆ మార గోఢనా అత్తర్‍ లగాఢీ. ");
INSERT INTO vgr_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","యో గణు ఫ్యార్‍ కరి, ఇనటేకె యో కరీతే కేత్రుకీ పాప్‍బీ మాప్‍హూయుగు కరి తారేతి బోలుకరూస్‍. కీను పాప్‍ కమ్‍ ధోవవాస్‍కీ యో కమ్‍ లాఢ్‍కరస్‍ కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","ఇనబాద్‍మా యేసు యినేతి, తారు పాప్‍ ఖారుబి మాప్‍హుయుగు కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","యేసునా కేడె ఖవనా భేరుతే యూవునే ఏక్‍ను పాప్‍ మాప్‍ కరానా ఆ కోన్‍కీ? కరి ఏక్‍నా ఏక్‍ బోల్లీదు. ");
INSERT INTO vgr_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","“తేదె యో తారు విష్వాసమస్‍ తునా భచ్ఛాయు, షామ్తి సమధనంతీ ఘర్‍కనా జాకరీ ఇనేతి బోల్యొ.” ");
INSERT INTO vgr_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","ఇనబాద్‍మా యేసు దేవ్ను రాజ్యంనూ వాతె బోల్తొ హరేక్‍ హఃయార్‍మా, గాంమ్మా ఫరీన్ బోల్తొహూయిన్‍, కర్తో ర్హావమ. ");
INSERT INTO vgr_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","భారజణ సిష్యుల్‍బి, సైతాన్‍ను రోగాల్‍మతూ ఛుటిహూయు థోఢీ భాయిక ఇవ్నేనేబి అజు కేత్రుకీ జణు యూవనా కనా ఛాతే ధౌలత్‍తీ యూవ్నా ఉపచార్‍ కర్తు ర్హయూ, ఖాత్‍ సైతాన్‍మతూ భచీహూయి మగ్దలేనే మరియబి, ");
INSERT INTO vgr_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","హేరొదు రాజోనా ఖవాత్‍నూ జోఢనూ కూజానూ భావణ్‍ యోహాన్నబి, సూసన్నాయేసునా కేడె థూ. ");
INSERT INTO vgr_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","గణు అద్మియే ఖారు ఖాయార్‍మతూ ఇనకనా ఆవ్‍తూర్హయు, ఇవ్నేనేతి యేసు ఏక్‍ ఉపమాన్‍నితర ఆమ్‍ బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","ఏక్‍ ఖేతర్‍వళొ బిమ్జోల ఛీఢాకాన టేకె ఖేతర్‍నా జైన్‍, యో ఎజ్గా బిమ్జోలనా ఖూకరతో థోఢు వాట్‍నా సేడే పఢీన్‍, అద్మియేనూ గోఢవ్‍మా ఖూంధలాయు, ఇనటేకె ఇన వూఢవలు జీన్వార్‍ ఆయిన్‍ ఖైలేస్‍. ");
INSERT INTO vgr_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","అజు థోడు పత్రావ్‍నూ జోగోపడమా, మొలకల్‍ ఉటీన్‍ పాణీనూ షమ్మా కయిన్తె ఖూకైగు. ");
INSERT INTO vgr_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","అజు థోఢు కాఠను ఢాగ్‍మా పడ్యు, యో బిమ్జోలను జోఢ్‍మా ఖాటాను ఢాగేబి వోధీన్‍ ఇన మోటు కోహూవదేని. ");
INSERT INTO vgr_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","అజు థోఢు అఛ్చాజోగొమా పఢీన్‍, యో ఉటీన్‍ మోటాహూయిన్‍ ఖోవంతు ఫల్‍ దేస్‍, కరి బోల్యొ. కాణ్‍ రవ్వాలు అసేల్‍ ఖమ్జనూ కరి ఘట్‍ ఛిక్రీన్‍ బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","సిష్యుల్‍, యేసుతీ ఆ ఉపమాన్‍నా మత్‍లభ్‍ షాత్‍కరీ పూఛాయు. ");
INSERT INTO vgr_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","యో దేవ్‍ని రాజ్యం ను రహస్యంనూ వాతే మాలంకరనా తూమ్‍నా అఖ్కాల్‍ దేవయ్‍రూస్‍. ఫణీకి ఫార్లేవ్‍నా హూయుతొ ధేఖిన్‍బి నాధేఖన్‍తర, ఖమ్జీన్‍బి నాఖమ్జానితర ర్హాను కరి యూవునా ఉపమాన్నితర బోలుస్‍. ");
INSERT INTO vgr_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","ఆ వాతేనా మతలభ్‍ ష్యాత్‍ కతొ బిమ్జోల దేవ్‍ని వాతేను జోణ్‍నూ. ");
INSERT INTO vgr_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","వాట్నా సేడె పడ్యుహూయు బిమ్జోలను జోణ్‍నూ కోన్‍ కతొ యూవునే దేవ్‍ని వాతే క్హంజస్‍ పన్కి, సైతాన్‍ యూవునే నమ్మి రక్చణ నాలేనుకరీ దేవ్ని వాతేన యూవ్నా దీల్మతూ పళ్లీ ఛల్జాస్‍. ");
INSERT INTO vgr_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","భండవ్నూ జమీన్‍ఫర్‍ పడ్యుతే బిమ్జోలను జోణ్‍ను కొన్‍ కతొ, ఖమ్జా తేదెస్‍ దేవ్‍ని వాతేనా ఒప్పిలేస్‍, పణికి యూవనామ విష్వసంనూ, భరోసనూ జడే కోరైని యినటేకే, ధర్యాషు బాధల్‍నస్‍ దేవ్‍తీ దూర్‍ ఛల్‍జస్‍. ");
INSERT INTO vgr_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","కాఠను డాగెమా పడ్యుతే బిమ్జోలను జోణ్‍నూ కోన్కతొ, దేవ్ని వాతేనా క్హంజస్‍. పన్కి యూవునే జీవనాటేకె ఆవతే థోడుస్యు మిన్హత్నా, బాధల్నస్‍, అజు ధన్‍ దౌలత్ను ఆహ్క్ యువ్నా ధాబినాగ్‍ దేస్‍, ఇనటేకె పూర్తిగా ఫలించకోయిని. ");
INSERT INTO vgr_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","అఛ్చా జమీన్‍ఫర్‍ పడ్యుతే బిమ్జోలను జోణ్‍నూ కోన్‍కతొ, అచ్చు దిల్‍థీ అజు నంమాకంతీ దేవ్‍ని వాక్మంమ్నా ఖమ్జీన్‍, ఇనా దిల్మా ర్హాకిన్‍, ఫలించా తోడి స్థీరంగా ర్హాస్‍. ");
INSERT INTO vgr_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","కోన్‍బి ఉజాళనాటేకె దివ్వొనా భాళీన్‍, డబ్బానా హేట్‍ మ్హేంధీన్‍ కోముఛాని. మంఛనా హేట్‍బి మ్హేంధాకొయిని. పన్కి ఘేర్మా ఆవాళనా జావ్వలన ఉజాళు దేఖ్వానటేకె ఉఛ్చు జోగొ ఫరాస్‍ మ్హేంధాస్‍. ");
INSERT INTO vgr_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","మాలంహూవకోయిన్తే రహస్యం కాయిబికోయిని. నామాలంతిమ్‍ ర్హావనాబి లపిర్యుతే కాయిబి కొయిని. ");
INSERT INTO vgr_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","యినటేకె తూమే ష్యాత్‍ హమ్జూకరస్‍కీ అఛ్చితర సోఛో కరీబోల్యొ; ఛాతే అద్మినస్‍ దేవవ్‍సే, కోయిన్తే అద్మీకనా ఛాకరీ సోఛుతొ యోభి కణ్నాక్‍ దీసే. ");
INSERT INTO vgr_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","తేదె యేసుని ఆయాబి ఇన భైయ్యే ఆయిన్‍, అద్మియే హఃరు గుంబల్‍తీ భరైరవ్హమా ఇనకనా ఆవనా కోహూయుని. ");
INSERT INTO vgr_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","తేదె ఏక్‍ అద్మి యేసు కనా ఆయిన్‍, తారీ ఆయాబి భైయ్యే, తునా దేక్నుకరి భ్హాధర్‍ హిభిరస్‍ కరి బోలు. ");
INSERT INTO vgr_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","ఇనహాఃజే యేసు ఇవ్నా క్హారంతీ దేవ్‍ని వాతేనా ఖమ్జీన్‍, ఇనా కోన్‍ పళ్ళిన్‍ ఛాలస్‍కీ యూవునేస్‍ మారు ఆయా భైయ్యే కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","అజేక్‍ ధన్నె యో ఇన సిష్యుల్‍తీ ధర్యావ్‍నా పార్‍ఛాతే గామ్‍మా జీయ్యే కరి బోలామా, తేదె యూవునే హఃరు యో ఢోంగనా ధక్లీన్‍ ఏజ్గాతు నిక్యా. ");
INSERT INTO vgr_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","ఇన్నె ఢోంగమా జౌంగ్రతొ, యేసు లిందర్‍ లెంకరా. తేదె వ్యారో ఫాణీ ఆయు. డొమ్గమా ఫాణీ భ్హరైజైన్‍ యూవ్నే హఃరు మోటు ప్రమాదంమా అట్కీగయూ. ");
INSERT INTO vgr_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","యినటేకె యువ్నే యేసు కనా ఆయిన్‍, ప్రభూ! ప్రభూ! అప్నే పాణీమా ఢుబిజౌంక్రేస్‍ కరి బోలి వుఠాడ్యు. యో ఉట్టీన్‍ హాత్‍ పాఢీన్‍ వాయిరో పాణీనా గుర్కావమా షోపో హూయుగు. ధర్యావ్‍నూ జూఖాళోబీ గఛ్చుప్‍ హూయుగు. ");
INSERT INTO vgr_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","తేదే యో తూమారు విష్వాసం కేజ్గా కరి సిష్యుల్‍నా పుచ్ఛాయో. యూవ్నే ఢరీజైన్‍ ఆ కోన్కి? వ్యాయ్రో పాణీబి అనివాత్‍ క్హంజుకరస్‍, కరి ఏక్‍తి ఏక్‍ బోల్లీన్‍ ఆష్చర్యంపడు. ");
INSERT INTO vgr_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","యేసు ఇను సిష్యుల్‍ గలీలయనాకంతూ నిఖీన్‍ గేరాసీనియుల్నూ ఇలాహొఃమా ఆయూ. ");
INSERT INTO vgr_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","యో ఉత్రీన్‍ ఆవూస్కర, యో గామ్మాతూ ఏక్జనో యిన హఃమే ఆయో. యో సైతాన్‍ ధర్యోహుయో హూయిన్‍, గణా ధన్తూ లుంగఢాబి నాపేరీన్‍, గోరాఢవ్‍మా తప్ప ఘర్‍మా ర్హవ్వాళొకాహే. ");
INSERT INTO vgr_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","యో యేసునా దేఖిన్‍ ఛికర్‍తోహూయిన్‍, యిన గోఢఫర్‍ పఢీన్‍, ఓ యేసు సర్వన్నహుయేతె దేవ్నొ ఛీయ్యో, మారేతి తునా ష్యాను కామ్‍? మన బాధ నకోకర్‍ కరి తూన బతీమాలుకరూస్‍ కరి ఛిక్రీన్‍ బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","కీమ్‍కతో యేసు, యో దుష్టాత్మా ఇనమాతు భార్‍ ఆవ్‍ కరి ఆజ్ఞా దిదో, యో కేత్రుకీ ధన్‍తూ ఇనమా ధర్తూ రయు. ఇనటేకె ఇన లోఢనీ ఖాకళ్‍తీ గోఢనా భాంధీన్‍ కావ్లికాసీ ర్హైతోబి, ఖాకళ్‍నా తోణ్నాక్‍ధీన్‍, యో దుష్టాత్మా ఇన గోరాఢవ్‍మా బూలాలీన్‍‌ ఛల్‍జై. ");
INSERT INTO vgr_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","యేసు తారు నామ్‍ ష్యాత్‍? కరి ఇనా పుచ్ఛావమా, మారు నామ్‍ సేన కరి బోల్యొ. కతో ఇనమా కేత్రుకీ సైతాన్నిఆత్మ థూ. ");
INSERT INTO vgr_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","యో దుష్టాత్మా ఇనేతి హమ్నా నరకమ్‍మా నొకొనాక్‍ కరి బతీలాఢ్యు. ");
INSERT INTO vgr_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","ఎజ్గా ఏక్‍ గ్హణు మోటు డూకర్‍నూ గుంబల్‍ ఫాఢ్‍నాఫర్‍ ఛరుకర్తుథూ. తేదె యో భూత్‌ హమ్‍నా యో ఢూకర్‍మా బోలిమోకల్‍ కరి యేసునా బతిలాఢమా, ఇమ్మాస్‍ యూవునా ఢూకర్‍మా జావనా ఆజ్ఞా దిదో. ");
INSERT INTO vgr_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","తేదె యో దుష్టాత్మా ఖారు యో అద్మినా మ్హేంధీన్‍ ఢూకరేవ్‍మా పేషీగయూ. తేదె యో ఢూకరే ఖారు, ఫాఢ్‍పర్‍తూహేట్‍ ధర్యావ్‍మా పఢీ మరీగయూ. ");
INSERT INTO vgr_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","ఢూకర్‍ ఛరవాళు జర్యుగూతే ఇన దేఖీన్‍ మిలైలిన్‍, హఃయర్‍మా, గామ్‍మా‌ను అద్మియేనా బోల్యు. ");
INSERT INTO vgr_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","యూవునే హాఃరు జర్‍గ్యూతే ఇన దేఖనా టేకె యేసుకనా ఆయిన్, భూత్‍ మ్హేంధీ ఛలీగూతే అద్మి అషల్ హూయిన్‍, అఛ్చా అద్మీనితర లుంగ్ఢా పేర్లీన్‍, యేసునా గోఢాకనా భేటూతే ఇన దేఖీన్‍ యూవ్నే ఢరీగయూ. ");
INSERT INTO vgr_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","యో కీమ్‍ అఛ్చు హూయోతే, దేక్యూతే అద్మీయే, ఏజ్గా ఆయుతే అద్మీయేనా బోల్యు. ");
INSERT INTO vgr_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","గేరాసీనియుల్‍ను అద్మీయే హాఃరు ఢరీజైన్‍, యేసునా హమారు ఇలాహొఃనా మ్హేంధీన్‍, ఛల్‍జాకరీ ఇన యూవునే బతిమాల్యు. ");
INSERT INTO vgr_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","యో ఢోంగ ఛఢీన్‍ ఛల్‍ జౌంకరత, సైతాన్‍ మాతూ అసేల్‍ హూయోతే యో మేబి తార కేడె ఆవుస్‍, కరి బతిమాలిన్‍ బోల్యు. ");
INSERT INTO vgr_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","యేసు ఇనేతి తూ తార ఘర్‍కనా జైన్‍, దేవ్‍ తునా కేవుడు మోటు అఛ్చు కామ్‍ కర్యోకి క్హారవ్‍నా ఆ వాతేనా బోలీన్‍ మాలంకరవ్‍ కరి ఇన బోలీమోకల్యొ; యో జైన్‍ యేసు ఇన కర్యొతే అఛ్చు కామ్‍నా గామ్‍ అక్కావ్‍నా బోల్యొ. అద్మీయే ఖారు యేసునాటేకె దేకుకర్తూతూ. ");
INSERT INTO vgr_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","యినటేకె యో పాచు ఫరీన్‍ ఆవ్‍స్‍కర యూవునే ఇన బూలైలీదూ, ఆనందంతీ బులాయు. ");
INSERT INTO vgr_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","ఏత్రాస్‍మా సమాజమందీర్‍మనో ఏక్జణో యాయిర్‍ కరి యో ఆయిన్‍ యేసునూ గోఢఫర్‍ పఢ్యొ, ఆనందమతీ ఘర్‍కనా ఆవ్‍కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","మారి ఛోరీ భారవరఖ్‍ఃనీ యో మర్‍జావనీక్లీ కరి యో ఏక్కస్‍ ఛోగిరీ హమ్‍నా ఇన కీమ్‍బీ హమారు ఘర్‍ ఆవ్‍కరీ ఇన బతీమాలాడ్యొ. యో ఇన ఘర్‍కనా జౌంగ్రతో, అద్మీయే హాఃరుబి ఇనకేడె జాతుహూయిన్‍ ఇన ఉఫర్‍ పఢ్తూ ర్హయూ. ");
INSERT INTO vgr_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","తేదే ఏక్‍ బాయ్‍కొ భార వరహ్‍ఃక్తి ల్హొయి చుటనూ రోగ్‍తీ థీ. యోఛొగిరి అష్యల్‍ కరనా దవా వాలను హాత్‍బి కోహూయుని. ");
INSERT INTO vgr_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","ఇనటేకె యో బాయికొ యేసునా పీటేతూ ఆయిన్‍, ఇను లుంగ్డనా తెదేస్‍ ఇను ల్హొయి ఝడనూ రోగ్‍ నయం హూయుగు. ");
INSERT INTO vgr_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","మన ఛీమ్యుతే కోన్కరీ యూవునా పుఛ్చావమా, క్హారు జణు హమ్నా మాలంకోయిని కరి బోల్యు. తేదే పేతురు ప్రభు జనం ఖారుబి ధకల్తూహూయిన్‍, తార ఉఫరస్‍ తో పఢుకరస్‍నీ, కోన్‍ కరి బోల్‍స్యు. ");
INSERT INTO vgr_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","యేసు, కోన్‍కీ మన ఛీమ్యు, ఇనటేకెస్ మార మతూ రోగ్‍నా అసేల్‍ కరనూ షక్తి భాధర్‍ గయు, కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","తేదే యో భాయిక్వొ ఛీమీతే వాత్‍ మాలంపడ్‍స్యేకోయిన్తే కోరసేని కరి, ఢర్‍తీ హూయిన్‍ ఆయిన్‍ యేసు గోఢఫర్‍ పఢీన్‍ ఖాలామ్‍ కరీన్‍, యో ష్యాన టేకే ఇన ఛీమీకి, తేదేస్‍ యో కీమ్‍ అసేల్‍ హూయికీ ఖారవ్‍నా ఖామే బోలి. ");
INSERT INTO vgr_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","ఇనటేకే యేసు తేదే ఛోరి, తారు విష్వాస్‍ తున అష్యల్ కర్యు కరి బోలిన్‍ సమాధానంతీ ఘర్‍కనా జాకరీ ఇనేతి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","యో ఉజున్‍భి వాతే బోలు కరతో, న్యావ్‍నుజొగొనూ మోటొ యాయిర్‍నూ ఘర్‍మతూ ఏక్‍ అద్మి ఆయిన్‍, తారీ ఛోరీ మరీగి అజు ప్రభును దీల్‍ నకొ ధూక్కావో కరి ఇనేతి బోల్యు. ");
INSERT INTO vgr_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","యేసునే యో వాతేన్‍ ఖమ్జీన్‍ ఢరోనకో విష్వాస్‍ ర్వాకో, తారి ఛోరి అసేల్‍ హూసేకరీ ఇనేతి బోలిన్‍, ");
INSERT INTO vgr_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","ఇన ఘర్‍కనా ఆవదీన్‍ పేతురు, యోహాన్‍, యాకోబునా, అజు యో ఛోగిరిని ఆయా భా న, యూవున తప్ప బుజు కీనాబి మై బూలాలీన్‍ గయు కోయిని. ");
INSERT INTO vgr_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","ఖారు జణు యో ఛోగిరినా టేకే ఛాతీ పోళ్‍లేతూహూయిన్‍, రోతూహూయిన్‍ రవ్హామా, యో యూవ్నేతీ, రోవో నకో, యో ఛోగిరి ఖూతీస్‍ పణికి మరీకోయిని కరి యూవ్నేతీ బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","యో చొరిగి మరీగయి కరి మాలంహూయుతే యూవ్నే యేసు గేలి కాడ్యు. ");
INSERT INTO vgr_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","తేదే యేసు యో ఛోగిరినూ హాత్‍ ధరీన్‍ ఓ ఛోగిరి వూట్‍కరీ బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","ఇను జాన్‍ పాచు ఆయిన్‍, యగ్గీస్‍ వూట్టీన్‍ గయి. యేసు యూవ్నేతీ ఇన ఖ్హావనా ష్యాత్‍బి దేవో కరీబోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","ఇని ఆయా భా ఇన దేఖీన్‍ అష్చర్యంపఢ్యు. ఆ జర్‍గ్యుతే హాఃరు కీనాబీ నకో బోలో కరి యూవ్నేతీ ఆజ్ఞాదీన్‍ బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","యేసు ఇన భారజణా సిష్యుల్నా బులైన్‍, దుష్టాత్మా హాఃరవ్‍ఫర్‍ అధికార్‍, బుజు రోగ్‍న దూర్‍కరను షక్తిబి, యువ్నా దిదో. ");
INSERT INTO vgr_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","దేవ్‍నూ రాజ్యంనూ వాతే ప్రచార్‍కరనా రోగుల్‍నా అసేల్‍ కరనటేకె యూవునా బోలిమోకల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","తెదె యో బోల్యొ; తూమే జవానటేకె హాత్‍నూ లాక్ఢుతోబి, సంఛితోబి, ఖావనటేకె రోటొతోబి, రూపుతోపు, బుజు, అజు ఖయ్యూబి నాలీన్‍జానూ; బే లుంగ్డాన నొకొరాకో కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","తుమె కేహూ ఘర్‍కనా జాసూకీ, యో గామ్‍ మ్హేంధీజావతోడీ యోస్‍ ఘర్‍కనా ర్హవో. ");
INSERT INTO vgr_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","తుమ్నా కోన్‍బీ చేర్చావ కొయినికీ, కోన్బి నాఖమ్జీన్‍, తూమ్‍నా కంధే నాకర్యుతో, యో గామ్‍మతూ ఛల్‍జవానూ వోహఃత్‍, యువ్నా ఉఫర్‍ సాక్చంనితర రవ్హానాటేకె, తూమారీ గోఢనీ దూళ్‍నా జట్కీ నగ్‍దేవో, కరి ఇవ్నేతి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","తేదె యువ్నేఏజ్గాతు నిక్లీన్‍ గామ్‍మా జైన్‍, సువార్తనా బోల్తూహూయిన్‍, రోగ్‍ వాళానా అషల్ కర్తుహూయిన్‍ గయూ. ");
INSERT INTO vgr_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","చతుర్థాధిపతి హుయోతె హేరోద్‍ జర్‍గ్యుతే క్హారు క్హంమ్జీన్‍, ఘణు గ్హబ్రాయిగయో. ష్యానకతో థోడు అద్మీయే మరీగయోతే బాప్తిస్మమ్‌ దేవవాలో యోహాన్‍ పాచు జీవిన్‍ ఆయో కరి. ");
INSERT INTO vgr_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","అజు థోఢు అద్మీయే ఏలీయా దేఖాయోకరీ, ఉజు థోఢు అద్మీయే జమానమనూ ప్రవక్తల్‍మా ఏక్‍జణో జీవిన్‍ ఆయో కరి బోల్లీదూ. ");
INSERT INTO vgr_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","తెదె హేరోదు, మే యోహాన్‍నూ ముఢుక్యు ఖాత్రాయి నగ్‍దిదోని “బుజు కీని వాతే బోల్లేంగ్రస్‍ కరి బోలీన్‍ యో కోన్‍కీ దేక్‍నూ కరి రైగో.” ");
INSERT INTO vgr_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","అపోస్తుల్‍ ఫరీన్‍ ఆయిన్‍, ఇవ్నే కర్యాతే హాఃరు యేసుతి బోల్యా, తెదే యో బేత్సాయిదా కరి బోలాతే ఏక్‍ గామ్మా, కోన్‍ కోయిన్తే జోగోమా బులాలీన్‍ గయో. ");
INSERT INTO vgr_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","ఆహాఃరు జనాభో మాలంకర్లీన్‍, ఇనకెడేస్‍ జావమా, యో ఇవ్నా చేర్చాలీన్, దేవ్ని రాజ్యంనీ గూర్చి వాతె బోల్తొహూయిన్‍ రోగ్‍ హువ్వాలన, రోగ్‍మాతీ ఇవ్నా అషల్ కర్యో. ");
INSERT INTO vgr_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","హఃమీ హాఃజే హూవమా భార సిష్యుల్‍ ఇనకనా ఆయిన్‍, అప్నే జాఢిమఛియ్యె, ఇనటేకె గామ్మా జైన్‍, ఖ్హావనా ఖ్హాణుబి, ఆరామ్‍ లేవనా జొగో దేఖిలిసే జనం బోలీమోకల్‍ధా కరి బోల్యు. ");
INSERT INTO vgr_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","యేసు “తూమేస్‍ ఇవ్నా ఖ్హాణు ఖ్హఢావోకరి బోలామా, ఇవ్నే హమారకనా ఫాఛ్‍ రోటా, భే మాస్లా తప్ప బుజు కాయిబి కోయిని ఆవ్నా ఖ్హాణు ఖఢావనా హమే జైన్‍ ఖ్హాణూ మోల్‍ లీన్‍ ఆయేనా” కరి బోలు. ");
INSERT INTO vgr_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","ఆయ్రూతె అద్మీయేమా ఇన్చు మిన్చు పాచ్‍హాజార్‍ మరద్మాన ఛా. యూవ్నా గుంపునితరా అఢైహ్ః అద్మీయేనా వరుసగా బేక్హాడొ, ");
INSERT INTO vgr_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","కరి యో ఇవ్నా బోలామా, యూవ్నే ఇమ్‍ కర్యు. ");
INSERT INTO vgr_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","తేదె యో ఫాచ్ రోటో, బే మాస్లానా లీన్‍ ఉఫర్‍ పాఢీన్‍, ఆకాష్‍ మ్హణీ దేఖిన్‍ ఇన ఆసిర్వదించీన్‍, తోడీన్‍ జనం ఖారౌన నాఖనాటేకె ఇన సిష్యుల్‍నా దిదో. ");
INSERT INTO vgr_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","యూవ్నే క్హారు పేట్‍ భరీన్‍ కైన్‍ మిగ్లిహుయుతే రోటానూటూక్డా భార టోక్రా పాఢ్యు. ");
INSERT INTO vgr_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","ఏక్‍ ఒహాఃత్‍ యేసు ఏకేలో ప్రార్ధన కరుకరతో, ఇన సిష్యుల్‍బి ఇనాకనా ఆయు. “మే కోన్‍ కరి జనం బోల్‍లేంగ్రస్‍?” కరి పుఛావమా, ");
INSERT INTO vgr_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","యూవ్నే, థోడు అద్మియే బాప్తిస్మమ్‍ దెవ్వాళొ యోహాన్‍ కరి, బుజు థోడు జణు ఏలియా కరి, బుజు థోడు జణు జమానాను ప్రవక్త జీవిన్‍ ఆయో కరి బోల్‍లేంగ్రస్‍ కరి బోల్యు. ");
INSERT INTO vgr_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","ఇనటేకె యో, తూమే మే కోన్‍ కరి ర్హైజంకరస్ కరి బోలామా, పేతురు తూ దేవ్‍ బోలిమోకల్యొతే క్రీస్తు కరి బోల్యు. ");
INSERT INTO vgr_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","ఆవాతే కీనాబి నకోబోలో కరి ఖఛ్చితంగా యూవ్నేతీ బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","అద్మినో ఛియ్యో కెత్రూకి మిన్హత్‍ పఢీన్‍, మోటవ్‍నూ, యాజకుల్‍నూ, షాస్ర్తుల్‍నూ హత్‍మా ఛీ కరి బోలైన్‍, యువ్నా హత్‍మా మరిన్‍ తీన్‍మన్‍ ధన్నే జీవిన్‍ వూట్‍స్యేతె హాఃఛికరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","బుజుబి క్హారవ్‍తీ యో ఆమ్‍ బోల్యొ. కోన్‍బి మార కేడె ఆవ్‍నూ కరి దేఖ్హావళు ఇను యో ఉపేక్చించిలీన్ఆ, హర్‍ ఏక్‍ ధన్‍ ఇను సిలువ పళ్ళీన్‍, మార కేడె ఆవ్‍నూ కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","ఇను జాన్‍ భఛయ్‍లేనూ కరి దేఖ్హావళు ఇను జాన్‍నా గమైలీసే. మారటేకె ఇను జాన్‍నా గమైలేవళు ఇను జాన్‍ భచాయ్‍లీసే. ");
INSERT INTO vgr_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","ఏక్‍జణో లోకంమనూ ఖారు కమైన్‍, ఇను జాన్‍ గమైలిదొతొ, ఇను యో నుక్సాన్‍ కర్‍లీదూతో ఇన ష్యానూ ఫైధో? ");
INSERT INTO vgr_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","మారటేకె మారీ వాతే బోలానా టేకె షరం ఖ్హావళు కోన్‍కీ, ఇనటేకె అద్మీనొ ఛీయ్యో ఇనూబి, ఇనూ భా నూబి, ఇనూ దూతల్‍నూ మహిమతీ ఆవ్‍తి వోఖాత్‍ యోభి షరంఖ్హాసే. ");
INSERT INTO vgr_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","ఏజ్గా హిబిర్యూతే అద్మీయేమా థోడు అద్మి దేవ్‍ని రాజ్యంనా దేహఃతోడి యూవ్నే మర్‍స్యే కోయినికరీ, మే తూమారేతి హాఃఛితి బోలుకురూస్. ");
INSERT INTO vgr_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","ఇమ్‍ వాతే బోలీన్‍ ఆట్‍మనే ధన్నా భాద్‍మా పేతురు, యాకోబు, యోహాన్‍నా యేసునకేడె ప్రార్దన కరనా ఏక్‍ పాఢ్‍ఫర్‍ బులాలీన్‍ గయో. ");
INSERT INTO vgr_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","యో ప్రార్ధన కరుకరతొ ఇను మోఢనూ రూప్‍ భద్‍లీగయు. ఇన లుంగడాబి ధోళుఫట్‍ జమ్ఖనిక్‍ళ్యు. ");
INSERT INTO vgr_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","తేదె ఇన బే జణా ధేఖైన్‍ వాతే బోలాలగ్యూ. యూవ్నే మోషేబి, ఏలీయా. ");
INSERT INTO vgr_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","ఇవ్నే ఇనా మహిమతి దేక్హాయిన్‍, యోరూషలేమ్‍మా జరగజాసేతె లేఖనల్‍ నేరావేర్నుతిమ్‍, సాత్‍కతో ఇను మరణ్‍నూ గురీంచీన్‍ వాతే బోల్యు. ");
INSERT INTO vgr_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","తేదె పేతురుబి, ఇనకేడె రవ్హాళు ఖారు అచ్చు లీంధర్‍నూ మగ్నేమా థూ. యూవ్నా హోషార్‍ ఆయిన్‍ వూటీన్‍ ధేఖ్హామా, యేసు నూ మహిమానాబి, ఇనా కెడెఛాతే యో బేజణనాబి ధేక్యూ. ");
INSERT INTO vgr_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","మోషెబి, ఏలీయా యేసుతి వాతే బోల్దిన్‍, ఇవ్నె ఛల్‍జౌంగ్రతొ, పేతురు యేసుతి ప్రభు అపేణె అజ్గాస్‍ రవ్హను అసేల్‍. తున ఏక్, మోషెనా ఏక్, ఏలియానా ఏక్ గుడీ భాంధీయేస్‍ కరి బోల్యు. యూవ్నే ష్యాత్‍ బోలుకరస్‍కీ ఇనా మాలంకోయిని. ");
INSERT INTO vgr_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","యూవ్నే ఇమ్మస్‍ వాతే బోలుకరతో, ఏక్‍ మబ్బు ఆయిన్ యూవ్నాఫర్‍ ఢఫాయ్‍గయూ. ఇమ్‍ ఢపావ్‍తీ వోఖత్‍ యూవ్నే గణు ఢరీగయూ. ");
INSERT INTO vgr_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","యో మబ్బుమాతు ఏక్‍ ఆవాజ్‍ ఆయు. “ఆ మారో ఛీయ్యో, మే యమ్ఛీ రాక్యోతే మారో ఛీయ్యో.” యో బోలా తీమ్మస్‍ తూమే క్హామ్జో కరి బోలు. ");
INSERT INTO vgr_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","యో వాతేనూ ఆవాజ్‍ బొలిన్‍ హూయిజవాదీన్‍, తేదె యువ్నా యేసు ఏక్కాస్‍ దేఖ్హావస్‍. తేదె యూవ్నేసాత్‍ దేఖ్యుకీ యోకీనాబి కోబోల్యుని. ");
INSERT INTO vgr_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","ఇనా బేమన్‍న ధన్నే ఇవ్నే ఫాఢ్‍పర్‍తూ హేట్‍ ఉత్రీన్‍ ఆవదీన్‍, యేసునా టేకే జనం క్హారు ఆయిరూథూ. ");
INSERT INTO vgr_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","యో జనంమతూ ఏక్‍జనో బోధకుడ్‍ మార ఛీయ్యోనా భఛవ్‍కరీ తునా బతీలాఢుకరుస్‍, యో ఏక్కాస్‍ ఛీయ్యో మనా. ");
INSERT INTO vgr_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","ఇన ఏక్‍ దుష్టాత్మా ధ్హరాక్యుస్‍, ఇమ్‍ ధ్హర తేదె మారో ఛీయ్యో గణు మోటు ఛిక్‍రాణ్‍ మ్హేంధీన్‍, మోఢమాతు బురుగు కాఢస్, యో దుష్టాత్మా ఇన ధడసామరక్హాకు కరీన్‍ థఖ్హావస్‍, ఇన మ్హేంధీకోజౌంగ్రనీ కరి బోలు. ");
INSERT INTO vgr_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","తార సిష్యుల్‍నా యో దుష్టాత్మానా కాఢోకరీ బోలమా, యూవ్నా హాత్‍బి కోహూయుని. కరి బోలామా. ");
INSERT INTO vgr_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","ఇనటేకె యేసు విష్వాస్‍ కొయిన్తే పిఢిను బుద్దు అద్మీయే, అజు కెత్రధన్‍ తూమ్‍నా హాఃమళ్‍ను, వుజు తుమారకెడె ర్హయిస్? కరీబోలీన్‍, తార ఛీయ్యోనా అజ్గ లీన్‍ ఆవ్‍ కరి ఇనేతి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","ఇన బులైల్యాంగ్రతో తెదె యో వాయిరోనూ చంధ్‍ ఇనా ఛోగర్వాన హేట్‍ ఫట్‍ఖైన్‍ తర్ఫాడయు తేదె యేసు యో వ్యారోను చంధ్‍నా గుర్‍ఖైన్‍, ఛోగర్వాన అసేల్‍ కరీన్‍, ఇన భా న హాత్‍మా ధరాయో. ");
INSERT INTO vgr_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","దేవ్‍ కర్యోతే మహిమనా దేఖిన్‍ హాఃరు హషం హూకరత. యేసు ఇనా సిష్యుల్‍తి ఆమ్‍ బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","ఆ వాతే అసేల్‍నితర ఖమ్జో, అద్మినొఛియ్యో అద్మినా హాత్‍మా ధరావ్‍సే కరి బొల్యొ ");
INSERT INTO vgr_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","యో వాతేనూ మతలబ్‍ యూవ్నా మాలంకోహూయుని. ఇనటేకె ఇను మతలబ్‍ లఫిరైయూ. యూవ్నే యో వాత్‍ యేసుతిబి పూఛావనాబి యూవ్నే ఢరీగయు. ");
INSERT INTO vgr_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","సిష్యుల్‍ ఖరవ్‍మా కోన్‍ మోటు కరి యో వాత్‍ఫర్‍ యూవ్నామా లాడైయ్‍హూయు. ");
INSERT INTO vgr_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","యేసు యూవ్నూ దీల్‍మనూ వాతే మాలంకర్లీన్‍, ఏక్‍ అఢ్డానీ లఢ్‍కాన బులైన్‍ ఇవ్నా ఇచ్మా వుభార్హకాఢీన్‍, ");
INSERT INTO vgr_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","ఆ అఢ్డాని లఢ్‍కాన మారు నామ్‍తి కోన్‍ కంధేకర్‍లేస్‍కీ, యో మనబి కంధే కర్‍లీసే. మన కంధే కర్‍లేవళు మన బోలీ మోక్‍ల్యుహూయుతే ఇనాబి కంధేకర్‍లీసే. తూమారమా కోన్‍ తగిమ్చిలిన్‍ ర్ఖస్‍కీ యోస్‍ హాఃరాతి మోటో హుయిన్‍ ర్హాసే కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","తేదె యోహాన్‍ మాలిక్‍ కోన్‍కీ ఏక్‍ అద్మి తారు నామ్‍తీ దుష్టాత్మానా నహాఃడుకరతో మే ఏక్‍నా దేఖ్యో, హమే ఇన ఇమ్‍ నకోకర్‍ కరి బోల్యా యేసు, యో అప్నా గలోమను కాహే. ");
INSERT INTO vgr_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","ఇనటేకె యేసు తూమే ఇన ఆఢు నకో బోలొ, తూమ్‍నా ధావో దూష్‍మన్‍ కరకోయిన్తే అద్మి తూమారు బాజుస్‍ ర్హవాళు, కరి యూవ్నేతీ బొల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","యో పరలోకమ్మా జావనూ ధన్‍ కంధే ఆవ్‍మ్గ్రతో, యెరూషలేమ్‍ జాను కరి దిల్మా సోఛీల్దో. ");
INSERT INTO vgr_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","ఇనేతి అగడీ అద్మియేనా బోలిమోక్‍ల్యొ. యూవ్నే జైన్‍ యేసునా టేకె ఖారు తయార్‍ కరనా సమరయుల్‍నూ గామ్‍మా గయూ. ");
INSERT INTO vgr_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","యో యెరూషలేమ్‍ జవనా దేఖమా సమరయుల్‍ ఇనా అంగికరించు కోయిని. ");
INSERT INTO vgr_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","ఇనా సిష్యుల్‍మా యాకోబుబి, యోహాన్‍ యో ఖారు దేఖీన్‍, ప్రభు యూవ్నా భళ్ళాక్హీన్‍ భర్‍బాత్‍ కరనా ఉఫర్‍తూ ఆగ్‍ ఉత్రీన్‍ ఆవ్‍ కరి బోలీయేనా? కరి బోల్యా. ");
INSERT INTO vgr_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","తేదె యో యూవ్నామణీ ఫరీన్‍ ఇవ్న గుర్‍ఖ్హాయో. ");
INSERT INTO vgr_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","యేసు ఇనా సిష్యుల్‍, అజేక్‍ గామ్‍ జావుంకరామా. ");
INSERT INTO vgr_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","యో వాట్‍ఫర్‍ చాలుకరతో, ఏక్‍ జణో “తూ కేజ్గా గయోతోబి మేబి తార కేడె ఆవుస్‍” కరి ఇనెతీ బోల్యు. ");
INSERT INTO vgr_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","ఇనటేకే యేసు న్హోరియే రవ్హనా భండనూ ఘవియే ఛా, ఊడవాళు జీన్వార్‍ నాబి జోగొ ఛా. ఫణీకి అద్మీనో ఛీయ్యోనా మూఢుక్యు టేకానభి జోగో కోయిని కరి ఇనేతి బోల్యు. ");
INSERT INTO vgr_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","యేసు అజేక్‍ జణాతీ మరా కేడే ఆవ్‍ కరి బోలామా, యో “మే జైన్‍ అగడీ మారు భా ను గోరాఢూ గాఢీన్‍ ఆవానా అనుమతి దా” కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","ఇనటేకె యో “మర్యూహుయు అద్మియే యూవ్నూ మరీహుయూనా గల్లిసే; తూ జైన్‍ దేవ్‍ని రాజ్యంని వాతే ప్రచార్‍ కర్‍” కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","అజేక్‍ జణొ ప్రభు మే తారకేడె ఆవుస్‍ పన్కి మారు ఘర్‍నూ అద్మినా బోల్దీన్‍ ఆవ్‍స్‍ కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","యేసు, “నాగళిఫర్‍ హాత్‍ మ్హేంధీన్‍ ఫీటే ఫరీన్‍ దేఖ్హావళు దేవ్‍నూ రాజ్యంనా లాయక్‍ కోయిని” కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","ఇనబాద్మా ప్రభు హఃడ్తినిఖ్ అద్మి అలధా సిష్యుల్‍నా జోడ్‍కరీన్‍, యో జవజాసేతే హర్‍ఏక్ గామ్‍మా, హర్‍ఏక్‍ జోగొమా ఇనేతి అగడీ బె భ్బేజణాన బోలీమోక్‍ల్తోహూయిన్‍ ఆమ్‍ బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","వాఢనా ఖేతర్‍ ఘణు ఛా, పన్కి కామ్‍ కరవాళు అద్మియే కమ్‍ ఛా. ఇనటేకె ప్రభు కామ్‍ కరవాలన బోలీమోకల్‍టేకె ప్రార్దన కరో. ");
INSERT INTO vgr_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","తూమే జవో! హఢనా ఇచ్మా మ్హేండొను చెల్కావ్‍నా బోలీమోక్‍లా తీమ్‍ తూమ్‍నా బోలీమోక్లుకరూస్‍. ");
INSERT INTO vgr_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","తూమే రఫ్యాతోబి, సంఛీయేతోబి, ఛేప్పల్‍తోబి నకో లీన్‍ జవో. వాట్‍ఫర్‍ కీనేతీబి వాతే లగాడ్‍లీన్‍ సమయంనా నుక్సాన్‍ కరో నకో. ");
INSERT INTO vgr_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","తూమే కీనూ ఘర్‍ కనా జాస్‍కీ యో ఘర్‍నా సమాధానం హూనుకరీ బోలొ. ");
INSERT INTO vgr_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","సమాధానం హూవానూ దీల్‍వాళో ఎజ్గా ర్హయూతో యూవునే సమాధానం హూసే, నా రైయ్యూతో యో సమాధానం తూమార కేడెస్‍ ఆయిత్రేస్యే. ");
INSERT INTO vgr_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","తూమే ఖ్హాయ్యూ ఘర్‍మా జాస్‍కీ యోస్‍ ఘర్‍మా ర్హవో. యూవ్నే ష్యాత్‍ దేస్‍కీ యోస్‍ క్హవో పియో. పణీకీ ఘర్‍ ఘర్‍మా నకో ఫరో. కామ్‍ కరవాళు యూవ్నూ షమ్‍ళమ్‍నా పాత్రుడు. ");
INSERT INTO vgr_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","అజు తూమే హాఃయ్యూ హఃయార్‍మా జాస్‍కీ, ఏజ్గానూ అద్మీయే తూమ్‍నా ష్యాత్‍ దేస్‍కీ యోస్‍ ఖ్హావో. ");
INSERT INTO vgr_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","ఏజ్గా ఛాతే రోగ్‍వాళాన అష్యల్‍ కరో, దేవ్‍నూ రాజ్యం తుమార కంధే ఆవ్‍స్యే కరి యూవ్నేతీ బోలొ. ");
INSERT INTO vgr_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","తూమే ఖ్హాయ్యూ ఖయార్‍మా జాస్‍కీ, ఏజ్గా తూమ్‍నా కంధే నాకర్యుతో తూమే యూవ్నూ గల్లీయేమా జైన్‍ యూవ్నేతీ హమార గోఢానా లగ్గ్యూతే తూమార గామ్‍ని ధూళ్‍నీ మాటీబి తూమార ఖమేస్‍ జట్కీనగ్‍ దేంగ్రేస్‍ కరి బోలొ ");
INSERT INTO vgr_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","హధేకో దేవ్‍నూ రాజ్యం కంధే ఆయిత్రగ్రస్‍ కరి మాలంకర్లేవో. ");
INSERT INTO vgr_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","న్యావ్ను ధన్నె ఆహాఃయార్‍నూ గతీతిబి సొదొమా హాఃయార్‍నూ గతీ యో ధన్‍మా షీక్చా కరి తూమారేతీ బోలుకరూస్‍. ");
INSERT INTO vgr_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","అయ్యో కోరజీనా! అయ్యో బేత్సయిదా! తూమారటేకే కర్యతే అధ్బుతాల్‍ తూరు సీదోను ఖయార్‍మా కర్యాహోత్‍తో ఏజ్గానూ అద్మీయే తేదేస్‍ చయినూ గోతం బాందిలిన్ రాక్‍ నక్‍లీన్‍ దీల్‍ భద్‍లాయిలీదు హోత్‍. ");
INSERT INTO vgr_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","న్యావ్ను ధన్నె తూరుసీదోన్ అద్మీయేతీబి తూమ్‍నస్‍ గణు దయావతాల్‍సే కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","ఓ కపెర్నహూమ్‍ వాజుళు ఏత్రె ఉఫర్‍ సోఛీలేంగ్రస్‍నా? పాతాళంమా ధక్‍లాయిజైస్‍. ");
INSERT INTO vgr_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","తూమారీ వాతే ఖమ్జావాళు, మారీ వాతే ఖమ్జాసే. తూమ్‍నా దూర్‍ కరవాళు, మనాబి దూర్‍ కర్షే. మన దూర్‍ కరవాళు, మన బోలిమోక్‍ల్యూతే ఇనాబి దూర్‍ కర్షే. ");
INSERT INTO vgr_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","యో ఖఢ్‍తీలిఖ్ అద్మియే సిష్యుల్‍ ఫాఛు ఫరీన్‍ ఆయిన్‍, దుష్టంత్మాన తారు నామ్‍తీ హమ్‍నా దేఖీన్‍ హమారీ వాతే ఖమ్జుకరస్‍, కరి బోలు. ");
INSERT INTO vgr_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","యేసు, దుష్టంత్మాబి ఇజ్లీనితర వాజ్లామతూ హేట్‍ ఫఢమా మే ధేఖ్యో. ");
INSERT INTO vgr_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","హధేక్‍ క్హాప్‍నా ఈఛ్చీయేనా కుమ్దలనాటేకే, వైరేవ్‍నూ బలంనా ఉఫర్‍ తూమ్‍నా సర్వధికార్‍ ధీరాక్యోస్‍; ఖయూబి తూమ్‍నా కాయ్‍బి కర్షే కోయిని. ");
INSERT INTO vgr_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","రైతోబి దుష్టంత్మాబి తూమ్‍నా ధేఖిన్‍ లోబాడుకరస్‍ కరి, ఖ్హూషీ నకో హూవో; తూమారు నామ్‍ పరలొకంమా లీఖైరూస్‍ కరి ఖ్హూషీ హూవొ. ");
INSERT INTO vgr_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","తేదెస్‍ యేసు పరీసుద్ధాత్మ కనా ఖుషీ హూయిన్‍, భా ఆకాష్‍నా, ధర్తినా దేవ్‍ హూయిరోతే ప్రభూ తూ అఖ్కాల్‍ వాళాన, అఖ్కాల్‍తీ సోఛావళానా ఆవాతే మాలం నా హూనుతిమ్‍ లఫఢీన్‍ రాకీన్‍, అఢ్డానీ లఢ్‍కాన మాలంకరయో, కరి తూన స్తూతించూకరూస్‍; హోలా భా, ఇమ్‍ కరను తార ఢోలాన అసేల్‍ ధేఖ్హయూ. ");
INSERT INTO vgr_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","సమాస్తంబి మారు భాను హత్‍ఖూ మనా దేవావ్‍రూస్‍, ఛీయ్యో కోన్‍కీ భా న తప్ప కీనాబి మాలంకయిని, ఛీయ్యో కీనా బోలస్‍కీ యూవ్నా తప్ప ఇన భా కోన్‍కీ అజు కీనాబి మాలంకోహూసేని. ");
INSERT INTO vgr_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","తెదె యేసు సిష్యుల్‍ భహణెఫరీన్‍ తూమే ధేఖ్హూకరస్‍తే ఇన ధేఖ్హూకరతే తుమార ఢోలా ధన్యత హుయురూస్‍. ");
INSERT INTO vgr_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","కెత్రూకి ప్రవక్తల్, రాజుల్‍ తూమే దేక్నుకరిసోచిలీన్‍ యూవ్నా దేఖనా కోహూంగ్రనీ. తుమే హఃమ్జుకరతే ఇన యూవ్నేబి ఖమ్జ్నూ కరి దేఖిన్‍బి యూవ్నా ఖమ్జానా కోహూంగ్రనీ కరి యూవ్నేతీ కీనా మాలంనాహూను తీమ్‍ బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","ఏక్‍ జణో ధర్మషాస్ర్తం బోలీ దేవళో వూటీన్‍, బోధకుడ్ నిత్యజీవంనా వారసుడ్‍ హూనుకతో హమే ష్యాత్‍ కర్నూ కరి యేసుతి పూఛాయు. ");
INSERT INTO vgr_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","ఇనటేకె యేసు ధర్మషాస్త్రంమా షాత్‍ లీఖైరూస్‍ కరి పూఛాయో తునా కిమ్‍ అర్థంకరి ర్హాక్యాస్‍, కరి పుఛ్చాయో. ");
INSERT INTO vgr_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","యో, తారో దేవ్‍హూయిరోతే ప్రభునా తారు పూరా దీల్‍తి, పూరా మనస్సుతి, పూరా బుద్దీతీ, పూరా తాఖ్హాత్‍తీ, ఫ్యార్‍ కర్‍నూ. ఎత్రేస్‍ కాహే తున తూ కింమ్‍ ఫ్యార్‍ కరస్కి, ఇమ్మస్‍ పార్లేవ్‍నాబి ఫ్యార్‍కర్‍నూ నిఖైరూస్‍ కరి బొల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","యేసునే, తూ అష్యల్‍ బోల్యొ; తూ ఇమ్‍ కర్‍ తేదె తూ జీవిస్‍ కరి ఇనేతి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","తేదె యో నీతీనూ అద్మికరి సాబుత్‍ హూవనాటేకె యో, యేసునా హమారు పార్లూ కతో కోన్‍ కరి పూఛాయో. ");
INSERT INTO vgr_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","ఇనటేకె యేసు ఆమ్‍ బోల్యొ ఏక్‍ అద్మి యెరూషలేమ్‍మతూ యేరీకోనూ క్హాయార్‍మా జౌంగ్రతో థో, చోట్టావ్‍నూ హత్‍మా ధరైన్‍, ఇనకనా ఛాతే క్హారు ఛీనాయ్‍లీన్‍, ఇన మారీన్‍ వాట్‍ఫర్‍ మ్హేంధీదూ, యో అఖరీనూ జాన్‍తీ పఢ్యూరుథూ. ");
INSERT INTO vgr_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","తేదె ఏక్‍ యాజకుడ్‍ యోస్‍ వాట్‍ఫర్‍ కరి జాతూహూయిన్‍, యో మార్‍ ఖైన్‍ పఢ్యూరుతే ఇన దేఖీన్‍, ఫార్‍కరీన్‍ యేఢీన్‍ ఛలీగూ. ");
INSERT INTO vgr_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","లేవీనూ ఏక్‍అద్మీబి ఇమ్మస్‍, యోస్‍ వాట్‍ఫర్ జాతోహూయిన్‍ యో అద్మినా దేఖీన్‍ యేఢీన్‍ ఛలేగో. ");
INSERT INTO vgr_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","పణీకీ ఏక్‍ సమరయుడ్‍ మాత్రం యోస్‍ వాట్‍ఫర్‍ జాతూహూయిన్‍ యో మార్‍ ఖైన్‍ పఢ్యూరుతే ఇన కనా ఆయిన్‍, ");
INSERT INTO vgr_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","ఇన దేఖీన్‍ గోర్‍ ఖైన్‍, కంధే జైన్‍ యో మార్‍ లగ్గ్యూతే జోగొమా తేల్‍బి ద్రాక్చనూ రఖ్‍ లగాఢీన్‍ కట్టు భ్హాంధీన్‍, ఇనా ఇని గధేఢో ఫర్‍ ఛఢైన్‍, ఏక్ సత్రంమా బూలాలీన్‍ గయో. యో ఇన అసేల్‍ కరనా టేకె యో సత్రంనూ యాజమానినా బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","భేమన్‍ ధన్నేబి బే రూపనూ దేనారమ్‍ దీన్‍, ఆన అసేల్‍తీ దేఖ్, అజు ష్యాత్‍బి గణు ఖర్చు హూయితొబి, మే అజేక్‍ ధన్నే ఆయిన్‍ దీస్‍ కరి బోలిన్‍ ఛలేగో. ");
INSERT INTO vgr_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","తేదె యేసు ఆవాతే బోలీన్‍, చోట్టావ్‍నా హత్‍మా ధరైన్‍ మార్‍ ఖ్హాదోతే, ఇన ఆ తీన్‍ జణామతూ కోన్‍ ఇనూ పార్లు కరి సోచుకరస్‍? కరి పూఛావమా యో ఇనఫర్‍ గోర్‍ ఖైన్‍ ఇన అసేల్ కర్యూతేస్‍ అద్మికరీ బోల్యు. ");
INSERT INTO vgr_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","ఇనటేకె యేసు తూభి జైన్‍ ఇమ్మస్‍ పార్లేవ్‍ నటేకె కర్‍ కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","ఏత్రస్మా యూవ్నే ఛాలీన్‍ జాతాహూయిన్‍, ఏక్‍ గామ్‍మా గయా. మార్త కరి ఏక్‍ భాయికో ఆయిన్‍ యేసునా ఇన ఘర్‍మా అహావనించి. ");
INSERT INTO vgr_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","యో మార్త నా మరియ కరి ఏక్‍ భేనెబి థీ. యో యేసునా గోఢకనా బేసీన్‍ ఇని వాతే హామ్జు కర్తీతి. ");
INSERT INTO vgr_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","పన్కి మార్తనా కేత్రుకి ఘర్‍నూ కామ్‍ రవ్హామా చీమ్తా హుయిన్‍, ప్రభు కనా ఆయిన్‍‍, మారీ భేనె కామ్‍ అక్కు మార ఏక్కాస్‍ జణీఫర్‍ మ్హేంధీదితే తూనా న్యాయామస్‍న్నా? యో ఆయిన్‍ మనా మధత్‍ కర్‍ కరి బోల్‍, కరి బోలి. ");
INSERT INTO vgr_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","ఇనటేకె ప్రభు మార్త, మార్త తూ కేత్రుకీ కామ్‍నాటేకె సోస్తీహూయిన్‍, గబ్రావ్‍తిహూయి ర్హాస్‍. ");
INSERT INTO vgr_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","హాఃఛకనా కర్నూతేబి ఎక్కస్‍ కామ్‍, మరియబి ఇమ్మస్‍ ఏక్‍ అష్యల్‍నూ కామ్‍నా చూణీల్దీ. ఇనకంతూ కేదెబి యో కామ్‍ కడైజాసెకొయిని, కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","యేసు బుజేక్‍ వొహఃత్‍ ఏక్‍ జోగె ప్రార్థన కరుకర్తొథో. తేదె ప్రార్దన హూయిజావదీన్‍ ఇన సిష్యుల్‍మా ఏక్‍ జణో ఇనకనా ఆయిన్‍, ప్రభు యోహాన్‍ ఇన సిష్యుల్‍నా సిఖాఢ్యోతీమ్‍, హమ్‍నాబి ప్రార్దన కరనా షీఖాఢ్‍ కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","ఇనటేకె యో యువ్నేతి తూమే ఆమ్‍ బోలి ప్రార్థనా కరొ, భా తారు నామ్‍ పరిసుద్ధా హోణు! తారు రాజ్యం ఆవ్‍నూ! ");
INSERT INTO vgr_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","హమ్నా హోణుతె ఖానూ ఆ ధన్నె హమ్నా ధిజొ. ");
INSERT INTO vgr_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","హామారేతి విరుధ్‍గా కోన్‍బి అపరాధ్‍ కర్యుతే అపరాధ్‍ హామే మాప్‍ కరూకరియేస్‍, ఇనటేకె హమారు అపరాధ్‍నాబి మాప్‍ కర్జొ. హామ్‍నా సోధనమా నకో ఆవదాకరి బోలొ కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","యో అజు ఆమ్‍ బోలొ, తూమ్‍నా కీనాబి ఏక్‍ దోస్‍ రైతో, యో దోస్‍ ఆది రాత్‍మా ఇన దోస్‍ కనా ఆయిన్‍, మారో దోస్‍ మన తీన్‍ రోటా బదుల్‍నా ధా. ");
INSERT INTO vgr_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","మారో దోస్‍ కేజ్గాకీ జాతొ జాతో మరాకనా ఆయు, ఇన ఖ్హాఢవనా మారకనా కాయిబి కోయిని కరి బోల్యా కరి బోల్‍, ");
INSERT INTO vgr_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","యో దోస్‍ మైస్‍ రైన్‍, మార లఢ్‍కా మారకనా ఖూత్యస్‍ వూటీన్‍ ఆవనా కోహూసేని, ధర్వాజూ మూఛీనాఖ్య, మే వూటీన్‍ హాంకే దేవ్వానా కోహూసేని కరి బోల్‍సేనా? ");
INSERT INTO vgr_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","యో ఇనూ దోస్‍ హూయిరోస్‍ ఇనటేకెస్‍బి, వూటీన్‍ దేవనా నాహూయితోబి, యో షరంకోయినితిమ్‍ మాంగ్తూరవ్హమా యో వూటీన్‍ ఇనూ దోస్‍ ష్యాత్‍ మాంగాస్‍కీ యో ఖారూ దేస్. కరి తూమారేతి బోలుకరుస్‍. ");
INSERT INTO vgr_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","ఇమ్మాస్‍ తూమేబి మాంగ్వొ తూమ్‍నా దేవావ్‍స్యే, ఢ్హూంఢో తూమ్‍నా మళ్‍స్యే, ధర్వాజూనా ట్హోకో తూమ్‍నా ఖఢవ్‍స్యే. ");
INSERT INTO vgr_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","మాంగాతె హార్‍ అద్మీయేనా దేవావ్‍స్యే, ధూండవాలనా హార్‍ అద్మీయేనా మళ్‍స్యే. ట్హోకాతే అద్మీయేనా కఢవ్‍స్యే, కరి తూమారేతి బోలుకరూస్‍. ");
INSERT INTO vgr_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","తూమారమా క్హయోబి భా ఛీయ్యో మాస్లూ మాంగ్యోతొ ఖ్పానా దీస్యూనా? ఇన్‍ఢూ మాంగ్యూతో ఇఛ్చీనా దీస్యూనా? ");
INSERT INTO vgr_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","తూమే ఖ్హారబ్‍ అద్మిరైతోబి, తూమార లఢ్‍కాన అసేల్‍ రాఛస్‍ దేనూ కరి తూమ్‍నా మాలం. ");
INSERT INTO vgr_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","స్వర్గంమా ఛాతె తార భానా మాంగతె ఇవ్నా ఇనతీబి జాహఃత్ ఖఛ్చితనంగా దిస్యేకరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","ఏక్‍ ధన్మా యేసు ముక్కు దుష్టాత్నా ఏక్‍ అద్మీమాతూ నాఖాడ్యో. తేదె యో దుష్టాత్మ ఛల్‍జావమా యో ముక్కు అద్మివాతే బోలానిక్‍ల్యామా. యో దేఖిన్‍ ఎజ్గానుఖారు హాషం హూయిగు. ");
INSERT INTO vgr_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","తేదె ఏజ్గా థూతే అద్మియే థోడూ జణూ ఆ భూత్‍నొ మాలిక్‍ హుయిరోతే బేయేల్జెబూలుతీ దుష్టాత్మ నా నాఖాఢూకరస్‍‍‍‍ షీకీ కరి బోల్లీదూ. ");
INSERT INTO vgr_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","అజు థోడూ అద్మిఇన షోధిస్తూహూయిన్‍ దేవ్‍ కంతు ఏక్‍ అధ్బుతం కర్‍ కరి బోల్యు. ");
INSERT INTO vgr_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","యో యూవ్నే సోచుకరతే ఖారు మాలంకర్లీన్‍, ఆమ్‍ బోల్యొ, ఇనూ యోస్‍ విరుద్దంతీ హూయుగుతే “కేసు రాజ్యంబీ హుభ్రాకోయిని, ఇమ్మస్‍ ఘర్‍వాలుబీ అలాదు హుయిజాస్‍.” ");
INSERT INTO vgr_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","సైతాన్‍బి ఇనేతి యోస్‍ దుష్మన్ హూయిగయోతో ఇను రాజ్యం కీమ్‍ర్హాసే? మే బేయేల్జెబులుతి దుష్టాత్మనా నాఖఢుకర్తో హూసేతో. ");
INSERT INTO vgr_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","తూమారు అద్మియే కీనేతీ నాఖాఢుకరస్‍? ఇనటేకె యూవ్నేస్‍ తూమ్‍నా తీర్పు దీస్యే. ");
INSERT INTO vgr_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","పన్కీ మే దేవ్‍నూ హాత్‍తి దుష్టాత్మనా నాఖాఢుకరుస్‍, ఇనటేకె దేవ్‍నూ రాజ్యంబీ తూమార కనా ఆయిరూస్‍ కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","ఏక్‍ ఖ్హూవత్‍వళో క్హారు ఆయుధాల్‍ పేర్లీన్‍, ఇను యో బేసీన్ కావ్లీ కాషీర్యూతో ఇను ఘర్‍ను ధౌలత్‍ జత్తన్‍తీ ర్హాసే. ");
INSERT INTO vgr_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","పన్కీ ఇనేతి ఖ్హూవాత్‍వళో, ఆయిన్‍ ఇనఫర్‍ పఢీన్‍ ఇన హారైన్‍, యో నమ్మీల్దొతే క్హారు ఆయుధాల్‍బి, ఘర్‍నూ ధౌలాత్‍బీ ఖారూ ఛీనాయ్‍లీన్‍ జైన్‍ ఖారవ్‍నా దీస్యే. ");
INSERT INTO vgr_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","మారేతి మలీన్‍ రైయికొయింతె అద్మి మన దుష్మన్‍ను సమానం, మారేతి మలీన్‍ మార మ్హేండాన ఏక్‍ జోగో కరనా టేకె సహయం కరకోయిన్తే అద్మిమార మ్హేంఢాన నాఖాఢ్‍దేవళోనితర కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","ఏక్‍ అద్మీమతూ దుష్టాత్మా బాధర్‍ ఆయిన్‍, ఆరామ్‍ కరనా టేకె పాణీకోయిన్తే జోగొ ఫర్‍తూహూయిన్‍, ఆరామ్‍ కరానా నమళామా, మే మ్హేంధీన్‍ ఆయోతే ఘర్‍కనా పాచు ఫరీన్‍ జానూకరీ సోఛో. ");
INSERT INTO vgr_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","యో ఏజ్గా ఆయిన్‍, యో ఘర్‍ అసేల్‍నితర రవ్హమా, ");
INSERT INTO vgr_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","యో జైన్‍ అజు క్హాత్‍ దుష్టాత్మానా కేడె బూలాలీన్‍ ఆయిన్‍, యో ఘర్‍మా రైన్‍ కాపురం కరాస్‍. ఇనటేకె యో అద్మీనూ ఆగళ్ళు గతీతీబి గణు అధ్యనం హూసే కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","ఏత్రస్‍మ జనం క్హారవ్‍మాతూ ఏక్‍ భాయికో యేసునా ధేఖీన్‍, తూనా ఢోయిన్‍ జణీన్‍ పాళితే యో ఆయా కేత్రేకీ ధన్యురాల్‍ కరి ఘట్‍ ఛిక్రీన్‍ బోలి. ");
INSERT INTO vgr_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","తేదె యో వోహో పన్కి దేవ్‍ని వాతే ఖమ్జీన్‍, ఇన భరోభ్బార్‍ ఛాలవళు అజుగణు ధన్యుల్‍ కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","అద్మీయేనూ గుంబల్‍ గణు హూవమా యేసు ఆమ్‍ బోల్యొ, ఆ పిఢిను అద్మియే ఘణు ఖ్హారాబ్‍. ఇనటేకె కర్‍కరీ పుఛావుంకారస్‍, దేవ్‍నే యోనానస్‍ ఏక్‍ సాబుత్‍ కర్యొతిమ్‍, తూమ్‍నాబి ఇమ్మస్‍ ఏక్‍ సాబుత్‍ తప్ప అజు హఃయ్యుబి సాబుత్‍ కోహూస్యేని కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","యోనా నీనేవె హఃయర్‍ వాళనా ఏక్‍ సాబుత్నితర కీమ్‍ రయోకీ, ఇమ్మస్ అద్మినొ ఛియ్యోబి ఆ ఫీఢీనూ అద్మీయేనా ఏక్‍ సాబుత్‍ కరి బోలొ. ");
INSERT INTO vgr_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","దక్చిణ దేహ్‍నూ రాణి సొలోమోను జ్ఞానంనా హఃమ్జనటేకె కెత్రూకి దూర్‍తి ఆయిథి. పన్కి హాంకే సొలొమోన్‍తీబి మోటొ అజ్గ ఆయ్రోస్‍కరి బోల్యొ. పన్కి తీర్పునూ ధన్నే ఆ ఫీడీనూ అద్మీయేతివుబ్రీన్ దక్చిణా దేహ్కమని రాణీ తూమే తప్పు కర్యాకరి బోల్‍స్యే. ");
INSERT INTO vgr_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","నీనెవెనూ అద్మీయేబి తూమారఫర్‍ తీర్పునూ ధన్నే తప్పు కర్యకరి బోలాస్యే. కీమ్‍కతో యూవ్నే యోననూ ప్రకటననా హఃమ్జీన్ దిల్ బద్లాయిలీదు. పన్కి యోనా తీబి మోటొఅజ్గా ఆయిరోస్‍. ");
INSERT INTO vgr_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","కోన్‍బి ఊజాళునా టేకె బుడ్డీబాళీన్‍, మై ఘర్‍మా ఆవ జావవాళోనా ధేఖ్వావనా టేకె ఏక్‍ ఉఛ్చీ జోగోఫర్‍ మ్హేందాస్‍, పన్కి నాదెఖ్కావ్‍నూ తిమ్ రేఖ్‍నూ డబ్బొనా హేట్‍ మ్హేందకొయిని. ");
INSERT INTO vgr_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","తుమార ఆంగ్తాన్‍నా తుమారొ డోళోస్‍ ఉజాళు. ఢోలొ అష్యల్‍ రైతో ఆంగ్తాన్‍బి ఉజాళుహూయిన్‍ ర్హాసే. డొలో కర్రాబ్‍ హూయిగయుతో ఆంగ్‍తన్‍ పూర అంధారు హూయిజాస్యే. ");
INSERT INTO vgr_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","ఇనటేకె తూమారమా ఛాతే యో ఊజాళునా అంధారూ నా హూనూతీమ్‍ దేఖీలేవొ. ");
INSERT INTO vgr_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","తారు షరీర్‍మా ధర్రాష్యుబి అంధారు నార్హానూతీమ్‍ ఖారుబి ఊజాళుతి భరైరైతో, ఊజాళుని బుడ్డి కీమ్‍ భల్తురస్‍కీ, ఇమ్మస్‍ తూమారు షరీర్‍బి ఊజాళునింతర భల్తూరస్యే. ");
INSERT INTO vgr_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","యేసునే వాతే బోలీన్‍ హుయిజవాదిన్‍, ఏక్‍ పరీస్యయుడు ఇనేతి ధాన్ ఖ్హావానటేకే బూలాయ్యో, తేదే యో జైన్‍ ఖ్హావనటేకే బేట్హొ. ");
INSERT INTO vgr_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","యో ధాన్‍ ఖ్హావనా ఆగడీ పాణీతి హాత్‍ ధోయో కోయినికరీ యో పరిసయ్యుడూ దేకీన్‍ హషంహూయిగో. ");
INSERT INTO vgr_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","ఇనటేకే ప్రభూ ఇవ్నేతీ ఆమ్‍ బోల్యో. గీన్నియే తాళీయేన బాదర్లూ ఆష్షల్‍తీ దౌసూ, పన్కీ తూమార మైక్హారబ్‍ చాల్‍ దూరాషతీ భరైన్‍చా. ");
INSERT INTO vgr_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","బుద్దు అద్మీయే, భాదర్లూ బ్హాగ్‍ కర్యోతే దేవ్‍ మైహనూ బ్హాగ్‍ కార్యోకోయినిసూ? ");
INSERT INTO vgr_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","తూమనా చాతే ఖారుబీ ధానంకరో. తెదె తూమాన ఖారూ షుధ్ది హూసే. ");
INSERT INTO vgr_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","అయ్యో పరిసయ్యుల్‍ ఖేతర్‍మా పీకాతే పూదీనామా, అజు హర్‍ ఏక్‍ రఛామతూ దేవ్‍నా తూమే ధసవభాగం దేంగ్రస్‍, పణికీ న్యాయం, దేవ్‍నూ ఫ్యార్‍నా మెందెవుమ్కరస్. ఇనా నా మ్హేంన్నుతీమ్‍ ఆనాబి కఛ్చితంగా కర్‍నూకరీన్‍ బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","ఓ పరీసయ్యుల్‍ తూమే ప్రార్థనాను ఉఛ్చుజొగోమా భేఖ్‍ఃనూ కరి, బజార్‍నూ గల్లీయేమా వందనాల్‍ ఆఖ్‍ః కరవళు. ");
INSERT INTO vgr_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","జనం ఖారు ఉఫర్‍ దేక్హావకోయిన్తే సమాధినా ఉఫర్‍ కుమ్ధల్తూహూయిన్‍, చాల్తూ రాస్‍ ష్యానకతో ఏజ్గా సమాధి ఛాకరీ యూవ్నా మాలంకోయిని ఇమ్‍ సమాధినూ జోణ్‍నూ అద్మి తూమే. ");
INSERT INTO vgr_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","ధర్మషాస్త్రంనా బోలావళో ఏక్‍ జణో ఉటీన్‍, బోధకుడా! తూ ఇమ్‍ బోలీన్‍ హమ్నా షరం కాఢూకరస్‍ కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","ఓ ధర్మషాస్త్రం బోలావళా! పాఢనా కోహూయిన్తే భోజానా తూమే జనం ఉఫర్‍ నాకూకరస్‍, పణీకీ తూమే యో భోజానా ఏక్‍ ఆంగ్లీతీబి కోఛీమానీ కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","తూమారు పూర్వీకుల్‍ కేత్రకీ ప్రవక్తల్‍నా మర్రాక్యు, యూవ్నూ సమాధియేస్‍ తూమే హాంకే భామ్దుకరస్‍. ");
INSERT INTO vgr_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","కతో తూమార పూర్వికుల్‍ కర్యూతే కామ్‍నా తూమే ఒప్పిలేతూహూయిన్‍ సాక్చంనితర యూవ్నే మర్రక్యూతే గోరాఢూనా సమాధి భామ్దుకరస్‍. ");
INSERT INTO vgr_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","ఇనటేకెస్‍ దేవ్‍ని ఆఖ్కాల్‍తీ ఆమ్‍ బోల్యొ; యో పూర్వికుల్‍ కనా ప్రవక్తల్‍నా, అపొస్తుల్‍నా బోలీమోక్లీస్‍, యూవ్నేతోఢ అద్మీయేనా మర్రాక్‍స్యే, తోఢ అద్మీయేనా హింసించిన్‍ మార్‍స్యే. ");
INSERT INTO vgr_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","లోకం పైదాహూయూతే ధన్‍తూ ధరీన్‍ కేత్రకీ ప్రవక్తల్‍ ఛూవడ్యూతే లోయీనా తూమేస్‍ బాధ్యుల్‍ కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","హేబెల్‍నబి లోయీతి ధరీన్‍, బలిపీటంనూ మందిరంనా ఇఛ్మా మర్యుతే జెకర్యాను లోయీతోడి, ఆవణేస్‍ బాధ్యుల్‍. ఆతరంనూ అద్మీయే యో లోయీనూ బదుల్‍ కఛ్చితంగా తూమారేతి బోలుకరూస్‍. ");
INSERT INTO vgr_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","ధర్మషాస్త్రం బోలావళా, తూమే అఖ్కల్‍నూ చాబీ లీరాక్యస్‍, పణీకీ యో చాబీ కాఢీన్‍ తూమేబీ కోజైనీ, జవవళానాబి కోజవాదేనీ కరి బోలీన్‍ ఛలేగొ. ");
INSERT INTO vgr_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","యో ఏజ్గాతూ ఛల్‍జవదీన్‍ షాస్త్రుల్‍బి, పరీసయ్యుల్‍ మళిన్‍ ఇనాఫర్‍ ధావోకరీన్‍ నింధల్‍నాకీన్‍ ధర్నూ కరి రైగు. ");
INSERT INTO vgr_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","ఇనాటేకె ఇన మోఢాతీ కయ్యూ వాత్‍నబి ధర్‍లేనూ కరి కయ్యు కయ్యూ వాతే బోలావ్‍తా ర్హయ్యా. ");
INSERT INTO vgr_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","ఏత్రమా జనం హాఃరు ఘను హూయిన్‍ ఏక్‍నా ఏక్‍ కుమ్దాలావ్‍తూహుయిన్‍ ర్హవామా, యేసు తేదె ఆమ్‍ బోల్యొ, పరిసయ్యుల్‍నూ ఉఫర్లు పేరాక్హోనూ జోణ్‍నూ ఖాటును ఆటోతి జత్తన్‍ ర్హవో. ");
INSERT INTO vgr_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","లఫిర్యూతే క్హారు ఖ్హాయూబి బాధర్‍ పడ్‍స్యే కోయిన్తే రసేకోయిని. కీనాబి మాలంనాహూనూ కరి కేత్రు ధబడ్‍రాక్యుతోబి యో మాలంహుసే. ");
INSERT INTO vgr_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","ఇనటేకె తూమే అంధారమా బోల్లేతే వాత్‍ ఊజాళమా క్హామ్జావస్‍, ఘర్‍మా ధర్వాజు మూఛిలీన్‍ వాతే బోల్లిదా తోబి యో ఘర్‍నూ ఉఫర్‍ యో వాతే ప్రచార్‍ హూస్యే. ");
INSERT INTO vgr_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","మారొ దోస్‍థో ఏక్‍ వాత్‍ బోలుకరుస్‍ ఖామ్జో, ఆంగ్‍తన్‍నా మర్రాఖావాళనా దేఖీన్‍ నకో ఢరో; ఇమ్‍ మర్రాకీన్‍ ఖాయిబి కోకర్షేని. ");
INSERT INTO vgr_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","పణీకీ కీనా దేఖిన్‍ ఢర్‍నూ కతో అద్మినా మర్రాకీన్‍ నరకంమా నాఖావాళనా దేఖీన్‍ ఢరో. ఇనస్‍ దేఖీన్‍ ఢరో కరి మే తూమారేతి బోలుకరుస్‍. ");
INSERT INTO vgr_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","బే పైసానా పాఛ్‍ పిస్కీలియే లేఛావస్‍కాహేనా? ఇన్మమాతు ఏక్‍ పిస్కీలినాబి దేవ్‍ బుల్‍స్యేకోయిని. ");
INSERT INTO vgr_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","తూమారు ముఢ్‍క్యామ కేత్రు ఖేహ్‍ః ఖారుబి గణాయ్‍రూస్‍, ఢరోనకో; ఇనటేకె యో పిస్కీలియేతిబి తూమే స్రేష్టుల్‍ కాహేనా? ");
INSERT INTO vgr_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","బుజున్‍బి మే తూమారేతి బోలుకరుస్‍, మన అద్మీయేనా ఖామే కోన్‍ ఒప్పిలేస్‍కి ఇనాబి అద్మీనో ఛీయ్యోబి దేవ్‍నూ దూతల్‍ను ఖామే యూవ్నాబి ఒప్పిలీస్యే. ");
INSERT INTO vgr_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","అద్మియేమా హాఃమే మే మాలంకోయిని కరి బోలవాళునా అద్మీనొ ఛీయ్యోబి యూవ్నా దేవ్‍కనా మాలంకొయిని కరి దేవ్ను దూతల్‍నా హాఃమె బోల్‍స్యే. ");
INSERT INTO vgr_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","అద్మీనో ఛియ్యోనా దూషించవాళనాతోబి క్చమించబడ్‍స్యే, పన్కి పవిత్రాత్మనా దూషించవాళనా మాత్రం క్చమాపణ కోయిని. ");
INSERT INTO vgr_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","యూవ్నే ప్రార్థనాను జోగో, అధికారుల్‍నా, సబా స్తాలంమా క్హామే తూమ్‍నా లీన్‍ గయు తేదె తూమే ష్యాత్‍ బోల్నూ, కీమ్‍ బోల్నూ కరి పస్తావో నకో. ");
INSERT INTO vgr_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","తుమె ష్యాత్‍ బోల్లుకి యో వాతేనా పవిత్రాత్మ తుమ్నా సిఖాఢ్‍స్యే. ");
INSERT INTO vgr_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","యో జనంమతూ ఏక్‍ జణో వుటీన్‍ బోధకుడ్‍, భా ను దౌలాత్‍మా మన బ్హాగ్‍ధాకరీ మార భైన బోల్‍ కరి బోలామా. ");
INSERT INTO vgr_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","యేసు తూమే మన తీర్పు బోలవాలంతరా, న్హైతొ భాగ్‍ పాఢిన్‍ దేవవాళోంతర మన కోన్‍ మ్హేంద్యు? కరి ఇనేతి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","బుజు యో యూవ్నేతి తూమే కీనఫర్‍బి గ్హణు ఆక్హ్‍నకోకరో; అద్మీను జీవ్నూ యో కేత్రు జమా కర్యుతోబి ఇనఫర్‍ ఆధారం కోహూసేని. ");
INSERT INTO vgr_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","యో యూవ్నేతీ ఏక్‍ ఉపమానం బోల్యొ; ఏక్‍ మ్హాజీన్‍ వాళోనూ ఖేతర్‍ కేత్రేకీ అసేల్‍ పీకాస్‍. ");
INSERT INTO vgr_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","తేదె ఇనా వాడీన్‍ నాఖాన జోగో కోపురాని, ఇనటేకె మే ష్యాత్‍ కర్‍నూ కరి ఇనూ దిల్‍మా సోచీన్‍ తేదె యో ఆమ్‍ కర్షే. ");
INSERT INTO vgr_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","మారు గోధమ్‍ పోడైన్‍ అనేతి అజు గ్హణు మోటు భంధైస్‍, పీక్యూతే ఖారు ఇనమా నఖైన్‍, తేదె యో ఆమ్‍ బోల్లీదో. ");
INSERT INTO vgr_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","ఇను జాన్‍తి యోస్‍, మారో జాన్‍ కేత్రాకీ వరఖ్‍ః ఖావనూ రాఛ కమాయో, తూ ఖైన్‍ పీన్‍ సుఖపఢ్‍ కరి బోల్లీస్యే. ");
INSERT INTO vgr_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","తేదె దేవ్‍, బుద్దుకోయినితె అద్మి ఆజ్‍రాత్‍ తారు జాన్‍ మే మాంగుకరుస్‍; తూ కమాయోతే ఖారు కీనూ పాల్‍ హూస్యే కరి పుఛాయో. ");
INSERT INTO vgr_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","దేవ్‍తి దౌవ్లత్‍ వాళో నాహూయిన్‍, ఇనా ఖాజే దౌలత్‍నా జమా కర్‍లేవళునూ గతి ఇమ్మస్‍ ర్హాస్యే. ");
INSERT INTO vgr_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","యో ఇనా సిష్యుల్‍తి ఆమ్‍ బోల్యొ, ఇనఖాజే తుమారు జాన్‍టెకేబి, సాత్ పేర్సూకీకరి, తుమారు ఆంగ్తాన్నాటేకెతోబి చింతపడొనొకొ; ఖానుతితీబి, జాన్‍ మహాన్‍ కాహేనా? ఆ ఆంగ్తాన్నా హఃయూ లుంగఢా పేర్‍నూ? కరి పస్తావో నకో. ");
INSERT INTO vgr_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","ధాన్‍తిబి జాన్‍, లుంగఢాతిబి ఆంగ్తాన్‌ మోటు కాహేనా? ");
INSERT INTO vgr_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","కాంగ్లాదేఖో, యో బింజ్లొనా ఖేతర్‍ నాఖకోయిని వాడకోయిని, యూవ్నా గోధాల్ కోయిని, రైతోబి దేవ్‍ యూవ్నా పాళుకరస్‍. తూమే యో జీన్‍వార్‍తిబి కేత్రేకీ స్రేష్టుల్‍ కాహెనా. ");
INSERT INTO vgr_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","పస్తాయిన్‍ తూమారు జీవితంనా ఏక్‍ గంటో జాహఃత్‍ కర్‍లేళు కోన్‍బి ఛా? ");
INSERT INTO vgr_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","ఆ ధర్రాష్యు తూమారు హత్‍ నా హూయుతో అజు పార్లు కామ్‍నా టేకె చుక్కె ష్యాన చిమ్తాక్హాస్‍? ");
INSERT INTO vgr_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","పూల్‍ కీమ్‍ వధూకరస్‍కీ దేఖో, యోమిన్హత్ కరకొయిని, కరకొయిని, మే ష్యాత్‍ బోలుకరుస్‍ కతో యేవోడొ మోటో రాజో సొలోమోన్‍ పేర్యోతే లుంగఢా ఆ పూల్‍మా ఛాతే ఏఖాదునింతరబి రంగ్‍ కోయిని కరి బోలుకరుస్‍. ");
INSERT INTO vgr_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","తూమే అల్పవిష్వాసీ కోయిన్తే అద్మీయే జాడీమా ఆజ్‍ వుటీన్‍ కాల్‍ చుల్లమా భళీజవళు గాఖ్‍ఃనా దేవ్‍ ఏత్రే రంగేలు కర్యుతో తూమ్‍నా బుజు కేత్రే రంగ్‍ కర్‍నూ. ");
INSERT INTO vgr_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","సాత్ ఖాసుకీ సాత్ పీసుకీ పీస్యుకీ కరి ఇనటేకె తుమార దిల్మా చిమ్తానకో లేవో ఇనా పీటే నాక్హో నకో. ");
INSERT INTO vgr_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","ఆ ములక్‍నూ అద్మీయే ఇనటేకె నాఖాస్‍, తూమార భానా యోహాఃరు తూమ్నా జరూరత్‍ కరి మాలం. ");
INSERT INTO vgr_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","తూమే దేవ్నూ రాజ్యంనా ఢూండో, ఇనకేడే ఆఖారుబి మళ్‍స్యే. ");
INSERT INTO vgr_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“న్హాను గల్లో ఢరోనకో తూమ్‍నా దేవ్‍నూ రాజ్యం దేవాను తూమార భా న ఇష్టమస్‍.” ");
INSERT INTO vgr_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","తూమార కనా ఛాతే ఇనా లేఛీన్‍ ధరమ్‍ కరో; గళాకోయిన్తే రఫ్యాని సంఛేవ్‍నా తయార్‍ కర్‍లేవో. తూమారు దవ్లత్నా స్వర్గంమా లపాడో, ఏజ్గా క్హయూ ఛోర్‍బి ఆవ్‍స్యే కోయిని, వూధీయేబి ధర్‍స్యే కోయిని. ");
INSERT INTO vgr_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","కేజ్గా రఫ్యా రస్‍కీ తూమారు జాన్‍బి ఏజ్గాస్‍ ర్హాస్‍. ");
INSERT INTO vgr_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","తూమారు కంభర్నా భాందిలీన్‍, తూమారు దేవ్ను ఆగ్‍నా ఇమ్మస్‍ భళ్తుర్హవదే. ");
INSERT INTO vgr_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","య్హాను విందు ఖావనా గయోతే హమారు మాలిక్‍ కేదె ఆవ్‍స్యే కరి కావల్‍ కాసిర్యూతే దాసుల్‍నితర ర్హవో మాలిక్‍ ఆయిన్‍ తలుపు ట్హోక్సే. ");
INSERT INTO vgr_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","యో మాలిక్‍ ఆయిన్‍, హోషార్‍తీ ర్హవనూ కీనా దేఖాస్‍కీ యూవ్నే ధన్యుల్‍; యోస్‍ ఆయిన్‍ ఇనా కంభర్నా బాందిలీన్‍ యూవ్నా ఖాణు ఖాడవనా బేక్హాఢీన్‍ యో సేవల్‍ కర్షె కరి తూమారేతి క్హాచీతీ బోలుకరుస్‍. ");
INSERT INTO vgr_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","బుజు యో బే భజేనా ఆయితోబి, తీన్‍ భజేనా ఆయో తోబి తో వక్హాత్‍ కోన్‍ హోషార్‍తి రహిన్‍ దేఖావస్‍కీ యూవ్నే ధన్యుల్‍. ");
INSERT INTO vgr_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","ఏక్‍ ఘర్‍నూ మాలీక్‍నా ఇనా ఘర్‍మా ఛోర్‍ ఆవ్‍స్యే కరి ఆగఢీస్‍ మాలంహూయుతో యో ఛోర్‍ నా ఆవ్‍నూ తిమ్‍ హూషార్‍ హూయిజాస్యే. ");
INSERT INTO vgr_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","తూమ్‍నా మాలంకోయిన్తే వోక్హాత్‍ అధ్మీనూ ఛీయ్యోబి ఇమ్మస్‍ ఆవ్‍స్యే, ఇనటేకె తూమే సిద్దంగా ర్హవో కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","తేదె పేతూరు ప్రభు ఆవాత్‍ హమ్నాస్‍ బోలుకరస్కి, న్హాయితో క్హారవ్నా బోలుకరస్కరీ బోలామా. ");
INSERT INTO vgr_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","తేదె ప్రభు ఆమ్‍ బోల్యొ, ఏక్‍ ఘర్నో మాలిక్‍ ఫరీన్‍ ఆయో తేదె ఇనుసేవకుల్‍ క్హారవ్నా బరోబర్ను వాక్హాత్‍మా ఖాణు ఖఢవనాటేకె ఇనూ గర్మాకోన్‍ హొషార్తీ, ఛలాక్తి, రైతే అద్మినా దేఖీన్‍ యూవ్నాఫర్‍ అధికారినింతర మ్హేంఛే. ");
INSERT INTO vgr_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","యో మాలీక్‍ ఫాచూ ఆయిన్‍ దేఖోతేదె క్హయోదాసుడ్‍ యో బోల్యొ తిమ్మస్‍ కర్తూర్హాస్కీ, యో ధన్యుడ్‍ కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","తేదె యో ఇను ధౌలత్‍ హాఃఛిఫర్‍ ఇనా అధికారి కర్‍స్సెతె క్హాఛి. ");
INSERT INTO vgr_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","పన్కీ యో దాసుడ్‍ మారో మాలీక్‍ కేదె ఆవ్‍స్యేకరి సోచుకర్తో హుయిన్‍ మాలిక్‍ ఆవనా గ్హను వహాఃత్‍ ఛాకరి యో ఖైన్‍, పీన్‍, దాసీ, దాసుడునా మార్తొర్హయోతో, ");
INSERT INTO vgr_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","తేదె యో సోచ్యా కొయిన్తేధన్‍, సోచ్యాకొయింతె వహాఃత్‍మా మాలీక్‍ ఆయిన్‍, యో దాసుడ్‍నా మరై నాఖీన్‍ ఇనా భక్తిహీనుల్‍మా మళైనాక్‍దిస్యే. ");
INSERT INTO vgr_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","సేవకుడ్‍, మాలీక్నూ దిల్నూ వాత్‍ మాలంరైన్‍సబి ఇనూ కామ్‍ నాకర్యతో యో దాసుడ్నా కెత్రేకి మార్‍ లగ్‍స్యే. ");
INSERT INTO vgr_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","హూయితోబి మాలంకోయిన్తే తప్పు కరవాళునా కమ్‍ మార్‍ పఢ్‍స్యే. కినా గ్హణు దేస్కీ యూవ్నాకం‍తూస్‍ గ్హణు ఆహ్ః కర్సె, గ్హణు దేవాయ్‍ర్యూతే అద్మీయేకంతూస్‍ ఆనేతిబి గ్హణు ఆహ్‍ః కరాస్‍. ");
INSERT INTO vgr_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","మే ఆయోతే ఆ జమీన్ఫర్‍ ఆగ్‍ నాఖానటేకె ఆయో, యో ఆగ్‍ హాంకేస్‍ భళ్‍నూ కరి ఆహ్‍ః కరుకురుస్‍. ");
INSERT INTO vgr_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","వుజు మే లేనూతే దుఃఖామ్ను బాప్తిస్మమ్‍ వుజుబి ఛా, యో హూవతోడీ మన ఆమిన్హత్‍ తప్పకొయిని. ");
INSERT INTO vgr_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","ఆ జమీన్‍ఫర్ ఆయోతె సమాధానం కరనటేకె ఆయోకరి సోచిలెంకరస్నా? కాహె ఏక్నయేక్‍ అలాదు కరనాటేకె ఆయో. ");
INSERT INTO vgr_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","హంకేతు ధరీన్‍ ఏక్‍ ఘర్మా ఫాచ్‍జణ రైతో యూవ్నే తీన్జణ ఏక్‍ బాజు రైతో బే జణ ఏక్‍ బాజు; బే జణ ఏక్‍ బాజు ర్హైతొ తీన్జణ ఏక్‍ బాజు ర్హైన్‍ ఇమ్‍ లాఢాయి కర్సె. ");
INSERT INTO vgr_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","అజు భా ఛియ్యోనా, ఛియ్యో భా న, ఆయా ఛోరినా ఛోరి ఆయానా, హాఃహుః హొవ్నా హొవ్‍ హాఃహుఃతి లఢాయి కర్సె. ");
INSERT INTO vgr_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","బుజు యేసు జనం ఖారేతి ఆమ్‍ బోల్యొ, తూమే పడమటతూ మాబ్బు ఆవనూ దేఖ్యాతో యెత్రే యగ్గీస్‍మా పాని వరహ్‍ఃస్యే కరి బోల్‍స్యు. ఇమ్మస్‍ వరఖాస్‍. ");
INSERT INTO vgr_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","దక్చిణనూ వ్యారో వాగ్యుతో అఖఢ్‍నూ గ్హాను గరామ్ను వ్యారో ఆవ్‍స్యేకరి బోల్‍స్యు ఇమ్మస్‍ హుసె. ");
INSERT INTO vgr_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","హదేక్‍ కపాఠివాలా! తుమే ఆకాష్‍, జమీన్‍నా దేఖీన్‍ ష్యాత్‍ జరగ్‍స్యేతే బోలస్‍ పన్కీ, ఆ ధన్నూ హఃనద్‍నా మాలం కరూకరకొయిన్నా? ");
INSERT INTO vgr_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","కెహూ న్యాయంకీ తూమేస్‍ మాలంకర్లేవో. ");
INSERT INTO vgr_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","తుమారు వైరి తుమ్నా అధికారికనా లీన్‍ జావనువోహఃత్‍ తుమే యోజావనూ వాట్ఫరస్‍ ఇనేతి కీమ్బి బోలిన్‍ పరిష్కారించను కోసీష్‍ కరో. న్హైతో యోవైరీ తుమ్నా ధర్మషాస్ర్తం నెయ్యోకనా లీన్‍ జాస్యే, యో నెయ్యో సైనికుడ్నా ధరౌస్యే, యో సైనికుడ్‍ తూమ్నా ఠాణామ ఘలవుస్యే. ");
INSERT INTO vgr_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","తుమారకనా ఛాతే ఆహాఃరును రఫ్యా హాఃర బాంధతోడీ తుమె బ్హాధర్‍ ఆవ్‍స్యుకోయిని కరి మే తారేతి ఖఛ్చితంగా బోలుకరూస్‍. ");
INSERT INTO vgr_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","“పిలాతు గలీలయమనూ త్హోడు అద్మీయేన ల్హొయినా యూవ్నూ బలిమస్‍ మళాయ్‍ రాక్యోస్‍” యో వక్హాత్‍మ ఏజ్గా ర్హాహవాళమా థ్హోడుజణు యేసుతి బోల్యు. ");
INSERT INTO vgr_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","తేదె యేసు యూవ్నేతీ ఆమ్‍ బోల్యొ, ఆ గలీలయ ఛాతె క్హారవ్మా యూవ్నేస్‍ గ్హణు పాపేలు, ఇనటేకెస్‍ యూవ్నే పిలాతునా హాత్మా ఇమ్‍ మర్యుకరీ సోచుకరస్‍నా? ");
INSERT INTO vgr_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","ఇమ్‍ కాహే కరి మే బొలుకరుస్‍, తూమేబి ఇమ్మస్‍ నాషనమ్ నాజానుకతో తూమారు దిల్‍ భద్‍లాయిలేవో. ");
INSERT INTO vgr_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","సిలోయంమా గోపురం పఢీన్‍ మార్యూతె యో అట్టార అద్మీయే యెరూషలేమ్‍మా ర్హావళుతిబి ఆవ్నాస్‍ ఇమ్నూ గతికింమ్‍ ఆయుకరి రైజమ్కరస్ నా? ");
INSERT INTO vgr_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","కాహే కరి తుమారితి బోలుకరుస్; తూమేబి ఇమ్‍ నాష్‍నాహోనుకతొ కతొ దిల్‍ భద్లాయిలేవో. ");
INSERT INTO vgr_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","ఇనబాద్మా యో యూవ్నేతి ఏక్‍ ఉపమాన్‍ బోల్యొ. ఏక్‍ అద్మి ఇనూ టోట్మా ఏక్‍ అంజుర్నూ జాఢు ఘాడ్యో. తేదె యో పండవ్నాటేకె యోజాఢకనా జైన్‍ యో ఢూండ్తోర్హాతోథొ. పన్కి ఇనా కాయిబి దేఖాయుకోయిని. ");
INSERT INTO vgr_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","ఇనటేకె యో “ఆ జాఢనా పంఢ లాగ్సెకరి తీన్‍ వరహ్‍ఃతూ దేఖో కాయిబికోయిని, ఇనటేకె యో జాఢనా ఖత్రీనాక్‍ ఆనేతి ష్యాన ఆ జమీన్‍ఫర్‍ భోజొ” యో టోట్‍ మాలిక్‍తి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","ఇమ్‍ బోలామా యో టోట్‍నో మాలిక్‍ ప్రభూ! మే ఆ జాఢనా అష్పిస్‍ అసేల్‍తి ఖోంధిన్‍ పాళి కరీన్‍ గోభర్ను ఖాత్‍ నాఖూస్‍. ");
INSERT INTO vgr_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","ఏక్‍ వరాఖ్ తోడీ దేక్హీయే. తేదె తోబి ఆ జాఢనా పంఢ వుటాస్‍షికీ దేఖీయే, నా పిక్యుతో తేదె ఇనా ఖత్తర్‍నాఖాజై కరి బోలాస్‍. ");
INSERT INTO vgr_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","యేసు ఆరామ్‍ను ధన్నే ప్రార్థనను జొగొమా బోధించు కరామా, ");
INSERT INTO vgr_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","అట్టార వరహ్‍ఃతూ ఏక్‍ బాయికాన ఖంజోర్‍ కరను దుష్టాత్మా ధరీన్‍, రోగ్‍తి థీ. వుజు కంభర్‍బి జుఖీజైన్‍ హీబ్రనబి కోహోతూథూని. ");
INSERT INTO vgr_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","తేదె యేసు యో బాయికాన దేఖీన్‍, ఇనా ఖందే ఆవ్‍ కరి బోలిన్‍, ఆయా! తారు రోగ్‍మతూ తూన ఛుట్‍కార్‍ కర్‍దిదో. ");
INSERT INTO vgr_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","కరి బోలిన్‍ ఇనాఫర్‍ హాత్‍ మ్హేంధామా అసేల్‍ హూయిజైన్‍ హఃడక్‍ హుయిన్‍ యో బాయికో దేవ్‍నా మహిమ కరి. ");
INSERT INTO vgr_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","యేసు ఆరామ్ను ధన్నె రోగ్‍వాళనా అషల్ కరమా యో న్యావ్‍నుజొగొనూ అధికారి చంఢాల్తీ ఆయిన్‍, జనభో‍నా దేఖీన్‍, కామ్‍ కరనూ ఛో ధన్‍ ఛా. యో ధన్నుస్మా రోగ్వాళు అషల్ కరైలేవో; పన్కి ఆరామ్నూ ధన్నె నకొఆవోకరీ యూవ్నేతి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","యేసు, తేదె యూవ్నేతి ఉఫర్లు పేరాక్హో భద్లావళా! తుమె క్హారు ఆరామ్నూ ధన్నే తుమారు ధాండొవ్నా, గధేడవ్నా ఛొళ్లిజైన్‍ పాణీ పిఢావకొయిన్నా? ");
INSERT INTO vgr_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","అట్టార వరక్హ్ తి సైతాన్నూ హాత్మా భందైరీతే అబ్రాహామ్ను ఛోరిహుయితె అనా ఆరమ్‍నా ధనే సైతాన్మతూ ఛుట్కార్‍ నాకర్నూనా? కరి ఇనేతి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","యో బోల్యొతె వాత్నా యూవ్నే క్హారు షరంతీ ముఢ్‍క్యూ జుఖైల్దు. బుజు క్హారుజనాల్‍ యో కర్యోతే అసేల్‍ కామ్నా దేఖీన్‍ ఖుషీ హుయూ. ");
INSERT INTO vgr_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","ఇనబాద్మా యేసు, దేవ్‍నూ రాజ్యం కీనింతర ఛా? కీనేతి మళైన్‍ బోల్‍నూ? ");
INSERT INTO vgr_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","ఏక్‍ అద్మి ఇనూ కేత్తర్మా నాఖ్యొతె రాయినూ బింజ్లొను జోఢ్నూ. యో మోటుహూయిన్‍ ఉఫర్‍ ఉఢవాళు జిన్వార్‍ ఇను ఛాళోమ ర్హైన్‍ మ్హాళొ బాంధీన్‍ జివాస్‍ కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","అజుబి దేవ్నూ రాజ్యం కినేతి మళైన్‍బోలు. ");
INSERT INTO vgr_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","ఏక్‍ బాయికో “అసేల్‍ ఆటోమా మళావతే ఖాటు మోటు గుండామ్‍మా ఆటో నాఖిన్‍ యో ఖాటు ఆటో అసేల్‍ ఆటో ఖాటు హూవతోడీ మళావతే యో ఖాటు ఆటోనూ జోణ్‍నూ” కరి బొల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","యెరూషలేమ్మా జాతోహూయిన్‍ గామేవ్మా, క్హయార్మా కరి దేవ్ని బోధిస్తు హుయిన్ ర్హయో. ");
INSERT INTO vgr_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","ఏక్‍ జనొ వుటీన్‍ “ప్రభు! రక్చణ లీసేతె థ్హోడూజణుస్నా?” కరి పుఛవమా. ");
INSERT INTO vgr_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","తెదే యో దేక్హీన్‍, పీఛ్చావనూ వాట్‍ఫరస్‍ జవనా కోషీస్‍ కరో కెత్రూకిజణు యో వాట్ఫర్‍ జానుకరీ దేఖ్యూ పన్కి, యూవ్నా హాత్‍ కోహూయుని. ");
INSERT INTO vgr_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","ఘర్నో మాలీక్‍ వుట్టీన్ మ్హైతూ తలుపు మూఛినాఖ్యూతో, తుమె జైన్‍ బాధర్తూ తలుపునా ఠోక్తాహూయిన్‍, క్హయేప్‍ కాళ్ళకరీ బోల్యుతోబి యో, తుమె కోన్కి, కెజ్గతూ ఆయాకీ మన మాలంకోయిని, కరి బోల్‍స్యే. ");
INSERT INTO vgr_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","తేదె ఇవ్నే, తారేతి మలీన్‍ హమే ఖాద్య, పీధాని తూ హమారు గల్లీయేమా దేవ్నూవాతే బోల్తొర్హయోని కరి బోల్‍స్యు. ");
INSERT INTO vgr_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","తేదెబి యో, తుమె కోన్కి, కెజ్గనాకి మన మాలంకోయిని. తుమె మోసం కరవాళ. ఇనటేకె తుమె మరా కాంతు నికిజవోకరీ బోల్‍స్యె. ");
INSERT INTO vgr_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","అబ్రాహామ్ను, ఇస్సాక్‍, యాకోబ్‍, ప్రవక్తల్‍ హాఃరు జణాబి దేవ్‍నూ రాజ్యంమా ర్హావనూ, తుమె దేఖ్‍స్యు, అజు తుమ్నా భ్హార్‍ దఖల్‍నాఖ్యుతొ పన్కీ తుమె భ్హార్‍ హిబ్రీన్‍ దాత్‍, ఛావ్తాహూయిన్‍, దుఃఖ పడ్తార్హాస్యు. ");
INSERT INTO vgr_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","బుజూ అద్మియే హాఃరు ధన్‍ నికతే బాజూతి ఓంద్యె ధన్‍ ఢుబతె బాజూతి ఆయిన్‍, దేవ్‍నూ రాజ్యంమా వీందుకనా బేహఃడ్‍స్యే. ");
INSERT INTO vgr_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","హాధేకో “పీటేనూ అద్మీయేమా థోడు జణు హఃమే హుస్యే, హాఃమెను థోడుజణు పీటె హుస్యే” కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","తేదెస్‍ థోడుజణు పరిసయ్యుల్‍ యేసు కనా ఆయిన్‍, “తూ అజ్గాతూ ఛలోజా ఆలదు జోగోమా జా. హేరోద్‍ తూనా మర్రాక్‍నూ కరి దేఖూకరస్‍” కరి బోల్యు. ");
INSERT INTO vgr_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","తేదె “యేసు యూవ్నేతి, తూమే జైన్‍ ఇనేతి ఆమ్‍ బోల్యొ ఆజ్‍ కాల్‍ మే రోగ్‍వాళనా ఖుధ్రవ్‍తోహూయిన్‍, దుష్టాత్మా ధరీహూయునా అషల్‍కర్తోహుయిన్‍, తీన్‍మనూ ధన్నే మే కరనూ కామ్‍ ఖారు పూరా కరీస్‍, కరి జైన్‍ యో న్హోరితి బోలో” కరి బోలిమోక్‍ల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","హూయితోబి ఏక్‍ ప్రవక్తబి యెరూషలేమ్‍నా బాధర్‍ మర్నూనా కాహేనా, ఇనటేకె ఆజ్‍ కాల్‍ ఇనకాల్‍ మారు కామ్‍ మే కరనూస్‍ పఢ్‍స్యే. ");
INSERT INTO vgr_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","యెరూషలేమ్‍! యెరూషలేమ్‍! తూ ప్రవక్తల్‍నా మర్రాక్‍తి హూయిన్‍, తార కనా ఆవతే ప్రవక్తల్‍నా ఫత్రావ్‍తి మార్రాకుకరస్‍. ఏక్‍ కూకీడి ఇనా చేల్కవ్‍నా కీమ్‍ ఇనూ పాకీఢినా హేట్‍ బులైలేస్‍కీ, ఇమ్మస్‍ తార లఢ్‍కావ్‍నబి కంధేకర్‍లేను కరి దేఖో, పన్కి తూమేస్‍ ఆవాన ఇష్టాపడ్య కోయిని. ");
INSERT INTO vgr_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","తారు ప్రార్థనా మందిరం పాడ్‍దిబ్బ హూయిజాస్యే. “ప్రభునూ నామ్‍తి ఆయోతే యో ధన్యుడ్‍ కరి బోలాతోడీ తూమే మన దేఖ్‍స్యు కోయిని కరి ఖఛ్చితనంగా బోలుకరూస్‍” కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","ఆరామ్నూ ధన్నే యో ధాన్‍ ఖావనాటేకె పరిసయ్యుల్మా ఏక్‍ అధికారి ఘర్కనా జవమా, యూవ్నే యేసు ఏజ్గా ష్యాత్‍ కర్షేకి కరి ఏన్‍ కర్తు ర్హయూ. ");
INSERT INTO vgr_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","ఆంగ్తన్‍ మొత్తం పులీనీర్‍ భరైహుయు రోగ్వాల ఏక్‍ అద్మిఇనా మే ఆయిన్‍ హూబ్ర్యు. ");
INSERT INTO vgr_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","ఆరామ్నూ ధన్నే రోగ్‍వాళనా ఖుద్రవనూ న్యాయం కాహేన్నా? ");
INSERT INTO vgr_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","కాని, బోలకోయినీతింమ్‍ యూవ్నే గఛ్చుప్‍ థా. తెదె యో రోగ్వాళనా కంధే బులైన్‍ ఇనా రోగ్నా క్హూద్రైన్‍ బోలిమొక్‍ల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","తుమారమా కీనూబి ఛయ్యోతోబి, ధాండొతోబి ఆరామ్‍నూ మా పడీగయు తేదె యగ్గీస్‍ ఇనా ఉఫర్‍ కాడ్‍స్యు కున్నా? కరి బొల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","ఆ వాతేవ్‍నా యూవ్నా కాయిబి బోలానా కోహూయుని. ");
INSERT INTO vgr_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","ధాన్‍ ఖావనటేకె బులైమాంగాయితే అద్మీయే యూవ్నే ఆగడీ బేహ్‍ఃనూ కరి దేఖూకరతే యూవ్నా దేఖీన్‍, యేసు ఏక్‍ ఉపమాన్‍ బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","తూన కోన్‍బి య్హానూ ధాన్‍ ఖావనా బులాయుతో ఏజ్గా అగ్రస్థాన్‍మా నకో బేఖో, తూన బులాయోతే యో ఏక్‍ వఖాత్‍ అజు తారేతిబి మోటోనా బులావజాయ్‍; ");
INSERT INTO vgr_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","యో తారకనా ఆయిన్‍, ఆనా జొగోధాకరీ తారేతి బోల్యుతో, తేదె తూ షరంతీ పీటే జైన్‍ బేహ్‍ఃనూ పడ్‍స్యే. ");
INSERT INTO vgr_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","ఇనటేకె తున బులాయుతో ఆఖరీనుజొగొమా బేక్హ్, ఇమ్‍ కర్యోతో తూనా బులాయోతే యో ఆయిన్‍, మారో దోస్ ఉట్టీన్ ఖామే బేహ్‍ః కరి బోల్‍స్యే, తేదె ఏజ్గా బేట్యూతే అద్మీయేమా తూనా అచ్చు నామ్‍ ర్హసే. ");
INSERT INTO vgr_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","ష్యానకతో ఇనూ యోస్‍ మోటోహోను కరి దేఖవాళు తగ్గాయిలీసే, తగ్గాయిలేవాళు హేచ్చింపబడ్‍సే. ");
INSERT INTO vgr_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","బుజు యో ఇనా విందు ఖాడవనా బులాయోతే ఇనేతి ఆమ్‍ బోల్యొ, కేధేబి రాత్నూ ర్హవో ధన్నూ ర్హవో విందు కర్తవొక్హత్‍ తారు దోస్తుల్‍నా, భైయ్యేవ్‍నా, బందుల్‍నా, దౌలత్‍ వాళనా నకోబులైస్‍; యూవ్నా బులాయోతో యూవ్నేబి తున బులవుస్యే, తేదె తూ కర్యోతే ఉపకార్‍నా యూవ్నేబి ఉపకార్‍ కర్‍సే. ");
INSERT INTO vgr_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","ఇనఖాజే తూ విందు కర్తీవోఖత్‍ గరీబేవ్‍నా, పాంగ్లేవ్‍నా, లంగడవ్‍నా, ఖాణవ్‍నా బులైన్‍ ఖాఢవో. ");
INSERT INTO vgr_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","తేదె తున రుణం పేఢనా యూవ్నాకన ఖాయిబి కోర్హాసేని. ఇనటేకె తూ ధన్యుడ్‍ హూయిస్‍. మరీగయూతే నీతినూ అద్మీయే పునరుధ్దానంధన్మా తెదె దేవ్‍ తునకర్యోతే అచ్చు కామ్‍నా బహుమానం మళ్‍స్యే. ");
INSERT INTO vgr_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","యత్రస్‍మా ఇనకేడె ఖావనా బేట్హుతే యూవ్నామా ఏక్‍ జణో యో వాతే ఖమ్జీన్‍, దేవ్‍నూ రాజ్యంమా ధాన్‍ ఖవళు ధన్యుడ్ కరి ఇనేతి బోలమా. ");
INSERT INTO vgr_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","తేదె ఇనేతి ఆమ్‍ బోల్యొ; ఏక్‍అద్మి మోటు విందు కర్నూ కరీన్‍ కేత్రాకీ జణానా బులాయో. ");
INSERT INTO vgr_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","విందునూ వొహఃత్‍ హాంకె హాఃరు సిద్దం హూయిరూస్‍ ఖావనా ఆవో కరి బులైమాంగాయితే యూవ్నేతి బోలాన ఏక్‍ దాసుడ్‍నా బోలిమొక్‍ల్యో. ");
INSERT INTO vgr_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","యూవ్నే హాఃరూబి ఏక్నూఏక్ సాకుల్‍ బోల్యా. ఆగళ్యోకీసికి మే ఖేతర్‍నా మోల్‍ లీధో ఇనా జైన్‍ దేకేనూ; ఇనటేకె మన మాప్‍ కర్‍ కరి బొల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","అజేక్‍ జణో మే పాఛ్‍ జోడ ధాండొనా లిధొ యో భరోభర్‍ కామ్‍ కరుకరాస్‍కీ కోయినికి దేఖాన జౌంగ్రుస్‍, మన మాప్‍కర్‍ కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","వుజేక్‍ జణో మే య్హా కర్‍లీదో. ఇనటేకె మన ఆవాన కోహూస్యేని కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","ఇమ్‍ యూవ్నే క్హారు బోల్యుతే వాత్నా లీన్‍ జైన్‍ ఇనా మాలిక్తి బోల్యు. యో ఛండాల్‍ ఖైన్‍, తూ యగ్గీస్‍ జైన్‍ క్హాయార్‍ని గల్లీయేమా, గొమ్ధీయేమా ఛాతే గరీబేవ్‍నా, లంగఢా పాంగళ్యేవ్‍నా, ఖాణవ్‍నా అజ్గ బులైల్యావ్‍ కరి ఇనా దాసుడ్‍తి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","ప్రభు తూ బోల్యొతిమ్మస్‍ కర్యొ పన్కి, అజుబి జోగొ ఛా కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","యజమానుడ్‍ ఇను దాసుడ్‍తి బోల్యొ, క్హయర్‍మా మారు ఘర్‍ భరవా ఖార్‍ఖు తూ జైన్‍ ఖేతర్‍మా, జైయిన్‍ ఎజ్గా రైతే అద్మీయేనా బులైల్యావ్‍ కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","మే ష్యాత్‍ బోలుకరుస్‍ కతో మే హాంకేతోడీ బులాయోతే యూవ్నామా ఏక్‍ జనోబి మారు విందుమా ఖాసే కోయిని కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","జనాల్‍ క్హారుజణు యేసునాకేడె జౌంగ్రతోతేదె యో యూవ్నా మ్హణీపరీన్‍, ");
INSERT INTO vgr_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","కోన్బి ఏక్జణో మారకనా ఆయిన్‍, ఇనా ఆయా, భా తీబి, బావణ్‍న లఢ్కాతిబి, భేనె, భైనా ఇనజాన్‍నాబి, ఇను యో నా ద్యేషించతో యో మారో సిష్యుడ్‍ కోహూస్యేని. ");
INSERT INTO vgr_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","ఇమ్మస్‍ కోన్బి ఇను సిలువనా పల్లీన్‍, స్రమపఢీన్‍, మర్రిజైయిన్‍, సిద్దంహుయీన్‍ మారకేడె నాఆయుతో యోమారో షిష్యుడ్‍ కోహూసేని. ");
INSERT INTO vgr_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","తుమారమా కోన్బి ఏక్‍ మ్హాడీ భాంద్నూకతో, యో భ్హాంధనా కేత్రా రఫ్యా హూవస్కీ, ఇనా కనా ఏత్రా రఫ్యా ఛాకీ కోయిని కరి యో దేఖిలీస్యే కున్నా? ");
INSERT INTO vgr_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","ఇనాకనా రప్యాఛ్చాకి కొయిన్‍కి నాధేఖీన్‍ భాంద్యుతో యో కామ్‍ ఆధాక్‍ఫర్‍ భిరి జాస్యే. ");
INSERT INTO vgr_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","దేఖావళు ఖారుబి ఆ అద్మిఆదూ భాందీన్‍, ఆదూ మ్హేందూదు కరి బోలీన్‍ ఇనూ షరం కాడ్‍స్యే. ");
INSERT INTO vgr_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","ఏక్‍ రాజో బుజేక్‍ రాజోతి యుధ్దంనా జానూ కతో ఇనాకనా ఛాతే దఖ్‍ః హజర్‍ సైనిక్‍తి యుధ్దం కర్‍స్యేతే యూవ్నూ ఈఖ్‍ః హజర్‍ సైనికుల్‍తీ యుధ్దంమా జీత్సునాకరీ సోఛ్‍స్యేకోయిన్నా? ");
INSERT INTO vgr_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","ఇనమా లఢనూ తాఖాత్‍ నా ర్హైతో యూవ్నే దూర్‍ఫర్‍ ర్హతివోఖత్‍ సందేష్‍ బోలిమోక్లీన్‍ దుష్మన్‍ కోయిన్‍తిమ్‍ మళీజస్యే. ");
INSERT INTO vgr_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","ఇమ్మస్‍ తుమ్నాఛాతే ఖారు నా మ్హేంధాతో మారు సిష్యుల్‍ కోహూస్యుని. ");
INSERT INTO vgr_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","మీట్ అష్యలస్, పన్కి ఇన్మనూ ఖారు ఛలిగుతో అజు కినేతి ఫాచు యో ఖారు ఆవ్సె. ");
INSERT INTO vgr_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","యో జమీన్‍నాబి, ఎరువునాబి కామే కోఆవాని, అజు ఇనా ఫేకీదేనూస్‍ పడస్‍. ఖంమ్జనా కాణ్‍ రవ్వాలు జత్తన్‍తి ఖంమ్జో కరి యూవ్నేతి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","ఏక్‍ వోహోఃత్‍ యేసు వాతే ఖంజనాటేకె కరి సుంకరుల్‍బి పాపుల్‍ కేత్రేకీ జణు ఇనాకనా ఆయూ. ");
INSERT INTO vgr_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","పరిసయ్యుల్‍బి, షాస్త్రుల్‍ యో ఖారు దేఖీన్‍, ఆ పాపేలవ్‍నా కందే కర్లీన్‍ యూవ్నేతి మలీన్‍ ఖాణు ఖౌంగ్రస్‍ కరి యూవ్నే గోణీగిలిధూ. ");
INSERT INTO vgr_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","ఇనటేకె యో యూవ్నా ఆమ్‍నూ ఉపమానం బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","తూమారమా కినాబి హోః మ్హెంఢర్హైన్, ఇన్మతూ ఏక్‍ మ్హేండా గమైగుతో, ఆ ఏక్కమ్‍ హోః మ్హేంఢా మ్హేంధిన్‍ యో ఏక్‍ మళతోడీ ఢూండ్‍స్యుకున్నా? ");
INSERT INTO vgr_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","యో మ్హేంఢా మళ్యు తేదె ఇనా ఖాందఫర్‍ నక్లీన్‍ ఖుషీతి ఘర్‍కనా ఆయిన్‍, ");
INSERT INTO vgr_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","గమైగయుతే మారు మ్హేంఢా ఫాచు మళ్యు; ఇనటేకె మార భరోబర్‍ తూమేబి ఖూషీ హూవో కరి బోల్‍స్యే. ");
INSERT INTO vgr_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","ఇమ్మస్‍ కేధేస్కి దిల్‍ భద్‍లాయిలీధూ హూయు నీతిగా ర్హవళు ఎక్కమ్ ఖొః అద్మీయేతిబి, దిల్‍ భద్‍లాయిలేవానునూ ఛాతే ఆ ఏక్‍ పాపితి స్వరగ్‍మా ఘను ఖుషీ హూవస్‍. ");
INSERT INTO vgr_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","ఏక్‍ బాయికోనా ధహ్‍ః రూపనూ బిళ్ళమతూ ఏక్‍ గమైగయుతో, “యో ఏక్‍ బిళ్లుమళతోడీ ఘర్‍మా ఊజాళునా బుడ్డీ బాళిన్‍ ఏన్‍ కరీన్‍ ఢూండ్‍స్యేకోయిన్నా?” ");
INSERT INTO vgr_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","యో బిళ్ళ మళ్యుతో ఇనాకనా కామ్‍ కరవళీయేనా, ఇనూ కందేనూ, బగళ్లునా బులైన్‍ మారు గమైగయుతే రూపనూ బిళ్ళు మళ్యు ఇనటేకె తూమేబీ మారబరొభ్బర్‍ ఖూషీ హూవోకరీ బోల్‍స్యేకొన్నా? ");
INSERT INTO vgr_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","ఇమ్మస్‍ దిల్‍భద్లాయిలేవళు ఏక్‍ పాపినటేకె దేవ్నూ దూతల్నా క్హామే ఖూషీ హూస్యే కరి తూమారేతి బోలుకరుస్‍. ");
INSERT INTO vgr_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","బుజు యో ఆమ్‍ బోల్యొ; ఏక్‍ అద్మినా బే ఛీయ్యా థా. ");
INSERT INTO vgr_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","పన్కి యో బేజణమా నానో ఛీయ్యో ఆయిన్‍ భా మన ఆవ్నూతే ఆస్తీమా మారు బాగ్‍ మన దాకరీ మాంగమా, యో ఇమ్మస్‍ నానో ఛీయ్యానూ బాగ్‍ ఇనస్‍ పాడీన్‍ దీనాఖ్యో. ");
INSERT INTO vgr_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","థ్హోడ ధన్మస్‍ యో నానో ఛీయ్యో ఇని ఆస్తినా లీన్‍ దేహ్‍ఃమా ఛల్‍జైన్‍, మలీన్‍ యో దౌలత్నా ఇనా క్హరాబ్‍కామ్‍నా ఖర్చు కర్యో. ");
INSERT INTO vgr_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","ఇమ్‍ రఫ్యా క్హారు ఖతంహూయిజవదీన్‍ ఘణు మోటు కాళ్‍ ఆయూ, తేదె యో గ్హణు ముసిబత్మా పడ్యోబుజు ఇనకనా కాయిబి కొయిని. ");
INSERT INTO vgr_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","తేదె యో క్హయార్‍మా ఏక్‍ అద్మికనా గయో, యో అద్మిఇనా ఢూకర్‍ ఛరావనా కరి ఖేతర్‍మా బోలిమోక్‍ల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","ఇనా కోన్బి అత్రు ఖాను‍బి దేవాళు కొమళ్యుని. ఇనటేకె యో ఢూకర్‍ ఖావనూ పోట్టు ఖానూ కరి రైగో. ");
INSERT INTO vgr_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","ఇనా తేదె బుద్ది ఆయిన్‍, మారు భా నూ ఘర్‍కనా కామ్‍ కరవళానా థక్‍తోడీన్‍ ఖవయేత్రు ధాన్‍ ఛా. పన్కి మన అజ్గ ఖాణు కోయిన్తే భుక్‍నా మర్‍జౌంగ్రుస్‍. ");
INSERT INTO vgr_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","మే వుట్టీన్‍ మారో భా కనా జైస్‍, భా మే, దేవ్నా, తారేఖుబి ఘాణు విరుద్‍గా పాప్‍ కర్యో; ");
INSERT INTO vgr_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","బుజు కేధేబి తారో ఛీయ్యో కరి బోలావనా మన యెత్రె లాయక్‍ కోయిని; ఇనటేకె మన తూమారు కామ్‍ కరవళమా ఏక్‍జణంతరతోబి గల్లా కరి బోల్‍నూ కరి సోచీన్‍, ");
INSERT INTO vgr_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","వూట్టీన్‍ ఇనా భా కనా ఆయో. యో ఇనూ భా నూ ఘర్‍ ధర్రాస్యు దూర్మా ఛాకతో ఇనా భా ఇనా దూర్తిస్‍ దేఖీన్‍ నాహ్‍ఃతో హూయిన్‍ ఆయిన్‍ ఇనా గలేంఢాఫర్‍ పడీన్‍ బుఛ్చా దిదో. ");
INSERT INTO vgr_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","తేదె యో ఇనా భా తి, మే దేవ్‍తిబి తారేతిబి మోటూ పాప్‍ కర్యొ. బుజు కేదేబి మే తారో ఛీయ్యో కరి బోలావనా మే లాయాక్‍ కోయిని కరి బోలామా. ");
INSERT INTO vgr_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","రైతోబి ఇనా భా ఇనా కామ్‍ కరవళాతి, మార ఛీయ్యానా పేరానూ అసేల్‍నూ లుంగ్ఢా, హాత్‍నా అంగోటీయే, గోఢానా చెప్లే లాయిన్‍ పేరావో కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","అష్యల్‍నూ బీష్యావళు ఏక్‍ పసువుణా లాయిన్‍ వాఢీన్‍ మోటు పండగంతర కరీయే. ");
INSERT INTO vgr_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","మరీగయోతే మారో ఛీయ్యో పాచు జీఉట్యో, గమైజైన్‍ పాచు మళ్యో కరి బోలామా, యూవ్నే ఖారు పంఢగ కరనిక్‍ల్యా. ");
INSERT INTO vgr_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","తేదె ఇనో మోటో ఛీయ్యో ఖేతర్‍మతూ ఆంక్రతో ఇనా ఘర్‍మతు గీతేవ్‍నూ ఖేల్‍నూ ఆవాజ్‍ ఖంమ్జయూ. ");
INSERT INTO vgr_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","యో దాసుల్‍మా ఏక్‍ జణానా బులైన్‍ ఘర్‍మా ష్యాత్‍ హూంక్రస్‍ కరి పుఛవమా. ");
INSERT INTO vgr_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","యో ఇనేతి తారో భై ఆయో, తారో భా నానో ఛీయ్యో అచ్చితర ఆయో కరి ఇనటేకె బిష్యావళు ఏక్‍ పషువు వాఢుకరస్‍ కరి బోలామా, ");
INSERT INTO vgr_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","యో వాతేనా ఖంమ్జీన్‍ ఖ్హీజ్‍ ఖైన్‍ యో ఘర్‍మా జవాన దిల్‍ నాహూవామా, తేదె ఇనా భా ఆయిన్‍ బతిమాల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","తేదె యో ఇనా భా తి అత్ర వరహ్‍ఃతూ తార కనా రైన్‍ తారీస్‍ వాతే ఖంమ్జు కరుస్‍నీ, కేధేబి మే మార దోస్తేవ్‍తి మళిన్‍ ఖూషీతి ఖావనా ఏక్‍ బోక్డుతోబి మన దిదోనా? ");
INSERT INTO vgr_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","కానీ ఆ తారో నానో ఛీయ్యో రైతో ఇని ఆస్తీలిన్‍ జైన్‍ క్హరాబ్‍వాళీయేతి ఖైయిన్‍ ఆయోతే ఇనా మాత్రం బిష్యావళు పషువు వాడీ పంఢగ కరుకరస్‍. కరి ");
INSERT INTO vgr_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","తేదె యో, మారొ ఛీయ్యో! తూ కేధేబి మారస్‍ కనా ఛా. ఇనటేకె “మారు హాఃరూబి తారుస్‍తో.” ");
INSERT INTO vgr_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","అప్నే ఖూషీ హూవనూ, ఆనందించనూ అసేలస్‍; ష్యానకతో భై మరీజైన్‍ ఫాచు జీవిన్‍ ఉట్యో, గమైజైన్‍ ఫాచు మళ్యో కరి ఇనేతి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","ఏక్‍ ధనే యేసు ఇను షిష్యుల్‍తి అమ్‍ బోల్యొ; ఏక్‍ మ్హాజీన్‍నా ఘరే ఏక్‍ మాలిక్‍ కామ్‍ కర్తొ థో. యో ఇని ఆస్తినా నుక్చాన్‍ కరూకరస్‍ కరి ఇనఫర్‍ ఛాడి బోలామ. ");
INSERT INTO vgr_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","యో మ్హాజీన్‍ ఇనా బులైన్‍, తార మ్హణీతూ క్హంమ్జాయుతే యో ష్యాను వాత్‍? కరి బోలిన్ తున అజు ఆ కామ్‍మా తున రాఖాన లాయక్‍ కోయిని, తూ కెత్రా ఖర్చు కర్యోకి యో క్హారు లెక్కల్‍వతాళ్‍ కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","తెదె యో గుమస్తా దిల్మా ఆమ్‍ సోచిల్దొ; హాంకే మన ఆ కామ్మతూ కణ్నాకి దిస్యే, మే ష్యాత్‍ కర్నూ? క్హేతార్‍మా క్హొందాను కామ్‍తో కోకర్‍నారోని అజు భీమాంగీ జీవనాబి షరం లగ్గస్‍. ");
INSERT INTO vgr_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","కేదె హుయితో మన ఆ కామ్మతూ కణ్నాఖ్యోతొ, తేదె దోస్తుల్‍ మన కంధే కర్‍లేను కతో ష్యాత్‍ కర్నూకీ మన మాలంకరి లాహీజైన్‍. ");
INSERT INTO vgr_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","తేదె ఇనా మాలిక్‍నా కోన్‍ కోన్‍ ఉధార్‍ ఛాకీ యూవ్నా బులైన్‍ మరా మాలిక్‍నా కేత్రా ఉధార్‍ ఛా కరి మోదుల్‍ అద్మి పుఛాయో. ");
INSERT INTO vgr_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","యో అద్మి ఖోః కేజీనూ తేల్‍ కరి బోలామా ఇమ్‍ హూస్యేతో తూ ఎగ్గీస్‍ బేసిన్‍ ఆ ఛీటిఫర్‍ ఆఢైఖ్‍ః మున్తా తేల్‍న లీఖ్‍ కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","పాసల్తి అజేక్‍ జణానబి ఇమ్మస్‍ బులైన్‍ తూ కేత్రా దేనూ కరి బోలామా, ఖోః గౌని సంచుల్‍ కరి బోల్యొ, ఇనబి ఆ ఛీటిఫర్‍ ఛారీఖ్‍ః సంచుల్‍నా లిఖ్కిలాకరీ బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","యో మాలిక్‍, మోసం కరవళొ గుమస్తాన తూ ఘాణు ఛలాక్‍ కరి ఇనా హాఃరైన్‍, ఉజాళునూ అద్మి ఆత్మీయతమా దేఖాడతే హూషార్‍తిబి, ఆ ములక్‍నూ అద్మీయే వఖ్వోనూ బట్టీ దేఖ్యాతో గ్హణు హూషార్‍తి ర్హాస్‍. ");
INSERT INTO vgr_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","యేసు ఆమ్‍ బోల్తో హుయిన్‍ “ఆ ములాక్‍ను రఫ్యాతి దోస్తుల్‍నా కమైలేవో; కీమ్‍ కతో యో రఫ్యా తుమ్నా మ్హేందీన్‍ జావనివహఃత్‍ నిత్యంహుయితే ఘేర్మా యూవ్నే తూమ్‍నా ఆదిలీస్యే” కరి తూమారేతి బోలుకరుస్‍. ");
INSERT INTO vgr_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","థోడ విషయంమా నమ్మకంతి ర్హవళు, మోటా వీషయంమాబి నమ్మకంతి ర్హసే. పన్కి థోడ విషయాంమ మోసం కరవళు, గ్హణ విషయంమబీ మోసం కర్షే. ");
INSERT INTO vgr_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","ఇనటేకె తూమే అన్యయంను దౌలాత్‍న తూమే నమ్మకంగా నార్హయ్యాతో, హాఃఛి రఫ్యావ్‍నా తూమ్నా కోన్‍ దీస్యే. ");
INSERT INTO vgr_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","తూమే ఫరాయిను దౌలత్‍ను విషయంమా నమ్మకంతి నార్హయ్యాతో, తూమారు సోంత దౌలత్‍నా కొన్‍ దిస్యే? ");
INSERT INTO vgr_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","ఖ్హయు దాసుడ్‍బి, భే మాలిక్‍ధార్నా సేవా కరనాకోహోయిని. ఇమ్‍ రైతో ఏక్‍నా ఫ్యార్‍కరీన్‍ ఏక్‍నాఫర్‍ ఛండాల్‍ ఖాసే, నైతో ఏక్‍ని వాత్ఫర్‍ ఛాలీన్‍ అజేక్‍నా ధకల్‍నాక్‍సే. తుమె దేవ్నా, దౌలత్‍నా యోస్‍ వక్హాత్‍మా సేవ కరానకోహూవాని కరి ఖఛ్చితంగా బోలుకరుస్‍. ");
INSERT INTO vgr_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","రఫ్యానూ లాంఛీను పరీసయ్యుల్‍ యో వాతేనా హఃమ్జీన్మ్జీ న్‍, యేసునా గేలీ కాఢుకరాతో, ");
INSERT INTO vgr_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","తేదె, తుమే క్హారు అద్మీవ్‍కనా నీతినూ అద్మీయేనితర ఛాలస్‍ పణికి, తూమారు దిల్‍ కీమ్‍నూ కీ దేవ్‍నా మాలం. “అద్మీయేనా అసేల్‍ కరి దేఖావతే, యో దేవ్‍నా డోలమా గ్హణు ఖరాబ్‍ దేఖవస్.” ");
INSERT INTO vgr_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","బాప్తిస్మమ్‍ దెవ్వాలొ యోహాన్ను ఆవతోడీ ధర్మషాస్త్రంబీ, ప్రవక్తల్‍ బోధించాను థూ. తేప్తూ ధరీన్‍ దేవ్‍నూ రాజ్యంనూ సువార్ ప్రచార్‍ హూయు, హర్‍ ఏక్‍ జణు యో రాజ్యంమా జనూకరీ జభర్‍దస్తిఖు. ");
INSERT INTO vgr_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","మోషే ధర్మషాస్ర్తం మనూ ఏక్‍ న్హాను అక్చర్‍బి నామటీజావానుతీబి ఆకాష్‍బి జమీన్‍ గళిజావను హల్కు. ");
INSERT INTO vgr_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","ఏక్జణు తలాక్‍ ఇని బావణ్‍నా లీక్కీన్‍ దినాకీన్‍ బుజేక్‍ బావణ్‍నా కరవాళు వ్యభిచార్‍ కరూకరస్‍. యో తలాక్‍ దేవాయిరీతె బాయికోనబి కోన్‍ య్హా కర్లేస్‍కీ యువ్నేబి వ్యభిచార్‍ కరూకరస్‍. ");
INSERT INTO vgr_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","ఏక్‍ మోటొ మ్హాజీన్‍ థొ. యో భారి మోల్ను లుంగ్డా పేరిన్‍ ఖైన్‍ పీన్‍ రోజ్‍ సుఖ్‍తి ర్హాతొ థో. ");
INSERT INTO vgr_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","ఇనా ధర్వాజనా ఖమేస్‍ లాజర్‍ కరి ఏక్‍ గరీబ్‍ థూ, యో ఆంగ్‍ అక్కు పోఢాతిస్‍ భరైన్‍, యో మ్హాజీన్‍ ఘర్‍నా భార్‍ పఢ్‍ర్హతూథూ. ");
INSERT INTO vgr_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","ఇనా భుక్‍ లగ్యూతో యో మ్హాజీన్‍ను ఖావనూ బల్లఫర్‍తూ ఇట్టా రోటానా టుక్డా పఢ్యుతో ఇనా ఖైన్‍ భుక్‍ తోణ్‍నూ కరి ఆహ్‍ఃతీ ర్హాతో థో. ఏత్రేస్‍ కాహేతిమ్‍ ఖుత్ర్యా ఆయిన్ యో ఫోఢావ్‍నా ఛాట్‍తూథూ. ");
INSERT INTO vgr_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","తేదె గరీబ్‍ అద్మి మరీజైన్‍ దేవదూతల్‍నా హాతే లీ జైన్‍ అబ్రాహామ్‍ని ఖోళామా బేఖానా గయో. మ్హాజీన్‍బి తేదెస్‍ మరిన్‍ మాటీమా సమాధి కరమా. ");
INSERT INTO vgr_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","తేదె యో పాతాళంమా పఢీన్‍ ఆగ్మా బాధపడ్తో హూయిన్‍ ఢోళపాఢీన్‍ దేఖమా అబ్రాహామ్‍ని మాంఢీఫర్‍ లాజర్‍ బెట్టోతే ఘణు దూర్‍తి దేఖైయూ. ");
INSERT INTO vgr_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","భా హూయోతే అబ్రాహామ్ను! మే ఆగ్మాబధాపడుకరుస్‍ మారఫర్‍ గోర్‍ కరీన్‍, ఇని ఛీటిఆంగ్లీ పాణిమా భీజైన్‍ మారు జీబ్‍నా ఠంఢు కరానా టేకె లాజర్‍నా బొలిమోకల్‍; కరి రోతోహూయిన్‍ చిక్రీన్‍ బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","తేదె అబ్రాహామ్ను, మారో ఛీయ్యో! తూ జీవ్‍తో ర్హయ్యో తేదె తారు జీందగీమా ఖాధో, పీనూకి పీధో అసేలస్‍ సుఖపడ్యో. కానీ లాజర్‍ హాంకే నేమ్మదితి ఛా. తూ వేధన పడుకరస్‍. ");
INSERT INTO vgr_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","ఆ కాహేతిమ్‍ దేక్‍ అజ్గానూ ఏజ్గా నా ఆవ్‍నూతిమ్‍ ఏజ్గాను అద్మిఅజ్గా నా ఆవ్‍నూతిమ్‍ బేహేనా ఇఛ్మా ఏక్‍ మోటు ఆగాధం ఛా. ");
INSERT INTO vgr_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","తేదె యో మహీజైన్‍ భా ఇమ్‍ హూస్యేతో. మార భాన ఘేరే లాజర్‍నా బోలిమోకల్‍ కరి తూన బతిలాడుకరుస్‍. ");
INSERT INTO vgr_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","ఏజ్గా మరా పాచ్‍ భైయ్యే ఛా! యూవ్నేబి మారీంతర అజ్గ నా ఆవ్‍నూ తిమ్‍ యూవ్నా ఆవాతే బోలుకరుస్‍. ");
INSERT INTO vgr_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","ఇనటేకె అబ్రాహామ్ను, యూవ్నా కనా మోషేబి, ప్రవక్తల్‍ లిఖుతే పుస్తకం ఛా; ఇవ్నే ఖారు ఇవ్నూ వాతస్‍ ఖంజ్నూపడస్‍ కరి బోలామా, ");
INSERT INTO vgr_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","భా అబ్రాహామ్ను ఇమ్‍ నకో బోల్‍; మరీ హూయుమతూ కోన్‍బి గయూతో యూవ్నేపాపం బేదిన్‍, కరి యో మ్హాజీన్‍ బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","అబ్రాహామ్ను, మోషేబి ప్రవక్తల్‍నూ వాతస్‍ ఖంజునాతో, మరిన్‍ జీవిహూయు ఏక్‍ జణో గయోతోబి యూవ్నే నమ్‍స్యేకోయిని కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","యేసు ఇనా షిష్యుల్‍తి ఆమ్‍ బోల్యొ, ఠోకర్‍ ఆవ్సేకొయినితిమ్ ర్హాసెకొయిని, పణికీ యో సోదాన కీనేతీ ఆవ్‍స్యేకీ ఇనా స్రమా. ");
INSERT INTO vgr_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","ఆ అఢ్డాని లఢ్‍కావ్‍మా ఏక్‍నా ఆఠంక్‍ కరవళనా గుధ్దినా గట్టీనో భండో భాందిన్‍ ధర్వావ్‍మా నఖైజావనూ ఇనా కెత్రూకి మేల్. ");
INSERT INTO vgr_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","తూమారి విషంమా జత్తన్‍థి ర్హవో; తూమార భైయ్యే గల్తీ కర్యుతో యూవ్నా తూమే గుర్‍కావో, పష్చతమం పడ్యూతో యూవ్నా మాఫ్‍ కరో. ");
INSERT INTO vgr_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","యో ఏక్‍ ధన్నా ఖాత్‍వోహోఃత్‍ తునా గూర్చి గల్తీ కరీన్‍ ఖాత్‍వోహోఃత్‍ తూమార కనా ఆయిన్‍ మే పష్చతమం పడ్యో కరి బోల్యుతోబి, ఇనా మాప్‍ కర్నూ. ");
INSERT INTO vgr_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","“హమారు విష్వాసంనా అజు ఘణు భఢవ్‍” కరి సీష్యుల్‍ ప్రభుతీ బోల్యా. ");
INSERT INTO vgr_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","తుమే రాయినూ గింజ ఏత్రే విస్వాసం రాక్యతో బైస్‍; ఆ కంభళినూ జాఢూ జఢ్‍ ఖామేస్‍ ఉక్‍డైన్‍ ధర్వావ్‍మా ఘడ్‍ కరి బోల్యుతో యో తూమారి వాతే ఖాజ్‍స్యే. ");
INSERT INTO vgr_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","తూమారు ఢాండ బోకఢా ఛరవళుస్‍కీ, కేత్తర్‍ వాడీ కరవళు దాసుడ్‍ కామ్‍ కరీన్‍ ఘర్‍ కనా ఆయుతో, తేదె “తూమే ఇనా ఆవ్‍ బేసిన్‍ ధాన్‍ ఖా కరి బోల్‍స్యునా?” ఇమ్‍ కో బోల్‍స్యుని. ");
INSERT INTO vgr_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","మే ఖాణు ఖావనా తయార్‍ కర్‍, అజు మే ఖావతోడీ మన సేవ కర్‍ కరి బోలిన్‍, ఇనబాద్‍మా తూబి ఖా పీ కరి బోల్‍స్యే. ");
INSERT INTO vgr_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","యో, బోల్యోతిమస్‍ ఇనో సేవకుడ్‍ యో కామ్‍ ఆష్యల్‍తీ కర్యోకరీ యో మాలిక్‍ మారఫర్‍ ఉపాకర్‍కర్సేన, నేయితో ఇనా క్హారౌస్యేనా? ");
INSERT INTO vgr_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","ఇమ్మస్‍ తూమ్‍న బోల్యుతే కామ్‍ కర్యాతేదె హామే యోగత్‍ కోయిన్తె దాసుల్‍. తూమే బోల్యాతిమ్‍ కర్యా. యో హమారు కామ్‍ కరి బోల్‍నూ కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","యేసు యెరూషలేమ్‍నా టేకె నికీన్‍ గలిలయథూ సమరయనా ఇచ్మా మరాగ్‍తు జాతోర్హయో, ");
INSERT INTO vgr_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","ఏక్‍ గామ్‍మా జౌంగ్రతో ఖోడ్‍నూ రోగ్‍వళు ధక్హ్ జణ ఇనా దేఖీన్‍ ఇనేతి దూర్‍మా భీరీన్‍, ");
INSERT INTO vgr_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","బొధకుడ్‍ యేసు హమారఫర్‍ గోర్‍ కర్‍కరీ యూవ్నే ఖారు చిక్రానిక్యు. ");
INSERT INTO vgr_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","యో యూవ్నా దేఖీన్‍ తూమే జైన్‍ తూమర యాజకుడ్‍నా దేఖాడో కరి బొలామా యూవ్నే ఇమ్‍ జాథి వోహోఃత్‍ యూవ్నే ఖుద్రగయా. ");
INSERT INTO vgr_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","యూవ్నామా ఏక్‍ జణొ ఇనా ఖుద్రగయోతే దేఖిన్‍, మోటా ఆవాజ్‍థి యో దేవ్‍నా కృతజ్ఞత కర్తోహుయిన్‍, ");
INSERT INTO vgr_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","యో పాచు యేసు కనా ఆయిన్‍, ఇనా కృతజ్ఞత బోలిన్‍ ఇనా గోఢాఫర్‍ పడ్యో. యో ఏక్‍ సమరయుడ్‍. ");
INSERT INTO vgr_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","ఇనఖాజే యేసు “తూమే ధఖ్‍ః జణ అసేల్‍ హూయాని” బుజు నౌ జణ కేజ్గా గయా? ");
INSERT INTO vgr_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","ఆ ఏక్‍ జణో తప్ప బుజు కోన్‍బి దేవ్‍నా మహీమ కరనా కోఆయుని. ");
INSERT INTO vgr_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","“తూ వుటీన్‍ జా; తారు విష్వాసమస్‍ తూనా ఖుద్రయూ” కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","పరిసయ్యుల్‍, ఖారు యేసుతి, ప్రభు దేవ్‍నూ రాజ్యం కేదె ఆవ్‍స్యే కరి బోలామా యో ఇవ్నేతీ “దేవ్నూ రాజ్యం అఖ్కావ్‍నా దేఖావఖార్‍కు కోఆవ్‍స్యేని” కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","ష్యానకతో దేవ్‍ రాజ్యం తుమరామా ఛా. ఇనటేకె హదేక్‍ అజ్గ ఛా ఏజ్జా ఛాకరీ బోలనూ హూవనూ కాహే కరి తుమారేతి బోలుకరుస్‍. ");
INSERT INTO vgr_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","ఇనబాద్‍మా యేసు ఇన సిష్యుల్‍తీ ఆమ్‍ బోల్యొ, తూమే ఏక్‍ ధనే అద్మీనో ఛీయ్యోతి ఏక్‍ చోట్‍తోబి దేకును కరి ఆఖ్‍ః కర్‍స్యు పన్కి ఇమ్‍హూస్యే కోయిని. ");
INSERT INTO vgr_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","అద్మియే తూమ్‍న అమ్‍ బోల్యుతెదె హదేక్‍ అజ్గ ఛా, ఏజ్గా ఛాకరీ బోల్యుతో యూవ్నా కేడె నకో జాస్యు. ");
INSERT INTO vgr_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","ష్యానకతో ఆకాష్‍మా ఏక్‍ దిక్కుతూ ధరీన్‍ అజేక్‍ దిక్కుతోడీ ఇజ్లీ కీమ్ జమ్కాస్‍కి యో ధన్‍మా అద్మీనో ఛీయ్యోబి ఇమ్మస్‍ ర్హసే. ");
INSERT INTO vgr_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","పన్కీ అగాఢి అద్మినొ ఛీయ్యో కఛ్చితంగా కెత్రేకి మ్హీనత్‍ వోఖ్కో పణ్‍నూ, బుజు ఆపీడీనూ అద్మీయేతి యో దూర్‍ ధక్‍లావ్‍నూ. ");
INSERT INTO vgr_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","నోవహు ధన్‍మా జర్‍గ్యుతిమ్‍ అద్మీనో ఛీయ్యోనూ ధన్‍మాబి ఇమ్మస్‍ హూస్యే. ");
INSERT INTO vgr_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","నోవహు ఇనూ జ్హాజ్‍మా గయోతే ధన్‍తోడీ అద్మీయే ఖాతు పీతూహూయిన్‍, య్హా కర్‍తూహూయిన్‍ య్హా కర్‍లేతూర్హయూ. ఏత్రస్‍మా జల్‍ప్రళయం ఆయిన్‍ అద్మీయే ఖారనా నాషనం కర్యు. ");
INSERT INTO vgr_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","లోతునూ ధన్‍మా హూయుతిమ్‍బి హూసే. అద్మీయే ఖాతు పీతూ మోల్‍ లేతూహుయిన్‍ నార్‍ గాడ్తూహుయిన్‍ ఘర్‍ భాంధ్తూర్హయు. ");
INSERT INTO vgr_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","పన్కి లోతు సోదొమనా మ్హేంధీన్‍ గయూతే ధన్నే ఆకాష్‍మతూ బలాతే ఆగ్‍నూ గంధకల్‍ వార్‍ఖిన్‍ యూవ్నే ఖారవ్నా నాషనం కర్యు. ");
INSERT INTO vgr_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","ఇమ్మస్‍ అద్మీనో ఛీయ్యో బేమానీ చోట్‍ ఆయోతే ధన్‍మా హూస్యే. ");
INSERT INTO vgr_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","యో ధన్‍మా మీద్దిఫర్‍ ర్హవళు రఛా పాణ్నూ కరి ఘర్‍మా నా జనూ, ఇమ్మస్‍ ఖేతర్‍మా ర్హవళు పాచు పరీన్‍ ఘర్‍నా నా ఆవ్‍నూ. ");
INSERT INTO vgr_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","లోతుని బావణ్‍నా యాధ్‍ కర్‍లేవో. ");
INSERT INTO vgr_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","ఇనూ జాన్‍నా భఛయ్‍లేనూ కరి ధేఖావళు ఇనా జాన్‍నా గమైలీస్యే. జాన్‍ మ్హేంధానటేకె తయార్‍ ర్హవళు ఇనా జాన్‍నా భచైలీస్యే. ");
INSERT INTO vgr_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","యో రాతే మంఛఫర్‍ బేజణ ఖుత్యాతో ఇవ్నేమా ఏక్జనో పఢైజాసే ఏక్జనో మేందైజాస్యే. ");
INSERT INTO vgr_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","బే బాయికా ఘట్టీ ధళుకరతో యూవ్నామా ఏక్‍ జణి పడ్వాసే, ఏక్ జణీ మేంధైజాస్యే. ");
INSERT INTO vgr_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","బుజు ఖేతర్‍మా కామ్‍ కర్తురస్‍, యూవ్నామా ఏక్‍ జణో ఫడైజైన్‍, ఏక్జణొ మేంధైజాసె. ");
INSERT INTO vgr_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","షిష్యుల్‍ పుఛ్చాయ, ప్రభు ఆహాఃరు కెజ్గా హుసేకరి బోలమా, యేసు, ముర్దా కెజ్గరాస్కి కేజ్గా రస్‍కీ గరధ్‍దేబి ఏజ్గాస్‍ బ్హారవాస్‍, కరి యూవ్నేతి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","ఇనా సీష్యుల్‍ విసక్నూనాతిమ్‍ కెదేబి ప్రార్దనస్‍ కర్నూ కరి, నీరాఖ్‍ః నా హూను కరి బోలాన టేకె యూవ్నేతి ఏక్‍ ఉపమానం బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","దేవ్‍థి నాఢరీన్‍ అద్మీయే కతోబి ఇమాన్‍ కోయినితిమ్‍ ఏక్‍ నెయ్యో ఏక్‍ ఖాయార్మా థో. ");
INSERT INTO vgr_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","యోస్‍ హఃయర్మా విధవరాల్‍ థీ. యో న్యాయాధిపతి కనా కేత్రేకీ వొహొఃత్‍ ఆయిన్‍, మనాబి మారో వైరీ న్యాయం కర్‍ కరి బోలీన్‍ బోల్తీరై ");
INSERT INTO vgr_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","గానీ యో థోడ ధన్‍ నా ఒప్పిన్‍, ఇనబాద్‍మా యో మే దేవ్‍నాబి నాఢరీన్‍, అద్మీయేనాబి లేక్కకరుకోయినితిమ్‍ రైతోబి, ");
INSERT INTO vgr_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","ఆ విధవరాల్‍ ఘడీ మరా కనా ఆయిన్‍, మన ఘభ్రాయినగ్‍దేంగ్రస్‍, ఇనటేకె యో బుజు ఘడీ ఆయిన్‍ గోజార్నూతిమ్‍ ఇనటేకె కీమ్‍బి న్యాయం కర్నూ కరి సోఛాస్‍. ");
INSERT INTO vgr_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","బుజు యేసుప్రభూ ఆమ్‍ బోల్యో, “యో అన్యాయ్‍ న్యాయాధిపతినూ వాతే ఖంజో; ");
INSERT INTO vgr_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","దేవ్‍ ఏర్పరచిలిదోతే యూవ్నే ఇనా రాత్‍నూ ధన్‍నూ ప్రార్దన కర్యుతో యూవ్నా న్యాయం కర్షేకోయిన్నా? యో యూవ్నా యగ్గీస్‍ న్యాయం కర్షే; ");
INSERT INTO vgr_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","యూవ్నా టేకెస్‍ కాహేనా దేవ్‍ దీర్ఘసాంతం దేఖాడుకరస్‍ కరి యూవ్నేతి బోల్యొ. రైతోబి అద్మీనో ఛీయ్యో ఆ జమీన్‍ ఫర్‍ ఆయోతొ అద్మీయేనూ విస్వాసం దేకావ్‍సేనా?” కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","హమేస్‍ నీతి వాళకరీ బోల్లిన్‍ పార్లేవ్‍నా కంజోర్కరి దేక్హావలనా యేసు ఏక్‍ ఉపమాన్‍ బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","ప్రార్దన కరాన ఖాజే కరి బేజణా దేవ్ను ఆలయంమా గయా. ఇవ్నామా ఏక్‍ పరిసయ్యుడ్‍బి, ఏక్‍ సుంకరి. ");
INSERT INTO vgr_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","పరిసయ్యుడ్‍, ఏక్‍ బాజు భీరిన్‍, దేవ్‍ మే ఛోట్టావ్‍నితరతోబి, వ్యభిచార్‍నితరతోబి, పార్లేవ్‍నితర కతో మోసం కరవాళోనితర, ఆ సుంకరీంతర తోబి మే కోఛౌని, ఇనటేకె తూనా కృతజ్ఞత్‍ కరుకరుస్‍. ");
INSERT INTO vgr_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","వారంమా బే ధన్‍ ఉపవాస్‍ కరుస్‍, అజు మరు ధంధాఖారమాబి ధఖ్‍వంతు దేవ్నా దేంగ్రుస్‍ కరి బోలిన్‍ ప్రార్ధన కర్యో. ");
INSERT INTO vgr_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","పన్కి సుంకరి దూర్‍తీస్ హీబ్రీన్‍, ఆబ్‍మ్హణీ ముఢ్‍క్యు పాఢనాబి హిమ్మత్‍ కోయినితిమ్‍, ఛాతీ కుట్‍లేతు హూయిన్‍ దేవ్‍ మే పాపి హూయిరోతే మన గోర్‍ కర్‍ కరి బోల్యు. ");
INSERT INTO vgr_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","తేదె దేవ్ను నజార్‍మా పరిసయ్యుడ్‍తిబి సుంకరిస్‍ నీతి వళో కరి ఎంచిలిన్‍ యో ఇనూ ఘర్‍కనా గయో. ఇనూ యో తగ్గాయిలేవళు కోన్‍కీ యూవ్నే హెచ్చింపబడ్‍స్యే, హేచ్చీంచిలేవళు తగ్గాయి జాస్యేకరీ బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","అడ్డాణి లఢ్కావ్‍నా లీన్ ‍ఆయిన్‍ యేసునా హాతేహుః బేందావునుకరి థోడుజణు యేసుకనా ఆంగ్రతో, సిష్యుల్‍ దేఖీన్‍ యూవ్నా గుర్‍కాయు. ");
INSERT INTO vgr_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","కానీ యేసు “యూవ్నా కంధే బులైన్‍, అఢ్డానీ లఢ్కావ్నా మారకనా ఆవదే యూవ్నా ఆఠంక్‍నకో కరో. దేవ్నూ రాజ్యం ఇమ్నూ లఢ్కావ్‍నితరాస్” కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","“అఢ్డానీ లఢ్కావ్నితర కోన్‍ దేవ్నూ రాజ్యంనా కోఒప్పిలిషేకరి యో అష్యల్ దేవ్ను రాజ్యంమా కోజాసేని” కరి తూమారేతి ఖఛ్చితంగా బొలుకరూస్‍. ");
INSERT INTO vgr_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","ఏక్‍ అధికారి యేసుతి, “అష్యల్ బోధకుడ్! నిత్యజీవంమా జానుకతో మే సాత్‍ కర్‍నూ” కరి పుఛ్చావమా. ");
INSERT INTO vgr_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","ఇనటేకె యేసు, తూ మన అఛ్చొ కరి కీమ్‍ బోలుకరస్‍? దేవ్‍ ఎక్కస్‍ అష్యల్ పన్కి అజు కోన్‍బి అష్యల్ కోహుస్యేని. ");
INSERT INTO vgr_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","తుమ్నా దేవ్ను ఆజ్ఞా తుమ్నామాలం, వ్యభిచార్‍ నకో కరో, నర్ హత్యనకో కర్‍స్యు, ఛోర్‍నూ కామ్‍ నకో కరో, జూటీ వాతే నకో బోల్‍స్యు, తారు ఆయా భాన గౌరవించును కరి ఇనేతి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","తేదె యో కవ్వారు యో హాఃరు మే అఢ్డాని ఫర్తూస్‍ కరూకరుస్‍నీ? కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","యేసు తున అజున్‍బి ఏక్‍ కమ్‍ ఛా. తారీ దవ్లత్‍ హాఃరు ఏచినాఖీన్‍ గరీబేవ్‍నా ధా. తేదె స్వర్గంమా తునా దవ్లత్‍ హుస్యే; తేదె తూ మారకేడె ఆవ్‍ కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","పన్కి యో కవ్వారు మోటొ దవ్లత్‍వాలొ థో! ఇనటేకె యో వాతే హఃమ్జీన్‍ దుఃఖ్‍ పడీన్‍ యో అగాఢి పాషళ్‍ హూవమా, ");
INSERT INTO vgr_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","యేసు ఇనాదుఃఖాపడాను దేక్హీన్‍, దౌలత్‍ వళు దేవ్‍నూ రాజ్యంమా జావను గ్హణు కష్టం. ");
INSERT INTO vgr_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","దౌలత్‍ వళు దేవునిరాజ్యంమా జావను తీబి ఖూయీను ఛీల్లామా వూట్‍ పేఖానూ హాల్కు కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","యో వాతే ఖంజ్యుతే యూవ్నే ఖారు ఇమ్‍ హూస్యేతో బుజు కోన్‍ దేవ్మా రక్చణ లీస్యే కరి పుఛ్చావమా? ");
INSERT INTO vgr_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","తెదె యేసు బోల్యొ, అద్మీయేనా అసాద్యం హుయోతే ఖారూబి దేవ్నా సాద్యం హూస్యే. ");
INSERT INTO vgr_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","తెదె పేతురు హాధేక్‍, హామే హామ్నా ఛాతే ఖారు మ్హేంధిన్‍, తార కేడేస్‍ ఆయిత్రని కరి బోలామా, ");
INSERT INTO vgr_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","యో దేవ్‍నా రాజ్యంనాటేకె ఘర్‍, భావణ్‍ లఢకా, భైయ్యేవ్‍నా, ఆయా భా, మ్హేంధిదూతే కోన్‍బి “యూవ్నే కోన్‍బి, ");
INSERT INTO vgr_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","జమీన్‍ఫర్‍బి, స్వర్గంఫర్‍బి నిత్యజీవం మల్సెకరి ఖఛ్చితంగా” కరి తూమారేతి బోలుకరుస్‍. ");
INSERT INTO vgr_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","యో భార జణ షిష్యుల్‍నా బులైన్‍, హాధేకో అప్నే యేరుషలేమ్‍మా జౌంగ్రెస్‍; అద్మీనో ఛీయ్యోనాటేకె ప్రవక్తల్‍నా హాతే నీఖైర్యూతే ఖారు వాతే జరగ్‍స్యే. ");
INSERT INTO vgr_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","యో అన్యుల్‍నా యుదు హువాకోయినితే ఇవ్నా హాతె ధరైన్‍, యూవ్నే ఇనా గేలి కాడీన్‍ ఇనాఫర్‍ తూకీన్‍ ఇజ్జత్‍ కాడ్‍స్యే. ");
INSERT INTO vgr_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","బుజు ఇనా కోల్డోతి మారీన్‍ మర్రాక్‍స్యే, తేదె యో తీన్‍మనూ ధన్నే పాచు జీవిన్‍ ఉట్‍స్యే కరి యూవ్నేతి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","యో వాతే ఖారు యూవ్నా జరబి అర్దం కోహూయుని, సానకతో యో సంగతి లఫిరయు, ఇనటేకె యో బోల్యోతె వాత్‍ యూవ్నా మాలంకోయిని. ");
INSERT INTO vgr_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","యో యెరికో క్హాయార్‍మా గయో తేదె ఏక్‍ ఖాణు అద్మి మారగ్నసేడె బేసీన్ భిక్‍మాంగ్తూహుయిన్‍ బేట్హూతూ. ");
INSERT INTO vgr_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","జనాల్‍ హాఃరు జౌంకరతే ఆవాజ్‍నా ఖంజీన్‍ యో ఆ ఖారు ష్యాత్‍ హూంగ్రస్‍ కరి పుఛాయూ. ");
INSERT INTO vgr_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","ఇవ్నే, నజరేయుడ్‍నో హుయోతే యేసు ఆ వాటే కరి జౌంగ్రస్‍ కరి బోలు. ");
INSERT INTO vgr_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","తేదె యో, యేసు దావీద్‍నో ఛీయ్యా! మన కరుణించ్‍ కరి ఖైకార్‍ మ్హేంధామా. ");
INSERT INTO vgr_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","యేసునా కేడె జవళు హాఃరు ఇనా గఛ్చుప్‍ ర్హాకరీ బోలామా, యో అజు గ్హణు చీక్రీన్‍ దావిద్‍నా ఛీయ్యా మన మరాఫర్‍ గోర్‍ కర్‍ కరి బోల్యు. ");
INSERT INTO vgr_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","ఏత్రమస్‍ యేసు భీరిజైన్‍, ఇనా మారకనా బులైల్యావో కరి బోల్యొ, యో కంధే ఆవమా, యేసు బోల్యొ, ");
INSERT INTO vgr_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“మే తూన ష్యాత్‍ కర్నూ కరి ఆహ్‍ః కరూకరాస్‍ కరి పుఛవమా” మన దేఖాన డోలాన నజార్‍ ఆవ్నూ కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","యేసు బోల్యొ, తూనా ఢోలాను నజార్‍ అవ్నూ, తారు విష్వాసంమస్‍ తునా అష్యల్‍ హూయు. ");
INSERT INTO vgr_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","యగ్గిస్‍మా ఇనా డోలాను నజార్‍ అవామా, తేదె యో అద్మి దేవ్‍నా స్తుతికర్తోహుయిన్‍, ఇనా కేడె గయో. జనాల్‍ ఖారుబి దేఖీన్‍ దేవ్‍నా స్తుతించ్యు. ");
INSERT INTO vgr_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","యేసు పర్తోహుయిన్‍ యెరీకో ఖాయార్మా కరి పేషీన్‍. ");
INSERT INTO vgr_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","యో వాటే కరి జాతోర్హయో. హాధేకో పన్ను వసూల్‍కరవాళొ మోటో అధికారిబి అజు ధౌలత్‍ వాళొ జక్కయ్య కరి ఏక్‍ జణో, ");
INSERT INTO vgr_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","యేసు కోన్‍కీ దేక్‍నూ కరి దేఖిన్‍ కోషీస్‍ కర్యో పణ్కీ, యో గ్హణు కుళ్ళో ఇనాటేకె జనం ఖారు ఆష్పిస్‍ భరైరవ్హమా ఇనా దేఖాన కోహూయుని. ");
INSERT INTO vgr_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","తేదె యేసు క్హయ్యు మార్గే ఆవ్‍స్యేకీ యో మాలంకర్లీన్‍, ఇనా ఆగఢీస్‍ జైన్‍ ఏక్‍ అంజుర్‍ను జాఢు ఛఢీన్‍ బేటోథో. ");
INSERT INTO vgr_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","యేసు యోస్‍ వాట్‍ఫర్‍ కరి జాఢకనా ఆవదీన్‍ ఢోళొపాఢీన్‍ దేఖిన్‍, జక్కయ్య! హేట్‍ వుత్రిన్‍ ఆవ్‍ ఆజ్‍ మే తార ఘర్‍ కనా రవ్హనూకరీ ఇనేతి బోలామా. ");
INSERT INTO vgr_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","యో యగ్గిస్‍ ఖూషీతి హేట్‍ వుత్రిన్‍ ఆయిన్‍, ఇనా చేర్చాయిలిదో. ");
INSERT INTO vgr_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","ఏజ్గానూ హాఃరు దేఖిన్‍ “ఆ అద్మి పాపేలు అద్మీనూ ఘర్‍ కనా ఖావనా గయో” కరి ఘణు గోణగనూ సూరు కర్యు. ");
INSERT INTO vgr_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","జక్కయ్య భీరిన్‍ హాధేక్‍ ప్రభు మారి ఆస్తీమా ఆధు బాగ్‍ గరీబేనా దీనాక్‍ దేంగ్రుస్‍; మే కీనా కన్‍తూబి అన్యాయ్‍తి లీరాక్యోతేబి ష్యాత్‍బి యూవ్నా చార్‍అంతల్‍ మళైన్‍ పాఛు పరీన్‍ దీనాకీస్‍ కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","ఇనటేకె యేసుఇనేతి బోల్యొ ఆ భి అబ్రాహామ్‍నో ఛీయ్యోస్‍; ష్యానకతో ఆజ్‍ ఆ ఘర్‍ కనా రక్చణ ఆయిరుస్‍ కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","నసింఛుకరతే అద్మీయేనా ధుండిన్‍ భచవనా టేకె అద్మీనో ఛీయ్యో ఆయో కరి ఇనేతి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","యూవ్నే ఆవాతేఖంజుకరతో, యెరూషలేమ్‍నా సేడె ర్హవమా, ఇనటేకె దేవ్‍నూ రాజ్యం ఖాందే ఆవ్‍స్యే కరి యూవ్నే సోచు కరాస్‍ కరి బోలిన్‍, ఏక్‍ ఉపమాన్‍ బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","ష్యాత్‍ కతో ఏక్‍ రాజోనో ఛీయ్యో రాజ్యంనా కమైలిన్‍ బుజు పాచు ఆవ్‍నూ కరి దూర్‍ ఛాతే దేహ్‍ఃఫర్‍తీ బైల్‍దేర్యో. ");
INSERT INTO vgr_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","ఇనా దాసుల్‍మా ధహ్‍ః జణనా బులైన్‍ జాన్న ధహ్‍ః గ్హేనాను దేనరాల్‍ ఏక్‍ ఏక్ దీన్‍, మే ఆవాతోఢీ ధంధో కర్లేవో కరి యూవ్నేతి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","పన్కీ ఇను క్హాయార్‍ను అద్మి ఇనాదూషించిన్‍, ఆ హామ్నా ఏలానూ హామ్నా ఇష్టం కోయిని కరి ఇనా ఫీటే ఖభార్‍వాలన బోలిమొక్‍ల్యా. ");
INSERT INTO vgr_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","యో రాజ్యం ఖారు కమైన్‍ పాచు పరీన్‍ ఆయో తేదె, హరేక్‍ జణు దంధో కరీన్‍ సష్యాత్‍ కమాయాకీ మాలంకర్నూ కరి యో రఫ్యా దిదోతే యూవ్నా బులామాంగవో కరి ఆజ్ఞాదిదో. ");
INSERT INTO vgr_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","తేదె అగాడీవాలు ఆయిన్‍, ప్రభూ తూ దిధోతే దేనార్మతి దంధో కరీన్‍, ఏక్‍నా ధహ్‍ః గ్హేనాను దేనారల్‍ కర్యో కరి బోలమా, ");
INSERT INTO vgr_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","తేదె యో, తూ గ్హణో అషల్ దాస్‍ అషల్ కామ్‍ కర్యో! ఆ ధర్రాష్యూమా నమ్మకంతీ ర్హయ్యో ఇనటేకె తూ ధహ్‍ః హాఃయార‍నా ఉప్పర్‍ అధికారింతరా ర్హాకరి ఇనేతి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","భేమ్మనో అద్మి ఆయిన్‍, ప్రభు మనా దిధోతే గ్హేనాను దేనారంన మే ఫాచ్‍ గ్హేనాను దేనారం కమాయో కరి బోలమా. ");
INSERT INTO vgr_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","ప్రభూ ఇనేతి బోల్యొ, తూనాబి ఫాచ్‍ హాఃయర్‍నా ఉఫర్‍ అధికారింతర ర్హా కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","తెదె బుజేక్‍జణో ఆయిన్‍, ప్రభు అల్లా తూ దిధోతే గ్హేనాను దేనారంన; మే అనా టువాల్‍మా లఫ్‍టీన్‍ ర్హాకో ");
INSERT INTO vgr_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","తూ ఘట్‍ జాన్‍నో ఇనటేకె తూన ఘను ఢరీన్‍ బోల్యో. ");
INSERT INTO vgr_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","ఇనటేకె యో, తూ గ్హణొ ఖ్హారాబ్‍ దాస్‍, తూ బోల్యోతే వాత్‍నూ బట్టీస్‍ తూన తిర్పు దీస్‍; సానకతో మే మ్హేంధాకోయిన్తే ఇనా ఫాడవాళో, నాక్యోకోయిన్తేస్‍ ఇనా వాఢవళో కరి మాలం హూస్యేతో, ");
INSERT INTO vgr_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","తూ మార రఫ్యానా వడ్డీవళానా ష్యాన కోదిధోని? ఇమ్‍ కర్యూహోత్‍తోబి మార రఫ్యా వడ్డీతీ యూవ్నాకన్‍తూ లిల్దోహోత్‍ని. ");
INSERT INTO vgr_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","తెదె ఎజ్గ ఛాతె అద్మితి ఆనకనా ఛాతే యో గ్హేనాను దేరారంనా లీన్‍ ధహ్‍ః గ్హేనాను దేరారంవలాన దినాక్‍ కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","తేదె యూవ్నే ప్రభూ! ఇనకనా ధహ్‍ః గ్హేనాను దేరారం ఛాని కరి బోల్యు. ");
INSERT INTO vgr_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","ఇనటేకె యో, ఛాతే ఇవ్నా అజు దేవావ్‍స్యే, కాయి కోయిన్తే ఇవ్నాకంతూ ఛాతేబి లేవాయ్‍జాస్యే కరి తూమారేతి బోలుకరూస్‍. ");
INSERT INTO vgr_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","మే తూమ్‍నా ఏలానా ఇష్టం కోయిన్తే సాత్రువు అజ్గ బులలాయిన్‍, మార ఖామే మర్రాక్‍దేవో కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","యేసు ఆ ఉపామనం ఖారు బోలీన్‍, ఇనాపాసల్తీ యెరూషలేమ్‍నా జానూ కరి అగాఢి నిక్ల్యొ, ");
INSERT INTO vgr_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","యూవ్నే ఓలివలనూ ఫాహాఢ్‍నూ ష్యేడే ఛాతే బేత్పగే, బేతనియ కరి బోలాతే గామ్‍నా ష్యేడె జావదీన్‍, ఇన షిష్యుల్‍మతూ బేజణనా బులైన్‍ ");
INSERT INTO vgr_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","తుమే ఖామే ఛాతే గామ్‍మా జవో, ఏజ్గాతూమ్‍నా భందైర్యూతే ఏక్‍ గధేఢానూ ఛేల్‍కు దేక్వాస్యే. ఇనఫర్‍ అజూన్‍బి కోణాస్‍ ఛడీ బేస్యుకోయిని, ఇనఛోళ్ళీన్‍ హకళ్యావ్‍ కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","కోన్‍బి తూమ్‍నా ష్యాన ఛొడుకరస్‍ కరి బోల్యుతో, ఆ ప్రభునా హోణుకస్‍ కరి బోలో బోలీన్‍ యూవ్నా బోలిమోకల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","బోలిమొక్‍లాయగయాతే యూవ్నే ఇమ్మస్‍ జైన్‍, యో బోల్యోతిమ్మస్‍ మాలంకరీన్‍, ");
INSERT INTO vgr_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","ఇనా ఛోడుకరతో ఇనూ మాలిక్‍ యో చేల్కానా ష్యాన ఛోడుకరస్‍ కరి పుఛాయూ. ");
INSERT INTO vgr_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","ఆ ప్రభునా హూణుకరీ యూవ్నే బోల్యు. ");
INSERT INTO vgr_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","తేదె ఇనా ఛోళ్ళీన్‍ ఆయిన్‍, యో గధేఢానూ ఛల్కానాఫర్‍ లుంగఢా భిఛాయిన్‍, యేసునా బేఖాడ్యా. ");
INSERT INTO vgr_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","యో గధేఢాఫర్‍ బేసీన్‍ చాలుకరతో అద్మీయే యూవ్నా లుంగఢానా వాట్‍ఫర్‍ బీఛావ్‍తాగయా. ");
INSERT INTO vgr_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","ఓలీవల ఫాహాఢ్‍పర్‍తూ ఉత్రానూ జోగో ఆయుతేదె యేసు కర్యోతే ఖారు అధ్బుతాల్‍నా టేకె షిష్యుల్‍నూ గల్లో ఖారు భరైన్‍ ఖూషీ హోతూహుయిన్‍, ");
INSERT INTO vgr_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","ప్రభునూ నామ్తీ ఆవ్‍స్యేతే రాజో ఘాణు స్తుతింపబణ్నూ! స్వరగ్‍మా షాంతి, సర్వోన్నత జోగోమా దేవ్నా మహిమబి ర్హఃణు కరి బోలీన్‍, మోటా ఆవాజ్‍తి దేవ్నా స్తుతించనిక్ల్యా. ");
INSERT INTO vgr_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","యో అద్మీయేమతూ థోడు పరిసయ్యుల్‍ ఉట్టీన్‍ ప్రభు తార షిష్యుల్‍నా గుర్‍కావ్‍ కరి బోలమా, ");
INSERT INTO vgr_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","యేసు యూవ్నామణీ దేఖీన్‍ బోల్యొ, ఆవ్‍ణే గఛ్చుప్‍ రైతో ఫత్రా ఛీక్రాణ్ ‍బేందిన్‍సే కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","అజు యేసు యెరూషలేమ్‍ జాతోహూయిన్‍, యో ఖాయార్నా దేఖీన్‍ దుఃఖ పడీన్‍, ");
INSERT INTO vgr_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","తూ ఆ ధన్‍మాతోబి సమాదానంనూ సంగతినా మాలంకర్లీదోహోత్‍తో తూనా కేత్రెకీ అసేల్‍; పణికి హాంకే తూనా యో లఫిర్యూస్‍. ");
INSERT INTO vgr_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","ప్రభు తునా దర్సంచేతే ధన్‍ తూ మాలంకర్యొకొయిని. ఇనటేకె తార వైరీయే ఆయిన్‍ ఆష్‍పిస్‍ భీత్‍ బాందీన్‍, కోండీన్‍ ఛార్హే బాజుతు తూనా అరికట్టిన్‍, ");
INSERT INTO vgr_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","తారమా ఛాతే తారు లఢ్‍కావ్‍నా కేడె తూనాబి మాటిమా మళైనాక్‍సే, తారమా భండనా ఉఫర్‍ భండనా భీరదేసేకోయిని కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","యో ఆలయంమా దంధొ కరుకరతే యువ్నా దేఖీన్‍ యూవ్నేతి. ");
INSERT INTO vgr_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","మారు ఆలయం ప్రార్దన కరనూ ఆలయం కరి లేక్హానల్‍మా లీఖైర్యూస్‍, కాని తూమే ఇనా ఛోర్‍నూ గ్హవీంతర కర్‍దిదా కరి బోలీన్‍, యూవ్నా ఏజ్గాతూ రగధానిక్యో. ");
INSERT INTO vgr_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","బుజు యో హర్‍ ధన్‍ యో ఆలయంమా దేవ్‍నూ వాతే బోలానిక్‍ల్యో, ప్రధాన్‍ యాజకుల్‍, షాస్త్రుల్‍బి, అద్మియేమా మోటా ప్రధానుల్‍బి, ఇనా కీమ్‍బి మర్రాక్నుకరీ దేక్తార్హయ్యా. ");
INSERT INTO vgr_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","పన్కి జనం ఖారు యేసునా ఆష్‍పిస్‍ భరైన్ ఇని వాతే ఖంజుతూహూయిన్‍ రవ్హమా, ఇవ్నా ష్యాత్‍ కర్నుకీ సోచాయు కోయుని. ");
INSERT INTO vgr_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","ఏక్‍ ధన్మా ఆలయంమా యేసు అద్మీయే ఖారవ్నా దేవ్‍ని వాతే బోల్తోహుయిన్‍, కరతో, ప్రధాన యాజకుల్‍బి, షాస్త్రుల్‍, అజు షాణావ్‍తి మలీన్‍ వ్యతేరెకంతీ ఆయు. ");
INSERT INTO vgr_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","తూ ఖయ్యూ అధికారంతి తూ ఆ కామ్‍ కరూకరస్‍కీ, ఆ అధికార్‍ తూనా కోన్‍ దిధూకీ, హమారేతి బోల్‍ కరి ఇన పుఛ్చాయు. ");
INSERT INTO vgr_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","ఇనటేకె, మేబి తూమ్‍నా ఏక్‍ వాత్‍ పుఛ్చావుస్‍, యో మారేతి బోలో. ");
INSERT INTO vgr_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","యోహాన్ దిదోతె బాప్తిస్మమ్‍ ఆయుకీ, అద్మియేతి ఆయుకీ? కరి యూవ్నా పూఛావమా. ");
INSERT INTO vgr_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","తేదె యూవ్నే ఆ స్వర్గంతూస్‍ హుయుకరి బోల్యాతో, ఇమ్‍ హూస్యేతో తూమే ష్యే కోనమ్ముకరని కరి అప్నా పుఛావ్‍సే. ఏక్ను యేక్‍ బోలిదు. ");
INSERT INTO vgr_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","అద్మీయేతీస్‍ హూయూ కరి బులాయోతే అద్మీయే ఖారు అప్నా భండవ్‍తీ మార్‍రక్‍స్యే, ష్యాన కతో యోహాన్‍ ఏక్‍ ప్రవక్త కరి ఘట్‍ నమ్ముకరస్‍ కరి ఇవ్నే సోచిలీన్‍, ");
INSERT INTO vgr_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","తేదె యూవ్నే హామ్నా మాలంకోయిని కరి బోల్యు. ");
INSERT INTO vgr_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","తేదె యేసుబి యో అధికారం కెజ్జాతూ ఆయూతే మేబీ బోలిస్‍ కోయిని కరి ఇవ్నేతీ బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","ఇనబాద్మా యేసు జనం హాఃరవ్తీ ఏక్‍ ఉపమానం బోలానిక్‍ల్యొ, ఏక్‍ అద్మి అంగూర్ను బాగ్‍ నాఖిన్‍, ధూనియానా పాల్‍నా ధిన్‍, దేహ్ఃఫర్ ఛల్‍జాస్‍. ");
INSERT INTO vgr_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","బాగ్‍ ఫీకాదీన్‍ ఇనూ పాల్‍నూ భాగ్‍ లేవనా టేకె ఏక్‍ దాసుడ్‍నా బోలీమోక్లాస్‍. యో పాల్‍నా లీరాక్యూతే యూవ్నే ఇనా మారీన్‍ ఖాళి హాతే బోలీమోక్‍ల్యు. ");
INSERT INTO vgr_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","తేదె అజేక్‍ దాస్‍నా బోలీమోకలామా, ఇనాబి ఇమ్మస్ మారీన్‍ ఇజ్జాత్‍ కాఢీన్‍ ఖాళి హాతే బోలిమోకలస్‍. ");
INSERT INTO vgr_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","బుజుబి యో తీన్‍మనూ అద్మినా బోలీమోకలామా, ఇనాబి ఇమ్మస్ లోహి నీఖా ఖార్కు గాయల్‍ కరీన్‍ బార్‍ ధకల్‍నాక్యూ. ");
INSERT INTO vgr_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","తేదె యో యాజమాని కీమ్‍కరూలా కరి బోలీన్‍, మారో లాఢ్‍నో ఛీయ్యోనా బోలిమోక్ల్యూతో ఇనాతోబి గౌరవించేసీకి కరి సోచ్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","కాని యూవ్నే యో యాజమానినో ఛియ్యానా దేఖీన్‍, ఆ టోట్‍ నో వారసుడ్‍ ఆనా మర్రాక్యుతో బైస్‍, ఆ టోట్‍ అప్నాస్‍ స్వంతం హూయిజాస్యే కరి ఇవ్నే బోల్లీదు. ");
INSERT INTO vgr_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","తేదె ఇనాబి టోట్‍నా బాధర్‍ మర్రాకీన్‍ నాకీదిధూ. ఇనటేకె యో యాజమాని యూవ్నా ష్యాత్‍ కర్షే? యేసు ఇవ్నా పుఛ్చాయో, ");
INSERT INTO vgr_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","యో ఆయిన్‍ యూవ్నా మర్రాకీన్‍ యో టోట్‍నా అలదాన దీస్యే కరి బోల్యొ. అద్మీయే ఖంజీన్‍ ఇమ్‍ నా హోణుకరి బోల్యు. ");
INSERT INTO vgr_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","యో యూవ్నా మ్హణి దేఖిన్‍, ఇమ్‍ హుస్యెతో “ఘర్‍ బాంధవాళు కామె ఆవకోయినికరి ఫేకి దిధూతె ఫత్రోస్ ‍ కోణనా ముఢ్క్యు హుయు” కరి లిఖైర్యూతె వాత్‍ ష్యాత్‍? ");
INSERT INTO vgr_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","“యో ఫత్రోఫర్‍ పఢతే హరేక్‍ టుక్డా హుయిజాస్యే, ఫత్రో కీనాఫర్‍ పడ్చెకి యువ్నె జగ్‍ధైజాస్యే” కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","ప్రధాన యాజకుల్‍బి, షాస్త్రుల్‍ యో ఉపమాన్‍ బోల్యుతే అప్నాటేకెస్‍ కరి మాలంకర్లీన్‍, తేదెస్ ఇనా ధర్లేనూ కరి దేక్యూ పణికీ యూవ్నే జనాల్‍నా దేఖిన్‍ ఢరీగయూ. ");
INSERT INTO vgr_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","యూవ్నే ఇన కెహు కెహూ వాతెమా ధర్లేనుకరీ ఇనా ఏన్‍ కర్‍తూహూయిన్‍, అధిపతుల్‍నా, అధికారంనా ధరైనాగ్దేనుకరి, నీతినూ అద్మియేకరి బోలైలేతె థోడు జణనా ఇనకనా బోలిమోక్‍ల్యా. ");
INSERT INTO vgr_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","యూవ్నే ఆయిన్‍ బోధకుడ్ తూ న్యాయంతి వాతే బోల్తోహుయిన్‍ బొదించుకరస్‍, కోన్‍ ష్యాత్‍ బోల్లీదుతోబి ఢరకోయినితిమ్‍ తూ ఖాచ్ఛీతీస్‍ దేవ్‍ని వాట్‍నా బోలుకరాస్‍ కరి హమ్నా మాలంహూంగ్రస్‍. ");
INSERT INTO vgr_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","ధర్మషాస్ర్తం ప్రకారంతి హమే రోమా మహారాజ్నా పన్ను బాంధనూ న్యాయంమస్‍నా? కరి ఇనా పుఛ్చాయా. ");
INSERT INTO vgr_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","యో యూవ్నూ సొఛ్‍నా మాలంకర్లీన్‍, ఏక్‍ దేనారంనా మన దెఖ్కాడొకరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","ఇనాఫర్‍ కీనూ రూపం ఛాకరీ బోలామా యూవ్నే మాహరాజ్ను కరి బోల్యా. ");
INSERT INTO vgr_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","ఇమ్‍ హూసేతో “మహారాజొను మహారాజ్నా దెవొ, దేవ్నా దేవ్నాస్‍ దెవొ” కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","ఇవ్నే జనం నా హాఃమె బోల్యొతె వాతేనా యువ్నే గలత్‍ ధరనా కోహూయిని, పన్కి ఇని వాతేనా హాష్యంహుయీన్‍ షొపొహుయిగా. ");
INSERT INTO vgr_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","మరీగయుతె అద్మీయే అజు జీవిన్‍ ఉట్‍స్యే కోయిని కరి బోలావళు థోఢు సద్దుకయ్యుల్‍ యేసుకన ఆయిన్ ఆమ్‍ పుఛ్చాయు. ");
INSERT INTO vgr_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","బోధాకుడ్‍! భావణ్‍ జీవిరవానూ వోఖాత్‍స్‍ ఏక్‍నో భై లఢ్‍కా కొయిన్తే మరీగయుతో, ఇనో భైని బావణ్‍నా య్హా కర్లీన్‍, ఇనా భైనా లఢ్‍కా దేనూ కరి మోషేను ధర్మాసాస్త్రమా లిఖ్కిరాక్యొస్‍. ");
INSERT INTO vgr_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","ఖాత్‍ భైయ్యే థూ, యూవ్నామా మోటో భై య్హా కర్లీన్, పణికీ యో లఢ్‍కా కోయిని తీమ్‍ మరీజాస్‍. ");
INSERT INTO vgr_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","తేదె ఇనో భై ఇని భావణ్‍నా రాఖీలేస్‍, యో బి లడ్కా కొయినితిమ్‍ మరిగయో, ");
INSERT INTO vgr_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","ఇమ్మస్‍ తీన్‍మనోబి భైని బావణ్‍నా రాఖిలీన్‍ యోబి మరిజాస్‍ ఇమ్మస్‍ హాఃతేజణాబి ఇనా రాఖిలీన్‍ లడ్కాకొయిని తిమ్మస్‍ మరిగయు, ");
INSERT INTO vgr_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","తేదె యో బాయికోబి మరిజాస్‍. తేదె మరీగయుతే హాఃరు జీవిన్‍ ఉట్‍స్యేతో? ");
INSERT INTO vgr_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","యో బాయికో యో ఖాతే జణామ కీనా బావణ్‍నితర ర్హాస్యే యో ఖాతే జణానబి బావణ్‍నితర రై కాహేనా? ");
INSERT INTO vgr_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","ఇనటేకె యేసు ఆ ములక్‍ను అద్మీయే య్హా కర్లేతూ హుయిన్‍ కర్తూరస్‍. ");
INSERT INTO vgr_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","“పన్కీ మర్యుతే అద్మి జీవీవూటీన్‍ స్వర్గంమా జానుకరీ బోలావలు య్హా కర్షెకొయిని కార్లేకోయినీ.” ");
INSERT INTO vgr_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","“ఇవ్నే పునరుథ్‍మా భాగ్‍ హుయిన్‍, దేవదూతల్తీ భరొబార్ హుయిరసే, దేవ్ను లడ్కా. ఇనటేకె యూవ్నే కెదేబి మర్‍సే కోయిని.” ");
INSERT INTO vgr_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","భళుకరతే ఢాగ్నా గూర్చీ లిఖ్యూతే ఇనమా ప్రభు అబ్రాహామ్‍నో, ఇస్సాక్‍నో, యాకోబ్‍నో దేవ్‍ కరి బోల్తోహుయిన్‍, మరీహుయు ఊట్‍సే కరి మోషే బోల్యోతో, ");
INSERT INTO vgr_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","యో జీవ్తానస్‍ దేవ్‍ పన్కీ మర్యాహుయనా దేవ్‍ కాహే; దేవ్ను ఢోళమ హాఃరుబీ జీవ్తూ ఛాకరీ బోల్యో. ");
INSERT INTO vgr_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","ఇనటేకె షాస్త్రుల్‍ బోధకుడ్‍, తూ ఘను అష్యల్‍ బోల్యొకరి బోల్యా. ");
INSERT INTO vgr_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","బాద్మా ఇవ్నే ఇన అజు సాత్బి పుఛ్చావన కోహుయూని. ");
INSERT INTO vgr_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","యేసు ఇవ్నేతీ, “క్రీస్తు దావీద్‍నో ఛీయ్యో కరి జనాల్‍ కీమ్‍ బోలుక్రస్‍” కరి పుఛ్చాయో. ");
INSERT INTO vgr_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","43","మే తార వైరియేనా తార గోడనా హేట్‍ పాదపీట్‍నితర ల్యావతోడీ, తూ మర ఖావ్వాత్‍ను భాజు బేహ్ఃకరి బోలిన్‍, దేవ్‍ మారో దేవ్‍తీ బోల్యొకరి కీర్తననూ పుస్తకంమా దావీద్‍ బోలిరాక్యోస్‍. ");
INSERT INTO vgr_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","దావీద్‍ ఇనా ప్రభుకరి బోల్యొతొ, యోకిమ్ ఇనా ఛియ్యో హుస్యేకరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","జనాభో హాఃరు హఃమస్తూ ర్హావమా, తేదె యేసు సీష్యుల్‍ ఆమ్‍ బోల్యొ, ");
INSERT INTO vgr_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","షాస్ర్తుల్‍తీ జత్తన్‍ ర్హవో, ఇవ్నే లంభ లుంగఢా పేర్లీన్‍ బజార్ని గల్లీయేమా ఫర్నూహుయిన్‍ వందనాల్‍నా కరిన్‍, విందుల్‍మా అగ్రస్థాన్‍, ప్రార్థనాను జోగోమా అగ్రపీట్‍ హోణు కరి కోషిష్‍ కర్తు ర్హాస్‍. ");
INSERT INTO vgr_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","యూవ్నే విధవరాల్‍నూ ఆస్తీనా లాపడ్‍లేతు హుయిన్‍, ఉఫర్‍ మాయ వేషంనూ ఘణు మోటు ప్రార్దన కర్తు ర్హాస్‍. యూవ్నే బుజు ఘణు సిక్చమల్సే. ");
INSERT INTO vgr_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","కాణీకి నాఖనూ పెట్టిమా దౌవ్లత్‍వాళు కాణుకల్‍ నాఖూకరతే యూవ్నా యేసు ఏన్‍ కరీన్‍ దేక్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","ఏక్‍ గరీబ్‍ విధవరాల్‍ బే న్హాను ఫైసాను ఇనమా నాఖానూ ధేఖిన్‍, ");
INSERT INTO vgr_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","ఆ గరీబ్‍ విధవరాల్‍ ఖారవ్తీబి ఘణు నాఖికరి తుమారేతి హాఃఛి బోలుకరూస్‍. ");
INSERT INTO vgr_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","ఇవ్నే హాఃరు ఇవ్నకనా ఛాతే కేత్రుకీ ధౌలత్‍మా థోడు నాక్యు పన్కి, ఆ విధవరాల్‍ ఇనూ గరీబ్‍మాబి ఇనకనా ఛాతే ఇనూ జీవ్నూ ఖారుస్‍ నాకీ దిదీ కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","థోడుజణు కేత్రుకి సుందర్ను ఫత్రావ్‍హూః, బుజు ఇవ్నే దిదుతే కానుకల్‍తీ బంధాయ్‍రూతే ఆలయంనా దేఖిన్‍ వాతే బోలుకరమా, ");
INSERT INTO vgr_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","యేసు యువ్నేతి, ఆ ఫత్రాతీ బంధాయ్‍రూతే ఇనా తూమే దేఖుకరస్‍నీ, ఇనమా ఫత్రాఫర్‍ ఫత్రా వుభర్సేకోయిని తీమ్‍ పడిజాస్యేతే ధన్‍ ఆంక్రస్‍ కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","తేదె యూవ్నే హాఃరు బోధకుడ్‍ ఆ హాఃరు కెదే హూస్యే హాఃరు హువానటెకే కేహూ సుచాన వాతలిస్‍, కరి పుఛ్చావమా. ");
INSERT INTO vgr_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","తూమే మోసం నా హూణుతీమ్‍ దేఖీలేవో! కెత్రూకి జణు ఆయిన్‍ యో క్రీస్తు మేస్‍ కరి, ధన్‍ కందే ఆయిత్రు కరి బోల్‍స్యే, యూవ్నాకేడె నోకోజాస్యు. ");
INSERT INTO vgr_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","తూమే యుధ్దాల్‍ని వాతే, కలహాల్ని వాతే ఖంజ్యా తేదె తూమే ఢరోనకో; ఆ అగడీ జరగ్‍నూస్‍, కాని అంతం యగ్గీస్‍ ఆవ్‍స్యే కోయిని కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","బుజు దేఖ్‍ ఫర్‍ దేఖ్, రాజ్యం ఫర్‍ రాజ్యం వుట్‍స్యే కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","ఎజ్గ ఎజ్గా మోటు భుకంపాల్‍ హూస్యే, తెగుల్‍, ఖాళ్‍ దూకళ్‍ ఆవ్‍స్యే, కేత్రేకీ ఘాణు ఢరవనూ సూచనల్‍ వాజ్లామతూ ఫైదాహూసే. ");
INSERT INTO vgr_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","ఆ ఖారు హూవనా ఆగఢీ, తూమ్నా ఇవ్నే జబర్‍ జస్తీతీ ధరీన్‍హీంసింసే, మార నామ్తీ రాజవ్‍నూ ఖామే, అధిపతుల్‍నూ ఖామే లీన్‍ జైన్‍ సమాజ మందిరంమా ఠాణవ్‍మ ధరైన్‍ తూమ్నా ఖాతవ్‍స్యే. ");
INSERT INTO vgr_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","ఆ ఖారు సాబుత్‍నితర తూమ్నా దేఖౌస్యే. ");
INSERT INTO vgr_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","ఇనటేకె తూమే ష్యాత్‍ బోల్‍నూ కరి ఆగఢీస్‍ సోఛీలేవో నకో కరి దీల్‍మా రైజవో. ");
INSERT INTO vgr_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","తూమారు వైరేవ్‍ ఖార పాఛుఫారాయిన్ వాతే పేఢానటేకె, తూమారు వాతేనా కాహే కరి బోలానాబీ యూవ్నా కోహూస్యేని. ఇమ్ను వాతేనూ ఆఖ్కాల్‍ తూమ్నా దీష్‍ కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","ఆయా భా న హతేఖు, భైయ్యే భందుల్‍హాతే దోస్తుల్‍నా హతేఖు, తూమే సాత్రువునా ధరౌస్యే; తూమరమా థోఢ అద్మీయే మరైనాక్‍స్యే. ");
INSERT INTO vgr_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","మారు నామ్‍మాతి అద్మీయే తూమ్నా ద్వేషింసే. ");
INSERT INTO vgr_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","పన్కితూమార ముఢ్‍క్యామనూ ఏక్‍ కేఖ్‍ఃబి హల్‍స్యే కోయిని కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","తూమారు ఓర్పుతీస్‍ తుమారు జాన్నా భచయ్‍లీలేవో. ");
INSERT INTO vgr_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","యెరూషలేమ్‍నూ ఆష్పీస్‍ సైనికుల్‍ కోంఢ్లేవనూ దేఖ్యతో తేదె ఇనూ నాషనం హూవనూ కందే ఆయిరూస్‍ కరి మాలంకర్‍లేవో. ");
INSERT INTO vgr_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","తేదె యూదయమా రవ్హాళు ప్హాహఢేవ్‍మా మీలైలెనూ; ఇనా ఇఛ్మా రవ్హాళు భాధర్‍ మీలైలేనూ; గామేవ్‍మా రవ్హాళు యెరూషలేమ్‍మా నా ఆవ్‍నూ. ");
INSERT INTO vgr_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","వాక్యంమా లిఖైర్యూతే ఖారు ఖాచ్ఛీ హూస్యేతే షిక్చనూ ధన్‍. ");
INSERT INTO vgr_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","యో ధనూవ్‍మా భేజీనీ బాయిక్వానాబి ఛేరవళి బాయిక్వాన కేత్రేకీ ష్రమ, బుజు జమీన్‍ ఫర్‍ ఘణు ముసిభత్‍బి, ఆ అద్మీయేఫర్‍ ఇనుఛంఢాల్‍ ఆవ్‍స్యే. ");
INSERT INTO vgr_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","యూవ్నే తల్‍వార్‍తిస్‍ పడీజాస్యే. ఠాణవ్‍మా ధరైన్‍ అన్యుల్‍నా ఖామే జాస్యు; అన్యుల్‍నూ ధన్‍ ఖాతంహూవతోఢీ యెరూషలేమ్‍ అన్యుల్‍ నా హాతే ఖూంధలావ్‍స్యే. ");
INSERT INTO vgr_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","బుజు సూర్య ఛంధర్‍మా, షుక్కర్‍మా సూచనల్‍ దేఖౌస్యే, ధర్యావ్‍ను జూఖాళోను ఆవాజ్‍తి ధర్తీక్హారు ఢరవాళనా ష్రమ అవ్‍స్యే. ");
INSERT INTO vgr_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","ఆకాష్‍మాను షక్తిహాఃరూ హల్జాసె, ఇనటేకె ములక్‍ ఫర్‍ ఆవ్సెతే లఫట్‍నా దేఖీన్‍ ఢరిజేన్‍ అద్మీయే హాఃరు గభ్రాయిజైన్‍ పఢీజాస్యే. ");
INSERT INTO vgr_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","తెదె అద్మినొ ఛియ్యో ప్రభావంతీ కేత్రేకీ తేజాస్సుతీ మబ్బుమతు ఆవ్‍స్యేతే తుమే దేఖ్సూ. ");
INSERT INTO vgr_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","ఆ ఖారు జరగనూ సురుహూయు తేదె తూమే ధైర్యం లాయిలీన్‍వు బ్హీర్హాయిన్‍ తూమారు ముఢ్‍క్వా ఉఫర్‍ పళ్ళేవో. తూమారు రక్చణ కందే ఆయిరూస్‍ కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","బుజు యో యూవ్నేతి ఆ ఉపమానంనా బోల్యొ. అంజురంనూ జాఢూబి, అజు ఖార జాఢనబి దేఖ్యో. ");
INSERT INTO vgr_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","యో జాఢవ్‍నూ ఇగ్గూర్‍ పుటీర్యూతో తడ్కను ధన్ ఆయు కరి తూమే మాలంకర్లేస్‍ కాహేనా. ");
INSERT INTO vgr_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","ఇమ్మస్‍ తూమే ఆ ఖారు జర్యుగు తేదె దేవ్‍నూ రాజ్యంబి కందే ఆయిరూస్‍ కరి మాలంకర్‍లేవొ. ");
INSERT INTO vgr_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","యో హాఃరు హువతోడి ఆ ఫిడి అద్మీయే మట్‍స్యే కోయిని కరి ఖఛ్చితంగా బోలుకరుస్‍. ");
INSERT INTO vgr_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","ఆకాషబీ జమీన్‍ మటీజాస్యే పణికీ మారీ వాతే కేదేబి మట్‍స్యేకోయిని కరి బోల్యో. ");
INSERT INTO vgr_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","తూమారు దిల్‍ ఏక్‍ వోఖాత్‍ ఖావన్‍ ఫీవన్‍నూ మత్తుతీ, ఆములక్‍నూ టేకే పస్తావ్‍తా ర్హయ్యాతో, యో ధన్‍ క్హాఢల్‍ కరి తూమార ఉఫర్‍ నా ఆవ్‍నూతీమ్‍ తూమే జత్తన్‍ హూయిజవొ. ");
INSERT INTO vgr_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","యో ధన్‍ జమీన్‍ ఫర్‍ రవ్హళ ఖారవ్నాఫర్‍ ఖాఢల్‍ కరి ఆవ్‍స్యే. ");
INSERT INTO vgr_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","ఇనటేకె తూమే జరగజస్యేతే ఆ ఖారవ్‍మతూ ఛుకైలీన్‍, అద్మీనొ ఛియ్యోనా హాఃమె ఉభ్రనా థాకత్‍వాళా హూవనటేకె కెధేబి ప్రార్ధన కర్తహూయిన్‍ హోషార్‍తీ ర్హవో. ");
INSERT INTO vgr_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","యో హర్‍ ధన్‍ ధన్నూ ఆలయంమా వాతే బోల్తొహూయిన్‍, రాత్‍నూ ఓలివనూ ఫాహాఢ్‍నా కనా జాతోర్హయ్యో. ");
INSERT INTO vgr_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","వ్హానే హఃత్రే అద్మీయే హాఃరు ఇనూ వాతే హఃమ్జనటేకె దేవాలయంమా ఇనకనా ఆవ్తా ర్హయ్యా. ");
INSERT INTO vgr_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","పస్కా కరి ఏక్‍ పోంగ్యుకోయిన్తే ఆటోను పండగ కందే ఆయు. ");
INSERT INTO vgr_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","ప్రాధనా యాజకుల్‍బి, షాస్త్రుల్‍ అద్మీయే దేఖిన్‍ ఢరీజైన్‍ యేసునా ధరనా కోహూయుని. కానీ యూవ్నే అజు కీమ్‍ మార్‍నూ కరి ఉపాయ్‍ ఢూండ్తార్హయా. ");
INSERT INTO vgr_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","యత్రామా భారజణ షిష్యుల్‍మా ఆయోతే ఇస్కరియోతు కరి బోలాతే యూదామా సైతాన్‍ పేసిగయూ. ");
INSERT INTO vgr_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","ఇనటేకె యో జైన్‍ యేసునా ఇవ్నాకనా కీమ్‍ ధరావ్‍నూకరీ వాతే బోలాన టేకె మందిర్ను అధిపతుల్‍ కనాబీ, షాస్త్రుల్‍ కనా గయో. ");
INSERT INTO vgr_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","ఇనటేకె యూవ్నే ఖూషీహూయిన్‍, ఇనా రఫ్యా దేవానా ఒప్పిలీదా. ");
INSERT INTO vgr_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","యుదా, యో వాత్‍నా ఒప్పిలిన్‍ యో ఇనకనా ఇనామాలం కోయిన్తే వఖాత్‍ యూవ్నా ధరవ్‍నూ కరి కావ్లీకాసిలిన్‍ జఫిరోతో. ");
INSERT INTO vgr_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","పస్కానూ బోక్డానా బలిదేవనూ పోంగ్యు కోయిన్తే రోటొను పండగ కరనూ ధన్‍ ఆయు. ");
INSERT INTO vgr_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","యేసు, పేతురు యేహాన్‍నా తూమే జైన్‍ అప్నా ఖావనాటేకె పస్కానా బణవో కరి బోలిమొక్‍ల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","యూవ్నే, హామే పస్కానా కేజ్జా కర్‍నూ కరి తూ సోచుకరస్‍ కరి పుఛవమా. ");
INSERT INTO vgr_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","తూమే ఖాయార్మా జావను వోఖాత్‍ పాణీనూ బింది పళ్ళిన్‍ జాస్యేతే ఏక్‍ జణో తూమ్నా దేఖౌస్యే, తూమ్నా ఆడే ఆవ్‍సే, యో జైతే ఘర్‍మా తూమేబి ఇనాకేడె జైన్‍, ");
INSERT INTO vgr_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","మే మార షిష్యుల్‍తి మళిన్‍ పస్కాను విందు ఖావన్‍ టేకె యో ఘర్‍నా మాలిక్‍తీ హామ్‍నా దేఖాఢ్‍ కరి బోలొ. ");
INSERT INTO vgr_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","యో తూమ్‍నా ఘర్‍నూ మోట్టుమిద్ది పర్‍ దేఖాఢ్‍స్యే, ఏజ్గా పస్కానా కరో కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","యూవ్నే జైన్‍ యో దేకిన్‍ మాలంకరీన్‍, యో బోల్యొ తిమ్మాస్‍ పస్కానా సీద్దం కర్య. ");
INSERT INTO vgr_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","పస్కానా ఖావనూ వోహోఃత్‍ ఆవమా యోబి ఇనా షిష్యుల్‍ ఖావనా టేకె గుండ్‍ బేఠా. ");
INSERT INTO vgr_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","తేదె మే ష్రమ పఢనా ఆగఢీ తూమారేతి ఆపస్కానా ఖాణు కరి ఆహ్‍ః కర్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","పస్కాను విషయంనా దేవ్‍నూ రాజ్యంమా హువాతోడీ అజు కేధేబి ఆ ఖాణునా ఖైస్‍కోయిని కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","యో గిన్నీనా పాఢీన్‍ దేవ్నా కృతజ్ఞాత కరీన్‍ తూమే ఆనా లీన్‍ పాంచీన్‍ ఖవో కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","హంకేతూ దేవ్‍నూ రాజ్యం ఆవతోడీ మే అజు కేదెబి ద్రాక్చనూ రహ్‍ పీష్‍కోయిని కరి తూమారేతి బోలుకరూస్‍ కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","ఇనబాద్‍మా ఏక్‍ రోటనా పాడీన్‍ దేవ్నా కృతజ్ఞత చెల్లించీన్‍, ఇనా తోఢీన్‍ యూవ్నా దీన్‍ తూమార టేకె దేవాంగ్రతే మారు ఆంగ్‍తన్‍ మన హఃయల్‍ కర్‍లేవనా టేకె ఆనా కరో కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","ఇమ్మస్‍ ఖాణు ఖావనూ హూయిజావదీన్‍, ఏక్‍ గిన్నినా పాడీన్‍, ఆ తూమార టేకె ఛువడ్యోతే మారూ ల్హొయితి సీద్దం కర్యోతే నవూ నిబంధన. ");
INSERT INTO vgr_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","హాదేక్‍ మన ధరౌస్యేతే అద్మి మారేతి ఖ్హాణు ఖావనా టేకె అజ్గ బేటోస్‍. ");
INSERT INTO vgr_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","దేవ్‍ ఎంచిరాక్యుతీమ్‍స్‍ అద్మీనో ఛీయ్యో మర్జావను ఛా! యో కెహూ అద్మీనూ హాత్‍తీ ధరౌస్యేకీ యో అద్మినా ఘాణు ష్రమ కరి బోల్యో. ");
INSERT INTO vgr_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","తేదె ఇవ్నే ఆ కామ్‍ కోన్‍కర్యు కరి ఏక్‍నా ఏక్‍ పుచైల్దు. ");
INSERT INTO vgr_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","ఇవ్నామా కోన్‍ మోటు బోలౌస్యే కరి వాదించీలిదు, ");
INSERT INTO vgr_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","యో యూవ్నేతి ఆమ్‍ బోల్యొ, అన్యుల్‍మా హూయితో రాజుల్‍ హీంసీచిన్‍ యూవ్నా యేల్యొ. పన్కీ యూవ్నఫర్‍ అధికారంతీ యూవ్నే ఖారావును కరి అద్మీయోమా దోస్తబోలానుకరి సోచ్ఛాస్‍. ");
INSERT INTO vgr_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","కానీ తూమే ఇమ్‍ నార్హాను, తుమారమా మోట నామ్‍ ఛాతె అద్మి ఖారావ్తి న్హానా అద్మీయేనితర ర్హనూ, యాజమాని దాసుణ్‍నితర ర్హనూ. ");
INSERT INTO vgr_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","కోన్‍ మోటు? ధాన్‍ ఖావనా బేటాతే యూవ్నేకీ నైతో ధాన్‍ నాఖాతే అద్మి? పన్కీ తుమారమ ధాన్‍ నాక్హా వాలుస్‍! కానీ మే తూమారకనా సేవ కరవాళోంతర ఛౌ. ");
INSERT INTO vgr_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","తూమేబీ మారు కష్టాల్ క్హారమా కేడేస్‍ ర్హాసు. ");
INSERT INTO vgr_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","ఇనటేకె మారో భా మన రాజ్యంనా దీదోతిమ్‍ మే బి తూమ్‍నా రాజ్యంనా దీస్‍. ");
INSERT INTO vgr_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","తేదె తూమేబి మారు రాజ్యంమా మారేతీ బేసీన్‍ ధాన్‍ ఖాష్యు. రాజవ్‍ని బేంఛీయేఫర్‍ బేసీన్‍ భార వాంసాంను అద్మీయేఫర్‍ తీర్పు బోల్‍ష్యు కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","సీమోన్‍, సీమోన్‍ హాఃజె సైతాన్‍ తూమ్‍నా ధరీన్‍ క్హేతార్‍ వాలో ఘౌనా ఛణ్కాతీమ్‍ ఛణక్‍నూ కరి తుమ్నా పరిక్చీంచును కరి దేవ్నా పుచ్చావాస్‍. ");
INSERT INTO vgr_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","సిమోన్‍ తారు విస్వాసంకమ్‍ నాహోణుకరీ మే ప్రార్దన కర్యొ. తారు విస్వాసం ఘట్‍ హూయుతీమ్‍ తార భైయ్యెను విష్వాసంమతు నాపడిజానుతిమ్‍ ప్రార్థన కారిన్‍ ఘట్‍ కర్‍ కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","తేదె సీమోన్‍ ప్రభు తారటేకె మే ఠాణామా ఆవ్‍కతోబి ఆయిస్‍, మర్‍కతోబి మరనాటేకెబి మేసిద్దం ఛౌకరీ బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","తేదె యేసు ఆమ్‍ బోల్యొ, ఆజ్నధన్నే పేతురూ తూ, మే మాలంకోయిని కరి తీన్‍ చోట్‍ బోలాతోడీ ముర్గు వాహ్‍ఃస్యే కరి తారేతి బొలుకరుస్‍. ");
INSERT INTO vgr_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","బుజు యేసు యూవ్నేతీ, రఫ్యాసంచీ, హాత్‍నూ సంచీ, ఛేప్లె కోయినితిమ్‍ తూమ్‍నా బోలిమోకల్యొ తేదె తూమారు అవసరాల్‍ కోతీర్యున్నా? కరి పుఛాయో. కాయిబి కామ్‍ కోహుయునీ కరి యూవ్నే బోల్యు. ");
INSERT INTO vgr_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","ఇనటేకె హంకే సంచీ ర్హవళు సంచీనా లీన్‍ జవో, ఛరీ కోయిన్తే అద్మీయే యూవ్నా లుంగ్ఢా ఏఛీన్‍ ఛరీ లేనూ; ");
INSERT INTO vgr_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","యో అక్రమ కరతే అద్మీయేమా ఏక్‍నితర దేఖాయో, కరి లేకానంమా లీఖైర్యూతే వాతె మరకనా జరగ్‍స్యేకరి క్హాచీతీ బొలుకరుస్‍, కీమ్‍ కతో మార టెకెనూ వాతే ఖాతంహూయిజాస్యే కరి మే తూమారేతీ బోలుకరుస్‍ కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","యూవ్నే “ప్రభు హమారకనా బే ఛరీ ఛాకరీ” బోలామా, “బైస్‍లా” కరి యో ఇవ్నేతీ బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","ఇనబాద్‍మా యూవ్నే ఏజ్గాతూ నీకీన్‍ రోజ్‍ జైతిమ్మస్‍ యో ధన్నేబి ఓలివనూ ఫహాఢ్‍ కనా జవమా ఇన సిష్యుల్‍బి ఇనా కేడే గయు. ");
INSERT INTO vgr_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","యో ఫహాఢ్‍ కనా జైన్‍ యూవ్నేతి, తూమే షోధనమా నా జనూతీమ్‍ ప్రార్దన కరో. ");
INSERT INTO vgr_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","యూవ్నకంతు ప్హాత్రో ప్హేకాతే ఏత్రు దూర్‍ జైన్‍ డూగ్నేఫర్‍ బేసీన్‍ ప్రార్దన కర్యో. ");
INSERT INTO vgr_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","భా ఆ గిన్నీనా తూన ఇష్టం హూస్యేతో మార కన్‍తూ కణ్నాక్‍, రైతోబి మారు ఇష్టం కాహే, తారుస్‍ చిత్తంహూవదే కరి ప్రార్దన కర్యో. ");
INSERT INTO vgr_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","తేదె స్వరగ్‍ మతూ ఏక్‍ దూత ఆయిన్‍, ఇనా దేక్హాయిన్‍ బలపరుచ్యు. ");
INSERT INTO vgr_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","యో వేధన పఢీన్‍ అజు గ్హణు ప్రార్దన కరమా ఇనూ పస్నో లోహిను బుంధనితర జమీన్‍ ఫర్‍ పడ్యు. ");
INSERT INTO vgr_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","ప్రార్ధన హూయిజవదీన్‍ యో ఉట్టీన్‍ సిష్యుల్‍ కనా ఆయిన్‍ దేఖామా, యూవ్నే దుఃఖంతీ థకిజైన్‍ ఖుత్యుథూ. ");
INSERT INTO vgr_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","తేదె యూవ్నేతీ, తూమే ష్యాన ఖూత్యాస్‍? షోధనమా నా జనూకతో జాగీరైన్‍ ప్రార్ధన కరో. ");
INSERT INTO vgr_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","యో బుజుబి ఇమ్మస్‍ వాతే బోలు కరతో, యత్రాస్‍మా అద్మీయే హాఃరు గుంబల్తీ భరైన్‍ ఆయు, భార జణా సిష్యుల్‍ ఏక్‍ జణొ ఇవ్నామా థో. యో యేసునా బుఛ్చా దేవనాటేకె ఆగడీ ఆయో. ");
INSERT INTO vgr_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","యేసు యూదాతి, తూ బుఛ్చా దీన్‍ అద్మీనో ఛీయ్యోనా ధరైదేంక్రరస్‍నా కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","ఇనా కేడె ఛాతే షిష్యుల్‍ యో ఖారు దేఖీన్‍, ప్రభూ ఆవ్నా ఛరీతీ ఖత్తర్‍నాఖేనా? కరి బోల్యు. ");
INSERT INTO vgr_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","యత్రస్‍మా యూవ్నామనో ఏక్‍ జణొ ప్రధాన యాజకుడ్‍ను దాసుడ్‍ను ఖావత్‍నూ ఖాన్‍నా కత్తర్‍నాఖ్యు. ");
INSERT INTO vgr_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","పన్కీ యేసు, భంధ్‍కరో అజు బైస్‍కరీ బోలిన్‍, ఇనా ఖాన్‍నా ఛీమీన్‍ అసేల్‍ కర్యో. ");
INSERT INTO vgr_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","ఇనా ధరాన ఆయూతే అద్మీయేతి యో, ప్రధాన యాజకుల్‍, ఆలయంనూ మోటావ్‍తి తూమే ఛోర్‍నా ధరాన ఆయాతిమ్‍ ఛ్హారియేతిబి లాక్డీయోతీ, ఆయానా? ");
INSERT INTO vgr_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","మే హార్‍ ధన్‍ తూమార షేడే ఆలయంమా థో కాని తూమే మన ధర్యాకోయిని. ఆ తూమారు సమయం అంధారనూ షక్తియేను సమయం కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","యూవ్నే ఇనా ధరీన్‍ భందించిన్‍ ప్రధాని యాజకుడ్‍నా ఘర్‍మా లీన్‍ గయు, కాని పేతురు యూవ్నా పీటే ఢీలే ఛాల్తొఆయో. ");
INSERT INTO vgr_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","తేదె థోడు అద్మీయే ఠణ్‍మా ఆగ్‍ షేకాన టేకె ఆగ్‍ బాళిన్‍ ఇన ఆష్పిస్‍ బేటూతో యూవ్నామా పేతురుబి జైన్‍ బేసిగయో. ");
INSERT INTO vgr_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","తేదె ఏక్‍ బాయికో, యో ఆగ్‍నూ ఉజాళమా పేతురునా దేఖిన్‍ ఆ భి యేసుతి ర్హయ్యోస్‍హూయో కరి బోలి. ");
INSERT INTO vgr_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","ఇనఖాజే పేతురు యో ఛోగిరితి యో కోన్‍కీ మన మాలం కోయిని కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","బుజ్జరగఢీతీ అజేక్‍ జణుబి ఇన దేఖిన్‍ తూబి యూవ్నామా ఏక్‍ కరి బోలామా. ఇనాబి ఇమ్మస్‍ యో మే కాహే కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","జరగడ్‍తూ బుజేక్‍ జణోబి దేఖిన్‍, “ఆ బి ఇనకేడే ర్హయ్యో, ఆ గలీలయనోస్‍ అద్మి” కరి ఘట్‍ బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","ఇనటేకె “పేతురూ తూమే ష్యాత్‍ బోలుకరస్‍కీ మన మాలంకోయిని కరి బోలుస్‍కర ముర్గు” వాష్యు ");
INSERT INTO vgr_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","తేదె యేసు పేతురూ మ్హణీ పరీన్‍ దేక్యో, తేదె ప్రభు “ఆజ్‍ ముర్గు వాహఃను అగాడి మే కోన్‍కీ మాలంకోయిని కరి తీన్‍ చోట్‍ బోలిస్‍” కరి బోల్యొతె వాత్‍ పేతుర్‍నా హఃయాల్‍ ఆయూ. ");
INSERT INTO vgr_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","తేదె యో బాధర్‍ జైన్‍ దుఃఖం పఢీన్‍ రోయ్యో. ");
INSERT INTO vgr_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","యేసునా ధర్యుతే అద్మీయే ఇనా ఇజ్జాత్‍ కాడీన్‍ మారీన్‍. ");
INSERT INTO vgr_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","ఇనూ ఢోలా భ్హాందిన్‍ తు ప్రవాక్తానీ, తూన మార్యుతే కోన్‍కీ బోల్‍ కరి బోల్యా. ");
INSERT INTO vgr_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","బుజు విరోధ్‍తి కేత్రుకీ నక్‍ల్‍ కర్తుహూయిన్‍ వుజు ఆవుమానంను వాతే బోల్తు హుయిన్‍, దూషిస్తా ర్హయ్యా. ");
INSERT INTO vgr_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","వ్హాణు హూస్‍కర యూదుల్‍నా మోటా, ప్రధాన యాజకుల్‍ షాస్ర్తుల్‍ ఖారు ఏక్‍ జోగోమా మళిన్‍, యేసునా మోటా సభమా బులాలిన్‍ ఆయూ. ");
INSERT INTO vgr_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","ఏజ్గా యేసునా “తూ క్రీస్తు హూస్యేతో హమారేతి బోల్‍” కరి బోల్యు. తేదె యో “మే బోల్యొతోబి తూమే నమ్‍స్యు కోయిని కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","మే తూమ్‍నా పుఛాయోతో తూమే మన జవాబ్‍ దిస్యుకోయిని. ");
INSERT INTO vgr_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","కాని హంకేతూ ధరీన్‍ అద్మినొ ఛియ్యో సర్వోన్నత్ దేవ్‍ని ఖవ్వాహాత్‍ను మ్హాంఢీఫర్‍ బేహ్‍ఃస్యే” కరి బోల్యా. ");
INSERT INTO vgr_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","ఇనటేకె యూవ్నే, ఇమ్‍ హూస్యేతో తూ దేవ్నొ ఛియ్యోనా? తూ బోల్యొతిమ్‍ యో మేస్‍కరీ యూవ్నేతి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","తేదె యూవ్నే అజు అప్నా సాక్చల్‍తి కామ్‍ ష్యాత్‍? ఇనా మోఢవాటేస్‍ ఖంజకున్నా కరి బోల్యా. ");
INSERT INTO vgr_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","యత్రమా సభామ ఛాతే హాఃరు ఉట్టీన్‍ ఇనా పిలాతు కన లీన్‍ గయా. ");
INSERT INTO vgr_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","ఆ అప్నా అద్మీయేనా తప్పు వాట్‍ ధరాంగ్రస్‍, అజు రోమా రాజోనూ పన్నుబి భాందోనకోకరీ మేస్‍ క్రీస్తు రాజో కరి బోలుకరతో హమే హఃమ్జ్యా, కరి ఇనఫర్‍ ఇన్‍జామ్‍ నాఖానిక్ల్యా. ");
INSERT INTO vgr_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","పిలాతు తూ “యూదుల్‍నూ రాజోనా?” కరి ఇనా పుఛ్చావమా యేసు హో “తూ బోలతిమ్మస్‍” కరి ఇనేతి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","యేసు ఇమ్‍ బోలమా పిలాతు ప్రధాన యాజకుల్‍తీ, అద్మీయేతి మన ఆ అద్మి కనా షీక్చనాటెకే ఖాయిబి తప్పు దేఖౌంగ్రకోయిని కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","తేదెబి యూవ్నే ఆ గలీలయతూ ధరీన్ ఆజ్గా తోడీ ఇనా బోధనల్‍తి యూదయమా ఖారమా బోధిస్తోహుయిన్‍, జనాల్‍నా వూషీ కరౌతో ర్హయో అజు ఘణు ఛిక్రాణ్‍ మ్హేంతా హూయిన్‍ బోల్తార్హయ్యా. ");
INSERT INTO vgr_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","పిలాతు ఆ వాతే ఖంజీన్‍ ఆ అద్మి గలీలయమనూ అద్మినా? కరి పుచ్చాన్‍, ");
INSERT INTO vgr_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","యో హేరోద్‍ ఏలుకరతే దేహ్‍ఃనో కరి హూస్యేతో హేరోద్‍ కనా బులైలిజవో కరి బోల్యొ, తేదె హేరోద్‍ యో ధన్‍మా యెరూషలేమ్‍మస్‍ థో. ");
INSERT INTO vgr_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","హేరోద్‍ యేసునా దేఖీన్‍ జర ఖూషీ హూయిన్‍, ఇనా గురీంచీన్‍ గ్హణు వాతే ఖంజో ఇనటేకె యో ఏఖాదు సూచననూ కామ్‍ కర్యుతో దేఖ్నూ కరి ఆఖ్‍ః కర్యొ, ఘాణ ధన్‍తూ ఇనా దేఖ్నూ కరి రైగో. ");
INSERT INTO vgr_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","హేరోద్‍ యేసునా దేఖీన్‍ కేత్రుకి ప్రష్నల్‍ పుచ్చాయోతోబి యో ఏక్‍ వాత్నాబీ జవాబ్‍ దిదోకోయిని. ");
INSERT INTO vgr_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","ప్రధాన యాజకుల్‍, షాస్ర్తుల్‍ హీబ్రీన్‍ ఇనా ఫర్‍ కేత్రేకీ నిందల్‍ నాఖ్‍తా ర్హయ్యా. ");
INSERT INTO vgr_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","హేరోద్‍ ఇనా సైనికుల్‍తీ మళిన్‍, ఇనా ఇజ్జాత్‍ గేలి కాఢీన్‍, లుంగఢా పేరైన్‍ అజు పిలాతు కనా బోలిమొక్‍ల్యా. ");
INSERT INTO vgr_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","అనా అగడీ హేరొద్‍బి పిలాతు ఏక్‍నా ఏక్‍ వైరేవ్‍నితర థా. యో ధన్‍మా బే జణా దోస్తీ హూయిగయా. బరబ్బా చుట్టను యేసున మరణ్‍ షిక్చా ");
INSERT INTO vgr_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","తేదె పిలాతు ప్రధానుల్‍నా, అధికరుల్‍నా అద్మీయేనా ఖారవ్నా బులైమంగైన్‍. ");
INSERT INTO vgr_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","పిలాతు అద్మీయేనా ఫాచు పరీన్‍ బోలా, కరుకరస్‍ కరి తూమే ఆ అద్మీనఫర్‍ మార ఖామే లాయ పణికీ మన ఆ అద్మినా ఏన్‍ కరీన్‍ దేఖామా ఏక్‍ గల్తీబి కోదేఖైయుని. ");
INSERT INTO vgr_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","హేరొద్‍నాబి ఖాయిబి కోదేఖైని, ఇనటేకె అనా అజు ఫాచు మార కనా బోలిమెక్‍ల్యు. ఆ మర ఏత్రే ఖైబి గల్తీ కర్యొకోయిని. ");
INSERT INTO vgr_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","ఇనటెకె మే అనా ఖాళి కోల్డతీ షిక్చ నాఖిన్‍ మ్హేందిస్‍ కరి బోలమా, ");
INSERT INTO vgr_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","పండగను వక్హత్‍ సమయంమా పిలాతు అద్మినటెకె ఏక్‍ చ ఖైదీన బెందావను ఆనవాతి థూ. ");
INSERT INTO vgr_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","యూవ్నే హాఃరు యేసునా మర్రాకీన్‍, ఖైది బరబ్బనా ఛోడీ మ్హేందో కరి ఖారు ఏక్కస్‍ ఖైకార్‍తీ ఛిక్రనిక్లియు. ");
INSERT INTO vgr_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","యో హఃయార్మా కర్యోతే గలాఠాన ఖాజే, నర్‍హత్యనా ఖాజే ఇనా ఠాణమా ఘలాయ్‍గయోతే యోబరబ్బా. ");
INSERT INTO vgr_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","పిలాతు అద్మియేతీ బోల్యొ, యేసునస్‍ మ్హేందేనూ కరి పాఛు బోల్యుతోబి. ");
INSERT INTO vgr_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","యూవ్నే హాఃరు అనా “సిలువస్‍ నాఖో సిలువ నాఖో” కరి ఛిక్రాణ్‍ మ్హేంధా. ");
INSERT INTO vgr_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","తీన్‍మనూ వోహోఃత్‍బి ఇమ్మస్‍ ఆ ష్యాను గల్తీ కర్యొ? మరణ్‍ అనాకనా ఖైబి గల్తీ కో దేఖౌంగ్రని ఇనటేకె అనా సిక్చించిన్‍ మ్హేందుంగ్రుస్‍ కరి యూవ్నేతి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","పన్కి, కేత్రు బోల్యుతోబి యూవ్నే నాఖంజ్నుతిమ్‍ అనా సిలువ నాఖో కరి అడాతీబీ బుజు జాఖాత్‍ కైఖార్‍ మ్హేంధామా ఇవ్నేస్‍ జిత్యూ. ");
INSERT INTO vgr_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","తేదె పిలాతు యూవ్నే బోల్యాతిమ్మస్‍ హూవధే కరి తీర్పు దీధో. ");
INSERT INTO vgr_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","బరబ్బ కర్యొతే గలాఠానా, మర్రాకినాకను నేరంనాఖాజే ఘలైరోతే ఇనా యో బోలాతిమ్‍ ఛుట్టీ కరీన్‍, యేసునా కీమ్‍బి కర్‍లేవోకరీ యూవ్నాటెకె ధరైనగ్‍దిదో. ");
INSERT INTO vgr_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","యూవ్నె క్హార యేసునా లీన్‍ జౌంగ్రతో గమ్మాతూ ఆయోతే కురేనీయుడ్ను‍ హుయోతె సీమోన్‍ కరి ఏక్నానా ధర్లీన్‍ యేసునాకేడె సిలువ ఢోవ్వానాటేకె ఇనా బులైలీన్‍ జైన్‍ ఇనా హాతే ఢోవ్వాయూ. ");
INSERT INTO vgr_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","మోటు అద్మీయేనూ ఫాంభళే ఇన్మా త్హోడుబాయిక దేఖీన్‍ ఛాతీకుట్‍లేతూ దుఃఖ పడ్తహూయిన్‍, కేత్రుకీ జణీ బాయికాబి యేసునాకేడె జాతుర్హయూ. ");
INSERT INTO vgr_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","తేదె యేసు యూవ్నామణి ఫరీదేఖిన్‍, ఓయెరూషలేమ్‍ని ఛోరీయే మరటేకె, నకో రోవొ; తూమార టేకె తూమార లఢ్‍కాన టేకె రోవొ. ");
INSERT INTO vgr_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","వాంజీణీయేబి, జణీ కోయిన్తె పేట్‍, దూత్‍ పీఢాయి కోయిన్తె తూమ్నా కేత్రుకీ అచ్చు హూయు కరి బోలానూ ధన్‍ ఆంగ్రస్‍. ");
INSERT INTO vgr_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","తేదె యూవ్నే పహాడ్తి హమార ఫర్‍ పడ్‍కరీ బోల్‍స్యే. బుజు ఫాహాడ్‍నా హమారఫర్‍ పఢీన్‍ ఢాపీనాక్‍ కరి బోల్‍స్యే. ");
INSERT INTO vgr_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","యూవ్నే ఖఛ్చు జాఢనస్‍ ఆమ్‍ కర్యుతో, కుఖ్కు జాఢనా అజు ష్యాత్‍ కరస్‍కీ? కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","యేసునా కేడె అజు బేజణాన నేరస్తులున సిలువ మారనటేకె లీన్‍ గయ్యా. ");
INSERT INTO vgr_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","యూవ్నే యేసునా కపాలం కరి బోలాతే (కలవర) జోగొమా ఆయ తేదె ఏజ్గా యేసునా ఖావత్‍ మణి ఏక్‍ జణనా, ఢవాత్‍ మణి ఏక్‍ జణనా కరి సిలువ మార్యు. ");
INSERT INTO vgr_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","యేసు ఆమ్‍ బోల్యొ, “భా ఆవ్నే ష్యాత్‍ కరుకరస్‍కీ అవ్నాస్‍ మాలంకోయిని అవ్నా క్చమించ్‍” కరి బోల్యొ. యూవ్నే చీట్లునాఖిన్‍ యేసును లుంగ్డాన ఫాడీన్‍ భాగ్‍ పళ్లిధా. ");
INSERT INTO vgr_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","అద్మీయే హాఃరు హిబ్రిన్‍ దేక్తూర్హయూ, తేదె అదికారుల్ ఆ “ఫార్లేవ్‍నా హూయితో భచయో! ఇనా హాఃఛీస్‍బి దేవ్‍ బోలిమోక్‍ల్యొతే దేవినిచే ఎన్ని రాక్యోతె క్రీస్తు హూస్యేతో ఇనూ యోస్‍ భచీజాసే” కరి బోల్లీదు. ");
INSERT INTO vgr_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","సైనికుల్‍బి కందే ఆయిన్‍ సైనికుడ్‍బి ఘేఖికాఢీన్‍ ఇనా ఖడు రహ్‍ఃనా దీదూ. ");
INSERT INTO vgr_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","మరియు తూ “యూదుల్‍నో రాజో హూస్యేతొ” తారు తూస్‍ నా భఛీజాకరీ గేళిసైనికుడ్‍బి కాఢ్యా. ");
INSERT INTO vgr_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","“ఆస్‍ యూదుల్‍నో రాజో” కరి నీక్కీన్‍ సిలువనా ఉఫర్‍ అట్‍క్వాయు. ");
INSERT INTO vgr_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","ఇనాకేడె సిలువ ఛఢీర్యూతే నేరస్తుడ్‍మా యూవ్నామా ఏక్‍ జణొ ఇనా గాళే దేతోహూయిన్‍ తూ క్రీస్తు కహేనా? తారు తూస్‍ భఛీన్‍ హమ్‍నాబి భచవ్‍ని కరి బోల్య. ");
INSERT INTO vgr_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","తేదె బేమ్మనో ఇనా గుర్‍ఖైన్‍ తూ దేవ్‍నా ఢరకోయిన్నా! తూబి యోస్‍ షిక్చమా ఛాకున్నా! ");
INSERT INTO vgr_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","అప్నా షిక్చించనూ న్యాయమస్‍. ష్యానకతో అప్నే కర్యతే పాపల్నా టేకె షిక్చ పడుకరస్‍ పణికీ యేసునే క్హయూ తప్పు కర్యొకోయిని కరి బోలీన్‍, ");
INSERT INTO vgr_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","యో యేసుతీ, ప్రభు! తారు రాజ్యంమా ఆవనూ వోహోఃత్‍ మనాబి ఖాయాల్‍ కర్లీజోకరీ బోలామా. ");
INSERT INTO vgr_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","యేసు ఇనేతి బోల్యొ, “ఆజ్‍ తూబి మార కేడె పరదేసిమా ర్హైస్ హాఃఛీతి బోలుకరుస్‍” కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","తేదె భరోబ్బర్‍ ధోపర్‍ హుయు, తేదె భార భజేథూ ధరీన్‍ తీన్‍ గంటాతోఢీ యో దేహ్‍ః అక్కు అంధారు హూయిగు. ");
INSERT INTO vgr_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","సూర్యుడ్‍బి దేఖైయో కోయిని; మందిరంనూ భీతే బే భాగ్‍ హూయి ఛీరైగయూ. ");
INSERT INTO vgr_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","తేదె యేసు ఏక్‍ మోటు ఆవాజ్‍తి “భా మారు ఆత్మనా తార హాత్మా మ్హేంధుకరుస్‍” కరి బోలీన్‍ జాన్‍ మ్హేందో. ");
INSERT INTO vgr_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","షతాధిపతి జర్‍గ్యూతే క్హారు దేఖీన్‍, దేవ్నా స్తుతించిన్ ఆ అద్మి క్హాఛ్చీస్‍బి నీతితీ ఛాకరీ బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","యేసునాకేడె ఆయుతే క్హారుజణు ఇనా దేఖీన్‍ ఛాతీకూట్టీన్‍ రోవ్తూహూయిన్‍ ఛలీగూ. ");
INSERT INTO vgr_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","యేసునా మాలంహూయు అద్మీయే, గలీలయమతూ ఆయుతే థోడీ బాయికాబి యో ఖారు దేక్తూహుయిన్‍దూర్‍ హిబ్ర్యుథూ. ");
INSERT INTO vgr_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","అరిమతయియ కరి యూద ఖాయార్‍మనూ ఏక్‍ సభ్యుడ్‍ యోసేపు కరి ఏక్‍ జణో థో. ");
INSERT INTO vgr_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","యో నీతినో అషల్ అద్మి, యో దేవ్నూ రాజ్యంనా టేకె ఎదుర్‍ దేక్తోర్హయో. యేసునా మరణ్‍నూ షిక్చ నాఖానూ వాత్మా ఓప్యోకోయినితే అద్మి. ");
INSERT INTO vgr_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","యోసేపు, పిలాతుకనా జైన్‍ యేసునూ ముర్దానా హమ్‍నా ధా కరి మాంగీలీదొ. ");
INSERT INTO vgr_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","యో ముర్దాన హేట్‍ వుత్రాయిన్‍, నారను లుంగఢామా లఫ్‍టిన్‍ ఇనాబాద్‍మా పళ్ళీజైన్‍ హాంకేతోడీబి కీనా గ్హల్యుస్‍ కోయిన్తే ఖాళి సమాదినూ ఖాఢమా గ్హాలీన్‍ యో సమాధినూ గవ్హీనా ఏక్‍ మోటో గండ్‍ భండోనా ధర్‍వాజునితర మూఛ్యు. ");
INSERT INTO vgr_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","యో ధన్‍ ఆరామ్నూ ధన్‍ అవానాటేకె సిద్దంథూ. ");
INSERT INTO vgr_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","తేదె గలిలయథూ యేసునకేడె ఆయుతే బాయికా యోసేపునాకేడె జైన్‍ యేసునూ సమాధిన దేఖ్యు. ");
INSERT INTO vgr_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","ఇనబాద్‍మా పాచుఫరీన్‍ జైన్‍ అత్తర్బి వాక్హ్ నూ రాచా లీధూ. పణికీ యూవ్నే మోషే ధర్మషాస్త్రం ఛాతెతీమ్‍ ఆరామ్‍నూ ధన్నే కాయిబి కామ్‍ నాకర్నూకరీ యూవ్నే షోపొథా. ");
INSERT INTO vgr_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","ఆదివార్‍నా వ్హానెహఃత్రె హూంక్రతో యోబాయికా లీరాక్యూతే అత్తర్, రాఛనా పళ్లీజైన్‍ యేసునూ సమాధికనా గయూ. ");
INSERT INTO vgr_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","యో సమాధిఛాతే గ్హవీనా మూఛీరాక్యతే భండో నీక్లీరవ్హమా దేఖీన్‍ మైహ్‍ గయా పణికీ ");
INSERT INTO vgr_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","యూవ్నా ప్రభు యేసును ఆంగ్‍ కోదేఖైయుని. ");
INSERT INTO vgr_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","ఇనటేకె యూవ్నాఖైయిబి సోఛవకోయినితీమ్‍ రవ్హమా, ఏత్రాస్‍మా ధోళు పట్‍ జమ్‍కుకరతే లుంగఢా పేర్‍రాక్యుతే బే అద్మీయే ఆక్చార్యంహుయీన్‍ ఇవ్నే ఖామే హీభ్ర్యు. ");
INSERT INTO vgr_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","యూవ్నే ఢరీన్‍ ముఢ్‍క్యా హేట్‍ జుఖైలేవమా ఆవ్నే జీవీ ర్హోతే ఇనా ఘోరాఢవ్‍మా తూమే ష్యాన ఢూంఢుకరస్‍? ");
INSERT INTO vgr_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","యో అజ్గ కోయిని, యో జివీన్ ఉట్టీరోస్‍; యో గలీలయమా రయ్యో తేదె, ");
INSERT INTO vgr_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","తూమ్‍నా అద్మీనో ఛీయ్యో పాపుల్‍నా హాతే ధరైన్‍ సిలువ నఖైన్‍ మరిన్‍ తీన్‍మనూ ధన్నే ఉటాను ఛాకరీ బోల్యొతే వాతే ఖాయాల్‍ కర్‍లేవో కరి బోల్యు. ");
INSERT INTO vgr_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","తేదె యూవ్నే యోవాతే ఖాయల్‍ కర్లీదు. ");
INSERT INTO vgr_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","యో సమాధి కన్‍తూ యూవ్నే జైన్‍, హారఅద్మి సిష్యుల్‍నబి అద్మీయే హాఃరవ్‍నా యో వాతేనా బోల్యు. ");
INSERT INTO vgr_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","యో వాతే బోల్యుతే కోన్‍కతో మగ్దలేనే మరియబి, యోహాన్నబి, యాకోబ్‍ని ఆయా మరియ, యూవ్నాకేడె అజు థోడి బాయికా థీ. ");
INSERT INTO vgr_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","హూయుతో యూవ్నే వాతె దేవ్నా వాతెంతర దేఖ్కాయు అవ్నె బోల్యుతె వాతేనా షిష్యుల్‍ నమ్మ కొయినితిమ్‍ బొల్లి దు. ");
INSERT INTO vgr_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","రైతోబి పేతురు ఉట్టీన్‍ జైన్‍ యో సమాధి కనా దేఖమా ఖాళీ లుంగఢా పఢ్యుతూ, ఇనా దేఖీన్‍ యో హషంహూయి ఘర్‍ కనా ఛలేగొ. ");
INSERT INTO vgr_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","యోస్‍ ధన్నే యూవ్నామా బేజణ యెరూషలేమ్‍నా ధర్రాసు దూర్‍మా ఛాతే ఎమ్మాయు కరి ఏక్‍ గమ్మా ఛలి జౌంగ్రతో, ");
INSERT INTO vgr_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","యెరూషలేమ్‍‍మా జర్‍గ్యూతే అక్కు ఏక్‍నా ఏక్‍ బొల్లేతూర్హయు. ");
INSERT INTO vgr_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","యూవ్నే ఇమ్‍ వాతే బోల్తాహూయిన్ సోచుకర్తథా, యేసుబి ఆయిన్‍ యూవ్నాకేడె ఛాలనిక్‍ల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","కానీ యూవ్నే యేసునా దేక్యా పన్కీ, గుర్తుదర్యూకొయినీతిమ్‍ ఢోళో ముచ్చాయుగయూ. ");
INSERT INTO vgr_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","యో, తూమే చాల్తోహూయిన్‍ తూమే ష్యాను వాతే బోల్‍లేంగ్రస్ కరి బోలమా, యూవ్నే ధుఃఖపడ్తుహూయిన్‍ హీభ్రి గయూ. ");
INSERT INTO vgr_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","యూవ్నామా ఏక్‍జణో క్లెయొపా కరి జణో యేసుతీ ఆమ్‍ బోల్యొ, యెరూషలేమ్‍మా రైన్‍బీ తూన ఆవాతే మాలంకొయినినా? కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","యేసు యోష్యాను వాతేకీ బోల్కరి బోల్యొ, యూవ్నే నజరేయుడ్నొ హుయోతె యేసుని వాతేస్‍; యో దేవ్నాబి, అద్మీయేకనాబి, క్రియామాబి, క్హారవ్మా ఏక్‍ ప్రవక్తనితర ర్హయో. ");
INSERT INTO vgr_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","అపుణు ప్రధాన యాజకుల్బి అధికారుల్బి యేసునా కింమ్నితర మరణ్‍ షిక్చానా ధర్యాయ్‍, సిలువమా నఖాయకీ తుమ్నా మాలంకొయిన్నా. ");
INSERT INTO vgr_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","హామే ఇష్రాయేల్‍నా యోస్‍ భచవ్‍స్యే కరి భరోసా కర్‍రాక్యథా. ఆ ఖారూ హూయిన్‍ తీన్‍ ధన్‍ హూంక్రస్‍ కరి బోల్యు. ");
INSERT INTO vgr_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","హమారమా థోడీ బాయికా వ్వాణే ఖాత్రే ఇనూ సమాధి కనా జైన్‍ దేఖామా, ఆష్చర్యాపర్చూ. ");
INSERT INTO vgr_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","థోడ దేవదూతల్‍ దేఖైన్‍ యో జీవిన్‍ ఉటీరోస్‍ కరి బోల్యుతే వాతే హమ్‍నా బోల్యు. ");
INSERT INTO vgr_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","యోబాయికా బోల్యుతిమ్‍ అజు థోడు జణుబి జైన్‍ దేఖామా, యూవ్నాబి యేసును ముర్దు దేఖైకోయిని కరి బోల్యు. ");
INSERT INTO vgr_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","ఇనటేకె యో యూవ్నేతి బుద్దు అద్మీయే, “ప్రవక్తల్‍ బోల్యుతే వాతేనా నమ్మానా అత్రే ఆల్యసం ష్యాన కరుకరస్‍? కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","క్రీస్తు ష్రమపఢీన్‍ మరీజైన్‍ యో మహిమమా జాస్యేతే జరూర్‍ కాహేనా?” కరి యూవ్నేతి బోలిన్‍, ");
INSERT INTO vgr_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","బుజూ మోషేబి, కేత్రాకీ ప్రవక్తల్‍ నిఖ్యాతే యోఖారవ్‍మా ఇనా గురీంచీన్‍ లిఖైర్యూతే వాతేనా బోలీన్‍ ఇనూ మతలబ్నా మాలంకరాయో. ");
INSERT INTO vgr_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","యత్రమా ఇవ్నేజంకరతె గామ్‍ కందే ఆవమా, యో బుజుథోడు దూర్‍బి జవవాళోంతర దేఖాయో. ");
INSERT INTO vgr_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","యూవ్నే ఇనా హాఃమి క్హాంజ్‍హూయిగు తూ హమారకేడెస్‍ ర్హాకరి బోలమా, యేసు తెదె యూవ్నాకేడె గయో. ");
INSERT INTO vgr_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","తేదె యూవ్నేహాఃరు ఖాణు ఖావనాటేకె బేఖామా యో ఏక్‍ రోటొనా పాడీన్ కృతజ్ఞతకరీర్‍ ఇనా తోడిన్‍ ఇవ్నా దేవమా, ");
INSERT INTO vgr_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","తేదె యువ్నా డోళొ వుక్‍డైన్‍ ఇనా యేసు కరి ఖణాద్ ధర్యు; పన్కి యేసు తేదె యువ్నా దేఖాయో కోయినితీమ్‍ మాయం హూయిగో. ");
INSERT INTO vgr_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","తేదె యూవ్నే, యో వాట్‍ఫర్‍ ఇనా గురించీన్‍ వాక్యంనూ వాతే బోల్యొ తేదె అపుణు దిల్‍మా ఏక్‍ ఆగ్‍నితర భళ్యుకోయిన్నా? కరి యూవ్నే బోల్లీదు. ");
INSERT INTO vgr_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","తేదెస్‍ యూవ్నే ఉట్టీన్‍ యెరూషలేమ్‍నా పరీన్‍ గయా. ఏజ్గా గ్యారజణబి అజు క్హార అద్మీయేబి ఏక్‍జోగొ మలీన్‍ బేటు థూ. ");
INSERT INTO vgr_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","ప్రభు క్హాచ్చీస్బి జివీన్ వుట్టీన్‍ సీమోన్‍నా దేఖైయో కరి బోల్లీదు. ");
INSERT INTO vgr_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","యూవ్ను వాతే ఖంజీన్‍ వాట్ఫర్‍ యేసుతి వాతె బోల్తాహూయిన్‍ ఆయాతే యూవ్నేతి యో బోల్యోతే వాతే, బుజు రోటొనా థోడీన్‍ దిధోతే యో వాతేవ్నా యో బేజణ యూవ్నేతి బోల్య. ");
INSERT INTO vgr_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","యూవ్నే హాఃరు యో వాతే బోల్లేంగ్రతో, ఎగ్గీస్‍ యేసు యూవ్నా ఇఛ్మాకరీ ఆయిహిబ్రిన్‍ “తూమ్‍నా సమాధానం హూవదా” కరి యూవ్నేతి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","తేదె యూవ్నే ఖారు భూతంనా దేఖ్యాకరీ ఢరీగయూ. ");
INSERT INTO vgr_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","పన్కీ, యేసు ఇవ్నేతి, తూమే ష్యాన ఢర్యూకరస్‍? తూమారు దిల్మా అత్రే అనూమానం కీమ్‍ ఆవాస్‍? కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","మార హాత్‍ గోఢనా దేఖో, యోస్‍ మే, మన ఛీమిన్‍ దేఖొ, మన భోటీ హాఢ్‍క్యా ఛా, కానీ భూతంనా యో ఖారు కోర్హైని కరి. ");
INSERT INTO vgr_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","ఇమ్‍ బొల్తూవక్హత్‍ యో యూవ్నా ఇనూ హాత్‍, గోఢాన దేఖాఢ్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","తేదె యూవ్నే ఖూషీతి అజున్‍బి యూవ్నా నమ్మకొయింతె, హాషం హూంగ్రతో, తేదె యేసు తూమార కనా ఏక్‍ రోటొ ఛానా? కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","యూవ్నే భుంజ్యుహూయు ఏక్‍ మాస్లాను టుక్డొన ఇనా దిధూ. ");
INSERT INTO vgr_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","యో ఇనా లీన్‍ యూవ్నా ఖామేస్‍ ఖైగో. ");
INSERT INTO vgr_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","మే తూమారేతి మళిన్‍ ర్హయో తేదె మోషే ధర్మషాస్ర్తంమా, ప్రవక్తల్‍నూ గ్రంధాల్మా, కీర్తనల్‍మా మరా గురీంచీన్‍, నీఖైర్యూతే ఖారు జరగ్‍స్యే కరి మే తూమ్‍నా బోల్యొతే వాత్‍ జర్యుగుకరీ ఇవ్నేతి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","తేదె యో యూవ్నా వాక్యంనా అర్దం కరవానటేకె యూవ్ను దిల్నా ఖూల్లా కర్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","క్రీస్తు ష్రమ పడీన్‍ మరీజైన్‍ తీన్‍మనూ ధన్నే జీవిన్‍ వుట్‍స్యేకరీ లిక్కారుతింమ్‍, ");
INSERT INTO vgr_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","“యెరూషలేమ్‍థూ ధరీన్‍ హాఃరు జనాభోమా ఇనూ నామ్‍తు దిల్‍ భద్లాయిలేవనూ, పాప క్చమపణ్‍ ప్రచార్‍హూస్యే” కరి లిఖ్కైర్యూస్‍. ");
INSERT INTO vgr_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","ఆ వాతే ఖారవ్నా తుమేస్‍ సాక్చుల్‍ కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","హదేక్‍ మారో భా వాక్దాన్‍దిదోతే ఇనా మే తూమారఫర్‍ బోలిమొక్లుస్‍; పణికీ స్వర్గం‍మతూ పరిసుద్దాత్మనూ షక్తి తూమారఫర్‍ ఆవతోడీ తూమే యెరూషలేమ్నూ హఃయార్‍మస్‍ ర్హవో. ");
INSERT INTO vgr_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","యేసు బుజు యూవ్నా బేతనియతోడీ బులైలీజైన్‍ హాత్‍ పాడీన్‍ యూవ్నా ఆషీర్వదించ్యో. ");
INSERT INTO vgr_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","ఇవ్నా ఆషీర్వదించ్యుకరతో తేదెస్‍ యో యూవ్నేతి దూర్‍ హూయిజైన్‍ స్వర్గంమా ఛలేగయో. ");
INSERT INTO vgr_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","ఇనబాద్మా యూవ్నే ఇనా హఃలమ్‍ కరీన్‍, కెత్రేకీ ఖుషీతి స్తుతికర్తూ యెరూషలేమ్‍మా గయా. ");
INSERT INTO vgr_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","బుజు యూవ్నే దేవాలయ్‍మా రైన్‍, లగాతార్‍ దేవ్నా స్తుతిస్తూ ర్హయా.");
INSERT INTO vgr_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","జమాననూ అగాఢి వచన్‍ థూ, యో వచన్‍ దేవ్కన థూ, యోవచన్‍ దేవ్‍హుయిన్‍ థొ. ");
INSERT INTO vgr_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","యో త్యో జమానమా దేవ్కనా థొ. ");
INSERT INTO vgr_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","సమస్తంబీ ఇన బన్తీస్‍ హుయు. హుయీన్ ఛాతె కెహూబి యో కొయినితిమ్‍ కోహుయూని. ");
INSERT INTO vgr_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","ఇనమా జీవం థూ; యో జీవమస్‍ అద్మిహాఃరనా ఉజాలుహుయిన్‍ థూ. ");
INSERT INTO vgr_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","యోఉజాలు అంధారమా బలుకరస్‍ పన్కి, అంధారు యో ఉజాలనా గ్రహించకరకొయిని. ");
INSERT INTO vgr_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","దేవ్ కంతు బోలి మొక్లాయుహుయుతే ఏక్ అద్మి థూ ఇను నామ్‍ యోహాన్‍. ");
INSERT INTO vgr_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","ఇనబారేమా హాఃరుబి విష్వసించా హాఃర్కూ యో యోఉజాలున గూర్చి బోలనటేకె సాబుత్‍నితార ర్హయో. ");
INSERT INTO vgr_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","యో యోఉజాలనీతర కాహె పన్కి యోఉజాలునటేకె సాబుత్ ‍బోలనఖాజె ఇనే ఆయో. ");
INSERT INTO vgr_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","హాఃఛి ఉజాలు థూ; యోములక్మా ఆవ్తూ హర్యేక్‍ అద్మియేనా బల్తూరయ్యూ. ");
INSERT INTO vgr_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","వాక్యం ఆములక్మా థొ, ఆములక్‍ ఇన బారేమా హుయు. పన్కి ములక్మాఛాతె ఇవ్నే వాక్యంనా అంగీకరించాకొయినీ. ");
INSERT INTO vgr_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","యో ఇను స్వంత అద్మికనా ఆయో; పన్కి ఇవ్నే ఇనా అంగీకరించాకొయినీ. ");
INSERT INTO vgr_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","ఇన కెత్రుకి అద్మి అంగీకరించాస్కి, కతో ఇవ్నా హఃరవ్‍నా ఇను నామ్తీ విష్వాసంరాఖవాలన దేవ్‍ను లడ్కా హువనటెకె హక్కు దిరాక్యోస్‍ ");
INSERT INTO vgr_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","ఇవ్నే దేవ్ను బారెమా ప్హైదాహుయాస్‍ పన్కి, లోహితితోబి, ఆంగ్తాన్ను ఆహ్‍ఃతితోబి ప్హైదాహుయాతె కాహె. పన్కి ఇవ్నా భా దేవ్‍హుయీన్‍ ఛా. ");
INSERT INTO vgr_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","యో వచన్‍ అంగ్తాన్‍తి హుయీన్‍ ఛా, కృపాసత్యసంపూర్ణంతీ అప్నా ఇఛ్మా జీవిన్‍ ర్హయ్యో. భా కంతు ఆయోతే ఏక్నొఏక్‍ ఛియ్యోనూ, మహిమతర అప్నె ఇను మహిమాన దేఖ్యా. ");
INSERT INTO vgr_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","యోహాన్‍ ఇనబారేమా సాబుత్‍ బోల్తొహుయిన్‍ మారఫీటె ఆవ్సేతె మారెతీబి మోటొగల్డొ ఇనటెకె యో మారెతీబి అగాఢివాలొ హుయోకరీ మే బోల్యొతె యోస్‍ ఆస్కరీ గట్తి చిక్రీన్‍ బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","ఇను పరిపూర్ణ కృపమాతు అప్నెహాఃరు ఆసీర్వాద్‍మతూ ఆసీర్వాద్‍ అప్నే పొందిరాక్యస్‍. ");
INSERT INTO vgr_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","దేవ్‍ ధర్మషాస్త్రం మోషెనా బారెమా అనుగ్రహించబడ్యూ; పన్కి కృపబీ, హాఃఛి యేసు క్రీస్తుబారేమా హుయూ ");
INSERT INTO vgr_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","కోన్బి కెదేబీ దేవ్నా దేక్యాకొయిని; భానుతర ఇను రూప్మాఛాతె, ఏక్నొయేక్‍ ఛియ్యోస్‍ ఇనగూర్చి భార్‍నాక్యో. ");
INSERT INTO vgr_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","బుజు యూదుల్నుమొట్టా యెరూషలేమ్‍థూ యాజకుల్‍నా, లేవీయుల్‍మా థోడుజను యోహాన్‍కన మొక్లితెదె థూ కోన్కరి? పుఛ్చావనటేకె యోబోల్యొతె సాబుత్‍ ఆస్‍. ");
INSERT INTO vgr_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","ఇనటేకె యో మాలంకొయినీకరి ఒప్పిలిదు; హుఃద్‍తి “క్రీస్తు కాహేకరి” బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","తెదె ఇవ్నే బుజు థూ కోణ్, థూ ఏలియానా? కరి పుఛ్చావమా “యో కాహేకరి” బోల్యొ. థూ యోప్రవక్తనా? కరి పుఛ్చావమా యో కాహేకరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","అనటేకే ఇవ్నే థూ కోణ్? హమ్నా మొక్లొతె ఇవ్నా హమే జవాబ్‍దేను, అనహాఃజె తారగూర్చి థూ సాత్ బొల్లేంకరస్‍కరి ఇన పుఛ్చాయూ! ");
INSERT INTO vgr_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","ఇనటేకె ఇనే ప్రవక్తాహుయూతె యెషయ బోలొతిమ్ మే ప్రభువును వాట్‍నా హూఃదుకర్యో కరి, జాఢిమా ఖైకార్‍ బేందుకరతే ఏక్ను ఆవాజ్‍కరి ఇవ్నేతి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","బుజు పరిసయ్యుల్‍ థోడుజాను హఃబర్‍ బోలవాలన బోలిమొక్లల్యో. ");
INSERT INTO vgr_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","ఇవ్నే “థూ క్రీస్తుతోబీ, ఏలియతోబి, ప్రవక్తతోబి నాహుయోతో సానఖాజె బాప్తిస్మమ్‍నా ద్యెకరస్కరి ఇన పుఛ్చావమా” ");
INSERT INTO vgr_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","ఇనటెకె యోహాన్‍ మే పానిమా బాప్తిస్మమ్‍ దెమ్‍కురుస్ పన్కి యో తుమారయిచ్మా ఛా; తుమె ఇన మాలంకర్సుకొయిని, ");
INSERT INTO vgr_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","మార పీట్పాసల్‍ వలావస్‍ పన్కి, “మే ఇని చెప్లెకాడనబీ మన యోగ్యత కొయినీ” కరి ఇవ్నేతీ బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","యోహాన్ బాప్తిస్మమ్‍ దేవుంకరతే యొర్దాను నదినా పార్‍ఛాతే బేతనీయగామ్మా ఆ సంగతుల్‍ హాఃరు జరగ్యు. ");
INSERT INTO vgr_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","బుజేక్‍ధన్నే యోహాన్ ఖందే యేసు ఆవను దేఖీన్‍ హదేక్‍ ములక్ను పాప్‍నా ఢోహిలీన్‍ జవ్వాలొ దేవ్నొ మ్హేండనుచెల్కు. ");
INSERT INTO vgr_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","మే కినా బారెమా వాత్‍ బోలుకరూస్కి యోస్‍ ఆ మారపీటె ఏక్ అద్మి ఆవుంకరస్‍; యో మారెతీబి ప్రముఖుడ్‍; ఇనటెకె మరేతీబి అగాఢివాలో హుయిరోస్కరి మే కినాలీన్ బోల్యొకి యోస్‍ ఆ. ");
INSERT INTO vgr_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","మే ఇన మాలంకర్యొకొయినీ పన్కి, యో ఇష్రాయేల్‍నా ప్రత్యక్చాహువనటేకె మే పాణిమా బాప్తిస్మమ్ దేతొహుయిన్‍ ఆయోకరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","బుజు యోహాన్‍ సాబుత్‍ బోల్తొహుయిన్‍ ఆకాష్‍మతూ ఆత్మ పర్యావ్‍నీతర ఉత్రీన్‍ ఆవను దేఖీన్; ఆత్మ ఇనాఉఫ్పర్‍ ఉబ్రూగు. ");
INSERT INTO vgr_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","మే ఇనా మాలంకర్యొకొయిని పన్కి, పాణిమా బాప్తీస్మం దేవనటెకె మన బోలీమోక్లోతే దేవ్‍ కినా ఉఫ్పర్‍ ఆత్మ వుత్రీన్‍ ఆవను దేకీస్కి యోస్‍ పరిసుద్ధాత్మమా బాప్తిస్మమ్‍ దేవ్వాలొకరీ మారేతి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","మే దేఖీన్‍ “ఆస్‍ దేవ్నొ ఛియ్యోకరి” సాబుత్నా బోలుకురుస్కరి బొల్యొ. ");
INSERT INTO vgr_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","బుజేక్‍ధన్నె అజు యోహాన్బి ఇనా సిష్యుల్మా బేజన ఉబ్రీన్‍ ర్హావమా, ");
INSERT INTO vgr_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","తెదె ఛాలుకరతే యేసు బణే దేఖీన్‍ హదేక్ దేవ్నో మ్హేండను చెల్కుకరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","యో బోల్యొతె వాతెవ్నా యో బేజణ సిష్యుల్‍ హాఃమ్జీన్‍ యేసునా కేడెగయా. ");
INSERT INTO vgr_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","తెదె యేసు పీటెఫరీన్‍ ఇవ్నే ఇన కేడెఆవను దేఖీన్‍ తుమే సాత్‍ ధూండుకరస్కరి ఇవ్నా పుఛ్చావమా ఇవ్నే రబ్బీ తూ కెజ్గా ర్హంకరస్కరి ఇనా పుఛ్చావమా. రబ్బీ కతో బోధకుడ్‍ కరి అర్థం. ");
INSERT INTO vgr_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","యేసు తెదె ఆయిన్‍ దేకో కరి యో ఇవ్నా బోలామ ఇవ్నే జైన్‍ యో ర్హయోతే జోగో దేఖ్య, తెదె బరోభర్ వ్హానె‍ ఛార్‍బజా హూయు. యో ధన్నే ఇనకన ర్హైయ్యా. ");
INSERT INTO vgr_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","యోహాను వాత్‍ హఃమ్జీన్‍ ఇనా పీటే గయాతే ఇవ్నమా ఏక్జననూ నామ్‍ సీమోన్‍ పేతుర్నో భైహుయోతే అంద్రెయా. ");
INSERT INTO vgr_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","ఇనే అగాడి ఇనొ భైహుయోతె సీమోన్‍నా దేఖీన్‍; హామే మేస్సీయాన మాలంకరిలిదా కరి ఇనేతి బోలిన్‍ ");
INSERT INTO vgr_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","యేసుకన ఇనా బులైలీన్ ఆయో. యేసు ఇనా బణే దేకిన్‍ తూ యోహాన్‍నో ఛియ్యో హుయోతే సీమోన్‍; తూ కేఫా కరీబోలైలీస్‍కరీ బోలస్‍ కేఫాకరీ వాత్‍న ఫత్రోకరీ అర్థం. ");
INSERT INTO vgr_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","బుజేక్‍ ధనే యేసు గలిలయమా జానుకరి ఫిలిప్పునా మాలంకరీన్‍ మారకెడె ఆవుకరీ ఇనేతి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","ఫిలిప్పు బేత్సయిదావాలు, కతో అంద్రెయ పేతుర్‍కరీ బోలవలాన ఖాయర్మా ర్హవ్వాలో. ");
INSERT INTO vgr_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","ఫిలిప్పు నతనయే‍ల్నా మాలంకరీన్‍ ధర్మషాస్త్రంమా మోషేప్‍బీ కినా బారెమా లిఖ్యుకి ప్రవక్తల్‍బి ఇన గురించి లీఖ్యా; యో నజరేయును గామ్నుహుయోతె యోషేప్‍నో ఛియ్యో యేసుకరి ఇనేతి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","ఇనటెకె నతనయేలు, “నజరేతుమాతీ అష్యల్‍ను కేహుబీ అవ్సేనాకరి” ఇన పుఛ్చావమా, ఆయిన్‍ దేక్కకరి ఫిలీఫ్పు ఇనేతి బోల్యొ, ");
INSERT INTO vgr_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","యేసు నతనయేలు ఇనకన అవను దేక్కీన్‍ “హదేక్‍ ఆ హాఃఛిమాస్ ఇస్రాయేల్‍వాలో ఇనామ కేహుబీ కపటం కొయినీ” కరి ఇనేతి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","తూ మన కిమ్‍ మాలంకర్యొ కరి నతనయేలు ఇన పుఛ్చావమా యేసు ఫిలీఫ్పు తునా బులావనా అగాఢీస్‍ తూ యో గుల్లర్‍నుఝాడ హేట్‍ థో తెదేస్‍ మే తున దేక్యోకరీ ఇనేతి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","నతనయేల్‍ “బోధకుడ్‍ తూ దేవ్‍నో ఛియ్యో ఇష్రాయేల్‍నో రాజో” కరి ఇన జవాబ్‍ బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","ఇనటెకె యేసు యో గుల్లర్ను ఝాడహేట్‍ తున మే దేక్యో కరి బోలామ తూ నమ్మూకరస్‍సూనా? అనేతీ గోప్ప కర్యాల్‍ దేకీస్‍ కరి ఇనేతి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","బుజు యేసు, “తుమే ఆకాష్‍ కోలైజావను, దేవ్నుదూతల్‍ అద్మినా ఛియ్యానా వుపర్తీ ఛడనూ, ఉత్రాను దేక్సూ” కరి తుమారేతి హాఃఛితీ బోలుకరూస్‍ కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","తీన్మను ధన్నె గలిలయమా ఛాతె కానాకరి హఃయర్మా ఏక్ య్హా హుయూ. ");
INSERT INTO vgr_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","యేసుని ఆయా ఎజ్గ ర్హైతి; బుజు యేసుబి ఇను సిష్యుల్‍బీ యో య్హాన బులాయ్‍ మంగాయు. ");
INSERT INTO vgr_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","ద్రాక్చాను రహ్క్ హుయ్గుతెదె యేసుని ఆయా ఇవ్నా ద్రాక్చాను రహ్క్ కొయినీకరి యేసుతి బోలమా! ");
INSERT INTO vgr_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","యేసు ఇనేతి ఆయా, మారేతి తున షాను కామ్‍? మారు వహాఃత్ బుజుబి కోఆయూనికరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","ఇని ఆయ ప్రచార్‍ కరవాలన దేఖిన్‍ యో తుమారేతి సాత్‍ బోలస్కి ఇనా కరోకరి బోలి. ");
INSERT INTO vgr_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","యూదుల్‍ సుద్ధికరణు ఆచారం ప్రకారంతి ఛారిఖ్‍ః న్హైతొ ఖోః లీటర్‍ ధహరను ఛో పత్రాను కొట్టియేవ్నా ఎజ్గా బేందిరాక్యుతు. ");
INSERT INTO vgr_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","యేసు యోబాణమా పాని భరీన్‍ మ్హేందోకరి ఇవ్నేతి బోలమా! ఇవ్నే ఇనా కనారితోడి భర్యు. ");
INSERT INTO vgr_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","తెదె యో ఇవ్నేతి తుమే హంకె కొట్టియేమాతు తోడు రహ్‍ భర్లీన్ ఖాణు కంకరతే ప్రధానికనా లీన్జవోకరి బోలమా! ఇవ్నేలీన్‍ గయ్యూ. ");
INSERT INTO vgr_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","యో ద్రాక్చను రహ్ కెజ్గాతూ ఆయూకి, కింమ్ బద్లూకి ప్రచార్‍ కరవాలన, యోపానీ బర్లిన్‍ లీగయుతె ఇవ్నస్‍ మాలం; పన్కి విందు ప్రధానినా మాలంకోతూని, అనటేకే ద్రాక్చాను రహ్ తోబీ యోపానినా చాఖీన్‍ దేక్యూతెదె, యోవిందు ప్రధాని నౌరోనా బులాయిన్‍ ");
INSERT INTO vgr_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","హర్యేక్‍ అద్మి అగాడి అషల్ ద్రాక్చాను రహ్ నాకీన్‍ జనాబో మాత్తుమా ర్హావనీవహఃత్‍ జబ్బును రహ్క్ నాఖస్‍; తూహుయోతో హంకెతోడీ అష్యల్ ద్రాక్చను రహ్క్ రాఖిలీన్‍ ఛా కరి ఇనేతి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","యేసు గలిలయామాఛాతె కానామ ఆ మోదుల్ను సూచక క్రియల్‍నా కరీన్‍ ఇను మహిమను బయాలు పరిచీలిదో; అనటెకె ఇను సిష్యుల్‍ ఇనాఫర్‍ వీస్వాసం రాఖ్యు. ");
INSERT INTO vgr_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","ఇనాపాస్సల్తీ యోబీ ఇని ఆయాబీ, భై బుజు సిష్యుల్‍ మలీన్‍ కపెర్నహూమ్‍‍మా ఖాయర్‍మా జైన్‍ ఎజ్గా థోడుధన్‍ ర్హయ్యు. ");
INSERT INTO vgr_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","తెదె యూదుల్ను పస్కాపండగా ఖందె ఆవమా, యేసు యెరూషలేమ్మా గయో. ");
INSERT INTO vgr_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","దేవ్ను ఆలయంమా ధాండొన, మ్హేంఢానా, పర్యావ్నా ఏచవాలనా పైషా బద్లావతే జోగమా ఇవ్నె బాల్లాపర్‍ బేసీన్‍రవ్వాను దేఖీన్‍ ");
INSERT INTO vgr_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","ఇనటెకె డోరితీ కోల్డాతికరీన్‍ మ్హేంఢావ్నా ధాండొనా హాఃర్వనా దేవ్ను మందిర్‍మాతూ హక్లిదీన్‍ పైషా బద్లావతే ఇవ్ను పైషావ్నా ఛిడ్కిదీన్‍ ఇవ్ను బాల్లల్నా ధక్లీనాకిదీన్‍; ");
INSERT INTO vgr_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","పర్యావ్నా ఏచాతే ఇవ్నేతీ ఆఖారు అజ్గాతులీన్‍ జావో! మారో “భాను ఘార్‍నా ధందోకరను బజార్నీతర నొకొ కరోకరి” గట్టింతి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","ఓ దేవ్‍ తారు ఘర్ను గూర్చి లేఖనాల్మా ఆహ్క్ మన హఃతావుసేకరి లిఖ్కాయ్‍ రూస్‍కరి ఇను సిష్యుల్‍ హఃయాల్ ‍కర్లీదు. ");
INSERT INTO vgr_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","అనటెకె యూదుల్‍ తూ కేహు హాక్కుతీ ఆ కార్యయాల్‍న కరుకరస్‍కీ హమ్నా కెహూ అద్బుతంనా కరిన్‍ వాతలిన్‍ బోలిస్‍ కరి ఇనా పుఛ్చాయ. ");
INSERT INTO vgr_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","యేసు, “ఆ దేవ్ను మందిర్‍నా ఫోడినాక్కో తీన్‍ ధన్‍మా ఇన బ్హాందీస్‍కి” ఇవ్నేతి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","యూదుల్‍ ఆ మందిర్‍నా ఛోప్పర్‍ చాలీక్‍ వరహ్ఃమా భాంద్యాని; తూ తీన్‍ధన్మా ఇన భాధిస్‍నా? కరి పుఛ్చాయా. ");
INSERT INTO vgr_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","హుయూతొ యో మందిర్‍నా గూర్చీ ఆ వాత్‍ బోల్యొకీ యో ఇను ఆంగ్‍తన్నుగుర్చీ బోల్యో. ");
INSERT INTO vgr_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","తెదె యో మరణ్మతూ ఉట్టాడెతే బాద్మా యో ఆవాతే బోల్యొకరి ఇను సిష్యుల్‍ ఖాయాల్‍ కర్లీన్‍ లేఖనాల్నాబి బుజు యేసు బోల్యొతె వాత్నా నమ్యా. ");
INSERT INTO vgr_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","యో పస్కా పండగాన వఖాత్‍ యేరుషలేమ్మా ర్హావమా; యో పండగామా కెత్రూకిజణు యో కర్యోతె అద్బుతల్నా దేఖీన్‍ ఇనపర్‍ వీష్వాస్‍ రాఖ్యూ. ");
INSERT INTO vgr_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","పన్కి యేసు ఖారవ్న మాలం కర్యోహొయో. అనటెకె యో ఇవ్నా సంపూర్ణంతి నమ్యకోయిని. ");
INSERT INTO vgr_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","యో అద్మీను దిల్మానాబి మాలం కరవాలో, అనటెకె కోన్బీ అద్మినా గూర్చి ఇనఫర్‍ సాబుత్‍ బొలాను జరూరత్‍కోయిని. ");
INSERT INTO vgr_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","యూదుల్ను అధికారిహుయోతె నీకొదెమ్కరి పరిసయ్యకుడ్‍ ఏక్జనొ థో. ");
INSERT INTO vgr_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","ఇనె ఏక్‍ రాత్ యేసుకనా ఆయిన్‍ బోధకుడ్, తూ దేవ్‍కంతొ ఆయోతె బోధకుడ్‍ కరి హమ్నామాలం; దేవ్ ‍ఇన జొడ్మా రయ్యోతోస్ తప్ప థూ కరుకరతె అద్భుతాల్నా కోన్బీ కర్చెకొయినీకరి ఇనేతి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","అనటెకె యేసు ఇవ్నేతీ బోల్యొ ఏక్జనో నవో పైదాహుయోతోస్‍ పన్కి ఇనే దేవ్ను రాజ్యంనా దేక్చేకొయినీకరి కరి తుమారితి హాఃఛితి బోలుకరుస్. ");
INSERT INTO vgr_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","అనటెకె నీకొదెమ్‍ బుడోహుయోతె అద్మికింమ్‍ పైయిదా హూసే? బెంమ్మను ఛోట్‍ ఆయాను పేట్మాపేషిన్‍ పైదాకర్నునా కరి ఇనా పుఛ్చావమా! ");
INSERT INTO vgr_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","యేసు అమ్ బోల్యొ ఏక్జనొ పానీనూ బారేమాతోబీ, ఆత్మానబారేమాతోబి, పైదాహుయోతో పన్కి, యో దేవ్నీ రాజ్మంమా జాసెకొయినీకరి తుమారేతి హాఃఛితి బోలుకరూస్‍ ");
INSERT INTO vgr_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","ఆంగ్తాన్‍ బారేమా పైదాహుయోతె ఆంగ్తాన్‍తీస్‍ ఆత్మను బారేమా పైదాహుయోతె ఆత్మాహుయిన్ ఛా! ");
INSERT INTO vgr_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","తుమే నవూ పైదాహూనుకరి మే తుమారేతి బోల్యొకరి, అష్యంనొకొహువో. ");
INSERT INTO vgr_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","వ్యారో ఇన ఇష్టంహుయుజొగొమా వాగస్‍; తూ ఇను ఆవాజ్ హఃజీస్‍ పన్కి, యో కెజ్గాతూ నికీన్‍ ఆవస్కి, కెజ్గాజాస్కి, తూన మాలంకొయినీ ఆత్మమూలంమా పైదాహుయోతె హర్యేక్‍జనూ ఇమ్మాస్‍ ఛా కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","అనటేకే నీకొదెమ్‍ ఆసంగతుల్‍ కింమ్‍ సాధ్యం కరి ఇనేతి పుఛ్చావమా! ");
INSERT INTO vgr_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","యేసు అమ్ బోల్యొ, తూ ఇష్రాయేల్‍నా బోధకుడ్‍ రహిన్బీ అన మాలంకరకొయిన్నా ");
INSERT INTO vgr_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","హుయ్తోబి హమే మాలంకర్యా సంగతుల్నా బోలుకరూస్‍ దేఖ్యతె ఇనస్ హాఃఛి బోలుకరూస్‍ హమారు హాఃచీన తుమే ఒప్చుకొయినీకరీ, తుమారేతి హాఃచీతి బోలుకరూస్‍ ");
INSERT INTO vgr_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","జమీన్‍ సంబంధహుయు సంగతుల్‍నా, మే తుమారేతీ బోల్యొతొ తెదె నమ్యకొయినీ, స్వర్గంను సంబంధంహుయు తుమారేతీ బోల్యొ తెదె కింమ్‍ నమ్సూ? ");
INSERT INTO vgr_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","బుజు స్వర్గంమతూ ఉత్రీన్‍ ఆయోహుయోస్‍ కతో స్వర్గంమా ఛాతె అద్మినఛియ్యోన తప్ప స్వర్గంమా చఢీన్‍గయోహుయో కోన్బీ కొయినీ. ");
INSERT INTO vgr_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","జాఢిమా మోషే హాఃప్‍నా కింమ్‍ పాడ్యోకి; ");
INSERT INTO vgr_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","ఇమ్మస్‍ విష్వాస్‍రాకవాలో హర్యేక్‍జనూ మట్సేకొయినీతిమ్‍ ఇను బరేమా నిత్యజీవంనా లేవకర్కూ అద్మినఛియ్యో ఉట్టాడనుఛా. ");
INSERT INTO vgr_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","దేవ్ ఆ ములక్నా కెత్రూకి ఫ్యార్‍కర్యో, ఇనటెకె యో ఇను ఏక్నాఏక్‍ ఛియ్యోని గోణి ప్హైయిదాహుయుతె ఇనపార్‍ విష్వాసం రఖావాలు హార్యేజను నాషనం నాహోనుకరి, ఇవ్నే నిత్యజీవుణు మల్ను కరి ఇనా అనుగ్రహించి రాక్యొస్‍ ");
INSERT INTO vgr_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","ములాక్నా రక్చణమాలనటేకె ఇన ఛియ్యాన బొలిమోక్లొ పన్కి, ములాక్నా షిక్చిచానటెకె దేవ్‍ ఇనా కొబోలిమోక్లొయిని. ");
INSERT INTO vgr_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","ఇనాపర్‍ వీష్వాసం రాహాఃవలాన న్యావ్‍ తీర్చేకొయిని; దేవ్ని ఏక్నా ఏక్ ఛియ్యాన, నామ్‍పర్‍ విష్వాసం రాక్యుకొయినితే, ఇవ్నా అన అగాఢీస్‍ న్యావ్‍ తీ ర్చిబడ్సే ");
INSERT INTO vgr_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","దేవ్‍ బోల్యొతే న్యావ్‍ ఆస్‍; ఉజాలు ములక్మా ఆయూ పన్కి ఇవ్ను కామ్‍ ఖారబ్‍ హువమా, అద్మియే ఉజాలనా ఫ్యార్‍కరకోయిన్తిం అంధరనాస్‍ ఫ్యార్‍కర్యు. ");
INSERT INTO vgr_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","గలత్‍ కామ్‍ కరతే హర్యేజను ఉజాలాన ద్వేసించుకరస్‍ ఇను క్రియల్‍ దుష్‍క్రియాల్‍ నితర దేఖావకోయినితిమ్‍ ఉజాలుకన ఆవకోయిని. ");
INSERT INTO vgr_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","పన్కీ హాఃఛివాలో హుయోతే ఇను క్రియల్ దేవ్నీ బరేమా కరిర్యాకొస్‍ కరి ప్రత్యక్చబడ్నుతీమ్‍ ఉజాలుకనా ఆవ్సే. ");
INSERT INTO vgr_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","ఇనపాస్సల్‍ యేసు ఇన సిష్యుల్‍తీ కెడే యూదయను దేఖ్‍మా ఆయిన్‍ ఎజ్గా ఇవ్నేతి థోడుధన్‍ ర్హాతు బాప్తిస్మమ్‍ దేతోహుయిన్‍ ర్హయో. ");
INSERT INTO vgr_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","సలీమ్నా ఖందెఛాతె ఐనోనుకరి జొగోమ పాణి భరైన్‍ థూ. అనహాఃజె యోహన్‍బి ఎజ్గా బాప్తిస్మమ్‍ దేతొహుయీన్‍ ర్హయ్యో, అద్మిఖారు ఆయిన్‍ బాప్తిస్మమ్‍ లీదు. ");
INSERT INTO vgr_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","యోహాన్న బుజుబీ ఠాణమా బంది కోకర్యుని. ఇన అగాడి జార్యగుతే సంగాతుల్‍ ");
INSERT INTO vgr_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","సుద్ధికరణ ఆచారంను గూర్చి యోహాన్‍ సిష్యుల్నా ఏక్‍ యూదుడ్‍తీ లఢైయి హుయు. ");
INSERT INTO vgr_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","అనహఃజే ఇవ్నే యోహన్‍కన ఆయిన్‍ బోధకుడ్‍ ఏక్జనో యొర్దాను నది పార్లీబాజు తారేతి ర్హాయోకి, తూ కిన బారెమా సాబుత్‍ బోల్యొతోకి హదేక్‍ యో బాప్తిస్మమ్‍ ద్యేకరస్‍ హాఃరు ఇనకన ఆంకరస్కరి ఇనేతి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","అనటేకె యోహాన్ అమ్‍ బోల్యొ, ఇన దేవ్‍ కంతు దేవాయిరాక్యుతోస్‍ పన్కి కోన్బీ సాత్‍బీ పోంద్సేకోయిని. ");
INSERT INTO vgr_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","మే క్రీస్తు కాహేకరీ, ఇనేతీబి అగాడి బోలిమోక్లోహుయోస్‍ కరి బొలాయుతిమ్‍ తుమేస్‍ మన జామిన్‍దారి. ");
INSERT INTO vgr_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","య్హాను నౌరిహో, య్హాను నౌరోహో హుయితో ఉబ్రీన్ యో య్హాను నౌరోను, ఆవజ్‍ ఖంజీన్‍ దోస్థ్ కెత్రూకి ఖూషిహుసేకి, ఇమ్మాస్ ఆ మారు ఖూసాల్‍ పరిపూర్ణంహుయిరుస్‍. ");
INSERT INTO vgr_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","యో హెచ్చిలిన్ రవ్వను ఛా; మే కామ్‍ కర్లేవాను ఛా. ");
INSERT INTO vgr_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","ఉప్పర్‍తో ఆవ్వలో హాఃర్వనా ఉపార్‍ రవ్వలో, జమీన్‍తూ నీకిన్‍ అవ్వలో జమీన్‍సంబంధి హుయిన్ ‍ఛా, జమీన్‍న చెందీహుయు సంగతుల్‍నా గుర్చి వాతె బోల్యొ, స్వర్గంతూ అవ్వలో హాఃర్వతీ ఉపార్‍ ర్హైన్‍ ");
INSERT INTO vgr_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","ఇనే దేఖ్యూతే ఇనా గుర్చి ఖాంజూతే ఇనగుర్చి ఖాబర్‍ బోల్సే పన్కి ఇనా బోదానా కోన్బీ ఇను సాబుత్నా ఓప్సేకోయినీ. ");
INSERT INTO vgr_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","ఇను హాఃఛినా ఓప్పవాలో దేవ్‍ హాఃచెలోకరి నిరూపించుకురాస్‍. ");
INSERT INTO vgr_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","కింకతో దేవ్‍ యో మోక్లొతె ఇనా కొలతకోయినీతిమ్‍ పవిత్రా ఆత్మనా దిసే అనటెకె యో దేవ్ని వాతెనాస్‍ బోల్సే. ");
INSERT INTO vgr_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","భా ఛియ్యోనా ఫ్యార్‍కరుకరాస్‍ ఇనాఖాజే ఇనా హాత్మా సమస్తమ్‍ దేవాయిర్హాకోస్‍ ");
INSERT INTO vgr_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","ఛియ్యోనా ఖామే విష్వాస్‍ కరవాలోస్‍ నిత్యంజీవమ్‍ రవ్వలొ; ఛియ్యోను విధేయుడ్ తార రవ్వకోయింతెవాలొ జీవమ్‍ దేక్చెకొయిని పన్కి, దేవ్ను ఛండాల్‍ ఇనఫర్‍ వుబ్రీన్‍రాసే. ");
INSERT INTO vgr_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","యోహాన్‍తీబి యేసు ఘాణు అద్మియేనా సిష్యుల్‍నీతర కర్లీన్‍ ఇవ్నా బాప్తిస్మమ్‍ దేవుంకరతె సంగతి పరిసయ్యుల్‍ మాలంహుయుతెదె. ");
INSERT INTO vgr_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","హుయుతోబి యేసు బాప్తిస్మమ్ కోదిదోని పన్కి ఇన సిష్యుల్‍ దేవుంకర్తూ థూ. ");
INSERT INTO vgr_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","ఇజ్గా ఇవ్నేవాతె బోల్యొతె యేసు హఃజీన్‍ యూదయా దేహ్కానా బెందీన్‍ గలిలయ దేహ్ఃమా ఫరీన్‍ గయో. ");
INSERT INTO vgr_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","యో సమరయా హఃయర్‍ మారగ్‍పర్తూ జానుపడ్యు. ");
INSERT INTO vgr_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","ఇనటేకె యాకోబ్‍ ఇనో ఛియ్యోహుయోతె యోషేపునాదదోతె జమీన్‍ ఖందెఛ్చాతె సమరయ దేహ్ః సుఖారుకరీ గాంమా ఆయ. ");
INSERT INTO vgr_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","ఎజ్గా యాకోబ్ను బావ్డి థూ; ఇనటేకె యేసు ప్రయాణమ్ కరిన్ థాకీజావమా యో బావ్డీకన బేసీన్‍థో తెదె బరోబ్బర్‍ భారబజీరా థూ. ");
INSERT INTO vgr_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","తెదె సమరయా హుయితె ఏక్‍ బాయికో ఏక్జని పాణి సెందిలేవనటేకె ఎజ్గా ఆయి. యేసు బోల్యొ, “మన తర‍హ్ః లాగుకరస్‍ పీయానా పాణి దా! కరి యోబాయికోన పుఛ్చాయో” ");
INSERT INTO vgr_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","ఇన‍ సిష్యుల్‍ ఖాణు మోల్‍లావనటేకె హాఃయర్‍మా జైన్‍ థా. ");
INSERT INTO vgr_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","యో సమరయా బాయికో, యూదుడ్‍ హుయోతె తూ సమరయాహుయితె బాయికో మన పాణి దా! కరి కిమ్‍ పుఛ్చాంకరస్‍కరి ఇనేతి బోలి. కిమ్కతో యూదుల్‍ సమరయుల్తీ కెజాత్నూబి సంబంధం కోకరని. ");
INSERT INTO vgr_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","అనటెకె యేసు బోల్యొ, తూ దేవ్ను వరంనా, “మన తరాహ్ః తోడ్‍కరీ మాంగుకరతె యోకోన్కి యోబి తున మాలంర్హైయితొ తూ ఇనా పుఛ్చాయిస్, యో తున జీవజల్‍ దిసేకరీ” యో బాయికోతి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","తెదె యో బాయికో మాలిక్‍ ఆ బావ్డీ జాహఃత్‍ లోత్మా ఛా సెందీలేవనటెకె తారకనా కాయిబీకోయిన్నీ; యో జీవజాలం కిమ్‍ తునా మల్సే? ");
INSERT INTO vgr_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","హమారొ జమాననూ భానొ భాహుయోతే యాకోబ్‍ ఇనా లడ్కావ్నా, ధండా బుజు బోక్డానా మందోనబి, ఆ బావ్డీను పాణి పీన్‍ హమ్నాదిదో. ఇనేతీబి తూ గొప్పవాలోసూ? కరి ఇనా పుఛ్చాయి. ");
INSERT INTO vgr_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","ఇనటెకె యేసు బోల్యొ, ఆ పాని పీయవాలు హర్యేక్‍జణు బుజేక్‍తార తారఖ్‍ః లాగ్సే. ");
INSERT INTO vgr_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","పన్కి “మే దిదోతె పాణి పియవాలు ఇనకెదేబి తరహ్ః లాగ్సేకొయిని. మే ఇన దేవుంతెపాణి నిత్య జీవంనటేకెస్‍ నిత్యం ఇన్మాపొంగీ పాణిను బుగ్గనితరా ర్హాసేకరి” యో బాయికోతి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","యో బాయికో ఇనా దేఖీన్‍ “మాలిక్ మన తరహ్ః నాలాగ హఃర్కు సెందానటేకె అత్రుదూర్‍ నాఆవునుతీమ్‍ యోపాని మన దయాకర్కరీ” పుఛ్చాయి. ");
INSERT INTO vgr_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","తెదె యేసు, “తూ జైన్‍ తార బావ్రినా బులైలీన్‍ అజ్గ పాచు ఆవ్కరీ” యో బాయికోతి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","యో బాయికో, “మన బావ్రీ కోయిని కరి బోలమా” యేసు యో బాయికోతి, బావ్రీ కొయినికరి బోలితె వాత్‍తో హాఃఛీస్‍; ");
INSERT INTO vgr_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","తునా పాచ్‍జన బావ్రీ థా, హంకే ఛాతే యో తారో భావ్రి కాహే “తూ ఆ ఖబర్‍ హాఃఛితీ బోల్యొకరి బోల్యొ” ");
INSERT INTO vgr_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","తెదె యో బాయికో, మాలిక్‍ తూ ప్రవక్తకరి మే గ్రహీంచుకరూస్‍ ");
INSERT INTO vgr_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","హమరా పుర్వికుల్‍ ఆ పహాడ్‍నా ఆరాధించా పన్కి, ఆరాధనకరను జొగొ యేరుషలేంమా ఛాకరీ, తూమే బోలుసుకరి ఇనేతి కాతో యేసు బాయికోతి బోలమా. ");
INSERT INTO vgr_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","యేసు యో బాయికోతి అమ్‍ బోల్యొ ఆయా! ఏక్ వఖాత్‍ ఆవుంకరస్‍ యోధన్మా ఆ పహాడ్నావుపర్‍హో, యెరుషలేమ్‍మాహో తుమే భాన కోఆరాధించుని మారు వాత్నా నమ్‍ ");
INSERT INTO vgr_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","సమరయుల్‍ హుయితె తుమే మాలంకోయింతె ఇనా ఆరాధించావాల; యూదుల్‍ హుయుతే హామేకోన్కి మాలంహుయూ ఆరాధించియేస్‍; బఛ్చాడను యూదుల్‍మాతూస్‍ కలుగుకరస్‍. ");
INSERT INTO vgr_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","అజు యధార్థంతీ ఆరాధించవాల దేవ్ను ఆత్మతీబి హాఃఛితీబి భాన ఆరాధనకరను ధన్‍ ఆవుంకరస్‍; యో హంకేబి ఆయ్రూస్‍ ఇన ఆరాధించవాలు ఎజాత్నుస్‍ హోనుకరీ భా కొరిలెంకొరాస్‍. ");
INSERT INTO vgr_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","దేవ్‍ ఆత్మ హుయ్రోస్‍ అనటేకె ఇనా ఆరాధించవాల ఆత్మతీబి హాఃఛితీబి ఆరాధన కర్నూకరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","తెదె యో బాయికొ ఇనేతి, క్రీస్తు బోలావతే మేస్సియ ఆవుంకరస్ కరి మన మాలం, యో ఆయోతెదె హమ్నా సమస్తంనా మాలంకరావ్సే కరి బోలి. ");
INSERT INTO vgr_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","తెదే యేసు, “తారేతీ వాతే బోలుకరతే మేస్‍ యోకరీ” బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","ఎత్రాస్‍మా ఇనా సిష్యుల్‍ ఆయిన్‍ యేసు యో బాయికోతి వాతెబోలాను దేఖీన్, హాష్యంహుయిగు పన్కి, తునా సాత్‍హోనుకతోబి, ఆ బాయికోతీ షాన వాతేబోలుకరస్‍కరీ కోన్బి కోపుచ్ఛాయుని. ");
INSERT INTO vgr_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","యో బాయికో ఇను కుండు బేందీన్‍ గమ్మా జైన్‍ యో పట్టానంవాలతీ బోలి. ");
INSERT INTO vgr_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","తుమే ఆయిన్‍ మే కర్యుతే హాఃరుబీ మరేతి బోలుతే అద్మినా దేఖో; యో మెస్సీయా కాహేనా ");
INSERT INTO vgr_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","ఇవ్నే పట్టనం మాతు నిఖీన్‍ యేసుకన గయూ. ");
INSERT INTO vgr_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","తెప్తోడి సిష్యుల్‍ బోధకుడ్‍ దాన్‍ ఖాకరి ఇనా బాతిమాలీదా. ");
INSERT INTO vgr_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","ఇనటెకె యేసు, ఖావనటెకె తుమ్నా మాలంకోయినీతె ఆహారం మరకన ఛా, కరి ఇవ్నేతి బోలమా. ");
INSERT INTO vgr_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","తెదే సిష్యుల్‍ ఇన ఖావనటెకె కోన్బి సాత్బి లాయుసుకి? కరి ఏక్నుఏక్‍ బొల్లిదూ. ");
INSERT INTO vgr_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","యేసు ఇవ్నా దేఖీన్‍ మన బోలిమోక్లోతె ఇనే చిత్తననెరవేర్చాను, ఇను కామ్‍ పూర్తికరనూస్‍ మారు ఆహరం హుయిన్‍ ఛా. ");
INSERT INTO vgr_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","బుజు ఛార్ మహీనా హుయిజావదీన్ ఇనపాసల్‍ వాడనుధన్‍ ఆవ్సేకరి తుమే బోల్సుకొయిన్నా! హదేక్‍ తుమార ఢోలపాఢీన్‍ ఖేతర్నా దేకొ; యో హంకేస్ పిఖీన్‍ వాడన ఆయ్రూస్‍ కరి తుమారేతి బోలుకరూస్‍ ");
INSERT INTO vgr_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","పిఖావాలుబీ వాఢవలుబీ ఖూషీహుయితిమ్‍ వాఢవలు జీతంకమైయిన్‍ నిత్యజీవార్థంను ఫలమ్‍ జమకర్లేంకరస్‍ ");
INSERT INTO vgr_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","బింజోళా నాఖవాలు ఏక్జను, వాఢవాలుబీ ఏక్జను ఆ వాత్‍ హాఃఛిస్‍ ");
INSERT INTO vgr_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","తుమే కినాలీన్‍ మినాత్‍ కోకరనీకి ఇన వాఢనటెకె తుమ్న బోలిమోక్లో థో, పార్లూ మినాత్‍పడ్యుతే తుమే ఇవ్నీ మినాత్‍ను ఫలంనా భాగ్‍ హువుంకరస్ కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","“మే కర్యోతె ఖారుబీ మారేఖు బోల్యొకరి” సాబుత్‍దిదితే యో బాయికోను వాతేనా లీన్‍ యో పట్టనంమను సమరయుల్‍ ఘాణుజనూ ఇనఫర్‍ వీస్వాసం రాఖ్యూ. ");
INSERT INTO vgr_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","యో సమరయుల్‍ ఇనకన ఆయిన్‍ ఇవ్నాకన ర్హాకరి ఇన బతీమాల్లీదా ఇనటెకె యో ఎజ్గా బే ధన్‍ ర్హాయో. ");
INSERT INTO vgr_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","ఇను వాతేవ్నా హఃజమా బుజుబి కెత్రుక్‍జణు నమ్యా, ");
INSERT INTO vgr_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","యో బాయికోనా దేఖిన్‍ హంకేతు ధరీన్‍ థూబోల్యోతె వాతేనా కాహేతిమ్‍ హామరు వాతేన హామే ఖంజీన్‍ ఆ హాఃఛిస్‍ ఆస్‍ ములక్‍నా బచ్చవాలో కరి మాలంకరీన్‍ నమ్ముకరేస్‍ కరి బోల్యా. ");
INSERT INTO vgr_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","యో బే ధన్‍ హువ్వది ఇన పాస్సల్‍ యో ఎజ్గాతూ నీకీన్‍ గలిలయమా గయో. ");
INSERT INTO vgr_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","సానకతో ప్రవక్త ఇను హుఃద్ను గమ్మా ఘనత పొంద్చేకోయినికరి యేసు సాబుత్‍నా బోల్యొ ");
INSERT INTO vgr_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","గలిలయావాలుబీ యో పస్కాను పండగాన జవ్వాలు, ఇనటెకె యేరూషలేమా పండగను వఖాత్‍ యో కర్యోతే కార్యల్‍ ఖారు ఇవ్నే దేక్యాకరి యో గలిలయమా ఆయోతెదె ఇవ్నే ఇనా బులైలీగయు. ");
INSERT INTO vgr_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","యేసు పానినా ద్రాక్చానురహ్ః గోణికర్యోతే గలిలయమా కానాను దేహ్కామా యో పరీన్‍ ఆయోతెదె కపెర్నహూమ్మా ఏక్‍ మోట్టొ మాలిక్నో ఛియ్యో రోగ్‍వాలో హుయిన్‍ థో. ");
INSERT INTO vgr_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","యేసు యూదయతునీకీన్‍ గలిలయమా ఆయోకరీ యో హాఃజీన్‍ ఇనకన జైన్‍ ఇనో ఛియ్యో మరాన్‍నీ సిత్ధిమ రవ్వమా ఇనటెకె యో ఆయిన్‍ ఛిమిన్‍ ఇన స్వస్థకరును కరి బాతిమాలీదో. ");
INSERT INTO vgr_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","యేసు సుచాక క్రియాల్‍నా మహత్కర్యాల్‍నా నాదేక్యాతో తుమారమా ఏక్జనుబి నంసుకోయినికరి ఇనేతి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","అనహఃజే యో మోట్టొ మాలీక్‍ ఖాయాబ్‍ మారో ఛియ్యో మర్జావనా అగాఢీస్‍ ఆవ్కరీ బతిమాల్యో. ");
INSERT INTO vgr_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","యేసు బోల్యొ, థూ “జా; తారొ ఛియ్యో జీవీన్‍ ఛాకరి” ఇనేతి బోలమా యోఅద్మి ఇనే బోల్యొతె వాత్నా ఖాంజీన్ నమ్మీన్‍ చలీగయో. ");
INSERT INTO vgr_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","యో బుజు జంకరమా ఇనో కామ్కరవాలు ఇన ఖామే ఆయిన్‍ ఇను ఛియ్యో జివీన్‍ఛాకరి మాలంకరాయో. ");
INSERT INTO vgr_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","కెత్రా బాజేన ఇన అషల్ హుసేకరి ఇవ్నా పుఛ్చాయోతెదె, ఇవ్నేకాల్‍ ధోపారే ఏక్ బజాన రోగ్‍ ఇన బేందిదూకరి ఇనేతి బోల్యా. ");
INSERT INTO vgr_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","“తారో ఛియ్యో జివీన్‍‍ఛాకరి” యేసు ఇనేతి బోల్యోతె వఖాత్‍ యోస్కరి భా మాలంకరీలీదొ అనటెకె యోబీ ఇను ఘర్మను ఖారు నమ్యా. ");
INSERT INTO vgr_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","యేసు యూదయతు నీకీన్‍ గలిలయమా ఆయిన్‍ కర్యోతె ఆ బెంమ్మాను సూచాక క్రియల్‍. ");
INSERT INTO vgr_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","ఇనుపాసల్‍ యూదుల్ను పండగ ఏక్ ఆవామ, ఇనఖాజే యేసు యెరూషలేమ్‍ గయో. ");
INSERT INTO vgr_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","యెరూషలేమ్‍మా మ్హేండనా ధర్వాజునకన హాఃమె హెబ్రిభాషమ బెతెస్థకరి బోలాతే ఏక్ కోనేర్ రవ్వమా ఇన పాచ్‍మంటపాల్‍ ఛా. ");
INSERT INTO vgr_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","4","త్యొ, వఖాత్మా దేవ్నుదూత కోనేర్‍మా వుత్రీన్‍ పాణినా హలావ్తూ థూ! పాణినా హళనా పాసల్‍ అగాడి కోన్‍ పాణిమా ఉత్రస్కి యో కెజాత్నూ రొగాఢివాలోబీ అషల్ హువ్వస్‍ ఇనటెకె మండపాల్‍మా రోగ్‍వాలా, కాణువాలు, లంగ్డొవాలు హాత్‍పడిగ్యుతె అద్మి, గల్లొనితర రవ్వానూ దేక్యొ. ");
INSERT INTO vgr_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","ఎజ్గా ఆట్‍వుప్పర్‍ డోఢిహ్క్ వరహ్క్ తూ ఏక్ రొగాఢి అద్మి ర్హాతుథూ. ");
INSERT INTO vgr_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","యేసు ఇన పఢిరవ్వాను దేఖిన్‍ యోతెప్తు కెత్రూకి ధన్‍తూ ఇంమ్‍ ర్హవ్వాను యో జోగొమా ఛాకరి సోచిలీన్‍ అష్యల్‍హోనుకరి సోచుకరస్‍న్నాకరి ఇన పుఛ్చావమా! ");
INSERT INTO vgr_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","యో రోగ్వాలు ఓ మాలిక్‍ పాణి హలుతెదె మన కోనేర్మా ఉత్రావనాటేకె కోన్బీకొయినీ అనటేకే మే ఆవతోడి ఎత్రమాస్‍ బుజేక్జనో మారెతీబీ అగాడి ఉత్రుకరస్కరి ఇనేతి జవాబ్‍దిదో. ");
INSERT INTO vgr_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","యేసు బోల్యొథూ ఉట్టీన్‍ తారు బిఛ్చావును పల్లిన్‍ జా కరి ఇనేతి బోలమా! ");
INSERT INTO vgr_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","తెదేస్‍ యో అష్యల్‍హుయిన్‍ ఇను బిఛ్చావును పల్లీన్‍‍ ఛాలనిక్యొ యోధన్‍ ఆరామ్నుధన్‍ ");
INSERT INTO vgr_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","ఇనటెకె యూదుల్ ఆ ఆరామ్నుధన్‍ కాహేనా తూ బిచ్ఛావును పల్లీన్‍ ఛాల్కరి హుసేకొయిన్నీకరి అష్యల్‍హుయోతె ఇనేతి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","ఇనటెకె మన నయంకర్యోతే యో తారు బిఛ్చాను పల్లీన్‍‍ ఛాల్కరి మారేతి బోల్యొకరి బోలాస్‍. ");
INSERT INTO vgr_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","ఇవ్నేతారు బిఛ్చావును పల్లీన్‍‍ ఛాల్కరి తున బోల్యొతె యో కోన్‍? కరి ఇన పుఛ్చాయా! ");
INSERT INTO vgr_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","యో కోన్కి నయంకరిహుయు ఇనా మాలంకొయినీ; యోజొగొమా గల్లొభరాయిన్‍ ర్హావ్వమా! ఇనటెకె యేసు చుక్కయిలీన్‍ నికిగో. ");
INSERT INTO vgr_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","ఇనపాసల్‍ మందిరంమా యేసున దేఖిన్‍ హదేక్‍ నయంహుయో కరి; బుజు “జాహఃత్‍ కీడుతున నాలాగ్నూతింమ్ హంకెతు పాప్‍ నొకొకర్కరి” బోలమా! ");
INSERT INTO vgr_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","యోజైన్‍ మన నయంకరోహో యేసుకరి యూదుల్‍ అధికారితి మాలంకరాయో. ");
INSERT INTO vgr_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","ఇనటేకె ఆకార్యల్‍నా ఆరామ్‍ధన్నె కర్యోకరి యూదుల్‍ అధికారి యేసునా హాఃథాయా! ");
INSERT INTO vgr_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","హుయుతో యేసు, “మారో భా హంకెతోడి కామ్‍కరూకరస్‍ మేబీ కరుకరూస్కురి” ఇవ్నేతి జవాబ్‍దిదో. ");
INSERT INTO vgr_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","యోధన్ ఆరామ్నుధన్‍ ఆచారంనాబీ మీరిన్‍ కాహేతీమ్‍ దేవ్‍ ఇను అస్లీ భాకరి బొల్లీన్‍ ఇనుయోస్‍ దేవ్తి సమాన్‍కరి కర్లిదో అనటెకె ఇనునిమిత్తమ్‍ యూదుల్‍ ఇనా మర్రాక్నుకరి బుజుజాఖాత్ కోషిస్‍కర్యు. ");
INSERT INTO vgr_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","ఇనటెకె యేసునే ఇవ్నేతీ అంమ్‍నితర ఫరాయిన్‍బొల్యొ. భాకెహూ కరను ఛియ్యో దేఖ్‍స్కి యోస్‍పన్కి ఇనుయోస్‍ కెహూబీ కరకొయినీ; యో కెహూ కరస్కి, ఇనా ఛియ్యోబి ఇమ్మాస్‍ కర్సే. ");
INSERT INTO vgr_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","భా ఛియ్యోనా లాఢ్‍కర్తొహుయిన్‍ యో కరుకరతె ఖారు ఇన దెఖావుంకరస్కరి తుమారేతి హాఃఛితి బోలుకరుస్‍ బుజు తుమే అష్యంహువతిమ్ అనేత్తీబి మోట్టో కార్యయల్న ఇన దె‍ఖాడ్‍సె ");
INSERT INTO vgr_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","భా మరిగయోనా కింమ్‍ జీవాడీన్‍ ఉట్టాడస్కీ, ఇమ్మాస్‍ ఛియ్యోబీ ఇన ఇష్టంహుయుతే ఇవ్నా జీవాడ్సె. ");
INSERT INTO vgr_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","భా కినాబి న్యావ్‍ తీర్చాకోయినీ పన్కి, భాన ఘనపరచనీతర హాఃరుబీ ఛియ్యానబి ఘనపరచుని కరి న్యావ్‍ తీర్చాన సర్వహకుబీ ఛియ్యానస్‍ దేవ్వాయిరాక్యోస్‍ ");
INSERT INTO vgr_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","ఛియ్యో నాఘనపరచాకోయినితే ఇవ్నే ఇన మోక్లోతే భానబీ ఘనపరచాకోయిని. ");
INSERT INTO vgr_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","దేవ్నిఛియ్యాను వాత్‍ హఃమ్జీన్‍ మన మోక్లోతే ఇనఫర్‍ విష్వాస్‍ రాఖవాలో నిత్యజీవంమా రవ్వాలో; యో న్యావ్‍మా అవకోయినీతీమ్ మరణ్‍మతో నిఖీన్‍ జీవంబణే దాటిన్‍ ఛాకరీ తుమారేతి హాఃఛితి బోలుకురుస్‍ ");
INSERT INTO vgr_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","మరిగుహుయు దేవ్ని ఛియ్యాను ఆవాజ్‍ ఖాంజను వఖాత్‍ ఆవుంకరస్‍ హాంకేస్‍ ఆయ్రూస్‍; ఇనా ఖంజవాలు జీవ్సెకరి తుమారేతి హాఃఛితిస్‍ బోలుకరూస్‍ ");
INSERT INTO vgr_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","భా కిమ్‍ ఇనుగోణి యోస్‍ జాన్‍వాలోహుయిన్ ఛాకీ ఇమ్మాస్‍ ఛీయ్యోనాబీ ఇనుయోస్‍ జాన్‍వాలోహుయిన్‍ రవ్వనాటెకె ఛియ్యోనాబీ హక్కు దేవ్వాయ్‍రుస్‍ ");
INSERT INTO vgr_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","బుజు యో అద్మినఛియ్యోనా హువమా న్యావ్‍ తీర్చానటేకే అధికార్నా దీరాక్యోస్‍ ");
INSERT INTO vgr_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","అనహఃజే అష్యం నొకొహువో, ఏక్ ధన్ ఆవుంకరస్‍; యో ధన్మా గోరఢమా ఛాతె ఇవ్నేఖారుబి ఇను ఆవాజ్‍ ఖాంజ్చె. ");
INSERT INTO vgr_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","అష్యల్ కర్యుహూయు జీవిన్‍ పునారుత్థానమా, కిడూ కర్యుహూయు న్యావ్‍ పునరుత్థనంమాతూ భాధర్‍ ఆవ్సే. ");
INSERT INTO vgr_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","మారు మేస్ సాత్బి కోకరిస్‍ని మే హఃమ్జొతిమ్‍ న్యావ్‍న తీర్చుకరూస్ మన మోక్లోతె ఇని చిత్తప్రకారమాస్‍ కరనసోఛీస్‍ పన్కి మారు ఇష్టప్రకరామ్‍ కరీస్‍కోయిని, అనటేకె మారు న్యావ్‍ న్యాయం హుయ్రూస్‍ ");
INSERT INTO vgr_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","మార బారెమా మేస్‍ సాబుత్‍ బొల్లీదోతొ, మారు సాబుత్‍ హాఃఛికాహే ");
INSERT INTO vgr_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","పన్కి మారుబారెమా సాబుత్‍ బోలవాలో బుజేక్జనో ఛా! యో మారగూర్చి దిసేతే సాబుత్‍ హాఃఛికరి మే మాలంకరీలిస్‍ ");
INSERT INTO vgr_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","తుమే యోహాన్‍కన థోడుజణనా మోక్లోథా; యో హాఃఛినగూర్చీ సాబుత్‍దిదొ. ");
INSERT INTO vgr_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","మే అద్మినాకంతూ ఆయుతే జామీన్‍న ఒప్పీస్‍కొయిని పన్కి, తుమే బచ్చీజానుకరీ ఆ వాతె బోలుకురూస్. ");
INSERT INTO vgr_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","యోహాన్‍ బొల్తోహుయిన్‍ ప్రకాసించుకరతే దివ్వొహుయిన్‍ ర్హాసే, తుమే ఇను ఉజాలుమా ర్హైన్‍ థోడుధన్ ఖుషాల్తి ర్హావనటెకె ఇష్టంహుయాథా. ");
INSERT INTO vgr_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","పన్కి యోహాన్‍ మారటెకె దిదొతె సాబుత్‍తీబి అజు జాఖాత్‍ హాఃఛ్చిను గొప్పసాబుత్‍ మారకనా ఛా; యోసాత్‍కతో, మే నేరవెర్చానటెకె భా కేహూక్రియాల్‍న మన దీరక్యోస్‍కీ, మే కరుకరతే యోస్‍ క్రియల్‍ భా మన బోలిమోక్లీరక్యోస్‍ ఆ క్రియల్‍ మనగూర్చిన్‍ జామీన్‍ దెంకరాస్‍ ");
INSERT INTO vgr_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","బుజు మనమోక్లోతే భాస్‍ మన గూర్చీన్ సాబుత్‍దెంకరాస్‍ తుమే కెహుధన్మాబీ, ఇను అవాజ్నా ఖాంజ్యాకొయినిఇన స్వరుపంనా దేక్యాకోయిని. ");
INSERT INTO vgr_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","అజు యో కినా బోలిమొక్లొకి ఇన తుమే నమ్మకోయిని, అనటెకె తుమారు దిల్మా ఇను వఛన్‍ వుబ్రీ ర్హయుకొయిని. ");
INSERT INTO vgr_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","లేఖనాల్‍మా తుమ్న నిత్యజివంను ఛాకరీ సోచీలేతుహుయిన్‍ ఇనాస్‍ పరిషోధంచుకరస్‍ యోస్ మన గూర్చిన్‍ సాబుత్‍ దేవుంకరస్‍ ");
INSERT INTO vgr_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","హుయ్తోబి తుమ్న జాన్‍హోనుతిమ్‍ తుమే మారకన ఆవాకోయిని. ");
INSERT INTO vgr_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","మే అద్మీయేనుబారెమా మహిమనా ఆసించవాలొకాహే. ");
INSERT INTO vgr_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","పన్కి తుమారు దిల్ కెజాత్నూకి మన మాలంకర్లిదో; దేవ్నీ ఫ్యార్‍ తుమారమ కొయినీ. ");
INSERT INTO vgr_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","మే మార భాను నామ్తీ‍ ఆయ్రోస్‍; పన్కి తుమే మన అంగీకరీంచా కొయినీ, బుజేక్జనో ఇను నామ్పర్‍ ఆయోతొతెదె ఇన అగీకరించుకరస్‍; ");
INSERT INTO vgr_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","ఏక్నాఏక్‍ దేవ్నఖాజె ఆవతే మెప్పున కోరకొయినీ తింమ్‍ ఏక్ను మహిమన పొందుకరతె తుమే కింమ్‍ నమ్ఛు? ");
INSERT INTO vgr_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","మే భా కన తుమారప్పర్‍ నేరంనా మోపిదీస్కరీ నొకొసోచొ; తుమే ఆహ్‍ఃకరతే మోషే తుమారప్పర్‍ నేరంన మోప్సే. ");
INSERT INTO vgr_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","తెదె యో మన గూర్చిన్‍ లిఖ్యో అనటెకె తుమే మోషేనా నమ్యాహూయ్తొ మనాబీ నమ్చూ. ");
INSERT INTO vgr_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","తుమే ఇను లేఖనల్నా నానమ్యతో తెదె మారు వాతె కింమ్‍ నమ్చుకరీ బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","ఇనపాసల్‍ యేసు తిబెరియ నాహితో గలిలయ ధర్యావ్నా దాటీన్‍ పార్లిబాజు ఠగర్ఫర్‍ గయో. ");
INSERT INTO vgr_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","రోగ్వాలను బారెమా యో కర్యోతె సూచక క్రియల్‍నా దేఖీన్‍ కెత్రూకిజనూ ఇనకెడె గయూ. ");
INSERT INTO vgr_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","యేసు ఫాడ్‍చఢీన్‍ ఎజ్గా ఇను సిష్యుల్తీ బేసీన్‍ రయ్యో. ");
INSERT INTO vgr_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","తెదె యూదుల్ను పస్కాకరి పండగా ఖాందె ఆవమా. ");
INSERT INTO vgr_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","అనహాఃజె యేసు ఢోలాపాడిన్ కేత్రుకిజను ఇనకన ఆవాను దేఖీన్‍ ఇవ్నా ఖావనటెకె కెజ్గాతూ రోటామోల్లీన్‍ మాంగాయిస్‍ కరి ఫిలిఫ్పున పుఛ్చాయో! పన్కి, ");
INSERT INTO vgr_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","యేసునె సాత్‍ కరజాసేకి యోస్‍ మాలంకరిన్‍ ఇన పరీక్చాకరనటెకె ఇమ్‍ పుఛ్చాయో. ");
INSERT INTO vgr_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","అనటెకె ఫిలిఫ్పు, ఇవ్నామా హార్యేక్‍జనునా దధ్రాసు రోటా లేవ్వానటేకెబి బేఖో, దేనారంన రోటా పూర్సేకొయిని కరి ఇనేతి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","యేసున సిష్యుల్మా‍ ఏక్జనొ, కతో సీమోన్‍ పేతుర్‍నో భై హుయోతె అంద్రెయ; ");
INSERT INTO vgr_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“అజ్గ ఛాతే ఏక్ న్హాన ఛొగ్రకనా పాచ్‍ రోటా బే మాస్ల ఛాకరీ పన్కి, అత్రా అద్మియేనా పూర్సేకొయిని ఇనేతి బోలమా” ");
INSERT INTO vgr_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","యేసునే అద్మీ హాఃర్వనా బేఖాడోకరీ బోల్యొ. యో జోగోమా ఘాను గాఖ్‍ రవమా, ఇనటెకె గణ్యతొ కంసేకమ్‍ పాచ్‍హాజార్‍ మరద్మాన బేట్యు. ");
INSERT INTO vgr_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","యేసు యో రోటనాపన్‍ పల్లీన్‍ కృతజ్ఞాతా స్తుతుల్‍కరీన్‍ బేట్యుతే హాఃరజావ్నానా వడ్డించ్యు. ఇమ్మాస్ మాస్లాబీ ఇవ్నా ఇష్టంహుయు ఎత్రు వడ్డించ్యు. ");
INSERT INTO vgr_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","ఇవ్నే ధండారుభరీన్‍ ఖైన్‍ పాసల్‍ కాయిబి నష్టంకోయినితిమ్‍ మిగ్లుతె టుక్డాన హొఃతొకరి ఇను సిష్యుల్‍తీ బోల్యొ ");
INSERT INTO vgr_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","ఇనాటెకె ఇవ్నే ఖావమ్మా ఇనపాసల్తి ఇవ్నాకన పాచ్‍ రోటాను టుక్డాన జమాకరీన్‍ భార టోక్రా భర్యూ. ");
INSERT INTO vgr_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","యో అద్మీయే యేసు కర్యోతే అద్బుత క్రియాల్‍న దేఖీన్‍ హాఃఛితీస్‍ ఆ ములక్‍మా ఆవుంకరతే ప్రవక్త ఆస్కరీ బోల్లీదు. ");
INSERT INTO vgr_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","అనటేకే రాజో కర్నూకరి ఇవ్నే ఆయిన్‍ ఇన జభర్‍దస్తీఖూ ధర్లీజావనా వలావస్‍కరీ యేసు సోచీన్‍ బుజు పహాడ్‍కనా ఎకేలొస్‍ గయో. ");
INSERT INTO vgr_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","ఖాంజ్‍ హుయుతెదె యేసును, సిష్యుల్‍ ధర్యావ్ను సేడెఛాతె ఢోంగ చఢీన్‍ గలిలీయాజంకరమా; ");
INSERT INTO vgr_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","ఎత్రాస్మా రాత్‍హుయిగు పన్కి యేసు ఇవ్నాకన బుజుబీ అయోకోయిని. ");
INSERT INTO vgr_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","తెదె మోటు వ్యారో ఆవామ! ధర్యావ్మా జుకాళో ఉక్లుకరా, ");
INSERT INTO vgr_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","ఇవ్నే బరోభ్బర్‍ పాఛ్‍ నైతొ ఛో పర్లాంగ్‍ ఎత్రే దూర్మా ఢోంగాన లీజావమా పాస్సల్‍ యేసు ధర్యావ్నా ఉప్పర్‍చాల్తోహుయిన్‍ ఇవ్ను ఢోంగాన హఃమే ఆవనూ దేఖీన్‍ ఢారిగయూ; ");
INSERT INTO vgr_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","పన్కి యో మేస్‍ ఢరొనొకొకరి ఇవ్నేతి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","అనటెకె ఇనా ఢోంగామ చడైలేవనాటెకె ఇవ్నా ఇష్టంహుయు, ఎగ్గీస్‍ యో ఢోంగ ఇవ్నే జవుంకరతే జొగొమ చేరిగు. ");
INSERT INTO vgr_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","బుజెక్ ధన్నె వ్హాణే ఖాత్రే ధర్యావ్ను ఒడ్డుకనా ఉబ్రీన్‍ ఛాతె అద్మీను గుమ్మల్‍ ఆయిన్‍ దేఖమా! ఏక్ న్హాను ఢోంగా తప్ప బుజు కెహూబి ఎజ్గా కొయినీకరీ యేసు ఇను సిష్యుల్‍నా కేడె చడ్యాకోయిని పన్కి ఇన సీష్యులాస్‍ గయాకరీ మాలంకరిలిదా. ");
INSERT INTO vgr_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","పన్కి ప్రభూన కృతజ్ఞాతాస్తుతుల్‍ దీనాకితెదె ఇవ్నే రోటాఖాద్యతె జొగొమా ఖందె ఛాతె తిబెరియాతువాలను ఢోంగాల్‍ లీన్‍ఆయూ. ");
INSERT INTO vgr_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","అనహఃజే యేసు బుజు ఇను సిష్యుల్‍ ఎజ్గా నార్హావను అద్మియేఖారు దేక్యాతెదె ఇవ్నే ఢోంగా చఢీన్‍ యేసునా ధూండుతూహుయిన్‍ కపెర్నాహూమ్నా గాయూ. ");
INSERT INTO vgr_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","ధర్యావ్నుకనారిన ఇనా మాలంకరీన్ బోధకుడ్‍ తూ కెదె అజ్గ ఆయోకరి పుఛ్చావమా! ");
INSERT INTO vgr_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","యేసు, తుమే హాఃనద్నా దేఖాను బారెమా కాహేపన్కి రోట్టాఖైయిన్‍ ఢండార్‍బరీన్‍ పొందనటెకేస్ మన ధూండుకరస్‍ కరి తుమారేతి హాఃఛితి బోలుకరూస్‍ ");
INSERT INTO vgr_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","మట్జాయితె ధాన్నాటెకె మినాత్‍ నొకొపడ పన్కి, నిత్యజీవంన జావాను ఇనటెకేస్‍ మినాత్‍కారో; అద్మినఛియ్యో ఆ తుమ్నాదిషే, అనటెకేస్‍ భా హుయోతె దేవ్‍ ఇన ఛాపొ నాఖిరాక్యోస్‍కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","ఇవ్నే హామె దేవ్న నచ్యుకతొ సాను కామ్‍ కర్నూకరి ఇన పుఛ్చావమా! ");
INSERT INTO vgr_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","యేసు, యో మొక్లొతె ఇనకనా తుమే విస్వాష్‍ రాఖానుస్‍ దేవ్ని కామ్‍ కరి ఇవ్నేతి బోల్యొ ");
INSERT INTO vgr_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","అనటేకె ఇవ్నే, ఇమ్‍హుయుతో హఃమే దేఖిన్‍ విష్వాస్‍ కరనా తూ కెహూ హాఃనద్నూ క్రియల్నా కరుకరస్‍? సాత్‍ కరాయిస్‍ కరి ఇన పుఛ్చాయ. ");
INSERT INTO vgr_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","స్వర్గంమాతు ఖావనటెకె యో ధన్నా ఇవ్నా దెవ్వాడిరాఖోస్‍ కరి లిఖ్కార్యుతిమ్‍ అప్న భాన భా, జాఢిమా మన్నాను ఖాను ఖాద్యకరీ ఇనేతి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","అనహఃజే యేసు స్వర్గంమతు ఆవతే ధాన్‍ మోషే తుమ్నాదీరాక్యొకొయినీ, మారో భాస్‍ స్వర్గంమాతు ఆవతే హాఃఛిను ధాన్‍నా తుమ్న దేవ్వాడిరాక్యోస్‍ ");
INSERT INTO vgr_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","స్వర్గంతూ ఉత్రీనాయిన్‍ ములక్నా జీవం దేంవ్‍కరతే దేవ్‍ దీరాక్యోతె ధాన్‍హుయిన్‍ ఛా కరి తుమారేతి హాఃఛిస్‍ బోలుకరూస్‍ కరి ఇవ్నేతి బోల్యొ ");
INSERT INTO vgr_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","అనహాఃజె ఇవ్నే మాలీక్‍ ఆ ఖాణు కేదెబి హమ్నా దేవ్వాయిరాక్కరి బోల్యా. ");
INSERT INTO vgr_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","అనటెకె యేసు ఇవ్నేతి అమ్‍ బోల్యొ, జీవాహారంబీ మేస్‍ మారకన ఆవ్వాలొ కెదేబి పస్తూ ర్హాసెకొయిని; మారఫర్‍ విష్వాస్‍ కరవాలో యో కెదేబి తరాఖ్‍ తి ర్హాసెకోయిని. ");
INSERT INTO vgr_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","తుమే మన దేఖీన్‍ ర్హహీన్బి విష్వాస్‍ కరకొయిని తీమ్‍ ఛాకరీ తుమారేతి బోల్యొ థో. ");
INSERT INTO vgr_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","భా మన దేవ్వాయిరాక్యొతె ఇవ్నే ఖారుబి, మారకన ఆవ్సే; మారకన ఆవ్వాలన మే కెత్రేబి భాధర్‍ ధక్లిస్‍కోయిని. ");
INSERT INTO vgr_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","హుయుతో మారు ఇష్టంనా నేరవేర్చనటెకె మే కోఆయోని, మన మొక్లోతె ఇను చిత్తమ్నా నెరవేర్చనటేకెస్‍ స్వర్గంమతూ ఉత్రీన్‍ ఆయో. ");
INSERT INTO vgr_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","యో మన దిరక్యోతే ఇన్మా ఖారమబి మేసాత్బి గమాయోకొయినీతిమ్‍ ధర్తిను ఆఖరిధన్మా ఇన ఉట్టాడునూస్‍ మన మొక్లోతె ఇను ఇష్టంహుయిన్ ఛా. ");
INSERT INTO vgr_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","ఛియ్యోనా దేఖీన్‍ ఇనఫర్‍ విష్వాస్‍రాఖవాలు హార్యేక్జను మరణ్ కోయినితిమ్‍ నిత్యజీవంన పొందనూస్‍ మార భా చిత్తం; ధర్తిను ఆఖరినుధన్‍ మే ఇవ్నా ఉట్టాడీస్‍ ");
INSERT INTO vgr_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","అనటెకె “మే స్వర్గంమాతు ఉత్రీన్‍ ఆయోతెధాన్కరీ యో బోల్యొ” కరి యూదుల్ మోటా ఇను గూర్చి భణ్కిలేతూ, ");
INSERT INTO vgr_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","ఆ యోషేప్‍నొ ఛియ్యోహుయోతే యేసు కాహేనా? అను ఆయా, భాన అప్న మాలంహుయిన్‍ఛా కాహేనా? మే స్వర్గంమతూ ఉత్రీన్‍ ఆయ్రోస్‍ కరి అనే కిమ్‍ బోలుకరస్‍ కరి పుఛ్చాయా. ");
INSERT INTO vgr_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","అనటేకె యేసు తుమారమా తుమేస్‍ నొకోబణికిలేవొ; ");
INSERT INTO vgr_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","మన మోక్లోతె భా ఇన మాలంకర్యొతోస్‍ పన్కి కోన్బీ మారకన ఆవ్సెకోయిని; ధర్తిను ఆఖరిధన్‍ మే ఇన వుట్టాడీస్‍ ");
INSERT INTO vgr_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","ఇవ్నె ఖారుబి దేవ్నిహాతేఖు బోధించబడ్చేకరి ప్రవక్తల్‍ లేఖనంమా లిఖాయ్రూస్‍ అనహాఃజె భాన బారేమ ఖంజీన్‍ సికిరాక్యతే హర్యేక్జను మారకనా ఆవ్సే. ");
INSERT INTO vgr_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","భాన కోన్బి కోదేఖిరాక్యోని; దేవ్కంతూ ఆయోతె యో అనేస్‍ తప్ప బుజు భాన దేఖిరాక్యోస్‍ ");
INSERT INTO vgr_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","మే హాఃఛితిస్‍ బోలుకురుస్‍ విష్వాస్‍ కరవాలోస్‍ నిత్యజీవన్‍ ర్హాసె, ");
INSERT INTO vgr_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","49","జీవనూ ఖానుబి మేస్‍; తుమార భాన భా జాఢిమా మన్నానా ఖాద్యాతోబి మరిగయు. ");
INSERT INTO vgr_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","అనా ఖవ్వాలో మర్యొకొయిని తిమ్‍ స్వర్గంమతూ ఉత్రీన్‍ ఆయుతే ఖాణు ఆస్‍ ");
INSERT INTO vgr_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","స్వర్గంమతు ఉత్రీన్‍ ఆయుతె జీవంనుఖాను మేస్. కోన్బి ఆ ఆహారంనా ఖాద్యుతొ యో కొమార్సేకొయిన్‍తిమ్‍ జీవ్సె; బుజు మే దెంకురుతె ఖాణు ములక్నా జీవమ్‍నటెకె మారు ఆంగస్‍కరి తుమారేతి హాఃచ్చీతి బోలుకురూస్కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","ఇవ్నే అనే ఇను ఆంగ్‍తాన్‍ కిమ్‍ ఖావదిసేకరి ఏక్నా ఏక్ వాదించిలీదు ");
INSERT INTO vgr_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","ఇనటేకె యేసు అమ్‍ బోల్యొ, తుమే అద్మినొఛియ్యోనా ఆంగ్‍తాన్‍ ఖైయిన్‍ ఇను లోహి పిదాతొస్‍ తప్ప, తుమారమా తుమే జాన్‍హుయిన్‍ కోర్హాసుని. ");
INSERT INTO vgr_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","మారు ఆంగ్న ఖైయిన్‍ మారు లోహినా పిదోహుయోస్‍ నిత్యజాన్వాలొ హుయోవోహొ; ధర్తీను ఆఖరినుధన్మా మే ఇనా ఉట్టాడీస్‍ ");
INSERT INTO vgr_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","మారు ఆంగ్‍తాన్‍ హాఃఛిహుయూతె ఖానుహుయిన్‍ మారు లోహి హాఃఛిహుయుతె పా‍నియంహుయిన్‍ ఛా. ");
INSERT INTO vgr_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","మారు ఆంగ్నా ఖైయిన్‍ మారు లోహి పిదోహుయోహో మారజోడ్మా మే ఇనా బరాబ్బర్‍ ఉబ్రీన్‍ ర్హాసు. ");
INSERT INTO vgr_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","జాన్‍తి ఛాతె మారొ భా మన మొక్లొ అనహాఃజె మే భాను బారేమా జీవుంకరతె తిమ్మస్‍ మన ఖోంకరతె యోబీ మారు బారేమా జీవ్సె. ");
INSERT INTO vgr_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","స్వర్గంతూ ఉత్రీన్‍ ఆయుతే ఖాణు ఆస్‍; భాన భా మన్నాన ఖైయిన్బి మరీగయూ తిమ్‍ కాహే; ఆ ఖాణు ఖవ్వాలో కెదేబీ జివీన్‍ ర్హాసేకరి హాఃఛీతి తుమారేతి బోలుకురూస్ కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","యో కపెర్నహూమ్‍మా బోధించుతొహుయిన్‍ యూదుల న్యావ్‍కరనుజొగొ ఆవాతె బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","కెత్రుకిజను ఆ భోధ హఃజిన్‍ ఆ మినాత్ను భోధ ఆ కోణ్ హఃమ్చె కరి బొల్లీదు. ");
INSERT INTO vgr_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","యేసు గురించి కెత్రుకి అద్మియో ఇన గురీంచీ భణికిలేంకరస్కరి ఇను యోస్‍ సోచీన్‍ ఇవ్నేతీ అంమ్‍ బోల్యొ, అనటెకె తుమే అభ్యంతరంగా ఛానా. ");
INSERT INTO vgr_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","ఇమ్‍హుయుతొ అద్మినొఛియ్యో అగాడి ఛాతె జొగోమా ఛాఢిజావాను దేఖ్యతెదె తుమే సాత్‍ బోల్చు. ");
INSERT INTO vgr_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","దేవుడు దిదొతే ఆత్మాస్‍ జివ్వాడుకరస్‍; ఆంగ్తన్‍ చుక్కేష్‍ నిష్‍ప్రయోజనమ్‍ మే తుమారేతి బోలిరాక్యోతె వాతె ఆత్మనా జాన్‍హుయీన్‍ ఛా! పన్కి ");
INSERT INTO vgr_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","తుమారమా విష్వాసం కరకొయింతే థోడుజనూ ఛాకరి ఇవ్నేతి బోల్యొ. విష్వాసం కరకొయింతె యోకోన్కి, ఇనా ధరైయ్‍దెవ్వాలొ యో కోన్కి, యేసునా అగాఢితూస్‍ మాలం. ");
INSERT INTO vgr_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","బుజు యో, భాన హాతె ఇవ్నా కృప దెవ్వాడి రాఖనుతీబి కోన్బిహో మారకన కోఆవ్సేనికరి అకారణంటేకెస్‍ తుమారేతి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","తెప్తూ ధరిన్‍ కెత్రూకి జణు ఫీటెచలీగు, బుజు కెదేబీ ఇనాకేడె కోగయూని. ");
INSERT INTO vgr_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","ఇనటెకె యేసు బోల్యొ, తుమేబీ చలీజానూకరి ఛానా? కరి యో భారజననా‌ సిస్యుల్తి పుఛ్చావమా. ");
INSERT INTO vgr_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","సీమోన్‍ పేతుర్‍ బోల్యా, ప్రభూ! కినాకన జైయే? తూస్‍ నిత్యజీవంనా గూర్చివాతె బోలవాలొ హూయ్రోస్‍; ");
INSERT INTO vgr_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","“తూస్‍ దేవ్ని ఛియ్యో పరిసుద్దుడ్‍ కరి హమే విష్వాసంకరిన్” మాలం రాక్యస్‍కరి ఇనేతి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","ఇనటేకె యేసు, మే తుమ్నా భారజనకరి ఎంచిరాక్యోస్నీ? తుమారమా ఏక్జనో భూత్‍ కరి ఇవ్నేతి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","సీమోన్‍ ఛియ్యో హుయోతె ఇస్కరియోతు యూదా భారజనమా ఏక్జనురహీన్‍‍ ఇనా ధరైయిదేనుకరి థో! ఇనటేకె ఇన గుర్చినాస్ యో ఆవాతె బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","ఇనపాసల్‍ యూదుల్‍ యేసునా మర్రక్నూ కరి దుంఢలగమా యో యూదయమా జావకోయిని తిమ్‍ గలిలయమ పర్తురంకరాస్. ");
INSERT INTO vgr_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","యూదుల్‍ను ఢేరను పండగా ఖాందె ఆవమా, ");
INSERT INTO vgr_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","పన్కి ఇన భైయేఖారు ఇన‍ దేఖీన్‍ తూ కరుకరతే క్రియాల్‍ తారు సిష్యుల్‍బి దేకహఃర్కు ఆ జోగొ బేందిన్‍ యూదయామ చాలోజా. ");
INSERT INTO vgr_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","బహిరంగంమా అంగీకరీంపబడవాలో యోకోన్బి ఇనుకామ్‍ ఆహ్‍క్రేతీ కర్సేకోయిని. తూ ఆకార్యమ్‍ కరుకరతోతెదె తున తూస్‍ ములక్నా దెఖాడిలాకరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","ఇనుస్‍ భైయ్యె హుయుతోబీ ఇనఫర్‍ విష్వాస్‍ రాక్యకోయిని. ");
INSERT INTO vgr_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","యేసు ఇవ్నేతి బోల్యొ, మారు వఖాత్‍ బుజుబి కోఆయుని తూమరు వఖాత్‍ కెదేబి సిద్దతార ఛా. ");
INSERT INTO vgr_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","ములక్‍ తుమ్న ద్వేషించే కోయిని పన్కి, ఇను క్రియల్‍ ఖారాభ్‍ మే ఇను గూర్చి ‍సాబుత్‍ దేవుంకరుస్‍ ఇనటేకె యో మన ద్వేషించుకరస్‍ ");
INSERT INTO vgr_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","తుమే పండగాన జవొ; మారు వఖాత్‍ బుజుబి పూర్తి కోహుయుని ఇనటేకె మే ఆ పండగాన హంకేస్‍ జైస్‍కోయిని, కరి ఇవ్నేతి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","యో ఇవ్నేతి అమ్‍ బోలిన్‍ గలిలయమ ర్హైయిగొ. ");
INSERT INTO vgr_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","పన్కి ఇన భైయే పండగామ నికిజావమా ఇన పాస్సల్‍తి యోబి కినమాలం కొయినితిమ్‍ ఆక్రేతీ గయో. ");
INSERT INTO vgr_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","పండగామ యూదుల్‍ యో కెజ్గా ఛాకరి ధూంఢు కరుకర్తథా. ");
INSERT INTO vgr_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","బుజు కెత్రుకి అద్మి ఇన గుర్చి ఛాఢీబోలలగ్యు, థోడుజను యో అషల్ వాలోకరి; బుజు థోడుజను కాహేకరి; యో అద్మిఖారు మోసం కరవాలోకరి బోల్యా. ");
INSERT INTO vgr_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","హుయుతోబి యూదుల్నా అధికరినా ఢరీన్‍ ఇనగురించి సభనఖామే వాతె కోబోల్యుని. ");
INSERT INTO vgr_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","ఆదు పండుగా హుయిగుయు తెదె యేసు మందిర్‍మా జైన్‍ బోధించుకుర్తు థో. ");
INSERT INTO vgr_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","ఇనటెకె యూదుల్ను అధికారి అష్యంహుయిన్‍ పడాను ఆవకోయినితె ఇన ఆ కింమ్‍ ఆయూకరి బోల్లిదు. ");
INSERT INTO vgr_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","ఇనటెకె యేసు అమ్‍ బోల్యొ, మే కరుకరతే బోధ మారుకాహే మన మోక్లోతె ఇనూస్. ");
INSERT INTO vgr_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","కోన్బి ఇన ఛిత్తమ్‍ ప్రకారం కర్నుకరి సోచిలిదాతో, తెదె యో బోధ దేవ్ని బన్తి హుయికీ నైతో, మారు మేస్‍ బోధించుకరుస్‍కీ ఇనే మాలం కర్లీసే. ");
INSERT INTO vgr_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","ఇను యోస్‍ బోలవలో స్వంత మహిమ దూండు‍కరాస్‍ పన్కి ఇన మోక్లోతే ఇనీ మహిమన ధూండవలో హాఃఛోఅద్మి ఇనకన కెహూ దుర్నితీబికొయిని. ");
INSERT INTO vgr_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","మోషే తుమ్న ధర్మషాస్త్రంనా దిదొకోయిన్నా? హుయుతోబి తుమారమ కొన్బి యో ధర్మషాస్త్రంనా మాలంకరకోయిని; తుమేసె మన మర్రాక్నుకరి దేఖుకరస్‍? కరి ఇవ్నేతి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","అనటెకె అద్మినుగల్లో థూ భూత్‍ ధర్రాక్యుహుయూతెవాలో కోన్‍ తునా మర్రాక్నుకరీ దేకుకరస్ పుఛ్చావమా. ");
INSERT INTO vgr_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","యేసు ఇవ్నా దేఖీన్‍ బోల్యొ, మే ఏక్ కార్యమ్‍ కర్యొ; ఇనటెకె తుమే ఖారు అష్యంహుంవుకరస్‍ ");
INSERT INTO vgr_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","మోషే తుమ్న సున్నతిన అచారంనా నియమించిరాక్యోస్‍ ఆ అచారమ్‍ మోషేతిహుయుతే కాహే భాన భాన‍టేకెస్‍ హుయూ. హుయుతోబి ఆరమ్నుధన్‍ తుమే అద్మినా సున్నతి షాన కరుకరాస్‍ ");
INSERT INTO vgr_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","మోషె ధర్మషాస్త్రంనా తుమే సోచ్చాతింమ్‍ ఏక్ అద్మినా ఆరమ్ను ధన్నె సున్నతీన పొంద్సె పన్కి! అమ్‍ర్హావమా మే ఆరమ్‍నుధన్నె ఏక్ అద్మినా పూర్తి స్వస్థతని గోణి ఇంనితర కర్యోకరి తుమె మారఫర్‍ చంఢాల్‍ కరుకరతె సే. ");
INSERT INTO vgr_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","భార్ దెఖావతె ఇనబట్టి న్యావ్‍ తీర్చాకొయినితింమ్ న్యాయంహుయూతె న్యావ్‍నా తీర్చొకరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","యేరుషలేమ్మా థోడుజను ఇవ్నె మార్రాక్నుకరి దుమ్‍డుకరతె యో ఆస్ కాహేనా? ");
INSERT INTO vgr_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","హాదేక్‍ అనే బహీరంగంమా వాతె బోలుకరతోబి అనా షాత్బీ బోలకోయిని; అనే క్రీస్తుకరి అధికారుల్‍ హాఃఛితీ మాలంకరీన్‍ ర్హాసేనా. ");
INSERT INTO vgr_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","హుయుతోబి అనే కెజ్గనోకి హామ్నమాలం. మెస్సయా ఆవని వఖాత్ ఇనే కెజ్గానొవాలోకి కోన్బీ మాలంకర్సెకొయిని కరి బొల్లిదు. ");
INSERT INTO vgr_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","హుయుతోబి యేసునె దేవ్ని మందిరంమా బొధకర్తొహుయిన్‍ “తుమే మన మాలంకర్సు; మే కెజ్గాను వాలోకి మాలంకర్సు మారు మేస్‍ ఆయోకోయిని, మన మోక్లోతే యో హాఃఛివాలొ, ఇనా తుమే మాలంకర్సుకొయిని. ");
INSERT INTO vgr_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","మే ఇనకంతు ఆయో! ఇనే మన మోక్లో అనటేకే మే ఇనా మాలంకరిస్కరి” గట్టీతి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","ఇనటేకె ఇవ్నేఇన ధర్లేనుకరి కోసీస్‍కర్యా, పన్కి ఇను వహఃత్ బుజుబి ఆయుకోయిని అనటేకె కోన్బి ఇనా ధర్యుకొయిని. ");
INSERT INTO vgr_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","బుజు అద్మియేన గల్లొమా కెత్రూకిజణు ఇనఫార్‍ విష్వాస్‍ రాకీన్‍ క్రీస్తు ఆయోతెదె అనే కర్యోతె ఇనేతీబి జాహఃత్‍ సూచక క్రియల్‍ కర్సేనా? కరి బొల్లీదు. ");
INSERT INTO vgr_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","అద్మియేను గళ్లో యేసును గురించి అమ్‍ భణికిలీదు పరిసయ్యుల్‍ ఖంజీన్‍ ఇవ్నె ప్రధానయాజకుల్‍ ఇనా ధర్లేవానా సైనికుల్‍నా మొక్లూ. ");
INSERT INTO vgr_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","యేసు “బుజుబీ థోడుధన్‍ మే తుమారకేడె ర్హహీస్‍; పాసల్తీ మన మొక్లొతె ఇనకన జైస్. ");
INSERT INTO vgr_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","తుమే మన ధూండ్సు పన్కి మాలంకర్సుకొయిని, మే కెజ్గా ర్హైస్కీ, ఎజ్గా తుమే ఆవ్సుకొయిని” కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","అనహాఃజె యూదుల్‍ అప్నె అన నామాలంకరఖార్కూ తిమ్‍ అనే కెజ్గా జోమ్‍కరస్‍? గ్రీసుదేఖ్‍ వాలమా చెదిరిగుతే ఇవ్నాకన జైన్‍ గ్రీసుదేఖ్ వాలన బోధించేనా? ");
INSERT INTO vgr_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","మన ధూండ్సు పన్కి మాలంకరకొయిని, మే కెజ్గా ర్హైయిస్కి, ఎజ్గా తుమె కోఆవ్సునీకరి ఇనే బోల్యొతె ఆవాత్‍ సాత్‍కరి ఇవ్నామా ఇవ్నె బోల్లీదు. ");
INSERT INTO vgr_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","యో పండగమా మహాధన్‍హుయూతె ఆఖరునుధన్నె యేసు వుబ్రీన్‍ “కోన్బీ తరఖ్‍ లాగ్గివుసేతో మారకనా ఆయిన్‍ తరాఖ్‍ తక్‍తొల్లెవోకరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","మారకనా విష్వాస్‍ రాకవాలు కోన్కీ లేఖనంమా బోల్యుతిమ్‍ ఇనా పేట్ మాతు జీవంను జలాధరాల్‍ పొంగ్సేకరిస” జోరేఖు బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","ఇనకన విష్వాస్‍ రాఖావాలు పొందజాసేతే ఆత్మనా గూర్చి యో వాతె బోల్యొ. యేసు బుజుబి మహిమపరచబడ్యోకొయిని ఇనటెకె ఆత్మ బుజుబి అనుగ్రహీంపబడ్యుకొయిని. ");
INSERT INTO vgr_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","అద్మియేను గళ్లొమా థోడుజను ఆవాతేన హాఃజీన్‍ “హాఃఛిస్‍ ఆ ప్రవక్తస్‍కరి” బోల్యు. ");
INSERT INTO vgr_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","“అజు థోడుజణు ఆ క్రీస్తునా” బోల్యా; బుజు థోడుజను సే? అజు థోడుజాను క్రీసు గలిలయమాతు ఆవ్సేనా? ");
INSERT INTO vgr_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","క్రీస్తునే దావీద్ను జాత్మా ప్హైయిదాహుయిన్‍ దావిద్‍ థోతె బేత్లెహేమ్ కరి పట్టణం ఆవ్సేకరి లేఖనంమా బోలుకరాస్‍ కొయిన్నా. ");
INSERT INTO vgr_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","అనహఃజే అన బారెమా అద్మియేను గుంబ్బల్మా భేదాల్‍ హుయు. ");
INSERT INTO vgr_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","ఇవ్నమా థోడుజణు ఇన ధర్లేనుకరి సోచూ! పన్కి కోన్బి ఇన ధర్యుకొయిని. ");
INSERT INTO vgr_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","యో సైనికుల్నా ప్రధాన యాజకుల్‍ కన పరిసయ్యుల్‍ కన, ఆయాతెదె ఇవ్నె “తుమే షానటెకె ఇన బులైలీన్‍ ఆయుకోయిని” పుఛ్చావమా! ");
INSERT INTO vgr_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","యోసైనికుల్‍ యో అద్మి బోల్యుతిమ్ కోన్బీ కెదేబి ఇమ్నితార వాతె బోల్యుకొయినికరి బోల్యు. ");
INSERT INTO vgr_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","అనహఃజే పరిసయ్యుల్‍ తుమేబి మోసం హుయిగయనా? ");
INSERT INTO vgr_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","“అధికారుల్మాహో పన్కి పరిసయ్యూల్మాహో పన్కి కోన్బీ అనకన విష్వాస్‍రాక్చునా? ");
INSERT INTO vgr_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","ధర్మషాస్త్రం మాలంకొయింతే యోక అద్మిఖారు షాపగ్రస్తల్ హుయూకరి” ఇవ్నేతి బోల్యు. ");
INSERT INTO vgr_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","ఇనఅగాఢి అనకన అయోతే నికోదేమ్ ఇవ్నామా ఏక్జనో థూ. ");
INSERT INTO vgr_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","యో ఏక్‍అద్మిను వాత్‍ ఖాంజన అగాఢిస్‍ ఇనే కర్యోతె మాలంకరకోయినితె అగాఢి, అప్ను ధర్మషాస్త్రం ఇనా న్యావ్‍ తీర్చేనా? కరి పుఛ్చావమా. ");
INSERT INTO vgr_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","యూదుల్‍ తుబి గలిలయావాలోనా? లేఖనాల్‍ పడ్యొకొయినిషూ ఏన్‍ కరిన్‍దేక్‍ గలిలయామా కెహూ ప్రవక్తాబి కోఫైదాహుసేని. ");
INSERT INTO vgr_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","తెదే ఇవ్నే ఘెర్నా ఇవ్నా గాయా. ");
INSERT INTO vgr_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","తెదె కిను ఘేర్కన ఇవ్నే చలీగు, పన్కి యేసు, ఒలీవలా పహాడ్‍కనా గయో! ");
INSERT INTO vgr_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","యేసు బుజేఏక్‍ ధనె వ్యానేకత్రేస్‍ ఫరీన్‍ దేవ్ని మందిర్‍మా ఆవమా అద్మి హాఃరు ఇనకనా ఆయూ ఇనటేకె ఇనే భేషీన్‍ ఇవ్నా బోధించుకరా. ");
INSERT INTO vgr_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","తెదె ధర్మషాస్ర్తంనా బోధించువాలు, షాస్ర్తుల్‍బీ పరిసయ్యుల్‍బీ, వ్యభిచార్‍కనా ధర్యుతే ఏక్ బాయికొ నా బులాలిఆయిన్‍ ఇన ఇచ్మా ఉభారి రాఖీన్‍. ");
INSERT INTO vgr_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","బోధకుడా, ఆ బాయికో వ్యభిచార్‍ కరుకరాతేదే, ");
INSERT INTO vgr_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","ఎజాత్ను వాలన ఫత్రాతి భిర్కైన్‍ మర్రాక్ను కరి మోషే ధర్మ షాస్ర్తంమా ఆజ్ఞాదిరాక్యోస్‍ కాహేనా? హుయుతోబీ థూ సాత్‍ బోలుకరస్‍? కరి ఇన పుఛాయ్యా. ");
INSERT INTO vgr_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","ఇన ఉప్పరస్‍ ఛాడి నాక్నుకరీ ఇనస్‍ ఖాహతావ్తూ అమ్నితర పుఛ్చాయు. పన్కి యేసు జుఖీన్‍ జమీన్‍ఫర్‍ అంగ్లితీ సాత్కీ లిఖ్కాలగూ. ");
INSERT INTO vgr_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","ఇవ్నే ఇనా బేందాకోయినితిమ్‍ బోలలాగమా యేసు మోడుపాడీన్‍ దేఖీన్‍ తుమారమా పాప్‍ కర్యుకోయింతె యో అగాడి ఇనఫర్‍ ఫత్రో నాకజాయి కరి ఇవ్నేతి బోలీన్‍ ");
INSERT INTO vgr_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","బుజు జుకిన్‍ మాటీపర్‍ లీఖాలగ్యూ! ");
INSERT INTO vgr_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","ఇవ్నే ఇని వాత్న ఖంజీన్‍ మోటా అద్మితూ నికీన్‍ అడ్డాణి లడ్కాలగు ఏక్ను కేడె ఏక్ బెందీన్‍ గయూ; యేసు ఎక్కస్‍జనో మిగ్లిగో యో బాయికో ఇచ్మా ఉబ్రీన్‍ రయ్యో. ");
INSERT INTO vgr_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","యేసునే ముడ్‍క్యూపాడిన్‍ ఆయా ఇవ్నే కేజ్గాఛా? కోన్‍బీ తున సిక్చ నాక్యుకోయిన్నా? కరి పుఛ్చాయుతెదె! ");
INSERT INTO vgr_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","యో బాయికొ కొయిని ప్రభూవా కరి బోలి అనటేకే యేసు మేబి తున సిక్చించు కొయిని; తూ జైన్‍ హంకేతు పాప్‍ నోకోకరిస్‍ కరి ఇనెతీ బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","బుజు యేసు మే ములాక్న ఉజాళు, మన మారకెడె చాలవాలో యో అంధారమా చాల్సేకొయిని జీవంను ఉజాలు హుయిన్‍ ర్హాసేకరి ఇవ్నేతీ బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","తెదె పరిసయ్యుల్‍ తారు థూస్‍ సాబుత్‍ బొల్లెంకరస్‍; తారు సాబుత్‍ హాఃఛికాహేకరి ఇనెతీ బోలమా. ");
INSERT INTO vgr_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","యేసునే మే కెజ్గాతూ ఆయోకి కెజ్గా జైయిస్కి సోచిరాక్యోస్‍; అనహాఃజె మారహాఃజె మేస్‍ సాబుత్‍ బోల్లిదొతోబి మారు సాబుత్‍ హాఃచ్ఛీస్‍; మే కెజ్గాతూ నికీన్‍ వాలంకురుస్కి, కెజ్గా జంకురస్కి తుమ్నామాలంకొయిని. ");
INSERT INTO vgr_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","తుమే ఆంగ్‍బట్టి న్యావ్‍ తీర్చుకరస్‍ ");
INSERT INTO vgr_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","పన్కి మే కినాబి న్యావ్ తీర్ఛీస్‍కొయిని, మే ఏక్జనో ర్హహీస్‍కొయినితింమ్‍ మేబీ, మన మొక్లొతె భా బీ ఛియ్యో అనటేకె మే బీ న్యావ్‍ తీర్చతోబి మారున్యావ్‍ హాఃఛిస్‍ ");
INSERT INTO vgr_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","బుజు బే అద్మిను సాబుత్‍ హాఃఛి తుమార ధర్మషాస్ర్తంమా లిఖ్కాయ్‍రూస్‍కాహేనా! ");
INSERT INTO vgr_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","మార గూర్చిన్‍ మే సాబుత్‍ బొల్లిలిదోత్‍; మన మొక్లొతె భా సబి మార గూర్చిన్‍ సాబుత్‍ బోలుకరస్‍కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","తెదె యేసు ఇవ్నేతి తారో భా కెజ్గఛాకరి పుఛ్చావమా; యేసు తుమే మనతోబి, భానతోబి మారో భాతోబి మాలంకరకోయిని; మన మాలం కర్యానా మార భానబి మాలంకర్చూ కరి ఇవ్నేతి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","ఇనే దేవ్ను మందిర్‍మా బోధాకర్తోర్హావమా పైసానకను పేట్టీనా జోగోమా ఆ వాతె బోల్యు, ఇను బాజను బుజుబి ఆయుకోయిని, పన్కి కోన్బీ అన ధర్లిదుకోయిని. ");
INSERT INTO vgr_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","బుజు ఏక్ వఖాత్‍ ఇనే, “మే ఛలోజంక్రుస్‍; తుమే మన ధూండ్సు పన్కి, తుమార పాప్ మాస్‍ రైయిన్‍ మార్జాసు; మే జైయిస్తే జొగోమా తుమే కోఆవ్సుని” కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","ఇనటెకె యూదుల్‍ అధికారల్‍ మే జేస్‍తే జోగోమా తుమే కోఆవుసునీ కరి యో బోలుకరస్‍నీ; ఇను యోస్‍ మరిజాసేనా కరి బొల్లిదు. ");
INSERT INTO vgr_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","తెదే యో, “తుమే ములక్నాసంబంధించుయుహు, అద్మి మే సర్గంనా సంబంధిహుయోహో; తుమే ములక్మా సంబందించుయుహు మే ములక్ను సంబందంహుయుతే కాహే. ");
INSERT INTO vgr_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","ఇనటెకె తూమరు పాపంమాతు తుమే మార్జాసు కరి తుమారేతి బోల్యోతొ, మే యోస్కరి తుమే విస్వాసం నాకర్యుతో తుమే తుమార పాప్‍ మతూస్‍ మర్జాసుకరి” ఇవ్నేతీ బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","ఇనటేకె ఇవ్నే, తు కోన్కరి ఇన పుఛ్చావమా యేసు ఇవ్నేతి, అగాడీతీ మే తుమ్న కోన్కరి బోలుకరూస్కి మేస్కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","తుమ్నా లీన్‍ బోలనుబి న్యావ్‍ తీర్చానటెకెబి ఘాణు సంగతుల్‍ మన మాలం పన్కి మన బోలీమోక్లోతె యో హాఃచేలొ మే ఇనకనా ఖాంజ్యోతే సంగతుల్‍ నస్‍ ములక్‍నా బోధించుకరుస్‍ కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","భానలీన్‍ యో ఇవ్నేతి బోలుకరస్కరి ఇవ్నే మాలం కోకర్యాని. ");
INSERT INTO vgr_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","ఇనటెకె యేసు, తుమే అద్మినా ఛీయ్యోనా ఉపర్‍ పడ్యాతెదే యో మేస్‍కరీ, మారు మేస్‍ సాత్‍బీ కోకరిస్‍నీతిం భా మనా‍ సీకడ్యోతిమ్‍ ఆ సంగతుల్‍ బోలుకరూస్కరి తుమే మాలంకర్‍సు. ");
INSERT INTO vgr_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","మన బోలీమోక్లోతె యో మారకేడె ఛా! నచ్యుతే కార్యంనా మే కెదేబి కరిస్‍ ఇనటెకే యో మన ఎకేలోస్‍ కొబెంద్యొని కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","యో ఆ సంగతుల్‍నా బోల్తొ ర్హావమా కెత్రూకి జను ఇనపర్‍ విస్వాసం రాఖ్యూ. ");
INSERT INTO vgr_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","ఇనటేకె యేసు ఇనా నమ్యుతె యూదుల్మా తుమే “మారు బోధనా హాఃజీన్‍ రవ్వాలవుసేతో హాఃఛిమాస్‍ మార సిష్యుల్‍ హుయిన్‍ హాఃచినా మాలంకర్‍సూ; కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","తెదే యో హాఃఛిమాస్‍ తూమ్నా స్వతంత్రులనుగా కర్‍సేకరి” బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","తెదె ఇవ్నే, హామే అబ్రాహామ్‍నా సంతానం హామే కెదేబీ కీనాబి దాసుడ్ హుయిన్‍ కోర్హయిని తుమే స్వతంత్రులనుగా రాసు కరి కిమ్‍ బోలుకరస్‍ కరి ఇనేతి బోల్యు. ");
INSERT INTO vgr_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","ఇనటేకే యేసు పాప్‍ కరిహుయు హార్యేక్జను పాప్న దాసుడ్‍ కరి తుమరేతి హాఃఛితి బోలుకరాస్‍ ");
INSERT INTO vgr_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","దాసుల్‍ కెదేబి ఘార్మా కోర్హయిని; ఛియ్యో హమేసాబి జివుంకరస్. ");
INSERT INTO vgr_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","ఛియ్యో తుమాన స్వతంత్రుల్గా కర్యుతో తుమే హాఃఛీమాస్‍ స్వతంత్రుల్‍ హుయిన్ రాసు. ");
INSERT INTO vgr_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","తుమే అబ్రాహామ్‍నా సంతానం కరి మన మాలం హుయుతోబీ తుమారమ మార వచన్న టెకే జోగో కొయిని, ఇనటేకె మన మర్రాకన దేఖూకరాస్‍ ");
INSERT INTO vgr_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","మే మార భాకన దేక్యోతే సంగతులస్‍ బోధించుకరుస్‍; యో ప్రకరమాస్‍ తుమే తుమారభా కన ఖాంజుతే ఇనస్‍ కరుకరాస్‍ ఇవ్నేతి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","ఇనటేకె ఇవ్నే ఇనేతి హామరో భా అబ్రాహామ్ను కరి బోల్యానీ; యేసు, “తుమే అబ్రాహామ్నా లడ్కా హుయాతో అబ్రాహామ్ను కర్యోతే క్రియాలస్‍ కర్సూ.” ");
INSERT INTO vgr_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","దేవ్నుకాంతు ఖాంజుతె హాఃఛినా తుమారేతి బోల్యోతె మనహంకెస్ తుమే మర్రాకన దేఖుకరస్నీ; అబ్రాహామ్ను ఇమ్‍ కోకర్యోని. ");
INSERT INTO vgr_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","తుమే తుమార భాన క్రియలస్‍ కరుకరాస్‍ కరి ఇవ్నేతి బోల్యొ; ఇనటేకె ఇవ్నే హామే వ్యభిచార్వాలా ఫైదాహుయాకాహే, “దేవ్‍ ఏక్కాస్‍ హామ్నా భా బుజు హామే ఇనా లడ్కా” బోలామ. ");
INSERT INTO vgr_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","యేసు ఇవ్నేతీ ఆమ్‍నీతర బోల్యొ; దేవ్‍ తుమరో భా హుయోతో తుమే మన ఫ్యార్‍కరసు; మే దేవ్‍కంతీ బయాలుదేరిన్‍ ఆయిరోస్‍ మారు మేస్‍ కోఆయోని, యో మన బోలిమోక్లో. ");
INSERT INTO vgr_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","తుమే కిమ్‍ మారువాతేనా మాలంకోకరని? తుమే మారు బోధనా ఖంజాను తుమ్నా సహనమ్‍ కొయిని? ");
INSERT INTO vgr_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","తుమే తుమార భాన వల భూత్‍ సంబందుల్‍; తుమార భాన ఆఖ్నా పురాకర్ను కరి కోరిలేవుంకరస్‍ జామానతి యో నరహంతకుడ్‍ హుయిన్‍ హాఃఛినాటెకె వుబీరోహుయో కాహే; ఇనమా హాఃఛీస్‍ కొయినీ యో ఛాడ్‍బోల్యా తెదె ఇను స్వభావమ్‍ ఛాలీన్‍ వాతె బోలస్‍; యో ఛాడ్‍ ఛాడ్న భాహుయిన్‍ ఛా. ");
INSERT INTO vgr_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","మే హాఃఛినస్‍ బోలుకరూస్‍ ఇనటెకె తుమే మన నమ్మా కొయినీ. ");
INSERT INTO vgr_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","మరామ పాప్ ఛాకరి తుమారమ కోన్‍ వతాల్‍సే? మే హాఃఛి బోలుకర్తో హుసేతో తుమేసే? మన నమ్మా కోనమ్యని. ");
INSERT INTO vgr_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","దేవ్నా సంభాధి హువ్వాలో దేవ్‍ను వాతేనా ఖంజాస్‍ తుమే దేవ్నా సంబంధుల్‍ కాహే ఇనటెకె తుమే కోఖంజానీ కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","ఇనటెకె యూదుల్‍ తూ సమరయుడ్నొ భూత్‍ ధర్యోతెవాలో కరి హమే బోల్యాతె వాత్‍ హఃఛిస్‍ కాహేనా. కరి ఇనేతి బోలామ. ");
INSERT INTO vgr_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","యేసు మే భూత్‍ ధర్యాక్యుతే వాలో కాహే, మార భాన ఘనాపరచా వాలో; తుమే మన అవమానం కాడుకరస్ కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","మే మార మహిమన ధూండుకురూ కోయిని; ధూండ్తోహుయిన్‍ న్యావ్‍ తీర్చావాలో ఏక్జను ఛా. ");
INSERT INTO vgr_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","ఏక్జనో మారివాతేనా పాట్టీన్చావాలు యో కెదేబి మారణ్నా కోదెక్సేనికరి తుమారేతి హాఃఛితి బోలుకరూస్‍ కరి ఉత్తరం బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","ఇనటేకె యూదుల్‍ తూ భూత్‍ ధరాక్యోహుయోకరి హాంకే మాలంకర్యా; అబ్రాహామ్‍బి, ప్రవక్తాల్బీ మరీగయా; హుయితోబీ ఏక్జాను మారు వాత్‍ యో కెదేబి మారణ్నా కోదేక్సెనికరి తూ బోలుకరస్‍ ");
INSERT INTO vgr_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","అప్నో భా హుయోతే అబ్రాహామ్ను మరిజాస్‍ కాహేన; ప్రవక్తల్బీ మరిజాస్నీ తూ ఇవ్నేతీబీ గొప్పవాలోసూ? తూ తార దీల్‍ కోన్‍కరీ రైయిజంక్రస్‍కరి పుఛ్చాయా. ");
INSERT INTO vgr_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","ఇనటెకే యేసు, మారు మేస్‍ మహిమా పరిచీలిదోతో మారు మహిమాన విలువా కొయిని; హామారో దేవ్కరీ కినాలీన్‍ బోలుకరస్కీ, యో మారో భాస్‍ మన మహిమా పరుచుకరస్‍ ");
INSERT INTO vgr_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","తుమే ఇన మాలంకరకొయినీ, పన్కి యో మనా మాలం; యో మన మాలంకొయినీ కరి బోల్యొతొ తుమ్మారని తరాస్‍ మే జూటీవాలొహుయిస్‍ పన్కి, మే ఇన మాలంకర్యొ, ఇని వాత్‍ఫర్‍ మే ఛాలుకరూస్‍ ");
INSERT INTO vgr_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","తుమారో భా హుయోతె అబ్రాహామ్‍నా దేక్‍సు కరి ఘాను ఆనందింస్యు; యో దేఖీన్‍ ఖూషి హుసు కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","ఇనటెకె యూదులస్ తునా “వుజుబీ అఢైహ్ః వరహ్‍ఃబీకొయిని తూ అబ్రాహామ్‍నా దేక్యనా” కరి బోలమా. ");
INSERT INTO vgr_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","యేసు, “అబ్రాహామ్ను ప్హైదాహువనా అగాడ్తిస్‍ మె ఛావ్కరి తుమారేతి హాఃఛితి బోలుకరూస్కరి” బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","ఇనటేకె ఇవ్నే ఇనవుపర్‍ ఫేకానటెకె ఫత్రోపాడ్యో, పన్కి యేసు లాపిన్‍ దేవ్ను మందిర్ మాతీ బాధర్‍ నికిలీజాస్‍. ");
INSERT INTO vgr_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","యేసు వాట్‍ఫర్తూ జంకరమా తెదె పైదాఖ్ తూ ఏక్‍ కాణు అద్మి దెఖ్కాయో. ");
INSERT INTO vgr_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","ఇన సిష్యుల్‍ బోధకుడ్‍ ఆ ఖాణుహుయిన్‍ ప్హైదాహువనా కోన్‍ పాప్‍కర్యూ? కరి పుఛ్చావమా, ఆకి, అన ప్హైదాకర్యతె ఆయా భానా కరి ఇనా పుఛ్చావమా. ");
INSERT INTO vgr_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","యేసు అనెహో అన ప్హైదాకర్యొహొ, పాప్‍కోకర్యోని పన్కి, దేవ్ను క్రియల్‍ అన‍కన వతాలనటెకె ఆ ఖాణుహుయిన్‍ ప్హైదాహుయు. ");
INSERT INTO vgr_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","ఉజాలు ర్హావయెత్రాతోడి మన బోలిమోక్లొతే ఇనుక్రియాల్‍ అప్నె కర్తూర్హాను; రాత్‍ హుయుతెదె, కొన్బి కామ్‍ కర్సెకొయినీ, ");
INSERT INTO vgr_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","మె ఆ ములక్మా ర్హయ్యోతెదె ఆ ములక్మా ఉజాలుహుయిన్‍ ర్హయీస్కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","యో అంబోలీన్‍ జమీన్‍ప్పర్‍ థూకీన్‍ థూక్తి ఛిక్కడ్‍ కరీన్‍ ఇనా ఢోలాప్పర్‍ ఛిక్కడ్నా లొథిన్‍; ");
INSERT INTO vgr_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","“తూ సిలోయమా కోనేర్‍కనా జైన్‍ ఇన్మా ధొయిలాకరి” బోల్యొ, సిలోయమ్కరి వాత్నా అర్థం బోలిమొక్లొ. యో జైన్‍ డోలా ద్హోయిలీన్ ఢోలవాలొహుయిన్‍ ఆయొ. ");
INSERT INTO vgr_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","ఇనటెకె అజు బాజును అద్మి, యో మాంగిఖావాలుకరి ఇనేతి అగాఢి దేఖ్యుహుయు ఆ బేసీన్ మాంగవాలు కాహేనా? కరి బోల్యా. ");
INSERT INTO vgr_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","ఆస్కరి థొడుజనూ ఆకాహేకరి అనింతరస్‍ బుజేక్‍ జన్నుకరి అజు థోడుజను బోల్యు యోహుయితో మేస్కరి బోల్యు ");
INSERT INTO vgr_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","ఇవ్నే, తునా కిమ్‍ దేఖాంకురాస్‍ కరి ఇన పుఛ్చావమా; ");
INSERT INTO vgr_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","యో బోల్యు యేసుకరి ఏక్‍ అద్మి చిక్కడ్‍ కరిన్‍ మారఢోలఫర్‍ లోథిన్‍ తూ సిలోమయా కోనేర్కన జైన్‍ దోయిలాకరి మారేతి బోల్యొ; తెదె మే జైన్‍ దోయోతెదె ఖోలాయుకరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","ఇవ్నే, యో కెజ్గఛాకరి పుఛ్చావమా, యో కెజ్గాఛాకి మన మాలంకొయినీకరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","తెదె ఇనేహుః అగాఢి కాణుహుయిన్‍ ఛాతె ఇనా ఇవ్నే పరిసయ్యూల్‍కనా బులైలీన్‍ గయ్యూ. ");
INSERT INTO vgr_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","యేసు చిక్కడ్ కరీన్‍ ఇనా ఢోళ ఖొలాయూతె ధన్‍ ఆరమ్‍కరను ధన్‍ ");
INSERT INTO vgr_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","యో కిమ్‍ నజర్న పొంద్యోకి ఇనాగూర్చిన్‍ అజేక్‍ ఛోట్‍ పరిసయ్యూల్బి ఇన పుఛ్చావమా యో, మార ఢోలాఫర్‍ ఛిక్కడ్‍ లఘాడామా మే దోయిలీన్‍ నజర్నా పోందిలిదో కరి ఇనేతి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","హుయితోబి పరిసయ్యూల్మా థోడుజను, ఆ అద్మి ఆర్మనుధనే ఆచరించుకరస్‍ కొయిని ఇనాటెకె దేవ్కన్తు ఆయుతే అద్మి కాహేకరి బోల్యా, బుజు థోడుజను, పాప్‍హుయోతె అద్మి ఆజాత్నూ సూచక క్రియల్నా కిమ్‍ త్యోబి కరూకరస్‍కరి; ఇమాస్‍ ఇవ్నామా భేదును పడ్యాగు. ");
INSERT INTO vgr_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","ఇనటెకె ఇవ్నే బుజు యో కాణుఅద్మితీ యో తరా ఢోలా ఖొలాయో ఇనటేకే తు ఇనలిన్‍ సాత్‍లయిజావుంకరస్‍ కరి పుఛ్చావమా కాణు అద్మి యో ఏక్ ప్రవక్త కరి బోలస్‍ ");
INSERT INTO vgr_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","యో కాణు రాహీన్‍ ఢోలాన పొందోకరి యూదుల్‍ నమ్యకొయిని ఢోలనపోందుతే అద్మిను ఆయా, భా న బూలాయిన్‍ ");
INSERT INTO vgr_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","కాణుహుయిన్‍ ఫైదాహుయూకరి బోల్యతె తుమారొ ఛియ్యో ఆస్నా? ఇమ్‍హుయుతో హంకె ఆకీమ్ దేఖూకరస్ కరి ఇవ్నా పుఛ్చావమా. ");
INSERT INTO vgr_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","ఇనటేకె ఇను ఆయా భా బోల్యా, ఆ హామారో ఛియ్యోకరి ఆ కాణుహుయిన్‍ ఫైదాహుయోకరి హామ్న మాలం. ");
INSERT INTO vgr_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","హాంకె ఆ కింమ్‍ దేఖుకరస్కీ హామ్న మాలంకోయిని; కోన్‍ అనా ఢోలాన ఖోలాయోకీ యోబి హామ్న మాలంకొయిని; పన్కి అనామాలం అనాస్‍ పుఛ్చావో ");
INSERT INTO vgr_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","ఇనా ఆయాభా యూదుల్‍నా ఢరిజైయిన్‍ ఇమ్మస్‍ బోలస్‍; ఆ వుంబార్‍వలో, ఇనాస్‍ పుఛ్చావో; ఇను సంగతి యో బోల్లిసే కరి ఇనేతి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","హుయుతోబీ ఇనా ఆయా భా, యో ఉంబ్బర్వా‍లో ఇనాస్‍ పుఛ్చావో కరి బోల్యా. ");
INSERT INTO vgr_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","“ఇనటెకే ఇవ్నే కాణుహుయిన్‍చ్ఛాతే అద్మినా బెంమ్మాని ఛోట్‍ బులాయ్‍ మంగాయిన్‍ దేవ్నా డరావాలోహుయోతొ మహిమపరచీన్‍; ఖాఛి బోల్కరి” బోలమా. కాణు యో పాపికీ కాహేకీ మన మాలంకొయిని, ");
INSERT INTO vgr_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","“ఇనాటేకె ఏక్‍ మాత్రం మన మాలం; యో కాణు హుయిన్‍ థో. హంకే దేఖూకరస్‍ కరి” బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","ఇనటెకె ఇవ్నే, యో తునా సాత్‍ కర్యో తార ఢోలాకింమ్‍ ఖొలైగుకరి ఇనా బుజేక్‍ ఛోట్‍ పుఛ్చావమా. ");
INSERT INTO vgr_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","యో కాణు, అనేఖూ అగఢిస్‍ తుమారేతి బోల్యోథో. పన్కి తుమే ఖాంజ్యాకొయిని తుమే సాన బుజేక్‍చోట్‍ ఖాఖమాజ్నుకరి ఛా? తుమేబీ ఇన‍ సిష్యుల్‍ హోనుకరి కోరిలేంక్రస్కీ ఇమ్కరి ఇవ్నేతి బోలమా. ");
INSERT INTO vgr_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","ఇనాటెకె ఇవ్నే, తూస్‍ ఇనో సిష్యుడ్‍; హామే మోషేనా సిష్యుల్‍కరి బోల్యా. ");
INSERT INTO vgr_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","దేవ్‍ మోషేతీ వాతె బోలాస్కరి మాలంకర్యు; పన్కి ఆ కెజ్గాతి ఆయోకి హామ్నా మాలంకొయినీ, కరి బోలీన్‍ ఇనా గట్టీతి బోల్యూ. ");
INSERT INTO vgr_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","ఇనటేకె యో అద్మి, అజు యో కిజ్గాతి ఆయోకీ తుమ్నా మాలంకోయినీతె అష్యంమాస్‍; హుయుతోబీ యో మారఢోలా ఖోలాయియోకరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","దేవ్‍ పాపుల్ను మానవీ ఖాంజాకోయినికరి హామ్న మాలం; కోన్బీహో దైవభక్తుడ్ హుయిన్‍ ఇను చిత్తంతీస్‍ హుయుతో, యో ఇను వాత్నా హఃఛే. ");
INSERT INTO vgr_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","ఫైదాకంతు యో కాణు అద్మిను ఢోలాన కోన్బీ ఖోలాయుతిమ్‍ హంకెతోడి కెదేబి కర్యుకొయిని. ");
INSERT INTO vgr_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","ఆ దేవ్కంతీ ఆయుతే అద్మి నావుసేతో సాత్బీ కోకరస్నీకరి ఇవ్నేతి బోలస్‍. ");
INSERT INTO vgr_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","ఇనటేకె ఇవ్నే, “తూ ఖాలి పాపిహుయిన్‍ ఫైయిదాహుయోతె; తూ హామ్నా బోధించన ఆయోసూకరి” ఇనేతి బోలీన్‍ ఇనా యాదుల్ను ప్రార్థనా జోగొమాతు బోలిమోక్లీదిదూ. ");
INSERT INTO vgr_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","పరిసయ్యుల్‍ ఇనా బోలిక్యులీదుకరి యేసు హాఃజీన్‍ ఇనా మాలంకర్లీన్‍ తూ అద్మినుఛియ్యానఫర్‍ విష్వాస్‍ రాఖూకరాస్నా కరి పుఛ్చావస్‍. ");
INSERT INTO vgr_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","ఇనటేకె ఇవ్నే, మాలిక్‍ మే ఇనపర్‍ విష్వాసంరకనా యో కోన్‍కరి పుఛ్చావమా. ");
INSERT INTO vgr_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","యేసు, తూ ఇనా దేఖుకరస్ని; తారేఖు వాతె బోలుకరతే అద్మి యోస్‍ కరి బోలస్‍ ");
INSERT INTO vgr_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","ఎత్రామాస్‍ యో, ప్రభూ, మే విస్వాసం కరుకురుస్‍ కరి బోలీన్‍ గుడ్యామేట్పర్ఆయిన్‍ ఇనా ఖాలామ్‍ కర్యొ. ");
INSERT INTO vgr_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","తెదె యేసు, “దేఖో కొయిన్‍తే అద్మి యో దేక్యుకరస్, దేక్కావాలు అద్మి కాణుహుసే, కరి న్యావ్‍నా నిమిత్తంతీ యో మూలక్మా ఆయోకరి” బోలస్‍ ");
INSERT INTO vgr_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","ఇనటటేకె ఛాతే థోడుజను పరిసయ్యుమా ఆ వాతేనా ఖంజీన్, హామేబి కాణు అద్మిసూ కరి పుఛ్చాయా. ");
INSERT INTO vgr_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","ఇనటేకె యేసు, తుమే కాణు అద్మి హుయాతో తుమ్నా పాప్‍ కోయిని పన్కి దేఖుకరస్కరి తుమే హంకే బోలిలేంక్రస్‍ ఇనటేకె తూమరు దోషసిక్చ ఉబ్రిన్‍ ఛాకరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","మే హాఃఛిస్‍ బోలుకురూస్‍ మ్హేండను దొడ్డిమాతూ జావకొయినీతింమ్ అలాదు వాట్మాతూ ఛడీన్‍ జవ్వాలో ఛోట్టుబి లపాడవాలోహుయీన్‍ ఛా ");
INSERT INTO vgr_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","దొడ్డీను వాట్మతూ జావ్వాలొ మ్హేంఢన కావ్లీహుయిన్‍ ఛా ");
INSERT INTO vgr_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","ఇన ధర్వాజు కాడాస్‍ మ్హేంఢా ఇను అవాజ్నా హఃమ్జస్‍ యో ఇను ఖూద్ను మ్హేండనా నామ్‍ మ్హేలీన్‍ మైహీ బులాయిన్‍ లీన్జాస్‍ ");
INSERT INTO vgr_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","బుజు యో ఇనా ఖుద్ను మ్హేండా హాఃరవ్నా మాహీ బులైలీన్‍జాస్‍ మ్హేంఢాహూః అగాడి జాస్‍ మ్హేంఢా ఇను ఆవాజ్నా మాలంకరిలేస్‍ ఇనాటెకె ఇవ్నే ఇనా కేడేజాసే, ");
INSERT INTO vgr_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","అలద్వాను ఆవాజ్నా ఇవ్నే మాలంకోకరానీ ఇనటేకె ఆలద్వాన కేత్రుకరితోబి కేడేకోజైని ఇనాకంతు మిలైలిజాస్‍ కరి తూమరేతి హాఃచీతి బోలుకారుస్ కరి ఇవ్నేతి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","ఆ ఉపమానం యేసు ఇవ్నేతీ బోలస్‍ పన్కి యో ఇవ్నేతి బోల్యోతె సంగతుల్‍ కేజాత్నుకి ఇవ్నే గ్రహించ్యా కొయిని. ");
INSERT INTO vgr_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","ఇనటేకే యేసు బుజేక్‍చోట్‍ మే హాఃఛిస్‍ బోలుకురస్‍ ఇవ్నేతీ బోల్యొ, మ్హేంఢాజావను ధర్వాజు మేస్‍; ");
INSERT INTO vgr_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","మరేఖూ అగాడి ఆయుతే ఇవ్నేఖారు ఛోటుబి, లపడిలివ్వాలు హుయిన్‍ ఛా! మ్హేంఢా ఇన ఆవాజ్నా ఖాంజాకోయిని. ");
INSERT INTO vgr_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","మేస్‍ వాట్వాలొ; మారవలనా కోన్బీ మాహీ గయూతో యో బచ్చిజావాలోహుయిన్‍ మాహీ జాతుహుయిన్‍ భాదర్‍ ఆవ్తూహుయిన్‍ ఛారో ఛార్తూరాస్‍ ");
INSERT INTO vgr_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","చొట్టు, చోర్కరనబి, మర్రకనాబి, నాషనం కరనటేకె ఆవస్‍ పన్కి బుజు సానటెకేబి కోఆవని; మ్హేండనా జీవమ్‍ కలగనాటేకె ఇవ్నే సమృధ్దిగా కలగానటెకే మే ఆయోకరి తుమారేతి నిస్చయంతి బోలుకరూస్‍. ");
INSERT INTO vgr_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","మే మ్హేండనా అషల్ చరావ్వాలొ; అషల్ చరావ్వాలొ మ్హేండనటెకె ఇను జాన్నబి దిసే. ");
INSERT INTO vgr_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","జితగాడ్‍ మ్హేంఢాన కావిలి కాఖావాలో కాహే; ఇనటేకే మ్హేంఢా ఇను కాహే కాబట్టి జరాక్‍ ఆవాను దేఖీన్‍ మ్హేంఢానా బేందీన్‍ మిలైయిదేస్‍ జరాక్‍ యో మ్హేంఢానా ధరిన్ గాల్లీనా ఏక్‍ కారకీదేస్‍ ");
INSERT INTO vgr_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","జితాగడ్‍ జీతంనాటేకెస్‍ సోచాస్‍ ఇనటెకె మ్హేంఢానా పటింకొయిన్‍తిమ్‍ మీలైయిదేస్‍ ");
INSERT INTO vgr_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","మే మ్హేంఢానా ఆస్సల్‍ కావిలి కాఖావాలో; ");
INSERT INTO vgr_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","భా మన కిమ్‍ మాలంకరస్‍కీ మే భాన కిమ్‍ మాలంకరుకి ఇమాస్‍ యో మార మ్హేంఢానా మాలంకరుకరస్‍ మార మ్హేంఢ మన మాలంకర్సే, బుజు మ్హేంఢానాటెకె మారు జాన్‍బి దేవుకరుస్‍ ");
INSERT INTO vgr_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","ఆ మ్హేండను దొడ్డి మంధా కహేతీమ్‍ ఆలాద మ్హేంఢాను మంధా మన ఛా! ఇనబీ మే హాక్కాలిలీన్‍ ఆవుస్‍; యోమంధా మారి ఆవాజ్నా ఖాంచ్చె, తెదె గుంపుబి మ్హేంఢాన కావ్లి కాఖావాలోబీ ఉబ్రిర్హాసే. ");
INSERT INTO vgr_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","మే ఇనా బుజు లీన్‍ అవ్నుకరి మారు జాన్నా బేందుకరూస్‍; అనహాఃజె మారొ భా మన ఫ్యార్‍ కరూకరస్‍ ");
INSERT INTO vgr_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","కోన్బీ మార జాన్‍లిసేకొయిని; మారు మేస్‍ ఇనా బేందుకరుస్‍; ఇనా బేందానటెకె మన అధికారం ఛా, అజు ఇనా పాచుఫారీన్ లేవనటేకె మన అధికారం ఛా; మార భానటెకె ఆ ఆజ్ఞాపోందుకరస్‍ కరి బోలస్‍ ");
INSERT INTO vgr_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","ఆ వాతేవ్నా లీన్‍ యూదుల్‍మా బుజు భేదల్‍ పడైయిజాస్‍ ");
INSERT INTO vgr_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","ఇవ్నమా కెత్రూకిజణు, యో భూత్‍ ధరాఖుతే అద్మిబి, బుజు పగల్‍ అద్మి ఇని వాతె సాన హఃమ్జకరస్‍ కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","బుజు థోడుజాను ఆ భూత్‍ధరుతే రాఖువాతే అద్మిను వాతె కాహే; భూత్‍‍ కాణు అద్మిను ఢోలాన ఖోలావుసే, కరి బోల్యా. ");
INSERT INTO vgr_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","యో థండ్నుధన్‍ ఆలాయంను ప్రతిష్ఠత పండుగా యేరుషలేమ్‍మా జరుగూకరాస్‍ ");
INSERT INTO vgr_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","తెదె యేసు దేవును మందిర్‍మా సోలొమోన్‍ను పాందిల్నా హేట్‍ ఫరుకరామా, ");
INSERT INTO vgr_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","తెదె యూదుల్ ఇనా అస్పీస్‍ మలిన్‍ హుయిన్‍ అమ్‍ బోల్యా, కెత్రాధన్‍ అనుమానంమా ర్హాస్‍? తూ క్రీస్తు హుయోతో హామరేతీ ఖూదు బొల్‍ ");
INSERT INTO vgr_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","అనటేకె యేసు మే మారేతి అగాడిస్ బోల్యోతొ పన్కి తుమే నమ్యాకోయిని; మే మార భాన నామ్తి కరుకరతే క్రియాల్‍ మానలిన్‍ సాబుత్ బోకుకరస్‍ ");
INSERT INTO vgr_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","హుయుతోబి తుమే మార మ్హేంఢామా చేమ్‍ద్యాహుయా కాహే ఇనటెకె తుమే నమ్మాకోయిని, ");
INSERT INTO vgr_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","మార మ్హేంఢా మారు ఆవాజ్‍ ఖాంమ్చే మే ఇవ్నా మాలంకరిలేవుస్‍ ఇవ్నే మారకేడె ఆవ్సే. ");
INSERT INTO vgr_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","మే ఇవ్నా నిత్యజీవంనా దేవుంకురుస్‍ ఇనటెకె ఇవ్నే కెదేబి మిట్‍సే కొయిని, కోన్‍బి ఇవ్నా మార హాత్మతి ఖేఛిలిసేకొయిని. ");
INSERT INTO vgr_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","యో మ్హేంఢాఖారు మన దీరాక్యోతె మారొ భా ఖారేతిబి మోటొఅద్మి. పన్కి కోన్బి మార భా నహాత్మతూ కోన్బి ఇవ్నాఛిన్వాసేకొయిని. ");
INSERT INTO vgr_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","మే బి బుజు భాబి ఏక్‍హుయిన్‍ ఛియ్యేకరి బోల్యొ ");
INSERT INTO vgr_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","యూదుల్‍ ఇన మార్నుకరి పత్రో హత్మా పల్లేవామా! ");
INSERT INTO vgr_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","ఇనటేకె యేసునె ఇవ్నేతి అమ్‍ బోల్యొ, భాకన కంతూ కెత్రూకి అషల్ క్రియల్‍నా తుమ్న వత్లో; ఇన్మా కెహూ క్రియల్నాటెకె మన ఫత్రేఖా మార్సుకరి ఇవ్నా పుఛ్చాయో ");
INSERT INTO vgr_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","యూదుల్‍ యేసుతి, తూ అద్మిర్హహీన్‍ దేవ్కన బరోబ్బర్‍కరి బొల్లేంకరస్‍; అనటెకె దేవ్నా ఛాడికరుకరాస్‍ అనటెకె తున ఫత్రాంతి మారుకర్యేస్‍ పన్కి అష్యల్‍కామ్‍ కర్యోకరికాహే కరిఇనేతి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","అనహాఃజె యేసునె అమ్ బోల్య తుమారు ధర్మషాస్ర్తంమా తుమేస్ దేవ్కరి లిఖ్కారూస్‍కొయిన్నా? ");
INSERT INTO vgr_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","లేఖనాల్ను ఫాల్తు హోనుకరి కాహేనా, దేవ్నిలేఖనాల్‍ కినా ఆవస్కి, ఇవ్నేస్‍ దేవస్కరి బోల్లిలిదుతో మే దేవ్ని ఛియ్యోకరి బోల్యోకరి, ");
INSERT INTO vgr_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","భా ప్రతిష్ఠకరిన్‍ ఆ ములక్మా మొక్లొతె ఇవ్నేతి తూ దేవ్నా దూషణ కరూకరస్కరి ఇవ్నేతి బోల్యు? ");
INSERT INTO vgr_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","మే మారో భా ను క్రియల్నా నా కర్యోతోతెదె మన నమ్మనొకొ. ");
INSERT INTO vgr_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","కర్యొతొతెదె మన నా నమ్యతోబి భా మారఖామె మే భానఖామేబి ఛియ్యేకరి తుమే గ్రహించిన్‍ మాలంకరతిం యోక్రియల్‍నా నమ్మనాటెకె ఇవ్నేతీ బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","ఇవ్నే బుజు ఇనస్‍ ధర్నూకరి దేక్యూ పన్కి, యో ఇవ్నహాత్‍మతూ చుక్కాలీన్‍ గయో. ");
INSERT INTO vgr_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","యొర్దాను నది పార్లిబజు యోహాన్‍ అగాడి బాప్తిస్మమ్‍దిదోతె జొగొమా పరీన్‍జైయిన్‍ ఎజ్గారయ్యో. ");
INSERT INTO vgr_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","కెత్రూకిజణు ఇనకనా ఆయిన్‍ “యోహాన్‍ సుచకా క్రియల్‍నాబి కర్యోకొయిని, పన్కి అనగూర్చి బోల్‍తెసంగతుల్‍ హాఃఛిచిస్‍కరి” బోల్యు. ");
INSERT INTO vgr_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","ఎజ్గా కెత్రూకిజణు ఇనఫర్‍ విష్వాస్‍ కర్యు. ");
INSERT INTO vgr_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","మరియకరి బుజు ఇని భేనెహుయీతె మార్త కరి ఇను గామ్‍ హుయుతె బేతనియమా ఛాతె లాజర్‍కరి ఏక్జనో రోగ్వాలో థో. ");
INSERT INTO vgr_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","ఆ మరియా ప్రభువున అత్తర్‍ లగాఢీన్‍ ముడ్‍క్యాన కేహ్‍నా తేల్‍ ఇను హాతేలి నుఛ్చితే మరియనొ భై. ");
INSERT INTO vgr_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","ఇని భేనె ప్రభూ, థూ లాఢ్‍కర్యొతె యో రొగ్తీ ఛాకరి, ఇనకనా వర్తమానమనా మొక్లొ. ");
INSERT INTO vgr_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","తెదె “యేసు ఆ హాఃజీన్‍ ఆ రోగ్ మర్రాఖనటేకె ఆయుకొయిని పన్కి, అనటేకే దేవ్‍నో ఛియ్యో ఇనుటేకె మహిమపరచబడ్నుతింమ్ దేవ్ను మహిమనటేకె ఆయుకరి” బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","యేసునే మార్తనఫర్‍ ఇను భేనె బుజు లాజర్నా ఫ్యార్‍కర్యో. ");
INSERT INTO vgr_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","ఇనే రొగాఢిహుయిన్‍ ఛాకరి మాలంహువమా, యేసు ఛాతె జొగొమా బుజు భే, ధన్‍ థో. ");
INSERT INTO vgr_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","అనుపాసల్‍ ఇనే “అప్నె యూదయమా ఫరిన్‍ జయ్యేకరి” ఇ‌ను సిష్యుల్‍తి బోలమా ");
INSERT INTO vgr_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","ఇ‌ను సిష్యుల్‍ బోధకుడ్‍ హంకేస్‍ యూదుల్‍ తున పత్రవ్‍తి మార్నుకరి దేకుకరస్‍ని, బుజు ఎజ్గా పరీన్‍ జియ్యానా? కరి ఇనా పుఛ్చాయా. ");
INSERT INTO vgr_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","అనటేకే “యేసు, ధోపారే భార ఘంటాఛా, కాహేనా ఏక్జనో ధన్నూచాలీన్ గయో. తెదె ఆ ములక్నూ ఉజాలూ దేక్చే. పన్కి, పిస్లీన్‍ పడిజాసెకొయిని. ");
INSERT INTO vgr_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","పన్కి రాత్నివఖాత్‍ ఏక్జనొ చాల్యొతెదె ఇనకనా ఉజాలుకొయిని, అనహఃజే పడిజాసేకరి” బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","ఇనే ఆ వాతె బోలీన్‍ పాసల్తీ అప్న దోస్త హుయోతే లాజర్‍ నిందార్‍మా ఛా ఇనా ఖూద్రావనటేకె జావుంకురు కరి ఇవ్నేతి బోలామ, ");
INSERT INTO vgr_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","సిష్యుడ్‍ ప్రభూవా ఇనే ఖూత్యోతో అజు ఖుదర్‍సేనా కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","యేసు ఇను మరణ్నఖాజే ఆ వాత్‍ బోల్యొ. పన్కి, ఇవ్నే ఇను ఖావను ఆరామ్‍నాఖాజె బోల్యుకరి రహిగు. ");
INSERT INTO vgr_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","అనటేకే యేసు లాజరు మరిగొ, ");
INSERT INTO vgr_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","అనహాఃజె యేసు లాజర్‍ మరిగయో, తుమే నమ్ఛుతింమ్‍ మే ఎజ్గాకోథోని, కరి తుమారబారేమా ఖుషీహుయిరోస్‍ హుయితోబి ఇనకన అప్నెజియ్యే, ఇవ్నేతి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","అనటేకే దిదుమ కరి బోలతె తోమా “బోధకుడుకెడె మరిజవాన అప్నేబి జియ్యెకరి” ఇనకెడె ఛాతె సిష్యుల్నా బోల్యు. ");
INSERT INTO vgr_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","యేసు ఆయిన్‍ తెదేస్‍ యో ఛార్‍ ధన్‍ సమాధిమా రయ్యోకరి మాలంకర్లిదొ. ");
INSERT INTO vgr_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","బేతనియ యెరూషలేమ్‍నా హాఃమేస్‍ రైహితూ ఇనఖామే బరాబ్బర్‍ తీన్‍ మైల్‍ దూర్‍ థూ. ");
INSERT INTO vgr_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","అనటేకె యూదుల్‍మా ఘనూ అద్మి ఇవ్ని భైయేనా మరాన్‍ గూర్చిన్‍ మార్తనా బుజు మరియనా ఖాంజావనటెకే ఆవ్నకన ఆయిన్‍ థా ");
INSERT INTO vgr_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","తెదె మార్త, యేసు వలావాస్కరి ఖంజీన్‍ ఇన మల్నుకరి గెయి. పన్కి, మరియా ఘర్మా బేసిన్‍ తి. ");
INSERT INTO vgr_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","తెదె మార్తనె యేసుతి, ప్రభువా తూ అజ్గ రయోతో మార భై మర్యోహోత్కొయిని కరి బోలి. ");
INSERT INTO vgr_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","హంకేబిహొ తూ దేవ్నా సాత్‍ మాంగ్యొతోబి దేవ్‍ తునబి దెవ్వాయి జాసెకరి మే సోఛ్చిరాక్యోస్‍ ");
INSERT INTO vgr_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","యేసునె తారొ భై బుజు ఉట్సేకరి, బాయికోతి బోలమా ");
INSERT INTO vgr_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","మార్త ఇనెతి ఆఖారి ధన్మా జీవిన్‍ ఉట్సేకరి మనమాలం. ");
INSERT INTO vgr_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","అనటేకే యేసు బోల్యొ మారన్‍ మాతు జీవిన్‍హుయ్‍ర్రొతె, జివీన్‍ఛాతే మేస్‍; మన నమ్మా వాలు మరిగుతోబి జీవ్సె, ");
INSERT INTO vgr_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","మారప్పర్‍ విష్వాస్‍ రాఖవాలో హర్యేక్‍జనూ కెదేబి మర్సేకోయిని. ఆవాత్‍ నమ్ముకరస్నాకరి యో బాయికోనా పుఛ్చాయో. ");
INSERT INTO vgr_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","బాయికో “ఓహో, ప్రభూ తూ ములక్నాటేకె ఆవను ఛాతె దేవ్నోఛియ్యోహుయోతె క్రీస్తుకరి హమే నమ్ముకరస్కరి” ఇనేతి బోలి. ");
INSERT INTO vgr_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","బద్మా మార్త ఆవాత్‍ బోలిన్‍ జైయిన్‍ బోధకుడునా; ఆయిన్‍ తున బులాంకరస్కరి ఇను భేనెహుయితె మరియానా ఆఖ్రాతీ బులాయు. ");
INSERT INTO vgr_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","తెదె బాయికో హాఃజీన్‍ ఎగ్గీస్‍ ఉట్టీన్‍ ఇనకనా గయీ. ");
INSERT INTO vgr_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","యేసు బుజుబి యోగామ్మా నాఆవమా మార్త ఇన మల్యాతే జోగొమాస్‍ రయ్యోథో. ");
INSERT INTO vgr_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","అనహఃజే ఘర్మా మరియతీబి ర్హహీన్‍ బాయికోనా ఓదార్చుకరతె యూదుల్నా మరియ ఎగ్గీస్‍ ఉట్టీన్‍ జావను దేఖిన్‍ ఆ బాయికో గొర్రాడుకన రొవ్వానటెకె ఎజ్గా జంకరస్కరి సోచిలీన్‍ బాయికోనకెడె గయూ. ");
INSERT INTO vgr_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","ఎత్రమస్‍ మరియా యేసుఛాతె జొగొకన ఆయిన్‍ ఇన దేఖిన్‍ ఇను గోడఫర్‍ పడీన్‍ ప్రభూ తూ ర్హాయోతొ మార భై మర్యోహోత్‍ కొయినీకరి బోలి. ");
INSERT INTO vgr_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","యో బాయికొ రొవ్వానుబి, బాయికోనకెడె ఆయుతె యూదుల్బి రొవ్వాను యేసునె దేఖిన్‍ గబ్రాయిన్‍ ఆత్మమా కుంగావ్తో ");
INSERT INTO vgr_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","ఇన కెజ్గా రాక్యాస్‍కరి పుఛ్చావమా. ఇవ్నే ప్రభూ ఆయిన్‍ దేక్కరి ఇనేతి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","యేసునే ఆంజు ఖాడ్యో. ");
INSERT INTO vgr_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","అనటేకే యూదుల్‍ ఇన కింనితర ఫ్యార్‍కరోకి దేక్కోకరి బొల్లిదా. ");
INSERT INTO vgr_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","హుయుతో ఇవ్నమా థోడుజను ఆ కాణోనా ఢోలాకొల్యొహొతే అనే, అన మరకొయింనితింమ్‍ కర్సెకోయిన్నా? కరి బోల్యా. ");
INSERT INTO vgr_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","యేసు బుజు మహ్హీస్ బాదతి సమాధికనా అయిన్‍ కేవు గుహాను ధర్వాజునా బండో బేందిరాక్యుతు యో సమాదికనా గయో. ");
INSERT INTO vgr_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","యేసునె యో బంఢోనా కనాక్కరి బోలమా, మరీగుతె ఇని భేన్‍హుయితె మార్త ప్రభూ, ఇనే మరిజైయిన్‍ ఛార్రోజ్‍ హుయ్గు. అనహఃజే వాఖ్‍ మార్సేకరి ఇనేతి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","అనటేకె యేసు ఇనేతి బోల్యొ, తూ నమ్మితోతెదె దేవ్ని మహిమనా దేఖిస్‍కరి మే తారేతీ బోల్యొకొయిన్నా. ");
INSERT INTO vgr_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","తెదె ఇవ్నే యో బాంఢోనా కనాక్యూ యేసునె ఢోళాపాఢీన్ “భా, తూ మారు మనవిన ఖాంజ్యో అనటేకే తూన కృతజ్ఞతల్‍ చెల్లించుకరుస్‍ ");
INSERT INTO vgr_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","తూ కెదేబి మారు మనవిన ఖాంజుకరస్‍కరి మే దిల్మాకర్యాకోస్‍ పన్కి, తూ మన మొక్లోకరి అస్సిస్‍ ఉబ్రిన్‍ఛాతె ఆ అద్మిహఃర్వనా నమ్మతింమ్‍ ఇవ్నఖాజె ఆవాత్‍ బోల్యొకరి” బోల్యు. ");
INSERT INTO vgr_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","యో ఇమ్నితర బోలిన్‍ లాజర్, భాధర్‍ అవ్‍కరి గట్టితి బోలమా ");
INSERT INTO vgr_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","మరిగుతే యో హాత్‍ గోడా లుంగ్డవ్తీ బందాయిన్‍ భాధర్‍ ఆయో ఇను మోఢన రుమాల్‍ బాందిరాక్యుతు. తెజాత్నో యేసు తుమే “ఇను కట్లునఛోడీన్‍ జావదాకరి” ఇవ్నేతి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","అనహాఃజె మరియకన ఆయిన్‍ ఇనే కర్యోతె కార్యల్‍నా దేక్యుతె యూదుల్మా ఘాణుజను ఇనపర్‍ విష్వాషంనరాక్యూ, ");
INSERT INTO vgr_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","పన్కి ఇవ్నమా థోడుజను పరిసయ్యల్కన ఆయిన్‍ యేసు కర్యొతె కార్యాల్‍నా గూర్చి ఇవ్నేతి బోల్యు. ");
INSERT INTO vgr_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","అనటేకే ప్రధాన్‍యాజకుల్‍ పరిసయ్యుల్‍ కెవ్డుకి మోటు సభనా జోడ్‍కరిన్‍ అప్నె సాత్‍కరుకరియస్‍? ఆ అద్మి కెత్రూకి సూచక క్రియల్‍నా కరుకరస్‍కి. ");
INSERT INTO vgr_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","అప్నే ఇనా అమ్‍ దేక్తా గప్చూప్‍రయ్యాతో హఃరుజనూ ఇనప్పర్‍ విష్వాషం రాక్చ తెదె రోమీయుల్‍ ఆయిన్‍ అప్ను మందిర్నా, అప్నూ అద్మినా కోన్డిలిసేకరి బోల్యు. ");
INSERT INTO vgr_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","హుయుతో ఇవ్నమా ఏక్జనో కయపకరి నామ్‍వాలు యోవరఖాన ప్రధాన్ యాజకుడ్ “తుమ్న సాత్బీ మాలంకొయిని” కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","యో అజు, “దేహ్క్ ఖారూ నాషనంహువణూ బదుల్‍ అద్మినటెకె ఏక్ అద్మి మర్జావను అషల్ ఆ తుమ్న సోచిలేంకరస్‍” కరి ఇవ్నే బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","ఇను యోస్‍ అమ్‍ బోల్యో కొయిని పన్కి, యోవరఖ్ నా ప్రధాన్‍యాజకుడ్‍ హుయిన్‍ థో ");
INSERT INTO vgr_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","అనటేకే యేసు “యో యూదుల్నా‍టేకెస్ కాహేతింమ్‍ నాసిగుతే దేవ్ని జానమ్‍ ఏక్నితర జమకరనాటేకె, మరణాటేకె హుయిన్‍ ఛా” కరి ప్రవచించ్యో. ");
INSERT INTO vgr_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","యుదా అధికారుల్‍ యో ధ‍న్తూ నిఖీన్‍ ఇవ్నే యేసున మర్రాక్నూకరి సోచలగూ. ");
INSERT INTO vgr_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","అనహాఃజె యేసునె తెప్తూధరిన్‍ యూదియామా భాధర్‍ పరకొయినీతింమ్‍ ఎజ్గాతూ నిఖీన్‍ ఝాడినూ హాఃమేను జొగొమా ఛాతె ఎఫ్రాయికరి గామ్మా జైయిన్‍ ఎజ్గా ఇను సిష్యుల్‍నాకేడె మలీన్‍ రయ్యో. ");
INSERT INTO vgr_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","బుజు యూదుల్ను పస్కాపండగను ధన్ హాఃమేహుయిన్‍ రయ్యూ. అనహాఃజె కెత్రూకిజణు ఇవ్నే యినూ సుద్ధి కర్లేవనటేకె పస్కానుపండగ ఆవకొయింతె అగాఢీస్‍ గామ్తూనికిన్‍ యెరూషలేమ్మా ఆయూ. ");
INSERT INTO vgr_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","ఇవ్నే యేసునా ధూండ్తూహుయిన్‍ మందిర్‍మా ఉబ్రీన్‍ తుమ్న సాత్‍ సోఛ్చుకరాస్‍? ఇనే పండగనా ఆవ్సే కోయినా సానటేకెకరి ఎక్తి ఏక్‍ బొలిదా. ");
INSERT INTO vgr_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","పన్కి, ప్రధానయాజకుల్బీ పరిసయ్యల్బీ ఇనే ఎజ్గా ఛాతె కినాబిమాలంహుయుతో హమే ఇనా ధర్లేవనాటెకె హమ్నా మాలంకరావోకరి ఆజ్ఞదిన్‍ రయ్యో. ");
INSERT INTO vgr_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","అనటేకె యేసు యో మర్రణ్‍మతూ ఉట్టాడెతె లాజర్‍ థోతే బేతనియమా పస్కాపండగనా ఛో ధన్‍ అగాఢీస్‍ ఆయు. ");
INSERT INTO vgr_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","ఎజ్గా ఇన ఖానునా బణయు, మార్త వడ్డించుకరాస్‍ లాజర్ ఇనేతి ధాన్‍ఖావన భేషుతె ఇవ్నమా ఏక్జనో. ");
INSERT INTO vgr_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","తెదె మరియ కంసేకంను మోల్ను హుయుతే అత్తర్నా ఆదులీటర్నూ అఛ్చు జటామాంసిను ఝాడు ఖాడుతే విలుహుయుతే సుంగంధను తేల్‍ యేసున గోఢన లగాఢీన్‍ ఇను మాథను ఖేహ్‍తి ఇను గోఢనా నుఛ్చీన్‍ యో ఘర్మా అత్తర్‍ను వాఖ్‍తి భరైగు. ");
INSERT INTO vgr_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","ఇను సిష్యుల్‍మతో ఏక్జనో కతో ఇన ధరాలిసేకరి ఛాతె ఇస్కరియోతు యూదా! ");
INSERT INTO vgr_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","ఆ అత్తర్‍సాన తీన్‍ఖో దేనారాల్‍నా ఏఛీన్‍ గరీబ్నా దిదుకొయినికరిబోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","యోఅమ్‍ బోల్యొతె గరీబ్‍ప్పర్‍ ష్రద్దహుయిన్‍ కాహేపన్కీ ఇనే ఛోర్‍రైహిన్‍ ఇనకన రప్యాను సంచిరవ్వామా ఇన్మా నాక్యూహు ఛోర్‍కర్తొహుయిన్‍ ఆయో అనటెకె ఇంమ్‍ బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","అనహాఃజె యేసు మన సమాధికరనూ ధన్మా గుర్తునితర బాయికోనా ఆ‍మ్నితరా కరదా; ");
INSERT INTO vgr_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","యేసు అమ్‍ బోల్యొ గరీబ్‍ కెదేబి తుమారకన ర్హాసే పన్కి, మేకెదేబి తుమారకెడె రైహిస్‍కొయిని. ");
INSERT INTO vgr_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","అనహఃజే యూదుల్మా గోప్ప అద్మిమ ఇనే ఎజ్గా ఛాకరి మాలంకరీన్‍ యేసున దేఖనా ఖాజేస్‍ కాహేతింమ్‍ మర్రాణ్‍మతూ యో ఉట్టాడొతె లాజర్నబీ దేఖనా ఆయూ. ");
INSERT INTO vgr_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","11","హుయుతే ఇనగూర్చి యూదుల్‍మా కెత్రూకిజనూ ఇవ్నా హఃరనబెందీన్‍ యేసుఫర్‍ విష్వాస్‍రాక్యూ. అనటెకె ప్రధానయాజకుల్‍ లాజర్‍నబి, మర్రాక్‍నుకరి సోచు. ");
INSERT INTO vgr_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","పాసల్‍ధన్‍ పస్కాపండగన ఆయుతె కెత్రూకి జనాభో యేసు యెరూషలేమ్‍మా వలావస్కరి హాఃజీన్‍ ");
INSERT INTO vgr_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","తెదె ఖర్జూరంను డాలియాన ధర్లీన్‍ ఇన మల్నూకరి జైయిన్‍ హోసన్నా! ప్రభువున నామ్తీగ వలావతె ఇష్రాయేల్‍నో రాజో ఆషిర్వాధించబడదా కరి ఛిక్రాన్‍ బేంద్యూ. ఇన మాలనాటేకె గయూ ");
INSERT INTO vgr_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","సీయోన్ను ఛోరి, ఢర్నొకో, హదేక్‍ తారో రాజో ఘదేఢను చెల్కాఫర్‍ బేసిగయో ");
INSERT INTO vgr_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","లేఖనాల్మా లిఖ్కారుతిమ్‍ యేసు ఏక్ న్హాను ఘదేడను చెల్కాన మాలంకరీన్‍ ఇనఫర్‍ వలోవాస్‍ ");
INSERT INTO vgr_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","ఇను సిష్యుల్‍ ఆవాత్‍ అగాడి గ్రహించకొయిని పన్కి, యేసుని మహిమ హుసెతెదె ఇనగూర్చిన్‍ లిక్కారుకరి, ఎత్రే‍స్‍ కాహెతిమ్‍ ఇవ్నె కర్యూతే ఇనుగూర్చి హఃయల్‍ కర్లీదు. ");
INSERT INTO vgr_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","యో లాజర్‍న సమాధిమతూ బులాయిన్‍ మరణ్‍మతూ ఇన ఉట్టాడోతెదె, ఇనకెడె తూతె అద్మి ఇను గురించి సాబుత్ బోల్యు. ");
INSERT INTO vgr_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","అనహాఃజె యో అద్భదాల్‍ కర్యోకరి అద్మియే ఖాంజిన్‍ ఇన మలనటెకె గయూ. ");
INSERT INTO vgr_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","అనహాఃజె పరిసయ్యుల్‍ ఏక్ను ఏక్ అప్ను కోసిష్‍ ఖారు‍ కింమ్ పా‍ల్తూ హుయుగయూతె దెక్కో. హదేక్‍ ములక్‍ఖారు ఇనపిటె చలిగయూకరి బొల్లిదు. ");
INSERT INTO vgr_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","యో పండుగమా ఆరాధన కర్నూకరి యేరుషలేమా ఆయూతె ఇవ్నమా థోడుజనూ గ్రీసుమా రైతు. ");
INSERT INTO vgr_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","ఇవ్నే గలిలయమా బేత్సయిదను హుయుతె చెంద్యు హుయు ఫిలిప్పుకన ఆయిన్‍ “ఖాయాబ్‍” హమే యేసున దేఖ్నూకరి ఇవ్నేతి బోల్యు. ");
INSERT INTO vgr_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","ఫిలిప్పునే ఆయిన్‍ అంద్రెయతి బోల్యూ, తెదె అంద్రెయబి ఫిలిప్పునే ఆయిన్‍ యేసుతి బోల్యా. ");
INSERT INTO vgr_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","అనటెకేస్‍ యేసు ఇవ్నేతి అంబోల్యొ అద్మినఛియ్యో మహిమపొందనుతూతె వక్హత్‍ ఆయ్రూస్‍ ");
INSERT INTO vgr_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","ఘౌను బింజోళ జమిన్‍ప్పర్‍ పఢీన్‍ నామర్యూతొ ఆ ఎక్కాస్‍హుయిన్‍ ర్హైజాసె ఆ మర్యూతొ తెదె ఘణూ పాయిదోనా దిసే ఖాఛితంతి బోలుకరుస్‍ ");
INSERT INTO vgr_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","ఇను జాన్న ఫ్యార్‍కరవాలో ఇన గమాయ్‍లిసే, ఆ ములక్మా ఇన జాన్నా దూషణకరవాలో నిత్యజీవంనటెకె ఇన బఛ్చాయ్‍లిసేకరి తుమారితి ఖాష్చితి బోలుకరూస్‍ ");
INSERT INTO vgr_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","ఏక్జనో మన ప్రచార్‍ కరుకురతెదె మారకెడె ఆవ్ను తెదె మే కెజ్గా రవుస్‍కి మార సేవకుడ్‍బి ర్హాసె, ఏక్జనొ మనసేవకర్యొతొ మార భా ఇన ఘనపర్చాసె. ");
INSERT INTO vgr_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","హంకె మార జాన్‍ గబ్రాతు ర్హంకరస్‍ మే సాత్‍బోల్లీస్? భా ఆ వఖాత్‍ నాఆవునుతింమ్‍ మన బఛ్చాడ్‍ “హుయుతోబి అనహఃజేస్ మే ఆ వఖాత్‍నా ఆయోతె, ");
INSERT INTO vgr_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","భా తారు నామ్నా మహిమపరచిలాకరి బోల్యొ” ఎత్రాస్మా మే ఇన మహిమపరిచోతొ బుజూ మహిమ పరిచిస్కరి ఆకాష్మతూ ఏక్ ఆవాజ్‍ ఆయూ. ");
INSERT INTO vgr_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","అనహాఃజె ఎజ్గా ఉబ్రీన్‍ ఖాంజుతె అద్మిఖారు ఇజ్లీకరి బోల్యు. బుజు థోడుజను “దేవ్నుదూత ఏక్జనొ ఇనేతి వాతె బోల్యుకరి” బోల్యు. ");
INSERT INTO vgr_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","అనటేకె యేసు బోల్యొ ఆ అవాజ్‍ మారటేకె ఆయుకొయిని, తుమారటెకేస్‍ ఆయూ. ");
INSERT INTO vgr_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","హంకె ఆ ములక్‍నా న్యావ్‍హుంకరస్‍ తెదె ఆ ములక్‍ను అధికారివాలొ భాదర్‍ దక్లాయ్‍జాసె ");
INSERT INTO vgr_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","“మే ఆ జమిన్‍మతో ఉప్పర్‍ గయ్యొతెదె అద్మిఖారవనా మారఖాందె ధపాయ్‍లీస్‍కరి” బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","తెదె ఇనే కిమ్నితర మరణ్న పొందుకరస్కి, సూచించిన్‍ యో ఆవాత్‍ బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","అద్మిన గళ్లో, కెదేబి ర్హాసేకరి ధర్మషాస్ర్తంమా బోలను హఃమ్‍జ్యా. అద్మినఛియ్యో ఉప్పర్‍ పడయ్‍జాసెకరి తూ బోలుకరతె సంగతి సాత్‍? అద్మినఛియ్యో ఇనే కోన్కరి యో పుఛ్చాయో. ");
INSERT INTO vgr_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","అనటెకె యేసు బోల్యొ, బుజూ థోడుధన్‍ ఉజాళు తుమార మద్యమా ర్హాసే రాత్‍ తుమారప్పర్‍ కమ్మినాఖకొయినితింమ్‍ తుమ్న ఉజాలు రయ్యూతెదేస్‍ ఛాలో రాత్‍మా ఛాలవాలొ యో కెజ్గా జంకరస్‍కీ మాలంకరకొయిని. ");
INSERT INTO vgr_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","తుమ్న ఉజాలు సంబందహుయుతింమ్‍ తుమ్న ఉజాలురయ్యూతెదేస్‍ ఉజాలుమా విష్వాస్‍రాకొకరి ఇవ్నేతి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","యేసు ఆ వాత్‍బోలీన్‍ జైయిన్‍ ఇవ్నా దెఖ్కావకొయినీతింమ్‍ లపీన్‍రవ్వామా, యో ఇవ్నహఃమే ఎత్రూ సూచక క్రియల్‍ కర్యొతోబి ఇవ్నేఇనా విష్వాస్నా రాక్యాకొయిని. ");
INSERT INTO vgr_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","ప్రభూ, హమారు సమాచార్‍నా నమ్మవాలో యోకోన్‍? ప్రభూవును, కువ్వత్‍ కినా బయల్‍పర్చబడూ? కరి ప్రవక్తహుయోతె యెషయా బోల్యొతె వచన్‍ నెరవేర్చునుతింమ్‍ అమ్‍ హుయు. ");
INSERT INTO vgr_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","అనహాఃజె ఇవ్నే నమ్యకొయిని, సానకతో ఇవ్నే ఢోలాతి దేఖిన్‍ దిల్మా గ్రహించీన్‍ మనస్సున బద్లాలీన్‍ దేవ్ను బాజు ఫారిన్‍ దేక్యాహోత్తొ స్వస్థతబడ్నుతింమ్‍ ");
INSERT INTO vgr_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","యో ఇవ్నా ఢోలనా అంధారు కరీన్‍ ఇవ్న దిల్నా కఠినంకర్లిదు కరి యెషయా అజేక్ జోగొమ బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","యెషయానె ఇను మహిమన దేక్యోకరి ఇన గూర్చీన్ ఆ వాతె బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","ఇను అధికార్‍మాబీ కెత్రూకిజణు ఇనప్పర్‍ విస్వాష్‍న రాక్యు పన్కి, న్యావ్‍కరను జోగొ తూ నఖాడిదేస్కికరి పరిసయ్యుల్‍న ఢరీన్‍ ఇవ్నే ఒప్యుకొయిని. ");
INSERT INTO vgr_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","ఇవ్నే దేవ్న్కంతూ ఆవతె మహిమతీబి అద్మికంతు ఆవతె మహిమనస్‍ జాఖాత్‍ ఫ్యార్‍కరుయుతె. ");
INSERT INTO vgr_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","తెదె యేసు గట్ట్ తి చిక్రీన్‍ అమ్‍బోల్యొ, మారప్పర్‍ విష్వాస్‍నరాఖవాలొ మారమ ఖాహే మన మొక్లోతె ఇనస్‍ప్పర్‍ విష్వాస్‍ రాఖుకరాస్‍ ");
INSERT INTO vgr_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","మన దేఖవాలొ మన మొక్లొతెయినస్‍ దేకుకరస్‍ ");
INSERT INTO vgr_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","మారమ విస్వాస్‍నరాఖవాలొ హర్యేక్‍జణు అంధారమా ఉబ్రిన్‍ నార్హానుతింమ్‍ మే ఆ ములక్‍మా ఉజాళుహుయిన్‍ ఆయ్‍ర్హోస్‍ ");
INSERT INTO vgr_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","కోన్బి మారివాతెన హాఃమ్జీన్‍ ఇన నాపాటించతోతెదె మే ఇన న్యావ్‍ తిర్చీస్‍ కొయిని మే ఆ ములక్మా న్వావ్‍ తీర్చన ఆయోకొయిని పన్కి ములక్‍నా బఛ్చావనటెకేస్‍ ఆయోతొ ");
INSERT INTO vgr_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","మన దక్లినాఖీన్‍ మారు వాతేన అంగీకరించకొయింతె ఇవ్నా న్యావ్‍ తీర్చీన ఏక్జనో ఛా మే బోల్యొతె వాతెస్ ఆఖరిధన్‍మా ఇనా న్యావ్‍ తీర్చే. ");
INSERT INTO vgr_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","కింమ్‍కతో మారు మేస్‍ వాతెకోబోలుకరుని; మే సాత్‍బోలునుకి సాణి వాతెబోలునుకి ఇనగూర్చీ మన మొక్లోతె భాస్‍ మనజ్ఞనా దిరాక్యోస్‍ ");
INSERT INTO vgr_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","బుజు ఇను ఆజ్ఞ నిత్యజీవంకరి మన మాలం. అనటేకే మే బోలుతె సంగతుల్ భా మారేతి బోల్యొ తిమ్మస్‍ బోలుకరూస్‍కరిబోల్యు. ");
INSERT INTO vgr_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","యో ఆ ములక్‍మతూ భా కన జావనుతూతె వహఃత్‍ ఆయుకరి యేసునె పస్కాపండగను అగాఢిస్‍ మాలంకర్యోహుయిన్‍ ములక్మాఛాతె ఇవ్నుఖారవ్‍నా ఫ్యార్‍కరిన్ ఇవ్నా ఆఖరితోడి ఫ్యార్‍కర్యో. ");
INSERT INTO vgr_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","యేసుబి ఇను సిష్యుల్‍ ధాన్‍ ఖంకరమా ఇన ధర్యాయ్‍దేనుకరి సీమో‍న్ను ఛియ్యోహుయోతె ఇస్కరియోతు యూదను దిల్‍మా భూత్‍నె అనేఖుఅగాఢి ఖాయల్‍ పైదాకర్యాకొ అనటేకే ");
INSERT INTO vgr_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","భానె ఇనహాత్మా సమస్తంనా హాత్మా దెవ్వాఢి రాక్యోస్‍కరి, ఇనే దేవ్కంతూ నాకిన్‍ ఆయోకరి, దేవ్కన జావను ఛాకరి యేసు మాలంకరిన్‍; ");
INSERT INTO vgr_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","ధాన్‍ ఖావను ఎజ్గాతూఉట్టీన్‍ ఉప్పర్‍ను లుంగ్డానా ఫార్‍బెందీన్‍ ఏక్ టువాల్‍ పల్లీన్‍ కంబర్‍నా బాందిలిదో. ");
INSERT INTO vgr_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","తెదె గిన్నిమా పాని నాకిన్‍ సిష్యుల్‍ను గోఢ దొవ్వానటెకె, ఇనే కంబ్బర్‍న బాందిరాక్యోతె టువాల్‍తీ సిష్యుల్నా నుఛ్చనటేకె సురుకర్యూ. ");
INSERT INTO vgr_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","అమ్‍కర్తూ యో సీమోన్‍ పేతుర్‍కన ఆయుతెదె ఇనే ప్రభూ, తూ మార గోఢన దొయిస్నా? కరి ఇనేతి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","అనటెకె యేసు బోల్యు, మే కరుకరతె హంకె తుమ్న మాలంకొహుసేని పన్కి హంకేతునికిన్‍ మాలంకర్లిసుకరి ఇనేతి బోలమా. ");
INSERT INTO vgr_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","పేతుర్‍ “తూ కెదేబి మార గోఢన నోకొదొవ్” కరి ఇనేతి బోల్యు. అనటెకె “యేసు మే తార గోఢనా దొయ్యోతొతెదె, తూ మారేతి సిష్యుడ్నిహుయీన్‍ కోరహీస్ని” కరి బోల్యు. ");
INSERT INTO vgr_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","సీమోన్‍ పేతుర్‍ “ప్రభూ, మారగోఢస్‍ కాహేతింమ్‍ మారహాత్, మార‍ ముడ్‍క్యూనాబి దోవ్కరి” ఇనేతి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","యేసు ఇన దేఖీన్ బోల్యొ పాని నొయ్యుతె యో బుజు కాయిబి దొవ్వాను అవసరంకొయినీ, యో కేవలమ్‍ పవిత్రుడుహుయో. “తుమేబి పవిత్రుల్‍ పన్కి తుమారమా ఖారు పవిత్రులు కాహేకరి” బోల్యు. ");
INSERT INTO vgr_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","యేసునా ధరాయ్‍ దెవ్వాలొన మాలంకర్యొ అనటెకె తుమారమా ఖారు సుద్ద్ కాహెకరి ఇనే బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","ఇవ్ను గోఢన దొయ్యీన్‍ ఇను ఉప్పర్ను లుంగ్డఫర్‍ నాఖను పాసల్తీ, యో బుజు బేసీన్‍ మే తుమ్న కర్యోతె కామ్‍ తుమ్న మాలంహుయూనా? ");
INSERT INTO vgr_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","“బోధకుడ్కరి, ప్రభూకరి తుమె మన బులాంకరస్‍; మే బోధకుడ్కరి ప్రభూకరిబి అనటేకె ఇమ్ బులావనూ న్యాయమస్‍. ");
INSERT INTO vgr_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","అనహాఃజె ప్రభూబి, బోధకుడ్‍హుయోతె మే తుమారు గొఢ ధొయ్యోతొతెదె తుమేబీ ఏక్‍ను గోఢన ఏక్ దొవ్వును” బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","మే తుమ్న కర్యొతింమ్‍ తుమేబి కర్నూకరి తుమ్న మాదిరింతరా అమ్‍ కర్యొ. ");
INSERT INTO vgr_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","దాసుడ్‍ ఇను యజమానితీబి గొప్పవాడ్‍ కాహె, మొక్లిరాక్యొతె ఇన మొక్లోతె ఇనేతీబి గొప్పవాడ్‍ కాహేకరి తుమారితి ఖాఛితి బోలుకరూస్‍. ");
INSERT INTO vgr_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","ఆ సంగతుల్‍ తుమె మాలంకర్యాకస్‍ అనహాఃజె ఆహాఃరు కర్యతొ తుమె ధన్యుల్‍ హుషు. ");
INSERT INTO vgr_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","తుమ్నా హాఃరవ్నా బారెమా మే బోలు కరూకొయిని; మే చూణిరాక్యొతె ఇవ్నా మాలంకర్యాక్యోస్‍ పన్కి మారేతి బేసీన్‍ ధాన్‍ఖాహదొహో మనస్‍ పాచుపర్యాన్‍ ఇను వైరీహుయీన్‍ ఛా. కరి లేఖనాల్‍ నెరవేర్చన అంనితర జరిగ్యూ. ");
INSERT INTO vgr_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","హుయుతెదె మేస్‍ యోకరి తుమే నమ్మతింమ్‍ యోహువకొయింతె అగాఢిస్‍ తుమారితి బోలుకరూస్‍. ");
INSERT INTO vgr_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","మే కినా మొక్లుస్‍కి ఇన చెరాయ్‍లెవాలొ మన చెరాయ్‍ లావాలోహుసె; మన చేర్చాయ్‍లావాలొ మనమొక్లొతె ఇనబి చేర్చాయ్‍లావాలొహుసెకరి తుమారితి ఖాఛితి బోలుకరూస్‍కరి ఇవ్నేతి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","యేసు ఆవాత్‍ బోలీన పాసల్‍ ఆత్మమా గబ్రాయిన్‍ తుమారమా ఏక్జనో మన దర్యాయ్‍దిసె తుమారేతి హాఃఛితి బోల్యకరి రూఢిమ్‍తర బోల్యు. ");
INSERT INTO vgr_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","యో కినబారెమా అమ్‍నితర బోల్యొకి కరి సిష్యుల్‍ సందేహంహూతు ఏక్ను బాజు ఏక్జను దేక్తూ రవ్వామా. ");
INSERT INTO vgr_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","ఇను సిష్యుల్‍మా యేసు ఫ్యార్‍కర్యోతె ఏక్జనో యేసున హఃమే బేసిన్‍ ర్హంకరమా. ");
INSERT INTO vgr_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","అనహాఃజె కినబారెమా యో బోల్యొకి ఆ హమ్నా బోల్‍కరి సీమోన్‍కరి బోల్వాతే పేతుర్‍ ఇన సైగకర్యో. ");
INSERT INTO vgr_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","ఇనే యేసున బుజుఖాందె లగ్గిన్‍ ప్రభూ, యోకోన్కరి ఇనపుఛ్చాయో. ");
INSERT INTO vgr_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","అనహాఃజె యేసు బొల్యొ మే రొట్టాను టుక్డా డుబాయిన్‍ కిన దేవ్‍స్కి యోస్కరి బోలీన్‍ ఏక్ టుక్డోన డుబాయిన్‍ సీమోన్‍ ఛియ్యోహుయోతె ఇస్కరియోతు యూదన దిదో; ");
INSERT INTO vgr_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","ఇనే యో టుక్డోన లెంకరస్మా సాతాన్‍ ఇనమా గయూ. యేసు తూ కరుకరాతె ఎగ్గిస్‍ కర్కరి ఇనేతి బోలమా. ");
INSERT INTO vgr_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","యో సానఖాజె ఇనేతి ఇంమ్‍ బోల్యుకి ఆ ధాన్‍ ఖావన బేష్యుతె ఇవ్నమా కినాబి మాలంకోహుయూని. ");
INSERT INTO vgr_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","రప్యాను సంచి యూదకనా తూ అనహాఃజె పండగన ఇవ్నా హోనుతె రాఛున లీలకరిబితోబి, గరీబ్న సాత్బీ దా! కరితోబి యేసు ఇవ్నేతి బోలన్‍తార థోడుజను ర్హైయిగు. ");
INSERT INTO vgr_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","ఇనే యో ముక్కన లీన్ ఎగ్గీస్‍ భాదర్‍ చలిగయో; తెదె రాత్నువఖాత్‍. ");
INSERT INTO vgr_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","యూదా చలీజావన పాసల్‍ యేసు అంమ్‍బోల్యు, హంకె అద్మినఛియ్యో మహిమ పరచబడిన్‍ ఛా; దేవ్బి ఇనపర్‍ మహిమ పరచబడిన్‍ ఛా ");
INSERT INTO vgr_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","దేవ్‍ ఛియ్యోన ఖామే మహిమ పరచబడితొ, దేవ్‍ ఇనఖామే ఇన మహిమపరస్చే; ఎగ్గిస్‍ ఇన మహిమపరస్చే. ");
INSERT INTO vgr_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","లడ్కా అజుబి థోడుధన్‍ తుమారితి ర్హహీస్‍ తుమే మన దుమ్‍డ్చూ మేకెజ్గా జైయిస్కి ఎజ్గా తుమే ఆవ్సుకొయిని మే యూదుల్తి బోల్యొతిమ్మస్‍ హంకె తుమారితిబి బోలుకరూస్‍ ");
INSERT INTO vgr_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","తుమే ఏక్న ఏక్ ఫ్యార్‍కర్లేనుకరి మే తుమ్న ఫ్యార్‍కర్యో తిమ్మస్‍ తుమేబి ఏక్న ఏక్ ఫ్యార్‍కర్లేనుకరి తుమ్న నవూ ఆజ్ఞన దెమ్‍కరూస్‍ ");
INSERT INTO vgr_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","తుమే ఏక్న ఏక్ ఫ్యార్‍కరవాలహుయోతొ అనబట్టీనస్‍ తుమే మార సిష్యుల్‍కరి ఖారుజనుబి మాలంకర్‍లిసెకరి బోల్యు. ");
INSERT INTO vgr_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","సీమోన్‍ పేతుర్‍ “ప్రభూ, తూ కెజ్గా జంకరస్కరి” ఇనేతి పుఛ్చావమా, యేసు మే జంకరతె జొగోమ తూ హంకె ఆయిస్‍ కొయిని పన్కి, పాసల్తీ ఆయిస్కరి ఇనేతి బోల్యు. ");
INSERT INTO vgr_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","అనహాఃజె పేతుర్‍ ప్రభూ, మే సానటెకె హంకె తారకెడె ఆయిస్‍ కొయిని తారటెకె మార జాన్‍న బేందీస్‍కరి ఇనేతి బోలమా. ");
INSERT INTO vgr_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","యేసు బోల్యొ, తూ మారటెకె తార జాన్నా బేందీస్‍నా? మే కోన్కి మాలంకొయినీకరి తీన్‍ఛోట్‍బోలన అగాడి ముర్గు వ్హాక్చేకొయినికరి తారేఖూ హాఃఛితి బోలుకరూస్‍ కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","యేసు ఇవ్నేతి బోల్యొ, తూమరు దిల్మా చింతానోకో పడాదిసు; దేవ్‍పర్‍ వీస్వాసం రాకొ మారఫర్‍బీ విస్వాష్‍ రాకో. ");
INSERT INTO vgr_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","మారు “భాను” ఘార్మా కెత్రుకి జీవాను ఛా, నావుసెతో తుమారేతి బోలిస్‍; తుమ్నా జొగొ సిధ్దాపరచానటెకె అగాఢి జంకురూస్‍ ");
INSERT INTO vgr_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","మే జైన్‍ తుమ్నా జొగో సిధ్దాపరిచ్చాతో మే ర్హాయోతే జొగొమా తుమేబి ర్హావహఃర్కూ బుజు ఆయిన్‍ మారకనా ర్హావనటేకె తుమ్నా బులైలీజైస్‍ ");
INSERT INTO vgr_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","మే జంకరూతె జొగోను వాట్ తుమ్నా మాలంహుసె. ");
INSERT INTO vgr_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","ఇనటేకె “తోమా ప్రభూ కెజ్గా జంకరస్కి” హంనా మాలంకోయిని; యో వాట్‍ హంనా కిమ్‍ మాలంపడ్సే కరి ఇనా పుఛ్చావమా. ");
INSERT INTO vgr_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","యేసు ఇవ్నేతి బోల్యొ, మేస్‍ మారగ్‍బీ హాఃఛిబి, జివంబి; మారవలస్‍ తప్ప కోన్బి భాకన కోఅవ్సేని. ");
INSERT INTO vgr_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","తుమే మన మాలంకరిరాక్యాతో మార భానబీ మాలంకర్సు; హంకేతీ లీన్‍ తుమే ఇనా మాలంకరుసు, బుజు ఇనా దేక్కిరాక్యస్‍ కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","తెదే ఫిలిప్పు బోల్యొ, ప్రభూ భాన హమ్నా వతాల్‍ హామ్నా యోస్‍ బైస్‍ కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","తెదె “యేసు ఫిలిఫ్పుతీ బోల్యొ, మే అత్రాధన్‍ తుమార కనా ర్హాయోతొబీ తూ మన మాలంకొకర్యనీ సూ? మన దేక్కావాలు భానబీ దేకిరాక్యుస్‍ ఇనాటెకె ‘భాన హమ్నా వాతల్కరి’ కిమ్‍ బోలుకరస్‍? ");
INSERT INTO vgr_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","పిలిప్పు భాకనా మే, మరాకనా భా ఛా కరి తూ నమ్ముకరా కోయినిసూ? మే తుమారేతి బోలుకరుతే ఆ వాతె మారు ఖూద్ను మేస్‍ కోబొలుకరుని భా మారమా ర్హాతోహుయిన్‍ ఇనా క్రియల్‍నా కరూకరస్‍ కరి” సిష్యుల్తి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","భా కనా మే మారకనా భా ఛియ్యేకరి ఆవాత్నా నమ్మో; నైయితొ క్రియల్నాతోబి నిమితంతోబి మన నమ్మో. ");
INSERT INTO vgr_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","మే భా కనా జావుంకురుస్‍ ఇనటెకే మే కరుతె క్రియల్‍ మారప్పర్‍ విస్వాష్‍ రాఖవాలనబీ కర్‍సే, ఇనేతిబీ బుజు ఇనెతిబి గోప్ప యో కర్సేకరి తుమారేతి ఖాఛితి బోలుకురూస్‍ ");
INSERT INTO vgr_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","తుమే మార నామ్‍మా కెహూ మాంగ్‍సుకి మల్సె, భా ఛియ్యోనాకన మహిమపరచనటెకేస్‍ ఇనకర్సే. ");
INSERT INTO vgr_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","మార నామ్తీ తుమే మారకన సాత్‍ మాంగితోబి మే కరిస్‍. ");
INSERT INTO vgr_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","తుమే మన ఫ్యార్‍కర్యతోతెదె మార ఆజ్ఞన్‍లా మాలంకర్సు. ");
INSERT INTO vgr_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","మే భాన వేడిలేవుంకరు, తుమారకనా హమేసా ర్హావనటేకె యో అలాదు మద్దత్‍ కరవాలో, దిస్యే. ");
INSERT INTO vgr_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","ఇనే దేవ్ను హాఃఛిన బయల్పర్చనటేకె ఆత్మహుయీన్‍ ఛా, ములక్‍ ఇనా కేదెబి కోదేక్నారుని, యో ఇవ్నామాలం ఇనాటేకె తుమే ఇనా గుర్తుధరస్‍ యో తుమరేతి నివసింసే, తుమారమా రాసే. ");
INSERT INTO vgr_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","తుమాన అనాదుతరా కోమేదిస్ని తుమారకనా థొడు ధన్నా బాద్మా ఆయిస్‍ ");
INSERT INTO vgr_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","ఆ ములక్‍ మనా అజు కేదేబి దేక్సెకొయిని. హుయితొ తుమే మనా దేక్సు, పన్కి బుజు తుమే మన దేక్సూ, మే జిమ్‍క్రూతె ఇమ్‍ తుమేబి జివ్సూ. ");
INSERT INTO vgr_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","యో ధన్ ఆయుతెదె, మే మార భాకనా ఛావు కరి, తుమే మరాకన మే తుమారకనా ఛియ్యేకరి యో ధన్నా తుమే మాలంకర్సు. ");
INSERT INTO vgr_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","మార ఆజ్ఞాల్‍నా అంగీకారించీన్‍ ఇవ్నామాలంకర్య హుయోస్‍ మన ఫ్యార్‍వాలో. మన ఫ్యార్‍కరవాలో మార భాతి ఫ్యార్‍హుయు బడ్సే మేబి ఇనా ఫ్యార్‍కరస్‍; మనాబి ఇవ్నా ఓపిలిసే కరి బోలాస్. ");
INSERT INTO vgr_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","యూదా ఇస్కరియోతు కాహేతె బుజెక్‍ యుదా, ప్రభూ తూ ములక్నా కాహేతీమ్‍ హమారు హామ్నాస్‍ తారు తునా దెఖాడిలేవను సే? పుఛ్చావమా. ");
INSERT INTO vgr_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","తెదె యేసు ఇవ్నా బోల్యొ, ఏక్జాను మన ఫ్యార్‍కరతే యో మారి బోధా గ్రహించే తెదె మారో భా ఇనా ఫ్యార్‍కరస్‍; హమే ఇనకనా ఆయిన్‍ ఇనా ఖందె నివాసం కరుసు. ");
INSERT INTO vgr_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","మన ఫ్యార్‍కరకొయిన్‍తే వాలో మారి బోధనా ఖాంచేకొయిని; తుమే ఖాంజుకరతె బోధ మారి బోధ కాహే మన మోక్లోతే భాను బోధ. ");
INSERT INTO vgr_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","మే తుమారకనా థో. తెదేస్‍ ఆ వాతె ఖారి తుమారేతి బోల్యొ థో. ");
INSERT INTO vgr_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","ఆదరణకర్త, కతో భాన నామ్తీ బోలిమోకల్సేతే పరిసుద్ధాత్మ, సమస్తంనా తుమ్నా బోధించీన్‍ మే తుమారేతి బోల్యోతే సంగతుల్‍ ఖారూబి తుమ్న‍ హఃయాల్‍ కరావ్సే. ");
INSERT INTO vgr_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","షాంతినా తుమ్నా అనుగ్రాహీంచీన్‍ జంకరూస్‍; మార షాంతినస్‍ తుమ్నా అనుగ్రాహీంచుకరుస్‍; ములక్‍ దేవుంకరస్‍ తీమ్‍ మే తుమ్నా అనుగ్రాహించుకరుస్‍ కోయిని, తుమారు దిల్నా బాధనొకొ పడాదేవో బుజు కినాబి నొకొదిసూ. ");
INSERT INTO vgr_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","మే జైన్‍ తుమారకన పాఛ్చు ఆయిస్‍ కరి బోల్యోతే వాత్‍ తుమే ఖాంజ్యా కోయినా భా మరేతిబి గోప్ప వాలొ ఇనటెకె తుమే మన ఫ్యార్‍కర్యతో మే భాకనా జావుంకురుస్‍ కరి తుమే ఖూషిహుసు. ");
INSERT INTO vgr_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","ఆ సంగతి హువాకొయిన్‍తే అగాడి తుమే నమ్మును కరి యో సంభావించనా అగాఢీస్‍ తుమారేతి బోలుకారుస్‍ ");
INSERT INTO vgr_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","హంకెతూ తుమారేతి జాహఃత్‍ వాత్‍కోబోలిస్ని; ఆ ములక్ను అధికారి ఆవుంకరస్‍; మారేతి ఇనా సంబంధమ్‍ కాయ్బి కొయిని. ");
INSERT INTO vgr_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","హుయుతోబి మే భాన ఫ్యార్‍కరుకరస్‍; ములక్నా మాలంకరును తిమ్‍ భా ఆజ్ఞాపించోతె హువతోడి మే అమ్మస్‍ కరిస్‍ ఉట్టో అజ్గాతి జైయే. ");
INSERT INTO vgr_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","యేసు బోల్యొ; మే హాఃఛిహుయోతె ద్రాక్చావల్లీ. మారో భా ఖేతర్‍వాలొ. ");
INSERT INTO vgr_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","మారమా ఫలించకొయింతె హర్యేక్‍ డాలిన ఇన కత్రీన్‍ ఫేకిదిసె; ఫలించతె హర్యేక్‍ డాల్లి బుజు ఘణు ఫలించానటెకె, ఇన్మతూ ఫాల్తు డాలినా ఛాట్టినాక్చే. ");
INSERT INTO vgr_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","మే బోల్యోతే వాతేవ్నా లీన్‍ తుమే పవిత్రుల్‍ హుయిన్‍ ఛా. ");
INSERT INTO vgr_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","మార మ్హాడ్తి వుబ్రిన్‍ ర్హవో; తుమార మ్హాడ్తి మేబి వుబిర్హావుస్‍ ద్రాక్చావలిమా డాల్లి ఉబ్రిన్‍ ర్హాయితోస్‍ గాని ఇనుయోస్‍ కింకోఫలించానికి ఇంమాస్‍ మారమా వుబ్రిన్‍ ర్హాయితోస్‍ కాని తుమేబి ఫలించుకోయిని. ");
INSERT INTO vgr_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","ద్రాక్చావల్లి మే, డాల్లియే తుమె, కినా మ్హాడ్తి వుబ్రిన్‍ ర్హాసుకి యో జాఖాత్‍ ఫలించే; మారేతి దుర్‍ ర్హాయిన్‍ తుమే కైయ్‍బి కొర్నారునీ. ");
INSERT INTO vgr_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","కోన్బి మారభానె వుబ్రిన్‍ నార్హాయితొ యో డాలినిజోక్‍ భాధర్‍ పెకైజైన్ హూఃకాయిజాసే; అద్మియే జోక్నా తోఢిన్‍ ఆగ్మా నాఖాదిసే, బుజు యో బలిజాసే. ");
INSERT INTO vgr_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","మారమ తుమే తుమరా మారి వాతె వుబ్రిన్ ర్హాయితోస్‍ తుమ్న కెహూ ఇష్టంకీ మంగో, యో తుమ్న మల్సె. ");
INSERT INTO vgr_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","తుమే ఘాణు ఫలించానవల మారో భా మహిమ పరచాబడ్సే; ఇనటేకె తుమే మార సిష్యుల్‍ హూసు. ");
INSERT INTO vgr_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","భా మన కిమ్‍ ఫ్యార్‍కర్యోకి మేబి తుమ్నా ఇమ్మాస్‍ ఫ్యార్‍కరిస్‍ మార ఫ్యార్‍‍ఫర్‍ వుబ్రిన్‍ ర్హావొ. ");
INSERT INTO vgr_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","మే మార భా ను ఆజ్ఞాల్‍నా మాలంకరిన్‍ ఇనా ఫ్యార్‍మా వుబ్రిన్‍ ఛావుతే లపట్మా తుమేబి మారు ఆజ్ఞాల్నా మాలంకర్యాతెదె మారు ఫ్యార్‍మా వుబ్రిన్ ర్హాసు. ");
INSERT INTO vgr_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","తుమారకన మారు ఖుషి ర్హానుకరి, అజు తుమారు ఖుషి పురా భర్తి హోనుకరి ఆ సంగతుల్‍ తుమారేతి బోలుకరూస్‍ ");
INSERT INTO vgr_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","మే తుమ్నా ఫ్యార్‍కర్యొతే ప్రకారం తుమేబి ఏక్నుయేక్‍ ఫ్యార్‍ కర్నూకరి ఆస్‍ మారు ఆజ్ఞా. ");
INSERT INTO vgr_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","ఇను దొస్తుల్‍నటేకె; ఇను జాన్‍ భేమ్‍దావాలుకనా అజు కేవు మహాన్‍ ఫ్యార్‍ ర్హావ్వాలు కోయిని. ");
INSERT INTO vgr_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","మే తుమ్నా దిదోతె ఆజ్ఞాల్‍నా కర్యాతో, తుమే మార దొస్తుల్‍ హుయిన్‍ ర్హాసూ. ");
INSERT INTO vgr_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","హంకేతు మే తుమ్నా దాసుడ్‍కరి కొబొలిస్నీ, సానకతొ దాసుడ్‍నా మాలంకోయినికి ఇనొ యజామనుడ్‍ సాత్‍ కరస్కి; పన్కి మేతొ తుమ్నా దొస్తుల్‍ కరి బోల్యొ; సానకతొ మే యో వాతెఖారుబి మార భా కనా ఖాంజోతె; యో హాఃరుబి తుమాన బొల్దిదొ. ");
INSERT INTO vgr_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","తుమే మన ఏర్పచిరాక్యకోయిని, తుమే మార నామ్తీ భా సాత్‍ మాంగాస్‍కి యో ఇనా దేవ్యాజాసే తీమ్‍ తుమె జైన్‍ ఫలించానటెకె తుమారు ఫల్‍ ఉబ్రరావ ఖార్కు మే తుమ్నాఎంచీ రాక్యోస్‍ ");
INSERT INTO vgr_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","తుమే ఏక్నుయేక్‍ ఫ్యార్‍ కర్నుకరి ఆ సంగతుల్‍నా తుమ్నా ఆజ్ఞదెంకరూస్‍. ");
INSERT INTO vgr_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","ములక్‍ తమ్నా ద్వేషించ్యాతో; తుమారేతిబి అగాడి మన ద్వేషించు కరాస్కరి తుమ్నమాలంహుసే ");
INSERT INTO vgr_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","తుమె ములక్నా సంబందుల్‍హుయీన్‍ ర్హాయితో ములక్‍ తుమాన ఫ్యార్‍ కర్సె హుయితోబి తుమే ములక్‍ సంబందుల్‍ కాహే మే తుమ్నా ములక్‍మాతు ఎంచిలిదో; ఇనటెకే ములక్‍ తుమ్న ద్వేషించుకరస్‍ ");
INSERT INTO vgr_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","దాసుడ్‍ ఇను యాజమానుడ్‍తిబి మహాన్‍ అద్మి కాహేకరి, మే తుమారేతి బోల్యోతే వాతె ఖాయాల్‍ కరిలేవొ; ములక్‍వాలు మన హింషిన్‍చ్యాతో తుమానబి హింషింసే; మారు వాతె మాలంకర్యాతొ తుమారు వాతేనాబి మాలంకర్సె. ");
INSERT INTO vgr_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","హుయితో ఇవ్నే మన బోలిమోక్లోతె ఇనా మాలంకోకార్యని; ఇనటేకె మార నామ్మా నిమిత్తంతి ఆఖారవ్నాతుమ్నా కరూస్‍ ");
INSERT INTO vgr_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","మే ఆయిన్‍ ఇవ్నా నాబోధించిన్‍ ర్హయతొ, ఇవ్నా పాప్‍ దూషణ కొర్హాసేని; పన్కి హంకెతూ ఇవ్ని పాప్మనువాట్‍ చుఖ్కావనా అవకాసం కొయిని. ");
INSERT INTO vgr_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","మన ద్వేషించవాలో మార భానబి ద్వేషించుకరస్‍ ");
INSERT INTO vgr_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","కోన్బి కార్యుకోయినితే క్రియాల్‍ మే ఇవ్నా ఇచ్మా నాకార్యోతో ఇవ్నా పాప్‍ దూషణ హుసేకోయిని; హంకేతో ఇవ్నే మనాహో మార భానాహో దేకిన్‍ ద్వేషించుకరాస్‍ ");
INSERT INTO vgr_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","పన్కి మన కారణంకొయినితింమ్‍ ద్వేషించు కరి ఇవ్నా ధర్మషాస్త్రంమా లిఖారుతే వాక్యం హుయుతిమ్‍ అమ్నితరా హుసే. ");
INSERT INTO vgr_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","భా కంతూ తుమారకనా మద్దత్‍కరవాలొ మోక్లాయిస్‍ కతో భా కంతు ఏక్‍ నిక్యొతె దేరుతే హాఃఛిబోలతె ఆత్మా ఆయుతెదె మార బారెమా సాబుత్నా దిసే. ");
INSERT INTO vgr_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","తుమే అగాడితి లీన్‍ మరాకన ర్హాయుహుయు కరి. ఇనాటేకె తుమేబి సాబుత్‍ బోల్చు. ");
INSERT INTO vgr_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","తుమే విస్వాష్‍మా ఉబ్రిన్‍ ర్హానుకరి ఆవాతె తుమారేతి బోలుకరూస్‍ ");
INSERT INTO vgr_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","ఇవ్నే తుమ్న న్యావ్‍కరను జోగొమతూ మొక్లిదిసె; తుమ్న మరాఖిదెయితె హర్యేక్‍ జాణు యో దేవ్నా సేవా కరూకరస్‍ కరి సోచ్చాను ధన్ ఖాందే ఆంకరస్‍ ");
INSERT INTO vgr_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","ఇవ్నే భాన మన మాలంకోకర్యస్‍ని ఇనటేకె అమ్‍కర్సె. ");
INSERT INTO vgr_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","హుయితో యో జర్గానువఖాత్‍ ఆయుతెదె మే ఇనా గుర్చి తుమ్నా బోల్యొ థో కరి, తుమే హఃయల్‍ కరిలేవా హఃర్కు ఆ సంగతుల్‍నా తుమారేతి బోలుకరూస్‍. పన్కి మేబి తుమరాకేడె థో ఇనటేకె అగాఢీస్ తుమ్నా ఆ కోబోల్యొని. ");
INSERT INTO vgr_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","హంకే మన బోలిమోక్లోతే ఇనకనా జావుంకురుస్‍ తూ కిజ్గా జావుంకరస్‍ కరి హంకేలాగు తుమారమా ఏక్జనూబి కోపుఛ్చాయుని. ");
INSERT INTO vgr_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","పన్కి మే ఆ సంగతుల్‍ తుమ్నా బొలమా తుమారు దిల్ ఘాణు దుఃఖాంతి భార్యయిన్‍ ఛా, ");
INSERT INTO vgr_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","అజు మే తుమారేతి హఃఛిస్‍ బోలుకరూస్‍ మే ఛలిజావను తుమ్న అష్యాల్‍; మే ఛలిగొతో మద్దత్‍ కరవ్వాలు తుమారకన కోఆవుసేని; మే గయోతో ఇనా తుమరాకన బోలిమోక్లిస్‍ ");
INSERT INTO vgr_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","యో ఆయోతెదె పాప్నా గూర్చిబి, నీతి బారెమాబి, బుజు దేవ్ను న్యావ్‍ను గూర్చి, ములక్ను అద్మియెనా ఒప్పిలేవా హఃర్కూ, కర్సే. ");
INSERT INTO vgr_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","ములక్ను మారహఃమే విస్వాష్‍ కోరాక్యుని, సానకతో ఇవ్ను పాప్‍న మాలంకోకర్యని. ");
INSERT INTO vgr_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","మే వుజు భా కనా జంకరూస్‍ తుమే బుజు మన కోదేక్సుని పన్కి నీతిన కోమాలంకర్యూని. ");
INSERT INTO vgr_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","ఆ ములక్‍ను అధికారి న్యావ్‍ అగాఢీస్‍ పోందిరాక్యుస్‍ ఇనటెకె న్యావ్‍ తుమే అర్థంకోకరూకరని. ");
INSERT INTO vgr_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","మే తుమారేతి బొలాను వుజుబి కెత్రూకి సంగతుల్‍ ఛా, పన్కి హంకే తుమే ఇవ్నా ఖామల్‍చుకొయిని. ");
INSERT INTO vgr_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","బుజు యో, కతో దేవ్ను హాఃఛినా మాలంకరవాతె ఆత్మ ఆయుతో తుమ్న స్వరసత్యంమా ఛలావ్సే; యో ఇనుయోస్‍ సాత్బి నాబోధించీన్‍ కెహూ హఃమ్జస్కి ఇనాస్‍ బోధించి జర్గజాసెతే సంగతుల్‍నా తుమ్నా మాలంకరసే. ");
INSERT INTO vgr_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","యో మారమతు థోడుకడిన్‍ లీన్‍ తుమ్నా మాలం కరవ్సే, ఇనటెకే మన మహిమా పరచాస్‍ ");
INSERT INTO vgr_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","భాన కలిగ్యుతే ఖారుబి మారుస్. ఇనఖాజే యో మారమతూ లీన్‍ తుమ్నా మాలంకరవును కరి మే బోల్యో థొ. ");
INSERT INTO vgr_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","థోడు ధన్నా బాద్మా తుమే మన దేక్చూకొయినికరి; బుజు థోడుధన్‍నా మన దేక్చుకరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","అనటెకె ఇను సిష్యుల్మా థోడుజను “థోడుధన్నా బాద్మా మన ధేక్చూకొయిని; బుజు థోడుధన్‍హువన బాద్మా మన దేక్చూకరి మే భాకన జంకరుస్‍కరి, యో అప్నేతి బోలుకరతే వాత్‍ సాత్‍కరి ఏక్తి ఏక్ బొల్లీదు. ");
INSERT INTO vgr_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","థోడు ధన్‍కరి యో బొలుకరతే సాత్‍? యో బోలుకరతే సంగతుల్‍ అప్నా మాలంకొయినికరి” బొల్లీదు. ");
INSERT INTO vgr_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","ఇవ్నేఆ వాత్‍ ఇన పుఛ్చావ్‍సెకరి యేసు సోచిన్‍ ఇవ్నేతి అమ్‍ బోల్యొ థోడు ధన్నా బాద్మా తుమే మన దేక్చూకొయినికరి, బుజు థోడుధన్నా మన దేక్చుకరి మే బోల్యొతె వాత్‍టేకె తుమే ఏక్నా ఏక్‍ సాత్‍ సోచిలెంకరస్‍నా? ");
INSERT INTO vgr_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","తుమే రొవ్వాస్‍ పన్కి ములక్‍ ఖుషిహుసే; తుమే దుఃఖాపడుసు పన్కి తుమారు దుఃఖామ్‍ సంతోషం హోనుకరి తుమారేతి హాఃఛితి బోలుకరూస్‍ ");
INSERT INTO vgr_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","బాయికొ జణావనుధన్‍ వఖాత్‍ ఆయు. అనటేకే యోబాయ్‍కొ బాధపడస్‍; పన్కి లడ్కుపైదహువన పాసల్‍ ములక్‍మా లడ్కుపైదాహుయోకరి యో ఖుషినటెకె బాయికో యోబాధన బుజు ఖాయల్‍ కరకొయినీ. ");
INSERT INTO vgr_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","ఇమ్నితరాస్ తుమేబి దుఃఖాపడుకరస్‍ పన్కి తుమ్న బుజే చోట్‍ దేక్యో తెదె తుమారు దిల్‍ ఖూషిహుసె, తుమారు ఖూషినా తుమారకంతు కోన్బి లిసేకోయిని. ");
INSERT INTO vgr_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","యో ధన్నే తుమే కినా గుర్చిబి కోపుఛ్చవుసుని; మే తుమారేతి హాఃఛి బోలుకురుస్‍ భా న తుమే మరానమ్తి సాత్బి మాంగ్యతోబి యో తుమ్నా మల్సే. ");
INSERT INTO vgr_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","హంకేలగు తుమే మార నామ్తీ సాత్బీ మంగ్యా కోయిని; తుమారు ఖూషి పరిపుర్ణం హువఖార్కు మాంగో; తుమాన మల్సే. ");
INSERT INTO vgr_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","ఆ సంగతుల్‍ ఉపామనంతి తుమారేతి బోలుకరూస్‍; హుయుతో మే బుజు కెదేబి ఉపామనంనితర తుమారేతి వాతె నాబోలిన్‍ భాన లీన్‍ స్పష్టంతి మాలంకరావను వఖాత్‍ ఆయుతురు. ");
INSERT INTO vgr_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","యో ధన్ముఆ తుమే మార నామ్తి మాంగుసు పన్కి తుమారటెకె మే భాన కొబతీమాలిస్ని కరి తుమారేతి కోబోలుకరుస్‍ని. ");
INSERT INTO vgr_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","తుమే మన ఫ్యార్‍ కర్య; ఇనటెకె మే భా కంతు బయాలుదేరిన్‍ ఆయో కరి తుమె నముకరాస్‍ ఇనటెకే భాస్‍ తుమాన ఫ్యార్కరుకరాస్‍ ");
INSERT INTO vgr_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","మే భా కంతు నికిన్‍ ములక్మా ఆయో, బుజు ఆ ములక్నా బేందిన్‍ భా కనా జావుంకురుస్‍ కరి ఇవ్నేతి బోలస్‍ ");
INSERT INTO vgr_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","తెదె ఇను సిష్యుల్తి, హదేక్‍ హంకేతు కేహు ఉపమానం నా బోలిన్‍ స్పష్టంతి వాతె బోలుకరస్‍ ");
INSERT INTO vgr_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","సమస్తంనా మాలంకర్యో హుయో కరి, కోన్‍బి తునా ప్రస్నా బొలాను ఆవసరం కోయినికరి, హంకెమాలంపడ్యు తూ దేవ్‍ కంతు తూ నికీన్ ఆయోకరి అనాలిన్‍ నమ్ముకరాస్ కరి బోలామ, ");
INSERT INTO vgr_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","యేసు ఇవ్నా మ్హడి దేఖిన్‍ హంకె నమ్ముకరాస్‍సూ? ");
INSERT INTO vgr_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","హదేక్‍ తుమారమ హర్యేక్‍జణు ఇను ఘేర్‍కనతో నికిజైన్‍ మన ఎక్కెలాన బేందెవాను వహఃత్‍ ఆంక్రాస్‍; ఆయిత్రూస్‍ హుయితో మారో భా మరకేడె ఛా ఇనటెకె మే ఎక్కెలో కోచవ్ని. ");
INSERT INTO vgr_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","మార యందు తుమ్న సమాధనం హువాఖార్కు ఆ వాతెవ్నా తుమరేతి బోలుకరస్‍ ములక్నా తుమా మినాత్‍ పడ్సే మే ములక్నా జైన్చుకరుస్‍ కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","యేసు ఆ వాతెహాఃరి బోలిన్‍ ఇనపాసల్‍ ఆబ్‍ మ్హాడి డోలో పడిన్‍ అమ్‍ బోలిన్‍ భా మార వఖాత్‍ ఆయిరుస్‍ తారొ ఛియ్యో తునా మహిమా పరచాఖార్కు తార ఛీయ్యానా మహిమా పరాచ్‍; ");
INSERT INTO vgr_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","తూ తరా ఛీయ్యానా దిదొతె ఇవ్నా హాఃర్వాన మే నిత్యజీవమ్‍న అనుగ్రహించతింమ్‍ అద్మియే హాఃరవ్పర్‍ ఇనా అధికార్‍న దీరాక్యోస్‍ ");
INSERT INTO vgr_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","అద్వితియానో హాఃఛి దేవ్‍ హూయోతె తునా, తూ బోలిమోక్లోతె యేసు క్రీస్తునా గుర్తుధరనుస్‍ నిత్యజివమ్‍ ");
INSERT INTO vgr_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","కరనాటేకె తూ మన దిదొతె కామ్‍ మే సంపూర్ణంతి జామిన్‍పర్‍ తునా మహిమా పరచ్యో. ");
INSERT INTO vgr_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","భా ములక్‍ పైదాహువనా అగాఢి థూస్‍ తరాకన మన కెహూ మహిమా తుకి యో మహిమాతి మన హంకె తరకనా మహిమా పర్చిలా. ");
INSERT INTO vgr_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","ములక్‍ మాతు తూ మన దీరాక్యోతె అద్మియోనా తరా నామ్తీ మహిమపరుచుకరస్, ఇవ్నే తారు హుయిన్‍ ర్హాయూ, తూ ఇవ్నాబి మన దెవ్వాడిరాక్యోస్‍; ఇవ్నే తారి వ్యాకంనా మాలంకరిన్‍ ఛా. ");
INSERT INTO vgr_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","అనటెకె తూ మన దీరాక్యోతె ఖారూబి తారువలనస్‍ హుయుకరి ఇవ్నేహంకె మాలంకరిన్‍ ఛా! ");
INSERT INTO vgr_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","థూ మన దీరాక్యోతె వాతెన ఇవ్నా దీరాక్యోస్‍; ఇవ్నేయోవాతేనా ఒప్పిలీన్ మే తారకంతూ నికిన్‍ ఆయోకరి హాఃఛితి ఎంచీన్‍ తూ మన మొక్లోకరి ఇవ్నే నమ్ముకారస్. ");
INSERT INTO vgr_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","మే ఇవ్నటెకె ప్రార్ధననా కరుకరూస్‍; ములక్నటెకె ప్రార్ధన కొకరుకరుని పన్కి, తూ మన దెవ్వాడిరాక్యోతె ఇవ్నేతారువాలకరి బోలీన్‍ ఇవ్నే ఖాజేస్‍ మే ప్రార్ధననా కరుకరూస్‍ ");
INSERT INTO vgr_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","మారు ఖారుబి తారు, తారు ఖారూబీ మారు; ఇవ్నమా మే మహిమమా హుయ్‍రోస్‍. ");
INSERT INTO vgr_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","మే ఆ ములక్మా బుజు కోరహీస్‍ని పన్కి అవ్నే ములక్మా ఛా; మే తారకన వలాంకరూస్‍ పరిసుద్దుడ్‍హుయోతె మారో భా అప్నె ఏక్‍ హుయిన్‍ రయ్యేతింమ్‍ ఇవ్నేబి ఏక్‍హుయిన్‍ ర్హానుతింమ్‍ తూ మన దీరాక్యోతె తారు నామ్మాతి ఇవ్నా బఛ్చావ్‍ ");
INSERT INTO vgr_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","మే ఇవ్నేకనా రవ్వమా తూ మన దిదోతె తారు నామ్మాలిన్‍ ఇవ్నా బఛ్చాయో. అనటెకె లేకనాల్‍ నెరవేర్చతింమ్‍ నాస్‍హువన బరాబ్బర్‍నో తప్ప, ఇవ్నేమా బుజు కోన్బీ నాస్‍నహోనుకరి మే ఇవ్నా జత్తన్‍కర్యో ");
INSERT INTO vgr_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","హంకె మే తారకనా వలాంకరూస్‍; మారు ఖుషాల్‍ ఇవ్నవలా కొదువాహోనుకరి, ములక్మా ఆవాత్‍ బోలుకరూస్‍ ");
INSERT INTO vgr_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","ఇవ్నా తారు వాతేనా దిరాక్యోస్‍ మే ములక్ను సంబందహుయొ కాయేతిమ్‍ ఇవ్నేబీ ములక్ను సంబందహుయుకాహె అనటెకె ములక్‍ ఇవ్నా దావ్వోకరూకరస్‍. ");
INSERT INTO vgr_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","తూ ములక్‍మతూ ఇవ్నా బులాలిజాకరి మే ప్రార్ధనా కరుకరాకొయిని పన్కి దుష్మాన్కంతూ బఛ్చావ్‍కరి ప్రార్ధననా కరుకరుస్‍ ");
INSERT INTO vgr_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","మే ములక్ను సంబందిహుయొ కాహే, తుమేబి ములక్న సంబందిహుయా కాహే. ");
INSERT INTO vgr_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","హాఃఛిమా ఇవ్నా ప్రతిష్ఠ పర్చను; తారు వాక్యమస్‍ హాఃచి. ");
INSERT INTO vgr_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","తూ మన ములక్మా మొక్లోతిమ్మస్‍ మేబి ఇవ్నా ములక్మా బొలిమొక్లొ. ");
INSERT INTO vgr_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","ఇవ్నేబి ఖాఛిమా ప్రతిష్టబడ్నుతింమ్‍ ఇవ్నహాఃజె మారుమేస్‍ తున ప్రతిష్ఠ కర్‍లెంకురుస్‍ ");
INSERT INTO vgr_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","ఇవ్ని వచన్‍టేకె మారకనా విష్వాస్‍న రాఖవాల హఃరూబి ఏక్‍హుయిన్‍ ర్హానుకరి ఇవ్నటెకె కాహే గాని అవ్ను వాతెవ్న ఖాంజ్యతే ఇవ్నాటెకె మే ప్రార్ధన కరూకరాస్‍ ");
INSERT INTO vgr_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","బుజు తూ మన మొక్లోకరి ములక్‍ నమ్మనుతింమ్‍; భా, మారకన తూబి, తారమా మేబి ర్హంకరతెతింమ్‍; ఇవ్నేబి అప్నమా ఏక్‍హుయిన్‍రానుకరి ఇవ్న ఖాజేస్‍ మే ప్రార్ధన కరుకురుస్‍; ");
INSERT INTO vgr_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","అప్నె ఏక్‍హుయిన్‍ ఛియ్యేతింమ్‍ ఇవ్నేబి ఏక్‍హుయిన్‍ ర్హానుకరి తూ మన దెవ్వాడిరాక్యోతె మహిమమా మే ఇవ్నా దిదో. ");
INSERT INTO vgr_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","ఇవ్నకన మేబి మారకనా తూబి రయ్యతొ ఇవ్నే సంపూర్ణుతరా హుయిన్‍ ఏక్నితరా ఛియ్యెకరి తూ మన మొక్లోకరి, తూ మన ఫ్యార్‍ కరోతిమ్మస్‍ ఇవ్నబి కర్యాకోస్కరి, ములక్ను మాలంకరతింమ్‍ మన అనుగ్రహించొతె ఫ్యార్ ఇవ్నాదిదొ ");
INSERT INTO vgr_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","భా మే కెజ్గారవుస్కీ ఎజ్గా తూ అనుగ్రహించితె ఇవ్నేబి మారకెడె ర్హానుస్‍కరి, తూ మన అనుగ్రహించుతె మారు మహిమనా ఇవ్నే దేక్నూకరి కోరిలెంక్రుస్‍ సానకతో ములక్‍ ఫైదాహుయుకొయింతె అగాడిస్ తూ మన ఫ్యార్‍ కర్యాకోస్‍. ");
INSERT INTO vgr_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","నీతి స్వరూపుడ్‍హుయోతె భా, ములక్ను తున మాలంకర్యూకొయుని; మే తున మాలంకర్యో; తూ మన మొక్లోకరి అవ్నేమాలంకరిన్‍ ఛా! ");
INSERT INTO vgr_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","తూ మారప్పర్‍ రాక్యోతె ఫ్యార్‍నా ఇవ్నకన ర్హానుతింమ్‍ మే ఇవ్నకన ర్హానుతింమ్‍ ఇవ్న తారు నామ్నా మాలంకర్యాయో అజుబి మాలం కర్యాస్‍కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","యేసు ఆవాతే హాఃరు బోలిన్‍ ఇనబద్మా ఇనా సిష్యుల్‍నా కేడె కెద్రొను లోయాన దాటిన్‍ గయ్యా, ఇజ్గా ఏక్‍ తోట్‍ థూ, ఎజ్గా యో ఇన సిష్యుల్‍తి మలిన్‍ జాస్‍ ");
INSERT INTO vgr_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","యేసు ఇనా సిష్యుల్‍తి మలిన్‍ ఘానిచోట్‍ ఎజ్గా గాయ్యో ఇనటేకె, ఇనా ధరైదెవ్వాలొ యూదానబి యో జోగొ గనుచోట్‍ మాలం థూ. ");
INSERT INTO vgr_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","ఇనహాఃజె యూదా రోమాసైనికుల్నా ప్రధానయాజాకుల్‍ పరిసయ్యుల్‍ బుజు మోక్లోతె బంట్రౌతుల్నా కెడెనాఖిలీన్‍ దివ్‍టిల్‍తి దివ్వోతి ఆయుధాల్‍తి ఎజ్గాగయు. ");
INSERT INTO vgr_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","యేసు ఇనాహుసేతెఖారు మాలంకరిన్‍ ఇవ్నాకన జైన్‍ తుమే కినా దుండుకరస్‍? కరి ఇవ్నా పుఛ్చావస్‍. ");
INSERT INTO vgr_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","ఇవ్నే బోలస్‍ “నజరేయుడ్‍ హుయోతే యేసున కరి” జావబ్‍ దేవమా యేసు యో మేస్‍ కరి ఇవ్నేతి బోలస్‍ ఇనా ధరైదిదొతే యూదాబి ఇవ్నే కెడె వుబ్రిన్‍ ర్హాస్‍ ");
INSERT INTO vgr_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","యేసు యో మేస్కరి ఇవ్నేతి బోలామ ఇవ్నే పిటె ఖార్కిన్‍ దర్లేవానటేకె తయార్‍హుయా. ");
INSERT INTO vgr_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","బుజెక్‍ చోట్‍ యో, తుమే కినా దూండుకరస్‍? కరి ఇవ్నేతి పుఛ్చావస్‍ ఇనటేకె ఇవ్నే “నజరెతు హుయోతె యేసు” కరి బోలామ. ");
INSERT INTO vgr_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","యేసు ఇవ్నేతి యో మేస్‍ కరి బోల్యొ థోని, ఇనటేకె తుమే మన దుండుకర్తా హుసెతొ అవ్నా జావదేవో కరి బోలస్‍ ");
INSERT INTO vgr_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","తూ మన అనుగ్రాహించోతే ఇవ్నామ ఏక్ జణుబి కోగమైలిదోని కరి యో బోల్యొతే వాత్‍ నెరవేర్నుతిమ్‍ అమ్‍ బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","సీమోన్‍బి పేతుర్‍కనా ఛారి ర్హావమా యో ఛారినా కడిన్, ప్రధానయాజకుడ్‍ను దాసుడ్‍నా ఖావ్వత్నుబాజును కాన్నా కాత్రినాకిదెస్. యో దాసుడ్‍ను నామ్‍ మల్కు. ");
INSERT INTO vgr_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","యేసు పేతుర్‍తి అమ్‍ బొల్యొ, తారు ఛారిన భేందా భా మన అనుగ్రహించ్యోతే గిన్ని మాను మినాత్‍ మే నా పినుసు. ");
INSERT INTO vgr_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","ఎత్రమాస్‍ రోమా అధికారులు, సైనికుల్బి, యూదుల్నూ బంట్రౌతుల్‍ యేసునా ధర్లీన్‍ ఇనా బాంధించ్యా. ");
INSERT INTO vgr_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","అగాడి అన్నాకనా లీన్జాస్‍ యో ఆ వరఖాను ప్రధానయాజాకుడ్‍ హుయోతె కయాపనా మామో ");
INSERT INTO vgr_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","ఏక్ అద్మి ప్రజల్‍నటేకె మరిజావను ప్రయోజాకరంకరి కయప యూదుల్నా ఆలోచాన బోల్యొహుయో. ");
INSERT INTO vgr_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","సీమోన్బి పేతుర్‍బి బుజేక్‍ సిష్యుడ్‍బి యేసునకెడె జంకరా. యోసిష్యుడ్‍ ప్రధానయాజకుడ్‍నా మాలంహుయో, అనటేకే యో ప్రధాన యాజక్ను ఘర్నువరన్డా యేసుతిబి గయా. ");
INSERT INTO vgr_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","పేతుర్నె ధర్వాజును భార్‍ ఉబ్రిన్‍తో పన్కి ప్రధానయాజక్న మాలంహుయోతె యో సిష్యుడ్‍ ఆయిన్‍ ఘర్‍వాలితీ వాత్‍బోలీన్‍ పేతుర్నా మహీ బులాలీన్‍గయో. ");
INSERT INTO vgr_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","ధర్వాజుకన కావ్లీచ్చాతే ఏక్ న్హాని పేతుర్‍తి తుబి ఇనా సిష్యుల్మా ఏక్‍జనొ కాహేనా? కరి బోలమా తెదె యో కాహేకరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","తెదె థండ్‍ లగమా దాసుల్బి బంట్రౌతుల్‍ ఆగ్‍ బాలీన్‍‌ షేక్తుహుయిన్‍ వుబ్రిన్‍ ర్హావమా పేతుర్‍బి ఇవ్నాకన వుబ్రిన్‍ ఆగ్ షేక్కోకర్తొ థో. ");
INSERT INTO vgr_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","ప్రధానయాజకుల్‍ ఇనా సిష్యుల్‍నా గురించిబి ఇనా బోధనా గురించి యేసునా పుఛ్చవమా. ");
INSERT INTO vgr_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","యేసు, మే హాఃరానఖామే వాతె బోల్యొ; యూదుల్‍ ఖారు జమాహువాతె న్యావ్‍కరనుజోగొ దేవును మందిర్‍మా కెదేబి బోధించో పన్కి చోరేతి మే సాత్బి వాతెబోల్యాకొయిని. ");
INSERT INTO vgr_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","తూ మన పుఛ్చావతెసాత్‍ మే తుమ్న సాత్‍ భోదించిరాక్యొతె ఖాంజిరాక్యుతె ఇవ్నా పుఛ్చావ్‍కరి; హదేక్‍ మే బోల్యొతే ఇవ్నామాలంకరి ఇనేతి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","యో ఆవాతె బోల్యొతెదె ఖాందె ఉబ్రీన్‍ ఛాతె ఇవ్నే బంట్రౌతుల్‍మా ఏక్జనో ప్రధాన్‍యాజకుడ్‍న్‍ అమ్‍ ఉత్తర్‍దెంకరస్‍నా; కరి బోలీన్‍ యేసున హాత్తి మార్యో. ");
INSERT INTO vgr_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","ఇనటేకె యేసు, అజ్గ ఛాతెఅద్మి హాఃర్వానా పుఛావో, మే సాత్బి తప్పుతి వాతే బోల్యొ హుసెతో మనాషే మారుకరతే? కరి బోలస్‍ ");
INSERT INTO vgr_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","ఎజాత్ను భైయే, యేసునా బంధిచిరక్యుతింమాస్‍ ప్రధానయజాకుడ్ హుయోతె కయపకనా మోక్లో. ");
INSERT INTO vgr_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","సీమోన్‍బి పేతుర్ వుబ్రిన్ థండ్‍ షేకుకరమా ఇవ్నే ఇనా దేఖీన్ తూబి ఇనా సిష్యుల్‍మా ఏక్ కాహేనా? కరి బోలామ మే కాహే యో మన మలంకోయిని కరి బోలస్‍ ");
INSERT INTO vgr_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","పేతుర్‍ కినా కాన్న కత్రినక్యోకి ఇవ్నీ మాయమత్రనూ ప్రధానయజాకుడ్మా దాసుడ్మా ఎక్బీ, తూ తోట్‍మా ఇవ్నేతీ మాలిన్‍ ర్హావను మే దేక్యోకోయిన్‍నా? కరి బోల్యొ, ");
INSERT INTO vgr_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","పేతుర్‍నే “మన మాలంకోయిని” కరి బుజేక్‍ తరా బోల్యొ తేదెస్‍ ముర్గు వ్వాస్యు. ");
INSERT INTO vgr_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","వానెఖాత్రే ఇవ్నే కయప ఘెర్మాకంతు లిన్ రోమా అధికారిన భంగ్లమా యేసునా బులైలిగయూ, ఇనఖాజే ఇవ్నే పస్కాను పండుగను దాన్‍ ఖావనటేకె అగాడి ఇవ్నే అచారం ప్రకారం మైలు పడకొయినితిమ్‍ ర్హానుకరి. ");
INSERT INTO vgr_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","అనహాఃజె పిలాతునే బాధర్‍ ఛాతే ఇవ్నాకన ఆయిన్‍ ఆ అద్మినా ఉప్పర్‍ తుమే కెహూ నేరాంనా నాఖుకరస్ కరి పుచ్చావమా? ");
INSERT INTO vgr_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","ఇనటేకె ఇనెతి అమ్ బోల్యు, ఆ తప్పు నాకర్యొతొ అన తుమారకనా ధరాయ్‍ద్యావనో కాహే ఇనెతి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","ఇనటెకె పిలాతునె ఇవ్నేతి తుమే అన బులాలిజైయిన్‍ తుమారు ధర్మషాస్ర్తంతింమ్‍ ప్రకార్‍ అన న్యావ్‍ తీర్చోకరి బోలమా; తెదె యూదుల్ కినాబి మరాణ షిక్చ నఖాన హమ్నా అధికారం కోయినికరి ఇనెతి బోల్యా ");
INSERT INTO vgr_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","ఇనఖాజే యేసు యో కేజాత్ను మరాణంనా మల్సేకి ఇనా సోచిలిన్‍ బోల్యుతే వాత్‍ నేరవేర్సే. ");
INSERT INTO vgr_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","తెదే పిలాతు బుజు రోమా రాజ్యఅధికారి భంగ్లుమా జైన్‍ యేసునా బులాయిన్‍ ఇనేతి తూ యూదుల్‍నో రాజోనా? కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","యేసునె తారు తూస్ ఆవాత్నా బొలుకరస్నా, నైహ్తో పార్లు మార గురించి బోలుకరూస్నా? కరి పుఛ్చాయో, ");
INSERT INTO vgr_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","ఇనాటెకె పిలాతు, మే యూదుడ్‍ కరి లైజొమ్‍ఖారస్నా? తారు స్వంతాద్మిన ప్రధానయాజాకుల్నా తునా ధరాయిదిదుని; తూ సాత్ యోకరి? పుఛ్చావమా. ");
INSERT INTO vgr_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","యేసు అమ్ బోల్య, మారు రాజ్యం ఆ ములక్‍ సంబంధి కహే “మారు రాజ్యం ఆ ములక్‍సంబంధి హుయుతో మే యూదుల్నా నా ధారైదెనుకరి మార సేవాకుల్‍ లడైయి కర్సె పన్కి మారు రాజ్యం అజ్గాను సంబంధహుయు కహేకరి” బోలస్‍ ");
INSERT INTO vgr_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","ఇనాటేకె పిలాతు, తూ రాజొనా? కరి ఇన పుఛ్చావమా యేసు తూ బోల్యోతిమ్ మాస్‍ మే రాజో; హాఃఛినాలిన్‍ సాబుత్ దెవనటేకె పైదాహుయో, అనా లీన్‍ ఆ ములక్మా ఆయిరోస్ హాఃచి హుయుతె హర్యేజను మార వాతె ఖాంస్చె కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","ఇనటేకె పిలాతు, హఃఛికతో సాత్‍? కరి ఇవ్నేతి బోల్యొ. యో ఆవాతె బోలిన్‍ భాధర్‍థూతె యూదుల్‍కన జైయిన్‍ ఇనకన కెహూ దోషంబి మన కోదెఖాయుని. ");
INSERT INTO vgr_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","పస్కాపండగనా ధన్నే మే ఏక్నా బేందేవను ఆచార్‍ ఛాకొన్నా మే యూదుల్‍నో రాజోన చుట్‍కార్ కరను తుమ్న ఇష్టంనా కరి బోల్యొ, ");
INSERT INTO vgr_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","బుజు ఇవ్నే అననొకొ, బరబ్బానా బెందాకరి బుజు‍ చిక్రాన్‍ బేంద్యూ, ఆ బరబ్బా బందిపోట్‍ ఛోర్‍. ");
INSERT INTO vgr_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","తెదె యేసున పిలాతునె ధరిన్‍ ఇన కొరడాల్తి మరాయా. ");
INSERT INTO vgr_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","సైనికుల్‍ కాట్ఠావ్ను డాలీనా కిరీటం అల్లిన్‍ ఇను ముడ్క్యాపర్‍ ఘాలిన్‍; ");
INSERT INTO vgr_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","తెదె బైంగని రంగ్ను లుంగ్డనా పెరాయిన్ ఇనకన‍ ఆయిన్‍ యూదల్నో రాజొ, అష్యల్ హువదాకరి బోలిన్‍ ఇన మార్య. ");
INSERT INTO vgr_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","పిలాతు బుజు భార్‍ ఆయిన్‍ “హదేక్‍ అన భాంతి మన కెహూ తప్పుబి దేఖావుకర కొయినికరి తమ్నా మాలం హూవదాకరి ఇన తుమారకనా బాధర్‍లిన్‍ ఆవుస్‍కరి” ఇవ్నేతి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","యో కాటొవ్ను కిరీటం బైంగని రంగ్ను లుంగ్డనా పెర్రాయిన్‍ యేసునె భార్‍ ఆవమా పిలాతు అమ్‍ బోల్యొ! హదేక్‍ ఆస్‍ యో అద్మికరి ఇవ్నేతి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","ప్రధానయాజకుల్‍బి బుజు భటుల్‍ ఇన దేకిన్ సిలువనాక్‍, సిలువనాక్‍ కరి చిక్రాన్‍ బేందమా తెదె పిలాతునె ఇనకన మన కెజాత్నూ దోషంబి మన దెఖావుకరకొయిని ఇనటెకె తుమేస్‍ అన బులాలిజైయిన్‍ సిలువ నాకోకరి ఇవ్నేతి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","ఇనాటేకె యూదుల్‍ హామ్నా ఏక్ నియామం ఛా! యో దేవ్నొ ఛియ్యోకరి ప్రాచారం బోల్లేవుంకరస్‍ ఇనాటెకె యో నియామంనా ఖాజే యో మారణ్‍ పాత్రుడు కరి బోలస్‍ ");
INSERT INTO vgr_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","పిలాతు యో వాతె ఖాంజిన్‍ బుజు ఘాణు ఢారిజైన్‍; ");
INSERT INTO vgr_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","పాచుఫారిన్‍ అధికార భంగ్లొ జైన్‍ తూ కెజ్గాతి ఆయో కరి యేసునా పుచ్చాయో, హుయితొబి యేసు ఇనా జావబ్‍ కొదిదొని. ");
INSERT INTO vgr_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","ఇనాటేకె పిలాతు, యేసుతి మారేతి వాతె కొబోలానిసూ? తునా భేమ్‍దెవనామి, బుజు తునా సిలువ నఖానబి అధికరం మన ఛా కరి తునా మాలంకోయినిసూ? ");
INSERT INTO vgr_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","ఇనాటేకె యేసు తునా యో అధికారం దేవ్‍కంతు ఆయితోస్‍ తప్ప మారఫర్‍ కెహూ అధికారంబి కోయిని. ఇనఖాజే మన తునా ధారైదేవ్వాలనా జాహఃత్‍ పాప్‍ షిక్చా ఇవ్నాఫర్‍ ఆవ్సే. ");
INSERT INTO vgr_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","ఆ వాతెనా లీన్‍ పిలాతు ఇనా విడుదలా కరనాటెకె కోషిస్‍ కరస్‍ పన్కి అద్మిహాఃరు ఛిక్రాన్‍ భేమ్‍తూ తు అనా విడుదలా కర్యోతో కైసర్‍నా భై కాహే ఇను యోస్‍ రాజో కరిలేవ్వాలో యో కైసరునా విరోధంతి వాతె బోలాన్‍తర్‍ కరి బోల్యా. ");
INSERT INTO vgr_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","పిలాతు ఆ వాతెవ్నా ఖాంజిన్‍ యేసునా బాధర్‍ బులైలిఆయిన్‍ “ఫాత్రో భంద్యుతే జోగొమా” న్యాయపిఠమ్‍ పర్‍ బేసిగో; హేబ్రి భాషమా యో జోగొను నామ్‍ గబ్బతా; ");
INSERT INTO vgr_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","యో ధన్‍ పస్కాకను సిధ్దార్చాను ధన్‍; తెదె ధోపారేను భారభజేన హుంకరా యో హదేక్‍ తూమరు రాజొకరి యూదుల్తి బోలమ ");
INSERT INTO vgr_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","ఇనటేకె ఇవ్నే గఛీన్తి ఛిక్నాన్‍ భేందిన్‍ అనా మర్రాకిదేవో మర్రాఖిదెవో సిలువనాకో కరి చిక్రణ్‍ బేంద్యు పిలాతు అదేక్‍ తుమే రాజోనా సిలువ నాకుసునా? కరి ఇవ్నా పుఛ్చావమా ప్రధానయాజకల్‍ కైసర్ తప్ప హామనా బుజు కెహూ రాజోబి కోయిని కరి బోల్యా. ");
INSERT INTO vgr_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","తెదె సిలువ నఖావనటెకేస్‍ ధరైయిదెస్. యో యేసునా ఇవ్నా ధర్యాయ్‍దిదొ. ");
INSERT INTO vgr_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","ఇవ్నే యేసునా బులాలీన్‍ గయూ. యో ఇను సిలువనా డొహిలీన్‍ కపాల జొగొమా గయా. హెబ్రీను వాత్మా ఇన గొల్గొతాకరి అర్థం. ");
INSERT INTO vgr_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","ఎజ్గా హంకల్నీ బజు ఏక్జన హింకల్నీ బజు ఏక్జననా ఇచ్మా యేసున రాఖిన్‍ ఇనకెడె బే జననా సిలువ నాక్యూ. ");
INSERT INTO vgr_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","బుజు పిలాతు, యూదుల్‍నో రాజో హుయోతే నజరేయుహుయోతే యేసు కరి పల్కఫర్ లిఖాయిన్‍ సిలువ ఫార్ మేంద్యా. ");
INSERT INTO vgr_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","యేసునా సిలువా నఖాయోతే జోగొ పటానంనా ఖాందె థూ, యో హెబ్రి, గ్రీక్, రోమా, భాషల్మా లీహఃయూ ఇనటెకె యూదుల్‍మా కెత్రూకి జణు ఇనా పడ్యూ. ");
INSERT INTO vgr_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","మే యూదుల్ను రాజో కరి యో బోల్యొ తిమ్‍ లిఖో, పన్కి యూదుల్ను రాజో కరి లిఖ్యునుకరి యూదుల్ను ప్రధానయాజకుల్‍ పిలాతుతీ బోలామ, ");
INSERT INTO vgr_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","పిలాతు ఇవ్నేతి అమ్‍ బొల్యో, మే లీక్యుతే సాత్కీ లిక్యో కరి బోల్యొ యో ఇమ్మస్‍ ర్హావదా. ");
INSERT INTO vgr_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","సైనికుల్‍ యేసునా సిలువనా నఖాది ఇనపాస్సల్తి, ఇనా ఉప్పర్ను లుండ్గానా లీన్‍ ఏక్‍ఏక్‍ సైనికుడ్‍నా ఏక్‍ఏక్‍ భాగ్‍ మలునుతీమ్‍ ఇనా ఛార్‍ భాగల్నా ఫాడ్యు, యో లుండ్గనా కుట్టు నారవ్వామా ఉప్పర్‍తూ మొత్తంబి నాఖాయిగొ పాన్కి ");
INSERT INTO vgr_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","ఇవ్నే ఇనా నాఫాడీన్‍ బుజు యో కినా ఆవ్సేకీ ఇనటెకె చీటీయే నాఖీయే కరి ఏక్నుఏక్‍ బొల్లీదు ఇవ్నే మార లుంగ్డా ఇవ్నామా భాగ్‍పాడిల్దా మార కుడ్తానటేకె చీట్లు నాక్సేకరి లేఖనంమా నేరవేర్చనటెకె ఆ జర్గ్యూ ఇనటేకేస్‍ సైనికుల్‍ అమ్‍ కర్యూ. ");
INSERT INTO vgr_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","ఇని ఆయాబి, ఇన ఆయాని భేన్‍బి క్లోపాని భావణ్‍ హుయితే మరియాబి బుజు మగ్దలలేని మరియబి యేసును సిలువకనా వుబ్రిన్ థా, ");
INSERT INTO vgr_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","యేసుఇని ఆయాబి యో ఫ్యార్‍ కర్యతో ఇనా భైయ్యే ఖందే వుబ్రిన్‍ రావను దేఖీన్‍ “ఆయా ఆదేక్‍ తారో ఛియ్యో కరి ఇని ఆయాతి” బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","పాస్సతి సిష్యుడ్‍ మ్హాడి దేఖిన్‍ “హదేక్‍ తారి ఆయా” కరి బోలస్‍ యో వఖాత్తీ లీన్‍ యో సిష్యుడ్‍ ఇనా ఘెర్మా రాక్యొ. ");
INSERT INTO vgr_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","ఇన పాస్సల్‍తీ సమస్తమ్‍ తెదేస్‍ ఖాతమ్‍ హువంకరస్‍ కరి యేసు మాలంకరీన్ లేఖనమ్‍ నేరవేరాఖార్కూ, మన తారఖ్‍ లాగుకరస్‍ కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","ఎజ్గా చిరకతీ బ్హరాయిన్‍ ఛాతె ఖాటు ద్రాక్చాను రహ్క్ పాత్ర ర్హావమా అనటేకె ఇవ్నే ఏక్ స్పాంజి చిరకతి డుబాయిన్‍, హిస్సోపు కొమ్మన బాందిన్‍ ఇనా మ్హోడన లగాడ్యు. ");
INSERT INTO vgr_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","యేసు యో రహ్క్ నా పిన్‍ సమస్తంను ఖారు బోలిన్‍ మూడుక్యు జుకాయిన్‍ ఆత్మాన దినాదిదో. ");
INSERT INTO vgr_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","యో ధన్‍ పస్కా పండగా సిద్దాపరచాను ధన్‍; బేంమాను రోజే ఆరమ్‍ కరను ధన్‍ మోటు ధన్‍ ఇనటేకె యో ఆంగ్తానా ఆరమ్‍ కరను ధన్‍ సిలువఫార్‍ నార్హానుతిమ్‍; ఇవ్నా గోడా తోడ్యునాకిదిన్‍ ఇవ్నా ఖాడైనాక్‍ కరి యూదుల్‍ పిలాతుతి బోల్యొ ");
INSERT INTO vgr_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","ఇనటెకె సైనికుల్‍ ఆయిన్‍ యేసు నాకడే మలైన్‍ సిలువ నాక్యుతే అగాడి వాలనబి గోడాన బుజు బేంమాను వాలనబి గోడానబీ తోడ్‍నాకిదిదూ. ");
INSERT INTO vgr_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","ఇవ్నే యేసు కనా ఆయిన్‍ ఇనేఖు అగాడిస్‍ మరిజావను దేఖీన్‍ ఇనా గోడా తోడ్యాకోయిని పన్కి, ");
INSERT INTO vgr_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","సైనికుల్‍మా ఏక్జనో ఇనా పాక్తినా హఃభల్తి టోచాస్ తేదెస్‍ లోహిబి పాని చూవాస్‍ ");
INSERT INTO vgr_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","యో దేక్యోతే ఆ సాబుత్‍దేవుకరస్‍; ఇను సాక్చం హాఃఛిస్‍ తుమే నమ్మ ఖార్కు యో హాఃచిబోలుకరస్‍ కరి యో మాలంకరిన్‍ ");
INSERT INTO vgr_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","ఇనా హడ్‍క్యామా ఏక్తోబి తుట్సేకొయినికరి లేఖనమ్‍ నెరవేరా హఃర్కు ఆ జారగస్‍ ");
INSERT INTO vgr_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","బుజు యో ఇన టోచ్యుతే ఇనా మ్హాడి దేక్సే కరి బుజేక్‍ లేఖానమ్‍ బోలుకరాస్‍. ");
INSERT INTO vgr_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","ఇనా పాస్సల్‍తి యూదుల్ ఢార్జావమా ఛోరేతి యేసునో సిష్యుడ్‍ హుయోతె అరిమతయియతు యోషేపు యో యేసును మూర్దొ లీన్‍జావనటెకె పిలాతు కనా మంగాస్‍ పిలాతు లిన్జాకరి బోలాస్ ఇనాటేకె యో ఆయిన్‍ యేసును షేవంన లీన్‍ జాస్‍ ");
INSERT INTO vgr_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","అగాడి రాత్నువహఃత్‍ ఇనహాఃమే ఆయుతె నీకొదేమ్‍బి బరాబ్బర్‍ ఢోడీహ్ః కిలోను బోలమ్‍న బుజు చంధన్ వ్హాక్ను జాఢు ద్రవ్యమ్‍, ఊద్నికాడినా ఇనకేడె లీన్‍ ఆయు. ");
INSERT INTO vgr_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","ఎత్రస్‍మా యేసును షేవంనా పల్లీన్‍ ఆయిన్‍ యూదుల్‍ మర్యాదాతీ గాడతిమ్‍ యో సుగంధా ద్రవ్యము ఇనా లోథిన్‍ ధోలు లుంగ్డా లాప్టూతు సమాధినాటెకె తయార్‍ కర్యు ");
INSERT INTO vgr_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","యేసునా సిలువ నాక్యుతే జొగోమా ఏక్ భాగ్‍ థూ యో బాగ్మా కోన్బి కెదేబి ర్హావనాటెకె నవూ సమాధి ఏక్ థూ ");
INSERT INTO vgr_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","యో సమాధి ఖాందే ర్హవామ ఇనటెకె యో ధన్‍ యూదుల్‍ను సిద్ధపరుచను ధన్‍ రవమా ఇవ్నే యేసునా ఇన్మా మేల్యా. ");
INSERT INTO vgr_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","ఆదివారంనా జరా రాత్‍రవ్వాన వ్హానె హఃత్రేస్‍ మగ్దలేని మరియ వ్హానే ఘొరాఢకనా ఆయిన్‍ ఘొరాఢన ఫర్‍ ముచ్చాయూతే బండొకాఢిన్‍ రవ్వమా దేఖి. ");
INSERT INTO vgr_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","అనటేకే మరియ మిలావ్తీహుయిన్‍ సీమోన్‍ పేతుర్‍కనబి యేసునె ఫ్యార్‍కర్యొతె యోఅజేక్‍ సిష్యుడ్‍కనా ఆయిన్‍ ప్రభువున ఘొరాఢమతూ పల్లీన్‍ గయూ ఇన కెజ్గా రాఖ్యాకి మాలంకొయినికరి బోల్యూ. ");
INSERT INTO vgr_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","అనటేకే పేతుర్‍బి అజు సీమోన్‍ ఇను యో సిష్యుడ్‍ నిఖిన్‍ ఘొరాఢకన ఆయూ. ");
INSERT INTO vgr_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","ఇవ్నేబేజణ మలీన్‍ మిలావుతూ రవ్వమా, యో సిష్యుడ్‍ పేతుర్‍తిబి ఎగ్గిస్‍ మిలావ్తూహుయిన్‍ అగాఢి సమాధికనా ఆయిన్‍ ");
INSERT INTO vgr_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","మహీ జుఖీన్‍ దేఖ్మ ధోలు లుంగ్డా పఢిన్‍రవ్వాను దేఖ్యొ పన్కి ఇనే గోరేడుమా ప్రవేసించోకొయిని. ");
INSERT INTO vgr_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","సీమోన్‍బి పేతుర్‍ ఇనాకెడె ఆయిన్‍ ఘొరాఢమా గయ్యా. ధోలా లుంగ్డా పడిర్హావనుబి ");
INSERT INTO vgr_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","ఇను ముఢ్క్యాను టువాల్నా ధోలు లుంగ్డా కనా కొయినితిమ్‍ అలాదూ ఏక్ జోగొమా లప్టేన్‍ ర్హావను దేఖాస్‍ ");
INSERT INTO vgr_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","తెదె అగాఢి సమధికనా ఆయుతే యో సిష్యుడ్‍ మహీజైన్‍ దేఖిన్‍ నమ్మాస్‍ ");
INSERT INTO vgr_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","యో మరణ్‍ మతూ ఉట్టాను హాఃచీ కరి లేఖనాల్మా ఇవ్నే బుజుబి గ్రహించకోయిని. ");
INSERT INTO vgr_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","తెదేస్‍ యో సిష్యుల్‍ పాచు ఫరీన్‍ ఇవ్నా ఘర్కనా చలిగొ. ");
INSERT INTO vgr_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","తెదె మరియా సమాధినా భాధర్‍ వుబ్రిన్‍ రోవుంకర్తితి, యో రొవ్తీహుయీన్‍ సమధిమా జుకీన్‍ దేకమా. ");
INSERT INTO vgr_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","ధోలు లుంగ్డా పేరాక్యుతె బేజాణ దేవ్నుదూతల్‍ యేసును మూర్దు మ్హేలురాక్యుతె జోగొమా ముడక్యా మ్హానె ఏక్జాణు గోడా మ్హాడి ఏక్జాణు బేసిన్‍ ర్హావను దెఖాయా. ");
INSERT INTO vgr_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","తెదె దూతాల్‍ మరియతి ఆయా సానటెకే రోవుంకర్‍ కరి ఇనా పుఛ్చావమా, “మరియ మార ప్రభూన కోన్కి పల్లిచలీగు, ఇనా కిజ్గా మ్హేలిరాక్యుస్కి మన మాలంకోయిని” కరి బోలి. ");
INSERT INTO vgr_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","యో ఆ వాతె బోలిన్‍ ఫిటేఫరీన్‍ యేసు వుబ్రిన్‍ ర్హావాను దేఖి పన్కి యో యేసు కరి హాఃనాద్‍ ధరికోయిని. ");
INSERT INTO vgr_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","యేసు ఆయా సానటేకె రోవుంక్రస్ కినాటెకె ధూండుకరస్‍? కరి మరియన పుఛ్చావమా యో బాయికో ఇనా తోటా మాలికరి లైహీజైన్‍ ఖాయాబ్‍ తూ ఇనా లీన్గయోతోబి ఇనా కిజ్గా మ్హేల్‍రాక్యోస్కీ మన బోల్‍ మే ఇనా పల్లీన్‍ జైస్‍ కరి బోలి. ");
INSERT INTO vgr_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","యేసు బాయికోన దేఖిన్‍ మరియ కరి బూలైన్‍ యోబాయికొ ఇనా భాణే ఫరిన్‍ ఇనా హేబ్రి భాషమా రబ్బూని కరి బూలవస్‍ యో వాత్నా బోధకుడ్‍ కరి అర్థం ");
INSERT INTO vgr_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","యేసు భాకోతి మే బుజుబి భా కన గయోకొయిని; అనటేకే మన ఛీమ్నోకో; హుయుతొ మార భైయేకనా జైయిన్‍ మార భా తుమార భా బి, మార దేవ్బి తుమార దేవ్‍హుయోతె ఇవ్నాకన ఫరిన్‍ జంకురుస్ కరి ఇవ్నేతి బోల్కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","మగ్దలేనే మరియ ఆయిన్‍ మే ప్రభువునా దేక్యితి, యో మారేతి ఆ వాతె సిష్యుల్నా బోల్కరి మాలంకర్యి. ");
INSERT INTO vgr_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","ఆదివార్న హఃజే సిష్యుల్‍ యూదులనా అధికారల్‍ ఢరీన్‍ ఇవ్నే ఛాతె ఘర్ను తలుపున మూఛిలీన్‍ రవ్వామా యేసు ఆయిన్‍ ఇచ్మా ఉబ్రీన్‍ తుమ్న షాంతి హువదాకరి ఇవ్నేతి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","యో ఇమ్నితర బోలీన్‍ ఇవ్నాఇను హాత్నా బగల్‍ వతాలమా, సిష్యుల్‍ ప్రభూవున దేఖీన్ ఖుషిహుయూ. ");
INSERT INTO vgr_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","తెదె యేసు బుజు తుమ్న సమాధనంతి హువదా, భా మన మొక్లోతిమ్మస్‍ మేబి తుమ్న మొక్లూ కరూస్కరి ఇవ్నేతి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","యో ఆవాతె బోలీన్‍ ఇవ్నాఫార్‍ పూఖీన్ పరిసుద్ధాత్మనా పొందొ ");
INSERT INTO vgr_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","తుమే కినా పాప్నా మాప్‍ కరస్కి, ఇవ్నా పాప్‍నా మాప్‍ కర్సె; కిను పాప్న తుమే రాఖస్కి యోపాప్‍ ఇమ్మస్‍ ర్హాసెకరి తుమారేతి బోలుకరూస్‍. ");
INSERT INTO vgr_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","యేసు ఆయోతెదె, భారజణమా ఏక్జనో దిదుమకరి బొలావతె తోమా ఇవ్నమా కోథోని. ");
INSERT INTO vgr_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","అనటేకే మిగ్లితె సిష్యుల్‍ “హమే ప్రభువునా దేక్యాకరి ఇనేతి బొలమా యో మేఇను హుత్మా మేక్నుగుర్తునా దేఖీన్‍ మార అంగ్లీయే యోమేక్ను గుర్తుమా బేందీన్‍ మార హాత్న ఇను హాత్న హఃమే రాక్యొతోస్‍ పన్కి నమ్మనూస్‍ నమ్మిస్‍కొయినికరి” ఇవ్నేతి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","ఆ‍ఠ్మాను ధనే‍ ఇను సిష్యుల్‍ బుజు మహీ రయ్యూతెదె తోమా ఇవ్నేతి మలిన్‍ రయ్యోతొ. తలుపు ముఛ్చాయిన్‍ రవ్వామా యేసు ఆయిన్ ఇవ్నాయిచ్మా ఉబ్రిన్‍ “తుమ్న సమాధానంహువదా” కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","పాసల్తీ తోమాన దేఖిన్‍ తారు హాత్‍ హంకడ్‍ ఛీదుకరిన్‍ మార హాత్న దేక్‍; తారహాత్‍ ఛీదుకరీన్‍ మార పహాఃలిమా రాఖ్‍ అవిష్వాసం కొయినీతింమ్‍ విష్వాస్‍హుయిన్ ర్హాకరి‍ బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","అనటేకే తోమా ఇనేతి మార ప్రభూ, మార దేవ్‍ బోల్యొ ");
INSERT INTO vgr_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","యేసు తూ మన దేఖీన్‍ నమ్యో, దేఖకొయినీతింమ్‍ నమ్మితెయివ్నే ధన్యుల్‍కరి ఇనేతి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","బుజు కెత్రూకిహుయుతె అలాదు ఖానద్ను క్రియల్‍నా యేసు ఇను సిష్యుల్‍నఖామే కర్యొ; యో ఆ తలాక్ను కాగత్‍ లిక్కారుకొయినీ ");
INSERT INTO vgr_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","పన్కి యేసు దేవ్ను ఛియ్యోహుయోతె క్రీస్తుతుకరి తుమే నమ్నూతింమ్‍, నమ్మిన్‍ ఇను నామ్మా జీవమ్‍ పొందునుకరి ఆ లిక్కాయ్‍రూస్‍. ");
INSERT INTO vgr_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","ఇనపాసల్తీ యేసునె తిబెరియ ధర్యావ్‍ను కనారికన సిష్యుల్నా బుజేక్‍తార యోస్‍ ప్రత్యక్చాపరచిలిదో. ");
INSERT INTO vgr_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","కింమ్‍కతో సీమోన్‍కరి బోలవాతే పేతుర్‍బి, దిదుమకరి బోలావతె తోమాబి, గలిలయమా కానాకరి గామ్‍వాలొహుయుతె నతనయేల్‍బి, జెబెదయని ఛియ్యాబి, బుజు ఇను సిష్యుల్‍మా బుజు బే జనబి మలిన్‍ రయ్యుతూ. ");
INSERT INTO vgr_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","సీమోన్‍ పేతుర్‍ మే మాస్లాధరనటెకె జంకరస్‍ కరి ఇవ్నేతి బోలమా ఇవ్నే హమేబి తారకేడె అయేస్కరి బోల్య. ఇవ్నే జైయిన్‍ ఢోంగాచఢ్యా పన్కి, యోరాతె సాత్బి ధర్యాకొయిని. ");
INSERT INTO vgr_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","వానేఖాత్రే హుంకరమా యేసు కనారిన ఉబ్రిన్‍ థో, పన్కి యో యేసుకరి సిష్యుల్‍ ఖానద్‍ కర్యకొయిని. ");
INSERT INTO vgr_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","యేసు “దోస్త్, ఖావనటేకె తుమారకనా సాత్బి” ఛా? కరి ఇవ్నా పుఛ్చావమా కొయినికరి ఇవ్నే ఇనేతి బోల్యా. ");
INSERT INTO vgr_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","తెదె యో ఢోంగాన ఖవ్వాత్‍ భణే జర్యాన నాక్కో తుమ్నామల్చేకరి బోల్యొ. అనటేకే ఇవ్నే ఇంకరమా, మాస్లా జాఖాత్తి పఢమా జర్యానకేఛనబి కో హుయూని. ");
INSERT INTO vgr_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","తెదె యేసు ఫ్యార్‍కర్యతె సిష్యుడ్‍ ఇనే ప్రభువుకరి పేతుర్‍తీ బోల్యొ. యో ప్రభువుకరి సీమోన్‍ పేతుర్‍ హాఃజీన్‍ ఉగ్గాడహుయిన్‍ రవ్వామా ఉప్పర్‍నులుంగ్డాన నాఖిలీన్‍ ధర్యావ్మా కూదిగా ");
INSERT INTO vgr_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","కనారిన బరాబ్బర్‍ బే ఖో మూరల్ను దూర్‍ రవ్వామా. మిగ్లితె సిష్యుల్ మాస్లా‍తూతె జర్యాన కేస్తూ యోహాను ఢోంగమా ఆయూ. ");
INSERT INTO vgr_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","ఇవ్నే ఉత్రీన్‍ కనారిన ఆవుంస్‍కరా ఎజ్గా ఆగ్బి ఇనప్పర్‍ బేంద్యురాక్యుతె మాస్లాబి, రోటా దెక్కాయు. ");
INSERT INTO vgr_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","యేసు ఇవ్నేతి తుమేహంకె దర్యాతె మాస్లామా థోడులీన్‍ ఆవోకరి ఇవ్నేతీబోలమా ");
INSERT INTO vgr_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","సీమోన్‍ పేతుర్‍ ఢోంగచఢిన్‍ జర్యానా కనారినా కేఛ్యూ యో ఏక్‍ఖో తీన్‍ప్పర్‍ అఢాయక్ మోట్టా మాస్లావ్తీ బరాయిన్ తూ కెత్రూకి మాస్లా జర్యా బరాయ్‍యిన్‍ పడితోబి జర్యా జరబీ పాట్యూకొయిని. ");
INSERT INTO vgr_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","యేసు బోల్యొ ఆవో ఖవ్వోకరి ఇవ్నేతి బోల్యొ. యో ప్రభువుకరి ఇవ్నా మాలంహుయ్‍జావమా తూ కోన్కరి సిష్యుల్మా కోన్బి ఇన పుఛ్చావన కినా హాత్కోహుయూని. ");
INSERT INTO vgr_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","యేసునె ఆయిన్‍ యోరోట్టన తోఢీన్‍ ఇవ్నా భాగ్‍పాడ్యొ. ఇమ్మస్‍ మాస్లానబీ భాగ్‍పాడీన్‍దిదో. ");
INSERT INTO vgr_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","యేసు మరన్‍మతూ ఉట్టీన్‍ పాసల్తి సిష్యుల్న ప్రత్యక్చహువనూ ఆ తీన్‍మనూఛోట్‍. ");
INSERT INTO vgr_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","ఇవ్నే ఖానుఖైయిన్‍ పాసల్తీ యేసు సీమోన్‍ పేతుర్న దేఖీన్‍ యోహాన్ను ఛియ్యో‍హుయోతె సీమోన్‍, అవ్నెతిబి తూ మన జాఖాత్తి ఫ్యార్‍కరూకరస్‍న్నా? కరి పుఛ్చావమా ఇనే ఓవో ప్రభూ, మే తునా ఫ్యార్‍కరూకరస్‍ కరి తునాస్‍ మాలంకరి ఇనేతి బోల్యొ; యేసునె మారు మ్హేండన చరావ్కరి ఇనేతి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","బుజేక్తార యో యోహాన్‍‌ ఛియ్యోహుయోతె సీమోన్‍ మన ఫ్యార్ కరుకరస్‍నా? కరి బెంమ్మనితార ఇనస్‍ పుఛ్చావమా ఇనే ఓహో ప్రభు మే తున ఫ్యార్‍కరుకరస్‍ కరి తూస్‍ మాలంకర్‍ లీస్కరి ఇనేతి బోల్యొ యేసునె మారు మ్హేండన కాప్లారవ్వోకరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","తీన్మనుఛోట్‍ యో యోహాన్ను ఛియ్యోహుయోతె సీమోన్‍, మన ఫ్యార్ కరుకరస్నా? కరి తీన్మను ఛోట్‍ ఇనస్ పుఛ్చాయోకరి పేతుర్‍ ఇబ్బందిహుయిన్‍ ప్రభూ, తూ సమస్తంనా మాలంకర్యాకోస్‍, తున ఫ్యార్‍కరూకరస్‍ కరి తూస్‍ మాలంకర్‍లిస్కరి ఇనేతి బోల్యొ. యేసు బోల్యొ, మార మ్హేంఢన ఛరావో. ");
INSERT INTO vgr_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","తూ కవ్వారోహుయో తెదె తారుతూస్‍ కంబర్నా బాంధిలీన్‍ సిద్దపఢిన్‍ తున ఇష్టంహుయు జొగోమా పర్తోరయ్యో; తూ భుఢ్డోహుయో తెదె తారహాత్ తూ పహాఃరిస్‍ అజేక్జనో తారు కంబర్నా బాంధీన్‍ తున ఇష్టంహుయు జొగోమా తున ఢోహిలీన్‍ జాసేకరి తారేఖూ హఃఛితీ బోలుకరూస్కరి ఇనేతి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","ఇనే కెజాత్నూ మరణ్తి దేవ్నా మహిమపర్చేకి ఇన సోచీన్‍ యో ఆవాత్నా బోల్య. అమ్‍ బొలీన్‍ “మార కెడె ఛాలో” ఇనెతి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","పేతుర్‍ పీట్టేపరీన్‍ యేసు ఫ్యార్‍కర్యోహొబి ఖాణు ఖాహాద్యతె బంతిన ఇను ఛాతికన లగాడీన్‍ ప్రభూ, “తున దర్యాయ్‍దె వాలో కోన్కరి పుఛ్చాయోహొ” సిష్యుడ్‍ ఇవ్నాకెడె ఆవను దేక్యొ. ");
INSERT INTO vgr_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","పేతుర్‍ ఇన దేఖిన్‍ ప్రభు, అను సంగతి సాత్‍హుసేకరి యేసున పుఛ్చాయో. ");
INSERT INTO vgr_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","యేసు బోల్యొ, “మే ఆవతోడి ఇనే రవ్వాను మన ఇష్టంహుయుతొ యో తునసే? తూ మారకెడె ఛాల్‍కరి” బోల్యు. ");
INSERT INTO vgr_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","ఇనఖాజే యోసిష్యుడ్నె మర్చెకొయినికరి వాత్‍ భైయేమా ప్రచార్‍హుయు. పన్కి యేసు మర్సెకొయినికరి యేసు ఇనేతి బోల్యొకొయిని పన్కి మే ఆవతోడి యో రవ్వాను మన ఇష్టంహుయుతొ యో తునసేకరి? బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","ఆ సంగతుల్న బారెమా జామీన్‍బోల్తూ ఆ లీక్యోతె సిష్యుడ్‍ ఆస్‍; అను సాబుత్‍ హాఃఛికరి మాలం‍కరిన్‍ ఛా. ");
INSERT INTO vgr_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","యేసు కర్యోతె కార్యల్‍ బుజుబి కెత్రూకి ఛా. ఇనమా హర్యేక్‍నా వివరించిన్‍ లీక్యుతో ఇంమ్‍ లిక్కాయుతె తలాక్ను కాగత్‍బి ములక్ను పూర్సెకొయినికరి మన సొచ్చాంకరాస్‍.");
INSERT INTO vgr_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","ఓ థెయోఫిలా యేసు స్వర్గంమా చేర్సాయిగయోతే ధన్తోడి అజు బోధించనటేకెబి సురుకర్యోతె ఇనాహాఃరనా గూర్చి మారు సఫ్హైలు గ్రంథంమా లిఖ్యొ. ");
INSERT INTO vgr_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","ఇనా బాద్మ యేసు ఇను ఏర్పచిలిధోతె అపొస్తుల్నా పరిసుధ్ధాత్మాతి ఆజ్ఞాపించొ, ");
INSERT INTO vgr_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","యో మరిగ్యొతె ఇనబాద్మ చాలిహ్క్ ధన్తోడి ఇవ్నా దెఖౌతోహుయీన్‍, దేవ్ను రాజ్యంనూ విషయాల్నా గూర్చి వాతె బోల్యొ, యో బోల్యెతె వాతె రుజువు కర్తొ హుయిన్‍ గయో ఇవ్నా ఇనుయోస్‍ జీవ్తొనితరా దెఖ్కాఢిలిదొ. ");
INSERT INTO vgr_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","యో ఇవ్నేతి మలీన్‍ అంనింతరా ఆజ్ఞదిదో, “తుమె యెరూషలేమ్నా మేంధిన్‍ నాజైన్‍ మారేతి హఃమ్జతె మే బోల్యొతె భానూ వాగ్దనంనాటేకె దేక్తార్హవొ ");
INSERT INTO vgr_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","యోహాన్‍ తుమ్నా పానిమా బాప్తిస్మమ్‍ దిదో, పన్కి థోడు ధన్మాస్‍మా తుమే పరిసుధ్దాత్మమా బాప్తీస్మమ్‍ లీస్యు.” ");
INSERT INTO vgr_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","తెదె ఇవ్నె హాఃరు గల్లొహుయీన్‍ ఆయుతెదె‍ ప్రభూ, ఆ ధన్మా ఇస్రాయేల్నా రాజ్యంనా అజు దీస్నా? కరి ఇనా పుచ్ఛావమా యో, ");
INSERT INTO vgr_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","యేసు ఇవ్నే అంబోల్యొ “ధన్మాబి వహఃత్నాబీ భా ఇను స్వాధినంమా కర్రాక్యోస్‍ ఇనా మాలంకరనూ తుమారు కామ్‍ కాహే. ");
INSERT INTO vgr_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","హూయితోబి పరిసుద్ధాత్మ తుమారఫర్‍ ఆయుతెదె తుమ్నా థాకత్‍ పోంద్సు, ఇనటేకె తుమే యెరూషలేమ్మా యూదయా సమరయ దేహ్క్ హఃరవ్మాబీ జమీన్‍ ఆఖరితోడీ మన సాక్చుల్‍నితర” ర్హాసు. ");
INSERT INTO vgr_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","ఆవాతె హాఃరు బోలిన్‍, ఇవ్నె దేకుకరతో యో స్వర్గంమా లేవ్వాయ్‍ గయో, యువ్నా ఢోలాన నాదెఖౌనూతిం ఏక్ మబ్బు ఇన ఢాపినాక్యు. ");
INSERT INTO vgr_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","యో ఛల్ ‍ జోంగ్రతో ఇవ్నే ఇమ్మాస్‍ ఆకాష్‍ భనే దేక్తూ ర్హావమా యెత్రాస్మా ధోళుఫట్‍ లుంగ్డా పెర్రాక్యూతె బే అద్మి ఇవ్నాకనా ఆయిన్‍ ఉబ్రీన్‍, ");
INSERT INTO vgr_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","గలిలయను అద్మియే, “తుమే ష్యాన ఉబ్రీ‍న్‍ ఆకాష్‍భణీ దేకుకరాస్‍? తూమారకంతూ స్వర్గంమా ఛలొగోతె ఆ యేసు స్వర్గంమా జావనూ కిమ్‍ దేఖ్యకీ, ఇమ్మస్‍ ఇనె పాఛు ఆవ్సె” కరి ఇవ్నేతి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","తెదె యో సిష్యుల్‍ ఒలీవనూ బాగ్‍ కరి ఫాహాడ్‍తూ యెరూషలేమ్నా పాఛుఫరీన్‍ గయా. యో ఫాడ్‍ యెరూషలేమ్నా బే పర్లాంగ్‍ దూర్‍మా ఛా. ");
INSERT INTO vgr_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","ఇవ్నె హఃయార్మా జైన్‍ ఇవ్నే అగఢీ ర్హయతె మేడగది చఢీన్‍ గయా. ఇవ్నే కోన్కతో పేతురు, యోహాన్, యాకోబ్‍, అంద్రెయ, ఫిలిప్పు, తోమా, బర్తొలోమయి, మత్తయ, అల్ఫయినో ఛియ్యో, యాకోబు, మతాభిమానికరి బోలాతె సీమోను, యాకోబునో ఛియ్యోహుయోతె యూదా. ");
INSERT INTO vgr_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","అవ్నే హఃరూబి, అవ్నకేడె థోడు బాయికాబి యేసుని ఆయాహుయ్తె మరియబి ఇనా భైయ్యేబి హఃరు హఃఛుదిల్తి విస్సక్నూ నాతిమ్‍ ప్రార్థన కర్తూరయు. ");
INSERT INTO vgr_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","థోడ ధన్నా పాసల్‍ బరోభర్‍ ఖోఃఫర్ ఈహ్ః అద్మి భైయ్యే ఏక్ జోగె మలీన్‍ ర్హావమా పేతురు ఇవ్నా ఇఛ్మా భీరిన్‍ అమ్‍ బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","భైయ్యే, యేసునా ధరాయుతే ఇవ్నా వాట్‍ దెఖాడ్యోతె యూదానటేకె పరిసుధ్దాత్మ దావీద్‍నా బారెమా జమానమా బోలాయుతే లేఖనం నెరవేరనూ తూ. ");
INSERT INTO vgr_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","యో అప్నమా ఏక్నితర రయీన్‍ సేవ పరిచర్యమా భాగ్ హురోస్. ");
INSERT INTO vgr_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","యో యూదా కుట్రతీ కమయోతే రఫ్యాతీ ఏక్ ఖేథర్నా మోల్‍ లిదో. ఇను ముడ్కుయు హేట్కరీ పడీన్‍ పొట్పుటిన్ ఇను అతల్డీ హాఃరు భాధర్‍ ఆయు. ");
INSERT INTO vgr_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","ఆ సంగతి యెరూషలేమ్మా చాతేఇవ్నా హఃరనా మాలంహూయు, అనటేకే ఇవ్ను బాషమా యో ఖేథర్నా అకెల్దమ కరి బొలాయ్‍రూస్‍. కతో లోహినూ జమీన్‍ కరి అర్థం. ");
INSERT INTO vgr_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","ఇను ఘర్‍ ఉజ్జాడ్‍ హూయిజానూ ఇన్మా కోన్బి కాపురం నారను ఇను నౌకరీ బుజేక్ జణో లీలేను కరి కీర్తనల్‍మా లిఖ్కైరూస్‍. ");
INSERT INTO vgr_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","అనటేకె యో అప్న ఇఛ్మా రయోతె ధన్‍ హఃరు అప్నేతి మలీన్‍ రయోతె అవ్నమా ఏక్జణో, అప్నే ఏక్జణో ఎంచిలేవాను అవరసరమ్. ");
INSERT INTO vgr_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","ఇనటేకె యోహాన్‍ బాప్తిస్మమ్‍ ధిదోతే ధరీన్‍ ప్రభు హూయోతే యేసు అప్నకంతూ స్వరగ్మా ఛలీగయోతే ధన్తోడి, జీవిన్‍ ఉట్టేతె ఇను సాక్చినితరా ర్హావను కఛ్చితంకరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","తెదె ఇవ్నే యూస్తుకరీ ఉజేక్‍ నామ్తి బోలావతే బర్నబాకరి బోలతె యోసేప్నబీ, మత్తీయనబీ కరి ఉభర్కాడీన్‍, ");
INSERT INTO vgr_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","అమ్‍ బోలిన్‍ ప్రార్థన కర్యో, హఃరవ్నూ దిల్‍ మాలంకర్‍ రాక్యోతే ప్రభూ ");
INSERT INTO vgr_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","ఇను జావనూ జోగో మెందిన్‍, తప్పిగయోతే యూదా, గమైల్దోతే పరిచర్యనా అపొస్తల్‍ను కామ్మా సేవాకరనా ఆ బేజణమా తూ బులాంకరతే ఇనా దేఖాడ్‍ కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","యత్రమా యూవ్నే బే జణనా గూర్చీ చీట్లు నాఖమా మత్తీయనూ నామ్తి చిటీ ఆయు, అనటేకే ఇనా గ్యారజణా అపొస్తల్‍తీ మలాన్‍ గణాయిగయో. ");
INSERT INTO vgr_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","పెంతెకోస్తు ధన్‍ ఆయుతెదె హాఃరుజణు ఏక్ జొగోమా భరైన్‍ రయూ. ");
INSERT INTO vgr_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","తెదేస్‍ జోరేహూః వాగతే వాయ్రోనూ జోణ్నూ ఏక్ ఆవాజ్‍ ఆకాష్‍ మతూ యత్రాస్‍మా ఇవ్నే బేఠూతె ఘర్ అక్కు భరైగయూ. ");
INSERT INTO vgr_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","బుజు ఆగ్ను జల్ఫట్‍ను జోణ్నూ జీబే అలాదు చిరాంవాంతర యూవ్నా దేఖైన్‍, యువ్నమా హర్యేక్‍ జనణా ఉఫ్పర్‍ ఆయూ. ");
INSERT INTO vgr_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","తెదె హాఃరు జణు పవిత్రాత్మతీ భరైన్‍హుయీన్‍, యో ఆత్మ యువ్నా షక్తీ ఆయిన్‍ అన్యభాషతీ వాతె బోలానిక్యా. ");
INSERT INTO vgr_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","యో ధన్‍మా ప్రపంచంమా ర్హాయ్తె హర్‍ జనంమతూ ఆయూతే కెత్రకి భక్తీవాళు యూదులు యెరుషలేమ్‍మా జీంకర్తూ థూ. ");
INSERT INTO vgr_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","ఆ ఆవాజ్‍ హూవమా ఆద్మియే హాఃరు భరైన్‍ ఆయిన్‍, హర్‍ అద్మి ఇన్ను సొంత భాషమా బోలుకరాతే హఃమ్జీన్‍ గబ్రాయిగయూ. ");
INSERT INTO vgr_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","యత్రమా హఃరు ఆష్చర్యం హూయిన్‍, వాతె బోలుకరాతే ఆవ్నే హఃరు గలిలయను కాహేనా? ");
INSERT INTO vgr_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","అప్నమ హర్యేక్‍ జను యో పైధహుయోతే దేహ్ఃను సొంత భాషమా బోలుకరతో అప్నె కిమ్‍ హఃజుకరూస్‍? ఆ ష్యాత్‍? ");
INSERT INTO vgr_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","పార్తీయులు, మాదీయులు, ఏలామీయులు, మెసొపొతమియ, యూదయ, కప్పదొకియులు, పొంతు, ఆసియా, ");
INSERT INTO vgr_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","ప్రుగియ పంపులియ ఐగుప్తు కరి దేఖ్ను వాళు యూవ్నే. లిబియమను కురేనేనా సేడె ఛాతే నంగిరి కనా కాపురం కరవాళు, ఇవ్నే రోమతు ఆయూతే ఇవ్నే, ");
INSERT INTO vgr_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","యూదుల్‍, యూదా జాత్ను చేర్యుతె ఇవ్నే. క్రేతీయులు, అరబీయులు కెత్రూకి థోడుబోత్‍ అప్నె హాఃరు అవ్నె అప్ను భాషల్‍తి దేవ్నూ గోప్ప కార్యల్‍నా బోలుకరతో హఃమ్జు కరూయేస్‍నికరి బొల్లీదు. ");
INSERT INTO vgr_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","హఃరు జణు గభ్రాయిజైన్‍ కాయిబి నా సొచైన్‍ ఆ ష్యాత్‍ హుసేకరి ఏక్తీ ఏక్ బొల్లీదు. ");
INSERT INTO vgr_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","అజు థోడుజణు నవూ ధారు పీన్‍ మత్తుమా ఛా కరి గేలి కాడ్యు. ");
INSERT INTO vgr_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","తెదే పేతురు గ్యార జణతీబి, ఉట్టీన్‍ భీరిన్‍ ఇవ్నేతి ఘట్‍ ఛిక్రీన్‍ అమ్‍ బోల్యొ; యూదయనూ అద్మీయే, యెరూషలేమ్మా జీవుంక్రతే హఃరజణ ఆవాత్‍ తుమ్నా మాలంహోణు ఖాన్‍ జోడీన్‍ హఃజో. ");
INSERT INTO vgr_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","తుమె సోఛుకరతిమ్‍ అవ్నే మత్తుమ ఛాకోయిని, అజున్‍బి హంకే నౌవ్ హుయిరూస్‍. ");
INSERT INTO vgr_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","ఆనా గురించి యోవేలు ప్రవక్తతి బోలాయుతే వాతె ఆస్‍; ష్యాత్‍ కతో ");
INSERT INTO vgr_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","అంతంను ధన్మా మే మారు ఆత్మనా అద్మీయే హఃరఫర్‍ నాఖీస్‍, తుమారు ఛియ్యో, తుమారు ఛోరీయే మారు కబర్‍ బోల్సే, తూమారు కవ్వారు లఢ్‍కవ్నా దర్షనాల్‍ ఆవ్సే, తూమారు బుఢాహఃరునా హోఃణె ఆవ్సే. ");
INSERT INTO vgr_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","యో ధన్మా మారు దాసుల్‍నాఫర్‍, మారు దాసిల్‍నాఫర్‍ మారు ఆత్మనా నాఖీస్‍, అనటేకే ఇవ్నే ప్రవచించే. ");
INSERT INTO vgr_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","ఉప్ఫర్‍ ఆకాష్‍మా గొప్ప కార్యల్‍నా, హేట్‍ జమీన్‍ సూచక క్రియల్‍, ల్హొయినా, ఆగ్నా అజు గాణు దువ్వోనా కరిస్. ");
INSERT INTO vgr_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","ప్రభువు ప్రత్యేక్చం హువనూ యో మహీమాను ధన్‍ ఆవాను అగాఢీస్‍ సూర్యుడ్‍ అంధారునితరా, చంధర్‍మా లోహినితర బదల్సే. ");
INSERT INTO vgr_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","తెదె ప్రభువును నామ్‍ను బట్టి ప్రార్థన కరవాళు హాఃరుబి రక్చణ లీస్యేకరీ దేవ్ బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","ఇష్రాయేల్‍నూ అద్మియే ఆ వాతె హాఃమ్జొ, దేవ్‍, నజరేయుడ్‍నో యేసునా ఏర్పరచిలీదోతె సాబుత్‍ కరవనాటేకె తూమ్నా అద్భుతాల్‍నా, మహత్‍కార్యల్నా, సూచకక్రియల్నా తూమార ఇచ్మా కరైయో. ఆ తుమ్నాస్‍ మాలం. ");
INSERT INTO vgr_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","దేవ్నుచిత్తంతీ, బుజు తుమే యేసునా ధరైయిని. ఇనబాద్‍మా తుమే దుర్మార్గుల్‍నా హాతె తుమే సిలువ నఖైన్‍ మరైనాఖ్య. ");
INSERT INTO vgr_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","పన్కి మరణ్‍ ఇనా భందించనూ అసాధ్యం, అనటేకే దేవ్‍ ఇనా మరణ్‍ను ధుఃఖ్‍నా కన్నాఖీన్‍ ఉఠ్టాడ్యొ. ");
INSERT INTO vgr_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","ఇనా గూర్చి దావీద్‍ అమ్‍ బోల్యొ; మే కెదేబి మారో ప్రభువునా మార హాఃమేస్‍ దేక్తొ ర్హయో. యో మారు హాఃమే ఛా. ఇనటేకె మే హాలీస్‍ కొయిని. ");
INSERT INTO vgr_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","ఇనటేకె మారొ దిల్‍ సంతోషించుకరాస్‍, మారు జీబ్‍ ఖుషీ హుంక్రస్‍. బుజు మారు ఆంగ్‍బి నిరీక్చణతి దేక్తు రోఛా. ");
INSERT INTO vgr_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","తూ మారు ఆత్మనా పాతాళంమా మ్హేందీస్‍ కొయిని, తారు పరిసుద్ధుడ్‍నా గొర్రేడమా హాఃఢదీస్‍కొయిని. ");
INSERT INTO vgr_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","మన జీవంనూ మారగ్‍ మాలంకరాయో. తారు దర్షనాల్‍నా దీన్‍ మన ఖుషితీ భరీస్. ");
INSERT INTO vgr_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","భైయ్యే, అప్నో ఖాంధాన్‍నో దావీద్‍నుటేకె మే అమ్‍ కఛ్చితంగా బోలుకరూస్‍, యో మరీజైన్‍ గోర్రెడు హుయిగో; ఇను గొర్రాడు హాంకెతోడి అప్న ఇచ్మాస్‍ ఛా. ");
INSERT INTO vgr_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","యో ప్రవక్తహుయిన్‍ ర్హయో ఇనహాఃజె ఇను ఖాంధాన్‍మా ఫైధాహూయతే ఇవ్నామా ఏక్నా సింహాసన్‍ఫర్‍ బేహాఃఢీస్‍ కరి దేవ్‍ ఇనా వాత్‍ దిదొకరి దావీద్‍నా మాలం. ");
INSERT INTO vgr_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","క్రీస్తు పాతాళంమా మేంధైగయో కోయిని కరి, ఇనూ ఆంగ్తాన్‍‍ సమాధిమా హాఃఢీగయు కోయినికరీ దావీద్‍నా ఆగఢీస్‍ మాలం, ఇనటేకె యో క్రీస్తు జివీన్ ఉట్‍స్యేతే ఇనా గూర్చీ బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","ఇనహాఃజే దేవ్‍ ఆ యేసునా మరణ్‍మతూ ఉఠ్టాడ్యో, ఇనా హామేస్‍ హాఃర సాక్చుల్‍. ");
INSERT INTO vgr_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","ఇనహాఃజే యో దేవ్ను కవ్వాత్‍ని బాజుమా ఛా. పరిషుద్ధాత్మనూ గూర్చిన్‍ వాగ్దానం భాను వల్లా పొందిన్‍, తుమే దేఖ్తాహుయిన్‍ హాఃమ్జుకరతేబి ఇనా జాహఃత్‍ దిదొ. ");
INSERT INTO vgr_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","దావీద్‍ స్వర్గంమా చఢీన్‍ కోగయోని; హూయితోబి యో అమ్‍ బోల్యొ, ");
INSERT INTO vgr_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","మే తారు వైరేవ్‍నా తారు గోఢానూ హేట్‍ పీఠానితర రాఖాతోడీ, తూ మారు ఖవ్వాత్‍ని మాంఢీమణీ బేహ్క్ కరి ప్రభూ మారో ప్రభుతి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","అనహాఃజే ఇష్రాయేల్‍ను గోత్వాలు హాఃరు ఖఛ్చితంగా మాలంకర్లేను, తుమే సిలువ నాఖ్యతె ఆ యేసునస్‍ దేవ్‍ అప్నా ప్రభునితరా, క్రీస్తునితరా నియమించొ. ఆ కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","ఇవ్నే హాఃరు ఆ వాతె హాఃజీన్‍ దిల్‍మా బాధపడీన్‍, పేతురునబి అలాదు అపొస్తుల్‍తి భైయ్యే, “హామే ష్యాత్‍ కర్నూ? కరి పుఛ్చావమా” ");
INSERT INTO vgr_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","తెదె పేతురు అమ్‍ బోల్యొ; తుమె దిల్‍ బద్లాలీన్‍ పాప్‍క్చమా హువనటేకె హర్యేక్‍ యేక్జణు యేసు క్రీస్తునూ నామ్‍తి బాప్తిస్మమ్‍ లెవో; తెదె తుమె పవిత్రాత్మను వరం పొంద్‍స్యు. ");
INSERT INTO vgr_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","దేవ్ను వాగ్దాన్‍ తుమ్నబి తుమార లఢ్‍క్వానాబి, దూర్‍ లేవనబి కతొ ప్రభు హుయోతె దేవ్‍ ఇనకనా బులాయోతె ఇవ్నా హాఃరవ్నా చెంద్సె. ");
INSERT INTO vgr_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","అజుబి కెత్రూకి రకంనూ వాతేతి సాక్చ్యాం దీన్‍, తుమె ముర్ఖుల్‍ హూయిరుతే ఆ ఫీడీనూ ఆద్మీయేతి అలాధు హూయిన్‍ రక్చణ లెవోకరి యూవ్న గుర్ఖాయో. ");
INSERT INTO vgr_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","ఇను వాక్యంనా అంగీకరించ్యుతె యూవ్నే హాఃరు బాప్తిస్మమ్‍ లీదు. యో ధన్నేస్‍ భరోబ్బర్‍ తీన్‍ హాజర్‍ అద్మి దేవ్నా నమ్మిలిదూ. ");
INSERT INTO vgr_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","అవ్నే అపొస్తుల్‍నూ బోధమా, హాఃగ్‍మా, రోటొ తోఢమాబి, ప్రార్థనకరమాబి నావిసక్నుతిమ్‍ ర్హయా. ");
INSERT INTO vgr_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","బుజు కెత్రూకి అధ్బుతాల్‍నా అజు హాఃణత్‍నాబి అపొస్తుల్‍నా హాతె దెఖ్కాడ్యొ. తెదె హార్యేక్‍ జణమా ఢర్‍ కలుగ్యు. ");
INSERT INTO vgr_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","విష్వాస్‍రాక్యుతె హార్యేక్‍జనూ కూడీన్‍ యూవ్నకనా ఛాతే హాఃరు రాఛ ఏక్నా యేక్ దీలేత థా. ");
INSERT INTO vgr_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","ఏత్రేస్‍ కాహేతిమ్‍ యూవ్నూ దవ్లత్‍ యేచీన్‍ గరీబేవ్‍నా కెత్రే కోదువ ఛాకీ పంఛా. ");
INSERT INTO vgr_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","బుజు యూవ్నే హాఃరు యేక్ దిల్‍తి హార్‍ రోజ్‍ దేవలయంమా మళ్తూథూ, ఘర్‍ ఘర్‍మా రోటా తోడ్‍తాహూయిన్‍, ఇవ్ను దిల్నా కామ్‍ కర్లిన్‍. ");
INSERT INTO vgr_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","దేవ్నా స్తూతిస్తాహూయిన్‍, జనాల్‍ హాఃరేతీ దయ పొంద్యుతే యువ్నింతర, బుజు ప్రభు రక్చణ లెంక్రతే యువ్నా విష్వాసుల్‍మా మలౌతార్హయా. ");
INSERT INTO vgr_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","ఏక్ ధన్నే పేతురుబి, యోహాన్‍ ప్రార్దన కరానూ వహఃత్‍ దొప్పారే తీన్‍ భజేనా ప్రార్థన కరానటేకె దేవాలయంనా జౌంగ్రతొ, ");
INSERT INTO vgr_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","ఫైదాహుయు మొదుల్తూ నికీన్‍ లంగ్డుహూయిరూతే ఏక్ అద్మినా థోడు జణు హర్‍ రోజ్‍ ఢోహిలీన్‍ కుప్సురత్‍ కరి దేవాలయ్‍నూ ధర్వాజు కనా బేహాఃఢస్‍, ఎజ్గా యో దేవాలయ్‍మా జవవాళవ్‍కనా భిక్‍ మాంగ్తుథూ. ");
INSERT INTO vgr_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","తెదె ఆ లంగ్డు యో పేతురుబి, యోహాన్‍ దేవాలయంమా జవానూ దేఖీన్‍ భిక్‍ మాంగమా యో వాట్‍ ఖుబ్సూరాత్‍ తూ, ");
INSERT INTO vgr_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","పేతురుబి, యెహాన్‍ ఇనా అసేల్‍తి దేఖీన్‍, పేతురు యో లంగ్డతి, “హామార మణీ ఇమ్మాస్‍ దేఖ్‍” కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","యో ఇవ్నే కంతూ ష్యాత్‍బి మళ్‍స్యే కరి ఇవ్నా మణీ దేఖ్యో. ");
INSERT INTO vgr_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","ఎత్రమా పేతురు రూపు ఘేణు “హామార కనా ఘేణు రూపుకోయిని పన్కి హామార కనా ఛాతేస్‍ తున దేంక్రూస్‍, నజరేయుడ్‍నో క్రీస్తును నామ్తీ ఛాల్‍” కరి గాచ్చిన్‍ బోల్యో, ");
INSERT INTO vgr_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","ఇను ఖావాత్‍ ధరీన్‍ ఉఠ్టాడ్యో. ఎగ్గిస్‍మా ఇను గోఢానూ ఆంగ్లీయే తోడీ తాఖాత్‍ ఆయి. ");
INSERT INTO vgr_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","యో లట్‍కరీన్‍వుటీన్‍ భీరీన్‍ ఛాల్యో. ఛాల్తోహూయిన్‍, కుధ్‍తోహూయిన్‍, దేవ్నా స్తుతిస్తోహూయిన్‍ ఇవ్నేతి దేవాలయంమా గయో. ");
INSERT INTO vgr_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","యో ఛాల్తోహూయిన్‍ దేవ్నా స్తుతింఛనూ ప్రజల్‍ ఖారు దేఖీన్‍, ");
INSERT INTO vgr_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","ఖుప్సురాతె దేవాలయ్‍నూ ధర్వాజుకనా భిక్‍ మాంగ్తుథూతే ఆస్‍ కరి హఃణద్‍ ధరీన్‍, ఇనా జర్‍గ్యుతే హాఃరు దేఖిన్‍‍ ఇవ్నే గబ్రాయిన్‍ హాషం హూయు. ");
INSERT INTO vgr_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","యో పేతురు, యెహాన్‍నా సేడే లగ్గీర్హవనూ అద్మీయే ఖారు హాషంహూయిన్‍, సోలొమోన్‍నూ మండపంమా కనా ఛాతే ఇవ్నా కనా మీలవ్తుహుయిన్‍ ఆయు. ");
INSERT INTO vgr_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","పేతురు యో ఖారు దేఖిన్‍ ప్రజల్‍తి అమ్‍ బోల్యొ ఇష్రాయేల్‍నూ ప్రజల్‍ తుమే ఆనా గూరించి ష్యాన హాషం హూంక్రస్‍? హామారు ఖుద్ను థాకత్‍, భక్తీనాబి ఛలావనా తాఖత్‍ దిదాతిమ్‍ తుమే ష్యాన హామార మణీ ఇమాస్‍ దేకుకరాస్‍? ");
INSERT INTO vgr_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","అబ్రాహామ్ను, ఇస్సాక్‍, యాకోబు కరి ఇవ్నూ దేవ్‍, కతో అప్నో పితరుల్‍నూ దేవ్‍ ఇను సేవ కరవళో యేసునా మహిమ పరిఛిరాక్యోస్‍, పన్కి తుమే ఇనా అధికారుల్నా ధరైయా, పిలాతు ఇనా ఛోడ్నాఖనాఖాజె నిర్ణయించ్యోతేదె తుమే ఇనఖామే ఇనా నోకో కరి బోల్యా. ");
INSERT INTO vgr_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","తుమే పవిత్రుడ్‍, నీతిమంతుడ్‍ హూయోతే ఇనా నోకో మేంద్‍ కరి బోలిన్‍, ఇనబదుల్‍ ఏక్ హంత్‍కుణ్‍నా మేందో కరి తుమే కోర్యా. ");
INSERT INTO vgr_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","తుమే జీవాధిపతినా మర్రాక్య పన్కి, దేవ్‍ ఇనా మరణ్‍మతూ జీవాఢ్యో ఇనా హమేస్‍ సాక్చుల్‍. ");
INSERT INTO vgr_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","హమ్నా యేసును నామ్‍మా విష్వసం ఛా ఇనటేకెస్‍, తుమ్నా మాలంహూయోతే ఆనా దేకుకరాతే ఆనా అసేల్‍ హూయు. యేసును నామ్‍, ఆనా హూయుతే విష్వాసంమస్‍ ఆనా పూర్తి స్వస్థత హూయు. ");
INSERT INTO vgr_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","భైయ్యే తుమేబి తుమారు అధికారుల్‍ ఇనా మాలంకోయింతే కర్యా కరి మన మాలం. ");
INSERT INTO vgr_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","హూయితోబి దేవ్‍ ఇనో క్రీస్తు ష్రమ పఢ్‍స్యే కరి ప్రవక్తల్‍ హాఃరేతి దేవ్‍ బోలాయోతే యో వాతె అమ్‍ నేరవేర్చో. ");
INSERT INTO vgr_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","తుమే తుమారు పాప్‍ ఓపిలిన్‍ దేవ్నా బణే పార్యాతో తుమారు పాప్‍ క్చమించాబడ్సే. ");
INSERT INTO vgr_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","ఇంకర్యతో తుమ్నా ప్రభువు సముఖంమాతు అగాడిస్‍ ఆత్మయను తాఖాత్‍ పోందస్సు. ");
INSERT INTO vgr_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","హాఃరవ్నా తగీన్‍నూ ధన్‍ ఆవ్సెకరీ దేవ్‍ ములక్‍ను భోజొమాతు ఇను పరిసుద్ధ ప్రవక్తల్‍నాహాతె బోల్యొ, తెప్తోడి యేసు స్వర్గంమా ర్హవనూ హాఃఛి. ");
INSERT INTO vgr_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","మోషే అమ్‍ బోలిమోకిల్యో ప్రభువు హూయోతే దేవ్‍ మారున్‍ జోణ్‍నూ ఏక్ ప్రవక్తనా తూమారు భైయ్యేమతూ తూమారటేకె ఫైధాకర్షే; యో తూమారేతి ష్యాత్‍ బోల్యుతోబి తుమే ఇని వాత్‍ హాఃజ్ను. ");
INSERT INTO vgr_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","యో ప్రవక్తనూ వాత్‍ హాఃమ్‍జ్యా కోయింతే ఇవ్నా దేవ్ను ప్రజల్‍మతూ దూర్‍హుయిన్‍ నాషనం హూయిజాస్యే. ");
INSERT INTO vgr_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","బుజు సమువేలుతి ధరీన్‍, కేత్రు జణు ప్రవక్తల్‍ ప్రవచించ్యాకీ ఇవ్నే హాఃర ఆ ధన్‍నా గూర్చీ ప్రఛార్‍ కర్యా. ");
INSERT INTO vgr_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","యో ప్రవక్తల్‍నా, దేవ్‍ అబ్రాహామ్‍తి తారు పేట్నూ లఢ్‍క్వాతి జమీన్‍ ఫర్‍ ఛాతే హాఃరు ఖాంధాన్‍నా ఆషీర్వదించబడ్‍స్యే కరి బోలిన్‍, తూమారు పితరుల్‍తి కర్యాతే వాత్నా తుమే వారసుల్‍ ఛా. ");
INSERT INTO vgr_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","దేవ్‍ ఇనా సేవ కరవళోన ఎంచీలిన్‍, తుమారమా హార్యేక్‍నా ఇను ఖరాబ్‍మతూ ఫరావనాటేకె బుజు తుమ్నా ఆషీర్వదించనాటేకె ఇనా అగాఢీ తుమార కనా బోలీమోక్‍ల్యో కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","పేతురు యోహాను ప్రజల్‍తి వాత్‍ బోల్తుర్హవమా, థోడుజను యాజకుల్‍బి, దేవాలయంనూ మోటోబి, సద్దూకయ్యుల్‍బి, ");
INSERT INTO vgr_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","ఇవ్నే ప్రజల్‍నా బోధించుకరాతేబి, యేసునా బట్టిన్‍, మరీహూయు జీవిన్ ఉట్‍స్యే కరి ప్రచార్‍ కరానూ దేఖిన్‍ ఇవ్నా ఘాణు ఛండాల్‍ ఆయూ. ");
INSERT INTO vgr_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","అనహఃజే ఇవ్నా జబర్‍జస్తీతి ధరీన్‍ బందించిన్‍, హాఃమ్‍జ్‍ హూయిజవమా బెంమ్మనూ ధన్‍తోడీ కావ్లీమా ఠాణమా రాక్యు. ");
INSERT INTO vgr_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","పన్కి ఇవ్ను వాక్యంనా హాఃమ్‍జ్యుతే ఇవ్నే కెత్రూకి జణు దేవ్‍నా విష్వాసించ్యు. ఇవ్నామా ఖాలీ మరధ్‍మానాస్‍ ఫాఛ్‍హజార్‍ అద్మి. ");
INSERT INTO vgr_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","బుజేక్‍ ధన్నే ఇవ్ను అధికారుల్‍బి, మోటోవ్‍బి, షాస్త్రుల్‍బి ఖారు యెరుషలేమ్‍ భరైయు. ");
INSERT INTO vgr_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","ప్రధాన్‍ యాజకుడ్‍ హూయోతే అన్న కయాప, యోహాన్‍బి, అలెగ్జాండర్‍, ప్రధాన్‍ యాజకుణ్‍నూ బంధుల్‍ ఖారూబి, ఏజ్గా థూ. ");
INSERT INTO vgr_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","ఇవ్నే అపొస్తోల్నా హాఃరవ్‍నా ఇఛ్మా భీరకాఢీన్‍ తుమే కింకరుకురాస్‍ కేవు థాకత్‍తి కేవు నామ్తి కరురాస్‍, కెహూ నామ్‍నూ బట్టిన్‍ ఆనా కరుకరాస్‍ కరి పుఛావమా, ");
INSERT INTO vgr_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","పేతురు పవిత్రాత్మతి భరైన్‍ అమ్‍ బోల్యొ, ప్రజల్‍నూ అధికారుల్‍, షాణ, ");
INSERT INTO vgr_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","యో లంగఢానా హుఃద్రాయోతే యో అసేల్‍ కామ్నా గూర్చీబి, హామ్నా పరీక్చించుకరస్‍? ఆ కినేతి అచ్చు హూయోకీ మాలంకర్నూకరీ ఛానా? ");
INSERT INTO vgr_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","తుమే ఖారూబి, ఇష్రాయేల్‍నూ అద్మీయేబి మాలంకర్నుతే ష్యాత్‍ కతో, తుమె సిలువ నాఖ్యతే, మరీహూయమథూ దేవ్‍ ఉఠ్టాడ్యోతె నజరేయుడ్‍నో యేసు క్రీస్తు నామ్‍తిస్‍ ఆ హుఃద్రిన్‍ తూమార హాఃమేస్‍ హీభిర్యోస్‍. ");
INSERT INTO vgr_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","ఘర్‍ బాంధవళా తుమె నకో కరి ఫేఖీదిదాతే ఫత్‍ర్వో ఆస్‍. యో ఫత్‍ర్వో హాంకే కోణోనా ముఢ్‍క్యనా ఫత్‍ర్వో హుయు యో యేసుస్‍. ");
INSERT INTO vgr_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","బుజు కినేతిబి రక్చణ మళ్‍స్యేకోయిని; ఆ నామ్‍తిస్‍ అప్నె రక్చణ లేను పన్కీ ఆకాష్‍నా హేట్‍ అద్మీయేనా దేవాయ్‍ర్యుతే బుజు కేవు నామ్‍తిబి రక్చణ కోమల్సేని. ");
INSERT INTO vgr_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","యూవ్నే హాఃరు పేతురు, యోహాన్‍నూ హిమ్మత్‍ దేఖిన్‍, ఆవ్నే పడ్యాకోయిన్తే మాముల్‍ అద్మీయే కరి అర్ధం కరీన్‍, హాషంహూయిన్‍, అవ్నే యేసునా కేడె ర్హయ్యా హూయాస్‍ కరి హాఃణత్‍ ధర్యా. ");
INSERT INTO vgr_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","హుయుతో ఖూద్రిగయోతే యో లంగఢుబి ఇవ్నా కేడేస్‍ హుబ్రిర్హావమా ఇవ్నా కాయిబి బోలాన కోహుయుని. ");
INSERT INTO vgr_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","తెదె యూవ్నే హాఃరవ్నా సభనా బాధర్‍ జవోకరీ ఆజ్ఞా దీన్‍, ఇవ్నే ఇవ్నేస్‍ అమ్‍ వాత్‍ బోలిలీదు. ");
INSERT INTO vgr_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","ఆ అద్మీయేనా అప్నె ష్యాత్‍ కర్నూ? ఇవ్నా హాతె అధ్బుతంనూ మహీమ హూయిరూస్‍ కరి హాఃరవ్నా మాలం. ఇనా అప్నె కాహెకరి బోలన కోహుస్యేని. ");
INSERT INTO vgr_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","హూయితోబి ఆ అద్మీయేమా నా ఫైలావ్‍నూ తిమ్‍, అజు కెధేబి ఆ నామ్తి కేవు అద్మీయేనాబి వాత్‍ బోలానా దేనూతిమ్‍ ఇవ్నా ఢార్వాను కరి బోల్లిదు. ");
INSERT INTO vgr_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","తెదె ఇవ్నా బులైమంగైన్, తుమే యేసునూ నామ్తి నా బోధించ్‍నూ, ఇనా గూర్చి వాతె నా బోల్‍నూ కరి ఇవ్నా ఆజ్ఞాదిదూ. ");
INSERT INTO vgr_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","ఇనటేకె పేతురుబి యోహాన్‍ ఇవ్నా దేఖీన్‍, దేవ్ను వాత్‍ నా హాఃజీన్‍ తూమారు వాత్‍ హాఃజనూ దే‍వ్ను డోలామా న్యాయమస్‍నా? తూమేస్‍ బోలొ. ");
INSERT INTO vgr_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","హామే హాఃజాతే, ధేఖ్యతే ఇనా గూర్చి బోల్యాకోయిన్తే ర్హవనా కోహూస్యేని కరి ఇవ్నా జబబ్‍ దిదా. ");
INSERT INTO vgr_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","ప్రజల్‍ ఖారు జర్‍గ్యుతే ఇనా దేఖీన్‍, దేవ్నా మహీమ కర్తుర్హయు. అనటేకే సభలో ఛాతే అద్మియే ప్రార్ధన కర్యు, ఇవ్నా కిమ్‍ షిక్చించ్నుకీ మాలంకోహుయుని, ఇనటేకె ఇవ్నా ఖాలీ ఢార్యిన్‍ మ్హేంద్యుదూ. ");
INSERT INTO vgr_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","హుఃద్రావనూ సూచక క్రియ కినూ విషయంమా హూయుకీ యో ఛాళీఖ్‍ః వరఖ్‍ఃతిబీ ఘను వరఖ్‍ఃనో. ");
INSERT INTO vgr_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","యోహన్‍ పేతుర్. కావ్లీమతూ ఛుటీన్‍ ఇవ్నా అద్మీయే కనా ఆయిన్, ప్రధాన యాజకుల్‍బి, మోటా ఇవ్నేతి బోల్యాతే వాతె ఖారు ఇవ్నా మాలంకరాయు. ");
INSERT INTO vgr_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","ఇవ్నే హాఃజిన్, ఏక్ దిల్తి దేవ్నా అమ్‍ ప్రార్దన కర్యు మహా ప్రభువు తూ ఆకాష్‍నా, జమీన్‍నా ధర్యావ్‍నా ఇనుమనూ హాఃరవ్నా కర్యోతేబి తూస్‍. ");
INSERT INTO vgr_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","తూ పవిత్రాత్మతి హామారొ భా హూయోతే తారో సేవకుడ్‍ హూయోతే దావీద్‍నా హాతె బోల్యొ. యూదుల్‍ ఖాయేతే ఇవ్నే సాన చీకురూకురాస్‍? ప్రజల్‍ ష్యాన కామే ఆవకోయిన్తే హూఃజ్‍ కరూకరాస్‍? ");
INSERT INTO vgr_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","ప్రభునాఫర్‍, క్రీస్తునాఫర్‍, ఆమేహాఃమే ధర్తిను రాజుల్‍ ఉట్యూ, అధికారుల్‍ ఖారు ఏక్ హూయిన్‍ కూడిగయూ. ");
INSERT INTO vgr_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","హేరోద్‍బి పొంతి పిలాతు అన్యుల్‍తి ఇష్రాయేల్‍ ప్రజల్‍తి ఆ హాఃయార్‍మా హాఃచిస్‍ మా జామహుయు. తూ అభిషెంచ్యోతె తారు పరిసుద్ధ సేవకుడ్‍ యేసుతి దావోతి ");
INSERT INTO vgr_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","కేవు జరగ్‍నూ కరి తారు హాత్‍బి తారు సంకల్పం అగడీ నిర్ణయించ్యాకీ. యో ఖారు కరనటేకె ఇవ్నే జామహుయు. ");
INSERT INTO vgr_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","ప్రభు ఆ వోహఃత్‍మా ఇవ్ను ధమ్‍కావ్నీ దేఖీన్‍, తారు దాసుల్‍ ఘను హీమ్మత్‍తి తారు వాక్యం బోధించనా తాఖాత్‍ ధా. ");
INSERT INTO vgr_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","రోగ్‍వాళాన అసేల్‍ కరానబి, తారు పరిసుద్ధ సేవకుడ్‍ హూయోతే యేసునూ నామ్‍తి సూచకక్రియాల్‍బి, గోప్పకార్యాల్‍ కరానబి తారు హాత్‍ లంబో కరిరాక్యోస్‍, ");
INSERT INTO vgr_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","తెదె ఇవ్నే ప్రార్థన కరుస్‍కరా ఇవ్నే భేఠాతే జోగో హాలీన్‍ రైగు తెదె ఇవ్నే ఖారు పవిత్రాత్మతి భరావమా, దేవ్ను వాక్యం ఘణు హీమ్మత్‍తి బోధించ్యా. ");
INSERT INTO vgr_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","విష్వాసించుతే ఖారు జణు ఏక్కాస్‍ దీల్తి, ఏక్ ఆత్మతి ర్హయా. కోన్బి ఇవ్నా కనా ఛాతే కేవుబి మారు కరి కోసోఛానీతీమ్‍ హాఃరు జణు మలీన్‍ పంచిలేతా థా. ");
INSERT INTO vgr_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","ఏత్రేస్‍ కాహేతిమ్‍ అపొస్తుల్‍ థాకత్‍ ప్రభు హూయోతే యేసు జీవిన్‍ ఉఠ్యెతే బారేమా సాక్చ్యం బోలానికిల్యా. ఇవ్నా హాఃరవ్‍ఫర్‍ దేవ్ను ఆషీర్వాద్‍ ఘణుస్‍ ఆయూ. ");
INSERT INTO vgr_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","ఇనటేకె ఇవ్నమా కినాబి కాయిబి కమ్‍ర్హయు కోయిని. జమీన్‍వో, ఘర్‍వో ర్హవ్వాలుహో హాఃరు ఏచీన్‍, ");
INSERT INTO vgr_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","యో రఫ్యా లాయిన్‍ అపొస్తుల్నా ఇవ్నే హారేక్నా ఇవ్ను ఇవ్నూ అవసరమ్‍ రవ్వాయెత్రు బాగ్‍ పాడీ దేతూర్హయూ. ");
INSERT INTO vgr_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","కుప్రమా పైధాహూయోతె లేవియుణ్నూ యోసేపు కరి ఏక్ థో. అపొస్తుల్‍ ఇనా బర్నబా కతో కరవ్వాను నామ్ను అర్ధమ్‍. ");
INSERT INTO vgr_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","యో జమీన్‍వాళొ హూయిరైన్‍ ఇనా ఏచిన్‍ ఇను రఫ్యాలాయిన్‍ అపొస్తుల్‍నూ దిదొ. ");
INSERT INTO vgr_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","అజు అననీయ కరి ఏక్ అద్మి ఇని భావణ్‍ సప్పీరాతి మలీన్‍ ఇవ్నా ఖేథర్‍ ఏచ్యా. ");
INSERT INTO vgr_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","భావణ్‍నా మాలం ర్హాయిన్‍ ఇనమాతు థోడు లఫాడ్‍లీన్‍ థోడు లాయిన్‍ అపొస్తుల్‍నా దిదో. ");
INSERT INTO vgr_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","తెదె పేతురు అననీయాతి, తారు జమీన్‍ రఫ్యావ్‍మా థోడు లఫాడి ‍లీన్‍ పరిషుద్ధాత్మనా జుట్టికరనా సైతాన్‍ ష్యాన తారు దిల్‍నా వుషీ కర్యో? ");
INSERT INTO vgr_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","యో తార కనా రైతో తెదే తారుస్‍తో? ఏఛానా బాద్మాబి యో తారు సొంతం కోహుసిన్నా? స్యాన ఆ సంగతి తారు దిల్మా సోచుకరాస్‍? తూ అద్మీతి కాహే దేవ్తి జుట్టి బోల్‍రాక్యోస్‍ కరి ఇనేతి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","అననీయ యో వాతె హఃమస్తోహుయినస్‍ పడీన్‍ జాన్‍ మ్హేందో, హఃజూతే హఃరవ్నా ఘణు ఢర్‍ హుయుగు. ");
INSERT INTO vgr_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","తెదె కవ్వార ఛోగరా వూట్టీన్‍ ఇనా లుంగ్ఢాతి లఫ్టీన్‍ ఢొయిలీజైన్‍ గాఢ్యా. ");
INSERT INTO vgr_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","భరోబర్‍ తీన్‍ గంఠనాబాద్మ ఇని భావణ్‍ హుయుతే మాలంకోయినింతే మహి ఆయీ. ");
INSERT INTO vgr_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","తెదె పేతురు తుమే యో జమీన్‍నా అత్రనస్‍ ఏఛానా మారేతి బోల్కరి ఇనా పుచ్ఛాయో. ఇనహాఃజే యో హో అత్రనాస్‍ ఏచ్యాకరి బోలి. ");
INSERT INTO vgr_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","తెదె పేతురు యోబాయికోతి ప్రభునూ ఆత్మనా సోధించనా తూ తార బావ్రి ష్యాన పూనిల్దా? హాధేక్‍ తార భావ్రీనా గాఢీన్‍ ఆయుతే ఇవ్నె ఘర్‍నా భారస్‍ ఛా; యూవ్నే తునాబి ఢోయిలీజాసె కరి ఇనేతి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","జల్దీస్‍ యోబాయికొ ఇనా గోఢకనా పఢీన్‍ జాన్‍ మ్హేంధి. యో కవార ఛోగరా మహీ ఆయిన్‍, యో మేరిగయేతె ఇనా దేఖిన్‍, ఇన ఢోయిలీజైన్‍ ఇని భావ్రీకనాస్‍ గాఢ్య. ");
INSERT INTO vgr_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","సంఘ హాఃరవ్‍నా, ఆ సంగతి హఃజూతే హఃరవ్‍నాబి ఘణు ఢరిగయు. ");
INSERT INTO vgr_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","జనాల్మా కెత్రూకి సూచక క్రియల్‍, మాహాత్‍కార్యల్‍ అపొస్తుల్‍నా హాతె హోతుర్హయు. బుజు ఇవ్నే హాఃరు ఏక్ మలీన్‍ సొలొమోన్‍నూ మండపంమా థూ. ");
INSERT INTO vgr_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","అజు హాఃరుబి ఇవ్నేతి మలిర్హవానా ఇవ్నా హిమ్మత్‍ కోపూర్యుని పన్కి, అద్మియే ఇవ్నా ఘనపరుచుచూ రయ్యూ. ");
INSERT INTO vgr_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","హుయుతో కెత్రుకి బాయికా వాగ్రియే ప్రభువును నమ్మిన్‍ కెత్రుకి జాణు ఇవ్నామా చేర్యు, ");
INSERT INTO vgr_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","అనటేకే పేతురు అవ్వామా అద్మియే ఆష్యల్ కొయిన్తే ఇవ్నా ఇను ఛాళో ఫణ్‍నూ కరి మంచల్‍ ఫర్‍ పరుపుల్‍నాఫర్‍ ఇవ్నా రాఖ్య. ");
INSERT INTO vgr_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","బుజు యెరూషలేమ్‍నా ఆష్పిస్‍నూ హాఃయార్నూ జనాల్‍ రోగేలనా అపవిత్రాత్మథీ హాఃతూకరాతే ఇవ్నా ఢోయిలీన్‍ మలిన్‍ ఆయు. ఇవ్నే హాఃరబి ఆష్యల్‍ హుయి. ");
INSERT INTO vgr_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","ప్రధానయాజకుడ్‍బి ఇనాకేడె ర్హవాళు హాఃరుబి, కతో సద్దూకయ్యుల్‍నూ జాత్‍ వాళు వుటీన్‍ దావోథీ భరైన్‍, సాత్బి కర్నుకరి థా. ");
INSERT INTO vgr_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","అపొస్తల్‍నా జభర్‍జస్తిథీ ధర్లీన్‍ ఠాణమా రాఖ్య. ");
INSERT INTO vgr_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","హుయుతోబి ప్రభునూ దూత రాత్నూ వహాఃత్‍ యో ఠాణాను ధర్వాజకాఢిన్‍ ఇవ్నా భా ఆయిన్‍ ఇవ్నేతి అమ్ బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","తుమే జైన్‍ దేవాలయ్‍మా భీరిన్‍, ఆ జీవంనూ గూర్చిన్‍నూ వాతె హాఃరుబి ప్రజల్‍తీ బోలో కరి ఇవ్నేతి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","ఇవ్నే యో వాతె హాఃజీన్‍, వ్వాణు హూస్‍కరా దేవాలయ్‍మా జైన్‍ బోధిస్తార్హయా. తెదె ప్రధాన యాజకుడ్‍బి ఇనాకేడె ర్హవాళుబి ఆయిన్‍, మహాసభ వాళన యూదుల్‍ ష్యాణవ్‍నా బులైమంగయుతే ఇవ్నా అపొస్తుల్నా బులైలీఆవ్‍ కరి భటుల్‍నా ఠాణమా బోలిమొక్‍ల్యా. ");
INSERT INTO vgr_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","పన్కీ భటుల్‍ ఎజ్గా గయా తెదె ఇవ్నే నాదేఖవమా ఫాచు ఆయిన్‍, అమ్‍ బోల్యు ");
INSERT INTO vgr_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“ఠాణా ఘణు అసేల్తీ మూచైర్హవానుబి, కావ్లీ కరవాళు ధర్వాజనా హాఃమే భిరిర్హవాను దేక్యా పన్కీ ధర్వాజు కాఢ్యాతేదె మహీ హామ్నా ఏక్ జణోబి దేఖాయో కోయిని.” ");
INSERT INTO vgr_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","ఇనబాద్మా దేవాలయ్‍నూ అధిపతిబి ప్రధాన యాజకుల్‍బి యో వాతె హాఃజీన్‍ ఆ ష్యాత్‍ హూవాస్‍కి కరి ఇవ్నా విషయ్‍మా కాయి సోఛవాకోయిన్తె రైయు. ");
INSERT INTO vgr_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","తెదె ఏక్ జణో ఆయిన్‍ హాధేక్‍ తుమే బందించుతే ఇవ్నే దేవాలయంమా భిరిన్‍ ప్రజల్‍నా బోధించుకరాస్‍ కరి యూవ్నా బోలమా, ");
INSERT INTO vgr_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","అనటేకే అధిపతి భటుల్‍థి కేడె జైన్‍, ప్రజల్‍ ఫత్రావ్తి మారస్‍షికి కరి ఢరీన్‍, జభర్‍జస్తీ నాకర్నూతిమ్‍ ఇవ్నా అపొస్తుల్నా ఆయిత్రా. ");
INSERT INTO vgr_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","ఇవ్నా లీఆయిన్‍ సభమా భిర్హకాఢమా ప్రధానయాజకుడ్‍ ఇవ్నా దేఖిన్‍ అమ్నితరా పుచ్చావమా, ");
INSERT INTO vgr_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","తుమే ఆ నామ్తి బోధించో నొకో కరి ఖచ్చితంగా ఆజ్ఞ దిదా కోయిన్నా? హాదేక్‍ తుమే యెరూషలేమ్‍నా తూమారు బోధిం భరీన్‍, ఆ అద్మీను మరణ్‍ హామారఫర్‍ లావ్నూ కరి సోచుకరాస్‍ కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","ఇనహాఃజే పేతురుబి బుజు బగల్‍ అపొస్తుల్‍ అద్మినా కాహే పన్కి దేవ్నా తప్ప అజు అద్మియేన లోబడ్సు కొయిని. ");
INSERT INTO vgr_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","తుమే మ్రాన్‍ఫర్‍ ఛడైన్‍ మార్రాక్యతే యేసునా అప్ను పితరుల్‍నో దేవ్‍ జీవ్వాడీన్‍ ఉఠ్టాడ్యో. ");
INSERT INTO vgr_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","ఇష్రాయేల్‍నా దిల్‍ బదలనుబి పాప్‍క్చమాపణ్‍ దేవానటేకె దేవ్‍ ఇనా ఉట్టాడీన్‍ అధిపతింతర రక్చకుడింతర ఇను ఖవ్వాత్‍బనే రాక్యోస్‍. ");
INSERT INTO vgr_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","హామేబి, దేవ్‍ ఇనా విధేయుడ్ ‍హుయిన్‍ ర్హైతె యూవ్నా దీదూతే పరిసుద్ధాత్మబి, ఆ సంగతుల్‍నా సాక్చుల్‍నితరా ఛియ్యే. ");
INSERT INTO vgr_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","మహాసభమా ఛాతే ఇవ్నే ఆ వాతె హాఃజీన్‍ ఘణు ఛంఢాల్‍ లాయిలీన్‍ ఆవ్నా మర్రాక్నూ కరి సోచమా, ");
INSERT INTO vgr_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","ఖారుఅద్మిథి ఘనత పోంద్యుహుయుబి ధర్మషాస్త్రం బోలావళు గమలీయేలకరి ఏక్ పరిసయ్యుడ్‍ మహాసభమా వుటీన్‍, ఆ అద్మీయేనా జర ఘడీ భార్‍ రాఖోకరీ ఆజ్ఞాదీన్‍ ఇవ్నేతి అమ్‍ బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","ఇష్రాయేలియుల్‍వాల, ఆ అద్మీయేనూ విషయంమా తుమే ష్యాత్ కరాజౌంగ్రస్‍కీ ఝథన్ హుయి‍ర్హవో. ");
INSERT INTO vgr_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","ఆ ధన్నా ఆగడీ థూదా వుటీన్‍ యో ఏక్ మోటో కరి బోల్లీదో; భరోభర్‍ ఛార్‍హోః అద్మీయే ఇనేతి మళీజైన్‍, యో మరైగయో. ఇనా లోబడ్యుతే ఇవ్నే హాఃరు చేద్రిజైన్‍ లఢాయ్‍ వ్యర్థం హుయిగు. ");
INSERT INTO vgr_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","ఇనబాద్మా జనాభలెక్కమా ధన్మా గలిలయడ్‍నో యూదాబి తిరుగుబాట్‍ కరనా వూషి కర్యో; యోబి నాషనం హుయిగో, ఇనా లోబడ్యుతే ఇవ్నే హాఃరు చేద్రిగయు. ");
INSERT INTO vgr_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","ఇనహాఃజే మే తూమారేతి ష్యాత్‍ బోలుకరూస్‍ కతో ఆ అద్మీనూ జోలినా నాజైన్‍ ఇవ్నా మ్హేందేవో. ఆ హూఃజ్‍బి హూవో ఆ కామ్బి హూవో ఆద్మీయేథి హూయుతో యో వ్యర్దం హుయిజాసే. ");
INSERT INTO vgr_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","హుయూతొ దేవ్తి బరేమా హుయూతొ ఇనాస్ కర్సుకోయిని; తుమే ఏక్ వోహాఃత్‍ దేవ్తి పోరడా వళా హుయిజాస్‍సీకి జథన్‍. ");
INSERT INTO vgr_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","ఇవ్నా ఇనా వాత్‍నా ఒప్పిన్‍, అపొస్తుల్‍నా బులైమంగైన్‍ కోల్డోతి మార్‍ ఖడైన్‍ యేసునూ నామ్‍థి బోధించో నోకో ఆజ్ఞాదిన్‍ ఇవ్నా మ్హేందిదా. ");
INSERT INTO vgr_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","యో నామ్నా టేకె అవమాన్‍ హూవానా పాత్రుల్‍ కరి ఎంచబడ్యుతే ఇనా హాఃజే ఇవ్నే సంతోషించిన్‍ మహాసభమ థూ ఛల్‍జైన్‍, ");
INSERT INTO vgr_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","హార్‍ ధన్‍ దేవాలయ్‍మాబి ఘర్‍ ఘర్‍మా నాతప్నూతిమ్‍, యేసుస్‍ క్రీస్తు కరి సువార్తనా ప్రచార్‍ కర్తర్హయా. ");
INSERT INTO vgr_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","యో ధన్నువ్‍మా‍ సిష్యుల్‍నూ గల్లో భడ్తుజోంగ్రతేదె హార్‍ రోజ్‍ పరిచర్యమా యూవ్నామనూ రఫా బగ్పడి దేవానిజోగొ పక్చపాతం దేఖడుకరి హేబ్రిల్‍నా ఫర్‍ గ్రీక్‍ భాష బోలావాళు భణ్‍ఖనూ సురుకర్యా. ");
INSERT INTO vgr_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","తెదె భార జణా అపోస్తుల్‍ యువ్నా కనా సిష్యుల్‍ అఖ్కావ్‍నా బులైన్‍ హామే దేవ్‍నూ వాక్యంనా బోలను మ్హేంధిన్‍, రఫ్యా, ఖాణుస్‍ బగ్పడి దేవాను అసేల్‍ కాహే. ");
INSERT INTO vgr_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","ఇనహాఃజే భైయ్యేవో, ఆత్మతీ అఖ్కాల్‍తి భరైరరిన్‍ అచ్చునామ్‍ కమైరాక్యు హూయునా హాఃత్‍ జణా అద్మీయేనా తూమారమణ్‍తూ ఏర్పరచో. హామే యూవ్నా ఆ కామ్‍నా ఎన్నుకొనుడి; ");
INSERT INTO vgr_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","తెదె హామే హమారు వఖాహత్‍మాబి ప్రార్థనమా వాక్యంనూ బోధించడంలోను ర్హస్యు కరి బోల్యా. ");
INSERT INTO vgr_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","ఆ వాత్‍ హాఃరవ్‍నా నచ్చ్యు, ఇనహాఃజే యూవ్నే విష్వాసంమాబి, పవిత్రాత్మతి భరైరోతే స్తెఫన్‍, బుజు ఫీలిప్పు, ప్రోకోరు, నీకానోరు, తీమోన్‍, పర్మేనాసు, యూదా మతంమా భద్లీగయోతే అంతియొకయమా ర్హవ్వాళో నీకోలాసు కరి యూవ్నా ఏంచీలీదా. ");
INSERT INTO vgr_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","యూవ్నా అపొస్తుల్‍నా హఃమే రాఖ్యా. అపోస్తుల్‍ ప్రార్ధనా కరీన్‍ యూవ్నాఫర్‍ హాత్‍ మ్హేంద్యా. ");
INSERT INTO vgr_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","దేవ్నూ వాక్యం ఏత్రేనా ఏత్రే ఫైలాయిన్‍, యెరూషలేమా సిష్యుల్‍నూ సంఖ్య భఢీగయు. యాజకుల్‍మాబి ఘణా అద్మీయే విష్వాసించ్యు. ");
INSERT INTO vgr_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","స్తెఫన్‍ దేవ్నూ కృపతి, థాకత్‍తి భరైన్‍ ప్రజల్‍నా ఇఛ్మా అధ్బుతాల్‍బి, ఆర్చ్యక్రాయల్‍ కరూకరాస్‍. ");
INSERT INTO vgr_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","లీబెర్తీను కరి బోలాతె గల్లోమాహో, కురేనీయుల్‍నూ గల్లోమాహో, అలెగ్జాండ్రియను గల్లోమాహొ, కిలికియమథూ, ఆసియామథూ ఆయుతే ఇవ్నామతూ, థోడుజణు ఆయిన్‍ స్తెఫన్‍థి వాదించ్యా పన్కీ, ");
INSERT INTO vgr_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","హుయుతో ఇనా అఖ్కల్‍నూ వాతేనా, ఇనేతి బోలాయుతే ఆత్మనా యూవ్నే వాదించనా కోహుయిని. ");
INSERT INTO vgr_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","తెదె యూవ్నే, యో మోషేఫర్‍బి, దేవ్‍ఫర్‍బి దూషణ్‍నూ వాతె బొలానూ హామే హఃమ్జాకరీ బోలావనా హాఃజే థోఢా అద్మీయేనా ఇంబోలనా పైసాలిదు, ");
INSERT INTO vgr_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","ప్రజల్నా‌ ష్యాణవ్‍నా షాస్త్రుల్‍నా వూషికరైన్‍ ఇనాఫర్‍ ఆయిన్‍, ఇనా ధర్లీన్‍ మహాసభనా హఃమే లీన్‍ ఆయా. ");
INSERT INTO vgr_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","తెదె ఇవ్నే ఆ అద్మి కెధేబి అప్ను పవిత్ర గుడి, ధర్మసాస్త్రంనా విరోధంగస్‍ వాత్‍ బోల్తోర్హస్‍. ");
INSERT INTO vgr_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","ఆ నజరేయుడ్‍నో యేసు ఆ గుడికరీన్‍, మోషే అప్నా దిదోతే ఆచారాల్‍నా భద్‍లాయినాక్‍స్యే కరి ఆ బోలమా హామే హఃజా కరి బోల్యా. ");
INSERT INTO vgr_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","సభమా భేఠూతే యూవ్నే హాఃరా ఇనా భణీ ఠర్కీన్‍ దేఖమా, ఇను మ్హోఢు దేవదూత్‍నూ మ్హోఢాంతర దేఖాయు. ");
INSERT INTO vgr_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","ప్రధాన యాజకుడ్‍ ఆ వాతె హఃచిస్నా? కరి కేఫను పుఛాయో. ");
INSERT INTO vgr_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","ఇనఖాజే స్తెఫన్‍ బోల్యోతే ష్యాత్‍ కతో భైయ్యే, భా హాఃజో. అప్నో పితరుడ్‍హూయోతే అబ్రాహామ్ను హారాన్‍మా కాపరం ర్హవానా అగడీ మెసొపొతమియమా ర్హయా తెదె మహిమనో దేవ్‍ ఇనా దేఖైన్‍, ");
INSERT INTO vgr_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","తూ తారు దేహ్‍ఃనా తారు ఘేర్‍వాల్నా మేందిన్‍ ఏజ్గాతూ నికీన్‍, మే తునా దేఖాడజైస్‍తే దేహ్‍ఃనా జాకరీ ఇనేతి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","తెదె యో ఇను దేహ్‍ఃనా మేందిన్‍ జైన్‍ హారాన్‍మా కాపరం ర్హయో. ఇనో భా మర్మఆయిజావాన బాద్‍మా, ఏజ్గాతు తుమే హాంకే కాపరంఛాతే ఆ దేహ్‍ఃమా జీవాన టేకె దేవ్‍ ఇనా బులైలీ ఆయో. ");
INSERT INTO vgr_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","దేవ్ ఇనమతూ ఇనా గోఢో మంద ఏత్రే జమీన్‍నాబి స్వాస్థంగా నా దీన్‍, ఇనా ఛియ్యో కోయినితేదె ఇనాబి ఇనబాద్‍నూ ఇను సంతాన్‍నాబి అనా స్వాధీన్‍ కరీస్‍ కరి ఇనా వాగ్దన్‍ కర్యో. ");
INSERT INTO vgr_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","హుయుతో దేవ్‍ ఇనూ సంతాన్‍ పరాయి దేహ్‍ఃమా పరవాసుల్‍ హూసే కరి, యో దేహ్‍ఃవాళు ఛార్‍ఖోః వరహ్‍ఃతోడి యూవ్నా దాస్యంనా లోపరచీలీన్‍ హింసకర్‍సే కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","బుజు దేవ్‍ జనంనా యూవ్నే దాసుల్‍ హుయిర్హస్‍కీ యో జనంనా మే న్యాయం కరీస్‍ కరి, ఇనబాద్‍మా యూవ్నే ఆయిన్‍ ఆ జోగోమా మన ఆరాదనాకర్స్యు కరి బోల్యు. ");
INSERT INTO vgr_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","తెదె దేవ్ అబ్రాహానా నిబంధన గుర్తు సున్నతి హుయుతె ఆచార్‍ను ఇనా దిదో. యో ఇస్సాక్‍నా జణీన్‍ యో ఆట్‍మనూ ధన్నే ఇనా సున్నతి కర్యు, ఇస్సాక్ యాకోబునా జాన్యో యాకోబును ద్వారా బారగోత్రాల్నామోట్వనా ఇనా చియ్యవ్నా ఇవ్నాసున్నతి కారాయో. ");
INSERT INTO vgr_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","యాకోబ్‍ ఛీయ్యా ఇను భైయే హుయుతే యోసేపు పార్‍ మత్సర్‍ పడీన్‍ ఇనా ఐగుప్తుమా బనిసతార యెచినాఖ్యా గానీ, దేవ్‍ఇనా కేడై ర్హైన్‍. ");
INSERT INTO vgr_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","ఇను ష్రమల్‍ అక్కమా ఛుఖైన్, దయనా అఖ్కాల్‍నా ఐగుప్తు రాజోనా హాఃమే ఇబనా దేవామా ఐగుప్తునాబి ఇను ఘర్‍హాఃరనాఫర్‍ ఇనా అధిపతింతర మ్హెంద్యు. ");
INSERT INTO vgr_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","ఇనబాద్‍మా ఐగుప్తు దేహ్ః అక్కునాబి‍ కనాను దేహ్‍ఃనాబి ఖళ్‍బి ఘణు‍ ష్రమబి ఆయు ఇనటేకె అప్నా పితరుల్‍నా ఖాణు కోయినితిమ్‍ హుయిగు. ");
INSERT INTO vgr_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","ఐగుప్తుమా ధాన్యమ్‍ ఛాకరీ యాకోబ్‍ హాఃమ్జీన్‍, అప్నూ పితరుల్‍ ఎజ్గా ఫైలు బార్‍ బోలిమొక్‍ల్యు. ");
INSERT INTO vgr_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","యూవ్నే బెంమ్మనూ వోహాఃత్‍ ఆయుతేదె యోసేపు ఇను భైయ్యే వ్‍నా యో మాలంకరైలిదో; తెదె యోసేపును పరివార్కరి రాజోనా మాలంహూయు. ");
INSERT INTO vgr_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","యోసేపు ఇను భా హూయోతే యాకోబ్‍ ఇను సోంత జనాల్‍నా బులావనా మొక్‍ల్యో; యూవ్నే ఫాచుఫర్‍ హాఃడ్‍తీనీహ్‍ః జణా థా. ");
INSERT INTO vgr_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","యాకోబ్‍ ఐగుప్తునా గయో; ఎజ్గా యోబి అప్నూ కుమారులుబి మరీజైన్‍ ఏజ్గాథూ షెకెమునా బులామంగైన్‍; ");
INSERT INTO vgr_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","షెకెముమకరి హమోరు ఛీయ్యాకనా అబ్రాహామ్ను ఫైసా దీన్‍ మోల్‍ లీన్‍ సమాధిమా ఘలాయో. ");
INSERT INTO vgr_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","కాని దేవ్‍ అబ్రాహామ్‍నా దిదోతే వాగ్దన్‍నూ ధన్‍ ఖందే ఆవాతిమ్‍ ప్రజల్‍ ఐగుప్తుమా కెత్రుకీ భడిగయు. ");
INSERT INTO vgr_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","ఆఖ్రీనా యోసేపు మాలంకొయింతే ఉజేక్‍ రాజో ఐగుప్తునా ఏలానూ సురు కర్యో. ");
INSERT INTO vgr_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","యో అప్నూ ఖాందాన్‍నూ పట్ల కపటింతర చాల్యో, యూవ్నూ లడ్క నాజీవ్నూతిమ్‍ యూవ్నా భార్‍ ఫేఖీనాక్నూ కరి అప్నూ పితరుల్‍నా బాధ కర్యు. ");
INSERT INTO vgr_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","యో ధన్నువ్‍మా మోషే ఫైధాహూయో. యో కెత్రూకి రంగేలో హూయిరైన్‍ ఇను భానూ ఘర్‍ కనా తీన్‍ మైనా వ్వోధో. ");
INSERT INTO vgr_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","ఇనబాద్‍మా యో భార్‍ ఫేఖైగో తెదె రాజోని ఛోరీ ఇనా ఫళ్ళీన్‍ ఇనూఛీయ్యోంతర పాళీల్దు. ");
INSERT INTO vgr_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","మోషే ఐగుప్తునూ హాఃరు ఫఢాయినా షీకీన్‍, వాతేమాహో, కామేవ్‍మాహో ప్రవీణ్‍ హుయిన్‍ ర్హయో. ");
INSERT INTO vgr_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","ఇనా ఛాళీహ్‍ః వరహ్‍ః భరాయా తెదె ఇష్రాయేల్నా ఇన భైయ్యేవ్‍నా దేక్నూ కరి ఖాయలెఆవు. ");
INSERT INTO vgr_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","తెదె యూవ్నామా ఎక్‍ జణో అన్యాయంహూయిజౌంకరాతే ఇనా దేఖీన్‍, ఇనా భచైన్‍ బాధపడుకరతే యూవ్నా మణీ ఐగుప్తు వాళనా మార్రాకీన్‍ ప్రతీకార్‍ కర్యో. ");
INSERT INTO vgr_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","ఇనేతి ఇనా భైయ్యేవానా దేవ్‍ రక్చణ దేంక్రస్‍తే సంగతి యూవ్నే మాలంకర్సె కరి యో సోచ్వో గానీ యూవ్నే అర్ధంకర్యు కోయిని. ");
INSERT INTO vgr_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","బుజేక్‍ ధన్నే బేఝణా లఢాయ్‍ కర్‍లేంకరాతో యో యూవ్నా దేఖీన్‍ హాఃయాప్‍, తుమె భైయ్యే; తుమె ష్యాన ఏక్నాఏక్‍ అన్యాయం కర్‍లేంకరాస్‍ కరి బోలిన్‍ యూవ్నా సమాదాన్‍ కర్నూ కరి దేఖ్యో. ");
INSERT INTO vgr_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","హూయుతోబి ఇను ఫరాయినా అన్యాయం కర్యోతే యో హామారఫర్‍ అధికారుల్‍ తర న్యావ్‍ కరంతర తూనా మ్హేంద్యూతే యో కోన్‍? కరి పుచ్ఛయో ");
INSERT INTO vgr_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","తూ కాల్‍ ఐగుప్తుయుడ్‍నా మార్యోతిమ్‍ మనాబి మార్నూకరీ ఛానా. ");
INSERT INTO vgr_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","మోషే యో వాత్‍ హాఃమ్జీన్‍ మీలైలిన్‍ మిద్యాను దేహ్‍ఃమా పరదేషిహుయిరైన్‍, ఎజ్గా బే ఛీయ్యానా జణ్యో. ");
INSERT INTO vgr_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","ఛాళీహ్‍ః వరహ్‍ఃనా బాద్‍మా సీనాయిపర్వత్‍నా సేడె ఛాతే ఝాడీమా ఏక్ డాగ్‍మాను ఆగ్‍మా ఏక్ ప్రభు దూత ఇనా దేఖాయు. ");
INSERT INTO vgr_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","మోషే దేఖీన్‍ యో హాషం హూయిజైన్‍ ఇనా హాళేతి దేఖాన టేకె ఖందే ఆవమా ");
INSERT INTO vgr_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","మే తారు పితరుల్‍నూ దేవ్‍, అబ్రాహామ్ను ఇస్సాక్‍ యాకోబ్‍నో దేవ్‍ కరి ప్రభునూ గళు హఃమ్జాయు ఇనటేకె మోషే కాఫీన్‍, ఢారిన్‍ దేఖాన దైర్యంకర్యో కోయిని. ");
INSERT INTO vgr_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","ఇనటేకే ప్రభు తారు చేప్పల్‍ కాఢ్‍; తూ హీభ్రోతే జోగొ పవిత్ర జమీన్‍. ");
INSERT INTO vgr_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","ఐగుప్తుమ ఛాతే మారు ప్రజల్‍నను దుఃఖమును రోవును మే ధేఖీరాక్యోస్‍; యూవ్న రోవ్ను హాఃమ్జీరాక్యోస్‍, యూవ్నా చోఢవనాటేకె ఉత్రి ఆయిరోస్‍, ఆవ్‍ మే హాంకే తునా ఐగుప్తునా బోలిమొక్లుస్‍ కరి ఇనేతి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","అధికారుల్‍ తర న్యావ్‍బోలావళోంతర తూనా మ్హేంద్యూతే కోన్‍ కరి యూవ్నే నిరాకరించ్యూతే ఆ మోషేనా ఇనా డాగ్‍మా దేఖైన్‍ ప్రభూ దూతతి దేవ్‍ అధికారింతర చుఖాడో వాలోనితర నియమించిన్‍ మోక్‍ల్యో. ");
INSERT INTO vgr_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","యో ఐగుప్తుమాహో లాల్‍ ధర్యావ్‍మాహో చాలిహ్ః వరహ్ః జంగాళ్‍మాహో మహాత్‍ కార్యల్‍ సూచక క్రియల్‍నా కరీన్‍ యూవ్నా కేడె లీన్‍ చలాయొ. ");
INSERT INTO vgr_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","మారీన్‍ జోణ్‍నో ఏక్ ప్రవక్త దేవ్‍ తూమార భైయ్యేవ్‍మా తూమ్‍నా ఫైధా కర్షే కరి ఇష్రాయేల్‍థీ బోల్యోతే మోషే ఆస్‍. ");
INSERT INTO vgr_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","సీనాయి పర్వత్‍ ఫర్‍ ఇనేతి వాతేబోల్యోతే దెవా దూతథి, అప్ను పితరుల్‍థి ఝంగాళ్‍మాను గల్లో అప్నా దేవాన టేకె జీవా వాక్యంనా లీధోతే యో ఆస్‍. ");
INSERT INTO vgr_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","పన్కి అప్నూ పితరుల్‍ లోబడనా కోహోయినింతే ‍ఇనా ధఖల్‍ నాఖిన్‍, యూవ్నూ దిల్‍మా ఐగుప్తునా జావవాళా హూయిన్‍. ");
INSERT INTO vgr_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","హామార హాఃమే ఛాలహాఃర్‍కూ దేవ్నా హామ్నా కర్‍; ఐగుప్తు దేహ్‍ఃథూ బులైలీ ఆయోతే ఆ మోషే ష్యాత్‍ హూయిగోకీ హమ్నా మాలంకోయిని కరి అహరోన్‍తి బోల్యా. ");
INSERT INTO vgr_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","యో ధన్నువ్‍యూవ్నే ఏక్ కేల్డొనా కరీన్‍ యో విగ్రహాంనా బలి దీన్‍ యూవ్నా హాతేహూః కర్యూతే ఇనా కనా హూఃషీ హుయు. ");
INSERT INTO vgr_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","ఇనహాఃజే దేవ్‍ యూవ్నా మెందావాన హుయిన్ ఆకాష్ సేవించనా హాఃజే యూవ్నా మ్హేందిదో. ఇనహాఃజే ప్రమాణ్‍తి ప్రవక్తల్‍నూ గ్రంథంమా అమ్‍ లిఖైర్యూస్‍. ఇష్రాయేల్‍నూ ఘర్‍వాళాతూమే ఘంగాళ్‍మా ఛాళీహ్‍ః వరహ్‍ః బలినూ ఢాండవ్‍నా అర్పణ్‍ల మన అర్పిపించ్యా? ");
INSERT INTO vgr_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","తుమె పూజ కరానఅ టేకె కర్‍లీదాతే మూర్తే మెలొకు గుడార్‍బి రొంఫాయబి దేవతనూ సుఖ్కర్‍నా ఢోహ్‍లీన్‍ గయా కాబట్టి బబులోనునా పార్‍ బులైలిన్జాసే. ");
INSERT INTO vgr_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","యో ధేఖ్యోతే ప్రకార్ ఇనా కర్నూ కరి మోషేథి బోల్యోహూయో యో అజ్ఞా దిదూతే ప్రకార్‍, సాక్చ్యంనూ గుడారం జంగాళ్‍మా అప్ను పితరుల్‍ కనా రయు. ");
INSERT INTO vgr_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","పాసల్తి అప్ను పితరుల్‍ యూవ్నా పెద్దల్‍థి ఇనా లీదాహుయా హూయిన్‍, దేవ్‍ యూవ్నా హాఃమేతూ రఫాట్‍నాక్యుతే జనాల్‍నా యూవ్నే స్వాధీన్‍ కర్‍లీదూతేదె యెహోషువానా కేడె ఆ దేహ్‍ఃమా ఇనా లీన్‍ ఆయు. యో దావీద్‍నూ ధన్‍తోడి రయు. ");
INSERT INTO vgr_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","యో దేవ్‍ను దయ పోందిన్‍ యాకోబ్‍ను దేవ్‍ను జోగొ భాంద్నూ కరి దేవ్తి మాంగో. ");
INSERT INTO vgr_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","కాని సోలోమోన్‍ దేవ్నా హాఃజే మందిర్‍నా భాంద్యో. ");
INSERT INTO vgr_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","హూయుతోబి “ఆకాష్ మారు సింహాసన్‍, జమీన్‍ మారు పాదపీట్‍” తుమె మారటేకే కీమ్‍నూ మందిర్‍ భాంద్‍స్యు? ");
INSERT INTO vgr_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","మారు జమీన్‍ కేహూకరి ");
INSERT INTO vgr_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","ప్రవక్త బొల్యోతిం సర్వషక్తిషాలి హఃతేఖు బణాయు హుయుమ రైకోయిని. ");
INSERT INTO vgr_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","బండనుదిల్వాళా దిల్‍నా కాన్‍నా దేవ్‍నూ వాక్యంనా లోబడవాకోయిన్తె ఇవ్నే, తూమారు పితరుల్‍నితర తూమేబి కెధేబి పరిసుద్ధాత్మనా ఎదిరించుకరస్‍. ");
INSERT INTO vgr_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","తూమారు పితరుల్‍ ప్రవక్తల్‍మా కినాబి హింసించుకోయినితిమ్‍ ర్హయ్యనా? యో దేవ్ను సమాచార్‍ బోలవాలు నీతిమంతుడ్‍ సేవకుల్నా ఆవ్‍సే కరి అగాడి బోల్యుతే యూవ్నా మర్రాఖ్యు. ఇనా తుమె హాంకే ధరైన్‍ హత్య కర్యాహుయా వాళా హుయిగా. ");
INSERT INTO vgr_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","దేవదూతల్‍తి నియమింపబడ్యుతే నియమషాస్త్రంనా తుమె పోంద్యా గాని ఇనా పాటించ్యాకోయిని. ");
INSERT INTO vgr_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","సభమ రవాలు వాతె హాఃమ్జీన్‍ ఛండాల్తీ భళిన్‍ స్టేఫన్నాదేఖీన్‍ ధాత్‍ చావనిక్యా. ");
INSERT INTO vgr_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","కాని పరిషరద్ధాత్మతి భరైహూయో హుయిన్‍ ఆకాష్‍మ్హణీ ఠర్ర్కీన్‍ దేఖీన్‍, స్తెఫన్ను దేవ్ను మహిమనా యేసు దేవ్ను ఖావాత్‍మ్హణి భీరిర్హవానూ దేఖీన్‍ ");
INSERT INTO vgr_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","ఆకాష్మని దేకిన్, అద్మినొ ఛియ్యో భీరిర్హవాను దేఖుకరుస్‍ కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","తెదె మహాసభమ రవాళు మోటు కైఖార్‍ మ్హేందీన్‍ కాన్ మూచీలీన్‍ ఏక్‍హుయిన్‍ ఇనాఫర్‍ పడీన్‍, ");
INSERT INTO vgr_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","హాఃయార్‍నా భార్‍ ఇనా రఫ్‍టిన్‍, ఫత్‍రావ్‍తి మర్రాఖ్యు. సాక్చితర సౌల్‍ కనా ఏక్ కవారునా గోఢాకనా యూవ్నూ లుంగుఢా మ్హేంద్యు. ");
INSERT INTO vgr_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","ఇవ్నే హఃరు పత్రవ్తి మారుకరతో యేసు ప్రభు, మారు ఆత్మనా చేర్సాయిలా కరి స్టేఫనే బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","యో ఢూగ్నేవ్‍ఫర్‍ బేసిన్‍ ప్రభు, యూవ్నా ఫర్‍ ఆ పాప్‍ నాక్‍నకో కరి మోటా ఆవాజ్‍థి బోల్యొ; ఆ వాత్‍ బోలిన్‍ హూఃయిగో. సౌలు తన మరణ్‍నా ఒప్పిలిదు. ");
INSERT INTO vgr_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","యో ధన్మా యెరూషలేమ్మను సంఘంనా మోటు హింహువమ, అపొస్తుల్‍ తప్ప అజు విష్వాసుల్‍ హాఃరు జణుబి యూదయ, సమరయ దేఖ్మా చేద్రీగయు. ");
INSERT INTO vgr_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","భక్తివాళు అద్మీయే స్తెఫన్‍నా సమాధి కరీన్‍ ఇనా గూర్చీ దుఃఖించిన్ రోయా. ");
INSERT INTO vgr_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","సౌల్‍తో ఘర్‍ ఘర్‍మా పేషీన్‍, హాఃరావునా రాండేవ్‍నా ఖేచ్‍లీజైన్‍, చేరసాల్‍మ నఖైన్‍ సంఘంనా నాషానమ్ కరుకర్తోతో. ");
INSERT INTO vgr_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","ఇనహాఃజే చెద్రిగయుతే యూవ్నే సువార్త వాక్యంనా ప్రచార్‍ కర్తుహుయిన్‍ రయు. ");
INSERT INTO vgr_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","తెదె ఫిలిప్పు సమరయమ చాతేముఖ్య హఃయార్‍తోడి జైన్‍ క్రీస్తునా యూవ్నా ప్రచార్‍ కర్తో ర్హయో. ");
INSERT INTO vgr_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","జనాల్‍ హాఃరు హఃజీన్‍ ఫీలిప్పు కర్యోతే సూచక క్రయల్‍నా దేఖమ యో బోల్యొతే వాతేమ ఏక్ మన్‍థి ఖంజు. ");
INSERT INTO vgr_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","కేత్రాకీజణానా ధర్యుతే అపవిత్రాత్మల్‍ చిగర్తూహుయిన్‍ యూవ్నా మ్హేంధిచలిగు; హాత్‍ గోఢా పడీగయు హుయుబి లంగుఢుబి కెత్రూకి జణు హూఃదుహుయ. ");
INSERT INTO vgr_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","ఇనటేకె యో హాఃయార్‍మా కెత్రూకి సంతోషమ్‍ హూయు. ");
INSERT INTO vgr_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","యో హాఃయార్‍మా సీమోన్‍ ఏక్ అద్మి యో ధన్‍మా గారడీ కర్తూహుయిన్‍, యో ఏక్ మోటో కరి బోల్లేతోహుయిన్‍ సమరయ జనాల్‍నా హాషం కర్తోర్హయో. ");
INSERT INTO vgr_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","గరీబ్‍థూ ధరీన్‍ మహాన్‍ అద్మీయేబి హాఃరు జణు దేవ్నూ మహా థాకత్‍ కతే ఆస్‍ కరి బోల్తుహుయిన్‍ ఇని వాత్‍నా ధ్యాన్‍ దిదూ. ");
INSERT INTO vgr_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","యో ఘణా ధన్ జాదుగర్‍ కర్తోహుయిన్‍ యూవ్నా హాషం కరౌతో ర్హయో ఇనహాఃజే యూవ్నా ఇనా ధ్యాన్‍ దిదూ. ");
INSERT INTO vgr_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","కాని ఫిలిప్పు దేవ్‍నూ రాజ్యంనాటేకె యేసు క్రీస్తునూ నామ్‍నాటేకె సువార్త ప్రచార్‍కరాతో ఇవ్నే ఇనా నమ్మిన్‍ మరధ్‍మనాబి భాయికాబి బాప్తిస్మమ్‍ లీదా. ");
INSERT INTO vgr_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","తెదె సీమోన్‍బి నమ్మిన్‍ బాప్తిస్మమ్‍ లీన్‍ ఫిలీప్పునా నామ్హేంధికేడెస్‍ ర్హైన్‍, సూచక క్రియల్‍నా మోటా జర్గాతే అద్భుతాల్నా దేఖిన్‍ అష్యం హుయో. ");
INSERT INTO vgr_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","సమరయవాళు దేవ్‍ను వాక్యంఒప్పిలీదా కరి యెరూషలేమ్‍మాను అపొస్తుల్‍ హాఃజిన్‍, పేతురుబి యోహాన్‍నా ఇవ్నా కనా మొక్‍ల్యా. ");
INSERT INTO vgr_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","ఆవ్నే ఆయిన్‍ పరిసుద్ధాత్మనా పోంద్నూ కరి యూవ్నా హాఃజే ప్రార్ధన కర్యు. ");
INSERT INTO vgr_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","ఇన అగడీ ఇవ్నమా కీనాఫర్‍బి యో ఉత్రొకోయిని, ఇవ్నె ప్రభు హుయోతె యేసునా నామ్‍ తీస్ ‍బాప్తిస్మమ్‍ లీరాక్యాత. ");
INSERT INTO vgr_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","తెదె పేతురుబి యోహాన్‍ ఇవ్నాఫర్‍ హాత్‍ మ్హేంధమ ఇవ్నె పరిషుద్ధాత్మనా పొంద్యా. ");
INSERT INTO vgr_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","అపొస్తుల్నా హాత్‍ మేందమ పరిసుద్ధాత్మ ఆయుకరీ సీమోన్‍ దేఖిన్‍, ");
INSERT INTO vgr_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","ఇవ్నా హాఃమె రఫ్యా మ్హేందీన్‍, మే కినాఫర్‍హాత్‍ మేందూస్కి ఇవ్నె పరిసుద్ధాత్మ పొందహఃర్కూ ఆ అధికార్‍ మన దేవొకరీ మాంగ్యో. ");
INSERT INTO vgr_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","ఇనహాఃజే పేతురు, తూ రఫ్యా దీన్‍ దేవ్‍నూ వరంనా కమైలీస్‍ కరి సోచ్యోతే నామ్‍నా తారు రఫ్యా తారెతీస్‍ గలిజాసే. ");
INSERT INTO vgr_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","తారు దిల్‍ దేవ్‍నా హాఃమే భరోభర్‍నూ కాహె ఇనటేకె ఆ కార్యంమా తునా భాగ్‍కోయిని. ");
INSERT INTO vgr_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","ఇనహాఃజె తారు ఖరాబ్‍ చాల్‍ మ్హేందిన్‍ దిల్‍ బద్లాయిలీన్‍ ప్రభునా వేడిలా; ఏక్‍వొహఃత్‍ తారు దిల్నూ సోచ్ మాప్‍ హువాజై; ");
INSERT INTO vgr_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","తూ ఘణూ దుష్టత్వంమా దుర్నితి బంధకంమ ర్హవానింతర మన దేఖ్కాంక్రస్‍కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","ఇనహాఃజె సీమోన్‍ తుమె బోల్యాతే ఇనమా ఖయ్యుబి మరఫర్‍ నాఆవ్నూతిమ్‍ తూమేస్‍ మారహాఃజే ప్రభునా వేడీలేవొ కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","ఇనబాద్మా ఇవ్నే సాబుత్‍ దేతూహుయిన్‍ ప్రభువునా వాక్యం బోల్తూహుయిన్‍ యెరూషలేమ్‍నా ఫాచు ఆతాహియిన్ సమరయుల్‍నూ గామేవ్‍మా సువార్త ప్రచార్‍ కర్తాహుయిన్‍ ఆయా. ");
INSERT INTO vgr_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","ప్రభు దూత తూ వుటీన్, దక్చీన్‍నా జైన్‍, యెరూషలేమ్‍థూ గాజానా జావాను ఘంగాళ్‍ను వాట్‍ఫర్‍ మళ్‍కరీ ఫిలీప్పుతి బోలమా యో ");
INSERT INTO vgr_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","ఉట్టీన్‍ గయో. తెదె ఇథియోపీయాల్‍ని రాణిహూయితే కందాకేనాహేట్‍ మంత్రిహుయిన్‍ ఇను ధవ్లత్‍ అక్కవ్‍నా ఉఫర్‍ ఛాతే ఇథియోపీయాడ్‍ హూయోతే నపుంసకుడ్‍ ఆరాధించనా యెరూషలేమ్‍నా ఆయో. ");
INSERT INTO vgr_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","యో ఫాచు ఫరీన్‍ జాతొహుయిన్‍, ఇను రథ్‍ ఫర్‍ బేసీన్‍ ప్రవక్త హూయోతే యెషయా గ్రంథ్‍ పడ్తోర్హయో. ");
INSERT INTO vgr_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","తెదె పరిసుద్ధాత్మనా ఫిలిప్పుథి తూ యో రథ్‍కనా జైన్‍ ఇనా మళ్కరీ బోల్యు. ");
INSERT INTO vgr_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","ఫిలిప్పు కందే నాహ్‍ఃతోహుయిజైన్‍ యో ప్రవక్త యెషయాను గ్రంథ్‍ ఫఢుకరాతో క్హంజీన్‍ తూ ఫడుకరాతే తునా అర్ధం హూంక్రస్‍నా? కరి పుఛవమా, ");
INSERT INTO vgr_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","యో కోన్బి మన వాట్‍ మన అర్థం నాబోల్యొతొ కిమ్‍ అర్ధంహుసెకరీ బోలిన్‍, ఘోడను బండిఛడీన్‍ మార కనా బేహ్ఃకరీ పిలిప్పునా వేడిలిదు. ");
INSERT INTO vgr_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","ఇను లేఖనాల్మా పఢుకరతే భాగ్సాత్కతో మ్హేండనా చెల్కంతర బిరిరయోతో, మ్హేండనుఖెహ్ః కత్రవాళకన కింబిరస్ ఇంమస్ బిరొతో. ");
INSERT INTO vgr_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","యో ఇనుయో తగించిలిదో ఇనా న్యాయం కోమాల్యుని ఇను వంషంనా కోణ్ వివరణ కర్షే. ఇను జీవం జమీన్‍ఫర్తూ ఖన్నాకిదిదు. ");
INSERT INTO vgr_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","తేదె యో ఆధికారి ప్రవక్త ఆ వాతే కినాబారెమా అమ్నితరా బోలుకరాస్. ");
INSERT INTO vgr_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","ఇనాటేకె ఫిలిప్పు ఇనామోడతి ఆం భోల్యో, ఆ లేఖన్మాచాతే యేసుని భారేమ భోల్యో. ");
INSERT INTO vgr_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","ఇవ్నె యో వాటేజవుంకరతే సమయంమ పాణిచాతే జొగొబిరైకాడ్యు, తేదె యో ఆదికారి హైదేఖ్ పాణిఅజ్గచా బాప్తిస్మం దేవాన ఆటంకం షాత్చకరి రధమ్నా బిరైకాడ్కరి ఇనేతే బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","ఫిలిప్పు నపుంసకుడ్‍ అధికారితి తార హాఃచ్చదిల్తి విస్వషమ్ కర్వోతో బాప్తిస్మం లేవాజైకరి బోల్యో, తేదె యో ఆధికారి యేసుక్రీస్తు దేవ్ని ఛియ్యోకరి మే ఒప్పిలేంకరుస్కరి బొల్యో. ");
INSERT INTO vgr_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","ఫిలిప్పు యో ఆధికారి ఇవ్నేబేజణ పాణిమ ఉత్రిన్ ఫిలిప్పు యో ఆధికారినా బాప్తిస్మం దిదో. ");
INSERT INTO vgr_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","ఇవ్నే పాణిమతు బాదర్అయు దేవ్నిఆత్మ ఫిలిప్పునా అల్దివాటే బులాయిగయు, యో ఆదికారి అలాధివాటే చల్యుగయు అజు కెదేబి దేకాయుకోయిని. ");
INSERT INTO vgr_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","తెదె ఫిలిప్పు అజోతులో దేకాయో, ఇజ్గతో అవాతోడి హాఃరై హాఃరమ దేవ్నివాతేబొల్తొహుయిన్ ఆయో. ");
INSERT INTO vgr_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","సౌలు బుజున్‍బి ప్రభును సిష్యుల్‍నా ధమ్‍కావనూబి హత్యకరానుబి ఇనా గ్హణు జాన్ కరి ప్రధానయాజక్‍ కనా జైన్‍, ");
INSERT INTO vgr_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","ఆ వాట్‍ఫర్‍ ఛాతే మరధమానానహో, రాండేన్‍హో మాలంకర్‍లిదాతో, యూవ్నా బంధీంచీన్‍ యెరూషలేమ్‍నా లీన్‍ ఆవాన ధమస్కుమాను సమాజంమచాతే జోగొ వాళవ్నా ఇవ్నా పత్రికల్‍ ధాకరీ మాంగ్యు. ");
INSERT INTO vgr_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","యో ప్రయాణ్ ధమస్కునా నంగర్‍ కందే ఆయుతెదె, తేదె ఆకాష్‍మథూ ఏక్ ఊజాళు ఇనా ఆష్పిస్‍ భళానిక్యు. ");
INSERT INTO vgr_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","తెదె యో జమీన్‍ ఫర్‍ పడీజావదీన్‍ సౌలా, సౌలా తూ ష్యాన మన హాఃతాంక్రస్‍ కరి ఇనేతి ఏక్ గళుథీ బొలాను హాఃజు. ");
INSERT INTO vgr_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","ప్రభు, తూ కోన్కరీ పుఛ్చావమ యో హాఃతాంక్రస్‍తే యేసు; ");
INSERT INTO vgr_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","తూ వుటిన్‍ నంగర్మా ‍జా, ఎజ్గా తూ ష్యాత్‍ కర్నూకి తున మాలంహుస్యే కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","ఇనేతి కేడె ఆయుహుయు అద్మియే ఆవాజ్‍ హఃజూ పన్కీ కినాబి నాదేఖిన్‍ షోపోహుయిన్‍ ఉభ్రిగయ. ");
INSERT INTO vgr_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","సౌల్‍ జమీన్‍ ఫర్తూవుట్టీన్ డోళొ కాడ్యోతోబి ఇనా కాయిబి కోదెఖ్కాయుని, ఇనటేకె ఇవ్నే హాత్‍ధరీన్‍ ధమస్కుమా బులైలీన్‍ గయా. ");
INSERT INTO vgr_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","యో తీన్‍ రోజ్‍ డోలాను నజార్‍ కోయినితిమ్‍ ఖాణు పాణీబి కోయినితిమ్‍ ర్హయో. ");
INSERT INTO vgr_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","ధమస్కుమ అననీయా కరి ఏక్ సిష్యుడ్‍ థో. ప్రభువు ఇనా ఖోఃణ్యామ అననీయా కరి బులావమ, యో ప్రభు మే ఛౌవ్‍. ");
INSERT INTO vgr_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","తెదె ప్రభు అమ్‍ బోల్యొ తూ వుటీన్‍ తిన్నని కరి గల్లీమ జైన్‍, యూదా కరి ఏక్నా ఘర్మా తార్సువాలొహుయోతె సౌల్‍నా గూర్చి ఏన్కరో, హాదేక్‍ యో ప్రార్థన కరుకరాస్‍. ");
INSERT INTO vgr_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","యో అననీయ కరి ఏక్ అద్మి మై ఆయిన్‍, ఇనా ఢోళఆవ్నూతిమ్‍ మాథఫర్‍ హాత్‍ మ్హేంధనూ దేఖిరాక్యోస్‍, కరి బొల్యొ. ");
INSERT INTO vgr_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","ఇనహాఃజే అననీయ ప్రభు ఆ అద్మి యోరుషలేమ్‍మ తారు పరిసుద్ధన కెత్రుకి హనికర్యు కరి కేత్రకీ అద్మీయే కనా మే హాఃజ్యో. ");
INSERT INTO vgr_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","అజ్గాబి తారు నాంతి ప్రార్ధన కరవళా హాఃరౌనా బందించనాటేకె ప్రధాన యాజకుల్‍తి అధికారం లీరాక్యోస్‍ని కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","ప్రభు ఇనేతి అంబోల్యొ తూ జా; అన్యుల్‍నా హాఃమేబి, రాజుల్‍నా హాఃమేబి, ఇస్రాయేలిల్‍నా హాఃమేబి మారు నామ్ను ప్రచార్‍ కరనా మే ఏర్పచిరాక్యొతె ఏక్ సాధనం హూయిరోస్‍. ");
INSERT INTO vgr_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","ఆ మారు నామ్‍నా టేకె కేత్రు మిన్హత్‍ పణ్నూకి కరాంవుస్‍ కరి ఇనేతి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","తెదె అననీయ యో ఘర్మా జైన్‍, ఇనాఫర్‍ హాత్‍ మేందీన్‍ సౌల్‍ భై తూ ఆయోతే వాట్ఫర్‍ఫర్‍ తున దేఖాయోతే ప్రభు హూయోతే యేసు, తూనా నజార్‍ ఆయిన్‍ పవిత్రాత్మతి భరౌనూతిం మన బోలిమెక్ల్యో. ");
INSERT INTO vgr_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","తేదెస్‍ ఇనా డోలా వాటే పోరల్‍ను జోణ్‍ను పడమ డొలా దెకావలగ్యు వుటిన్‍ బాప్తిస్మమ్‍ లిదో; ");
INSERT INTO vgr_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","ఇనబాద్మా ఖాణు ఖైన్‍ థాఖత్‍ లీదొ. ఇనబాద్మా యో ధమస్కుమా ఛాతే సిష్యుల్‍తి మలీన్‍ థోడుధన్‍ ర్హయో. ");
INSERT INTO vgr_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","ఎగ్గీస్‍ యో న్యావ్‍నుజొగొ యేసుస్‍ దేవ్‍నో ఛియ్యో కరి ఇనా గూర్చి ప్రచార్‍ కర్తోర్హయో. ");
INSERT INTO vgr_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","హాఃమ్‍జ్యుతే హఃరు హాషంహూయిన్‍, యోరుషలేమ్‍మా యేసు నామ్‍తి ప్రార్ధన కరవళాన మార్రాక్యోతె ఆస్‍ కాహేనా? యువ్నా బాందిన్‍ ప్రధాన యాజకుల్‍ కనా బులైలి జవనా టేకె అజ్గాబి ఆయిరోస్‍ కరి బోల్లీదు. ");
INSERT INTO vgr_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","హూయితోబి సౌల్‍ బుజు గ్హణు థాఖత్తి ఆస్‍ క్రీస్తు కరి సాబుత్‍ కర్తోహూయిన్‍ ధమస్కుమా జీవుణు కరుకరాతే యూదుల్‍నా కలవర పర్‍చ్యు. ");
INSERT INTO vgr_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","కెత్రాకీ ధన్‍ చల్‍జవదీన్ ఇనబాద్‍మా యూదుల్‍ సౌల్నా మర్రాక్‍నూ కరి హూఃజ్‍ నాఖమా, ");
INSERT INTO vgr_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","హయుతో యూవ్నే నాఖాతే హూఃజ్‍ సౌల్‍నా మాలంహూయు, యూవ్నే ఇనా మార్నూ కరి రాత్నూ ధన్ను వాట్‍కనాస్‍ కావ్లీకాసిర్హయు. ");
INSERT INTO vgr_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","ఇనటేకె ఇనా సిష్యుల్‍ రాత్ను వహఃత్‍ ఇనా లీన్‍ జైన్‍ గంపమా రాఖీన్‍ కోటనూ భీత్‍నా ఉఫర్‍తూ కరి హేట్‍ఉత్రాయు. ");
INSERT INTO vgr_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","యో యోరుషలేమ్‍మా ఆయిన్‍ ఇన సిష్యుల్‍తి మళీర్హనూ కరి కోషిష్‍ కర్యో పన్కి, అద్మీయే క్హారు ఇనా సిష్యుడ్‍ కరి నా నమ్మిన్‍ ఇనా దేఖీన్‍ ఢర్యు. ");
INSERT INTO vgr_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","హూయితోబి బర్నబా ఇనా కందే లీన్‍ అపొస్తుల్‍ కనా బులైలిఆయిన్‍, యో వాట్‍ఫర్‍ ప్రభునా దేఖ్యోకరీ, ప్రభుతి వాతె బోల్యొ కరి యో ధమస్కుమా యేసునూ నామ్‍తి హిమ్మత్‍తి బోదించ్యో కరి యూవ్నా ఖూల్లా కరీన్ బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","యో ఇవ్నే మలిన్‍ యోరుషలేమ్‍మా హాఃరు ఫరిన్‍ ప్రభునూ నామ్‍తి హిమ్మత్‍తి బోదిస్తోహుయిన్‍, ");
INSERT INTO vgr_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","గ్రీక్‍మా వాతె బొలావళాతి, యూదుల్‍తి వాతె బోల్తోహుయిన్‍, పేడ్తోర్హాయో. యూవ్నే ఇనా మార్నూ కరి కోషిష్‍ కర్యా పన్కి ");
INSERT INTO vgr_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","అజు భైయ్యె ఇనా మాలంకర్లీన్‍ ఇనా కైసరయానా బులైలీన్‍ తార్సునా బొలీమెక్‍ల్యా. ");
INSERT INTO vgr_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","ఇనహాఃజే యూదయ గలిలయ సమరయ జోగొ హాఃరవ్‍మా సంఘం క్చమాబివృద్దిలేతోహుయిన్‍ సమాదానంతి రయు, అజు ప్రభుమా ఢర్‍బి, పరిషుద్ధాత్మనూ అదరణబి కలిగిన్‍ చాల్తోహుయిన్‍ ఫైలాయో. ");
INSERT INTO vgr_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","ఇనబాద్మా పేతురు హర్యేక్ జోగొ ఫర్తోహుయిన్‍ లుద్దమా జీవ్‍ణు కరుకరాతే దేవ్ను జనభో కనా గయో. ");
INSERT INTO vgr_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","ఎజ్గా హాత్‍ గోఢా పడ్యుగయుహహుయు ఐనెయ కరి ఏక్ అద్మి ఆట్‍ వరఖ్‍ఃతూ మంచ్వో ధర్రాక్యుతే ఇనా దేఖీన్‍, ");
INSERT INTO vgr_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","పేతురు ఐనెయా, యేసు క్రీస్తు తునా అషల్ కరూకరస్ తూ వుటీన్‍ తారు బిస్తార్‍ పల్లిన్ జాకరీ ఇనేతి బోల్యొ. యగ్గిస్‍ యో వుటిగయు ");
INSERT INTO vgr_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","లుద్దమ షారోన్‍మ రావళు హాఃరుబి ఐనెయునా దేఖీన్‍ ప్రభుమ అజు ఘాణు దేవ్‍మ విష్వాస్కరు. ");
INSERT INTO vgr_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","బుజు యొప్పేమ తబితా కరి ఏక్ విష్వాసంతి. ఇనా గ్రీక్‍మ దోర్కా కరి నామ్‍ ఇను అర్థం చీతాల్‍. యో ధరమ్‍ను కామ్‍బి, బుజు కెత్రుకి అషల్ కామ్‍ కర్రాఖీ. ");
INSERT INTO vgr_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","యో ధన్నువ్‍మా యో అషల్ కొయిన్తిం మరీజవమా, ఇవ్నే యో ముర్దునా పాణితి ధోవడిన్‍ మిద్దినాఉఫర్‍ హుడియిరాక్యు. ");
INSERT INTO vgr_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","లుద్ద యొప్పేను కంధేస్‍ను గామ్‍ కాబట్టి పేతురు ఏజ్గా ఛాకరీ సిష్యుల్‍ హాఃజీన్‍ యో ఎగ్గిస్‍ ఇవ్నా కనా ఆవ్ను తిమ్‍ యూవ్నామ బేజణనా ఇనా వేడిల్దా బులైల్యావనాటేకె ఇనాకనా బోలిమొక్‍ల్యా. ");
INSERT INTO vgr_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","తెదె పేతురు వుటీన్‍ యూవ్నేతి మలిన్‍ ఏజ్గా గయో. యూవ్నే ఇనా మేడ గదిమా లీన్‍ గయా. బావ్రీ కోయింతే బాయిక్వా హాఃరీ ఆయిన్‍ రోతుహుయిన్‍, దోర్కా యూవ్నేతి రైతేదె యో సీవి దిదితే ఖూఢతా, లుంగఢా ఇనా దేఖాడ్తూహుయిన్ రోయు. ");
INSERT INTO vgr_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","పేతురు యూవ్నా హాఃరవ్‍నా బాధర్‍ బోలిమోక్లిన్‍, గూఢ్‍గేఫర్‍ బేసీన్‍ ప్రార్దన కరీన్‍, ముర్దు మ్హణీ ఫరీన్‍ తబితా వుట్‍ కరీన్‍ బోలమా, యో ఢోలా కాడీన్‍ పేతురునా ధేఖీన్‍ వుటీన్‍ బేసీగయి. ");
INSERT INTO vgr_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","యో ఇనా హాత్‍ ధరీన్‍ వుట్టడీన్‍ విష్వా‍సుకనా బావ్రికోయింతే బాయిక్వా కనా లీన్‍ జైన్‍ ఇనా అప్పగించ్యో. ");
INSERT INTO vgr_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","ఆ వాత్‍ యొప్పేమ హాఃరవ్‍నా మాలంహూవమ కెత్రూకి జణు ప్రభునా విష్వాసించు. ");
INSERT INTO vgr_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","పేతురు యొప్పేమ సీమోన్‍ కరి చేప్లే సీవవాళునా ఘర్‍కనా కేత్రుకి ధన్‍ రయో. ");
INSERT INTO vgr_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","ఇటలీ పటాలం కరి బోలాతే పటాలంమా షతాధిపతి హూయోతే కోర్నేలీ కరి ఏక్ భక్తీతీ ర్హవళు యో కైసరయామా థో. ");
INSERT INTO vgr_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","యో ఇను ఘర్‍ పరీవార్‍తి దేవ్‍మా గ్హణు భయభక్తితి ర్హైన్‍, అద్మీయేనా ఘాణు ధరమ్‍ కర్తోహుయిన్‍ కెధేబి ప్రార్థన కర్తోర్హవళో. ");
INSERT INTO vgr_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","ధోఫర్ను భరోబర్‍ తీన్‍ బజేనూ వోహఃత్మా దేవ్‍నూ దూత ఇనాకనా ఆయిన్‍, కోర్నేలి కరి బులావమా యో దర్షనంమా ఖూల్లా దేఖ్యొ. ");
INSERT INTO vgr_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","యో దూత మ్హణీ ఫరీన్‍ ధేఖీన్ ఢరీజైన్‍‍ ప్రభు సాత్‍ కరి పుఛాయో, ఇనటేకె దేవ్ను దూత తారు ప్రార్ధనబి, ధరమ్‍నూ కామ్‍ హాఃరు దేవ్‍ ఖుషి హుయో తారు ప్రార్థనా జబబ్‍ కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","హాంకే తూ తారు అద్మీయేనా యొప్పేనా బోలిమొక్లీన్‍, పేతురు కరి బోలాతే సీమోన్‍నా బులైమంగౌ, ");
INSERT INTO vgr_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","యో ధర్యవ్‍నా కనారినా ఛాతే సీమోన్‍ కరి ఏక్ చేప్లే సీవవాళునా ఘర్‍మా ఛాకరీ ఇనేతి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","తెదె ఇనేతి వాతె బోల్యుతే దూత ఛల్‍జావదీన్‍, యో యగ్గిస్‍మా ఇనా ఘర్‍మా కామ్‍ కరవాళుమా బేజణాన, బుజు ఇనాకనా నమ్మకంతి ర్హవళు సైనిక్నా బులైన్‍, ");
INSERT INTO vgr_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","యూవ్నా ఆవాత్‍ హాఃరు బోలిన్‍ యొప్పేనా బోలిమొక్‍ల్యొ. ");
INSERT INTO vgr_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","బుజా ధన్నేయూవ్నే యొప్పేనా కందే జాతార్హయా. తెదె భరోబర్‍ భరాబజనా పేతురు ప్రార్దన కరానటేకె మిద్ది ఛడీన్‍ గయో. ");
INSERT INTO vgr_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","యో ఘణు బుక్‍తి ర్హైన్‍ ఖాణు ఖాణు కరి రైగో ఘర్‍వాళు ధాన్‍ కర్తుర్హవమా యో దర్షనం దేఖ్యో, ");
INSERT INTO vgr_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","తెదె ఆకాష్‍ ఉక్‍డైన్‍ చార్‍బాజు నూఛేడో ధరైన్‍ వుత్ర్యుతే ఏక్ మొటు గోధిడినూ జోణ్‍నూ ఏక్ థాళి జమీన్‍ఫర్‍ వుత్రానూ దేఖ్యో. ");
INSERT INTO vgr_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","ఇన్‍మా జమీన్‍ఫర్‍ ర్హవళు కెత్రూకి రకంనూ జీన్‍వార్‍, జమీన్‍ హాఃవ్‍ళవాలు కీడాబి, బుజు ఉడావాళు జీన్‍వార్‍ థూ. ");
INSERT INTO vgr_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","తెదె “పేతురునా తూ వుటీన్‍ మారీన్‍ ఖా” కరి బోలిన్‍ ఏక్ ఆవాజ్‍ హాఃజాయు. ");
INSERT INTO vgr_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","పన్కి పేతురు నకో ప్రభు అపవిత్రంనూ కేయుబి మే కెధేబి ఖాధో కోయిని కరి బోలమా, ");
INSERT INTO vgr_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","దేవ్‍ పవిత్రం కర్యోతే ఇన అపవిత్రం కరి నకో ఏంచ్‍ కరి బుజేక్‍ చోట్‍ యోస్‍ ఆవాజ్‍ ఇనా హాఃమ్‍జాయు. ");
INSERT INTO vgr_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","ఇమ్మస్‍ తీన్‍ వొహఃత్‍ హుయు, ఇనబాద్మా యో ఎగ్గిస్‍మా ఆకాష్‍మా థాళి ఉఫర్‍ పడైగయు. ");
INSERT INTO vgr_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","పేతురు ఇనా ఆయుతే ఖోఃణ్యు సాత్‍లాకరి ఇను ఇనూస్‍ కాయిబి తోచకోయింతే ర్హవమా, కోర్నేలి బోలిమొక్‍ల్యొతే అద్మియే సిమోన్‍నూ ఘర్‍ కేయు కరి పుఛావ్‍తూహుయిన్‍, మాలంకరీన్‍ ఇనా ఘర్‍నా బాధర్‍ హుబ్రిన్‍. ");
INSERT INTO vgr_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","ఘర్‍నూ అద్మీయేనా చిక్ర్యు. పేతురు కరి బుజైక్‍నామ్‍నూ అద్మి సీమోన్‍ అజ్గ ఛానా? కరి పుఛ్చాయు. ");
INSERT INTO vgr_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","పేతురు యో ఖోఃణ్యానా గూర్చి సోచుకరాతో ఆత్మ హదేక్‍ తిన్‍ జణ తూనా ఢూండుకరాస్‍ కరి బోల్యా. ");
INSERT INTO vgr_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","తూ వుటిన్‍ హేట్‍ వుత్రిన్‍ నోకోకరి బొలిన్‍ యూవ్నా కేడె జా యూవ్నా బోలిమొక్‍ల్యోతే మేస్‍ కరి ఇనేతి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","పేతురు యో అద్మీయేకనా ఆయిన్‍ హదేక్‍ తుమె డుండుకరాతే అద్మి మేస్‍ తుమె ఆయుతే ష్యానటేకెకీ బోల్‍ కరి ఇవ్నే బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","తెదె ఇవ్నే అమ్‍ బోల్యా, నీతిమంతుడ్‍నితరా ర్హావళు, దేవ్తి ఢరవాళు యూదుల్‍తి అషల్ నామ్‍ కమైలిదోతే షతాధిపతి కోర్నేలి కరి ఏక్ అద్మి ఛా యో తునా బులైమంగైన్‍ తూ బోలాతే వాతె హాఃజ్ను కరి పరిసుద్ధ దూతతి బోలావమ యో ఇనటేకె తూనా బులాయో. తెదె యో ఇవ్నా బులైన్‍ తూ సాత్ బోలస్కి ఇనా హాఃజనటేకే. ");
INSERT INTO vgr_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","పేతురు ఉజేక్ దన్నె ఇవ్నాకేడె గయో, యొప్పెకరి హాఃరైమరావళు, థోడుజణు భైయ్యేబి ఇనా కేడె గయూ. ");
INSERT INTO vgr_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","బుజేక్‍ ధన్నే యూవ్నే కైసర్‍మా గయా. తెదె కోర్నేలి ఇనా బందుల్‍నా దోస్తుల్‍నా బులైలీన్‍, ఇనటేకె ఎదుర్‍ దేక్తుర్హయు. ");
INSERT INTO vgr_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","పేతురు మై అవదీన్‍ కోర్నేలి ఎదుర్కోని ఇనా గోఢాఫర్‍ పడీన్‍ క్హలామ్‍ కర్యో. ");
INSERT INTO vgr_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","ఇనటేకె పేతురు బోల్యొ తూ వుటీన్ భిర మేబి అద్మీస్‍ కరి బోలిన్‍ ఇనా ఉటాడీ భిరకాఢీన్‍, ");
INSERT INTO vgr_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","ఇనేతి వాతె బోల్తుహుయిన్‍ మై ఆయిన్‍, కెత్రూకి జణు భరైర్హవనూ దేఖ్యో. ");
INSERT INTO vgr_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","తెదె యో అన్యుల్‍తి మలీన్‍ ర్హావనుబి ఇంనూ అద్మీయేనా ఛీమానుబి యూదుల్‍నా ధరమ్‍ కాహే కరి తూమ్‍నా మాలం, కానీ హఃయు అద్మీబి ధక్‍లాయిగయో కరీతోబి, అపవిత్రంనో కరీతోబి నాబోల్‍నూ కరి దేవ్‍ మన దేఖాఢీరాక్యోస్‍. ");
INSERT INTO vgr_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","ఇనహాఃజే మన బులాయోతేదె కోఆవ్‍ని కరి ఆఢు క్హయుబి నాబోల్‍నూతిమ్‍ ఆయో. ఇనటేకె ష్యాన బులాయాకీ ఇనా గూర్చీ పుచాంగ్రస్‍ కరి యూవ్నేతి బోలుకరూస్‍. ");
INSERT INTO vgr_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","ఇనటేకె కోర్నేలి ఛార్‍ రోజ్‍నా అగఢీ ధోఫర్ను తీన్‍ భజేతూ ధరీన్‍ ఆ వొక్హత్‍ తోడి ప్రార్దన కరుకరుతో ధోళుఫట్‍ జంమ్‍కుకరాతే లుంగఢా పేర్రాక్యుతే ఏక్ జణో మార క్హామె భీరిగొ. ");
INSERT INTO vgr_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","కోర్నేలి తారీ ప్రార్దన హాఃమ్‍జాయు; తారు ధరమ్‍ కామ్‍ దేవ్‍నా హాఃమె హాఃయాల్‍ కర్యోకరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","ఇనటేకె తూ యొప్పేనా బొలీమొక్లీన్‍ పేతురు కరి బోలాతే సీమోన్‍నా బులైమంగౌ యో ధర్యావ్‍నా కనారీనా ఛాతే చేప్లే సీవవాళు సీమోన్‍నా ఘర్మా ఆయిరోస్‍ కరి మారేతి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","జల్దీస్‍ తూనా బులాయో తూ ఆయోతే ఆసేలస్‍. ప్రభు తూనా ఆజ్ఞాపించ్యోతే క్హారు హాఃమ్‍జనా టేకె హంకే హమే హాఃరా దేవ్‍న క్హామె అజ్గ ఏక్‍జోగొ బేటాస్‍ కరి బోల్యొ, ఇనటేకె పేతురు మోఢు కాడీన్‍ అమ్‍ బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","దేవ్‍ పక్చపాతి కాహే యో హాఃచి కరి మాలంకర్‍రాక్యోస్‍. ");
INSERT INTO vgr_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","హార్యేక్ జనంబీ ఇనేతి ఢరీన్‍ నీతిథీ రావవాళునా యో అంగీకరించస్‍. ");
INSERT INTO vgr_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","యేసు క్రీస్తు హాఃరవ్‍నా ప్రభుస్‍. ఇనద్వార సమాదానంను సువార్తనా ప్రచార్‍ కరీన్‍ ఇస్రాయేలిల్‍నా బోలిమొక్‍ల్యొతే ఖభార్‍ తూమ్నా మాలమస్‍. ");
INSERT INTO vgr_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","యోహాన్‍ బాప్తిస్మమ్‍ లేను కరి ప్రచార్‍ కరానుబాద్‍మా గలిలయతూ ధరీన్‍ యూదయాదేహ్ః క్హారు ఫైలాయుతే వాత్‍ తూమ్‍నా మాలం. ");
INSERT INTO vgr_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","యో ష్యాత్‍ కతో దేవ్‍ నజరేయుడ్‍నో యేసునా పరీసుద్దాత్మతి థాకత్‍తి అభిషేకించ్యొతేస్‍. దేవ్‍ ఇనా కేడె రయో యో మేల్‍ కర్తోహుయిన్‍, సైతాన్‍నా హాతె పింజావ్‍కరాతే యూవ్నా హాఃరౌనా అసేల్‍ కర్తోహుయిన్‍ రయో. ");
INSERT INTO vgr_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","యో యూదుల్‍ను దేఖ్‍ఃమబి, యెరూషలేంమబి కర్యోతే హాఃరౌనా హామే సాక్చుల్‍. యూవ్నే ఇనా సిలువఫర్‍ మారీనాఖ్యా. ");
INSERT INTO vgr_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","పన్కి దేవ్‍ ఇనా తిన్‍మన్‍ ధన్నే ఉట్టాడీన్‍ ");
INSERT INTO vgr_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","ప్రజల్‍ కాహేతిమ్‍ దేవ్‍ చూనిలిదోతే సాక్చుల్‍నస్‍ కతో యో మరీహుయుమతూ ఉట్యోతే ఇనబాద్‍ ఇనేతి మలిన్‍ ఖాణు పాణీ ఖాదాతే హామ్‍నస్‍, యో ప్రత్యేకంగా దేఖవహాఃరుకు దేఖాయో. ");
INSERT INTO vgr_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","ఆస్‍ కాహే తిమ్‍ దేవ్‍ జీవ్తావ్‍నబి, మర్యాహుయమబి న్యాయాధిపతింతర మ్హేందోతే ఆస్‍ కరి ప్రజల్‍నా ప్రచార్‍ కరీన్‍ ఘట్‍ సాక్చ్యం బోల్‍నూ కరి హామ్నా ఆజ్ఞాపించ్యో. ");
INSERT INTO vgr_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","ఇనకనా విష్వాసంగా ర్హవళు కోన్‍కీ యేసునూ నామ్‍తి యూవ్నా పాప్‍ మాఫి మళ్‍స్యే కరి ప్రవక్తల్‍ హాఃర బోల్యా. ");
INSERT INTO vgr_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","పేతురు అజున్‍బి ఇమ్మస్‍ వాతె బోలుకరాతో ఇను వాతె హాఃజుకరతె యూవ్నాఫర్‍ పరీసుద్దాత్మ ఆయు. ");
INSERT INTO vgr_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","యొప్పెతూ పేతురుతి ఆయుతే యూదుల విష్వాసుల్‍ పరీసుద్దాత్మను వరం అన్యుల్‍ఫర్‍బి ఆవాను దేఖీన్‍ కలవర పడ్యు. ");
INSERT INTO vgr_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","కిమ్కతో యూవ్నే అన్యబాషల్‍తి వాతె బోల్తుహుయిన్‍ దేవ్‍నా స్తూతికరను యూవ్నే ఖంజు. ");
INSERT INTO vgr_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","ఇనటేకె పేతురు అపిణింతర పరీసుద్దాత్మమ లీరాక్యుతే పానినా బాప్తిస్మమ్‍ నాలేనూ కరి కోన్‍బి ఆఢు బోల్సునా? కరి బోలీన్‍, ");
INSERT INTO vgr_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","యేసు క్రీస్తునూ నామ్‍తి ఆవ్నే బాప్తిస్మమ్‍ లేనూకరీ ఆజ్ఞా దిదొ. యో హాఃరు హుయిజావదిన్‍ పేతురునా యూవ్నే థోడధన్‍ హామరకేడేస్‍ ర్హకరీ బతిమాల్యు. ");
INSERT INTO vgr_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","యూదుల్‍ కాహెతె దేవ్‍ని వాతేనా హాఃజీన్‍ ఓప్పిలిదు కరి అపొస్తుల్‍బి, యూదయాను భైయే హాఃజ్యు. ");
INSERT INTO vgr_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","పేతురు యెరూషలేమ్‍మా ఆయో తెదె సున్నతి లీదుతే యూవ్నే వాదించి బోల్యు, ");
INSERT INTO vgr_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","“తూ సున్నతి కోయింతే అద్మీయేకనా జైన్‍ యూవ్నేతి ఖాణు కాధోకరీ ఇనేతి బోల్యా.” ");
INSERT INTO vgr_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","ఇనటేకె పేతురు జర్‍గ్యుతే హాఃరు అమ్‍ ఖూల్లా కరీన్‍ బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","మే యొప్పె హాఃయార్‍మా ప్రార్దన కరుకరుతో మన ఏక్ దర్షన్ ఆయు. యో ష్యాత్ కతో ఛార్‍ చేడో ధరైన్‍ ఉత్రుతే ఏక్ మోటు గోధిడీనూ జోణ్‍నూ ఏక్ థాళి ఆకాష్‍తూ ఉత్రీన్‍ మారకనా ఆయు. ");
INSERT INTO vgr_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","ఇనామ్హణీ మే ఠర్‍కీన్‍ ధేఖిన్‍ ఏన్‍కరమా జమీన్‍ఫర్‍ రవళు ఛార్‍ గోఢాను జీన్వార్‍, జమీన్‍ఫరాస్‍ హాఃవ్‍ళావళు కీఢా, జాఢనూ ‍హరేక్‍ జిన్వార్‍ ఉఢాతే జీన్వార్‍ మన దేఖాయు. ");
INSERT INTO vgr_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","తెదె పేతురునా “తూ వుటీన్‍ ఇనా మారీన్‍ ఖా” కరీన్‍ బోలిన్‍ ఏక్ ఆవాజ్‍ మారేతి బొలానూ మే హాఃమ్‍జ్యొ. ");
INSERT INTO vgr_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","పన్కీ మే నకో ప్రభు నిషిద్దంనూ, అపవిత్రంనూ హఃయుబి మే కెధేబి మోఢమా గ్హాలో కోయిని కరి బోలమా ");
INSERT INTO vgr_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","బెంమ్మనూ వోహాఃత్‍బి యో ఆవాజ్‍ ఆకాష్‍తూ దేవ్‍ మే పవీత్రం కర్యోతే ఇనా నిషిద్దంనూఅపవి కరి నకో ఎంచ్‍ కరి ఉత్తార్‍ ఆయు. ");
INSERT INTO vgr_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","ఇమ్మస్‍ తీన్‍ వొహఃత్‍ హుయు. ఇనబాద్‍మా యో హాఃరు ఫాఛు ఆకాష్‍మా పడైగయు. ");
INSERT INTO vgr_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","ఏగ్గిస్‍మ కైసరయాతూ మార కనా బోలిమొక్‍లాయుతే తిన్‍ అద్మి మే ఛౌతే ఘర్‍ కనా ఆయిన్‍ భిర్యు. ");
INSERT INTO vgr_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","తెదె ఆత్మ తూ కాయ్‍బి బేధం నాబోల్‍నూతిమ్‍ యూవ్నే కేడె జాకరీ మారేతి బోల్యొ. ఆ చో జణ భైయే మాకెడే ఆయా; హామే కొర్నేల్ను ఘర్మాగయా. ");
INSERT INTO vgr_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","తెదె యో దేవ్నుదూత యొప్పేమా అద్మీయేన్‍ బోలిమొక్లీన్‍ పేతురు కరి సీమోన్‍నఅ బులైమంగౌ. ");
INSERT INTO vgr_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","యో బోలాతే వాతె హఃరు తారు ఘర్‍ పరీవార్‍ హాఃరనా భచవ్‍స్యే. ");
INSERT INTO vgr_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","మే వాతె బొలాను సురు కర్యోతేదె పరిషుద్దాత్మ అప్నాఫర్‍ అగడీ కిమ్‍ ఆయుకీ ఇమ్మస్‍ యూవ్నాఫర్‍బి ఆయు. ");
INSERT INTO vgr_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","తెదె యోహాన్‍ పాణీనూ బాప్తిస్మమ్‍ దిదో పన్కి తుమె పవిత్రాత్మతి బాప్తిస్మమ్‍ లీస్యు కరి ప్రభు బోల్యొతే వాతె మే హాఃయాల్‍ కర్‍లిదొ. ");
INSERT INTO vgr_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","ఇనటేకె ప్రభు హూయోతే యేసు క్రీస్తుమా వీస్వాష్‍ ర్హఖతే అప్నా దేవాయ్‍రూతిమ్‍ దేవ్‍ యూవ్నాబి వరం దిరాఖఫర్‍ దేవ్‍నా ఆఢు బోలానా మే కోన్‍? ");
INSERT INTO vgr_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","యూవ్నే ఆ వాతె క్హంజీన్‍ అజు క్హయుబి ఆడు నాబోలిన్‍, ఇమ్‍హూస్యేతో దేవ్‍ యూదుల్‍కాహెతెనబి దిల్‍భద్‍లాలీన్‍ రక్చణ లేవాను దయకర్‍రాక్యోస్‍, కరి బోల్లేతుహుయిన్‍ దేవ్‍నా మహిమ కర్యు. ");
INSERT INTO vgr_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","స్తెఫన్‍నా విషంమ హుయుతే మీన్హాత్‍ నాటేకె భిగిడిగయుతే యూవ్నె యూదుల్‍నా తప్ప బుజు కినాబి వాక్యం నాబోల్‍నుతిమ్‍ ఫేనికే, కుప్ర, అంతియొకయమ చెద్రిగయు. ");
INSERT INTO vgr_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","పన్కి కుప్రియుల్‍ను థోడుజణు, కురేనియుల్‍మ థోడుజణుబి ఇవ్నమతు. అంతియొకయమ ఆయిన్‍ యూదుల్‍కాహెతె ఇవ్నేతి వాతె బోల్తుహుయిన్‍ ప్రభు యేసును సువార్తనా ప్రచార్‍ కర్తర్హయ. ");
INSERT INTO vgr_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","ప్రభును హాత్‍ షక్తి యూవ్నా కేడేస్‍ రయు ఇనటేకె విష్వాసించ్యుతే యూవ్నే హాఃరుస్‍ ప్రభుమ్హణీ ఫర్యు. ");
INSERT INTO vgr_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","యూవ్నా గూర్చీన్‍ ఖభార్‍ యెరూషలేమ్‍మా ఛాతే సంఘంమచాతే యూవ్నే హఃమ్జీన్‍ బర్నబానా అంతియొకయ బోలిమొక్‍ల్యా. ");
INSERT INTO vgr_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","యో ఆయిన్‍ దేవ్ను గణు ఆషిర్వధం దేఖీన్‍ సంతోష పడీన్‍ ప్రభుమా ఆనిలిన్‍ నిలకడ్‍తి ర్హవో కరి హాఃరవ్‍నా సిఫారత్‍ కర్యో. ");
INSERT INTO vgr_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","యో పరిషుద్ధాత్మతి, విష్వాసంతి భరైరోతే అషల్ అద్మీనితరా రవమా; కెత్రూకి జణు ప్రభుమఫర్యు. ");
INSERT INTO vgr_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","యో సౌలునా దేఖనహాఃజె తార్సునా గయో. ");
INSERT INTO vgr_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","ఇనా మాలంకరీన్‍ అంతియొకయానా బులాలీన్‍ ఆయో. ఇవ్నే మళిన్ ఏక్ వరఖ్‍ః అక్కు సంఘంమా ర్హైన్‍ కెత్రాకీ జణానా వాక్యం బోలిధిదా. ఫైలీవోహఃత్‍ అంతియొకయామా విస్వసియే క్రైస్థవులుకరీ బోలాయి గయా. ");
INSERT INTO vgr_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","యో ధన్నువ్‍మా థోడుజను ప్రవక్తల్‍ యెరూషలేమ్‍తూ అంతియొకయానా ఆయు. ");
INSERT INTO vgr_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","యూవ్నామా అగబు కరి ఏక్ జణో భిరిన్ ములక్‍ అక్కమా మోటు ఖాళ్‍ ఆవ్‍స్యే కరి ఆత్మతి భరైన్‍ బోల్యొ. యో క్లౌదియ రాజాను ధన్‍మ యో ఖాళ్‍ ఆయూ. ");
INSERT INTO vgr_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","తెదె సిష్యుల్‍మ హర్‍ఏక్‍ జణు ఇవును షక్తి ఏత్రె యూదయామ ఛాతే భైయ్యేవ్‍నా సహయం బోలిమొక్‍లానటేకె సోచిల్దు. ");
INSERT INTO vgr_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","యూవ్నే సోచాతిమ్‍ బర్నబా, సౌలునా హాతె బోలిమొకల్ను కరి రైగతే ఇనా యూదయమ ఛాతే షాణవ్‍కనా బోలిమొక్‍ల్యా. ");
INSERT INTO vgr_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","బరోభ్బర్‍ యోస్‍ ధన్నువ్‍మా రాజో హూయిరోతే హేరోద్‍ సంఘంనూ అద్మీయేమా థోడజణానా ధర్లీన్‍ హాఃతావాన సురు కర్యో. ");
INSERT INTO vgr_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","యెహాన్‍నో భై యాకోబ్‍నాబి తల్‍వార్‍తి ఖత్రాయినాఖ్యో. ");
INSERT INTO vgr_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","ఆమ్నూ యూదుల్‍నా ఇష్టంనూ కామ్‍ కరీన్‍ మాలంకర్లీన్‍, పేతురునబి ధర్లీదు. ఖాటుకోయిన్తే రోటోను పండుగను ధన్. ");
INSERT INTO vgr_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","ఇనా ధరీన్‍ ఠాణమా గలైన్‍, పస్కా పండగహువదిన్‍ ఇనబాద్‍మా జనాల్‍నా హాఃమె ఇనా ల్యావ్‍నూ కరీన్‍ ఇనా కావ్లీమారక్య చార్‍ గుంపునా చార్ సైనికుల్‍నా అప్పగించ్యో. ");
INSERT INTO vgr_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","పేతురు ఠాణమ గలైజవమ సంఘంను అద్మీయే హాఃరు ఇనహాఃజే గ్హణు ఆఖ్‍ఃతి దేవ్‍నా ప్రార్దన కర్తుర్హయు. ");
INSERT INTO vgr_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","హేరోద్‍ ఇనా కాల్‍ విచారణ్‍ కరను ఛాలా కతో, యో బోల్యొతె అగాడీను రాతేస్‍ యో ఖంకల్‍తి భందైరీన్‍ బే సైనికుల్‍నా ఇచ్మా హూఃత్యోథో. బుజు కావాలి రవాళు ఠాణాను ధర్వాజుకనా కావల్‍ కాసిర్హయు. ");
INSERT INTO vgr_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","ఎగ్గీస్‍, హధేక్‍ ప్రభును దూత ఇనాకనా ఆయిభిరీజవమా, ఏజ్గా యో ఛాతే జోగో హాఃరు ఊజాళు హుయిగు; తెదె దూత పేతురునా భావఢాఫర్‍ ఠోకీన్ వుట్‍ కరి బోలిన్‍ ఇనా వుట్టాడమా జల్దీస్‍ ఖంకల్‍ ఇనాహాత్‍మతూ ఇనూయోస్‍ టుటిపడీగయు. ");
INSERT INTO vgr_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","తెదె దూత ఇనేతి తూ కంభార్‍నా భాందిలిన్‍, చప్లే పేర్లా కరి బోల్యొ, యో ఇమ్‍ కరాదీన్ ఇనబాద్‍మా దూత తార లుంగఢా ఉప్పర్ నాకిలిన్ మార కేడె ఆవ్‍ కరి ఇనెతి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","యో బాధర్‍ ఆయిన్‍ దూతనా కేడె జైన్‍, యో దూతతి జర్‍గ్యుతే హాఃరు హాఃఛి కాహే, యో హాఃరు ధర్షనమ్కరీ రైగో. ");
INSERT INTO vgr_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","ఆగాళ్ళు కావ్లీ వాళనా, బెంమ్మను కావ్లీవాళానా డాటిన్‍ హాఃయార్‍మ జావను లోఢను తలుపుకనా ఆయా తెదె ఇనుయోస్‍ యూవ్నా కడైగయు. యూవ్నే ఏజ్గాతు నిక్లీన్‍ ఏక్ గల్లీ డాటైదిన్‍ ఎగ్గీస్‍ దూత ఇనా మ్హేంధిన్‍ ఛలేగో. ");
INSERT INTO vgr_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","తెదె పేతురునా హాఃయాల్‍ ఆయిన్‍, ప్రభు ఇను దూతనా బోలిమొక్లిన్‍ హేరోద్‍నూ హాత్‍మతూ, యూదుల్‍నా జనాల్‍ కర్నూ కరి దేఖ్యూతే ఇనా హాఃరవ్‍మతూ మన చుఖైరాక్యొస్‍ కరి హాంకే మన హాఃఛిస్‍ కనా మాలంహుయు కరి రైగో. ");
INSERT INTO vgr_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","మార్కు కరి బోలాతె బుజేక్‍ నామ్‍ను యెహాన్‍ కరి ఇని ఆయా మరియనా గర్మఆయో. ఏజ్గా కెత్రూకి జణు మలీన్‍ ప్రార్దన కర్తుర్హయు. ");
INSERT INTO vgr_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","యో బాధర్‍తు భిరిన్ ధర్వాజునా ఠోఖామా యో కోన్‍కీ దేక్నుకరీ ఏక్ నాని కాంకరవాళి ఛోగిరి ఆయి. ");
INSERT INTO vgr_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","యో పేతురునూ వాత్‍ ఆవాజ్ హాఃణత్‍ ధరీన్‍, ఖుషీతి ధర్వాజు కాడీకోయింతిమ్‍ నాఖ్‍ఃతి జైన్‍ హాఃరవ్‍తి పేతురు ఆయిన్‍ బాధర్‍ హిభ్యిరోస్‍ కరి బోలి. ");
INSERT INTO vgr_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","ఇనటేకె యూవ్నే ఇనేతి తూ దివానిసీకి కరి బోల్యా, రైతోబి మే బోలితేస్‍ క్హాఛీ కరి ఘట్‍బోలామ యూవ్నే ఇను దూత కరి బోల్యా. ");
INSERT INTO vgr_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","పేతురు బుజున్‍బి ఇమ్మస్‍ ఠోక్‍తోర్హవమా యూవ్నే ధర్వాజు కాడీన్‍ ఇనా దేఖీన్‍ కలవర్‍ పడ్యు. ");
INSERT INTO vgr_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","యో యూవ్నేతి సోపోర్హవో కరి సైగ్‍ కరీన్‍ బోలిన్‍, ప్రభు ఇనా ఠాణామాతూ కిమ్‍ బులల్యాయోకి యూవ్నా బోలిన్‍, యాకోబ్‍నా భైయ్యేనా యో వాతె మాలంకరావో కరి బోలిన్‍ బుజేక్‍ జోగోమ ఛలేగో. ");
INSERT INTO vgr_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","వణు హూస్‍కరా పేతురు కేజ్గా ఛలేగో? కరి సైనికుల్‍మ హుయుతే గలిబిలి అత్రే ఏత్రే కాహే. ");
INSERT INTO vgr_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","హేరోద్‍ ఇనటేకె ఢూండ్యోతేదె నా దేఖావమా కావ్లీవాళానా పరీక్చించుచిన్‍, కావాళివాలనా మర్రాకిదేయో ఆజ్ఞా దిదో ఇనబాద్‍మా హేరోద్‍ యూదయమతు కైసరయమ జైన్‍ రైయో. ");
INSERT INTO vgr_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","తూరు సీదోన్ను హఃయర్‍యుల్‍నా ఫర్‍, సీదోనీయుల్‍నాఫర్‍ హేరోద్‍నా గ్హణు ఛంఢాల్‍ హూవమా, యూవ్నే హాఃరు మలిన్‍ రాజో కనా ఆయిన్‍ రాజోన దోస్తి బ్లాస్తునా యూవ్ను బాజు కర్లీన్‍, షాంతి హోణు కరి వేడిలీదు; ష్యానకతో రాజోనూ దేఖ్‍ఃతూ యూవ్నా దేఖ్‍ఃనా ఖవాను ఆనాజ్‍ ఆవాస్‍. ");
INSERT INTO vgr_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","ఆ నియమించ్యుతే ధన్‍మ హేరోద్‍ రాజవస్ర్తాల్‍ పేర్లీన్‍ సీంహాసన్‍ఫర్‍ బేసిన్‍ యూవ్నా ఖామె న్యాయ కర్యొ. ");
INSERT INTO vgr_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","జనాల్‍ హాఃరు ఆ దేవ్ను ఆవాజస్‍ పన్కి అద్మీను ఆవాజ్‍ కాహే కరి ఖైకార్‍ మేంద్యు. ");
INSERT INTO vgr_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","యో దేవ్‍నా మహిమ నా కరమా యత్రాస్‍మా ప్రభునూ దూత ఇనా ధాభామా కీఢా పఢీన్‍ జాన్‍ మ్హేంద్యు. ");
INSERT INTO vgr_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","దేవ్‍నూ వాక్యం హాఃరవ్‍మా ఫైలావ్‍తూ రయు. అధికమయ్యరు ");
INSERT INTO vgr_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","బర్నబాబి సౌల్‍ యూవ్ను పరిచర్య నేరవెరనా బాద్‍మా మార్కు కరి బుజేక్‍ నామ్‍ను యెహన్‍నా కేడె బులాలిన్‍ యెరూషలేమ్‍మతూ ఫాచు ఆయు. ");
INSERT INTO vgr_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","అంతియొకయమ ఛాతే సంఘంమ బర్నబా, కాళోరవాళో సుమాయేను, కురేనీయుడ్‍ను లూకియ, హేరోద్‍తి మలిన్‍ అధికారినితరా థోతె వ్యధోతే మనయేను, సౌల్‍ కరి ప్రవక్తల్‍బి, బోధకుల్‍ థూ. ");
INSERT INTO vgr_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","ఇవ్నా ప్రభునా సేవకర్తూహుయిన్‍ పస్తు కర్తూ ర్హావమా పరిసుద్దాత్మ మే బర్నబానా సౌల్‍నా బులాయోతే సేవనాటేకె ఇవ్నా మన ప్రత్యేకం కర్‍ కరి ఇవ్నేతి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","తెదె ఇవ్నే ఉపవాస్‍ రైన్ ప్రార్థనా కరీన్‍ ఇవ్నాఫర్‍ హాత్‍ మ్హేంధిన్‍ బోలిమొక్‍ల్యా. ");
INSERT INTO vgr_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","పరీసుద్దాత్మతి బోలిమొక్‍లాయ్‍ర్యూతే ఆవ్నే సెలూకయ హాఃయార్‍మా ఆయిన్‍ ఏజ్గాతూ జ్హాజ్‍ చఢీన్‍ కుప్రమా గయా. ");
INSERT INTO vgr_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","ఇవ్నే ఏజ్గాతు సలామిమా ఆయిన్‍ యూదుల్‍ను సభాస్థలంమ దేవ్‍ని వాక్యం ప్రచార్‍ కర్తర్హయ. యోహాన్, మార్కు ఇవ్నాకేడెతా. ");
INSERT INTO vgr_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","ఇవ్నే ద్విపాల్‍ హాఃరు పర్తూహుయిన్‍, పాపు కరి ఏక్ గామ్‍మా ఆయాతేదె గారిడి వాళోబి, జుటీ ప్రవక్త హుయిరోతే బర్‍యేసు కరి ఏక్ యూదుడ్‍నా దేఖ్యా. ");
INSERT INTO vgr_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","యో సెర్గిపౌల్‍ కరి ఏక్ అధిపతి కనా గణు హాఃగ్‍తి రయో. యో బర్నబానాబి, సౌల్‍నా బులైమంగైన్‍ దేవ్ను వాక్యం హాఃమ్‍జునూ కరి కోర్యొ. ");
INSERT INTO vgr_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","రైతోబి ఎలుమ యో అధిపతినా విష్వాసంతి దూర్‍ రాక్ను కరి కోషీస్‍ కరీన్ ఇవ్నా ఆడుపడ్యొ. ఎలుమ కతో గారిఢివాళో కరి. ");
INSERT INTO vgr_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","ఇనహాఃజే పౌల్‍ కరి బోలాతే సౌల్‍ పవిత్రాత్మతి భరైన్‍, ");
INSERT INTO vgr_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","ఇనామణీ టర్కిన్ ధేఖీన్‍ కెత్రూకి కపటం దురాలోచన్‍తి భరైరోతే సైతాన్‍నూ ఛియ్యో, నీతినా వైరీంతర ధేఖవాళా, తూ ప్రభును అసేల్‍ వాట్‍నా చేడగోట్టాను మేంధా కోయిన్నా? ");
INSERT INTO vgr_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","హధేక్‍ ప్రభు ఇను హాత్‍ తారఫర్‍ పాఢీరాక్యోస్‍; తూ థోడధన్‍ ఖాణోహుయిన్‍ ర్హైస్‍, సూర్యుడ్‍నా దేఖీస్‍ కోయిని కరి బోల్యొ. తెదె యత్రాస్‍మా, అంధారు ఇనాఫర్‍ ఆయిన్‍ ఢఫైజవమా, ఇను నజార్‍ ఛల్‍జైన్‍ ఫర్‍తోహుయిన్‍ కోన్బి మన హాత్‍ ధరీన్‍ ఛలావ్‍స్యేకీ కరి ఢూండ్‍తోర్హయో. ");
INSERT INTO vgr_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","ఎత్రమా యో అధిపతి జర్‍గ్యుతే ఇనా దేఖిన్‍ ప్రభు బోధనా హషం హుయిన్‍ విష్వాసించ్యో. ");
INSERT INTO vgr_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","ఇనాబాద్‍మా పౌల్‍బి ఇనాకేడె ర్హవళు ఝాజ్‍ చఢీన్‍ పాపుతూ నిక్లీన్‍ పంపులియామా ఛాతే పేర్గేనా ఆయు ఏజ్గా యోహాన్నా మార్క ఇవ్నా మ్హేంధిన్‍ యెరూషలేమ్‍నా పాఛు చలెగో ");
INSERT INTO vgr_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","తెదె ఇవ్నే పేర్గేతు నాకీన్‍ పిసిదియామా ఛాతే అంతియొకయనా ఆయిన్‍ ఆరామ్‍నూ ధన్‍మా యూదులనా సభామా జైన్‍ బెట్టా ");
INSERT INTO vgr_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","ధర్మషాస్ర్తంబి ప్రవక్తల్‍నూ లేఖనం ఫడదదీన్‍ ఇనబాద్మా న్యావ్‍నుజొగొనూ అధికారుల్‍ భైయ్యే జనాల్ తుమె కేయూబి బోల్నూ కరి హూస్యేతొ బోలో కరి కభార్‍ కర్యా ");
INSERT INTO vgr_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","తెదె పౌల్‍ హిభ్రీన్‍ హాత్‍తి సైగ్‍ కరీన్‍ అమ్‍ బోల్యొ ఇష్రాయేలీల్‍వాళా దేవ్‍తి‍‍ ఢరవాళా హాఃజో. ");
INSERT INTO vgr_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","ఇష్రాయేల్‍ ప్రజల్‍నూ దేవ్‍ అప్ను అప్నా పితరుల్‍నా ఏర్పచిలీన్‍ ఇవ్నే ఐగుప్తునూ దేఖ్‍ఃమా పరదేషిల్‍ హూయిన్‍ ర్హయ తెదె యో ప్రజల్‍నా ఉఫర్‍ పాఢీన్‍ ఇను అధ్బుతంనూ షక్తీతి ఇవ్నా ఎజ్గాతు బులాలిన్‍ ఆయో. ");
INSERT INTO vgr_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","బరోభర్‍ ఛాళీఖ్‍ః వరఖ్‍ఃతోడీ ఝాఢీయేవ్‍మా యూవ్ను చేష్టల్‍నా హాఃమాళ్యో. ");
INSERT INTO vgr_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","బుజు కనాన్‍ దేఖ్‍ఃమా హాఃత్‍ గోత్‍వాళానా నాషనం కరీన్‍ ఇవ్ను దేఖ్‍ఃనా ఆవ్నా వారసుల్నితర కర్యో. ");
INSERT INTO vgr_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","బరోభర్‍ ఛార్‍ఖోః ఆఢైఖ్‍ః వరఖ్‍ః ధర్యు ఇమ్‍ కరానా. ఇనబాద్‍మా సమూవేలు ప్రవక్త తోడీ యో యూవ్నా న్యాయాపతిల్‍నా దయకర్యో. ");
INSERT INTO vgr_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","ఇనబాద్‍మా యూవ్నే రాజో హూణు కరి కోరమా దేవ్‍ బెన్యామీన్ గోత్‍నూ కీషునూ ఛియ్యో సౌల్‍రాజొ ఛాళిఖ్‍ః వరఖ్‍ఃతోడి ఏల్యో. ");
INSERT INTO vgr_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","ఇనబాద్‍ ఇనా కణ్నాకీన్‍ దావీద్‍నా రాజోంతర కర్యో దావీద్‍ విషంమా దేవ్‍ ఇనూ మన్‍నూ వాత్‍ అమ్‍ బోల్యొ యెష్షయినో ఛియ్యో దావీద్‍ మారు ఇష్టనూసారంగా ఛాలావళో, మారు మే సోఛీ రాక్యోతే హాఃరు క్హాఛీ కర్సే కరి బోలిన్‍ సాక్చ్యం దిదో. ");
INSERT INTO vgr_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","దేవ్‍ వాగ్దన్‍ కర్యోతిమస్‍ ఇను సంతాన్‍మతూ ఇష్రాయేల్‍నాటేకే రక్చకుడ్‍ యేసునా ఫైధాకర్యొ. ");
INSERT INTO vgr_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","యెహాన్‍ ఇను కామ్‍ కరుథూరావ్వమా మే కోణ్ కరి తుమే రైజోంగ్రస్‍ తుమె ఎదురుదేకుకరతె యో మే కాహె, హదేక్‍ మార పీటే ఏక్జణో ఆవుంక్రస్‍, ఇను చప్లేనా ఛోడనబి మన ఎత్రే అర్హత కోయిని. ");
INSERT INTO vgr_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","ఇను ఆవానూ అగడీ యెహాన్‍ ఇష్రాయేలీల్‍ అద్మీయే హాఃరవ్‍నా దిల్‍ బద్‍లాయిలేవనూ గూర్చీ బాప్తిస్మమ్‍ ప్రచార్‍ కర్యో. ");
INSERT INTO vgr_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","భైయ్యే, అబ్రాహామ్‍నూ జాత్‍వాళా, దేవ్‍తి ఢరవాళా, ఆ రక్చణ వాక్యం అప్నా కనా మొక్లాయిరూస్‍. ");
INSERT INTO vgr_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","యెరూషలేమ్‍మా కాపరం ర్హవళాబి, ఇవ్ను అధికారుల్‍బి, హార్‍ ఆరామ్‍నూ ధన్నే ఫడావ్‍ంగ్రతే ప్రవక్తల్‍నూ వచన్‍నా ధ్యాన్‍ నాదీన్‍ ఇనా యేసునా మరణ్‍ షిక్చ నాఖీన్‍ యో వచన్‍నా హాఃఛి కర్యా. ");
INSERT INTO vgr_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","ఇనాహాఃమె మర్రాఖ ఏత్రే తప్పు నాధేఖాయుతోబి, ఇనా మర్రాక్ను కరి యూవ్నే పిలాతునా వేడిలిదా. ");
INSERT INTO vgr_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","ఇవ్నే ఇన గూర్చీ నిఖైర్యూతే హాఃరు క్హాఛీ హూవదిన్‍, ఇనా సిలువతూ ఉత్రాయిన్‍ సమాధిమా రాఖ్యా. ");
INSERT INTO vgr_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","రైతోబి దేవ్‍ ఇనా మర్యాహూయమతూ ఉఠాడ్యొ. ");
INSERT INTO vgr_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","యో గలిలయమతూ యెరూషలేమ్‍నా ఇనేతి కేడె మళిన్ ఆయుతే యూవ్నా కెత్రాకీ ధన్‍ దేఖాయో. ఇవ్నేస్‍ ఇస్రాయేల్నా సాక్చిహుయీన్‍ రయు. ");
INSERT INTO vgr_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","దేవ్‍ యేసునా ఉఠాడీన్, పితరుల్‍నా కర్యోతే వాగ్దన్‍ అప్నా లఢ్‍క్వా కనా క్హాఛీ కర్‍రాక్యోస్ కరి, హమేబి తుమ్నా ప్రచార్‍ కరూకరుయేస్‍, ");
INSERT INTO vgr_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","ఇమ్మస్‍ తూ మారో ఛియ్యో మే తూనా జణీరాక్యోస్‍ కరి బెంమ్మనూ కీర్తనమా నిఖైర్యుస్‍. ");
INSERT INTO vgr_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","బుజు అజు హాఃడ్నూనాతిమ్‍ ఇనా మర్యాహూయమతూ ఉఠాడనూబి, దావీద్‍నా దీదోతే పవిత్రమ్‍హుయుతే వరాల్‍ తూమ్నాబి దీస్‍, యో నమ్మకంనూస్‍ కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","ఇనహాఃజే అజేక్‍ కీర్తనమా తారు పరీసుద్దుడ్‍నా గోరాడమ హాఃఢదీస్‍కోయిని కరి బోలుకరాస్‍. ");
INSERT INTO vgr_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","దావీద్‍ దేవ్‍నూ సంకల్ప ప్రకార్‍ ఇనూ పీఢీనూ అద్మీయేనా సేవ కరీన్‍ హూఃయిజైన్, ఇనా పితరుల్‍ కనా చేర్చాయి జైన్‍ ఆంగ్తాన్‍ హాఃఢీగయో. ");
INSERT INTO vgr_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","పన్కి దేవ్‍ ఉఠాడ్యోతే ఇనా యో హాఃడదీదోకోయిని. ");
INSERT INTO vgr_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","ఇనహాఃజే భైయ్యే తూమ్నా ఆనేతిస్‍ పాప్‍ మాఫి హూంక్రస్‍ కరి ");
INSERT INTO vgr_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","తుమె మోషే ధర్మషాస్ర్తంమా క్హయు విషంమా నీతి మంతుడ్‍ కరి బోలావ్‍స్యుకి యో విషం హాఃరమా విష్వసించతె హార్‍ ఏక్ ఆనేతిస్‍ నితి మంతుడ్‍ కరి తీర్చబడ్‍స్యు కరి తూమ్‍నా మాలంహోణు. ");
INSERT INTO vgr_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","ప్రవక్తల్‍నూ గ్రంథంమా బోలాయుతిమ్‍ తుమారఫర్ నాఆవునుతిమ్‍ దేఖీలేవో; యో ష్యాత్ కతో ");
INSERT INTO vgr_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","హధేకో నక్లే కాడవాళా, హాషంహువో నషించ్వో, యో ధన్నువ్‍మా మే ఏక్ కార్యం కరీస్‍, ఇనా కోన్‍బీ బోల్యుతోబి తుమె జరాబి నమ్‍స్యు కోయిని. ");
INSERT INTO vgr_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","ఇవ్నే పౌల్ యూదుల సభమతు ఛల్‍జౌంగ్రతో ఆవాతే హంకేనూ ఆరామ్నూ ధన్నేబి హమారేతి బోల్‍జో కరి జనాల్‍ గోజ్‍లాడ్యు. ");
INSERT INTO vgr_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","యూ యూవ్నే వూటాదిన్‍ కెత్రూకి జణు యూదుల్‍బి, యూదమతంనూ ప్రవిష్టుల్‍ పౌలునా బర్నబానా కేడెగయా. అవ్నే యూవ్నేతి వాతె బోల్తూహూయిన్‍, దేవ్‍ని కృపమా నిలకడ్‍గా ర్హనూ కరి యూవ్నా ఉసీకర్యొ. ");
INSERT INTO vgr_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","బెంమ్మనూ ఆరామ్నూ ధన్నే యో హఃయార్‍నూ హాఃరూస్‍ దేవ్‍నూ వాక్యం హాఃమ్‍జ్ను కరి భరైన్‍ ఆయు. ");
INSERT INTO vgr_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","యూదుల్‍ జనాల్నూ గుంపుల్‍నా దేఖిన్‍, కుట్రతి భరైన్‍, దూషించతా దేతాహూయిన్‍, పౌలు బోలాతే వాతేనా ఆడే బోల్తా ర్హయా. ");
INSERT INTO vgr_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","తెదె పౌలుబి, బర్నబా హిమ్మత్‍తి అమ్‍ బోల్యా, దేవ్‍నూ వాక్యం ఆగడీ తూమ్నా బొలానూ కాయామస్‍ హుయితోబి తుమె ఇనా దకల్‍ నాఖీన్‍, తూమరు తూమేస్ నిత్యజీవంనూ పాత్రుల్‍ కాహేతిమ్‍ కర్‍లేంగ్రస్‍, ఇనహఃజే హామే అన్యుల్‍ కనా జౌంగ్రుయేస్‍ ");
INSERT INTO vgr_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","కిమ్కతో ప్రభు హమ్నా జమీన్‍నూ అంతంతోడి అన్యాజనుల్‍నా రక్చణగా బుజు ఊజాళుంతర ర్హాకరీ ఆజ్ఞదిదో. ");
INSERT INTO vgr_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","అన్యాజనుల్‍ యో వాతె హఃమ్‍జీన్‍ హూఃషీహూయిన్‍, దేవ్‍ని వాక్యంనా మహిమ కర్యు బుజు నిత్యజీవంనా నిర్ణయించ్యుతే యూవ్నే హఃరు నమ్మిలిదు. ");
INSERT INTO vgr_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","ప్రభునూ వాక్యం యో ప్రదేషాల్‍ హఃరూమా ఫైలాయు. ");
INSERT INTO vgr_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","కాని యూదుల్‍ భక్తిమా మర్యాదితి ర్హవాళి బాయిక్వాన, యో హఃయార్నూ ప్రముఖుల్నా, ఉషీ కరైన్‍ పౌలునా, బర్నబానా హఃతాయిన్‍ యూవ్నా ఇవ్నూ ప్రాంతంనా నాహఃడ్‍నాక్యు. ");
INSERT INTO vgr_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","అపోస్తుల్‍ యూవ్నూ గోఢాను ధుళ్‍నా యూవ్నా మ్హణీ జట్కీనాఖీదిన్‍ ఈకోనియానా ఆయా. ");
INSERT INTO vgr_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","కాని అంతియొకయలోని సిష్యుల్‍ హూఃషీతి, పవిత్రాత్మతీ భరైన్‍ ర్హయా. ");
INSERT INTO vgr_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","ఈకోనియామ హూయుతే ష్యాత్‍ కతో, యూవ్నే హఃరూ మలిన్‍, యూదుల్ను సమాజమందిరంమా జైన్‍ ఖూల్లా కరీన్‍ బోధించమా, హఃరుజణు యూదుల్‍బి, గ్రీసు యూదుల్ కాహెతె దేహ్‍ఃవాళుబి విస్వసించ్యు. ");
INSERT INTO vgr_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","హుయుతో దేవ్‍తి ఢరకోయినితే యూదుల్‍ అన్యాజనుల్‍నా ఉషి కరైన్‍ ఇవ్నా దిల్‍మా భైయ్యేఫర్‍ ధావోనా ఫైదాకర్యు. ");
INSERT INTO vgr_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","ఇనహఃజే యూవ్నే ప్రభునా అనిలీన్‍, హిమ్మత్‍తి వాతె బోల్తుహుయిన్‍ ఏజ్గా ఘణా ధన్‍ ర్హయా. ప్రభు యూవ్నా హాతె సూచక క్రియాల్నా అధ్బుతాల్నా కరనా తాఖాతి దిదో, ఆమ్‍నితర ఇను గూర్చీ సాబుత్‍ దేతొ ర్హయో. ");
INSERT INTO vgr_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","యో హఃయర్నూ ప్రజల్మా విభేధాల్‍ హూవమా థోడు జణు యూదుల్‍మ్హణి, థోడు జణు అపొస్తుల్‍ మ్హణి ర్హయూ. ");
INSERT INTO vgr_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","బుజు అన్యుల్‍బి, యూదుల్‍బి యూవ్నా అధికారుల్‍థీ మలిన్‍, అపోస్తుల్‍నా ఇజ్జాత్‍ కాడీన్, ఫత్రావ్‍తీ మారీన్‍ మర్రాక్నుకరీ దేఖ్యు. ");
INSERT INTO vgr_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","ఇవ్నే ఆ వాత్ మాలంకరీన్‍ లుకయమానూ హఃయార్‍మా లుస్త్రనా, దెర్బేనా అస్పీస్‍ ఛాతె ఇలాఖోవ్‍నా మిలైలిన్‍, ");
INSERT INTO vgr_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","ఏజ్గా సువార్త ప్రచార్‍కర్తోథొ. ");
INSERT INTO vgr_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","యో ఫైధావహ్‍ఃతూస్‍ ఛాలకోయింతే లంగ్డు హుయిన్‍ కంజోర్నూ గోఢాను ఏక్ జణు లుస్త్రామా థూ. ");
INSERT INTO vgr_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","తెదె పౌలు వాఇనా ఠర్కీన్‍ దేఖిన్‍, హూఃదోహువానా ఇనా విష్వాష్‍ ఛాకరీ మాలంకరీన్‍, ");
INSERT INTO vgr_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","తార గోఢా జమీన్‍ఫర్‍ మ్హేందీన్‍ హఃఢక్‍ వుభార్‍ కరి ఘట్‍ బోలమా యో కూథో హుయిన్‍ వుటీన్‍ చాలనిక్యో. ");
INSERT INTO vgr_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","జనాల్‍ హఃరు పౌలు కర్యోతె ఇనా దేఖిన్‍, దెవతల్‍ అద్మీయేనూరూప్‍మా ఆప్నాకనా వుత్రీఆయి ర్హాస్‍ కరి కైఖార్‍ మ్హేందిన్‍, ");
INSERT INTO vgr_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","బర్నబానా ద్యుపతి కరిబీ, పౌలు ముఖ్య ప్రసంగీ హుయిర్హవమా ఇనా హేర్మే కరీన్‍ నామ్‍ మ్హేంద్యా. ");
INSERT INTO vgr_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","హఃయర్నా హఃమే ఛాతే ద్యపతినూ పూజారీ ఢాండవ్‍నా పూల్‍నూ మాళవ్‍నా వాట్‍కనా లీన్‍ ఆయిన్‍, గల్లోవ్తి మలీన్‍, బలి దేనూ కరి థూ. ");
INSERT INTO vgr_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","అపొస్తుల్‍ హుయాతే బర్నబాబి, పౌలు ఆ వాత్‍ హఃమ్‍జీన్‍, యూవ్న లుంగఢా ఫళ్ళీన్‍ అద్మీయేను గల్లావ్‍మా పేషీన్‍, ");
INSERT INTO vgr_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","హాఃయాప్‍ వో తుమె హాఃరూ ష్యాన అమ్‍ కరుకరాస్‍? హామేబి తూమారిన్‍ జోణ్‍నస్‍ అద్మీయే. తుమె ఆ బేకార్నూ హాఃరూ మ్హేందీన్‍, ఆకాష్‍నా జమీన్‍నా ధర్యావ్‍, ఇనమానూ సమస్తంనా బణాయోతే జీవంనో దేవ్‍మ్హణీ పర్నూకరీ హామే తుమ్నా ఆ సువార్తనా ప్రచార్‍ కరూకరుయేస్‍. ");
INSERT INTO vgr_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","యో పాషళ్‍నూ కాలంమా సమస్త ప్రజల్‍నా ఇవ్నూ యూవ్నూ వాట్‍ఫర్‍ చాలాదిదో. ");
INSERT INTO vgr_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","హూయితోబి యో ఆకాష్‍థూ తూమ్నా వరహాఃత్‍నా, ఫల్‍ దేవానూ రుతుల్‍నా, దేతోహూయిన్‍, ఖాణు దేతోహుయిన్‍, హూఃషీథీ తూమారు దిల్‍నా భర్తూహూయిన్‍, అషల్ కరన హాఃజే ఇనా గూర్చి సాబుత్‍ కోయింతే కర్యాకోయిని కరి ఘట్‍ చిక్రీన్‍ బోల్యు. ");
INSERT INTO vgr_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","ఇవ్నే ఆం బోలిన్‍ ఇనా బలి దేనూనా తిమ్‍ అద్మీయేనా రూకావనూ ఘనూ కోషీష్‍ హూయు. ");
INSERT INTO vgr_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","పిసిదియమాఛాతె అంతియొకయతూ ధరీన్‍, ఈకోనియథూబి యూదుల్‍ ఆయిన్‍, అద్మీయే హాఃరవ్‍నా యూవ్నా మ్హణి కర్లీన్‍, పౌలునా ఫత్రావ్‍థీ మారీన్, తెదె యో మరిగయోకరీ ఇనా హాఃయార్‍నా భార్‍ లీయిన్‍ ఖేఛీన్‍ మ్హేంద్యూదు ఆ ");
INSERT INTO vgr_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","హుయుతో సిష్యుల్‍ ఇనా ఆష్పిష్‍ భరైజవమా యో వుటిన్‍ హాఃయార్‍మా జైన్‍ బుజా ధన్నే బర్నబాతి మలిన్‍ దెర్బేనా నిక్లీగయా. ");
INSERT INTO vgr_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","భర్నబా పౌలు హఃయార్‍మా సువార్త ప్రచార్‍ కరీన్‍, కెత్రాకీ జణానా సిష్యుల్‍నితర కరనూ బాద్‍మా, లుస్త్రనా, ఈకోనియానా, పిసిదియమా ఛాతె అంతియొకయనా ఫరీన్‍ ఆయా. ");
INSERT INTO vgr_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","సిష్యుల్‍నూ మన్‍నా ఘట్‍ కరీన్‍, విస్వాసంమా నిలకడ్‍గా ర్హనూ కరి, కెత్రూకి మిన్హత్‍నా హఃమాలీన్‍, అప్నె దేవ్‍నూ రాజ్యంమా జానుకరి యువ్నా ప్రోత్సహించొ. ");
INSERT INTO vgr_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","బుజు హర్‍ సంఘంమా యూవ్నా ష్యాణవ్‍నా ఏర్పరచిన్‍, ఉపాస్‍ ర్హైన్‍, ప్రార్ధన కరీన్‍ ఇవ్నే నమ్మిరాక్యతేవాలనా దేవ్నా అప్పగించ్యా. ");
INSERT INTO vgr_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","ఇనబాద్మా పిసిదియ దేహ్‍ఃమా జైన్‍, బుజు ఏజ్గాతూ నికీన్‍ పంపులియానా గయా. ");
INSERT INTO vgr_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","బుజు పేర్గేమా వాక్యం బోధించిన్‍, ఏజ్గతూ అత్తాలియనా గయా. ");
INSERT INTO vgr_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","బుజు ఎజ్గతు జ్హాజ్‍ ఛడీన్‍, ఇవ్నె ఖతం కర్యాతే కామ్‍నా టేకె దేవ్‍ను కృపనా దరాటిదిదో బడ్యాహుయాహుయిన్‍, అగాఢి బయల్దేరీ గయాతేస్‍ అంతియొకయన జోగోకనాస్‍ బుజు ఆయా. ");
INSERT INTO vgr_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","యూవ్నే ఆయిన్‍, సంఘంనా ఏక్ జోగో జోడ్‍ కరీన్‍, దేవ్‍ యూవ్నా కేడె ర్హైన్‍ కర్యోతే అక్కుబి, బుజు అన్యుల్‍ విష్వాసించనా టేకె యో వాట్‍ కిమ్‍ కాడ్యోకి యూవ్నా ఖూల్లా కరీన్‍ బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","యూవ్నే ఎజ్గాస్‍ ఎజ్గాను సిష్యుల్‍తీ గ్హణా ధన్‍ ర్హయా. ");
INSERT INTO vgr_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","థోడుజణు యూదయ థూ అంతియొకయనా ఆయిన్‍, యెజ్గ ఛాతె భైయ్యేవ్‍నా, “తుమె మోషేను మ్హేంద్యొతె ఆచారంను సున్నతినా లిదాతోస్‍ పన్కి తుమ్నా రక్చణ మల్సెకొయినికరి” ఇవ్నా బోధించ్యు. ");
INSERT INTO vgr_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","పౌలుబి, బర్నబా ఇవ్నేతి ఘణుమోటు వాదనల్‍ థంగొ తోడ్యా. ఆ విషయంనా బారెమా పౌలుబి, బర్నబా ఇవ్నమా బుజు థోడు అద్మి యెరూషలేమ్‍నా, అపొస్తుల్‍కనా, ష్యాణవ్‍కనా, జాణుకరి బోలిన్‍, భైయ్యే నిర్ణయించ్యా. ");
INSERT INTO vgr_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","ఇనహఃజె యూవ్నె సంఘంతి బోలిమొక్లాయతే ఆవ్నే, ఫేనికే, సమరయ దేహ్‍ఃమా కరి జాతాహుయిన్‍, యూదుల్‍కాహెతె బి దేవ్‍నా నమ్మిలిదు కరి బోలి భైయ్యేవ్‍నా హూఃషీ కరాయా. ");
INSERT INTO vgr_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","ఆవ్నే యెరూషలేమ్మా జౌస్‍కరా, సంఘం, అపొస్తుల్‍, ష్యాణా హఃరూ మలిన్‍, ఆవ్నా స్వాగత్‍ కర్యు. పౌలు, బర్నబాతి దేవ్‍ కరాయోతే కామ్‍నా గూర్చి యూవ్నా బోల్యా. ");
INSERT INTO vgr_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","పరిసయ్యుల్‍నూ థోడుజణు భక్తివవళా వుటిన్‍, “యూదుల్‍కాహెతెవాల ఖచ్చితంగా సున్నతి కర్లేనూ. అజు మోషే ధర్మషాస్ర్తంనా పాటించ్ను” కరి బోల్యు. ");
INSERT INTO vgr_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","తెదె అపొస్తుల్‍బి, పెద్దల్‍బి ఆ వాతె హఃజే సోచనాటేకె హఃరు మలిన్‍ ఆయు. ");
INSERT INTO vgr_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","పాసల్తీ ఘణు వాదించిన్‍ హుయిజావదిన్‍ పేతురు వుటిన్‍ యూవ్నేతి ఆం బోల్యొ. భైయ్యే ఆగాఢిమా యూదుల్‍కాహెతె ఇవ్నే మారు వాక్యం హఃజీన్‍ భరోసా కరతిమ్‍ తుమార మాతు దేవాస్‍ మన ఎన్నిలిదో కరి తూమ్నా మాలం. ");
INSERT INTO vgr_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","బుజు దిల్‍నా మాలంకర్‍ రాక్యోతే దేవ్‍ అప్నా దిరాక్యోతిమస్‍, యూవ్నాబి పరిషుద్ధాత్మ ప్రాప్త్ కరీన్‍ యూవ్నా గూర్చి సాక్చ్యం దిదొ. ");
INSERT INTO vgr_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","ఇవ్ను దిల్‍నా విష్వాసంనా పవిత్ర కరీన్‍ అప్నాబి, అవ్నాబి హఃయూ బేధంబి దేఖాడుకోయిని. ");
INSERT INTO vgr_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","ఇనటేకె అప్ను పితరుల్‍ ర్హవో, అప్నే ర్హవో హఃమాళకోయింతే భోజోనూ కాడీనా సిష్యుల్‍నూ గలేంఢాఫర్‍ మ్హేందిన్‍ తూమే‌ ష్యాన దేవ్‍నా హఃతావ్‍ంకరాస్‍. ");
INSERT INTO vgr_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","ప్రభు హూయోతే యేసునూ కృపతి అప్నా రక్చణ పోంద్‍స్యు కరి భరోసా కరుకరాస్‍ కాహేనా? ఇమ్మస్‍ యూవ్నేబి రక్చణా పోంద్‍స్యే కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","యత్రమా యో జనాల్‍నూ గల్లో హఃరు షోపొ హూయిన్‍ బర్నబాబి, పౌల్‍ ఇవ్నేతి, దేవ్‍ యూదుల్‍కాహెతె హాఃనద్ను క్రియాల్నా, అధ్బుతాల్నా వివరించమా ధ్యాన్‍ దీన్‍ హఃమ్‍జ్యా. ");
INSERT INTO vgr_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","ఇవ్నే బొలాను హుయిజవాను బాద్మా యాకోబ్‍ అమ్‍ బోల్యొ, భైయ్యే మారు వాత్‍ హఃమ్‍జో ");
INSERT INTO vgr_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","యూదుల్‍ కాహేతే ఇవ్నే దేవ్‍ ఇను నామ్‍నా టేకె ఏక్ జనంనా ఎర్పరచనా టేకె యూవ్నా కిమ్‍ ఆగఢి కటాక్చించోకీ సుమాయోను వివరించిన్‍ బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","అనహఃజే ప్రవక్తల్‍ను వాక్యల్‍ సరిహుయిరూస్ కిమ్‍కతో ");
INSERT INTO vgr_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","ఇనబాద్‍మా మే పాఛు ఆయిస్‍; పడీగయూతే దావీద్‍ను డేరనా పాఛు భాందిస్‍, ఇను పడిగూతె డేరనా ఇన భాందిన్‍ భిరాకాడీస్‍ కరి అగాఢిమతూ ఆ వాతె మాలం కరాయోతే. ");
INSERT INTO vgr_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","అద్మీయేమా ఆఖరినూ అద్మీయేనాబి మారు నామ్‍ కినా మేందైర్హాస్‍కీ యో సమస్తంనూ యూదుల్‍కాహెతె ప్రభువునా ఢూండ్నూతిమ్‍. ");
INSERT INTO vgr_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","ప్రభు ఆం బోల్యొ కరి లిఖైర్యుస్‍. అగాఢిస్‍ ప్రభువు మాలంకరాయో. ");
INSERT INTO vgr_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","ఇనహఃజే యూదుల్‍కాహె ఇవ్నామతూ దేవ్‍ మ్హణి ఫరుకరతే యూవ్నా అప్నె మ్హీనత్‍మా నాఘాల్నూతిమ్‍, ");
INSERT INTO vgr_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","పన్కీ, మూర్తీయేనూ సంబంధంనూ అపవిత్రనా, హాఃవను నేటో దాబిన్‍ మారవాళీయేనా, ల్హొయినా, ఫేకి దేవానాటేకె ఏక్ పత్రిక లిఖ్కిన్ బోలిమొకల్నుకరీ మారీ హూఃజ్‍. ");
INSERT INTO vgr_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","కిమ్కతో సమాజమందిరంమా హర్యేక్‍ ఆరామ్ను ధన్నే మోషేనూ లేఖనాల్‍నా ఫఢ్తారైన్‍ ఆగఢినూ జమానమతూ ఇను నియామ్‍నా ప్రచార్‍ కరవాళు హర్‍ హఃయార్‍మా ఛాకరీ బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","తెదె భైయ్యే హఃరమా ముఖ్యంనో బర్సబ్బాకరీ బుజేక్‍ నామ్నో యూదా సీలనా ఇవ్నమా యెంచిలీన్‍, పౌలుతి, బర్నాతి అంతియొకయానా బోలిమొకలానూ అసేల్‍ కరి అపొస్తుల్‍నా ష్యాణవ్‍నా సంఘహఃరవానాబి సోచాయు. ");
INSERT INTO vgr_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","అవ్నే లిఖ్కిన్‍ యూవ్నా హాతె బోలిమోక్లుతే ష్యాత్‍ కతో అపోస్తుల్నా, ష్యాణాబీ భైయ్యేహుయాతె హమె అంతియొకయా, సిరియామాబి, కిలికీయామాబి జింకరతె యూదుల్‍కాహెతెతిమ్‍ విష్వాసుల్నాహుయాతె భైయ్యెవ్‍నా వందనములు కరి బోలిల్‍ లిఖ్కుకరతె, ");
INSERT INTO vgr_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","థోడుజణు హమారకంతూ జైన్‍ ఇవ్ను బోధతీ తూమ్నా కలవరం కరీన్‍, తూమారు మన్నా దుఃఖవ్‍ంగ్రస్‍ కరి హఃమ్‍జ్యా. ఇవ్నా హమే రూభాబ్‍ కోదిదాని. ");
INSERT INTO vgr_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","ఇనటేకె అద్మీయేనా ఏర్పరచిన్‍ అప్ను ప్రభు హుయోతే యేసు క్రీస్తు నామ్‍నా టేకె ఇను జాన్‍ ఇవ్నే అప్పగించిలిదాతే బర్నబా పౌల్‍నా తుమారకనా మొల్లుకరియేస్‍. ");
INSERT INTO vgr_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","అప్ను ప్రియుల్‍నా కేడె తూమారకనా బోలిమొకలాను అసేల్‍ కరి హమ్నా హఃరవ్‍నా ఏక్కాస్‍ హూఃజ్‍ ఆయు. ");
INSERT INTO vgr_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","హూయితోబి యూదానా సీలనా మొకల్‍రాక్యస్‍; యూవ్నేబి యువ్నా మోఢాతి ఆ సంగతుల్‍నా తుమ్నా మాలంకరవ్‍స్యే. ");
INSERT INTO vgr_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","మూర్తేవ్‍నా ఆర్పించ్యుతే ఇనా, ల్హోయీనా, న్హేటో దాబిన్‍ మర్రాక్యుతే ఇనా జారత్వంనా ఫేకి నాక్ను. ");
INSERT INTO vgr_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","జరూరత్‍నూ థీబి ఘాణుహూయుతే కేవు భోజోనాబి తూమారఫర్‍ నా మ్హేన్‍నూ కరి పరీసుద్దాత్మనబి, హమ్‍నాబి సోఛాయు. అనేతి దూర్‍ ర్హవనాహాఃజే జత్తన్‍థీ ర్హయాతో యో తుమ్నా మేల్‍. తుమ్నా అచ్చు హోణు. ");
INSERT INTO vgr_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","తెదే యూవ్నే వార్త లీజావాలు జీయ్యేస్‍ కరి బోల్లీన్‍, అంతియొకయనా ఆయిన్‍, విష్యాల్‍నా ఏక్ జోగొ జామకరీన్‍ యో పత్రికల్‍నా దిదూ. ");
INSERT INTO vgr_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","యూవ్నే ఇన పఢీన్‍ ఇనేతి ఆదరణ పోందిన్‍ హూఃషీ హూయు. ");
INSERT INTO vgr_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","బుజు యూదాబి, సీలబి ప్రవక్తల్‍ హూయిర్హయా, అనటేకే ఘాణు వోహాఃత్‍ వాత్‍ బోల్తుహుయిన్‍ భైయే ఆదరించిన్‍, బలపర్చు. ");
INSERT INTO vgr_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","యూవ్నే థోడుధన్‍ రాహిన్‍, భైయ్యేవ్‍ కంతు యూవ్నా బోలీమొక్లుతే ");
INSERT INTO vgr_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","యూవ్నా కనా జవానటేకె సమాధానంతీ సెలవుమాంగిల్దా. ");
INSERT INTO vgr_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","పన్కి పౌలుబి బర్నబా అంతియొకయమా థోడధన్‍ ర్హైన్‍, అజు కెత్రాకీ జణాథీ ప్రభునూ వాక్యం బోధిస్తాహుయిన్‍, ప్రచార్‍ కర్యా. ");
INSERT INTO vgr_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","థోడు ధన్‍నా బాద్మా ఇవ్నే కెవు కెవూ హాఃయార్‍మా ప్రభునూ వాక్యం ప్రచార్‍ కర్యాకీ, యో హాఃయార్‍మాను భైయ్యే కన ఫాచు జైన్‍ యూవ్నే కిమ్‍ ఛాకిస అప్నె దేఖియేకరి పౌల్‍ బర్నబాతి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","తెదె మార్కు కరి బోలాతే యోహాన్‍నా కేడె లీన్‍ జానూ కరి బర్నబా ఇష్టపడ్యో. ");
INSERT INTO vgr_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","కాని పౌలు, పంపులియమా కామ్‍నా హాఃజే హమారకేడె నా ఆవ్నూతిమ్‍ అప్నా మ్హేంద్యుదూతే ఇనా కేడె బులాలీన్‍ జవానూ అషల్ కాహెకరి సోచ్యొ. ");
INSERT INTO vgr_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","యూవ్నామా ఘణు లఢాయినూ వాదనల్‍ హూవమా, యూవ్నే ఏక్నాయేక్ మ్హేందిన్‍ అలాదు హూయిగా. తెదె బర్నబా మార్కునా కేడెలీన్‍ కుప్రనా గయో. ");
INSERT INTO vgr_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","పౌలు సీలనా ఏర్పరచిలిన్‍ భైయ్యేవ్‍తీ ప్రభునూ కృపమ అప్పగింపబడిన్ బయల్దెర్యా. ");
INSERT INTO vgr_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","సంఘాల్‍నా స్ధీరం కర్తాహూయిన్, సిరియా కిలికీయా దేహ్‍ఃథీ బలపర్తూ ర్హయూ. ");
INSERT INTO vgr_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","పౌలు దెర్బేకు నాబి, లుస్త్రనా ఆయా. ఎజ్గా తిమోతి కరి సిష్యుడ్ తో. యో దేవ్నా విస్వాసమ్ కరోతే ఏక్ యూదురాల్‍ని ఛియ్యో, ఇనో భా గ్రీసు దేహాఃమనో. ");
INSERT INTO vgr_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","యో లుస్త్రమా, ఈకోనియామా ఛాతే భైయేతిబి అచ్చు నామ్‍ కమైలిదో హూయో. ");
INSERT INTO vgr_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","యో ఇనకేడె ఆవ్నూ కరి పౌలు కోరీన్‍ ఇనో భా గ్రీసు దేహ్‍ఃనో కరి హఃరవ్‍నా మాలం. ఇనటేకె ఇవ్నా టేకెతిస్‍ ఇనా సున్నతి కరాయో. ");
INSERT INTO vgr_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","ఇవ్నే యో హాఃయార్మా కరి జాతూహుయిన్‍ యెరూషలేమ్‍ ఛాతే అపొస్తుల్‍ నాబి, ష్యాణ ఆద్మీయేనా నిర్ణయం కర్యుతే వాతేనా పాటించనాటేకె ఇనా ఇవ్నా అప్పగించ్యో. ");
INSERT INTO vgr_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","ఇనహాఃజే సంఘాల్‍ విష్వాసంమా ఘట్ ర్హైన్‍, హర్‍ ధన్‍నూ లెక్కతి జాహఃత్‍ ఫైలావుతూ ర్హయూ. ");
INSERT INTO vgr_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","ఆసియామా వాక్యం నాబోల్‍నూ కరి పరిషుద్ధాత్మ యూవ్నా ఆటంకం కరమా, యూవ్నే ప్రుగీయ గలతీయనూ ప్రదేషాల్‍ మాతూ గయా, ");
INSERT INTO vgr_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","తెదె ముసియాను కందే ఆయిన్‍, బితునియన జవాన కోసిష్‍ కర్యా గానీ, యేసునూ ఆత్మ ఇవ్నా జవాదిదూ కోయిని. ");
INSERT INTO vgr_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","యత్రమా యూవ్నే ముసియాన దాటీన్‍ త్రోయానా ఆయా. ");
INSERT INTO vgr_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","తెదె మాసిదోనియా దేహ్‍ఃవాళో ఏక్‍జణో హీబ్రీన్‍, తూ “మాసిదోనియామా ఆయిన్‍ హమ్నా మదత్‍ కర్‍” కరి గోజాడంతర పౌలునా యోరాతే దర్సణం ఆయు. ");
INSERT INTO vgr_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","ఇనా యో ఖోఃణ్యు ఆయు తెదె యూవ్నా సువార్తనా ప్రచార్‍ కరనా హఃజేస్‍ దేవ్‍ హమ్‍నా బులాయ్‍ రాక్యోస్‍ కరి హమే నిర్ణయించిన్‍, యగ్గిస్‍మా మాసిదోనియామా జవనా కోషిష్‍ కర్యా. ");
INSERT INTO vgr_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","ఇనహఃజే హమే త్రోయనా మెందిన్‍, హామే ఝాజ్‍ ఛడీన్‍ హాఃఢక్‍ సమొత్రాకేక్‍నా, బుజేక్‍ ధన్నే నెయపొలికినా, ఆయా. ");
INSERT INTO vgr_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","ఏజ్గాతూ ఫిలిప్పినా ఆయా. మాసిదోనియా దేహ్‍ఃమా యో ప్రాంతంనా యో ముఖ్య హాఃయార్‍ బుజు రోమియుల్‍నా వషారే కరానూ జోగో హుయిరూస్‍, హమే తోడు ధన్‍ థా. ");
INSERT INTO vgr_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","ఆరామ్ను ధన్నే గవిని దాటిన్‍, నద్దినా కనారీనా ప్రార్థన హూసే కరి హమే ఎజ్గా ఆయిన్‍ బేసిన్‍, భరైన్‍ ఆయేతే బాయిక్వాతీ వాతె బోల్తార్హయా. ");
INSERT INTO vgr_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","తెదె లూదియా కరి దేవ్ను భక్తీవాళి ఏక్ బాయిక్వో హాఃజు కర్తీథీ. యో బైంగని రంగ్నూ లుంగ్డానా లేచావళి, తుయతైరనూ హాఃయార్‍ వాళి. ప్రభు ఇను దిల్‍నా ఛిమ్యో. ఇనటేకె యో పౌల్‍నూ వాతేనా మన్ రాఖీ. ");
INSERT INTO vgr_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","యోబి ఇను ఘర్‍నూ అద్మి బాప్తిస్మమ్‍ లిదాతేదె అమ్‍ బోలి “మే ప్రభుమా విష్వాసంతి ర్హవాళీ” కరి తుమే ఎంచ్యాతో మారు ఘర్మా ఆయిన్‍ రవోకరి బోలిన్‍ బ్రతిమాలి హమ్నా జవదిదూకొయిని. ");
INSERT INTO vgr_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","ఏక్ ధన్‍ హమే ప్రార్దన కరానటేకె జౌకరీయేతో సోది బొలమా చంద్నుఆత్మ దరాకిహుయి ఏక్ బానిస ఛోగ్రి హమార హాఃమ్ణె ఆయి. ఇనేతి ఇను మాలిక్‍ ఘాణు ఫైదో కమ్యికర్యో. ");
INSERT INTO vgr_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","యోబాయికొ పౌలునకేడె బుజు హమ్నాకేడె ఆయిన్‍, “ఆ అద్మియే సర్వోన్నతుడ్‍నూ దేవ్‍నూ దాసుల్‍” అవ్నే తుమ్నా రక్చణనూ వాట్‍నా ప్రచార్‍ కరవాళా హుయిర్హస్‍ కరి కైఖార్‍ మ్హేంది. ");
INSERT INTO vgr_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","యో బాక్యో ఇమ్‍ కెత్రాకీ ధన్‍ బోల్తిర్హయీ, ఇనహఃజే పౌలు కనికర పడీన్‍, ఇనా మ్హణి ఫరీన్‍ తూ ఆనా మ్హేందిన్‍ జా కరి “యేసు క్రీస్తునూ నామ్‍తి ఆజ్ఞా దేంక్రుస్‍” కరి యో చంద్నుఆత్మనా బోల్యొ; యో యగ్గిస్‍ మ్హేందిన్‍ ఛలీగు. ");
INSERT INTO vgr_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","తెదె ఇని మాలిక్‍ ఇవ్ను ఫైదో జసేకరీ ర్హాహిజయిన్‍, పౌలునా సీలనా ధర్లి జైన్‍ గామ్‍మా హాఃరనా హాఃమే మోట్టా కన కేచ్‍లిన్‍ గయూ. ");
INSERT INTO vgr_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","యత్రామా రోమా అధిపతికనా ఇవ్నా లీన్‍ ఆయిన్‍ ఇవ్నే యూదుల్‍ హుయిన్‍రైన్‍బి, ");
INSERT INTO vgr_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","రోమియుల్‍ హుయాతే అప్నే అంగికరించనబి, కరనాబి కోహువానితే ఆచారాల్నా ప్రచార్‍ కర్తాహుయిన్‍, హాఃయార్‍నా గలిబిలి కరూకరాస్‍ కరి బోల్యా. ");
INSERT INTO vgr_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","తెదె అద్మీయేనూ గల్లో ఇవ్నాఫర్‍ గుంపుంతర ఆయు, తెదె అధికారుల్‍ ఇవ్నా లుంగఢా కణ్నాకీన్‍ కొల్డాతి మార్ను కరి హూఖం దిదూ. ");
INSERT INTO vgr_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","ఇవ్నే ఘాణు మార్‍ మారీన్‍, ఠాణమా గలైన్‍, ఆవ్నా జత్తన్‍తీ ర్హాఖో కరి హూకం దిదూ. ");
INSERT INTO vgr_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","యో ఇవ్ను ఆజ్ఞా లీన్‍ యూవ్నా ఠాణమా గల్దీన్‍ ఇవ్నా గోఢానా కోడ్‍ష్యానూ ఖాఢవ్‍మా గాలీన్‍ భాంద్యు. ");
INSERT INTO vgr_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","ఆధీ రాత్‍మా పౌలుబి సీల ప్రార్థన కర్తుహుయిన్‍, దేవ్‍నూ గీద్‍ బోలుకరాతో ఖైదిల్‍ హఃజుకర్తుథూ. ");
INSERT INTO vgr_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","యత్రస్‍మా ఏక్ మోటు భూకంపం ఆయిన్‍, ఠాణాను పునాదుల్‍ హాలీగయు. యగ్గిస్‍మా ధర్వాజ హాఃరు నిక్లీగయు, ఆవ్నా భాంద్యూతే కట్లు ఛూటీగయు. ");
INSERT INTO vgr_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","ఠాణాను అధికారి హోషార్‍ హుయిన్‍, ఠాణానూ ధర్వాజ హాఃరా నిక్లిర్హవాను దేఖిన్‍, ఖైదిల్‍ హాఃరు నాషీగయు హూసే కరి ఇనూ యోస్‍ ఛారితి టోఛిలిన్ మరీ‍ జౌంగర్తో థో. ");
INSERT INTO vgr_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","పన్కిపౌలు తూ కేవు హని నకో కర్‍లా, హమే హాఃరా అజ్గాస్‍ ఛియ్యేకరి ఘట్‍న్తి చీక్రీన్‍ బొల్యా. ");
INSERT INTO vgr_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","తెదె యో అధికారి బుడ్డి మంగైన్‍, మై నాసిన్ ఆయిన్ ఢర్తోహుయిన్‍ పౌలు సీలనా గోఢఫర్‍ పడ్యో. ");
INSERT INTO vgr_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","ఇనబాద్మా ఇవ్నా భాధర్‍ బులలాయిన్‍, “హాఃయాబ్ మే రక్చణ లేనూ కతో ష్యాత్‍ కర్నూ?” కరి పుఛ్చాయో. ");
INSERT INTO vgr_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","ఇవ్నే తూ “యేసు ప్రభుమా విష్వాసం ర్హాకో, తెదె తూనా తారు ఘర్‍ పరీవార్‍నా రక్చణ ఆవ్‍స్యే” కరి ఉత్తార్‍ దిదా. ");
INSERT INTO vgr_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","ఇవ్నే ఇనబాద్మా ప్రభును వాక్యంనా ఇనా, ఇనూ పరీవార్‍నా బోలిదిదా. ");
INSERT INTO vgr_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","యో జైలు అధికారియే రాత్నూ వోహాఃత్‍నూ ఇవ్నా బులాలిజైన్‍ ఇవ్ను మార్నా ధోయా. తెదె యగ్గిస్‍మ యో ఇను ఘర్‍నూ హఃరూస్‍ బాప్తిస్మమ్‍ లిదా. ");
INSERT INTO vgr_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","ఇనబాద్మా యో ఇవ్నా ఇనూ ఘర్మా బులాలిన్‍ జైన్‍ ఖాణు ఖడయో, యో ఇను ఘర్నూ అద్మీయే దేవ్‍నా విష్వసిం కరను సురు కర్యా ఇనహాఃజే ఘణు ఖుషీ హూయా. ");
INSERT INTO vgr_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","వ్హాణు హూస్‍కరా రోమా అధికారుపతి ఇవ్నా మెంద్యవాన కరి బోలానా హాఃజే ఇవ్ను భటుల్నా బొలిమొకల్యొ. ");
INSERT INTO vgr_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","ఠాణానో న్యాయాదిపతి బోల్యోతే వాతేనా పౌలు సీలనా బోలిన్‍, తూమ్నా మ్హేందా కరి యో బోలిమొకల్యో. ఇనహఃజే తుమె హేంకే హూఃషీతీ సమాధానముతొ జవో కరి బోల్యా. ");
INSERT INTO vgr_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","హుయుతో పౌలు ఇవ్నే న్యాయం కర్నూస్‍నాతిమ్‍ రోమియుల్‍ హూయతే హమ్నా హఃరవ్‍నా హఃమే మార్‍ ఖడైన్‍, ఠానామా గలైన్‍, హంకే హమ్నా కినా మాలంకోయింతే మొకల్‍ దేంగ్రస్ ఇనటేకె హమే ఒప్పియే కొయిని ఇవ్నేస్‍ ఆయిన్‍ హమ్నా బాధర్‍ లీన్‍ జానూ కరి బోల్యా. ");
INSERT INTO vgr_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","యో భటుల్‍ యో వాతేనా న్యాయాధిపతుల్‍నా మాలం కరావమా, ఇవ్నే రోమియుల్‍ కరి హఃమ్‍జిన్‍ డరీజైన్‍, ఇవ్నా కనా ఆయిన్‍, ");
INSERT INTO vgr_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","అనటేకే ఇవ్నా మాపి మాంగీన్‍ ఠాణ బాధర్‍ లీన్‍ ఆయిన్‍ ఆ హాఃయార్నా భాహార్ జవో కరి బ్రతిమాల్యా. ");
INSERT INTO vgr_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","ఇవ్నే ఠాణమతూ బాధర్‍ ఆయిన్‍, లూదియానూ ఘర్‍కనా గయా; ఏజ్గాను భైయ్యేవ్‍నా దేఖిన్‍ ఆదరించిన్ ‍ఏజ్గాతూ ఛలేగా. ");
INSERT INTO vgr_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","పౌలుబి సీలల్‍బి అంఫిపొలిస్‍, అపోల్లోనియ, కరి హాఃయారేథీ ప్రయాణ్‍ కరీన్‍ థెస్సలొనిక కరి హాఃయార్‍మా ఆయా, ఏజ్గా యూదుల్‍ను సభ జోగో ఛా. ");
INSERT INTO vgr_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","అనటేకే పౌల్‍ ఇను క్రమంతీ యో యూదుల్నుసభ జోగొమా జైన్‍ ఇవ్నేతి తీన్ ఆరమ్ను ధన్‍ అమ్నితార వాదించో ర్హాయో, ");
INSERT INTO vgr_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","మే తుమ్నా ప్రచార్‍ కరుకరుతే యేసుస్‍ క్రీస్తు హుయిరోస్‍ కరి పవిత్ర లేఖనాల్‍ బోల్యుతిమ్‍ యో క్రీస్తు మీన్హాత్‍ పడిన్‍ మరణ్ మతు వుటిన్‍ కరి రుజువుయు, ");
INSERT INTO vgr_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","ఇవ్నామా థోడు జణు, భక్తివాళు గ్రీసు దేహ్ఃమా ఘణు అద్మీయే, ముఖ్యంని బాయిక్వాబి అజు దేవ్నా ఆరధాన కరిన్‍ ఒప్పిలిన్‍ పౌలు, సీలతి మళిగయే. ");
INSERT INTO vgr_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","హుయుతో యూదుల్‍ యోహాఃరు దేఖిన్‍, అసూయతి కామ్‍ధామ్‍ కోయింతే థోడు అద్మీయేనా బులైన్‍, హఃయార్‍మా రావ్‍డీ కరానూ సురు కర్యా, యాసోను ఘర్‍మా పడీన్‍ పౌలు, సీలనా ప్రజల్నా సభల్‍నా హాఃమెలీన్‍ ఆవానా హఃజే కోసిష్‍ కర్యా. ");
INSERT INTO vgr_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","హుయుతో ఇవ్నే నా దేఖావమా యాసోనూనా, థోడు భైయ్యేవ్‍నా యో హఃయార్‍నూ అధికారుల్‍ కనా ఖేచ్లిన్‍ జైన్‍, అవ్నే హర్యక్ జోగొబి ఆటకం కరవాల ఆ నంగర్మాబి ఆయిరూస్‍; ");
INSERT INTO vgr_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","యాసోనూ ఆవ్నా చేర్సాయి రాక్యోస్‍. ఆవ్నే హఃరూ యేసు కరి బుజేక్‍ రాజో ఛాకరీ బోలిన్‍, రోమ రాజో చట్టంనా విరోధంతీ చాలుకరాస్‍ కరి బోలిదా. ");
INSERT INTO vgr_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","యో వాతె హాఃజ్యుతే అధికారుల్‍బి, ప్రజల్‍ గళ్లొ కలవర్‍ కర్యు. ");
INSERT INTO vgr_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","ఇనబాద్‍మా యాసోనుతి, ఇనా కనా ఛాతే ఇవ్నా కనాతూ తోడు పైసా లీన్ ఇవ్నా మ్హేందిదూ. ");
INSERT INTO vgr_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","తెదె ఎగ్గిస్‍ భైయ్యే రాత్నుటేపార్‍ పౌలునా సీలనా బెరయ కరి హఃయార్‍నా మొకల్‍దిదూ. బెరయానా ఆయాతే ఇవ్నే యూదుల్‍ను సభ జోగొ గయా. ");
INSERT INTO vgr_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","బెరయనూ ప్రజల్‍‌ థెస్సలోనికనూ అద్మియేతిబి ఘణు ఇమాన్‍దార్‍నూ అద్మియే ఇనహఃజే యూవ్నే లేఖనంమా ధ్యాన్‍తి హఃమ్జవాళు, బుజు హర్‍ ధన్‍ యూవ్నే బోలాతే వాతె హఃరు ఇమ్మస్‍ ఛాకీ కోయినికి పరీక్చించీన్‍ కర్త ఆయు ");
INSERT INTO vgr_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","ఇనాటెకే ఇవ్నా మాబి కేత్రుకి విష్వాసుల్‍ హూయా గ్రీకునూ బాయిక్వా మరధ్‍మనా హాఃరాబి విష్వసుల్‍ విస్వస్ కర్యు ");
INSERT INTO vgr_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","హుయుతే బెరయమాబి పౌలు సీల దేవ్‍ని వాక్యం ప్రచార్‍ కరుకరాస్‍ కరి థెస్సలోనికమా రావాళు యూదుల్‍ మాలంకర్లీన్‍ ఏజ్గా ఆయిన్‍ ప్రజల్‍నా హూసీ కరిన్ కలవర్‍ కర్యు ");
INSERT INTO vgr_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","ఎగ్గిస్‍మా యో విష్వాసి పౌలునా ధర్యావ్‍ను ప్రాతంమా జాకరీ బోలిన్‍ మొకల్యా కానీ సీలబి తిమోతి ఎజ్గాస్‍ రైగా. ");
INSERT INTO vgr_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","పౌలునా బోలిమొక్‍లాన గయాతే ఇవ్నే ఏథెన్సునూ యార్‍తోడి కేడె గయా, ఇనబాద్మా పౌలు ఇవ్నేతి సీలనాబి, తిమోతినా హూవ ఏత్రె ఎగ్గిమా ఆవో కరి బోలో కరి బోలిన్‍ ఇవ్నా బోలిమొక్‍ల్యో, తెదె ఇవ్నే యో ఖభార్‍ లీన్‍ ఫాచు బెరయనా గయా. ");
INSERT INTO vgr_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","పౌలు ఏథెన్సుమా సీల తిమోతి హాఃజే ఏదుర్‍ దేక్తోహుయిన్‍ రైగో, ఏజ్గా ఇను యో హాఃయార్‍ అక్కు మూర్తేవ్‍తీ భరైర్హవనూ దేఖిన్‍, ఇనూ దిల్మా ఘణు దుఃఖ పడ్యు. ");
INSERT INTO vgr_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","ఇనహఃజే యో సమాజ మందిరంమా ఆవాతే యూదుల్‍థీ, భక్తివాళాథి హర్యేక్‍ధన్‍ గల్లీయేమా, ఇనేతి మళాతే హర్యేక్‍తి యో వాతె బోల్తోథో. ");
INSERT INTO vgr_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","ఎపికూరీయుల్‍మనూ, స్తోయికుల్‍మనూ థోడు జ్ఞానుల్‍ ఇనేతి వాదించ్యా. ఆ మధంభరో ష్యాత్‍ బోలుకరాస్‍కీ కరి థోడు జణు బోల్యా. థోడు జణు యేసు ప్రభునూ గూర్చి బోలుకరాస్‍ కరి, బుజు థొడు జణు ఆ అలాదుదేవ్ను గూర్చి బోలుకరాస్‍ కరి బోల్లీదు. ");
INSERT INTO vgr_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","ఎత్రమా ఇవ్నే ఇనా అరేయొపగు కరి సభ కనా లీన్‍ జైన్‍, తూ కరుకరాతే ఆ కేవు నవు బోధకీ హమే మాలం కరాజైనా? ");
INSERT INTO vgr_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","థోడు అర్థంహువకొయితే వాతె హమ్నా హఃమ్జాక్రస్‍ ఇనూ మతలబ్‍ బోల్‍ కరి థోడు జణు పుఛాయు. ");
INSERT INTO vgr_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","ఏతెన్సునూ హాఃరుబి, ఏజ్గా ర్హవాళు అజు పరదేసియే వాళు నవూ వాతె బోలామబి, హాఃజామబి ఇవ్ను ధన్‍ అక్కు ర్హాయు. ");
INSERT INTO vgr_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","పౌలు అరేయొపగు సభమా హుబ్రీన్‍ ష్యాత్‍ బోల్యొ కతో ఏతెన్సువాళా తుమే హఃరూ హర్యేక్‍మా ఘణు దేవ్నూ భక్తివాళంతర దేఖౌంగ్రస్‍. ");
INSERT INTO vgr_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","మే హాఃయర్‍ పర్తోహుయిన్‍ తూమరు దేవతల్‍నా, మూర్తేవ్‍నా దేఖూకరుతో ఏక్ బలిపీటం మన దేఖాయు. ఇనాఫర్‍ మాలం కోయింతే దేవ్నా కరి లిఖైరూస్‍. ఇనటెకే తుమే మాలం కోయింతే క్హయు దేవ్నా హఃలామ్‍ కరుకరాస్‍కీ ఇనాస్‍ గూర్చి మే ప్రచార్‍ కరుకరూస్‍. ");
INSERT INTO vgr_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","ఆ జగత్‍నా, ఇనుమనూ సమస్తంనా బణాయోతే దేవ్‍ యోస్‍. ఆబ్‍నా జమీన్‍ యోస్‍ ప్రభు హుయిర్హఫర్‍ అద్మీయే భాంద్యుహుయు ఆలయంమా యో ర్హాసేకోయిని. ");
INSERT INTO vgr_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","యో హాఃరవ్నా జీవ్డొనా, ధమ్‍నా సమస్తంనా దేవవాళో, ఇనహఃజే “ఇనా క్హయుబి కమ్‍ ఛాతిమ్‍ కరి అద్మీయేనా హతేఖుః కరలీలేవళో కాహే.” ");
INSERT INTO vgr_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","యో ఏక్ అద్మీథీ హర్యేక్‍ జాత్‍వాళానా కరీన్‍, ఇవ్నే హఃరు జగత్ ఆక్కామా జీవా హఃర్‍ఖు కరీన్‍, ఇనా ఢూండనా హఃజే నిర్ణయించ్యుతే కాలంనా, ఇవ్ను జీవానూ జమీన్‍ పోలిమెరల్నా కర్యో. ");
INSERT INTO vgr_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","ఇవ్నే ఏక్ వోహాఃత్‍ దేవ్నా డుండిన్ మాలంకర్షే కరి, యో అప్నమతూ కినాబి దూర్‍ ర్హవాళో కాహే. ");
INSERT INTO vgr_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","అప్నె ఇనమా జీవుంగరీయేస్‍, ఇనామా ఛీయ్య, ఇమ్మస్‍ అప్నే ఇనూ సంతాన్‍ కరి తూమారు తోడు కవులు బోలుకరాస్‍. ");
INSERT INTO vgr_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","ఇనహఃజే అప్నే దేవ్నా సంతాన్‍ హూయిరైన్‍, అద్మీయేనూ అక్కల్ బణాయుతే ఘేణవ్‍నా, రూపునా, బండనా దేవ్‍నితర ఛాకరీ హుఃజ్‍నాకర్ను. ");
INSERT INTO vgr_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","యో బుధ్దునూ కాలమ్‍నా దేవ్‍ దేఖిన్‍బి నాదేఖాతిమ్‍ ర్హయో హంకే హుయుతో హార్యేక్‍జణు దిల్‍భద్‍లాయిన్ ఫార్ను కరి ఆజ్ఞాదిదో. ");
INSERT INTO vgr_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","ష్యానకతో యో నియమించ్యోతే అద్మీతి నీతినా అనుసరించిన్‍, జగత్‍మా ఛాతే హాఃర్నా న్యావ్‍ దేవానూ ఏక్ ధన్‍నా నిర్ణయించి రాక్యోస్‍; మర్యా హుయాతే యో ఫారిని వుఠాడమా ఇనా నమ్మానాటెకె హాఃరవ్నా భాల్ నా దీరాక్యోస్‍. ");
INSERT INTO vgr_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","మర్యా హుయామతూ జీవిన్‍ వుట్యోతే టేకె, యూవ్నే హాఃజ్యా తెదె థోడు జణు నాక్లే కాడ్యా; బుజు థోడు జణు తూ బోలాతే వాత్‍ బుజేక్‍ ఛోట్‍ హాఃజీయేస్‍ కరి బోల్యా. ");
INSERT INTO vgr_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","ఇమ్‍ ర్హవమా పౌలు ఏజ్గాతూ నాకీన్‍ ఛలేగో. ");
INSERT INTO vgr_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","కాని థోడు జణు ఇనా కన్నెకరిన్‍ విష్వసించ్యు. యూవ్నామా అరేయొపగితుడ్‍నూ దియొనూషియు ఏక్ జణోబీ, దమరి కరి ఏక్ బాయిక్వోబి, బుజు థోడు జణు అవ్నా కేడె థూ. ");
INSERT INTO vgr_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","ఇనబాద్మా పౌలు ఏథెన్సుథూ ధరీన్‍ కొరింథునా గయో. ");
INSERT INTO vgr_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","ఎజ్గా పోంతు జాత్ను అకుల కరి ఏక్ యూదుడ్‍ను ఇని బావణ్‍ ప్రిస్కిల్లానా మాలంకరీన్‍ యూవ్నా కనా గయో. యూదుల్‍ హాఃరు రోమ్‍నా మ్హేందీన్‍ ఛలుజానూ కరి క్లౌదియ రాజో ఆజ్ఞా దేవ్మా, అకుల ఇని బావణ్‍ ప్రిస్కిల్లాతీ మలిన్‍, ఇటలిథూ ఆ మద్యమస్‍ ఆవమా. ఇవ్నా దేఖానా పౌలు ఆయో. ");
INSERT INTO vgr_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","ఇవ్నే డేరా సీవాను ధందో. పౌలునుబి యోస్‍ ధందో కర్తోథో, ఇనటేకె ఇవ్నేతి మలిన్‍ ఏజ్గా కామ్‍ కర్తో ర్హయో. ");
INSERT INTO vgr_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","యో హర్యేక్‍ ఆరామ్ను ధన్నే సభ జోగొమా వాదిస్తోహుయిన్‍, యూదుల్‍నా, గ్రీసు దేహాః వాళానా ఓప్పావ్‍తోర్హయో. ");
INSERT INTO vgr_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","సీలబి, తిమోతి మాసిదోనియా మతూ ఆయిత్రా తెదె పౌలు సమయం అక్కు వాక్యం బోలస్‍మా ర్హయో, యేసుసుస్‍ క్రీస్తు కరి యూదుల్‍నా ఘట్‍ సాక్చ్యం దేతోర్హయో. ");
INSERT INTO vgr_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","ఇవ్నే ఫాచు ఫరీన్‍ దూషించమా, యో వుటీన్‍ ఇనూ లుంగఢా జట్కిలీన్ “తూమారు నాషనంనా తూమేస్‍ పాత్రుల్‍” మే నిర్దోషి, హంకేతూ మే అన్యుల్‍జనూల్‍ కనస్‍ జైస్‍ కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","యో ఏజ్గాతూ నాకీన్‍, తీతి యూస్తు కరి ఏక్ విష్వాసినా ఘేరే గయో. ఇనూ ఘర్‍ సభ జోగోనా సేడెష్‍ థూ. యో దేవ్నా ఆరధాన కరవాలో. ");
INSERT INTO vgr_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","యో న్యావ్‍నుజొగొనూ మాలిక్‍ క్రీస్పుకరీ ఇనూ ఘర్‍ హాఃరవ్‍తీ మలిన్‍ విష్వాసంగా ర్హయో. అజు కోరింథీయు వాత్‍ ఖంజీన్‍ వీష్వాసించినా కేత్రకి జాణు బాప్తిస్మం లీదు. ");
INSERT INTO vgr_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","ఏక్‍ రాత్నూ ప్రభు పౌల్‍తి దర్షనం అంమ్‍ బోల్యో “తూ ఢర్నునాతిమ్‍ వాతె బోల్‍, షోపొతి నకొ ర్హా, ");
INSERT INTO vgr_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","మే తార కేడేస్‍ ఛౌ. ఆ హఃయార్‍నూ హఃరూబి మారుస్‍ ప్రజల్‍, కోన్‍బి తున హాని కోకర్‍స్యేని కరి బోల్యొ.” ");
INSERT INTO vgr_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","తెదె యో యూవ్నా ఇఛ్మా బోదిస్తోహుయిన్‍, ఎక్ ఒరహ్ః చోమైనా ఏజ్గా ర్హయో. ");
INSERT INTO vgr_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","గల్లియోను కరి ఏక్‍జణో అకయ ప్రాంతంనా రోమను ఆధికారితార ర్హాయో తెదే, ఇనూ వోహాఃత్‍మా యూదుల్‍ అక్కు మలిన్‍, పౌలుపర్ పచు పరిగయూ, ఇనా న్యాయం కరను జోగొ లీన్‍ ఆయిన్‍, ");
INSERT INTO vgr_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","“ఆ అప్ను షాస్ర్తంనా విరుద్దంతి దేవ్నా హఃలామ్‍ కరో కరి ప్రజల్‍నా హుషి కరుకరాస్‍” కరి ఇనాఫర్‍ ఇంజామ్‍ నాక్యా. ");
INSERT INTO vgr_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","పౌలు మ్హోడు కాడీన్‍ బోల్తోహుయిన్‍ గల్లియోను యూదుల్‍ వాళాతి, ఆ ఏక్ అన్యాయంతి, ఖరాబ్ ఇంజామ్‍ పన్కి హూయుతొ మే తూమారు వాతె సహనంతి హాఃమ్‍జానూ న్యాయమస్‍. ");
INSERT INTO vgr_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","హుయుతో ఖయూకి ఏక్ ఉపదేషకి, నామ్‍కి, తూమారు ధర్మషాస్త్రంనా టేకె లడాయ్‍ హుయుతో తుమ్నా తూమేస్‍ దేకిలేవో; ఆంనూ సంగతుల్‍నా విమర్షించను మారు కామ్‍ కాహే కరి యూదుల్‍తి బోలిన్‍, ");
INSERT INTO vgr_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","ఇవ్నా న్యాయస్థానం కన్నూ హాఃమేథూ హకాళ్‍ నాక్యు. ");
INSERT INTO vgr_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","తెదె ఇవ్నె న్యావ్‍నుజొగొనూ అధికారి సోస్తెనేసునా ధర్లీన్‍ న్యాయపీఠంనా హాఃమేస్‍ మార్యు. అజు గల్లియోను ఆ సంగతిల్నా ధ్యాన్‍ దిదూ కోయిని. ");
INSERT INTO vgr_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","పౌలు బుజుబి ఘణా ధన్‍ ఏజ్గా ర్హవానుబాద్‍మా విష్వాసుల్‍ జైయిన్‍ అవ్వుస్‍ కరి బోలిన్‍, ఇనా మొక్కుబడి ర్హవమా కెంక్రేయమా ముఢ్‍క్యానూ కేహ్‍ః కడైలీన్‍ ఝాజ్‍ ఛడీన్‍ సిరియనా నిక్యో. ప్రిస్కిల్లా అకుల ఇనా కెడే గయా. ");
INSERT INTO vgr_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","ఇవ్నే ఎఫేసునా ఆయా తెదె యో ఇవ్నా ఏజ్గా మ్హేందీన్‍, యో ఏక్కాస్జణో సభ జోగోమా జైన్‍ యూదుల్‍తి ఆరాభరు వాత్‍ ఫేడ్తోర్హయో. ");
INSERT INTO vgr_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","ఇవ్నే ఇనా బుజుబి థోడా ధన్‍ ర్హవోకరీ బతిమాలమా, యో నాఒప్పిన్‍ ");
INSERT INTO vgr_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","హుయుతో దేవ్నూ చిత్తంరైతో తూమారకనా పాచు ఆయిస్‍ కరి, ఇవ్నా కనా జాయిన్‍ అవ్వుస్‍ కరి బోల్యో, ఝాజ్‍ ఛడీన్‍ ఎఫెసుథూ నిక్యో. ");
INSERT INTO vgr_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","బాద్మా కైసరయనూ ఝజ్‍ వుత్రిన్ యెరూషలేమ్‍నా జైన్‍ సంఘ అద్మీయేనా హాల్‍చాల్‍ పుఛైన్‍ అంతియొకయనా ఆయో. ");
INSERT INTO vgr_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","ఏజ్గా థోడధన్‍ ర్హవానూ బాద్మా నికీన్‍ గలతీయ ఈలాఖోమా ప్రుగియమా ర్హథో హుయిన్‍ సిష్యుల్‍నా విష్వాసంమా ఘట్‍ కర్యో. ");
INSERT INTO vgr_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","యో ధన్మా అలెగ్జాండ్రియనూ అపొల్లో కరి ఏక్ యూదుడ్‍ ఎఫెసునా ఆయు. యో విద్వాంసుడ్‍బి, లేఖనంమా ఛాతుర్థీ థో. ");
INSERT INTO vgr_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","యో ప్రభునూ వాట్‍నూ విషయంమా ఉపదేషం లీన్‍ ఇనూ ఆత్మమా ఉషిహుయో, యెహాన్‍నూ బాప్తిస్మం ఏక్కాస్‍ మాలంహూయో హూయిన్‍, యేసునూ వాతె ఖుల్లా కరీన్‍ బోలిన్‍ బోధిస్తోహుయిన్‍ ");
INSERT INTO vgr_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","సభ జోగొమా హిమత్తి బొలాను స్యురు కర్యో. తెదే ప్రిస్కిల్లా, అకుల హాఃజీన్‍ ఇనా ఖందే కర్‍లీన్‍ దేవ్ను వాతేనా అజు ఘణు బోలిన్‍ ధరయూ. ");
INSERT INTO vgr_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","ఇనబద్మా యో అకయనా జానూ కరి రైగోతేదె ఇనా ఖందేకర్‍లేనూ తిమ్‍ భైయ్యేవ్‍నా ఖుఃషి కరౌతోహుయిన్‍, ఏజ్గాను సిష్యుల్‍నా లిఖ్యా. యో ఏజ్గా ఆయిన్‍ కృపతి విష్వసించ వాళానా ఘణు మదాత్‍ కర్యో. ");
INSERT INTO vgr_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","యేసుస్‍ క్రీస్తు కరి లేఖనంథి హాఃరవ్‍నా మాలం కరాయిన్‍ యూదులనూ వాదనల్‍నా అఖ్కావ్‍మా ఘట్‍ ఖండీస్తో హుయిన్‍ ఆయో. ");
INSERT INTO vgr_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","అపొల్లో కోరింతిల్‍మా రైతేదె ష్యాత్‍ హూయు కతో, పౌలు ఉఫర్లు ఇలాహొఃమా ర్హతో హుయిన్‍, ఎఫెసునా ఆయిన్‍, థోడుజణు సిష్యుల్‍నా దేఖిన్‍, ");
INSERT INTO vgr_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","అజు ఇవ్నా విష్వాసం కరుతే తేదె పవిత్రాత్మనా పోంద్యానా? కరి ఇవ్నా పుఛావమా, ఇవ్నే “పవిత్రాత్మ ఛాకరీన్‍ హమే కేదే హాఃజ కోయిని” కరి బోల్యా. ");
INSERT INTO vgr_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","తెదె యో ఇమ్‍ హూస్యేతో తుమే కినా బట్టీ బాప్తిస్మమ్‍ లీదా కరి పుఛావమా, ఇవ్నే యోహాన్‍ను బాప్తీస్మమ్‍ను కరి బోల్యా. ");
INSERT INTO vgr_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","ఇనహాఃజె పౌలు, యోహాన్‍ ఇనా పీటే ఆవుంక్రతే ఇనా కనా, కతో యేసుమా విష్వాసంరాక్నూ కరి ప్రజల్‍తి బోల్తోహుయిన్‍, పాప్ మాతు మారుమనస్సునూ విషయంమా బాప్తిస్మమ్‍ దిదూ కరి బోల్యా. ");
INSERT INTO vgr_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","ఇవ్నే యో వాతె హాఃజీన్‍ ప్రభుహూయోతే యేసునా నామ్‍తి బాప్తిస్మమ్‍ లీదూ. ");
INSERT INTO vgr_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","ఇనబాద్మా పౌలు యూవ్నాఫర్‍ హాత్‍ మ్హేంధామా పవిత్రాత్మ యూవ్నా ఉఫర్‍ ఆయూ. తెదె యూవ్నే అన్యా సభాషాల్‍మా వాతేబోల్తూస, ప్రవచించన షురు కర్యు. ");
INSERT INTO vgr_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","ఇవ్నే హాఃర భరోభర్‍ భార జణా ఫర్ఖా . ");
INSERT INTO vgr_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","బద్మా యో సభ జోగొమా జైన్‍ సువార్త కర్తోహుయిన్‍, దేవ్నూని రాజ్యంనా టేకె బోల్తో ర్హయిన్‍, ఓప్పావ్‍తో హుయిన్‍, హిమ్మత్‍తి వాతె బోల్తోహుయిన్‍ తీన్‍ మైనా ర్హాయో. ");
INSERT INTO vgr_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","హుయుతో థోడు జణు ఘట్‍ జాన్‍ వాళు హుయిన్ నమ్మాకోయినితిం, జనాల్‍నా హాఃమే ఆ వాట్నా దూషించమా యో ఇవ్నా మ్హేందిన్‍, సిష్యుల్‍నా జోడ్‍కర్లిన్‍ హార్యేక్ తురన్న కరి ఏక్నూ పాఠషాలమా బోల్తోఆయో. ");
INSERT INTO vgr_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","భే వరహ్‍ఃతోడి ఇమ్మస్‍ హూయు, ఇనటేకె యూదుల్‍ మాహో గ్రీసు దేహ్ఃవాళా మాహో ఆసియామా కాపరంకర్యు కరతె ఇవ్నే హాఃరుబి ప్రభునూ వాక్యం హాఃజ్యా. ");
INSERT INTO vgr_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","బుజు దేవ్‍ పౌల్‍తి కెత్రూకి విసేషంనూ అద్భుతాల్‍నా కరాయో. ");
INSERT INTO vgr_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","ఇనూ ఆంగ్తన్‍నా లగ్గూతే హాత్‍నూ లుంగుఢు హూయుతో, కంబర్‍నా బందయుతే లుంగుడు హుయుతో రోగేలకనా లాయుతేదె, రోగ్‍ యూవ్నా మ్హేంధిదూ, చంద్నుఆత్మ మ్హేంది ఛలీగు. ");
INSERT INTO vgr_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","తెదె దేహ్‍ఃనూ వషారే కరావళు, జాదుకోర్ థోడు జణు యూదుల్‍ పౌల్‍ ప్రచార్‍ కరూకరాతే యేసునూ నామ్తి తూమ్‍నా హుఖుఃమ్‍ కరూకరస్‍ కరి బోలిన్‍, చంద్నుఆత్మ ధర్యూహుయునా ఉఫర్‍ ప్రభుహూయోతే యేసునూ నామ్‍ లేవానాటేకె ఏక్‍హూయా. ");
INSERT INTO vgr_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","యూదుడ్‍ స్కేవయన్‍ కరి ఏక్ ప్రధాన యాజకుడ్‍నూ ఛియ్యో హాఃత్‍ జణా ఇమ్మస్‍ కరూకర్యా. ");
INSERT INTO vgr_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","ఇనహాఃజే యో చంద్నుఆత్మ యేసు కోణ్కాతో మనా మాలం, పౌలుబి మాలం, అజు తుమె కోన్‍ కరి పుఛవమా, ");
INSERT INTO vgr_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","యో చంద్నుఆత్మ ధర్యుహుయు ఉఢీన్‍, యూవ్నాఫర్‍ పడీన్‍ చీరిన్ లుంగాడ పాడ్యు; ఇనహాఃజే యూవ్నె ఉఘాఢాహుయిన్‍ గాయల్‍ కర్లీన్‍ యో ఘర్‍తూ మీలైల్దా. ");
INSERT INTO vgr_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","ఆ సంగతి ఎఫెసుమా కాపరం ఛాతే హాఃవాఖో యూదుల్‍ నాహో, యూదుల్‍ కావేతే హఃరామాలం హుయుతేదె యూవ్నా హాఃరవ్‍నా ఢర్‍ హుయుగు. ప్రభుహూయోతే యేసునూ నామ్‍ ఘనపర్‍ఛ బడ్యు. ");
INSERT INTO vgr_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","విష్వాసించుతె యూవ్నే హాఃరు ఆయిన్‍, యూవ్నే కర్యాతే ఇనా బోలిన్‍ ఒప్పిలీదా. ");
INSERT INTO vgr_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","బుజు మంత్రంనూ ఫఢాయి మాలంహూయు యూవ్నే హాఃరు పుస్తకాల్‍నా లాయిన్‍ హాఃరవ్‍నా హాఃమే భళ్లాఖ్యు. యూవ్నే గణ్తీ దేఖమా ఇనూ మోల్‍ ఆఢైహ్‍ః హాజార్‍ రూపనూ రఫ్యా హూయా. ");
INSERT INTO vgr_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","ఏత్రే ప్రభావ్‍తి ప్రభునూ వాక్యం ప్రబల్‍ హుయిన్‍ ఫైలాయు. ");
INSERT INTO vgr_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","అమ్‍ హూవాన బాద్‍మా పౌల్‍ మాసిదోనియ అకయ దేహ్‍ఃనూ మారగ్‍ఫర్‍ ఆయిన్‍, యెరూషలేమ్‍నా జాను కరి దీల్‍మా సోచిన్‍ మే ఏజ్గా జవాన బాద్‍మా రోమానబి దేక్నూ కరి రైగో. ");
INSERT INTO vgr_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","తెదె ఇన పరిచర్య కరతె యూవ్నామా తిమోతి ఎరస్తు కరి యూవ్నా బేజణానా మాసిదోనియ మోక్లీన్‍, యో ఆసియామా థోఢా ధన్‍ ర్హయో. ");
INSERT INTO vgr_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","యో ధన్నువ్‍మా క్రీస్తునూ మారగ్‍నా గూర్చి ఎఫెసులో ఘణు గలాఠా హూయు. ");
INSERT INTO vgr_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","కిమ్‍ కతో దేమేత్రి కరి ఏక్ కంసాలి అర్తెమిదేవి మూర్తినా మందిర్ బణావమా యో కామ్‍ యూవ్నా ఘణు ఫైధో హోతుర్హయు. ");
INSERT INTO vgr_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","యో యూవ్నా ఇమ్‍నూ కామ్‍ కరు ఆజు బాజు వాళనా గుంపు కరైన్‍ హాఃయబ్, ఆ కామ్‍థి అప్నూ జీవ్నూ ఘణు అష్యల్‍ చాలుకరాస్‍ కరి తూమ్‍నా మాలం. ");
INSERT INTO vgr_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","హూయుతో హాతేహూః భణాయుహుయు దేవతల్‍ కాహే కరి, ఆ పౌల్‍ బోలిన్‍, ఎఫెసుమా మాత్రం కాహే, హూఃమార్‍ ఆసియామా ఘణా జనాల్‍నా ఒప్పాయిన్‍, ఫరాయి రాక్యుతే సంగతి తుమె దేఖిన్‍బి హాఃమ్జీబి రాక్యస్‍. ");
INSERT INTO vgr_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","బుజు ఆ అప్నూ వృత్తిమా కామ్‍ ఛుకీజావనూ కాహేతిమ్‍, మహాదెవినూ అర్తెమిదేవినూ గుడిబి ఛీ కరి బోలైజైన్‍, ఆసియా హాఃరమ్‍ ముల్క్మా హాఃలామ్‍ కరైలేంగ్రతే అనూ కోణ్ ఆవసే హాటీజాసే కరి ఢర్‍తీ యూవ్నేతి బోల్యు. ");
INSERT INTO vgr_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","యూవ్నే హాఃమ్జీన్‍ ఛంఢాల్తీ భరైన్‍ ఎఫెసీయుల్‍నూ అర్తెమిదేవి మహాదేవి కరి ఖైకార్‍ మ్హేంధు. ");
INSERT INTO vgr_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","హాఃయార్‍ ఘణు గిలిబిలింతర రయు. బుజు బేజణ పౌల్‍తి ఏజ్గాతు నాకీన్‍ ఆయుతే మాసిదోనియ వాళా గాయియుబి అరిస్తార్కునా ధర్లీన్‍ ఎక్ నాటక షేలమా ఫేటూ. ");
INSERT INTO vgr_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","పౌల్‍ జనాల్‍ హాఃమే జానూ కరి రైగో కాని సిష్యుల్‍ ఇనా జవాదిదూ కోయిని. ");
INSERT INTO vgr_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","బుజు ఆసియ దేహ్‍ఃనూ అధికారుల్‍మా థోడు జణు ఇనా దోస్తుల్‍ హుయిరైన్‍, ఇన నాటకషాలమా జావోనొకో; కరి గోజాడ్తుహుయిన్‍, ఖభార్‍ బోలిమొక్‍ల్యా. ");
INSERT INTO vgr_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","యో సభ అక్కు రావ్‍డింతర థూ, ఇనటేకె థోడు జణు అమ్‍, థోడు జణు ఇమ్‍ ఖైకార్‍ మ్హేంధు; యూవ్నే ష్యాన ఆయిర్హస్‍ కరీన్‍బి యూవ్నా మాలంకోయిని. ");
INSERT INTO vgr_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","తెదె యూదుల్‍ అలెగ్జాండర్‍నా అగడీ ధక్లమా థోడు జణు గుంపుల్‍మథూ ఇనా హాఃమే లీ ఆయా. అలెక్సంద్రు ఈషార కరీన్‍ జనాల్‍తి ఉత్తర్‍ బోల్లేను కరి థో. ");
INSERT INTO vgr_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","కాని యో యూదుడ్‍ కరి యూవ్నే మాలంకర్లీదు తెదె హాఃరుబి ఏక్కాస్‍ ఖైకార్‍తి బే గంటా తోడి ఎఫెసియుల్‍నూ అర్తెమిదేవి మహాదేవి కరి ఖైకార్‍ మ్హేంధూ. ");
INSERT INTO vgr_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","ఇనబాద్‍మా గామ్ను అధికారి గుంపుల్‍న హఃమ్జాయిన్‍ షోపొ కరైన్‍ ఎఫెసియుల్‍వాలా, ఎఫెసియుల్‍నూ హఃయర్‍ అర్తెమి మహాదేవినా ఆకాష్‍మతూ ద్యుపతికనాతూ పడ్యూతే మూర్తినా పాళావళి హుయిన్‍ ఛా కరి మాలంకోయింతే కోన్‍? ");
INSERT INTO vgr_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","ఆ సంగతుల్‍నా కోన్‍బి కాహే కరి బొలాను కాహే ఇనటేకె తుమె సాంతం హుయిన్‍, ఖయుబి ఘభ్రాయిన్‍ కరోనకో. ");
INSERT INTO vgr_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","తుమె ఆ అద్మినా లీన్‍ ఆయా. ఆవ్నే గుడినా లఫాడ్యాకోయిని, అప్నూ దేవినా దూషించ్యాబి కోయిని. ");
INSERT INTO vgr_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","దేమేత్రినాబి ఇనా కేడె ర్హవళ కమసాలుల్‍నాబి కీనఫర్‍బి యవారాల్‍ హూసేతో న్యాయసభల్‍ హూంక్రస్‍, అధిపతుల్‍బి ఛా, ఇనటేకె యూవ్నే ఏక్తిఏక్‍ లఢాజై. ");
INSERT INTO vgr_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","కాని తుమె అలాదు సంగతుల్‍నా హాఃజే ఖయూబి విఛారించ్నూ కరి హుసేతో యో ఏక్ క్రమంనూ సభమా థంగో తోడీలేనూ. ");
INSERT INTO vgr_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","ఆప్నే ఆ రావ్డీనా హాఃజే బోల్లేవానూ కారణ్‍ కాయిబి కోయిని, ఇనహాఃజే ఆజ్‍ హూయుతే రావ్‍డినా హాఃజే అప్నా విచారణమా లావ్‍సేసికి కరి ఢర్‍లగ్గూకరాస్‍. అమ్‍ గుంపు భరయాతే ఇనా తగిన్‍నూ కారణ్‍ బోలానహూసే కోయిని కరి యూవ్నేతి బోల్యు. ");
INSERT INTO vgr_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","యో ఇమ్‍ బోలిన్‍ సభనా ముగ్‍సాయో. ");
INSERT INTO vgr_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","యో గలాఠా షోపో హూవనా బాద్‍మా పౌలు సిష్యుల్‍ నా ఇనాకనా బులామంగైన్‍ యూవ్నా జెతవనా బాద్‍మా యూవ్నా కనా సెలవు మాంగ్లీన్‍ మాసిదోనియానా జవనా నీక్యో. ");
INSERT INTO vgr_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","యో ప్రదేషాల్‍మా సంచార్ కర్తో హుయిన్‍, గట్ వాతేతి యూవ్నా జెథాయిన్ గ్రీసునా ఆయో. ");
INSERT INTO vgr_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","యో ఎజ్గా తీన్‍ మహీనా ర్హైన్‍, ఝాజ్‍ చడీన్‍ సిరియనా జానుకరీ రైజవమా, ఇనూ విషంమా యూదుల్‍ కుట్ర కరమా యో మాసిదోనియాను ఫారిన్‍ జాను కరి సోచీల్దో. ");
INSERT INTO vgr_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","బుజు పుర్రునో ఛియ్యో బెరయ హాఃయార్‍నూ సోపత్రును, థెస్సలోనికయుల్‍మా అరిస్తార్కును, సెకుందును, దెర్బే హఃయర్‍నొ గాయియుబి, తిమోతిబి, ఆసియా దేహ్‍ఃనూ తూకికు, త్రోఫిమునూబి ఇనా కేడె ఆయు. ");
INSERT INTO vgr_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","ఆవ్నే ఆగడీ జైన్‍ త్రోయమా హమార టేకె కనిపెట్‍తార్హయా. ");
INSERT INTO vgr_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","ఖాటుకోయింతే రోటొనుపండగనా బాద్‍మా, ఫిలిప్పినా మ్హెందిన్‍, జ్హాజ్‍ ఛడీన్‍ ఫాచ్‍ ధన్‍మా త్రోయనా ఆయిన్‍, ఏజ్గా యూవ్నా కనా హఃత్‍ ధన్‍ ర్హయా. ");
INSERT INTO vgr_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","ఆదివారమ్‍ హఃజే హమే రోటొ తోఢానా టేకె ఏక్ జోగో భరయా తెదె, పౌలు బుజాధన్నే జాను కరి రైజిన్‍, యూవ్నేతి బోదిస్తోహుయిన్‍, ఆది ర్హేణ్‍ తోడీ కెత్రూకి వాతె బోల్తోర్హయో. ");
INSERT INTO vgr_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","హమే భరైర్హతే మిద్దినూ కమ్రామా కెత్రూకి దిపాల్‍ భళుకరుథూ. ");
INSERT INTO vgr_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","ఏజ్గా పౌలూ బోదించుకరాతో ఏక్ ఐతుకు కరి కవారు చోగ్రు కీటికినా సేడె బేసిన్ ఖుఃతూ హుయిన్‍, ఇమ్మస్‍ లీంధార్‍మా యో చోగ్రు తీన్‍మనూ అంతస్థుథూ హేట్‍ పడీన్‍ మరీగయు. ");
INSERT INTO vgr_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","యత్రమా పౌలుబి హేట్‍ వుత్రిన్‍ ఆయిన్‍ యో ఛోగ్రుఫర్‍ పడీన్‍ భతైలీన్‍, తుమె ఢరో నకో ఆనమా జాన్‍ ఇమ్మస్‍ ఛాకరీ యూవ్నేతి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","యో బుజు ఉఫర్‍ ఆయిన్‍రోటొ తోఢీన్‍ హఃరవ్‍నా దీన్‍ యోబి ఖైన్‍, వ్హాణు హువతోడి కెత్రూకి వాతె బోలిన్‍, పౌప్‍ నీకిగో. ");
INSERT INTO vgr_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","యూవ్నే జీవిగయూతే యో చోగ్రానా లీన్‍గయాతేదె కేత్రెకీ ఆదరణ మళ్యు. ");
INSERT INTO vgr_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","హమే ఆగడీస్‍ జ్జాజ్‍ ఛడీన్‍ అస్సుమా పౌలునా ఛడైలేను కరి గయా, ష్యానకతో పౌలు తుమె అగడీ జవో, మే గోడాతి ఛాలీన్‍ ఆయిన్‍ తుమ్నా అస్సుమా మళీస్‍ కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","అస్సుమా యో ఆయిన్‍ హమ్నా మళ్యోతేదె హమే ఇనా జ్జాజ్‍ ఛడైలీన్‍ మితులెనునా ఆయా. ");
INSERT INTO vgr_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","ఏజ్గాతూ జైన్‍ బుజాధన్నే కీయొసునా ఎదుర్‍ ఆయా. బుజా ధన్నే సయొసున జైన్‍ బుజా ధన్నే మిలేతునా ఆయా. ");
INSERT INTO vgr_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","హూవఎత్రే యగ్గిమా పెంతెకోస్తునా ధన్నే యెరూషలేమ్‍మా ర్హనూ కరి పౌలు జల్ధిమాథో. ఇనహఃజే యో ఆసియామా ధన్‍నా ఛుక్కేస్‍ నాకాణ్నుతిమ్‍ ఎఫెసునా దాటిన్‍ జాను కరి సోచీరాక్యో. ");
INSERT INTO vgr_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","యో మిలేతు మాతు ఎఫెసునా ఖభార్‍ మొక్లీన్ ‍సంఘంనూ ష్యాణవ్‍నా బులాయ్ మంగాయో. ");
INSERT INTO vgr_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","యూవ్నే ఇనాకనా ఆయాతేదె యో యూవ్నేతి అమ్‍ బోల్యొ మే ఆసియామా గోడొ మ్హేంద్యోతే ధన్‍థూ ధరీన్‍, ఎల్లకాలం తూమార ఇఛ్మా కిమ్‍ ర్హయోకీ తూమ్నాస్‍ మాలం. ");
INSERT INTO vgr_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","యూదుల్ను కుట్రల్‍తీ మన కెత్రూకి షోదనా ఆయుతోబి, ఆంజూ చువాడ్తో హుయిన్‍ కెత్రూకి ఇమాన్‍థీ ప్రభునా కిమ్‍ సేవా కర్యోకీ తూమ్నాస్‍ మాలం. ");
INSERT INTO vgr_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","బుజు ఫైదోనూ క్హయూబి లఫాడ్నూ నాతిమ్‍ ఖుల్లా కరీన్‍, ఘర్‍ ఘర్‍మా తుమ్నా మాలం కరవ్‍తో హుయిన్‍, బోదిస్తోహుయిన్‍, ");
INSERT INTO vgr_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","దేవ్ను ఖామే దిల్‍భద్‍లై లీన్‍ అప్నో ప్రభుహూయోతే యేసు క్రీస్తుమా విష్వాసంగా ర్హనూ కరి యూదుల్‍నాబి యూదుల్ కాహేతె ఇవ్నే కిమ్‍ సాబుత్‍ దిదోకీ యో హఃరుబి తూమ్నా మాలం. ");
INSERT INTO vgr_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","హాధేకో మే హాంకే యోఆత్మ విధేయత వాలోహుయిన్‍, యెరూషలేమ్‍నా జౌంకరుస్‍, ఏజ్గ మన ష్యాత్‍ హూవాస్‍కీ మాలంకోయిని. ");
INSERT INTO vgr_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","పన్కి బంధకాల్‍బి, ష్రమల్‍ మారా హాఃజే తక్చేరీ కాటుకరాస్‍ కరి పరిషుద్ధాత్మ హార్యేక్ ‍హాఃయార్‍మా మన సాక్చ్యం దేంకరాస్‍ కరి మాలం. ");
INSERT INTO vgr_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","కాని దేవ్‍నూ కృప సువార్తనా గూర్చి సాక్చ్యం దేవామాబి, మారు మిలావను మే ప్రభు హుయోతే యేసుథీ మళ్యుతే పరిచర్యనా, ఖతం కర్నూ కరి, మారు జాన్‍ఫర్‍ మన ష్యానుబి ప్యార్‍ చాకరీ మే కోరుకరుకోయిని. ");
INSERT INTO vgr_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","హాధేకో దేవ్‍నూ రాజ్యంనా టేకె ప్రచార్‍ కర్తోహుయిన్‍, మే తూమర ఇఛ్మా ర్హయో; తూమారమా కోన్‍బి అజు కెదేబి మన దేక్సుకోయిని కరి మన హాంకే మాలంహుయు. ");
INSERT INTO vgr_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","అనటేకే మే హాఃరను లోహిను విషయంమా నిర్దోషికరి ఆవహఃత్‍ఫర్‍ తుమరేతి సాబుత్‍ దెంకరుస్‍. ");
INSERT INTO vgr_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","దేవ్నూ చిత్తం హఃరుబి తూమ్నా మాలంకరాయో కోయింతే మే కేయూబి లఫాడ్యో కోయిని. ");
INSERT INTO vgr_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","దేవ్‍ ఇనూ ఛీయ్యాను స్వంత లోహినా దీన్‍ కమాయోతే ఇనూ సంఘంనా కావ్లీకరాన టేకె, పరిషుద్ధాత్మ తుమ్నా కినా హఃమే మోటావ్‍నితర ర్హాక్యోకియో హఃరు మందల్‍నాటేకె, బుజు తుమారటేకె జత్తన్ ‍ర్హవో. ");
INSERT INTO vgr_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","మే ఛలోజావదిన్‍ బద్మా భయంకర్నూ హాఢోనూ జోణ్నూ తూమారమా ఆవ్‍స్యే కరి మన మాలం; ఇవ్నే మందనాఫర్‍ గోర్‍ కర్షేకోయిని. ");
INSERT INTO vgr_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","బుజు విష్వాల్‍ ఇవ్నా కేడె ఖేచ్‍లీన్ జాను కరి కెత్రేకీ ఢంగాల్ని వాతె బోలవాళు అద్మీయే తూమారమథూస్‍ నికల్స్యే. ");
INSERT INTO vgr_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","ఇనటేకె మే తీన్‍ వరహ్‍ః రాత్ను ధన్ను ఆంజు ఛువాడ్తో హుయిన్, ఏక్నాబి నా మ్హేన్నూతిమ్‍ హార్యేక్‍ అద్మినా అఖ్కల్‍ బోల్యొ కరి, తుమే హాఃయాల్‍ కర్లీన్ హొషార్తి ర్హవో. ");
INSERT INTO vgr_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","హాంకె తుమ్నా దేవ్‍నాబి, కృపా వాక్యంన దేవాడు కరూస్‍. యో తుమ్నా క్చేమాభివృద్ది కరావనా టేకె, పరిసుద్ధ్‌హూయుతే ఇవ్నా హఃరవ్‍మా స్వాస్థంనా దేవానా టేకె తాహాఃత్‍వాళో. ");
INSERT INTO vgr_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","కినకానా రూపుహో, ఘేణుహో, లుంగడా మే ఆహాః కర్యోకోయిని. ");
INSERT INTO vgr_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","మారు జరూరత్నా హఃజే, మారా కేడె ఛాతే యూవ్నా హఃజే ఆ మారు హాత్‍ మ్హీనత్‍ కర్యో కరి తూమ్నాస్‍ మాలం. ");
INSERT INTO vgr_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","36","తూమేబి ఆమ్మాస్‍ ప్రయాస్‍ కరీన్‍, కంజోర్‍తి ఛాతే యూవ్నా రక్చించోకరీ, “హీంకడ్‍తూ లేవానూథీబి హాంకడ్‍తూ దేవాను భాగ్యం” కరి ప్రభు హుయోతే యేసు బోలోతే వాత్‍ హాఃయాల్‍ కర్‍లేవో కరి, హాఃరు విషయాల్మా మే తుమ్నా ఏక్ వాట్నితర దేఖాడ్యో కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","యో ఆమ్‍ బోలిన్‍, గూడ్‍గ్హే ఫర్‍ బేసిన్‍, హాఃరవ్‍తి మలిన్‍ ప్రార్దన కర్యొ. ");
INSERT INTO vgr_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","తెదె యూవ్నే హఃరు గ్హణు రోవానిక్ల్యా. తుమె అజు కెధేబి మారు మ్హోడు దేక్సుకోయిని కరి పౌలు బోల్యోతే వాత్నా యూవ్నే అజు గ్హణు దుఃఖ పడ్యా. పౌలునా గర్దన్ ఫర్‍ పడీన్‍ ఇనా బుఛ్చా దీన్‍, యూవ్నే జ్హాజ్‍ తోడీ ఇనా బోలిమొక్ల్యా. ");
INSERT INTO vgr_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","హామే యూవ్నా మ్హేందిన్‍ జ్జాజ్‍ ఛడీన్‍ ఏజ్గాతు హాఃఢాక్‍ కోసుకునా, బుజాధన్నే రోదుకునా, ఏజ్గాతూ పతరకునా ఆయా. ");
INSERT INTO vgr_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","తెదె ఫేనికేనా జావానూ ఏక్ జ్హాజ్‍నా దేఖిన్‍ ఇనాఫర్‍ ఛడీన్‍ గయా. ");
INSERT INTO vgr_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","కుప్రనా హఃమే కరీన్‍, ఇనూ ఢవాత్నూ బాజుమా మ్హేందీన్‍, సిరియమ్హణి జైన్‍, తూరుమా ఉత్ర్యా. ఏజ్గా జ్హాజ్‍నూ మాల్‍ ఉత్రావనూ థూ. ");
INSERT INTO vgr_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","హమె ఎజ్గా సిష్యుల్‍నా మాలంకరీన్‍, యూవ్నా కనా హఃత్‍ ధన్‍ ర్హయా. యూవ్నే పౌలుథీ తూ యెరూషలేమ్‍మా నకోజాకరి మ్హేందీస్‍ కరి ఆత్మతిస్ బోల్యా. ");
INSERT INTO vgr_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","యో ధన్‍ హఃరు గుజారీన్‍ ఏజ్గాతూ నీకానూ వోహఃత్‍, ఇవ్ను భావణ్‍థీ, లఢాక్వాథీ హమార కేడె ఆయిన్‍ హఃయార్నూ కనారి తోడి ఆయిన్‍ బోలిమొక్‍లానా హాఃజె ఆయా, ఏజ్గా హామే హాఃరా మలిన్‍ గుడ్గేఫర్‍ బేసిన్‍ ప్రార్థన కరీన్‍, ");
INSERT INTO vgr_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","ఏక్నా ఏక్తీ జైయేస్‍ కరి బోల్లిదా. తెదె హామే ఘాజ్‍ ఛడీగయా, ఇవ్నే ఇవ్ను ఘర్‍ ఛలీగు. ");
INSERT INTO vgr_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","హామే తూరుథూ కర్యాతే ప్రయాణంనా ఖతం కరీన్‍, తొలెమాయినా ఆయిన్‍, ఏజ్గాను భైయ్యేవ్‍నా కిమ్‍ ఛాకీ పుఛాయిన్‍ ఇవ్నా కనా ఏక్ ధన్ ర్హయా. ");
INSERT INTO vgr_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","తినా బుజా ధన్నే ఏజ్గాతూ నాకీన్‍ కైసరయనా ఆయిన్‍, హాఃత్‍జణామా ఎక్నా యేరుషలేమ్‍ సువార్త కరవాళో ఫిలిప్పునూ ఘర్మా జైన్‍ ఇనాకనా ర్హయా. ");
INSERT INTO vgr_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","ఇనా ఛార్‍ కవారీ ఛోరీయే, ఇవ్నే ప్రవచనాల్‍ బోలావాళియే. ");
INSERT INTO vgr_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","ఏజ్గా హామే కెత్రాకీ ధన్‍ ర్హవమా, యూదయ దేహ్ః మతూ అగబు కరి ఏక్ ప్రవక్త ఆయో. ");
INSERT INTO vgr_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","యో హామార కనా ఆయిన్‍ పౌలును కంభార్నో కాఛో లీన్‍ ఇనూ హాత్‍ గోఢానా భంద్‍లిన్‍, యెరూషలేమ్‍నూ యూదుల్‍ ఆ కంభార్ను కాఛో వాళానా ఆం భాందిన్‍, యూదుల్ కాహేతే ఇన్నా హాత్మా ఒప్పావ్‍స్యే కరి పరిషుద్ధాత్మ బోలుకరాస్‍ కరి బోల్యు. ");
INSERT INTO vgr_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","ఆ వాతె హాఃజ్యాతెదే ఇనా హామే ఏజ్గా ఛాతే ఇవ్నే యేరూషలేమ్‍ నకోజాకరీ బతిమాల్యా పన్కి, ");
INSERT INTO vgr_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","పౌలు ఆం ష్యాన రోయిన్‍ మారు దీల్‍ దుఃఖవా హాఃరుకు కరాస్‍నా? మేతో ప్రభు హుయోతే యేసునూ నామ్‍నాటేకె యెరూషలేమ్‍మా బంధింప బడనస్‍ కాహే పన్కి మరానబి సిద్ధంగా ఛౌ కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","హామే కెత్రూ బోల్యుతోబి యో నా ఒప్పామా “ప్రభును చిత్తమస్‍ హూవాదే” కరి షోపొ హూయిగయా. ");
INSERT INTO vgr_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","యో ధన్నానా బద్మా హమ్నా హూనుతే రాఛా పళ్ళీన్‍ యెరూషలేమ్‍నా గయా. ");
INSERT INTO vgr_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","బుజు కైసరయథూ థోడు జణా సిష్యుల్‍, ఆగడీతూ సిష్యుడ్‍నితర ర్హయోతే కుప్రీయుడ్నో మ్నాసోను ఘర్మా హామే ర్హనూ కరి హూఃజ్‍తీ ఇనా కేడె లీన్‍ హామార కేడె ఆయా. ");
INSERT INTO vgr_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","హామే యెరూషలేమ్‍నా ఆయాతేదె భైయ్యే హామ్నా హూఃషీతి చేర్సాయి లిదు. ");
INSERT INTO vgr_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","బుజా ధన్నే ష్యాణా అద్మీయే హఃరు ఏజ్గా ఆయి ర్హవమా పౌలు హామార కెడే యాకోబ్‍ కనా ఆయో. ");
INSERT INTO vgr_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","యో యూవ్నా కిమ్‍ ఛాకీ పుచ్‍తాచ్‍ కరీన్‍, ఇనూ సేవతి దేవ్‍ యూదుల్‍ కాహేతే ఇవ్నా కర్యోతే ఇనా వివరించిన్‍ బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","ఇవ్నే యో హఃరూ హఃమ్‍జీన్‍ దేవ్నా మహిమ కర్యా, ఇనా దేఖీన్‍ భై, యూదుల్‍మా విష్వాసుల్‍ హూయూతే కెత్రూ హజార్ అద్మీకి తూ దేఖూ కరాస్‍ కున్నా? యూవ్నే హాఃరు ధర్మషాస్ర్తంని వాతేనా హాఃజిన్‍ ఘాణు ఆహ్‍ఃతి ర్హవాళు. ");
INSERT INTO vgr_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","యూదుల్‍ కాహేతే ఇవ్నే ఛాతే యూదుల్‍ ఇవ్ను లడ్కవునా సున్నతి నాకరావ్ను కరి, అప్ను ఆచారాల్మా ఛాతిం నాఛాల్నుతిం తూ బోల్యొతేథి ఇవ్నే హఃరూ మోషేనా మ్హేందేనూ కరి తూ బోలుకరా తిమ్‍, ఆవ్నే తారటేకెను ఖభార్‍ హాఃజీరాక్యస్‍. ");
INSERT INTO vgr_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","ఇనహఃజే అప్నె ష్యాత్‍ కరీయే? తూ ఆయోతె వాత్‍బి ఇవ్నే ఖాంజ్యా. ");
INSERT INTO vgr_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","ఇనహఃజే తూ హామే బోలాతిమ్ కర్. మొక్కుబడి కర్‍రాక్యతే యూవ్నే ఛార్‍జణా మారకనా ఛా. ");
INSERT INTO vgr_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","తూ యూవ్నా కేడె లీన్‍ జైన్‍ యూవ్నేతి మలిన్‍ సుద్ధి కరైలిన్‍, యూవ్నా ముఢ్‍క్యాను కేహూ కఢవానా తార రఫ్యా ఇనా హూషేతే; తెదె తారటేకెను హాఃమ్‍జ్యుతే వాతె హాఃఛీ కాహే కరీన్‍, బుజు తూబి మోషేనూ ధర్మషాస్ర్తంనా పాటించిన్‍, ఇనా ప్రకార్‍ చాలుకరాస్‍ కరీన్‍ మాలంకర్‍స్యే. ");
INSERT INTO vgr_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","హుయుతో విష్వాసించ్యుతే యూదుల్ కాహేవాలు గూర్చి ఇవ్నే మూర్తేవ్‍నా బలి దిదాతే జీన్‍వార్ లోహినా, లండి దాబిన్‍ మార్యుతే జీన్‍వార్‍హుయుతోబి, జారత్వంనా భైకీజానూ కరి నిర్ణయించిన్‍ ఇవ్నా లిఖ్కీ రాక్యాస్‍ కరి బోల్యా. ");
INSERT INTO vgr_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","ఎత్రమా పౌలు బుజా ధన్నే యో అద్మీయేనా కేడె లీన్‍ జైన్‍, ఇవ్నా కేడెస్‍ సుద్ధి కరాయిలిన్‍, ఆలయంమా జైన్‍ ఇవ్నామా హార్యేక్‍జణ హాఃజే కానుకల్‍ అర్పించతోడి సుద్ధినూ ధన్‍కరీయే కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","హుయుతో హఃత్‍మనూ ధన్నే ఆసియామథూ ఆయూతే యూదుల్‍ ఆలయంమా ఇనా దేఖీన్‍, హాఃరవ్నా కలవర్‍ కర్రాఖీన్‍ ఇనా జభర్‍జస్థీథీ ధర్లిన్‍, ");
INSERT INTO vgr_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","ఇష్రాయేల్‍ వాళా, మదత్‍ కరన ఆవో; ప్రజల్నా ధర్మషాస్త్రంనా ఆ జోగోనా విరుద్ధంథీ హాఃరౌనా హాఃరూస్‍ బొలీదేంకరాతే యో ఆస్‍. బుజు ఆ యుదుల్ కాహే వాలనా ఆలయంమా లీన్‍ ఆయిన్‍, ఆ పవిత్ర జోగోనా అపవిత్ర కర్‍నాఖ్యో కరి కైఖార్‍ మ్హేంద్యు. ");
INSERT INTO vgr_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","కింకతో ఎఫెసీయుడ్‍నో త్రోఫిమునా ఆనా కేడె హఃయార్‍మా ఆనేతి ఆగడీ యూవ్నే దేఖ్యాథా, ఇనహఃజే పౌలు ఆలయంమా ఇనాబి లీన్‍ ఆయో హూసే కరి సోచ్యా. ");
INSERT INTO vgr_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","హాఃయార్‍ అక్కు గ్హణు గంధార్‍ గోళ్‍ హుయిగు. అద్మియేనూ గల్లో గల్లోంతర నాఖ్ థూ ఆయిన్‍, పౌలునా ధర్లీన్‍ ఆలయంమాథూ ఇనా భాధర్‍ ఖేఛా; తెదె యగ్గిస్‍మా ధర్వాజ ముచిన్వాకు. ");
INSERT INTO vgr_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","యూవ్నే ఇనా మర్రాక్నూ కరి దేఖూకరాతో యెరూషలేమ్‍ అక్కు గంధార్‍ గోళ్‍ హూంకరాస్‍ కరి రోమను స్తెన్యంను ఉపార్‍ అధికారినా ఖభార్‍ మొక్‍ల్యా. ");
INSERT INTO vgr_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","యగ్గిస్‍మా యో భటుల్నా, సైనికుల్ను అధికారి కేడె లీన్‍ ఇవ్నా కనా నాహ్‍ఃతో హుయిన్‍ ఆయో. ఇవ్నే ఉఫర్లో అధికారినా, సైనికుల్‍ ఆవాను దేఖిన్‍, పౌలునా మారనూ భంద్‍కర్రాక్యు. ");
INSERT INTO vgr_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","యో అధికారి ఇవ్నా ఖందే జైన్‍ ఇనా ఖంకల్‍తి భాందో కరి ఆజ్ఞాదిన్‍, ఆ కోన్‍? ఆ ష్యాత్‍ కర్యో? కరి పుఛావమా, ");
INSERT INTO vgr_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","యో అద్మియేమా థోడుజణు, థోడుజణు ఇం ఛీఖార్తూర్హవమా ఇనా హఃఛీ ష్యాత్‍కీ మాలంకరాన కోహుయుని, కోఠడ్‍మా ఇనా లీన్‍ జవో కరి హుకుందిదు. ");
INSERT INTO vgr_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","పౌలు కిట్కీనూ ఉఫర్‍ ఆయోతెదె అద్మియేను గల్లో హఃరూ భరైన్‍ బలవంతం కర్తుర్హవమా సైనికుల్నా ఇనా ఢోహ్‍లీన్‍ జావహఃర్‍కు హుయు. ");
INSERT INTO vgr_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","కింకతో అద్మీయే హఃరు ఇనా మర్రాక్ను కరి కైఖార్‍ మ్హేన్‍థూ హుయిన్‍ ఇవ్నా కేడె గయూ. ");
INSERT INTO vgr_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","ఇవ్నే పౌలునా కోఠడ్‍మా లీ జౌంకరాతో యో సైనికా అధికారినా దేఖిన్‍, మే తారేతి ఏక్ వాత్‍ బోలాజైనా? కరి పుచ్చా యో. అనటేకె యో తునా గ్రీక్‍ను వాతెబి ఆవాస్‍నా? ");
INSERT INTO vgr_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","ఆ ధన్నావ్‍నా ఆగడీ రాజద్రోహాంనా హూసీకరైన్‍, హాంతకుల్ హూయిర్హయాతే ఛార్‍ హజార్‍ అద్మీయేనా ఝాడీమా కేడె లీన్‍గయోతే తూ ఐగుప్తుడ్‍నో కాహేనా? కరి పుఛ్చాయో. ");
INSERT INTO vgr_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","ఇనాహఃజే పౌలు మే కిలికియమనూ తార్సునో యూదుడ్‍; యో మోటో హఃయార్‍నో అద్మి. మన అద్మీయేతి వాత్‍ బోలాన ఆజ్ఞా దాకరీ వేడిలెంగ్రస్‍ కరి బోల్యు. ");
INSERT INTO vgr_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","ఆధికారి ఆజ్ఞా దేవాదిన్‍ పౌలు ఖీట్కిఫర్‍ హీబ్రిన్‍ హాత్‍తి సైగ్‍ కర్యో, తెదె యూవ్నే షోపొ హుయిజవామా, యో హెబ్రీ భాషమా ఆం బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","భైయ్యేహో, భాతి యూవ్నే, మే హాంకే బోలుకరుతే వాతేనా ధ్యాన్‍ దేవో. ");
INSERT INTO vgr_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","యో హెబ్రీ భాషామా వాతె బొలానూ ధేఖిన్‍, యూవ్నే అజు గ్హణు గఛ్చుప్‍ హూయుగు. తెదె యో ఆం బోలానిక్యో. ");
INSERT INTO vgr_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","మే కిలికియమనూ తార్సుమా పైదాహూయోతే యూదయనో. కానీ ఆ హఃయార్‍మా గమలీయేల్‍నూ గోఢాకనా వధీన్‍, మారొ భానూ ధర్మషాస్ర్తంనూ నిష్ఠమా షిక్చితుడుహుయిన్‍, తుమె హఃరూ ఆజ్‍ ఛాతె ప్రకార్‍ దేవ్నా హఃజే ఎన్నిర్హాక్యోస్‍, ");
INSERT INTO vgr_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","ఆ వాటే ఛాతే మర్ధమానో, రాంఢేవ్‍నా బంధించీన్‍, ఠాణావ్‍మా ఘాలావ్‍తో హుయిన్‍, మరణ్నా ఇవ్నా హాఃతావ్‍తో థో. ");
INSERT INTO vgr_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","ఇనూ గూర్చీ ప్రధాన యాజకుడ్‍బి, ష్యాణా హాఃరాబి మన సాబుత్‍ హూయిరుస్‍. మే ఇవ్నా హాఃజే భైయ్యేవ్‍కనా పత్రికల్‍ లీన్‍, ధమస్కుమనూ ఇవ్నాబి బందీంచిన్‍ షిక్చించనా హాఃజే యెరూషలేమ్‍మా లీఆవ్‍నూ కరి ఏజ్గా గయోథో. ");
INSERT INTO vgr_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","మే నీకిన్ ధమస్కునా సేడె కరి గయోతేదె ధోఫర్నూ వోహాఃత్‍మా ఆబ్‍మథూ ఏక్ మోటు ఊజాళు మార ఆస్పీష్‍ భళానిక్ల్యు. ");
INSERT INTO vgr_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","తెదె మే మట్టిఫర్‍ పడీగయో, తెదె మన “సౌల్‍, సౌల్‍ మన ష్యాన తూ హాఃతాంక్రస్‍” కరి ఏక్ ఘళునూ ఆవాజ్‍నా మే హాఃమ్‍జ్యో. ");
INSERT INTO vgr_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","ఇనటేకె మే ప్రభు, తూ కోన్‍ కరి పుఛావమా యో “మే తూ హాఃతావ్‍ంగ్రతే నజరేయుడ్‍నో యేసు” కరి మరేతి బోల్యు. ");
INSERT INTO vgr_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","మార కేడె థూతే ఇవ్నా యో ఉజాళు యూవ్నా దేఖ్కాయు పన్కీ, మన హాఃమ్‍జాయుతే ఆవాజ్‍ ఇవ్నా హాఃమ్‍జ్యుని. ");
INSERT INTO vgr_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","తెదె ప్రభునా మే ష్యాత్‍ కరూ కరి పుఛవమా, ప్రభు తూ వూటిన్‍ ఆగడీ ధమస్కుమా జా; ఏజ్గా తూనా ష్యాత్‍ కరానూ ఛాకీ యో హాఃరు తూనా ఏజ్గా బోలావ్‍స్యే కరి మారేతి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","మన యో ఊజాళు దేకమా మే కాణో హుయిగో, మారకేడె ర్హవాళు మన ఛలైలిన్‍ ధమస్కుమా ఆయా. ");
INSERT INTO vgr_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","యత్రమా ధర్మషాస్ర్తం ప్రకార్‍ ఛాలుకరాతే ఏక్ భక్తిపరుడ్‍ యూదుల్‍ అఖ్కాతి అచ్చు నామ్‍ కమైరాక్యోతే అననీయ కరి ఏక్ జణో మారకనా ఆయి హిబ్రీన్‍, ");
INSERT INTO vgr_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","సౌల్‍ భైయ్‍, ఢోలానూ నజార్‍ లా కరి బోలిన్‍, యో క్చణామస్‍మన నజార్‍ ఆయిన్‍, ఇనా మే దేక్యో. ");
INSERT INTO vgr_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","తెదె యో అప్ను పితరుల్‍నో దేవ్‍ ఇనూ చిత్తంనా మాలంకరానాబి, యో నీతిమంతుడ్‍నా దేఖానాబి, ఇనూ మ్హోఢానూ వాతె హాఃమ్‍జానా హాఃజే తున నియమించిరాక్యోస్‍; ");
INSERT INTO vgr_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","తూ దేక్యోతే యో, హాఃమ్‍జ్యోతె యో అద్మీయే అఖ్కావ్‍నా హాఃమే ఇనా సాబుత్‍ హుయిరైస్‍. ");
INSERT INTO vgr_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","ఇనహాఃజే తూ ష్యాన ఆలస్యం కరస్‍? వుటీన్ దేవ్నా ప్రార్ధన కరీన్‍, బాప్తీస్మమ్‍ లీన్‍ తారు పాప్‍నా ధోయ్‍లా కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","తెదె మే యెరూషలేమ్‍మా ఫరీన్‍ ఆయిన్‍, ఆలయంమా ప్రార్ధనా కరూకరుతో మన దర్షనం ఆయూ ");
INSERT INTO vgr_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","ప్రభునా దేక్యో. తేదె యో తూ యెరూషలేమ్‍నా మ్హేందీన్‍ యగ్గిస్‍ జా; మారా హఃజే తూ దీస్‍తే సాబుత్‍ ఇవ్నే ఒప్‍స్యే కోయిని కరి మారేతి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","ఇనటేకె ప్రభు, మే హార్యేక్ సభ జోగొమా తూనా విష్వాసించ్యుతే యూవ్నా ఠాణావ్‍మా ఘలైన్‍ మార్తోహుయిన్‍ ర్హయోతే ఇవ్నా అసేల్తీ మాలం కరి జవాబ్‍ దిదో. ");
INSERT INTO vgr_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","బుజు తారు సాక్చి హుయిరహూయుతే స్తెఫన్‍న మర్యాక్యోతే తేదె మేబి ఇవ్నా ఖందే ఉబ్రీన్‍, ఇనా ఇమ్‍ కరన ఒప్పిన్‍, ఇనా మర్యూతే ఇవ్నా ఖూడ్తానా కవ్లీ ర్హయో కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","ఇనహాఃజే ప్రభువు తూ జా, దూర్‍ యూదుల్ కాహెతే ఇవ్నా కనా తూనా బోలీమొక్లీస్‍ కరి మారేతి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","ఆ వాత్‍తోడి అష్యల్‍ హాఃమాస్తూ హుయిన్‍ ర్హయూ. యత్రమా ఆమ్నూ అద్మి జీవానూ అర్హత్‍ కోయిని, జమీన్‍ఫర్‍ నార్హనూతిమ్‍ ఇనా మార్రాక్ను కరి కైఖార్‍ మ్హేంద్యు. ");
INSERT INTO vgr_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","యూవ్నే కైఖార్‍ మ్హేమ్‍థూ హుయిన్‍ యూవ్నా ఫర్‍ లుంగఢా ఝటాక్‍థూ హుయిన్‍, ఆకాష్‍ మ్హణీ ధూళ్‍ పాడీన్‍ నాఖూకరాతో, ");
INSERT INTO vgr_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","అవ్నే అనాఫర్‍ ఆత్రే కైఖార్‍ మ్హేంధాను కారణ్‍ ష్యాత్‍ కరి మాలంకరాన హాఃజే, రోమ అధికారి ఇనా కోల్డాతీ మారీన్‍, అనా పుచ్‍తాచ్‍ కర్నూ కరీన్‍ జాయిన్‍, కోఠడోమా లీజవో కరి ఆజ్ఞాదిదో. ");
INSERT INTO vgr_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","హుయుతో తెదె ఇవ్నే పౌలునా సీంద్రావ్‍తీ భాందుకరాతో యో ఇనా ఖందే హీబ్రూతే అధికారినా దేఖీన్‍, షిక్చ నాఖ్యాకో యింతేస్‍ ఏక్ రోమీయుడ్‍నా కోల్డావ్‍తి మారనా తుమ్నా అధికార్‍ ఛానా? కరి పుఛ్చాయో. ");
INSERT INTO vgr_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","అధికారి యో వాత్‍ హాఃమ్‍జీన్‍ రోమఅధికారి కనా ఆయిన్‍తూ ష్యాత్‍ కరుకురాస్‍? ఆ అద్మి రోమీడ్‍నో లా కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","తెదె రోమధికారి పౌల్‍ కనా ఆయిన్‍, ఇనా దేఖిన్‍ తూ రోమీయుడ్‍నా? యో మారేతి బోల్‍కరి బోలమా, యో వోహో కరి బోల్యొ ");
INSERT INTO vgr_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","రోమ అధికారి మే కెత్రాకీ రఫ్యా దీన్‍, యో రోమీయుడ్‍నూ నామ్‍ కమాయో; తెదె పౌలు హమరితి యో ఫైధావహ్‍ఃతూస్‍ రోమియుడ్‍ కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","ఇనహఃజే ఇనా పుచ్‍తాచ్‍ కర్నూ కరి దేఖ్యూతే యూవ్నే ఇనా యగ్గీస్‍ మ్హేంధిదూ. బుజు యో రోమీయుడ్‍ కరి మాలంహుయు తెదె యో ఇనా బంధీంచ్యుతే ఇనాటేకె రోమ అధికారి ఢరీగో. ");
INSERT INTO vgr_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","బుజాధన్నే, యూదుల్‍ ఇనాఫర్‍ నాఖ్యూతే నింద ష్యానూకి మాలంకర్నూ కరి రోమ అధికారి ఇనా మ్హేంధిన్‍, ప్రధానయాజకుల్‍నా, మహా సభమనూ హఃరుబి మళిన్ ఏక్ జోగో ఆవ్నూ కరి ఆజ్ఞాదీన్‍, పౌలునా లీన్‍ ఆయిన్‍ ఇనా హఃమే భిరాకాడ్యు. ");
INSERT INTO vgr_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","పౌలు మహాసభనూ అద్మీయేనా ధేఖిన్ ‍భైయ్యేవో, మే హాంకేతోడి కేవల్‍ ఏక్ అషల్ మన్‍తి దేవ్నా హాఃమే ఛాలుకర్తోతో కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","ఇనహాఃజే ప్రధానయాజక్‍ అననీయ ఇనా మోఢాఫర్‍ మారోల కరి ఇనా ఖందే బిర్యుతే యూవ్నా ఆజ్ఞాదిదో, ");
INSERT INTO vgr_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","పౌలు ఇనా దేఖీన్‍ చున్నో మార్యుతే భీత్‍, దేవ్‍ తూనా మార్సే; తూ ధర్మషస్త్రం ప్రకార్‍ పుచ్‍తాచ్‍ కరన బేసీన్‍, ధర్మషస్త్రంనా విరుద్దంథీ మన మారానా ఆజ్ఞా దీదోనా కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","తెదె ఖందే బిర్యుతే ఇవ్నే తూ దేవ్నూ ప్రధానయాజక్‍నా దూషించజైనా ");
INSERT INTO vgr_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","ఇనాహాఃజే పౌలు భైయే యో ప్రముఖ్‍ యాజక్‍ కరి మన మాలం కోయిని, తారు ప్రజల్నా అధికారినా నింద కరజైనా కరి లీఖైర్యూస్‍ కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","యూవ్నామా ఏక్ భాగ్‍ సద్దూకయ్యుల్‍, బుజేక్‍ భాగ్‍ పరిసయ్యుల్‍ ఛాకరీ పౌలు ఏన్‍ కరీన్‍ భైయ్యేవో, మే పరిసయ్యుడ్‍నో ఖాంధాన్‍నో; అప్నా ఛాతే నిరీక్చణనా టేకెబి, బుజు మర్యాహుయా జీవానూటేకేబి మన పుచ్‍తాచ్‍ కరూకరాస్‍ కరి సభమా ఘట్‍ చీక్రీన్‍ బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","సద్దూకయ్యుల్‍ మర్యాహుయానూ జీవిన్ ఉటానూ కోయిని కరి, దేవ్‍నూ దూతబి, ఆత్మబి కోయిని కరి బోలస్‍ పన్కి, పరిసయ్యుల్‍ భేహేబి ఛా కరి ఒప్పిలేస్‍. ");
INSERT INTO vgr_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","తెదె ఏక్ మోటు లఢాయ్‍ హూయుగు; పరిసయ్యుల్‍నూ బాజుమా ఛాతే షాస్ర్తుల్‍మా థోడు జణు వుటీన్ ఆ అద్మీమా హమ్నా కాయిబి ఖొః దేఖాయు కోయిని; ఇనేతి ఏక్ ఆత్మస్‍కీ దేవ్నూ దూతాస్‍కీ వాత్‍ బోలుహూస్యేతో బోల్యుస్‍బి హూస్యే కరి లఢాయ్‍ కర్‍లిదు. ");
INSERT INTO vgr_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","ఇమ్‍ లఢాయ్‍ ఘణు హుయుగు తెదె ఇవ్నే పౌలునా ఛీర్‍నాక్‍స్యే షీకీ కరి సహస్రాధిపతి ఢరీజైన్‍ తుమే జైన్‍ ఇవ్నామతు ఇనా జబర్‍జస్తితి ధర్లీఆయిత్రవో సైనికుల్నా ఆజ్ఞాదిదో. ");
INSERT INTO vgr_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","యో రాతే ప్రభువు ఇనా కనా హిభ్రిన్‍ హిమ్మత్‍థి ర్హా, యెరూషలేమ్‍మా మార గూర్చి కిమ్‍ బోల్యోకీ ఇమ్మస్‍ రోమ్‍మాబి సాక్చ్యం బొలానూ ఛా కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","వ్హాణు హుయుతేదె యూదుల్‍ హఃరు మలిన్‍, అప్నె పౌలునా మర్రాఖతోడి ఖాణు పాణీబి లీస్యు కోయిని కరి హోఃగత్‍ లీదా. ");
INSERT INTO vgr_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","ఆ కుట్రమా ఛాతే యూవ్నే భరోబర్‍ ఛాళీహ్‍ః థీబి గ్హణా థా. ");
INSERT INTO vgr_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","యూవ్నే ప్రముఖ్‍ యాజక్‍క నాబి, ష్యాణవ్‍ కనా ఆయిన్‍ హామే పౌలునా మారతోడీ హమే ష్యాత్‍బి ఛీమ్‍స్యు కోయిని కరి ఘట్‍ హోఃగత్‍ లీన్‍ ఛా. ");
INSERT INTO vgr_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","ఇనహఃజే తుమె మహాసభతి మలిన్‍, ఇనా గూర్చీ అజు గ్హణు మాలంకర్నూ కరీన్‍ ఇనా తూమార కనా లీన్‍ ఆవో కరి మనవి కర్యో; యో ఖందే ఆవనూ ఆగడీస్‍ ఇనా మర్రాఖనా సిద్దంగా ఛీయ్యే కరి బోల్యు. ");
INSERT INTO vgr_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","హుయుతో పౌల్‍ని జమై ఇవ్నే ఇనా మర్రాఖనా ఝఫీర్హతే వాత్‍ హఃమ్‍జీన్‍ కోఠడ్‍మా ఆయిన్‍ యో వాత్‍ పౌలునా బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","ఇనహఃజే పౌల్‍ షతాధిపతిమా ఏక్నా బులైన్‍ ఆ ఛొగర్వనా సహస్రాధిపతికనా బులైలీన్‍జా; ఆ ఇనేతి ఏక్ వాత్‍ బొలానూ ఛాకరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","షతాధిపతి ఇనా బులైలీన్‍ సహస్రాధిపతి కనా జైన్‍, ఖైది హూయోతే పౌల్‍ మన బులైన్‍, ఏక్ వాత్‍ బోల్నూ కరి ఛాతే ఆ న్హాన ఛోగర్వానా తార కనా బులైలీన్‍జా కరి మారేతి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","యో సహస్రాధిపతి ఇనూ హాత్‍ ధర్లీన్‍ ఫార్‍ బులైలీజైన్‍ తూ ష్యాత్‍ బోల్నూ కరి ఛాకీ యో వాత్‍ మారేతీ బోల్‍ కరి పుఛాయో. ");
INSERT INTO vgr_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","తెదె యో తూ పౌలునా హఃజే పూర్తిగా ఏన్‍ కరాహఃర్‍కూ ఇనా హూసీకరౌ మహాసభ కనా లీన్‍ ఆవ్నూ కరి తూనా గోజాఢనా టేకె యూదుల్‍ ఏక్ కట్టో భందైర్హస్‍. ");
INSERT INTO vgr_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","తూ యూవ్నీ వాత్‍నా ఒప్పిస్‍ నకో; యూవ్నామా ఛాళీహ్‍ః థీబి గ్హణుస్‍ అద్మీయే ఇనా హఃజే ఝపి ర్హాస్‍. ఇవ్నే ఇనా మర్రాఖతోడి యూవ్నే ఖాయిబి కోఖాస్యునికరి ఒట్టు లీరాక్యుస్‍; హాంకే తార కనా వాత్‍ లేనూ ఏదుర్‍ దేక్తాహుయిన్‍ సిద్దంగా ఛా కరీబోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","ఇనహఃజే సహస్రాధిపతి తూ ఆ వాత్‍ మన బోల్యొ కరి కినాబి నకో బోలిస్‍ కరి ఇనా ఆజ్ఞా దీన్‍ బోలి మొకల్‍ నాఖ్యో. ");
INSERT INTO vgr_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","ఇనబాద్‍మా యో షతాధిపతిమా బేజణనా బులైన్‍, కైసరయనా జవానా ఇన్నూర్‍జణా సైనికుల్నా హాఃడ్‍తీనీహ్‍ః ఘోడావ్‍నా, ఇన్నూర్‍ జణా యీటెల యూవ్నా రాతే నౌ భజేనా సిద్దమ్‍ కరీన్‍, ");
INSERT INTO vgr_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","పౌలునా ఛడైన్‍ అధిపతి హుయోతే ఫెలిక్సుకనా జత్తన్‍థీ లీజవాన టేకె ఘోడావ్‍నా సిద్దంకరో. ");
INSERT INTO vgr_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","బుజు అమ్మాస్‍ ఏక్ పత్రిక లిఖ్యో. ");
INSERT INTO vgr_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","మహా గౌరవంనో అధిపతి హుయోతే ఫేలిక్సునా క్లౌదియ లూసియ వందనాల్‍. ");
INSERT INTO vgr_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","యూదుల్‍ ఇనా ధరీన్‍ మర్రాఖూ కరతో యో రోమీయుడ్‍ కరి మే హఃమ్‍జీన్‍ సైనికుల్‍థీ ఆయిన్‍ ఇనా చుకాయో. ");
INSERT INTO vgr_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","యూవ్నే ఇనాఫర్‍ నాఖ్యూతె నింద ష్యాత్‍కీ మాలంకర్నూ కరి మే యూవ్నా మహాసభమా ఇనా లీన్‍ ఆయో. ");
INSERT INTO vgr_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","యూవ్నే యూవ్నూ ధర్మషాస్ర్తంనా టేకెస్‍ ఇనాఫర్‍ నిందనాఖ్యా గానీ మరణ్‍ నాహో, బందీ హూవానా యో ఇనా తగీన్‍నూ క్హయూబి నేరం ఇనా హఃమే ఖొః దేఖాయుని. ");
INSERT INTO vgr_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","కానీ యూవ్నే ఆ అద్మీనాఫర్‍ కుట్ర కరజౌంగ్రస్‍ కరి మాలం హువామా, ఇనా యగ్గిస్‍ ఇనా తార కనా బోలిమొక్‍ల్యొ. నింద నాఖ్యూ హుయుతో ఇనాఫర్‍ బొలానూ వాతె తార హఃమేస్‍ బోలానా ఆజ్ఞా దిదో. ");
INSERT INTO vgr_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","ఇనహఃజే యో యూవ్నా ఆజ్ఞాదిదో తిమ్‍ సైనికుల్‍ పౌల్‍నా అంపత్రికనా లీన్‍ రాత్నూ గయూ. ");
INSERT INTO vgr_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","బుజా ధన్నే యూవ్నే ఇనా కేడె రౌతుల్‍నా బోలిమొక్లీన్‍, యూవ్నే కోఠడ్‍మా ఫాచుపరీన్‍ ఆయూ. ");
INSERT INTO vgr_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","యూవ్నే కైసరయనా ఆయిన్‍ ఏజ్గాను అధిపతినా యో పత్రిక ఒప్పాయిన్‍, పౌలున్‍బి ఇన హఃమే భిరకాడ్యు. ");
INSERT INTO vgr_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","అధిపతి యో పత్రిక ఫడీన్‍ ఆ కేయో ఈలాఖోనూ అద్మికరి పుచ్ఛాయిన్‍ మాలంకర్లీన్‍, ");
INSERT INTO vgr_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","తారఫర్‍ నింద నాఖా వాళుబి ఆయుతేదె తారి సంగతీ ఏక్‍ధమ్‍ విచారించిస్‍ కరి బోలిన్‍, ");
INSERT INTO vgr_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","హేరోద్‍నూ హూఖంనూ మంధీర్‍మా ఇనా కావ్లీమా రాక్నూ కరి ఆజ్ఞాదిదూ. ");
INSERT INTO vgr_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","తెదె యూవ్నే ఫాచ్ ధన్నా బాద్‍మా ప్రముఖ్‍ యాజక్‍ హూయిరోతే అననీయబి, థోడుజణు ష్యాణాబి, తెర్తుల్లు కరి న్యాయం బోలావళో కైసరయనా ఆయిన్‍, పౌలుఫర్‍ ల్యాయుతే ఫీరాద్‍నా అధిపతినా మాలం కరాయా. ");
INSERT INTO vgr_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","పౌలు బులైమంగైన్‍ తెర్తుల్లు ఇనాఫర్‍ నేరం నాఖానూ సురు కరీన్‍ ఆం బోలానిక్ల్యా. మహా గౌరవంనో ఫేలిక్సా, హామే తారేతి కేత్రెకి షాంత్‍నా ఆలోచన కరూ కరీయేస్‍, బుజు ఆ దేహ్‍ఃనూ అద్మీయేనూ కీడ్‍ తారు విమర్షథీ దిద్దావం కరాస్‍ కరి ఒప్పిలిన్‍, ");
INSERT INTO vgr_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","హామే కేత్రూకూ రకం నూబి, జోగోవ్‍మాబి పూర్ణ కృతజ్ఞతథీ ఒప్పు కరీయేస్‍. ");
INSERT INTO vgr_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","మే తూనా ఛండాల్‍ నా ఛడావ్నూ తిమ్‍ హామే ధర్రాస్యు కరీన్‍ బీలియేతె ఇనా తూ ఆగడీంతర సాంత్‍థీ హఃమ్‍జ్నూ కరి వేడుకరుస్‍. ");
INSERT INTO vgr_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","ఆ అద్మి ఖారబ్‍జోణ్నూ, ఆ ములాక్‍మా ఛాతే యూదుల్‍ హఃరవ్‍నా లఢాయేనా హూషీ కరావవాళో, నజరేత్‍మా మతంనూ లఢాయేన్ కరిన్ నాయకుడ్‍ హుయిరోస్‍ కరి హామే హఃమ్‍జ్యా. ");
INSERT INTO vgr_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","బుజు ఆ దేవాలయంనా అపవిత్ర కరానా కోషీష్‍ కర్యో ఇనాహఃజే హామే ఆనా ధర్‍లీధా. ");
INSERT INTO vgr_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","తూ అనా విమర్షించ్యా తో ");
INSERT INTO vgr_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","హామే ఆనాఫర్‍ నాఖ్యాతే ఇంజామ్‍ హాఃరూబి తూనాస్‍ మాలంహూస్యే. ");
INSERT INTO vgr_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","యూదుల్‍ హాఃరూ ఏక్ హూయిన్‍ ఆ వాతె హఃరు హాఃఛీస్‍ కరి బోల్యా. ");
INSERT INTO vgr_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","తెదె అధిపతి పౌలునా ష్యాత్‍బి బోల్‍ని కరి సైగ్‍ కరమా, యో అమ్‍ బోల్యొ, తూ గ్హణా వరహ్‍ఃథూ ధరీన్‍ ఆ అద్మియేవ్‍నా నెయ్యో హుయిరోస్‍ కరి మాలంకరీన్‍, మే హిమ్మాత్‍తీ బోలుకరూస్‍. ");
INSERT INTO vgr_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","యెరూషలేమ్‍మా ఆరాధించనా గయోతే ధన్‍ థూ ధరీన్‍ ఖాలి భార రోజాస్‍ హూయా కరీన్‍ తూ విచారించిన్‍ మాలం కరాజై. ");
INSERT INTO vgr_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","దేవాలయ్‍మాహో, సభ జోగొమాహో, హాఃయార్‍ మాహో, బుజు మే కినేతిబి వాదనల్‍ కరానుహో, అద్మీయేనా భరైన్‍ భేహఃడానూ హో ఇవ్నే దేఖ్యాకోయిని. ");
INSERT INTO vgr_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","బుజు ఇవ్నే హంకే మారఫర్‍ నాఖ్యాతే ఇంజామ్‍నా తరా కనా రుజువుకర్సే కోయిని. ");
INSERT INTO vgr_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","ధర్మషాస్త్రమాబి, ప్రవక్తల్‍నూ గ్రంధాల్‍మా లిఖైరూతే హాఃరూబి నమ్మిన్‍, ఇవ్నే మతభేదం కరి నామ్‍ మ్హేందూ ఆ వాట్‍ ప్రకార్‍ అప్ను పితరుల్నూ దేవ్నా సేవించుకరుస్‍ కరి తూమార హఃమే ఒప్పి లేంగ్రూస్‍. ");
INSERT INTO vgr_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","అంనితరస్‍ నీతిమంతుడ్‍ వాళానాబి, అవినీతి వాళానాబి పునరుత్థాన్‍ హూస్యే కరి ఆవ్నే నిరీక్చించు కరాతిం మేబి దేవ్‍కనా నిరిక్చించిన్‍, ");
INSERT INTO vgr_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","అంనితర మేబి దేవ్‍కనాబి, అద్మీయేకనాబి కేదెబి మారు మన్‍ నిర్దోషుతార రావానటేకె మే షీకిలేంగ్రూస్‍. ");
INSERT INTO vgr_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","థోడు వరహ్‍ఃనా బాద్మా మే మారు స్వంత అద్మీయేనా దాన్‍ ధరమ్‍ కానుకల్‍ ధినఖనాటెకె ఆయోథో. ");
INSERT INTO vgr_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","మే సుద్ధి కర్‍లీన్‍ ఆం అప్పగించు కరుతో ఇవ్నే దేవాలయ్‍మా మన దేఖ్యు. మే గల్లో తార కర్యోకోయిని, మారేతి గలాఠా హుయుకోయిని. ");
INSERT INTO vgr_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","ఆసియాతూ ఆయూతే థోడు యూదుల్‍ థూ. మారఫర్‍ యూవ్నగాని ష్యాత్‍బి హూసేతో యూవ్నేస్‍ ఆయిన్‍ మారఫర్‍ ఇంజామ్ నాఖూకరాస్‍. ");
INSERT INTO vgr_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","నైతో, మే మహాసభనా హఃమే భిర్యోతే తెదె, మర్యుహూయు పునరుత్థాన్‍నూ గూర్చి ఆజ్‍ ఇవ్నా హాఃమే విమర్షించ బడుకరుస్‍ కరి, ");
INSERT INTO vgr_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","ఇవ్నా ఇఛ్మా భిరిన్‍ మే ఘట్‍ చిక్రీన్‍ బోల్యోతె ఆ విషయంనా టేకె తప్ప మారు అజు ఖయు ఇంజామ్‍ మాలంకర్యు హూస్యెతో ఆవ్నే తోబి బోలాజై. ");
INSERT INTO vgr_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","తెదే ఫేలిక్సు ఆ వాట్‍నా గూర్చి అసెల్తీ మాలం హుయిన్‍ రోమ అధికారి లూసియ ఆయోతెదె తూమారు సంగతి మే ఏన్‍ కరీన్‍ మాలంకరీస్‍ కరి బోలిన్‍ విమర్షనా భిరకాడు నాఖ్యు. ");
INSERT INTO vgr_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","బుజు ఇనా కావ్లీమా ఏకేలనా రాఖీన్‍, ఇనా సేవ కరన ఇనూ అద్మీయేనా ఆడే నకో బోలొ కరి అధికారి హూకం దిదో. ");
INSERT INTO vgr_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","థోడుధన్నా బాద్మా ఫేలిక్సు యూదుల్నిహుయీతె ద్రుసిల్లా కరి ఇని బావణ్‍తి ఆయిన్‍ పౌలునా బులైమంగైన్‍ క్రీస్తుయేసునూ విష్వాసంనా హాఃజే యో బోదించమా హాఃమాస్తా ర్హయా. ");
INSERT INTO vgr_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","తెదె యో న్యాయంనా గూర్చిన్‍బి ఆషా నిగ్రహ్‍నూ గూర్చీన్‍బి బుజు ఆవాజాసేతె న్యాయ ధన్నా హాఃజేబి బోదించు కరాతో ఫేలిక్సు ఢరీన్‍ అత్రు బైస్‍ అజు జా; మన వహాఃత్‍రైతో తునా బులైమంగైస్‍ కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","ఇనబాద్‍మా పౌలుతి ఇనా ధన్‍ మళ్‍స్యే కరి ఆఖ్ కరీన్‍ ఇనా గణితర బులైన్‍ ఇనేతి సంభాషణ్‍ కర్తోర్హయో. ");
INSERT INTO vgr_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","బే వరహ్‍ఃనా బాద్మా ఫేలిక్సునా బదుల్‍ పోర్కిబి ఫేస్తు ఆయు. తెదె ఫేలిక్సు యూదుల్‍నా హాతె అచ్చో అద్మి కరి బోలైలేను కరి ఆహ్‍ః కరీన్‍ పౌలునా బంధకంస్‍ మ్హేంధిన్‍ గయో. ");
INSERT INTO vgr_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","ఫేస్తు యో దేహ్‍ఃనూ అధికార్‍మా ఆయోతే తీన్‍ ధన్నా కైసరయ కంతు యెరూషలేమ్‍నా గయో. ");
INSERT INTO vgr_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","తెదె ప్రధానయాజకుల్‍బి యూదుల్‍మా ముఖ్యుల్‍ పౌలు ఫర్‍ యూవ్నే లాయూతే ఫిరాద్‍ని సంగతి పేస్తునా మాలంకరాయు. ");
INSERT INTO vgr_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","బుజు వాట్‍ఫర్‍ ఇనా మర్రాక్ను కరి జఫీరిన్‍ ఇనా యెరూషలేమ్‍నా బులైమంగౌ కరి ఇనా గూర్చీ ఫేస్తు కనా బోల్లిదు. ");
INSERT INTO vgr_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","ఇనహాఃజే ఫేస్తు, పౌలు కైసరయనూ కావ్లీమా ఛా; మే యగ్గిస్‍ ఏజ్గా జావనూ ఛా. ");
INSERT INTO vgr_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","ఇనటేకె తూమారమా నాయుకులు ర్హవాళా మారకేడె ఆయిన్‍ యో అద్మి కనా ఖయు తప్పు రైతోబీ ఇనాఫర్‍ నాఖాజై కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","యో ఏజ్గా ఆట్‍, ధహ్‍ః ధన్‍ యూవ్నా కనా ర్హైన్‍ కైసరయనా జైన్‍ బుజాధన్నే న్యాయ పీఠ్‍ఫర్‍ బేసిన్‍ పౌలునా లీన్‍ ఆవో కరి హూఖం దిదో. ");
INSERT INTO vgr_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","పౌలు ఆయో తెదె యెరూషలేమ్‍థూ ఆయూతే యూదుల్‍ ఇనా ఆష్పిష్‍ భరైన్‍, కేత్రెకీ కఠీన్‍ ఇంజామ్‍ ఇనాఫర్‍ నాఖా గాని ఇనా సాబుత్‍ కరనా యూవ్నా హాత్‍కోహుయిని. ");
INSERT INTO vgr_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","ఇనహాఃజే పౌలు యూదుల్ను ధర్మషాస్త్రంమా పన్కి, దేవాలయ్‍నూ గూర్చీ పన్కి, రోమా రాజోగూర్చీ పన్కి, మే ఆత్రేబి తప్పు కర్యోకోయిని కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","హుయుతో ఫేస్తు యూదుల్నా హాతె అచ్చో అద్మి కరి బోలైలేనూ కరి యెరూషలేమ్‍నా ఆయిన్‍ ఏజ్గా మార హాఃమే ఆ సంగతుల్‍ నా గూర్చి విచారించిన తూనా ఇష్టమస్నా? కరి పౌలునా పుఛాయో. ");
INSERT INTO vgr_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","ఇనహాఃజే పౌలు కైసర్‍ న్యాయపీఠ్‍న్‍ హాఃమే భిరిరోస్‍; మే విచారించ బడానూ జోగో ఆస్‍, యూదుల్‍నా మే ఖయు అన్యాయం కర్యో కోయిని కరి తూనా అసేల్తి మాలం. ");
INSERT INTO vgr_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","మే అన్యాయం తప్పి మరణ్‍ షిక్చ ఏత్రె ఖయుబి కర్యొహూసేతో మరానాబి హాటీస్‍ కోయిని; ఆవ్నే మారఫర్‍ నాఖూ కరాతే ఇంజామేమా ఖయూబి హాఃఛీ నాహూయుతో మన యూవ్నా అప్పగించనా కినా హాత్‍బి కోహూసేని; రోమరాజొ హాఃమేబి బోల్లీస్‍ కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","తెదె ఫేస్తు ఇనూ సభనూ అద్మీయేతి హూఃజ్‍ కరనా బాద్మా రోమ‍రాజోనా హాఃమే జీయ్యే, కరి బోలోకున్నా రోమరాజో కన జీయ్యే కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","థోడధన్నా బాద్‍మా రాజో హూయోతే అగ్రిప్పబి బెర్నీకేబి ఫేస్తు దేకిన్‍ బోలవాలన హాఃజే కైసరయనా ఆయా. ");
INSERT INTO vgr_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","ఇవ్నే ఏజ్గా కెత్రాకీ ధన్‍ ర్హవమా, ఫేస్తు పౌలునూ సంగతి రాజోనా మాలంకరాయో; ష్యాత్‍ కతో ఫేలిక్సు మ్హేంధి చలీగోతే ఏక్ ఖైది ఛా. ");
INSERT INTO vgr_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","మే యెరూషలేమ్‍మా ర్హయోతేదె ప్రధాన యాజక్‍బి యూదుల్‍ను మోట్ట ష్యాణ ఇనాఫర్‍ ల్యాయతే ఫీరాద్‍నా మాలంకరైన్‍ ఇనా షిక్చ నాఖౌనూ కరి వేడిల్దు. ");
INSERT INTO vgr_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","ఇనహాఃజే మే ఇంజామ్‍ నాఖ్యో హుయుబి, నఖైహూయోబి ఆయిన్‍ మోఢానా హాఃమే ఇనాఫర్‍ నఖైరూతే ఇంజామ్‍ నా హాఃజే యో సమాధాన్‍ బోలాన అవకాష్‍ దేవాన ఆగడీ ఖయూ అద్మీయేనాబి అప్పగించనూ రోమియుల్‍నా ఆచార్‍ కాహేకరీ ఉత్తర్‍ దిదో. ");
INSERT INTO vgr_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","ఇనహాఃజే ఇవ్నే అజ్గ భరైన్‍ ఆయుతేదె మే అలస్యం నాకర్నూ తిమ్‍, బుజా ధన్నే న్యాయ పీఠ్‍ఫర్‍ బేసిన్‍ యో అద్మినా లీన్‍ ఆవో కరి హూఖం దిదో. ");
INSERT INTO vgr_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","ఇంజామ్‍ నాఖ్యుతె ఇవ్నే భిరిగు తేదె, మే రైగోతే ఇంజామ్‍మా ఏక్‍బి ఇనాఫర్‍ నాఖ్యుతె ఇవ్నే కాహే. ");
INSERT INTO vgr_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","హుయుతో ఇవ్ను మతంనా హాఃజే, మరీగయోతే యేసు కరి ఏక్నా హాఃజే అనేతి ఇవ్నేతి థోడు లఢాయే ర్హవానింతర దేఖాయు. హుయుతో యోయేసు జీవ్తోస్‍ ఛాకరీ పౌలు బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","మే ఇమ్నూ వాదనల్‍నా కిమ్‍ విచారించ్నూకీ కాయిబి తోచవకోయిన్తే, యెరూషలేమ్‍నా జైన్‍ ఏజ్గా ఆనా హాఃజే విమర్షించనా పౌలు ఇష్ట పడాస్‍షీకీ కరి పుఛాయో థో. ");
INSERT INTO vgr_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","హుయుతో పౌలు, చక్రవర్తి విమర్షనినా ఇనా భిరకాణ్నూ కరి బోల్లేవమా మే ఇనా రోమరాజో కనా బోలీమొక్‍లా తోడి హుభర్కును కరి ఆజ్ఞ దిదో కరి బోల్యొ మానవి కర్లిదో. ");
INSERT INTO vgr_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","ఇనటేకె అగ్రిప్ప యో అద్మి బోల్‍స్యేతే మేబి హాఃజ్నుకరీ ఫేస్తుథీ బోలమా యో కాల్‍ హాఃజాజై కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","ఇనహాఃజే బుజాధన్నే అగ్రిప్పబి బెర్నీకేయు ఘణు ఆడంబర్‍తీ ఆయిన్‍, సైనికుల్నా అధికారి తి హాఃయార్‍నూ ప్రముఖుల్తీ మోట్టో సభ ఘార్ ‍జవాను బాద్మా ఫేస్తు హూఖం దేవామా పౌలునా బులైమంగయా. ");
INSERT INTO vgr_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","తెదె ఫేస్తు, అగ్రిప్ప రాజా ఆజ్గా హామారేతీ ఛాతే హాఃరూ జణా, తుమె ఆ అద్మినా దేఖూకరాస్‍. యెరూషలేమ్‍మాబి అజ్గాబి యూదుల్‍ హాఃరు ఆ అజు నాజివ్నుకరి అధికార్‍ కోయిని కరి కైఖార్‍ మ్హేన్‍థూ హుయిన్‍ ఇనాఫర్‍ మారేతి మనవి కర్‍లిదు. ");
INSERT INTO vgr_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","ఆ మరణ్‍నా తగిన్‍నూ ఖయూబి కర్యుకోయిని కరి మే మాలంకరీన్‍, ఆ జారొనా హాఃమే బోలిస్కరీ బోలమా ఇనా బొలిమొకల్‍నూ కరి రైగో. ");
INSERT INTO vgr_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","ఆనా గూర్చీ అప్నో యేలినా వాడ్‍నా లిఖ్కానా కాయిబి దేఖాయు కోయిని ఇనహాఃజే విచారించదీన్‍ లిఖ్కానా ష్యాత్‍బి మన మళ్‍సే కరి తూమార హాఃమేబి, అగ్రిప్ప రాజో, ముఖ్యం తూమార హాఃమేబి, ఆనా బులైమంగై రాక్యోస్‍. ");
INSERT INTO vgr_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","ఖైదినా ఫర్‍ నాఖ్యూతే ఇంజామ్‍నా నావివరించ్ను తిమ్‍ ఇనా బోలిమొక్‍లాను అసేల్‍ కాహే కరి మన తోచుకరాస్‍ కరి బోల్యు. ");
INSERT INTO vgr_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","అగ్రిప్ప పౌలు మ్హణీ దేఖీన్‍ తారు బాజు బోలిలేవాన తునా ఆవకాష్‍ ఛా కరి బోల్యొ. తెదె పౌలు హాత్‍ పాడీన్‍ అమ్‍ బోలనిక్యో. ");
INSERT INTO vgr_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","ఇనటేకె యూదుల్‍ మారఫర్‍ నాఖ్యూతే ఇంజామ్‍ హాఃరవ్‍నా గూర్చీ ఆజ్‍ తూమార హాఃమే సమాధాన్‍ బోలుకరూస్‍తే మే ధన్యుడ్‍ కరి రైజోంగ్‍రూస్‍; అనటేకే మేబి తార ఖామే బొలిలేంకురుస్‍ ");
INSERT INTO vgr_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","తూ యూదుల్‍మా ఛాతే సమస్త ఆచారాల్‍ వివాదాల్‍బి అసేల్తీ మాలంకర్‍రాక్యోస్‍ తాల్మిథీ మారు మనవి హాఃమజ్ను కరి వేడుకరూస్‍. ");
INSERT INTO vgr_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","ఆగడీథూ యెరూషలేమ్‍మా మారు దేహ్‍ఃను ఇఛ్మా మారు అఢ్డాని ఫర్‍థూ మే జీయోతే జీవ్‍ణు కీమ్‍నూకీ యూదుల్‍ హాఃరవ్‍నా మాలం. ");
INSERT INTO vgr_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","ఇవ్నే ఆగడీతూ మన మాలంకర్యు హూయు కాబట్టి సాబుత్‍ దేవాన యూవ్నా ఇష్టం హూసేతో మే మారు మతంమనూ ఘణుమాలంహుయూహు జాత్‍నా ప్రకార్‍ ఛాలీన్‍, పరిసయ్యుడ్‍నితర ప్రవర్తించనితర బోల్‍స్యు. ");
INSERT INTO vgr_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","హాంకేహుయుతో దేవ్‍ అప్నా పితరుల్‍నా కర్యోతే వాగ్దన్‍నూ విషయంనూ నీరిక్చణ్‍నా గూర్చీ మే విమర్షింప బడనా హాఃజే మే భీరీరోస్‍. ");
INSERT INTO vgr_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","అప్ను భార గోత్‍నూ యూవ్నే విసక్నూ నాతిమ్‍ ఎక్కస్ రాత్‍ దేవ్‍నా హమేషా సేవిస్తూ హూయిన్‍ యో వాగ్దన్‍ పోంద్‍స్యు కరి నిరిక్చించు కరాస్‍. ఓ రాజో ఆ నిరీక్చణ్‍నూ విషయంమస్‍ యూదుల్‍ మారఫర్‍ ఇంజామ్‍ నాఖ్యు రాక్యుస్‍. ");
INSERT INTO vgr_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","దేవ్‍ మర్యుహుయునా ఉఠాడ్‍సేతే సంగతి నమ్మనూ కాహే కరి తుమె కిమ్‍ యేంచుకరాస్‍? ");
INSERT INTO vgr_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","నజరేయుడ్‍నో యేసునూ నామ్‍థీ ధావోతి కెత్రూకి మే కామ్‍ కర్నూ కరి రైగో. ");
INSERT INTO vgr_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","యెరూషలేమ్‍మా మే ఇమ్మస్‍ కర్యోథో. మే ప్రధాన యాజకుల్‍తి అధికార్‍ లీన్‍, దేవ్ను అద్మి హాఃరవ్నా చెరసాల్‍మా నాఖీన్‍, ఇవ్నా మార్యుతేదె ఒప్పి గయోథో ");
INSERT INTO vgr_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","కెత్రూకి చోట్‍ సభ జోగోమా ఇవ్నా ఢరైన్‍ ఇవ్నా హాతేస్‍ దేవ్నా దూషించహాఃర్‍కు కర్తోథో. జోర్‍ కరనా దేక్తోథో. బుజు ఇవ్నాఫర్‍ ఘణు ఛండాల్‍ వాళో హూయి అలదు హాఃయారేవ్‍మా జైన్‍ ఇవ్నాబి హాఃతావ్ కర్యో. ");
INSERT INTO vgr_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","ఇనహాఃజె మే ప్రధాన యాజకుల్‍నా హాతె అధికార్‍బి, హూఖం లీన్‍ ధమస్కునా జౌంకరతో ");
INSERT INTO vgr_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","రాజో ధోఫర్ను వోహాఃత్‍ మార ఆష్పిష్‍బి మారకేడె అయూతే యూవ్నా ఆష్పిష్‍ ఆకాష్ థూ సూర్యుడ్‍నూ తెజస్సుథీబి ఘణూ జమ్కాత్తు ఏక్ ఊజాళు వాట్‍ఫర్‍ ఆవానూ దేఖ్యో. ");
INSERT INTO vgr_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","హామె హాఃర జమీన్‍ఫర్‍ పడీగయాతేదె సౌల్‍, సౌల్‍ తూ ష్యాన మన హాఃతావ్‍ంకరాస్‍? మునికోలల్‍నా హాఃమే మారనూ తూనా ఇష్టం కరి హెబ్రీ భాషామా మారేతి బోల్యుతే ఏక్ ఆవాజ్‍నా హాఃజో, దాండో ఇను బందుతే కల్డినా మార్యుతో దాండానాస్‍ మార్లగ్సే. ");
INSERT INTO vgr_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","తెదె మే, ప్రభు తూ కోన్‍ కరి పుఛ్చావమా తూ హాఃతావ్‍ంకరాతే యేసు. ");
INSERT INTO vgr_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","పన్కీ, తూ దేఖ్యోతే సంగతి, మే తూనా దేఖాయోతే సంగతి, తూనా పరిచార్‍ కరావాళో నింతర, సాబుత్‍నితర నియమించ నాటేకే దేఖైరోస్‍. తూ వుటీన్‍ తార గోఢా ఘట్‍ మ్హెందిన్‍ హుభర్‍; ");
INSERT INTO vgr_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","మే ఆ ప్రజల్‍ థీ హో, యూదుల్‍కాహెతె థీహో తూనా ఖయూ హాని నా హోణుతిమ్‍ బఛైస్‍. ");
INSERT INTO vgr_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","ఇవ్నే అంధారమథూ ఊజాళమా సైతాన్‍నూ అధికార్‍మతూ దేవ్‍ మ్హణీ ఫరీన్‍, మారమ విష్వాషంతి పాప్‍ మాపి, పరిసుద్ధ్‌ దేవ్ను అద్మిహూయుతే ఇవ్నామా స్వాస్థ్యం పోందనా హాఃజే ఇవ్నా డోలా ఖఢావనాటేకె మే తూనా ఇవ్నా కనా బోలిమొక్లీస్‍ కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","“ఇనహాఃజే అగ్రిప్ప రాజో, ఆకాష్‍థూ హూయూతే యో దర్షన్‍నా మే అవిధేయుడ్‍ నాహూయిన్‍, ");
INSERT INTO vgr_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","ఆగడీ ధమస్కు వాళానా, యెరూషలేమ్మాబి యూదయ దేహ్‍ఃమాబి, ఇనబాద్‍మా యూదుల్‍ కాహేతె, యూవ్నే మారు మనస్సు లీన్‍ దేవ్‍ మ్హణీ ఫరీన్‍ మారుమనస్సునా తగిన్‍నూ కామ్‍కర్నూ కరి ప్రచార్‍ కర్తో ర్హయో. ");
INSERT INTO vgr_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","ఆ కారణంతి యూదుల్‍ హాఃరూ దేవాలయ్‍మా మన ధరీన్‍ మర్రాక్ను కరి కోషీష్‍ కర్యా ");
INSERT INTO vgr_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","హూయుతోబి మే దేవ్నూ మదత్‍ లీన్‍ ఆజ్ తోడీ భిరోస్‍; ప్రవక్తల్‍బి మోషేబి ఆగడీస్‍ బోల్యుతే కాహేతిమ్‍ కరీఅజు ఖయూబి నాబోలిన్‍, అల్పుల్‍నా ఘనుల్‍నా సాక్చ్యం దేతోర్హయో. ");
INSERT INTO vgr_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","క్రీస్తు మ్హీనత్‍ పడీన్‍ మర్యా హూయామా జీవీ ఉఠ్‍స్యేతే యూవ్నామా ఆగడీహూవమా ఇనహాఃజే ఆ ప్రజల్‍నా యూదుల్కాహెతెనా ఊజాళు ప్రచుర్‍ హూసే” ");
INSERT INTO vgr_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","యో ఇమ్‍ వాతె బోల్తో ర్హవమా ఫేస్తు, పౌలా తూ జాహఃత్‍ ఫడీన్‍ పాఘాల్‍ అద్మి, ఘణూ ఫడాయి కర్యో ఇనహాఃజే తూనా పాఘాల్‍ ఛడీగుకరీ మోటు ఆవాజ్‍తి చీక్రీన్‍ బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","ఇనహఃజే పౌలు అమ్‍ బోల్యొ, నామ్‍ గౌరవంహుయోతె ఫేస్తు, మే పాఘాల్‍ కాహే పన్కి హఃచి అచ్చుబుద్దిథీ వాతేనస్‍ బోలుకరూస్‍. ");
INSERT INTO vgr_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","రాజోనా ఆవాత్‍ మలం ఇనహాఃజే మే ఇనహఃమే భీరీన్‍ వాత్‍ బోలుకరూస్‍; ఇనమా ఏక్బి ఇనా మాలంనాహూనూ తిమ్‍ ధబిర్యూస్‍ కోయిని కరి మే ఖచ్చితంగా నమ్ముకరుస్‍; ఆ ఏక్ రహస్యంతి జర్‍గ్యూతే వాత్ కాహే. ");
INSERT INTO vgr_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","అగ్రిప్ప రాజో, తూ ప్రవక్తల్‍నా నమ్ముకరాస్‍నా? నమ్ముకరాస్‍ కరి మన మాలం. ");
INSERT INTO vgr_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","ఇనహాఃజే అగ్రిప్ప, అత్రే సులభంగా మన క్రైస్తవుడ్‍ నితర మన కర్నూ కరి దేఖూకరాస్‍ని కరి పౌల్‍తి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","ఇనటేకె పౌల్‍, సులభంథీస్‍కీ, కారబ్ థీస్‍కీ తూ మాత్రం కాహే గాని, ఆజ్‍ మారు వాత్‍ హాఃజా వాళు హాఃరూబి ఆ బంధక్‍ మాతు తప్ప మారుతార ర్హవాహాఃర్‍కూ దేవ్‍ అనుగ్రహించ్నూ కరి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","ఎత్రమా రాజోబి అధిపతిబి బెర్నీకేయు యూవ్నేతి భెటుతే యూవ్నేబి వుటీన్‍ పార్‍ జైన్‍ ");
INSERT INTO vgr_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","ఆ అద్మి మరానహో, భందై ర్హవానబిహో ఇనా ఏత్రె ఖాయిబి కోకర్యోని కరి యూవ్నామా యూవ్నే వాత్‍ బోల్లిదా. ");
INSERT INTO vgr_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","ఇనటేకె అగ్రిప్ప ఆ అద్మి రోమరాజొతి హఃమే బోల్లేవ్‍స్‍ కరి నా బోల్యుహోత్‍తో అనా ఛుట్కార కర్యాహోత్‍ కరి ఫేస్తుతీ బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","హామే ఝాజ్‍‍ చఢీన్‍ ఇటలీ జానూ కరి సోచీల్దో తెదె, ఇవ్నే పౌలునా బుజు థోడు జణు ఖైదిల్‍నా రోమ రాజో సైన్య అధికారి హూయోతే యూలి కరి ఏక్ జణానా అప్పగించ్యా. ");
INSERT INTO vgr_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","ఆసియానా సేడె ఛాతె హాఃయారేవ్‍నా జావాళు అద్రమత్తియ హాఃయర్‍నూ ఝాజ్‍ చఢీన్‍ హామే నిక్యా; మాసిదోనియుడ్‍నూ థెస్సలోనిక హాఃయార్‍నో అరిస్తార్కు హామార కేడె థో. ");
INSERT INTO vgr_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","తినబుజా ధన్నే సీదోన్‍నా ఆయా. తెదె యూలి. పౌల్‍ఫర్‍ గోర్‍ కరీన్‍, యో ఇనూ దోస్తుల్‍ కనా జైన్‍ పాల్‍పోందన హాఃజె ఇనా జా కరి బోల్యు. ");
INSERT INTO vgr_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","బుజు ఏజ్గాతూ నికనబాద్మా హాఃమెను వాయిరో మారామా కుప్రనా జోగొ ఝాజ్‍నా ఛలాయా. ");
INSERT INTO vgr_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","బుజు కిలికియనాబి పంపూలియాన హాఃమే ఛాతె ధర్యావ్‍ దాటీన్‍ లుకియమా ఛాతే మూరకు గయా. ");
INSERT INTO vgr_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","ఏజ్గా సైన్యాధికారి ఇటలీ జానుకరి ఛాతె అలెగ్జాండ్రియ హాఃయార్‍నూ ఝాజ్‍ మాలంకరీన్‍ హామ్నా ఇనమా చఢయు. ");
INSERT INTO vgr_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","కెత్రాకీ ధన్ ఢీలె చాలిన్‍, కెత్రూకి మ్హీనత్‍ పడీన్‍ క్నీదు హఃయర్నా హాఃమే ఆయా తెదె వాయిరో హామ్నా నాజవాదేవమా క్రేతునా జోగొ కరి సల్మోనేనా సేడే కరి ఝాజ్నా ఛలాయా. ");
INSERT INTO vgr_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","ఘను మిన్హత్‍ పడీన్‍ ఇనా డాటీన్‍, అష్యల్‍నుజోగొమా గయా. ఇనాసేడె లసైయ కరి హాఃయార్‍ థూ. ");
INSERT INTO vgr_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","ఘణా ధన్‍ హూవానా బాద్మా ఉపాస్‍నూ ధన్బి తెదేస్‍ హూయిజవామా ప్రయాణం కరన ముసిభత్మా థూ. ");
INSERT INTO vgr_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","తెదె పౌల్‍ హఃయాబ్, ఆ ప్రయాణంథీ హాఃమాన్‍నాహో, ఝజ్‍నస్‍ కాహేతిమ్‍ అప్ను జాన్‍నబి ఖత్రాబి నుక్‍షాన్‍ హూసే కరి మన సోచాంగ్రస్‍ కరి బోలిన్‍ గుర్కాయో. ");
INSERT INTO vgr_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","హుయుతోబి సైన్యాదికారి పౌల్‍ బోల్యొతె నానమ్మిన్‍, ఝాజ్‍ ఛలావవాళో నావికుడ్‍నుబి, ఝాజ్‍నూ మాలిక్‍ బోల్యుతేస్‍ నమ్యు. ");
INSERT INTO vgr_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","రుజు ఠణ్నూధన్‍ గుజారనా యో రేవు అనుకూల్‍నా హూవామా ఏజ్గాథూ నాకీన్‍ వీల్‍హుయుతో ఫీనిక్సునా జైన్‍ ఏజ్గా ఠణ్‍నా ధన్‍ కాఢీయే కరి ఘణా అద్మీయే హూఃజ్‍ బోల్యా. యో నైరుతి వాయవ్వదిక్కు మ్హణీ ఛాతే క్రేతు రేవుమా థూ. ");
INSERT INTO vgr_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","బుజు నూ వాయిరో ఢీలే వాగుకరమా ఇవ్నే ఇవ్నూ హూఃజ్‍ అసేల్‍నూ కాహే కరి సోచిన్‍ లంగరేత్తిన్‍ క్రేతునా సేడె ఝాజ్‍నా ఛలాయా. ");
INSERT INTO vgr_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","థొడు వోహాఃత్‍నా బాద్‍మా ఊరకులోను కరి ఏక్ మోటో వాయిరో క్రేతునా వుఫర్‍ కరి మార్యు. ");
INSERT INTO vgr_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","ఇనమా ఝాజ్‍ ఫసిజైన్‍ వాయిరోనా హాఃమే జవానకో హూయినితె అగడీ జవానా మ్హేంధిన్‍ వాయిరోమా మర్లీఛలేగా. ");
INSERT INTO vgr_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","బాద్మా కౌద కరి ఏక్ న్హానూ ద్వీపంనా బాజూమాకరీ ఇనా ఛలావమా పడవనా భచైలేవనా ఘాణు ముష్కీల్‍ హుయిగు. ");
INSERT INTO vgr_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","ఇనా ఉఫర్‍ పాడీన్‍ భాందనా బాద్‍మా షింద్రా హాఃరులీన్‍ జ్హాజ్‍నా ఆష్పీస్‍ ఘట్‍ లప్టీన్‍ భాంద్యా. బుజు సూర్తిస కరి రేతినూ ఉడ్డోఫర్‍ పడ్‍స్యుషికి ఢరీన్‍, జ్హాజ్‍నూ ఛాద్రీయే వుతారీన్‍, మర్లీ ఛలీగు. ");
INSERT INTO vgr_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","ఘణు వాయిరో వాగ్‍తూ ర్హవమా బుజాధన్నే హాఃమాన్‍ హాఃరూ భార్‍ ఫేఖానిక్యు. ");
INSERT INTO vgr_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","తీన్మాను ధన్నే ఇవ్నా హాతేహూఃస్‍ ఝాజ్‍నూ రాఛాబి ఫేకీదిదూ. ");
INSERT INTO vgr_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","థోడు ధన్‍ సూర్యుడ్‍బిహో, షుక్కార్‍బిహో నాదేఖైన్‍ మోటు వాయిరో హామారఫర్‍ మారమా జాన్‍థీ భచీజాస్యుకరీ ఆహాఃస్‍ ఛలీగు. ");
INSERT INTO vgr_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","యూవ్నే ఘణా ధన్‍ ఖాణు కోయింన్తె ర్హవామా పౌల్‍ యూవ్నా ఇఛ్మా భిరిన్‍ హాఃయాప్‍వో, తుమే మారు వాత్‍ హాఃమ్‍జీన్‍ క్రేతుథూ నానికాన్‍థూ. తెదె ఆ ఖత్రా, నుక్చాన్‍ కోహుయు హోత్‍ని. ");
INSERT INTO vgr_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","హాంకేతోబి హిమ్మత్‍ లాయిలేవో కరి తూమ్‍నా గింజుకరుస్‍; ఝాజ్‍నా తప్ప తూమారమా కినాబి జాన్‍నా ఖత్రా కోహూయుని. ");
INSERT INTO vgr_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","మే కీనోకీ, కినా సేవకరుకరుస్‍కీ, యో దేవ్‍నూ దూత ఛలీగుతే రాతే మార కనా భిరిన్‍, ");
INSERT INTO vgr_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","పౌల్‍ ఢర్‍నకో; తూ రోమరాజు హాఃమే భిరాను ఛా; హాధేక్‍ ఝాజ్‍మా బయల్దేరిర్యూతే ఇవ్నే హాఃరవ్‍నా దేవ్‍ తూనా ధీ రాక్యోస్‍ కరి మారేతి బోల్యు. ");
INSERT INTO vgr_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","ఇనహాఃజే హాఃయాప్‍వో, హిమ్మత్‍ లాయిలేవో; మారేతి బోల్యుతిమ్‍ జరగ్‍సే కరి మే దేవ్నా నమ్ముకరుస్‍. ");
INSERT INTO vgr_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","హూయుతోబి అప్నె మర్లీజైన్‍ ఖయూబి ఏక్ ద్వీపంఫర్‍ ఫడానూ ఛా కరి బోల్యు. ");
INSERT INTO vgr_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","ఛౌధమనూ ధన్నా రాత్‍ ఆయుతేదె హామే అద్రియ మద్యధరా ధర్యావ్‍మా హంఖడ్‍ హీంఖడ్‍ మర్లీ జౌంకరాతో ఆధిరాత్‍మా ఝాజ్‍నూ అద్మీయే ఖయూకీ ఏక్ దేహ్‍ః సేడే ఛా కరి వుహించి ");
INSERT INTO vgr_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","బుడుదు భొజొ నాఖిన్‍ దేఖమా ఏక్‍ ఖోః ఈహ్‍ః అడుగు ఘధార్‍ ఛాకరీ మాలంకర్యు. బుజున్‍బి థోడు దూర్‍ జవాన బాద్‍మా, బుజు బుడుదు నాఖిన్‍ దేఖమా చార్‍ఈహ్‍ః అడుగు ఘధార్‍ ఛాకరీ మాలంకర్యు. ");
INSERT INTO vgr_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","తెదె ఫత్రానూ తిప్పల్‍నూ జోగొ పడ్‍స్యుకీ షీకి కరి ఢరీన్‍, యూవ్నే జ్హాజ్‍నూ మైహ్‍ తూ చార్‍ లంగరుల్‍ నాఖిన్‍ కెదె వ్హాణహు హూసే కరి కాస్లీన్‍ థూ. ");
INSERT INTO vgr_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","హుయుతో ఝాజ్‍నూ అద్మి ఝాజ్‍ మ్హేందిన్‍ నాషీజానూ కరి దేఖీన్‍, ఇవ్నే అనివిమథూ లంగరు నాఖాంతర నానుఝాజ్‍నా ధర్యావ్‍మా ఉత్రాయి నాఖ్య. ");
INSERT INTO vgr_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","ఇనహాఃజే పౌలు అవ్నే ఝాజ్‍మా ర్హయ్యాతోస్‍ పన్కి తుమె ఛుఖైలీషూ కోయిని కరి సైన్యాధిపతి, సైనికుల్‍థి బోల్యు. ");
INSERT INTO vgr_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","ఎగ్గిస్‍ సైనికుల్‍ ఝాజ్‍ షీంధ్రా వ్హాడీన్‍ ఇనా మర్లీ జవాదిదూ. ");
INSERT INTO vgr_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","వ్హాణు హూంకరాతో పౌల్‍ ఛౌధ రోజ్‍థూ తుమె కాయిబి నా ఖైన్‍ ఉపాస్‍థి కాస్లీన్‍ ఛా. ");
INSERT INTO vgr_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","ఇనటేకె ఖాణు ఖవో కరి తూమ్‍నా మంగిలేకురుస్‍; ఆ తూమారు జాన్‍నా భచావనా మధత్‍హూసే. తూమారమా కినా ముఢ్‍క్యానూ ఏక్ కేహ్‍ఃతోబి నషించే కోయిని కరి బోల్తోహూయిన్‍, ఖాణు ఖవో కరి హాఃరవ్‍నా బతిమాల్యు. ");
INSERT INTO vgr_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","ఆ వాతె బోలిన్‍, ఏక్ రోటొ పాడీ ధర్లీన్‍ హాఃరవ్‍నా హాఃమే దేవ్‍నా కృతజ్ఞత దీన్‍ ఇనా తోఢీన్‍ ఖవాన గయూ. ");
INSERT INTO vgr_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","తెదె హాఃరు హిమ్మత్‍ లాయిన్‍ ఖాణు ఖవానిక్యు. ");
INSERT INTO vgr_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","ఝాజ్‍మా ఛియ్యేతే హామే హాఃర భేఖొః ఖడ్తిన్ ఫర్ ఛో జణా. ");
INSERT INTO vgr_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","ఇవ్నే హాఃరు ఖైన్‍ జాన్ దరిన్ బాద్‍మా, ఘౌనా ధర్యావ్‍మా ఫేఖినాఖిన్‍ జ్హాజ్‍నా హాల్కు కర్యా. ");
INSERT INTO vgr_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","వ్హాణు హుయుతేదె యో ఖయూ దేహ్‍ఃకీ యూవ్నే హాఃణాత్‍ ధర్యా కోయిని, పన్కి ఖందేనూ ఏక్ ధర్యావ్‍నూ ఏక్ పాయ్‍న దేఖిన్‍, హూవా ఏత్రే జ్హాజ్‍నా ఇనామా ధఖల్‍నూ కరి సోచ్యు. ");
INSERT INTO vgr_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","ఇనటేకె లంగరుల్‍నూ షింధ్రా వ్హాడీన్‍ ఇనా ధర్యావ్‍మా మ్హేందిన్‍ చుక్కానుల్‍నూ కట్లు ఛోడిన్‍ హాఃమేనూ తేరానూ ఛాద్రీనా వాయిరోనా ఉఫర్‍పాడిన్‍ హాఃమే ఛలాయా పన్కీ ");
INSERT INTO vgr_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","బే ఛాల్‍తుపాణిమా రేతిను జోగొమా అట్కీజైన్‍ ఝాజ్‍నా మెట్ట ధరాయు. ఇనహాఃజే ఝాజ్‍నూ అగ్లు భాగ్‍ పహిఃజైన్‍ హాల్యు కోయిన్‍తిమ్‍ రైగు, పాష్లు భాగ్‍ పాణీను జుఖాళోనా మార్‍నా బద్దల్‍ హుయి జవామతూస్‍. ");
INSERT INTO vgr_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","ఖైదిల్‍మా ఏక్ జణుబి తిరాక్‍ మారిన్‍ నా ఛుఖైలేనూతిమ్‍ ఇవ్నా ధరీన్‍ మర్రాక్‍ దేనూ కరి సైనికుల్నా సోచ్‍మా ఆయు పన్కీ ");
INSERT INTO vgr_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","సైన్యాధికారి పౌల్‍నా భచావ్‍నూ కరి సోచీన్‍ ఇవ్నూ సోచ్‍ నాహువదేనూ తిమ్‍, అగడీ తిరాక్‍ మారవాళు ధర్యావ్‍మా కూధిన్‍ భార్‍ ఠగర్‍ఫర్‍ జానూకరీ ");
INSERT INTO vgr_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","బాకీనూ అద్మీయే పెలుకుల్‍ఫర్‍, చెక్కల్‍ఫర్ ఛల్‍జాను కరి హూఖందిదో. ఇమ్మస్‍ హాఃరూబి ఛుఖైలిన్‍ భార్‍ పడ్యు. ");
INSERT INTO vgr_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","హాఃమె ఛుకైలేవాన బాద్‍మా యో ద్వీపం మెలితే కరి హామ్నా మాలంహూయు. ");
INSERT INTO vgr_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","ఎజ్గనూ అద్మియే హామరఫర్‍ ఘణు దయ దేఖాడు. కిమ్కతో తెదె పాని వరహ్ః తూ హూయిన్‍, హమ్నా ఘణు ఠణ్‍ ర్హవమా యూవ్నే ఆగ్‍ బాళిన్, హమ్నా హాఃరవ్‍నా కంధే కర్లీదు. ");
INSERT INTO vgr_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","తెదె పౌల్‍ థోడా లాక్‍ఢాన ఛూణీన్‍ ఆగ్‍ఫర్‍ నాఖూకరాతో ఏక్ క్హాప్‍ యో ఆగ్నూ ఆంచ్‍నా భార్‍ ఆయిన్‍, ఇనా హాత్‍నా కల్‍డ్యు. ");
INSERT INTO vgr_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","జనాభో హఃరు యో హాఃప్‍ ఇనా హాత్‍నా ధర్లీన్‍ ఠంగీ ర్హావనూ దేఖిన్‍, “ఆ అద్మి కఛ్చితంగా హంతకుడ్‍ హూసే. యో ధర్యావ్‍మతూ చుఖైన్‍ ఆయోతోబి న్యాయంను దేవతా ఇనా జీవాదిసెకొయిని” కరి ఏక్నా ఏక్ బోల్లీదు. ");
INSERT INTO vgr_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","హుయుతో పౌల్‍ యో ఝేర్ను హాఃప్‍నా ఆగ్‍మా జఠ్కీనాఖీన్‍ కేయు హానిబి కోహుయుని. ");
INSERT INTO vgr_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","యూవ్నే హాఃరు ఇనూ ఆంగ్‍తన్‍ పులీజవానుస్‍కీ, నైతో యో హఃడాల్‍ కరి పడీ మర్జానూస్‍కీ హూసే కరి దేక్తూర్హయు. ఘణా వోహఃత్‍ హూవానా బాద్‍మాబి ఇనా కాయినా హూవానూ దేఖిన్‍ ఇవ్ను అభిప్రాయ్‍ భద్‍లాయిలీన్‍, “ఆ ఏక్ దేవ్‍” కరి బోలానిక్యు. ");
INSERT INTO vgr_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","పోప్లి కరి యో ద్వీపంమా ముఖ్య అద్మి. ఇనా యో ప్రాంతంమా ఘణు జమీనే ఛా. యో హామ్నా కంధేకర్లీన్‍ తీన్‍ ధన్‍ హామారేతి దోస్తితి అతిధ్‍ కర్యో. ");
INSERT INTO vgr_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","యో వోహఃత్‍మా పోప్లినో భా తావ్‍థీ, ల్హొయినూ పేట్‍చాలానూథీ బాధ పడ్తోహుయిన్‍ హూఃతోథో పౌల్‍ ఇనాకనా జైన్‍ ప్రార్థన కరీన్‍ ఇనాఫర్‍ హాత్‍ మ్హేంధీన్ అసేల్‍ కర్యో. ");
INSERT INTO vgr_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","ఇమ్‍ హూయుతె ఇనా దేఖీన్‍, యో ద్వీపంమా ఛాతే హాఃరా రోగ్‍ వాళబి ఆయిన్‍ అసేల్‍ హూయా. ");
INSERT INTO vgr_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","బుజ ఇవ్నే హమ్నా కెత్రూకి మాన్‍ మర్యాధ కరీన్‍, బుజు హామే ఝాజ్‍ ఛడీన్‍ జవాను వోహాఃత్‍ హామ్నా జరూరత్‍ ఛాతే హాఃర రాఛు లాయిన్‍ ఝాజ్‍మా రాఖ్యు. ");
INSERT INTO vgr_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","తీన్‍ మైనానా బాద్మా, హామే యో ద్వీపంమా ఠణ్‍నా ధన్‍ హాఃరా భీరిరూతే ఝాజ్‍మా నిక్యా. యో ఝాజ్‍ అలెగ్జాండ్రియ నంగర్‍నూ. ఇనాఫర్‍ కవులు జోడాకరి హాఃనత్‍ ఛా. ");
INSERT INTO vgr_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","సూరకూ నంగర్‍నా ఆయిన్‍ ఏజ్గా తీన్‍ ధన్‍ ర్హయా. ");
INSERT INTO vgr_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","ఏజ్గాతూ ఆష్పిష్‍ ఫరీన్‍ జైన్‍ రేగియునా ఆయిన్‍ ఏజ్గా ఏక్ ధన్‍ ర్హవాదీన్‍ దక్చిణ్‍నూ వాయిరో వాగమా బుజాధన్నే పొతియొలీ హఃయర్‍ గయా. ");
INSERT INTO vgr_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","ఏజ్గా థోఢా భైయే మళ్యాతేదె యూవ్నే హామారేతి మలిన్‍ హాఃత్‍ ధన్‍ ర్హవో కరి హామ్నా బతిమాలు. ఇనబాద్‍మా రోమ్‍ నంగర్‍నా ఆయా. ");
INSERT INTO vgr_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","ఏజ్గాతుస్‍ భైయ్యే హమార గూర్చి హాఃమ్జీన్‍ హమార హాఃజే ఏదుర్‍ ఆయా. అప్పియా బజార్‍ తోడీ త్రియొన్‍ సత్రం తోడి ఆయా. ఇవ్నా దేఖీన్‍ పౌల్‍ దేవ్నా కృతజ్ఞత కరీన్‍ హిమ్మత్‍ లాయిలీదో. ");
INSERT INTO vgr_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","హామే రోమ్‍నా గయాతెదె పౌల్‍నా ఇనా కావ్లీ కరుకరాతే సైనికుడ్‍తి మలిన్‍ ప్రత్యేకంగా ర్హవానా అనుమతి మళ్యు. ");
INSERT INTO vgr_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","తీన్‍ధన్నా బాద్‍ యో ప్రముఖ్‍ యూదుల్‍నా ఇనా కనా బులామంగయో. ఇవ్నే ఆయుతేదె యో భైయ్యే, మే అప్నా ప్రజల్‍నా, పూర్వీకుల్‍నూ ఆచారాల్‍నా ఆడు కాయి నా కర్యుతోబి, యెరూషలేమ్‍థూ మన రోమ్‍ను హాత్మా ధరాయా. ");
INSERT INTO vgr_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","ఇవ్నే మన పరీక్చించీన్‍ మరామా మరణ్‍నూ తగ్గిన్‍నూ కాయిబి నాదేఖవమా, మన మ్హెందేనుకరి ర్హైగూ, ");
INSERT INTO vgr_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","పాన్కి యూదుల్‍ ఆఢే బోలమా మే రోమనురాజొ హాఃమే బోల్లీస్‍ కరి బోలమా హూయు థూ. ఏత్రేస్‍ గాని మార అద్మీఫర్‍ ఇంజామ్‍ నాక్నూ కరి మాత్రం కాహే. ");
INSERT INTO vgr_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","ఆ వాత్‍నా టేకెస్‍ మే తుమ్నా బులాయో. ఇష్రాయేల్‍ ప్రజల్‍నూ నిరిక్చణ్‍నా టేకెస్‍ మే ఆ ఖంకల్‍తి భందైరోస్‍ కరి ఇవ్నేతి బోల్యొ. ");
INSERT INTO vgr_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","ఇనహాఃజే ఇవ్నే, “యూదయతు తూమారు వాతేను ఉత్తర్‍ ఆయుకోయిని, ఆజ్గా ఆయుతే యూదు భైయ్యేమా ఏక్‍జణుబి తూమారు బారెమా ఖర్రాబ్‍ వాత్‍ బోల్యకోయిని కోన్‍బి బోల్లిదుబి కోయిని. ");
INSERT INTO vgr_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","హూయుతోబి ఆ విషయంమా తూమరు అభిప్రాయ్ తూమార మ్హోఢాతీస్‍ హాఃమ్జునూ కరి ఛీయ్యే. ఆ మతభేద్‍నూ హాఃజే హాఃరు జోగోబి వ్యతిరేక్‍ నితర ఛాకరీ హమ్నా మాలం” కరి బోల్యు. ");
INSERT INTO vgr_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","యో ఏక్ ధన్నే ఏర్పాట్‍ కరీన్‍, యో ఛాతే జోగో హాఃరు జణు ఆయు. వ్వాణేతూ ధరీన్‍ హాఃమీ హాఃమ్‍ తోడీ యో దేవ్‍నూ రాజ్యంన టేకె పూరా సాక్చ్యం దేతోహుయిన్‍, మోషే ధర్మషాస్త్రథూ, ప్రవక్తల్‍మథూ నూ సంగతుల్‍నా యూవ్నా దేఖాడ్‍తో హుయిన్‍, యేసునా హాఃజే ఖూల్లా కరీన్‍ బోల్తో హుయిన్‍, యూవ్నా ఒప్పావ్‍తో ర్హయో. ");
INSERT INTO vgr_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","యో బోల్యోతే సంగతుల్‍నా థోడు జణు నమ్యు, థోడు జణు నమ్యు కోయిని. ");
INSERT INTO vgr_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","యూవ్నామా భేదం హుయిజవమా, పౌల్‍ ఆఖరిమా యూవ్నేతి ఏక్ వాత్‍ బోల్యొ. యో ష్యాత్‍ కతో, పవిత్రాత్మ యెషయాతి ప్రవక్త తూమారు పితరుల్‍తి బోల్యోతే వాత్‍ ");
INSERT INTO vgr_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","ఇవ్నే హాఃమాజ్‍సే పన్కీ అర్ధం కర్‍సే కోయిని. దేక్‍సే పన్కి గ్రహీంచే కోయిని కరి ఆ అద్మీయేతి బోల్‍. ");
INSERT INTO vgr_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","ఆ అద్మీయే ఢోలాతి ధేఖీన్‍, ఖాన్‍తి హాఃజీన్‍, పూరా దీల్‍తి అర్ధం కరీన్‍ మార మ్హణీ ఫరీన్‍, మారేతి అష్యల్‍ నాహుయిన్‍, ఇవ్నూ దిల్ ఘట్‍‍ హుయిగు. ఇవ్నే కాయిబి హాఃమాజ్‍ కోయిని, ఇవ్ను ఢోలా మూఛీరాఖ్యస్‍ కరి ");
INSERT INTO vgr_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","ఇనహాఃజే దేవ్‍తీ హూయుతే ఆ బఛ్చాడ యూదులు కాహెతె ఇవ్నా కనా ఛల్‍జౌంగ్రస్‍ కరి తుమె మాలంకర్‍లీసు. ఇవ్నే ఇనా ఒప్పిలీసే ఆ వాత్‍ హాఃజుతే ఇవ్నే హాఃరు ఛలీగయు. ");
INSERT INTO vgr_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","పౌల్‍ పురా బే వరహ్‍ః బాడ్‍గునా ఘర్‍మా ర్హైన్‍, ఇనా కనా ఆవావళు హాఃరనా ఆదరిస్తోర్హయో. ");
INSERT INTO vgr_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","కెహూ ఆడుస్‍ కోయినితిమ్‍ పురా హీమ్మతి దేవ్ను రాజ్యంనా హాఃజే ప్రచార్‍ కర్తోహుయిన్‍, ప్రభూహుయోతే యేసు క్రీస్తునూ వాతేనా బోధిస్తో ర్హయో.");
INSERT INTO vgr_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","యేసు క్రీస్తు దాసుడ్‍, అపొస్తల్‍నితరా ర్హావనటేకె బులాయుమంగాహుయోబి, దేవ్ను సువార్తనటేకె ప్రత్యేకించుహుయోతె ");
INSERT INTO vgr_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","పౌల్‍ రోమమా ఛాతె దేవ్ను ఫ్యార్ను అద్మి ఖారవ్నా కతొ పరిసుద్దుడ్‍ని తరా రవ్వానటేకె బులాయుహు హాఃరన్నా లిఖ్కుకరతె అప్న భా హుయోతె దేవ్‍ కంతుబి, ప్రభుహుయోతె యేసుక్రీస్తు కంతుబి, కృపాసమాధానంబి తుమ్న హువదా దేవ్‍ ఇను ఛియ్యోనా అప్న ప్రభువుహుయోతె యేసు క్రీస్తును విషయంహుయూతె ");
INSERT INTO vgr_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","యో సువార్తల్నా పరిసుద్ధ్ లేఖనాల్‍కనా ఇను ప్రవక్తల్‍ బారేమా అగాడి వాగ్ధానం కర్యొ ");
INSERT INTO vgr_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","ఇను పరిత్రహుయూతె ఆత్మతి ప్రభావంతి మరన్‍మతూ జీవిన్‍ ఉట్టను తాఖత్‍ అజు పరిసుద్ధహుయుతె ఆత్మనాటేకె దేవుని ఛియ్యానితర ప్రభావంతీ జనాబనా హాఃమె రుజుహుయు, ");
INSERT INTO vgr_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","క్రీస్తుయేసు నామ్ను బణేతీ సమస్తంను అద్మిహాఃరు విష్వాస్‍నా విధేయులునాహువనాటేకె ఇనా బరేమా హమే కృపబి అపొస్తులునుత్వవం పొందిరాక్యస్‍. ");
INSERT INTO vgr_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","ఇనేతి హామే కృపబి, తుమేబి ఇవ్నామా రవ్వాలహుయిన్‍ యేసు క్రీస్తువాలంతర రవ్వానటెకె బులాయ్‍ రాఖిన్‍ ఛా, ");
INSERT INTO vgr_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","హుయుతో రోమను హాఃరవ్నా గూర్చి అజు దేవ్ను లాఢ్‍హుయాతె అద్మియేనుటేకె లిఖ్యో; మారొ దేవ్‍ అప్ను భా హుయుతె ప్రభువుహుయుతె యేసుక్రీస్తు అప్నా గోర్‍బి షాంతి దిసె, ");
INSERT INTO vgr_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","తుమారు విష్వాస్‍ ములక్‍హాఃరు ప్రచార్‍హువను దేఖిన్‍ అగాఢి తుమారు హాఃరవ్నాటేకె యేసుక్రీస్తు బారేమా మార దేవ్నా కృతజ్ఞాతస్తుతుల్‍ బోలుకురుస్‍, ");
INSERT INTO vgr_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","అనహాఃజె యో ఛియ్యోను సువార్తను విషయంమా మే మారు పూర్ణదిల్మా సేవించుకరతె దేవస్‍ మన సాబుత్‍, ");
INSERT INTO vgr_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","హంకె కింమ్‍ కింతోబి ఆటంకం కొయినీతిమ్ తుమారకన‍ ఆవనటెకె దేవ్ని చిత్తంతీ వీల్‍హువస్‍షికి కరి, మారు ప్రార్థనమా కెదేబి ఇనస్‍ బతిమాలుకురుస్‍, ");
INSERT INTO vgr_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","తుమె ఏక్‍ జొగొ ఖడ్నూకిరి, కతొ తుమ్నబి మనబీ కల్గీన్‍ఛాతె విష్వాస్‍న క్హాజె, కతొ అప్నే ఏక్ను విష్వాస్‍తి ఏక్‍ ఆదరణపొందును కరి, మారు ఆఖ్‍ః ");
INSERT INTO vgr_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","ఆత్మాసంబంధంహుయూతె కృపావరంను కెహూబి తుమ్నా దెవ్వానా తుమ్న దేనుకరి ఆహ్క కరుకరూస్‍; ");
INSERT INTO vgr_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","భైయ్యె మే అలాదుహుయూతె అన్యజనాభోమా ఫల్‍ పొందునుకరి తుమారమాబి కెహూబి ఫాయ్‍దొ పొందునుతింమ్‍ కెత్రూకి వహఃత్‍ తుమారకన ఆవ్నుకరి సోఛొ థొ; పన్కి హంకెతోడి ఆటంకంహుయూతు; ఆ తుమ్న మాలంకొయినితింమ్‍ రవ్వాను మన ఇష్టంకొయిని; ");
INSERT INTO vgr_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","గ్రీసు దేహ్ఃవాలనబి గ్రీసుదేఖ్‍ఃవాలకాహేతె ఇవ్నబి, జ్ఞానుల్‍నబి బుద్దికొయింతె ఇవ్నబి మే రుణస్తుడ్‍; ");
INSERT INTO vgr_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","ఇంమ్‍ హుయూతొ మారవల హువ యెత్రుతోడి రోమమాఛ్చాతె తుమ్నబి సువార్తన బోలనాటెకె తయాయ్‍ హుయీన్‍ఛావ్‍. ");
INSERT INTO vgr_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","సువార్తనటేకె మే ష్యరమ్‍హువవాలొ కాహె కింకతొ విష్వాస్‍ హర్యేక్‍ జననా, అగాఢి యూదుల్‍దేఖ్‍ః, గ్రీసుదేఖ్‍ః వాలనబి బఛ్చాడనాటేకె యో దేవ్ని థాఖత్‍ హుయిన్‍‌ ఛా ");
INSERT INTO vgr_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","సానకతో నీతిమంతుడ్‍ విష్వాస్‍నుబారెమా జివ్సేకరి లిక్కాయ్‍రాక్యుతిమ్‍ విష్వాస్‍నుబారేమా ఘను విష్వాస్‍హువతింమ్‍ దేవ్ని నీతి ఇనమా బయలు పరుచుబడుకురాస్‍. ");
INSERT INTO vgr_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","దుర్నితి హాఃచిన ఆఢు ఆవతె అద్మియేను సమస్తనా భక్తితపార్‍ దుర్నీతిపార్‍ దేవ్ని చంఢాల్‍ స్వర్గంతూ బయలుపరుచుబడుకురాస్‍ ");
INSERT INTO vgr_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","సానకతో దేవ్న గూర్చూన్‍ మాలంకర వెత్రూ కెహూకి యో ఇవ్నూ ఇచ్మా విషద్దపరచి రాక్యోస్‍, ");
INSERT INTO vgr_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","ఆ ములక్‍ ఫైదయుతే కంతు, అనంతహుయుతే థాఖత్‍ దైవత్వమ్‍ కరి యో అద్రుష లక్చణం, కతో యో నిత్యథాఖాత్‍ దేవ్‍త్వమ్‍బి, ధర్తిను అగాఢితూ నిఖిన్‍ సృష్టంచిహుయూతె రాచునబి హాఃయల్‍కరమా తేటపరుచుకరస్‍ పన్కి ఇవ్నే నిరుత్తర్‍ హుయీన్‍ ఛా. ");
INSERT INTO vgr_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","బుజు ఇవ్నే దేవ్నా మాలంకరీన్‍బి ఇనా దేవ్‍కరి మహిమపరచకొయినీ, కృతజ్ఞతస్తుతులుబి చెల్లించకొయినీ, పన్కి ఇవ్ను లఢాయమా వ్యర్దయుల్‍హుయూ ఇవ్నే అవివేకలు దిల్‍తి అంధారుహుయు, ");
INSERT INTO vgr_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","ఇవ్ను అక్కల్‍వాల కరి బోలిదు పన్కి ఇవ్నే బుద్దిహీనుల్‍హుయూ, ");
INSERT INTO vgr_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","ఇవ్నే మఠిజాసెకొయినితిమ్‍ దేవ్ని మహిమన మట్టిజంకతె అద్మితీబి, జిన్వార్‍తిబీ, నాక్హనూజిన్వార్‍తీబి, కీడనుతీబి, హార్యేక్‍ రూపంమా బద్లయా ");
INSERT INTO vgr_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","అనహఃజే ఇవ్నే ఇవ్ను దిల్‍ను ఆహ్ఃనాబ్హనె చాలిన్‍, ఇవ్ను ఆంగ్తాను ఇవ్నమా ఇవ్నేస్‍ అవమానం కర్లెనుతింమ్‍ దేవ్‍ ఇవ్నా అపవిత్రతన దెవ్వాడిదిదూ ");
INSERT INTO vgr_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","ఎజాత్నూ ఇవ్నే దేవ్ను హాఃచినా జూటింతర బద్లాయిన్‍ బుజు సృష్టికర్తన బదుల్‍ సృష్టంనా ప్రార్థనకరీన్‍ సేవించుతూ యోస్‍ యుగయుగల్నా స్తోత్రార్హుడుహుయిన్‍ ఛా ఆమెన్‍. ");
INSERT INTO vgr_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","అనటేకే దేవ్నె ఇవ్నా కారబ్‍హుయుతె ఆహ్ః దరాయిదిదో. ఇవ్ని బాయ్‍కొ స్తెతం సహజ సంబంధనా మ్హెందీన్‍ అసహజహుయుతె సంబంధనా ఎంచిలిదా. ");
INSERT INTO vgr_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","ఇంమితరస్ మరద్మానోబి బాయ్‍కవ్‍ను సహజ ధర్మంనా బెందీన్‍, మరధ్‍మానోతి మరధ్‍మానొ నాకర్నూతె కర్తూహుయీన్‍, ఇవ్ను తప్పున కామ్‍నా తగినా ప్రతిపలం పోందిలిన్‍ ఏక్‍ప్పర్‍ ఏక్‍ మస్తివాలుహుయా. ");
INSERT INTO vgr_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","బుజు ఇవ్నే ఇవ్నూ దిల్‍మా దేవ్నా జొగొన దిదూకొయినీ. అనహఃజే కరకొయింతె కార్యాల్‍నా కరన దేవ్‍ భ్రష్ట్ దిల్నా ఇవ్నా దెవాడో. ");
INSERT INTO vgr_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","ఎజాత్నూ ఇవ్నే సమస్తహుయూతె దుర్నితిబి, దుష్టత్వంక్హూబి, లోభితిక్హూబి, ఈర్ష్యహూఃబి, బరాయ్‍హుయీన్‍, ఏక్కతో ఏక్‍పడ కొయినితిమ్‍, మర్రాకనూ, లఢాయ జగనా బుజు వైరమ్‍ భరాయ్‍ రయ్యూ. ");
INSERT INTO vgr_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","చాహ్డాన బోలవాలు, నిందల్‍ నాఖవాలు, దేవ్నా ద్వేషించవాల, హింసకరవాల, హంకార్‍వాల, జూటి వాతె బోలవాలు, ఆయ బాన వాతె ఖంజకొయింతె ఇవ్నా, ");
INSERT INTO vgr_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","అఖ్కల్‍కొయింతె ఇవ్నా, వాత్‍ బద్లావవాల, అనురాగరహితూల్‍బి, గోర్‍కొయిన్‍తెవాల. ");
INSERT INTO vgr_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","అజాత్ను కార్యల్‍నా అభ్యసించవాలన మరణ్‍న బరాబ్బర్‍ పూరిగయూహు కరి దేవ్ని న్యాయవిధినా ఇవ్నే అఛ్చుతి మాలంకరీన్‍బి, ఇనాస్‍ కరూకరస్‍. ఆస్‍ కాహేతింమ్‍ ఇనేతి అభ్యసించుకరతే ఇవ్నేతి ఖుషీతి ఒప్పిలెంకరాస్‍. ");
INSERT INTO vgr_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","అనహఃజే న్యావ్‍ తీర్చు కరుకురతే అద్మి, తూ కోన్‍ రయ్యోతోబి సరే నిరుత్తుడ్‍హుయిన్‍ ఛ్చా. కెహూ విషయంమా అగాఢివాలన న్యావ్‍ తీర్చుకరస్‍కి ఇనా విషయంమా తూస్‍ దోషికరి న్యావ్‍ తీర్చిలెంకరస్‍; సానకతో న్యావ్ తీర్చుకరతె తూబి ఎజాత్నూ కార్యల్‍నా కరుకరస్‍ని కాహేనా? ");
INSERT INTO vgr_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","ఎజాత్నూ కార్యల్‍నా కరవాలప్పర్‍ దేవ్ను న్యావ్‍ హాఃచినా అనుసరించనూస్‍ కరి మలంరాక్చూ. ");
INSERT INTO vgr_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","ఎజాత్నూ కార్యల్‍నా కరుకరతె ఇవ్నా న్యావ్‍ తీర్చును ఇనాస్‍ కరుకరతె అద్మి, తూ దేవ్ను న్యావ్‍మతూ చుక్కాయ్‍జైస్‍కరి సోచిలెంకరస్‍న్నా? ");
INSERT INTO vgr_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","దేవ్ను కటాక్చమ్‍ తునా పస్చాత్తాపమ్‍ హువనాటేకె తున ప్రేరేపించుకరస్‍ కరి మాలంకొయినీ తింమ్‍ ఇను అష్యల్‍ను కతో ఐష్వర్యమును సహనంనా దీర్ఘ షాంతంనా నొకొరిబొలుకురాస్‍న్నా? ");
INSERT INTO vgr_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","తారు ఘట్‍ జాన్‍ బద్లాకొయింతె తారు దిల్నా అనుసరించీన్‍, చంఢాల్‍న ధన్నె తెదె కతో దేవ్ను హాఃచి న్యాయంహుయ్‍తె న్యావ్‍ బాధర్‍ నాక్చే ధన్నే తారు తూస్‍ ఖీజ్‍నా లాయిలెంకరస్‍. ");
INSERT INTO vgr_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","యో హర్యేక్‍జననా ఇను ఇని క్రియల్‍నా బట్టీన్‍ ప్రతిఫలం దిస్యే. ");
INSERT INTO vgr_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","అష్యల్ క్రియల్‍నా ఓపికతి కర్తూ, మహిమన, ఘనతన, అక్చయతన ధూండవాలన నిత్యమ్‍ జీవం దిస్యే. ");
INSERT INTO vgr_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","హుయుతొ లఢాయనా కరాయిన్‍, హాఃచినా లొంగకొయినీతిమమ్‍ దుర్నితినా లోబడతె ఇవ్నప్పర్‍, దేవ్ను చంఢాల్‍బి ఖీజ్‍బి ఆవ్సే. ");
INSERT INTO vgr_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","దుష్‍కార్యంనా కరతె హర్యేక్‍ అద్మిను ఆత్మనా అగాడి యూదుల్‍కరి, గ్రీసుదేఖ్‍ వాలనబి, మిన్హత్‍, వేదనల్‍బి హుషే. ");
INSERT INTO vgr_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","అష్యల్‍కరతె హర్యేక్‍జననాబి, అగాడి యూదుల్‍, గ్రీసుదేక్హ్ వాలనబి, మహిమబి, ఘనతబి షాంతిసమాధానం హూస్‍. ");
INSERT INTO vgr_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","దేవ్నా హర్యేక్‍జనణ పక్చపాతం కొయినితిమ్‍ ");
INSERT INTO vgr_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","ధర్మషాస్ర్తం రవాలహుయిన్‍ పాప్‍ కర్యూహు ఖారు ధర్మషాస్ర్తంను న్యావ్‍ లిషె. ");
INSERT INTO vgr_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","ధర్మషాస్ర్తంన క్హంజవాలు దేవ్ను నాజర్‍మా నీతిమంతుల్‍ కాహేగాని ధర్మషాస్ర్తంనా చాలవాలొ ప్రవర్తించాలోస్‍ నీతిమంతుడ్‍ గోణి ఎంచబడ్‍సే. ");
INSERT INTO vgr_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","ధర్మషాస్ర్తం కొయింతే అన్యజనాభోనా ధర్మషాస్ర్తంను సంబంధంచుయుహు క్రియల్‍న కర్యుతెదె ఇవ్నేధర్మషాస్ర్తం కొయింతెహుయుతోబి, ఇవ్ను ఇవ్నేస్ ధర్మషాస్ర్తం హువంతరా ఛా. ");
INSERT INTO vgr_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","ఎజాత్నానూ దిల్‍క్హాఛిబీ సాక్చిబోలుకరతోబి, ఇవ్ను క్హయల్‍ ఏక్నూప్పర్‍ ఏక్‍ తప్పుననాక్తూ న్హైతో తప్పు కొయినీకరి బొలుకరతోబి, ధర్మషాస్ర్తం సారంతీ ఇవ్ను దిల్‍నుక్హామె లిక్కారుతింమ్‍ వతాలుకరస్‍. ");
INSERT INTO vgr_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","దేవ్‍ మారు సువార్తన‍ ప్రకారం యేసు క్రీస్తున బారేమ అద్మిను రహస్యాల్‍నా న్యావ్‍కరను ధన్నే ఇమ్‍ హుసే. ");
INSERT INTO vgr_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","తూ యూదుల్‍కరి నామ్‍ మ్హేందిలీన్‍ ధర్మషాస్ర్తంఫర్‍ బరోసారాఖీన్‍ దేవ్నక్హామె అతిసయించుకరస్‍ కాహేనా? ");
INSERT INTO vgr_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","ఇను చిత్తంనమాలంకరీన్‍, ధర్మషాస్ర్తంకన ఉపదేషంనా పొందొహుయుహొ వాలొరహీన్‍, స్రేష్ఠహుయూతె ఇనస్‍ మెఛ్చిలెంకరస్‍ని కాహేనా? ");
INSERT INTO vgr_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","జ్ఞాన్‍ ఖాచ్ఛిన స్వరూప్‍హుయూతె ధర్మషాస్ర్తంన కల్గీరహీన్‍, మే కాణ ఢోలవాలనా వాట్‍వతాలవాలొ. అంధారమా ఛ్చాతెఇవ్నా ఉజాలునా, ");
INSERT INTO vgr_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","అంధారమా ఛాతె ఇవ్నా ఉజాలునా, అక్కల్ కొయింతెవాలనా అజు హాఃచిన సిక్చాదెవ్వాను, లడ్కావ్‍నా ఉపాధ్యాయులుహుయిన్‍ ఛాకరి తారు తూస్‍ ధైర్యమ్‍నా లాయిలెంకరస్‍ కాహేనా? ");
INSERT INTO vgr_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","హాఃమెనువాలన బోధించవాలో తూ తున తూస్‍ బోధించికోలేయిన్నా? ఛోర్‍నుకామ్‍ నొకొకర్‍కరి ప్రచార్‍కర్యతె తూ ఛోర్‍నుకామ్‍ కరాస్‍న్నా? ");
INSERT INTO vgr_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","వ్యభిచార్‍ నొకొకర్‍కరి బోలతె తూస్‍ వ్యభిచార్‍కరస్‍న్నా? విగ్రహాల్‍నా అసహ్యింయంచతె తూ గుడినా దోచిలేస్‍న్నా? ");
INSERT INTO vgr_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","ధర్మషాస్ర్తంమా అతిసయించతె తూ ధర్మషాస్ర్తం మీరమా అనహఃజే దేవ్ను ఇజ్జాత్‍ కాఢస్‍న్నా? ");
INSERT INTO vgr_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","లిఖ్కాయ్‍రు ప్రకారమ్‍ తుమారటెకేస్‍కాహేనా దేవ్ను నామ్‍ అన్యజనాభోనా ఇచ్మా గాలయ్‍ఖాసు? ");
INSERT INTO vgr_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","తూ ధర్మషాస్ర్తంనా అనుసరించీన్‍ చాలవాలో హుయ్‍రోతొ, సున్నతి ప్రయోజనంహుసే పన్కీ ధర్మషాస్ర్తంనా మీరీన్‍ అతిక్రమించవాలొహుయోతో, తారు సున్నతి సున్నతికాహె తింమ్‍హుసె. ");
INSERT INTO vgr_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","అనహఃజే సున్నతి కొయింతెయో ధర్మషాస్ర్తంను నీతి నియామాల్‍నా మాలంకర్యతొ తెదె యో సున్నతి కొయింతే వాలొ హుయ్యోతోబి సున్నతి ర్హావాలంతరా ఎంచబడ్చే కాహేనా? ");
INSERT INTO vgr_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","బుజు ఛాల్‍నబట్టీన్‍ సున్నతి కొయింతే యో ధర్మషాస్ర్తంనా నెరవేర్చితొతెదె అక్చర్‍నా సున్నతిబి హువ్వాలొహుయీన్‍ ధర్మషాస్ర్తంనా అతిక్రమించతె తున న్యావ్‍నా తీర్చకొయిన్నా? ");
INSERT INTO vgr_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","ఉప్పర్‍ యూదుల్‍నితర హుయోహొ యూదుల్‍ కాహె; ఆంగ్తానుప్పర్‍ సున్నతిహుయోతె సున్నతి కాహె. ");
INSERT INTO vgr_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","హుయ్‍తొ దిల్‍మా యూదుల్‍హుయేతె యోస్‍ యూదుల్‍. బుజు సున్నతి దిల్నా సంబంధహుయీన్‍ ఆత్మమా జరగకొయింతెస్‍ పన్కి అక్చరంనాహాఃజె కలగ్చెతె కాహె. ఎజాత్ననా మెఛ్చతె అద్మిటేకె కల్గకొయినీ, దేవ్నాబారేమాస్‍ కలగ్చె. ");
INSERT INTO vgr_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","అమ్‍హుయుతో యూదుల్నా హుయుతె మహాన్‍ సాత్? సున్నతినాటేకె ప్రయోజనంసాత్‍? ");
INSERT INTO vgr_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","క్హాచిస్‍ హర్యేక్‍విషయంమా గ్హానుస్‍. అగాఢిను, దేవ్ను వాతె అగ్గాడిస్‍ యూదుల్‍నా దెవ్వాయుగయూ. ");
INSERT INTO vgr_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","కింకతో థోడుజను అవిస్వాసులు నాహుయుతె? ఇవ్నే అవిస్వాసుహుయుతెతిమ్‍ దేవ్‍ విష్వాస్‍వాలొ ర్హాసేకొయిన్నా? ఇమ్‍నాబొల్‍ను. ");
INSERT INTO vgr_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","ఇమ్‍ హుస్‍కొయిని “తారు వాత్మా తూ నీతిమంతుడునితరా తీర్చబడ్నుతిమ్‍ తూ న్యావ్‍హుయుతెదె గెల్చనుతిమ్‍” కరి లిఖ్యుతిమ్‍ ప్రకారం హార్యేక్‍ అద్మియోను చాఢివాలనితార పన్కి దేవ్‍ మాత్రం హాఃఛివాలొ. ");
INSERT INTO vgr_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","అప్ను దుర్నితి దేవ్నా నీతిను ప్రసిద్ధి హాఃరుయుతె బారేమా సాత్‍బొల్‍సు? తో హామే ఖారబ్‍ కామ్‍ కర్యాతో కిజ్హానా వొతాల్‍ దేవ్‍ అన్యాయుస్తు హుసెనా? మే అద్యియోనుతార వాత్‍బొలుకురుస్‍; ");
INSERT INTO vgr_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","ఇమ్‍నాబొల్‍ను. ఇమ్‍ హుసేతో దేవ్‍ ములక్‍నా కిమ్‍ న్యావ్‍ తీర్‍చె? ");
INSERT INTO vgr_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","మారు జోట్టినాటేకె దేవ్‍ హాఃచి ప్హైలగుతో ఇనా మహిమ కలిగ్యుతొ మే పాప్‍కర్యూహుయో న్యావ్‍ పొందనా సానా? ");
INSERT INTO vgr_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","ఆవొ అప్నె హాఃరు ఖరాబ్‍ కామ్‍కారి అష్యల్ హోను, ష్యానకతొ అప్న థోడుజను తుమ్న గాలెదీన్‍ బోల్యుతె ప్రకారం హమె ష్యాన నాబొల్ను? ఎజాత్ననా హుస్‍తె సిక్చావిధి న్యాయమస్‍. ");
INSERT INTO vgr_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","కిమ్‍హుయుతోబి సాత్‍బోల్సుకరి? హమే ఇవ్నేతి స్రేష్ఠలంనా? కామ్‍వాలన? ఎత్రే మాత్రమంకాహే యూదుల్‍ గ్రీసుదేక్హ్ను హాఃరుజణు పాప్‍నాహేట్‍ ఛాకరి అనఅగాడి హఃరాబ్‍ వాతెకరి రాహఃస్‍, ");
INSERT INTO vgr_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","అనగూర్చి లిఖ్కిరాక్యుతె సాత్‍కతొ నీతిమంతుడ్‍ కొయిన్‍, లేఖనాల్‍ తిమ్‍ ఏక్జనుబి కొయిని, ");
INSERT INTO vgr_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","గ్రహించువాలొ కొన్బిస కొయిని దేవ్నా ధూండవాలు కొన్బి కొయిని, ");
INSERT INTO vgr_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","హాఃరుబి వాట్‍ చుక్కిజైయిన్‍ ఏక్‍హుయిన్‍ కామెఆవకొయిని తిమ్‍ హుయ్‍గయూ. మేల్‍ కరవాలు కొయిని, ఏక్జనుబి కొయిని. ");
INSERT INTO vgr_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","ఇవ్నే బాకు కాడ్యుతె గొర్రాడు, ఇవ్ను జీబ్తి మోసం కర్సె; ఇవ్ను వోట్ను ఉప్పట్‍ హాఃప్ను విషం ఛా. ");
INSERT INTO vgr_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","ఇవ్ను బాకుభరిన్‍ సపించానుబి ఖీజ్బి ఛా. ");
INSERT INTO vgr_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","ల్హొయినా దేఖనాటేకె ఇవ్ను గోడ మిలాంకరాస్‍. ");
INSERT INTO vgr_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","నాసనంనా కష్టంనా ఇవ్నే వాట్‍మా ఛా. ");
INSERT INTO vgr_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","షాంతి వాట్మా ఇవ్నేనా మాలంకొయిని. ");
INSERT INTO vgr_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","ఇవ్ను నజర్నానా హాఃమే దేవ్ను ఢర్‍ కొయిని. ");
INSERT INTO vgr_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","హార్యేక్‍ను బాకు ముచ్చావ్‍నుతిమ్‍, ములక్‍హాఃరు దేవ్ను సిక్చనా పాత్రహుయుతిమ్‍, ధర్మషాస్ర్తం బోలుకరతె ఆహాఃరన ధర్మషాస్ర్తంనా లోబడెనుహుయుతె ఇవ్నేతి బోలుకురుస్కరి మాలంకర్చు. ");
INSERT INTO vgr_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","కింకతొ ధర్మషాస్ర్తం సంబంధంహుయుతె క్రియనుమూలంతి కెవు అద్మిమిబి ఇన నజర్మా ఆంగ్తాను నీతిమంతుడ్‍ కరి తీర్చబడ్సెకొయిని; ధర్మషాస్త్రంనాటేకె పాప్‍ కాతొ కెజాత్నుకి మాలంహుకొరాస్. ");
INSERT INTO vgr_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","అమ్‍ఛాతొ ధర్మషాస్ర్తంనా అలదుతి దేవ్నా నీతి భార్‍ పడుకరస్; ఇన ధర్మషాస్ర్తంనా ప్రవక్తల్‍నా సాక్చ్యం దెమ్కరాస్‍. ");
INSERT INTO vgr_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","ఆ యేసు క్రీస్తుమా నీతి విష్వాస్‍ మూలంహుయుతె, నమ్మతె ఇవ్నా హాఃరవ్నా హుసెతె దేవ్ను నీతిహుయిన్‍ ఛా. కెహు భేదం కొయిని; ");
INSERT INTO vgr_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","హాఃరుబి పాప్‍ కరీన్‍ దేవ్‍ అనుగ్రహించొతె మహిమనా పొందకొయిన్‍తిమ్‍ చల్‍జొంకొరస్‍. ");
INSERT INTO vgr_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","అనటేకే నమ్మస్‍తె ఇవ్నే ఇన కృపతీస్‍, క్రీస్తుయేసుమా విమోచనమ్‍తీస్‍ థ్యారకతీ నీతిమంతుడ్‍ కరి తీర్చబడుకురస్‍. ");
INSERT INTO vgr_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","క్రీస్తుయేసు ల్హొయి విస్వాస్‍తీస్‍ లయోస్‍ కరుణాధారంతి బయలుపర్చొ. దేవ్ యేసుక్రీస్తునా అప్నా బలి అర్పణంగా అర్పించొ. జమానమా కర్యూహుయుతె పాప్‍నా దేవ్ ఇను ఓర్పుతి ప్రాయష్చితమ్‍ యో ఇను నీతిన వతాలిలెంకరస్‍కరి. ");
INSERT INTO vgr_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","దేవ్‍ హంకెను కాలంమా ఇను నీతిన దెఖాడతె నిమిత్తం, యో నీతిమంతుడ్‍ కరి యేసుమా విష్వాస్‍ఛాతె ఇనా నీతిమంతుడుతార న్యావ్‍కరవాలొహుయిన్‍ రావ్వానటేకె యో ఇమ్మాస్‍ కర్యొ. ");
INSERT INTO vgr_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","అనటేకె అప్నే బడ్డాయ్‍ బొలిలేవ్వాన కెజ్గా? ఇనా మర్రాకి దెవ్వాను హుయుగు. కేవు న్యాయంనాబట్టీ ఇనా మర్రాకిదిసే? క్రియనియమంను బట్టీన్నా? కాహే, ధర్మషాస్ర్తం విష్వాస్‍ నియంమ్నాటేకెస్‍. ");
INSERT INTO vgr_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","కతో ధర్మషాస్ర్తం సంబంధహుయుతె, క్రియల్‍నా కొయిన్‍తిమ్‍ విష్వాస్‍తీస్‍ అద్మియోనా నీతి మంతుడ్‍తరా తీర్చబడుకరస్కరి ఎంచుకురస్‍. ");
INSERT INTO vgr_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","దేవ్‍ యూదుల్‍నా మాత్రంమస్‍ దేవ్నా? అన్యజనాభోనా దేవ్‍ కావేనా? ఒహో, అన్యజనాభోనాబి దేవ్‍. ");
INSERT INTO vgr_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","దేవ్‍ ‍ఎక్కస్‍ పన్కి, యో యూదుల్‍ ఇవ్నే విస్వాస్‍ మూలంగాతీబి, అన్యజనుల్‍ ఇవ్నే విష్వాస్‍మ్ను బరేమా, నీతిమంతుడ్‍తరా తీర్చె. ");
INSERT INTO vgr_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","విష్వాస్‍బారెమా ధర్మషాస్త్రంనా నిరర్థకం కరూకరియేస్‍నా? ఇమ్‍నబొల్‍ను; ధర్మషాస్ర్తంనా పాటించుకరియేస్‍. ");
INSERT INTO vgr_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","అనటేకె ఆంగ్తాను విషయంమ అప్ను మూల మరద్మానొహుయుతె అబ్రాహామ్‍నా సాత్‍ మల్యుకరి బోల్సు ఇను అనుభవం సాత్‍? ");
INSERT INTO vgr_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","అబ్రాహామ్ను కామ్ను మూలంతి నీతిమంతుడ్‍ కరి తీర్చబడీన్‍ ర్హయోతొ ఇనా అతిసయకారణం హుస్‍ పాన్కి యో దేవ్నా హాఃమే హుసెకొయిని. ");
INSERT INTO vgr_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","లేఖనం సాత్‍ బోలుకరస్‍? అబ్రాహామ్ను విష్వాస్‍ బారేమా దేవ్నా నమ్యో, యో ఇనా నీతితి ఎంచబడ్యు ");
INSERT INTO vgr_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","కామ్‍ కరవాలొనా జీతంనా జీతగాడ్ పన్కి దానంకరి బహుమతికరి ఎంచబడకొయిని ఇనటేకె కామ్‍ కర్ను. ");
INSERT INTO vgr_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","కామ్‍ కరకొయినితిమ్‍, భక్తిహీనుడ్నా నీతిమంతుడ్నితరా తీర్చు వాలోనా విష్వాస్‍ బట్టి ఇనబీ ఇన విష్వాసంనా నీతి తరా ఎంచబడుకరస్‍. ");
INSERT INTO vgr_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","యో ప్రకారం క్రియల్‍ కొయినితిమ్‍ దేవ్నాస్‍ ఇనా నీతిమంతుడ్‍తరా ఎంచొయో అద్మియే ధన్యుడ్‍కరి దావీద్‍బి బోలుకరస్‍. ");
INSERT INTO vgr_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","“ఇను పాప్‍నా ప్రాయచిత్తం పొంద్యొతె యో ధన్యుడు. కింకాతొ ఇను అతిక్రమంనా మాప్‍ పరిహరింపబడ్చె. పొంద్యొతెయో ");
INSERT INTO vgr_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","ప్రభువుహాతె పాప్‍నా లెక్కమా లెవ్వాకొయిన్‍తె యో ధన్యుడు.” ");
INSERT INTO vgr_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","ఆ ధన్యవచనం సున్నతి ఛాతె ఇవ్నే యూదుల్‍ గూర్చి బొలయునా సున్నతి కొయిన్‍తె ఇవ్నే అన్యజనుల్నా గూర్చిబి బొలయునా? అబ్రాహామ్‍ను విష్వాస్‍ ఇనా నీతి కరి ఎంచబడుకురస్‍ కాహేనా? ");
INSERT INTO vgr_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","అషల్; యో కెవు సీతిమా ఎంచబడ్యు? అబ్రహామ్‍ సున్నతి కలిగిరాహితొ సున్నతి కొయితెటెపార్‍? సున్నతి కలిగిరాహితొ కాహె సున్నతి కొయింతెదెస్‍. ");
INSERT INTO vgr_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","అజు సున్నతి కొయింతే ఇవ్నేనా, నమ్మతె ఇవ్న ఖార్వానా యో భా హువనటేకె ఇవ్నే నీతి ఆరోపించనాటేకె, యో సున్నతి పొందకొయింతె అగాడి, ఇనా కలుగుతె విష్వాస్‍హుయుతె నీతినా ఛాపొ, సున్నతి కరి సాబుత్‍ పొందెయో. ");
INSERT INTO vgr_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","అజు సున్నతి ఛాతె ఇవ్నే భా హువనటేకె, కాతొ సున్నతి మాత్రం పొందితె ఇవ్నే కాహే అప్ను భాహుయుతె అబ్రాహామ్ను సున్నతి పొందకొయితె అగాఢి ఇనా కల్గితె విష్వాస్‍ను ఛాల్యుతె ఇవ్నే భా హువానటేకె, యో గుర్తు పొందెయో. ");
INSERT INTO vgr_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","యో ములక్నా వారసుడ్‍హుసె వాక్ముల్ అబ్రాహామ్‍నాబి ఇను సంతానంనాబి ధర్మషాస్ర్తం మూలంతి హుయుకొయిని పన్కి విష్వాస్‍నాటేకెహుయుతె నీతి మూలంతీస్‍ కల్యుగు. ");
INSERT INTO vgr_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","ధర్మషాస్ర్తం సంబందుల్‍నా వారసుల్‍హుయతె విష్వాస్‍నా పాల్తుహుసెకొయిని, ఈ వాక్ముల్‍ నిరర్థకంహుస్‍. ");
INSERT INTO vgr_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","కింకతొ ధర్మషాస్ర్తంనా ఖీజ్‍నా ఫైదకరతె; ధర్మషాస్ర్తం కొయింతెబారేమా అతిక్రమంకొయిని హుసె. ");
INSERT INTO vgr_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","ఆ కారణంతీబి యో వాక్ముల్‍నా ఖంయదాన్‍ ఖారవ్నా, కాతొ ధర్మషాస్ర్తం వాలనా మాత్రం కావే అబ్రాహామ్‍నా ఛాతె విష్వాస్‍ఛాతె ఇవ్నా కెడెబి ఘటిన్‍ హోనుకరి, కృపానానుసరించిన్‍ ఛాతిమ్‍, యో విస్వాసను మూలంహుయు యో అప్నహాఃనా భాహుయీన్‍ ఛా. ");
INSERT INTO vgr_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","ఇనే విష్వాస్‍ రాక్యొతె దేవ్నా ఖామే, కతొ మరిగుతె వాలన జివ్వాడవాలో, కొయింతే ఇనా ఛాతె తిమ్‍ బొలయోహుయుతె దేవ్నా హఃమే, యో అప్న ఖారనా భాహుయిన్‍ ఛా. అనటేకే తారు గూర్చి ఖారు జనాభోనా భానితరా నియమించోకరి లిఖ్కిరాక్యుస్‍. ");
INSERT INTO vgr_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","అబ్రహమ్‍ నమ్మకంతి ర్హైన్‍ కెత్రూకి అద్మియేనా తున ఉండునని తారు సంతానంనా ఇమ్మాస్‍ ర్హాస్‍కరి బొలుయుతె ఇనాబట్టి ఇనాస్‍ జనాబనా భా హువాతిమ్‍, నిరీక్చణనా ఆధారం కొయినితెదె యో నిరీక్చణ కలిగిన్‍ నమ్మెయో. ");
INSERT INTO vgr_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","అబ్రహామ్నా బొరాబ్బర్‍ ఖోః వరఖ్‍ వుంబర్‍ ర్హాహియు, అజు యో విష్వాస్‍మా ఖంజొర్‍వాలో కాహే, తెత్రమా ఇను ఆంగ్తాను సారా బెజినినా వామ్జిణితరా హాఃయల్‍ పన్కి. ఇనే విష్వాస్‍మా కంజోర్‍ కోహుయోని. ");
INSERT INTO vgr_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","అవిష్వాస్‍నుటేకె దేవ్ను వాక్ముల్‍ను గూర్చి సందేహించక ఇను విష్వాస్‍ ఇనా బలపర్చూ, దేవ్ను మహిమ పరిచి, ");
INSERT INTO vgr_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","యో వాక్ముల్‍ దిదొతె ఇనా నెరవేర్చనాటేకె కరిదేఖడావాలోతరా ఖఛ్చితంగా విష్వసించి విష్వాసంటేకె తాఖత్నా పొంద్యె. ");
INSERT INTO vgr_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","అనటేకే అబ్రహామ్‍ విష్వాసం మూలమతీ ఇనా నీతితార ఎంచబడ్యొ. ");
INSERT INTO vgr_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","యో ఇనా ఎంచబడ్నుకరి ఇనా నిమిత్తం మాత్రంమస్‍ లిఖ్కాయు కాహేపన్కి; ");
INSERT INTO vgr_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","అప్నా ప్రభువుహుయుతె యేసునా మరిగొతె కంతు ఉట్యోతె ఇనా విష్వాస్‍ర్హాకిన్‍ లిఖ్కు గయూతిమ్‍ నిమిత్తంటేకె అప్నా ఎంచబడ్యు. ");
INSERT INTO vgr_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","యో అప్ను పాప్‍నా నిమిత్తం ధరాయిజైయిన్, అప్నె దేవ్మా నీతి మంతుల్‍ గోని తీర్చబడనాటేకె ఉట్యో. ");
INSERT INTO vgr_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","అనటేకె విష్వాస్‍ మూలంనా అప్నే నీతిమంతుడ్‍ తార తీర్చబడిన్‍, అప్నా ప్రభువుహుయుతె యేసు క్రీస్తుతిస్‍ దేవ్తి షాంతిసమాధానం కలిగిరాసు. ");
INSERT INTO vgr_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","అజు ఇనాబారేమా అప్నా విష్వాస్‍నాటేకె ఆ కృపమా ప్రవేసంహుయు, ఇనమా ఉబ్రిర్హాహిన్‍, దేవ్ను మహిమనా గూర్చినా నిరీక్చణటేకె గౌర పడుకరియేస్‍. ");
INSERT INTO vgr_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","ఎత్రెస్‍ కాహే; కష్టంమా అతిషయ పడియేస్‍, అప్నా మాలం పరీక్చా నిరీక్చాణ కల్గాంకరస్‍. ");
INSERT INTO vgr_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","మిన్హత్‍ ఓర్పునా, ఓర్పు పరీక్చానా, పరీక్చా నిరీక్చణనా కల్గమ్‍కరస్‍కరి మాలం; స్రమల్‍మా అతిసయపడో. ");
INSERT INTO vgr_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","సానటేకె కతొ ఆ నిరీక్చణ అప్నా షెరం కోహువదేయ్‍ని. అప్నా అనుగ్రహించబడొతె పరిసుద్ధాత్మతీస్‍ దేవ్ను ఫ్యార్‍ అప్నా దిల్‍మా కుమ్మరించిన్‍ ఛా. ");
INSERT INTO vgr_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","కింకతో అప్న హంకెతో నిరీక్చణ కొయింతే ఇవ్నితరా, క్రీస్తు అప్నాదేవ్‍ భక్తిహీనుల్‍నాటేకె మరిగొ. ");
INSERT INTO vgr_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","నీతిమంతుడ్‍నాటేకె సహితం ఏక్జాను మరిగొతొ మాములీస్‍; అష్యల్‍వాలనాటేకె కొన్‍బి ఎక్తార మరిజావనాటేకె తెగించస్‍. ");
INSERT INTO vgr_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","హుయుతో దేవ్‍ అప్నబారేమా ఇను ఫ్యార్‍ వెల్లడిపరుచుకురాస్‍; కిమ్‍కాతొ అప్నె హంకెబి పాపేలుహుయిన్‍ ర్హావమా క్రీస్తు అప్నాటేకె మరిగొ. ");
INSERT INTO vgr_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","అనటేకే ఇను ల్హొయి హంకె నీతిమంతుడ్‍ తార తీర్చబడిన్‍, అజు నిష్చయంతి ఇనెతీస్ ఖీజ్‍మతూ బఛ్చాయిజాసు. ");
INSERT INTO vgr_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","అప్నే వైరిహుయిన్‍‌ థాబి, ఇను ఛియ్యాన మరణ్‍తీస్‍ అప్నే దేవ్తి సమాధానం పరచబడిన్‍ యో జీవం అజు ఖఛ్చింతిస్‍ బఛ్చాయిజాసు. ");
INSERT INTO vgr_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","యోస్‍కాహె; అప్ను ప్రభువుహుయుతె యేసు క్రీస్తుతిస్‍ అప్నె దేవ్కనా అతిసయ ఖుషి పడుకరుయేస్‍; ఇనేతిస్‍ అప్నె హంకె సమాధానంను స్థితిని పొందిరాక్యస్‍. ");
INSERT INTO vgr_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","అమ్‍ ర్హావమా ఏక్‍ అద్మినుబారేమా పాప్‍బీ పాప్‍ను బారేమా మరణ్‍ ములక్‍మా కిమ్‍ ప్రవేసించుకి, ఇమ్మాస్‍ అద్యియోక్హారనా పాప్‍ కార్యెయోతె మరణ్‍ హాఃరనా దాపరించూ. ");
INSERT INTO vgr_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","కింకతొ ధర్మషాస్ర్తం అవకొయిన్‍తె అగాడి పాప్‍ ములక్‍మా ఛా, పన్కి ధర్మషాస్ర్తం కొయింతే వఖాత్‍ పాప్‍ నిరూపించె కోహుయుని. ");
INSERT INTO vgr_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","హుయుతోబి ఆదామ్‍ కర్యొతె అతిక్రమంనాజోక్ పాప్‍ కరకొయితె ఇవ్నపర్బి, ఆదామ్‍తూ సురూహుయిన్‍ మోషేతొడి మరణ్‍నా యేల్యూ; ఆదామ్‍ అవ్సెతె ఇనా గుర్తుహుయిన్‍ ఛా. ");
INSERT INTO vgr_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","హుయుతో పాప్‍ హుస్‍తిమ్‍ కృప వరమ్‍ కలుగ్యుకొయిని. కింకాతొ ఏక్ను అపరాధంనాటేకె ఘనుజను మరిగ్యొతొ బుజు ఘను దేవ్ను కృపబి, యేసుక్రీస్తు ఏక్‍ అద్మిహుయుతె యేసుక్రీస్తు కృపతి కెత్రుకి జననా ప్హైలాయుగయూ. ");
INSERT INTO vgr_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","అజు పాప్‍ కరిన్‍ ఏక్నాటేకె సిక్చావిధి హోనుతిమ్‍ యో ధానమ్‍ హుయుకొయుని. కిమ్‍ కతొ న్యావ్‍ ఏక్‍ అపరాధం మూలంతి ఆయుతె సిక్చావిధి కారణంహుయు; కృపావరంహుయుతె ఘానుహుయుతె అపరాధంను మూలమా అయుతె అద్మియోనా నీతిమంతుడ్‍తార తీర్చబడ్‍సే కారణంహుయు. ");
INSERT INTO vgr_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","మరణం ఎక్నా పాప్‍ మూలంతి అయుతె యో ఏక్నతీస్‍ ఏలితొ బారేమ కృపాబాహుల్యంనా నీతి దానంనా పొందవాల జీవం ఛాతె ఇవ్నే, అజు నిష్చయంతి యేసుక్రీస్తు ఏక్నా తీస్‍ పాల్సు. ");
INSERT INTO vgr_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","అనటేకే న్యావ్‍ ఏక్‍ పాప్‍నా మూలంతి అయుతె, అద్మియోనా ఖారనా సిక్చావిధి హువానాటేకె కిమ్కి కారణంహుయు, ఇమ్మాస్‍ ఏక్‍ పుణ్య్ కార్యంనాటేకె అద్మియే ఖారనా జీవం ప్రథమ్‍హుయుతె నీతి విధింపబడనటేకె కారణం హుయు. ");
INSERT INTO vgr_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","కిమ్కాతొ ఏక్‍ అద్మి అవిధేయతటేకె ఘానుజనణ పాప్‍వాల కిమ్‍ కర్యోకి, ఇమ్మాస్‍ ఏక్ను విధేయతనటేకె ఘానుజను నీతిమంతుడ్‍తరా కార్యంహుయుతె. ");
INSERT INTO vgr_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","అజు అపరాధం ఫేలాయుతిమ్‍ ధర్మషాస్ర్తం పేఖిన్‍, హుయుతొబి పాప్‍ కేజ్గా బఢాస్‍కి ఏజ్గాగ దేవ్ను కృప అజు ఘాను బఢాసే. ");
INSERT INTO vgr_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","ఇమ్మాస్‍ నిత్యమ్‍జీవం కలుగనాటేకె, నీతి తీస్‍ కృపబి అప్ను ప్రభువుహుయోతె యేసుక్రీస్తు మూలంతి పాలనునిమిత్తం పాప్‍ కెజ్గా ఫైలాయుకి ఎజ్గా కృప ఘాను ఫైలాయు. ");
INSERT INTO vgr_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","ఇంతోబి సాత్‍బోలిస్‍? కృప ప్హైలావునుకరి పాప్‍మా ఉబ్రీన్‍రయ్యానా? ");
INSERT INTO vgr_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","ఇంమ్‍ నా బోల్ను. పాప్‍నా విషయంమా మర్‍జైయిన్‍ అప్నె హంకేతునికీన్‍ కింమ్‍ ఇన్నా జీవ్‍సు. ");
INSERT INTO vgr_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","క్రీస్తు యేసుమా బాప్తిస్మమ్‍ పొందితె, అప్నే ఖారబి ఇను మరణ్‍మా బాప్తిస్మం పొంద్యాకరి తుమ్నా మాలంకొయిన్‍నా కాహేన? ");
INSERT INTO vgr_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","అప్నే బాప్తిస్మమ్‍ బారేమా మరణ్‍మా పాలు పొందనాటేకె కోమ్దీన్‍ గడాయ్‍గయా. అనటేకే భా మహిమనటేకె క్రీస్తు మరణ్‍మతు కిమ్‍ ఉట్యోకి, ఇమ్మాస్‍ అప్నేబి నవూ జీవంమా పొందితెవాలహుయిన్‍ ఛాల్‍తిమ్‍, ");
INSERT INTO vgr_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","అజు ఇను మరణ్‍న సాద్రుష్యమా ఇనేతి మలిన్‍ ఛాతె ఇవ్నే బారెమ, యో జీవిన్‍ ఉట్టమా సాద్రుస్యంమా ఇనేతె మలిన్‍ వాలహుయిన్‍ ర్హాసు. ");
INSERT INTO vgr_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","సాత్కతొ అప్నె హంకేబి పాప్నా దాసుల్‍ నాహోనుతిమ్‍ పాప్ను ఆంగ్తన్నా ర్హావకొయినితిమ్‍ గతించుగయూతె, అప్ను జూను స్వభావంనా ఇనాకెడె సిలువ నాక్యుకరి మాలం. ");
INSERT INTO vgr_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","మరిగొతె యోఅద్మి పాప్‍మతూ బఛ్చీన్‍ విడుదలా పొందిరాక్యుస్‍. ");
INSERT INTO vgr_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","అప్నె క్రీస్తునాకెడె మరిగుతొ, ఇనాకెడే జీవ్సు ర్హాసుకరి నమ్ముకురుస్‍. ");
INSERT INTO vgr_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","హామ్న మాలం క్రీస్తు మారణ్‍ మాతు జివుట్యో, క్రీస్తు అజు మర్సేకొయినికరి, మరణ్‍ ఇనాపార్‍ అధికారమ్‍ కర్సెకొయిని. ");
INSERT INTO vgr_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","కిమ్‍కతొ యో మరణ్‍ దేఖ్యతొ, పాప్‍ను విషయంహుయ్తొ, ఎక్కాస్‍త్తార మరిగొ పన్కి యో జీవ్ను దేఖ్యతొ, దేవ్ను విషయంహుయిన్‍ జిమ్కరాస్‍ ");
INSERT INTO vgr_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","ఇంనితార తుమేబి పాప్‍నా విషయంహుయిన్‍ మరణ్‍నితార ఛా, దేవ్ను విషయంహుయిన్‍ క్రీస్తుయేసుమా జీవ్నుజివం తార తుమ్నా తుమేస్‍ ఎంచిలెవొ. ");
INSERT INTO vgr_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","అనహాఃజె ఆంగ్‍తాను దురాషనా లోబడుతిమ్‍ మరణ్‍నా లోనుహుయుతొ తుమరు ఆంగ్‍తాన్‍మా పాప్‍నా ఏల నొకొదెవొ. ");
INSERT INTO vgr_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","అజు తుమరు అవయవమునా క్హారబ్‍ సాధనంనీతరా పాప్‍నా ద్హరాయి నొకొలెవొ, హుయుతొ మరణ్‍మతూ జీవ్తావాలకరి, తుమ్నా తుమేస్‍ దేవ్నా ద్హారయిలెవొ, తుమరు అవయవమునా నీతిసాధనంగా దేవ్నా ద్హారయిలెవొ. ");
INSERT INTO vgr_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","తుమే దేవ్ను కృపనాస్‍ పన్కి ధర్మషాస్ర్తంనా లోబడహుయుతె ఇవ్నె కాహే, పన్కి పాప్‍నా తుమరఫర్‍ అధికారం కార్సేకొయినీ. ");
INSERT INTO vgr_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","ఇమ్‍ హుయుతొబి కృపనాస్ పన్కి ధర్మషాస్ర్తంనా లోనుహువాల కాహెకరి పాప్‍నా కరియేనా? ఇమ్‍ కాహెస్‍ కాహే. ");
INSERT INTO vgr_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","లొంగనాటేకె దేవ్నా తుమారు తుమేస్‍ దాసుడ్‍తార ద్హారయిలిసూకి, యో మరణ్‍ను నిమిత్తంతార పాప్‍నాస్‍ పన్కి, నీతి నిమిత్తంతరా విధేయతనాస్‍ పన్కి, కినా తుమే లోబడ్సుకి ఇనాస్‍ దాసుడ్‍హుసుకరి తుమ్న మాలంకొయినా? ");
INSERT INTO vgr_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","దేవ్నా ధన్యవాద్‍ కరుకురుస్‍ తుమే పాప్నా దాసుడ్‍హుయిన్‍ ర్హయ్యా పన్కి కేవు ఉపదేషక్రమంనా తుమే అప్పగిమ్చలిదాకి, ఇనా దిల్‍నుపూర్వకంతి లోబడిన్‍ర్హావొ, ");
INSERT INTO vgr_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","పాప్‍మాతు ఛూట్కార్‍హుయిన్‍ నీతినా దాసులైహుయ అనటేకే దేవ్నా స్తోత్రం. ");
INSERT INTO vgr_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","తుమే ఆంగ్తాను ఖంజొర్‍టేకె మే అద్మితార వాత్‍బొలుకురాస్‍ కింకాతొ అతిక్రమంనా కారనాటేకె, అపవిత్రతనా బుజు పాప్న అక్రమంనా తుమరు అవయవంనా నీతినాలిన్‍ పరిషుద్ధఆత్మ ఛాలవ్వానటెకే దాసుడ్‍తార అప్పగించిలెవొ. ");
INSERT INTO vgr_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","తుమే పాప్నా దాసుడ్‍హుయిన్‍ ర్హాయితెదె నీతినువిషయమం ఆడుకొయింతె వాలహుయీన్‍ రయ్యా. ");
INSERT INTO vgr_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","తెదెను క్రియల్నాటేకె తుమ్నా సాత్బి ఫలం హుయుకి? ఇనాగురించి తుమే హంకే షరంలెంకరస్‍ కాహేనా? ఇనా అంతమ్‍ మరణ్ నా ఫలితం, ");
INSERT INTO vgr_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","అజుబి హంకేబి పాప్‍మతు విమోచింపబడీన్‍ దేవ్నా దాసుడ్‍హుయతిమ్‍ పరిసుద్ధత హువతిమ్‍ తుమ్నా ఫలం ఇను అఖరిను ఫలితం నిత్యమ్‍జీవం. ");
INSERT INTO vgr_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","కింకతొ పాప్నాటేకె అవ్సేతె జీతం మరణ్‍, హుయుతొ దేవ్ను కృపవరమ్ అప్ను ప్రభువుహుయుతె క్రీస్తుయేసుమా నిత్యమ్‍జీవం. ");
INSERT INTO vgr_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","భ్యేనే భైయే, అద్యియో జీవిన్ ర్హావతొడి ధర్మషాస్ర్తం ఇనాఫర్‍ హాఃర్కార్‍ కరూకరస్నాకరి తుమ్న మాలంకొయిన్నా? ధర్మషాస్ర్తంనా మాలంహుయుతె తుమారేతి వాత్‍బోలుకురూస్‍. ");
INSERT INTO vgr_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","బావ్రిఛాతె బాయికొ, బావ్రి జీవిన్‍ర్హావతొడి ధర్మషాస్ర్తంనటేకె ఇన బద్ధురాల్‍ పన్కి, బావ్రి మరిగొతొ బారేమ బావ్రి విషయంహుయిన్‍ ధర్మషాస్ర్తం మాతు యో ఛుట్కా పొంది. ");
INSERT INTO vgr_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","అనటేకే బావ్రి జీవిరాహితొ యో అజెక్‍ అద్మితి జాయితొ వ్యభిచారికరి బోల్సె పన్కి, బావ్రి మరిగొతో యో ధర్మషాస్ర్తంన కంతు విడుదల పొందిన్‍ పన్కి అజేక్‍ అద్మినా య్హా కార్లిదితొ వ్యభిచారిని వుసెకొయిని. ");
INSERT INTO vgr_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","మార భ్యేనే భైయే, అప్నే దేవ్నాటేకె ఫలం ఫలించెతిమ్‍ మరణ్‍ కంతు ఉట్యోతె క్రీస్తు కరి అలాదనా చేరనాటేకె తుమేబి ఇను ఆంగ్తాన్‍తిస్‍ ధర్మషాస్ర్తం విషయంహుయున్‍ మరిగా. ");
INSERT INTO vgr_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","కింకాతొ అప్నే ఆంగ్తాను సంధంహుయిన్‍ ర్హాయతేదె మరణ్‍ సంబంధంహుయితె ఫలంనా ఫలింనటేకె, ధర్మషాస్ర్తంనటేకె పాప్ను ఆఖ్‍ఃతి అప్ను అవయంతి కామ్‍ కార్తురహియు. ");
INSERT INTO vgr_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","హంకెహుయుతో దేవ్తి నిర్బంధింబడిహుయుతె ఇను విషయంహుయిన్‍ మరిగాతె అప్నే, ధర్మషాస్ర్తం కంతు ఛుట్కార పొంద్యా పన్కి అప్నె అక్చర్‍నా సారంహుయుతె జూనుస్థితివాలా కాహె ఆత్మనుసారంతి నౌవుస్థితి వాలాహుయిన్‍ సేవా కరుకరియేస్‍. ");
INSERT INTO vgr_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","అనటేకే సాత్‍బొల్ను? ధర్మషాస్ర్తం పాప్నా? ఇంనాబొల్ను. ధర్మషాస్ర్తంనటేకె పన్కి పాప్‍కాతొ సాత్కి మన మలంకొయిని. ఆఖ్‍ఃకరోనోకొకరి ధర్మషాస్ర్తం బొలుతెబారెమ దురాసనా కెద్దెనుకి మన మలంకోయిని. ");
INSERT INTO vgr_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","హుయుతొ పాప్‍ ఆజ్ఞాననా కర్లీన్‍హాఃరు విధంహుయుతె దురాసనా మారమా పుట్టించొ. ధర్మషాస్ర్తం కొయింతే వహఃత్‍ పాప్‍ మరిగు. ");
INSERT INTO vgr_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","9","ఏక్తార మే ధర్మషాస్ర్తం కొయిన్‍తిమ్ జీవించుకరథో పన్కి, ఆజ్ఞ ఆయుతెదే పాప్నా ఆజు జీవ్ను ఆయు; మేహుయుతొ మరిగో. ");
INSERT INTO vgr_vpl VALUES ("RM7_10","075_7_10","ROM","7","10","10","తెదే జీవార్థంహుయుతె ఆజ్ఞనా మన మర్జాంతరా దెహాఃయు. ");
INSERT INTO vgr_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","కింకాతొ పాప్‍ ఆజ్ఞనా హేతువుకరిన్‍ మన దోహాఃకరిన్‍ ఇనేతి మన మరదిదొ. ");
INSERT INTO vgr_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","అనటేకే ధర్మషాస్ర్తంమా పరిసుద్ధ హుయుతె, ఆజ్ఞకెడె పరిసుద్ధడ్‍హుయుతె నీతిమంతుడ్‍హుయుతె ఉత్తమంహుయిన్‍ఛా. ");
INSERT INTO vgr_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","ఉత్తమంహుయుతె మన మరణ్‍నా హుయునా? ఇమ్‍ నాబొల్ను. హుయుతొ పాప్‍ ఉత్తమంహుయుతె ఇనా మూలంతి మన మరణంనా కరావ్తూ, పాప్‍ పాప్‍హుయుతిమ్‍ ద్యెక్హావతిమ్‍ నిమిత్తం, కాతొ పాప్‍ ఆజ్ఞమూలంతి గ్హను పాప్‍హుయుతె నిమిత్తం, యో మన మరణ్‍కరంహుయు. ");
INSERT INTO vgr_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","ధర్మషాస్ర్తం ఆత్మ సంబంధహుయుతె మాలం; హుయుతె మే పాప్‍నా ఎచ్చాయ్‍జైయిన్‍ ఆంగ్తాను సంబంధహుయిన్‍ ఛా. ");
INSERT INTO vgr_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","కింకతొ మే కారొయోతె మే మాలంకోకర్యోని; మే కరుతె నిచ్ఛయించుతె కార్యొకొయినితిమ్‍ ద్యేషించుకారుతె కరూకురుస్‍. ");
INSERT INTO vgr_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","ఇచ్ఛయింపుతె మే కార్యాతెబారెమ ధర్మషాస్ర్తం అషల్‍కరి ఒప్పుకురుస్‍. ");
INSERT INTO vgr_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","అనటేకే హంకెతు ఇన కరూకరతె మేకాహె మారకనా జింకరతే పాపస్‍ పన్కి మే కాహె. ");
INSERT INTO vgr_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","18","మరకాన, కాతొ మరు ఆంగ్‍తాన్‍మ అష్యల్ కేవుకి నివసించెకొయినికరి పాప స్వభావం మనమలం. పన్కి అష్యల్ కర్నూకరి ఆఖ్‍ః మన హుకొరాస్ పన్కి, ఇనా కరనటేకె మన హుకొరకొయిని. ");
INSERT INTO vgr_vpl VALUES ("RM7_19","075_7_19","ROM","7","19","19","మే కర్నూకరి మేలు కరకొయిన్తిమ్‍ కరీస్‍కొయిని నాకర్నూతే యో కీడు కరూకురూస్‍. ");
INSERT INTO vgr_vpl VALUES ("RM7_20","075_7_20","ROM","7","20","20","మే కొర్యొకోయిన్తే ఇనా కార్యోతొ, ఇనా కార్యెతె మరకాన నివసించితె పాప్‍మస్‍ పన్కి హంకెబి మే కాహె. ");
INSERT INTO vgr_vpl VALUES ("RM7_21","075_7_21","ROM","7","21","21","అంనితార మన ఏక్‍ ధర్మషాస్ర్తం నియమమ్‍ మాలంహుయు. యోసాత్‍ కాతొ అషల్ కర్‍నుకరి ఇష్టంహుయుతె ఎజ్గా పాప్‍ ఛా. ");
INSERT INTO vgr_vpl VALUES ("RM7_22","075_7_22","ROM","7","22","22","మారు దిల్‍ దేవ్నా ధర్మషాస్ర్తంమా మే ఖుషితిఛావ్‍ ");
INSERT INTO vgr_vpl VALUES ("RM7_23","075_7_23","ROM","7","23","23","అజేక్‍ నియమం మారు అవయవల్‍తి ఛాతె మన ద్యెఖాకురాస్. యో మారు దిల్మా ధర్మషాస్ర్తంతి లడ్డాయికరిన్‍ మారు అవయనల్‍మాఛాతె పాప్‍నునియమంనా మన లోబరొచుకురుస్‍. ");
INSERT INTO vgr_vpl VALUES ("RM7_24","075_7_24","ROM","7","24","24","అయ్యో, మేఎత్రెస్‍ బేకార్‍? అద్దాను మరణ్‍నా లోనుహువతిమ్‍ ఆంగ్తాన్‍కంతు మన చుఖాయో? ");
INSERT INTO vgr_vpl VALUES ("RM7_25","075_7_25","ROM","7","25","25","అప్నొ ప్రభువుహుయుతె యేసు క్రీస్తుతిస్‍ దేవ్నా ధన్యవాద్‍ బోలుకురుస్‍, హువమా దిల్‍ను విషయంమా మే దేవ్ను ధర్మషాస్ర్తంను, ఆంగ్తాను విషయంమా పాప్నా దాసుడుహుయిరొస్‍. ");
INSERT INTO vgr_vpl VALUES ("RM8_1","075_8_1","ROM","8","1","1","అనటేకె హంకె క్రీస్తుయేసుమఛాతే ఇవ్నా కెవు సిక్చవిధిబీ కొయిని. ");
INSERT INTO vgr_vpl VALUES ("RM8_2","075_8_2","ROM","8","2","2","క్రీస్తుయేసుమా జీవందేస్తె ఆత్మను నియమంన పాప్‍ అజు మరణ్‍ నియమం కంతు మన చుక్కాయు. ");
INSERT INTO vgr_vpl VALUES ("RM8_3","075_8_3","ROM","8","3","3","ఆంగ్తాన్‍నా అనుసరించకొయిని‍తిమ్‍ ఆత్మను అనుసరించినాస్‍ ఛాల్ను అప్నాకన ధర్మషాస్ర్తం సంబంధహుయుతె నీతివిధి నెరవేర్చచును కరి పాప్‍ను పరిహారంనిమిత్తం. ");
INSERT INTO vgr_vpl VALUES ("RM8_4","075_8_4","ROM","8","4","4","దేవ్‍ ఇనో ఛియ్యోను పాప్‍మా ఆంగ్తానుసారంతి బొలిమొక్లీన్, యో ఆంగ్‍తాన్‍మా పాప్‍ను సిక్చనా విధించు. ");
INSERT INTO vgr_vpl VALUES ("RM8_5","075_8_5","ROM","8","5","5","ఆంగ్తానుసారులు ఆంగ్తాన్ను విషయంపర్‍ దిల్‍రాక్సు; ఆత్మను సంబందహుయుతె ఆత్మను విషయంపార్‍ దిల్‍కారక్సు; ఆంగ్‍తాను సారంహుయుతె దిల్నా మరణ్‍; ");
INSERT INTO vgr_vpl VALUES ("RM8_6","075_8_6","ROM","8","6","6","ఆత్మాను సారంహుయుతె దిల్‍ జీవంనబి షాంతి సమాధానంహుయిన్‍ ఛా. ");
INSERT INTO vgr_vpl VALUES ("RM8_7","075_8_7","ROM","8","7","7","కింకాతొ ఆంగ్తాను సారంహుయుతె దిల్‍ దేవ్నా విరొధంహుయిన్‍ ఛా; యో దేవ్ను ధర్మషాస్ర్తం లోబడ్సెకొయిని, ఏమాత్రంబి లోబడ్సేకొయిని. ");
INSERT INTO vgr_vpl VALUES ("RM8_8","075_8_8","ROM","8","8","8","ఆంగ్తాను స్వభావంతి ఛాతె ఇవ్నే దేవ్నా ఖుషీ కరకొయిని. ");
INSERT INTO vgr_vpl VALUES ("RM8_9","075_8_9","ROM","8","9","9","దేవ్ను ఆత్మ తుమరమ నివసించిరాహితొ బరెమ తుమే ఆత్మను స్వభావంతి ఛాతె ఇవ్నే పాన్కి ఆంగ్తాను స్వభావం ఛాతె ఇవ్నేకాహె. కొన్బి క్రీస్తు ఆత్మ కొయితె ఇవ్నే యో ఇనువాలో కాహె. ");
INSERT INTO vgr_vpl VALUES ("RM8_10","075_8_10","ROM","8","10","10","క్రీస్తు తూమరమ ర్హహితొ తుమారు ఆంగ్తాన్‍ పాప్‍ను విషయంహుయిన్‍ మరిగయో పన్కి తుమారు నీతి విషయంహుయుతె జీవం కల్గిన్‍ ఛా. ");
INSERT INTO vgr_vpl VALUES ("RM8_11","075_8_11","ROM","8","11","11","మరణ్‍మతూ కంతు యేసునా ఉట్యోతె ఇన ఆత్మ తుమారమ నివసించిన బారెమ, మరిగొతె కంతు క్రీస్తుయేసునా ఉట్యోతె మరనాటేకెలొను హుయుతె తుమారు ఆంగ్‍తాన్‍న కెడె తుమారమ నివసించుకురతె ఇను అత్మతిస్‍ జీవడ్సే. ");
INSERT INTO vgr_vpl VALUES ("RM8_12","075_8_12","ROM","8","12","12","అనటేకే భేనే భైయెనా, అప్నె ఇమ్‍ జీవనా కర్తవయం ఉన్నది. ఆంగ్తాను సారంతి ఛాల్‍నటేకె ఆప్నెఆంగ్తనా ‍రుణపడిన్‍ కోచయ్యెని. ");
INSERT INTO vgr_vpl VALUES ("RM8_13","075_8_13","ROM","8","13","13","తుమే ఆంగ్తానుసారంహుతె ఛాలితొబరెమ మరనుతు ఇవ్నే ర్హాసు పాన్కి, ఆత్మతి ఆంగ్‍తాను క్రియల్తి మరఖిదిదుతోబి జీవ్సు. ");
INSERT INTO vgr_vpl VALUES ("RM8_14","075_8_14","ROM","8","14","14","దేవ్ను ఆత్మతి కెత్రుకి ఛాలయాహుయో ఇవ్నె హాఃరు దేవ్ను ఛియ్యోహుయు రాసు. ");
INSERT INTO vgr_vpl VALUES ("RM8_15","075_8_15","ROM","8","15","15","కింకతొ అజు ఢరనాటేకె తుమే దాస్యపు ఆత్మన పొందకొయిని పన్కి దత్త ఛియ్యోను ఆత్మనా పొంద్యొ యో ఆత్మ కలిగితె ఇవ్నే అప్నె అబ్బా భా కరి ప్రార్థనా కరూకరుయేస్‍ ");
INSERT INTO vgr_vpl VALUES ("RM8_16","075_8_16","ROM","8","16","16","అప్నె దేవ్‍ లడ్కాకరి ఆత్మ ఇనూయోస్‍ అప్ను ఆత్మతి కెడె సాక్చ్యం దెమ్కరాస్. ");
INSERT INTO vgr_vpl VALUES ("RM8_17","075_8_17","ROM","8","17","17","అప్నె లడ్డాకహుయుతొ వారసులం, కాతొ దేవ్ను వారసులం; క్రీస్తున కెడె మహిమ పొంనాటేకె యో స్రమపాడితె బరెమ, క్రీస్తునాకెడె వారసులం. ");
INSERT INTO vgr_vpl VALUES ("RM8_18","075_8_18","ROM","8","18","18","అప్నుబరెమ ప్రత్యక్చం వుసెతె మహిమనా ఖామే హంకెను వఖాత్మ స్రమల్‍ కోర్లీదుతే కాహెకరి ఎంచుకురుస్‍. ");
INSERT INTO vgr_vpl VALUES ("RM8_19","075_8_19","ROM","8","19","19","దేవ్ను ఛియ్యో ప్రత్యక్చతంటేకె సృష్టి గ్హాను ఆహ్ః తి దేక్తూ ర్హంకరస్‍. ");
INSERT INTO vgr_vpl VALUES ("RM8_20","075_8_20","ROM","8","20","20","కింకతొ సృష్టి, నాసనంనా లోనుహుయుతె దాస్యంన కంతు చొడాయిన్‍, దేవ్ను లడ్కా పొంద్సే‍తె మహిమను స్వాతంత్ర్యంనా పొందీస్కరి నిరీక్చణహుయీవ్‍, ");
INSERT INTO vgr_vpl VALUES ("RM8_21","075_8_21","ROM","8","21","21","స్వేచ్ఛతిమ్‍ కాహె ఇనా లోపర్‍చుతెవాలనా మూలంతి పాల్తుహుయ్రూస్. యో ");
INSERT INTO vgr_vpl VALUES ("RM8_22","075_8_22","ROM","8","22","22","హమ్నా ఆ మాలం సాత్కాతో, సృష్ట హాఃరు హంకెతొడి ఏక్‍హుయిన్ టుమ్తూ జనాను ధర్రాద్‍ పడుకరస్‍కరి అప్నామాలం. ");
INSERT INTO vgr_vpl VALUES ("RM8_23","075_8_23","ROM","8","23","23","యోస్కాహేతిం, ఆత్మను ప్రథమ ఫల్నా అగాడిను ఫలంన పోందతె అప్నెబి దత్త ఛియ్యోనటేకె, కతొ అప్ను ఆంగ్తాన్ను విమోచనమ్నటేకె మాలంకరిన్‍ అప్నమా అప్నే టుముకురస్‍ ");
INSERT INTO vgr_vpl VALUES ("RM8_24","075_8_24","ROM","8","24","24","కిమ్‍కతొ అప్నే ఆఖ్ తి కల్గతె వాలహుయీన్‍ బఛ్చాయిగా. నిరీక్చింప బడ్యుతె దెఖాయుతెదె, ఆఖ్‍ తి కామ్‍కోర్హాయిని; ఇనే దేకుకరతే ఇనాటేకె కోన్‍ ఆఖ్‍ తి ర్హాను? ");
INSERT INTO vgr_vpl VALUES ("RM8_25","075_8_25","ROM","8","25","25","అప్నే ద్యెకాకొయితెటేకె ఆఖ్‍ తి బరెమ ఓపికతి ఇనటేకె మాలంకార్‍సు. ");
INSERT INTO vgr_vpl VALUES ("RM8_26","075_8_26","ROM","8","26","26","ఇంనితరా పవిత్రఆత్మబి అప్ను కంజోర్న దేఖీన్‍ సహాయం కరూకురస్‍. కింకతొ అప్నె అష్యల్‍తి కిమ్‍కర్నుకి ప్రార్థన కార్‍నుకరి అప్న మలంకొయిని పాన్కి, వాత్‍ బొలనాహువ కొయిన్‍తె క్హాదరిన్‍ యో ఆత్మనాస్‍ అప్నె బణెతి విజ్ఞాపనమ్‍ కరుకురస్‍. ");
INSERT INTO vgr_vpl VALUES ("RM8_27","075_8_27","ROM","8","27","27","అజు దిల్మ పరిసోధించొవాలొ ఆత్మనుబి దిల్‍ను సాత్‍కి మాలం; కింకతొ ఇన దేవ్ను చిత్తప్రకారం పరిసుద్ధనటేకె విజ్ఞాపనం కరూకరస్‍. ");
INSERT INTO vgr_vpl VALUES ("RM8_28","075_8_28","ROM","8","28","28","హామ్నా మాలం. దేవ్న ఫ్యార్‍కరవాల, కాతొ ఇను సంకల్పం చొప్పున బులైయతె ఇవ్నే, అష్యల్ హువనటేకె ఖారున సమకుడిన్‍ హుకొరస్‍కరి మాలం, ");
INSERT INTO vgr_vpl VALUES ("RM8_29","075_8_29","ROM","8","29","29","సానటేకెకాతొ ఇను ఛియ్యోబి ఖారతి భైయెతి భేనేబి, జ్యెష్ఠడుహువతిమ్‍, దేవ్‍ కినా అగాడి మాలంకర్యకి, ఇవ్నే ఇనా ఛియ్యానితరా పోలీన్ రూపం‍ హువనాటేకె ఇవ్నే అగాడి నిర్ణయించో. ");
INSERT INTO vgr_vpl VALUES ("RM8_30","075_8_30","ROM","8","30","30","అజు కినా అగాఢి నిర్ణయించాకి ఇవ్నే బొల్య; కినా బొలయోకి ఇవ్నే నీతిమంతుల్‍తార కర్యాయో; కినా నీతిమంతుడ్‍ తార కర్యయోకి ఇవ్నే మహిమపరిచ. ");
INSERT INTO vgr_vpl VALUES ("RM8_31","075_8_31","ROM","8","31","31","ఇమ్‍ ర్హహితొ సాత్‍బొల్సు? దేవ్‍ అప్న బ్హనె ర్హహితొ అప్న విరోదంకొన్‍? ");
INSERT INTO vgr_vpl VALUES ("RM8_32","075_8_32","ROM","8","32","32","అజు ఇనో ఛియ్యాన దానంకరనాబి పిటె హట్యోకొయిని తిమ్‍ అప్న క్హారనటేకె ఇనా అప్పగించ్యొతె యో ఇనకేడె సమస్తంనా అప్న సానటేకె అనుగ్రహించ బడ్యుసేకోయిన్నా? ");
INSERT INTO vgr_vpl VALUES ("RM8_33","075_8_33","ROM","8","33","33","దేవ్తి ఏర్పచిరాక్యొతె ఇవ్నా ఫర్‍ నేరం నాక్యుతె యోకోన్‍? నీతి మంతుల్‍తరా హాఃరవాలొ దేవుస్‍; ");
INSERT INTO vgr_vpl VALUES ("RM8_34","075_8_34","ROM","8","34","34","సిక్చ విధించొవాలొ కోన్‍? మరిగొతె క్రీస్తు యేసుతూస్‍; యోస్‍ కాహె, మరణ్‍మతు ఉట్యోతె దేవ్ను ఖావాత్‍బణె ఛాతేయో అప్నాటేకె విజ్ఞాపతినంబి కరవాలోబీ యోస్‍. ");
INSERT INTO vgr_vpl VALUES ("RM8_35","075_8_35","ROM","8","35","35","క్రీస్తు ఫ్యార్‍ కంతు అప్నా దూర్‍ కారవాలొ యోకోన్‍? స్రమహుయుతొబి, బాధహుయుతొబి, హింసహుయుతొబి, ఖ్హాల్‍హుయుతొబి, లుంగ్డా క్హరాబ్‍ హుయూతోబి, ఉపద్రవంహుయుతొబి, తాల్వార్‍హుయుతోబి, అప్న దూర్‍కర్సేనా? ");
INSERT INTO vgr_vpl VALUES ("RM8_36","075_8_36","ROM","8","36","36","అనా గూర్చి లిక్యురాక్యుతె సాత్‍ కతొ తునా బట్టి ధిన్‍భరీన్‍ హమే కత్రాయావాలహుయ్రాస్‍ ఓత్రనా తయాయ్‍హుయుతె మ్హేంఢా కరి హమే ఎంచబడతేవాల. ");
INSERT INTO vgr_vpl VALUES ("RM8_37","075_8_37","ROM","8","37","37","హుయ్‍తోబి ఆ ఖారివాతేమా అప్నా ఫ్యార్‍కర్యతొయో ఇనా బారెమా అప్నె ఆ ఖారమా జాఖాత్‍ విజాయం పోందిరాక్యస్‍. ");
INSERT INTO vgr_vpl VALUES ("RM8_38","075_8_38","ROM","8","38","38","కిమ్‍కతో మరణ్‍హుయుతొబి జీవంహుయుతొబి దేవ్నుదూతహుయుతొబి ప్రధానుహుయుతొబి ఛాతెహుయుతొబి అవ్సెతెహుయుతొబి ఏలవాలొహుయుతొబి షక్తుల్‍ హుయుతొబి ఊచుహుయుతొబి ఘదర్‍హుయుతొబి సృష్టింపబడుతె బుజు కెవూబి, ");
INSERT INTO vgr_vpl VALUES ("RM8_39","075_8_39","ROM","8","39","39","అప్ను ప్రభువుహుయుతె క్రీస్తుయేసుమా దేవ్ను ఫ్యార్‍కంతు అప్నా దూర్‍ కర్సేకొయినీకరి ఖఛ్చితంతీ నమ్ముకురూస్‍. ");
INSERT INTO vgr_vpl VALUES ("RM9_1","075_9_1","ROM","9","1","1","మన ఘను దుఃఖం, మారు దిల్మా తీరకొయిన్‍తె వేదననా‌ ఛా. ");
INSERT INTO vgr_vpl VALUES ("RM9_2","075_9_2","ROM","9","2","2","క్రీస్తుకన ఖాచ్ఛిస్‍ బొలుకురుస్‍, జుట్టివాత్‍ కొయిన్‍. ");
INSERT INTO vgr_vpl VALUES ("RM9_3","075_9_3","ROM","9","3","3","పరిసుద్ధాత్మమ మారు దిల్‍సాక్చిన మారకెడె సాబుత్‍ దెమ్కొరతె. సాధ్యహుయుతొ బారెమ, ఆంగ్తాన్ సంబంది హుయుతె మారు భైయ్యేనాటేకె మే క్రీస్తుకంతు దూర్‍హుయీన్‍ షాపగ్రస్తుడ్‍ హువానటేకె కోర్లిస్‍. ");
INSERT INTO vgr_vpl VALUES ("RM9_4","075_9_4","ROM","9","4","4","అవ్నేఇస్రాయేల్‍ను; దత్తపుత్రత్వంన మహిమనబి నిబంధనల్‍నా ధర్మషాస్త్రం ప్రధానంహుయుతె ఆచారాలువాలన వాగ్దానంనా అవ్ను. ");
INSERT INTO vgr_vpl VALUES ("RM9_5","075_9_5","ROM","9","5","5","భానొభా అవ్నెవాల; ఆంగ్తానుబట్టి క్రీస్తుఅవ్నమా ఫైదాహుయో. యో సర్వాధికారిహుయు దేవ్‍హుయిన్‍ కెదేబి స్తొత్రార్హుడు హుటిన్‍‌ ఛా. ఆమేన్‍. ");
INSERT INTO vgr_vpl VALUES ("RM9_6","075_9_6","ROM","9","6","6","హుయుతొ దేవ్నువాత్‍ తప్పి జావంతరా కాహె; ఇష్రాయేల్‍ సంబంది ఖారుబి ఇష్రాయేలీయుల్‍ కాహె. ");
INSERT INTO vgr_vpl VALUES ("RM9_7","075_9_7","ROM","9","7","7","అబ్రాహామ్ను సంతానహుయుతె మాత్రంతి ఖారనబి లడ్డాకకాహె పన్కి “ఇస్సాక్‍టేకెహుయుతె తారు సంతానం కారిబొల్య” ");
INSERT INTO vgr_vpl VALUES ("RM9_8","075_9_8","ROM","9","8","8","కతొ ఆంగ్తాను సంబంది హుయుతె లడ్కాన దేవ్ను లడ్కాకాహే పన్కి వాక్ముల్‍నా సంబంది హుయుతె లడ్కా సంతానంకరి ఎంచబడ్‍సె. ");
INSERT INTO vgr_vpl VALUES ("RM9_9","075_9_9","ROM","9","9","9","వాక్ముల్‍ రూపహుయుతె వాక్యంమస్‍ హాంకెతొ ఆ వఖాత్‍న అవ్సే; తెదె సారాన ఛియ్యో కాలగ్‍సే. ");
INSERT INTO vgr_vpl VALUES ("RM9_10","075_9_10","ROM","9","10","10","యోస్‍కాహె; రిబ్కా అప్ను భాహుయుతె ఇస్సాక్‍నా కరి ఏక్‍నాటేకె బేజినిహుయుతెదె, ");
INSERT INTO vgr_vpl VALUES ("RM9_11","075_9_11","ROM","9","11","11","ఏర్పాట్‍న అనుసరించుతె దేవ్ను సంకల్పం, కరతే అష్యల్ అజు ఖరాబ్‍ను కామ్ను మూలంతి కాహే బొలవాలొనా మూలొతిమ్‍ నిలకడతి ఛాతె నిమిత్తం, ");
INSERT INTO vgr_vpl VALUES ("RM9_12","075_9_12","ROM","9","12","12","లడ్క అజుబి పెద్దాయిన్‍ అష్యల్‍బి ఖారబ్‍బి కారకొయిన్‍తిమ్‍ అగాడి మొట్టొన నానాన దాసుడుహుస్‍ కరి ఇనేతి బొల్యా. ");
INSERT INTO vgr_vpl VALUES ("RM9_13","075_9_13","ROM","9","13","13","అనగూర్చి మే యాకోబ్‍న ఫ్యార్‍కార్‍యో, ఏసావున ద్యేషించిన్‍ కరి లిఖురాక్యుస్‍ ఛా. ");
INSERT INTO vgr_vpl VALUES ("RM9_14","075_9_14","ROM","9","14","14","అనటేకే సాత్‍బొల్‍సుకి? దేవ్ కాన అన్యాయం ఛానా? హుసే కొయినీ. ");
INSERT INTO vgr_vpl VALUES ("RM9_15","075_9_15","ROM","9","15","15","అనటేకే దేవ్ మోషేతి అమ్‍బొల్‍యో “మే కినాకి గోర్‍ ఇనాబి గోర్‍కరీన్‍; కినాబారెమబి గోర్‍తి ద్యెకిస్‍కి ఇనాబారెమ గోర్‍తి ద్యెకిస్‍.” ");
INSERT INTO vgr_vpl VALUES ("RM9_16","075_9_16","ROM","9","16","16","కాహే పొందుగొర్‍సెతె వాలొటేకెహుయుతె, ప్రయాసపాడ్‍తె ఇనటేకెహుయుతె కాహే పన్కి, గోర్‍ వోతలను దేవ్ను వల్లె హుస్‍. ");
INSERT INTO vgr_vpl VALUES ("RM9_17","075_9_17","ROM","9","17","17","అజు లేఖనం ఫరోతి అమ్‍ బొల్‍యో మే తారకనా మారు తాఖాత్‍ ద్యెఖాడనటేకె, మారు నామ్‍ ధర్తిఖారనా ప్రచురంహువాతిమ్‍, అనునిమిత్తంమస్‍ తూన నియమించొ. ");
INSERT INTO vgr_vpl VALUES ("RM9_18","075_9_18","ROM","9","18","18","పన్కి యో కినాకి గోర్‍ కార్‍సెకి ఇనా గోర్‍ కరిస్‍; కినా కఠనాపార్‍చునికి ఇనా కఠనా పార్‍చును. ");
INSERT INTO vgr_vpl VALUES ("RM9_19","075_9_19","ROM","9","19","19","అమ్‍హుయుతొ ఇను చిత్తంనా గుర్కవాలొ యోకోన్‍? యో హాంకెబి నేరము మోపకు కిమ్‍ కరి తూ మరెతి బొలిస్‍. ");
INSERT INTO vgr_vpl VALUES ("RM9_20","075_9_20","ROM","9","20","20","ఓ పన్కి ఓ అద్మిమి, దేవ్ను ఎదురు బొలను తుకొన్‍? మేసాన అమ్‍కారియో రూపింపబడ్యుతె రూపించిచుతె ఇనాతి బొలునా? ");
INSERT INTO vgr_vpl VALUES ("RM9_21","075_9_21","ROM","9","21","21","ఏక్‍ ముద్దమతు ఏక్‍ ఘటం ఘనతకునా ఏక్‍ ఘనహీనతంనా కారనటేకె మట్టిపార్‍ కుమ్మరిఇనా అధికార్‍ కొయినా? ");
INSERT INTO vgr_vpl VALUES ("RM9_22","075_9_22","ROM","9","22","22","ఇమ్మాస్‍ దేవ్‍ ఇను ఖీజ్‍నా ద్యెఖావాతిమ్‍, ఇను ప్రభావంనా ద్యెకాడానటేకె, ఇచ్చయించినహుయుతె, నాసనమునం సిద్దపడిన్‍ ఖీజ్‍ను పాత్రహుయో ఘటంనా యో ఘాను ధీర్ఘషామ్తంతి సహించిన్‍ సాత్‍? ");
INSERT INTO vgr_vpl VALUES ("RM9_23","075_9_23","ROM","9","23","23","అజు మహిమ పొందనటేకె సిద్ధపరిచిన్‍ గోర్‍పాత్రనా ఘటమునుబారెమ, కాతొ యూదుల్‍మకంతు మాత్రమస్‍ కాహే, ");
INSERT INTO vgr_vpl VALUES ("RM9_24","075_9_24","ROM","9","24","24","అన్యజనాభోనా కంతు యో బులయిన్‍ అప్నుబారెమ, ఇను మహిమైస్వర్యంనా దెఖావునుకరి ఛా సాత్‍? ");
INSERT INTO vgr_vpl VALUES ("RM9_25","075_9_25","ROM","9","25","25","అనా గురించి హోషేయా గ్రంథంమా యో అమ్‍హుషె బోలుకురస్‍, యో ప్రకారం మారు జనాభో కాహెతె ఇవ్నే మారు జనాభోకరి, ఫ్యార్‍వాలి కాహెతె ఇనా ఫ్యార్‍వాలికరి, నామ్‍ మ్హేందిస్‍. ");
INSERT INTO vgr_vpl VALUES ("RM9_26","075_9_26","ROM","9","26","26","అజు హుస్‍తే సాత్‍కాతొ, తుమే మారు జనాబొ కాహేకరి ఇవ్నేతి కెజ్గా బొలయిహుయు, యో జొగొస్‍ జీవమ్‍హుయుతె దేవ్ను ఛియ్యాకరి ఇవ్నే నామ్‍మేదిస్‍ కరి హోషేయమా యో బొలుకురస్‍. ");
INSERT INTO vgr_vpl VALUES ("RM9_27","075_9_27","ROM","9","27","27","అజు ప్రభువు ఇను వాత్‍ ఖాతమ్‍కరిన్‍, క్లుప్తపరిన్‍ జామిన్‍పార్‍ ఇనా కారనటేకె పన్కి ఇష్రాయేల్‍నా ఛియ్యాను సంఖ్య ధర్యావ్‍ను రెతినుతార ఛా మన సేషమస్‍ బఛ్చాయిగాకరి ");
INSERT INTO vgr_vpl VALUES ("RM9_28","075_9_28","ROM","9","28","28","యెషయాబి ఇష్రాయేల్‍నా గూర్చి ఘాణు ఆవాజ్‍తి బులకురాస్‍. ");
INSERT INTO vgr_vpl VALUES ("RM9_29","075_9_29","ROM","9","29","29","అజు యెషయా పైహ్లూ బోల్యొతె ప్రకారం “సైన్యంనా అధిపతిహుయుతె ప్రభువు, అప్నాటేకె వంషంనా మిగ్లాయిన్‍ నా రాక్యొహోతొ సొదొమనుతరస్‍ హుయహోత్‍, గొమొఱ్ఱానుతరా పోలిన్‍ ర్హయహోత్‍.” ");
INSERT INTO vgr_vpl VALUES ("RM9_30","075_9_30","ROM","9","30","30","అమ్‍హుయుతొ అప్నె సాత్‍బోల్సు? నీతితీ చాల కొయింతే అన్యజనూల్‍ నీతినా, కతొ విష్వాస్‍ను మూలంహుయుతె నీతినా పొంద్యా; ");
INSERT INTO vgr_vpl VALUES ("RM9_31","075_9_31","ROM","9","31","31","హుయితొ ఇష్రాయేల్‍ నీతి కారణంహుయిన్‍ నియమంనా రేప్‍టిన్‍ మన యో నియమంనా అందుకరకొయిని, ");
INSERT INTO vgr_vpl VALUES ("RM9_32","075_9_32","ROM","9","32","32","ఇవ్నేసానా అందుకరకొయిని? ఇవ్నే విష్వాస్‍మూలంతి కాహే క్రియనుమూలొతి ఇనా దుమ్డ్యా. ఇవ్నా గోడ్డాన అడుభండొ లగ్గీన్‍ పల్టీన్‍ పడ్యా. ");
INSERT INTO vgr_vpl VALUES ("RM9_33","075_9_33","ROM","9","33","33","ఆదేక్‍ మే అడుఫాత్రొ అడుబండో సీయోనుమా స్థాపించుకరూస్‍; ఇనాకనా విష్వాస్‍రాకిన్‍ యో షెరం ఖాస్‍కొయిని కరి లిఖూతె ప్రకారం ఇవ్నే అడొఫాత్రొ లగిన్‍, గోడొ పిహ్లిన్‍ పడ్యా. ");
INSERT INTO vgr_vpl VALUES ("RM10_1","075_10_1","ROM","10","1","1","భైయ్యె భ్యేనె, ఇస్రాయేలుల్‍నా బఛ్చడన పొందునుకరి మారు దిల్‍మా ఆహ్ః ఇవ్నేను విషయమం మే దేవ్నా కార్యు ప్రార్థనకారుకురుస్‍. ");
INSERT INTO vgr_vpl VALUES ("RM10_2","075_10_2","ROM","10","2","2","దేవ్ను విషయమ్‍ ఇవ్నే ఘను ఆఖ్‍ఃతి ఛాతె ఇవ్నే గురించి సాక్చం దెమ్కొరాస్‍; హుయుతొబి ఇవ్నే ఆఖ్‍ః జ్ఞానుసారంతిహుయుతె కాహె. ");
INSERT INTO vgr_vpl VALUES ("RM10_3","075_10_3","ROM","10","3","3","కింకతొ ఇవ్నే దేవ్‍కనా నీతిమలంకొయిన్‍తిమ్‍ ఇవ్ను స్వనీతి స్థాపించనా ద్యేతా దేవ్ను నీతినా లోబడ్యుకొయిని. ");
INSERT INTO vgr_vpl VALUES ("RM10_4","075_10_4","ROM","10","4","4","కిమ్‍కాతో విష్వాస్‍కరాతె హార్యేక్‍జణ నీతి కలుగుతిమ్‍ యేసుక్రీస్తు మాస్‍ ధర్మషాస్ర్తంనా పూర్తిహుయిన్‍ ఛా. ");
INSERT INTO vgr_vpl VALUES ("RM10_5","075_10_5","ROM","10","5","5","ధర్మషాస్ర్తం మూలంతి నీతిన నెరవేరేచొవాలొ ఇనా బారేమస్‍ జీవ్‍నుకరి మోషే లిఖుకురాస్‍. ");
INSERT INTO vgr_vpl VALUES ("RM10_6","075_10_6","ROM","10","6","6","హుయుతొ విష్వాస్‍మాలంహుయుతె నీతి అమ్‍ బొలుకురాతే కొన్‍ స్వర్గమ్‍మా చాడిన్‍ జాసే. ");
INSERT INTO vgr_vpl VALUES ("RM10_7","075_10_7","ROM","10","7","7","కొయిన్‍తొ కొన్బి నరకమ్‍మా ఉతిరిజాసేనా? కతొ క్రీస్తునా మరిగొతె కంతు ఉప్పర్‍ లేవాను కరి తూ తారు దిల్‍మ నొకొరాయిజ్ వో. ");
INSERT INTO vgr_vpl VALUES ("RM10_8","075_10_8","ROM","10","8","8","యోసాత్‍కరి బొలుకురాస్‍ దేవ్ను వాత్‍ తారకనా, తారు బాకుమాతు తారు దిల్‍మా ఛా; యో హామే ప్రచార్‍ను విష్వాస్‍నా సంబంధహుయుతె వాత్‍బి యోస్. ");
INSERT INTO vgr_vpl VALUES ("RM10_9","075_10_9","ROM","10","9","9","యోసాత్‍కతొ యేసు ప్రభువుకరి తారు బాకుతి ఒప్పిలీన్‍, దేవ్ను మరిగొతె కంతు ఇనాబి ఉట్యోకరి తారు దిల్‍మా విష్వాస్‍ను బారేమ, తూ బఛ్చాయిజాసు. ");
INSERT INTO vgr_vpl VALUES ("RM10_10","075_10_10","ROM","10","10","10","కింకతొ నీతి కలుగుతిమ్‍ అద్మిమి దిల్‍మా విష్వాస్‍కరిన్‍, బఛ్చడనహుసేతిమ్‍ బాకుతి ఒపిలిసే. ");
INSERT INTO vgr_vpl VALUES ("RM10_11","075_10_11","ROM","10","11","11","సాత్‍కాతొ, ఇనాకనా విష్వాస్‍ర్హాఖీన్‍ యోకొన్‍కరి సారమ్‍ఖాయిస్‍కొయిని లేఖనం బొలుకురాస్‍. ");
INSERT INTO vgr_vpl VALUES ("RM10_12","075_10_12","ROM","10","12","12","యూదుల్‍కరి గ్రీసు దేఖ్కరి ఫారాక్‍ కొయిని; ఏక్‍ దేవాస్‍ ఖారనా ప్రభువుహుయిన్‍ ర్హాహిన్‍, ఇన ప్రార్థనకారుతె ఖారనాబారేమ కృప ద్యెఖాడానటేకె ఘాను ఆషీర్వాద్‍ ఛా. ");
INSERT INTO vgr_vpl VALUES ("RM10_13","075_10_13","ROM","10","13","13","సానాకాతొ ప్రభువు నామ్ను బట్టి ప్రార్థనకరస్‍తె యోకొన్‍బి బఛ్చాయిజాసు కరి లిఖ్యాయ్‍రుస్‍. ");
INSERT INTO vgr_vpl VALUES ("RM10_14","075_10_14","ROM","10","14","14","ఇవ్నే విష్వాస్‍ కరకోయితె వాలన కిమ్‍ ప్రార్థన కర్సు? నాహఃమ్జవాలన కిమ్‍ విష్వాస్‍కర్‍యో? నా ఖాంజ్యుతో ఇను నామ్‍ సాన లేను, ప్రచార్‍వాలొ కొయిన్‍తిం ఇవ్నేకిమ్‍ ఖాంచే? ");
INSERT INTO vgr_vpl VALUES ("RM10_15","075_10_15","ROM","10","15","15","సువార్తన బోలవాలొనా బొలిమొక్లితో ఇన బారేమ కిమ్‍ ప్రచార్‍కరతే? అను విషయంమ ఉత్తమంహుయుతె ఇనా గూర్చినా అష్యల్‍ను ప్రచార్‍కరతే ఇవ్నేపాదం కెత్రూకి సుందర్‍హుయుతె కరి లిఖ్కిరాక్యుస్‍. ");
INSERT INTO vgr_vpl VALUES ("RM10_16","075_10_16","ROM","10","16","16","హుయుతొబి హాఃరుజణు సువార్తన లోబడుకొయిని ప్రభువు, హామే మాలంకారయిన్‍ సమాచరంవాలొ విష్వాస్‍కర్యొకొయిని కరి యెషయా బోలుకురాస్‍ కాహే? ");
INSERT INTO vgr_vpl VALUES ("RM10_17","075_10_17","ROM","10","17","17","కతొ హఃమ్జన బారెమా విష్వాస్‍ హుసె; హఃమ్జను క్రీస్తును బారెమ హుయూతె వాత్‍తి హుయు. ");
INSERT INTO vgr_vpl VALUES ("RM10_18","075_10_18","ROM","10","18","18","హుయుతొ మే సాత్‍ బోలుకరూస్‍ కతొ, ఇవ్నే హఃమ్జకొయిన్నా? హఃమ్జా హుయా? ఇవ్నే ఆవాజ్‍ జామిన్‍పర్‍ ఖారనాబి, ఇవ్నే వాత్‍ ములక్‍ను ఆఖరితోడి నిక్‍ల్యా. ");
INSERT INTO vgr_vpl VALUES ("RM10_19","075_10_19","ROM","10","19","19","అజు మే సాత్‍ బోలిస్‍కతొ ఇష్రాయేల్‍నా మాలంకొయిన్‍నా? జనాభో కరి ఇవ్నేటేకె తుమ్నా రోషం పుట్టించో, అక్కల్‍కొయింతెవాలనా జనాభొ హాఃరనావల్లా తుమ్నా ఛండాల్‍ కర్యాస్‍. కరి అగాఢి మోషే బోలుకరాస్‍. ");
INSERT INTO vgr_vpl VALUES ("RM10_20","075_10_20","ROM","10","20","20","అజు యెషయా తెగించొతె దూండవాలన మే మలీస్‍; మన పుఛ్చావకొయింతె ఇవ్నే ప్రత్యక్చహుయుతొ కరి బోలుకరూస్‍. ");
INSERT INTO vgr_vpl VALUES ("RM10_21","075_10_21","ROM","10","21","21","ఇష్రాయేల్‍ను విషయం హుయుతొ అవిధేహుయిన్‍ పీటెఫరతే అద్మినా మే ధన్‍అక్కూ మార హాత్‍తి బోలుకరూస్‍. ");
INSERT INTO vgr_vpl VALUES ("RM11_1","075_11_1","ROM","11","1","1","ఇమ్‍ హుయితో మే పుచ్చాయోతె సాత్కాతొ, దేవ్‍ ఇనా ప్రజల్న మేన్దిదొ? ఇంనాబొల్ను. మేబి ఇస్రాయేల్‍ కరి, అబ్రాహామ్ను సంతానమా బెన్యామీన్‍ గోత్రంమా పెద్దాహుయోతెస్‍. ");
INSERT INTO vgr_vpl VALUES ("RM11_2","075_11_2","ROM","11","2","2","ఇనా అగాఢిస్ మాలం ఇనా ప్రజలన్నా దేవ్‍ మేన్దిదొకొయిని. ఏలియాన గూర్చిను భాగంమా లేఖనంమ బొలయు తుమ్నా మలంనా? ");
INSERT INTO vgr_vpl VALUES ("RM11_3","075_11_3","ROM","11","3","3","ప్రభువా, ఇవ్నే తారు ప్రవక్తల్నా మరాఖీదిదా, తారు బలిపీఠమ్నా పట్టకాయిన్‍నాఖీదిదు, మే ఎక్సేజాను మిగిలిరొస్, మరు జాన్‍ కాడుకరస్‍కరి ఇష్రాయేల్నా వైరితి దేవ్నా ఖామే యో వాదించుకురస్‍. ");
INSERT INTO vgr_vpl VALUES ("RM11_4","075_11_4","ROM","11","4","4","హుయుతొ దేవ్‍ దిదోతే జవాబ్‍ ఖమ్జో, బయలునా గుడ్డెకెనాకి‍తే ఖాత్‍హజార్‍ వాగ్రీనా మే సేషంతి రాకిరక్యొస్‍. ");
INSERT INTO vgr_vpl VALUES ("RM11_5","075_11_5","ROM","11","5","5","ఇమాస్‍ తెదెను కాలంమ సయితము కృపను ఏర్పాటును చొప్పుతి సేషంతి మిగిలిన్‍ ఛా. ");
INSERT INTO vgr_vpl VALUES ("RM11_6","075_11_6","ROM","11","6","6","యో కృపతిహుయుతె బరేమ అజుబి క్రియలతి మూలొహుయుతె కాహే ఇమ్‍ హుయితో కృప అజుబి కృప హుస్‍కొయిన్‍నా. ");
INSERT INTO vgr_vpl VALUES ("RM11_7","075_11_7","ROM","11","7","7","ఇమ్‍హుయూతొ సాత్‍హుసే? ఇష్రాయేల్‍ దూండుడోకరతె సాత్‍కి యో ఇవ్నే మల్యుకొయిని, దేవ్ను క్రుపానువల్లా ఏర్పాటు హుయుతెవాలనా యో మలియు మిగిలుతె ఇవ్నే కఠినచిత్తుహుయా. ");
INSERT INTO vgr_vpl VALUES ("RM11_8","075_11_8","ROM","11","8","8","అనావిషయంమ హంకెతొడి దేవ్ను ఇవ్నే నిందార్ను మత్తుహుయూతె దిల్నా, దెక్హావాకొయిన్‍తె డొలనా, హఃమ్జకొయిన్‍తె కాన్‍నా దీరాక్యొస్‍కరి లిఖ్కిరాక్యొస్‍. ");
INSERT INTO vgr_vpl VALUES ("RM11_9","075_11_9","ROM","11","9","9","దావీద్‍ బొల్యెతే సాత్‍కాతొ, అజు ఇవ్ను దాన్‍ ఇవ్నా ఉరినితార, బోన్‍తార, ఆటంకమ్‍తార ఇవ్నే క్రియల్‍నా ప్రతిఫలంహువను ర్హాసె పన్కి. ");
INSERT INTO vgr_vpl VALUES ("RM11_10","075_11_10","ROM","11","10","10","ఇవ్నే దేఖకొయినితిమ్‍ ఇవ్నే ఢోళ అంధారుహుయు పాన్కి. ఇవ్నే పీట్పర్‍ కెదేబి జుఖీన్‍ ర్హానుతిమ్‍ కరోకరి దావీద్‍తి బోలుకురస్‍. ");
INSERT INTO vgr_vpl VALUES ("RM11_11","075_11_11","ROM","11","11","11","అనటేకె మే బోలుకరతే సాత్‍కాతొ, యూదుల్‍ పడిజవాతిమ్‍ తొట్రిల్లిచ్‍నా? ఇమ్‍నాబొల్‍ను, ఇవ్నేను రోషం పుట్టించనాటేకె ఇవ్నేతి తోట్రు పాటుటేకె అన్యజనాభోతి బఛ్చడన కిలిగిన్‍. ");
INSERT INTO vgr_vpl VALUES ("RM11_12","075_11_12","ROM","11","12","12","ఇవ్నేతి తొట్రుపాటు ములక్‍నా ఐస్వర్యంనా, ఇవ్నే నష్టం అన్యజనాభోనా ఐస్వర్యంనా హుయుతొబరేమ ఇవ్నే పరిపూర్ణంతి కెత్రుకి‍ జాక్హత్‍ ఐస్వర్యంహుసే, తేదే యుదుల్బి బుజు జాఖాత్‍ పరిపుర్నత హువుంకారస్‍. ");
INSERT INTO vgr_vpl VALUES ("RM11_13","075_11_13","ROM","11","13","13","ఇవ్నేమ తొడుజానునా బఛ్చావ్‍నుకరి మారు సేవనా ఘనపరుచుకురుస్‍. ");
INSERT INTO vgr_vpl VALUES ("RM11_14","075_11_14","ROM","11","14","14","అన్యజనాభో తుమరెతి మే వాత్‍బొలుకురుస్‍. మే అన్యజనాభోనా అపొస్తలుహుయున్‍ఛా పాన్కి కిమ్‍హుయుతొబి మారు ఆంగ్‍తాను సంబందినా ఖీజ్‍ పుట్టించిన్‍. ");
INSERT INTO vgr_vpl VALUES ("RM11_15","075_11_15","ROM","11","15","15","ఇవ్నే తిరస్కారం పొందాను, ములక్‍నా దేవ్తి సమాధానంహువానటేకె హుయుతొబరేమ, ఇవ్నే చేర్చిలెవాను సాత్‍హుస్‍? మరిగొతె ఇవ్నే సాజీవంమాస్‍ హుయిన్‍ ఉట్టాసే కాహేన? ");
INSERT INTO vgr_vpl VALUES ("RM11_16","075_11_16","ROM","11","16","16","ఆట్టాను ముద్దమా అగాడి ఏక్జానో పరిసుద్ధ హుయుతె ఆట్టోను ముద్దక్హారుబి పరిసుద్ధమాస్‍ జాఢ్ పరిసుద్ధహుయుతొబి ఢాలిబి పరిసుద్ధాస్‍. ");
INSERT INTO vgr_vpl VALUES ("RM11_17","075_11_17","ROM","11","17","17","హుయుతొ ఢాలిమా తొడు తుటిగొ, జ్హాడిమా ఒలీవ డాలీహుయురుతె తూ ఇనా ఇచ్చమా అంటుకట్టబడిన్‍, ఒలీవజ్హాడుతార సారవంతంహుయుతె జాఢ్‍నా ఇనేతి మలిన్‍ పాలుపొందినబరేమ, యో ఢాలిఫర్‍ ");
INSERT INTO vgr_vpl VALUES ("RM11_18","075_11_18","ROM","11","18","18","తుహుయో ఢాలి ఫార్‍ బడ్డాయినొకొమార్‍, జాడ్‍ తునా భరించుకురస్‍ ‍పాన్కి తూ జాఢ్‍నా భరించాకొయిని. ");
INSERT INTO vgr_vpl VALUES ("RM11_19","075_11_19","ROM","11","19","19","ఇనాటేకె మే అంటుకట్టబడిన్‍ నిమిత్తం ఢాలినా తొడిన్‍ నాక్హిదిదుకరి తూ బొలిస్‍. ");
INSERT INTO vgr_vpl VALUES ("RM11_20","075_11_20","ROM","11","20","20","ఖాచీస్‍ ఇవ్నే అవిస్వాసంనాబట్టి తొడాయహుయా, తుహుయుతొ విష్వాస్‍నాబట్టి ఉభీరీరోస్‍ తారు తుస్‍ గ్వోరాపాడ్‍నొకొ తీమ్‍, ఢర్‍ కాలిగిన్‍ ర్హా. ");
INSERT INTO vgr_vpl VALUES ("RM11_21","075_11_21","ROM","11","21","21","సానకాతో దేవ్నూ స్వాభావికంహుయుతె ఢాలినా మేదిన్‍ బారేమ తునాబి కోమేన్దాసే. ");
INSERT INTO vgr_vpl VALUES ("RM11_22","075_11_22","ROM","11","22","22","అనటేకె దేవ్ను అనుగ్రహంనా కాఠిన్యంతి కాతొ పడిజైయిన్‍ ఇవ్నఫర్‍ కాఠిన్యంనా, తూ అనుగ్రహ ప్రాప్తుహుయోతె హుబిరొతె బరేమ తారపార్‍ ఛాతె దేవ్ను అనుగ్రహంనా ద్యెక్‍ అమ్‍ హుబర్‍సేకరి బారేమ తూబి క్హాత్రయిజాయిస్‍. ");
INSERT INTO vgr_vpl VALUES ("RM11_23","075_11_23","ROM","11","23","23","బుజు యూదుల్‍బి ఇవ్ను అవిష్వాసంమా హుబిరినార్హహితొ బారేమ అంటుకట్టబడ్‍సు; దేవ్ను ఇవ్నే బారేమ అంటుకట్టటనా తాక్హాత్‍వాలొ. ");
INSERT INTO vgr_vpl VALUES ("RM11_24","075_11_24","ROM","11","24","24","కింకతొ తూ స్వాభావికహుయుతె జాడిన ఒలివ జ్హాడ్‍ కంతు వాడయుగుతె స్వభావవిరుద్ధంతి అషల్ ఒలీవ జ్హాడాన అంటుకట్టబడ్యుతె బారేమ స్వాభావికహుయుతె ఢాలినా ఇవ్నే అజు నిష్చయంతి ఇవ్నేతి ఇను ఒలీవజ్హాడాన అంటుకట్టబడ్‍యా కొన్నా ");
INSERT INTO vgr_vpl VALUES ("RM11_25","075_11_25","ROM","11","25","25","భేనే భైయ్యె, తుమరుద్రుష్టన తుమే దిమాక్‍వాల కరి అనుకొలెంకొరుస్‍ ఆ మర్మంనా తుమే మలంకార్‍నుకరిఛావు. యోసాత్‍కతొ, అన్యజనాభోనా పేసిన్‍ సంపూర్ణహువాతొడి ఇష్రాయేల్‍నా కఠిన్‍ దిల్తివాలు తొడుతొడి కలిగ్యు. ");
INSERT INTO vgr_vpl VALUES ("RM11_26","075_11_26","ROM","11","26","26","ఇవ్నే పేసిన్‍ విమోచకుడునా సీయోనుమాంతు అయిన్‍ యాకోబ్‍కంతు భక్తిహీనతాన చుఖాయో ");
INSERT INTO vgr_vpl VALUES ("RM11_27","075_11_27","ROM","11","27","27","మే ఇవ్ను పాప్‍నా పరిహరించీన్‍, మారటేకె ఇవ్న హుసెతె నిబంధన అస్నా కరి లిఖ్యుతిమ్‍, ఇస్రాయేల్‍ జనాభొహాఃరు బఛ్చాయి జాసె. ");
INSERT INTO vgr_vpl VALUES ("RM11_28","075_11_28","ROM","11","28","28","సువార్త విషయహుయుతె తుమ్నాబట్టి వైరిహుయిన్‍ ర్హావజాయ్‍ పన్కి, దేవ్ను ఏర్పాటును విషయహుయుతె భానుభా బట్టి ఇవ్నె దేవ్నా లాఢ్‍వాలు హుయిన్‍ ఛా. ");
INSERT INTO vgr_vpl VALUES ("RM11_29","075_11_29","ROM","11","29","29","కింకతొ, దేవ్ను ఇను కృపావరంలొ విషయంమా, దేవ్ను బులావను విషయంమా పష్చాత్తాపం పడ్సేకొయిని. ");
INSERT INTO vgr_vpl VALUES ("RM11_30","075_11_30","ROM","11","30","30","సామకతో జమానమా తుమే దేవ్నా అవిధేహుయున్‍ ర్హవొ, హంకెతొ అన్యజనాబో హుయుతే తుమే దేవ్ను దయాన పోందిన్‍ ఛా, యూదుల్ హుయుతే తూమే అవిధేయతబట్టి గోర్‍ పొంద్యొ. ");
INSERT INTO vgr_vpl VALUES ("RM11_31","075_11_31","ROM","11","31","31","ఇమ్నితరా తుమారురు బారేమ ద్యెహాఃడ్యుతె గోర్‍ బట్టి ఇవ్నేబి హంకె గోర్‍ పొందిన్‍ నిమిత్తం, తెదె ఇవ్నే అవిధేహుయున్‍‌‌ ఛా. ");
INSERT INTO vgr_vpl VALUES ("RM11_32","075_11_32","ROM","11","32","32","హాఃర ఫర్‍ ఇను గోర్‍ దేక్నుకరి, దేవ్ను హాఃరన అవిధేయతాసీతిమా మూచిదిన్‍ బంధించిన్‍ఛా. ");
INSERT INTO vgr_vpl VALUES ("RM11_33","075_11_33","ROM","11","33","33","బాబ్రే, దేవ్ను దిమక్‍నుజ్ఞానంతి బాహుష్యంన కెత్రుకి గంభీరంతి; యో న్యావ్‍నా పహాఃవనుతిమ్‍ అషక్యంనా యో వాట్‍మకెత్రుకి అగమ్యం. ");
INSERT INTO vgr_vpl VALUES ("RM11_34","075_11_34","ROM","11","34","34","ప్రభువును దిల్నా మాలంహుయతె యోకోన్‍? ఇనా హఃయల్నా బోల్యుతె యోకోన్‍? ");
INSERT INTO vgr_vpl VALUES ("RM11_35","075_11_35","ROM","11","35","35","కొన్బీ యేసునా సాత్బి దిరాఖ్యుకి, పాఛు యో దేనారో కొయిన్నా? ప్రతిఫలం పొందను యోకొన్‍? ");
INSERT INTO vgr_vpl VALUES ("RM11_36","075_11_36","ROM","11","36","36","యో మూలంతి ఇనేతిస్‍ యో నిమిత్తంను సమస్తం కలుగురాస్‍. పిఢపిఢినా తోడి ఇనాస్‍ కెదేబి మహిమ కలుగుస్‍ పన్కి. ఆమేన్‍. ");
INSERT INTO vgr_vpl VALUES ("RM12_1","075_12_1","ROM","12","1","1","అనటేకె భైయ్యె, పరిసుద్ధంనా దేవ్నా అనుకూలం హుయుతె జీవనుయాగంతి తుమే ఆంగ్‍తాను ఇనా సమర్పింపిచిలెవొ దేవ్ను త్యాగమ్‍ వాత్యల్యంనుబట్టి తుమ్నా పొఖాలవుకురుస్‍. అజాత్నూ సేవ తుమ్న యుక్తహుయురొస్‍, తో ఆ ఖాచీస్‍. కరి మే బొలుకరుస్‍, ");
INSERT INTO vgr_vpl VALUES ("RM12_2","075_12_2","ROM","12","2","2","తుమే ఆ ములక్‍ను అద్మియే అనుసారంచుకరతే తుమే నొకొఅనుసరించొ, అనుకూలంనా, సంపూర్ణంహుయుతె దేవ్ను చిత్తంసాత్కి పరీక్చించిన్‍ మాలంకరతిమ్‍ తుమారు దిల్‍ బద్లాయిన్‍ నవూహువానటేకె రూప్నా పొందితొ అష్యల్. ");
INSERT INTO vgr_vpl VALUES ("RM12_3","075_12_3","ROM","12","3","3","ఇనా యోస్‍ ఎంచుకొనతగిన ఇనకనా ఘాను ఎంచకొయిన్‍తిమ్‍, దేవ్‍ ఏక్నా ఏక్‍ విభజిమ్చిన్‍ దిదొతె విష్వాస్‍ పరిమాణ ప్రకారం, యో స్వస్థ దిమాక్‍వాల హువనాటేకె తగిన రీతితిమ్‍ ఇనా ఎంచిలీస్‍ కొయినికరి, మన అనుగ్రహింపబడ్యుతె కృపనుబట్టి తుమరమాబి హర్యేక్‍తి బొలుకురుస్‍. ");
INSERT INTO vgr_vpl VALUES ("RM12_4","075_12_4","ROM","12","4","4","ఇమ్‍హుయితో ఏక్‍ ఆంగ్‍తాన్‍తి అప్నా కెత్రుకి అవయావాల్‍ ర్హాహితొబి, ఆ అవయవాల్‍ ఖారనా ‍ఎక్కస్‍ కామ్‍ కిమ్‍కి ర్హాసెకొయిని, ");
INSERT INTO vgr_vpl VALUES ("RM12_5","075_12_5","ROM","12","5","5","ఇమ్మాస్‍ అనుకులంహుయుతె అప్నే క్రీస్తుమా ఏక్‍ ఆంగ్‍తానుతార ర్హహిన్‍, ఏక్నా ఏక్‍ ప్రత్యేకంతి అవయవాల్‍ హుయిన్‍ ఛా. ");
INSERT INTO vgr_vpl VALUES ("RM12_6","075_12_6","ROM","12","6","6","అప్నా అనుగ్రహింపబడ్యుతె కృప చొప్పుతిమ్‍ అలాదుకొన్కి కృపావరంతి హుయువాల హుయిరాస్న పాన్కి, ప్రవచనవరం హుయుతె విష్వాస్‍ పరిమాణంమా చొప్పుతిమ్‍ ప్రవచించు; ");
INSERT INTO vgr_vpl VALUES ("RM12_7","075_12_7","ROM","12","7","7","సేవకారవాలహుయుతొ సేవ కార్‍, బోధించొవాలొ హుయుతొ బోధించాను కార్‍, ");
INSERT INTO vgr_vpl VALUES ("RM12_8","075_12_8","ROM","12","8","8","ప్రోత్సహించవాలొహుయుతొ ప్రోత్సహించమా కామ్‍హుయిన్‍ ర్హాసు. పంఛవాలొ స్రద్ధాదిల్తి పంచును, పార్ను విచారణకరవాలో జాగ్రుత్‍తి, గోర్‍వాలొ కామ్‍ కారవ్ను. ");
INSERT INTO vgr_vpl VALUES ("RM12_9","075_12_9","ROM","12","9","9","తుమారు ఫ్యార్‍ నిష్కపట హుయుతే ర్హాను. హాఃరబ్‍నా నసహ్యింసిచిన్‍ అష్యల్నా ధారిలేవో. ");
INSERT INTO vgr_vpl VALUES ("RM12_10","075_12_10","ROM","12","10","10","భైయే, భేనేను ఫ్యార్‍ను విషయంమా ఏక్నా ఏక్‍ అనురాగము హుయుతె ఇవ్నే, ఘనతను విషయంమా ఏక్నాఏక్‍ గొప్పతి ఎంచిలెవొ. ");
INSERT INTO vgr_vpl VALUES ("RM12_11","075_12_11","ROM","12","11","11","స్రద్ధాసక్తుల్‍ విషయంమా పిటే నొకొర్హావొ, ఆత్మమా తీవ్రతావాలహుయిన్‍ ప్రభువునా దిల్తీ సేవించొ. ");
INSERT INTO vgr_vpl VALUES ("RM12_12","075_12_12","ROM","12","12","12","నిరీక్చణ హుయుతె ఇవ్నే ఖుషితి, ఓర్పుహుయిన్‍ ఇవ్నే, ప్రార్థనామా హామేసా పట్టుదలతి కల్గీన్‍ ర్హవొ. ");
INSERT INTO vgr_vpl VALUES ("RM12_13","075_12_13","ROM","12","13","13","దేవ్ను అద్మియోనా అవసరం హుయుతె ఇవ్నా సహయాం కారో, ఖాదర్‍తి ఆతిథ్యం షీఖిలెకొరాస్‍. ");
INSERT INTO vgr_vpl VALUES ("RM12_14","075_12_14","ROM","12","14","14","తుమ్నా హింసించవాలనా ఆసీర్వాదించొ; ఆసిర్వాదించో పన్కి సపించానొకొ. ");
INSERT INTO vgr_vpl VALUES ("RM12_15","075_12_15","ROM","12","15","15","ఖుషితీ ఇవ్నేతి ఖుషితి ర్హవొ; రొవ్వావాలతీ రొవ్వొ; ");
INSERT INTO vgr_vpl VALUES ("RM12_16","075_12_16","ROM","12","16","16","ఏక్ను ఏక్‍ దిల్‍తీ మలీన్‍ ర్హవొ, తుమారు తుమేస్‍ దీనుల్తీ సహవాసం కరో; దిమాక్‍ వాలొకరి నొకొర్హహిజవొ. ");
INSERT INTO vgr_vpl VALUES ("RM12_17","075_12_17","ROM","12","17","17","క్హారబ్‍నా ప్రతి హాఃరాబ్‍ ఇవ్నే కర్‍నొకొ; అద్మిహాఃరనా నజర్మా యోగ్యహుయుతె ఇనాబారెమా హఃయల్‍ కల్గీన్‍ ర్హవొ. ");
INSERT INTO vgr_vpl VALUES ("RM12_18","075_12_18","ROM","12","18","18","వీల్‍హుయూతొ హుయుతె తుమరు హాత్నుహుయుతే మట్టుకుతీ సమస్తం అద్మియేతి షాంతీతీ ర్హవొ. ");
INSERT INTO vgr_vpl VALUES ("RM12_19","075_12_19","ROM","12","19","19","లాఢ్‍హుయతే భైయ్యే, తుమ్నా తుమేస్‍ పగతిర్చి కొయిన్‍తిమ్‍, దేవ్నా ఖీజ్నా జోగోదేవో పగతీర్చునాను మారు కామ్‍, మే ప్రతిఫలంతి దిస్కరి ప్రభువు బొలుకురాస్‍కరి లిఖ్హురాక్యుస్‍ ఛా. ");
INSERT INTO vgr_vpl VALUES ("RM12_20","075_12_20","ROM","12","20","20","అనటేకే, తారు వైరి భుక్కె లాగ్యు ర్హయితో ఇనా ధాన్‍ నాఖో, ఎక్కాతరా తర్హాక్తి ర్హైతో పానిదెవ్వొ; ఇమ్మాస్ కర్యాతొ ఇనా దిల్మా షారమ్‍ ఖైయిన్‍ ఆగ్‍నితరా హుసే. ");
INSERT INTO vgr_vpl VALUES ("RM12_21","075_12_21","ROM","12","21","21","కారబ్నాహాతె తుమ్నాఉపర్‍ జీతొకొయినీతింమ్‍, ఖరాబ్తి హారినొకొజావొ పన్కి, అష్యల్లి కారబ్నా జిత్‍సు. ");
INSERT INTO vgr_vpl VALUES ("RM13_1","075_13_1","ROM","13","1","1","హర్యేక్‍జణు ఉప్పర్ను అధికార్‍నా లోబడి ర్హావానటేకె; కింకతొ దేవ్నటేకె హుయుతె తప్ప అజు కెవు అధికారంబి కొయిని; ఛాతె అధికారంనా దేవ్తీస్‍ నియమింబడిన్‍ ఛా. ");
INSERT INTO vgr_vpl VALUES ("RM13_2","075_13_2","ROM","13","2","2","అనటేకే కొన్బి అధికార్‍నా ఎదిరించొవాల దేవ్ను నియమంనా ఎదిరించుకురాస్‍; ఎదిరించవాల ఇవ్నేఫర్‍ ఇవ్నేస్‍ న్యావ్‍ ల్యాలిసే. ");
INSERT INTO vgr_vpl VALUES ("RM13_3","075_13_3","ROM","13","3","3","హఃర్కార్‍ కరవాలనా ఖర్రాబ్‍ కార్యంనాస్‍ పన్కి అష్యల్ కార్యంనా భయమ్‍కర్‍వాలొ కాహే; తునా అషల్ హుసెతిమ్‍ అధికార్‍నా దేవ్ను పరిచారకులు; ఇవ్నే ఢర్ కొయిన్‍తిమ్‍ ర్హాను కోర్యెనా? కేహుఅష్యల్‍కి కారో, తెదె ఇవ్నేతి ఘనతపొందిస్‍. ");
INSERT INTO vgr_vpl VALUES ("RM13_4","075_13_4","ROM","13","4","4","తూ హాఃరబ్‍ కార్యయోతె బారేమ ఢరొ, ఇవ్నే చుక్కేస్‍ తాల్వార్‍నా పేర్లీదా; కీడు కారవాలొఫర్‍ ఖీజ్‍ వతాలనుటేకె ఇవ్నే ప్రతికారం కరవాల దేవ్ను ప్రచార్‍ కరవాలొ. ");
INSERT INTO vgr_vpl VALUES ("RM13_5","075_13_5","ROM","13","5","5","అనటేకే ఖీజ్నుఢర్‍ బట్టి యోస్‍ కాహే దిల్ను జామీన్‍ బట్టిబి అధికారుల్నా లొంగీన్‍ ర్హావను ఆవస్వకం. ");
INSERT INTO vgr_vpl VALUES ("RM13_6","075_13_6","ROM","13","6","6","కింకతొ ఆ కారణంతీస్‍ పాన్నుల్‍ భాందుకారస్‍, ఇవ్నే దేవ్ను సేవకుడ్‍హుయున్‍ ఛా కెదేబి సేవమా కామ్‍ హుయిన్‍ ర్హాస్‍. ");
INSERT INTO vgr_vpl VALUES ("RM13_7","075_13_7","ROM","13","7","7","అనటేకే తుమే కంతుబీ ప్హేడుకరస్‍? అనటేకే కిను పన్ను ఇనా పన్నుబి, కినాబి సుంకమో ఇనా సుంకంనా చెల్లించొ. కినాబారేమబి ఢర్‍ర్హాను కరి ఇనాబారేమ ఢర్‍బి, కినాబిబారేమ సన్మానమం హుయిన్‍ర్హావొ, ఖారనా ఇవ్ను ఇవ్ను రుణంనా తీర్చొ. ");
INSERT INTO vgr_vpl VALUES ("RM13_8","075_13_8","ROM","13","8","8","ఏక్నాయేక్‍ ఫ్యార్‍ను విషయంమా తప్పఅజు సాత్బి కినాబి రుణం ర్హావొనొకొ. అలాదువాలనా ఫ్యార్‍కరవాలొ ధర్మషాస్ర్తంనా నెరవేర్చెచవాలొ. ");
INSERT INTO vgr_vpl VALUES ("RM13_9","075_13_9","ROM","13","9","9","కింకతొ వ్యభిచరింనొకొకారొ, నరహత్య నొకొరారొ, చొర్‍నొకొకారొ, ఆక్హాక్‍నొకొకారొ, కారిహుయుతె, అజు కెహు ఆజ్ఞనహుయుతొబి ఛాతె బారేమ యోబి తారిన్‍తార తారు అలాదువాలొనబీ ఫ్యార్‍ను వాక్యంనా సంక్చేపంతి ఇమిడిన్‍ ఛా. ");
INSERT INTO vgr_vpl VALUES ("RM13_10","075_13_10","ROM","13","10","10","ఫ్యార్‍ అలాదువాలనా కీడు కర్సెకొయిని పన్కి ఫ్యార్‍హుయిన్‍ ర్హాను ధర్మషాస్ర్తంనా క్హారు నెరవేర్చనుటేకె. ");
INSERT INTO vgr_vpl VALUES ("RM13_11","075_13_11","ROM","13","11","11","అజు తుమే ధన్‍ మాలంకరీన్‍, లిందర్‍మతూ‍ ఉట్టిన్‍ వక్హత్‍హుయూకరి మాలంకరీన్‍, ఇమ్మాస్‍ కరొ. అప్నే విష్వాస్‍హుయతొ కంతు హంకె, బఛ్చడన అప్న అజు ఖందెస్‍ఛా. ");
INSERT INTO vgr_vpl VALUES ("RM13_12","075_13_12","ROM","13","12","12","రాత్‍ గ్హనుహుయిన్‍ వ్హాను క్హందెస్‍ఛా పన్కి అప్నే అంధారాను క్రియల్‍నా మ్హేందిన్‍, ఉజాలనుసంబంధహుయుతె కవచమ్‍ పేరిలిన్‍ లిసు. ");
INSERT INTO vgr_vpl VALUES ("RM13_13","075_13_13","ROM","13","13","13","అల్లరితి మలితె కెలానుకుదానుహుయుతె దారు పిన్‍ మత్తుమాబి కొయిన్‍తిమ్‍, కామవిలాసంహుయుతె పోకిరి చేష్టనాబి కొయిన్‍తిమ్‍, ఖీజ్‍, కలహంహుయుతొబి మత్సరంహుయుతొబి కొయిన్‍తిమ్‍, ఉజాలమా ఛాలతిమ్‍ మర్యాదతి ఛాల్చే. ");
INSERT INTO vgr_vpl VALUES ("RM13_14","075_13_14","ROM","13","14","14","ఇమ్మాస్‍ పిటేతి ప్రభువుహుయుతె యేసు క్రీస్తును అయుదామ్మా పేర్లేవో, ఇవ్నే ఆంగ్తాన్‍ను ఇచ్ఛల్నా నెరవేర్చాటేకె ఆంగ్‍తాను విషయంత ఆలోచిన్‍ కర్లెవో. ");
INSERT INTO vgr_vpl VALUES ("RM14_1","075_14_1","ROM","14","1","1","విష్వాస్‍ను విషయంహుయతె కంజొర్‍వాలన బులయిలెవొ, హుయుతొబి సందేహామ్‍ తీర్చునటేకె లడ్డాయిన మెదినొకొలెవొ ");
INSERT INTO vgr_vpl VALUES ("RM14_2","075_14_2","ROM","14","2","2","ఏక్‍ ధర్తి ఖావజైకరి నమ్ముకురస్‍, అజెక్ జణు ఖంజోర్ హుయిన్‍ ర్హాయో, చట్టినురాచునా క్హాంకొరాస్‍. ");
INSERT INTO vgr_vpl VALUES ("RM14_3","075_14_3","ROM","14","3","3","క్హావాలొ క్హావకొయిన్‍తె ఇనా నొకొకరినాబొల్‍ను, క్హావ్వాలొ క్హావుంకరాతెఇనా న్యావ్‍ కర్‍లేను; కింకతొ దేవ్‍ఇనా చేర్‍చిలేస్‍. ");
INSERT INTO vgr_vpl VALUES ("RM14_4","075_14_4","ROM","14","4","4","అజెయేక్ జణుసేవకుడ్నా వీషయాంమా న్యావ్‍ దెవ్వానా తూ కొన్‍? యో ఉబిరిర్హావాను హుయుతొబి పడిర్హావను హుయుతొబి ఇను యజమానినా కామ్‍మాస్‍; యో ఉబిర్‍సే, ప్రభువు ఇనా ఉబరానటేకె తాఖత్‍వాలొ హుసె. ");
INSERT INTO vgr_vpl VALUES ("RM14_5","075_14_5","ROM","14","5","5","ఏక్జనొ ఏక్‍ ధన్‍తీబి అజుఏక్‍ ధన్‍ అషల్ ధన్‍కరి ఎంచిలింకొరాస్‍; హర్యేక్‍జానొ ఇనాతొడి యోస్‍ ఇను దిల్‍నా ఖఛ్చితంకార్‍లెకొరాస్‍. ");
INSERT INTO vgr_vpl VALUES ("RM14_6","075_14_6","ROM","14","6","6","ధన్నా లక్చ్యపెట్టవాలొ ప్రభువు కోసం లక్చ్యమేదుకురాస్‍; క్హావాలొ దేవ్ను కృతజ్ఞతాస్తుతులు చెల్లించుకురాస్‍ పన్కి ప్రభువు కోసంమాస్‍ క్హాకొర్‍స్‍, నాక్హావాలొ ప్రభువు కొసం క్హానుబంద్‍కరిన్‍, దేవ్ను కృతజ్ఞతాస్తులు చెల్లించుకురాస్‍. ");
INSERT INTO vgr_vpl VALUES ("RM14_7","075_14_7","ROM","14","7","7","అప్నామ కొన్‍బి ఇనాటేకెస్‍ జీవ్‍సేకొయిని, కొన్‍బి ఇనాటేకె మరెసేకొయిని. ");
INSERT INTO vgr_vpl VALUES ("RM14_8","075_14_8","ROM","14","8","8","అప్నే జీవియాతొబి ప్రభువు కోసమాస్‍ జీకొరాస్‍; మరిగొతొబి ప్రభువు కోసమాస్‍ మరిజొకొరుస్‍. అనటేకే అప్నే జీవితొబి మరిగాతొబి ప్రభువువాలయిన్‍ ఛా. ");
INSERT INTO vgr_vpl VALUES ("RM14_9","075_14_9","ROM","14","9","9","యో మరిగొతెనా జీవిన్‍ఛాతె ప్రభువుహుయిన్‍ ర్హానా అను నిమిత్తం కాహేనా క్రీస్తు మరిన్‍ అజు జీయో. ");
INSERT INTO vgr_vpl VALUES ("RM14_10","075_14_10","ROM","14","10","10","హుయుతొ తూ తారు భైయోన బుజు భేనేనా న్యావ్‍ తీర్చకిమ్‍? తారు భైయోన నిరాకరింపనుకిమ్‍? అప్నేక్హారా దేవ్ను న్యాయ పీఠమ్నా క్హామే ఉబర్‍సు. ");
INSERT INTO vgr_vpl VALUES ("RM14_11","075_14_11","ROM","14","11","11","మారు జీవమ్‍తోడు, హర్యేఏక్‍ గుడ్డెయో మరా క్హామే వంగ్‍సే, హర్యేక్‍ జిబ్‍ దేవ్ను స్తుతించును కరి ప్రభువు బొలుకురాస్‍ కరి లిఖ్హురాక్యుస్‍. ");
INSERT INTO vgr_vpl VALUES ("RM14_12","075_14_12","ROM","14","12","12","పన్కి అప్నమా హర్యేక్‍జాను ఇను గురించి దేవ్ను లెక్క అప్పగిమ్చును. ");
INSERT INTO vgr_vpl VALUES ("RM14_13","075_14_13","ROM","14","13","13","ఇనటెకే అప్నెహంకెతు ఎక్నాఎక్ న్యావ్‍ తీర్చలిసు. అస్‍కాహే, భైయో, భేనేనా, అడుహుయుతె ఆటంకంహుయుతె‍ కార్‍రుకరి తూమే నిష్చయించొ. ");
INSERT INTO vgr_vpl VALUES ("RM14_14","075_14_14","ROM","14","14","14","సహజంతి కెవుబి నిషిద్ధం హుయుకొన్‍యితె మే ప్రభువుహుయుతె యేసుమా మాలం ఖఛ్చితంగా నమ్ముకురుస్‍. హుయుతె కెవుబి గలీజ్‍కరి ఎంచవాలనా యో గలీజాస్‍. ");
INSERT INTO vgr_vpl VALUES ("RM14_15","075_14_15","ROM","14","15","15","తారు భైయో, భేనే, తారు క్హాణు మూలంతి దుఃఖంచెతొ బారేమ తారుహంకె ఫ్యార్‍హుయిన్‍ ఛాలవాలొ యోకొన్‍. కినాటెకె క్రీస్తు మరిగొకరి ఇనా తారు క్హాణుతి క్హారబ్‍ కార్‍నొకొ. ");
INSERT INTO vgr_vpl VALUES ("RM14_16","075_14_16","ROM","14","16","16","తుమ్నా ఛాతే అష్యల్‍హుయుతె గాలయ్‍ హువాననొకొద్యెవొ. ");
INSERT INTO vgr_vpl VALUES ("RM14_17","075_14_17","ROM","14","17","17","దేవ్ను రాజ్యమ్‍ ఖావ్వాను పియాను కాహే పన్కి, నీతిబి షాంతిబి పరిసుద్ధాత్మమా ఖుషిహుయిన్‍ ఛా. ");
INSERT INTO vgr_vpl VALUES ("RM14_18","075_14_18","ROM","14","18","18","సానకతో ఆ విషయంమా క్రీస్తునా దాసుడుహుయుతె యో దేవ్ను ఇష్టుడుహుయుతె అద్మియెన ద్రుష్టినా యోగ్యుడ్‍. ");
INSERT INTO vgr_vpl VALUES ("RM14_19","075_14_19","ROM","14","19","19","అనటేకే షాంతిసమాధానంనా, బుజుఏక్‍ దుసారతీ సాంతితి ప్రోసాహీంచో కార్‍కుకరాతె ఇనా అఖ్‍తి అనుసరింతచు. ");
INSERT INTO vgr_vpl VALUES ("RM14_20","075_14_20","ROM","14","20","20","ఖాణును నిమిత్తం దేవ్ను కామ్మా ఖారబ్‍నొకొకారొ; ఖావను పదార్థంనా పవిత్రమాస్‍ పన్కి అనుమానంతి ఖావాలొ యో ఖారబ్‍. ");
INSERT INTO vgr_vpl VALUES ("RM14_21","075_14_21","ROM","14","21","21","బొట్టి క్హాను పన్కి, ద్రాక్చనురసం పియాను పన్కి, తారు భైయె, భేనే, అడ్డు కలుగుకారాస్‍కరి అజుకెవుబి పన్కి, బులిజ్హానొ అషల్. ");
INSERT INTO vgr_vpl VALUES ("RM14_22","075_14_22","ROM","14","22","22","తూనాఛాతె విష్వాస్‍నా దేవ్ను ఖామే తారటేకె తూస్‍ ఎంచిలెకొరాస్‍; యో సమ్మతించొతె విషయంమా ఇనా యోస్‍ న్యావ్‍ తీర్చుతిచిలెవాలొ ధన్యుడు. ");
INSERT INTO vgr_vpl VALUES ("RM14_23","075_14_23","ROM","14","23","23","అనుమనంచొవాలొ ఖాద్యెతెబరేమ విష్వాస్‍ కొయిన్‍తిమ్‍ ఖాసే, పన్కి దోషికరి న్యావ్‍ పొందవాలొ. విష్వాసమూలంతి హుయుతె కెవుకి యో పాప్‍. ");
INSERT INTO vgr_vpl VALUES ("RM15_1","075_15_1","ROM","15","1","1","కాహే తాఖత్‍వాలొయుహుతె తప్ప, అప్నా అప్నాస్‍ ఖుషిహువకొయిన్‍తిమ్‍, క్హాంజొర్‍ దౌర్బల్యంహుయుతె పేరిలెవానటేకె రుణమ్ హుయిన్‍ ఛా. ");
INSERT INTO vgr_vpl VALUES ("RM15_2","075_15_2","ROM","15","2","2","ఇను బగ్లాల్‍వాలు క్చేమాభిహ్రుద్ధి హువాతిమ్‍ అప్నమా హర్యేఏక్‍జాను అష్యల్ హుయుతె ఇనమా ఇనా ఖుషిరాక్‍నుకరి. ");
INSERT INTO vgr_vpl VALUES ("RM15_3","075_15_3","ROM","15","3","3","క్రీస్తుబీ ఇనాయోస్‍ ఖుషికర్‍లిదొకొయిని పన్కి తునా క్హుజయివాల గాలై మరపార్‍ పాడ్యు. కరి లిఖ్హుతిమ్‍ ఇనా హుయు. ");
INSERT INTO vgr_vpl VALUES ("RM15_4","075_15_4","ROM","15","4","4","కిమ్‍కాతొ ఓర్పునటేకె, ప్రోత్సహించటేకె అప్నా నిరీక్చణ హువాతిమ్‍ జామనామా లిఖ్హుతిమ్‍ క్హారుబి అప్నా బొధహుసేతిమ్‍ నిమిత్తం లిఖిలిన్‍ ఛా. ");
INSERT INTO vgr_vpl VALUES ("RM15_5","075_15_5","ROM","15","5","5","క్రీస్తు యేసు చిత్తప్రకారం ఎక్‍ దిల్తీ ఏక్‍ ఆవాజ్తి మల్యుతె ఇవ్నే ఓర్పునా ఆదరణనా కర్తహుయుతె దేవ్నా తుమ్నా అనుగ్రహించిస్‍ పన్కి. ");
INSERT INTO vgr_vpl VALUES ("RM15_6","075_15_6","ROM","15","6","6","తుమేస్‍ ఏక్‍భావం వాలా ఎకగ్రీవంతి అప్నా ప్రభువుహుయుతె యేసు క్రీస్తు భాహుయుతె దేవ్న మహిమపరచటేకే యేసుక్రీస్తుని వాతేఖమ్జిన్ ఇన్మారవానా ఎకామనస్సుతి ఒర్పుతి ఆదరణతిచాతే దేవ్ తుమ్నాదేవాదా. ");
INSERT INTO vgr_vpl VALUES ("RM15_7","075_15_7","ROM","15","7","7","అనటేకే క్రీస్తు తుమ్నా చేర్చులిదోతే ప్రకారం దేవ్ను మహిమతీ కలుగుతిమ్‍ తుమేబి ఏక్నాఏక్‍ చేర్చలెవొ. ");
INSERT INTO vgr_vpl VALUES ("RM15_8","075_15_8","ROM","15","8","8","మే బోలుకురాతే సాత్‍కతో, దేవ్ను హాఃచినా బ్హణే అన్యజణుల్‍ ఓఢో యో కర్యయోతే సుష్థిరంతీ వాక్ముల్‍నా తిరంతి కరనటేకె క్రీస్తు సున్నతి ఛాతే ఇవ్నా ప్రచార్‍ కరవాలొహుయో. ");
INSERT INTO vgr_vpl VALUES ("RM15_9","075_15_9","ROM","15","9","9","తుమేస్‍ ఏక్‍భావం వాలా ఎకగ్రీవంతి అప్నా ప్రభువుహుయుతె యేసుక్రీస్తు భాహుయుతె దేవ్న మహిమపరచ నిమిత్తం, మే బొలుకుర్‍తెసాత్‍కాతొ, భానొభా కార్యాతె వాగ్దానంనా విషయంమా దేవ్ను గోర్‍బి మహిమపరచటేకె క్రీస్తు సున్నతి వాలానా పరిచారకుడుహుయుతె. ఇన విషయంమా ఆ కారణంతి అన్యజనాభో మే తునా స్తుతించిస్‍; తారు నామ్‍నుసంకీర్తనా కార్‍సుకారి లిఖ్హురాక్యుస్‍. ");
INSERT INTO vgr_vpl VALUES ("RM15_10","075_15_10","ROM","15","10","10","అజు అన్యజనాభో, ఇనా ప్రజల్‍నా ఖుషితి ర్హావో కరి ");
INSERT INTO vgr_vpl VALUES ("RM15_11","075_15_11","ROM","15","11","11","అజు ధరత్తినా అన్యజనాభో, ప్రభువునా స్తుతించొ హర్యేక్ అద్మి ఇనా కొనియాడ్సుకరి బోలుకురాస్‍. ");
INSERT INTO vgr_vpl VALUES ("RM15_12","075_15_12","ROM","15","12","12","అజు యెషయా ఇమాస్‍ బొలుకురాస్‍, యెష్షయిను ఖాందాన్‍ మాతు ఝడ్‍ ఆవ్సే, కతొ అన్యజనాభో ఏలానటేకే ఉట్టావాలొ అవ్సే; ఇనాకనా అన్యజనాభో ఆఖ్‍తి ర్హాక్‍సు. ");
INSERT INTO vgr_vpl VALUES ("RM15_13","075_15_13","ROM","15","13","13","హువామా తూమే పరిసుద్ధాత్మను తాఖత్‍నా పొందిన్‍, విస్తారంతి నిరీక్చణ హువాలతిమ్‍ నిరీక్చణకర్తహుయతె దేవ్ను విష్వాస్‍తిస్‍ ధారతి ఖారుబి షాంతి తుమ్మనా భారిస్‍ పన్కి. ");
INSERT INTO vgr_vpl VALUES ("RM15_14","075_15_14","ROM","15","14","14","మారా భైయ్యే బుజు భేనె, తుమే కేవలం అచ్చువాల నమ్ముకురు, సమస్త తారుపూరజ్ఞాన్‍తి, ఎక్నాయేక్‍ దిమక్‍బోలిన్‍ యోగ్యుల్‍హుయుతెకరి మరతొడి మేబి తుమ్నా గూర్చి ఖఛ్చింతి నమ్ముకురుస్‍. ");
INSERT INTO vgr_vpl VALUES ("RM15_15","075_15_15","ROM","15","15","15","హుయుతొ అన్యజానబొ కరి అర్పణ పరిసుద్ధాత్మటేకె ప్రీతిహువాతిమ్‍, మే సువార్త విషయంహుయిన్‍ యాజక ధర్మం హుయిన్‍, దేవ్తి మన అనుగ్రహింపబడిన్‍ కృపను బట్టి, ");
INSERT INTO vgr_vpl VALUES ("RM15_16","075_15_16","ROM","15","16","16","సానటేకె అన్యజనాభోనా అర్పణ పరిసుద్థాత్మహాఃజె పవిత్రహుయిన్‍, దేవ్నా ఇష్టమ్‍హువతిమ్‍, మే సువార్త విషయమ్‍మా యాజక ధర్మమ్‍ కర్తహుయిన్‍, దేవ్ను మన అనుగ్రహించుతే కృపటేకె అన్యజనాభోవాలనా యేసుక్రీస్తు సేవకుడ్‍హుయిన్‍ ఛావు. ");
INSERT INTO vgr_vpl VALUES ("RM15_17","075_15_17","ROM","15","17","17","హువామా, క్రీస్తుయేసునాబట్టి దేవ్ను సేవ విషయంహుయిన్‍ సంగతుల్‍మా మన గర్వంకారణం ఛా. ");
INSERT INTO vgr_vpl VALUES ("RM15_18","075_15_18","ROM","15","18","18","కింకతొ అన్యజనాభో విధేయులుహువాతిమ్‍, వాక్యంతి, క్రియతి, సాబుత్‍ థాకత్‍తి, బోలుకరూస్‍, ");
INSERT INTO vgr_vpl VALUES ("RM15_19","075_15_19","ROM","15","19","19","అద్బుతాల్‍తి, పరిసుద్ధాత్మ థాకత్‍తి క్రీస్తు మరేతి ఎంచిన్‍ ఇన గూర్చిను పన్కి అజు ఇన గూర్చిబి వాత్‍బొలనా తెగించ్యొ. అనటేకే యెరూషలేమ్‍తూ ధరీన్‍ ఆజు బాజుమాఛాతే దేఖ్‍, ఇల్లూరితొడి క్రీస్తు సువార్తనా పూర్తితీ ప్రచార్‍కర్‍రాక్యోస్‍. ");
INSERT INTO vgr_vpl VALUES ("RM15_20","075_15_20","ROM","15","20","20","మేహుయుతొ అజేక్ను పునాదిఫర్‍ నాబ్హాద్‍నుకరి క్రీస్తు నామ్ మాలంకొయింతెజొగొ సువార్తన ప్రచార్ కరి గ్హాను ఆఖ్‍తి ఇమ్‍ ప్రకటించో, ");
INSERT INTO vgr_vpl VALUES ("RM15_21","075_15_21","ROM","15","21","21","లిఖ్కుతిమ్‍ ప్రకారం క్రీస్తునా బారెమా సమాచరం మాలంకొయినికి ఇవ్నా ఇవ్నే దేఖ్యా. కోన్‍ హఃమ్జ్యూ కొయినికి ఇవ్నే మాలంకర్చె. ");
INSERT INTO vgr_vpl VALUES ("RM15_22","075_15_22","ROM","15","22","22","ఆ కారణంతి తుమరకానా అవకొయినితిమ్‍ మన కెత్రుకి చోట్‍ పర్యాయలు ఆఢు హుయు. ");
INSERT INTO vgr_vpl VALUES ("RM15_23","075_15_23","ROM","15","23","23","హంకేహుయుతొ ఆ జోగొ మేహంకె సంచరింపనుకరి భాగ్‍ కొయిని పన్కి, కెత్రుకి వారఖ్‍ కంతు తుమరకాన అవ్నుకరి ఘాను అపేక్చకలిగిన్‍ ఛావు, ");
INSERT INTO vgr_vpl VALUES ("RM15_24","075_15_24","ROM","15","24","24","మే స్పెయిను దేఖాక్నా గాయితొ వాట్‍మా తుమ్నా ద్యెకిన్‍, అగాడి తుమరు మాలనాటేకె తొడుతొడి ఖుషివొనొకరి, తుమరెతి ఎగ్జా బొలిమొకులునుకరి ఆఖ్‍తి రాస్‍. ");
INSERT INTO vgr_vpl VALUES ("RM15_25","075_15_25","ROM","15","25","25","హుయుతొ హంకె దేవ్ను అద్మియే సేవా కర్తహుయిన్‍ యెరూషలేమ్‍నా జొమ్కురాస్‍. ");
INSERT INTO vgr_vpl VALUES ("RM15_26","075_15_26","ROM","15","26","26","కింకతొ యెరూషలేమ్‍మా ఛాతె దేవ్ను అద్మియేనా గారిబ్‍హుయుతె ఇవ్నే నిమిత్తం మాసిదోనియవాలబి అకయవాలాబి తొడు పైసా దేనుకరి ఇష్టంహుయూ. ");
INSERT INTO vgr_vpl VALUES ("RM15_27","075_15_27","ROM","15","27","27","ఓ ఇవ్నేఇష్టపడ్యె ఇనా కరిన్‍; ఇవ్నే ఇవేనా రుణపడిన్‍; కింకతొ అన్యజనాభోనా తప్ప ఇవ్నే ఆత్మ సంబంహుయుతె ఆషీర్వాదంనా విషయంమా భాగ్‍వాలహుయిన్‍ ఛా పన్కి ఆంగ్తాను సంబంధ హుయుతె విషయంమా ఆవ్నే ");
INSERT INTO vgr_vpl VALUES ("RM15_28","075_15_28","ROM","15","28","28","ఆ కామ్‍ పూర్తికరిన్‍ ఆ ఫలంనా ఇవ్నేఅప్పగిమ్చిన్‍, మే తుమ్నా మలిన్‍, స్పెయిన్‍తొడి ప్రయాణంనా కరీస్‍. ");
INSERT INTO vgr_vpl VALUES ("RM15_29","075_15_29","ROM","15","29","29","మే తురకనా అయోతెదె, క్రీస్తును ఘాను ఆషీర్వాదమ్తీ ఆయిస్‍కరి మన మాలం. ");
INSERT INTO vgr_vpl VALUES ("RM15_30","075_15_30","ROM","15","30","30","భైయ్యె, భేనె మారటేకె దేవ్నా కార్‍యుతె ప్రార్థనామ మరకెడె మలిన్‍ లడ్డాయికార్‍నుకరి, అప్ను ప్రభువుహుయుతె యేసు క్రీస్తునా బట్టి, ఆత్మనటేకె ఫ్యార్‍ను బట్టి తుమ్నా పొఖాలవుకురుస్‍. ");
INSERT INTO vgr_vpl VALUES ("RM15_31","075_15_31","ROM","15","31","31","మే యూదయమా ఛాతె ఆవిష్వాస్‍నా హత్‍ కంతు చుఖ్కాయ్‍ జానుకరి ప్రార్థన కర్యొ, బుజు యెరూషలేమ్‍మా కారనుఛాతె ఆ సేవ దేవ్ను అద్మియేనా హఃమ్జనుతిమ్‍. ");
INSERT INTO vgr_vpl VALUES ("RM15_32","075_15_32","ROM","15","32","32","ఆజు మే దేవ్ను చిత్తంటేకె ఖుషితి తుమరకానా అయిన్‍, తుమరెతి మలిన్‍ అరామ్‍ పొందాయో, ");
INSERT INTO vgr_vpl VALUES ("RM15_33","075_15_33","ROM","15","33","33","షాంతిసమాధాన కర్తహుయోతె దేవ్నాతుమరక్హారన తొడుహుయిన్‍ పన్కి. ఆమేన్‍. ");
INSERT INTO vgr_vpl VALUES ("RM16_1","075_16_1","ROM","16","1","1","మే ఫీబే కరి అప్ను భేన్‍ హుయితె, కెంక్రేయమాఛాతె సంఘనా ప్రచార్‍కరవాలి హుయిన్‍ ఛా ");
INSERT INTO vgr_vpl VALUES ("RM16_2","075_16_2","ROM","16","2","2","ఇనా తుమరటేకె హోనుతె కెవుబి ఛాతెబారేమ సహాయం కార్‍నుకరి యోబాయికొ గూర్చి తుమ్నా సిఫారస్‍ కరూకరాస్‍ యో మనా బుజు గ్హను అద్మినా సహాయం కరి. ");
INSERT INTO vgr_vpl VALUES ("RM16_3","075_16_3","ROM","16","3","3","క్రీస్తుయేసుమా మారు భేన్‍ హుయితే అకులకునా ప్రిస్కిల్లనా మారు హఃలామ్‍ కరి బొలొ. ");
INSERT INTO vgr_vpl VALUES ("RM16_4","075_16_4","ROM","16","4","4","ఇవ్నే మారటేకెస్‍ కాహే యెజ్గా ఛాతె సంఘం హాఃరనాటేకె జాన్‍ దెవ్వావనటేకె ఇవ్నే తెగిమ్చా. అజు ఇవ్ను గేర్‍ సంఘమ్‍నా క్హాలమ్‍ బోలొ, మేస్‍ కాహే అన్యజనాభోమా సంఘమ్‍క్హార్‍నా ఆవ్నాభాన్నే కృతజ్ఞలుహుయిరాస్‍. ");
INSERT INTO vgr_vpl VALUES ("RM16_5","075_16_5","ROM","16","5","5","అజు ఇవ్ను ఘర్మా మలీన్‍ ఛా సంఘంనా హఃలమ్‍. ఆసియామా అగాడి క్రీస్తునా విష్వాసించొతె మారొ లాఢ్‍హుయోతె ఎపైనెటుకు ఖాలామ్‍. ");
INSERT INTO vgr_vpl VALUES ("RM16_6","075_16_6","ROM","16","6","6","తుమరటేకె గ్హాను ప్రయాసపడిన్‍ అజుతుమ్‍నా మరియనా హఃలమ్‍. ");
INSERT INTO vgr_vpl VALUES ("RM16_7","075_16_7","ROM","16","7","7","మన మయామాత్ర మరు తొడు ఖైదీల్‍నా ఆంద్రొనీయనా ఖాలమ్‍, యూనీయనబి ఖాలమ్‍; అవ్నే అపోస్తలుమా నామ్‍ పొందినవాలా, మరుకంటె అగాడి క్రీస్తుమా విష్వాస్‍కర్యుతె ఇవ్నే. ");
INSERT INTO vgr_vpl VALUES ("RM16_8","075_16_8","ROM","16","8","8","ప్రభువుమా మన లాఢ్‍హుయోతె అంప్లీయతునా క్హాలమ్‍. ");
INSERT INTO vgr_vpl VALUES ("RM16_9","075_16_9","ROM","16","9","9","క్రీస్తుమా అప్ను జొడుకామ్‍వాలా ఊర్బానాకు మారు లాఢ్‍హుయోతె స్టాకునా ఖాలమ్‍. ");
INSERT INTO vgr_vpl VALUES ("RM16_10","075_16_10","ROM","16","10","10","క్రీస్తుమా యోగ్యుడ్‍ హుయోతె అపెల్లెనా హఃలమ్‍. అరిస్టొబూనా ఘేర్‍వాలనా ఖాలమ్‍. ");
INSERT INTO vgr_vpl VALUES ("RM16_11","075_16_11","ROM","16","11","11","మరు మయామాత్ర హెరోది యోనునా హఃలమ్‍. నార్కిస్సు ఘేర్‍వాలనా ప్రభువుమా ఇవ్నే హఃలామ్‍. ");
INSERT INTO vgr_vpl VALUES ("RM16_12","075_16_12","ROM","16","12","12","ప్రభువుమా ప్రయాసపడు త్రుపైనాకు, త్రుఫోసాకు హఃలమ్‍. లాఢ్‍వాల పెర్సిసునా హఃలమ్‍; యో ప్రభువుమా ఘను ప్రయాసపడ్యా. ");
INSERT INTO vgr_vpl VALUES ("RM16_13","075_16_13","ROM","16","13","13","ప్రభువుమా ఏర్పచిరాక్యొతె రూపునా ఖాలమ్‍; ఇనా అయానబి ఖాలమ్‍; యో మనబి అయా. ");
INSERT INTO vgr_vpl VALUES ("RM16_14","075_16_14","ROM","16","14","14","అసుంక్రితునా, ప్లెగో, హెర్మే, పత్రొబ, హెర్మానా, ఇనామా మలిన్‍ఛాతె భైయెనా బెనేనాబి ఖాలమ్‍. ");
INSERT INTO vgr_vpl VALUES ("RM16_15","075_16_15","ROM","16","15","15","పిలొలొనా, యూలియాన, నేరియన, ఇను భేనెనాబి, ఒలుంపాకునా ఇవ్నేతెఛాతె పరిసుధ్ధుల్‍ హాఃరనా హఃలామ్‍. ");
INSERT INTO vgr_vpl VALUES ("RM16_16","075_16_16","ROM","16","16","16","పవిత్రహుయుతె బుచ్చదిన్‍ ఏక్నాయేక్‍ హఃలమ్‍ కరొ. క్రీస్తుసంఘం హాఃరుబి తుమ్నా హఃలామ్‍ బోలుకురుస్‍. ");
INSERT INTO vgr_vpl VALUES ("RM16_17","075_16_17","ROM","16","17","17","భైయ్యే, భేనెనా తుమే సికిలిదాతె బోధనా వ్యతిరేకంతి భేదంతి ఆటంకంనా కలిగిమ్చోతే ఇవ్నే కనిపెట్టి ర్హవొ తుమ్నా పొఖాలవుకురుస్‍. ఇవ్నేకంతు దుర్‍హువొ. ");
INSERT INTO vgr_vpl VALUES ("RM16_18","075_16_18","ROM","16","18","18","ఎజాత్ను వానా అప్ను ప్రభువుహుయుతె క్రీస్తునా కాహే ఇవ్నే పేట్‍నా దాసులు; ఇవ్నే హంకెతు వాత్తిగాని ఇచ్చకంటేకెతొబి నిష్కపటుల దిల్నా మోసంకార్‍సే. ");
INSERT INTO vgr_vpl VALUES ("RM16_19","075_16_19","ROM","16","19","19","తుమరు విధేయత క్హారనా ప్రచురంహుయు పన్కి తుమ్నాగూర్చి ఖుషితిఛావ్‍. తుమే అష్యల్ విషయంహుయిన్‍ జ్ఞానుల్‍నా, కారబ్ను విషయహుయిన్‍ నిష్కపటుహుయుతె ర్హానుకరి కోరుకురుస్‍. ");
INSERT INTO vgr_vpl VALUES ("RM16_20","075_16_20","ROM","16","20","20","షాంతిసమాధాన కర్తహుయుతె దేవ్నా సైతాన్‍ తుమరు గొడనాహేట్‍ కుద్హాల్వాసే. అప్ను ప్రభువుహుయుతె యేసుక్రీస్తు కృప తుమ్నా తొడహుయిన్‍ పన్కి. ");
INSERT INTO vgr_vpl VALUES ("RM16_21","075_16_21","ROM","16","21","21","మారు జొడుకామ్‍వాలా తిమోతి మారు మయామాత్ర‍నా లూకియ యాసోను, సోసిపత్రు కరివాలన తుమ్నా హఃలమ్‍ బోలుకరూస్‍. ");
INSERT INTO vgr_vpl VALUES ("RM16_22","075_16_22","ROM","16","22","22","ఆ పత్రిక లిఖ్యూతె తెర్తియు కరి మే ప్రభువుమా తుమ్నా హాఃలమ్‍ కరుకరూస్‍. ");
INSERT INTO vgr_vpl VALUES ("RM16_23","075_16_23","ROM","16","23","23","మనబి సంఘంహాఃరనా ఆతిథ్యందెవ్వాలొ గాయి తుమ్నా హఃలామ్‍ బోలుకురుస్‍, ఆ ఖాయేర్‍ ఖజానావాలొ ఎరస్తు భైయెనా క్వర్తునా తుమ్నాబి హఃలామ్‍ బోలుకురుస్‍. ");
INSERT INTO vgr_vpl VALUES ("RM16_24","075_16_24","ROM","16","24","24","అప్ను ప్రభువుహుయోతె యేసుక్రీస్తు తుమ్నా తొడుహుయిన్‍ ర్హాస్ పన్కి. ");
INSERT INTO vgr_vpl VALUES ("RM16_25","075_16_25","ROM","16","25","25","ఆ మర్మంనా ఘను రోజ్తీ అనుసరించిఛాతె మరు సువార్త ప్రకారం కరి, యేసు క్రీస్తు గూర్చినా ప్రచార్‍నా ప్రకారంకరి, తుమ్నా సిరపరచిక్హాత్‍వాలొ. ");
INSERT INTO vgr_vpl VALUES ("RM16_26","075_16_26","ROM","16","26","26","సారహుయుతె అన్యజనాబ విష్వాస్‍నా విధేయులుతిమ్‍, జామనా కంతు రహస్యంతి ర్హాకిరాకిన్‍ కెదెబి ప్రత్యక్చపరచబడ్యుతె మర్మంనా, నిత్యమ్‍ దేవ్నా ఆజ్ఞప్రకారం ప్రవక్తల్‍నా లేఖనంను తీస్‍ ఇవ్నే తెలుపబడిన్‍ ఛా. ");
INSERT INTO vgr_vpl VALUES ("RM16_27","075_16_27","ROM","16","27","27","ఏక్‍ జ్ఞానంవాలొహుయుతె దేవ్నా, యేసు క్రీస్తు తిస్‍, కెదేబి మహిమ కలుగ్‍సే గాక. ఆమేన్‍.");
INSERT INTO vgr_vpl VALUES ("C11_1","076_1_1","1CO","1","1","1","దేవ్ను చిత్తంనుబారెమా యేసుక్రీస్తునూ హఃజె అపొస్తలుఘోని రవ్వానటేకె బులాయుహుయోతె పౌల్నా, భైహుయోతె సొస్తెనేసునా, ");
INSERT INTO vgr_vpl VALUES ("C11_2","076_1_2","1CO","1","2","2","కొరింథుల్మాఛాతె దేవ్ను సంఘంనా, కతొ యేసుక్రీస్తుమా పరిసుద్ధంతి దొవ్వాయిహుయిన్‍ పరిసుద్ధంతి రవ్వానటేకె బులాయుహుయురతే ఇవ్నాబి, అప్నబి ప్రభువునుఘోని ఛాతె అప్ను ప్రభుహుయోతె యేసుక్రీస్తు నామ్‍మా హర్యేక్‍జొగొమా ప్రార్థనకరవాలు హాఃరవ్నా అఛ్చుకరి బోలిన్‍ లిఖ్యుతె. ");
INSERT INTO vgr_vpl VALUES ("C11_3","076_1_3","1CO","1","3","3","అప్న భా హుయోతె దేవ్‍ కంతూ, ప్రభుహుయోతే యేసుక్రీస్తుకంతూ కృపబి సమాధానంబి షాంతి తుమ్నహువదా. ");
INSERT INTO vgr_vpl VALUES ("C11_4","076_1_4","1CO","1","4","4","యేసుక్రీస్తు బరెమా తుమ్న దెవ్వాయ్‍రాక్యుతె దేవ్ను కృపనా దేఖిన్, తుమార విషయంమా ధన్యవాద్‍ బోలుకరుస్‍. ");
INSERT INTO vgr_vpl VALUES ("C11_5","076_1_5","1CO","1","5","5","కతొ సమస్తంను సాబుత్‍మహో సమస్తంను జ్ఞానంమహో దవ్లత్‍వాలుహుయ; ");
INSERT INTO vgr_vpl VALUES ("C11_6","076_1_6","1CO","1","6","6","క్రీస్తున బారెమనూ సాబుత్‍ తుమారమా స్థిరంహువనా అనటేకె ఇన్మా తుమే హర్యేక్ విషయంమాబి, ");
INSERT INTO vgr_vpl VALUES ("C11_7","076_1_7","1CO","1","7","7","అనటేకె కెహు అత్మియావరంమ లోపమ్‍ కోయిన్తిమ్‍ తుమే అప్ను ప్రభుహుయోతె యేసుక్రీస్తును ప్రత్యక్చతనటేకె దేక్తూరంకరస్‍. ");
INSERT INTO vgr_vpl VALUES ("C11_8","076_1_8","1CO","1","8","8","అప్ను ప్రభుహుయోతె యేసుక్రీస్తు ఆవ్సేతె ధన్నే తుమె పాప్‍వాలకోయిన్తిమ్‍ ర్హానుతిమ్‍ ఆఖరీను ధన్తోడి యోతుమ్న స్థిరంతి రాక్సె. ");
INSERT INTO vgr_vpl VALUES ("C11_9","076_1_9","1CO","1","9","9","అప్నొ ప్రభుహుయోతె యేసుక్రీస్తుకరి ఇన ఛియ్యాను సహావాసంకేడె ర్హానుకరి తుమ్న బులాయోతె దేవ్‍ నమ్మకంవాలొ. ");
INSERT INTO vgr_vpl VALUES ("C11_10","076_1_10","1CO","1","10","10","భైయ్యే భేనె, తుమెహాఃరు ఏక్‍హుయిన్‍ వాతెబోల్నుకరి, తుమారమా కక్చ్యా కొయిన్‍తిమ్‍, ఏక్ దిల్తి ఏక్‍హుయిన్‍ తుమె ఉబ్రిర్హానుకరి, అప్న ప్రభుహుయోతె యేసుక్రీస్తు నామ్‍మా అధికార్‍తి తుమ్న బతిమాలుకరూస్‍. ");
INSERT INTO vgr_vpl VALUES ("C11_11","076_1_11","1CO","1","11","11","మార భైయ్యె భేనె, తుమారమా లఢాయే ఛాకరి తుమార గూర్చిన్‍ క్లోయె ఘర్‍వాలతి మన మాలంహుయు. ");
INSERT INTO vgr_vpl VALUES ("C11_12","076_1_12","1CO","1","12","12","తుమారమా “ఏక్జనొ మే పౌల్‍వాలొకరి, ఏక్జనొ మే అపొల్లోవాలొకరి, బుజేక్జనొ మే పేతుర్‍వాలొకరి” అజేక్జనొ మే “కేఫావాలొకరి, పార్ల్యొవాలొ మే క్రీస్తువాలోకరి” మే ర్హహిజంకురుస్‍. ");
INSERT INTO vgr_vpl VALUES ("C11_13","076_1_13","1CO","1","13","13","క్రీస్తు భాగ్‍ హుయురోస్నా? పౌల్‍నే తుమారటేకె సిలువ నక్కాయ్‍ రాక్యోస్‍నా? పౌల్‍ను నామ్‍మా తుమే బాప్తిస్మమ్‍ లీరాక్యస్‍నా? ");
INSERT INTO vgr_vpl VALUES ("C11_14","076_1_14","1CO","1","14","14","మారు నామ్మా తుమె బాప్తిస్మమ్‍ లీరాక్యస్‍కరి కోన్బి నాబోల్నుతింమ్ క్రీస్పునబీ గాయికినబీ తప్ప బుజు కినాబి మే బాప్తిస్మమ్‍ దిదొకొయిని; ");
INSERT INTO vgr_vpl VALUES ("C11_15","076_1_15","1CO","1","15","15","అనటేకె మే దేవ్నా నామ్‍మా కృతజ్ఞతాస్తుతుల్‍ చెల్లుంచుకరూస్‍. ");
INSERT INTO vgr_vpl VALUES ("C11_16","076_1_16","1CO","1","16","16","స్తెఫన్‍ను ఘేర్‍వాలనబి మే బాప్తిస్మమ్‍ దిదోసికీ; అవ్నాతప్ప బుజు కినాబి బాప్తీస్మమ్‍ దిదోసూకి మన మాలంకొయిని. ");
INSERT INTO vgr_vpl VALUES ("C11_17","076_1_17","1CO","1","17","17","క్రీస్తు బాప్తిస్మమ్‍ దెవ్వానటేకె మన మొక్లొకొయిని పన్కి, సిలువమా క్రీస్తును మరణ్‍నా పాల్తు నాహోనుతిమ్‍, వాతెతీస్ కాహేతిమ్‍ సుసమాచార్‍నా బోలనటేకెస్‍ యో మన మొక్లొ. ");
INSERT INTO vgr_vpl VALUES ("C11_18","076_1_18","1CO","1","18","18","సిలువమా క్రీస్తుమరణ్‍ను వార్త, మటిజంకరతె ఇవ్నా ధివాను పన్కి, బఛ్చుకరతె అప్నా దేవ్‍ను తాఖత్‍. ");
INSERT INTO vgr_vpl VALUES ("C11_19","076_1_19","1CO","1","19","19","అన విషయంమా జ్ఞానుల్‍ను “జ్ఞానంనా నాషనం కరీస్‍. అఖ్కల్‍వాలను అఖ్కల్నా కామె ఆవకొయిన్తిమ్‍ కరీస్‍కరి” లిఖ్కాయిన్‍ ఛా. ");
INSERT INTO vgr_vpl VALUES ("C11_20","076_1_20","1CO","1","20","20","జ్ఞాని సాత్‍హుయ్‍గో? షాస్త్రి సాత్‍హుయ్‍గో? ఆ ములక్‍ను ఛాడి బోలవాలు సాత్‍హుయ్‍గో? ఆ ములక్ను జ్ఞానంనా దేవ్‍ ఫాగల్‍గోని కర్రాక్యోస్‍ కాహెనా? ");
INSERT INTO vgr_vpl VALUES ("C11_21","076_1_21","1CO","1","21","21","దేవ్‍ను జ్ఞానం కారణంతి ములక్‍ ఇను జ్ఞానంనాహాతె దేవ్నా నామాలంకరమా, సుసమాచార్‍ ప్రచార్‍ను దివాను నమ్మతెవాలనా బఛ్చావను దేవ్ను ఇష్టపూర్వకంహుయూతె సంకల్పంహుయీన్‍ ఛా. ");
INSERT INTO vgr_vpl VALUES ("C11_22","076_1_22","1CO","1","22","22","యూదుల్‍ అద్భుతంనా వతాల్‍కరి పుఛ్చాంకరస్, గ్రీసుదేహ్‍వాల జ్ఞానంనా దూండుకరస్‍. ");
INSERT INTO vgr_vpl VALUES ("C11_23","076_1_23","1CO","1","23","23","పన్కి హమె సిలువ నఖ్కాయోతె క్రీస్తున ప్రచార్‍ కరూకరియేస్‍. యో యూదుల్‍న ఆటంకమ్‍ తరా యూదుల్‍ కాహెతెవాల ఫాగల్‍ ఘోని హుయ్‍రోస్‍; ");
INSERT INTO vgr_vpl VALUES ("C11_24","076_1_24","1CO","1","24","24","పన్కి యూదుల్‍హో, గ్రీసు దేహ్క్ వాలనహో, బులాయోహుయో ఇవ్నాస్‍ క్రీస్తు దేవ్‍ని తాఖత్‍బీ దేవ్ని జ్ఞానంహుయిన్‍ ఛా. ");
INSERT INTO vgr_vpl VALUES ("C11_25","076_1_25","1CO","1","25","25","దేవ్‍ని అజ్ఞానమ్‍ అద్మిను జ్ఞానంతీబి జ్ఞానంహుయిన్‍ ఛా, దేవ్ను కంజోర్‍ అద్మిను తాఖత్‍తీబి తాఖత్‍. ");
INSERT INTO vgr_vpl VALUES ("C11_26","076_1_26","1CO","1","26","26","భైయ్యే భ్హేనె, తుమ్న బులాయోతె బులావను దేక్కొ. తుమారమా ములక్నురీతిను జ్ఞానుల్ హుయతో, మోటాహాఃదన్ వాలహుయుతోబి, మహాన్‍జాత్‍వాల హుయుతొ, కెత్రూకిజననా మే బులయోకోయిని పన్కి ");
INSERT INTO vgr_vpl VALUES ("C11_27","076_1_27","1CO","1","27","27","దేవ్‍ జ్ఞానంవాలను షరం కాడనటేకె ములక్‍మాతు ఫాగల్‍వాలన చూణి రాక్యోస్‍ తాఖత్‍వాలన షరం కాడవనాటేకె ములక్‍మతూ కంజోర్‍వాలన చూణిరాక్యోస్‍. ");
INSERT INTO vgr_vpl VALUES ("C11_28","076_1_28","1CO","1","28","28","మహాన్‍వాలన షరమ్‍ కఢావనాటేకె ములక్‍మా కామె ఆవకొయింతె అద్మినా నొకొకరిబోలుతె ఇవ్నా, లెక్కమా కొయింతే అద్మినా దేవ్‍ చూణి రాక్యొస్‍. ");
INSERT INTO vgr_vpl VALUES ("C11_29","076_1_29","1CO","1","29","29","ఇనటేకె కెహు అద్మిబి దేవ్నాహాఃమె ఘమండి నామార్ను. ");
INSERT INTO vgr_vpl VALUES ("C11_30","076_1_30","1CO","1","30","30","పన్కి ఇను బారెమా తుమె క్రీస్తుయేసుమా ఛా. దేవ్‍ను మూలంమా యో అప్నా జ్ఞానంనా నీతిన పరిసుద్ధాత్మ ఛొడాయిన్‍హుయ్‍రూస్‍. ");
INSERT INTO vgr_vpl VALUES ("C11_31","076_1_31","1CO","1","31","31","అనటేకె “బఢాయ్‍మారవాలొ ప్రభువుమాస్‍ బడ్డాయిపర్నుకరి” లిఖ్కారూతె నెరవేర్చబడు. ");
INSERT INTO vgr_vpl VALUES ("C12_1","076_2_1","1CO","2","1","1","భైయ్యే భేనె, మే తుమారకన ఆయిన్‍ దేవ్‍ను గురించి సాబుత్‍ బోల్యొతెదె వాతేతి పన్కి, మహాన్‍ జ్ఞానంతి వాడ్యొకొయిని. ");
INSERT INTO vgr_vpl VALUES ("C12_2","076_2_2","1CO","2","2","2","మే తుమార ఇఛ్మాతోతెదే సిలువనఖ్కాయోతె యేసుక్రీస్తున తప్ప, అజు కెహూబి మాలంకొయినీకరి నిర్ణయించిల్దొ. ");
INSERT INTO vgr_vpl VALUES ("C12_3","076_2_3","1CO","2","3","3","బుజు కంజోర్‍హూఃతిబీ ఢర్తొతీబి కెత్రూకి కాప్‍తోహుయిన్‍ తుమారకన రయ్యోథొ. ");
INSERT INTO vgr_vpl VALUES ("C12_4","076_2_4","1CO","2","4","4","మే వాతెబోల్యొతోబి సువార్తన ప్రచార్‍కర్యాతోబి జ్ఞానయుక్తంహుయుతె మిట్టువాతెనా వాడిలిదొకొయినితిమ్‍, పరిసుద్ధాత్మమాబి దేవ్ను తాఖత్‍ దెఖ్కావతె సూచకక్రియల్‍ వినిగించిరాక్యోస్‍. ");
INSERT INTO vgr_vpl VALUES ("C12_5","076_2_5","1CO","2","5","5","తుమారు విష్వాస్‍ అద్మిను జ్ఞానంఫర్‍ ఆధారపడకొయినీతింమ్‍, దేవ్‍ను తాఖత్‍నా ఆధారంకర్లీన్‍ ర్హానుకరి ");
INSERT INTO vgr_vpl VALUES ("C12_6","076_2_6","1CO","2","6","6","పరిపూర్ణహుయుతె జ్ఞానంనా ఇవ్నా ఇచ్మా వార్త బోధించుకరుయేస్‍, యో ఆ ములక్‍ను జ్ఞానంకాహె, కామేఆవకొయినీతిమ్‍ జంకరతే ఆ ములక్‍ను అధికారుల్‍ను జ్ఞానంను కాహే. ");
INSERT INTO vgr_vpl VALUES ("C12_7","076_2_7","1CO","2","7","7","ఆ దేవ్ని లాపఢిరాఖ్యుతె జ్ఞానం బోధించుకర్యుస్‍ ఆ జ్ఞానం దేవ్‍కన లపాఢిలీన్‍ తూ. ములక్‍ పైద్దహువనా అగాడిస్‍ దేవ్‍ అన అప్న మహిమన బారేమా నియమించి రాక్యోస్‍ అన్నాస్‍ మే తమ్న ప్రచార్‍కర్యొ. ");
INSERT INTO vgr_vpl VALUES ("C12_8","076_2_8","1CO","2","8","8","ఆ ములక్‍ను అధికారుల్‍మా కినాబి మాలంకొయిని ఆ ఇవ్నా మాలంరయ్యుతొ తెదె మహిమాస్వరూపి హుయోతె ప్రభువును సిలువ నాఖకొయినీతింమ్‍ రయ్యూహోత్‍. ");
INSERT INTO vgr_vpl VALUES ("C12_9","076_2_9","1CO","2","9","9","అనహాఃజె దేవ్‍ ఇన ఫ్యార్‍కరవాలనటేకె కెహూ సిద్ధంకర్యాకోస్‍కి “యో డోళనహాఃమె దెఖ్కాయుకొయిని, కాణ్‍నా హఃమ్‍జాయుకొయిని, ఆద్మిను దిల్‍మా సోచయికోయిని కోహుయునికరి లిఖ్కాయిన్‍ ఛా.” ");
INSERT INTO vgr_vpl VALUES ("C12_10","076_2_10","1CO","2","10","10","అప్నహుయోతొ దేవ్‍ యోహాఃరు ఇను ఆత్మనబన్తీ, భార్‍బోలిరాక్యోస్‍ ఆ ఆత్మా హాఃరన, దేవ్ని లప్యుతేవాత్‍ హాఃరూబి మాలంకరుకరాస్‍. ");
INSERT INTO vgr_vpl VALUES ("C12_11","076_2_11","1CO","2","11","11","ఏక్ అద్మిను సంగతుల్‍ ఇనమాఛాతె ఇను ఆత్మనస్‍ పన్కి అద్మియేమా అజు కినా మాలంహుసె? ఇమ్మస్‍ దేవ్ను సంగతుల్‍బి దేవ్ని ఆత్మనస్‍ పన్కి బుజుకినాబీ మాలంకొహువని. ");
INSERT INTO vgr_vpl VALUES ("C12_12","076_2_12","1CO","2","12","12","దేవ్నుబారెమా అప్న దెవ్వాయ్‍రాక్యుతె హాఃరు మాలంకర్లెవనా అప్నె లౌకికాత్మన కాహేతింమ్‍ దేవ్నుకంతూ ఆయూతె ఆత్మనా పొందిరాక్యాస్‍. ");
INSERT INTO vgr_vpl VALUES ("C12_13","076_2_13","1CO","2","13","13","అద్మియేను జ్ఞానం సిఖనువాతేతి కాహేతిమ్‍ ఆత్మసంబంధహుయుతె ఇవ్నేతి ఆత్మసంబంధహుయుతె సంగతుల్‍తీ హూఃదుకరతాహుయిన్‍, ఆత్మా సిఖ్కాడతెవాతెతీ అన గూర్చినస్‍ హమె బోధించుకరియేస్‍. ");
INSERT INTO vgr_vpl VALUES ("C12_14","076_2_14","1CO","2","14","14","సహజ సంబంధహుయుతె అద్మి దేవ్ను ఆత్మను విషయాలనా అంగీకరించకొయినీ, యో ఇన పాగల్‍ఘోని హుయ్‍రూస్‍, యో ఆత్మనూ బన్తీస్‍ విమర్సనపడుకరస్‍ అనహాఃజె ఇనె ఇనా గ్రహించకొయని. ");
INSERT INTO vgr_vpl VALUES ("C12_15","076_2_15","1CO","2","15","15","ఆత్మ సంబంధహుయెతె యో హాఃరస్‍నా పరీక్చాకర్సె పన్కి, యో కినా హాతెతీబి కినహాతెతిబి బోలయిలిషేకొయిని బడ్చెకొయిని. ");
INSERT INTO vgr_vpl VALUES ("C12_16","076_2_16","1CO","2","16","16","“ప్రభువును దిల్నా మాలంకరీన్‍ ఇన బోధించవాలొ యోకోన్‍? అప్నెహుయితొ క్రీస్తును దిల్నవాల హుయ్‍రాస్‍.” ");
INSERT INTO vgr_vpl VALUES ("C13_1","076_3_1","1CO","3","1","1","భైయ్యె, భేనె ఆత్మసంబంధంహుయ్తె అద్మియేతి వాతె బోలతిమ్‍ మే తుమారేతి వాతెబోలన కోహుయూని. ఆంగ్తాన్‍ సంబందహుయుతె అద్మిస్‍కరి, క్రీస్తుకన అఢ్డాని లడ్కనితరా, కరి తుమారేతి వాతె బోలంతరహుయు. ");
INSERT INTO vgr_vpl VALUES ("C13_2","076_3_2","1CO","3","2","2","తెదెమా తుమ్నా కువ్వత్‍ నాపూరిజావమా దూధ్‍తీస్‍ తుమ్నా పాల్యొ పన్కి, ఖానుతి తుమ్నా పాల్యొకొయిని. తుమె హంకెబీ ఆంగ్ను సంబంధంహుయిన్‍ రవ్వానబారెమా హంకెబీ తుమె కంజోర్‍హుయిన్‍ ఛా కాహేనా? ");
INSERT INTO vgr_vpl VALUES ("C13_3","076_3_3","1CO","3","3","3","తుమారమా ఖీజ్‍బి జగఢాబి రవ్వమా తుమె ఆంగ్తాన్‍ను సంబంధంహుయూతె అద్మినుజోడ్మా ఛాలవాల కాహెనా? ");
INSERT INTO vgr_vpl VALUES ("C13_4","076_3_4","1CO","3","4","4","ఏక్జనొ “మే పౌల్‍వాలొ” కరి, బుజేక్జనొ “మే అపొల్లోవాలో” కరి బోల్యాతెదె తుమె ప్రకృతి సంబంధహుయు అద్మియే కాహెనా? ");
INSERT INTO vgr_vpl VALUES ("C13_5","076_3_5","1CO","3","5","5","అపొల్లో కోన్‍? పౌల్‍ కోన్‍? ప్రచార్‍కరవాలస్‍ కాహెనా? ఏక్‍యేక్‍ జనణా ప్రభు దీరాక్యొతె ప్రకార్‍ ఇవ్నా బన్తీ తుమె విష్వాస్‍ కర్యథా. ");
INSERT INTO vgr_vpl VALUES ("C13_6","076_3_6","1CO","3","6","6","మే గాఢ్యొతొ, అపొల్లో పాని నాక్యు, భడాయోతె దేవస్‍. ");
INSERT INTO vgr_vpl VALUES ("C13_7","076_3_7","1CO","3","7","7","అనటేకె బఢావాళో, దేవ్‍మస్‍ పన్కి, గాఢవాలమాతోబి పానినాఖవాలమాతోబి కాయ్‍బికొయిని ఇవ్నె ‍ఎక్కస్‍. ");
INSERT INTO vgr_vpl VALUES ("C13_8","076_3_8","1CO","3","8","8","హర్యేక్‍ జనూ యో కర్యొతె కామ్‍ పట్టీన్‍ జీతంనా లీలేస్‍. ");
INSERT INTO vgr_vpl VALUES ("C13_9","076_3_9","1CO","3","9","9","హమే దేవ్ను జోడ్మా కామ్‍కరవాలహుయీన్‍ ఛియ్యే తుమె దేవ్ను ఖేతర్‍వాడనబీ దేవ్ను ఘర్‍హుయిన్‍ ఛా. ");
INSERT INTO vgr_vpl VALUES ("C13_10","076_3_10","1CO","3","10","10","దేవ్‍ మన దీరాక్యొతె కృపచొప్పన మే నేర్పరిహుయితె షిల్పకారుల్‍ఘోని బేస్‍నా నాక్యొథొ, బుజేక్‍జనో ఇనప్పర్‍ బాందుకరస్‍. హర్యేక్‍జను ఇనఫర్‍ కింమ్‍ బాందుకరస్కి జాతన్తి దేఖిలేను. ");
INSERT INTO vgr_vpl VALUES ("C13_11","076_3_11","1CO","3","11","11","నాక్యురాక్యుతె తప్ప, జుజేక్‍ బేస్‍నా కోన్బి నాక్చెకొయిని ఆ పునాది యేసుక్రీస్తుస్‍. ");
INSERT INTO vgr_vpl VALUES ("C13_12","076_3_12","1CO","3","12","12","కోన్బి ఆ బేస్‍నుప్పర్‍ ఘేణు, రూపు, మోల్ను ఫత్రా, గుంజా, గాహ్ః, ఖూకైయియుతే గాహ్ః, థోడుబోత్‍తి బాంద్యతొ, ");
INSERT INTO vgr_vpl VALUES ("C13_13","076_3_13","1CO","3","13","13","ఇవ్ను ఇవ్నూ కామ్‍ దెక్కావ్‍సే, యోధన్‍ యో హాఃరు తేటపర్చే, యో ఆగ్తీ బాధర్‍పడిజాసే, బుజు ఇను ఇనూ కామ్‍ బట్టీన్‍ ఆగాస్‍ పరీక్చకర్సె. ");
INSERT INTO vgr_vpl VALUES ("C13_14","076_3_14","1CO","3","14","14","బేస్నా ఉప్పర్‍ ఏక్జను బాంద్యొతె కామ్‍ ఉబ్రిగుతో యో జీతంనా లీలిసె. ");
INSERT INTO vgr_vpl VALUES ("C13_15","076_3_15","1CO","3","15","15","ఏక్ను కామ్‍ బల్లాక్యుతో తెదె ఇన నష్టమ్‍ హుసె ఇను ఇనతోడి బచ్చిజాసె పన్కి ఆగ్మతూ చుక్కాయిగయోతిమ్‍ బచ్చిజాసె. ");
INSERT INTO vgr_vpl VALUES ("C13_16","076_3_16","1CO","3","16","16","తుమె దేవ్ని ఆలయంహుయిన్‍ ఛా కరి, దేవ్ను ఆత్మ తుమారమా జింకరస్‍కరి తుమె మాలంకరకొయిన్నా? ");
INSERT INTO vgr_vpl VALUES ("C13_17","076_3_17","1CO","3","17","17","కోన్బి దేవ్ను ఆలయంనా ఖర్రాబ్‍ కర్యతొ దేవ్‍ ఇన ఖర్రాబ్‍ కర్సె. దేవ్ను ఆలయమ్‍ పరిసుద్ధహుయిన్‍ ఛా; తుమె యో ఆలయంహుయిన్‍ ఛా. ");
INSERT INTO vgr_vpl VALUES ("C13_18","076_3_18","1CO","3","18","18","కోన్బి ఇనూయోస్‍ మోసం నా కర్లేను. తుమారమ కోన్బి ఆ ములక్‍ఫర్‍ యో జ్ఞానికరి రైగుతో, జ్ఞాని హువతిమ్‍ ఫాగల్‍వాలొ హోను. ");
INSERT INTO vgr_vpl VALUES ("C13_19","076_3_19","1CO","3","19","19","ఆ ములక్‍ను జ్ఞానం దేవ్ను డోళమా ఫాగలస్‍. ");
INSERT INTO vgr_vpl VALUES ("C13_20","076_3_20","1CO","3","20","20","జ్ఞానుల్‍ను ఇవ్ను కుయుక్తిమా యో దర్లిసె బుజు జ్ఞానుల్ను హఃయలే ఫాల్తుస్‍కరి ప్రభువ్న మాలంహువస్‍కరి లిఖ్కాయిన్‍ ఛా. ");
INSERT INTO vgr_vpl VALUES ("C13_21","076_3_21","1CO","3","21","21","అనటేకె కోన్బి అద్మియేనా హాఃమె బడ్డాయ్‍నామార్ను; సమస్తమ్‍ను హాఃరు తుమారూస్‍. ");
INSERT INTO vgr_vpl VALUES ("C13_22","076_3_22","1CO","3","22","22","పౌల్‍హుయోతోబి, అపొల్లోహుయోతోబి, కేఫాహుయోతోబి, ములక్‍ను హుయోతోబి, జాన్‍హుయ్‍తోబి, మరణ్‍హుయ్‍తోబి, హంకెఛాతె హుయుతోబి, అగాఢిఛాతె హుయుతోబి, ఆవ్సెతెహుయుతోబి సమస్తమ్‍హాఃరు తుమారూస్‍. ");
INSERT INTO vgr_vpl VALUES ("C13_23","076_3_23","1CO","3","23","23","తుమె క్రీస్తువాల, క్రీస్తు దేవ్నొ వాలొ. ");
INSERT INTO vgr_vpl VALUES ("C14_1","076_4_1","1CO","4","1","1","అమ్నితరా క్రీస్తును సేవకరవాలకరి, దేవ్ను మర్మాల్ను విషయంమా ఘర్నుమాలిక్‍కరి హర్యేక్‍ అద్మియే హమ్న మాలంకర్ను. ");
INSERT INTO vgr_vpl VALUES ("C14_2","076_4_2","1CO","4","2","2","బుజు ఘర్నుకామ్ కరవాలు హర్యేక్‍జనూబి నమ్మకంతి రవ్వాను జరూర్‍ ఛా. ");
INSERT INTO vgr_vpl VALUES ("C14_3","076_4_3","1CO","4","3","3","తుమె గాని, అలాదన గాని మన న్యావ్‍కరను ఘను న్హాణు విషయం, మన మేస్‍ విమర్సన కర్లీస్‍కొయిని. ");
INSERT INTO vgr_vpl VALUES ("C14_4","076_4_4","1CO","4","4","4","మారమ మన కెహూ దోష్‌ దెఖ్కావాకొయిని; హుయుతోబి అనహాఃజె నీతిమంతునిఘోని ఎంచబడీస్‍కొయిని, మన విమర్సన కరవాలొ ప్రభుస్‍. ");
INSERT INTO vgr_vpl VALUES ("C14_5","076_4_5","1CO","4","5","5","అనటేకె వహఃత్‍ ఆవను అగాఢీస్‍, కతొ ప్రభూ ఆవతోడి, కినా గూర్చిన్‍బి న్యావ్‍ తీర్చొనొకొ. యో అంధకారంమా ఛాతె రహస్యంనా ఉజాళుమాలాయిన్‍ దిల్‍మను మ్హైను హఃయల్‍లేవ్నా బాధర్‍నాక్యొతెదె, హర్యేక్‍జననా బట్టీన్‍ గౌరవమ్‍ దేవ్‍కంతు హుసె. ");
INSERT INTO vgr_vpl VALUES ("C14_6","076_4_6","1CO","4","6","6","భైయ్యే బ్హేనె, తుమె హమ్న దేఖిన్‍, లేఖనాల్‍మా లిఖ్కాయిన్‍చ్చాతె సంగతుల్‍నా నాఅతిక్రమించ్నుకరి సిఖిజైన్‍, తుమె యేక్నుబాజుమా అజేక్నునుప్పర్‍ భడాయ్‍నామార్నుతిమ్‍, ఆ వాతెన తుమారహాఃజె మారప్పర్‍బి అపొల్లోనానుప్పర్‍ బెందిలీన్‍ ఉదహారణ్‍తి బోలిరాక్యోస్‍. ");
INSERT INTO vgr_vpl VALUES ("C14_7","076_4_7","1CO","4","7","7","సానకతొ కోణ్ తునా అధికారింతరా కర్యొ? తున కల్గితె ఇన్మా దేవ్ తునా దిదొకొయిన్నా? పొంది రహీన్‍బి పొందకొయినీతింమ్‍ తూ బడ్డాయిహువను షాన? ");
INSERT INTO vgr_vpl VALUES ("C14_8","076_4_8","1CO","4","8","8","హంకెతోడిస్‍ తుమ్న సాత్బి కంకొయినితిమ్‍ తృప్తిహుయిన్‍ ఛానా? హంకెతోడిస్‍ దవ్లత్‍వాలహుయనా? హమ్నా బెందీన్‍ తుమె రాజనితరా ఛానా? ఓహో, హమేబి తుమారకేడె రాజహువతిమ్‍ తుమె రాజహువనూ హమ్నా ఖుషీస్‍ కాహెనా? ");
INSERT INTO vgr_vpl VALUES ("C14_9","076_4_9","1CO","4","9","9","మరణ్‍ను దండ్‍నా నఖ్కాయతిమ్‍ ఛియ్యేకరి దేవ్‍ అపొస్తలుహుయతె హమ్నా హాఃరవ్‍తీబి పాస్సల్‍ రాక్యోస్‍కరి హమ్నా సొచ్ఛాంకరస్. హమే ములక్‍నబి, దేవదూతల్‍లబి, అద్మియేనా హాఃమె తమాషానితరా హుయ్‍గయా. ");
INSERT INTO vgr_vpl VALUES ("C14_10","076_4_10","1CO","4","10","10","హమె క్రీస్తునటేకె దివ్వాణ, దేవ్ను సహవాసంమా తుమె క్రీస్తుమా అఖ్కల్‍వాల, హమె కంజోర్‍వాల, తుమె తాఖత్‍వాల; తుమె మహాన్‍వాల, హమె ఘనహీనుల్‍. ");
INSERT INTO vgr_vpl VALUES ("C14_11","076_4_11","1CO","4","11","11","ఆ వహఃత్‍తోడి హమె భుక్‍తి థరహ్ఃతి రయ్యాహుయా థా, ఫాట్యులుంగ్డతి; ముట్టినమార్‍ ఖంకురియస్‍; జివ్వాన జొగొబి కొయినితిమ్‍ ఛియ్యే. ");
INSERT INTO vgr_vpl VALUES ("C14_12","076_4_12","1CO","4","12","12","హామరా హాతెహూః మిన్హత్‍ కరీన్ కామ్‍ కరిలెంకరియేస్‍; అద్మియే హమ్నా నిందించుతె హారేక్‍ చోట్బి దీవించుకరియేస్‍, కెత్రు బాధల్‍ బెంద్యుతోబి హఃమాలిలెంకరియేస్‍. ");
INSERT INTO vgr_vpl VALUES ("C14_13","076_4_13","1CO","4","13","13","హమ్నా గాళెదిదుతోబి ఇవ్నెతి అష్యల్తి వాతె బోలుకరియేస్‍, హంకెబి హమ్నా హాఃరుజను ఆ ములక్‍మా ఫేకిదిదూతె కచ్రొను దిబ్బోనితరా సోచిలెంకరియేస్‍. ");
INSERT INTO vgr_vpl VALUES ("C14_14","076_4_14","1CO","4","14","14","మే ఆవాతె లిఖ్కుకరాతె, తుమే మార లాఢ్‍నా లడ్కరి తుమ్నా అక్కల్ బోలనటేకెస్‍ పన్కి షరమ్ కాడనటేకె కాహె. ");
INSERT INTO vgr_vpl VALUES ("C14_15","076_4_15","1CO","4","15","15","సానకతొ క్రీస్తుమా తుమ్న బఛ్చావాల ధక్హ్ హాజార్‍ అద్మియే కాపలావాల ర్హయితోబి, భా ఎక్కస్‍, క్రీస్తు యేసును సువార్తనువలా మే తుమ్నా జణ్యొ, ");
INSERT INTO vgr_vpl VALUES ("C14_16","076_4_16","1CO","4","16","16","ఇనటేకె మన పోలిన్‍ చాలోకరి తుమ్నా బతిమాలుకరూస్‍. ");
INSERT INTO vgr_vpl VALUES ("C14_17","076_4_17","1CO","4","17","17","ఇనటేకె ప్రభువుమా మన లాఢ్‍నోబి నమ్మకంవాలో హుయోతె మారొ ఛియ్యో తిమోతినా తుమారకనా బోలిమోక్లొ. యో మే కేహు తరికామ జియ్యోకి హారెక్‍ జోగోమా, హారేక్‍ సంఘంమా సాత్‍ బోధించుకరుస్‍కి, ఇనా క్రీస్తుమా కేహు తరికమా చాలుకరుస్‍కీ, యో తుమ్నా హఃయాల్‍ కరవ్సె. ");
INSERT INTO vgr_vpl VALUES ("C14_18","076_4_18","1CO","4","18","18","మే తుమారకనా కోఆయిస్నికరి సోచిలీన్‍ థోడుజను బడ్డాయి మారుకరస్‍. ");
INSERT INTO vgr_vpl VALUES ("C14_19","076_4_19","1CO","4","19","19","ప్రభువును చిత్తంహుయితో ఎగ్గిస్‍ తుమారకనా ఆయిన్‍, బడ్డాయ్‍ మారుకరతె ఇవ్నా వాతెనా కాహే, ఇవ్ను తాఖత్‍ సాత్కి మాలంకరిస్‍. ");
INSERT INTO vgr_vpl VALUES ("C14_20","076_4_20","1CO","4","20","20","దేవ్ను రాజ్యమ్‍కతో వాతేతి కాహె, యో తాఖత్‍తీస్‍ ఛా. ");
INSERT INTO vgr_vpl VALUES ("C14_21","076_4_21","1CO","4","21","21","తుమే సాత్‍ హోను? తుమారకనా మే లాక్డితీ ఆవ్నుకీ? ఫ్యార్‍తీ కవ్లుహుయితే దిల్తీ ఆవ్నూ? ");
INSERT INTO vgr_vpl VALUES ("C15_1","076_5_1","1CO","5","1","1","తుమార ఇచ్మా జారత్వమ్‍ ఛా కరి హఃమ్‍జ్యా, తుమారమా ఏక్జణు ఇను భాని బావన్నా రాకిల్దో కాస్ని, యెజాత్ను వ్యభిచార్‍ యూదుల్‍ కాహెతెవాలమాబి హుయితోబి జర్గకొయిని. ");
INSERT INTO vgr_vpl VALUES ("C15_2","076_5_2","1CO","5","2","2","అమ్‍ ర్హయిన్బి తుమే బడ్డాయికరుకురాస్‍ పన్కి, తుమె కెత్రేబి దుఃఖపడిన్‍ ఆరంగ్ను కామ్‍ కరుతే ఇవ్నా తుమారమతూ కోకన్నాఖిదెవుంకరాని. ");
INSERT INTO vgr_vpl VALUES ("C15_3","076_5_3","1CO","5","3","3","మే ఆంగ్తాన్‍ను విషయంమా తుమారేతి దూర్‍ర్హయితోబి, ఆత్మవిషయంమా హఃమ్దే ర్హయిన్‍, తుమారకేడె ర్హావన్‍తరస్‍, అమ్‍ జోక్ను కామ్ కరవాలనా లీన్‍ న్యావ్‍ తీర్చిరాకోస్‍. ");
INSERT INTO vgr_vpl VALUES ("C15_4","076_5_4","1CO","5","4","4","కిమ్కతొ ప్రభూవుహుయోతె యేసునా ధనుమా ఇని ఆత్మ బచ్ఛిజావహఃర్కూ ఆంగ్తాన్‍నా నాష్‍హువనటేకె, ");
INSERT INTO vgr_vpl VALUES ("C15_5","076_5_5","1CO","5","5","5","అప్న ప్రభుహుయోతె యేసుక్రీస్తును నామ్‍తి తుమేబి, మార ఆత్మబి ప్రభూహుయోతె యేసుక్రీస్తు తాఖత్తి మలీన్‍ ఆయోతెదె, యో జోక్ను అద్మియేనా సైతాన్‍నా ధరాయ్‍దేను. ");
INSERT INTO vgr_vpl VALUES ("C15_6","076_5_6","1CO","5","6","6","తుమె గర్వంతి ముర్సిజావను అష్యల్ కాహె, ఖాటు ఆటో యో ధరాసు ర్హాయితోబి ఆటో హాఃరునా ఖాటు వాహ్ఃకరస్‍కరి తుమ్న మాలంకొయిన్నా? ");
INSERT INTO vgr_vpl VALUES ("C15_7","076_5_7","1CO","5","7","7","తుమే ఖాటుఆటొ కొయింతెవాల ఇనటేకె నవూ ముద్దొ హువనాటేకె యో జూను ఆటోన పేఖిదెవో, అత్రెస్‍ కాహెతిమ్‍ అప్న క్రీస్తుకరి పస్కాను మ్హేండను చెల్కు బలిహుయో. ");
INSERT INTO vgr_vpl VALUES ("C15_8","076_5_8","1CO","5","8","8","అనటేకె జూనుహుయూతె పొంగ్యు ఆటొతీబి హుయుతోబి దుర్మార్గత హుయుతోబి దుష్టత్వమ్‍తిహుయుతోబి ఖాటు ఆటొతీబి కాహెతిమ్‍, నిజాయితీబి, హాఃచికరి ఖాటు రోటను పండుగా కరియే. ");
INSERT INTO vgr_vpl VALUES ("C15_9","076_5_9","1CO","5","9","9","వ్యభిచార్‍ వాలవ్‍తి సహవాసం నొకొకరోకరి మార పత్రికమా తుమ్నా లిఖ్కిరాఖ్యొస్‍. ");
INSERT INTO vgr_vpl VALUES ("C15_10","076_5_10","1CO","5","10","10","మే అమ్‍ కోబోలుకరుస్ని తుమె ఆ ములక్ను అద్మియోతి మలీన్‍ నొకొర్హవొకరి కాహె; ఇంహుయితో తుమే ములక్‍మతూ నికిజానుపడ్సే కాహెనా? ");
INSERT INTO vgr_vpl VALUES ("C15_11","076_5_11","1CO","5","11","11","హంకెతొ భైయ్యేకరి బొలైలెవ్వాలు కోన్బిహొ, వ్యభిచారంతోబి, లోభితోబి, మూర్తియేనుపూజతోబి పూజ కరవాలుహో, పీకోఢినితరా, చోర్‍కరవాలుతరా హుయిన్‍ ర్హాయితో, ఇమ్‍ జోక్నుకేడె సహవాసంనా కరను ఇవ్నాకేడె మలీన్‍ ధాన్బి నాఖానుకరి తుమ్న లిఖ్కుకరూస్‍. ");
INSERT INTO vgr_vpl VALUES ("C15_12","076_5_12","1CO","5","12","12","సంఘంమా బాధర్‍ ఛాతే ఇవ్నా మే సాన న్యావ్‍ కర్ను? మహీ ర్హవ్వాలనా న్యావ్‍ కరావలా కాహేనా? ");
INSERT INTO vgr_vpl VALUES ("C15_13","076_5_13","1CO","5","13","13","తుమారమా మహీఛాతెవాలనా దేవస్‍ న్యావ్‍ కర్సె, అనటేకె యో దుష్టున్నా తుమారమతూ కన్నాకిదెవొకరి లేఖనంమా లిఖ్కాయ్‍రూస్‍. ");
INSERT INTO vgr_vpl VALUES ("C16_1","076_6_1","1CO","6","1","1","తుమారమా ఏక్నా బుజెక్నాఫర్‍ లడ్ఢాయహుయుతెదె ఇనహాఃమె కాహేతింమ్ పరిసుద్ధ యూదులు కాహెతె అద్మినా హాఃమె అవినీతి కర్సెనా? ");
INSERT INTO vgr_vpl VALUES ("C16_2","076_6_2","1CO","6","2","2","దేవ్నులఢ్కా ములక్నా న్యావ్‍ కర్సేకరి, తుమె మాలంకరకొయిన్నా? తుమారటేకె ఆ ములక్‍నా న్యావ్‍ కరను జరుగనూ ర్హావమా, ఘను న్హాను సంగతుల్‍నా గురించీన్‍ న్యావ్‍కరనా తుమ్న అధికార్‍ కొయిన్నా? ");
INSERT INTO vgr_vpl VALUES ("C16_3","076_6_3","1CO","6","3","3","అప్నె దేవ్ను దూతల్‍నా న్యావ్‍కర్సుకరి తుమె మాలంకరకొయిన్నా? ఆ జివ్నునూ సంబంధంహుయితే సంగతుల్నా గూర్చి అజు ముఖ్యాంతి న్యావ్‍ కరజైయి కొయిన్నా? ");
INSERT INTO vgr_vpl VALUES ("C16_4","076_6_4","1CO","6","4","4","అనహాఃజె ఆ జివ్నును సంబధహుయుతె లఢాయే తుమ్న హుయుతెదె సంగతులనా తీర్చనటేకె సంఘంమా దక్లాయ్‍గయూతె ఇనకనా బెహాఃఢి రాక్యస్‍ రాక్చున్నా? ");
INSERT INTO vgr_vpl VALUES ("C16_5","076_6_5","1CO","6","5","5","తుమ్న షరమ్‍ ఆవ్నుకరి అమ్‍ బోలుకరూస్‍. సాత్‍? ఇవ్నా భైయ్యేనా ఇచ్మా లఢాయేనా తీర్చవాలు, అఖ్కల్‍వాలు తుమారమా ఏక్జనుబి కొయిన్నా? ");
INSERT INTO vgr_vpl VALUES ("C16_6","076_6_6","1CO","6","6","6","కేవలం మారు సలహా మాత్రమాస్‍. పన్కి భైయ్యే భైయ్యేఫర్‍ లఢాయే కరూకరస్‍, అజు విష్వాసుల్‍ హాఃమె లఢాయేకరూకరాస్‍. ");
INSERT INTO vgr_vpl VALUES ("C16_7","076_6_7","1CO","6","7","7","ఏక్‍నాప్పర్‍ ఏక్ లఢాయకరను తుమారమా హంకేష్‍ హరిజంకరస్‍. ఇనేతీబి అన్యాయంనా హఃమాలను అఛ్చు కాహేనా? ఇనేతీబి తుమారు రాఛ్చున గమాయ్‍లేవను అఛ్చు కాహేనా? ");
INSERT INTO vgr_vpl VALUES ("C16_8","076_6_8","1CO","6","8","8","హుయుతొ తుమేస్‍ పార్లావ్నా అన్యాయంనా బోల్తాహుయీన్ చోర్‍ కర్తాహుయీన్‍, అన్యాయ‍మ్‍తి మోసం కరుకరష్, తుమారు భైయ్యేనాస్‍ అంనితర కరూకరష్‍. ");
INSERT INTO vgr_vpl VALUES ("C16_9","076_6_9","1CO","6","9","9","అన్యాయస్తుల్‍ దేవ్ను రాజ్యమ్‍నా వారసుల్‍ హుసేకొయినీకరి తుమ్నా మాలంకొయిన్నా? మోసం నొకొహుషు జారుల్‍హుయాతె, మూర్తియేనాపూజకరవాలు, ఖర్రాబ్‍హువాలు, వ్యభిచారుల్‍హుయుతె మరధ్మానవ్‍తీ, ");
INSERT INTO vgr_vpl VALUES ("C16_10","076_6_10","1CO","6","10","10","చొట్టహుయతె, లోభివాలు, పియ్యవాలు, గాలెదెవ్వాలు, లపాఢిలెవ్వాలు, దేవ్ను రాజ్యమ్‍నా అధికార్‍వాలొ హుసెకొయిని. ");
INSERT INTO vgr_vpl VALUES ("C16_11","076_6_11","1CO","6","11","11","తుమారమా థోడజను ఎజాత్నూస్‍ హుయ్రూస్‍ పన్కి, ప్రభుహుయోతె యేసుక్రీస్తును నామ్‍మా అప్నా దేవ్‍ను ఆత్మమాబి తుమె దొవ్వాయ్‍జైయిన్‍, పరిషుద్ధహువవాలహుయిన్‍, నీతిమంతునితరా హుయ. ");
INSERT INTO vgr_vpl VALUES ("C16_12","076_6_12","1CO","6","12","12","హాఃరంప్పర్‍బి మన అధికారంతి హుయురూస్‍, పన్కి మొత్తంబి కరనుహుయూతె కాహె. హాఃరవ్‍మబీ మన స్వాతంత్ర్యం హుయురూస్‍ పన్కి మే కినహాతే హూఃబి లోపరచబఢీస్‍ కొయినీ. ");
INSERT INTO vgr_vpl VALUES ("C16_13","076_6_13","1CO","6","13","13","ధాన్‍ ఖావనురాచు పేట్నటేకె బుజు పేట్‍ ధాన్‍ ఖావనటేకె నియమించి రాక్యోస్‍. దేవ్‍ అనబి ఇనా నాష్‍ కర్రాక్చె. ఆంగ్తాన్‍ జారత్వమ్‍ హాఃజెకాహె పన్కి, ప్రభువు నిమిత్తమాస్‍ ప్రభును ఆంగ్తాన్‍నా నిమిత్తమాస్‍ ");
INSERT INTO vgr_vpl VALUES ("C16_14","076_6_14","1CO","6","14","14","దేవ్‍ ప్రభువునా మరణ్‍మతూ ఉట్టాడ్యొ అప్నబి ఇను తాఖత్తీ ఉట్టాడ్చె. ");
INSERT INTO vgr_vpl VALUES ("C16_15","076_6_15","1CO","6","15","15","తుమారు ఆంగ్తాన్‍ క్రీస్తుమా భాగ్‍హుయిన్‍ ఛా కరి తుమ్న మాలంకొయిన్నా? మే క్రీస్తునూ ఆంగ్తాన్నూ భాగ్‍ హాడ్డక్యాన లీలిన్‍ వేష్యయనితర అవయంగోని కరిస్‍న్నా? యోకెత్రె మాత్రంబి హుసెకొయిని. ");
INSERT INTO vgr_vpl VALUES ("C16_16","076_6_16","1CO","6","16","16","వ్యభిచారి మలిజావ్వాలు ఇనేతి ఏక్ ఆంగ్తాన్‍ ఛాకరి తుమ్న మాలంకొయినా? ఇవ్నే బేజ్నా ఏక్ ఆంగ్తాన్‌ హుయిన్ ర్హాసెకరి బోలుకరాస్‍ని? ");
INSERT INTO vgr_vpl VALUES ("C16_17","076_6_17","1CO","6","17","17","ఇంనితరాస్ ప్రభూవుమా మలిజవ్వాలు ఇనేతి ఏక్‍ ఆత్మ హుయిన్‍ ఛా ");
INSERT INTO vgr_vpl VALUES ("C16_18","076_6_18","1CO","6","18","18","జారత్వమ్‍తి దూర్‍ మిలైదెవో, అద్మియే కరతే హరేక్‍ పాప్‍నా ఆంగ్తాన్‍నా మహీ ఛా పన్కి జారత్వమ్‍ కరతే హరేక్‍ అద్మి ఇను ఆంగ్తాన్ విరోధంతి పాపం కరూకరస్. ");
INSERT INTO vgr_vpl VALUES ("C16_19","076_6_19","1CO","6","19","19","తుమారు ఆంగ్తాన్‍ దేవ్ను బారెమా తుమ్నా దేవ్వాయిరూస్‍, తుమె పరిసుద్ధాత్మనా ఆలయమ్‍ హుయిన్‍ ఛ్చాకరి తుమ్న మాలంకోయిన్‍నా? తుమారఫర్‍ తుమ్నా హక్కు కొయని, ");
INSERT INTO vgr_vpl VALUES ("C16_20","076_6_20","1CO","6","20","20","తుమ్న మోల్‍ నాఖీన్‍ లిరాక్యోస్‍, ఇనాటెకే తుమారు ఆంగ్తాన్‍తీ దేవ్‍నా మహిమా పర్చొ. ");
INSERT INTO vgr_vpl VALUES ("C17_1","076_7_1","1CO","7","1","1","తుమె లిఖ్యతె ఇను విషయంమా మరద్మానో బాయికవ్నా ఛీమకొయినితిమ్‍ ర్హావను అష్యలస్‍, ");
INSERT INTO vgr_vpl VALUES ("C17_2","076_7_2","1CO","7","2","2","హుయుతోబి జారత్వమ్‍ హుంకరమా, హరేక్‍ మరద్మాననా హుఃద్నుబావన్ ర్హాను, హరేక్‍ బాయికోనా హుఃద్నుబావ్రి ర్హాను. ");
INSERT INTO vgr_vpl VALUES ("C17_3","076_7_3","1CO","7","3","3","బావ్రి బావన్నా, బావన్‍ బావ్రినా ఇవ్ను ఇవ్నూ ధర్మంనా చలావ్ను. ");
INSERT INTO vgr_vpl VALUES ("C17_4","076_7_4","1CO","7","4","4","బావ్రినాస్‍ పన్కి బావన్నా ఇను ఆంగ్తాన్ ఫర్‍ అధికారంకొయిని; ఇమ్మాస్‍ బావన్నాస్‍ పన్కి, బావ్రినా ఇను ఆంగ్తాన్‍ ఫర్‍ అధికరం కొయిని. ");
INSERT INTO vgr_vpl VALUES ("C17_5","076_7_5","1CO","7","5","5","ప్రార్థనకరనటేకె వీల్‍హువనా థోడు ధన్‍లగు బే జనాను ఒప్పి ర్హయితోస్‍ పన్కి, ఇవ్నా ఇచ్మా ఏక్ను యేక్‍ నాబెందేను తుమే దిల్నా నావుభారి రాఖితొతెదె సైతాన్‍ తుమ్నా నాసోధించునుతిమ్‍ పాచు ఫరీన్‍ మళిజవో. ");
INSERT INTO vgr_vpl VALUES ("C17_6","076_7_6","1CO","7","6","6","ఆ మారు సలహా మాత్రమాస్ పన్కి ఆజ్ఞ కాహె; ");
INSERT INTO vgr_vpl VALUES ("C17_7","076_7_7","1CO","7","7","7","అద్మియే హాఃరు మారిన్‍తరస్ ర్హానుకరి కోరిలెవుంకరుస్‍; హుయుతోబి ఏక్జను ఏక్ రకంనితరా బుజేక్‍ జణు అజేక్‍ రకంనితరా, హర్యేక్‍ అద్మిబి ఇనఛ్చాతె కృపావరంనా దేవ్నకంతూ పొందిరాక్యోస్‍. ");
INSERT INTO vgr_vpl VALUES ("C17_8","076_7_8","1CO","7","8","8","మారింతరస్‍ ర్హావను ఇవ్నా అఛ్చుకరి య్హా హువకొయింతె ఇవ్నేతిహో, ముండ్డమోపితిహో, బోలుకరూస్‍. ");
INSERT INTO vgr_vpl VALUES ("C17_9","076_7_9","1CO","7","9","9","హుయుతొ దిల్నా ఉభార్కాడను నాహుయుతో ఇవ్నే య్హా కర్లేను. కామంతిరవ్వాను బదుల్‍ య్హా కర్లేవను అష్యల్. ");
INSERT INTO vgr_vpl VALUES ("C17_10","076_7_10","1CO","7","10","10","బుజు య్హాహుయుతె ఇవ్నా మే కాహె ప్రభువస్‍ ఆజ్ఞ దిరాక్యోస్‍ సాత్కతొ, బావణ్‍ బావ్రినాకంతూ అలాదునాహోను. ");
INSERT INTO vgr_vpl VALUES ("C17_11","076_7_11