﻿USE sofia;
DROP TABLE IF EXISTS sofia.var_vpl;
CREATE TABLE var_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES var_vpl WRITE;
INSERT INTO var_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Kúíraa. Neee Maateo tewaniamea, piiripi puuu Eesusi Riosie Weratiamee weratiamepua tiame, oosa mariki aampa ooka Eesusi ajawaria ahjama. I'wa iyotemane Eesusi Riosie Weratiameo, aatana ehkoriami tetejimarisichi o'inia eenamekopua, aatia tiiachipa puuua Auranitaru tetejimarikopua Raawitaru tiame, ehkoriami mochiriame ti'tijoerichiopua. O'inemane i'ka iyosi aamowichio. ");
INSERT INTO var_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Ehkoriami Aurania Ihsa noonora eneriaipua; Ihsaa, Aakowo noonora; Aakowoa, Uura noonora enerepua poponirama. ");
INSERT INTO var_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Uuraa, Paaresi noonora enerepua Saara tiame. Yeeyera ihji ooka tatanao, Taamara tewaniame enerepua; Paaresia, Ehroni noonora enerepua; Ihji Ehronia, Aarami noonora enerepua; ");
INSERT INTO var_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aaramia, Aaminawa noonora enerepua; ihji Aaminawaa, Naasoni noonora enerepua; Naasonia, Saromoni noonora enerepua; ");
INSERT INTO var_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Saromonia, Wooosi noonora enerepua, yeeyeraa Raaja tewaniame. Ihji Wooosi tewaniamea, Ooweri noonora enerepua, yeeyeraa Ruuti tewaniame; Ooweria, Isai noonora enerepua; ");
INSERT INTO var_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Ihji Isai tewaniamea, Raawi noonora enerepua, yawichi enekame; puuu yawichi Raawia, Saromoni noonora enerepua, ihji Saromoni yeeyeraa, Uuria uupira enekame; ");
INSERT INTO var_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Saromonia, Roowoami noonora enerepua; Roowoamia, Aawiasi noonora enerepua; Aawiasia, Aasa noonora enerepua; ");
INSERT INTO var_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Aasa tewaniamea, Osaja noonora enerepua; Osajaa, Oorami noonora enerepua; Ooramia, Uusia noonora enerepua; ");
INSERT INTO var_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uusiaa, Ootami noonora enerepua; Ootamia, Aakasi noonora enerepua; Aakasia, Esekia tewaniame noonora enerepua. ");
INSERT INTO var_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Esekiaa, Manase noonora enerepua; Manasea, Aamoni noonora enerepua; Aamonia, Oosia noonora enerepua; ");
INSERT INTO var_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Oosiaa, Eekonia noonora enerepua poponirama, isaeri ti'tijoeri Wawironia i'tonioiopua, chapisa i'totiame tiame. ");
INSERT INTO var_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Neipa Wawironia e'enatioio, Eekoniaa, Saratieri noonora enerepua; Saratieria, Soorowaweri noonora enerepua. ");
INSERT INTO var_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Soorowaweria, Aawiu noonora enerepua; Aawiu tewaniamea, Eriakími noonora enerepua; Eriakímia, Aasori noonora enerepua. ");
INSERT INTO var_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Aasoria, Sooroki noonora enerepua; Soorokia, Aakimi noonora enerepua; Aakimia, Eeriuu noonora enerepua. ");
INSERT INTO var_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eeriuu tewaniamea, Riasari noonora enerepua; Riasaria, Maatani noonora enerepua; Maatania, Aakowo noonora enerepua; ");
INSERT INTO var_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Aakowoa, Oose noonora enerepua, Maaria kuunara enekame, Eesusi yeeyera. Ihji Eesusipu puuua taamoo, Riosie Weratiameko tuuyaa. ");
INSERT INTO var_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Ihji tetejimarira muuwekamea, oosa mariki aampa naao sesenerichi u'matokamepua, ahkasi Auranitaru o'iniao, Raawitarusiopua; Raawitaru o'iniaoi, wa'achi kehki seseneri u'matorepua, ahkasi Wawironia taawechiopua, i'isaeri ti'tijoerio Wawironia i'totioiopua; Wawironia o'iniao, wa'achi kehki seseneri u'matorepua, ahkasi Eesusi Riosie Weratiame naawariachisiopua tiame. ");
INSERT INTO var_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Ehpeo neeea, Eesusi naawariachi simiyame aamo nayewemania, achini teereriopua i'wa weeechio. Ihji Eesusi yeeyera Oose ahjama neewimerioio, Riosi utewarie peteterepatetiamepua. ");
INSERT INTO var_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Ihji Oose Maaria ahjama neewimeriaa, ki se'wika kaawerumakapaopua, ki suuwe erapatenariapaopua Maariao, ki aawata nane'rejererepua achini teeka peteterepariaopua pu'kao. Pukaepa ihchi poanatamo o'rariaipua, apoeche nane'reka. ");
INSERT INTO var_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Nape i'ka Oose wa'a e'raka oiyoio Riosi ku'iwaria, kochirewachi chaanerepua pu'kao: —Ooséee, Raawi tetejimarichi eename, ka'te suuwe eramitia muuua, Maaria ahjama neewikao. Ihji Maaria petetepariaa, Riosi Riosiwarie wa'a e'rariae iikamepua. ");
INSERT INTO var_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Pukaepa muuua i'ka Maaria sausoopua, i'ka temari naawakameo, Eesusi tewameri eemea ti'tijoeo ooweruopua tiameo, tatakoritiamewichio kokosapuame, newipatemerikoopua. ");
INSERT INTO var_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Yooma ihji wa'a ikipuamea, ehkoriami o'inia Riosi cheeriapua, ahpo nayewaturachiopua, eee cheeriaeopua: ");
INSERT INTO var_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Weemera kutewea, peteterepameripua; ihji peteterepasaapua, temari saumeripua. Ihji temaria, Emanuéri teewapuamepua. Ihji Emanuéri chaniwamea: Riosia taamo ahjamapua, cheeka chaniwamepua. ");
INSERT INTO var_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Wa'a chaanetiapa Oosea Riosi ku'iwarieo, pusasaapa, yooma wa'a teetorepua waikao, ahkasi Maaria ahjama ahpo neewiachisi. Oosea neewirepua neewiao Maaria ahjamao, ");
INSERT INTO var_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","nape ki noonoterepua pehjio ahpo uupichitiao, ahkasi neipami sauria yachapachisiopua. Waikaopua i'ka kuita naawasoopua Oosea, Eesusi teewarepua pu'kao. ");
INSERT INTO var_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Uurea weeechio, Eesusi Weereni mochiwachi naaoiopua, Eerore yawichi eneriaipua wa'ao waikamio. Waika taawechiamio, wa'a Eerusareni e'enarepua ookapi ti'tijoe cherayachitepa e'ename. Ihji ti'tijoea, te'ta machiwari pepeniame enerepua, itapiti so'porichi simiyame tísia i'yesika mochitoriame. ");
INSERT INTO var_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Ihjia wa'a mochiwachi e'enakao iinatukesirepua ti'tijoerio, chaachapaka: —¿Akatia naawariarepua kohja, Uurio yawichiwara enemeri? Teemea so'porichitia tajayame ne'netoka e'enakame teemea, cherayachisi o'iniaopua, ahkasi pu'ka so'porika tiiame kahtiachisi, i'wa kohja naawamiachiopua. Pukaepa i'wa e'nakame teemea iyorimia te'teretoapu teemea pu'ka kuitao, ahka naawariachio. ");
INSERT INTO var_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Waikao Eerore yawichia wa'a chaachapo tuuwame inamukapaopua mehka e'enakameo, wekana eraparepua kiisi kaawe e'rakao, muuwaeme Eeroreka erakoameai Eerusareni mochiwachio, wa'achi erakorepua tiame Eerorechitiao. ");
INSERT INTO var_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Wa'a erapakaopua Eerore yawichia, ahpo kahtiachi napawinasaapua, te'ta isaeri ne'neseriosio, pariseroopua tiame napawinurasaopua, cheeka iinatukerepua pu'kao: —¿Akatia naawameri ohjoarepu Riosie Weratiamea? ");
INSERT INTO var_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Waikao ne'neseriosi pa'pamiratuamea chaachaparepua: —Uurea weeechi naawameripua Weereni mochiwachi; wa'a cheeka nayewame Ehkoriami Iyoteria, Riosi nayewatura chaachapariaa. ");
INSERT INTO var_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","I'ka eee chaachapaka: Muuu Weereni mochiwachio, epeche nu'utirakaimua Uura weeechio ki wahjachi te'ta mochiwarichitiaopua, wa'a aamo mochiwachio wa'a naawamerikaitepua piiripi tijoe, epeche te'ta weruma tiiaemeopua ki aaatachitia, aaata puuua te'ta yawichi enemeriapua, yooma no'o ijinuwachio, isaeri ti'tijoechio. ");
INSERT INTO var_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Wa'a chaachapatiame nane'resaapaopua Eerorea, ihchi paaesapa pu'ka cherayachi e'enakameo, pu'ka iinatukeka nane'rerepua, achinitio o'inia machenariopua so'porio, cherayachi so'pori naaniatiwariopua. ");
INSERT INTO var_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Wa'a ikisaopua Eerorea, Weereni siimpanurerepua waikao, chaanesa: —Yooma aamo ye'kachisi i'yapuapua pu'kao, pu'ka kuita naawariachiopua. Tewisaapa eemea, no'o tuuyepuapua, wa'achi siminariame neeeai, ahjachi paparawemia. ");
INSERT INTO var_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Waikao cherayachitepa e'enakamea, Eerore cheeria inatatosika siimparepua. Waikao puuu so'pori cherayachisi o'inia tetewitoka na'naritosi e'enariaa, pu'ka wa'api so'pori ne'netosirepua Weereni ajasipuawichiopua. Waikaopua pu'ka so'pori na'naritokao, pu'ka kuita naawakame ta'perachi tahjepaka yasipakopaopua wa'asi, teewerepua ahpo wa'ami siimpao. ");
INSERT INTO var_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Waikaopua cherayachitepa e'enakamea, tísia kaawe erakorepua, kuita naawakame ohjirachi ajasitiopao. ");
INSERT INTO var_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Waikao wa'a karichi muisaopua yooreminao, wa'a kahtiame tetewarepua kuitao, ahpo yeeye Maaria tewaniame ahjama. Waikao cherayachitepa e'enakamea, chopokorieka ajapaka ki nu'uti iyorirepua pu'kao. Wa'a ikisaopua ahpo u'paria kaaja wahjonasaopua wa'a manitoame puuyanasaopua, Eesusi kuita ihkokerepua, itapiti tísia nateyáme, naatichitia: apoche o'ro, cho'imori, peeniajuri miira tiamé. ");
INSERT INTO var_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Waikao i'ka nonoraka nokisinioiopua, Riosi ku'iwaria kochirewachi nayewerepua pu'kao, eee chaaneka: —Ka'te uumatomitia eemea Eerore kahtiachiamio, pirenachi poowechiami uumitia ohso kaawe. Pukaepa puuua, piirechi pooechiami uumatorepua nonorakao. ");
INSERT INTO var_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Wa'a ikisaopua Riosi ku'iwaria, pu'ka te'ta ma'machiwari nonowasoopua, Oosepechi nayewerepua kochirewachio, puuua Ooseo chaanerepua: —¡Yaapi ihtakosa Ooséee! Ikanati werisika ujumamitiapua Eejito, wa'a i'toka ichipupamitiapua pu'ka kuitao yeeyera tiame. Wa'a ikisaapua, wa'a mochipuapua ku'itapi, ahkasi aamo no'o chaaniachisi eenechi, ahka aamo uumpamiachio. I'ka aamo chaanenania neeea, Eeroreo amori i'yasiamekopua pu'ka kuitao merinareka. ");
INSERT INTO var_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Waikao Oosea pu'ka tukawarichi wa'api machenarepua Eejitomio, pu'ka weeechi ichipupamiaopua kuita i'tokaopua tiame, yeeyerama. ");
INSERT INTO var_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Wa'a Eejitoo wa'a mochirepua ahkasi Eerore mukuyachisi. Ihji wa'a ikitiame ikitiamea, Riosi cheeria pichiwa machenaka teerere puuua, ehkoriami ahpo nayewaturachi cheeria. Apoe taamo Noono Paamiraa ehkoriamio, cheeriaipua: “Eejito o'inia paaenania no'o Taanao.” ");
INSERT INTO var_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Eerorea cherayachitepa e'enakameo tísia ahpo wisikuerioopua, tísia nekarepua waikao. Wa'a iikapa puuua yooma kukuchi ooka paamuameopua waanami, ko'inurerepua, yooma Weereni na'nawakameopua, wa'a norikame mochiwachiopua tiame, yooma pu'ka so'pori machenariachisi na'nawakameopua kukuchi, cherayachitepa e'enakame chaachapariaopua waika taawechi naawamio tuuka. ");
INSERT INTO var_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Ihji kukuchi ko'itiameai, Riosi chaaneriachitia ikitiamepua tiame, ehkoriami Eremia nayewariachitia, i'ka cheeriachitiao: ");
INSERT INTO var_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Wahka Raama tewaniachi roomosachio, aaata oowitime ki teesa kokosa e'raka naarachani, tísia yuuwesika. Ihji aaata naarachaniamea, Raakeri tewaniamepua ahpo tatanawichio tísia naarame. Ihjia kiisi teewenariame puuua naarakao, ki nu'uti kaawe erapateniai, ahpo tatana kiterepatekapa. ");
INSERT INTO var_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Neipa Eerore mukisoopua, Eejito kahtioiopua Ooseo pehjio, Riosi ku'iwaria eenechi nayewerepua Ooseo, kochirewachi. Puuua kochirewachio, chaanerepua: ");
INSERT INTO var_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","—Ehpeomua Oose, werisika Isaeri weeechi no'ramitiapua, puuua aamo taana merinariameapa, mukukamekopua wa'asio. ");
INSERT INTO var_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Waikao Oosea wa'a simirepua waikao, pu'ka kuita i'toka yeeyera tiame, Isaeri weeechi. ");
INSERT INTO var_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Nape Oosea Uurea weeechio, Arakerao tewaniame Eerore taanara yawichiko tuuopa wa'ao waikao, majawerepua pu'kaoiopua pehjio, wa'a ahpo ohjoremiaopua. Waikao Oosea eenechi kochirewachi tuuyetiapao Riosi ku'iwarieo, wa'ao ki kaawe teeremerikoopua wa'ao; ohso kaawe Arirea weeechikamera akiparepua no'rakao. ");
INSERT INTO var_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Waikaopua Arirea weeechi enasaopua, Nasare mochiwachi yasarepua waikao ohjoekao. Wa'a iika ihjia, ehkoriami Riosi nayewatura chaachapariachitia iintorepua. Ihjia eee chaachapariaipua: “Puuu Riosie Weratiame enameria, Nasare tijoe tewapuamepua.” ");
INSERT INTO var_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Pu'ka taawechiami Eesusi Nasare mochiwachi ohjoekoiopua, Waani ti'tijoeri Paatoamea Uurea weeechiami yaajatoriaipua, ki tijoeekachi. Wa'ami yasaka tuuwicharepua ti'tijoerio, Riosi tuuyewarichi simiyame. ");
INSERT INTO var_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Ihji Waania ti'tijoeri sisinawekao, eee cheerepua: —¡Yooma toaka mochitopuapua aamo ki ka'karuma yooraka mochikao, puuu aamo ki ka'karuma yoora cheriwemerio, ki mehka kahtioi tiiopua pu'kaopua wa'asi! Puuu Apoe aamo cheriwemeria, Apoe ihsimeripua aamo wahjonekao, ahpo ye'karichi muimichioo, ahpokamera ahjama teerepuawichiopua taamoo. ");
INSERT INTO var_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Waania wa'a cheeka nayewerepua wa'a chiiamekopa Ehkoriami Iyoterichiopua Isaiao, puuua eee cheeriaipua: Wahka mehka ki tijoeekachi siinachani aaata, puuua cheechaniamepua: “Eeme ti'tijoea ooweru tiamea Riosiwichioo, aamo iikachi wahjonamitia pooe; nape te'ta pichiwa cheeka, kiisiki kihta a'chi tiame inasokaopua amochio, itapiti a'chi tiameopua ki kaawerumao.” ");
INSERT INTO var_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Ihji Waani wisachucharaa, tumusari animari kuuparae netetiame eneriamepua; ihji wahsipuraraa, wi'chie netetiame eneriamepua. Ihji koayaa ohchi koaka yayasariamepua, se'ma se'ori kuhsitere iintuame tiame. ");
INSERT INTO var_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Eerusareni mochikame ti'tijoea, yooma Uurea weeechiami mochikameopua tiameo, Oorani akichiko ohjoemeapua tiame, Waani kahtiachi eejenapariaipua Waani keepumia. ");
INSERT INTO var_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Ihji Waania wa'a enapasoopua ahpo kahtiachi, i'kao ahpo tatakoriwa toimo erapasoopua Riosichi tuuka, Waania paapatosiriaipua pu'kao Oorani akichi, kaaweruma enepanariameopua taamo Noono Riosichio. ");
INSERT INTO var_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Nape seenepi simikameo Waania ki ookapi e'nariopa nanaarame ahpo paatoachio, parisero ti'tijoeo, saruseo ti'tijoeopua tiameo, chaanekapua pu'kao: —¡Eeme sayawe ti'tijoeri, itapiti ki ka'karuma masitiame, ¿ihtana yoramia e'enaka eemea i'wao, ti'tijoeri ahpo tatakori ma'chitachio Riosíchio, ahpo paatoka toimo tuuwachiopua tatakoririao? ¿Aatana aamo chaaneka aamoo, aamo newipamerikoopua Riosi kokosarichio, aamoo kiisi kaawe nokayameo? ");
INSERT INTO var_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Toipuapua pahchao aamo tatakorika mochikao, nape pichiwa toinarekaopua aamoo kiisi kaawe aamo nokayao. ");
INSERT INTO var_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Ki oowera aamo Aurani ojochiwarako erapuapua, aamokamera te'ta ka'karumako erakokaopua Riosichio. Aamoka te'tiame ojochiwa nakiyame enesaa Riosia, i'ka tehte i'wa maaniameoi Aurani tetejimara enepatemiipua. ");
INSERT INTO var_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Riosi kokosari tepuraraapa, nawachi meteka tehpunamerapua wa'asi yooma ki ka'karuma taakiameopua Riosiwichioo. Yooma aaata ki ka'karuma taakiameopua Riosiwichioo, na'ichi ipaka kosimerapua pu'kao. ");
INSERT INTO var_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Neeea yooma ahpo tatakoriwa toinariameo, neeroie paatoamepua paatoao, nape neipa eenamea ahpo Riosiwarie paatomeripua iikachio, neeea pu'kawichioo kihta nateyamepua. Puuu Apoe neipa eename paatoaa, te'ta piipari paatowa enemeripua; na'ie kosoka piipatiamechitiapua tatakorio. Pu'kao neeea kihta nateyamenia pukachio, pu'ka kaakaraoinia ki nateyamenia no'o na'sonemiao. ");
INSERT INTO var_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Puuu Apoe Paamiraraa wa'asi, ahpo sekachi makotoamepua wa'asi ahjae kasarapupuameopua tiirikoo. Kasarapusaapua tiirikoo katewemeripua pu'kao; nape pu'ka tiiriko moowaraopua na'ichi ipaka tajenatemeripua kosoka. Puuu ti'tijoeri ki ka'karuma ihpapapuachio, kiisi choipame na'ichi ihpapapuamepua. ");
INSERT INTO var_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Senepi simikame Waanio paatoka ihsioio Oorani akichio, wa'achi eenariai Eesusiai Arirea o'iniaopua, ahpo paatopuawichioopua. ");
INSERT INTO var_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Nape Waania Eesusio ki paatonariaipua pu'kao, ki nu'uti tiiamekopa Eesusio apochio. Pukaepa chaanekaipua Eesusio: —¿Nape neee? Muuukamera no'o paatometepua. ¿Aatia neeekamera aamo paatotapua? ");
INSERT INTO var_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Nape Eesusia chaanekapua pu'kao: —Eje'e, wa'atepua tiiao, nape wa'atioi no'o paatopuapua, ti'tijoerio nane'remichiopua Riosie no'o weraniamekopua. ");
INSERT INTO var_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Eesusio paatotiache neerochi machenoiopua, te'pa tewekachio wahjoame tetewitiapua. Wa'a o'inia kooroka tiame tekikao, Eesusichi yasipakapua. Pu'kao, yooma teeme wa'a nokayame tetewikapua. ");
INSERT INTO var_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Pu'ka Eesusichi yasipasoopua tewekachi o'iniao, chiiame inamuretiapua tewekachi o'iniao: —Ihjipu no'o Taanaa, puuu te'ta no'o nakiyaa. Ihji puuua, te'ta tísia no'o kaawe e'riapua. ");
INSERT INTO var_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Riosi Riosiwari wa'a iintosaapua Eesusichio, mehka i'torepua ki tijoeekachi. Eesusi wa'a kahtioiopua ki tijoeekachio riaorósia, Eesusio aatia iintotarepua pu'kao. ");
INSERT INTO var_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Wa'a ki tijoeekachio Eesusia, ooka weerewa taawe yasarepua wa'ao, ooka weerewa tukawari tiame, kiisi koaka. Wa'a yasakaopua tísiwa toore aiwarepua. ");
INSERT INTO var_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Wa'a tiiopa Eesusio tísia chorowakao, riaorósia, kiisi kaawe iintotenariapapua Eesusio, chaanerepua: —Pichiwa Riosi Taanara enesaamua, paani enepatepuapua i'ka tehteo, ko'kopuapua ihsisa. ");
INSERT INTO var_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Wa'a chiiopa riaorósio Eesusia, chaanerepua: —Riosi Ehkoriami Iyoterichi chiiaa, chiiamepua: “Ki kooameche koaka ahjame ti'tijoeria, Riosi chiiacheeoiopua yoorekao, ahjaniamepua.” ");
INSERT INTO var_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Ehjepamio riaorósia Eerusareni u'parepua Eesusio, Eerusarenio Piipari Mochiwari teewataniachi upasaoi tiopachio, epeche te'pa weeriame tiopachi moenapusaopua, ");
INSERT INTO var_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","chaanerepua wa'a weerakao: —Pichiwa Riosi Taanara enesaa, aamo ihpaomua wa'atipoo, Riosia ahpo ku'iwarieo, aamo ku'ipameripua ka'chi ikimichioo —wa'a chiiamepua Riosi Ehkoriami Iyoterichio. Puuu wa'api Iyoteria chiiamepua tiameo: Riosia, ahpo ku'iwarie aamo panitomapua, ki wichipamichiopua pooechi motochikao. ");
INSERT INTO var_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Eesusia nehjiarepua pu'kao: —Nape Ehkoriami Iyoterichio chaanipua tiameo: “Aamo Riosiwao, ka'te aatiatamua utewarirao.” ");
INSERT INTO var_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Neipa wa'asiopua riaorósia, kai waapi weeriamechi kawijampa i'torepua Eesusio, wa'a werakaopua yomatiame ma'chiachiopua weeechi yawichiwachiamio, ");
INSERT INTO var_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","chaanerepua ne'netekao: —Nee. Yooma i'ka ye'kari aamo tetewao, yooma aamowichio teerepamania pu'kao, no'okamera yooresoopua chopokorieka. ");
INSERT INTO var_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Nape Eesusia wa'a chiiopa Satanasio, chaanerepua: —Se'wisa muuua noochio. Mehka akipaka muuua ki noochi. Kiisi ahjachi chiiamemua, oowera tísia se'wi chiiamemua. Riosi Iyoteri chiia eeekamera chiiamepua: “Muuua aamo Riosikamera iyorimitiapua, Apoe aamo Paamirakamera. Pu'kakamera yorakeka yasitopuapua kiisi teesaoi se'wika.” ");
INSERT INTO var_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Wa'a chaanetiapa riaorósia, toarepua waikao. Eesusi toisoopua riaorósio, Riosi ku'iwaripechi wa'a e'enarepua, Eesusi itapiti ku'ipuame nakisoo ku'ipamia. ");
INSERT INTO var_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Eesusia Waani karichi yachatiame inamukaopua, Arirea weeechi no'rariapua eenechi, Nasare mochiwachi. ");
INSERT INTO var_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Nape wa'a Nasare mochiwachio ki itipirepua wa'ao, ohso kaawe Kapenaukamera akipariapua, ohjoremia. Kapenau tewaniachio, kawiyamina Arirea weruma neeroi maaniachi suuwerachi enerepua, Sauroni tetejimara weewarachi enerepua, Nehtari tetejimara weewarachi tiame. ");
INSERT INTO var_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Wa'a iintotiamea Eesusieo, Isaia iyoteriaa tísia pichiwa machenarepua, puuu cheeriaopua tiame: ");
INSERT INTO var_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Wa'a Sauroni tetejimari weewarachio Nehtari tetejimari weewarachi tiameo, Oorani akichi o'inia ahkasi kawiyamina Arirea pa'we suuwerachisi enerepua. ");
INSERT INTO var_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Wa'a mochikamea tísia tukapachi mochikme eneriaipua, ki nu'uti tukapachi ahpo te'teriame: nape aaata wa'a eenakaopua taajenachi te'terepaterepua, kaaweruma uutapachi iintaparepua iikachio. Puuua wa'a te'terekao wahjiparichi mochikame eneriaipua ahjaio. Nape aaata apochi eenakopaopua, ma'chireparepua ahpochi iikachio. Ihji aaataa, Eesusi wa'a iintoriaa nayewamepua, Isaia ehkoriami cheeria ahpo iyoterichi. ");
INSERT INTO var_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Eesusia wa'a o'inia o'inesirepua Riosi kaaweruma tuuyewari chiia nayewatusikao. Puuua eee cheeka nayewesirepua ti'tijoeriopua ooweruriopua tiame: —Yooma toaka mochitopuapua aamo kiisi ka'karuma nokayao; ohso kaawe eemea, Riosi kaaweruma chiiakamera na'naritopuapua, puuu Riosi ye'karichi muijerameo, aamo ohjoekachi eenariamekopua wa'asi. ");
INSERT INTO var_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Piie taawechi Arirea pa'wesuweko ihtoai Eesusia, ooka aaata ahpo poponieme tewarepua sochichaira neerochi ihpapame, puuua so'chi chapiwa tekipaname eneriaipua. Piiripi puuua Siimoni Peero tewaniame enerepua, piirea Anteresi, wa'api puuu poonira. ");
INSERT INTO var_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Eesusia wa'a tetewakapao, pu'kao chaanerepua: —¡Nahpe no'o ahjama, ti'tijoeri Riosichi paajutiame enetai, Riosiwichio so'chi upapamechitia! ");
INSERT INTO var_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Wa'a chaanetiapa puuua ikanati toisapua ahpo sochichaira, ahjama siimparepua. ");
INSERT INTO var_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Epeche waanakoopua tiameo, piirechi ooka tewarepua ahpo poponieme. Piiripi puuua Saantiao tewaniame enerepua, piirea Waani. Ihji ookaa Sewereo tatanara enerepua, ahpo noonoma nokayame so'chi ikuchaira koyacheka, pawekakerachi mochika. Pu'ka wa'a tewakapaopua Eesusia, paajutesirepua tiameo, ahpo ahjama ohjomichiopua. ");
INSERT INTO var_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Ihjia paajutetiaapa ikanati ahjama siimpariapua tiameo, wa'api pawekakerachi toisaopua ahpo noonoo. ");
INSERT INTO var_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Wa'a inisikaopua Eesusia, yooma Arirea mochiwachiami ohjotiapua isaeri ka'karichiami napawiwachi, masitekaopua, Riosi chiia ka'karuma tuuyewari, tuuyesika, Riosi ye'kariwachi simiyame nayewesikapua wa'ao. Yooma wa'amiopua, yooma ihta kokorewa yachapatesikapua tiame. ");
INSERT INTO var_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Wa'a inisiame inamukapaopua yooma ihta kokorewa yachapatekao, muuwaeme Nehtari weeechiamio, yomachi Siiria weeechiamiopua tiameo ti'tijoeri, wa'a e'enariapua yooma ihta kokoriame u'yepakaopua. Puuu muuwaeme kokoriame u'yepatiamea ti'tijoe ooweru tiame, reemo yahchame eneriapua, epiresi ko'koame te'teriame tiame, tu'tuikame kokoriame, ro'roji kokoriame, chookopakame kokoriame tiame. Yooma i'ka ko'koameopua Eesusia, sautekapua. ");
INSERT INTO var_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Wa'a teetochaniopa Eesusio, muuwaeme Eesusichi paparariapua: Arirea ohjoeme, Eerusareni ohjoeme, Uurea weeechi ohjoeme, Reekapori weeechi mochikame, Oorani akichi cherayachimina ohjoeme tiame. ");
INSERT INTO var_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Seenepi simikame muuwaeme ti'tijoeri ahpo na'naritorioio Eesusia, teewi tekorata yasipakapua masitemiao. Waikao wa'a yasipakopa Eesusio masitemiao, ti'tijoeri pepenipanariamea Eesusi masitiao, waapi eenepakapua Eesusio. ");
INSERT INTO var_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Pu'ka muuwari waapi enepakoopa Eesusia, o'inekapua cheekao: ");
INSERT INTO var_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","—Aaata Riosichi tuukame ahpo tatakorio, tísia kaawe yorapuamepua Riosieo, cheriwepuamepua tatakoririao; puuu tatakori cheriwetiamea, iinuemeri puuua Riosi ye'karichi muipuameopua. ");
INSERT INTO var_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","’Aaata tatakoririapa tísia yuuwesiameopua, tísia kaawe yorapuamepua Riosieo, apoe Riosi iintomerikopua kaawe erapatekao, aaata pu'ka tatakoriria cheriwekaopua. ");
INSERT INTO var_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","’Tísia kaawe yorapuame Riosieopua tiameo, aaata ahpo iikachio tísia tesiwa e'raka ahpo uuyamea Riosichio, wa'a te'tiamekapa Riosichiopua puuukamera muimerikapapua Riosi ye'karichio, te'ta weemera weeeopua. ");
INSERT INTO var_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","’Tísia kaawe yorapuame Riosieopua, chorowa e'rameapua Riosichio tísia paramua e'rameapua tiameo, te'ta ahpo kaawe teeremiapa Riosichio; puuukamerakopua te'ta ahpo ta'iria yasitemeria. ");
INSERT INTO var_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","’Tísia kaawe yorapuame Riosieopua, aaata tísia kaawe tiiamea Riosichio, aaata te'ta tesiwa e'reka tetewame aaatao, aaata tesiwa e'reka tetewachitia aaata, wa'achitia tesiwa e'reka tetewipuamepua Riosieoi. ");
INSERT INTO var_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","’Tísia kaawe yorapuamepua Riosieo, te'ta piipatetiamea iikachi Riosi Riosiwarieo, puuukamerakapapua Riosichi ahpo ahjama tetewimeria. ");
INSERT INTO var_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","’Tísia kaawe yorapuame Riosieopua, Riosichi ahpo katewekamea, ta'iria mochipuawichio ku'ikamea, puuukamera Riosi tatanara tewapuamekapa. ");
INSERT INTO var_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","’Tísia kaawe yorapuamepua Riosieo, Riosi nakiya yoorapa na'ara yoraniamea, pu'kakamerawichiopu tewekachi ye'karia. ");
INSERT INTO var_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","’Tísia kaawe yorapuame Riosieopua na'ara chaaneniamea, aaata kihta yoorakai wenejiniamea, no'okamera na'naritoapaopua. ");
INSERT INTO var_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Yooma wa'a ikiwa aiwamea no'owichioo, kaawe erakomitia eemea aamowichio enemerikopa Riosi nuutiaopua tewekachio. Wa'achitia aiwateretiaipu ehkoriami Riosiwichio na'nayewatukameai. ");
INSERT INTO var_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Piirechi taawechiamio Eesusia, oona wa'achitari nayewakapua waikao, eee cheeka: —Eemea oonaka teeremetepua, i'ka weeechi mochikameo ta'iretiame. Nape ki oonachitia enesaa eemea, ka'chi iika ta'iretema eemea aaataoi, kihta oonaemekapa. Ihta oona ki onachari enepakameapa, kihtawichio kaawe enepamepua, ipaniame nahkipua kasarachio. Riosiai, aaata ki onacharipakamepua wa'asio, ipaka teteimapua pu'kao. ");
INSERT INTO var_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Piirechi taawechiamio Eesusia, chaanekapua ti'tijoerio: —Eemea tajayameka te'teremeripua, yooma ti'tijoea ooweru tiameai, i'ka weeechi mochikamewichioo, ti'tijoechiopua ooweruchiopua tiame. Aamo i'ka weeechi tajayaa kiisi noriwi teeremetepua, naapi tetewiwachiche teeremetepua, te'pa kawijampa o'inia tahjiamechitia yomachi mochiwario, ki wahjika tajayame tetewiniachiche. Wa'a te'tereka eemea, aaata te'pa kawijampa mochiwarika teeremeripua, ahkaoi o'inia teteiwame. ");
INSERT INTO var_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Aamo kaaweruma nokaya tajayaa ma'chiachiche te'teremetepua, yooma ti'tijoee tetewika mochipuawichiopua. Pukaepa itapiti tahjera uutapariai, aaataai ki noriwi weeramepua pu'kao ki weeresi uutapamichioo. Ohso kaawe te'pa weramapua pu'kao yooremina karichio, weeresi uutapamichiopua petechio. ");
INSERT INTO var_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Wa'achitia eemeai tahjerachitiao, yooma tetewachi tajitopuapua aamo kaaweruma yoorao. Aamo wa'a te'teretosoo chaachapama ti'tijoeria, wa'a te'tiame puuua ahpo Noono te'pa kahtiameo, iyorika mochitoapa. ");
INSERT INTO var_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Tajayame te'terewa nayewaka kajusaapa Eesusia, cheekapua waikao: —Ookapi aaata eeme i'isaeri pa'pamiratuamea, ehkoriami Moise nuurari Riosie kiaretia, no'o sa'runamio eenario tuuyamepua, pu'ka ehkoriami na'nayewatura masitiaopua tiameoi. Nape neeea ki wa'a iintomia eenakamenia, ohso kaawe neeea pu'ka Moise nuurario, te'ta utewatemia eenakamenia, ohsotia pu'ka ehkoriami Riosi na'nayewatura Riosie chaachapaka iyoteriaopua tiameo, te'ta pichiwatamia eenakamenia, pu'kakamera te'ta nateyameko tuumia. ");
INSERT INTO var_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Ihji no'o chiiaa kiisi wehchi wichimeripua. Yooma puuu Riosi iintomia ne'newaka chaachapatiamea, kiisi sewina chaachapapuamepua piiripi iyotichioi, piiripi chi'pichioiopua, ahkasi ki yooma ikiyachisiopua i'ka tuutiameo. ");
INSERT INTO var_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Pukaepa ki ahsieme e'waka mochikamea i'ka Moisetaru kiaretiaopua nuurari, wa'achitia ki ahsieme masitesaa teeme wahjachioi, kiisi iinuemeri teemea Riosi ye'karichi muipuameo. Nape yooma i'ka nuurari chiia ahsieme e'waka mochitokamea, ahsieme masitekamea tiame wahjachioi, muimeripua Riosichi ye'karichio. ");
INSERT INTO var_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Pukaepa aamo chaanenania, ki te'ta Riosi e'wiame enesoopua aamo iikachio, pa'pariserochitiaopua, iyoteri ti'tijoechitiaopua tiame, kiisi muimeri puuua Riosi ye'karichio. ");
INSERT INTO var_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Piirechi taawechiamio Eesusia ti'tijoerio, nekarewachi simiyame masitekapua, eee cheekao: —Inamukame eemeapa aamo ki'yami mochiriame chaachapario: “Ka'te aaata merimitia muuua. Aaata merisaamua, saaemeriche muuua Riosi kokosario.” ");
INSERT INTO var_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Nape neeea aamo chaaniamepua, kiisi aaata me'yakaio, ooweraoi tísia aaata na'ara chaanekameai, kiisi kaawe iintokamekaitepua tiame. Aaata ki inatame teewakameai aaatao, apoe ahpo wa'api ki teesa Riosi kokosarichi ipayameaitepua, ahkasioi na'ichi ahpo ipaka kosopuame. ");
INSERT INTO var_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","’Wa'a tiiame inatatoame enesaamua Riosi iyoriwachi simiyaiopua itapiti oowewamiao, itapiti ki kaaweruma aamo iintoria inatepasaoimua aaatao, ohso kaawe ki asipuapua Riosi te'ta iyoriwachiopua, itapiti Riosiwichio oowewa i'toaiopua, Riosi tepawechi tooemiaiopua. ");
INSERT INTO var_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","Ohso kaawe aamo ki kaawe iintoria aaatachio, aamo katewepuapua pahchao. Neipa aamo kaawe katewesaapua na'areriao, enapuapua waikao Riosi oowewa tooemiaopua. ");
INSERT INTO var_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","’Aaataoi aamo wenejisoopua karichi yachanarekao, ikanati katewepuapua ahjamao, ke'chu i'toniaipua peereichio. Wa'a peereichi upatiaapa muuua, karichiche yachapuame muuua yoorewa neesetoameeopua. ");
INSERT INTO var_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Wa'a pachatiaapa muuua pichiwa teeremerimua, ki ma'chipapuamemua ahkasi yoomá natetesa aamo koparoaniao. Wa'a tiachipa eemea aaatachi ki kaawe teeresaa, ikanati aamo kaawe erapateka katewepuapua ahjamao, ke'chu epeche aamo teerepoiopua. ");
INSERT INTO var_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Piie taawechio Eesusia, suweporichi simiyame masitekapua, eee cheeka: —Inamukame eemea ki ehpesi o'inia chanitiamekopua: “Ka'te suwepori ihsiii.” ");
INSERT INTO var_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Nape neeea aamo chaanenapua, aaata tijoeai, oowera ikotuka tetewikai aaata oowitiameo, tatakori suwepori iintokame puuuapa, ahpo e'rariaeo. ");
INSERT INTO var_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","’Wa'a tiiachipa muuua aamo puusioi tatakorichi wichitesoo, pujisa mehka ipania nakiyamepua ohso kaawe. Epeche kaawe weerewaoi ku'wichi wekatetiaa, ki yooma weerewa kokosari na'ichi ipaniamechitiaopua ki wahjika tajenarichi. ");
INSERT INTO var_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Aamooi seeka tatakorichi wichitesoo, ohso kaawepua tehpunaka mehka ipatiaa, ku'wichioi wekateka ki yooma weerewa na'ichi kosiniamechitia, ki wahjiamesi tajenakame tiiachi. ");
INSERT INTO var_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Piirechi taawechio nenewikai poanatuniamechi simiyame masitekapua, eee cheekao: —Ihjia ki ehpesi o'inia wa'a cheetiamepua: “Aaata ahpo uupichi poanatunariamea, poanatari iyosichi to'waka katewesapa, poanatuniamepua.” ");
INSERT INTO var_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Nape pu'kaonia aamo chaanenania, aaataai ahpo uupi ki suwepori iintokoi poanatukamea, suwepori iintokamepua ahpo uupichio, Riosio ki ahpo toaka mochinurariopua pu'kao. Aaataai, oowitiame ahpo kuunachi poanatukame ahjama neewikamea, tatakoriame puuuai, pu'ka oowitiameo Riosiwichio, ki poantukamechitia tetewamekopua. ");
INSERT INTO var_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Eesusia piie taawechio, aaata itapitichi ahpo iintomia pichiwataniame masitekapua, eee cheekao: —Inamukame eemea, pu'ka ehkoriami mochiriameopua chaaneretioopua pu'kao: “Ka'te mukiwae pichiwata eemea aamo iintomiao, Riosiwichio iintomo tuurikao, ki yorameriai.” ");
INSERT INTO var_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Nape neeea ohso kaaweo aamo chaanenapua, ki aamo itapitichi pichiwataka iintojeraninia, tewekaeoi, pu'ka tewekao ki aamo iinuwarakopapua, Riosiche iinuwarakopapua pu'kao ahpo kahtiachi. ");
INSERT INTO var_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Weeeoi ki aamo pichiwatamete eemea a'chi ikijerakao, aamo iintomiaopua. Weeeai kiisi aamo iinuwa puuua, apoe Riosikamera iinuwara puuua, ihteka kahtiachiopua. Eerusarenichioi ki aamo pichiwatamete eemea aamo iintomiao, Apoe Te'ta Yawichi iinuwarakopapua pu'kao, Apoe te'pa kahtiame taamo Noono. ");
INSERT INTO var_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Aamo mo'oeoi ka'te aamo iintomotiwichio pichiwatamitiamua, pu'kaoi ka'chi iika aamo sewina ikitepo tiiapaomua piiripi kuupaoio, ohchonasipatekao, tohsanasipatekaoioo. ");
INSERT INTO var_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Pukaepa muuua, “eje'e” cheesaa, pichiwa eje'e enepuapua, “ka'i” cheesaa, pichiwa ka'i enepuapua. Epeche u'matoame i'ka ooka pichiwario, riaorósiche eenamepua. ");
INSERT INTO var_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Eesusia piie taawechi ti'tijoeri masitekao cheekapua: —Ki ehpesi o'inia inamukame eemeapa chaachapaniameo: “Puichi wewetiaa, wa'achi iintopua muuuai puichi wewekao; taamechi wewetiaa, taame wichitemichiopua piiripi, wa'achi iintopuamua taamechi wewekao, wichitemichiopua, piiripi.” ");
INSERT INTO var_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Nape neeea ki wa'a tiame masitiamepua, neeea eee chiiamenia: Aaataoi aamo na'ara yoorasoo paanata wewekao, ohsotia piire aamo paanatawa oowepuapua aamo wewemichioopua tiame. ");
INSERT INTO var_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Aaata piire ahka aamo peereichi upasoo itapiti nu'uti ikitiamewichioo, wakiraoi aamo u'yenarekao, kiapuapua pu'kao ohso kaawe, ahkasi aamo ampawakiraoi i'tomichio. ");
INSERT INTO var_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Aaata ku'itapioi ahpo ku'inuresoopua itapiti mooketoka, ehpeche tepepioi ku'ipuapua mooketokekao. ");
INSERT INTO var_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Aaataoi aamo ihko itanesooi, ihkokepuapua pu'kao. Aaataoi aamo rewewa itaneka enasoo, rewesaa pu'kao ka'te utewa yoora koparoakaopua pu'kao. ");
INSERT INTO var_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Pu'ka wa'a tiiame nayewasaapua neipao, aaata ahpo seepurawachi simiyame masitekapua, eee cheeka: —Inamukame eemeapa ehkoriami chaachapariameo: “Aamo kaawe e'riao nakipuapua, nape aamo seepurawao nekumepuapua.” ");
INSERT INTO var_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Nape neeea aamoo chaaniamepua: Aamo sesepurawao nakika tetewipuapua kaawe yooraka, pu'kawichioo Riosi itaka ku'iwa, ka'karuma enepatemichio pu'kao. ");
INSERT INTO var_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Wa'a te'teriame enesaa eeme, tewekachi kahtiame No'no tatanara enemeripua. Apoe Te'ta taamo No'noa, yooma napati taamo nakika tetewamepua, ki aaata epeche tiiame tetewaka. Taaaoi puuua, yooma napati taamo taajenekiamepua, ki ka'karuma ti'tijoerikoipua, ka'karumakoiopua tiame. Apoea yu'kioi, napati wa'achitia tamochi yukitiamepua, ahpo piipateriamechi, ki ahpo piipateriamechiopua tiame. ");
INSERT INTO var_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Aamo nakiniamechee nakiyame enesoo aamo, ¿aatana aamo kaawe ihsiameko tuutapua? ¿Ahkasi te'ta ki ka'karumaai ki wa'achi nokayamepu tiame ahpo nakiyao? Ahkasi Rooma weeechi yawichiwichio koparowameai, wa'achi nokayamepua pu'kao. ");
INSERT INTO var_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Aamo Riosichiche te'teriame kaawe uuyame enesoo, ¿aachin teeka sewina teereta eemea ki Riosichi te'teriameo? ¿Ki wa'achi nokayamepu puuua tiame, ki Riosichi paparaipua? ");
INSERT INTO var_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Ahsepari ka'karuma nokipuapua, kiisi se'wika, te'pa kahtiamechitia taamo No'no, nakiyachitia. ");
INSERT INTO var_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Eesusia, seepurawa kaawe e'rewa nayewaka kajusaapua, ka'karuma yoorarichi simiyame masitekapua, eee cheeka: —Riosiwichio aamo yoorao, ka'te oowera aamo kaawe teteipuachewichio ihsimitiapua pu'kao, aaata yooma tetewachiopua. Wa'a aamo ihsiame enesoopua, kihta aamo kaawe e'rema taamo Noono tewekachi kahtiamea. ");
INSERT INTO var_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Pukaepa aaata ku'iwa ki'yaiopua, ka'te aamokamera kaawe chaachapapuaichio ihsimitiapua ihkokiaio, yooma teteiniachioopua; wa'a nokayame aaataai ki ku'inariai ku'yameai, ahkaoipua napawikarichiamioi, pooechioiopua tiame turupuchaka paajutekao. Pichiwa kaawe chaachapariwa iinuemeripua, nape ti'tijoerieche ki Riosie. ");
INSERT INTO var_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Aaata ku'isaamua wahka tiopachiamioi, ka'te yooma aamo kaawe ihsiame tetewimichio ihsimitiamua itapitie ku'ikaiopua ihkokewao. ");
INSERT INTO var_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Ihjia noriwi teerepuamea aamo kaawe iintoriao, aamo te'pa kahtiame Noonoche nane'remichiopua. Wa'a aamo iintokame enesoo aamo tewekachi Noonoa, kaawe e'reka aamo tetewimapua. ");
INSERT INTO var_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Piirechi taawechio Eesusia, Riosichi paparaka nayeweniame masitekapua. Pukachi simiyame nayewemiaopua, eee cheeka o'inekapua: —Ka'te aamokamera kaawe teteipuawichio nayewemitia. Wa'a e'raka nokayamea, ahpoche kaawe teteiwa i'yamepua; wa'a e'raka ahkaoi Riosi nayewiamea, ahkaoi napawikarichioipua yooremina ajakaoi, ma'chioipua, pichiwa chaaninia pu'kao, aaata wa'a nokayamea, yooma ahpo nakiwa kaawe chaachapawa yowikame puuuapa, nape ti'tijoerieche, ki Riosie. ");
INSERT INTO var_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Nape eemea, ki wa'a teeka nayewemeripua Riosio. Piineri Riosiche ahjama nayewemeri eemea, yooremina karichioiopua mochika. Apoe Te'ta aamo Noono wa'a ihsiame aamo tetewisaapua aamoo, te'pa kahtiame aamo Noonoa kaawe e'raka aamo teteimapua. ");
INSERT INTO var_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","’Riosi ahjama nayewaiopua, ka'te oowera wihtuki ni'ochaka nayewe eemea Riosio, wahjachi ki Riosichi paparamechitiaopua, aaata puuua weeka naewasao, epeche inamupua e'rakaopua Riosieo. ");
INSERT INTO var_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Ka'te wa'achi nokaka nayewemitiapua Riosio, Riosia ke'chu aamo nayeoio apoe nane'riamepua, yooma aamo inataopua itanareka, yooma ihta aamo nakika yasitoaopua. ");
INSERT INTO var_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Ohso kaawe aamo iikachi erakoae nayewepuapua Riosio, eee cheeka: Taamo Noono tewekachi kahtiame, tísia iyoriwa taamo teerewia. ");
INSERT INTO var_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Ikanati enajerani teemea, aamo ye'kario, taamo mochikachi weeechio; Wa'achi teerejerani teemea aamo e'rao, i'wa weeechiopua tewekachi tiiaopua tiame. ");
INSERT INTO var_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Senepi taawechi taamo oowepuapua, taamo nakisiao. ");
INSERT INTO var_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Taamo cheriwejerani teemea, taamo ki kaawe nokariao, taamoo aaata taamo na'aria, cheriwiachitia. ");
INSERT INTO var_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Muuua taamo ku'imitiapua ki ruhjimichioopua ki ka'karumachio, ohso kaawe taamo neesetomitia muuua, ki taamo ruhjimichioopua, te'ta taamo seepurawa Satanasichio. Yooma i'ka no'o aamo chaaniao, aamoo te'ta yomatiame ye'kari Teekorakopapua, amochiopua tiameo, tísia utewariemekopapua, amochiopua yomatiame te'ta iyoriwao, amochi tiiamekopapua, ahkasi ki wahjiamesiopua amochio. Wa'asi, wa'a teerejeriamenia amochio. ");
INSERT INTO var_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","’Aamo na'ara iintokame cheriwesoo, wa'achitia aamo cheriwema aamo No'noai, tewekachi kahtiamea. ");
INSERT INTO var_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Nape aamoo ki cheriwiame enesoopua aaata aamo na'arekameo, wa'achita ki aamo cheriwema aamo Noonoai, tewekachi kahtiamea. ");
INSERT INTO var_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Eesusia simiteka masitekao, Riosi iyoriwa ki koi'wamechi simiyame masitekapua, eee cheeka: —Riosi iyoriwa ki koi'wa yooraio, ka'te aamo nane'retemitiamua, tísia chorowari aamo aiwariaopua, ka'te aamo nanarichi tetewetemitiaoimua pu'kao. Aaata wa'a nokayame ti'tijoeria, tísia Riosiwichio ahpo ki koaka nokayame, eratiamepua ti'tijoerio. Pichiwa chaaninia wa'a nokayameo, yooma iinuepakame puuuapa ahpo kaawe chaachaparewaopua, nape ti'tijoerieche, ki Riosie. ");
INSERT INTO var_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Eemea Riosi iyoriwa ki koi'wa yooraioo, kaawe aamo pusitesa puuyapuapua, kaawe aamo katewesa kuupaoi, ");
INSERT INTO var_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","ki aamo nane'repuawichiopua ti'tijoerieo, aamo chorowari aiwariao, pu'ka aamo Riosiwichio ki koi'wa iyoriwa ihsiriao, Riosieche nane'repuawichiopua pu'kao, ki aaatae wa'asi. Waikao te'pa kahtiame Waikao wa'a aamo te'teresoo, Riosi taamo Noonoa, tísia aamo kaawe e'remapua. ");
INSERT INTO var_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Piie taawechi Eesusia masitiao, tewekachi paarasarichi simiyame masitekapua, eee cheekapua: —Ka'te weeka paarasari katewepa eemea, itapiti i'ka weeechi iintuameopua, ki tehpe yemitupameopua, ihta itapitioi, ki tehpe esoratupameopua, itapiti pikayameoiopua, ihtaoi ichikopua tiiaopua. ");
INSERT INTO var_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Ohso kaawe eemea, tewekachi paarasarikamera iinuepua i'yapuapua, ka'chitia taawechi esoratupamera, ki pikayamera itapiti, ichikuameoi wa'ao ki'tiachi. ");
INSERT INTO var_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Wa'atiao eemea, wa'ache inataka mochitomapua. ");
INSERT INTO var_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Piirechi taawechi masiteka oiai Eesusia, i'ka masitekapua: —Aamo weerewachi tahjeraa, aamo puusi puuua, aamo simiyachi tajetoame ki motochimichio; iikara ne'niachipona puuua tiame. Ka'karuma ne'nepuawichio iinuesaamua aamo puusio, kaaweruma enemamua yomatiame aamo weerewachio. ");
INSERT INTO var_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Nape aamo puusie ki ka'karuma tiiame ne'niame enesaamua, yomatiame aamo weerewachi aamo na'atameri muuua, ahkasioi aamo iikachisiopua tiame. Wa'a tiiame ne'nenareka simitesaamua, tukaparichi tiiame tetewinarekaomua, yomatiame aamo weerewachi tukapari enepamamua, te'ta tukapari oorosi enepaka. ");
INSERT INTO var_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Piie taawechio Eesusia, eee cheekapua ti'tijoerio: —Aaataai ka'chi iika ihsimetepua ooka teeko ahsepari yorakewao, neneku te'ta ahsepari iyoriwao; aaata ooka teekoemea, piiripikamera teeko e'wiame enesaapua, ki e'wiame enemamua piireo, piiripi teekaokamera te'ta iyoriame enesaamua, piire teekoo kiisi iyoriame enemamua. Wa'achi teereniame i'ka weeechiche iintuame i'yaniameai, ka'chi iika Riosiwichiokamera te'ta iyoriwa teeremerikapapua, i'ka weeechi iintuamekamera ikotuka yasitoame enesaapua pehjio. ");
INSERT INTO var_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Eesusia masiteka oiaio, Riosi ahpo tatanachitia neesetowa, masitekapua. Pukachi simiyame nayewakao, eee cheeka o'inekapua pu'kao: —Ka'te te'ta erakomitia eemea, aamo meere ko'komiawichioo, aamo nerojimiaoipua, wisasorioi aamo chuchamiaoi. Aamowichio te'ta epeche nateyameraa, Riosichikamera ahjaniame puuua, ki itapiti kooamechitia, wisasorioi, yooma ihtaoi i'ka wehjoarichi aamo nakika mochitoa. ¿Ki wa'akosa tiiame tetewame eemea? ");
INSERT INTO var_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","¿Ki pahtekakosa tetewame eemea tuchiki nokayao, kiisi echayameoipua pu'kao, kihtaoi i'ipameoipua suunujorichio ahpo katewemiao, taamo Noonoa pu'kao ki'yamekopua ko'komichioo? ¿Ki epeche nateyame ohjoare eemea taamo Noono tatanaraa, ki pu'ka tuchikichitia? ");
INSERT INTO var_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Eemea koi'wamechekamerache inatame eemea, ¿pukaekamera epeche tehpe ahjaka mochitomio o'raniche eemea? ");
INSERT INTO var_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","’¿Achinikai tahpitika erakona eemea wisasori chuchapuamewichioo? ¿Ki tetewame eemea kuhsitere iintuameoi seewao, ki tehki nokayaipua wisasori netekao, ki teesa peeniatiame sewayo? ");
INSERT INTO var_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Naakona, ¿ki epeche tísia peeniatiamepua ki Saromonichitia, apoe yawichi, tisiwa nateyame wisasori chuhchamekaipua? ");
INSERT INTO var_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Riosio kuhsitere sewayameoi ki tehpe e'rame tísia peeniatame enesoo, ¡ki epeche iintotarepua aamooio, yooma ki'yakaopua aamo nakirewaka yasitoa? Wa'a ihsiame enesoo Riosio, ¿achinikai ki pukachikamera paparani eemea? ");
INSERT INTO var_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Wa'a teeresoo, kihta a'chi chaachapamete eemea i'kachitiao: “¿Ihtatia ko'kota teemea meereo? —erakoniame— ¿Achini nokaka tewita teemea taamo wakiratamiao? —erakoniame.” ");
INSERT INTO var_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Yooma ihji ki Riosichi paparamea, wa'a tiameche inatame puuua. Eemea yooma aamo nakiwia nane'riameo, apoe aamo Noonokamerapua, te'pa kahtiamera taamo ne'neka. ");
INSERT INTO var_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Pukaepa eemea epeche nateyamera inataka mochitopuapua, Riosi ye'karichikamera inataka mochitopuapua, kiisi se'wi erakoka te'teretoka. Wa'a aamo te'teresoo te'pa kahtiame taamo Noonoa, yooma itapiti aamo nakirewaka yasitoao, kiameripua. ");
INSERT INTO var_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Ka'te yuuwesi eemea, meere aamo a'chi teeremia katewenarekao. Ehpeche wa'api aamo a'chi tiia, katewepuachepua. Puuu meere aamo a'chi teeremiaa, meere wa'api iinuepuamepua katewepuao. Senepi taawechi machenasiame taamo a'chi teeremiaa. ");
INSERT INTO var_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Eesusia ki aaata a'chi chaaneniamechi masitekao, chaanekapua ahpo masitiao: —Ka'te ki kaawe chaachapamitia eemea aaata ihsiao, itapiti chiiaoi, ki aamo terijeraa Riosieo, aaata na'ariapao. ");
INSERT INTO var_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Wa'a te'teriame aamo enesoo, wa'achitia ki kaawe chaachapapuame eemeai. Kehkisa kehchuma aamo na'areria, wa'achi kehchuma na'arepuame eemeai. ");
INSERT INTO var_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Puuu aaata aamo katewenarewaa, aaata puichi pusiwekame, kasarara puhjenariameka tiiamepua. ¿Achinikai itapiti tahpitika e'riame eemea aaatao, kiisi weruma teekamekoipua pu'kao ahpo puichio, eemea aamo puichio, epeche weruma teekamekaipua, ki nu'uti kutemorika tiiame? ");
INSERT INTO var_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Eemea, puichi ki nu'uti kutemori teekameai wa'a chaachapasaa, ¡achini iika tetewita eemea, aaata pusiweria kasarao? Eemea wa'a kehchuma teekame enesaa puichio, ¿wa'ana chaachapamete eemea, aaata puichi, kasarara ma'chipakemo tuukao? ");
INSERT INTO var_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Wa'a te'teriame enesaa eeme, kihta chaachapame tiiamepua. Ohso kaawe eemea, aamo puichi kutemorikamera pujipuapua pahchao, waikaope, kihta eina teerema eemea aamo puichio, aaata aamo piirechi kasarae pusiweria, aamo ma'chipasekemichioopua. ");
INSERT INTO var_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Eesusia masiterepua tiame napawikameo, aaataopua seenekachio, kihta keepunariame Riosichi simiyameopua, peeniatiame. Pu'ka naewakaopua, cheerepua: —Ka'te chuhchuri ki'ya eemea itapiti te'ta iyoriniameo, itapiti koowioi ki ihpapaseniamepua, perera tehte peenia te'tiameka tiamea, koowia pu'ka ihpapasetiaa yooma tekesoka na'atamapua, ti'tijoeai chuhchurika noonoimapua tiameo, amochi e'enakaopua ki'kimia. Wa'a tiiamekatepua, aaata ki nakiyamea Riosichi simiyameo ahpo tuuyenia. ");
INSERT INTO var_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Piie taawechio Eesusia, Riosichi kaawe teerewa i'yaniame masitekapua, eee cheeka o'ineka: —Aamo Riosichi kaaweruma teerewa itasoo, kaaweruma itapiti aamo kiamapua; aamo Riosichi kaaweruma i'yame enesoo, Riosichi teimache muuua pu'kao; Riosi ta'perachi aamo enasooio itapiti kaaweruma teerewa i'yakao, wahjonepuamemua pu'ka iinueniachiopua yeeterao, aamoo pu'ka aamo i'ya kiapuaichiopua. ");
INSERT INTO var_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Kaaweruma e'raka itayamea, kiapuamechepua; Riosichi i'yamea, teimeripua Riosichio; Riosichi i'yaka eenamea, wahjonepuamepua kaawe yoramia. ");
INSERT INTO var_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","’¿Aatana eeme aamo taanao takari itakoio, tehte kiatapua? ");
INSERT INTO var_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","¿So'chi itasooi ahpo taanao, siinoi kiatapua? ");
INSERT INTO var_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Aaata oowera ti'tijoekai ahpo tatanao, ka'karumara ki'yame enesoopua itapitio, ¿ki epeche kaawerumara taamo kiatarepu taamo Noonoa, te'pa kahtiamea tewekachi? ");
INSERT INTO var_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","’Pukaepa eemea kaawe teerenariamea aaata wahjachio, aamo yorajerachitia teeremerimua pu'kao. Wa'a chiiame Riosia, ehkoriami ahpo nayewaturachi nayewariaa iyotetemichio. ");
INSERT INTO var_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Pu'ka kuuwepasa naewaka Eesusia ti'tijoerio, Riosi ye'karichi muiraa ma'chitekapua eee cheeka: —Riosi ye'karichi siminariameaa, ku'wichi muirachikamera simiyame i'yapuapua pooeo. Puuukamerapua, Riosi ye'karichi eenamea pooe. Piirechi pooe po'yaitepua tiameo, ki ku'wichi muirachi eename, nape puuua, Riosi kokosamiachikamera simiyamepua. Pu'ka pooeo ki tehki tiiamekopao, muuwaeme pu'ka pooechi uumpamepua, ki toinariamekapapua ahpo kiisi kaawe nokayao, pu'ka ki ku'wichi muirachi eenamechi pooe. ");
INSERT INTO var_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Nape Riosi ahjama ahjaniachio pooe ki werepoe puuua, yeetaraai muiwachiopua, kúú'wichipua; wa'a muiwao, ki muuwaeme tewayamepua. ");
INSERT INTO var_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Piie taawechio Eesusia, kaawe ahpo neesetonurekapua ahpo masitiao, ki pichiwa chaachapamechiopua. Pu'ka ahpo inatenurawa nayewekaopua, eee chaanekapua: —Eemea kaawe aamo inateka mochitopuapua, Riosichi simiyameo wihkuaka nayewamechiopua, pichiwaka naewamechitia chaachapamechiopua. Sapoorika nokayameopua po'wa konarekao. ");
INSERT INTO var_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Pu'kao eemea wa'a nokayachio, wa'a chaachapachiopua tiameo, kaawerumachi puuyanapuapua. Kaawerumachio ka'chitia machenameri ki kaawerumao. ¿Wehchajurichikona taakiamepu panijuwari, chuunakaio? ");
INSERT INTO var_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Ki checheyame kuuua, ka'karuma taakiamepua, nape checheyame kuuua, kiisi ka'karuma taakiamepua. ");
INSERT INTO var_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Ki checheyame kuuua, ka'chi iika taakemapua ki ka'karumao; checheyame kuuuai, ka'chi iika taakemapua ka'karumao. ");
INSERT INTO var_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Yooma puuu kuuu ki ka'karuma taakiamea, tehpunasa na'ichi ihpapapuamepua, tajimichio. ");
INSERT INTO var_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Yooma ne'nepasaapa eemea i'ka ma'masitari masitiao, itapiti taakerawachitia machima eemea pu'kao, ka'karuma enesoo, ki ka'karuma enesoo pu'ka masitiao. ");
INSERT INTO var_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Eesusia Riosi ye'karichi muipuame nayewakao, eee cheekapua: —Ki yooma no'o ahpo Paamira teewame, no'o Noono ye'karichi muimeripua. Wa'a no'o Noono ye'karichio, no'o Noono muimeri kaawe e'reriache muimeripua. ");
INSERT INTO var_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Kajuyachi te'ta taawechio, muuwaeme ki no'o Noono e'ra noonoikamea, no'oo chaachapameripua: “Nape Paamira, ¿ki aamo nayewakamekosa teeme? ¿Ki aamo teewaka utewarichi puuyanakame teemeai nanaarario reemó? ¿Ki aamo teewarae cheeka ki ookapi ki maaenari peeniatiame nokakame teemeai?” ");
INSERT INTO var_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Nape neeea waikao, chaanemapua pu'kao: “¡Kiisi aamo macheyamenia! ¡Se'wi eemea noochio, tísia na'ara noonowikame!” ");
INSERT INTO var_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Seenepi simikameo Eesusia, kaari chokiterachitia wa'achitaka nayewekapua ti'tijoerio, eee cheeka: —Yooma no'o masiteria teetokamea, e'pechi karitakameka iintoamepua. ");
INSERT INTO var_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Yu'ki ki nu'uti eenakoiopua, ahkasioi ki nu'uti yeenakoipua neeroio, eekaoiopua, ki muuenati motakoiopua pu'ka kaario, kiisi ru'mimeri puuua, e'pechi tísia pewatiame nawateka karitatiamekopa. ");
INSERT INTO var_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Nape ki no'o masitia teeretokamea, setechi karitakame ikiriachitia. ");
INSERT INTO var_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Puuu karitariaa, weruma yukisoopua eeka ahjamao, aaki neeroiai ki nu'uti yeenasoopua tiame, pukae ruruputiaopua, ru'mirepua. ¡Wa'a ikitiamea tísia kokosa ikitiamepua! Wa'achi ikimeripu ki no'o masiteriachi pewatiame weritokamea. ");
INSERT INTO var_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Eesusi kajusoopua nayewakao, yooma ti'tijoeria tísia peenia eraparepua Eesusi masitiao, ");
INSERT INTO var_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","tísia ye'kaka nayewamekopapua masitekao, ki iyoteri ti'tijoechitia, kiisi aaata seeweka nayewamekopa pu'kao. ");
INSERT INTO var_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Tapanarami Eesusi roomosachi Riosi kaawe ihsiwa nayeweka kajusaapua ti'tijoerio, tetekitiapua wa'a roomosarichi o'iniao. Wa'a tetekitioopua, tisiwa muuwaeme taamo na'naritokapua, ti'tijoe ooweru tiame. ");
INSERT INTO var_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Pu'ka muuwaeme ahjama nokisinioio Eesusio, aaata chopokorieka weripakapua Eesusio, repera kokoriame, korowari tísia chewipatiamera. Puuua wa'a iintokao chaanekapua Eesusio: —Paamiraa, no'o piipatenaresaa no'o sautepuapua no'o kokoriao. ");
INSERT INTO var_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Eesusia waikao sekae ihchepakao, chaanekapua: —Eje'e, aamo sautenariame neeea. Waikao Eesusia wa'a cheesaapua, chaanekapua: —Saukame itipisa muuua. Waikao kokoriamea wa'a cheesochepa Eesusio, saukame itipikamepua, ikanati. ");
INSERT INTO var_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Waikao pu'ka sautesaapua Eesusia, chaanekapua pu'kao: —Née, ka'te tuuyemitia naaju aaataoi, i'ka aamo no'o yoorariaopua. Ihchi siinka kiapuapua pu'ka Riosi ihkorewao, waami tiopachi eenakaopua neeseriosichio. Wa'a eenakao, pu'ka kiapuapua, Moisetaru nuuraretia Riosiwichio oowewario, aamo yachapariawichioo, wa'a tiopachio yoomahka aamo tetewimichiopua, aamo kokoriao yachapakamekopapua. ");
INSERT INTO var_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Pu'ka repera kokoriame sautesoopua Eesusio, Kapenau mochiwachi siimpatiapua waikao. Wa'a muipuachi nokisinioiopua pehjio, aaata natepatiapua, Rooma yawichi kapitaira. Puuua Eesusi ahsekao, tísia tesiwa cheeka, chaanekapua: ");
INSERT INTO var_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","—Paamira, itapiti eratori teetoamenia amochio. No'o neesetoka weripateriaa, tesiwatia po'yapu no'o ta'pechio, kiisi werisiame. No'o cheriwejerame neeea sautekekao. ");
INSERT INTO var_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Wa'a chiiopa pu'kao Eesusia, chaanekapua: —Wee, kaawepua. Wa'a simimane sautemiao. ");
INSERT INTO var_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Nape kapitaia wa'a chiiopao chaanekapua pu'kao: —Nape Paamira, kihta no'o nateyo e'rame neeea no'o petechi pakipuaio. Neeea tísia amochi paparamepua, i'wache o'inia aamo cheesoo, yachapamapua. ");
INSERT INTO var_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Neeeai nuureniamepua no'o epeche paamiratuameeoi. Nooeai noochi iinueme neeeai no'o nuurewa soontaroo. Puuua no'o cheesoo, “Wa'a siimitia muuua”, wa'a siimachepua; Piirechi no'o soontarooi chaanesoopua, “Eenao wa'ana”, enamachepua wa'anao; no'o ta'pechi yoratiaoi chaanesoopua, “I'ka yoramitia muuua”, yoramachepua pu'kao. ");
INSERT INTO var_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Eesusia wa'a chiiopa kapitaio, tísia peenia erapakapua pu'kao, ki nu'uti paparamekopapua. Wa'a iikapa Eesusia, ahpo pukamina nokisiame ne'nepakaopua, chaanekapua: —Pichiwa chiiamenia i'ka tijoeo, yomatiame isaeri weeechioi, ki tetewikamenia te'ta paparameo. ");
INSERT INTO var_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Neeea chiiamepua, i'ka tijoechitia paparakamea, káátisia ki ookapi ti'tijoe ooweru tiame, Riosi ye'karichi muimeripua, yomatiame wehjoarichi mochikamea, yomatiame nenekumi weeechi e'nakame, cherayachitepa o'inia ariyachitikia o'inia tiame. Yooma puuua wa'a Riosi ye'karichi mochikao, tísia ta'iria mochimeripua, Aurani ahjama, Ihsa ahjamaopua, Aakowo ahjamaopua tiameo, yooma pirena ta'iria koaka. ");
INSERT INTO var_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Nape yooma puuu ki i'ka tijoechitia paparakamea, isaeri ti'tijoeai pahcha inamukai i'ka Riosi tuuyewari ki nakikamea tiame, tukapachi uhjurapuamepua ki nu'uti oorosi tukapari tiiachi, wa'ao ki nu'uti naarakoniachi, taamerao tahpitika cheeniachi ki'suka tísia aiwakaopua. ");
INSERT INTO var_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Waikao Eesusia ahpo pukamina nokisiame wa'a chaanesaapua, chaanekapua kapitaio: —Kaawe e'raka no'raka naaju aamo ta'pechio, aamo paparariopa, yachapakame teimamua ta'pechi kokoriameo. Waikaopu kapitai ta'perachi kokoriamea, Eesusi wa'a cheesoche yachapakame itipiriapua. ");
INSERT INTO var_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Eesusia piie taawe Peero ta'perachi ajasitioopua, Peero waasiraopua tísia che'yame tewitiapua, ipetachi po'yame. ");
INSERT INTO var_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Wa'a tiioopua pu'kao Eesusia po'yachi eenakao, sekae ihchepaka yachapatekapua pu'kao. Waikao Peero waasiraa yachapasaapa, itapiti kooame yoramia werisikapua ko'kopuawichio. ");
INSERT INTO var_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Pu'ka wa'api aario yooma wa'ami ohjoemea waapi, ki ookapi reemoikame u'yepakapua Eesusio. Waikaopua pu'ka na'arari yahchameopua, oowera te'yaka puuyanakapua pu'kao. Wa'aoiopua tiameo, yooma ihta kokoriame yachapatekapua tiame. ");
INSERT INTO var_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Ihji Eesusie sautetiamea, ehkoriami Isaia cheeria, ikitiamepua. Puuu Isaiaa, i'ka Eesusi naewakao, eee cheeriaipua: “Puuua yooma taamo kokosa ikitiaopua weerewachio, yomatiame taamo ihtaoi yuuwesiwaopua tiameo, taamo apechunekaopua pu'kao, apochi uuka i'torepua, kurusichi mukukao.” ");
INSERT INTO var_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Wa'a ohjonioiopua pehji Eesusi ahjamao, muuwaeme napawikame tetewikapapua ahpo norikameo, tísia resipakamekapapua wa'asio, paonamina pa'wechi siimpapo tuukapua waikao. ");
INSERT INTO var_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Wa'a chiioi Eesusio pehjio, wa'a naaepakapua aaata iyoteri tijoe. Puuua naaepakao chaanekapua Eesusio: —Masitari, aamo ahjama siminariame neeeai, ahkaoi aamo simiyachi. ");
INSERT INTO var_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Nape Eesusia nehjiakapua pu'kao: —Keeochia yeewachi ohjoemepua wa'atioi, tuchikiai ahpo ta'sochi kochiyamepua, nape neeea Tijoe Tijoetukamea, ki iinuemepua i'wa weeechio ahka no'o che'repasimiachioopua karichio. ¿Kaawe inatakamekosamua naaju no'o ahjama oinariao? ");
INSERT INTO var_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Piirechi aaata Eesusi keepuame tiamea, chaanekaipua Eesusio: —Paamira, aamo ahjama oinariamene oiyao, nape no'o noono mukukame, wetemajimerikane pehjio. ");
INSERT INTO var_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Nape Eesusia i'ka e'rao nane'riamekapaopua, oowera wa'a chiiamekopapua pu'kao, wahjachi wa'a keepuameo wa'achi ahpo e'rameko erakomichiopua pu'kao, pukaepa eee cheeka nehjiakapua pu'kao, Eesusia: —Pichiwa no'o ahjama oinariame enesaa, kihta eina e'remetemua aamo no'o ahjama siminarewao. Pichiwa enesoo aamo noono mukukameo, wahjipakameka te'teriame Riosichikamera toipuapua pu'kao, wetemajimichioo. ");
INSERT INTO var_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Wa'a cheesaapa Eesusia, pawekakerachi mo'moenatiapua. ");
INSERT INTO var_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Wa'a pa'wechi nokisinioio ki kuita yukipakapua ki nu'uti eejeka. Pa'we pe'koniraai pawekakerachio, aampasi chi'posiapua, pawekakerao piwiteme teereteka. I'ka wa'a ikinioio Eesusia kochipariaipua pawekakera wasichitu poika. ");
INSERT INTO var_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Waikao teeme Eesusi ajawariaa, pusatekapua Eesusio, chaachapaka: —¡Paamíra, Paamíra pusasaaa! ¡Werisika taamo ku'isa! ¡Ki piwiteme teetona teeme? ");
INSERT INTO var_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Waikao Eesusia pusatetiaapa, taamo chaanekapua: —Ai eeme, ¿achinikai tísia majayame eemea? ¿Kiisi ahjachi erakona eemea noochio, no'o ihsia tetewakameai? Wa'a cheesaopua werisikao, ta'omakapua eekao, yu'kiopua tiame. Waikao yu'kia eekaa tiame ta'omatiapao, teewekapua. Waikao, yooma yúúweeme itipikapua waikao, pa'wechio. ");
INSERT INTO var_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Waikao teemea tísia peenia erakokaopua iintoriao, taamo chaachapaka teemea: —¿Ihtana tijoe iikame ihjia, ahkasi yu'kia eekaai e'wiameo? Wa'a erakoka itipitiapua pu'kao. ");
INSERT INTO var_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Kaatara weeechi ajasitioopua paonamina wa'a pa'wechio, pu'ka meereo pooechite mo'moenanioio, senawato ooka ti'tijoe reemoikame taamo natepakapua, Eesusi ahjama nayewamia. Ihji reemoikamea wahjipari toaniachi ohjoeme eneriapua tísia nenekatuame. Wa'a te'tiamekopua pu'kao, aaataai ki u'matome tiiapua wa'amio, pooechio. ");
INSERT INTO var_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Ihji ooka reemoikamea wahjipame wetemajiwachi ohjoeme senawato puuyakamea, weeru sisinakokaopua, chaachapakapua Eesusio: —¡Muuu Riosi Taanara, ihtana yoramia teetonamua wakinao? ¿Taamo kokosamia eenamemua ke'chu taamo kokosapuame asiyoio? ");
INSERT INTO var_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Teesa waanami kaawi kahjenachio, muuwaeme ohjoriapua koowi tepuniame, koaka nokayame. Reemoikamea pu'ka wa'a ohjoame tetewapao, ");
INSERT INTO var_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","utewa chaachapakapua Eesusio, pukachi ahpo uhjurapuawichiopua. Puuua chaachapakapua Eesusio: —¡Eesúsii!, i'ka tijoechi taamo puuyanameri enesaa, pu'ka koowichi taamo reesisepuapua muimichiooo. ");
INSERT INTO var_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Eesusia chaanekapua waikao: —E'esa naaju, wa'a muimitia eemea. Waikaopu re'remonia pu'ka ti'tijoechi puuyakaopua, koowichi muikapua waikao. Apochi muitiaapa koowia reemonioeo, kai muenáti ujumakaopua, tekoratatipo ruhjikapua pa'wechi neerochi. Waikaopua wa'ao, yooma wahjipakapua si'sirika. ");
INSERT INTO var_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Waikaopua koowi tepuyamea, wa'a noonoikopa koowio, ahkasi mochiwachisi ujumakapua tísia majakame. Wa'a ajasisaopua mochiwachio yooma tuuyeriapua wa'a mochikameo, ihtana ikiriamekopua, puuu ooka ti'tijoe re'remoikameopua. ");
INSERT INTO var_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Waikao wa'a mochiwachi ohjoemea ikanati Eesusi kahtiachi e'enariapua. Wa'a e'enasaopua Eesusi ihsiachio, pu'ka iintoria majakaopua, utewaeme itanekapua Eesusio, sewinachi akipamichiopua, ki ahpo weewachi. ");
INSERT INTO var_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Kaatara o'inia Kapenau no'rapakao, pawekakerachi mo'moenatiapua Eesusi ahjama. ");
INSERT INTO var_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Wa'a ajasitioopua Eesusio, aaata tu'wikame u'yepatiapua wa'ao, e'taparachi tekitoka. Waikao pu'ka tu'wikameo, pu'ka u'pakameopua tiameo, tísia apochi paparamekopua pu'kao, Eesusia chaanekapua tu'wikameo: —¡Oisa erapasaaa temaríi!, aamo sautema neeea, aamo tatakorio cheriweka. ");
INSERT INTO var_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Ikanati wa'a cheekopa Eesusio iyoteri ti'tijoea, erakoriapua apochio: “Ihji tijoea, na'arenapua Riosio.” ");
INSERT INTO var_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Nape Eesusia nane'riapa i'ka erakoao, chaanekapua: —¿Achinikai no'o na'ara cheerio erakoame eemea Riosio? ");
INSERT INTO var_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","¿Naakonakosa ki epeche ki tehki ohjoarepua: “Aamo cheriwiamenia tatakoririao” —chaniwame, naatikosaoi— “Yachapasa oisí”? ");
INSERT INTO var_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","I'ka tu'wikame no'o cheeriaa aamo tetewimichio cheekamenia, neee Tijoe Tijoetukameo, reesiseri iinuekamekopapua i'ka weeechi cheriwepuameopua tatakorio. Wa'a chaanesapa Eesusia pu'ka nekakoameo, chaanekapua tu'ikameo: —¡Sausáaa, werisika oisíii! ¡Saukame muuuapa wa'asiii! Ehpeo apechunasa aamo ipetao no'asa. ");
INSERT INTO var_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Wa'a cheesoche Eesusio tu'ikamea, saukame itipikapao, ahpo ipeta apechunasa mookeka no'rakapua. Waikao Eesusia wa'a iintosaapa, iyoteri ti'tijoe ne'nepakaopua, chaanekapua: —Aaí. ¿Ki saukamekosa, no'rapukosamene pu'ka? ");
INSERT INTO var_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Waikao Eesusi iintoria yooma tetewikamea, ki nu'uti iyoriwa tetewikapua pu'kao. Wa'a iikapa puuua, weruma kaaweruma paparari nayewaka, paparakapua Riosichio, pu'ka Eesusio weruma utewari kiaretiopua, aaata weeechi tijoekoipua. ");
INSERT INTO var_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Ehpeo Eesusi no'o paajuteria ahjama oimichio, nayewamane. Piie taawechi no'o Rooma yawichiwichio koparowaka ihsioio, Eesusia no'o chokichiami u'matoaio, no'o paajutesikapua, eee no'o chaaneka: —Nahpe Maateo no'o ahjama, ahkaoi no'o oiyachi ahjama oitai. Waikao neeea, ahjama siinkapua. Waika o'inia neeea, ahjama oiyamepua. ");
INSERT INTO var_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Waikaonia pu'ka wa'apichio, no'o ta'pechi paajutekania aari enamichiopua ko'komiao, noochitia Rooma yawichiwichio koparoame, napawisa ko'kopuachi. Wa'achi wa'a e'enariapua tiame, ki kaawe nokayame, puuua wa'achi ko'kakapua tiame, Eesusi taamo ahpo masitera ahjama koaka kahtiachi. ");
INSERT INTO var_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Neipa meeriamio parisero ti'tijoea, Eesusi nane'rekapao tatakoriame ahjama ko'kariopao, taamo iinatukekapua chaachapakao: —¿Achinikai aamo masitaria, yawichiwichio koparowame ahjama ko'kakamepua, wahjachi ti'tijoe ahjama tatakoriame? ");
INSERT INTO var_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Wa'a chaachapachaniopao Eesusia, chaanekapua pu'kao: —Ki kokoriamea ki nakiyamepua ahpo sauteniameo; kokoriamerakamerapua, ahpo sautewa nakiyamea. Neeea, tatakoriame ahjama koayamepua, puuukamerakopapua ahpo tatakoriria sautepuameo. ");
INSERT INTO var_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Nonorasaapa, Ehkoriami Iyoterichi chiia, ne'nepuapua, eee chiiachi: “Ki itapiti no'o ooweniameche tetewinare neeea, itapiti me'yetiame no'o ooweniame. Neeea aamo iikachikamera, kaaweruma enepakame tetewinare neeea, no'okamera oowe e'reka paparakamera.” Neeea tatakorikamera noochi paajutemia eenakame neeea, noochi paparaka enasoopua cheriwemiapa tatakoririao, ki ahpo tatakorieme erakoamekoopua ka'i. ");
INSERT INTO var_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Seenepi simikame Waani Paatori na'naritoamea, Riosi iyoriwa ki koi'warichi simiyame iinatukekapua, Eesusio: —¿Achinikai teeme Waani masitewaraa, pa'pariseroa tiameo, tísia Riosi iyoriwa ki koi'wa yooramepua, nape aamo masitewaraa, ki wa'achi nokayamepuá? ");
INSERT INTO var_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Eesusia nehjiakapua: —¿Yuuweeme mochitariarepua nenewiwachi paajutetiamea, neewimerio ahpo paajutetiachi ahjama kahtioopua pehjio? Nape no'o neewimerika tiiame apechunatioopua tewekachio, waikamiope o'inemeri no'o masitewaraa, ki koi'wa Riosiwichio iyoriwa yoorakao. ");
INSERT INTO var_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","’Neeea i'ka wehjoarichio weemera Riosichi te'terewa enepatemia eenakamenia. Oochetiame Riosichi te'terewa nokiwameo, animari ko'yeka kohseniamechitiaopua oowewa, kiteremichiopua pu'ka nokiwameo. Aaata ki koyachiame weemera wisasorieopua, oochetiame wakiraopua. Weemera wisasori chu'rupasokoopua, oochetiame wisasori koyacheraa si'panamiopa pu'kao, wa'a ikisoopua pu'kao, epeche teeremerikopua si'pariachio. ");
INSERT INTO var_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Wa'achitia weemera wiinooi, ki oochetiame wi'chi aarichi toaniamepua. Puuua oochetiame wi'chi aarichi toatiaa, si'pama oochetiame aaria wi'chi. Wa'a ikisoopua pu'kao, wa'atia wekamapu wiinoa aaria tiame. Weemera wiinoo weemera aarichi wi'chichi toaniamepua, nenekuti ka'karuma enesoo ki si'pamichiopua. ");
INSERT INTO var_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Wa'a chaanioipua Waani na'naritoao, senawato wa'a eenaka Uurio ti'tijoeri paamiratuamea. Ihjia ikanati chopokorieka weripakao chaanekapua Eesusio: —Paamira, yaapiti simijerani neeea no'o maara ne'nemia. Ihpi kiterepakapu no'o maaraa, nape wa'a eenaka aamo sekae ahjachi ihchepasoo, eenechi oijenamapua. ");
INSERT INTO var_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Wa'a chaanetiache Eesusia, ahjama siinkapua ne'nemiao, ahpo yeeka oiya yeetoka. ");
INSERT INTO var_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Wa'a simiyoiopua pooechio, pukamina naaeparia piiripi oowitiame. Puuu oowitiamea, oosa mariki aampa ooka paaumpari i'toame eneriaipua eerasukao. Ihji oowitiamea noriwi ihchepariapua Eesusi wisasoriwachio, e'raka: ");
INSERT INTO var_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","“Wisasorichioi ihchepasaane, saumachenia.” ");
INSERT INTO var_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Wa'a ikitiaapa Eesusia, ku'rika ne'nepakao chaanekapua oowitiameo: —Kaawe erapasa maararaa. Muuua noochi paparaka ihchepakapao, saukame itipikamemua wa'asi. Waika wa'apichio, saukame itipiriapua. ");
INSERT INTO var_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Eesusia tijoe paamiratuame ta'perachi ajasitioopa, weeru chaachapa wa'áo naarakokao, pakapuchera chaajateka o'inemerikaiopua wa'asi mukukame i'topuawichioopua wetemajimiao. ");
INSERT INTO var_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Eesusia chaanekapua wa'ao: —Ehsoo eemea, se'wi ajapasaopua pahchúo. Ihji kutewea kiisi mukukamekaitepua, oowera kohchiaite ihjia. Wa'a chiiopua Eesusio ti'tijoeria, a'achekapua na'areka. ");
INSERT INTO var_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Wa'a cheesao Eesusia yooremina pakikao, yooma puuyanakapua wa'ao. Wa'a ikisaopua pu'ka kiterepakame maaeniameo, sekachi chapika oijenatekapua. ");
INSERT INTO var_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Eesusi wa'a iintoriaa, yooma pu'ka weeechiami nane'reretiapua. ");
INSERT INTO var_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Wa'a o'inia Eesusi machenasoopua, ooka ki mamachiriame na'naritokapua siinakosika, aaatae panitoka i'toniaiopua chaachapasiapua Eesusio: —¡Ehkoriami Raawichi eenameee, taamo cheriwesa muuuaaa! ");
INSERT INTO var_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Aaata ta'pechi pakisoopua Eesusio, wa'a e'enaka naaepakapua Eesusio. Wa'a e'enakopapua pu'kao, iinatukekapua Eesusia: —¿No'o kajumio erakona eemea aamo sautekao? —Eje'e Paamiraaa —chaachapakapua. ");
INSERT INTO var_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Waikao Eesusia puichi ihchepakao, chaanekapua pu'kao: —Saukame itipiame eemeapa, noochi paparakapa. ");
INSERT INTO var_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Waikao ki mamachireriamea ti'tijoe, saukame itipikapua. Wa'a iintosaapa Eesusia, chaaneka uhjurakapua ohjirachio: —Kiisi aaata chaanemitia eemea, i'ka no'o aamochi iintoriao. ");
INSERT INTO var_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Nape puuua wa'a puuyasacheo, yooma mochiwachiami nane'reteriapua, ahpo yoraretiaopua Eesusieo. ");
INSERT INTO var_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Pu'ka ki mamachiriame pukeri puuyasooipua ta'pechio, wahjachi ajasikapua wa'ao, ni'o tijoe u'yepame Eesusio, puuua reemo yahchame eneriapua tiame. ");
INSERT INTO var_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Puuu tijoe ni'oa, Eesusi ma'chipasochepua reemoo, o'inekapua nayewakao. I'ka wa'a iikame tetewapao Eesusio, ti'tijoeria tísia peenia erakokao, chaachapakapua: —¡I'wa isaeri weeechio, kiisi tetewameai teemea eee ikiwameo, ihtá taawechioi! ");
INSERT INTO var_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Nape pa'pariseroa wa'a chaachapame inamukapaopua pu'kao, chaachapakapua: —Aa nape puuua wa'a ihsiamepua re'remo puuyachakao, reemo noonorae ku'iniapa, pukae kianiamekapa puuua, te'ta utewario. ");
INSERT INTO var_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Eesusia yomachi muuwari mochiwachiami oikao, nu'nunti mochiwachiamiopua tiameo, yooma pipiripi i'isaeri napawikarichiamioipua tiameo, masiteka oiriapua tiameo. Eesusia, Riosi ye'karichi simiyame masitekaopua wa'amio, yooma ihta ko'koame sautesikapua tiame, ihtaoi weerewachi a'chi eraniameopua, sautekapua tiame. ");
INSERT INTO var_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Yomachiami wa'ami tesiwa te'tiamekopapua ku'iwa nakikao, po'wa ki tepuniamechitia mochitoamekopua pu'kao, tísia tesiwa e'repakapua pu'kao. ");
INSERT INTO var_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Waikao Eesusia ki ookapi ti'tijoeri wa'a tiiame tetewikapaopua, taamo chaanekapua ahpo ajawariao: —Riosi tehkiwachio ki nu'uti tehki simiyamepua, nape tekipanamea ki weekapua, ehpeche ki ookapi nakiwiamepua pehjio. ");
INSERT INTO var_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Pukaepa ehpeche weeka tekipaname itamitiapua no'o No'no tewekachio, Apoe i'ka echiwa Teekoraopua, taamo ku'ika apechunameriopua i'ipario, pu'ka i'ipari ti'tijoeri noochi paparameriopua. ");
INSERT INTO var_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Wa'a cheesapa Eesusia, taamo ahpo ahjama ohjoameo, oosa mariki aampa ooka uusaopua, ahpo waapi ajapanurekapua. Wa'a ikisaopua, taamo nayewatumia siimpameri ajawakapua. Taamo uusaapua siimpamichioo, ahpo utewari taamochi yahchekapua, pu'kae utewarie taamo puuyanemichiopua re'remoopua ti'tijoechio, yooma ihta ko'koameopua tiameo, pukae yachapatemichiopua weerewachi kokoreniame. ");
INSERT INTO var_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Ihji teeme oosa mariki aampa ooka ajawatiamea, ihjipua: pahcha simiyamea Siimoni Peero teewataniame, Anteresi Peero poonira; piirea Saantiaokapua Waani tiame, na'pa Sewereo tatanara; ");
INSERT INTO var_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","piirechia Eeripekapua, piirea Waatorome, epeche piirea Toomasi; wa'a ikisa piirechia tiameo, neee Maateokapua, Rooma kahtiame yawichiwichio koparoaka yasitoai; piirea Saantiaokapua tiame Arajeo taanara; piirea Taareokapua; ");
INSERT INTO var_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","piirechia tiameo, Siimonikapua Weemuame teewataniame tijoe; piirea Uurasi Ihkariótekapua Eesusio, noriwi nehjakame. ");
INSERT INTO var_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Eesusia taamo oosa mariki aampa ooka masitera uusaopua, eee cheeka taamo uhjurapuame ajawakapua: —Ka'te ohjomitia ki isaeri ti'tijoerichio, Sa'samaria mochiwachiamioi. ");
INSERT INTO var_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Ohso kaawe isaeri mochikachiami siimpapuapua, po'wa ki tepuniamechitia mochikamechi, tatakorichi wewekakame mochikachi ti'tijoeri. ");
INSERT INTO var_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Pu'ka ti'tijoerio chaanepuapua: “Aamo Riosi ye'karichi muitemeria, aamo weeechi ihsiame puuuapa. Pu'ka aamo nayewemia e'nakame teemea.” ");
INSERT INTO var_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Pu'ka Riosi ye'karichi simiyame nayeweka nokisikao, yooma aaata kokoriameo sautesipuapua pu'kao; mukukameo ahjatepuapua pu'ka; repera kokoriameoi piipatepuapua pu'kao; reemo na'arari yahchameoipua, ma'chipasepuapua tiame. Eemea pu'ka sauteniame nokisiaio, kihta toomi koparoachi nokisipuapua, wa'a te'teretomeri eemea i'ka Riosi utewario, kihta koparoawachi kiatiamekapapua. ");
INSERT INTO var_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","’Toomio itapiti aamo ahjae tarimiao, kihta i'toka siimpapuapua. ");
INSERT INTO var_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Mokewarioi ka'te i'toka siimpamitia, itapiti aamo ahjachi i'tomiao, piirechi wakiraoi, piirechi kaakaoi, teesoraoi; wa'atia siimpameri kihta i'tokao, tekipanameo, ahkaoi ahpo nokayachio ko'kotepuamekopua. ");
INSERT INTO var_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","’Ookapi ta'peekachiami asikaio, Riosichi paparame i'yapuapua, aaata aamo che'repamiachi kiamia tiiachi. Aamo che'repari kiatiachioi, wa'ache mochisa uumatopuapua. ");
INSERT INTO var_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Aaata ta'pechi asiyaio, Riosichi mochikamechitia teepotapuapua. ");
INSERT INTO var_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Wa'a ta'pechi aamo asiyachiamio, Riosichi paparamechitia aamo asipusoo, wa'ache che'repasa uumatopuapua. Nape ki Riosichi iyoriame enesoo, poanachi i'yapuapua che'repapuachio. ");
INSERT INTO var_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Nape wahka mochiwachi, ki aaata aamo kianaresoo che'repapuachio, aamo tarachi pechichisache kaakao uumatopuapua wa'ao, ki ahpo kaawe e'reretia pechichisa. ");
INSERT INTO var_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Pu'ka wa'a te'tiamechio ti'tijoeri, pichiwa chaaninia pu'kachio, ki teesa tiame wichimerikopua Riosi kokosario te'ta Riosi katewemiachiopua ti'tijoerio. Epeche kokosari aiwamerikopua pu'kao, ki Sooroma muuwari mochiwachi, Oomora muuwari mochiwachioiopua tiame, Riosi kokosari aiwariachitiaopua. ");
INSERT INTO var_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","’Tísia maajoichitia che'maka ohjopuapua aamo siimpachio, wa'a aamo no'o uhjurachio, sapoori ti'tijoe ooweru tiame mochiwarichiami aamo uhjuramenia. Wa'ami ahka aamo tetewisaapua, aamo ko'konaremapua, pu'ka aamo Riosi kaaweruma tuuyesiopa, tísia aamo na'areka tetewimapua. Pukaepa eemea, koorochitia kihta chiiame enepuapua, kihta nekame tiameo. ");
INSERT INTO var_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Pu'ka ti'tijoechio kaawe aamo neesetopuapua, ki senawato yoorewa neesetoamechi wenejipua tiiame enepuaichiopua, seenekachioi puuua aamo wenejikao karichiami ahkaoi aamo toanaremapua. I'isaeri napawikarichioi aamo i'tomapua wepipuawichioo. ");
INSERT INTO var_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Te'ta yawichi peereirachi u'upapuame eemea wenejika, noomina te'teriapa eemea ahjama. Waika chaachapameri eemea no'o nehpupakao, wa'akachi, te'ta ya'yawichi tetewachi. Eepi wa'a yorapuame eemea aamo ohjoachio ihta ya'yawichichioi, ihta aaata seesenu ya'yawichichioi i'isaeri. ");
INSERT INTO var_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Nape ahkaoi te'ta yawichichi upatiaio, ka'te seewemitia eemea aamo chaachapamiao, achini ihtana chaachapaka aamo nehpupapuameopua. Riosi Apoea amochi ihsimeripua nehpupaka, aamo chaachapamiao nayeweteka. ");
INSERT INTO var_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Ki aamoe naewai chaachapameri eemea, apoe Riosi ihsimeripua amochi nayewaka, apoe ahpo Riosiwarie. ");
INSERT INTO var_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Wa'a cheesaapa i'ka nayewasikapua: —Asimiitepua piie tawechiamio, aaataa no'o ahjama ohjoniopao, ahpo poponiemeai ahpo ko'imiitepua; noonoraai ahpo tatanao, wa'achi iintomiitepua ahpo taana me'yaka; tatanaraai tiame ahpo noono nekamuchekao, merimeripua tiame ahpo noonoo, ki tetewinariapa ahpo noonoo ahjama teereniameo. ");
INSERT INTO var_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Ahkaoi ti'tijoeria aamo nekamuchemeripua no'owichioo, nape ahkasi kateweri taawechisi ki se'wika noochi paparaka te'teretosoopua newipatepuamepua, kakupachi iintapakao. ");
INSERT INTO var_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Pirenapi mochiwachi na'ara yoramia naanaritoniaa, pirenachi mochiwachiami ujumapuapua; neeea no'o ikimiao, kiisi wehchi wichimeripua, neee Tijoe Tijoetukamea ke'chu aamo yooma ohjoi i'isaeri mochiwachiamio, meritiai eenechi oijenakame eenakame enamania. ");
INSERT INTO var_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","’Aaataai masiteraa, ki epeche tiiamepua ahpo masitario. Aaataai ahpo teeko tekipanakiamea, ki epeche tiiamepua ahpo teekoo. ");
INSERT INTO var_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Puuu masiteraa, ki ahpo masitari epeche tiiame tetewiniamechitia, ahpo tetewipo maaemetepua. Aaata tekipanamea, ki ahpo teeko tetewiniamechitia, tetewipo ahpo maaemetepua. No'oo, no'o Weseu riaorósi tewatioo, ¿ki epeche eemekamerakosa riaorósi tewapuamepua? ");
INSERT INTO var_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Eesusi i'ka taamo masitesaapua, i'ka taamo chaanekapu: —Nee. Ka'te seewemitia masitari ki ka'karumao aamo na'ariao, yooma itapiti aamo na'aretiamea kihta noriwi itipimerikaitepua. Yooma wa'a chaachapakamea, Riosi te'ta kokosari tísia aiwatepuamepua. Yooma noriwi tiiamea, yooma ma'chi teerepapuaite puuua; yooma noriwi na'ara nokitiameai inasoka, yooma nane'repuaitepua, Riosi kokosarichi taawechio, te'ta Riosi ti'tijoeri te'teria katewiachiopua. ");
INSERT INTO var_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Pukaepa eeme piineri mochikai no'o masiteria, yooma tetewachi masitepuapua aaatao, yooma aamo no'o ki aaata inamuachi masiteriao, yooma inamuachi masitepuapua pu'kao. ");
INSERT INTO var_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Ka'te seewe nokisimitia aamo weerewa merinariameo, aamo weerewa me'yakaipua, ka'chi iika merimeripua aamo iikao, Riosi ahjama yasimeriopua. Riosikamera aamo kokosamia seewepuapua, te'ta ki wahjiame aiwarichi uhjurapuame. ");
INSERT INTO var_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","’¿Kikosa tuchikia, piiripi toomichi wa'api nehjitioiopua pu'kao, ki nane'retare Riosia pu'kao, piiripi pu'kaoio mukukoo? ");
INSERT INTO var_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Aamoo Riosia, ¿ki epeche nateyame tetewame ohjoare Riosia, ki tuchikichitia? Puuua ahkasi aamo kuupaoi, nane'riamepua kehkina aamo kuupaekopua. ");
INSERT INTO var_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Pukaepa kihta seeweka mochitomete eemea, epeche nakiwamekapapua Riosieo, ki tuchikichitia. ");
INSERT INTO var_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Eesusia simiteka masitekao, chiiapua: —Aaata no'o ahjama tiio tuuyameo, wa'achitia no'o ahjama tiio tuuyo tuuyemania pu'kao, apoe te'ta no'o Noonochi te'pa kahtiamechio. ");
INSERT INTO var_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Nape aaata ti'tijoechio ki no'o ahjama tiio tuukameo, neeea no'o Noochio te'pa kahtiamechio, kiisi machiyo tuumania pu'kao. ");
INSERT INTO var_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Pu'ka masitesaapua ti'tijoerio, ki ahpo wa'achitia inataniame masitekapua, eee cheeka: —No'o i'wa weeechi eenariwaa, ki napati ta'iria mochipuawichio no'o eenario erakopuapua, ti'tijoeriopua noochi simiyame chaachapakao, ahpo nekakomerikopa. ");
INSERT INTO var_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Ahkasi aaata ta'pechi mochikameai, ki wa'achitia ahpo erakomapua no'owichio tiiachiopua. Tatanaraa, ahpo noonochi noochi paparameo, ki wa'achitia erakomeripua; mamararaai ahpo yeeyechioi, ki wa'achi tiiame erakomeripua noochi paparopa ahpo yeeyeo; momoriawaraai, noochi paparopa ahpo waasio, nekakomeripua. ");
INSERT INTO var_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Wa'a te'terewachio, ahpo ta'pechikaiopua wa'apio, ahpo seepuraweka enemeripua. ");
INSERT INTO var_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","’Aaata ahpo noonoo ahpo yeeyekamera epeche nakiyameapua ki no'ochitiao, ki no'o ijinuwara teereme tiiamepua. Wa'achitia aaata ahpo maaraoi ahpo taanaoi epeche nakiyamera ki no'ochitia, ki no'o ahjama teereme tiiamepua. ");
INSERT INTO var_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Aaata ki noochi paparawawichio anachaka yasitoamea, na'areniaoi aaataeoi, kiisi noochi teeremetepua. ");
INSERT INTO var_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","No'o ahjama tiia noriwi teerenariamea, kihta iinuemeri puuua noochio, ahpo ahjama teerewao. Nape ki inasoamea ahpo noochi tiiao, kaawe teeremetepua noochio, ki ahpo inasoamekapapua noochi tiiao. ");
INSERT INTO var_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","’Aamo kaawe tetewamea noochi tiiopao, no'o kaawe tetewamepua tiame. Wa'achitia no'ooi kaawe tetewamea, no'o Noono kaawe tetewamepua tiame, Apoe no'o Noono no'o weerakame, tewekachi o'inia kahtiame. ");
INSERT INTO var_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Aaata noochi tiiame Riosiwichio kaaweruma nayewatuamea, kaawe uuka tetewameapua Riosi chiiao, wa'achitia ahpo iinuepakamepua, Riosie ahpo kianiameopua. Yooma noochi eneka Riosichi ka'karupakameo, kaawe tetewame no'o Noonoo, wa'achitia ahpo iinuepakamepua Riosie kianiameo. ");
INSERT INTO var_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Aaataai, pukeri noochi o'ichame paparakao, teesaoi ku'ikoipua pu'kao, neeroioi ki'yakaopua paramusoo, Riosia kaawe e'raka tetewamepua pu'kao, ki wa'atia toimeripua pu'kao, itapiti ahpo kiameriopua, tísia kaawerumaopua. ");
INSERT INTO var_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Eesusia kajusaapa taamo oosa mariki aampa ooka ajawatiame yorapuame tuuyekao, wa'api wa'ami masitemia simikapua taamo ahjamao, ahpo Noono kaaweruma tuuyewari tuuyewamiaopua. ");
INSERT INTO var_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Waani Paatoria yeetaeka kahtiaiopua perekarichio, Eesusi inisia inamukapaopua, ookapi ahpo masitia uhjurariapua Eesusi iinatukemichioo. ");
INSERT INTO var_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Waania eee cheeka iinatukenureriapua Eesusio: —¿Muuupu Ehkoriami enamio tuutiame Iyoterichi, piirechikosa puuyetaone, pehji? ");
INSERT INTO var_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Eesusia iinatuketiapao, nehjiakapua cheekao: —Nonorasaa eemea, yooma aamo tetewaria no'o ihsia, tuuyepuapua Waanio, yooma aamo no'o chiia inamuriaopua tiame: ");
INSERT INTO var_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","ki mamachiriameo no'o ma'chirepatio tuupuapua; rojowi kokoriameo, sautio tuupuapua no'oo; repera ko'koriameoi, no'o yachapatio tuupuapua tiame, piipakame itipiteka; na'nakapioio, no'o sautio tuupuapua pu'kaoi, inamuteka; mukukameoio, no'o oijenatio tuupuapua eenechi; ahpo tatakoririopa tísia cheriwejerao, nooe cheriwio tuupuapua. ");
INSERT INTO var_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Noochi kiisi seeweka oowe e'riame, tísia kaawe yorapuameko tuupuapua pu'kao, no'o Noonoeopua Riosi. ");
INSERT INTO var_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Waikao i'ka Waani na'naritoa nonorapusaapua Eesusia, Waanichi simiyame nayewasikapua wa'a muuwario, eee cheeka: —¿Ihtana ne'nemia siimpaka eemea ooruchi weeechiopua? ¿Aaata majaka kuhsichitia chachapia ihsiame eekaekosa, ne'nemia siimpakame eemea wa'ao? ");
INSERT INTO var_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Ki wa'a tiame ne'nemia siimpakame enesaa eemea, ¿ihtana ne'nemia siimpanareka eemea naaju, aaata tijoe ka'karuma wakiraemekosa? Ka'iii, ka'karuma wakiraemea peenia tiame, yawichi karichiche wa'a tiame wakiraetaniamepua, apoe yawichikamera. ");
INSERT INTO var_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Ki wa'a tiame wakiraeme ne'nemia e'enakame enesaa eeme, ¿ihtanakamera ne'nemia siimpaka eemea naaju, aaata Riosi nayewamekosa? Eje'e. Puuu enerepua Riosi nayewatuame, nape ki oowera Riosi nayewatuame. ");
INSERT INTO var_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Waania ki oowera tijoe enerepua, pu'ka Waanio no'o Noonoa ke'chu no'o eenoio masitemiao, cheeriaipua pu'ka nayewakao, eee cheeka: Neeea, ke'chu aamo o'inioi masitekao, wa'a aamo uhjurenania aaata, yooma ti'tijoe ooweru tiame ki kaawe te'teriame ahpo iikachio, katewetiame mochiwamichiopua ahpo iikachio, yooma pu'ka ki kaawe ahpo te'teriameopua, toinuresika na'arariopua, ki kaawe nokiwameo. Wa'a cheeka nayewakame Riosia Ehkoriami Iyoterichio, ahpo ehkoriami nayewaturachio. ");
INSERT INTO var_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Pichiwa chaaninia i'kao, yooma ooweruchi naawakamea, ihji Waani Paatoriche puuua, epeche weruma itapiti yoorakamea ki wahjachitia; nape Riosi ye'karichi yasipua ahsepakamea, epeche weruma tiiaitepua, ki Waani Paatorichitia, kihta weruma iintokaipua i'ka weeechio. ");
INSERT INTO var_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","’Waani eenariachisi o'inia ahkasi ehpe taawechiamisio, tísia na'areka tetewiniamepua, Riosi ye'karichi muipuame nayewatuamea. Ehpe taawechimioi, wa'achitia tahpitika e'raka kajuka tetewinariame, Riosi ye'karichi simiyame tuuyewaria. ");
INSERT INTO var_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Yooma ehkoriami Riosi nayewatukamea, Ehkoriami Iyoterichi chiiaa tiamea, i'ka Riosi ye'karichi muira nayewaka chaachapatiame puuua, ahkasi Waani enasaoipu tiameo, pu'kachi ehkoriamisi o'inia Riosi ye'kari nayewatiame nayewarepua tiame. ");
INSERT INTO var_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Neeea pukaepa i'ka Waanio, ehkoriami Eeríakotinia pukachio, Riosi na'nayewatura enamio tuuka chaachapariao, pu'kao wa'achi tiiame ihsiwariemekopapua. Aaata wa'achitia erakonariamea, wa'achi erakomapua. ");
INSERT INTO var_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","I'ka wa'a tiiame pahtenariamea, kaawe inataka ne'nepuapua. ");
INSERT INTO var_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","’¿Ihtanako tuutarenia ehpe taawechiami ti'tijoerio? Ihji ti'tijoeria, kukuchika te'tiamepua, muuwaeme mochikame nehjiwachiopua, te'eka chaachapakame: ");
INSERT INTO var_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“Teemea chaachatekamepapua pakapucherao, nape ki yaukame eemea. Yuuwesiwa wikatakame teemea, nape ki naarakokame eemea.” Ehpiami ti'tijoeria wa'a te'tiamepua. Eemea Riosie paaetiai, kiisi e'wekamepua. ");
INSERT INTO var_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Waanioi ki e'wakame eemea, ohsotia eemea pu'kao, rooroikame teewakamepua eemea, ki ti'tijoeri ahjama koayamekopua pu'kao, mochiwachiami oika. ");
INSERT INTO var_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Ehpeoi no'o Tijoe Tijoetukame eenakoio, wa'achitia te'teriamepua, ki no'o e'wekao, ohsotia eemea no'oo, tísia koayame no'o teewamepua, nawajiameopua tiame. Eemea, oowera wa'a no'o chaachapamepua, senepi ti'tijoeche ahjama koayamekopa. Eemea wa'a chaachapamea no'oo, tatakoriamera ti'tijoeri no'o kaawe e'rio tuuyamepua. Nape aamo no'o na'ariao, no'o kaaweruma ihsia aamo ihchitamapua, no'o yooraka yasitoaa, kaawerumakapa, no'o Noono tewekachi kahtiameo, te'ta peenewari machiwarikapapua. ");
INSERT INTO var_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Waikao Eesusia wa'a mochiwachio, epeche weeka itapiti peenia ihsiwa ahpo iintoriachio, o'inekapua te'yakao, yooma pu'ka ti'tijoeriopua, ki toinarekopa ki kaawe ahpo nokayao. Eesusia chaanekapua pu'kao: ");
INSERT INTO var_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","—¡Aiiii eemea Korasini mochikame! ¡Aiiii eemeai We'saira mochikame tiamé! I'ka no'o peeniasiwao Tiiro mochiwachi no'o iintosoopua Siironioiopua mochiwachiopua tiameo, pichikemii puuua no'o chiiao Riosichi paparakao, yooma ahpo ki kaawe nokayaopua toakáa. Wisasori suuwiti chuhchamii puuua napisooi ahpo moochi ipaseka, ahpoo kiisi kaawe ahpo nokario erakoka, ahpoo puuua wa'a tiame e'rakao, tetewiteka. ");
INSERT INTO var_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Nape neeea aamo chaanemapua pu'ka aamo nokayawichioo, te'ta Riosi katewemiachiopua taawechio, Riosia amochio ki nu'uti kokosari amochi teewemiitepua, epeche ki Sooroma Oomora mochiwachiopua tiameo, te'ta kokosari aiwatetiamechitiaopua. ");
INSERT INTO var_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Eeme Kapenau mochikameai, ¿Riosie aamo apechunapuamekosa maayame eemeai te'pa Riosi kahtiachio? ¡Ka'ii, ohsotia eemea kiisi wahjiame wichiwachi uhjurapuamepua, poanachi ki Riosi kahtiachi, wa'ao te'ta tukapachi! Neeea i'ka peenia tiame amochi iintoriao, Sooroma mochiwachi no'o iintokame enesoo, Sooroma mochikame ti'tijoeria, paparamii puuuapa, wa'a iikaopua, ahjaka mochimeriipua pehjio. ");
INSERT INTO var_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Nape eemea tetewikameaipua i'ka te'ta kaaweruma no'o peenia ihsiriao, kiisi nakika tetewikame eemea. Wa'a te'tiapa eemea, te'ta Riosi yooma ti'tijoeri katewiachio, epeche tísia kokosari aiwatepuame eemea Riosieo, epeche ki Sooroma Oomora tiame aiwatetiamechitia. ");
INSERT INTO var_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Eesusia yooma ti'tijoeri inamuachio, ahpo Noonoo nayewekaopua, cheekapua: —No'no, aamoo tewekachi yomatiame ye'kameopua i'ka weeechiopua tiame, aamo cheriwema ki'yame neeea, aamoo, i'ka ti'tijoeri weeechi mochikameo, kihtawichio aamo nakimia erakoamechiopua, ki aamo te'ta ma'chiame tetewitiamekopapua pu'kao, aapoeo aapoeche, ahpo ahsepari tiiame maayameopua, kaawe te'teriameopua; ohso kaawe muuua, tesiwa te'tiamerakachi aamo tetewitiame muuua, te'ta aamo machika mochitonariamechiopua. ");
INSERT INTO var_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Wa'a ihsiame muuua No'noo, wa'a tiame iintomo e'rakamekapa. ");
INSERT INTO var_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Wa'a cheesapua Eesusia ahpo Noonoo, chaanekapua ti'tijoerio: —No'o Noonoa yooma no'o ki'yakamepua ahpo itapitiwao, yooma ihta itapiti iintuameopua tiame. Aaataai ki te'ta no'o machiyamepua, no'o Noonoche puuua, te'ta no'o machiyamea; no'o Noonooi, aaataai ki'tiamepua te'ta machiyamea, neeechepua, te'ta machiyameraa, pu'kao neeea aaatao, no'o Noono machitenaria. ");
INSERT INTO var_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Pukaepa noochi e'enajeraninia. Aamo noochi e'enasoopua, aamo machitemania no'o Noonoo. No'o Noonoo te'ta machisaapa eemea, resipumeri eemea yooma itapiti amochi pehtiao, yooma aamo ki ka'karuma nokariaopua, cheriwetiame itipikapa. ");
INSERT INTO var_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Noochi te'teresa naaju, yooma teitaipua waikao aamo resipuka yasitopuameo. Pepenipapuapua naaju no'o masitiao, kiisi tehki tiiame aamo masitema neeea, kaawe e'raka. Kihta utewa cheeka aamo masitemeri neeea, kaaweruma iikaeka. ");
INSERT INTO var_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Neeea aamo maakurakiao, kiisi pehtiamepua tehkíi. Ihji aamo no'o nuuriaa, kiisi pehtiame tiiamepua. ");
INSERT INTO var_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Piie taawe resipuniame taawechio Eesusia, tiiriko echitiachiami u'matoiopua ahpo ma'masitera ahjamao, ihji ma'masitewaraa cho'chorowame nokisiapaopua tiiriko pahchira koi'siriaipua okisikao. ");
INSERT INTO var_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Nape parisero ti'tijoea wa'a nokisiopua pu'kao, chaanekapua Eesusio: —Ne'neo aamo masiterao, resipuniachi taawechioipua, itapiti yooraka nokisinapua, ki reesisewa nokiwameopua. ");
INSERT INTO var_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Eesusia wa'a chaanetiapao nehjiakapua pu'kao: —¿Ki iyonakame eemea Ehkoriami Iyoterichio ihtana iintorio Raawitaruo ki anachapasaopua toore? ");
INSERT INTO var_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","¿Ki Riosi kaarirachi pakika paani iyoriwa ko'kakamepua, ahpo yeetoka inisia kipotekaopua tiame, pu'ka paanio tiopachi neeseriosiche reesiseniame, ko'komichio? ");
INSERT INTO var_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","¿Ki tetewakame eemea tiameo pu'ka Moisetaru Iyoterichio tiame chiiao, tiopachi pa'pamiratuameopua tiameo, itapiti yoorariopua, Moise nuurari resipuniame taawechioi, itapiti ki reesiseri yoorario? ");
INSERT INTO var_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Pu'ka resipuniame taawechiwichionia, aaata te'ta iyoriniame kahtiotinia pehjio, ki pu'ka tiopachi iyoriwachitia. ");
INSERT INTO var_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Eemea epeche no'o te'ta machiyame enesaa, ki wa'a no'o chaanemii eemea i'ka ki reesisewaopua. Pahtiame enesaa eemea i'ka tiopachi iyoriniameo, pahtemii eemea tiamea, Ehkoriami Iyoterichi chiiaopua, Riosio eee cheeriachiopua: “Neeea, ki oowera itapiti meritiame oowewari no'o u'yepaka no'o iyorijeraninia; neeea aamo iikachikamera kaaweruma enepaniame, nakiyamenia, aamo aaataopua tesiwe e'remichiopua.” I'ka Ehkoriami Iyoteri chiia nokisiame enesaa eeme, kihta chaachapamii eemea, i'ka ti'tijoeri kihta ki kaawe nokayameo. ");
INSERT INTO var_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Neee Apoe Tijoe Tijoetukamea, neee wa'api iintokamepua pu'ka resipuniame taaweo, yahchakao. ");
INSERT INTO var_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Eesusia wa'a tiirikochi o'inia u'matosaopua napawikarichi pakikapua wa'api mochiwachio. ");
INSERT INTO var_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Wa'a tiopachiopua, wa'a tewitiapua piiripi tijoe sekachi chookopakame. Wa'aoi parisero ti'tijoea, itapiti wenejipuame tewinariapua Eesusio, chaachapaka pu'kao: —¿Reesisewa ohjoarepua, aaata resipuniame taawechi yachapatepuao? ");
INSERT INTO var_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Nape Eesusia i'ka nayewaka nehjiakapua: —¿Aatana eemea po'wa aamo puhkue tekorichi wichisoopua piiripio, ki ma'chipatapua, resipuniame taawechikoio? ");
INSERT INTO var_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","¿Ki wa'achi iintotarepu aaataai tísia ahpo nakiyame enesaaopua aaata tijoeo? ¿Ki epeche nateyame ohjoarepu ti'tijoea oowerua ki po'wachitia? Wa'a teeresoo resipuniame taawechioiopua, aaataai tijoe ku'yamea oowitiameoiopua, kihta ki kaawe tiiame ihsiamepua. ");
INSERT INTO var_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Wa'a cheesaopua Eesusia, chaanekapua chookopakameo: —Riisasipaomua aamo seekao. Waikao chookopakamea, riisasipasaopua seekarao, ikanati saukame itipikapua seekarao, piire kaaweruma ahpo seekachitiaopua. ");
INSERT INTO var_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Nape parisero ti'tijoea kaawe e'remitioiopua Eesusi kaawe iintoriao, Eesusi meripuame ahpo kateweriapua wa'a puuyasao. ");
INSERT INTO var_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Eesusia i'ka noonoimia nane'resaapua, sewinachi siimpatiapua waikao, muuwaeme taamo pukamina nokisiniame ahjama. Eesusia ahpo pukamina nokisiameo, ki ookapi sautesiapua. ");
INSERT INTO var_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Eesusia ahpo sauteriao, ki aaata tuuyenuresiapua pu'kao, aatana ihsiriopua sauteriao. ");
INSERT INTO var_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Ihji Eesusi kaawe ihsika oiriaa, ehkoriami Riosi cheeria teetotiamepua, ehkoriami Isaia tewaniamechi Riosi cheeria, Ehkoriami Iyoterichio puuua, eee cheeriai Riosia: ");
INSERT INTO var_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","¡Nee! Senawato yachamiitenia, aaata no'owichio yorakemeriopua; puuua aaata no'o uuria tijoe enemeripua, aaata te'ta no'o nakiya, aaata no'oo, tísia kaawe e'raka tetewamera; pukachi yasipameri neeea no'o Riosiwario. Ihjia te'ta no'o Taana enemeripua. Puuua yomachi weeechi mochikameo, no'o chiia cheesimeri enemeripua, no'oe cheriwepuame tatakori tiiameo. ");
INSERT INTO var_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ihjia kaaweche nayewiame enemeripua ti'tijoerio, kaawe e'raka nakikache, kihta uwatiame nayewaka nekayamechitia. Kihta inamupuamepua, aaata tetewachioipua, ihta ki oowe e'repuameopua, utewa cheeka aaatao, weeru nayewaka nekame cheekao. ");
INSERT INTO var_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Ihji no'o Taanaa, ki epeche erapatemapua aaata, ka'chi ikime e'raka kahtiameopua, neeroturi kahponakachitiaopua, aaata epeche koomorapatekaopua tísia yuuwesika yasitoameo. Puuu no'o Taanaa tiameo, ki wa'atia toimapua ki ku'ikao, aaata noochi teesa paparawa moroyame choipatiame, itapiti tahjera meechara choipatiamechitia. Wa'a inisimeri no'o Taanaa, noochi enapame ku'isikaopua, ahkasi ahsepari teeremeriachisi noochi paparameriopua wa'asi, ahkasi no'o Taana yawichituwachi, no'oo mochitepasichi. ");
INSERT INTO var_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Wa'a pu'ka no'o Taana yawichituwachio, yomatiame wehjoarichi mochikame, no'o Taanachi ahjachi erakoka, ohjoepameripua. ");
INSERT INTO var_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Wa'ao Eesusia, piiripi tijoe ni'o ki ma'chiriame u'yepatiapua. Ihji tijoea reemo apochi yahchapa wa'a teereriapua. I'kao Eesusia, reemo ma'chipasekaopua, saukame itipitekapua ki ma'chiriao, ni'ooi naewatekapua tiame. ");
INSERT INTO var_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Yooma i'ka wa'a iikame tetewakamea, tahpítikatia peenia erakokaopua, ahpo iinatukiapua chaachapaka: —¿Ki ehkoriami Raawichi enamerijuare ihji? ¿Ki ihjipu Riosie enamio tuutiame? ");
INSERT INTO var_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Nape parisero ti'tijoea i'ka inamukapaopua, ahpo ihchi chaachaparepua: —Ihji tijoea, Weseuchi eenamepua utewariraa, pukae ma'chipamepua reemonioo. ");
INSERT INTO var_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Wa'a ahpo chaachapopa ihchio, Eesusia chaanekapua pu'kao: —Nape piiripi yawichiwachio, ka'chi iika ahpo wa'apichi nasiwametepua. Ahpo wa'apichi nasiwasaapua ooka pirenaturi enepakao, ahpo wa'api soopameripua. Ahkaoi mochiwachioi, ahkaoi ta'pechioi, ahpo wa'api nasiwasaapua, ahpo wa'api soopameripua tiameo. ");
INSERT INTO var_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Satanasia ahpo wa'api utewarie aaata reemo ma'chipame enesaa, ahpo wa'apichi nasiwame puuua. Wa'a tiiame enesaa, ¿ki ahpo wa'api me'yaka ihsiamepu? Ahpo wa'api merisaapua, ¿Aachin teeka teetotapua waikao ahpo yawichituao? ");
INSERT INTO var_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Eemea no'ooi, Weseu utewarie no'o ma'chipame teewasoopua reemoo, ¿ihtana utewarie ma'chipame reemo, aamo na'naritoamea naaju? Puuu aamo na'naritoao, Riosi utewarie ma'chipame enesoopua reemo ki Weseu utewarie, se'wi chaachapai no'o wenejina eemea. ");
INSERT INTO var_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Nape no'oo Riosi Riosiwari utewarie puuyachame enesoopua reemoo, amochi ihsiamepua wa'a teesoo, aaata Riosi ye'karichi muitiamea. ");
INSERT INTO var_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","’Ihji no'o reemo puuyaka ihsiaa, Riosi seepurawa puraka ihsiniamepua. Ki Satanasi purisaa teeme pahchao, ka'chi iika upameriai teemea aaatao Riosi ye'karichio. Nee. Aawataai ki ichikuetare aaata karichiopua, ki pahcha purisaopua kariwaemeo. ¿Achini ihsika u'yetariapu aaata iinuwarao tísia inatewa iinueme enesoopua? Ka'chi iika u'yetariare ki purisaapua pahcha. ");
INSERT INTO var_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","’Ki noochi tiamea ku'itokao, no'o seepurawapua. Ki no'owichio na'poamea, Riosi ye'karichi upapuameo, no'o chi'ripakiamepua, ki noochi e'enamichio. ");
INSERT INTO var_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","’Riosia, ahpo Riosiwarie paaeria apochi oowe e'reka e'enekameopua, cheriwiame puuua pu'kao. Nape aaata ki nakikameo ahpo Riosiwarie paaewao, kiisi cheriwepuamepua pu'kao. Nape ahpo paaeriao ahpochi paparameopua nakika, ihta ki kaaweruma iintorioipua pu'kao, yooma cheriwekemeripua pu'kao. ");
INSERT INTO var_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Riosia, no'o Tijoe Tijoetukame na'aretioopua, cheriwemapua pu'kao pehjio, nape ahpo Riosiwari chiia kiisi apochi uunarekameopua, kiisi cheriwemapua pu'kao, ahkasi ki wahjiamesi taawea, i'wa wehjoarichioi, Riosi weemera wehjoarichioi. ");
INSERT INTO var_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Eesusia simiteka masiteka ti'tijoeo ooweruopua tiameo, chaanekapua: —Eemea aamo nokayaa, itapiti kuuu taakiameka tiiamepua. Ka'karuma taakiame enesaa eemea, ka'karuma nokayame enema eemea. Nape ki ka'karuma taakiame enesaa eeme, ki ka'karuma enema eemea aamo yoorao. Ihtaoi kuuu taakiamea, taakiachi machiniamepua ihtanakoo, kaaweruma enesoo, ki kaaweruma enesoooi. ");
INSERT INTO var_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","¡Eeme pa'pariserooo, sayawe ti'tijoeee, kiisi ka'karuma eemea! ¿Achini iika ka'karuma naewata eemea kiisi ka'karumakaio? ¿Ki nane'riame eemea aamo iikachi tahpitika ki ka'karuma e'ra, nayewamekopua? ");
INSERT INTO var_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Kaaweruma tijoea, ka'karuma ahpo iikachi e'ra, nayewamepua. Ki kaaweruma tijoea, ahpo iikachi ki ka'karuma e'ra, nayewamepua. ");
INSERT INTO var_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Pukaepa neeea utewaeme aamo chaaniamepua, utewaeme aamo neesetomichioo, kiisi se'wika aamo masitemichioopua, ka'karumache. Wa'a te'teretomeri eemea, te'ta Riosi katewiachiopua taawechio, ahkasi nu'utioi ki kaawe chaachapa tiiameo, tuumerichekopua. ");
INSERT INTO var_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Te'ta Riosi katewiachio, yooma ihta aamo chaachaparia aamo noonowiria tiame katewemeripua. Yooma ihta aamo noonowiria teteiwachi iintapaka, chanimapua aamoo kaawerumakoo, aamo ki kaaweruma enesooiopua. Waika kateweniachio, ahpo chaachaparichi wa'a kateweniachi chapisipuamepua waikao, ihta ki kaawe iintokame enesoo, kaaweruma iintokame enesooiopua, wa'a nane'repuame eemea. ");
INSERT INTO var_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Waikao pukeri e'enakame ookapi pariseroa iyoteri ti'tijoea tiame, chaachapakapua Eesusio: —Masitari, aamo itapiti peenia ihsiwa tetewinare teemea. ");
INSERT INTO var_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Nape Eesusia chaanekapua pu'kao: —Ehpiami ehpe taawechiami mochikame ti'tijoe ooweru tiamea, no'o peenia ihsiwache tetewinariamepua, nape ihji ti'tijoeria, ki tetewitepuamepua wa'asi itapiti Riosi peenia ihsiwaeopua, naatiche tetewitepuame puuua, Riosi iintoriachiche, ehkoriami Oonasichi. ");
INSERT INTO var_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Ehkoriami Oonasia, kiiya paika taawe tukawari tiame weruma pawesochi topachi yasariaipua ko'kotiameo, ahkasi yo'yotiaiopua eenechi ahjakame. ");
INSERT INTO var_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Níniwe ehkoriami mochiriamea kateweniachi taawechio, Oonasi cheeria pichikekamea, Riosichi aamo wenejimapua, ki no'o pichikiopa Riosi paajutewaopua. Pichiwa aamo chaaniamenia, neeea aamo nayewiaa epeche ki nu'uti tiiamerapua, ki ehkoriami Oonasichitia. ");
INSERT INTO var_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Wa'achi iintomeripu yawichi oowitiameai, yomatiame Tetuyachi weee yawichituka kahtiameai, Riosichi aamo wenejimeripua, te'ta Riosi katewiachio; puuu oowitiamea kai waapi siinka Riosichi paparakamekapa, ahkasi ehkoriami Saromoni yawichi kahtiachisi eenakamekapa, Riosichi kaaweruma tuuyewari i'yasikao. Nape eemea pu'ka oowitiame iintoria noonoimitiooi, kiisioi no'o keepunariamepua, no'oo, aamo nayewiameo, epeche tísia werumakoipua, ki puuu Saromonichitia. ");
INSERT INTO var_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Eesusia ti'tijoeri simiteka nayewekaopua, chaanekapua pu'kao, nape wa'achitarichi naewakao, eee chaanekapua pu'kao: —Aaata tijoechi oowitiamechioi machenasaa na'araria, wahka oiyai wakiwechi ooruchiamio, tísia aiwaka ki tewakapa ahpo ohjoeka resipumiachio, erapame puuua: ");
INSERT INTO var_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","“Ohso kaawe eenechi no'ramania, no'o yasariachi tijoechi.” Waikaopua eenechi ahpo yasariachi enasaapua tijoechio, kakupa ihpichitiachi enesoopua ahpo yasariachio, wa'a ohjoepamapua eenechio, ki Riosi Riosiwari enesoo wa'a ohjoemeo. ");
INSERT INTO var_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Nape eenechi wa'a enasopua ohjoemiao, oowisani yeeka enameripua wa'a ohjoemiao, epeche nanaarame ki ahpochitia. Wa'a ikitiaa ihji tijoea, epeche teeremeri ihjia apochio na'ararieo, ki pukerichitia. Wa'achi ikimeri ehpe taawechiami tísia nanaaramea, ki apochi yachatoka ohjoamea Riosi Riosiwario. ");
INSERT INTO var_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Eesusio, iiweta yooremina ihsioipua tijoe nayewekao, ma'chio, wa'a eenaria Eesusi yeeyeraa, Eesusi poponira ahjama pipinira tiame. Ihjia Eesusi ahjama nayewanariame eneriapua. Wa'a ajakoiopua pehjio ma'chi, tamochi eenakapua aaata Eesusi tuuyemeri. ");
INSERT INTO var_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Puuua, chaanekapua Eesusio: —Aamo yeeyea, aamo poponi aamo pipini ahjama weeriamepua ma'chi, aamo ahjama nayewamia puuyeka. ");
INSERT INTO var_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Nape Eesusia ahpo tuuyekameo, chaanekapua pu'kao: —¿Aatanakamerajuarepu te'ta no'o yeeyea, te'ta no'o poponia pipinia tiame? ");
INSERT INTO var_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Waikaopua ahpo masiterakamera ma'majoekao, cheekapua: —¿Ki ihjikosapu no'o te'ta yeeyea, no'o te'ta poponia, no'o te'ta pipinia tiame? ");
INSERT INTO var_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","No'o te'ta tetejimaa, yooma aaata no'o Noono yorajera yooraka mochitoamera puuua. ");
INSERT INTO var_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Eesusia pu'ka wa'api taawechiopua, wa'a wa'api ta'pechiopua, yooremina machenakaopua weruma neeroi maaniachimina yasipakapua, neerosuwe. ");
INSERT INTO var_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Wa'aoi ki ookapi napawiriopa ti'tijoerio, pawekakerachi mooenakapua waikao ti'tijoeri nayewemiao, puuu ti'tijoea oowerua tiamea, pa'wesuwe itipikapua. ");
INSERT INTO var_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Wa'a yasipasaopua waikao, ki ookapi itapiti nayewekapua ti'tijoerio, itapiti wa'achitarichi, puuua o'inekapua cheeka: —Piiripi echayamea tiiriko echimia simiriataipua. ");
INSERT INTO var_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Nape echimiaiopua, poowechi ruhjiteriataipua ookapi iimorio. Pu'kao tuchikia wa'a e'enakao, yooma pepeka ko'kariatapua pu'kao. ");
INSERT INTO var_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Wahjachi iimoria, tehteekachi ruhjiriataipua ki tunakame kahtiachi weee. Puuuai ikanati yaupariatapua yaupao, nape waitiamekopua weeeo, ");
INSERT INTO var_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","taaa taipasoopua, ikanati wakipateriatapua pu'kao, ki teeresi naawatakamekopua pu'kao. ");
INSERT INTO var_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Puuu iimoria paikapichio, wehchaekachi ruhjiriataipua. Pu'kao wehchaa, yaupakoipua weweripakao, wi'ropateka wakipateriatapua pu'kao. ");
INSERT INTO var_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Nape wahjachi iimori kaaweruma weeechi ruhjikamea, tísia kaawe taakeriatapua; ihji piiripi pahchiraa, piie siento pachitariatapua taakekao; wahjachi pahchiraa kaawe taakekamea tiame, paika weerewa pahchi taakeriatapua pipiripi pahchira iimori; epeche ki weeka taakekamea, piie weerewa aampa oosa mariki taakeriatapua, piiripi pahchiraa. ");
INSERT INTO var_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","I'ka pahtenariamea, kaawe inataka i'yewa nakiyamepua. ");
INSERT INTO var_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Waikao Eesusi masitewaraa, naaepaka iinatukekapua: —¿Achinikai wa'achitarichi nayewekamua ti'tijoerio? ");
INSERT INTO var_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Eesusia pu'kao, cheeka nehjiakapua: —Eemea kiatiamepua pu'kao aamo nane'repuao, itapiti Riosi iinuekaopua aamowichioo, Riosi apoeo noriwi iinuekaopua pehjio, nape aaata ki no'o oowe e'rekache keepuamea, ka'ipua. ");
INSERT INTO var_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Aaata Riosichi simiyame nane'renariamea, epeche nane'retepuamepua Riosieo, ahkasi ki ookapi Riosi oowe e'ria kiapuaopua. Nape aaata oowera no'o na'arenareka keepuamea, kihta pahtewari kiapuamepua; pu'kao, teesa ahpo pahteriaoi, u'yepuamepua. ");
INSERT INTO var_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Pukaepa ki Riosichi te'terenariameo, wa'achitarichi masitiamenia pu'kao, pu'kao no'o keepuaio, oowera ki pahteka itipimichiopua; ne'niaio ki tetewika itipimichiopua, pahtewario. ");
INSERT INTO var_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Wa'a iikaopua ihji ti'tijoea, Isaia iyoterichi cheeriachitia ikiyamepua, ehkoriami Riosi nayewaturachi cheeriachitia; Riosia Isaiachi naewakaopua, cheeriaipua: Nape ihji ti'tijoea keepuaio, ki pahteka inamumeripua; ihji ti'tijoea tetewaio, kiisi pahteka tetewimeripua. ");
INSERT INTO var_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Ihji ti'tijoea kiisi pahtenariamepua; ihji ti'tijoea ahpo nakachio, to'peraemepua; ihji puichiopua tiameo, kiisi pahteka tetewame enepakamepua. Wa'a te'tiapa ihji ti'tijoea, Riosichi simiyameo, kiisiki pahteka tetewamepua, tetewai; inamukai kiisi pahteka inamuamepua. Ihji ti'tijoeri noochi e'enaka pahtekame enesoopua tiameo, cheriwemii neeea pu'kaoi, puhjekaopua tatakorirao. ");
INSERT INTO var_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Eesusia simiteka naewakao, taamo chaanekapua ahpo ajawariao: —Nape eeme no'o pahtenariamea, te'ta kaawe te'terenariamepua Riosichio, no'o kaawe keepukamea masitiao, pahteka tetewinariamea pu'kao, pichikekamekapapua tiameo, noochi paparawao. ");
INSERT INTO var_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Ihjia tísia pichiwa tiiamepua, muuwaeme ehkoriami Riosi nayewatukamea, ka'karuma enepakamea tiame, waika taawechiami mochiriamea, tísia tetewinareka mochikaipua tiameo, i'ka ehpe no'o aamo tetewika mochikao, wa'atia wahjipakamepua ki no'o tetewika. I'kachi tísia inamunariame eneriaipua tiameo, i'ka ehpe taawechiami aamoo, aamo no'o keepuka mochitoao, nape wa'atia wahjipakame puuua, ki no'o inamuka masitia. ");
INSERT INTO var_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Wa'a cheeka kajusaapa Eesusia, taamo chaanekapua: —Ehpeo echayamechi simiyame aamo ma'chitemania. Kaawe keepumitiao eeme. ");
INSERT INTO var_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Puuu iimori pooechi ruhjikamea, Riosi kaaweruma tuuyewari puuua, tijoe peewaeme iikarachi echitiame. Riosi ye'karichi simiyame inamukaipua, ki pahtekamepua riaorósie u'yetiapapua ahpo pahteriao, ahpo iikachi echitiameopua kaaweruma tuuyewari. ");
INSERT INTO var_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Puuu tehteekachi ruhjikamea iimori, kaawe e'raka inamukamepua inamuao pu'ka Riosi kaaweruma tuuyewario, ");
INSERT INTO var_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","nape ki pewatiame weritokamepua Riosichio, ki teeresi naawaekapa Riosichio; ikanati kokosa yooraka naanaritoniapaopua, towayamepua Riosichi ahpo paparariao. ");
INSERT INTO var_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Puuu wehchaekachi echitiamea iimori, kaawe e'raka inamuamepua inamuao Riosi kaaweruma naawesario, nape tísia ahpo toomituwa inatapapua i'ka weeechi iintuameo, ahpo si'ritiamepua pu'kaeo. Yooma ahpo Riosichi simiyame ahpo masiteretiaopua, wa'a iikapapua pu'kao yooma toayamepua. Wa'a iikapa puuua yooma Riosichi simiyame ahpo keepuriaopua penipaka, kihtawichio kaawe eenekame puuua. ");
INSERT INTO var_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Nape kaaweruma weeechi ruhjikamea iimori, puuua pahteka inamukamepua pu'ka Riosi kaaweruma tuuyewario. Ihjia, ka'karuma weeka muuwewa iintomeripua Riosiwichioo, itapiti echitiame ki ookapi taakekamechitia. Ookapi ihji ti'tijoea, tiiriko muuraraka tísia muuwekameka teerekamepua, piiripi iimoriopua, piie weerewa aampa oosa mariki taakekamepua pipiripi pahchirakai, wahjachi ihji tiiriko iimoria, paika weerewa muuwekamepua pipiripi pahchirachiopua muurekao; epeche wahjachi wa'asia, piie siento pahchira pachitakamepua pipirepi muuraraa. ");
INSERT INTO var_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Eesusia piirechi wa'achitarichi nayewekao, chaanekapua: —Riosi ye'karichi mochipuamea, tiiriko iimori echitiameka ikiyamepua. ");
INSERT INTO var_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Aaata tijoe teekoraa kaaweruma iimori tiiriko echanurariataipua ahpo wasawachio, nape seepurawaa yoomahka kokochinioio, wa'a eenakao tukaoo, tiirikotui ki kaaweruma eecheriatapua tiirikochio. ");
INSERT INTO var_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Waikao ihji ki kaaweruma tiirikotuiai tiiriko yaupariachio, wa'achi yaupaka weweripariatapua tiame. ");
INSERT INTO var_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Waikao tiiriko ne'nemia enanioipua, pachitariatapu tiirikoapa, tiirikotuiapua tiamé. Wa'a tiiame tewakapa ahpo teeko tekipanakiamea, ahpo teeko ne'nemia siimpariatapua tuuyemia, ahpo teekochi ajasisaapua chaaneriatapua pu'kao: “¿Ki ka'karumakosa iimori taamo ki'yakamemua echipuawichioo? Tahpitika tiiapu tiirikotuia tiirikochio, ¿aatia wa'a tiiarepua?” ");
INSERT INTO var_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Waikao teekoraa chaaneriatapua: “Aa puuua, aaata no'o seepurawa iintoriapua, taamo echariao, tiirikotui ki kaaweruma pahchira ipasekao”, cheeriatapu teekoraa. Tekipanakiamea waikao chaachapariatapua: “¿Napotare teemea pu'kao?”, chaachapariatapua. ");
INSERT INTO var_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Waikao teekoraa cheeka nehjiariatapua: “Ka'i, wa'atia toipuapua pu'kaopua pehjio, tiiriko ahjama po'tamaoipu —cheeriatapu teekoraa—. ");
INSERT INTO var_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Wa'atia toipuapua pu'kao pehjio, ahkasi tiiriko i'ipapuachisi. Ahkasi waika, naponuremania pu'kao, pu'ka tiirikotuio, patuka purisa kosimania pu'kao, tiirikochi poanatasaopua —cheeriatapu teekoraa—. Tiiriko ki tiirikotuiekachi i'ipatiameo, tiirijomachi katewemania pu'kao”, chaaneriatapu teekoraa ahpo tekipanakiao. Wa'achi yoorapuame ti'tijoeai, Riosi katewiachi taawechi, asisoopua. ");
INSERT INTO var_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Eesusia i'ka wa'achitarichi nayewekaopua tiame, cheekapua tiame: —Riosi ye'karia wacherai tewaniame kuuu pahchiraka tiiamepua. ");
INSERT INTO var_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Ihji wacherai kuuu pahchiraa kiisi werumakaipua pahchira, ki nu'uti kuuu weripamekaitepua, ahkasi tuchikiai muuwaeme ta'sotachi wa'a nu'nunti atowarachi. Wa'achitia Riosi ye'karichi mochimeria, ki nu'uti mehtamiitepua, ki ookapi enepakao. ");
INSERT INTO var_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Eesusia wa'a tiame taamo nayewesopua, piirechi wa'achitarichi taamo nayewakapua eee cheeka: —Riosi ye'karichi nayewaniachio, Riosi kaaweruma tuuyewaria rewaruraka ihsiamepua. Aaata oowitiame teesa rewarura yahcheka wesosoopua paatusio, rewaruraa yomachi muika weruma a'potiamepua paatusio. Wa'achitia Riosi tuuyewariai, yomachi wehjoarichi mu'ipaka tuuyetowatiaopua, ki nu'uti enepatiamepua Riosi ye'kario, Riosichi paparakameeopua. ");
INSERT INTO var_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Eesusia yooma i'ka ahpo masiteria ti'tijoerio, wa'achitarichiche ahjae masitekapua pu'kao, ki wa'achitarichiopua, kihta. ");
INSERT INTO var_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Ihji Eesusia wa'achitarichi naewaniamea, Riosi ehkoriami ahpo nayewaturachi cheetiamepua, waika taawechimio, cheeriaipua: Wa'achitarichiche nayewema neeea; itapiti nayewatupuame no'o noriwi teereriopua, ahkasi Riosi i'ka wehjoari mochiwachio, yahchariachisi. ");
INSERT INTO var_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Waikao Eesusi toisoopua ti'tijoerio, wa'api karichi muitiapua waikao. Wa'a muitioopa teemea, iinatukekapua Eesusio: —¿Aachin cheeka chanikamua to'iwe naewakao? Naane e'renare teemea Masitari. ");
INSERT INTO var_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Waikao Eesusia taamo nehjiakapua cheeka: —Puuu kaaweruma iimoria, Riosi kaaweruma tuuyewari echayame puuua, echayamea neeepua, Riosi Tijoe Tijoetukame. ");
INSERT INTO var_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Waasa echiwachio, yoomatiame wehjoarichi ti'tijoeri puuua. Puuu ka'karuma iimoria, ti'tijoe puuua Riosi ye'karichi mochitoame. Puuu ki kaaweruma to'iwea, ti'tijoeri nanaarame puuua, ki Riosi ye'karichi mochimeri, Satanasi ijinuwarakapa. ");
INSERT INTO var_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Puuu ki kaaweruma to'iwe echakamea, riaorósi puuua. I'ipaniamea, i'ka yomatiame weee kajuyachi teeremeri puuua, te'ta Riosi katewiachi wa'asi. Puuu echitiame i'ipameria, tewekachi Riosi ku'iwari e'enameri puuua. ");
INSERT INTO var_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Puuua ti'tijoeri ki ka'karumaopua, to'iwe ki ka'karumachitiaopua, yooma patuka poanatasaopua, ihpapaka na'ichi kosimapua pu'kao, ki teesa aiwaniachiopua. Wa'asa teeremerikapua i'ka yomatiame wehjoari kajuyachiopua. ");
INSERT INTO var_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Neee Tijoe Tijoetukamea waikao, tewekachi mochikame no'o ku'iwario, yomatiame wehjoarichi uhjuramania, no'o ye'karichi ki ka'karuma ti'tijoeri wa'a mochikameo, yooma puuyanamichiopua, ti'tijoeri ka'karuma tatakoritameopua. ");
INSERT INTO var_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Wa'a ikisaopua, yooma pu'ka nanaarame aaata tatakoritameopua tiameo, na'ichi ihpapamapua ooronachi. Wa'ao puuua, tísia aiwameripua tajakao, tísia naarakomeripua tísia aiwapao; kiisi anachapa aiwakaopua wa'ao, tahpitika chanimapua taamera ki'sukao, ki teesa tiiame aiwapa puuua Riosi kokosario. ");
INSERT INTO var_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Waikao Riosi te'ta weruma katewiachi u'matosoopua, yooma ti'tijoea ooweruaiopua tiamea, Riosi te'ta nakiyachitia noonowikamea, yooma te'ta Riosie piipatetiamea, tisiwa kaawe erakomeri puuua, taaachitia peenia tiame tajayamechitia, no'o ahjama mochikapapua no'o Noono ye'karichio. Epeche pahtenariame enesaa yooma aamo no'o nayeweriao, tísia kaawe inataka i'yepuapua pu'kao, tísia pahtewari nakimerikopua aamoo, aamo masiteka ohjoachiopua. ");
INSERT INTO var_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Pu'ka to'iwe ki kaaweruma wa'achitarichi nayewaka kajusaapua, eee taamo chaanekapua ahpo ajawariao: —Riosi ye'karia, weee toomi majitiame tísia nateyame iinuemeka tiiamepua. Aaata nane'resaapua tísia nateyamekopua pu'ka weeeo, ahpo ta'pe no'rakaopua, yooma nehjimapua ahpo iinuekao, ahkasi ahpo kariwaoipua tiame. Pu'ka nejisaapua pu'ka toomitutiameopua, pu'ka toomitutiame i'toka siimapua, pu'ka tísia nateyame weee ahjae tarimiaopua. Pu'ka weee tarisaopua, tísia kaawe eramapua waikao, ahpo tarariachi yasakao. Wa'achi iintomeri aaataa, ki teesa te'ta nateyamechitia tetewamea, Riosi ye'karichi yasiwao. Te'ta Riosi chiia e'weka yasitoma puuua, Riosi ye'karichi ahpo yasipoa reesisepuawichioopua. ");
INSERT INTO var_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Eesusia weee wehtere toomichi simiyame kajusaapua nayewakao, chaanekapua taamoo: —Riosi ye'karia, perera ki teesa nateyamechitia tiiamepua. Aaata perera tarayame, ");
INSERT INTO var_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","perera tísia nateyame tewisaa, ahkasi yooma ahpo iinueka toomichi nehjisaopua, tarimeripua pu'kao. Wa'achitia aaata tijoea oowitiameai, tísia nateyamechitia tetewikameapua Riosi ye'kario itapiti pererachitiao, yooma Riosi ahpo nuuria yooraka yasitoma puuua, Riosi ye'karichi yasipoa kiapuawichioopua. Wa'a tiiame inatari masitemitia eemea, ahkaoi aamo masitiachiamio. ");
INSERT INTO var_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Perera wa'achitaka nayewasaopua, sochichaira wa'achitarichi taamo nayewekapua, eee cheeka: —Riosi ye'karichi muimeria, sochichairae pa'wechi chapiwameka ikiniamepua. Yooma ka'karuma so'chi, ki ka'karuma ahjama tiame chapisaopua, ");
INSERT INTO var_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","suuwerachi upasaopua, poanataka uuka ka'karumarao, ihpapaniamepua ki ka'karumao. Yooma ka'karuma uusaopua, weruma waarichi toaniamepua. ");
INSERT INTO var_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Wa'achi ikipuamepua, i'ka wehjoari kajuyachiopua. Waika taawechio yomatiame wehjoarichi ti'tijoe ooweruopua tiameo, Riosi ku'iwari tewekachi e'enakamea, yooma ka'karumara uusaopua, ");
INSERT INTO var_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","ki ka'karumao na'ichi ihpapamapua pu'kao ooronachi, wa'ao tísia naarakomiachio, na'ie tajaka ki anachapaopua, tahpitika cheemeripua taamera ki'sukao, tísia kokosa tiame aiwakaopua. ");
INSERT INTO var_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Wa'a cheesaapua Eesusia, taamo iinatukekapua ahpo ajawariao: —¿Pahteka inamukame eeme i'ka no'o cheeriao? —Eje'e —chaachapakapu teemea. ");
INSERT INTO var_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Waikao Eesusia ki ka'karuma toiwamechi simiyame taamo nayewekapua, piirechi wa'achitarichi. Puuua pu'ka wa'achitarichio, eee taamo chaanekapua: —Aaata Riosi ye'karichi tiiame masitiamea, aaata kariwaemechitia tiiamepua, ahpo ijinuwa to'wachi ka'karumache poanataka uuyamechitia, ki ka'karumao ki uuka. Wa'achitia Riosi kaaweruma tuuyewari ma'masitariai, poanatameripua oochetiame Moisetaru masiteria nokiwameopua, Riosichi te'tereretiao, weemera Eesusi masitiachitia, te'terepuawichioopua, pu'kakamera masitemeri Riosichi simiyame ma'masitaria, oochetiame Riosichi te'tereretiaopua, toaka. ");
INSERT INTO var_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Eesusia kajusaapa yooma pu'ka wa'achitarichi taamo nayewekao, wa'a Ooriwo roomosachio, wa'a chaachapaka taamo masitenurakapua, ahkaoi taamo masiteka ohjoachiopua. Waikao Ooriwo roomosachi o'iniao, Eesusi nu'utikai weripariachi, nonoratiapua Kapenau tewaniachi. ");
INSERT INTO var_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Eesusia Kapenau ajasitioopua, wa'a napawikarichi pakikapua, i'isaeri napawikarichi. Wa'a masitekapua waikao weesa, senepi taawechi. Wa'a napawikarichi nanapawiamea, tísia peenia erakokaopua, chaachapakapua ahpoo: —¿Akatia penipakamejoarepua, ahpo tísia peenewariopua, ahpo tísia peenia ihsiaopua tiame? ");
INSERT INTO var_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","¿Ki ihjipu tijoe, i'wa mochiwachi ma're sipaka itapiti neteyame, taanara? ¿Ki Maaria tewaniamepu yeeyeraa ihji? ¿Ki puuu poponirapu Saantiaoa Oosea tiame, Siimonia Uurasia tiame? ");
INSERT INTO var_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","¿Ki i'wa ohjoepu pipiniraai, i'wa taamo mochikachi? ¿Achini ihsika tísia machiyame enepariarepu? ");
INSERT INTO var_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Pukaepa Eesusia ki ahpo yoorenariopao e'wekao, chaanekapua pu'kao: —Riosi nayewatuamea, yomachi kaawe tetewiniamepua, nape te'ta ahpo mochiwachiopua, ka'i. ");
INSERT INTO var_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Ki apochi pichikiopa wa'a ti'tijoerio, paikapi ki weeka peenia ihsiwa wa'api ihsikapua wa'ao. ");
INSERT INTO var_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Pu'ka taawechiamio Eeroreo, Arireasi yawichikoio, tísia peenia ihsiame inamukapapua Eesusio, ");
INSERT INTO var_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Eerorea cheeriapua ahpo nuurewao: —Puuu Eesusia, Waanitaru puuua eenechi ahjakame, weruma utewari yahchaka eenakame. Pukaepa peenia ihsika oiyamepua —cheere Eerorea. ");
INSERT INTO var_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Eerorea me'yakamekapapua Waanio, eenechi oijenakame maaeriapua, apoe kaarenae o'yaeka yahchakamekapapua karichio. Eerorea wa'a iintokame Waanio, i'ka Waanio ahpo wenejika naewakopa, kiisi kaawe iintorio tuukaopua Riosichio, ahpo pa'chi uupira ahjama neewikaopua. Eeripea Eerore pa'chira eneriaipua, Eroria kuunaraa. ");
INSERT INTO var_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Waania chaaneriaipua Eeroreo: —Muuua aamo pa'chi uupira uupitariapao, kiisi yoorekamemua Riosio, tísia tatakorikamemua Riosichio. ");
INSERT INTO var_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Eerorea pukaepa waika taawechiami merimo o'rariaipua Waanio, nape ki me'yariaipua pehjio, majawiapa Waanimina ti'tijoeriopua, Riosi nayewaturachitia tetewameopua. ");
INSERT INTO var_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Nape Eerore paamupari paamuachiopua pahkochio, ahpo piisimarara machenasoopua yawimia yooma paajutetiame mochikachiopua tetewachi, tísia pu'serekaopua ahpo piisimarao, u'matome chaacharepua tísia teekupakao. ");
INSERT INTO var_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Pukaepa ahpo piisimaraopua, chaanerepua: —Nee, ihtaoi no'o itanekooio, aamo kiamache neeea, kiisi wihtuka chiiamenia. ");
INSERT INTO var_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Waikao piisimararaa ahpo yeeye cheerewachio, chaanerepua Eeroreo: —Waani Paatori merisa no'o kiamitia naaju, pehtorichi yachasa mo'orao —chaanerepua Eeroreo. ");
INSERT INTO var_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Waikao Eerore yawichia wa'a chiiame yoomae inamutiapao, yuuwesiparepua erapakao: “Ki wa'a cheeme teeeriainia naaju.” Nape Eerorea yooma ahpo paajuteria tetewachi wa'a iintomo tuukapao, kiisi wa'a iintomo e'raipua, wa'a iintoriapua. ");
INSERT INTO var_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Waikao Eerorea yeetepatiame yahchaipua Waanio kaarenae o'yaekao, mo'ora tehpunasa u'yepanurarepua, itapitichi oowatoka. ");
INSERT INTO var_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Waikaopu piisimararaa pu'ka u'yepatiao, ahpo yeeye ki'yarepua. ");
INSERT INTO var_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Wa'a iintosoopua Eeroreo Waanio, wa'a e'enaka Waani na'naritoamea meritiachio, i'ka weerewara i'tokao, wetemajirepua. Wa'a noonoisaapua, Eesusi tuuyemia siimparepua. ");
INSERT INTO var_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Eesusia Waani ikiria nane'resapao, tísia yuuwesipakaopua poanachi siimo orapakapua piineri tiiachi. Waikao pawekakerachi mooenasaopua, pukachi simitiapua. Nape ti'tijoea nane'rekapao, muuwaeme na'naritoriapua pa'we suuwerachikoopua ma'chi, ahkaoi yooma mochiwachiami ahpo yeetopasikao, muuwaeme enepasiriapua. ");
INSERT INTO var_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Eesusi tekimiachi asisaapua, ki ookapi muuwekame mochiriapua wa'ao, ti'tijoeri. Waikaopua wa'a noonowiriame tewakapaopua, tísia tesiwa e'repakapua pu'kao, wa'a erapakaopua, yooma kokoriame u'pariaopua, sautekapua. ");
INSERT INTO var_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Aari enepasoopa wa'ao, teeme Eesusi ajawariaa Eesusi naaepakao, chaanekapua pu'kao: —Paamira, ariwatonapa wa'asi, mehka ki'tiachi mochiwachi i'wao. ¿Ki kaawe ohjoare ti'tijoeapa nonoraputia, aapoe kooame i'yamichiopua mochiwachiamio? ");
INSERT INTO var_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Nape Eesusia taamo chaanekapua: —Ka'i, ki nonoramerinia pu'kao. Eeme wa'api ko'kotemeripua pu'kao. ");
INSERT INTO var_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Waikao teemea Eesusi masiteraa, chaachapakapua: —Nape teemea, mariki paani wa'api itipitiamepua, ooka so'chi tiame. ");
INSERT INTO var_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Waikao Eesusia taamo chaanekapua: —Ehsoo, no'o u'yepaopua pu'kao. ");
INSERT INTO var_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Wa'a cheesapa Eesusia, wehchi mochipanurakapua ti'tijoeo ooweru tiameopua, paachi. Waikaopua, pu'ka mariki paani uusaopua ooka so'chiopua tiameo, te'pa ne'nepaka cheriwema kiasaopua ahpo Noonoo, taamo ki'yakapua pu'kao, taamoo naachutamichiopua. Wa'a ikitiaapua yooma ti'tijoeri naachutekapua. ");
INSERT INTO var_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Waikao yooma ahka ko'kakapua ahkasi poposaniachisi. Ehjepao ko'kotiame soparakameo, oosa mariki aampa ooka weeweruma waari na'poatiapua pehji, chi'wapame. ");
INSERT INTO var_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Wa'a ko'kakame ti'tijoea, mariki miirikapua, ki ihtetaka ooweruopua kukuchioipua tiame. ");
INSERT INTO var_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Waikao pu'ka muuwari ko'kotesaopua Eesusia, taamo paonamina uhjurakapua pa'wechio, pawekakerachi taamo mo'moenapuka. Wa'a taamo uhjurasaopua apoeo, ti'tijoe nonorapuka itipikapua pehjio. ");
INSERT INTO var_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Yooma nonorapusaapa Eesusia ti'tijoerio, teewi kaawitiachite akipariapua ahpo Noono ahjama nayewamia. Tukapasipoiopua pehjio, iiweta wa'a ihsiriapua piineri. ");
INSERT INTO var_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Wa'a keenakoopua teeme masiteraa, paaomi nokisiniapua wa'asi. Nape tísia ekayopao, tísia pe'kosiopa pa'weopua tiameo, tehki nokisiapua wa'apoo. ");
INSERT INTO var_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Marikarowaopua Eesusia, taamo nokisiachipo eenakapua nerojampa weritoka. ");
INSERT INTO var_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","I'kao nerojampa weritopao, tísia majakao chaachapatiapua: —¡Wéiii, naayuripu puuua! ");
INSERT INTO var_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Nape Eesusia taamo sisinamukao, taamo chaanekapua: —¡Ka'te majakoo, oisa erapasa! ¡Ka'te tahpitika erakoo! ");
INSERT INTO var_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Waikao Peeroa sisinamukapua tiame: —¡Paamiraaa, pichiwa Eesusi enesaa no'o Paamira, nerojampa weritoka no'o aamo natepatemitiapuaaa! ");
INSERT INTO var_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","—¡E'esaaa iiyetasao wa'anaaa! —chaanekapu Eesusia. Waikao Peeroa pawekakerachi o'inia niipakao, nerojampa o'inekapua simika, Eesusi natepamia. ");
INSERT INTO var_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Nape Peero nerojampa ihtoaiopua tísia ekayopao, tahpitika erapakaopua piwiteme teetoapa. Waikao sisinamukapua Eesusio, cheeka: —¡Yaapitiii, no'o ku'isaaa! —cheeka sisinamukapua. ");
INSERT INTO var_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Waikao Eesusia, Peero inisiachi asikaopua, ikanati sekachi chapitokapua, chaanekapua Peeroo: —¿Kiisi noochi paparame muuua teesaoi? ¿Achini iika wekakame muuua noochi paparao? ");
INSERT INTO var_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Wa'a cheesoopua Eesusio, wa'a pawekakerachi mooenasacheopua Eesusia, teewetekapua tísia ekayao. ");
INSERT INTO var_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Eesusio teewetesoopua eekao, teeme pawekakerachi mochikamea, chopokorieka ajapekao Eesusio tísia iyorikao, chaanekapua Eesusio: —Muuua pichiwa tewekachi o'inia eenakamepua, Riosi weeechi eenaka Tijoe Tijoetukame. ");
INSERT INTO var_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Wa'a neerochi paonasaapua teemea, Eenesare weeechi tetekitiapua. ");
INSERT INTO var_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Waikao wa'a ohjoemea Eesusikoopua wa'a eenakameo, muuwaeme u'yepatiapua kokoriame. ");
INSERT INTO var_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Eesusio tesiwa chaachapopa, ahpo wisasori suuwerachioi ihchepapua itanekapua. Wa'ao waikao, yooma Eesusi wisasoriwachi ihchepakamea, saukame nonorakapua ahpo ta'pechiamio. ");
INSERT INTO var_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Ookapi Eerusareni e'enakame parisero ti'tijoea, ookapi iyoteri ti'tijoeapua tiamea wa'achi e'enakame, Eesusi naaepaka iinatukekapua: ");
INSERT INTO var_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","—¿Achinikai ki paanikosa koayame aamo masiteraa, taamo pa'pamiratuameo masitiachitia? ");
INSERT INTO var_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Wa'a chaanetiapao Eesusia tiame, iinatukekapua pu'kao: —¿Achinikai eemea aamo pa'pamiratuamekamera nokaya, inatamepua yoorepuameo, ki Riosi nuurari yoorepuamekamera? ");
INSERT INTO var_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Riosi nuuraria eee chiiamepua: “Yooreka yasitopuapua aamo yayawao; ki yooreka yasitokamea pu'kao, mukimachepua.” ");
INSERT INTO var_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Nape eemea chaachapamepua aaatao, ahpo yayawao chaachapamichiopua: “Yooma no'o iinuekao Riosichewichiopua, wa'a tiiapa neeea ka'chi iika aamo ku'imetenia.” ");
INSERT INTO var_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Wa'a chaachapakao eemea, wehchi ipaka tetewame eemea Riosi nuurari iyoriwao, aamoe wa'apiche nokiwa yoorepuawichiopua na'naritoka. ");
INSERT INTO var_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Eemea, ¡“wisikuarikamera erakoai”!, chaachapamepua aamo masitiao. Wa'a aamo nokimiao, ma'chiame cheeriai Riosia, ehkoriami Isaia iyoterichiopua, eee cheeriaopua: ");
INSERT INTO var_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Ihji mochiwaria no'o kaawe chaachapanipua chaachapao, nape oowera chuwaeche, nape ahpo iikachiopua kai waapi mochikai chaachapamepua noochio. ");
INSERT INTO var_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Puuua wa'a nokayamea, kihta no'o iyoriwa nokayamepua, oowera ti'tijoeche nokaya masitiamepua, ki Riosichi eename nokipua. ");
INSERT INTO var_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Pu'ka kajusaapa naewekao Eesusia, ahpo wapichuri ajapanuresaopua ti'tijoeo ooweruopua tiameo, yoomahka taamoo, chaanekapua: —Pahteka inamumitiapua i'kao: ");
INSERT INTO var_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Aaata chu'wachipo rupituniamea, kihta ki kaaweruma chuhkiamepua aaatao; aaata chu'wachi chiia machenakamera, na'atamepua pu'ka aaatao, tatakoriwatekao. ");
INSERT INTO var_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Neipa taamoche ahjama kahtioi Eesusio, teeme masiteraa chaaneka iinatukekapua Eesusio: —¿Nane'rekamua pariseroo, aamo wa'a chaanesoo, nekamuka inamurio? ");
INSERT INTO var_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Nape Eesusia cheeka nehjiakapua: —Pe'yachipua. Yooma puuu ki no'o Noono ahpowichio uuriao, ihpapameripua, itapiti to'iwe ki ahpo echariachitia, po'tanaka ihpapaniamechitia. ");
INSERT INTO var_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Ka'te pichikemitia eemea pu'ka parisero ti'tijoe masitiaopua. Puuua ki mamachiriai, aaata tukapachi ohjoameo, neesetoka panitonariamepua. Wa'a te'tiamea aaata panitoaiopua wichipasaa, wichipatemapua tiame ahpo panitoaoi. ");
INSERT INTO var_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Waikao Peeroa chaanekapua Eesusio: —Kaawe taamo tuuyeomua pu'kao, chu'wachi machenamechi simiyameopua, aamo naewariaopua. ");
INSERT INTO var_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Nape Eesusia taamo chaanekapua: —¿Naakona iiweta ki pahtiame eemea pehji? ");
INSERT INTO var_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","¿Ki nane'rena eemea yooma chu'wachi rupituniameo, topachi eenamekopua, wa'a ikisaopua eenechi machenamekopua weerewachio? ");
INSERT INTO var_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Nape chu'wachi machenamea taamo nayewa, iikachi eenamepua, puuukamerapua taamo na'aratiamea. ");
INSERT INTO var_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Ihji na'arari itapiti, tijoe iikachi o'inia machenakamea ihjipua: ki kaaweruma e'raniamera, tijoe ko'inarewa, suwepori nokinarewa, ooweru ikotuwa eraniame, ichikonarewa, wihtunarewa eraniame, na'ara chaninarewa. ");
INSERT INTO var_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Yooma puuupua ti'tijoerio ki ka'kaweruma enepatiamea; puuu ki paanikosa koi'wamea, kihta na'ara ikiwamepua iikachio. ");
INSERT INTO var_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Neipa wa'a o'inia puuyasaapua Eesusi ahjamao, Tiiro weeechiami e'enatiapua Siironi weeechi tiame. ");
INSERT INTO var_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Wa'ao piiripi oowitiame Kaanani weeechi ohjoemea, Eesusi sisinamukapua: —¡Paamira, ehkoriami Raawitaru oochiwaraa, no'o tesiwa e'remitia muuuaaa! ¡Reemoikamekapu no'o kuteweee! ");
INSERT INTO var_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Nape Eesusio kihta nehjiakopa pu'kao, teeme masiteraa, naaepaka utewaeme terijerakapua pu'kao: —Paamira, ¿achinikai ki te'yanimua pu'ka oowitiame aamo pukamina kichiwa cheesiameo? ");
INSERT INTO var_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Nape Eesusia taamo nehjiakapua chaaneka: —No'o Noonoa, isaeri mochikamechiche no'o uhjurakamepua, apochi simiyame tuuyemichioo, wa'ao po'wa wewekakamechitia, te'teriamekopa. ");
INSERT INTO var_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Nape puuu oowitiamea, Eesusi ihsiachi ahsesaopua, tísia ahpo tesiwa cheeka ahpo sautejerakao, chaanekapua Eesusio: —Paamira, taamo cheriwemitiapua no'o kutewe yachapatekao. ");
INSERT INTO var_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Nape Eesusia chaanekapua: —Ki kaawe iintomaoi neeea aamo ku'isaa, no'o Noonoeo no'o tetejimarichikamera uhjuratiamekapa pahcha, ku'imichiopua pu'kao. Kiisi kaawepu kukuchi ko'komiao, u'yesa chuhchuri kianiaapua pahchao. ");
INSERT INTO var_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Wa'a chaanetiapa oowitiamea, nehjiakapua: —Wa'atepua tiiao, nape chuhchuriai meesatere ruhjikameo, koayamepua. ");
INSERT INTO var_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Wa'a chiiopa oowitiameo, chaanekapua Eesusia: —¡Ai muuua, tísia paparamemua noochio! Muuua noochi paparakapao, te'ta aamo itayachitia ikimamua. Wa'a cheesoche Eesusiopua, saukame itipiriapu puuu kuteweraa. ");
INSERT INTO var_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Eesusia Tiiro weeechi machenasaapua, Arirea e'enatiapua pa'wechi. Wa'a pa'wesuweo, suuwerachitetu uumatotiapua. Wa'atetu nokisinioio roomosachite mo'moenatiopua, yasipaka Eesusia. ");
INSERT INTO var_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Wa'aoi muuwaeme napawikapua ti'tijoe ooweru tiame, chookopakame kokoriame u'yepaka, ki mamachiriame u'yepaka, rojomika ohjoame, ti'tijoe ni'o ooweru no'oopua tiameo, wahjachi ki ookapi itapiti kokoreniame tiame. Yooma pu'kao Eesusi chokichi upatioopua, Eesusia yooma sautekapua pu'kao. ");
INSERT INTO var_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Wa'a iintokopao Eesusio, ni'oo nayewatioopua, rojomio kaawe ohjotetioopua, chookopakameo sautetioopua, ki mamachiriameo tetewitetioopua tiameo, wa'a napawikame muuwaria, ki nu'uti kaawe erakoapua Riosio, tísia peenia Riosiopa Eesusio, isaeri Riosiwachio. ");
INSERT INTO var_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Eesusia ahpo kahtiachi taamo paaesapao masiterao, chaanekapua: —Tísia tesiwe e'renania i'ka ti'tijoerio, i'ka muuwari taamo ahjama nokayameopua, paika taawe i'toamekopaopua, kiisi iinueka kooameo. Ki wa'atia uhjuranarenia i'kao, ki ko'kotesao, toore wahjipamerikopua wahka pooechi nokisiaiopua. ");
INSERT INTO var_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Waikao teeme Eesusi masiteraa chaachapakapua: —¿Nape aatia nokaka tewitare teemea kooameo, i'wa kai waapi ki tijoeekachio, ki ookapi ti'tijoewichio ko'kotepuawichioo? ");
INSERT INTO var_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Eesusia waikao iinatukekapua ahpo masiterao: —¿Ihkina paani to'ame eemeapa? —Oowisani paani wa'api, ookapi nu'nunti so'chi tiame —chaachapaka teemea. ");
INSERT INTO var_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Waikao Eesusia yooma ti'tijoerio, wehchi mochipanurekapua. ");
INSERT INTO var_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Wa'a cheesaapua oowisani paani uusaopua ookapi so'chiopua tiame, te'pa ne'nepaka cheriwema kiasaopua ahpo Noonoo, chi'wanasa ki'yakapua taamoo masiterao. Waikao teemea masiteraa, ahkasi yooma ahsepachisi naachuteka teemea, pu'ka muuwariopua. ");
INSERT INTO var_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Ihjia yooma ahsepari poposatioiopua. Ko'kotiame soparakamea, oowisani weeweruma waari pochiwatiapua, yooma chi'wapameopua soparakame. ");
INSERT INTO var_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Kehki wa'a ko'kotiamea, naao miirikapua ti'tijoe, ki ihtetakaopua ooweruopua kukuchioi. ");
INSERT INTO var_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Neipao Eesusia nonorapuso muuwario, pawekakerachi mooenatiapua waikao. Pukachi mo'moenasaopua, Makarani weeechi siimpatiapua. ");
INSERT INTO var_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Parisero ti'tijoea, saruseo ti'tijoea tiame, Eesusi ne'nemia e'enariaipua, oowera Eesusi peenia ihsiwa teewinaria. Puuua oowera itapiti ki kaawe iintowachi chapinariapao, chaanekapua Eesusio: —Riosi peenia ihsiwa taamo tetewitepuapua, wa'a aamo iintosoomua, nane'reme teemea, pichiwa tewekachi eenamekoopua. ");
INSERT INTO var_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Nape Eesusia chaanekapua pu'kao: —¿Achinikai epeche tiiame tetewinare eemea no'oo naania ihsiwao, tísia machika tetewameko tuuyameai itapiti uurapario, ariyachi sehtanasipasoopua tewekachio, kaaweruma ma'chirepamio tuuyameai, ");
INSERT INTO var_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","eemea, cherayachitepa sehtanasipasooi ki nu'uti yukimio tuuyameai tiame? Yooma pu'ka uurapari machika tetewameai eemea, ¿kiisi machika tetewame eemea, ehpiami no'o naania teetoao no'o yoorao, ihtana ikipuame ohjoare ehpe taawechiamio? ");
INSERT INTO var_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Ehpe taawechiami ki ka'karuma ti'tijoeri ki Riosi yooreka mochitoamea, no'o peenia ihsiwachee nane'renariamepua no'o aatanatawao; nape eemea ki tetewitepuamepua wa'asio, no'o peenia ihsiwae no'o aatanatawao, no'o ikimiaeche tetewitepuamepua no'o aatanatao, puuu enemeripua no'o naaniatiwatamea. Puuu no'o ikimiaa, ehkoriami Oonasi ikiriachitia teeremeri, pu'kao, ki nu'nuti so'chie ko'kotiaio, simiteriamechitiaopua ahjakao. Wa'a cheesoopua Eesusio, uumatotiapua wa'ao. ");
INSERT INTO var_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Paonamina pa'wechi ajasitioopua Eesusia, taamoo ki uparioiopua nutukao, paani ki rewarurarachi simiyame taamo nayewekapua. ");
INSERT INTO var_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Pu'kachi wa'achitarichio, taamo chaanekapua: —Nee, kaawe aamo inateka ohjopuapua parisero rewarurawarachio, saruseo rewarurachiopua tiameo, yoomachi paatusichi mu'ipameka nokayamechiopua. ");
INSERT INTO var_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Rewarura nayewatioopua, taamo nutuka ki u'pario ijinatepaka teemea. Waikao taamoo, chaachapaka teemea: —¡Aa e'enone, natakepare teemea nutuka! ¿Ihtana noonoita teemea ehpeo? ");
INSERT INTO var_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Waikao Eesusia taamo wa'a chaachapame inamukapao, chaanekapua taamoo: —Ai eeme, ¿kiisi oowe erakoame eemea noochio? ¿Achinikai paani nutuka no'o nayeo erakoame eemea, aamo nutuka natakeparia? ");
INSERT INTO var_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Kiisi pusakona eemea no'oo aatanakoo? ¿Ki inatepame eemea no'oo, mariki paanieo mariki miiri ti'tijoe ko'koterio, ki ihtetaka ooweruo kukuchiopua tiaméo, kehkina weeweruma waari popochiame na'poatiamekoopua soparakameó? ");
INSERT INTO var_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","¿Ki inatepani eemea neipamioi wa'achi no'o iintoriopua, oowisani paanieoiopua tiame, naao miiri ti'tijoe no'o ko'koteriopua tiame, wa'a soparakameopua kehkina weeweruma waari apechunatiopua? ");
INSERT INTO var_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿Ki nane'reka inamukame eemea, no'o rewarura naewakoio, pariserochi simiyameo saruseochiopua tiameo, ki paani rewarurara no'o nayewaka cheerioiopua? ");
INSERT INTO var_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Ahkasi waika wa'a chiiopa, inateparepua Eesusio ki rewarura nayewaka cheeriopaopua, pa'akachiopua. Parisero masitewakamera naewaka cheeriopua, saruseopua tiame, ki paanikamera rewarurara. ");
INSERT INTO var_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Makarani weeechi puuyasaopua, Sesareami e'enaka teemea, Iiripo yawichi ye'karichi. Wa'ami ohjonioio, taamo ahpo masitiao, iinatukeka Eesusia: —¿Aatanako no'oko tuuna ti'tijoeria, no'oo Tijoe Tijoetukameo? ");
INSERT INTO var_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Teemea chaaneka nehjiakapua pu'kao: —Ookapi ti'tijoea, Waani Paatoriko aamo tuunapua; wahjachi ti'tijoea, ehkoriami Eeria aamo maayamepua; epeche wahjachia, ehkoriami Eremiako tuuyamepua aamoo; epeche wahjachia pehji, aaata piirechi ehkoriami Riosi nayewatukame maaenapua. ");
INSERT INTO var_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","—¿Eemepe, aatanako no'o tuuna eemea? —chaanekapua taamoo. ");
INSERT INTO var_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Siimoni Peeroa, nehjiakao chaanekapua: —Neeea aamoo, Riosie Weratiamekotipua, Riosi te'ta ahjarichi eename. ");
INSERT INTO var_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Waikao Eesusia, chaanekapua Peeroo: —Wa'a e'ramekapa muuua, tísia kaawe yorapuame muuu Siimonia, Oonasi taanaraa. Ki aaata amochi iintokamepua, aamo wa'a tiiame inatatekaopua, no'o Noonokamera iintokamepua wa'a eratekao, apoe te'pa kahtiamera. ");
INSERT INTO var_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Wa'a cheeriopua aamoo no'oo, Peero teewa aamo yahchiame neeea, e'pe, cheeka chaniwame. Peero aamo teewame neeea, pu'ka aamo noochi simiyame cheeriao, e'pechitia pewatiamekopa. Pu'ka e'pechio neeea, yooma noochi paparakame wa'a mochiwama neeea, no'o tewekachi tiopachio, ki teteiwame pusieopua. Wa'a no'o tiopachi mochikame ti'tijoeo ooweruopua tiameo, aaataai ki no'o u'yemapua, te'ta mukiwari utewariraai apoe Satanasiai. ");
INSERT INTO var_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Aamoonia Peeroo, aaata yeetapura ki'yamechitia Riosi ye'karichiopua, muiniame. Puuu yeetapura no'o aamo kiamiaa, no'o aamo aatanakoo cheeriapua. Pukae aaata Riosi ye'karichi pakinariameo, pu'kae aamo wahjopurae reesisemerimua pakimichioo, aaata aamochitia no'o aatanakoo ma'chitame enesoo; nape aaata ki aamo cheeriachitia ma'chitakameopua no'o aatanakoo, ki reesisemerimua pu'kao, Riosi ye'karichi pakimichioo. ");
INSERT INTO var_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Wa'a cheesaopua Eesusia, utewaeme taamo chaanekapua ahpo masiterao, kiisi tuumichiopua ahpoo, Riosichi ahpo eenamekoopapua, Tijoe Tijoetukao, ehkoriami o'inia Meesia tewaniame. ");
INSERT INTO var_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Waika o'inia Eesusia Eerusareni enasaopua, tísia aiwamio tuutuwisikapua, yooma wa'a Eerusareni isaeri pa'pamiratuameopua, pukaeo, ki teesa ahpo aiwatepuameko tuukapua, ahkasi mukiwachisi ahpo aiwatewachisi, nape meritiaiopua, paika taawechi oijenamio tuukapua eenechio. ");
INSERT INTO var_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Waikao Peeroa kiisi inamunariapao Eesusi chiiao, poanachi i'tokaopua te'ya cheekao, chaanekapua: —¡Kiisi mukimerimua! ¡Riosiai kiisi wa'a aamo ikijeramepua! ");
INSERT INTO var_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Nape Eesusia ku'rikao, chaanekapua Peeroo: —Waamiami se'wisa noochio. Satanasi muuua wa'a chiiapao. ¿Ki no'o Noono Riosie ikika itipimeriche tuutiame, eerinatame muuua? Puuu wa'a chaniwamea, oowera tijoechitia inataka chaniwame puuua, kiisi Riosi inata. ");
INSERT INTO var_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Wa'a chaanesaapua Peeroo Eesusia, eee cheeka masitekapua masiterao: —Aaata noochi paparaka no'o na'naritonariamea, aiwaka ahpo yasitomia eramete puuua, ki ta'iriache ahpo yasitopo inataka. ");
INSERT INTO var_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Aaata ki aiwanariamea noochi paparawawichioo, ki uumapua weemera ahjario, ki pichiwarikapa puuua noochio, ahpo paparao. Nape ki seewiamea ahpo aiwamiao noochio, kiapuame puuua weemera ahjario, pichiwaka noochi paparakamekapapua. ");
INSERT INTO var_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","¿Ihtatia kaawe enetapu tijoea, ki ookapi paarasatekaipua toomio, ki uumeri teeresaapua weemera ahjario? ¿Kehkina toomi aamo ahsepamia maaena eemea, weemera ahjari taripuao, tariniame enesoopua? ");
INSERT INTO var_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","¿Aachin teeretapu naaju puuu ki weemera ahjari iinuemea, no'o Noono tisiwari teetokae enasoopua, yooma tewekachi ku'iwari ahjamao? Waika taawechio neeea, yooma aaata kiapuame i'toka enameri neeea, yooma aaata noochi paparamewichioo. ");
INSERT INTO var_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Pichiwa chaaninia, ki wa'atia itipimerikopua aamo ookapiopua, ki tetewikaopua no'o o'iniameopua no'o ye'kari yawichitukao. ");
INSERT INTO var_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Puhsani taawechi neipao Eesusia, Peero yeetokapua, Saantiao, Waani Saantiao poonira tiame, pu'ka yeetokao teewi kaawichite siimpakapua, kai waapi te'pa weeriachi kaawi. ");
INSERT INTO var_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Wa'a kaawichi asisaapa Eesusia, sewina tiame eneparepua, yooma pu'ka paika ahpo yeetoria tetewachiopua. Wa'ao Eesusi nanariraa, taaachitia tajayame eneparepua, puuu wisasoriwaraa, tisiwa tohsaname eneparepua, tisiwa tohsaname, kiisi ne'neme eraniame, tatapara ihsiame. ");
INSERT INTO var_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Pu'ka wa'apichioi, wa'achi ajakame tetewiriapua tiameo, Moise Eeria tiame, ehkoriami ahjariame Eesusi ahjama nayewaka. ");
INSERT INTO var_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Pu'ka wa'a tetewapa Peeroa, senawato kihta inatasa chaanerepua Eesusio: —¡Paamira, kaawechupena aamo ahjama e'enakame teeme! Aamo erasoo, paika ekapora ajawama teeme i'wa, piiripia aamowichio, piirea Moisewichio, piirechia pehji, Eeriawichio. ");
INSERT INTO var_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Wa'a chiioi Peeroo, paawi tajayame eenaka, yooma mo'poreparepua Eesusi ahjama ajaniachio. Waikao pu'ka toomarichi o'iniao, eee chiiame inamuriapu puuu paikaa, Eesusi ahjama siimpakamea, Eesusi masiteraa: —Eeme yooma weeechi mochikame, ihjipu no'o taanáá, ki teesa nakika no'o uuriaa, pukachio no'oo, tísia kaawe e'reka yasitoaaa. Yooreka mochitomitiapua pu'kao, e'weka keepuka tiame. ");
INSERT INTO var_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Wa'a chiiame inamukapa Eesusi masitewaraa, tahpitika erapakaopua, ki nu'uti yoorewa e'reweka Eesusio, chopokorieka ajaparepua, ahkasi wehchisi koomorasipaka. ");
INSERT INTO var_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Waikao Eesusia wa'a te'tioiopua pehjio, wa'a te'tiachi pehji eenakao, ahjachi seekarepakao chaanerepua: —Ajasisa. Ka'te majako wa'asi. ");
INSERT INTO var_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Waikao Eesusi masitewarao ajapaka ne'nepoio, Eesusiche wa'a weeriame tetewarepua, ahpo chokichi. ");
INSERT INTO var_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Ehjepao kaawichi o'inia tetekiaiopua Eesusia, chaanerepua ahpo yeetoria masiterao: —Ka'te aaata tuuyemitia eemea, i'ka aamo teewi tetewiriaopua, ahkasi no'o Tijoe Tijoetukameo, no'o meritioi oijenachisi. ");
INSERT INTO var_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Wa'a chiiopua Eesusio, iinatukeria puuu paika masitewaraa: —¿Achinitio yasipameri muuua naaju aamo ye'karichio, iyoteri ti'tijoeo ke'chu Riosie Weratiame yawichi yasipoio, Eeriakamera enameriko tuuyamekopua pahchao? ");
INSERT INTO var_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Wa'a chaachapopa ahpo masitewarao Eesusia, chaanerepua pu'kao: —Pichiwa chaachapame puuua, Eeria pahcha enameriko tuuakao, puuupua, iintomerikoo ti'tijoeri Riosichi te'terepuame katewemeria. ");
INSERT INTO var_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Nape puuu Eeriaa, eenakamekaite puuuapa, nape ti'tijoea ki machika tetewikamepua pu'kao, ohsotia a'chikoi yoorarepua na'arekao. Wa'achitia yorapuame neeeai Tijoe Tijoetukamea, pu'ka ti'tijoeri nanaarameeo. ");
INSERT INTO var_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Wa'a chiiopua Eesusio masiteraa, pahteka inamure puuua, Waani Paatori nayewaka chiiamekopua, Eeria yoorari simiteriopa Waanio yorasikao. ");
INSERT INTO var_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Wa'a kaawichi o'inia tetekioiopua Eesusio, taamo Eesusi masitera toaria mochikachio, muuwaeme e'enakame mochikame tewakapua wa'ao. Wa'ao piiripi wa'a e'nakamea, chopokorieka weripaka Eesusi natepakao, chaanekapua: ");
INSERT INTO var_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","—Paamiraa, taamo tesiwa e'rejerani neeea, no'o taanaa, mumukipamekapu na'ararie. Tísia aiwamekapu wa'a tiiapao, weesa na'ichi wiwichipateniamepua reemoeopua, neerochiamioipu tiame. ");
INSERT INTO var_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Pukaepa i'wa aamo u'yepakamenia aamo sautemichio. Aamo masitera sautenurekainia nape ki kajukapua yoorakai. ");
INSERT INTO var_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Eesusia nehjiakapua: —¡Ai eeme kiisi ahjachi erakoame Riosichio! ¿Akanasi aamo chaaneka neeea, aamo noochi paparapamichioo? ¿Akatiasi aamo anachata neeea, aamo ki noochi oowe erakoao? Ehsóó, no'o u'yepao pu'ka temario. ");
INSERT INTO var_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Waikao Eesusia pu'ka temario, pu'ka na'arario, te'yaka ma'chipakapua temarichio. Pu'ka na'arari ma'chipasetiaapua temaria, ikanati kaaweruma kahtiapua, saukame. ");
INSERT INTO var_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Neipao Eesusi piineri kahtioio taamo ahjama ajawariacheo, iinatukeka teemea: —¿Achinikai ki kajukame teemea, pu'ka tijoe reemo na'arari yahcha ma'chipasekao? ");
INSERT INTO var_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","21","Wa'a chaachapaniopao, taamo chaanekapua Eesusia: —Ai eeme, ¿ma'chipamekosa erakokame eemea, kiisi Riosichi paparaka itayame enesaa? ¿Ki aamo wa'api utewariekosa ma'chipasemo erakokamekosa eemea? Ihjia tisiwa pichiwa tiiamepua: Eemea teesaoi te'ta Riosichi paparakame enesaa, mohtasa pahchirakoi kehchuma ki weruma, Riosia aamo kajutemiipua pu'ka na'arari aamo ma'chipasenariaopua; ihtaoi aamo yoranariao, teesaoi Riosichi aamo paparasoo, Riosia aamo kajutemerikoipua kajutekao, ahkasi i'ka kaawioi ikicha weripanurekooi. ");
INSERT INTO var_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Neipao Arirea weeechiami ohjoniaiopua, Eesusia taamo chaanekapua: —Neee Tijoe Tijoetukamea, tijoe nanaaramechi nehjipuamepua. ");
INSERT INTO var_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Neeea pukaeo, meripuamenia me'yao nape paika taawechi oijenamerinia eenechio. Wa'a chiiopa Eesusio, tísia yuuwesipaka teemea. ");
INSERT INTO var_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Eesusio Kapenau asisoopua taamo ahjamao, wa'a tiopachi koparoamea, Peerochi e'enaka chaanekapua: —¿Aamo masitariwaa, ki natetiamepua tiopachi koparowaniameo? ");
INSERT INTO var_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","—Eje'e, natetiamepua tiame pu'kawichioo —nehjiakapua Peeroa. Ehjepa petechi pakioi Peeroo, Eesusia ke'chu nayeoi iinatukekapua: —Siimonii, ¿achini chiiamemua? ¿Aatanakamera koparoame ohjoare i'isaeri ya'yawichia, ahpo tiopawichioo, i'wa wa'api ohjoemekosa, ma'chikosa o'inia enapamekosacheoi? ");
INSERT INTO var_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Peeroa nehjiakapua: —I'wa ohjoemeraa, ka'i. Eesusia waikao aampachi cheekao: —Wa'a teeresoo teemea, kihta natetemetepua pu'kawichioo. ");
INSERT INTO var_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Nape ki seesenukai natetenia kaawepua, ki aaata ki kaawe eramichiopua. Wa'a teesoo, wiitu siinka weruma neerochi, so'chi po'wachupuapua. Pahcha so'chi aamo ma'chipariachi, ne'nepuapua chu'wachio wahjoneka, wa'a tewimamua piiripi toomi. Pu'kaeche ahsepameripua, yawichi koparowa natetepuameo, taamo na'pawichio koparowaniameo. ");
INSERT INTO var_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Waikao pu'ka wa'api taawechi, aaata Eesusi masitia pepenipanariamea, Eesusi naaepakao, iinatukekapua: —¿Aatanakamera ohjoarepu, epeche weruma enemeria tewekachi ye'karichio? ");
INSERT INTO var_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Waikao Eesusia piiripi kukuchi paaesapaopua, taamo naasipa werapakaopua, ");
INSERT INTO var_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","cheekapua yooma inamuachio: —Tísia pichiwa ihjia: Aaata ki i'ka kuitachitia tiiamea apochio, ka'chi iika pakimeri puuua tewekachio, no'o Noono ye'karichiopua. ");
INSERT INTO var_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Epeche weruma teerenariamea tewekachi ye'karichio, i'ka kuitachitia teeremeripua, yooma ahpo noono chiia pichikiame. ");
INSERT INTO var_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Aaata kuitachitia noochi paparamea, pakimeripua Riosi ye'karichio, te'pa tewekachio. ");
INSERT INTO var_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Nape aaata kukuchichitia noochi paparakame tatakorichi wichitekamea, ohso kaawe kutachi o'yesa tusura matasurara, pa'wechi ipaniame nakiyamepua, pu'kao kai waapisi teere piwitewika, si'rika mukimichiopua. ");
INSERT INTO var_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Eesusia pu'ka nayewaka kajusaapa, taamo tatakorichi wichipua, eeyowa tiia taamo nayewekapua. I'ka naewakaopua, eee taamo chaanekapua: —I'ka wehjoarichi taamo mochikachio, tahpitika tiiamepua itapiti, taamo wichiteme tiiame. Wa'a tiiachi i'wao, ki ookapi mochikamekopa ti'tijoeri ki ka'karuma taamo tatakorichi ruhjitenariame. Nape ¡ai puuu wa'a aaata iintokamea!, kiisi cheriwepuamepua Riosie. ");
INSERT INTO var_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","’Pukaepa neeea, aamoo chaaniamepua, aamo seeka aamo taaraoi tatakorichi aamo wichitesoo, ohso kaawe tehpunasa ipania kaawepua, nape mehkaa. Epeche kaawepu piiripi seekaeka, piipiri taaraekaoi, ki wahjiame ahjarichi pakiniamea ohso kaawe, ki na'pa seekaekao, na'pa taaraekaoi, ki teesa aiwaniachi pakiniamechitiao. ");
INSERT INTO var_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Aamo puusioi ki kaawerumachi aamo wichitenaresoo, ma'chipasa mehka ipapuapua pu'kaoi. Epeche kaawepu piiripi puusiekai Riosi ye'kari ahjarichi pakipuaa, ki ooka puusieka ki wahjiame na'ichi ahpo ipaniamechitia. ");
INSERT INTO var_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Pu'ka naewaka kajusaapa Eesusia, po'wa wekakamechi simiyame nayewakapua. Pu'ka nayewakao o'inekapua cheekao: —Ka'te ki kaawe chaaneka tetewi aaataoi u'utichitia noochi paparakameo, no'o te'pa te'ta Noonoo, ahpo tewekachi ku'iwarie neesetoamekopapua pu'kao, noochi ahpo paparao ku'ika ki toitemichiopua, ihta keenakooi ku'ipamichio ahpo ku'iwa nakiso. ");
INSERT INTO var_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Neee Tijoe Tijoetukamea, pu'ka po'wachitia wewekakame, i'yamia eenakame neeea, noochi e'enamichiopua pu'kao, noochi paparaka. ");
INSERT INTO var_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","’Ihjia, aaata piie siento po'wa iinuemeka tiiamepua. Puuua, piiripioi ahpo tepuya wekasoo, ikanati simika i'yamepua pu'kao, wahja ahpo tepuyao toisa ku'itapioi. ");
INSERT INTO var_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Pu'ka wekakame teisaa, ¿ki epeche kaawe e'retarepua pu'kao, ki wahjachitia naao weerewa oosa mariki watani ahpo toariaopua ku'itapi, po'wa? ");
INSERT INTO var_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Wa'achitia no'o Noonoai tísia kaawe erapamepua, aaata ki kaawerumachi oiyai, apochi upatioopua, nu'utichitia apochi paparakopao. Tísia kaawe erapame puuua, aaataai i'ka nu'utichitia apochi paparakameo, wekakame itipijerapapua, ki kaawerumachio. ");
INSERT INTO var_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Neipao Eesusia, taamo poponiwa cheriwewa nayewakapua. Puuua pu'ka nayewakao cheekapua: —Aaata Riosichi paparame ki kaawe iintosoopua amochio, piineri ihsioi amoe simika katewepuapua pu'ka ahjamao. Kaawe teereka itipinariaapua amochio, ahpo cheriwenuramapua. Wa'a iintosoopua, ahpo kaawe e'reka itipima eeme. ");
INSERT INTO var_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Nape ki katewenaresoopua aamo ahjamao, i'yapuapua ooka paikaoi pu'ka iintoria tetewikame, pu'ka pichiwatarie aamo katewepuapua pu'ka iintoriao. ");
INSERT INTO var_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ki e'wesoopua pu'ka aamo ku'yame katewekaopua, Riosichi paparame pirenaturichi i'topuapua pu'kao, aamo ku'ika ne'neweka katewemichiopua pu'kao. Nape pu'kao ki e'wesoo Riosichi paparame pirenaturio, wa'asi waikao, wa'atia toipuapua pu'kao. Nape pu'kachepa pu'kao, ki Riosichi paparame tetewipuapua pu'kao, tijoekoio oowitiamekoiopua, pu'kao ki ka'karumachiche oiyamekopao. ");
INSERT INTO var_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","’Ihji no'o chiiaa kiisi se'wi ikimeripua: i'ka weeechi aaata ahpo kateweka cheriwesoo, wa'achitia cheriwepuamepua tewekachioi; nape ki aaata ahpo kateweka cheriwesoo, wa'achitia ki cheriwepuamepua taamo Noono te'pa kahtiameeopua tewekachi. ");
INSERT INTO var_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","’Eenechio chaaninia: Aaata eeme ookaoi paikaoi aamo ki kaawe noonoiria katewemia napawisoopua, aamo cheriwepua itasoo Riosichio, no'o Noono tewekachi kahtiamea, aamo cheriwemapua. ");
INSERT INTO var_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","No'o Noonoa aamo cheriwemapua, neee aamowichio tatakori natetekamea, aamo napawiriachi ihsiopa tiame. ");
INSERT INTO var_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Waikao Peeroa Eesusi naaepakao iinatukekapua: —Paamira, aaata no'o Riosichi poponiwa ki kaawe iintosoopua noochio, ¿kehkinasi anachetania cheriweka pu'kao, oowisanisi? ");
INSERT INTO var_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Eesusia nehjiakapua pu'kao: —Muuua ki oowisanisi cheriwemerimua pu'kao, ahkasi paika weerewaoi oosa marikisi o'owisanisa, cheriwemerimua pu'kao. ");
INSERT INTO var_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Ahpo cheriweniame naewaka kajusaapua Eesusia, Riosi ye'karichi simiyame nayewakapua wa'achitarichio. Pu'ka naewakao, eee cheeka o'inekapua: —Aaata yawichia, yooma ahpo tehkiwa neesetoame wikirieka koparoamo o'rariataipua. ");
INSERT INTO var_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Pukeri o'ichoi wikiriewa ne'nekao, pahcha puuu u'yeparia aaata wikiria ne'niaopua, ki ookapi toomi wikirewakatapua, oosa mariki miiriahka. ");
INSERT INTO var_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","I'kao teekoraa, ka'chi iika natetemio tiiopa wikiriemeo, toomichi nehjinuremo o'rariataipua wikiriemeo, yooma pu'kao iinueka ahjamaopua, uupiraopua, tatanaraopua tiame, pukae nehjitiameeo, natetetiame itipimichiopua wikiriaraa. ");
INSERT INTO var_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Wa'a yoranarewaopua wikiriemea, chopokorieka weripaka tísia naaracheriataipua ahpo teekoo, tesiwa cheeka ahpo cheriwenureka: “Muuu no'o teekoo, ka'te te'ta yaapi no'o e'remitiamua aamo no'o wikiriekawichioo; no'o puuyemitiapua pehjio paikapi taaweoi, yooma aamo natetemiitenia pu'kao.” ");
INSERT INTO var_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Waikao teekoraa tísia tesiwa chiiopa pu'kao, tesiwe e'repakaopua pu'kao, yooma cho'weriatapua wikiriarao. Wa'a ikisaopua wa'atia toariatapua no'ramichioo. ");
INSERT INTO var_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Nape puuu wa'api cheriwetiameaio, ahpo ta'pechi no'raio, aaata wa'achi tekipanameopua tiame, piie siento wa'api wikiriekoipua pu'kao toomi, pooechi natepakaopua, kutachi chapikaopua chaaneriatapua: “¡Ehpe wa'api no'o natetepuapua aamo no'o wikiriekao!” ");
INSERT INTO var_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Waikaopu wikiriemea, chopokorieka weripaka tísia tesiwa cheeriataipua chaaneka: “Ka'te ikanati aamo natetejeramua no'o wikiriekao, yooma aamo natetemitenia, aamo wikiriekao.” ");
INSERT INTO var_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Nape ihjia ki puuyenareriatapua pu'kao, ohsotia karichi pachariatapua pu'kao, ahkasi yooma ahpo natetiachisi. ");
INSERT INTO var_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","I'kao wahjachi wa'api tekipanamea, wa'a iintokopa pu'kao, ahpo teekochi wenejiriatapua pu'kao. Nekamuchiapapua pu'kao, yooma i'ka iintoria tuuyeriatapua ahpo teekoo. ");
INSERT INTO var_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Waikao teekoraa paaeriatapua wa'a wenejitiameo, enasoopua pu'kao, chaaneriatapua: “¡Ki tísia na'arame muuua? No'oo yooma aamo cheriwekoipua aamo wikiriao, ");
INSERT INTO var_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","¿ki wa'achi iintomo teereriamua naaju, no'oo aamo cheriweriachitia?”, chaaneriatapua. ");
INSERT INTO var_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Waikao teekoraa tísia nekakao, karichi yachanurariatapua pu'kao, wa'a yoorakaopua ahkasi wikirieka nateteriatapua. ");
INSERT INTO var_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Eesusia cheekapua aampachi pehji: —Wa'achitia no'o Noonoai ki cheriwemapua aaatao, ki ahpo iikachi e'raka cheriwiameopua ahpo piirechio, aaata ahpo cheriwenuresoopua. ");
INSERT INTO var_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Neipa pu'ka wa'achitarichi naewasoopua Eesusio, puuyatiapua Arireao. Oorani akichi paonamina e'natiapua waikao, Uurea ye'kari nenekuwachi. ");
INSERT INTO var_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Ki ookapi wa'ami taamo na'naritokameo Eesusia, yooma sautekapua kokoriameo. ");
INSERT INTO var_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Wa'a ohjonioio ookapi pariseroa, iinatukekapua Eesusio, itapitichi wichipatenariapapua, eee chaachapaka: —¿Reesiseri ohjoarepua ahpo uupichi poanatuniamea, ihta itapitiwichiooi? ");
INSERT INTO var_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Eesusia nehjiakapua: —¿Ki iyoname eemea Ehkoriami Iyoterichio, pukeri Riosi tijoe neterioio, eee chiiachio, “piiripi tijoe neterepua, piiripi oowitiame tiame”, chiiachi? ");
INSERT INTO var_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Riosia pirenachi Iyoterichio, cheriaipua tiame: “Pukaepa tijoea, ahpo yayawa toayamepua, ahpo uupi ahjama neewisaapa, na'pa pirena piiripi enepamiapa.” ");
INSERT INTO var_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Wa'a tiiachipa no'o Noono Riosia, ki ookachitia tetewanipua nenewikameo, piiripichitia enepakamekopua pu'kao. Pukaepa Riosi pirenaturia nenewika, aaataai ti'tijoeria, kiisi poanatametepua pu'kao. ");
INSERT INTO var_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Wa'a chiiopa Eesusio, eenechi iinatukekapua pa'pariseroa: —¿Nape aatia Moise Nuurari Iyoteria chiiamepua, reesisewako tuuka pu'kao, iyoterichiche poanatari iyotesa kiasapua nenewikameo? ");
INSERT INTO var_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Wa'a chaachapopa, Eesusia cheeka nehjiakapua: —Moisea wa'a iintorepua pu'kao, ti'tijoerio kiisi e'waka mochitonariopa Riosi nuurario, wa'a tiame aamo tísia itariopua aamoo. Pukaepa wa'a iintorepua poanatuwa reesisekao, nape no'o Noonoa pukeri o'iniachisio, kiisi reesiseriaipua wa'a tiameo. ");
INSERT INTO var_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Pukaepa neeea aamoo chaanenapua, aaata ahpo uupichi poanatukamea, kihta suwepori iintokame enesoo, wa'a iintosapa piirechi oowitiame ahjama neewisaapua, apoekamera suwepori iintoamepua. ");
INSERT INTO var_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Waikao teemea Eesusi ma'masitewaraa pu'ka wa'a tiame inamukapao, chaanekame teemea Eesusio: —Wa'a teeresoo ohso kaawe ki nenewinia nahkipua. ");
INSERT INTO var_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Waikao Eesusia, taamo chaanekapua: —Ihji no'o chiiaa, ki yoomawichio puuua, nenewiniamewichioche puuua, puuua, Riosi chiia te'ta iyorika mochitonariamewichiochepua. ");
INSERT INTO var_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Nenewiniame nayewaniachi tiiamea, ki yooma ti'tijoe nenewime te'teriamepua. Iintuame ti'tijoe ahpo naawariachisi o'inia ki tatanatame te'tiamekapa. Wahjachi ti'tijoe tiamea, ki nenewiamepua, kaponitatiamekapapua. Wahjachi ti'tijoe tiamea, ki nenewiamepua, Riosi tehkiwachiche ki wahjiame teetonariapa. Wa'a tiiachipao, ihji no'o chiiaa, te'ta Riosiwichio iyorikache yasitonariamewichiopua. ");
INSERT INTO var_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Piie taawechi Eesusi u'yepanioi kukuchio, i'kawichioo kaawerumari itamichiopua Riosio, Eesusi masiteraa te'yariaipua Eesusi u'yepapuaichioo. ");
INSERT INTO var_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Nape Eesusia, chaanekapua masiterao: —Toowa pu'ka kukuchio noochi e'enamichio. Ka'te wa'ine pu'kao, pu'ka kukuchi tiiamekopua no'o Noono ye'karichi muimeria, puuu kukuchi ahpo noonoo ihta chiiaoi ikanati pichikiamekopua. ");
INSERT INTO var_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Waikao Eesusia, pu'ka kukuchichi seekarepaka, ahpo Noono paparaka kaawerumari yahchesoopua, uumatotiapua wa'ao. ");
INSERT INTO var_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Piie taaweo aaata tijoe eenariapua Eesusi ne'nemiao, puuua chaanekapua Eesusio: —Kaaweruma Masitari, ¿ihtana iintotarenia ki wahjiamesi ahjari no'o iinuepuamichioo? ");
INSERT INTO var_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Eesusia nehjiakapua pu'kao: —¿Ihtana tiiachipa no'o tísia kaaweruma teewamemua? Te'ta kaawerumaa, piiripi wa'apiche puuua, Apoe tísia te'pa kahtiame Riosiche. ¿Wa'a tiiamekosa no'o e'riame muuua? Weeh, pu'ka aamo ki wahjiame ahjari iinuenarewachi simiyameo, no'o Noono nuurarira e'weka yasitopuachepua. Waikao tijoea cheekapua nehjiakao: ");
INSERT INTO var_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","—¿Ihtanapu nuurari no'o e'wemiaa? Waikao Eesusia chaanekapua: —Ka'te me'ya, ka'te suwepori ihsi, ka'te ichiko, ka'te wistumitia muuua aaatao, ki kaawe yorapuawichioo, ");
INSERT INTO var_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","aamo yayawao yoorepuapua, aamo piirechioi kaawe e'raka tetewipuapua tiameo, aamo wa'apichitia. ");
INSERT INTO var_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Wa'a chiiopua Eesusio puuu tijoea, chaanekapua: —Yooma pu'kao neeea, yooraka yasitokame neeeapa, temarikai o'inia. ¿Ihtanajupu no'o toitiaa naaju pehjio? ");
INSERT INTO var_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Eesusia wa'a chiiopa pu'ka tijoeo, pu'ka pichiwarira nane'renariaapa, chaanekapua: —Te'ta kaaweruma enenariaa, yooma nehjipuapua aamo iinuekao, wa'a iintosaapa muuua, te'ta tooremuka mochikamerao, pu'ka ihkokepuapua wa'a iintosaapa waikao. Wa'a iintokame enesaamua, tewekachikamera iinuemerimua aamo te'ta pichiwari paarasario, pu'ka ki wahjiame ahjario, aamo i'yáo. Yooma pu'ka iintosaapa muuua, noochi enapuapua waikao, no'o yeetowa enepaka. ");
INSERT INTO var_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Wa'a chaanetiapa puuua, yuuweeme akipakapua, no'rakao, ki ookapi tomiwaemekapa puuua, kihta wekateme e'ramekapa puuua. ");
INSERT INTO var_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Pu'ka no'rasoopua Eesusia, chaanekapua ahpo keepuameo: —Ihjia tísia pichiwapua: aaata tísia tomiwaemea, tísia eerina tiiame puuua, ahpo Riosi ye'karichi pakimiao. ");
INSERT INTO var_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Eenechi aamo chaaniamenia: aaata ihtaoi te'ta paarasatiamea, epeche ki tehki tiiame piiripi tumusari animari i'ikia puusirachiami u'matoteniameaa, ki aaata te'ta tomiwaemechitia ahpo Riosi ye'karichi pakimiáo. ");
INSERT INTO var_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Masiteniamea wa'a tiame inamukapao, epeche tahpitika erapakao, chaachapakapua Eesusio: —¡Aa, naakona! ¡Wa'a teesoo aatanakamera newimeripua? ");
INSERT INTO var_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Waikao Eesusia kaawe ne'nepakao, chaanekapua: —Ihji newitoniamea ti'tijoewichioo, kiisi ahsepame tiiamepua, nape Riosiwichioo ka'i. ");
INSERT INTO var_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Wa'a chaachapatiopua Peeroa, chaanekapua Eesusio: —Kaawechupena teeme aamo masitewaraa, yooma taamo iinueriao, toakamepua. Wa'a tiiao uumeri teemea pu'ka paarasario, ¿nape ihtana paarasaripu puuua? ");
INSERT INTO var_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Waikao Eesusia, cheeka nehjiakapua Peeroo: —Kiisi wehchi wichimeri ihji no'o chiiaa: Yooma ihta weemeratatiachi taawechi asisoo, neee Tijoe Tijoetukameo yasipasoopua tiame, no'o tísia peenia tiiamechi ye'karichio, neeea aamoo no'o ku'ika katewemeri ajawamania, pu'ka i'isaeri oosa marikichi aampa ooka tetejimarichio, kateweri enemichio. ");
INSERT INTO var_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Yooma aaata ahpo iinuwa toakamea no'owichioo, naatichitia: ahpo kariwao, ahpo papachi, ahpo pipini, ahpo yayawa, ahpo tatana, ahpo weewa tiame, epeche ki ahpo toariachitia kiapuamepua Riosieo, u'matoame piie sientoo si'siento paarasari kiapuamepua, wa'a kehki ki'yakameaipua pehjio, weemera ahjari kiameripua tiameo, ahkasi ki wahjiamesi. ");
INSERT INTO var_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Wa'a Riosi weemeratariachiopua, yooma napati wa'achitia paarasateka mochipuamepua, napati te'terewa tiiame, ki i'wa weeechitia. ");
INSERT INTO var_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Eesusia, Peero nehjiaka kajusaapa, yooma taamo wa'a keepuameo, piirechi wa'achitarichi taamo nayewekapua, ahpo ye'karichi simiyame. Puuua eee cheekapua: Ihji Riosi ye'karichi kiapuamea, aaata tekipanakame nateteniameka tiiamepua. Aaata teekoa echakamea, pa'a piari werisika simiriataipua aaata tekipaname i'yamiaopua. ");
INSERT INTO var_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ihjia tekipaname teewisaapa, piie taawe yowiwame yowitemio tuuka uhjurariataipua tekipanamichioo. ");
INSERT INTO var_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Watanichi keenakoopua wa'asi tiame, eenechi simiriataipua wahjachi tekipaname i'yamiao muuwaeka nehjiwachi, wa'amiahka ajariatapua wahja kihta yoorame. ");
INSERT INTO var_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Pu'kaoi chaaniatapua: “No'o echiwachi siimpamitia eemeai tekipanamiao, kaawe aamo natetemane”, chaaneriatapua. Puuuai, wa'achi siimpariatapua tiame, tekipanamiao. ");
INSERT INTO var_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Oowetawe asitoio wa'achi iintoriatapua, arikiriopua tiame, tekipaname i'yamiao. ");
INSERT INTO var_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Marikichi simiyachiopua aario, wahjachi wa'ami ahka oowera ajakame tewakatapua. Pu'kao chaaneriatapua: “¿Achinikai ki tekipanakame eemea, ehpe taawechio?” ");
INSERT INTO var_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Ihjia chaachapariatapua: “Ki aaata takewakopa”, chaachapariatapua. Waikao takewameraa chaaneriatapua: “Siimpamitia eemeai no'o echiwachi tekipanamia.” ");
INSERT INTO var_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Neipao teekoraa cheeriatapua ahpo tekipanakiame paamiratiao, nateteniachi asisoopa aario: “Natetemitiamua no'o tekipanakiao, pipiripi paaesika, neipa e'enakamechi o'ineka.” ");
INSERT INTO var_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Marikichi keenako aari tekipanamia e'enakameopua, ahsieme piie taawe yowiwame sotateriataipua pu'kao. ");
INSERT INTO var_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Pahcha piari e'enamea epeche ahpo natetepo orakoriataipua, nape wa'api kehki piie taawe yowiwame kiatiapaopua. ");
INSERT INTO var_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Wa'a ikitaapua, kiisi kaawe erakokao, chaachapariatapua ahpo teekoo: ");
INSERT INTO var_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","“¿I'ka ku'itapi wa'api tekipanakameoi, wa'achi kehki natetere muuua tamochitia, taamoo yooma taawe tekipanakoipua, tatae aiwakao?” ");
INSERT INTO var_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Eje'e —chaaneriatapu teekoraa—. ¿Ki piie taawe yowiwamewichiokosa e'enakame eemea aamo tekipanamiao? —chaaneriatapu teekoraa pu'kao—. Ahsieme aamo natetekamenia aamoo. ");
INSERT INTO var_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Natetetiame muuuapa, yaapi no'rasa. I'ka neipa e'enakameopua, nooe wa'a kehki e'rekapa, wa'a kehki natetekamenia. ");
INSERT INTO var_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","¿Ki no'o iintonaria iintotarenia naajuo, no'o wa'api tomiwaeo? ¿Tísia ikotuchiamekosamua naaju, i'ka nooe no'o oowe e'reria nateteria toomi?” ");
INSERT INTO var_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Wa'a cheesapa Eesusia, cheekapua: —Wa'achitia no'o Noono ye'karichi muimeria, neipa kuwachi wa'asi e'enakamea noochi paparamiao, pukeri o'iniachi pahcha e'enakamechitia noochi paparamia, wa'achitia napati kiapuamepua, no'o Noono tewekachi kahtiameeopua. ");
INSERT INTO var_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Eerusareni siimpapooio Eesusia, taamo ahpo oosa mariki aampa ooka masiterao poanachi i'tokao, chaanekapua: ");
INSERT INTO var_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","—Née, Eerusareni siimpani teemea ehpeo. Wa'ao neee Tijoe Tijoetukamea, isaeri tioparachi neeseriosie nanaaramechi nehjipuamepua, iyoteri ti'tijoechi. Puuu ti'tijoea, no'o merinuremapua. ");
INSERT INTO var_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Wa'a noonowitioopua tísia no'o na'aresao, tísia no'o wepisaopua tiameo, ki isaeri ti'tijoechi kiapuame neeea, kurusichi chuhchaka merimichiopua. Nape wa'a yooraka meritiainia, paika taawe i'toio, oijenamerinia eenechi. ");
INSERT INTO var_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Eesusio Eerusareni siimpanioiopua taamo ahjameo, Sewereo uupiraa, ooka ahpo tatana ahjama eenakaopua, Aakowo Waaniopua tiame Sewereo tatanarao, Eesusichi eenakaopua chopokorieka weripakapua Eesusio, tesiwa cheeka nayewekaopua, itapiti itanareka. ");
INSERT INTO var_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Eesusia wa'a iintokopao, iinatukekapua cheeka: —¿Ihtana eratoame muuua? Waikao puuu oowitiamea chaanekapua Eesusio: —Paamira, neeea aamo itamia eenakamepua, i'ka ooka no'o tatanao, aamo ye'karichi yasipasaamua, aamo kahtiachi nenekuo, chokichi mochitejeraninia, piiripi ahjamina, piireo owemina. ");
INSERT INTO var_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Eesusia wa'a chiiopa pu'ka oowitiameo chaanekapua: —Muuua kiisi inatamemua aamo itayao. Wa'a cheesaopua Eesusia, oowitiame tatanara iinatukekapua: —¿Anachamerikosa eemea naaju, no'o paasowachi iijimiao iijika, tisiwa chihpuameoipua pu'kao? Aapoeo chaachapakapua: —Eje'e —chaachapakapua—, anachaka iijima teemea. ");
INSERT INTO var_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Waikao Eesusia chaanekapua pu'kao: —Eemea kajutarepua kajuya pu'ka iijikao, nape pu'ka no'o neneku mochipuameo, ki neee iintomeripua pu'kao, apoe no'o Noono iintomeripua pu'kao. ");
INSERT INTO var_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Waikao teeme oosa marikia, wa'a chaachapame inamukapa pu'ka tehtemario, nekumeka teemea pu'kao. ");
INSERT INTO var_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Wa'a iikopa taamoo Eesusia, taamo chaanekapua: —Eemea tetewamepua weeweruma tiiarieme ya'yawichio, tísia e'raka yooraka tetewamekopua ahpo yoorewachi mochikameo, tísia ahpo utewarieo saaeteka. ");
INSERT INTO var_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Nape amochio eemea, ki wa'a erakoka mochimetepua Riosichi iyoriamea. Ohso kaawe eemea, aaata paamiratuame enenariamea, eemekamera yorakiamera enemeripua aaata aamo ahpoo, kihta aamo weruma uuka. ");
INSERT INTO var_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Eemea amochio epeche weruma enenariamea, yorakiamera enemeripua. ");
INSERT INTO var_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Wa'a teeremeripua, neeeai Tijoe Tijoetukameai ki no'okamera yorakepuawichio, eenakamenia. Neeea Tijoe Tijoetukamea, ohsotia aamokamera yorakemia eenakamenia, ahkasioi no'o ahjarioi nehjimia, mukiwachisi, ki ookapi ti'tijoewichioopua, pejana nateteteka kokosapuameopua, tatakoririawichioo. ");
INSERT INTO var_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Taamo Eriko o'inia puuyatioio, ki ookapi Eesusi ahjama e'enatiapua. ");
INSERT INTO var_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Pooechi nokisinioio, ooka ki mamachiriame tetewitiapua pooesuwe mochikame. Puuua wa'ami taamo u'matopoio, Eesusi sisinamukapua, wa'ami ihtoame inamukapa. Puuua chaachapakapua: —¡Muuu ehkoriami Raawitaruchi eenameee! ¡Taamo tesiwe e'resa pahchuu, tísia tesiwa erakoka chaachapame teemeaaa! ");
INSERT INTO var_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Waikao ookapi wa'a nokisiamea taamo ahjamao, ihchi mochinuriaipua pu'kao ta'omaka. Nape aapoeo ohsotia epeche weeru sisinamukapua Eesusio, chaachapaka: —¡Paamíraaa, Raawítaru ehkoriamichi eenámeee, Taamo tesiwa e'resa pahchúuu! ");
INSERT INTO var_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Waikao Eesusia paaekapua weripakao, wa'a ikisaapua iinatukekapua pu'kao: —¿Ihtana aamo yorajerani eemea? ");
INSERT INTO var_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Waikao ki mamachitiamea, muuenati naewakaopua wa'asio, chaachapakapua: —Paamira, taamo ki mamachiria sautejerani teemea. ");
INSERT INTO var_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Waikao Eesusia tesiwa e'repakaopua pu'kao, puichi seekarepakao, sautekapua pu'kao. Ikanati kaawe ma'chiriame itipitekapua. Waikaopu ki mamachiriame sautetiameai wa'a, Eesusi ahjama nokisikapua tiame siimpaniachi. ");
INSERT INTO var_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Eerusareni ke'chu asinioio, Wepaje tewaniachi ajasitioopua Ooriwo roomosachi mo'moenakao, Eesusia ooka ahpo masitera uhjurakapua chaaneka: ");
INSERT INTO var_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","—Eemea paao siimpamitiapua, ma'chiachi mochiwachi. Wa'a teimeri eemea piiripi uuru ye'ira, oowira taanaeme. Pu'ka uuru taanarao o'yaeka chuhkuao, na'sonasa no'o u'yepapuapua. ");
INSERT INTO var_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Aaata aamo wa'inesoo, chaanepuapua pu'kao, aamo Paamirae i'yetonuretiamekopua, ku'itapi, ehjepa upapo tuutiamekopua eenechio. ");
INSERT INTO var_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Ihji uuru upatiamea, ehkoriami chanitiame pichiwa eneriapua, waikami Ehkoriami Riosi cheeriaopua, ahpo nayewaturachiopua Iyoterichio. Eee cheeriaipua: ");
INSERT INTO var_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Siioni muuwari mochiwachio, chaanepuapua pu'kao: “Ne'neo eemea aamo Yawichio; tesiwa teetoka yasitoamepua uuru taanarachio.” ");
INSERT INTO var_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Puuu ooka Eesusi masitewaraa waikao, yooma wa'a noonowirepua waikao, Eesusi uhjurariachitia. ");
INSERT INTO var_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Ehjepao Eesusia pu'ka uuru taanara i'yepatiaapua, wisasori ipeteka yaasetokapua. ");
INSERT INTO var_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Waikao muuwaeme puuyeka ajakamea uumatopuachio, wisasori ipetesiapua u'matomiachio. Wahjachi puuua, kuhsisawa ipekesiapua, u'matomiachio. ");
INSERT INTO var_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Waikao pahcha nokisiamea, pukamina nokisiamea tiamea, weeru chaachapasiapua siinasikao: —¡Nee tetewísaaa, ehkoriami Raawi yawichichi o'inia enamériii! ¡Te'ta kaaweruma Yawichi Riosichi eenámeee! —chaachapaka siinakosiapua simipakao. ");
INSERT INTO var_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Eesusi Eerusareni pakisoopa, yooma weeru noonowikapua muuwari mochiwachio, ihjia chaachapakapua: —¿Aatana ihjia naaju? ");
INSERT INTO var_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Eesusi ahjama nokisiamea chaachapakapua: —Eesusi ihjia, Riosi Apoe nayewatura, Nasare ohjoeme tijoe, Arirea weeechi. ");
INSERT INTO var_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Eerusareni enasaapa Eesusia, i'isaeri tiopachi eenaka yooma puuyanakapua wa'a nehjameo, yooma tarayameopua tiame. Meesa toomi naakuriwaniachiopua tiameo, yooma yakana ihpapasekapua, kooro nehjiwaopua korokariraopua tiamé. ");
INSERT INTO var_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Eesusia chaanekaopua pu'kao: —Ehkoriami Iyoterichio no'o Noonoa, chiiamepua: “No'o kariwao, no'oche ahjama nayewapuawichio netetiamepua”; nape eemea ichikuame teesowara enepaterepua. ");
INSERT INTO var_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Wa'a i'isaeri tiopachio, ookapi ti'tijoe ooweru tiame Eesusi naaeparepua, ki mamachiriame, chookopari kokoriame tiamé, puuua Eesusie ahpo sautemichio e'enariapua wa'ao. Waikao Eesusia, yooma sautekapua pu'kao. ");
INSERT INTO var_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Nape wa'a i'isaeri pa'pamiratuamea, Eesusi ki maaepori iintokopao, kukuchiopua eee chaachapaka siinako chaachapachaniopua tiopachio: “¡Ee, taamo newipateri Eesusiii, ehkoriami Raawitaru yawichi o'inia eename oochiwaraaa!”, tísia nenekakapu pa'pamiratuamea. ");
INSERT INTO var_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Wa'a ijikikaopua, chaanekapua Eesusio: —¿Ki inamuame muuua kukuchioi ihtana aamo chaachapachanio? —Eje'e, inamuamenia —nehjiaka Eesusia—. ¿Naakona ki iyonamekosa eemea, Ehkoriami Iyoterichi chiiao, i'ka kukuchichitia teereniame, nayewaka chanitiameo, eee chiiachio?: Ahkasi kukuchiai, nu'nunti chiiameai pehji, aamo kaawe chaachapamapua. ");
INSERT INTO var_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Wa'a chaanesopa Eesusio pu'kao, uumatotiapua waikao Wetania mochiwachi. Wa'a ajasisaapa, wa'a che'repatiapua waikao. ");
INSERT INTO var_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Piario eenechi Eerusarenite e'enapanioio, Eesusia chorowapariaipua. ");
INSERT INTO var_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Puuua, chuuna tetewikapao pooechiami u'matoaiopua, ahseka ne'nekaipua, taakaekoipu e'raka. Nape puuua ki taakaeme eneriapua, saawarache weeriame. Wa'a tiiopa pu'kao Eesusia, chaanekapua pu'kao: —¡Kiisi taakemeri muuua wa'asio! Waikaopu chuuna saawaraa, ikanati waaropakapua. ");
INSERT INTO var_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Waikao teemea ikanati wa'a iikopa pu'ka chuunao, iinatukekapua Eesusio: —¿Achinikai ikanati wakiparepu? ");
INSERT INTO var_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Eesusia taamo nehjiakapua: —Neeea pu'ka chuuna wakipatekane, itapiti ki kaaweruma iinueriopa, ki toayame taakemichioo. Pichiwa chiiame neeea i'kao: Wa'achitia eemeai, aamo pichiwa Riosichi paparaka no'o itasoo, ihta itapiti ki kaaweruma amochi iinuemeo, pujime tiiamemua amochio, Riosi utewariraeo, kaaweruma taakiame aamo enemichiopua, Riosiwichio. A'chitia kehchumaoi aamo eerina tiiaopua Riosiwichio aamo taakemiaopua, i'ka kaawi kehchumakooi, kajuyamenia aamo puhjenekao, aamo i'ka kaawi chaanekooio: “Waami pa'wechi wichime”, wa'a iintotekaoio, kajumania. ");
INSERT INTO var_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Yooma ihtaoi amochi eina tiiame Riosichi paparaka aamo puhjenurewa itanesoo, aamo ahsieme puhjetiame itipimamua amochio. ");
INSERT INTO var_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Ajasisaapa Eerusareni taamo siimpachio, Eesusia i'isaeri tiopachi pakikapua wa'ao. Wa'a yooremina masitioio Eesusio, neeseriosi pa'pamuratuamea Eesusi naaepakapua, puuu Uurio o'ochetiamechitia uuniame tiame. Puuua iinatukekapua Eesusio: —¿Aatana nuurewachi ihsina muuua i'kao? ¿Aatana aamo ki'yakamepua i'ka aamo iintomichioo? ");
INSERT INTO var_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Eesusia nehjiakapua pu'kao: —Nape neee aamo iinatuketao pahchao. Pu'ka kaawe aamo nehjiasoo, aamo nehjiama neeeai waikao, aamo iinatukiao. ");
INSERT INTO var_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","¿Aatanakamera iintokame Waani uhjuraka paatomichioo, Riosikosa puuua, aaata ti'tijoerikosaoi? Waikao ihchi ahpo nayewekaopua, chaachapariapua: —Riosiko tuusoopua taamoo, taamo chaanemapua: “¿Achinikai ki pu'ka pichikeka eeme waikao?” ");
INSERT INTO var_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Aaata ti'tijoerioiopua ka'chi iika uhjurario chaachapamete teemea, pu'ka yooma ti'tijoeria Waanio, Riosi nayewaturamekoo, erakoamekopua pu'kao. Wa'a tiiachio, maapori tiamepua taamowichioo, tamochi nenekamiopa puuua. ");
INSERT INTO var_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Wa'a erakoamekapaopua, chaachapaka nehjiakapua Eesusio: —Kiisi nane'riame teemea pu'kao. Waikao Eesusia chaanekapua pu'kao: —Wa'a teesoo neeeai ki chanimapua, aatana no'o nuurekamekopua, yooma i'ka no'o ihsimichioo. ");
INSERT INTO var_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Eesusia iinatukekapua waikao i'isaeri pa'pamuratuameo: —Ehsoo, ¿ihtana chaachapata eeme i'ka wa'achitarichi no'o aamo nayewamiao? Piiripi tijoea ooka tatanareriataipua. Ihji noonoraa chaaneriataipua piiripi ahpo taanao: “Taamo panijuwari eechichi siimitia tekipanamia.” ");
INSERT INTO var_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Ihji taanaraa nehjiariatapua ahpo noonoo: “Ki siminarenia tekipanamia”, cheeriataipua. Nape wa'a cheekaipua simiriatapua. ");
INSERT INTO var_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Ehjepao piire ahpo taanaoi wa'achi chaaneriataipua. Ihjia nehjiariataipua: “Siimania.” Nape wa'a cheekaio, kiisi simiriatapua. ");
INSERT INTO var_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Ehsoo no'o tuuyemitiao, ¿aatanakamerapu ihji ooka tatanaraa, kaawe noonoikamepua ahpo noonochio? —Pahcha simiyamera, ki siimo tuusa simikamera —chaachapakapua i'isaeri pa'pamuratuamea. Waikao Eesusia, chaanekapua pu'kao: —Eemea pu'ka pahchachitia te'teriamepua, ki e'weka mochikamekapa te'pa kahtiame no'o Noonoo. Kiisi wehchi wichimeri ihji no'o chiiaa: Rooma yawichiwichio ko'koparoamea, ooweru suwepori nokayamea tiame, i'kao ki Riosi ye'karichi muimeri enesoo, eemea epeche ki muimeripua. ");
INSERT INTO var_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Eemea Waani Paatorio, Riosi kaaweruma tuuyewari aamo masitemia eenarioio, kiisi pichikere eemea pu'kao, nape yooma Rooma kahtiame yawichiwichio koparoamea, suwepori tekipanamea tiame oowerua, pichikerepua pu'kao, Waani chiiao; puuu koparoamea, suwepori tekipanamea tiame, pichikekamekapaopua Waani chiiao, ahpo ki kaawe nokaria cheriwejerarepua no'o Noono te'pa kahtiameo. Nape eemea pu'ka no'o Noonoe cheriwetiame tetewikaio, kiisi sewina erapakame eemea kaawerumachio, Waani Paatori cheeria pichikekaopua. ");
INSERT INTO var_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Eesusia kajusaapa pu'ka ooka tatanachi simiyame nayewakao, piirechi wa'achitari o'inekapua nayewakao. Puuua pu'ka wa'achitarichio cheekapua: —Aaata tijoea, panijuwari echariataipua. Echisaapua, ko'reteriataipua pu'kao, wa'a ikisaapa, satuneropuachi neteriataipua tiameo. Wa'a iintosaapua, kai waapisi weeriame ne'nesori neteriataipua wa'a werika inatepuawichioopua yomachi ma'chiachi echitiachio. ’Wa'a ikisaopua tiameo, ti'tijoe tekipanameri takewariataipua. Yooma wa'a iintosaapua waikao, wahka simiriatapua mehka, seenu weeechi. ");
INSERT INTO var_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","I'ipaniachi asisoopua, aaata uhjurariataipua waikao ooka ahpo seekaraeka kahtia, ne'nemichiopua pu'kao, kehkina ahpo yowiria i'ipatiameo. ");
INSERT INTO var_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Nape eechi neesetoka toitiamea wepiriatapua pu'kao, piireo me'yariatapua, piirechi pehjio wa'api pasipuka kahsinariatapua mo'orao. ");
INSERT INTO var_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Ehjepao teekoraa eenechi uhjurariatapua epeche weeka, nape pu'kaoi, wa'achi yoorariatapua tiame. ");
INSERT INTO var_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","’Neipaopua wa'asio, ahpo taana uhjurariataipua waikao: “Pu'kao no'o taanakopao yooremakoipua”, e'raka. ");
INSERT INTO var_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Nape ihji tekipanamea pu'ka taanarakopao pu'kao, ahpo chaachapariatapua: “Ihji tijoea, taamo teeko taanarapua, ihjipua, yooma ahpo noono iinuekao, yooma ahjama itipimeria; meritaria pu'kao, teeme yooma ahjama itipipuawichiopua noonora iinuekao.” ");
INSERT INTO var_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Wa'a erakosaapua, chapisa me'yariatapua pu'kao. ");
INSERT INTO var_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Waikao Eesusia iinatukekapua pu'kao: —Eemea i'ka noonowiriawichioo, ¿ihtana iintomio maaena eemea teekora enasaa, pu'ka tekipanameo? ");
INSERT INTO var_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Waikao aapoeo nehjiakapua Eesusio: —Kiisi cheriwemapua pu'kao, tísia na'ara noonoikamekopa. Wa'a iintosaapa teekoraa, piirechi ajawamapua ahpo eechichio, ahsieme nehjame ahpo i'ipariaopua ahpo teekochio. ");
INSERT INTO var_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Waikao Eesusia chaanekapua pu'kao: —¿Ki iyonakame eemea Ehkoriami Iyoteri chiiao, eee chiiame?: Puuu tehte ahjae karitaniame ki nakitiameo, epeche te'ta nateyame enepakamepua, te'ta kaari naawarachi yachaniamechitia. I'ka wa'a tiame iintokamea apoe Paamirapua, wa'a tiiachipa tísia peenia e'riame teemea pu'kao. ");
INSERT INTO var_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Pukaepa aamo chaanenania aamoo, pu'ka no'o Noonoe aamo kiaretiaopua u'yepuame eemea, pu'ka ahpo chiia ye'karichi simiyame masitepuameopua ti'tijoerio, ki kaawe noonowiriopua neesetokao. Pukaepa wahjachi ti'tijoeri kiameripua pu'kao, te'ta ka'karumara, kaawe taaketiamera ahpowichioo, pichiwa paparameopua apochio, te'ta iyorika mochitoame. ");
INSERT INTO var_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Nape aaata no'o Noono ahpo karitachi naawarachi yahcheria tehtechi motochikamea, pihtumeri puuua. Puuu tehte aaatachi wichisaa, piwiyame pihtunamapua pu'kao. ");
INSERT INTO var_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Puuu ne'neseriosi pa'pamiratuamea, i'ka chiia keepusaapua, nane'reriapua Eesusio, ahpokamera nayewaka chiio. ");
INSERT INTO var_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Pukaepa chapimo o'rariaipua Eesusio, nape wa'atia toakapua majawiapa ti'tijoerio, pu'ka ti'tijoeo ooweruopua tiameo, Riosi nayewatura erakoamekopa Eesusio. ");
INSERT INTO var_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Eesusia eenechi wa'achitarichi nayewekao, chaanekapua pu'ka keepuameo: ");
INSERT INTO var_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","—Riosi ye'karia naatika tiamepua, aaata yawichi ahpo taana nenewiwawichio, pahkotakameka tiiamepua. ");
INSERT INTO var_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Ihjia ahpo ta'pechi weweripateriao, yooma ti'tijoe ooweru tiameo, aaata ahpo paajutenariakamera paajutenureriataipua, nape paajutetiamea, kiisi aaata e'enareriataipua. ");
INSERT INTO var_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Waikao wahjachi ahpo weweripateriapechi uhjurariatapua tiame, eenechi paajutemichiopua aaata wahjachi. I'kao chaanesa uhjurariatapua: “Chaanemitiapua ti'tijoeri paajutekao: No'o teekoa, kooame wasikame weerotiapua wa'asi. Wakasi wi'wiyame pasuriapu ko'isa, aamo paajutiapu, wa'a siimpaka ko'komichio, ahpo nenewiwa pahkotaniachiopua.” ");
INSERT INTO var_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Nape puuu paajutetiamea tiameo, kiisi e'enariatapua aaataoi. Nape puuua ookapio, ahpo wasachi ne'nemia siimpariatapua; wahjachia ookapi, ahpo tehkiwachi uupariatapua ohso kaawe. ");
INSERT INTO var_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Wahjachi pehjia, yawichi uhjurariao, chapisa wepika ko'yariatapua pu'kao. ");
INSERT INTO var_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Waikao yawichia tísia nekakao, ahpo soontarowa uhjurariatapua waikao, pu'ka ti'tijoe ko'yameo, ko'imichiopua; wa'a ikisaopua yooma ko'isaopua wa'a mochirachio, kosinureriatapua pu'kao. ");
INSERT INTO var_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Waikao yawichia, chaaneriatapua ahpo weweripateriao: “Yooma yoratiame iinuemenia iinuemeko nenewipuameopa, nape pu'ka ki e'nakameopua te'ta paajutetiaio, kiisi reesisemania pu'kao, no'o neewiwa pahkochi muimichio. ");
INSERT INTO var_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Ohso kaawe eemea, ahkaoi pooechiami ajapasikao, aaataoi paajutepuapua”, cheeriatapu yawichia. ");
INSERT INTO var_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Waikaopu yawichi weweripateriaa, wa'a noonowiriatapua waikao, yooma aaataoi paajuteriatapua waikao, ka'karuma ti'tijoeri ki ka'karumaoipua tiame. Waikao yooma aaata paajutetia e'enakamea, apoche puuua pochiriatapua nenewiwachio. ");
INSERT INTO var_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","’Ehjepao Yawichia wa'a eenaka ne'niaio yoorekoo, aaata tijoechi ne'neka itipiriatapua, pu'kao ki nenewiniachi wakirataniame chuhchaka eenariopa. ");
INSERT INTO var_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Pu'kao chaaneriatapua: “¿Achini ihsika pakikamua i'wasio, ki nenewiwachi enapaniame wakiraekai?” Nape puuua kihta nehjiaka ihchi itipiriatapua. ");
INSERT INTO var_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Waikao yawichia chaaneriatapua wa'a neesetowao ko'kopuachio: “Purimitia pu'ka tijoeo sekachi tonochi tiame, wa'a ikisa ma'chi ipamitiapua pu'kaopu tukapachi ki ma'chiachi, wa'ao te'ta naarakoniachi; wa'ao tahpitika chaniwachi taameraopua ki'sukao.” ");
INSERT INTO var_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Riosi ye'karichi muimichio paajutetiamea, ki ookapipu, nape wa'a muimichio uutiamea, paikapi wa'apipua, piipakame wakiraemeche. ");
INSERT INTO var_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Pa'pariseroa, neipa apochi utewaeme nayeweretia Eesusie, puuu pa'pariseroa Eesusi ahpo chapimia kateweriapua. Puuu pa'pariseroa, itapiti iinatukemo o'rariaipua Eesusio, Eesusi nehjiarichi chapinariapua pu'kao, ahjae wenejipuameopua. ");
INSERT INTO var_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Wa'a chaachapasaapua ahpominakamera te'tiameopua, aaata ti'tijoe uhjurariapua Eerore yawichichi te'teriame ahjama, Eesusio chaanemichioopua: —Masitari, nane'rena teemea aamoo tísia pichiwari chiiamekopua, pichiwa te'ta Riosichi simiyame taamo masitiamekopua aamoo, aaataoipua napati wa'achitia tetewamekopua, ki aaata epeche werumaka tiiame tetewika. ");
INSERT INTO var_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Wa'a tiiopua aamoo, taamo tuuyemitiapua, ¿kaawe ohjoare nateteniaopua Rooma ohjoeme yawichiwichioopua, Seresa tewaniamepua? ");
INSERT INTO var_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Nape Eesusia nane'riapa pu'ka erakoao, ahpo itapitichi wichijeraka chaachapopao, chaanekapua pu'kao: —Wihkuame eemea. ¿Achinikai itapiti chairachi no'o wichitenare eemea? ");
INSERT INTO var_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Ehsoo, no'o ki'yaopua piiripi toomi yawichi koparoa. Eesusia u'yepatiaapa pu'kao ne'nesaa, ");
INSERT INTO var_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","iinatukekapua pu'kao: —¿Aatanajupu ihji toomichi kahtiame nanariraa, aatanapu teewaraapua tiame i'ka toomichi iyotetiame? ");
INSERT INTO var_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Aapoeo chaachapakapua: —Seresa yawichi —chaachapakapua. Waikao Eesusia chaanekapua pu'kao: —Wa'a teesoo pu'ka yawichio, ahpo kiajerakamera kiapuapua, toomikamera; Riosio ahpo kiajerakamera kiapuapua, iyoriwakamera. ");
INSERT INTO var_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Waikaopua Eesusio wa'a tiame inamukapaopua, tísia inatamekoopua, tahpitika erapakaopua, nonorakapua wa'asi. ");
INSERT INTO var_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Pu'ka taawechi wa'apioi, ookapi saruseo ti'tijoe wa'a e'enakaipua Eesusi ne'nemia, ki'tio tuuyamekapua eenechi ahjaniameo. Ihjia i'ka iinatukekapua Eesusio chaachapaka: ");
INSERT INTO var_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","—Masitari, ehkoriami nuurarichio, Moisea cheeriaipua: Aaata tijoe pa'chira neewikai ki taanaeka mukisoo, wa'api poonira ahjama neewinuriamepua, pa'chi uupirao, ahpo tatanao ahpo pa'chi tatanarachitia enemichiopua. ");
INSERT INTO var_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Wee, aamo tuuyemane aachin teeeriaopua aaatao i'wao taamo mochiwachio. Piie taaweo, oowisani ahpo poponiemea, pahcha simiyame pa'chiraa, neewisache wa'atia mukuriataipua ki tatanataka. ");
INSERT INTO var_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Wa'achi ijikiriatapua wahjachi poponiraai, ahpo pa'chi uupira ahjama nenewikaméa, wa'atia ki tatanátaka yooma pipiripi wahjipariatapua, ahkasi yooma oowisanisi kajuka, kiisi tatanataka wahjipakao. ");
INSERT INTO var_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Yooma i'ka wahjipasoo, oowitiameai mukuriatapua waikao. ");
INSERT INTO var_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Wee, ihji oowitiamea, yooma pu'ka oowisani ahjama neewikame enesaa, ¿aatanakamerapu te'ta kuunaraa i'ka oowitiameo, i'ka oowisani ahpo poponieme ahjama nenewikamea, pichiwa enesoo eenechi ahjapuameo? ");
INSERT INTO var_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Waikao Eesusia nehjiakapua: —Eemea sewina chaachapanipua, kiisi machiyapa eemea Ehkoriami Iyoterichi chiiao, ki machiyapa tiameo, Riosi utewarario. ");
INSERT INTO var_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","¿Ki nane'riamekosaai eemea wahjipakameo, eenechi ahjarichio, kiteremerikopua nenewiniameo? Wa'a eenechi ahjatiachio, ti'tijoea oowerua tiame, Riosi ku'kuira tewekachi ohjoemeka te'teremeripua. ");
INSERT INTO var_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Nape pu'ka eenechi ahjaniamechi naewaniachio, ¿ki iyonakamekosa eemea pu'ka Ehkoriami Iyoteri chiiao? Riosia eee cheeriaipua: ");
INSERT INTO var_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“Neee puuu Apoea, Aurani Riosiwaraa, Ihsa Riosiwaraa tiame, Aakowopua tiame Riosiwaraa wa'achi.” Riosio pu'ka Riosiwarako tuuyoiopua pehjio, wahjipakame eneriaipua wa'asio. Riosia wa'a cheekao, simitiameko tuukamepua ahjaniameo, nape ki weeechi weerewa weerewaeka. Wa'a teeresoo ki aamo chaachapachitia tiiame puuua, wahjipatioo ki eenechi ahjaniameko tuuyao. ");
INSERT INTO var_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Wa'a tiiame inamukapa yooma wa'a napawikamea, ma'chiame chiiopua Eesusio, tísia peenia tiiame chiiopao, ki teesa pu'sereka inamukapua waikao. ");
INSERT INTO var_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Waikao parisero ti'tijoea nane'riapa saruseo ti'tijoeo, newitoriopua Eesusio, ahpo poanapuka teesa, kateweriapua ihtanachi chapipuameopua Eesusio. ");
INSERT INTO var_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Wa'a ahpo katewesaapua, aaata te'ta peeniamera Moise nuurari, uhjurariapua waikao Eesusi iinatukemichioo: ");
INSERT INTO var_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","—Masitari, yooma puuu Moise Riosie kiaretiaa nuurari, ¿aachin tiamerajuarepu epeche nateyameraa? ");
INSERT INTO var_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Eesusia nehjiakapua pu'kao: —Epeche nateyameraa, ihjipua: “Aamo Paamira Riosio, yomatiame aamo iikae nakipuapua, yomatiame aamo e'rae iikachi, yomatiame aamo inatarie.” ");
INSERT INTO var_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Puuupua epeche nateyameraa, te'ta weruma te'terepuamea. ");
INSERT INTO var_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ookachi simiyamea nuurari, ihjipua tiameo: “Aamo piirechiopua, aamo wa'apichitia nakipuapua tiame.” ");
INSERT INTO var_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Yooma Riosi nuuraria Moiseo, ahpo naewaturachiopua tiameo, ihji ooka nuurari nokipua ahsepari teereniamepua yorapuameo. ");
INSERT INTO var_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Pu'ka nehjiasapa, iiweta wa'a mochikopua pehjio, iinatukekapua pariseroo: ");
INSERT INTO var_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","—¿Ihtana erakoame eemea, Riosie Weratiameo? ¿Aatana ojochiwarachi eenameko maaena eemea pu'kao? Waikao pa'pariseroa nehjiakapua: —Raawitaru —chaachapakapua. ");
INSERT INTO var_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Waikao Eesusia chaanekapua: —Wa'a teesoo, ¿aatia tiiachipa Raawitaruai ahpo Paamira teewarepua Riosie Weratiameo, Riosie ahpo iyoteteniaio? Ehkoriami Raawitarua ahpo Iyoterichio, eee cheerepua: ");
INSERT INTO var_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Te'ta no'o Paamiraa, chaanekapua no'o Paamira Weratiameo: “No'o ahjamina yasipamitia muuua, ahkasi no'oo, yooma aamo seepurawao, aamo taratere toapachisi.” ");
INSERT INTO var_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Wa'a cheekame enesoo Raawitaruo ehkoriamio, ¿achini teeka Raawichi eename enetapu Riosie Weratiamea, Raawitaru wa'apioi ahpo Paamira teewakamekoopua pu'kao? ");
INSERT INTO var_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","I'ka wa'a chiia Eesusio, aaataai pa'pamuratuame wa'a keepuamea, ka'chi iika nehjiame erakokapua. Waika taawechi o'inia wa'anao, aaataai ki iinatukeme erakoapua Eesusio. ");
INSERT INTO var_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Neipa i'kao Eesusia chaanekapua ahpo masitia ti'tijoeriopua, taamo ahpo masiteraopua tiame: ");
INSERT INTO var_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","—Iyoteri ti'tijoea, parisero ti'tijoea tiame, Moisetaru nuurari neesetora enepakamepua. ");
INSERT INTO var_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Wa'a iikamekopa pu'kao, pu'kakamera e'weka mochitopua, Moisetaru nuurarichi simiyame nokisika, nape kihta aampachi na'roetiameo nokisipuapua, pu'ka ahpo na'roeriopua, pu'ka aapoe ahpo na'roeriaopua, aapoe wa'apioi ki ajasepa yoorakao. ");
INSERT INTO var_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Tahpitika pehtiame tiiamekoopua yorajerawa, aaataoi ki chewame tiiameopua yoorakao; Aapoeo sutueoi ki ihchepame erakoamekopua pukachio yorapuaichio, tísia pehtiamekopaopua pu'kao yorapuao. ");
INSERT INTO var_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Yooma ihji i'ka yooraa, ahpokamera kaawe tetewipuawichio nokayamepua, weeweruma iyotetiame Ehkoriami Iyoteri e'wewa chiia, kutachi chuhchaka ohjowa pu'seriamepua, ramakachi tiame. Ihjia tiameo, ahpo wisasoriwa suuwerachio, itapiti peenia tiiame chucheraeme ohjoamepua. ");
INSERT INTO var_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Pahkochi koi'rachioi epeche kaaweruma yasirachi mochinariamepua puuua, napawikarichioi tiame epeche peenia yoratiamechi momochinariamepua tiame. ");
INSERT INTO var_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Ihjia wahka ahpo natepaniachioi poowechio, kaawe ahpo yooreka teepotajeramepua masitari teewaka. ");
INSERT INTO var_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","’Nape eemea te'ta yoorekao, aaataoi ki masitari tewapuapua, yooma eemea Riosichikamera aamo poponiemekapaopua, te'ta pichiwari Masitari iinuemekapa, piiripi wa'api, Riosie Weratiame Eesusi. ");
INSERT INTO var_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ka'te aawataoi aamo noono teewamitiapua eemea i'ka weeechi mochikameo, te'ta iyoriwa yoorekaopua; te'ta aamo Noonoa, te'ta te'pa kahtiamerapua tewekachi, káii waapisi te'pa. ");
INSERT INTO var_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Eemea aawataoi ki aamo ne'netosiame tewapuapua, i'ka weeechi mochikameo, neeechekopua Riosie Weratiamea, aamo ne'netesiamea aachin teeka aamo teetomiachiopua. ");
INSERT INTO var_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Amochio eemea, epeche weruma tiiameraa amochio, apoe inisiame enemeripua itapiti aamo yorakewao. ");
INSERT INTO var_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Puuu ahpo wa'api werumatamea, yooma tesiwa erapatepuamekaitepua; nape ki ahpo weruma uuyameraa, puuukamera werumatapuaitepua. ");
INSERT INTO var_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","’¡Ai eeme iyoteri ti'tijoea, parisero ti'tijoeopua tiame, kiisi ahjachi kaawe simiyamechi chaachapamepua! Eemea wa'a chaachapakao, aamo wa'api yeetepamepua Riosi ye'karichi muipuao. Eemea ki muinarepua muiyao, nape kiisioi ki toinariamepua eemea aamo piirechio, Riosi ye'karichi muimichioo. ");
INSERT INTO var_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","’¡Ai eeme iyoteri ti'tijoea, parisero ti'tijoeapua tiame, kiiisíoi aamo inata chaachapame eemea! Eemea, ooweru kukunara kariwara u'yamepua. Eemea tiameo, ti'tijoeeo kaawe aamo tetewipuawichioo, ki e'nekuma ni'ochame eemea. Eemea wa'a aamo nokariawichioo, tísia kokosa yorapuame eemea Riosieo. ");
INSERT INTO var_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","’¡Ai eeme iyoteri ti'tijoea parisero ti'tijoea tiame, ki kaaweruma inatameai chaachapame eemea! Ahkaoi ohjopamepua weeechiamio pa'wechiopua tiame, ahpo na'naritomeri i'yakaopua amochitia nokayame enepámichiopua. Wa'a nokaka eemea aamo te'ta kokosa aiwapuame epechetame eemea. ");
INSERT INTO var_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","’¡Ai eeme! ¡Ki mamachiriameai eemea, aaata piirechi ki ma'chiriame neesetoka panitonariame eemea! Eemea chaachapamepua aaatao: “Aaata tiopae pichiwata ahpo iintomiao, kihta nateyo tuuyame eemea; nape tiopachi maaniamee o'ro ahpo pichiwatasoo, tísia nateyameko tuuyame eemea.” ");
INSERT INTO var_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","¡Kiisi ijinatame eemea! ¡Kiisikoi mamachiriame eemea! ¿Ki tiopachi upatiamekapapu o'roa, epeche nateyame enepakamepu? ");
INSERT INTO var_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Eemea tiameo, chaachapamepua: “Riosi tepawetiamechi natewataka iintomo tuuniamea, ki nateyameko tuuna eemea; nape wa'a oowewa towatiamechi aaata ahpo iintomo tuuya pichiwatasoo, nateyameko tuuyame eemea.” ");
INSERT INTO var_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","¡Kiisi mamachiriame! ¿Ihtanakamera epeche nateyamera maaena eemea, Riosi tepawetiachi toatiamera oowewari, naatikosaoi, Riosi tepawekamera? ¿Ki puuu oowewaria epeche nateyamepua, Riosi tepawechi toatiamekapa? ");
INSERT INTO var_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Riosi tepawetiae ahpo iintomo natewatamea, ki Riosi tepawetiachiche nayewaka chiiaitepua. Yooma wa'a maaniame to'wetiamechi ahpo natewatai chiiamepua. ");
INSERT INTO var_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Puuu Riosi tiopachi ahpo nateyataka ahpo iintomochamea, ki tiopachiche ahpo natewataka chiiai chiiamekaitepua, Riosie ahpo natewatai chiiamepua, Riosiai wa'a yooremina kahtiamekopua tiopachio. ");
INSERT INTO var_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Tewekachi ahpo natewataka itapiti iintomo tuuyamea, Riosi yasirachi ahpo natewatai chiiamepua tiameo, wa'a ikisaopua tiame, wa'a Riosi yasirachi kahtiameopua tiame, Apoe Riosichi. ");
INSERT INTO var_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","’¡Ai eeme iyoteri ti'tijoea, parisero ti'tijoea tiame, kiisi aamo erakoa chaachapame eemea! Eemea oosa marikio, piiripi poanatakiameai, Riosiwichioo, yooma itapiti echitiame pahchiraopua, meenta pahchirachitiaopua, aanisioipua pahchiraoi, koomino pahchiraoiopua tiameoio, ki e'waka mochitoame eemea epeche nateyameopua Riosi nuurario, i'ka te'ta kaaweruma masiteniamechitiaopua: tísia kaaweruma eneniame ahpo wahjachiopua, tesiwewa e'reniame aaata, te'ta Riosi nuurari iyorika yasitoniame. I'kakamera yooraka mochimete eemea aamo wahjawichioo, kiisi wahjiame teewetoka. ");
INSERT INTO var_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","¡Eemea ki mamachiriameai, aaata neesetonariame eemea! Eemea ti'tijoerio, ihta nu'uti ki kaawe tiiamekoi tísia teripo chaachapamepua; nape eemea wa'a chaachapaio, epeche ki nu'uti ki kaawe nokayame eemea, Riosiwichioo. ");
INSERT INTO var_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","’¡Ai eeme iyoteri ti'tijoea, parisero ti'tijoea tiame, ki ahpo masitia nokayame! Eemea pehtori tísia ohchorewaemeka te'tiamepua. Aampache aamo papakoame eemea, nape aamo yooreminao tísia ohchorewaeme itipitekaopua, aamo ki kaawe nokaka ichikoriaeo, eemea tiameo, aamochewichio tahpitika erakoamepua yooma ihta itapitichio. ");
INSERT INTO var_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Eeme pa'pariseroa, kiisi mamachiriame ti'tijoe: aamo yooreminakamera papakopapua pahchao, wa'atiao ma'chioi papakotiame itipimapua. Wa'a tiiame papakotiame enesaa eemea, yooma aamo yooraai ka'karuma enemapua waikao. ");
INSERT INTO var_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","’¡Ai eeme iyoteri ti'tijoe, parisero ti'tijoe tiame, sewina erakoai chaachapame eemea ki kaawerumachi! Eeme wahjipame toaniachika te'tiame eemea aamo yooreminao, ma'chio peenia yooraka tosawetiame, nape yooreminao, tahpitika tiiamekaitepua pikakameo, oowera tisiwa eiwepua tiiame. ");
INSERT INTO var_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Wa'a te'tiamekai yooreminao, ma'chio ka'karumaka te'tiamepua, nape aamo yooreminao pochikame kahtiaipua aamo wihkuariao, aamo na'arariaoipua tiame. ");
INSERT INTO var_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","’¡Ai eeme iyoteri ti'tijoea, parisero ti'tijoeapua tiame, kiisi kaaweruma erakoai wa'a chaachapame eemea! Eemea wahjipame wetemajira wejayamepua, aaata Riosi nayewatuame meritioopua, kaawe erakoamekapa. Wa'a te'tiameai eemea, tesiwa yoraretupua me'yakao chaachapamepua chaachapao, nape amochio ki wa'a erakoamekai. ");
INSERT INTO var_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Ahkasioi eemea, chaachapamepua tiameo: “Teeme ehkoriami mochiriame enesaa, ki ku'imii teemea pu'ka Riosi nayewatura ko'yakao, pu'ka eerara wi'sutekao.” ");
INSERT INTO var_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Nape wa'a chaachapaio eemea, pu'ka noonowiria Riosi ehkoriami nayewatura ko'yakame, pu'ka ojochiwarasisikameko tuuyamepua. ");
INSERT INTO var_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","¡Ki wa'achikosa nokayame eemeai, ehpiámikosaoi! ");
INSERT INTO var_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","’¡Eeme siinowi iikamepua! ¡Sayawe ti'tijoe! ¿Aamo newipamio maayame eemea Riosi aamo kokosamiachio, ki teesa tiiame aiwapuameo? ");
INSERT INTO var_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Pukaepa amochi uhjuremania, te'ta Riosichi simiyame nayewatura, te'ta ma'machiyamera masitekao, te'ta pepeneka ye'kamera, aamoo Riosichi oowe erapatemichiopua. Nape eemea pu'kaoio, ko'imerapua tiame ookapio; wahjachi pu'kaopua tiameo, kurusichi chuhchaka ko'imerapua; epeche wahjachiopua pu'kao tiame, aamo napawikarichiamio, wepika kokosa aiwatemeri eemea, yomachi mochiwachiami wa'achi nokimeripua naanaritoka. ");
INSERT INTO var_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Yooma pu'ka aamo ehkoriami ki kaawe noonowiriawichioo, yooma aamo ki kaawe noonowiriawchioopua tiameo, te'ta kokosari iintomeri Riosia amochio. Yooma eemea Riosie kokosapuamepua, Riosi na'nayewatura ko'yakamekapa, ehkoriami Aaweri taawechisi o'iniaopua, ahkasi Sakaria Werekia taanara taawechisi, pu'kao eemea, naasipa Riosi iyoriwachi Riosi tepawetiachi ihsioiopua. ");
INSERT INTO var_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Neeea i'ka kokosari Riosi iintomerio, ki nu'uti pichiwa chiiamenia, kiisi wa'atia itipimeripua kii iintokao, yooma aamo ki kaawe nokayamechiopua. ");
INSERT INTO var_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","’¡Ai muuu Eerusareni! ¡Muuu Riosi na'nayewaturao papaka ko'yakamea, aamokamera no'o uhjurekoipua, Riosi te'ta ka'karuma nayewaturaopua! ¡Kehkinasa aamo na'poanarekame neeea aamo tatanao, nu'nunti pipilochitia no'o masatere koominarekaopua, aaata totori yeeyera ahpo tatana koominariachitia! Nape muuu Eerusarenia ohsotia aamo wa'inekamepua. ");
INSERT INTO var_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Pukaepa wa'a te'terekamekapa eemea, aamo te'ta iyoriachi tiopaa, ooruchi itipimeripua. ");
INSERT INTO var_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Aamo chaaniamenia tiameo, ki no'o tetewipuamekopua, ahkasi taawechi chaachapaniachio: “¡Nee, Riosi te'ta taamo Paamira Tijoetukamea, kaawechupena tamochi eename puuuapa!” ");
INSERT INTO var_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Eesusi Eerusareni tiopachi machenaso nonoraka nokisinioiopa, teeme Eesusi masitewaraa tísia peenia tiiame peeniatewetiame tetewapa tiopa ka'kariwarao, chaachapasiai teemea: —¡Néee! ¡Ne'neo achini yooraka tísia peeniatewetiamepu tiopaa! ");
INSERT INTO var_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Nape Eesusia poanachi sewina tiame e'rapao, chaanekapua taamoo: —Wa'a tiiame tiiao ihjia, nape ihji wa'a tiiame aamo tetewaa ehpe, meeriamahkaopua taawechio, kiisi raampata itipimiitepua tehte to'weraa. Yooma pihtuame itipimiitepua ru'mikao. ");
INSERT INTO var_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Wa'a muuwarichi puuyasaapua, Oorio roomosate e'enatiapua waikao. Teeme masiteraa wa'a yasipasoopua Eesusio, naaepaka iinatukekapua, piineri kahtioio: —Paamiraa, wiitu i'isaeri tiopachi taamo cheeriao, ¿achinitio wa'a ikimeri puuua? ¿Ihtana enetapua naania teerewaa, i'ka wehjoari kajuyachi aamo eenechi enamiachiopua? ");
INSERT INTO var_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Taamoo nehjiakapu Eesusia: —Waika taawechiami mochikamea, yooma noochi paparakamea amochitia, tísia kaawe ahpo inatemetepua, ki aawata ahpo wisikuemichiopua. ");
INSERT INTO var_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Waika taawechiamio ki ookapi e'enamerikopua: “Neeepua Apoe Riosie Weratiame”, chaachapame. Wa'a chaachapakao puuua, ki ookapi ti'tijoeri wihkuemeripua, ti'tijoe, ooweru tiame. ");
INSERT INTO var_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Waika taawechiamiopua tiameo, ki nu'uti nasiwaniame inamupuamepua ahkaoi. Nape wa'a teetoiopua pehjio, ki te'ta majapuamepua pehjio, ki te'ta kajuyachipuapua pehjio. ");
INSERT INTO var_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Piiripi ti'tijoeturia piirechi ti'tijoeturichi nasiwari mehtameripua. Piiripi yawichituwachi, piirechi yawichituniamechi nasiwasimeripua, ahpo soontarowae. Waika taawechiamio tísia toorewi aiwapuamepua, waikamio ihji wehjoari weeechiamioi tiame, ahkaoi ki muenati noonomeripua. ");
INSERT INTO var_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Nape yooma i'ka ikiyoiopua pehjio, pukeri o'icharichi enemapua tísia iinya tiame aiwapuachiopua, ki teesa kokosa tiiame aiwapuachio. ");
INSERT INTO var_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","’Waika taawechiamio amochitia noochi paparakameopua, tísia nekamuchepuame puuua, yomatiame i'ka wehjoarichi mochikameeopua; pu'kaopua chapisaoi tísia na'ara kokosa yorapuamepua, ahkasioi merinarekaopua. ");
INSERT INTO var_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Wa'a yoraniapa puuu noochi paparamea, ki ookapi noochi paparamea toimeripua, ahpo noochi paparao. Waikaopua, noochi paparame nekamuchiamekapaopua, ki ookapi noriwi wenejimapua pu'kao. ");
INSERT INTO var_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Waika taawechiamiopua tiameo, ki ookapi Riosi nayewatuame puuyamapua, kiisi pichiwa chaachapame Riosi pichiwarirao, puuua wa'a chaachapaka wihkuekao, ki ookapi ti'tijoe ooweru tiameo, sewina erapatemapua. ");
INSERT INTO var_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Pu'ka taawechiamioi, tísia muuweemapua tiameo, na'ara nokayameai, ahpo piirechi kaawe e'riameai, wekamapua ahpo piirechi kaawe e'riao. ");
INSERT INTO var_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Nape noochi wa'api teetokamea paparakao, kiisi sewina erapaka ahkasi kajuyachio, newipatepuamepua no'o Noono Riosieo. ");
INSERT INTO var_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Ihji kaaweruma tuuyewari Riosi ye'karichi simiyamea, yomachi wehjoarichi tuuwitopuamepua, ke'chu wa'a ikinioiopua, yomatiame i'ka wehjoarichi, nane'reka mochitopuamichiopua; waika enemeri, i'ka wehjoari kajuyachiopua wa'asio. ");
INSERT INTO var_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","’Ehkoriami Riosi nayewatura Raanieriai, itapiti eee tuuwame cheeriaipua iyotekao, wahka ihtorichio, itapiti tísia iinya tiiame werapuamekopua Riosi te'ta iyoriwachiopua, tiopachio. (Aaata i'ka iyoteri iyonamea, Raanieri cheereria pu'ka iinya tiiamechi simiyame iyotekao, ahkasi ikisopa nane'remapua pehjio, ihtanakoopua pu'ka iinya tiiame ahpo iyonariao.) ");
INSERT INTO var_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Waika wa'a tiame ikiyopaopua, pu'ka te'ta iinya tiiame te'ta Riosi iyoriwachi yachatiame naaniatiwariaopua, Uurea mochikamea ti'tijoeria, tísia majaka kaawichiami ujumeripapua waikao. ");
INSERT INTO var_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Te'pa karijampa ihsiamea, ka'te tekimitiapua itapiti ma'chipamiaopua ahpo petechio, ohso kaawe wa'atia toisa ujumameripua. ");
INSERT INTO var_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ahpo wasawachi nokayameai tekipanakao, ki ahpo ta'pechio e'enametioi teeremeripua, ahpo wisasoriwaoi ma'chipamiaopua. ");
INSERT INTO var_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","¡Ooweru petetiamea, kohja chiitiamea tiame pehjio, tísia tesiwa te'teremeripua waika taawechiamio! ");
INSERT INTO var_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Pu'ka taawechiamio, yomatiame ti'tijoeri mochikamea, Riosichi itaka mochimetepua, ki tuuroi enemichiopua pu'ka kajuyachi taawechiami ikinioiopua, resipuniame taawechioiopua. ");
INSERT INTO var_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Waika taawechi aiwaniamio, ki teesa kokosa tiiame aiwaniame teeremerikopua, ihta taawechioi naayachisi o'iniao, ka'chitia aiwatiamechitiaopua, neipamioipua ki iintumeriopua wa'a ikiniameopua aiwario. ");
INSERT INTO var_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Pu'ka aiwari ki ku'we teewetesoopua Riosio, ki aawata newimeriaipua, nape Riosia pu'ka aiwario, ahpo uuriachi ti'tijoerio, ki tehpe teewetemeripua pu'kao, yooma ahpo uuriao, apochi newipateka. ");
INSERT INTO var_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","’Pukaepa wahka ihtoriachi ahjaka mochitoameopua, aamo chaaniamenia, aaata wa'amahka enasoo aamo chaanekao: ¡“Nee, i'wa kahti Riosie Weratiamea”!, ¡“Waamiami ihtonapua”!, aamo chaanesooiopua, ka'te pichikemitiamua pu'kao, wa'a chaachapoio. ");
INSERT INTO var_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Aamo mochikachio e'enamiitepua aaata ki pichiwa chaachapame, Riosie Weratiame ahpo teewaka. E'enamitepua tiame, wisikuaka Riosi nayewatura ahpo teewaka, ki nu'unti peenia ihsiwa nokimeripua tiame, ahkasi Riosi uuriaoi wisikuemeripua. ");
INSERT INTO var_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","I'ka aamo tuuyamenia, kaawe aamo neesetoka mochitomichiopua pukachio, ke'chu enapoiopua pu'kao, ");
INSERT INTO var_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","aaata aamo chaanesoo: “Nee, Riosie Weratiamea, waami ihsiamepua ki tijoeekachi”, ka'te siimpamitiapua wa'ao; seenekachiooio aamo chaanesoopua aaatao: “Nee, waami kahtipua yooremina”, ka'te pichikemitiapua pu'kaoi. ");
INSERT INTO var_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Ka'te pichikemitia pu'kao, no'o enameria yomatiame ma'chiame weeechi tetewiniame enameripua, kuhjipari tahjepakamechitia, cherayachisi o'inia ahkasi ariyachisi. ");
INSERT INTO var_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Yooma pu'ka wa'a tiiame ikiwame no'o aamo chaaneriachitia teetoopapua, kihta toiyame enemapua wa'asio, no'o enameriopua wa'asiopua, oonori ruhjiame tetewapachitia eemea, wa'a po'ipu mukukamea erakopapua. ");
INSERT INTO var_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","’Waika taawechiamio, neipa te'ta tísia aiwari u'matosoopua, ikanati taaa tukapasipamapua, meechaai choipameripua ahpo mechatajenao, so'poriai ruhjimeripua waikao tewekachi o'iniao; ahkasi tewekachi ohjoeme nanaarame utewariraai, chachapia noonoimapua majaka. ");
INSERT INTO var_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Waikao te'pa tewekachio, no'o Tijoe Tijoetukame enameriopua wa'asi, tísia naaniateremeripua, tahpitika tiiame. Waikao yomatiame weeechi ti'tijoeturi ki Riosichi paparakamea, naarakomapua chaachapakao: “¡Ai teemea, kiisiki ahjameripua!”, chaachapaka, no'o Tijoe Tijoetukameo ki nu'uti utewarieo tajitoame, toomarichi weritoka no'o tekioio. ");
INSERT INTO var_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Waikao weeechi tekisaapania, no'o ku'iwari ki ku'ita chiiame kusutenuramania ahpo turupuchario, yomachi weeechi inamumichiopua, ahpoo yooma na'poapuamekoopua noochi upapuachiopua, yooma te'ta noochi paparakameopua, pu'kao yooma no'owichio uuriaopua, yomatiame i'ka wehjoarichi naomina ohjoemeopua. ");
INSERT INTO var_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","’Pahtemitia eemea, i'ka wauri echiwamechi simiyamechi nayewaniame, wa'achitarichio: Eemea i'ka wauri uuyoiopua sawatakao, nane'rema eemea amori asiyamekopapua paamunio. ");
INSERT INTO var_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Wa'achitia teeka no'o enamiachi taawechiopua, yooma i'ka no'o cheeria tetewapa ikiwameo, nane'remapua no'o Tijoe Tijoetukameo, tísia waapi ihtoamekopua wa'asi, ahpo petechi pakiwachi weeriamechitiakopua wa'asi. ");
INSERT INTO var_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Yooma ihji no'o aamo chaaneria ikipuameo, ikikache itipimapua, ke'chu wahjipoi i'ka no'o cheeria tetewikameopua, waika taawechiamio. ");
INSERT INTO var_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Tewekaa weeea tiame kiterepamapua, nape yomatiame ihji no'o aamo chaaneriaa, kiisi wa'atia itipimeripua, kiisi ikikao. ");
INSERT INTO var_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","’I'ka wa'a tiiame ikimeriopua keenakoo, aawataai ki nane'riamepua pu'kao, ihta taawechioi ikipuameo, tewekachi ohjoemeai Riosi ku'iwari, kiisi nane'riamepua, neeeai tijoechitia nane'rewao, apoeche nane'riamepua pu'kao, te'pa tewekachi kahtiameche no'o Noono. ");
INSERT INTO var_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","’Ehkoriami Nooe taawechiamichitia ikitiameka teeremeri no'o eenariwaa. ");
INSERT INTO var_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Ke'chu i'ka weeechi si'riwa neeroiopua, natakeka mochitoriaipua tiameo, pu'ka taawechiami itapiti ta'iria pahkotaka, nenewiwa ta'iria pahkotaka tiame, ahkasi ehkoriami Nooeo, tisiwá ki nu'uti pawekakerachi pakiriochisi. ");
INSERT INTO var_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Senawato yu'ki wawasora eenakaopua, yooma si'ripurepua. Wa'achitia no'o enamio taawechiopua, wa'achitia senawato enameripua; wa'a teeka enameri neeea, neee Tijoe Tijoetukamea. ");
INSERT INTO var_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Pu'ka taawechio, ooka nokayachio, piiripi wa'api apechunapuamepua. ");
INSERT INTO var_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Ooka ooweru nokayamea tusuka, piiripi apechunapuamepua, toaka piireo. ");
INSERT INTO var_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","’Pukaepa ki nane'riapa achinitio no'o enamerikopapua, no'o aamo Paamiraopua, ka'te kochika mochitomitia eemea no'o enamiao. ");
INSERT INTO var_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Eemea inataka keepusaomua i'kao: Aaata kariwaemeraa, nane'riame enesaa ahpo ichikopuao, ki kochika yasimii puuua, te'ta taawechi ahpo ichikuepuachiopua. ");
INSERT INTO var_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Pukaepa eemea ka'te kochika mochitomitiapua, i'ka no'o Tijoe Tijoetukame eenoiopua, neeea, senawato enamerikaitenia. ");
INSERT INTO var_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Wa'a cheesaapua Eesusia, eee taamo chaanekapua: —¿Aatanakamera ohjoare te'ta kaaweruma seekaerewaa? Kaaweruma seekaerewaa ihjipua: aaata teekorae toitiame ahpo ta'pechi neesetomichio, kaawe koi'teka yasitokamepua ahpo teeko ta'pechio, yooma kaawe yooraka yasitokameopua, ahpo teeko weweripateriao ahpo ta'pechi, ahkasi ahpo teeko eenachisi. ");
INSERT INTO var_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Waikaopua, ihji Teekoraa eenechi eenasaapa, tísia kaawe yoramapua pu'kao, ahpo ta'pechio tísia kaawe neesetoka yasitoriopua pu'kao. ");
INSERT INTO var_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Puuu teekoraa, kaawe neesetokame enesoopua ahpo ta'pechio, ¿ki epeche tiiame tehki kiatarepua neesetomichioo, ahkasioi yooma ahpo iinuewachiopua? ");
INSERT INTO var_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Nape pu'ka neesetoame ahpo toariao, na'ara iintokame enesoopua ahpo ta'pechio, ");
INSERT INTO var_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","wepikame enesoopua ahpo ta'pechi weweripakameo, oowera yasaka koaka nawajikame enesoopua, ");
INSERT INTO var_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","teekoraa senawato enasaa, tísia kokosa yoramapua pu'kao. ");
INSERT INTO var_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Wa'achi yorameri Riosiai aaatao, ki ahpo chiia e'waka yasitosoo. Poanatamapua pu'kao, ki ahpo chokichi yasitomichiopua pu'kao, tísia aiwaniachi ipamapua pu'kao, ki teesa naarakoniachi, tahpitika cheeniachi taameraopua ki'supakaopua, tísia aiwakao. ");
INSERT INTO var_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Waikao Eesusia, pu'ka ooka seekaerewachi simiyame wa'achitari naewaka kajusaapua, oosa mariki kutewechi simiyame, wa'achitarichi o'inekapua taamo naewekao, eee cheekao: —Nee, no'o Noono tewekachi kahtiame ye'karichi muimeria, kaawe ahpo katewetiame mochitomeripua no'o eenachisi puuyekao, aaata nenewiwachi noonowitiachitia. No'o keepumitiao i'ka wa'achitarichi no'o chanimiao, i'ka eee tiiameo: Piie taawechio, oosa mariki kutewe eneriataipua, muuwaeme napawiriachi nenewipuachio. Wa'a nenewiwachio puuu oosa mariki kutewea, neewimeri natepamerikataipua tahjetokao. ");
INSERT INTO var_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Puuu oosa mariki kutewea mariki puuua, ki ne'niame eneriataipua ahpo ikitariao, nape mariki puuu oosa mariki kutewea, kaawe ijinatame eneriataipua ahpo ikitariao. ");
INSERT INTO var_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Ihji mariki ki ahpo a'chi ikimia inatakamea, ki soparame i'toriataipua aasieteo, ahpo tahjewa to'emiaopua. ");
INSERT INTO var_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Nape piire mariki kutewe ki kochika te'terekamea ahpo tahjetomiao, u'matoame soparame i'toriatapua ahpo ahjae tahjemia aasieterao. ");
INSERT INTO var_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Nape wa'a neewimeri puuyeka mochinioio, tehpe eenepakopa neewimerio, kokochipariataipua ki anachapakapa kochirewao. ");
INSERT INTO var_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Nape naasipa tukaoopua, sisinapuretiatapua tahjera tahjemichiopua, eee cheeka: “¡Née, wa'a ihtona neewimeriapaaa! ¡Tahjetoka natepasaaa!” ");
INSERT INTO var_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Waikaopu yooma puuu kutewea, mochisiriatapua waikao yooma ahpo tahjetomia tajenatemia. ");
INSERT INTO var_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Nape puuu mariki kutewe ki ahpo ikimia inatakamea, yooma soopasaapua ahpo tahjetoa aasieterao, chaachapariatapua ahpo wahjachi mariki kuteweo, ahpo ikipua inatakameopua: “Eemea, taamo rewemitia ku'witaoi aasiete, amori choipatiameka teeme taamo tahjetoao, wakipamekapua wa'asi aasietera.” ");
INSERT INTO var_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Nape puuua kutewe aasiete i'toamea pehji, chaachapariatapua pu'kao: “Ka'i, ki aamo kiama teemea. Aamo kiasaa teemea, ki ijinueka itipimeri teemeai. Tarimitia eemea ohso kaawe.” ");
INSERT INTO var_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Nape pu'ka kutewe aasiete tarimia siimparioiopua, puuu kutewe ahsepari aasiete i'tokamea, ahjama muiriatapua neewimiachio, pahkochi. Pu'ka ahjama muisoopua neewimeria, yeeteparetiatapua muiwachio. ");
INSERT INTO var_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Puuu kutewe aasiete tarimia siimpakame e'enasaapa, chaachapaka sisinamuriataipua muirachio: “¡Taamo paamiraaa, taamo wahjonesaaa, muinariame teemeee!” ");
INSERT INTO var_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Nape apoe neewimeria nehjiariatapua pu'kao: “¡Ka'i eemea! ¡Kiisi aamo machiyamenia aamoo!” ");
INSERT INTO var_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Eesusia kajusaapa i'ka wa'achitarichi naewakao, taamo chaanekapua ahpo masitewao: —Pukaepa eemea kaawe aamo neesetopuapua, no'o enamiachi taawechisiopua, no'oo senawato enamerikopapua. ");
INSERT INTO var_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Pu'ka oosa mariki kutewe noonowiria nayewasaopua, teekora iintoria ahpo tomiwae, wa'achitarichi taamo nayewekapua eee cheeka: —No'o enamiaa i'ka wa'achitarichitia teeremeripua. Piie taawe aaata teekoraa, aaata ahpo tekipanatia ahpo toomi tekipanamichio toowesa simiriataipua wahka, seenu weeechi. ");
INSERT INTO var_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","’Piiripi pu'ka toomi tekipanamerio, mariki miiri apoche o'ro toomi ki'yariataipua. Piireopua pu'kao, ooka miiri. Piirechi pehjiopua tiameo, piire miiri toomi tooweriatapua pu'kao. Ihji toomi kiatiamea, yoomahka tekipanaka muuepumichio eneriataipua, ahkasi ahpo ye'kachisiopua pipiripio. ");
INSERT INTO var_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Waikaopu mariki miiri apoche o'ro toomi kiatiamea, oosa mariki miiri iintapariatapua pu'kao, tekipanakao. ");
INSERT INTO var_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Puuu ooka miiri apoche o'ro kiatiamea, naao miiri iintapariatapua pu'ka toomio, wa'achitia ooka miiri yowiteriatapua ahpo teekoo. ");
INSERT INTO var_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Nape piie miiri apoche o'ro toomi kiatiamea, kihta muuwepuriatapua, oowera wa'amiahka majisa yasariatapua pu'ka toomio. ");
INSERT INTO var_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","’Tehpe neipamio teekora enasaapa, ne'neriatapua i'ka noonowiriaopua ahpo toomiwaeo, kehkisa ahpo yowika machenariaopua ahpo toomiwaeo. ");
INSERT INTO var_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Waikao mariki miiri tooetiamea, pahcha naaepakaopua ahpo teekoo, chaaneriatapua pu'kao: “Íya, i'wa maani aamo toomiwaa mariki miiri, i'wachi maaniamepua tiameo, mariki miiri toomi no'o yowiteria tekipanakao.” ");
INSERT INTO var_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Waikao apoe teekoraa chaaneriatapua pu'kao: “Kaawe iintokame muuua no'o tekipanakiaa, kaawechupena aamochi oowe e'rere neeea. Kaawe tekipanatekamemua no'o toomiwao, wa'a aamo iintoriawichioonia, epeche weruma aamo kiamania tehkio. Kaawe e'ramitia muuua noochio, wa'achi erameri neeeai amochio.” ");
INSERT INTO var_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Ehjepa neipao, wa'achi eenariatapu ahpo teekoe ooka miiri tooetiamekai toomi. Puuua wa'achi eenakaopua chaaneriatapua ahpo teekoo: “Paamira, i'wa maani ooka miiri toomi, aamoo no'o tooeria tekipanamichioo. I'wachi maanipua tiame ooka miiri, aamo toomiwae yowiteria tekipanakao.” ");
INSERT INTO var_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Pu'kao teekoraa chaaneriatapua: “Tísia kaawe iintokamemua tiameo, kaawechupena kaawe iintorenia aamochi e'rarenia. Kaawe neesetoremua no'o tomiwao, wa'a aamo iintoriawichioo neeea, ehpeche epeche tiiame aamo toowemania yowitemichioo. Kaawe e'ramitia muuuai noochio, neeeai wa'achitia e'ramepua amochio.” ");
INSERT INTO var_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Waikaopu piie miiri toomi toowetiamea, ahpo teeko naaepakao, chaaneriatapua pu'kao: “Paamira, i'wa maani piie miiri aamo no'o tooweriaa. Neeea nane'riamekapa ki cheriwiamekopua ki kaawe machenatioo, aamo majawekania, aamoo ki echakamekaio, muuu i'ipamekopua, aamoo oritiameo ki ekasuwakai ekasuwatiame uuyamekopa. ");
INSERT INTO var_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Pukaepania aamo tomiwao, kihta muuwepukania, wehtere majika katewekania ohso kaawe. Pukaepa wa'api kehki aamo no'rawenania toomio, i'wa maanipua wa'api kehki.” ");
INSERT INTO var_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Nape teekoraa wa'a iintoriopua pu'kao, chaaneriatapua pu'kao: “Kiisi kaawe iintokamemua, oowera nahsinaka yasakamemua, kihta yooraka pu'ka toomio, itapiti muuetekao. ");
INSERT INTO var_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Muuwejerame e'rakame enesaamua pu'ka toomio, toomi yowiteniachi toamii muuua, pu'ka toomio ehpe taawechi no'o eenoiopua, yowika manimichiopua paikapioi, paikapioi yowikame no'o teimichiopua eenoio.” ");
INSERT INTO var_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Wa'a chaanesapa teekoraa, ahpo tekipanatiameoopua chaaneriatapua pu'kao: “U'yemitiapua pu'kao pu'ka piie miiri no'o ki'yaria toomio, naatikamera kiamitiapua pu'kao, oosa mariki miiri muuwepukamera tekipanaka. ");
INSERT INTO var_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Wa'achitia Riosichi tekipanameai, epeche kaawe iintokamea Riosie ahpo oowetiao yorajera, epeche kaawe yorapuamepua wi'suamesi; nape kiisi yoorakamea Riosi ahpo ooweria teesaoi Riosi nakiya yorajerawao, teesaoi ahpo oowe e'reretia wekatemapua, kihta yoranarekapapua Riosi tehkirao. ");
INSERT INTO var_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Waikao Riosia pu'kao, ki apochi teerenarekopaopua apochi tekipanakao, pu'kao, tukapachi ipamapua pu'kao, wa'ao te'ta naarakoniachi, tísia kokosa tiiame aiwaniachi, wa'ao tísia aiwakao, ma'chi cheeniachi taamerao ki'supaka.” ");
INSERT INTO var_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Waikao Eesusia teekora ahpo tomiwae iintoria kajusaapua, wa'achitarichi naewakao, i'ka wehjoarichi mochiniame katewerichi simiyame, taamo nayewekapua wa'achitarichio, eee cheeka: —Neee Tijoe Tijoetukame eenaio, norikame tajitoka enamerinia, no'o tewekachi ku'iwari ahjama; wa'a teetoka enamerinia, no'o ye'karichi yasipamiao wa'asi. No'o ye'karichio, tahpitika teeremeripua wa'ao, te'ta peenia tiiario. ");
INSERT INTO var_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Waika taawechionia, yoomatiame wehjoarichi mochikame ti'tijoeo ooweruo tiameo, no'o kahtiachi upanuremania pu'kao, yooma ahpo nonowiriaopua, katewepuawichiopua. Waikaonia Tijoe Tijoetukamea, ti'tijoeo ooweruopua tiameo, poanatamania pu'kao, aaata tepuyamechitia po'wao, poanatamechitia chiiwachio. ");
INSERT INTO var_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Waikaonia pu'ka po'wachitia no'o poanatariao, no'o ahjamina mochiwama neeea. Pu'ka chiiwachitia no'o poanatariaopua ti'tijoeo ooweruopua tiameo, no'o oweminakamera iintapamania pu'kao. ");
INSERT INTO var_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Waika wa'a iintosaania, no'o ahjamina mochiwariao chaanemania pu'kao: “Yooma eeme no'o Noonochi piipakamea, no'o Noono ye'karichi mochimeripua, no'o kahtiachi ahjama. Ihji no'o ahjama aamo mochimiaa, ke'chu naayachikoi o'inia eratiamepua no'o Noonoeo, waika o'inia aamowichio nuuteweniame. ");
INSERT INTO var_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","I'ka no'o wa'a iintomiaopua aamo no'o ahjama mochimiao, no'o chorooi eeme ko'koteriawichiopua; no'o paramukoiopua no'o nerojiteriopa; no'o pooechi ihtoio aamo ta'pechi no'o asipuriopa, no'oo aamoo, kaawe noonowiriopua pu'kao; ");
INSERT INTO var_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","no'oo wisasori nakiyoio, no'o ki'yariopua pu'kao; no'o kokorioiopua, no'o ne'nemia e'enariopua aamoo; no'o perekarichi kahtioio, wa'achi e'enariopua aamoo, no'o ne'nemia.” ");
INSERT INTO var_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Waikao no'o ahjamina ajawariaa, chaachapamapua: “Nape Paamira, ¿achinitio wa'a noonowikame teemea, aamo chorooio aamo ko'koteriao, aamo paramoi nerojiterioio? ");
INSERT INTO var_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿Achinitio aamo kaawe yoorakame teemea taamo ta'pechi i'tokao? ¿Achinitio aamo ku'ikame teemea, ki aamo wakiraekoio ki'yakao? ");
INSERT INTO var_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","¿Achinitio siimpakame teemea aamo ne'nemia kokorioio? ¿Achinitio aamo ne'nekame teemea aamo karichi kahtioio?” ");
INSERT INTO var_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Waikao neeea Yawichichitiao, nehjiamapua: “¿Ki no'okosa ku'ikai iikame eemea, aaata no'o poponichitia tetewao no'o pipinichitia tetewaopua tiame, tesiwa te'terioio aamo ku'irioiopua?” ");
INSERT INTO var_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","’Waikao no'o owenamina ajakameopua chaanemania pu'kao: “Eemea se'wimitapua noochio, eemea Riosieo, te'ta kokosarichi uhjurapuamepua, te'ta aiwaniachi na'ie tatae, kiisii seenampa choipachi na'i, Satanasi ipapuachi na'itiachi, wa'a aiwatepuachi pu'kao yooma ahpo ku'iwari ahjama. ");
INSERT INTO var_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Wa'a yorapuame eemea no'o chorooio, kiisi ko'kotekamea, no'oo tísia paramoio, kiisi nerojitekameo; ");
INSERT INTO var_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","no'o ki machiwachi oiyoio, kiisi no'o asipuriopua aamo ta'pechio; no'o wisasori nakiyoio kiisi no'o ki'yariopa; no'o kokorioiopua kiisi no'o neesetoriopa, no'o karichi kahtioio kiisi e'nariopa no'o ne'nemiao.” ");
INSERT INTO var_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Waikao no'o owenamina ajakamea chaachapamapua: “Nape teemea Paamira, ¿achinitio aamo tetewikame teemea chorowameo, paramuameoio, ki machiwame oiyoio, wisasorioi nakiyoio, kokoriameoi po'yoio, karichi kahtioiopua tiameo? ¿Achinitio ki aamo ku'ire teemea?” ");
INSERT INTO var_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Nape neeea Yawichichitia kahtiaio, aamo chaanemapua: “¿Ki nane'riame eemea aaata tesiwa te'tioio ki ku'irioo, ki nane'riame eemea no'okamera ki ku'irioo?” ");
INSERT INTO var_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Wa'a teesoo no'o owemina poanatatiamea, riisaka aiwaniachi uumpamapua, ki wahjika aiwaniachi; puuu no'o ahjamina poanatatiamea, ki wahjiame ahjaniachi itipimapua. ");
INSERT INTO var_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Neipa yooma pu'ka taamo cheesaapa Eesusia, taamo chaanekapua ahpo masitewao: ");
INSERT INTO var_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","—Nane'riame eemea ooka taawe toiyamekopua wa'asio, Semejenato pahko enemiachio. Wa'a pahkochi neee Tijoe Tijoetukamea, kurusichi meripuamenia, nanaaramechi ki'yaka. ");
INSERT INTO var_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Pu'ka taawechiami ne'neseriosi pa'pamiratuamea, Uurio pirenaturi o'ochetiamea tiame, Kaija te'ta neeseriosi paamiratuame kahtiachi napawiriaipua, te'ta weruma tiopachi. ");
INSERT INTO var_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Ihjia Eesusi ahpo chapipua katewemia napawiriaipua, a'chikoi yooraka meripuaichiopua, wistuka. ");
INSERT INTO var_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Puuua ahpo katewekao chaachapariapua: —Nape pahkokoio ki chapima teemea pehjio, ki tahpitika noonoimichiopua pu'ka na'naritoao nenekaka. ");
INSERT INTO var_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Eesusi Wetania ihsioio Siimoni reperaeme teewataniame ta'perachio, ");
INSERT INTO var_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","wa'a eenaka piiripi oowitiame sewajuya i'tokao, puuua piire riimeta pochikame u'pariapua pu'kao, tísia nateyame. Ihji oowitiamea wa'a enasa, meesa chokichi kahtioiopua Eesusio, moochi to'wepakapua ahpo sewajuya u'pariaopua. ");
INSERT INTO var_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Teemea wa'a iintokame tetewapao, kiisi kaawe erakokao, taamo chaachapaka teemea: —¿Achinikai ihji oowitiamea na'atanipua pu'ka sewajuya, tísia nateyameoiopua? ");
INSERT INTO var_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","¿Ki ookapi toomichi nehjime teeeriaipua ohso kaaweo, kihta ko'kome tiamekoopua ihkokepuaichio? ");
INSERT INTO var_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Nape Eesusia inamuriapaopua taamo chaachapao, taamo chaanekapua: —¿Achinikai wa'a aamo chaachapani eemea i'ka oowitiame wa'a ihsiame tetewikapao? Ihji oowitiame noochi iintoriaa, káátisia kaawe iintotiamepua. ");
INSERT INTO var_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Kooamewichio tesiwa te'tiamea, senepi taawechi tetewimeri eemea pu'ka ku'ipuawichioo, nape no'oo ki senepi taawechi tetewimeri eemea. ");
INSERT INTO var_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Ihji sewajuya no'o to'wetiamea, no'o weerewa kateweka ihsitiame puuua, ke'chu no'o mukuyoio, no'o weerewa ki iinyajuwa ujuremichiopua. ");
INSERT INTO var_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Pichiwa chiiamenia i'kao, ihji oowitime no'o yoorariaa, ahkasi wahka ihtoriachi i'ka Riosi kaaweruma tuuyewari nayewatuniachisi, nayewapuame ihji oowitiamea, inatepasikao. ");
INSERT INTO var_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Waika taawechiamio piiripi taamo Eesusi oosa mariki aampa ooka masiteraraa, Uurasi Ihkarióte tewaniame masiteraa, ne'neseriosi pa'pamiratuamechi simiriaipua. ");
INSERT INTO var_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Pu'kao chaaneriapua wa'a eenakao: —¿Ihkina no'o kiatare eemea Eesusi no'o amochi nejisoo? Aapoeopua chaachapariapua: —Ahkasi piie weerewa aampa oosa mariki tataparasi toomi. ");
INSERT INTO var_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Waikaopua, pu'ka toomi ahpo kiatiachisi wa'anao, o'ineria Uurasia i'yakao, aachin teeka noriwi nehjimiaopua Eesusio. ");
INSERT INTO var_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Pahcha taawechi pahkochio ki rewaruraeme koi'wachiopua paanio, teeme masiteraa, iinatukekapua Eesusio: —¿Akana aamo yorakejeranimua Semejenato koi'wariopua? ");
INSERT INTO var_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Wa'a taamo chaanesoopua puuua, taamo chaanekapua: —I'ka muuwarichi siimpamitia eemea i'ka tijoe ta'perachi, pu'ka wa'a ta'peemeo chaanemitiapua: “Taamo Masitariaa, eee aamo chaanemichio taamo uhjurakapua: Waapi toinapua no'o kiteremiachio; wa'ami simiyamekane aamo ta'pechi, Semejenato koi'wari ko'komiaopua, yooma no'o masitera ahjama.” ");
INSERT INTO var_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Wa'a chaanetiapa teeme masiteraa, wa'a siimpatiapua waikao. Wa'a e'enasaopua teemea, yooma iintokapua chaaneretiao, wa'a yoratiapu kooameai. ");
INSERT INTO var_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Ehjepami aari enasaapa Eesusia, meesamina yasipakapua, yooma taamo ahjamaopua, oosa mariki aampa ooka masitera. ");
INSERT INTO var_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Wa'a koaka mochinioio, taamo chaanekapua Eesusia: —Aaata i'wa mochikamea teeme, no'o noriwi nehjimeripua. ");
INSERT INTO var_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Waikao teeme masiteraa, tísia yuuwesipatiapua. Wa'a chiiopao teemea yoomahka pipiripio, iinatuketiapua: —¿Paamira, aatana ohjoare puuua, neeekosa? —chaachapatiapua. ");
INSERT INTO var_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Neipa yooma wa'a chaachapatioopua, nehjiaka Eesusia: —Aaata piirepua, taamo ahjama ichuyame. ");
INSERT INTO var_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Neee Tijoe Tijoetukamea, wa'a yooraka noriwi nehjipuamepua, Ehkoriami Iyoterichio, wa'a chiiopa, nape ¡ai puuua, aaata wa'a iintokamea! Epeche kaawe eneriaipua, ki naawakame enesaa. ");
INSERT INTO var_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Eesusia, Uurasi ahpo noriwi ihsiame iinatukekoiopua cheeka: —Paamira, ¿neee ohjoarepua? —Wa'a chiiame muuua —chaanekapua Eesusia. ");
INSERT INTO var_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Waikao koi'oiopua pehjio Eesusia, piiripi paani uusa chi'wanasao, cheriwema ki'yakapua ahpo Noono. Wa'a iintosaapua, chaanekapua taamoo: —Ihji paania no'o weerewapua. Eemea yoomahka eeme pipiripio, chi'watiame ko'komeripua. ");
INSERT INTO var_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Wa'a ikisaopua, itapiti iijiwari uusaopua piie paasoo, cheriwema ki'yakapua tiame ahpo Noono, wa'a iintosaopua, chaanekapua taamoo: —I'ka, paasochi maaniameo, yoomahka pipiripi iijimeri eemea i'kao. ");
INSERT INTO var_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Ihji paasochi maaniamea, no'o eera puuua. I'ka eeraeo, weemera kateweri ti'tijoeri ahjama no'o yahchapua, yooma ti'tijoeri tatakoririao, cheriwepuamewichio no'o wi'sumeri. ");
INSERT INTO var_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Eesusia, simiteka taamo tuuyekao, cheekapua: —Neeea aamo chaanenapua, ki oosa no'o iijimio tuunania, i'ka uuwa neeroraopua, ahkasi no'o Noono ye'karichi, taamo mochipachisiopua. Ahkasi waika enemapua, eenechi aamo ahjama iijimiaopua, i'ka panijuwari neeroraopua. ");
INSERT INTO var_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Neipao, wiikari wikatasaopua, teewi siimpatiapua waikao, Oorio Roomosachi. ");
INSERT INTO var_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Wa'ao Eesusia, taamo chaanekapua ahpo masiterao: —Eemea ehpe tukaoo, yooma eeme no'o toimeripua. Ehkoriami Iyoterichio, eee chiiamekopua: “Tepuyamea meripuamepua, tepuniamea, chi'ripameripua.” ");
INSERT INTO var_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Nape neeea eenechi meritiai ahjasaapa, Arirea weeechi siimania ke'chu wa'a aamo e'enoi no'o ne'nemiao. ");
INSERT INTO var_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Peeroa chaanekapua waikao: —Yoomahka aamo toitarepua nape neeea ka'i; kiisi aamo toimania. ");
INSERT INTO var_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Wa'a chiiopua Peeroo, chaanekapua Eesusia: —Pichiwa chiiame neeea ehpe wa'api tukawarichio, ke'chu totojowira kusuyoio, paisa no'o ka'itamerimua. ");
INSERT INTO var_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Nape wa'a chaanetiai Peeroa, nehjiakapua: —Kiisi wihtuka chaaninia pu'kao, mukimiaiopua aamowichioo, kiisi aamo toimania. Wahjachi masiteraai, wa'achi chaachapatiapua. ");
INSERT INTO var_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Ehjepao Eesusia masitera ahjamao, E'semaní tewaniachi e'enatiapua. Wa'a asisaapua Eesusia, taamo chaanekapua ahpo masiterao: —I'wa itipimitia eemea ku'itapio. Waami siminania ku'itapio, no'o Noono ahjama nayewamia te'pa kahtiameo. ");
INSERT INTO var_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Wa'a cheesaopua, waanami akipakapua teesa, Peero yeeka, na'pa Sewereo tatanara tiame. Wa'ao Eesusia, tísia iiyana erapakaopua, ");
INSERT INTO var_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","chaanekapua ahpo yeetoriao: —Neeea ehpeo, tísia yuuwesiamepua, ahkasi mukime eraniame iikachio. I'wa no'o puuyemitia eemea pehjio, ne'neka mochika. ");
INSERT INTO var_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Wa'a cheesaopua epeche teesa waanami enepasaapua, wehchisi koomorasipakaopua, chaanekapua ahpo Noonoo tewekachi kahtiameo: —No'nooo, no'o sewina teeremia enesaamua, i'ka aamo iintomia noochi tísia yuuwesiao, no'o se'wipuaoiopua. Nape ki no'okamera e'rachitia iintojeraninia aamoo, aamo e'rachikamera. ");
INSERT INTO var_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Ehjepao Eesusia, taamo ahpo masitera toariachi eenaio, kokochiame tewakapua taamoo. Wa'a te'tereriopa taamoo, chaanekapua pu'ka Peeroo: —¿Ku'itapioi ki ne'neka mochime erakona eemea? ");
INSERT INTO var_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Pusakame moochíii, neesetowa itaka Riosichio, ki aamo ahsemichiopua na'arario. ¿Ki nane'rena eemea kaaweruma erakoaio, senawato ki kaawerumachi wichitariaio, weerewao ki anachamekopu moochi inatarichi eraniameo? ");
INSERT INTO var_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Eesusia, oosa simiyachi simisaapua ahpo Noonoma nayewamiao, chaaneka nayewekapua: —No'noo, ki teeresoo no'o se'winapua i'ka tísia no'o aiwa yuuwesiao, aamo e'rachitia iintopuapua, ki no'okamera e'rachitia. ");
INSERT INTO var_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Eenechi oosa simiyachi eenaka ne'nioio, kokochiame taamo tewakapua. Teemea puichio, kiisi ne'neme erakoamekapua kokochinaria. ");
INSERT INTO var_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Wa'a te'tiame toisaapao, eenechi siinkapua ahpo Noono ahjama nayewamia, paisa simiyachikapua wa'asio. Waikaoi Eesusia, wa'api cheeka nayewekapua ahpo Noonoo. ");
INSERT INTO var_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Eenechi eenaiopua wa'asio taamo pe'tiachio, taamo chaanekapua: —¿Iiweta kokochina eemea pehji? ¿Tísia reresipakame eemea? Ne'neka mochikaa, asikame neeeapa, Tijoe Tijoetukameapa, nanaaramechi kiapuachiopua, ichipukao. ");
INSERT INTO var_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Mochisíka wa'ási. Wa'a ihtoamepa no'o noriwi nanaaramechi kiameria. ");
INSERT INTO var_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Iiweta wa'a chiioi Eesusio, Uurasia piiripi taamo oosa mariki aampa ooka masiteraa, taamo mochikachi asikapua, muuwaeme yeeka soontaro. Ihji ahjama e'nakamea, nasimacheta makoka e'enakamekapua; puuu wahjachia, kuuu ahjae wewepuame. Yooma ihjia, ne'neseriosi paamiratuame uhjurariamekapua, i'isaeri o'ochetiame pirenaturi tewaniame tiame. ");
INSERT INTO var_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Uurasia noriwi nehjiakaopua Eesusio, chaanekame eneriapua soontaroo: —Aaata no'o chuchuya, puuu enemapua chapipuamea. ");
INSERT INTO var_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Pukaepa Uurasia Eesusichi asikao, —¡Kúíraaa, Masitari! —chaanekaopua Eesusio. Wa'a chaaneka Eesusio, chuchukapua. ");
INSERT INTO var_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Waikao Eesusia wa'a yoratiapao, chaanekapua Uurasio: —¿Ihtana e'raka ihsiamemua?, no'o kaawe uuyaa. Ikanati iintosa naaju, aamo iintomia eenariao. Wa'a cheesoche Eesusio, soontaro i'tomeria, naaepaka chapisa i'tokapua. ");
INSERT INTO var_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Nape Eesusi chapinioio piiripi teeme Eesusi ahjama ohjoamea, ikanati ahpo nasimacheta ma'chipasapao, nakachi meteka tehpunekapua nahkarao, piiripi pu'ka te'ta ne'neseriosi weripateriaopua. ");
INSERT INTO var_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Nape Eesusia wa'a iintokopa pu'kao, chaanekapua pu'kao: —Ka'te wa'a iinto muuua. Yaapiti katewesa muuua pu'ka aamo merimachetao. ¿Ki nane'renakosa muuua ki wa'a ihsimerikopua? ¿Ki nane'riame muuua merimachetae ko'yameo, merimachetae meriniamekoopua tiame? ");
INSERT INTO var_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿Ki nane'riame muuua no'o nehpurewa itanesoopua no'o Noonoo, u'matoame piie miiri Riosi ku'iwari no'o uhjuremiikoopua, no'o nehpupamichioopua pu'kao? ");
INSERT INTO var_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Nape wa'a no'o iintosoopua, ¿achini ikitapu Ehkoriami Iyoterichi chiia, no'o Noono tewekachi kahtiameopua, ikipo tuuria? ");
INSERT INTO var_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Waikao wa'a chaaneka terisaopua merimachetae metekameopua, Eesusia chaanekapua ahpo chapimia e'enakameo: —¿Achini iikai eemea kuuu wewera makoka enapamepua, nasiwaniame maacheta makokaopua tiame, aaata ki nu'uti na'ara iintokamechitia chapimiao? ¿Ki senepi taawechi no'o tetewikame eeme tiopachi masitiame? ¿Achinikai ki wa'a no'o chapika eemea? ");
INSERT INTO var_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Nape eemea, wa'a noonoimeripua noochio, pu'ka Ehkoriami Iyoterichi chiiao, pichiwa machenamichiopua, ehkoriami Riosi nayewatura, chaachapariao. Wa'a o'inia Eesusi chapitiachio, piineri toaka teemea, yooma ujumatiapua. ");
INSERT INTO var_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Wa'a chapisa Eesusia Kaija peereimia napawiniachi i'toretiapua, ne'neseriosi te'ta paamiratuamechi. Wa'a weruma yooremina napawiniachio, wa'a napawiriapua, iyoteri ti'tijoe, o'ochetiame tewaniame pirenaturi tiame, Eesusi chapitiame katewemiapua, puuyeka. ");
INSERT INTO var_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Peerochea waikao, piineri na'naritoriapua neipa, ahkasi ne'neseriosi te'ta paamiratuame ta'perachi. Wa'a ta'pechi pakisaapua, tiopachi ne'nesetoame ajakachi weripakapua ne'neka, nane'renariapa puuua, aachin teeremerikopua Eesusichio. ");
INSERT INTO var_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Yooma neeseriosi pa'pamuratuamea, oochetiame pirenaturi tewaniamea tiame, te'ta weruma napawiwachi napawikamea, Eesusi meripuamesi wenejiwa i'yaipua. ");
INSERT INTO var_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Nape Eesusia ki ookapi itapiti wenejika e'enatiaipua, kihta na'arari teitiapua, yooma wistuki chaachapariapua. Nape wa'asi neipaopua wa'ao, ooka e'enakapua wenejiame, ");
INSERT INTO var_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","puuua chaachapakapua: —I'ka tijoeo teemea, i'ka chiiame inamukapua: “Neeea i'ka tiopa ru'minakaio, paika taawechi weramania eenechi.” ");
INSERT INTO var_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Waikaopu te'ta paamiratuamea neeseriosi, werisika iinatukekapua Eesusio: —¿Kihta nehjianimua pu'kao, ki nu'uti na'arario tuuka wenejiniai? ");
INSERT INTO var_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Nape Eesusia ihchi itipikapua. Waikao te'ta neeseriosi paamiratuamea, chaanekapua Eesusio: —Pichiwa Riosi ahjamechi pichiwataka nehjiapuapua, ¿pichiwa Riosi Taanarakosa muuua, Riosie Weratiame? ");
INSERT INTO var_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Eesusia waikao cheekapua: —Eje'e, wa'atepua, te'ta aamo chiiachitia. Neeea aamo chaanemapua tiameo: No'oo Tijoe Tijoetukameo, tewekachi kahtiame no'o tetewipuawite neeea, te'ta no'o Noono yawichituwa yasirachi ahjamina kahtiame, ki nu'uti utewarieka yawichituame. Wa'a o'iniao no'oo toomarichi weritoka eename tetewipuamepua. ");
INSERT INTO var_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Wa'a chiiame inamukapa Eesusio, waikaopu te'ta ne'neseriosia tísia nekakao, ahpo si'panakapua wisasoriwao. Wa'a iintosaapua, chaanekapua yooma wa'a napawikameopua: —¡Ihji tijoe chiiaa, tísia na'araripua Riosichioo! ¿Aatia aaata nakita teeme, epeche pichiwatameri? Eeme wa'api inamukamepua wa'asio, Riosio, tísia na'ariamekopua. Waikao te'ta neeseriosia yooma ahpo ahjama napawikameo, iinatukekapua chaanekao: ");
INSERT INTO var_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","—¿Achina erakoame eemea pu'ka chiiao? ¿Ihtana yorapua erakoame eemea pu'ka? Waikao wa'a napawikame iinatuketiamea, chaachapakapua: —¡Merisáaa! ¡Merisáaa! ¡Riosi tísia na'ariame puuuaaa! ");
INSERT INTO var_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Waikao ookapi weruma napawitiachi mochikamea, Eesusi weeriachi e'enapaka akachupiapua, nanarichi. Wahjachia teesa wepakao, chaachapapua iinatukekao: ");
INSERT INTO var_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","—¿Ki Muuukosapu Riosie Weratiame? ¡Ehsoo, taamo tuuyesao aatanakamera aamo wewekame teeme! ");
INSERT INTO var_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Peeroa wa'a nokioiopua yooreminao, ma'chi kahtiapua Kaija kaarira ta'pewarachio. Wa'a kahtioiopua Peeroo, wa'a eenaka piiripi oowitiame wa'api tekipanamea, chaanekapua: —¿Ki pu'ka ahjama oiyame muuuai, Arirea ohjoeme chapitiame ahjama? ");
INSERT INTO var_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Peeroa nehjiakapua: —Ka'i, neeea. Kiisi machiyamenia pu'kao, aamo chaachapao. ");
INSERT INTO var_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Waikao Peeroa, waami puuyaniachiami ihtoio, wa'aoi piirechi oowitiame tiamea, Peero tetewikapao tiameo, chaanekapua ahpo wahjachio: —Ihjipu tijoea tiame, i'ka Eesusi Arirea ohjoeme ahjama oiyamea. ");
INSERT INTO var_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Waikao Peeroa eenechi ka'itakapua Eesusio cheeka: —Kiisi machiyamenia pu'kao; ki pichiwa enesoo no'o chiiao, mukitaonia —cheekapua. ");
INSERT INTO var_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Ehjepatakirio wa'a nokayamea, Peero naaepakao, utewaeme chaachapakapua: —Pichiwápua muuu tiameo, i'ka Eesusi ahjama oiyamea, wa'achi cheeka nayewame muuúai. ");
INSERT INTO var_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Waikao Peeroa, eenechi ka'itakapua Eesusio, paisachi simiyameopua, eee cheeka: —Kiisiki machiyamenia pu'ka tijoeo. Wa'a cheesoche Peeroo, kusuchachakapu totori oowiraa. ");
INSERT INTO var_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Waikao Peeroa Eesusi cheeria inatepariapua: “Muuua, ke'chu kusuyoi totori oowirao, paisa simiyame no'o ka'itamerimua.” Wa'a iikapa Peeroa, tísia iiyana erapakaopua yuuwesika, ma'chi machenaka nanarariapua. ");
INSERT INTO var_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Pu'ka meere ma'chirepasoopua, yooma ne'neseriosi pa'pamuratuamea, i'isaeri pirenaturi o'ochetiame tewaniameapua tiame, Eesusi meripuame kateweriapua. ");
INSERT INTO var_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Waikao Eesusi purisapaopua, Piiratochi i'totiapua, Rooma ohjoeme te'ta yawichiwichio yawichituamechi. ");
INSERT INTO var_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Waikao Uurasia Eesusi noriwi nehjakamea, Eesusi meripuame iintoriapao, tísia iiyana eraparepua ahpo tísia na'ara iintoriaopua. Wa'a erapakaopua pu'ka piie weerewa aampa oosa mariki tataparasi toomio, eenechi no'rapurepua neeseriosi pa'pamuratuameo, o'ochetiame pirenaturi tewaniameopua tiameo. ");
INSERT INTO var_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Wa'a iintosaapua pu'ka pa'pamuratuameo, chaanerepua: —Ki nu'uti tatakorire neeea aaata kihta iintokameoipua nehjakao. Nape puuu pa'pamuratuamea, chaanerepua Uurasio: —Muuua, muuukamerapua tatakorikamea, teemea kihta noonowikamepua. Amoe wa'api wa'a iintokamemua pu'kao. ");
INSERT INTO var_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Waikao Uurasia wa'api i'isaeri tiopachi ihpapasesapao toomio, ma'chi akiparepua wa'a mochiwachio. Wa'a machenasaapa puuua, ahpo kuuuchi chuhchaka wiitarichio, ahpo topepateka me'yarepua. ");
INSERT INTO var_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Waikao te'ta pa'pamuratuamea pu'ka toomi apechunasaopua, chaachaparepua ahpoo: —Ihji toomio eeraemekopaopua pu'kao, ka'chi iika towapuamepua Riosi oowewari maaniachio. ");
INSERT INTO var_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Waikaopua kaawe ahpo katewesaopua, Sikoritame Weewara tararepua ahjaeo, seesenu ti'tijoeri wahjipame toapuachi. ");
INSERT INTO var_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Waika o'inia ehpiamisiopua pehjio, We'e Eeraeme teewaniachipua wa'ao. ");
INSERT INTO var_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Wa'a teeka pichiwa machenare Eremia cheeriaa Riosi nayewatura, puuua eee cheeriaio ahpo iyoterichio: “Puuu isaeri pa'pamuratuamea, ahpo noriwi nateteriae nehjitiameeo, pu'ka piie weerewa aampa oosa mariki tataparasi toomio, eenechi no'raputiame itipikamepua. ");
INSERT INTO var_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Pukae toomie taritiame Sikoritame Weewaraa. Neee Eremiaa, wa'a chiiame iyotekamenia, te'ta no'o Paamira tewekachi kahtiamee, no'o nane'reteriachitia.” ");
INSERT INTO var_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Eesusia Piirato yawichichi upasao, eee cheeka iinatuketiapua: —¿Pichiwa uurio ti'tijoeri yawichiwara muuua? —Eje'e, aamo chiiachite puuua —nehjiaka Eesusia. ");
INSERT INTO var_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Nape puuu ne'neseriosi pa'pamiratuamea o'ochetiame pirenaturi tewaniame tiamea, weeru chaachapoipua Eesusi na'arekao, ihchi itipikapu Eesusia. ");
INSERT INTO var_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Waika Piiratoa Eesusio ihchi itipikopao, chaanekapua Eesusio: —¿Kiisi inamuamekosamua yooma aamo tísia na'arechanewao? ");
INSERT INTO var_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Nape Eesusia kiisi nehjiakapua pu'kao. Wa'atia itipikapua. Yawichia wa'a tiiopa pu'kao, “iinsa tiiame ihjia”, erapakao, ka'chi ikime e'rapua. ");
INSERT INTO var_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","I'ka pahkochio, aaata karichi kahtiame toiniame eneriaipua pu'ka taawechiamio, aaata itasoopua ma'chi toipuawichioo. ");
INSERT INTO var_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Waika taawechiamiopua, wa'a karichi yasariaipua piiripi tijoe tísia inamuniame, Eesusi Warawasi tewaniame. ");
INSERT INTO var_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Pukaepa Piiratoa machenaka iinatukeriaipua wa'a napawikameo: —¿Aatanakamera toijerame eemea, Eesusi Warawasi, naatikosaoi, Riosie Weratiame Eesusi? ");
INSERT INTO var_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Piiratoa Eesusi Riosie Weratiame toinuramio o'rariaipua, kihta na'ara iintokamekopua Eesusio, oowera tísia nakiniamekopa Eesusio tísia muuwaeme ti'tijoerieopua. ");
INSERT INTO var_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Nape Eesusi katewenioiopua Piiratoeo, Piirato uupiraa, chaanenuraka uhjureriapua Piiratoo, eee cheeka: “Ka'te katewemitiamua pu'ka tijoechi simiyameopua wenejiniameo, kaaweruma tijoekopa pu'kao, pa'a tukaoopua neeea, tísia iinya tiiame teemukania amochi simiyameopua, kiisi kaawe tiiame aamo iintosoopua pu'ka tijoechio.” ");
INSERT INTO var_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Nape pu'ka wa'apichio ma'chio, neeseriosi pa'pamuratuamea, o'ochetiame pirenaturi tewaniameapua tiame, Warawasikamera toinuramichio, oowe erapaterepua ti'tijoerio, Eesusikamera meripuawichio. ");
INSERT INTO var_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Pukaepa Piirato eenechi ti'tijoeri iinatukioio aachin tiamera toipuamekoo, Eesusikoio, Warawasikoio, ti'tijoeria chaachapakapua siinakokao: —¡Warawasikameraa puhjésaa! ¡Warawasikamera puhjésaa! ");
INSERT INTO var_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Piiratoa wa'a chaachapopao ti'tijoerio, eenechi iinatukeka chaanekapua: —¿Ihtana iintotane Eesusio, Riosie Weratiame tewaniameo? Pu'kao muuwari ti'tijoeria, chaachapakapua: —¡Kurusíchi me'yaaa! ");
INSERT INTO var_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Wa'a chaachapopao Piiratoa, chaanekapua: —Nape ¿ihtana ki kaawe iintokamepua wa'a yorapua? Waikao muuwaeparia, epeche utewaeme chaachapakapua: —¡Kurusichi merisáaa, kurusichi merisáaa! ");
INSERT INTO var_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Piiratoa ka'chi ikime e'rapa Eesusi toinariaio, epeche teetopa muuwario chaachapakao, Piiratoa neeroi uusao, yooma tetewachi paanikokapua cheeka: —Neee aamo noonowinariao, paanikonania pu'kao, kihta teerenariapa noochio, pu'ka meritioio —chaanekapua pu'ka muuwepari tísia siinakoameopua—. Eemekamera kokosapuamepua, neeea ka'i. ");
INSERT INTO var_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Waikao yooma muuwaria nehjiakapua: —¡Wéee, pe'yáchiii! ¡Pe'yachi tamochi wichitapu Riosi kokosáriaaa, yooma taamo tatana tijoetusiwachiopua tiaméee! ");
INSERT INTO var_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Wa'a chaachapopaopua pu'kao, Warawasikamera puhjesa toakapu Piiratoa; Eesusio wepinurarekapua pu'kao, wepisaopua, merinurekapua pu'kao, kurusichi chuhchaka. ");
INSERT INTO var_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Waikao Eesusia soontarokarichi uparetupua kapitaichi. ");
INSERT INTO var_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Wa'a ajapasaapa kapitai kahtiachio Eesusio, yooma wakirapusao, sehtamurame wakirateriapua waikao. ");
INSERT INTO var_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Wa'a yorasaopua moochio, wehcha pi'rinaka yawichi mo'kori netesaopua, mosokiraterepua. Wa'a noonoisaapua, ahjamina sekachio yawichi teesorara makotesaopua, yawichi teewaka aacherepua na'areka. Wa'a yorasaapua, chopokorieka aajapeka Eesusio, eee chaachapariapua na'arekao: —¡Kúíraaa, isaeri yawichíwaraaa! ");
INSERT INTO var_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Wa'a chaachapakaopua akachupiapua paanatao, wa'a nokakaopua tiame, pu'ka wa'api teesorae ahpo ki'yariae, moochi wepariapua wa'ao. ");
INSERT INTO var_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Wa'a nokisaapua na'arekao, pu'ka ampawakira sehtamurameo puhjesaopua, wa'api wakirara chuhcheriapua eenechi. Yooma wa'a noonoisaapua yooreminao, merimiachi i'totia Eesusi wa'asi, kurusichi merimia. ");
INSERT INTO var_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Wa'a i'tonioio siimpaniachio, pooechi natepatiapua piiripi tijoe Siimoni tewaniame. Ihji tijoea Siirene weeechi ohjoeme eneriapua. Waikao soontaroa pu'kao, Eesusi ku'ika i'tonurekapua kurusio, ki kakajuopua Eesusiopa mooketokao. ");
INSERT INTO var_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Wa'a nokisia Ókota tewaniachio, ajasitiapua, Wahjipakame Mo'ojowa chanika chaniwamechi. ");
INSERT INTO var_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Wa'ao Eesusio waikao, chipuwari neerora wiino ahjama kiatiaipua tisiwá chihpuame, nape Eesusia yenasache ki nakikapua. ");
INSERT INTO var_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Kurusichi chuchasaopa so'sontaroa, Eesusi wisasoriwao ahpo newitowa te'ekapua pu'kao, aaatakamera newitokamea, ahjama itipimichiopua, ehkoriami Riosi na'nayewatura te'ta chaachapariachitia, puuu te'ta ikitiapua. ");
INSERT INTO var_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Wa'a nokisaopua, wa'api mochika itipirepua inatekao. ");
INSERT INTO var_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Wa'a kurusichio moochikamera tepaminao, itapiti iyotetiame chuhcheretiapua, aatia tiiachipa meritiamekopua chiiame. Puuu iyotetiamea, chiiamekapua: “Ihjipu Eesusia, uurio ti'tijoeri yawichiwaraa”, chiiamekapua. ");
INSERT INTO var_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Ooka ichikoame chucharetiaipua tiameo, piiripi ahjamina, piirea owemina, na'pa puuua neneku chokichi, pipiripi kurusichi. ");
INSERT INTO var_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Wa'a chuhkoi Eesusio wa'ami u'matopamea, na'areka Eesusio, mo'rewaka u'matopapua chaachapa: ");
INSERT INTO var_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","—¡Nee, muuua tiopa ru'minakaio, paika taawechi weramio tuukamekaiomua eenechio, ¿ka'chi iika aamo newime o'ranimua ehpeo, pichiwa tísia utewariemeko tuukamekaio? ¡Pichiwa Riosi Taanara enesaa, tekisáoko ehpeo, wa'a kurusíchio! ");
INSERT INTO var_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Puuu neeseriosi pa'pamiratuamea, puuu o'ochetiame pirenaturi tewaniameaipua tiame, chaachapakapua: ");
INSERT INTO var_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","—Wahjachio newipatiameko tuukaio, ka'chi iika newipame e'ranipua ahpo wa'apioi. Ihjia i'isaeri yawichikai, tekimetiaipua wa'a kurusichio, taamoo pichikemichiopua pu'kao, apoekopua Riosichi eenameo. ");
INSERT INTO var_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Riosichikamera oowe e'riameko tuukamepua; wa'a teeresoo, Riosi apoe enamapua newipatemiao, tísia nakiyame enesaapua pu'kao: “Riosi Taanara neeea”, cheekamekopao. ");
INSERT INTO var_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Ahkasi puuu ooka ichikuame kurusichi chuchatiameai, na'ara chaachapakapua Eesusio. ");
INSERT INTO var_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Neipa pu'kaopua, oowetawesi o'inia yooma tukapasipasao, ahkasi arikiri paika keenako simiyachisi, taajenakapua eenechio. ");
INSERT INTO var_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Paika keenako teetoio Eesusia, weeru sisinakaopua chaachakapua: —Eeri, Eeri, ¿reema sawatani? —No'o Riosi, no'o Riosi, ¿achinikai no'o toakamemua? —cheeka chaniwamepua eureo naewaniachio. ");
INSERT INTO var_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Waikao ookapi wa'a ajakamea, pu'ka inamukapao chaachapakapua: —¡Néé, keepukao! Ehkoriami Eeria paaechanipua. ");
INSERT INTO var_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Waikaopua piiripi puuua, ikanati a'potiame uusa paatatiamechi saampatesao, kuhsichi chuchasa wa'apote oowepakapua, Eesusio pi'pimichiopua. ");
INSERT INTO var_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Nape i'kao oowioiopua, wahjaa chaachapakapua: —Ka'te, ka'teopua pehji. Enatakoipu Eeriaa, newipatemia. ");
INSERT INTO var_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Nape Eesusia eenechi utewaeme sisinakao, mukukapua wa'asi, ahpo Noonochi nehjakapua iikao. ");
INSERT INTO var_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Eesusi mukuyoio isaeri mochiwachi tiopachioi, tísia weruma tiiame ikirepua. Puuu wisasori Riosi iyoriwachi pejana chuhkuameai, pu'ka wa'apichi keenakoo, te'pa o'inia teeresi si'parepua. Pu'ka wa'apichi keenakooi, weeeai, ki muenati noonorepua, ahkasi e'peai yooma tataka kahsirepua. ");
INSERT INTO var_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Wa'a iikaopua tiameo, wahjipakame toatiachioi, yooma wahjorepua, ki ookapi Riosichi paparaka wahjipakamea, eenechi ahjarepua. ");
INSERT INTO var_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Neipa Eesusi oijenasoopua, puuu wahjipakame eenechi ahjakamea, ohjosirepua toatiachi puuyakao, Eerusareni e'enare puuua waikao, wa'a Eerusarenio, ki ookapi ti'tijoee tetewitiamepua. ");
INSERT INTO var_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Waikao eenechi Eesusi meritiachi nayewakao, puuu soontaro wa'a inateka mochikamea, soontaro kapitairaopua tiameo, yooma pu'ka ikiyame tetewapaopua wa'ao, weeeo tiame ki muuenati nokayopao, tísia majariapua. Waikaopua yooma wa'a tiame ikiniopaopua, Eesusio e'repakaopua, chaachapakapua: —¡Aa, pichiwa Riosichi o'inia eenakame eneriai ihjia, Tijoe Tijoetukame! ");
INSERT INTO var_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Pu'ka wa'a ikiyoiopua wa'ao, wa'achi ajakapu ooweruai muuwaeme Eesusi ahjama e'enakame, Arirea o'inia ku'isika na'naritokamea. Ihjia, mekapi ajakapua wa'ao, ne'neka. ");
INSERT INTO var_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Pu'ka ooweruchio wa'a ajakapua, Maaria Maarena, Maaria Saantiao Oose tiame yeeyera, Sewereo tatanara yeeyera tiame. ");
INSERT INTO var_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Pu'ka wa'api aari tukapasipoio, wa'achi eenariapu Oose tewaniameai Arimatéa weeechi tijoe, Eesusichi pichikiamekapaopua tiameo. ");
INSERT INTO var_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Puuu Oosea, Eesusi yeeyera ahjama ahpo katewesaapua masitewara tiame, Piiratochi simika itariapua Eesusi weerewarao, wetemajimio tuuka. Waikao Piiratoa, kianurarepua pu'kao. ");
INSERT INTO var_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Ehjepao Oosea, Eesusi weerewara tekipuketiaopua, riino wisasori tohsanamechi ikapikapua. ");
INSERT INTO var_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Pu'kao ikapisaopua, ahpo weemera teesotariachi teekakapua, ahpo mukiso tekipuachio neteriachi. Wa'a tekisaopua weruma tehte chihturame to'petiapua ki'sunaka. Wa'a ikisaapa nonoratiapua. ");
INSERT INTO var_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Nape Maaria Maarenaa, piirechi Maariaapua tiame, wa'a mochika itipikapua pehji, tekitiachi ne'neka. ");
INSERT INTO var_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Pu'ka meereo ma'chirepasoopua, yooma kateweniame tewaniame taawechi u'matosoopua, resipuniame taawechio neeseriosi pa'pamuratuamea parisero ti'tijoe tiame, pirena siimpariapua Piirato chaanemia. ");
INSERT INTO var_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Piiratochi e'enasaapua, chaachapariapua pu'kao: —Muuu Piirato, muuu taamo paamiratuameraa, naati inatepaka teemea, pu'ka meritiame ahjaka oioiopua, pu'ka tísia wistuameo eee cheekamekoopua: “Neeea meritiaio, paika taawe i'toai oijenamania eenechio.” ");
INSERT INTO var_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Pukaepa teemea, aamo inatenurawa itamia e'enakapua, wa'a mukuteso tekitiachio, ki seenekachi Eesusi masitewarao, Eesusi weerewara ichikosapaopua, oijenario tuumichioopua. Pu'kao wa'a chaachapasoopua puuu meritiame wistuniamea, epeche teeremapua, ki pukerichitia. ");
INSERT INTO var_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Waikao Piiratoa chaaneriapua: —Weh, kaawepua. Wa'a ajawi soontaroa, aamoe wa'api i'toka, inatetepuapua pu'ka mukukame tekitiachio, nape te'ta ki ichikopua teereweka. ");
INSERT INTO var_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Waikaopu isaeri pa'pamiratuamea, Eesusi tekitiachi e'enasaapua Piirato so'sontarowa i'tokaopua, tísia kaawe inatenureriapua. Waikao soontaroa wa'a noonowiwaapua, kaawe ikichesa toariapua yeetarachio. ");
INSERT INTO var_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","U'matosoopua resipuniame taawechio, pahcha taawechiopua oowisarichio, ma'chirepasoopua Maaria Maarenaa, piirechi Maaria tewaniameapua tiamea, wa'a e'enariaipua ne'nemia Eesusi mukukame tekitiachiopua. ");
INSERT INTO var_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Wa'a tekitiachi ajasisoopua ooweruo, ki muuenati noonoka we'ea, te'pa o'inia tekikopa Riosi ku'iwario. Ihji Riosi ku'iwaria, tekisache wahjonasa tehtee to'perarao, ikicha yachapasaopua pu'kao, ahjachi yasiparepua. ");
INSERT INTO var_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Ihjia, kuhjiparichitia utewaeme tajaka yasarepua, wisasoriraa, tisiwa tohsaname keepachitia. ");
INSERT INTO var_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Soontaroa wa'a tiiame tetewapao, tisiwa majariapua, ahpo sasaweriapua majaka, mukipakame ruhjirepua majakao. ");
INSERT INTO var_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Ihji Riosi ku'iwaria, chaanerepua ooweruo: —Ka'te majako eemea. Naane e'rena neeea aamoo, Eesusi i'yasiopua, kurusichi meritiame. ");
INSERT INTO var_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Nape puuua ki'tepua i'wao, oijenakamepua wa'asi ahpo cheeriachitia. Naakoo ne'nesakoopua tekitiachio. ");
INSERT INTO var_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Wa'a ne'nesaapa, yaapi nonoraka tuuyepuapua Eesusi masitewarao, Eesusi oijenariopua wa'asi, Arirea ahpo ihsimio tuuko tuupuapua pu'kao, ke'chu wa'a enapoiopua aapoeo. Wa'a ahpo tetewipo chiio tuupuapua pu'kao. I'kache aamo tuuyemia tekikamenia. ");
INSERT INTO var_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Wa'a chaanetiapapua oowerua Riosi ku'iwarieo, ikanati ujumasiriapua taamo Eesusi ajawaria mochikachi tuuyemiao, tísia majakamekaipua kaawe erakoriapua. ");
INSERT INTO var_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Nape pu'ka ooweru u'mapasioipua nonoraka, senawato pooechi machejeneka Eesusia —Kúíraa —chaanerepua. Waikao oowerua, tisiwa yuuwesiaiopua, tahpitika kaawe erapaka tetewapaopua, tonochi kooreparepua Eesusio, iyorire. ");
INSERT INTO var_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Waikao Eesusia chaanerepua pu'ka ooweruo: —Ka'te yuuwesipa, iika yachapasa naajúu. Ohso kaawe yaapi nonoraka tuuyepuapua no'o masiterao. Pu'kao chaanepuapua, Arirea no'o tetewimeriko tuuyepuapua. ");
INSERT INTO var_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","I'ka ooweruo Eesusi ma'masitera tuuyemia nonorakoiopua, ookapi soontaroa wa'a tekitiachi inatekamea, Eerusareni e'enakaopua, ikanati yooma tuuyerepua wa'a neeseriosi pa'pamuratuameo, wa'a itapiti ahpo tetewariaopua. ");
INSERT INTO var_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Waikao ihji pa'pamuratuamea i'ka wa'a tiame tuuyetiapaopua, o'ochetiame pirenaturi tewaniachi e'enarepua ahpo wahjachi ahjama ahpo erakoa katewepuawichiopua, ihtana yorapuamekopua Eesusi ki'tiopa mukukame tekitiachio. Waikao ihji o'ochetiame pirenaturi tewaniamea, ahpo napawika katewesaapua, ki ookapi toomi nateterepua soontaroo, wihtuki chaachapamichiopua Eesusi ahpo wekateriameopua. ");
INSERT INTO var_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Wa'a ikisaapua, eee chaachapanurarepua: —Eemea aaatae iinatuketiaa, Eesusi weerewarao, Eesusi wa'api ma'masitera ichikorio tuupuapua, aamo kokochioio. ");
INSERT INTO var_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Taamo yawichio nekasoo nane'resapao, teeme kaawe erapatemapua pu'kao, aamoo ka'chi yorapuawichiopua. ");
INSERT INTO var_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Waikao soontaroa pu'ka toomi uusao, wa'a tiiame katewetiame itipirepua. Pukaepa uurio ti'tijoeria, wa'api chaachamepua ahkasi ehpe taawechiamioi. ");
INSERT INTO var_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Piirechi taawechiami neipao, puuu oosa mariki aampa piiripi masiteraa, Arirea siimpariapua Eesusi chaaneriachi kaawichi. ");
INSERT INTO var_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Wa'a ajasisaapa teemea, Eesusi tetewisaapa, tísia kaawe erapatiapua tísia ahjachi paparaka mukukai eenechi ahjariopa, aaatacheo tamochio, ki te'ta oowe e'rerioiopua, te'ta oijenario Eesusio. ");
INSERT INTO var_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Neipao Eesusia, taamo naaepakao, cheekapua: —No'o Noono Riosi tewekachi kahtiamea, yooma ahpo utewari no'o ki'yakame puuuapa, yomatiame te'ta aampa tiiameopua, tewekachio, i'ka wehjoarichiopua tiame. ");
INSERT INTO var_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Wa'a tiiachipa neeea ehpe o'inia tiiame, yomatiame i'ka wehjoarichi aamo uhjuraninia, yooma noochi paparakameopua tiame nuurewaka, yomachiami siimpaka masitesimichiopua tiame, i'ka Riosi kaaweruma tuuyewariopua. Yooma pu'ka aamo masitesiao, no'o masitewara enepatemitiapua, no'o Noonochi paparaka paatosipuapua, noochiopua tiame Taanarachio, Riosiwarichioopua tiame. ");
INSERT INTO var_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Pu'kaoiopua tiame, yooreka mochiwa masitepuapua pu'kao, no'o e'waka mochitomichiopua, no'o masiteriachitia. Eemea no'oo, te'ta kaawe nane'reka mochitomitiapua, yooma aaata noochi paparakameo, ahjama ihsitomerikopua, ahkasi i'ka wehjoari kajuyachisiopua. Wee, neee Maateoa, i'wasi kajuyamenia i'ka Eesusichi simiyame no'o iyotiao. Cheriwema wa'asi, no'o aamo kaawe teererewa aamowichioo.");
INSERT INTO var_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Ihji i'wa iyotapechi iyotetiamea, Riosi kaaweruma tuuyewarichi simiyame nayewaniamepua, Apoe te'ta Riosi Taanara, Riosie Weratiamechi simiyame. ");
INSERT INTO var_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Ehkoriami Raawitaru Riosi nayewaturaa, eee cheeka iyoteriaipua Riosi chiiao, Riosi Taana nayewakaopua wahka ihtoriachi naawameriopua: Wa'a aamo uhjurenane aaata, amochi simiyame nayewamichiopua ti'tijoerio, kaaweruma pooe ahpo wahjonemichio iikachio, ke'chu aamo asioiopua weeechiami ti'tijoeri nayewemiao, no'o kaaweruma tuuyewari pichikeka mochitopuawichioopua. ");
INSERT INTO var_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Puuu Isaia cheeriaipua tiameo: Wahka ki tijoeekachi siinachaniamepua aaata tijoee, puuua eee cheechaniame: “Eeme ti'tijoe ooweru tiame, riisame pooe wahjonemitiapua aamo iikachio, Riosi chiiao aamo iikachi uumichiopua.” ");
INSERT INTO var_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Puuu wa'a ooruchi siinachania tuutiamea, Waanitaru wa'a teetomia eneriamepua, wahka mehka ki tijoeekachi tuuyeka siinachaniame, ti'tijoe ooweru tiame paatokaopua. Puuu Waania paatoka yaajatoaio eee chaaneka tuuyeriaipua ti'tijoerio: “Ka'karuma enepaka mochitomitia eemea aamo iikachio, aamo ki ka'karuma nokayao, yooma toakaopua wa'asio. Noochi e'enamitia eemea aamo ki ka'karuma nokayao, toinarepaka, aamo ki ka'karuma toinarepasoopania, aamo neeroiye paatomania, aamo tatakoririaopua amochio, no'o aamo paatoriae Riosie cheriwetiame aamo tetewipuawichiopua, ti'tijoerieo.” ");
INSERT INTO var_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Wa'a Waani kahtiachio, yooma Uurea weeechi mochikamea, Eerusareni mochikamea tiamea, wa'a e'enaparepua Waanie tuuyewa keepumia. Waania ti'tijoeo ooweruopua tiame, Riosichi ahpo cheriwejeresoopua ahpo tatakoririao, yooma toinarepasoopa ahpo tatakoririao, paatosiriamepua waikao Oorani akichio. ");
INSERT INTO var_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Waani wakirataa, tumusari animari kuuparae netetiame enerepua, puuu wahsipuraraai wi'chie netetiame enerepua. Ihji koayaa ohchi enerepua, se'ori tiame. ");
INSERT INTO var_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Waania ti'tijoerio, eee cheeka naaweseriamepua: —Neipa no'oo piirechi tijoe enameripua, piirechi aaata epeche weruma tiiame ki no'ochitia; pu'kao no'oo kiisi nateyamenia, pu'ka kakajoyaraoi no'o na'sonemiao. ");
INSERT INTO var_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Neeea neeroie paatoamepua ti'tijoerio ooweruopua tiameo, nape apoe enameri enasaapua, ahpo Riosiwarie paatomeripua. ");
INSERT INTO var_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Pu'ka taawechiamio Eesusia, Nasare mochiwachi o'inia eenakame eneriaipua, Arirea weeechi. Waania wa'a eenakopa pu'kao, paatorepua Eesusio, Oorani akichio. ");
INSERT INTO var_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Eesusia wa'a paatotiai neerochi machenaio, tewekachi wahjoame tetewarepua tepoona. Wa'a tewekachi wahjoriachitepao, Eesusia, Riosi Riosiwari tekiyame tetewarepua, kooroka tiiame, pu'ka kooroo apochi eenaka apochi yasipame. ");
INSERT INTO var_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Waikao i'ka kooroka tiiame Eesusichi yasipoio, teweka wahjorachi o'iniao, chiiame inamuretupua: —Muuujupua no'o Taanaa —chiiame—. Muuupua tiameo, te'ta no'o nakika yasitoao. Muuupua tiameo no'o iintomiawichioo, te'ta uuriaa. ");
INSERT INTO var_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Waikao Riosi Riosiwaria, seenepi pu'ka wa'apichi, mehka i'torepua ki tijoeekachi. ");
INSERT INTO var_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Wa'a ki tijoeekachio, ooka weerewa taawe yasiterepua wa'ao, oori ohjoachi. Satanasia Eesusio, tatakoritemo o'rariaipua, nape Riosi ku'iwaraai wa'achi nokarepua Eesusi ku'ipakao, Satanasi aatiatawao anachapawichio. ");
INSERT INTO var_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Neipa Waani karichi pachatioiopua, Eesusia Arirea weeechi akiparepua Riosi ahpo Noono nayewatumia, Riosi kaaweruma tuuyewari. ");
INSERT INTO var_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Wa'a Arireao Eesusia, eee chanika nayewerepua ti'tijoeo ooweruopua tiame: —Asikame wa'asiopua no'o Noonoo, uhjuramio tuuriaa. Asikamepa aamo mochikachio, Riosi ye'karichi muitemerio. Pukaepa toaka mochipuapua wa'asi pu'ka aamo ki ka'karuma nokayaopua wa'asi, ohso kaawe Riosikamera kaaweruma tuuyewarira pichikeka mochitopuapua, pu'kakamera yooraka mochitosaa eemea, newipatepuamepua tewekachi Noonoeo. ");
INSERT INTO var_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Eesusia Arirea Pa'wesuweko ihtoaio, Siimoni tewarepua ahpo poonima Anteresi ihsiame. Ihjia sochichaira ihpapaka nokariaipua pa'wechio, so'chi i'yaka tekipanaka, wa'a nokaka tekipanameka puuua. ");
INSERT INTO var_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Eesusia pu'kao, wa'ami u'matokaopua chaanesirepua na'pa: —No'o ahjama ohjoame enemitia eemea. Neeea aamoo ti'tijoeri oowe erapatiame enepatemapua, Riosi kaaweruma tuuyewarie po'wachuame. ");
INSERT INTO var_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Waikao puuua wa'api toisapa ahpo sochichairao, ahjama siimparepua. ");
INSERT INTO var_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Wa'a ikisaopua tiameo Eesusia, teesa waanakoopua tiameo, Sewereo tatanara tewarepua waikao, Saantiaoo ahpo poonima ihsiame tiame, puuua pawekakerachi mochiriaipua, ahpo sochichaira tehpuriachiami kateweka. ");
INSERT INTO var_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Pu'kao Eesusia paajutesirepua tiame ahpo ahjama ohjomichiopua pu'kao. Waikaopu tehtemaria ahpo noono pawekakerachi tekipaname toisaopua, ahjama siimparepua tiame, taamo Paamira Eesusi na'naritoka. ");
INSERT INTO var_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Wa'a inisika Eesusia, Kapenau tewaniachi asirepua resipuniachi taawechi, wa'a e'enasaopua, i'isaeri napawikarichi pakirepua ahpo ajawaria ahjama, wa'a yooremina o'inerepua masiteka. ");
INSERT INTO var_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Wa'ao Eesusi masitia keepuamea, peenia erakoka inamurepua pu'kao, tísia peeneka masitiamekopa pu'kao, Riosi kaaweruma tuuyewario, ki i'isaeri iyoteri ti'tijoechitiaopua. ");
INSERT INTO var_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Nape wa'achi tiopachioi yasariaipua aaata keewakame, na'arari pakitekame. Puuua tísia nekawekao, chaanerepua Eesusio: ");
INSERT INTO var_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","—¿Ihtana yoramia eenakamemua tamochio, Eesusi Nasare ohjoeme? ¿Taamokosa kokosa yoramia eenakamemua? ¿Ki aamo machiyamekosa teemeapa, Riosichi aamo eenakameko, aamoo te'ta Riosi kaawerumarako? ");
INSERT INTO var_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Waikao Eesusia te'yarepua pu'ka na'arari pakiteriao chaaneka: —¡Ihchi yaasa muuua na'arari! ¡Yaapiti, machenasa muuua pu'ka tijoechio! ");
INSERT INTO var_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Waikaopu nanaararia, ki muenati sasaweteka pu'ka tijoeo, ki ku'ita sisinaka machenarepua pu'ka tijoechio. ");
INSERT INTO var_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Waikaopu wa'a e'enakamea, tísia majakamekapapua, ahpo iinatukerepua chaachapaka: —¡Ihtana weemera penipaniame ihjia, ihji tijoea tísia utewari iinueka nayewamepua, ahkasi riaorósiwari nanaarariai, e'wiamepua? ");
INSERT INTO var_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Ihji Eesusi inisiriaa, ki tehpe yomachi nane'reretupua Arirea weeechiamiopua mochiwachiami tiame. ");
INSERT INTO var_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Napawikarichi puuyatioopua Eesusia, Siimoni ta'perachi simirepua Anteresi pehterachi tiame, Aakowo yeeka Waani tiame. ");
INSERT INTO var_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Wa'a ta'pechi ajasitioopua, Siimoni waasiraa ipetachi poirepua che'yame. Wa'a mochikamea chaachaparepua Eesusio, kokorenio tuuka wa'ao. ");
INSERT INTO var_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Waikao Eesusia naaepakao, sekachi chapika werisipurepua kokoriameo. Waikao wa'a ikitiaopua kokoriamea, yachaparepua ikanati. Waikaopua yachapatetiaopua, kooame yorasirepua Eesusi ko'kotemia. ");
INSERT INTO var_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Wa'ao Eesusia taaaa pakiyoio, muuwaeme kokoriame u'yeparetupua, wahjachi aaataa, na'arari yahchawa kokorewa. ");
INSERT INTO var_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Puuu ti'tijoeria wa'a karichi muirachio, tísia muuwaeme napawirepua. ");
INSERT INTO var_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Eesusia wa'ao, ki ookapi kokoriame yachapaterepua, a'chitiame ko'koame iniwaeme. Eesusia na'arario, kiisi toarepua nayewamichioo, machiwamekapa puuua pukaeo. ");
INSERT INTO var_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Eesusia wa'a mochiwachio, amori ma'chirepachi yasisisapa wa'ao, machenarepua wa'ao mehka ooruchi, ahpo Noono Riosi ahjama nayewamia yuuweekachi. ");
INSERT INTO var_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Siimonia ehjepao, ahpo ahjama mochikameo tiameo, Eesusi i'yamia siimparepua. ");
INSERT INTO var_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Puuua tewisaapa, chaanerepua: —Yooma ti'tijoeria aamo i'yani wiituo. ");
INSERT INTO var_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Nape Eesusia cheerepua: —Pirenachiami siimpameri teemea ehpeo. Nahpe, i'ka Riosi kaaweruma tuuyewario, pirenachiami i'tomia. Pu'kawichio machenakame neeea, nayewatumiao. ");
INSERT INTO var_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Wa'a ikire Eesusia waikao. Yomachi Arireami oiparepua, i'ka Riosi kaaweruma tuuyewari tuuyesikao, yoomachi napawikarichiami, mochiwachi tiame. Waikao Eesusia wa'a inisirepua waikao, yomachi mochiwachiamio, puuyachasika na'arario, kokoriame sautesikaopua tiame. ");
INSERT INTO var_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Piiripi tijoe repera kokoriamea, tawemina chokichi chopokorieka weripakao, chaanerepua Eesusio: —Aamo no'o sautejerani neeea wa'a aamo erasoo, yachapanarenia no'o kokoriao ko'koame. ");
INSERT INTO var_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Eesusia waikao cheriwepakao, ahjachi seekarepakaopua, chaanerepua: —Aamo yachapatenare neeea. ¡Yachapakame itipisa naaju muuua, wa'asi! ");
INSERT INTO var_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Wa'a chaanesochepa Eesusio, puuu repera ko'koamea, toarepua pu'kao wa'asi. Saukame itipirepua wa'asi. ");
INSERT INTO var_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Waikao Eesusia pu'kao, no'anurerepua pu'kao ahpo ta'perachi, nape utewaeme eee chaanesapa pahcha: ");
INSERT INTO var_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","—Nee. Ka'te aaata tuuyemitia muuua i'ka aamo ikiriao. I'kache iintopuapua muuua. Waami siimitia muuua napawikarichi neeseriosichi, pu'ka neeseriosio, pu'ka itapiti i'yetomitiapua Moisetaru nuurari nuura, i'ka Riosi aamo yachapariawichioo. Wa'a ihsimitiamua tiameo, i'ka Riosi iintoriaopua amochio, yooma ti'tijoeri tetewimichiopua, aamoo saukamekopua wa'asi, pu'ka aamo repera kokoriaopua. ");
INSERT INTO var_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Nape tijoea no'rasaapa yooma tuuyesirepua wa'a mochiwachio, yooma Riosi iintoretiaopua apochio, kaawe iintokao. Pukaepa neipao Eesusia, ka'chi iika te'ta ma'chiame pakime e'rarepua wa'a mochiwachio. Pukaepa oowera ma'chiche oojowirepua waikao ki tijoeekachiche. Nape ahkasi wa'aoi ahkaoi mochikame e'enaparetupua Waani keepumiaopua kahtiachi, tetewinariapa pu'kao. ");
INSERT INTO var_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Paikapi taawechiami neipamio Eesusia, eenechi pakirepua Kapenauo. Waikao ti'tijoeria Eesusio aaata ta'pechi kahtiame inamukapao, ");
INSERT INTO var_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","ki ookapi napawirepua wa'ao muirachi, wa'a yeetarachio kiisi ojowime teererepua. Pu'ka napawikame ti'tijoerio Eesusia, wa'a ihsirepua masiteka Riosichi simiyame. ");
INSERT INTO var_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Wa'a teerenioi wa'ao, wa'a e'enarepua naao ti'tijoe aaata tu'ikame tijoe upakoame. ");
INSERT INTO var_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Nape tísia tahchiame weeriopa muirachio, ka'chi ikime erakoapaopua te'ta Eesusi kahtiachi pachanariaiopua ahpo kokoriame u'pariao, karijampa mo'moenarepua. Wa'a mo'moenasaapua, wahjonarepua Eesusi kahtiachi riisakao, wa'a ikisaopua wa'atipo tekipurepua kokoriameo, e'taparachi tekitoka. ");
INSERT INTO var_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Waikao Eesusia pu'ka kokoriameo, tísia paparamekopua apochio, tísia tesiwa e'repakaopua pu'kao, chaanerepua tu'wikameo: —Tísia aamo cheriwiame neeea. Wa'a e'rapa neeea, aamo sautenania, yooma aamo tatakoririaoiopua puhjeka. ");
INSERT INTO var_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Nape wa'ao ookapi iyoteri ti'tijoea, wa'a chiiopa Eesusio apoe te'ta cheriwio tuuyopa tatakorio, ki kaawe erakokaopua, chaachaparepua ahpoo: ");
INSERT INTO var_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“¿Achini iikai wa'a cheeka nayewame ihji tijoea? ¿Ki Riosikamera na'areka wa'a chiiamepu? ¿Ki apoekamerache Riosi cheriwiamepu tatakoritiameo? Riosi apoechekamera puuua, tatakorikame cheriwiamea.” ");
INSERT INTO var_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Nape Eesusia nane'riapa pu'kaopua apochi erakoao, chaanerepua: —¿Achini iikai wa'a tiiame no'o erakoame eemea, kiisi no'o kaawe ihsio erakowao? ");
INSERT INTO var_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Ehsosao naaju, ¿ihtanakamera epeche ki tehkijuarepua naajuo: “Cheriwetiame itipimitia muuua aamo tatakoririao”, chaniwa, naatikosaoipua naajuoi: “Saukame werisikosa muuua”, chaniwakosa? ");
INSERT INTO var_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Weh, ehpe wa'api aamo tetewitemania no'oo, te'ta utewari iinueemekopua no'oo, aaata te'ta tatakorikameoi, te'ta ahsieme saukame no'o itapitiamekoopua, te'ta tatakoritiameoi ahsieme cho'wetiame itipitiamekooipua. Wa'a cheesaopua chaanerepua tu'wikameo: ");
INSERT INTO var_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","—Aamo chaanenane tu'wikame, saukame werisika, apechunasa aamo ipetawao, oisika no'ramitia aamo petechio. ");
INSERT INTO var_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Wa'a chaanetiache tu'wikamea, ikanati kaaweruma werisika ahpo petechi no'rarepua, ahpo ipetawaopua tiameo, mooketoka. Waikao wa'a mochikamea, ki Eesusichi na'arekamea, tahpitika tiiame peenia erapaka Eesusi iintoriao, cheriwema ki'yarepua Riosio, ki nu'uti peenia iintoriopua Eesusichio. Wa'a erakoapaopua chaachaparepua ahpoo: —Ka'chitia taawechi tetewameai teemea, i'ka eee tiiame iintoniameo. ");
INSERT INTO var_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Eesusia wa'a tiiame iintosaopua neipao, eenechi pa'wesue eenariamepua. Wa'a enasoopua pa'wesuweo, muuwaeme ti'tijoe ooweru tiameo, napawiriamepua Eesusi eenariachio. Waikao Eesusia o'inerepua wa'a masitekao, apochi waapi enepakameopua keepumiao. ");
INSERT INTO var_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Ehjepamio masiteka kajusaa u'matosaapua, Reewi tewaniame tewarepua, Arajeo taanara. Puuua toomi koparoaniachi yasariaipua, ya'yawichiwichio koparoaniachi wa'a mochiwachio. Wa'a tetewikapa pu'kao, chaanere Eesusia: —Nahpe no'o ahjama. Neeea aamoo, no'o masitewara enejeraninia. Waikaopu Reewia pu'serepakapua Eesusi chiiao, ahjama simirepua tiame wahjachitia, ahjama teetomia ahkaoi Eesusi simiyachio. ");
INSERT INTO var_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Neipapamio piie taawechio, Reewi ta'perachi koi'oio, Eesusia koi'rachi yasariaipua ahpo yeetoria ahjamao, wa'achi nokariaipua tiameo, muuwaeme ti'tijoe Eesusi keepupuame, Eesusi teetoachi pirenatukame. Wa'achi mochiriaipua tiameo Eesusi chokichio, ti'tijoe koparoame te'ta ya'yawichiwichio, wa'a ikisa muuwaeme wahjachi ti'tijoe tatakoriame, ki kaawe nokayame tetewiniame. ");
INSERT INTO var_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Iyoteri ti'tijoea, wa'a kahtiame tetewapa Eesusio, yooma pu'ka ki ka'karuma ti'tijoe ahjama koakao, puuua iinatukerepua Eesusi masitewarao: —¿Achinikai aamo masitaria pu'ka ki ka'karuma ti'tijoeri ahjama koayamepua, pu'ka te'ta yawichiwichio koparoame ahjama, wahjachi ti'tijoeriopua tiameo, ki ka'karuma nokayame tetewiniame ahjama? ");
INSERT INTO var_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Pu'kao wa'a chaachapame inamukapao Eesusia, chaanerepua pu'kao: —Ki kokoriamea kihta nakiyamepua me'merikoo. Kokoriamekamera nakiyamepua me'merikoo. Neeea kokoriamekamera sautemia eenakamenia, ki kokoriameo ka'i. Neeea tatakorie kokoriamerakamera sautemia eenakamenia, kihta ahpo tatakorikame maayameopua, ka'i. ");
INSERT INTO var_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Aaataa seenepi simiyame taawechi Waani ma'masitewarao, pa'parisero masitia na'naritoameapua tiameo, ki koi'wa Riosi iyoriwa nokayame tetewapao, Eesusichi e'enakaopua chaachaparepua pu'kao: —¿Achinikai Waani na'naritoamea, pa'parisero na'naritoameapua tiame, ki koi'wa Riosi iyoriwa nokayamepua, nape aamo na'naritoamea, ka'í? ");
INSERT INTO var_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Wa'a chaanetiapao Eesusia, cheeka nehjiarepua: —¿Toore aiwatariarepu nenewiwachi paajutetiamea, aaata neewikame ahpo neewiriachi kahtioiopua pehjio? Ka'ipua, ohso kaawe yoomahka paajutetiame, ta'iria ko'kopuamepua, ahkasi posaka. ");
INSERT INTO var_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Puuu neewimerika tiiamea, neeepua, noochi paparamechio. No'o apechunatiopa ki'tioiopua i'ka weeechio, waikaope noochi paparamea o'inemapua ki koi'wa Riosi iyoriwa yorasikao. ");
INSERT INTO var_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Waikao wa'a cheesapa Eesusia ahpo iinatukiameo, chaanerepua: —No'o tewekachi apechunatiopa, ehkoriami o'inia oochetiame nokisitiamea toipuamepua wa'asi, weemera tiiame te'teretopuawichiopua, Riosichi kaawe te'terewaopua, aaataai ki koyacheme tiiachitiaopua oochetiame wisasorio, weemera wisasori chuhchekao. Wa'a iintotioopua weemera wisasorie koyacheraa, chu'rupaka si'panameripua oochetiame wisasorio. Wa'a iikapu oochetiame wisasoria, epeche weere enepameripua yeewasipakao. ");
INSERT INTO var_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Wiino weemeraai, ki totoaniamepua oochetiame wichijarichioi. Wa'a iintotiaapu weemera winopatariai, tatateka si'panamaoipua oochetiame wi'chijario. Wa'a ikisoopua oochetiame wi'chijario, yooma na'itumeri wi'suka weemera winopataria, wi'chijaria tiame. Pukaepa weemera wiinoa weemera wichijarichi toaniamepua. ");
INSERT INTO var_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Piire taawe resipuwa taawechio, Eesusi tiiriko echichiami u'matoio ahpo ajawaria ahjamao, chorowapa puuua, tiiriko kumisiriaipua, muurara okisika. ");
INSERT INTO var_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Parisero ti'tijoea wa'a nokisiopa Eesusi ajawariao, iinatukerepua Eesusio, chaachapaka: —¿Achini iikai wa'a nokayame aamo ahjama ohjoamea, ki reesisenioi resipuwa taawechio, ihtaoi yooramekopua? ");
INSERT INTO var_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Nape Eesusia nehjiarepua pu'kao: —¿Ki nane'riame eemea aamo ehkoriami Raawitaru iintoriao, ahpo ahjama nokisiame cho'chorowapasoopua piie taawechio? ");
INSERT INTO var_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Iiweta Aawiatataruo te'ta neeseriosikoipua, ¿ki Riosi kaarichi pakika Riosi paaniwara ko'kakame puuua, Riosiwichio to'weniame tiopachio, ne'neseriosiche ko'komichioo? ¿Ki pu'ka paani uusa kipotekamepua tiameo ahpo ahjama nokisiriao, tísia cho'choroopa? ");
INSERT INTO var_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Wa'a chaanesapao Eesusia, chaanerepua tiameo: —Resipuniame taawea, ti'tijoewichio yachatiamepua, ki resipuniame taawekamera ti'tijoeri ye'kamichiopua. Resipuniame taawea, Riosie yachatiamepua. ");
INSERT INTO var_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Pukaepa neee Riosie Tijoe Tijoetutetiamea, neeekamera ye'kamepua, resipuniame taaweo. ");
INSERT INTO var_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Neipao Eesusia, eenechi napawikarichi eenariaipua. Wa'a yasariaipua piiripi tijoe sekachi chookopakame. ");
INSERT INTO var_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Nape wa'aoi ihpueniame enere Eesusia, aaata resipuniame taawechi sautesoopua, wenejinaria. ");
INSERT INTO var_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Eesusia wa'ao, sekachi chookopakameo chaanerepua: —Werisisa, i'wa weripamitia naasipa. ");
INSERT INTO var_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Wa'a ikisoopua pu'kao, wahja wa'ao, iinatukerepua cheeka: —¿Ihtanakamera epeche kaawejoarepua, resipuniame taawechi yoraniaa, kaaweruma yoraniamekosa, ki kaaweruma yoraniamekosaooio? ¿Meriniamekooi, ahjateka newipateniakosaoipua? Nape aapoeo ihchi itipirepua, kiisioi ihta nehjiaka. ");
INSERT INTO var_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Waikao Eesusia kiisi kaawe erapaka ahpo norikame ne'nepasaopua, tísia yuuwesiparepua, kiisi pahteka inamuamekopa pu'ka chaaniao. Wa'a iikaopua, chaanerepua chookopakameo: —Ehsoo, riisasipaomua aamo seekao. Waikaopu sekachi chookopakamea, riisasiparepua seekao. Ahpo seekache riisasipasopua, saukame itipirepua ahpo chookowao. ");
INSERT INTO var_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Waikao pa'pariseroa wa'a puuyasachepa puuua, Eesusi ahpo merimia katewesirepua, Eeroremina chuchukuame ti'tijoe ahjama. ");
INSERT INTO var_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Eesusia muuwaeme Arirea mochikame na'naritowae ahjamao, ahpo masitera yeekaopua tiameo, Arirea pa'wechi akiparepua. ");
INSERT INTO var_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Waika taawechiami Eesusiapao, kai waapisi nane'reretiame enere puuuapa, tísia peenia ihsiaopua ahpo Riosi utewarieo. Pukaepa ahkaoi yomachiami mochikamea wa'a e'enariaipua Eesusi tetewika machinariapa. Puuu wa'a e'enakamea ihji enerepua: Uurea weeechi mochikame, Eerusareni mochikame, ahkasi Irumea mochikame tiame, wa'a ikisa muuwae tiame Oorani akichi cherayachimina ohjoeme. Wa'a e'nakame enerepua tiameo, Tiiro mochiwachiami o'inia e'enakame, Siironi mochiwachiami o'inia e'enakame tiame. ");
INSERT INTO var_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Pukaepa Eesusia wa'a pa'wechi asiaio, yomachiami weeechi o'inia e'enakame wa'a tewarepua. Waikao Eesusia, po'wachuwa nerokakera katewetiame iinuenurarepua ahpo masiterao, ki tahchika yasinariapa pu'ka tísia muuwaeme yomachi e'enakame masitekao. ");
INSERT INTO var_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Nape ki ookapi Eesusi kahtiachi e'enakaopua, Eesusichi aampa e'enarepua ahjachi ihchepanareka, ikanati yachapanariapapua ahpo kokoreka mochitoa, ki ookapi wa'asi sautekame inamukamekapa Eesusiopa. ");
INSERT INTO var_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Puuu ti'tijoe ooweru tiame nanaarari apochi mochitiamea, Eesusi tawemina chopokorieka aajapapua siinakokao, eee chaachapakao: —¡Muuupua Riosi tepoena o'inia eenakamea, apoe Riosi Taanara tijoe tijoetukamea! ");
INSERT INTO var_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Nape Eesusia wa'a chaachapopa ti'tijoechi mochikame nanaarario: —Ihchi mochika eemea —cheeka te'yarepua yooma tetewachio, ki nanaararie nane'repuawichiopua, te'ta aatanakoopua ahpoo. ");
INSERT INTO var_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Pu'ka nanaarari terisaapa Eesusia, teewi kaawieka tiiachi mooenarepua, paikapi ahpo masitera yeeka. ");
INSERT INTO var_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Wa'a yasipasaapua ookapi ahpo oowe e'reria uurepua, oosa mariki aampa ooka ti'tijoe ajawarepua, ahkaoi ahpo tehkiwa yorasia nokisimichiopua, Riosi kaaweruma tuuyewari nayewatusikaopua. ");
INSERT INTO var_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Pu'kao ajawasaapa, ahpo Riosiwari utewari yahcherepua, pu'kao pu'ka utewarieo nanaarari puuyanasimichiopua, ti'tijoechi muikameo. ");
INSERT INTO var_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Ihjipu oosa mariki aampa ooka uutiamea: Siimoni, pu'kao Peero tewatiame tiame; ");
INSERT INTO var_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Saantiao, Sewereo taanara, wa'a ikisa Waani, Saantiao poonira, pu'ka ookao Waanereje teewatanime tiame, Te'oni Tatanaraa cheeka chaniwame; ");
INSERT INTO var_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Anteresi, Eeripe, Waatorome, Maateo, Toomasi, Aakowo, Arajeo taanara; Taareo, Siimoni, Kaanani ohjoekame tijoe; ");
INSERT INTO var_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Uurasi Ihkarióte tiame, puuua neipao Eesusi ki ka'karuma ti'tijoechi nehjakame. ");
INSERT INTO var_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Wa'a iintosaapa Eesusia ahpo ajawaria ahjamao, ahpo checherepachi no'rarepua ko'komia. Nape wa'apechi ajasitioio, ki ookapi mochiriopa wa'ao ka'chi iika ko'kome teererepua. ");
INSERT INTO var_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Eesusi tetejimaraa wa'a inamukapao Eesusio, wa'a e'enariaipua i'tomia, ki inatameka ihsiopa, ki ookapi ti'tijoeri ku'inarekao. ");
INSERT INTO var_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Iyoteri ti'tijoe Eerusareni o'inia e'enakamea, chaachaparepua: —Ihji Eesusia, te'ta Weseu Satanasi utewarira yahchamepua apochio, apoe te'ta na'arari teekora. Pu'ka utewarie puuyachamepua na'arario, ti'tijoechi muikameo. ");
INSERT INTO var_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Wa'a chaachapopa pu'kao Eesusia, waapi ahpo ajapanurerepua, chaanenariapa. Wa'a ikisoopua chaanerepua: —¿Achini iintoka ma'chipatapu Satanasia, ahpo wa'apio? ");
INSERT INTO var_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Aaataai yawichia ahpo wa'apichi nasiwamea, ahpo wa'api soopameripua. ");
INSERT INTO var_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Aaata ahpo ta'pechi mochikamea, ahpo ta'pechi mochikamechi nasiwasisaa, ahpo wa'api soopameripua. ");
INSERT INTO var_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Satanasiai ahpo wa'apichi nasiwasisaa, ahpo wa'api soopameripua, wa'atiao ka'chi iika ahjakame weritomeripua ahpo yawichituwachio. ");
INSERT INTO var_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","’Aaata tijoe utewaeme enesoo, aaataai ka'chi iika ichikonemeripua ta'perachi pakikao, ki o'yesaapua pahchao. ");
INSERT INTO var_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","’Neeea i'ka no'o chiiao, te'ta pichiwa chiiamepua: Yooma aaata tijoea oowitiamea tiameo, ihtaoi ahpo ki kaawe iintokaio, ihtaoi ki kaaweruma cheekaio, cheriwepuame tiiamepua; ");
INSERT INTO var_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","nape Riosi Riosiwari ahpo chaania ki e'wekamea, ka'chitia cheriwepua tiiamepua, ka'chitia cheriwepuamepua tatakoririao, ki itayamekapapua ahpo cheriwepuameo. Puuu aaata wa'a tiiamea, wa'api teeka itipimeri puuua tatakoriekao, ahkasi ki wahjiamesi. ");
INSERT INTO var_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Wa'a cheeka ahpo nehpupare Eesusia, Weseu riaorósiwarira apochi iinueko tuuwao. ");
INSERT INTO var_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Wa'a ihsioi Eesusio tísia naanasoti oika ti'tijoeri sautekao, ma'chi werika Eesusi yeeyeraa, Eesusi poponira ahjamao pipinira tiame, paaenurerepua Eesusio. ");
INSERT INTO var_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Waikao wa'a mochikamea Eesusi norikame, Eesusi paaewa inamukapaopua, chaachaparepua Eesusio: —Aamo yeeyea aamo poponi pipini tiame ahjama, aamo paaechanipua waami ma'chi. ");
INSERT INTO var_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Nape Eesusia, cheerepua: —Aa no'o tetejima, ¿Aatanakamerajuarepu no'o yeeyea, no'o poponia pipinia tiameo? ");
INSERT INTO var_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Waikaopua ahpo norikame mochikame ne'nepakaopua, chaanerepua: —I'wa mochikamerapu no'o yeeyea, no'o poponia pipinia tiame. ");
INSERT INTO var_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Aaataai Riosi e'ra yooramea, no'o yeeyekaite puuua, no'o pooni, no'o piini tiame. ");
INSERT INTO var_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Piirechi taawechio Eesusia eenechi pa'wesue o'ineriaipua masitekao, wa'a kahtiachio tísia muuwaeme napawiriaipua tiame. Waikaopua pawekakerachi mooenasaopua pa'wechi chuhkuamechio, wa'a yasiparepua waikao. Wa'a ikitioopua ti'tijoeria, waapi ma'chi ajapare puuua, pa'wesueo. ");
INSERT INTO var_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Waikao wa'a yasaka Eesusia, itapiti wa'achitarichi masiterepua, muuwaeme itapiti Riosichi simiyame masiteniame. Pu'ka masitewachio cheerepua: ");
INSERT INTO var_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","—¡Eeme ti'tijoee ooweru tiame, keepumitiao pahchuuu! Wa'a cheesao o'inerepua ti'tijoeri i'ka eee cheeka wa'achitarichi nayewekao: —Aaata tijoea wahka wasachi echimia simiriataipua. ");
INSERT INTO var_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Puuua echimia simiyaio pooechi ruhjiteriatapua ookapi iimori. Pu'kao tuchikia, wa'a e'enaka yooma pepeka ko'kariatapua pu'kao. ");
INSERT INTO var_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Wahjachi iimoria, waitiame kahtiachi weee echariataipua. Puuu iimoria ku'we yaupariatapua yaupao, nape ki tunakame yasariopapua weeeo, ");
INSERT INTO var_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","taaaa machenasaapa taipakopao, wakipateriatapua pu'kao, ki teeresi naawaeriopa pu'kao. ");
INSERT INTO var_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Wahjachi puuu iimoria wehchaekachi ruhjiriataipua. Puuua yaupariatapua yaupao, nape wehchae si'riputiapa mo'porepakao, wa'atia wakipariatapua kihta taakeka. ");
INSERT INTO var_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Nape wahjachi iimoria kakupa weeechi ruhjikamea echitiaio, ka'karuma yaupaka weweripasaopua, ki ookapi taakeriatapua. Ihji muurara pachitariaa, piire weerewa aampa oosa mariki pahchitariatapua, piiripi wa'api pahchira echitiaopua. Wahjachi pipiripi iimoria, pa'paika weerewa pachitariatapua muuraraa; epeche wahjachi iimoria, pipie siento pachitariatapua muuraraa, pipirepi pahchira echitiamea. ");
INSERT INTO var_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Wa'a tiiame wa'achitarichi nayewasaapa Eesusia, chaanerepua ahpo masitiao: —Nahkaesaa eeme, pahteka inamupuapua pu'kao. ");
INSERT INTO var_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","I'ka wa'achitari Eesusi naewaka kajusoopa, wa'a muuwepariame ti'tijoeria, nonowarepua waikao ahpo petechiami. Ehjepamio Eesusi piineri itipisoopa, paikapi Eesusi masitia keepuamea, puuu oosa mariki aampa ooka Eesusi ajawariaapua tiamea, iinatukerepua Eesusio, ihtana cheeka cheeriopua Eesusio, wa'achitarichi nayewakao. ");
INSERT INTO var_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Waikao Eesusia eee cheeka nehjiarepua pu'kao: —Neeea pu'ka ti'tijoerio wa'a cheeka nayewakamenia wa'achitarichichio, aatiatanariapa pu'kao, no'o te'ta masitia pichiwa pahtenarewa ne'nenariapa pu'kao. Aaata aamochitia te'tiameopua, te'ta Riosi ye'karichi muinariameopua, Riosia ki wa'achitarichi ma'chiame aamo tuuyamepua aamoo; nape neeea pu'kao oowera keepumia e'enariame nane'riapao, wa'achitarichi nayewekania pu'kao, kihta Riosichi simiyame pepeninariapa e'enakame. ");
INSERT INTO var_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Puuu wa'a te'teriamea, ne'niaio ki ma'chiriame itipimeripua, keepuaio kihta pahtemeripua. Wa'a te'tiapa puuua, kiisi ahpo tuuyamepua Riosichio, ahpo ki ka'karuma nokariao, ahpoo Riosieo, ahpo cheriwepuawichioopua. ");
INSERT INTO var_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Eesusia chaanerepua waikao: —¿Kiisi pahteka inamukame eemeai, i'ka no'o wa'achitarichi nayeweriao? Wa'a teeresaa eemea, ¿achini teeka pahteta eeme wahjachi wa'achitari no'o nayewamiaopua meeriamahkao? ");
INSERT INTO var_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","¡Nee! Puuu echayame no'o nayewaria wa'achitarichio, Aaata iimori echayamepua, Riosi ka'karuma tuuyewari echisiamepua. ");
INSERT INTO var_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Puuu iimoria, Riosi ka'karuma tuuyewaripua, ti'tijoeri keepua. Puuu iimori echayame echiwachi ruhjikamea, ti'tijoeri iikarachi echitiamepua. Paikapi iimori echayamee pooechi ruhjitetiamea, ti'tijoeri peewame iikaemechi ruhjikamepua. Puuua, Riosi chiia keepunapua keepuao, nape Satanasia ikanati wa'a eenaka yooma u'yamepua, pu'ka Riosi ka'karuma tuuyewari keepuriao. ");
INSERT INTO var_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Wahjachi iimori e'peekachi ruhjitetiamea, kaawe e'raka keepuamepua keepuao Riosi tuuyewario, nape ki tehpesi simiyamechi wekatiamepua, ahpo keepuriao. ");
INSERT INTO var_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Puuua itapiti aiwateniaapua Riosiwichioo, ikanati toayamepua ahpo paparariao, kihta teeresi naawaekapa Riosi kaaweruma tuuyewarichio. ");
INSERT INTO var_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Wahjachi iimori wehchaekachi ruhjikamea, naatiju puuua, i'ka weeechiche iintuame tísia weemuniame. Puuu ti'tijoeria pu'ka Riosi kaaweruma tuuyewari kaawe keepuame keepuao, ");
INSERT INTO var_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","nape epeche ahpo erakoaeopua i'ka weeechi iintuamechi itapitio, ahpo si'ripuamepua, tahpitika erakoamekapa puuua, toomichio. Puuua yooma ihtaoi iniwaeka mochinariamepua. Yooma ihji wa'a tiame mu'ipakamea ahpo iikachio, yooma apochi si'ripukao, kihta taakiamepua apochio, Riosiwichio ka'karumaopua. ");
INSERT INTO var_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Nape puuu iimori kakupa weeechi ruhjikamea, ti'tijoeri ka'karuma iikaemechi ruhjikamepua. Puuua kaawe e'raka keepuamepua Riosi kaaweruma tuuyewario, te'ta pewatiame apochi itipiteka. Wa'a iikamea, kaaweruma taakiamepua Riosiwichioo, tiiriko echitiame muurarachitia. Ookapi ihji tiiriko muuraraa, piire weerewa aampa oosa mariki pachitakamepua; wahjachi ihji tiiriko muuraraa, paika weerewa pachitakamechitia tiame; epeche wahjachi ihji tiiriko muuraraa, ahkasi piire sientooi pachitakame. ");
INSERT INTO var_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Eesusia chaanerepua tiameo: —Riosi tuuyewaria, itapiti tahjeraka tiiame puuua. ¿Aatanana noriwi weratare itapiti ahpo tahjerao, e'tapara teereopua, itapiti kaajonitere noriwioiopua? Aaataai ki wa'a iintomeripua. Ohso kaawe te'pa werameri puuua, weeresi tahjemichiopua pu'kao, weeresi uutapamichio pu'ka tajayao, weeresi tetewipuawichiopua. ");
INSERT INTO var_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Wa'achitia Riosiai wahka taawechiamio, yooma ahpo teteiwachi toapamapua, yooma ihta inasotiame toatiameoipua, yooma ihtaoi ti'tijoe ki ka'karuma noonowiriaopua, ooweruoiopua tiame. ");
INSERT INTO var_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Eemea inatame enesaa, pahteka inamumitiapua pu'kao. ");
INSERT INTO var_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Eesusia wa'a cheesaa, chaanerepua tiameo: —I'kao eemea, te'ta inataka inamumitiapua: Kehkisa aamo nakika mochitokamea Riosichi, pu'kachi kehkisa kiapuamepua eemea Riosieo, itapiti te'ta Riosichi eenameopua kaaweruma, nape u'matiame epeche kehkisio. ");
INSERT INTO var_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Riosie kiatiame iinuemeopapua, epeche pehji kiapuamepua, i'wa weeechi no'o enasoopua; nape kihta iniwaemeopua Riosie kiaretiao, ahkasi teesa iinuekaoi i'ka weeechi ahpo iinuekao, yooma u'yepuamepua, no'o tewekachi Noonoeopua, kiisi kihta tooeka, no'o tewekachi o'inia eenechi enasopao. ");
INSERT INTO var_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Eesusia chaanerepua tiame: —Riosi ye'karichio, tijoe echariaka tiiamepua. ");
INSERT INTO var_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Echakame kohchioiopua, pusakame kahtioiopua, puuu echitiame yaupasaapua, tukaooi taaweoi tiame, naapi simitiamepua weweripakao, pu'ka echakame ki teteoiopua. ");
INSERT INTO var_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Riosi ihsimepua yaupatekao, weweripatekaopua tiame naawaepatekaopua, neipao muuraetepamepua, pu'ka muurara pachitasoopua, iwapatiamepua. ");
INSERT INTO var_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Pu'ka tiiriko pahchira iwapasoopua, ahsepakame puuua ohsae tehpunaka i'ipapuachio. ");
INSERT INTO var_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Eesusia eenechi chaanerepua: —¿Ihtanaka tiiame ohjoarepu Riosi ye'karia? ¿Ihtanaka tiiame teemea Riosi ye'karichio? ");
INSERT INTO var_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Aa, wacherai pahchiraka tiiame puuua. Kaawe inataka ne'nemitiaomua wacherai kuuurao. Kiisi werumakaipua pahchirao, ki nu'nuti weripamekai tiiamepua kuuuraa, ");
INSERT INTO var_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","echitiaapa, kii ookapi atowataitepua, ahkasi tuchikioi ahjachi tatasotachi. Wa'achi tiiame Riosi ye'kariai. Ki weruma o'inekaipua, ki nu'uti mehtamepua. ");
INSERT INTO var_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Eesusia, weeka tuuyewari masitere puuua wa'achitarichio, ki tehki erakoka pahtemichio ahpo masitiao. ");
INSERT INTO var_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Kihta masiterepua pu'kao, ki wa'achitarichi ku'ikao; nape ahpo wa'api ajawariao, piineri ahpo ahjama mochikoio, tísia tehki tiiamekopua pu'ka masitiao, yooma kaawe ma'chiame tuuyerepua pu'kao. ");
INSERT INTO var_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Pu'ka wa'api taawechi tukaoo, Eesusia chaanerepua ahpo ajawaria masiterao: —Paao siimpapuamepua ehpeo, paonamina pa'wechi. ");
INSERT INTO var_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Waikao masiteraa wa'a toisapa ti'tijoerio, paonamina i'torepua Eesusio, wa'api pu'ka pawekakera Eesusi kahtiachi. Wahjachi pawekakeraai pukamina chuchutorepua tiame. ");
INSERT INTO var_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Wa'a nokisioio, ki nu'uti eenare yu'kia ki nu'uti eejeka. Waikaopu pa'wea pe'kokao, aampamisi chi'posirepua pawekakerachio. ");
INSERT INTO var_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Eesusia wa'a ikinioio, kochipariaipua pawekakera wasichitu poika, itapiti mo'teka. Nape ma'masiteraa tahpitika ikiyapaopua, pusaterepua pu'kao chaaneka: —¡Masitári, Masitáriii! ¿Kiisi ka'chi e'ramemua taamo piwitewioio? ");
INSERT INTO var_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Waikao Eesusia werisika teeweterepua eekao, pa'weopua tiameo, chaaneka: —¡Muuu eekáaa, ikanati teewésaaa! ¡Neeroi pe'koniai, mooena manipásaaa! Wa'a chaanetiapa eekaa teewerepua, yooma yuuweeme itipika. ");
INSERT INTO var_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Wa'a iintosaapua ahpo masitera ajawariao, chaanerepua: —¿Achinikai majayame eemea? ¿Kiisiki paparame eemea pehji, noochio? ");
INSERT INTO var_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Nape aapoeo, Eesusi iintoria tísia seewepakamekapapua Eesusio, kiisi nehjiame erakorepua. Pukaepa aapoeo, poanachi ahpo chaachaparepua: —¡Ihtana tijoe naaju ihjia, eekaeoi e'weniamée, pa'weeoiopua tiamé? ");
INSERT INTO var_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Wa'a nokisika paonarepua wa'a neerochio, Eesusi paonamina i'tokao, wa'ao Eerasa weewachi e'enarepua. ");
INSERT INTO var_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Wa'a paonamina tekisochepa Eesusio, aaata naaeparepua pu'kao itapiti na'ararie keewakame. ");
INSERT INTO var_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Ihji tijoea wahjipame toaniachi ohjoeme eneriaipua. Puuua aaataeoi ki yuuyumpaniame eneriaipua mooena yahchakao, kaarenaeoi o'yekaio. ");
INSERT INTO var_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Puuua ki ku'itapisi kaarenae o'yeniaipua tarachio sekachiopua tiame, yooma tetepunasa siisimiriaipua, yooma pipiripi pihtunaka ihpapasa. Wa'a ihsiamekopa pu'kao, ka'chi yorame erakoretiaipua wa'asi, wa'a mochikameeopua ti'tijoeri. ");
INSERT INTO var_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Wa'a iintosaapua yooma tukawari ojowiriaipua, mukuteso wahjipame toaniachi siinakao, kaawichiami oikaopua tiame, temosochiami tiame momotochisika, tísia kokosa ijikisika. ");
INSERT INTO var_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Ihjia wa'a eename tetewapa Eesusio, mehka ihtoi u'masika eenakao, chopokorieka weripakaopua chokichi, ");
INSERT INTO var_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","chaanerepua Eesusio, ki ku'ita sisinaka: —¡Eesúsiii, te'ta te'pa eename Riosichiii, ka'te no'o te'ta kokosa yoramitiamua! ¡Neeea aamoo te'ta tesiwa cheeka aamo itaniamepua, ka'chi no'o yoramichiopua kokosakao! ");
INSERT INTO var_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Wa'a cheeka nayeware na'arari tijoechi kahtiamea, Eesusie eee cheeka teritiamekapaopua: —¡Muuu na'arari tijoeturi, ikanati machenasa muuua pu'ka tijoechio! ");
INSERT INTO var_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Eesusia terisapaopua pu'ka na'arario, iinatukerepua pu'kao: —¿Achini teewaeme muuua? Waikao na'araria nehjiarepua cheekao: —Reejioni tewaniame neeea, kii ookapi na'arari tijoeturikapa. ");
INSERT INTO var_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Waikaopu nanaarari tijoechi mochikamea, naaracheka itaneriaipua Eesusio, ki se'wiami ahpo uhjurapuaichiopua wa'ao. ");
INSERT INTO var_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Nape wa'api wa'a kahjena kaawichiamioio, ki ookapi koowi ohjopa wa'ao, ");
INSERT INTO var_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","wa'a ahpo uhjuranurare nanaarari ti'tijoeturia, eee chaachapaka: —Wa'a pu'ka koowichioi taamo uhjuramitiapua, wa'a pukachi taamo muimichiopua —chaachaparepua. ");
INSERT INTO var_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Waikao Eesusia wa'a uhjurarepua koowichi. Wa'a uhjuratiapa nanaararia, pukachi muirepua koowichi, tijoechi puuyanatiapao. Waikaopu ooka miiri ahka koowia, pu'ka nanaarari apochi muitiaapa, tahpitika noonoikao, ki muenati ujumarepua tekoratamio. Wa'a noonowikaopua, yooma wahjiparepua tekoratatipo ruhjika, pa'wechi neerochi ruhjikapa, si'rika. ");
INSERT INTO var_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Waikaopu koowi inatiamea, ahpo mochiwachi ujumasirepua yooma tuuyemia mochiwachio, yomachi o'okapi mochiwachiamiopua tiame. Waikao yooma wa'ami ohjoemea, wa'a e'enarepua pu'ka ikitia ne'nemia. ");
INSERT INTO var_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Ajasisaapa Eesusi ihsiriachio, puuu nanaarari tijoeturi iinueriamea pa'akachio, ehpeo yachapakame yasarepua wa'a Eesusi ihsiachio, kaaweruma wakiraeka wa'asi. Waikao wa'a e'enakamea wa'a iintoriopua Eesusio, tísia seeweparepua pu'kao. ");
INSERT INTO var_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Puuu pu'ka yooma wa'a ikitiame tetewikamea, yooma tuuyerepua wa'a e'enakame ne'nemiao, aachin teererio puuu tijoe ki ookapi nanaarari apochi ohjoeriao, koowioi achipu noonowiriopua tiameo. ");
INSERT INTO var_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Waikao wa'a e'enakamea wa'atiame tuuyetiapa Eesusi iintoriaopua tiameo, tísia seewepakaopua Eesusio, utewaeme itanerepua chaachapakao: —Se'wi siimitiamua i'wao, sewinachiami akipaka. ");
INSERT INTO var_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Ehjepao pawekakerachi mooenoi Eesusio, puuu na'arari apochi ohjoeteriamea, utewaeme itaneriaipua Eesusio, ahpo yeetomichiopua ahpo simiyachio. ");
INSERT INTO var_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Nape Eesusia ki e'rapa chiiao, chaanerepua pu'kao: —Muuua no'ramitiapua ohso kaawe, aamo pehtewachi aamo tetejimachi. Muuua aamo ta'pewachi asisaapa, yooma tuuyemitiapua pu'kao, Riosi amochi iintoriao, achini iintoka Riosio, aamo tesiweriopua. ");
INSERT INTO var_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Waikaopu tijoea, ahpo petechi no'rasaopua, yomachi Reekapori weeechiami mochiwachi oirepua tuukao, yooma ihta itapiti ahpo Eesusie, kaawe iintoretiaopua. Waikao mochiwachiami ohjoemea, tísia peenia e'reka inamurepua Eesusi iintoriao. ");
INSERT INTO var_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Eesusio eenechi pe'ku paonasoopua pa'wechio, muuwaeme napawirepua pa'wesuwe tekiriachio. Wa'a neerosue kahtioi Eesusio, ");
INSERT INTO var_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","wa'a eenarepua aaata tijoe Airo tewaniame, puuua wa'a mochiwachi napawikarichi paamiratuame enerepua. Wa'a tewakapa Eesusio, chopokorieka weripaka taweminao, chaanerepua Eesusio: ");
INSERT INTO var_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","—Paamira, tísia yaapi e'raka eenakamene amochio, amori mukuyame teekane no'o maara petechi. Wa'a simika ahjachi seekarepajeraninia saumichio, ahjame weritomichiopua pehjio. ");
INSERT INTO var_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Waikao Eesusia wa'a simirepua ahjamao. Nape pooechi nokisinioio, muuwaeme tahchiame ajatoriaipua Eesusichio. ");
INSERT INTO var_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Wa'a naasipa muuwaeme nokisiniachioipua tiameo, wa'achi weritoriai aaata oowitiameai, erawisu kokoriame. Puuua wa'a teerekaopua, oosa mariki aampa ooka paaumpari wa'a tiiame enerepua wa'asi. ");
INSERT INTO var_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Ki ku'witapi aiwakame eneriaipua wa'asi, ki ookapi me'merikochi oiyai wa'asi, wa'api teerekame eneriaipua, kihta sauka, ki ookapi toomi na'atakaiopua. ");
INSERT INTO var_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Ihji oowitiamea, Eesusi sautiame inamukapaopua, wa'achi eenakame eneriaipua, Eesusie sautetiame itipinariapa tiame. Pukaepa Eesusi ahjama nokisiachi ihtoaiopua naasipao, Eesusi wisasoriwarachi ihcherepua, káátisia saunareka. ");
INSERT INTO var_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Ihjia wa'a e'raka ihchepasaapua Eesusi wisasoriwachio, saukame itipirepua: “Eesusi wisasoriwachi ihchepakaio, saukame itipimania”, e'rakapa. ");
INSERT INTO var_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Wa'a e'raka ihchepasaopua Eesusi wisasoriwachio, saukame itipirepua ikanati. Ikanati teewekame saaerepua ahpo erawisuao. ");
INSERT INTO var_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Waikao Eesusia ahpo utewari u'yetia saaekapao, ku'rika chaanerepua apochi tahchiame muuetoao: —¿Aatanapu noochi ihchepakamea, wisasorichio? ");
INSERT INTO var_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Nape masiteraa chaachaparepua: —Nape Paamira, tetewameai muuua amochi tahchiame ajatonio amochi ijichepaka, ¿iinatukiamemua: “¿Aatana noochi ihchepakamepua?” —cheeka? ");
INSERT INTO var_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Wa'a cheesapa Eesusia, neneku ne'nesao, apochi ihchepakame wisasoriwachi ne'neparepua oowitiame. ");
INSERT INTO var_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Waikao oowitiamea ahpo nane'retiamekapaopua Eesusieo, chachapia ihsika majakao, chopokorieka weripakaopua, apoe ihsirio tuurepua. ");
INSERT INTO var_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Waikao Eesusia chaanerepua oowitiameo: —No'o maalala, saukame itipikame muuuapa, noochi te'ta paparakamekapa. Wa'a chaanesaapa chaanerepua tiameo: Kaawe eratoka ehpeo, no'ramitiamua aamo petechi. ");
INSERT INTO var_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Iiweta Eesusi oowitiame naewaka ihsiaio, wa'a e'enariame aaata kooriaa, Airo ta'perachi o'inia e'ename. Puuua chaachaparepua Airoo: —Aamo maaraapa, kiterepakamepua wa'asi. Kihtawichio noonotepuame taamo Paamira masitaria wa'asi, taamo ta'pechi siimichioopua wa'asi. ");
INSERT INTO var_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Nape Eesusia wa'a chaachapoiopua pu'ka kooriao, chaanerepua kuita noonorao: —Ka'te paache yuuwesipa muuua, te'ta paparapuachepua muuua, Riosichio. ");
INSERT INTO var_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Waikao Eesusia ki yeetokaopua wahjachio, naatiche i'toka simirepua, Peero, Saantiao, Waani Saantiao poonira tiame. ");
INSERT INTO var_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Ehjepamio, Airo ta'perachi ajasitioiopa, ne'ku ohjoame tewarepua wa'a mochika inatiameo, weeru chaachapaka naarakokao. ");
INSERT INTO var_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Waikao Eesusia yooremina pakisaapua kutewe po'yachio, chaanerepua wa'a po'yachi neesetoka mochikameo: —¿Achinikai naarakoame eemea? ¿Ki oowera wa'a tiiai tiiamepua kochikache? Kiisi mukukamekaitepua. ");
INSERT INTO var_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Nape wa'a chiiopa Eesusio, a'acheretupua wa'a mochikameeopua chokichi. Wa'a cheesao Eesusia yooma puuyanarepua wa'a neesetoameo, ma'chisi machenaka tiame. Waikaopua pu'ka kutewe noonorache i'tokaopua yeeyera tiame, ahpo ahjama ohjoameopua tiame, eenechi pakirepua yooreminao, kutewe po'yachio. ");
INSERT INTO var_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Pu'kao sekachi chapikao, cheerepua: —¡Talita, cumi! —eee cheeka chaniwamepua: ¡Kuita, aamo chaanenane, werisi! ");
INSERT INTO var_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Waikaopua kutewea oosa mariki aampa ooka paamuamea, oijenarepua eenechi ahjaka. Wa'a iika werisisaapua, oisirepua eenechi. Puuu a'achekamea waikao, sewina ijikirepua tísia kaawe erapaka, tísia peenia tiame tetewa Eesusi iintoriao. ");
INSERT INTO var_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Nape Eesusia waikao pu'kao, utewame chaanerepu pu'kao, kiisi ahpo tuupuaichiopua wa'a ahpo iintoriao, aaataoi. Waikao Eesusia, pu'ka kutewe ahjatesaopua, ko'kotenurarepua pu'kao. ");
INSERT INTO var_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Wa'a o'iniao Eesusia, ahpo weewachi no'rarepua ahpo masitewa ahjamao. ");
INSERT INTO var_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Wa'a asisaapa ahpo weewachio, resipuniachi taawechiopua, wa'a napawikarichi o'inerepua masitekao. Wa'ao Eesusi keepukamea, ki nu'uti peenia erakokaopua, chaachaparepua ahpoo: —¿Akatia tísia penipakame ohjoare ihji tijoea, i'ka itapiti ki ookapi peenia ihsiwaopua? ");
INSERT INTO var_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","¿Naakona ki naatikosapu ihji tijoea, kapintero Maaria taanara? ¿Ki Aakowo pa'chirapu ihjia, ki Oose, Uurasi, Siimoni tiamepu tiamea, pu'ka poponirapuaa? ¿Kikosa ihji tijoe pipiniraa, i'wa ohjoemepua tiame taamo ohjoekachi? Wa'a chaachaparepua ki kaawe e'erakoapa Eesusi masitiao, kiisi paparaniamekapa Eesusichio. ");
INSERT INTO var_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Waikao Eesusia wa'a chaachapame inamukapaopua pu'kao, chaanerepua: —Yomachi yooreka tetewiniame Riosi nayewatuamea, nape ahpo ohjoekachiopua ka'i, ahpo tetejimarichioi, ahpo wa'api petechioi. ");
INSERT INTO var_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Pukaepa kihta a'chi ihsime e'rarepua wa'ao, ihtaoi peenia ihsiwaopua Riosieo. Wa'a mochikameo kiisi pichikenariopa apochio, paikapioi sautesa kokoriame, u'matorepua wa'ao. ");
INSERT INTO var_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Wa'a te'tiopa Eesusia wa'ao, kiisi kaawe eratoka u'matorepua wa'ao, eee tiiame inatasika pu'kao: “¿Naakona ahkasi wa'a te'tiame ihji ti'tijoeria?” Waikao Eesusia wa'a o'inia u'matosapao, yooma wa'ami waapiami simiterepua masitekao, Riosi ye'karichi simiyame tuuyewariopua, ahkaoi ahkasi ti'tijoeekachisi, mochiwachiamio. ");
INSERT INTO var_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Ihji Eesusia ahpo ajawariao kaawe tuuyesaopua pu'kao ahpo yoramiao, o'okache uhjurarepua mochiwachiamio, ki ka'karuma tijoeturi puuyanemichiopua, ti'tijoechi mochikame. ");
INSERT INTO var_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Ahpo siimpachiwichio kihta i'toka siimpanurerepua, teesorache makoka ahpo sekachio, kihta mokewarioi i'tokaopua, nutukaoi kihta i'toka, toomioi kihta i'toka ahjae taripuameo, ");
INSERT INTO var_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","kaakaoi ahpoche chuhchaka ohjoa i'tonurerepua, wakiraoi ahpoche chuhchaka oiya i'tonurerepua. ");
INSERT INTO var_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","I'kao eee chaanesa uhjurarepua tiameo: —Aaata ta'pechiami ajasisaa, wa'ache mochisa uumatomitiapua wa'ao. ");
INSERT INTO var_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Wahka pirenachi mochiwachi aamo ajasiriachio, ki kaawe aamo uutioopua ki inamunareka aamo masitio, puuyasaapua wa'ao, aamo tarachi pechichisa uumatopuapua wa'ao. Wa'a aamo noonoipuapua, nane'remichiopua pu'kao, ki kaawe erakoka aamo uumatoamekopua wa'ao, aapoe nane'remeripua epeche ahpo ikimeriopua aiwari kokosario ki Sooroma Oomorachitia, kiisi inamunareriopa, aamo Riosi kaaweruma tuuyewario. ");
INSERT INTO var_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Waikao Eesusi ajawatiamea siimpasaapa, yomachi sisinamurepua Riosi kaaweruma tuuyewario, Riosichikamera e'enamichio paajuteka, yooma apochi ki kaaweruma tiiao, Riosichi tuusa pichiwa toinariameko tuuka, yooma ahpo ki kaaweruma noonowiriao, cheriwepuawichiopua. ");
INSERT INTO var_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Puuu Eesusie uhjuratiameapua tiameo, ki ookapi nanaarari puuyanarepua ti'tijoechio ooweruchiopua tiame, kokoriameoi ki ookapi sauterepua Riosi utewarieo, ooriwo nerosowi chuhchesika. ");
INSERT INTO var_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Te'ta Eerore yawichia, Eesusi tísia sautiame inamukapao, tísia Eesusi nayewaniame yomachiamio, tuuyerepua mochiwachi mochikameo: —Puuu Eesusi tewaniamea ti'tijoeeo, Waanikotinia Riosi nayewatura eenechi ahjakame, pukaepa sautewa utewari iinuemepua. ");
INSERT INTO var_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Nape aaata wahjachia chaachaparepua ti'tijoerio: —Ka'i ki puuupua. Eeriakamera puuua, eenechi i'wa weeechi eenakame. Wahja wahjachia tiame, chaachaparepua: —Naatikamera puuua, aaata ehkoriami Riosi nayewaturao, i'wa weeechi eenakame. ");
INSERT INTO var_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Nape Eerorea wa'a chaachapanioiopua, cheerepua ahpo chokichi mochikameo: —Ka'chitia piirechipua. Waanitarukamera puuua, te'ta pichiwa, pu'kao nooe mo'ora tehpunenureria, ehpeopua eenechi ahjakame. ");
INSERT INTO var_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Eerorea, Eroria iintowachi karichi yahchakame eneriaipua Waanio, kaarenae o'yeraeka. Eerorea Eeripe uupira ahjama neewikame eneriapua, ahpo pooni uupieria. ");
INSERT INTO var_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Waania Eeroreo chaanekame eneriaipua: —Muuua aamo pooni uupirao, kiisi uupietame teereriaimua, wa'a iintokapao muuua, kiisi kaawe iintokamemua Riosichio. ");
INSERT INTO var_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Pukaepa Eroriaa Waanio, nekamuchiame eneriaipua pu'kao, merinareka tetewame, nape ka'chi ikime e'rariaipua wa'a e'raio. ");
INSERT INTO var_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Eeroreapua Waanio, Riosi nayewaturakopaopua pu'kao, seeweka tetewame enerepua pu'kao, Riosie kaaweruma tijoekopaopua tiame. Wa'a tiiachipa seewiaio, ka'chi yorapuawichio neesetoriaipua Waanio. Ki kaawe pahtiaipua Waani chiia Riosieo, pu'sereka keepuame eneriaipua Waanio. ");
INSERT INTO var_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Nape Eroriaa, tewarepua piie taawechi ahpo iintomiachio, Eerore ahsepatioipua paamupari pahko. Eerorea yooma paajuteriaipua waikao ahpo ye'karichi yawichituameo, Arirea ohjoeme tiamé, weruma te'teriame ti'tijoeri. ");
INSERT INTO var_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Eroria maararaa yawimia pakiriaipua pahkochi koi'rachiopua, Eerorea tísia pu'serekapa pu'ka yawiriao, yooma wa'a mochikame inamuachio, chaanerepua ahpo piisi maarao: —Ihtaoi aamo no'o itanesoo, aamo kiamania, ");
INSERT INTO var_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","ahkasi no'o nuurari naasipasioi yawichiwa. ");
INSERT INTO var_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Waikao piisi maararaa, ikanati ahpo yeeyechi simikao, iinatukerepua ahpo yeeyeeo ihtana itanejeraopua yawichio. Waikao yeeyeraa chaanerepua: —Waani Paatori mo'ora itanemitiapua. ");
INSERT INTO var_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Waikaopu Eroria maararaa, yaapi eenechi pakisaopua yawichi kahtiachio, chaanerepua pu'kao: —Ehpe wa'api no'o kiajeraninia pehtorichi yachasao, Waani Paatori mo'ora tehpunasa. ");
INSERT INTO var_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Waikao yawichia wa'a chiiopa ahpo piisi maarao, tísia iiyana eraparepua apochio. Nape yooma paajutetiame inamuachi wa'a cheekamekapaopua, ka'chi ikime e'rarepua ka'itanariaio. ");
INSERT INTO var_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Wa'a tiiachipa yawichia, ikanati uhjurarepua piiripi ahpo soontaro, Waani mo'ora tehpunasa upamichiopua, pehtorichi yachasa. ");
INSERT INTO var_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Waikao soontaroa wa'a akiparepua Waani mo'ora upamia. Puuu soontaroa Waani mo'ora upasaopua, Eroria maararaa ki'yarepua, pehtorichi yachatiame. Waikaopu kutewea, ahpo yeeye ki'yarepua pu'kao. ");
INSERT INTO var_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Waikao Waani na'naritoamea, Waani meritiame nane'rekapao, wa'a e'enarepua Waani weerewara i'tomiao, wahjipame toaniachi tekimia. ");
INSERT INTO var_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","I'ka ikitiame u'matosoopa, Eesusi yomachi masitemichio uhjurariaa, eenechi e'enarepua Eesusi kahtiachio. Waikao Eesusi uhjurariaa, yooma tuuyerepua Eesusio, achini teereriopua ahpo ohjoriachi nokariao, yooma mochiwachiami ahpo masiteriachio. ");
INSERT INTO var_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Nape wa'a Eesusi kahtiachio, naapi nonowasika wahjachi enapasiamekopaopua ki wahjika, ki toiwamekapapua ku'itapioi ko'komichiooi, chaanere Eesusi ahpo ajawariao: —Nahpe no'o ahjama, yuuweekachi siimpapuapu, ku'itapi resipumia. ");
INSERT INTO var_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Wa'a iintore Eesusia waikao ahpo ajawaria yeekao, pawekakerachi mo'moenasao, paonamina ooruchi resipumia. ");
INSERT INTO var_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Nape muuwaeme ti'tijoeri Eesusi ahka suwenamiachi nane'rekamea, wa'a uumparepua paonamiachi puuyemia. Wa'a paonamiachi siimpoio pu'kao, ahkaoi ohjoeme ahjama na'peparepua, ahjama siimpamia siimpachi. ");
INSERT INTO var_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Pukaepa Eesusi wa'a tekiyaiopua suwenakao, muuwaeme mochikame tewarepua wa'ao, ahpo puuyeka mochikame. Waikao Eesusia wa'a te'teriopa pu'kao, tísia tesiwa e'reparepua pu'kao, tísia tesiwa te'tiamekopua pu'kao, po'wa ki tepuniamechitia neesetoka. Wa'a iikapa Eesusia, wa'apechi simiterepua masitekao, ki ookapi itapiti Riosichi simiyame nayewaka. ");
INSERT INTO var_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Aarikopa wa'asi Eesusi ajawariaa, Eesusi naaepakao chaanerepua: —Masitari, tísia ariwanipua wa'asi. Ki waapi ooruchi i'wao. ");
INSERT INTO var_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","¿Ki kaawejoare nonorapunia i'wa e'enakameo, kooame tarisimichiopua wahka mochiwachiamio? ");
INSERT INTO var_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Nape Eesusia nehjiarepua: —Ka'i. Eeme ko'kotemeripua pu'kao. Nape aapoeo chaachaparepua Eesusio: —¿Pu'ka kehkiwichio tarijeranimua kooame, ooka siento taawechi yowiniame toomi tehki, yooma ko'kotepuamewichioo? ");
INSERT INTO var_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Eesusia waikao, cheerepua: —Ne'nemitia eemea kehkisa kooame iinueniame i'wao. Eesusi ajawariaa e'enasaapa, chaachaparepua: —Mariki paani wa'api maaniamepua i'wao, ooka wa'api so'chi tiame. ");
INSERT INTO var_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Waikao Eesusia pu'ka muuwari wa'a e'enakameo, pa'paikapichi mochipanurerepua pu'kao, paasepo siionachio. ");
INSERT INTO var_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Waikao wa'a chaanetiaapa, wa'a teeka mochiparepua pa'paikapiche, pipie siento ahsieme, wahja o'oka weerewa aampa oosa marikisi. ");
INSERT INTO var_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Waikao Eesusia pu'ka mariki paani uusao, Riosichi ne'nepakaopua tewekachio, cheriwema kiasapa tewekachi No'noo, ahpo ajawariao chi'wanasa ki'yarepua pu'ka paanio, so'chioipua tiameo, naachutamichio ki'yarepua. Waikao Eesusi ajawariaa, yomatiame wa'a mochipakame muuwari, naachuterepua, pu'ka paaniopua, so'chiopua tiame. ");
INSERT INTO var_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Pukae kooame naachutatiameopua, yooma posakame itipirepua, ahkasi soparamesi. ");
INSERT INTO var_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Puuu ko'kotiame chi'wapame soparakamea, oosa mariki aampa ooka wa'wari weeweruma pochikame, na'poaretupua paani soparakameopua, so'chi tiame. ");
INSERT INTO var_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Pu'ka paani ko'kakamea so'chi tiame, mariki miiri u'matoame, enerepua ti'tijoe. ");
INSERT INTO var_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Neipa i'kao Eesusia, ahpo ajawaria pawekakerachi mo'moenapusaopua, We'saira mochiwachi paonanurarepua pahcha, wa'a weruma neeroi maaniachiopua, ahpoo pu'ka ti'tijoeri wa'a muuweeriao, nonorapuachisi. ");
INSERT INTO var_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Neipao nonorapusaapa Eesusia pu'kao, kaawichi mooenarepua pehji, ahpo Noonoma nayewamia tewekachi kahtiame. ");
INSERT INTO var_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Ariwatoipua pehji pawekakeraa, naasipapo pa'wechi ihtoraipua pehjio, Eesusio weeechi itipirioiopua pehjio, piineri. ");
INSERT INTO var_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Eesusio pu'ka muuwari nonorapusaapa, paaomi nokisiame tetewarepua ahpo ajawariaopua pehjio, tehki nokisiame pawekakera ka'kepusikaopua, natepaka nokisiamekapapua eekao. Ehjepamio Eesusia, marikarowaopua wa'asio, nerojampa weritoka eenarepua ahpo ajawaria nokisiachio, u'matome iintokaiopua weriparepua. ");
INSERT INTO var_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Nape ajawariaa wa'a ihtoame tetewapa Eesusio nerojampa weritoameo, naayuri maaekaopua pu'kao, siinakorepua tísia majakao. ");
INSERT INTO var_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Nape Eesusia wa'a chaachapoio majakao, ikanati nayewerepua cheeka: —¡Ka'te majako eemea! ¡Neeekaite puuua! ¡Iika yachapasa eemea, aamo majaya erakoao! ");
INSERT INTO var_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Ihji Eesusia pawekakerachi mooenasaopua, teeweterepua eekao. Waikao Eesusi ajawariaa tahpitika eraparepua, wa'a tiiame tetewakapa Eesusi iintoriao. ");
INSERT INTO var_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Kiisiki pahtiame eneriaipua pehjio, aatana te'takoopua, Eesusio, Eesusio ki ookapi ko'kotekame tetewikameai. Puuua ahpo pahtemiao, peewame eneriaipua pehjio. ");
INSERT INTO var_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Wa'a pa'wechi paonasaapua Eenesare weewarachi ajasisaapua, wa'ao pa'wesuwe o'yesapa pawekakerao, wa'a toarepua pu'kao. ");
INSERT INTO var_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Eesusio wa'a tekisochepa pawekakerachio, machiretupua muuwarieo. ");
INSERT INTO var_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Wa'a iikapa ti'tijoeria, ahpo ta'pechiami ujumasirepua, ahpo kokoriame ijinuwaeka i'noramia, yomachiami mochiwachiamiopua, ipetachi tekitoka upamia. ");
INSERT INTO var_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Waikao ahkaoi eenoio Eesusio, teesa ohjoewachioi, wekapi ohjoewachioio, pipiripi ohjoewachioio tiameo, ahkaoi u'matomiachi pooechiamio, poowesue tootowariamepua kokoriameo, tísia tesiwa chaachapaka Eesusichio, teesaoi Eesusi wisasorirachi ihchepajeraka, saukame itipitemichiopua ahpo kokoriamewao. Waikamio, yooma Eesusi wisasoriwachi ihchepakamea, saukame itipiriamepua, ahpo kokorewao. ");
INSERT INTO var_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Pa'parisero ti'tijoea, ookapi iyoteri ti'tijoe Eerusareni ohjoeme yeeka e'enakamea, Eesusi naaeparepua. ");
INSERT INTO var_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Ihjia ookapi Eesusi masitera ki paanikosa koayopaopua, Moisetaru nuurari chiiachitiao, na'arerepua Eesusi ma'masitewarao. ");
INSERT INTO var_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(Puuua na'arerepua pu'kao, ki koayamekapa ki weesa paanikosaapua pahchao, ko'komiao. Puuu parisero ti'tijoea, yooma i'isaeri ti'tijoeriapua tiamea, pu'ka ehkoriami Moisetaru nuurari chiia, iyorika mochitoamekapa pehjio. ");
INSERT INTO var_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Ihjia tiameo, te'ta muuwari nehjiwachi no'rakaiopua, tísia kaawe paanikosa koayame eneriaipua. Ihjia tiameo, weeka iinueriaipua tiame itapiti ahpo iyoriwa nokayao, i'ka eee nokiwamechitia: paasoo tísia kaawe papakoniame, piicheri, pehtoriopua tiame, oronse meetari kaajete, ahpo kochiyachioi, kaawe wichotiame ipetiachi.) ");
INSERT INTO var_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Pukaepa pa'pariseroa iyoteri ti'tijoea tiame, pu'kachi simiyame iinatukerepua Eesusio, chaachapaka: ki taamo ehkoriami nokariachitia nokayamepua? Puuua ki Riosichi iyorikao, kiisioi te'ta paanikosa koayamepua. ");
INSERT INTO var_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Eesusia wa'a chaachapao, nehjiarepua pu'kao: —Isaia ehkoriami Riosi nayewatukamea, ma'chiame cheeka iyoteriaipua, i'ka Riosi chiiao: Ihji ti'tijoeria no'o kaawe chaachapanipua chuwaecheo, nape puuua ahpo iikachi yooreminao, tísia mehka tiiai chaachapamepua noochio. ");
INSERT INTO var_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Puuua tísia iyoriameka nokayai, noochi simiyame masitekao, kihta kaawerumakaitepua ahpo noochi iyoriwa nokayao, pu'ka masitiao wihtukikapa, aapoe erakowachiche machename. ");
INSERT INTO var_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","’Eemea wa'a nokakao, toayamepua Riosi ka'karuma nuurario, aamo wa'api erakoakamera yoranarekao, aamo ehkoriami noonori noonowiriachitia. ");
INSERT INTO var_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Eemea aamo ehkoriamichitia nokaria yooraio, ki ahsepari yooramepua Riosi te'ta kaaweruma nuurariopua, ");
INSERT INTO var_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","i'ka eee chiiachitia: “Aamo noono aamo yeeyeopua tiameo, ka'karumako tuupuapua, aaata ahpo Noono na'ara cheekamea, ahpo yeeyeoiopua tiameo, meripuamechi puuua.” ");
INSERT INTO var_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Eemea ki e'wiamepua pu'ka Riosi kaaweruma nuurario, ki yooreka tetewamekapa aamo yayawao. Eemea ki ku'yamepua aamo yayawao, pu'ka yooma aamo iinuekao, Riosi iinuwarako tuuka. ");
INSERT INTO var_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Eemea wa'a tiame masiteka aamo tatanao, ki utewa yorapuameko tuuyamepua, ahpo yeeye ku'ipuaopua, ahpo noonooi. ");
INSERT INTO var_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Wa'a te'tiapa eemea Riosi te'ta Riosi nuurario, kiisi kihta nateyame iintamepua, pu'ka ehkoriami o'inia aamo te'teretoria teetoapa pehji. Wa'a nokisika eemea aamo tijoetusiachio, aamo tatanachi toisiame eemea, i'ka ki ahpo yayawa yoorepuaopua. Eemea, ki ookapi wa'a te'tiame nokaka mochitoamepua. ");
INSERT INTO var_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Wa'a chaanesapa Eesusia i'isaeri pa'pamiratuameo, ahpo waapi paaesapa wahjachi ti'tijoeo ooweruopua tiameo, chaanerepua pu'kao: —No'o kaawe keepumitiapua i'kao, nape kaawe inataka, kaawe aamo pahtemichiopua: ");
INSERT INTO var_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Ihtaoi ma'chi eenaka amochi pakiyamea, ki aamo na'itutiamepua Riosichi aamo kaawe teerewao. Aamo Riosichi kaaweruma tiia na'itutiamea, naatipua, aamo ki kaaweruma chiiakamera, aamo iikachi o'inia eenamera. ");
INSERT INTO var_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Eemea pahtiame enesaa, pahtepuapua i'kao, no'o aamo cheeriao. ");
INSERT INTO var_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Eesusi toisoopa pu'ka ti'tijoerio, petechi pakisoopua, Eesusi masiteraa, iinatukerepua Eesusio: —¿Achini cheeka chiiamua ma'chi eename tamochi pakiyameo, ki na'itutiamekoopua taamo Riosichi kaawe te'terewao? ");
INSERT INTO var_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Eesusia chaaneka nehjiarepua: —¡Aa eemee, kiisi pahtekame eemeai pu'kao? ¿Ki nane'riame eemea itapiti aamo rupituao, ki iikachisi pakiyamekopua pu'kao, ");
INSERT INTO var_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","ki aamo iikachi te'ta pakiyamekopua pu'kao, aamo e'rariwachi? ¿Ki nane'riame eemea topachikamerache u'matoamekopua pu'kao, siwachituche, neipao pu'kao machenamekopua weerewachio? Wa'a cheekao Eesusia, cheeka cheerepua yooma ihtaoi kooame enesaa, ka'chi tiiameko tuurepua ko'kotiaio, Riosichi kaawe te'terewao. ");
INSERT INTO var_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Cheerepu tiame: —Puuu tijoe ki kaaweruma erapatiamea, tijoe chu'warachi machenamekamerapua, puuukamerapua, taamo Riosichi kaawe te'terewa na'itutiamea. ");
INSERT INTO var_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Puuu taamo ki ka'karuma erapatiamea, taamo iikachi o'inia machenamepua, te'ta eratewarachi, yooma ihta suuwe erapori iintonarewa eraniamea, ichikonarewaa, tijoe ko'inarewaa, yooma ihta ki ahpo iinuwa iinuwanarewaa tiame, ");
INSERT INTO var_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","yooma ihta na'ara nokinarewaa, wihkuenarewaopua tiame, nawajinarewaa, piirechi iinuwa ikotunarewaa tiame; taamo aaata pukamina na'ara chaachapanarewa, weruma ahpo uunarewa, ki inata nokinarewaa tiame. ");
INSERT INTO var_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Yooma ihta aamo yooremina o'inia eratiamea, taamo na'itutiame taamo Riosichi kaawe teerewao. ");
INSERT INTO var_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Wa'a o'iniao Eesusia, Tiiro mochiwachiami akiparepua, Siironi mochiwachiami tiame. Wa'a asisaapua, aaata petechi pakiriaipua kiisi ahpo nane'rejereka aaataeoi, nape ka'chi iika wa'a ikime teererepua. ");
INSERT INTO var_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Ikanati wa'a eenarepua aaata yeeyera, ahpo kutewe na'arari yahchame u'paka. Puuua ikanati wa'a eenaka Eesusi kahtiachio, chokichi chopokorieka weriparepua. ");
INSERT INTO var_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Puuu oowitiamea, seenu weeechi ohjoeme enerepua Sirojenisi tewaniachi. Wa'a iintoka puuu oowitiamea, Eesusi itanerepua ma'chipasemichioopua, ahpo kutewewachi kahtiameopua na'arari. ");
INSERT INTO var_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Nape Eesusia chaanerepua pu'kao: —Nape kukuchikamera ko'koteniamepua pahchao. Ki kaawepu taamo tatana ko'koamiao, chuhchurikamera kipoteniao. ");
INSERT INTO var_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Nape puuu oowitiamea wa'a chiioi Eesusio, cheerepua: —Pichiwa wa'atepua Paamira, ahkasi chuhchuri koayamepua, kukuchi koayoi meesatere ruhjitiao. ");
INSERT INTO var_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Waikao Eesusia chaanerepua: —Kaawe cheeka nehjiakame muuua. Aamo tísia kaawe cheeka nehjiariawichioo, aamo kuteweapa yachapakame kahtiame puuuapa aamo ta'pechio. Kaawe eratoka no'ramitia muuua. Puuu na'arari aamo kutewechi yasariameapa, toarepua pu'kao wa'asi. ");
INSERT INTO var_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Waikaopu oowitiamea, ahpo ta'pechi asisaapapua, saukame tewarepua ahpo kuteweo, ta'iria po'yame ahpo kochirachio. ");
INSERT INTO var_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Eesusia Tiiro muuwari mochiwachiami oiyai machenasaapua, Siironiami u'matosaapua Reekapori weeechi mochiwachiami tiameo, Arirea weruma neromanichi eenarepua, wa'ao pa'weka tiiachi. ");
INSERT INTO var_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Wa'a asisoopua Eesusio, wa'a u'yeparetupua piiripi nakapi ni'o. Puuu nakapi ni'o u'yepakamea Eesusio, ahpo tesiwenurerepua pu'ka nakapi yachapateka. ");
INSERT INTO var_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Waikao Eesusia poanachi i'toka ki tijoe tetewachi pu'ka nakapio, nakachi suhturepakaopua, sekachi akachupasaopua tiameo, sutue chachaterepua yenichi. ");
INSERT INTO var_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Waikaopua tewekachi ne'nepaka weeru panisukaopua iwiwao, nakapi ne'nepakaopua: —¡Ejata! —chaacharepua eureo naewaniachio, puuua: ¡Wahjosa!, cheeka chaniwame. ");
INSERT INTO var_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Wa'a chaanetiache nakapia, wahjorepua nahkarao, kaawe inamupakao. Yeeniraai wi'ropakao, kaawe nayewarepua. Saukame itipirepua wa'asio. ");
INSERT INTO var_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Waikao wa'a iintosaapua, ki aaata tuuyenurarepua ahpo iintorio; nape wa'a chaanetiai nakapi sautetiamea, newitoka tuusirepua. ");
INSERT INTO var_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Waikao inamukamea ki nu'uti peenia erakokaopua, chaachaparepua: —¡Tisiwa peenia ihsiamepu tijoea, ahkasi tísia nakapikooiopua, inamutiamepua; ni'ooio nayewatiamepua tiameo, kiisi maaepori tiiamekoipua! ");
INSERT INTO var_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Piire taawechi Eesusia, ki ookapi napawirioi ahpo oiyachio, Eesusi masitia keepumiao, i'kao kihta ko'kome te'tioi, chaanerepua ahpo ajawariao: ");
INSERT INTO var_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","—Neeea tísia tesiwa e'riamenia i'ka ki ookapi i'wa no'o masitiachi napawikameo, paika taawe i'toamekopapua no'o ahjamao pu'kao, yooma soopariopa wa'asi ahpo ko'kometio. ");
INSERT INTO var_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Wa'atia no'o nonorapusoopua pu'kao ki ko'kotesao, wahka pooechioi wahjipamaoipua toore, kai waapisi e'enakame ihji i'wa e'enakamea. ");
INSERT INTO var_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Eesusi ajawaria waikao iinatukerepua: —¿Nape ihtana ko'kotetariapua, i'wa ki ti'tijoeekachio, ki'tiachiopua ahka taripuachio ko'kotepua? ");
INSERT INTO var_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Waikao Eesusia iinatukerepua ahpo ajawariao: —¿Ihkina paani itipitiame eemea naaju? Aapoeo chaachaparepua: —Oowisaniche paani. ");
INSERT INTO var_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Waikao Eesusia pu'ka muuwaeme e'enariameopua, wehchi mochipanurerepua pu'kao, yoomahka. Waikao Eesusia wehchi mochipasoopua, ahpo sekachi uusaopua pu'ka oowisani paanio, tewekachi ne'nepasopua, cheriyema kiasaopua ahpo Noono, ahpo ajawaria ki'yarepua pu'ka paani chi'wanasao, yooma wa'a mochipakameo, naachutemichiopua. Waikaopu Eesusi ajawariaa, naachuterepua yooma muuwario. ");
INSERT INTO var_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Wa'a ikisaopua Eesusia, so'chi paikapi maniriopa tiameo, ahpo Noono cheriwema kiasaopua, ahpo ajawaria ki'yarepua pu'ka so'chioi, naachutamichio tiameo. ");
INSERT INTO var_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Yoomahka ko'kosepatioopua wa'asi, ahkasi yooma ta'iria itipiwachisiopua, pu'ka ko'kotiame soparakameopua, ahkasi oowisani weeweruma wa'wari popochiame, na'poaretupua. ");
INSERT INTO var_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Puuu wa'a ko'kakamea, kiiya naao miiri enerepua, ti'tijoe ooweru kukuchi tiame. Ehjepamio Eesusia wa'a iintosaapa nonorapukaopua, kaawe eratonurerepua pu'kao. ");
INSERT INTO var_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Wa'a iintosaopua Eesusia, pawekakerachi mooenasaapua, Ramanuta weeechiami akiparepua, ahpo ajawaria ahjama. ");
INSERT INTO var_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Wa'a Ramanuta weeechi ohjoniaio, parisero ti'tijoea Eesusi naaeparepua. Puuua naaepasopua, o'inerepua Eesusio nekakoa chaachapaka. Wa'a chaachapakoapua parisero ti'tijoea Eesusio, itapiti peenia ihsiwa itanerepua, ahpo Riosichi eename pichiwatame. ");
INSERT INTO var_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Eesusia waikao weeru panisusaapua iwirao, chaacharepua: —¿Aatia ehpe taawechiami mochikame ti'tijoeria, Riosi peenia ihsiwache ahpo tetewitejeramepua, no'ooche akana o'inia eename ma'chitame? Nape neeea aamoo, ma'chiame chiiamepua aamowichioo, kihta tetewitepuamekopua wa'asio, Riosi peenia ihsiwaopua. ");
INSERT INTO var_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Wa'a chaanesapa Eesusia, toarepua pu'kao. Eenechi pawekakerachi mooenasaopua ahpo ajawaria ahjamao, paonamina akiparepua pa'wechio. ");
INSERT INTO var_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Waika taawechio Eesusi ajawariaa, natakepariaipua ahpo weeru nutuka i'tomiaopua. Piiripi paani wa'api itipitiame eneriaipua wa'asio. ");
INSERT INTO var_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Waikao Eesusia nane'riapao, natakepariamekopua ahpo ajawariao nutukao, paani rewarurarachi simiyame masiterepua, eee cheeka: —Kaawe aamo neesetomitia eemea, parisero ti'tijoechi rewarurarachio, Eerore rewarurachiopua tiameo, ihji ti'tijoe na'arame rewaruraraa, aaatachioi mu'ipamepua. ");
INSERT INTO var_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Nape Eesusi ajawariaa poanachi ahpo piiripi paaniche itipitiache, ahpo chaachaparepua: —Aa, Eesusia rewarurachi simiyame taamo nayewiamepua, taamo natakepariopa weeka paani nutuka taamo upamiao. ");
INSERT INTO var_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Eesusia wa'a ahpo chaachapame inamukapaopua, chaanerepua pu'kao: —¿Achinikai ka'chi ijikime erakoame eemea, soparamekoipua piiripi paani wa'api iinuekoio? ¿Kiisi noochi te'ta paparapamekosa eemea pehji? ");
INSERT INTO var_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","No'o ihsia tetewai eemea, ¿kiisi pahteka tetewame eemea? Ma'chiame no'o chiioipua masitekao, aatanakoopua no'oo, ¿kiisi pahtiame eemea no'oo, aatanakoo? ");
INSERT INTO var_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","¿Ki inatapame eemea mariki miiri ti'tijoe ko'koterioio? ¿Kehkina waari pochikame apechunatioio ko'kotioio soparakameo? Aapoeo nehjiarepua: —Oosa mariki aampa ooka waari enekamepua. ");
INSERT INTO var_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Eesusia chaanerepua tiameo: —Naao miiri no'o ko'koteriaoio, oowisani paanieoipua wa'asi, ¿kehkina waari pochiwatiamepua apechunatiameopua soparakameo? Eesusi ajawaria nehjiarepua: —Oowisani waari, apoche soparakameo. ");
INSERT INTO var_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Waikao Eesusi chaanerepua: —Yooma wa'a no'o iintorioio eemea, ¿kiisi pahtiame eemea no'oo aatanakoo? ¿Ki soparame ohjoarepua, piiripi wa'apikaipu puuu paani? ");
INSERT INTO var_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Arirea pa'wechi paonasaapa Eesusia, We'saira mochiwachi asirepua. Wa'a tekisaapua, aaata ki ma'chiriame u'yeparetupua. Puuu ki ma'chiriame i'toka e'enakamea, tesiwa chaachapaka itanerepua Eesusio, ahjachi seekarepakaoi, sautemichiopua pu'kao. ");
INSERT INTO var_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Waikao Eesusia ma'chi mochiwachi i'tokaopua sekachi panitokao, ahpo a'kae saampatekaopua puichio, ahjachi seekarepaka sauterepua. Wa'a ikisaopua, iinatukerepua pu'kao: —¿Ehsoo ehpeo ne'nepao, tetewamemua ehpeo? ");
INSERT INTO var_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Waikao ki ma'chiriamea ne'nepakao, nehjiarepua Eesusio: —Eje'e, tetewapamenia teesa, nape kutemorika tiame ohjoame. ");
INSERT INTO var_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Waikao Eesusia eenechi puichi seekarepasoopua, kawiyame ma'chireparepua wa'asi, ahsieme saukame itipikaopua wa'asi. ");
INSERT INTO var_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Wa'a ikisoopua Eesusia, uhjurarepua ahpo petechi no'ramichio, nape pu'kao chaanesapa pahcha: —I'wapi o'inia aamo weeriachio, seene simika no'ramitiapua aamo petechio, ka'te eenechi pakimitiapua mochiwachio. ");
INSERT INTO var_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Neipao Eesusia ahpo ajawaria ahjamao, pu'ka ki ma'chiriame sautesao, Sesarea nu'nunti mochiwachiami akiparepua, Iiripo weewachi. Pooechi nokisinioi Eesusia, iinatukerepua ahpo ajawariao: —¿Aatanako no'o tuuna ti'tijoeria? ");
INSERT INTO var_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Aapoea nehjiarepua: —Waanitaru Paatoamekata muuua, chaachaparepua. Wahjachi ti'tijoeria, Eeriataru aamo maayamepua, nape epeche wahjachia chaachapamepua, piirechi ahka aaatakatamua, ehkoriami Riosi nayewatukame eenechi eenariame. ");
INSERT INTO var_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","—Eemepe, ¿aatanakotipua no'oo? —iinatukere Eesusia. Peeroa waikao chaanerepua: —Muuua, Te'ta Riosie Weratiameramua. ");
INSERT INTO var_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Nape Eesusia Peero ahpo cheeriao, ki aaata ahpo ma'chitanurarepua pehjio. ");
INSERT INTO var_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Waikao Eesusia, pooechi ihtoai wa'a chaanesaapa Peeroo, apochi simiyame nayewerepua ahpo ajariao, eee cheeka o'ineka: —Ihji neee Tijoe Tijoetukamea, tísia aiwatepuamepua. Kiisi nakika tetewipuamenia yooma i'isaeri pa'pamiratuameeo, ihji pa'pamiratuamea naatipua: o'ochetiame ma'masitari tewaniamee, wa'a ikisa te'ta pa'pamira neeseriosie, i'isaeri iyoteri ti'tijoee tiame. Yooma pukae tísia aiwatesapa neeea, meripuamepua. Nape meritiaio neeea, paika taawechi i'toaionia, eenechi oijenamania. ");
INSERT INTO var_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Peeroa Eesusio ahpo ajawariao ma'chiame wa'a chiiopa ahpo meripo tuukao, poanachi i'toka, te'yarepua Eesusio. ");
INSERT INTO var_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Nape Eesusia ku'rika ne'nesapa ahpo wahjachi ajawariao, utewaeme te'yaka Peeroo, chaanerepua: —¡Poanatu muuua noochio, ka'te no'o naaepa muuua, Satanasi! Kiisi Riosi e'rachitia tetewamemua no'oo Riosio, ikitemo e'rao, ohsotia muuua, tijoe erakoachitia e'ramemua, Satanasi na'naritoame. ");
INSERT INTO var_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Waikao Eesusia ahpo ajawariao, yooma muuwaeme wa'a napawikameopua tiameo, chaanerepua: —Aaata no'oe te'ta masiteniame enenariamea, natakepametepua ahpochewichio teerewa inatao, ahkasi ahpo meripuame tiiaio, no'oche ki toaka na'naritomeripua. ");
INSERT INTO var_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Aaata ki toakamea ahpo pukeri o'iniasi yooma ihta ahpo ki kaaweruma ihsiao, ka'chi iika iniwaemeripua, Riosi weemera ahjariopua, Riosie ahpo kiapuameopua. Nape toakamea ahpo pukeri o'inia ahpo ki kaaweruma inisiriao, iinuemeri puuua weemera ahjario, Riosie newipaniameo. ");
INSERT INTO var_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","¿Te'ta kaawenanapu te'ta weeechi tísia paarasariteniamea, ki iinueniamewichio te'ta Riosi ahjari ki'yao? ");
INSERT INTO var_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","¿Iintunakosarepua epeche nateyameo, ki Riosi weemera ahjari taamo kianarewachitia? ");
INSERT INTO var_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Aaataai ti'tijoechio, suuwe e'rameopua noochi teerewameo, suuwe erapameopua tiameo no'o ka'karuma masitiao, wa'achi teerema neeeai Riosie Tijoe Tijoetukamea pukachio, eenechi no'o weeechi tekisaapa, tewekachi o'inia eenaiopua, yooma no'o Noono tewekachi ku'kuira ahjama. ");
INSERT INTO var_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Eesusia chaanerepua tiame: —Pichiwa chaaninia ihji ookapi i'wa ajakameo, ki wahjipamerikopua pehjio, ki tetewakaopua, no'o Noono Riosiwari tísiwari tekika noochi yasipameopua, no'o apoe aamo ki'yamechiopua reesiserio, no'o Noono ye'karichi muipuameopua. ");
INSERT INTO var_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Puhsani taawe i'toiopua Eesusi wa'a cheerioio, Eesusia Peero yeetorepua ooruchi kaawichi, Aakowoopua Waani tiame. Wa'a mooenasao Eesusia, sewina tiiame eneparepua ahpo ajawaria tetewachiopua. ");
INSERT INTO var_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Ihji Eesusi wisasoriraa, ki teesa tohsaname eneparepua, tajayame, keepachitia tohsaname. Ihji wisasoriraa, tisiwa kaawe wichotiameka tiiame eneparepua, kiisi ahsepame tiiame aaataeoi, wa'a tiiame tísia tohsaname wichokao. ");
INSERT INTO var_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Puuu yeetotiamea wa'ao, Eeriataru tetewarepua, Moisetarua tiame, Eesusi ahjama ajakame nayewaka. ");
INSERT INTO var_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Wa'a te'teriopua pu'kao Peeroa, chaanerepua Eesusio: —¡Masitarii, kaawechupena i'wa aamo ahjama e'enakame teemea! Paika ekaporatama teemea, piiripi aamowichio, piireo Moisetaruwichio, piireo Eeriataruwichio. ");
INSERT INTO var_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Peeroa wa'a chaacharepua Eesusio, tísia tahpitika erapakaopua ahpo tetewariao. Yooma paikaopua, wa'achi erakorepua tiame. ");
INSERT INTO var_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Wa'a chiioi Peeroo, paawika tiame tepoona eenakao, mo'poreparepua pu'kao, yooma ajakachio. Waikao wa'a toomarichio aaata nayewa chaaniame inamuretupua. Puuua cheechaniame: —Ihjipu no'o Taanaaa, te'ta tísia no'o nakiyaa. Yooma pu'ka Apoe aamo chaaniao, yoorakache mochitopuapua. ");
INSERT INTO var_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Wa'a tiiai apechusoopua paawio, Eesusiche werirepua wa'ao. Wahjaa ki naania ikirepua wa'ao, Moisea Eeriaa tiame. ");
INSERT INTO var_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Wa'a kaawichi o'inia tetekinioiopua Eesusi ahjamao, Eesusia ahpo ajawariao, ki aaata tuuyenurerepua pehjio, pu'ka te'pa kaawichi ahpo tetewariao, ahkasi ahpo eenechi oijenachisiopua ahjaka, i'ka Tijoe Tijoetukameo. ");
INSERT INTO var_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Pukaepa ihchi teeweka mochitoriai Eesusi ajawariaa pu'ka ahpo tetewariao. Aapoeo Eesusi oijenaniame nayewariachi inataka mochitorepua, pu'ka cheeriao eee cheeka ahpo iinatukekache: ¿Achini cheeka cheeriamare Eesusia, oijenaniamechi simiyame nayewaio, mukukai eenechi ahjaniameo? ");
INSERT INTO var_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Wa'a erakoapaopua, chaachapaka iinatukerepua Eesusio: —¿Achinikai chaachapani i'isaeri iyoteri ti'tijoea, Ehkoriami Iyoterichio, Eeriakamera enamio tuukaopua pahchao, ke'chu Riosie Weratiame yawichituka yasipoiopua? ");
INSERT INTO var_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Eesusia cheeka nehjiarepua pu'kao: —Pichiwapu puuua, Eeriakamera enamio tuutiamekopua pahchao, yooma ihta pahcha katewemiaopua pooeo aaata enameriwichioopua. Nape ¿aatia Ehkoriami Iyoteria chiiamepua tiameo, aaata Tijoe Tijoetukameo, tísia kokosa aiwamerikopua, ki nakipo tuuwameopua muuwaemeoipua ti'tijoeeo? ");
INSERT INTO var_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Neeea pu'ka Eeriao, eenario tuuyame neeeapa, yooma no'o enamia katewemiaopua; nape pu'kachepa te'ta Ehkoriami Iyoterichio cheeriachitiao, tísia nanaaramea, a'chikoi na'ara yoorarepua pu'kao. ");
INSERT INTO var_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Wa'a chaachapasiaiche, ajasitioopua wahjachi Eesusi ajawaria toitiachio, muuwaeme nooreka mochiniame tewarepua ahpo ajawariao, Moise nuurari ma'masitariopua, weeru chaachapame ahjama. ");
INSERT INTO var_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Puuu muuwaemea wa'a ihtoame tetewapa Eesusio, tísia kaawe erapaka ujumasirepua, Eesusi natepaka teepotemia. ");
INSERT INTO var_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Waikao Eesusia, iinatukerepua ahpo ajawariao: —¿Ihtana weeru chaachapai eemea pu'ka Moise nuurai ma'masitari ahjamao? ");
INSERT INTO var_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Nape ke'chu Eesusi nehjianiaiopua, aaata pu'ka muuwaemechi kahtiamea, peichi chaacharepua: —Masitari, saukame itipiniame nayewai teemea. I'wa aamo u'yepakamene no'o taanao, na'arari yahchame, ni'o iintapakamekapu pu'kao. ");
INSERT INTO var_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Ahkaoi oiyoiopua pu'kao, ihji na'arari yahchaa, utewaeme wiiwichipatiapu puuua, mumukipateka pu'kao. Wa'a ikitekaopua pu'kao, tootonewatiapua chu'wachio, ma'chi cheeteka taameraopua ki'sutekao. Wa'a yoorakaopua, u'wanakame teetekipapua pu'kao. Aamo ajawaria ma'chipanurekainia pu'ka na'arari yahchao, nape ki kajukapua ma'chipasekao. ");
INSERT INTO var_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Wa'a tiiame chaanetiapa Eesusia, chaacharepua: —¡Ai eeme ti'tijoeria, teesaoi ki paparame eemea Riosichio! ¿Ahkasi achinitio wa'a teereta neeea aamo ahjamao, aamo pepenipamichiopua wa'asio, aamoe wa'api Riosichi itamichioopua aamo sautepuawichioo? ¿Ahkasi akanasi anachata neeea, aamo ki oowe e'reka mochikaopua Riosio? Árisa, yaapiti no'o u'yepasao wa'ana pu'ka temario. ");
INSERT INTO var_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Waikao u'yeparetupua temario. Nape na'araria Eesusi tetewapao, mukipaterepua pu'ka temario, wehchi wichipatekaopua, ikapurisitekapua pu'kao, chu'wachioiopua toonewateka. ");
INSERT INTO var_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Waikao Eesusia, iinatukerepua noonorao: —¿Achinitio o'inia wa'a ihsiame ihji temaria? Noonoraa waikao, chaanerepua Eesusio: —Ahkasi simarokoi. ");
INSERT INTO var_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Weesa na'ichi iipapakamepua pu'kao, neerochiami tiame, merinarekaopua pu'kao. Wa'a tiiachipa muuua, yuumpame teeresaamua pu'kao, taamo cheriwepuapua yachapatenekao. ");
INSERT INTO var_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Eesusia waikao wa'a chiiopao, chaanerepua: —¡Yuumpame teeresa —chiiame muuua? ¡Noochi paparamewichioo, yooma yuumpaniamepua! ");
INSERT INTO var_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Waikao temari noonoraa sisinarepua cheekao: —¡Pichiwa amochi paparame neeeaaa! ¡Muuua epeche no'o ku'imitiapua, epeche no'o amochi paparamichiopua! ");
INSERT INTO var_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Waikao Eesusia muuwaeme tetewachio, te'yarepua na'arario, chaaneka: —¡Muuu Satanasi na'ararii, ni'o enepatekame i'ka temaríii, nakapi enepatekameopua tiameo, ikanati machenamitiapua i'ka temarichio! ¡Ka'te seena aampasi, ahjachi pakimitiamua eenechio! ");
INSERT INTO var_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Waikao Satanasi na'araria, ki ku'ita sisinakaopua, mukipaterepua eenechi. Wa'a iintokaopua na'araria, machenarepua wa'asi temarichio, mukipakame toisa temario. Waikao muuwaeme wa'a napawikamea, mukukame maaeriaipua pu'kao. ");
INSERT INTO var_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Nape Eesusia sekachi chapikaopua pu'kao, werisipurepua pu'kao. Waikaopua Eesusie werisiputiaapa temaria, saukame werisirepua wa'asi. ");
INSERT INTO var_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Neipao Eesusio, aaata ta'perachi muitoopua resipupuachio, Eesusi ajawariaa, iinatukerepua Eesusio: —¿Achini iikai ki kajure teemea pu'ka na'arari ma'chipakao? ");
INSERT INTO var_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Eesusia chaanerepua waikao: —Pu'ka wa'a tiame na'arari ma'chipaniamea, te'ta Riosichi paparaka ma'chipaniamepua, te'ta apoe Riosi utewarie. Apoea, apoe ahpo e'ra ihsiamepua. ");
INSERT INTO var_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Wa'a ahpo tetekiriachi o'inia nonowasaa, Arireami uumparepua waikao. Eesusia ki aaata ahpo nane'rejerarepua ahpo simiyachio, ");
INSERT INTO var_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","ahpo ajawariakamera epeche te'ta pahtemichio masitenariapa, pehjio. Pukaepa pu'kao, chaanerepua: —Neee Tijoe Tijoetukamea, tijoe nanaaramechi nehjipuamekaitepua, meripuawichioo. Nape neipa paika taawe i'toiopua meritiachio, eenechi oijenamerikaite neeea, wahjiparichi o'inia machenakao. ");
INSERT INTO var_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Nape Eesusi ajawariaa, kiisiki pahtiaipua pu'ka chiiao, tísia seewerepua iinatukenariaio. ");
INSERT INTO var_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Kapenau mochiwachi ajasirioiopua pu'kao, aaata ta'perachi ahpo che'cherepachio, Eesusia ahpo ajawaria iinatukerepua, cheeka: —¿Ihtana naewaka chaachapasia eemea pooechi nokisiaio? ");
INSERT INTO var_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Nape masiteraa kiisi ahpo tuunariapa chaachapariao, ihchi itipirepua, ahpo aatanakamera epeche weruma itipiniame nayewakamekapaopua pooechi nokisiaio. ");
INSERT INTO var_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Waikao Eesusia yasipasao, pu'ka ahpo oosa mariki aampa ooka ajawariao, ahpo waapi ajapanuresopua, chaanerepua: —Aaata epeche weruma enenariamea ahpo wahjachio, ki weruma ahpo uumetepua, ohsotia puuua, apoekamera yorakemeripua pu'kao. ");
INSERT INTO var_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Neipao ti'tijoeekachi oiaio, piiripi kuita koomipaka naasipa werapakao, chaanerepua wa'a mochikameo: ");
INSERT INTO var_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","—Aaata peenia e'raka apochi uuyamea aaata kuitao, wa'achi e'raka no'o uuyai teeremeripua apochio. Aaata piire no'o kaawe e'reka uukamea, ki no'oche kaawe e'reka uuyai tiiamepua, te'ta te'pa kahtiamera no'o Noono kaawe uuyai teeremeripua, Apoe i'ka wehjoarichi no'o uhjurakamera. ");
INSERT INTO var_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Waikao Waani Eesusi weerariaa, chaanerepua Eesusio: —Masitarii, aaata tetewikame teemea, aamo teewachi puuyachame na'arari, nape pu'kao, ta'omaka teemea ki taamo ahjama ohjoamekopua pu'kao. ");
INSERT INTO var_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Nape Eesusia wa'a chiiopa Waanio, chaanerepua: —Ka'te ta'omamitia eemea pu'kao. Aaataai peenia ihsiame no'o teewaraeo, kiisi na'ara ihsiamepua noochio. ");
INSERT INTO var_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Wa'a teeresoo aaataai ki taamo seepurawa enesaa, taamo ahjama te'teriamepua. ");
INSERT INTO var_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Aaataai noochi paparamea, piire arapaoi neeroi aamo oowekameo, kiisi wehchi wichiyamepua, Riosie kaawe yorapuao. ");
INSERT INTO var_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","’Aaata kukuchichitia noochi paparakame tatakorichi ruhjitesoopua, ohso kaawe enemii puuua, weruma moorino matasurara kutachi o'yesa pa'wechi ipaniaopua. ");
INSERT INTO var_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Eemea aamo seekaraoiopua tatakorichi aamo wichitesoo, ohso kaawe aamo tehpunapuapua pu'kao. Epeche kaawe piiripi seekaeka Riosi peenia tiiame ye'karichi pakiniaa, ki ooka seekaeka Satanasi ahjama na'ichi ipapuachitiao, kiisi wahjiamesi tajayachiopua; ");
INSERT INTO var_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","wa'ao na'ioo kiisi wahjiame tajenarichio; wa'ao ikuchuwaoi ki wahjipakao, tahpitika eiwepua tiiachiopua. ");
INSERT INTO var_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Aamo taaraoi tatakorichi aamo wichipatesoo, ohso kaawe puuua tehpunatia. Epeche kaawe piiripi taaraeka pakiniaa Riosi ta'iria mochiwachi ye'karichiopua, ki ooka taaraeka Satanasi na'ichi ipapuachi aamo ipaniachitiaopua; ");
INSERT INTO var_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","wa'ao na'ioo kiisi wahjiame tajenarichiopua; wa'ao ikuchuwaoi kiisi wahjika tahpitika tiiachi eiwepuao. ");
INSERT INTO var_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Aamo puusioi aamo tatakorichi aamo wichitiame enesoo, ohso kaawe puuua ma'chipatiaa. Epeche kaawe piiripi puusiekai tewekachi pakiniaa Riosi kahtiachi ahjamao, ki ooka puusieka Satanasi na'ichi ipapuachi aamo ipapuachitiaopua; ");
INSERT INTO var_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","wa'ao tísia ikuchuwao kiisi wahjiame tiiachi, na'ioi ki choipachi seena aampa. ");
INSERT INTO var_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","’Wa'a te'teremeri eemea, tísia kaawe aamo neesetoka tatakorichi wichiniameo, kihta tatakori aamo tewikepuawichiopua Riosi te'ta katewiachi taawechiopua, Riosia ahpo taawechi ti'tijoeri katewiachio, yoomahka na'ie i'yekiamechitia iintomerikopua, tamochi i'yawakaopua taamo tatakoriria ki cheriwetiameo. ");
INSERT INTO var_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Eemea, ki tatakorichi wichitepuawichio aamo piirechio, te'ta oonaemechitia mochitopuapua, aamo piirechi tetewachio kaawerumache yooraka mochitoka. Oonaeme eneniamea, aamo piirechiwichio kaawe yorapuao, nape aamo onachari wekatesaamua, kihtawichio kaawe enemamua aamo piirechi ku'imiao. Oonaa, ahpo anachari wekasaapapua, ki oosa onachari enepamepua. Pukaepa eemea, kaawe aamo neesetopuapua onachari eneniameo, ki wekapuawichio aamoo, aamo onachari eneniameo. Wa'a te'teresaa eemea, ta'iria mochima eemea aamo wahjachi ahjamao, wa'achitia oonaeme enepakapao. ");
INSERT INTO var_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Eesusia Kapenau tewaniachi machenasaapua, tetuminatu akiparepua, Uurea weewachiami, Oorani akichi cherayachiami. Wa'ami inisika asiyachiamio, muuwaeme napawisiachiopua ti'tijoe ooweruopua tiame, ahpo Riosi kaaweruma tuuyewari masitesirepua, senepi taawechi inisiwachitia. ");
INSERT INTO var_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Piie taawechi wa'ami inisioio pu'ka weeechiamio, ookapi parisero ti'tijoea Eesusi naaepariaipua, itapiti ki kaawe chaachasoopua, chapinariapa. Wa'a erakoapaopua teepotesao, iinatukerepua Eesusio chaachapaka: —Masitari, ¿reesiserijuare kuunarao, ahpo uupi toiwao? ");
INSERT INTO var_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Eesusi pu'kao nehjiarepua: —¿Ihtana aamo chaaniamekosapu, Moisetaru nuurarikosaapua naaju? ");
INSERT INTO var_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Aapoeo chaachaparepua: —Taamo ehkoriami Moisetarua reesisekamepua pu'kao, nape iyosichi chanika iyotesa kiasa, ahpo poanatawa pichiwatawao. ");
INSERT INTO var_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Waikao Eesusia chaanerepua: —Moisetarua nane'riai Riosio ki reesisiamekopua pu'kao, oowera wa'a iintorepua, tísia wa'a chaachapopapua pu'kao, kiisi e'wenarekaopua Riosio. ");
INSERT INTO var_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Nape pukeri o'inia Riosi yooma ihta enepaterioio, ki wa'a teereriaipua, Ehkoriami Iyoterichio Moise wa'api eee cheeriopua: “Riosia pukeri o'iniao, piiripi tijoe neterepua piiripi oowitiame tiame. ");
INSERT INTO var_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Wa'a tiachipa ti'tijoea, toimeripua ahpo yayawao, ahpo uupima pirenatumiaopua wa'asi, ");
INSERT INTO var_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","na'pa piiripichitia teeremeripua pirenatusaa.” Wa'a tiiachipao pirenatutiameapa, ki ookakaite puuua, piiripi wa'apikaitepua. ");
INSERT INTO var_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Pukaepa pirenatutiameo, aaataai tijoea oowitiameai, ki poanatametepua pu'kao, apoe Riosi iintokamekopua pirenatakao, pukeri o'inia nenewitiaiopua. ");
INSERT INTO var_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Ehjepamio ta'pechi nonorasaapa Eesusi ahjamao, Eesusi ajawariaa, iinatukerepua Eesusio nenewikame poanatuniame nayewariame. ");
INSERT INTO var_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Eesusia waikao pu'kao, te'ta ma'chiame tuuyerepua, eee cheekao: —Aaata piire ahka ahpo uupichi poanatusa piirechi ahjama neewisaa, suwepori tiiame tatakoriamepua, kiisi kaawe iintoka ahpo pahcha uupieriamechio. ");
INSERT INTO var_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Oowitiameai ahpo kuuna toisaa, piirechi ahjama neewisaapua, wa'achitia ki nu'uti suwepori iintuamepua tiameo, ki nu'uti tatakorika ahpo pahcha kuunaeriachiopua. ");
INSERT INTO var_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Neipao, ma'chi kahtioio Eesusio, kukuchi u'yeparetupua wa'ao, pu'kao Eesusia ahjachi seekarepakao, Riosi kaaweruma neesetori yahchemichiopua pu'kao. Nape Eesusi ajawariaa, ki eerinatemichiopua Eesusio, ki u'yepajereriaipua kukuchio. ");
INSERT INTO var_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Nape Eesusia ahpo ajawariao, wa'iniopa ki apochi e'enamichiopua kukuchio, te'yarepua pu'kao, eee cheeka: —Tooa pu'ka kukuchio noomina e'enamichio. Ka'te wa'ine pu'kao. ¿Ki nane'riamekosa eemea, kukuchika te'teriamekopua Riosi ye'karichi muimerio? ");
INSERT INTO var_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Pichiwa aamo chaanenania, ki kukuchichitia ikanati pichikiamea, Riosi chiia ahpo ye'karichi paajutewao, ka'chi iika pakimeripua wa'ao. ");
INSERT INTO var_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Waikaopua piiripi kuita apechunasaapua, koomirepua. Wa'a ikisaopua ahjachi seekarepaka, Riosi neesetori yahcherepua pu'kao, kaaweruma weritomichiopua pu'kao. ");
INSERT INTO var_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Piie taawechi wahkami u'matoi Eesusio, aaata tijoea u'masika eenaka naaeparepua Eesusio. Ihjia Eesusi tawemina chopokorieka weripakao, taweminao, iinatukerepua pu'kao: —Muuu Kaaweruma Masitari, ¿ihtana yoratania ki wahjiame ahjari Riosie no'o kiapuawichioo? ");
INSERT INTO var_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Eesusia chaanerepua: —¿Ihtanawichio kaaweruma no'o teewame muuua? Apoe Te'ta Kaawerumaraa, piiripiche puuua, apoeche te'pa kahtiameche Riosi. ");
INSERT INTO var_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","¿Machiyamekosa muuua, Moisetaru nuurari chiiao? Puuua eee chaaniamepua aamoo: “Ka'te suuwe erapori ihsi, ka'te me'ya, ka'te ichiko, ka'te wihtucha aaataoi na'ara yorapuaichioo, te'ta yooreka yasitopuapua aamo yayawao.” ");
INSERT INTO var_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Waikaopu tijoea, nehjiarepua Eesusio: —Eje'e Masitari, nu'utikai machiyamenia pu'kao, nu'utikai ahsieme yooraka yasitoamenia pu'kao. ");
INSERT INTO var_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Waikao Eesusia kaawe e'repakaopua pu'kao, chaanerepua: —Nape muuua wa'a tiiaio, piiripi itapiti toitiamemua pehjio: nehjimitia naaju muuua, yooma aamo iinueka kahtiao, wa'a iintosaamua, tooremuka mochikame ku'imitiamua pukaeo. Wa'a iintosaa muuua, tewekachikamera iinuemamua, aamo paarasario. Yooma wa'a iintosaapua muuua, noochi enapuapua waikao, no'okamera yorakeka yasitomia. Ahkasi yooma wa'a iintosaape, iinuemamua waikao, ki wahjiame ahjario. ");
INSERT INTO var_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Nape ihji tijoea tísia tomiwaemekapaopua, yuuweeme itipirepua wa'a tiiame inamukapao, yuuwesipakapaopua. Wa'a teetoka no'arepua, kiisi wekatenariapapua ahpo tísia paarasatiao. ");
INSERT INTO var_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Waikao Eesusia ahpo ma'masitia norikame ne'nepakao, chaanerepua pu'kao: —¡Ki teesa tehki e'rame tísia totomiwaemea, Riosi ye'karichi ahpo muipuao! ");
INSERT INTO var_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","I'ka wa'a chiiopa Eesusio, Eesusi ajawariaa, tahpitika eraparepua Eesusi cheeriao, kiisi pahtiapa puuua pu'ka chiiao. Waikao Eesusia eenechi chaanerepua pu'kao: —¡Tísia tehki e'rame aaata tísia paarasatiamea, ahpo Riosi ye'karichi muimiao, ahpo tísia paarasarichi toomichiche paparamekapa, tisiwa weemuame pukachio! ");
INSERT INTO var_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Epeche ki tehki tiiaitepua tumusari tewaniame animaria, i'ikia puusirachiami u'matoteniaopua, ki aawata te'ta paarasatiameo, Riosi ye'karichi pakimiao. ");
INSERT INTO var_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Wa'a tiiame inamukapa Eesusi ajawariaa, epeche tahpitika erapakaopua chaachaparepua ahpoo: —¿Aatanakamera newipame teeretapua, wa'a teeresoo? ");
INSERT INTO var_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Eesusia wa'a chaachapame inamukapaopua, chaanerepua: —Ti'tijoewichioo ki kajume tiiamepua, ki ahpo wa'api newipateme tiiamekapapua. Nape Riosiwichioo, kiisi tehki tiiaitepua, apoekameraka puuua, te'ta taamo newipatiameraa. Apoewichioopua Riosio, kihta itapitioi, ki'tiaitepua ki kajume tiiameo. ");
INSERT INTO var_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Waikao Peeroa chaanerepua Eesusio: —Paamira, kaawechupena teemea, yooma toakamepua taamo weeechi iinuenarewa erakopua, aamokamera ahjama te'teretonariapa. ");
INSERT INTO var_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Waikao Eesusia yooma inamumichioopua, weeru naewakao, cheerepua Peeroo: —Pichiwa chaaninia i'kao: aaataai i'ka kaaweruma tuuyewarichi, noochi te'teriamewichioo, ahpo ta'pewa toakamea, ahpo papachiwao, ahpo pipiniwao, ahpo noonoo, ahpo yeeyeo, ahpo uupio, ahpo tatanao, ahpo weewaoio, ");
INSERT INTO var_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","kiapuamepua i'ka weeechi mochitoiopua pehjio, itapiti epeche piire sientosa u'matoka nateyame ki yooma ahpo toariachitiao. Puuu tísia nateyame pu'ka kiapuameraa, Riosie ahpo newipaterapua, ahpo tatakoriria ahsieme cheriweniame, i'ka weeechi mochitoaiopua pehjio, aiwaka mochitoaiopua. Puuua kiapuamepua tiameo, weemera Riosi ye'karichi mochipuameo, ahkasi ki wahjiamesi ahjaka mochipuachi. ");
INSERT INTO var_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Nape pu'ka taawechiami Riosie ahpo ye'karichi muipuachio, Riosie reesiseniaopua, ehpiami i'ka wehjoarichi te'ta weruma nateyame tetewiniame paarasatiapao, kihta weruma nateyame tetewipuame puuua, Riosieo. Nape ehpiami i'ka wehjoarichio, kihta weruma nateyame tetewitiamea kihta weruma paarasatiapao, waika taawechi Riosia ahpo ye'karichi muipuawichio reesisiaio, te'ta weruma te'terewaeme tetewimapu Riosia. ");
INSERT INTO var_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Pooechi nokisinioi Eerusareniteo, Eesusia ahpo ajawariao, pahcha weritoriaipua. Pu'kao oisa teetoka pahcha weritopao, seewerepua Eesusio itapiti ahpo ikipuao. Neipa nonosiamea tiamea, wa'achitia seewerepua. Eesusia wa'a erakotopapua pu'kao, poanatasaopua pu'ka oosa mariki aampa ooka ahpo ajawariao, ma'chiame tuuyerepua pu'kao, ihtana apochi teeremerikopua wa'a Eerusarenio. ");
INSERT INTO var_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Waikao Eesusia o'inerepua tuuyekao, ihtana ahpo ikimiaopua wa'ao: —Tetewame eemeapa, Eerusarenite asiyamekopua wa'asi. Wa'ao neee Tijoe Tijoetukamea, nanaarame ti'tijoechi nehjipuamepua, isaeri ne'neseriosi pa'pamuratuamechi tiame, wa'a ikisao iyoteri ti'tijoechi i'topuamenia tiame, yooma puuu noonoimeripua, no'o mukiwachi uhjurakao. Neeea pu'ka noonoimerie chaachapatioopua, seesenu ti'tijoechi kiapuamenia meripuawichioo, rooma ti'tijoerichi. ");
INSERT INTO var_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Puuu seesenu ti'tijoeria, no'o tísia na'ara yorameripua, a'chikoi yoorakao wepaka tiame. Puuua ahkasioi no'o nanarichi akachupemeripua, nanaarakao. Wa'a noonoisaapua, no'o meripuachi i'tomeripua, kurusichi chuhchaka meripuaichiopua. Nape wa'a meritiainia, paika taawe simiyachiopua, eenechi ahjameri neeea oijenakao. ");
INSERT INTO var_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Waikao Aakowoa Waania tiame na'pa Sewereo tatanaraa, Eesusi naaepakao, chaanerepua: —Masitari, itapiti aamo itanenariai teemea taamo yorajera. ");
INSERT INTO var_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Eesusia waikao wa'a chaachapatiapao, chaanerepua pu'kao: —¿Ihtana no'o aamo yorakejerai eemea? ");
INSERT INTO var_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Waikao aapoeo chaachaparepua: —Teemea aamoo, aamo ye'karichi yasipasaapa, taamo reesisejeranipua aamo chokichi mochipuapuawichiopua, taamo piiripio aamo ahjamina, piireo aamo owemina. ");
INSERT INTO var_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Waikao Eesusia chaanerepua pu'kao: —Eemea kiisi ijinatamepua aamo itayao. ¿Ahkasioi anachameri ohjoare eemea no'o tísia aiwamia paasochi iijimiachitiao, pu'ka tísia no'o aiwarieo pukachi moropiteka paatoniamechitiao? ");
INSERT INTO var_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Aapoeo nehjiarepua waikao: —Eje'e, anachameri teemea. Waikao Eesusia chaanerepua: —Pichiwa aiwatare eemea kokosatiameo, itapiti tísia chihpuame iijikaopua, itapiti tísia aiwaniamechi aamo moropiteka paatoniamechitiaopua; ");
INSERT INTO var_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Nape puuu aamo no'o ahjamina mochipuao, piiripio no'o oenao, piirea no'o ahjaminaoi, ki neeekamera iintomeripua pu'kao; Apoe no'o Noono tewekachi iintomeripua pu'kao, apoe te'ta apochi reesiseri ki'yamera. ");
INSERT INTO var_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Waikao puuu oosa mariki Eesusi ajawaria ki wa'a chaachapakamea, pu'ka ooka Eesusi ajawaria wa'a chaachapariopao, nekawerepua pu'kao, Saantiaoopua, Waaniopua tiameo. ");
INSERT INTO var_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Nape Eesusia pu'ka nekawiopao, yooma ahpo ajawaria paaesaopua, pirena ajawakaopua chaanerepua: —Eeme wa'apiai nane'reka mochitoamepua i'ka wehjoarichio, iintuamekopua aaata ya'yawichio, ahpo tararia ti'tijoerio, tísia kokosa yooraka tekipanatiamekopua pu'kao. Puuua, tísia ahpo weruma erakoka mochitoamepua. ");
INSERT INTO var_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Nape eemea noochi paparamea, ki wa'achitia weruma erakoka mochitopuapua. Ohsotia aaata eemea te'ta weruma enenariamea, kiisi aamo weruma e'raka yasitomeripua; ohso kaawe puuua kaawe e'raka ku'imeripua ahpo wahjachio. ");
INSERT INTO var_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Aaata te'ta paamiratuame enenariamea, ohsotia puhkuka teeremeri puuua ahpo wahjachio. ");
INSERT INTO var_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Neeeai Riosie Tijoe Tijoetutetiamekai ki epeche weruma teeremia eenakamenia amochio, no'o kaawe yorakepuawichioo, ohsotia neeea, aamokamera yorakemia eenakamenia, aamokamera kaawe yoramia. Neeea aamowichioo, ahkasioi no'o ahjarioi, aamowichio pejana nehpupaka nehjimia eenakame neeea, aamo kiisi kaawe noonowiriawichio natetemia. ");
INSERT INTO var_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Eesusi Eriko mochiwachiami u'matoi ahpo ajawaria ahjamao, muuwaeme nokisiame tiame Eesusi ahjamao, pooesuwe yasariaipua aaata ki ma'chiriame, puuua ihkorewa itaka yasariaipua wa'ao. Puuu ki ma'chiriamea, Watimeo tewaniame enerepua, Tiimeo tewaniame taanara. ");
INSERT INTO var_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Puuua Eesusi wa'ami u'matomioio, puuua Eesusio Nasare ohjoemeko tuuwame inamukapao, weeru sisinamurepua Eesusio, chaaneka: —¡Eesúsiii, Raawitaru tetejimarisiwachi naawakamee, no'o cheriwejerani neeeaa! ");
INSERT INTO var_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Wa'a chiiopa pu'kao, waapi ajakamea, te'yarepua pu'kao, nape puuu ki ma'chiriamea teritiaio, epeche uwatiame sisinamurepua Eesusio: —¡Raawitaru tetejimarisiwachi eenameee, no'o tesiwa e'remitiapua pahchúuu! ");
INSERT INTO var_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Waikao Eesusia weripakao, chaanerepua ahpo chokichi ajatoameo: —No'o u'yepao pu'ka tijoeo. Waikao ki ma'chitiame i'noramea, chaanerepua pu'kao: —Nahpesa naaju aamo paaena Eesusi. Kaawe erapasa naaju. Utewataka werisisa. ");
INSERT INTO var_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Waikao ipasapa ahpo matomoporao, ikanati niika werisika, Eesusi chokichi eenarepua, ahpo i'norame panitoaeopua. ");
INSERT INTO var_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Eesusia waikao iinatukerepua pu'kao: —¿Ihtana aamo yoorejeranimua? Ki ma'chiriamea nehjiarepua cheekao: —Masitari, ma'chiriame enenare neeea. ");
INSERT INTO var_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Waikao Eesusia, chaanerepua pu'kao: —Wee, kaawepua. Kaawe e'raka no'ramitiamua. Noochi paparakapa muuua, aamo ki ma'chiriaopua muuua, saukame muuuapa wa'asi. Waikao ki ma'chiriamea, ikanati ma'chireparepua, kawiyame tetewaka. Waikao puichi saukamea, ahjama simirepua waikao, Eesusi na'naritokao. ");
INSERT INTO var_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Eesusia Eerusareni waapi ihtoaiopua, Weetajeo Wetaniao tiame, Ooriwo kaawichi taweminao, ooka ahpo ajawaria chaanerepua: ");
INSERT INTO var_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","—Paao ohjoewachi siimpamitia eemea, i'wa o'iniao ma'chiachio. Wa'a muirachio piiripi uuru teimeri eemea, masotatiame wa'asi, puuua ki yaasetoniame pehjio. Pu'ka uuruo, o'yaeka chuhkuame teimeri eemea wa'ao, wa'a kaari ko're yeetarachi poemina. Na'sonasa no'o u'yepamitiapua pu'kao. ");
INSERT INTO var_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Piire ahka iinatukesoo pu'ka uuru aamo na'sochoio, chaanepuapua pu'kao: —Eesusi Apoe taamo Paamiraa, ahpo i'yetonurakapua ku'itapio, eenechi upapuatapua ku'we. ");
INSERT INTO var_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Puuua wa'a siimpasaa waikao, wa'a tewarepua pu'ka uuruo, yeeta ko'rechi poemina o'yetiame. Waikaopua pu'ka uuru o'yara na'sochoiopua, ");
INSERT INTO var_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","aaataa wa'ao sisinamurepua chaaneka: —¿Ihtana yooraka nooka eemea wa'ao? ¿Achini iikai na'sochani eemea pu'ka uuruo? ");
INSERT INTO var_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Waikao Eesusi uhjurariaa, te'ta Eesusi ahpo chaanenurechitia nehjiarepua. Wa'a chaachapakopua pu'kao, reesiseretupua i'tomichioo. ");
INSERT INTO var_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Waikao Eesusi uhjurariaa pu'ka uuruo, Eesusi u'yeparepua pu'ka uuruo. Waikao Eesusia pu'ka uuruo, itapitie ipetetiopua pu'kao, yaasetoka yasitorepua pu'kao. ");
INSERT INTO var_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Waikao wehchi ahjama nokisiamea, ahpo kemawa ipekesirepua simiyachio. Wahjachia kuhsisawa ihpapasesirepua u'matomiachio. ");
INSERT INTO var_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Waikao pahcha nokisiamea, neipa nokisiamea tiame, chaachapasirepua siinakosikao: —¡Tisiwari, tisiwari! ¡Riosichi eename Yawichiii, Te'ta kaawerumara Yawichiii! ");
INSERT INTO var_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","¡Ehpe o'inia werisipupuapua eenechio, ehkoriamisi Raawitaru yawichituriao! ¡Cheriwema ki'yame teemea Riosi tisiwa te'pa kahtiameo, te'ta te'pa tewekachi o'inia aamo uhjurakameopua weeechi! ");
INSERT INTO var_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Ehjepa Eerusareni ajasisaapa Eesusia, isaeri te'ta tioparachi pakirepua, wa'a yooremina napawikarichi. Wa'ao yooma ne'nesapa yoorekoo, aarikopa wa'asio, Wetaniami akiparepua ahpo oosa mariki aampa ooka ajawaria ahjamao. ");
INSERT INTO var_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Pu'ka meere Wetaniami nokisinioio Eesusi chorowapasaa, ");
INSERT INTO var_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","mehka o'inia tetewariaipua, echitiame chuunao weeru sawatakame weeriame. Pu'kao ahseriaipua ne'nemia taakaeko o'raka, kihta taakaeme werirepua, saawarache apoche. ");
INSERT INTO var_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Waikao Eesusia chaanerepua pu'ka eechichunao: —¡Ka'te oosa taakemitia muuua, ki aawata aamo ko'komichiopua taakiao! Puuu Eesusi ajawariaa, inamurepua Eesusio, pu'ka eechichuna na'ara chaanerioio. ");
INSERT INTO var_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Neipa i'ka cheesoo Eesusio, Eerusareni ajasirepua. Waikaopua i'isaeri tiopachi pakisaapa Eesusia, yooma puuyanarepua wa'ao, ki kaawe nokayameopua wa'ao, itapiti nehjameopua wa'ao, tarayameopua tiame. Yooma ru'minerepua meesao, toomi naakuriwaka mochikameopua tiame, waankooi ahjachi mochikao, yooma ru'minaka ihpapaserepua tiame, kooro nehjaka mochikameo, yooma ihpapaserepua koorokario. ");
INSERT INTO var_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Eesusia wa'a tiopachiopua tiameo, aawataoi ki towarepua itapiti i'toka nonoramichioopua, yoorekomi nonoraka puuyaniachio. ");
INSERT INTO var_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Wa'a yoorasaapa pu'kao, tísia te'yarepua pu'kao, chaanekao: —¿Ki Ehkoriami Iyoterichio, eee chiiame Riosia: “No'o kariwaa, ki noochi paparapuawichio netetiamepua, yomatiame weeechi mochikamewichioo”? Nape eemea no'o kariwao, ichikoame teesowara, iintaparepua. ");
INSERT INTO var_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Neeseriosi pa'pamiratuamea iyoteri ti'tijoea tiame, wa'a ahpo chaaneniame inamukapaopua, waika o'inia i'yasirepua aachin teeka Eesusi ahpo merimiao. Nape wa'a erakoaipua majawerepua ti'tijoerio, muuwaeme tísia peenia e'raka keepuamekopua Eesusio. ");
INSERT INTO var_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Tukapasipasoopua wa'asio, Eesusia ahpo ajawaria ahjamao, ma'chi machenarepua wa'a muuwari mochiwachio. ");
INSERT INTO var_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Meere piario, eenechi wa'ami uumatonioio, puuu eechichuna Eesusi nayeweriaopua, wakipakame werirepua wa'asi. ");
INSERT INTO var_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Waikao Peeroa chaanerepua Eesusio: —Masitari, ne'neo pu'ka echichunao, tapana aamoo ki taakenureriao wa'asi. Nee, ¿ikanáti wakiparepua wa'ási? ");
INSERT INTO var_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Eesusia nehjiarepua: Wa'a iintokame Riosia aamo tetewimichioopua, itapiti ahpo itanetiaapua aamoeo, wa'a iintoka nehjiamekapapua ikanati. ");
INSERT INTO var_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Pichiwa te'ta paparaka nayewesaa eeme Riosichio, ihta itapiti aamo tesiwa e'raka itasoopua, aamowichio iintomeriche puuua, kai nu'utikoipua aamo itayao, kaawi kehchumakoio. ");
INSERT INTO var_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Pukaepa, aamo weruma Riosichi itayao, kaawi kehchumaoi enesoo werumao, ihta kaawioi wa'a weeriamechitiao, wiitu weripa pa'wechi chaanesoo, wa'a weripamii kaawia. Pukaepa aamo chaaniamenia, kihta seeweka itanepuapua Riosio ihta kehchuma aamo cheriwejeraopua, nape te'ta pichiwa Riosichi paparaka. ");
INSERT INTO var_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Nape eeme Riosi ahjama nayewanariame enasaa eemea, kaaweruma e'raka enamitia muuua aamo iikachio, aamo iikachioi kihta inasoka nayewemia. ");
INSERT INTO var_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Aaata aamoo ki kaawe iintosoopua, ka'te nekumeka itipimitiamua pu'kao; ohso kaawe cheriwepua muuua pu'kao, wa'achitia Riosiai waikao, aamo cheriwemapua tiameo, ihtaoi aamo itayae cheriwekao. Nape muuua ki cheriwiame enesoopua aaataoiopua aamo piirechio, Riosiaio kiisi aamo cheriwemapua. ");
INSERT INTO var_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Neipa i'ka wa'atiame nayewasaapa Eesusia, eenechi Eerusareni eenarepua. Wa'a i'isaeri tiopachi pakisa yooremina oiyoio, neeseriosi pa'pamiratuamea, iyoteri ti'tijoea tiame ookapia, wa'a ikisa o'ochetiame pirenaturi tewaniamea ti'tijoe ma'masitari, ");
INSERT INTO var_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Eesusi naaepakaopua, iinatukerepua: —¿Aatana reesiserichi inisiamemua aamo masitiao? ");
INSERT INTO var_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Wa'a chaachapopao Eesusia, chaanerepua: —Pu'kachi aamo no'o iinatukia, aamo iinatukiame neeeai. Pu'ka aamo no'o nehjiasoo, aamo nehjiama neeeai aamo no'o iinatukiao. ");
INSERT INTO var_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","¿Aatanakamera ihsikame uhjuraka Waanio paatomichioo, Riosikamera, ti'tijoekamerakosaoi? ");
INSERT INTO var_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Waikao aapoeo, ihchi nayewakaopua ahpoo, chaachaparepua: —Riosi uhjurario taamo tuusoo, eee cheeka taamo nehjiamapua: “¿Achini iikai ki pichikeka eeme pu'ka chiiao?” ");
INSERT INTO var_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Wa'a tiiachio, ¿ihtanakamera chaachapata teemea? Aaata ti'tijoerioi, ka'chi iikaoi uhjurario chaachapamete teemea. Puuua wa'a chaachaparepua majayapa ti'tijoerio, pu'ka Waanio yomarika ti'tijoe ooweru tiameo, Riosie uhjuratiameko, erakoamekopua pu'kao. ");
INSERT INTO var_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Wa'a tiiachipao, chaachapaka nehjiarepua Eesusio: —Kiisi nane'riame teemea. Waikao Eesusia chaanerepua pu'kao: —Wa'a teesoo neeeai ki aamo tuuyemapua, no'oo aatanakamera no'o uhjurariaopua, i'ka no'o masitia inisimichioo. ");
INSERT INTO var_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Ehjepamio Eesusia wa'achitarichi masiteka o'inerepua wa'a i'isaeri napawikarichio. Puuua eee chaanerepua: —Seenepi simiyachio wahka yasariataipua aaata tijoe panijuwari echayame. Puuua panijuwari echisapao, ko'reteriataipua pu'kao. Naati neteriaipua tiameo, tekesatura, pu'kao i'ipasaopua wa'a sahtunapuawichiopua. Naati neteriataipua tiameo, kai waapisi weeriame ne'nesero, wa'a te'pa werika inatepuawichiopua echitiameo. Wa'a ikisaapa neipa tekipaname i'yasaapua, wa'a wasachi eechichi toariatapua tekipanamichioo. Yooma wa'a iintosaapa, mehka akipariatapua seenu weeechi. ");
INSERT INTO var_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Neipami ahsepasoopa pu'ka echitiame i'ipasa naachutapuawichioo, aaata uujurariatapua ahpo naachutari i'noramichioopua wa'a kajukame naasipasio. ");
INSERT INTO var_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Nape wa'a tekipanamea chapisa wepisapao, wa'atia uhjureriatapua ahpo teekoo, kihta i'toka. ");
INSERT INTO var_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Waikao wa'a ikitiapa apoe teekoraa, piirechi uhjurariatapua waikao, ahpo ku'iwa. Nape pu'kaoi tekipanamea, moochi weweka na'ara yooraka eeranatesaopua, ahpo teekochi no'apuriatapua pu'kaoi. ");
INSERT INTO var_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Waikao paika simiyachiopua te'ta teekoraa, eenechi piirechi uhjurariatapua, nape puuua meriretiatapua. Neipao epeche weeka uhjurariataipua, nape pu'kaoi tekipanamea, ookapi ko'isaopua, wahjachio oowera wepisaa nonorapuriatapua ahpo teekochio. ");
INSERT INTO var_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","’Waikaopu teekoraa, ki aaata uhjurame tiiapaopua, piiripi wa'api taanaekaipua tísia nakiyao, pu'kapechi uhjurariatapua: “Ki merimapu i'kao”, e'raka, “Yooremapua i'ka no'o taanakopao”, e'raka. ");
INSERT INTO var_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Nape tekipanamea, pu'ka wa'a ihtoame tetewakapaopua, chaachapariatapua: “Ihjia taamo teekora taanarapua, ihjia ahpo noono mukisoopua, puuukamera yooma ahpo noono iinuekao, teekorachitia itipimeripua. Meritaria pu'kaopua tiame. Wa'a noonoisaa teemea, yooma pu'ka iinuemia iinueka itipima teemea”, chaachapariatapua. ");
INSERT INTO var_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Waikaopua pu'kaoio, chapisa me'yariatapua. Pu'kao merisapao, pu'kao eechichio, ma'chi i'toka ipariatapua. Wa'asa noonoiriata puuua. ");
INSERT INTO var_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Pu'ka yooma naewasaapa Eesusia, iinatukerepua ahpo keepuameo: —¿Wee, ihtana iintotapu teekoraa ahpo tekipanateriao, wa'a noonowiriopao? ¿Ko'itarepua ahpo tekipanakiameo wa'a enasaopua? Puuua wa'a iintosaa, ¿ki wahjachi kiatarepua pu'ka tehkiwarao, ki ichikoka tekipanamekamera? ");
INSERT INTO var_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","’Naakona, ¿ki iyonakame eemea pu'ka Ehkoriami Iyoteri chiiao, tehte ki nakika ipatiame nayewachio? Eee chiiamepua Ehkoriami Iyoterichio: Tehte tekipaname ihpapariaa ki nakika tetewikao, puuu tehte ipaka tetewitiamea, te'ta nakiwamera eneparepua, te'ta kaari nawatera utewarachitia. ");
INSERT INTO var_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Pu'ka tehte te'ta nateyame enepatekamea, Apoe taamo Noono tewekachi kahtiame iintokamepua. Teemea pu'ka tehteo taamo Noono iintoriao, tísia peenia erakoka tetewame teemea. Wa'a cheeriame Raawitarua, Ehkoriami Iyoterichio. ");
INSERT INTO var_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Puuu ne'neseriosi pa'pamiratuamea, wa'a cheekopa Eesusio, apochi simiyame nayewaka chiio erakoparepua. Wa'a erakoapa puuua, karichi chapisa yachanareriaipua Eesusio, nape majawiapa ti'tijoerio, wa'atia toisa nonowarepua pu'kao. ");
INSERT INTO var_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Neipapao Eesusia, parisero ti'tijoe uhjureretupua, Eeroremina chuchukuame ti'tijoe. Ihji uhjuratiamea, Eesusi noonotemichio uhjuratiame eneriaipua, itapiti ahpo wenejiwa chaachasoopua, ahpo pa'pamuratuamechi wenejimichio. ");
INSERT INTO var_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Wa'a e'enakao chaanere puuua: —Masitari, nane'rena teemea aamoo, te'ta pichiwarichi simiyamekamera chiiamekopua, a'chikoi chaanenioiopua ti'tijoeeopua, kiisi sewina erapamekopua. Muuua, wa'a chaaneriaiopua kiisi toayamekopua, te'ta Riosi pichiwari chiia masitekao. Pukaepa i'ka aamo iinatukemo o'rame teemea: “Nee, ¿kaawejoare te'ta yawichiwichio koparoaniame, nateteniao?” ");
INSERT INTO var_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Nape Eesusia nane'riapa ahpo wihkueka chaachapopa pu'kao, chaanerepua: —¿Achini iikai no'o chapimo o'raka nayewiame eemea? No'o u'yepamitiaopua piiripi toomi, no'o ne'nemichiopua pu'kao. ");
INSERT INTO var_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Waikako Eesusia u'yepatiapa pu'ka toomio, kaawe ne'nesaapa pu'kao toomichio, iinatukerepua pu'kao: —¿Aatanapu, ihji toomichi kahtiame nanariraa? ¿Aatana teewara iyotetiamepua i'ka toomichio? Waikao aapoeo chaachaparepua: —Aa puuua, apoepua Seresa, apoe te'ta yawichi —chaachaparepua aapoeo. ");
INSERT INTO var_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Waikao wa'a chaachapakopa pu'kao, chaanere Eesusia: —Wa'a teesoo te'ta yawichi iinuwarao, te'ta yawichikamera kiapuapua; nape Riosikamera iinuwarao, Riosikamera kiapuapua. Wa'a cheeka nehjiatiapao puuu Eesusieo: —¡Naakonakosa wa'a tiiaitepua, tísia inatamekaite puuua? —ahpo chaachapaka itipirepua. ");
INSERT INTO var_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Waikao Eesusi kahtiachio, saruseo ti'tijoepechi e'enarepua wa'ao. Puuu saruseo ti'tijoea, ki pichikiame enerepua, mukukai eenechi ahjaniameo. Pukaepa iinatukeriaipua Eesusio, eee chaachapakao: ");
INSERT INTO var_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","—Masitari, ehkoriami Riosi nayewatura Moisea, eee cheeriaipua ahpo Iyoterichio, aaata neewikame ki tatanatasa mukukameopua ahpo uupichio, puuu wa'api poonira neewimeri tuukamepua ahpo pa'chi uupira ahjamao, ahpo tatanatariaopua, ahpo pa'chitaru tatanara enemichiopua. ");
INSERT INTO var_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Nape neeea pu'kao wa'achitarichi aamo nayewemania. Puuu wa'achitaria eee teereriataipua: Oowisani tijoe eneriatai puuua, ahpo poponieme. Pahcha weeriamea neewiriataipua aaata oowitiame ahjamao, nape puuua ki tatanatasa mukuriatapua. ");
INSERT INTO var_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Waikao puuu wa'api neipa weeriamera ahpo pa'chi uupieria ahjama neewiriatapua, nape puuuai kihta tatanatasa mukuriatapua. Wa'achi iika mukuriata neipa weeriame pooniraai ahpo pa'chi uupira neewikameai. ");
INSERT INTO var_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Yooma puuu oowisani ahpo poponiemea, wa'achi iika wahjipariatapua, pu'ka oowitiame ahjama nenewikamea, aaataai ki tatanaeka. Wa'asi neipaoi te'ta pa'chira uupiraai, mukuriatapua tiame. ");
INSERT INTO var_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Wa'a ikikame enesaa yooma puuua, ¿aatanakamera te'ta kuunara enetarepu eenechi ahjarichio, yoomahka puuu oowisania ahpo poponieme, pu'ka oowitiame ahjama nenewikame enesoo, pa'chira tiame? ");
INSERT INTO var_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Waikao Eesusia pu'kao, cheeka nehjiarepua: —Aa eemea, tísia se'wi erakoamepua, kiisi pahtiapa ehkoriami iyoteri chiiao, kiisi machiyapa tiameo, te'ta Riosi utewarira ihsiao. ");
INSERT INTO var_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Wahjipakamea eenechi o'oijenasaapua ahjarichio, aaataai ki nenewika mochitomeripua, tewekachi mochikamechitia te'teriamekapa. ");
INSERT INTO var_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Eemea pu'ka wahjipakai oijenaniameo, kihta machiyamepua, Ehkoriami Iyoteri chiiamekoopua. ¿Kikosa iyonakame eeme pu'ka Ehkoriami Iyoterichi cheeria Moisetaruo, Riosie ahpo nayewetiameopua, kuhsi uuyari tajenarichi ahpo nayewetioiopua? Pu'ka uuyari tajenarichi o'iniao Riosia, eee chaanerepua Moiseo: “Neee Aurani Riosiwaraa, Ihsa Riosiwaraa, Aakowo Riosiwaraapua tiame.” ");
INSERT INTO var_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Wa'a cheekame enesoo Riosio, puuu paika Riosichi paparaka wahjipakameopua, Riosiwarako tuuriopao, wa'a teeresoo ahjaka mochitoamekaitepua pehjio, eenechi weerewa uumerikaitepua. Wa'a tiiachipa eemea, ki pichikiame enesaa eemea eenechi ahjaniameo, ki nu'uti se'wi erakoamepua. ");
INSERT INTO var_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Waikao piiripi puuu Moise nuurewa masitaria Eesusio, tísia peeneka nehjiachaniopa saruseo ti'tijoe iinatukeriao, Eesusichi eenakao iinatukerepua tiame, eee cheeka: —¿Achini tiiamerapu Riosi nuuraria, te'ta nateyamechitia tetewipuamea, te'ta e'waka nokisipuamea? ");
INSERT INTO var_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Eesusia nehjiarepua cheeka: —Aamo ehkoriami Moisea, eee cheeka nayewerepua ti'tijoerio: “Eeme isaeri ti'tijoe ooweru tiame wa'achitia, keepuka mochimitia eemea aamo Noono tewekachi kahtiameo, taamo Noono Riosia piiripi wa'apipua, ki'tepua wa'asi piirechia. ");
INSERT INTO var_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Te'pa kahtiame taamo Noono nuuraria, ihjipua te'ta yorapuamea: Aamoche Riosiwa nakika mochitopuapua, yomatiame aamo iikachi e'rae, yomatiame aamo inatarie, yomatiame aamo utewarie tiame.” Puuupua te'ta nokaka mochitopuamea nuurari. ");
INSERT INTO var_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Piirechi nuuraria tiame, ihjipua te'ta nateyameraa: “Kaawe e'reka yasimitiamua aamo piirechio, aamo wa'api aamo nakiyachitia.” Te'ta nuurari nokipuamea, ki'tepua wa'asi epeche nateyamea, pu'ka ookachitiao. ");
INSERT INTO var_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Waikaopu Moise nuurari masitaria, chaanerepua Eesusio: —Eje'e, kaawe chaanimua masitari. Pichiwajupu aamo chiiaa, pichiwa piiripi wa'apipu Riosia, ki'tiamepua wa'asi piirechio. ");
INSERT INTO var_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Riosikamera epeche nakika mochitoniamea, epeche te'ta nateyamepua, nape yomatiame ahpo iikae nakiniamepua, yomatiame ahpo inatarieopua tiame, yomatiame ahpo utewarieopua tiame, ahpo piirechioi ahpochitia nakiniameopua tiame. Yooma puuua epeche nateyamepua, ki animari Riosiwichio wahseka, oowewari kianiamechitia. ");
INSERT INTO var_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Waikao Eesusia Moise nuurari masitario, kaawe e'raka pichikeriopa ahpo pichiwari chiiao, chaanerepua pu'kao: —Ki se'wi tiiame muuuapa Riosi ye'karichio. Waikao tísia ye'kaka nehjiamekopua Eesusio ahpo iinatukeniao, ki aaata iinatukeme erakorepua pu'kao. ");
INSERT INTO var_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Eesusia i'isaeri tiopachi masitiaio, iinatukerepua ti'tijoerio, eee cheeka: —¿Aatia tiiachipa chaachapame iyoteri ti'tijoea, Raawitaruchi eenameko tuuka Riosie Weratiameo? ");
INSERT INTO var_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Raawitaru wa'apiai Riosi Riosiwarie erapatetiaopua, cheerepua: Apoe Riosi Paamiraa, eee chaanerepua ahpo Taana no'o Paamirao: “No'o ahjamina yasipamitia muuua, ahkasi aamo seepurawao, aamo taaratere no'o toapachisi.” ");
INSERT INTO var_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Eesusia wa'a Ehkoriami Raawi Iyoteria cheesaapua, iinatukerepua ti'tijoerio: —¿Achini iikai Raawitarua, ahpo paamira teewakame Riosie Weratiameo, tísia ahpo neipami naawakamekoipua pu'kao? Ti'tijoea ooweru tiamea muuwaeme, pu'sereka keepuame enerepua Eesusio. ");
INSERT INTO var_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Eesusia i'isaeri iyoteri ti'tijoe masitario, kiisi kaawe noonowirio tuunapua. Pukaepa eee chaanerepua ahpo masitia keepuameo: —Naane e'reka i'isaeri iyoteri ti'tijoe masitiao, puuua teteperuma wakirata pu'seriamekapu, kaawe yooreka ahpo tepotejeramepua, ahpo ihtoachi natepatiaapua. ");
INSERT INTO var_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Aapoeo ahpo napawikarichiopua tiameo, epeche yoorewa ti'tijoe mochipamiachi momochipamepua, epeche yoorewa ti'tijoe ko'komiachi momochipamepua. ");
INSERT INTO var_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Puuua kunamukukameopua tiameo, a'chikoi chaachapaka wihkueka kariwaraoi u'yamepua tiame, puuua ka'chi erakopuawichio ti'tijoerieo, tepekuma ni'okiamepua Riosi cheriwema ki'yakaopua, ahpo tísia kaawe yoratiamewichioopua kunamukukameeo. Nape puuua wa'a nokayaio, ki nu'uti kokosapuaitepua Riosieo. ");
INSERT INTO var_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Eesusia piire taawe ne'neka kahtioio. Riosiwichio toomi oowewari toaniachio, muuwaeme enapame teteware Eesusia wa'ao, ahpo Riosiwichio oowewa to'wiame. Ki ookapi we'weka tomiwaemea, we'weka to'eriaipua toomio. ");
INSERT INTO var_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Nape piiripi wa'a eenakame kunamukukamea, ki weeka toomiwamekapaopua, ookapi wa'api nu'nutira toomi to'erepua Riosi oowewario, kiisi weeka nateyame. ");
INSERT INTO var_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Waikao Eesusia ahpo ajawaria paaesapaopua, chaanerepua: —Pichiwa ihji oowitiame kunamukukamea, epeche oowewari ki'yakai tiiamepua Riosio, ki pu'ka wahjachi ki ookapi tomiwaemechitia, Riosiwichio nehjariachitia oowewario. ");
INSERT INTO var_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Yooma puuu tísia paarasatiamea toomi, ahpo soparawatiakamera ki'yamepua Riosi oowewarichioo, nape puuu kunamukukamea, ahpoche ko'komia ahjae tarimia iinuekaiopua, yooma Riosiwichio oowewariopua. ");
INSERT INTO var_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Eesusi i'isaeri tiopachi machenoio, piiripi Eesusi ajawaria chaanerepua: —¡Masitari! ¡Ne'neo, achipu kekechumapu tehte, achini keena ajakamepu raampakariai! ");
INSERT INTO var_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Eesusia nehjiarepua: —Eje'e, ¿kaawe tetewamemua pu'ka kaario, kai waapisi ajakamekoo? Nape puuua wa'a tiiaio, kiisi itipimerikaitepua piiripioi tehte, raampata maaniameo. Yooma wehchi yasipamiitepua wa'a tiiaio, piie taawechiamio. ");
INSERT INTO var_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Ooriwo Roomosachi ajasitioopua i'isaeri tiopa ma'chiachiopua, Eesusia yasiparepua. Wa'a yasipasoopua Eesusio, Peeroa, Aakowoa, Waania, Anteresia tiame, piineri iinatukerepua Eesusio, chaachapaka: ");
INSERT INTO var_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","—Teemea taamo tuuyejeramemua pu'ka i'isaeri tiopao, achinitio enemerikopua wehchi yasipamiachio, ihtana enemerikopua naania teerewa ikipuachio. ");
INSERT INTO var_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Eesusia nehjiarepua: —Eeme waika taawechi ohjoemea, aamo inateka mochitometepua, ki aawata aamo wihkuepuamichio pu'ka taawechiamio, ");
INSERT INTO var_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","muuwaeme e'enamerikaitepua chaachapame: “Neeeju Riosie Weratiamea.” Pu'ka chaachapaeo, ki ookapi ruhjimiitepua pu'ka wisikuewachio. ");
INSERT INTO var_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","’Eeme pu'ka taawechiami ohjoemea, ki nu'uti nasiwaniame inamuaio, ka'te te'ta majamitiapua pehjio, wa'a tiame inamuaiopua, ki kajuyachikai teetomapua pehjio. ");
INSERT INTO var_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Pirenapi weeechi ohjoemea, piire weeechi mochikamechi nasiwasimeripua ya'yawichi. Weeeai, ki muenati noonomeripua tiame, yoomatiame wehjoarichi, wa'a ikinioio tooretuniameai, ki teesa tiame teetomeripua. Nape yooma pu'ka wa'a tiiame teetoaiopua pehjio, pukeri o'ichari enemeripua, te'ta tísia kokosa aiwapuachio, pehjio. ");
INSERT INTO var_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","’Eeme pu'ka taawechiami noochi paparaka mochitoamea, kaawe aamo neesetoka mochitopapua; waika taawechiamio eemea, ya'yawichichi ijitopuamepua eemea; ahkaoipua i'isaeri napawikarichiamioi chapisa wepipuame eemea. Eemea te'ta weeweruma ya'yawichichi paaepuamepua noochi te'teriapa, wa'a iika no'o nehpupaka nayewameri eemea, te'ta ya'yawichi peereichio. ");
INSERT INTO var_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Pukaepa ihji Riosi kaaweruma tuuyewaria, ke'chu i'ka weee kajuyoio, yomatiame i'ka wehjoarichi nayewatupuamepua. ");
INSERT INTO var_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Eemea weruma ya'yawichichiami ijitotiaio itapiti iinatukemiao, wa'a weeweruma ya'yawichi peereichi ajakaio, ka'chi eramitia eemea aamo chaachapamiao, Riosia aamo eratiae chaachapameri eemea wa'ao, ki eemeche piineri nokimerikapa wa'ao, wa'achi ihsiamerikopua Riosiai, aamo ahjama ku'ika nayewakao. ");
INSERT INTO var_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Waika taawechiamio ahpo poponiemeai, ahpo poonioi nehjimeripua meripuawichio, noonoraai wa'achi iintomeripua tiame, ahpo tatana nehjakaopua ko'ipuamechio; aaata tatanaraai ahpo noono nehjimeripua tiame meripuaichio. ");
INSERT INTO var_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Yooma wehjoarichi mochikamea, noochi te'teriopa aamoo, nekamuchemeripua; nape wa'a te'tereniai ki se'wika noochi paparaka newitoka puuyakamea, te'ta kajuyachisio, Riosie newipatepuamepua. ");
INSERT INTO var_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","’Ehkoriami Riosi nayewatura Raanieria, wahka ihtoriachi ikipuame iyoteriaipua, itapiti tísia iinya tiiame yachapuamekopua i'isaeri tiopachi yooreminao, kiisi yachapuachi tiiame. Ehkoriami Raanieri tuuya iyonakamea, pu'ka taawechi pu'ka tísia iinya tiiame tetewapao, pahtemapua Raanieri cheeriao. Pahteka tetewamea pu'ka tísia iinya tiiameo, kaawichiami ujumamitiapua, yooma Uurea weeechiami mochikamea. ");
INSERT INTO var_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Aaata ahpo karijampa ihsiamea, ki tekisaa kaawe enemiipua ahpo itapitiwaoi ma'chipamiao; ");
INSERT INTO var_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","aaata wahka nokayameai ki e'enasaa kaawe enemiipua, ahpo petechioi ahpo wisasoriwa ma'chipamiao. ");
INSERT INTO var_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Pu'ka taawechi peteteka mochikame oowerua, ahpo tatana chiiteka mochikameaipua pehjio, ¡tísia tesiwa te'teremeripua! ");
INSERT INTO var_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Pukaepa pu'ka taawechiami noochi paparaka mochitoamea, Riosichi itaka mochitomitiapua, ki tuuroi enemichiopua wa'a ikipuameo. ");
INSERT INTO var_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Pu'ka taawechiami tísia aiwapuamea, ki nu'uti teeremeripua, ka'chitia taawechi tetewiniame, naayachi o'inia i'ka weee yachatiasichiopua, neipami ahkaoi wahka ihtoriachioi. ");
INSERT INTO var_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","I'ka tísia aiwario ki kahporatasoopua Riosio, apochi paparamewichioo, aaataai ki itipimeripua ahjakameo. Nape yooma apochi paparakameopua Riosia, ahpo tatana iintapariaopua, kahporatamapua pu'ka taawechiami tísia aiwaka mochitoao. ");
INSERT INTO var_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","’Waikami taawechiami aaata Riosichi paparamea aaatae ahpo chaanetiao: “Ne'neo, i'wa kahti Riosie Weratiamea”, wahjachikoieoi chaanetiaapua: “Ne'neo, waamikachi kahtipua”, ka'te pichikemitiapua pu'kao. ");
INSERT INTO var_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","E'enameripua weeka aaatao, Riosie Weratiameko tuuyame, nape wihtuka chaachapameripua. E'enameripua tiameo, pichiwaka Riosi nayewameka chaachapame, ahkasioi puuua tiameo, Riosi peenia ihsiwa nokisikao. Ahkasioi puuua Riosi ahpo tatana iintapariaoi, wihkuenaremapua; nape pu'kaopua wihkuenariaio, kiisi yuumpamapua, te'ta pewatiame mochitoamekopua Riosichio. ");
INSERT INTO var_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Neeea no'o ahjariao, i'ka wa'a ikipuame aamo tuuyenapua, te'ta nane'reka mochitomichiopua, wahka ihtoriachi ikipuameo. ");
INSERT INTO var_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","’Nape pu'ka taawechiami pu'ka aiwari u'matosoopa, taaaai tukapasipamapua, meechaai ahpo mechatajenao choipameripua. ");
INSERT INTO var_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","So'poriai tewekachi o'iniao, ki ookapi ruhjiame tetewipuamepua, ahkasi tewekachi ohjoemeai, tísia chachapia noonoimeripua majakao. ");
INSERT INTO var_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Waikao neee Tijoe Tijoetukamea, toomarichi eename tetewipuamepua tekika, ki teesa tiame tajitoka eename Riosi utewarieo, tahpitika tiame teetoka uutapari. ");
INSERT INTO var_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Waikao neee Tijoe Tijoetukamea tekisaopua, nuuremania no'o ku'iwario, yooma na'poamichiopua no'o poanatariaopua Riosiwichioo, yomatiame naomina i'ka weeechi mochikame, ahkasi i'ka wehjoarichi sihkochiamisioi mochikame. Wa'a ikisa tewekachi Riosie apechunatiameoipua wa'asio, yomatiame na'poanuremania pu'kaoi. ");
INSERT INTO var_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","’Eemea pepenipamitiapua i'kao, chuunachitia wa'achitarichi no'o aamo masitiao: Pu'ka oowarao rahtatiame uuyoiopua sawatakao, nane'riame teemea waikao, paamuni asiriamekopa wa'asi. ");
INSERT INTO var_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Wa'achitia i'ka a'chitiame simiyoiopua, taaa ikiyao, meechaoi, so'porioi tiame tutukapasipasoopa, no'o eenamechitiapa nane'reniame enemeripua, no'o Tijoe Tijoetukameo, aamo ta'pechi muirachi weeriamechitiaopua, erakopuamekoopua wa'asio. ");
INSERT INTO var_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Yooma ihji wa'a tiiame teetomeria, pichiwa wa'a teeremeripua kajuyachi taawechio, ke'chu wahjipoi waikami mochikame, tetewimerio. ");
INSERT INTO var_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Tewekaa weeea tiamea wahjipatarepua, nape ihji no'o chiiaa te'ta pichiwapua, kiisi wehchi wichika itipimeripua. ");
INSERT INTO var_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","’Nape pu'ka keenako ikimiao ihta taaweoio, ki aawata nane'riamepua pu'kao, Riosi ku'iwari tewekachi mochikameai, neeeai wehjoarichi ti'tijoechitiaoi kiisi nane'riamepua, apoche no'o Noono tewekachi kahtiamera, nane'riamepua pu'kao. ");
INSERT INTO var_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","’Wa'a tiachipa eemea, pusakameche mochitopuapua no'oche enamia inataka, ki nane'riapa achini keenako no'o enemiaopua. ");
INSERT INTO var_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Ihjia naatika tiiamepua, aaata tijoe teekora seenu weeechi akipakamechitia, ahpo tehkiwao ahpo tekipanatewa tooesaopua yoramichio, ahkasi ahpo eenachisi. Puuua ahpo ta'pechi yeetepawa tekipanatewaopua, chaanesa simirepua: “Ka'te kochika yasimitia muuua, eenechi eenaionia senawato enamiitenia.” ");
INSERT INTO var_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Wa'a tiachipa eemeai pu'kachitiao, ka'te kochika mochitomitia no'o enamiaopua, ki nane'riamekapa eemea, achini keenako no'o enamiao, seenekachioinia tukapasipooi enamaoinia, naasipa tukaooi seenekachio, seenekachi totori oowira kusuyooipua marikarowa, piarioiopua seenekachi. ");
INSERT INTO var_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Aamo inateka mochitopuapua, ki aamo kokochiame tewipuawichiopua, senawato no'o eenoiopua. ");
INSERT INTO var_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","I'ka no'o aamo chaania, yomachi weeechi mochikame chaaneka chiiamenia: ¡Ka'te natakia mochitomitia eemea, senawato no'o enamiao! ");
INSERT INTO var_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Ooka taawe toiriai Semejenato pahko enamiachiopua, paani ki rewaruraeme koi'wachio. I'isaeri tiopa ne'neseriosi te'ta pa'pamuratuameraa i'isaeri iyoteri ti'tijoea tiame, Eesusi achini yooraka ahpo chapimia i'yariaipua, wihkueka merimo o'rakapua pu'kao. ");
INSERT INTO var_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Nape ookapi puuua chaachaparepua: —Nape pahko simiyoiopua pehjio, ka'chi yoramete teemea pu'kao, ki tahpitika noonowemichiopua pahkochio. ");
INSERT INTO var_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Eesusia Wetania mochiwachi eenariaipua Siimoni ta'perachi, Reperaeme teewataniame tijoe ohjírachi. Eesusio meesa weeriachi kahtioio, wa'a eenarepua aaata oowitiame, piie riimeta pochikame tísia nateyame sewajuya makotoame, apoche narato tewaniamee netetiame sewajuya. Puuu oowitiamea pu'ka riimeta kuhtarachi kahponasaopua, Eesusi moochi to'werepua pu'ka riimetachi peeniajuwao. ");
INSERT INTO var_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Waikao wa'a iintokopao pu'kao, ookapi wa'a mochikamea, nekaweka tetewarepua pu'ka oowitiameo. Wa'a erakoapa puuua, ahpo chaachaparepua: —¿Achini iikai na'atame puuua tísia nateyame peeniajuwao? ");
INSERT INTO var_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","¿Nehjimetioipua pu'kao ohso kaawe, paika siento taawechi yowiwame kehkisi, pu'ka toomieo, tesiwa te'tiamera ku'ime teereriaipua? Wa'a chaachapaka na'areriaipua oowitiameo. ");
INSERT INTO var_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Nape Eesusia wa'a chaachapopa pu'kao, chaanerepua: —Ka'te na'ara chaachapa eemea i'ka oowitiameo; ¿achini iikai na'ara chaachapame ihji oowitiameo? Ihji oowitiamea kihta ki kaaweruma iintokamepua, ohsotia puuua, te'ta kaawerumara iintowa iintokamepua. ");
INSERT INTO var_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Aaata te'ta tooremuameo, senepi taawechi amochi iinuemeripua ku'ipuamewichioo, nape no'ooo, ki senepi taawechi amochi iinuemeripua. ");
INSERT INTO var_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ihji oowitiamea ahpo tesiwatia iinuekai i'ka peeniajuwao, no'o moochi to'wekamepua. Ihji oowitiame iintoriaa, ke'chu no'o mukuyoi, no'o weerewachi chuhchekamepua peeniajuwao, no'oo, peeniajutiame katewepuawichiopua teesotatiachio, wahjipame toaniachio. ");
INSERT INTO var_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Pichiwa aamo chaaniamenia i'kao, ihji oowitiamea i'ka noochi iintoriao, ahkaai i'ka wehjoarichi Riosi kaaweruma tuuyewari nayewatutiachio, i'ka oowitiame kaaweruma iintoria inatepaka mochitopuamepua. ");
INSERT INTO var_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Uurasi Ihkarióte tewaniamea, piiripi puuu oosa mariki aampa ooka ajawariaa, i'isaeri ne'neseriosi te'ta pa'pamuratuamechi simirepua, Eesusi noriwi nehjiwa ahjama nayewamia. ");
INSERT INTO var_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Waikao puuu i'isaeri tiopachi te'ta pa'pamuratuamea Uurasi chiia inamukapao, kaawe erakoka natetemo tuurepua natekarao. Waikao o'inia Uurasia, o'inerepua i'yasika achini iintoka ahpo nehjimia Eesusiopua. ");
INSERT INTO var_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Pahcha pukeri o'iniachi taawechi Semejenato pahkoo, ki rewaruraeme koi'wachio paanio, po'wa Riosi oowewariwichio meriwachiopua, Eesusi ajawariaa iinatukerepua Eesusio: —¿Akana aamo yorajeranimua, Semejenato pahko ko'kopuachio? ");
INSERT INTO var_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Waikao Eesusia ooka ahpo ajawaria uusaopua, chaanerepua: —Waami siimpamitia eemea muuwari mochiwachi. Wa'a tetewimeri eemea aaata tijoe sikorichi neeroi mahtotoame. Pu'ka na'naritopuapua, ahkasi ta'pechi pakiyachisi. ");
INSERT INTO var_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Wa'a ta'pechi pakiriachio, chaanemitiapua wa'a kariwaemeo, taamo Masitaria aamo iinatukenurekapua, akana yooreko yorapuamekopua, Semejenato pahko ko'kopuameo, ahpo ajawaria ahjama ko'komiachio. ");
INSERT INTO var_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Waikao apoe aamo ne'netemapua, akana yooreko aamo yoramia pu'ka kooameo, te'pa raampatakarichi yoorémina. Waikao wa'a yorapuapua pu'ka kooameo, taamo ko'komiao. ");
INSERT INTO var_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Waikao Eesusi ajawariaa, wa'a siimpasaapa wa'a muuwari mochiwachio, yooma ahpo chaaneretiachitia tetewarepua wa'ao. Wa'a yooremina yoorarepua waikao, pu'ka Semejenato pahkokoi koi'wao. ");
INSERT INTO var_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Waikao Eesusia tukapasipasoopua, wa'a eenarepua ko'komiao, ahpo oosa mariki aampa ooka ajawaria ahjamao. ");
INSERT INTO var_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Waikao Eesusia ahpo ajawaria ahjama mochinioiopua koi'rachiopua koakao, chaanerepua ahpo ajawariao: —Pichiwa aamo chaaneniame neeea, piiripi i'wa koayame no'o ahjamao, no'o toomichi noriwi nehjimerikopua. ");
INSERT INTO var_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Waikaopu ajawariaa, tísia yuuwesipakaopua, yoomahka pipiripi iinatukerepua Eesusio, chaachapaka: —¿Neeejoare Paamira? ");
INSERT INTO var_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Eesusia nehjiarepua: —Piiripi eemepua, i'wa mochikame no'o ahjame, oosa mariki aampa ookao, no'o ahjama pehtorichi ichuka koayame. ");
INSERT INTO var_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Ihji no'o Tijoe Tijoetukamechi iintopuamea, Ehkoriami Iyoterichi chiia iintopuamepua; nape ¡Ai puuu no'o noriwi nehjakamea, epeche kaawe eneriaipua ki naawasaa! ");
INSERT INTO var_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Wa'a cheeka Eesusia koaka mochinioio, piiripi paani uusa cheriyema kiasaopua ahpo tewekachi Noonoo, naasipasi chi'wanasa pu'ka paanio, chi'wapame ki'yarepua ahpo ajawariao, eee chaaneka: —Ihji paania no'o weerewapua. Ko'komitia eemea pu'kao. ");
INSERT INTO var_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Wa'a ikisaopua, paaso to'wame uusaopua tiameo, tewekachi ahpo Noono cheriyema kiasaopua tiameo, ahpo ajawaria iijinurerepua pu'kao, pu'ka paasochi maaniamepua. Waikao Eesusi ajawariaa, yooma ahka iijirepua pu'kao. ");
INSERT INTO var_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Wa'a ikisoopa ahpo ajawariao, chaanere Eesusia: —Puuu paasochi maaniame aamo iijiriaa, no'o eerapua, puuu eeraa Riosi ehkoriami mochiriame ahjama kateweria pichiwatamepua, no'o eera wi'sumiae pichiwataniame. Ihji eera no'o wi'sumiaa, ki ookapi tatakoririamewichio piipatepuamepua. ");
INSERT INTO var_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Ehpeo pichiwa chiiamenia, ki oosa no'o iijimerikopua, i'ka echijuwari neeroraopua, ahkasi no'o Noono ye'karichi no'o yasipaka ye'kachisi. Ahkasi waikamisi iijimerinia eenechio, i'ka echijuwari neerorao, weemera ye'karichi. ");
INSERT INTO var_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Neipao, aari koi'wame ko'kosaapua, Riosi wikatari wikatasaapa wa'asio, Ooriwo roomosachite e'enarepua E'semaní siimpakao. ");
INSERT INTO var_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Wa'a nokisiaio, chaanere Eesusia ahpo ajawariao: —Yooma eemea noochi paparamekaio, ehpe tukao wa'api no'o chapitioo, piineri no'o toaka ujumameripua, Ehkoriami Iyoterichio, eee chiiamekopa: “Me'rema neeea tepuyamerao, wa'a ikitiaapa po'wa tepuyaa, yooma chi'ripamapua.” ");
INSERT INTO var_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Meripuamenia me'yao, nape eenechi oijenamerinia; oijenasaapa neeea, Arirea ihsimania wa'a aamo e'enoio. ");
INSERT INTO var_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Waikao Peeroa wa'a chiiopa Eesusio, chaanerepua: —Pe'yachi wahjachi aamo ajawariaa, aamo piineri toita, nape neeea ka'i. ");
INSERT INTO var_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Nape wa'a chiiopa Peeroo, Eesusia chaanerepua: —Pichiwa aamo chaaniame neeea, i'ka wa'api tukaoo, ke'chu oosa kusuyoi totori oowirao, paisa simiyame no'o ka'itamiitemua, kiisi no'o machiyo tuuka. ");
INSERT INTO var_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Nape Peeroa utewaeme naawesakao, eenechi chaanerepua Eesusio: —Nape neeea ahkasioi meripuameaio, kiisi aamo ka'itamerinia. Waikao yooma Eesusi ajawariai, wa'achi chaachaparepua tiame. ");
INSERT INTO var_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Ehjepamio, E'semaní tewaniachi ajasirepua. Eesusia wa'a ajasitioopua, chaanerepua ahpo ajawariao: —I'wa no'o puuyemitia eemea ku'itapio, no'oo no'o Noonoma nayewachisi pehji. ");
INSERT INTO var_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Waikao Eesusia, wa'a toisapa ookapi ahpo ajawariao, Peeroche i'torepua, Aakowoo Waani tiame. Pu'ka yeeka simiyaiopua, tísia iiyana eraparepua. ");
INSERT INTO var_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Wa'a erapakaopua Eesusia, chaanerepua ahpo yeetoao: —Ki nu'uti tahpitika e'ramenia noochio, no'o iikachi yuuwesiwao, ahkasi mukime e'ramenia. I'wa itipimitia eeme ku'itapiopua pahchu, nape ki kokochika. ");
INSERT INTO var_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Waikao Eesusia, teesa wamichuri akiparepua ahpo Noono tewekachi kahtiame ahjama nayewamia. Wa'ao chopokorieka weripakao, ahpo Noonoo, ahpo aiwamia se'witepua itanerepua. ");
INSERT INTO var_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Pu'ka ahpo Noonochi itakao, eee cheerepua ahpo Noonoo: —Muuu no'o No'noo, kihta iinuame aamowichioo, ki kajuka iintome tiiao; pukaepa no'o se'wijeramenia i'ka tísia no'o aiwamiao, nape ki no'o e'rachitia iintoka, aamokamera e'rachitia ohso kaawe. ");
INSERT INTO var_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Ehjepao ahpo paika ajawaria toariachi enasaa, kokochiame tewarepu pu'kao. Eesusia wa'a te'teriopa pu'kao, yooma pusatesaopua pu'kao, chaanerepua Peeroo: —Siimoni, ¿kohchiame muuua? ¿Kiisi pusakame yasime e'ramemua ku'itapioi, ne'neka yasimitiooi? ");
INSERT INTO var_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Ne'neka mochimitia eemea Riosichi itakao, ki aamo eenechi ahsemichiopua aamo nahsinapari kochirewao. Aamo ki kochimeriko e'raio, aamo wa'api resipariwaa, aamo kochipatiamepua. ");
INSERT INTO var_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Waikao Eesusia, eenechi simisaapua ahpo Noono ahjama nayewamiao, eenechi simiterepua cheekao, pu'ka wa'api naewaka. ");
INSERT INTO var_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Eenechi enasaapua oosa simiyachi ahpo ajawaria ne'nemiao, eenechi kokochiame tewarepua pu'kao. Eesusia pusateniaio, kihta nehjiame erakorepua, tísia kochinariapa. ");
INSERT INTO var_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Ehjepa eenechi enasaa Eesusia paisa simiyachiopua, chaanerepua ahpo ihsiachi yeetoriao: —¿Iiweta resipuna eemea kokochika? Soparanipa wa'asi; ahseparupua wa'asi keenakoo, no'o Tijoe Tijoetukameo, nanaaramechi nehjipuachio. ");
INSERT INTO var_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","¡Yaapiti mochisisa! Nahpe waami wahja itipiriachi! Wahja itipiriachi asisaapa Eesusia chaanerepua pu'kao, yooma ahpo ajawariao: —Wa'atikia ihtoame tijoeapa, no'oo Tijoe Tijoetukameo, noriwi toomichi nehjakamea. ");
INSERT INTO var_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Wa'a chiioi Eesusiopa, wa'atikia ihtore Uurasiapa, Eesusi noriwi toomichi nehjakamea, piiripi puuu oosa mariki aampa ooka Eesusi ajawariaa. Ihjia, ki ookapi merimacheta makotoame, yeetoka eenariamepua, wahjachi puuua, kuuu ahjae wewepua makotoka e'enakamepua. Puuua te'te ne'neseriosi te'ta pa'pamuratuamee uhjuratiame enerepua, iyoteri ti'tijoee uhjuratiame tiame, wahjachi ti'tijoee uhjuratiame tiame, o'ochetiame pirenaturi tewaniamee. ");
INSERT INTO var_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Uurasia Eesusi toomichi nehjaio, cheekame eneriaipua: “Pu'ka aaata no'o chuchuyao, pu'ka chapisa i'topuapua, kaawe chapitoka, ki aamo neipumichiopua.” ");
INSERT INTO var_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Pukaepa puuua asisaapa, Eesusi naaepakao: —¡Masitari! —cheekao, chuchurepua. Waikao i'isaeri pa'pamiratuame soontarowaraa, Eesusikamera chapirepua. ");
INSERT INTO var_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Wa'a yooraka chapinioi Eesusio, i'topuawichioo, ");
INSERT INTO var_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","piiripi Eesusi ajawariaa, ahpo merimacheta ma'chipasa, nakachi meteka tehpunerepua, te'ta ne'neseriosi paamiratuameopua, ku'ira. ");
INSERT INTO var_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Waikao Eesusia chaanerepua ahpo chapiriameo: —¿Eemea nasimachetawaeka e'enakamepua, kuuu makoka tiame no'o chapimiao, eemea no'oo aaata ichikoameka yooramepua? ");
INSERT INTO var_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","¿Achini iikai ki no'o chapika eemea, no'oo i'isaeri tiopachi senepi taawechi no'o tetewaio, no'oo masiteka ihsioio? Aa, nape wa'a teetoame ihjia, Ehkoriami Iyoterichio wa'a chiiamekopa, wa'a ikikache itipimerikoopua. ");
INSERT INTO var_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Wa'a ikinioio yooma Eesusi ajawariaa, piineri toisa ujumarepua. ");
INSERT INTO var_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Piiripiche temari na'naritoriaipu, nape puuuai chapinareretiaipua tiame; ");
INSERT INTO var_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","nape puuuai wisasoriwarachi chapiniaopua, yasipaka newika poiyame u'marepua. ");
INSERT INTO var_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Waikao Eesusia, te'ta ne'neseriosi paamiratuamechi i'toretupua. Wa'ao yooma ne'neseriosi pa'pamiratuamea, o'ochetiame tewaniameapua tiame pirenaturi, wa'a ikisa iyoteri ti'tijoeapua tiame, wa'a weruma nanapawiwa nanapawiniachi napawirepua. ");
INSERT INTO var_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Peeroa mehka weritoka ne'netoka, na'naritosaapua, ahkasi te'ta neeseriosi ta'perachisi eenarepua, wa'a ta'pechio na'iretiopao, wa'a weriparepua tatapamiao, wa'a ta'pechi inatiame tatapachi. ");
INSERT INTO var_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Wa'a weruma napawitiachio, yooma i'isaeri pa'pamuratuame wa'a e'enakamea, yooma te'ta, Eesusi na'ara iintoria i'yeriaipua iinatukekao, nape itapiti merime teerewa; nape Eesusia kihta tewikeretupua, ihtaoi weruma na'ara iintoriao. ");
INSERT INTO var_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Aapoeo muuwaeme wihtuki Eesusi wenejiaio, ki napati wa'achi chaachapaka wenejirepua, aapoe wa'api ahpo nateparika nayewapapua. ");
INSERT INTO var_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Nape wahjachi wa'a e'nakamea tiamea, wihtuka wenejiriaipua Eesusio, eee chaachapakao: ");
INSERT INTO var_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","—Teemea i'ka tijoeo, inamukamepua chiiameo: “Neeea i'ka tiopa ti'tijoee netetiameo, nooe wa'api ru'minasa i'ka tiopao, paika taawechi werapamania eenechio” —wa'a chiiame inamukame teemea. ");
INSERT INTO var_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Nape wa'a chachapaipua wenejikao, ki napati wa'achi chachaparepua. ");
INSERT INTO var_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Waikaopu ne'neseriosi te'ta weruma paamiratuamea, werisika wa'a napawitiachi naasipao, iinatukerepua Eesusio: —¿Kihta nehjianimua aamo wenejiwao? ¿Ihtana chanimamua aamo nehpupakao? ");
INSERT INTO var_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Nape Eesusia wa'a chaaneniaio iinatukekao, kihta nehjiarepua, piiripioi naera. Waikaopu ne'neseriosi te'ta weruma paamiratuamea, eenechi iinatukerepua Eesusio, cheeka: —¿Muuupu te'ta Riosie Weratiamea, te'ta Riosi Kaaweruma Taanaraa? ");
INSERT INTO var_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Eesusia nehjiarepua: —Eje'e, neee puuua. Eemea wahka ihtoriachio, no'oo Tijoe Tijoetukameo, no'o Noono te'pa kahtiame Ki Teesa Utewaeme kahtiachi ahjama, ahjamina kahtiame no'o tetewimeripua, wa'a o'iniaopua tiameo, toomarichi weritoka no'o tekiyame tetewimeripua, i'ka weeechio. ");
INSERT INTO var_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Waikaopu ne'neseriosi te'ta weruma paamiratuamea nekakao, ahpo wisasoriwa panisuka si'panarepua, wa'a iintosaapua, chaanerepua wa'a napawikameo: —¿Ihtanawichio epeche wenejiwa nakitariapua? ");
INSERT INTO var_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Inamukame eemeapa, na'araka nayewamekopua Riosichio. ¿Ihtana chaachapame eemea pu'kao? Waikao yooma ahkao, meripo tuurepua Eesusio. ");
INSERT INTO var_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Waikaopu Eesusi chokichi ajakamea, o'inerepua Eesusi akachupeka. Wa'a nokisao, Eesusi puusira to'peka wewesao, chaachaparepua: —Ehsoo, ¿aatana ihsirupu aamo wewekao? —chaachaparepua na'arekao. Wa'a nokisaopua Eesusio, wa'a inatiame soontaroa, nanarichi wewesa ma'chiparepu iinatukeniachio. ");
INSERT INTO var_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Wa'a ikitioio Eesusio, Peeroa teere weririaipua pehji, napawitiachi ma'chi. Wa'aoi wa'a eenaka piiripi oowitiame neeseriosi ku'yamea, ");
INSERT INTO var_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","wa'a weeriame tetewapa Peeroo, na'isuwe tatapaka, puuua kaawe ne'nepaka Peeroo, chaanerepua: —Muuu tiamepua, Eesusi Nasare ohjoeme ahjama oiyamea. ");
INSERT INTO var_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Wa'a chaanetiapa Peeroa ka'itarepua cheeka: —Ka'i, kiisi machiyamenia pu'kao. Neeea aamo chiiao, ki nane'riamenia. Wa'a chaaneretiaapa Peeroa, ma'chi machenarepua waikao, wa'api wa'a ta'pechi muiwachio. Pu'ka wa'apichi kusuriame totori oowiraai. ");
INSERT INTO var_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Puuu wa'api oowitiamea wa'a ku'yamea, eenechi tetewapa Peeroo, chaanerepua wahjachi wa'ami ajakameo: —Ihji tijoeai, puuupua tiame Eesusi ahjama oiyamea. ");
INSERT INTO var_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Nape Peeroa, eenechi ka'itarepua, ki pichiwako tuukao. Waikao puuu ajakame tuuyetiamea, ehjepamio paisachi simiyachio, chaachaparepua Peeroo: —Pichiwa muuupua tiame, pu'ka tijoe chapitiame ahjama oiyamea, Arirea ohjoemechitia nayewámemua. ");
INSERT INTO var_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Waikao Peeroa, tísia utewaeme ahpo ka'itarepua, eee cheekao: —¡Kiisi machiyamenia pu'ka tijoeo, aamo chaachapao! ");
INSERT INTO var_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Wa'atiaiche, eenechi kusure totori oowiraa, paika simiyachiopua. Waikao Peeroa inateparepua, eee ahpo chaaneretia Eesusieo: “Ke'chu oosa kusuyoi totori oowirao, paisa no'o ka'itameri muuua, kiisi no'o machiyo tuukao.” Pu'ka wa'a ahpo wa'a chaaneretia inatepakapaopua Peeroa, nanararepua tísia yuuwesipaka. ");
INSERT INTO var_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Ma'chirepasoopa yooma ne'neseriosi pa'pamiratuamea iyoteri ti'tijoea tiame, o'ochetiame pirenaturia tewaniameapua tiame, wa'a ikisa yooma puuu te'ta weruma peereira pa'pamiratuameapua tiamea, Eesusi o'yesa i'tonurerepua Piiratochio. ");
INSERT INTO var_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Waikao Piiratoai wa'ao, iinatukerepua Eesusio: —¿Muuukosapu i'isaeri yawichia? —Wa'atepua, amoe wa'api wa'a chiiamepua —cheeka nehjiare Eesusia. ");
INSERT INTO var_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Waikao ne'neseriosi pa'pamiratuameo, weeka itapiti utewa chaachapopa wenejikao, ");
INSERT INTO var_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","iinatukerepua eenechio chaaneka: —¿Oowera kihta nehjianimua aamo wenejiwao, ki ookapi aamo wenejiniaio? ");
INSERT INTO var_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Nape Eesusia kihta nehjiarepua. Waikaopu Piiratoa: “Aatia wa'a tiiamejuarepua”, eraparepua Eesusio. ");
INSERT INTO var_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Piiratoa senepi pu'ka pahkokoio paamuachio, aaata na'sonatiame toayame eneriaipua aaata peeresoo, aatanakamera peereso ma'chi toinuraniame ti'tijoeeo. ");
INSERT INTO var_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Waika taawechiamio wa'a iinueniame eneriaipua piiripi peereso Warawasi tewaniame, wahjachi ahjama pirenatuka ti'tijoe ko'yame, puuua muuwaeka nasiwaniachi nasiwakame, ahpo yeetowa nasiwaniame ahjama. ");
INSERT INTO var_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Waikao muuwaria, Piirato senepi paamuparichi ijintoakamera yoranurarepua, aaata piiripi peereso ma'chipaka toiwame. ");
INSERT INTO var_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Waikao Piiratoa chaanerepua muuwario: —¿Aatanakamera nahki eemea toipuaichioo, i'ka i'isaeri Yawichiwara? ");
INSERT INTO var_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Wa'a cheere Piiratoa, nane'rejeretoapa pu'ka ne'neseriosi pa'pamiratuameo, ahpo paamiratuwa wa'inaka wenejiriopua Eesusio. ");
INSERT INTO var_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Nape ne'neseriosi te'ta pa'pamuratuamea yooma muuwari noonotekao, weeru chaachapaterepua, Warawasikamera itamichio puhjepuawichoo. ");
INSERT INTO var_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Waikao Piiratoa eenechi iinatukerepua cheekao: —¿Nape ihtana no'o yorajerani eemea waikao, i'ka i'isaeri Yawichiwarao? ");
INSERT INTO var_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Waikao muuwaeme wenejiameraa, chaachaparepua siinakokao: —¡Kurusichi merisáaa, kurusichi merisáaa! ");
INSERT INTO var_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Piiratoa chaanerepua waikao: —¿Ihtana na'ara iintokamesapua naajuo, ahkasi meripuawichiooo? Nape muuwaria simiterepua chaachapakao: —¡Kurusichi me'yáaa, kurusichi me'yáaa! ");
INSERT INTO var_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Waikao Piiratoa kaawe itipinariapa pu'ka muuwari ahjamao, Warawasikamera puhjerepua waikao. Waikao Piiratoa wepinurarepua Eesusio muuwari tetewachi, wa'a ikisao Eesusio, ahpo soontarowao, kurusichi merimia i'tonurerepua. ");
INSERT INTO var_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Waikaopu soontaroa, ke'chu kurusichi merimia i'tomiaio, yawichikarichi ta'perachi i'tosaapua Eesusio, wa'a napawinurarepua yomatiame soontarowa. ");
INSERT INTO var_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Wa'aopua Eesusio, sehtamurame mopowakira chuhchéretupua, wa'a ikisapapua moochio, wehcha mosokira netetiame yahcheretupua. ");
INSERT INTO var_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Wa'a yorasaapa na'arekao, chaachaparepua siinakoka: —¡Nee, ne'neopu isaeri Yawichio! ");
INSERT INTO var_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Wa'a chaachapakao, moochi weparepua kuhsie, akachupekao. Wa'a nokisaapa, chopokorieka aajapekao, na'arerepua ahpo yawichi teewaka. ");
INSERT INTO var_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Neipapa wa'a nokisapa na'arekao, puhjerepua wisasori sehtamurameo, waikao wa'a ikisaopua, wa'api pu'ka wisasorira chuhcherepua eenechi. Wa'asi wa'a nokisapao, ma'chiparepua waikao, kurusichi merimia i'tomiaopa. ");
INSERT INTO var_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Piiripi tijoe Siirene eenamea, Siimoni tewaniame eneriaipua. Ihji Siimoni tatanaraa, Arejantoro eneriaipua piiripia, piirea Ruujo tewaniame. Ihji Siimonia, wasachi tekipanai eenaka wa'ami u'matoio, utewa yoraretupua, Eesusi kurusi mahtotoa, ku'ika mahtotomichio. ");
INSERT INTO var_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Eesusia Ókota tewaniachi i'toretupua, Wahjipakame Mo'ojoa, cheeka chaniwame rieko naewaniachio. ");
INSERT INTO var_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Wa'ao Eesusio, wiino ooweretupua miira na'petiame, nape Eesusia ki nakirepua pu'kao. ");
INSERT INTO var_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Waikaopua Eesusio mukimichioo, kurusichi chucharetupua. Wa'a noonowisaa soontaroa Eesusi wisasoriwao, ahpo newitopua te'erepua Eesusi wisasoriwichioo, nane'renariapapua aaatakamera newitoka machenamerikopua Eesusi wisasorieo. ");
INSERT INTO var_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Pu'ka kurusichi chuchanioio, watani keenako enerepua. ");
INSERT INTO var_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Wa'a kurusichioiopua, itapiti iyoteri chuhcheretupua, eee chiiame: “I'isaeri Yawichira ihjia.” ");
INSERT INTO var_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Wa'a Eesusi meriwachio, ooka ichikoame ko'iretupua tiameo kurusichi chuhchakao, piiripi ahjamina, piirea owemina. ");
INSERT INTO var_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Ookapi ehkoriami Riosi iyotaperichio, i'ka eee tiiame ikipuame nayewakao, eee chiiamepua: “Ki ka'karuma ti'tijoechi tetewipuamepua.” ");
INSERT INTO var_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Wa'ami u'matopamea mo'rewakao, Eesusi na'arekao, chaachaparepua: —Ehso muuua, tiopa ru'minamo tuukamekai, paika taawechi weramo tuukamekai eenechio, ");
INSERT INTO var_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","¿achini iikai ki aamo Riosi utewarie tekika aamo newipanimua wa'a kurusichio? ");
INSERT INTO var_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Ne'neseriosi pa'pamiratuameai, wa'a ikisa iyoteri ti'tijoeai, wa'ami u'matopaio, na'arerepua tiame chaachapaka: —Kaawe newipaterepua wahjao, nape ahpo wa'apio ka'chi iika ahpo newipateme e'ramepua. ");
INSERT INTO var_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","¡Riosie Weratiame enesaa, apoe wa'api ahpo tekipumetepua kurusichio, wa'a iintosoopua pu'kao, pichiwa i'isaeri Yawichirako, erakopuawichiopua pu'kao! Wahjachi ookaa kurusichi chuchukuameaa tiame, na'ara chaachaparepua Eesusio. ");
INSERT INTO var_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Oowetawe enetoiopa, yomatiame weeechi tukapasiparepua, ahkasi paikachi keenakoosi. ");
INSERT INTO var_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Wa'a keenako teetoio Eesusia, weeru sisinakao chaacharepua: —Eloi, Eloi, ¿lama sabactani? —puuua cheeka cheerepua: No'o Riosiwa, no'o Riosiwa, ¿achini iikai piineri no'o toanimua? ");
INSERT INTO var_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Wahjachi wa'a mochikamea, wa'a chiiame inamukapaopua Eesusio, ahpo chaachaparepua: —Keepukao, ehkoriami Eeria paaechanipu, ehkoriami Riosi nayewatura. ");
INSERT INTO var_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Waikao piiripi puuu inamukamea, ikanati u'masika ikanati a'potiame uusaopua, wiino cho'koamechi saampatesaopua, kuhsichi chuchasa Eesusi ooweparepua wa'apote, pi'pimichio. Wa'a iintosaopua cheerepua ti'tijoerio: —Puuetariaopua pehjio, enamakoipu Eeriaa tekipumia. ");
INSERT INTO var_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Nape Eesusia weeru sisinakao, mukurepua wa'asi. ");
INSERT INTO var_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Pu'ka wa'apichioi, puuu wisasori te'ta i'isaeri tiopara iyoriwachi to'piamea, cha'rika si'parepua te'pasi o'inia teeresi. ");
INSERT INTO var_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Waikaopu rooma kapitaia, Eesusi tawemina weripakao, cheerepua: —Pichiwa Riosichi eename eneriai ihji tijoea. ");
INSERT INTO var_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Wahjachi ooweruai wa'achi ajariaipua mehka ajaka ne'neka. Puuu piiripia, Maaria Maarena tewaniame eneriaipua, piire Maariaa, Saantiao epeche nu'utira poonira yeeyera enerepua, puuua wa'api Maariaa, Oose yeeyera enerepua tiame, Sarome yeeyera tiame. ");
INSERT INTO var_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Ihji oowerua, Arirea o'inia Eesusi ahjama e'enariame enerepua, Arirea kahtioi Eesusio, tísia ku'ikame. Wa'a nokarepua tiame wahjachi weeka ooweruai, Eesusi na'naritoka e'enakame Eerusarenisio. ");
INSERT INTO var_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Semejenato pahkowichio kateweniachikoo, tukapasipachiopua wa'asio, pu'ka meereopua resipuniame taawechikoopua wa'asio, ");
INSERT INTO var_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Oose Arimatéa ohjoemea, naanaso eratoka Piiratochi eenakao, Eesusi weerewara itanerepua. Puuu Oosea Te'ta Weruma Pirenatuwa tewaniamechi piiripia, weruma yooreniamechitia tetewiniame eneriaipua. Puuua tiameo, Riosi ye'kari puuyetoka yasitoame eneriai puuua. ");
INSERT INTO var_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Nape Piiratoa Oosee itanetiapa Eesusi weerewarao, tahpitika eraparepua Eesusio, ikanati mukuriopa. Pukaepa paaerepua ahpo kapitaio, Eesusi pichiwa mukuria iinatukenariapa. ");
INSERT INTO var_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Waikao Piiratoa, pichiwa mukurio tuuyetiapa kapitaieo, reesiserepua Ooseo, Eesusi weerewara tekipusa i'tomichioo. ");
INSERT INTO var_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Waikao ihji Oosea wisasori tohsaname tarisapaopua, simirepua Eesusi weerewara tekipumia. Wa'a asisa tekipusa Eesusi weerewara ahpo ku'iwa ahjamao, pu'ka ahpo i'toria wisasori tohsanamechi ikapisaapua, wahjipame toaniachi i'tokaopua, yooremina teekarepua. Wa'a tekisaopua muirachio, weruma tehte rahpename chihturamee to'perepua. ");
INSERT INTO var_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Maaria Maarenaa, Maaria Oose yeeyeraa tiame, tetewakamepua pu'kao, Eesusi weerewara tekitiachio. ");
INSERT INTO var_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","U'matosoopa resipuniachi taawechio, Maaria Maarenaa, piirechi Maariaa Saantiao yeeyeraa, Sarome tewaniamea oowitiame tiame, peeniajuwa tararepua Eesusi weerewarachi chuhchemia. ");
INSERT INTO var_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Waikaopua pu'ka oowisari pahcha taawechio, Eesusi mukutekitiachi siimparepua pu'ka peeniajuwari chuhchemia. ");
INSERT INTO var_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Piari taaa machenoi wa'a siimpakao ahpo chaachapasiriaipua: —¿Aatana taamo wahjoneta Eesusi tekitiachi muirachio? ");
INSERT INTO var_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Nape ihji oowerua, ajasisaapa wa'a Eesusi mukukatewetiachio, tehte wa'a to'piameo, ikichatiame tewarepua. ");
INSERT INTO var_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","I'kao, wa'a muisoopua mukukatewechi yooremina ne'nemiao, wa'a yasarepua aaata Eesusi tekitiachi ahjamina, tepekuma tohsaname wakiraeme. ");
INSERT INTO var_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Puuu oowerua tísia majariaipua pu'ka tetewakao, nape puuu wa'a kahtiamea Eesusi tekitiachi ahjaminao, chaanerepua ooweruo: —Ka'te majakoo, eemea Eesusi Nasare ohjoeme i'yamepua kurusichi meritiame, nape puuua ki'tiamepua i'wao, oijenakame puuuapa wa'asi. ");
INSERT INTO var_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Wa'a cheesaapa Riosi ku'iwaria, chaanerepua tiameo: —Yaapiti nonoraka Eesusi ajawaria tuuyemitiapua, Peerokamera pahcha, pu'kao chaanepuapua: Eesusia Arirea ihsimeriko tuuyo, ke'chu ahpo ajawaria wa'a e'enoiopua, ke'chu meriwaio ahpo ajawaria chaaneriachitia. ");
INSERT INTO var_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Waikao oowerua, u'mapaka puuyarepua mukukatewerachio, ahpo sasaweka tísia majakame. Pukaepa aawata tuuyerepua pooechi u'mapasiaio. ");
INSERT INTO var_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Piiripi puuu u'masikamea Maaria Maarena enerepua, pu'kao Eesusio oowisani nanaarari puuyaneria weerewachio. ");
INSERT INTO var_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Puuu Maariaa piirechi ooka ooweru ahjamao, riisaka e'enarepua Eesusi ajawaria mochikachi, Riosi ku'iwaria ahpo chaaneria tuuyemia. Wa'a ajasisaapua, tísia yuuwesiame tewarepua Eesusi ajawariao, naarakoka mochikame. Waikaopua oowerua, chaachaparepua Eesusi ajawariao, eenechi oijenariame Eesusia, wa'a cheeka tuuyetiame teemea Riosi ku'iwarieo, Eesusi tekitiachi yasariameeo. ");
INSERT INTO var_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Nape ihji Eesusi ajawariaa, wa'a chaanetiaiopua oowerueo, kiisi pichiwako chaachapame tuurepua. ");
INSERT INTO var_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Neipatakiro Eesusia, ooka ahpo na'naritoamera machejenerepua pooechi nokisinioio, nape sewina tiiame weritopa, ki machiriapua Eesusio. ");
INSERT INTO var_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Nape waikachuriami machisaapua Eesusikoo, ikanati siimparepua Eesusi oosa mariki aampa piiripi ajawaria mochikachi, tuuyemia pu'kao. Nape puuu Eesusi ajawariaa, kiisi pichikerepua pichiwa tetewiko tuuyetiaipua. ");
INSERT INTO var_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Pu'kachi meeriamio Eesusia, senawato yooma pu'ka ahpo oosa mariki aampa piiripi ajawaria mochikachi machejenerepua, aaata ohjoewachi meesamina mochikoi. Eesusia wa'a machejenekao, te'yarepua ahpo ajawariaopua chaaneka: —¿Achini iikai ki pichikeka eemea, no'o oijenario tuuyetiaio? Tísia peewame eemea iikachio, kiisi pichikekapa eemea aamo tuuyetiameeo, aaata amochisi e'enakameeo. ");
INSERT INTO var_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Neipa wa'a chaanesapaopua Eesusia, ahjama ko'karepua. Ko'kosepasaopua, ke'chu machenaiopua wa'a ta'pechio, i'kao achini nokisimia kaawe tuuyerepua. Pu'kao eee chaanerepua: —Eemea ehpe o'iniao, yomachiami mochiwachiami siimpamitiapua, yooma ihta no'o iintoria nayewatumia, ihtana iintoriopua no'oo, yooma noochi paparakameo newipatepuawichioopua. ");
INSERT INTO var_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Kiisi pichikekamea i'ka tuuyewario, kokosapuame puuua, Riosi nekarewaeo. Nape pichikekamea i'ka noochi simiyame aamo nayewatiao, ahpo ki ka'karuma nokaya toaka, ahpo paatokameapua tiameo, no'oe newipatepuamepua Riosi nekarewachio. ");
INSERT INTO var_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Neeea aamo nayewatusiachio, aamo ahjama inisimeripua neeea no'o utewarie aamo ku'isikao. Pu'ka noochi paparasiameopua, ma'chiame tetewitesimania no'o utewario, aamo aaata noochi simiyame tuuyesiwachio. Puuu noochi paparakamea, i'ka naaniatiwari aamo nokisiame tetewimeripua: Ahkaoi aamo asikoachiamio, no'o teewae puuyachame ti'tijoechi muikame na'arari; ahkaoi aamo ajasisiachiopua, pu'ka seesenu nayewachi nayewame aamo inamumeripua. ");
INSERT INTO var_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Puuu noochi paparasiamea, amochi tetewimeripua tiameo, sekae chapikoi sayaweo, ki'kioiopua, ka'chi aamo ikiyame; itapiti yerowaeme aamo iijikoiopua, ki mukuyame; aaata kokoriamechi aamo seekarepasoopua, sautiame aamo tetewimeripua pu'kao. ");
INSERT INTO var_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","I'ka nayewesaapua, neipatakiri taawechiopua, apoe Paamira Eesusia, tewekachi ahpo Noonoe apechunaretupua, wa'asi. Wa'a akipasaapa puuua, ahpo Noonomina yasiparepua yawichitumiao. ");
INSERT INTO var_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Wa'a ikisoopua Eesusio, Eesusi ajawariaa, ahkaoi yomachi mochiwachiami puuyarepua, Riosi kaaweruma tuuyewari nayewatumiaopua, Eesusi iintorio tatakoriria cheriwepuawichiopua tuuyesikaopua. Waikao nayewatuka nokisinioio, ahkaoi Eesusichi simiyame nayewesinioiopua ti'tijoerio, Riosia pu'ka ahjama inisirepua ku'isikao, ma'chiame tetewitesikaopua ahpo utewario, ahpo ajawariachi tísia peenia ihsiwa ki maaenari inisikaopua, ahpoo, cheeriachitia. I'wasi kajuna ihji iyoteri chiiaa.");
INSERT INTO var_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Kúíraa, weruma teerewaeme Tiiojiroo. I'wa aamo nayewemane i'ka iyoterichio, muuwaeme ti'tijoee Riosi iintoria iyoteka mochitoriaopua, muuwaeme itapiti Riosi iintoriaopua i'ka weeechio, taamoo nane'reka mochitoapa pu'kao, yooma ti'tijoeri tetewachi ikitiame. ");
INSERT INTO var_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Ihji ti'tijoe pukeri o'inia iyotekamea, Eesusi Riosie Weratiamechi simiyame, taamowichio toowerepua yooma Eesusi iintoria iyotetiame, pukeri o'iniachisi Riosie Weratiamee ahpo tetewiteretia, yooma pukeri o'iniachisi ahpo nayeweretiaopua tiame pukae. ");
INSERT INTO var_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Wa'a tiiachipao neeeai, tehpe simitekapa i'yaeka i'ka ikitiameo, aamoo Tiiojiroo, weruma tiiamekopa aamoo, aamo iyotepamio orapakania waikao, nape ma'chiame chiiamepua i'kao, ");
INSERT INTO var_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","aamoo, nane'remichiopua i'ka Riosie Weratiamechio, yooma itapiti ikitiameopua, te'ta pichiwa wa'a tiiame ikitiamekoopua, aamo masiteriachitia. ");
INSERT INTO var_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Uurea weeechi te'ta yawichikoipua Eeroreo, wa'a yasariaipu piiripi tijoe neeseriosi, isaeri tiopachi neesetoame. Ihji tijoea Sakaria tewaniame eneriaipua, Aawiasi tewaniamechi pirenaturichi neeseriosi eneriaipua. Ihji Sakaria uupiraa, Eerisawe tewaniame eneriaipua, Aaronichi o'inia ti'tijoeturichi eename. ");
INSERT INTO var_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Ihji Sakariaa uupimao, na'pahka kaawe teteiwame enerepua Riosieo, kaaweruma teetoka mochitoamekapa, te'ta Riosi chiiachitia, Riosi yoorewao, ki se'wika mochitoapa. ");
INSERT INTO var_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Puuua, ki tatanaeme eneriaipua, pu'ka oowitiameopua ki tanayamekopa; oowitiamea, ya'watiame enerepua wa'asi, tijoeai oochetiame wa'asi. ");
INSERT INTO var_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Piire taaweo, Sakaria ahpo pirenaturi ne'neseriosichio, aaata pakimioiopua ti'tijoeriwichio iintomiaopua, iyoriwachio, ");
INSERT INTO var_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Sakariachi wichirepua pakimiao, te'ta iyoriwachi cho'i moorimiaopua Riosiwichioo. ");
INSERT INTO var_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Sakariao, yooremina ihsioio pu'ka cho'i moorekao, wa'api ma'chi itipikamea, Riosichi nayewarepua paparaka. ");
INSERT INTO var_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Wa'a yooremina ihsioiopua Sakariao, senawato wa'a weeriame tetewarepua Riosi ku'iwari, moorera chokichi weeriame ahjamina. ");
INSERT INTO var_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Sakariaa, wa'a weeriame tewakapa moorera ahjaminao, tajinachurepua, tísia majakapa pu'ka tijoeo. ");
INSERT INTO var_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Nape Riosi ku'iwaria chaanerepua pu'kao: —Ka'te mahja muuua. Neeea, Apoe Te'pa Kahtiamee uhjuratiamenia aamo tuuyemichioopua, aamo Riosichi itariaopua inamutiamekopapua wa'asi. Aamo uupia, taanaremerikatapua piiripi temarí, pu'ka temari aamo uupi taanaremerio, Waani tewamiatamua, wa'a aamo no'o chaanenurekapu Riosia. ");
INSERT INTO var_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Pu'ka kuita naawasoo tisiwa peenia erakomeri eemea, ahkasi wahjachiai wa'achitia erakomeripua. ");
INSERT INTO var_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Ihji kuita naawameria, ki oowera tijoe enemeripua Riosiwichioo. Kiisi iijiame enemeripua ihta utewaeme teekuchameoi. Ihji Waani tewapuamea, Riosi Riosiwari yahchame enemeripua, ke'chu naawaio, pukaepa itapiti yoorame enemeripua Riosiwichioo. ");
INSERT INTO var_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Puuua, muuwaeme isaeri ti'tijoerio, ahpo Paamira Riosichi e'enapumeripua, pukachi paparaka mochitomichiopua pu'kao. ");
INSERT INTO var_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Ihji Waania yooma ti'tijoerio, ehkoriami Eeriachitia Riosi utewarie nayewemeripua, Riosi Riosiwarie, ke'chu eenoiopua pu'ka Paamirao, ti'tijoeri masitemiaopua. Ihji Waania, ti'tijoeri weeweruma tiiarieme erakoniameo, nu'nunti tiiarieme erapaniamewichio nayewemeripua pu'kao, wa'a erapakaopua, yooreka tetewimichiopua pu'ka Paamira enameriopua masitemia. ");
INSERT INTO var_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Sakariaa chaanerepua Riosi ku'iwario: —¿Taanaetare teemea, no'o uupio ya'watuamekoi, neeeai oochetiamepua wa'asi? ");
INSERT INTO var_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Waikao, Riosi ku'iwaria chaanerepua: —Apoe Kaurieri neeea, Riosi kahtiachi o'inia eename. Amochi uhjuratiame neeea, i'ka peeniatiame tuuyepua, chaanemichio aamoo. ");
INSERT INTO var_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Nape ehpeo, ki ikanati pichikekapamua Riosi chiiao, ni'o itipimamua, ahkasi yooma ikiyachisi i'ka Riosi aamo chaaneriao. ");
INSERT INTO var_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","I'ka wa'a tiame ikiyoipua Sakariao Riosieo, ma'chi itipikame ti'tijoeria, yaapi erakoka puuyerepua: “¿Aatia ki machenaniare Sakariaa?”, chaachapaka. ");
INSERT INTO var_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Sakariao ahkasi machenasoopa iyoriwachio, nane'rerepua itapiti ikiriopua wa'a iyoriwachio, ki ijiyenopapua naewakao, sekaeche nayeopa pu'kao, itapiti tepoena eename tetewiriameko maaerepua. ");
INSERT INTO var_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Wa'a teekaopua, ahpo neeseriosi tehkiwa yorasao, no'rarepua ahpo ta'pechi. ");
INSERT INTO var_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Neipa i'kao, Sakaria uupira Eerisawe tewaniamea, petetereparepua waikao. Peteterepasaapa, ki ahka oirepua mariki meecha. Ahpo iikachio e'rarepua: ");
INSERT INTO var_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“I'ka no'o yoorare Te'pa Kahtiamea No'noa, ki suuwe eramichiopua no'oo, ki tatanatapao, apoe cheeria ihjia, noochi ikimia.” ");
INSERT INTO var_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Puhsani mechachiopua Riosia, eenechi uhjurarepua Kaurierio, nape ehpeo, Arirea weeechi, Nasare tewaniame mochiwachi. ");
INSERT INTO var_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Wa'a naewanurerepua oowitiame ahjama, Maaria tewaniame enerepua. Puuua ki neewiame eneriaipua pehjio, Oose ahjama neewimeri, ehkoriami Raawitaru tetejimarichi, naawakame. ");
INSERT INTO var_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Wa'a asisaapa Riosi ku'iwari Kaurieria, pu'ka oowitiameo, chaaneka teepoterepua: —¡Kúíra Maaria, Riosie kaawe yoratiameráa! ¡Aamo ahjama tiiame Riosía! ");
INSERT INTO var_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Riosi ku'iwarichio wa'a tiiame inamukapa Maariaa, tahpitika eraparepua, ki pahtekapa wa'a tiiame teepotario. ");
INSERT INTO var_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Nape Riosi ku'iwaria chaanerepua: —Ka'te a'chi e'ra Maariaa, kaaweruma iintomeri Riosia aamowichioo. ");
INSERT INTO var_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Ki maaeme tiiaiopua, peteterepameri muuua. Pu'ka temari naawasoopua, Eesúsi tewamerimua. ");
INSERT INTO var_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Puuua ki nu'uti enemeripua, ahkasioi puuua Te'ta Werumara Riosio, Taanara tewapuamepua, apoe Paamira Riosia, ki nu'uti ye'kari kiameripua pu'kao, ehkoriami Raawitaru teereriachitia ye'kari. ");
INSERT INTO var_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Yawichi enemeripua tiameo, yooma ahkasi Aakowo tetejimarisiwachisi ye'karisiwachi, ahkasi ki seenampachisi ki wahjiame; ihji kuita yawichituniamea, ki seenampasi enemeripua, ki wahjiamesi. ");
INSERT INTO var_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Maariaa iinatukerepua waikao: —¿Nape ihtana ikika wa'a teereta neeea, ki kuunaemekai, ki neewikameai neeea? ");
INSERT INTO var_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Nape Riosi ku'iwaria nehjiarepua: —Riosi Riosiwaria, amochi enameripua, Te'pa Kahtiameraai tewekachi, amochi yasipameripua. Pukaepa naawasaapa temaria, Riosika tiiame iinuemeripua, kihtaoi a'chi tiiame, Riosi Taanara tewapuamepua tiameo. ");
INSERT INTO var_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Aamo tejima Eerisaweai, kiisi maaepori tiiaio, taanaemeripua tiameo, piiripi temari. Puuua, ki tatanatameko tuuniameai, puhsani meecha i'tonapapua peteterekao. ");
INSERT INTO var_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Wa'a ikikame puuua, ki'tiopa Riosiwichioo, ki kajume tiameo. ");
INSERT INTO var_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Waikao Maariaa, chaanerepua: —Kaawepua. Riosi nuurewarachi kahtiame neeea. Wa'a erasaa Riosia, wa'a ikitemapua noochio, pu'ka aamo chiiao. Ikaechepa Riosi ku'iwaria, no'arepua waikao. ");
INSERT INTO var_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Pu'ka taawechiamio Maaria, yaapi Uurea weeechiami akiparepua, piiripi mochiwachi roomosachiami. ");
INSERT INTO var_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Wa'ami simikaopua, Sakaria ta'perachi eenarepua, wa'a asiyaio ta'pechio, teepotarepua Eerisaweo. ");
INSERT INTO var_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Eerisawea, wahka teepotame inamukapaopua Maariao, Eerisawe simaroraapua topachio, noonorepua. Pu'ka wa'apichi Riosi Riosiwariai, Eerisawechi eenarepua. ");
INSERT INTO var_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Wa'a iikapa puuua, ki nu'unti kaawe erapakao, chaacharepua: —Yomachi ooweruchio, muuukamerapua uutiameapua Riosieo, amochi naawakameo, ki nu'uti uupuamepua Riosieo. ");
INSERT INTO var_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Tísia kaawe iintoremua eenakao, tísia kaawe e'rame neeea aamo tetewapao. Cheriwema aamo eenariawichioopua, nape neeekamera enameriaipua aamo kahtiachio, aamokamera kaawe eratemiao. ");
INSERT INTO var_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Aamokamera kiameri tiiai neeea kaawe e'rewao, noochi kahtiame simaroo aamo teepotachanioopua, káitisia peenia erapaka noochi noonorioopua. ");
INSERT INTO var_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Tísia kaawe yoratiame muuua Riosieo, pichikekapa muuua aamo chaanenuretiao. ");
INSERT INTO var_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Wa'a chaanetiapa Maariaa, cheerepua: Noochio neeea, ki nu'utiko e'riamenia Paamirao, ");
INSERT INTO var_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","pukachi kaawe erapasiame neeea no'o iikachio, no'o Te'pa Kahtiamechi Paamira, no'oo newipatiamechi; ");
INSERT INTO var_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Riosio no'oo, oowera ki weruma tiiamekoipua yorakiame, noochi ne'nepakamepua, ahpo iintomeriopua noochi, ki aaatakoipua no'oo. Ehpe waanamio yooma ti'tijoetusiamea, Riosie noochi kaawe iintotia, chaachapaka mochitomapua, ");
INSERT INTO var_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","i'ka Riosi yomachi aampa utewariemeopua, ki nu'uti iintoriopa noochio. Tísia kaawerumakotinia pu'kao. ");
INSERT INTO var_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Apoe Riosia tesiwe e'riame aaatao, ahpo kaawe e'reka yooriameopua, ahjachi paparakao; pu'ka ahpo iyoriameo, cheriwiamepua pu'kao, ahkasi ihtori tijoetusiwachi. ");
INSERT INTO var_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Apoe Riosia ahpo ki nu'unti utewarieopua, yooma ahpo weruma erakoame noonowinariao, pihtuchamepua. ");
INSERT INTO var_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Ihji Riosia ya'yawichioio, puipamepua ahpo yasirachiopua, wa'a ikisaopua pu'ka yawichiwa yasirachio, ki ahpo weruma erakoamerakamera mochiwamepua, wa'a weruma ahpo erakoame yawichi yasirachiopua, weruma te'tereparichi apechunakaopua. ");
INSERT INTO var_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Cho'chorowa e'raka ahpo iikachi Riosichi enapameopua, kaawerukamera kiatiamepua Riosieo, cheriwiamepua pu'kao. Wahjachiopua, ki tesiwa erakoka enapameopua apochio, wa'atia no'rapuamepua pu'kao, kihta cheriwesa. ");
INSERT INTO var_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Apoe Riosia, ku'irepua i'isaeri ti'tijoerio, ahpo seekaerachitia te'teriameopua tiameo, ki natakepaka ahpo tesiwemiaopua. ");
INSERT INTO var_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Riosia, pu'ka iintomeri tuuriaipua taamo ehkoriamio, aaata newipatemeri uhjuramio tuukao, yooma Auranisi o'inia tetejimarisiwichioopua, ahkasi ki wahjiamesi. ");
INSERT INTO var_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Maariaa, paika meechahka yasisaa Eerisawe ta'perachio, eenechi no'arepua ahpo petechio. ");
INSERT INTO var_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Neipao Eerisawea, pu'ka kuita naawameri asisoopua, saurepua pu'ka kuitao, temari enerepua. ");
INSERT INTO var_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Waikaopua, Eerisawe tetejimara waapi mochikameraa, e'enarepua waikao, kaawe e'remiaopua sauriao, tísia kaawe yooratiamekopua pu'kao, apoe Paamiraeopua Riosio. ");
INSERT INTO var_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Osanao taawe i'toiopua kohjao, siichitepumia i'toretupua, teewara yahchepuawichioopua, tiopachi neeseriosieopua. Wa'a teewatanioiopua neeseriosia, Sakaria tewamo o'rariaipua, wa'a teewaekopa noonorao, ");
INSERT INTO var_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","nape yeeyeraa chaanerepua neeseriosio: —Ka'ipua, ihjia Waani tewapuamepua. ");
INSERT INTO var_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Wa'a chiiopa Eerisaweo, tetejimaraa chaachaparepua: —¿Nape aatia? Ki'te aaataai wa'a tewaniamea, taamo tetejimachio. ");
INSERT INTO var_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Waikao, sekae iinatukerepua noonorao, aachin tewapuamekoopua pu'kao. ");
INSERT INTO var_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Waikao noonoraa iyositasaopua iyotepuachio, wa'a iyoterepua teewarao, Waani tewapuameko tuuka. Wa'a ikisoopua pu'kao, ahpo ne'nepakaopua, “naakona”, chaachaparepua. ");
INSERT INTO var_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Pu'ka wa'apichi Sakariaai, iiyenarepua waikao naewasika. Wa'a ikisaapua, ki nu'uti cheriwema ki'yarepua Riosio, yooma Riosi iintoriawichioopua. ");
INSERT INTO var_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Waikao pu'ka wa'a ikitiameopua wa'ao kuitachi simiyameo, waapiami mochikamea, ki nu'uti erakorepua Riosichio, i'ka iintoriaopua. Ahkaoi mehka ohjoemeoi Uurea weeechi tuuyeretupua i'ka ikitiameo, ahka roomosachiami ohjoemeoi. ");
INSERT INTO var_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Yooma i'ka nane'rekamea aatia tiiao, ahpo chaachaparepua: —¿Ihtatia enemerijuare ihji kohja temaria? Wa'a erakore puuua, Apoe Paamira Riosio, weruma teereme tiiopa kuitachiopua. ");
INSERT INTO var_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Sakariaa, ki nu'unti erapaka Riosi Riosiwarieopua ahpo iikachio, chaacharepua: ");
INSERT INTO var_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","I'isaeri Paamirawa Riosio, ki nu'uti paparawa chanipuapua pu'kao, yooma ahpo mochiwachiamiopua ti'tijoeri, newipatemia eenariopa. ");
INSERT INTO var_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Apoe Riosia, taamowichio weerakamepua aaata, taamoo, taamo newipatemeri tuuyemichio; puuu newipatemeriaa, ehkoriami Raawitaru tetejimarichi eenamepua. ");
INSERT INTO var_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","I'ka newipatemeri nayewaka cheerepua ehkoriamio, uhjuramio tuukao, ahpo nayewaturachiopua, ti'tijoe. ");
INSERT INTO var_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Riosia taamo newipatemo tuuriaipua, taamo seepurawachio, taamo nekumiamechiopua tiameo. ");
INSERT INTO var_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","I'ka iintowachiopua ahpo cheeriao, taamo ehkoriami cheeriaopua, pichiwa iintokamepua; kiisi natakepakamepua ahpo katewerio, ");
INSERT INTO var_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","taamo ehkoriami Aurani ahjama kateweriao, ");
INSERT INTO var_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","taamo seepurawachio, na'sonamio tuuriaopua; wa'a iintosoopua pu'kao tamochio, kihta seeweka mochitopuawichiopua, Riosichewichio yorakesikaopua. ");
INSERT INTO var_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Wa'a teerekao Riosio, kakupachi nokisimeri teemea, taamo iikachio kihta a'chi tiiame ki kaaweruma inatatokao, ahkasi ki seena aampasi. ");
INSERT INTO var_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Muuua, no'o taanaai, Te'ta Riosi Werumarawichioo, nayewatura enemerimua; pahcha teetomerira pu'kao, katewesika pooeopua, ti'tijoeri iikachi, apoe enasoopua te'ta Paamira tewekachi o'inia enameriopua, kaawe e'raka uupuaichiopua. ");
INSERT INTO var_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","I'ka Paamirao naewameripua, tatakori cheriwemio tuuka, ti'tijoerio newipatemio tuuka, ");
INSERT INTO var_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","ahpo nakiyae tesiwe e'riaopua. Pu'ka Apoe Paamira enasoopua, weemera ma'chirepakameka teeremapua, weemera taajenakamechitia apochio, ");
INSERT INTO var_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","pu'ka te'ta tukapachi mochitoameopua, taajenamichiopua iikachio, apochi paparaka enapameopua, cheriweka, Riosichio ta'iria mochiwa teerepaka. ");
INSERT INTO var_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Puuu Waania simiterepua weripakao, epeche teetoka Riosichio, epeche teetokaopua paparaka. Ihjia, ke'chu o'iniaiopua, isaeri ti'tijoerichio nayewatukao, poanachi ohjoere puuuapu ki tijoeekachiopua pehjio. ");
INSERT INTO var_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Pu'ka taawechiamio, Aauhto tewaniame eneriaipua te'ta yawichi. Puuu iintokamepua yooma ti'tijoeri kehkiwa nane'repua teewara iyopunurakaopua, yomatiame ahpo ye'karichiopua. ");
INSERT INTO var_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Ihji ti'tijoeri kehkisa ihtetawa pukeri o'iniachio, Siirenio Siiria weeechi yawichikoi enerepua. ");
INSERT INTO var_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Pukaepa ti'tijoeria, yooma ahpo naawariachi e'enapuretupua, ahpo iyopumichiopua teewarao. ");
INSERT INTO var_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Oosea waikao machenarepua Nasare Arirea weeechio; wa'a o'iniao Uurea weeechite mooenarepua Weereni muuwarichi, Raawitaru tetejimarichi naawakamekapa. ");
INSERT INTO var_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Wa'a ahpo iyopure Oosea, Maaria ahpo uupi enemeri ahjamao, amori sauyamepa wa'asi. ");
INSERT INTO var_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Wa'ao Weereni nokioio, asire Maariaa ahpo saumiachio. ");
INSERT INTO var_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Wa'a saure Maariaa pahcha simiyame temariopua. Pu'ka naawasoopua, wisasorichi ikapisaapua, wakasi koi'rachi teekarepua. Ki karichi naawakame puuua, ki tewitiopa ahka che'repapuachio. ");
INSERT INTO var_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Waika tukaooi, wa'ami ahka che'repariaipua waapio, po'wa tepuyameaipua tiame. ");
INSERT INTO var_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Senawato wa'a weeriame tetewarepua eekachi, aaata tewekachi eename, Riosi ku'iwari. Waikao i'ka norikame che'repameo, ki nu'uti uutapatere Riosia, ahpo tísia peeniatiamee tisiwariopua. Pu'ka tetewakaopua, tísia majarepua. ");
INSERT INTO var_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Nape wa'a tiiopao Riosi ku'iwaria, chaanerepua: —Ka'te majako eemea. Kaaweruma aamo tuuyemia eenakamenia, yomatiame wehjoarichio ti'tijoeo ooweruopua tiameo, tisiwa peenia erakopuame. ");
INSERT INTO var_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Ehpe tukao Weereni mochiwarichio, wa'ao aamo newipatemeri naawakamepua, apoe Paamira Riosie Weerapuamea, wa'a Weerenio, Raawitaru mochiwarichi tewaniamepua tiame. ");
INSERT INTO var_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Eee tiame teima eemeapu pu'kao, wisasorichi ikapitiame enemapua, itapitichi kaanoachitia wakasi ko'irachi tekitiame. ");
INSERT INTO var_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Pu'ka wa'apichi wa'a eekachio, Riosi ku'iwari weeriachiopua, ki ookapi ajaparepua ahjama wahjachi Riosi ku'iwari. Puuua Riosi ka'karuma naewakao, chaachaparepua: ");
INSERT INTO var_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","Ki nu'uti peenia tiame naewariii, ki waapisi te'pa kahtiameoopuaaa, weeechi mochikame ti'tijoe ooweru tiameoo, tísia ta'iria mochiwari pu'kawichiooo, Riosi te'ta te'pa kahtiamee tesiwewaeooo. ");
INSERT INTO var_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Pu'ka tewekachi e'enameo nonorasoopua, po'wa tepuyamea chaachaparepua: —Siimpataria wa'a Weereni, wa'a ikitiameo Riosi taamo tuuyeria ne'nemia. ");
INSERT INTO var_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Wa'a chaachapasaapa, yaapi teetoka siimparepua wa'ao. Wa'a ajasisaapa puuua, kahtiame tewarepua Maariao, Ooseopua tiame. Kohjao, itapitichi kaanoachitia po'yame tewarepua, wakasi koi'rachi. ");
INSERT INTO var_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Waikao, wa'a po'yame tetewisaapua pukeri naawakame kohjao, yooma tuurepua Maariao, pu'ka tepoena e'nakame Riosi ku'iwari ahpo chaaneriaopua, pu'ka kohjachi simiyameo. ");
INSERT INTO var_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Waikao yooma wa'a inamukamea, tahpitika erapakaopua chaachaparepua: “¡Aa, naakónaa! ¡Itapiti ikipuamejuarepua naaju?” ");
INSERT INTO var_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Nape Maariaa yooma i'kao, senepi apochi inataka yasitorepua, i'ka ikipuameopua. ");
INSERT INTO var_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Puuu po'wa tepuyamea, poanachi nokisire puuuapu chaachapasika, kaawe naewasika Riosio, pu'ka itapitio ahpoo, chaaneretia, tetewaria tiame. ");
INSERT INTO var_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Osanao taawe i'toiopua kohjao, siichitepumia i'toretupua teewatemia. Ihji kohja temaria, Eesusi teewaretupua, Riosi ku'iwario wa'a cheeriopua Maariao, ke'chu peteterepoiopua pehjio. ");
INSERT INTO var_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Maaria ahsepatesoopua ahpo sauria piipatepuachi taaweo, Eerusareni siimparepua Eesusi temari i'tokaopua tiame, Riosichi tetewipumiapua, Moisetaru nuurari chiiachitia. ");
INSERT INTO var_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Wa'a noonoirepua, i'ka Riosi Iyoterichio eee chiiamekopa: “Yooma pahcha naawakame tehtemaria, Riosiwichio teewepuamepua.” ");
INSERT INTO var_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Yayawaraa Eesusio, ahpo tatakoririawichioopua, Moise yoranura yoorarepua, puuua chiia: “Ooka chonoporo oowemitia, ooka piichonioi.” ");
INSERT INTO var_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Waika taawechiamioi, Eerusareni yasariaipua piiripi tijoe, Siimeoni tewaniame. Ihji tijoea, tísia kaaweruma eneriaipua, tísia paparame Riosichiopua tiameo, Riosichio, isaeri ti'tijoeri newipatewa tísia puuyetoka yasitoame. Ihji Siimeoni Riosi Riosiwarieo, eratetiame eneriaipua, ");
INSERT INTO var_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","ki mukimerikopua pehjio, ki tetewaapua pehjio, Riosie Weratiameopua, tísia puuyeniameopua, yoomahka. ");
INSERT INTO var_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Ihji Siimeonia, Riosi eratewachi eenariaipua wa'ao, isaeri tiopachio. Wa'achi e'enariopua Eesusi yayawarao, Moise nuurari yoramiao, Siimeonia tetewarepua kuitao. ");
INSERT INTO var_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Wa'a ikisaopua, koomirepua kuitao, pu'ka koomikao, cheriwema ki'yakaopua Riosio, cheerepua: ");
INSERT INTO var_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Paamira, ehpeo muuua aamo cheeriao, iintokame muuuapa, Pu'ka aamo iintomia tetewikapao, ta'iria mukimerinia, ");
INSERT INTO var_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","aamo uhjuraria newipatemerio, tetewakapa. ");
INSERT INTO var_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Ihjia aamo iintoriaapua, aamo tetewachi iintotiamepua, yooma mochiwari tetewachi. ");
INSERT INTO var_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Ihji aamo weeechi enateriaa, yomachi weeechi mochikamewichio, tahjewaripua, yoomahka aamo inatariao, yoomahka pahtepuawichio, yooma isaeri ti'tijoeriopua, pu'kao te'ta kaawe tetewipuawichiopua. ");
INSERT INTO var_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Waikaopu kuita yeeyeraa noonoraapua tiame, tahpitika erapakaopua: “Naakónaa”, eraparepua. ");
INSERT INTO var_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Waikao Siimeónia, kaawerumari Riosie e'resaapua yayawarao, chaanerepua Maariao: —Ihji aamo kohja temaria, ki ookapi ti'tijoe ooweru tiamee, ki nakika tetewipuamepua. Puuu i'ka kohja weripaso wa'a teeka tetewikamea, ahpo Noono tewekachi kahtiamechi simiyame nayewatuka oioioo, kiisi kaawe te'teremeripua i'ka Noonora tewekachi kahtiamechio. Wa'a teeremiaipua, wahjachi ki ookapi ti'tijoea ooweruapua tiame, ka'karuma enepaka Riosichio, tísia kaawe te'terepakaopua Riosichio, tísia kaawe erakoka ahjachi paparamapua. ");
INSERT INTO var_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Ihjia nayewatuka oioi nane'repuamepua, ihtana erakoameko ti'tijoerio pukachio, kaawe erakowao ki kaawe erakowaoi. I'ka ti'tijoerieo kiisi kaawe e'reniamekopao, tísia yuuwesimeri muuua aamo iikachio, ahkasioi nasimachetae aamo iikachi otopuniamechitia. ");
INSERT INTO var_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Wa'api tiopachio, wa'a yasariaipua piiripi ooitiame, Aana tewaniame. Ihji oowitiamea, Riosi naewatura eneriaipua tiame, Aanueri maarara eneriaipua, Aasere tetejimari tetejimaeme. Yáá'watiame eneriaipua wa'asio. Pukeri weripai neewisaapua, oowisani paamupariche ohjoeriaipua kuunaekao, ");
INSERT INTO var_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","naao weerewa aampa oowisani paaumpari i'toriaipua. Waika o'inia tiopachi ohjoeme eneriaipua wa'ao, senepi wa'a ihsiame eneriaipua i'isaeri tioparachio, Riosichi naewaka ti'tijoeriwichio. Ki ku'itapisi weesa wa'a iijisia Riosi naewakao, chorowaio ki teewiame eneriaipua. ");
INSERT INTO var_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Siimeóni kajukoiopua nayewakao, wa'achi eenare Aanaai wa'ao, pu'ka tetewakaopua kuitao, cheriwema ki'yarepua Riosio, yooma inamuachiopua wa'ao. Waikao i'ka kuitachi simiyame nayewerepua yooma wa'a ahpo tetewaka wa'a tiopachi ajakameopua, pu'ka kuita koomika weeriáío. Waikao pu'ka nayewaria inamukamea, pu'ka kuita maaerepua ahpo newipatemerio, rooma soontarowarachi nasiwaka Eerusareni u'yekao, rooma yawichiwatere mochiteniameo, wa'a tiiame puuyeka mochitoamekapa puuua. ");
INSERT INTO var_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Oosea Maariaa tiame yooma yorasaapua Riosi nuurari chiiaopua, Nasare nonowarepua pe'ku, ahpo mochiwachi Arirea weeechi. ");
INSERT INTO var_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Wa'ao nu'uti temaria, epeche epecheche weruma weripatorepua, epeche epecheche peenewarieme enepatoka, epeche utewasipaka Riosieopua, ahpo neesetowachio. ");
INSERT INTO var_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Eesusi yayawaraa senepi paaumparichio, Eerusareni siisimpame eneriaipua pahkochio, Semejenato pahko tewaniamechi. ");
INSERT INTO var_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Eesusio, oosa mariki aampa ooka paamuoiopua, eenechi siimparepua Eerusarenio, senepi paaumparichi, siisimpaniachitia. ");
INSERT INTO var_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Nape yooma kajusoopa pahkoo, nonowanioipua eenechio, Eerusareni itipiriai Eesusia, ahpo yayawae ki nane'reka. ");
INSERT INTO var_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Yayawaraa, wa'a ihtoame maaerepua muuwarichio. Nape ahkasi piie taawe poorosimiai ki tetewapa pu'kao, i'yasirepua waikao, tetejimarichiopua, muuwari nokisiwachi. ");
INSERT INTO var_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Ki tewakapa wa'ao Eesusio, pe'ku e'enarepua Eerusareni, wa'a i'yamia. ");
INSERT INTO var_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Ahkasi paika taawechi neipa, tewarepua pu'kao, i'isaeri tioparachi yooremina kahtiame, masitaria ahjama naewaka, iinatukekaopua pu'kao, keepukaopua tiame. ");
INSERT INTO var_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Wa'a mochikame ma'masitarie iinatukeniaapua, tísia peeneka nehjiarepua. Wa'a chiiopua i'kao, ma'masitaria, tísia peenia e'raka inamurepua, tísia peeniopa. ");
INSERT INTO var_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Wa'a tewakapa yayawaraa, tahpitika eraparepua, wa'a tewakapa pu'kao, nu'utikaiopua pu'kao, tísia machiyame ahjama nayeopa. Waikao yeeyeraa, chaanerepua: —Eesusi, ¿achiníii wa'a iintoka muuua taamoo, ki tuuyesa taamoo? ¿Ki nane'riamemua taamoo, ki ahjame e'raka aamo i'yamekoo? ");
INSERT INTO var_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Wa'a chaachapopa ahpo yayawao, Eesusia chaanerepua: —¡Aa, wa'a erakoka no'o i'yamekosa eemea? ¿Ki nane'riamekosa eemea, no'o Noono kariwarachi itapiti no'o Noonowichio yoramerikoo? ");
INSERT INTO var_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Nape yayawaraa wa'a chiioi, ki pahterepua. ");
INSERT INTO var_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Wa'a o'inia ahpo yayawae Nasareniko i'totiaapua, Nasare e'enarepua ahpo ohjoewachi. Wa'a ohjoekai Eesusia, ahpo yayawa e'wewachi weripatorepua. Yooma wa'a ikiniameo, yeeyeraa, apoeche inataka yasitorepua. ");
INSERT INTO var_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Eesusia wa'a o'iniao, o'inerepua weripakao ahkasi tijoe werumachitia inatapakao, epeche muuwepasika Eesusi nakiyameo, tísia kaawe ahpo tetewiniame, ahpo Noono tewekachi kahtiameeoi. ");
INSERT INTO var_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Tiiwerio te'ta yawichio, oosa mariki aampa mariki paaumpari yomatiame Rooma weeechi yawichituka kahtioio, Poonsio Piiratoa, Uurea weeechi rooma ye'karichiopua, ki te'ta weruma yawichi eneriaipua. Eerore yawichia tiameo, Arirea weeechi ki te'ta yawichi eneriaipua, rooma te'ta ye'karichi yawichituwachio. Eerore poonira Eeripea, Iturea weeechi ki te'ta yawichi eneriaipua Tarakoni weeechiopua tiameo, rooma te'ta ye'karichi yawichituwachiopua. Riisiani ki te'ta yawichia, Awirinia weeechi yasariaipua yawichitukao, rooma te'ta ye'karichi yawichituwachio. ");
INSERT INTO var_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Pu'ka taawechiami Eerusarenio, Aanasia, Kaijaa tiame, i'isaeri tioparachi ne'neseriosio puuua, te'ta neeseriosi eneriaipua. Pu'ka taawechiamioi Riosia, Waani nayewerepua, Sakaria taanara, ki tijoeekachi yaajatoiopua pu'kao, ");
INSERT INTO var_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Riosia pu'kao, ahpo kaaweruma tuuyewari nayewatumichio uuriame enerepua, ti'tijoerio, toinuremichiopua ahpo ki ka'karuma nokayao, ahpo paatokaopua. Pukaepa Waania yooma ahpo ki ka'karuma nokaya toinariameo, yooma Oorani akichiko oirepua paatokao, i'ka ahpo tatakoriwa toinarekameopua ahpo paatokao, Riosie cheriwepuawichiopua tatakoririao. ");
INSERT INTO var_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Wa'a iintore Waania, ehkoriami cheeriachitia Isaia. Ihjia eee cheeriaipua: Wahka siinachani aaata tijoée, mehka ooruchi ki tijoeekachi. Puuua cheechaniamepua: “Kaaweruma pooe katewemitia aamo iikachio, Te'ta Apoe Paamirao amochi enamichiopua iikachio, Riosi Riosiwarirao. ");
INSERT INTO var_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Yooma aamo iikachi roomosameo, yepotapuapua; yooma aamo iikachi tekopameo, napatitapuapua; nohkorameo pooe aamo iikachio, riisatepuapuapua; motochipua tiiameopua aamo iikachio, ikichapuapua pu'kao, mehka ipaka. ");
INSERT INTO var_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Yooma wa'a iintokamea pu'kao, piipakame itipikamepua iikachio, papakotiame tatakorio, ki kokosapuamepua Riosieo.” ");
INSERT INTO var_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Pukaepa Waania, muuwaeme ahpo kahtiachi e'enarioiopua ti'tijoeri pa'pamiratuameo, ki ahpo iikachi piipanariai ahpo paatojeriopaopua pu'kao, chaanere puuua pu'kao: —¡Sa'sayawe ti'tijoeturipua, tisiwa wiwisituame! ¿Aatanae noochi e'enaka paatonuretiame eemea, aamo newipamichioopua Riosie kokosapuameo? ");
INSERT INTO var_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Toipuapua naaju aamo tatakoriao, waikaope, aamo paatomania. Nape ka'te tatakorika mochitomitiapua naajuo, ma'chiame aamo ka'karumache erapakame iikachio. Eemea Riosichio ki kaawe te'tiameaio, ka'te aamo te'ta piipakame maaemitiapua tatakorio: “Aurani tatanarakamera teemea” chaachapakao. Oowera wa'a chaachapame nakiyame enesaa Riosia, ahkasi i'ka tehteoi Aurani tatanara enepatemiipua. Te'ta pichiwari Aurani tatanaraa, ki ti'tijoerichitia naawaniamepua, puuua Riosie piipatewae Riosichi naawakamepua, yooma ahpo tatakori ihsiwao toariamekapa. ");
INSERT INTO var_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Aamo ne'nepuapua amochio, ki kaawe nokayame enesaa, wa'a weeri tepuraapa aamo ahjaeo, tehpunapuame. Yooma kuuu ki taakiameo, chokichi meteka tehpunapuamepua, wa'a yorasaapua na'ichi ipapuame. ");
INSERT INTO var_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Waikao wa'a chiiopa Waanio, muuwaeme ti'tijoeria, iinatukerepua Waanio, Paatomerao: —¿Ihtana yorata naajuo teemea? ");
INSERT INTO var_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Waania nehjiarepua: —Ooka iinuwaeme wakirao, aaata aamo piirechi kiapuapua piiripio; aaata eeme soparame iinuemea kooame, kipotepuapua aaata ki iinuemeo. Wa'a nokaka aamo ma'chitama eemea, aamo kaawerumachi erapariaopua iikachio. ");
INSERT INTO var_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Wahjachi ti'tijoe yawichiwichio koparoamea, Waani naaepakamea ahpo paatopuawichioo, iinatukerepua tiame: —Masitari, teemepe, ¿ihtana yorata teemea, Riosichi kaawe teerepuawichioo? ");
INSERT INTO var_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Waania chaanerepua pu'kao: —Toinaria eemea aamo ki ka'karuma nokiwao, ka'te u'matoka koparoamitia eemea, aaata wikiriekao. ");
INSERT INTO var_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Soontaroai naaepaka iinatukerepua: —Teemeape, ¿ihtana yorata teemea Riosichi kaawe teerepuawichoo? Pu'kao chaanerepua: —Ka'te u'yemitiapua aaataoi, kihta ki kaaweruma iintokoi utewachi koparoakao. Aamo natetewaeche kaawe erapuapua. ");
INSERT INTO var_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Yooma isaeri ti'tijoeria, Riosie Weratiame enameri puuyeka mochitoamekapaopua, ahpo rurumurakao chaachaparepua: “¿Ki ihji ohjoarepu Riosie Weratiamea, Riosi uhjuramo tuuria?” ");
INSERT INTO var_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Nape Waania inamukapa wa'a chaachapameo, chaanerepua yoomao: —Ka'i, ki puuu neeea. Neeea, neeroie paatoame neeea, nape piirechi no'o pukamina ihtoamea, Riosi Riosiwarie paatomeripua aamoo, te'ta piipari aamo yoorakaopua, o'ro na'ie kokoka piipatiamechitia. Neeea pu'kao, kakajoyaraoi ki na'sopume tiamenia. ");
INSERT INTO var_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Sekachi makotoame puuuapa charejicherao, ahpo ahjae kasarapumiaopua tiirikoo, wa'a iintosaopua ekasuaka mooapumiao. Wa'a iintosaapua pu'ka tiiriko kuhsira kasarao, na'ichi kosimapua, pu'ka na'io ka'chitia taawechi choipamechi, ki seena aampasi. Wa'a yorapuamepua, kiisi piipakameopua ahpo tatakoriwaopua apochio. Pu'ka tiiriko pahchira ka'karumaraopua, ahpo tiiriko oomawachi toamapua. Puuu tiiriko ka'karumaraa, ti'tijoeri puuua, tatakoriria Riosie piipatetiamera. ");
INSERT INTO var_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Waania utewa chaaneka uunurarepua, Riosi kaaweruma tuuyewariopua, ahpo tatakoririaopua cheriwepuawichioo. ");
INSERT INTO var_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Waania naewatuka oiyaiopua, kiisi kaawe iintorio tuurepua Eeroreo, rooma yawichiopua Eerusareni, pu'ka Eeroreo ahpo pooni uupira ahjama kahtiopa, Eroria tewaniame. Waania, muuwaeme tiame ki kaawe iintoria Eeroreo, teriwame nayewarepua. ");
INSERT INTO var_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Pukaepa Eerorea, perekarichi yahcharepua Waanio, epeche teerepakaopua, ahpo ki kaawe ihsiao. ");
INSERT INTO var_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Nape ke'chu peereso karichi yachanioiopua Waanio, Eesusia Waanie paatoretiamepua, piie taawe Waanio, ti'tijoeri paatoka ihsioiopua. Eesusia ahpo paatonioi ahpo Noonoma Te'pa Kahtiame naeyoio, wahjorepua te'pa tewekachio. ");
INSERT INTO var_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Wa'a te'pa o'iniao, Eesusichi tekirepua kooroka tiame, Riosi Riosiwaria. Pukachi yasipasoopua pu'kao, te'pa tewekachio te'teorepua, wa'a o'inia chaacharepua: —Muuua no'o Taanapua, no'oo te'ta no'o nakiya; amochio neeea, ta'iria yasitoame neeea. ");
INSERT INTO var_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Ihji Eesusia, ahpo Noono Riosi tehkiwa o'iniaio, piire weerewa aampa oosa mariki ahka paamuame eneriaipua. Eesusia, i'ka tetejimarisiwachi o'inia eenamepua: Eesusi noonoratewaa, Oose enerepua, ");
INSERT INTO var_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Oose noonoraa, Eeri enerepua, ihji waanamio te'ta teerekameraapua te'ta ojochira: Maata, Reewi, Mereki, Ajanai, Oose, ");
INSERT INTO var_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Matatia, Aamosi, Naaumi, Ehri, Naakai, ");
INSERT INTO var_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Maaati, Matatia, Siimei, Oose, Uura, ");
INSERT INTO var_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Ooana, Reejesa, Soorowawe, Saratieri, Neeri, ");
INSERT INTO var_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Mereki, Aariri, Koosami, Emorami, Eeere, ");
INSERT INTO var_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Osuwe, Erieseri, Oorimi, Maatati, ");
INSERT INTO var_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Reewi, Simeoni, Uura, Oose, Oonami, Eriakími, ");
INSERT INTO var_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Meerea, Meena, Maatata, Naatani, ");
INSERT INTO var_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Raawi, Isai, Oowere, Wooosi, Saramoni, Naasoni, ");
INSERT INTO var_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Aaminara, Aremini, Arini, Ehroni, Aaresi, Uura, ");
INSERT INTO var_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Aakowo, Ihsa, Aurani, Taare, Naakori, ");
INSERT INTO var_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Seeruku, Raakau, Peereku, Eewere, Saraa, ");
INSERT INTO var_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Kainani, Arajasa, Seemi, Nooe, Raameke, ");
INSERT INTO var_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Maatusareni, Eenoko, Aarete, Majareeri, Kainani, ");
INSERT INTO var_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Eenosi, Seeti, ahkasi ehkoriamisiopua, Aarani, Riosi tijoe neteria, ahpoka tiiame taana. ");
INSERT INTO var_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Eesusia pochikamepa Riosi Riosiwarieo, no'rarepua Oorani akichi o'iniao. Wa'a o'inia Riosi Riosiwaria, ");
INSERT INTO var_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","ki tijoeekachi i'torepua. Wa'ao riaorósia, iikachi noonoterepua Eesusio, ooka weerewa taawe wa'a ihsika, ne'nenariapa pu'kao aatia tiiamekopua ahpo iikachio, tísia ahpo Noonochi Riosi iyoriwaopua. Pu'ka ooka weerewa taawechio tísia choroware Eesusia, kiisi koaka oiriamekapa. ");
INSERT INTO var_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Wa'a tiiopa chorowakao, riaorósia, chaanerepua Eesusio: —Riosi Taanara enesaa muuua, ¿achinikai ki paani enepatena muuua i'ka tehté, ko'kotai? ");
INSERT INTO var_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Wa'a chiiopa riaorósio, Eesusia nehjiarepua: —Ehkoriami Riosi Iyoterichio chaanipua: “Ti'tijoeria Riosichio, ki paaniche koaka ahjameripua, Riosi chiiakamerache te'ta yooraka ahjatoniamepua.” ");
INSERT INTO var_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Waikao, te'pa apechunakaopua riaorósia, ikanati yomatiame ne'netesaopua i'ka weeechi ye'kari mochiwao, ");
INSERT INTO var_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","chaanerepua: —Néé, yomatiame i'ka ye'kari ki nu'uti mochiwari, aamo kiamania. Yooma ihjia, no'o iinuwapua, aaata no'o kianaria kiamania, kianaresaa. ");
INSERT INTO var_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Aamo no'o yawichiwatere enepasoo no'o chopokorieka weripekao, yomatiame no'o yawichituao, aamo iinuwa enepatemania. ");
INSERT INTO var_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Eesusia nehjiarepua pu'kao: —Ki yuumpamamu no'oo, Ehkoriami Iyoterichio chiiopa: “Aamoche Riosi paparapuapua, te'ta aamo Paamirache; pu'kache e'weka yasitopuapua.” ");
INSERT INTO var_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Wa'a o'iniao ehjepao riaorósia, Eerusareni u'parepua. Wa'a Eerusarenio, te'ta te'pa tiopachi mooenapurepua, wa'a moenapusapao chaanerepua: —Aamo ihpao i'wa. Riosi Taanara enesaa, ka'chi ikimamua; ");
INSERT INTO var_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Ehkoriami Iyoterichio chiiopa: Riosia uhjuramapua ahpo ku'iwario, aamoo neesetomichio. ");
INSERT INTO var_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Aapoeo puuua, aamo inatetomapua, ki tehtechi motochika wichipamichiopua. ");
INSERT INTO var_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Wa'a chiiopa riaorósio, Eesusia chaanerepua: —Nape Iyoterichio chaanipua tiame: “Ka'te oowera aatiata Riosio. Ka'te oowera aatiataka ne'nemo oramitiamua Riosi utewario.” ");
INSERT INTO var_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Riaorósia ki tewakapa ahjae aatiatapao, toarepua waikao, ahkasi piire taawechi yorame tiiachisi. ");
INSERT INTO var_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Eesusia, Arirea weeechi eenarepua eenechi, ahpo Noonoe weratiameopua Noonora Riosiwarie, i'ka weeechiopua, ahpo tehkiwa yoramia. Eesusia waikao, yomachi inamuretupua wa'a weeechio. ");
INSERT INTO var_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Ahka ahpo asiyachiamio, i'isaeri napawikarichiami masitioio, ti'tijoea oowerua tiame, kaawe e'reka tetewarepua pu'kao. ");
INSERT INTO var_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Wa'a teetoka asirepua, ahpo weripariachiopua Nasare. Wa'a asisaapua, napawikarichi pakirepua resipuniame taawechio, wa'a ihsiamekapa, ahkaoi ahpo asiyachiamio. Wa'a yooreminaopua, werisirepua Ehkoriami Iyoteri iyonamiao. ");
INSERT INTO var_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Eesusia werisisa weerioiopua, Isaia iyoteria kiaretu puuua, iyonamichioo. Waikaopua pu'ka iyotape wahjonaio, ahpo iyonamiachi i'yaiopua, i'ka chiiame iyonarepua: ");
INSERT INTO var_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Riosia, ahpo Riosiwarie no'o weerakamepua, tesiwa te'tiameopua Riosie cheriwepuao, tuuyemichiopua i'kao, ahpo ka'karuma tuuyewariopua. Neeea tatakorie chapitiameo, puhjewa naewamichio, uhjuratiamenia. Yooma pu'ka ki ma'chiame tetewaopua, Riosi iintonariaopua pu'kawichioo, ma'chitamia eenakamenia. Ka'chi ikime erakoameopua ahpo iintoriawichioo, cheriwemia eenakamenia, ta'iria mochiwamia. ");
INSERT INTO var_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Neeea weratiamepua tiameo, Riosi naewamichio te'ta paaumpari enamiachi, pu'ka enameri tuuyemichiopua ti'tijoerio. ");
INSERT INTO var_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Waikao iyonasaapa pu'ka Iyoterio, pi'rinarepua pu'kao, wa'a ikisaopua, wa'api ku'yame ki'yarepua eenechi. Wa'a ikisaopua, yasiparepua. Eesusi kahtioiopua, yooma wa'a mochikameapua napawikarichio, ki wahjiame ne'neka itipirepua. ");
INSERT INTO var_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Wa'a te'tioiopua pu'kao, waikao Eesusia eenechi werisikao chaanerepua: —Ihji Iyoterichi ehkoriami o'inia cheesitiamea, ehpe taawechi ikiyamepua, noochi simiyamekaitepua aamo tetewachi weeriame. ");
INSERT INTO var_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Wa'a chiiopa Eesusio, yoomahka kaaweruma nayewarepua pu'kao, Eesusio peeniatiame nayeopa. Aapoeopua ahpoo, chaachaparepua: —¡Naakona! ¡Ki Oose taanarapu ihji? ¡Puuukona enetapu Ehkoriami Iyoterichi chiiaa? ");
INSERT INTO var_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Waikao Eesusia cheerepua: —Eemea piie taawechiamio, chaachapameripua: “Muuua ki ookapi sautekameai, ¿achinikai ki newipani muuu aamo wa'apio tekika?” Ihta taawechi no'o chaanemeri eemea tiameo: “¿Achinikai iintoame muuua i'wa aamo mochiwachi wa'apio, aamo Kapenau iintoria taamo inamuria?” ");
INSERT INTO var_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Pu'kao Eesusia cheerepua waikao: —Pichiwa chiiamenia i'kao: Aaataai Riosi nayewaturaa, aaataeoi ki nakiwamepua ahpo wa'api mochiwachio. ");
INSERT INTO var_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Ka'chi iika wa'a iintomera i'wao, ehkoriami Eeria ikitiameka tiiopa i'wao, Eeria taawechiamio tísia tooretunioiopua paika paaumpari ki yukukopao, isaeri weeechio ki ookapi mochikoiopua kunamukukame tooremuame, ki wa'ao uhjuraretu Eeriaa ku'imichioo. ");
INSERT INTO var_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Saarepa mochiwachikamera uhjuraretupua seesenu weeechi, waapi Siironi weeechiami, wa'a ku'imichioo, piiripi kunamukukame wa'api. Isaeri mochikamea, wa'a yooraretupua, ki pichikeriopa Eeriao. ");
INSERT INTO var_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Eriseo taawechiamioi, ki ookapi repera kokoriame mochirioipua isaeri weeechio, ki sauteretupua piiripioipua wa'ao, Eriseoeo, naatiche sauteretupua piiripi, Naamani tewaniame, Siiria weeechi ohjoeme, seenu weeechi. ¿Ki wa'a yooraretupu ihjia, ki pichikeriapa? ");
INSERT INTO var_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Wa'a tiame inamukapa, yooma napawikarichi mochikamea, tísia nenekarepua, Eesusi ahjamao. ");
INSERT INTO var_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Waikao, tahpitika chaachapakaopua, chapisa ma'chiparepua wa'ao, ma'chi mochiwachi. Wa'api mochiwachi tekorata i'tore puuua, wa'a ipamia. ");
INSERT INTO var_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Nape Eesusia, ki naaniai iikao, naasipami u'matoka newirepua. Wa'a ikisaopua wa'ao, sewinami akiparepua wa'ao. ");
INSERT INTO var_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Wa'a newisaa Kapenau akiparepua, Arirea weeechi. Waikaopua wa'a masiterepua, resipuniame taawechi. ");
INSERT INTO var_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Ti'tijoeria tísia peenia e'raka keepurepua wa'ao, ki teesa peeneka nayeopa. ");
INSERT INTO var_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Wa'a napawikarichio, wa'a yasariaipua tijoe, reemoniwari yahchame, puuua Eesusi tetewapao, ki ku'ita sisinaka chaacharepua Eesusio: ");
INSERT INTO var_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","—¿Ihtana yoramia teetonamua tamochio Eesusi Nasare ohjoeme? ¿Taamo ko'imiakosa eename muuua? Neeea aamo machiyamepua aatanakoo, te'pa tewekachi o'inia tekikamekoo. Muuua, Te'ta Ki'tiamerapua Ihtaoi Ki Kaawerumao, ihtaoi Ka'chi Tiiamera, te'ta Riosichi eenámeramua. ");
INSERT INTO var_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Waikao Eesusia te'yarepua pu'ka reemonio, pukachi kahtiameo, pu'kao chaanerepua: —Ihchi yaasamua, yaapiti machenasa muuua, pu'ka tijoechio. Wa'a chaanetiapa riaorósi reemoniwaria, wichipaterepua pu'ka tijoeo, ahjachi machenakaopua weerewachio, ka'chi ikitekaopua tijoeo. ");
INSERT INTO var_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Wa'a ikitiame tetewapao, ki inata erakorepua, peenia erapakao. Wa'a te'tiapaopua chaachaparepua ahpoo: —¿Ihtana iikame ihji tijoea, tísia utewariemekopua ahpo chiiao, ki ka'karuma reemoniowarioi, yooreniame? ");
INSERT INTO var_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Ihji ikitiamea, yomachi wa'a mochiwachiamio, yomachi chaachaparetupua i'ka wa'a ikitiameo. ");
INSERT INTO var_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Eesusia napawikarichio, werisika machenarepu wa'ao, wa'a ikisaopua Siimoni ta'perachi eenarepua. Wa'aoi Siimoni waasirao tísia che'yopao, Eesusia tesiwa chaachaparetupua, yachapatemichio. ");
INSERT INTO var_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Waikao Eesusia kokoriame po'yachi chukipakao, te'yarepua che'erio. Waikaopu che'yamea, ikanati yachaparepua. Yachapasaapua, ikanati o'inerepua itapiti yoorakao, Eesusi ko'kotepuawichio, yooma wa'a mochikame tiame. ");
INSERT INTO var_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Ehjepamio taaa pakioio, ihta kokoriame ijinuemeai ahpo petechio, wa'a e'enarepua Eesusi u'yepakao, kokoriameo, yachapatemichiopua pu'kao. Waikao puuua, yooma pipiripichi seekarepakao, yachapaterepua pu'kao. ");
INSERT INTO var_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Reemoniwariai, muuwaeme puuyanaretupua tiameo. Reemoniwariai Eesusie puuyanachiaio, chaachaparepua siinakokao: —¡Aa Muuua, Riosi Taanaramua! Nape Eesusia wa'a chaachapopao, te'yarepua pu'kao, nane'riai chaachapopa pu'kao, ahpoo, Riosie Weratiamekoo, ki wa'a chaachapamichiopua pu'kao, reemoniwari ti'tijoeturio. ");
INSERT INTO var_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Ma'chirepasoopua, machenarepua wa'a mochiwachi muuwarichio, ki aaata ki'tiachi yasinariapa. Nape wa'aoi ti'tijoeria, tewarepua i'yasikao. Utewa yoorariaipua itipimichioo, ahpoche ahjama yasimichiopua. Ta'omapuaipua itipimichioo, ta'omamo orakoriai puuuapu ki ahka siimichio. ");
INSERT INTO var_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Nape Eesusia chaanerepua: —Ka'chi iika i'wache itipimerinia. Wahjachi mochiwachi siimerinia tiameo, i'ka kaaweruma Riosi tuuyeturi, tuuyemiao, pu'kawichio uhjuratiamekapania, no'o Noonoe te'pa kahtiameeo. ");
INSERT INTO var_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Eesusia wa'a inisika nayewatusirepua, yomachi Arireami i'isaeri napawikarichiopua, wa'a ikisirepua tiame, Uurea weeechiamioi. ");
INSERT INTO var_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Seenepi simikame Eesusi Eenesare pa'wesuwe ihsioiopua masitekao, tahchiame weririai muuwaeme ti'tijoeria, Eesusi keepunaria, Riosichi simiyame naawesari. ");
INSERT INTO var_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Wa'a tiiopa Eesusia, ooka pawekakera tetewapa neerosuwe chuchukuameo, piiripi puuu tetekorao, tetekiriopa ahpo sochichaira papakomia, ");
INSERT INTO var_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","wa'a mooenare Eesusia waikao. Puuu pawekakera aaata Siimoni tewaniame enerepua. Wa'a mooenasaapua chaanerepua Siimonio, pu'ka pawekakerao, epeche mekapi neerochi chuchapamichiopua. Wa'a ikitioopua Eesusia, wa'a o'inia yasaka masiterepua ti'tijoerio. ");
INSERT INTO var_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Eesusia, ti'tijoeri masiteka kajusaapa, chaanerepua Siimonio: —Epeche waanami chuchapamitia i'ka pawekakerao. Wa'a ipasemitiamua pu'ka aamo sochichairao, wa'aope chapitai so'chi. ");
INSERT INTO var_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Nape Siimonia nehjiarepua Eesusio: —¿Wa'á? ¿Ki wa'a nokakame teeme yooma tukawari wa'ami ihpapaseka sochichaerao, oowera kihta chapikao? Nape aamo wa'a chiioopao, wa'a ipasemane. ");
INSERT INTO var_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Waikao wa'a ipasesoopua sochichairao, ki ookapi chapirepua so'chí. Waikao panisuka ma'chipanioiopua pawekakerachi moenapukaopua sochichairao, ahkasi tehpume teetorepua, ki ookapi chaiteriamekapapua so'chio. ");
INSERT INTO var_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Wa'a teetopua sochichairao, wahjachi pirenachi pawekakerachi nokayame sisinamurepua, wa'a e'enaka ahpo ku'imichio pu'kao. Wa'a e'enasaopua ku'imiao, ooka pawekakera pochiwarepua, ahkasi chuurame pochikame, ahkasi piwiteme tiiamesi. ");
INSERT INTO var_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Waikao Siimoni Peeroa, wa'a ikitiame tetewapao, tawemina chokoporieka weripakaopua, chaanerepua Eesusio: —Paamiraa, aamo poanatujeraninia noochio, kiisi no'o ne'neme tiiamenia aamoeo, tísia tatakoriekapania noochio. ");
INSERT INTO var_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Wa'a cheere Siimoni Peeroa, ki nu'uti iyoriwapakapapua Eesusio, tahpitika erapakaopua tiameo, pu'ka ki nu'uti ki maaepori iintoriopua Eesusio, ki ookapi so'chi puuyanateka. ");
INSERT INTO var_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Wahjachi Siimoni ahjama nokayameai, tahpitika erakorepua tiame iyoriwa Eesusichio, Saantiaoa, Waania tiame, puuua na'pa Sewereo tatanara. Wa'a te'teriopao Eesusia, chaanerepua Siimonio: —Ka'te te'ta no'o peenia erapamua, i'ka so'chi no'o aamo chapiteriao, neeea ehpe waanamio aamoo, ti'tijoeri Riosichi aamo e'enapatiame enepatemerikopua, Riosiwichio po'wachuamechitia ti'tijoeopua ooweruopua tiame wa'achitia. ");
INSERT INTO var_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Waikao puuua, wa'a nokayaipua so'chi chapika, wa'api toisa ahpo pawekakerao, toare puuua ahpo sochiero eneniameo. Wa'a ikisaopua, yooma ahpo iinueka toisaopua tiameo, Eesusi ahjama nokisirepua waikao, ahjama tekipanasikao. ");
INSERT INTO var_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Piire taawechio, Eesusi piie mochiwachi ihsioio, wa'a eenarepua piiripi tijoe, repera kokoriame. Puuua wehchisi koomorasipakao, tesiwa cheerepua Eesusio: —Paamira, nane'renania aamoo, no'o tesiwe e'resoo, no'oo yachapatemerikopua. ");
INSERT INTO var_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Wa'a chiiopua Eesusia, ahjachi seekarepakaopua, chaanerepua: —Eje'é, wa'a aamo e'riame neeea. Yachapakame itipisa naajú. Wa'a cheesoche Eesusio, yachapakame itipirepua, ahpo repera kokoriao. Te'ta saukame itipirepua wa'asi, pu'ka kokoriao, kiisi naania ikiteka wa'asi. ");
INSERT INTO var_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Sautesaapa Eesusia, chaanerepua pu'kao: —Muuua, ka'te aaata tuumitia, i'ka no'o aamo sauteriao, ohso kaawe i'isaeri tioparachi siimitiamua i'yetokao, wa'a neeseriosio kiamia, pu'ka Moise nuurari chiia kianurawao, pu'ka Riosiwichio oowewario. Pu'ka kiariwa oowewaeo, yooma nane'remichiopua aamoo, yachapakamekoopua aamoopua wa'asi. ");
INSERT INTO var_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Nape Eesusio ki mehtajerioipua ahpo iintoriao, ahkaoi yomachiami mehtarepua. Pukaepa Eesusi ahkaoi asiyoio, muuwaeme e'enaparepua keepumiao, ahpo kokoriame i'yetokaopua Eesusio, sautemichiopua pu'kao. ");
INSERT INTO var_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Nape Eesusia tísia resipakapa sautiaio, poanachi siisimiriaipua ooruchi, ahpo Noono tewekachi kahtiame ahjama nayewámia, resipunariaapua tiameopua ku'itapioi. ");
INSERT INTO var_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Piie taawechi masiteka ihsioi Eesusio, parisero ti'tijoeai wa'ami ahka mochiparepua keepumia, ookapi Moise nuurari ma'masitari tiame. Ihji ti'tijoea, Eesusi ihsia ne'nemia e'nariamepua, Riosi utewarie ihsia. Puuu yomachi e'enakame enerepua: Arirea weeechi, Uurea weeechi, wa'a ikisa Eerusareni muuwarichi o'inia e'enakame tiame. ");
INSERT INTO var_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Wa'achi e'enarepua tiameo, tu'ikame u'pakame, e'taparachi tekitoka. Muinareriai puuua Eesusi kahtichio, ");
INSERT INTO var_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","nape ki ahka pakime tiiopa muuwaekapao. Ihjia wa'a karichio, yomachi i'yai ki tewakapa pachapuachio, te'pa mo'moenaka wahjonerepua, karijampara wehchorieme netetiameo. Wa'atipo wahjonasaapua, pu'ka tu'ikameo, wa'atipo tekipurepua e'taparachio, te'ta Eesusi kahtiachio. ");
INSERT INTO var_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Waikao Eesusia pu'ka u'pariao, ki nu'unti apochi paparariopao, chaanerepua kokoriameo: —Saukame itipiame muuuapa, aamo tatakoriria cheriwetiame. ");
INSERT INTO var_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Wa'a cheekopa Eesusio, Parisero ti'tijoea, nuurari ma'masitariaapua tiame, erakorepua: “¿Ihtana iikame ihjia chiia? ¿Ki ahpo Riosiko tuunapu? Riosiche puuua wa'a iintomeria, tatakori cheriwemeria, wa'asi waanamiopua, aaataai ka'i.” ");
INSERT INTO var_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Eesusia nane'riapa erakoao, chaanerepua: —¿Achinikai wa'a erakona eemea, ki tatakori no'o cheriwemia iinuekoo, maaeka? ");
INSERT INTO var_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Ehsoo, ¿ihtanakamera epeche tehkijuarepua ne'netewao, tatakori cheriweniame, yachapakame werisiteniamekosaoi i'ka tu'ikameo? Oowera wa'a chaniwamea ki tetewitekao, ki tehki tiiame puuua. Te'ta tehki tiiamea, te'ta iintoka ikiteka, ne'neteniamepua. ");
INSERT INTO var_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Pukaepa neee Tijoe Tijoetukamea, iinuekapa neeea no'o tatakori cheriwemiao, iintomania. Wa'a cheesaa chaanerepua tu'ikameo: —¡Yachapakame werisísaa, aamo chaanenane tu'ikameoo! ¡Apechunasa ipetáa, no'rasa petechíí! ");
INSERT INTO var_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Waikao kokoriamea yooma tetewachi werisikao, ikanati apechunasa ahpo ipetao, no'rarepua ahpo petechi, pooechio, cheriwema kiasika Riosio, ahpo yachapariawichioo. ");
INSERT INTO var_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Waikao yooma wa'a mochikamea, ki nu'uti tiiame tetewikapa Eesusichio, tahpitika eraparepua apochio, káátisia, peenia iintoriopua Eesusio. Wa'a iikapa puuua, tísia kaawe nayewarepua Riosio. Puuua chaachaparepua ahpoo: —Ki teesa tiiame, tetewakame teemea ehpe taawechio. I'ka taamo tetewariao, ka'chitia taawechi tetewikamekai teemea. ");
INSERT INTO var_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Ehjepao wa'a ta'pechi machenasaapa Eesusia, Maateo tewaniame tijoe tetewarepua, Rooma yawichiwichio koparoame, ahpo yooremina koparowachi kahtiame. Wa'a kahtiame tetewaopua, chaanerepua pu'kao: —Nahpé, no'o ahjáma. ");
INSERT INTO var_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Waikao Maateoa, yooma wa'api toisaopua, na'naritorepua Eesusio. ");
INSERT INTO var_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Ehjepao Maateoa ahpo ta'pechio, weruma pahkotarepua Eesusiwichioo, weruma koi'wari yooreka. Wa'ao wahjachi e'enarepua tiame, rooma yawichiwichio koparoame, wahjachi tiame oowera ti'tijoeri. Yooma wa'a mochirepua meesa chokichi. ");
INSERT INTO var_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Pukaepa parisero ti'tijoea, iyoteri ti'tijoeapua tiame, wa'a oi'inia ki kaawe chaachapasirepua, Eesusi te'ta yeeka oiya masiterao. Pukaepa piie taaweo, Eesusi ahpo yeeka oiya masitioio, pa'parisero ti'tijoea i'iyoteri ti'tijoea tiame, na'ara chaachapariaipua Eesusi yeeka oiyao. Puuua eee chaachapariaipua pu'kao: —¿Achinikai eemea yawichi koparoame ahjama koayamepua, wahjachi tatakoriame ahjama tiame? ");
INSERT INTO var_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Eesusia, wa'a chaachapame inamukapao, chaanerepua pu'kao: —¿Ki kokoriamea sauteniamekosa nakiyamepua? ¿Ki kokoriamekosapu te'ta ahpo sautepuame nakiyamea? ");
INSERT INTO var_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Pukaepa neeea, tatakoriamera paaemia eenakamenia, noochi e'enaka itamichiopua, ahpo tatakoriria cheriwepuawichioo, yooma toimo tuukaopua, ahpo tatakoririao. Ki ahpo tatakoriame maayameo, ki paayamenia pu'kao. ");
INSERT INTO var_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Piirechi taawechiamio aaata ti'tijoeria, chaachaparepua Eesusio: —Waani na'naritoamea, parisero na'naritoamea tiame, tísia iyoriamepua Riosio ki koaka. Nape aamo yeeka oiya masitiaa, ki wa'achi nokayamepua. ¿Aatia? ");
INSERT INTO var_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Wa'a chaachapopa pu'ka ti'tijoerio Eesusia, chaanerepua: —¿Aiwatarepu tooree neewiwachi paajutetiamea, iiweta ahpo ahjama kahtioiopua neewikameo? Ka'ii, neewiwachio, ko'komichio paajutetiamepua. ");
INSERT INTO var_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","No'o ma'masitiaapua no'oo ahjama kahtioiopua pehjio, ki iyorimetepua koi'wao, ahkasi no'o no'raka apechunaniachisi tewekachio, waikaope Riosi iyorimeripua ki koi'wao, kihta koakao, no'o Noonochi ahpo ku'iyeraka nokayaiopua, ihtaoi noochioi itapiti ku'iwa itayaiopua. ");
INSERT INTO var_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Wa'a ikisaopua Eesusia, wa'achitarichi nayewerepua tiame, weemera Riosichi te'terewachi simiyameopua, eee cheeka: —Aaataai ki weemera wisasorie koyachiamepua oochetiame wisasorio. Wa'a iintotioopua, wa'atia na'atameripua weemera wisasorio. Puuu weemera wisasoria, iinya teeremeripua pukachio, oochetiamechiopua. ");
INSERT INTO var_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Cheerepua tiameo: —Aaataai ki to'wamepua, weemera wiinoopua oochetiame wi'chijarichiopua. Wa'a iintotioopua, puuu aari wi'chia tataka si'pamapua, wa'a ikisoopua pu'kao, wa'atia na'itumapu wiinoai, wi'sukao. ");
INSERT INTO var_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Pukaepa wiino weemeraa, weemera wi'chijarichi toaniamepua. Wa'achitia eemeai, kaawe te'terenariaa eemea aamo weemera te'terewaeo no'o Noono tewekachi kahtiamechio, kihta na'pemete eemea oochetiame te'terewaopua Moise nuuriwachi oochetiame nokisitiameopua, animari ko'yaka Riosiwichio kohseka oowepaniameopua. ");
INSERT INTO var_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Wa'atepua tiiao, nape eeme parisero pa'pamiratuamea, oochetiame te'tereniakamera pu'seriamepua, weemera Riosichi te'tereniakamera pu'sereme tiioipua. Ihji no'o aamo tuuyeka chiiaa, ki wiinoka tiiame puuua, wiinoa, paamutetiamerakamera, tísia te'yamerapua. Nape Riosichi simiyamea, weemera Riosichi te'tereniakamera, te'ta ta'yameraa. ");
INSERT INTO var_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Piire taawechi Eesusia te'ta ahpo masitera ahjama ihtoio, resipuniame taawechio, tiiriko echitiachiami u'matoipua pu'ka ahjamao, Eesusi te'ta masitewaraa, tiiriko muurara tehpuchasika koi'siriaipua, okisikao. ");
INSERT INTO var_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Pa'parisero ti'tijoea, wa'a nokisiame tetewapao, chaanerepua: —¿Achinikai wa'a nooka eemea resipuniame taawechioi, taamoo ki reesiseniamekoipua wa'a nokiwao? ");
INSERT INTO var_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Waikao Eesusia nehjiarepua: —¿Kiisi iyonakamekosa eemea Raawitaru iintoriaopua, ahpo ahjama nokisia ki teesa cho'chorowapasoopua? ");
INSERT INTO var_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","¿Ki Riosi karichi pakika, Riosi to'wewa paani ko'kakamepu, ahpo yeetoaopua kipoteka tiame, neeseriosiche koaya ko'kometi? ");
INSERT INTO var_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Eesusi chaanerepua tiameo: —Puuu resipuniame taawe yahchakao, neee Tijoe Tijoetukame, iintokamepua pu'kao. ");
INSERT INTO var_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Piirechi taawechi resipuniame taawechio, Eesusio i'isaeri napawikarichi ihsioiopua masitekao, wa'achi yasariaipua piiripi tijoe, sekachi chookopakame. ");
INSERT INTO var_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Ookapi pa'parisero ti'tijoea, i'iyoteri ti'tijoea tiame, Eesusi ichipuka inateriaipua, itapiti ki reesisewa iintosoopua resipuniame taawechio, yawichichi wenejinariapa chapisa. ");
INSERT INTO var_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Nape Eesusia nane'riaipua ahpo chapinarewao, sekachi chookopakameo chaanerepua: —Ehsoo enasao wa'ana, i'wa weripaomua naasipa. Waikao sekachi chookopakamea, wa'a iintorepua. ");
INSERT INTO var_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Waikao Eesusia wa'a naasipa weripasoopua, chaanerepua ahpo norikame mochikameo: —Aamo iinatuketaone: ¿Ihtanakamera reesiseripua resipuniame taawechio, kaawerumara yoraniame, ki kaaweruma yoraniamekosaoipua; aaata sauteniamera, ki aaata sauteniamekosaoipua? ");
INSERT INTO var_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Nape aapoeo kihta nehjiakopaopua, Eesusia ahpo norikame ne'nepakaopua waikao, chaanerepua chookopakameo: —Riisasipaomua aamo seekao. Wa'a iintorepua waikao sekachi chookopakamea. Wa'a iintosochepua pu'kao, saukame itipirepua, sekachio. ");
INSERT INTO var_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Nape wa'a iintokopa Eesusio, pa'pariseroa tísia nenekarepua Eesusichio. Wa'a iikapa puuua, ihchi ahpo katewerepua, achini yorapuameopua Eesusio. ");
INSERT INTO var_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Pu'ka taawechiamio Eesusia, teewi roomosachite akiparepua, ahpo Noono tewekachi kahtiame ahjama nayewamia. Wa'a simisaa Eesusia, yooma tukawari ihsirepua wa'ao. ");
INSERT INTO var_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Taaa machenasoopua piario, ahpo ahjama ohjosikameopua ahpo masitia keepusikao, ahpo kahtiachi waapi ajapanurerepua. Ahpo kahtiachi ajapasoopua pu'kao, pu'kao oosa mariki aampa ooka uusaopua, ahpo Noono tehkiwachi ahpo ku'ika nokisimichio ajawarepua. ");
INSERT INTO var_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Ihji ajawatiamea naati enerepua: Siimoni, puuua Peero teewataniame tiame; Anteresi, Siimoni poonira; Saantiao; Waani; Eeripe; Waatorome; ");
INSERT INTO var_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Maateo, Reewi teewataniamepua tiame; Toomasi; Saantiao Arajeo taanara; Siimoni Weemuame teewataniame; ");
INSERT INTO var_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Uurasi Saantiao taanara; Uurasi Ihkarióte kuchitewaeme, puuua neipao Eesusi nehjakame noriwi. ");
INSERT INTO var_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Ehjepao Eesusia ahpo ajawawa kajusaapa, ahjama tekiyaiopua wa'a yeepoo, ki ookapi tewarepua ti'tijoerio, wa'a Eesusi keepumia napawikame, ahpo kokoriame sautekepuaichio eneriapua tiameo. Puuu ti'tijoeri napawikamea, yomachi ahkaoi e'enakame enerepua: Uurea weeechiami, Eerusareni muuwarichi o'inia e'enakame, Tiiro weruma mochiwachi o'inia e'enakame, Siironi weruma mochiwachi o'inia e'enakame, na'pa puuua, Meritaráneo pa'wesuwe weruma mochiraeme. ");
INSERT INTO var_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Yooma ki kaaweruma tijoeturi yahchari aiwameoi, sauteretupua Eesusieo. ");
INSERT INTO var_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Eesusia ahpo utewarieo, seekarepakache yachapatiopaopua, yoomahka ahjachi ihchepakaoi, yachapanarerepua, wa'a e'enakamea. ");
INSERT INTO var_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Waikao wa'a iintosaapa sautekaopua Eesusia, masiteka o'inerepua wa'ao, ahkaoi o'inia ahpo keepumia e'enakameopua, ti'tijoeri. Pu'kao yooma ne'nepakaopua, chaanerepua: —Eeme tesiwa erakoameopua iikachio, ta'iria mochitomitia eemea, kiatiamekapa eemea, Riosi ahjama aamo mochipuaopua, Riosi ye'karichio. ");
INSERT INTO var_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","’Ta'iria mochitomitia eemea, chorowachitia e'ramea iikachio, aiwaka posatepuaite eemea, Riosieo. ’Ta'iria mochitomitia eemea, ehpe taawechiami naarakoamea aamo tatakoriwichioo, enamitepua taawechio, aamo Riosie cheriwetiame tatakorio, ta'iria achikomiachiopua. ");
INSERT INTO var_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","’Ta'iria mochitomitia eemea ohso kaawe, no'owichioo aamo nekamuchenioi, aamo wa'ineka mochinioi, aamo na'ara chaanenioi, aamo ki kaaweruma tijoerichitia ipaka tetewinioiopua, no'o Eesusi Tijoe Tijoetukamechi te'teretopa. ");
INSERT INTO var_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Ohsotia eemea wa'a yoraniaio, peenia erakopuapua pu'kao. Eemea ohso kaaweo, kaawe erakopuapua, Riosio aamowichioo ki nu'uti kaawe erapuame aamo nuutekiopa, ki teesa ta'iria mochipuame. Puuu ehkoriami Riosi nayewaturaai, amochitia na'aretiamepua tiameo, i'ka ki ka'karuma ti'tijoeeo, ehkoriami mochiriameeo. ");
INSERT INTO var_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","’Nape ai eeme ki Riosichi erakoamea, aamo toomi tísia paarasatiachiche tahpitika erakoamea, eemea pu'kao, ku'itapisi wa'a te'tereka ta'iria mochikamepua. ");
INSERT INTO var_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","’Ai eeme Riosi toakamea, ki Riosie soparame ahpo erakoamea. Wa'a erakoame eemea ehpiamiopua pehjio, nape asimiitepua piie taawechiamio, tísia aamo tesiwa erakomiachiopua Riosichio, tahpitika erakoka Riosie ahpo ku'ipuawichioo. ’Ai eeme, ehpe taawechiami ta'iria achikoameapua, kiisi kaawe te'tereka Riosichio, asimiitepua piie taawechiamio, aamoo tísia yuuwesika mochimiachio, Riosio ti'tijoerio, te'ta kateweka ihsioio. ");
INSERT INTO var_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","’Ai eeme aaata tísia kaawe nayewaniame ti'tijoerieo, ahpo tísia kaawe te'teriame erakoamea Riosichio, wa'achitia teteiwame eneriai ehkoriami mochiriameai, ahpo ki ka'karuma Riosi nayewaturiameo, kiisi pichiwaka chaachapakameo. ");
INSERT INTO var_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","’Ohso kaawe no'o keepupuapua, no'o aamo chaanemia. Ka'karumara teerewachiche te'teretopuapua. Aamo na'ara yoorameo, ki nekaka tetewipuapua; aamo nekumiameo, ka'te nekumeka tetewimitiapua pu'kao. ");
INSERT INTO var_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Aamo mukijeraka na'arameo, kaaweruma e'repuapua pu'kao. Na'ara aamo chaaniameo, ohsotia kaaweruma itapuapua pu'kawichioo. ");
INSERT INTO var_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Aamo nanarichi wewetioo, oowepuapua piire aamo nanarioi, wewepuaichio. Aaata aamo ampawakira u'yenaresoo, ohsotia aamo wakiraoi kiapuapua pu'kao. ");
INSERT INTO var_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Aaata itapiti tesiwa tiiapa aamo itanesoo, kiapuapua pu'kao. Itapiti u'yetiaimua, ki utewa yorapuapua, aamo no'rawemichioo. ");
INSERT INTO var_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Aaataoi muuua, aamo yorajerachitia, yorapuapua. ");
INSERT INTO var_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","’Aamo nakika mochikameche nakiyame enesaamua, ¿te'tana kaawe ihsiame enetamua? Pu'ka wa'a tiiameo, ahkasi ki Riosi nakiyameai, wa'achi nokayamepua. ");
INSERT INTO var_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Aaata aamo kaawe yoorameche, kaawe yoresaamua, ¿ihtana peenia ihsiame enetamua waikao? Ahkasi ki kaawe te'tiameai Riosichio, wa'achi nokayamepua pu'kao. ");
INSERT INTO var_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Aaata aamo no'rawepo o'raka reweyameche enesaamu, ¿ihtatia peenia ihsiwa enetamua waikao, pu'ka tatakoriameoi wa'achi nokayamekoo? ");
INSERT INTO var_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Kaawe uuka teteipuapua, aaata ki aamo nakiyoiopua. Aamo reweka itaniameo, rewepuapua pu'kao, ki epeche aamo no'raweniame puuyeka. Wa'a te'teriamea, te'pa kahtiame No'noeopua, ki nu'uti enemeripua kiapuamea. Wa'a te'tereka mochitoamea, Riosi nakiyachitia mochitoamepua, tísiwa te'pa kahtiame tatanarachitia. Te'pa kahtiame Noonoeopua tiameo, aaata ki ka'karumaoipua, kaaweruma itapiti kiapuamepua Riosieo, ahpo wa'a iintowachio, ki cheriwema kianiaipua. ");
INSERT INTO var_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Eemea, tesiwe e'riame enepuapua, taamo Noonoopua aamoo, tesiwa e'riachitia. ");
INSERT INTO var_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","’Ka'te ihta ki kaaweruma chaanemitiamua aaatao, kihta a'chi aamo chaanepuawichioopua aaataeo. Ka'te aaata itapiti iintoko tuumitiamua aaatao, ki wa'achi aamo iintorio tuupuaichiopua. Eemea cheriwiame enepuapua aamo piirechio, aamo Noono tewekachi kahtiameo, aamo cheriwemichiopua tiameo. ");
INSERT INTO var_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Chuurame pochikame ihko nehjame enepuapua, puuu aamo ihkokiamea, epeche pochikame aamo ihkokemapua, wi'suame, sasaweka pochiwatiame, pewatiame sasaweka. Aamo kaawe e'rariachitia ihko nehjaka, wa'achi kaawe e'raka ihkokepuame muuuai. ");
INSERT INTO var_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Eesusia cheerepua tiame: —¿Achini teeka aaata ki ma'chiriamea, kaawe neesetotarepua aaata piirechio ki ma'chiriameopua, ki ma'chitiame enesaa? ¿Ki na'pa wahka tekopachi ruhjitarepua? Pukae eemea pipiripi, ki kakupachi ohjoame enesaa, kihta chaanemete muuua aaataoi. ");
INSERT INTO var_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Masiteniamea ki epeche pepeniamepua ahpo masitiachitiao. Ahkasi ahpo masitarichitia ahsepari penipasaape, wa'achi ihsimeripua tiameo, ahpo masitarichitia. Wa'achi teeremete eemeai, aaata chaanenariaa. ");
INSERT INTO var_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","’¿Achini iikai kasarae pusiwekameko tuunamua piirechio, aamoo ki tetewamekaipua, kutemori teekaopua puichi? Pukaepa muuuai, ¿aachin teeka chaanetamua aaatao, muuu wa'api ki kaawerumachi oiyameai enesaa? ");
INSERT INTO var_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Wa'a tiame teekame enesaa, ¿aatia chaanetaremua aamo poonio: “Ehsoo, aamo pusiweria ma'chipasetaone kasara?” ¡Tísia wistuame muuua, aamo puichi teekai kutemori! Aamo puichi teeka kutemorio, aamo pusiwepupuapua pahchao. Kaawe ma'chiriapa muuua waikao, kaawe pusiwepumamua waikao, aamo piirechi kasara pusiweriao. ");
INSERT INTO var_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Eesusia, simiteka masitekao, cheerepua tiameo: —Kuuu ka'karumaa, kiisi taakiamepua ki kaawerumao; kuuu ki ka'karuma taakiamea, ka'chi iika ka'karuma taakiamepua. ");
INSERT INTO var_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Yooma ihta kuuu taakiamea, ahpo taakiamechi machiwamepua. Wehchajurichiai, ki taakiamepua waurio. Panijuwariai, ki ihta uuyawichiooi, pujiniamepua. ");
INSERT INTO var_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Kaaweruma tijoea oowitiameai wa'achitiao, ahpo iikachi kaaweruma tiiakamera, chaachapamepua; ki kaaweruma tijoea oowitiameoi, ahpo na'ara tiiakamera iikachi chaachapamepua. ");
INSERT INTO var_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Eesusia eee cheeka masiterepua tiame: —¿Achini iikai aaataa, no'o Paamira teewanipua, ki no'o chiia yoorai? Te'ta no'o Paamira teewamea, ki wa'a teeka yasitomeripua. ");
INSERT INTO var_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Aaata no'o Paamira teewamea, no'o chiia yooramea, eee tiiamekatepua: ");
INSERT INTO var_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Ihjia, teeresi wejisa kaari chokitetiamechitepua. Ihjia teere chokitesa weeramepua kaario, e'pechitia pewatiachi. Waikao aakia, tísia utewaeme eenakaiopua motaka, kiisi ko'rimeripua, tísia pewatiame weeriapa pu'kao. ");
INSERT INTO var_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Nape no'o keepuaio, ki yooramea no'o chiiao, setechi karitakameka tiiamepua, ki pewatiachi chokiteka. I'ka kaariopua, aaki utewaeme enasaopua, ahjachi motaka ru'minamapua pihtunaka. Wa'achitia ru'michaniame aaataa noochi paparao, ki pewatiame kahtiamea noochio, itapiti aiwaka yasitoapaopua. ");
INSERT INTO var_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Eesusia ti'tijoeri nayeweka kajusaapua, Kapenau eenarepua mochiwachi. ");
INSERT INTO var_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Wa'a Kapenauo, wa'a yasariaipua piiripi soontaro kapitai, rooma tijoe eneriaipua. Puuua ahpo ta'pechio, ahpo tísia nakiya nuurewao, tísia kokoriame iinueriaipua, ki paparamepa. ");
INSERT INTO var_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Ihji kapitaia, Eesusi wa'amahka oiyame inamukapao, paaenurerepua pu'kao, ookapi i'isaeri ti'tijoee, o'ochetiame pirenaturi tewaniamee. Pu'kao kapitaia, ahpo cheriwenureka uhjurerepua Eesusio, eenaka sautejeraka ahpo ta'pechi kokoriameo. ");
INSERT INTO var_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Waikao uhjuratiamea Eesusichi e'enakao, ahpo cheriwe nuurio tuurepua kapitaio, ahpo kahtiachi eenaka sautemichioopua, ahpo kokoriameo. Wa'a chaanesaapua uhjuratiamea, chaachaparepua: —Tísia ku'ijerani teeme pu'ka kapitaio, tísia kaawe erakoma teemea amochio, pu'ka ku'iriao. ");
INSERT INTO var_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Puuu kapitaia tiameo, tísia taamo ku'ikamepua, taamoo i'isaeri ti'tijoerio, taamo napawikarioi apoe wa'api weerakamepua pu'kaoi. ");
INSERT INTO var_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Wa'a chaanetiaapa Eesusia, ahjama simirepua, nape waapi ta'pechi ihtoame tetewapa kapitaia Eesusio, wahjachi ahpo kaawe uuya uhjurerepua Eesusio, chaanemichioo: Eee chaani kapitaia: —Ka'te aamo eerinamitiamua no'o ta'pechisi asikao, ki aaata neeea no'o ta'pechi pakipuaio. ");
INSERT INTO var_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Wa'a e'rapa neeea, ki simikame neeea nooe aamo paaemiaoi, no'o cheriwejerakao, no'o kokoriame yachapatejerakao. Aamo cheesochepaoi, yachapatemioche e'rapaopua, no'o weripateria kokoriame iinuekaopua —chiiame uhjurerepua Eesusio ahpo nuurewaeo—. ");
INSERT INTO var_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Neeeai amochitia nuuramepua tiameai, no'o soontarowaa no'o nuurewachi mochitoamepua tiamé. I'kao amochitia no'o chanisoche: “Waami siimitia”, wa'ache ikimapua; piirechio no'o chaanesooi: “Eenao noochi”, enamachepua noochioi. No'o yorakiame mochikameoi, no'o chaanesoo: “I'ka yoramitia eemea”, yoramachepua pu'kao —wa'a chaachapare kapitaie uhjuratiamea. ");
INSERT INTO var_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Eesusia, yooma i'ka kapitai ahpo chaania inamusaapa: “Aa, naakona wa'a e'ramemua”, eraparepua kapitaio. Wa'a iikapa Eesusia, yooma ne'nepakaopua ahpo na'naritokameo, chaanerepua: —Aaatachioi ki tewakamenia te'ta i'ka kapitaichitiao, te'ta noochi paparameopua, ahkaoi isaeri ti'tijoechiopua. Waikao Eesusia ki pakika wa'a ta'pechio, yachapaterepua kapitai weripateriaopua kokoriame. ");
INSERT INTO var_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Waikaopu uhjuratiamea, kapitai ta'pechi noonorasaapua, saukame tewarepua kokoriameo. ");
INSERT INTO var_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Wa'a o'inia neipao Eesusia, Naaini mochiwachi akiparepua ahpo te'ta masitera ahjama, muuwaeme ahpo na'naritoa ahjama. ");
INSERT INTO var_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Waapi Naaini nokisiaio, mukukame i'toame nateparepua, muuwaeme nokisiame. Ihji mukukame yeeyeraa, kunamukukame eneriaipua, pú'kache taanaekaipua piiripi wa'api, kiterepatekame. ");
INSERT INTO var_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Waikao Eesusia pu'ka oowitiameo, tesiwe e'repakaopua, chaanerepua: —Ka'te naara oowitiame. ");
INSERT INTO var_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Wa'a cheekao Eesusia, chapikerepua e'taparao i'toniachio. Waikao mooketoameai, ajaparepua. Ajapasoopua Eesusia, mukukameo chaanerepua: —¡Werisisa temaríí! —aamo chaanenane temaríí. ");
INSERT INTO var_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Waikao temaria yasisirepua, nayewasirepua waikao. Wa'a iintosaapa Eesusia, chaanerepua yeeyerao: —Wa'a kahti aamo taanaapa, kaaweruma. ");
INSERT INTO var_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Waikao wa'a iintokame tetewakamea, ki nu'uti iintoriame e'reparepua Eesusio. Wa'a iikapaopua, tísia kaaweruma nayewarepua Riosio, chaachapaka: —Ki nu'uti kaawerumapu Riosia, ki nu'uti taamo nayewatumeri uhjurekamepua tamochio. Ahpoopua chaachaparepua tiameo: —Riosi apoe ihjia, tamochi eenakame, ahpo ijinuwa ku'imia. ");
INSERT INTO var_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ihji i'wa wa'a ikitiamea, ki tehpe yomachi Uurea weeechi nane'reretupua, yooma norikameopua tiameo, Uurea weeechio. ");
INSERT INTO var_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Waani Paatoria, ahpo masiterae nane'rekapaopua, yooma itapiti Eesusi peenia inisiaopua, ");
INSERT INTO var_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","ooka ahpo masitera uhjurerepua Eesusi iinatukemichioo, apoekosapua enamerio, aaata piirechikosakoiopua, taamo puuyemerikoopua enamerio, Ehkoriami Iyoterichi Riosi na'nayewatura chaachapariachitiao. ");
INSERT INTO var_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Waikao Waanie uhjuratiamea, Eesusichi e'enakao, chaachaparepua: —Teemea aamo iinatukemichio uhjuratiamekapu, muuujuareko iinatukemichio Riosie uhjuratiame enameria, aaata piirechikosaoipua, puuyepuamea pehjio. ");
INSERT INTO var_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Pu'ka uhjuratiamea ajasioio, Eesusia, ti'tijoeri yachapateka ihsire puuua, muuwaeme na'arari yahchame sauteriaipua, yooma ihta ko'koame iinueme, ki mamachiriame tiame. ");
INSERT INTO var_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Wa'a ihsiai sauteka Eesusia, chaanerepua Waani uhjurariao: —Nonorakao, yooma i'ka tuuyemitiapua Waanio, i'ka no'o ihsia aamo tetewa, yooma i'wa aamo keepuria tiame. Chaanepuapua pu'kao no'oo, ki mamachiriameo ma'chirepatio —tuuyepuapua—; ro'rojioi no'oo, ohjotio —tuupuapua—; repera kokoriameoi no'o sautio —tuuyepuapua tiameo—; na'nakapioi inamutio —tuuyepuapua—; mukukameoi ahjatio —tuuyepuapua tiamée—; aaata ahpo tatakoririoopa tesiwa erakoameopua iikachio, Riosi ka'karuma tuuyewarie, no'o kaawe erapatio —tuuyepuapua—. ");
INSERT INTO var_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Aaataoi ki suuwe e'riameopua noochi paparakao, tísia ta'iria yasitomeriko tuuyepuapua. ");
INSERT INTO var_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Waani uhjuraria nonorasoopua Eesusia, Waanichi simiyame nayewesirepua ti'tijoerio. Uwatiame nayewaka iinatukerepua: —¿Ihtana ne'nemia siimpakame eemea ooruchi weeechio? ¿Oowera paaka eekae nokayamekosa, tijoe chachapia ihsiame? ¿Aaata tijoe rooroikamekosaoi? ");
INSERT INTO var_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","¿Naatikosaoipua, tijoe sosopatiame wakiraeme, tísia nayewame? Ka'i puuua, puuu wa'a te'tiame wakiraemea, ahpoche ta'iriache mochikamea, ya'yawichiche te'ta kaarirachiche mochikamepua. ");
INSERT INTO var_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Ki wa'atiame ne'nemia siimpaka enesaa, ¿ihtana ne'nemia siimpaka eemea naaju wa'ao? ¿Riosi nayewatuame tijoe? Eje'e, puuu enerepua. Nape puuua, epeche tiiame, ki Riosi nayewaturachitia. ");
INSERT INTO var_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Ihji Waania, ehkoriami nayewatiame enerepua, Ehkoriami Iyoterichio, pu'ka Waani nayewakao iyoteria, chaanipua: Wa'a aamo uhjurenane piiripi nayewatura, aamo nayewatumichio pahcha. ");
INSERT INTO var_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Neeea aamo chaanenapua, aaataai i'ka weeechio, ki epeche tiamekopua Waanio, no'o enameriko tuuka ihsikamea; nape te'pa tewekachi Riosi ye'karichio, aaata nu'uti tiiamekaipua, epeche weruma tiiamekaitepua ki Waanichitiao, weeechio ohjoemeo. ");
INSERT INTO var_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Yooma Waani keepukamea, Rooma te'ta yawichiwichio koparoamea tiameo, pichikeka keepukame Waani chiiao, ahpo paatonurerepua Waanio, Riosia pu'kao, te'ta papakorepua tatakorio. ");
INSERT INTO var_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Nape pa'pariseroa, Moise nuurari ma'masitaria tiame, ki nakikame puuua ahpo paatopuawichioo, ipaka tetewikamepua, i'ka Riosi ka'karuma tuuyewariopua, Riosio kaaweruma e'raka oowioiopua, ki ahpo tuunareriopa tatakorio, kiisi cheriwepuame Riosieo. ");
INSERT INTO var_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Eesusia simiteka naewakao, cheerepua: —¿Ihtanaka tiiameko tuutane i'ka ehpe taawechiami ti'tijoerio? ¿Aatia tiiame ohjoarepua? ");
INSERT INTO var_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Aa, puuu ti'tijoeria, kukuchi te'eka mochiriamekatepua, eee chaachapariaipua: “Taamoo pakapucherae peenia chaachatekoio, kiisi yawikame eemea; taamoo tísia yuuwesiwa tiiame chaachatekoio, kiisi naarakokame eemea.” ");
INSERT INTO var_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Wa'achi te'terekame eemeai, ki yoorakapa Waani Paatori chiiao. Ohsotia eemea, reemoikame teewarepua Waanio, pu'kao, ki tijoeekachi yaajatopa, ki paani koayamekopua pu'kao, wiinooi ki iijiamekopua pu'kao. ");
INSERT INTO var_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","No'ooi Tijoe Tijoetukameoi, ki yooriame eemea no'o chiiao, no'oo aamo mochikachiami oiyoipua ahjama koaka, aamo ahjama iijika itapiti. Wa'a tiiopa no'oo, oowera posaka no'o pu'seriame teewanipua, iijika pu'seriameopua tiame. Wa'a chaachapakaopua tiame, no'o tatakoriame ahjama oiyo tuunapua, aaata Rooma yawichiwichio koparoame tiame. ");
INSERT INTO var_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Nape ehpe taawechiami ti'tijoerio wa'a te'terioio, Riosi te'ta ka'karuma tuuyewaria taamo ti'tijoeri chaaniao, ki pichikenarerioiopua, Riosi peenewaria ma'chiame tetewitemeripua, yooma aaata Riosi chiia pichikekameopua, Riosio te'ta peenewariamekopaopua. ");
INSERT INTO var_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Piiripi parisero tijoe Siimoni tewaniamea, ahpo ta'pechi yeetorepua Eesusio, ko'kotemia. Eesusia kajena poipaka yasiparioiopua ko'komia, ");
INSERT INTO var_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","wa'achi eenare piiripi oowitiame suweporichi tehkieme, Eesusi wa'a eenario tuuo inamukapa. Puuu oowitiame, piire riimeta sewajuya i'toka eenarepua. ");
INSERT INTO var_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Wa'a eenakaopua, tarachi chukipaka nanararepua tísia o'kewataka, pu'ka o'kewae papakosaapua Eesusi tarachio, ahpo kupae wakipaterepua pi'wekao. Wa'a ikisaopua, tarachi chuchusaopua, pukae seewajuyae peeniajurepua tarachio, to'wepaka. ");
INSERT INTO var_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Waikapu pariseroa, ahpo ta'pechi paajutekamea ko'kotemiao, e'raka tetewarepua Eesusio: “Pichiwa Riosichi eename enesaa ihjia, nane'reka tetewimiipua i'ka oowitiame apochi imachukameo, suwepori nokiwamechi tekipanamekopua.” ");
INSERT INTO var_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Nape Eesusia nane'riapa ahpo e'reniao, chaanerepua: —Siimoni, aamo chaanemo o'rane itapiti. Siimonia waikao nehjiarepua: —Ehsoo no'o chaaneo masitari. ");
INSERT INTO var_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Waikao Eesusia o'inerepua chaanekao, wa'achitarichi nayewekao: —Ooka ti'tijoea, wikirieriataipua aaatao, aaata toomi reweyame. Piiripi puuua, mariki siiento taawe yowiniame wikirieriataipua, piirea ooka weerewa aampa oosa mariki taawe yowiniame. ");
INSERT INTO var_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Pu'ka ookao, ki nateteme te'tiopao, na'pa wikiriara cho'weriatapua pu'kao. Ehsoo, no'o chaanemitiao, ¿aatanakamera epeche nakiyame enerepua ahpo reweyameo? ");
INSERT INTO var_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Siimonia nehjiarepua: —Epeche wikiria cheriwetiamera, maaenania. Eesusia chaanerepua: —Eje'e, kaawe nehjiarumua. ");
INSERT INTO var_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Waikao pu'ka oowitiame ne'nepakao Eesusia, chaanerepua Siimonio: —¡Nee, ne'neo i'ka oowitiameo, achini iintorupua noochio! Nape muuua ki wa'a iintorumua. Muuua, aamo ta'pechi asikoiopua, neeroioi ki no'o ki'yakamepua, no'o tarachi papakopuamichoopua. Nape ihji oowitiamea, ahpo o'kewaeoi papakosaopua no'o tarachio, ahpo kupaeoi no'o wakipaterupua, pi'wekao. ");
INSERT INTO var_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Muuua ki no'o chuchukamepua teepotaio, nape ihji oowitiamea no'o pakisoche aamo ta'pechi, o'inekamepua no'o chuchuka taarachi. ");
INSERT INTO var_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Muuua no'o moochioi, kiisi no'o to'wekamemua ooriwo soowioi, wa'a taamo nokayamekoi muuua. Nape ihji oowitiamea, yooma iintokamepua pu'kao, ahpo u'paria seewajuyaoi, no'o tarachioi chuhchekamepua ohsotia. ");
INSERT INTO var_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Pukaepa aamo chaanenania, i'ka oowitiameo ki ookapikoipua tatakorirao, cheriwetiame itipio tuunania tatakoririao, tísia nakiwari iintokaopua, ki nu'unti paparari iinuekapapua. Ihji ooitiamea, tísia weruma cheriwetiamepua, nape ki weruma cheriwepuame iinuemea, ki te'ta ahpo nakiwari, tetewitiamepua. ");
INSERT INTO var_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Wa'a chaanesaapua Siimonio, chaanere Eesusia oowitiameo: —Aamo tatakoririao, yooma cheriwetiame itipitenania. ");
INSERT INTO var_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Wa'a cheekopa Eesusio, wahjachi wa'a paajutetiamea, chaachaparepua ahpoo: —¿Ihtana iikame ihji tijoea, ahkasi tatakorioi cheriwio tuuyame? ");
INSERT INTO var_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Nape Eesusia oowitiamechi ne'nepakaopua, cheerepua aampachi: —Aamo tatakoririao, aamo paparariawichio, newikame itipikame muuua Riosie kokosapuameopua. Ehpeo aamo iikachio, ta'iria teetoka no'rapuapua. ");
INSERT INTO var_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Ku'wetakiri neipao Eesusia, yomachi oiparepua mochiwachiamio, Riosi chiia ahpo ye'karichi simiyame nayewesikaopua, tuuyesika, ahpo oosa mariki aampa ooka, ahpo ajawaria ahjama. ");
INSERT INTO var_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Wa'achi nokisire ooweruai, Eesusi sauteria kokoriao, wahjachi ooweruai tiame, ki ka'karuma tijoeturi puhjetiame. Piiripi ihji oowerua, Maaria enerepua, Maarena teewataniame, pukachio, oowisani reemo puuyanetiame. ");
INSERT INTO var_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Wa'achi ihtore Uhwana tewaniameai, Kuusa tewaniame uupira. Kuusaa, Eerore ye'karichi ku'yame eneriaipua. Wa'achi inisire Suusana tewaniameaipua. Wa'achi nokisiriai muuwaeme wahjachiai, Eesusi ku'ikame itapiti ahpo iinuekae, yooma Eesusi ajawaria ahjama. ");
INSERT INTO var_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Piie taawechio, muuwaeme norikame ahpo mochiwachiami puuyakao, Eesusi ne'nemia e'enarepua keepumia. Eesusia ahpo kahtiachi napawikopao, i'ka wa'achitarichi o'inerepua nayewekaopua cheeka: ");
INSERT INTO var_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","—Piiripi echayamea o'ineriataipua echakao. Ihjia echayaio, pooechi ruhjiteriataipua ookapi iimori. Pu'kao ti'tijoeria wa'a u'matopamea, yooma tekeka uumatoriatapua. Tuchikiai wa'a e'nakaopua, yooma pepeka ko'kariatapua pu'ka iimorio. ");
INSERT INTO var_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Wahjachi iimoria e'peekachi ruhjiriataipua, waitiame chuhkuachi weee. Puuuai yaupakai, ikanati wakipariatapua tiame, i'ka weee samiyao, ki tehpe e'oka wakipariopa. ");
INSERT INTO var_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Wahjachi iimoriai wehchajuritere ruhjiriatapua, pukaepa i'kao, wehchajuri weweripakao, wakipateriatapua si'rinaka. ");
INSERT INTO var_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Neipa wa'asi iimori ruhjikamea, tunakame weeechi ruhjiriatapua, ka'karuma weeechi. Pukaepa puuua weweripakao, piie siiento pahchira taakeriatapua, pipiripi iimoria. Pu'ka kajusaapa Eesusia, pu'ka keepuameo, utewaeme nayewaka chaanerepua: —I'ka wa'achitari pahtenariamea, kaawe inataka i'yepuapua masitiao. ");
INSERT INTO var_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Ehjepamio Eesusi ajawariaa, iinatukerepua piineri kahtioio: —¿Achini chanika chiiamua pa'ao, wa'achitarichi nayewakao? ");
INSERT INTO var_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Waikao Eesusia, cheeka nehjiarepua: —Eemea Riosichi noriwi tiiao, ma'chitepuamepua, nape wahjachi ki Riosi chiia pichikiameopua, ka'i. Wahjachi ti'tijoeri ki Riosi chiia pichikenariameo, wa'achitarichi nayewiamenia pu'kao, inamuaio, ki ma'chiame pahtepuawichiopua, ne'niaio, ki pahteka tetewipuawichiopua. ");
INSERT INTO var_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Eesusia pu'ka wa'achitarichi nayewaka kajusaapa, cheerepua ahpo keepuameo: —Ihji iimori wa'achitari no'o nayewiaa, eee chanika cheekamenia: Iimoria, Riosichi simiyamepua, kaaweruma tuuyewari. ");
INSERT INTO var_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Pooechi ruhjikame iimoriaa ikiriao, Riosichi simiyame nayewetiamepua, ka'karuma tuuyewari, pu'kao keepurioipua ki apochi uuriáa, apochi eenaka riaorósio u'yeriopua sewina erepateka, ki Riosichi paparaka newipamichiopua pu'káo. ");
INSERT INTO var_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Puuu iimori e'pechi ruhjikamea, weee waitiachio, Riosi tuuyewari pichiketiamepua, nape puuua, ki teeresi naawaekapa ahpo pichikeriao, kokosa tiiame aiwapa Riosichio, toakame ahpo pichikeriao. ");
INSERT INTO var_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Puuu iimori wehchajuritere ruhjikamea, Riosi tuuyewari pichiketiamepua, nape paarasari weemuniamee, itapiti ki ka'karuma eraniameeopua tiameo, itapiti ki ka'karuma pu'serewaeopua, kihta iintokame taakewachitiaopua, teesa teesache si'rikame. ");
INSERT INTO var_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Nape puuu iimori tunakame weeechi ruhjikamea, pichiwaka kaaweruma iikaeka pichikekamepua ahpo nayeweretiao. Puuua pewatiame uukamepua ahpo tuuyeretia pichikeriao, a'chikoitia tísia aiwaiopua Riosichi teetoapao, tísia anachakame puuua. Puuu wa'a teeka tísia anachakamea, tísia kaawe taakekamepua Riosichi te'teretowachiopua. ");
INSERT INTO var_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","’Puuu iimori taakeniameka tiiame puuua, ti'tijoeri tahjeraka te'teriame. Ihtaoi tahjeraa, ki noriwi weraniamepua, sikori yakana chuhcheka to'pekao, e'taparatereoi ki weraniamepua noriwio. Puuua ohso kaawe uutapamichioo, te'pa weraniamepua tepatetiachi, wa'a enapameoopua, uutapemichio. ");
INSERT INTO var_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Ihji ti'tijoe ooweru tiame tahjeraa, ki noriwi te'teremetepua ahpo tahjera te'teriao, yooma apochi enapameopua ahpo uutapachi e'enamichiopua, Riosichi paparamiao. Asimitepua piie taaweo, Riosio, yomatiame ki ka'karuma noriwi noonoitiameo, ma'chitamiachiopua. ");
INSERT INTO var_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","’Kaawe inataka inamumitiapua i'ka no'o chiiao. Te'ta iinuemea Riosie cheriwetiameo, Riosia kajuyachi taawechi enasaopua, epeche iinuemeripua Riosie ahpo kiapuao, Riosieo ahpowichio nuutekeka kahtiao. Nape kihta iinuemea Riosie cheriwetiameo, kihta ahpo kiapua teeremeripua Riosieo, ohsotia puuua ahkasi ahpo teesa iinueka erakoaoipua, u'yepuamepua Riosieo. Wa'a teeremeri Riosia, te'ta katewetiachi taawechio. ");
INSERT INTO var_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Seenepi simikame Eesusi aaata ta'perachi ihsioio, wa'a eenare Eesusi yeeyeraa, Eesusi poponira yeeka, nape ihjia tahchiame weeriopa ti'tijoeri muirachio, ka'chi iika muime erakorepua Eesusi ihsiachio. ");
INSERT INTO var_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Eesusi yeeyera ma'chi weerioio Eesusi poponira ahjama, aaataa chaanerepua Eesusio: —Aamo paaechani aamo yeeyea, aamo poponia tiame waami ma'chi. Wa'a chaanetiaapa Eesusia, cheerepua ahpo norikame ajaka keepuameo: ");
INSERT INTO var_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","—Áaa, ¿Aatanakamerajuare no'o yeeyea no'o poponiaio tiame, no'o tetejimaria tiameo? No'o te'ta yeeyea, no'o te'ta poponia, no'o te'ta tetejimaa tiame, yooma aaata Riosi chiiakamera keepuamepua, te'ta Riosi chiiakamera yoorame, Riosikamera e'waka. ");
INSERT INTO var_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Piie taawechi Eesusia, pawekakerachi pakisaapua ahpo te'ta masitia ahjamao, chaanerepua pu'kao: —Nahpe, paonamina i'ka weruma neerochio. Wa'a siimparepua waikao. ");
INSERT INTO var_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Eesusia pa'wechi nokisinioio, wa'a poitoka kochipariaipua. Wa'a teetoiopua Eesusio, wa'a pa'wechio, ki nu'unti yukurepua, tísia eejeka. Wa'a ikitiopa pawekakeraa, maapori inisirepua, neeroie pochisika piwiteme teetoka. ");
INSERT INTO var_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Wa'a ikiniopa Eesusi masiteraa, yaapiti pusitesa chaachaparepua Eesusio: —¡Masitari, masitari, yaapiti pusasáaa! ¡Piwitepani teeméee! —chaachaparepua siinakokao. Waikao Eesusia werisikao, teeweterepua eekao, pa'we pe'koniraoi. Eesusia, teewetesoopua eekao, teewere pa'we pe'koniraai. Waikao, yooma yúúweeme itipirepua. ");
INSERT INTO var_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Wa'a ikisao chaanerepua ahpo masitiao: —¿Achini ijikikame eemea, aamo noochi paparao? Nape aapoeo tahpitika erapakamekapapua, poanachi ahpo chaachaparepua: —¿Ihtana iikame ihji tijoea, eekaoi teewetiame, pa'weeoi yooreniame? ");
INSERT INTO var_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Ehjepa wa'a tiame ikisaapua pa'wechio, Kaarara weeechi paonarepua, Arirea weruma neerochiopua. ");
INSERT INTO var_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Wa'a weeechi tekikoiopua Eesusio, wa'a machejenarepua piiripi tijoe, na'arari tijoeturi yahchame. Puuua wa'a mochiwachi ohjoeme eneriaipua, nape neipao, wahjipame toaniachi yaajatoame, ki chuhchaka wisasori oiyame, poiyame. Ki ku'itapi wa'a teeka, yaajatoame eneriaipua. ");
INSERT INTO var_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Weesa kaarenae o'yaeka, ya'yachatiame enerepua soontaroeo, nape puuua, tehpunasa kuhsitere uujumame eneriaipua, pu'ka na'arari tijoeturie i'toniapa. ");
INSERT INTO var_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Puuua Eesusi machikapa aatanakoo, chopokorieka weripaka cheerepua sisinaka: —Eesúsiii, ¿ihtana yoramia teetonamua noochio, muuu Te'ta Te'pa Kahtiame Taanáraaa? Nape Eesusia wa'a chiiopa na'arari tijoeturio, te'yarepua pu'kao chaaneka: —Yaapi machenasa muuua pu'ka tijoechio. Wa'a chaanetiapa na'araria tijoeturi, chaanerepua Eesusio: —No'o tesiwe e'résaa, ki no'o kokosájeraniniaa. ");
INSERT INTO var_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Waikao Eesusia iinatukerepua: —¿Achini tewania muuua? —Piie Siento tewaniame neeea —nehjiare reemoa. Wa'a cheere puuua, ki ookapi muitekamekapa nanaarari reemoniwario. ");
INSERT INTO var_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Waikaopu tijoechi mochikamea na'araria, tesiwa chaachaparepua Eesusichio: —Ka'te taamo kokosamitia taamoo, ki waapisi wichiwachi tísia aiwateniachi taamo ihpapakao. ");
INSERT INTO var_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Wa'api waapi kahjenakooi, muuwaeme ohjopaopua koowi, pukachi ahpo uhjuranurarepua. Waikao Eesusia, pukachi reesiserepua muimichioo. ");
INSERT INTO var_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Waikao tijoechi puuyasaopua, koowichi muirepua. Waikao koowia ahjachi muitiao, tahpitika noonowirepua ujumaka. Kai muuenati ujumakaopua waatachituo, neerochi ruhjirepua si'rika. ");
INSERT INTO var_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Wa'a iikopa koowio, koowi inatiamea, ahpo mochiwachi e'enarepua tuumia, tísia majakame. Wa'a ajasisaapa, yooma tuurepua mochiwachio, yooma ihta ahpo ikiriao, ihtana ikirio ahpo tepuya koowio. ");
INSERT INTO var_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Waikao yooma wa'a mochiwachi mochikamea, yooma wa'ami mochikameapua tiameo, wa'a ikitiachi e'enarepua ne'nemia. Wa'a e'enatioopua Eesusi ihsiachio, na'arari tijoeturi iinuekamea, wa'a kahtiame tetewiretupua, kaawéruma, yachapakamepua wa'asi. Wakiratakame yasarepua wa'ao, kaawerumapua ki roorowiame. Nape ti'tijoeria wa'a iintokame tetewapa Eesusio, tísia majawerepua pu'kao, chachapia nokaka. ");
INSERT INTO var_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Puuu yooma tetewikamea, yooma tuuyerepua pu'kao, Kaararami e'nakameopua ne'nemia. ");
INSERT INTO var_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Waikaopua yooma nane'resaapa, Eesusi iintoria ahpo utewarieo, tísia seewepakaopua Eesusio, tesiwa chaachaperepua Eesusio, ahpo weewachio, machenajeraka Eesusio. Waikao Eesusia, no'rarepua pawekakerachi chuhkuachio. Wa'a mooenamioiopua pawekakerachio, ");
INSERT INTO var_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","puuu ki ookapi na'arari tijoeturi puuyanetiamea, tesiwa cheeriaipua Eesusio ahpo yeetojerao, nape Eesusia chaanerepua pu'kao: ");
INSERT INTO var_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","—Ohso kaawe muuua, i'wa aamo mochiwachi itipimitia muuua, yooma tuuyemia aamo mochiwachio, Riosi iintoriaopua amochio. Waikaopu ihji tijoea, ahpo mochiwachi no'rasaopua, yooma tuuyerepua ahpo mochiwachio, ihtana iintorio Eesusiopua apochio. ");
INSERT INTO var_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Waikao Eesusio eenechi no'rakao, Arirea weeechi paonasoopua, muuwaeme napawikame tewarepua wa'a, kaawe e'raka puuyeka mochiriame. ");
INSERT INTO var_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Wa'a tekisoopua Eesusio, wa'achi eenarepua aaata piiripi, Airo tewaniame. Puuu tijoea wa'a napawikarichi paamiratuame enerepua, kokoriame iinueme. Ihjia chopokorieka weripakao, tesiwa chaacharepua Eesusio, ahpo ta'pechi enajeraka. ");
INSERT INTO var_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Amori mukuyo tuurepua ahpo maarao, pu'ka ahpo maarara oosa mariki aampa ooka paamuame, puuuche ahpo iinueka. Waikao wa'a simiyoio Eesusio, ki ookapi na'naritorepua, tahchiame weritokaopua norikameo. ");
INSERT INTO var_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Wa'a muuwari nokisiniachio, wa'achi ihtoriaipua piiripi oowitiame, oosa mariki aampa ooka paaumpari i'toame, erayena kokoreka. Puuua me'merikochi i'yowakao, ki ookapi na'atakame eneriaipua toomio, kiisi yachapaka. ");
INSERT INTO var_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Ihji oowitiamea pukamina eenaka naaepakao, Eesusi wisasoriwarachi ihcheparepua teesa. Waikaopua, ahjachi ihchepasache ahpo erajenao teewekame saaerepua. ");
INSERT INTO var_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Waikao Eesusia, apochi ihchepatiame saaesao, cheerepua: —¿Aatana noochi ihcheparu? Nape aaataai ki noonorio tuuyopao, Peeroa chaanerepua Eesusio: —Masitari, ¿nane'retare teemea, taamo tahchitoka teetoachio motasikao? Wa'a teetoi taamoo: “¿Aatana noochi ihcheparu”, iinatukiamemua? ");
INSERT INTO var_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Waikao Eesusia cheerepua: —Nape noochi ihchepakamea, ki oowera noochi ihchepakamepua, noochi machenakame saaekame neeea, no'o Riosi utewari. ");
INSERT INTO var_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Waikao oowitiamea ki newime tiiapa ahpo iintoriao, chopokorieka weripaka Eesusio, yooma tetewachi apoe ihsirio tuurepua Eesusio, chachapia ihsika seewiapa. Waikao puuua cheerepua tiame, aatia tiiachipa ahjachi ihchepario, wa'a iintosacheopua, ikanati saukame itipirio tuurepua. ");
INSERT INTO var_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Waikao Eesusia kaawe e'rekao chaanerepua: —No'o kutewée, noochi paparakapa, saukame itipikamemua. No'raka ehpeo aamo ta'pechi, kaawe eratoka. ");
INSERT INTO var_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Eesusi wa'a chaanioipua oowitiameo, wa'a eenare piiripi kooriaa, Airo ohjirachi o'inia eename, puuua chaanerepua Airoo: —Aamo maaraapa, kiterepakame puuuapa. Kihtawichio noonotepuame Paamiraapa. ");
INSERT INTO var_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","I'ka inamuka Eesusia, chaanerepua Airoo: —Ka'te yuuwesi muuua. Noochiche oowe e'repuapua, aamo maaraa, saumitepua. ");
INSERT INTO var_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Eesusia asisaapa wa'a ta'pechiopua, ki aaata pakinurerepua wahjao, naatiche yeetoka pakimio tuurepua wa'ao, Peero, Waani, Saantiao, pu'ka kuita yeeyera tiame, noonora wa'achi, wahjaopua ka'i. ");
INSERT INTO var_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Wa'a ta'pechi tísia naarakopao, Eesusia chaanerepua pu'kao: —Ka'te naarako eemea. Ihji kuita kutewea, ki mukukamekaitepua, oowera kohchiaitepua. ");
INSERT INTO var_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Wa'a chiiopa Eesusio ti'tijoeria, a'acherepua na'arekao, puuua pu'ka kuteweo pichiwa mukukameko nane'riamekapa. ");
INSERT INTO var_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Waikao yooreko pakisao Eesusia, sekachi chapikaopua, utewaeme chaanerepua pu'ka kuita kuteweo: —¡Kutewéee, yasisísaaa! ");
INSERT INTO var_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Waikao kuita kutewea, eenechi eenaka iikarao, eenechi ahjarepua oijenakao. Wa'a ikisaopua, yasisisoopua kuitao, ko'kotenurare Eesusia. ");
INSERT INTO var_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Waikao yayawaraa, ki teesa kaawe erakorepua, tahpitika e'rakao Eesusi iintoriao. Nape Eesusia chaanerepua pu'kao, ka'te tuumitiapua i'kao, aawataoi. ");
INSERT INTO var_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Seenepi simikame tiameopua, Eesusia paaesapa ahpo oosa mariki aampa ooka ahpo ajawariopua, yooma pipiripi yahcherepua utewario, ahjae sautemichiopua kokoriameo, ahjae puuyanamichiopua tiame ihtaoi reemoniwari nanaarariopua. ");
INSERT INTO var_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Yooma wa'a iintosaopua, nayewatumia siimpanurerepua, i'ka kaaweruma Riosichi simiyame tuuyewariopua, yooma ihta ko'koameoiopua yachapatemichio. ");
INSERT INTO var_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Eesusia pu'kao, chaanesa uhjurarepua: —Wa'atia siimpamitia eemea, kihta i'toka teesorao, kihta i'toka mokewarioi, nutukaoi kihta i'toka, toomioi kihta kahcheka, wakiraoipua, ahpoche chuchatoa i'toka. ");
INSERT INTO var_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Ahkaoi mochiwachi aamo che'repachioi, wa'ache mochisa uumatopuapua, pirenachi mochiwachiamio. ");
INSERT INTO var_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Ahka ki aamo nakiwachi e'enasaa, aamo kaaka pechichisa uumatopuapua wa'ao, kihta Riosi tuuyewari nakiriopa. ");
INSERT INTO var_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Yooma i'ka chaanetiaapao, siimparepua waikao, i'ka kaaweruma tuuyewari, tuuyesimia, sautesimiaopua tiameo, kokoriame. ");
INSERT INTO var_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Pu'ka taawechiamioi Eerore yawichiai, Eesusi ihsiame inamukapaopua, wekana e'rarepua, aaata ookapia Waaniko tuuopa eenechi ahjakame. ");
INSERT INTO var_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Wahjachi aaataa, Eeriako tuurepua, eenechi ahjakame. Wahjachi piirechia tiame, ehkoriami Riosi nayewatura, oijenakameko tuurepua, eenechi ahjakame. ");
INSERT INTO var_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Nape Eerorea cheerepua: —Nape neeea Waanio, me'yakamenia pu'kao, mo'ora tehpunakao. ¿Aatanapu naaju puuua, ki ookapi itapiti ihsia tuuwamea? Pukaepa Eerorea nane'renariapa pu'kao aatanakoo, i'yasirepua, aachin teeka ahpo tetewimia pu'kao, machinariapa. ");
INSERT INTO var_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Eesusie ajawatiame uhjuratiamea eenechi e'enasaapa, yooma tuuyerepua Eesusio, yooma ahpo ohjoriaopua tuuyesikao, mochiwachiamio. Eesusia waikao e'enariopaopua pu'kao, poanachi ooruchi i'tomo o'rariaipua pu'kao, We'saira muuwarichi waapi, wa'a resipupuamichioopua ahjama. ");
INSERT INTO var_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Nape muuwaeme nane'rekamea akanamina uumpariameo, wa'amina na'naritorepua. Eesusia ahka ahpo akipariachi ahsepatiaopua, pu'ka muuwari ahpo na'naritoka ahsepakameo, kaawe e'reka uurepua. Wa'a ikisaapa Eesusia, Riosi ye'karichi simiyame nayewerepua, masitekao. Wa'aopua tiameo, ahpo sautejererameopua ahpo kokoriame u'uyepariao, sautekerepua pu'kao. ");
INSERT INTO var_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Aarikopao wa'asio Eesusi ajawariaa, naaepaka chaanerepua Eesusio: —¿Ki kaawejoarepa ti'tijoerio uhjurania, wa'ami ahka che'repamichiopua mochiwachiami, kooame i'yamichiopua tiame? Ooruchi i'wao, ki ahka i'yamete kooamea. ");
INSERT INTO var_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Eesusia chaanerepu pu'kao: —Eeme ko'kote pu'kao. Wa'a chaanetiapa Eesusie ajawatiamea, chaachaparepua: —Nape i'wao mariki paani wa'api maaniamepua, ooka so'chi wa'api tiame. Nape ¿ahsepamanapua yooma ko'kotepuamewichioo? Aamo ehpeche tarijenuresoope kooame, ahsepameripua. ");
INSERT INTO var_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Ti'tijoeria mochikame wa'ao ooweru tiame kukuchimao, u'matoame enerepu mariki miiri. Waikao Eesusia chaanerepua ahpo ajawariao: —Ooka weerewa aampa oosa mariki ahka, mochipanuramitiapua pi'pirenapio. ");
INSERT INTO var_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Waikao ajawatiamea, wa'a kehkiche mochipanurepua, pi'pirenapio, ti'tijoeria wa'a noonoirepua waikao. ");
INSERT INTO var_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Wa'a ikitioopua Eesusia, pu'ka mariki paani uusaopua, pu'ka ooka so'chiopua tiameo, te'pa tewekachi ne'nepakaopua ahpo Noonochio, cheerepua: —No'noo, aamo utewarie muuwetejeraninia i'ka kooameo. Wa'a cheekaopua nu'nunti chi'wanasao, ahpo ajawaria ki'yarepua, yooma ti'tijoeri naachutamichio. ");
INSERT INTO var_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Waikao muuwari mochipakamea, ahkasi ahpo aiwachisi ko'karepua. I'ka sopakameopua chi'wapameo, oosa mariki aampa ooka weeweruma waari, popochiame apechunarepua. ");
INSERT INTO var_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Piirechi taawechiopua Eesusio, poanachi ooruchi ihsioio, ahpo Noonoma nayewakao, wa'achi mochiriai Eesusi te'ta masitiaapua ahjama. Wa'a mochiniaoi Eesusia, iinatukerepua ahpo te'ta masitiao: —¿Aatanakata neeea, chaachapani ti'tijoeria? ");
INSERT INTO var_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Eesusie te'ta ma'masiteniamea nehjiarepua: —Ookapia, Waani Paatoriko tuunapua aamoo; ookapi wahjachia, Eeriataruko tuunapua aamoo; nape epeche wahjachia tiameo, piirechi ahkako tuunapua aamoo, ehkoriami Riosi nayewatura, eenechi ahjasa eenakame. ");
INSERT INTO var_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Wa'a cheesaopua Eesusia, ahpo ajawaria iinatukerepua: —Eemepe, ¿aatanakotipua no'oo? —iinatukerepua pu'kao. Peeroa nehjiarepua cheeka: —Muuua, Riosie Weratiamepua, Riosi tijoe enepakame. ");
INSERT INTO var_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Wa'a cheeka ahpo ma'chitakopa Peeroo, Eesusia chaanerepua: —Pichiwa puuua, nape ka'te tuumitia eemea pu'kao pehjio, aaataoi. ");
INSERT INTO var_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Neee Tijoe Naawakamea, tísia aiwamerikaitepua pehjio, kiisi nakika teteipuamepua i'isaeri ti'tijoeeo, isaeri pa'pamiratuameeopua tiame, wa'a ikisaopua tiameo, ne'neseriosi pa'pamiratuamee, Moise nuurari neesetoameeopua tiame. Ihji neee Tijoe Naawakamea, yooma pukae meripuamepua me'yao, nape neeea, paika taawechi teetoiopua, eenechi ahjakame werisimeri neeea, oijenaka. ");
INSERT INTO var_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Aaata no'o na'naritonariamea, ahpo kiapuaichiopua weemera ahjario, ki ahpochewichio inataka yasitomeripua, senepi noochi teetoka yasitomeripua, aiwaiopua. ");
INSERT INTO var_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Aaata ahpo inatiamea, ki noochi teeretoka aiwanarekao, wekatemeripua ahpo kiapuameo, weemera ahjario. Nape ki suuwe erapamea noochi tiiapao, a'chi chaaneniaipua, uumeripua weemera ahjario. ");
INSERT INTO var_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","¿Ihtanawichio kaawe enetapu, yooma iinueniaiopua i'ka weeechi iintuameopua, yooma wekapuame enesaapua, ahpo weemera ahjarichiopua Riosichio? ");
INSERT INTO var_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Aaataeoi ki no'o suuwe erapaka noochi teetokameo, neee Tijoe Naawakameai, ¿ki wa'achi teeretare neeeai suuwe e'rekao, eenechi taawechi no'o eenoiopua? Eje'e, wa'achi teerema neeeai eenechi eenaka tekisao, waika te'ta peenia tiiachi taawechi no'o Noonowichioo, te'pa no'o Noono ku'iwariwichioopua tiame, no'o Noonochio tísia iyoriwamewichioopua. ");
INSERT INTO var_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Pichiwa chaaninia ookapi i'ka ajakameo, ki wahjipama puuua, ki tetewaiopua pehjio Riosi ye'kariwao. ");
INSERT INTO var_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Osanao taawe neipao, te'pa mooenare Eesusia, roomosachi ahpo Noono tewekachi kahtiame ahjama nayewemia. Waani yeetoka simirepua wa'ao, Peero tiame, Saantiao wa'achi. ");
INSERT INTO var_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Eesusia ahpo Noono ahjama nayewaio, sewina ikirepua nanarirao, ihji Eesusi wisasoriraai, ki teesa tiame tohsaname eneparepua, nape tisiwa tohsaname, tajayame. ");
INSERT INTO var_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Wa'a ajarepua tiame, ooka tijoe Eesusi ahjama nayewakao. Puuu piiripia, ehkoriami Moisetaru enerepua, piirea, ehkoriami Eeriataru yasariame. ");
INSERT INTO var_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Ihji ooka Eesusi ahjama ajakameaio, tahpitika tiiame tajayame ajakaopua tiameo, Eesusi tewekachi no'ramia, tehpe nayewarepua Eesusi ahjamao, Eerusareni meripuaopua. ");
INSERT INTO var_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Peeroa, ahpo ahjama mochikameapua tiame, tísia kokochinariaipua, anachaka mochirepua ne'nekao. Wa'a te'teriapa puuua, tetewarepua Eesusi wa'a ikiyame tísia tisiwariraeo, nape ki teesa tiiame tajayáme, wa'achi te'tereka tajayamekoopua, puuu ooka Eesusi ahjama ajariameai. ");
INSERT INTO var_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Puuu ooka ti'tijoeo, Eesusio piineri toakoioopua, Peeroa kihta nane'riapa ahpo chanimiao, oowera wa'a chaanekapua Eesusio: —¡Masitari, kaawechupena i'wa nooka teemeai! Paika ekapora ajawama teemea, piiripi aamowichio, piirea Moisewichio, wa'a ikisa Eeriawichio tiame. Nape Peeroa kihta inatapa ahpo chanimiao. ");
INSERT INTO var_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Peeroo wa'a chanioipua Eesusio, toomari yasiparepua wa'ao, mo'porepaka. Wa'a iikopa toomario, majapochire Peeroa, wahjachi ooka mochikameapua tiame. ");
INSERT INTO var_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Wa'a ikisoo toomario, wa'a toomaritereo, chiiame inamurepua: —No'o Taana puuua, no'o weeraria, no'o uuria. Eemea pu'kao, e'weka mochipuapua. ");
INSERT INTO var_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","I'ka ihkepameo, nayewaka kajusoopua, toomari apechusoopua, Eesusiche weeriame tetewiretupua. Nape aapoeo i'ka ahpo tetewariao, ihchi teewerepua pu'ka taawechiamio, aawataoi ki tuuyerepua pu'kao. ");
INSERT INTO var_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Meereopua, kaawitiachi tetekiaio wa'asio, muuwaeme nokisiame tetewarepua ahpo natepameri. ");
INSERT INTO var_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Wa'a muuwarichi inisiame piiripi tijoea, utewaeme sisinamurepua Eesusio: —Masitári, no'o tesiwe e'remitia no'o taanao. Piiripi wa'api taanaemekane. ");
INSERT INTO var_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Nape na'araria, tísia chachapia ihsitiamekapua. Senawato ki ku'ita sisinatekaopua pu'kao, muumukipatiapua pu'kao, chu'wachiopua toonewateka. Pu'kao chapisaopua, ki toinariamekapua pu'kao, ahkasioi weerewaraopua, yooma saasawetiapua. ");
INSERT INTO var_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Aamo te'ta ma'masitiao utewa yoorakaine ma'chipamichioopua, nape aapoeo ki kajukamekapua ma'chipakao. ");
INSERT INTO var_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Waikao Eesusia chaanerepua yooma wa'a ajakameo: —Ai eeme, kiiisí ahjachi erakoame Riosichio, oowera yooma wewekakame ti'tijoeri. ¿Ahkasi achinitio wa'a teeretania aamo ahjamao, aamo anachakao aamo wa'a te'tia? Ehsoopua pu'ka temario, no'o i'yetosaopua wa'ana. ");
INSERT INTO var_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Pu'ka temario Eesusichi upatioopua, reemoniwari ahjachi kahtiamea, eenechi kai muenati puiparepua pu'ka temario, tísia kokosa yooraka mumukipateka. Nape pu'ka reemoniwario wa'a yooroiopua pu'ka temario, tísia te'yaka ma'chipakesaopua pu'ka reemoniwari mumukipatiao, saukame ki'yarepua pu'ka noonorao. ");
INSERT INTO var_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Wa'a ikitiopua Eesusieo, ti'tijoeria, ki nu'uti ihsiame eraparepua Riosichio. I'ka ti'tijoerio ki nu'uti erakoiopua Eesusi iintoriao, Eesusia chaanerepua ahpo te'ta masitiao: ");
INSERT INTO var_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","—Tísia kaawe keepukao, i'ka ti'tijoeri chaachapao, wa'a chaachapanioi no'oo, neee Tijoe Naawakamea, wahjachi ki ka'karuma ti'tijoechi, nehjipuamepua. ");
INSERT INTO var_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Nape aapoeo ki pahteka inamurepua pu'kao, wa'a chiioio. Ka'chi iika chapime erakorepua, pahtewakao, pu'ka iinatukemiaoi suuwe eraparepua. ");
INSERT INTO var_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Piie taaweo Eesusie te'ta ma'masiteniamea, nekakome chaachapariaipua ahpoo, aatanakamera epeche ahpo weruma teeremeriko nayewakao. ");
INSERT INTO var_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Nape Eesusia, nane'riapa ahpo ajawaria inatao, piiripi kuita uukaopua ahpo chokichi werapakao, chaanerepua pu'kao: ");
INSERT INTO var_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","—Noochitia kaawe e'reka uuka tetewamea kuitao, ki weruma ahpo e'rakao, noochi kaawe teereniameapua. Noochi kaawe teereniamepua, wa'achitia kaawe teereniamepua, no'o Noonochioi. Wa'a teesoo, puuu kiisi weruma ahpo tetewamea, epeche weruma tiiamekaitepua. ");
INSERT INTO var_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Wa'a cheesoopua Eesusio, Waania chaanerepua: —Muuua taamoo, taamo paaeriamemua aamo na'naritomichio, aamo tehkiwachi ku'imichio tiame, nape teemea tapanara nayewatuka ohjoaio, aaata tetewaka teemea ki taamo ijinuwa, aamo teewarachi cheeka ma'chipayame nanaarame reemoniwario. Ta'omaka teemea pu'kao, ki taamo ijinuwakopa. ");
INSERT INTO var_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Wa'a chiiopa Waanio, Eesusia chaanerepua: —Pe'yachipua pu'kao, ki taamo ahjama nokayai puuua, ki taamo na'ara nokayamepua, ohsotia puuua taamo ku'yamepua. ");
INSERT INTO var_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Paikapi taawe toioiopua, Eesusi tewekachi mooenamiachio, Eesusia oisa teetoka mooenarepua Eerusarenio. ");
INSERT INTO var_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Nape pahchao, ahpo ajawaria uhjurarepua, ahpo che'repapuachi i'yamichioo, nu'uti mochiwachio, Saamaria weeechio. ");
INSERT INTO var_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Nape Eesusi ajawaria wa'a mochiwachi e'enatioio uhjuratiaio, ki kaawe uuka tetewiretupua, Eerusarenichi siimpameko nane'rekapa. (Saamaria ohjoemea wa'a teeka tetewirepua Eesusi uhjurariáo, ki ahpo kaawe uuka tetewamekapapua, Eerusareni ti'tijoerio.) ");
INSERT INTO var_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Wa'a ikisaopua Saantiaoa Waania tiame, i'ka inamusaa, chaachaparepua Eesusio: —¿Ihtana iintotariapua pu'kao Masitari, tewekachi na'i itatariarepua, ahjae kosimichiopua pu'kao, Eeria Riosi nayewatura iintoriachitia waika ehkoriami taawechiamio? ");
INSERT INTO var_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Nape Eesusia wa'a chaachapopao, ku'rika kaawe ne'nepaka, te'yarepua pu'kao chaaneka: —¿Aaataai Riosichi paparamea, wa'ana erakometepua? ¿Kikosa aaata aamo na'ara yoora, wa'achi yoranare eemeai? ");
INSERT INTO var_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Waikao uumatorepua pirena mochiwachi che'repapuachi i'yamia. ");
INSERT INTO var_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Pooechi siimpoio aaataa, Eesusi naaepakao, chaanerepua: —Paamira Eesusi, aamo ahjama siminare neeeai, ahkaoi aamo simiyachi. ");
INSERT INTO var_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Nape Eesusia chaanerepua: —¿Kaawe inatakame muuua aamo chiiao? Keeochia, keeochikai iinuemepua ahpo kochimiachio, tuchikia tuchikikaio iinuemechi puai ahpo ta'sowao, nape neee Tijoe Tijoetukamea, kihta iinuemenia ahkaoi no'o kochimiachio. Wa'a tiiamekoio, ¿no'o ahjama siminariame muuua? ");
INSERT INTO var_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Piirechiopua tiame Eesusia, ahpo ahjama nokisiame inisiameo, chaanerepua: —No'o ahjama ihsiame enemitiapua, no'o Noonochi tehkiwa ku'isika. Nape tijoea nehjiarepua Eesusio: —Eje'e wa'a ikimane Paamira, nape iiweta pahchao, no'o noono kiterepakame, no'o toimitiapua wetemajimichioopua pehjio —cheerepua oowera wa'a chaanekao. ");
INSERT INTO var_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Eesusia nane'riapa oowera wa'a chiioopua pu'kao, chaanerepua: —Toipuapua pu'ka Riosiwichio wahjipakameka te'tiameo, aapoe nokimichiopua ahpo wahjipakame wetemajikao. Muuua ohso kaawe, pichiwa no'o Noono tehkiwachi teetonaresaa, noochitia teetomitiapua ohso kaawe, Riosi kaaweruma tuuyewarikamera tuuyetopuapua ti'tijoerio. ");
INSERT INTO var_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Piirechi tijoe pooechi nokisinioi natepatiamea, chaanerepua Eesusio: —Paamiraa, siima neeeai aamo ahjama, ahkaoi aamo inisiachi ku'isimia, nape no'o puuyepuapua pehjio, no'o ta'pechi aamo ahjama siimio, tuuyemichiopua pehjio. ");
INSERT INTO var_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Nape Eesusia oowera nane'riamekapa puuua, oowera wa'a chiiamekopa pu'kao, chaanerepua: —Oowera wa'a chiiame muuua, ki te'ta no'o ahjama siminariaio. Muuua aaata yoomuameka tiiamepua, yoomoka ihtoai pukamina ne'nepame, ahka aamo asimiachiche ne'netomitiapua ohso kaawe. Wa'a tiiamea ki te'ta ne'netoamepua ahpo asimichiopua inatariachi. Muuua pichiwa no'o na'naritonariame enesaa, ki wekana erametemua aamo no'o ahjama simiao, wa'a erasaa muuua, aamo pukamina ne'nepameka tiiamepua. Wa'a ikisaamua ka'chi iika no'o Noonochi teetomerimua, no'o Noono tehki yorakesikaopua. ");
INSERT INTO var_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Neipa piirechi taawechio, Apoe Eesusi Paamiraa, pahcha pukeri simiyachi ajawakaipua uhjurawa, eenechi uurepua neipamio, wahjachi ti'tijoe uhjurapuameo. Puuua, paika weerewa aampa oosa mariki ti'tijoe enerepua. Puuua pu'kao, chaaneriaipua: ");
INSERT INTO var_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","—Ki ku'ichi i'ipapuachio, nape tekipanamea paikapipua. Utewa itanekepuapua, i'ipapuame Teekorao, aamo uhjuramichiopua, ahpo tehkichio. Wa'a chaanesapaopua, o'okache uhjurarepua yooma mochiwachiamio, ahpo asimiachiamiopua, nape aampachi chaanesapa pehji: ");
INSERT INTO var_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","—Kaawe aamo neesetoka naaju. Po'wachitia te'teretoame eemea, sapoorika te'teriame ti'tijoerichio. ");
INSERT INTO var_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Kihta i'tomeri eemea naatio: mokewario, toomioi, kaakaoi. Ka'te tehpe weripamitia pooechioi, teepotakaio. ");
INSERT INTO var_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Wahka ta'pechi ajasisaai: “Kúíraaa, Riosichi paparame ti'tijoeri”, chaachapaka teepotapuapua wa'ao. ");
INSERT INTO var_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Riosi ti'tijoeri enesaa, kaaweruma aamo teepoteka aamo asipumapua. Ki wa'a tiame enesaa, ki aamo nehjiamapua. ");
INSERT INTO var_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Aaata ta'pechi ajasitetiai, wa'ache mochisa checherepasa uumatopuapua wa'ao. Kooameoi, kihta chanika ko'kopuapua, ko'kosa iijiwa kiatiaio, ihchi iijipuapua. Tekipanaka oiyamea, ko'koteniamepua. ");
INSERT INTO var_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Wahka mochiwachi ajasisaa, ihta kooame kiatiaa ko'kopuapua. ");
INSERT INTO var_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Wa'a kokoriame mochisoo, sautesaapua, chaanepuapua: “Riosi ye'karia epeche waapi enetoamepua, Apoe Te'ta Yawichi aamo sautena.” ");
INSERT INTO var_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Nape ahka mochiwachi ajasitioi ki nakitiaa, ma'chi puuyasapa uumatopuachio wa'asi, ahpo tarachi pechichisaopua kaakao, chaachapasa uumatopuapua: ");
INSERT INTO var_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Aamoo taamo wa'inekopao, we'e moorewaraoi taamo kaakachi chukipakame, taamo pechichisa uumatoma teemea. Nape nane'remitia eemea, taamo Riosi kaaweruma tuuyewario, amochi u'paria aamo nayewetioopua, Riosie newipameriko enerio eemea, ahpo yawichituwachi mochimeri enerioiopua.” ");
INSERT INTO var_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","I'kao, kajusaapa tuuyekao, chaanerepua ahpo uhjurapuameo tiame: —Pu'ka taawechi Riosi katewiachio, pu'ka mochiwachio ki aamo nahkeriopao, Riosi kokosaria, epeche teeremiitepua pu'kawichioo, ki Sooroma mochiwari ikiriachitia. ");
INSERT INTO var_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Waikao Eesusia, ki e'waka mochiwachi mochikame inatepakao, cheerepua pu'kao: “¡Áii muuu Korasini mochiwachi mochikame! ¡Áii muuu We'saira mochiwachi mochikame tiame! Yooma puuu amochi peenia tiame no'o iintoriao, Tiiro mochiwachi iintokame enesoopua Siironi mochiwachiopua tiame, ki ehpesi suuwe erapamii puuua, napisochi yasipamii puuua, sosotiame wisasori wakirataka, ahpo tatakoririao, suuwe erapakapa. ");
INSERT INTO var_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Nape aamo wa'a noonoriawichioo ki ka'karumao, epeche weruma enemera Riosi kokosariopua, ki Tiiro mochiwachitia, ki Siironi mochiwachitia tiamea. ");
INSERT INTO var_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Muuu Kapenau mochikameai, ¿tewekachi uumpameri maaena eemea Riosieo? Ka'ii. Ohsotia ki wahjiame ruhjiniachi ihpapapuame eemea, ki teesa aiwaniachi.” ");
INSERT INTO var_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Eesusia eenechi naewaka pu'ka paika weerewa aampa oosa mariki ooka ahpo uhjurameri, chaanerepua: —Aamo no'o uhjurari keepuamea, no'o keepuamepua; ki aamo nahkiekamea keepukao, ki no'o nahkiekamea keepukao; puuu ki no'o nahkiekamea keepunarekao, no'o Noono i'ka weeechi no'o uhjuraria, ki nahkiekamepua keepunarekao. ");
INSERT INTO var_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Neipaopua eenechi e'enasaapua puuu paika weerewa oosa mariki aampa ookaa uhjuratiame, tisiwa kaawe erakokaopua, chaachaparepua Eesusio: —¡Paamira, ki teesa peenia teerekapua tamochio, reemonioai aamo teewarachiche cheesochepa, taamo e'wekamepua puuyachaniaa ti'tijoechio! ");
INSERT INTO var_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","—Eje'e —cheere Eesusia—, pichiwapua teware eemea Satanasi ku'kuyao, Satanasionia, tetewakamenia tewekachi o'inia ipatiameo, su'werichitia wichikameo. Puuu ku'iwaripua, i'wa weeechi ohjoamea. ");
INSERT INTO var_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Neeea aamoo, utewari ki'yakamepua ki'yao, pukaeo, pu'ka seepurawa Satanasi utewari newitomichiopua; sayaweoi aamo ki'kitioio, ka'chi aamo ikimichiopua, machirie ki'kitiaiopua, kihta saaemichiopua ko'koameo. ");
INSERT INTO var_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Nape wa'a te'tiai no'o utewari yahcheriaieo, ka'te pukaekamera aamoo oijeramitiapua, ohso kaawekamera aamo kaawe erakopuapua tewekachi mochimerikapapua Riosi ye'karichi, aamoopua teewarao, Riosi iyotaperichi iyotetiamekapa wa'asi. Puuukamerapu, epeche nateyameraa, aamowichioo. ");
INSERT INTO var_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Pu'ka wa'apichio Eesusia, tísia peenia erapaka Riosi Riosiwarieo, cheerepua ahpo Noono tewekachi kahtiameo: —Cheriwema No'nooo, yomatiame itapiti iintuame teekorao, yooma tewekachi iintuameopua, yoomatiame weeechi iintuameopua tiameo, tísia kaawe iintoriopa aamoo, yooma aamo ye'karichi muiniamechi simiyameo, aamo noriwi teeweriopa aapoe ahpo pepeniwachichee pahtenariameoopua; nape nu'nuntika te'tereriame amochi itaka, aamo ye'kariwachi simiyame pahtenarewao, kawiyame ma'chitakamemua pu'kawichioo. Eje'e No'noo, wa'a iintokame muuua, wa'a tiiame inatakamekapa. ");
INSERT INTO var_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Ahpo Noono ahjama nayewasaapa, yooma ahpo keepuameo, chaanerepua: —Yooma ihta itapiti iintuameo, yooma kiatiamenia no'o Noonoeo. No'o tiiao, aaataai ki no'o machiyamepua, no'o Noonoche te'pa kahtiame. No'o Noono tiiaoi tewekachi kahtiameo, neeeche nane'riamepua pu'kao, apoe te'ta Taanarache, ki aaata piirechi. Neeeche puuua tiameo, no'o Noono machinariameo, machitiameraa. ");
INSERT INTO var_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Wa'a cheesaapa ahpo ajawariamechi ku'rikao, chaanerepua, aapoechewichioo: —Kaawechupena eemea, tetewani eemea ehpe no'o ihsiao. ");
INSERT INTO var_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Muuwaeme ehkoriami Riosi nayewaturaa, i'ka aamo tetewa tetewisaapua, tísia kaawe erakomiipua, aapoe tetewapa i'kao, aapoe inamuapua tiame i'kao, nape wa'atia ki tetewarepua. ");
INSERT INTO var_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Seenepi simikameo, piiripi Moise nuurari masitaria, oowera aatiatakaopua Eesusio, chaanerepua: —Masitari, ¿ihtana yoratania ahsepanariaa, ki wahjiame ahjaniameo? ");
INSERT INTO var_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Eesusia nehjiarepua: —¿Achini cheeka iyotetiamepu naaju, Moise nuurariaa? ¿Ihtana pahtena muuua pu'kao? ");
INSERT INTO var_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Moise nuurari masitaria, nehjiarepua: —Wa'ao chaanipua: “Apoe Te'ta Paamirao, nakika tetewipuapua, yooma aamo iikae, yooma aamo utewaeopua, yooma aamo inatarie; aamo piirechiopua, aamo wa'api nakiyachitia, wa'achitia nakipuapua pu'kao.” ");
INSERT INTO var_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","—Wa'atepua, kaawe nehjiakamemua —chaanere Eesusia—. Pu'ka teresaamua, ki wahjiame ahjamamua —chaanere Eesusia. ");
INSERT INTO var_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Waikao, masitari tijoea pu'kao, wa'a ihsiame e'rapaopua, kaawe iinatukerepua Eesusio eenechi: —Puuu no'o piirechia, ¿aatanajuarepua? ");
INSERT INTO var_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","—Keepusao naaju —chaanerepu Eesusia—. Nee. Aaata tijoea Eriko simiriataipua, Eerusareni pooechitu, nape pooechi ihtoaiopua, aaata nanaaramee wepiretiatapua, kiiya mukukame toaka. Wa'a yorasaapu, yooma ichikoneretiatapua, ahkasioi wisasori ahpo chuchatoaoi. ");
INSERT INTO var_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Ehjepamio, aaata neeseriosiai pu'ka wa'apichi pooechi ihtoriataipua, nape wa'a po'yame tewakaiopua, ikicha u'matoriatapua, kiisi ku'ipasa. ");
INSERT INTO var_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Reewi tijoeai wa'ami u'matoaio, wa'achi iintoriatapua tiame ikicha u'matoka. ");
INSERT INTO var_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Nape piirechi tijoe Saamaria eenamea, wa'ami u'matoaio, wa'a po'yame tewakapaopua, tesiwa e'repariatapua. ");
INSERT INTO var_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Ihjia, apechunaka sowijiyoi chuhcheka i'yowesaapua, itapiti aakorieme chuhchekaopua tiameo, puureriatapua pu'kao na'ituriachio. Wa'a ikisaopua ahpo yaasetoachi tekitokao, mochiwachi i'toriatapua, che'cherepaniachio, wa'a che'repariatapua inatekao. ");
INSERT INTO var_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Pu'ka meereo, ooka toomi ma'chipasao, wa'a che'repaniachi teekorao, ki'yariatapua cheekao: “Ía, epeche nateyame enesoo aamo inateriao i'ka tijoe, eenechi eenaio aamo natetemane. Wa'a cheesaa, u'matoriatapua.” ");
INSERT INTO var_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Wa'a tiame nayewesaapa Eesusia, pu'ka tijoe masitario, iinatukerepua: —¿Achini tiamera ihji paika uumatokamea, kaawe iintorepua ahpo piirechio? ");
INSERT INTO var_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Waikao masitaria, cheeka nehjiarepua: —Wee, neeea tesiwa e'reka ku'ikamera maayamenia —cheerépua. —Eje'é —chaanere Eesusia. Wa'a cheesaopua: —Wa'achi iintomitia muuuai —chaanerepua. ");
INSERT INTO var_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Piie taawechi Eesusio, Eerusareni simiyoiopua ahpo ajawaria ahjamao, paikapi mochiwachi asisisoopua, aaata Marata tewaniamee tetewiretupua. Puuu oowitiamea, ahpo ta'pechi paajuterepua pu'kao, Eesusi ajawaria ahjama, ahpo ta'pechio ko'komichiopua. ");
INSERT INTO var_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Marataa ahpo ta'pechio, ahpo piini ahjama ohjoeme eneriaipua, Maaria tewaniame. Puuu Maariaa, Eesusi chokichi yasiparepua, Eesusi nayewa keepunaria. ");
INSERT INTO var_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Nape Marataa, tísia eerina ihsiapapua weeka itapiti yoorakao, chaacharepua Eesusio: —¿Ka'chi e'ranimua no'o piinio ki no'o ku'ioio, piineri no'o tehki ihsioio kooame yorakao? ¿Ki no'o ku'inuretaremua no'o Paamira? ");
INSERT INTO var_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Nape Apoe Paamiraa, nehjiarepua: —¡Aa Muuu Marataa! ¿Tahpitika e'ramemua itapitichio? ");
INSERT INTO var_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Piiripi wa'apipua, itapiti tísia tahpitika erapuamea. Maariaa, pu'kakamera uunarerepua pu'kao, pu'kao, aaatae ki u'yemetepua. ");
INSERT INTO var_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Seenepi simikame Eesusio, tewekachi kahtiame ahpo Noonoma nayeoio, i'ka kajusoopa nayewakao, ihji te'ta Eesusi masitiaa chaachaparepua Eesusio: —Paamira, taamo masitemitia taamooi, Waanichitia ahpo masiterao masiteria, achini cheeka nayeweniamepua, te'pa kahtiame No'noo. ");
INSERT INTO var_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Eesusia chaanerepua waikao: —Aamo Noono nayewenariaa, eee chaachapapuapua: Muuu te'pa kahtiame No'noo, aamo teewaa, te'ta tísia iyoriniame enemitiapua. I'wa weeechi enamitia muuua, aamo ye'kari yasipatemiao. Aamo e'ra ikimitia weeechioi, te'pa tewekachichitia. ");
INSERT INTO var_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Soparame taamo kiamitia kooame senepi taawechi. ");
INSERT INTO var_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Taamo tatakoririao cheriwepuapua, taamo cheriwiachitia taamo na'ara yoorameo. Ka'te taamo tooa ki kaawerumachi taamo ruhjimichioo, taamo newipatemitiamua pukachio. ");
INSERT INTO var_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Wa'a cheesaapa Eesusia, cheerepua tiame Riosichi itaniameopua, i'ka wa'achitarichi aaata iintoriachitia nayewaka, eee cheere Eesusia: —Aaataa, aaata ahpo piirechi ta'perachi eenariataipua naasipa tukaomiahka. Puuua wa'a eenakao, chaaneriataipua pu'kao: “No'o reewemitia ookapioi paani. ");
INSERT INTO var_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","No'o ta'pechi eenakapu aaata poorosimiame, ko'kotemo o'rane pu'kao no'o ta'pechi che'repamiopa, nape kihta iinuekane no'o ko'kotemiao.” ");
INSERT INTO var_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Ta'pechi reweniamea, pichiwa nehjiatarepua nehjiao, nape eee cheeka: “Ka'i, ki werisime e'rani neeeapa, yooma yeetepakame teemeapa wa'asi, kukuchiai, yooma kokochika pe'tiamepua wa'asi. Ki werisinare neeea, aamo kiamiaio.” ");
INSERT INTO var_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Nape reweka itayameo utewa chiiopao, ki kichiwa cheemichioopua, rewemapua ohso kaawe, ki suuwe e'raka e'rarioipua, tísia tukao eenakao. ");
INSERT INTO var_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Nape Riosia ki aaata nahsinepameaapapua, a'chitia keenakooi aamo apochi eenakoiopua itapiti itanemiaopua, naasipa tukaokooipua, aamo kaawe e'reka kiamapua. I'yamitiapua, teimapua waikao. Yeetarachi chochoka sisinamupuapua, wahjonepuamemua waikao. ");
INSERT INTO var_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Yooma wa'a teeka ihta keenakooi itayamea Riosichio, uutepuamepua. Riosichi itasaa, kiapuamemua. Riosichi i'yasaa, teimamua. Riosi yeetarachi aamo sisinamusoo, aamo yeetapumapua. ");
INSERT INTO var_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","’¿Naakona aaata noonoraa ahpo taana paani itasoo, tehtena kiamapua? ¿so'chioi itasoopua ahpo taanao, siinoioi kiamanapua? ");
INSERT INTO var_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","¿ka'waoi itasoo ahpo taana, machirioi kiamanapua? ");
INSERT INTO var_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Weeh, aamoo tatakoriamekoi kaaweruma ki'yame enesoopua aamo tatanao, ¿ki kehkisa epeche kaawe e'raka amochi enanaretare Riosia, amochi yasipamiaopua Riosiwarie? Wa'a iintomeri aamo Noono tewekachi kahtiámea, yooma aaataoi apochi yasipamichio ahpo Riosiwarie, apochi enapaka itaniamechio. ");
INSERT INTO var_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Senepi simikame Eesusia, tijoe yachapate puuua, reemonie ni'opakame. Ihji reemonieme ni'opakamea yachapasaapa, ma'chipasetiaopua reemoniwario, nayewasirepua. I'ka wa'a iikame tetewakame ti'tijoeria, tísia peenia eraparepua Eesusichio, wa'a iintokopa. ");
INSERT INTO var_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Nape ookapi puuu tetewikamea, chaachaparepua: —Áaa, Weseu yahchamekapa apochi, wa'a ihsiamepua, pu'ka wa'api reemo noonora utewarie. ");
INSERT INTO var_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Nape wahjachi ti'tijoe tiamea, ki pichiwa utewarieme maayameopua Eesusio, pu'ka ahpo iintoriaopua reemo ma'chipaka, itapiti ki maaenari itarepua iintomichioo, te'pa eekachi teteipua tiiame. ");
INSERT INTO var_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Nape Eesusia, nane'riapao, Weseu utewarie ihsiame maaeniao, chaanerepua: —¿Achini teeka nasiwata Satanasia ahpo wa'api? Aaata ahpo ijinuwa ahjama nasiwasaa, ¿ki yooma ahpo wa'api soopatarepua? Aaata ta'pechioi, ahpo tatanachi wa'api nasiwasaa, ¿ki ahpo wa'api ta'pechio, yooma ahpo ko'itarepua? ");
INSERT INTO var_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Satanasiai, ahpo wa'api ahjama ijinuwa nasiwasaa, wa'achitia ahpo wa'api soopamapua. ");
INSERT INTO var_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Eeme wa'apiai, ti'tijoeri puuyacho tuusaa reemonio, ¿ihtana utewarie puuyachame eemea? Riosi utewarie chaachapasaa, ki pichiwaniamea no'o chaachapao. ");
INSERT INTO var_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Nape no'oo, Riosi utewarie puuyachame enesoopua Satanasi reemoniwarioo, Riosi utewarirakamera ihsiamepua. Wa'atiao neeea, Riosi utewarie Riosi ye'kari iintapame neeea, pukae inisikao, Satanasio newitopakaopua. ");
INSERT INTO var_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","’Satanasia, aaata weeechi ohjoemekatepua, ahpo karichio ki ookapi aataeka tísia utewaeme, ahpo iinueka kahtiao kaawe neesetoka. Wa'a tiiapa puuu aaata tijoea, ka'chi iika ichikoneme tiiamepua, tísia kaawe neesetoka yasitoamekopa. ");
INSERT INTO var_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Nape piirechi tijoe epeche utewaeme enasoopua ki ookapi aataekao, pu'ka ta'perachi iinueka u'yemiao, newitoka yooma u'yemapua pu'kao. Wa'a iintosaapa puuua pu'ka newitoka u'yeriao, ahpo iintonaria iintomapua pukaeo. Weeh, neee Riosie Tijoe Tijoetutetiamea, pu'ka Riosi te'ta utewarie eenakamenia, Satanasi ye'kari utewarira puipamia. ");
INSERT INTO var_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","’Yomatiame aaataa ki noochi ahjama te'teriamea, no'o seepurawapua. Ki no'o ku'ika Riosimina upapameaapua ti'tijoerio, no'o mamajochakiame puuua, ki noochi enepamichio, pu'kao ki no'oeo chi'rípamichio. ");
INSERT INTO var_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","’Aamo inateka mochitomitia eemea, pu'ka Satanasi reemoniwachio. Ihji Satanasi reemoniwaraa, tijoechio machenasaapua, oowera wahka ooruchi oiyaipua aaatachi ahpo pakimiachi i'yakao; ki ahka tewisaapua pakipuachio, erapamapua: “No'o yasariachio kakupakaipua, ohso kaawe wa'akamera siimania eenechio.” ");
INSERT INTO var_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Wa'ao wa'apitia kakupa tiio tewisaapua, ki wa'a Riosi Riosiwarie eina teeresoopua ahpowichio wa'ao, ");
INSERT INTO var_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","ehpeche oowisani epeche ki ahpochitia nanaarame Satanasi re'remoniwa paajutesaapua, eenechi wa'a pakimapua. Waikao puuu tijoea oowitiameoiopua, epeche ki kaaweruma enepameripua, ki ke'chu ahpo teereriachitia. ");
INSERT INTO var_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","I'ka wa'a tiame nayeoio Eesusio, piiripi oowitiame wa'achi ihsiameai keepukao, sisinarepua cheeka: —¡Aamo naawatekamea, tísia kaawe e'ramejuarepua, puuu aamo chiiteka weripatekamea! ");
INSERT INTO var_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Eesusia chaanerepua pu'kao: —¡Te'ta kaawe erakoamea, naati puuúa, Riosikamera e'weka mochitoamera, pu'ka chiiakamera keepuamera! ");
INSERT INTO var_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Wa'a ihsioi Eesusio masitekaopua pehjio, ti'tijoeria epeche epecheche enetorepua napawikao, tísia muuwepakaopua Eesusi norikameo. Wa'a iikopa wa'ao, Eesusia, o'inerepua masitekao. Puuua chaanerepua: —Ehpe taawechiami ti'tijoeria, te'ta no'o peenia ihsiwae itayamepua no'o naaniatiwao. Nape ki tetewitepuamepua wa'asio no'o naaniatiwaopua no'o peeniasiwaeo, naatiche enemeripua no'o naaniatiwaa, Oonasi ikiriaka tiiame, enemeripua pu'kawichioo, no'o naaniatiwaria. ");
INSERT INTO var_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Wa'achitiao ehkoriami Oonasi ikiriaa, ehkoriami Níniwe taawechiamiwichio eneriamepua naaniatiwario, Riosie wa'api uhjuraria ahpo ma'chitameopua, wa'achitia ehpiami taawechiami neeeai apoe wa'api Riosie uhjurakamepua ahpo ma'chitario, ehpiamiwichio no'oo ti'tijoeri nayewemichioopua. Puuu enemeripua naaniatiwaria, aatanakoo te'ta no'o ma'chitamea, no'o Noonoo no'o mukukoio, eenechi no'o ahjaterioio. ");
INSERT INTO var_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Wahka ihtoriachi Riosi ti'tijoeri te'ta katewiachio, puuu yawichi oowitiame Tetuyachi o'inia eenakamea, Saromoni te'ta peenewari machiwari ne'nemia eenakamea, te'ta wenejimeripua aamoo, ehpe taawechiami mochiriameoo. Wa'a iintomeri puuua, kai waapi o'inia eenakamekapa Saromoni tísia peenewari keepumiao, eemeo ki ahpo iintoriachitia te'teriopa, no'oo epeche weruma tiiariemekoio ki Saromonichitiao, no'oo tísia aamo chokichi oioiopua, kiisi no'o ewakoamekopua no'o aamo masitiao, kiisikoio, no'o keepunarekao. ");
INSERT INTO var_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Wa'achitia Níniwe ohjoekameai, aamo wenejimapua tiameo, Riosi te'te ti'tijoeri katewechio. Wa'a noonoimapua aamoo, tísia pichikeriapa Oonasi cheeriaopua, aamoo, kiisi no'o pichikeriamekopa no'o masitiao, no'o epeche tísia weruma tiiariemekoipua, ki Oonasichitia. ");
INSERT INTO var_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Waikao Oonasi ikiria teereria nayewasaopua, taamo weerewarachi tiia nayewakapua i'ka wa'achitarichio, eee cheekao: —Tahjeraa, ki noriwi weraniamepua itapiti teereo, te'pa weraniame ohso kaawe, weeresi uutapamichiopua, wa'a enapameopua uutapemichiopua. ");
INSERT INTO var_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Puusia, tahjeraka tiiamepua taamo weerewachio, pukae tetewiniamepua te'ta kaawerumara pahtewario. Kaawerumache aamo inatame enesoo, puuu tahjewaa amochi tajimeripua, kaawerumachiche aamo oiteka. Nape ki i'ka masitewa kaaweruma pahtewari uusaamua, ki kakupachi oimamua, tukapachikamera. ");
INSERT INTO var_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Wa'a teesoo, kakupachi mochitonariaa, ki toipuapua choipamichioo, pu'ka kaaweruma pahteriaopua, amochi uuriao. Ki wa'a teeresaamua, tukapari enemamua amochio. ");
INSERT INTO var_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Yomachi amochi uutapame enesaamua, kihta ki'tiameomua noriwi ihsitiameo, kaawerumache enemamua waikao amochio, yooreminao, aamo itapiti tahjerae, uutapaniamechitia. ");
INSERT INTO var_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Eesusia kajusoopa wa'a naewakao, aaata parisero tijoe ahpo ta'pechi paajuterepua, ahpo ta'pechi ko'komichioopua. Eesusia, pu'ka parisero ta'perachi asisaapapua, chitokae poiparepua ko'komiao, wahjachi ahjama ko'komiao. ");
INSERT INTO var_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Nape pariseroa, ki paanikoriamekopua Eesusio ko'komia, Moise nuurari nokiwachitiao, iinatukerepua: “Achina tiiachipa ki paanikokamua ko'komiao?” ");
INSERT INTO var_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Wa'a chiiopa pu'kao Eesusia chaanerepua: —Eeme parisero ti'tijoea, aampache kaawe pakoyamepua pehtorio, nape yooreminao wa'atia toayai, ki papakotiame. Wa'ache te'tiame eemea yooreminao, ki papakotiamechitia, aamo yooreminao eemea, pochikame kahtiame eemea, ki kaawe noonoitiame ichikoka, yooma ihta ki ka'karuma tiame. ");
INSERT INTO var_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","¡Ki ijinatame eemea! ¿Ki nane'riame eemea, ma'chi weerewa netekameo, yooremina tiame neteriamekopua? ¿Ki nane'riamekosa eemea, ma'chi ahpo weerewachi papakoamea, ahpo yooremina tiame papakomerikopua? ");
INSERT INTO var_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Pukaepa eemea, tiopachiwichio toomio nehjaio, iikachi kaaweruma e'raka kiapuapua, ki ti'tijoerikamera, aamo kaawe e'remichiopua. Wa'a nokisao eemea, yooma piipateka enemii eemea, yooreminao, ma'chio tiameo. ");
INSERT INTO var_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","’¡Áii eeme parisero ti'tijoea! Eeme oosa mariki simiyame poanatakiame Riosiwichioo, yooma ihta aamo echaria i'ipaopua, meenta saawaraopua tiame, ruura i'yowiopua tiame, yooma ihta rahtatiame koi'wameopua tiame, nape wa'a nokakai eemea, ki tesiwe e'riame eemea ti'tijoeri ichikoekao. Wa'a te'tiapa eemea, ma'chiame tiiame eemea, ki pichiwa nakiyamekopua Riosio. Ki ichikoka mochitomete eemea ti'tijoerio, pu'ka Riosiwichio poanatakia ki'yariwaoi, ki toaka kiatoka. ");
INSERT INTO var_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","’¡Áii eeme parisero ti'tijoea! Eemea napawikarichio, te'ta weruma teerewame mochipachi moomochikonariame, ahpo yooreka teteipuawichiopua ti'tijoerieo. Pooechi ohjoiopua eemea, yooreka teepotejeranipua. ");
INSERT INTO var_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","’¡Áii eeme wahjipame toaniachika te'tiame, wa'ami uumatoame ti'tijoeria, tísia eiwepuatiachi tekeyame ki wa'a tiame maaekaopua teereo. ");
INSERT INTO var_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Wa'a chiiopa Eesusio, piiripi puuu Moise nuurari masitaria, chaanerepua Eesusio: —Masitari, parisero ti'tijoe wa'a cheekaomua, taamo nekamutenamua tiame. ");
INSERT INTO var_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Nape pu'kao tiame Eesusia, chaanerepua: —¡Áii eeme iyoteri ti'tijoeai! U'matoka pehtiame iyoriwa yorapuameopua ti'tijoerio, Moisetaru nuurari chiia na'roakao, aamo wa'apioi, kiisi kajume tiiaopua iyorikao. ");
INSERT INTO var_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","’¡Ai eeme!, ehkoriami Riosi nayewatura wahjipakame toatiachi tosawiamea, te'ta nakiriamechitiapua pu'kao. Nape pu'ka Riosi nayewaturao aamo wa'api ehkoriami mochiriame ko'yakamekoipua pu'kao. ");
INSERT INTO var_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Wa'a te'terekao eemea, kaawe e'riameka nooka eemea pu'kao, pu'ka ko'yariopua, ehkoriami Riosi nayewatukameopua, pu'ka wahjipakame toatiachiopua, senepi paaumparichi tosawesikaopua. ");
INSERT INTO var_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","’Pukaepa Te'pa Kahtiame No'noa, nane'riapa puuua ehkoriamio, cheerepua: “Wa'a uhjurenane no'o nayewatura, neipa no'o ajawariaopua tiame, tuuyetumeri. Puuua, ko'ipuamepua ookapio, wahjachio na'ara yoramia, naanaripuame.” ");
INSERT INTO var_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Wa'a nokayamekapa eemea, wa'achitia ki kaawe noonokame eemeai, aamo ehkoriami noonowiriachitia. Yooma ehkoriamisi o'inia Riosi nayewatura ko'itiameopua, ");
INSERT INTO var_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Aaweri yasaria taawechi o'inia, ahkasi Sakaria ooka Riosi iyoriwa tepawetiachiami u'matoi meritiachisi ko'itiameo, yooma eeme i'ka ikitiamewichioo, te'ta Riosi kokosariraa, amochi wichimeripua. ");
INSERT INTO var_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","’¡Áii eeme Moise nuurari ma'masitari! Tísia kaawe nane'riai eemea, achini teeka kaawe mochitopuame Riosichio, ki wa'a te'tereka mochitoamepua. Wa'a te'teriameai eemea, ki toani eeme wahjachioi, kaawe te'tereka mochitomichioopua pu'kao, Riosichio. ");
INSERT INTO var_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Waikao o'inia, parisero ti'tijoea, Moise nuurari ma'masitaria tiame, nekaweka tetewarepua Eesusio. Waikao o'inia wa'anao, ki ta'iria yahcharepua Eesusio, muuwaeme itapiti iinatukeka, ");
INSERT INTO var_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","ki kaawe chaachasoopua pu'kao, chapisa wenejimiipua te'ta isaeri pa'pamirachiopua. ");
INSERT INTO var_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Piie taawechio ki ookapi napawioiopua, ahkasi apochi momotochikao, Eesusia wa'a e'nakameo, o'inerepua masitekao. Pahchao o'inerepua cheekao: —Eemea aamo inateka mochitopuapua, pu'ka parisero ti'tijoe masitiao, ka'karuma masitiameka chaachapameopua ki ka'karuma erakoka masitiaio. Puuu masitiaa, rewaruraka ikiyamepua, ti'tijoechi mu'ipakao. ");
INSERT INTO var_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Pu'ka ahpo masitiai ki yooreka mochitoaa, noriwi noonowiriaopua tiame, te'ta Riosi katewiachi taawechiopua, yooma ma'chitapuaitemeripua. Kihta wa'atia itipipuaitepua, ki nane'rekao Riosieo. ");
INSERT INTO var_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Wa'achita eemeai wa'achi te'teriame enesaa, yooma noriwi aamo nayewariaa, yooma noriwi aamo noonowiriaopua tiameo, ma'chiachi toapapuamepua puuua ma'chitakao, taajenachi. Wa'achitia puuu, yooremina yeetaeka ihchi naewatiameai, karijampa weripaka, ma'chitaka sisinamuniameka teeremapua. ");
INSERT INTO var_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","’Pukaepa neeea aamoo, no'o kaawe e'riao, aamo chaanenane, ka'te seeweka tetewamua ihta ti'tijoerio, aamoo na'ara yooroiopua, aamoo ahkasi merinarioiopua, aamo wa'a chaachapaiopua, ka'chi yorameripua aamo iikao. ");
INSERT INTO var_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Nape neeea aamo chaanenapua aatanakamera seewemerio: puuua Riosipua, Apoe taamo Noonokamera tewekachi kahtiame. Pu'kakamera seewemeri ki kaawe noonoikamea, pu'kao Apoe kokosariao, taamo iikachikamera kokosamekopua pu'kao, te'ta kokosarichi ihpapamaopua, ki wahjiamesi tajayachiopua na'i, wa'a ki wahjiamesi aiwaniame teeremiachi. Pukaepa Riosichikamera iyorika mochitopuapua, ki wa'a tiiame Riosi kokosari ikimichiopua amochio. ");
INSERT INTO var_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","’¿Tuchikina kehki nateyame eemea? ¿Ki ooka toomichi wa'api nehjiwamepu mariki tuchiki? Nape ku'ita kehki nateyoi Riosia, ki natakepamepua pu'kao. Ki ku'ita epeche nateyame eemea Riosiwichio. ");
INSERT INTO var_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Eemea ki teesa nakiwamepua Riosieo, ahkasi aamo kuupaoi kehkitaka ne'neka. ");
INSERT INTO var_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","’Ka'te suuwe erapa noochio, aaata ti'tijoerichioi. Aaata noomina ahpo ma'chitame ti'tijoerichio, neeeai Tijoe Tijoetukamea, noomina te'terio ma'chitamania pu'kao, no'o Noonochi tewekachi kahtiamechiopua, yooma no'o Noono tewekachi ku'iwari, tetewachiopua tiame. ");
INSERT INTO var_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Nape ahpo wa'iname ti'tijoerio, ki noomina te'terio tuukao, wa'achitia neeeai, no'o wa'inemapua pukachio no'o ahjama teerewao, yooma no'o Noono tewekachi ku'iwari tetewachio. ");
INSERT INTO var_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","’No'o chiia na'arekamea, Riosieo cheriweme tiiamepua pehjio, nape aaata Riosi Riosiwarie ahpo nayewenia ki e'wiame enesaa, kiisi cheriwepuame puuua Riosieo, kiisi e'wekapa ahpo nayewia Riosiwario. ");
INSERT INTO var_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","’Nape no'o ahjama te'tiamea, wahka i'totiaipua isaeri napawikarichi wenejikao, ka'chi eramitia eemea, aamo nehpupaka nehjiamiao, ");
INSERT INTO var_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","puuu wa'api Riosi Riosiwari amochi yasitoame, ihsimeripua aamo ku'ika nehjiatekao, aamo wenejiwa iinatukewao. ");
INSERT INTO var_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Eesusi masitioio, piiripi wa'achi keepuamea, senawato chaacharepua Eesusio peyachi, eee cheeka: —Masitari, no'o ku'ika chaanemitia no'o pa'chio, taamo noono tooeria mukukao, naachutamichio. ");
INSERT INTO var_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Nape Eesusia pu'kao, nehjiarepua: —¿Aaataekona weratiamenia pu'kawichio aaata nayewemichioo? ");
INSERT INTO var_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Wa'a cheeriopua pu'kao, Eesusia cheerepua yoomao: —Aamo inateka mochitopuapua, te'ta ikotuwachi simiyameo; ta'iria mochiniamea, ki itapiti te'ta iinueniamepua. ");
INSERT INTO var_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Waikao Eesusia, i'ka wa'achitarichi nayewerepua. Waikao o'inerepua cheekao: —Aaata tijoe ahpo echariachio, ki ookapi paarasatiamea, ki ookapi apechunamiapa i'ipario, ");
INSERT INTO var_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","e'rariatapua: “¿Akatia katewetane i'kao? Ki iinuene ahkao.” ");
INSERT INTO var_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Ehjepao erapariatapua: “¡Aa! Na'sonamane naaju no'o i'ipari toaniachio, epeche weruma ajawamane ihsisao, pu'ka no'o i'ipamiao, yooma ojowimichiopua wa'ao. ");
INSERT INTO var_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Wa'a iintosapaonia, chaanemania no'oo: Nee, tisiwá paarasatiame muuua, ki ku'itapisiwichio. Resipusa ehpeo, ta'iria ko'kósa, ta'iria iijísa, pahkoteka pu'séresa.” Wa'asa chaniriatapua. ");
INSERT INTO var_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Nape wa'a e'rariopua pu'kao, Apoe Riosia chaaneriatapua pu'kao: “Kiisi inatame muuua. Wa'a e'rakamekapa muuua, ehpe tukao mukima muuua. Puuu aamo paarasatiaa, piirechi aaataoi, kiapuame puuua”, chaaneriata Riosia. ");
INSERT INTO var_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Waika ahpo keepuameo, chaanere Eesusia: —Wa'a ikiyame pu'ka tijoechi oowitiamechi tiame ahpochewichio erakoamechio, ki nakika mochitoamechiopua, Riosichikamera paarasario. ");
INSERT INTO var_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","’Pukaepa aamo chaanena neeea, ka'te epeche erako eemea, aamo ko'kometiowichioo, aamo chuchamiaoi wisasorio. ");
INSERT INTO var_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Te'ta pichiwa ahjaniamea, ki kooamee ahjaniamepua, wisasoriai, chuchaniameo. ");
INSERT INTO var_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Tetewame eemea kaarachio, ki echayameaipua, ki i'ipameoipua, ki nuutiameaipua ko'kopuameo, tewiteniamepua Riosieo ko'kopuameo. Riosiwichioo eemea, epeche nateyamepua, ki ihta tuchikichitia. ");
INSERT INTO var_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","¿Aatana eemea tahpitika e'rai iintonaria, aamoe waminatamua aamo ahjario, piire taaweoi ehpecheo? ");
INSERT INTO var_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Ka'chi iika waminame teeresaamua aamo ahjario piie taaweoi, ¿achini iika pu'ka aamo tahpitika e'rarieo, kiamamua ihta aamo ahjariwachi nakisimiaopua, ihtoriachisi taawewichio? Ohso kaawe Riosichi paparapuapua pu'kao, aamo nakika yasitoao. ");
INSERT INTO var_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","’Ne'nemitia to'iwe seewarao, tísia peeniatiamekopua pu'kao, kihta tekipanameaipua, kihta ikutamekoiopua ahpo peeniatiame teerepuawichioopua. Wa'a tiiamepua. Saromoniai yawichikaipua, ki epeche peeniatiame wakiratakamepua, ki pu'ka seewa tísia peeniatiamechitiao. ");
INSERT INTO var_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Riosio, to'iwekoipua pu'kao, tísia peenia tiame teewiame enesoopua pu'kao, ¿kehkisa epeche aamo wakiratetarepua, yooma kiatarepua itapiti aamo nakiwiaoi? ");
INSERT INTO var_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Pukaepa ki te'ta erakomete eemea, aamo ko'komiawichioo, aamo iijimiawichiooi. ");
INSERT INTO var_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Pu'ka wa'a tiiameo, ki Riosichi te'teriameche wa'a erakoamepua. Nape aamoo, Riosi taamo Noono tewekachi kahtiame nane'riamepua aamo itapiti nakiweka mochitoao, apoe aamo ihsiamepua aamo ku'ikao. ");
INSERT INTO var_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Wa'a teeso eemea, Riosi neesetowachi mochitonarepuapua, pu'kakamera nakika yooraka mochitoka, apoe ihsiamekopua yooma ihta aamo nakiwia ki'yakao. ");
INSERT INTO var_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","’Aamoo noochi paparaka mochitoameo, tísia nakika yasitoamenia, no'o pupuku po'wachitia neesetoka tetewamekopao, ka'te seeweka mochitomitia eemea Satanasio, ihtaoi ki kaaweruma aamo na'ara yoranarewao. Aamo Noono tewekachi kahtiamea, tísia kaawe aamo neesetonariamepua ahpo ye'karichi mochipuawichioo, tísia pu'sereka wa'a tiiame e'rariapa. ");
INSERT INTO var_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Nehjitiame maaemitiamua yooma aamo iinuekaopapua. Riosi tooemitia pu'kao, ahjae ihsimichiopua pu'kao, aaata kiamichiopua ahpo kianariao, ku'ipuame nakiyameo. Wa'atiaomua, tewekachi nuutepanimua, kakupa, ka'chi ikiyachi, ki yemipachi, ki'tiachioipua ichikoameo. ");
INSERT INTO var_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Aamo maayachi aamowichio nateyame iinuwao, wa'a yasima muuuapu aamo inatario, wa'a kahtiachitia aamo iikaopua. ");
INSERT INTO var_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","’Ka'te kochika mochimitia eemea, ohso kaawe pusakame mochipuapua, ");
INSERT INTO var_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","aaata ahpo teeko neewiwachi enameri puuyamechitia te'terepuapua, enasoche yeetapukepuawichiopua pakimichioo. ");
INSERT INTO var_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Tísia peenia erakotariare ahpo teeko yorakiamea, wa'a te'teriame tewitiapua ahpo teekoeo. Teekoraai tísia kaawe eratarepua tewisaa, teekoraai tísia kaawe e'reka ajawemeripua kooameo, ko'kopuawichioo. ");
INSERT INTO var_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Ahpo teeko naasipa tukaomi ahka eenakoio, tísia kaawe erakotarepu ahpo teeko yorakiamea, pa'a marikarowa ahka eenakoio. ");
INSERT INTO var_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Eesusia i'ka wa'achitari masitewari chaanerepua tiameo: “Aaata petechi teekora nane'riame enesaa, achini keenako ahpo ichikuepuameo, pu'ka keenako ki kochika yasimiipua, ki ahpo ichikuepuawichioo.” ");
INSERT INTO var_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Wa'achitia eemeai, pu'pusame mochitopuapua ohso kaawe, senawato enamaoi neeea, a'chitia keenakooi. ");
INSERT INTO var_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Waikao Peeroa iinatukerepua Eesusio: —Masitari, ¿taamochewichio ohjoarepu, puuu wa'achitari aamo cheeriaa, ki wahjachiwichioopua tiame? ");
INSERT INTO var_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Eesusia chaanerepua waikao: —Aa, ¿ki pahtekakosa inamukame eemea, ahpo teeko kaarira inatiame no'o aamo nayeweriao? ¿Ki yooma aaatachitiapua amochitia noochi paparameopua, itapiti yoramichio no'o toowewa nuurewaopua, ahkasi tewekachi no'o no'rasoopua eenechi no'o eenachisiopua? Wa'achitia aaata paamira i'wa weeechi ahpo ta'pechi mochikame kianiame ahpo seekaere kaawe neesetomichioo, mehka weeechi simisoo, wa'achitia neeeai tewekachi no'rasaa, yooma aaata noochi paparameo, yooma napati ahpo inateka mochitomichio toimania pu'kao, no'o kariwao. ");
INSERT INTO var_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Pu'ka ahpo teeko kaarira kaawe neesetoka mochiriamea, tísia kaawe erakomeripua ahpo teeko enasoopua, pu'ka ahpo teekoeo tísia kaawe e'reretiapaopua, ahpo tísia kaawe neesetoriaopua, ahpo teeko ta'perao. ");
INSERT INTO var_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Pichiwa chaaninia pu'ka teekorao, tísia kaawe iintomerikopua pu'kawichioo, epeche weruma neesetori kiameripua pu'kao, ahkasi yooma ahpo iinuwaoi. Neeeai wa'achitia iintomeripua eenechi enasaa, tísia kaawe noonoikameopua no'owichioo, no'o neesetokeriaopua tísia kaawe yooraka inateriopao. ");
INSERT INTO var_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Nape aaata ahpo teeko seekaerewao, ki enameri maaeka ahpo teeko ki kaawe noonoikameo, ki ihkokekaopua ahpo wahjachio, ahpoche kaawe ko'komia inatakameopua, nawajikache yasaka pu'serekameopua, ");
INSERT INTO var_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","apoe teekoraa senawato enasaopua, wa'a nokayame tewisaopua, kiisi cheriweka tísia kokosameripua pu'kao, yooma ahpo seekaerewa ahjamaopua, ki ahpo e'waka mochiriameopua. ");
INSERT INTO var_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","’Aaataai ahpo teeko seekarewachitia tiiameo, nane'riameai tísia iyoripua ahpo teeko iyorikameo, oowera yasakameopua kihta yooraka ahpo nuureretiao, epeche weruma kokosari nakiyamepua. ");
INSERT INTO var_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Nape kihta nane'riapa ki yoorakamea ahpo teekora nuurariao, ki te'ta kokosapua nakiyamepua. Epeche machiyame ahpo nuurewao, epeche iyorimete puuua ahpo nuurewao. Epeche kianiamea neesetomichioo, epeche iyoriwa itaneniamepua ahpo neesetopuaichio tooweretiao. ");
INSERT INTO var_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Eesusia, simiteka masitekao cheerepua: —Neeea, noochi kaaweruma paparawa tajenatemia eenakamenia amochio. Tísia pu'seriamii neeea, amochi ti'tijoechi ooweruochiopua tiameo, tajenakame enesoo noochi paparario. ");
INSERT INTO var_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Neeea, ki nu'uti aiwarichi u'matomeripua, ti'tijoeo ooweruopua tiameo, te'ta piipakame itipimichio tatakoririao. Ahkasi kajuyachisi iintosaapua tatakori natetekao, tísia aiwamerimua noochio, ki ahjame eraniameo, ahkasi kujuyachisi yoranariapa aamo tatakoriria natetekao. ");
INSERT INTO var_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","¿Ta'iria yoomahka mochitemia no'o eenakame maayame eemea, napati inatakaopua noochio? Ka'i ki wa'a teeremeripua. Neeea ti'tijoeo ooweruopua tiameo, napati yoomahka paajutemia eenakamenia noochio, noochi paparaka mochitomichiopua. Nape ti'tijoeria, ki yoomahka napati paparaka mochitomeripua noochio, ki yoomahka napati no'o chiia pichikemeirikapapua. Wa'a te'tiapa ti'tijoeria, ki napati ahpo kaawe e'reka mochitomeripua, ahkasioi tísia nekakomeripua apochio. Apochi nekakoapa puuua, ahkasioi poanatumeripua apochio. ");
INSERT INTO var_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Wa'a iikaopua, mariki mochikachio piiripi ta'pechio, ooka wa'api no'o nakitarepu wa'ao, wahjachi paikaa ka'ikoio. Wa'a tiiapao, ahpo poanatumapua ahpo poponiemea pipiniemeopua tiameo. ");
INSERT INTO var_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Yayawaraa, ahpo tatanachitiaoi, ki napati noochi paparamapua; tatanaraai, ahpo yayawachitiao, ki napati noochi paparameripua; waasiraai, ahpo moniawachioi oowitiameo ki kaawe nakika tetewimapua pu'kao noochi paparamekopapua pu'kao; moniawaraa, ahpo waasichio, wa'achi teeremeripua pukachio, ki noochi paparemekopua pu'kao. ");
INSERT INTO var_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Eesusia muuwari simiteka naewakaopua pehjio, cheerepu ti'tijoerio: —Eemea, ariyachi toomaritame tetewapao, yukimio tuusoo, yuyukuamepua pichiwa. ");
INSERT INTO var_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","I'ka weee tekiyanatikia eejesoopua, tataremeri asimeriko aamo tuusoo, pichiwa wa'a teeremeripua. ");
INSERT INTO var_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Yooma pu'kao machiyame enesaa eemea, ¿achini iikai ki pahteka tetewame eemea ehpe taawechiami amochi ikiyao, yooma no'o yooraka inisiao, amoe pusie tetewaio? Wa'a teesoo, ki pichiwa nane'riai chaachapame eemea itapiti ikimiao. Wa'a tiiapao eemea, oowera wihkuaka chaachapame eemea, aamoe wa'apioi. ");
INSERT INTO var_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Wa'a cheesaa Eesusia, cheerepua tiameo: —¿Achini iikai ki aamoe wa'api ahpo katewena eemea, ahpo kaawe teerepuawichioopua ki kaawe ahpo nokariao, te'ta Riosi nakiyachitia? ");
INSERT INTO var_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Aaata peereichi aamo i'tonaresoo, ohso kaawe ke'chu peereichi aamo i'tonioi, katewepuapua aamo wenejiame ahjamao. ");
INSERT INTO var_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Wa'a i'totiame enesaapamua, ki machenama muuua wa'ao, ahkasi aamo ki kaawe iintoria yooma natetesapa. Pukaepa neeea aamoo, chaaniamepua: Ke'chu asioi kajuyachi Riosi te'ta peereio, Riosi ahjama aamo katewepuapua yooma aamo ki kaawe iintoriopua natetepuameo, kihta kokosari amochi teerepuawichiopua Riosi peereirachio. ");
INSERT INTO var_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Pu'ka taawechiami tiameo, Eesusichi e'enarepua kooria Eerusareni o'inia, Eesusio ahka kahtiachiami. Puuua chaachaparepua Eesusio, Piirato ahpo soontaroeo, Arirea e'enakame ko'yakapua, Riosiwichio mananioiopua animari ko'itiame, i'isaeri tioparachiopua. ");
INSERT INTO var_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Wa'a tiiame tuuyetiapa Eesusia, cheeka iinatukerepua ahpo masiteka ihsiaopua: —¿Aatia tiiachipa ko'iretiarepua? ¿Epeche tatakoririapa, ki wahjachi Arirea mochikamechitia? ¿Riosi kokosari iintokame maaena eemea Piiratoo? ");
INSERT INTO var_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Ka'i puuua. Riosia te'ta kokosamepua nape wa'atia, yooma ki apochi e'enakameopua, wahjipakameka teewiamepua pu'kao apochiopua poana, ki seenampasi wa'asi. ");
INSERT INTO var_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","¿Ihtana erakona eemea, pu'ka oosa mariki osanao mesuka wahjipakameopua Siroe chupakarichio, epeche tatakorikapa ki Eerusareni mochikamechitia, wa'a iikame maaena eemea? ");
INSERT INTO var_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Ka'i puuua. Ki wa'a te'tereriapa wa'a iikamepua. Nape aaata eemea, ahjame ohjoaiopua pehjio, ki Riosichi paparaka aamo tatakoriwa toinaresaa, wahjipakameka tiiame eemeapa Riosiwichioo. ");
INSERT INTO var_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Eesusia waikao, ti'tijoeo ooweruopua tiameo, eechichuna echiwamechitiaka nayewerepua: —Aaata tijoea, piiripi eechichuna echiwa echariataipua, taaketaoipu e'raka. Tehpe neipamio, taakerio o'raka simiriataipua ne'nemia. Nape ne'nioio, piiripioi ki taakeriatapua. ");
INSERT INTO var_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Wa'a tiioopa pu'kao, chaaneriatapua ahpo moromatuao: “Paika paaumpari i'tonanepa ejenakao, ki tewaka piiirípioi i'ka wauri taakeriao. Po'tanapuapua ohso kaawe, kihtawichio eina teeremichiopua wa'ao.” ");
INSERT INTO var_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Nape pu'ka echiwa inatiamea, chaaneriatapua echakameo: “Toimitiao pehji. Itapitioi yahcheka kaawe yoramane wejikekao, taaketaoipu wa'a yoratiaa. ");
INSERT INTO var_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Taakesoo eenechi paaumparichio, wa'atia toipuapu. Ki taakesoopua waikamio, po'tanapuapu.” ");
INSERT INTO var_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Piie taawe resipuniame taawechio, Eesusia napawikarichi ihsiriaipua masiteka, ");
INSERT INTO var_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","wa'achi yasariaipua piiripi oowitiame, tuumuwari kokoriame. Wa'a ikiteriaipu na'arari tijoeturia, oosa mariki aampa osanao paaumpari i'toriaipua, ki werisika riisakao. ");
INSERT INTO var_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Eesusia wa'a kahtiame tetewapao, apochi enanuresaopua, chaanerepua: —Oowitiame, saukame itipiamemua, aamo kokoriao. ");
INSERT INTO var_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Wa'a cheeka ahjachi seekarepasoopua, yachapakame itipire ooitiamea, kaawe oisirepua waikao, riisasipakao. Wa'a ikikapa oowitiamea saukao, tísia kaawe e'reka nayewerepua, cheriwema Riosio. ");
INSERT INTO var_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Nape wa'a napawikarichi paamiratuamea, tísia nekarepua, Eesusi iintoriawichioopua resipuniachi taawechio, pu'ka oowitiame sautekao. Wa'a iikapa puuua, chaanerepua wa'ao yooma ti'tijoerio: —Tekipananiamea, puhsani taawechepua, pu'kache taawechiami e'enamete eemea, aamo sautemiawichioo, ki resipuniame taawechi. ");
INSERT INTO var_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Eesusia waikao chaanerepua: —¡Wisikuame eemea! ¿Ki nerojimia i'toamekosa eemea animari ko'rerachi ma'chipasaopua, aamo oisiwao, aamo uuruoikosaoiopuá, resipuniame taawechikooikoopua? ");
INSERT INTO var_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Wa'a nokiwachi enesoo, ¿aatia ki sautepuame ohjoare ihji ooitiamea, resipuniame taawechikoopua, i'ka ooitiameo ehkoriami Aurani tetejimarichi eenamekoopua, ki ehpesi kokoretetiameopua Satanasieo? ");
INSERT INTO var_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Wa'a chiiopa Eesusio, puuu a'chi chaachapamea, ahpo newitotio eraparepua, nape wahjachi ti'tijoeria, ohsotia peenia erakorepua, yooma wa'a, itapiti peeniatiame iintoriawichioopua. ");
INSERT INTO var_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Eesusia simitekaopua masitekao, cheerepua: —¿Ihtanaka tiametatane Riosi ye'karichi simiyameo? ¿Aatia chanika naewatane pu'kao? ");
INSERT INTO var_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Puuu ye'karia, wacherai kuuu pahchiraka tiiamepua. Núú'utikoipua pahchirao, echitiaopua ki nu'uti weripame, ahkasi tuchikioi ahjachi ta'sotachi. Wa'a tiiame Riosi ye'karia, ki weruma o'inetiaipua, ki ku'wichisi enepame, ki ookapi ti'tijoeri ohjorepuachi. ");
INSERT INTO var_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Eesusia cheerepua tiameo: —¿Ihtanaka tiameko tuutania tiameo, Riosi ye'kario? ");
INSERT INTO var_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Ihjia, rewaruraka tiamepua, ooweru paanitameo, paatusi yahchia a'pomichiopua, muuenati mu'ika. Wa'a iika weruma mehtamepua, Riosi ye'karia. ");
INSERT INTO var_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Eerusareni simiyai Eesusia, muuwaeme mochiwachiami masitesirepua, o'okapi mochiwachiami tiame. ");
INSERT INTO var_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Wa'ami simika masitioiopua, aaataa iinatukerepua: —¿Paamira, páikapijoarepu, tatakorichi newipameria? ");
INSERT INTO var_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Eesusia chaanerepua: —Riosi ye'karichi muirachia, ki weeresi puuua. Wa'a muiniamea ki oowera aaata pakime tiiachipua ki Riosi reesiseri iinuesaa, wa'a tiiachipa wa'ao muuwaeme muinariaiopua, ka'chi iika muiyamepua. ");
INSERT INTO var_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Nape taamo Noono tewekachi kahtiame yeetepasaapua wa'ao, aaataoi ki reesisemapua muimichioopua wa'asi. Pu'ka taawechiamio muuwaeme enapoiopua chaachapakao: “¡Paamíra, taamo yeetapukesaaa!” Wa'a chaachapoipua paamiraa, chaanemapua: “Ka'i, kiisi aamo macheyamenia aamoo, ahka e'nameo.” ");
INSERT INTO var_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Nape aapoea, chaachapamapua: “¿Nape Paamira, ki pirena ko'kakame teeme, aamo pooechi ihtoai taamo masiterioio?” ");
INSERT INTO var_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Nape neee Paamiraa pu'ka taawechio chaanemania pu'kao: “Ka'i, kiisi aamo maachinia, seesenu eemea noochio. Yaapi se'wisa eemea noochio, ki ka'karuma iintosiame ti'tijoeri.” ");
INSERT INTO var_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Wa'a teeremera kajuyachiopua, no'o eenechi enasoo. Waika taawechio eemea, ki sewina erapakamea iikachio tatakori toakao, naarakoma eemea, pu'ka aamo ehkoriami Riosi nayewatura tetewapaopua, wa'a mochikame yooremina, Auraniopua, Ihsaopua, Aakowoopua tiame, ka'chi ikime e'rapa eemea, pu'ka mochikachi muinariaio. ");
INSERT INTO var_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Wa'ao waika taawechio wa'ao, yomatiame i'ka weeechi ti'tijoe ooweru tiame e'enameripua, i'ka weeechi kapoyachikia, tetuyachitikia, cherayachitepa, ariyachitikia. ");
INSERT INTO var_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Pu'ka taawechio, muuwaeme te'ta ahpo muime te'terekai, ki muimapua, ki tatakori papakotiame enesaa; nape, ki muime te'terekameai, nape papakotiamea ahpo tatakoriwa toakao, muimeriai teeremapua. ");
INSERT INTO var_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Pu'ka wa'apichioi, wa'achi e'enaka ookapi parisero Eesusichi paparakameai, chaanerepua Eesusio: —¡Masitári! Yaapiti machenamitia i'wao, aamo merinariapu Eerore. ");
INSERT INTO var_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Nape Eesusia chaanerepua pu'kao: —Nonorakao chaanemitia eemea pu'ka keeochi tísia wihkuameo: “Nee, ehpeo meere tiameo, iiweta pehji i'wa no'o ihsimio” —tuuyemitiapua—, “ti'tijoeri na'arari pakitekame puuyachekaopua, ti'tijoeri kokoriame sautekaopua tiame. Meerekachiopua kajusaapa, wa'a no'o enamio” —tuuyemitiapua pu'kao—. ");
INSERT INTO var_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Ooka taawe toitena neeeapa, no'o asiyachio wa'a Eerusareni. Wa'a asinariame neeea, aaata Riosi nayewaturao, ki ma'chi Eerusareni mukimerikopua. ");
INSERT INTO var_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Waikao Eesusia Eerusareni inatakao, chaanerepua pu'ka muuwario: —¡Áii muuu Eerusarenia! Muuu Riosi na'nayewatura ko'yamera, papaka ko'yame amochi nayewatumeri uhjureretiaopua. Kehkinasa aamo na'poakame neeea noochi pirenatumichioo, totori yeeyerachitia ahpo masatere toapanariamechitia, nape kiisi nakikame eemea. ");
INSERT INTO var_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Ehpeo muuu Eerusarenia, ooruchi itipimerimua aamo ta'perao, wa'a teeka itipimerimua, ahkasi no'o eenachisi eenechi, waikao chaachapapuameo: “Kaawechupena eenakame muuua, te'ta Amoe Paamira Riosichi eename.” ");
INSERT INTO var_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Piie taawechio, Eesusio ko'komia yeetotioiopua, aaata parisero paamiratuame ta'perachio, wa'achi mochiriaipua tiame wahjachi pa'parisero. Puuu wahjachi pa'pariseroa, inateriai puuua Eesusio, aatia iintotarepu erakoka. ");
INSERT INTO var_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Wa'achi yasariai piirechi tijoeai, a'popari kokoriame. ");
INSERT INTO var_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Eesusia Moise nuurari ma'masitario, parisero ti'tijoeopua tiame, iinatukerepua: —¿Reesiseniamejuarepua resipuniame taawechio, kokoriame sautewao? ¿Eje'é, ka'ikosaoi? ");
INSERT INTO var_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Nape aapoeo, kiisi chaachaparepua. Waikao ki chaachapakopa pu'kao, apochi uukaopua kokoriameo, sauterepua. Wa'a ikisaopua, uhjurarepua no'ramichio. ");
INSERT INTO var_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Pu'ka tijoe sautesaapa Eesusia, chaanerepua yooma wahjao: —¿Aatana eemea ki ma'chipata aamo oisio, aamo taanaoiopua tekorichi wichisoopua neeropairachi, pe'yachi resipuniame taawechikoio? ");
INSERT INTO var_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Nape aapoeo, kihta nehjianarere puuua. ");
INSERT INTO var_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Eesusia, ko'komia mochipuapuachio, epeche weruma te'teriame mochipamiachi uuyopua pu'kao, i'ka wa'achitaka nayewarepua: ");
INSERT INTO var_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","—Wahka nenewiwachi paajutetiaa ko'komichioo, ka'te te'ta iyoriwachi yasipamitiamua, seenekachi epeche weruma tiiame paajutetiame enasoo, ");
INSERT INTO var_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","ki aamo werisipuka, sewina yachapamichioopua. Wa'a yoratiaamua, tísia suuwe e'raka, sewina yasipamamua. ");
INSERT INTO var_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Ohso kaawe muuua wahka paajutetiaa, mehka iyoriwa mochipamiachi yasipapuapua. Wa'a tiiaopu aamo paajutekame enasaa, ahpo chokichi yasipatemaoipua, epeche iyoriwa mochikachio. Wa'a aamo yoratioopua wahjachi aamo ahjama napawikamea, te'ta iyorika aamo tetewimapua. ");
INSERT INTO var_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Apoe wa'api ahpo weruma iintamia, suuwe erapatepuamepua; nape ki ahpo weruma uuyamea, weruma teewepuamepua Riosieo, ahpo te'ta katewiachi taawechio. ");
INSERT INTO var_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Ahpo paajutekameo chaanerepu tiame: —Itapiti kooame pahkotasaamua, ka'te totomiwaemeche paajutemitiamua, aamo tetejimacheoi, aamo wa'achi yorame te'tiameopua. ");
INSERT INTO var_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Ohso kaawe ihtaoi kooame pahkotasaa, naatikamera paajutepapua, ki totomiwaemera ti'tijoe ooweru tiame, a'chi iika kahpokame ti'tijoe ooweru tiame, rojowi ti'tijoe ooweru tiame, ki mamachiriame tiame. ");
INSERT INTO var_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Pu'kakamera paajutepuapua, ka'chi iika nateteme tiiopa pu'kao, aamo no'rarewa paajutewao. Nape aapoeo ki aamo no'raweme teererioipua paajutewao, aamo Noono tewekachi kahtiamea, ki teesa aamo kaawe ikitema puuua, ka'karuma ti'tijoe ooweru tiame oijenatiaio. ");
INSERT INTO var_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Piiripi wa'a kahtiamea meesa chokichio, wa'a chiiopa Eesusio, chaacharepua: —Wa'a teeresoo waika taawechio, ¿ki teesa ta'iria ko'komerijoarepua wa'a, Riosi ahjamao? ");
INSERT INTO var_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Nape Eesusia, chaanerepua pu'kao: —Wa'atepua tiiao, nape siimerichemua, Riosie paajutetiachio. Wa'a cheesaapua o'inere cheekao: —Piie taawechio piiripi tijoea, weruma kooame yoorariataipua paajutewa. Wa'a ikisaopua, muuwaeme paajuteriataipua wa'ao. ");
INSERT INTO var_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Yooma wasipatesaapapua, uhjurariataipua waikao yooma paajutemichiopua, ko'komia e'enamichioopua. ");
INSERT INTO var_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Nape puuua, a'chikoi chaachaparepu ki e'nanariapa. Piiripia cheeriatapua: “Ka'chi eranurepuapua ki no'o siinkoi, we'e no'o tararia ne'nemia simiyo tuupuapua”, cheeriatapua. ");
INSERT INTO var_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Piirechia cheeriatapua: “Mariki maakurawa oisi no'o tarario tuupuapua, ka'chi no'o e'repo tuupuapua ki no'o simikoi, pu'ka oisi ne'nemia no'o simiyo tuupuapua.” ");
INSERT INTO var_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Ehpeche piirechia cheeriatapua: “Ka'i, pukeri neewikame neeea, ki siima neeea. No'o cheriwenurepuapua pu'kao, ki no'o simikoi”, cheeriatapua. ");
INSERT INTO var_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Ehjepao, uhjuratiame enasaapa: “Ki e'enanarekapu”, chaaneriatapua ahpo teekoo. Wa'a chaanetiapa teekoraa, tísia nekariatapua. Wa'a ikisaopua eenechio, cheeriatapua: “Ehpeo yaapi siinka, yooma paajutemitiapua, kihta paarasatiameoi, pooechiami aamo tewaya, yooma sihkochiami aamo tewaya tiame. Te'ta tesiwa te'tiamera paajutemitia: rojowika ohjoame, panaka ohjoniame ki ma'chiriapa, wa'a mahka ruhjika kahpokame.” ");
INSERT INTO var_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","“Paamira, yooma yoorakameniapa aamo cheeriao, nape itipina pehji mochipuapuachio, ko'komia”, cheeriata uhjuratiamea. ");
INSERT INTO var_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Waikao teekoraa chaaneriatapua: “Wahka epeche mehka pooechiami i'yasaopua, utewa yorasaopua e'enamichioo, mochiwapuapua wa'ao. Yooma ko're chokichiami, aamo tewariaoi, muinurepuapua no'o ta'pechi, pochimichiopua i'wa. ");
INSERT INTO var_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Aaataai ki nakikamea no'oe paajutetiaio, kiisi ko'komeripua no'o kooameo.” Wa'a teeremeri Riosia, ti'tijoerichio. ");
INSERT INTO var_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Piirechi taawechio, seenepi simikame Eesusia, muuwaeme nokisioiopua ahpo ahjamao, ku'rikao chaacharepua: ");
INSERT INTO var_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","—No'o pichiwa na'naritonariamea, epeche no'o nakimeripua ki ahpo yayawachitia, epeche ki ahpo poponichitia, ahpo pipinioi, epeche ki ahpo uupichitia, epeche ki ahpo ahjarichitia. Ki wa'a teeka no'o nakiyame enesaa, ka'chi iika no'o na'naritomerimua. ");
INSERT INTO var_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Ki ahpo maaporichi teetonariamea no'owichioo, ka'chi iika no'o na'naritome enemeripua. Kaawe ahpo inataniamepua ke'chu no'o na'naritoaio. ");
INSERT INTO var_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Ke'chu no'o na'naritoaio, kaawe aamo ne'nepuapua amochio, ihtanakamera ehpeche nateyamerakoopua, aamo iintomiao. ¿Ki aaata karitameai, pahcha ne'nesapa ahpo wekatemiaopua toomio, o'ichamepua? ");
INSERT INTO var_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Ki wa'a iintokame enesoo, ahpo kaari o'inekai ki kajusoo, suuwe erapori chaanepuamepua waikao, wa'ami u'matopamee, a'acheka pu'kao. ");
INSERT INTO var_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Waikao ti'tijoeria, pu'ka ki kajukame ne'nekao, chaachapamapua: “Nee, ¿kiisi kajurepu tiame?” ");
INSERT INTO var_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Yawichiai, ki nasiwameripua aaata piirechi yawichichio, ki newitomeri enesaa, ahpo oosa mariki miiri soontaroeopua, piirechi yawichichi, piire weerewa miiri iinuemechiopua soontaroo. ");
INSERT INTO var_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Ki newitomeri teeresaapua, uhjuramapua waikao katewemichio, kehkioi kiamio tuuka, ki nasiwapuawichio. ");
INSERT INTO var_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Pukaepa muuua, kaawe inatapuapua pahchao, noochi enanariaa. Aamo iinueka kahtia, epeche nateyamera maaesaamua ki noochi enaniamechitia, ka'chi iika enamerimua noominao, noochi te'teretomiao. ");
INSERT INTO var_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Wa'a cheesapa Eesusia, oonachi simiyame naewarepua wa'achitarichio. Puuua cheerepua ti'tijoerio: —Eemea, oonachitiapua. Oonaa, tísia nakiwamepua, onachariesaapua pehjio. Nape ahpo onachari wekatesaapua, ¿achini iika eenechi onataparetapua? ");
INSERT INTO var_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Ki kaawe ihsiamepua to'iwe wasachi wakipatewawichiooi, itapiti kasaraoi echipuamewichio onawepuaoi, ipapuamepua wa'asi. Pahteka inamumitia i'ka no'o cheeriao, ki wa'a ikipuaichio aamoo. ");
INSERT INTO var_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Yooma yawichiwichio koparoamea, wahjachi ti'tijoeria tiame tatakoriwaeme, Eesusi waapi e'enarepua keepumia. ");
INSERT INTO var_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Parisero ti'tijoea wa'a noonoikopa pu'kao, ahpo chaachaparepua Eesusio, pa'parisero ti'tijoea: —Nee, achini ihsiamepua. Ihji tijoea, yooma tatakoriameoi, toayamepua ahpo naaepamichioo, ahjama koayamepua tiameo. ");
INSERT INTO var_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Wa'a chaachapopa i'kao, Eesusia i'ka wa'achitarichi nayewerepua: ");
INSERT INTO var_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","—¿Aatana eemea piie siento puhkuemea po'wa, piiripi wekatesaa, ki simiyamepua i'yamiao, piiripi toiyameopua siento? ");
INSERT INTO var_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Ihjia i'yai tewesaapa, mooketoka no'rasaapa ahpo ta'pechio, kaawe e'raka chanimapua waapi ohjoemeo: ");
INSERT INTO var_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","“¡U'masio ne'nemia! Tewakasai neeeapa no'o wekateria po'wao. Pahkotamane pu'ka no'o tewariawichioo.” ");
INSERT INTO var_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","I'ka wa'achi tiiame, epeche kaawe erapuame te'pa tewekachi mochikame Riosi ku'iwarieeopua wa'asi, aaataoi we'wemerakamera ahpo tatakoria toimo tuukameopua Riosio, ki wahjachitia ti'tijoeo ooweru tiamechitia, ahpo tatakoria ki toinareriachitiaopua wa'asi. ");
INSERT INTO var_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Waikao tepuyame nayewasaopua Eesusia, toomi wekatetiame nayewarepua waikao wa'achitarichio. Puuua cheerepua: —¿Aatana oowitiame, oosa mariki toomi oosa mariki taawechi yowiwame iinuekai piiripi wekatesaapua, ki chichika i'yatarepua ahkasi ahpo tewayachisio, tukapachi enesoo tahjekaoioopua? ");
INSERT INTO var_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Tewisapaopua i'kao, ¿ki yooma ahpo kaawe e'ria tuuyetarepua, ahpo tísia kaawe e'raopua, ahpo wekateria tewariapao? I'ka oowitiame kaawe e'reka tetewamea chaachapamiipua: “¡Kaawechupena muuua tewakamepua! ¡Teemeai aamo tewariopao, amochitia tísia kaawe erakoamepua!” ");
INSERT INTO var_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Wa'achitia Riosiai, tísia kaawe eramapua ahpo tewekachi ku'kuiwara ahjamao, aaata tísia tatakorichi wekakameoio, apochikamera eenariopao paparamiao, tatakoriria chewipuawichioo, aaataoi apochi paparamia eenariopao, ahpo tatakoriria cheriwepuawichioo. ");
INSERT INTO var_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Eesusia naewarepua tiameo, cheeka: —Aaata tijoea ooka tatanaeriataipua. ");
INSERT INTO var_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Piie taawechi neipa weeriamea, chaaneriataipua ahpo noonoo: “No'noo, no'o kiajeraninia aamo mukusa tooemio.” Wa'achiopa ahpo taanao noonoraa, yooma ahpo tatana naachuterepua iyosichi iyopusapua, yooma pipiripi weewara iinueka itipiniameopua. ");
INSERT INTO var_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Waikao ehjepamio pooniraa, yooma ahpo weewa nehjisaopua, wahka akipariatapua waikao, méhka pirenachi weeechi. Wa'a asisaopua, o'ineriatapua ahpo toomi na'ataka, itapiti suwepori ihsiwachi. ");
INSERT INTO var_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Ahpo tomiwa sopasoopua, ki nu'uti toorewi eenariatapua wa'a weeechio. Waikao puuua tísia toore aiwapao, ");
INSERT INTO var_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","tehki i'yasiriatapua pu'ka weeechio. Ehjepamio tewisaapa tehkio, o'ineriatapua tekipanakao, koowi inateka, wa'api ohjoeme tijoe, puhkura. ");
INSERT INTO var_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Waikao ihjia tekipanaio, tísia chorowapaopua, koowi koi'teniameoi ko'konareriataipua, nape ki kiatiapaopua pu'kaoi, wa'atia itipiriatapua. ");
INSERT INTO var_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Waikao tísia aiwapa tooreo, e'rariatapua: “No'o noono kahtiachio ki aiwaniachi tooreo, paarasanipua wa'ao. Muuwaeme no'o noono ahjama tekipanamea, ki aiwanipua tooreo. Nape neeea i'wao, amori mukuyame kahtinia toore. ");
INSERT INTO var_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","No'ramane ohso kaawe, no'o noono kahtiachi. Wa'a asisaa chaanemane: No'no, iinya iintokame neeea. Taamo Noono te'pa kahtiamechio, tatakorikame neeea noochio, amochiopua tiame. ");
INSERT INTO var_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Kiisi aamo taana enemetekoinia ehpeo, nape wa'atioi, aamo no'o cheriwesoo, oowera tekipanamechitia, uupuapua. Wa'a chaanemane no'o noonoo, asisaa.” ");
INSERT INTO var_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Waikao wa'a erasaopua, no'ariatapua ahpo noonochio. ’Noonoraa i'ka asioiopua ta'pechio, wa'a ihtoame tetewapaopua mehka o'inia ihtoiopua pehjio, tísia tesiwa teetopa ahpo taanao, u'masiriatapua natepamiao. Natepasaapa noonoraa, koorepaka chuchuriatapua pu'kao. ");
INSERT INTO var_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Waikao taanaraa, chaaneriatapua ahpo noonoo: “No'noo, tísia tatakorikame neeea, te'pa kahtiame Noonochiopua, amochiopua tiame. Kiisi aamo taana enemete neeea.” ");
INSERT INTO var_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Wa'a chiiopa ahpo taanao noonoraa, yaapiti sisinamuriatapua ahpo ta'pechi mochikameopua chaaneka: “Yaapiti. U'yepake wisasori, epeche ka'karumara, chuhchepuapu. Aanio tiame u'yepamitia, sutuchi chuhchepuame, wa'a ikisa kaaka we'wemera. ");
INSERT INTO var_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Wa'a ikisaopua tiameo, weesero i'noramitiapua, epeche wiiyamera. Pahkotapuapu merisa, ta'iria ko'kopuawichio, tísia kaawe erakoka. ");
INSERT INTO var_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Pahkotemane i'ka no'o taanao, mukukameka teererioipua pu'kao, eenariopa. Ihjia eenakao, eenechi oijenakamekatepua. I'ka no'o noorao, wekatekai neeea, eenechi tewakamepua.” Waikao o'ineriata pahkoa, yoomahka pu'sereka. ");
INSERT INTO var_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","’Nape pahcha naawakamea pa'chira, wasachi ihsiriatapua tekipanakao. Ihjia eenaiopua, ke'chu asiyaiopua ahpo ta'pechio, weeru chiiame inamuriatapua, sooni cheeteniame yawika. ");
INSERT INTO var_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Waikaopua asisaapa ahpo ta'pechio, aaata ahpo ta'pechi mochikame iinatukeriatapua cheeka: “¿Ihtana pahkotania i'wao?” ");
INSERT INTO var_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Wa'a tekipanamea, nehjiariatapua: “Aamo pooni pahkoteniapua. Aamo noonoa, aamo pooni pahkotiapua eenechi eenariopa wahka oiyai, pu'kawichioopua, weesero me'yeriapua epeche sowiyamera, eenario tuukaopua kaaweruma.” ");
INSERT INTO var_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Waikao pa'chiraa tísia nekakao, kiisi pakinareriataipua wa'ao. Nape noonoraa kahtiachi eenakao, cheriweka nayewekaopua, pakinureriatapua. ");
INSERT INTO var_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Nape taanara pa'chiraa, chaaneriatapua ahpo noonoo: “Nape muuua, ki ehpesi no'o tekipanaoiopua aamo e'weka, seenepioi ki e'wekao, seenepioi ki no'o pahkotiamemua, no'o taaenarichio, no'o kaawe e'ria ahjama ko'komichioopua, pu'sereka. ");
INSERT INTO var_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Nape muuua i'ka aamo taana enasoopua, oowera suweporichi oika na'atakameoipua toomio, ikanati me'yamemua epeche wiiyame weeseroo, no'owichioo ki wa'a iintokameai.” ");
INSERT INTO var_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Waikao noonoraa chaaneriatapua: “Nape no'o nooláá, muuua senepi taawechi no'o ahjama kahtiamepua, yooma no'o iinueka kahtiaopua, yooma aamo iinuwapua tiame. ");
INSERT INTO var_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Nape i'ka aamo poonio, mukukameka teereriopua pu'kao, eenechi eenakaopua, oijenameka ikiriopa pu'kao; wekakameka teererioipua tiameo, eenechi tewitiameka ikiriopa pu'kao. Pukaepa kaawepua, kaawe e'raka pahkoteniamepua.” Waikao Eesusia, kajusapa pu'ka noonora ahpo taana cheriwetiameo nayewakao, chaanerepua yooma ahpo masitia keepuameo: —Wa'achi teeka cheriwiame te'pa kahtiame taamo Noonoa, ahpo tatakoriwa tuuka enapameo apochiopua, ahpo tatanachitia uuka. ");
INSERT INTO var_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Eesusia ahpo masitiachi keepuameo, i'ka piirechi wa'achitarichi nayewerepua: —Aaata tijoe tísia paarastiame weeechio, ahpo paarasatia neesetokiameo, yooma ahpo paarasatia, na'atame inamuriatapua. ");
INSERT INTO var_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Teekoraa wa'a tiame inamukapaopua pu'kao, paaesa iinatukeriatapua pu'kao: “¿Achini iikai no'o ichikuame muuua? Yooma nane'riamenia aamoé no'o ichikokenioo. Yooma ihtetaripapua no'o tomiwa aamo ma'chipariaopua, yooma kehkisasaapua, no'o iyotaperichi toapuapua, no'o nane'remichiopua. Ki tekipanamerimua wa'asio noochio.” ");
INSERT INTO var_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Waikao ahpo teeko tehkiwa neesetoamea, e'rariatapua: “¿Ihtana yoratarene ehpeo?, no'o teeko u'yesoopua tehkio. Ki utewaemenia wa'asi wasachi tekipanamiao, ihkorewa itakaio, tísia suuwe e'ramenia. ");
INSERT INTO var_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Aa, inatepane no'o iintomiao, aachin teeka no'o ku'ipuaichiopua, ki tehkiekoio.” ");
INSERT INTO var_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Waikao yooma ahpo teeko wikirieme paaesapao, iinatukeriatapua. Pahcha simiyameo, chaaneriatapua: “¿Ihkina wikiriemua taamo teekoo?”, chaaneriatapua. ");
INSERT INTO var_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Puuu tekipanamea, cheeriatapua pu'kao: “Neeea, piie siento piire weerewa aampa oosa mariki weeweruma sikori, waariri tewaniame, ooriwo nerosowi koi'wame wikirienia. Puuu waariria, piire weerewa aampa mariki ri'ritoro to'wame enerepua pipiripio.” Waikao tehki paamiratuamea, chaaneriatapua pu'kao: “Nee, tamochiche nane'rewa itipimeri ihjia. Aamo wikiriao, naasipasi cho'wemane, ooka weerewa oosa mariki waariri wa'api, wikirieka itipimerimua.” ");
INSERT INTO var_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Piirechi tekipanameo iinatukeriataipua tiameo: “¿Kehkinapu aamo wikiriaa?” “Neeea, piie siento aaneka wikiriemenia tiirikoo”, cheeriatapu wikiriemea. Waikao tehki paamiratuamea, chaaneriatapua pu'kaoi: “Nee, ka'te tuumitia naaju aaataoi, neeea, naao weerewa aaneka, wikirieka itipitemania aamoo”, chaaneriatapua. ");
INSERT INTO var_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Teekoraa nane'resaapa i'ka iintoriao, e'rariatapua: “¿Ki teesa inatame puuua?”, e'rariatapua. Pu'ka wa'achitari kajusapa Eesusia, chaanerepua ahpo keepuameo: —Tísia pichiwa ihjia: Tukapachi ohjoamea, te'ta a'chikoi nokaka pepeniamepua ahpo ihsimiao, ki Riosichi paparaka mochitoamerakamerachitia, ki Riosi taajenarichi ohjoamechitiao. ");
INSERT INTO var_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","’Pukaepa aamo chaanenania, ka'te wa'achi noonoimitia eemea, pu'ka tehki paamiratuameo, ki kaawe iintoriachitia. Ohso kaawe eemea, paikapioi iinuekaio, ookapieoi ku'ika mochitopuapua aaata tísia tooremuka mochikameo. Wa'a nokayame enesaa eemea, tewekachikamera ohjorewachi te'ta paarasarikamera iinuemeripua. ");
INSERT INTO var_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","’Kaawe iintokame enesaamua paikaoi aamo Riosie kianiao, kaawe iintomerimua, epeche kiatiai Riosieo neesetomichioo. Nape ki kaawe neesetosaamua, paikapioi Riosie aamo neesetotetiao, ¿ihtana aamo kiatare Riosia, ehpeche aamo itapiti neesetomichio? ");
INSERT INTO var_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Aamo iinueka paikapioi ki kaawe neesetoka yasitokame enesoo, ¿kiapua tiiamejuarepua Riosieo, itapiti neesetokepuawichioo ahpo kehkiwachi? ");
INSERT INTO var_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Aaata kiisi peeniame enesoo, ahpo wa'api iinuwaoi neesetokao, ¿kiatariamejoarepua aaataeo, ahpo iinueka neesetokemichioo? ");
INSERT INTO var_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Eesusi wa'a tiiame masitesaapa, eee cheerepua: —Aaataai ka'chi iika yorakemetepua ooka teekoo wa'api keenakoo, eee tiiamekopa: piiripi ahpo teeko yorakioio, piire ahpo teekoai wa'apichi keenako ahpo yorakejemerikopua. Puuua waikao, piiripi teekokamera yorakiopaopua, piire teekoa nekamapua; piiripi teekokamera ahsieme yorakepuamepua, piie ahpo teekoo toaka. Wa'a tiiachiopua aaataai, Riosikamera te'ta nakiyamea, ka'chi iika weemumetepua toomichio. ");
INSERT INTO var_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Pa'parisero ti'tijoea, pu'ka inamukapaopua, a'achere puuua, toomikamera pu'seriapapua. ");
INSERT INTO var_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Waikao Eesusia chaanerepua: —Nape Riosia nane'riamepua aamoo, toomichikamera te'ta paparamekopua, ki ahpokamerachi. Eeme pa'pariseroa, te'ta aamo yooreka tetewijeranipua ti'tijoerieo, nape aamo iikachio eemea, aamo wahjachi ti'tijoerichio, kiisi kaaweruma ijinatamepua. I'ka weeechi mochikame te'ta nateyamechitia tetewao, Riosiwichioo, tísia iinya tiiame teerewa tetewamepua. ");
INSERT INTO var_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Pu'ka nayewaka kajusaapa Eesusia, i'ka eeetiame simiterepua masitekao: —Ke'chu eenoi Waani Paatorio, ti'tijoeria, ehkoriami nokiwa yooraka mochitoriaipua, ahpo ehkoriami Riosi na'nayewatura masiteriachitia. Nape puuu Waani Paatori enasaapua, weemera nokiwa masiterepua ti'tijoerio, Riosi ye'karichi muimichiopua pu'kao. Pukaepa ki ookapi Riosi yawichituwachi mochirachi tísia muinarerepua wa'ao. ");
INSERT INTO var_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","’Pu'ka Waani Paatorichi simiyame wa'a tiiame te'ta pichiwa ikirepua, te'ta wa'a tiiame ikimeriko tuutiamekopua Ehkoriami Iyoterichio Riosieo. Yomatiame Riosi cheeria ikikache itipimerikai teererepua, ahkasi nu'nuti naawesari chanitiameoipua, te'ta nateyame tetewaka, te'ta nu'nuntiraoipua iyoti. Ihji weeea, ihji tewekaai, pahcha ki naania ikitarepua, nape Riosi cheeriaa ka'i, wa'api teeremeripua. ");
INSERT INTO var_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","’Kaawe inatamitia i'kao: Aaata ahpo uupi toisaa, piirechi ahjama neewikameka ikiyameopua, suwepori iintowa. Wa'achi teekao, aaata Riosichi chiia toisaa, piirechi masitewa pichikemichio, suweporika iintokame Riosimina. Aaata tijoe ooitiame toitiame ahjama neewisaa, suwepori iintokamepua tiame Riosi ne'niachio. Wa'achi teekao, aaata piirechi masitewa pichikesaa ki Riosi taamo chiia, suwepori iintokamepua Riosichio, toakame puuuapa Riosio. ");
INSERT INTO var_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Eesusia tiameo, Riosi chiia Ehkoriami Iyotetiame nateyarachi nayewakao, i'ka wa'achitarichi nayewerepua ti'tijoerio. Eesusia o'inekao cheerepua: —Aaata tijoe eneriataipua, tísia tomiwaeme, tísia nateyame wisasori chuhchame eneriataipua, te'ta to'totomiwaeme koaya koayame, ihtaoi ki tooremuame eneriataipua ahpo ta'pechio. ");
INSERT INTO var_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Wa'achi ohjoeriataipua tiame, aaata Rasaro tewaniame. Ihji Rasaroa, pochikame ehchaeme weerewachio enerepua, pu'ka paarasatiame ta'perachi, yayasariataipua, muirachi. ");
INSERT INTO var_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Ihjia pu'ka paarasatiame ta'pera muirachi yayasariataipua, ko'kotiame wehchi ruhjikameoi, ahpo ihkokepuaichio. Chuhchuriai wa'a kahtioio, wa'a enapaka saasaeriataipua ehcharao. ");
INSERT INTO var_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Pu'ka ihkoriame mukisoopua, Riosi ku'iwaria, Aurani kahtiachi i'toriatapua, Riosichi ka'karuma enekame mochikachi. Puuu tijoe paarasatiame mukisoopua, wetemajiretiatapua. ");
INSERT INTO var_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Wa'a ahpo upatiachi kahtiaiopua, ki ka'karuma wahjipame mochikachiopua, ki teesa aiwapaopua wa'ao, Aurani Rasaro ahjama kahtiachi ne'nepariatapua, te'pa. ");
INSERT INTO var_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Waikaopu te'ta paarasatekamea, tísia aiwapa ahpo upatiachio, sisinamuriatapua Auranio, cheeka: “¡No'nó Auráni, no'o tesiwéee! Uhjura pu'ka Rasaroo, piiripi suhturaoi saampatesa, no'o yenichioi seipatemane teesa. Tahpitika e'ranine parae i'wa na'ichio.” ");
INSERT INTO var_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Nape Aurania chaaneriatapua: “Nape, ¿ki nane'rena muuua, weeechi kahtiaiopua tísia tomiwaekao, tísia aamo ta'iria yasariopua ki Riosichi inataka? Nape Rasaroa tísia aiwaio weeechio, tísia kaaweruma enepakamepua Riosichio, pukaepa i'wa kahtiamepua no'o ahjamao tísia ta'iria, muuua wa'a. ");
INSERT INTO var_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","I'waoipua taamo pejanao, káii waapisi akipame teeresi po'ipua waata, aaataai ka'chi iika u'matometepua wa'apoo, wa'aponaoi aaataai ka'chi iika u'matometepua.” ");
INSERT INTO var_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Waikao paaresatekamea chaanerepua Auranio: “Wa'a teeresoo muuu no'no Aurania, pu'ka Rasaroo, no'o noono ta'pechi uhjuramitiapua, weeechi kahtiame. ");
INSERT INTO var_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Wa'ao mariki no'o poponiekao, tísia utewaeme chaanenurapuapua pu'kao, Riosi chiiakamera pichikenuraka, ki i'wa te'ta aiwaniachi upapuaichiopua pu'kao.” ");
INSERT INTO var_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Nape Aurania, nehjiariatapua pu'kao: “Nape aapoeo puuua, iinueme puuuapa Riosi cheeriao, ehkoriami nayewatura iyoteria, ehkoriami Moise iyoteria kiaretiaopua tiame. Pu'ka e'weka mochimeri puuua. Ki Moise e'wesaa tooweretiao nuurari, aaataoi wahjipakame oijenaka wa'a eenakoipua aamo chiia tuuyemiao, oijenakao, ki pichikemapua.” ");
INSERT INTO var_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Nape paarasatekamea nehjiariatapua: “Eje'e, wa'atepua tiiao, nape ki e'wekameai Riosi nayewatura iyoteriao, i'wa o'inia oijenakame wa'a enasoo, yooma nayewesoo achini tiio i'wao, pichikemapua pu'kao. Wa'a iikapa puuua Riosio, yooma ahpo toimio tuumapua ahpo tatakoriwao.” ");
INSERT INTO var_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Nape waikao Aurania, chaaneriatapua: “Ka'i. Ki e'wiame enesaa pu'ka Riosi Ehkoriami Iyoterichi chiiao, aaata wa'a eenakoipua i'wa o'inia oijenakameo, ka'chitia pichikemapua pu'kaoi.” ");
INSERT INTO var_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Eesusia, ahpo te'ta masitiao chaanérepua: —Aaata tatakorimichio ihsiamea, wa'api iintumeripua, na'ara yorapuaichio ihsiamea; nape ¡wéii!, wa'a iintokamewichioo. ");
INSERT INTO var_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Ohso kaawe eneriaipua pu'kao, moorino matasuraraa tehte, kutachi o'yesao, pa'wechi ipatiaa, kátisia teeresi akipamichio pa'wechi, ki tatakorichi ruhjinamichioopua, i'ka nu'nuntichitia noochi paparakame o'iniameoopua. Pukaepa eemea wa'a aamo noonoimiao, tisiwá aamo neesetopuapua, aamo inateka eemea, pu'kao. ");
INSERT INTO var_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Wa'a cheesapa Eesusia cheerepua tiame: —Kaawe keepusao. Aaata piire aamo na'aresoo, teripuapua pu'kao; nape ahpo cheriwenuresoo, cheriwepuapua pu'kao. ");
INSERT INTO var_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Oowisanisa simiyame aamo na'aresoo, wa'a iintokai ahpo cheriwenuresoopua pehjio, wa'apichi kehki cheriwepuapua, oowisanisa. ");
INSERT INTO var_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Piie taawechi Eesusi ajawariaa chaanerepua Eesusio: —Paamira, taamo ku'imitiapua tamochio, epeche taamo ahjachi eramichiopua amochio. ");
INSERT INTO var_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Waikao Eesusia wa'achitarichi naewakao, chaanerepua ahpo te'ta masitiao: —Weruma kehki no'o ahjachi erakowa ki nakiniamepua. Ku'ita kehkioi no'o ahjachi erakoame enesaa eemea, wacherai kuuu pahchira nu'utikoichitiao, i'ka aoso aamoo chaanesoopua: “Po'taka wiitu weripa neeroi pa'wechi”, wa'a weripamii puuua. Noochiche ahjachi e'rakaimua, soparamepua noochio. ");
INSERT INTO var_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","’Nape ka'te weruma aamo maayame eemea, no'owichio yoorakawichio itapiti noochi ahjachi e'rakao. Keepuka i'ka wa'achitari: Aaataai ahpo yorakiame teekoraa, ahpo yorakiao wahka oirioipua wasachi tekipanakao, resipakame eenakoipua tekipanakao, ki chaanemapua: “Koi'wachi yasipasa. Aamo weeremane kooame.” ");
INSERT INTO var_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Ohsotia teekoraa chaanemapua: “No'o weere kooame, no'o neesetopuapua ahkasi no'o aiwaka koayachisi. No'o ko'kosopa ko'kopua muuua.” ");
INSERT INTO var_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Teekoraa, cheriwemaoi ki kiatarepua ahpo nuurewa yoorariawichioopua. ");
INSERT INTO var_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Wa'achitia eemeai, te'ta Riosi chiia yooraka mochitoaiopua, kihta aamo wikirieko eramete eemea Riosio. Ohsotia eemea amochio erakopuapua: “Teemea, taamo Riosi yorakemeriche yooraka mochitoamepua.” ");
INSERT INTO var_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Piie taawechi Eerusareni simiyai Eesusia, Arirea weeechiami Saamaria weeechiami tiame u'matorepua. ");
INSERT INTO var_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Wa'ami ihtoiopua pooechio, piiripi mochiwachi asiyoio, oosa mariki ti'tijoe machejenarepua, repera kokoriame. Ihji kokoriamea, mehka ajapaka ");
INSERT INTO var_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","sisinamurepua: —¡Eesúsi masitárii! ¡Taamo tesiwe e'résaaa! ");
INSERT INTO var_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Eesusia wa'a chaachapameo tetewapao, chaanerepua: —Ne'neseriosichi siimpamitia eemea, pu'ka napawikarichi neeseriosi mochikachi, aamo tetewimichio pu'kaopua, aamo yachapakamekopa wa'asi. Wa'a siimpaiopua waikao, saukame itipirepua. ");
INSERT INTO var_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Wa'a iikapa piiripi puuua, saukame itipikapao, Eesusi ihtoachi no'arepu eenechi, cheriwema kiamia. No'raiopua, weweru cheesika cheriwema kiasirepua Riosio, kaaweruma naewaka pu'kao. ");
INSERT INTO var_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Eesusi natepasaapa, wehchisi koomorasipakao, cheriwema ki'yarepua Eesusio. Ihji tijoea, Saamaria tijoe enerepua. ");
INSERT INTO var_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Waikao Eesusia cheerepua ahpo ahjama nokisiameo: —¿Ki oosa marikisakaipu saukamea? ¿Ki e'enakame wahja watania? ");
INSERT INTO var_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","¿Ihji seenu tijoeche eenarepua Riosi cheriwema kiamiao? ");
INSERT INTO var_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Eesusia waikao seenu tijoeo, chaanerepua: —Werika no'rasa ehpeo, noochi paparakapa saukamemua. ");
INSERT INTO var_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Piie taawechi Eesusi masitioio, pa'parisero ti'tijoea utewaeme iinatukeriaipua Eesusio, achinitio enamio Riosi ye'kariwao. Wa'a tiiame iinatuketiaapa Eesusia, chaaneka nehjiarepua: —Riosi ye'karia amochi tiiaitepua wa'asi, ki pusie tetewiwame. Pu'ka ye'karichi eenepatiameo, amochio eenariamekopua wa'asi. ");
INSERT INTO var_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Pu'kao ki pusie tetewiniamekapao, ka'chi iika cheepuamepua: “Nee, i'wane weeri”, “wa'ane kahti”, yooremina aamo iikachi kahtiamekopaopua, puuua aamo kaawe te'ta tiiamepua Riosichio. ");
INSERT INTO var_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Eesusia simiteka ahpo masitiao, chaanerepua ahpo masiteka ihsiao: —Asimitepua piie taaweo, aamoo piie taaweoi, no'o tísia tetewinaremiachio, nape wa'a erakoai ka'chi iika no'o tetewimeri eemea. ");
INSERT INTO var_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Pu'ka taawechiamio, ti'tijoeria chaachapameripua: “U'masi ne'neo, i'wa kahti.” Wahjachia chaachapamapua: “Waami tetewika teemea pu'kao, ne'netaria.” Nape wa'a chaaneniai, ka'te siimpamitiapua ahjamao. ");
INSERT INTO var_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Neeea, waika taawechio ki wa'a chaachapamechi enameripua. Neee Tijoe Tijoetukame eenaio, kuhjiparichitia ma'chiame enameri neeea, yooma ma'chiame tetewachi. ");
INSERT INTO var_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Nape ehpe taawechiami pehjio, ki no'o nakiyame ti'tijoerieo, weeka itapiti ikimeri neeea, tísia kokosa tiiame. ");
INSERT INTO var_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Pu'ka yooma u'matoso eenechi no'o eenoio, naatika teeremeripua, Nooe tewaniame tijoe taawechiami, te'tereka mochitiachitia. ");
INSERT INTO var_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Ihji Nooea itapiti yooraka mochiriaipua, tekipanaka koakache, nenewikaoipua tiameo, ahkasi Nooeo pawekakerachi pakiriachisiopua, i'ka yomatiame weeechi si'ririnioiopua, te'ta werumara si'riri, yu'kie. ");
INSERT INTO var_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Rooti tewaniame taawechiamioi, wa'achi te'tereriaipua, ahpo wahjipoiopua. I'ka ti'tijoerio wa'achi nokaka mochikoiopua Nooe taawechitia, oowera koakaopua, oowera tarakaopua tiame, itapiti nehjakaopua, echakaopua, karitakaopua tiame. ");
INSERT INTO var_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Rooti machenoiopua Sooroma mochiwachi muuwarichio, senawato ki ku'ita na'i yukurepua Sooroma mochiwachio, yooma wahjiparepua pukaeo, choochoka. ");
INSERT INTO var_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Wa'achitia senawato enamania waika taawechio, neee Tijoe Tijoetukamea, eenechi i'ka weee eenaiopua. ");
INSERT INTO var_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","’Pu'ka taawechio, karijampa ihsiamea itapiti yoorakaoi, kihtawichio inatametepua ahpo tekimiao, yooremina ahpo karichi iinueka ma'chipamiao. Wahka ihsiameai kuhsitereo, kihta inatameripua ahpo no'ramiaopua petechio, ahpo itapiti ma'chipasa i'tomiao. ");
INSERT INTO var_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Nane'riame eemea, Rooti uupirao, itapiti ahpo toaria i'noranaria ukana ne'nepariopaopua, oona enepariopua. ");
INSERT INTO var_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Aaata i'wa weeechi ohjoewache epeche nateyame maayamea, ki Riosi weemera ahjarichi ohjoewachitiao, wekatemeripua te'ta ahjario, ki wahjiamesi ahjaniameo. Nape aaata i'wa weeechi ohjoewa ki epeche nateyame maayamea, ki Riosi weemera ahjarichi mochiwao, puuua teimeripua te'ta pichiwari ahjario, ki wahjiamesi ahjaniameo. ");
INSERT INTO var_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","’Pu'ka taawechi tukao no'o eenoio, aamoo chaanenania, ooka pe'tiamea kokochikao, apechunapuamepua piiripio, piireo toaka. ");
INSERT INTO var_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Ooka ooweru nokayamea tusukao, i'topuamepua piiripio Riosieo, piirea toaka. ");
INSERT INTO var_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Ooka tijoe nokayamea wasachio, piiripi wa'api i'topuamechepua Riosieo, piireo toaka. ");
INSERT INTO var_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Waikao keepuameraa, iinatukerepua Eesusio: —Nape ¿akana wa'a ikimeri puuua? Waikao Eesusia chaanerepua: —Wa'achitia itapiti mukukame po'yachio, naania tiiatachiatia oonori weeru nokiwao, no'o aamo ikipo tuuriao, naania teeremeripua achinitio ikipuamekoopua pu'kao. ");
INSERT INTO var_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Piie taawechio Eesusia, ti'tijoerio, ki toaka paparapuawichioopua Riosichio, eee cheeka nayewerepua wa'achitarichio: ");
INSERT INTO var_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","—Wahka muuwari mochiwachio, yasariataipua piiripi tijoe peereira, kiisi iyoriame eneriataipua Riosio, ti'tijoerioi, ki tesiwa e'riame. ");
INSERT INTO var_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Wa'achi ohjoeriataipua tiame piiripi oowitiame kunamukukame, aaatae na'ara yoraniame eneriataipua. Wa'a yoraniapa ihji ooitiamea, peerei kahtiachi simiriatapua ahpo katewepuaichio. ");
INSERT INTO var_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Weesa eenakame eneriaipua, pu'ka peerei tijoechio, nape ihjia ahpo wa'inariataipua, ki ikanati katewenareka. Nape puuu tijoe peereiraa, ki toaniapa senepi ejenakao, erapariatapua pu'ka ooitiameo: “Ka'chitia taawechi tesiwa e'riameaipua aaataopua Riosichioi, ");
INSERT INTO var_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","ikanati katewekemane i'ka ooitiame, tísia kichiwa chiiopua pu'kao, noochi ejenaka.” ");
INSERT INTO var_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Wa'a cheesapa Eesusia, ahpo masiteka ihsiao chaanerepua: —Kaawe inatamitia i'ka peereira tijoe iintoriao, ki pichikiamekaipua Riosi kaaweruma tuuyewari chiiao. ");
INSERT INTO var_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Ihji tijoe Riosi chiia ki pichikiameaipua, kaawe iintokame enesoo, ¿ki epeche kaawe iintomerijoare Riosia ahpowichio poanatariopua ijinuwaopua, apochikamera paparameopua? ¿Ki ikanati nehpupatarepua te'ta ahpo ijinuwao? ");
INSERT INTO var_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Riosia, kiisi puuyeka cheriwemeri puuua, aaata apochi enasoopua ahpo tatakori cheriwepuawichioo. Nape neeea no'o iinatukiamepua, neee Tijoe Tijoetukame eenaio, ¿tewimerijoarenia pehjio, aaata noochi paparameopua? ");
INSERT INTO var_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Eesusia i'ka wa'achitari nayewerepua, ahpoche kaawe nokayame maaeka Riosichio, wahjachio ki kaawe nokayame maaerepua: ");
INSERT INTO var_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","—Ooka ti'tijoea i'isaeri tiopachi e'enariataipua, Riosi ahjama nayewamia. Piiripia, parisero tijoe eneriataipua, tísia ahpo iyoriame maaetame Riosichi. Piirea, yawichi koparoari ichikoame eneriataipua. ");
INSERT INTO var_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Parisero tijoea, werisikaopua eee cheeka nayewariatapua Riosio: “No'no Riosi, cheriwema ki'yaninia ki wa'achitia tiiamekapa wahjachi te'teriamechitiao: aaata ichikoame; ki kaaweruma yoorame wahjachiwichioo; suwepori ihsiwa yoorame; ki waami weeriame aamo ahjama nayewame, yawichiwichio koparoame. ");
INSERT INTO var_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Neeea oosa iyoriame neeea chorowario, oowisari taawechisiopua. Neeea no'o yowiyao, senepi oosa mariki toomi iinuekaionia, aamo poanatakiamenia piiripio.” ");
INSERT INTO var_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Nape puuu yawichiwichio koparoamea, ahpo muripa sonikao, chiiatapua mekapi werikao: “No'o tewekachi kahtiame No'nóo, no'o tesiwe e'remitia muuua, no'oo tatakoriamekopa.” ");
INSERT INTO var_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Pu'ka cheesaapa, Eesusia cheerepua: —Neeea aamo chaanenapua, ihji yawichiwichio koparoamea, cheriwetiame no'rarepua ahpo ta'pechio, nape piirea ka'i. Riosia ki keepuamepua aaataoi, ahpo wa'api werumataka naewameopua. Nape tesiwa cheeka nayewameopua, cheriwiame Riosia pu'kao, tatakoririao. ");
INSERT INTO var_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Eesusi masiteka ihsioio, wa'a e'enariaipua ooweru kukuchi i'toka, Eesusi kahtiachisi upanariapa, Eesusio ahjachi seekarepaka ahpo kaawerumari yahchemichio. Nape Eesusi te'ta masitewaraa wa'a uparetioopua, wa'ineriaipua ooweruo, pu'ka kukuchi Eesusichi asitepuawichioo. ");
INSERT INTO var_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Nape Eesusia ki reesiseniopa pu'ka kukuchi, apochi asitepuawichioo, chaanerepua: —Tooa pu'ka kukuchio noochi e'enamichio. ¿Ki nane'riame eemea pu'ka kukuchika te'tiamekopua Riosi ye'karichi muimeria? —cheere Eesusia. Simitekaopua cheekao, Eesusia cheerepua: ");
INSERT INTO var_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","—Pichiwapua no'o chiia: Ki kukuchichitia uukamea Riosi paajutewao, ahpo ye'kari muimichioo, kiisi reesisepuamepua Riosieo, ahpo ye'karichi pakimichioo. ");
INSERT INTO var_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Piiripi tijoe itapiti paamiratuamea, iinatukerepua Eesusio: —Kaaweruma Masitari, ¿aachin iintotania ahsepanariaa, ki wahjiame ahjaniameo? ");
INSERT INTO var_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Eesusia chaanerepua: —¿Achini no'o kaaweruma teewamemua? Te'ta Kaawerumaa, Riosichepua, ki aaata wa'asi. ");
INSERT INTO var_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","¿Kikosa nane'riamemua Moise nuurari chiio? ¿Ki eeekosa chiiamepua?: “Ka'te suwepori nokimitia eemea, ka'te merimitiapua aaataoi, ka'te ichikoemitiapua aaataoi, ka'te wihtuka wenejimitia aaataoi, aamo yayawao muuua, yoorekache tetewipuapua.” ");
INSERT INTO var_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","—Wee Masitari, nape neeea pu'kao, yooma yooraka yasitokamenia pu'kao, temariai o'inia —chaanere iinatukeniamea. ");
INSERT INTO var_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Eesusia wa'a chiiopao, chaanerepua pu'kao: —Nape toitiame muuua aamo iintomiaopua pehjio. Nehjimitiaopua naaju, yooma aamo paarasatiao, wa'a iintosaapa muuua, yooma ihkokemitiapua pu'kao yooma aaata tooremuka mochikameo. Wa'a iintosaamua, te'pa Riosi kahtiachi iinuemamua aamo paarasario. Yooma wa'a iintosaapamua waikao, noochi enepuapua no'o ku'isimiao. ");
INSERT INTO var_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","I'ka inamukapa paamiratuame tijoea, iiyana eraparepua Eesusi wa'a chiiao, ki ookapi itapiti paarasatiamekapapua. ");
INSERT INTO var_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Waikao Eesusia wa'a iikopa pu'kao, yooma wa'a keepuka ajakameo chaanerepua: —¡Ki teesa tehki tiamepua, paarasatiamewichioo, Riosi ye'karichi pakipuameopua! ");
INSERT INTO var_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Animari tumusaria epeche ki tehki enemiipua, i'ikia puusirachiami u'matoteniaapua, ki puuu tijoe paarasatiamechitiaopua, Riosi ye'karichi pakimichioo. ");
INSERT INTO var_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Inamukamea chaachaparepua waikao: —¡Aa! Wa'a teeresoo, ¡aatanakamera newipatapua waikao? ");
INSERT INTO var_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Eesusia waikao chaanerepua: —Ti'tijoeriwichioo, ka'chi iika iintome tiiamekoio, nape Riosiwichioo, kihta tehki tiiamekaitepua. Nape Riosia aaata ahpo te'ta paarasarichi weemuwa toisoo, apochikamera te'ta weemusoopua waikao, reesisemapua pu'kaoi, ahpo ye'karichi pakimichioopua. ");
INSERT INTO var_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Waikao Peeroa muuwaeniachio, chaacharepua: —Wa'a teeresoo teemea, kaawe te'tiamepua aamo ajawariaa, aamo ahjama ohjomiaopua yooma toakamekapao, taamo iinueriaopua itapiti. ");
INSERT INTO var_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Eesusia chaanerepua: —Pichiwa puuua, yooma aaataa ahpo ta'pe toikamea, ahpo uupioi, ahpo poponioipua, ahpo tetejimaoi, ahpo tatanaoipua, Riosi ye'kariwichio ikimiapa ahpoo, ");
INSERT INTO var_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ehpe o'inia i'ka weeechio epeche nateyame tewimeripua Riosichio, Riosie ahpo kiapuameopua, wa'asi kajuyachi taawechio, weemera mochiwachiopua tiameo, weemera ahjari kiapuamepua tiameo, ki wahjiame. ");
INSERT INTO var_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Eesusia poanachi i'toka ahpo ajawariao, chaanerepua: —Ehpeo Eerusareni mo'moenama teemea, wa'ao, yooma ikimiachipua wa'asio, pu'ka ehkoriami nayewatura iyoteriaopua, no'o Tijoe Tijoetukamechi simiyameopua. ");
INSERT INTO var_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Wa'ao seesenu ti'tijoeria no'o Tijoe Tijoetukameo, na'ara yorapuamepua, na'ara chaanepuamepua tiameo, akachupepuamepua tiame; ");
INSERT INTO var_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","pu'ka nanaarame ti'tijoeeo wepipuamepua, wa'a yorasaopua meripuamepua, nape neeea meritiaio, paika taawe simiyachio, ahjaka oijenamania. ");
INSERT INTO var_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Nape Eesusie ajawatiamea, kihta pahterepua pu'kao, wa'a chiioio; ka'chi iika pahteme tiame enerepua. ");
INSERT INTO var_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Eesusia amori asiyai Erikoo, aaata ki ma'chiriame pooechi kahtiame tetewarepua, ihko itaka kahtiame. ");
INSERT INTO var_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Ihji ki ma'chiriamea, weeru cheetoame inamukapa pooechi nokisiameo, iinatukerepua: —¿Ihtana yooramepu wa'a cheetoamea? ");
INSERT INTO var_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Waikao neesetoamea chaanerepua: —Aa, Eesusi Nasare ohjoemepua, i'wami u'matoame. ");
INSERT INTO var_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Waikao ki ma'chiriamea, sisinamurepua Eesusio: —¡Eesusi, ehkoriami Raawi taanara! ¡No'o cheriwesa pahchúu! ");
INSERT INTO var_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Pahcha nokisiamea chaaneriaipua pu'kao: —¡Ihchi yasakáa! Nape puuua ohsotia weeru sisinakao, chaanerepua: —¡Muuúu! Raawi taanáraa! ¡No'o tesiwésaa! ");
INSERT INTO var_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Waikao Eesusia weripakao, ki ma'chiriameo, ahpo weeriachi u'yepanurarepua. U'yepatiaapa pu'kao, Eesusia iinatukerepua: ");
INSERT INTO var_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","—¿Ihtana aamo yorajeranimu no'óo? Waikaopua ki ma'chiriamea nehjiarepua: —No'o ma'chirepatejerani neeea. ");
INSERT INTO var_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Waikao Eesusia chaanerepua: —Saukame itipinamua aamo ki ma'chiriao. Muuua saukamemua, noochi paparakapa. ");
INSERT INTO var_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Waikao ki ma'chiriamea, ikanati ma'chireparepua puichio. Wa'a iikapa puuua, wa'api o'inia na'naritorepua Eesusio, tisiwa kaaweruma nayewasika Riosio. Waikao yooma ti'tijoeria wa'a tiiame tetewikamea, ka'karuma nayewasirepua tiame Riosichio, tísia kaaweruma chaachapakaopua Riosio. ");
INSERT INTO var_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Eesusia Eriko mochiwachi pakisao, riisaka u'matomo o'rariaipua, ");
INSERT INTO var_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","nape Saakeo tewaniame tewakapao, sewina eraparepua. Puuu Saakeoa, yawichiwichio koparoame, paamiratuame enerepua, tísia tomiwaeme tijoe. ");
INSERT INTO var_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Ihji tijoea, tísia tetewinareriaipua Eesusio, nape wichipa weeriamekapao, ki ajasepapapua ti'tijoeri aampamiopua tetewinariaio, ");
INSERT INTO var_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","pahcha u'masirepua Eesusi u'matomiachi, sikomoro tewaniame kuuuchi mooenamia, te'pa werika tetewinaria. ");
INSERT INTO var_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Eesusia teeriami u'matomiaio, te'pa kahtiame tewakapao, chaanerepua: —Saakeo, yaapi tekisa wa'ao, aamo ta'pechi no'o i'tojeraninia ko'komia. ");
INSERT INTO var_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Waikao Saakeoa, ikanati tekikao, ahpo ta'pechi i'torepua, kaawé e'raka. ");
INSERT INTO var_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Waikao ti'tijoeria, Eesusi Saakeo ahjama akipakame tetewikapao, ihchi ahpo chaachaparepua: —¡Naakona! ¿Tatakoriame ta'perachi siminapua? ");
INSERT INTO var_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Ehjepao ta'pechio, wa'a mochikai nayewakao, Saakeoa yooma inamuachi chaanerepua Eesusio: —Tísia kaawe erapaka aamo chiiaeo, kaaweruma enepanariapa ehpeo, naasipasi kiamane no'o iinuekao, tooremuka mochikameopua ihta, yooma no'o ichikoneriao, naaosa epeche no'o ichikoneria kiamania pu'kao. ");
INSERT INTO var_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Waikao Eesusia chaanerepua yooma wahja wa'a mochikameo: —Riosi newiparia, ehpe o'inia o'iniamepua i'ka ta'pechio, ihji Saakeoo Riosichi paparariopa, Aurani tetejimarisiwachi enepaka, Riosi te'ta ye'karichiopua. ");
INSERT INTO var_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Neee Tijoe Tijoetukamea i'ka wehjoarichio, i'ka Saakeoka te'teriame, i'yaka eenakamenia, te'ta Riosichi paparame, ti'tijoe ooweru tiameo, tatakoriameo, te'ta newipatemia kokosapuaio. ");
INSERT INTO var_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Neipa Saakeo ta'perachi machenasaapa Eesusia, pooechi ihtoai Riosi ye'karichi simiyame nayewakao, ti'tijoeria waapikopa Eerusarenio, wa'a enemio maaere puuua, Riosi ye'kario. Eesusia wa'a erakopa pu'kao, i'ka wa'achitarichi nayewerepua waikao. ");
INSERT INTO var_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Waikao Eesusia o'inerepua nayewakao eee cheeka: —Wahka yasariataipua piiripi tijoe, yawichi enemeri, puuua wahka akipariataipua mehka pirenachi weeechi, ahpo yawichichitia werapuachi, yawichi weratiaapa enasaa, ahpo weeechi yawichitumichiopua. ");
INSERT INTO var_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Nape ke'chu simiyaiopua, oosa mariki ahpo tekipaname paaesaopua, watani siento taawesi yowiwa ki'yariatapua pu'kao, pipiripi. Puuua chaaneriatapua pu'kao: “Íya, tekipanamitia eemea i'ka toomio, no'o eenachisiopua.” ");
INSERT INTO var_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","I'kao simisoopao, tijoe ki nakiyamea, pukaminachi uhjurariatapua asimiachiopua, chaachapaka: “Ki nahki teemea pu'ka tijoeo, taamo yawichi enemichioo.” ");
INSERT INTO var_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Nape wa'a chaachaparioi pu'kao, yawichi weraretiatapua. Waikao eenechi enasaapapua ahpo weewachio, paaeriatapua waikao, ahpo tooeriaopua toomio, kehkisa yowiteriarepua ahpo toomio, e'raka. ");
INSERT INTO var_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Pahcha eenakamea ahpo teeko tomiwarae tekipanakamea, cheeriatapua: “Paamira, i'wa maani aamo tomiwaa, oosa mariki toomi epeche muuwekamepua pipiripia.” ");
INSERT INTO var_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Waikao yawichia chaaneriatapua: “Kaawe iintoremua. Kaaweruma iintokame tekipanamemua”, chaaneriatapua. “Wa'a aamo iintoriawichioo, kaawe iintorepua aamo tehkiwachio, oosa mariki muuwari mochiwari, aamo yachamane yawichitumichioo.” ");
INSERT INTO var_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Piire wa'a eenakamea ahpo tehkiwaeo cheeriatapua: “Paamira, i'wa maani aamo toomiwaa, mariki toomi tiame, ehpeche muuwekame pipiripichi.” ");
INSERT INTO var_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Pu'kao, yawichia chaaneriatapua: “Mariki muuwari mochiwachi, aamo yawichitemane aamoo.” ");
INSERT INTO var_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Ehpeche piirechi eenakamea, chaaneriatapua yawichio: “Paamira, i'wa maani aamo tomiwaa, wisasorichi to'waka kaawe kateweka neeea. ");
INSERT INTO var_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Ki tekipanakania pukaeo aamo majawiapa, kihta to'wakameai toomio yowiyamekopua; aamoo, kihta echakaiopua tiameo, apechunamekopua i'ipario.” ");
INSERT INTO var_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Waikao yawichia chaanerepua pu'kao: “Aamoopua ki kaaweruma tekipanameo, aamo wa'api naawesarie chapimania aamoo. ");
INSERT INTO var_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Wa'a tiiame no'o e'rekame enesaa, ¿achinikai ki toomi tekipanateniachi to'wakamua, paikapioi yowimichio no'o eenoiopua? Oowera kihta iintoremua.” ");
INSERT INTO var_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Puuua kajusapa chaanekao, ahpo waapi ajakameo chaaneriatapua: “U'yemitiapua pu'ka toomio, naatikamera kiamitiapua pu'kao, oosa mariki epeche yowitekamera.” ");
INSERT INTO var_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Nape ki tekipanakamera u'yemeria, chaachapariatapua yawichio: “¡Pu'káa? ¿Ki oosa mariki ki'yakamemua pu'kaopa?” ");
INSERT INTO var_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Nape yawichia chaaneriatapua waikao: “Iinuemea, iinuekai epeche kiapuamepua; nape ki iinuemea, ahkasi teesa iinuekaoi, u'yepuamepua.” ");
INSERT INTO var_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Wa'a cheesaapa, yawichia cheerepua: “Yooma no'o seepurawao, ki no'o nahkiekamea no'o yawichi enemichioo, i'wa no'o u'yepamitia pu'kao. I'wa upasaapa pu'kao, yooma ko'imitiapua pu'kao, no'o tetewachi.” Eesusi cheerepua tiameo i'ka wa'achitarichi ikipuame inatakaopua: —Neeeai eenechi tekisaapa i'ka weeechio, wa'achi iintomeri neeea, i'ka weeechi yawichi yasipamiaapa. ");
INSERT INTO var_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Eesusia i'ka nayewasaopua, Eerusarenite u'matorepua. ");
INSERT INTO var_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Eesusia Weetajeo waapi ihtoaiopua Wetania tiame, wa'ao Ooriwo kaawichio, ooka ahpo ajawaria uhjurarepua chaanesa: ");
INSERT INTO var_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","—Waami siimpamitia eemea mochiwachi, wa'a muirachio, wa'a teima eemea piiripi uuru o'yetiame, ki aaata oiwame pehji ahjachio. Na'sonasa no'o u'yepamitia pu'kao. ");
INSERT INTO var_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Aaatao aamo chaanesoo: “¿Achini iikai na'sochani eemea pu'ka uuruo? Apoe Paamiraa nakiyapua i'kao”, chaachapapuapua, pu'kao. ");
INSERT INTO var_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Waikao uhjuratiamea siimpakao, yooma wa'a tiame nateparepua pu'kao, Eesusi cheeriachitia. ");
INSERT INTO var_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","I'ka uuru na'sochaniaio, teekoraa iinatukerepua: —¿Achini iikai na'sochani eemea, pu'ka no'o puhku uuruo? —cheerepua. ");
INSERT INTO var_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Waikao puuua, chaachaparepua: —Taamo Paamira Eesusia, ahpo rewenurekapu ku'itapi. ");
INSERT INTO var_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Waikao Eesusia u'yepatiapa pu'ka uuruo, ahjachi ipetesapa wisasorio, yaasetorepua pu'kao. ");
INSERT INTO var_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Waikao Eesusio, uuruchi yasitoiopua pu'kao, yooma wa'a nokisiamea, ahpo wisasorie ipekesirepua simiyachio, pahcha. ");
INSERT INTO var_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Asiaiopua Ooriwo roomosachi o'inia tekiwachio, yooma muuwaeme nokisiamea kaawe e'rakao, weeru chaachapasirepua siinakao, ka'karuma naawesari siinasika Riosio, ki teesa tiame ki maaenari yooramekopa, ahpoo peenia e'raka tetewaria. ");
INSERT INTO var_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Puuua chaachapasirepua: —¡Ée Yawichíí! ¡Tewekachi eename yawichíí! ¡Apoeo tísia te'ta kaawérumaraa! ¡Tewekáchio ta'iria mochiwáaa! ¡Pu'ka ki nu'uti teerewame tewekachi o'inia eenameo, te'ta weruma iyoriwa pu'kawichióo! ");
INSERT INTO var_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Ookapi parisero wa'achi nokisiamea, chaanerepua Eesusio: —Masitárii, te'ya pu'ka aamo na'naritoameo, ki wa'a chaachapamichiopua pu'kao. ");
INSERT INTO var_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Nape Eesusia nehjiarepua: —I'ka ti'tijoe ooweru tiame wa'a chaachapame no'o teewetekekoio, ahkasi ihji i'wa tehteewaapechi siinakomapua, no'o asiya kaawe e'rewa siinakowao. ");
INSERT INTO var_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Waapi enepasaapa muuwari mochiwachio, nanarare puuua mochiwachi ne'nekaopua cheeka: ");
INSERT INTO var_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","—Yuuwesinania aamoo ki no'o machiriopa aatanakoopua no'oo, aaata aamo newipatemia eenakameo. Nape eemea aamo wa'inekamepua noochio. ");
INSERT INTO var_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Ehpeo ki teesa teeremeri aamo mochiwarichio, aamo seepurawaa norikame noorepaka ki ujumamichioo, ahjachi mooenapuame ajawasaapua norikameo. Kiisi kaawe teeremera eemea aamo ikiyao, aamo seepurawaa e'enasaapua, yooma we'ee i'morataka mo'moenasaapua norikameo, ");
INSERT INTO var_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","aamo aampa e'enamapua ko'isikao, yooma aamo tatanama ko'isika wehchi wewekaopua. Yooma ohjorewao sa'mikoreopua tiameo, yooma ko'rinamapua, chi'rinaka. Yooma wa'a tiame ikimeri muuua, ki machika tetewikapa muuu mochiwachia, aaata aamo newipatemia eenariaopua. ");
INSERT INTO var_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Neipa i'ka cheesaopua, napawikarichi eenakaopua, wa'a pakirepua yooremina tiopachi weeriamechi. Wa'ao, wa'a nehjameopua, tarayameopua tiame, yooma puuyanarepua pu'kao. ");
INSERT INTO var_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","I'ka puuyachaiopua, chaanérepua: —¿Ki Ehkoriami Iyoterichio, eee chiiamepua: “No'o kariwaa, no'oche naewapuachipua wa'ao?”, nape eemea ichikoame teesowara, iintapare eemea. ");
INSERT INTO var_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Wa'a iintosaapua, wa'a masitesirepua waikao tiopachi, senepi taawechi. Waikao o'inia neeseriosi pa'pamiratuamea, iyoteri ti'tijoea tiamea, wahjachi ti'tijoe wa'a mochiwarichi pa'pamiratuamea tiameai, i'yasirepua waikao, aachin teeka ahpo merimiaopua Eesusio, wa'asi werapapuawichiopua Eesusi masitiao. ");
INSERT INTO var_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Nape ka'chi yorame e'rarepua pu'kao, muuwaeme ti'tijoerio, pu'ka masitiachi chuchutopa pu'kao. ");
INSERT INTO var_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Piie taawechio Eesusio, ti'tijoeri masitioiopua tiopachio, pu'ka Riosi ka'karuma tuuyewari nayewioio, wa'a e'enare neeseriosi pa'pamuratuamea, iyoteri ti'tijoea tiame, mochiwari pa'pamiratuamea tiame. ");
INSERT INTO var_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Ihjia Eesusi naaepakao, iinatukerepua: —¿Aatana nuurena aamoo, i'ka yoramichioo? ¿Aatanachi utewaemua, i'ka aamo ihsiaopua masitekao? ");
INSERT INTO var_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Waikao Eesusia, chaanerepua pu'kao: —Eemekamera no'o nehjiapapua pahchao: ");
INSERT INTO var_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","¿Aatana ihsire Waanio, paatopuame ki'yakao, Riosi iintoriarepua, ti'tijoekosaoi? ");
INSERT INTO var_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Waikao aapoeo ahpo chaachaparepua: —Riosi iintorio taamo tuusoo, waikaopua taamo chaanemapua: “¿Achini iikai ki pichikeka eemea pu'kao?” ");
INSERT INTO var_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Ti'tijoeri reesiserio taamo chaachapasoooi, ti'tijoeriai taamo ko'imapua waikao tehtee pasipupaka, ti'tijoeria, Riosie reesisetiameko erakoapa puuua. ");
INSERT INTO var_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Wa'a erakosaapua puuua, chaachaparepua: —Ki nane'rena teemea —chaachaparepua. ");
INSERT INTO var_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Eesusia chaanerepua waikao: —Neeeai ki aamo nehjiamane waikao, aatana no'o reesisiaopua, i'ka no'o yoramichioopua. ");
INSERT INTO var_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Waikao Eesusia, i'ka wa'achitarichi nayewerepua ti'tijoerio: —Aaata tijoea panijuwari ajawariataipua ahpo wasachi weweripamichioopua, wa'a iintosaapua, aaata naasipasi uupuaichio taakesoo, yahchariatapua neesetomichioo. Wa'a iintosaapua, mehka simiriataipua pirenachi weeechi. ");
INSERT INTO var_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Asisoopa taakemiachiopua, uhjurariatapua ne'nemiao ahpo inatetiao, ahpo ne'netepuaichiopua naasipasio, ahpo naachutawao. Nape echiwa inatiamea pu'ka uhjuratiameo, wewesa uhjurariatapua pe'kuo, wa'atia seekaekaopua kihta i'toka. ");
INSERT INTO var_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Waikao eenechi uhjurariatapua, pu'kaoipua echitiachi inatiamea, na'ara chaaneka wepisaopua, wa'atia seekaeka uhjurariatapua eenechio, kihta i'toka. ");
INSERT INTO var_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Waikao paisa simiyachio teekoraa, piirechi eenechi uhjurariatapua, nape i'kaoi eechi inatiamea, kiiya merika wepisaopua, ma'chi ipariatapua. ");
INSERT INTO var_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","’Neipao wa'asipao, teekoraa e'rariatapua: “¿Ihtana yoratane ehpeo?”, e'rariatapua. “Aa, no'o taana uhjuramane naaju, no'o te'ta nakiya, yooremakoipua pu'kao, no'o taanakopa.” ");
INSERT INTO var_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Nape eechi inatiamea, i'kao wa'a eenakopao, chaachapariatapua ahpoo: “Nee, ihjipu tijoea, yooma ahpo noono iinuekao, ahjama itipimeria. Meritariapua pu'kao, taamowichio itipimichiopua, taamo teeko iinuwarao.” ");
INSERT INTO var_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Waikaopua pu'kao, ma'chipasaopua pu'kao, me'yariatapua pu'kao. Waikao Eesusia wa'a cheesaapua, iinatukerepua ti'tijoerio: —¿Ihtana iintomo erakona eemea, apoe echijuwari teekora enasaa? ¿Ki ko'itariarepua pu'kao? ");
INSERT INTO var_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Eje'e, yooma ko'imapua enasaa, wa'a iintosaapua pu'kao, piirechi inatetemapua wa'ao, tekipanamichioo. Ti'tijoeria i'ka Eesusi ahpo nayeweria inamukapao, chaachaparepua: —¡Naakona, kiisi wa'a noonoimii teemea! ");
INSERT INTO var_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Waikao Eesusia ne'nepakao chaanerepua: —¿Wa'a erakona eemea? Nape ¿ihtana chanika chaanikosapu Ehkoriami Iyoteria? Eee chiiamepua: Puuu tehte karitamee, ki nakika ipatiamea, puuu tehte wa'apia, epeche te'ta nateyame tehte enepamiitepua. ");
INSERT INTO var_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Pukachi tehte motochikamea, kahsimeripua chapakarao; pu'ka tehtee mesukamea, pihtukame itipimeripua. Wa'a chiiame Ehkoriami Iyoteria. ¿Ki no'okamera nayewaka chiiamejuarepua? ");
INSERT INTO var_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Ihji wa'achitaria, ahpowichiokopa pu'ka chaniwao, tiopa ne'nesero pa'pamuratuamea, iyoteri ti'tijoe tiamea, wa'api chapime erakoriaipua Eesusio, nape se'sewepakapaopua ti'tijoeria, ka'chi ikime e'rarepua, chapinariai. ");
INSERT INTO var_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Waikaopu wa'a tiiopa pa'pamiratuamea, aaata ajawarepua Eesusi na'naritomichio, aatia iintota inatemia, ihtaoi ki kaawe cheesoopua pu'kao, yawichichi i'toka wenejinariapa chapisá. ");
INSERT INTO var_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Ihjia waikao waika taawechio, ka'karuma ti'tijoe ahpo eratenareka Eesusio, chaachaparepua pu'kao: —Masitari, aamo chiiaa pichiwapua, nane'rena teemea aamoo, pichiwarichi teetoka masitiameko, Riosi nakiyachitia mochijeraka, yooma taamoo aaataoi, nu'nuntio weewerumaoi wa'achitia. ");
INSERT INTO var_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Pukaepa aamo iinatukena teemea: —¿Kaawe ohjoarepu Seresa yawichi kopariari nateteniao, ka'ikosa? ");
INSERT INTO var_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Nape Eesusia nane'riapaopua ki kaaweruma erakoai wa'a chaachapopaopua, chaanerepua pu'kao: ");
INSERT INTO var_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","—No'o ne'neteo piiripi toomi. ¿Aatanapu wa'a toomichi netetiamea? ¿Aatanapu tiame wa'a teere iyotetiamea, teewara? —Seresa puuua —chaachaparepua. ");
INSERT INTO var_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Waikao Eesusia chaanerepua: —Puuu enesoo toomichi kahtiameo, pu'kawichio kiapuame enesoo, pu'ka kiapuapua; nape Riosiwichio iyoriwa kiapuame enesoo, Riosikamera iyoripuapua. ");
INSERT INTO var_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Waikaopu chapimeria, kitachi chiia chapime e'rarepua Eesusio, ti'tijoeri tetewachio. Ohsotia puuua, tísia peeneka nehjiopa Eesusio, ihchi itipirepua, tísia peenia erapakaopua tiameo, Eesusi chiia. ");
INSERT INTO var_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Neipamio, Saruseopechi e'enariaipua Eesusichi iinatukemiao, itapiti ki kaawe chaachasoo chapinariapao. Puuu Saruseo ti'tijoea, ki pichikiame eneriaipua, mukukai eenechi ahjaniameo. ");
INSERT INTO var_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Puuua wa'a te'tiamekapaopua, chaachaparepua Eesusio: —Masitari, ehkoriami Moisea taamo chaaneka tooeriaipua ahpo nuurariwachiopua, aaata pa'chira mukisoo ki tatanaeka ahpo uupichio, kaawe neewimio tuunapua wa'api pooniraoipua, pukachi oowitiame tatanaremichiopua, ahpo pa'chi tatanarachitia enemichiopua. ");
INSERT INTO var_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Nee, aaataa oowisani ahpo poponieme eneriataipua. Yooma puuua pipiripio, ahpo pa'chi uupira ahjama neewiriataipua. Pahcha neewikamea ahjamao, wa'atia ki tatanaeka mukuriatapua. ");
INSERT INTO var_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Oosachi simiyamea, ");
INSERT INTO var_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","paisachi simiyamea tiamea, yooma puuu oowisaniapua tiamea, wa'achitia neewika pu'ka ooitiame ahjama, yooma wahjipariatapua tiameo, ki tatanaeka. ");
INSERT INTO var_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Neipao oowitiameai, wa'atia mukuriatapua tiame, ki tatanaeka. ");
INSERT INTO var_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Weh, ¿achini tiamera puuu ti'tijoe, te'ta kuunara enetapua pu'ka oowitiameo, eenechi yooma ahjatiachiopua, pichiwa ahjaniame enesoopua eenechio? ");
INSERT INTO var_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Waikao Eesusia chaanerepua: —I'ka weeechi ahjarichio, nenewiniachipua wahjipaniachipua tiameo, ");
INSERT INTO var_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","nape Riosi weemera ahjari ki'yariachiopua ahpo ahjamao, ki nenewiwachi enemeripua wa'ao. ");
INSERT INTO var_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Wa'ao, ki wahjipaniachi enemerapua tiameo, yooma Riosie eenechi ahjatetiachio, ti'tijoea ooweru tiamea, Riosi ku'iwarika te'teremeripua, ka'chitia taawechi wahjipame. ");
INSERT INTO var_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Eenechi ahjapuamea pichiwa enemeripua, wa'atiame taamo tetewitenapua inatarichio, Moisetaru tuuriaeopua Riosi ahpo chaaneriao, kuhsi tajenakamechi Riosio, ahpo chaanerio tuuriaeo. Pu'ka Riosio, Auranitaru Riosiwako tuurio cheerepua, Ihsa Riosiwara, Aakowoo Riosiwara tiame. ");
INSERT INTO var_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Riosia wa'a cheekao, wahjipariamekoiopa ahjameko tuuriamepua pehjio, Riosia ahjakame Riosiwarakapa. Wa'a teesoo Riosia, eenechi oijenatemeripua yooma ahpo ijinuwao, ti'tijoeo ooweruopua tiameo, i'wa weeechio wahjipakamekoiopua. ");
INSERT INTO var_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Waikao ookapi iyoteri ti'tijoea, chaachaparepua: —Wa'atepua. Ahjachi chaanimua masitari. ");
INSERT INTO var_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Aapoea ki oosa aampa iinatukerepua waikao, naawesarichi wichipamichioopua, seewiapa Eesusi nehjiamiaopua, iinatukenariai. ");
INSERT INTO var_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Nape Eesusia, wa'a chaachapasoopua iinatukerepua pu'kao: —¿Achini tiiachipa ti'tijoeria, Raawitaruchi eenameko tuuyamepua Riosie Weratiameo? ");
INSERT INTO var_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Ehkoriami Raawitaruai ahpo Wiikari Iyoterichio, eee cheerepua iyotekao: Te'ta Riosi Paamiraa, chaanekapua no'o Paamira Meesíao: “No'o ahjamina yasipamitiamua pehjio, ");
INSERT INTO var_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","ahkasi no'oo, yooma aamo seepurawao, aamo taaratere toapachisi tekeka.” ");
INSERT INTO var_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Eee cheekame enesoopua, ¿aatia tiiachipa ehkoriami Raawitaruai ahpo paamira teewarepua Meesíao, ki ku'itapi neipami naawamerioipua pu'kao? Aaataai ki ahpo paamira teewamepua, ahpo neipa naawakameopua. Wa'a cheeriopa ehkoriami Raawiaipua, Meesiaa epeche paamirakai tiiamepua Raawitaruchio. Wa'a teesoo Meesiaa, ki ehpesi o'inia wa'apitia paamira yasitoamepua, puuu Meesiaa, neee Riosie Weratiamepua. ");
INSERT INTO var_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Waikao yooma inamuachio, Eesusia chaanerepu ahpo te'ta masitiao: ");
INSERT INTO var_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","—Naane e'reka eemea, Moise nuurari ma'masitari nokayaeo, puuua tepekuma wakiraeka ohjowa pu'seriamepua, ahpo te'ta ka'karumako maaetiameopua Riosichio; muuwaeka nehjiwachi ohjoaiopua, ahpo yooreka teepotejerameopua; napawikarichioiopua, epeche ka'karuma mochipaniachi momochipanariamee; pahkotaniachioiopua, epeche ahpo teteiwachi mochipanariame, ");
INSERT INTO var_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","ooweru kunamukukame kariwaraopua, u'yeka pu'seriame; ki ku'itapisi ahpo Riosiwachi paparamechitia chaachapaka, oowera ahpo kaawe teteipuawichio nokaka. Nape puuu wa'a nokayamea, ki nu'unti kokosa aiwamiitepua Riosieo. ");
INSERT INTO var_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Eesusia wa'a ihsiaiopua ti'tijoeri naewekao, tetewarepu wa'ao, aaata ti'tijoeo ooweruopua tiameo, weeka totomiwaemeopua, toomi na'poa toaniachio, weeka toomi to'wame. ");
INSERT INTO var_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Aaata ooitiame tetewarepua tiameo, wa'achi eenariame toomi na'poaniachiopua toamia, puuua kunamukukame eneriamepua. Eesusia pu'kao, ooka wa'api toomi, kiisi weeka nateyame to'wame tetewakamepua. ");
INSERT INTO var_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Wa'a iikopao Eesusia, ahpo norikame ajakame ti'tijoerio, chaanerepua: —Nee, pichiwa chaanine i'ka oowitiameo, epeche nehjai tiiamekopua pu'kao, Riosiwichio oowewao, ki wahjachitia ti'tijoeri tísia totomiwaemeo. ");
INSERT INTO var_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Weeka totomiwaeme ti'tijoeria, ahpo soparatiakamera oowewamepua Riosio, nape ihji oowitiamea, kihta itipitiai ahpo ko'komiawichio taripuameo, yooma nehjarepua Riosiwichio oowewakao. ");
INSERT INTO var_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Wa'api i'isaeri tiopachi toomi toaniachi puuyapanioiopua, Eesusi te'ta masitewaraapua ookapia chaachapasiriaipua: Nee ihji tiopaa, ¿ki tísia peenia te'tiame tehtee peeniatatiamepua? ¿Kikosa te'ta peeniatatiamepua itapitie ti'tijoeri oowewariáo? Nape Eesusia wa'a chaachapopao, cheeka nehjiarepua: ");
INSERT INTO var_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","—Nape yooma ihji tísia peeniatiame aamo tetewao, enamitepua piie taawechio, piiripioi ihji tehtera to'weteka ahjae peeniatatiamea, piiripioi ki itipimeriitepua raampatao. ");
INSERT INTO var_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Waikao Eesusi te'ta masitiaa iinatukerepua Eesusio: —Masitari, ¿achinitio enetapu wa'a ikimeri ihji tiopaa? ¿Ihtana naaniatiwachi nane'reta teemea wa'a ikimiao? ");
INSERT INTO var_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Eesusia cheeka nehjiarepua: —Naane e'reka naaju, ki aamo wisikuepuawichioo, muuwaeme enapamitepu no'oko tuukao. Puuua chaachapamapu: “Neee puuua, Riosie Weratiamea; no'o eenaria asikamepua wa'asi.” Nape ka'te pichikemitiapua pu'kao, wa'a chaachapoio. ");
INSERT INTO var_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Nasiwaniame inamuaioopua wahkao, weeru nokayo tuuoiopua ahpo ahjama nasiwaka ti'tijoerio, ahkaoi i'ka wehjoarichio, ki te'ta seewepuapua pu'kaopua pehjio. Yooma puuua, te'ta aiwari pukeri o'iniachi enemeripua. Puuua, ki kajuyachikai teeremapua pehjio. ");
INSERT INTO var_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Eesusia simitere puuuapu cheekao: —Pirenapi ti'tijoeritukamea, pirenachi ti'tijoeritukame ahjama nasiwasimeri puuua; pirenapi yawichiwachio, pirenachi yawichiwachi ahjama, ahpo chapisimeripua nasiwasikao; ");
INSERT INTO var_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","weeeai, ki muenati noonomeripua, yomatiame wehjoarichiopua; toorewiai tísia aiwaniame ki nu'uti teeremeripua yomatiame wehjoarichio; tísia majaniameai ki nu'uti teeremeripua ahkasi yomatiame wehjoarichio; tewekachioi káátisia iinyatiame teteipuamepua, itapiti ikiyameo. ");
INSERT INTO var_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","’Nape ke'chu wa'a teetoiopua noochi paparamea, tísia na'ara yoramia naanaritopuamepua. Waika taawechiamio aaata noochi paparameopua, napawikarichiami upapuamepua wenejikao, napawikarichi te'ta pa'pamiratuamechio, karichi toapuaichiopua; waika taawechiamio tiame, ahkasioi te'ta weruma ya'yawichichi upapuamepua tiame wenejikao, noochi paparaka mochitoapaopua. ");
INSERT INTO var_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Yooma puuu noochi paparapa ya'yawichichiami i'topuamea, noochi simiyame kaawe chaachapameri puuua, ya'yawichichi pe'peirachi i'totiapaopua. ");
INSERT INTO var_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Nape pu'ka taawechi no'o nehpupawachi chanimiao, ka'chi eramete puuua ahpo ki kajumia chanimiao, ahpo no'o nehpuwaka nehjiamiaopua. ");
INSERT INTO var_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Neee wa'api ahjama ihsimeripua pukachio, ahpo no'o nehpuwachi ku'ikao, aaataoi ya'yawichioi, ka'chi iika newitome teeremichioopua, aaata no'o nehpupaka nayewameopua. ");
INSERT INTO var_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Waikachiami taawechiamio aaata ahpo wa'api ta'pechioi, ahpo wenejipuamepua, ahpo noonoeoipua, ahpo papachieoiopua, ahpo tetejimaeoiopua, ahkasi aaata ahpo kaawe uuyameeoi, ahkasi aaataeoi meripuameeoipua. ");
INSERT INTO var_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Pu'ka taawechio no'owichioo, yoomahka ahpo nekamumeripua nekamuao, ");
INSERT INTO var_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","nape ahpo Riosichi te'ta weemera ahjarichio, te'ta newitoka puuyameripua, kihta wekateka piiripioi ahpo kuupaopua. ");
INSERT INTO var_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Yooma aaata ki toakamea noochi ahpo paparao, newitoka puuyameripua, Riosi weemera ahjarichi mochipuameopua, Riosi ye'karichio. ");
INSERT INTO var_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","’Pu'ka taawechiami Eerusareni mochikameo, pochikame tetewapa norikame seesenu weeechi e'enakame soontaroo, asikame enemapua Eerusareni mochiwario, wehchi yachapuameoopua pihtunaka. ");
INSERT INTO var_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Waikao, yooma Uurea weeechiami mochikamea, kaawichi ujumapuapua, ka'chi ikipuaichio. Eerusareni mochikamea ma'chiami ahka ohjoamea, ka'chi iika nonowameripua ahpo ta'pechio. ");
INSERT INTO var_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Wa'a teeremeripua wa'ao, tísia aiwaniachi taawechikoopua, Riosia ki ahpokamera e'weka mochikopapua, tísia kokosamapua pu'kao. Wa'a teeremio tuuyame, Ehkoriami Riosi Iyoterichiopua. ");
INSERT INTO var_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","¡Ai, puuu ooweru peteterepakame mochikameapua pu'ka taawechiamio, kukuchi chiiteka mochikameapua pehjio! Ki teesa tesiwa te'teremeri puuua, ki teesa iinyatiame ikiniopa weeechio, ti'tijoerio. Weeeai kokosa aiwameripua tiameo, wa'a tiiame ikiyopa. ");
INSERT INTO var_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Pu'ka taawechi mochikamea, ki nu'uti teeremeripua ko'iniameo; chapitiamea, seenu weeechi i'topuamepua, pirenachi; Eerusareni mochiwaria, ahkasioi teketiame itipimeripua, ki Riosi iyoriamee nanaarame. Wa'a teeremeripua waika taawechiamio, ahkasi Riosio newitoka machenachisi, yomatiame nanaarame ti'tijoerio. ");
INSERT INTO var_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","’Pu'ka ihtoria taawechio, taaachio tísia iinyatiame teetomeripua, meechachio tiame, so'porichioi wa'achi. I'ka weeechioi, ki nu'uti siimapua wekana eraniamea. Ti'tijoeria, ka'chi ikime erameripua tiameo, pa'weo tahpitika chiiopua, pe'kokao te'okaopua. ");
INSERT INTO var_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Ki nu'uti iinyatiame simiyopa weeechio, tewekachiopua tiameo, mukipaka ruhjimapu ti'tijoeria, ki ahjame e'rapa ahpo iikachio, ki teesa majakaopua ahpo iikachio, tisiwa iinya tiiame ikimia i'ka weeechio, chaachapamapua. ");
INSERT INTO var_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Waika wa'a teerenioio, tetewipuame neee Tijoe Tijoetukamea, eenameo, naasipa toomari weritoame, ki nu'unti utewarieme teetoka, tahpitika tiame teetoka. ");
INSERT INTO var_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Yooma wa'a tiiame tísia iinyatiame tetewiniopao, waika taawechiami ti'tijoeria, kaawe erakoka yooma ahpo katewemapua, kihta toiyame nane'riapa tewekachi ahpo apechunapuachiopa. ");
INSERT INTO var_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Waikao Eesusia simiteka naewakao, cheerepua tiameo i'ka eeetiame wa'achitarichio: —Naakoo, inataka ne'nemitaopua chuunao, ihta kuuuoi. ");
INSERT INTO var_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","I'ka sewayoopa teemea, nane'remapua waapi teeto paamuniopa. ");
INSERT INTO var_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Wa'achitia ihjiai, yooma tetewapa i'ka aamo no'o chaaneriao, amori asinapua ihjia, erakopuapua, pu'ka Riosi iintomiaopua i'ka weeechio, yawichitukao. ");
INSERT INTO var_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","’Yooma i'ka iinyatiame tetewikamea, waika taawechiami ohjoekamea, ki wahjipama puuua, ki tetewaopua pehjio, yooma ikiyameopua ihta no'o cheeriaopua. Kiisi wehchi wichimapu no'o chiia. ");
INSERT INTO var_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Yomatiame we'ea tewekaa tiame, kajutarepua, nape no'o chiia wa'api teeremeripua, kiisi sewina iika ki wahjiamesi. Yooma no'o cheeriaa ikikache itipimeripua. ");
INSERT INTO var_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","’Aamoo, kaawe aamo inateka mochimitia eemea. Ka'te te'ta weemuka moochi eemea. Aamowichio kaawe eratewa yooraiopua, ka'karumachi simiyame yorapuapua pu'kao, ki u'matoka nawajika wekaniachisiopua. Ka'te aamo iikachi peewanate pu'ka itapiti aamowichioche yoraniameoipua; ki yooresaa eemea no'o chiiao, senawato mesuma eemeapu, pu'ka iinyatiame taaweeopua, teeremerieopua, ihta kaari amochi ru'miamechitia, matachinaka. ");
INSERT INTO var_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Kaawe aamo neesetopuapua naaju, ki aamo wichimichiopua itapiti wiitari ihsumarichio pu'ka taawechio, ki teesa iinya tiiame ikiwame teeremerichio, yomatiame i'ka wehjoarichi mochikamewichioo. ");
INSERT INTO var_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Aamo neesetoka mochimitia aamo iikachio, pu'ka taawechiwichioopua. Senepi nayewaka mochimitia aamo Noono te'pa kahtiame ahjamaopua, ki se'wika, ahkasi no'o eenachisiopua, no'oo Tijoe Tijoetukameo, yooma katewemioiopua, ti'tijoeri te'tereka mochiriaopua. ");
INSERT INTO var_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Senepi taawechio, napawikarichi ijisire Eesusiapu masitekao, tukaoopua, ooriwo kookochire puuuapu teewi, kaawitiachi. ");
INSERT INTO var_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Senepi piario, ti'tijoeria wa'a eejenaparepu keepumia. ");
INSERT INTO var_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Waika taawechiamio, amori asiaipua pahkoa, paani ki rewaruraeme koi'wameo, Semejenato pahko tewaniamea tiameo, ");
INSERT INTO var_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","napawikarichi ne'nesero pa'pamiraa, i'isaeri iyoteria tiamea, naapi i'yaiopua Eesusio, aachin teeka meripuameopua nape noriwí, kiisi aaata tetewachi, majayapa ti'tijoerio, ki ahpokamera chapisipuawichiopua puuua. ");
INSERT INTO var_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Piie taaweo, Uurasi Ihkariótea, piiripi puuu Eesusi ajawaria, oosa mariki aampa ooka ajawatiamea, Satanasie noonoteretupua. ");
INSERT INTO var_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Ihjia noriwi simikao, isaeri napawikarichi ne'nesero pa'pamiratuameopua, yooma tuuyere puuuapu akana teipuame Eesusio, noriwi tarichere puuuapu pu'kao, pukamina naewaka. ");
INSERT INTO var_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Waikao aapoeo, tísia kaawe erakokaopua, natetemo tuurepu Uurasio. ");
INSERT INTO var_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Uurasia kaawe iintasaopu pu'kao, i'yasire puuuapu aachin teekao ahpo nehjimiaopua Eesusiopua, wahka noriwi, ki muuwaeme tetewachiami. ");
INSERT INTO var_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Asisoopa pahko paani ki rewaruraemeo, pu'ka po'wao te'ta meriwachiopua, Semejenato pahkowichioopua, ");
INSERT INTO var_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","waikao Eesusia, Peeroo Waaniopua tiameo, chaanerepua pu'kao: —Siimpamitiapa eemea, kooame yoramia, Semejenato pahko kooame, taamo ko'komiaopua. ");
INSERT INTO var_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Uhjurapuamea iinatukerepu: —¿Akana yorajeranimua pu'kao? ");
INSERT INTO var_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Eesusia chaanerepu pu'kao: —Nee, muuwari mochiwachi muisaapao, wa'a teteima eeme piiripi tijoe, neropai sikori mahtotoame, pu'ka na'naritopuapua, ahkasi karichi pakiyachisi. ");
INSERT INTO var_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Wa'ao, asika chaanepuapua kariwaemerao: “Masitaria iinatukiapu, akana yooreko enamerikopua, Semejenato pahko kooame yorakepuaichio, ahpo masitari ahjama ko'komiachio.” ");
INSERT INTO var_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Waikaopua, tepakarichi aamo ne'netema puuuapu, yooma katewetiame ajakachi, kooame ahjae yorapuameopua, yooreminao, weere enemapu wa'ao. Wa'a yorapuapua kooameo. ");
INSERT INTO var_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Waikao siimpasaopua wa'ao, yooma wa'a tiame teware puuuapu, ahpo chaaneretiachitia. Waikaopua, wa'a yoorarepu kooameo. ");
INSERT INTO var_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Ehjepamio wa'a e'natioopua, Eesusia waikao, yasiparepu ko'komiao meesa weeriachio, yooma ahpo ajawariopua ahjama. ");
INSERT INTO var_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Wa'aopua Eesusia cheerepua: —¡Káátisia e'rainia i'ka Semejenato koi'niameopua aamo ahjamao, ke'chu no'o tísia aiwatenioiopua! ");
INSERT INTO var_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Pichiwa simiyame ihjia, ki seenampa no'o ko'komania i'kaopua, ahkasi Riosi ye'karichi mochikapa, yooma ihta ikimerio, ikikopa. ");
INSERT INTO var_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Waikao, iijipaso uusapao ahpo sekachio, cheriwema nehjisaopua ahpo Noono tewekameo, chaanerepua ahpoe ajawatiameopua: —Íya, iijio pu'kao, yoomahka pipiripio; ");
INSERT INTO var_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","ki oosa aamo oowemania i'ka uuwa neerora iijiwariopua, ahkasi Riosi ye'karichi mochipachisi taamo ahjama. ");
INSERT INTO var_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Wa'a cheekaopua, paaniopua tiameo uusaopua, cheriwema kiasaopua ahpo Noonoo, pu'ka paanio, naasipasi chi'wanasaopua, te'ta ahpo masitia ki'yarepua chi'wapame ko'komichioo. Wa'a iintosaapua chaanerepua: —Ihji paania, no'o weerewapua aamo tatakoriwichio pejana natetemia. No'o ki'tioiopua, i'ka nokaka mochitomitiapua, ahkasi taawechisi, no'o aamowichio mukuka iintoria inatapasika. ");
INSERT INTO var_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Wa'a ikisaopua Eesusia, paanio ko'kotioopa, wa'achi iintoka apechunaka iijipasoo, pu'ka iijipaso ne'netekao chaanerepua: —Ihji aamo iijimiaa, no'o eerapua, aamowichio wi'sumeri aamowichio mukukao. Pu'ka wa'a no'o mukuriaeo, Riosiea aamo tatakoriria cheriwepuame pichiwatame puuua, yooma noochi paparakameo. ");
INSERT INTO var_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","’Aa, nape i'wa kahtipua apoea te'ta puuu no'oo, noriwi iintomeria. Taamo ahjama kahtipua koaka. ");
INSERT INTO var_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Neeea Tijoe Tijoetukamea, wa'a yooraka meripuamenia, wa'a tiiame inatariopa apoe no'o Noonoo, tewekachi kahtiameo. Nape ai puuu, no'o noriwi nehjikamea. ");
INSERT INTO var_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Waikao Eesusi ajawaria, Aatanakamerajuarepu wa'a iintomeria, chaachaparepua ahpoo. ");
INSERT INTO var_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Ehjepao, Eesusi ajawaria, ahpo wa'ineriai puuuapu waikao, aatanakamera ahpo weruma paamiratuame enemerikopua. ");
INSERT INTO var_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Nape Eesusia wa'a chaachapame inamukapaopua, chaanerepua: —Yomatiame ahkaoi wehjoarichio, mochikamepua ya'yawichio, tísia utewa yooraka tetewamekopua, ahpo yawichituwachi ye'karichi mochikameopua. Pu'ka ya'yawichi ti'tijoeria, tísia iyorika tetewamepua. ");
INSERT INTO var_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Nape eemea amochio, ki wa'a te'tereka mochitopuapua. Ohso kaawe eemea amochio, napati aamo wa'achi te'tereka mochitomeripua. Aaata epeche weruma paamiratuame enenariamea, ki werumachitia teeremeripua amochio; aaata nuuriamera enenariamea, aaata puhku seekaerewachitia tiiame enemeripua, ahpo wahjachiwichioo. ");
INSERT INTO var_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","¿Aatanakosa naaju, epeche teerewaemea, meesachio mochikamera koaka, meesachi ajawiamekosa kooameo? ¿Ki puuu ohjoarepu naaju, mesachi mochikame koaka? Nape neeea, aamo paamiratuameai, aamokamera yorakiamerania. ");
INSERT INTO var_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","’Nane'renania aamo aiwariao no'o ahjamao, yooma ihta no'o aiwa teetoria ikiyachi. ");
INSERT INTO var_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Pukaepa neeea, wa'achitia no'o Noono weerariachitia ahpo ye'karichi ye'kamichioo, wa'achitia aamo ajawame neeeai, ");
INSERT INTO var_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","no'o ye'karichi ye'kamichiopua no'o ahjamao. Aamo ya'yawichi ajawamania no'o ye'karichio, oosa mariki aampa ooka yawichituwachiopua, isaeri ti'tijoeri tetejimarichiopua. ");
INSERT INTO var_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Nape ke'chu wahka ihtoriachi ahpo ajawaria ikimioio pehjio, ehpe taawechiami ikipuame nayewerepua ahpo ajawariao. Waikao Eesusia Siimoni Peeroo chaanerepua: —Aa muuu Siimoni Peero, utewaeme aamo chapipuapua, Satanasia tahpitika aamo yoojoranariamekapu yuuwesitekao, yooma aamoo no'o ajawariachiopua, tiiriko mooarachitia aamo eejepunariapu, wa'a aamo yooraka aamo u'yenariapa te'ta noochi paparao. ");
INSERT INTO var_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Nape neeea itakamenia no'o Noonochio, aamo ku'ipuaichioopua, kiisi sewina erapamichiopua aamo noochi paparao. Pu'ka wa'a tiiame yooma ikisaopua Satanasie aatiatario, eenechi kaawerumachi enepasaopua, tísia ye'kame enemamua waikao, te'ta aamo kaawe cheeka tuuyemiaopua, no'o aamo wahjachi ajawariaopua, kiisi toaka mochinurekaopua pu'kao, te'ta noochi iyoriaopua. ");
INSERT INTO var_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","—Nape Paamira —chaanere Peeroa— Satanasia kiisi no'o yuumpameripua no'o aatiatao. A'chitiameoi no'o yoraniaio pukaeo, anachamania aamowichioo, karichi yachatiaiopua, meripuamekaipua. ");
INSERT INTO var_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Nape wa'a chiioi Peeroo, Eesusia chaanerepua pu'kao: —Muuu Peeroa, ka'te aamo oise e'remua, te'ta. Wa'a chiiaiomua, ke'chu kusuyoipua totorio, paisa simiyame no'o ka'itamapua, kiisi no'o machiyo tuuka. ");
INSERT INTO var_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Waikao Eesusia, chaanerepu ahpo ajawariao: —Nane'riame eemeapa, no'o aamo wekanami mochiwachiami uhjurarioiopua kihta i'toka uhjurarioipua, kihta toomi i'toka, kihta i'toka mokewario, kakajoyaoi weekao. ¿Ihta itapiti nakiwa aiwakamekosa eemea wa'ami ohjoaio? Aapoeo nehjiarepua: —Ka'i. Kihta nakiwa aiwakame teemea. ");
INSERT INTO var_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Eesusia chaanerepua waikao: —Nape ehpe waanami ki aamo ahjama no'o kahtioio, nakimeri eemea aamo itapiti i'toka ohjomiao, toomio, wisasoriopua tiame; aaata eemea ki peeturi maacheta iinuemea, tarimaoipua piiripi ahpo ampawakiraoi nehjisa. ");
INSERT INTO var_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Chaanerepua tiameo: —Ehpe asirupua, pu'ka Ehkoriami Iyoteri chiiao noochi simiyameo, puuua chiia: “Nanaaramechi teteipuame puuua, na'aramechitia.” Yooma puuu wa'a cheeka iyotetiame Ehkoriami Iyoterichio, ikimachepua. ");
INSERT INTO var_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Eesusi ajawariaa chaachaparepua: —Aa, i'wa iinueka teeme ooka nasimachetao, aamo nehpupapuaeo. Nape Eesusi chaanerepua: —Ka'te wa'a chaachapa eemea. Ki nasiwaka taamo nehpupameri teemea. ");
INSERT INTO var_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Eesusia wa'a cheesapa, Ooriwo kaawichite no'rarepu, yayasaniachi ahpo Noono nayewemia, ahpo ajawarewaoi yeetoka. ");
INSERT INTO var_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Asisapao cheerepu: —Nayewamita eemea Riosi ahjamao i'wa, ki aamo a'chi e'ra na'arachi, ruhjimichio. ");
INSERT INTO var_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Wa'a cheesaapapua, epeche wa'ami akiparepua, piie tehte pasipuniachi keenako, wa'aopua, ahpo Noono ahjama naewamia. Wa'ao chopokorieka weripakao cheerepua: ");
INSERT INTO var_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","—No'noo, no'o cheriwepua muuua i'ka tísia no'o aiwamiao, wa'a tiame erasaamua noochio; nape ki no'o chiiachitia iintojeraninia no'oo, aamo te'ta e'rachitia iintojeraninia no'oo. ");
INSERT INTO var_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Waikao piiripi Riosi ku'iwaria, wa'achi machejenarepu chokichi, iika yachapatemichiopua, ahpo tahpitika e'rao. ");
INSERT INTO var_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Wa'aopua, ki nu'unti tahpitika e'raka apochiopua, epeche yuuweeme nayewere puuuapu ahpo Noono, taipochiraoipua, ki ku'ita wehchisi ichuparepu, eerachitia. ");
INSERT INTO var_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Werisisaapa puuua wa'a o'iniao, waami eenarepu ahpo ajawario, toariachi. Wa'a enasao, kokochiame tewakapua pu'kao, kihta yorame e'ropa yuuwesikao, ");
INSERT INTO var_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","chaanerepu: —Mochisisa, mochika nayewe eemea Riosio, aamoo, ki aamo ruhjimichiopua na'ara e'rachio. ");
INSERT INTO var_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Wa'a chiioipua pu'kao, wa'atikia nokisirepua soontaroapa muuwaeme ti'tijoeri ahjama, pahcha weritorepu yeetoamea, piiripi puuu oosa mariki ooka Eesusie te'ta masiteniamea, ihji tijoea, Uurasi tewaniámera. Ihjia, Eesusi naaepakao chuchurepu. ");
INSERT INTO var_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Nape Eesusia wa'a yoratiaopua, chaanerepua: —Uurasi, ¿piiripi chuchuwachi nehjanimua, Tijoe Tijoetukameo? ");
INSERT INTO var_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Waikao ahjama mochikamea, maapori tiame simiyopao, chaanerepua Eesusio: —Paamiraaa, ¿nasiwasitariare merimachetae? ");
INSERT INTO var_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Waikao piiripi Eesusi na'naritoa, pu'ka napawikarichi ne'nesero paamiratuame seekaerewao, meteka tehpunarepu nahkaraopu piiripi, ahjamina weeriamera. ");
INSERT INTO var_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Eesusi cheerepua: —¡Ka'te wa'a iintomua! ¡Mooena yasaka! Waikao Eesusia, nahkara tehpuriachi chapikaopua, weemera enepaterepu eenechi. ");
INSERT INTO var_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Wa'a ikisa Eesusia, ne'nesero pa'pamiratuameo, napawikarichi kapitaiopua tiameo, mochiwari pa'pamiratuameopua tiameo, ahpoo i'tomia e'nakameo, chaanerepua: —¿Merimacheta i'toka enapani eemea no'o chapimiao, kuuu makoka tiame, no'oo, ki nu'uti ichikoamechitia? ");
INSERT INTO var_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Ki ehpesi aamo tetewachi no'o ihsioi napawikarichio, ¿kiisi no'o chapika eemea? Nape ehpe wa'a noonoimeri eemea, ehpe kiatiame Tukapari Noonoraai, wa'a iintomichioo. ");
INSERT INTO var_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Waikao chapisao, ne'nesero paamiratuame ohjirachi i'toretupu waikao. Waikao, Peeroa na'naritore puuua, mekapi. ");
INSERT INTO var_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Eesusi i'toamea ajasisaapa, ta'pechio na'yarepua. Wa'a ikisaapa, wa'a mochiparepua tatapamia. Peeroai wa'achi yasipariaipua tatapaniachio. ");
INSERT INTO var_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Wa'a tekipaname piiripi oowitiamea, na'i tajayachio, kaawe ne'nepaka pu'kao, cheerepua: —¿Ki pu'ka ahjama oiyame ihji? ");
INSERT INTO var_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Peeroa chaanerepua: —Ka'i, ki maachinia pu'kao. ");
INSERT INTO var_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Neipatakiriopua, piirechia cheerepua: —Puuuchi muuuai, ahjama oiriamea. Nape Peeroa nehjiarepu: —Ka'i, seenunia pu'kao. ");
INSERT INTO var_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Epeche ehjepamio, piie keenakomi ahkao, cheerepu piirechi: —Puuuchi ihjiai, ki aaata piirechi ihjia, Arirea tijoea ihjia. ");
INSERT INTO var_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Nape Peeroa chaanerepu: —Ka'i, kiisi maachinia aamo chiiao. Pu'ka wa'apichi chiioi Peeroo, totoria kusurepu. ");
INSERT INTO var_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Waikao, Eesusio ku'rika ne'nepakoopua, Peeroa, inateparepu waikao, eee cheeria: “Ke'chu kusuyoi totorio ehpe o'iniao, paisa no'o ka'itamamu.” ");
INSERT INTO var_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Wa'a iikapa Peeroa, machenakaopua wa'ao, ki teesa yuuwesika nanararepu. ");
INSERT INTO var_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Eesusio inatiamea, na'ara chaanerepu pu'kao, wepaka. ");
INSERT INTO var_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Puichiami purisaopua ki ma'chiremichioo, wewesapa, chaanerepua Eesusio: —Ehsoo, ¿aatana aamo weweru? ");
INSERT INTO var_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ki ookapi na'ara naawesari chaanerepua tiame. ");
INSERT INTO var_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Ma'chirepasoopua, mochiwari ne'neseroa, napawikarichi ne'neseriosi pa'pamiratuamea, iyoteri ti'tijoea tiame, napawire puuuapu. Waikao Eesusia, wa'a uparetupua, te'ta napawi napawitiachi. Wa'a upatiopaopua, iinatukeretupua: ");
INSERT INTO var_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","—Taamo chaanemitiakoo, ¿Riosie Weratiameko tuuyamemua, taamo yawichi enemichioo? Nape Eesusia cheerepua: —Eje'e no'o cheekoio, kiisi no'o pichikema eemea; ");
INSERT INTO var_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","itapiti aamo iinatukekooi, kihta pichiwaka no'o nehjiama eemea. No'oo pichiwaka aamo nane'retekoio te'ta aatanakoo, kiisi no'o toimapua. ");
INSERT INTO var_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Nape ehpe o'inia neee Tijoe Tijoetukamea, ye'kamia yasipamerinia, no'o Noono tewekachi kahtiame yasirachi yawichitumia yasipamania, no'o Noono ahjaminaopua, tísia utewariekaopua. ");
INSERT INTO var_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Waikao puuu pa'pamiratuamea, chaanerepua Eesusio: —Wa'a teesoo, ¿Riosi Taanarakoti muuua? Eesusia nehjiarepua: —Wa'atepua. Ki se'wipua aamo chaachapao. ");
INSERT INTO var_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Waikao pa'pamiratuamea, ahpo chaachaparepua: —¿Ihtana nakita teeme epeche nane'reniameo? Soparame ahpo ma'chitari cheekamepua wa'asio, ahpo wa'api chuwae. ");
INSERT INTO var_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Waikao, Te'ta Weruma Napawitiachi o'iniao, yoomahka werisikao, Piirato peereirachi i'toretu Eesusia. ");
INSERT INTO var_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Wa'a upasopua, Piiratochi wenejirepua waikao, chaachapaka: —¡Yawichi! I'wa aamo u'yepaka teeme i'ka tijoeo, weeru chaachapatiapu taamo mochiwachio ki natetepo tuuyekaopua, te'ta Seresa yawichiwichio koparoaniameopua, rooma yawichi kahtiameopua. Apoeopua tiameo, Riosie Weratiame yawichiko tuuyapu puuua. ");
INSERT INTO var_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Wa'a chaanetiaapa Piiratoa, chaaneka iinatukerepua Eesusio: —¿Pichiwa yawichiju muuua, i'isaeri ti'tijoerio? Eesusia nehjiarepu pu'kao: —Wa'atepua, aamo chiiachitia. ");
INSERT INTO var_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Wa'a tiame inamukapa Piiratoa, napawikarichi neeseriosi pa'pamuratuameo, yooma wa'a napawikame ti'tijoeriopua tiameo, chaanerepua: —Pu'ka aamo chaachapa i'ka tijoechio, kihta a'chi tiame iintoria tewakamenia pukachio. Wa'a tiiachio ihjia, ki asiyamepua te'ta kokosapuameo. ");
INSERT INTO var_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Nape aapoeo, epeche utewaeme chaachaparepua Piiratoo: —Ahpo masitiaeopu ti'tijoerio, weeru chaachapatiapua, yomachi taamo mochikachiopua. Ihjia, Arirea weeechi o'inesao wa'a tiame masitekao, wa'achi ihsinapua ahkasi i'wa Eerusarenioi. ");
INSERT INTO var_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Piiratoa Arirea o'inerio tuuopa Eesusio, iinatukerepua wa'a muuwaemeo, Eesusio Arirea tijoekoopua. ");
INSERT INTO var_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Pu'ka muuwaemeo, Arirea ohjoemeko tuukopa Eesusio, Eerore yawichie katewepo tuurepua waikao, Eerore ye'karichikopua wa'ao. Waikao Piiratoa, Eerorechi i'yetonurerepua Eesusio, pu'ka taawechiami Eeroreo, Eerusareni eenariamekopua. ");
INSERT INTO var_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Eerorea Eesusi tetewapao kaawe e'rarepua, tehpe o'inia tetewinareka yasitoriaipua, Eesusi tísia peenia ihsiame inamukapaopua, tísia tetewinarere puuua achini ihsiao. ");
INSERT INTO var_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Ahpo kahtiachi upatiopao, Eerorea ki ookapi itapiti utewa chaaneka iinatukerepua, nape Eesusia kihta nehjiarepua. ");
INSERT INTO var_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Wa'achi mochirepua tiameo, neeseriosi pa'pamiratuame, Moise nuurariwa ma'masitari tiame, tísia utewaeme wenejika. ");
INSERT INTO var_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Waikao Eerorea soontarowaraopua tiameo, na'arerepua waikao a'chikoi chaaneka Eerore tetewachi yooma ahjama wa'a mochikameopua tiame. Yawichi wisasorira chuhcherepua tiame na'arekao. Kajusaapa wa'ao na'arekao, eenechi Piiratochi i'yetorepua Eesusio. ");
INSERT INTO var_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Waika o'inia kaawe erapare Eerorea, Piiratochi ahpo nekumeka mochiriao. ");
INSERT INTO var_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Waikao Piiratoa Eesusi u'yepatiaopua, yooma napawinurerepua i'ka ti'tijoeo: i'isaeri neeseriosi pa'pamiratuame, mochiwari pa'pamiratuameopua tiame, yooma wa'a Eerusareni mochiwarichi mochikameopua tiame. ");
INSERT INTO var_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Napawisoopua, Piiratoa chaanerepua: —Ki nu'unti wenejika no'o u'yepariai eemea i'ka Eesusio, ti'tijoeri weeru nokitio chaachapaka, nape i'kao neeea, aamo tetewachi te'ta iinatukekamenia, eeme wa'api tetewakamepua pu'kao, no'oo kihta na'ara iintokame tewakamekopua pukachio. ");
INSERT INTO var_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Eeroreai kihta na'ara iintoriame tewakapa, no'o uhjurekamepua i'ka Eesusio. Ma'chiame tetewame eemeai, kihta iintoriamekopua pu'kao, meripuawichioo. ");
INSERT INTO var_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Waikaonia wa'a tiioopao pu'kao, wepisache toimania pu'kao. ");
INSERT INTO var_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Wa'a chaanere Piiratoa wa'a muuwari napawikameo, senepi paamuparichi Semejenato pahkochio, piiripi peereso toiwamekopua pu'kao, ti'tijoeri kaawe erakomichioo. ");
INSERT INTO var_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Nape muuwaria Eesusikamera toinariopua Piiratoo, yoomahka weeru sisinaka chaachaparepua: —¡Ka'i pu'káo! ¡Warawasikamera toipuapua ohso kaawe! —chaachaparepua. ");
INSERT INTO var_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Nape Warawasia tijoe ko'yame eneriaipua, nasiwari mehtachame eneriai puuua. ");
INSERT INTO var_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Piiratoa eenechi chaaneriaipua ti'tijoerio, Eesusikamera toinario tuuka. ");
INSERT INTO var_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Nape muuwari ti'tijoeria, epeche utewaeme siinakokao, chaachaparepua: —¡Kurusichi merisáaa, kurusichi merisáaa! ");
INSERT INTO var_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Paisa simiyachi wa'a chaachapoipua Piiratoa, chaanerepua: —¿Nape aatía? ¿Ihtána iintokamepua naaju ki kaawerumao? Neeea ki tewakame pu'kao, ihta meripuame tiiameo. I'kao neeea, wepisache toimania. ");
INSERT INTO var_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Nape muuwaria, wa'api chaachaparepua siinakokao: —¡Kurusíchi merisáaa, kurusíchi merisáaa! —chaachapaka. Wa'a chaachapaka simiterepua, ahkasi Piiratoopua ahpo erakoa e'wachisi. ");
INSERT INTO var_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Waikao Piiratoa pu'ka muuwaeme chaachapao, e'wérepua. ");
INSERT INTO var_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Piiratoa waikao wa'a iintorepua waikao. Tijoe ko'yamekamera, puhjerepua waikao, Eesusiopua, nanaaramechi ki'yarepua, aapoeo ahpo e'ra nokimichiopua pu'kao. ");
INSERT INTO var_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Ehjepamio, pooechio i'tonioiopua Eesusio kurusichi merimiao, pooechi nateparetupua piiripi tijoe, Siireneo ohjoeme Siimoni tewaniame, tekipanaio eename. Waikao Eesusi mooketoaopua kurusio, pu'ka ku'ika mooketonureretupua, Eesusi pukamina weritoka. ");
INSERT INTO var_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Wa'a pooechi Eesusi i'toniachio, ki ookapi nokisiriai ti'tijoea ooweru tiame. Oowerua tesiwe e'rekaopua Eesusio, weeru chaachapasirepua naarakoka. ");
INSERT INTO var_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Nape Eesusia ooweruchi ku'rika ne'nepakao, cheerepua pu'kao: —Eerusareni Ooweru, ka'te naarako eemea no'owichioo. Aamowichiokamera naarakopuapua, aamo tatanawichio tiame. ");
INSERT INTO var_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Enamiitepu taawe chaachapaniamea, Ehkoriami Iyoteriao eee chiiao: “¡Tísia kaawe erakomeri ooweru ki tatanatamea, ka'chitia taawechi ki peteterepakamea, ka'chitia taawechi kohja chiitekamea!” ");
INSERT INTO var_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Pu'ka kajuyachi taaweo chaachapama ti'tijoeria tiame: “¡Tamochi ru'misa kaawíii! ¡Taamo wetemaka ichipupasa kaawíii!” ");
INSERT INTO var_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","I'ka nokioiopua no'o siiyoname kuuu ki wakiyame kuuu pehjio, ¿achipu nokitarepua, no'o kuuuchitia wakipasoopua wa'asi? Ihji kuuu siiyoname weritoame chaniwamea, no'o weeechi oioio ahjariamepua; ihji kuuu wakiyame chaniwamea, no'o i'wa kiteremio no'o cheeka chiiapua. ");
INSERT INTO var_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Wa'a chaanerepua Eesusia, soontaroe i'toio pu'kao, ahpo merimiachi. Wa'achi i'toretupua tiameo, wahjachi ooka ti'tijoe, ti'tijoe ko'yame, Eesusichitia ko'ipuame kurusichi. ");
INSERT INTO var_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Ajasisaapua Mukukame Mo'ojoa tewaniachio, kurusichi chucharetu Eesusia mukimichioo. Wahjachi ooka ti'tijoeopua tiameo, wa'achi chokichi ku'kurusichi chucharetupua, piiripia ahjamina, piirea owemina, ku'kurusichi wahjipamichiopua tiameo. ");
INSERT INTO var_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Wa'a kurusichi chuhkuaio Eesusia, cheerepua ahpo Noono Tewekachi kahtiameopua: —No'no, cheriwepuapua i'kao wa'a nokayoio, ki no'o te'ta machiyamekapa, wa'a nokayamepua. Wa'a chuhkoi Eesusio wisasorirao, puuu inatiamea soontaro, ahpo newitowa te'erepua wisasorirao, aatanakamera, ahpo ahjama itipimerikopua pu'kao. ");
INSERT INTO var_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Muuwari ti'tijoea ooweru tiamea, wa'a ajarepua ne'nekao. I'isaeri pa'pamuratuamea wa'achi ajarepua tiameo, Eesusi kurusichi chuchatiameo, na'areka, eee chaachapaka: —Newipatio tuurepua wahjao, ehpeo ahpo wa'api newipatemetepua, Meesia enesaa Riosie Weratiame. ");
INSERT INTO var_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Soontaroai Eesusio na'ara chaachaparepua, itapiti cho'koame neero, pi'piteka. Puuua wa'a yoorakao, chaachaparepua: ");
INSERT INTO var_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","—Isaeri yawichi enesaamua, ¿achini iikai ki aamo soontarowa nuuriamemua, aamo tekipumichioo, aamo nehpupaka? ");
INSERT INTO var_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Te'pa kurusichi moochiminao, wa'a manirepua iyotetiamea, puuua chiiame: “Ihjia, isaeri ti'tijoeri Te'ta Yawichirapua.” ");
INSERT INTO var_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Piiripi tijoe ko'yame kurusichi chuchatiamea, na'arariaipua Eesusio chaaneka: —¿Ki Meesíakosamu muuua, Riosi taamo uhjureriao newipatemichioo? Yaapi aamo newipasa naaju, taamo newipatepuapua tiame. ");
INSERT INTO var_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Nape piire kurusichi chuchatiameapua tiame, ta'omarepua pu'kao, wa'a chiiopao: —¿Kiisi iyorina muuua Riosikoipua pu'kao? ¿Ki wa'achi teerenia muai? ");
INSERT INTO var_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Teemea na'ara noonoikapa i'wa chuchatiamepua, nape puuu apoea, kihta yoorakai i'wa chuchatiamepua. ");
INSERT INTO var_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Wa'a cheesaapa, chaanerepua Eesusio: —Aamo ye'karichi kahtiaiopa, no'o inatepajeraninia. ");
INSERT INTO var_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Eesusia chaanerepua waikao: —Ehpe o'inia no'o ahjama yasimeri muuua, te'ta peenia tiame paarasarichiopua. ");
INSERT INTO var_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Wa'a te'terenioi wa'ao, oowetawe o'inia tukapasiparepua, ahkasi paika keenako simiyachiopua arikiri, yoomachi weeechi tukapasipaka. ");
INSERT INTO var_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Taaaai, ahkasi wa'a keenakosi, choipakame yasarepua waikao. Eerusareni tiopachioipua waikao, Riosi iyoriwachi to'piameai wisasoria, te'pa o'inia teeresi si'parepua tiame. ");
INSERT INTO var_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Eesusia arikiriopao, ki ku'ita sisinarepua cheeka: —¡No'no, aamo neesetowachi toaninia no'o iika! Wa'a cheesache, mukurepua. ");
INSERT INTO var_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Waikao rooma kapitaia, yooma wa'a iikame tetewapaopua, kaaweruma nayewerepua Riosio, wa'a ikisaapa cheerepua: —Pichiwa ihji tijoea, kihta iintokame eneriaipua, ki kaawerumao. ");
INSERT INTO var_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Yooma wa'a e'enakamea ne'nemiao, yooma i'ka iikame tetewikamea, no'wapaiopua, ahpo moripa chonisirepua, kiisi kaawe noonowiretio, erasikaopua. ");
INSERT INTO var_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Yooma Eesusi tetejimaraa, Eesusi kaawe tetewikameapua tiamea, ooweru tiamea Arirea o'inia Eesusi na'naritokamea, wa'a itipirepua pehjio, mehka ajaka ne'neka. ");
INSERT INTO var_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Eerusarenio, yasariaipua piiripi tijoe, Oose tewaniame. Puuua isaeri tijoe eneriaipua Arimatéa ohjoeme. Puuua, te'ta weruma napawirachi teeriame eneriaipua, kaaweruma tijoe. ");
INSERT INTO var_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Puuua ki ahpo pirenaturi wa'achitia inatame eneriaipua, wa'a ikitiamechitiaopua Eesusichio. Ihjiai tiameo, Riosie ye'kari yasipapuame, inataka yasitoame eneriaipua. ");
INSERT INTO var_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Ihji Oosea Piiratochi simikao, itanerepua Eesusi weerewarao, katewemio tuuka. ");
INSERT INTO var_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Reesisetiaapa puuua, Eesusi chuchatiachi eenaka tekipurepua. Tekipusaapua Eesusi weerewarao, riino tewaniamechi wisasori tohsanamechi uusaopua, ahjachi ikapirepua. Ikapisaopua, wahjipame toaniachi i'torepua tekimia, weemera teesotatiame, ki aaata tekiwachi pehji. ");
INSERT INTO var_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Wienechi enerepua pehjio, sawarachi resipuniameo, amori o'ichachi. ");
INSERT INTO var_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Arirea e'enakame oowerua, na'naritokaopua, kaawe tetewarepua Eesusi weerewarao, tekitiachio. ");
INSERT INTO var_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Puuu ooweru Arirea e'enakamea, ahpo che'repachi nonowasaapa, peeniajuri na'poarepua, itapiti chuhchepuameopua tiame. Wa'a ikisao oowerua sawarachi taawechio, resipurepua, wa'atia yachatiamekopapua, Moise nuurarieo. ");
INSERT INTO var_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Waikao oowerua, oowisari taawe o'wicharichiopua (toomikochi eneriaipua waika taawechiamio), pa'a piari siimparepua Eesusi tekitiachio, ahpo peeniajuri na'poariao, i'toka. ");
INSERT INTO var_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Wa'a ajasisaa ne'nioiopua tekitiachiopua, wahjonatiame tewarepua wa'ao, puuu wa'a tehte yeeteraa, ikicha yasarepua. ");
INSERT INTO var_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Wa'a muirepua waikao ne'nemiao, nape Eesusi weerewaraa, kitererepua wa'ao. ");
INSERT INTO var_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Waikao oowerua, weeka inatarepua, ihtana ikiriaopua wa'ao. Ka'chi ikime e'roiopua pu'kao, senawato ahpo chokichi ajapakame tetewarepua, ooka tijoe tísia totosaname tajayame wakiraeme, tewekachi e'ename Riosi ku'iwari. ");
INSERT INTO var_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Pu'ka tewakapaopua ahpo chokichi ajakame, tísia majarepua pu'kao. Wa'a iikapa puuua seewepamaopua pu'kao, wehchisi koomorasiparepua, yoorewika. Waikao Riosichi e'enamea chaachaparepua: —¿Achinikai wahjipame toaniachi i'yani eemea, aaata ahjameo? ");
INSERT INTO var_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Puuua aamo i'yaa, ki'tepua i'wao, ahjakamepua wa'asi eenechio. ¿Ki nane'renakosa eemea Arirea kahtiaio ");
INSERT INTO var_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","paika taawechi teetoio oijenamio tuurio, nanaaramechi nehjitiaiopua kurusichi meritiaio? ");
INSERT INTO var_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Waikao oowerua, inateparepua Eesusi cheeriameopua. ");
INSERT INTO var_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Wa'a iikapa puuua nonorarepua, tuuyemia pu'ka oosa mariki aampa piiripi Eesusi te'ta masitiao, wahjachi wa'a mochikame Eesusichi paparame tiame. ");
INSERT INTO var_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Tuumia e'enakamea Eesusi ajawariao, naati enerepua: Maaria Maarena, Uhwana, Maaria Saantiao yeeyera tiame, wa'a ikisa wahjachi ooweru, ahjama ohjoame tiame. ");
INSERT INTO var_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Nape Eesusi ajawariaa, kiisi pichikerepua pu'ka ahpo tu'tuyameo, kiisi maaeporikopa chaachapao. ");
INSERT INTO var_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Nape wa'a tiioi Peeroa, u'masirepua ne'nemiaopua, tekitiachi. Asika yooremina ne'nioiopua, kiteerepua aaataai, ahjae ikapi tiameche wa'a yasarepua, riino wisasori. Waikao Peeroa no'rarepua tahpitika erasikaopua: “¡Naakona wa'a ikirepua!”, erasika. ");
INSERT INTO var_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Pu'ka wa'api taawechi Eesusia, ooka ahpo na'naritoame machijenerepua, Emausi mochiwachi simiyameopua pooechi, wa'ao Eerusareni piari machenasao, oowetawesi asiwame. ");
INSERT INTO var_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Puuu pooechi nokisiaio, Eerusareni ikitiame ahpo nayewesiriaipua. ");
INSERT INTO var_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Wa'a nokisinioiopua nayewasikao, senawato naaepaka ahjama weritore Eesusia. ");
INSERT INTO var_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Nape wa'a Eesusi ahjama siimpaiopua, aapoeo Eesusi tetewaio, kiisi machirepua. ");
INSERT INTO var_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Ku'itapi simiyaiopua ahjamao, iinatukere Eesusia: —¿Ihtana naewasina eemea pooechi nokisikao? ");
INSERT INTO var_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Waikao yuuwesiame ajapakaopua Kereojá tewaniamea, chaanerepua: —¿Muuuchekosapua, ki nane'reka itipiameopua pehjio, ihpi taawechiami Eerusareni ikitiameo? ");
INSERT INTO var_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Eesusia wa'a cheeka nehjiatiaapua, eenechi iinatukerepua: —¿Ihtana ikiretupua naaju? Waikao aapoeo, chaachaparepua: —Wa'a Eerusarenio aaata meriretiapua, Nasare tijoe Eesusi tewaniame, Riosi nayewakame enekame. Puuua, ki ookapi itapiti kii maaepori iintokameaipua, tísia peenia ihsiwa. Weruma masitari Riosichi eename enekamepua, tísia kaawe tetewitiame ki ookapi ti'tijoerieo. ");
INSERT INTO var_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Nape taamo ne'neseriosi pa'pamuratuamea, rooma ya'yawichichi nehjariapua kurusichi meripuawichio. ");
INSERT INTO var_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Pu'ka Eesusieo teemea, taamo mochiwa yawichiwa poanatuwa puuyetoai teemea, na'sopuameopua wa'asi taamo rooma yawichi ye'karitere mochitoao, nape puuua mukukamepua wa'asi, paika taawe i'toamepua. ");
INSERT INTO var_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Pa'a piarioi ooweruai taamo ohjoekachi ohjoemeapua tiamea, tísia taamo majatekapua, ki teesa tiiame taamo tuuyeriaeopua. Pa'a piari siimpakai Eesusi tekitiachiopua, ");
INSERT INTO var_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","ki tewako tuukapua wa'ao, wa'a e'enakaiopua ne'nemiao. Wa'a nonorasaapua, ooka tijoe tewekachi e'ename tetewiko tuukapua, Riosi ku'iwari. Ihji Riosi ku'iwaria Eesusio, eenechi ahjario tuuriatapua. ");
INSERT INTO var_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Wa'a chaachapariopa ihji ooweruo, wahjachi taamo ahjama mochikame tiame, siimpariaipua tiame ne'nemiao, wa'achi chaachapakapua tiame ooweru taamo tuuyeriachitia, kitererio tuukapua tiameo, Eesusi mukukame tekitiachio. ");
INSERT INTO var_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Waikao Eesusia chaanerepua: —¿Kiisi ijinatame eemea i'ka wa'a tiame ikitiameo, aamo pahtemiao? ¿Kiisi pahtekame eemea, ehkoriami Riosi nayewaturao aamo chaaneriameopua ahpo iyoteriachio? ");
INSERT INTO var_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","¿Ki wa'a tiame aiwamerikosaaipu Meesiaa, apoe Riosie Weratiame tewaniamea, ke'chu tewekachi mooenaipua, yawichi yasipamiaopua? ");
INSERT INTO var_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Wa'a chaanesaapua, o'inerepua waikao, kaawe tuuyekao, yooma ahpo nayewaka chaachapario tuurepua puuu Riosi nayewaturao, ahkasi Moise Iyoterichi o'iniaopua, ahkasi yooma wahja Riosi nayewatura chaachapariachisi, Riosie ahpo iyotetesiwao. ");
INSERT INTO var_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","I'ka pooechi nokisiameo, ahpo ta'pechi ajasimioio, Eesusio riisaka u'matomerikopua, ");
INSERT INTO var_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","nape aapoeo utewa yoorarepua chaachapakao: —Ariwanipa wa'asi, ohso kaawe taamo ta'pechi che'repasa u'matopuapua meere. Waikao ahjama asirepua ta'perachio. ");
INSERT INTO var_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Ehjepao ko'kopuachioipua wa'ao, Eesusia, piiripi paani uusaopua, cheriwema ki'yarepua ahpo Noonoo. Wa'a iintosaapua pu'ka paanio, naasipa chi'wanasaopua, wa'a ko'komeri ki'yarepua. ");
INSERT INTO var_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Ahkasi wa'a iintokopa Eesusio, ahpo ta'pechi paajutekamea, machirepua Eesusio, ahpo ki'yoiopua paanio chi'wanoi. Waikao Eesusia wa'a iintosao, ahjama kahtiaiopua tetewachi, senawato ki naania ikirepua. ");
INSERT INTO var_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Wa'a ikikoopa chaachaparepu: —¿Kíkosa tamochi eename saaeka teeme iikachio, pu'ka taamo nayewioio, pu'ka Ehkoriami Iyoterichi chiia taamo nayewioio tuuyekao, puuu apoe Eesusikopa, wa'a erekore teemea? ");
INSERT INTO var_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Waikaopua ikanati werisika siimparepua Eerusarenio, wa'a ajasitiopa, pu'ka oosa mariki aampa piiripi Eesusi ajawariaopua, napawikame tewarepua wa'ao, wahjachi ahpo ahjama ohjoame tiame. Puuua pu'ka ajasikameo, chaachaparepua: ");
INSERT INTO var_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","—¡Pichiwa Eesusi oijenariaa, Peero tiame machejeneriopa! ");
INSERT INTO var_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Waikaopu ooka wa'a ajasikamea, yooma tuurepua tiameo, pooechi ahpo ijikiriao, achini teeka ahpo machiriopua Eesusio, ahpo ko'komia paanio, naasipa chi'wanasa ki'yoio. ");
INSERT INTO var_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","I'kao, wa'a chaachapaoiopua tuukao, naasipa weripame tetewiretupu Eesusia. Wa'a weripasaapa, teepotarepua cheeka: —Kúíra, Riosie ta'iria mochikáaa. ");
INSERT INTO var_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Senawato wa'a weeriame tetewikapaopua, tísia majarepua, naayuri maayapa. ");
INSERT INTO var_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Nape Eesusi chaanerepua: —¿Achinikai tísia majawa eemea? ¿Tísia tehkikosamua no'oo aatanako pichikemiao? ");
INSERT INTO var_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","40","¿Ki neeekosapua naaju? Ne'nesao naaju no'o sekachio, no'o tarachiopua tiame. Noochi ihchepaka, ne'neo. Tijoe neeea, ki naayuri. Naayuria, ki no'oka tiiame weerewaeme puuua. ");
INSERT INTO var_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","I'kao ki te'ta ahpoko maaeka teteopao, chaanerepua: —¿Iinue eeme ko'kopuame? No'o kiapuapua ko'komichioo, nane'retai neeekopua. ");
INSERT INTO var_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Waikao so'chi wahsetiame kiaretupua. ");
INSERT INTO var_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Waikao pu'ka kiatiaopua, ko'karepua ahpo ajawaria tetewachi. ");
INSERT INTO var_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Ko'kosepasaopua, chaanerepua: —Yooma ihji no'o ikiriaa, yooma no'o aamo nayeweriapua, aamo ahjama oiyaiopua pehjio. Yooma ihji no'o ikiriaa, Ehkoriami Moisetaru Iyoteria chiiapua, ahpo Iyoterichio, ehkoriami Riosi nayewatura, chaachaparia tiame, wa'a ikisao, yooma Ehkoriami Wiika Iyotaperichi chiiaopua tiame. ");
INSERT INTO var_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Wa'a cheesaapa, yooma epeche kaawe tuuyerepua Ehkoriami Iyoterichi chiiao, kaawe ma'chiame, ki tehki eramichiopua pahtekao. ");
INSERT INTO var_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","I'ka Iyoterichio, ma'chiame chiiamepua Riosie Weratiameo, meripuamekopua, meritiaiopua, paika taawechi oijenamiopua eenechio. ");
INSERT INTO var_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Yomachi weeechi siimpameri eemea tuuyemiao, i'wa Eerusareni o'inekao, yooma i'ka no'o iintoriao. Riosichi paajutepuapua ti'tijoeriopua ooweruoopua tiameo, ahpo tatakoriria cheriwepuawichioo, yooma aaata ahpowichio uukameopua no'o iintoriao, yooma ahpo toimo tuukameopua ahpo tatakoriniameo. ");
INSERT INTO var_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Tuuyemitia i'kao eemea, yooma i'ka no'o iintoria tetewikamekapa eemea. ");
INSERT INTO var_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Nape ehpeo pehjio, Eerusareniche nokimera eemea, ahkasi Riosi kiamo tuuria, kianiachisi. Ahkaoi ki se'wi ohjomeri eemea pehjio, ahkasi no'o Noonoo tewekachi kahtiameo, utewari aamo ki'yachisi. ");
INSERT INTO var_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","I'ka weeechi oika kajusaapa Eesusia, ahpo Noono tewekachi kahtiamee oijenatetiaapa wa'asio, Wetania eenarepua waikao muuwaeme yeekao, ahpo na'naritoame. Wa'a asisaopua te'pa seekarepakao, kaawerumari yahcherepua wa'a ti'tijoerio. ");
INSERT INTO var_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Wa'a iintosaapa Eesusia, te'pa apechurepua tewekachi, ahpo ne'neka ajakameo weeechi toaka. ");
INSERT INTO var_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Waikao ahjama na'narito Wetania e'enakamea, Eesusi tewekachi mooenoiopua: “¡Nee, te'ta pichiwa tewekachi o'inia eenakame enerepua.” Waikaopua kaaweruma nayewasacheopua, nonowarepua Eesusio, Eerusareni nonowarepua, tísia kaawe eratoka. ");
INSERT INTO var_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Wa'a o'inia waanamio, aapoe wa'api ahpo Riosi tioparachi nanapawirepua, senepi taawechi Riosichi paparamiao. Wa'asi ihji no'no iyoteka chiiaa. Cheriwema wa'asio, yooma i'ka no'o iyoteria iyonamerio. Neeea Riosieo, tísia kaaweruma teetojeramenia amochio.");
INSERT INTO var_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Kúíra, yomatiame wehjoarichi mochikame ti'tijoe, ooweru kukuchi tiamé. Neeea Waani tewaniamepua, piiripi puuu Eesusi ajawaria, Riosie Weratiame weratiamenia. Ihji no'o iyoterichio, taamo te'pa kahtiame Noonochi simiyame nayewamania, aachin teereriopua i'ka weeechi eenariao. Paikapioi nayewama neeea, ihtana yooraka oikame Eesusio, i'ka wehjoarichi mochirachiopua. Wee, i'wa o'inemania paikapioi taamo Noono te'pa kahtiame, no'o pahteteria. Ihji no'o iyoteri chiiaa, ihjipua: Pukeri o'iniao ke'chukoipua i'ka wehjoarichio, Riosi tiiariraa ahjaka yasariai puuuapa, puuu tiiarirachi kahtiamea, Naera tewaniame enerepua. Puuu Naera tewaniamea, Riosi te'ta tiiarirachi teerewaeme enerepua; puuu te'ta tiiari Naeraa, Apoe te'ta Riosikai teererepua. ");
INSERT INTO var_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Puuu Tiiari Naeraa, wa'apitia kahtiame enekamepua Riosichio, Riosi tiiarichi teerekao. ");
INSERT INTO var_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Riosia pukae te'ta tiiarichi tiiame Naeraeo, yooma ihtaoi iintuame enepaterepua; yooma ihtaoi iintuamea, piiripi ihtaoi ki'tiamepua, ki pukae enepatetiamea, Naerae. ");
INSERT INTO var_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Pukachi Naera tiiarirachio, te'ta ahjari teereniame enerepua, ti'tijoerichi tahjiame enerepua, puuu ti'tijoerichi Tahjewaria ti'tijoeri pahtepatiame puuua; yooma ti'tijoe ooweru tiame i'ka wehjoarichi mochikameo, taamo Noono Riosichi simiyame pahtemichiopua. ");
INSERT INTO var_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Puuu Pahtewari Tajayamea, i'ka wehjoarichio, ti'tijoeri tukapachi mochitoamechi eenarepua. Puuu tukaparia ka'chi iika cho'wakamekopapua pu'ka wa'a eenakame Tahjewario, puuu Tahjewaria wa'api tiiamepua ti'tijoerichi tahjewakao. ");
INSERT INTO var_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Pu'ka taawechiami pu'ka Pahtewari Tajayame tukapachi te'teriamechi eenoio, piirechi Waani tewaniame ki neee, yasariaipua, Riosie uhjuratiame. ");
INSERT INTO var_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Puuu Waani Riosie uhjuratiamea, pu'ka Pahtewari Tajayamechi simiyame nayewekamepua, aatanakoo puuu Pahtewari Tajayamea. Puuu Waania ti'tijoerio, pu'ka Pahtewari Tajayamechi paparanurekapua, keepuka pichikemichiopua pu'ka Pahtewari Tajayame chiiao. ");
INSERT INTO var_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Wa'a tiiachio Waania, ki puuukamerakai enerepua, Pahtewari Tajayamea. Puuua ti'tijoerio, oowera Pahtewari Tajayamechi simiyame nayewemia eenakame enerepua, aatanakoopu Pahtewari Tajayamea. ");
INSERT INTO var_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Puuu te'ta Pahtewari Tajayamea, i'wa wehjoarichi eenakamepua yooma ti'tijoerichi tahjepamia, Riosichi simiyame pahtetemia. ");
INSERT INTO var_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Puuu Pahtewari Tajayame i'wa wehjoarichi eenakamea, Riosi Naera puuua, Riosi inataka naewamia. Nape pu'ka taawechiami ti'tijoeria, pu'ka Riosi Naerao tewekachi o'inia eenakameoipua ahpo weee neteriachio, ki machika tetewarepua pu'kao, apoe iintokamekoipua, yooma ihta weeechi iintuame netekaopua. ");
INSERT INTO var_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Ihjia, ahpo weeechi eenakame eneriaipua, apoe ahpo neteriachi, nape weeechi mochikame ti'tijoeria, apoe iintokamekoipua yooma ihta itapiti iintuame netekao, kiisi nakika tetewarepua pu'kao. ");
INSERT INTO var_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Nape muuwaeme ti'tijoeria ki wa'a erakoka tetewarepua pu'ka te'ta Pahtewari Tajayameo i'ka weeechi eenakameo. Nape te'ta apoe i'wa wehjoarichi eenakamea, kaawe uuka ahpo tetewikameo, ahpo chiia pichikekameopua tiame, Riosia ahpo tatanara enepaterepua pu'kao. ");
INSERT INTO var_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Ihji Riosi tatanara enepatetiamea, ki ooweruchi naawamekapa Riosi tatanara tiiamepua, Riosie uutiamekapa Riosi tatanara puuua. ");
INSERT INTO var_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Puuu taamo Noono Riosi tiiaria ahpo Naerao, tijoe iintapamo eraparepua pu'kao, i'ka weeechi oimichiopua ahpo e'rari naewatukao. Pukaepa oowitiamechi naawaterepua pu'kao, i'ka wehjoari mochiwachiopua. Wa'a iika Riosi Naeraa, tijoetusaapa tamochi yaajatokamepua, te'ta apoeche Riosi Taanarachitia. I'kao teemea, Eesusi ajawariaa, ma'chiame tetewamepua, Riosi tisiwarichi o'inia eenakamekopua pu'kao, ki nu'unti Riosi utewari yachatoka. Puuua i'ka weeechi oiaio, i'ka weeechi mochikameopua, tísia ahpo nakiya tetewiterepua, kihta wihtuki nayewaka, te'ta Riosi pichiwarichi simiyameche nayewasika. ");
INSERT INTO var_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Waika taawechiami Oorani akichiko oikame Waania, ti'tijoeri paatokao, pu'kachi naewaka cheekame puuuai cheekao: —Ihji Eesusipua, puuu tapanara no'o nayewaka cheeriaa no'o neipa enamio tuukao, puuua epeche weruma teerewi iinuemeko tuuriaa ki noochitiao, ihji tijoea ke'chu no'o ki'tioio, ki ehpesi o'inia yasariamepua wa'asi. ");
INSERT INTO var_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Ihji Eesusi Riosi Tijoetukamee, kiatiame teemea te'ta kaaweruma teerepuamepua Riosichio, taamoo senepi taawechi piipatesipuameopua, tatakorisiwaopua taamoo. ");
INSERT INTO var_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Pu'ka ehkoriami animari manaka kosotiamea, Moise nuurari yoorakao tatakori ahpo cheriwepuawichioo, kihta tatakori kokosarira natetekamepua. Nape Riosia tísia taamo nakiyapao, ahpo te'ta Taana mukirae nateteterepua taamo tatakori kokosapuameopua. Wa'a tiiachipa tatakori cheriwewaa, Eesusi iintoriawichioe, kianiame teemea Riosieo. ");
INSERT INTO var_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Riosio, aaataai ki tetewamepua pu'kao. Apoe Riosie Tijoe Tijoetukamechiche tetewiniamepua. Wa'a tiiachio ihji Eesusia, apoe taamo Noono Riosi wa'apikaitepua, tijoe weerewaeme enepakame. ");
INSERT INTO var_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Waaniai paatoka oiaio, ma'chiame ahpo ka'itakame puuua, ki apoeko tuuka Riosie uhjurapo tuutiameo. Wa'a cheekame Waania ahpo ka'itakao, piie taawechi i'isaeri ya'yawichieo iinatuketiao aatanakoopua ahpoo. ");
INSERT INTO var_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Waania pu'kao, ma'chiame cheeka nehjiakamepua cheekao: —Ka'i, ki Riosie Weratiame neeea, Riosi apoe uhjuramo tuuriao, Meesia tewaniameo. ");
INSERT INTO var_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Waikao uhjuratiamea, eenechi iinatukekao, chaachapakapua: —¿Aatanakamera muuua naaju? ¿Ki Eeriatarukosamua naaju, puuu eenechi ahjakame? —Ka'i, ki puuu neeea —cheeka nehjiaka Waania. —¿Ki muuukosapua naaju Eeriaa, Riosi naewatura te'ta uhjurapo tuutiame? —Ka'íí, piirechi neeea ki puuu —cheeka nehjiakapu Waania. ");
INSERT INTO var_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","—¿Aatanakosa muuua naaju? ¿Aatanakoti muuua? Taamo tuuyepuapua, wa'a taamo chaachapamichio taamo uhjurariao. ");
INSERT INTO var_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","—Neeea aaatapua, wahka siinachaniame ihkepaka, puuua wahka ooruchi cheechaniame: “Kaaweruma pooe wahjonamitia eemea, aamo iikachio, pu'ka te'ta taamo Paamirao amochi eenaka pakimichiopua, aamo iikachio.” Wa'a cheeka nehjiaka Waania, ahpo iinatukeka uhjuratiameopua. Puuu wa'a cheeka nehjiatiamea, ehkoriami o'inia, wa'a cheepo tuutiamepua Isaiaeo, Ehkoriami ahpo Iyoterichiopua. ");
INSERT INTO var_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Waikao pa'pariseroe uhjuratiamea, ");
INSERT INTO var_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","chaachapakapua Waanio: —¿Achinikai paatona muuua wa'a teeresoo, ki Riosie Weratiame enesaa, Eeriaoi ki muuu enesaa, Riosie uhjuratiameopua, aaataoi Riosi nayewaturao? ");
INSERT INTO var_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Waania waikao chaaneka nehjiakapua: —Neeea ki aaata werumakaitenia, oowera neeroie paatoame neeea. Nape amochio oiyaitepua aaatao, pu'kao ki machiyame eemea pehjio, puuua ahpo Riosiwarie paatomeri puuua, ki neeroiye. ");
INSERT INTO var_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Pu'kaonia kakajoyaraoi ki nateyamenia no'o na'sonemiao, no'oo, neipa naawakamekoipua pu'kao. ");
INSERT INTO var_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Yooma i'ka wa'atiame teerekame Wetania tewaniame mochiwachiopua, Waanio, Oorani akichi paonamina paatoka kahtioiopua. ");
INSERT INTO var_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Pu'ka meerekachio Waani Paatoria, wa'ana ihtoame tetewapa Eesusio, cheekapua: —Nee, wa'ana ihtoame puuua, Riosieo po'wachitia tetewiniamea, taamo tatakoriwichio pejana oowewapuame. Puuupua, te'ta taamo pejana mukimeria, yooma taamo tatakorieka mochikao, natetekao. ");
INSERT INTO var_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Ihji puuujupua, no'o tapanara cheeriao, no'o neipa naawakameoipua, ki nu'uti tiiari iinuemekai tuuriaa, pu'kao ke'chu no'o naaoio, ki ku'itapisi yasariameko tuuria. ");
INSERT INTO var_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Neee wa'apiai ki nane'riamekainia, aatanakoopua enemerio, nape wa'a tiiai neeea, neeroiye paatosiameainia i'isaerio, i'ka enameri eenachisio. ");
INSERT INTO var_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","’Nape ehpeonia Riosi Riosiwario kooroka tiame ahjachi tekikopao Eesusichio, ma'chiame machikamenia pu'kao, puuukoopua. ");
INSERT INTO var_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Neeeai ki nane'riamekainia aaata enamerio; nape apoe no'o uhjurakamea, neeroiye no'o paatonurekaipua ti'tijoerio, puuua no'oo, eee no'o chaanekamekaipua tiameo: “Aaata Riosi Riosiwari ahjachi tekikameo, puuu enemerikopua apoeo, Riosi Riosiwarie paatomerikoopua, ti'tijoério.” ");
INSERT INTO var_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Neeea pu'ka wa'a tiiameo tetewikapao, puuuko tuuyamenia weeechi uhjuremo tuutiameo, puuuo pu'kaonia, Apoe Riosi Taanarakotinia, Apoe weeechi tijoe tijoetukame. ");
INSERT INTO var_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Eenechi meereo wa'api wa'ao, Waania ooka ahjama weeriaiopua ahpo masitia, ");
INSERT INTO var_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","ahpo weeriachiami u'matoi Eesusio, cheekapua: —¡Nee, waami ihtona Riosi Po'wa teewataniamea, taamo pejana mukimeria! ");
INSERT INTO var_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Waikao masiteraa, na'pa Waani ahjama ajakamea, wa'a chiiame inamukapaopua ahpo masitari Waanio, na'pahka na'naritokapua Eesusio, wa'amio. ");
INSERT INTO var_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Eesusi ahpo pukamina nokisiopao, ku'rika ne'nepakao, iinatukekapua: —¿Ihtana erakotona eemea noochio? Waikao aapoeo chaachapakapua: —Masitari, ¿akana checherepame muuua? ");
INSERT INTO var_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Waikao Eesusia chaanekapua pu'kao: —¿Nane'renare eemea? Nahpeo naaju, nane'retai no'o checherepachio. Ahjama siimpakapua waikao checherepachio. Nape tísia aarikopa wa'asio, wa'a che'repatiapua waikao Eesusi checherepachi. ");
INSERT INTO var_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Piiripi puuu ooka Eesusi na'naritokamea, Anteresikapua, Siimoni Peeroo poonira, Waanio puuua chiiame inamukame, Riosi Po'wa teewataniameko tuuyame Eesusio. ");
INSERT INTO var_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Wa'a che'repasaopua pu'ka meereo, ke'chu ihta yooraiopua pehjio, ahpo pa'chi Siimoni Peero i'yamia akipakapua. Waikao Siimoni tewisaapua, chaanekapua: —Tewakame teemea Riosie Weratiameo, puuu Riosi uhjuramo tuuriaa, puuua Apoe Meesia. ");
INSERT INTO var_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Wa'a chaanesaapua, Eesusi kahtiachi upatiapua. Eesusia Siimonio, ahpo kahtiachi upatiame tetewapao: —Kúíraa —cheeka teepotesaapapua, chaanekapua— Siimoni teewaeme muuua te'ta teewarao, Waani taanara, nape neeea Seeja aamo tewamania. Ihji Seeja chaniwamea, Peero chaniwamepua rieko naewaniachio. ");
INSERT INTO var_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Eenechi meereo Eesusia, Arirea weeechiami oinarepakapua. Wa'ami nokisinioi pooechio, Eeripe natepatiapua. Wa'a tetewikapa Eeripeo, chaanekapua: —Nahpe no'o ahjama, no'o ahjama oitai. ");
INSERT INTO var_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Ihji Eeripea, We'saira mochiwachi ohjoeme eneriapua, Anteresi ohjoekachiopua Peero tiame. ");
INSERT INTO var_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Waikao Eeripea Natanaéri i'yamia simikapua. Natanaéri tewisaapua, chaanekapua: —Eesusi Nasare ohjoeme natepaka teemea Oose taanara. I'ka Eesusi nayewaka cheeriai Moiseai ahpo Iyoterichio, aaata naewakaoopua, ehkoriami Riosi nayewaturaa, wa'achi chaachapakamepua tiameo ahpo iyoterichio. ");
INSERT INTO var_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Natanaéria wa'a tiiame tuuyetiaapua, cheeka nehjiakapua: —¡Aa Nasare? ¡Naakonakosa puuua? ¡Aaata kaaweruma machenamii teeerepua wa'a? Eeripea chaanekapua: —Nahpeo naajuo, amoe wa'api tetewitai. ");
INSERT INTO var_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Waikao Eesusia, ahpo kahtiachiana tetewapa ihtoame Natanaério, chaanekapua pu'kao: —Néé, wa'ana ihtona isaeri tijoe, tísia kaaweruma, kihta a'chi tiiame wihtuniameo. ");
INSERT INTO var_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Wa'a chaanetiao Natanaéria, chaanekapua Eesusio: —¿Achini ihsika no'o machikamemua? Eesusia chaanekapua waikao: —Neeea ke'chu Eeripe aamo noochi enanurioio, chuunatere kahtiame aamo tetewikame neeea. ");
INSERT INTO var_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Natanaéria, chaanekapua waikao: —¡Aa muuua, Apoe Paamirakaitemua wa'a teesoo, Apoe Riosi Tijoetukame! ¡Muuúa, isaeri yawichiwaramua, te'ta enameriko tuutiamera! ");
INSERT INTO var_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Eesusia wa'a chaanetiapao, cheekapua: —¿Muuua chuunatere aamo tetewario tuuriamekopa, wa'a e'ramemua noochio? Muuua no'o ahjama oiyame enesaa, epeche tiiame tetewimamua, no'oo aamo tetewitemia. ");
INSERT INTO var_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Wa'a cheesaapa Eesusia, yooma ahpo paajuteriao, chaanekapua: —Pichiwa chiiamenia i'kao, eemea tewekachio, wahjokame tetewimiitepua, Riosi tewekachi ku'kuiwario, no'o Riosi Tijoetukamechi tetekisika, eenechi tewekachi mooenapame. ");
INSERT INTO var_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Paika taawechi simiyachi Kaanani tewaniachio, nenewiwa enekapua wa'ao, ookapi mochiwachi Arirea ye'karirachi. Wa'a ihsiapu tiame, Eesusi yeeyeraai. ");
INSERT INTO var_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Eesusia ahpo masitera ahjama, paajuteretiapua tiame wa'a nenewiwachi. ");
INSERT INTO var_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Eesusi yeeyeraa, wahjipasoopa wiinoo, ehpeche nakiniamekoopa wiinoo nenewiwachio, chaanekapua Eesusio: —Sooparetupa wiinoapa. ");
INSERT INTO var_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Eesusia nehjiakapua waikao: —Ye'ye, ¿ihtana no'o iintojeraka chiiamemua wa'a cheekao? ¿Eenechi iintujeraka chiiamemua wiinoo? Ki asiyame neeea pehjio, wa'a iintomiachio. ");
INSERT INTO var_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Ihji yeeyeraa wa'a chiioio, chaanekapua wa'a nokayameo naachutakao: —Eemea oowera e'wemitiachepua pu'kao chiiao. ");
INSERT INTO var_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Wa'a ajariapua tiame puhsani sikori, tehte netetiame. Puuua neeroi ahjachi toaniame piipaniamewichio eneriapua, isaeri ti'tijoerio. Pipiripi puuu sikoria, piire siento ritiro ahka uuyame eneriapua. ");
INSERT INTO var_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Nape wa'a cheekai Eesusia, chaanekapua pu'ka naachutameo: —Neeroiye pochiwamitia naaju pu'ka weeweruma tehte sikorio, eeme naachutamea. Waikaopu puuu naachutamea pochiwakapua pu'ka sikorio, póóchikame. ");
INSERT INTO var_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Wa'a noonowisoopua pu'kao, Eesusia chaanekapua pu'kao: —Ehpeo ku'wita itusao, pahko paamiratuame i'yetomitiapua. Waikao wa'a ikiretupua. ");
INSERT INTO var_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Waikao puuu pahko paamiratuamea, ki nane'rekaopua achini teereriopua wiinoo, naachutameche nane'reriameopua, yenasaopua pu'kao, chaanekapua pu'ka wa'a neewiameo: ");
INSERT INTO var_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","—Ahkaoi pahcha naachutaniame wiino epeche ta'yameraa, neipa tehpe iijinioi nanachutaniame wiino ki te'ta ta'yameraa, nape muuua, neipawichio katewekamemua pu'kao. ");
INSERT INTO var_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Wa'asa iintoka Eesusia Kaanani tewaniachio, Arirea weeechiopua. Puuu ki maaenaria pukeri pahcha simiyame iintoriamekapua, puuu iintoriaa ahpo aatanako ne'netiamekapua. Pukachipa masiteraa, epeche pichiwa tewekachi o'inia eenameko, erapakapua waikao. ");
INSERT INTO var_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Neipao, nenewiwa u'matosoopa wa'asi Eesusia, Kapenaumi siimpatiapua waikao, Eesusi yeeyera ahjama, poponira tiame; wa'ao, ookapi taawe mochitiapua. ");
INSERT INTO var_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Amori asiyachi Semejenato pahkoopa, Eesusia taamo ahjamao, Eerusarenite mo'moenatiapua. ");
INSERT INTO var_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Eerusareniopa tiopachio Eesusia, wa'a tiopachio ki ookapi tewakapao weeka itapiti nehjameo, oisi, po'wa, kooro, wa'a ikisa toomi naakuriwame tiaméo ti'tijoe. ");
INSERT INTO var_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Waikao Eesusia wepijoera netesapaopua, yooma weweka puuyanakapua, wa'a mochikameo nehjakaopua, pu'ka puhkura oisio po'waopua tiamé, yooma ma'chi uhjurakapua pu'kao, wi'wiyaka. Pu'ka wa'a toomi naakuriameo, yooma ru'minekapua meesao, toomiopua tiameo yooma wi'sunekapua wehchio, chi'rineka. ");
INSERT INTO var_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Pu'ka kooro nehjame naaepakao, chaanekapua: —¡Yooma puuyanamitia i'ka i'wao! ¡Ka'te weruma itapiti nehjiwachi iintamitia eemea, no'o Noono kariwarachio! ");
INSERT INTO var_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Waikao masiteraa, inatepare puuuapu pu'ka Ehkoriami Iyoterio, chiia: “No'nóo, ki tisiwa nu'nuti wa'inaka tetewamenia kahtine, kariwao.” ");
INSERT INTO var_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Isaeri ya'yawichia, chaanekapua nekakoka: —¿Aatana puuua, aamo wa'a ihsitiamea? Yorasao naaju, ihtaoi itapiti Riosichi eename, taamoo aamo tetewimichioo, pichiwa Riosichi eenamekoo. ");
INSERT INTO var_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Eesusia nehjiakapua pu'kao: —Ru'misoo i'ka tiopao, neeea, paika taawechi weramania eenechio. ");
INSERT INTO var_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Waikao Isaeri ti'tijoea chaachapakapua pu'kao: —Ooka weerewa aampa puhsani paamupari ariwatiameoi i'ka tiopa weerakao, ¿muuua, paika taawechi wa'apiche werataremua eenechio? ");
INSERT INTO var_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Nape Eesusia, tiopa naewakao, ahpo wa'api weerewa naewaka cheeriapua. ");
INSERT INTO var_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Waikao teeme Eesusi masiteraa, inatepakapua ke'chu oijenaio wa'a cheeriaopua Eesusia; waikao teemea, pichiwapu puuu Ehkoriami Iyoteri chiiaa, erapakapua; waikaopua tiameo, pichikeka teemea, Eesusi taamo masiteriao. ");
INSERT INTO var_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Eerusareniopa, Semejenato pahkochi Eesusio, muuwaeme pichikerepu pu'kao aatanako, apoe ki ookapi ki maaenari yooramekopua, itapiti. ");
INSERT INTO var_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Nape Eesusia, ki pichiwako erapakapua pu'ka chiiao, machiyapa aachin erakoamekopua pu'kao. ");
INSERT INTO var_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Puuua ki tuuyeniai nane'riamepua aatanakamera apochi paparamekopua, machiyamekapapua ihtana inatamekopua ahpo iikachio. ");
INSERT INTO var_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Wa'ao yasariaipua tiame piiripi tijoe, Nikoremo tewaniame, parisero tijoe enepakame. ");
INSERT INTO var_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Ihjia, tukao eenakaopua Eesusi kahtiachio, chaanerepu: —Masitari, nane'rena teemea, taamo masitemichio uhjuratiameko, Riosieo. Ki'tepu aaataaio, aamo yooraria yooramea, ki ahjachi yasisoo Riosio. ");
INSERT INTO var_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Waikao chaanerepu Eesusia: —Ki waapisi noochi eename e'raka, aamo chaanenania i'kao, pichiwa kiisi sewina tiame ihjia, ki eenechi naawakamea, ka'chitia muimapua Riosi ye'karichio. ");
INSERT INTO var_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nikoremoa iinatukerepu waikao: —Nape, ¿achini iika tijoetuta teeme eenechi, oochetiameapa? ¿Achini iika ahpo yeeyechi pakika, tijoetuta teeme eenechi? ");
INSERT INTO var_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Eesusia nehjiarepu pu'kao: —Kiisi sewina tiiamepua pu'kao. Ki oowitiame yeeyechi tijoetukao, Riosi Riosiwarichi tijoetukamea, ka'chi iika machimapua Riosi ye'kariwao. ");
INSERT INTO var_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Tijoechi tijoetuyamea, tijoepua; Riosi Riosiwarichi tijoetuyamea, Riosi Riosiwarichi ihchiamepua, ahpo naawariao. ");
INSERT INTO var_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Ka'te ka'chitiachitia tetewa muuua i'ka no'o chiiao: “Weemera tijoetumerimua, eenechi.” ");
INSERT INTO var_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Eekaka tiiame puuua, ahka kahtioio ki teteiwame; ahkaminaoi simiyoi ekayo, ki tetewamemua pu'kao, nape ki tetewaiopua eekao, amochi saayamepua ekayoo. Wa'achi teeka saaeniamepua tamochio, Riosio taamo eenechi naawatekame enesoopua, ahpo Riosiwarieopua. ");
INSERT INTO var_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nikoremoa, chaaneriapua eenechi: —Kiisi pahtenania pu'kao. ");
INSERT INTO var_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Eesusia chaanerepu waikao: —Nee, muuua isaeri masitarikai, ¿ki pahtiamemua? ");
INSERT INTO var_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Kiisi se'wi no'o chiiaa, pichiwarichi simiyamea. Neeea no'o Noono tewekachi ahjamao, teemea aamo i'ka weeechi mochikameo, tewekachi simiyame itapiti chaachapamepua, nane'riamekapa teemea, te'ta pichiwarichikamera simiyamekopua pu'kao. Nape eemea, kiisi pichikenariamepua pu'kao, taamo chiiao. ");
INSERT INTO var_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Ki no'o pichikiame enesaamua, i'ka weeechi iintuame aamo nayewiao, ¿achini iika pichiketa muuua, te'ta tewekachi iintuame aamo no'o nayewiao? ");
INSERT INTO var_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","’Aaataai te'ta tewekachio ki mooenamepua, naatiche puuua, te'ta tewekachi o'inia eenakameche, te'ta tewekachi Riosichi teereka yasitoameche, ehpe taawechiamio puuua, weeechi tekika tijoe tijoetukame. ");
INSERT INTO var_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Yepowechio, wa'achitia Moise apechunarichitia siinowe tetewipuawichioo, wa'achitia apechunaniame tetewipuame neeeai Tijoe Tijoetukamea. Waikao yooma noochi paparakamea, saupukame itipimapua ahpo tatakoririao. ");
INSERT INTO var_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Wa'a iikoopua, yooma puuu noochi paparakamea, ki wahjiamesi ahjari te'teremeri puuua, ki wahjipaka oosa simiyame wahjiparichiopua. ");
INSERT INTO var_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","’No'o Noono Riosia tísia nakikamepua weeechi mochikameo, ahkasi ahpo piiripikoi ahpo Taanao, pu'kawichio nehjakamepua, aaataoi weeechi mochikame ahpo Taanachi paparakameo, ki kokosari saaemichiopua no'o Noonoeo, ohso kaawe ki wahjiame ahjarikamera kiapuawichiopua. ");
INSERT INTO var_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Riosia ahpo Taanao, ki aaata ti'tijoeri kokosamichio uhjuratiamepua i'wa wehjoarichio, ohso kaawe puuua, ti'tijoe ooweru tiame newipatemichiokamera, uhjuratiamepua. ");
INSERT INTO var_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","’Riosi Taanarachi pichikeka paparakamea, ki aiwatepuamepua Riosi kokosario; nape ki ahpo Taanachi paparakameo Riosia, ahpo kokosari aiwapuachi teerepakamepua wa'asi, ki Riosi te'ta piiripi Taanarachi paparakopa. ");
INSERT INTO var_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Pukachipa aiwamerapua Riosieo, na'arachikamera mochinarekapapua tukapachi, ki e'enanariapapua, Riosi Taanara tajayachio. ");
INSERT INTO var_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Yooma ki kaaweruma nokaka mochikamea, ki uunariamepua Riosi te'ta kaaweruma chiiaa, uutaparichi enepaniameopua, ki ahpo ma'chitapuaichio ahpo ki kaaweruma nokayao. ");
INSERT INTO var_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Nape ka'karuma nokiwame nokaka mochitonariamea, Riosi tahjewa kaaweruma uutaparichi eenepamepua, ahpo Riosichi kaawe nokayao, ma'chiame tetewipuawichiopua. ");
INSERT INTO var_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Neipa i'kaopua Eesusia, Uurea weewachi simikapua taamo ahjamaopua masiteramao, wa'ami nokisinioio paatosikapua, ti'tijoe ooweru tiame. ");
INSERT INTO var_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Waania waikamio, Eenoni tewaniachi pa'paichi ihsirepua paatokaopua tiame, Saarimi tewaniachi waapio, weeru maaniopa neeroio. ");
INSERT INTO var_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Yooma ihji wa'a tiame simikapua, ke'chu Waani pachanioiopua karichio. ");
INSERT INTO var_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Piie taaweo, Waani na'naritoamea ookapi, piiripi isaeri tijoe ahjama chaachapakapua, tatakori piipaniamechi simiyame. ");
INSERT INTO var_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Waikao wa'a chaachapasaopua, Waani na'naritoamea, Waani kahtiachi e'enakapua tuuyemia, pu'kao chaanekapua: —Masitari, puuu waami yasakameopua taamo ahjamaopua Oorani akichi cherayachiminao, pu'kaopua epeche werumako tuuriaopua amochio, paatoatapua ehpeo, muuwaemea, yooma wa'a enapatapua ahpo paatotemiao. ");
INSERT INTO var_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Waikao Waania chaanerepua ahpo masiterao: —Pe'yachipua, aawataai kihta yoratarepua, ki Riosie kiatiame enesaapua ahpo ihsimiao. ");
INSERT INTO var_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Eeme wa'api inamukamepua no'o cheerioio, ki Riosie Weratiameko tuurio no'oo, aaata Riosie uhjurapo tuutiameo, neeea no'oo, pahcha uhjuratiameko tuurioo, ke'chu pu'ka eenoiopua. ");
INSERT INTO var_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Nenewiwachio, moniawá ahjama neewimeria, mo'nera enemeripua. Mo'nera kaawe e'ria, neee puuua, kaawe e'raka yorakiamerapua ihtaoi ahpo yorajekeraopua. Wa'a tiiachipa neeeai ki nu'uti kaawe e'raka tetewaninia pu'kao. ");
INSERT INTO var_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Ehpeo puuukamera, epeche weruma enetoaopua, no'oo epeche nu'uti enetoiopua, pu'ka apoeo te'ta tewekachi eenamekopapua, no'oo weeechiche tijoe naawakamekopa. ");
INSERT INTO var_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","’Apoe te'ta tewekachi eenameopua, yomarika aampa tiiamepua. Teemea, weeechi ohjoemea, weeechiche simiyameche nayewamepua. Nape tewekachi ohjoemea, tewekachi tiiame nayewamepua, yomachi aampa tiiame itapitichio, ti'tijoechiopua tiame, ");
INSERT INTO var_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","ahpo te'ta tetewaria nayewamepua, te'ta ahpo Noono ahpo nayeweria inamuria tiame; nape wa'atioi pu'kao, ookapipupua, pu'ka chiiao uuyamea. ");
INSERT INTO var_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Nape pu'ka chiiao uukamea, pichiwa chiiame nane'rekamepua pu'kao, pu'ka chiiao, te'ta tewekachi eenamekopua, te'ta tewekachi Noonora o'inia eename. ");
INSERT INTO var_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Puuu Taanaraa naawesaa, ahpo Noono chiia chu'warachitia naewamepua, yooma apoe Noonora tiiaa, ahpo Taanachi yasitoamekapa, ahpo Riosiwari. ");
INSERT INTO var_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Noonoraa, ki teesa nakiyamekapapua ahpo Taanao, ki nu'unti utewari ki'yarepua pu'kao, yomachi aampa tiiame ihtao. ");
INSERT INTO var_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Pukaepa pukachi paparakamea, tewayamepua pukachio, ki wahjiamesi ahjaniame, nape ki pukachi paparakamea, kiisi tewayamepua pukachio, ki wahjiame ahjaniameo, ohsotia puuua, Riosi kokosario, apochi petereka mochitoamepua. ");
INSERT INTO var_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Waika taawechiamio pa'parisero ti'tijoea, Eesusio epeche muuwaeme paatoame inamurepua ki Waanichitiao, ");
INSERT INTO var_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","ki apoe Eesusi paatoamerakamekoipua, teemekamera paatoiopua masiterara. ");
INSERT INTO var_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Pukaepa Eesusia machenakapua wa'a Uurea weeechio, Arirea no'rakapua taamo ahjamao. ");
INSERT INTO var_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Saamaria weeechiami u'matosaapa, ");
INSERT INTO var_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","wa'atumi nokisikaopua, Siikari tewaniachi ajasitiapua, ma'chi ke'chu muiwachi. Wa'a ke'chu asiwachio, ehkoriami Aakowo weewarachi eneriapua, Oose ki'yariachi weeeopua ahpo taana, wa'ao, neropaira neteriachi tekoritaka. ");
INSERT INTO var_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Wa'ao, resipakamekapa Eesusia, paira tekoritatiachi yasipakapua resipumiao, oowetawe wa'asi. ");
INSERT INTO var_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Waikao teeme Eesusi ajawariaa, piineri toisa Eesusio, Siikari mochiwachi siimpatiapua kooame tarimia. ");
INSERT INTO var_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Wa'a piineri itipirioi Eesusio, wa'a eenaria aaata oowitiame, neeroi paimia. Eesusia pu'kao chaaneriapua: —No'o kiamitia ku'ita neeroi. Paramuna neee. ");
INSERT INTO var_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Nape Saamaria oowitiamea, chaaneriapua Eesusio: —¿Achini iikame muuua naaju, muuua isaeri tijoekai no'o itanenamua neeroio, no'oo Saamaria ohjoemekooi? ");
INSERT INTO var_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Eesusia nehjiariapua pu'kao: —Muuua nane'riame enesaamua no'oo aatanako, ahka eenameoio, nane'riame enesaamua tiameo, Riosio aamo ihta kianareka kahtiamekoo, muuukamera no'o itanemiipua neeroio, nape neeroi ki wahjiame ahjaniame. ");
INSERT INTO var_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Puuu oowitiamea chaaneriapua waikao: —Nape Paamira, muuua ki iinuemepua aamo ahjae ma'chipapuameoipua neeroio, itapiti wiitarioiopua, kai waapisi teere maaniameopua neeroi ma'chipapuameopua ahjaeo. ¿Akana uuka no'o kiatamua pu'ka neeroi ki wahjiamesi ahjaniameo? ");
INSERT INTO var_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Ki ehpesi nerojiniachi ihji neeroia, taamo ehkoriami Aakowoo, taamo tooweriachisiopua i'ka tekoritiachi pairao. I'wa nerojikamepua Aakowoai apoe, wa'api tatanaraa tiame, yooma puhkura ahjama wakasi. Ki ehpesioi, ki teiwachi i'wao, neeroi ki wahjiame ahjaniameopua, aaataeoi. ¿Epechekosa iintotaremua naaju, ki te'ta taamo ehkoriami Aakowo weruma tiiamechitia? ");
INSERT INTO var_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Eesusia nehjiariapua waikao: —Aamo pairachi ma'chipaka nerojiniamea, yooma paramumeripua eenechi, ");
INSERT INTO var_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","nape no'o aamo ki'ya nerojitemiaa, ki oosa aampa paramumerimua. Ihji neeroia aamo no'o nerojitiaa, amochi wa'api pajenameka teeremeri puuua, ahkasi ki wahjiamesi, aamo ki wahjiame ahjateka. ");
INSERT INTO var_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Puuu oowitiamea wa'a chiiopa Eesusio, chaaneriapua: —Paamira, wa'a teeresoo no'o kiamitia naaju muuua, pu'ka neeroi ki wahjiamesi ahjaniame, ki oosa paramumichiopua no'oo, ki oosa no'o enamichiopua i'wa neeroi paimiao. ");
INSERT INTO var_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Eesusia waikao chaaneriapua pu'kao: —Kaawepua, nape paaemitia naaju aamo kuunaoi, wa'a ikisaomua, noochi e'enamitiapua na'pahka. ");
INSERT INTO var_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Nape oowitiamea nehjiariapua: —Ki kuunaemekoi neeea. Eesusia chaaneriapua waikao: —Pichiwa chaanimua, ki kuunaeko tuukao. ");
INSERT INTO var_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Mariki tijoe ahjama ohjoekame muuuapa, ihji ehpe aamo ahjama kahtiaoi, ki aamo kuunakopa. Wa'a tiiachipao aamo chiia, pichiwapua. ");
INSERT INTO var_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","I'ka inamukapa oowitiamea, chaaneriapua: —Naatiko erapaninia aamoo, Riosie ne'neteniame. ");
INSERT INTO var_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Taamo ehkoriami Saamaria ohjoekamea i'wa wa'api paparaweriaipua Riosio, i'ka wa'api kaawieka tiiachi, nape eeme i'isaeri ti'tijoeria, Eerusareni siimpapo tuunapua Riosichi paparamiao. ");
INSERT INTO var_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Eesusia chaaneriamepua: —Pichikemitiamua i'kao, akanache Riosichi paparaniamea, ki nateyamepua Riosiwichioo, Riosichi paparaniameo ahkakoikopua. Enamitepua meere ahka taaweopua, aamoo, ki i'wa kaawichiche aamo Riosichi paparamericheopua, Eerusarenioicheo. ");
INSERT INTO var_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Eemea, ki machiyamepua aamo te'ta paparawiao. Teeme i'isaerikamera nane'riamepua aatanakamera paparawiao, Apoe te'ta aamo Newipatiameo, wa'akamera machenakamekopua te'ta taamo i'isaeri tetejimarichi. ");
INSERT INTO var_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Nape asikamepua wa'asi, ki wihtuka te'ta paparapuameopua ahpo iikachio, ahpo Noonoopua tewekachi kahtiameo, wa'a teeka paparajeriamekopua apochio. ");
INSERT INTO var_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Riosia, ki pusie tetewiniamekopao, iikachi eraniamee paparaniamepua, pukachio. ");
INSERT INTO var_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Waikao oowitiamea chaaneriapua: —Wa'a teeremerijoarepua tiiao, nape teemea, pu'ka enameriche puuyamepua, Riosie Uutiame, apoeo enasaapua, ma'chiame taamo chanimichiopua aachin teeremiao, yooma itapitichi simiyameo. ");
INSERT INTO var_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","—Neeekaite puuua —chaaneria Eesusia—. Pu'ka ahjama nayewaka weeriaitemua —chaaneriapua. ");
INSERT INTO var_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Wa'a chiioio Eesusio, teeme masitewaraa e'enatiapua itipiriachio. Masiteraa, a'chi erapakaipua, pu'ka oowitiame ahjama nayewaniameo, kihta iinatukeka teemea, pu'ka ahjama nayewao. ");
INSERT INTO var_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Waikao, puuu oowitiamea, ahpo pairiachi toisapaopua ahpo sikorio, wa'atia u'masikapua mochiwachio. Wa'aopua yooma, paaekaopua chaaneriapua: ");
INSERT INTO var_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","—U'masio pahchu. E'enasao, ne'nemia i'ka tijoe, yooma no'o yoorariao, tuuria. ¿Ki Riosie Weratiame ohjoarepu? ");
INSERT INTO var_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Waikaopua, puuyaka mochiwachio, e'enariapua Eesusi kahtiachi. ");
INSERT INTO var_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Ke'chu asikoi pu'kao, teeme masitewaraa, ko'konurekai teemea Eesusio. ");
INSERT INTO var_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Nape Eesusia taamo chaanekapua: —Ko'kakame neeeapa. ");
INSERT INTO var_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Teemea waikao taamo chaachapakapua: —¿U'yeparetiarepua naaju, ko'kopuameo? ");
INSERT INTO var_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Eesusia wa'a taamo chaachapopao, taamo chaanekapua: —Neeea itapiti kooame ko'kakamepua, aamoo, ki machiya pehji. No'o koayaa naatipua tiameo, No'nowichio tehki, kajumichio uhjuratiame. ");
INSERT INTO var_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Eemea chaachapaniarepu, naao meecha toinapa i'ipapuachio, nape neeea aamo chaanenapua, i'ipapuamea asikame puuuapa. Pukaepa neeea aamo chaaniamepua, i'ipapuameo, ti'tijoeri Riosichi e'enapupuame naewaka chiiamepua. ");
INSERT INTO var_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","I'ipaniachi tekipanakamea yowimeripua; pu'ka Riosiwichio i'ipamechitia tekipaname yowiraa, Riosichi upapania weemera ahjari uumichio peenia eraniamepua; pu'ka weemera ahjari uupuawichio echakamea, i'ipakame ahjama kaawe erakoamepua, puuu yowiraa, ahpo kaawe erakowarapua. ");
INSERT INTO var_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Wa'a tiiachipao, ki ahpo echariachi i'ipaniapua. ");
INSERT INTO var_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Wa'a aamo uhjurakame neeea, ki aamo echariachi i'ipamichioo, Riosi tehkirachio, wahjachi ohjoriachi pahchaopua tiameo, eemeai ehpeo i'ipamea, ku'ipanipua tiameo wahja ohjoriachiopua, tehkiwachio. ");
INSERT INTO var_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Pu'ka oowitiameo cheeriopao: “Yooma no'o tuuyekapua no'o ihsiriao”, Siikari ohjoemea waikao, ki ookapi ahjachi erakokapua Eesusichio. ");
INSERT INTO var_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Siikari ohjoemea, wa'a iikapao, ajasisaapa Eesusi kahtiachio, itipinurekapua ahpo mochiwachi che'repamichioo. Waikao Eesusia teeme tiame, wa'a itipitiapua ooka taawe. ");
INSERT INTO var_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Waikao wa'a itipitioio epeche weeka Eesusichi paparakapua pehjio, aapoe inamukapapua Eesusio, apoe wa'api chiia. ");
INSERT INTO var_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Puuu Saamaria weemera paparakamea, chaanekapua waikao pu'ka oowitiame: —Ki aamo cheeriowichioche pichikena teemea ehpeo, tamoe inamukapa tiame, te'ta pichikena teemea, pu'ka chiiao. Nane'rena teemea ehpeo, i'ka tijoeo, pichiwa te'ta Riosie Weratiamekopua, yooma wehjoarichi mochikameo newipatemia eenakamekopua. ");
INSERT INTO var_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Eesusia pu'ka ooka taawe i'toai Saamariao, taamo ahjama u'matokapua Arireami. ");
INSERT INTO var_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Eesusia ki Uurea weeechiche itipinarekapua tekipanakao, Apoe wa'apio cheekapa: “Riosi naewatoamea ki peenia e'raka uuniamepua ahpo wa'api weewachiopua, te'ta ahpo machiwachiopua.” ");
INSERT INTO var_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Arirea weeechi asiyachiamio, kaawe e'raka tetewiretupu wa'ao, wa'achi nonorakamekapapua tiame, Eerusareni pahkochi, tetewakamekapapua tiameo, itapiti yooriaopua wa'ao. ");
INSERT INTO var_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Wa'a o'iniao Eesusia, Kaanani e'enatiapua eenechi, pukeri simiyachio ahpo machenariachi, Arirea weeechi, neeroio ahpo wiino iintapariachi. Wa'a Kapenau yasariaipu piiripi tijoe yawichi seekaerewa, ahpo taana kokoriame iinueme. ");
INSERT INTO var_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Waikao ihji tijoea, inamukapao Arirea eenario tuuopa Eesusio, Eesusi kahtiachi eenakapua i'tomia. Wa'a enasaapua, utewa yoorakapua Eesusio, ahpo ta'pechi enamichiopua, ahpo taanao tísia kokorio tuukaopua, amori mukuyo tuuka wa'asi. ");
INSERT INTO var_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Eesusia pu'kao chaanekapua: —Eeme ti'tijoeri i'wa ohjoemea, ki noochi paparanariamepua, ki tetewaa pehjio no'o peenia ihsiwaopua Riosieo. ");
INSERT INTO var_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Nape yawichi seekaerewa tijoea simitekapua naaracheka utewa chaanekao Eesusio: —Nape Paamira, no'o cheriwepuapua wa'atioi, nape yaapiti, amori mukuyamekapu no'o taanaa. ");
INSERT INTO var_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Waikao Eesusia chaanekapua: —Aamo taana ahjanipua pehjio, saukame kahtipua wa'asio, kaaweruma. Simika ne'nemitiao. Waikao yawichi seekarewaa, Eesusi chiia paparakapaopua, kaawe eratoka no'rakapua. ");
INSERT INTO var_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","I'ka no'roiopua pooechio, ihji tijoe nuurewaraa amori ta'pechi asioi natepakao, chaaneriapua: —¡Ahjame aamo taanaa, yachapakame kahtiame puuuapa! ");
INSERT INTO var_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Waikao apoeo iinatukeriapua, achini keenako o'ineriopua yachapakao, ahpo taanao. Puuu ku'kuyamea nehjiariapua: —Tapana taaa kayeoi, toakapua che'eria —chaachaparepua. ");
INSERT INTO var_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","I'ka noonoraa waikao, inatepariapua Eesusio, achini keenako yachapakame kahtio tuurioopua, pu'ka kokoriameo ahjakame kahtio tuuriopua. Wa'a iikapapu kokoriame noonoraa, tísia Eesusichi paparakapua. I'ka noonorao ta'pechi asisoopua, yooma pu'ka ta'perachi mochikamea tiame, Eesusichi papararepua. ");
INSERT INTO var_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Ihji Eesusi ki maaepori iintoriaa, oosa simiyachi iintoniamekapua, Uurea o'inia enasapaopua, Arireao. ");
INSERT INTO var_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Pu'ka neipachiami Eesusia, Eerusarenite mooenatiapua isaeri ti'tijoeri pahkotachi siimpaka. ");
INSERT INTO var_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Eerusarenio, waapi Po'wa Yeeta tewaniachiopua, wa'a tootoaretiaipua neeroi tekopatetiachio, eureo nayewaniachiopua We'seta tewaniachi. Wa'a neeroi maniteniachio, mariki arakokari ajarepua wa'a norikameo, neerochi pakiniachio. ");
INSERT INTO var_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Wa'ao, ki ookapi mochikame tetewitiapua kokoriame, puuua: ki mamachiriame, rojomi, chookopakame, tu'ikame, petika puuyamekapua wa'ao, neeroi maaniame noonoachisi. ");
INSERT INTO var_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Ti'tijoeria aaata Riosi tewekachi ku'iwari, eepi wa'a eejenaka noonotiame maayame enerepua neeroio, pahcha pakikamea pu'ka neeroi noonosocheo, saukame machenaniamekopua ahpo kokoriao. ");
INSERT INTO var_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Piiripi puuu kokoriame wa'a po'yamea, piire weerewa oosa mariki aampa osanao paamuame eneriaipua kokorekao, uwanapakame. ");
INSERT INTO var_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Eesusia wa'a po'yame tetewaopua ki ku'itapisi kokorerioopua pu'kao tiame, iinatukekapua: —¿Yachapanariame muuuai naaju? ");
INSERT INTO var_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Kokoriamea yaapiti nehjiakapua Eesusio: —Eje'e, nape ki'tiapu no'o neerochi pachamerio, neeroi noonosoopua. Senepi no'o pakimio o'roio, piirechi paapakiapu pahchao, i'wa neerochio. ");
INSERT INTO var_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Eesusia chaanekapua waikao: —¡Werisisao naajuo! ¡Apechunasa pu'ka aamo ipetao! ¡I'toka no'rasa naajuu! ");
INSERT INTO var_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Pu'ka cheesochepa Eesusio saukame itipikapua tijoea. Waikao sautetiamea ahpo e'tapara apechunasaopua, mookeka no'rakapua. Nape resipuniachi taawechikopa pu'ka taawechio, ");
INSERT INTO var_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","yoorewa inatewa i'isaeria, chaachapariapua sautetiameo: —Resipuniachi taawechikoi ehpeo; ¿achinikai mooketonamua aamo ipetao, ki reesiseniachikoi itapiti tehki yoraniameo? ");
INSERT INTO var_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Waikao sautetiamea chaaneriapua i'isaeri yoorewa inatiameo: —No'o yachapatekamea, no'o e'taparawa apechunaka mookeka no'ranurekapua. ");
INSERT INTO var_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Waikao yoorewa inatiamea i'isaeri iinatukeriapua sautetiameo: —¿Aatanapu puuua, aamo e'tapara mookeka no'ranurekamea? ");
INSERT INTO var_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Nape puuu tijoe sautetiamea, ka'chi iika nehjiame e'rarepua pu'kao, ki nane'riapa puuua, aatana ihsiriopua ahpo sautekao, pu'ka Eesusio ki naania ikiriamekopua muuwaeme ohjoachio. ");
INSERT INTO var_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Ehjepamio Eesusia, eenechi tiopachi natepasaopua sauteriao, chaanekapua: —¡Nee, saukame muuuapa! Ehpeo ka'te oosa aampa tatakorimitia, ki eenechi ki kaaweruma aamo ikimichiopua, epeche tiiameopua. ");
INSERT INTO var_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Waikao saukame tijoea ahpo iinatukekamechi iyoriwa inatiamechio, aatana ihsirio tuuka ahpo sautekao, Eesusiko tuuyere pu'kao ahpo sautekameo. ");
INSERT INTO var_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Pukaepa isaeri ya'yawichia, Eesusi i'yasirepua aachin teeka ahpo na'ara yoramiao, ki iyorioopapua pu'kao, resipuniame taawechio. ");
INSERT INTO var_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Eesusia, wa'a tiiachipa piie resipuniame taawechio, i'isaeri pa'pamiratuamee wa'a wa'ineniaipua aaata sautemichioo, chaanekapua pu'kao: —No'o tewekachi Noonoa, a'chitia keenakooi tekipanamepua, pu'ka ihsia ihsiame neeea, pu'ka tehkiwara yooraka. Yooma no'o ihsiaa itapitio, apoe Noono ihsiamepua no'oeo. ");
INSERT INTO var_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Pukaepa i'isaeri ya'yawichia, epeche nekamuchekapua Eesusio merinareka, ki resipuniame taawechiche tekeka tetewamekopua Eesusio ki iyorika. Ihji i'isaeria nenekarepua Eesusio tiameo, ahpo Noonoko tuuyopa Riosio, Riosichitia ahpo uuyamekopapua. ");
INSERT INTO var_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Waikao Eesusia, ehpeche epeche kaawe ahpo tuuwikaopua, chaanekapua: —Pichiwa chaani neeea Riosi Taanaraa, ki nooe e'rachi yooramekopua ihtaoi. No'o Noono ihsia, yorasiame neeeai. ");
INSERT INTO var_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Riosia, nakiyamepua no'oo, ahpo Taanao. Pukaepa apoe wa'api tetewitenapua yooma ihta no'o yoranariao. Pukaepa ahpo Taanachi ihkepateka ahpo inatao yorasitenapua ahpo Taanao, pukaepa pukachi ihcheka inisiame Taanaraa ahpo Noono erasia yorasikaopua. Puuua epeche tiame iintomiitepua pehjio, aamo i'isaerio, epeche peenia erakomeri tiiame. ");
INSERT INTO var_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","No'o Noono aaata tatakorichi wahjipakame ahjatenario, neee yooramepua pu'ka, weemera ahjari piipari ki'yakao. Wa'a tiiachiopua no'o Noono ihsinariao, no'oe ihsiamepua. ");
INSERT INTO var_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Apoe Noonoraa, kihta apoe chiiamepua aaataoi, aaata cheenaresaa, ahpo Taanachi chiiamepua ihta ahpo chianariaopua. ");
INSERT INTO var_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Noonoraa, yooma ahpo Taanae ihsiamepua, apochitia weruma tetewipuawichiopua. Wa'a tiiachipao, Noono Taanara ki iyoriamea, apoe Noonora ki iyoriamekaitepua, apoe Noonora ahpo Taanachi yasitoamekai tiiamekopua. ");
INSERT INTO var_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","’Ki wihtuki aamo chaaniamenia, aaata yooreka keepuamea no'o chiiao, kaawe uuka tetewameopua no'o uhjurakameoi, kiamania pu'kao, weemera ahjario ki wahjiamesi; ihjia kihta seenampa iinuemeri puuua, Riosie ahpo kokosapuaopua wa'asio ahpo tatakoriawichioo, paonakamekopa pu'kao weemera ahjarichio, tatakorika wahjiparichio newitoriopa. ");
INSERT INTO var_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Ihjia te'ta pichiwapua, weeka tatakorichi wahjipakameka tiiamea, ehpe wa'api taawechiami inamumeripua no'o Riosi Taanara chiiao, yooma no'o chiiao yooreka inamukamea, no'oe kiapuamepua pu'ka weemera ahjario, ki wahjiamesi ahjapuameopua wa'asi. ");
INSERT INTO var_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Pu'ka ki wahjiame ahjari no'o Noono tiiameo, noochi teerepatiapa, no'o weeechi tijoetutioio naawatetiaio. Pukaepa neeea, noochi tiiamepua ki wahjiame ahjario, apoe no'o Noonochitia. ");
INSERT INTO var_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Neeepua no'o Noonoe utewari kiatiamea, yooma weeechi ti'tijoerio neee katewemichiopua pu'kao, pu'ka kiisi kaawe noonoiriaopua. Neee puuua aawata wa'a iintomeria, tijoe weerewaeme naawatetiamekapa. ");
INSERT INTO var_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Ka'te tahpitika erakomitiapua, i'ka no'o aamo chaaneriao, neeea, epeche tiiame iintomiitenia pehjio, ahkasi yooma wehtere toatiameoipua wahjipakame, ahjakame werisipumiitenia, ");
INSERT INTO var_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","no'oche chaachasocheopua ahjapukao. Puuu no'o ahjateriaa, i'ka weeechi noochi paparaka kaaweruma iintokamea, no'o ahjama ohjoremichio kiamania, ahkasi ki wahjiamesi. Nape puuu no'o ahjateriaa, ki noochi paparapa ki kaaweruma iintokamea, ki teesa kokosapuame puuua, ahkasi ki wahjiamesi. ");
INSERT INTO var_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","’Neeea, no'o tijoe weerewachi inataria, ki seenu inataripua no'o Noono inatario. Pukaepa neeea, ka'chi iika iintomerinia itapiti ki no'o Noono inataria enesoo. Yooma ihta no'o ihsiaa, te'ta kaaweruma puuua, no'o Noono inatari iintonariopua pu'kao, Apoe no'o Noono uhjurakame ahpo iintonaria ihsimichiopua weeechio. ");
INSERT INTO var_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Eeme wa'api no'o chaachapachitia oowera tijoechitia chiia enesaane, kihta nateyame enemiipua, no'o chiia aatanako tuuyaa, oowera tijoe oijeramechitia chiiame enemiinia waikao. ");
INSERT INTO var_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Nape kahtiaitepua piirechi aaata, noochi ihsika pichiwatame no'o aatanakoo, puuu noochi ihsiwa pichiwatamepua no'o chiiao. ");
INSERT INTO var_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Waani Paatori nehjiariaa, pu'ka aamo uhjuraria iinatukemichio aatanakoo, pichiwaka tuurepua eee cheeka nehjiakao: “Ki neeepua Riosie Weratiamea, puuua no'oo neipa enameripua”, cheekapua. ");
INSERT INTO var_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Nape Waanio no'o aatanako ma'chitariao, ki aaata weeechi tijoee pichiwataniame nakiyamenia no'o aatanakoo. Oowera wa'a chiiamenia Waani cheeriao, pu'ka no'o ma'chitatiamechi noochi paparakameo, tatakoriria cho'weka cheriwenariapa. ");
INSERT INTO var_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Waania, tajayameka teerekamepua no'o ma'chiame nayewakao, no'oo aatanakoo; eemea, ku'witapisi oowera kaawe erakokamepua wa'a kahtiachi e'enapakaopua, keepumiao. ");
INSERT INTO var_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Nape kahtiaitepua piirechi no'o ma'chitamea, no'o Noono apoe puuua, epeche weruma tiiari tiiaeme, ki Waanichitiao; Apoeo no'o ihsitiae, te'ta ma'chitamepua no'o aatanakoo. ");
INSERT INTO var_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","No'o Noono no'o uhjurasaapa, i'wa weeechio apoe wa'api pichiwataka no'o nayewakamepua, aamoeo ki tetewaoipua pu'kao, ki inamuamekaipua pu'ka iiyenario. ");
INSERT INTO var_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Ki pichikere eemea pu'kao, apoe aamo chaanenariaopua, ki pichikekapa eemea pu'kao, noochi chu'wachie aamo nayewenareriaopua. ");
INSERT INTO var_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Eemea kaawe iyonanipua pu'ka Ehkoriami Iyoteriaopua i'yachikao, nape oowera iyonakache teimo orakokaopua ki wahjiame ahjariopua. Nape eemea, puuu wa'api iyoterio noochi simiyame nayewamekoipu, ki pahteka iyonakame eemea pu'kao. ");
INSERT INTO var_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Pukaepa ki noochi e'enakame eemea, nooe aamo kiamichioopua, pu'ka ki wahjiame ahjariopua. ");
INSERT INTO var_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","’Eeme ki uunariamea Ehkoriami Iyoterichi noochi chiiao, aamo kaaweruma nayewamekoi no'oo, ki uuka tetewamenia. ");
INSERT INTO var_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Wa'a chaachapai eemea no'o kaaweruma naewakao, nane'riame neeea aamoo, wihtuki chaachapamekopua aamoo, kiisi nakiyai wa'a chaachapame eemea Riosio. ");
INSERT INTO var_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","No'o Noono kaaweruma tuuyewari aamo i'yetoka eenakamenia, nape eemea, ki no'o kaawe e'raka tetewakamepua no'o eenariao. Nape aaata piirechi ahka enasoopua, ki nane'riai ahka o'inia ahpo eenariachio, pu'seremii eemea puuukamera enasoo. ");
INSERT INTO var_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Eemea ki no'o kaawe e'raka uuka tetewiniamea, aaataai wa'a te'teremiipua ki no'o machiyapa no'o aatanakoo. Eemea wa'a te'tiapao, aaataoi amochi asiyame kaawe e'riamekapao, ki no'o kaawe e'reka uukamepua no'o asikoio, no'oo te'ta Riosikoi, ki no'o machikamekapapua. ");
INSERT INTO var_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Nape wa'atioi ka'te aamo no'o wenejimeri maaemitiapua no'o Noonochio, kajuyachi taawechi katewerichiopua. Ki neee iintomeripua pu'kao, Moise wa'api aamo wenejimeripua ahpo nuurarieopua, Riosie ahpo kiaretiaeopua ehkoriamio, puuu wa'api Moise kiaretia nuurari nokisika mochitowa, aamo wa'api ahjachi erakoae. ");
INSERT INTO var_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Moise chiia pichikesaa, noochi paparamera enemii eemea, Moiseo noochi simiyame nayewaka iyoteriopa. ");
INSERT INTO var_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Nape ki pichikere eemea pu'kao. Waikao, ¿achini teeka pichiketa eemea i'ka no'o chiiao? ");
INSERT INTO var_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Neipa i'kao Eesusi ahjamao, paonatiapua Arirea pa'wechio, Tiiwerio pa'werachi tewaniamechiopua tiame. ");
INSERT INTO var_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Muuwaeme ti'tijoe ooweru tiamea, pa'we suuwerachiko taamo na'naritokapua taamo tetewitoka, pu'ka Eesusio ki nu'nuti ki maaenari yorasiamekopapua, ko'koame sautesikao. ");
INSERT INTO var_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Wa'a tetekitioopa Eesusia, teewi yasipakapua nahpuchi, teemea waikao, norikame mochipakapua Eesusio. ");
INSERT INTO var_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Wa'a taamo nokayoio, amori asiyachikapua Semejenato pahkoa. Pukaepa pu'ka pahkochi simiyame taamo nayewemio maaekai teemea. ");
INSERT INTO var_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Nape Eesusia ki ookapi ahpo na'naritoriopaopua, chaanekapua Eeripeo: —¿Achini iika tewita teeme kooame, yooma i'ka muuwaemewichioo? ");
INSERT INTO var_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Oowera wa'a cheekapua Eesusia Eeripeo, aatia cheetarepua e'raka, ahpochi paparaopua, nane'riai cheere Eesusia ahpo iintomiao. ");
INSERT INTO var_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Nape Eeripea nehjiakapua: —Ooka siento taawe sotatiame taritiai kooame, ki ahsepatariaipua posaka ko'koniameopua. ");
INSERT INTO var_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Waikao piiripi masitera Anteresi tewaniamea, Siimoni Peeroo pooniraa, chaanekapua Eesusio: ");
INSERT INTO var_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","—Piiripi kuita temari nutukarache maanipua, nape mariki paani wa'api, seewara tewaniame tiiriko paani, ooka so'chi ahjama, nape ¿ihtanapua, ki ookapiwichioo? ");
INSERT INTO var_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Eesusia taamo chaanekapua ahpo ma'masiterao: —Mochipanuremitiapua pu'kao, yoomahka. Waikao mochipakapua paasepochi, weeru paasepochikopa wa'ao, mariki miiri ahkakapua mochipakamea, ti'tijoeapua ooweruapua tiame. ");
INSERT INTO var_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Eesusia kiatiapa pu'ka mariki paanio, pu'ka ooka so'chiopua tiameo, cheriwema ki'yakapua ahpo Noono te'pa tewekachi kahtiameo. Wa'a iintosaapa Eesusia, taamo ki'yakapua pu'kao yooma ti'tijoeri naachutemichioopua. Waikao teemea yooma naachutekapua, yoomahka ko'kotiapua ahkasi poposaka aiwaniachisi. ");
INSERT INTO var_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Waikao Eesusia yoomahka aiwaka poposatioopa, taamo ahpo ajawariao, chaanekapua: —Yooma na'poamitiapua chi'wapame soparakameo, kihta wa'atia wekamichiopua. ");
INSERT INTO var_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Waikao teeme na'poanuraretiamea, oosa mariki aampa ooka waari weeweruma na'poatiapua chi'wapame soparakameopua, pu'ka mariki paani tiiriko seewara tewaniamee, paanitatiame. ");
INSERT INTO var_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Waikao yooma puuu ti'tijoe ooweru tiamea, i'ka ki nu'uti ki maaenari Eesusi iintoriao, ki nu'uti peenia tiiame chaachapakapua ahpoo: —¡Te'ta pichiwa Riosie tamochi ti'tijoerichi enamio tuutiamera ihjía! ");
INSERT INTO var_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Nape Eesusia nane'rekaopua ahpoo, utewachi i'topuamekoopua yawichi weramiaopua, poanachi akipakapua ki naania iika wa'ao, epeche teewiami ooruchi. ");
INSERT INTO var_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Tukaoopua wa'asi, teeme masiteraa pa'wesuwe tetekisaapua, ");
INSERT INTO var_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","pawekakerachi mo'moenatiapua. Pawekakerachi mo'moenasaapa, wa'a pa'wechipo nokisiniapua, Kapenau muuwari mochiwachipoopua. Teemea Eesusio ki eenopa tukaokopaopua wa'asio, teemeche piineri uumatokapua, Kapenaukoo. ");
INSERT INTO var_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Wa'a keenako Tiiwerio pa'wechipo nokisinioio, ki muuenati eejekapua, ahkasi pa'weoi ki nu'unti pe'koteka, te'pasi wewerisitiapua pe'konio. ");
INSERT INTO var_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Téhpe nokisinioio pa'wechipoo, tehki nokisikaopua pawekakerao matakakesikao, taamo pukamina ihtoame tetewitia aaatao, nerojampa weritoame. Teemea, wa'a ihtoame tetewapao tísia majaka teemea, ki machikapa Eesusikoiopua, tukaokopa. ");
INSERT INTO var_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Nape Eesusia taamo sisinachachapua cheeka: —¡Ka'te majako eemea, neeekaite puuua! ");
INSERT INTO var_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Waikao teemea majayaio kaawe erapakapua. Waikao tísia kaawe e'raka mooenaputiapua pawekakerachio, wa'a ikitioopua, ikanati Kapenau pawekakera chuchupachi ajasitiapua. ");
INSERT INTO var_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Pu'ka meereopua, wanamina pa'wechi itipikamea, ki tetewakapa puuuche pawekakera wa'a pa'a piari chuhkuameo, nane'reriapua pu'ka masiterao piineri uumatoriopua, ki Eesusi ahjama. ");
INSERT INTO var_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Waikatakirio, piirechi pawekakerachi Tiiweria eename, chuchupakame tetewariapua, Eesusi ko'koteriachimina muuwaeme ti'tijoerio. ");
INSERT INTO var_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Waikao ki tewakapa Eesusio pu'ka Tiiweria eename pawekakerachio, i'yamo oraparia puuua. Pukaepa pu'ka pawekakerachi mo'moenasa, Kapenau siimpariapua. ");
INSERT INTO var_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Paonasaapa pu'ka neerochio, wa'a tewisaapa Eesusio Kapenauo, iinatukekapua Eesusio: —Masitari, ¿achinitio asikamua i'wao? ");
INSERT INTO var_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Nape Eesusia cheeka nehjiakapua pu'kao: —¿Eemea pahtekamekosa eemea no'o aatanakoo, ki maaepori iintokopao, wa'a tiachipa noochi paparanariame eemea? ¿Oowera aamo no'o ko'kotemichio e'nakamekosajuoipua naaju, no'o i'yasikao? ");
INSERT INTO var_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Ka'te resipamita eemea aamo kooameche ki tehpe e'rameche i'yakao, ohso kaawe eemea tehpe e'ramera kooame i'yame enepuapua, pu'ka kooame ko'kosaa eeme, ki wahjiamesi ahjari eneniame, pu'kao, neee Tijoe Tijoetukamea, nooe inisia aamo ki'yakao. Wa'a iintomichio no'o uhjurakame no'o Noonoa i'ka weeechio. ");
INSERT INTO var_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Waikao aapoeo iinatukekapua: —¿Ihtanakosapu taamo nokijera Riosi? ");
INSERT INTO var_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Eesusia nehjiakapua pu'kao: —Naati puuua, no'o ahpo uhjurariachi pichikeniame. ");
INSERT INTO var_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Waikao aapoeo chaanekapua: —¿Ihtatia ki maaepori tiame yoratamu, pu'kao tetewakapa, aamo pichikemichio? Yorasao naaju pu'kao. Árisa, eenechi ko'kotesao naaju. ");
INSERT INTO var_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Moisetarua wa'a iintokamepua, maana koi'ra ko'kotekao taamo ehkoriami mochiriameo, wakiwechiami nokisinioio. Wa'a chiiame Ehkoriami Iyoterichiopua, eee cheekao: “Apoeo, tewekachi eename koi'wame, ko'kotekapua.” ");
INSERT INTO var_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Waikao Eesusia chaanekapua: —Nape neeea, ki Moisetaru iintorio tuunania pu'kao, Apoe iintorio tuunania pu'kao no'o Noonó, tewekachi kahtiame. Puuu Apoepua tiameo, pu'ka te'ta pichiwari kooame ki'yameraa, tewekachi eenameo. ");
INSERT INTO var_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Te'ta pichiwari kooamea, tewekachi o'inia eenakamerapua, Apoepua tewekachi o'inia tekikame; puuu te'ta tewekachi kooamea, tewekachi tekekamepua ahjae te'ta weemera ahjari teerepuawichioopua. ");
INSERT INTO var_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Aapoea waikao, wa'a chiiopa Eesusio, chaachapakapua Eesusio: —¡Aa Paamiraa, naakonakosa wa'a tiiamepua? ¡Pu'kakamera kooame taamo kiamitiapua ohso kaawe! ");
INSERT INTO var_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Waikao wa'a chaachapakopa pu'kao Eesusia chaanekapua: —Nape neeea, ki aamo kooame erakoa chiiamenia. No'o wa'api naewaka chiiaitenia, no'oo kooamechitia nayewakaopua. Neeekaite puuua, puuu kooamea. Noochi paparaka e'enakamea ko'komiao, kiisi chorowameripua wa'asi, noochi paparakamea, ki oosa paramumerioipua. ");
INSERT INTO var_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Nape no'o aamo cheeriachitia, eemea ki pichikenapua no'o chiiao no'oo aatanakoo, tetewaiopua. ");
INSERT INTO var_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Yooma puuu no'o kiapuamea no'o Noonoeo, noomina e'enameripua; wa'a ikisoo pu'kao, neeea uumeripua. ");
INSERT INTO var_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Neeea ki no'o e'ra yoramia eenakamenia tepoonaopua tewekatepao, naati e'ra yoramia eenakamenia, Apoe puuu no'oo uhjurakame. ");
INSERT INTO var_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Apoe no'o uhjurakame e'raa, kaawe neesetopuamepua pu'ka no'o kiapuameo, neeea pu'kao, eenechi ahjatemerinia pu'kao i'ka weeechio mukukoi, pu'ka kajuyachi taawechi te'ta asisoopua wa'asi. ");
INSERT INTO var_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","No'o Noono nakiyaa, ki wahjiamesi ahjaniamepua, aaata pahteka tetewikame ahpo Taanaopua aatanakoo, ahpo Taanachikamera paparakaopua. Waikao yooma aaata noochi paparameo, wahjipakameoi i'ka weeechio, waika kajuyachi taawechiopua, eenechi ahjatemania pu'kao. ");
INSERT INTO var_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Waikao puuu i'isaeri ti'tijoeria rurumurakao, kiisi kaawe chaachapakapua Eesusio, Eesusio chiiopao: “Neeepua tewekachi o'inia tekikame koi'ra.” ");
INSERT INTO var_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Wa'a cheekopao ti'tijoeria, chaachapakapua: —¿Ki ihjipu Eesusi, Oose tewaniame taanara? ¿Ki machiyame teemea pu'ka yeeyerao, pu'ka noonoraopua tiame? ¿Achinikai tewekachi o'inia tekikameko tuunapua? ");
INSERT INTO var_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Waikao Eesusia chaanekapua pu'kao: —Tooa pu'ka aamo rurumura chaachapao. Te'ta pichiwamekaite neeea no'o chiiao, te'ta tewekachi no'o eenamekoo, te'ta pichiwari puuua; neeepua te'ta tewekachi kooamea, no'o ahjae te'ta ahjari aamo ki'yaa. ");
INSERT INTO var_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Nape aaataai ki keepukame no'o Noono chiiao, noochi e'enanurawa paajutetio, ka'chi iika enameripua noochio, pu'ka Riosi kooame uhjuraria ko'komiao. Nape no'o Noono paajutewa e'waka e'enakamea, ko'komeripua pu'ka kooameo. Waikao neeea pu'kao, weemera ahjarichi te'terewa kiamania. Pu'kaonia wa'a iintoriaopua, kajuyachi taawechio, eenechi ahjatemania wahjipariameoipua. ");
INSERT INTO var_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Ehkoriami Isaia Iyoteriachio chaanipua: “Yooma Riosi mochiwarichi mochimeria, Riosie masitetiame enemeripua.” Wa'a tiiachipa, yooma no'o Noonoe pepenitetiamea, yoorekamea tiame, noomina e'enamepua. ");
INSERT INTO var_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","’Aawataai ki tetewai Riosi ahjae pepenipakamepua, Riosio ki aaata puusie tetewiniamekopua, naatiche tetewikamepua pu'kao Riosichi wa'api eenakame. ");
INSERT INTO var_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Wa'a tiiachio te'ta pichiwa ihjia: noochi paparakamea, weemera ahjari iinuepakamepua, te'ta ahjari ki wahjiamesi. ");
INSERT INTO var_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Neeekaitepu puuu kooamea, ahjaetiamea pu'ka weemera ahjario. ");
INSERT INTO var_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Aamo ehkoriamia maana koi'ra ko'kakaipua wakiwechi nokisiaio, wahjipakamepua. ");
INSERT INTO var_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Nape neeea seenu kooame naewaninia, tewekachi o'inia tekikame, pu'ka ko'kakameo ki mukimapua seena aampa. ");
INSERT INTO var_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Neeeju puuu kooame ahjatiamea, te'ta tewekachi o'inia eenakamea. Pu'ka kooame ko'kakamea, mukukai, ahjari teeremapua ki seena aampasi. Puuu kooame no'o weerewa puuua, i'kao, i'wa wehjoarichi mochikame kiamania pu'kao, ki seena aampasi ahjamichiopua pu'kao. ");
INSERT INTO var_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","I'isaeri ti'tijoea ki pahtiapa puuua, ahpo chaachapakapua: —¿Achini iintoka taamo kiatapua ahpo weerewa ko'kopuaopua? ");
INSERT INTO var_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Waikao Eesusia wa'a chaachapopao, chaanekapua: —Neeea pichiwa aamo chaanenapua, ki aamo ko'kosoo no'o weerewao, iijisoo tiame no'o eeraraooi, ki iinuemeri eemea amochio, te'ta pichiwari ahjario. ");
INSERT INTO var_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Ko'kakamea no'o weerewao, iijikamea tiame no'o eerao, iinueme puuuapa, ki wahjiamesi ahjaniameo; pu'kao neeea kajurachi taawechio, mukukoiopua pu'kao, eenechi ahjatema neeea. ");
INSERT INTO var_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","No'o weerewaa ki oowera kooamepua, no'o eeraa tiame ki oowera iijiwaripua. ");
INSERT INTO var_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","No'o weerewa ko'kakamea, no'o eera iijikamea tiame, noochi ohjoeka kahtiame puuua, neeeai pukachi kahtiamepua. ");
INSERT INTO var_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","No'o Noono ahjaria no'o ahjari puai, apoe no'o uhjurakame. Pukaepa, noochi koayamea, noochi uuka ahjamapua ahjario. ");
INSERT INTO var_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Puuupua te'ta kooame tepoona eenamea tewekachi, ki puuuka tiamepua maana koi'ra taamo ehkoriamio ko'karia, pu'kao ko'kakaio wahjipatiame; nape i'ka kooame ko'kakamea, mukukai, ahjamapua, ki seena aampasi. ");
INSERT INTO var_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Pu'ka wa'atiame masiteka Eesusia Kapenau napawikarichio. ");
INSERT INTO var_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Muuwaemea, yooma i'ka wa'a tiame inamukapao, ahpo ihchio chaachapariapua: —Nape ihji pu'ka chiiaa, ki teesa tehki tiiamepua. ¿Aaatatia pahteta pu'kao? ");
INSERT INTO var_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Nape Eesusia nane'riapa pu'ka ahpo masitia chaachapao, chaanekapua: —¿Kiisi pahtena eemea no'o masitiao pehjio? ");
INSERT INTO var_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","¿Achipu erakotariamare eemea no'o aatanako pahtesaopa, no'oo Tijoe Tijoetukameo te'pa tewekachi tetewime teeresaapua no'o yasariachio, ke'chu i'ka weeechi no'o tekioiopua? Waikaope tísia pahtemerii eemea, i'ka aamo tuuyao. ");
INSERT INTO var_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Taamo iikarakamera ahjatiamepua taamo weerewao; ki iikaeme enesaa teeme taamo weerewachio, ki ahjamii teemea taamo weerewaraa, oowera weerewachea piineri, kihtawichio kaawekamepua. No'o aamo nayeweriaa te'ta iikachi simiyamepua, te'ta pichiwarikamera ahjari amochi teerepame, aamo kaawe e'reka u'wisoopua. ");
INSERT INTO var_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Nape iintuna eemea paikapi ki no'o pichikiame. Wa'a cheere puuuapu Eesusia nane'riapa pukeri o'inia aatanako ahpo ki pichikemerio, wa'a ikisa aatanako tiame ahpo nehjimerio noriwi. ");
INSERT INTO var_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Eesusi aampachi cheekapua tiameo: —Pukaepa aamo chaanekamene ki aaata enamio tuuka noochio, ki no'o Noonoe eratetiame enesoo. ");
INSERT INTO var_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Waikao o'inia neipao, puuu muuwaeme Eesusi ahjama ohjoamea keepuka, toakapua Eesusio, ki ohjokapua ahjamao wa'asi. ");
INSERT INTO var_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Wa'a ijikikopapua pu'kao, Eesusia taamo iinatukekapua tiame, ahpo oosa mariki aampa ookao: —¿No'o toitare eemeai? ");
INSERT INTO var_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Siimoni Peeroa nehjiakapua yooma taamowichioo: —Paamira, ¿aatanachi uumpata teeme? ¿Ki muuuchekosamu, taamo ki wahjiame ahjari masitekamea? ");
INSERT INTO var_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Aamokamera pichikiame teemea, aamo nane'riamekapa teemea, te'ta pichiwa tewekachi o'inia eenamekopua, aamoo Riosie, Te'ta Weratiamekopua. ");
INSERT INTO var_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Eesusia waikao chaanekapua pu'kao: —Nape Peeroo, ki yooma eeme wa'achi erakoamekopua. Piiripi eemea na'arame tijoepua, aamo oosa mariki aampa ookao, no'o poanataka uurioipua, no'o ahjama tekipanamichiopua. ");
INSERT INTO var_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Wa'a cheekao Eesusia, Uurasi nayewaka cheeriapua, Siimoni Ihkarióte taanara, puuu Uurasikamera enemerikopua te'ta na'aramerio, nanaaramechi ahpo nehjakaopua, noriwi. Eesusia nane'riame eneriapua wa'a iintomerikopua, Uurasia wa'apikai oosa mariki aampa ooka uutiamea. ");
INSERT INTO var_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Neipa i'kao Eesusi ahjama Arirea weeerachiami ohjotiapua. Eesusia ki oinarekapua Uurea weeechiopua, i'isaeri pa'pamiratuameeopua merinareniapao. ");
INSERT INTO var_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Ekapora Pahko asiyopaopua i'isaeri papakotao, ");
INSERT INTO var_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Eesusi poponiraa ki nakiyapaopua ahpo pa'chio, chaachapakapua Eesusio: —¿Achini iikai ki Uurea siminamua wa'a mochikame aamo na'naritoameai, aamo tetewimichiopua pahkochi, aamo ki maaenari tísia peenia tiame ihsiaopua tiame? ");
INSERT INTO var_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Aaataai ahpo weruma tetewijeramea ki itipiamepua noriwio, ohso kaawe ahpo tetewitiamepua, ahpo peenia ihsiao, ahpo weruma tiiaopua, machipuawichiopua. Wa'a simika iintometiaimua aamo peenia ihsiao, yooma wa'a pahkochi nokayameo, aamo pu'sereka tetewimichiopua. ");
INSERT INTO var_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Aapoe wa'api poponiraa, oowera wa'a chaachapamekapua, ki ahjachi paparapapua Eesusichio. ");
INSERT INTO var_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Nape Eesusia wa'a chaachapopao, chaanekapua pu'kao: —Ka'i. Ki siimania pehji wa'ao, ki asiyame neeea noochio pehji, no'o te'ta ma'chiame oimiachiopua; nape wa'a tiiainia noochio, amochio ka'chi tiamepua aamo siimpamiao. ");
INSERT INTO var_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Eemea ki seepurawaemepua wa'ao, nape neeeape, neeea no'o seepurawao, ma'chitamekapapua pu'kao, ki kaawe nokayao. ");
INSERT INTO var_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Eemea siimpanariaa siimpapuapua. Neeea i'wa itipimapua pehjio, ki asiyapa pehjio, no'oo te'ta ma'chiame oimichioopua pehjio. ");
INSERT INTO var_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Wa'a cheeka itipika Eesusia Arireao, teeme ahjama ohjoameapua tiame. ");
INSERT INTO var_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Neipa ahpo poponi siimpasoopua, wa'achi siimpatiapua tiame, nape Eesusia noriwi teetoka. ");
INSERT INTO var_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","I'isaeri pa'pamiratuamea pahkochio, i'yaka ohjoriapua Eesusio, iinatukeka ti'tijoerio. ");
INSERT INTO var_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Wa'a pahkochio, muuwaeme ti'tijoeri kaaweruma naewamekapua Eesusio, ooweru tiame, nape pu'kachepao noriwi teereka. Eesusi naewamea ookapi, kaawerumako tuuyamekapua Eesusio, nape wahjachia Eesusi na'araka naewamea, ki kaawerumako tuuyamekapua Eesusio, ti'tijoe wisikuiameko tuuyapua pu'kao. ");
INSERT INTO var_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Nape Eesusi kaaweruma chaachapamea, wichipa nayewaka kaawe chaachapaka nayewamekapua Eesusio, majayamekapa i'isaeri pa'pamiratuameo. ");
INSERT INTO var_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Naasipa simiyoipa ekapora pahkoo, Eesusia tiopachi pakikao, wa'a napawikame masitekapua, ti'tijoe ooweru tiame. ");
INSERT INTO var_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Waikao wa'a tiopachi i'isaeri wa'a e'enamea, peenia erakoka inamukapa Eesusi masitiao, chaachapakapua: —¿Achini ihsika ki ookapi machiyame ihji tijoea, ki penitetiameaipua ma'masitarieo? ");
INSERT INTO var_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Eesusia inamukapa pu'ka chaachapao, chaanekapua: —No'o masitiaa ki nooechi simiyamepua, apoe no'o uhjurakamee chanitiame ihjia. ");
INSERT INTO var_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Aaata te'ta Riosi e'ra e'weka mochikamea, machika inamumapua i'ka no'o chiiao, nane'remapua tiameo no'oo Riosichi eename nayewamekoopua; machika inamumapua no'oo, no'o nayewao oowera noochi machename enesoopua. ");
INSERT INTO var_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Aaata piire ahka apochiche machename masitiame enesaa, ahpokamera kaawe e'repuawichio masitiame puuua; nape aaata ahpo uhjurakamekamera kaawe e'repuawichio i'yamea, te'ta pichiwari nayewamapua ahpo uhjurariao, kihta ahpowichiokamera kaawe e'repuawichiopua i'yakao. ");
INSERT INTO var_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","’¿Ki pichiwakosapu Riosi Moisetaruo ki'yaria nuuraria? Pichiwa tiiame enerepua, nape eemea kiisi yooriamepua pu'ka nuurario. Eemea pu'ka Riosi nuurari te'ta yooriame enesaa, kiisi no'o merinaremii eemea. ");
INSERT INTO var_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Waikaopu ti'tijoeria, chaachapakapua: —Nawajikamepu muuua, teekupakame muuua chiia. ¿Aatanapu aamo merinariamea? ");
INSERT INTO var_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Waikao Eesusia chaanekapua pu'kao: —Nee, piiripi tijoe sautekainia, nape eemea ki nu'uti no'o nekaweka tetewakapua, resipuniame taawechi no'o wa'a iintoriopa. ¿Achini tiiachipa no'o nekawekame eemea? ");
INSERT INTO var_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Eemeai kiisi iyoriamepua, eemeai resipuniame taawechioi, aamo siichitepuwa nokayamekopapua, pu'ka nokiwao te'ta iyorimichio kiatiamekaipua, Moiseeo. (Nape ki Moisekamerae o'inetiamekoipua ihji siichitepuwa nokiwaopua, aamo wa'api ehkoriami noonorikamera o'ineriamekoipua, i'ka siichitepuwa nokiwameopua.) ");
INSERT INTO var_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Waikao aamoo resipuniame taawechioi, aamo tijoe kohjakoi siichitepuameaipua, Moisetaru nuurari iyorikao, ¿achini iikai nekakona eemea no'oo aaata sautesoo resipuniame taawechio? ");
INSERT INTO var_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Kiisi oowera wa'a teeremeche tiamechiche ne'nekache chaachapamete eemea. Eemea aaataoi ki kaawe iintorio chaachapanariaa, ke'chu aaata te'yaiopua, te'ta kaawe teeremio ne'nesapa, teripuapua terinariaa. ");
INSERT INTO var_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Eerusareni ohjoemea, Eesusi kaawe nayewame inamukaopua, ahpo chaachapakapua: —¿Ki ihji ohjoare i'yaniamea merinareka? ");
INSERT INTO var_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Wa'a ihsinapua yooma inamuachi nayewaka, aaataai ki a'chi chaanenapua pu'kao. ¿Wa'atia kaawe e'renakosapua i'isaeri yoorewa neesetoameai, pichiwa Riosie Weratiamekopua Riosichi eenameo, i'ka wehjoarichi mochikamechiwichio weratiamekoopua? ");
INSERT INTO var_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Nape teemea i'ka tijoeo, ¿nane'riamekosa teemea, akana naawakamekoopua? Nape te'ta Meesia eenoiopua, puuua Riosie Weratiame tewaniameo, aaataai ki nane'remeripua, ahka i'ka weeechi o'inia eenariachio, teemea tewekachi o'inia enameriko erakoapa. ");
INSERT INTO var_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","I'ka wa'a tiame inamukapao Eesusia, tiopachi masiteka weeru nayewakao, chaanekapua pu'kao: —Eje'e no'o maachi eemea, maachi eemea no'o ohjirachiopua tiameo, nape eemea ki maachipua ki i'ka wehjoarichiche no'o ohjoemekoo. Neeea aaata aamo ki machiyamee, uhjuratiamepua. ");
INSERT INTO var_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Neeea maachipua pu'kao, pukae uhjuratiamekapa i'wa wehjoarichio. ");
INSERT INTO var_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Wa'a chiiopa Eesusio, iyoriwa inatiamea, chapisa i'tomo orapakaipua Eesusio, peereso yachamia. Nape wa'a erakokameai, ki chapikapua pu'kao, Riosieo wa'a tiiame po'yopua pehjio. ");
INSERT INTO var_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Nape Eesusio muuwaeme ki nakiyoiopua, muuwaeme ahjachi erakoriapua tiame, wahjachia chaachapariapua: —¿Aatana aaata epeche tiiame iintotamarepua ki ihjichitia, i'ka eee tiiame ki maaenari yoorakao? ¿Ki ihjijuare Riosie Weratiamea? ");
INSERT INTO var_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Iyoriwa neesetoria, ihchi kaawe naewaniopa Eesusio, ki anachapariapua waikao, ikanati uhjurariapua waikao, Eesusi chapimichio. ");
INSERT INTO var_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Waikao Eesusia ahpo chapimia e'enakameo, chaanekapua: —Ku'itapi yasimeri neeea, aamo ahjamaopua pehjio. Wa'a ikisaapa neeea, no'ramerinia, no'o uhjurakame kahtiachi. ");
INSERT INTO var_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Wa'a no'o no'rasoopua, no'o i'yaio eemea, ki no'o teimeripua. No'o yasimiachio ka'chi iika e'enameri eemea wa'ao, no'o ahjamao. ");
INSERT INTO var_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","36","I'isaeria ahpo chaachapakapua: —¿Achini cheeka chaanipua naaju ki ahpo teipo tuukao? ¿Wahka simika chiiarepua naaju seesenu weeechi, wahkami ahka mochikame, ki isaeri ti'tijoerikamera masitemia? ¿Akahtia akipatapua ki teipua? ");
INSERT INTO var_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Eesusia kajuyachio pahkoo, epeche iyoriwa taawechiopua pahkoo, werisika chaachanekapua: —Aaata piire ahka paramuamea, noochi e'enaka nerojimeripua. ");
INSERT INTO var_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Noochi eenaka nerojikamea, tísia kaawe erameripua ahpo iikachio, ki ku'ita neeroi u'mamechitia akichi. Wa'a chiiame Ehkoriami Iyoterichio. ");
INSERT INTO var_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","I'ka wa'a tiiame cheekao Eesusia, Riosi Riosiwari ku'iwa naewaka cheeriapua pu'kao, Riosie Eesusichi paparakameo kiapuameopua pu'kao. Nape ihji Riosi Riosiwari ku'iwaa, ahkasi Eesusi eenechi tewekachi mooenasopa, kiapuamepua Eesusichi paparameo. ");
INSERT INTO var_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Wa'a cheekame inamukamea Eesusio, chaachapakapua: —Pichiwa wa'a ikitiame ihjia, ehkoriami enamo tuutiamea Riosi nayewaturaeo. ");
INSERT INTO var_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Nape wahjachia chaachapapua: —Apoe ihjia, Riosie te'ta uutiamera, Riosie Weratiame. Epeche wahjachia tiame, chaachapapua ookapi: —¿Nape Arirea o'inia enatare puuua? ");
INSERT INTO var_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","¿Ki Weereni machenamerikai puuua, Raawitaru tetejimarichi, ehkoriami yasakame Weerenichi wa'api? ¿Ki wa'akosa chaanipu Ehkoriami Iyoteri? ");
INSERT INTO var_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Wa'a chaachapakapa puuua Eesusio, ahpo poanatukapua. ");
INSERT INTO var_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Ookapi puuu ki wa'achitia ahpo inatamea, chapinareriai puuua Eesusio, nape ka'chi yoorakapua pu'kao, wa'a e'erakoaiopua. ");
INSERT INTO var_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Waikao iyoriwa inatiamea wa'ao, wa'atia nonowakapua parisero mochikachio, wa'ao te'ta ne'neseriosi pa'pamuratuamea, iinatukekapua pu'kao: —¿Achinikai ki chapika eemea pu'kao? ");
INSERT INTO var_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","—Seewepaka teemeapu pu'kao, ki nu'uti peeneka nayewamekopa, kiisi aawatachitia —chaachapaka nehjiariapua, iyoriwa inatiamea. ");
INSERT INTO var_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Waikao te'ta ne'neseriosi pa'pamuratuamea, chaachapariapua: —¡Aa eemeai, sewina erapakapua naaju, ahjachi paparanarekao? ");
INSERT INTO var_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","¿Akana inamuame eemea, aaata taamo pa'pamiratuameo, aaataai pa'pariseroai, pukachi paparanariamekoo? ");
INSERT INTO var_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Ka'ii, wa'a nokayamepua, ki machiyamea taamo masitiao. Wa'a te'teriapa puuua, kokosapuamepua Riosieo. ");
INSERT INTO var_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nape Nikoremoa, puuu piie tukaoo Eesusi nayewemia eenakamea, chaaneriapua ahpo napawiriachio: ");
INSERT INTO var_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","—Taamo nuurari yooreka mochitoniamea, iinatuteka nane'renuriamepua pahcha, itapiti aaata a'chi iintoria katewenariaa. ");
INSERT INTO var_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Aapoeo nehjiariapua: —¿Ki muuuju tiame Arirea tijoe, puuuchitia? Ne'neo amoe, i'ka Ehkoriami Iyoterichio ki wa'a chiio, aawataai puuu Riosi na'nayewaturao, ki Arirea puuyakamekopua. ");
INSERT INTO var_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Napawikamea, yooma i'ka chaachapasaapa, nonowariapua tiame, ahpo ta'pechiami. ");
INSERT INTO var_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Nape Eesusia, teewi ajasitiapua roomosachite, Ooriwo tewaniachi. ");
INSERT INTO var_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Pu'ka meereo, piari yasisisaapa, eenechi wa'a e'enatiapua i'isaeri tiopachi. Wa'ao, muuwaeme ahsekapua pu'kao. Waikao Eesusia yasipakao, o'inekapua eenechi, masiteka. ");
INSERT INTO var_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Wa'a ihsioipa Eesusio masitekao, Moise nuurari ne'nesetoria, pa'pariseroa tiame wa'a e'enakapua, piiripi oowitiame i'toka, suwepori ihsioi chapitiame. Ihjia pu'kao, naasipa werapakao, ");
INSERT INTO var_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","chaachapakapua Eesusio: —Masitari, i'wa weeri ihji oowitiame, suwepori ihsioi chapitiame. ");
INSERT INTO var_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Moisetaru nuuraria, pasaka merinuramepua wa'a iintokameo. Nape muuua, ¿ihtana iintopuameko chiiamemua i'ka oowitiame wa'a iintokameo? ");
INSERT INTO var_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Oowera wa'a chaachapakame puuua, Eesusio ki kaawe chaachasoo, chapinariapa. Nape pu'kao wa'a chaachapoio, Eesusia chukipaka wehchi iyotekapua. ");
INSERT INTO var_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Waikao, simiteniapaopua iinatukekao, riisasipakao Eesusia, chaanekapua pu'kao: —Aaata eemea ki tatakorieme enesaa, pasipupuapua, i'ka oowitiameo. ");
INSERT INTO var_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Wa'a cheesapa, eenechi chukipaka simitekapua iyotekao, wehchi. ");
INSERT INTO var_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Waikao wa'a chaanetiapa aaata pasipumeria, aaataai ki pasipukapua, piiripi o'inekaopua ahpo tehte makoyao, wa'atia ki pasipusa yooma pipiripi ahka ihpapasa nonorakapua, o'ochetiame pahcha o'ineka, ahkasi yooma. Wa'a ikitoopua Eesusia, piineri toitiapua, oowitiameche ahpo chokichi weeriameche ahjama. ");
INSERT INTO var_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Waikao Eesusia oowitiameo, nanarichi ne'nepaka iinatukekapua: —¿Akana uumparupu aamo wenejiamea? ¿Piiripiai, ki aamo pasipurupua? ");
INSERT INTO var_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Ka'i —cheekapu oowitiamea— aaataai, Paamira. Waikao Eesusia chaanekapua pu'ka oowitiameo: —Neeeai wa'atia aamo toiyamepua, kihta terika. Neeea aamo ki kaawe iintoriao, cheriwetiame aamo itipitiamenia. Kaawe erakoka no'rasa naaju. Ka'te oosa aampa, tatakorimitia naaju. ");
INSERT INTO var_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Waikao Eesusia, eenechi simitekaopua masitekao, ahpo masitiao, chaanekapua: —Neee puuua, i'ka wehjoarichi mochikame tajayamenia, ki tukapachi ohjomichiopua. No'o na'naritoamea, ki tukapachi oimeri puuua, no'o tahjera uutapachi oiyapa. No'o tajaya pahtewari apochi uukamea, te'ta weemera ahjari iinuepamepua, ahkasi ki wahjiamesi. ");
INSERT INTO var_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Pa'parisero iyoriwa inatiamea, chaanekapua Eesusio: —Amoe wa'api, nayewanimua, aamo wa'api. Ahpo wa'api nayewaniamea, kiisi pichiwapua chiiaa. ");
INSERT INTO var_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Eesusia nehjiakapua: —Nape wa'atioi, no'o wa'api nayewainia, pichiwa chaaninia, nane'riapa no'oo, aatanako. Neeea nane'riamenia no'oo, akana o'inia no'o eenamekoo, akana no'o no'wamerikooipua tiameo; nape pu'kao eemea no'oo, ki nane'riamepua. ");
INSERT INTO var_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Eemea, ki no'o te'ta machiyamekai aatanakoo, ki pichikiame eemea no'o pichiwa chiiao, no'o weeechiche ohjoeme maayamekapapua, oowera weeechi mochikamechitia inatamepua. Nape aamoo wa'atia ki kaaweruma inatoiopua noochio, kihta aamo iikachio i'yame neeea, kaawerumakoio ki kaawerumakoio, aaatachioipua amochio. ");
INSERT INTO var_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Nape amochi i'yame enesaania, ki ookapi teimiinia ki ka'karuma noochi inatao. Wa'a ikimeri neeea amochio, ki piinerikapa neeea te'ta pichiwatamea, ookakapa teemea amochi i'yameria, neeepua piiripia, no'o Noonopua piirea, Apoe no'o uhjurakamera, te'pa tewekachi kahtiame. ");
INSERT INTO var_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Aamo yoorewa iyoriwachio, ooka tijoe wa'achi chaachapaka pichiwatameo, pichiwachitia uuyame eemea. ");
INSERT INTO var_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Wa'a teeresoo aamo yoorewa iyoriwao, waikao ooka pichiwatamea iniwae neeeai: no'o Noonopua piiripia, apoe no'o uhjurakamera, neeepua piirea. Na'pa teemea, wa'achi chaachapaka pichiwatamepua, no'o chiiao. ");
INSERT INTO var_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Waikao aapoeo chaachapakapua: —¿Nape akana kahti aamo noonoa?, ki naaniatepua i'wao. Eesusia nehjiakapua: —¡Aa, wa'a chaachapaka nayewame eemea, te'ta no'oo ki machiyapa, te'ta no'o Noonooi ki machiyapa! Te'ta no'o machiyame enesaa eemea, machiyame enemii eemea no'o Noonooi. ");
INSERT INTO var_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","I'ka wa'atiame cheeka masiteka Eesusia isaeri tiopachio, waapi toomi ihkokewa toaniachiopua, tiopachiwichio ku'iwariopua. Wa'atiame masitioiopua, ki aaata a'chi yoorare Eesusio, chapinariaiopua pu'kao. Puuu Eesusi chapinariai ki chapitiamea, apoe wa'a teerere puuua, ki asiyapa pehji, Riosi nakiyachitia chapipuameo. ");
INSERT INTO var_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Eesusia eenechi chaanekapua: —Siimerikaite neeeapa. Waikao eemea, ahkaoi no'o i'yaio, ki no'o teimii eemea, wa'a no'o simiyachio. No'o simiyachio, ka'chi iika siimpameri eemea. ");
INSERT INTO var_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","I'isaeri yoorewa inatiamea ahpo chaachapakapua waikao: —¿Ahpo merimerijoarepua naaju, ka'chi iika siimpo tuukaopua ahpo simiyachio? ");
INSERT INTO var_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Nape apoeo simitekapua chaaneka: —Eemea i'wa teere tijoetukamepua weeechi; neeea, te'pa tewekachi o'inia eenakamepua; no'o te'ta ahjaria, ki i'wa weeechi o'inekamepua. ");
INSERT INTO var_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Neeea aamo tatakorichi wahjipamio tuukamenia, ki no'o machisaa no'oo, te'ta aatanakoo, aaata te'ta aamo tatakoriria cheriwiameraopua. Wa'a tiachipao, ki noochi e'enaka aamo cheriwenuresoopua tatakoririao, aamo tatakorie wahjipameri eemea. ");
INSERT INTO var_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Aapoeo ki pahtekapao, chaachapakapua Eesusio: —¿Aatana muuua naaju? Eesusia chaanekapua: —¿Aatia eenechi aamo chaanetania? Aamo chaanekame neeeapa aatanakoo. ");
INSERT INTO var_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Neeea ki ookapi iinueme neeea, aamo wenejime tiiao, nape ki iintomania. Puuu ki kaawe aamo noonowiria no'o wenejime tiiaa, aaata no'o uhjurakamechi o'inia eenamepua, apoe te'ta nane'riamerachi o'inia, pukaepa te'ta pichiwari tiiamepua. ");
INSERT INTO var_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Nape aapoeo kiisi pahteriapua Eesusio, ahpo Noono tewekachi kahtiame nayewaka chiioiopua. ");
INSERT INTO var_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Pukaepa Eesusia kiisi pahteka inamuriopao, ehpeche tuuyekao chaanekapua: —No'oo, Tijoe Tijoetukameo me'yakameo, te'pa apechunasapa kurusichi no'oo, nane'rema eemeapu no'oo, apoe tewekachi eenamekoopua, ki nooe ihsiameko tiameopua no'oo, no'o Noono naewasoche, chaachasiamekopua neeeai. ");
INSERT INTO var_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","No'o uhjurakamea, no'o ahjama yasitoamepua, ki piineri no'o toaka, no'oo ahpo e'ra yorasiopa, ahpo kaawe e'riakamera. ");
INSERT INTO var_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","I'ka wa'a chiiame inamukapao, muuwaeme ahjachi oowe erapakapua. ");
INSERT INTO var_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Waikao Eesusia, pu'ka i'isaeri ahpo tuuya pichikekameo, chaanekapua: —Wa'api te'teretosaa eemea, no'o masitewa penipakao, pichiwa no'o masitera enemapua waikao. ");
INSERT INTO var_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Wa'a te'teretoka epeche epecheche, no'o machipama eemea no'oo, aatanakoo, wa'api aamo te'teretosoo noochi paparakao, senepi aamo tatakoririoio aamo piipatesima neeea tatakoriaio. Wa'a iintoka aamo, puhjesiame enema neeea puhkuchitia chapitiame iinueniameo. ");
INSERT INTO var_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Nape wahjachi Eesusi chiia ki pichikiamea, chaachapakapua: —Nape teemea, ehpe taawechi Aurani tetejimara teemea, ki aawata puhkurachitia chapika mochitiame teemea, seenepioi. ¿Achini tiiachipa taamo puhjemio tuunamua, taamo puhku mochiniachitiao? ");
INSERT INTO var_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Eesusia chaanekapua: —Pichiwa pichiwapua no'o aamo chaaniaa, senepi tatakorika kahtiamea, puhkuchitia kahtipua chapitiame. ");
INSERT INTO var_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Aaata puhkuchitia yasitoame piie ta'pechio, ki tejimarapua wa'a ta'pechio, nape te'ta tejimaraa piie ta'pechio, te'ta taanarakamera puuua. ");
INSERT INTO var_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Nape neee Riosi Taanarao, aamo puhjesoo tatakorio, pichiwa na'soame itipima eemea, pu'ka aamo chapitiamechitia mochikao, tatakori puhkurachitiao. ");
INSERT INTO var_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Nane'riamenia aamoo, Aurani tetejimari ti'tijoetukamekoopua, nape wa'a te'teriamekai eemea, no'o merinarepua, ki pichikiapa eemea, no'oko aamo tuuyao, tewekachi o'inia eenamekoo. ");
INSERT INTO var_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","No'o Noonochi simiyame tetewitenia nayewani neeea, nape aamo noonoa piirechipua, pu'ka aamo noono aamo chaanesia yorasina eemeai. ");
INSERT INTO var_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Aapoeo nehjiakapua waikao: —Ka'i, Auranikamera tetejimari teemea, pukachi puuyakamekopua. Eesusi chaanekapua: —Aurani tetejimari enesaa eemea, Auranichitia mochimii eemea, wa'achi nokaka, Riosi chiia pichikeka, ahjachi paparaka tiame. ");
INSERT INTO var_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Nape eemea, sewina nookapua, no'o merinarepua, no'oo te'ta Riosi pichiwarikamera no'o nayeoio, te'ta apoe no'o Noonochi inamuriaopua. Apoe Aurania ki wa'a tiiame iintomii puuua. ");
INSERT INTO var_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Eemea, aamo piirechi noono ihsia, yoora nokayame eemea. Aapoeo nehjiakapua: —Kiisi noonoeme teemea piirechio, piisi noonoo; piiripi wa'apikamera taamo paamiraa, apoe te'ta Riosiche. ");
INSERT INTO var_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Eesusia wa'a chaachapakopao, chaanekapua: —Apoe paamira Riosio, pichiwa aamo paamira enesoo, no'o nakika uumii eemea waikao, ki sewina Riosichi no'o eenakameko tuuka, ki seenu neeea pu'kao, apoe wa'apikaite neeea. ");
INSERT INTO var_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","¿Iiweta ki no'o pahtiame eeme? Eemea ki pahtiamepua, oowera weeechi tijoe no'o tetewapa, pukaepa ki pichikenariame eemea no'o aatanakoo chiia. ");
INSERT INTO var_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Satanasipua, te'ta aamo paamiraa. Pukaepa pu'ka aamo paamirae nuurenia, nokisinare eemeapu, no'o merinare eemea, aamo paamirao wa'api wa'a e'ropapua, merijerario. Aamo paamiraa, kihta iinuepua pichiwarichi simiyameo, pukaepa ki nakika tetewanipua ihta pichiwario. Ihji wistuaa, apoe wa'apichi ikika machenamepua, ihjia, wistuniame apoe noonorapua. ");
INSERT INTO var_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Pukaepa wa'achi te'te eemea, ki no'o pichikekao, no'o pichiwa chiiao. ");
INSERT INTO var_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","¿Aatana eeme no'o chaanetapua, akana no'o a'chi ihsiriao, na'ara iintorio? ¿Kiisi wistuame enesoo, aatia ki no'o pichiketa eemea? ");
INSERT INTO var_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Riosi ahpo paamiraemea, Riosi yoorenapua. Eemea, ki yoorenapua Riosio, seenukapa aamoo, paamirao. ");
INSERT INTO var_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Isaeri tijoea chaachapakapua: —¿Ki Saamaria tijoe muuua, reemowari yahchame amochio? ");
INSERT INTO var_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Eesusia chaanekapua: —Ka'i, ki reemowari yahchame neeea, no'o Noonoche kaawerumari yachatoame neeea; eemea wa'a chaachapakao, ki no'o yooretiame eemea. ");
INSERT INTO var_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Nape neeea, ki nooe no'o weruma iintani neeea, piirechipua wa'a tiiame no'o iintamea, apoepua, Riosi; apoepua chanimeria, aamo chaachapao pichiwakoo. ");
INSERT INTO var_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Ihji no'o chiiaa, tisiwa pichiwaripua, pichiwachitia uukamea no'o chiiao, ki tetewimapua apochio mukiwario. ");
INSERT INTO var_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Isaeri ti'tijoeria chaachapakapua waikao: —Ehpeo pichiwa erakoame teemea, reemo na'arame yahchamekopua amochio, aamoo chiiopao: “Aaata noochi paparakamea, kiisi mukumeripua.” Nape taamo ehkoriami Aurania, yooma Riosi na'nayewaturaapua tiame, yooma wahjipakamepua wa'asi. ");
INSERT INTO var_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","¿Naakonakosa muuua epeche tiiame ohjoare muuua, ki mukimeriko tuumeriwichio? ¿Ihtanakoo aamo maayamemua? ");
INSERT INTO var_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Eesusia nehjiakapua: —Nooe wa'api no'o nayewasaane no'oo aatanakoo, kihtawichio natemii puuua no'owichioo. Nape no'o Noonokamera wa'a chaanipua, no'oo aatanakoo, aamo wa'api aamo Riosiwa teewa. ");
INSERT INTO var_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Nape pu'kao eemea, kiisioi ahjama te'teriai chaachapani eemea amochio. Neeekamera, ahjama teereka yasitoamepua. Ki no'o Noono ahjama no'o teerewaeme tewasaania, wihtumii neeeai, amochitia. Nape neeea, ahjama teerewaemepua, pu'ka cheesia ikisiame neeea. ");
INSERT INTO var_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Aamo ehkoriami Aurania, tísia kaawe e'rakapua no'o machiyapao. Pichiwa no'o machika puuua, peenia e'raka no'o tetewakapua waikao. ");
INSERT INTO var_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Isaeri ya'yawichia chaachapakapua waikao: —Ki weeka paamuamemua pehjio, ooka weerewa oosa marikioi paamupario, ¿achini tiiachipa tetewako tuunamua Auranio? ");
INSERT INTO var_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Eesusia chaanekapua: —Te'ta pichiwapua no'o chiia, ki ehpesi o'inia kahtiai tiiame neeea; ke'chu Auranio ki tijoeturioi pehjio, ahjakame yasitoame neeea. ");
INSERT INTO var_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Waikao wa'a cheesopa Eesusio ya'yawichia tehte uusa, papaka merimo erakoaipu. Nape Eesusia, ki tetewiniame enepakaopua weerewarao, newikapua wa'ao, wa'a isaeri tiopachio machejenakaopua. ");
INSERT INTO var_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Eesusia isaeri topachi machenasaapa ti'tijoeri mochikachi uumatonioio, aaata ki ma'chiriame tewitiapua wa'ao. Ihjia, wa'api teeka naawakame eneriapua. ");
INSERT INTO var_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Waikao aaata teeme Eesusi ajawariaa, chaanekapua: —Masitari, ¿aatia tiiachipa wa'a tiiare ihjia ki ma'chirekao, ahpo yayawa tatakoririopa wa'a tiiamejuarepua, apoekosaoi tatakorikapa, wa'a tiiare puuua? ");
INSERT INTO var_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Eesusia taamo nehjiakapua cheeka: —Ka'i. Kihta pu'ka wa'a tiiachipua, ahpo yayawa tatakoriawichiooi, apoe wa'apioi tatakoririawichiooi; nape puuua, pukachi ikitiame ne'netepuawichio ikitiamepua Riosi utewarieo, kaawe ihsiamekopua ki ma'chiriame sautekao, Riosi ahpo utewarieopua. ");
INSERT INTO var_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","I'ka kaaweruma yoorachitia nokisimeri teemea, no'o uhjuratiame te'ta nakiyachitia, i'ka weeechi ajatoaapua pehjio. Ki wa'a nokisisaa teeme, ki Riosi tehkiwarakamera nokisima teemea. ");
INSERT INTO var_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Neeea, i'wa wehjoarichi kahtiaa pehjio, neee inisimapua tahjetosikaopua, kaawe pahtemichiopua Riosi kaaweruma tuuyewario. ");
INSERT INTO var_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Wa'a chiiaipua pehjio, wehchi akachupaka wesosaopua, pu'ka tijoe puichi chuhchepakapua. ");
INSERT INTO var_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Wa'a yorasaopua pu'kao, chaanekapua pu'ka ki ma'chiriameo: —Ehpeo waami aamo i'tonurepuapua Siroe tewaniachi neeroi maaniachi pusitepuapua; wa'ao, Uhjuratiame cheeka chaniwame. Waikaopu ki ma'chiriamea wa'a i'totiapa papakosaapua ahpo puichio, ma'chiriame eenarepua Eesusie ahpo uhjuratiachio. ");
INSERT INTO var_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Waikao pu'ka waapi ohjoemea, wahjachi tiameopua machiyamea, ki ma'chiriame tetewikamea, ahpo chaachaparepua pu'kao: —¿Ki ihjipu tijoe, ahkaoi ihkoriwa itaka yayasame? ");
INSERT INTO var_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Wahjachi ookapia chaachapariapua: —Eje'e, puuupua. Nape wahjachi pehjia chaachapariapua: —Ka'i, seenu puuua, nape wa'achi tiamepua tijoe. Nape puuu ki ma'chiriameai ma'chirepakamea, chaanerepua: —Neee puuukaitepua. ");
INSERT INTO var_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Aapoeo waikao, chaachaparepua: —¿Achini iika ma'chiriamemua ehpeo? ");
INSERT INTO var_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Waikao ki ma'chirekamea chaanerepua: —Aaata Eesusi tewaniame iintokapua, no'o kawiyame ma'chirepatekao. Puuua, ahpo a'kae wesosapa we'eo, no'o puichio chuhchesaopua, Siroe neeroi maaniachi no'o uhjurakapua, no'o puichi papakomichioo. Wa'ao pusitesache kawiyame ma'chiriame itipikania. ");
INSERT INTO var_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Waikao aapoeo chaachaparepua pu'kao: —Ehpepe puuua, ¿akana kahtipua ihsisaa? Sautetiamea nehjiarepua: —Iiná. Ki tetewakania ahka akipariachio. ");
INSERT INTO var_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","14","Waikao ookapi puuu iinatukiamea, resipuniame taawechikopa, Eesusi sautioiopua pu'ka ki ma'chireriameo, kiisi kaawe erakoriapua Eesusichio. Waikaopu tijoea, parisero pa'pamuratuamechi u'pariapua, te'ta Moisetaru nuurari ne'nesetoamechi. ");
INSERT INTO var_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Waikao wa'a u'pasaopua, iinatukeriapua tijoeo, achini iikapa ma'chiriamekoopua pu'kao. Waikao ki ma'chireriai sautetiamea, chaaneriapua: —Puuu Eesusi tewaniame no'o puichi wehsara chuhchesaopua, no'o pusitemichio no'o uhjurakapua Siroe neeroi maaniachi. Wa'a iintosache, kawiyame ma'chiriame oiyamenia. ");
INSERT INTO var_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Wa'a chiiopua, ookapi pariseroa ahpo chaachapariapua: —Puuu tijoe wa'a iintokamea, kiisi Riosichi eenamepua wa'a teesoo, kiisi iyoriamepua resipuniame taawechio. Nape wahjachi puuua chaachapariapua: —Nape, ki Riosichi eenamea, ¿iintotariarepua wa'a tiiameo, itapiti ki maaepori tiiameo? Wa'a chaachapaapua ki napati wa'achitia inatame eneriapua, pa'pamuratuamea. ");
INSERT INTO var_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Waikao eenchi iinatukeriapua sauteriameo: —¿Aachin chaani muuua pu'ka tijoe aamo sauteriao? Waikao sautetiamea, nehjiariapua pu'kao: —Neeea, aaata Riosichi eenamekotinia pu'kao. ");
INSERT INTO var_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Waikaopu isaeri pa'pamuratuamea, ki pichikeriaipua pu'ka tijoeo ki ma'chirerio tuuyao, aaata sautetiameoi, ahkasi yayawara paaesapa pichikeriapua. ");
INSERT INTO var_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Ihjia yayawara paaesaopua iinatukeriapua: —¿Pichiwa ki ma'chiriame naawakame ihjipu aamo taanaa? Wa'a teerekame enesoo, ¿ihtana ikirepua?, ma'chiamepua ehpeo. ");
INSERT INTO var_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Waikao yayawaraa nehjiariapua: —Eje'e, te'ta nane'riame teemea, ki ma'chiriame naawakamekopua, ");
INSERT INTO var_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","nape ki nane'rena teemea aaata sauterioo, aatia tiiachipaoi ma'chiriamekopua pu'kao. Apoekamera iinatukepuapua, puichi sautetiamera, apoe nane'reme tiiamepua wa'asi, ki temarikapa wa'asi. Apoe wa'api aamo kaawe nehjiamapua, pu'ka aamo iinatukeriao. ");
INSERT INTO var_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Yayawaraa wa'a cheeka nehjiare puuua, parisero pa'pamuratuameo majayapa, nane'riamekapa pu'kao, Eesusi Riosichi eename sauterio tuusoo, ma'chipapuameko tuutiamekopua, napawikarichiopua wa'asi. ");
INSERT INTO var_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Pukaepa yayawaraa, ahpo taanakamera iinatukenureriapua ohso kaawe. ");
INSERT INTO var_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Waikao parisero pa'pamuratuamea, eenechi paaesao sautetiameo, chaaneriapua: —I'ka aamo ikiriao, Riosikamera kiapuapua cheriwemao, ihji tijoe aamo sautekamea kiisi Riosi nuurari iyoriamekopua, ki nu'uti tatakoriame. ");
INSERT INTO var_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Waikao sautekamea chaanerepua pu'kao: —Pichiwa tatakorikame enesoo aamo chaachapachitiao, neeea ki nane'riamepua pu'kao. Nape i'kache te'ta nane'riamenia, pukerio neeea, kiisi ma'chiriamekainia, ehpeo neeea kawiyame ma'chiriamenia. ");
INSERT INTO var_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Aapoeo eenechi iinatukeriapua pehji: —Nape, ¿ihtana aamo yoorarupua? ¿Achini iintorupua aamo tetewitepuawichioo? ");
INSERT INTO var_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Waikaopu sautetiamea, chaaneriapua pu'kao: —Aamo chaanekasai neeeapa. ¿Ki no'o inamukamekosa eeme? ¿Eenechi aamo chaanejerani eemea naaju? ¿Epeche kaawe nane'renariamea naaju, ahjachi paparanariapa eemeai naaju? ");
INSERT INTO var_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Wa'a chiiopao sautetiameo, pa'pamuratuamea waikao, te'yariapua chaachapaka: —Ihchiasamua pu'kao. Muuukamerapu ahjachi paparamea. Teemea, Moisetarukamera chiia oowe e'riamepua. ");
INSERT INTO var_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Pu'kakamera nane'riame teemea, Riosie nayewetiamekopapua, nape i'ka tijoeo, kiisikoi kihta nane'riame teemea, ahka machenakameo. ");
INSERT INTO var_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Waikao tijoe sautetiamea chaaneriapua pu'kao: —¡Naakonakosa! ¡Ki pahtiame eemea akana o'inia eenamekoopua Eesusio, no'o puichio sautékame? ");
INSERT INTO var_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Aaataai tatakoriamea, ka'chi iika wa'a iintomeriipua, ki Riosi utewarieme enesaa. Wa'a teesoo puuu no'o sautekamea, kiisi ihta tatakoriemera puuua. Apoekamera puuu Eesusia wa'a teesoo, Riosi utewarae no'o sautekamea, puuua te'ta tewekachi No'no utewarira iinuemepua, Riosio te'ta ahpo utewario, ki oowe aaata tijoe ki'yamekoopua. ");
INSERT INTO var_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Aaata oowera tijoea, i'ka weee yasipariachisi o'inia, seenepioi ki inamuamepua, aaata sautiameopua, ki ma'chiriameo. ");
INSERT INTO var_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Wa'a tiachipao, ihji tijoea ki Riosichi eenakame enesaa, ka'chi iika iintomii puuuapu, ihtaoi i'kaka tiiame iintowao. Wa'a teesoo ma'chiame apoepua, Riosichi eename. ");
INSERT INTO var_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Waikao chaachapariapua pa'pamuratuamea: —¿Wa'a taamo chaaniame muuua? ¿Taamo masitiame muuua, tísia tatakorie pochikame naawakameai? Waikao ki ma'chiriame sautetiamea, waika o'inia u'yeretupua reesiserio, i'isaeri napawikarichi pakiniameopua. ");
INSERT INTO var_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Waikao Eesusia, pu'ka ahpo sauteria wa'a napawikarichi wa'a i'isaeri napawikarichio, ki reesiseniame inamukapaopua pakimichioo, i'yasitiapua pu'kao. Tewisaopua iinatuketiapua Eesusieo: —¿Paparame muuuapa, Riosi Tijoetukamechio? ");
INSERT INTO var_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Sautetiamea cheekapua: —¿Pukachi paparatare neeea, ki machiyameaipua pehjio? No'o tetewitepuapua pu'kao, no'o ahjachi paparamichioo. ");
INSERT INTO var_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Eesusia chaanekapua waikao: —Tetewani muuuapa pu'kao, neee puuua apoea aamo ahjama nayewame. ");
INSERT INTO var_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Waikao sautetiame ki ma'chiriamea, chaanekapua Eesusio: —¡Naakona! ¡Muuupua? ¡Eje'e, wa'a teesoo, amochi paparame neeea! ");
INSERT INTO var_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Eesusia waikao, yooma ahjama ajaka inamumichioo, cheeka nayewekapua pu'kao: —Neeea i'ka wehjoarichi eenakamenia, ti'tijoe ooweru tiame ahpo iikachi pahtetemia, aachin te'tereka mochikamekopua ahpo iikachio, Riosichi ahpo te'terewa, pukachi kaawe te'terewao ki kaawe te'terewaoi. Puuu ki ka'karumachi nokayamea, ki ma'chiriameka te'teriame puuua, puuua ki kaawe te'teriamepua Riosichio. Pu'kawichio eenakame neeea, ti'tijoe ooweru tiame ki ma'chiriameka te'teriameopua apochio, puhjemia pu'ka ki ma'chiriameka te'teriao, noochi e'enasoo ahpo tatakoriria, cheriwejerakao. Nape puuu ki ma'chiriameka te'teriameopua apochio, ki tetewamekapa puuua, ahpo ki kaawe te'teriaopua Riosichio, wa'api teeka itipimeriipua ahpo ki ma'chiriachitia. ");
INSERT INTO var_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Wa'a chiiopa Eesusio, ookapi pa'parisero wa'a waapi ajaka inamukamea, chaachapakapua Eesusio: —¡Naakona, ki mamachiriamekosa teemea? ");
INSERT INTO var_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Eesusia wa'a chaachapopao, chaanekapua pu'kao: —Pichiwa ki mamachiriame maaeria enesaa eemea, aamo Riosichi ki kaawe te'terewa erakokao, noochi e'enamiipua aamo cheriwepuawichioo. Neeea waikao aamo cheriwemiipua aamo tatakoriwao. Nape eeme aamo mamachiriame erakoamea ki ka'karumachi te'teriaai, wa'api teereka itipimeri eemea ki mamachiriamechitia, aamo kiisi kaawe noonowiriachitia Riosichio, apoe Riosi tetewachio. ");
INSERT INTO var_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Wa'a cheeka kajusaapua Eesusia, ahpo simitewa masitewachiopua, i'ka masitekapua: —Pichiwari chaaninia, ki yeetapuwachiami pakiyamea po'wa ko'rechio, ichikoameche puuua; ");
INSERT INTO var_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","nape yeetapuwachiami pakiyamea, apoe tepuyakamerapua po'wao. ");
INSERT INTO var_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","I'ka tepuyameo, wahjonenapua yeetapukiamea waikao pakisaapao tepuyamea, nayewenapua po'wao ma'chi puuyanamia, yooma pipiripichi teewaka, po'waai i'ka iiyenao, machika inamuamepua. ");
INSERT INTO var_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Yooma puuyanasaapa ahpo tepuyao, pahcha weritoamepua ahpo na'naritopuawichioo, tepuyamea. Waikao po'waa, na'naritoamepua pu'kao, machika inamuamekapapua ahpo yeetotoameopua. ");
INSERT INTO var_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Aaata seenu enesoo, ki na'naritomapua pu'kao, ohsotia ujumamapua pukachio, ki machiyapa pu'ka seenu tijoeopua, iiyenao. ");
INSERT INTO var_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","I'ka wa'a tiame nayewekai Eesusia pu'ka pa'parisero pa'pamiratuameo, nape puuu pa'pariseroa, kiisi pahteka inamukapua Eesusio, ahpo apochi paparapuame nayeweka chiioiopua pu'kao. ");
INSERT INTO var_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Waikao wa'a cheesaapa Eesusia, simitekaopua pehjio, cheekapua yooma inamuachio: —Weruma inataka inamumitiamua i'kao. Neeepua yeetapuraa, po'wa ko'rerachi muiniachio. ");
INSERT INTO var_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Yooma no'o ke'chu eenoi e'enakamea, ahpokamera na'naritomichio ti'tijoeri yeetokamea, wi'wisikuame puuua, ichikoamepua tiame. Nape aaata no'o na'naritokamea, no'o puhku po'wakameka te'teriamepua, puuua, ki e'waka inamukamepua pu'ka wi'wisikuame chaachapao. ");
INSERT INTO var_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Neeepua pu'ka ko'rerachi muiniamea, wa'a pakikamea no'oe tepupuame puuua, tísia kaawe neesetopuamepua no'oeo, newipuatepuame puuua tiaméo. Ahkaoi no'o ohjotioioopua tepuka, kihta tooremumeri puuua. ");
INSERT INTO var_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","’Ichikowaria, na'ara iintoka ichikoemia e'enamepua, merimia, kajuka na'atamia; nape neeea, ahjamichio eenakamepua, no'o korewachi enepameopua, te'ta ahjario, paarasateka kiamania. ");
INSERT INTO var_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Neeea, kaaweruma tepuyamerania. Kaaweruma tepuyamea, ahpo mukiwachisi nehpupamepua ahpo po'wa tepuyao. ");
INSERT INTO var_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Oowera natetewachi tepuyamea, ki ahpo iinuwakopa po'wao, ki kaawe tepuyamepua pu'kao, itapiti oorie naaepatioopua ahpo tepuyao, piineri toisa u'mamepua po'wa tepuyao. Waikao ooria, wa'a eenaka ko'koniamepua po'wao, chi'chiripatiamepua pu'kao. ");
INSERT INTO var_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Oowera tekipanaka tepuyamea, toisa uujumamepua pu'ka po'wa ahpo tepuyao, ka'chi e'rakapua wewekatekai, ki ahpo puhkukopua pu'kao. ");
INSERT INTO var_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","’Neeea, kaaweruma tepuyamerakamerania, no'o ijinuwakopa pu'kao, ahjama tiiame neeea, aapoeai wa'achitia tiiamepua noochio. ");
INSERT INTO var_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Neeea te'ta no'o Noonoo, wa'achitia no'o machiyao, neeeai wa'achitia machiyamepua. Neeea, no'o po'wa tepuyao, wa'achitia no'oe machiyachitia pu'kao, no'o po'wa tepuyaai wa'achitia no'o machiyamepua tiame. ");
INSERT INTO var_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Neeea pirenachiamio, iinuenia tiame po'wa no'o tepuyao, ki i'ka ko'rechi mochikame. I'noramerinia pu'kaoi, pirenapi ko'rechi iintapamiapa, piiripi wa'api enepuawichiopua tepuyameo. Aapoeopua no'o e'wekao, no'o na'naritomapua teetoachio. Wa'atiao, piiripi wa'api enemapu tepuyameraa, neeeche, ki aaata piirechi tepuyame. ");
INSERT INTO var_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","’Apoe no'o Noonoa no'o nakiyamepua. No'o Noonoa i'kawichio no'o nakiyamepua: no'o ahjario no'o po'wachitia tepuyawichio pejana nehjimichiopua, wa'a iintosaapua noochio, eenechi no'o ahjatemiapa. ");
INSERT INTO var_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","No'o ahjario aaataai ki no'o u'yemepua, nooe wa'api no'o kaawe e'rachi ki'yamepua pu'kao. Neeea iinuemenia utewario noochio, no'o ahjario wahjiparichi uhjurakaio, eenechi noochi enatemia no'o ahjario. Wa'a tiiameo, no'o Noonoe yahchetiamenia pu'kao. ");
INSERT INTO var_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Waikao eenechi ki napati wa'achitia erakoka inamukapa Eesusi chiiao, o'inekapua ahpo poanatukao. ");
INSERT INTO var_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Muuwaemea chaachapakapua: —Rooroikamepu ihjia chiia, itapiti na'arari yahchamepua. Nape rooroikame enesaa ihjia, ¿aatia keepuna eemea pu'kao? ");
INSERT INTO var_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Wahjachia chaachapakapua: —Nape ihjia, kiisi na'arari yahchameka chiiamepua. ¿Naakonakosa na'arari yahchameai sautetapua ki ma'chiriameo? ");
INSERT INTO var_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Seenepi simikameo Eerusarenio tuuroi taawechiamio, i'isaeri ti'tijoeria pahkotakapua, ahpo weemera tiopawichio pahkotewa. ");
INSERT INTO var_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Waikao Eesusio wa'a Saromoni Arakokari teeriami oiyoiopua, ");
INSERT INTO var_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","i'isaeri ti'tijoeri pa'pamuratuamea, taamo noorepakao Eesusi iinatukekapua: —¿Achinatiosi wa'a taamo teeremamua, ki aamo aatanako taamo nane'retekao? Amoe enesaa Riosie Weratiameo, ma'chiame taamo chaanepuapua. ");
INSERT INTO var_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Eesusia nehjiakapua: —Aamosa chaanekasai neeeapa, ki pichikena eemea. Yooma puuu no'o Noono utewarie no'o yoora, no'o nayewanipua, aatanakoo; ");
INSERT INTO var_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Nape eemea, ki no'o pichikenapua, wa'a te'te eemeapu, ki no'o tepuyakapa. ");
INSERT INTO var_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","No'o ijinuwa no'o puhku po'wachitiaa, no'o machika inamuame puuua. Neeeaio, te'ta machiyamepua pu'kao, wa'a te'teriamekapaopua, aapoeo kihta seeweka no'o na'naritoamepua. ");
INSERT INTO var_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Neeea ki'yamepua pu'kao, ahjari ki wahjiameo, ki seena aampasi wahjipaniameo, ki seenampasi wahjipameripua, puuua te'ta wahjiparichio, kiisi wahjipameripua; aaataai no'o seepurawaa, kiisi no'o u'yemeripua pu'kao. ");
INSERT INTO var_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","No'o Noonoa, yooma no'o na'naritoame ki'yakamepua. Puuu apoeo, epeche weruma tiiamepua ki aaatachitia. Pukaepa aaataai ka'chi iika u'yemetepua ahpo sekachio, no'o ki'yaopua pu'kao. ");
INSERT INTO var_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","No'o Noonoa, neeea tiameo, piiripikaitepua. ");
INSERT INTO var_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Waikao, pa'pariseo pa'pamuratuamea, eenechi pasipumo o'rariaipua Eesusio, ");
INSERT INTO var_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","nape Eesusia chaanekapua: —Ki ookapi itapiti ka'karuma aamo tetewitekame neeea, no'o Noonoepua. ¿Aachin tiiamera pu'ka kaaweruma itapiti aamo teteweteriawichio, no'o pasipunariame eemea? ");
INSERT INTO var_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Waikao i'isaeri pa'pamuratuamea, chaanekapua Eesusio: —Ka'karuma yoratiamewichioopua ka'ii, aamoo, Riosi aamo teewamekopapua, taamochitia tijoekaio, pu'kawichio aamo pasipunariame teemea. ");
INSERT INTO var_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Waikao pa'pamuratuame wa'a chaachapakopao, Eesusia chaanekapua pu'kao: —¡Naakonakosa! ¡Naakonakosa ki pahtiame eemea, wa'a chiiamekopua Riosio Ehkoriami Iyoterichio? Puuua, eee cheeriaipua ahpo na'nayewatura nayewakao: “Eemea, riosipua, no'o Riosio, tatanarapakapa.” ");
INSERT INTO var_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Nane'riame teemea Ehkoriami Iyoterichi Riosi cheeriaa, pichiwakopua pu'kao, Riosio ahpo chiiao kiisi wihtuamekopa, teemea pu'kao kihta ka'itame tiiamekopua pu'kao. Pu'ka ahpo na'nayewaturao riosi teewariaopua Riosia, te'ta pichiwapua, pu'ka na'nayewaturao ahpo chiia chu'waremichiopua ti'tijoerichi tu'tuyesikao. ");
INSERT INTO var_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Weh, Riosi iintorioo, no'o ahpo chiia ti'tijoeri nayewatumichio weerakamekoipua, ¿achini iikai nekakoame eemea noochio, no'oo Riosie Tijoe Tijoetukameko tuuyoo? ");
INSERT INTO var_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","No'o yoorao, ki Riosi ihsia yoorame enesoo, ki no'o pichikepuapua no'oo, no'o Riosichi eenameko tuuyao. ");
INSERT INTO var_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Nape no'o yoorao, Riosiche yorame tiiameche enesoo, pu'kakamera pichikepuapua, puuukopua no'o ma'chitameo, te'ta no'oo aatanakoo. ");
INSERT INTO var_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Nape isaeri pa'pamuratuamea, ki wa'a teeka pahtekapa puuua, eenechi pasipumo orapakapua Eesusio, nape Eesusia newikapua wa'ao. ");
INSERT INTO var_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Wa'a o'iniaopua waikao, paonamina Oorani akichi e'enatiapua, Waani Paatori yaajatoriachi, ti'tijoe paatoka ooweru tiame. Wa'a mochitiapua waikao paikapi taawechi. ");
INSERT INTO var_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Wa'a mochinioio ki ookapi ti'tijoe ooweru tiame, no'o Paamira Eesusi machimia. Ihji wa'a e'enakamea, Eesusi masitia keepusaapua, ahpoo chaachapakapua: —Aa, wa'a teeso Waani Paatori nayewariaa i'ka tijoechi simiyameo, Waania kiisi yoorakaipua itapiti peenia ihsiwao, te'ta pichiwa cheeriamepua. ");
INSERT INTO var_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Wa'a erapakaopua, muuwaeme Eesusichi paparakapua, Eesusi ihsiachi masiteka. ");
INSERT INTO var_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Wa'a mochioiopua pehjio, wa'a asikapua aaata kooria Wetania mochiwachi o'inia eename. Puuua Eesusio chaanekapua Wetania mochiwachio, tísia kokorepariata aaata Rasaro tewaniame. Ihji Rasaroa, ooka pipiniemekapua, piiripia Maaria tewaniame, piirea Marata tewaniame. ");
INSERT INTO var_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Ihji Maariaa, Eesusi tarachi sewajuya to'wepakamekapua, ahpo kupae pi'weka, wakipatekame. ");
INSERT INTO var_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Ihji ahpo pipiniemea, Eesusi paaenurekapua, ahpo pa'chi Rasaroo kokoriopa. Puuua ahpo uhjurawao, chaanenureriapua Eesusio: —Paamira, aamo kaawe e'riaa, kokoriapua. ");
INSERT INTO var_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Eesusia, wa'a tiiame inamukapao, cheekapua: —Ihji tijoe kokorewaa, kaawerumachi kajumiitepua. Ohso kaawe, Riosi ihsiwa tetewipuawichio iikamepua, aatanakoopu ahpo Tijoetuteriao, pukachi yasitoamekopua Riosia, apoeo. ");
INSERT INTO var_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Naatiopua, tísia nakiyame enerepua tiame, Maariao, Maratao, Rasaroopua tiame. ");
INSERT INTO var_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Wa'a tiiooi Eesusia, ooka taawe itipikapua pehjio, ahpo kahtiachio. ");
INSERT INTO var_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Neipa i'kaopua, ooka taawe puuyesaopua, chaanekapua taamoo ahpo masiterao: —Ajasika. Siimpapuapu Uurea weeechi eenechi. ");
INSERT INTO var_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Waikao teeme Eesusi masitewaraa, chaanekapua Eesusio: —Nape isaeri ya'yawichieo, iiweta aamo merinarioi wa'ao, ¿wa'a siminaremua eenechi? ");
INSERT INTO var_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Nape Eesusia taamo nehjiakapua: —Pe'yachi wa'a teeremapua noochio. Wa'atioi neeea tekipanamerichepua. ¿Tepekumanapu taawea? Neeea ti'tijoeri tukapachi ohjoameo, Riosi kaaweruma tuuyewarie, tahjepamerichenia. Pu'ka tahjewarichi oiyamea, kihtae motochimapua. ");
INSERT INTO var_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Nape ki apochi i'toamea Riosi kaaweruma tuuyewari tahjerao, tukapachi oiyamepua, pukaepa motochimapua. ");
INSERT INTO var_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Wa'a cheesapa Eesusia taamo chaanekapua: —Taamo kaawe uuya tijoea, kohchiamepua, nape ehjepa wa'a ajasitioopua, pusatemania pu'kao. ");
INSERT INTO var_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Waikao teeme masiteraa, chaachapakapua Eesusio: —Wa'a teesoo, kohchiame enesaa, apoe wa'api pusamiitepua. ");
INSERT INTO var_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Nape Eesusia Rasaroo, mukukameko tuuka cheeriapua, ki oowera kohchiamekopua resipuka. Nape teemea ki pahtiamekapao, oowera kohchiame maaekapua. ");
INSERT INTO var_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Waikao Eesusia, eenechi taamo chaanekao, ma'chiame taamo tuuyekapua: —Rasaroa mukukame puuua. ");
INSERT INTO var_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Kaawechupena ki wa'a yasarenia wa'a ikinioio, pu'ka wa'a no'o iintomeri tetewakao, epeche kaawe teeremerikopua aamowichioo, aamo no'o te'ta pichiwataopua, no'oo te'ta aatanakoo. Nahpe naaju, siimpaka ne'netaria Rasaro ikiriao. ");
INSERT INTO var_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Waikao Toomasia, taamo wahjachi masiterao, chaanekapua: —Nahpesa naaju teemeai. Pe'yachi Eesusi ahjama ko'itaria teemeai. ");
INSERT INTO var_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Eesusi ahjama Wetania ajasitioiopua, Eesusia tuuyetiapua, naao taawe i'toamekopua Rasaro mukukame katewetiachio. ");
INSERT INTO var_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Wetaníao, waapikopa Eerusarenio, piie keenako ku'itapi simiwachi, ");
INSERT INTO var_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","muuwaeme e'enariapua wa'ao, Maratao, Maariaopua tiameo, kaawe erapatemia yuuwesiao, ahpo pa'chi mukuria yuuwesiwaopua. ");
INSERT INTO var_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Marataa Eesusio, wahka ihto tuuwame inamukapao, machenariapua natepamia. Maaria ahpo kariwachi itipiriapua pehjio. ");
INSERT INTO var_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Marataa natepasao, chaanekapua Eesusio: —Paamira, i'wa aamo yasisoo, no'o pa'chia ki kiterepamiipua. ");
INSERT INTO var_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Nape wa'atioipua aamoo, nane'riamenia aamoo, ihtaoi itaka aamo Noono Riosi nayewasoo, aamo inamumerikopua, ahkasioi ki maaepuame tiiameoi. ");
INSERT INTO var_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Eesusi chaanekapua: —Aamo pa'chia eenechio, ahjamitepua. ");
INSERT INTO var_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Marata chaanekapua: —Nane'renania ahjamioo, nape kiteremiachioopua wa'asi taaweo, yooma wahjipakame ahjapuniachiopua. ");
INSERT INTO var_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Eesusia chaanekapua waikao: —Neee apoe puuua, eenechi ahjaniame ikitiamea. Neeepua tiameo, ahjari aaata yahchiameraa; noochi paparakamea, mukukaio, eenechi ahjamapua. ");
INSERT INTO var_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Noochi paparamea, ki mukuyai pehji no'o eenoi kiteremiachi wa'asi taaweo, ki mukimapua seenepioi. ¿Wa'a tiiame pichikiamemua Marata? ");
INSERT INTO var_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Marata chaanekapua: —Eje'e, wa'a tiiame e'ramenia Paamira. Neeea aamoo, Riosie weratiameko e'riamenia aamoo, apoe Riosie Weratiame, apoe Riosi Taanarakopua tiame, ehkoriami o'iniao, enameriko tuutiame. ");
INSERT INTO var_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Wa'a cheesapa Marataa, pe'ku eenakapua ta'pechi, ahpo piini Maaria tuuyemia. Marataa, nakachi chukipakao chaaneriapua: —Eenariapu Paamiraapa, aamo paayapu waami. ");
INSERT INTO var_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","I'ka inamukaopua, ikanati werisika eenariapua natepamia. ");
INSERT INTO var_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Eesusia, ki pakiriai pehji mochiwachiopu. Ma'chi yasariai puuuapu Marata natepariachi. ");
INSERT INTO var_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Ahjama mochika kaawe eratiamea, wa'ami akipakopa na'naritoriapu, mukukatewetiachi simiyame maaeka, naarachemia. ");
INSERT INTO var_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Maariaa, Eesusi kahtiachi asisaopua, chopokorieka weripakao chaanekapua: —Paamira, i'wa aamo yasisoo, ki kiterepamii no'o pa'chia. ");
INSERT INTO var_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Eesusia, Maaria naarame tetewapaopua, ahjama e'enakametiameo, Marata tiame, tahpitika erapaka puaipu, yuuwesipaka. ");
INSERT INTO var_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Waikao cheekapua: —¿Akana kateweka eeme? Aapoeo chaachapakapua: —Nahpeo Paamira, ne'nepuapu. ");
INSERT INTO var_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Ajasitioopa Eesusia, nanarakapua. ");
INSERT INTO var_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Waikao nanarakame tetewakapao, chaachapakapua: —¡Ki teesa nakiyai teeeriai, puuuai! ");
INSERT INTO var_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Wahjachia chaachaparepu: —Ihji ki ma'chiriame sautekamea, ¿ki itapiti iintome teeeriamarepua, ki mukimichioo? ");
INSERT INTO var_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Waikao Eesusia ajasitioopua Rasaro mukukatewetiachio, eenechi tahpitika erapakapua apochio. Rasaro tekiriatiachio, nu'uti teesotatiachikapua, tehte rahpename chihturamee to'petiame. ");
INSERT INTO var_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Eesusia waikao aaata cheekapua: —Ikichanaopua pu'ka tehte, se'wi weerao. Waikao Marata kiterepakame piiniraa, chaanekapua Eesusio: —Nape Paamira, iiyanakame ujuremapu puuua, naao taawe i'toamekapa wa'asi, i'ka ikiriachiopua. ");
INSERT INTO var_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Waikao Eesusia chaanekapua Maratao: —¿Ki aamo chaanekosane, aamoo noochi ahjachi erasoo, Riosio ki nu'unti iintomerikopua, itapiti aamo tetewimerio? ");
INSERT INTO var_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Waikao, ikicha werapatiapu tehtea. Wa'a ikitioopa Eesusia, te'pa tewekachi ne'nepakao chaachakapua: —Cheriwema No'noo, aamoo no'o inamuriawichioo. ");
INSERT INTO var_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Nane'riameai neeea aamoo, senepi aamo no'o nayewesoo no'o inamuamekoo. Nape ehpeo neeea aamoo, yooma inamumichioo, weeru nayewaka aamo chaaniamenia, pu'ka aapoeopua tiameo, nane'remichiopua no'oo, te'ta amoe no'o uhjuratiamekopua. ");
INSERT INTO var_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Wa'a cheesapa weeru sisinakaopua, cheeka te'ta Rasaro tekitiachi ne'nepakao: —¡Rasaróoo, machenasa wa'áaa! ");
INSERT INTO var_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Waikao mukuriamea machenakapua, yooma weerewa wisasopurae wipirika puritiame tarachisi o'inia na'pa toonorama, na'pa seekarama ahkasi moochisi nanarima. Eesusi chaanekapua waikao, wa'a ajakameo: —¡Puhjeke wipipuriráo, oisimichioo! ");
INSERT INTO var_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Muuwaeme isaeri ti'tijoeri, Maaria ahjama e'enakamea, tetewakapua wa'a iintokopao, Eesusichi paparakapua. ");
INSERT INTO var_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Nape ookapi puuu i'isaeria ki Eesusichi paparakamea, pariserochi e'enakao, yooma tuuyeriapua pu'kao, Eesusi iintoriao. ");
INSERT INTO var_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Waikao neeseriosi pa'pamiratuamea, yooma ahpo na'poasaopua parisero ahjamao, chaachapariapua: —¿Achini yorata teeme i'ka tijoeo? Ki ookapi ihsina puuuapa, itapiti ki maaenari yoorakaopua, ");
INSERT INTO var_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","wa'atia taamo toisoopua, yooma ti'tijoeria ahjachi pichikemerapua. Wa'a ijikisoo, tamochi e'enaka kajuka pihtunamerapua rooma tijoea, taamo iyoriachioi tiopao, wehchi yachamerapua, pihtunaka. ");
INSERT INTO var_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Nape piiripi wa'api puuua, Kaija tewaniamea pu'ka taawechiamio, te'ta ne'neseriosi paamiratuameraa, cheeriapua: ");
INSERT INTO var_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","—¿Kiisiki pahtena eemea? ¿Ki nane'renakosa eemea, ehpeche kaaweko, piiripi wa'api mukisaa yoomawichio, ki yooma mochiwari wahjipamichioopua? ");
INSERT INTO var_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Nape ki ahpo e'rachi wa'a cheekapua, Riosie eratetiapa wa'a cheekamepua, pu'ka paaumparichio te'ta neeseriosi paamiratuaio. Pukaepa wa'a tiame cheeriai Kaija. Riosia wa'a chaniteriapua Kaipao, taamoo pahtemichiopua, Eesusio, ti'tijoeri pejanaka mukimerikopua, pu'ka tatakoriria kokosapuamewichioo, ");
INSERT INTO var_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","ki i'isaeriwichioche mukimerikopua, yooma wehjoarichiami mochikamewichioopua tiamé, yooma Riosi tatanarachitia te'teriameo, pirenapi wa'api pirenaturichi, pirenatupuaichio. ");
INSERT INTO var_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Nape ki wa'a tiame pahteriai puuu pa'pariseo napawikame wa'ao, pu'ka taawechi o'inia wa'ana, nanapawiriapua a'chi teeka ahpo merimiao, chaachapamia. ");
INSERT INTO var_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Pukaepa Eesusia, ki te'ta ma'chiame oiyapua, isaeri mochikachiamiopua, mehka wa'a o'inia siimpasao Raaini mochiwachi e'enatiapua, waapi wakiwechiamio. Wa'a itipika Eesusia waikaopua, taamo ahjamaopua masiterao. ");
INSERT INTO var_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Asiyachikapua isaeri pahkotaopua, Semejenato pahkoo, muuwaeme ti'tijoeri po'poanami mochikamea, e'enariamekaipua Eerusarenio, ke'chu pahkokoikopua, ahpo Riosichi piipatepuawichioopua, wa'a nokiwamechikopua wa'ao. ");
INSERT INTO var_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Waikao pahkochi e'enakamea, ahkachiami tiopachiami aajatoka chaachapariapua ahpoo: —Ihtana erakona eemea, ¿enameriare Eesusia i'wa pahkochio, ki enatarekosaoipua? ");
INSERT INTO var_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Wa'a nooka ahpo chaachaparia ti'tijoeria, te'ta neeseriosi pa'pamiratuamea, parisero pa'pamiratuame tiamea, nuurarioipa puuuapu, ahpo tuutiamichio aaataeo Eesusio tetewisoo, chapimichiopua pu'kao. ");
INSERT INTO var_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Puhsani taawechi toioio pahko asimioio, Eesusia Wetania eenakapua eenechi, Rasaro ohjirachi, ahpoo, ahjateria ta'perachi. ");
INSERT INTO var_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Wa'ao kooame neteketiapua, aari koi'wame Eesusi kaawe e'rewawichioo. Marataa, oiyapua ajawaka kooame, Rasaroa kahtiapua koaka Eesusi ahjama meesachi. ");
INSERT INTO var_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Maariaa Eesusio, naasipa kiiro tísia nateyame uusapa peeniajurao, apoche narato sewajuyamee netetiame, tarachi to'wekaopua, ahpo kupae pi'wekapua wakipateka. Ihji peeniakame e'oniraa, yoomachi karichi mu'ikapua. ");
INSERT INTO var_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Nape Uurasi Ihkariótea, piiripi Eesusi wa'api masiteraa, noriwi iintomeria pu'kao, cheekapua: ");
INSERT INTO var_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","—¿Achini iikai ki nehjiretupua ohso kaawe, paika siento taawechi yowiwamechi, ahjae ku'ipuaichioo, kihta iinuwaeme ko'kometiwichio? ");
INSERT INTO var_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Uurasia, ki tesiwa te'tiame cheriwiai cheeriapuapu, ichikoapa cheeriapua toomi, ahpo neesetoaopua, katewetenia. ");
INSERT INTO var_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Eesusia chiiapua: —Ka'te a'chi chaane pu'kao. Tooa pu'kao, enemapu no'o kiterepamichio, kateweriai i'ka peeniajurao. ");
INSERT INTO var_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Tesiwa erakoamea, wa'api iintumerapua, nape no'oo, ki yooma taawechi amochi iinuemera eemea. ");
INSERT INTO var_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Isaeri ti'tijoeri muuwaemea, nane'rekapao Eesusio, Rasaro ta'perachi kahtiameko, muuwaeme e'enakapua wa'ao, nape ki Eesusiche ne'nemia, Rasaro ne'nemia tiame, Eesusio pu'kao, ahjateria eenechi. ");
INSERT INTO var_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Pu'ka ahjateretiawichio, neeseriosi pa'pamiratuamea, i'yasikapua tiame a'chi teeka ahpo merimiaopua Rasaroo, ");
INSERT INTO var_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Rasaro ikitiamewichioopua, muuwaeme Eesusikamera na'naritokopa, ahpo neeseriosi pa'pamuratuame masitiaopua, toaka. ");
INSERT INTO var_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Pu'ka meereo, Eesusi Rasaro oijenateria chaachapaniamea, ahkasi Eerusareni yooma mochiwachi nane'reretiapua, mehtakao. Pukaepa muuwaeme Eerusareni pahkochi e'enakamea, Eesusi Eerusareni asiyame inamukapaopua, ");
INSERT INTO var_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","tahku saawara tehpunasaopua, kuhsi saawaeme tiame, ma'chi muirachi puuyeriapua Eesusi natepamia. Eesusi natepasaapua, ahjama nokisikaopua, weeru siinakosiapua chaachapakao: —¡Taamo Riosiii! ¡Taamo Riosiii! ¡Taamo newipatesaaa! ¡Taamo newipatesaaa! ¡Kaawechupena Riosichi o'inia eenamemua! ¡Kaawechupena yawichi enemerimua i'isaerichio ti'tijoechi! ");
INSERT INTO var_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Eesusia uuru taamo i'yakeriachi yasitoaa, Ehkoriami Iyoterichi chiia ikiriapua, pichiwa wa'a tiiame ikipua, machenariapua. Ehkoriami Riosi Iyoteria, eee cheeriaipua: ");
INSERT INTO var_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Ka'te majawemua, Siioni Riosi mochiwaria. Nee, wa'a ihtonapa aamo te'ta yawichia, uuru taanarachi yasitoka. ");
INSERT INTO var_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","I'ka wa'a tiame uuruchi ihtotiameo, pukeri simiyachio, ki pahteriai teemea, nape neipa taamo Paamira Eesusi no'rasoopua tewekachio, waikapa inatepatiapua, Ehkoriami Iyoterio pu'ka naewaka cheerioopua. ");
INSERT INTO var_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Puuu muuwaeme ti'tijoe ooweru tiamea, Eesusie Rasaro oijenatetiame tetewikamea, Eerusareni nonorasaapua, yooma tuuyeriaipua Eesusi iintoria ahpo tetewariapua, Rasaro oijenatekaopua. ");
INSERT INTO var_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Wa'a tiame inamukapaopua Eesusi iintoriao, pahteriapua waikao Eesusio te'ta weruma tiiamekopapua pu'kao. Pukaepa muuwaeme natepamia puuyakamepua. ");
INSERT INTO var_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Pa'parisero pa'pamiratuamea, wa'a Wetania nonorakame inamukapaopua, Eesusi Rasaro oijenateriao, chaachapariapua ahpoo: —Nee, yoomahka ti'tijoea, ooweruapua tiameo, Eesusikamera pu'sereka tetewamepua. Kihta yorame te'teriame teemeapa, ti'tijoeri teewetepuameopua, i'ka Eesusichi paparaniameo. ");
INSERT INTO var_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Eerusareni pahkochi e'enakamechio, ri'rieko ti'tijoeri tiame e'enariapua ookapi. ");
INSERT INTO var_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Ihjia, Eeripe piiripi Eesusi ajawaria naaepariapua, We'saira ohjoeme Arirea weeechi. Puuu ri'riekoa chaanekapua Eeripeo: —Paamira, machinariai teemea, Eesusio. ");
INSERT INTO var_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Waikao Eeripea, Anteresi tuuyesaopua, pirena e'enaka tuuyekapua Eesusio. ");
INSERT INTO var_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Waikao Eesusia chaanekapua: —Kaawepua, e'enanuremitiapua pu'kao, keepumichiopua no'o ti'tijoeri nayewiao. Waikao Eesusia yooma ti'tijoeri nayewekao, o'inekapua cheekao: —Asikame neeeapa, tetewipuawichioo no'o te'ta weruma iintomiao. Pukaepa ehpeo neeea yooma aamoo, no'o ikimiachi simiyame nayewemania, yooma no'o ku'we ikimeria, no'o te'ta aatanakooko ma'chitameripua. ");
INSERT INTO var_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Ihji no'o ikimia chiia, kiisi wehchi wichimeripua. Neeea no'o ikimiaa, piiripi tiiriko pahchiraka teeremeripua. Ki mukusaa puuu tiiriko pahchiraa, piiripi wa'api teereka itipimeripua, ki muuweka; nape echitia mukisaapua wehtereo, ki ookapi muuwemeripua, taakekao. ");
INSERT INTO var_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Aaata i'ka weeechi ahjari epeche te'ta nateyamechitia tetewamea, ki Riosikamera ahjari ahpo kianariachitiao, wekatemeripua pu'ka te'ta ahjari Riosie ahpo kianarewaopua. Nape ki epeche nateyame tetewamea i'ka wehjoari ahjario, ki pu'ka ahjarichitia ahpo kianareniao Riosie, kiapuamepua pu'ka te'ta ahjario Riosie ahpo kianarewaopua, pu'ka te'ta ahjari ki wahjiamesi ahjaniameopua. ");
INSERT INTO var_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Aaata piire no'o yorakeka yasinariamea, noochi enamitiapua; ahkaoi no'o kahtioi no'o yorakeka yasitoameo, no'o Noonoa, kaawe no'o ihsikiame tetewimapua pu'kao. ");
INSERT INTO var_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","’Ehpe neeea i'ka no'o ikimiao, ki nu'uti tahpitika erapaninia. Nape ¿ihtana chanitania i'kao no'o ikimiao: “No'o Noonoo, no'o apechunamitia i'ka no'o ikimiao”, cheetarenia naaju? Ka'inia pu'kao, pu'kawichio eenakamenia i'ka wehjoarichio, i'ka ti'tijoechio. ");
INSERT INTO var_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","—Ohso kaawe no'o Noonoa, aamo iintonariakamera iintopuapua no'oeo —wa'a tiiame inatamenia. Waikao tepoona o'iniao cheechaniapua: —Neeea no'o amoe iintonariao, o'inekame neeeapa amoe iintokao; iiweta simitiame neeea pehjio, amochi iintokao. ");
INSERT INTO var_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Waikao ki ookapi wa'ami ajakame ti'tijoe ooweru tiamea, te'teoko tu'tuikapua. Wahjachia, Riosi ku'iwari Eesusi nayewerio chaachapapua. ");
INSERT INTO var_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Nape Eesusia chaanekapua wa'a chaachapameo: —Aamo tewekachi inamuriaa, ki no'owichiokamera simiyamepua, aamowichiokamera simiyamepua, aamoo tetewimichiopua, Apoe no'o Noonoo, no'o ahjama nayewamekopua. ");
INSERT INTO var_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Tísia waapi teetoamepua naatia, puuu na'arari noonorao, newitopuachiopua. Puuu na'arari nokinarepuawichio pa'pasuame ti'tijoerio yomachi wehjoarichio, ma'chi ipapuameopua Riosi tetewachio. ");
INSERT INTO var_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Waikao yooma no'o Noono iintonareria iintosoopa noochio, no'o apechunatioopua no'o Noonoeo, yooma aaata te'ta pichiwa no'o ijinuwaa, yooma te'ta ahsieme natetetiame wa'asi, itipimeripua yooma ihta tatakoritiamea. ");
INSERT INTO var_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Pu'ka wa'a cheeka nayewaria Eesusia, ahpo a'chi teeka meripuame nayewaka cheerepua, ahpoo kurusichi chuchaka apechunaka meripuame. ");
INSERT INTO var_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Waikao keepuameraa chaachapakapua Eesusio: —Nee, ¿nape ki senepi wa'apitia ahjamerikaipua Riosie Weratiamea, Ehkoriami Iyoteri chiiachitiao? ¿Achini wa'a chaanimua pu'kao, apechunaka meripuameko tuukao meripuaichio, pu'ka Tijoe Tijoetukameoopua? ¿Aatanakosapu puuu Tijoe Tijoetukamea, ki muuu enesaa? ");
INSERT INTO var_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Eesusia chaanekapua: —Neee Apoepua, nape i'wa no'o kahtioiopua pehjio aamo tahjewachitiao, ohso kaawe no'o chiiakamera pichikepuapua, ki aamo chapipuaichiopua tukaparieo. Puuu tukaparie chapitiamea, ki ma'chiriame puuua Riosi tahjewachi teerepuameo. ");
INSERT INTO var_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Tahjewarikamera pichikeka mochitopuapua, iiweta amochi tiioipua pehji Riosi te'ta pichiwari tahjewao. Wa'a tiiame enepasaa eemea, Riosi tahjewarachi mochitoame enemapua. I'ka cheesapa Eesusia, wa'ami akipakapua noriwi, pu'ka ti'tijoerio, toisa. ");
INSERT INTO var_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Puuu ti'tijoeria Eesusio, ki ookapi ki maaenari yoorakameoipua ahpo tetewachio, wa'atia itipikapua, ki ahjachi paparaka. ");
INSERT INTO var_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Ihji wa'a ikitiamea ki Eesusichi paparakao, pu'ka cheeka cheeriai Isaiatarua, Ehkoriami ahpo Iyoterichio: Paamira, ¿nape aatana pichikekamepua, amochi simiyame taamo nayewariao? ¿Aatana amochi eenakamepua, ahpo tatakoriria cheriwepuawichioo? ");
INSERT INTO var_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Wa'a te'tiapapua, ki machika Eesusio aatanakoo, ki eenarepua pu'kao ahjachi paparaka. Ehkoriami Isaiaa pu'kao, wa'achi cheeriamepua tiame ahpo iyoterichio, eee cheekao: ");
INSERT INTO var_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Riosia ki apochi e'enanarekameopua ahpo tatakoriria cheriwepuawichioo, wa'apitia toare Riosia, ahpo ki mamachiriamechitia peewaeme te'teriamechiopua iikachio; i'ka iikarachiopua peewame enemichiopua. Wa'a te'teriamekapa puuua, kiisi e'wakapa puuua, Riosi apochi paaewao, kiisi machika tetewamepua apochi kiisi ka'karuma te'teriao, pukaepa ki noochi e'ename puuua, no'o cheriwekemichiopua ahpo tatakoririao. ");
INSERT INTO var_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Ehkoriami Isaiaa, waika o'inia tetewikaopua Riosio ki nu'uti tísia peenia tiiame iintomiaopua ahpo Taanachi Eesusiopua, ti'tijoeri tatakoriria te'ta cho'wepuawichiopua, wa'a cheeka iyotere puuua ahpo Ehkoriami Iyoterichio. ");
INSERT INTO var_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Nape wa'a te'tererioi i'kao, wahjachia, muuwaeme pichikeriapua wa'ao, wa'api wa'ao i'isaeri pa'pamurakaipua tiameo. Nape ki chaachariapua, seewiapaopua pariseroo, ahpo ma'chipapuameopua napawikarichio; ");
INSERT INTO var_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Wa'atia ahpo iintare puuuapu, ohso kaawe tijoekameraa ahpo kaawe e'rewa nakire puuuapu, ki Riosi. ");
INSERT INTO var_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Eesusia weeru nayewakao cheekapua: —Noochi paparamea, no'o uhjurakamechi paparamepua tiame, wa'apichi. ");
INSERT INTO var_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","No'o tetewamea, no'o Noono tetewamepua wa'api, apoe te'ta no'o uhjurakamera. ");
INSERT INTO var_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Tahjewarichitia eenakame neeea weeechio, noochi pichikekameo ki tatakorira tukapachi oimichiopua wa'asi. ");
INSERT INTO var_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","No'o keepukai ki yoorekameo, ka'chi yoramania pu'kao; ki pu'kachi eenakame neeea, newipatenia eenakamenia ohso kaawe. ");
INSERT INTO var_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","No'o ehpeo ki nakika tetewikamea, no'o chiiaoi tiameo, pu'ka wahjipachi taawechi wa'asi, enemera no'o chiia aamo wenejiao, aamo te'tia kateweniachio. ");
INSERT INTO var_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","No'o nayewaa, ki nooe chiia puuua, apoe no'o Noono no'o uhjurakame, no'o ki'yaria puuua, no'oo aamo chaanemichioo. ");
INSERT INTO var_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Nane'renania, pu'ka no'o Noono no'o ki'yaria aamo chaanemichioo, aamo ki wahjiame ahjariwawichiokopua pu'kao. Pukaepa wa'atiame naawesari aamoo, tuuyesina neeea, te'ta wa'achi chiiame, no'oo kiasinia, no'o Noonoeo. ");
INSERT INTO var_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Ke'chu pahkokoi Semejenato pahkoo, nane'riame enere Eesusia, asiriamekopua ahpo Noonochi siimerikoopua, i'ka weee toakaopua. Eesusia taamo ahpo ajawariao, tísia taamo nakika yasitoamekaipua, ahkasi wa'a teereka mukukamepua. ");
INSERT INTO var_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Ke'chu taamo koaka mochipanioio, Uurasi Ihkarióte Siimoni taanaraa, riaorósie usuwetiapa ahpo iikachio, noriwi nehjimo orapariapua Eesusio. ");
INSERT INTO var_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Eesusia, yooma nane'riamekapaopua, ahpo Noonoe yooma ihta ahpo iintomia kiatiamekoopua reesiseri, nane'riamekapua tiameo, ahpo Noonochi no'ramerikopaopua tiame, ahpo ma'masitia neesetorichi tooemo eraparepua, yooma ahpo Noonoe weeechi tehkiwaopua. ");
INSERT INTO var_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Wa'a erapakapaopua Eesusia, werisika koi'rachio, ahpo ampawakira pujisaopua, ");
INSERT INTO var_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","neeroi neropetorichi toasaopua, wisasori ahjae wakipateniame kaichi chuchakapua. Wa'a ikisaopua yasipakaopua, taamo ahpo ajawaria ma'masitia tarachi taamo o'inekapua papakokao, yooma taamo pipiripio. ");
INSERT INTO var_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Nape Peerochi asitioiopua ahpo tarachi papakopuameo, chaanekapua Eesusio: —¿Neeekosa tiame, no'o Paamira? ");
INSERT INTO var_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Eesusi nehjiakapua: —Eje'e. Ehpeo ki pahtiame eemea i'ka aamo no'o papakoao, nape ehjepa neipatakirio pahtemeri eemea. ");
INSERT INTO var_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Peeroa ahpo wa'inekaipua chaaneka: —Ka'i neeea no'o Paamira, Kiisi no'o toima neeea no'o Paamira. Nape Eesusi chaanekapua: —Ki no'o aamo papakosoo, kihta teeremapua noochio. ");
INSERT INTO var_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Waikao Siimoni Peeroa, chaanekapua: —Aa, wa'a teresoo Paamira, yooma no'o uupepapua sekachiami tiame, nanarisichiami tiame. ");
INSERT INTO var_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Wa'a chiiopa Peeroo, Eesusia chaanekapua: —Pukeri uupakameapa, tarachiche papakonia nahkipua. Piipakame eemeapa wa'asi, nape ki yoomahka. ");
INSERT INTO var_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Eesusia nane'riapa wa'a cheekapua, aatanakoopua ahpo noriwi na'ara yorameriopua. ");
INSERT INTO var_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Neipa yooma kajusaapua papakokao, eenechi chuchasapa ahpo ampawakirao, eenechi yasipakapua ahpo yasariachi. Wa'a ikisaopua chaanekapua taamoo ahpo ma'masiterao: —¿Pahtena eemea ihtanakoopua i'ka no'o iintoriao? ");
INSERT INTO var_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Eemea no'oo, aamo Masitariwa teewamepua, aamo Paamirawa tiame. Pichiwa chaachapame eemea pu'kao, pichiwa puuu neeea aamowichioo. ");
INSERT INTO var_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Weh, neeea te'ta aamo Masitarikaipua te'ta aamo Paamirawa, neeea ki weruma no'o uukaopua aamo tarachi papakokame enesoopua, eemea noochitiao, wa'achitia aamo ki weruma uuniame te'terepuapua. ");
INSERT INTO var_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Neeea aamo tarachi papakokamepua, aamoo no'oo ki weruma no'o uuya, aamo tetewimichiopua, aamoo wa'achi te'teretomichiopua, ki weruma aamo uuka. ");
INSERT INTO var_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Eemea inataka inamumitiapua i'kao: aaataai ki epeche weruma tiiamepua ahpo teekochio; aaata uhjuratiameai, ki epeche weruma tiiamepua ahpo uhjurakamechioi. ");
INSERT INTO var_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","I'ka pahtekame enesaa eemea, tísia ta'iria mochitomeri eemea, aamoo ki aamo weruma uuka mochitoame enesoo. ");
INSERT INTO var_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","’Neeea aamoo, ki yoomahka te'ta piipakameko tuuriao, pichiwa wa'a tiiamepua, tetewamekapa neeea no'o ajawaria iikachio. Nane'riamenia piiripi eeme no'o ajawariao, kiisi kaawe iintomerikopua noochio. Nape ihji wa'a tiiame iintomeria, wa'a tiiame tetewitiapa ehkoriami o'iniao, wa'a tiiame iintomeripua. Ehkoriami Riosi nayewaturao, wa'a tiiame iintopuame tetewika chaachapariopua, Ehkoriami Iyoterichiopua, eee chaachapaka iyoteriaopua: “Piiripi puuu no'o ahjama oiyamea, no'o pukamina na'ara iintokamepua.” ");
INSERT INTO var_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","I'ka wa'a tiiame aamo chaanenania, ke'chu wa'a tiiame no'o ikiyoiopua, aamo nane'remichiopua no'oo, yomatiame no'o ikimiao, tetewamekopua. Neeea Apoepua te'ta neeea, te'ta ihtaoi tetewameopua ke'chu ikiniameoipua pehji. ");
INSERT INTO var_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Eemea i'ka pichiwari no'o cheemiao, inataka keepupuapua: No'o uhjurakame kaawe uuka tetewamea, no'o kaawe uuka tetewamepua tiame; no'o kaawe uuka tetewamea, no'o uhjurakame kaawe tetewamepua tiame. ");
INSERT INTO var_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Wa'a cheesaopua Eesusia, iiyana erapaka apochiopua, taamo chaanekapua: —Pichiwa simiyame ihjia, piiripi eemea, nanaaramechi no'o nehjimerapua noriwi. ");
INSERT INTO var_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Waikao teemea, tahpitika erakokao, nenekuti taamo ne'nepakapua: “¿Aatanakamera ohjoare teemea?”, taamo erakoka. ");
INSERT INTO var_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Waikao no'oo, Eesusie epeche nakiwa eraniameo, chokichi kahtiamekopa pu'kao, ");
INSERT INTO var_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Siimoni Peero tewaniamea, sekae no'o naewakapua, ihchi no'o iinatukenurakapua pu'kao, aatanakamerakopua. ");
INSERT INTO var_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Waikaonia waapi chukipakao: —¿Aatanakameraju no'o Paamira? —chaaneka iinatukekania. ");
INSERT INTO var_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Waikao Eesusia, ihchi no'o cheekapua: —Ihji paani ichuka saampatesa no'oo ki'ya, puuu enemapua. Wa'a cheesapa, Uurasi ki'yakapua paani ichuka saampatesa, Siimoni Ihkarióte taanarakapua. ");
INSERT INTO var_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Neipa pu'ka paani iintotioiopua, Uurasia apochi pakiteriapua Satanasio, ahpo na'ara iintomichioopua. Wa'a iikopa Uurasio Eesusia chaanekapua: —Uurasi, yaapi werisika siinka, iintomitiapua pu'ka aamo iintonareka kahtiao. ");
INSERT INTO var_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Nape piiripiai wahjachi teemea, Eesusi ahjama koayamea, kiisi pahtekapua aatia tiiachipa Eesusio, wa'a chaaneriamekopua Uurasio. Neeeche pahtekamepua pu'kao. ");
INSERT INTO var_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Puuu wahjachia, poanachi tarimia siinkameko erakoapua, itapiti taripua pahkowichioo, aaata tesiwewa te'tiamewichiooi, ihkokepuamekoiopua. Wa'a erakokamekapua Uurasio, puuu iintotoamekopapua, taamo toomi na'poasika kiasiriaopua. ");
INSERT INTO var_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Waikao Uurasia, ikanati ahpo paani chi'wanetiame ichuka ko'kosaapua, simikapua waikao wa'asi ahpo iintomia yoramiaopua. I'ka Uurasi simioiopua, tukaokapua wa'asio. ");
INSERT INTO var_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Neipa Uurasi simisoopua Eesusia taamoo chaanekapua: —Ehpe tetewipua neeea, te'ta peenia tiiame no'o iintomerio; te'ta peeniatiame tetewipuameopua tiame, te'ta no'o Noono inatariaopua no'o iintomiaopua. ");
INSERT INTO var_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Neeea no'o iintomiaeo, No'o Noono tísia peeniatiame inataria tetewitesoo, Apoe no'o Noono tísia peeniatiame inatariao, no'o iintoriae tetewitemapua pu'kao, ti'tijoe ooweru tiame tatakoririao, ahsieme natetetiame itipiniame tetewitekao. Ehpe wa'api tukawarichi iintopuamepua wa'asi. ");
INSERT INTO var_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Eeme no'o kukuchiwa, kihta itipina neeeapa aamo ahjama yasimiaopa. No'o i'yama eemea i'yao, nape ki no'o teimapua. No'o simiyachio eemea, ka'chi iika siimpamete eemea, isaeri ya'yawichioi wa'achi chaanekamenia no'o iinatukekoopua. ");
INSERT INTO var_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Ehpeo neeea, tísia aamo nakiyao, tísia kaawe aamo nakika mochitojeraninia. ");
INSERT INTO var_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Wa'a te'teretoka aamo mochitosoo, yooma ti'tijoea ooweru tiamea, amochi tetewimeri eemea no'o masiteriao, no'o aamo kaawe nakika mochitoniameo. ");
INSERT INTO var_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Siimoni Peero teewaemea, ka'chi iika ahjama siimpuame inatakaopua pehjio, chaaneka iinatukekapua Eesusio: —¿Akana akipatamua Paamira, ka'chi aamo ahjama siimenia? Eesusia chaaneka nehjiakapua: —No'o simiyachio ehpeo, ka'chi iika no'o na'naritomerimua pehjio, nape piie taawechiope. ");
INSERT INTO var_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Peeroa waikao utewa cheeka iinatukekapua eenechi: —Nape Paamira, ¿aatia tiiachipa ki siimetenia? Nape Paamira, kiisi ka'chi e'ramenia ahkasi mukukainia, aamo nehpupawachio. ");
INSERT INTO var_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Peero wa'a chiiopa chaaneka Eesusia: —Wa'a chiiamemua chiiao, nape neeea aamo chaanenapua, ke'chu kusuyoi totori oowirao pa'a piario, paisa simiyame no'o ka'itameri muuua, kiisi no'o machiyo tuuka. ¿Pichiwa wa'a e'ramemua aamo chiia? ");
INSERT INTO var_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Eesusia wa'a chaanesa Peeroo, yooma taamo ahpo ma'masiterao chaanekapua: —Ka'te yuuwesi, no'o siimo tuuyoio, noochi ahjachi e'rakache mochipuapua ohso kaawe, Apoe no'o Noono Riosichi tiame. ");
INSERT INTO var_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","No'o Noono tewekachi kahtiachio, ki ookapi iintunapua ahka mochipuachio. Ki wa'a teeresoo, ki cheemiinia wa'a simika aamowichio katewemio tuuyao, yooma pipiripi ahka aamo mochimiachiopua. ");
INSERT INTO var_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Ehpe ki tehpe simisao, ahkasi aamowichio katewesapa enamania eenechi, wa'a aamo i'tomaniapua no'o ahjama, no'o ahjama mochimichiopua waikao, ahka no'o te'ta kahtiachi; ");
INSERT INTO var_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Nane'riame eemeapa, achini teeka asipuameo wa'ao. ");
INSERT INTO var_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Toomasia chaanekapua waikao: —Nape Paamira, ¿achini nokaka asita teemea wa'ao, kiisi nane'renaoi teemea wa'a pooeoi, ahka aamo simiyachiopua? ");
INSERT INTO var_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Eesusia chaanekapua: —Neeekamerapua puuu pooea, no'o yasimiachi asitemeria; neeechepua te'ta pichiwari aamo tuuyekamea; neeechepua tiameo, te'ta ahjari ki'yameraa, ahkasi ki wahjiamesio. Aawataai ki asima no'o No'nochio, ki no'oeo. ");
INSERT INTO var_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","No'oo te'ta machiyame enesaa eemea, no'o Noono tiame, te'ta machimii eemea. Machikamekai eemeapa no'o Noonoo, noochi tetewaka ohjoamekai eemeapa no'o Noonoo. ");
INSERT INTO var_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Eeripea waikao chaanekapua: —Nape Paamira, ahjama ohjoamekai teeresaa teeme, ¿achinikai ki tetewame teemea? Taamo tetewitesao naaju. Tetewisaa teemea pu'kao, tisiwa kaawe erakomii teemea waikao. ");
INSERT INTO var_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Eesusia waikao chaanekapua: —¿Kiisikosa no'o machika tetewame muuua Eeripe, ki ehpesi no'o aamo ahjama oiyoi? ¿Aatia tiiachipa aamo tetewitejerata eemea no'o No'noo? Neeekamera puuua, Apoe no'o Noonoa; no'o tetewamea, apoe no'o Noono tetewamepua. ");
INSERT INTO var_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","¿Ki pichikiamekosa eemea no'o tiiario no'o Noonochi tiiamekopua, apoe no'o Noono tiiario noochi tiiamekoopua? No'o nayewao ki nooe chiiamepua, weeechi tijoechitiao, no'o Noonoa noochi tiiamekapao, apoekaitepua noochi chiiao. ");
INSERT INTO var_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Waikao Eesusia yooma taamoo, chaanekapua: —No'o pichikepuapua no'o chiiao, no'oo no'o Noonochi kahtiamekopua, apoe no'o Noonoo, noochi kahtiamekopua wa'achitia. Ki no'o chiia pichikesaa, no'o ihsiaoi pichikepuapua, apoe no'o Noono noochi ihsia. ");
INSERT INTO var_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Pichiwa chaaninia, aaataai noochi paparamea, no'o Noono tehkiwa no'o inisia teetomeripua, apoepechi no'o Noonochi paparamichio ti'tijoe paajuteka, ooweru wa'achitia. Nape puuu apoepechia, epeche muuwaeme paajutemeri ki noochitia no'o Noonochio, no'oo no'o no'ramerikopa no'o Noonochio. ");
INSERT INTO var_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Eemea aaata no'o Noonochi enatekamea aaata tatakoriria cheriwepuawichioo, ihtaoi tatakoriria no'o Noonoe cheriwepo tuuka masitemeripua, nape no'o ahpowichio no'o kurusichi mukuriae natetewachi itaka. No'o kurusichi mukuria ki ookapiwichio tatakoriria natetekao, no'o Noono tísia peenia tiiame inataria puuua, yooma wehjoarichi mochikamewichio, tetewimichiopua. ");
INSERT INTO var_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Ihtaoi ahpo cheriwepuawichio noochi eenakameo, cheriwemachenia pu'kao, nape ahpowichio no'o iintoriae natetewachitia, noochi itasoopua. ");
INSERT INTO var_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","’No'o nakiyame enesaa eemea, no'o e'weka mochitopuapua, no'o aamo nuuria. ");
INSERT INTO var_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Wa'a aamo te'tereka mochitopao, no'o Noono nayewemania aamo uhjuremichioopua ahpo Riosiwarioopua, aamo ahjama teetomichiopua ki wahjiamesio, aamo ku'isimichiopua aamo teetowachio, yooma ihta aamo nakiyachisio, aamo oisa erapatesimichiopua tiamé. ");
INSERT INTO var_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Puuu iintomeripua amochio, te'ta pichiwari tiiamera pahtetekao. I'wache weeechi nokiwame pu'seriamea, ki kaawerumachiche mochitonariamea, ka'chi iika uumeripua pu'ka no'o Noono Riosiwari ku'iwarao, ki uuka tetewamekopa puuua, no'o Noonoe ahpo kiamiao. Eemekamera kiatiamepa pu'ka Riosiwario, puuua epeche ku'iwa yasitomeripua yooma pipiripichi amochio, ki wahjiame aamo ku'isimeripua no'oo no'rasoopua. ");
INSERT INTO var_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Ka'chitia taawechi aamo piineri toayai neeea neesetokao; eenechi enamerikaite neeea, pu'ka wa'api Riosiwarichi amochi yahchamechi, nooe amochi yasitomiaopua, ki wahjiame amochi te'ta ku'isimia. ");
INSERT INTO var_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Ki mehka toiaitepua, i'ka weeechi mochikame ki ka'karumao, ki oosa no'o tetewimiachiopua i'ka weeechio, nape eemea noochi te'teretokamea, eenechi no'o tetewimiitepua no'oo oijenasocheo pehjio. Neeea wahjipaniame newitosaapua, kajuyachi taawechio, aamoo wahjipakamekoipua, eenechi aamo ahjatemania. ");
INSERT INTO var_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Nape eenechi no'o ahjakame tetewapaopua ke'chu no'o no'roipua tewekachio, pahtemeri eemea waikao, pichiwa No'nochi eenamekopua, no'o Noonoo neeeopua tiameo, piiripi wa'apikai tiiopua. Waika waanamio, eemea no'o ahjamao piiripi wa'apika teeremeripua, no'oo amochi teetoamekopua no'o Riosiwarieo. ");
INSERT INTO var_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","No'o nuuraria kaawe neesetoka i'toamea, pichiwa no'o nakiyame puuua. Wa'a teeka no'o nakiyameo, no'o Noonoai tísia nakiyamepua pu'kao. Pu'ka wa'a te'teriamechi, no'o Noonoa neeea tiameo, pukachi taamo tetewitemapua, piiripichitia, Riosi Riosiwarichi. ");
INSERT INTO var_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Waikao Uurasia, nape ki Ihkarióte Uurasia, iinatukekapua: —Paamira, ¿aatia taamoche taamo tetewitetamua, ki aamo paparameopua ka'i? ");
INSERT INTO var_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Eesusia, nehjiakao chaanekapua: —Aamoo noochi paparasoopua, no'o Noonoa neeea tiameo, piiripichitia yasitomeripua amochio. ");
INSERT INTO var_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Nape ki no'o nakiyamechiopua kihta yasitomeri teeme pukachio, ki no'o e'weka yasitoamekopua pu'kao, no'oo, no'o Noonoche chiia nayewerioipua. Ihji no'o chiia aamo inamuaa, apoe no'o Noono naawesa puuua, apoe wa'api i'ka weeechi no'o uhjurakame, ahpo noochi nayewa inamupuawichiopua. ");
INSERT INTO var_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","’Neeea iiweta aamo ahjama kahtiaapua pehjio, i'ka yooma aamo tuuyamepua. ");
INSERT INTO var_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Nape no'o Noonochi no'rasoopua, no'o Riosiwarie ihsimania aamo ku'ikao, no'o Noonoo aamochi uhjuramia. No'o Riosiwari ihsimapua aamo tuuyekao, yooma itapiti aamo masitiachio, yooma no'o aamo masiteria, inatepatesika. ");
INSERT INTO var_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","’Neeea te'ta kaawe erapari aamo ki'yamepua, ki weeechi mochikame kaawe erapari ki'yamechitia. No'o aamo kaawe erapari ki'yaa, no'o wa'api kaawe erapari iinuekapua. Pukaepa no'o kaawe erapari iinuemea, kihta yuuwesipuapua no'o simiyawichioo, itapiti seewekaoipua a'chi teeremiaopua, no'o ikimiaoipua ku'we. ");
INSERT INTO var_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Eemea, no'o inamukame eemeapa no'o siimio tuuriamekoo, nape eenechi amochio yasimia enameriko tuuriao. Noochi paparamea, no'o te'ta nakiyame enesaa, kaawe erakomete puuua kihta yuuwesika no'owichioo, no'o Noonochi simiyaa, amochi enamiapa eenechi wa'a no'o simiyopa, nape Riosi Riosiwarichi, yomachi amochi yasitome teereniamechi Riosiwarichi. No'o Noono Riosiwarichi yasipasaapa neeea, ahkaoi teeremeri neeea no'o Noono Riosiwarie yasitoaeo, ki weeechi no'o weerewae yasitoriachitia. ");
INSERT INTO var_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Ke'chu ikiyoi i'ka, yooma aamoo chaanenania, i'ka wa'a tiame ikisoopua, pichiwa no'o cheerio erakomichiopua aamoo, wa'a erakoapa eemea, kihta seeweka noochi paparaka mochitomichiopua i'ka weeechio, noochiche ahjachi erakoka. ");
INSERT INTO var_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","’Ki tehpe toina neeeapa ki no'o aamo nayeweka yasimiaopua wa'asi, waapi ihtona tukaparichi ye'kameapa, puuu te'ta no'o na'ara yorameria, apoe te'ta Satanasi tewaniamea, puuua te'ta ki ka'karuma nokayakamera, noonora. Puuua kiisi iinuekaitepua apochio, no'ochi newitomiaopua, ");
INSERT INTO var_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","nape yooma ti'tijoeri nane'remichio no'oo, tísia nakiyamekopua no'o Noonoo, pu'ka iintomo e'raria iintomania ehpeo, no'o Noonoo tísia e'weka. Werisisa, nahpe. ");
INSERT INTO var_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Wa'a o'inia puuyatioiopua, pooechi nokisinioio Eesusia, eee cheesika taamo masitesikapua, ahjama nokisinioio: —Neeea, uuwa echitiamepua, no'o echakamea, apoe no'o Noonopua. ");
INSERT INTO var_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Yooma no'o paanira ki taakiameo, tehpuchenapua pu'kao; nape kaawe taakiameo, katewekenapua pu'kao, charewa ki ka'karumao puhjeneka, epeche taakemichioopua. ");
INSERT INTO var_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Eemea, cheriwetiame eemeapa tatakorio, piipaka itipikame, amochi uukapa muuua no'o cheeriao, pichikeka. ");
INSERT INTO var_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Wa'a aamo te'teresoopua noochio, wa'achi teerema neeeai amochio, amochi yasimania. Yooma uuwa paaniraa, ki ihchiame enesaa, kihta taakemapua. Wa'achi te'terena eemeai noochioi, ki noochi ihcheka te'teriame enesaa, kihta muuwemii eemeai, aamo taakiamechitiaopua. ");
INSERT INTO var_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","’Neeepu uuwa echitiamea, eemea paanirapua. Noochi ihchiapa eemea, neeea amochi taakiamepua, nape ki no'oeo eemea, kihta muuwemiipua taakekao. ");
INSERT INTO var_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Ki noochi ihchiame yasinariamea, ki uuka tetewipuamepua, paanira ikicha ipatiamechitia, wakipasoopua kosopuaichio. ");
INSERT INTO var_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","’Eemea noochi ihcheka te'teretonariamea, no'o chiiao, iyorika uuka yasitonariamea, ihtaoi ahpo nakiya no'o itanemeri puuua, aamo muuwewari taakemichioopua. ");
INSERT INTO var_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Aamo nokisiamechi ka'karuma taakesoo, no'o Noono amochi ihsiwarao, ahpo kaawerumari amochi teteiwa ihsimeripua. Pukachi naania teeremeri eemea, no'oe masitetiamekoopua. ");
INSERT INTO var_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Wa'achitia no'o Noono aamo nakika yasitoachitia, wa'achitia aamo nakika yasitoame neeeai. Wa'achitia mochitopuapua eemeai i'ka no'o aamo nakiyaopua, ka'te wa'atia wekate eemea. ");
INSERT INTO var_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Wa'api teetosaa eemea no'o masiteria teetokao, wa'api amochi tetewika uupuamepua, aamo no'o nakirao. ");
INSERT INTO var_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","’Peenia erakosa naaju, ihji no'o aamo chaaniaa, pu'kawichiopua, ki teesa aamo peenia erakomichio, amochi yasitoniamekoo inataka. ");
INSERT INTO var_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","I'kache aamo nuurenania, aamo kaawe tetewaka mochipuame, ahpo nakika, no'o aamoo te'ta kaawe nakiriachitia. ");
INSERT INTO var_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Ki'te te'ta epeche nakiwamea, ki'te mukiwachisi nakiwamea aaatao, ahpo kaawe e'rawichioopua. ");
INSERT INTO var_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","E'wakame eemeapa, i'ka aamo no'o nuureriao, pukaepa aamo, aamokamera kaawe e'riame neeea. ");
INSERT INTO var_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Neeea aamoo, ki no'o tekipanatewa teewaninia wa'asi, tekipanamea ki yooma nane'reteka yasitoame puuua ahpo teekochio, itaoi ahpo yoranareka kahtiaopua pu'kao. Nape neeea aamoo, no'o kaawe e'rewachitia tetewamenia aamoo, yooma no'o Noono e'ra aamo nane'retesiapa. ");
INSERT INTO var_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Ki eemekamera no'o uukamepua, aamo ahjama oimichioopua; neeekamerapua aamo uukamea, no'o masitia masitesimichiopua ti'tijoeo ooweruopua tiame, noochi paparamichiopua pu'kao. Aaata aamo ku'yao noochi paparariame enesoo, no'o iintoria ahpowichio kurusichi inatakao, no'o Noonochi cheriwewa itasoo, cheriwemeri no'o Noono te'pa tewekachi kahtiamea, ihtaoi itapiti ahpo cheriwejera itakoiopua. ");
INSERT INTO var_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Nape ka'te ahpo newitome erakomitia eemea, Riosichi paparamichio e'enatewa nokayaiopua ti'tijoeo, ooweruopua tiame. Ohsotia aamo chaanenania wa'a aamo nokisiachi pu'ka yooraka: Kaawe aamo nakika mochitowa, masitepuapua, napati aamo wa'achitia uuka tetewika. ");
INSERT INTO var_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Eesusia simiteka pehji taamo masitekao, eee cheekapu: —Ki noochi paparameo aamo nekumesoo, nane'repuapua no'ooi wa'achi teeretiopua pahcha ki aamochitia, nekamuchekao. ");
INSERT INTO var_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Eemea, i'ka wehjoari ki ka'karuma yooraka nokisiame enesaa, kaawe e'raka tetewi puai eemea, ki ka'karuma yoorameeo. Nape eemea, no'o paajutekopa noochi e'enariopa, no'o ijinuwa iintapame neeea, ki wa'achi nokaka mochitomichiopua, ki ka'karuma yooraka mochitoamechitiao. Ehpeo aamoo noochi te'teriapakoopa, nekamucheniame eemea pukaeo. ");
INSERT INTO var_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Nane'repapuapua no'o cheeria: “Yoorewa naewakao, ki epeche yooreka tetewiniame tekipanameraa, ahpo teekorachitiaopua.” Kaawe uuka tetewipuame enesaa no'o masiteriao, kaawe uuka tetewipuame aamo masitiaai, no'o nuurarikapa. No'o na'aretiame enesoo, na'arepuame eemeai. ");
INSERT INTO var_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Yooma aamo na'ara yoraniamea, noochi te'teriapa wa'a aamo yorapuamepua. Ki no'o Noono uhjurariachi ahjama te'teriapa, wa'a aamo yorameripua, nanaaramea. ");
INSERT INTO var_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","’Ki no'o eenakame enasoo kihta teeremii puuua ki no'o nakika mochikapa kokosapuameo, ki tetewikame enesaapua tísia peenia tiame no'o ihsiriao, ki aaata iintome tiiaopua. Nape ehpeo no'o eenakoio ki no'o uuka tetewikamea ti'tijoe ooweru tiamea, no'o Noonoe kokosapuametere mochitomeripua. ");
INSERT INTO var_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Aaata ki no'o uuka tetewamea, no'o Noonoi ki uuka tetewamepua. ");
INSERT INTO var_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","No'oo, ki yooma tetewachi ki maaenari yoorakame enesoo, itapiti ki aaata yorame tiameo, kihta a'chi teeremii puuua, ki no'o uuka tetewaiopua. Nape ehpeo yooma no'o ihsia tetewakaio, na'pa taamo ki nakika tetewikamepua, no'ooi no'o Noonoi. ");
INSERT INTO var_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Nape yooma ihji ikiniamea, ehkoriami Riosi nayewatura no'o ikimio chaachapatiamepua. Puuu ehkoriami nayewatuaa, ehpe taawechiami ki no'o nakiyo tuuwa, chaachapakame puuua iyotekao: “Kihta iintokai ki nakiniame neeea.” ");
INSERT INTO var_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","’No'oo, no'o Noonochi no'rasoo eemea, kaaweruma nayewameri eemea no'o iintoriao, no'o Riosiwari aamo ku'imichio no'o uhjurariae. Puuu no'o Riosiwari yomatiame ihta no'o iintoria aamo inatepatesikaopua, yooma no'o iintoriao, kaaweruma nayewesimichioopua ti'tijoerichio, pichiwa te'ta wa'a teeeriopua no'oo. ");
INSERT INTO var_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Eemea no'o ajawariaa, pukerisi o'inia no'o ahjama ohjokamekapao, wa'a chaachapameripua. ");
INSERT INTO var_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","’Yooma i'ka aamo chaanesika yasitokame neeea, aamoopua, ki no'o toaka mochitomichiopua, anachaka pu'ka ki teesa tiame aiwari enameriopua. ");
INSERT INTO var_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Ma'chi ihpapapuame eemea napawikarichio, ahkasi aamo me'yakameai, ahpo kaawe e'repuame maaemerapua Riosieo ahpo wa'a iintoriawichioopua. ");
INSERT INTO var_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Wa'a nokimera puuua, ki te'ta no'o Noonochi te'tereka mochitoapa, no'ochioi. ");
INSERT INTO var_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","’Wa'a aamo chaanena neeea, nane'reka mochimichiopua i'ka wa'a tiame ikinioiopua, no'o aamo chaaneriao. Pukeri simiyachio, ki aamo chaanekania i'kao, aamo ahjama oiyapaopua pehjio, nape ehpe aamo chaaniamenia, simiyapa wa'asi. ");
INSERT INTO var_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Nape eemea, aaataai ki no'o iinatuketiamepua akana no'o simiyao, ma'chiame aamo no'o tuuyekamekopua, akana no'o simiyachio. ");
INSERT INTO var_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Oowera no'o simiyache, yuuwesina eemea. ");
INSERT INTO var_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Nape pichiwa chaani neeea, kaaweruma simiyamekopua aamowichioo no'o simiyaa. Ki no'o simisoopua, ka'chi iika enameri amochio aamo Ku'itomeria, nape nooe simisaapania no'o Noono kahtiachio, nooe wa'api iintomania aamo Ku'itomeri uhjurekao, puuu aamo Ku'imeria, nooe wa'api Riosiwari enemeri puuua, amochi enameria. ");
INSERT INTO var_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Ihji no'o Riosiwari i'ka weeechi enasaapa, puuu iintomapua tetewitekao, yooma ti'tijoe ooweru tiameo ahpo iikachio, kiisi ka'karumakopua, tísia tatakorikamekapaopua. Nape puuu Riosiwaria tiameo, pu'ka ki ka'karuma nokaka mochikameo, tetewitemapua tiameo aachin nokaka ahpo ka'karumachi enepamiaopua tiame. No'o Riosiwaria ihsimapua tiameo, yooma noochi paparakameo nane'retekaopua, pu'ka na'arari noonorao, no'o Noono kokosaritere teereniakopua wa'asi, pu'kao te'ta kokosapuawichiopua te'ta kajuyachiopua taawechio. ");
INSERT INTO var_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Ihji kiisi kaawe nokiwamea tatakorika mochitoame tewaniame puuua, ki noochi paparaka mochitoamekopua pu'kao. ");
INSERT INTO var_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","No'o Riosiwaria, apoe ihsimapua ki ookapi paajutekaopua aachin teeka kaawerumachi enepameriopu, no'o Noonochi e'enamichio paajutekao. I'wa weeechiche itipisaane, no'o chiia inamukameche e'enatemiinia no'o Noonochio. Nape simisaane no'o Noonochio, ahkaoi yomachi tiiame enamania no'o yasitoao, no'o Riosiwari tiiarirao aaatachioi, no'o Noonochi paajutenariaopua. ");
INSERT INTO var_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Te'ta na'arari Noonoraa, no'o Noonoe kokosaripuache chanitiamekopaopua, no'o Noono ki ka'karuma katewemiao, te'ta pichiwa enamerichepua, kiisi wa'atia itipimeripua pu'kao. ");
INSERT INTO var_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","’Ki ookapi iinuenia pehji aamo chaanemiao, nape ehpeo eemea, ki pahtemapua pehjio. ");
INSERT INTO var_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Nape apoe Riosi Riosiwari te'ta pichiwariemea, amochi enasaapa, yooma aamo masitemapua, noochi simiyame pichiwarichiopua. Apoe Riosiwaria ki seenu Riosiwarie ihsimeripua masitekao, apoe no'o Noonoe ahpo chaanesiwa masitesimapua. Puuu no'o Riosiwaria tiameo, puuu teetosimeripua aamo masitekao, ahkasi wahka ihtoriachisiopua, itapiti ikipuamechi simiyameopua. ");
INSERT INTO var_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","No'oo, puuu ihsimapua no'o kaawe chaniwa tetewipakaopua, akatiasi no'o soparamekoopua, no'o ihta aamo kiamiaopua ku'iwario, no'o iinuwachi uuyapapua aamo kiamiaopua. ");
INSERT INTO var_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Yooma no'o Noono iinuekao, no'o iinuwapua tiame. Pukaepa no'o iinuachi uumio tuuna neeea, aamo kiamiawichioo. ");
INSERT INTO var_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","’Ku'itapi toiyachio, kiteremania i'wao, nape eenechi ku'itapichio, no'o tetewimeri eemea. ");
INSERT INTO var_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Ookapi teeme Eesusi ajawariaa, taamo ahpo chaachapai teemea: —¿Ihtana ku'itapi naewaka cheeriamare Eesusia, ki ahpo tetewipo tuukao, wa'a ikisao eenechi ku'itapi ahpo tetewipo tuuriao? ¿Ihtana chanika cheeriamarepua, neipao ahpo Noonochi simimio tuukaopua tiameo? ");
INSERT INTO var_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","¿Aatia wa'a cheeka nayewariare Eesusia, “ku'itapi”, cheekao? ");
INSERT INTO var_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Eesusia nane'riapa ahpo iinatukepuameo, chaanekapua: —No'o ku'itapi ki tetewisaa, eenechi tetewipo tuuriao, ¿pu'ka nane'renariame eemea? ");
INSERT INTO var_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Kaawe keepumitia naaju i'kao: Aamo naarakoio yuuwesikao, ki nu'uti siimera kaawe erakoniamea, wahja tijoechiopua ki ka'karumachio. Nape neipa yuuwesisaapa, kaawe erakomeri eemea eenechio. ");
INSERT INTO var_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Aaata oowitiame saumeria, iiyana e'rame puuua ahpo saumiachi asiyoopua, kokosa aiwamiapa puuua, nape pu'ka sauniame aiwari u'matosoopa, yooma natekepamepua pu'kao, wa'a ikisaapa kaawe ejeramepua eenechio. ");
INSERT INTO var_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Eemea, wa'achi te'teremapua ehpeo, ehpeo yuuwesina eemea, nape eenechi no'o amochi tetewitemia machejenesoopua, eenechi peenia erakomeri eemea aamo iikachio, nape te'ta peenia erakorie ki aaata u'yeme tiameee. ");
INSERT INTO var_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","’Pu'ka taawechiami no'o Noonochi simikoio, eemea kihta no'okamera itanemeripua waikao, ihtaoi aamo itayaopua Riosichi ta'iria mochitopuaopua. Pu'ka aamo kiapuao, Apoe te'ta Noonokamera itanemeri eemea pu'kao, Apoe iintomeripua yooma aamo itaya ki'yakao, yooma ihta apochi ta'iria mochitoniameopua. Wa'a iintomeri puuua aamoo, no'o ijinuwarakopa. ");
INSERT INTO var_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Ahkasi ehpeo, kihta wa'a tiiame itayame eemea no'o Noonochio, no'o ijinuwako tuukao. Nape no'o Noonochi simisoopua, no'o Noono itanepuapua, yooma ihta aamo nakiyaopua, no'o Noonochi ta'iria mochitopuaopua. Wa'a te'teretosaa eemea no'o Noonochio, tísia ta'iria tiiame mochitomeripua, tísia kaawe erapuame tiiaeme. ");
INSERT INTO var_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","’Ahkasi ehpeo, itapiti wa'achitarichi aamo nayewekame neeea, nape asinapa no'oo, ki wa'achitarichi aamo nayewemiaopua, ma'chiame aamo ne'netemania waikao, no'o No'noo. ");
INSERT INTO var_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","No'oo no'o Noonochi no'rasoopa, aamoe wa'api itameripua no'o Noonoo, tewekachi kahtiameo. No'o Noonochi no'rasaapa, ki neee ihsimeripua, no'o Noonochi aamowichio itanekaopua. Wa'a te'terewa iinuemeri eemea no'o Noonochio, no'o ijinuwarakapa. ");
INSERT INTO var_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Apoe no'o No'noa aamo inamumapua, tísia aamo nakiyamekapa. Wa'a tiiame puuua tísia aamo nakikao, aamoo tísia no'o nakika mochikamekopapua, aamoo no'o pichikeriopua tiameo, no'oo te'ta no'o Noonochi eenamekopa. ");
INSERT INTO var_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Neeea no'o Noono tiiarirachi machenakame neeéa, weeechi enamiaapa, pukaepa neeea ehpeo, i'ka weeechi mochikame toisaopua, no'o Noonochi no'rameripua, no'o Noono Riosi tiiarichi yasimia. ");
INSERT INTO var_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Waikao teemea Eesusi ajawariaa, chaachapakapua: —¡Aa, ehpeo ma'chiame nayewakame muuua, kihta itapitichi wa'achitarichi naewaka! ");
INSERT INTO var_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Wa'atiao, ehpeo nane'rekame teemea aamoo, yooma ihta yomatiame machikamekopua, ke'chu ihta aamo iinatukioio, yooma nane'riamekopua. ");
INSERT INTO var_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Eesusia nehjiakapua: —¿Ehpeope, pichiwa pichikiame eemea, no'oo aatanakotiao? ");
INSERT INTO var_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Nape wa'a erakoai eemea, ki tehpe simiyachi ujumamiite eemea, piineri toakaoopua no'oo —chaaneka Eesusia—. Nape aamo ujumakoi, ki piineri kahtiai teerema neeea, no'o Noonoa no'o ahjama kahtiai teeremapua, Apoeo noochi yasitoamekapa Riosiwarirao. ");
INSERT INTO var_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Yooma i'ka aamo chaanekame neeea, kihta a'chi e'raka aamo mochitomichiopua. I'ka weeechi mochikaopua pehjio, itapiti a'chi tiame na'arari aiwameri eemea. Nape eeme noochi ahjachi erakoamea kaawe erakomitiapua, no'oo newitoriopa i'ka wehjoarichi te'ta na'arari noonoraopua, i'ka weeechi ki ka'karuma yooraka mochiniameo ye'kaka yasitoameo. ");
INSERT INTO var_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Eesusia wa'a cheesika taamo masitekoiopua mochipatiapua ku'itapi. Eesusia waikao, te'pa ne'nepakao, eee cheeka nayewekapua ahpo Noonoo: —No'o Noonoo, asikame neeeapa aamo yahchariachio, aamo te'ta inataria iintomiachio yomatiame i'ka wehjoarichi mochikamewichioo. Kaawe no'o iintomia tetewijeraninia pu'kawichioo, neeeai aamoo tísia kaawe aamo te'ta inatatoriaopua kiisi ki ku'itapisi ehkoriami o'iniaopua, ehpe i'ka taawechi no'o iintomeriopua. ");
INSERT INTO var_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Muuua No'no, reesiseri no'o ki'yakamemua, ki wahjiame ahjari kiamichiopua, yooma aaata amochi paparaka e'enakameo, i'ka weeechi mochikameo. Yooma pu'kao amochi e'enakame ahpo tatakori cheriwepuawichioo, no'o ki'yakame muuua pu'ka piipatemichio. Wa'a iintokame muuua, amoe no'o uhjurakamekopamua i'ka weeechio, no'oo, pu'ka tatakorikameo, pejana natetemichiopua tatakoririao, amoe wa'api kokosapuameo, te'ta weemera ahjari kiapuawichiopua ki wahjiamesi. ");
INSERT INTO var_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Neeea pu'kao, weemera ahjari ki'yamepua, noochi paparaka amochi paparaka tiame e'enakamekopapua pu'kao, aamoo te'ta pichiwari Riosikamerakopua. Neeea wa'a iintokamepua pu'kao, pu'ka iintomichio amoe uutiamekapa, pu'ka iintomichio weeechi no'o naawatekamekopua. ");
INSERT INTO var_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","’I'ka weeechio neeea, aamo te'ta kaaweruma tiiao yomatiame weeechi aamo nayewakamenia; neeea tiameo, aamo no'o nuureria i'ka weeechi no'o iintomichioo, yooma iintokamenia wa'asio. ");
INSERT INTO var_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Ehpeo, noochi aamo tetewitepuapua, pu'ka amochio pu'ka ki nu'uti tísiwari aamo tiiaopua, ke'chu i'ka weeechi naayachisiopua, taamo pirena te'tereniameopua taamo tiiarichio. ");
INSERT INTO var_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","’Neeea i'ka no'o ahjama ohjokameo, yooma aamo tiia ma'chitekame neeeapa pu'kao, aachin tiiamekopua aamoo. Ihjia aamo ijinuwakapao, no'o ijinuwapua tiame, amoeo wa'a tiame noochi tetewiniamekopua. I'ka aapoeo, no'o e'wekapao, aamo e'wekamekopapua tiameo. ");
INSERT INTO var_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Ehpeo ihjia, nane'reka mochitoamepua, yomatiame no'o tiia, amochi o'inia eenamekopua. ");
INSERT INTO var_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Wa'a tiame pahtekamepua, yooma no'o masiteriaopua no'o chuwaeo, amoe inatarichi e'rario noochi eenamekopua nayewamichioo. Wa'a tiame pahtekamekapaopua, amochi paparamepua. ");
INSERT INTO var_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","’Pu'ka wa'a teeremichio aamo uuriaopua, aamo itaniamenia pu'kawichioo, kaawe inateka neesetomichiopua pu'kao. Wahjachi ki aamo ijinuwaopua, kihta aamo itaniamenia pu'kawichioo, aamoche ijinuwawichio noochi iintapariawichio itaniamenia neesetojerakao. ");
INSERT INTO var_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Yooma no'o ijinuwaa, aamo ijinuwapua tiameo; yooma aamo ijinuwaai, no'o ijinuwapua tiame. Pu'ka wa'a teereniachi ijinuwakao, ma'chiame piiripi tiiame teemea. ");
INSERT INTO var_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","’Neeea ki itipimapua i'wao, nape aapoeo i'wa itipimerapua. Pukachipa muuua te'ta kaaweruma Noonoa, kaawe neesetopuapua pu'kao, aamo mochiwarikopua, pu'kao, apochi kaawe erakoka mochitomichiopua, taamoo pirena te'teriachitia. ");
INSERT INTO var_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Neee i'ka weeechi kahtiaopua pehjio, kaawe inatekame neeea pu'kao, amochi eename inatewarie. Aamo no'o uukeria ajawariopua, yomarika noochi paparaka mochitoamepua, nape piiripia ka'i, Ehkoriami Iyoterichio chiiachitia. ");
INSERT INTO var_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","’Ehpeo aamo kahtiachi no'ramerinia. Nape no'o ahjama ohjokameopua, weeka itapiti kaawe e'rari tuuyekamenia pu'kao, kaawe erakomichiopua noochitia. ");
INSERT INTO var_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Tuuyekame neeeapa pu'kao, yooma aamo iintomia inatarichi eenameopua. Puuu aamo inatarichi eename uukamekaapua, amochi ijinuwa eenepakame puuuapa. Wa'a iikapa puuua, ki i'ka wehjoarichi ahpo ohjorewa iinuekaite puuuapa, noochitia wa'achitia ki i'wa wehjoarichi ohjoekai tiiamepua. Pu'ka i'wa ohjoeraemea, kiisi taamo nakika tetewamepua. ");
INSERT INTO var_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Neeea no'o ahjariao, ki aamo puuyanamichio itaninia i'ka wehjoarichio, ohso kaawe aamo inatejeraninia, i'ka weeechi ki ka'karuma noonoraopua, ka'chi yoramichiopua pu'kao. ");
INSERT INTO var_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Neeea ki i'wa weeechi ohjoerewaemekapao, wa'achi te'tiame no'o ajawariai. Pukaepa aamo neesetojeraninia pu'kao, ki apochi panisumichiopua Satanasio, apochi erapatekao. ");
INSERT INTO var_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Ku'imitia pu'kao, ahpo piipakameche mochitonaretekapua pu'kao, aamo te'ta kaaweruma e'rarie iikachi naawesika, amochiche paparaka ohjoremichiopua pu'kao, kiisi sewina erapaka. ");
INSERT INTO var_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Neeea aamoo, te'ta no'o uhjuraretiachitia weeechi ti'tijoeri nayewemichioo, wa'achitia uhjurakame neeeai pu'kao, yomachi mochiwachiami nayewemichioopua, amochi eename tuuyewario. ");
INSERT INTO var_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Neeea, yomatiame no'o ihsiwachio, aamoche kaaweruma tuuyewari ti'tijoeri tuuyeka ihsikamenia, pu'ka ti'tijoerio te'ta aamo ijinuwara enemichiopua, aamo pichiwariwachi te'ta paparakamekopa. ");
INSERT INTO var_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","’Ki i'kache ajawariawichioche aamo itanenania, yoomawichiopua tiameo, wahjachi amochi paparameriopua pehjíi. Puuupechi nokisimeripua amochi paparatekao, aamo tuuyewari nayeweka tuuyesikao. ");
INSERT INTO var_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Neeea aamo itanenapua tiame ku'imichioo, yooma amochi paparaka mochikameo, te'ta kaawe ahpo nakika mochitomichiopua, te'ta pirena te'tereka, te'ta taamoo, pirena te'teriachitia. Pu'kaonia te'ta tamochitia pirena te'tereka mochitojeraninia, pu'ka aaata ki taamochi te'teriameopua, pichiwako erapamichiopua no'oo, amoe no'o Noono uhjuratiamekoopua. ");
INSERT INTO var_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Neeea yooma noochi paparakameo, piiripi wa'api pirenaturi iintapakamenia, piiripi wa'api pirenaturi teereka ohjoremichiopua, no'oo aamo no'o Noonochiopua tiameo, piiripichitia pirena te'teriachitia. ");
INSERT INTO var_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Neeea pu'ka noochi paparamechio, yasitoamenia no'o Riosiwarieo; muuu no'o Noonoa, noochio yasitoamemua tiameo, piiripi wa'api Riosiwarikapa teemea taamo te'terewachio. Wa'a teereka piiripi Riosiwarichi teemea, yooma aaata pipiripi tamochi paparamechi, yasitoame teemea piiripi teeka taamo Riosiwariwao. Wa'a teekao, aaata ki tamochi paparamea, tamochi paparameo ka'kaweruma itapiti yoorame tetewapaopua, kaawe ahpo nakika mochitoameopua tiameo, nane'rema puuua pu'ka tamochi paparame iikachio, itapiti tísia kaaweruma iinuemekoopua. Waikaopu ki tamochi paparamea, noochi paparapa ka'karuma yoorameko erapamapua, itapiti kaaweruma ijinuemekoopua iikachio. Wa'a erapakaopua, pichiwa no'o tewekachi amochi o'inia eenameko erapamapua, ki oowera tijoeko maaeka. Aapoeoipua waikao, nane'remapua tiameo, wa'achitia ahpo nakiwamekopua amoeo, muuu no'o No'noo, no'no nakiyamechitia. ");
INSERT INTO var_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","’No'noo, yooma tamochi paparakameopua, no'o ahjama mochitejeraninia pu'kao, pu'ka aamo no'o ki'yariaopua newipatemichio. Neeea tetewijeraninia no'o kahtiachi mochikaapa, tetewimichiopua neeea muuukopua, ki ehpesioi wa'apitia ahjaka yasitoame, piiripi tiiarichi wa'api, ke'chu i'ka weee naayachikoipua pehjio. ");
INSERT INTO var_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Muuu no'o Noonoa, Te'ta Kaawerumara muuua, nape i'ka weeechi ki amochi inataka mochitoamea, te'ta kiisi aamo machiyamepua, aamoo te'ta kaawerumarakoipua. Nape neeea, te'ta aamo machiyamerapua, ahkasi aamo te'ta tiiarirachi, aamo wa'api tiiarichi machenakamekapa. Yooma noochi paparakamea, nane'riamepua no'oo, amochi o'inia eenakamekopua. ");
INSERT INTO var_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Pu'kao neeea aamo tiiao, ma'chiame tuuyekamenia, wa'api teetomeri neeea amochi simiyame masitekao, aamo kahtiachi no'rakaio. Wa'a yasaka ku'isimania no'o Riosiwarieo, kaawe ahpo pirena mochitomichiopua pu'kao, kaawe ahpo nakika wa'achitia, taamo ahpo nakiyachitia. ");
INSERT INTO var_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Waikao Eesusi teewesoopua ahpo Noono ahjama nayewakao, ajasika uumatotiapua Seeroni kohjochioopua, paonamina. Paao ajasisaapua waikao, itapiti taakiame echitiachi yeepo muitiápua. ");
INSERT INTO var_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Uurasia Eesusi noriwi na'arekamea, machiyamekapua tiame wa'asi wa'ao, weesa eenakamekapapua wa'ao, taamo Eesusi ahjamao. ");
INSERT INTO var_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Ihji Uurasia, ne'neseriosi pa'pamiratuameo pa'parisero pa'pamiratuameopua tiameo, ahjama ahpo kateweriai puuua, muuwaeme soontaro ahpo kiapuaichiopua Eesusi chapipuamewichio. Ehjepamio Uurasia, muuwaeme soontaro yeeka wa'atikia ihtoame tetewetiapua Eesusi chapisa i'tomia wa'asi. Puuu soontaroa, yoomahka tahjetoka nokisiamekapua, ahpo merimacheta makotoka tiame. ");
INSERT INTO var_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Waikao Eesusia nane'riamekapua ahpo ikimiao, pahcha weripaka pejanao, iinatukekapua, wa'a e'nakameo: —¿Aatana i'yame eemea? ");
INSERT INTO var_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Aapoeo chaachapakapua: —Eesusi, Nasare tijoe. Eesusia waikao chaanekapua ahpo i'yasiameo: —Neeeju puuua. Puuu Uurasi Eesusi noriwi nehjamea, wa'achi weeriapua tiame, Eesusi i'yasiame ahjama. ");
INSERT INTO var_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Puuu Eesusi i'tomia e'enakamea: “Neeepua”, cheekopa Eesusio, ukana ruhjikapua majaka. ");
INSERT INTO var_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Waikao Eesusia eenechi iinatukekapua: —¿Aatana? Aapoeo eenechi nehjiakapua: —Eesusi, Nasare ohjoeme. ");
INSERT INTO var_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Eenechi chaaneka Eesusia: —Neeesakotine. No'o i'yame enesaa, toipuapua no'o ahjama nokisiao, nonoramichioopua. ");
INSERT INTO var_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Wa'a tiiame ikitiamea wa'ao, Eesusi eee cheeria enerepua ahpo Noono ahjama nayewaio: “Aamoe no'o kiatiao, piiripioi ki wekatekamenia.” ");
INSERT INTO var_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Waikao Siimoni Peeroa, ahpo merimachetaeka ma'chipaka, nakachi meteka tehpunekapua ahjamina, pu'ka Marakoo tewaniameopua, te'ta ne'neseriosi weripateriaopua. ");
INSERT INTO var_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Nape Eesusia chaanekapua Peeroo: —Yaapi katewesamua pu'kao. ¿Ki iijimerikosa neeea pu'ka tísia chihpuame iijipasochi, no'o iijimichio no'o Noonoe kiatiame, no'o Noonoe e'rariaeopua? ¿Ki kajuka simitemerine pu'ka, no'o Noonoopua yorajera? ");
INSERT INTO var_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Waikao isaeri ya'yawichi soontarowaraa kapitaiwaraa tiame, chapisa purakapua Eesusio. ");
INSERT INTO var_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Pahchao Aanasi i'yetotiapua, Kaija si'yarao, puuua te'ta ne'neseriosikopua pu'ka taawechiamio. ");
INSERT INTO var_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Puuu Kaijakapua, piie taawechio cheekamekaa: “Epeche kaawe enema piiripi wa'api mukisaa, yoomawichioopua, ki muuwaeme wahjipamichiopua.” ");
INSERT INTO var_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Siimoni Peeroa, neee Waania tiame, mekapi ajatoka na'naritokapua Eesusi i'toniachio. Neeea, machiwamekapapua pu'ka te'ta neeseriosi paamiraeopua, neeea yooremina pakikapua Eesusi i'toniachio, te'ta neeseriosi kaarira ta'perachiopua. ");
INSERT INTO var_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Nape Peeroo, ma'chi itipikapua muiwachio. Ehjepamio neeea, eenechi machenakaonia, wa'a muirachi inatiame oowitiame nayewekania, Peero reesisemichiopua pakimichioopua ta'pechio. ");
INSERT INTO var_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Waikaopu puuu oowitiame iinatukekapua Peeroo: —¿Ki muuupu tiame, i'wa upatiame masitewara? —Ka'i —nehjiakapua. ");
INSERT INTO var_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Tuuroikopao wa'a nu'nurewaa, ihsawi choatiame kosoriapua. Wa'a ikisaopua wa'a ajakapua tatapaka, Peeroai wa'achi kahtiapua waikao na'isue, tatapaka. ");
INSERT INTO var_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Te'ta neeseriosia, iinatukiapua Eesusio ihtana masitia, masiterachi simiyameopua tiameo. ");
INSERT INTO var_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Eesusia nehjiakapua pu'kao: —Yooma tetewachi masitekame neeea ti'tijoeo ooweruopua tiameo. Ki seenepiche simiyame masitekame neeea napawikarichiamiopua, i'isaeri ti'tiopachiamiopua tiame, yooma i'isaeri nanapawiriachiamiopua. Kihta masitekame neeea noriwio. ");
INSERT INTO var_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","¿Achinikai no'o iinatukenamua? Aapoe iinatukepuapua ohso kaawe, no'o masiteria. Puuu nane'renapua no'o cheeriao. ");
INSERT INTO var_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Wa'a chiiopa Eesusio, chokichi weeriameraa, wewekapua chaaneka: —¿Wa'a cheeka nehjianimua te'ta neeseriosi paamiratuameo? ");
INSERT INTO var_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Waikao Eesusia chaanekapua: —Ki kaawe no'o cheekame enesoo no'o chaanepapua ihtanachi ki kaawe no'o cheerio, nape kaawe no'o cheekame enesoo, ¿kihtanawichio no'o wewemetemua? ");
INSERT INTO var_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Aanasia waikao purinurasaopua, Kaija i'yetonurakapua, piirechi te'ta paamiratuame neeseriosi. ");
INSERT INTO var_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Kaija ta'perachio Peeroo tatapoiopua wahjachi ahjamao, aaataa iinatukekapua pu'kao: —¿Ki muuupu tiame puuu tijoe chapitiame masiterawa? Peeroa ahpo noriwitakao, cheekapua: —Ka'iii. ");
INSERT INTO var_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Waikao piirechi tiame Kaija seekaerachi kahtiamea, Peero tehpuneria nahkara tejimaraa, chaanekapua tiame: —¿Ki pa'a aamo tetewikane pu'ka chapitiame ahjama, teewi itapiti taakeri echichi? ");
INSERT INTO var_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Peeroa, eenchi ka'itakapua ahpoo. I'ka ahpo ka'itoiopua, pu'ka wa'apichi kusuchacha totori oowiraai. ");
INSERT INTO var_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Kaija petechi o'iniao, Rooma yawichi ta'perachi i'totiapua waikao, wa'ao peereitaniachi. Wa'a mochioio, ma'chirepapua wa'asi. Nape wenejiameraa i'isaeri ki muikapua wa'ao, ki na'arame teerenariapapua ahpo piipariwachio. Wa'a pakisaapua, ki ko'kome teeremerikapapua Semejenato pahko koi'niameo. ");
INSERT INTO var_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","I'isaerio ki muikopao, Piiratoa machenaka chaanekapua pu'ka Eesusi u'pakameo: —Ti'tijoeee, ¿ihtana wenejina eeme i'ka tijoeo? ");
INSERT INTO var_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Aapoeo chaachakapua: —Kihta iintokame enesoo, ¿aamo u'yepatariamare teeme? ");
INSERT INTO var_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Piiratoa nehjiakapua: —Aamoe i'topapua pu'kao, aamo yooreka mochikae katewepuapua pu'kao. I'isaeri pa'pamiratuamea chaachapakapua waikao: —Merinare teemea pu'kao, nape Rooma yoorewaa, ki taamo toayamepua merimichioo. ");
INSERT INTO var_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Wa'a chaachapariachio, ma'chiame naania tiiamekapua achini yooraka meripuameopua Eesusio, kurusichi chuhchaka. ");
INSERT INTO var_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Piiratoa eenechi pakika peereiniachiopua, Eesusio paaesa iinatukeriapua: —¿Isaeri ti'tijoeri yawichijuarekosa muuua? ");
INSERT INTO var_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Eesusia nehjiariapua: —¿No'o yawichiko e'ranimua amoe, oowerakoi wa'a chaanikosamua, inamukapa? ");
INSERT INTO var_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Piiratoa nehjiariapua: —¿Isaeri tijoekosane nane'remetiao? Ki nane'riame neeea nane'riao, nape aamo tetejimari wa'api, i'wa no'o aamo u'yepakamepua. ¿Ihtana iintokamemu naaju wa'a yorapua? ");
INSERT INTO var_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Eesusia cheerepua waikao: —No'o yawichitumiaa, ki i'ka weeechi enemeri puuua. I'ka weeechi yawichi enesaane ye'kario, iinuemiinia no'o wa'inamerio, ki no'o chapisa kiapuaichioopua i'isaeri ti'tijoerichiopua; nape no'o yawichiwamiachio, ki i'wa weeechipua. ");
INSERT INTO var_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Waikao Piiratoa chaaneriapua: —Wa'a teesoo, ¿pichiwa yawichimua? Waikao Eesusi nehjiakapua: —Eje'e wa'atepua, aamo chiiachitia. Pu'kawichio naawakamenia i'ka weeechi eenakao, yooma ti'tijoerio, te'ta pichiwarichi simiyameo, machitemia. Yooma puuu te'ta pichiwarichi te'terenariamea, no'o te'ta pichiwari chiia, e'wiamerapua. ");
INSERT INTO var_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Piiratoa cheeriapua: —¿Ihtanajuarepu pichiwaria? Wa'a cheesaapua machenakapua eenechi, isaeri ti'tijoeri nayewemia. Chaanekapua pu'kao: —Kihta ki kaaweruma iintokame ihji tijoea, kihta tewakekamenia pukachio ihta ki kaaweruma iintoriao. ");
INSERT INTO var_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Nape eemea senepi Semejenato pahkoio, piiripi peereso maamachipamekopaopua, ¿ki i'kakamera puhjesa toijerani eemea, i'isaeri Yawichikamera Eesusi tewaniame? ");
INSERT INTO var_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Waikao aapoeo weeru chaachapakaopua eenechio: —¡Ka'ii! ¡Pu'kao ka'iii! ¡Warawasikamera puhjepuapuaaa! —chaachapakapua. Nape puuu Warawasia, ichikoamekapua. ");
INSERT INTO var_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Waikao Piiratoa nuurakapua, Eesusi wepipuaichio wepirae. ");
INSERT INTO var_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Eesusi wepisapa soontaroa, yawichi mo'kori netesaopua wehcha apoche, mosokiratekapua na'araka. Wa'a yorasaopua, yawichi wisasori chuhchekapua. Puuu wisasoria, sehtanamekapua teesa. ");
INSERT INTO var_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Waikao soontaroa Eesusi naaepakao, chaaniapua: —¡Née, ne'neopu, isaeri yawichia! —chaachapaka wepayapua sekae. ");
INSERT INTO var_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Wa'a noonowiretioopua Piiratoa, eenechi machenakaopua Eesusi i'tokao, chaanekapua muuwari napawikameo: —Née, ma'chipakania pu'kao tetewimichio, kihta tewakapa pu'kachio, a'chi tiame iintoriaopua ki kaawerumao. ");
INSERT INTO var_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Eesusia wa'a weeriapa waikao, yawichi mo'kori apoche wehcha netetiamee mo'koritetiame. Puuu Eesusia, yawichi wakirata wakiratetiamekapua tiame, tepekuma wakira sehtamurame. Waikao Piiratoa chaanekapua wa'a muuwaeme napawikameopua, ti'tijoeo ooweru tiame: —Wa'a weeriamepu tijoea. ¿Ihtana iintotaria pu'kao? ");
INSERT INTO var_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Waikao puuu te'ta ne'neseriosi pa'pamiratuamea, wahjachi tiameopua yoorewa inatiameapua, Eesusi ne'neka siinakokapua chaachapaka: —¡Kurusichi me'yaaa! ¡Kurusichi me'yaaa! Piiratoa chaanekapua waikao: —Ka'i neeea, ki merinariamenia pu'kao. Te'ta merinaresaa, aamoe wa'api i'toka meripuapua, kurusichi chuhchakao. Neeea utewaeme iinatukeka i'yekai ki kaawe iintorio, kihta tewakamenia pukachio. ");
INSERT INTO var_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Waikao i'isaeri pa'pamiratuamea chaachapakapua: —Ihji tijoe meripuamechepua, wa'a chiiame taamo nuurari yoorewewa mochikaa. Wa'a yorapuamepua, ahpoo Riosichi eenameko tuuyopa, oowera tamochitia tijoekai. ");
INSERT INTO var_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Piiratoa waikao, wa'a tiame inamukapao, tísia seewepakapua pu'kao. ");
INSERT INTO var_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Eenechi yooremina pakikaopua, eenechi iinatukeriapu Eesusio: —¿Akana eename muuua naaju? ¿Ihtana tijoe muuua naaju? Nape Eesusia ki nehjiariapua pu'kao. ");
INSERT INTO var_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Waikao Piiratoa chaaneriapua: —¿Kiisi no'o nehjiamemua? ¿Ki nane'renamua no'oo, aamo merime tiiariemeko kurusichi chuhchakao, no'ooio aamo toime tiiameko? ");
INSERT INTO var_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Eesusia chaanekapua: —Kihta iintomii muuua, ki wa'a tiame teeketiame enesaapua no'o Noonoeo, tepoona o'iniaopua. Nape pukachipa, puuu no'o amochi u'pakameraa, epeche na'ara noonoikamepua. ");
INSERT INTO var_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Wa'a tiame inamukapa Piiratoa, achini teeka toipuaichio i'yakao, Eesusi pejanao ta'omamo o'raipua ti'tijoerio. Nape i'isaeri ti'tijoeria, simitekapua sisinakao, chaachapakapua: —Pu'ka tijoe toisaamua, ki kaawe teeka itipimamua aamo te'ta yawichichiopua Seresa. Aaataai yawichi enepakamea, Seresa seepurawarapua. ");
INSERT INTO var_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Wa'a chaachapopa pu'kao, Piiratoa ma'chipanurakapua Eesusio. Waikao peerei kateweniachi yasirachi yasipakapua, nuurari yasirachi tewaniamechi, Eureo naewaniachio, Kawata, Tehtewetiame Pooe, cheeka chaniwame. ");
INSERT INTO var_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","I'ka nokioio, oowetaweapapua wa'asi, pu'ka meere enemiachikapua Semejenato pahkoo, yooma kateweniachikapua wa'asi, pahkowichioo. Piiratoa chaanekapua i'isaerio: —Née, wa'a weeri aamo yawichiwaa, tesiwa yoratiame. ");
INSERT INTO var_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Nape aapoeo sisinakokapua: —¡Kurusichi me'yáaa! ¡Kurusichi me'yáaa! Piirato chaanekapua: —¿Kurusi chuhchaka meritarene aamo yawichi wa'api? Nape i'isaeri ne'neseriosiai chaachapakapua: —Ki'tiame piirechi taamo yawichiwaa, apoe Seresa yawichichepua. ");
INSERT INTO var_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Waikao Piiratoa, ki'yakapua pu'kao, kurusichi chuhchaka meripuaichioopua, i'toka. ");
INSERT INTO var_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Waikaopua i'totia Eesusia. Waikao wa'a o'inia machenasaopua Eesusia kurusi mahtokao, ahkasi Mukukame Mo'ora Wakiyame tewaniachisi mahtotokapua, Eureo nayewaniachioo, Ókota tewaniachi. ");
INSERT INTO var_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Waikao wa'a ajasitioopua, kurusichi chuchatiapua Eesusia, ooka kurusichi chuchatiame naasipa chuchatia Eesusia. ");
INSERT INTO var_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Wa'a ikitioopua Piiratoa, itapitichi iyotenurakapua Eesusi kurusiwachi chuhchepuame, pukachio chiiamekapua: “Eesusi Nasare tijoe, uurio ti'tijoeri yawichira.” ");
INSERT INTO var_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Muuwaeme wa'a enapaka iyonapua pu'ka wa'a iyotetiameo, waapi muuwarichikopua wa'ao mochiwachio. Pu'ka Eesusi kurusichi chuchatiameo naati, rieko naewachi iyotetiamekapua, raatini nayewaniachi, eureo nayewaniachi tiame. ");
INSERT INTO var_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Pukaepa isaeri ne'neseriosi pa'pamuratuamea, chaachapakapua Piiratoo: —Ka'te iyotemitiamua wa'a kurusichio: “Uurio ti'tijoeri yawichi ihjia” —cheekao. Ohso kaawe iyotemitia muuua kurusichio, eee cheeka: “Uurio ti'tijoeri yawichiko tuukame ihjia.” ");
INSERT INTO var_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Nape Piiratoa nehjiakapua: —No'o iyoteriaa, wa'a chiiame iyotetiame puuuapa. ");
INSERT INTO var_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Kurusichi chuchasaopa Eesusio soontaroa, ahpo naachutekapua wisasorirao, naaochi ahpo. Nape ampawakira tepekumao, yomatiame ihchiamekopa soontaroa, ki si'pananariapao, ");
INSERT INTO var_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","pu'ka ampawakirao, ka'chi iika naachutame tiiamekopa pu'kao, ahpo newitowa te'eriapua pu'kawichioo. Puuu wa'a noonoitiamea, ehkoriami o'inia wa'a teeremio tuutiamekapua, Ehkoriami Riosi Iyoterichio. Puuu Ehkoriami Iyoteria eee chiiamepua: “No'o wisasoriwao ahpo naachutekapua, pu'ka wisasori newitowawichioo, apochi newitowa te'eka.” ");
INSERT INTO var_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Eesusi kurusichi waapio, wa'a ajakamea naatikapua: Eesusi yeeyera, Eesusi ye'chira, Eesusi yeeyera ko'chira tiame, Maaria Kereojá tewaniame uupira, wa'a ikisa Maaria Maarena tewaniame tiame. ");
INSERT INTO var_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Eesusia no'oo, ahpo yeeye ahjama weeriame tetewapao, chaanekapua ahpo yeeyeo: —Ye'yee, aamo chokichi weeriamea, aamo taanapua ehpeo. ");
INSERT INTO var_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Waikao no'oo, te'ta ahpo nakiya weerariao, no'o chaanekapua: —Nee, ehpe waanamio no'o yeeyea, aamo yeeye enemapua. Waika o'inia Eesusi yeeyerao, no'o petechi ohjoetekania. ");
INSERT INTO var_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Wa'a cheesapa Eesusia, nane'riapa ahpo na'ara yorapuao, wa'a tiiame ikimio tuuyo Ehkoriami Iyoterichi chiiao, ahsieme ikimichiopua wa'a chiiameo, cheekapua: —Paramunane. ");
INSERT INTO var_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Wa'aoi kurusitereo wa'a weratiamekapua, itapiti cho'koame to'wame. Waikao wa'a isapatesa itapiti a'potiameo, iisopo kuhsira kuachi chuchasa ki'yakapua wa'apote, Eesusi pi'pika rupitumichiopua. ");
INSERT INTO var_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Eesusia pu'ka pi'pisaopua nerojika, chaachakapua: —Kuuwepakamenia wa'asi. Waikao Eesusia, koomorasipakao ahpo iikao, ahpo Noonochi no'rapukapua. ");
INSERT INTO var_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Waikao isaeri pa'pamiratuamea, pu'ka meere o'ichachikopua, ahpo te'ta iyoriwa taawechiopua pahkoo, Piirato itariaipua Eesusi chapakara kahsinepuaichioo, ikanati mukimichiopua erawisuka. Wa'a tiame itariai Piiratoa, ki tehpe chuchumichiopua wa'ao, amori asiyamekopa resipuniame taawechio, pu'ka kurusichi chuchukuameo ikanati tekipusa katewepuawichiopua waikao, wahjipakame toaniachiopua. ");
INSERT INTO var_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Waikao soontaroa, wa'a e'naka kahsinakapua chapakarao, na'pa Eesusi chokichi kurusichi chuchatiameo, piiripio pahcha, piireo neipa. ");
INSERT INTO var_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Nape Eesusi chapakara kahponemiaio, mukuriopa pu'kaopa, wa'atia toitiapua waikao, ki kahponesa chapakarao. ");
INSERT INTO var_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Nape piiripi soontaroa, nasijicherae checheka yeewatakapua Eesusi wachikachio, wa'a yooratiapao, eera wi'sukapua neerompakame. ");
INSERT INTO var_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Neee Waani te'ta i'ka wa'a tiiame tetewikamea, te'ta pichiwa chiiame neeea. Te'ta pichikepuapua i'kao. ");
INSERT INTO var_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Ihji wa'a tiiame ikitiamea, Ehkoriami Iyoterichi chiiapua, puuua eee chanitiame: “Piiripioi o'wara ki kahsinetiapua.” ");
INSERT INTO var_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Pirenachi Ehkoriami Iyoterichioi, eee chiiamepua tiame: “Puuua tetewipuamepua, chokichi ajakamea, checheka otowinakapua.” ");
INSERT INTO var_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Neipa Eesusi mukusoopua, Oose Arimatéa mochiwachi o'inia eenakamea, Piiratochi eenaka itarepua reesiseri, Eesusi weerewara tekipumio tuuka, wa'a ikisaopua katewenario tuuka wahjipakame toaniachi. Piiratoa waikao, reesiserepua pu'kao. Puuu Oosea, Eesusichi paparame eneriaipua tiame, nape noriwi teereka, seewiapa puuua isaeri ya'yawichio. Waikao Oosea, tekipusapua Eesusi weerewarao, i'tokapua wahjipame toaniachi. ");
INSERT INTO var_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nikoremo tiame, Eesusi ahjama naewakame piie tukao, wa'achi eenakapua tiame, piire weerewa aampa oosa mariki pehtiame u'matoame petejitiame i'toka, sewajuya mirira tewaniame, ároe teewaeme sewajuya ahjama na'petiame. ");
INSERT INTO var_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Waikao Oosea Nikoremo tiamea, riino wisasori peeniajurichi isapatesaopua, ahjae ikapisapa ahpo yoyorachitia isaeri ti'tijoerio, katewemia i'tokapua wahjipame toaniachi. ");
INSERT INTO var_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Eesusi kurusichi mukukachio, waapikapua wa'ao itapiti taakewa echitiachi. Wa'ao, weemera yeewatatiachikapua, mukukame tekipuachi, ki aaata tekiwachiopua pehjio. ");
INSERT INTO var_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Wa'a katewetiapua Eesusia, waapikopa wa'ao ahpo mukiriachio, resipuniame taawechioi asiyachikopua wa'asi, Semejenato pahkowichioo, yooma kateweniachikapua wa'asi. ");
INSERT INTO var_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Maaria Maarenaa, píiiari tukapoi eenariaipua wa'a Eesusi katewetiachio, nape wahjonatiame tewakapa wa'ao, yeetera tehteo ikicha iintapatiame, ");
INSERT INTO var_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","u'masiriapua waikao taamoo tuuyemiao, Peeroopua no'oopua tiame. Puuua tamochi eenakao chaanekapua: —Ma'chipaka i'toretia taamo Paamiraa wahjipame toaniachio, wahka i'toretiare puuua, ki nane'rena teemea i'totiachio. ");
INSERT INTO var_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Wa'a chiiopa Maaria Maarenao, ujumasika teemea, neee Peero tiameo, wa'a wahjipakame toaniachiopua ne'nemia. ");
INSERT INTO var_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Pirena ujumasikai teemea, pahcha asikania wahjipame toaniachio, epeche uwatiame u'masikapa. ");
INSERT INTO var_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Nape pahcha asikainia, ki pakikania. Pakirachi chukipaka yooremina no'o ne'nioipua, wisasorirache wa'a maaniapua sa'runatiame. ");
INSERT INTO var_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Peeroa no'o pukamina asika yooremina pakisao, pu'kachi tetewikapua tiame, riino wisasoriche ahjae ikapitiame wa'a maaniame. ");
INSERT INTO var_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Moochi ikapitiamea wisasori, poanachi yachatiame, kaawe ikapitiame. ");
INSERT INTO var_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Waikao neeea tiame wa'a pakisaopua wahjipame toaniachio, kaawe ne'nesaopua yooreminao, pichiwa oijenario erapakania waikao. ");
INSERT INTO var_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Ki inatepai teemea wa'a tiame ikimioiopua, ki pahteriapa teemea pu'ka Iyoteri Ehkoriami chiiaopua, oijenamio tuuyoiopua pu'kao. ");
INSERT INTO var_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Wa'a tiame tetewisaapua wa'a yooreminao, Peeroa neee tiameo, nonoraka teemea taamo petechio. ");
INSERT INTO var_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Maaria Maarenaa wa'a itipikapua pehji, wahjipame toaniachi ma'chio, naaraka. Maaria Maarenaa wa'a itipikaio eenechi taamo petechi enasaopua, eee tiiame taamo tuuyekapua: —Neeea ma'chi itipisaa naarakao, yooreminapo no'o ne'nioiopua chukipakao, ");
INSERT INTO var_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","wa'a mochikame tetewakane ooka Riosi ku'iwari, tísia totosaname wakiraeme; piiripia Eesusi poiriachi moota kahtiapua, piirea tarachitu. ");
INSERT INTO var_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Puuua no'o iinatukekapua: “¿Achinikai naaranimua?” Waikao nehjiakania pu'kao: “Neeea no'o Paamira ki tewakapa naaramenia, ki nane'riapa ahka i'totiachio.” ");
INSERT INTO var_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Wa'a cheesaania ku'rika no'o ne'nepasoo, waapi weeriame tetewakania aaata, pu'kao Eesusikoi kiisi machiriania. ");
INSERT INTO var_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Puuua no'o, iinatukekapua: “¿Achinikai naarani muuua? ¿Aatana i'yani muuua?” Waikaonia, tísia o'kewaekapaopua ki ma'chiame tetewapaopua Eesusikoio, wa'a echitiame inatiame maaekao, iinatukekania: “No'o Paamira wekatekapa naaramenia, ki nane'riapa aaata i'toriameo. Muuu i'tokame enesaa, no'o tuuyepuapua ahka aamo teekariachio, no'o wa'a siimichiopua i'noramiao.” ");
INSERT INTO var_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Waikao no'o chaanekapua: “Maaria.” Wa'a cheesoche machika inamukania pu'kao. Waikaonia, tísia kaawe erapakao, ku'rika ne'nepakao chaanekania: “¡Naakona muuukaitepua, Masitari!”, eureo naewakao, Raawoni chaniwamepua. ");
INSERT INTO var_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Waikaonia chapakachi koorepakainia, iyoriwa iyoreka Eesusio, nape apoeo no'o chaanekapua: “No'o tooamua pehjio, no'oo ki mooenamekopua pehjio, no'o Noonochiopua. Nape muuua no'o ma'masiterao chaanemitiamua, no'oo, no'o Noono kahtiachi mooenamio tuuyo, pu'kao yooma aamo Noonorachi tiame; puuua apoe no'o Noonoa, no'o Riosiwapua, yooma aamo Riosiwa tiame.” ");
INSERT INTO var_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Wa'asa tiiame taamo tuuyekapu Maaria Maarenaa, taamo petechi no'rasaapua taamo tuuyemiao. ");
INSERT INTO var_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Pu'ka wa'api taawechio amori tukapasipoio, taamo isaeri ya'yawichi majayapao, taamo kariwa yeetesa yooremina mochikai teemea. Nape wa'a te'terenioio yeetaekao, senawato wa'a weeriame tetewika teemea Eesusio. Wa'a werikao taamo teepotekapua cheeka: —¡Kúíra, kaawe erakoka mochiwíii! ¡Ka'te majakóo! ");
INSERT INTO var_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Wa'a cheesapa puuua, taamo ne'netekapua ahpo sekachi, ahpoopua wachikachi chechetiachi tiame. Waikao tísia kaawe erakoa teemea, taamo Paamirao eenechi tetewapa. ");
INSERT INTO var_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Waikao eenechi taamo chaanekapua: —¡Kúíra, iika yachapasa eemeapa amochío! Wa'a cheesaopua taamo chaanekapua: —Neeea no'o Noono no'o uhjurariachitia, wa'achitia aamo uhjurame neeeai, eemepechi simitemichiopua no'o i'wa weeechi o'ineria no'o Noono tehkiwao. ");
INSERT INTO var_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Pu'kawichioo, neeea aamo kiamapua ku'iwario, no'o Noono utewarira utewarieme Riosiwari. Wa'a cheesapao, tamochi pupuchekapua cheeka: —Ía, amochi u'wi eemea, Riosi utewario. ");
INSERT INTO var_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","I'ka Riosi kaaweruma tuuyewari aamo teetoachio, no'o Noono utewarie aamo nayewatuachio, yooma aaata uuka tetewikame aamo nayewatuao, cheriwetiame itipimeripua ahpo tatakoririao, Apoe te'ta no'o Noonoeo. Nape ki apochi uuka tetewikamea pu'ka aamo nayewatuao, wa'atia itipimeripua ahpo tatakoririao, kiisi cheriwetiame no'o Noonoeo. ");
INSERT INTO var_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Toomasia, piiripi puuu oosa mariki aampa ooka Eesusi ajawariaa, puuua tiameo Okasauti teewataniamea, ki'tiaipua taamo ahjamao, Eesusi pukeri pahcha taamo mochikachi machejenoiopua. ");
INSERT INTO var_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Nape teemea neipamio, tuuyekapua chaachapaka: —¡Tetewakasai teemea taamo Paamirao! Nape Toomasia, ohsotia chiiapua: —Oowera wa'a chaachapani eemea, kiisi pichiwakoi. Nooe tetewisaape, pichikemania pu'kao. Ahkasi nooe sutue tahchinesaape raositeretetiachio, ahkasi nooe sekae ne'nesaape wachikachi yeewatatiachiopua tiameo, pichikemania. ");
INSERT INTO var_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Nape osanao taawechi neipao, eenechi taamo napawikoio wa'api ta'pechio, wa'achi kahtiapua waikao Toomasiai, taamo yooremina yeetaeka mochikoio. Wa'a te'terioi taamoo, senawato wa'a weeriame tetewika teemea Eesusio, wa'a yooreminaopua taamo chokichi. Waikao Eesusia, taamo teepotekapua cheeka: —Kúíraa, kaawe erakósa. ");
INSERT INTO var_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Waikao Eesusia Toomasi wa'a tetewapao, chaanekapua: —Ehsoko naaju. Yaapi no'o ne'nesa naaju. No'o sekachi raositeka yeewatatiachio. Yaapi no'o ne'nesao naaju, no'o wachikachi yeewatatiachiopua naaju. ¿Ki neeekosapu naaju Eesusia? Ka'te oosa aampa ki maaemitiamua naaju, pichikemitiachemua. ");
INSERT INTO var_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Waikao Toomasia chaachakapua: —¡Nee, pichiwa no'o te'ta Paamírakamera muuua, Apoe no'o Riosiwa! ");
INSERT INTO var_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Eesusia chaanekapua: —¿No'o tetewapa pichikenapua ehpeo? Ki no'o tetewai pichikiamea, te'ta kaawe erakowa kiapuamepua no'o Noonoeo. ");
INSERT INTO var_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Eesusia muuwaeme itapiti ki maaeniame yoorakapua pehji, nape puuua ki yooma iyotetiamepua i'ka no'o iyotiachio. ");
INSERT INTO var_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Nape ihji no'o iyoteriaa, pukachi aamo pichikemichio puuua, Riosi tiiarie naawakamechi pichikemichiopua, Eesusi Riosie Weratiamechi; yooma aaata pukachi paparakameo, weemera ahjari kiapuamepua pukaeo, ahkasi ki wahjiamesi ahjari. ");
INSERT INTO var_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Neipa i'kao, eenechi tetewitiapua Eesusia, Tiiweria Pa'wechi suuwerachi. Eee teerekapua wa'ao: ");
INSERT INTO var_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Wa'a mochimioi Siimoni Peeroa, Toomasi (Okasauti teewataniame tiame), Natanaéri (Kaana ohjoeme Arirea weeechi), Sewereo tatanara tiameo, wahjachi ooka no'o ahjama Eesusi masitewara tiame. ");
INSERT INTO var_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Waikao Siimoni Peeroa, taamo chaanekapua: —So'chi chapimia siimania, no'o sochichaira i'toka. Waikao teemea, chaanekapua tiame: —Siimpama teemeai aamo ahjama. Wa'a chaachapasao siimpakapua teemeai, so'chi chapimiaopua pawekakerachi. Nape pu'ka tukawarichio, yooma tukao nokakai, kihta chapika teemea. ");
INSERT INTO var_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Piari taaa cherayoio, pukeri asitoa teemea suuwerachio, wa'a weeriame tetewaka teemea aaatao. Ki machikai teemea pukerio, nape Eesusikai teereriapua, puuu aaataa. ");
INSERT INTO var_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Puuua wa'a werikao, taamo sisinamukapua cheeka: —Tehtémariii, ¿weeka chapitú so'chíii? —¡Ka'íii, kihtáaa! —chaachapaka teemea. ");
INSERT INTO var_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Waikao Eesusia taamo chaanekapua: —¡Aamo ahjamina pawekakerachi ipasesa pu'ka aamo sochichairáo, wa'aope chapima eeméaaa! Waikao wa'a ipasao teemea, kiisi chechewa teemea sochichairao, ki ookapi chuchatopa so'chio. ");
INSERT INTO var_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Waikao neee Waania, Eesusi ne'nepaka machikapao, chaanekania Peeroo: —¡Nee naakona! ¿Ki Eesusikaitepu puuu, puuu aaataa taamoo sisinamukamea? Apoe taamo Paamirakaite puuua. Waikao Peeroa, nane'resache Eesusikoopua, yaapiti u'masikapua ahpo wisasoriwa chuchamia, pujakamekapa puuua neerochi tekipanamiapa. Waikao chuchasache wisasorio, ikanati asinariapa Eesusi weeriachi, ikanati neerochi niipaka ka'keka akipakapua. ");
INSERT INTO var_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Teeme pawekakerachi itipikamea, tesiwatia panisutoka pawekakerachi sochichairao, suuwerachisi e'enaka teemea; so'chi chapitiachi o'iniao, kiiya piie siento matokahka eneriapua suuwerachisio. ");
INSERT INTO var_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Wakiyachi puuyasaapa, na'itiame tewitiapua wa'ao, wa'a ihsawichio piiripi so'chi wahseniame po'yapua, paani tiame. ");
INSERT INTO var_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Waikao Eesusia, taamo chaanekapua: —I'norame ookapi so'chi, pu'ka weemera aamo chapiria. ");
INSERT INTO var_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Waikao Siimoni Peeroa, pawekakerachi mooenaka na'sonasaopua sochichairao, suuwerachisi u'pakapua setechi. Póóchikame chuchatome eneriapua, so'chi apoche weeweruma, piire siento ooka weerewa aampa oosa mariki ahka, so'chi eneriapua. Ki ookapikoi so'chi, kiisi tehpuria sochichairaa. ");
INSERT INTO var_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Eesusia taamo chaanekapua waikao: —E'enasa wa'ana ko'komia. Aaataai teemea ki iinatukeme erakoapua aatanakoo, machikapa teemea wa'asi Eesusikoo. ");
INSERT INTO var_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Eesusia pu'ka paanio, chi'wanasa taamo naachutekapua. Wa'achi iintokapua so'chioi chi'wanasa. ");
INSERT INTO var_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Ihji Eesusia paisa simiyachikapua, senawato taamo machejeniachiopua. ");
INSERT INTO var_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Neipa ko'kosepatioopa, Eesusia chaanekapua Siimoni Peeroo: —Siimoni Waani taanara, ¿epeche nahkimua no'oo ki i'ka no'o aamo ajawaria wahjachitia? Peeroa nehjiakapua Eesusio: —Eje'e Paamira, nane'riamemua no'oo aamoo, nakiyamekoo. ");
INSERT INTO var_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Oosa simiyachio, chaanekapua Peeroo: —Siimoni Waani taanara, ¿pichiwa no'o nakiyamemua? Peeroa nehiakapua eenechio: —Eje'e, pichiwa aamo nakiyamenia. Waikao Eesusia chaanekapua: —Kaawe neesetomitia muuua naaju, no'o ijinuwaopua po'wa. ");
INSERT INTO var_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Eesusia Peeroo, paisa simiyachi iinatukekao chaanekapua: —Siimoni Waani taanara, ¿tiiisiwá no'o nakiyamemua? Peeroa, paisa simiyachi ahpo iinatukioio Eesusio, tísia yuuwesipakao, chaanekapua: —Yomatiame nane'riamemua no'oo; nane'riame muuua no'oo, káaatisia aamo nakiyamekoo. Eesusia waikao chaanekapua pu'kao: —Kaawe neesetomitia naaju, no'o ijinuwaopua po'wa, noochi paparakameo. ");
INSERT INTO var_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Pichiwa aamo chaanenania, temarikaio muuua, amoe apechuka seekara wakiratariaipua, waikamio ahkaoi aamo siminariachi siisimiriaimua; nape aamo oochetupasoopua, aaata aamo seekara apechuneka wakiratemapua, ki aamo siminariachi i'toka. ");
INSERT INTO var_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","I'ka Eesusi wa'a cheeriaa, Peero mukimia naewaka cheeriapua, a'chi teeka mukimia pu'kao, Eesusichi simiyame nayewaturiamekapapua. Neipa i'ka cheesao Eesusia, chaanekapua Peeroo: —Nahpesa naaju. No'o na'naritomitiamua. ");
INSERT INTO var_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Waikao neee Waania, wahjachi Eesusi ajawaria ahjama ihtoania, Eesusi pukamina nokisiwachi. Neeekapu Eesusi chokichi kahtiamea, pu'ka Eesusio aari koi'wame koayoio, aaatakamera iinatukekamea Eesusio, aatanakoopua ahpo noriwi nehjimerio. ");
INSERT INTO var_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Waikao Peeroa, no'o Eesusi pukamina ihtoame ne'nepakao, iinatukekapua Eesusio cheeka: —Paamira, ¿ihjipe? ¿Ihtana ikimera puuua? ");
INSERT INTO var_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Eesusia chaanekapua pu'kao: —I'kao no'o tewekachi o'inia eenachisi no'o ahjatenariao, ¿ihtanawichio nane'renariamemua pu'kao? Muuua oowera no'o na'naritopuapua. ");
INSERT INTO var_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Wa'a chaaneriopa Eesusio Peeroo no'o naewaka, yooma Riosichi paparakamechio, no'oo ki no'o mukimeriko erakowa, mehtariapua. Nape ki no'o ki mukimio wa'a cheeka naewariaopua Eesusia. Pu'kao Eesusia oowera chiiapua: “No'o pu'kao, ahkasi tewekachi o'inia no'o eenachisi ahjatenaresoopua seenekachio, ¿ihtana tiiamepua aamowichioo?” ");
INSERT INTO var_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Neee Waania, yooma i'ka no'o iyoterichi chiia, pichiwa chiiame puuua, nooe wa'api Eesusi ahjama oika tetewamekapa. Yooma ehpiami mochitoamea, te'ta pichiwa no'o chiiameko i'ka no'o iyotiao. ");
INSERT INTO var_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Eesusia ki ookapi itapiti yoorariopua pehjio, ki yooma iyotetiamepua i'ka iyotaperichio. Yomatiame Eesusi cheeriaa iintotiame tiameo, yomatiame iyotetiame enesaa, pochikame yasipamiipua yomatiame i'ka wehjoarichio, yomatiame i'ka iyotaperi iyotetiamea, kiisi ojowika. Ehpeonia i'wasioi iyotesa kaawe e'raka itipiamenia, yooma Eesusi inisiria no'o tetewaria iyoteriapua. Wa'asi kajunania no'o iyotiao. Ehpeo cheriwemapua yomatiame i'ka wehjoarichi no'o iyoteria inamukameo. Wa'asipua wa'asi.");
INSERT INTO var_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Kúíra Tiiojiroo, weruma iyoriwa tiiame. Kaaweruma kahtiare muuua. Kaaweruma yasisaamua tísia kaawe enemiipua. Neee aamo iyotepuamea, aamo no'o pahcha simiyame iyoterichi iyotepuriaa, Eesusi Riosie Weratiame iintoria iyotepukamenia, masiteria tiame. ");
INSERT INTO var_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","Pu'kaonia, pukeri o'iniachisi ahkasi tewekachi apechunatiachisi Eesusio, yooma iyotekania iintoriao. Ihji Eesusia ke'chu mooenai tewekachio, ahpo ajawariao Riosi Riosiwarie nuurerepua pu'kao, ahpo nayewatumichiopua pu'kao, neipa ahpo tewekachi mooenasoopua. ");
INSERT INTO var_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Neipa mukukai oijenasaapua, Eesusia ahpo ajawariao, apoe wa'api ahpo tetewiterepua eenechio, ahpo masitera mochikachi machejeneka, ahpo ajawariao, pichiwa ahpo oijenario erakomichiopua. Eesusia ahpo ajawariaopua tiameo, ahpo te'ta Noono ye'karichi simiyame nayewerepua, Apoe tisiwa te'pa kahtiame. ");
INSERT INTO var_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Nape neipa eenechi oijenasaopua tiameo, ahpo ajawaria ahjama koayaio, Eesusia ahpo ajawariao, ki ahka puuyanurerepua Eerusareniopua pehjio. Wa'a cheesaapua eee chaanerepua: —Riosi iintomia puuyemitiapua pehjio, no'oo aamoo ki ehpesi aamo nayeweka yasitoria. ");
INSERT INTO var_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Eemea ehpe taawechiamio, neeroie paatotiamepua Waani Paatorieo, nape ku'we eemea Riosia ahpo Riosiwarie aamo paatomeripua, ahpo utewarie aamo teetomichio apochi simiyame nayewatukaopua. ");
INSERT INTO var_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Piiechi taawechiami neipao, Eesusi ahjama mochikaio, Eesusi ajawariaa, iinatukerepua Eesusio: —¿Paamira, ehpe taawechiami enetarepu aamo yawichitumiaa, yooma i'ka i'isaerichi ikimiaopua? ");
INSERT INTO var_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Waikao pukachi simiyameo, chaanere Eesusia: —Pu'kao ki aamo nane'reporipua pehjio, i'ka itapiti Riosi iintomiaopua, apoekamera Riosi nane'riamekapaopua pu'kao. ");
INSERT INTO var_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Nape ke'chu aamo nane'rioiopua pu'kao, i'ka aamo chaaninia aamoo: Eemea Riosi Riosiwari amochi enasoopua, Riosi utewarie teetomeri eemea no'o nayewatukao, Eerusareni o'inesaopua ahkasi yomachi Uurea weeechiami ohjomeripua, Saamaria weeechiami tiamé, yomachi mochiwachiami, pu'ka noochi simiyame nayewatuwao; neipami eemechitia noochi paparakamea, noochi simiyame nayewatuka nokisimeripua, ahkasi yomatiame i'ka wehjoarichi mochiwachiami, noochi paparamichio nayewatukao. ");
INSERT INTO var_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Neipa i'ka cheesaapa Eesusia, ne'neka ajanioipua pehjio Eesusia, tewekachi apechunaretupua, ahkasi toomarichi wekaka. ");
INSERT INTO var_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Pu'ka ne'neka ajakoiopua pehjio, senawato Eesusi ajawaria chokichi ajakame tetewiretupua ooka ti'tijoe, totosáme wakiraeme. ");
INSERT INTO var_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Ihji ooka Riosi ku'iwaria chaachaparepua: —Arirea ti'tijoérii, ¿achini iika wa'a teeka ne'neka itipina eemea pu'ka tewekachi mooenaka akipariachio? Puuu wa'api Eesusia, ahpo wa'achi teeka tewekachi mooenariachitia, wa'achi teeka eename tetewipuamepua, kii ookapi ti'tijoeri yeeka tekiyame tewekachi o'iniao. ");
INSERT INTO var_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Waikao wa'a ijikisaapua wa'a kaawichi Ooriwo taakeri echitiachi tewaniachi o'iniao, yoomahka Eerusareni e'enarepua eenechi, sawarachi oiwa keenako reesisewachi. ");
INSERT INTO var_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Puuu Eesusie ajawatiamea, Eerusareni nonowasaapua, raampakarichi mo'moenarepua wa'a naanapawika mochikachi, naatia: Peero, Aakowo, Waani, Anteresi tiame, Eeripe, Toomasi, Waatorome tiame, wa'a ikisa Maateo, Aakowo Arajeo taanara, Siimoni We'muame teewataniame, naati tiame, Uurasi Aakowo poonira. ");
INSERT INTO var_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Wa'ao yooma puuua, wa'a nanapawiame eneriaipua Riosichi iyoriwa nayewamia, Maariaa Eesusi yeeyera, Eesusi poponiraapua tiame, wahjachi ooweru tiame. ");
INSERT INTO var_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Seenepi simikame Eerusareni wa'apiopua napawitioio, Peeroa werisika nayewerepua napawikameo. Wa'a napawikamea, piire siento aampa piire weerewahka napawiriaipua. Pu'ka napawikameo Peeroa, chaanerepua: ");
INSERT INTO var_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","—Riosichi poponiwaa pipiniwa tiame, no'o keepumitiaopua ku'witapio. Ehkoriami Raawitaru iyoteriaa Riosi Riosiwarieo, aaata wahka ihtoriachi na'ara iintomeriko tuuriaa, ikikache itipirupa puuua. Uurasi wa'a iintomia nayewaka cheeriamepua, Uurasia pichiwa wa'a iintokamekopapua, pichiwa muuwaeme yeeka eenakamepua Eesusi chapisa i'topuawichioopua. ");
INSERT INTO var_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Puuu Uurasia, Eesusi ahjama taamo ohjoio, wa'a iintokamepua Eesusi na'arekao. ");
INSERT INTO var_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Pu'ka na'ara iintoriao teemekamera tetewikamepua, ahpo Eesusi na'ara iintoria nateteretiaeopua, weee tarariamekopua Uurasio. Wa'a iintosaopua neipao, tekoratatipo wichika, yooma ta'pariamepua topachio, ma'chi wichika siiwarao. ");
INSERT INTO var_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Uurasi ikiriao, yooma Eerusareni ohjoeme ti'tijoeria, tísia nane'reka ohjoemepua pu'kao. Pukaepa pu'ka we'e tarariao, Akerama teewaretupua, rieko nayewarichio, puuu weee wa'a teewaraa, Eeraeme Weee cheeka chaniwamepua. ");
INSERT INTO var_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Uurasi ikiriaa, te'ta Wiika Iyotaperichi chiiachitia ikirepua, Raawi iyoteriachitiaopua, ehkoriamio. Wiika Iyoterichio eee cheeriame puuua: Uuruchi toipuapua ohjirao, ki aaata ohjoepuapua wa'ao. Puuua cheeriamepua tiameo: Pu'ka tehkiwa teetoriachio, piirechi werapuapua. ");
INSERT INTO var_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","’Pukaepa Uurasi tehki towariachio, piirechi werapuamepua, nape Eesusiche ahjama oikame, iiweta Apoe Paamirao, taamo ahjama oiyoi. ");
INSERT INTO var_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Nape puuua Eesusio, Waanie paatoniachisi o'inia, ahkasi tewekachi mooenariachisi tetewikame enemeripua. Te'ta pu'ka tetewakame nakiwamepua, taamo ahjama pichiwatamichiopua Eesusio, pu'kao, te'ta pichiwa oijenakamekopua. ");
INSERT INTO var_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Waikao wa'a cheesoopa Peeroo wa'a raampa karichi napawitiachio, Eesusi ajawariaa ooka ne'neparepua waikao werapuameo, Uurasi Eesusie weratiamechitia teetomichiopua, aaata pu'ka ooka uutiameo, Riosie uutiamekoopua werapuawichioo. Piiripi puuua, Oose enerepua werapuamea, Warawasi teewataniame, Uhto teewataniameopua tiame. Piirea, Maatia tewaniame enerepua. ");
INSERT INTO var_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Waikao Riosichi nayewarepua, chaachapaka: —Muuu No'no tewekachi kahtiameraa, muuu te'ta machiyamerakapa pu'ka ti'tijoeri iikara te'teriao, taamo ne'netepuapua aatanakamerakopua taamo weramiao, i'ka ookao. Amoe uupuapua i'ka werapuameo, ");
INSERT INTO var_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","i'ka Uurasi teetoriachi tehki werapuawichioopua, Uurasio simikamekopua pu'kaopua wa'asio, ahpo te'ta kokosa aiwamiachiopua wa'asio, ahpo ki kaawe iintoriawichioo. ");
INSERT INTO var_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Waikao puuu oosa mariki aampa piiripi Eesusi ajawariaa, aaata pu'ka ooka piiripi werapuame inatariao, itapiti ihpapaka nane'repuamechi iyoterepua teewarao, pu'ka ihpapaniamechio nane'repuawichiopua Riosio, aatanakamera e'rariopua werapuameo. Waikao Riosie nane'repuame ihpapatiamechio, Maatiachikamera wichirepua werapuamea. Wa'a yooraka nane'retioopua Riosie eratiameo, Maatiakamera weraretupua, Uurasi tehkiwara teetoriamechioopua. Waika o'inia Maatiaa, Eesusi ajawaria ahjama oisirepua, Uurasi tehkiwaeria yorasika, pu'ka Eesusi oosa mariki aampa piiripi ajawari ahjámao. ");
INSERT INTO var_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","I'ipari pahko asisoopua, yooma puuu oosa mariki aampa ooka Eesusi ajawaria napawiriachiopua, ");
INSERT INTO var_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","senawato te'pa tewekachi o'inia inamuretupua, weruma eeka cheetoamechitia. Puuu cheetochaniamea Eesusi ajawaria mochikachi, pochikame yasiparepua. ");
INSERT INTO var_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Waikao weeka yeenika tiiame puuyarepua, na'ika tiame tajenarieme. Puuu na'i yeenia yooma Eesusi ajawariachi moochi chachasoopua yomatiame wa'a yooremina mochikamechio, pochikame yasipare Riosi Riosiwaria. ");
INSERT INTO var_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Wa'a iikaopua Eesusi ajawariaa, pochikame ahjachi muipaterepua Riosi Riosiwario, yooma ihtaoi seesenu naeraoi kajuteka, Riosi Riosiwarie kiaretia iiyenawa. ");
INSERT INTO var_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Pu'ka wa'a ikinioio Eesusi ajawariao, puuua yomachi weeechi Eerusareni e'enakamea, yooma Eerusareni mochikameapua tiameo, pu'ka weruma eeka ahpo inamuriachi, ujumasirepua ne'nemia. ");
INSERT INTO var_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Waikao Eesusi ajawariaa wa'a e'enakameopua, yooma aaata pipiripi naewarichi, iiyenaka nayewerepua. Waikao wa'a e'enakame seesenu ti'tijoeria, ahpo wa'api naewachi nayewetiaopua Eesusi ajawariaeo, tísia wekamuwa erakorepua. ");
INSERT INTO var_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Waikao ahpo nayewa nayewachaniopao, tahpitika erakokao, chaachaparepua ahpoo: —¿Ihtana ijikikame ohjoare naaju ihji ti'tijoea? Naakona, ¿ki Arirea ohjoemekosapu ihji ti'tijoe? ");
INSERT INTO var_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Nape Arirea ohjoeme enesaa, ¿achini iika taamo nayewa nayewachaniamepua, yooma pipiripi taamo seesenu nayewamechi? ");
INSERT INTO var_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Ihji ti'tijoeri ahpo seesenu naewachi inamukamea, wekanami weeechi o'inia e'enakamepua: Paratia weeechi e'enakame, Meeria weeechi e'enakame, Eerami e'enakame, Meesopotami e'enakame, Uurea e'enakame tiame, Kaparosia e'enakame wa'achi, Poonto e'enakame, Aasia e'enakame tiame, ");
INSERT INTO var_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","wa'a ikisa Rijia e'enakame, Paanjiria e'enakame tiame, Eejito e'enakame tiame, Riiwia weeechi e'enakame tiame, Siirene weeechi waapi. I'wa nookapua tiameo, Rooma muuwarichi e'enakame, Iitaria weeechi o'inia; ookapi ihjia i'isaeri naawakame enerepua, epeche ookapi puuua isaeri enepakamepua. ");
INSERT INTO var_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","I'wachi nookapu tiameo, Kereta e'enakame, Aarawia weeechi e'enakame tiame. Yooma ahka ma'chiame pahteka inamuame teemea pu'ka Eesusi ajawariao, ma'chiame taamo nayewa nayewachaniamekoo, Riosio yooma ihta peenia iintoriamekoopua taamowichioo. ");
INSERT INTO var_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Yooma ihji ti'tijoeria, ki nu'unti peenia erakorepua, ki teesá peenia tiame ikitiopua wa'ao. Wa'a erakoapaopua, chaachaparepua ahpoo: —¿Ihtana ikiwame i'wao? ¿Ihtanapua? ");
INSERT INTO var_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Nape aaata wahjachia, na'arakao chaachaparepua: —Aa puuua, nawajikamepua. ");
INSERT INTO var_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Wa'a chaachapopa Peeroa, yooma pu'ka Eesusi ajawaria ahjama weripakao, pu'ka ti'tijoeri ahpoo nawajiame teewariao, weeru sisinaka chaanerepua: —Yooma ti'tijoeri yomachi e'énakamea, yooma i'wa Eerusareni ohjoeme tiaméa, kaawe no'o keepumitiapua pahchuo. ");
INSERT INTO var_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Teemea, kiisi nawajika chaachapamepua. ¿Aatana nawajita piarikooiopua pehjio? ");
INSERT INTO var_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Ihji taamo ikiyaa, ehkoriami chanitiamepua, Ooeri iyoteriachi, Riosi nayewatura. Ihjia cheeka iyoteriaipua: ");
INSERT INTO var_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Neipami taawechiamio, Riosi nayewatura kajumiachiopua wa'asio, Riosia cheeriaipua: Yooma weeechi mochikamewichioo, no'o Riosiwari kiamania pu'kao; yooma noochi paparameo, aamo tatana tehtemario, no'o kaaweruma nayewamichiopua, aamo mamaraopua tiame, wa'achi chaachapamichio; aamo tehtemario, ka'karuma yoorari inatatemichiopua pu'kao; o'ochetiamea yayawatiamea tiame, peenia tiame teemumichiopua kochirewachio, ahpo peenia erakoa tewekachi mochipua. ");
INSERT INTO var_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Pu'ka taawechiamio, no'o seekarachitia mochikameo, ti'tijoeo ooweruo tiameo, no'o Riosiwari yahchemania pu'kao, noochi simiyameo peeneka nayewamichiopua, ki se'wi simiyame; ");
INSERT INTO var_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Neeea tewekachio, itapiti tetewitemania neipamio, itapiti peeniatiwari uurapari tetewitemania neipami teetomeri wa'asi, wehchioi itapiti eera uurapari teetotemania waikamio, itapiti na'i uurapari tiame, itapiti morowa tiame. ");
INSERT INTO var_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Taaaai tukapamapua, meechaai eeraka tiiame ikimapua sehtanasipaka, ke'chu no'o aamo Paamirao Riosi Tijoetukame eenoio pehjio, yooma wa'a tiiame teetomeripua, nape no'o Taana eenaiopua Tijoe Tijoetukameopua, tahpitika teetoka enameripua, pu'ka taawechio. ");
INSERT INTO var_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Yooma pu'ka Riosi Tijoetukamechi paparakamea, newipatepuamepua pukaeo, tatakoriwao. ");
INSERT INTO var_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","’Eeme i'isaeri ti'tijoeria, keepusa i'ka naawesari: Nane'rena eemea Eesusi Nasare ohjoemeo, Riosie weratiamekopua pu'kao, pu'ka weruma itapiti, peenia tiame ihsiriapa, Eesusia pukae peenia ihsiawae ahpo pichiwatarepua, pichiwa Riosie weratiamekopua ahpoo, pu'ka taamo nane'reka mochitomichiopua. ");
INSERT INTO var_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Nape ihji Eesusichi ikitiamea, Riosi e'rariachitia teerekamepua, Apoe Riosi Taanarao, amochi kiatiamekopua meripuaichio. Eeme wa'api nokakamepua pu'kao, nanaaramechi ki'yakao. Pukaepa wa'a noonoire eemea, kurusichi meripuaichioo. ");
INSERT INTO var_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Nape Riosia i'ka ahpo Taana Eesusio, eenechi ahjatere puuua, oijenatekao. Wa'a iintoka Riosia Eesusio, newitoterepua wahjipaniameo; wahjipaniameo ka'chi iika newitome tiiamekopua Eesusio. ");
INSERT INTO var_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Taamo yawichi ehkoriami Raawitaru ikipo tuuriai, i'ka Eesusi ikiria cheeka cheekame puuuai, eee cheeka iyotiaiopua: Neeea no'o Noonoo, ki piineri no'o toaka tetewamepua, pukaepa no'oche ahjama inisiame tetewamenia, pukaepa ki majayamenia noochio, apoeo no'o ahjamakopua pu'kao. ");
INSERT INTO var_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Pukaepa peenia e'raninia noochio, no'o iikachio, pukachi ahjachi e'rapa; pukaepa no'o yeenieoi, ta'iria nayewamenia wa'a e'rapa; no'o weerewaai ahjachi e'ramepua, ahpo oijenatepuao mukukai, amoeopua No'noo. ");
INSERT INTO var_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Muuua no'o iikaoi, ki toimapua wahjiparichio, aamo Taana Te'ta Piipari weerewaraoi, kiisi toimamua pikamichioo. ");
INSERT INTO var_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Muuua no'o tetewitekamemua aachin iintoka no'o mukukoio, eenechi no'o ahjatemio; wa'a ikitiapao neeea, tísia ta'iria yasitomerikopua, aamo kahtiachi ahjamao. ");
INSERT INTO var_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","’Ihji ehkoriami Raawi wa'a cheeriao, ma'chiame ki ahpo weerewa nayewaka cheerepua, apoeai Raawitaruo, wetemajitiamekopua mukisoo, i'ka Raawitaruo tetewikame teemea wetemajitiachio. ");
INSERT INTO var_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Ihji Raawitarua Riosie naewaniamekapa, ma'chiame tiiame enerepua, i'ka Riosi ahpo chaaneretiao, pichiwa ahpo tetejimarisiwachi machenamerikopua piiripi aaata yawichi, ahpo tetejimariwachi yawichitumeri. ");
INSERT INTO var_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Wa'a tiame pahtekapa Raawitarua, ke'chu ehpiami simiyame ikiyoiopua pehjio; pukaepa, wa'a cheeka iyoterepua Eesusi oijenatepuao, ka'chi iika pikamerikopua weerewarao, wa'a iikaopua, kiisi itipimerikopua wahjiparichio mukukaio. ");
INSERT INT