﻿USE sofia;
DROP TABLE IF EXISTS sofia.vaa_vpl;
CREATE TABLE vaa_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES vaa_vpl WRITE;
INSERT INTO vaa_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","ಹೈರಿತೆ ಯೇಸು ಕ್ರಿಸ್ತನಿ ಗುರುಗುರಬ್‍ಲ್ಯಾನಿ ಪಟ್ಟಿ: ಯೇಸು ದಾವೀದನೊ ಖಾಂದಾನ್‌ವಾಳೊ, ದಾವೀದ ಅಬ್ರಹಾಮನೊ ಖಾಂದಾನ್‌ವಾಳೊ. ");
INSERT INTO vaa_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","ಅಬ್ರಹಾಮ್ ಇಸಾಕನೊ ಬಾ, ಇಸಾಕ್ ಯಾಕೋಬನೊ ಬಾ, ಯಾಕೋಬನ ಯೆಹೂದ ಅಜು಼ ಇನ ಭೈಯೇ ಪೈದಹುಯ. ");
INSERT INTO vaa_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","ಯೆಹೂದ ಪೆರೆಚ ಅಜು಼ ಜೆರಹಾನೊ ಬಾ (ಅವ್ಣಿ ಆಯ ತಾಮರ), ಪೆರೆಚ ಹೆಚ್ರೋನನೊ ಬಾ, ಹೆಚ್ರೋನ ಅರಾಮನೊ ಬಾ. ");
INSERT INTO vaa_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","ಅರಾಮ ಅಮ್ಮಿನಾದಾಬನೊ ಬಾ, ಅಮ್ಮಿನಾದಾಬ ನಹಶೋನನೊ ಬಾ, ನಹಶೋನ ಸಲ್ಮೋನನೊ ಬಾ. ");
INSERT INTO vaa_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","ಸಲ್ಮೋನಬಿ ರಾಹಾಬನೊ ಛಿಯ್ಯೊ ಬೋವಜ, ಬೋವಜಬಿ ರೂತ್‍ನೊ ಛಿಯ್ಯೊ ಓಬೇದ, ಓಬೇದ ಇಷಯನೊ ಬಾ. ");
INSERT INTO vaa_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","ಇಷಯ ದಾವೀದ್‌ ರಾಜಾ಼ನೊ ಬಾ, ದಾವೀದ ಸೊಲೊಮೋನನೊ ಬಾ (ಸೊಲೊಮೋನ್ನಿ ಆಯ ಪಹಿಲೆ ಉರಿಯಾನಿ ಬಾವಣ್‍ ಹುಯಿರ‍್ಹೀಥಿ), ");
INSERT INTO vaa_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","ಸೊಲೊಮೋನ ರೆಹಬ್ಬಾಮ್ನೊ ಬಾ, ರೆಹಬ್ಬಾಮ ಅಬೀಯನೊ ಬಾ, ಅಬೀಯ ಆಸನೊ ಬಾ. ");
INSERT INTO vaa_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","ಆಸನ ಯೆಹೋಷಾಫಾಟನೊ ಬಾ, ಯೆಹೋಷಾಫಾಟ ಯೆಹೋರಾಮನೊ ಬಾ, ಯೆಹೋರಾಮ ಉಜ್ಜೀಯಾನೊ ಬಾ. ");
INSERT INTO vaa_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","ಉಜ್ಜೀಯ ಯೋತಾಮನೊ ಬಾ, ಯೋತಾಮ ಆಹಾಜನೊ ಬಾ, ಆಹಾಜ ಹಿಜ್ಕೀಯಾನೊ ಬಾ. ");
INSERT INTO vaa_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","ಹಿಜ್ಕೀಯ ಮನಸ್ಸೆನೊ ಬಾ, ಮನಸ್ಸೆ ಆಮೋನನೊ ಬಾ, ಆಮೋನ ಯೋಷೀಯಾನೊ ಬಾ. ");
INSERT INTO vaa_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","ಯೋಷೀಯಾನ ಯೆಕೊನ್ಯ ಅಜು಼ ಇನ ಭೈಯೇ ಪೈದಹುಯ. ಯೆಹೂದ್ಯರ್‌ನ ಅದ್ಮಿನ ಬಾಬೇಲ್‌ನ ಧರ್‌ಲಿಗಯೂತೆ ಯೋ ವಖ್ಹತ್‌ಮ ಅವ್ಣೆ ಪೈದಹುಯುತೆ. ");
INSERT INTO vaa_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","ಯೆಹೂದ್ಯರ್‌ನ ಅದ್ಮಿನ ಬಾಬೇಲ್‌ನ ಧರಿಲೀನ್ ಜಾ಼ವಾನ ಬಾದ್‌ಮ, ಪೈದಹುಯುತೆ ಇವ್ಣಿ ಖೇಣಿ, ಯೆಕೊನ್ಯ ಶೆಯಲ್ತಿಯೇಲ್‌ನೊ ಬಾ, ಶೆಯೆಲ್ತಿಯೇಲ್ ಜೆರುಬ್ಬಾಬೆಲ್‍ನೊ ಬಾ. ");
INSERT INTO vaa_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","ಜೆರುಬ್ಬಾಬೆಲ್ ಅಬಿಹೂದನೊ ಬಾ, ಅಬಿಹೂದ ಎಲ್ಯಕೀಮ್‌ನೊ ಬಾ, ಎಲ್ಯಕೀಮ್ ಅಜೋರನೊ ಬಾ. ");
INSERT INTO vaa_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","ಅಜೋರ ಸದೋಕನೊ ಬಾ, ಸದೋಕ ಅಖೀಮನೊ ಬಾ, ಅಖೀಮ ಎಲಿಹೂದನೊ ಬಾ. ");
INSERT INTO vaa_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","ಎಲಿಹೂದ ಎಲಿಯಾಜರನೊ ಬಾ, ಎಲಿಯಾಜರ ಮತ್ತಾನನೊ ಬಾ, ಮತ್ತಾನ ಯಾಕೋಬನೊ ಬಾ. ");
INSERT INTO vaa_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","ಯಾಕೋಬ ಯೋಸೇಫ್‌ನೊ ಬಾ, ಯೋಸೇಫ ಮರಿಯನೊ ಬಾವ್ರಿ. ಮರಿಯ ಯೇಸುನಿ ಆಯ, ಯೇಸುನ, ಬಚಾ಼ಡವಾಳೊ ಕ್ರಿಸ್ತ ಕರಿ ಚಿಕರ್ತುಥು. ");
INSERT INTO vaa_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","ಅಬ್ರಹಾಮ್‍ಥು ಧರಿನ್ ದಾವೀದತೋಡಿ ಚೌ಼ಧ ಮುಂಡಿ, ದಾವೀದ್‌ಥು ಧರಿನ್ ಬಾಬೇಲ್‌ನ ಧರಿಲಿಗಯೂತೆ ಇವ್ಣಾತೋಡಿ ಚೌ಼ಧ ಮುಂಡಿ, ಬಾಬೇಲ್‌ನ ಧರಿಲಿಗಯೂತೆ ಹಿಜ್ಜಾ಼ಥು ಧರೀನ್ ಕ್ರಿಸ್ತಲಗು ಚೌ಼ಧ ಮುಂಡಿ. ");
INSERT INTO vaa_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","ಯೇಸು ಕ್ರಿಸ್ತ ಪೈದಹುಯೊತೆ ಕಿಮ್‌ಕತೊ; ಇನಿ ಆಯ ಮರಿಯನ ಯೋಸೇಫ್‌ಥಿ ಖ್ಹಗೈ ನಾಖಿರಾಖ್ಯೂಥು, ಕತೋಬಿ ಇವ್ಣೊ ವ್ಯಹಾ ಹುವಾನ ಅಗಾಡಿಸ್, ಯೋ ಪವಿತ್ರಾತ್ಮಾಥಿ ಬೇಜೂನಿ ಹುಯಿರ‍್ಹೀಥೀತೆ ಇನ ಮಾಲುಮ್‌ಪಡ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","ಯೋಸೇಫ ಏಕ್‌ ನೀತಿವಾಳೊ ಅದ್ಮಿ ಹುಯಿರ‍್ಹೋಥೊ, ಇನಖ್ಹಾಜೆ ಯೋಸೇಫ ಅದ್ಮಿನ ಖ್ಹಾಮ್ಣೆ ಮರಿಯನಿ ಖ್ಹರಮ್‌ ನಾ ಕಾಡ್ಣು ಕರಿ, ಕಿನಾಬಿ ಮಾಲುಮ್‌ಪಡ್ಣುನಾತೆ ಇಮ್‌, ಖ್ಹಗೈನ ತೋಡಿನಾಕ್‌ಣು ಕರಿ ಥೊ. ");
INSERT INTO vaa_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","ಯೋ ಇಮ್‌ ಸೋಚುಕರಾನಿ ವಖ್ಹತ್‌ಮ, ದೇವ್ನದೂತನೆ ಇನ ಖ್ಹೋಣ್ಯಮ ದೆಖೈನ್, “ದಾವೀದನೊ ಖಾಂದಾನ್‌ವಾಳ ಯೋಸೇಫ, ಮರಿಯನ ತಾರಿ ಬಾವಣ್‍ ಕರಿಲ್ಯವಾನ ಡರ್‌ನಕೊ. ಯೋ ಪವಿತ್ರಾತ್ಮಥೀಸ್ ಬೇಜೂನಿ ಹುಯಿರ‍್ಹೀಸ್ತೆ. ");
INSERT INTO vaa_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","ಯೋ ಏಕ್‌ ಪರ್ಖ್ಹೊ ಲಡ್ಕಾನ ಜ಼ಣ್‌ಶೆ, ತೂ ಇನ ಯೇಸುಕರಿ ನಾಮ್ ಮ್ಹೇಲ್ನು. ಶನಕತೊ, ಯೋ ಇನ ಅದ್ಮಿಯೇವ್ನ ಪಾಪ್‌ಮಾಥು ಬಚಾ಼ವ್‍ಶೆ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","ಪ್ರಭುನೆ ಪ್ರವಾದಿಯೇನ ಮ್ಹೋಡವಾಟೆ ಬೋಲಾಯೋತೆ ವಾತೆ ಖ್ಹಾರು ಚಾ಼ಲಾನಟೇಕೆ, ಆ ಖ್ಹಾರು ಚಾ಼ಲ್ಯುತೆ. ");
INSERT INTO vaa_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","ಯೋ ವಾತೆ ಶಾತ್‌ಕತೊ, “ಹಂದೇಖೊ, ಏಕ್‌ ಕವಾರಿ ಬೇಜೂನಿ ಹುಯಿನ್, ಏಕ್‌ ಛಿಯ್ಯಾನ ಜ಼ಣ್‌ಶೆ. ಅಜು಼ ಇನ, ‘ಇಮ್ಮಾನುವೇಲ್’ ಕರಿ ನಾಮ್ ಮ್ಹೇಲ್‌ಶೆ!” ಇಮ್ಮಾನುವೇಲ್ ಕತೊ, “ದೇವ್ ಅಪ್ಣ ಜೋ಼ಡೆ ಛಾ಼” ಕರಿ. ");
INSERT INTO vaa_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","ಯೋಸೇಫ ನಿಂದರ್‌ಮಾಥು ಹೊಷಾರಿ ಹುಯಿನ್ ಉಠಾನ ಬಾದ್‌ಮ, ದೇವ್ನದೂತನೆ ಬೋಲ್ಯೋತೆ ಇಮ್ಮಸ್, ಮರಿಯನ ವ್ಯಹಾ ಕರಿಲಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","ಕತೋಬಿ ಮರಿಯ ಛಿಯ್ಯೊ ಪೈದಾಕರಾತೋಡಿ, ಯೋಸೇಫ ಇನಜೋ಼ಡೆ ಖ್ಹುತೊಕೊಯ್ನಿ. ಯೋಸೇಫ್‌ನೆ ಯೋ ಲಡ್ಕಾನ ಯೇಸು ಕರಿ ನಾಮ್ ಮ್ಹೇಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","ಹೆರೋದ ರಾಜ಼ ಹುಯಿರ‍್ಹೊಥೋತೆ ವಖ್ಹತ್‌ಮ, ಯೂದಾಯ ತಬರ್‌ಖಾನು ಬೇತ್ಲೆಹೇಮ್ ಕರಿ ಗಾಮ್ಮ ಯೇಸು ಪೈದಹುಯೊ. ಅನಬಾದ್‌ಮ, ಥೋಡು ಗ್ಯಾನಿ ಅದ್ಮಿಖ್ಹಾರು, ಪೂರಬ್ ದಿಕ್ನು ದೇಖ್ಹ್‌ಥು ಯೆರೂಸಲೇಮ್‌ನ ಆಯಿನ್, ");
INSERT INTO vaa_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","“ಯೆಹೂದ್ಯರ್‌ನೊ ರಾಜಾ಼ ಹುಯಿನ್ ಪೈದಹುಯುತೆ ಲಡ್ಕು ಕಿಜ಼್ಜಾ ಛಾ಼? ಯೋ ಪೈದಾಹುಯು ಕರಿ ಖ್ಹಣೇದ್ ವತಾಳಸ್ತೆ ಶುಕ್ಕರ್‌ನ, ಹಮೆ ಪೂರಬ್ ದಿಕ್‍ಥು ದೇಖಿನ್, ಇನ ಆಡ್‍ಪಡಿನ್ ಖ್ಹಲಾಮ್ ಕರಾನ ಐರ‍್ಹಾಸ್” ಕರಿ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","ಅನಖ್ಹಮ್‌ಜಿನ್, ರಾಜ಼ ಹೆರೋದನ ಅಜು಼ ಇನಜೋ಼ಡೆ ಯೆರೂಸಲೇಮ್‌ನು ತಮಾಮ್‌ ಅದ್ಮಿನ ದಿಲ್ಮ ಘಣು ಕಲಾವ್ಣಿ ಹುಯು. ");
INSERT INTO vaa_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","ತದೆ ಹೆರೋದನೆ ಯೆಹೂದ್ಯರ್‌ನ ಖ್ಹಾರಸ್ ಗಲ್‌ಢಯಾಜಕರ್‌ನ ಅಜು಼ ವಚನ್ ಶಿಕಾಡವಾಳ ಪೊಂಡಿತ್‍ನ ಎಕ್ಟು ಕರೀನ್, “ಕ್ರಿಸ್ತ ಪೈದಾ ಹೋಣುತೆ ಕಿಜ಼್ಜ?” ಕರಿ ಪುಛಾ಼ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","ಇವ್ಣೆ ಇನ, “ಯೂದಾಯ ತಬರ್‌ಖಾನು ಬೇತ್ಲೆಹೇಮ್ಮಾಸ್, ಶನಕತೊ-ಪ್ರವಾದಿವ್‍ನೆ ಅಮ್‍ಬೋಲ್ಯುಕಿ; ");
INSERT INTO vaa_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","ಯೆಹೂದ ತಬರ್‌ಖಾನು ಬೇತ್ಲೆಹೇಮ್, ಯೆಹೂದನು ಮುಖ್ಯ ಖ್ಹಯೇರೇಥಿ, ತೂ ಎತ್ರೇಬಿ ಶಾತ್ ನ್ಹಾನು ಕಾಹೆ. ಶನಕತೊ ತಾರ ಮಹಿಥು ಏಕ್‌ ಅದಿಕಾರಿ ಆವ್‌ಶೆ, ಯೋ ಮಾರು ಅದ್ಮಿ ಹುಯಿರ‍್ಹೂತೆ ಇಸ್ರಾಯೇಲ್‌ನ ಚ಼ಲಾವವಾಳೊ! ಕರಿ ಪ್ರವಾದಿನ ಹಾತೆ ಲಿಖೈರ‍್ಹುಸ್” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","ತದೆ ಹೆರೋದನೆ ಕಿನಾಬಿ ಮಾಲುಮ್‌ಕೊಂತೆ ಇಮ್‌, ಯೋ ಗ್ಯಾನಿ ಅದ್ಮಿಖ್ಹಾರಾನ ಬುಲೈನ್, ಯೋ ಶುಕ್ಕರ್ ದೆಖಾಯೂತೆ ಬರೋಬರ್‌ನಿ ವಖ್ಹತ್‌ನ ಪುಛೈ಼ಲಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","ಅಜು಼ ಇವ್ಣುನ, “ತುಮೆ ಜೈ಼ನ್ ಬರೋಬರ್‌ಥಿ ಯೋ ಲಡ್ಕಾನ ಢೂಂಡೊ, ಅಜು಼ ಯೋ ಮಳಾನ ಬಾದ್‌ಮ ಮನ ಬೋಲೊ, ಮೇಬಿ ಅಯಿನ್ ಯೋ ಲಡ್ಕಾನ ಆಡ್‍ಪಡಿನ್ ಖ್ಹಲಾಮ್‌ಕರುಸ್” ಕರಿ ಬೋಲಿನ್ ಇವ್ಣುನ ಬೇತ್ಲೆಹೇಮ್‌ನ ಮೋಕ್ಲಿದಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","ಇವ್ಣೆ ರಾಜಾ಼ನಿ ವಾತೆ ಖ್ಹಮ್‌ಜಿನ್‌, ವಳ್ಯುಜಾ಼ತುಥೂತೆ ತದೆ ಪೂರಬ್ ದೇಖ್ಹ್‌ಮ ಇವ್ಣುನ ದೆಖಾಯುಥೂತೆ ಯೋ ಶುಕ್ಕರ್ ಇವ್ಣುನ ಪಾಛು಼ ದೆಖಾಯು. ಇವ್ಣೆ ಯೋ ಶುಕ್ಕರ್‌ನ ದೇಖಿನ್, ಘಣು ಖ್ಹುಶಿಖಾದು! ಯೋ ಶುಕ್ಕರ್ ಇವ್ಣ ಖ್ಹಾಮ್ಣೆ-ಖ್ಹಾಮ್ಣೆ ಚಾ಼ಲ್ತುಹುಯಿನ್, ಲಡ್ಕು ಥೂತೆ ಝ಼ಗೋಕನ ಆಯಿನ್ ಭೀರಿಗಯು. ");
INSERT INTO vaa_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","ತದೆ ಇವ್ಣೆ ಯೋ ಘರ್‌ಮ ಜೈ಼ನ್, ಯೋ ಲಡ್ಕಾನ ಇನಿ ಆಯ ಮರಿಯನ ದೇಖಿನ್, ಇನ ಆಡ್‍ಪಡಿನ್ ಆರಾದನೆ ಕರ‍್ಯು. ಅಜು಼ ಇವ್ಣೆ ಲೈರಾಖ್ಯುಥೂತೆ ಇನಾಮ್ನ ಬುತ್ತಾವ್‍ನ ಛೋ಼ಡಿನ್ ಇನಾಮಾಥು ಖ್ಹೊನ್ನು, ಖ್ಹಾಲರ‍್ಯೊ ಅಜು಼ ರಕ್ತಬೋಳನ ಕಾಡಿನ್ ಇನ ಕಾಣ್ಕೆ ದಿದು. ");
INSERT INTO vaa_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","ಅನಬಾದ್‍ಮ ದೇವ್ ಇವ್ಣ ಖ್ಹೋಣ್ಯಮ ದೆಖೈನ್, “ತುಮೆ ಹೆರೋದಕನ ಪಾಛು಼ ಫರಿ ನಾ ಜಾ಼ವ್ಣು” ಕರಿ ಝೇತಾವಖ್ಹತರ್, ಇವ್ಣೆ ಬಿಜೇಕ್ ವಾಟೆಕರಿ ಇವ್ಣ ದೇಖ್ಹ್‌ನ ಪಾಛು಼ಫರಿ ಚ಼ಲ್ಯುಗಯು. ");
INSERT INTO vaa_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","ಇವ್ಣೆ ಜಾ಼ವಾನ ಬಾದ್‌ಮ, ದೇವ್ನದೂತ ಯೋಸೇಫ್‌ನ ಖ್ಹೋಣ್ಯಮ ದೆಖೈನ್, “ಹೆರೋದ ಆ ಲಡ್ಕಾನ ಮಾರಿನಾಕ್ಣು ಕರಿ ಢೂಂಡುಕರಾಸ್, ಇನಖ್ಹಾಜೆ ತೂ ಉಠೀನ್, ಲಡ್ಕಾನ ಅಜು಼ ಇನಿ ಆಯನ ಬುಲೈಲಿನ್, ಈಜಿಪ್ಟ್ ದೇಖ್ಹ್‌ನ ಮಿಲೈ ಜಾ಼. ಅಜು಼ ಮೇ ಬೋಲಾತೋಡಿ ಹಿಜ್ಗಾ಼ಸ್ ರ‍್ಹೇ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","ತದೆ ಯೋಸೇಫ ಉಠೀನ್, ರಾತ್ನಿ ವಖ್ಹತ್‌ಮಾಸ್‌, ಯೋ ಲಡ್ಕಾನ ಅಜು಼ ಇನಿ ಆಯನ ಬುಲೈಲಿನ್, ಈಜಿಪ್ಟ್‌ನ ನಿಕ್ಳಿಗಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","ಹೆರೋದ ಮರಾತೋಡಿ ಯೋ ಹಿಜ್ಗಾ಼ಸ್ ಥೊ. “ಮಾರ ಛಿಯ್ಯಾನ ಮೇ ಈಜಿಪ್ಟ್ ದೇಖ್ಹ್‌ಮಾಥು ಬುಲಾಯೊ” ಕರಿ ಪ್ರಭುನ ಪ್ರವಾದಿನ ಮ್ಹೋಡಥಿ ಬೋಲಾಯೋತೆ ವಾತೆ ಅಮ್ ಪೂರಹುಯು. ");
INSERT INTO vaa_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","ಯೋ ಗ್ಯಾನಿ ಅದ್ಮಿಖ್ಹಾರು ಇನ ಠಗೈನಾಖ್ಯು ಕರಿ ಹೆರೋದನೆ ಘಣು ಖೀಜ಼್‌ ಕರೀನ್‌, ಇವ್ಣೇಥಿ ಪುಛಾ಼ಯೊಥೋತೆ ವಖ್ಹತ್‌ನ ಬರೋಬರ್‌ಥಿ ಮಾಲುಮ್ ಕರ‍್ಲಿನ್, ಆಳ್‌ನ ಖ್ಹಾರು ಮೋಕ್ಲಿನ್, ಬೇತ್ಲೆಹೇಮ್ ಅಜು಼ ಇನ ಅಶ್‌ಪಿಶ್‍ ಖ್ಹಾರುಸ್ ಗಾಮ್‌ನು, ಬೇ ವರಖ್ಹ್‌ನ ಮಹಿನು ಖ್ಹಾರಸ್ ಪರ್ಖ್ಹಾ ಲಡ್ಕಾನ ಮಾರಿನಾಖಿದೆವ್ಣು ಕರಿ ಹುಕುಮ್ ದಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","ಯೆರೆಮೀಯ ಕರಿ ಪ್ರವಾದೀನೆ ಬೋಲ್ಯೋತೆ ವಾತೆ ಯೋ ಹಗಾಮ್ಮ ಪೂರಹುಯು ಯೋ ಶಾತ್‌ಕತೊ, ");
INSERT INTO vaa_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“ರಾಮಾಮ ಬಳೆಳ್ಹಾಟ್ ಖ್ಹಮ್‌ಜಾ಼ಯು, ರೊವಣ್-ಝೊವಣ್ಣು ಅವಾಜ಼್ ಹುಯು; ರಾಹೇಲ್‍ ಇನ ಲಡ್ಕಾವ್‍ನಖ್ಹಾಜೆ ರದನ್ಯಕರಿನ್, ಇವ್ಣೆ ಮರಿಗಯೂತೆ ಇನಖ್ಹಾಜೆ, ಸಮಾಧಾನ್ ಕೋಹುಯಿನಿ” ಕರಿ ಬೋಲಾನುಸ್. ");
INSERT INTO vaa_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","ಹೆರೋದ ಮರಿಜಾ಼ವಾನ ಬಾದ್‌ಮ, ಈಜಿಪ್ಟ್‌ಮ ದೇವ್ನದೂತ ಯೋಸೇಫ್‌ನ ಖ್ಹೋಣ್ಯಮ ದೆಖೈನ್, ");
INSERT INTO vaa_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“ತೂ ಉಠೀನ್, ಲಡ್ಕಾನ ಅಜು಼ ಇನಿ ಆಯನ ಬುಲೈಲಿನ್, ಪಾಛು಼ಫರಿನ್ ಇಸ್ರಾಯೇಲ್‌ ದೇಖ್ಹ್‌ನ ಜಾ಼, ಶನಕತೊ ಲಡ್ಕಾನು ಜಾನ್‌ ಕಾಡ್ಣುಕರಿ ಥೋತೆ ಯೋ ಮರಿಗಯೊ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","ತದೆ ಯೋಸೇಫ್‌ನೆ ಉಠೀನ್, ಲಡ್ಕಾನ ಅಜು಼ ಇನಿ ಆಯನ ಬುಲೈಲಿನ್, ಪಾಛು಼ಫರಿ ಇಸ್ರಾಯೇಲ್‌ ದೇಖ್ಹ್‌ನ ಗಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","ಕತೋಬಿ ಆರ್ಖೆಲಾಯನೆ ಇನೊ ಬಾ ಹೆರೋದಾನ ಬದಲ್ ಯೂದಾಯನ ಚ಼ಲವ್‍ಕರಾಸ್‌ ಕರಿ ಖ್ಹಮ್‌ಜಿನ್‌, ಹಿಜ಼್ಜಾ ಜಾ಼ವಾನ ಡರ‍್ಯೊ. ತದೆ ಯೋಸೇಫ್‌ನೆ ಖ್ಹೋಣ್ಯಮ ದೇವ್ನಿ ಹುಕುಮ್‌ನ ಲೀನ್, ಗಲಿಲಾಯ ತಬರ್‌ಖಾನ ಗಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","ಅಜು಼ ನಜ಼ರೇತ್ ಕರಿ ಗಾಮ್ಮ ಆಯಿನ್ ಹಿಜ್ಗಾ಼ ಘರ್ ಕರೀನ್ ಥೊ. ಅನೇಥಿ ಇನ, “ನಜ಼ರೇತ್‌ವಾಳೊ ಕರಿ ನಾಮ್ ಆವ್‌ಶೆ” ಕರಿ ಪ್ರವಾದಿಯೇನೆ ಬೋಲ್ಯೂತೆವಾತೆ ಪೂರಹುಯು. ");
INSERT INTO vaa_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","ಯೋ ದನೂಮ ಬ್ಯಾಪ್ತಿಸ್ಮ ದ್ಯವಾಳೊ ಯೋಹಾನ ಯೂದಾಯಾನಿ ಉಜ್ಜಾ಼ಡಿ ಝ಼ಗೋಮ ಬೋಧನೆನ ಬೋಲ್ತೊಹುಯಿನ್, ");
INSERT INTO vaa_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“ಪಾಪ್‌ಥಿ ಫರಿನ್ ನಿಕ್ಳೊ, ಶನಕತೊ ಸೊರ್ಗ ರಾಜ್ಯ ಖನ್ನೆ ಐಗೈ!” ಕರಿ ಬೋಲ್ತೊನಿಕ್‌ಳ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","“ಪ್ರಭುನಿ ವಾಟ್ನ ಖ್ಹವಾರೊ; ಇನಿ ವಾಟ್ನ ಖ್ಹೂದುಕರೊ! ಕರಿ ಉಜ್ಜಾ಼ಡಿ ಝ಼ಗೋಮ ಚಿಕ್ರಾವಾಳಾನಿ ಅವಾಜ಼್ ಛಾ಼” ಕರಿ ಪ್ರವಾದಿ ಯೆಶಾಯನೆ ಬೋಲ್ಯೋತೆ ಅನಿಸ್‌ ಬಾರೇಮ. ");
INSERT INTO vaa_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","ಯೋಹಾನನು ಲುಂಗ್ಡ ಊಟ್ನ ಕೇಖ್ಹ್‌ಥಿ ಬಣಿರ‍್ಹೂಥು; ಇನಿ ಕಂಬರ್‌ನ ಚಾ಼ಂಬ್ಡಾನು ಕಂಬರ್‌ಪಟೊ ಭಾಂದಿರಾಕ್‌ತೋಥೊ, ಚಿಡ್ಡೋಬಿ ಜ಼ಂಗಳ್ನಿ ಶೇತ್‌ ಇನು ಖಾಣು ಹುಯಿರ‍್ಹುಥು. ");
INSERT INTO vaa_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","ಅದ್ಮಿಖ್ಹಾರು ಯೆರೂಸಲೇಮ್‌ಥುಬಿ, ಹಿಡಿ ಯೂದಾಯ ತಬರ್‌ಖಾಥುಬಿ, ಅಜು಼ ಯೊರ್ದನ್‌ ನದ್ದಿನು ಅಶ್‌ಪಿಶ್‍ ಥೂತೆ ಖ್ಹಾರ ತಬರ್‌ಖಾಥುಬಿ ಇನಾಕನ ಆಯಿನ್; ");
INSERT INTO vaa_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","ಇವ್ಣು-ಇವ್ಣು ಪಾಪ್ನ ಕಬೂಲಿಲೀನ್‌, ಯೊರ್ದನ್‌ ನದ್ದಿಮ ಯೋಹಾನಥಿ ಬ್ಯಾಪ್ತಿಸ್ಮ ಕರೈಲೆವ್‌ಕರ್ತುಥು. ");
INSERT INTO vaa_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","ಕತೋಬಿ ಫರಿಸಾಯರ್‌ವಾಳಮ ಅಜು಼ ಸದ್ದುಕಾಯವಾಳಮ ಕೈಯೆಕ್ಕಿ ಜ಼ಣು ಇನಾಕನ ಬ್ಯಾಪ್ತಿಸ್ಮ ಕರೈಲೆವಾನ ಆವ್‍ಕರಾತೆ ದೇಖಿನ್‌, ಯೋಹಾನನೆ ಇವ್ಣುನ, “ಅಲಾ ಖ್ಹಾಪ್‌ನಿ ಪಿಳ್ಗಿವಾಳವೊ! ಖ್ಹಾಮ್ಣೆ ಉಳ್ಯಾವತೆ ದೇವ್ನ ಇರಾದೇಥಿ ತುಮೆ ಬಚಿಜಾ಼ಶು ಕರಿ, ತುಮೂನ ಬೋಲ್ಯುತೆ ಕೋಣ್? ");
INSERT INTO vaa_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","ಇಮ್‍ಕತೊ, ತುಮೆ ಪಾಪ್ನ ಮ್ಹೇಲಿನ್ ಫರಿಗಯಕರಿ ವತಾಳನಖ್ಹಾಜೆ ಬರೋಬರ್‌ಥಿ ಚಾ಼ಲ್‌ಮ ವತಾಳೊ. ");
INSERT INTO vaa_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","ಅಬ್ರಹಾಮ್‌ ಹಮಾರೊ ಗುರು ಕರಿ ಬೋಲಾಥಿ ತುಮೆ ದೇವ್ನ ನಿಶಥ್ಥಿ ಬಚಿಜಾ಼ಶು ಕರಿ ನಕೊ ಸೋಚೊ, ಮೇ ತುಮೂನ ಬೋಲುಸ್ಕಿ, ದೇವ್ ಅಬ್ರಹಾಮ್‌ನಖ್ಹಾಜೆ ಆ ಬಂಡೇವ್‌ಥಿಬಿ ಲಡ್ಕಾವ್ನ ಉಬ್‍ಜಾ಼ವ್‍ಶೆ ಕರಿ ತುಮೂನ ಬೋಲುಸ್. ");
INSERT INTO vaa_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","ಹಮ್ಕೇಸ್‌ ಝಾ಼ಡಾವ್‍ನಿ ಜ಼ಡ್‌ಪರ್‌ ಕುರ‍್ಹಾಡಿ ಮ್ಹೇಲೈರ‍್ಹಿಸ್; ಇನಖ್ಹಾಜೆ ಅಛ್ಛು಼ ಪಂಡು ದೇಯಿಕೊಂತೆ ಹರೇಕ್ ಝಾ಼ಡಾವ್‌ನ ಕತ್ರಿನ್‌ ಆಗ್‌ಮ ನಾಕ್‌ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","ಮೇತೊ ಮನ್ ಫರಾವನ ತುಮೂನ ಪಾಣಿಥಿ ಬ್ಯಾಪ್ತಿಸ್ಮ ಕರವ್‍ಕರುಸ್. ಕತೋಬಿ ಮಾರ ಬಾದ್ಮ ಆವವಾಳೊ ಮಾರೇಥಿಬಿ ಶಕತ್‌ವಾಳೊ. ಇನಿ ಖೋಖ್ಹ್‌ಡಾನ ಢೋವಾನಾಬಿ ಮೇ ಲ್ಹಾಯೇಕ್‍ಕೊಯ್ನಿ; ಯೊ ಪವಿತ್ರಾತ್ಮಥಿಬಿ ಆಗ್‍ಥೀಬಿ ತುಮೂನ ಬ್ಯಾಪ್ತಿಸ್ಮ ಕರಾವ್‌ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","“ಇನ ಹಾತ್‌ಮ ಖ್ಹುಪ್‌ಡು ಧರಿರಾಖ್ಯೋಸ್‌, ಇನ ಖಳಾಮಾನು ರಾಶ್‌ನ ತೂರಿನ್‌, ಅಛ಼್ಛ ಕರೀನ್, ಘವ್‌ನ ಕಣ್ಗಿಮ ಭರಿಲೀನ್‌ ಪೊಟ್ಟಾನ ಉಝಾ಼ವಕೊಂತೆ ಆಗ್‌ಮ ಬಾಳಿನಾಕ್‌ಷೆ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","ಯೋ ದನೂಮ ಯೇಸು ಯೋಹಾನಥಿ ಬ್ಯಾಪ್ತಿಸ್ಮ ಕರೈಲೇವ್ಣು ಕರಿ ಗಲಿಲಾಯ ತಬರ್‌ಖಾಥು ಯೊರ್ದನ್‌ ನದ್ದಿಕನ ಆಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","ತದೆ ಯೋಹಾನನೆ, “ಮೇ ತಾರೇಥಿ ಬ್ಯಾಪ್ತಿಸ್ಮ ಕರೈಲೆವ್ಣುತೆ, ಕತೋಬಿ ತೂ ಮಾರಕನ ಐರ‍್ಹೋಸ್ತೆ ಕಿಮ್?” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","ಕತೋಬಿ ಯೇಸುನೆ ಇನ, “ಹಮ್ಕೆ ಆ ಕರಾನ ಮಾನಿಜಾ಼. ಅಮ್ ಕರಾಥಿ ಅಪ್ಣೆ ದೇವ್ನಿ ಖ್ಹಾರಿಸ್ ಮರ್ಜಿನ ಪೂರಕರಾನಿತರ ಉಶೆ” ಕರಿ ಬೋಲ್ತಾನ, ಯೋಹಾನನೆ ಮಾನಿಗಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","ಯೇಸು ಬ್ಯಾಪ್ತಿಸ್ಮ ಕರೈಲೀನ್, ಭಾರ್‌ ನಿಕಳ್‌ತಾಸ್ನ ಆಬ್‍ಫಾಟೀನ್, ದೇವ್‌ನು ಆತ್ಮ ಪರ‍್ಯಾವಾನಿಘೋಣಿ ಇನಾಪರ್‌ ಉತ್ರಿನ್ ಆಯೂತೆ ಯೇಸುನೆ ದೇಖ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","ತದೆ ಪರಲೋಕ್‌ಮಾಥು ಏಕ್‌ ಅವಾಜ಼್ ಹುಯು, “ಆ ಮಾರೊ ಪ್ಯಾರ್‌ನೊ ಛಿಯ್ಯೊ, ಅನೇಥಿ ಮೇ ಘಣು ಖ್ಹುಶಿ ಛೂ಼” ಕರಿ ಠವ್‌ಕೊ ಖ್ಹಮಜ್‍ಪಡ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","ತದೆ ಯೇಸುನ ಶೈತಾನ್‌ಥಿ ಶೋದನೆ ಹುವಾನಟೇಕೆ, ದೇವ್‌ನು ಆತ್ಮಾನೆ ಇನ ಉಜ್ಜಾ಼ಡಿ ಝ಼ಗೋಮ ಚ಼ಲಾಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","ಯೇಸು ಚಾ಼ಳಿಖ್ಹ್ ರೋಜ಼್‌ ರಾತ್‌-ದನ್ ಉಪವಾಸ್ ರ‍್ಹವಾನ ಬಾದ್‌ಮ, ಇನ ಭುಕ್‌ಲಾಗ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","ತದೆ ಶೈತಾನ್‍ ಯೇಸುಕನ ಆಯಿನ್, “ತೂ ದೇವ್‌ನೊ ಛಿಯ್ಯೊ ಉಶೇತೊ, ಆ ಬಂಡಾವ್‍ನ ರೋಟೊ ಹುವಾನಿಘೊಣಿ ಹುಕುಮ್‌ ದೇ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","ಕತೋಬಿ ಯೇಸುನೆ, “ಅದ್ಮಿ ಖಲಿ ರೋಟೊ ಖಾವಾಥೀಸ್‌ ಕೋ ಬಚಾ಼ನಿ, ದೇವ್ನ ಮ್ಹೋಡವಾಟೆ ನಿಕ್ಳಾಸ್ತೆ ಹರೇಕ್ ವಾತೆಥೀಸ್‌ ಬಚಾ಼ಸ್ತೆ’ ಕರಿ ವಚನ್‌ಮ ಲೀಖೈರ‍್ಹೂಸ್‌ನಿ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","ತದೆ ಶೈತಾನ್ನೆ ಯೇಸುನ ಪವಿತ್ರ ನಂಗರ್ ಯೆರೂಸಲೇಮ್‌ನ ಬುಲೈಲಿಜೈ಼ನ್ ಮಂದಿರ್‌ನ ಉಪ್ಪರ್‌ಲಿ ಟೇಕ್‌ಡಿನಿ ಝ಼ಗೋಪರ್ ಭೀರಾಖಿನ್, ");
INSERT INTO vaa_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","“ತೂ ದೇವ್‌ನೊ ಛಿಯ್ಯೊ ಉಶೇತೊ, ಹಜ್ಜಾ಼ಥೊ ಹೇಟ್ ಕೂದ್, ‘ದೇವ್ ತಾರಿ ಬಾರೇಮ ಇನ ದೂತರ್‌ನ ಹುಕುಮ್‌ ದಿಶೆ; ತಾರ ಗೋಡೊ ಬಂಡಾನ ಠೋಕರ್ ನಾಲಗ್ನುತೆ ತಿಮ್‌ ಯೋ ತುನ ಹಾತ್‌ಮ ಪಾಡಿಲಿಶೆ. ಕರೀಬಿ ಪವಿತ್ರ ದಪ್ತರ್‌ಮ ಲೀಖೈರ‍್ಹೂಸ್‌ನಿ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","ತದೆ ಯೇಸುನೆ, “ತಾರೊ ದೇವ್‌ ಹುಯಿರ‍್ಹೋತೆ ಪ್ರಭುನ ತರೀಪ್‌ಶ ನಾ ಕರ‍್ನು’ ಕರೀಬಿ ವಚನ್‌ಮ ಲೀಖೈರ‍್ಹೂಸ್‌ನಿ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","ಅನಬಾದ್‌ಮ, ಶೈತಾನ್ನೆ ಯೇಸುನ ಘಣ ಊಚಾ಼ ಪಹಾಡ್‌ಪರ್ ಬುಲೈಲಿಜೈ಼ನ್‌, ಜಗತ್‌ನು ಖ್ಹಾರಸ್ ರಾಜ್ಯನ, ಅಜು಼ ಇನಿ ಖ್ಹಾರಿಸ್ ರಾಜ್ಯನ ವೈಭವನ ಇನ ವತಾಳಿನ್. ");
INSERT INTO vaa_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","“ತೂ ಮನ, ಆಡ್‍ಪಡಿನ್ ಆರಾದನೆ ಕರ‍್ಯೋತೊ, ಆ ಖ್ಹಾರಸ್ನ ಮೇ ತುನ ದೆವುಸ್‌” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","ತದೆ ಯೇಸುನೆ, “ಇನ, ಶೈತಾನ್‍ ತೂ ಹಟಿಜಾ಼! ‘ತಾರೊ ದೇವ್ ಹುಯಿರ‍್ಹೋತೆ ಪ್ರಭುನ ಎಕ್ಕಸ್ ಜ಼ಣಾನ ಆರಾದನೆ ಕರ‍್ನು ಅಜು಼ ಸೇವೆ ಕರ‍್ನು ಕರಿ ವಚನ್‌ಮ ಲೀಖೈರ‍್ಹುಸ್” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","ತದೆ ಶೈತಾನ್ನೆ ಇನ ಮ್ಹೆಂದಿನ್ ಚ಼ಲೆಗಯೊ. ಅಜು಼ ದೇವ್‌ನು ದೂತರ್ ಆಯಿನ್, ಇನಿ ಸೇವಾ-ಚಾ಼ಕ್ರಿ ಕರ‍್ಯು. ");
INSERT INTO vaa_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","ಯೋಹಾನನ ಜೇಲ್‌ಮ ಕೋಂಡಿನ್‌ ಘಾಲಿದಿದು ಕರಿ ಯೇಸುನೆ ಖ್ಹಮ್‌ಜಿನ್‌, ಯೋ ಝ಼ಗೋನ ಮ್ಹೆಂದಿನ್, ಗಲಿಲಾಯ ತಬರ್‌ಖಾನ ಚ಼ಲೆಗಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","ತದೆ ಯೇಸು ನಜ಼ರೇತ್ ಕರಿ ಗಾಮ್‌ನ ಮ್ಹೆಂದಿನ್, ಹಿಜ್ಜಾ಼ಥೊ ನಿಕ್ಳಿನ್ ಗಲಿಲಾಯ ದರ‍್ಯಾವ್‍ನ ಖನ್ನೆ ಥೂತೆ ಕಪೆರ್ನೌಮ್ ಕರಿ ಗಾಮ್ಮ ಆಯಿನ್ ರ‍್ಹಿಯೊ. ಆ ಗಾಮ್‍ ಜೆಬಲೋನ್‌ ಅಜು಼ ನಫ್ತಾಲಿ ಕರಿ ತಬರ್‌ಖಾಮ ಥೂ. ");
INSERT INTO vaa_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","ಅನೇಥಿ ಪ್ರವಾದಿ ಯೆಶಾಯಥಿ ಬೋಲಾಯೋತೆ ವಾತೆ ಚಾ಼ಲ್ಯು. ಯೋ ಶಾತ್‌ಕತೊ, ");
INSERT INTO vaa_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“ಜೆಬಲೋನ್‌ ತಬರ್‌ಖೊ, ಅಜು಼ ನಫ್ತಾಲಿ ತಬರ್‌ಖೊ, ಯೊರ್ದನ್‌ ನದ್ದಿನು ಪಾರ್ಲಿ ಬಾಜೂ಼ಮ, ದರ‍್ಯಾವ್‍ಭಣಿ ಛಾ಼ತೆ ತಬರ್‌ಖೊ, ಯೆಹೂದ್ಯರ್‌ಕಾಹೆತೆ ಅದ್ಮಿಖ್ಹಾರು ಛಾ಼ತೆ ಗಲಿಲಾಯ ತಬರ್‌ಖೊ, ");
INSERT INTO vaa_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","ಅಮ್ ಅಂಧಾರಾಮ ಜಿವ್‍ಕರ್ತುಥೂತೆ ಆ ತಬರ್‌ಖಾನು ಅದ್ಮಿಖ್ಹಾರು ಮೋಟು ಉಜಾ಼ಖ್ಹ್‌ ದೆಖಾಯು. ಮರಣ್ಣಿ ಛಾ಼ಳೊ ಢಪೈರ‍್ಹುಥುತೆ ತಬರ್‌ಖಾಮ ಜಿವ್‍ಕರ್ತುಥೂತೆ ಇವ್ಣಾಪರ್ ಉಜಾ಼ಳು ಘೈಗೈಗು.” ");
INSERT INTO vaa_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","ತಪ್‌ಥೊ ಯೇಸು, ಪಾಪ್‌ಥಿ ಫರಿನ್ ನಿಕ್ಳೊ, ಶನಕತೊ ಸೊರ್ಗ ರಾಜ್ಯ ಖನ್ನೆ ಐಗು!” ಕರಿ ಖಬರ್‌ನ ಬೋಲ್ತೊನಿಕ್‌ಳ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","ಯೇಸು ಗಲಿಲಾಯ ದರ‍್ಯಾವ್ನ ಕನಾರೆಕರಿ ವಳ್ಯೊಜಾ಼ತೊಥೊ. ತದೆ, ಬೇ ಭೈಯೇ ಜಾ಼ಳು ನಾಖುಕರ್ತಥಾತೆ ದೇಖ್ಯೊ. ಇವ್ಣೆ ಕೋಣ್‌ಕತೊ, ಪೇತ್ರ ಕರಿ ಬೋಲೈಲಿದೋತೆ ಸೀಮೋನ, ಅಜು಼ ಇನೊ ಭೈ ಅಂದ್ರೆಯನ ದೇಖ್ಯೊ. ಅವ್ಣೆ, ಮಾಛ಼್ಲ ಖ್ಹಾವಾಳ ಹುಯಿರ‍್ಹಾಥ. ");
INSERT INTO vaa_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","ಯೇಸುನೆ ಇವ್ಣುನ, “ಮಾರ ಕೇಡೆ ಆವೊ, ಮೇ ತುಮೂನ ಮಾಛ಼್ಲ ಖ್ಹಾವಾಳಾನಿತರ ಕಾಹೆ ಅದ್ಮಿನ ಖ್ಹಾವಾಳಾನಿತರ ಬಣವುಸ್. ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","ಇಮ್‌ ಬೋಲ್ತಾಸ್‌ನ ಇವ್ಣೆ ಇವ್ಣು ಜಾ಼ಳುಖ್ಹಾರು ಮ್ಹೆಂದಿನ್, ಇನ ಕೇಡೆ ಗಯ. ");
INSERT INTO vaa_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","ಯೇಸು ಹಿಜ್ಜಾ಼ಥೊ ನಿಕ್ಳಿನ್, ಬಿಜೂ಼ ಬೇ ಭೈಯೇನ ದೇಖ್ಯೊ, ಇವ್ಣೆ ಕೋಣ್‌ಕತೊ, ಜೆಬೆದಾಯನೊ ಛಿಯ್ಯೊ ಯಾಕೋಬನಾಬಿ ಅಜು಼ ಇನೊ ನ್ಹಾನೊ ಭೈ ಯೋಹಾನ್ನ ದೇಖ್ಯೊ. ಇವ್ಣೆ ಡೋಣ್‌ಮ ಜಾ಼ಳಾನ ಬರೋಬರ್ ಕರುಕರ್ತಥ. ಯೇಸುನೆ ಇವ್ಣುನಾಬಿ ಬುಲಾಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","ತದ್‌ನು-ತದೇಸ್‌ ಇವ್ಣೆ ಡೋಣ್ಣಾ ಅಜು಼ ಇವ್ಣ ಬಾನ ಮ್ಹೆಂದಿನ್, ಯೇಸುನ ಕೇಡೆ ಗಯ. ");
INSERT INTO vaa_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","ಬಾದ್‌ಮ ಯೇಸು ಗಲಿಲಾಯ ಅಖ್ಖೂಸ್ ಫರೀನ್, ಹಿಜ್ಜಾ಼ನು ಯೆಹೂದ್ಯರ್‌ನ ಸಬೆ ಭರಾವಾನು ಮಂದಿರ್‌ಮ ಬೋಲಿದೇತೊಹುಯಿನ್‌, ದೇವ್ನಿ ರಾಜ್ಯನಿ ಬಾರೇಮನು ಅಛ್ಛಿ ಖಬರ್‌ನ ಬೋಲ್ತೊಹುಯಿನ್‌, ಅದ್ಮಿಮ ಥೂತೆ ಖ್ಹಾರೀಸ್‍ ತರ‍್ಹಾನು ರೋಗ್‌-ರಾಯನ ಅಛ್ಛು಼ ಕರ್ತೊ ಆಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","ಇನಿ ಬಾರೇಮಾನಿ ಖಬರ್ ಸಿರಿಯ ದೇಖ್ಹ್‌ ಅಖ್ಖುಸ್ ಫೈಲಿಗಯು. ತದೆ ಆದ್ಮಿಖ್ಹಾರು ರೋಗ್‌ಮ ರ‍್ಹವಾಳನ ಯೇಸುಕನ ಲಾಯು, ಇವ್ಣಾಮ ಕೈಯೆಕ್ಕಿ ತರ‍್ಹಾನು ರೋಗ್‌-ರಾಯಥಿ ತರಪ್‌ಡುಕರ್ತುಥೂತೆ ಅಜು಼ ಭೂತ್‌ ಧರಿರಾಖ್ಯುಥೂತೆ, ಮಿರ್‌ಘಿ ಥೂತೆ ಅಜು಼ ಲಕ್‍ವೊ ಮಾರಿರಾಖ್ಯುಥೂತೆ ಇವ್ಣ ಅಖ್ಖಾನ ಇನಕನ ಲಾಯು. ಯೇಸುನೆ ಇವ್ಣ ಖ್ಹಾರಸ್ನ ಅಛ್ಛು಼ ಕರ‍್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","ಗಲಿಲಾಯ, ದೆಕಪೊಲಿ, ಯೆರೂಸಲೇಮ್‌, ಯೂದಾಯ ತಬರ್‌ಖಾಥು, ಅಜು಼ ಯೊರ್ದನ್‌ ನದ್ದಿನು ಪಾರ್ಲಿ ಬಾಜು಼ಥು, ಆದ್ಮಿಖ್ಹಾರು ಝೂ಼ಂಡೆ-ಝೂ಼ಂಡೆ ಹುಯಿನ್, ಯೇಸುನ ಪೀಠೆ ಗಯು. ");
INSERT INTO vaa_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","ಯೇಸುನೆ ಅದ್ಮಿನಿ ಝೂ಼ಂಡೆನ ದೇಖಿನ್‌, ಪಹಾಡ್‌ಪರ್ ಚ಼ಢೀನ್‌ ಬೆಶಿಗಯೊ. ತದೆ ಇನ ಶಿಷ್ಯರ್‌ ಆಯಿನ್, ಇನ ಅಶ್‌ಪಿಶ್‌ ಭರಾಯ, ");
INSERT INTO vaa_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","ತದೆ ಯೇಸುನೆ ಇವ್ಣುನ ಶಾತ್‌ ಬೋಲಿಶಿಕಾಡ್ಯೊಕತೊ, ");
INSERT INTO vaa_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“ಕೋಣ್ ಆತ್ಮಮ ಗರೀಬ್ ಹುಯಿರ‍್ಹವಾಳ, ಇವ್ಣೆ ಖ್ಹುಶಾಲಿವಾಳು ಹುಯಿರ‍್ಹುಸ್; ಸೊರ್ಗ ರಾಜ್ಯ ಇವ್ಣುಸ್‌ ಹುಯಿರ‍್ಹುಸ್‍! ");
INSERT INTO vaa_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","ಕೋಣ್ ದುಖ್‌ಮ ಛಾ಼ಕಿ, ಇವ್ಣೆ ಧನ್ಯ ಹುಯಿರ‍್ಹುಸ್‍ ದೇವ್ ಇವ್ಣುನ ಸಮಾಧಾನ್‍ ದಿಶೆ. ");
INSERT INTO vaa_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","ಖ್ಹಮಾಳಿಲ್ಯವಾಳು ಧನ್ಯ, ಇವ್ಣೆ ಧರ್ತಿಪರ್ ಖ್ಹುಶಾಲಿವಾಳು ಹುಯಿರ‍್ಹುಸ್‍. ದೇವ್ನೆ ಶಾತ್ ವಾತೆ ದೀರಾಖ್ಯೊಸ್ಕಿ, ಯೋ ಇವ್ಣುನ ಮಳ್‌ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","ಕೋಣ್ ದೇವ್ನಿ ಮರ್ಜಿನಿಘೋಣಿ ಕರಾನ ಘಣು ಆಖ್ಹ್ ಕರಾಸ್ಕಿ, ಇವ್ಣೆ ಧನ್ಯ ಹುಯಿರ‍್ಹಾಸ್; ದೇವ್ ಇವ್ಣುನ ಹಕ್ಲಾಲ್‌ ಹುವಾನಿತರ ಕರ್ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","ಕೋಣ್ ಬಿಜಾ಼ನ ಗೋರ್‌ ಕರಾಸ್ಕಿ, ಇವ್ಣೆ ಖ್ಹುಶಾಲಿವಾಳು ಹುಯಿರ‍್ಹುಸ್‍. ದೇವ್ ಇವ್ಣಾಪರ್ ಗೋರ್‌ ಕರ್ಶೆ! ");
INSERT INTO vaa_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","ಕೋಣ್ ದಿಲ್ಮ ಪಾಕ್‌ ರ‍್ಹೇಸ್ಕಿ, ಇವ್ಣೆ ಖ್ಹುಶಾಲಿವಾಳು ಹುಯಿರ‍್ಹುಸ್‍. ಇವ್ಣೆ ದೇವ್ನ ದೇಕ್‌ಶೆ; ");
INSERT INTO vaa_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","ಕೋಣ್ ಸಮಾಧಾನ್ ಕರಾನ ಮ್ಹಿನತ್ ಕರಸ್ಕಿ, ಇವ್ಣೆ ಖ್ಹುಶಾಲಿವಾಳು ಹುಯಿರ‍್ಹುಸ್‍, ಇವ್ಣೆ ದೇವ್ನ ಲಡ್ಕಕರಿ ಬೋಲೈಲಿಶೆ. ");
INSERT INTO vaa_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","ಕೋಣ್ ದೇವ್ನಿ ಮರ್ಜಿನಿಘೋಣಿ ರ‍್ಹವಾನಖ್ಹಾಜೆ ಖ್ಹತಾಪ್ಣಿನ ಖ್ಹಮಾಳಿಲೇಸ್ಕಿ, ಇವ್ಣೆ ಖ್ಹುಶಾಲಿವಾಳು ಹುಯಿರ‍್ಹುಸ್‍. ಸೊರ್ಗ ರಾಜ್ಯ ಇವ್ಣುಸ್‌ ಹುಯಿರ‍್ಹುಸ್‍! ");
INSERT INTO vaa_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“ಮಾರ ಖ್ಹಾಜೇಥಿ ಅದ್ಮಿಖ್ಹಾರು ತುಮೂನ ಖ್ಹರಮ್‌ ಕಾಡಿನ್, ಖ್ಹತೈನ್, ತುಮಾರಪರ್ ಖ್ಹಾರಿಸ್ ತರ‍್ಹಾನು ಖರಾಬ್‌ನ ಬೋಲಿನ್, ಝೂ಼ಟಿ ಲಗಾಡ್ಯುತೊ, ತುಮೆ ಧನ್ಯ ಹುಯಿರ‍್ಹಾಸ್‌. ");
INSERT INTO vaa_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","ಖ್ಹುಶಿ ಕರೊ ಅಜು಼ ಖೇಲ್‌ಕೂದ್ ಕರೊ, ಶನಕತೊ ಸೊರ್ಗಾಮ ತುಮೂನ ಘಣು ಇನಾಮ್ ಮಳ್‌ಶೆ. ತುಮಾರೇಥೀಬಿ ಅಗಾಡಿ ಥೂತೆ ಪ್ರವಾದಿಯೆನಾಬಿ ಅಮ್ಮಸ್ ಖ್ಹತಾಯುನಿ. ");
INSERT INTO vaa_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","ತುಮೆ ಧರ್ತಿನ ಮೀಟ್‌ ಹುಯಿರ‍್ಹಾಸ್‌. ಮೀಟಸ್‌ ಫಿಕ್ಕು ಹುಯಿಗುತೊ, ಇನ ಬಿಜು಼ ಶನೇಥಿ ರುಚ಼್‍ ದ್ಯವಾನ ಉಶೆ? ಅದ್ಮಿಖ್ಹಾರು ಇನ ಭಾರ್‌ ನಾಖಿನ್ ವಾಟ್‌ಪರ್ ಚಾ಼ಲವಾಳು ಇನ ಖುಂದ್ಲಾನ ಲ್ಹಾಯಕ್‌ ಪಣ್ಕಿ ಬಿಜ಼ ಖೆವ ಕಾಮ್ನಾಬಿ ಕೋಆವಾನಿ. ");
INSERT INTO vaa_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“ತುಮೆ ಹಿಡಿ ಜಗತ್ನ ಉಜಾ಼ಳು ಹುಯಿರ‍್ಹಾಸ್‌. ಪಹಾಡ್‌ಪರ್ ಭಂದೈರ‍್ಹುತೆ ಗಾಮ್‍ ಲಪಿರ‍್ಹೆಯಿಕೊಯ್ನಿ. ");
INSERT INTO vaa_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","ಅಜು಼ ಕೋಣ್‌ಬಿ ದೀವೊ ಲಗಾಡಿನ್, ಕೋಳ್ಗಾನಹೇಟ್ ಮ್ಹೇಲಾಕೊಯ್ನಿ; ಅನಬದಲ್ ಘರ್‌ಮ ಛಾ಼ತೆ ಹರೇಕ್ನ ಉಜಾ಼ಳು ದ್ಯವಾನಿತರ ದೀವೊ ಮ್ಹೇಲಾನಿ ಖಂಬಾಪರ್‌ ಮ್ಹೇಲಾಸ್. ");
INSERT INTO vaa_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","ಅಮ್ಮಸ್ ತುಮಾರು ಉಜಾ಼ಳು ಅದ್ಮಿನ ಖ್ಹಾಮ್ಣೆ ಉಜಾ಼ಖ್ಹ್‌ ಹುವಾದೆ, ಅನೇಥಿ ತುಮೆ ಕರಾತೆ ಅಛ್ಛು಼ಕಾಮ್ನ ಇವ್ಣೆ ದೇಖಿನ್‌, ಸೊರ್ಗಾಮ ಛಾ಼ತೆ ತುಮಾರ ಬಾನ ಖ್ಹರಾವ್‌ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","ಮೋಶೇನು ಧರ್ಮಶಾಸ್ತ್ರನ ರ‍್ಹವೊ, ಪ್ರವಾದಿನು ಬೋಧನೆನ ರ‍್ಹವೊ, ಕಾಡಿನಾಖನಖ್ಹಾಜೆ ಮೇ ಆಯೋಕರಿ ನಕೊ ಸೋಚೊ. ಕಾಡಾನಖ್ಹಾಜೆ ಕಾಹೆ, ಇನ ಪೂರ ಕರಾನಖ್ಹಾಜೆ ಆಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","ಮೇ ತುಮೂನ ಖ್ಹಾಚಮಾಬಿ ಬೋಲುಸ್ಕಿ, ಆಬ್ಬಿ ಧರ್ತಿ ಮಟಿಜಾ಼ಶೆ, ಧರ್ಮಶಾಸ್ತ್ರಮ ಛಾ಼ತೆ ಖ್ಹಾರುಸ್ ಚಾ಼ಲಾಲಗುಬಿ ಇನಮಾನು ಏಕ್‌ ನ್ಹಾನು ಲಿಖ್ಯೂಬಿ ರ‍್ಹವೊ, ನಾತೊ ಏಕ್‌ ಟಿಪ್‌ಕ್ಯುಬಿ ಮಟ್‌ಶೆ ಕೊಯ್ನಿ. ");
INSERT INTO vaa_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","ಇನಖ್ಹಾಜೇಸ್, ಆ ಹುಕುಮ್‌ನಿ ನ್ಹಾನಿಶಿ ಏಕ್‌ ವಾತ್ನಬಿ ಮ್ಹೇಲಿನ್ ಚಾ಼ಲವಾಳೊ ಅಜು಼ ಬಿಜಾ಼ನಾಬಿ ಇಮ್ಮಸ್ ಚಾ಼ಲಾನ ಶಿಕಾಡವಾಳೊ, ಸೊರ್ಗ ರಾಜ್ಯಮ ಖ್ಹಾರೇಥಿ ನ್ಹಾನೊ ಕರಿ ಬೋಲೈಲಿಶೆ. ಕತೋಬಿ ಯೋಸ್ ಯೋ ಹುಕುಮ್ನಿಮತ್ ಚಾ಼ಲಿನ್, ಬಿಜಾ಼ನಾಬಿ ಇಮ್ಮಸ್ ಚಾ಼ಲಾನ ಶಿಕಾಡವಾಳೊ, ಸೊರ್ಗ ರಾಜ್ಯಮ ಮಹಾನ್ ಕರಿ ಬೋಲೈಲಿಶೆ. ");
INSERT INTO vaa_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","ಮೇ ತುಮೂನ ಶಾತ್‌ ಬೋಲುಸ್‌ಕತೊ, ಮೋಶೆನಿ ಧರ್ಮಶಾಸ್ತ್ರ ಶಿಕಾಡವಾಳು ಪಂಡಿಥ್ಥಿಬಿ ಅಜು಼ ಫರಿಸಾಯರ್‌ನಿ ನೀತಿಥೀಬಿ ತುಮಾರಿ ನೀತಿ ಜಾ಼ಖ್ಹತ್ ನಾ ಹುಯಿರ‍್ಹೀಕತೊ, ತುಮೆ ಸೊರ್ಗ ರಾಜ್ಯಮ ಜಾ಼ಶುಕೊಯ್ನಿ. ");
INSERT INTO vaa_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“ಅದ್ಮಿನ ಖೂನಿ ನಾ ಕರ್ನು, ಇಮ್‌ ಖೂನಿಕರವಾಳನ ನ್ಯಾವ್‍ನಿ ತೀರ್ಪ್‌ನ ಭೀರಾಕ್‌ಶೆ’ ಕರಿ ತುಮಾರು ಶಾಣುಖ್ಹಾರು ಬೋಲಿರಾಖ್ಯುಸ್ತೆ ತುಮೆ ಖ್ಹಮ್‌ಜಿರಾಖ್ಯಾಸ್‌. ");
INSERT INTO vaa_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","ಕತೋಬಿ ಮೇ ತುಮೂನ ಶಾತ್‌ ಬೋಲಸ್‍ಕತೊ, ತುಮೆ ತುಮಾರ ಭೈಪರ್ ಖೀಜ಼್ ಖಾವಾಳೊ ಹರೇಕ್ ಜ಼ಣೋಬಿ ತುಮೆ ನ್ಯಾವ್‍ನಿ ತೀರ್ಪ್‌ಮ ಪಡ್‍ಶು, ಅಜು಼ ತುಮೆ ತುಮಾರ ಭೈನ, ‘ಏ ಬಿಣ್‍ಅಕ್ಲಿ’ ಕರಿ ಬೋಲ್ಯಾತೊ, ತುಮೂನ ನ್ಯಾವ್‍ನಿ ಸಭೆನಖ್ಹಾಮ್ಣೆ ಭೀರಾಕ್‌ಶೆ, ಅಜು಼, ‘ಏ ಫಾಲ್ತು’ ಕರಿ ಬೋಲವಾಳೊ, ನರಕ್‌ನಿ ಆಗ್‌ಮ ಪಡ್‌ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","ಇನಖ್ಹಾಜೇಸ್ ತೂ ತಾರಿ ಕಾಣ್ಕೆನ ಚಾ಼ಚ಼ರ್‌ನ ಖ್ಹಾಮ್ಣೆ ಲಾಯೊತೆ, ತಾರ ಭೈನ ದಿಲ್ಮ ತಾರಪರ್ ಶಾತ್‌ತೋಬಿ ವಹೇರ್‌ ಛಾ಼ ಕರಿ ತಾರಿ ಯಾದ್ಮ ಆಯುತೊ, ");
INSERT INTO vaa_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","ತು ತಾರಿ ಕಾಣ್ಕೆನ ಚಾ಼ಚ಼ರ್‌ನ ಖ್ಹಾಮ್ಣೆಸ್ ಮ್ಹೆಂದಿನ್, ಪಹಿಲೆ ಜೈ಼ನ್‌, ತಾರ ಭೈನ ಜೋ಼ಡೆ ಏಕ್‌ಹೂ. ಇನ ಬಾದ್‌ಮ ಐನ್, ತಾರಿ ಕಾಣ್ಕೆನ ದೇವ್ನ ದೇ. ");
INSERT INTO vaa_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“ತಾರೊ ವಿರೋದಿ ತುನ ನ್ಯಾವ್ನಖ್ಹಾಜೆ ನ್ಯಾಯದೀಶಕನ ಖೇಚಿಲೀಜಾ಼ವನ ಅಗಾಡಿಸ್ ತೂ ವಾಟ್‌ಪರಸ್ ಹೇಳ್‍ಮೇಳ್‍ ಹುಯಿಜಾ಼. ನತರ್‌ಕಿ ತಾರೊ ವಿರೋದಿ ತುನ ನೈಯಾಕನ ಖೇಚಿಲಿಜಾ಼ಶೆ. ಯೋ ನಯ್ಯೊ ಜೇಲ್‌ನ ಶಿಪಾಯಿನ ಹಾತ್ಮ ದಿಶೆ ಅಜು಼ ತೂ ಜೇಲ್‌ಮ ಫೆಕೈಜೀಶ್. ");
INSERT INTO vaa_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","ತೂ ಏಕ್‍ ಕಾಖ್ಹ್‌ಬಿ ಬಚೈಶ್‍ಕೊಂತೆ ತಾರಾಮ ಛಾ಼ತೆ ಅಖ್ಖು ಪೈಶು ಫೇಡಾವಲಗೂಬಿ ಹಿಜ್ಜಾ಼ಥೊ ಆವಾನ ಉಶೇಸ್‍ ಕೊಯ್ನಿ ಕರಿ ಮೇ ಖ್ಹಾಚಮಾಬಿ ಬೋಲುಸ್. ");
INSERT INTO vaa_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“ವ್ಯಬಿಚಾರ್‌ ನಾ ಕರ‍್ನು’ ಕರಿ ಬೋಲಾಸ್ತೆ ಇನ ತುಮೆ ಖ್ಹಮ್‌ಜಿರಾಖ್ಯಾಸ್‌. ");
INSERT INTO vaa_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","ಕತೋಬಿ ಮೇ ತುಮೂನ ಬೋಲುಸ್ಕಿ, ಕೋಣ್‌ತೋಬಿ ಬಿಜಿ ತಯೇಡಾನ ದೇಖಿನ್‌, ಇನಾಪರ್ ಆಖ್ಹ್ ಕರ‍್ಯೋತೊ, ಯೋ ತದ್ದೇಸ್ ಇನ ಮನ್‌ಮ ಯೋ ತಯೇಡಾನಿ ಜೋ಼ಡೆ ವ್ಯಬಿಚಾರ್‌ ಕರಾವಾಳೊ ಹುಯಿರ‍್ಹೋಸ್. ");
INSERT INTO vaa_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","ತಾರೊ ಖಾವೊ ಡೋಳೊ ತುನ ಪಾಪ್‌ಮ ಖ್ಹಪ್‌ಡವಾನು ಉಶೇತೊ, ಇನ ಕಚ಼್‌ಕೋರಿ ಫೇಕಿದೆ, ತಾರು ಹಿಡೀ ಶರೀರ್ ನರಕ್ಮ ಪಡಾಥೀಬಿ, ತಾರು ಶರೀರ‍್ನು ಏಕ್‌ ಭಾಗ್‌ ನಾ ರ‍್ಹಯುತೋಬಿ ತುನ ಅಛ್ಛು಼ ಕಾಹೆಕಿ ಶು. ");
INSERT INTO vaa_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","ತಾರೊ ಖಾವೊ ಹಾತ್ ತುನ ಪಾಪ್‌ಮ ಖ್ಹಪ್‌ಡವಾನು ರ‍್ಹಿಯುತೊ, ಇನ ಕತ್ರೀನ್ ಫೇಕಿದೆ! ತಾರು ಹಿಡಿ ಶರೀರ್ ನರಕ್ಮ ಪಡಾಥೀಬಿ, ತಾರು ಶರೀರ್‌ನು ಏಕ್‌ ಭಾಗ್‌ ನಿಕ್ಳಿಜಾ಼ವಾನುಸ್‌ ತುನ ಅಛ್ಛು಼ ಕಾಹೆಕಿ ಶು. ");
INSERT INTO vaa_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","ಇನಿ ಬಾವಣ್ಣ ಮ್ಹೇಲಿದ್ಯವಾಳೊ, ಇನ ತಲಾಕ್‌ನು ಕಾಗತ್‌ ಲೀಖಿದೀನ್‌ ಮ್ಹೇಲ್ನು ಕರಿ ಬೋಲೈರ‍್ಹುಸ್ ಎತ್ರೇಸ್. ");
INSERT INTO vaa_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","ಕತೋಬಿ ಮೇ ತುಮೂನ ಬೋಲುಸ್ಕಿ, ವ್ಯಬಿಚಾರ‍್ನಿ ಕಾರಣ್‌ ಕೊಂತೆಸ್ ಇನಿ ಬಾವಣ್ಣ ಮ್ಹೇಲಿದ್ಯವಾಳೊ ಯೋಸ್ ಇನಿ ಬಾವಣ್ಣ ವ್ಯಬಿಚಾರ್‌ಮ ಪಡಾನ ಜಿಮ್ಮೇದಾರಿ ಉಶೆ. ನಾಹುಯಿನ್ ಬಾವ್ರಿ ಮ್ಹೇಲಿಹುಯಿನ ವ್ಯಹಾ ಕರಿಲ್ಯವಳೋಬಿ ವ್ಯಬಿಚಾರಿ ಹುಯಿಜಾ಼ಸ್. ");
INSERT INTO vaa_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“ಝೂ಼ಟಿ ಆಣ್ ನಾ ಲೇವ್ಣು ; ಕತೋಬಿ ತುಮೆ ಪ್ರಭುಕನ ಬೋಲಿಲಿದೋತೆ ತಿಮ್ಮಸ್ ಚಾ಼ಲಿಲೇವ್ಣು ಕರಿ ಗಯೋತೆ ಜ಼ಮಾನಾನ ಅದ್ಮಿಯೇವ್ನ ಬೋಲ್ಯುತೆ ತುಮುನ ಮಾಲುಮಸ್ ಛಾ಼ನಿ. ");
INSERT INTO vaa_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","ಕತೋಬಿ ಮೇ ತುಮೂನ ಬೋಲಾನು ಶಾತ್‍ಕತೊ, ಆಣೆಸ್ ನಾಲೇವ್ಣು. ಆಬ್‍ಪರ್‌ ಆಣ್ ನಕೊ ಲೇವೊ; ಯೋ ದೇವ್‌ನು ಸಿಂಹಾಸನ್. ");
INSERT INTO vaa_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","ಧರ್ತಿಪರ್ ಆಣ್‌ ಕರೋನಕೊ ಯೋ ದೇವ್‌ನು ಗೋಡಾಮ್ಹೇಲಾನು ಕುಡ್‌ಶಿ’ ಯೆರೂಸಲೇಮ್‌ಪರ್ ಆಣ್ ನಾ ಕರ‍್ನು, ಶನಕತೊ ಯೆರೂಸಲೇಮ್‌ ಯೋ ಮಹಾನ್ ರಾಜಾ಼ನು ನಂಗರ್ ಹುಯಿರ‍್ಹುಸ್‍. ");
INSERT INTO vaa_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","ತಾರ ಮಾಥಪರ್‌ಬಿ ಆಣ್ ನಾ ಲೇವ್ಣು; ಶನಕತೊ, ಏಕ್‌ ಕೇಖ್ಹ್‌ನ ಜಿನ್‌ಕುಬಿ ಧೋಳು ರ‍್ಹವೊ, ನತರ್‌ಕಿ ಕಾಳು ರ‍್ಹವೊ ಕರಾನ ತುನ ಕೊವುಶೇನಿ. ");
INSERT INTO vaa_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","ಕತೋಬಿ ತುಮಾರಿ ವಾತೆ ಹೋ ಕತೊ ಹೋ, ಕೊಯ್ನಿಕತೊ, ಕೊಯ್ನಿ ಕರಿ ರ‍್ಹೇವಾದೆ. ಅನೇಥಿ ಜಾ಼ಖ್ಹತ್ ಬೋಲ್ಯಾತೊ, ಯೋ ಶೈತಾನ್‌ಥಿ ಆಯುಹುಯು ಕರಿ. ");
INSERT INTO vaa_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“ಡೋಳಾನ ಬದಲ್ ಡೋಳೊ, ದಾತ್ನ ಬದಲ್ ದಾತ್‌’ ಕಡಾವ್ಣು ಕರಿ ಬೋಲಿರಾಖ್ಯುಸ್ತೆ ಇನ ತುಮೆ ಖ್ಹಮ್‌ಜಿರಾಖ್ಯಾಸ್‌ ಎತ್ರೇಸ್. ");
INSERT INTO vaa_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","ಕತೋಬಿ ಮೇ ತುಮೂನ ಬೋಲಾನು ಶಾತ್‍ಕತೊ, ಕೋಣ್‌ತೋಬಿ ತುನ ಖರಾಬ್ ಕರ‍್ಯುತೊ, ಯೋ ಅದ್ಮಿನ ಬದ್‌ಲಾ ನಕೊ ಲೀಶ್‌. ಕೋಣ್‌ತೋಬಿ ಏಕ್‌ಜ಼ಣು ತಾರ ಖಾವಕಲ್ಲಪರ್ ಮಾರ‍್ಯುತೊ, ಇನ ಬಿಜೇಕ್ ಕಲ್ಲು ವತಾಳ್. ");
INSERT INTO vaa_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","ಅಜು಼ ಕೋಣ್‌ತೋಬಿ ತಾರ ಜೋ಼ಡೆ ಝಂಝಟ್‍ ಕರೀನ್, ತಾರ ಮಹಿನಲುಂಗ್ಡಾನ ಛೀನೈಲೇವ್ಣುಕರಿ ತೀರ್ಮಾನ್‌ ಕರವಾಳಾನ, ಉಪ್ಪರ್ ಪೇರ‍್ಹಿರಾಖ್ಯೋತೆ ಝ಼ಗ್ಗಾನಾಬಿ ಮ್ಹೆಂದೆ. ");
INSERT INTO vaa_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","ಏಕ್‌ ಜ಼ಣೊ ತುನ ಏಕ್‌ ಮೈಲ್ ದೂರ್ ಆವ್‌ಕರಿ ಜು಼ಲಮ್‌ ಕರ‍್ಯುತೊ ಇನಜೋ಼ಡೆ ಬೇ ಮೈಲ್ ದೂರ್ ಜಾ಼. ");
INSERT INTO vaa_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","ಕೋಣ್‌ತೋಬಿ ತಾರಕನ ಶಾತ್ತೋಬಿ ಮಾಂಗ್ಯುತೊ, ಇನ ದೇ; ತಾರಕನ ಕರಜ಼್ ಮಾಂಗವಾಳನ ಮ್ಹೋಡು ನಕೊ ಫರೈಲೀಶ್‌. ");
INSERT INTO vaa_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“ತಾರ ಭೀಡೆವಾಳಾನ ಪ್ಯಾರ್ ಕರ್‌ ಅಜು಼ ತಾರ ದುಶ್‌ಮನ್ನ ವಹೇರ್‌ ಕರ‍್ನು’ ಕರಿ ಬೋಲಿರಾಖ್ಯುಸ್ತೆ ಇನ ತುಮೆ ಖ್ಹಮ್‌ಜಿರಾಖ್ಯಾಸ್‌ ಎತ್ರೇಸ್. ");
INSERT INTO vaa_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","ಕತೋಬಿ ಮೇ ತುಮೂನ ಬೋಲಾನು ಶಾತ್‌ಕತೊ, ತುಮಾರ ದುಶ್‌ಮನ್ನ ಪ್ಯಾರ್ ಕರೊ; ತುಮೂನ ಖ್ಹತಾವವಾಳನಟೇಕೆ ದೇವ್ನ ಪ್ರಾರ್ಥನೆ ಕರೊ. ");
INSERT INTO vaa_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","ಅಮ್ ಕರ‍್ಯಾತೊ, ಪರ್‌ಲೋಕ್‌ಮ ಛಾ಼ತೆ ತುಮಾರ ಬಾನ ತುಮೆ ಲಡ್ಕಾಉಶು. ಯೋ ಖರಾಬ್ನ ಉಪ್ಪರ್‌ಬಿ ಅಛ್ಛಾ಼ನ ಉಪ್ಪರ್‌ಬಿ ಇನೊ ಚಾ಼ಂದ್ನು ಉಜಾ಼ಳು ಪಡಾನಿಘೋಣಿ ಕರಾಸ್, ನೀತಿವಾಳಾನ ಉಪ್ಪರ್‌ಬಿ ಅನೀತಿವಾಳಾನ ಉಪ್ಪರ್‌ಬಿ ಪಾಣಿ ವರ್ಖ್ಹಾವಸ್‌. ");
INSERT INTO vaa_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","ತುಮೂನ ಪ್ಯಾರ್ ಕರಾವಾಳನಾಸ್‌ ತುಮೆ ಪ್ಯಾರ್ ವತಾಳ್ಯಾತೊ ದೇವ್ ತುಮೂನ ಶನ ಇನಾಮ್ ದಿಶೆ? ಶುಂಕವಶೂಲ್‍ ಕರವಾಳುಬಿ ಅಮ್ಮಸ್ ಕರಾಸ್ನಿ! ");
INSERT INTO vaa_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","ತುಮೆ ಖಲಿ ತುಮಾರ ದೋಸ್ತಿ ಖ್ಹಾರಾನಾಸ್ ಮಾನ್-ಮರ‍್ಯಾದಿ ವತಾಳ್ಯಾತೊ, ಇನಾಮ ಶಾತ್‌ ಬಡೈಮಾರಿಲೆವಾನು ಛಾ಼? ದೇವ್ನ ಪರ್‌ಖ್ಯುಕೊಂತೆ ಅದ್ಮಿ ಖ್ಹಾರುಬಿ ಇಮ್ಮಸ್ ಕರಾಸ್ನಿ! ");
INSERT INTO vaa_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","ಇನಖ್ಹಾಜೇಸ್, ಪರಲೋಕ್‍ಮ ಛಾ಼ತೆ ತುಮಾರೊ ಬಾ ಖೆವಿಸ್ ಗಲ್ತಿಕೊಂತೆ ಛಾ಼ತೆ ಇಮ್‌, ತುಮೇಬಿ ಗಲ್ತಿಕೊಂತೆ ಇಮ್‌ ರ‍್ಹವೊ. ");
INSERT INTO vaa_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","ಅದ್ಮಿ ದೇಖಾದೆ ಕರಿ ತುಮೆ ಇವ್ಣ ಖ್ಹಾಮೆ ತುಮಾರು ಅಛ್ಛು಼ಕಾಮ್ನ ನಾ ಕರ‍್ನು. ಇಮ್‌ ಕರ‍್ಯಾತೊ, ಸೊರ್ಗಾಮ ಛಾ಼ತೆ ತುಮಾರ ಬಾಕನ ತುಮೂನ ಶಾತ್ಬಿ ಇನಾಮ್ ಕೋ ಮಳ್‌ಶೇನಿ. ");
INSERT INTO vaa_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","ಇನಖ್ಹಾಜೇಸ್ ತು ಧರಮ್ ದ್ಯವಾನಿ ವಖ್ಹತ್‌ಮ, ನಕೊ ಫೂಕಿಲೇವೊ. ಅದ್ಮಿಥಿ ಖ್ಹರಾವ್ಣಿ ಕರಿಲೇವ್ಣುಕರಿ ಖೋಟ್ ದಿಲ್‌ವಾಳು ಯೆಹೂದ್ಯರ್‌ಬಿ ಸಬೆ ಭರಾವಾನು ಮಂದಿರ್‌ಮ ಅಜು಼ ಗಲ್ಲಿಯೇಮ ಅಮ್ಮಸ್ ಕರಾಸ್. ಮೇ ಖ್ಹಾಚಮಾಬಿ ಬೋಲುಸ್ಕಿ, ಇವ್ಣುನ ಮಳ್‌ಣುತೆ ಧನ್ಯವಾದ್ ತದೇಸ್‌ ಮಳಿಗಯು. ");
INSERT INTO vaa_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","ಕತೋಬಿ ತುಮೆ ಧರಮ್ ದ್ಯವಾನಿ ವಖ್ಹತ್‌ಮ, ತಾರೊ ಖಾವಹಾತೆ ದಿದೋತೆ ಧರಮ್, ತಾರೊ ಡಾವ ಹಾತ್‌ನಾಬಿ ನಾ ಮಾಲುಮ್‌ ಪಡ್‌ಣೂತೆ ಇಮ್‌ ದೇ. ");
INSERT INTO vaa_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","ಅಜು಼ ದಿಲ್ಮ ಚಾ಼ಲಾತೆ ಇನ ದೇಖವಾಳೊ ತಾರೊ ಬಾ, ತುನ ಇನಾಮ್ ದಿಶೆ. ");
INSERT INTO vaa_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“ತುಮೆ ಪ್ರಾರ್ಥನೆ ಕರಾನಿ ವಖ್ಹತ್‌ಮ, ಖೋಟ್ ದಿಲ್‌ವಳಾನಿಮತ್‌ ನಕೊ ಪ್ರಾರ್ಥನೆ ಕರ್‌; ಅದ್ಮಿಖ್ಹಾರು ದೇಖಾದೆಕರಿ ಇವ್ಣೆ ಸಬೇನು ಮಂದಿರ್‌ಮ ಅಜು಼ ಗಲ್ಲಿಯೇನು ಚೌ಼ಕ್‌ಮ ಭೀರಿನ್‌, ಪ್ರಾರ್ಥನೆ ಕರಾನ ಆಖ್ಹ್‌ಕರಾಸ್‌. ಮೇ ತುಮೂನ ಖ್ಹಾಚಮಾಬಿ ಬೋಲುಸ್ಕಿ, ಇವ್ಣುನ ಮಳ್‌ಣುತೆ ಇನಾಮ್ ತದ್ದೇಸ್ ಮಳಿಗಯು. ");
INSERT INTO vaa_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","ಕತೋಬಿ ತೂ ಪ್ರಾರ್ಥನೆ ಕರಾನಿ ವಖ್ಹತ್‌ಮ, ತಾರ ಮಹಿನಕೋಣಾಮ ಜೈ಼ನ್, ಬಾಕಲ್‌ ಲಗಾಡಿನ್, ದಿಲ್ಮ ಛಾ಼ತೆ ತಾರ ಬಾನ ಪ್ರಾರ್ಥನೆ ಕರ್‌. ತದೆ ದಿಲ್ಮ ಚಾ಼ಲಾಸ್ತೆ ಇನ ದೇಖವಾಳೊ ತಾರೊ ಬಾ, ತುನ ಇನಾಮ್ ದಿಶೆ. ");
INSERT INTO vaa_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“ತೂ ಪ್ರಾರ್ಥನೆ ಕರಾನಿ ವಖ್ಹತ್‌ಮ, ದೇವ್ನ ಪರ್ಖಾಕೊಂತೆ ಅದ್ಮಿ ಬೋಲಾಸ್ತೆ ಇಮ್‌, ಮತ್ಲಬ್‌ಕೊಂತೆ ವಾತೇನ ಘಡಿಕೇಡೆ ನಕೊ ಬೋಲ್. ಇವ್ಣೆ ಘಣಿ ವಾತೆ ಬೋಲ್ಯಾತೊ, ಇವ್ಣಿ ಪ್ರಾರ್ಥನೆ ದೇವ್ ಖ್ಹಮಜ಼್‌ಶೆ ಕರಿ ಸೋಚ಼ಸ್‌. ");
INSERT INTO vaa_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","ಇನಖ್ಹಾಜೇಸ್ ತುಮೆ ಇವ್ಣಿನಿಘೋಣಿ ನಕೊ ಕರೊ, ತುಮೆ ತುಮಾರ ಬಾಕನ ಮಾಂಗಿಲ್ಯವಾನ ಅಗಾಡಿಸ್, ತುಮೂನ ಶಾತ್‌ ಜ಼ರೂರತ್ ಛಾ಼ ಕರಿ ಇನ ಮಾಲುಮ್‌. ");
INSERT INTO vaa_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","ಇನಖ್ಹಾಜೇಸ್, ತುಮೆ ಸೊರ್ಗಾನ ಬಾನ ಅಮ್ ಪ್ರಾರ್ಥನೆ ಕರ‍್ನು: ");
INSERT INTO vaa_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","ಸೊರ್ಗಾಮ ಛಾ಼ತೆ ಮಾರೊ ಬಾ: ತಾರು ನಾಮ್ ಪರಿಶುದ್‌ಕರಿ ಗಣ್ತಿ ಹುವಾದೆ. ತಾರಿ ರಾಜ್ಯ ಆವಾದೆ; ತಾರಿ ಮರ್ಜಿ ಸೊರ್ಗಾಮ ಚಾ಼ಲಾಸ್ತೆ ಇಮ್ಮಸ್, ಧರ್ತಿಪರ್‌ಬಿ ಚಾ಼ಲಾದೆ. ");
INSERT INTO vaa_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","ಹಮ್ಕೆ ಹಮೂನ ದನ್‌ಪರೋಜ಼್‌ನು ಖಾಣು ದೇ. ");
INSERT INTO vaa_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","ಹಮಾರ ವಿರೋದ್ ಗಲತ್‌ ಕರಾವಾಳನ, ಹಮೆ ಮಾಪ್‌ ಕರೇಸ್ತೆ ಇಮ್ಮಸ್, ಹಮಾರಿ ಗಲ್ತಿನ ತೂ ಮಾಪ್‌ಕರ್‌. ");
INSERT INTO vaa_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","ಹಮೂನ ಶೋದನೆಮ ನಕೊನಾಕ್‌, ಕತೋಬಿ ಶೈತಾನ್‌ಥಿ ಹಮೂನ ಛೋ಼ಡಾವ್.’ ");
INSERT INTO vaa_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","ತುಮೆ ಅದ್ಮಿಖ್ಹಾರನಿ ಗಲತ್‌ನ ಮಾಪ್‌ ಕರ‍್ಯಾತೊ, ಪರಲೋಕ್‍ಮ ಛಾ಼ತೆ ತುಮಾರೊ ಬಾಬಿ ಜಿನು ತುಮಾರಿ ಗಲತ್‍ನಾಬಿ ಮಾಪ್‌ ಕರ್ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","ಕತೋಬಿ ತುಮೆ ಅದ್ಮಿನು ಗಲತ್‌ನ ಮಾಪ್‌ ನಾ ಕರ‍್ಯಾತೊ, ತುಮಾರೊ ಬಾ ಹುಯಿರ‍್ಹೋತೆ ದೇವ್‌ಬಿ ತುಮಾರು ಗಲತ್‌ನ ಮಾಪ್‌ ಕೋ ಕರ್‌ಶೇನಿ. ");
INSERT INTO vaa_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“ತುಮೆ ಉಪವಾಸ್ ಕರಾನಿ ವಖ್ಹತ್‌ಮ, ಖೋಟ್ ದಿಲ್‌ವಾಳನಿಘೋಣಿ ಮ್ಹೋಡು ನಾ ಮುರ್‌ಝೈ಼ಲೇಣು. ಇವ್ಣೆ ಉಪವಾಸ್ ಛಾ಼ ಕರಿ ಅದ್ಮಿಯೇನ ವತಾಳಿಲೆವಾನಖ್ಹಾಜೆ ಇವ್ಣು ಮ್ಹೋಡಾನ ಇಮ್‌ ಕರಿಲೇಸ್, ಮೇ ತುಮೂನ ಖ್ಹಾಚಮಾಬಿ ಬೋಲುಸ್ಕಿ, ಇವ್ಣುನ ಮಳ್‌ಣುತೆ ಇನಾಮ್ ತದೇಸ್‌ ಮಳಿಗಯು. ");
INSERT INTO vaa_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","ಕತೋಬಿ ತೂ ಉಪವಾಸ್ ಕರಾನಿ ವಖ್ಹತ್‌ಮ, ಮುಡ್‌ಕ್ಯಾನ ತೇಲ್ ಲಗಾಡಿಲೀನ್‌, ಮ್ಹೋಡು ಧೊಯಿಲೆ. ");
INSERT INTO vaa_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","ಅಮ್ ಕರ‍್ಯೋತೊ, ತೂ ಉಪವಾಸ್ ಛಾ಼ ಕರಿ ಅದ್ಮಿಯೇನ ಮಾಲುಮ್‌ ಕೋ ಪಡ್‌ಶೇನಿ, ಕತೋಬಿ ದಿಲ್ಮ ರ‍್ಹವಾಳ ತಾರ ಬಾನ ಯೋ ಮಾಲುಮ್‌ಪಡ್‍ಶೆ. ದಿಲ್ಮ ಚಾ಼ಲಸ್ತೆ ಇನ ದೇಖವಾಳೊ ತಾರೊ ಬಾ, ತುನ ಇನಾಮ್ ದಿಶೆ. ");
INSERT INTO vaa_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“ಜಗತ್‌ಪರ್ ತುಮಾರಖ್ಹಾಜೆ ಧನ್‌ದೌಲತ್‌ನ ನಕೊ ಜ಼ಮಕರಿಲೇವೊ, ಹಜ್ಜಾ಼ ಇನ ಕಿಲಪ್‍ಧರೀನ್‌, ಕೋರ‍್ಹಖೈನ್‌, ನಾಶ್ ಹುಯಿಜಾ಼ಸ್ ಅಜು಼ ಚೋ಼ರ್ ಖ್ಹಾರು ಘರ್‌ನ ಫೋಡಿನ್, ಇನ ಚೋ಼ರಿ ಕರಿಲಿಶೆ. ");
INSERT INTO vaa_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","ಕತೋಬಿ ಸೊರ್ಗಾಮ ಶೊತ್‍ ಕರಿರಾಖೊ. ಹಿಜ್ಜಾ಼ ಯೋ ಕೋರ‍್ಹ ಖೈನ್‌, ಕಿಲಪ್‍ ಧರೀನ್ ಲುಕ್ಷಾನ್ ಕೋ ಹುವಾನಿ, ಅಜು಼ ಚೋ಼ರ್ ಖ್ಹಾರು ಘರ್‌ಫೋಡ್‍ಶೇಬಿ ಕೊಯ್ನಿ. ಚೋ಼ರೀಬಿ ಕರಾಕೊಯ್ನಿ. ");
INSERT INTO vaa_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","ಶನಕತೊ ತುಮಾರಿ ಶೊತ್‌ ಕಿಜ್ಜಾ಼ ರ‍್ಹೇಸ್ಕಿ, ಹಿಜ್ಜಾ಼ಸ್ ತುಮಾರೊ ದಿಲ್‌ಬಿ ರ‍್ಹೇಸ್‌. ");
INSERT INTO vaa_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“ಡೋಳಾ ಶರೀರ್‌ನ ದಿವಾನಿಘೋಣಿ ಹುಯಿರ‍್ಹುಸ್‍. ತಾರ ಡೋಳ ಬರೋಬರ್ ರ‍್ಹಯಾತೊ, ತಾರು ಶರೀರ್ ಅಖ್ಖುಸ್, ಉಜಾ಼ಳು ಹುಯಿರ‍್ಹಿಷೆ. ");
INSERT INTO vaa_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","ಕತೋಬಿ ತಾರ ಡೋಳಾ ಖರಾಬ್ ರ‍್ಹಯಾತೊ, ತಾರು ಶರೀರ್ ಅಖ್ಖುಸ್ ಅಂಧಾರು ಹುಯಿರ‍್ಹಿಷೆ. ತಾರಮಾನು ಉಜಾ಼ಳುಸ್‌ ಅಂಧಾರು ಹುಯಿರ‍್ಹಯುತೊ, ಯೋ ಕೆತ್ರೆ ಖತರ್‌ನಾಕ್ ಹುಯಿರ‍್ಹಿಶೆ! ");
INSERT INTO vaa_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“ಕೋಣ್‌ಬಿ ಬೇ ಯಜಮಾನ್ನ ಸೇವೆಕರಾನ ಕೊಹೊಯ್ನಿ. ಯೋ ಏಕ್‌ನ ವಹೇರ್‌ ಕರೀನ್, ಬಿಜೇಕ್‌ನ ಪ್ಯಾರ್ ಕರ್ಶೆ; ನತರ್ ಏಕ್‌ನ ಜೋ಼ಡೆ ಅಛ್ಛಿಂತ್ರ ರ‍್ಹೀನ್, ಬಿಜೇಕ್‌ನ ಫಿಕ್ಕರ್‌ಕೊಕರ್ಷೇನಿ. ತುಮೆ ದೇವ್‍ನಾಬಿ, ಪೈಶಾನಾಬಿ ಭೇನಾ ಏಕ್‌ದಮ್ ಸೇವೆ ಕರಾನ ಕೋಹುವ್ವಾನಿ. ");
INSERT INTO vaa_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","ಇನಖ್ಹಾಜೇಸ್ ಮೇ ತುಮೂನ ಬೋಲುಸ್ಕಿ, ಜಿವಾನಖ್ಹಾಜೆ ಶಾತ್‌ ಖಾಣು ಅಜು಼ ಪೀಣು ಕರಿ ಬೋಲಾನಿ ಬಾರೇಮರ‍್ಹವೊ, ನತರ್‌ಕಿ ಶರೀರ್‌ನ ಹೋಣುತೆ ಲುಂಗ್ಡಾವ್‍ನಿ ಬಾರೇಮರ‍್ಹವೊ ವೇಚ಼್‌ಣೆ ನಕೊ ಕರೊ. ಖಾಣಥೀಬಿ ಜಾನ್‌, ಅಜು಼ ಲುಂಗ್ಡಾವ್‍ಥೀಬಿ ಶರೀರ್ ಮಹಾನ್ ಕಾಹೆಕಿ ಶು? ");
INSERT INTO vaa_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","ಆಕಾಶ್‌ಪರ್ ಉಡಾಸ್ತೆ ಜಿನಾವರ್‌ನ ದೇಖೊ, ಯೋ ಪಿಕಾವಕೊಯ್ನಿ, ವ್ಹಾಡಕೊಯ್ನಿ, ಕಣ್ಗಿ ಭರಿನ್ ಮ್ಹೇಲಾಕೊಯ್ನಿ. ಇಮ್‌ ರ‍್ಹಯುತೋಬಿ, ಸೊರ್ಗಾಮ ಛಾ಼ತೆ ತುಮಾರೊ ಬಾ, ಯೋ ಖ್ಹಾರಾನ ಪಾಳಿನ್ ಪರ್ವೇಶ್ ಕರಾಸ್. ಇವ್ಣೆಥಿಬಿ ತುಮೆ ಕೆತ್ರೇಕ್ಕಿ ಊಚ಼ ಹುಯಿರ‍್ಹಾಸ್ನಿ? ");
INSERT INTO vaa_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","ತುಮೆ ವೇಚ಼್‌ಣೆ ಕರಿನ್‌ ಏಕ್‌ ಘಡಿತೋಬಿ ಜಾ಼ಖ್ಹತ್ ಜಿವಾನ ತುಮಾರಮ ಕಿನೇಥೀಬಿ ಉಶೇಕಿ ಶು? ");
INSERT INTO vaa_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","ಎತ್ರೇಸ್ ಕಾಹೆತೆ ಪೇರ‍್ಹಾನ ಲುಂಗ್ಡಾನಿ ಬಾರೇಮ ಶನ ಫಿಕರ್ ಕರೋಸ್? ಜ಼ಂಗ್‍ಳಿಫೂಲ್‍ ಫುಟಾಸ್ತೆ ತರಿಕಾನ ದೇಖೊ: ಯೋ ಮ್ಹಿನತ್ ಕರಕೊಯ್ನಿ, ಖ್ಹುದ್‌ನಖ್ಹಾಜೆ ಲುಂಗ್ಡಾಬಿ ಬಣೈಲೇಯ್ ಕೊಯ್ನಿ. ");
INSERT INTO vaa_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","ರ‍್ಹಯುತೋಬಿ ಮೇ ತುಮೂನ ಬೋಲುಸ್ಕಿ, ರಾಜ಼ ಸೊಲೊಮೋನ್ ಇನಾಕನ ಥೂತೆ ಖ್ಹಾರೂಸ್ ವೈಭೋಗ್‌ಥಿಬಿ ಪೇರ್‌ವಾಖ್ಹ್‌ನ ಪೇರ‍್ಹಿರಾಖ್ಯೊಥೋತೆ ವಖ್ಹತ್‍ಮಾಬಿ, ಆ ಫೂಲ್‌ಮ ಏಕ್‌ನ ಛಾ಼ತೆ ಶನ್‌ಗಾರ್ ಎತ್ರೆ ಇನ ಕೋ ಥೂನಿ. ");
INSERT INTO vaa_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","ಅಲಾ, ದರ್ರಾಶಿ ವಿಶ್ವಾಸ್‌ವಾಳ, ಹಮ್ಕೆರ‍್ಹೀನ್‌ ಕಾಲ್‌ ಚು಼ಲ್ಹಾಮ ಬಳಿಜಾ಼ವಾನ ಜ಼ಂಗ್‌ಳಿ ಘಾಖ್ಹ್‌ನ ದೇವ್ ಅಮ್ ಪೇರ‍್ಹಾಯೋತೊ, ಅನೇಥಿಬಿ ಜಾ಼ಖ್ಹತ್ ತುಮೂನ ಹೋಡಾವ್‌ಶೆ, ಫೇರಾವ್‌ಶೆ ಕೊಯ್ನಿಕಿಶು? ");
INSERT INTO vaa_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","ಇನಖ್ಹಾಜೇಸ್, ಶಾತ್‌ ಖಾಣು? ಕರಿ ರ‍್ಹವೊ, ನತರ್‌ಕಿ ಶಾತ್‌ ಪೀಣು?ಕರಿ ರ‍್ಹವೊ, ಶಾತ್ ಫೇರ್‌ನು? ಕರಿ ಬೋಲಾನಿ ಬಾರೇಮ ರ‍್ಹವೊ ವೇಚ಼್‌ಣೆ ನಕೊ ಕರೊ. ");
INSERT INTO vaa_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","ಆ ತಮಾಮ್‍ನಖ್ಹಾಜೆ ದೇವ್‌ಮ ಅಲಕ್‌ ಅದ್ಮಿಖ್ಹಾರು ಕದೇಬಿ ವೇಚ಼್‌ಣೆ ಕರಸ್. ಆ ಖ್ಹಾರು ತುಮೂನ ಜ಼ರೂರತ್ ಛಾ಼ಕರಿ ಪರಲೋಕ್‍ಮ ಛಾ಼ತೆ ತುಮಾರ ಬಾನ ಮಾಲುಮ್. ");
INSERT INTO vaa_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","ಅನಬದಲ್, ತುಮೆ ಪಹಿಲೆ ದೇವ್ನು ರಾಜ್ಯನಖ್ಹಾಜೆ ಅಜು಼ ಇನಿ ನೀತಿನ ಖ್ಹಾಜೇಬಿ ತರ್ಖ್ಹೊ. ತದೆ ಅನಜೋ಼ಡೆ ಯೋ ಖ್ಹಾರೂಸ್ ಮಳ್‌ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","ಇನಖ್ಹಾಜೇಸ್, ಕಾಲ್ನಿ ಬಾರೇಮ ಫಿಕರ್ ನಕೊ ಕರೊ; ಕಾಲ್‌ನೊ ದನ್ ಇನಿ ಬಾರೇಮ ಯೋಸ್ ಫಿಕರ್ ಕರಿಲಿಶೆ. ಯೋ ದನ್ನಿ ಖ್ಹತಾಪ್ಣಿ ಯೋ ದನ್‌ಮಾಸ್ ಬಶ್‌. ");
INSERT INTO vaa_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“ತುಮೆ, ಬಿಜಾ಼ನ ತೀರ್ಪ್‌ ನಕೊ ಕರೊ, ತದೆ ದೇವ್‌ಬಿ ತುಮೂನ ತೀರ್ಪ್‌ ಕೋ ಕರ್‌ಶೇನಿ. ");
INSERT INTO vaa_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","ತುಮೆ ಬಿಜಾ಼ನ ಕಿಮ್ ತೀರ್ಪ್‌ ಕರಾಸ್ಕಿ, ಇಮ್ಮಸ್ ದೇವ್‌ಬಿ ತುಮೂನ ತೀರ್ಪ್ ಕರ್ಶೆ, ಅಜು಼ ತುಮೆ ಬಿಜಾ಼ನ ಕಿಮ್ ಮಾಪಿನ್‌ ದೇಸ್ಕಿ, ಇಮ್ಮಸ್ ದೇವ್‌ಬಿ ತುಮೂನ ಮಾಪಿನ್‌ ದಿಶೆ. ");
INSERT INTO vaa_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","‘ತೂ ತಾರ ಡೋಳಾಮ ಛಾ಼ತೆ ಪೇದಡ್‌ನಿ ಬಾರೇಮ ಸೋಚ್ಯೊಕೊಂತೆ, ತಾರ ಭೈನ ಡೋಳಾಮ ಛಾ಼ತೆ ಕಾಕ್ರಿನಿ ಬಾರೇಮ ಸೋಚಾಸ್ತೆ ಕಿಮ್? ");
INSERT INTO vaa_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","ತು ತಾರ ಭೈನ, ಭೈ ತಾರ ಡೋಳಾಮ ಛಾ಼ತೆ ಕಾಕ್ರಿನ ಕಾಡುಸ್‌ ಆವ್’ ಕರಿ ತು ಕಿಮ್ ಬೋಲಾಸ್? ತಾರ ಡೋಳಾಮ ಪೇದಡಸ್‌ ಛಾ಼ನಿ? ");
INSERT INTO vaa_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","ಅಲಾ ಠಗಾರ! ತಾರ ಡೋಳಾಮ ಛಾ಼ತೆ ಪೇದಡ್‌ನ ಪಹಿಲೆ ಕಾಡ್, ತದೆ ತಾರ ಭೈನ ಡೋಳಾಮ ಛಾ಼ತೆ ಕಾಕ್ರಿ ತುನ ಅಛ್ಛಿನಿತರ ದೆಖಾವ್‌ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","ಪರಿಶುದ್ ರಾಛ಼ವ್‍ನ ಕುತ್‌ರ‍್ಯಾವ್‍ನ ನಕೊ ನಾಖೊ; ಯೊ ಪಾಛು಼ಫರಿ ತುಮಾರಪರ್ ಪಡಿನ್ ಕಲ್ಡಿನಾಕ್ಷೆ. ಮುತ್ತ್ ಖ್ಹಾರು ಡೂಕರ್‌ನ ಖ್ಹಾಮ್ಣೆ ರಂಚೊ಼ ನಕೊ. ಯೊಅಖ್ಖು ಯೊ ಮುತ್ನ ಖುಂದ್ಲಿನಾಕ್ಷೆ. ");
INSERT INTO vaa_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“ಮಾಂಗಿಲೇವೊ, ತದೆ ತುಮೂನ ದೇವಾವ್‌ಶೆ; ಢೂಂಡೊ, ತದೆ ತುಮೂನ ಮಳ್‌ಶೆ; ಖಟ್‌ಖಟಾವೊ, ತುಮುನ ಬಾಕಲ್‌ ನಿಕಳ್‌ಶೆ, ");
INSERT INTO vaa_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","ಶನಕತೊ ಮಾಂಗವಾಳ ಹರೇಕ್‌ನ ದೆವಾವ್‌ಶೆ, ಅಜು಼ ಢೂಂಡವಾಳನ ಮಳ್‌ಶೆ, ಕೋಣ್ ಖಟ್‌ಖಟಾವಸ್ಕಿ ಇನ ಬಾಕಲ್ ಕಡಾವ್‌ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","ತುಮಾರಾಮ ಕೋಣ್‌ತೋಬಿ ರೋಟೊ ಮಾಂಗವಾಳ ಛಿಯ್ಯಾನ ಬಂಡೊ ದಿಶುಕಿ ಶು? ");
INSERT INTO vaa_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","ನತರ್‌ಕಿ ಮಾಛ಼್‌ಲು ಮಾಂಗ್ಯೊತೊ, ಖ್ಹಾಪ್‍ನ ದಿಶೆ! ");
INSERT INTO vaa_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","ಇಮ್‍ಕತೊ ಖರಾಬ್ ಹುಯಿರ‍್ಹಾತೆ ತುಮೇಸ್ ತುಮಾರ ಲಡ್ಕಾವ್‍ನ ಅಛ್ಛು಼ ರಾಛ಼ವ್‌ನ ದೆವಾಪರ್, ಪರಲೋಕ್‌ನೊ ತುಮಾರೊ ಬಾ, ಇನಾಕನ ಮಾಂಗವಾಳನ ಕೆತ್ರೇಕ್ಕಿ ಅಛ್ಛು಼ ರಾಛ಼ವ್‍ನ ದಿಶೆಕೊಯ್ನಿಕಿ ಶು? ");
INSERT INTO vaa_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","ಅದ್ಮಿಖ್ಹಾರು ತುಮೂನ ಶಶ್ಶಾತ್ ಕರ‍್ನುಕರಿ ತುಮೆ ಆಖ್ಹ್ ಕರೋಸ್ಕಿ, ಯೋಸ್ ತುಮೆ ಇವ್ಣುನ ಕರೊ: ಮೋಶೇನು ಧರ್ಮಶಾಸ್ತ್ರ ಅಜು಼ ಪ್ರವಾದಿಯೇನು ವಚನ್ನು ಮತ್‌ಲಬ್ ಆಸ್ ಹುಯಿರ‍್ಹೂಸ್. ");
INSERT INTO vaa_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","ನ್ಹಾನ ಬಾಕಲ್ ವಾಟೆಕರಿ ಮಹಿ ಜಾ಼ವೊ, ಶನಕತೊ ನರಕ್‌ನ ಜಾ಼ವಾನು ಬಾಕಲ್ ಝಾ಼ಲು ಅಜು಼ ಇನಾಮ ಚಾ಼ಲಿ ಜಾ಼ವಾನು ಶುಲ್ಬ, ಅಜು಼ ಇನಾಮ ಜಾ಼ವಾಳು ಅದ್ಮಿ ಘಣು. ");
INSERT INTO vaa_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","ಕತೋಬಿ ಹಮೇಶಾನಿ ಜಿ಼ಂದ್‌ಗೀಮ ಜಾ಼ವಾನು ಬಾಕಲ್‌ ನ್ಹಾನು ಅಜು಼ ಇನಾಮ ಜಾ಼ವಾನ ಮುಶ್ಕಿಲ್, ಯೋ ಮಾರಗ್‌ನ ಢೂಂಡಿಲ್ಯವಾಳು ಥೋಡುಸ್ ಅದ್ಮಿ. ");
INSERT INTO vaa_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","ಝೂ಼ಟ ಪ್ರವಾದಿಯೇನಿ ಬಾರೇಮ ಹೊಷಾರ್‌ಥಿ ರ‍್ಹವೊ; ಇವ್ಣೆ ಮೇಂಢಾನು ಪೇರ್‌ವಾಖ್ಹ್‌ನ ಘಾಲಿಲೀನ್‌ ತುಮಾರಕನ ಆವ್‌ಶೆ, ಕತೋಬಿ ಮಹಿ ದೇಖ್ಯುತೊ ಇವ್ಣೆ ಖ್ಹಾಚಮಾಬಿ ಝಂಜೋ಼ಡಿ ಖವಾಳ ಜ಼ರಕ್‌ನಿಘೋಣಿ ಹುಯಿರ‍್ಹೂಸ್. ");
INSERT INTO vaa_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","ತುಮೆ ಇವ್ಣಿ ಚಾ಼ಲ್‌ಥೀಸ್ ಇವ್ಣುನ ಮಾಲುಮ್‌ ಕರಿಲಿಶು. ಕಾಟಾನಿ ಡಾಗೇಮ ದ್ರಾಕ್ಷಿನು ಪಂಡಾ ಅಜು಼ ದತ್ತೂರಿನ ಝಾ಼ಡಾವ್‌ಮ ಅಂಜೀರ್‌ನ ಪಂಡಾ ಮ್ಹೇಲಾಸ್ಕಿ ಶು? ");
INSERT INTO vaa_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","ಇಮ್ಮಸ್ ಅಛ್ಛು಼ ಝಾ಼ಡು ಅಛ್ಛು಼ಸ್ ಪಂಡು ದೇಸ್, ಕತೋಬಿ ಕೀಡ್‌ಣು ಝಾ಼ಡು ಖ್ಹಡ್ಯುಪಂಡು ದೇಸ್. ");
INSERT INTO vaa_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","ಅಛ್ಛು಼ ಝಾ಼ಡು ಖ್ಹಡ್ಯು ಪಂಡು ಕೋ ದೇಯ್ನಿ, ಅಜು಼ ಕೀಡ್‌ಣು ಝಾ಼ಡು ಅಛ್ಛು಼ ಪಂಡು ಕೋ ದೇಯ್ನಿ. ");
INSERT INTO vaa_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","ಅಜು಼ ಅಛ್ಛು಼ ಪಂಡು ದೇಯಿಕೊಂತೆ ಹರೇಕ್ ಝಾ಼ಡನ ಕತ್ರೀನ್, ಆಗ್‌ಮ ನಾಖಾಸ್. ");
INSERT INTO vaa_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","ಅಮ್ ಝೂ಼ಟಿ ಪ್ರವಾದಿಯೇನು ಚಾ಼ಲ್‌ಥೀಸ್ ತುಮೆ ಇವ್ಣುನ ಮಾಲುಮ್‌ ಕರಿಲಿಶು. ");
INSERT INTO vaa_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“ಮನ, ‘ಪ್ರಭು, ಪ್ರಭು’ ಕರಿ ಬೋಲವಾಳು ಖ್ಹಾರು ಸೊರ್ಗ ರಾಜ್ಯಮ ಜಾ಼ಶೆಕರಿ ನಕೊಲ್ಹಾವೊ. ಕತೋಬಿ ಸೊರ್ಗಾಮ ಛಾ಼ತೆ ಮಾರ ಬಾನಿ ಮರ್ಜಿನಿಘೋಣಿ ಚಾ಼ಲವಾಳುಸ್ ಸೊರ್ಗ ರಾಜ್ಯಮ ಜಾ಼ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","ನ್ಯಾವ್‍ನಿ ತೀರ್ಪ್‌ನ ದನ್ಮ ಕೈಯೆಕ್ಕಿ ಅದ್ಮಿ ಮನ, ‘ಪ್ರಭು, ಪ್ರಭು’ ತಾರ ನಾಮ್‌ಪರ್‌ ಹಮೆ ಪ್ರವಾದ್‌ನೆ ಬೋಲ್ಯ, ತಾರ ನಾಮ್‍ಪರ್ ಹಮೆ ಭೂತ್‌ನ ಖ್ಹಾರು ಕಾಡ್ಯ ಅಜು಼ ಕೈಯೆಕ್ಕಿ ಮಹಾನ್ ಕಾಮ್ನ ಕರ‍್ಯಾ, ಕರಿ ಬೋಲ್‌ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","ತದೆ ಮೇ ಇವ್ಣುನ, ತುಮೆ ಕೋಣ್‌ಕರಿ ಮನ ಮಾಲುಮಸ್ ಕೊಯ್ನಿ. ಮಾರೇಥಿ ದೂರ್ ಹಟಿಜಾ಼ವೊ, ತುಮೆ ಖರಾಬ್ ಅದ್ಮಿ ಹುಯಿರ‍್ಹಾಸ್!” ಕರಿ ಬೋಲಿಶ್. ");
INSERT INTO vaa_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“ಇನಖ್ಹಾಜೇಸ್, ಆ ಮಾರಿ ವಾತೇನ ಖ್ಹಮ್‌ಜಿನ್‌, ಅನೀನಿಘೋಣಿ ಚಾ಼ಲವಾಳು ಹರೇಕ್ ಜ಼ಣು ಬಂಡಾಪರ್ ಘರ್ ಭಾಂದಿಲೇಸ್ತೆ ಅಕ್ಲಿ ಅದ್ಮಿನಿಘೋಣಿ ಹುಯಿರ‍್ಹೂಸ್. ");
INSERT INTO vaa_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","ಭಾಂದಾನ ಬಾದ್ಮ ಅಪಟ್-ಜ಼ಪಟ್‌ನೊ ಪಾಣಿ ವರ್ಶೀನ್, ನದ್ದಿಯೆ ಭರೈನ್ ಆಯು, ಅಜು಼ ಚಾರ‍್ಹೆ ಆಡಿಥು ವ್ಹಾಯಿರೊ ವಾಗಿನ್ ಯೋ ಘರ್‌ನ ಮಾರ್ ಪಡ್ಯು. ಕತೋಬಿ ಯೋ ಘರ್ ಬಂಡಾಪರ್ ಭಂದೈರ‍್ಹೂಥೂತೆ ಇನಖ್ಹಾಜೆ, ಯೋ ರಡ್‍ಕ್ಯು ಕೊಯ್ನಿ. ");
INSERT INTO vaa_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","ಕತೋಬಿ ಆ ಮಾರಿ ವಾತೇನ ಖ್ಹಮ್‌ಜಿನ್‌ಬಿ, ಇನೀನಿಘೋಣಿ ಚಾ಼ಲಕೊಂತೆ ಹರೇಕ್ ಜ಼ಣು ರೇತಿಪರ್ ಘರ್ ಭಾಂದಿಲೇಸ್ತೆ ಬುಧ್ಧು ಅದ್ಮಿನಿಘೋಣಿ ಹುಯಿರ‍್ಹೂಸ್. ");
INSERT INTO vaa_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","ಭಾಂದಾನ ಬಾದ್‌ಮ, ಅಪಟ್‌ಝ಼ಪಟ್‌ನೊ ಪಾಣಿ ವರ್ಶೀನ್, ನದ್ದಿಯೆ ಭರೈನ್ ಆಯು, ಅಜು಼ ಚಾರ‍್ಹೆ ಆಡಿಥು ವಹಿರೊ ವಾಗಿನ್, ಯೋ ಘರ್‌ನ ಮಾರ್ ಪಡ್ಯು. ತದೆ ಯೋ ಘರ್ ಧಡಮ್‌ ಕರಿ ರಡ್ಕಿ ಗಯು. ");
INSERT INTO vaa_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","ಯೇಸುನೆ ಆ ಖ್ಹಾರಿ ವಾತೇನ ಬೋಲಿನ್ ಖತಮ್ ಕರಾನ ಬಾದ್ಮ, ಇನೆ ಬೋಲಿವತಾಳ್ಯೋತೆ ಇನಿ ಬಾರೇಮ ಅದ್ಮಿಖ್ಹಾರು ಘಣು ಆಶ್ಚರ್ಯಖಾದು. ");
INSERT INTO vaa_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","ಶನಕತೊ, ಯೇಸು ಮೋಶೆನಿ ವಚನ್‍ ಶಿಕಾಡವಾಳ ಶಾಸ್ತ್ರಿಯೇನಿಘೋಣಿ ಕಾಹೆತೆ ಅದಿಕಾರ್ ರ‍್ಹವಾಳಾನಿತರ ಬೋಲಿ ವತಾಳ್‌ತೋಥೊ. ");
INSERT INTO vaa_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","ಯೇಸು ಪಹಡ್ ಉತ್ರಿನ್ ಆವಾದಿನ್, ಅದ್ಮಿನು ಏಕ್‌ ಝೂ಼ಂಡ್‌ ಇನ ಪೀಠೆ ಗಯು. ");
INSERT INTO vaa_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","ತದೆ ಖೋಡ್‍ ಲಗ್ಯೋಹುಯೊ ಏಕ್‌ ಜ಼ಣೊ ಯೇಸುಕನ ಐನ್, ಇನ ಖ್ಹಾಮ್ಣೆ ಢುಕ್‌ಣ್ಯ ಟೇಕಿನ್, “ಪ್ರಭು, ತೂ ಮನ್ ಕರ‍್ಯೋತೊ, ಮನ ಶುದ್ದಿ ಕರೆಜಾ಼ಯ್” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","ಯೇಸುನೆ ಹಾತ್‌ ಖ್ಹಾಮ್ಣೆ ಕರೀನ್, ಇನ ಛೀಮಿನ್‌, “ಮನ ಮನ್ ಛಾ಼, ಶುದ್ದಿ ಹೂ” ಕರಿ ಬೋಲ್ಯೊ. ತದ್‌ನು-ತದ್ದೇಸ್ ಯೋ ಅದ್ಮಿನ ಖೋಡ್‍ ಅಛ್ಛು಼ ಹುಯಿಗಯು. ");
INSERT INTO vaa_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","ತದೆ ಯೇಸುನೆ ಇನ, “ಖ್ಹಮಜ಼್! ಕಿನಾಬಿ ನಕೊ ಬೋಲೀಶ್‌; ಕತೋಬಿ ಯಾಜಕಕನ ಜೈ಼ನ್ ತಾರು ಆಂಗ್‌ತನ್‌ ವತಾಳಿನ್ ಮೋಶೇನೆ ನೇಮ್‌ಶಾಯೋತೆ ಕಾಣ್ಕೆನ ದೇ; ಅನೇಥಿ ಅದ್ಮಿಖ್ಹಾರಾಮ ತುನ ಅಛ್ಛು಼ ಹುಯಿಗಯು ಕರಿ ಸಬೂತ್ ರ‍್ಹಿಶೆ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","ಯೇಸು ಕಪೆರ್ನೌಮ್‌ನ ಆವಾದಿನ್, ಖ್ಹೋಶಿಪಾಯಿನೊ ಮೋಟಾನೆ ಇನಾಕನ ಗಿಂಗೈನ್, ");
INSERT INTO vaa_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“ಪ್ರಭು, ಮಾರೊ ಸೇವಕ್ ಲಖ್‌ವೊ ಮಾರಿನ್, ಘರ್‌ಮ ಛಾ಼ದ್ರಿಪರ್‌ ಪಡ್ಯೋಸ್‌ ಅಜು಼ ಅಜಾ಼ಥಿ ಘಣು ತರಪ್‌ಡುಕರಾಸ್” ಕರಿ ಬೋಲಿಲಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","ಯೇಸುನೆ, “ಮೇ ಆಯಿನ್, ಇನ ಅಛ್ಛು಼ ಕರುಸ್” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","ತದೆ ಯೋ ಖ್ಹೋಶಿಪಾಯಿನೊ ಮೋಟಾನೆ, “ಪ್ರಭು, ತೂ ಮಾರ ಘರ್‌ಕನ ಆವಾಯೆತ್ರೆ ಮೇ ಲ್ಹಾಯೇಕ್‌ನೊ ಕಾಹೆ. ತೂ ಖಲಿ ಏಕ್‌ ವಾತೆ ಬೋಲ್ಯೋತೊ ಬಶ್‌, ಮಾರ ಸೇವಕ್‌ನ ಅಛ್ಛು಼ ಉಶೆ. ");
INSERT INTO vaa_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","ಮೇಬಿ ಬಿಜೇಕ್ ಅದಿಕಾರ್‌ನ ಹಾತ್‍ಹೇಟ್ ರ‍್ಹವಾಳೊ, ಮಾರ ಅದೀನ್‌ಮಾಬಿ ಸಿಪಾಯಿಖ್ಹಾರು ಛಾ಼. ಮೇ ಇವ್ಣಾಮ ಏಕ್‌ ಜ಼ಣಾನ ‘ಜಾ಼’ ಕರಿ ಬೋಲ್ಯೊತೊ ಜಾ಼ಸ್‌; ಬಿಜ್ಜೇಕ್‌ ಜ಼ಣಾನ, ‘ಆವ್’ ಕರಿ ಬೋಲ್ಯೋತೊ, ಆವಸ್; ಮಾರ ಆಳ್‌ನ, ‘ಅಮ್ನು-ಅಮ್ನು ಕರ್‌’ ಕರಿ ಬೋಲ್ಯೋತೊ, ಯೋ ಕರಸ್” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","ಯೇಸುನೆ ಅನಖ್ಹಮ್‌ಜಿನ್, ಆಶ್ಚರ್ಯಖೈನ್, ಇನ ಪೀಠೆ ವಳ್ಯಾವ್‌ತುಥೂತೆ ಇವ್ಣುನ, “ಮೇ ಅವ್ಡಿ ಮೋಟಿ ವಿಶ್ವಾಸ್‌ನ ಇಸ್ರಾಯೇಲ್‌ ಅದ್ಮಿಮಾಬಿ ಕೋ ದೇಖ್ಯೋನಿ ಕರಿ ತುಮೂನ ಖ್ಹಾಚಮಾಬಿ ಬೋಲುಸ್. ");
INSERT INTO vaa_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","ಅತ್ರೇಸ್ ಕಾಹೆತೆ, ಮೇ ತುಮೂನ ಬೋಲುಸ್ಕಿ, “ಪೂರಬ್ ಪಶ್ಚಿಮ್ ದಿಕ್ ಭಣೀಥು ಅದ್ಮಿ ಐನ್, ಸೊರ್ಗನು ರಾಜ್ಯಮ ಅಬ್ರಹಾಮ್‌, ಇಸಾಕ್ ಅಜು಼ ಯಾಕೋಬನ ಜೋ಼ಡೆ ಖಾಣನ ಬೇಖ್ಹ್‌ಶೆ; ");
INSERT INTO vaa_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","ಕತೋಬಿ ಕೋಣ್ ಆ ರಾಜ್ಯಮ ಮಳವಾಳೊಕಿ ಇವ್ಣೆ ಭಾರ್ ಅಂಧಾರಾಮ ಫೆಕೈಜಾ಼ಶೆ; ಹಿಜ್ಜಾ಼ ಇವ್ಣೆ ರೊವ್‌ಶೆ ಅಜು಼ ಕರ್‌-ಕರ್‌ ದಾತ್‌ ಚಾ಼ವಾನು ಉಶೆ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","ಅಜು಼ ಯೇಸುನೆ ಯೋ ಖ್ಹೋಶಿಪಾಯಿನೊ ಮೋಟಾನ, “ತೂ ವಿಶ್ವಾಸ್ ಕರ‍್ಯೊತೆ ಇಮ್ಮಸ್ ತುನ ಹುವಾದೆ, ಘರೆ ಜಾ಼” ಕರಿ ಬೋಲ್ಯೊ. ಯೋಸ್‌ ವಖ್ಹತ್‌ಮ ಇನ ಸೇವಕ್‌ನ ಅಛ್ಛು಼ ಹುಯಿಗಯು. ");
INSERT INTO vaa_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","ಅನಕೇಡೆಥು ಯೇಸು ಪೇತ್ರಾನ ಘರ್‌ಕನ ಆಯಿನ್, ಹಿಜ್ಜಾ಼ ಇನಿ ಖ್ಹಾಖ್ಹು ತಾವ್ ಐನ್, ಬಿಛಾ಼ವ್ಣಿಪರ್ ಖ್ಹುತಿಥೀತೆ ದೇಖ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","ಯೇಸುನೆ ಇನ ಹಾತ್ನ ಛೀಮ್ಯೊ; ಛೀಮ್‌ತಾಸ್ನ ತಾವ್ ಉತ್ರಿಗಯೊ, ಅಜು಼ ಯೋ ಉಠೀನ್ ಇನಿ ಚಾ಼ಕ್ರಿ ಕರಿ. ");
INSERT INTO vaa_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","ಖ್ಹಾಂಜ಼್ ಹುವ್ವಾದೀನ್, ಭೂತ್‌ ಧರಿರಾಖ್ಯುಥೂತೆ ಘಣ ಅದ್ಮಿನ ಯೇಸುಕನ ಬುಲೈಲಾಯು; ಯೇಸುನೆ ಖಲಿ ವಾತೆಥೀಸ್‌ ಭೂತ್‌ಖ್ಹಾರು ಕಾಡ್ಯೊ ಅಜು಼ ರೋಗ್‌ಮ ಥೂತೆ ಖ್ಹಾರಾನ ಅಛ್ಛು಼ ಕರ‍್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","ಅನೇಥಿ, “ಖ್ಹುದ್ ಇನೇಸ್‌ ಅಪ್ಣು ರೋಗ್‌-ರಾಯನ ಪಾಡಿಲಿದೊ, ಅಜು಼ ಅಪ್ಣ ಅಜಾ಼ನ ಢೊಯಿಲಿದೊ” ಕರಿ ಯೆಶಾಯ ಪ್ರವಾದಿಥಿ ಬೋಲೈತೆ ವಾತೆ ಚಾ಼ಲಾನಖ್ಹಾಜೆ ಯೇಸುನೆ ಆ ಖ್ಹಾರು ಕರ‍್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","ಯೇಸುನೆ ಇನ ಅಶ್‌ಪಿಶ್‌ಥೂತೆ ಅದ್ಮಿನಿ ಭೀಡ್‌ಣ ದೇಖಿನ್‌, ದರ‍್ಯಾವ್‍ನಿ ಪಾರ್ಲಿ ಬಾಜೂ಼ಮ ಜಾ಼ವ್ಣುಕರಿ ಇನ ಶಿಷ್ಯರ್‌ನ ಹುಕುಮ್‌ ದಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","ತದೆ ಮೋಶೆನಿ ವಚನ್ ಶಿಕಾಡವಾಳೊ ಏಕ್‌ ಜ಼ಣೊ ಐನ್, ಯೇಸುನ, “ಗುರು, ತೂ ಕಿಜ್ಗಾ಼ ಗಯೊತೋಬಿ ಮೇ ತಾರ ಪೀಠೇಸ್‌ ಆವ್‍ಸ್‌” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","ಯೇಸುನೆ ಇನ, “ನ್ಹೋರಿಯೆನ ಘವಿಯೆ ಛಾ಼, ಅಜು಼ ಆಬ್‌ಪರ್ ಉಡಾತೆ ಜಿನಾವರ್‌ನ ಖ್ಹಾರು ಮ್ಹಾಳೊ ಛಾ಼, ಕತೋಬಿ ಅದ್ಮಿನ ಛಿಯ್ಯಾನ ಮುಡ್‌ಕ್ಯು ಟೇಕಯೆವ್ಡಿ ಝ಼ಗೋಬಿ ಕೊಯ್ನಿ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","ಶಿಷ್ಯರ್‌ಮ ಬಿಜೇಕ್‌ನೆ, “ಪ್ರಭು, ಮೇ ಪಹಿಲೆ ಜೈ಼ನ್‌ ಮಾರ ಬಾನ ಧಪ್‌ನೈದೀನ್‌ ಆವಾನ ಮನ ಹುಕುಮ್ ದೆ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","ಯೇಸುನೆ ಇನ, “ಮಾರ ಪೀಠೆ ಆವ್, ಮರ‍್ಯಹುಯಾಸ್‌ ಇವ್ಣಮ ಮರಿಗಯೂತೆ ಇನ ಮಾಟಿ ಕರಾದೆ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","ಯೇಸು ಡೋಣ್‌ಪರ್‌ ಚ಼ಢ್ಯೊ, ಅಜು಼ ಇನ ಶಿಷ್ಯರ್‌ಬಿ ಇನಜೋ಼ಡೆ ಗಯ. ");
INSERT INTO vaa_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","ಎಕ್ಕಸ್‌ದಮ್‌, ಮೋಟೊ ವಹಿರೊ ದರ‍್ಯಾವ್‌ಮ ಹುವಾಲಗ್ಯೊ, ಅಜು಼ ಝೋ಼ಕಾಳ್ಯೊ ಆಯಿನ್ ಡೋಣ್ಣಾ ಢಾಪಿನಾಖನಿತರ ಹುಯು. ಕತೋಬಿ ಯೇಸು ಖ್ಹುತೋಥೊ. ");
INSERT INTO vaa_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","ಶಿಷ್ಯರ್‌ ಯೇಸುಕನ ಜೈ಼ನ್‌, ಇನ ಉಠಾಡಿನ್, “ಪ್ರಭು, ಹಮೂನ ಬಚಾ಼ಡ್‍! ಹಮೆ ಮರ‍್ವಾನ ಆಯಾನಿ!” ಕರಿ ಬೋಲ್ಯ. ");
INSERT INTO vaa_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","ಯೇಸುನೆ, “ತುಮೆ ಶನ ಡರೋಸ್ತೆ? ತುಮೂನ ಕಮ್‍ವಿಶ್ವಾಸ್ ಛಾ಼!” ಕರಿ ಬೋಲಿನ್, ಉಠೀನ್‌ ವಹಿರನಾಬಿ, ದರ‍್ಯಾವ್ನ ಗುರ್‌ಕಾಯೊ, ತದೆ ಖ್ಹಾರೂಸ್ ಖ್ಹೊಪೊ ಪಡಿಗಯು. ");
INSERT INTO vaa_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","ಹರೇಕ್ ಜ಼ಣು ಅಶ್ಚರ್ಯ ಖೈನ್, “ಆ ಕಿಮ್ನೊ ಉಶೆ? ವಹಿರೋಬಿ, ದರ‍್ಯಾವ್‌ಬಿ ಜಿನು ಆ ಬೋಲಾತೆ ಇಮ್‌ ಖ್ಹಮ್‌ಜಾ಼ಸ್‌ನಿ?” ಕರಿ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","ಅನಬಾದ್‍ಮ ಯೇಸು ದರ‍್ಯಾವ್‍ನಿ ಪಾರ್ಲಿ ಬಾಜೂ಼ಮ ಥೂತೆ ಗದರೇನ್‌ ಕರಿ ತಬರ್‌ಖಾನ ಆವಾದಿನ್, ಭೂತ್‌ ಧರಿರಾಖ್ಯುಥೂತೆ ಬೇ ಜ಼ಣು ಮಖ್ಹಾಣ್ಯನಿ ಘವಿಮಾಥೊ ನಿಕ್ಳಿನ್‌, ಇನಖ್ಹಾಮ್ಣೆ ಆಯು. ಇವ್ಣೆ ಘಣು ಚ಼ಂಢಾಳಿ ಹುಯಿರ‍್ಹುಥೂತೆ ಇನಖ್ಹಾಜೆ ಯೋ ವಾಟೆ ಕೋಣ್‌ಬಿ ಕೋ ಫರ್ತುಥೂನಿ. ");
INSERT INTO vaa_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","ತದೇಸ್‌ ಇವ್ಣೆ, “ದೇವ್ನ ಛಿಯ್ಯಾ, ಹಮಾರೇಥಿ ತುನ ಶಾತ್‌ ಛಾ಼? ವಖ್ಹತ್ ಆವಾನ ಆಗಾಡಿಸ್‌ ಹಮೂನ ನಿಶತ್ ದ್ಯಾವಾನ ಐರ‍್ಹೋಸ್ಕಿ ಶು?” ಕರಿ ಚಿಕ್ರಿನ್ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","ದರ್ರಾಶಿ ದೂರ್ ಪಾರಸ್ ಡೂಕರ್‌ನಿ ಏಕ್‌ ಮೋಟಿ ಝೂ಼ಂಡ್‌ ಚ಼ರೂಕರ್‌ತೂಥು. ");
INSERT INTO vaa_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","ಯೋ ಭೂತ್‌ಖ್ಹಾರು, “ತೂ ಹಮೂನ ಅವ್ಣ ಮಹಿಥು ನಖ್ಹಾಡ್‌ತೊ ಉಶೇತೊ, ಯೋ ಡೂಕರ್‌ನಿ ಝೂ಼ಂಡ್‌ನ ಮಹಿ ಮೋಕಲ್” ಕರಿ ಗಿಂಗೈಲಿದು. ");
INSERT INTO vaa_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","ಯೇಸುನೆ ಇವ್ಣುನ, “ಜಾ಼ವೊ” ಕರಿ ಬೋಲ್ಯೊ. ತದೆ ಯೋ ಭೂತ್‌ಖ್ಹಾರು ಇವ್ಣ ಭೇ ಜ಼ಣಾನ ಮ್ಹೆಂದಿನ್, ಡೂಕರ್‌ನ ಮಹಿ ಪೆಶಿಗಯು. ತದ್‌ನು-ತದ್ದೇಸ್ ಡೂಕರ್‌ಖ್ಹಾರು ನಾಶಿನ್, ಪಹಡ್‌ನಿ ಕಥಾರ್‌ಪರ್‌ಥು ದರ‍್ಯಾವ್‌ಮ ಪಡೀನ್, ಡುಬಿನ್ ಮರಿಗಯು. ");
INSERT INTO vaa_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","ತದೆ ಡೂಕರ್‌ ಚ಼ರಾವವಾಳು ಇವ್ಣೆ ಗಾಮ್‌ನ ಮಹಿ ನಾಶಿ ಜೈ಼ನ್‌, ಭೂತ್‌ ಧರಿರಾಖ್ಯುಥೂತೆ ಇವ್ಣುನ ಚಾ಼ಲ್ಯುತೆ ಖ್ಹಾರಿಸ್ ಬಾರೇಮ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","ತದೆ ಯೋ ತಬರ್‌ಖಾನು ಖ್ಹಾರುಸ್‌ ಅದ್ಮಿ ಯೇಸುನ ಮಳಾನಖ್ಹಾಜೆ ಆಯು; ಅಜು಼ ಇವ್ಣ ತಬರ್‌ಖಾನ ಮ್ಹೆಂದಿನ್ ಜಾ಼ ಕರಿ ಇನ ಗಿಂಗೈಲಿದು. ");
INSERT INTO vaa_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","ಯೇಸುನೆ ಡೋಣ್‌ ಚ಼ಢೀನ್, ದರ‍್ಯಾವ್‍ನಿ ಪಾರ್ಲಿ ಬಾಜೂ಼ಮ ಥೂತೆ ಇನ ಗಾಮ್‌ನ ಪಾಛೊ಼ ಗಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","ಹಿಜ್ಜಾ಼ ಥೋಡ ಜ಼ಣಾನೆ ಬಿಛಾ಼ವ್ಣಿಪರ್ ಪಡ್ಯುಥೂತೆ ಏಕ್‌ಜ಼ಣೊ ಲಕ್‍ವೊ ಮಾರ‍್ಯುಹುಯಾನ, ಯೇಸುಕನ ಪಳ್ಳಿನ್‌ ಆಯು. ಇನೆ ಇವ್ಣಿ ವಿಶ್ವಾಸ್‌ನ ದೇಖಿನ್‌, ಯೋ ಲಕ್‍ವೊ ಮಾರ‍್ಯಹುಯಾನ, “ಮಾರ ಛಿಯ್ಯಾ, ಹಿಮ್ಮತ್‌ ರಾಕ್! ತಾರು ಪಾಪ್‌ಖ್ಹಾರು ಮಾಪ್‌ ಹುಯಿಗಯು” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","ಹಿಜ್ಜಾ಼ ಥೂತೆ ಮೋಶೇನು ವಚನ್‍ ಶಿಕಾಡವಾಳು ಶಾಸ್ತ್ರೀಮ ಥೋಡಜ಼ಣಾನೆ, “ಆ ಅದ್ಮಿ ದೇವ್ನಿ ವಿರೋದ್ ಬೋಲಾಸ್ನಿ!” ಕರಿ ಇವ್ಣ-ಇವ್ಣ ಮಹಿ ಬೋಲಿಲಿದು. ");
INSERT INTO vaa_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","ಇವ್ಣೆ ಇಮ್‌ ಸೋಚುಕರಾತೆ ಯೇಸುನೆ ಮಾಲುಮ್‌ ಕರೀಲಿನ್‌, ಇವ್ಣುನ, “ಶನ ತುಮೆ ತುಮಾರ ಮನ್‌ಮ ಅಮ್ ಖರಾಬ್ ಸೋಚೋ಼ಸ್ತೆ? ");
INSERT INTO vaa_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","ಕೆಹು ಶುಲ್ಬ? ‘ತಾರು ಪಾಪ್‌ಖ್ಹಾರು ಮಾಪ್‌ ಹುಯಿಗಯು’ ಕರಿ ಬೋಲಾನುಕಿ, ‘ಉಠೀನ್, ಚಾ಼ಲ್’ ಕರಿ ಬೋಲಾನು? ");
INSERT INTO vaa_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","ಕತೋಬಿ ಅದ್ಮಿನೊ ಛಿಯ್ಯಾನ ಪಾಪ್‌ಖ್ಹಾರು ಮಾಪ್‌ ಕರಾನ ಧರ್ತಿಪರ್ ಹಕ್‌ ಛಾ಼ ಕರಿ ಮೇ ತುಮೂನ ವತಾಳುಸ್‌” ಕರಿ ಬೋಲಿನ್,ಯೋ ಲಕ್‌ವೊ ಮಾರಿರಾಖವಾಳನ, “ಉಪ್ಪರ್ ಉಟ್, ತಾರಿ ಬಿಛಾ಼ವ್ಣಿನ ಪಳ್ಳಿನ್‌, ಘರೆ ಜಾ಼!” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","ತದೆ ಯೋ ಅದ್ಮಿ ಉಪ್ಪರ್ ಉಠೀನ್, ಘರೆ ಗಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","ಅದ್ಮಿಖ್ಹಾರು ಅನದೇಖಿನ್‌, ಡರಿನ್‌, ದೇವ್ನೆ ಅದ್ಮಿನ ಅಮ್ನಿ ಅದಿಕಾರ್ ದಿದೋತೆ ಇನಖ್ಹಾಜೆ ದೇವ್ನ ಖ್ಹರಾಯು. ");
INSERT INTO vaa_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","ಯೇಸು ಹಿಜ್ಜಾ಼ಥೊ ಜಾ಼ತೊರ‍್ಹವಾನಿ ವಖ್ಹತ್‌ಮ, ಶುಂಕ ಮಾಂಗವಾಳೊ ಮತ್ತಾಯ ಕರಿ ಏಕ್‌ ಜ಼ಣೊ, ಶುಂಕ ಮಾಂಗಾನಿ ಝ಼ಗೋಪರ್ ಬೆಠೊಥೋತೆ ದೇಖಿನ್, ಯೇಸು ಇನ, “ಮಾರ ಪೀಠೆ ಆವ್” ಕರಿ ಬೋಲ್ಯೊ. ತದೆ ಮತ್ತಾಯ ಉಠೀನ್, ಇನ ಪೀಠೆ ಗಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","ಅನಕೇಡೆಥು, ಯೇಸು ಇನ ಘರ್‌ಮ ಖಾಣನ ಬೆಠೋರ‍್ಹವಾನಿ ವಖ್ಹತ್‌ಮ, ಘಣು ಅದ್ಮಿ ಶುಂಕ ಮಾಂಗವಾಳು ಅಜು಼ ಪಾಪಿಖ್ಹಾರು ಐನ್, ಯೇಸು ಅಜು಼ ಇನ ಶಿಷ್ಯರ್‌ನ ಜೋ಼ಡೆ ಖಾಣನ ಬೇಶಿಗಯು. ");
INSERT INTO vaa_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","ಫರಿಸಾಯರ್‌ನೆ ಅನದೇಖಿನ್‌, ಯೇಸುನ ಶಿಷ್ಯರ್‌ನ, “ತುಮಾರೊ ಗುರು ಶುಂಕ ಮಾಂಗವಾಳನ ಅಜು಼ ಪಾಪಿ ಖ್ಹಾರಾನ ಜೋ಼ಡೆ ಶನ ಖಾಣುಖಾಸ್ತೆ?” ಕರಿ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","ಅನ ಖ್ಹಮ್‌ಜಿನ್ ಯೇಸುನೆ, ಇವ್ಣುನ, “ಅಛ್ಛು಼ರ‍್ಹಾವಾಳಾನ ವೈದ್ಯ ಹೋಣುಕೊಯ್ನಿ, ರೋಗ್‌ಮ ರ‍್ಹಾವಾಳನ ವೈದ್ಯಹೋಣು. ");
INSERT INTO vaa_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","ತುಮೆ ಜೈ಼ನ್‌, ‘ಮನ ಜಾನ್ವರ್‌ನು ಬಲಿ ನಕೊ, ಗೋರಸ್‌ ಹೋಣುತೆ’ ಕರಿ ಧರ್ಮಶಾಸ್ತ್ರಮ ಲೀಖೈರ‍್ಹೂಸ್ತೆ ವಚನ್ನಿ ಮತ್‌ಲಬ್ ಶಿಕಿಲೇವೊ. ಮೇ ಆಯೋತೆ ನೀತಿವಾಳ ಅದ್ಮಿಯೇನ ಬುಲಾವನ ಕಾಹೆ, ಕತೋಬಿ ಪಾಪಿ ಖ್ಹಾರಾನ ಬುಲಾವಾನಖ್ಹಾಜೆ ಆಯೋತೆ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","ಅನಬಾದ್‍ಮ, ಬ್ಯಾಪ್ತಿಸ್ಮ ದ್ಯವಾಳೊ ಯೋಹಾನನು ಶಿಷ್ಯರ್‌ ಯೇಸುಕನ ಆಯಿನ್, “ಹಮೇಬಿ, ಫರಿಸಾಯರ್‌ಬಿ ತದೆ-ತದೆ ಉಪವಾಸ್ ಕರಿಯೇಸ್, ಕತೋಬಿ ತಾರು ಶಿಷ್ಯರ್‌ ಶನ ಉಪವಾಸ್ ಕೋ ಕರಾನಿ?” ಕರಿ ಪುಛಾ಼ಯು. ");
INSERT INTO vaa_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","ಯೇಸುನೆ ಇವ್ಣುನ, “ವ್ಯಹಾನ ಛ಼ತ್‍ಮ ಆಯೂತೆ ಅದ್ಮಿ ಇವ್ಣ ಜೋ಼ಡೆ ನೌಶೊ ರ‍್ಹವಾತೋಡಿ ಇವ್ಣುನ ದುಖ್ ರ‍್ಹಿಶೇಕಿ ಶು? ಕೊಯ್ನಿ! ಕತೋಬಿ ನೌಶೊ ಇವ್ಣಾಕಂಥು ಮ್ಹೆಂದಿನ್ ಜಾ಼ವಾನಿ ವಖ್ಹತ್ ಆವ್‌ಶೆ, ತದೆ ಇವ್ಣೆ ದುಖ್ ಕರ್ಶೆ ಅಜು಼ ಉಪವಾಸ್ ಕರ್ಶೆ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“ಅಜು಼ ಕೋಣ್‌ಬಿ ನವು ಲುಂಗ್ಡಾನು ಥಿಗ್‌ಳು ಜೂ಼ನ ಲುಂಗ್ಡಾನ ಕೇಡೆಲಗಾಡಿನ್‌ ಶಿವಾಕೊಯ್ನಿ. ಇಮ್‌ ಕರ‍್ಯುತೊ, ಯೋ ನವು ಲುಂಗ್ಡಾನು ಥಿಗ್‌ಳು ಖೇಚಾ಼ವಸ್ತೆ ಇನಖ್ಹಾಜೆ, ಯೋ ಜೂ಼ನು ಲುಂಗ್ಡು ಬಿಜೂ಼ಬಿ ಜಾ಼ಖ್ಹತ್ ಫಾಟಿಜಾ಼ಸ್‌. ");
INSERT INTO vaa_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","ಅತ್ರೇಸ್ ಕಾಹೆತೆ, ಜೂ಼ನಿ ಚಾ಼ಂಬ್ಡಾನಿ ತಿತ್ತಿಯೇಮ ನವು ದ್ರಾಕ್ಷಿನುರಖ್ಹ್‌ ಭರಿನ್‌ ಕೋ ಮ್ಹೇಲಾನಿ, ಇಮ್‌ ಮ್ಹೇಲ್ಯುತೊ ಚಾ಼ಂಬ್ಡಾನಿ ತಿತ್ತಿಯೆ ಫುಟಿನ್‌, ದ್ರಾಕ್ಷಿನು ರಖ್ಹ್‌ ಭಾರ್ ರಂಚೈ಼ಜಾ಼ಸ್‌, ಅಜು಼ ತಿತ್ತಿಯೇಬಿ ಬರ್ಬಾತ್ ಹುಯಿಜಾ಼ಸ್. ಇನಖ್ಹಾಜೇಸ್ ನವು ದ್ರಾಕ್ಷಿನು ರಖ್ಹ್‌ನ ನವಿ ತಿತ್ತಿಯೇಮ ಭರಿನ್‌ ಮ್ಹೇಲಾಸ್, ತದೆ ಭೇಬಿ ಬಚಿಜಾ಼ಸ್‌” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","ಯೇಸು ಇವ್ಣಿ ಜೋ಼ಡೆ ಆ ವಾತೆ ಬೋಲುಕರಾನಿ ವಖ್ಹತ್‌ಮ, ಯೆಹೂದ್ಯರ್‌ನೊ ಏಕ್‌ ಅದಿಕಾರಿ ಇನಾಕನ ಆಯಿನ್, ಇನಖ್ಹಾಮ್ಣೆ ಢುಕ್‌ಣ್ಯಟೇಕಿನ್, “ಮಾರಿ ಛೋ಼ರಿ ಹಂಕೇಸ್‌ ಮರಿಗೈ; ತೋಬಿ ತೂ ಐನ್ ಇನಾಪರ್‌ ಹಾತ್‌ ಮ್ಹೇಲ್ಯೋತೊ ಯೋ ಜಿವ್‌ತಿ ಉಶೆ” ಕರಿ ಗಿಂಗೈಲಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","ತದೆ ಯೇಸು ಉಠೀನ್, ಇನ ಕೇಡೆ ಗಯೊ, ಅಜು಼ ಇನ ಶಿಷ್ಯರ್‌ ಇನ ಪೀಠೆ ಗಯ. ");
INSERT INTO vaa_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","ಭಾರ ವರಖ್ಹ್‌ಥು ಮುಟ್ನು ರೋಗ್‌ಥೀತೆ ಏಕ್‌ ತಯೇಡ ಥಿ ಯೋ ಯೇಸುನ ಪೀಠೇಥಿ ಆಯಿನ್, ಇನ ಝ಼ಗ್ಗಾನು ಕನಾರಿನ ಛೀಮಿ. ");
INSERT INTO vaa_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","ಯೋ ತಯೇಡ, “ಮೇ ಇನ ಲುಂಗ್ಡಾನ ಛೀಮೀತೊ ಬಶ್‌, ಮನ ಅಛ್ಛು಼ ಹುಯಿಜಾ಼ಶೆ” ಕರಿ ಇನು ಯೋಸ್ ಬೋಲಿಲಿದಿ. ");
INSERT INTO vaa_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","ತದೆ ಯೇಸುನೆ ಫರೀನ್, ಇನಾಭಣಿ ದೇಖಿನ್‌, “ಛೋ಼ರಿ ಧಿಲ್‌ಪತ್‌ಥಿ ರ‍್ಹೇ! ತಾರಿ ವಿಶ್ವಾಸ್‌ಥೀಸ್‌ ತುನ ಅಛ಼್ಛುಹುಯು” ಕರಿ ಬೋಲ್ಯೊ. ಯೋಸ್‌ ವಖ್ಹತ್‌ಮ ಯೋ ತಯೇಡಾನ ಗುಣ್‌ಹುಯು. ");
INSERT INTO vaa_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","ಅನಕೇಡೆಥು ಯೇಸು ಯೋ ಅದಿಕಾರಿನ ಘರೆ ಆಯೊತದೆ, ಹಿಜ್ಜಾ಼ ವಾಖ್ಹ್‌ಳಿ ವಜಾ಼ಡವಾಳನ ಅಜು಼ ಗಲಾಟ್ ಕರುಕರ್ತುಥೂತೆ ಅದ್ಮಿಖ್ಹಾರಾನ ದೇಖಿನ್‌, ");
INSERT INTO vaa_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","“ಭಾರ್‌ ಜಾ಼ವೊ, ಛೋ಼ಕ್ರಿ ಮರಿಕೊಯ್ನಿ, ಖ್ಹುತೀಸ್!” ಕರಿ ಬೋಲ್ತಾನ, ಇವ್ಣೆ ಖ್ಹಾರು ಯೇಸುನ ದೇಖಿನ್ ನಕ್ಲೆಕಾಡಿ ಹಾಶ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","ಅದ್ಮಿಖ್ಹಾರಾನ ಭಾರ್‌ ಮೋಕ್ಲಾನ ಬಾದ್ಮ, ಯೇಸು ಮಹಿ ಜೈ಼ನ್‌, ಯೋ ಛೋ಼ಕ್ರಿನೊ ಹಾತ್‌ ಧರ್‌ತಾನ, ಯೋ ಉಠಿ ಭೀರಿಗೈ. ");
INSERT INTO vaa_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","ಆ ಖಬರ್ ಯೋ ದೇಖ್ಹ್‌ ಅಖ್ಖುಸ್ ಫೈಲಿಗಯು. ");
INSERT INTO vaa_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","ಯೇಸು ಹಿಜ್ಜಾ಼ಥೊ ಜಾ಼ವಾನಿ ವಖ್ಹತ್‌ಮ, ಬೇ ಜ಼ಣು ಕಾಣು, “ದಾವೀದ್‌ನ ಛಿಯ್ಯಾ, ಹಮಾರಪರ್‌ ಗೋರ್‌ ಕರ್‌!” ಕರಿ ಜೋ಼ರೇಖ್ಹು ಚಿಕರ್ತು ಹುಯಿನ್, ಇನ ಪೀಠೆ ಗಯ. ");
INSERT INTO vaa_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","ಯೇಸು ಘರ್‌ನ ಮಹಿ ಜಾ಼ವಾದಿನ್, ಯೋ ಭೇ ಕಾಣು ಇನಾಕನ ಆಯು, ಇನೆ ಇವ್ಣುನ, “ಮೇ ತುಮೂನ ಅಛ್ಛು಼ ಕರೆಜಾ಼ಯ್ ಕರಿ ತುಮೆ ನಂಬೋಸ್ಕಿ ಶು?” ಕರಿ ಪುಛಾ಼ಯೊ. ಇವ್ಣೆ, “ಓಹೋಲಾ, ಪ್ರಭು!” ಕರಿ ಜವಾಬ್‌ ದಿದು. ");
INSERT INTO vaa_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","ತದೆ ಯೇಸುನೆ ಇವ್ಣ ಡೋಳಾ ಛೀಮಿನ್‌, “ತುಮೆ ವಿಶ್ವಾಸ್ ಕರ‍್ಯಾತೆ ಇಮ್ಮಸ್, ತುಮೂನ ಹುವಾದೆ!” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","ತದೆ ಇವ್ಣ ಡೋಳಾ ದೆಖಾವಲಗ್ಯ. ಅಜು಼ ಯೇಸುನೆ ಇವ್ಣುನ, “ಆ ಬಾರೇಮ ಕಿನಾಬಿ ನಾ ಬೋಲ್‌ನು!” ಕರಿ ಇವ್ಣುನ ಝೇತಾಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","ಕತೋಬಿ ಇವ್ಣೆ ಹಿಜ್ಜಾ಼ಥು ಚ಼ಲ್ಯೂಜೈ಼ನ್, ಯೇಸುನಿ ಬಾರೇನಿ ಖಬರ್‌ನ ಯೋ ದೇಖ್ಹ್‌ ಅಖ್ಖು ಫೈಲೈದಿದು. ");
INSERT INTO vaa_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","ಇವ್ಣೆ ಭೇ ಜ಼ಣು ಹಿಜ್ಜಾ಼ಥು ಜಾ಼ವಾನಿ ವಖ್ಹತ್‌ಮ, ಥೋಡು ಅದ್ಮಿನೆ ಭೂತ್‌ ಧರಿರಾಖ್ಯುಥೂತೆ ಏಕ್‌ ಮುಕ್ಕಾನ ಯೇಸುಕನ ಲಾಯು. ");
INSERT INTO vaa_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","ಯೇಸುನೆ ಯೋ ಭೂತ್‌ನ ನಖ್ಹಾಡಾನ ಬಾದ್ಮ, ಯೋ ಮುಕ್ಕೊ ವಾತೆ ಬೋಲಾಲಗ್ಯೊ. ತದೆ ಯೋ ಅದ್ಮಿಖ್ಹಾರು, “ಇಸ್ರಾಯೇಲ್‌ಮ ಅಮ್ನು ಕಾಮ್ನ ಹಮೆ ಕದೇಸ್‌ ಕೋ ದೇಖಿರಾಖ್ಯಾನಿ!” ಕರಿ ಆಶ್ಚರ್ಯಖಾದು. ");
INSERT INTO vaa_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","ಕತೋಬಿ ಫರಿಸಾಯರ್‌ನೆ, “ಭೂತ್‌ ಖ್ಹಾರಾನೊ ಯಜಮಾನ್ನಿ ಮದತ್‌ಥೀಸ್ ಯೇಸು ಭೂತ್‌ನ ಖ್ಹಾರು ಕಾಡಸ್ತೆ” ಕರಿ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","ಯೇಸು ಖ್ಹಾರ ಖ್ಹಯೇರ್‌ಮ ಅಜು಼ ಗಾಮ್ಮ ಕರಿ ಫರ್ತೊಹುಯಿನ್, ಇವ್ಣಿ ಸಬೆ ಭರಾವಾನು ಮಂದಿರ್‌ಮ ಬೋಲಿದೇತೊಹುಯಿನ್‌, ರಾಜ್ಯನಿ ಅಛ್ಛಿ ಖಬರ್‌ನ ಬೋಲ್ತೊಹುಯಿನ್, ಖ್ಹಾರಿಸ್ ತರ‍್ಹಾನು ರೋಗ್‌-ರಾಯನ ಅಛ್ಛು಼ ಕರ್ತೊ ಆಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","ಕತೋಬಿ ಅದ್ಮಿನಿ ಭೀಡ್ ದೇಖಿನ್‌, ಇವ್ಣೆ ಖ್ಹಾರು ಕುರುಬಕೊಂತೆ ಮ್ಹೇಂಢವ್‌ನಿ ಘೊಣಿ ಖ್ಹತಿರ‍್ಹೂತೆ ಅಜು಼ ಮದತ್‌ಕೊಂತೆ ಇಮ್‌ ಛಾ಼ ಕರಿ ಬೋಲಿನ್, ಇವ್ಣಾಪರ್ ಗೋರ್‌ ಖಾದೊ. ");
INSERT INTO vaa_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","ತದೆ ಯೇಸುನೆ ಇನ ಶಿಷ್ಯರ್‌ನ, “ಅನಾಜ಼್ ಜಾ಼ಖ್ಹತ್ ಛಾ಼, ಕತೋಬಿ ಕಾಮ್ ಕರಾವಾಳು ಕಮ್; ");
INSERT INTO vaa_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","ಇನಖ್ಹಾಜೇಸ್ ಅನಾಜ಼್ ಪಿಕಾವಳೊ ಯಜಮಾನ್ನ, ತಾರು ಅನಾಜ಼್‌ನ ಎಕ್ಟು ಕರಾನಖ್ಹಾಜೆ ಕಾಮ್‌ವಾಳಾನ ಮೋಕಲ್ ಕರಿ ಬಿಂತಿ ಕರೊ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","ಯೇಸುನೆ ಇನ ಭಾರ ಜ಼ಣ ಶಿಷ್ಯರ್‌ನ ಎಕ್ಕದಮ್‌ ಬುಲೈನ್, ಭೂತ್‌ಖ್ಹಾರು ಕಾಡಾನ ಅಜು಼ ಖ್ಹಾರಿಸ್ ತರ‍್ಹಾನು ರೋಗ್‌-ರಾಯನ ಅಛ್ಛು಼ ಕರಾನ ಇವ್ಣುನ ಅದಿಕಾರ್ ದಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","ಯೋ ಭಾರಜ಼ಣ ಅಪೊಸ್ತಲರ‍್ನು ನಾಮ್ ಕೆಹುಕತೊ: ಪಹಿಲೊ ಪೇತ್ರ ಕರಿ ಬೋಲೈಲಿದೋತೆ ಸೀಮೋನ, ಇನೊ ಭೈ ಅಂದ್ರೆಯ, ಜೆಬೆದಾಯನೊ ಛಿಯ್ಯೊ ಯಾಕೋಬ ಅಜು಼ ಇನೊ ಭೈ ಯೋಹಾನ. ");
INSERT INTO vaa_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","ಫಿಲಿಪ್ಪ ಅಜು಼ ಬಾರ್ತೊಲೊಮಾಯ, ತೋಮ, ಶುಂಕವಾಳೊ ಮತ್ತಾಯ, ಅಲ್ಫಾಯನೊ ಛಿಯ್ಯೊ ಯಾಕೋಬ, ತದ್ದಾಯ, ");
INSERT INTO vaa_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","ದೇಖ್ಹ್‌ನೊ ಭಕ್ತ ಕರಿ ಬೋಲೈಲಿದೋತೆ ಸೀಮೋನ, ಯೇಸುನ ಧೊಕೇಥಿ ಧರಿದಿದೋತೆ ಇಸ್ಕರಿಯೋತ ಯೂದ, ಅವ್ಣೇಸ್. ");
INSERT INTO vaa_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","ಆ ಭಾರ ಜ಼ಣಾನ ಯೇಸು ಮೋಕ್ಲಾನಿ ವಖ್ಹತ್‌ಮ, ಇವ್ಣುನ ಶಾತ್‌ ಬೋಲಿನ್ ಮೋಕ್‌ಲ್ಯೊ ಕತೊ, “ಯೆಹೂದ್ಯರ್‌ಕಾಹೆತೆ ಅದ್ಮಿನ ಗಾಮ್‌ಭಣಿ ರ‍್ಹವೊ, ಸಮಾರಿಯಾನು ಖೆವುಸ್‌ ಗಾಮ್ಮ ರ‍್ಹವೊ ನಕೊಜಾ಼ಶು. ");
INSERT INTO vaa_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","ಅನಬದಲ್ ಗುಮೈಗಯೂತೆ ಮೇಂಢನಿಘೋಣಿ ಛಾ಼ತೆ ಇಸ್ರಾಯೇಲ್‌ನ ಅದ್ಮಿಕನ ಜಾ಼ವೊ. ");
INSERT INTO vaa_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","ಜೈ಼ನ್‌, ‘ಸೊರ್ಗನು ರಾಜ್ಯ ಖನ್ನೆ ಐಗು’ ಕರಿ ಬೋಲಿವತಾಳೊ. ");
INSERT INTO vaa_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","ರೋಗ್‌ವಾಳಾನ ಅಛ್ಛು಼ಕರೊ, ಮರ‍್ಯಾಹುಯಾನ ಜಿವ್ತು ಕರೊ, ಖೋಡ್‍ ಲಗ್ಯಹುಯಾನ ಪಾಕ್‌ಕರೊ ಅಜು಼ ಭೂತ್‌ಖ್ಹಾರು ಕಾಡೊ. ತುಮೂನ ಫುಗಟ್‌ಮ ಮಳಿರ‍್ಹೂಸ್‌ ಇನಖ್ಹಾಜೆ ಫುಗಟ್‌ಮ ದೆವೊ. ");
INSERT INTO vaa_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","ತುಮಾರಿ ಚ಼ಂಚಿಮ ಖ್ಹೊನ್ನು, ರೂಪು ನಾತೊ ತಾಂಬಾನು ಪೈಶಾ ರ‍್ಹವೊ, ನಕೊ ಲೀಜಾ಼ವೊ; ");
INSERT INTO vaa_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","ಜಾ಼ವಾನಿ ವಖ್ಹತ್‌ಮ, ಝೋ಼ಳಿ ರ‍್ಹವೊ, ಬೇ ಕುಡ್‌ತಾ ರ‍್ಹವೊ, ಖೋಖ್ಹ್‌ಡು ರ‍್ಹವೊ, ಲಠ್ಠೊ ರ‍್ಹವೊ ನಕೊ ಲೀಜಾ಼ಶು. ಕಾಮ್ ಕರಾವಾಳ ಆಳ್‌ನ ಶಾತ್‌ ಜ಼ರೂರತ್ ಛಾ಼ಕಿ ಯೋ ಇನ ದೆವಾವ್‌ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","ತುಮೆ ಖೆವತೋಬಿ ಖ್ಹಯೇರ್‌ಮ ನತರ್‌ಕಿ ಗಾಮ್ಮ ಗಯಾತೊ, ಹಿಜ್ಜಾ಼ ಕೋಣ್ ಅಛ್ಛು಼ಕರಿ ಪುಛೈ಼ಲೀನ್‌, ಯೋ ಗಾಮ್‌ನ ಮ್ಹೆಂದಿನ್ ಜಾ಼ವಾತೋಡಿ ಯೋಸ್ ಝ಼ಗೋಮ ರ‍್ಹವೊ. ");
INSERT INTO vaa_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","ತುಮೆ ಏಕ್‌ ಘರ್‌ಮ ಜಾ಼ವಾನಿ ವಖ್ಹತ್‌ಮ, ‘ತುಮೂನ ಸಮಾಧಾನ್ ಮಳಾದೆ’ ಕರಿ ಬೋಲೊ. ");
INSERT INTO vaa_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","ಯೋ ಘರ್‌ಮಾನು ಅದ್ಮಿ ತುಮೂನ ಬುಲೈಲಿದುತೊ, ತುಮಾರಿ ಸಮಾಧಾನ್ ಇವ್ಣುನ ಮಳಾದೆ. ಕತೋಬಿ ಇವ್ಣೆ ತುಮೂನ ನಾ ಬುಲೈಲಿದುತೊ, ತುಮಾರಿ ಸಮಾಧಾನ್ ಪಾಛು಼ಫರಿ ತುಮುನಾಸ್ ಆವಾದೆ. ");
INSERT INTO vaa_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","ಖೆವತೋಬಿ ಘರ್‌ವಾಳು ನತರ್‌ಕಿ ಗಾಮ್‌ವಾಳು ತುಮೂನ ನಾ ಬುಲೈಲಿದುತೊ, ನತರ್‌ಕಿ ತುಮಾರಿ ವಾತೆನ ನಾ ಖ್ಹಮ್‌ಜುತೊ, ಯೋ ಗಾಮ್‌ನ ಮ್ಹೆಂದಿನ್ ಜಾ಼ವಾನಿ ವಖ್ಹತ್‌ಮ, ತುಮಾರ ಗೋಡಾನ ಲಗ್ಯುತೆ ಧೂಳ್‌ನ ಝ಼ಟ್‌ಕಿ ದೆವೊ. ");
INSERT INTO vaa_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","ನ್ಯಾವ್‍ನಿ ತೀರ್ಪ್‌ನ ದನ್ಮ ಇಮ್ನ ಗಾಮ್‌ನಿ ಹಾಲ್‌ ಸೊದೋಮ್ ಅಜು಼ ಗೊಮೋರ್‌ ತಬರ್‌ಖಾನಿ ಹಾಲ್‌ಥೀಬಿ ಖರಾಬ್ ರ‍್ಹಿಶೆ ಕರಿ ಮೇ ತುಮೂನ ಖ್ಹಾಚಮಾಬಿ ಬೋಲುಸ್” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“ಖ್ಹಮ್‌ಜೊ಼! ಜ಼ರಕ್‌ನ ಮಹಿ ಮೇಂಢವ್‌ನ ಮೋಕ್ಲಾತೆ ಇಮ್‌ ಮೇ ತುಮೂನ ಮೋಕ್ಲುಕರುಸ್. ಇನಖ್ಹಾಜೇಸ್ ತುಮೆ ಖ್ಹಾಪ್‌ನಿತರ ಚಾ಼ತುರ್ ಅಜು಼ ಪರ‍್ಯಾವಾನಿಘೋಣಿ ಖೋಟ್‌ಕೊಂತೆ ಇಮ್‌ ರ‍್ಹವೊ. ");
INSERT INTO vaa_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","ಅದ್ಮಿನಿ ಬಾರೇಮ ಜ಼ತನ್ ರ‍್ಹವೊ, ಶನಕತೊ ಇವ್ಣೆ ತುಮೂನ ಧರೀನ್, ನ್ಯಾವ್ ಕರಾನಿ ಸಭೆಮ ಖೇಚಿಲಿಜಾ಼ಶೆ, ಅಜು಼ ಇವ್ಣಿ ಸಬೆ ಭರಾವಾನು ಮಂದಿರ್‌ಮ ತುಮೂನ ಕೊಳ್ಡೇಥಿ ಮಾರ್‌ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","ಮಾರಖ್ಹಾಜೆ ತುಮೂನ ಅದಿಕಾರಿ ಅಜು಼ ರಾಜಾ಼ವ್‌ನ ಖ್ಹಾಮ್ಣೆ ಲೀಜಾ಼ಶೆ; ಅಮ್ ಇವ್ಣುನಾಬಿ ಅಜು಼ ಯೆಹೂದ್ಯರ್‌ಕಾಹೆತೆ ಅದ್ಮಿವೋನಾಬಿ ತುಮೆ ಸಬೂತ್ ಹುಯಿರ‍್ಹಿಶು. ");
INSERT INTO vaa_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","ಇವ್ಣೆ ತುಮೂನ ಧರಿದ್ಯವಾನಿ ವಖ್ಹತ್‌ಮ, ತುಮೆ ಶಾತ್‌ ವಾತೆ ಬೋಲ್‌ನು, ಕಿಮ್ ವಾತೆ ಬೋಲ್ನುಕರಿ ಸೋಚೊ ನಕೊ; ತುಮೆ ಶಾತ್‌ ಬೋಲ್ನುಕರಿ ಯೋ ವಖ್ಹತ್ ಆವಾದಿನ್, ತುಮೂನ ದೆವಾವ್‌ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","ವಾತೆ ಬೋಲವಾಳ ತುಮೆ ಕಾಹೆ; ತುಮಾರೊ ಬಾನೊ ಪವಿತ್ರ ಆತ್ಮಾಸ್‌ ತುಮಾರ ಮ್ಹೋಡವಾಟೆ ವಾತೆ ಬೋಲ್‌ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","ಭೈ ಉಠೀನ್ ಇನ ಶೊಂತ್‌ ಭೈಯೇನ, ಅಜು಼ ಬಾ ಉಠೀನ್ ಇನ ಶೊಂತ್‌ ಲಡ್ಕಾವ್‍ನ ಧರೀನ್, ಮರೈನಾಖಾನ ದಿನಾಕ್‌ಶೆ, ಲಡ್ಕಾ ಇವ್ಣ ಆಯ-ಬಾನಿ ವಿರೋದ್ ಉಠೀನ್, ಇವ್ಣುನ ಮರಾವ್‌ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","ಮಾರ ಕಾಮ್ನಖ್ಹಾಜೆ ಹರೇಕ್ ಜ಼ಣು ತುಮೂನ ವಹೇರ್‌ ಕರ್ಶೆ. ಕತೋಬಿ ಖ್ಹರ್ತಿಲಗು ಖ್ಹಮಾಳಿಲ್ಯವಾಳು ರಕ್ಷಣೆ ಲಿಶೆ. ");
INSERT INTO vaa_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","ಏಕ್‌ ಗಾಮ್ಮ ತುಮೂನ ಖ್ಹತಾಯೂತೊ, ಬಿಜ್ಜೇಕ್‌ ಗಾಮ್‌ನ ಮಿಲೈ ಜಾ಼ವೊ, ಅದ್ಮಿನೊ ಛಿಯ್ಯೊ ಆವಾನಮಹಿ ತುಮೆ ಇಸ್ರಾಯೇಲ್‌ ಅದ್ಮಿನು ಖ್ಹಾರಸ್ ಗಾಮ್ಮ ಫರೀನ್, ತುಮಾರು ಕಾಮ್ ಖತಮ್ ಕೊಕರಿರಾಕ್‌ಶುನಿ ಕರಿ ಮೇ ತುಮೂನ ಖ್ಹಾಚಾಮಬಿ ಬೋಲುಸ್. ");
INSERT INTO vaa_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","ಶಿಷ್ಯ ಗುರುಥಿ ಮೋಟೊ ಕಾಹೆ; ಆಳ್‌ ಇನ ಯಜಮಾನ್‍ಥಿ ಮೋಟೊ ಕಾಹೆ. ");
INSERT INTO vaa_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","ಶಿಷ್ಯ ಇನ ಗುರುನಿಮತ್‌ ಬಣ್ಯೋತೊ ಬಶ್‌, ಅಜು಼ ಆಳ್‌ ಇನ ಯಜಮಾನ್ನಿ ಮತ್‍ ಬಣ್ಯೋತೊ ಬಶ್‌. ಘರ್‌ನೊ ಯಜಮಾನ್ನಸ್‌, ಬೆಲ್ಜೆಬೂಲ್ ಕರಿ ಇವ್ಣೆ ಚಿಕ್‌ರ‍್ಯುತೊ, ಯೋ ಘರ್‌ನ ಬಿಜಾ಼ಖ್ಹಾರ ಅದ್ಮಿನ ಅಜು಼ಕೆತ್ರೆ ಖರಾಬ್ ನಾಮ್‍ಥಿ ಚಿಕರ್‌ಶೆ ಕೊಯ್ನಿಕಿಶು? ");
INSERT INTO vaa_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","ಇನಖ್ಹಾಜೇಸ್ ಅದ್ಮಿನ ದೇಖಿನ್‌ ಡರೊನಕೊ, ಲಪೈರ‍್ಹೂತೆ ಖ್ಹಾರುಸ್‌ ಭಡಕಿಜಾಶೆ, ಅಜು಼ ಶಿಕಾಡಿ ಬೋಲಾಸ್ತೆ ಹರ್‌ವಾತೆ ಉಜಾ಼ಳಾಮ ಭಾರ್‌ ಮಾಲುಮ್‌ ಪಡ್‌ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","ಮೇ ಅಂಧಾರಾಮ ತುಮೂನ ಬೋಲುಸ್ತೆ ಇನ ತುಮೆ ಉಜಾ಼ಳಾಮ ಬೋಲೊ. ಅಜು಼ ಕಾನ್‌ಮ ಬೋಲುಸ್ತೆ ಇನ ಘರ್‌ನ ಛ಼ತ್‍ಪರ್‌ಥು ಭೀರಿನ್‌ ಚಿಕ್ರಿನ್ ಬೋಲಿನ್ ಫೈಲಾವೊ. ");
INSERT INTO vaa_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","ಅತ್ರೇಸ್ ಕಾಹೆತೆ, ಶರೀರ್‌ನ ಮರ್‌ನಾಖಿನ್ ಆತ್ಮನ ಮಾರಾನ ಕೋ ಹುವ್ವಾನಿತೆ ಅದ್ಮಿನ ದೇಖಿನ್‌ ನಕೊ ಡರೊ; ಕತೋಬಿ ಆತ್ಮಾನ ಅಜು಼ ಶರೀರ್‌ನ ಭೇನ ನರಕ್ಮ ನಾಖಿನ್ ಬರ್ಬಾತ್ ಕರಾವಾಳೊ ದೇವ್ನ ದೇಖಿನ್ ಡರೊ. ");
INSERT INTO vaa_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","ಖಲಿ ಏಕ್ಕಾಖ್ಹ್‌ನ ಏಕ್‌ ಜೋ಼ಡು ಚು಼ರಕ್‌ಲಿಯೇನ ವೇಚಾ಼ಸ್ನಿ, ತೋಬಿ ಇನಾಮಾಥು ತುಮಾರೊ ಬಾನಿ ಮರ್ಜಿಕೊಂತೆ ಯೋ ಚು಼ರಕ್‌ಲೀಮ ಏಕ್‌ಬಿ ಜ಼ಮೀನ್‌ಪರ್ ಕೋ ಪಡಾನಿ. ");
INSERT INTO vaa_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","ಕತೋಬಿ ತುಮೂನಾತೊ, ತುಮಾರೊ ಮುಡ್‌ಕ್ಯಾನೊ ಕೇಖ್ಹ್‌ ಜಿನ್‌ಕುಬಿ ಖ್ಹಾರುಸ್‌ ಗಣೈರ‍್ಹೂಸ್‌. ");
INSERT INTO vaa_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","ಇನಖ್ಹಾಜೇಸ್ ಡರೊ ನಕೊ; ಕೈಏಕ್ಕಿ ಚು಼ರಕ್‌ಲಿಯೇಥೀಬಿ ತುಮೇಸ್ ಘಣ ಮೋಟ ಹುಯಿರ‍್ಹಾಸ್‌. ");
INSERT INTO vaa_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“ಕೋಣ್ ಅದ್ಮಿನ ಖ್ಹಾಮ್ಣೆ ಯೋ ಮಾರವಾಳೊಕರಿ ಬೋಲಸ್ಕಿ, ಮೇಬಿ ಇನ ಸೊರ್ಗಾಮ ಛಾ಼ತೆ ಮಾರ ಬಾನ ಖ್ಹಾಮ್ಣೆ ಯೋ ಮಾರ ಭಣಿವಾಳೊ ಕರಿ ಬೋಲಿಶ್. ");
INSERT INTO vaa_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","ಕತೋಬಿ ಕೋಣ್ ಅದ್ಮಿನ ಖ್ಹಾಮ್ಣೆ ಯೇಸುವಾಳೊ ಕಾಹೆ ಕರಿ ಬೋಲಸ್ಕಿ, ಮೇಬಿ ಇನ ಸೊರ್ಗಾಮ ಛಾ಼ತೆ ಮಾರ ಬಾನ ಖ್ಹಾಮ್ಣೆ ಯೋ ಮಾರ ಭಣಿವಾಳೊ ಕಾಹೆಕರಿ ಬೋಲಿಶ್. ");
INSERT INTO vaa_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","ಧರ್ತಿಪರ್ ಶಾಂತಿ ದ್ಯವಾನ ಮೇ ಆಯೊ ಕರಿ ನಕೊ ಸೋಚೊ, ಶಾಂತಿ ಪೈದಾಕರಾನ ಕಾಹೆ, ಪಣ್ಕಿ ತಲ್ವಾರ್‌ ಪಾಡಾನ ಆಯೋತೆ. ");
INSERT INTO vaa_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","ಛಿಯ್ಯಾನ ಅಜು಼ ಬಾನ, ಛೋ಼ರಿನ ಅಜು಼ ಆಯನ, ವ್ಹವ್‌ನಾಬಿ ಅಜು಼ ಖ್ಹಾಖ್ಹುನ ಮಹಿ ವಿರೋದ್‌ ಪೈದಾ ಕರಾನಖ್ಹಾಜೆ ಮೇ ಆಯೋತೆ. ");
INSERT INTO vaa_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","ಅಮ್ ಏಕ್‌ ಅದ್ಮಿನ ಇನು ಶೊಂತ್‌ ಘರ್‌ವಾಳುಸ್‌ ದುಶ್‌ಮನ್‌ ಉಶೆ. ");
INSERT INTO vaa_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","ಬಾನ ರ‍್ಹವೊ, ಆಯಾನ ರ‍್ಹವೊ, ಮಾರೇಥಿಬಿ ಜಾ಼ಖ್ಹತ್ ಪ್ಯಾರ್‌ಕರ‍್ಯುತೊ ಮನ ಲ್ಹಾಯೇಕ್‌ನೊ ಕಾಹೆ. ಛಿಯ್ಯಾನ ರ‍್ಹವೊ, ಛೋ಼ರಿನ ರ‍್ಹವೊ ಮಾರೇಥಿಬಿ ಜಾ಼ಖ್ಹತ್ ಪ್ಯಾರ್‌ಕರ‍್ಯುತೊ ಮಾರೊ ಶಿಷ್ಯ ಹುವಾನ ಲ್ಹಾಯಕ್‌ ಕಾಹೆ. ");
INSERT INTO vaa_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","ಕೋಣ್ ಇನಿ ಶಿಲ್‌ಬೇನ ಪಳ್ಳಿನ್‌, ಮಾರ ಪೀಠೆ ಕೋ ಆವಾನಿಕಿ, ಯೋ ಮಾರೊ ಶಿಷ್ಯ ಹುವಾನ ಲ್ಹಾಯೇಕ್‌ನೊ ಕಾಹೆ. ");
INSERT INTO vaa_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","ಇನು ಶೊಂತ್‌ ಜಾನ್ನ ಬಚಾ಼ಡಿಲೇವ್ಣು ಕರಿ ಕರಾವಾಳೊ ಇನ ಗುಮೈಲಿಶೆ; ಕತೋಬಿ ಮಾರಖ್ಹಾಜೆ ಇನು ಶೊಂತ್‌ ಜಾನ್ನ ಗುಮೈಲ್ಯವಾಳೊ ಇನ ಬಚಾ಼ಡಿಲಿಶೆ. ");
INSERT INTO vaa_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“ಕೋಣ್‌ತೋಬಿ ತುಮೂನ ಬುಲೈಲಿದುತೊ, ಇವ್ಣೆ ಮನ ಬುಲೈಲೆವಾದಾಖ್ಹಲ್‌; ಮನ ಬುಲೈಲೆಸ್ತೆ ಇವ್ಣೆ ಮನ ಮೋಕ್‌ಲ್ಯೊತೆ ಇನಾಸ್ ಬುಲೈಲೆವಾದಾಖ್ಹಲ್‌, ");
INSERT INTO vaa_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","ಪ್ರವಾದಿನ, ಆ ಪ್ರವಾದಿ ಕರಿ ಸ್ವಾಗತ್‍ಕರೀನ್ ಬುಲೈಲೆವಾಳಾನ, ಪ್ರವಾದಿನ ಆವ್‌ಶೇತೆ ಇನಾಮ್ ಲೀಲಿಶೆ. ಅಜು಼ ಧರ್ಮಿನ, ಯೋ ಏಕ್‌ ಧರ್ಮಿಕರಿ ಬುಲೈಲೆವಾಳಾನ, ಧರ್ಮಿನ ಆವ್‌ಶೇತೆ ಇನಾಮ್ ಮಳ್‌ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","ಆ ನ್ಹಾನಾವ್‍ಮ ಏಕ್‌ ಜ಼ಣಾನ ಯೇಸುನೊ ಶಿಷ್ಯಕರಿ ಬೋಲಿನ್ ಕೋಣ್‌ತೋಬಿ ಏಕ್‌ ತಾಂಬ್ಯೊ ಪಾಣಿ ಪಿಯ್ಯಾನ ದಿದುತೋಬಿ, ಇನ ಆವ್‌ಶೇತೆ ಇನಾಮ್ ಛು಼ಕ್‌ಶೆಸ್‌ ಕೊಯ್ನಿ ಕರಿ ಮೇ ತುಮೂನ ಖ್ಹಾಚಮಾಬಿ ಬೋಲುಸ್” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","ಯೇಸುನೆ ಇನ ಭಾರ ಶಿಷ್ಯರ‍್ನ ಬೋಲ್ನುತೆ ಖ್ಹಾರುಸ್‌ ಬೋಲಿನ್ ಖತಮ್ ಕರಾನ ಬಾದ್ಮ, ಹಿಜ್ಜಾ಼ಥೊ ನಿಕ್ಳಿನ್, ಅಛ್ಛಿ ಖಬರ್‌ ಬೋಲಿವತಾಳಾನ ಅಜು಼ ಶಿಕಾಡಾನಖ್ಹಾಜೆ ಖನ್ನೇನ ಗಾಮ್ಮ ಗಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","ಬ್ಯಾಪ್ತಿಸ್ಮ ದೆವಾಳೊ ಯೋಹಾನನೆ, ಕ್ರಿಸ್ತ ಕರುಕರ್ತೊಥೋತೆ ಕಾಮ್ ಖ್ಹಾರಾನಿ ಬಾರೇಮ ಜೇಲ್‌ಮ ಖ್ಹಮ್‌ಜಿನ್‌, ಇನ ಶಿಷ್ಯರ್‌ಮ ಥೋಡ ಜ಼ಣಾನ ಇನಾಕನ ಮೋಕ್‌ಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","ಇವ್ಣೆ ಯೇಸುನ, “ಯೊಹಾನ್ನೆ ಬೋಲ್ಯೋತೆ ಇಮ್‌ ಆವ್ಣುತೆ ಯೋ ತೂಸ್ಕಿಶು, ನಾತೊ ಹಮೆ ಬಿಜೇಕ್‌ನಖ್ಹಾಜೆ ಟಿವಾವ್‌ಣು?” ಕರಿ ಪುಛಾ಼ಯ. ");
INSERT INTO vaa_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","ಯೇಸುನೆ, “ಜೈ಼ನ್‌, ತುಮೆ ಶಾತ್‌ ಖ್ಹಮ್‌ಜ್ಯ ಅಜು಼ ದೇಖ್ಯಾಕಿ ಇನಿ ಬಾರೇಮ ಯೋಹಾನ್ನ ಬೋಲೊ: ");
INSERT INTO vaa_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","ಕಾಣಾವ್ನ ಡೋಳಾ ಆವ್‌ಶೆ, ಲಂಗ್ಡು ಖ್ಹಾರು ಚಾ಼ಲ್‌ಷೆ, ಖೋಡ್‍ ರ‍್ಹವಾಳು ಪಾಕ್‌ ಉಶೆ, ಭೈರಾವ್‍ನ ಖ್ಹಮ್‌ಜಾ಼ವ್‌ಶೆ, ಮರಿಗಯುಹುಯು ಜಿವ್ತು ಉಟ್‌ಶೆ, ಅಜು಼ ಗರೀಬ್‌ನ ಸುವಾರ್ತೆ ಬೋಲಾವ್‌ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","ಮಾರಿ ಬಾರೇಮ ಶಕ್ ಕರಾಕೊಂತೆ ಇವ್ಣೇಸ್‌ ಧನ್ಯ ಹುಯಿರ‍್ಹುಸ್‍” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","ಯೋಹಾನನು ಶಿಷ್ಯರ್‌ ಹಿಜ್ಜಾ಼ಥು ನಿಕ್ಳಿನ್ ಜ಼ವ್‍ಕರ್ತುಥೂತೆ ವಖ್ಹತ್‌ಮ, ಯೇಸುನೆ ಯೋಹಾನ್ನಿ ಬಾರೇಮ ಯೋ ಅದ್ಮಿನಿ ಝೂ಼ಂಡ್‌ನ ಶಾತ್‌ ಬೋಲ್ಯೊಕತೊ, “ತುಮೆ ಶಾತ್‌ ದೇಕ್ಣು ಕರಿ ಉಜ್ಜಾ಼ಡಿ ಝ಼ಗೋಮ ಗಯಾಥ? ವಹಿರಾಮ ಹಲಾಸ್ತೆ ಘಾಖ್ಹ್‌ನ ಡಂಟ್‍ನಾಕಿಶು? ");
INSERT INTO vaa_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","ಕೊಯ್ನಿಕತೊ, ಶಾತ್‌ ದೇಕ್ಣುಕರಿ ಗಯಾಥ? ಶನ್ಗಾರ್‌ನ ಲುಂಗ್ಡ ಪೇರ‍್ಹಿರಾಖಾಸ್ತೆ ಅದ್ಮಿನಾಕಿ ಶು? ಅಛ಼್ಛ ಶನ್‌ಗಾರ‍್ನಲುಂಗ್ಡಾ ಪೇರ‍್ಹಿರಾಖಾಸ್ತೆ ಖ್ಹಾರು ರಾಜಾ಼ನ ಮಹೇಲ್‌ಮ ರ‍್ಹೇಸ್‌! ");
INSERT INTO vaa_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","ಇಮ್‍ಕತೊ ಶಾತ್‌ ದೇಖಾನ ಗಯಾಥ? ಏಕ್‌ ಪ್ರವಾದಿನಕಿ ಶು? ಓಹೊ, ಪ್ರವಾದಿಥೀಬಿ ಮೋಟಾನ ತುಮೆ ದೇಖ್ಯಾಕರಿ ತುಮೂನ ಖ್ಹಾಚಮಾಬಿ ಬೋಲುಸ್. ");
INSERT INTO vaa_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","“ಹಂದೇಕ್‌, ಮಾರ ದೂತಾನ ತಾರ ಖ್ಹಾಮ್ಣೆ ಮೋಕ್ಲಿಶ್‌, ಯೋ ತೂ ಜಾ಼ವಾನಿ ವಾಟ್ನ ಬರೋಬರ್‌ ಕರ್ಶೆ’ ಕರಿ ಕಿನಿ ಬಾರೇಮ ವಚನ್‌ಮ ಲೀಖೈರೂಸ್ಕಿ, ಯೋ ಅದ್ಮಿ ಯೋಹಾನಸ್‌. ");
INSERT INTO vaa_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","ತಯೇಡಾನ ಪೇಟೆ ಪೈದಹುಯುತೆ ಖ್ಹಾರಾನ ಬ್ಯಾಪ್ತಿಸ್ಮ ದ್ಯವಾಳೊ ಯೋಹಾನ್‌ಥಿ ಮೋಟು ಕೋಣ್‌ಬಿ ಕೊಯ್ನಿ. ತೋಬಿ ಪರ್‌ಲೋಕ್ ರಾಜ್ಯಮ ಛಾ಼ತೆ ನ್ಹಾನೊ ಜಿನ್‌ಕುಬಿ ಯೋಹಾನ್‌ಥಿ ಮಹಾನ್ ಹುಯಿರ‍್ಹೋಸ್ ಕರಿ ಮೆ ತುಮೂನ ಖ್ಹಾಚಮಾಬಿ ಬೋಲುಸ್. ");
INSERT INTO vaa_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","ಬ್ಯಾಪ್ತಿಸ್ಮದ್ಯವಾಳೊ ಯೋಹಾನ್ನ ಹಗಾಮ್‌ಥು ಧರೀನ್ ಹಂಕೆತೋಡಿ ಸೊರ್ಗ ರಾಜ್ಯನಿ ಘಣು ಜು಼ಲಮ್‌ನ ಝೇಲ್‌ನು ಪಡ್ಯು, ಅಜು಼ ಜು಼ಲಮ್‌ ಕರಾವಾಳು ಅದ್ಮಿ ಇನ ಛಿನೈಲೇಣು ಕರಿ ಕರಾಸ್. ");
INSERT INTO vaa_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","ತಮಾಮ್‌ ಪ್ರವಾದಿ ಅಜು಼ ಧರ್ಮಶಾಸ್ತ್ರ ಯೋಹಾನ ಆವಾತೋಡಿ ದೇವ್ನಿ ರಾಜ್ಯನಿ ಬಾರೇಮ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","ಇವ್ಣೆ ಬೋಲ್ಯುತೆ ಇನ ನಂಬಾನ ತುಮೂನ ಮನ್ ಉಶೇತೊ, ಆ ಯೋಹಾನಸ್‌ ಆವಾಳೊ ಎಲೀಯಕರಿ ಬೋಲಾನಿತರ ಹುವಾಸ್ನಿ. ");
INSERT INTO vaa_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","ಖ್ಹಮ್‌ಜಾ಼ನ ಕಾನ್‌ ರ‍್ಹವಾಳು ಖ್ಹಮ್‌ಜಾ಼ದೆ! ");
INSERT INTO vaa_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“ಹಮ್ಕೆ ಮೆ ಆ ಹಗಾಮ್ನ ಪಿಳ್ಗಿನ ಮೆ ಖಿವಿ ಪರಕ್ಮ ಬೋಲು? ಅವ್ಣೆ ಬಜಾ಼ರ್‌ಮ ಬೆಠೂತೆ ಲಡ್ಕಾವ್‍ನಿಘೋಣಿ ಹುಯಿರ‍್ಹುಸ್‍. ಏಕ್‌ ಝೂ಼ಂಡ್‌ನ ಲಡ್ಕಾ ಬಿಜ್ಜೇಕ್‌ ಝೂ಼ಂಡ್‌ನ ಲಡ್ಕಾವ್‍ನ ಚಿಕ್ರಿನ್, ");
INSERT INTO vaa_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘ಹಮೆ ತುಮಾರಖ್ಹಾಜೆ ವಾಖ್ಹ್‌ಳಿ ವಜಾ಼ಡ್ಯ ತುಮೆ ಖೇಲ್ಯಕೊಯ್ನಿ; ಹಮೆ ಅಂದ್ರೋಖ್ಹ್‌ನು ಗೀದ್‌ ಬೋಲ್ಯ, ಕತೋಬಿ ತುಮೆ ರೋಯಾಕೊಯ್ನಿ!’ ಕರಿ ಬೋಲಾಸ್. ");
INSERT INTO vaa_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","ಕಿಮ್‌ಕತೊ, ಯೋಹಾನ ಆಯೊ, ಯೋ ಖಾತೋಥೊಕೊಯ್ನಿ ಅಜು಼ ಪೀತೋಥೊಕೊಯ್ನಿ, ಅಜು಼ ಅದ್ಮಿಖ್ಹಾರು, ‘ಇನ ಭೂತ್‌ ಧರಿರಾಖ್ಯುಸ್’ ಕರಿ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","ಅದ್ಮಿನೊ ಛಿಯ್ಯೊ ಆಯೊ, ಯೋ ಖಾಣುಪಾಣಿ ಲ್ಯವಾಳೊ ಹುಯಿರ‍್ಹೊಥೊ. ಅದ್ಮಿಖ್ಹಾರು ಇನ, ‘ಆ ಅದ್ಮಿ ಖಾಣನು ಮರ್‌ತೇಲ್‌ ಅಜು಼ ಪೀಕುಡ್ಕ ಹುಯಿರ‍್ಹೋಸ್! ಶುಂಕ ಮಾಂಗವಾಳನೊ ಅಜು಼ ಪಾಪಿ ಖ್ಹಾರಾನೊ ದೋಸ್ತ್’ ಕರಿ ಬೋಲಾಸ್, ಕತೋಬಿ ದೇವ್ನಿ ಗ್ಯಾನ್ ಖ್ಹಾಚಿಸ್ ಕರಿ ಬೋಲಾನು ಇನ ಕಾಮ್‌ಥೀಸ್‌ ಮಾಲುಮ್‌ ಪಡಾಸ್‌” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","ತದೆ ಯೇಸುನೆ ಯೋ ಕೈಯೆಕ್ಕಿ ಮಹಾನ್ ಕಾಮ್‌ಖ್ಹಾರು ಕರ‍್ಯೊತೆ ಗಾಮ್‌ವಾಳು ಪಾಪ್ನ ಮ್ಹೇಲಿನ್ ಫರ‍್ಯುಕೊಂತೆ ದೇಖಿನ್‌, ಇವ್ಣುನ ಗುರ್‌ಕಾವಲಗ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“ಅಯ್ಯೋ ಖೊರಾಜಿನ್‌ ಖ್ಹಯೇರ್, ತುಮಾರಿ ಹಾಲ್ನ ಶಾತ್‌ ಬೋಲು ಬೆತ್ಸಾಯಿದ, ತುಮಾರಿ ಹಾಲ್ನಬಿ ಶಾತ್‌ ಬೋಲು! ತುಮಾರಾಮ ಚಾ಼ಲ್ಯುತೆ ಮಹಾನ್ ಕಾಮ್‌ಖ್ಹಾರು ತೂರ್ ಅಜು಼ ಸೀದೋನ್ ಖ್ಹಯೇರ್‌ಮ ಚಾ಼ಲ್ಯುಹೋತ್ತೊ, ಹಿಜ಼್ಜಾವಾಳು ಕದೇಸ್‌ಕಿ ಛೈ಼ನೊಕೋಥ್‌ಳೊ ಲಪೇಟಿಲೀನ್, ರಾಕ್‌ಮ ಬೇಶಿನ್, ಇವ್ಣು ಪಾಪ್ನ ಮ್ಹೇಲಿನ್, ಫರಿಗಯುಹೋತ್‌! ");
INSERT INTO vaa_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","ಕತೋಬಿ ನ್ಯಾವ್‍ನಿ ತೀರ್ಪ್‌ನ ದನ್ಮ ತುಮಾರಿ ಹಾಲ್‌ಥೀಬಿ ತೂರ್ ಅಜು಼ ಸೀದೋನ್ ಖ್ಹಯೇರ‍್ನಿ ಹಾಲ್‌ ಅಛ್ಛಿ ರ‍್ಹಿಶೆ ಕರಿ ಮೇ ತುಮೂನ ಬೋಲುಸ್! ");
INSERT INTO vaa_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","ಅಲಾ ಕಪೆರ್ನೌಮ್ ಗಾಮ್‍, ತೂ ಸೊರ್ಗಾಮ ಪಡೈಲೀಶ್‌ಕರಿ ಸೋಚಾಸ್ಕಿ ಶು? ಕೊಯ್ನಿ! ತುನ ಪಾತಾಳ್ಮ ನಾಕ್‌ಶೆ! ತಾರಾಮ ಚಾ಼ಲ್ಯುತೆ ಅದ್ಭುತ್‌ಕಾಮ್‌ಖ್ಹಾರು ಸೊದೋಮ್‌ಮ ಚಾ಼ಲ್ಯುಹೋತ್ತೊ, ಯೋ ಖ್ಹಯೇರ್ ಹಂಕೆತೋಡಿ ರ‍್ಹಯುಹೋತ್‌. ");
INSERT INTO vaa_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","ಕತೋಬಿ ನ್ಯಾವ್‍ನಿ ತೀರ್ಪ್‌ನ ದನ್ಮ ತಾರಿ ಹಾಲ್‌ಥೀಬಿ ಸೊದೋಮ್ ತಬರ್‌ಖಾನಿ ಹಾಲ್‌ ಅಛ್ಛಿ ರ‍್ಹಿಶೆ ಕರಿ ಮೇ ತುಮೂನ ಬೋಲುಸ್” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","ಯೋ ವಖ್ಹತ್‌ಮ ಯೇಸುನೆ ಶಾತ್‌ ಬೋಲ್ಯೊಕತೊ, “ಬಾ, ಸೊರ್ಗ ಅಜು಼ ಧರ್ತಿನೊ ಯಜಮಾನ್! ತುನೆ ಗ್ಯಾನಿ ಅಜು಼ ಅಕ್ಲಿಥಿ ಅದ್ಮಿಥಿ ಆ ವಾತೆನ ಲಪಾಡಿನ್ ಶಾತ್ಬಿ ಮಾಲುಮ್‌ಕೊಂತೆ ಇವ್ಣುನ ವತಾಳಿರಾಖ್ಯೋತೆ ಇನಖ್ಹಾಜೆ ಮೇ ತುನ ಧನ್ಯವಾದ್ ಕರುಸ್. ");
INSERT INTO vaa_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","ಓಹೋಲಾ ಬಾ, ಅಮ್ಮಸ್ ಕರಾನು ಅಛ್ಛು಼ಕರಿ ತುನ ದೆಖಾಯು.” ");
INSERT INTO vaa_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","“ಮಾರೊ ಬಾ ಮನ ಖ್ಹಾರುಸ್‌ ಮಾರ ಹಾತ್ಮ ದೀರಾಖ್ಯೊಸ್. ಬಾನ ಮ್ಹೆಂದಿನ್ ಕೋಣ್‌ಬಿ ಛಿಯ್ಯಾನ ಮಾಲುಮ್‌ ಕರಿರಾಖ್ಯುಕೊಯ್ನಿ, ಅಜು಼ ಛಿಯ್ಯಾನ ಮ್ಹೆಂದಿನ್ ಕೋಣ್‌ಬಿ ಬಾನ ಮಾಲುಮ್‌ ಕರಿರಾಖ್ಯುಕೊಯ್ನಿ ಅಜು಼ ಛಿಯ್ಯೊ ಬಾನ ಕಿನ ವತಾಳ್ಣುಕರಿ ಆಖ್ಹ್‌ಕರಾಸ್ಕಿ, ಇವ್ಣೆ ಬಾನ ಮಾಲುಮ್‌ ಕರಿಲಿಶೆ. ");
INSERT INTO vaa_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“ಅಲಾ ಥಕಿರ‍್ಹವಾಳ, ಭೋಜೊ ಪಾಡಿರಾಖವಾಳ, ತುಮೆ ಖ್ಹಾರು ಮಾರಕನ ಆವೊ; ಮೇ ತುಮುನ ಅರಾಮ್‌ ದೆವುಸ್‌. ");
INSERT INTO vaa_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","ಮೇ ಹಂಕಾರ್‌ಭರ‍್ಯೊ ಕಾಹೆ ಅಜು಼ ಕೌಳೊ ದಿಲ್‌ವಾಳೊ ಹುಯಿರ‍್ಹೋತೆ ಇನಖ್ಹಾಜೆ, ಮಾರು ನೊಗಾನ ತುಮಾರಪರ್ ಪಾಡಿಲೀನ್ ಮಾರೇಥಿ ಶಿಕಿಲೇವೊ. ತದೆ ತುಮಾರು ಆತ್ಮಾನ ಅರಾಮ್‌ ಮಳ್‌ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","ಶನಕತೊ ಮಾರು ನೊಗ ಪೋಲು ಹುಯಿರ‍್ಹುಸ್‍ ಅಜು಼ ಮಾರು ಭೋಜ಼್‌ ಕಮ್‍ ವಜ಼ನ್ನು ಹುಯಿರ‍್ಹುಸ್‍” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","ಯೋ ದನೂಮ ಸಬ್ಬತ್‌ನ ರೋಜೆ ಯೇಸು ಅನಾಜ಼್ ಪಿಕಿಹುಯು ಖೇತರ್‌ಮಾಕರಿ ಚಾ಼ಲಿನ್ ಜಾ಼ವಾನಿ ವಖ್ಹತ್‌ಮ, ಇನ ಶಿಷ್ಯರ್‌ನ ಭುಕ್ ಲಾಗಲಗ್ಯುಥು, ಇನಖ್ಹಾಜೆ ಇವ್ಣೆ ಬುಟ್ಟಾ ತೋಡಿನ್, ಖಾವಲಗ್ಯಾಥ. ");
INSERT INTO vaa_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","ಅನದೇಖಿನ್‌ ಫರಿಸಾಯರ್‌ನೆ ಯೇಸುನ, “ಹಂದೇಕ್‌, ತಾರು ಶಿಷ್ಯರ್‌ ಧರ್ಮಶಾಸ್ತ್ರನು ವಿರೋದ್ ಸಬ್ಬತ್‌ ದನ್ಮ ಕರ್ನುನಾತೆ ಕಾಮ್ನ ಕರುಕರಸ್” ಕರಿ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","ತದೆ ಯೇಸುನೆ ಇವ್ಣುನ, “ದಾವೀದ್‌ನಾಬಿ, ಇನ ಜೋ಼ಡ್ಮ ರ‍್ಹವಾಳಾನ ಭುಕ್ ಲಾಗಖ್ಹತರ್‌, ದಾವೀದ್‌ನೆ ಶಾತ್‌ ಕರ‍್ಯೊ ಕರಿ ತುಮೆ ಪಢ್ಯಾಕೊಯ್ನಿಕಿಶು? ");
INSERT INTO vaa_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","ದಾವೀದ್‌ನೆ ದೇವ್ನ ಮಂದಿರ್‌ಮ ಜೈ಼ನ್‌, ಯಾಜಕರಸ್‌ ಖಲಿಖಾವ್ಣುಥುತೆ ಪಣ್ಕಿ, ದಾವೀದ್ ರ‍್ಹವೊ, ಇನ ಜೋ಼ಡ್ಮ ರ‍್ಹವಾಳು ರ‍್ಹವೊ, ನಾ ಖಾವ್ಣುಕರಿ ಖಾನುಲ್‌ ರ‍್ಹಯುತೋಬಿ, ದೇವ್ನ ಝಾ಼ಳ್‌ಉತಾರನ ರೋಟಾನ ಖಾದೋನಿ? ");
INSERT INTO vaa_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","ಅತ್ರೇಸ್ ಕಾಹೆತೆ, ಸಬ್ಬತ್‌ ದನ್ಮ ಯಾಜಕರ್‌ ಮಂದಿರ್‌ಮ ಸಬ್ಬತ್‌ ದನ್ನ ಮೈಲಾಪ್‍ ಕರ‍್ಯುತೋಬಿ ಇವ್ಣೆ ಅಪರಾದ್‌ಕೊಂತೆ ರ‍್ಹೇಸ್. ಇನತುಮೆ ಮೋಶೆನ ಧರ್ಮಶಾಸ್ತ್ರಮ ಪಢ್ಯಕೊಯ್ನಿಕಿ ಶು? ");
INSERT INTO vaa_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","ಕತೋಬಿ ಮೇ ತುಮೂನ, ಮಂದಿರ್‌ಥೀಬಿ ಮೋಟೊ ಹಜ್ಜಾ಼ ಛಾ಼ ಕರಿ ಬೋಲುಸ್. ");
INSERT INTO vaa_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","‘ಮನ ಜಾನ್ವರ್‌ನು ಬಲಿ ನಕೊ, ಗೋರಸ್ ಹೋಣುತೆ’ ಕರಿ ಧರ್ಮಶಾಸ್ತ್ರಮ ಬೋಲಾಸ್ತೆ ಇನಿ ಮತ್‌ಲಬ್ ತುಮೂನ ಖ್ಹಾಚಮಾಬಿ ಮಾಲುಮ್‌ ರ‍್ಹಯುಹೋತ್ತೊ, ಗಲತ್‌ ಕರಾಕೊಂತೆ ಇವ್ಣಾಪರ್ ತುಮೆ ಗಲತ್‌ ಕೋ ಲಗಾಡ್ಯಹೋತ್ನಿ. ");
INSERT INTO vaa_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","ಅದ್ಮಿನೊ ಛಿಯ್ಯೊ ಸಬ್ಬತ್‌ ದನ್ನ ಪ್ರಭು ಹುಯಿರ‍್ಹೋಸ್” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","ಯೇಸು ಹಿಜ್ಜಾ಼ಥೊ ನಿಕ್ಳಿನ್, ಯೆಹೂದ್ಯರ್‌ನ ಸಬೆ ಭರಾವಾನು ಮಂದಿರ್‌ಮ ಗಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","ಹಿಜ್ಜಾ಼ ಹಾತ್‌ ಝೂ಼ಟೊ ಪಡಿಹುಯು ಏಕ್‌ ಅದ್ಮಿಥು. ತದೆ ಥೋಡು ಜ಼ಣು ಯೇಸುಪರ್‌ ಗಲ್ತಿ ಲಗಾಡ್‌ಣು ಕರಿ, ಇವ್ಣೆ ಇನ, “ಸಬ್ಬತ್‌ ದನ್ಮ ಅಛ್ಛು಼ ಕರಾನು ಅಪ್ಣ ಧರ್ಮಶಾಸ್ತ್ರಮ ಬರೋಬರ್‌ಕಿ ಶು?” ಕರಿ ಪುಛಾ಼ಯು. ");
INSERT INTO vaa_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","ಯೇಸುನೆ, “ತುಮಾರಮ ಕಿನಾಕನಾತೋಬಿ ಎಕ್ಕಸ್ ಮೇಂಢು ರ‍್ಹೀನ್, ಸಬ್ಬತ್‌ ದನ್ಮ ಯೋ ಮೇಂಢು ಖಾಡ್‌ಮ ಪಡಿಗಯೂತೊ ಯೋ ಇನ ಧರೀನ್, ಉಪ್ಪರ್ ಪಾಡ್‌ಶೆಕೊಯ್ನಿಕಿ ಶು? ");
INSERT INTO vaa_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","ಮೇಂಢಥೀಬಿ ಅದ್ಮಿ ಕೈಯೆಕ್ಕಿ ಮಹಾನ್ ಹುಯಿರ‍್ಹುಸ್‍! ಇನಖ್ಹಾಜೇಸ್ ಸಬ್ಬತ್‌ ದನ್ಮ ಅಛ್ಛು಼ಕಾಮ್ ಕರಾನು ಅಪ್ಣಿ ಧರ್ಮಶಾಸ್ತ್ರಮ ಬರೋಬರಸ್‌ ಹುಯಿರ‍್ಹುಸ್‍” ಕರಿ ಜವಾಬ್‌ ದಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","ಅನಕೇಡೆಥು ಯೇಸುನೆ ಯೋ ಹಾತ್‌ ಝೂ಼ಟೊ ಪಡಿಹುಯು ಅದ್ಮಿನ, “ತಾರೊ ಹಾತ್‌ ಖ್ಹಾಮ್ಣೆ ಕರ್‌” ಕರಿ ಬೋಲ್ಯೊ; ಇನೆ ಖ್ಹಾಮ್ಣೆ ಕರ‍್ಯೊ. ತದೆ ಇನೊ ಹಾತ್‌ ಅಛ್ಛು಼ ಹುಯಿನ್, ಬಿಜ್ಜೇಕ್‌ ಹಾತ್ನಿ ಘೋಣಿ ಹುಯಿಗಯು. ");
INSERT INTO vaa_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","ತದೆ ಫರಿಸಾಯರ್ ಖ್ಹಾರು ಭಾರ್‌ಜೈ಼ನ್‌, ಯೇಸುನ ಖೆವಿ ತರೀಕಾಥಿ ಮಾರಿಯೆ ಕರಿ ಸೋಚ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","ಯೇಸುನೆ ಇನಿ ವಿರೋದ್ ಇವ್ಣೆ ಸೋಚುಕರಾತೆ ಇನ ಮಾಲುಮ್‌ ಕರಿಲೀನ್, ಹಿಜ್ಜಾ಼ಥೊ ಚ಼ಲೆಗಯೊ; ಮೋಟಿ ಭೀಡ್ ಇನ ಪೀಠೆ ಗಯು. ಅರಾಮ್‌ಕೊಂತೆ ಖ್ಹಾರಾವ್‌ನ ಇನೆ ಅಛ್ಛು಼ ಕರ‍್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","ಅಜು಼ ಇನಿ ಬಾರೇಮ ಬಿಜಾ಼ನ ನಾ ಬೋಲ್‌ನು ಕರಿ ಅದ್ಮಿ ಖ್ಹಾರಾನ ಝೇತಾಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","ದೇವ್ನೆ ಪ್ರವಾದಿ ಯೆಶಾಯನ ಮ್ಹೋಡೇಥಿ ಬೋಲಾಯೋತೆ ಖ್ಹಾಚ಼ನ, ಚ಼ಲಾವಾನಖ್ಹಾಜೆ ಯೇಸುನೆ ಆ ಖ್ಹಾರು ಕರ‍್ಯೊತೆ: ");
INSERT INTO vaa_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","ಹಂದೇಕ್‌, ಮಾರೊ ಸೇವಕ್, ಅನ ಮೇ ಚೂ಼ಣಿ ರಾಖ್ಯೋಸ್, ಆ ಮಾರೊ ಪ್ಯಾರ್‌ನೊ ಹುಯಿರ‍್ಹೋಸ್, ಅನೇಥಿ ಮೇ ಖ್ಹುಶಿ ಛೂ಼. ಮೇ ಮಾರು ಆತ್ಮಾನ ಇನಾಪರ್‌ ರಾಖುಸ್, ಅಜು಼ ಯೋ ಅಲಕ್‌ ಅದ್ಮಿವೋನಾಬಿ ಮಾರಿ ನ್ಯಾವ್‌ನ ಬೋಲಿವತಾಳ್‌ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","ಯೋ ಲಡೈ ಕರಾಕೊಯ್ನಿ ಅಜು಼ ಚಿಕ್ರಾಕೊಯ್ನಿ; ಗಲ್ಲಿಯೇಮ ಇನಿ ಅವಾಜ಼್ ಕಿನಾಬಿ ಖ್ಹಮ್‌ಜಾ಼ವಕೊಯ್ನಿ. ");
INSERT INTO vaa_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","ಚ಼ಗ್‌ದೈಗಯುತೆ ಡಂಟ್‍ನ ಯೋ ತೋಡಾಕೊಯ್ನಿ, ಉಝ಼ವ್‍ಕರಾತೆ ದಿವೋನಾಬಿ ಯೋ ಉಝಾ಼ವಕೊಯ್ನಿ, ನ್ಯಾವ್‌ನ ಜೀತಾತೋಡಿ ಯೋ ಲಗ್ಯುರ‍್ಹೀಶೆ. ");
INSERT INTO vaa_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","ಅಜು಼ ಅಲಕ್‌ ಅದ್ಮಿಖ್ಹಾರು ಇನ ನಾಮ್‌ಪರ್‌ ಭರೋಖ್ಹೊ ಕರ್ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","ಭೂತ್‌ ಧರಿರಾಖ್ಯುಥೂತೆ ಇನಖ್ಹಾಜೇಥಿ ಕಾಣು ಅಜು಼ ಮುಕ್ಕು ಹುಯಿರ‍್ಹುಥೂತೆ ಏಕ್‌ ಜ಼ಣಾನ ಯೇಸುಕನ ಲಾಯು. ಇನೆ ಇನ ಅಛ್ಛು಼ ಕರ್ತಾನ, ಇನ ಡೋಳಾ ಅಜು಼ ವಾತೆ ಆಯು. ");
INSERT INTO vaa_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","ತದೆ ಯೇಸುನೆ ಕರ‍್ಯೊತೆ ಇನ ದೇಖಿನ್, ಅದ್ಮಿಖ್ಹಾರು ಆಶ್ಚರ್ಯಖೈನ್, “ಆ ದಾವೀದ್‌ನೊ ಛಿಯ್ಯೊಕಿ ಶು?” ಕರಿ ಬೋಲಿಲಿದು. ");
INSERT INTO vaa_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","ಕತೋಬಿ ಫರಿಸಾಯರ್‌ನೆ ಅನಖ್ಹಮ್‌ಜಿನ್, “ಭೂತ್‌ ಖ್ಹಾರಾನೊ ಯಜಮಾನ್ ಹುಯಿರ‍್ಹೋತೆ ಬೆಲ್ಜೆಬೂಲ್‌ನಿ ಮದತ್‌ಥೀಸ್ ಆ ಭೂತ್‌ ಖ್ಹಾರಾನ ಕಾಡಸ್‌ ಪಣ್ಕಿ, ಬಿಜು಼ ಶನೇಥೀಬಿ ಕಾಹೆ” ಕರಿ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","ಯೇಸುನೆ ಇವ್ಣಿ ಸೋಚ್ನ ಮಾಲುಮ್‌ ಕರಿಲೀನ್, “ಕೆಹು ರಾಜ್ಯ ಫುಟ್‌ ಪಡೀನ್, ಇನಿ ವಿರೋದ್ ಯೋಸ್‌ ಭೀಡಾಸ್ಕಿ, ಯೋ ರಾಜ಼್ ಬರ್ಬಾತ್ ಹುಯಿಜಾ಼ಶೆ. ಇಮ್ಮಸ್ ಏಕ್‌ ಘರ್‌ಮ ರ‍್ಹವೊ, ಖ್ಹಯೇರ್‌ಮ ರ‍್ಹವೊ ಫುಟ್‌ ಪಡೀನ್, ಖ್ಹುದ್‌ನಿ ವಿರೋದ್ ಭೀಡಾಲಗಾಸ್ಕಿ, ಇಮ್ನು ಘರ್ ಅಜು಼ ಖ್ಹಯೇರ್ ಪಡಿಜಾ಼ಸ್‌. ");
INSERT INTO vaa_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","ಇಮ್ಮಸ್‌ ಶೈತಾನ್ ಶೈತಾನ್ನ ನಖ್ಹಾಡ್ಯುತೊ ಇನಿ ವಿರೋದ್ ಲಡೈಭೀಡಾನಿತರ ಹುಯು, ಇಮ್‍ರ‍್ಹಯುತೊ ಇನಿ ರಾಜ್ಯ ಕಿಮ್ ಭೀರ‍್ಹಿಷೆ? ");
INSERT INTO vaa_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","ಮೇ ಬೆಲ್ಜೆಬೂಲ್‌ನಿ ಶಕಥ್ಥಿ ಭೂತ್‌ಖ್ಹಾರು ಕಾಡುಸ್‌ ಕರಿ ತುಮೆ ಬೋಲೋಸ್‌. ಇಮ್‍ಕತೊ, ತುಮಾರು ಶಿಷ್ಯರ್‌ಖ್ಹಾರು ಕಿನಿ ಶಕಥ್ಥಿ ಭೂತ್‌ಖ್ಹಾರನ ಕಾಡಸ್‌? ಇನಖ್ಹಾಜೇಸ್ ತುಮಾರು ಅದ್ಮಿಸ್‌ ತುಮೂನ ನ್ಯಾವ್ ಕರ್ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","ಮೇ ಬೆಲ್ಜೆಬೂಲ್‌ನಿ ಶಕಥ್ಥಿ ಕಾಹೆ, ಕತೋಬಿ ದೇವ್ನಿ ಆತ್ಮಾನಿ ಶಕಥ್ಥಿ ಭೂತ್‌ಖ್ಹಾರನ ಕಾಡ್ತೊ ಉಶೇತೊ, ದೇವ್ನಿ ರಾಜ್ಯ ತುಮಾರ ಖನ್ನೆ ಆಯಿಗೈಯು ಕರಿ ಆ ವತಾಳಸ್‍. ");
INSERT INTO vaa_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","ಅತ್ರೇಸ್ ಕಾಹೆತೆ, ಕೋಣ್‌ಬಿ ಪಹಿಲೆ ಏಕ್‌ ಶಕತ್‌ವಾಳ ಅದ್ಮಿನ ಭಾಂದ್ಯುನಾತೊ, ಇನ ಘರ್‌ಮ ಪೇಶಿನ್, ಇನು ಶೊತ್‌ನ ಲೂಟಾನ ಕೋ ಹುವಾನಿ, ಪಹಿಲ್‌ವಾಣ್ಣ ಭಾಂದಾನ ಬಾದ್‌ಮ, ಇನ ಘರ್‌ನ ಲೂಟೆಜಾ಼ಯ್‌. ");
INSERT INTO vaa_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","ಮಾರ ಜೋ಼ಡ್ಮ ಮಳಾಕೊಂತೆ ಇವ್ಣೆ ಮಾರು ವಹೇರ‍್ಯು ಹುಯಿರ‍್ಹುಸ್‍. ಮಾರ ಜೋ಼ಡ್ಮ ಎಕ್ಟು ಕರಾಕೊಂತೆ ಇವ್ಣೆ ಛಿದ್ರಾವವಾಳು ಹುಯಿರ‍್ಹುಸ್‍. ");
INSERT INTO vaa_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","ಇನಖ್ಹಾಜೇಸ್ ಮೇ ತುಮೂನ ಬೋಲುಸ್, ಅದ್ಮಿಖ್ಹಾರು ಕರಾತೆ ಹರೇಕ್ ಪಾಪ್ನ ಅಜು಼ ಗಾಳೆನಿ ವಾತೇನ ಮಾಪಿ ಛಾ಼; ಕತೋಬಿ ಪವಿತ್ರಾತ್ಮನ ವಿರೋದ್ ವಾತೆ ಬೋಲವಾಳಾನ ಮಾಪಿಕೊಯ್ನಿ. ");
INSERT INTO vaa_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","ಕೋಣ್‌ತೋಬಿ ಅದ್ಮಿನೊ ಛಿಯ್ಯಾನ ವಿರೋದ್ ವಾತೆ ಬೋಲ್ಯುತೊ ಇನ ಮಾಪಿ ಛಾ಼; ಕತೋಬಿ ಪವಿತ್ರಾತ್ಮನಿ ವಿರೋದ್ ವಾತೆ ಬೋಲ್ಯುತೊ ಇನ ಆ ಜಗತ್‌ಮ ಹಮ್ಕೆಬಿ ಕೊಯ್ನಿ, ಕದೇಬಿ ಮಾಪಿಸ್‍ಕೊಯ್ನಿ. ");
INSERT INTO vaa_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“ತುಮೂನ ಅಛ್ಛು಼ ಪಂಡು ಹೋಣುಕತೊ ತುಮಾರಕನ ಅಛ್ಛು಼ ಝಾ಼ಡು ರ‍್ಹೇಣು. ತುಮಾರು ಝಾ಼ಡು ಅಛ್ಛು಼ ನಾ ರ‍್ಹಯೂತೊ, ಯೋ ಖರಾಬ್ ಪಂಡಾನಸ್‌ ಮ್ಹೇಲ್‌ಶೆ, ಏಕ್‌ ಝಾ಼ಡು ಕಿಮ್ನು ಕರಿ ಬೋಲಾನು ಯೋ ಮ್ಹೇಲಾತೆ ಪಂಡಾಥೀಸ್‌ ಮಾಲುಮ್‌ ಪಡಾಸ್‌”. ");
INSERT INTO vaa_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","ಅಲಾ ಖ್ಹಾಪ್‌ನ ಖಾನ್‌ದಾನ್‌ವಾಳ! ತುಮೆ ಖರಾಬ್ ರ‍್ಹವಾಪರ್, ತುಮಾರ ಮ್ಹೋಡವಾಟೆ ಅಛ಼್ಛು ವಾತೆ ಕಿಮ್ ನಿಕಳ್‌ಶೆ? ದಿಲ್ಮ ಭರೈರ‍್ಹೇಸ್ತೇಸ್‌ ಮ್ಹೋಡವಾಟೆ ನಿಕ್ಳಾಸ್‌. ");
INSERT INTO vaa_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","ಏಕ್‌ ಅಛ್ಛು಼ ಅದ್ಮಿ ಇನಿ ಕಣ್ಗಿಮಾಥು ಅಛ಼್ಛು ರಾಛ಼ವ್‍ನ ಭಾರ್ ಕಾಡಸ್‌; ಏಕ್‌ ಖರಾಬ್ ಅದ್ಮಿ ಇನು ಖರಾಬ್ ಕಣ್ಗಿಮಾಥು ಖರಾಬ್ ರಾಛ಼ವ್‍ನ ಭಾರ್‌ಕಾಡಸ್‌. ");
INSERT INTO vaa_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","ಅತ್ರೇಸ್ ಕಾಹೆತೆ, ಮೇ “ತುಮೂನ ಶಾತ್‌ ಬೋಲುಸ್‌ಕತೊ, ಅದ್ಮಿಖ್ಹಾರು ಫಾಯಿದೊಕೊಂತೆ ಬೋಲಾಸ್ತೆ ಹರೇಕ್ ವಾತೇನಿ ಬಾರೇಮ ನ್ಯಾವ್‍ನಿ ತೀರ್ಪ್‌ನ ದನ್ಮ ಗಣ್ತಿ ದೇವ್ಣುಪಡ್‌ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","ತಾರಿ ವಾತೆಥೀಸ್‌ ತೂ ನೀತಿವಾಳೊಕರಿ ತೀರ್ಪ್‌ ಮಳ್‌ಶೆ; ಅಜು಼ ತಾರಿ ವಾತೆಥೀಸ್‌ ತೂ ಅಪರಾದಿಕರಿ ತೀರ್ಪ್ ಮಳ್‌ಶೆ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","ತದೆ ಮೋಶೆನಿ ವಚನ್ ಶಿಕಾಡವಾಳು ಶಾಸ್ತ್ರಿಯೆ ಅಜು಼ ಫರಿಸಾಯರ್‌ಮ ಥೋಡು ಜ಼ಣು ಯೇಸುನ, “ಗುರು, ತೂ ಅದ್ಭುತ್ ಕರಾನು ದೇಕ್ಣು ಕರಿ ಹಮೆ ಆಖ್ಹ್ ಕರಿಯೇಸ್” ಕರಿ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","ಯೇಸುನೆ, “ಆ ಜ಼ಗ್‌ನು ಅದ್ಮಿ ಖರಾಬ್ ಅಜು಼ ಪಾಪಿ ಹುಯಿರ‍್ಹುಸ್‍, ಅವ್ಣೆ ಅದ್ಭುತ್ ಕಾಮ್ ದೇಕ್ಣು ಕರಿ ಆಖ್ಹ್ ಕರಾಸ್. ಕತೋಬಿ ಯೋನ ಕರಿ ಪ್ರವಾದಿಮ ಹುಯೂತೆ ಅದ್ಭುತ್ ಕಾಮಸ್ ಪಣ್ಕಿ, ಬಿಜು಼ ಕೆಹೂಬಿ ಕೊಯ್ನಿ. ");
INSERT INTO vaa_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","ಯೋನ ಕಿಮ್ ತೀನ್ ರಾತ್‌-ದನ್ ಮೋಟಮಾಛ್ಲಾ಼ನ ಪೇಟ್‌ಮ ಥೋಕಿಇಮ್ಮಸ್‌, ಅದ್ಮಿನೊ ಛಿಯ್ಯೊ ತೀನ್ ರಾತ್‌-ದನ್ ಧರ್ತಿನ ಮಹಿ ರ‍್ಹಿಶೆ. ");
INSERT INTO vaa_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","ನ್ಯಾವ್‍ನ ತೀರ್ಪ್‌ನ ದನ್ಮ ನಿನವೆ ನಂಗರ್‌ವಾಳು ಆ ಪಿಳ್ಗಿವಾಳಾನ ವಿರೋದ್ ಭೀರಿನ್‌, ತುಮೆ ಗಲತ್‌ ಕರಿ ಬೋಲ್‌ಶೆ. ಇವ್ಣೆ ಯೋನಾನೆ ಬೋಲ್ಯೋತೆ ವಚನ್ನ ಖ್ಹಮ್‌ಜಿನ್‌, ಪಾಪ್ನ ಮ್ಹೇಲಿನ್ ದೇವ್ ಭಣಿ ಫರಿಗಯು. ಕತೋಬಿ ಮೇ ತುಮೂನ ಬೋಲುಸ್ಕಿ, ಯೋನಾಥೀಬಿ ಮೋಟೊ ಹಜ್ಜಾ಼ ಛಾ಼! ");
INSERT INTO vaa_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","ಶೆಬಾ ದೇಖ್ಹ್‌ನಿ ರಾಣಿ ನ್ಯಾವ್‍ನ ತೀರ್ಪ್‌ನ ದನ್ಮ ಆ ಪಿಳ್ಗಿನಿ ವಿರೋದ್ ಭೀರಿನ್‌, ತುಮೆ ಗಲತ್‌ ಕರಿ ಬೋಲ್‌ಶೆ. ಯೋ ಸೊಲೊಮೋನ್ನಿ ಗ್ಯಾನ್ನಿ ವಾತೇನ ಖ್ಹಮ್‌ಜಾ಼ನಖ್ಹಾಜೆ ಜಗತ್ನ ಕಡ್‍ಶೀಥಿ ಆಯಿ. ಕತೋಬಿ ಮೇ ತುಮೂನ ಬೋಲುಸ್ಕಿ, ಸೊಲೊಮೋನ್‌ಥೀಬಿ ಊಚೊರ‍್ಯವಾಳೊ ಹಜ್ಜಾ಼ ಛಾ಼! ");
INSERT INTO vaa_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“ಭೂತ್‌ ಏಕ್‌ ಅದ್ಮಿನ ಮ್ಹೇಲಿನ್ ನಿಕ್ಳಿಜಾ಼ವಾನ ಬಾದ್ಮ, ಅರಾಮ್‌ ಕರಾನಖ್ಹಾಜೆ ಝ಼ಗೊ ಢೂಂಡ್‌ತುಹುಯಿನ್, ಪಾಣಿಕೊಂತೆ ಝ಼ಗೋಮ ವನ್‌ವನ್ತು ರ‍್ಹೇಸ್. ");
INSERT INTO vaa_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","ಕತೋಬಿ ಅರಾಮ್‌ ಕರಾನ ಝ಼ಗೊ ಮಳಾಕೊಂತೆ ದೇಖಿನ್‌, ಯೋ, “ಮೇ ಮ್ಹೆಂದಿನ್ ಆಯೋತೆ ಮಾರ ಘರ್‌ನ ಫಾಛು಼ ಫರೀನ್ ಜ಼ವುಸ್‌” ಕರಿ ಬೋಲಿನ್, ಪಾಛು಼ ಯೋ ಘರ್‌ಕನ ಆಯಿನ್, ಯೋ ಘರ್ ಖಾಲಿ ಪಡ್ಯುತೆ ಅಜು಼ ಝ಼ಡೈಶನ್‌ಗಾರ್‌ ಹುಯಿರ‍್ಹೂತೆ ದೇಖಿನ್‌, ");
INSERT INTO vaa_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","ಜೈ಼ನ್‌, ಇನೇಥಿಬಿ ಖರಾಬ್ ಹುಯಿರ‍್ಹೂತೆ ಬಿಜು಼ ಖ್ಹಾತ್ ಭೂತ್‌ನ ಇನ ಜೋ಼ಡೆ ಬುಲೈಲಿನ್ ಆವಸ್. ಇವ್ಣೆ ಯೋ ಅದ್ಮಿನ ಮಹಿ ಪೇಶಿನ್, ಹಿಜ್ಜಾ಼ಸ್ ರ‍್ಹವಾಲಗಸ್‌, ತದೆ ಯೋ ಅದ್ಮಿನಿ ಖ್ಹರ್ತಿಮಾನಿ ಹಾಲ್‌ ಪಹಿಲೆಥೀಬಿ ಖರಾಬ್ ಹುಯಿಜಾ಼ಸ್. ಅಮ್ಮಸ್ ಆ ಪಿಳ್ಗಿನು ಖರಾಬ್ ಅದ್ಮಿನ ಉಶೆ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","ಯೇಸು ಅದ್ಮಿನಿ ಝೂ಼ಂಡ್‌ನ ಜೋ಼ಡೆ ಬಿಜೂ಼ಬಿ ವಾತೆ ಬೋಲುಕರಾನಿ ವಖ್ಹತ್‌ಮ, ಇನಿ ಆಯಾಬಿ ಇನ ಭೈಯೇ ಅಯಿನ್, ಇನಜೋ಼ಡೆ ವಾತೆ ಬೋಲ್‌ನು ಕರಿ ಭಾರ್‌ಭೀರ‍್ಯು. ");
INSERT INTO vaa_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","ತದೆ ಏಕ್‌ ಜ಼ಣಾನೆ ಯೇಸುನ, “ಹಂದೇಕ್‌, ತಾರಿ ಆಯಾಬಿ, ತಾರ ಭೈಯೇ, ತುನ ವಾತೆ ಬೋಲ್‌ನು ಕರಿ ಭಾರ್‌ ಭಿಯ್ಯುಸ್” ಕರಿ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","ಯೇಸುನೆ, “ಮಾರಿ ಆಯ ಕೋಣ್? ಮಾರ ಭೈಯೇ ಕೋಣ್? ಕರಿ ಬೋಲಿನ್, ");
INSERT INTO vaa_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","ಶಿಷ್ಯರ್‌ ಭಣಿ ಹಾತ್‌ ವತಾಳಿನ್ “ಹಂದೇಖೊ! ಅವ್ಣೆಸ್‌ ಮಾರಿ ಆಯ ಅಜು಼ ಮಾರ ಭೈಯೇ”. ");
INSERT INTO vaa_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","ಪರ್‌ಲೋಕ್‌ಮ ಛಾ಼ತೆ ಮಾರ ಬಾನಿ ಮರ್ಜಿನಿ ಘೋಣಿ ಕೋಣ್ ಚಾ಼ಲಾಸ್ಕಿ, ಯೋಸ್‌ ಮಾರೊ ಭೈ, ಮಾರಿ ಭೇನ್ ಅಜು಼ ಮಾರಿ ಆಯ ಹುಯಿರುಸ್‌” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","ಯೋಸ್‌ ದನ್ಮ ಯೇಸು ಘರ್‌ಥೊ ನಿಕ್ಳಿನ್, ದರ‍್ಯಾವ್‍ನ ಕನಾರೆಕನ ಜೈ಼ನ್‌, ಬೇಶಿಗಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","ಘಣು ಅದ್ಮಿ ಇನಾಕನ ಎಕ್ಟುಹುಯಿನ್ ಆಯೂತೆ ಇನಖ್ಹಾಜೆ ಯೇಸು ಡೋಣ್‌ಮ ಚ಼ಢೀನ್‌, ಬೇಶಿಗಯೊ ಯೋ ಅದ್ಮಿಖ್ಹಾರು ಕನಾರಿಕನ ಭೀಯೂಥು. ");
INSERT INTO vaa_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","ತದೆ ಯೇಸುನೆ ಇವ್ಣುನ ಮತ್ಲಬ್‌ನಿ ಖೇಣಿಯೇಥಿ ಕೈಏಕ್ ವಾತೆನಿ ಬಾರೇಮ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","“ಖೇತರ್‌ ಕರಾವಾಳೊ ಏಕ್‍ಜ಼ಣೊ ಪಂಡಾ ಛಿಡ್ಕಾನಖ್ಹಾಜೆ ಗಯೊ. ಯೋ ಪಂಡಾ ಛಿಡ್ಕಾನಿ ವಖ್ಹತ್‌ಮ, ಥೋಡ ಪಂಡಾ ವಾಟ್ನಿ ಪಾಕ್ತಿಮ ಪಡ್ಯು ಜಿನಾವರ್‌ ಖ್ಹಾರು ಆಯಿನ್ ಇನ ಚ಼ರಿಲಿದು. ");
INSERT INTO vaa_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","ಅಜು಼ ಥೋಡ ಪಂಡಾ ಜಾ಼ಖ್ಹತ್ ಮಾಟಿಕೊಂತೆ ಬಂಡಾನಿ ಜ಼ಮೀನ್‌ಪರ್ ಪಡ್ಯು; ಹಿಜ಼್ಜಾ ಛಿವರ್‌ ಮಾಟಿ ಥೀತೆ ಇನಖ್ಹಾಜೆ ಯೋ ಒಗ್ಗಿಸ್‌ಮ ಫುಟಿ ಆಯು. ");
INSERT INTO vaa_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","ಕತೋಬಿ ತಡ್ಕೊ ಪಡಾದೀನ್‌, ಯೋ ಶೊಶಿಯೆ ಮಹಿತೋಡಿ ಜ಼ಡೆ ಕೋ ಮ್ಹೇಲಿರಾಖ್ಯುಥುಂತೆ ಇನಖ್ಹಾಜೆ ಖ್ಹುಕೈಗಯು. ");
INSERT INTO vaa_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","ಅಜು಼ ಥೋಡ ಪಂಡಾ ಕಾಟಾನ ಡಾಗ್‌ಮ ಪಡ್ಯು, ಕಾಟಾನು ಝಿಕ್ರುಖ್ಹಾರು ಮೋಟುಹುಯಿನ್, ಯೋ ಶೊಶಿಯೇನ ದಾಬಿನಾಖ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","ಕತೋಬಿ ಅಜು಼ ಥೋಡ ಪಂಡಾ ಅಛ್ಛಿ ಜ಼ಮೀನ್‌ಪರ್‌ ಪಡೀನ್, ಫುಟೀನ್, ಪಂಡು ಮ್ಹೇಲ್ಯು; ಥೋಡು ಖ್ಹೋ ಪಂಡಾಎತ್ರು, ಥೋಡು ತೀನಿಖ್ಹ್‌ ಪಂಡಾಎತ್ರು, ಥೋಡು ಡೋಡಿಖ್ಹ್‌ ಪಂಡಾಎತ್ರು” ಮ್ಹೇಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","“ಖ್ಹಮ್‌ಜಾ಼ನ ಕಾನ್‌ರ‍್ಹವಾಳು ಖ್ಹಮ್‌ಜಾ಼ದೆ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","ಬಾದ್ಮ ಯೇಸುನ ಶಿಷ್ಯರ್‌ ಇನಾಕನ ಆಯಿನ್, “ತೂ ಅದ್ಮಿನ ಜೋ಼ಡೆ ವಾತೆಬೋಲಾನಿ ವಖ್ಹತ್‌ಮ ಮತ್ಲಬ್‌ನಿ ಖೇಣಿಯೇಥಿ ಶನಬೋಲಾಸ್ತೆ?” ಕರಿ ಪುಛಾ಼ಯ. ");
INSERT INTO vaa_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","ಯೇಸುನೆ ಇವ್ಣುನ, “ಸೊರ್ಗ ರಾಜ್ಯನಿ ಬಾರೇಮಾನಿ ಖ್ಹಾಚಿನ ಮಾಲುಮ್‌ ಕರಿಲ್ಯವಾನು ಕಿಮ್ ಕರಿ ಬೋಲಾನು ತುಮೂನ ದೆವೈರ‍್ಹೂಸ್‌, ಪಣ್ಕಿ ಇವ್ಣ ಕಾಹೆ. ");
INSERT INTO vaa_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","ಶನಕತೊ ಕಿನಾಕನ ಛಾ಼ಕಿ ಇವ್ಣುನ ಬಿಜೂ಼ಬಿ ಜಾ಼ಖ್ಹತ್ ದೆವಾವ್‌ಶೆ; ಕತೋಬಿ ಕಿನಾಕನ ಕೊಯ್ನಿಕಿ ಇನಾಕಂಥು ಛಾ಼ತೆ ಥೋಡುಬಿ ಕಾಡಿಲಿಶೆ. ");
INSERT INTO vaa_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","ಮೇ ಇವ್ಣ ಜೋ಼ಡೆ ಮತ್ಲಬ್‌ನಿ ಖೇಣಿಯೇಥಿ ವಾತೆ ಬೋಲುಸ್ತೆ ಶನಖ್ಹಾಜೆ ಕತೊ, ಇವ್ಣುನ ಡೋಳಾ ರ‍್ಹಯುತೋಬಿ ದೇಖಾಕೊಯ್ನಿ ಅಜು಼ ಕಾನ್‌ ರ‍್ಹಯುತೋಬಿ ಖ್ಹಮ್‌ಜಾ಼ಕೊಯ್ನಿ ಅಜು಼ ಪರ್ಖಾ ಕೊಯ್ನಿ. ");
INSERT INTO vaa_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","ಅಮ್ ಯೆಶಾಯನೆ ಬೋಲ್ಯೋತೆ ಪ್ರವಾದ್‌ನೆ ಇವ್ಣಾಮ ಚಾ಼ಲಸ್. ಯೋ ಶಾತ್‌ಕತೊ ಆ ಅದ್ಮಿಖ್ಹಾರು ಖ್ಹಮ್‌ಜ಼್‌ಶೆ ಅಜು಼ ಖ್ಹಮಜ಼್‌ತೂಸ್‌ ರ‍್ಹಿಶೆ, ಕತೋಬಿ ಇವ್ಣುನ ಮಾಲುಮ್‌ ಕೋ ಪಡ್‌ಶೇನಿ; ಇವ್ಣೆ ದೇಕ್‌ಶೆ ಅಜು಼ ದೇಕ್‌ತೂಸ್‌ ರ‍್ಹಿಶೆ, ಕತೋಬಿ ಇವ್ಣುನ ದೆಖಾವ್‌ಶೆ ಕೊಯ್ನಿ; ");
INSERT INTO vaa_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","ಆ ಅದ್ಮಿ ಖ್ಹಾರಾನೊ ದಿಲ್‌ ಬಂಡೊ ಹುಯಿರ‍್ಹೋಸ್, ಅಜು಼ ಅವ್ಣ ಡೋಳಾ ಮೂಚೈ಼ರ‍್ಹಾಸ್, ಅವ್ಣೆ ಡೋಳಾಥಿ ದೇಖಿನ್‌, ಕಾನ್‍ಥಿ ಖ್ಹಮ್‌ಜಿನ್‌, ದಿಲ್‌ಥಿ ಪರ್ಖಿನ್, ಮಾರಭಣಿ ಫರಿಜೈ಼ನ್‌ ಮಾರೇಥಿ ಅಛ್ಛು಼ ನಾಹೊಣುಕರಿ ತೀರ್ಮಾನ್‌ ಕರಿರಾಖ್ಯುಸ್‌ಕರಿ ಬೋಲಾನುಸ್‌ ಯೋ ಪ್ರವಾದ್‌ನೆ. ");
INSERT INTO vaa_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","ಇನಖ್ಹಾಜೆ ತುಮೆ ಧನ್ಯರ್ ಹುಯಿರ‍್ಹಾಸ್. ಶನಕತೊ ತುಮಾರ ಡೋಳಾ ದೆಖಾವಸ್ ಅಜು಼ ತುಮಾರೊ ಕಾನ್‌ ಖ್ಹಮ್‌ಜಾ಼ಸ್‌. ");
INSERT INTO vaa_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","ಮೇ ತುಮೂನ ಖ್ಹಾಚಮಾಬಿ ಬೋಲುಸ್ಕಿ, ತುಮೆ ದೇಖುಕರಾತೆ ಕಾಮ್‍ಅಖ್ಖಾನ ಕೈಯೆಕ್ಕಿ ಪ್ರವಾದಿ ಖ್ಹಾರುಬಿ ಅಜು಼ ಕೈಯೆಕ್ಕಿ ನೀತಿವಾಳು ಅದ್ಮಿಖ್ಹಾರು ದೇಕ್ಣುಕರಿ ಆಖ್ಹ್‌ಕರ‍್ಯು ತೋಬಿ ಇವ್ಣೆ ದೇಖಾನ ಕೋ ಹುಯುನಿ. ತುಮೆ ಖ್ಹಮ್‌ಜು಼ಕರಾತೆ ಸಮಾಚಾರ‍್ನ ಇವ್ಣೆ ಖ್ಹಮಜ಼್‌ಣು ಕರಿ ಆಖ್ಹ್‌ ಕರ‍್ಯುತೋಬಿ ಖ್ಹಮ್‌ಜ್ಯು ಕೊಯ್ನಿ. ");
INSERT INTO vaa_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“ಪಂಡಾ ಛಿಡ್ಕಾವಾಳನಿ ಬಾರೇಮಾನು ಮತ್ಲಬ್‌ ಖ್ಹಮ್‌ಜೊ಼. ");
INSERT INTO vaa_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","ಪರ್‌ಲೋಕ್ ರಾಜ್ಯನಿ ಖಬರ್‌ನ ಖ್ಹಮ್‌ಜಿನ್‌, ಪರ್ಖಿ ನಾಲಿದುತೊ, ಶೈತಾನ್‍ ಆಯಿನ್, ಯೋ ಅದ್ಮಿನ ಮನ್‌ಮ ಪಡ್ಯುತೆ ಇನ ಕಾಡಿನಾಖಸ್‌, ಆ ಅದ್ಮಿಸ್‌ ಪಂಡಾ ಪಡ್ಯುತೆ ವಾಟ್ನಿ ಶೇಡೆನು ಝ಼ಗೊ ಹುಯಿರ‍್ಹುಸ್‍. ");
INSERT INTO vaa_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","ಏಕ್‌ ಜ಼ಣೊ ವಚನ್ನ ಖ್ಹಮಜ಼್‌ತಾಸ್‌, ಖ್ಹುಶಿಥಿ ಇನ ಮಾನಿಲೇಸ್; ಕತೋಬಿ ಜ಼ಡ್‌ಕೊಂತೆ ಇನಖ್ಹಾಜೆ ಯೋ ಖಲಿ ಥೋಡುಸ್ ದನ್ ರ‍್ಹೇಸ್ ");
INSERT INTO vaa_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","ಶನಕತೊ ಇನ ಜ಼ಡ್‌ಕೊಂತೆ ಇನಖ್ಹಾಜೆ ಯೋ ಥೋಡಹಗಾಮ್‍ ಖಲಿರ‍್ಹೀನ್ ಯೊ ವಚನ್ನಖ್ಹಾಜೆ ಖ್ಹತಾಪ್ಣಿ ರ‍್ಹವೊ ಲತಾಡ ರ‍್ಹವೊ ಆಯೂತೊ ಒಗ್ಗಿಸ್ ಠೊಕ್‍ರೈ ಪಡಿಜಾ಼ಸ್‌. ಆಸ್ ಪಂಡಾ ಪಡ್ಯುತೆ ಬಂಡಾನಿ ಜ಼ಮೀನ್ ಹುಯಿರ‍್ಹುಸ್‍. ");
INSERT INTO vaa_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","ಏಕ್‌ ಜ಼ಣೊ ವಚನ್ನ ಖ್ಹಮ್‌ಜುತೋಬಿ, ಆ ಜಗತ್ನಿ ಪಶ್ತಾವ್ಣಿ ಅಜು಼ ಧನ್‌-ದೌಲತ್‌ಪರ್‌ನಿ ಪ್ಯಾರ್ ಯೋ ವಚನ್ನ ದಾಬಿನಾಖಸ್‌, ಇನಖ್ಹಾಜೆ ಯೋ ಫಲ್ ಕೋದೇಯ್ನಿ. ಆಸ್ ಕಾಟಾನ ಝಿಕ್ರಾನು ಝ಼ಗೋಪರ್ ಪಡ್ಯಾತೆ ಪಂಡು ಹುಯಿರ‍್ಹುಸ್‍. ");
INSERT INTO vaa_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","ಏಕ್‌ ಜ಼ಣೊ ವಚನ್ನ ಖ್ಹಮ್‌ಜಿನ್‌, ಇನ ಪರ್ಖಿಲಿನ್‌, ಯೋ ಖ್ಹೋಯೆತ್ರು, ಅಜು಼ ತೀನೀಖ್ಹ್‌ಎತ್ರು, ಬಿಜು಼ ಥೋಡು ಡೋಡಿಖ್ಹ್‌ಎತ್ರು ಫಲ್‍ದೇಸ್. ಯೋಸ್‌ ಅಛ್ಛಿ ಝ಼ಗೊಮ ಪಡ್ಯುತೆ ಪಂಡು ಹುಯಿರ‍್ಹೋಸ್ ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","ಯೇಸುನೆ ಬಿಜ್ಜೇಕ್‌ ಮತ್ಲಬ್‌ನಿ ಖೇಣಿನ ಇವ್ಣುನ ಬೋಲ್ಯೊ: ಯೋ ಶಾತ್‌ಕತೊ, “ಸೊರ್ಗನಿ ರಾಜ್ಯ ಅಛ಼್ಛ ದಾಣಾನ ಖೇತರ್‌ಮ ನಾಖ್ಯೋತೆ ಏಕ್‌ ಅದ್ಮಿನಿಪರಕ್ ಘೋಣಿ ಛಾ಼. ");
INSERT INTO vaa_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","ಕತೋಬಿ ಏಕ್‌ ರಾತೆ ಅದ್ಮಿಖ್ಹಾರು ಖ್ಹುತುರ‍್ಹವಾನಿ ವಖ್ಹತ್‌ಮ, ಯೋ ಅದ್ಮಿನು ದುಶ್‌ಮನ್‌ ಐನ್, ಘವ್‌ನ ಮಹಿ ಶತ್ತೇನ ಛಿಡ್ಕಿನ್‌ ಚ಼ಲೆಗಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","ಘಾವ್ ಫುಟಿನ್‌ ಬುಟ್ಟಾ ನಿಕ್ಳಾದಿನ್‌, ಇನಜೋ಼ಡೆ ಶತ್ತೇಬಿ ಫುಟಿ ಆಯು. ");
INSERT INTO vaa_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","ತದೆ ಯೋ ಅದ್ಮಿನು ಆಳ್‌ಖ್ಹಾರು ಇನಾಕನ ಆಯಿನ್, “ಯಜಮಾನ್, ತುನೆ ತಾರ ಖೇತರ್‌ಮ ಅಛ಼್ಛ ದಾಣಾವ್‍ನ ನಾಖ್ಯೋಥೋನಿ; ಶತ್ತೇ ಕಿಜ್ಗಾ಼ಥು ಆಯು?” ಕರಿ ಫುಛಾ಼ಯು. ");
INSERT INTO vaa_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","ಯೊ ಯಜಮಾನ್ನೆ, “ಆ ಏಕ್‌ ದುಶ್‌ಮನ್ನೆ ಕರ‍್ಯೊತೆ ಕಾಮ್” ಕರಿ ಬೋಲ್ಯೊ. ತದೆ ಆಳ್‌ನೆ, “ಹಮೆ ಜೈ಼ನ್‌, ಶತ್ತೇನ ಉಖ್ಡಿನಾಖೇಕಿ ಶು?” ಕರಿ ಫುಛಾ಼ಯು. ");
INSERT INTO vaa_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","ತದೆ ಇನೆ, “ನಕೊ, ಶನಕತೊ ಶತ್ತೇ ಉಖ್ಡಾನಿ ವಖ್ಹತ್‌ಮ, ತುಮೆ ಘವ್‌ನಾಬಿ ಉಖ್ಡಿನಾಕ್‍ಶು. ");
INSERT INTO vaa_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","ಇನಖ್ಹಾಜೇಸ್ ಖ್ಹುಗ್ಗೀನು ದನ್ ಆವಾತೋಡಿ ಭೇಬಿ ಜೋ಼ಡ್ಮಾಸ್ ಫುಟಾದೆ. ಖ್ಹುಗ್ಗೀನ ದನ್ಮ ಮೇ ವ್ಹಾಡವಾಳನ, ‘ಪಹಿಲೆ ಶತ್ತೇನ ಉಖ್ಡಿನಾಖಿನ್‌, ಇನ ಭಾರೊ ಭಾಂದಿ ಬಾಳಿನಾಖೊ, ಅಜು಼ ಘವ್‌ನ ಎಕ್ಟು ಕರೀನ್, ಮಾರಿ ಕಣ್ಗಿಮ ಭರೊ’ ಕರಿ ಬೋಲಿಶ್” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","ಯೇಸುನೆ ಬಿಜೇಕ್ ಮತ್ಲಬ್‌ನ ಇವ್ಣುನ ಬೋಲ್ಯೊ: ಯೋ ಶಾತ್‌ಕತೊ, “ಸೊರ್ಗನು ರಾಜ್ಯ ಅಮ್ ಹುಯಿರ‍್ಹೂಸ್. ಕಿಮ್‌ಕತೊ, ಏಕ್‌ ಜ಼ಣಾನೆ ರಾಯಿನ ದಾಣಾನ ಲೀಜೈ಼ನ್, ಇನ ಖೇತರ್‌ಮ ಛಿಡ್‌ಕ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","ಯೋ ರಾಯಿನೊ ದಾಣೊ ಖ್ಹಾರಾಸ್ ಬಿಂಜೋ಼ಳಾಥೀಬಿ ನ್ಹಾನು ಹುಯಿರ‍್ಹುಸ್‍, ತೋಬಿ ಯೋ ಫುಟಾನ ಬಾದ್ಮ ಖ್ಹಾರಸ್ ಭಾಜಿಪಾಲಾನ ಝಾ಼ಡ್‌ಥೀಬಿ ಮೋಟು ಹುಯಿನ್, ಝಾ಼ಡು ಹುವ್ವಾಸ್‌, ತದೆ ಆಬ್‍ಪರ್‌ ಉಡಾತೆ ಜಿನಾವರ್‌ ಖ್ಹಾರು ಆಯಿನ್, ಇನಿ ಡಾಳಿಯೇಮ ಮ್ಹಾಳೊ ಭಾಂದಿನ್‍ ವಖ್ಹಸ್‌” ಕರಿಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","ಯೇಸುನೆ ಅಜೂ಼ಬಿ ಏಕ್‌ ಮತ್ಲಬ್‌ನಿ ಖೇಣಿನ ಬೋಲ್ಯೊ: ಯೋ ಶಾತ್‌ಕತೊ, “ಸೊರ್ಗನು ರಾಜ್ಯ ಅಮ್ ಹುಯಿರ‍್ಹುಸ್‍. ಕಿಮ್‌ಕತೊ, ಏಕ್‌ ತಯೇಡಾನೆ ಶೋಡಾನ ಲೀಜೈ಼ನ್, ತೀನ್ ಶೇರ್ ಆಟಾಮ ಕಲೈನ್ ಮ್ಹೇಲಾಖ್ಹತರ್‌, ಯೋ ಆಟೊ ಖ್ಹಾರುಸ್‌ ಫುಗಿಆಯು. ");
INSERT INTO vaa_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","ಯೇಸುನೆ ಆ ವಾತೆಖ್ಹಾರು ಅದ್ಮಿನಿ ಭೀಡ್‌ಣ ಮತ್ಲಬ್‌ನಿ ಖೇಣಿಯೇಥೀಸ್‌ ಬೋಲ್ಯೊ; ಮತ್ಲಬ್‌ನಿ ಖೇಣಿ ಕೊಂತೆ ಶಾತ್ಬಿ ಕೋ ಬೋಲ್ಯೋನಿ. ");
INSERT INTO vaa_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","ಅಮ್ಮಸ್, “ಮೇ ಬೋಲಾನಿ ವಖ್ಹತ್‌ಮ ಮತ್ಲಬ್‌ನಿ ಖೇಣಿಯೇಥಿ ಬೋಲಿಶ್; ಜಗತ್‌ ಉಬ್‌ಜ್ಯುತೆ ತಪ್‌ಥು ಲಪೈರ‍್ಹುಥೂತೆ ಬಾರೇಮ ಮೇ ಇವ್ಣುನ ಬೋಲಿಶ್” ಕರಿ ಪ್ರವಾದಿನ ಮ್ಹೋಡೆ ಬೋಲಾಯೋತೆ ವಾತೇನ ಯೇಸುನೆ ಅಮ್ ಕರ‍್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","ಯೇಸು ಅದ್ಮಿನ ಮ್ಹೆಂದಿನ್, ಘರೆ ಜಾ಼ವಾನ ಬಾದ್ಮ, ಇನ ಶಿಷ್ಯರ್‌ ಇನಾಕನ ಆಯಿನ್, “ಖೇತರ್‌ಮಾನು ಶತ್ತೇನಿ ಬಾರೇಮಾನು ಮತ್ಲಬ್‌ನ ಹಮೂನ ಬೋಲಿವತಾಳ್” ಕರಿ ಬೋಲ್ಯ. ");
INSERT INTO vaa_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","ಯೇಸುನೆ, “ಅಛ್ಛು಼ ಪಂಡು ನಾಖವಾಳೊ ಕತೊ ಅದ್ಮಿನೊ ಛಿಯ್ಯೊ; ");
INSERT INTO vaa_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","ಖೇತರ್‌ಕತೊ ಆ ಜಗತ್‌; ಅಛ್ಛು಼ ಪಂಡುಕತೊ ದೇವ್ನಿ ರಾಜ್ಯನು ಅದ್ಮಿಖ್ಹಾರು; ಶತ್ತೆಕತೊ ಶೈತಾನ್‍ ಭಣಿವಾಳು ಕರಿ; ");
INSERT INTO vaa_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","ಶತ್ತೇ ನಾಖ್ಯೋತೆ ದುಶ್‌ಮನ್‌ಕತೊ ಶೈತಾನ್ ಕರಿ. ಖ್ಹುಗ್ಗೀನ ದನ್‌ಕತೊ ಜಗತ್‌ನು ಖ್ಹರ್ತಿನ ದನ್‌ಕರಿ ಅಜು಼ ವ್ಹಾಡವಾಳುಕತೊ ದೇವ್ನು ದೂತರ್ ಕರಿ. ");
INSERT INTO vaa_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","ಕಿಮ್ ಶತ್ತೇನ ಉಖ್ಡಿನ್ ಬಾಳಿನಾಖಸ್ಕಿ, ಇಮ್ಮಸ್ ಜಗತ್‌ನು ಖ್ಹರ್ತಿನ ದನ್ಮ ಚಾ಼ಲ್‌ಷೆ. ");
INSERT INTO vaa_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","ಅದ್ಮಿನೊ ಛಿಯ್ಯೊ ಇನ ದೂತರ್‌ನ ಮೋಕ್ಲಿನ್, ಇವ್ಣೆ ಇನ ರಾಜ್ಯಮ ಕೋಣ್ ಪಾಪ್ ಅಜು಼ ಖರಾಬ್‌ಕರಾನಿತರ ಕರ‍್ಯುಕೀ ಇಮ್ನ ಅದ್ಮಿಖ್ಹಾರನ ಎಕ್ಟು ಕರೀನ್‌, ");
INSERT INTO vaa_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","ಅಜು಼ ಇನಿ ರಾಜ್ಯಮಾಥು ಭಾರ್‌ ಕಾಡಿನ್ ಆಗ್‌ನ ಕುಂಡಾಮ ನಾಕ್‌ಶೆ. ಹಿಜ್ಜಾ಼ ಇವ್ಣೆ ರೊವ್‌ಶೆ ಅಜು಼ ಕರ್‌-ಕರ್‌ ದಾತ್‍ಚಾ಼ವ್‍ಶೆ ");
INSERT INTO vaa_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","ತದೆ ನೀತಿವಾಳು ಅದ್ಮಿಖ್ಹಾರು ಚಾ಼ಂದ್‍ನಿಘೋಣಿ ಚ಼ಮಕ್‌ತುಹುಯಿನ್ ಇವ್ಣ ಬಾನಿ ರಾಜ್ಯಮ ರ‍್ಹಿಶೆ. ಖ್ಹಮ್‌ಜಾ಼ನ ಕಾನ್‌ ರ‍್ಹವಾಳು ಖ್ಹಮ್‌ಜಾ಼ದೆ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“ಸೊರ್ಗನು ರಾಜ್ಯ ಅಮ್ ಹುಯಿರ‍್ಹೂಸ್. ಕಿಮ್‌ಕತೊ, ಏಕ್‌ ಜ಼ಣಾನೆ ಖೇತರ್‌ಮ ಲಪಿರ‍್ಹೂತೆ ನಿಧಿನ ದೇಖಿನ್‌, ಇನ ಪಾಛು಼ ಖೇತರ್‌ಮಾಸ್‌ ಖೋಂದಿ ಘಾಲಿದೀನ್‌, ಇನೇಥಿ ಘಣು ಖ್ಹುಶಿಹುಯಿನ್ ಜೈ಼ನ್‌, ಇನಾಕನ ಥೂತೆ ಖ್ಹಾರುಸ್‌ ವೇಚಿನಾಖಿದೀನ್‌, ಆಯಿನ್ ಯೋ ಖೇತರ್‌ನ ಮೋಲ್‌ಲೀಲಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“ಸೊರ್ಗನು ರಾಜ್ಯ ಅಮ್ ಹುಯಿರ‍್ಹೂಸ್. ಕಿಮ್‌ಕತೊ, ಅಛ಼್ಛು ಮುತ್‌ಅಖ್ಖಾನ ಢೂಂಡಾಸ್ತೆ ಏಕ್‌ ಧಂದೊ ಕರಾವಾಳೊ, ");
INSERT INTO vaa_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","ಘಣ ಮೋಲ್ನು ಏಕ್‌ ಮುತ್ನ ದೇಖಿನ್‌, ಹಿಜ್ಜಾ಼ಥೊ ಜೈ಼ನ್‌, ಇನಾಕನ ಥೂತೆ ಖ್ಹಾರುಸ್‌ ವೇಚಿನ್, ಯೋ ಮುತ್ನ ಮೋಲ್‌ಲೀಲಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“ಸೊರ್ಗಾನು ರಾಜ್ಯ ಅಮ್ ಹುಯಿರ‍್ಹೂಸ್. ಕಿಮ್‌ಕತೊ, ಥೋಡು ಜ಼ಣು ಮಾಛ್ಲು಼ ಧರಾವಾಳಾನೆ ಜಾ಼ಳಾನ ದರ‍್ಯಾವ್‌ಮ ನಾಖ್ಯು, ತದೆ ಖ್ಹಾರಿಸ್ ರಖ್ಹಮ್‌ನು ಮಾಛ್ಲು಼ ಇನಾಮ ಖ್ಹಪ್‌ಡ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","ಜಾ಼ಳು ಭರಾವಾನ ಬಾದ್‌ಮ, ಇನ ಕನಾರೆ ಖೇಚಿಲೈನ್‌, ಬೇಶಿನ್, ಅಛ಼್ಛ ಮಾಛ್ಲಾ಼ವ್ನ ಟೋಕ್ರಾವ್‍ಮ ಭರಿಲೀನ್‌, ಖರಾಬ್ ಮಾಛ್ಲಾ಼ವ್ನ ಫೇಕಿನಾಖಿದಿದು. ");
INSERT INTO vaa_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","ಅಮ್ಮಸ್ ಜಗತ್ನ ಖ್ಹರ್ತಿಮ ಚಾ಼ಲ್‌ಷೆ. ದೇವ್‌ನು ದೂತರ್ ಆಯಿನ್, ಧರ್ಮಿ ಅದ್ಮಿಯೇನ ಮಹಿಥು ಖರಾಬ್ ಅದ್ಮಿಯೇನ ಅಲಕ್ ಕರೀನ್, ");
INSERT INTO vaa_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","ಇವ್ಣುನ ಆಗ್‌ನ ಕುಂಡಾಮ. ಹಿಜ್ಜಾ಼ ಇವ್ಣೆ ರೊವ್‌ಶೆ ಅಜು಼ ಕರ್‌-ಕರ್‌ ದಾತ್‍ಚಾ಼ವ್‍ಶೆ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","ಯೇಸುನೆ ಇನ ಶಿಷ್ಯರ್‌ನ, “ಆ ಖ್ಹಾರಿ ವಾತೆನಿ ಮತ್‌ಲಬ್ ತುಮೂನ ಮಾಲುಮ್‌ಪಡ್ಯುಕಿ ಶು?” ಕರಿ ಪುಛಾ಼ಯೊ. ಇವ್ಣೆ, “ಓಹೊ” ಕರಿ ಜವಾಬ್‌ ದಿದಾ. ");
INSERT INTO vaa_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","ತದೆ ಯೇಸುನೆ ಇನ ಶಿಷ್ಯರ್‌ನ, “ಅಮ್‌ಕತೊ, ಸೊರ್ಗ ರಾಜ್ಯನು ಶಿಷ್ಯರ್‌ ಬಣ್ಯೂತೆ ಹರೇಕ್ ಮೋಶೆನಿ ವಚನ್‍ ಶಿಕಾಡವಾಳು ಶಾಸ್ತ್ರಿಯೆ, ಘರ್‌ನೊ ಯಜಮಾನ್ನಿಘೋಣಿ ಹುಯಿರ‍್ಹೂಸ್, ಯೋ ಯಜಮಾನ್ ಇನ ಘರ್‌ನಿ ಕಣ್ಗಿಮ ಜ಼ಮ ಕರಿರಾಖ್ಯೋತೆ ನವು ಅಜು಼ ಜೂ಼ನ ರಾಛಾ಼ನಖ್ಹಾರು ಭಾರ್‌ ಕಾಡಸ್‌” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","ಯೇಸು ಆ ಮತ್ಲಬ್‌ನಿ ಖೇಣಿಯೇನ ಬೋಲಾನ ಬಾದ್‌ಮ, ಹಿಜ್ಜಾ಼ಥೊ ನಿಕ್ಳಿನ್, ");
INSERT INTO vaa_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","ಇನ ಶೊಂತ್‌ ಗಾಮೆ ಗಯೊ. ಹಿಜ್ಜಾ಼ ಯೇಸು ಯೆಹೂದ್ಯರ್‌ನ ಸಬೆ ಭರಾವಾನು ಮಂದಿರ್‌ಮ ಅದ್ಮಿನ ಬೋಲಿವತಾಳ್ಯೊ, ತದೆ ಅದ್ಮಿಖ್ಹಾರು ಇನ ಖ್ಹಮ್‌ಜಿನ್‌, ಆಶ್ಚರ್ಯಖೈನ್, “ಅನ ಅಮ್ನಿ ಗ್ಯಾನ್ ಅಜು಼ ಅಮ್ನು ಅದ್ಭುತ್‌ಕಾಮ್‌ಖ್ಹಾರು ಕರಾನು ಕಿಜ್ಜಾ಼ಥು ಮಳ್ಯು? ");
INSERT INTO vaa_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","ಆ ಯೋ ಖೋಡ್‌ಶಾನು ಖ್ಹಾಮನ್‌ ಕರಾವಾಳಾನೊ ಛಿಯ್ಯೊ ಕಾಹೆಕಿ ಶು? ಅನಿಆಯ ಮರಿಯ ಕಾಹೆಕಿ ಶು? ಯಾಕೋಬ, ಯೋಸೇಫ, ಸೀಮೋನ್‌ ಅಜು಼ ಯೂದ ಅನ ಭೈಯೇ ಕಾಹೆಕಿ ಶು? ");
INSERT INTO vaa_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","ಅನಿ ಭೇನೆ ಖ್ಹಾರಿ ಹಜ್ಜಾ಼ಸ್ ರ‍್ಹೇಸ್‌ನಿ? ಇಮ್‍ಕತೊ, ಆ ಖ್ಹಾರು ಅನ ಕಿಜ್ಜಾ಼ಥು ಮಳ್ಯು?” ಕರಿ ವಾತೆ ಬೋಲಿಲಿದು. ಅಜು಼ ಯೇಸುನ ಝಿಟ್ಕಾರವಾಳು ಹುಯು. ");
INSERT INTO vaa_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","ತದೆ ಯೇಸುನೆ ಇವ್ಣುನ, “ಪ್ರವಾದಿನ ಅಲ್ಹಾವ್ ಅದ್ಮಿ ಮರ್ಯಾದಿ ದೇಸ್, ಕತೋಬಿ ಶೊಂತ್‌ ಗಾಮ್‌ನು ಅದ್ಮಿನರ‍್ಹವೊ, ಶೊಂತ್‌ ಘರ್‌ನು ಅದ್ಮಿನರ‍್ಹವೊ ಮರ್ಯಾದಿ ಕೋ ದೇಯ್ನಿ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","ಇವ್ಣೆ ಇನ ನಂಬ್ಯುಕೊಂತೆ ಇನಖ್ಹಾಜೆ, ಯೇಸುನೆ ಹಿಜ್ಜಾ಼ ಘಣು ಅದ್ಭುತ್‌ಕಾಮ್ನ ಕೋ ಕರ‍್ಯೋನಿ. ");
INSERT INTO vaa_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","ಯೋ ದನೂಮ, ಹೆರೋದ ಗಲಿಲಾಯಮ ರಾಜ಼್‌ಭಾರ್‌ ಚ಼ಲಾವ್‍ ಕರ್ತೊಥೊ, ಅದ್ಮಿಖ್ಹಾರು ಯೇಸುನಿ ಬಾರೇಮ ಬೋಲುಕರ್ತುಥೂತೆ ಇನೆ ಖ್ಹಮ್‌ಜೊ. ");
INSERT INTO vaa_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","ಇನಖ್ಹಾಜೆ ಇನೆ ಇನ ಸೇವಕರ್‌ನ, “ಖ್ಹಾಚಮಾಬಿ ಯೇಸುಸ್‌ ಬ್ಯಾಪ್ತಿಸ್ಮದ್ಯವಾಳೊ ಯೋಹಾನ ಹುಯಿರ್‍ಹೊಸ್, ಯೋಸ್‍ ಪಾಛೊ಼ ಜಿವ್ತೊಹುಯಿನ್ ಐರ‍್ಹೋಸ್. ಇನಖ್ಹಾಜೇಸ್ ಆ ಖ್ಹಾರು ಅದ್ಭುತ್ ಕರಾನ ಶಕತ್ ಮಳಿರ‍್ಹೀಸ್ತೆ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","ಹೆರೋದನೆ ಹೆರೋದ್ಯನಖ್ಹಾಜೆ ಯೋಹಾನ್ನ ಧರೈನ್, ಭಂದೈನ್, ಜೇಲ್‌ಮ ಕೋಂಡಿ ಘಲಾಯೋಥೊ. ಆ ಹೆರೋದ್ಯ ಹೆರೋದನೊ ಮೋಟೊ ಭೈ ಫಿಲಿಪ್ಫನಿ ಬಾವಣ್‍ ಹುಯಿರ‍್ಹೀಥಿ. ");
INSERT INTO vaa_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","ಯೋಹಾನ ಹೆರೋದಾನ, “ತೂ ಹೆರೋದ್ಯನ ರಾಖಿರಾಖ್ಯೋತೆ ನ್ಯಾವ್‌ಕಾಹೆ” ಕರಿ ಬೋಲ್ತೊರ‍್ಹೇತೋಥೊ. ");
INSERT INTO vaa_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","ಹೆರೋದ ಯೋಹಾನ್ನ ಮರೈನಾಕ್ಣು ಕರಿ ಥೊ, ತೋಬಿ ಅದ್ಮಿಖ್ಹಾರು ಯೋಹಾನ ಏಕ್‌ ಪ್ರವಾದಿ ಕರಿ ಮಾನ್‌ತುಥೂತೆ ಇನಖ್ಹಾಜೆ, ಅದ್ಮಿನ ಡರ್‌ಥಿ ಇನ ಮರಾಯೊ ಕೊಯ್ನಿ. ");
INSERT INTO vaa_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","ಹೆರೋದನೊ ಪೈದಾಖ್ಹ್‌ನೊ ದನ್ಮ, ಹೆರೋದ್ಯನಿ ಛೋ಼ರಿ ಹೆರೋದ ಅಜು಼ ಇನ ಮೆಹೆಮಾನ್ನ ಖ್ಹಾಮ್ಣೆ ನಾಚಿನ್ ವತಾಳಿ. ಅನೇಥಿ ಹೆರೋದನ ಘಣು ಖ್ಹುಶಿ ಹುಯು. ");
INSERT INTO vaa_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","ಇನಖ್ಹಾಜೆ ಇನೆ, “ತೂ ಶಾತ್ ಬೋಲಿಲಿದಿತೋಬಿ, ಮೇ ತುನ ದೆವುಸ್‌” ಕರಿ ಯೋ ಛೋ಼ಕ್ರಿನ ವಾಗ್ದಾನ್‌ದಿದೊ ");
INSERT INTO vaa_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","ತದೆ ಇನಿ ಆಯ ಶಾತ್‌ ಮಾಂಗಿಲೆವ್ಣು ಕರಿ ಇನ ಬೋಲಿದಿದಿ. ತದೆ ಇನೆ, “ಹಮ್ಕೆ, ಹಜ್ಜಾ಼ಸ್ ಬ್ಯಾಪ್ತಿಸ್ಮದ್ಯವಾಳೊ ಯೋಹಾನನು ಮುಡ್‌ಕ್ಯು ಪತ್ತರ್‌ಮ ಮಂಗೈನ್, ಮನ ದೇವ್ಣು” ಕರಿ ಬೋಲಿ. ");
INSERT INTO vaa_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","ಯೋ ವಾತೇಥಿ ರಾಜಾ಼ನ ದುಖ್ ಹುಯು, ತೋಬಿ ಇನೆ ಇನ ಮೆಹಮಾನ್ ಅಖ್ಖಾನ ಖ್ಹಾಮ್ಣೆ ಆಣ್ ದಿದೋತೆ ಇನಖ್ಹಾಜೆ, ಇನೆ ಮಾಂಗಿತೆ ಇನ ದೇವ್ಣುಕರಿ ಹುಕುಮ್‌ ದಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","ಅಜು಼ ಆಳ್‌ನ ಮೋಕ್ಲಿನ್, ಜೇಲ್‌ಮ ಕೋಂಡಿ ಘಾಲಿರಾಖ್ಯುತೆ ಹಿಜ್ಜಾ಼ ಯೋಹಾನನು ಮುಡ್‌ಕ್ಯು ಕತ್ರಾಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","ಇವ್ಣೆ ಯೋಹಾನ್ನ ಮುಡ್‌ಕ್ಯಾನ ಪತ್ತರ್‌ಮ ಲೈನ್‌, ಯೋ ಛೋ಼ಕ್ರಿನ ದಿದು. ಇನೆ ಯೋ ಮುಡ್‌ಕ್ಯಾನ ಇನಿ ಆಯಕನ ಲೀಗೈ. ");
INSERT INTO vaa_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","ಯೋಹಾನನು ಶಿಷ್ಯರ್‌ ಆಯಿನ್, ಇನು ಧಡ್‌ನ ಪಳ್ಳಿಜೈ಼ನ್‌, ಘವಿಮ ಘಾಲ್ಯು. ಅನಕೇಡೆಥು ಇವ್ಣೆ ಯೇಸುಕನ ಜೈ಼ನ್‌, ಚಾ಼ಲ್ಯುತೆ ಬಾರೇಮ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","ಯೇಸುನೆ ಯೋಹಾನ್ನಿ ಬಾರೇಮಾನು ಖಬರ್‌ನ ಖ್ಹಮ್‌ಜಿನ್‌, ಯೋ ಝ಼ಗೋನ ಮ್ಹೆಂದಿನ್, ಡೋಣ್‌ ಚ಼ಢೀನ್‌, ಎಕ್ಕಸ್ ಜ಼ಣೊ ಉಜ್ಜಾ಼ಡಿ ಝ಼ಗೋನ ಚ಼ಲೆಗಯೊ. ಅನ ಖ್ಹಮ್‌ಜಿನ್‌ ಅದ್ಮಿಖ್ಹಾರು, ಇವ್ಣ-ಇವ್ಣ ಗಾಮ್‌ನ ಮ್ಹೆಂದಿನ್, ಗೋಡೇಥೀಸ್‌ ಚಾ಼ಲಿನ್ ಯೇಸುನ ಪೀಠೆಗಯು. ");
INSERT INTO vaa_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","ಯೇಸು ಡೋಣ್‌ಮಾಥು ಭಾರ್‌ ಆಯಿನ್, ಅದ್ಮಿನಿ ಘಣಿ ಮೋಟಿ ಭೀಡ್‌ಣ ದೇಖಿನ್‌, ಇವ್ಣಾಪರ್ ಗೋರ್‌ಖೈನ್, ರೋಗ್‌ಮ ರ‍್ಹವಾಳಾನ ಖ್ಹಾರು ಅಛ್ಛು಼ ಕರ‍್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","ಖ್ಹಾಂಜ಼್ ಹುವ್ವಾದೀನ್, ಇನ ಶಿಷ್ಯರ್‌ ಇನಾಕನ ಐನ್, “ಆ ಉಜ್ಜಾ಼ಡಿ ಝ಼ಗೊ, ಅಜು಼ ವಖ್ಹತ್‍ಬಿ ಘಣಿ ಹುಯಿಗೈ. ಆ ಅದ್ಮಿಖ್ಹಾರು ಇವ್ಣಖ್ಹಾಜೆ ಖಾಣನು ರಾಛು಼ ಲ್ಯವಾನಟೇಕೆ, ಇವ್ಣುನ ಗಾಮೆ ಬೋಲಿಮೋಕಲ್‌” ಕರಿ ಬೋಲ್ಯ. ");
INSERT INTO vaa_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","ಯೇಸುನೆ ಇವ್ಣುನ, “ಅದ್ಮಿಖ್ಹಾರು ಜಾ಼ವಾನು ನಕೊ, ತುಮೇಸ್ ಇವ್ಣುನ ಖಾವಾನ ಶಾತ್‌ತೋಬಿ ದೆವೊ!” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","ತದೆ ಶಿಷ್ಯರ್‌ನೆ, “ಹಜ್ಜಾ಼ ಹಮಾರಕನ ಪಾಚ಼್ ರೋಟಾ ಅಜು಼ ಬೇ ಮಾಛ಼್‌ಲಾ ಎತ್ರುಸ್ ಛಾ಼ತೆ” ಕರಿ ಜವಾಬ್‌ ದಿದಾ. ");
INSERT INTO vaa_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","ತದೆ ಯೇಸುನೆ, “ಇನ ಹಜ್ಜಾ಼ ಮಾರಕನ ಲೀನ್, ಆವೊ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","ಅಜು಼ ಅದ್ಮಿ ಖ್ಹಾರಾನ ಘಾಖ್ಹ್‌ಪರ್‌ ಬೇಖ್ಹೊ ಕರಿ ಬೋಲಿನ್, ಯೋ ಪಾಚ಼್ ರೋಟಾ ಅಜು಼ ಬೇ ಮಾಛ಼್‌ಲಾನ ಪಾಡಿಲೀನ್, ಆಬ್‍ಭಣಿ ದೇಖಿನ್‌, ದೇವ್ನ ಧನ್ಯವಾದ್ ಕರೀನ್, ಯೋ ರೋಟಾವ್ನ ತೋಡಿನ್, ಶಿಷ್ಯರ್‌ನ ಹಾತ್‌ಮ ದಿದೊ. ಶಿಷ್ಯರ್‌ನೆ ಅದ್ಮಿನಿ ಝೂ಼ಂಡ್‌ನ ದಿದಾ. ");
INSERT INTO vaa_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","ತಮಾಮ್‌ ಅದ್ಮಿ ಖೈನ್ ಬಶ್‌ಹುಯು. ಉಬ್‍ರ‍್ಯುತೆ ಟುಕ್ಡಾವ್‍ನ ಜ಼ಮಾಕರ್ತಖ್ಹತರ್‌ ಭಾರ ಟೋಕ್ರಾ ಭರಾಯು. ");
INSERT INTO vaa_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","ಖಾಣು ಖಾದೂತೆ ಇವ್ಣಾಮ ತಯೇಡ ಅಜು಼ ಲಡ್ಕಾವ್ನ ಮ್ಹೆಂದಿನ್, ಪರ್ಖ್ಹಾ ಅದ್ಮಿಸ್‌ ಕಮ್‌ಶಿಕಮ್ ಪಾಚ಼್ ಹಜಾ಼ರ್‌ಜ಼ಣು ಥೂ. ");
INSERT INTO vaa_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","ಅನಕೇಡೆಥು ಯೇಸುನೆ ಇನ ಶಿಷ್ಯರ್‌ನ, “ಮೇ ಆ ಅದ್ಮಿನಿ ಭೀಡ್‌ಣ ಮೋಕ್ಲಾನ ಮಹಿ, ತುಮೆ ಡೋಣ್‌ ಚ಼ಢೀನ್, ಪಹಿಲೆ ಪಾರ್ಲಿ ಕನಾರೆ ಜಾ಼ವೊ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","ಅದ್ಮಿನಿ ಭೀಡ್‌ಣ ಮೋಕ್ಲಾನ ಬಾದ್‌ಮ, ಪ್ರಾರ್ಥನೆ ಕರಾನಖ್ಹಾಜೆ ಯೋ ಎಕ್ಲೋಸ್ ಪಹಾಡ್‌ಪರ್ ಗಯೊ. ದನ್ ಡುಬಾನ ಬಾದ್‌ಮ, ಯೇಸು ಎಕ್ಲೋಸ್ ಹಿಜ್ಜಾ಼ ಥೊ. ");
INSERT INTO vaa_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","ಎತ್ರಾಸ್‌ಮ ಡೋಣ್‌ ಜ಼ಮೀನ್‌ಥಿ ಘಣಿ ದೂರ್ ಜೈ಼ರ‍್ಹೀಥಿ, ಅಜು಼ ಖ್ಹಾಮ್ಣೆನೊ ವಹಿರೊ ವಾಗುಕರ್ತೊಥೋತೆ ಇನಖ್ಹಾಜೆ, ಡೋಣ್‌ ದರ‍್ಯಾವ್‌ನ ಇಚ಼್‌ಮ ಜ್ಹೋಕಾಳ್ಯನ ಮಾರ್‌ಮ ಖ್ಹಪ್‌ಡಿರ‍್ಹೀಥಿ. ");
INSERT INTO vaa_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","ವ್ಹಾಣ್‌ಖ್ಹತ್ರೆ ಚಾರ್‌ ಘಂಟಾ ಹುಯಿರ‍್ಹುಥು, ತದೆ ಯೇಸು ದರ‍್ಯಾವ್‌ಪರ್ ಚಾ಼ಲ್ತೊಹುಯಿನ್‌ ಶಿಷ್ಯರ್‌ ಭಣಿ ಆಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","ದರ‍್ಯಾವ್‌ಪರ್ ಚಾ಼ಲ್ತೊವಳ್ಯಾವಾತೆ ಯೇಸುನ ಶಿಷ್ಯರ್‌ನೆ ದೇಖಿನ್‌, ಘಬ್‌ರೈಗಯ. ಅಜು಼ ಭೂತ್‌ಕರಿ ಸೋಚಿನ್, ಡರ್‌ಥಿ ಚಿಕ್‌ರ‍್ಯ. ");
INSERT INTO vaa_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","ತದ್‌ನು-ತದ್ದೇಸ್ ಯೇಸುನೆ ವಾತೆ ಬೋಲಿನ್ ಇವ್ಣುನ, “ಹಿಮ್ಮತ್‌ ರ‍್ಹವಾದೆ; ಆ ಮೇಸ್! ಡರೊ ನಕೊ!” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","ತದೆ ಪೇತ್ರನೆ, “ಪ್ರಭು, ಆ ತೂಸ್ ಉಶೇತೊ, ಮನ ಪಾಣಿಪರ್‌ ಚಾ಼ಲಿನ್ ತಾರಕನ ಆವಾನ ಹುಕುಮ್ ದೇ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","ಯೇಸುನೆ ಇನ, “ಆವ್!” ಕರಿ ಜ಼ವಾಬ್‌ದಿದೊ. ತದೆ ಪೇತ್ರ ಯೇಸುಕನ ಜಾ಼ವಾನಖ್ಹಾಜೆ ಡೋಣ್‌ಮಾಥು ಉತ್ರಿನ್, ಪಾಣಿಪರ್‌ ಚಾ಼ಲಲಗ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","ಕತೋಬಿ ವ್ಹಯಿರಾನ ರಪಾಟಾನ ದೇಖಿನ್‌ ಡರಿನ್, ಪಾಣಿಮ ಡುಬಾಲಗ್ಯೊ ಅಜು಼ “ಪ್ರಭು, ಮನ ಬಚಾ಼ಡ್‍!” ಕರಿ ಚಿಕ್‌ರ‍್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","ಯೋಸ್ ವಖ್ಹತ್‌ಮ ಯೇಸು ಹಾತ್‌ ಖ್ಹಾಮ್ಣೆ ಕರೀನ್, ಇನ ಧರೀನ್, “ಏ ಕಮ್‍ವಿಶ್ವಾಸ್‍ವಾಳ! ತೂ ಶನ ಶಕ್ ಕರ‍್ಯೊ?” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","ಇವ್ಣೆ ಡೋಣ್‌ಮ ಚ಼ಢಾನ ಬಾದ್‌ಮ, ವಹಿರೊ ಭೀರಿಗಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","ತದೆ ಡೋಣ್‌ಮ ಥಾತೆ ಶಿಷ್ಯರ್‌ನೆ, “ಖ್ಹಾಚ಼ಮಾಬಿ ತೂ ದೇವ್‌ನೊ ಛಿಯ್ಯೊ” ಕರಿ ಬೋಲಿನ್, ಯೇಸುನ ಆರಾದನೆ ಕರ‍್ಯಾ. ");
INSERT INTO vaa_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","ಇವ್ಣೆ ದರ‍್ಯಾವ್‍ನ ಮ್ಹೇಲಿನ್, ಗೆನೆಜರೇತ್‍ ಝ಼ಗೋನಿ ಕನಾರೆಕನ ಆಯಾ. ");
INSERT INTO vaa_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","ಯೋ ಝ಼ಗೊವಾಳು ಯೇಸುನಿ ಖ್ಹಣೇದ್ ಧರೀನ್, ಇವ್ಣೆ ಯೋ ಅಶ್‌ಪಿಶ್‌ನು ತಬರ್‌ಖಾಮ ಖ್ಹಾರು ಬೋಲಿಮೋಕ್ಲಿನ್, ರೋಗ್‌ಮ ರ‍್ಹವಾಳ ತಮಾಮ್‌ನ ಯೇಸುಕನ ಬುಲೈ ಮಂಗಾಯು. ");
INSERT INTO vaa_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","ಇವ್ಣೆ ಯೇಸುನ, “ಆ ರೋಗ್‌ಮ ರ‍್ಹವಾಳಾನ ತಾರು ಲುಂಗ್ಡಾನು ಕೋಣೊತೋಬಿ ಛೀಮಾನ ಮ್ಹೇಲ್‌” ಕರಿ ಗಿಂಗೈಲಿದು. ಅಜು಼ ಇನು ಲುಂಗ್ಡು ಛೀಮ್ಯೂತೆ ಹರೇಕ್ನ ಅಛ್ಛು಼ ಹುಯು. ");
INSERT INTO vaa_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","ಬಾದ್‌ಮ ಯೆರೂಸಲೇಮ್‌ಥು ಫರಿಸಾಯರ್ ಅಜು಼ ಮೋಶೆನಿ ವಚನ್ನ ಶಿಕಾಡವಾಳು ಶಾಸ್ತ್ರಿಯೆ ಯೇಸುಕನ ಆಯಿನ್, ");
INSERT INTO vaa_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“ತಾರು ಶಿಷ್ಯರ್‌ ಅಪ್ಣ ಶಾಣವ್‌ಥಿ ಆಯೂತೆ ಆದತ್‌ನ ಶನ ಪಾಡಿನ್ ಚಾ಼ಲಕೊಯ್ನಿ? ಇವ್ಣೆ ಹಾತ್‌ ಧೊವಾಕೊಂತೆ ಖಾಣು ಖಾಸ್ನಿ” ಕರಿ ಪುಛಾ಼ಯು. ");
INSERT INTO vaa_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","ಯೇಸುನೆ ಇವ್ಣುನ, “ತುಮೆ ತುಮಾರಿ ಆದತ್‌ನ ಪಾಡಿ ಚಾ಼ಲಾನಖ್ಹಾಜೆ ದೇವ್ನಿ ಹುಕುಮ್‌ನ ಶನ ತೋಡೊಸ್ತೆ? ");
INSERT INTO vaa_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","ಕಿಮ್‌ಕತೊ, ‘ಆಯ-ಬಾನ ಮರ್ಯಾದಿ ದೇವ್ಣು, ಆಯನ ರ‍್ಹವೊ, ಬಾನ ರ‍್ಹವೊ ಶಾಪ್ನ-ಶಬರ್‌ ದೆವಾಳಾನ ಮರಣ್ ದಂಡ್‌ ಹೋಣು’ ಕರಿ ದೇವ್ನೆ ಬೋಲಿರಾಖ್ಯೊಸ್. ");
INSERT INTO vaa_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","ಕತೋಬಿ ತುಮೆತೋ, ಕೋಣ್‌ತೋಬಿ ಇನ ಬಾನ ರ‍್ಹವೊ, ಆಯಾನ ರ‍್ಹವೊ ದೇಖಿನ್‌, ‘ಮೇ ತಾರಿ ಖ್ಹದ್ದರ್‌ನಖ್ಹಾಜೆ ದೇವ್ಣುಥೂತೆ ಇನ ದೇವ್ನಖ್ಹಾಜೆ ಮುಡಪ್‍ ಕರ‍ಖ್ಯೊಸ್’ ಕರಿ ಬೋಲ್ಯೋತೊ, ");
INSERT INTO vaa_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","ಯೋ ಇನ ಆಯ-ಬಾನ ಮರ್ಯಾದಿ ದೆವಾನು ಜ಼ರೂರತ್ ಕೊಯ್ನಿ ಕರಿ ಬೋಲಿದೆವೋಸ್‌. ಅಮ್ ಕರಾಥಿ ತುಮಾರಿ ಆದತ್‍ಥೀಸ್‍ ದೇವ್ನಿ ಹುಕುಮ್‌ನ ಫಾಯಿದೊಕೊಂತೆ ಇಮ್‌ ಕರಿರಾಖ್ಯಾಸ್. ");
INSERT INTO vaa_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","ತುಮೆ ಖೋಟ್ ದಿಲ್‌ವಾಳ! ಯೆಶಾಯನೆ ತುಮಾರಿ ಬಾರೇಮ ಬರೊಬರ್‌ಥೀಸ್‌ ಪ್ರವಾದ್‌ನೆ ಕರಿರಾಖ್ಯೋಸ್! ಯೋ ಶಾತ್‌ಕತೊ: ದೇವ್ನೆ ಬೋಲ್ಯೋಕಿ, ");
INSERT INTO vaa_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘ಆ ಅದ್ಮಿಖ್ಹಾರು ವಾತೇಥಿ ಮನ ಮರ್ಯಾದಿ ದೇಸ್, ಕತೋಬಿ ಅವ್ಣೊ ದಿಲ್‌ ಮಾರೇಥಿ ದೂರ್ ಛಾ಼. ");
INSERT INTO vaa_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","ಅದ್ಮಿನ ಖ್ಹೂಜ಼್‌ನಿತರ ಶಿಕಾಡ್ತು ಆಯೂತೆ ಇನಾಸ್ ದೇವ್ನಿ ಹುಕುಮ್‌ನಿಘೋಣಿ ಬೋಲಿಶಿಕಾಡವಾಳ ಅವ್ಣೆ ಮನ ಆರಾದನೆ ಕರಾನು ಕಾಮ್ನಕೊಯ್ನಿ. ");
INSERT INTO vaa_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","ಅನಕೇಡೆಥು ಯೇಸುನೆ ಅದ್ಮಿನಿ ಝೂಂಡ್‌ನ ಖನ್ನೆ ಬುಲೈನ್ ಇವ್ಣುನ, ಕಾನ್‌ ದೀನ್, “ಖ್ಹಮ್‌ಜೊ಼, ಅಜು಼ ಮಾಲುಮ್‌ ಕರಿಲೆವೊ! ");
INSERT INTO vaa_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","ಬಾಕನ ಮಹಿಜಾ಼ಸ್ತೆ ಯೋ ಅದ್ಮಿನ ಮೈಲುಕರಾಕೊಯ್ನಿ, ಮ್ಹೋಡಾನ ಮಹಿಥು ಭಾರ್ ನಿಕ್ಳಾಸ್ತೆ ಯೋಸ್‌ ಅದ್ಮಿನ ಮೈಲುಬಣಾವಸ್‌” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","ತದೆ ಶಿಷ್ಯರ್‌ ಯೇಸುಕನ ಆಯಿನ್, “ತುನೆ ಬೋಲ್ಯೋತೆ ವಾತೇನ ಖ್ಹಮ್‌ಜಿನ್‌, ಫರಿಸಾಯರ್‌ವಾಳು ಇರಾದೊ ಕರ‍್ಯುತೆ ತುನ ಮಾಲುಮ್‌ಪಡ್ಯು ಕಿಶು?” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","ಯೇಸುನೆ, “ಪರಲೋಕ್‍ಮ ಛಾ಼ತೆ ಮಾರೊ ಬಾ ಗಾಡ್ಯೊಕೊಂತೆ ಝಾ಼ಡಖ್ಹಾರನ ಜ಼ಡ್‌ ಖ್ಹಮೇಥು ಉಖ್ಡಿ ನಾಕ್‌ಶೆ” ಕರಿ ಜವಾಬ್‌ ದಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","“ಇವ್ಣಿ ಬಾರೇಮ ಫಿಕರ್ ನಕೊ ಕರೊ! ಇವ್ಣೆ ಕಾಣು ಹುಯಿರ‍್ಹುಸ್‍, ಬಿಜಾ಼ನ ವಾಟ್‌ ವತಾಳನ ಜಾ಼ಸ್‌, ಕಾಣೊ ಕಾಣಾನ ವಾಟ್‌ ವತಾಳ್ಯೊತೊ ಇವ್ಣೆ ಭೇ ಜ಼ಣು ಖಾಡ್‌ಮ ಪಡಾಸ್‌” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","ತದೆ ಪೇತ್ರನೆ, “ಆ ಮತ್ಲಬ್‌ನಿ ಖೇಣಿನ ಹಮೂನ ಬೋಲಿವತಾಳ್” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","ಯೇಸುನೆ ಇವ್ಣುನ, ಬಿಜಾ಼ನಿ ಘೋಣಿ ತುಮೂನಾಬಿ ಬುದ್ಧಿ ಕೊಯ್ನಿಕಿ ಶು? ");
INSERT INTO vaa_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","ಮ್ಹೋಡಾಮ ಜಾ಼ಸ್ತೆ ಖ್ಹಾರುಸ್‌, ಪೇಟ್‌ಮ ಜೈ಼ನ್‌, ಇನಕೇಡೆಥು ಭಾರ್‌ಮ ನಿಕ್ಳಿಜಾ಼ಸ್ ಕರಿ ಬೋಲಾನು ತುಮೂನ ಮಾಲುಮ್‌ ಕೋ ಪಡ್ಯುನಿಕಿ ಶು? ");
INSERT INTO vaa_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","ಕತೋಬಿ ಮ್ಹೋಡಾಮಾಥು ನಿಕ್ಳಾಸ್ತೆ ವಾತೆ ಇನ ದಿಲ್‌ಮಾಥು ಆವಸ್, ಆಸ್ ಅದ್ಮಿನ ಅಶುದ್ಧ ಬಣಾವಸ್ತೆ. ");
INSERT INTO vaa_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","ಕಿಮ್‌ಕತೊ, ದಿಲ್‌ಮಾಥು ಖರಾಬ್‌ಸೋಚ಼್‌, ಖೂನ್‌ಕರಾನು, ವ್ಯಬಿಚಾರ್‌, ಅಜು಼ ಪಾಪೇಲುಕಾಮ್‍, ಚೋ಼ರಿಕರಾನು, ಅಜು಼ ಗಾಳೆಅಖ್ಖು ಭಾರ್‌ ನಿಕ್ಳಾಸ್‌. ");
INSERT INTO vaa_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","ಅಮ್ನುಸ್‌ಖ್ಹಾರು ಅದ್ಮಿನ ಮೈಲುಬಣಾವಾಸ್ತೆ. ಕತೋಬಿ ಇವ್ಣೆ ಬೋಲಾತೆ ಇಮ್‌ ಹಾತ್‌ ಧೊವಾಕೊಂತೆ ಖಾಣು ಖವಾನು ಅದ್ಮಿನ ಅಶುದ್ಧ ಕೋಬಣಾವಾನಿ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","ಯೇಸು ಯೋ ಝ಼ಗೋನ ಮ್ಹೆಂದಿನ್, ತೂರ್ ಅಜು಼ ಸೀದೋನ್ ಖ್ಹಯೇರ‍್ನ ಖನ್ನೇನು ತಬರ್‌ಖಾನ ಚ಼ಲೆಗಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","ಯೋ ಮುಲಕ್‌ಮ ರ‍್ಹೇತಿಥೀತೆ ಕಾನಾನ್‌ವಾಳಿ ಏಕ್‌ ತಯೇಡ ಇನಾಕನ ಆಯಿನ್, “ದಾವೀದ್‌ನ ಛಿಯ್ಯಾ! ಪ್ರಭು, ಮಾರಪರ್ ಗೋರ್‌ ಕರ್‌! ಮಾರಿ ಛೋ಼ರಿಮ ಭೂತ್ ಛಾ಼ ಅಜು಼ ಘಣಿ ಖರಾಬ್ ಹಾಲ್‌ಮ ಯೋ ಛಾ಼” ಕರಿ ಚಿಕ್ರಿನ್ ಬೋಲಿ. ");
INSERT INTO vaa_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","ಕತೋಬಿ ಯೇಸುನೆ ಇನ ಶನೀಶ್ ಜವಾಬ್‌ ಕೋ ದಿದೋನಿ, ತದೆ ಇನ ಶಿಷ್ಯರ್‌ನೆ ಯೇಸುಕನ ಆಯಿನ್, “ಯೋ ತಯೇಡಾನ ಮೋಕ್ಲಿದೆ! ಯೋ ಚಿಕರ್ತಿ ಹುಯಿನ್ ಅಪ್ಣ ಪೀಠೇಸ್ ವಳಿಆವಸ್‌!” ಕರಿ ಗಿಂಗಾಯು. ");
INSERT INTO vaa_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","ತದೆ ಯೇಸುನೆ ಫರೈನ್ ಬೋಲ್ಯೋಕಿ, “ಗುಮೈಗಯೂತೆ ಮೇಂಢವ್‌ನಿ ಘೋಣಿ ಛಾ಼ತೆ ಇಸ್ರಾಯೇಲ್‌ನು ಅದ್ಮಿನ ಮ್ಹೆಂದಿನ್ ಬಿಜ಼ ಕಿನಾಕನಾಬಿ ದೇವ್ನೆ ಮನ ಮೋಕ್‌ಲ್ಯೊಕೊಯ್ನಿ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","ತದೆ ಯೋ ತಯೇಡ ಯೋಸ್‌ ಆಯಿನ್, ಇನ ಆಡ್‍ಪಡಿನ್, ಪ್ರಭು ಮನ ಮದತ್‌ಕರ್‌!” ಕರಿ ಗಿಂಗೈ. ");
INSERT INTO vaa_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","ಯೇಸುನೆ ಇನ, “ಲಡ್ಕಾ ಖಾವಾನು ರೋಟಾವ್ನ ಪಾಡೀನ್, ಕುತ್‌ರ‍್ಯಾವ್‍ನ ನಾಖಾನು ಬರೋಬರ್‌ಕೊಯ್ನಿ” ಕರಿ ಜವಾಬ್‌ ದಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","ಯೋ ತಯೇಡಾನೆ, “ಯೋ ವಾತೆ ಖ್ಹಾಚಾಸ್‌ಲಾ ಪ್ರಭು, ಕುತ್‌ರ‍್ಯು ಖ್ಹಾರು ಇವ್ಣೊ ಯಜಮಾನ್ನು ಮೇಜ್‌ಪರ್‌ಥು ಹೇಟ್ ಪಡಾಸ್ತೆ ರೋಟಾನು ಟುಕ್ಡಾವ್‍ನ ಖಾಸ್ನಿ” ಕರಿ ಬೋಲಿ. ");
INSERT INTO vaa_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","ತದೆ ಯೇಸುನೆ ಇನ, “ಬಾಯಿ, ತಾರಿ ವಿಶ್ವಾಸ್ ಘಣಿ ಮೋಟಿ! ತಾರ ಮನ್‌ಮ ಛಾ಼ತೆ ಇಮ್ಮಸ್ ತುನ ಹುವಾದೆ” ಕರಿ ಜವಾಬ್‌ ದಿದೊ. ಯೋಸ್ ವಖ್ಹತ್‌ಮ ಇನಿ ಛೋ಼ರಿನ ಅಛ಼್ಛುಹುಯು. ");
INSERT INTO vaa_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","ಯೇಸು ಹಿಜ್ಜಾ಼ಥೊ ನಿಕ್ಳಿನ್, ಗಲಿಲಾಯ ದರ‍್ಯಾವ್‌ಕನ ಆಯಿನ್, ಪಹಾಡ್‌ಪರ್ ಚ಼ಢೀನ್ ಬೇಶಿಗಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","ತದೆ ಅದ್ಮಿಖ್ಹಾರು ಝೂ಼ಂಡ್‌-ಝೂ಼ಂಡ್‌ ಹುಯಿನ್, ಇನಾಕನ ಆಯು, ಇವ್ಣೆ ಲಂಗ್ಡು, ಕಾಣು, ಮುಕ್ಕು, ಹಾತ್‌-ಗೋಡಕೊಂತೆ ಅಜು಼ ಕೈಯೆಕ್ಕಿ ಬಿಜಿ ತರ‍್ಹಾನು ರೋಗ್‌-ರಾಯಮ ರ‍್ಹವಾಳ ಅದ್ಮಿನ ಯೇಸುನ ಗೋಡಾಕನ ಲಯಿನ್ ಮ್ಹೇಲ್ಯು. ಯೇಸುನೆ ಇವ್ಣುನ ಅಛ್ಛು಼ ಕರ‍್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","ಮುಕ್ಕುರ‍್ಹಾವಾಳು ವಾತೆ ಬೋಲ್ಯೂತೆ, ಹಾತ್‌ಗೋಡಾಕೊಂತೆ ಅದ್ಮಿಖ್ಹಾರು ಅಛ್ಛು಼ ಹುಯೂತೆ, ಲಂಗ್ಡುಖ್ಹಾರು ಚಾ಼ಲ್ಯುತೆ, ಕಾಣಾವ್ನ ಡೋಳಾ ಆಯೂತೆ, ಅದ್ಮಿಖ್ಹಾರು ದೇಖಿನ್‌ ಆಶ್ಚರ್ಯಖಾದು ಅಜು಼ ಇಸ್ರಾಯೇಲ್‌ನೊ ದೇವ್ನ ಸ್ತುತಿ ಕರ‍್ಯು. ");
INSERT INTO vaa_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","ಯೇಸುನೆ ಇನ ಶಿಷ್ಯರ್‌ನ ಖನ್ನೆ ಬುಲೈನ್, ಇವ್ಣುನ, “ಆ ಖ್ಹಾರ ಅದ್ಮಿನ ದೇಖಿನ್‌, ಮನ ಗೋರ್‌ಲಾಗಸ್‌, ಅವ್ಣೆ ಮಾರಕನ ಆಯಿನ್, ತೀನ್ ದನ್ ಹುಯಿಗಾ; ಇವ್ಣುನ ಖಾಣನ ಶಾತ್ಬಿ ಕೊಯ್ನಿ; ಅವ್ಣುನ ಭುಕ್ಯುಸ್‌ ಮೋಕ್ಲಾನ ಮನ ಮನ್‌ಕೊಯ್ನಿ; ಜಾ಼ವಾನಿ ವಖ್ಹತ್‌ಮ ಅವ್ಣೆ ಥಕಿಜಾ಼ಶೆ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","ಶಿಷ್ಯರ್‌ನೆ ಯೇಸುನ, “ಅತ್ರಾಅದ್ಮಿನ ಬಶ್‌ ಹುವ್ವಾಎತ್ರು ಖಾಣು ಆ ಉಜ್ಜಾ಼ಡಿ ಝ಼ಗೋಮ ಹಮೂನ ಕಿಜ್ಗಾ಼ಥು ಮಳ್‌ಶೆ?” ಕರಿ ಬೋಲ್ಯ. ");
INSERT INTO vaa_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","ಯೇಸುನೆ, “ತುಮಾರಕನ ಕೆತ್ರ ರೋಟಾ ಛಾ಼?” ಕರಿ ಪುಛಾ಼ಯೊ. ಶಿಷ್ಯರ್‌ನೆ, “ಹಮಾರಕನ ಖ್ಹಾತ್ ರೋಟಾ ಅಜು಼ ಥೋಡು ನ್ಹಾನಿಮಾಛ್ಲಿಯೆ ಛಾ಼” ಕರಿ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","ತದೆ ಯೇಸುನೆ ಅದ್ಮಿನಿ ಝೂ಼ಂಡ್‌ನ ಜ಼ಮೀನ್‌ಪರ್ ಬೇಖ್ಹೊ ಕರಿ ಹುಕುಮ್‌ದಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","ಯೋ ಖ್ಹಾತ್ ರೋಟಾ ಅಜು಼ ಯೋ ಮಾಛ಼್‌ಲಾವ್ನ ಪಾಡಿನ್, ದೇವ್ನ ಧನ್ಯವಾದ್ ಕರೀನ್, ಇನ ತೋಡಿನ್, ಶಿಷ್ಯರ್‌ನ ಹಾತ್‌ಮ ದಿದೊ. ಶಿಷ್ಯರ್‌ನೆ ಅದ್ಮಿನಿ ಝೂ಼ಂಡ್‌ನ ವಾಟಪಾಡಿ ದಿದಾ. ");
INSERT INTO vaa_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","ಅದ್ಮಿಖ್ಹಾರು ಖೈನ್, ಹಕ್ಲಾಲ್‌ಹುಯು. ಉಭ್‌ರ‍್ಯುತೆ ಟುಕ್ಡಾವ್‌ನ ಜ಼ಮಾಕರ್ತಖ್ಹತರ್ ಖ್ಹಾತ್ ಟೋಕ್ರಾ ಭರಾಯು. ");
INSERT INTO vaa_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","ಖಾಣು ಖಾದೂತೆ ಇವ್ಣಾಮ ತಯೇಡ ಅಜು಼ ಲಡ್ಕಾವ್‍ನ ಮ್ಹೆಂದಿನ್, ಪರ್ಖ್ಹಾ ಅದ್ಮಿಸ್‌ ಚಾರ್ ಹಜಾ಼ರ್‌ ಜ಼ಣು ಥೂ. ");
INSERT INTO vaa_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","ಅನಕೇಡೆಥು ಯೇಸುನೆ ಯೋ ಅದ್ಮಿನಿ ಝೂ಼ಂಡ್‌ನ ಮೋಕ್ಲಿದೀನ್, ಡೋಣ್‌ಪರ್‌ ಚ಼ಢೀನ್, ಮಗದಾನ್ ತಬರ್‌ಖಾನ ಗಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","ಫರಿಸಾಯರ್ ಅಜು಼ ಸದ್ದುಕಾಯವಾಳು ಯೇಸುನ ಖ್ಹಪ್‌ಡಾವ್ಣು ಕರಿ ಇನಾಕನ ಐನ್, ತೂ ಆಬ್‍ಥೊ ಆಯೊಹುಯೊ ಕರಿ ವತಾಳನಖ್ಹಾಜೆ ಹಮೂನ ಏಕ್‌ ಅದ್ಭುತ್ ಕರಿನ್ ವತಾಳ್ ಕರಿ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","ತದೆ ಯೇಸುನೆ ಇವ್ಣುನ, “ಖ್ಹಾಂಜ಼್‌ನಿ ವಖ್ಹತ್‌ಮ ತುಮೆ ಆಬ್‍ ಲಾಲ್‍ಹುಯಿರ‍್ಹೋತೊ, ‘ಅಪ್ಣುನ ಅಛ್ಛು಼ ಮೋಸಮ್ ರ‍್ಹಿಶೆ’ ಕರಿ ಬೋಲೋಸ್. ");
INSERT INTO vaa_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","ವ್ಹಾಣಾನು ಆಬ್‍ ವಾದ್‍ಳೇಥಿ ಢಪೈನ್ ಕಾಳೊ ಅಜು಼ ಲಾಲ್ ಹುಯಿರ‍್ಹೋತೊ, ‘ಆಜ಼್ ಪಾಣಿ ವರಖ್ಹ್‌ಶೆ’ ಕರಿ ಬೋಲೋಸ್ ಕಾಹೆಕಿ ಶು? ದನ್ನಿ ಹಾಲ್-ಚಾ಼ಲ್ ದೇಖಿನ್, ಆ ಅಮ್, ಯೋ ಇಮ್‌ ಕರಿ ಖ್ಹಣೇದ್ ಕರಾನ ತುಮೂನ ಮಾಲುಮ್; ಕತೋಬಿ ಆ ವಖ್ಹತ್‌ನಿ ಖ್ಹಣೇದ್‍ನಿ ಮತ್‌ಲಬ್ ತುಮೂನ ಮಾಲುಮ್ ಕೊಯ್ನಿಕಿಶು? ");
INSERT INTO vaa_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","ಖರಾಬ್ ಅಜು಼ ಪಾಪಿ ಹುಯಿರ‍್ಹೂತೆ ಆ ಪಿಳ್ಗೀನು ಅದ್ಮಿ ಏಕ್‌ ಅದ್ಭುತಾನ ದೇಕ್ಣು ಕರಿ ಆಖ್ಹ್ ಕರಾಸ್! ಯೋನನ ಚಾ಼ಲ್ಯುತೆ ಅದ್ಭುತ್ ಕಾಮಸ್ ಪಣ್ಕಿ ಬಿಜು಼ ಕೆಹೂಬಿ ಇವ್ಣುನ ಮಳ್‌ಶೆ ಕೊಯ್ನಿ!” ಕರಿ ಜವಾಬ್‌ ದೀನ್, ಇವ್ಣುನ ಮ್ಹೆಂದಿನ್ ಚ಼ಲೆಗಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","ಯೇಸು ಅಜು಼ ಇನ ಶಿಷ್ಯರ್‌ ದರ‍್ಯಾವ್‍ನಿ ಪಾರ್ಲಿ ಬಾಜೂ಼ಮ ಗಯ, ತದೆ ಶಿಷ್ಯರ್‌ನೆ ರೋಟ ಪಳ್ಳಿಜಾ಼ವಾನು ಭೈಕಿಗಯಾಥಾ. ");
INSERT INTO vaa_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","ಯೇಸುನೆ ಇವ್ಣುನ, “ಜ಼ತನ್ ರ‍್ಹವೊ! ಫರಿಸಾಯರ್ ಅಜು಼ ಸದ್ದುಕಾಯವಾಳನು ಶೋಡ ನಾಖ್ಯುಹುಯು ಆಟಾನಿ ಬಾರೇಮ ಜ಼ತನ್‌ಥಿ ರ‍್ಹವೊ ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","ತದೆ ಇವ್ಣೆ, “ಅಪ್ಣೆ ರೋಟಾ ಲಾಯಕೊಂತೆ ಇನಖ್ಹಾಜೆ ಅಮ್ ಬೋಲ್ಯೊಕಿ ಶುಕಿ” ಕರಿ ಇವ್ಣ-ಇವ್ಣಾಮ ಬೋಲಿಲಿದು. ");
INSERT INTO vaa_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","ಯೇಸುನೆ ಇವ್ಣೆ ಬೋಲಿಲೆವ್‍ಕರಾತೆ ಮಾಲುಮ್‌ಕರಿನ್, ಇವ್ಣುನ, “ಕಮ್‍ವಿಶ್ವಾಸ್‍ವಾಳ! ರೋಟಾ ಕೊಯ್ನಿ ಕರಿ ಬೋಲಾನಿ ಬಾರೇಮ ಶನ ವಾತೆ ಬೋಲಿಲೆವ್‍ಕರಾಸ್ತೆ? ");
INSERT INTO vaa_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","ತುಮೂನ ಬಿಜೂ಼ಬಿ ಮಾಲುಮ್ ಕರ‍್ಯಾಕೊಯ್ನಿಕಿ ಶು? ತುಮೂನ ಯಾದ್ ಕೊಯ್ನಿಕಿ ಶು? ಯೋ ಪಾಚ಼್ ರೋಟಾನ ಪಾಚ಼್ ಹಜಾ಼ರ್‌ ಅದ್ಮಿನ ಖಡಾವಾನ ಬಾದ್‌ಮ ಕೆತ್ರ ಟೋಕ್ರಾ ತುಮೆ ಭರ‍್ಯಾಥ? ");
INSERT INTO vaa_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","ಎತ್ರೇಸ್ ಕಾಹೆತೆ ಯೋ ಖ್ಹಾತ್ ರೋಟಾನ ಚಾರ್ ಹಜಾ಼ರ್ ಅದ್ಮಿನ ಖಡಾವಾನ ಬಾದ್‌ಮ ತುಮೆ ಕೆತ್ರ ಟೋಕ್ರಾ ಭರ‍್ಯಾಥ? ");
INSERT INTO vaa_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","ಮೇ ರೋಟಾನಿ ಬಾರೇಮ ವಾತೆ ಬೋಲ್ಯೋತೆ ಕಾಹೆ ಕರಿ ತುಮೂನ ಮಾಲುಮ್ ಪಡ್ಯುಕೊಯ್ನಿತೆ ಕಿಮ್? ಜ಼ತನ್! ಫರಿಸಾಯರ್ ಅಜು಼ ಸದ್ದುಕಾಯವಾಳನು ಶೋಡಾ ಪಡ್ಯುಹುಯು ಆಟಾನಿ ಬಾರೇಮ ಹೊಷಾರ್‌ಥಿ ರ‍್ಹವೊ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","ತದೆ ಇನ ಶಿಷ್ಯರ್‌ನೆ ರೋಟಾಮ ನಾಖಾತೆ ಶೋಡಾನಿ ಬಾರೇಮ ಜ಼ತನ್‌ಥಿ ರ‍್ಹವೊ ಕರಿ ಕಾಹೆ ಯೇಸುನೆ ಅಪ್ಣುನ ಬೋಲ್ಯೊತೆ, ಫರಿಸಾಯರ್ ಅಜು಼ ಸದ್ದುಕಾಯವಾಳು ಬೋಲಿ ಶಿಕಾಡಸ್ತೆ ಇನಿ ಬಾರೇಮ ಜ಼ತನ್‌ಥಿ ರ‍್ಹವೊ ಕರಿ ಇನೆ ಬೋಲ್ಯೊತೆ ಕರಿ ಇವ್ಣೆ ಮಾಲುಮ್ ಕರಿಲಿದು. ");
INSERT INTO vaa_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","ಯೇಸು ಫಿಲಿಪ್ಪನು ಕೈಸರೆಯ ಕರಿ ಖ್ಹಯೇರ‍್ನು ಇಟಾರಮ್ಮ ಗಯೊ. ಹಿಜ್ಜಾ಼ ಇನ ಶಿಷ್ಯರ್‌ನ, “ಅದ್ಮಿನೊ ಛಿಯ್ಯೊ ಹುಯಿರ‍್ಹೋತೆ ಮನ ಅದ್ಮಿಖ್ಹಾರು ಕೋಣ್ ಕರಿ ಬೋಲಾಸ್?” ಕರಿ ಪುಛಾ಼ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","ಇವ್ಣೆ ಇನ, “ಥೋಡು ಜ಼ಣು ತುನ, ‘ಬ್ಯಾಪ್ತಿಸ್ಮದ್ಯವಾಳೊ ಯೋಹಾನ’ ಕರಿ ಬೋಲಾಸ್, ಬಿಜು಼ ಥೋಡು ಜ಼ಣು, ‘ಎಲೀಯ’ ಕರಿ ಬೋಲಾಸ್, ಅಜು಼ ಥೋಡು ಜ಼ಣು, ಯೆರೆಮೀಯ ನತರ್‌ಕಿ ಪ್ರವಾದೀಮ ಏಕ್‌ ಜ಼ಣೊ’ ಕರಿ ಬೋಲಾಸ್” ಕರಿ ಜವಾಬ್‌ ದಿದಾ. ");
INSERT INTO vaa_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","ಯೇಸುನೆ ಇವ್ಣುನ, “ತುಮೆ ಮನ ಕೋಣ್ ಕರಿ ಬೋಲೋಸ್?” ಕರಿ ಪುಛಾ಼ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","ತದೆ ಸೀಮೋನ ಪೇತ್ರನೆ, “ತೂ ಆವ್ಣುತೆ ಕ್ರಿಸ್ತ, ಜಿವ್ತೊ ದೇವ್‌ನೊ ಛಿಯ್ಯೊ” ಕರಿ ಜ಼ವಾಬ್ ದಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","ಯೇಸುನೆ, “ಯೋನಾನೊ ಛಿಯ್ಯೊ ಸೀಮೋನ, ತೂ ಧನ್ಯ ಹುಯಿರ‍್ಹೋಸ್! ಆ ಖ್ಹಾಚ಼ನ ತುನ ಮಾಲುಮ್ ಕರಾಯೂತೆ ಅದ್ಮಿನೆ ಕಾಹೆ, ಪಣ್ಕಿ ಸೊರ್ಗಾಮ ಛಾ಼ತೆ ಮಾರ ಬಾನೇಸ್ ಆ ಖ್ಹೂಜ಼್‌ ಕರಾಯೋತೆ ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","ಅಜು಼ ಮೇ ತುನ ಶಾತ್ ಬೋಲಸ್‍ಕತೊ, ಪೇತ್ರ, ತೂ ಬಂಡೊ, ಅಜು಼ ಆ ಬಂಡಾಪರ್ ಮೇ ಮಾರಿ ಸಬೆನ ಭಾಂದೀಶ್, ಪಾತಾಳ್ನಿ ಶಕತ್‌ಬಿ ಇನ ಕದೇಬಿ ಹರಾವನ ಕೋ ಉಶೇನಿ. ");
INSERT INTO vaa_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","ಸೊರ್ಗಾನು ರಾಜ್ಯನು ಬೀಗಾನ ಖ್ಹಾರು ಮೇ ತುನ ದಿಶ್; ಧರ್ತಿಪರ್ ತೂ ಶಾತ್ ಭಾಂದೀಶ್‌ಕಿ, ಯೋ ಸೊರ್ಗಾಮಾಬಿ ಭಂದಾವ್‌ಶೆ, ಅಜು಼ ಧರ್ತಿಪರ್ ತೂ ಶಾತ್ ಛೋ಼ಡಿಶ್‌ಕಿ, ಯೋ ಸೊರ್ಗಾಮಾಬಿ ಛೋ಼ಡಾವ್‌ಶೆ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","ಅನಕೇಡೆಥು ಯೇಸುನೆ ಇನ ಶಿಷ್ಯರ್‌ನ, “ಮೇಸ್ ಕ್ರಿಸ್ತ ಹುಯಿರ‍್ಹೋಸ್ ಕರಿ ಕಿನಾಬಿ ನಾ ಬೋಲ್‌ನು” ಕರಿ ಝೇತೈನ್‌ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","ತಪ್‌ಥೊ ಯೇಸು, “ಮೇ ಯೆರೂಸಲೇಮ್‌ನ ಜೈ಼ನ್‌, ಹಿಜ್ಜಾ಼ ಶಾಣಾವ್‍ಥೀಬಿ, ಗಲ್‌ಢಯಾಜಕರ್‌ಥಿ, ಅಜು಼ ಮೋಶೆನಿ ವಚನ್ ಶಿಕಾಡವಾಳ ಶಾಸ್ತ್ರಿಯೇಥಿ ಘಣು ಲತಾಡ ಖ್ಹಮಾಳ್‌ಣು ಅಜು಼ ಇವ್ಣೆ ಇನ ಮರ್‌ನಾಕ್‌ಶೆ; ಕತೋಬಿ ತೀನ್ ದನ್‌ಕೇಡೆ ಮೇ ಪಾಛೊ಼ ಜಿವ್ತೊಹುಯಿನ್, ಉಠೀನ್ ಆಯಿಶ್” ಕರಿ ಶಿಷ್ಯರ್‌ನ ಬೋಲಾನ ಶುರು ಕರ‍್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","ತದೆ ಪೇತ್ರನೆ ಯೇಸುನ, ಏಕಾಡಿ ಬುಲೈಲಿಜೈ಼ನ್, ಪ್ರಭು, ದೇವ್ ತೂ ಇಮ್ ನಕೋಸ್ ಬೋಲ್! ತುನ ಇಮ್‌ ನಾಸ್ ಹೋಣು!” ಕರಿ ಬೋಲಿನ್, ಇನ ಜಿದ್‌ಕರ‍್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","ತದೆ ಯೇಸುನೆ ಫರೀನ್, ಪೇತ್ರನ, “ಏ ಶೈತಾನ್, ಮಾರ ಖ್ಹಾಮ್ಣೇಥೊ ಹಟಿಜಾ಼! ತೂ ಮಾರ ಕಾಮ್ನ ಅಡ್ಡಿ ಹುಯಿರ‍್ಹೋಸ್! ತಾರಿ ಆ ಸೋಚ್ ಅದ್ಮಿನಿ ಸೋಚಸ್‌ ಪಣ್ಕಿ ದೇವ್ನಿ ಸೋಚ಼್ ಕಾಹೆ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","ಅನಕೇಡೆಥು ಯೇಸುನೆ ಇನ ಶಿಷ್ಯರ್‌ನ, “ಕಿನಾತೋಬಿ ಮಾರ ಪೀಠೆ ಆವ್ಣುಕರಿ ಮನ್ ಉಶೇತೊ, ಯೋ ಖ್ಹುದ್‌ನ ಭೈಕಿಜೈ಼ನ್, ಇನಿ ಶಿಲ್‌ಬೇನ ಪಾಡಿಲೀನ್, ಮಾರ ಪೀಠೆ ಆವಾದೆ. ");
INSERT INTO vaa_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","ಇನೊ ಜಾನ್ನ ಬಚಾ಼ಡಿಲೇವ್ಣು ಕರಿ ಕರಾವಾಳು ಇನ ಗುಮೈಲಿಶೆ; ಕತೋಬಿ ಮಾರಖ್ಹಾಜೆ ಇನ ಜಾನ್ನ ಗುಮೈಲ್ಯಾವಾಳು ಇನ ಬಚಾ಼ಡಿಲಿಶೆ. ");
INSERT INTO vaa_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","ಏಕ್‌ ಅದ್ಮಿ ಹಿಡಿ ಜಗತ್‍ನಾಸ್ ಕಮೈಲೀನ್, ಇನ ಜಾನ್ನ ಲುಕ್‌ಶಾನ್ ಕರಿಲಿದುತೋ, ಇನ ಶನಿ ಫಾಯಿದೊ? ಶನೀಸ್ ಫಾಯಿದೊ ಕೊಯ್ನಿ! ಯೋ ಅದ್ಮಿ ಬಿಜು಼ ಶಾತ್ಬಿ ದೀನ್ ಇನ ಜಾನ್ನ ಪಾಛು಼ ಬಚಾ಼ಡಿಲ್ಯವಾನ ಕೋ ಹುವಾನಿ! ");
INSERT INTO vaa_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","ಅದ್ಮಿನೊ ಛಿಯ್ಯೊ ಇನ ಬಾನಿ ಮಹಿಮೆಥಿ ಅಜು಼ ಇನ ದೂತರ್‌ನ ಜೋ಼ಡೆ ಆವ್‌ಶೆ; ಯೋ ವಖ್ಹತ್‌ಮ ಏಕೇಕ್‌ನ ಇವ್ಣಿ ಚಾ಼ಲ್‌ನಿಘೋಣಿ ಇನಾಮ್ ದಿಶೆ. ");
INSERT INTO vaa_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","ಮೇ ತುಮೂನ ಖ್ಹಾಚಾಮ ಬೋಲುಸ್ಕಿ, ಹಜ್ಜಾ಼ ಭಿಯುತೆ ಇವ್ಣಾಮ ಥೋಡು ಜ಼ಣು ಅದ್ಮಿನೊ ಛಿಯ್ಯೊ ಇನ ರಾಜ್ಯಮ ಆವ್‌ಶೇತೆ ದೇಖಲಗೂಬಿ ಮರ್‌ಶೆಸ್ ಕೊಯ್ನಿ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","ಛೊ಼ ದನ್ನ ಬಾದ್‌ಮ ಯೇಸುನೆ ಪೇತ್ರ, ಯಾಕೋಬ ಅಜು಼ ಇನೊ ಭೈ ಯೋಹಾನ್ನ ಬುಲೈಲಿನ್, ಏಕ್‌ ಊಚಾ಼ ಪಹಡ್‌ಪರ್ ಗಯೊ. ಹಿಜ್ಜಾ಼ ಇವ್ಣುನ ಮ್ಹೆಂದಿನ್ ಕೋಣ್‌ಬಿ ಕೋ ಥೂನಿ. ");
INSERT INTO vaa_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","ಹಿಜ್ಜಾ಼ ಇವ್ಣ ಡೋಳಾನ ಖ್ಹಾಮ್ಣೇಸ್, ಯೇಸುನು ರೂಪ್ ಬದ್ಲಿಗಯು: ಇನು ಮ್ಹೋಡು ಚಾ಼ಂದ್‍ನಿಘೋಣಿ ಝ಼ಮ್‌ಕಾಲಗ್ಯು ಅಜು಼ ಇನ ಲುಂಗ್ಡ ಉಜಾ಼ಳಾನಿಘೋಣಿ ಧೋಳುಫಟ್ ಹುಯಿಗಯು. ");
INSERT INTO vaa_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","ಎತ್ರೇಸ್ ಕಾಹೆತೆ ಮೋಶೇಬಿ, ಎಲೀಯ ಯೇಸುನ ಜೋ಼ಡೆ ವಾತೆ ಬೋಲುಕರಾತೆ ಯೋ ತೀನ್ ಶಿಷ್ಯರ್‌ನೆ ದೇಖ್ಯ. ");
INSERT INTO vaa_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","ತದೆ ಪೇತ್ರನೆ ಯೇಸುನ, “ಪ್ರಭು, ಹಮೆ ಹಜ಼್ಜಸ್ ರ‍್ಹವಾನು ಕೆತ್ರೇಕ್ಕಿ ಅಛ್ಛು಼ ಹುಯಿರ‍್ಹೂಸ್! ತೂ ಬೋಲ್ತೊ ಉಶೇತೊ, ಮೇ ಹಜ್ಜಾ಼ ತೀನ್ ಡೇರಾ ಠೋಕೆಸ್, ಏಕ್‌ ತುನ, ಏಕ್‌ ಮೋಶೇನ ಅಜು಼ ಏಕ್‌ ಎಲೀಯನ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","ಯೋ ಅಮ್ ಬೋಲುಕರಾನಿ ವಖ್ಹತ್‌ಮಾಸ್‌, ಏಕ್‌ ಉಜಾ಼ಖ್ಹ್‌ನು ವಾದ್‌ಳು ಐನ್, ಇವ್ಣಾಪರ್ ಢಪಾಯು, ಅಜು಼ ಯೋ ವಾದ್ಳಾನ ಮಹಿಥು, “ಆ ಮಾರೊ ಪ್ಯಾರ್‌ನೊ ಛಿಯ್ಯೊ, ಅನೇಥಿ ಮೇ ಘಣು ಖ್ಹುಶಿ ಛೂ಼!” ಕರಿ ಏಕ್‌ ಅವಾಜ಼್ ಆಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","ಶಿಷ್ಯರ್‌ನೆ ಆ ಅವಾಜ಼್‌ನ ಖ್ಹಮ್‌ಜಿನ್‌, ಡರ್‌ಥಿ ಮ್ಹೋಡು ಹೇಟ್ ಕರೀನ್, ಜ಼ಮೀನ್‌ಪರ್ ಊಂಧಾ ಪಡಿಗಯ. ");
INSERT INTO vaa_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","ತದೆ ಯೇಸು ಇವ್ಣಾಕನ ಐನ್, ಇವ್ಣುನ ಛೀಮಿನ್‌, “ಉಪ್ಪರ್ ಉಠೊ, ಡರೊ ನಕೊ!” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","ತದೆ ಇವ್ಣೆ ಡೋಳಾ ಪಾಡಿನ್ ದೇಖ್ಯ, ತದೆ ಯೇಸು ಎಕ್ಕಸ್ ಜ಼ಣೊ ಥೊ, ಬಿಜು಼ ಕೋಣ್‌ಬಿ ಕೋ ಥೂನಿ. ");
INSERT INTO vaa_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","ಇವ್ಣೆ ಯೋ ಪಹಡ್‌ಪರ್‌ಥು ಉತ್ರಿನ್ ಆವಾನಿ ವಖ್ಹತ್‌ಮ, ಯೇಸುನೆ ಇವ್ಣುನ, “ತುಮೆ ಹಮ್ಕೆ ದೇಖ್ಯಾತೆ ಇನ ಅದ್ಮಿನೊ ಛಿಯ್ಯೊ ಮರಿನ್‌, ಪಾಛೊ಼ ಜಿವ್ತೊ ಹುಯಿನ್, ಉಠಿ ಆವಾತೋಡಿ, ಕಿನಾಬಿ ನಾ ಬೋಲ್‌ನು” ಕರಿ ಹುಕುಮ್‌ದಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","ತದೆ ಶಿಷ್ಯರ್‌ನೆ ಯೇಸುನ, “ಕ್ರಿಸ್ತ ಆವಾನಿ ಅಗಾಡಿ ಎಲೀಯ ಆವ್ಣುಕರಿ ಮೋಶೆನಿ ವಚನ್ ಶಿಕಾಡವಾಳು ಶಾಸ್ತ್ರಿಯೆ ಬೋಲಾಸ್ತೆ ಶನ?” ಕರಿ ಪುಛಾ಼ಯ. ");
INSERT INTO vaa_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","ಯೇಸುನೆ ಇವ್ಣುನ, “ಎಲೀಯ ಪಹಿಲೆ ಆವ್ಣುಕರಿ ಇವ್ಣೆ ಬೋಲಾಸ್ತೆ ಬರೊಬರಸ್, ಖ್ಹಾಚಮಾಬಿ ಎಲೀಯ ಆಯಿನ್, ಖ್ಹಾರುಸ್ ಖ್ಹವಾರ್‌ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","ಕತೋಬಿ ಮೇ ತುಮೂನ ಶಾತ್‌ ಬೋಲುಸ್‌ಕತೊ, ಎಲೀಯ ಅಗಾಡಿಸ್ ಐನ್‌ಬಿ, ಚ಼ಲೆಗಯೊ. ಕತೋಬಿ ಅದ್ಮಿಖ್ಹಾರು ಇನಿ ಖ್ಹಣೇದ್ ಕೋ ಧರ‍್ಯುನಿ, ಅಜು಼ ಇವ್ಣ ಮನ್‌ಮ ಆವಾತೆ ಇಮ್‌ ಇನ ಕರ‍್ಯು. ಇನ ಕರ‍್ಯುತೆ ಇಮ್ಮಸ್ ಅದ್ಮಿನ ಛಿಯ್ಯಾನಾಬಿ ಇವ್ಣೇಥಿ ಖ್ಹತಾಪ್ಣಿ ಉಶೆ” ಕರಿ ಜ಼ವಾಬ್ ದಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","ಬ್ಯಾಪ್ತಿಸ್ಮದ್ಯವಾಳೊ ಯೋಹಾನ್ನಿ ಬಾರೇಮ ಯೇಸು ವಾತೆ ಬೋಲುಕರಾಸ್ತೆ ಕರಿ ಶಿಷ್ಯರ್‌ನೆ ತದೆ ಮಾಲುಮ್‌ ಕರಿಲಿದ. ");
INSERT INTO vaa_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","ಯೇಸು ಅಜು಼ ಇನ ಶಿಷ್ಯರ್‌ ಪಾಛು಼ ಫರೀನ್ ಅದ್ಮಿನಿ ಝೂ಼ಂಡ್‌‍ಕನ ಆವಾದಿನ್, ಏಕ್‌ ಜ಼ಣೊ ಯೇಸುಕನ ಐನ್, ಇನಖ್ಹಾಮ್ಣೆ ಗುಡ್‍ಘ್ಯ ಟೇಕಿನ್, ");
INSERT INTO vaa_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“ಪ್ರಭು, ಮಾರ ಛಿಯ್ಯಾನ ಗೋರ್‌ ಕರ್‌! ಇನ ಮಿರ್‌ಘಿ ಲಾಗಿರ‍್ಹೂಸ್, ಇನೇಥಿ ಯೋ ಘಣು ತರಪ್‌ಡುಕರಾಸ್. ಯೋ ತದೆ-ತದೆ ಆಗ್‌ಮಾಬಿ ಪಾಣಿಮಾಬಿ ಪಡ್‌ತೊರ‍್ಹೇಸ್. ");
INSERT INTO vaa_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","ಮೇ ಇನ ತಾರ ಶಿಷ್ಯರ್‌ಕನ ಬುಲೈಲಿ ಆಯೊ, ಕತೋಬಿ ಇನ ಅಛ್ಛು಼ ಕರಾನ ಇವ್ಣ ಹಾತೆ ಕೋ ಹುಯೋನಿ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","ಯೇಸುನೆ, “ಏ, ವಿಶ್ವಾಸ್‌ಕೊಂತೆ ಬುಧ್ಧು ಖಾಂದಾನ್‌ವಾಳ! ಬಿಜು಼ ಕೆತ್ರ ದನ್ ಮೇ ತುಮಾರ ಜೋ಼ಡೆ ರ‍್ಹೇಣು? ಬಿಜು಼ ಕೆತ್ರ ದನ್ ತುಮೂನ ಖ್ಹಮಾಳ್‌ಣು? ಯೋ ಛೋ಼ಕ್ರಾನ ಹಜ್ಜಾ಼ ಮಾರಕನ ಬುಲೈಲಿ ಆವೊ!” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","ಯೇಸುನೆ ಯೋ ಛೋ಼ಕ್ರಮ ಥೂತೆ ಭೂತ್‌ನ ಗುರ್‌ಕಾವಖ್ಹತರ್, ಯೋ ಭೂತ್ ಇನ ಮ್ಹೆಂದಿನ್ ನಿಕ್ಳಿಗಯು. ಯೋಸ್ ವಖ್ಹತ್‌ಮ ಇನ ಅಛ್ಛು಼ ಹುಯಿಗಯು. ");
INSERT INTO vaa_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","ಅನಕೇಡೆಥು ಯೇಸು ಎಕ್ಲೋಸ್ ರ‍್ಹವಾನಿ ವಖ್ಹತ್‌ಮ, ಇನ ಶಿಷ್ಯರ್‌ ಇನಾಕನ ಆಯಿನ್, “ಯೋ ಭೂತ್‌ನ ಕಾಡಾನ ಹಮಾರೇಥಿ ಶನ ಕೋ ಹುಯೂನಿತೆ?” ಕರಿ ಪುಛಾ಼ಯ. ");
INSERT INTO vaa_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","ತದೆ ಯೇಸುನೆ ಇವ್ಣುನ, “ತುಮಾರಿ ವಿಶ್ವಾಸ್ ಕಮ್ ಥೀತೆ ಇನಖ್ಹಾಜೇಸ್ ತುಮೂನ ಕೋ ಹುಯೂನಿ, ಮೇ ತುಮೂನ ಖ್ಹಾಚಮಾಬಿ ಬೋಲುಸ್ಕಿ, ರಾಯಿನ ದಾಣ ಎವ್ಡಿ ವಿಶ್ವಾಸ್ ತುಮೂನ ರ‍್ಹಯೂತೊ, ");
INSERT INTO vaa_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","ತುಮೆ ಆ ಪಹಡ್‌ಣ, ‘ಹಜ್ಜಾ಼ಥು ಹಿಜ್ಜಾ಼ ಜಾ಼!’ ಕರಿ ಬೋಲ್ಯಾತೋಬಿ ಯೋ ಜಾ಼ಶೆ. ತುಮಾರ ಹಾತೆ ಹುವ್ವಾಕೊಂತೆ ಕಾಮ್ ಏಕ್‌ಬಿ ಕೋ ರ‍್ಹಿಶೇನಿ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","ಶಿಷ್ಯರ್‌ ಖ್ಹಾರು ಎಕ್ಕದಮ್‌ ಗಲಿಲಾಯಮ ಆವಾದಿನ್, ಯೇಸುನೆ ಇವ್ಣುನ, “ಅದ್ಮಿನ ಛಿಯ್ಯಾನ ಅದ್ಮಿಖ್ಹಾರಾನ ಹಾತ್‌ಮ ದೆವೈಜಾಶೆ. ");
INSERT INTO vaa_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","ಇವ್ಣೆ ಇನ ಮಾರಿನಾಕ್‌ಶೆ! ಕತೋಬಿ ತೀನ್ ದನ್‌ಕೇಡೆ ಯೋ ಪಾಛೊ಼ ಜಿವ್ತೊ ಹುಯಿನ್, ಉಠಿ ಆವ್‌ಶೆ” ಕರಿ ಬೋಲ್ಯೊ. ಅನ ಖ್ಹಮ್‌ಜಿನ್‌, ಶಿಷ್ಯರ್‌ನ ಘಣು ದುಖ್ ಹುಯು. ");
INSERT INTO vaa_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","ಯೇಸು ಅಜು಼ ಇನ ಶಿಷ್ಯರ್‌ ಕಪೆರ್ನೌಮ್ ಆವಾದಿನ್, ಮಂದಿರ್‌ನಖ್ಹಾಜೆ ಶುಂಕ ಮಾಂಗವಾಳು ಪೇತ್ರಕನ ಆಯಿನ್, “ತುಮಾರೊ ಗುರು ಮಂದಿರ್‌ನ ದೇವ್ಣುತೆ ಶುಂಕಾನ ಭಾಂದಾ ಕೊಯ್ನಿಕಿ ಶು?” ಕರಿ ಪುಛಾ಼ಯು. ");
INSERT INTO vaa_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","ತದೆ ಪೇತ್ರನೆ, “ಒಹೊ, ಭಾಂದ್‌ಶೆ” ಕರಿ ಬೋಲ್ಯೊ. ಪೇತ್ರ ಘರ್‌ಮ ಆವಾದಿನ್, ಯೇಸುನೆ ಇನೇಥಿ ಪಹಿಲೇಸ್, “ಸೀಮೋನ, ತುನ ಕಿಮ್ ದೆಖಾವಸ್? ಆ ಧರ್ತಿಪರ್‌ಲ್ಯ ರಾಜ಼ಖ್ಹಾರು ಕಿನಾಕಂಥು ಶುಂಕ ಮಾಂಗಾಸ್? ಶೊಂತ್ ದೇಖ್ಹ್‌ನ ಅದ್ಮಿಥೀಕಿ ನತರ್‌ಕಿ ಪರೈದೇಖ್ಹ್‌ವಾಳ ಅದ್ಮಿಕಂಥು ಮಾಂಗಾಸ್?” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","ಪೇತ್ರನೆ, “ಪರೈ ದೇಖ್ಹ್‌ವಾಳಕಂಥು” ಕರಿ ಜವಾಬ್‌ ದಿದೊ. ತದೆ ಯೇಸುನೆ ಪೇತ್ರನ, “ಇಮ್‍ಕತೊ, ಶೊಂತ್ ದೇಖ್ಹ್‌ವಾಳು ಶುಂಕ ಭಾಂದಾನು ಕೊಯ್ನಿ ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","ತೋಬಿ ಶುಂಕ ಮಾಂಗವಾಳು ಅಪ್ಣಿ ಬಾರೇಮ ಖಟು ಕರಾನು ನಕೊ. ಇನಖ್ಹಾಜೆ ತೂ ದರ‍್ಯಾವ್‍ನ ಜೈ಼ನ್, ಗಳ್‌ ನಾಖಿನ್, ಪಹಿಲೆ ಮಳಾಸ್ತೆ ಮಾಛ಼್‌ಲಾನ ಮ್ಹೋಡಾನ ಕಾಡಿ ದೇಕ್, ಇನಾಮ ಶುಂಕ ಭಾಂದಾನ ಹೋಣುತೆ ಏಕ್‌ ಪೈಶಾನು ಬಿಲ್ಲು ಮಳ್‌ಶೆ. ಇನ ಲಯಿನ್, ಅಪ್ಣ ಭೇ ಜ಼ಣಾನು ಕರಿ ಬೋಲಿನ್ ದೇ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","ಯೋ ವಖ್ಹತ್‌ಮ ಶಿಷ್ಯರ್‌ ಯೇಸುಕನ ಆಯಿನ್, “ಸೊರ್ಗಾನು ರಾಜ್ಯಮ ಖ್ಹಾರೇಥಿ ಮೋಟು ಕೋಣ್?” ಕರಿ ಪುಛಾ಼ಯ. ");
INSERT INTO vaa_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","ಇನಖ್ಹಾಜೆ ಯೇಸುನೆ ಏಕ್‌ ಅಡ್ಡಾಣಿ ಲಡ್ಕಾನ ಬುಲೈನ್, ಶಿಷ್ಯರ್‌ನ ಖ್ಹಾಮ್ಣೆ ಭಿರಾಖಿನ್, ");
INSERT INTO vaa_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","“ಮೇ ತುಮೂನ ಖ್ಹಾಚಮಾಬಿ ಬೋಲುಸ್ಕಿ, ತುಮೆ ಪಾಛು಼ ಫರೀನ್, ಆ ಅಡ್ಡಾಣಿ ಲಡ್ಕಾನಿ ಘೋಣಿ ನಾ ಹುಯಾತೊ, ತುಮೆ ಸೊರ್ಗಾನು ರಾಜ್ಯಮ ಜಾ಼ಶುಸ್ ಕೊಯ್ನಿ. ");
INSERT INTO vaa_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","ಕೋಣ್ ಅಡ್ಡಾಣಿ ಲಡ್ಕಾನಿಘೊಣಿ ಇನು ಯೋ ಝು಼ಕೈಲೇಸ್ಕಿ, ಯೋಸ್ ಸೊರ್ಗಾನು ರಾಜ್ಯಮ ಖ್ಹಾರೇಥಿ ಮೋಟೊ. ");
INSERT INTO vaa_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","ಅತ್ರೇಸ್ ಕಾಹೆತೆ ಕೋಣ್‌ತೋಬಿ ಮಾರ ನಾಮ್‌ಪರ್‌ ಅಮ್ನಏಕ್ ಅಡ್ಡಾಣಿ ಲಡ್ಕಾನ ಬುಲೈಲೇಸ್ಕಿ, ಯೋ ಮನ ಬುಲೈಲ್ಯವಾಳೊ ಹುಯಿರ‍್ಹೊಸ್. ");
INSERT INTO vaa_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","ಮಾರಪರ್ ವಿಶ್ವಾಸ್ ಕರಾವಾಳ ಆ ನ್ಹಾನಾವ್‍ಮ ಏಕ್‌ನ ಕೋಣ್‌ತೋಬಿ ಭೀರಾಖ್ಯೂತೊ, ಇಮ್‌ನಾನ ಘಲೆಂಡ ಕೇಡೆ ಘಟ್ಟಿನ ಬಂಡಾನ ಭಾಂದಿನ್, ಗಧಾರ್ ದರ‍್ಯಾವ್‌ಮ ಡುಬೈನಾಖಾನುಸ್ ಇನ ಅಛ್ಛು಼. ");
INSERT INTO vaa_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","ಜಗತ್ನಿ ಹಾಲ್ನ ಶಾತ್ ಬೋಲು! ಶನಕತೊ, ಅದ್ಮಿನ ಪಾಪ್‌ಮ ಚ಼ಲಾವವಾಳು ರಾಛು಼ಖ್ಹಾರು ಛಾ಼! ಇಮ್ನು ರಾಛು಼ಖ್ಹಾರು ಕದೇಬಿ ಚಾ಼ಲ್‌ಷೆ. ಕತೋಬಿ ಇಮ್‌ ಹುವ್ವಾನಿಘೋಣಿ ಕರಾಸ್ತೆ ಯೋ ಅದ್ಮಿನಿ ಹಾಲ್ನ ಶಾತ್ ಬೋಲು! ");
INSERT INTO vaa_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“ತಾರೊ ಹಾತ್ ನತರ್‌ಕಿ ತಾರೊ ಗೋಡೊ ತುನ ಪಾಪ್‌ಮ ಖ್ಹಪ್‌ಡಾವ್‌ತೊ ಉಶೇತೊ, ಇನ ಕತ್ರೀನ್ ಫೇಕಿದೆ! ಬೇ ಹಾತ್ ಅಜು಼ ಬೇ ಗೋಡ ರ‍್ಹೀನ್, ಹರ್‌ಹಮೇಶಾನಿ ಆಗ್‌ಮ ಫೆಕಾವಥೀಬಿ, ಹಾತ್‌-ಗೋಡಕೊಂತೆ ಹರ್‌ಹಮೇಶಾನಿ ಜಿ಼ಂದ್‌ಗೀಮ ಜಾ಼ವಾನೂಸ್ ತುನ ಅಶೇಲ್. ");
INSERT INTO vaa_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","ತಾರೊ ಡೋಳೊ ತುನ ಪಾಪ್‌ಮ ಖ್ಹಪ್‌ಡಾವ್‌ತೊ ಉಶೇತೊ, ಇನ ಕಚ಼್‌ಕೋರಿನ್ ಫೇಕಿದೆ! ಬೇ ಡೋಳಾ ರ‍್ಹೀನ್ ನರಕ್‌ನಿ ಆಗ್‌ಮ ಫೆಕಾವಥೀಬಿ ಎಕ್ಕಸ್ ಡೋಳೊ ರ‍್ಹೀನ್, ಹರ್‌ಹಮೇಶಾನಿ ಜಿ಼ಂದ್‌ಗೀಮ ಜಾ಼ವಾನೂಸ್ ತುನ ಅಶೇಲ್. ");
INSERT INTO vaa_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","ಆ ನ್ಹಾನಾವ್‍ಮ ಏಕ್‌ನಾಬಿ ಕಡ್‌ತೆಲ್ ಕರಿ ನಕೊ ಸೋಚ಼್‌ಶು. ಸೊರ್ಗಾಮ ಅವ್ಣು ದೂತರ್ ಸೊರ್ಗಾಮ ಛಾ಼ತೆ ಮಾರ ಬಾನು ಮ್ಹೋಡಾನ ಹಮೇಶ ದೇಕ್ತುರ‍್ಹೇಸ್ ಕರಿ ಮೇ ತುಮೂನ ಬೋಲುಸ್. ");
INSERT INTO vaa_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","ಅದ್ಮಿನೊ ಛಿಯ್ಯೊ ಖರಾಬ್ ಹುಯಿಗಹುಯಾನ ಢೂಂಡಿನ್ ಬಚಾ಼ಡನ ಆಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","ತುಮೂನ ಕಿಮ್ ದೆಖಾವಸ್? ಏಕ್‌ ಅದ್ಮಿಕನ ಖ್ಹೋ ಮೇಂಢರ‍್ಹೀನ್, ಇನಾಮ ಏಕ್‌ ಮೇಂಢು ಗುಮೈಗಯೂತೆ, ಯೋ ಅದ್ಮಿ ನೌ ಉಪ್ಪರ್ ಖ್ಹಡ್‌ಚಾರೀಖ್ಹ್ ಮೇಂಢಾನ ಮ್ಹೆಂದಿನ್, ಗುಮೈಗಯೂತೆ ಯೋ ಮೇಂಢಾನ ಢೂಂಡಾನ ಜಾ಼ಯಿಕೊಯ್ನಿಕಿ ಶು? ");
INSERT INTO vaa_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","ಗುಮೈಗಯೂತೆ ಯೋ ಮೇಂಢು ಮಳ್ಯುತೊ, ಗುಮಾಯುಕೊಂತೆ ಯೋ ನೌ ಉಪ್ಪರ್ ಖ್ಹಡ್‌ಚಾರೀಖ್ಹ್ ಮೇಂಢವ್‌ಥೀಬಿ ಯೋ ಏಕ್‌ ಮೇಂಢಾನಖ್ಹಾಜೆ ಜಾ಼ಖ್ಹತ್ ಖ್ಹುಶಿ ಕರಾಸ್ ಕರಿ ಮೇ ತುಮೂನ ಖ್ಹಾಚಮಾಬಿ ಬೋಲುಸ್. ");
INSERT INTO vaa_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","ಇಮ್ಮಸ್ ಆ ನ್ಹಾನಾವ್‍ಮ ಏಕ್‌ಬಿ ಖರಾಬ್ ನಾ ಜಾ಼ವ್ಣು ಕರಿ ಬೋಲಾನುಸ್ ಸೊರ್ಗಾಮ ಛಾ಼ತೆ ತುಮಾರ ಬಾನಿ ಮರ್ಜಿ. ");
INSERT INTO vaa_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","ತಾರೊ ಭೈ ತಾರಿ ವಿರೋದ್ ಗಲತ್‌ ಕರ‍್ಯೋತೊ, ತೂ ಜೈ಼ನ್, ಯೋ ಎಕ್ಲೋಸ್ ರ‍್ಹವಾನಿ ವಖ್ಹತ್‌ಮ, ಇನಿ ಗಲ್ತಿನ ಇನ ಬೋಲಿವತಾಳ್. ಯೋ ತಾರಿ ವಾತೇನ ಖ್ಹಮ್‌ಜಿಗಯೋತೊ ತಾರ ಭೈನ ತೂ ಪಾಛೊ಼ ಕಮೈಲಿದೊ ಕರಿ. ");
INSERT INTO vaa_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","ಕತೋಬಿ ಯೊ ತಾರಿ ವಾತೆನ ನಾ ಖ್ಹಮ್‌ಜ್ಯೋತೊ, ತಾರ ಜೋ಼ಡೆ ಬಿಜು಼ ಏಕ್‌ ನತರ್‌ಕಿ ಬೇ ಜ಼ಣಾನ ಬುಲೈಲಿ ಇನಾಕನ ಜಾ಼, ಶನಕತೊ ‘ಹರೇಕ್ ವಾತೇನ ಬೇ ನತರ್‌ಕಿ ತೀನ್ ಅದ್ಮಿನಿ ಸಾಕ್ಷಿ ರ‍್ಹೇಣು. ");
INSERT INTO vaa_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","ಯೋ ಇವ್ಣಿ ವಾತೇನಾಬಿ ನಾ ಖ್ಹಮ್‌ಜ್ಯೊತೊ, ಸಭೆನ ಬೋಲ್, ಯೋ ಸಬೇನಿ ವಾತೇನಾಬಿ ನಾ ಖ್ಹಮ್‌ಜ್ಯೋತೊ ಯೋ ದೇವ್‌ಮ ವಿಶ್ವಾಸ್‍ಕರಾಕೊಂತೆ ನತರ್‌ಕಿ ಶುಂಕ ಮಾಂಗವಾಳ ಅದ್ಮಿನಿಘೋಣಿ ಇನ ದೇಕ್. ");
INSERT INTO vaa_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","ಮೇ ತುಮೂನ ಖ್ಹಾಚಮಾಬಿ ಬೋಲುಸ್: ತುಮೆ ಆ ಧರ್ತಿಪರ್ ಶಶ್ಶಾತ್ ಭಾಂದಾಸ್ಕಿ, ಯೋ ಖ್ಹಾರು ಸೊರ್ಗಾಮಾಬಿ ಭಂದೈರ‍್ಹೀಶೆ, ಅಜು಼ ತುಮೆ ದರ್ತಿಪರ್ ಶಶ್ಶಾತ್ ಛೋ಼ಡಾಸ್ಕಿ ಯೋ ಖ್ಹಾರು ಸೊರ್ಗಾಮಾಬಿ ಛೋ಼ಡಾವ್‌ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","ಎತ್ರೇಸ್ ಕಾಹೆತೆ, ತುಮಾರಾಮ ಬೇ ಜ಼ಣು ಆ ಧರ್ತಿಪರ್ ಎಕ್ಕಸ್ ಮನ್‌ಥಿ ಶಾತ್‌ ಮಾಂಗಿಲಿದುತೋಬಿ ಸೊರ್ಗಾಮ ಛಾ಼ತೆ ಮಾರೊ ಬಾ ಇವ್ಣುನ ದಿಶೆ ಕರಿ ಮೇ ತುಮೂನ ಖ್ಹಾಚಮಾಬಿ ಬೋಲುಸ್. ");
INSERT INTO vaa_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","ಶನಕತೊ ಬೇ ನತರ್‌ಕಿ ತೀನ್ ಜ಼ಣು ಮಾರ ನಾಮ್‍ಪರ್ ಕಿಜ್ಗಾ಼ ಎಕ್ಟು ಹುಯಿನ್ ಐರ‍್ಹೇಸ್ಕಿ ಹಿಜ್ಜಾ಼ ಇವ್ಣ ಇಚ಼್‌ಮ ಮೇ ರ‍್ಹೆವುಸ್‌. ");
INSERT INTO vaa_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","ತದೆ ಪೇತ್ರನೆ ಯೇಸುಕನ ಆಯಿನ್, “ಪ್ರಭು, ಮಾರೊ ಭೈ ಮಾರಿ ವಿರೋದ್ ಗಲತ್‌ ಕರ‍್ಯೋತೊ, ಮೇ ಇನ ಕೆತ್ರಿಹಲ್ಲ ಮಾಪ್‌ ಕರ‍್ನು? ಖ್ಹಾತ್ ಹಲ್ಲಾಕಿ ಶು?” ಕರಿ ಇನ ಪುಛಾ಼ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","ಯೇಸುನೆ, “ಖ್ಹಾತ್ ಹಲ್ಲಾ ಕಾಹೆ, ಖ್ಹಾತ್ ಖ್ಹಡ್‌ತೀನಿಖ್ಹ್ ಹಲ್ಲ” ಕರಿ ಜವಾಬ್‌ ದಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“ಶನಕತೊ ಸೊರ್ಗ ರಾಜ್ಯನ ಇನ ಸೇವಕರ್‌ಥಿ ಪೈಶಾನಿ ಇಶಾಬ್ ಲೇವ್ಣುಕರಿ ತೀರ್ಮಾನ್ ಕರಾಸ್ತೆ ಏಕ್‌ ರಾಜಾ಼ನಿಘೋಣಿ ಛಾ಼. ");
INSERT INTO vaa_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","ಯೋ ಇಶಾಬ್ ಲ್ಯವಾನು ಶುರುಕರ್‌ತಾನ, ಕರೋಡೊ ರಪ್ಯ ದೇವ್ಣುಥೂತೆ ಏಕ್‌ನ ಇನಾಕನ ಲಾಯು. ");
INSERT INTO vaa_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","ಯೋ ಕರಜ಼್ ಫೇಡಾನ ಇನಾಕನ ಶಾತ್ಬಿ ಕೋ ಥೂನಿತೆ ಇನಖ್ಹಾಜೆ, ಇನ ಯಜಮಾನ್ನೆ, ‘ಇನಾಬಿ ಇನಿ ಬಾವಣ್‍ ಅಜು಼ ಲಡ್ಕಾವ್‍ನ, ಅಜು಼ ಇನಾಕನ ಛಾ಼ತೆ ಖ್ಹಾರಸ್ನ ವೇಚಿನ್, ಯೋ ಕರಜ಼್‌ನ ಫೇಡ್‍ಣು’ ಕರಿ ಹುಕುಮ್ ದಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","ತದೆ ಯೋ ಆಳ್‌ನೆ ಇನ ರಾಜಾ಼ನ ಆಡ್‍ಪಡಿನ್, ‘ರಾಜಾ಼, ಜ಼ರ ಖ್ಹಮಾಳಿಲೇ, ಮೇ ತುನ ದೇವ್ಣುತೆ ಖ್ಹಾರುಸ್ ಫೇಡುಸ್’ ಕರಿ ಇನ ಗಿಂಗೈಲಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","ಅನ ದೇಖಿನ್ ಯೋ ಯಜಮಾನ್ನೆ ಇನ ಆಳ್‌ಪರ್ ಗೋರ್‌ಖೈನ್, ಯೋ ದೇವ್ಣುತೆ ಖ್ಹಾರು ಕರಜ಼್‌ನ ಮಾಫ್‌ಕರೀನ್, ಇನ ಜಾ಼ವಾನ ಮ್ಹೆಂದಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“ಅನಕೇಡೆಥು ಯೋ ಆಳ್‌ ಭಾರ್‌ಆಯಿನ್, ಇನ ಥೋಡ ಪೈಶಾ ದೇವ್ಣುಥೂತೆ ಇನ ಜೋ಼ಡ್ಮ ಕಾಮ್ ಕರಾವಾಳೊ ಆಳ್‌ನ ದೇಖಿನ್, ಇನಿ ನ್ಹೇಟಿ ಭೀಚಿನ್, ‘ಮಾರು ಕರಜ಼್ ಫೇಡ್ಲ!’ ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","ತದೆ ಯೋ ಆಳ್‌ನೆ ಇನ ಗೋಡಾಪರ್ ಪಡೀನ್, ‘ಜ಼ರ ಖ್ಹಮಾಳಿಲೇ, ಮೇ ಫೇಡುಸ್!’ ಕರಿ ಗಿಂಗೈಲಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","ಕತೋಬಿ ಇನೆ ಮಾನ್ಯೊಕೊಂತೆ, ಇನ ಧರೀನ್, ಕರಜ಼್ ಫೇಡಾತೋಡಿ ಇನ ಜೇಲ್‌ಮ ಘಲಾಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","ತದೆ ಅನ ದೇಖ್ಯೂತೆ ಬಿಜಾ಼ಖ್ಹಾರ ಆಳ್‌ನೆ ಘಣು ದುಖ್ ಖೈನ್, ಯಜಮಾನ್‍ಕನ ಆಯಿನ್, ಚಾ಼ಲ್ಯುತೆ ಇನಿ ಬಾರೇಮ ಖ್ಹಾರುಸ್ ಇನ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","ತದೆ ಯಜಮಾನ್ನೆ ಯೋ ಆಳ್‌ನ ಬುಲೈನ್, ‘ತೂ ಖರಾಬ್ ಆಳ್‌! ತೂ ಮನ ಬೋಲಿಲೇತಾನ, ಮನ ದೇವ್ಣುತೆ ಯೋ ಖ್ಹಾರೂಸ್ ಕರಜ಼್‌ನ ಮೇ ಮ್ಹೆಂದಿದೋನಿ. ");
INSERT INTO vaa_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","ಮೇ ತಾರಪರ್ ಗೋರ್‌ ವತಾಳ್ಯೊತೆ ಇಮ್ಮಸ್, ತೂಬಿ ತಾರ ಜೋ಼ಡ್ಮ ಕಾಮ್ ಕರಾವಾಳೊ ಯೋ ಆಳ್‌ನ ಮಾಪ್‌ ನಾ ಕರ್ನುಥೂಕಿ ಶು?’ ಕರಿ ಬೋಲಿನ್, ");
INSERT INTO vaa_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","ಯಜಮಾನ್ನೆ ಖೀಜ಼್‌ ಕರೀನ್‌, ಇನ ದೇವ್ಣುಥೂತೆ ಖ್ಹಾರುಸ್ ಕರಜ಼್ ಫೇಡಾತೋಡಿ, ಇನ ದಂಡ್‌ ದ್ಯವಾನಖ್ಹಾಜೆ ಜೇಲ್‌ಮ ಘಲಾಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","ತುಮಾರಾಮ ಹರೇಕ್ ಜ಼ಣು ಇನ ಭೈನ ದಿಲ್‌ಥಿ ಮಾಪ್‌ ನಾ ಕರ‍್ಯಾತೊ, ಸೊರ್ಗಾಮ ಛಾ಼ತೆ ಮಾರೊ ಬಾಬಿ ತುಮೂನ ಯೋ ರಾಜಾ಼ನೆ ಕರ‍್ಯೊತೆ ಇಮ್ಮಸ್ ಕರ್ಶೆ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","ಯೇಸುನೆ ಆ ಖ್ಹಾರಿ ವಾತೇನ ಬೋಲಾನ ಬಾದ್‌ಮ, ಗಲಿಲಾಯನ ಮ್ಹೆಂದಿನ್, ಯೊರ್ದನ್‌ ನದ್ದಿನು ಪಾರ್ಲಿ ಬಾಜೂ಼ಮ ಥೂತೆ ಯೂದಾಯ ತಬರ್‌ಖಾನ ಗಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","ಕೈಯೆಕ್ಕಿ ಅದ್ಮಿನಿ ಮೋಟಿ ಝೂ಼ಂಡ್‌ ಇನ ಪೀಠೆ ಗಯು, ಅಜು಼ ಯೇಸುನೆ ಇವ್ಣುನ ಹಿಜ್ಜಾ಼ ಅಛ್ಛು಼ ಕರ‍್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","ತದೆ ಫರಿಸಾಯರ್‌ವಾಳು ಯೇಸುಕನ ಆಯಿನ್ ಇನ ಫಖ್ಹಾವ್ಣು ಕರಿ, “ಏಕ್‌ ಜ಼ಣೊ ಖೆವಿತೋಬಿ ಏಕ್‌ ಭಾಮ್‌ಥಿ ಇನಿ ಬಾವಣ್ಣ ಮ್ಹೇಲಿದ್ಯವಾನು ಬರೊಬರ‍್ನಿ ನಿಯಮ್‌ ಕಿಶು?” ಕರಿ ಪುಛಾ಼ಯು. ");
INSERT INTO vaa_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","ತದೆ ಯೇಸುನೆ, “ಅದ್ಮಿನ ಉಬ್‌ಜಾ಼ಯೋತೆ ಇನೆ ಶುರುವಾತ್‌ಥೂಸ್ ಇವ್ಣುನ ಪರ್ಖ್ಹೊ ತಯೇಡಕರಿ, ಬಣಾಯೊ ಕರಿ ವಚನ್‌ಮ ಛಾ಼ತೆ ಇನ ತುಮೆ ಪಢಿರಾಖ್ಯಕೊಯ್ನಿಕಿ ಶು? ");
INSERT INTO vaa_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","ಇನಖ್ಹಾಜೆ ದೇವ್ನೆ, ಇನ ಆಯ-ಬಾನ ಮ್ಹೇಲಿನ್, ಇನಿ ಬಾವಣ್‍ಥಿ ಮಳಾಸ್. ಇವ್ಣೆ ಭೇ ಜ಼ಣು ಎಕ್ಕಸ್ ಶರೀರ್ ಹುಯಿನ್ ರ‍್ಹಿಶೆ’ ಕರಿ ಬೋಲ್ಯೋತೆ. ");
INSERT INTO vaa_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","ಇನಖ್ಹಾಜೇಸ್ ಬಿಜು಼ ಖ್ಹಾಮ್ಣೆ ಇವ್ಣೆ ಬೇಜ಼ಣ ಕಾಹೆ, ಎಕ್ಕಸ್ ಶರೀರ್‌ ಹುಯಿರ‍್ಹಾಸ್. ಇನಖ್ಹಾಜೇಸ್ ದೇವ್ನೆ ಮಳಾಯಹುಯಾನ ಅದ್ಮಿ ಅಲಕ್‌ನಾಸ್ ಕರ‍್ನು” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","ತದೆ ಪರಿಸಾಯರ್‌ನೆ ಯೇಸುನ, “ಇಮ್‍ಕತೊ, ಏಕ್‌ ಪರ್ಖ್ಹೊ ತಲಾಕ್‌ನು ಕಾಗತ್‌ ಲೀಖಿದೀನ್‌, ಇನಿ ಬಾವಣ್ಣ ಮ್ಹೇಲಿದಿಯ್ಯೆಜಾ಼ಯ್ ಕರಿ ಮೋಶೇನೆ ಹಮೂನ ಹುಕುಮ್‌ ದಿದೋನಿ ಶನ?” ಕರಿ ಪುಛಾ಼ಯು. ");
INSERT INTO vaa_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","ತದೆ ಯೇಸುನೆ ಇವ್ಣುನ, “ಮೋಶೆನೆ ತುಮಾರ ಮೊಂಡಿದಿಲ್‌ನ ದೇಖಿನ್, ತುಮಾರಿ ಬಾವಣ್ಣ ಮ್ಹೇಲಿದ್ಯವಾನ ಹುಕುಮ್ ದಿದೋತೆ. ಕತೋಬಿ ಶುರುವಾತ್‌ಥೂಸ್ ಅಮ್ ಕೋಥೂನಿ. ");
INSERT INTO vaa_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","ಮೇ ತುಮೂನ ಶಾತ್‌ ಬೋಲುಸ್‌ಕತೊ, ವ್ಯಬಿಚಾರ‍್ನಿ ಕಾರಣ್‌ ಕೊಂತೆಸ್ ಇನಿ ಬಾವಣ್ಣ ಮ್ಹೇಲಿದಿನ್, ಬಾವ್ರಿ ಮ್ಹೇಲಿಹುಯಿನ ವ್ಯಹಾ ಕರಿಲ್ಯವಾಳೊ ವ್ಯಬಿಚಾರಿ ಹುಯಿರ‍್ಹೋಸ್” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","ತದೆ ಇನ ಶಿಷ್ಯರ್‌ನೆ ಇನ, “ಬಾವಣ್ಣಿ ಬಾರೇಮ ಬಾವ್ರಿ ಅಮ್ಮಸ್ ಚಾ಼ಲಿಲೇವ್ಣು ಕರಿ ಉಶೇತೊ, ವ್ಯಹಾ ಕರಾಕೊಯ್ನಿತೇಸ್ ರ‍್ಹವಾನುಸ್ ಅಛ್ಛು಼” ಕರಿ ಬೋಲ್ಯ. ");
INSERT INTO vaa_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","ಯೇಸುನೆ, “ಆ ವಾತೇನ ಮಾನಿಲ್ಯವಾನು ದೇವ್‍ಥಿ ಕಿನ ದೆವೈರ‍್ಹೂಸ್ಕಿ ಇವ್ಣೇಸ್ ಪಣ್ಕಿ, ಬಿಜು಼ ಕೋಣ್‌ಬಿ ಇನ ಮಾನಿಲ್ಯವಾನ ಕೋ ಹುವಾನಿ. ");
INSERT INTO vaa_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","ಪರ್ಖ್ಹಾ ಅದ್ಮಿ ವ್ಯಹಾ ಕರಾಕೊಯ್ನಿತೆ ಇನ ಬಿಜಿ-ಬಿಜಿ ಕಾರಣ್ ಛಾ಼. ಕೆಹುಕತೊ, ಥೋಡು ಜ಼ಣು ಆಯಾನ ಗರಬ್‌ಮಾಥೂಸ್ ವ್ಯಹಾ ಕರಾನ ಲ್ಹಾಯಕ್‌ಕೊಂತೆ ಇಮ್‌ ಪೈದಾಹುವ್ವಾಸ್; ಅಜು಼ ಥೋಡು ಜ಼ಣು ಅದ್ಮಿನ ಹಾತೆ ಇಮ್‌ ಕರೈಲೇಸ್; ಕತೋಬಿ ಬಿಜು಼ ಥೋಡು ಜ಼ಣು ಸೊರ್ಗಾನು ರಾಜ್ಯನಖ್ಹಾಜೆ ವ್ಯಹಾ ಕರಾಕೊಯ್ನಿ. ಕಿನ ಆ ವಾತೇನ ಮಾನಾನ ಹುವಾಸ್ಕಿ ಇವ್ಣೆ ಮಾನಿಲೇಸ್. ");
INSERT INTO vaa_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","ಥೋಡು ಜ಼ಣು ಇವ್ಣ ಅಡ್ಡಾಣಿ ಲಡ್ಕಾವ್‍ನ ಯೇಸುಕನ ಲೈನ್‌, ಇವ್ಣಾಪರ್ ಹಾತ್ ಮ್ಹೇಲಿನ್, ಪ್ರಾರ್ಥನೆ ಕರ‍್ನು ಕರಿ ಬೋಲಿಲಿದು, ಕತೋಬಿ ಶಿಷ್ಯರ್‌ನೆ ಇವ್ಣುನ ಗುರ್‌ಕಾಯು. ");
INSERT INTO vaa_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","ತದೆ ಯೇಸುನೆ, “ಅಡ್ಡಾಣಿ ಲಡ್ಕಾವ್‍ನ ಮ್ಹೇಲೊ, ಮಾರಕನ ಆವಾನ ಇವ್ಣುನ ಭೀರಾಖೊ ನಕೊ, ಶನಕತೊ ಸೊರ್ಗಾನು ರಾಜ್ಯ ಇಮ್‌ವಾಳನೂಸ್” ಕರಿ ಬೋಲಿನ್, ");
INSERT INTO vaa_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","ಇವ್ಣಾಪರ್ ಹಾತ್‌ ಮ್ಹೇಲಿನ್, ಹಿಜ್ಜಾ಼ಥೊ ಚ಼ಲೆಗಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","ಏಕ್‌ ಹಲ್ಲ ಏಕ್‌ ಅದ್ಮಿ ಯೇಸುಕನ ಆಯಿನ್, “ಗುರು, ಮನ ಹಮೇಶಾನಿ ಜಿ಼ಂದ್‌ಗಿ ಮಳ್‌ಣುಕತೊ ಮೇ ಖೆವು ಅಛ಼್ಛು ಕಾಮ್ನ ಕರ‍್ನು?” ಕರಿ ಪುಛಾ಼ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","ತದೆ ಯೇಸುನೆ ಇನ, “ಅಛ್ಛಾ಼ನಿ ಬಾರೇಮ ತೂ ಮನ ಪುಛಾ಼ವಾಸ್ತೆ ಶನ? ದೇವ್ ಎಕ್ಕಸ್ ಜ಼ಣೊ ಅಛ್ಛೊ಼. ಕತೋಬಿ ತುನ ಹರ್‌ಹಮೇಶಾನಿ ಜಿ಼ಂದ್‌ಗಿ ಹೋಣುಕತೊ, ದೇವ್ನಿ ಖ್ಹಾರಿ ಹುಕುಮ್‌ನಿಘೋಣಿ ಚಾ಼ಲಿಲೇ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","ಯೋ ಅದ್ಮಿನೆ, “ಖೆವಿ ಖ್ಹಾರಿ ಹುಕುಮ್?” ಕರಿ ಪುಛಾ಼ಯೊ. ಯೇಸುನೆ, “ಖೂನಿ ನಾಹೋಣು; ವ್ಯಬಿಚಾರ್ ನಾ ಕರ‍್ನು; ಚೋ಼ರಿ ನಾ ಕರ‍್ನು; ಬಿಜಾ಼ಪರ್ ಝೂ಼ಟಿ ಸಾಕ್ಷಿ ನಾ ಬೋಲ್‌ನು; ");
INSERT INTO vaa_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","ತಾರ ಆಯ-ಬಾನ ಮರ್ಯಾದಿ ದೇವ್ಣು; ಅಜು಼ ತಾರು ತೂ ಕಿಮ್ ಪ್ಯಾರ್ ಕರಿಲೇಸ್ಕಿ, ಇಮ್ಮಸ್ ತಾರ ಭೀಡೆವಾಳಾನ ಪ್ಯಾರ್ ಕರ‍್ನು; ");
INSERT INTO vaa_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","ಯೋ ಜಾ಼ನ್ಜ಼ಮಾನ್ ಅದ್ಮಿನೆ, “ಮೇ ಆ ಖ್ಹಾರಿಸ್ ಹುಕುಮ್‌ನಿಘೋಣಿ ಚಾ಼ಲಿರಾಖ್ಯೋಸ್. ಬಿಜು಼ ಶಾತ್ಬಿ ಕಮ್ ಹುಯಿರ‍್ಹುಸ್ಕಿ ಶು?” ಕರಿ ಪುಛಾ಼ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","ಯೇಸುನೆ ಇನ, “ತೂ ಪಕ್ಕಾ ಹೋಣುಕರಿ ಉಶೇತೊ, ಜೈ಼ನ್, ತಾರು ಶೊತ್ನ ಖ್ಹಾರು ವೇಚಿನ್, ಇನೇಥಿ ಆವಸ್ತೆ ಪೈಶಾನ ಗರೀಬ್‌ನ ದೇ, ತದೆ ಸೊರ್ಗಾಮ ತುನ ಶೊತ್ ರ‍್ಹಿಶೆ. ಅನಕೇಡೆಥು ತೂ ಐನ್, ಮಾರ ಪೀಠೆ ಆವ್!” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","ಯೋ ಜಾ಼ನ್ಜ಼ಮಾನ್ ಅದ್ಮಿನೆ ಅನ ಖ್ಹಮ್‌ಜಿನ್‌, ಘಣು ದುಖ್‌ಥಿ ಚ಼ಲೆಗಯೊ. ಶನಕತೊ ಯೋ ಘಣೊ ಶೌಕಾರ್ ಹುಯಿರ‍್ಹೋಥೊ. ");
INSERT INTO vaa_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","ತದೆ ಯೇಸುನೆ ಇನ ಶಿಷ್ಯರ್‌ನ, “ಮೇ ತುಮೂನ ಖ್ಹಾಚ ಬೋಲುಸ್: ಶೌಕಾರ್ ಅದ್ಮಿ ಸೊರ್ಗಾನು ರಾಜ್ಯಮ ಜಾ಼ವಾನು ಘಣು ಮುಶ್ಕಿಲ್. ");
INSERT INTO vaa_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","ಒಹೊ, ಶೌಕಾರ್ ಅದ್ಮಿ ದೇವ್‌ನು ರಾಜ್ಯಮ ಜಾ಼ವಾಥೀಬಿ, ಊಟ್‍ ಖ್ಹುಯಿನ ಡೋಳವಾಟೆಕರಿ ಪೇಶಿಜಾ಼ವನು ಶುಲ್ಬ ಕರಿ ಮೇ ತುಮೂನ ಪಾಛೊ಼ ಬೋಲುಸ್” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","ಅನ ಖ್ಹಮ್‌ಜಿನ್‌, ಶಿಷ್ಯರ್‌ನೆ ಘಣು ಆಶ್ಚರ್ಯಥಿ, “ಇಮ್‍ಕತೊ, ಕಿನ ರಕ್ಷಣೆ ಮಳ್‌ಶೆ?” ಕರಿ ಪುಛಾ಼ಯ. ");
INSERT INTO vaa_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","ಯೇಸುನೆ ಇನ ಶಿಷ್ಯರ್‌ ಭಣಿ ಠರ್‌ಕೈ ದೇಖಿನ್, “ಆ ಅದ್ಮಿಥಿ ಹುವ್ವಾಕೊಯ್ನಿ, ಕತೋಬಿ ದೇವ್‍ಥಿ ಖ್ಹಾರುಸ್ ಹುವಾಸ್” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","ತದೆ ಪೇತ್ರನೆ, “ಹಂದೇಕ್‌! ಹಮೆ ಖ್ಹಾರೂಸ್ ಮ್ಹೆಂದಿನ್, ತಾರ ಪೀಠೆ ಐಗಯ. ಹಮೂನ ಶಾತ್ ಮಳ್‌ಶೆ?” ಕರಿ ಪುಛಾ಼ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","ಯೇಸುನೆ ಇವ್ಣುನ, “ಮೇ ತುಮೂನ ಖ್ಹಾಚ ಬೋಲುಸ್: ನವಜ಼ಗ್‍ಮ ಅದ್ಮಿನೊ ಛಿಯ್ಯೊ ಇನಿ ಮಹಿಮೆನಿ ಸಿಂಹಾಸನ್‌ಪರ್ ಬೇಖ್ಹ್‌ಶೆ, ತದೆ ಮಾರ ಪೀಠೆ ಆಯಾತೆ ತುಮೆ ಭಾರ ಜ಼ಣಾಬಿ ಸಿಂಹಾಸನ್‌ಪರ್ ಬೇಶಿನ್, ಇಸ್ರಾಯೇಲ್‌ನ ಭಾರ ಖೂಮ್‍ವಾಳನ ನ್ಯಾವ್‍ಫೇಡ್‍ಶು. ");
INSERT INTO vaa_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","ಅಜು಼ ಮಾರ ನಾಮ್‍ಪರ್ ಘರ್‌ನರ‍್ಹೆವೊ, ಭೈಯೇನ ರ‍್ಹವೊ, ಭೇನೇನ ರ‍್ಹವೊ, ಬಾನ ರ‍್ಹವೊ, ಆಯಾನ ರ‍್ಹವೊ, ಲಡ್ಕಾವ್ನ ರ‍್ಹವೊ, ಖೇತರ್‌ನ ರ‍್ಹವೊ ಮ್ಹೇಲಿದಿದೂತೆ ಹರೇಕ್ನ ಖ್ಹೋ ಪಟ್ ಜಾ಼ಖ್ಹತ್ ಮಳ್‌ಶೆ ಅಜು಼ ಹರ್‌ಹಮೇಶಾನಿ ಜಿ಼ಂದ್‌ಗೀಬಿ ಮಳ್‌ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","ಕತೋಬಿ ಹಮ್ಕೆ ಅಗಾಡಿ ಛಾ಼ತೆ ಕೈಯೆಕ್ಕಿ ಜ಼ಣು ಪಾಛ಼ಳ್ ಹುಯಿಜಾ಼ಶೆ ಅಜು಼ ಪಾಛ಼ಳ್ ಛಾ಼ತೆ ಕೈಯೆಕ್ಕಿ ಜ಼ಣು ಅಗಾಡಿ ಹುಯಿಜಾ಼ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","ಸೊರ್ಗಾನು ರಾಜ್ಯ ಏಕ್‌ ದ್ರಾಕ್ಷಿನೊ ಬಾಗ್‌ನೊ ಯಜಮಾನ್ನಿಘೋಣಿ ಛಾ಼.ಏಕ್‌ ದನ್ನೆ ವ್ಹಾಣಾನು ಯೋ ಇನ ಬಾಗ್‌ಮ ಕಾಮ್ ಕರಾನಖ್ಹಾಜೆ ಥೋಡ ಕೂಲಿಆಳ್‍ನ ಬುಲಾವನ ನಿಕ್‌ಳ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","ಇನೆ ದನ್ನ ಏಕ್‌ ಕೂಲಿ ಆಳ್‌ನ ಏಕ್‌ ರೂಪಾನಬಿಲ್ಲಾ ದೆವುಸ್ ಕರಿ ವಾತೆ ಕರೀನ್, ಯೋ ಆಳ್‌ನ ಖ್ಹಾರು ಇನ ಬಾಗ್‌ಮ ಬೋಲಿ ಮೋಕ್‌ಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","ಅನಕೇಡೆಥು ಯೋ ಬಾಗ್‌ನೊ ಯಜಮಾನ್ ಕಮ್‍ಶಿಕಮ್ ನೌ ಘಂಟಾನ ಪಾಛೊ಼ ಘರ್‌ಥೊ ನಿಕ್ಳಿನ್, ಬಜಾ಼ರ್‌ನಿ ಝ಼ಗೋಕನ ಜೈ಼ನ್, ಹಿಜ್ಜಾ಼ ಥೋಡು ಜ಼ಣು ಫಾಯಿದೊಕೊಂತೆ ಭೀರ‍್ಯುಥೂತೆ ದೇಖಿನ್, ");
INSERT INTO vaa_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","ಇವ್ಣುನ, “ತುಮೇಬಿ ಮಾರ ದ್ರಾಕ್ಷಿನ ಬಾಗ್‌ಮ ಜೈ಼ನ್ ಕಾಮ್ ಕರೊ. ತುಮೂನ ಮೇ ನೀತಿನಿ ಕೂಲಿ ದೆವುಸ್’ ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","ತದೆ ಇವ್ಣೆ ಬಾಗ್‌ಮ ಗಯು. ಯೋ ಯಜಮಾನ್ ಪಾಛೊ಼ ಕಮ್‌ಶಿಕಮ್ ಭಾರ ಘಂಟಾನ ಅಜು಼ ತೀನ್ ಘಂಟಾನ ಏಕ್‌ ಹಲ್ಲ ಬಜಾ಼ರ್‌ನಿ ಝ಼ಗೋಕನ ಗಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","ಖ್ಹುಮಾರ್ ಪಾಚ಼್ ಘಂಟಾನ ಏಕ್‌ ಹಲ್ಲ ಯೋ ಯಜಮಾನ್ ಬಿಜೇಕ್ ಹಲ್ಲ ಬಜಾ಼ರ್‌ನಿ ಝ಼ಗೋಕನ ಜೈ಼ನ್, ಹಿಜ್ಜಾ಼ ಭೀರ‍್ಯುಥೂತೆ ಥೋಡ ಅದ್ಮಿನ ಇನೆ ದೇಖಿನ್, ‘ತುಮೆ ದನ್‌ಭರ್ ಫಾಯಿದೊಕೊಂತೆ ಚು಼ಪ್‌ಕೆಸ್ ಶನ ಭೀಯಾಸ್?’ ಕರಿ ಪುಛಾ಼ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","ತದೆ ಇವ್ಣೆ, ‘ಕೋಣ್‌ಬಿ ಹಮೂನ ಕಾಮ್ನ ಬುಲಾಯು ಕೊಯ್ನಿ’ ಕರಿ ಬೋಲ್ಯು. ಯೋ ಯಜಮಾನ್ನೆ, ‘ಇಮ್‍ಕತೊ, ತುಮೆ ಜೈ಼ನ್, ಮಾರ ದ್ರಾಕ್ಷಿನ ಬಾಗ್‌ಮ ಕಾಮ್ ಕರೊ’ ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","ಖ್ಹಾಂಜ಼್ ಹುವ್ವಾದೀನ್, ಬಾಗ್‌ನೊ ಯಜಮಾನ್ನೆ ಕಾಮ್ ಕರಾವಾಳಾನ ದೇಖಿಲೇಸ್ತೆ ಇನ ಬುಲೈನ್, ‘ಖ್ಹಾರೇಥಿ ಪಾಛ಼ಳ್ ಆಯೂತೆ ಆಳ್‌ಥಿ ಶುರುಕರೀನ್, ಪಹಿಲೆ ಆಯೋತೆ ಆಳ್‌ತೋಡಿ ಖ್ಹಾರಾನಿ ಕೂಲಿನ ದೇ’ ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","ಪಾಚ಼್ ಘಂಟಾನ ಕೂಲಿನ ಆಯುಥೂತೆ ಆಳ್‌ ಖ್ಹಾರಾನಾಬಿ ಏಕೇಕ್‌ ರೂಪಾನುಬಿಲ್ಲಾ ಮಳ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","ಅನಕೇಡೆಥು ಪಹಿಲೆ ಕಾಮ್‌ಪರ್ ಆಯುಥೂತೆ ಇವ್ಣೆ ಆಯಿನ್, ಹಮೂನ ಜಾ಼ಖ್ಹತ್ ಕೂಲಿ ಮಳ್‌ಶೆ ಕರಿ ಸೋಚ್ಯು; ಕತೋಬಿ ಇವ್ಣುನಾಬಿ ಏಕೇಕ್‌ ರೂಪಾನುಬಿಲ್ಲಾ ಮಳ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","ಇವ್ಣೆ ಯೋ ಪೈಶಾನ ಲೀಲಿನ್‌, ಯೋ ಬಾಗ್‌ನ ಯಜಮಾನ್‍ಪರ್ ಮಶ್ಲಾ ಮಾರ್‌ತುಹುಯಿನ್, ");
INSERT INTO vaa_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘ಪಾಛ಼ಳ್ ಆಯೂತೆ ಆ ಎಕ್ಕಸ್ ಘಂಟೊ ಕಾಮ್ ಕರ‍್ಯು, ಕತೋಬಿ ಹಮೆಖ್ಹಾರು ದನ್‌ಭರ್ ತಡ್ಕಾಮ ಮ್ಹಿನತ್ ಕರೀನ್, ಕಾಮ್ ಕರ‍್ಯಾ, ತೋಬಿ ತುನೆ ಹಮೂನ ದಿದೋತೆ ಎತ್ರುಸ್ ಇವ್ಣುನಾಬಿ ದಿದೋನಿ!’ ಕರಿ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","ತದೆ ಬಾಗ್‌ನೊ ಯಜಮಾನ್ನೆ ಯೋ ಆಳ್‌ಮ ಏಕ್‌ನ, ‘ಹಂದೇಕ್‍ಲ, ದೋಸ್ತ್, ಮೇ ತುನ ಠಗಾಯೊ ಕೊಯ್ನಿ. ತೂ ಏಕ್‌ ರೂಪಾನ ಕಾಖ್ಹ್‌ನಖ್ಹಾಜೆ ಏಕ್‌ ದನ್ನು ಕಾಮ್ ಕರುಸ್ ಕರಿ ಮಾನಿಗಯೊಥೋನಿ? ");
INSERT INTO vaa_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","ಅಲ್ಲೆ, ತಾರಿ ಕೂಲಿ, ಅನ ಲೀನ್ ಘರೆ ಜಾ಼. ತುನ ದಿದೋತೆ ಇಮ್ಮಸ್, ಆ ಪಾಛ಼ಳ್ ಆಯೋತೆ ಇನಾಬಿ ಮನ ಮನ್ ಛಾ಼. ");
INSERT INTO vaa_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","ಮಾರ ಶೊಂತ್ ಪೈಶಾನ ಮಾರು ಮನ್ಆವಾತೆ ಇಮ್‌ ಕರಾನ ಮನ ಹಕ್‍ಕೊಯ್ನಿಕಿ ಶು? ಮೇ ಇವ್ಣುನ ಅಛ಼್ಛು ಕರ‍್ಯೊತೆ ಇನಖ್ಹಾಜೆ ತೂ ಬಳಾಪೊ ಕರಾಸ್ಕಿ ಶು?’ ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","“ಅಮ್ಮಸ್ ಪಾಛ಼ಳ್ ರ‍್ಹವಾಳು ಅಗಾಡಿ ಹುಯಿಜಾ಼ಶೆ, ಅಜು಼ ಅಗಾಡಿ ರ‍್ಹವಾಳು ಪಾಛ಼ಳ್ ಹುಯಿಜಾ಼ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","ಯೇಸು ಯೆರೂಸಲೇಮ್ಮ ಜ಼ವ್‍ಕರಾನಿ ವಖ್ಹತ್‌ಮ, ಭಾರ ಜ಼ಣ ಶಿಷ್ಯರ್‌ನ ಏಕ್‌ ತರಬ್‌ ಬುಲೈನ್, ವಾಟ್‌ಪರ್ ಚಾ಼ಲ್ತೊಹುಯಿನ್‌, ಇವ್ಣುನ, ");
INSERT INTO vaa_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“ಹಂದೇಖೊ, ಅಪ್ಣೆ ಯೆರೂಸಲೇಮ್‌ನ ವಳ್ಯಾಜಯ್ಯೇಸ್‌, ಹಿಜ್ಜಾ಼ ಅದ್ಮಿನೊ ಛಿಯ್ಯಾನ ಗಲ್‌ಢಯಾಜಕರ್‌ನ ಅಜು಼ ಮೋಶೆನಿ ವಚನ್ ಶಿಕಾಡವಾಳ ಶಾಸ್ತ್ರಿಯೇನ ಹಾತ್‌ಮ ಧರಿದಿನಾಕ್‌ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","ಇವ್ಣೆ ಇನ ಮರಣ್ ದಂಡ್‌ ದೀನ್, ಇನ ಖ್ಹರಮ್‌ ಕಾಡಾನ, ಕೊಳ್ಡೇಥಿ ಮಾರಾನ ಅಜು಼ ಶಿಲ್‌ಬೇಪರ್ ನಾಖಾನಖ್ಹಾಜೆ ಪರೈ ಜಾ಼ತ್‌ವಾಳಾನ ಹಾತ್‌ಮ ದಿನಾಕ್‌ಶೆ. ಕತೋಬಿ ಮರೀನ್ ತೀನ್ ದನ್‌ಕೇಡೆ ಯೋ ಪಾಛೊ಼ ಜಿವ್ತೊಹುಯಿನ್ ಆವ್‌ಶೆ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","ತದೆ ಜೆಬೆದಾಯನಿ ಬಾವಣ್‍ ಇನ ಭೇ ಪರ್ಖ್ಹಾ ಲಡ್ಕಾನ ಜೋ಼ಡೆ ಯೇಸುಕನ ಐನ್, ಇನಖ್ಹಾಮ್ಣೆ ಆಡ್‍ಪಡಿನ್, ಮಾರಿ ಏಕ್‌ ಬಿಂತಿನ ಚ಼ಲೈದೇಣು ಕರಿ ಬೋಲಿಲಿದಿ. ");
INSERT INTO vaa_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","ಯೇಸುನೆ ಇನ, “ತುನ ಶಾತ್ ಹೋಣು?” ಕರಿ ಪುಛಾ಼ಯೊ. ತದೆ ಇನೆ, “ಮನ ಹುಕುಮ್‌ಕರ್‌ ತಾರಿ ರಾಜ್ಯಮ ಮಾರ ಬೇ ಛಿಯ್ಯಾಮ ಏಕ್‌ ಜ಼ಣೊ ತಾರಿ ಖಾವಿ ಬಾಜು಼ಮ ಅಜು಼ ಏಕ್‍ಜ಼ಣೊ ತಾರಿ ಡಾವಿ ಬಾಜು಼ಮ ಬೇಖ್ಹಾನ ಬೋಲ್‌ಕರಿ ಬೋಲಿ ");
INSERT INTO vaa_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","ಯೇಸುನೆ ಇನ ಛಿಯ್ಯಾವ್‍ನ, “ತುಮೆ ಶಾತ್ ಮಾಂಗಿಲಿದ ಕರಿ ತುಮೂನ ಮಾಲುಮ್ ಕೊಯ್ನಿ. ಮೇ ಪೀಣುತೆ ಖ್ಹತಾಪ್ಣಿನ ರಾಛ಼ಮ ತುಮೆ ಪಿಯ್ಯಾನ ಉಶೇಕಿ ಶು?” ಕರಿ ಪುಛಾ಼ಯೊ. ಇನ ಇವ್ಣೆ, “ಹಮೂನ ಹುವಾಸ್” ಕರಿ ಜ಼ವಾಬ್‍ದಿದಾ. ");
INSERT INTO vaa_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","ತದೆ ಯೇಸುನೆ ಇವ್ಣುನ, “ಮೇ ಪೀಣುತೆ ರಾಛ಼ಮ ತುಮೇಬಿ ಪೀಶು. ಕತೋಬಿ ಮಾರಿ ಖಾವಿ ಬಾಜೂ಼ಮ ಅಜು಼ ಡಾವಿ ಬಾಜೂ಼ಮ ಕೋಣ್ ಬೇಖ್ಹ್‌ಶೆ ಕರಿ ಚೂ಼ಣವಾಳೊ ಮೇ ಕಾಹೆ. ಮಾರೊ ಬಾ ಯೋ ಝ಼ಗೋನ ಕಿನ ಕರಿ ಮ್ಹೇಲಿರಾಖ್ಯೋಸ್ಕಿ ಇವ್ಣುನಾಸ್ ಯೋ ಮಳ್‌ಶೆ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","ಉಬ್‌ರ‍್ಯಾತೆ ದಖ್ಹ್‌ ಜ಼ಣ ಶಿಷ್ಯರ್‌ನೆ ಅನ ಖ್ಹಮ್‌ಜಿನ್‌, ಯೋ ಬೇ ಭೈಯೇಪರ್ ಖೀಜ಼್‌ಖಾದ. ");
INSERT INTO vaa_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","ಕತೋಬಿ ಯೇಸುನೆ ಇವ್ಣ ಖ್ಹಾರಾನ ಇನಾಕನ ಬುಲೈನ್ ಇವ್ಣುನ, “ಯೆಹೂದ್ಯರ್‌ಕಾಹೆತೆ ಅದ್ಮಿನ ಅದಿಕಾರ್‌ಮ ರ‍್ಹವಾಳು ಇವ್ಣಾಪರ್ ಹಂಕಾರ್‌ಥಿ ಅದಿಕಾರ್ ಚ಼ಲಾವಸ್, ಅಜು಼ ಮೋಟು ಅದಿಕಾರಿಖ್ಹಾರು ಇವ್ಣಪರ್ ಜು಼ಲಮ್‌ಥಿ ಹಕ್ನ ಚ಼ಲಾವಸ್ ಕರಿ ಹಮೂನ ಮಾಲುಮ್. ");
INSERT INTO vaa_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","ಕತೋಬಿ ತುಮಾರಮ ಇಮ್‌ ನಾರ‍್ಹೇವ್ಣು. ತುಮಾರಮ ಕೋಣ್‌ತೋಬಿ ಮೋಟು ಹೋಣು ಕರಿ ಉಶೇತೊ, ಯೋ ತುಮಾರೊ ಸೇವಕ್ ಹುಯಿರ‍್ಹವಾದೆ. ");
INSERT INTO vaa_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","ಅಜು಼ ತುಮಾರಾಮ ಅಖ್ಖೇಥಿ ಖ್ಹಾಮ್ಣೆ ರ‍್ಹವಾನ ಆಖ್ಹ್‌ಕರವಾಳೊ ಕೋಣ್‌ತೋಬಿ ಉಶೇತೊ, ಯೋ ತುಮಾರೊ ಸೇವಕ್ ಹುಯಿರ‍್ಹೇಣು. ");
INSERT INTO vaa_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","ಅಮ್ಮಸ್ ಅದ್ಮಿನೊ ಛಿಯ್ಯೋಬಿ ಸೇವೆ ಕರೈಲ್ಯವಾನಖ್ಹಾಜೆ ಕೋ ಆಯೋನಿ, ಪಣ್ಕಿ ಸೇವೆ ಕರಾನ ಅಜು಼ ಇನೊ ಜಾನ್ನ ದೀನ್, ಕೈಯೆಕ್ಕಿ ಅದ್ಮಿನ ಛೋ಼ಡೈಲ್ಯವಾನಖ್ಹಾಜೆ ಆಯೊ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","ಯೇಸು ಅಜು಼ ಇನ ಶಿಷ್ಯರ್‌ ಯೆರಿಕೋಥು ಚ಼ಲ್ಯಾಜ಼ವ್‍ಕರ್ತಥಾತೆ ವಖ್ಹತ್‌ಮ, ಅದ್ಮಿನಿ ಮೋಟಿ ಭೀಡ್ ಇನ ಪೀಠೆ ಗಯು. ");
INSERT INTO vaa_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","ತದೆ ಮಾರಗ್‌ನ ಶೇಡೆ ಬೆಠಾಥಾತೆ ಬೇ ಜ಼ಣ ಕಾಣಾನ ಯೇಸು ಹಜ್ಜಾ಼ಸ್‌ಕರಿ ವಳ್ಯೊಜಾ಼ಸ್ ಕರಿ ಖ್ಹಮ್‌ಜಿನ್‌, “ಪ್ರಭು, ದಾವೀದ್‌ನ ಛಿಯ್ಯಾ! ಹಮಾರಪರ್ ಗೋರ್‌ಕರ್‌” ಕರಿ ಚಿಕ್ರಾಲಗ್ಯಾ. ");
INSERT INTO vaa_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","ಯೋ ಭೀಡ್‌ಮ ಥೂತೆ ಅದ್ಮಿಖ್ಹಾರು ಇವ್ಣುನ ಗುರ್‌ಕೈನ್, “ಖ್ಹೊಪೇಥಿರ‍್ಹವೊ” ಕರಿ ಬೋಲ್ಯು. ತೋಬಿ ಭೇ ಕಾಣಾವ್ನೆ ಬಿಜೂ಼ಬಿ ಜೋ಼ರೇಖ್ಹು ಚಿಕ್ರಿನ್, “ಪ್ರಭು, ದಾವೀದ್‌ನ ಛಿಯ್ಯಾ! ಹಮಾರಪರ್ ಗೋರ್‌ ಕರ್‌” ಕರಿ ಬೋಲ್ಯ. ");
INSERT INTO vaa_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","ತದೆ ಯೇಸುನೆ ಭೀರಿನ್, ಇವ್ಣುನ ಬುಲೈನ್, “ಮೇ ತುಮೂನ ಶಾತ್ ಕರ‍್ನು?” ಕರಿ ಇವ್ಣುನ ಪುಛಾ಼ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","ಇವ್ಣೆ, “ಪ್ರಭು, ಹಮಾರ ಡೋಳಾ ದೆಖಾವಾನಿಘೋಣಿ ಕರ್ಲಾ!” ಕರಿ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","ತದೆ ಯೇಸುನೆ ಇವ್ಣಾಪರ್ ಗೋರ್‌ಖೈನ್, ಇವ್ಣ ಡೋಳಾನ ಛೀಮ್ಯೊ. ತದ್‌ನು ತದ್ದೇಸ್ ಇವ್ಣ ಡೋಳಾ ಐಗಯ, ಅಜು಼ ಇವ್ಣೆ ಇನ ಪೀಠೆ ಗಯ. ");
INSERT INTO vaa_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","ಯೇಸು ಅಜು಼ ಇನ ಶಿಷ್ಯರ್‌ ಯೆರೂಸಲೇಮ್‌ನ ಖನ್ನೆ-ಖನ್ನೆ ಐನ್, ಆಲಿವ್ ಪಹಾಡ್‌ಕನ ಛಾ಼ತೆ ಬೆತ್ಫಗೆ ಕರಿ ಗಾಮ್‌ಕನ ಆಯಾ. ತದೆ ಯೇಸುನೆ ಇನ ಬೇ ಶಿಷ್ಯರ್‌ನ ಬುಲೈನ್, ");
INSERT INTO vaa_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","“ತುಮಾರ ಖ್ಹಾಮ್ಣೆ ಛಾ಼ತೆ ಗಾಮ್ಮ ಜಾ಼ವೊ, ಜಾ಼ತಸ್‌ನ ಹಿಜ್ಜಾ಼ ಭಂದೈರ‍್ಹೀಶೆತೆ ಗಧೇಡಾನ ಅಜು಼ ಇನಜೋ಼ಡೆ ಛಾ಼ತೆ ಇನ ಚೆಲ್ಕಾನ ದೇಕ್‌ಶು; ಯೋ ಭೇನ ಛೋ಼ಡಿಲಿನ್, ಮಾರಕನ ಲ್ಯಾವೊ. ");
INSERT INTO vaa_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","ಕೋಣ್‌ತೋಬಿ ತುಮೂನ ಶಾತ್‌ತೋಬಿ ಬೋಲ್ಯೂತೊ, ‘ಪ್ರಭುನ ಆ ಹೋಣುಕಸ್; ಅಜು಼ ಒಗ್ಗಿಸ್‌ಮ ಯೋ ಅನ ಮೋಕ್ಲಿದಿಶೆ’ ಕರಿ ಬೋಲೊ” ಕರಿ ಬೋಲಿನ್ ಮೋಕ್‌ಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","ಏಕ್‌ ಪ್ರವಾದೀನ ಮ್ಹೋಡವಾಟೆ ಬೋಲಾಯೋತೆ ವಾತೆ ಚಾ಼ಲಾನಖ್ಹಾಜೆ ಅಮ್ ಹುಯೂತೆ: ಯೋ ವಾತೆ ಶಾತ್ ಕತೊ, ");
INSERT INTO vaa_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","ಚೀಯೋನ್ ನಂಗರ‍್ನ ಬೋಲೊ, ದೇಕ್ ತಾರೊ ರಾಜ಼ ತಾರಕನ ವಳ್ಯಾವಸ್, ಯೋ ಖ್ಹುದ್‌ನ ಝು಼ಕೈಲೀನ್, ಗಧೇಡಾಪರ್ ಬೇಶಿನ್, ಒಹೊ, ಗಧೇಡಾನ ಚೆಲ್ಕಪರ್‌ ಬೇಶಿನ್ ವಳ್ಯಾವಸ್’ ಕರಿ ಬೋಲಾನುಸ್. ");
INSERT INTO vaa_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","ತದೆ ಶಿಷ್ಯರ್‌ ಜೈ಼ನ್, ಯೇಸುನೆ ಇವ್ಣುನ ಬೋಲ್ಯೋತೆ ಇಮ್ಮಸ್ ಕರ‍್ಯು. ");
INSERT INTO vaa_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","ಇವ್ಣೆ ಗಧೇಡಾನ ಅಜು಼ ಗಲ್‌ಢ ಚೆಲ್ಕಾನ ಲೈನ್‌, ಇನಪರ್ ಇವ್ಣ ಲುಂಗ್ಡಾವ್‍ನ ನಾಖ್ಯು. ಯೇಸು ಇನಾಪರ್ ಚ಼ಢೀನ್ ಬೇಶಿಗಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","ತದೆ ಅದ್ಮಿನಿ ಝೂ಼ಂಡ್‌ಮ ಥೂತೆ ಘಣು ಅದ್ಮಿ ಇವ್ಣ ಲುಂಗ್ಡಾವ್‍ನ ವಾಟ್‌ಪರ್ ಬಿಛಾ಼ಯು, ಬಿಜು಼ ಥೋಡಾನೆ ಝಾ಼ಡಾನಿ ಡಾಳಿಯೇನ ಕತ್ರಿಲೈನ್, ವಾಟ್‌ಪರ್ ನಾಖ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","ಯೇಸುನ ಖ್ಹಾಮ್ಣೆ ಅಜು಼ ಪೀಠೆ ಝೂ಼ಂಡ್‌ಥಿ ವಳ್ಯುಜಾ಼ತುಥೂತೆ ಅದ್ಮಿಖ್ಹಾರು, “ದಾವೀದ್‌ನ ಛಿಯ್ಯಾನ ಸ್ತುತಿಹುವ್ವಾದೆ! ಪ್ರಭು ದೇವ್ನ ನಾಮ್‌ಪರ್‌ ಆವಾಳಾನ ಆಶೀರ್ವಾದ್‌ ಹುವಾದೆ! ಉಪ್ಪರ್‌ಲ್ಯ ಲೋಕಾಮ ದೇವ್ನ ಧನ್ಯವಾದ್ ಹುವಾದೆ!” ಕರಿ ಚಿಕ್‌ರ‍್ಯು. ");
INSERT INTO vaa_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","ಯೇಸು ಯೆರೂಸಲೇಮ್‌ನ ಜಾ಼ವಾದಿನ್, ಯೋ ಖ್ಹಯೇರ್ ಅಖ್ಖುಸ್ ಚಿಕ್ರಾಣ್ ಪಡೀನ್, “ಆ ಕೋಣ್?” ಕರಿ ಅದ್ಮಿಖ್ಹಾರು ಪುಛಾ಼ಯು. ");
INSERT INTO vaa_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","ತದೆ ಯೋ ಅದ್ಮಿನಿ ಝೂ಼ಂಡ್‌ನೆ, “ಆ ಪ್ರವಾದಿ ಹುಯಿರ‍್ಹೋತೆ ಯೇಸು, ಆ ಗಲಿಲಾಯಾನು ನಜ಼ರೇತ್‌ವಾಳೊ” ಕರಿ ಜವಾಬ್‌ ದಿದು. ");
INSERT INTO vaa_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","ಯೇಸು ಮಂದಿರ್‌ಮ ಜೈ಼ನ್, ಹಿಜ್ಜಾ಼ ವೇಚ಼ವಾಳ ಅಜು಼ ಲ್ಯವಾಳ ತಮಾಮ್‌ ಅದ್ಮಿನ ಭಾರ್‌ ನಖ್ಹಾಡಿದಿದೊ. ಪೈಶಾ ತೋಡಾವಾನು ಧಂದೊ ಕರಾವಾಳಾನ ಅಜು಼ ಪರ‍್ಯಾವೊ ವೇಚ಼ವಾಳಾನು ಮೇಜ್‌ನ ರಡ್‌ಕೈನಾಖಿದಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","ಅಜು಼ ಇವ್ಣ ಖ್ಹಾರಾನ, “ದೇವ್ನೆ ಬೋಲ್ಯೋತೆ ಇಮ್‌, ‘ಮಾರಿ ಮಂದಿರ್‌ ಪ್ರಾರ್ಥನೇನು ಘರ್ ಕರಿ ಬೋಲೈಲಿಶೆ’ ಕರಿ ವಚನ್‌ಮ ಲೀಖೈರ‍್ಹೂಸ್‌ನಿ ಕತೋಬಿ ತುಮೆ ಇನ ಚೋ಼ರ್‌ನಿ ಲಪಾನಿ ಘವಿ ಕರುಕರಸ್!” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","ತದೆ ಕಾಣು ಅಜು಼ ಲಂಗ್ಡುಖ್ಹಾರು ಮಂದಿರ್‌ಮ ಇನಾಕನ ಆಯು, ಯೇಸುನೆ ಇವ್ಣುನ ಅಛ್ಛು಼ ಕರ‍್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","ಕತೋಬಿ ಗಲ್‌ಢಯಾಜಕರ್‌ ಅಜು಼ ಮೋಶೆನಿ ವಚನ್ ಶಿಕಾಡವಾಳ ಶಾಸ್ತ್ರಿಯೇನೆ ಯೇಸುನೆ ಕರ‍್ಯೊತೆ ಆಶ್ಚರ್ಯನು ಕಾಮ್ನಖ್ಹಾರು ಅಜು಼ ದಾವೀದ್‌ನ ಛಿಯ್ಯಾನ ಸ್ತುತಿಹುವ್ವಾದೆ ಕರಿ ಮಂದಿರ್‌ಮ ಚಿಕ್ರುಕರ್ತುಥೂತೆ ಲಡ್ಕಾವ್ನ ದೇಖಿನ್, ಖೀಜ಼್‌ಖಾದು. ");
INSERT INTO vaa_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","ಇನಖ್ಹಾಜೆ ಇವ್ಣೆ ಯೇಸುನ, “ಅವ್ಣೆ ಬೋಲುಕರಾತೆ ಇನ ತೂ ಖ್ಹಮ್‌ಜು಼ಕರಾಸ್ಕಿ ಶು?” ಕರಿ ಪುಛಾ಼ವ್‌ತಾನ, ಯೇಸುನೆ, “ಓಹೊ, ಖ್ಹಮ್‌ಜು಼ಕರೂಸ್, ‘ಅಡ್ಡಾಣಿ ಲಡ್ಕಾವ್‍ನ ಮ್ಹೋಡವಾಟೆ ಅಜು಼ ದೂದ್ ಪಿಯ್ಯಾವಾಳ ಲಡ್ಕಾವ್ನ ಮ್ಹೋಡವಾಟೆ ಸ್ತುತಿ ಕರಾಯೊ’ ಕರಿ ವಚನ್‌ಮ ಛಾ಼ತೆ ಇನ ತುಮೆ ಪಢ್ಯಾಕೊಯ್ನಿಕಿ ಶು?” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","ಅನಕೇಡೆಥು ಯೇಸು ಇವ್ಣುನ ಮ್ಹೆಂದಿನ್, ಖ್ಹಯೇರ್‌ಥು ನಿಕ್ಳಿನ್, ಬೇಥಾನ್ಯ ಗಾಮ್ಮ ಐನ್, ಹಿಜ್ಜಾ಼ಸ್ ರಾತ್‌ ಕಾಡ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","ತಿನವ್ಹಾಣೆ ಯೇಸು ಪಾಛೊ಼ಫರಿ ಯೆರೂಸಲೇಮ್‌ ಖ್ಹಯೇರ‍್ನ ಜಾ಼ವಾನಿ ವಖ್ಹತ್‌ಮ, ಯೇಸುನ ಭುಕ್‌ಲಾಗ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","ಇನೆ ವಾಟ್ನ ಶೇಡೆಏಕ್‌ ಅಂಜೀರ್‌ನ ಝಾ಼ಡಾನ ದೇಖಿನ್, ಇನಖನ್ನೆ ಜೈ಼ನ್, ಇನಾಮ ಖಲಿ ಪಾಂದ್‍ಡುಸ್ ಪಣ್ಕಿ, ಬಿಜು಼ ಶಾತ್ಬಿ ಕೋಥುಂತೆ ದೇಖಿನ್, “ಅನಾಪರ್‌ಥು ತೂ ಬಿಜು಼ ಕದೆಕದೇಬಿ ಪಂಡು ನಾ ಮ್ಹೇಲ್‌ನೂತೆ ಇಮ್‌ ಹುವಾದೆ!” ಕರಿ ಬೋಲ್ಯೊ. ತದ್‌ನು-ತದ್ದೇಸ್ ಯೋ ಅಂಜೀರ್‌ನು ಝಾ಼ಡು ಖ್ಹುಕೈಗಯು. ");
INSERT INTO vaa_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","ಶಿಷ್ಯರ್‌ನೆ ಅನ ದೇಖಿನ್, ಆಶ್ಚರ್ಯಖೈನ್, “ಅಂಜೀರ್‌ನು ಝಾ಼ಡ್ ಎಕ್ಕಸ್ ಘಡೀಮ ಖ್ಹುಕೈಗಯೂತೆ ಕಿಮ್?” ಕರಿ ಪುಛಾ಼ಯ. ");
INSERT INTO vaa_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","ಯೇಸುನೆ, “ತುಮುನ ಖ್ಹಾಚ ಬೋಲುಸ್, ತುಮೆ ಗುಮಾನಿ ಕರಾಕೊಂತೆ ಇಮ್‌ ವಿಶ್ವಾಸ್ ಕರ‍್ಯಾತೊ, ಮೇ ಆ ಅಂಜೀರ್‌ನ ಝಾ಼ಡಾನ ಕರ‍್ಯೊತೆ, ಇಮ್ಮಸ್, ತುಮೇಬಿ ಕರ್ಶು. ಅಜು಼ ಎತ್ರೆಸ್ ಕಾಹೆತೆ,ಆ ಪಹಾಡ್‌ನ, ‘ತೂ ಉಖ್‌ಡೈ ಜೈ಼ನ್, ದರ‍್ಯಾವ್‌ಮ ಪಡ್’ ಕರಿ ಬೋಲ್ಯಾತೋಬಿ ಯೋ ಉಶೆ. ");
INSERT INTO vaa_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","ತುಮೆ ನಂಬಿನ್, ಪ್ರಾರ್ಥನೆಮ ಶಾತ್ ಮಾಂಗೋಸ್‌ಕಿ ಯೋ ತುಮೂನ ಮಳ್‌ಶೆ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","ಯೇಸು ಪಾಛೊ಼ ಮಂದಿರ್‌ಮ ಐನ್, ವಚನ್ನ ಬೋಲಿದೆವ್‍ಕರಾನಿ ವಖ್ಹತ್‌ಮ, ಗಲ್‌ಢಯಾಜಕರ್‌ ಅಜು಼ ಶಾಣುಖ್ಹಾರು ಇನಾಕನ ಆಯಿನ್, “ತೂ ಖೆವಿ ಹಕ್‌ಥಿ ಆ ಖ್ಹಾರು ಕರುಕರಸ್? ಆ ಹಕ್ನ ತುನ ದಿದೂತೆ ಕೋಣ್?” ಕರಿ ಪುಛಾ಼ಯು. ");
INSERT INTO vaa_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","ಯೇಸುನೆ ಇವ್ಣುನ, “ಮೇ ತುಮೂನ ಏಕ್‌ ಸವಾಲ್ ಪುಛಾ಼ವ್‍ಸ್, ತುಮೆ ಮನ ಜ಼ವಾಬ್ ದಿದಾತೊ, ಮೇ ಹಕ್‌ಥಿ ಆ ಖ್ಹಾರು ಕರುಸ್ ಕರಿ ತುಮೂನ ಬೋಲುಸ್. ");
INSERT INTO vaa_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","ಬ್ಯಾಪ್ತಿಸ್ಮ ದ್ಯವಾನಿ ಹಕ್ ಯೋಹಾನ್ನ ಕಿಜ್ಜಾ಼ಥಿ ಆಯಿ? ಪರಲೋಕ್‌ಥೀಕಿ, ನತರ್‌ಕಿ ಅದ್ಮಿಥಿ?” ಕರಿ ಪುಛಾ಼ಯೊ. ತದೆ ಇವ್ಣೆ, “ದೇವ್‍ಥಿ ಆಯು ಕರಿ ಅಪ್ಣೆ ಬೋಲ್ಯಾತೊ, ‘ಇಮ್‍ಕತೊ, ತುಮೆ ಇನ ಶನ ನಂಬ್ಯಾಕೊಯ್ನಿ’ ಕರಿ ಅಪ್ಣುನ ಬೋಲ್‌ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","‘ಅದ್ಮಿಥಿ ಆಯು’ ಕರಿ ಬೋಲ್ಯಾತೊ, ಅಪ್ಣುನ ಅದ್ಮಿನೊ ಡರ್‌ ಛಾ಼” ಕರಿ ಇವ್ಣ-ಇವ್ಣ ಮಹಿಸ್ ಬೋಲಿಲಿದು. ಶನಕತೊ, ಯೋಹಾನ ಏಕ್‌ ಪ್ರವಾದಿ ಕರಿ ತಮಾಮ್‌ ಅದ್ಮಿ ಶಕ್‌ಕೊಂತೆ ಇಮ್‌ ನಂಬಿರಾಖ್ಯುಥು. ");
INSERT INTO vaa_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","ಇನಖ್ಹಾಜೆ ಇವ್ಣೆ, “ಹಮೂನ ಮಾಲುಮ್ ಕೊಯ್ನಿ” ಕರಿ ಯೇಸುನ ಜ಼ವಾಬ್ ದಿದು. ತದೆ ಯೇಸುನೆ ಇವ್ಣುನ, “ಮೇಬಿ ಖೆವಿ ಹಕ್‌ಥಿ ಆ ಖ್ಹಾರು ಕರುಸ್ ಕರಿ ತುಮೂನ ಕೋ ಬೋಲೂನಿ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“ಕತೋಬಿ ತುಮೂನ ಕಿಮ್ ದೆಖಾವಸ್? ಏಕ್‌ ಅದ್ಮಿನ ಬೇ ಛಿಯ್ಯಾ ಥಾ. ಇನೆ ಇನ ಮೋಟಾ ಛಿಯ್ಯಾಕನ ಜೈ಼ನ್, ‘ಛಿಯ್ಯಾ, ಆಜ಼್ ತೂ ಜೈ಼ನ್, ದ್ರಾಕ್ಷಿನ ಬಾಗ್‌ಮ ಕಾಮ್ ಕರ್‌’ ಕರಿ ಬೋಲ್ತಾನ, ");
INSERT INTO vaa_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","ಇನೆ, ‘ಮೇ ಕೋ ಜ಼ವ್‍ನಿ’ ಕರಿ ಬೋಲೀನ್‌ಬಿ, ಬಾದ್‌ಮ ಮನ್ ಫರೈಲಿನ್, ಬಾಗ್‌ಮ ಗಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","ಇನಕೇಡೆಥು ಬಾನೆ ನ್ಹಾನ ಛಿಯ್ಯಾಕನ ಜೈ಼ನ್, ಯೋಸ್ ವಾತೇನ ಬೋಲ್ಯೊ. ತದೆ ಇನೆ, ‘ಜ಼ವುಸ್‌ಲಾ ಬಾ’ ಕರಿ ಬೋಲಿನ್‌ಬಿ ಕೋಸ್‍ಗಯೋನಿ. ");
INSERT INTO vaa_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","ಇವ್ಣ ಭೇಮ ಬಾನಿ ಮರ್ಜಿನಿಘೋಣಿ ಚಾ಼ಲಿಲಿದುತೆ ಕೋಣ್?” ಕರಿ ಪುಛಾ಼ವ್‌ತಾನ, ಇವ್ಣೆ, “ಮೋಟೊ ಛಿಯ್ಯೋಸ್” ಕರಿ ಬೋಲ್ಯು. ತದೆ ಯೇಸುನೆ ಇವ್ಣುನ, “ಮೇ ತುಮೂನ ಖ್ಹಾಚ ಬೋಲುಸ್: ಶುಂಕ ಮಾಂಗವಾಳು ಅಜು಼ ಶೂಳೆ ತಯೇಡ ಖ್ಹಾರಿ ತುಮಾರೇಥಿ ಅಗಾಡಿ ದೇವ್ನಿ ರಾಜ್ಯಮ ಜಾ಼ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","ಬ್ಯಾಪ್ತಿಸ್ಮ ದ್ಯವಾಳೊ ಯೋಹಾನ ತುಮಾರಕನ ಆಯಿನ್, ತುಮೂನ ಜಿವಾನೊ ಬರೋಬರ್‌ನ ಮಾರಗ್‌ನ ವತಾಳ್ಯೊ, ತೋಬಿ ತುಮೆ ಇನ ನಂಬ್ಯಾಕೊಯ್ನಿ; ಕತೋಬಿ ಶುಂಕ ಮಾಂಗವಾಳು ಅಜು಼ ವ್ಯಬಿಚಾರ್‌ ಕರವಾಳು ಖ್ಹಾರು ಇನ ನಂಬ್ಯು. ಅನ ದೇಖಿನ್‌ಬಿ ತುಮೆ ತುಮಾರು ಮನ್‍ಫರಾಯಕೊಯ್ನಿ, ಇನಾಬಿ ನಂಬ್ಯಾ ಕೊಯ್ನಿ. ");
INSERT INTO vaa_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“ಬಿಜೇಕ್ ಮತ್ಲಬ್‌ನಿ ಖೇಣಿನ ಖ್ಹಮ್‌ಜೊ಼: ಏಕ್‌ ಜ಼ಮೀನ್‌ದಾರ್ ಥೊ. ಇನೆ ಇನಿ ಜ಼ಮೀನ್‌ಮ ದ್ರಾಕ್ಷಿನೊ ಬಾಗ್‌ನ ಬಣೈನ್, ಇನ ಅಶ್‌ಪಿಶ್ ವಾಡ್‌ಗಿ ನಖೈನ್, ದ್ರಾಕ್ಷಿನೊರಖ್ಹ್ ಕಾಡಾನಖ್ಹಾಜೆ ಖಾಡ್ ಖೋಂದೈನ್, ಕಾವ್ಲಿನಖ್ಹಾಜೆ ಅಟ್‌ಲೊ ಭಂದಾಯೊ. ಅನಕೇಡೆಥು ಯೋ ಬಾಗ್‌ನ ಇನೆ ವಾರ್‌ನ ಕರಾವಾಳನ ಹಾತ್‌ಮ ದೀನ್, ದೇಖ್ಹ್‌ಪರ್ ಚ಼ಲೆಗಯೊ ಕರಿ ಯೇಸುನೆ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","ಪಂಡಾ ತೋಡಾನಿ ವಖ್ಹತ್ ಆವಾದಿನ್, ಇನ ಆವ್ಣುತೆ ಭಾಗ್‌ ಲ್ಯವಾನಖ್ಹಾಜೆ ಯೋ ವಾರ್‌ನ ಕರಿರಾಖವಾಳಕನ ಇನ ಆಳ್‌ನ ಖ್ಹಾರು ಮೋಕ್‌ಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","ಕತೋಬಿ ಯೋ ವಾರ್‌ನ ಕರಿರಾಖವಾಳಾವ್‍ನೆ ಇನ ಆಳ್‌ನ ಖ್ಹಾರು ಧರೀನ್, ಏಕ್‌ನ ಮಾರ‍್ಯು, ಬಿಜೇಕ್‌ನ ಮಾರಿಸ್‌ನಾಖ್ಯು, ಅಜು಼ ಏಕ್‌ನ ಬಂಡಾ ಫೇಕಿನ್ ಮಾರ‍್ಯು. ");
INSERT INTO vaa_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","ಯೋ ಬಾಗ್‌ನ ಯಜಮಾನ್ನೆ ಪಾಛೊ಼ ಅಗಾಡಿ ಮೋಕ್‌ಲ್ಯೋಥೋತೆ ಇನೇಥಿಬಿ ಜಾ಼ಖ್ಹತ್ ಆಳ್‌ನ ಖ್ಹಾರು ಮೋಕ್‌ಲ್ಯೊ. ವಾರ್‌ನ ಕರಿರಾಖವಾಳನೆ ಇವ್ಣುನಾಬಿ ಇಮ್ಮಸ್ ಕರ‍್ಯು. ");
INSERT INTO vaa_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","ಬಾದ್‌ಮ, ‘ಮಾರ ಛಿಯ್ಯಾನ ತೋಬಿ ಮರ್ಯಾದಿ ದಿಶೆ’ ಕರಿ ಬೋಲಿನ್, ಇನ ಛಿಯ್ಯಾನ ಇವ್ಣಾಕನ ಮೋಕ್‌ಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","ಕತೋಬಿ ಯೋ ವಾರ್‌ನ ಕರಿರಾಖವಾಳು ಖ್ಹಾರು ಇನ ಛಿಯ್ಯಾನ ದೇಖಿನ್, ‘ಆಸ್ ಮಾಲಿಕ್‌ನೊ ಛಿಯ್ಯೊ, ಆವೊ, ಅನ ಮಾರಿನಾಖಿದಿಯ್ಯೆ, ತದೆ ಇನು ಶೊತ್ ಅಪ್ಣು ಹುಯಿಜಾ಼ಶೆ’ ಕರಿ ಇವ್ಣ-ಇವ್ಣಾಮ ವಾತೆ ಬೋಲಿಲೀನ್, ");
INSERT INTO vaa_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","ಇನ ಧರೀನ್, ದ್ರಾಕ್ಷಿನ ಬಾಗ್‌ಥಿ ಭಾರ್ ಫೇಕಿನ್, ಇನ ಮಾರಿನಾಖ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","ಇಮ್‍ಕತೊ, ದ್ರಾಕ್ಷಿನೊ ಬಾಗ್‌ನೊ ಯಜಮಾನ್ ಆವಾದಿನ್, ಯೋ ವಾರ್‌ನ ಲೀರಾಖ್ಯುಥೂತೆ ಇವ್ಣುನ ಶಾತ್ ಕರ್ಶೆ?” ಕರಿ ಯೇಸುನೆ ಇವ್ಣುನ ಪುಛಾ಼ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","ಇವ್ಣೆ ಇನ, “ಯೋ ಖರಾಬ್ ಅದ್ಮಿ ಖ್ಹಾರಾನ ಮಾರಿನಾಖಿದೀನ್, ಖ್ಹುಗ್ಗೀನ ದನ್ಮ ಇನು ವಾಟೊ ಬರೋಬರ್‌ಥಿ ದ್ಯವಾಳ ಬಿಜ಼ ವಾರ್‌ನ ಕರಾವಾಳಾನ ಇನ ಬಾಗ್‌ನ ದಿಶೆ” ಕರಿ ಜವಾಬ್‌ ದಿದು. ");
INSERT INTO vaa_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","ಯೇಸುನೆ ಇವ್ಣುನ, “ಘರ್ ಭಾಂದಾವಾಳು ನಕೊಕರಿ ಧಕೇಲೈ ಗಯೋತೆ ಬಂಡೋಸ್, ಅಖ್ಖೇಥಿ ಹೋಣುತೆ ಕೋಣಾನೊ ಬಂಡೊ ಹುಯೊ. ‘ಆ ಪ್ರಭುನೇಸ್ ಕರ‍್ಯೊತೆ, ಆ ಅಪ್ಣ ಡೋಳಾಮ ಆಶ್ಚರ್ಯ ದೆಖಾವಸ್!’ ಕರಿ ಧರ್ಮಶಾಸ್ತ್ರಮ ಛಾ಼ತೆ ತುಮೆ ಕದೆತೋಬಿ ಪಢ್ಯಾಕೊಯ್ನಿಕಿ ಶು? ");
INSERT INTO vaa_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","ಇನಖ್ಹಾಜೇಸ್ ಮೇ ತುಮೂನ ಬೋಲುಸ್ಕಿ: ದೇವ್ನಿ ರಾಜ್ಯನ ತುಮಾರಕಂಥು ಕಾಡಿಲೀನ್, ದೇವ್ನಿ ಮರ್ಜಿನಿಘೋಣಿ ಚಾ಼ಲಾಸ್ತೆ ಅದ್ಮಿನ ದೆವಾವ್‌ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","ಆ ಬಂಡಾಪರ್ ಪಡಾವಾಳು ಟುಕ್‌ಡಾ-ಟುಕ್‌ಡಾ ಹುಯಿಜಾ಼ಶೆ; ಅಜು಼ ಆ ಬಂಡೊ ಕಿನಾಪರ್ ಪಡಾಸ್ಕಿ, ಇವ್ಣುನ ಬುಕ್‍ನು-ಬುಕ್‍ನು ಕರಿನಾಕ್‌ಶೆ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","ಗಲ್‌ಢಯಾಜಕರ್‌ ಅಜು಼ ಫರಿಸಾಯರ್‌ನೆ ಯೇಸುನೆ ಬೋಲ್ಯೋತೆ ಮತ್ಲಬ್‌ನಿ ಖೇಣಿಯೇನ ಖ್ಹಮ್‌ಜಿನ್‌, ಆ ಅಪ್ಣೀಸ್‌ ಬಾರೇಮ ಬೋಲ್ಯೋತೆ ಕರಿ ಮಾಲುಮ್‌ ಕರಿಲೀನ್, ");
INSERT INTO vaa_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","ಇನ ಧರ್‌ನು ಕರಿ ಕರ‍್ಯು. ಕತೋಬಿ ಅದ್ಮಿಖ್ಹಾರು ಯೇಸುನ ಪ್ರವಾದಿ ಕರಿ ಮಾನಿರಾಖ್ಯುಥೂತೆ ಇನಖ್ಹಾಜೆ ಅದ್ಮಿಥಿ ಡರಿಗಯು. ");
INSERT INTO vaa_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","ಯೇಸುನೆ ಬಿಜೂ಼ಬಿ ಮತ್ಲಬ್‌ನಿ ಖೇಣಿಥಿ ಅದ್ಮಿ ಖ್ಹಾರಾನ ಬೋಲ್ಯೋಕಿ, ");
INSERT INTO vaa_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“ಸೊರ್ಗಾನು ರಾಜ್ಯ ಇನ ಛಿಯ್ಯಾನಿ ವ್ಯಹಾ ಕರ‍್ಯೊತೆ ಏಕ್‌ ರಾಜಾ಼ನಿಘೋಣಿ ಛಾ಼. ");
INSERT INTO vaa_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","ಇನೆ ವ್ಯಹಾನು ಮಿಝ಼್‌ವಾನ್ ಖಾವಾನ ಬುಲಾಯೊಥೋತೆ ಮೆಹೆಮಾನ್ನಖ್ಹಾರು ಬುಲಾವಾನಟೇಕೆ ಇನ ಆಳ್‌ನ ಖ್ಹಾರು ಮೋಕ್‌ಲ್ಯೊ, ಕತೋಬಿ ಇವ್ಣುನ ಆವಾನ ಮನ್ ಕೋ ಥೂನಿ. ");
INSERT INTO vaa_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","ತದೆ ಇನೆ ಪಾಛೊ಼ ಬಿಜಾ಼ಖ್ಹಾರ ಆಳ್‌ನ ಬುಲೈನ್, ‘ತುಮೆ ಜೈ಼ನ್, ಮೇ ಮಿಝ಼್‌ವಾನ್ನ ಬುಲಾಯೊಥೋತೆ ಇವ್ಣುನ, ಹಂದೇಖೊ, ಮಿಝ಼್‌ವಾನ್ ತೈಯಾರ್ ಹುಯಿಗಯು, ಮಾರು ಢಾಂಡಾವ್‍ನ ಅಜು಼ ಪಲ್ಯಹುಯ ಮೇಂಢಾವ್ನ ರ‍್ಹೇ಼ಖ್ಹಯ್‌ರಾಖ್ಯೋಸ್; ಖ್ಹಾರುಸ್ ತೈಯಾರ್ ಹುಯಿಗಯು. ವ್ಯಹಾನು ಮಿಝ಼್‌ವಾನ್ ಖಾವಾನ ಆವೊ’ ಕರಿ ಬೋಲೊ” ಕರಿ ಹುಕುಮ್‌ ದೀನ್, ಮೋಕ್‌ಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","ಕತೋಬಿ ಇವ್ಣೆ ಮಜು಼ರಸ್ ಕರ‍್ಯುಕೊಂತೆ ಏಕ್‌ ಜ಼ಣೊ ಖೇತರ್‌ನ, ಏಕ್‌ ಜ಼ಣೊ ಧಂದಾನ ಚ಼ಲೆಗಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","ಬಿಜು಼ ಥೋಡು ಜ಼ಣು ಯೋ ಆಳ್‌ನ ಖ್ಹಾರು ಧರೀನ್, ಇವ್ಣುನ ಮಾರಿನ್, ಮರ್‌ನಾಖಿದಿದು. ");
INSERT INTO vaa_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","ತದೆ ಯೋ ರಾಜಾ಼ನೆ ಘಣು ಖಿಜೈ಼ನ್, ಇನು ದಂಡ್‌-ದಳ್‌ವಾಯಿನ ಮೋಕ್ಲಿನ್, ಇನ ಆಳ್‌ನ ಖೂನಿಯೇವ್ನ ಮರೈನಾಖ್ಯೊ ಅಜು಼ ಇವ್ಣು ಖ್ಹಯೇರ‍್ನ ಬಾಳಿನಾಖ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","ಅನಕೇಡೆಥು ಇನೆ ಇನ ಆಳ್‌ ಖ್ಹಾರಾನ, “ವ್ಯಹಾನು ಮಿಝ಼್‌ವಾನ್ ತೈಯಾರ್ ಛಾ಼, ಕತೋಬಿ ಮೇ ಬುಲಾಯೊಥೋತೆ ಅದ್ಮಿಖ್ಹಾರು ಇನ ಲ್ಹಾಯಕ್‌ನು ಕೋ ಥೂನಿ. ");
INSERT INTO vaa_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","ಇನಖ್ಹಾಜೇಸ್ ತುಮೆ ಗಲ್ಲಿ-ಗಲ್ಲಿಯೇಮ ಜೈ಼ನ್, ತುಮೂನ ದೆಖಾವಸ್ತೆ ಅದ್ಮಿಖ್ಹಾರಾನ ಬುಲಾವೊ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","ಇಮ್ಮಸ್ ಯೋ ಆಳ್‌ಖ್ಹಾರು ಗಲ್ಲಿ ಗಲ್ಲಿಯೇಮ ಜೈ಼ನ್, ಅಛ಼್ಛು ಖರಾಬ್ ಕರಿ ದೇಖ್ಯುಕೊಂತೆ, ಇವ್ಣುನ ಮಳಾತೆ ಖ್ಹಾರ ಅದ್ಮಿನ ಎಕ್ಟು ಕರಿನ್, ಬುಲೈಲಿ ಆಯೊ; ಅಮ್ ಯೋ ವ್ಯಹಾನುಮಂಟಪ್ ಅಖ್ಖುಸ್ ಅದ್ಮಿ ಭರೈಗಯು. ");
INSERT INTO vaa_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","ಅನ ಬಾದ್‌ಮ ಯೋ ರಾಜಾ಼ನೆ ಖಾಣನ ಬೆಠುಥೂತೆ ಇವ್ಣುನ ದೇಖಾನಖ್ಹಾಜೆ ಆಯೊ, ತದೆ ವ್ಯಹಾನು ಲುಂಗ್ಡ ಪೇರ‍್ಹಿರಾಖ್ಯುಕೊಂತೆ ಏಕ್‌ ಅದ್ಮಿನ ದೇಖಿನ್, ");
INSERT INTO vaa_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","‘ಅಲಾ ದೋಸ್ತ್, ವ್ಯಹಾನು ಲುಂಗ್ಡ ಕೊಂತೆ ತೂ ಕಿಮ್ ಮಹಿ ಆಯೊ?’ ಕರಿ ಪುಛಾ಼ಯೊ. ಕತೋಬಿ ಯೋ ಅದ್ಮಿನೆ ಶಾತ್ಬಿ ಜ಼ವಾಬ್ ಕೋ ದಿದೋನಿ. ");
INSERT INTO vaa_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","ತದೆ ಯೋ ರಾಜಾ಼ನೆ ಇನ ಆಳ್‌ನ ಖ್ಹಾರು, ‘ಅನ ಹಾತ್-ಗೋಡ ಭಾಂದಿನ್, ಭಾರ್‌ ಅಂಧಾರಾಮ ಫೇಕಿದೆವೊ’ ಕರಿ ಬೋಲ್ಯೊ. ಹಿಜ್ಜಾ಼ ಅದ್ಮಿಖ್ಹಾರು ರೊವ್‌ತುಹುಯಿನ್, ಕರ್‌-ಕರ್‌ ದಾತ್‌ ಚಾ಼ವ್ತು ರ‍್ಹಿಶೆ. ");
INSERT INTO vaa_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","ಅಮ್ ಬುಲಾಯೂತೆ ಘಣು ಅದ್ಮಿನ, ಕತೋಬಿ ಚೂ಼ಣಾಯೂತೆ ಥೋಡುಸ್ ಅದ್ಮಿ” ಕರಿ ಯೇಸುನೆ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","ತದೆ ಫರಿಸಾಯರ್ ಜೈ಼ನ್, ಯೇಸುನ ವಾತೇಮ ಖ್ಹಪ್‌ಡಾವ್ಣು ಕರಿ ವಾತೆ ಕರಿಲೀನ್, ಇನಾಕನ ಆಯು. ");
INSERT INTO vaa_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","ಪರಿಸಾಯರ್‌ನು ಶಿಷ್ಯರ್‌ಮ ಥೋಡಾನ ಅಜು಼ ಹೆರೋದ ಭಣಿವಾಳ ಥೋಡು ಅದ್ಮಿನ ಮೋಕ್‍ಲ್ಯು. ಇವ್ಣೆ ಐನ್, “ಗುರು, ತೂ ಖ್ಹಾಚಿಸ್ ಬೋಲಾಸ್ ಕರಿ ಹಮೂನ ಮಾಲುಮ್. ತೂ ಅದ್ಮಿನಖ್ಹಾಜೆ ಛಾ಼ತೆ ದೇವ್ನಿ ಮರ್ಜಿನಿ ಬಾರೇಮ ಖ್ಹಾಚಿಸ್ ಬೋಲಿವತಾಳಸ್, ಎತ್ರೇಸ್ ಕಾಹೆತೆ ಅದ್ಮಿಖ್ಹಾರು ಶಾತ್‌ ಸೋಚ್‌ಶೆ ಕರಿ ಬೋಲಾನಿ ಬಾರೇಮ ತುನ ಫಿಕರ್ ಕೊಯ್ನಿ, ಶನಕತೊ, ತು ಕಿನಾಬಿ ಮ್ಹೋಡು ದೇಖಿನ್, ವಾತೆ ಬೋಲಾಕೊಯ್ನಿ. ");
INSERT INTO vaa_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","ಇನಖ್ಹಾಜೇಸ್ ಹಮೂನ ಬೋಲ್, ಕೈಸರ್‌ನ ಶುಂಕ ಭಾಂದಾನು ನಿಯಮ್‌ಕಿ ಕೊಯ್ನಿ? ತುನ ಕಿಮ್ ದೆಖಾವಸ್? ");
INSERT INTO vaa_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","ಯೇಸುನೆ ಇವ್ಣಿ ಖರಾಬ್ ಚಾ಼ಲ್‌ನ ಮಾಲುಮ್‌ ಕರಿಲೀನ್, “ತುಮೆ ಖೋಟ್ ದಿಲ್‌ವಾಳ! ತುಮೆ ಮನ ಖ್ಹಪ್‌ಡಾವ್ಣು ಕರಿ ಶನ ದೇಖೋಸ್ತೆ? ");
INSERT INTO vaa_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","ಶುಂಕ ಭಾಂದಾಸ್ತೆ ಪೈಶಾನ ಮನ ವತಾಳೊ!” ಕರಿ ಬೋಲ್ಯೊ. ಇವ್ಣೆ ಏಕ್ಕಾಖ್ಹ್‌ ಲಯಿನ್ ಇನ ದಿದು. ");
INSERT INTO vaa_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","ತದೆ ಯೇಸುನೆ ಇವ್ಣುನ, “ಅನಾಪರ್ ಕಿನು ರೂಪ್ ಅಜು಼ ಕಿನುನಾಮ್‍ ಛಾ಼ತೆ?” ಕರಿ ಪುಛಾ಼ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","ಇವ್ಣೆ, “ಕೈಸರ್‌ನು” ಕರಿ ಜ಼ವಾಬ್ ದಿದು. ತದೆ ಯೇಸುನೆ ಇವ್ಣುನ, “ಇಮ್‍ಕತೊ, ಕೈಸರ್‌ನು ಶಾತ್ ಛಾ಼ಕಿ, ಯೋ ಕೈಸರ್‌ನ ದೆವೊ, ಅಜು಼ ದೇವ್‌ನು ಶಾತ್‌ ಛಾ಼ಕಿ, ಯೋ ದೇವ್ನ ದೆವೊ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","ಇವ್ಣೆ ಆ ವಾತೇನ ಖ್ಹಮ್‌ಜಿನ್‌, ಆಶ್ಚರ್ಯಖೈನ್, ಇನ ಮ್ಹೆಂದಿನ್, ಚ಼ಲ್ಯುಗಯು. ");
INSERT INTO vaa_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","ಯೋಸ್ ದನ್ನೆ ಸದ್ದುಕಾಯವಾಳು ಯೇಸುಕನ ಆಯು. ಅವ್ಣೆ ಮರ‍್ಯುಹುಯು ಅದ್ಮಿ ಪಾಛು಼ ಜಿವ್ತುಹುಯಿನ್ ಉಠಾಕೊಯ್ನಿ ಕರಿ ಬೋಲಾವಾಳು. ");
INSERT INTO vaa_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","ಇವ್ಣೆ ಯೇಸುನ, “ಗುರು, ಏಕ್‌ ಅದ್ಮಿ ಲಡ್ಕಾಕೊಂತೆ ಮರಿಗೋತೊ, ಇನಿ ಬಾವಣ್ಣ ಇನೊ ಭೈ ಕರಿಲೇವ್ಣು, ಅಜು಼ ತದೆ ಇವ್ಣುನ ಲಡ್ಕಾ ಹುಯಾತೊ, ಯೋ ಲಡ್ಕಾ ಮರ‍್ಯೋತೆ ಭೈನ ಲಡ್ಕಾ ಹುಯಿರ‍್ಹಿಶೆ ಕರಿ ಮೋಶೆನೆ ಬೋಲಿರಾಖ್ಯೊಸ್.’ ");
INSERT INTO vaa_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","ಹಜ್ಜಾ಼ ಖ್ಹಾತ್ ಜ಼ಣ ಭೈಯೆ ಥಾ. ಮೋಟೊ ಭೈ ವ್ಯಹಾ ಕರಿಲೀನ್, ಲಡ್ಕಾ ಕೊಯ್ನಿತೇಸ್ ಮರಿಗಯೊ, ಇನಖ್ಹಾಜೇಸ್ ಇನ ಭೈನೆ ಇನಿ ಬಾವಣ್ಣ ಕರಿಲಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","ಯೋ ಬೇನೊ ಭೈನಾಬಿ ಇಮ್ಮಸ್ ಹುಯು, ಅಮ್ಮಸ್ ತೀನ್ನೊ ಭೈನಾಬಿ, ಅಜು಼ ಖ್ಹರ್ತಿಮ ಖ್ಹಾತೆ ಭೈಯೇನಾಬಿ ಇಮ್ಮಸ್ ಹುಯು. ");
INSERT INTO vaa_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","ಆ ಖ್ಹಾರಾನ ಬಾದ್‌ಮ ಯೋ ತಯೇಡಾಬಿ ಮರಿಗೈ. ");
INSERT INTO vaa_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","ಇಮ್‍ಕತೊ, ಮರವಾಳು ಜಿವ್ತುಹುಯಿನ್, ಆವ್‌ಶೇತೆ ತದೆ ಯೋ ತಯೇಡ ಖೆವಾನಿ ಬಾವಣ್‍ ಹುಯಿರ‍್ಹಿಶೆ? ಇವ್ಣೆ ಖ್ಹಾರಾಸ್ ಇನ ವ್ಯಹಾ ಕರಿಲಿದಾಥಾನಿ?” ಕರಿ ಪುಛಾ಼ಯು. ");
INSERT INTO vaa_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","ಯೇಸುನೆ ಇವ್ಣುನ, “ತುಮೆ ಕೆತ್ರೆ ಗಲ್ತಿಮ ಪಡ್ಯಾಸ್ತೆ ದೇಖೊ! ಶನಕತೊ ತುಮೂನ ದೇವ್ನಿ ವಚನ್‌ಬಿ ನಾತೊ ದೇವ್ ಕೆತ್ರೆ ಶಕತ್‌ವಾಳೊ ಕರೀಬಿ ಮಾಲುಮ್‌ಕೊಂತೆ ಇನಖ್ಹಾಜೇಸ್. ");
INSERT INTO vaa_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","ಮರವಾಳು ಜಿವ್ತುಹುಯಿನ್ ಆವ್‌ಶೇತೆ ತದೆ, ಇವ್ಣೆ ಸೊರ್ಗಾನು ದೂತರ್‌ನಿ ಘೋಣಿ ರ‍್ಹಿಶೆ, ಅಜು಼ ಇವ್ಣೆ ವ್ಯಹಾ ಕರ್ಶೆ ಕೊಯ್ನಿ. ");
INSERT INTO vaa_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","ಮರವಾಳು ಜಿವ್ತುಹುಯಿನ್ ಆವ್‌ಶೇತೆ ಬಾರೇಮ ದೇವ್ನೆ ಬೋಲ್ಯೋತೆ ಇನ ತುಮೆ ಪಢ್ಯಾಕೊಯ್ನಿಕಿ ಶು? ");
INSERT INTO vaa_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘ಮೇ ಅಬ್ರಹಾಮ್‌ನೊ ದೇವ್, ಇಸಾಕನೊ ದೇವ್, ಯಾಕೋಬನೊ ದೇವ್ ಕರಿ ಯೋ ಜಿವ್ತಾ ಅದ್ಮಿನೊ ದೇವ್ ಹುಯಿರ‍್ಹೋಸ್, ಪಣ್ಕಿ ಮರ‍್ಯಾಹುಯಾನೊ ಕಾಹೆ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","ಅದ್ಮಿಖ್ಹಾರು ಇನ ಖ್ಹಮ್‌ಜಿನ್‌, ಯೋ ಬೋಲಿವತಾಳಾಸ್ತೆ ಬಾರೇಮ ಆಶ್ಚರ್ಯ ಖಾದು. ");
INSERT INTO vaa_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","ಯೇಸುನೆ ಬರೋಬರ್‌ನು ಜ಼ವಾಬ್‌ದೀನ್, ಸದ್ದುಕಾಯವಾಳನು ಮ್ಹೋಡು ಭಾಂದ್ಯೊ ಕರಿ ಫರಿಸಾಯರ್‌ನೆ ಖ್ಹಮ್‌ಜಿನ್‌, ಇವ್ಣೆ ಎಕ್ಟು ಹುಯಿನ್ ಹಿಜ್ಜಾ಼ ಆಯು. ");
INSERT INTO vaa_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","ಇವ್ಣಾಮ ಥೋತೆ ಮೋಶೆನಿ ವಚನ್‍ ಶಿಕಾಡವಾಳೊ ಶಾಸ್ತ್ರಿಮ ಏಕ್‍ಜ಼ಣೊ ವಾತೆಥಿ ಯೇಸುನ ಖ್ಹಪ್‌ಡಾವ್ಣು ಕರಿ, ");
INSERT INTO vaa_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“ಗುರು, ಧರ್ಮಶಾಸ್ತ್ರನಿ ನಿಯಮ್ ಖ್ಹಾರೇಥಿ ಮೋಟಿ ಹುಕುಮ್ ಖೆವಿ?” ಕರಿ ಪುಛಾ಼ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","ಯೇಸುನೆ, “ತಾರೊ ದೇವ್ ಹುಯಿರ‍್ಹೋತೆ ಪ್ರಭುನ ತಾರೊ ಪೂರ ದಿಲ್‌ಥಿ, ಪೂರ ಜಾನ್‌ಥಿ, ತಾರೊ ಪೂರ ಮನ್‌ಥಿ ಪ್ಯಾರ್‌ಕರ‍್ನು. ");
INSERT INTO vaa_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","ಆಸ್ ಖ್ಹಾರೇಥಿ ಮೋಟಿ ಅಜು಼ ಮುಖ್ಯ ಹುಕುಮ್‌. ");
INSERT INTO vaa_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","ಆಸ್ ಹುಕುಮ್‌ನಿಘೋಣಿ ಛಾ಼ತೆ ಬೇನೆ ಮುಖ್ಯ ಹುಕುಮ್ ಖೆವಿಕತೊ, ತಾರು ತೂ ಕಿಮ್ ಪ್ಯಾರ್ ಕರಾಸ್ಕಿ ಇಮ್ಮಸ್, ತಾರ ಭೀಡೆವಾಳಾನ ಪ್ಯಾರ್ ಕರ‍್ನು’ ಕರಿ ಬೋಲನುಸ್. ");
INSERT INTO vaa_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","ಹಿಡಿ ಮೋಶೇನು ಧರ್ಮಶಾಸ್ತ್ರ ಅಜು಼ ಪ್ರವಾದೀನು ವಚನ್‌ಖ್ಹಾರು ಆ ಬೇಸ್ ಹುಕುಮ್‌ಪರ್ ಟಿಕ್ಯುಸ್ತೆ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","ಫರಿಸಾಯರ್ ಖ್ಹಾರು ಎಕ್ಟು ಹುಯಿನ್ ಆವಾದಿನ್, ಯೇಸುನೆ ಇವ್ಣುನ, ");
INSERT INTO vaa_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","ಆವ್ಣುತೆ ಕ್ರಿಸ್ತನಿ ಬಾರೇಮ ತುಮಾರಿ ಸೋಚ್ ಶಾತ್? ಯೋ ಕಿನೊ ಛಿಯ್ಯೊ?” ಕರಿ ಪುಛಾ಼ಯೊ. ಇವ್ಣೆ, “ಯೋ ದಾವೀದ್‌ನೊ ಛಿಯ್ಯೊ” ಕರಿ ಜ಼ವಾಬ್ ದಿದು. ");
INSERT INTO vaa_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","ತದೆ ಯೇಸುನ, ದಾವೀದನೊ ಛಿಯ್ಯೊಕರಿ ಬೋಲ್ಯು. ತದೆ ಇನೆ,ಇಮ್‍ಕತೊ, ದಾವೀದಸ್‌, ಪವಿತ್ರಾತ್ಮನಿ ಖ್ಹಯಾಲ್‌ಥಿ ಇನ ಪ್ರಭುಕರಿ ಬುಲಾಯೋನಿ, ಯೋ ಕಿಮ್? ");
INSERT INTO vaa_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","ಮೇ ತಾರ ದುಶ್‌ಮನ್ನ ಖ್ಹಾರು ತಾರ ಗೋಡ ಹೇಟ್ ನಾಖಾಲಗು, ಮಾರಿ ಖಾವಿ ಬಾಜೂ಼ಮ ಬೆಠೋರೆ ಕರಿ ಪ್ರಭುನೆ ಮಾರ ಮಾಲಿಕ್‌ನ ಬೋಲ್ಯೊ’ ಕರಿ ಪವಿತ್ರಾತ್ಮಥಿ ಬೋಲ್ಯೋನಿ. ");
INSERT INTO vaa_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","ದಾವೀದಸ್‌ ಕ್ರಿಸ್ತನ ಪ್ರಭುಕರಿ ಬೋಲಾಪರ್, ಕ್ರಿಸ್ತ ದಾವೀದ್‌ನೊ ಛಿಯ್ಯೊ ಕಿಮ್ ಉಶೆ?” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","ಯೇಸುನೆ ಪುಛಾ಼ಯೋತೆ ಇನ ಕಿನಾಬಿ ಜ಼ವಾಬ್ ದ್ಯವಾನ ಕೋ ಹುಯೂನಿ, ಅತ್ರೇಸ್ ಕಾಹೆತೆ ತಪ್‌ಥು ಇನ ಬಿಜು಼ ಶಾತ್ಬಿ ಸವಾಲ್‌ಕರಾನ ಇವ್ಣೆ ಹಿಮ್ಮತ್ ಕೋ ಕರ‍್ಯುನಿ. ");
INSERT INTO vaa_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","ಅನಕೇಡೆಥು ಯೇಸುನೆ ಅದ್ಮಿನಿ ಝೂ಼ಂಡ್‌ನ ಅಜು಼ ಇನ ಶಿಷ್ಯರ್‌ನ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","ಪಂಡಿತ್‍ಖ್ಹಾರುಬಿ ಫರಿಸಾಯವಾಳೂಬಿ ಮೋಶೆನಿ ಖುಡ್‍ಶಿಪರ್ ಬೆಠುರ‍್ಹುಸ್‍. ಶಾಸ್ತ್ರಿಯೇನ ಅಜು಼ ಪರಿಸಾಯರ್‌ನ ಹಕ್‌ ಛಾ಼. ");
INSERT INTO vaa_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","ಇನಖ್ಹಾಜೇಸ್ ತುಮೆ ಇವ್ಣೆ ಬೋಲಾತೆ ಇನಖ್ಹಾರಾನ ಖ್ಹಮಜ಼್‌ಣು ಅಜು಼ ಇನೀನಿಘೋಣಿ ಚಾ಼ಲ್ನು; ಇವ್ಣೆ ಕತೋಬಿ ಚಾ಼ಲಿಲೇಸ್ತೆ ಇಮ್‌ ನಾ ಚಾ಼ಲಿಲೇವ್ಣು, ಶನಕತೊ ಇವ್ಣೆ ಬೋಲಾತೆ ಇಮ್‌ ಇವ್ಣೇಸ್ ಕೋ ಕರಾನಿ. ");
INSERT INTO vaa_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","ಇವ್ಣೆ ಘಣು ವಜ಼ನ್ನು ಭೋಜಾ಼ನ ಭಾಂದಿನ್, ಅದ್ಮಿನ ಖಾಂದಾಪರ್ ನಾಖಾಸ್, ಕತೋಬಿ ಇವ್ಣೆತೊ ಚಿಟಂಗ್‌ಳಿಥೀಬಿ ಇನ ಕೋ ಛೀಮಾನಿ. ");
INSERT INTO vaa_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","ಇವ್ಣೆ ಅದ್ಮಿನ ಖ್ಹಾರು ದೆಖಾವಾದೆ ಕರಿ ಇವ್ಣು ಕಾಮ್ನ ಕರಾಸ್. ವಚನ್ ಲೀಖೈರ‍್ಹೂತೆ ಪಟ್ಟಿಯೇನ ತಾಳ್ವಪರ್ ಅಜು಼ ಡಂಟ್‌ಪರ್ ಭಾಂದಿರಾಖಾಸ್ತೆ ದೇಖೊ. ಇವ್ಣೆ ಪೇರ‍್ಹಾಸ್ತೆ ಝ಼ಗ್ಗಾವ್‍ನ ಗೊಂಡಾನ ಲಾಂಬು ಕರಿಲೇಸ್! ");
INSERT INTO vaa_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","ಅತ್ರೇಸ್ ಕಾಹೆತೆ, ಮಾನ್-ಮಿಝ್‍಼ವಾನೇನಿ ಝ಼ಗೋಮ ಖ್ಹಾರು ಖ್ಹಾರೇಥಿ ಖ್ಹಾಮ್ಣೆ, ಅಜು಼ ಸಬೆ ಭರಾವಾನು ಮಂದಿರ್‌ಮ ಖ್ಹಾರು ಅಖ್ಖಾನ ದೆಖಾವಾನಿಘೋಣಿ ಖ್ಹಾಮ್ಣೆ ಬೇಖ್ಹ್‌ಣು ಕರಿ ಇವ್ಣೆ ಆಖ್ಹ್‌ ಕರಾಸ್. ");
INSERT INTO vaa_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","ದುಕಾನೇನಿ ಗಲ್ಲಿಯೇಮ ಅದ್ಮಿಖ್ಹಾರು ಇವ್ಣುನ ಖ್ಹಲಾಮ್ ಕರ‍್ನು ಕರಿ ಅಜು಼ ಗುರುಕರಿ ಬೋಲೈಲೇವ್ಣು ಕರಿ ಬೋಲನುಸ್ ಇವ್ಣಿ ಆಖ್ಹ್. ");
INSERT INTO vaa_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","ಕತೋಬಿ ತುಮೆ ಗುರು ಕರಿ ನಕೊ ಬೋಲೈಲಿಶು; ಶನಕತೊ ಕ್ರಿಸ್ತ ಎಕ್ಕಸ್‍ಜ಼ಣೊ ತುಮೂನಛಾ಼ತೆ ಗುರು ಅಜು಼ ತುಮೆಖ್ಹಾರು ಭೈಯೇ ಭೇನೆನಿಘೋಣಿ ಹುಯಿರ‍್ಹಾಸ್. ");
INSERT INTO vaa_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","ಆ ಧರ್ತಿಪರ್ ತುಮೆ ಕಿನಾಬಿ ‘ಬಾ’ ಕರಿ ನಕೊ ಚಿಕರ್‌ಶು, ಶನಕತೊ ಸೊರ್ಗಾಮ ಛಾ಼ತೆ ಎಕ್ಕಸ್ ಜ಼ಣೊ ತುಮಾರೊ ಬಾ ಹುಯಿರ‍್ಹೂಸ್. ");
INSERT INTO vaa_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","ಅಜು಼ ತುಮೆ ‘ಮೋಟೊ’ ಕರಿ ನಕೊ ಬೋಲೈಲಿಶು; ಶನಕತೊ ಕ್ರಿಸ್ತ ಎಕ್ಕಸ್ ಜ಼ಣೊ ತುಮಾರೊ ಮೋಟೊ. ");
INSERT INTO vaa_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","ತುಮಾರಾಮ ಮಹಾನ್ ಕರಿ ರ‍್ಹವಾಳೊ ತುಮಾರೊ ಆಳ್‌ನಿಘೋಣಿ ರ‍್ಹೇಣು. ");
INSERT INTO vaa_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","ಇನುಯೋಸ್ ಮೋಟೊಕರಿ ಬೋಲೈಲ್ಯವಾಳೊ ಹೇಟು ಹುಯಿಜಾ಼ಶೆ, ಇನುಯೋಸ್ ಹೇಟುಕರಿ ಬೋಲೈಲ್ಯವಾಳೊ ಯೋ ಮೋಟೊ ಹುಯಿಜಾ಼ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“ಮೋಶೆನಿ ವಚನ್ನ ಶಿಕಾಡವಾಳ ಶಾಸ್ತ್ರಿಯೆ ಅಜು಼ ಫರಿಸಾಯರ್‌ವಾಳ ತುಮಾರಿ ಹಾಲ್ನ ಶಾತ್‌ ಬೋಲು! ತುಮೆ ಖೋಟ್ ದಿಲ್‌ವಾಳ ಹುಯಿರ‍್ಹಾಸ್! ಅದ್ಮಿಖ್ಹಾರು ಸೊರ್ಗಾನು ರಾಜ್ಯಮ ಜಾ಼ವಾನು ಬಾಕಲ್‌ನ ತುಮೆ ಖ್ಹಾಮ್ಣೆ ಮೂಚಿನಾಖೋಸ್, ತುಮೇಬಿ ಮಹಿ ಕೋಜಾ಼ಯ್ನಿ ಅಜು಼ ಮಹಿ ಜಾ಼ವ್ಣುಕರಿ ಕರಾವಾಳಾನಾಬಿ ಕೋ ಮ್ಹೇಲೋನಿ. ");
INSERT INTO vaa_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","ಅಲಾ ಠಗಾರು ಖ್ಹಾರ ಪಂಡಿತ್ ಪರಿಸಾಯವಾಳ ಅದ್ಮಿಖ್ಹಾರು ದೇಖಾದೆಕರಿ ಲಾಂಬಿ ಪ್ರಾರ್ಥನೆ ಕರೋಸ್ ತುಮೆ ಮುಂಡಚ್ಚಿನ ಶೊತ್‌ನ ಗಳಿಲಿನ್ ನಾಟಕ್ ಕರೋಸ್. ಇನಖ್ಹಾಜೆ ತುಮೆ ಘಣಿ ನಿಶತ್‌ ಲೀಲಿಶು. ");
INSERT INTO vaa_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","ಮೋಶೆನಿ ವಚನ್ ಶಿಕಾಡವಾಳ ಶಾಸ್ತ್ರಿಯೆ ಅಜು಼ ಫರಿಸಾಯರ್‌ವಾಳ ತುಮಾರಿ ಹಾಲ್ನ ಶಾತ್‌ ಬೋಲು! ತುಮೆ ಖೋಟ್ ದಿಲ್‌ವಾಳ ಹುಯಿರ‍್ಹಾಸ್! ತುಮೆ ಏಕ್‌ ಜ಼ಣಾನ ತುಮಾರಿ ಧರಮ್ಮ ಮಳೈಲ್ಯವಾನಖ್ಹಾಜೆ ದರ‍್ಯಾವ್‍ನ ಖ್ಹಾರು ಉಲಾಂಗಿನ್, ಬಿಜ಼-ಬಿಜ಼ ದೇಖ್ಹ್‌ನ ಜಾ಼ವೋಸ್. ಅಜು಼ ಯೋ ಮಳಾನ ಬಾದ್‌ಮ ತುಮಾರೇಥಿ ಬೇ ಪಟ್ ನರಕ್‌ನ ಜಾ಼ವಾನಿಘೋಣಿ ಇನ ಕರೋಸ್! ");
INSERT INTO vaa_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","ವಾಟ್‌ ವತಾಳವಾಳ ಕಾಣ ಅದ್ಮಿಯೆ, ತುಮಾರಿ ಹಾಲ್ನ ಶಾತ್‌ ಬೋಲು! ಏಕ್‌ ಜ಼ಣೊ ಮಂದಿರ್‌ಪರ್ ಆಣ್ ಲಿದೋತೊ, ಯೋ ಶಾತ್ ಆಣ್ ಕಾಹೆ, ಕತೋಬಿ ಏಕ್‌ ಜ಼ಣೊ ಮಂದಿರ್‌ನು ಖ್ಹೊನ್ನಾಪರ್‌ ಆಣ್ ಲಿದೋತೊ, ಇನ ಚ಼ಲಾವ್ಣುಸ್ ಚ಼ಲಾವ್ಣು’ ಕರಿ ಬೋಲೋಸ್. ");
INSERT INTO vaa_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","ತುಮೆಖ್ಹಾರು ಕಾಣ ಬುಧ್ಧು ಹುಯಿರ‍್ಹಾಸ್! ಕೆಹು ಮೋಟು? ಖ್ಹೊನ್ನುಕಿ, ಮಂದಿರ್‌? ಖ್ಹೊನ್ನಾನ ಪರಿಶುದ್ ಕರ‍್ಯುತೆ ಮಂದಿರ್‌ ಕಾಹೇಕಿಶು? ");
INSERT INTO vaa_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","ಎತ್ರೇಸ್ ಕಾಹೆತೆ, ‘ಏಕ್‌ ಜ಼ಣೊ ಚಾ಼ಚ಼ರ್‌ಪರ್ ಆಣ್ ಲಿದೋತೊ, ಯೋ ಶಾತ್ ಆಣ್ ಕಾಹೆಕರಿ ಬೋಲೊಸ್‍, ಕತೋಬಿ ಇನಮಾನಿ ಕಾಣ್ಕೆಪರ್‌ ಆಣ್ ಲಿದುತೋ ಇನ ಚ಼ಲಾವ್ಣುಸ್ ಚ಼ಲಾವ್ಣು’ ಕರಿ ತುಮೆ ಬೋಲೋಸ್. ");
INSERT INTO vaa_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","ತುಮೆ ಕೆತ್ರೆ ಕಾಣ ಹುಯಿರ‍್ಹಾಸ್! ಕೆಹು ಮೋಟು? ಕಾಣ್ಕೆಕಿ, ಕಾಣ್‌ಕೆನ ಪಾಕ್‌ ಕರಾಸ್ತೆ ಚಾ಼ಚ಼ರ್‌? ");
INSERT INTO vaa_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","ಚಾ಼ಚ಼ರ್‌ಪರ್ ಆಣ್ ಲ್ಯವಾಳೊ, ಖಲಿ ಚಾ಼ಚ಼ರ್‌ಪರಸ್ ಕಾಹೆ, ಇನಾಪರ್ ಮ್ಹೇಲಾಸ್ತೆ ಖ್ಹಾರಿಸ್ ಕಾಣ್ಕೆಪರ್ ಆಣ್ ಲ್ಯಾವದಾಖ್ಹಲ್; ");
INSERT INTO vaa_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","ಮಂದಿರ್‌ಪರ್ ಆಣ್ ಲ್ಯವಾಳೊ, ಖಲಿ ಮಂದಿರ್‌ಪರಾಸ್‌ ಕಾಹೆ, ಇನಾಮಹಿ ರ‍್ಹವಾಳೊ ದೇವ್‌ಪರ್‌ಬಿ ಆಣ್ ಲ್ಯಾವದಾಖ್ಹಲ್. ");
INSERT INTO vaa_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","ಅಜು಼ ಸೊರ್ಗಪರ್ ಆಣ್ ಲ್ಯವಾಳೊ, ದೇವ್ನಿ ಸಿಂಹಾಸನ್‍ಪರ್‌ಬಿ, ಇನಾಪರ್ ಬೇಖ್ಹಾವಾಳಪರ್‌ಬಿ ಆಣ್ ಲ್ಯಾವದಾಖ್ಹಲ್. ");
INSERT INTO vaa_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","ಮೋಶೆನಿ ವಚನ್ನ ಶಿಕಾಡವಾಳ ಶಾಸ್ತ್ರಿಯೆ ಅಜು಼ ಫರಿಸಾಯರ್‌ವಾಳ ತುಮಾರಿ ಹಾಲ್ನ ಶಾತ್‌ ಬೋಲು! ತುಮೆ ಖೋಟ್ ದಿಲ್‌ವಾಳ ಹುಯಿರ‍್ಹಾಸ್! ತುಮಾರಕನ ಛಾ಼ತೆ ಹರೇಕ್‍ಮಾಬಿ ಪುದೀನ, ಖ್ಹೋಪ್ ಅಜು಼ ಜೀರಮಾಬಿ ದಖ್ಹ್‌ಮ ಏಕ್‌ ಭಾಗ್‌ ದೇವ್ನ ಕರಿ ತುಮೆ ದೆವೋಸ್. ಕತೋಬಿ ಧರ್ಮಶಾಸ್ತ್ರಮ ಬೋಲಾಸ್ತೆ ನ್ಯಾವ್‌ನಾಬಿ, ಗೋರ್‌ನಾಬಿ ಅಜು಼ ವಿಶ್ವಾಸ್‍ನಾಬಿ ಮ್ಹೇಲಿಲಿದಾ. ಆ ಖ್ಹಾರಿ ಹುಕುಮ್‌ನಿಘೋಣಿ ಪಹಿಲೆ ಚಾ಼ಲೊ ಅಜು಼ ಯೋ ಖ್ಹಾರು ಕರಾನಬಿ ನಕೊ ಮ್ಹೇಲೊ. ");
INSERT INTO vaa_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","ವಾಟ್‌ ವತಾಳವಾಳ ಕಾಣ! ತುಮೆ ಮಛ್ಛರ್‌ನ ಛಾ಼ಣಿನ್ ಕಾಡೋಸ್, ಕತೋಬಿ ಊಟ್ನ ಗಳಿಲೆವೊಸ್! ");
INSERT INTO vaa_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","ಮೋಶೆನಿ ವಚನ್‍ ಶಿಕಾಡವಾಳ ಶಾಸ್ತ್ರಿಯೆ ಅಜು಼ ಫರಿಸಾಯರ್ ತುಮಾರಿ ಹಾಲ್ನ ಶಾತ್‌ ಬೋಲು! ತುಮೆ ಖೋಟ್ ದಿಲ್‌ವಾಳ ಹುಯಿರ‍್ಹಾಸ್! ತುಮೆ ತುಮಾರು ಹಂಡ್‌ಕು ಅಜು಼ ಥಾಳಿ ಭಾರ್‌ ಪಾಕ್‌ಥಿ ಮಾಂಜ಼ಸ್. ಕತೋಬಿ ಇನಮಹಿ ದೋಚಿಲ್ಯವಾನುಬಿ, ಲಾಲಚ಼್‌ಥೀಬಿ ಭರೈರ‍್ಹೇಸ್. ");
INSERT INTO vaa_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","ಫರಿಸಾಯರ್ ತುಮೆ ಕಾಣ ಹುಯಿರ‍್ಹಾಸ್! ಪಹಿಲೆ ಹಂಡ್ಕನ ಮಹಿ ಅಛ್ಛಿನಿತರ ಧೋವೊ, ತದೆ ಹಂಡ್ಕನ ಭಾರ್‌ಬಿ ಪಾಕ್‍ ಹುಯಿಜಾ಼ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","ಮೋಶೆನಿ ವಚನ್‍ ಶಿಕಾಡವಾಳ ಶಾಸ್ತ್ರಿಯೆ ಅಜು಼ ಫರಿಸಾಯರ್ ತುಮಾರಿ ಹಾಲ್ನ ಶಾತ್‌ ಬೋಲು! ತುಮೆ ಖೋಟ್ ದಿಲ್‌ವಾಳ ಹುಯಿರ‍್ಹೋಸ್! ತುಮೆ ಚು಼ನ್ನೊ ಮರೈರ‍್ಹೇಯಿತೆ ಮಖ್ಹಾಣ್ಯನಿಘೋಣಿ ಹುಯಿರ‍್ಹಾಸ್. ಯೋ ಮಖ್ಹಾಣ್ಯ ಭಾರ್‌ ಅಛ್ಛು಼ ದೆಖಾವಸ್, ಕತೋಬಿ ಮಹಿ ಮರ‍್ಯಾಮುರ್ದಾನ ಹಡ್‌ಕ್ಯಾ ಅಜು಼ ಖ್ಹಾರಿಸ್ ತರ‍್ಹಾನು ಖ್ಹಡ್ಯು ಭರೈರ‍್ಹೇಸ್. ");
INSERT INTO vaa_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","ಇಮ್ಮಸ್ ತುಮೇಬಿ, ಭಾರ್‌ಲ್ಯ ಅದ್ಮಿವೋನ ನೀತಿವಾಳ ಕರಿ ದೆಖಾವೋಸ್, ಕತೋಬಿ ತುಮಾರ ಮಹಿ, ಖೋಟ್ ಅಜು಼ ಪಾಪ್ ಭರೈರ‍್ಹೂಸ್. ");
INSERT INTO vaa_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","ಮೋಶೆನಿ ವಚನ್‍ ಶಿಕಾಡವಾಳ ಶಾಸ್ತ್ರಿಯೆ ಅಜು಼ ಫರಿಸಾಯರ್ ತುಮಾರಿ ಹಾಲ್ನ ಶಾತ್‌ ಬೋಲು! ತುಮೆ ಖೋಟ್ ದಿಲ್‌ವಾಳ ಹುಯಿರ‍್ಹಾಸ್! ತುಮೆ ಪ್ರವಾದಿ ಖ್ಹಾರಾನಖ್ಹಾಜೆ ಅಛ್ಛಿ ಮಖ್ಹಾಣ್ಯನಿ ಘವಿಯೇನ ಬಣಾವೋಸ್, ಅಜು಼ ನೀತಿವಾಳಾನ ಮಖ್ಹಾಣ್ಯವ್‍ನ ಶನ್‌ಗಾರ್ ಕರೋಸ್; ");
INSERT INTO vaa_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","ಹಮಾರ ಗುರುಗುರುಬ್‌ಲ್ಯವ್‍ನ ಜಂಗ್‌ಮ ಹಮೆ ರ‍್ಹಯಾಹೋತ್ತೊ, ಆ ಪ್ರವಾದಿ ಖ್ಹಾರಾನ ಮಾರ‍್ಯುತೆ ಖೂನಿಮ ಭಾಗಿ ಹುಯಹೊತ್‍ಕೊಯ್ನಿ’ ಕರಿ ಬೋಲೋಸ್. ");
INSERT INTO vaa_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","ಇಮ್‍ಕತೊ, ತುಮೆ ಪ್ರವಾದಿ ಖ್ಹಾರಾನ ಮಾರ‍್ಯೂತೆ ಇವ್ಣ ಲಡ್ಕಾ ಹಮೆ ಕರಿ ತುಮಾರು ತುಮೇಸ್ ಸಾಕ್ಷಿ ಬೋಲಿಲೆವೊಸ್. ");
INSERT INTO vaa_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","ಅಛ್ಛು಼ಸ್, ತುಮಾರ ಗುರುಗುರಬ್‍ಲ್ಯಾನಿ ಪಾಪ್ನ ತುಮೆ ಪೂರ ಕರೊ! ");
INSERT INTO vaa_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","ಅಲ ಖ್ಹಾಪ್ ಅಜು಼ ಖ್ಹಾಪ್‌ನಿ ಪಿಳ್ಗಿವಾಳ, ತುಮೆ ನರಕ್‌ನಿ ತೀರ್ಪ್‌ಥಿ ಛು಼ಕ್‍ಶು ಕರಿ ಕಿಮ್ ಸೋಚೋ಼ಸ್? ");
INSERT INTO vaa_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","ಇನಖ್ಹಾಜೇಸ್ ಮೇ ಬೋಲುಸ್ಕಿ, ಮೇ ತುಮಾರಕನ ಪ್ರವಾದಿಯೇನಾಬಿ, ಗ್ಯಾನಿ ಅದ್ಮಿಖ್ಹಾರಾನಾಬಿ ಅಜು಼ ಬೋದಕರ್‌ ಖ್ಹಾರಾನ ಮೋಕ್ಲೀಶ್; ತುಮೆ ಇವ್ಣಾಮ ಥೋಡಾನ ಮಾರಿನಾಕ್‌ಶು, ಅಜು಼ ಥೋಡಾನ ಶಿಲ್‌ಬೇಪರ್ ನಾಕ್‌ಶು ಅಜು಼ ಬಿಜು಼ ಥೋಡಾನ ತುಮಾರಿ ಸಬೆ ಭರಾವಾನು ಮಂದಿರ್‌ಮ ಖ್ಹಾರು ಕೊಳ್ಡೇಥಿ ಮಾರಿನ್ ಗಾಮ್‌ಥು-ಗಾಮ್‍ ನಖ್ಹಾಡಿಲಿಜಾ಼ಶು. ");
INSERT INTO vaa_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","ಅಮ್ ನೀತಿವಾಳೊ ಹುಯಿರ‍್ಹೋತೆ ಹೇಬೆಲ್‍ನು ಲ್ಹೊಯಿಥಿ ಧರೀನ್, ತುಮೆ ಮಂದಿರ್‌ನಾಬಿ ಅಜು಼ ಚಾ಼ಚ಼ರ್‌ನ ಇಚ಼್‌ಮ ಮಾರಿನಾಖ್ಯಾತೆ ಬರಕೀಯಾನೊ ಛಿಯ್ಯೊ ಜಕರೀಯಾನು ಲ್ಹೋಯಿತೋಡಿ, ಧರ್ತಿಪರ್ ರಂಚಾ಼ಯುತೆ ಹರೇಕ್ ನೀತಿವಾಳಾನು ಲ್ಹೋಯಿನು ಮಾರ್ ತುಮಾರ ಮುಡ್‌ಕ್ಯಪರ್ ಆವ್‌ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","ಮೇ ತುಮೂನ ಖ್ಹಾಚಾಮ ಬೋಲುಸ್, ಅಖ್ಖು ಅಪರಾದ್‌ ಆ ಪಿಳ್ಗಿಪರ್ ಆವ್‌ಶೆ! ");
INSERT INTO vaa_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","ಯೆರೂಸಲೇಮ್‌, ಯೆರೂಸಲೇಮ್‌! ಪ್ರವಾದಿ ಖ್ಹಾರಾನೊ ಜಾನ್‌ ಕಾಡಾವಾಳಿ! ದೇವ್ನೆ ತಾರಕನ ಮೋಕ್‌ಲ್ಯೊತೆ ಅದ್ಮಿಖ್ಹಾರಾನ ಬಂಡೊ ಫೇಕಿನ್, ಮಾರವಾಳಿ! ಮುರ್‌ಗಿ ಚೇಲ್ಕಾನ ಇನಿ ಪಾಖ್ಡಿಯೆಮ ಪೆಖ್ಹಾಡಿಲೇಯಿತೆ ಇಮ್‌, ತಾರ ಲಡ್ಕಾವ್ನ ಮೇ ಪೆಖ್ಹಾಡಿಲೇವ್ಣು ಕರಿ ಮನ ಕೆತ್ರಿಕ್ಕಿಹಲ್ಲ ಮನ್‍ಹುಯು, ಕತೋಬಿ ತುನ ಪಣ್ಕಿ ದಿಲ್‌ ಕೋಥುನಿ. ");
INSERT INTO vaa_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","ಹಂದೇಕ್, ತಾರಿ ಮಂದಿರ್‌ ಉಜ್ಜಾ಼ಡಿ ಪಡಿಜಾ಼ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","ಹಂಕೇಥು ಧರೀನ್, ‘ಪ್ರಭುನ ನಾಮ್‌ಪರ್‌ ಆವಾಳಾನ ಆಶೀರ್ವಾದ್‌ ಹುವಾದೆ’ ಕರಿ ತುಮೆ ಬೋಲಾತೋಡಿ, ತುಮೆ ಮನ ಪಾಛು಼ ದೇಕ್‌ಶುಸ್ ಕೊಯ್ನಿ ಕರಿ ಮೇ ತುಮೂನ ಬೋಲುಸ್” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","ಅನಕೇಡೆಥು ಯೇಸು ಮಂದಿರ್‌ನ ಮ್ಹೆಂದಿನ್ ಜಾ಼ವಾನಿ ವಖ್ಹತ್‌ಮ, ಮಂದಿರ್‌ ಭಂದೈರ‍್ಹೀತೆ ತರೀಕಾನ ಇನ ವತಾಳ್ಣು ಕರಿ ಇನ ಶಿಷ್ಯರ್‌ ಇನಾಕನ ಆಯಾ. ");
INSERT INTO vaa_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","ತದೆ ಯೇಸುನೆ, “ತುಮೆ ಆ ಖ್ಹಾರು ದೇಖುಕರಾಸ್‌ನಿ ಹಜ್ಜಾ಼ ಏಕ್‌ ಬಂಡಾಪರ್ ಬಿಜೇಕ್ ಬಂಡೊ ಭೀರಿಶೆ ಕೊಯ್ನಿ; ಅಖ್ಖಾಸ್ನ ರಡ್‌ಕೈನಾಖಿದಿಶೆ ಕರಿ ಮೇ ತುಮೂನ ಖ್ಹಾಚಾಮ ಬೋಲುಸ್” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","ಯೇಸುನೆ ಆಲಿವ್‌ ಪಹಡ್‌ಪರ್ ಬೆಠೋಥೋತೆ ತದೆ ಇನ ಶಿಷ್ಯರ್‌ ಇನಾಕನ ಅಲಕ್‌ಥಿ ಆಯಿನ್, “ಆ ಖ್ಹಾರು ಕದೆ ಚಾ಼ಲ್‌ಷೆ? ತೂ ಆಯಿಶ್‍ತೆ ಅಜು಼ ಆ ಜಗತ್ನಿ ಖ್ಹರ್ತಿ ಹುವಾನ ಖ್ಹಣೇದ್‍ಕಿ ಶು? ಹಮೂನ ಬೋಲ್” ಕರಿ ಪುಛಾ಼ಯಾ. ");
INSERT INTO vaa_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","ಯೇಸುನೆ ಇವ್ಣುನ, “ಕೋಣ್‌ಬಿ ತುಮೂನ ಠಗಾವ಼್ಣುನಾತೆ ಇಮ್‌, ಜ಼ತನ್‌ಥಿ ರ‍್ಹವೊ. ");
INSERT INTO vaa_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","ಶನಕತೊ, ಕೈಯೆಕ್ಕಿ ಜ಼ಣು ಆಯಿನ್, ಮಾರು ನಾಮ್‌ಲೀನ್, ‘ಮೇ ಕ್ರಿಸ್ತ, ಮೇ ಕ್ರಿಸ್ತ’ ಕರಿ ಬೋಲಿನ್, ಘಣ ಅದ್ಮಿನ ವಾಟ್‌ ಭೈಕಾವ್‌ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","ಅತ್ರೇಸ್ ಕಾಹೆತೆ ತುಮಾರ ಖನ್ನೆ ಜಂಗ್ ಭೀಡುಕರಾತೆ ಅವಾಜ಼್ ಅಜು಼ ದೂರ್‌ಮ ಚಾ಼ಲುಕರಾತೆ ಜಂಗ್‌ನಿ ಬಾರೇಮಾನಿ ಖಬರ್ ತುಮೆ ಖ್ಹಮಜ಼್‌ಶು, ಕತೋಬಿ ಡರ್‌ಶು ನಕೊ. ಖ್ಹರ್ತಿ ಆವಾನ ಅಗಾಡಿ ಆ ಖ್ಹಾರು ಚಾ಼ಲ್ನುಸ್ ಚಾ಼ಲ್ನು. ");
INSERT INTO vaa_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","ದೇಖ್ಹ್‌ನ ವಿರೋದ್ ದೇಖ್ಹ್‌, ರಾಜ್ಯನ ವಿರೋದ್ ರಾಜ್ಯ ಉಟ್‌ಶೆ; ಖ್ಹಾರಿಸ್ ಬಾಜೂ಼ಮ ಕಾಳ್ದುಕಾಳ್ ಉಶೆ ಅಜು಼ ಜ಼ಮೀನ್ ಹಲ್‌ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","ಆ ಖ್ಹಾರು ಲಡ್ಕಾ ಪೈದಾ ಹುವಾನಿ ವಖ್ಹತ್‌ಮ ಆವಾಸ್ತೆ ಪಹಿಲಿ ಅಜಾ಼ನಿಘೋಣಿ ಹುಯಿರ‍್ಹುಸ್‍ ಎತ್ರೇಸ್. ");
INSERT INTO vaa_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","ತದೆ ತುಮೂನ ಧರೀನ್ ದಂಡನೆ ದೀನ್ ಮಾರ ನಾಮ್ನಖ್ಹಾಜೆ ಹರೇಕ್ ದೇಖ್ಹ್‌ವಾಳು ತುಮೂನ ವಹೇರ್‌ ಕರ್ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","ಯೋ ವಖ್ಹತ್‌ಮ ಕೈಯೆಕ್ಕಿ ವಿಶ್ವಾಸಿಖ್ಹಾರು ಪಿನ್‌ಮಾಟಿಜಾ಼ಶೆ; ಏಕ್‌ನ-ಏಕ್‌ ಧೋಕೇಥಿ ಧರಿದಿಶೆ ಅಜು಼ ಏಕ್‌ಪರ್‌-ಏಕ್‌ ವಹೇರ್‌ ಕರ್ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","ಘಣು ಜ಼ಣು ಝೂ಼ಟುಪ್ರವಾದಿ ಖ್ಹಾರು ಆಯಿನ್, ಕೈಯೆಕ್ಕಿ ಅದ್ಮಿನ ಖ್ಹಾರು ಠಗಾವ್‌ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","ಅತ್ರೇಸ್ ಕಾಹೆತೆ ಜಗತ್‌ಮ ಖರಾಬ್ ಜಾ಼ಖ್ಹತ್ ಹುಯಿಜಾ಼ಶೇತೆ ಇನಖ್ಹಾಜೆ ಘಣ ಅದ್ಮಿನಿ ಪ್ಯಾರ್ ಠಂಡು ಪಡಿಜಾ಼ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","ಕತೋಬಿ ಖ್ಹರ್ತಿತೋಡಿ ಖ್ಹಮಾಳಿಲ್ಯವಾಳಾನ ರಕ್ಷಣೆ ಲಿಶೆ. ");
INSERT INTO vaa_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","ರಾಜ್ಯನು ಆ ಅಛ್ಛಿ ಸಮಾಚಾರ್ ಜಗತ್‌ನು ತಮಾಮ್‌ ದೇಖ್ಹ್‌ವಾಳ ಅದ್ಮಿನ ಸಾಕ್ಷಿನಟೇಕೆ ಬೋಲಾವ್‌ಶೆ; ತದೆ ಖ್ಹರ್ತಿನದನ್‍ ಆವ್‌ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“ಪ್ರವಾದಿ ದಾನಿಯೇಲ್‌ನೆ ಬೋಲ್ಯೋತೆ, ‘ಬರ್ಬಾತ್ ಕರಾವಾಳು ಗಲೀಜ಼್ ರಾಛು಼’ ಪವಿತ್ರ ಝ಼ಗೋಪರ್ ಭೀರಾವನು ತುಮೆ ದೇಕ್‌ಶು. ಅನ ಪಢವಾಳು ಅನಿ ಮತ್ಲಬ್ ಶಾತ್‌ ಕರಿ ಪರ್ಖಿಲ್ಯವಾದೆ. ");
INSERT INTO vaa_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","ಯೋ ವಖ್ಹತ್‌ಮ ಯೂದಾಯಮ ರ‍್ಹವಾಳು ಪಹಾಡೋಮ ಮಿಲೈಜಾ಼ಣು. ");
INSERT INTO vaa_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","ಕೋಣ್‌ತೋಬಿ ಏಕ್ಜ಼ಣೊ ಇನ ಘರ್‌ನ ಛ಼ತ್‍ಪರ್‌ ರ‍್ಹಯೋತೊ, ಯೋ ಹೇಟ್ ಉತ್ರಿನ್ ಶಾತ್‌ತೋಬಿ ಪಾಡಿಲೇಣು ಕರಿ ಘರ್‌ನ ಮಹಿ ಜೈ಼ನ್, ವಖ್ಹತ್ ಬರ್ಬಾತ್ ನಾ ಕರ‍್ನು. ");
INSERT INTO vaa_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","ಅಜು಼ ಕೋಣ್‌ತೋಬಿ ಏಕ್‌ ಜ಼ಣೊ ಖೇತರ್‌ಮ ರ‍್ಹಯೋತೊ, ಯೋ ಇನೊ ಝ಼ಗ್ಗೊ ಪಾಡಿಲೇಣು ಕರಿ ಪಾಛೊ಼ಫರಿ ಘರೆ ನಾ ಜಾ಼ವ್ಣು. ");
INSERT INTO vaa_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","ಯೋ ದನೂಮ ಬೇಜೂನಿ ಅಜು಼ ದೂದ್ ಪಿಡಾವವಾಳಿ ತಯೇಡಾವ್ನ ಉಷೇತೆ ಹಾಲ್ನ ಶಾತ್ ಬೋಲು! ");
INSERT INTO vaa_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","ತುಮೆ ಮಿಲೈಜಾ಼ಣುತೆ ದನ್ ಠಣ್‌ನೊ ದನ್ ನಾತೊ ಸಬ್ಬತ್‌ನೊ ದನ್ ನಾ ಹುಯಿರ‍್ಹೇಣು ಕರಿ ದೇವ್ನ ಪ್ರಾರ್ಥನೆ ಕರೊ! ");
INSERT INTO vaa_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","ಶನಕತೊ ಯೋ ವಖ್ಹತ್‌ಮ ಘಣು ಲತಾಡ ರ‍್ಹಿಶೆ. ಜಗತ್‌ ಉಬ್‌ಜ್ಯುತೆ ತಪ್‌ಥು ಧರೀನ್, ಹಮ್ಕೆಲಗು ಕದೇಸ್‌ ಅಮ್ನು ಲತಾಡ ಕೋ ಐರ‍್ಹೂನಿ. ಬಿಜು಼ ಖ್ಹಾಮ್ಣೆಬಿ ಕೋ ಆವ್‌ಶೇನಿ. ");
INSERT INTO vaa_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","ದೇವ್ ಯೋ ಖ್ಹಾರ ದನ್ನ ಕಮ್ ನಾ ಕರ‍್ಯೋತೊ, ಏಕ್‌ ಅದ್ಮಿ ಜಿನ್‌ಕುಬಿ ಬಚಿಜಾಶೆಕೊಯ್ನಿ; ಕತೋಬಿ ಇನೆ ಚೂ಼ಣಿಲಿದೊತೆ ಅದ್ಮಿನಖ್ಹಾಜೆ ದೇವ್ ಯೋ ಖ್ಹಾರ ದನ್ನ ಕಮ್ ಕರ್ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","ಯೋ ವಖ್ಹತ್‌ಮ ಕೋಣ್‌ತೋಬಿ ತುಮೂನ, ‘ದೇಖೊ, ಕ್ರಿಸ್ತ ಹಜ್ಜಾ಼ ಛಾ಼! ನಾತೊ, ಯೋ ಹಿಜ್ಜಾ಼ ಛಾ಼! ಕರಿ ಬೋಲ್ಯುತೊ, ಇನ ನಕೊ ನಂಬ್‌ಶು. ");
INSERT INTO vaa_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","ಶನಕತೊ ಝೂ಼ಟುಕ್ರೈಸ್ತರ್‌ ಖ್ಹಾರು ಅಜು಼ ಝೂ಼ಟು ಪ್ರವಾದಿಖ್ಹಾರು ದೆಖೈನ್, ಇವ್ಣೇಥಿ ಹುಯೂತೊ ದೇವ್‍ಥಿ ಚೂ಼ಣೈರ‍್ಹವಾಳನಾಬಿ ಠಗಾವಾನಖ್ಹಾಜೆ, ಅದ್ಭುತ್‌ಕಾಮ್‌ ಅಜು಼ ಅಶ್ಚರ್ಯನು ಕಾಮ್‌ಖ್ಹಾರು ಕರಿ ವತಾಳ್‌ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","ಖ್ಹಮ್‍ಜೊ! ಮೇ ತುಮೂನ ಆ ಖ್ಹಾರು ಚಾ಼ಲಾನ ಅಗಾಡಿಸ್ ಇನಿ ಬಾರೇಮ ಬೋಲಿರಾಖ್ಯೊಸ್. ");
INSERT INTO vaa_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","ಇನಾಖ್ಹಾಜೆ ಕೋಣ್‌ತೋಬಿ ತುಮೂನ, “ಹಂದೇಖೊ, ಕ್ರಿಸ್ತ ಉಜ್ಜಾ಼ಡಿ ಝ಼ಗೋಮ ಛಾ಼’ ಕರಿ ಬೋಲ್ಯೂತೊ, ನಕೊ ಚಲ್ಯಾಜಾ಼ಶು, ‘ಹಂದೇಖೊ, ಯೋ ಮಹಿನಕೋಣಾಮ ಛಾ಼’ ಕರಿ ಬೋಲ್ಯೂತೊ, ನಕೊ ನಂಬ್‌ಶು. ");
INSERT INTO vaa_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","ಶನಕತೊ ವಿಜ಼್‌ಳಿ ದನ್‌ನಿಕ್‌ಳಾ ಭಣೀಥು ದೆಖೈನ್, ದನ್ ಡುಬಾಭಣೀನು ಬಾಜು಼ತೋಡಿ ಚ಼ಮ್‌ಕಾಸ್ತೆ ಇಮ್ಮಸ್ ಅದ್ಮಿನೊ ಛಿಯ್ಯೊಬಿ ಆವ್‌ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","ಮುರ್ದು ಕಿಜ಼್ಜ ಪಡ್ಯುರ‍್ಹೇಸ್ಕಿ, ಹಿಜ್ಜಾ಼ಸ್ ಗರದ್‍ಖ್ಹಾರು ಎಕ್ಟುಹುವಾಸ್. ");
INSERT INTO vaa_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","ಯೋ ಖ್ಹಾರು ದನ್ನು ಖ್ಹತಾಪ್ಣಿ ಖತಮ್ ಹೋತಾಸ್‌ನ, ಚಾ಼ಂದ್ ಕಾಳೊಪಡಿಜಾ಼ಶೆ, ಚ಼ಂದರ್‌ಮೊ ಉಜಾ಼ಳು ಕೋದಿಶೇನಿ, ಆಬ್‍ಪರ್‌ಥು ಶುಕ್ಕರ್ ಖ್ಹಾರು ಖಂಕರ್‌ಶೆ, ಅಜು಼ ಆಬ್‍ಮ ಛಾ಼ತೆ ಶಕತ್‌ಖ್ಹಾರಿ ಕಾಪ್‌ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","ತದೆ ಅದ್ಮಿನೊ ಛಿಯ್ಯಾನ ವತಾಳವಾಳಿ ಖ್ಹಣೇದ್ ಆಬ್‍ಮ ದೆಖಾವ್‌ಶೆ. ತದೆ ಧರ್ತಿಪರ್ ಛಾ಼ತೆ ತಮಾಮ್‌ ಖೂಮ್‍ವಾಳು ಛಾ಼ತಿಪರ್ ಮಾರಿಲಿಶೆ ಅಜು಼ ಅದ್ಮಿನೊ ಛಿಯ್ಯೊ ಶಕತ್‌ಥೀಬಿ, ಮಹಾನ್ ಮಹಿಮೆಥೀಬಿ ಆಬ್‍ನ ವಾದ್ಳಪರ್ ಆವ್‌ಶೇತೆ ಇನ ದೇಕ್‌ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","ಅಜು಼ ಯೋ ತುತ್ತೂರಿನೊ ಮೋಟೊ ಅವಾಜ಼್‌ಥಿ, ಇನ ದೂತರ್‌ನ ಜ಼ಮೀನ್ನಿ ಚಾರ‍್ಹೆ ಬಾಜೂ಼ಮ ಮೋಕಲ್‌ಶೆ, ಇವ್ಣೆ ಇನೆ ಚೂ಼ಣಿಲಿದೊತೆ ಇವ್ಣುನ ಆಬ್‌ನ ಏಕ್‌ ಬಾಜು಼ಥು ಧರಿನ್ ಬಿಜೇಕ್ ಬಾಜೂ಼ಲಗು ಎಕ್ಟು ಕರ್ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","ಅಂಜೀರ್‌ನ ಝಾ಼ಡಾನಿ ಖೇಣಿಥಿ ತುಮೆ ಅಕ್ಕಲ್‍ಶಿಕೊ. ಇನಿ ಡಾಳಿಯೆ ಹರಿಗಾರ್ ಕವ್ಳಿ ಹುಯಿನ್, ಪಾಂದ್‌ಡ ಮ್ಹೇಲಾಲಗ್ಯುತೊ ತಡ್ಕಾನ ಹಗಾಮ್‌ ಖನ್ನೆ ಐಗು ಕರಿ ತುಮೆ ಮಾಲುಮ್‌ ಕರಿಲೇವೊಸ್ನಿ. ");
INSERT INTO vaa_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","ಇಮ್ಮಸ್, ತುಮೇಬಿ ಆ ಖ್ಹಾರು ದೇಖಾನಿ ವಖ್ಹ್‌ತೆ ಯೋ ದನ್ ಖನ್ನೆಛಾ಼, ಬಾಕಲ್‍ಕನಸ್‍ ಛಾ಼ಕರಿ ಮಾಲುಮ್ ಕರಿಲೆವೊ. ");
INSERT INTO vaa_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","ಹಮ್ಕೆ ಜಿವ್ತು ಛಾ಼ತೆ ಅದ್ಮಿಖ್ಹಾರು ಮರ್‌ವಾನ ಮಹಿಸ್ ಆ ಖ್ಹಾರು ಚಾ಼ಲ್‌ಶೇತೆ ಕರಿ ಮೇ ತುಮೂನ ಖ್ಹಾಚಮಾಬಿ ಬೋಲುಸ್. ");
INSERT INTO vaa_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","ಆಬ್-ಧರ್ತಿ ಮಟಿಜಾ಼ಶೆ, ಕತೋಬಿ ಮಾರಿ ವಾತೆಖ್ಹಾರಿ ಕದೇಬಿ ಮಟ್‌ಶೆಸ್ ಕೊಯ್ನಿ. ");
INSERT INTO vaa_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","ಎತ್ರೇಸ್ ಕಾಹೆತೆ, ಯೋ ದನ್ನಿ ಬಾರೇಮ ರ‍್ಹವೊ, ಯೋ ವಖ್ಹತ್‌ನಿ ಬಾರೇಮ ರ‍್ಹವೊ, ಮಾರ ಬಾನ ಮಾಲುಮ್ ಪಣ್ಕಿ ಬಿಜು಼ ಕಿನಾಬಿ ಮಾಲುಮ್‌ಕೊಯ್ನಿ; ಪರ್‌ಲೋಕ್‌ಮ ಛಾ಼ತೆ ದೇವ್‌ನು ದೂತರ್‌ನಾಬಿ ಮಾಲುಮ್‌ಕೊಯ್ನಿ; ಛಿಯ್ಯಾನಾಬಿ ಮಾಲುಮ್‌ಕೊಯ್ನಿ. ");
INSERT INTO vaa_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","ನೋಹಾನ ದನ್ಮ ಚಾ಼ಲ್ಯುತೆ ಇಮ್ಮಸ್ ಅದ್ಮಿನೊ ಛಿಯ್ಯೊ ಆವ್‌ಶೇತೆ ದನ್ಮ ಚಾ಼ಲ್‌ಷೆ. ");
INSERT INTO vaa_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","ಕಿಮ್‌ಕತೊ, ತೋಫಾನ್ ಆವಾನ ಅಗಾಡಿ ಅದ್ಮಿಖ್ಹಾರು ಖಾತು-ಪೀತು ಹುಯಿನ್, ವ್ಯಹಾ ಕರ್ತುಹುಯಿನ್, ವ್ಯಹಾ ಕರಿದೇತುಹುಯಿನ್ ಥೂ. ನೋಹಾನೆ ಜ಼ಹಾಜ಼್‌ನ ಮಹಿ ಚ಼ಢ್ಯೋತೆ ದನ್‌ಮಾಬಿ ಇವ್ಣೆ ಇಮ್ಮಸ್ ಕರುಕರ್ತುಥು. ");
INSERT INTO vaa_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","ತೋಫಾನ್ನು ಪಾಣಿ ಐನ್, ತಮಾಮ್‌ನ ವವ್ಹಾಡಿಲೀನ್, ಜಾ಼ವಾತೋಡಿ ಇವ್ಣೆ ಶಾತ್ಬಿ ಮಾಲುಮ್‌ಕೊಂತೆ ಇಮ್‌ ಥೂ. ಇಮ್ಮಸ್ ಅದ್ಮಿನೊ ಛಿಯ್ಯೊ ಆವ್‌ಶೇತೆ ತದೇಬಿ ರ‍್ಹಿಶೆ. ");
INSERT INTO vaa_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","ಯೋ ವಖ್ಹತ್‌ಮ ಖೇತರ್‌ಮ ಬೇ ಜ಼ಣು ಕಾಮ್ ಕರ್ತು ರ‍್ಹಿಶೆ, ಏಕ್‌ಜ಼ಣಾನ ಪಾಡಿಲಿಶೆ, ಅಜು಼ ಏಕ್‌ ಜ಼ಣಾನ ಮ್ಹೆಂದಿಶೆ. ");
INSERT INTO vaa_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","ಬೇ ತಯೇಡ ಬೇಶಿನ್, ಘಟ್ಟಿ ದಳುಕರ್‌ಶೆ, ಏಕ್‌ನ ಪಳ್ಳಿಶೆ ಏಕ್‌ನ ಮ್ಹೆಂದಿಶೆ. ");
INSERT INTO vaa_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","ಇನಖ್ಹಾಜೇಸ್ ತುಮಾರೊ ಪ್ರಭು ಆವ್‌ಶೇತೆ ದನ್ ತುಮುನ ಮಾಲುಮ್‌ಕೊಂತೆ ಇನಾಖ್ಹಾಜೆ ಹೊಷಾರ್‌ಥಿ ರ‍್ಹವೊ. ");
INSERT INTO vaa_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","ಚೋ಼ರ್ ಆವಾನಿ ವಖ್ಹತ್ ಘರ್‌ನ ಯಜಮಾನ್ನ ಮಾಲುಮ್ ರ‍್ಹಯುಹೋತ್ತೊ, ಯೋ ಹೊಷಾರಿ ರ‍್ಹೀನ್, ಇನ ಘರ್‌ನ ಕೋ ತೋಡಾದಿದೊಹೋತ್ನಿ. ");
INSERT INTO vaa_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","ಇನಖ್ಹಾಜೇಸ್ ತುಮೇಬಿ ಕದೇಬಿ ತೈಯಾರ್ ರ‍್ಹೇಣು, ಶನಕತೊ ತುಮೆ ಸೋಚಾಸ್‌ಕೊಂತೆ ವಖ್ಹತ್‌ಮ ಅದ್ಮಿನೊ ಛಿಯ್ಯೊ ಆವ್‌ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","ಇಮ್‍ಕತೊ, ಯಜಮಾನ್ ಇನ ಘರ್‌ಮ ಕಾಮ್ ಕರಾವಾಳ ಆಳ್‌ನ ಖ್ಹಾರು ಬರೋಬರ್‌ನಿ ವಖ್ಹತ್‌ಮ ಖಾಣು ದ್ಯವಾನಖ್ಹಾಜೆ ಇವ್ಣಾಪರ್ ನೇಮ್‌ಶಾಯೋತೆ ನಿಯತ್‍ವಾಳೊಬಿ ಅಕ್ಲಿಆಳ್‌ ಕೋಣ್? ");
INSERT INTO vaa_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","ಯಜಮಾನ್ ಆವಾನಿ ವಖ್ಹ್‌ತೆ, ಕೆಹೊ ಆಳ್‌ ಆ ಖ್ಹಾರು ಕರುಕರಾತೆ ದೇಕ್‌ಶೇಕಿ, ಯೋ ಆಳ್‌ ಧನ್ಯ ಹುಯಿರ‍್ಹೋಸ್! ");
INSERT INTO vaa_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","ಇಮ್ನ ಆಳ್‌ನ ಯೋ ಇನು ಖ್ಹಾರೂಸ್ ಧನ್‌-ದೌಲತ್‌ಪರ್ ಅದಿಕಾರಿಹುಯಿನ್ ನೇಮ್‌ಶಾವ್‌ಶೆ ಕರಿ ಮೇ ತುಮೂನ ಖ್ಹಾಚಮಾಬಿ ಬೋಲುಸ್. ");
INSERT INTO vaa_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","ಕತೋಬಿ ಯೋ ಆಳ್‌ ಖರಾಬ್ ರ‍್ಹಯೋತೊ, ಇನೊ ಯಜಮಾನ್ ಒಗ್ಗಿಸ್‌ಮ ಕೋ ಆವ್‌ಶೇನಿ ಕರಿ ಇನ ಮನ್‌ಮ ಸೋಚಿಲೀನ್, ");
INSERT INTO vaa_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","ಇನ ಜೋ಼ಡ್ಮ ಕಾಮ್‌ಕರವಾಳ ಬಿಜಾ಼ಖ್ಹಾರ ಆಳ್‌ನ ಮಾರಲಗ್‌ಶೆ ಅಜು಼ ಪೀ ಕುಡ್‌ಕಾವ್‍ನ ಜೋ಼ಡೆ ಖಾತೊ-ಪೀತೊ ರ‍್ಹಿಶೆ. ");
INSERT INTO vaa_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","ತದೆ ಏಕ್‌ ದನ್ನೆ ಯೋ ಆಳ್‌ ಸೋಚಾಸ್‌ಕೊಂತೆ ದನ್ಮ ಅಜು಼ ಇನ ಮಾಲುಮಸ್ ಪಡಾಕೊಂತೆ ವಖ್ಹತ್‌ಮ ಯೋ ಇನೊ ಯಜಮಾನ್ ಐನ್, ");
INSERT INTO vaa_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","ಇನ ಕತ್ರೀನ್, ಟುಕ್‌ಡಾ-ಟುಕ್‌ಡಾ ಕರೀನ್, ಖೋಟ್ ದಿಲ್‌ವಾಳಾನ ನಾಖಾಸ್ತೆ ಝ಼ಗೋಪರ್ ಇನ ನಾಕ್‌ಶೆ. ಹಿಜ್ಜಾ಼ ಯೋ ರೋವ್‌ತೊ ಹುಯಿನ್, ಕರ್‌-ಕರ್‌ ದಾತ್‌ ಚಾ಼ವ್‌ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","ಯೋ ವಖ್ಹತ್‌ಮ ಸೊರ್ಗಾನು ರಾಜ್ಯ ದೀವೊ ಖ್ಹಾರು ಪಾಡಿಲೀನ್, ನೌಶೊನ ಮಳಾನ ಜಾ಼ಸ್ತೆ ದಖ್ಹ್‌ ಜ಼ಣಿ ಕವಾರಿನಿಘೋಣಿ ರ‍್ಹಿಶೆ. ");
INSERT INTO vaa_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","ಇನಾಮ ಪಾಚ಼್ ಜ಼ಣಿ ಬುಧ್ಧು ಅಜು಼ ಪಾಚ಼್ ಜ಼ಣಿ ಅಕ್ಲಿ ಹುಯಿರ‍್ಹೀಥಿ. ");
INSERT INTO vaa_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","ಬುಧ್ಧು ಕವಾರಿಯೇನೆ ಇವ್ಣು ದೀವೋನ ಪಾಡಿಲಿದಿಯೆ, ಕತೋಬಿ ಜಾ಼ಖ್ಹತ್ ಆಲಿವ್‍ತೇಲ್‌ನ ಕೋ ಪಾಡಿಲಿದಿಯೇನಿ. ");
INSERT INTO vaa_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","ಅಕ್ಲಿ ಕವಾರಿಯೇನೆ ದೀವೋನ ಜೋ಼ಡೆ ಕಟೋರಿಮ ತೇಲ್‌ನಾಬಿ ಪಾಡಿಲಿದಿಯೆ. ");
INSERT INTO vaa_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","ನೌಶೊ ಆವಾನ ಧೇರ್ ಹೋತಾಖ್ಹತರ್, ಇವ್ಣೆ ಖ್ಹಾರು ಝೂಕಾರೆ ಮಾರಿನ್, ಖ್ಹುಯಿಗಯ್ಯೆ. ");
INSERT INTO vaa_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","ಕತೋಬಿ “ಅಧಿರಾತ್ಮ, ‘ಹಂದೇಖೊ, ನೌಶೊ ವಳ್ಯಾವಸ್! ಇನ ಮಳಾನಖ್ಹಾಜೆ ಆವೊ!’ ಕರಿ ಅವಾಜ಼್ ಆಯು. ");
INSERT INTO vaa_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","ತದೆ ಯೋ ದಖ್ಹ್‌ ಕವಾರಿಯೆ ಉಠೀನ್, ಇವ್ಣ ದೀವೋನ ತೈಯಾರ್ ಕರಿಲಿದಿಯೆ. ");
INSERT INTO vaa_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","ತದೆ ಯೋ ಬುಧ್ಧು ಕವಾರಿಯೇನೆ ಅಕ್ಲಿ ಕವಾರಿಯೇನ, ‘ತುಮಾರ ತೇಲ್‌ಮ ಹಮೂನ ಥೋಡು ದೆವೊ; ಶನಕತೊ, ಹಮಾರೊ ದೀವೊ ಉಝಾ಼ವಾನ ಆಯೊ’ ಕರಿ ಬೋಲಿಯೆ. ");
INSERT INTO vaa_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","ತದೆ ಅಕ್ಲಿ ಕವಾರಿಯೇನೆ, ‘ಕೊಯ್ನಿ, ‘ತುಮೂನ ದಿದುತೊ, ಹಮುನಾಬಿ ತುಮೂನಾಬಿ ಪೂರಾಕೊಂತೆ ಇಮ್‌ ಹುಯಿಜಾ಼ಶೆ. ತುಮೆ ವೇಚಾ಼ವಾಳಾಕನ ಜೈ಼ನ್, ಮೋಲ್ ಲೀಲೆವಾನೂಸ್ ಅಛ್ಛು಼’ ಕರಿ ಜ಼ವಾಬ್ ದಿದಿಯೆ.’ ");
INSERT INTO vaa_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","ಯೋ ಬುಧ್ಧು ಕವಾರಿಯೆ ತೇಲ್ ಲ್ಯಾವಾನ ಜಾ಼ವಾದಿನ್, ನೌಶೊ ಆಯೊ. ತೈಯಾರ್ ರ‍್ಹವಾಳಿಯೆ ವ್ಯಹಾನು ಮಿಝ಼್‌ವಾನ್ ಖಾವಾನಖ್ಹಾಜೆ ಇನಜೋ಼ಡೆ ಮಹಿ ಗಯ್ಯೆ. ತದೆ ಬಾಕಲ್ ಮೂಚೈ಼ಗಯು. ");
INSERT INTO vaa_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","ಅನ ಬಾದ್‌ಮ ಯೋ ಬುಧ್ಧು ಕವಾರಿಯೆ ಆಯಿನ್, ‘ಪ್ರಭು, ಪ್ರಭು ಮಹಿ ಆವಾನ ಬಾಕಲ್ ಕಾಡ್’ ಕರಿ ಚಿಕ್ರಿಲಿದಿಯೆ ");
INSERT INTO vaa_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","ತದೆ ಯೋ ನೌಶಾನೆ, ‘ತುಮೆ ಕೋಣ್ ಕರಿ ಮನ ಮಾಲುಮ್ ಕೊಯ್ನಿ, ಕರಿ ಮೇ ಖ್ಹಾಚಮಾಬಿ ಬೋಲುಸ್’ ಕರಿ ಬೋಲ್ಯೊ.” ");
INSERT INTO vaa_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","ಅಜು಼ ಯೇಸುನೆ ಖ್ಹರ್ತಿಮ ಬೋಲ್ಯೋಕಿ, “ಯೋ ದನ್‍ರ‍್ಹವೊ, ವಖ್ಹತ್‌ರ‍್ಹವೊ ತುಮೂನ ಮಾಲುಮ್‌ಕೊಂತೆ ಇನಖ್ಹಾಜೇಸ್ ಹೊಷಾರ್‌ಥಿರ‍್ಹವೊ. ");
INSERT INTO vaa_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“ಸೊರ್ಗಾನು ರಾಜ಼್ ಇನ ಘರ್‌ನ ಮ್ಹೆಂದಿನ್ ಬಿಜೇಕ್ ದೇಖ್ಹ್‌ನ ಗಯೋತೆ ಅದ್ಮಿನಿಘೋಣಿ ಹುಯಿರ‍್ಹೂಸ್. ಯೋ ಅದ್ಮಿ ಜಾ಼ವಾನ ಅಗಾಡಿ ಇನ ಆಳ್‌ನ ಖ್ಹಾರು ಬುಲೈನ್, ಇನು ಧನ್‌-ದೌಲತ್‌ನ ದೇಖಿಲ್ಯವಾನಖ್ಹಾಜೆ ಇವ್ಣುನ ನೇಮಕ್‍ಕರ‍್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","ಇನೆ ಏಕ್‌ನ ಪಾಚ಼್ ಹಜಾ಼ರ್, ಖ್ಹೊನ್ನಾನು ಬಿಲ್ಲು, ಬಿಜೇಕ್‌ನ ಬೇ ಹಜಾ಼ರ್, ಅಜು಼ ಬಿಜೇಕ್ ಜ಼ಣಾನ ಏಕ್‌ ಹಜಾ಼ರ್. ಅಮ್ ಇವ್ಣ ಇವ್ಣ ತಾಖತ್‌ ಎತ್ರೆ ಇವ್ಣುನ ದೀನ್, ಬಿಜೇಕ್ ದೇಖ್ಹ್‌ನ ಚ಼ಲೆಗಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","ಪಾಚ಼್ ಹಜಾ಼ರ್ ಖ್ಹೊನ್ನಾನು ಬಿಲ್ಲು ಲಿದಾಹುಯಾನೆ ಇನ ಲೀಜೈ಼ನ್, ಧಂದೊ ಕರಾನ ನಾಖಿನ್, ಇನೇಥಿ ಬಿಜು಼ ಪಾಚ಼್ ಹಜಾ಼ರ್ ಖ್ಹೊನ್ನಾನು ಬಿಲ್ಲು ಕಮೈಕರ‍್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","ಇಮ್ಮಸ್ ಬೇ ಹಜಾ಼ರ್ ಖ್ಹೊನ್ನಾನು ಬಿಲ್ಲು ಮಳ್ಯುಹುಯೊ ಬಿಜು಼ ಬೇ ಹಜಾ಼ರ್ ಖ್ಹೊನ್ನಾನು ಬಿಲ್ಲು ಕಮಾಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","ಕತೋಬಿ ಏಕ್‌ ಹಜಾ಼ರ್ ಬಿಲ್ಲು ಮಳ್ಯಾಹುಯಾನೆ ಜೈ಼ನ್, ಬಲ್ಡಾಮ ಖಾಡ್ ಖೋಂದಿನ್, ಇನು ಯಜಮಾನ್ನು ಬಿಲ್ಲಾನ ಲಪಾಡಿನಾಖ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","ಘಣ ದನ್ನ ಬಾದ್‌ಮ ಯೋ ಆಳ್‌ ಖ್ಹಾರಾನೊ ಯಜಮಾನ್ ಫಾಛೊ಼ ಆಯಿನ್, ಇವ್ಣೇಥಿ ಇಶಾಬ್ ಮಾಂಗ್‌ತಾನ, ");
INSERT INTO vaa_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","ಪಾಚ಼್ ಹಜಾ಼ರ್ ಖ್ಹೊನ್ನಾನು ಬಿಲ್ಲು ಲಿದಾಹುಯಾನೆ ಖ್ಹಾಮ್ಣೆ ಆಯಿನ್, ಇನಜೋ಼ಡೆ ಬಿಜು಼ ಪಾಚ಼್ ಹಜಾ಼ರ್ ಖ್ಹೊನ್ನಾನು ಬಿಲ್ಲಾ ಲಯಿನ್, ‘ಪ್ರಭು, ತುನೆ ಪಾಚ಼್ ಹಜಾ಼ರ್ ಖ್ಹೊನ್ನಾನು ಬಿಲ್ಲು ಮನ ದಿದೋಥೋನಿ, ಹಂದೇಕ್, ಇನಜೋ಼ಡೆ ಬಿಜು಼ ಪಾಚ಼್ ಹಜಾ಼ರ್ ಖ್ಹೊನ್ನಾನು ಬಿಲ್ಲು ಕಮೈರಾಖ್ಯೋಸ್’ ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","ತದೆ ಇನ ಯಜಮಾನ್ನೆ ಇನ, ‘ಶಬಾಶ್, ತೂ ಅಛ್ಛೊ಼ ಅಜು಼ ಭರೋಖ್ಹಾನೊ ಆಳ್‌! ಹುಯಿರ‍್ಹೋಸ್!’ ತೂ ಥೋಡಾಮ ನಿಯಥ್ಥಿ ರ‍್ಹಯೋತೆ ಇನಖ್ಹಾಜೆ, ಮೇ ತುನ ಮೋಟಾ ಕಾಮ್‌ಪರ್ ನೇಮ್‌ಶಾವುಸ್. ಐನ್, ಮಾರಿ ಖ್ಹುಶಿಮ ಭಾಗ್‌ ಹೂ’ ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“ತದೆ ಬೇ ಹಜಾ಼ರ್ ಖ್ಹೊನ್ನಾನು ಬಿಲ್ಲು ಲಿದೊಹುಯೊ ಆಳ್‌ ಖ್ಹಾಮ್ಣೆ ಐನ್, ಪ್ರಭು, ‘ತುನೆ ಮನ ಬೇ ಹಜಾ಼ರ್ ಖ್ಹೊನ್ನಾನು ಬಿಲ್ಲು ದಿದೊಥೋನಿ, ಹಂದೇಕ್, ಬಿಜು಼ ಬೇ ಹಜಾ಼ರ್ ಕಮೈರಾಖ್ಯೋಸ್’ ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","ಇನ ಯಜಮಾನ್ನೆ ಇನ, ‘ಶಬಾಶ್! ತೂ ಅಛ್ಛೊ಼ ಅಜು಼ ಭರೋಖ್ಹಾನೊ ಆಳ್‌ ಹುಯಿರ‍್ಹೋಸ್!’ ತೂ ಥೋಡಾಮ ನಿಯಥ್ಥಿ ರ‍್ಹಯೋತೆ ಇನಖ್ಹಾಜೆ, ‘ಮೇ ತುನ ಮೋಟಾ ಕಾಮ್‌ಪರ್ ನೇಮ್‌ಶಾವುಸ್, ತೂ ಐನ್, ಮಾರಿ ಖ್ಹುಶಿಮ ಭಾಗ್‌ ಹೂ!’ ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","ಅನ “ಬಾದ್‌ಮ ಏಕ್‌ ಹಜಾ಼ರ್ ಖ್ಹೊನ್ನಾನು ಬಿಲ್ಲು ದೇವ್ಣುಥೂತೆ ಇನೆ ಖ್ಹಾಮ್ಣೆ ಆಯಿನ್, ‘ಪ್ರಭು, ತೂ ಕಠಣ್‌ ಅದ್ಮಿಕರಿ ಮನ ಮಾಲುಮ್; ತೂ ಛಿಡ್‌ಕ್ಯೊಕೊಂತೆ ಇನ ವ್ಹಾಡವಾಳೊ, ತೂ ಗಾಡ್ಯೊಕೊಂತೆ ಅನಾಜ಼್‌ನ ಎಕ್ಟು ಕರಾವಾಳೊ. ");
INSERT INTO vaa_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","ಮೇ ಡರಿನ್, ತಾರ ಪೈಶಾನ ಜ಼ಮೀನ್‌ಮ ಲಪಾಡಿರಾಖ್ಯೊಥೊ. ಹಂದೇಕ್, ತಾರು ತುನಾಸ್ ದೆವ್‍ಕರೂಸ್’ ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","ತದೆ ಇನ ಯಜಮಾನ್ನೆ, ‘ತೂ ಖರಾಬ್ ಅಜು಼ ಶೋಂಬೇರಿ ಆಳ್‌ ಹುಯಿರ‍್ಹೋಸ್! ಮೇ ಛೀಡ್‌ಕ್ಯೊಕೊಂತೆ ಹಿಜ್ಜಾ಼ ವ್ಹಾಡವಾಳೊ, ಮೇ ಗಾಡ್ಯೊಕೊಂತೆ ಅನಾಜ಼್‌ನ ಎಕ್ಟು ಕರಾವಾಳೊ ಕರಿ ತುನ ಮಾಲುಮ್ ಥೂಕಿ ಶು? ");
INSERT INTO vaa_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","ಇಮ್‍ಕತೊ, ತೂ ಮಾರ ಪೈಶಾನ ಬಡ್ಡಿಪರ್ ದೇವ್ಣುಥು, ತದೆ ಮೇ ಆಯಿನ್, ಮಾರ ಪೈಶಾನ ಬಡ್ಡಿ ಖ್ಹಮೇದ್ ಲೀಲಿದೊಹೋತ್’ ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","ಅಜು಼ ಇನ ಆಳ್‌ ಖ್ಹಾರಾನ, ‘ಆ ದೇವ್ಣುತೆ ಯೋ ಪೈಶಾನ ಲೀನ್, ದಖ್ಹ್‌ ಹಜಾ಼ರ್ ಖ್ಹೊನ್ನಾನು ಬಿಲ್ಲಾ ಛಾ಼ತೆ ಇನ ದೆವೊ. ");
INSERT INTO vaa_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","ಕಿನಾಕನ ಥೋಡು ಛಾ಼ಕಿ ಇವ್ಣುನ ಬಿಜೂ಼ಬಿ ದೆವಾವ್‌ಶೆ, ಅಜು಼ ಇನ ಹೋಣುತೆ ಇನೇಥಿಬಿ ಜಾ಼ಖ್ಹತ್ ಇನ ಮಳ್‌ಶೆ; ಕತೋಬಿ ಕಿನಾಕನ ಶಾತ್ಬಿ ಕೊಯ್ನಿಕಿ, ಇನಾಕಂಥು ಇನಾಕನ ಛಾ಼ತೇಬಿ ಥೋಡು ಕಾಡಿಲಿಶೆ. ");
INSERT INTO vaa_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","ಅನಕೇಡೆಥು ಯೋ ಯಜಮಾನ್ನೆ, ಕಾಮ್ನಕೊಂತೆ ಆ ಖರಾಬ್ ಆಳ್‌ನ ಭಾರ್ ಅಂಧಾರಾಮ ನಾಖಿದೆವೊ; ಹಿಜ್ಜಾ಼ ಆ ರೊವ್‌ತೊಹುಯಿನ್, ಕರ್‌-ಕರ್‌ ದಾತ್‌ ಚಾ಼ವ್‌ಶೆ’ ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","ಅತ್ರೇಸ್ ಕಾಹೆತೆ ಅದ್ಮಿನೊ ಛಿಯ್ಯೊ ಇನಿ ಮಹಾನ್ ಮಹಿಮೆಥಿ ತಮಾಮ್‌ ದೇವ್‌ನು ದೂತರ್‌ನ ಜೋ಼ಡೆ ಆವಾನಿ ವಖ್ಹತ್‌ಮ, ಯೊ ಇನಿ ಮಹಿಮೆನು ಸಿಂಹಾಸನ್‍ಪರ್ ಬೇಖ್ಹ್‌ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","ಅಜು಼ ತಮಾಮ್‌ ದೇಖ್ಹ್‌ನು ಅದ್ಮಿಖ್ಹಾರು ಇನಖ್ಹಾಮ್ಣೆ ಎಕ್ಟು ಉಶೆ. ಚ಼ರಾವವಾಳೊ ಬೋಕ್‍ಡಾವ್‍ ಅಜು಼ ಮೇಂಢವ್‌ನ ಅಲಕ್ ಕರಾತೆ ಇಮ್ಮಸ್, ಯೊ ಇವ್ಣುನ ಅಲಕ್ ಕರೀನ್, ");
INSERT INTO vaa_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","ಮೇಂಢವ್‌ನ ಇನಿ ಖಾವಿ ಬಾಜೂ಼ಮ ಅಜು಼ ಬೋಕ್‍ಡಾವ್ನ ಇನಿ ಡಾವಿ ಬಾಜೂ಼ಮ ಭೀರಾಕ್‌ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","ತದೆ ರಾಜಾ಼ ಇನಿ ಖಾವಿ ಬಾಜೂ಼ಮ ಭಿಯುತೆ ಅದ್ಮಿ ಖ್ಹಾರಾನ, ‘ಮಾರ ಬಾನೆ ಆಶೀರ್ವಾದ್‌ ಕರ‍್ಯೊತೆ ತುಮೆ ಆವೊ, ಜಗತ್‌ ಉಬ್‌ಜ್ಯುತೆ ತಪ್‌ಥು ತುಮಾರಖ್ಹಾಜೆ ತೈಯಾರ್ ಹುಯಿರ‍್ಹೂತೆ ರಾಜ್ಯನ ಅಲ್ಲೇವೊ. ");
INSERT INTO vaa_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","ಮೇ ಭುಕ್ಯೊ ಥೊ, ತುಮೆ ಮನ ಖಾಣು ದಿದಾ; ಮೇ ಟೋಖ್ಹ್‌ಮ ಥೊ, ತುಮೆ ಮನ ಪಿಯ್ಯಾನ ದಿದಾ; ಮೇ ಪರೈ ಅದ್ಮಿಹುಯಿನ್ ಥೊ, ತುಮೆ ಮನ ಮಳೈಲಿದ; ");
INSERT INTO vaa_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","ಮೇ ಉಘಾಡೊ ಥೊ, ತುಮೆ ಮನ ಪೇರ‍್ಹಾನ ಲುಂಗ್ಡಾದಿದಾ; ಮೇ ರೋಗ್‌ಮ ಪಡ್ಯೋಥೊ, ತುಮೆ ಮನ ದೇಕ್-ಭಾಲ್ ಕರ‍್ಯಾ; ಮೇ ಜೇಲ್‌ಮ ಥೊ, ತುಮೆ ಮನ ದೇಖಾನ ಆಯಾಥಾ’ ಕರಿ ಬೋಲ್‌ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","ತದೆ ಯೋ ಧರ್ಮಿ ಅದ್ಮಿಖ್ಹಾರು, ‘ಪ್ರಭು, ಕದೆ ತೂ ಭುಕ್ಯೊ ಥೋತೆ ದೇಖಿನ್, ಹಮೆ ಖಾಣು ದಿದಾ? ನಾತೊ ಕದೆ ತೂ ಟೋಖ್ಹ್‌ಮ ಥೋತೆ ದೇಖಿನ್, ತುನ ಪಿಯ್ಯಾನ ದಿದಾ? ");
INSERT INTO vaa_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","ಕದೆ ತೂ ಪರೈ ಅದ್ಮಿ ಹುಯಿರ‍್ಹೊಥೋತೆ ದೇಖಿನ್, ಹಮೆ ತುನ ಮಳೈಲಿದ? ನಾತೊ ಕದೆ ತೂ ಉಘಾಡೊ ಥೋತೆ ದೇಖಿನ್, ಹಮೆ ತುನ ಪೇರ‍್ಹಾನ ಲುಂಗ್ಡ ದಿದಾ? ");
INSERT INTO vaa_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","ಕದೆ ತೂ ರೋಗ್‌ಮ ಥೋತೆ ದೇಖಿನ್, ನಾತೊ ಜೇಲ್‌ಮಥೋತೆ ದೇಖಿನ್, ಹಮೆ ತುನ ದೇಖಾನ ಆಯಾಥಾ?’ ಕರಿ ಬೋಲ್‌ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","ತದೆ ಯೋ ರಾಜಾ಼ ಫರೈನ್, ‘ಆ ಮಾರ ಭೇನೆ-ಭೈಯೇಮ ಕಡ್‌ತೇಲ್‌ನಿಮತ್ ಥೂತೆ ಏಕ್‌ನ ತುಮೆ ಶಶ್ಶಾತ್ ಕರ‍್ಯಾಕಿ, ಯೋ ಮನಾಬಿ ಕರಾದಾಖ್ಹಲ್ ಕರಿ ಮೇ ತುಮೂನ ಖ್ಹಾಚಮಾಬಿ ಬೋಲುಸ್’ ಕರಿ ಬೋಲ್‌ಶೆ! ");
INSERT INTO vaa_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","ಅನಕೇಡೆಥು ಯೋ ರಾಜ಼ ಇನಿ ಡಾವಿ ಬಾಜೂ಼ಮ ಭೀರ‍್ಯೂತೆ ಅದ್ಮಿಖ್ಹಾರಾನ, ‘ಮಾರೇಥಿ ದೂರ್ ಹಟಿಜಾ಼ವೊ, ತುಮೆ ದೇವ್ನಿ ಶಾಪ್ನ ಹೇಟ್ ಛಾ಼! ಮನ ಮ್ಹೆಂದಿನ್, ಶೈತಾನ್ನ ಅಜು಼ ಇನ ದೂತರ್‌ನಖ್ಹಾಜೆ ತೈಯಾರ್ ಹುಯಿರ‍್ಹೂತೆ ಹರ್‌ಹಮೇಶಾನಿ ಆಗ್‌ಮ ಜೈ಼ನ್, ಪಡೊ! ");
INSERT INTO vaa_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","ಮೇ ಭುಕ್ಯೊ ಥೊ, ತುಮೆ ಮನ ಖಾಣು ಕೋ ದಿದಾನಿ; ಮೇ ಟೋಖ್ಹ್‌ಮ ಥೊ, ತುಮೆ ಮನ ಪಿಯ್ಯಾನ ಕೋ ದಿದಾನಿ; ");
INSERT INTO vaa_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","ಮೇ ಪರೈ ಹುಯಿನ್ ಥೊ, ತುಮೆ ಮನ ಮಳೈಲಿದಾಕೊಯ್ನಿ; ಮೇ ಉಘಾಡೊ ಥೊ, ತುಮೆ ಮನ ಪೇರ‍್ಹಾನ ಲುಂಗ್ಡ ಕೋ ದಿದಾನಿ; ಮೇ ರೋಗ್‌ಮ ಥೊ, ತುಮೆ ಮನ ದೇಕ್‌ಭಾಲ್‌ ಕೋ ಕರ‍್ಯಾನಿ; ಮೇ ಜೇಲ್‌ಮ ಥೊ, ತುಮೆ ಮನ ದೇಖಾನ ಕೋಆಯನಿ’ ಕರಿ ಬೋಲ್‌ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","ತದೆ ಇವ್ಣೆ ಇನ, ‘ಪ್ರಭು, ಕದೆ ತೂ ಭುಕ್ಯೊ ಥೋತೆ, ನಾತೊ ಟೋಖ್ಹ್‌ಮ ಥೋತೆ, ನಾತೊ ಪರೈಹುಯಿನ್ ಥೋತೆ, ನಾತೊ ರೋಗ್‌ಮ ಥೋತೆ, ನಾತೊ ಜೇಲ್‌ಮಥೋತೆ ದೇಖಿನ್, ಹಮೆ ತುನ ಮದತ್ ಕರ‍್ಯಾಕೊಂತೆ ಗಯ?’ ಕರಿ ಪುಛಾ಼ವ್‌. ");
INSERT INTO vaa_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","ತದೆ ಯೋ ರಾಜ಼ ಫರೈನ್ ಇವ್ಣುನ, ‘ತುಮೆ ಆ ನ್ಹಾನಾವ್‍ಮ ಕಡ್‌ತೇಲ್‌ನಿಮತ್ ಛಾ಼ತೆ ಏಕ್‌ನ ಶಶ್ಶಾತ್ ಕೋ ಕರ‍್ಯಾನಿಕಿ, ಯೋ ಮನಾಬಿ ಕರ‍್ಯಾಕೊಯ್ನಿ ಕರಿ ಮೇ ತುಮೂನ ಖ್ಹಾಚಮಾಬಿ ಬೋಲುಸ್’ ಕರಿ ಬೋಲ್‌ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","ತದೆ ಖರಾಬ್ ಅದ್ಮಿ ಖ್ಹಾರಾನ ಹರ್‌ಹಮೇಶಾನಖ್ಹಾಜೆ ಡಂಡ್ ಉಶೆ ಅಜು಼ ಧರ್ಮಿ ಖ್ಹಾರಾನ ಹರ್‌ಹಮೇಶಾನಿ ಜಿ಼ಂದ್‌ಗಿ ಮಳ್‌ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","ಯೇಸುನೆ ಆವಾತೆಖ್ಹಾರಿ ಬೋಲಿನ್ ಖತಮ್ ಕರಾನ ಬಾದ್‌ಮ, ಇನ ಶಿಷ್ಯರ್‌ನ, ");
INSERT INTO vaa_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“ಬಿಜು಼ ಬೇ ದನ್ಮ ಪಸ್ಕ ಪೂಜಾ಼ ಆವ್‍ಶೆಕರಿ ತುಮೂನ ಮಾಲುಮ್; ತದೆ ಅದ್ಮಿನೊ ಛಿಯ್ಯಾನ ಶಿಲ್‌ಬೇಪರ್ ನಾಖಾನಖ್ಹಾಜೆ ಇವ್ಣಹಾತ್ಮ ದಿನಾಕ್‌ಶೆ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","ತದೆ ಗಲ್‌ಢಯಾಜಕರ್‌ಬಿ ಅಜು಼ ಶಾಣುಖ್ಹಾರು ಮಹಾಯಾಜಕ್ ಕಾಯಫನ ಮಹೇಲ್‌ಮ ಮಳೀನ್ಆಯು, ");
INSERT INTO vaa_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","ಯೇಸುನ ಕಿನಾಬಿ ಮಾಲುಮ್‌ಕೊಂತೆ ಇಮ್‌ ಧರೀನ್, ಮರೈನಾಕ್ಣು ಕರಿ ವಾತೆ ಕರಿಲಿದು. ");
INSERT INTO vaa_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","“ತೋಬಿ ಪೂಜಾ಼ನಿ ವಖ್ಹತ್‌ಮ ನಾ ಧರ್‌ನು, ಶನಕತೊ ಅಪ್ಣ ಅದ್ಮಿಮ ಕಲ್ಹಾಗಟ್ ಪಡಿಜಾ಼ಶೆ” ಕರಿ ಬೋಲಿಲಿದು. ");
INSERT INTO vaa_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","ಯೇಸು ಬೇಥಾನ್ಯಮ ಸೀಮೋನ್ನ ಘರ್‌ಮ ಥೊ, ಆ ಸೀಮೋನ್ ಅಗಾಡಿ ಖೋಡ್‍ವಾಳೊ ಹುಯಿರ‍್ಹೋಥೊ. ");
INSERT INTO vaa_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","ಯೇಸು ಖಾಣು ಖಾವಾನಿ ವಖ್ಹತ್‌ಮ, ಏಕ್‌ ತಯೇಡ ಘಣ ಮೋಲ್ನು ವಾನು ತೇಲ್ನ ಧೋಳ ಬಂಡಾನಿ ಶೀಶಿಮ ಲೀನ್, ಇನಾಕನ ಆಯಿನ್, ಯೋ ತೇಲ್ನ ಇನ ಮಾಥಪರ್ ರಂಚಿ. ");
INSERT INTO vaa_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","ಅನ ದೇಖಿನ್, ಶಿಷ್ಯರ್‌ನೆ ಖೀಜ಼್ ಕರ‍್ಯಾ, ಅಜು಼, “ಆ ವಾನು ತೇಲ್ನ ಶನ ಲುಕ್ಷಾನ್ ಕರಿ? ");
INSERT INTO vaa_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","ಆ ತೇಲ್ನ ಘಣ ಪೈಶಾನ ವೇಚಿನ್, ಆವಾಸ್ತೆ ಪೈಶಾನ ಗರೀಬ್‌ನ ದಿಯ್ಯೆಜಾ಼ಯಿಥೂನಿ?” ಕರಿ ಬೋಲ್ಯ. ");
INSERT INTO vaa_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","ಯೇಸುನೆ ಇವ್ಣೆ ಬೋಲುಕರಾತೆ ಮಾಲುಮ್‌ ಕರಿಲೀನ್ ಇವ್ಣುನ, “ತುಮೆ ಆ ತಯೇಡಾನ ಶನ ಖ್ಹತವ್‍ಕರಸ್ತೆ? ಅನೆ ಮಾರಖ್ಹಾಜೆ ಘಣು ಅಛ್ಛು಼ಕಾಮ್ ಕರಿರಾಖೀಸ್. ");
INSERT INTO vaa_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","ಗರೀಬ್ ಅದ್ಮಿಖ್ಹಾರು ಕದೇಬಿ ತುಮಾರಕನ ರ‍್ಹಿಶೆ, ಕತೋಬಿ ಮೇ ಹಮೇಶ ತುಮಾರಕನ ರ‍್ಹೀಶ್ ಕೊಯ್ನಿ. ");
INSERT INTO vaa_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","ಮೇ ಮರ್‌ವಾನ ಬಾದ್‌ಮ, ಮಾರು ಶರೀರ್‌ನ ಮಖ್ಹಾಣ್ಯು ಕರಾನಟೇಕೆ, ಅನೆ ಮಾರ ಆಂಗ್‌ತನ್‌ಪರ್ ವಾನು ತೇಲ್ನ ರಂಚಿರಾಖಿಸ್. ");
INSERT INTO vaa_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","ಮೇ ತುಮುನ ಖ್ಹಾಚಮಾಬಿ ಬೋಲುಸ್, ಹಿಡಿ ಜಗತ್‌ಮ ಆ ಅಛ್ಛಿ ಖಬರ್ ಕಿಜ಼್ಜ-ಕಿಜ಼್ಜ ಬೋಲಾವ್‌ಶೇಕಿ, ಹಿಜ್ಜಾ಼ ಖ್ಹಾರು ಅನೆ ಕರೀತೆ ಇನಾಬಿ ಅನಿ ಯಾದ್‌ನಖ್ಹಾಜೆ ಬೋಲ್‌ಶೆ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","ಅನ ಬಾದ್‌ಮ ಭಾರ ಶಿಷ್ಯರ್‌ಮ ಏಕ್‌ ಜ಼ಣೊ ಹುಯಿರ‍್ಹೊಥೋತೆ ಇಸ್ಕರಿಯೋತ ಯೂದಾನೆ ಗಲ್‌ಢಯಾಜಕರ್‌ಕನ ಜೈ಼ನ್, ");
INSERT INTO vaa_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","“ಮೇ ಇನ ಧೋಕೇಥಿ ಧರಿದಿದೋತೊ, ತುಮೆ ಮನ ಶಾತ್ ದಿಶು?” ಕರಿ ಪುಛಾ಼ಯೊ. ತದೆ ಇವ್ಣೆ ಡೋಡಿಖ್ಹ್‌ ರೂಪಾನು ಬಿಲ್ಲಾನ ಗಣೀನ್, ಇನ ದಿದು. ");
INSERT INTO vaa_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","ತಪ್‌ಥೊ ಯೂದ ಯೇಸುನ ಧರಿದ್ಯವಾನಿ ಬರೋಬರ್‌ನಿ ವಖ್ಹತ್‌ನಖ್ಹಾಜೆ ಜ಼ಪೂಕರ್ತೊಥೊ. ");
INSERT INTO vaa_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","ಖಾಟುಕೊಂತೆ ರೋಟಾನು ಪೂಜಾ಼ನ ಪಹಿಲ ದನ್ನೆ, ಶಿಷ್ಯರ್‌ ಯೇಸುಕನ ಐನ್, “ಹಮೆ ತಾರಖ್ಹಾಜೆ ಪಸ್ಕಾನು ಖಾಣನ ಕಿಜ಼್ಜಾ ತೈಯಾರ್ ಕರ‍್ನು?” ಕರಿ ಪುಛಾ಼ಯಾ. ");
INSERT INTO vaa_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","ತದೆ ಯೇಸುನೆ ಇವ್ಣುನ, “ತುಮೆ ಖ್ಹಯೇರ್‌ಮ ಮೇ ವತಾಳ್ಯೊತೆ ಇನಕನ ಜೈ಼ನ್ ಇನ, ‘ಮಾರಿ ವಖ್ಹತ್ ಖನ್ನೆ ಐಗೈ, ತಾರ ಘರ್‌ಮ ಮಾರ ಶಿಷ್ಯರ್‌ನ ಜೋ಼ಡೆ ಪಸ್ಕಾನು ಖಾಣು ಖವುಸ್ ಕರಿ ಗುರುನೆ ಬೋಲ್ಯೊ’ ಕರಿ ಬೋಲೊ.” ");
INSERT INTO vaa_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","ಶಿಷ್ಯರ್‌ನೆ ಯೇಸುನೆ ಇವ್ಣುನ ಬೋಲ್ಯೋತೆ ಇಮ್ಮಸ್ ಕರ‍್ಯಾ ಅಜು಼ ಪಸ್ಕಾನ ಖಾಣನ ತೈಯಾರ್ ಕರ‍್ಯಾ. ");
INSERT INTO vaa_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","ಖ್ಹಾಂಜ಼್ ಹುವ್ವಾದೀನ್, ಯೇಸು ಇನ ಭಾರ ಶಿಷ್ಯರ್‌ನ ಜೋ಼ಡೆ ಖಾಣನ ಬೇಶಿಗಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","ಇವ್ಣೆ ಖಾಣು ಖವ್‍ಕರಾನಿ ವಖ್ಹತ್‌ಮ, ಯೇಸುನೆ ಇವ್ಣುನ, “ಮೇ ಖ್ಹಾಚಮಾಬಿ ಬೋಲುಸ್ಕಿ, ತುಮಾರಾಮ ಏಕ್‌ ಜ಼ಣೊ ಮನ ಧೋಕೇಥಿ ಧರಿದಿಶೆ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","ತದೆ ಶಿಷ್ಯರ್‌ ಖ್ಹಾರು ಘಣು ದುಖ್‌ಥಿ, “ಪ್ರಭು, ಖ್ಹಾಚಮಾಬಿ ಮೇ ಕಾಹೆ ಕೊಯ್ನಿ?” ಕರಿ ಏಕ್‌ನ ಬಾದ್ಮ ಏಕ್‌ ಇನ ಪುಛಾ಼ವಲಗ್ಯಾ. ");
INSERT INTO vaa_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","ಯೇಸುನೆ, “ಕೋಣ್ ಮಾರ ಜೋ಼ಡ್ಮ ಕಟೋರಿಮ ಚೋ಼ಪ್‌ಡಾಸ್ಕಿ, ಯೋಸ್ ಮನ ಧೋಕೇಥಿ ಧರಿದ್ಯವಾಳೊ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","ವಚನ್‌ಮ ಲೀಖೈರ‍್ಹೂತೆ ಇಮ್ಮಸ್, ಅದ್ಮಿನೊ ಛಿಯ್ಯೊ ಮರ್‌ಶೆ, ಕತೋಬಿ ಕೋಣ್ ಅದ್ಮಿನೊ ಛಿಯ್ಯಾನ ಧರಿದಿಶೇಕಿ, ಇನಿ ಹಾಲ್ನ ಶಾತ್‌ ಬೋಲು! ಯೋ ಅದ್ಮಿ ಪೈದಾ ನಾಸ್ ಹುಯುಹೊತ್ತೊ ಇನ ಅಛ್ಛು಼ ಥೂ. ");
INSERT INTO vaa_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","ತದೆ ಇನ ಧೋಕೇಥಿ ಧರಿದೇಣು ಕರಿ ಥೋತೆ ಯೂದಾನೆ, “ಗುರು, ಖ್ಹಾಚಮಾಬಿ ಯೋ ಮೇತೊ ಕಾಹೆನಿ?” ಕರಿ ಪುಛಾ಼ಯೊ. ಯೇಸುನೆ ಇನ, “ತೂಸ್ ಬೋಲ್ಯೋನಿ” ಕರಿ ಜ಼ವಾಬ್ ದಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","ಇವ್ಣೆ ಖಾಣು ಖವ್‍ಕರಾನಿ ವಖ್ಹತ್‌ಮ, ಯೇಸುನೆ ರೋಟಾನ ಪಾಡೀನ್,ದೇವ್ನ ಧನ್ಯವಾದ್‌ ಕರೀನ್, ಇನ ತೋಡಿನ್, ಇನ ಶಿಷ್ಯರ್‌ನ ದೀನ್, “ಅಲ್ಲೇವೊ, ಅನಖಾವೊ, ಆ ಮಾರು ಶರೀರ್” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","ಅನಕೇಡೆಥು ಕಟೋರಿನ ಪಾಡಿನ್, ದೇವ್ನ ಧನ್ಯವಾದ್ ಕರೀನ್, ಇವ್ಣುನ ದೀನ್, “ತುಮೆ ಖ್ಹಾರು ಅನಾಮ ಪೀಯ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","ಆ ಮಾರು ಲ್ಹೋಯಿ, ಆ ದೇವ್‌ನು ನವು ಒಪ್ಪಂದಾನನ ಮುದ್ರೊ ಮರೈಹುಯು ಮಾರು ಲ್ಹೊಯಿ; ಕೈಯೆಕ್ಕಿ ಅದ್ಮಿನು ಪಾಪ್‌ಖ್ಹಾರು ಮಾಪ್‌ ಕರಾನಖ್ಹಾಜೆ ರಂಚಾ಼ಯುತೆ ಮಾರು ಲ್ಹೊಯಿ. ");
INSERT INTO vaa_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","ಮೇ ತುಮೂನ ಬೋಲುಸ್ಕಿ, ಹಂಕೇಥು ಧರೀನ್, ಬಾನಿ ರಾಜ್ಯಮ ನವು ದ್ರಾಕ್ಷಿನು ರಖ್ಹ್‌ ಪಿಯ್ಯಾನ ದನ್‌ತೋಡಿ, ಅನ ಮೇ ಪಾಛೊ಼ ಪೀಶಸ್ ಕೊಯ್ನಿ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","ಅನಕೇಡೆಥು ಇವ್ಣೆ ಸ್ತುತಿನು ಗೀದ್‌ ಬೋಲಿನ್ ಆಲಿವ್ ಪಹಡ್‌ಕನ ಚ಼ಲೇಗಯ. ");
INSERT INTO vaa_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","ತದೆ ಯೇಸುನೆ ಇವ್ಣುನ, “ಆ ರಾತೆ ತುಮೆ ಖ್ಹಾರುಸ್ ಮನ ಮ್ಹೆಂದಿನ್, ಮಿಲೈಜಾ಼ಶು; ದೇವ್ ವಚನ್‌ಮ ಬೋಲುಕರಸ್ ಮೆ ಮೇಂಢ ಚ಼ರಾವವಾಳಾನ ಮರ್‌ನಾಕಿಶ್, ತದೆ ಮಂಧಾಮಾಥು ಮೇಂಢ ಛಿಡ್‌ಗರ್‌ ಹುಯಿಜಾ಼ಶೆ, ");
INSERT INTO vaa_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","ಕತೋಬಿ ಮೇ ಜಿವ್ತೊಹುಯಿನ್, ಉಠಾನ ಬಾದ್‌ಮ ತುಮಾರೇಥಿ ಅಗಾಡಿ ಗಲಿಲಾಯ ಜೈ಼ಶ್” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","ತದೆ ಪೇತ್ರನೆ ಯೇಸುನ, “ಖ್ಹಾರು ಡರಿನ್, ತುನ ಮ್ಹೆಂದಿದಾತೋಬಿ ಮೇ ತುನ ಮ್ಹೇಲಿಶ್ ಕೊಯ್ನಿ” ಕರಿ ಬೋಲಾಖ್ಹತರ್, ");
INSERT INTO vaa_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","ಯೇಸುನೆ ಪೇತ್ರನ, “ಖ್ಹಾಚಮಾಬಿ ತುನ ಬೋಲುಸ್ಕಿ, ಆ ರಾತೇಸ್ ಮುರ್‌ಗೊ ಬಾಂಗ್‌ ದ್ಯವಾನ ಅಗಾಡಿ ತೂ ಮಾರಿ ಬಾರೇಮ, ‘ಯೋ ಮನ ಮಾಲುಮ್ ಕೊಯ್ನಿ’ ಕರಿ ತೀನ್‍ಹಲ್ಲ ಬೋಲಿಶ್” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","ಪೇತ್ರನೆ, “ಮೇ ತಾರ ಜೋ಼ಡ್ಮ ಮರಾನು ರ‍್ಹಯುತೋಬಿ, ಮೆ ತುನ ಮಾಲುಮ್‌ ಕೊಯ್ನಿ ಕರಿ ಕೋ ಬೋಲಿಶ್‌ನಿ” ಕರಿ ಬೋಲ್ಯೊ. ಅಜು಼ ಬಿಜಾ಼ಖ್ಹಾರ ಶಿಷ್ಯರ್‌ನೇಬಿ ಇಮ್ಮಸ್ ಬೋಲ್ಯ. ");
INSERT INTO vaa_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","ಅನಕೇಡೆಥು ಯೇಸು ಇನ ಶಿಷ್ಯರ್‌ನ ಜೋ಼ಡೆ ಗೆತ್ಸೆಮನೆ ಕರಿ ಬಾಗ್‌ನ ಗಯೊ, ಇವ್ಣುನ, “ಹಜ್ಜಾ಼ಸ್ ಬೇಖ್ಹೊ, ಮೇ ಹಿಜ್ಜಾ಼ ಜೈ಼ನ್, ಪ್ರಾರ್ಥನೆ ಕರೀನ್, ಆವುಸ್‌” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","ಅಮ್ ಬೋಲಿನ್, ಪೇತ್ರ ಅಜು಼ ಜೆಬೆದಾಯನ ಛಿಯ್ಯಾವ್‍ನ ಇನಜೋ಼ಡೆ ಬುಲೈಲಿ ಗಯೊ. ತದೆ ಯೇಸುನ ಘಣು ಘಬ್ರಾವ್‍ಣಿ ಹುಯು ಅಜು಼ ಯೋ ದುಖ್‌ಥಿ ಭರೈಗೊ. ");
INSERT INTO vaa_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","ಅಜು಼ ಯೇಸುನೆ ಇವ್ಣುನ, “ಮಾರೊ ಜಾನ್‌ ಮರ‍್ವಎತ್ರೆ ದುಖ್‌ಮ ಛಾ಼. ತುಮೆ ಹಾಸ್‌ರ‍್ಹೀನ್, ಮಾರ ಜೋ಼ಡೆ ಹೊಷಾರಿ ರ‍್ಹವೊ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","ಅನಕೇಡೆಥು ಯೋ ಜ಼ರ ಖ್ಹಾಮ್ಣೆ ಜೈ಼ನ್, ಜ಼ಮೀನ್‌ಪರ್ ಆಡೊ ಪಡೀನ್, “ಮಾರೊ ಬಾ, ಹೋತು ಉಶೇತೊ, ಆ ವದೇಖ್ಹಾನಿ ಕಟೋರಿ ಮನ ಮ್ಹೆಂದಿನ್ ಜಾ಼ವಾನಿಘೋಣಿ ಕರ್‌! ತೋಬಿ ಮಾರಿ ಮರ್ಜಿನಿಘೋಣಿ ಕಾಹೆ, ತಾರಿ ಮರ್ಜಿನಿ ಘೊಣಿಸ್ ಹುವಾದೆ” ಕರಿ ಪ್ರಾರ್ಥನೆ ಕರ‍್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","ಅನ ಯೇಸು ಯೋ ಶಿಷ್ಯರ್‌ಕನ ಆಯಿನ್, ಇವ್ಣೆ ಖ್ಹುತಾತೆ ದೇಖಿನ್, ಪೇತ್ರನ, “ಅಮ್‌ಕಿ ಶು? ತುಮೆ ಮಾರ ಜೋ಼ಡೆ ಏಕ್‌ ಘಡೀಬಿ ಹೊಷಾರಿ ರ‍್ಹವಾನ ಕೋ ಹೋಯ್ನಿಕಿ ಶು? ");
INSERT INTO vaa_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","ಶೋದನೆಮ ಪಡ್ಣುನಾತೆ ಇಮ್‌ ಹೊಷಾರಿ ರ‍್ಹೀನ್, ಪ್ರಾರ್ಥನೆ ಕರೊ. ಮನ್ ಛಾ಼ ಖ್ಹಾಚಸ್, ಕತೋಬಿ ಶರೀರ್‌ನ ಶಕತ್ ಪುರಾಕೊಯ್ನಿ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","ಬಿಜು಼ ಪಾಛೊ಼ ಭೇನೆಹಲ್ಲ ಜೈ಼ನ್, “ಮಾರೊ ಬಾ, ಮೇ ಆ ವದೇಖ್ಹಾನಿ ಕಟೋರಿನ ಪಿಯ್ಯಾಶೆ, ಆ ಮನ ಮ್ಹೆಂದಿನ್ ನಾ ಜಾ಼ವ್ಣುಕರಿ ತಾರಿ ಮರ್ಜಿ ಉಶೇತೊ, ತಾರಿ ಮರ್ಜಿನಿಘೋಣಿಸ್ ಹುವಾದೆ” ಕರಿ ಬೋಲಿನ್, ಪ್ರಾರ್ಥನೆ ಕರ‍್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","ಅನ ಬಾದ್‌ಮ ಪಾಛೊ಼ ಶಿಷ್ಯರ್‌ಕನ ಐನ್, ಇವ್ಣೆ ಖ್ಹುತಾತೆ ದೇಖ್ಯೊ; ಇವ್ಣ ಡೋಳಾಮ ನಿಂದರ್‌ ಚು಼ವ್‍ಕರ್ತಿಥಿ. ");
INSERT INTO vaa_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","ಅನಕೇಡೆಥು ಪಾಛೊ಼ ಇವ್ಣುನ ಮ್ಹೆಂದಿನ್ ಜೈ಼ನ್, ಯೋಸ್ ವಾತೇನ ಬೋಲ್ತೊಹುಯಿನ್, ತೀನ್ನೆಹಲ್ಲ ಪ್ರಾರ್ಥನೆ ಕರ‍್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","ಬಾದ್‌ಮ ಯೋ ಬಿಜು಼ ಪಾಛೊ಼ಫರಿನ್, ಇನ ಶಿಷ್ಯರ್‌ಕನ ಆಯಿನ್, “ತುಮೆ ಬಿಜೂ಼ಬಿ ಖ್ಹುಯಿನ್, ಅರಾಮ್‌ ಕರುಕರಾಸ್ಕಿ ಶು? ಹಂದೇಖೊ, ಅದ್ಮಿನೊ ಛಿಯ್ಯಾನ ಪಾಪಿ ಅದ್ಮಿಯೇನ ಹಾತ್‌ಮ ದೆವೈಜಾ಼ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","ಉಠೊ, ಜ಼ಯ್ಯೆ. ಮನ ಧೋಕೇಥಿ ಧರಿದ್ಯವಾಳೊ ಖನ್ನೆಸ್‌ ಐರ‍್ಹೋಸ್” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","ಯೇಸು ಅಜೂ಼ಬಿ ವಾತೆ ಬೋಲುಕರಾತೆ ತದ್ದೇಸ್, ಇನ ಭಾರಜ಼ಣ ಶಿಷ್ಯರ್‌ಮ ಏಕ್‌ ಜ಼ಣೊ ಹುಯಿರ‍್ಹೊಥೋತೆ ಯೂದ ಹಿಜ್ಜಾ಼ ಆಯೊ.ಇನ ಜೋ಼ಡ್ಮ ಗಲ್‌ಢಯಾಜಕರ್‌ ಅಜು಼ ಶಾಣುಖ್ಹಾರು ಬೋಲಿ ಮೋಕ್‌ಲ್ಯುತೆ ಅದ್ಮಿನಿ ಏಕ್‌ ಮೋಟಿ ಝೂ಼ಂಡಸ್ ತಲ್ವಾರೆ ಅಜು಼ ಲಠ್ಠ ಧರಿಲಿನ್ ಹಿಜ್ಜಾ಼ ಆಯು. ");
INSERT INTO vaa_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","ಯೇಸುನ ಧೋಕೇಥಿ ಧರಿದ್ಯವಾಳೊ ಯೋ ಅದ್ಮಿನಿ ಝೂ಼ಂಡ್‌ನ, “ಮೇ ಕಿನ ಬುಚ್ಚಾ಼ ದೆವ್‌ಸ್ಕಿ ಯೋಸ್‌ ತುಮೂನ ಹೋಣುತೆ ಅದ್ಮಿ. ಇನ ಧರೊ!” ಕರಿ ಖ್ಹಣೇದ್ ಬೋಲಿ ದೀರಾಖ್ಯೊಥೊ ");
INSERT INTO vaa_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","ಇಮ್ಮಸ್ ಯೂದ ಯೇಸುನ ಖನ್ನೆ ಜೈ಼ನ್, “ಗುರು, ಶೂಲ” ಕರಿ ಬೋಲಿನ್, ಇನ ಬುಚ್ಚಾ಼ ದಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","ತದೆ ಯೇಸುನೆ, “ದೋಸ್, ತೂ ಕರಾನ ಆಯೋತೆ ಕಾಮ್ ಆಸ್ಕಿಶು?” ಕರಿ ಬೋಲ್ಯೊ. ತದೆ ಇವ್ಣೆ ಖನ್ನೆ ಐನ್, ಯೇಸುಪರ್ ಹಾತ್‌ ನಾಖಿನ್, ಇನ ಧರ‍್ಯು. ");
INSERT INTO vaa_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","ಧರ್‌ತಾಸ್‌ನ ಯೇಸುನ ಜೋ಼ಡ್ಮ ಥೂತೆ ಇವ್ಣಾಮ ಏಕ್‌ನೆ, ಇನಿ ತಲ್ವಾರ್‌ನ ಕಾಡಿನ್, ಗಲ್‌ಢಯಾಜಕ್‌ನ ಆಳ್‌ನ ಮಾರಿನ್, ಇನು ಕಾನ್ನ ಕತ್ರಿನಾಖ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","ತದೆ ಯೇಸುನೆ ಇನ, “ತಾರಿ ತಲ್ವಾರ್‌ನ ಕಷ್‌ಬಂದ್‌ನಿ ಚ಼ಂಚಿಮ ಪಾಛು಼ ಘಾಲ್‌; ತಲ್ವಾರ್‌ಥಿ ಮಾರವಾಳು ಖ್ಹಾರು ತಲ್ವಾರ್‌ಥೀಸ್ ಮರ್‌ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","ಮೇ ಮಾರ ಬಾನ ಬೋಲಿಲಿದೋತೊ, ಯೋ ಮನ ಮದತ್ನಖ್ಹಾಜೆ ದೇವ್ ದೂತರ್‌ನು ಭಾರ ದಂಡ್‌-ದಳ್‌ವಾಯಿನಿ ಝೂ಼ಂಡ್‌ನ ಮೋಕಲ್‌ಶೆ ಕರಿ ತುನ ಮಾಲುಮ್‌ ಕೊಯ್ನಿಕಿ ಶು? ");
INSERT INTO vaa_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","ಕತೋಬಿ ಇಮ್‌ ಮೋಕ್‌ಲ್ಯೋತೊ, ಮನ ಅಮ್ನು ಖ್ಹಾರು ಹೋಣು ಕರಿ ವಚನ್‌ಮ ಬೋಲೈತೆ ವಾತೆ ಕಿಮ್ ಚಾ಼ಲ್‌ಷೆ?” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","ಯೋಸ್‍ ವೇಳ್ಮ ಯೇಸು ಝೂ಼ಂಡ್‍ಭಂದೈನ್ ಆಯಿರ‍್ಹುಥೂತೆ ಅದ್ಮಿವೋನ, “ಚೋ಼ರ್‌ನ ಧರಾನಿಘೋಣಿ ತಲ್ವಾರೆ ಅಜು಼ ಲಠ್ಠ ಪಳ್ಳಿನ್‌, ಮನ ಧರಾನಖ್ಹಾಜೆ ಆಯಾಕಿ ಶು? ಮೇ ದನ್‍ರೋಜ಼್, ಮಂದಿರ್‌ಮ ಬೇಶಿನ್, ವಚನ್ ಬೋಲಿನ್ ದೇವ್‌ಕರ್‌ತೊಥೋತೆ ತದೆ ತುಮೆ ಮನ ಧರ‍್ಯಾಕೊಯ್ನಿ. ");
INSERT INTO vaa_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","ಕತೋಬಿ ಪ್ರವಾದಿ ಖ್ಹಾರು ಲೀಖ್ಯೂತೆ ವಚನ್ ಪೂರಹುವಾನ ಟೇಕೆ ಅಮ್ ಹುಯು” ಕರಿ ಬೋಲ್ಯೊ. ತದೆ ತಮಾಮ್‌ ಶಿಷ್ಯರ್‌ ಇನ ಮ್ಹೆಂದಿನ್, ನಾಶಿ ಚ಼ಲೇಗಯ. ");
INSERT INTO vaa_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","ಯೇಸುನ ಧರ‍್ಯೂತೆ ಇವ್ಣೆ ಇನ ಗಲ್‌ಢಯಾಜಕ್‌ನ ಕಾಯಫನ ಘರೆ ಲೀನ್‌ಗಯು. ಹಿಜ್ಜಾ಼ ಮೋಶೆನಿ ವಚನ್‍ ಶಿಕಾಡವಾಳ ಶಾಸ್ತ್ರಿಯೆ, ಅಜು಼ ಶಾಣು ಖ್ಹಾರು ಎಕ್ಟು ಹುಯಿನ್ ಐರ‍್ಹುಥು. ");
INSERT INTO vaa_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","ಪೇತ್ರ ದೂರ್‌ಥೋಸ್ ಯೇಸುನ ಪೀಠೆ-ಪೀಠೆ ಜಾ಼ತೊಹುಯಿನ್, ಮಹಾಯಾಜಕ್‌ನ ಘರ್‌ನ ಖ್ಹಾಮ್ಣೆನು ಬಲ್ಡತೋಡಿ ಆಯಿನ್, ಮಹಿ ಧಕೆಲ್‌ತೊ ಅಯಿನ್, ಇನಿ ಹಾಲ್ ಶಾತ್‌ ಉಷೆಕರಿ ದೇಕ್ಣು ಕರಿ, ಕಾವ್ಲಿನ ಶಿಪಾಯಿನ ಜೋ಼ಡೆ ಜೈ಼ನ್, ಬೇಶಿಗಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","ತದೆ ಗಲ್‌ಢಯಾಜಕರ್‌ ಅಜು಼ ಯೆಹೂದಿ ಪಂಚಾಯತ್‌ನು ಹಿಡಿ ಅದ್ಮಿ ಶಾತ್‌ತೋಬಿ ಗಲತ್‌ ಸಬೂತ್ ಢೂಂಡಿನ್, ಯೇಸುನ ಮರೈನಾಖಿದೇಣು ಕರಿ ಕರ‍್ಯು. ");
INSERT INTO vaa_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","ಘಣು ಅದ್ಮಿ ಖ್ಹಾಮ್ಣೆ ಆಯಿನ್, ಯೇಸುಪರ್ ಝೂ಼ಟಿ ಸಾಕ್ಷಿಯೆ ಬೋಲ್ಯು, ತೋಬಿ ಇವ್ಣಿ ಸಾಕ್ಷಿಮ ಶಾತ್ಬಿ ಗಲತ್‌ ಮಳ್ಯುಕೊಯ್ನಿ. ಖ್ಹರ್ತಿಮ ಬೇ ಅದ್ಮಿ ಖ್ಹಾಮ್ಣೆ ಆಯಿನ್, ");
INSERT INTO vaa_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","“ದೇವ್‌ನು ಮಂದಿರ್‌ನ ರಡ್‌ಕೈ ನಾಖಿದೀನ್, ತೀನ್ ದನ್ಮ ಅನ ಪಾಛು಼ ಭಾಂದಾನ ಮನ ಹುವಾಸ್ ಕರಿ ಆ ಅದ್ಮಿನೆ ಬೋಲ್ಯೊ” ಕರಿ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","ತದೆ ಗಲ್‌ಢೊಯಾಜಕ್‌ನೆ ಉಠಿ ಭೀರಿನ್, ಯೇಸುನ, “ತೂ ಶಾತ್ಬಿ ಜವಾಬ್ ಕೋ ದೇಯ್ನಿಕಿ ಶು? ಅವ್ಣೆ ತಾರಪರ್ ಬೋಲುಕರಸ್ತೆ ಆ ಸಾಕ್ಷಿ ಖ್ಹಾಚಸ್‌ಕಿ ಶು?” ಕರಿ ಪುಛಾ಼ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","ಕತೋಬಿ ಯೇಸು ಖ್ಹೊಪ್ ಥೊ. ತದೆ ಮಹಾಯಾಜಕ್‌ನೆ ಪಾಛೊ಼, “ತುನ ಜಿವ್ತೊ ದೇವ್ನ ನಾಮ್‌ಪರ್‌ ಆಣ್‍ಲೀನ್, ಪುಛಾ಼ವುಸ್, ತೂ ದೇವ್‌ನೊ ಛಿಯ್ಯೊ ಕ್ರಿಸ್ತಸ್‌ಕಿಶು? ಹಮೂನ ಬೋಲ್” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","ಯೇಸುನೆ ಇನ, “ತುನೇಸ್ ಬೋಲ್ಯೋನಿ; ಅತ್ರೇಸ್ ಕಾಹೆತೆ ಮೇ ತುಮೂನ ಬೋಲುಸ್ಕಿ, ಹಂಕೇಥು ಅದ್ಮಿನೊ ಛಿಯ್ಯೊ ಮಹಾನ್ ಶಕತ್‌ವಾಳಾನಿ ಖಾವಿಬಾಜು಼ಮ ಬೆಠೊರ‍್ಹಿಶೇತೆ ಅಜು಼ ಆಬ್‍ನ ವಾದ್ಳಪರ್ ಬೇಶಿನ್ ಆವ್‌ಶೇತೆ ತುಮೆ ದೇಕ್‌ಶು!” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","ತದೆ ಮಹಾಯಾಜಕ್‌ನೆ ಇನ ಲುಂಗ್ಡಾನ ಫಾಡಿಲೀನ್, “ಆ ದೇವ್ನ ದೂಷಣೆ ಕರಾನಿ ವಾತೆ! ಅನೇಥಿ ಬಿಜು಼ ಖೆವಿ ಸಾಕ್ಷಿ ಅಪ್ಣುನ ಹೋಣು? ಅನೆ ದೇವ್ನ ಗಾಳೆಕರಾನಿ ವಾತೆ ಬೋಲ್ಯೋತೆ ತುಮೇಸ್ ಖ್ಹಮ್‌ಜ್ಯಾನಿ? ");
INSERT INTO vaa_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","ತುಮೂನ ಕಿಮ್ ದೆಖಾವಸ್?” ಕರಿ ಬೋಲ್ಯೊ. ತದೆ ಇವ್ಣೆ, “ಆ ದೋಶಿ ಬಿಜು಼ ಮರ್‌ವಾನ ಲ್ಹಾಯಕಸ್ ಛಾ಼” ಕರಿ ಜ಼ವಾಬ್ ದಿದು. ");
INSERT INTO vaa_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","ಅಜು಼ ಇವ್ಣೆ ಯೇಸುನ ಮ್ಹೋಡಾಪರ್ ಥೂಕಿನ್, ಇನ ಗುಖ್ಹ್‌ತೊ ದಿದು; ಥೋಡು ಜ಼ಣು ಇನ ಕಲ್ಲಪರ್ ಮಾರಿನ್, ");
INSERT INTO vaa_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","“ಕ್ರಿಸ್ತ, ತುನ ಮಾರ‍್ಯೂತೆ ಕೋಣ್? ಹಮೂನ ಪ್ರವಾದ್‌ನೆ ಬೋಲ್?” ಕರಿ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","ಪೇತ್ರ ಭಾರ್‌ ಚೌ಼ಕ್‌ಮ ಬೆಠೋಥೊ, ಹಿಜ್ಜಾ಼ ಏಕ್‌ಜ಼ಣಿ ದಾಸಿ ಇನಾಕನ ಐನ್, “ತೂಬಿ ಗಲಿಲಾಯಾನೊ ಯೇಸುನ ಜೋ಼ಡೆ ಥೋನಿ” ಕರಿ ಬೋಲಿ. ");
INSERT INTO vaa_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","ಕತೋಬಿ ಇನೆ, “ಕೊಯ್ನಿ, ತೂ ಶಾತ್‌ ಬೋಲುಕರಾಸ್ಕಿ ಮನ ಮಾಲುಮ್‌ ಕೊಯ್ನಿ” ಕರಿ ಖ್ಹಾರಾನ ಖ್ಹಾಮ್ಣೆ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","ಅಜು಼ ಯೋ ನಿಕ್ಳಿನ್, ಬಾಕಲ್‍ಭಣಿ ಚ಼ಲೆಗಯೊ. ತದೆ ಹಿಜ಼್ಜಾ ಥೀತೆ ಬಿಜೇಕ್ ಆಳ್‌ನೆ ಇನ ದೇಖಿನ್, ಹಿಜ್ಜಾ಼ ಥೂತೆ ಅದ್ಮಿ ಖ್ಹಾರಾನ, “ಆಬಿ ನಜ಼ರೇತ್‌ನೊ ಯೇಸುನ ಜೋ಼ಡೆ ಥೊ” ಕರಿ ಬೋಲಿ. ");
INSERT INTO vaa_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","ಪಾಛೊ಼ ಪೇತ್ರನೆ, “ಕೊಯ್ನಿ, ಯೋ ಅದ್ಮಿ ಕೋಣ್ ಕರಿ ಮನ ಮಾಲುಮ್ ಕೊಯ್ನಿ” ಕರಿ ಆಣ್‍ಲೀನ್, ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","ಜ಼ರಘಡಿನ ಬಾದ್‌ಮ ಹಿಜ಼್ಜಾ ಭಿಯುಥೂತೆ ಅದ್ಮಿಖ್ಹಾರು ಪೇತ್ರಕನ ಆಯಿನ್, “ಖ್ಹಾಚ಼ಮಾಬಿ ತೂಬಿ ಇವ್ಣಾಮ ಏಕ್‍ಜ಼ಣೊ,ಕರಿ ತೂ ವಾತೆ ಬೋಲಾಸ್ತೆ ತರಿಕಾಥಿಸ್ ಮಾಲುಮ್ ಪಡಾಸ್‌” ಕರಿ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","ತದೆ ಪೇತ್ರನೆ, ಇನುಯೋಸ್ ಆಣ್‌ಪ್ರಮಾಣ್‌ಲೀನ್ ಯೋ ಅದ್ಮಿ ಮನ ಮಾಲುಮಸ್‌ಕೊಯ್ನಿ” ಕರಿ ಬೋಲ್ಯೊ. ತದ್‌ನು-ತದೇಸ್‌ ಮುರ್‌ಗೊ ಬಾಂಗ್‌ ದಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","ತದೆ ಪೇತ್ರನೆ, ಮುರ್‌ಗೊ ಬಾಂಗ್‌ದ್ಯವಾನ ಅಗಾಡಿ, ತೀನ್‍ಹಲ್ಲ ಮಾರಿ ಬಾರೇಮ, ಯೋ ಮನ ಮಾಲುಮ್ ಕೊಯ್ನಿ! ಕರಿ ತೂ ಬೋಲಿಶ್” ಕರಿ ಯೇಸುನೆ ಇನ ಬೋಲ್ಯೊಥೋತೆ ವಾತೆನ ಯಾದ್‌ಕರಿನ್, ಭಾರ್ ಜೈ಼ನ್, ಖ್ಹಡ್‌ಕ್ಯಾಭರೀನ್ ರೋಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","ವ್ಹಾಣ್‌ಖ್ಹತ್ರೇಸ್ ಖ್ಹಾರಾಸ್ ಗಲ್‌ಢಯಾಜಕರ್‌ ಅಜು಼ ಶಾಣುಖ್ಹಾರು ಯೇಸುನ ಮರೈನಾಖಿದೇಣು ಕರಿ ಇನಿ ವಿರೋದ್ ವಾತೆ ಕರಿಲೀನ್, ");
INSERT INTO vaa_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","ಇನ ಖ್ಹಂಕ್‌ಳಿಥಿ ಭಂದೈನ್, ಬುಲೈಲಿಜೈ಼ನ್,ರೋಮ್‌ನೊ ರಾಜ್ಯಪಾಲ್ ಹುಯಿರ‍್ಹೊಥೋತೆ ಪಿಲಾತನ ಹಾತ್‌ಮ ದಿದು. ");
INSERT INTO vaa_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","ಯೇಸುನ ಧೋಕೇಥಿ ಧರಿದಿದೋತೆ ಯೂದಾನೆ, ಯೇಸುನ ಮರಣ್ ದಂಡ್‌ನು ತೀರ್ಪ್ ಹುಯು ಕರಿ ದೇಖಿನ್, ಪಶ್‌ತೈನ್, ಯೋ ಡೋಡಿಖ್ಹ್‌ ರೂಪಾನು ಬಿಲ್ಲಾನ ಗಲ್‌ಢಯಾಜಕರ್‌ ಅಜು಼ ಶಾಣವ್‍ಕನ ಲೀಜೈ಼ನ್, ");
INSERT INTO vaa_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","“ಶಾತ್ಬಿ ಗಲ್ತಿಕೊಂತೆ ಅದ್ಮಿನ ಧೋಕೇಥಿ ಮರೈನಾಖಿದ್ಯವಾನ ಧರಿ ದೀನ್, ಮೇ ಪಾಪ್ ಕರ‍್ಯೊ” ಕರಿ ಬೋಲ್ಯೊ. ತದೆ ಇವ್ಣೆ, “ಇನ ಹಮೆ ಶಾತ್ ಕರಿಯೆ? ಯೋ ತಾರು ಮಾಮ್ಲ!” ಕರಿ ಜ಼ವಾಬ್ ದಿದು. ");
INSERT INTO vaa_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","ತದೆ ಯೂದಾನೆ ಯೋ ಪೈಶಾನ ಮಂದಿರ್‌ಮ ಫೇಕಿದಿನ್, ಹಿಜ್ಜಾ಼ಥೊ ಜೈ಼ನ್, ಟೀಪೊ ಲೀನ್, ಮರಿಗಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","ಗಲ್‌ಢಯಾಜಕರ್‌ನೆ ಯೋ ಪೈಶಾನ ಪಾಡಿಲೀನ್, “ಆ ಪೈಶಾ ಏಕ್‌ ಅದ್ಮಿನ ಲ್ಹೋಯಿನಖ್ಹಾಜೆ ದಿದೂತೆ, ಇನಖ್ಹಾಜೆ ಅನ ಮಂದಿರ್‌ನಿ ಹುಂಡಿಮ ನಾಖಾನು ಅಪ್ಣಿ ನಿಯಮ್ನ ವಿರೋದ್ ಹುಯಿರ‍್ಹೂಸ್” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","ಅನಕೇಡೆಥು ಇವ್ಣೆ ವಾತೆ ಕರಿಲೀನ್, ಯೋ ಪೈಶಾಥಿ ಪರೈ ದೇಖ್ಹ್‌ನು ಅದ್ಮಿಯೇನ ಮಾಟಿ ಕರಾನಖ್ಹಾಜೆ ಏಕ್‌ “ಕುಂಭಾರ‍್ನು ಖೇತರ್‌” ಕರಿ ಜ಼ಮೀನ್ನ ಮೋಲ್ ಲಿದು. ");
INSERT INTO vaa_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","ಅನಖ್ಹಾಜೆಸ್ ಅದ್ಮಿಖ್ಹಾರು ಯೋ ಖೇತರ್‌ನ ಹಂಕೆತೋಡಿ, ‘ಲ್ಹೋಯಿನು ಖೇತರ್‌’ ಕರಿ ನಾಮ್‍ಥಿ ಚಿಕ್ರಾಸ್. ");
INSERT INTO vaa_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","ಅಮ್ ಹುವಾಥಿ ಪ್ರವಾದಿ ಯೆರೆಮೀಯನೆ ಬೋಲ್ಯೋತೆ ವಾತೆ ಚಾ಼ಲಿಗೈ, ಯೋ ಶಾತ್‌ಕತೊ, ಇವ್ಣೆ ಯೋ ಡೋಡಿಖ್ಹ್‌ ರೂಪಾನು ಬಿಲ್ಲಾನ ಲೀನ್,ಆ ಇಸ್ರಾಯೇಲ್‌ಮ ಥೋಡಾನೆ ಇನ ಜಾನ್ನ ಭಾಂದ್ಯೂತೆ ಮೋಲ್” ಕರಿ ಬೋಲನುಸ್ ಯೋ ವಚನ್ ");
INSERT INTO vaa_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","ಪ್ರಭುನೆ ಹುಕುಮ್ ದಿದೋತೆ ಇಮ್ಮಸ್, ಇನೇಥಿ ಕುಂಭಾರ‍್ನು ಖೇತರ್‌ನ ಮೋಲ್‍ಲಿಧು. ");
INSERT INTO vaa_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","ತದೆ ಯೇಸು ಪಿಲಾತನ ಖ್ಹಾಮ್ಣೆ ಭಿಯ್ಯುಥೊತೆ ತದೆ ಇನೆ ಇನ, “ತೂ ಯೆಹೂದ್ಯರ್‌ನೊ ರಾಜಾ಼ಕಿ ಶು?” ಕರಿ ಪುಛಾ಼ಯೊ. ಯೇಸುನೆ ಇನ, “ತುನೇಸ್ ಬೋಲ್ಯೋನಿ” ಕರಿ ಜ಼ವಾಬ್ ದಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","ಗಲ್‌ಢಯಾಜಕರ್‌ ಅಜು಼ ಶಾಣುಖ್ಹಾರು ಇನಾಪರ್ ಘಣು ಗಲತ್‌ ಲಗಾಡುಕರ್ತುಥು, ತೋಬಿ ಯೇಸುನೆ ಶಾತ್ಬಿ ಜವಾಬ್‌ ಕೋ ದಿದೋನಿ. ");
INSERT INTO vaa_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","ತದೆ ಪಿಲಾತನೆ ಯೇಸುನ, “ಅವ್ಣೆ ತಾರಾಪರ್ ಅತ್ರೆ ಗಲ್ತಿ ಲಗಾಡುಕರಾಸ್ತೆ, ತೂ ಖ್ಹಮ್‌ಜು಼ಕರಾಕೊಯ್ನಿಕಿ ಶು?” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","ಕತೋಬಿ ಯೇಸುನೆ ಇನಿ ಏಕ್‌ ವಾತೆನಾಬಿ ಜ಼ವಾಬ್ ಕೋ ದಿದೋನಿ, ಅನ ದೇಖಿನ್, ಯೋ ರಾಜ್ಯಪಾಲ್‌ನ ಘಣು ಆಶ್ಚರ್ಯ ಹುಯು. ");
INSERT INTO vaa_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","ಪಸ್ಕ ಪೂಜಾ಼ನಿ ವಖ್ಹತ್‌ಮ ಕೋಂಡಿ ಘಾಲಿರಾಖಾತೆ ಅದ್ಮಿಮ, ಅದ್ಮಿಖ್ಹಾರು ಕಿನ ಬೋಲಸ್ಕಿ, ಇನ ಭಾರ್ ಮ್ಹೇಲಾನು ರಾಜ್ಯಪಾಲ್‌ನು ಆದತ್ ಹುಯಿರ‍್ಹೀಥಿ. ");
INSERT INTO vaa_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","ಯೋ ವಖ್ಹತ್‌ಮ ಯೇಸು ಬರಬ್ಬ ಕರಿ ಏಕ್‍ಜ಼ಣಾನ ಜೇಲ್‌ಮ ಘಾಲಿರಾಖ್ಯುಥು. ");
INSERT INTO vaa_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","ಅದ್ಮಿಖ್ಹಾರು ಪಿಲಾತಕನ ಎಕ್ಟು ಹುಯಿನ್ ಆವಾದಿನ್, ಇನೆ ಇವ್ಣುನ, “ಮೇ ತುಮಾರಖ್ಹಾಜೆ ಕಿನ ಮ್ಹೇಲಿದೇಣು ಬರಬ್ಬಾನಾಕಿ, ಕ್ರಿಸ್ತ ಕರಿ ಬೋಲೈಲ್ಯವಾಳೊ ಯೇಸುನ?” ಕರಿ ಪುಛಾ಼ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","ಅದ್ಮಿಖ್ಹಾರು ಬಳಾಪೇಥಿ ಯೇಸುನ ಧರೀನ್, ಇನ ಹಾತ್‌ಮ ದೀರಾಖ್ಯುಸ್‌ ಕರಿ ಪಿಲಾತನ ಮಾಲುಮ್‌ ಥು. ");
INSERT INTO vaa_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","ಅತ್ರೇಸ್ ಕಾಹೆತೆ, ಪಿಲಾತ ನ್ಯಾವ್‍ನಿ ಖುಡ್‍ಶಿಪರ್ ಬೆಠೊರ‍್ಹವಾನಿ ವಖ್ಹತ್‌ಮ ಇನಿ ಬಾವಣ್ಣೆ, “ಯೋ ಅದ್ಮಿನ ಶಾತ್ಬಿ ನಕೊ ಕರೀಶ್, ಯೋ ನೀತಿವಾಳೊ ಹುಯಿರ‍್ಹೊಸ್, ಗಯೋತೆ ರಾತೆ ಖ್ಹೋಣ್ಯಮ ಮನ ಘಣು ಖ್ಹತಾಪ್ಣಿ ಹುಯು” ಕರಿ ಇನ ಬೋಲಿನ್ ಮೋಕ್ಲಿ. ");
INSERT INTO vaa_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","ಕತೋಬಿ ಗಲ್‌ಢಯಾಜಕರ್‌ ಅಜು಼ ಶಾಣುಖ್ಹಾರು ಬರಬ್ಬನ ಮ್ಹೇಲಿದೇಣು, ಯೇಸುನ ಮರೈನಾಕ್ಣು ಕರಿ ಪಿಲಾತನ ಬೋಲಿಲೇವ್ಣು ಕರಿ ಅದ್ಮಿಯೇನ ಬೋಲಿದಿದು. ");
INSERT INTO vaa_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","ಪಿಲಾತನೆ ಇವ್ಣುನ, “ಆ ಬೇಮ ತುಮಾರಖ್ಹಾಜೆ ಕಿನ ಮ್ಹೇಲಿದೇಣು?” ಕರಿ ಪುಛಾ಼ಯೊ. ಇವ್ಣೆ, “ಬರಬ್ಬಾನ” ಕರಿ ಜ಼ವಾಬ್ ದಿದು. ");
INSERT INTO vaa_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","ತದೆ ಪಿಲಾತನೆ, “ಇಮ್‍ಕತೊ, ಕ್ರಿಸ್ತ ಕರಿ ಬೋಲೈಲ್ಯವಾಳೊ ಯೇಸುನ ಮೇ ಶಾತ್‌ ಕರ‍್ನು?” ಕರಿ ಇವ್ಣುನ ಪುಛಾ಼ಯೊ. ತದೆ ಇವ್ಣೆ ಖ್ಹಾರಾಸ್, “ಇನ ಶಿಲ್‌ಬೇಪರ್ ಮರಾವ್!” ಕರಿ ಜ಼ವಾಬ್ ದಿದಾ. ");
INSERT INTO vaa_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","ಕತೋಬಿ ಪಿಲಾತನೆ, “ಶನ? ಅನೆ ಶನಿ ಗಲ್ತಿ ಕರಿರಾಖ್ಯೋಸ್?” ಕರಿ ಬೋಲ್ಯೊ. ತದೆ ಇವ್ಣೆ, “ಇನ ಶಿಲ್‌ಬೆಪರ್ ಮರಾವ್!” ಕರಿ ಬಿಜೂ಼ಬಿ ಜೋ಼ರೇಖ್ಹು ನಳ್ಡೊ ತಾಣಿನ್ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","ತದೆ ಪಿಲಾತನೆ ಮೇ ಕೆತ್ರು ಕರ‍್ಯೊತೋಬಿ ಚಾ಼ಲ್‌ಷೆ ಕೊಯ್ನಿ, ಅದ್ಮಿಖ್ಹಾರು ಕಲ್ಹಾಗಟ್ ಕರೆಜಾ಼ಯ್ ಕರಿ ಮಾಲುಮ್ ಕರಿಲೀನ್, ಪಾಣಿ ಲೀನ್, ಅದ್ಮಿನ ಖ್ಹಾಮ್ಣೆ ಇನ ಹಾತ್ನ ಧೊಯಿಲಿನ್, “ಆ ಅದ್ಮಿನ ಮರೈನಾಖನ ಮೇ ಜಿಮ್ಮೇದಾರ್ ಕಾಹೆ, ಆ ತುಮೇಸ್ ಕರುಕರಸ್ತೆ!” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","ತದೆ ಝೂ಼ಂಡ್‌ಮ ಥೂತೆ ಹಿಡಿ ಅದ್ಮಿನೆ, “ಆ ಅದ್ಮಿನ ಮರೈನಾಖಿದ್ಯವಾನಿ ಜಿಮ್ಮೇದಾರ್ ಹಮಾರಪರ್ ಅಜು಼ ಹಮಾರ ಲಡ್ಕಾಪರ್ ಪಡಾದೆ!” ಕರಿ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","ತದೆ ಪಿಲಾತನೆ ಬರಬ್ಬಾನ ಇವ್ಣುನ ಮ್ಹೇಲಿದಿದೊ, ಅಜು಼ ಯೇಸುನ ಕೊಳ್ಡೇಥಿ ಮರೈನ್, ಶಿಲ್‌ಬೆಪರ್ ನಾಖಾನ ದಿನಾಖ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","ಅನಕೇಡೆಥು ಪಿಲಾತನು ಸಿಪಾಯಿಖ್ಹಾರು ಯೇಸುನ ರಾಜ಼ನ ಮಹೇಲ್‌ಮ ಬುಲೈಲೀಜೈ಼ನ್, ಹಿಡಿ ದಂಡ್‌-ದಳವಾಯಿಸ್ ಹಿಜ಼್ಜ ಎಕ್ಟು ಹುಯಿನ್ ಭರೈರ‍್ಹೂಥು. ");
INSERT INTO vaa_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","ಇವ್ಣೆ ಯೇಸುನ ಲುಂಗ್ಡಾವ್‍ನ ಕಾಡಿನಾಖಿನ್, ಲಾಲ್‍ಝ಼ಗ್ಗಾನ ಇನ ಫೇರೈನ್, ");
INSERT INTO vaa_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","ಕಾಟಾನ ವೇಲಾಥಿ ಏಕ್‌ ಕಿರೀಟ್‍ನ ವಣಿನ್, ಇನ ಮಾಥಪರ್‌ ಘಾಲ್ಯು ಅಜು಼ ಖಾವೊ ಹಾತ್ಮ ಏಕ್‌ ಲಠ್ಠೊ ದೀನ್, ಇನಖ್ಹಾಮ್ಣೆ ಗುಡ್‍ಘ್ಯ ಟೇಕಿನ್, “ಯೆಹೂದ್ಯರ್‌ನ ರಾಜ಼! ತುನ ಜಯ ಹುವಾದೆ” ಕರಿ ಬೋಲಿಲಿನ್ ನಕ್ಲೆ ಕರ‍್ಯು, ");
INSERT INTO vaa_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","ಇವ್ಣೆ ಇನಪರ್ ಥೂಕಿನ್, ಯೋ ಲಠ್ಠಾನ ಛಿನೈಲಿನ್‌, ಇನೇಥಿ ಇನ ಮುಡ್‌ಕ್ಯಪರ್ ಮಾರ‍್ಯು, ");
INSERT INTO vaa_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","ಅಮ್ ಇನಿ ನಕ್ಲೆ ಕಾಡಾನ ಬಾದ್‌ಮ, ಯೋ ಝ಼ಗ್ಗಾನ ಕಾಡಿನ್, ಇನ ಲುಂಗ್ಡಾವ್‍ನ ಇನ ಪಾಛು಼ ಫೇರೈನ್, ಶಿಲ್‌ಬೆಪರ್ ಮಾರಾನಖ್ಹಾಜೆ ಲೀಗಯು. ");
INSERT INTO vaa_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","ಇವ್ಣೆ ಖ್ಹಯೇರ‍್ನ ಭಾರ್‌ ಜ಼ವ್‍ಕರಾನಿ ವಖ್ಹತ್‌ಮ, ಸಿರೇನ್ ಖ್ಹಯೇರ‍್ನೊ ಸೀಮೋನ್‌ ಕರಿ ಏಕ್‌ ಜ಼ಣಾನ ಧರೀನ್, ಯೇಸುನಿ ಶಿಲ್‌ಬೆ ಪಾಡ್‌ಕರಿ ಶಿಪಾಯಿಖ್ಹಾರು ಇನ ಜು಼ಲಮ್‌ ಕರ‍್ಯು. ");
INSERT INTO vaa_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","ಅಜು಼ ಇವ್ಣೆ ಗೊಲ್ಗೊಥಾ ಕರಿ ಝ಼ಗೋಪರ್ ಆಯಾ, ಗೊಲ್ಗೊಥಾ ಕತೊ, “ಖೋಪ್ರಿನಿ ಝ಼ಗೊ” ಕರಿ. ");
INSERT INTO vaa_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","ಹಿಜ್ಜಾ಼ ಇವ್ಣೆ ಇನ ಕಡು ಮಳಾಯುಹುಯು ದ್ರಾಕ್ಷಿನು ರಖ್ಹ್‌ನ ಪಿಯ್ಯಾನ ದಿದು; ಇನೆ ಲಜ಼ತ್‌ ದೇಖಿನ್‌ ಪಿಯಾನ ಕೊಹುಯುನಿ. ");
INSERT INTO vaa_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","ಅನಕೇಡೆಥು ಇವ್ಣೆ ಇನ ಶಿಲ್‌ಬೆಪರ್ ನಾಖ್ಯು ಅಜು಼ ಚೀಟ್ ನಾಖಿನ್ ಇನ ಲುಂಗ್ಡಾವ್‍ನ ಇವ್ಣಾಮ ವಾಟ ಪಾಡಿಲಿದು. ");
INSERT INTO vaa_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","ಅನ ಬಾದ್‌ಮ ಇವ್ಣೆ ಹಿಜ್ಜಾ಼ಸ್ ಬೇಶಿನ್, ಇನ ವಖ್ಹ್‌ತಿ ಕರಾಲಗ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","ಅತ್ರೇಸ್ ಕಾಹೆತೆ ಇವ್ಣೆ ಯೇಸುಪರ್ ಲಗಾಡ್ಯುತೊ ಗಲ್ತಿನು ಲೀಖಿಹುಯು ಪಲ್ಗಾನ, ಮುಡಕ್ಯಪರ್‌ನಿ ಉಪ್ಪರ್‌ಲಿ ಬಾಜು಼ ಶಿಲ್‌ಬೆಪರ್ ಲಗಾಡ್ಯು: ಯೋ ಶಾತ್‌ಕತೊ, “ಆ ಯೇಸು, ಯೆಹೂದ್ಯರ್‌ನೊ ರಾಜ಼” ಕರಿ. ");
INSERT INTO vaa_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","ತದೆ ಬೇ ಜ಼ಣ ಚೋ಼ರ್‌ನ ಲಯಿನ್, ಏಕ್‌ಜ಼ಣಾನ ಯೇಸುನಿ ಖಾವಿ ಬಾಜೂ಼ಮ ಅಜು಼ ಬಿಜೇಕ್‌ ಜ಼ಣಾನ ಇನಿ ಡಾವಿ ಬಾಜೂ಼ಮ ಇನಿ ಜೋ಼ಡೆ ಶಿಲ್‌ಬೆಪರ್ ಠಂಗಾಯು. ");
INSERT INTO vaa_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","ಹಿಜ್ಜಾ಼ಕರಿ ಜಾ಼ವಾಳು ಅದ್ಮಿಖ್ಹಾರು ಮುಡ್‌ಕ್ಯು ಠಶ್‌ಕೈನ್ ದೂಷಣೆ ಕರ್ತುಹುಯಿನ್, ");
INSERT INTO vaa_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“ಮಂದಿರ್‌ನ ಫೋಡಿನ್, ಇನ ತೀನ್ ದನ್ಮ ಪಾಛು಼ ಭಾಂದಾವಾಳ, ತಾರು ತೂಸ್ ಬಚಾ಼ಡಿಲೆ! ತೂ ದೇವ್‌ನೊ ಛಿಯ್ಯೋಸ್ ಉಶೇತೊ, ಶಿಲ್‌ಬೆಪರ್‌ಥು ಉತ್ರಿನ್, ಹೇಟ್ ಆವ್!” ಕರಿ ಬೋಲಿನ್, ಇನ ಚಿಂಘಾವ್‍ಕರ್ತೂಥು. ");
INSERT INTO vaa_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","ಇಮ್ಮಸ್ ಗಲ್‌ಢಯಾಜಕರ್‌ಬಿ, ಮೋಶೆನಿ ವಚನ್‍ ಶಿಕಾಡವಾಳು ಶಾಸ್ತ್ರಿಖ್ಹಾರು ಅಜು಼ ಶಾಣುಖ್ಹಾರು, ");
INSERT INTO vaa_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“ಇನೆ ಬಿಜಾ಼ನಖ್ಹಾರು ಬಚಾ಼ಡ್ಯೊ, ಕತೋಬಿ ಇನು ಯೋಸ್ ಬಚಾ಼ಡಿಲ್ಯವಾನ ಕೋ ಹೋಯ್ನಿ! ಆ ಇಸ್ರಾಯೇಲ್‌ನೊ ರಾಜಾ಼ ಕಾಹೆಕಿ ಶು? ಆ ಹಮ್ಕೆ ಶಿಲ್‌ಬೆಪರ್‌ಥು ಉತ್ರಿನ್ ಹೇಟ್ ಆಯೋತೊ, ತದೆ ಹಮೆ ದೇಖಿನ್, ಇನಾಮ ವಿಶ್ವಾಸ್ ಕರ್ಶು! ");
INSERT INTO vaa_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","ಆ ದೇವ್ನ ಮಾನಿರಾಖ್ಯೊಸ್‌ನಿ, ಅಜು಼ ದೇವ್ನ ಆ ಹೋಣು ಉಶೇತೊ, ದೇವಸ್ ಇನ ಛೋ಼ಡಾವಾದೆ! ಮೇ ದೇವ್‌ನೊ ಛಿಯ್ಯೊ ಕರಿ ಇನೇಸ್‌ ಬೋಲಿಲಿದೋನಿ!” ಕರಿ ಬೋಲಿನ್ ಚಿಂಘಾಯು. ");
INSERT INTO vaa_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","ಇನ ಜೋ಼ಡ್ಮ ಆಜು಼ಬಾಜು಼ನ ಶಿಲ್‌ಬೆಪರ್ ಮರೈರ‍್ಹೂಥೂತೆ ಭೇ ಚೋ಼ರ್‌ನೇಬಿ ಇಮ್ಮಸ್ ಬೋಲಿನ್, ಇನಿ ಖ್ಹರಮ್‌ಕಾಡ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","ಧೊಪಾರ್‌ ಹುವ್ವಾದೀನ್, ಹಿಡಿ ದೇಖ್ಹ್‌ಪರ್ ಅಂಧಾರು ಢಪೈನ್, ತೀನ್ ಘಂಟತೋಡಿ ಇಮ್ಮಸ್ ಥೂ. ");
INSERT INTO vaa_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","ಖ್ಹುಮಾರ್ ತೀನ್ ಘಂಟಾನ ಯೇಸು, “ಏಲಿ, ಏಲಿ, ಲಮಾ ಸಬಕ್ತಾನಿ?” ಕತೊ, “ಮಾರೊ ದೇವ್, ಮಾರೊ ದೇವ್, ತೂ ಶನ ಮನ ಹಾತ್‌ ಮ್ಹೆಂದಿದೋತೆ?” ಕರಿ ಜೋ಼ರ್ ಆವಾಜ಼್‌ಥಿ ಚಿಕ್‌ರ‍್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","ಹಿಜ್ಜಾ಼ ಭಿಯ್ಯುಥೂತೆ ಥೋಡು ಜ಼ಣು ಅನ ಖ್ಹಮ್‌ಜಿನ್‌, “ಆ ಎಲೀಯನ ಚಿಕ್ರುಕರಾಸ್!” ಕರಿ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","ತದೇಸ್‌ ಇವ್ಣಾಮ ಏಕ್‌ ಜ಼ಣಾನೆ, “ಗುಂಜ಼್‌ನ ಪಾಡೀನ್, ಖಾಟ ರಖ್ಹ್‌ಮ ಡುಬೈನ್, ಲಠ್ಠಾಕೇಡೆ ಅಟ್‌ಕೈನ್, ಯೇಸುನ ಪಿಯ್ಯಾನ ದಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","ಅಜು಼ ಥೋಡ ಜ಼ಣಾನೆ, “ಠೇರೊ! ಎಲೀಯ ಆಯಿನ್, ಅನ ಬಚಾ಼ಡಾಸ್ಕಿ ಶುಕಿ?” ಕರಿ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","ಅನಕೇಡೆಥು ಯೇಸುನೆ ಪಾಛೊ಼ ಜೋ಼ರೆಖ್ಹು ಚಿಕ್ರಿನ್ ಜಾನ್‌ ಮ್ಹೇಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","ತದೆ ಯೆರೂಸಲೇಮ್ ಮಂದಿರ್‌ಮ ಠಂಗೈರಾಖ್ಯುಥೂತೆ ಪಡ್‌ದೊ ಉಪ್ಪರ್‌ಥು ಧರಿನ್ ಹೇಟ್‌ತೋಡಿ ಫಾಟಿನ್, ಬೇ ಭಾಗ್‌ ಹುಯಿಗಯು. ಧರ್ತಿಕಾಪ್ಯು ಅಜು಼ ಬಂಡಾ ಫುಟಿಗಯು, ");
INSERT INTO vaa_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","ಮಖ್ಹಾಣ್ಯನಿ ಘವಿಯೆ ನಿಕ್ಳಿಗಯು, ಅಜು಼ ಮರಿಗಯುಥೂತೆ ಕೈಯೆಕ್ಕಿ ದೇವ್‌ನು ಅದ್ಮಿಖ್ಹಾರಾನು ಶರೀರ್ ಪಾಛು಼ ಜಿವ್ತು ಹುಯಿನ್ ಉಠಿ ಆಯು. ");
INSERT INTO vaa_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","ಯೇಸು ಜಿವ್ತೊಉಠಾನ ಬಾದ್‌ಮ, ಯೋ ಘವಿನ ಮ್ಹೆಂದಿನ್, ಪವಿತ್ರ ನಂಗರ್ ಹುಯಿರ‍್ಹೂತೆ ಯೆರೂಸಲೇಮ್ಮ ಜೈ಼ನ್, ಕೈಯೆಕ್ಕಿ ಅದ್ಮಿಯೇನ ದೆಖಾಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","ಖ್ಹೋಶಿಪಾಯಿನೊ ಮೋಟಾನೆ ಅಜು಼ ಇನಜೋ಼ಡೆ ಯೇಸುನ ಕಾವ್ಲಿ ಕರುಕರ್ತುಥೂತೆ ಇವ್ಣೆ ಜ಼ಮೀನ್ ಹಲ್ಯುತೆ ಅಜು಼ ಚಾ಼ಲ್ಯುತೆ ಖ್ಹಾರಸ್ನ ದೇಖಿನ್, ಘಣು ಡರಿನ್, “ಖ್ಹಾಚಮಾಬಿ ಆ ದೇವ್‌ನೊ ಛಿಯ್ಯೊ ಹುಯಿರ‍್ಹೋಥೊ!” ಕರಿ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","ಅತ್ರೇಸ್ ಕಾಹೆತೆ ಕೈಯೆಕ್ಕಿ ಜ಼ಣಿ ತಯೇಡ ಹಿಜ್ಜಾ಼ ದೂರ್‌ಥು ಭೀರಿನ್, ಇನ ದೇಖುಕರ್ತಿಥಿಯ್ಯೆ, ಅವ್ಣೆ ಖ್ಹಾರಿ ಯೇಸುನಿ ಸೇವೆ ಕರ್ತಿಹುಯಿನ್, ಗಲಿಲಾಯಾಥು ಇನ ಪೀಠೇಸ್ ಐರ‍್ಹೀಥಿಯ್ಯೆ. ");
INSERT INTO vaa_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","ಅವ್ಣಾಮ ಮಗ್ದಲನಿ ಮರಿಯ, ಯಾಕೋಬ ಅಜು಼ ಯೋಸೇಫನಿ ಆಯ ಮರಿಯಬಿ, ಅಜು಼ ಜೆಬೆದಾಯನಿ ಬಾವಣ್‌ಬಿ ಥೀ. ");
INSERT INTO vaa_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","ಖ್ಹಾಂಜ಼್ ಹುವಾದಿನ್, ಅರಿಮಥಾಯ ಗಾಮ್‌ನೊ ಯೋಸೇಫ ಕರಿ ಏಕ್ಜ಼ಣೊ ಶೌಕಾರಿ ಆಯೊ, ಆಬಿ ಯೇಸುನೊ ಶಿಷ್ಯ ಹುಯಿರೋಥೊ. ");
INSERT INTO vaa_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","ಅನೆ ಪಿಲಾತಕನ ಜೈ಼ನ್, ಯೇಸುನು ಶರೀರ್‌ನ ಮನ ದೆವಾಡ್ ಕರಿ ಬೋಲಿಲಿದೊ, ತದೆ ಪಿಲಾತನೆ ಯೇಸುನು ಶರೀರ್ ಯೋಸೇಫನ ದೇವ್ಣುಕರಿ, ಹುಕುಮ್ ದಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","ಯೋಸೇಫನೆ ಯೋ ಶರೀರ್‌ನ ಲೀನ್, ಇನ ಶುದ್‍ ಕೋರಧೊಳ ಲುಂಗ್ಡಾಥಿ ಲಪೇಟಿನ್, ");
INSERT INTO vaa_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","ಬಂಡಾಮ ಖೋಂದಿ ಬಣೈರಾಖ್ಯೊಥೋತೆ ಇನಿ ಶೊಂತ್ ನವಿ ಘವೀನಖ್ಹಾಮ್ಣೆ ಮೋಟಿ ಬಂಡಾನಿ ಚಿಪಾಟ್‌ನ ಮ್ಹೇಲಿನ್ ಯೋ ಘವಿನ ಮೂಚಿನ್, ಚ಼ಲೆಗಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","ಮಗ್ದಲನಿ ಮರಿಯ ಅಜು಼, ಯೋ ಬಿಜೇಕ್ ಮರಿಯ ಹಿಜ್ಜಾ಼ ಘವೀನ ಖ್ಹಾಮ್ಣೆ ಬೇಠಿಥಿಯೆ. ");
INSERT INTO vaa_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","ತಿನವ್ಹಾಣೆ, ಕತೊ ಸಬ್ಬತ್‌ ದನ್ ಖತಮ್ ಹುವಾನ ಬಾದ್‌ಮ, ಗಲ್‌ಢಯಾಜಕರ್‌ ಅಜು಼ ಫರಿಸಾಯರ್ ಪಿಲಾತಕನ ಜೈ಼ನ್, ");
INSERT INTO vaa_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","“ಯಜಮಾನ್, ಯೊ ಝು಼ಟೆಲೊ ಜವ್ತೊಥೋತೆ ತದೆ, ‘ತೀನ್ ದನ್ ಬಾದ್‌ಮ ಮೆ ಪಾಛೊ಼ ಜಿವ್ತೊ ಹುಯಿನ್ ಉಠಿ ಐಶ್‌’ ಕರಿ ಬೋಲ್ಯೊತೆ ವಾತೆ ಹಮಾರ ಯಾದ್ಮ ಛಾ಼, ");
INSERT INTO vaa_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","ಇನಖ್ಹಾಜೇಸ್ ತೀನ್ ದನ್‌ತೋಡಿ, ಇನಿ ಘವೀನ ಜ಼ತನ್‌ಥಿ ವಖ್ಹ್‌ತಿ ಕರಾನಖ್ಹಾಜೆ ಹುಕುಮ್ ದೇ, ನತರ್‌ಕಿ, ಇನ ಶಿಷ್ಯರ್‌ ಐನ್ ಇನಿ ಶರೀರ್‌ನ, ಚೋ಼ರೇಖ್ಹು ಪಾಡಿಲಿಜೈ಼ನ್ ಮರ‍್ಯೊಹುಯೊ ಜಿವ್ತೊ ಹುಯಿನ್ ಉಠಿರ‍್ಹೋಸ್, ಕರಿ ಬೋಲೆಜಾ಼ಯ್ ತದೆ ಪಹಿಲಿ ಝೂ಼ಟಿಥೀಬಿ, ಖ್ಹರ್ತಿಮಾನಿ ಝೂ಼ಟಿ ಘಣು ಖರಾಬ್ ಹುಯಿಜಾ಼ಶೆ” ಕರಿ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","ತದೆ ಪಿಲಾತನೆ ಇವ್ಣುನ; ವಖ್ಹ್‌ತಿ ಕರವಾಳನ” ಬುಲೈಲಿ “ಜಾ಼ವೊ,ಅಜು಼ ತುಮುನ ಹೋಣುತೆ ಇಮ್‌ ಜ಼ತನ್‌ಥಿ ಘವೀನ ವಖ್ಹ್‌ತಿ ಕರೊ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","ತದೆ ಇವ್ಣೆ ಜೈ಼ನ್, ಘವಿನ ಮುದ್ರೊಮಾರಿನ್, ಶಿಪಾಯಿನ ಕಾವ್ಲಿನ ಮ್ಹೇಲಿನ್, ಘವೀನ ಜ಼ತನ್ ಕರ‍್ಯು. ");
INSERT INTO vaa_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","ಸಬ್ಬತ್‌ನೊ ದನ್ ಹುವಾನ ಬಾದ್‌ಮ, ಐತ್‍ವಾರ್‌ನ ದನ್ನೆ ವ್ಹಾಣೇಸ್ ವೇಳಿ, ಮಗ್ದಲನಿ ಮರಿಯ ಅಜು಼ ಯೋ ಬಿಜೇಕ್‌ಜ಼ಣಿ ಮರಿಯ ಯೇಸುನು ಮಖ್ಹಾಣ್ಯನಿ ಘವಿಕನ ಐಯ್ಯೆ. ");
INSERT INTO vaa_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","ತದೆ ಎಕ್ಕದಮ್‌ ಜೋ಼ರೇಖ್ಹು ಜ಼ಮೀನ್ ಹಲ್ಯು; ಪ್ರಭುನೊ ಏಕ್‌ ದೂತ ಆಬ್‍ಪರ್‌ಥು ಉತ್ರಿ ಐನ್, ಯೋ ಘವಿನ ಮೂಚೈ಼ರ‍್ಹುಥೂತೆ ಬಂಡಾನ ಹಿಜ್ಜಾ಼ಥು ಗಿರ್‌ಗಡೈನ್, ಇನಾಪರ್ ಬೇಶಿಗಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","ಇನು ರೂಪ್ ವಿಜ಼್‌ಳಿನಘೋಣಿ ಥೂ, ಇನ ಲುಂಗ್ಡ ಬರಪ್‌ನಿಘೋಣಿ ಧೋಳುಫಟ್ ಥೂ. ");
INSERT INTO vaa_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","ಹಿಜ್ಜಾ಼ ವಖ್ಹ್‌ತಿ ಕರುಕರ್ತುಥೂತೆ ಶಿಪಾಯಿ ಖ್ಹಾರು ಡರ್‌ಥಿ ಧರ್‌ಧರ್‌ ಕಾಪಿನ್ ಮರ‍್ಯಾ ಮುರ್ದಾನಿಘೋಣಿ ಹುಯಿಗಯು. ");
INSERT INTO vaa_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","ತದೆ ಯೋ ದೇವ್‌ನೊ ದೂತನೆ ಯೋ ತಯೇಡಾವ್‍ನ, “ತುಮೆ ಡರೊನಕೊ, ಶಿಲ್‌ಬೆಪರ್ ಮಾರ‍್ಯುಥೂತೆ ಯೇಸುನ ತುಮೆ ಢೂಂಡುಕರಾಸ್ ಕರಿ ಮನ ಮಾಲುಮ್. ");
INSERT INTO vaa_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","ಯೋ ಹಜ್ಜಾ಼ ಕೊಯ್ನಿ; ಇನೆ ಬೋಲ್ಯೊಥೋತೆ ಇಮ್ಮಸ್ ಮರಣ್‌ಮಾಥೊ ಜಿವ್ತೊ ಹುಯಿನ್, ಉಠಿರ‍್ಹೋಸ್. ಹಜ್ಜಾ಼ ಆವೊ, ಯೋ ಖ್ಹುತೊಥೋತೆ ಝ಼ಗೋನ ದೇಖೊ. ");
INSERT INTO vaa_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","ಹಮ್ಕೆ ಒಗ್ಗಿಸ್ ಜೈ಼ನ್, ಇನ ಶಿಷ್ಯರ್‌ನ ಬೋಲ್ಯೊಕಿ, ‘ಮರಿಗಯೊಹುಯೊ ಪಾಛೊ಼ ಜಿವ್ತೊಹುಯಿನ್ ಉಠ್ಯೊ ಅಜು಼ ತುಮಾರೇಥಿ ಅಗಾಡಿ ಗಲಿಲಾಯನ ವಳ್ಯೊಜಾ಼ಸ್; ಹಿಜ್ಜಾ಼ ತುಮೆ ಇನ ದೇಕ್‌ಶು!’ ಕರಿ. ಮೇ ಬೋಲ್ಯೋತೆ ವಾತೆ ಖ್ಹಾರಿ ಯಾದ್ಮ ರ‍್ಹವಾದೆ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","ತದೆ ಇವ್ಣೆ ಡರ್‌ಥೀಬಿ, ಘಣಿ ಖ್ಹುಶಿಥಿ ಒಗ್ಗಿಸ್‌ಮ ಯೋ ಮಖ್ಹಾಣ್ಯನಿ ಘವಿಕಂಥು ನಿಕ್ಳಿನ್, ಇನ ಶಿಷ್ಯರ್‌ನ ಬೋಲಾನಖ್ಹಾಜೆ ಮಿಲಯ್ಯೆ಼. ");
INSERT INTO vaa_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","ತದೆ ಎಕ್ಕದಮ್‌ ಯೇಸು ಇವ್ಣುನ ದೆಖೈನ್, “ತುಮೂನ ಸಮಾಧಾನ್‍ ಹುವಾದೆ” ಕರಿ ಬೋಲ್ಯೊ. ಇವ್ಣೆ ಇನ ಖನ್ನೆ ಆಯಿನ್, ಇನ ಗೋಡ ಧರೀನ್, ಇನ ಆರಾದನೆ ಕರಿಯೆ. ");
INSERT INTO vaa_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","ಯೇಸುನೆ ಇವ್ಣುನ, “ಡರೊ ನಕೊ, ಮಾರ ಭಯೇಕನ ಜೈ಼ನ್, ಗಲಿಲಾಯಾನ ಆವಾನ ಬೋಲೊ. ಹಿಜ್ಜಾ಼ ಇವ್ಣೆ ಮನ ದೇಕ್‌ಶೆ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","ಯೋ ತಯೇಡ ಖ್ಹಾರಿ ಜಾ಼ತಿ ವಖ್ಹತ್‌ಮ, ವಖ್ಹ್‌ತಿ ಕರುಕರ್ತುಥೂತೆ ಶಿಪಾಯಿಮ ಥೋಡು ಜ಼ಣು ಖ್ಹಯೇರ್‌ಮ ಜೈ಼ನ್, ಚಾ಼ಲ್ಯುತೆ ಬಾರೇಮ ಖ್ಹಾರೂಸ್ ಗಲ್‌ಢಯಾಜಕರ್‌ನ ಖ್ಹಾಮ್ಣೆ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","ಗಲ್‌ಢ ಯಾಜಕರ್ ಶಾಣಾವ್ನ ಜೋ಼ಡೆ ಮಳಿನ್, ವಾತೆ ಕರಿಲೀನ್, ಯೋ ಶಿಪಾಯಿಯೇನ ಇವ್ಣೆ ಘಣ ಪೈಶಾದೀನ್, ");
INSERT INTO vaa_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","“ರಾತ್ಮ ಹಮೆ ಖ್ಹುತಾರ‍್ಹವಾನಿ ವಖ್ಹತ್‌ಮ, ಇನ ಶಿಷ್ಯರ್‌ ಆಯಿನ್, ಇನ ಮುರ್ದಾನ ಚೋ಼ರೇಖ್ಹು ಪಳ್ಳಿ ಗಯ ಕರಿ ಬೋಲೊ. ");
INSERT INTO vaa_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","ಆ ಖಬರ್ ರಾಜ಼್‌ಭಾರ್ ಚ಼ಲಾವವಾಳಾನ ಕಾನ್‌ಮ ಪಡ್ಯೂತೊ, ಹಮೆ ಇನಜೋ಼ಡೆ ವಾತೆಕರಿನ್, ತುಮಾರಾಮ ಗಲ್ತಿಕೊಯ್ನಿ ಕರಿ ಖ್ಹಮ್‍ಜಾ಼ಡ್‍ಶು, ತದೆ ತುಮೂನ ಶನೋಸ್ ಡರ್‌ ಕೋ ರ‍್ಹಿಶೇನಿ” ಕರಿ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","ಯೋ ಶಿಪಾಯಿಯೇನೆ ಪೈಶಾ ಲೀಲಿನ್‌, ಇವ್ಣುನ ಶಾತ್ ಬೋಲಿದಿದೂಥೂಕಿ ಇಮ್ಮಸ್ ಕರ‍್ಯು. ಆ ವಾತೆ ಹಮ್ಕೆಲಗೂಬಿ ಯೆಹೂದ್ಯರ್‌ಮ ಫೈಲಿರ‍್ಹೂಸ್. ");
INSERT INTO vaa_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","ಬಾದ್‌ಮ ಗ್ಯಾರ‍್ಹ ಜ಼ಣ ಶಿಷ್ಯರ್‌ ಯೇಸುನೆ ಬೋಲಿವತಾಳ್ಯೋತೆ ಗಲಿಲಾಯನು ಏಕ್‌ ಪಹಾಡ್‌ಕನ ಗಯ. ");
INSERT INTO vaa_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","ಹಿಜ್ಜಾ಼ ಯೇಸುನ ದೇಖಿನ್, ಇನಖ್ಹಾಮ್ಣೆ ಆರಾದನೆ ಕರ‍್ಯು, ಕತೋಬಿ ಇವ್ಣಾಮ ಥೋಡು ಜ಼ಣು ಶಕ್ ಕರ‍್ಯು. ");
INSERT INTO vaa_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","ಯೇಸು ಇವ್ಣ ಖನ್ನೆ ಆಯಿನ್, “ಸೊರ್ಗಾಮಾಬಿ, ಧರ್ತಿಪರ್‌ಬಿ ಖ್ಹಾರೀಸ್‍ ಅದಿಕಾರ್ ಮನ ದೆವೈರ‍್ಹೀಸ್. ");
INSERT INTO vaa_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","ಇನಖ್ಹಾಜೆ ತುಮೆ ಜೈ಼ನ್, ಖ್ಹಾರ ದೇಖ್ಹ್‌ಮ ಛಾ಼ತೆ ಅಲಕ್ ಅಲಕ್ ವಾತೆ ಬೋಲಾವಳು ಅದ್ಮಿ ಖ್ಹಾರಾನ ಮಾರ ಶಿಷ್ಯರ್‌ ಬಣಾವೊ: ಇವ್ಣುನ ಬಾ, ಛಿಯ್ಯೊ ಅಜು಼ ಪವಿತ್ರಾತ್ಮನ ನಾಮ್‌ಪರ್‌ ಬ್ಯಾಪ್ತಿಸ್ಮ ದೆವೊ. ");
INSERT INTO vaa_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","ಅಜು಼ ಮೇ ತುಮೂನ ಹುಕುಮ್‌ ದೀರಾಖ್ಯೋತೆ ಖ್ಹಾರಸ್ನ ಇವ್ಣೆ ಪಾಡಿ ಚಾ಼ಲಾನಿಘೋಣಿ ಇವ್ಣುನ ಬೋಲಿವತಾಳೊ. ಅಜು಼ ಯಾದ್ಮ ರ‍್ಹವಾದೇಕಿ ಜಗತ್‌ನು ಖ್ಹರ್ತಿ ಹುವಾಲಗೂಬಿ, ಹಮೇಶ ಮೇ ತುಮಾರ ಜೋ಼ಡೆಸ್ ರ‍್ಹೀಶ್” ಕರಿ ಬೋಲ್ಯೊ.");
INSERT INTO vaa_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","ದೇವ್‌ನೊ ಛಿಯ್ಯೊ ಹುಯಿರ‍್ಹೋತೆ, ಯೇಸು ಕ್ರಿಸ್ತನಿ ಬಾರೇಮ, ಅಛ್ಛಿ ಸಮಾಚಾರ್‌ನಿ ಶುರುವಾತ್. ");
INSERT INTO vaa_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","ಪ್ರವಾದಿ ಯೆಶಾಯನ ದಪ್ತರ್‌ಮ ಲೀಖೈರ‍್ಹೂತೆ ತಿಮ್, “ಹಂದೇಕ್‌, ಮಾರ ದೂತಾನ ತಾರ ಖ್ಹಾಮ್ಣೆ ಮೋಕ್ಲಿಶ್, ಯೋ ತಾರಿ ವಾಟ್ನ ಬರೋಬರ್‌ ಕರ್ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","ಏಕ್‌ ಜ಼ಣೊ ಉಜ್ಜಾ಼ಡಿ ಝ಼ಗೋಮ, “ಪ್ರಭುನಿ ವಾಟ್ನ ಖ್ಹವಾರೊ, ಇನಿ ವಾಟ್ನ ಖ್ಹೂದು ಕರೊ” ಕರಿ ಚಿಕ್ರುಕರಾಸ್. ");
INSERT INTO vaa_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","ಅಮ್ ಕರಿ ಪ್ರವಾದಿ ಹುಯಿರ‍್ಹೊಥೋತೆ ಯೆಶಾಯನ ಪುಸ್ತಕ್‌ಮ ಲೀಖೈರ‍್ಹೂಸ್ತೆ ಇಮ್ಮಸ್, ಯೋಹಾನ ಉಜ್ಜಾ಼ಡಿ ಝ಼ಗೋಮ ದೆಖೈನ್, ಅದ್ಮಿ ಖ್ಹಾರಾನ, “ತುಮೆ ಪಾಪ್ ಕರಾನು ಮ್ಹೇಲಿನ್ ದೇವ್ ಭಣಿ ಫರೊ ಅಜು಼ ಬ್ಯಾಪ್ತಿಸ್ಮ ಲೇವೊ, ತದೆ ದೇವ್ ತುಮಾರು ಪಾಪ್ನ ಮಾಪ್‌ ಕರ್ಶೆ” ಕರಿ ಬೋಲ್ತೊಹುಯಿನ್ ಬ್ಯಾಪ್ತಿಸ್ಮ ದೆವ್‍ಕರ್‌ತೋಥೊ. ");
INSERT INTO vaa_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","ತದೆ ಯೂದಾಯ ತಬರ್‌ಖ ಭಣೀಥು ಅಜು಼ ಯೆರೂಸಲೇಮ್‍ ಖ್ಹಯೇರ್‌ಥು ಘಣು ಅದ್ಮಿ ಯೋಹಾನಕನ ಜೈ಼ನ್, ಇವ್ಣ-ಇವ್ಣ ಪಾಪ್ನ ಕಬೂಲಿಲೀನ್‌, ಇನ ಹಾತೇಖ್ಹು ಯೊರ್ದನ್‌ ನದ್ದಿಮ ಬ್ಯಾಪ್ತಿಸ್ಮ ಕರೈಲೆವ್‌ಕರ್ತುಥು. ");
INSERT INTO vaa_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","ಯೋಹಾನ ಊಟ್ನ ಕೇಖ್ಹ್‌ಥಿ ಬಣಾಯುಹುಯು ಲುಂಗ್ಡು ಪೇರ‍್ಹೀರಾಕ್ತೊಥೊ, ಕಂಬರ್‌ನ ಚಾ಼ಂಬ್ಡಾನು ಕಂಬರ್‌ಪಟೊ ಭಾಂದಿರಾಕ್‌ತೋಥೊ ಅಜು಼ ಚಿಡ್ಡೋಬಿ ಜ಼ಂಗಳ್ನಿ ಶೇತ್‌ ಇನು ಖಾಣು ಹುಯಿರ‍್ಹುಥು. ");
INSERT INTO vaa_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","ಯೋಹಾನನೆ ಅದ್ಮಿಖ್ಹಾರನ, “ಮಾರೇಥಿಬಿ ಶಕತ್‌ವಾಳೊ ಮಾರ ಪೀಠೆ ವಳ್ಯಾವಸ್; ಮೇ ಝು಼ಕಿನ್‌ ಇನಿ ಖೋಖ್ಹ್‌ಡಾನಿ ಡೋರಿ ಛೋ಼ಡಾನಾಬಿ ಲ್ಹಾಯೇಕ್‍ಕೊಯ್ನಿ ಕರಿ ಬೋಲಿವತಾಳ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","ಮೇ ತುಮೂನ ಪಾಣಿಥಿ ಬ್ಯಾಪ್ತಿಸ್ಮ ದೆವಾಡುಸ್; ಕತೋಬಿ ಯೋತೊ ತುಮೂನ ಪವಿತ್ರಾತ್ಮಥಿಬಿ ಬ್ಯಾಪ್ತಿಸ್ಮ ದೆವಾಡ್‌ಶೆ” ಕರಿ ಬೋಲಿವತಾಳ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","ಏಕ್‌ ದನ್ನೆ ಯೇಸು ಗಲಿಲಾಯ ತಬರ್‌ಖಾನು ನಜ಼ರೇತ್ ಕರಿ ಗಾಮ್‌ಥು ಐನ್, ಯೊರ್ದನ್‌ ನದ್ದಿಮ ಯೋಹಾನಥಿ ಬ್ಯಾಪ್ತಿಸ್ಮ ಕರೈಲಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","ಯೇಸು ಬ್ಯಾಪ್ತಿಸ್ಮ ಲೀನ್, ಪಾಣಿಮಾಥೊ ಭಾರ್‌ ನಿಕಳ್‌ತಾಸ್ನ, ಸೊರ್ಗ ನಿಕ್ಳಿನ್, ದೇವ್‌ನು ಆತ್ಮ ಪರ‍್ಯಾವಾನಿಘೋಣಿ ಇನಾಪರ್ ಉತ್ರಿನ್‌ ಆಯೂತೆ ದೇಖ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","ತದೆ ಪರಲೋಕ್‌ಮಾಥು “ತೂ ಮಾರೊ ಪ್ಯಾರ್‌ನೊ ಛಿಯ್ಯೊ, ತಾರೇಥಿ ಮೇ ಘಣು ಖ್ಹುಶಿ ಛೂ಼” ಕರಿ ಏಕ್‌ ಅವಾಜ಼್ ಖ್ಹಮಜ್‌ಪಡ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","ತದ್‌ನು-ತದ್ದೇಸ್ ಯೇಸುನ ಪವಿತ್ರಾತ್ಮನೆ ಉಜ್ಜಾ಼ಡಿ ಝ಼ಗೋಮ ಚ಼ಲಾಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","ಹಿಜ್ಜಾ಼ ಯೇಸು ಚಾ಼ಳಿಖ್ಹ್ ರೋಜ಼್ ಥೊ, ಜ಼ಂಗ್‌ಳಿ ಜಿನಾವರ್‌ಬಿ ಹಿಜ್ಜಾ಼ ಥೂ. ತದೆ ಶೈತಾನ್‌ಥಿ ಯೇಸು ಶೋದನೆಮ ಪಡ್ಯೊ. ಅಜು಼ ದೇವ್ ದೂತರ್ ಖ್ಹಾರುಐನ್ ಇನಿ ಸೇವಾ-ಚಾ಼ಕ್ರಿ ಕರ‍್ಯು. ");
INSERT INTO vaa_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","ಯೋಹಾ‍ನನ ಜೇಲ್‌ಮ ಕೋಂಡಿನ್‌ ಘಾಲಿದೆವಾನ ಬಾದ್‌ಮ ಯೇಸು ಗಲಿಲಾಯ ತಬರ್‌ಖಾನ ಆಯಿನ್ ದೇವ್ನಿ ಸುವಾರ್ತೆನ ಅಮ್ ಬೋಲಿ ಒತಾಳ್ಯೊಕಿ, ");
INSERT INTO vaa_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","“ದನ್‌ಖ್ಹಾರ ಭರೈಗ, ದೇವ್ನಿ ರಾಜ್ಯ ಖನ್ನೆ ಐಗು! ತುಮಾರು ಪಾಪ್ನ ಖ್ಹಾರು ಮ್ಹೇಲಿನ್ ದೇವ್‌ಭಣಿ ಫರಿನ್, ದೇವ್ನಿ ಅಛ್ಛಿ ಸಮಾಚಾರ‍್ನ ನಂಬೊ!” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","ಏಕ್‌ ದನ್ನೆ ಯೇಸು ಗಲಿಲಾಯ ದರ‍್ಯಾವ್ನ ಕನಾರೆಕರಿ ವಳ್ಯೊಜಾ಼ತೊಥೊ. ತದೆ ಜಾ಼ಳು ನಾಖುಕರ್ತಥಾತೆ ಸೀಮೋನ್‌ ಅಜು಼ ಇನೊ ನ್ಹಾನೊ ಭೈ ಅಂದ್ರೆಯನ ದೇಖ್ಯೊ. ಅವ್ಣೆ ಮಾಛ಼್ಲ ಖ್ಹಾವಾಳ ಹುಯಿರ‍್ಹಾಥ. ");
INSERT INTO vaa_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","ಯೇಸುನೆ ಇವ್ಣುನ, “ಮಾರ ಕೇಡೆ ಆವೊ, ಮೇ ತುಮೂನ ಮಾಛ಼್ಲ ಖ್ಹಾವಾಳಾನಿತರ ಕಾಹೆ ಅದ್ಮಿನ ಖ್ಹಾವಾಳಾನಿತರ ಬಣವುಸ್. ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","ಅಮ್ ಬೋಲ್ತಾಸ್‌ನ ಇವ್ಣೆ ಇವ್ಣು ಜಾ಼ಳುಖ್ಹಾರು ಮ್ಹೆಂದಿನ್ ಯೇಸುನ ಕೇಡೆ ಗಯ. ");
INSERT INTO vaa_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","ಯೇಸು ಬಿಜು಼ ಜ಼ರ ಖ್ಹಾಮ್ಣೆ ಜೈ಼ನ್, ಜೆಬೆದಾಯನೊ ಛಿಯ್ಯೊ ಯಾಕೋಬನಾಬಿ ಅಜು಼ ಇನೊ ನ್ಹಾನೊ ಭೈ ಯೋಹಾನ್ನ ದೇಖ್ಯೊ. ಇವ್ಣೆ ಡೋಣ್‌ಮ ಜಾ಼ಳಾನ ಬರೋಬರ್ ಕರುಕರ್ತಥ. ");
INSERT INTO vaa_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","ದೇಕ್‍ತಾಸ್, ಇವ್ಣುನಾಬಿ ಬುಲಾಯೊ; ಬುಲಾವ್‍ತಾಸ್‍ನ ಇವ್ಣೆ ಇವ್ಣೊ ಬಾ ಜೆಬೆದಾಯನ ಕೂಲಿಆಳ್‍ನ ಜೋ಼ಡೆ ಡೋಣ್‌ಮ ಮ್ಹೆಂದಿನ್ ಯೇಸುನ ಕೇಡೆ ಗಯ. ");
INSERT INTO vaa_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","ಬಾದ್‌ಮ ಯೇಸುಬಿ ಇನು ಶಿಷ್ಯರ್‌ ಕಪೆರ್ನೌಮ್ ಕರಿ ಗಾಮ್‌ನ ಗಯ, ಹಿಜ್ಜಾ಼ ಸಬ್ಬತ್‌ ದನ್ನೆ ಯೇಸು ಸಬೆ ಭರಾವಾನು ಮಂದಿರ್‌ಮ ಜೈ಼ನ್ ವಚನ್ ಬೋಲಿದೆವಾನಿಕ್‍ಳ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","ಅದ್ಮಿಖ್ಹಾರು ಯೇಸುನಿ ಭೋದನ್ನ ಖ್ಹಮ್‌ಜಿನ್‌, ಘಣು ಆಶ್ಚರ್ಯಖಾದು. ಶನಕತೊ ಯೋ ಮೋಶೆನಿ ವಚನ್‍ ಶಿಕಾಡವಾಳ ಶಾಸ್ತ್ರಿಯೇನಿಘೋಣಿ ಕಾಹೆತೆ, ಅದಿಕಾರ್ ರ‍್ಹವಾಳಾನಿತರ ವಾಕ್ಯ ಬೋಲ್ತೊಥೊ. ");
INSERT INTO vaa_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","ತದೆ ಯೋ ಸಬೆ ಭರಾವಾನು ಮಂದಿರ್‌ಮ ಭೂತ್‌ ಧರಿರಾಖ್ಯುಥೂತೆ ಏಕ್‌ ಅದ್ಮಿ ಆಯು. ");
INSERT INTO vaa_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","ಯೋ ಚಿಕ್ರಿನ್, “ನಜ಼ರೇತ್‌ನೊ ಯೇಸು, ಹಮಾರೇಥಿ ತುನ ಶಾತ್‌ ಛಾ಼? ಹಮೂನ ಬರ್ಬಾತ್ ಕರಾನ ಆಯೊಕಿ ಶು? ತು ಕೋಣ್ ಕರಿ ಮನ ಮಾಲುಮ್; ತೂ ದೇವ್‌ನೊ ಪವಿತ್ರ್‌ ಛಿಯ್ಯೊ ಹುಯಿರ‍್ಹೋಸ್” ಕರಿ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","ಯೇಸುನೆ ಯೋ ಭೂತ್‌ನ ಗುರ್‌ಕೈನ್, “ಖ್ಹೊಪ್‌ರ‍್ಹೆ, ಅನ ಮ್ಹೆಂದಿನ್ ಭಾರ್‌ನಿಕಳ್‌” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","ತದೆ ಯೋ ಭೂತ್‍ನೆ ಯೋ ಅದ್ಮಿನ ಧಡಾಶಮರೈನ್, ಜೋ಼ರೇಖ್ಹು ಚಿಕ್ರಿನ್ ಭಾರ್‌ ನಿಕ್ಳಿಗಯು. ");
INSERT INTO vaa_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","ಅನ ದೇಖಿನ್‌ ಅದ್ಮಿಖ್ಹಾರು ಆಶ್ಚರ್ಯಖೈನ್, “ಆ ಶಾತ್ ನವಿ ತರ‍್ಹಾಥಿ ಬೋಲಿ ದೇಯಿತೆ? ಯೇಸು ಅದಿಕಾರ್‌ಥಿ ಭೂತ್‌ಅಖ್ಖಾನಬಿ ಹುಕುಮ್‌ ದೇಸ್‌ನಿ, ಭೂತ್‌ ಖ್ಹಾರುಬಿ ಇನಿ ವಾತ್ ಖ್ಹಮ್‌ಜಾ಼ಸ್‌ನಿ!” ಕರಿ ಏಕ್‌ಥಿ ಏಕ್‌ ಬೋಲಿಲಿದು. ");
INSERT INTO vaa_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","ಜ಼ಲ್ದೀಸ್‍ಮ ಯೇಸುನಿ ಬಾರೇಮನಿ ಖಬರ್ ಗಲಿಲಾಯ ತಬರ್‌ಖಾನು ಖ್ಹಾರಿ ಬಾಜು಼ಮ ಫೈಲಿಗಯು. ");
INSERT INTO vaa_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","ಬಾದ್‌ಮ ಇವ್ಣೆ ಸಬಾಮಂದಿರ್‌ಥ ನಿಕ್ಳಿನ್‌ ಯಾಕೋಬಬಿ ಯೋಹಾನ್ನ ಜೋ಼ಡೆ ಸೀಮೋನ್‍ಬಿ ಅಂದ್ರೆಯನ ಘರ್‌ಕನ ಗಯ. ");
INSERT INTO vaa_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","ಹಿಜ್ಜಾ಼ ಸೀಮೋನನಿ ಖ್ಹಾಖ್ಹು ತಾವ್ ಐನ್ ಖ್ಹುತೀಥಿ, ಒಗ್ಗಿಸ್‌ಮ ಇವ್ಣೆ ಇನಿ ಬಾರೇಮ ಯೇಸುನ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","ಯೇಸು ಸೀಮೋನನಿ ಖ್ಹಾಖ್ಹುನ ಖನ್ನೆ ಜೈ಼ನ್, ಇನೊ ಹಾತ್ ಧರೀನ್ ಉಠಾಡ್‌ತಾಖ್ಹತರ್‌, ಇನೊ ತಾವ್ ಉತ್ರಿಗಯೊ. ತದೆ ಯೋ ಉಠೀನ್ ಇವ್ಣಿ ಸೇವಾ-ಚಾ಼ಕ್ರಿ ಕರಿ. ");
INSERT INTO vaa_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","ದನ್ ಡುಬಾನ ಬಾದ್‌ಮ ಖ್ಹಾಂಜ಼್‍ನು, ಅದ್ಮಿಖ್ಹಾರು ರೋಗ್‌ಮ ರ‍್ಹವಾಳ ಖ್ಹಾರಾನ ಅಜು಼ ಭೂತ್ ಧರಿರಾಖವಾಳ ಖ್ಹಾರಾನ ಯೇಸುಕನ ಲೀನ್ ಆಯು. ");
INSERT INTO vaa_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","ಗಾಮ್‍ ಅಖ್ಖೂಸ್ ಯೋ ಘರ್‌ನ ಬಾಕಲ್‌ನ ಖ್ಹಾಮ್ಣೆ ಭರೈರ‍್ಹೂಥು. ");
INSERT INTO vaa_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","ತದೆ ಯೇಸು ಖ್ಹಾರಿ ತರ‍್ಹಾನು ರೋಗ್‍ವಾಳ ಘಣ ಅದ್ಮಿನ ಅಛ್ಛು಼ ಕರ‍್ಯೊ. ಅಜು಼ ಘಣು ಭೂತ್ ಖ್ಹಾರು ಕಾಡ್ಯೊ, ಯೋ ಭೂತ್ ಖ್ಹಾರಾನ ಯೇಸು ಕೋಣ್‌ಕರಿ ಮಾಲುಮ್ ಥು, ಇನಾಖ್ಹಾಜೆ ಯೋ ಭೂತ್ ಖ್ಹಾರಾನ ವಾತ್ ಬೋಲಾದಿದೊಕೊಯ್ನಿ. ");
INSERT INTO vaa_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","ಇನ ವ್ಹಾಣೇಸ್ ವೇಳಿ ದನ್ ನಿಕ್ಳಾನ ಅಗಾಡಿ, ಅಂಧಾರು ರ‍್ಹಾವಾನಿಸ್ ವಖ್ಹತ್‌ಮ, ಯೇಸು ಉಠೀನ್ ಘರ್ ಮ್ಹೆಂದಿನ್ ಉಜ್ಜಾ಼ಡಿ ಝ಼ಗೋಪರ್ ಜೈ಼ನ್, ಪ್ರಾರ್ಥನೆ ಕರುಕರ್ತೊಥೊ. ");
INSERT INTO vaa_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","ಬಾದ್‌ಮ ಸೀಮೋನ್‍ಬಿ ಇನ ಜೋ಼ಡ್ಮ ರ‍್ಹವಾಳು ಯೇಸುನ ಢೂಂಡ್‌ತುಹುಯಿನ್ ಹಿಜ್ಜಾ಼ ಆಯು. ");
INSERT INTO vaa_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","ಹಿಜ್ಜಾ಼ ಯೇಸುನ ಮಳಿನ್, “ಅಖ್ಖುಜ಼ಣು ತುನಾಸ್ ಢೂಂಡುಕರಾಸ್” ಕರಿ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","ತದೆ ಯೇಸುನೆ ಇವ್ಣುನ, “ಅಪ್ಣೆ ಖನ್ನೆ ಛಾ಼ತೆ ಬಿಜ಼ಖ್ಹಾರ ಗಾಮ್‌ನಾಬಿ ಜ಼ಯ್ಯೆ಼. ಹಿಜ್ಜಾ಼ಬಿ ಮೇ ದೇವ್ನಿ ಅಛ್ಛಿ ಖಬರ್‌ನ ಬೋಲ್‌ನು; ಅನಾಸ್‍ಖ್ಹಾಜೆ ಮೇ ಐರ‍್ಹೋಸ್ತೆ” ಕರಿ ಖ್ಹಮ್‌ಜಾ಼ಡ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","ಬಾದ್‌ಮ ಯೇಸು ಗಲಿಲಾಯ ತಬರ್‌ಖಾನು ಖ್ಹಾರಿ ಬಾಜು಼ಮ ಜೈ಼ನ್, ಸಬೆ ಭರಾವಾನು ಮಂದಿರ್‌ಮ ದೇವ್ನಿ ಅಛ್ಛಿ ಖಬರ್‌ನ ಬೋಲ್ತೊಹುಯಿನ್, ಭೂತ್‌ಖ್ಹಾರು ಕಾಡುಕರ್ತೊಥೊ. ");
INSERT INTO vaa_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","ಖೋಡ್‍ ಲಾಗಿಹುಯು ಏಕ್‌ ಜ಼ಣೊ ಯೇಸುಕನ ಐನ್, ಇನ ಖ್ಹಾಮ್ಣೆ ಢುಕ್‌ಣ್ಯ ಟೇಕಿನ್, “ಮನ ಅಛ್ಛು಼ ಕರಾನ ತಾರೇಥಿ ಹುವಾಸ್, ತುನ ಮನ್ ಉಶೇತೊ ಮನ ಶುದ್ದಿ ಕರೆಜಾ಼ಯ್” ಕರಿ ಗಿಂಗೈಲಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","ತದೆ ಯೇಸುನೆ ಇನಾಪರ್ ಘಣು ಗೋರ್‌ಖೈನ್, ಇನ ಹಾತೇಖ್ಹು ಛೀಮಿನ್‌, “ಮನ ಮನ್ ಛಾ಼; ಶುದ್ದಿ ಹೂ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","ಅಮ್ ಬೋಲ್ತಾಸ್‌ನ ಇನು ಖೋಡ್‌ಖ್ಹಾರು ನಿಕ್ಳಿಜೈ಼ನ್, ಯೋ ಪಾಕ್‌ ಹುಯಿಗೊ. ");
INSERT INTO vaa_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","ತದೆ ಯೇಸುನೆ ಇನ ಝೇತೈನ್‌, “ಹಂದೇಕ್, ಮೇ ತುನ ಅಛ್ಛು಼ ಕರ‍್ಯೊ ಕರಿ ಕಿನಾಬಿ ನಕೊ ಬೋಲೀಶ್‌; ಕತೋಬಿ ತು ಯಾಜಕಕನ ಜೈ಼ನ್ ತಾರು ಆಂಗ್‌ತನ್‌ ವತಾಳಿನ್ ಮೋಶೇನೆ ಶುದ್ದಿನಖ್ಹಾಜೆ ಹುಕುಮ್‌ ದೀರಾಖ್ಯೋತೆ ಇಮ್‌, ಕಾಣ್ಕೆ ಖ್ಹಾರು ಲೀಜೈ಼ನ್ ದೇ. ಯೋಅಖ್ಖು ಅದ್ಮಿವೋನ ಸಾಕ್ಷಿ ಹುಯಿರ‍್ಹವಾದೆ ಅಮ್ ಕರಿ ಬೋಲಿನ್ ಇನ ಒಗ್ಗಿಸ್ ಮೋಕ್ಲಿದಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","ಕತೋಬಿ ಯೋ ಚ಼ಲ್ಯೂಜೈ಼ನ್, ಯೇಸುನೆ ಇನ ಅಛ್ಛು಼ ಕರ‍್ಯೊ ಕರಿ ಬೋಲಿನ್‌ ಖ್ಹಾರಿ ಬಾಜು಼ಮ ಫೈಲೈನಾಖ್ಯು. ಅನೇಥಿ ಯೇಸು ಬಿಜು಼ ಖೆವ ಗಾಮ್ಮಾಬಿ ಖ್ಹಾರಾನ ದೆಖಾವಾನಿ ಘೋಣಿ ಜಾ಼ವಾನ ಕೋ ಹುಯುನಿ. ಇನಾಖ್ಹಾಜೆ ಯೇಸು ಭಾರ್‌ ಉಜ್ಜಾ಼ಡಿ ಝ಼ಗೋಮ ಜೈ಼ನ್ ಥೊ, ತೋಬಿ ಚಾರ‍್ಹೆ ಆಡಿಥು ಅದ್ಮಿಖ್ಹಾರು ಇನಾಕನ ಅವ್‌ಕರ್ತುಥು. ");
INSERT INTO vaa_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","ಥೋಡ ದನ್ನ ಬಾದ್‌ಮ ಯೇಸು ಕಪೆರ್ನೌಮ್ ಗಾಮ್ಮ ಪಾಛೊ಼ ಗಯೊ, ಅಜು಼ ಯೋ ಘರ್‌ಮ ಛಾ಼ ಕರಿ ಖಬರ್ ಫೈಲಿಗಯು. ");
INSERT INTO vaa_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","ಅನ ಖ್ಹಮ್‌ಜಿನ್‌ ಘಣು ಅದ್ಮಿ ಐನ್ ಭರೈಜೈ಼ನ್, ಘರ್‌ನ ಮಹಿ ಗೋಡೊ ಮ್ಹೇಲಾನಬಿ ಝ಼ಗೊ ಕೋ ಥೂನಿ, ಬಾಕಲ್‍ಕನಾಬಿ ಝ಼ಗೊ ಕೋ ಥೂನಿ. ಯೇಸು ಇವ್ಣುನ ವಚನ್ ಬೋಲಿ ದೆವ್‍ಕರ್‌ತೋಥೊ. ");
INSERT INTO vaa_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","ತದೆ ಚಾರ್ ಅದ್ಮಿನೆ, ಏಕ್‌ಜ಼ಣೊ ಲಕ್‍ವೊ ಮಾರ‍್ಯುಹುಯಾನ ಹಿಜ್ಜಾ಼ ಪಳ್ಳಿನ್‌ ಆಯು. ");
INSERT INTO vaa_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","ಹಿಜ್ಜಾ಼ ಅದ್ಮಿನಿ ಭೀಡ್ ಭರೈರ‍್ಹಿಥೀತೆ ಇನಾಖ್ಹಾಜೆ, ಮಹಿ ಯೇಸುಕನ ಇನಲೀನ್ ಆವಾನ ಕೋ ಹುಯೂನಿ. ಇನಾಖ್ಹಾಜೆ ಇವ್ಣೆ ಯೋ ಘರ್‌ನ ಛ಼ತ್‍ಪರ್‌ ಚ಼ಢೀನ್, ಯೇಸುನಿ ನೇರ್ ಉಪ್ಪರ್ ಛ಼ತ್‍ನ ಥೋಡು ಕಾಡಿನಾಖಿದೀನ್, ಮೋಟಿ ಖೀಂಡ್ ಬಣೈನ್ ಇನಾಮಾಕರಿ ಯೋ ಲಕ್‍ವೊ ಮಾರಿರಾಖವಾಳನ ಖ್ಹುಡೈರಾಖ್ಯುಥೂತೆ ಬಿಛಾ಼ವ್ಣಿ ಖ್ಹಮೇದ್ ಇಮ್ಮಸ್ ಹೇಟ್ ಉತಾರ‍್ಯು. ");
INSERT INTO vaa_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","ಯೇಸುನೆ, ಇವ್ಣೆ ಎತ್ರೇ ಇನಾಪರ್ ವಿಶ್ವಾಸ್ ಕರ‍್ಯುತೆ ದೇಖಿನ್, ಯೋ ಲಕ್‍ವೊ ಮಾರಿರಾಖವಾಳನ, “ಛಿಯ್ಯಾ, ತಾರು ಪಾಪ್‌ಖ್ಹಾರು ಮಾಪ್‌ ಹುಯಿಗಯು” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","ಹಿಜ್ಜಾ಼ ಮೋಶೇನು ವಚನ್‍ ಶಿಕಾಡವಾಳು ಶಾಸ್ತ್ರೀಮ ಥೋಡು ಜ಼ಣು ಬೆಠೂಥು. ");
INSERT INTO vaa_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","ಇವ್ಣೆ, “ಆ ಅಮ್ ಶನ ಬೋಲಾಸ್ತೆ? ಆ ದೇವ್ನ ಚಿಂಘಾವ್ಣಿ ಕರಾನಿ ವಾತೆ, ದೇವ್ನ ಮ್ಹೇಲಿನ್ ಬಿಜು಼ ಕಿನೇಥಿ ಪಾಪ್‌ಖ್ಹಾರು ಮಾಪ್‌ ಕರಾನ ಹುವಾನು? ಕರಿ ಇವ್ಣ-ಇವ್ಣ ದಿಲ್ಮ ಸೋಚಾಲಗ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","ಯೇಸುನೆ ತದ್‌ನು-ತದೇಸ್‌ ಇವ್ಣೆ ಮನ್‌ಮ ಇಮ್‌ ಸೋಚುಕರಾತೆ ಮಾಲುಮ್ ಕರಿಲೀನ್, “ತುಮೆ ತುಮಾರ ದಿಲ್ಮ ಶನ ಅಮ್ ಸೋಚುಕರಾಸ್ತೆ? ");
INSERT INTO vaa_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","ಕೆಹು ಶುಲ್ಬ? ಆ ಲಕ್‌ವೊ ಮಾರಿರಾಖವಾಳನ, ‘ತಾರು ಪಾಪ್‌ಖ್ಹಾರು ಮಾಪ್ ಹುಯಿಗಯು’ ಕರಿ ಬೋಲಾನುಕಿ, ನಾತೊ ‘ಉಠೀನ್ ತಾರಿ ಬಿಛಾ಼ವ್ಣಿ ಪಳ್ಳಿನ್‌ ಚಾ಼ಲ್’ ಕರಿ ಬೋಲಾನು? ");
INSERT INTO vaa_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","ಕತೋಬಿ ಮೇ ತುಮೂನ ಅದ್ಮಿನೊ ಛಿಯ್ಯಾನ ಜ಼ಮೀನ್‌ಪರ್ ಪಾಪ್‌ಖ್ಹಾರು ಮಾಪ್‌ಕರಾನ ಹಕ್‌ ಛಾ಼, ಕರಿ ವತಾಳುಸ್‌” ಅಮ್ ಬೋಲಿನ್ ಯೋ ಲಕ್‌ವೊ ಮಾರಿರಾಖವಾಳ ಭಣಿ ದೇಖಿನ್, ");
INSERT INTO vaa_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“ಉಟ್, ತಾರಿ ಬಿಛಾ಼ವ್ಣಿ ಪಳ್ಳಿನ್‌, ಘರೆ ಜಾ಼! ಕರಿ ಮೇ ತುನ ಬೋಲುಸ್” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","ಅಮ್ ಬೋಲ್ತಾಸ್‌ನ ಇನೆ ಉಠೀನ್, ಇನಿ ಬಿಛಾ಼ವ್ಣಿನ ಪಳ್ಳಿನ್, ಅಖ್ಖಾನ ದೇಕ್ತಾಡೋಳೆ ಭಾದರ್ ಚ಼ಲೆಗಯೊ. ಅನ ದೇಖಿನ್ ಖ್ಹಾರುಜ಼ಣು ಘಣು ಅಶ್ಚರ್ಯಹುಯಿನ್, “ಹಮೆ ಹಂಕೆತೋಡಿ ಕದೇಬಿ ಅಮ್ನು ದೇಖೀಸ್‌ರಾಖ್ಯಕೊಯ್ನಿ” ಕರಿ ದೇವ್ನ ಸ್ತುತಿ ಕರ್ತುಹುಯಿನ್ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","ಯೇಸು ಪಾಛೊ಼ಫರಿನ್ ಗಲಿಲಾಯ ದರ‍್ಯಾವ್ನ ಕನಾರೆಕನ ಗಯೊ. ಅದ್ಮಿನಿ ಝೂ಼ಂಡ್‌ಖ್ಹಾರು ಇನಾಕನ ಆವಾದಿನ್, ಯೇಸು ಇವ್ಣುನ ವಚನ್ ಬೋಲಿ ದೆವಾಲಗ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","ಯೇಸು ಹಿಜ್ಜಾ಼ಥೊ ಜಾ಼ತೊರ‍್ಹವಾನಿ ವಖ್ಹತ್‌ಮ, ಶುಂಕ ಮಾಂಗಾನಿ ಝ಼ಗೋಪರ್‌ ಬೆಠೊಥೋತೆ ಅಲ್ಫಾಯನೊ ಛಿಯ್ಯೊ ಲೇವಿನ ದೇಖಿನ್, “ಮಾರ ಪೀಠೆ ಆವ್” ಕರಿ ಬುಲಾಯೊ. ಯೋ ಉಠೀನ್ ಯೇಸುನ ಪೀಠೆ ಗಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","ಅನ ಬಾದ್‌ಮ ಯೇಸು ಲೇವಿನ ಘರ್‌ಮ ಖಾಣನ ಬೆಠೋಥೊ. ಇನ ಪೀಠೆ-ಪೀಠೆ ಆಯುಹುಯು ಘಣು ಜ಼ಣು ಶುಂಕ ಮಾಂಗವಾಳು ಅಜು಼ ಪಾಪಿಖ್ಹಾರು, ಯೇಸು ಅಜು಼ ಇನ ಶಿಷ್ಯರ್‌ನ ಜೋ಼ಡೆ ಖಾಣನ ಬೆಠೂಥು. ");
INSERT INTO vaa_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","ಹಿಜ್ಜಾ಼ ಪರಿಸಾಯರ್‌ನಿ ಝೂ಼ಂಡ್‌ವಾಳು ಹುಯಿರ‍್ಹುಥೂತೆ, ಮೋಶೆನಿ ವಚನ್ ಶಿಕಾಡವಾಳು ಶಾಸ್ತ್ರಿಮ ಥೋಡು ಜ಼ಣು, ಯೇಸು ಶುಂಕ ಮಾಂಗವಾಳನ ಅಜು಼ ಪಾಪಿ ಅದ್ಮಿನ ಜೋ಼ಡೆ ಖಾಣು ಖಾತಾನ ದೇಖ್ಯು. ತದೆ ಇವ್ಣೆ ಯೇಸುನ ಶಿಷ್ಯರ್‌ನ, “ಯೋ ಅಮ್ನಅದ್ಮಿನ ಜೋ಼ಡೆ ಶನ ಖಾಣು ಖಾಸ್ತೆ?” ಕರಿ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","ಅನ ಖ್ಹಮ್‌ಜಿನ್‌ ಯೇಸುನೆ, “ಅಛ್ಛು಼ರ‍್ಹಾವಾಳನ ವೈದ್ಯನಿ ಜ಼ರೂರತ್ ಕೊಯ್ನಿ, ರೋಗ್‌ಮ ರ‍್ಹಾವಾಳನ ವೈದ್ಯನಿ ಜ಼ರೂರತ್ ಛಾ಼. ಮೇ ಆಯೋತೆ ನೀತಿವಾಳನ ಬುಲಾವನ ಕಾಹೆ, ಪಾಪಿ ಖ್ಹಾರಾನ ಬುಲಾವನ ಆಯೋತೆ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","ಬಾಪ್ತಿಸ್ಮ ದ್ಯವಾಳೊ ಯೋಹಾನನು ಶಿಷ್ಯರ್‌ಬಿ, ಫರಿಸಾಯರ್‌ನು ಶಿಷ್ಯರ್‌ ಉಪವಾಸ್ ಥು. ತದೆ ಥೋಡು ಅದ್ಮಿ ಯೇಸುಕನ ಆಯಿನ್, “ಯೋಹಾನನು ಶಿಷ್ಯರ್‌ಬಿ ಫರಿಸಾಯರ್‌ನು ಶಿಷ್ಯರ್‌ ಖ್ಹಾರು ಉಪವಾಸ್ ರ‍್ಹೇಸ್‌ನಿ, ತಾರು ಶಿಷ್ಯರ್‌ ಶನ ಉಪವಾಸ್ ಕೋ ರ‍್ಹೇಯ್ನಿ?” ಕರಿ ಪುಛಾ಼ಯು. ");
INSERT INTO vaa_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","ತದೆ ಯೇಸುನೆ ಇವ್ಣುನ, “ವ್ಯಹಾನ ಆಯೂತೆ ಅದ್ಮಿ ಇವ್ಣ ಜೋ಼ಡೆ ನೌಶೊ ರ‍್ಹವಾಪರ್ ಉಪವಾಸ್ ರಹೆಜಾ಼ಯ್‌ ಕಿಶು? ನೌಶೊ ವ್ಯಹಾನಘರ್‌ಮ ಇವ್ಣ ಜೋ಼ಡೆ ರ‍್ಹಾವಾಲಗು ಇವ್ಣೆ ಉಪವಾಸ್ ಕೋ ರ‍್ಹೇಯ್ನಿ. ");
INSERT INTO vaa_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","ಕತೋಬಿ, ನೌಶೊನ ಇವ್ಣಕಂಥು ಲೀಜಾ಼ವಾನ ದನ್ ಆವ್‌ಶೆ, ಯೋ ದನ್‌ಮಾಸ್ ಇವ್ಣೆ ಉಪವಾಸ್ ರ‍್ಹಿಶೆ. ");
INSERT INTO vaa_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","ಕೋಣ್‌ಬಿ ಫಾಟಿಹುಯು ಜೂ಼ನ ಲುಂಗ್ಡಾನ ಕೇಡೆ ನವು ಲುಂಗ್ಡಾನು ಥಿಗ್‌ಳು ಲಗಾಡಿನ್ ಶಿವಾಕೊಯ್ನಿ, ಇಮ್‌ ಶಿವಿತೊ ಯೋ ನವು ಲುಂಗ್ಡಾನು ಥಿಗ್‌ಳು ಖೇಚಾ಼ವಸ್ತೆ ಇನಖ್ಹಾಜೆ, ಯೋ ಜೂ಼ನು ಲುಂಗ್ಡು ಬಿಜೂ಼ಬಿ ಜಾ಼ಖ್ಹತ್ ಫಾಟಿಜಾ಼ಸ್‌. ");
INSERT INTO vaa_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","ಇಮ್ಮಸ್ ಕೋಣ್‌ಬಿ ಜೂ಼ನಿ ಚಾ಼ಂಬ್ಡಾನಿ ತಿತ್ತಿಯೇಮ ನವು ದ್ರಾಕ್ಷಿನು ರಖ್ಹ್‌ ಭರಿ ಮ್ಹೇಲಾಕೊಯ್ನಿ, ಇಮ್‌ ಭರಿ ಮ್ಹೇಲ್ಯೂತೊ, ಯೋ ನವು ದ್ರಾಕ್ಷಿನು ರಖ್ಹ್‌ ಯೋ ಜೂ಼ನಿ ಚಾ಼ಂಬ್ಡಾನಿ ತಿತ್ತಿನ ಫೋಡಿನಾಖಸ್. ತದೆ ದ್ರಾಕ್ಷಿನು ರಖ್ಹ್‌ಬಿ ಚಾ಼ಂಬ್ಡಾನಿ ತಿತ್ತಿಯೇಬಿ ಭೇ ಖರಾಬ್ ಹುಯಿಜಾ಼ಸ್. ಇನಾಖ್ಹಾಜೆ ನವು ದ್ರಾಕ್ಷಿನ ರಖ್ಹ್‌ನ ನವ ಚಾ಼ಂಬ್ಡಾನಿ ತಿತ್ತಿಯೇಮ ಭರಿ ಮ್ಹೇಲಾಸ್” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","ಯೇಸು ಸಬ್ಬತ್‌ನ ರೋಜೆ, ಇನ ಶಿಷ್ಯರ್‌ನ ಜೋ಼ಡೆ ಖೇತರ್‌ಮಾಕರಿ ವಳ್ಯೊಜಾ಼ತೋಥೊ, ತದೆ ಇನ ಶಿಷ್ಯರ್‌ನೆ ಖಾವಾನಖ್ಹಾಜೆ ಥೋಡು ಬುಟ್ಟಾ ತೋಡಿಲಿದ. ");
INSERT INTO vaa_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","ಫರಿಸಾಯರ್‌ವಾಳು ಅನ ದೇಖಿನ್ ಯೇಸುನ, “ದೇಕ್, ಅವ್ಣೆ ಸಬ್ಬತ್‌ ದನ್ಮ ನಿಯಮ್‌ಕೊಂತೆ ಕಾಮ್ ಶನ ಕರಾಸ್?” ಕರಿ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","ಯೇಸುನೆ ಇವ್ಣುನ, “ದಾವೀದ್‌ಬಿ ಇನ ಜೋ಼ಡ್ಮ ರ‍್ಹವಾಳು ಖಾಣು ಕೊಂತೆ ವಖ್ಹತ್‌ಮ, ಜಾ಼ಖ್ಹತ್ ಭುಕ್ ಲಾಗಖ್ಹತರ್, ದಾವೀದ್‌ನೆ ಶಾತ್‌ ಕರ‍್ಯೊ ಕರಿ ತುಮೆ ಕದೇಬಿ ಪಢ್ಯಾಕೊಯ್ನಿಕಿಶು? ");
INSERT INTO vaa_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","ಇನೆ ಗಲ್‌ಢಯಾಜಕ್ ಅಬಿಯಾತರ್‌ನ ಹಗಾಮ್ಮ ದೇವ್ನ ಮಂದಿರ್‌ಮ ಜೈ಼ನ್‌, ಯಾಜಕರಸ್‌ ಖಲಿಖಾವ್ಣುಥುತೆ ಪಣ್ಕಿ ಕೋಣ್‌ಬಿ ನಾ ಖಾವ್ಣುಕರಿ ತದ್ನಿ ಖಾನುಲ್‌ಮ, ದೇವ್ನ ಖ್ಹಾಮೆ ಮ್ಹೇಲಾತೆ ರೋಟಾನ ಖೈನ್, ಇನ ಜೋ಼ಡ್ಮ ರ‍್ಹಾವಾಳನಾಬಿ ದಿದೋನಿ?” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","ಅಜು಼ ಯೇಸುನೆ ಇವ್ಣುನ, “ಅದ್ಮಿನ ಅಛ್ಛಾ಼ನಖ್ಹಾಜೆ ದೇವ್ನೆ ಸಬ್ಬತ್ ದನ್ನ ಬಣಾಯೋತೆ ಪಣ್ಕಿ, ಸಬ್ಬತ್‌ ದನ್ನ ದಾಬುಕ್ಮ ರ‍್ಹಾವಾನಟೇಕೆ ಅದ್ಮಿ ಖ್ಹಾರಾನ ಕೋ ಬಣೈರಾಖ್ಯೋನಿ. ");
INSERT INTO vaa_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","ಅನಖ್ಹಾಜೆಸ್ ಅದ್ಮಿನೊ ಛಿಯ್ಯೊ, ಸಬ್ಬತ್‌ ದನ್ಮಾಬಿ ಪ್ರಭು ಹುಯಿರ‍್ಹೋಸ್” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","ಬಿಜೇಕ್ ದನ್ನೆ ಯೇಸು ಸಬೆ ಭರಾವನು ಮಂದಿರ್‌ಮ ಗಯೊ. ಹಿಜ್ಜಾ಼ ಹಾತ್‌ ಝೂ಼ಟೊ ಪಡಿಹುಯು ಏಕ್‌ ಅದ್ಮಿಥು. ");
INSERT INTO vaa_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","ಹಿಜ್ಜಾ಼ ಥೋಡು ಅದ್ಮಿ ಯೇಸುಪರ್‌ ಗಲ್ತಿ ಲಗಾಡನಖ್ಹಾಜೆ, ಸಬ್ಬತ್‌ ದನ್ಮ ಯೋ ಹಾತ್‌ ಝೂ಼ಟೊ ಪಡಿಹುಯು ಅದ್ಮಿನ ಅಛ್ಛು಼ ಕರಾಸ್ಕಿ ಶುಕಿ, ಕರಿ ಜ಼ಪೀನ್ ದೇಖುಕರ್ತುಥು. ");
INSERT INTO vaa_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","ಯೇಸುನೆ ಯೋ ಹಾತ್‌ ಝೂ಼ಟೊ ಪಡ್ಯೊಹುಯೊ ಅದ್ಮಿನ, “ಉಠೀನ್ ಖ್ಹಾರಾನ ಇಚ಼್‌ಮ ಐನ್ ಭೀರೆ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","ತದೆ ಯೇಸುನೆ ಇವ್ಣುನ, “ಸಬ್ಬತ್‌ ದನ್ಮ ಧರ್ಮಶಾಸ್ತ್ರನಿ ನಿಯಮ್‌ನು ಕಾಮ್‌ಕರಾನು ಖೆವು? ಅಛ಼್ಛುಕರಾನುಕಿ ಖರಾಬ್‌ಕರಾನು? ಜಾನ್‌ ಬಚಾ಼ಡಾನುಕಿ, ಕಾಡಾನು?” ಕರಿ ಬೋಲಾಖ್ಹತರ್ ಇವ್ಣೆ ಖ್ಹೊಪ್‌ ಥು. ");
INSERT INTO vaa_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","ತದೆ ಯೇಸು ಖೀಜ಼್‌ಥಿ ಚಾರ‍್ಹೆ ಬಾಜು಼ ದೇಖಿನ್‌, ಇವ್ಣೊ ದಿಲ್‌ ಬಂಡಾನಿ ಘೋಣಿ ಹುಯಿರ‍್ಹೋತೆ ಇನಾಖ್ಹಾಜೆ ಇನ ಘಣು ದುಖ್ ಹುಯು. ತದೆ ಯೋ ಹಾತ್ ಝೂ಼ಟೊ ಪಡ್ಯೊಹುಯೊ ಅದ್ಮಿನ, “ತಾರೊ ಹಾತ್ ಖ್ಹಾಮ್ಣೆ ಕರ್‌” ಕರಿ ಬೋಲ್ಯೊ. ಯೋ ಖ್ಹಾಮ್ಣೆ ಹಾತ್ ಕಾಡ್ತಾ, ಇನೊ ಹಾತ್ ಅಛ್ಛೊ಼ ಹುಯಿಗಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","ತದೆ ಫರಿಸಾಯರ್ ಖ್ಹಾರು ಭಾರ್‌ಜೈ಼ನ್‌ ಒಗ್ಗಿಸ್‌ಮ ಹೆರೋದ ರಾಜ಼ ಭಣಿವಾಳನ ಜೋ಼ಡೆ ಮಶ್ಲತ್ ಭಂದೈನ್, ಯೇಸುನ ಖೆವಿ ತರೀಕಾಥಿ ಮಾರ‍್ಯೆ ಕರಿ ಸೋಚ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","ಅನ ಬಾದ್‌ಮ ಯೇಸು ಇನ ಶಿಷ್ಯರ್‌ನ ಜೋ಼ಡೆ ದರ‍್ಯಾವ್‌ಕನ ಗಯೊ. ಗಲಿಲಾಯ ತಬರ್‌ಖಾಥು ಅಜು಼ ಯೂದಾಯ ತಬರ್‌ಖಾಥು ಘಣು ಅದ್ಮಿ ಇನ ಪೀಠೆ ಗಯು. ");
INSERT INTO vaa_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","ಎತ್ರೇಸ್ ಕಾಹೆತೆ ಯೇಸು ಅಮ್ನು-ಅಮ್ನು ಕಾಮ್ ಕರಾಸ್ ಕರಿ ಖ್ಹಮ್‌ಜಿನ್‌, ಯೂದಾಯ ತಬರ್‌ಖಾಥು, ಯೆರೂಸಲೇಮ್ ಖ್ಹಯೇರ್‌ಭಣಿಥುಬಿ, ಇದುಮಾಯ ತಬರ್‌ಖಾಭಣಿಥು, ಯೊರ್ದನ್‌ ನದ್ದಿನು ಪಾರ್ಲಿ ಬಾಜು಼ಥು, ತೂರ್ ಅಜು಼ ಸೀದೋನ್ ಖ್ಹಯೇರ್‌ಥು ಘಣು ಅದ್ಮಿ ಯೇಸುಕನ ಆಯು. ");
INSERT INTO vaa_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","ಅದ್ಮಿನಿ ಝೂ಼ಂಡ್‌ ಜಾ಼ಖ್ಹತ್ ಥೀತೆ ಇನಾಖ್ಹಾಜೆ ಯೇಸುನೆ, ಅದ್ಮಿಖ್ಹಾರು ಇನಾಪರ್‌ ಪಡೀನ್ ಧಕೇಲ್‌ಶೆ ಕರಿ ಇನ ಶಿಷ್ಯರ್‌ನ, “ಮಾರಖ್ಹಾಜೆ ಏಕ್‌ ಡೋಣ್ಣಾ ಖ್ಹವಾರಿ ಮಿಛಾ಼ಣೊ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","ಶನಕತೊ ಯೇಸುನೆ ಘಣ ಅದ್ಮಿನು ರೋಗ್‌ ಅಛ್ಛು಼ ಕರ‍್ಯೊಥೋತೆ ದೇಖಿನ್, ರೋಗ್‌ಮ ರ‍್ಹವಾಳು ಖ್ಹಾರು ಇನ ಛೀಮ್‌ನು ಕರಿ ಧಕೇಲ-ಧಕೇಲಿ ಕರ್ತುಥು. ");
INSERT INTO vaa_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","ಅಜು಼ ಭೂತ್ ಧರೀರಾಖ್ಯುಹುಯು ಅದ್ಮಿಖ್ಹಾರು ಯೇಸುನ ದೇಖಾತೋಡಿ ಇನ ಗೋಡಾಪರ್ ಪಡ್‌ತೂಥು; ಇವ್ಣಮಾನು ಭೂತ್‌ಖ್ಹಾರು, “ತೂ ದೇವ್‌ನೊ ಛಿಯ್ಯೊ!” ಕರಿ ಚಿಕರ್ತುಥು”. ");
INSERT INTO vaa_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","ಕತೋಬಿ ಯೇಸುನೆ ಯೋ ಕೋಣ್ ಕರಿ, ಅದ್ಮಿನ ಖ್ಹಾಮೆ ನಾ ಬೋಲ್‌ನು ಕರಿ ಭೂತ್‌ನ ಖ್ಹಾರು ಝೇತಾಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","ಬಾದ್‌ಮ ಯೇಸು ಏಕ್‌ ಪಹಡ್‌ಪರ್ ಚ಼ಢೀನ್, ಇನ ಕೋಣ್-ಕೋಣ್ ಹೋಣುಕಿ ಇವ್ಣುನ ಬುಲಾಯೊ. ತದೆ ಇವ್ಣೆ ಇನಾಕನ ಆಯು. ");
INSERT INTO vaa_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","ಇವ್ಣಮಾಥು ಯೇಸು ಭಾರ ಜ಼ಣಾನ ಚೂ಼ಣಿನ್ ಅಪೊಸ್ತಲರ್ ಕರಿ ನಾಮ್‌ದಿದೊ. ಯೋ ಭಾರ ಜ಼ಣ ಇನ ಜೋ಼ಡೆ ರ‍್ಹೇವ್ಣುಕರಿ ಅಜು಼ ದೇವ್ನಿ ಅಛ್ಛಿ ಖಬರ್‌ನ ತಮಾಮ್‌ ಅದ್ಮಿನ ಬೋಲಿದೆವಾನ ಖ್ಹಾಜೆ ಮೋಕಲ್‌ನು ಕರಿ, ");
INSERT INTO vaa_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","ಅಜು಼ ಭೂತ್‌ಖ್ಹಾರು ಕಾಡಾನ ಅದಿಕಾರ್‌ವಾಳ ಹುಯಿರ‍್ಹೇಣು ಕರಿ ಇವ್ಣುನ ಅಲಕ್ ಕಾಡಿಮ್ಹೇಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","ಯೋ ಭಾರಜ಼ಣ ಕೋಣ್-ಕೋಣ್‌ಕತೊ, ಯೇಸುನೆ ಪೇತ್ರ ಕರಿ ನಾಮ್ ಮ್ಹೇಲ್ಯೋತೆ ಸೀಮೋನ; ");
INSERT INTO vaa_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","ಜೆಬೆದಾಯನ ಲಡ್ಕಾ ಹುಯಿರ‍್ಹಾಥಾತೆ ಯಾಕೋಬಬಿ, ಇನೊ ನ್ಹಾನೊ ಭೈ ಯೋಹಾನ. ಯೇಸುನೆ ಅವ್ಣುನ ಬೊವನರ್ಗೆಸ್‌ ಕರಿ ನಾಮ್ ದಿದೊ, ಅಮ್‌ಕತೊ “ವಿಜ಼್‌ಳಿನ ಚೆಲ್ಕ” ಕರಿ. ");
INSERT INTO vaa_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","ಅಜು಼ ಅಂದ್ರೆಯ, ಫಿಲಿಪ್ಪ, ಬಾರ್ತೊಲೊಮಾಯ, ಮತ್ತಾಯ, ತೋಮ, ಅಲ್ಫಾಯನೊ ಛಿಯ್ಯೊ ಯಾಕೋಬ, ತದ್ದಾಯ, ದೇಖ್ಹ್‌ನ ಪ್ಯಾರ್ ಕರಾವಾಳೊ ಕರಿ ಬೋಲೈಲಿದೋತೆ ಸೀಮೋನ, ");
INSERT INTO vaa_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ಅಜು಼ ಯೇಸುನ ಧೋಕೇಥಿ ಧರಿದಿದೋತೆ ಇಸ್ಕರಿಯೋತ ಯೂದ, ಅವ್ಣೇಸ್. ");
INSERT INTO vaa_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","ಅನ ಬಾದ್‌ಮ ಯೇಸು ಘರೆ ಆವಾದಿನ್, ಪಾಛು಼ ಅದ್ಮಿ ಭರೈಗಯು, ಅನೇಥಿ ಯೇಸುನಾಬಿ ಇನ ಶಿಷ್ಯರ್‌ನ ಖಾಣುಬಿ ಖಾವಾನ ವಖ್ಹತ್ ಕೋ ಥೀನಿ. ");
INSERT INTO vaa_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","ಯೇಸುನ ಘರ್‌ವಾಳಾನೆ ಇನ ದಿವಾನು ಲಾಗಿರ‍್ಹೂಸ್ ಕರಿ ಅದ್ಮಿಖ್ಹಾರು ಬೋಲಾತೆ ಖ್ಹಮ್‌ಜಿನ್‌, ಇನ ಘರೆ ಬುಲೈಲಿನ್ ಆವಾನಟೇಕೆ ನಿಕ್‌ಳ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","ಎತ್ರೇಸ್ ಕಾಹೆತೆ ಯೆರೂಸಲೇಮ್‌ಥು ಆಯುಹುಯು ಮೋಶೆನಿ ವಚನ್ ಶಿಕಾಡವಾಳು ಶಾಸ್ತ್ರಿಖ್ಹಾರು, “ಆ ಯೇಸುನ ಬೆಲ್ಜೆಬೂಲ್ ಧರಿರಾಖ್ಯೋಸ್‌! ಯೋ ಭೂತ್‌ನೊ ಯಜಮಾನ್ನಿ ಮದತ್‌ಥೀಸ್ ಯೇಸು ಭೂತ್‌ನಖ್ಹಾರು ಕಾಡಸ್ತೆ” ಕರಿ ಬೋಲುಕರ್ತೂಥು. ");
INSERT INTO vaa_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","ಯೇಸುನೆ ಇವ್ಣುನ ಖನ್ನೆ ಬುಲೈನ್, ಇವ್ಣುನ ಮತ್ಲಬ್‌ನಿ ವಾತೆಖ್ಹು ಬೋಲ್ಯೋಕಿ: ಶೈತಾನ್ ಶೈತಾನ್ನಸ್ ಕಿಮ್ ಕಾಡ್‌ಶೆ? ");
INSERT INTO vaa_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","ಏಕ್‌ ರಾಜ಼್‌ಭಾರ್‌ನು ಅದ್ಮಿ ಭಾಗ್‌ ಪಡಿನ್, ಇವ್ಣ ಇವ್ಣಾಸ್‍ಮ ಲಡೈ ಪಡಾಲಗ್ಯೂತೊ, ಯೋ ರಾಜ್ಯ ಪಡಿಜಾ಼ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","ಏಕ್‌ ಘರ್‌ಮ ಭಾಗ್‌ ಪಡಿನ್ ಏಕ್‌ಥಿ ಏಕ್‌ ಲಡೈ ಕರಾಲಗ್ಯುತೊ ಯೋ ಘರ್ ಫುಟಿಜಾ಼ಸ್. ");
INSERT INTO vaa_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","ಇಮ್ಮಸ್ ಶೈತಾನ್ ಉಠೀನ್ ಇನು ಭೂತ್‌ಖ್ಹಾರನ ಯೋಸ್ ನಖ್ಹಾಡ್ಯೋತೊ ಯೋ ಭಾಗ್‌ ಹುಯಿನ್‌, ಇನು ರಾಜ಼್‌ಭಾರ್ ರ‍್ಹಿಶೆಕೊಂತೆ ಖತಮ್ ಹುಯಿಜಾ಼ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","ಎತ್ರೇಸ್ ಕಾಹೆತೆ ಕೋಣ್‌ತೋಬಿ ಏಕ್‌ ಜ಼ಣು ಅಗಾಡಿ ಏಕ್‌ ಶಕತ್‌ವಾಳ ಅದ್ಮಿನ ಭಾಂದ್ಯುನಾತೊ, ಇನ ಘರ್‌ಮ ಜೈ಼ನ್‌, ಇನು ಶೊತ್ ಖ್ಹಾರು ಚೋ಼ರಿ ಕರಾನ ಕೋ ಹುವಾನಿ. ಕತೋಬಿ ಯೋ ಇನ ಭಾಂದಿನಾಖಿದೆವಾನ ಬಾದ್‌ಮ ಇನ ಘರ್‌ಮ ಲೂಟಿ ಕರೆಜಾ಼ಯ್. ");
INSERT INTO vaa_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","ಯೇಸುನೆ “ತುಮೂನ ಮೇ ಖ್ಹಾಚಾಮ ಬೋಲುಸ್ಕಿ, ಅದ್ಮಿಖ್ಹಾರು ಕರಾತೆಅಖ್ಖು ಪಾಪ್‌ನಾಬಿ ದೂಷಣೆನಾಬಿ ಕ್ಷಮಾಪಣ್ ಮಳ್‌ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","ಕತೋಬಿ ಪವಿತ್ರಾತ್ಮನಿ ಚಿಂಘಾವ್ಣಿ ಕರಾವಾಳನ ಕದೇಬಿ ಮಾಪಿ ಕೋ ಮಳ್‌ಶೆನಿ. ಯೋ ಹಮೇಶಾಬಿ ಮಾಪ್‌ಕರಾನ ಕೋ ಹುವ್ವಾನಿತೆ ಪಾಪ್‌ಮ ಪಡಿಗಯೊ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","ಇವ್ಣೆ ಇನ, “ಭೂತ್‌ ಧರಿರಾಖ್ಯುಸ್” ಕರಿ ಬೋಲುಕರ್ತೂಥೂತೆ ಇನಾಖ್ಹಾಜೆ ಯೇಸುನೆ ಅಮ್ ಬೋಲ್ಯೋತೆ. ");
INSERT INTO vaa_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","ತದೆ ಯೇಸುನಿ ಆಯಾಬಿ ಇನ ನ್ಹಾನ ಭೈಯೇ ಹಿಜ್ಜಾ಼ ಐನ್, ಭಾರ್ ಭೀರಿನ್‌ ಇನ ಬುಲಾಯು. ");
INSERT INTO vaa_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","ತದೆ ಯೇಸುನ ಅಶ್‌ಪಿಶ್‌ ಭರೈರ‍್ಹುಥೂತೆ ಅದ್ಮಿಖ್ಹಾರು ಇನ, “ತಾರಿ ಆಯ, ಭೇನೆ ಅಜು಼ ತಾರ ಭೈಯೇ ತುನ ಢೂಂಡಿನ್ ಭಾರ್‌ ಭಿಯ್ಯುಸ್ ದೇಕ್” ಕರಿ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","ತದೆ ಯೇಸುನೆ ಇವ್ಣುನ, “ಮಾರಿ ಆಯ ಕೋಣ್? ಮಾರ ಭೈಯೇ ಕೋಣ್?” ಕರಿ ಬೋಲೀನ್‌, ");
INSERT INTO vaa_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","ಇನ ಅಶ್‌ಪಿಶ್‌ ಬೆಠುಥೂತೆ ಅದ್ಮಿನ ದೇಖಿನ್‌, “ಹಂದೇಕ್‌! ಅವ್ಣೇಸ್ ಮನ ಆಯಾಬಿ, ಮಾರ ಭೈಯೇ! ");
INSERT INTO vaa_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","ಕೋಣ್ ದೇವ್ನಿ ಮರ್ಜಿನಿ ಘೋಣಿ ಚಾ಼ಲಾಸ್ಕಿ ಯೋಸ್‌ ಮಾರೊ ಭೈ, ಮಾರಿ ಭೇನ್, ಮಾರಿ ಆಯ ಹುಯಿರುಸ್‌” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","ಯೇಸು ಪಾಛೊ಼ ಗಲಿಲಾಯ ದರ‍್ಯಾವ್‍ನ ಕನಾರೆಕನ ವಚನ್ ಬೋಲಿ ದೆವ್‌ಕರ್ತೋಥೊ. ಘಣು ಅದ್ಮಿ ಇನಾಕನ ಐನ್ ಭರೈರ‍್ಹುಥೂತೆ ಇನಖ್ಹಾಜೆ ಯೇಸುನೆ ಪಾಣಿಮ ಭೀಥಿತೆ ಡೋಣ್‌ಪರ್‌ ಚ಼ಢೀನ್‌ ಬೇಶಿಗಯೊ. ಯೋ ಅದ್ಮಿಖ್ಹಾರು ಭಾರ್‌ ಕನಾರೆಕನ ಭರೈರ‍್ಹೂಥು. ");
INSERT INTO vaa_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","ತದೆ ಯೇಸುನೆ ಇವ್ಣುನ ಮತ್ಲಬ್‌ನಿ ಖೇಣಿಯೇಥಿ ಘಣಿ ಬಾರೇಮ ಬೋಲಿದಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","ಇನೆ ಬೋಲ್ಯೋಕಿ, “ಹೈಕಡ್ ಖ್ಹಮ್‌ಜೊ಼! ಏಕ್‌ ಅದ್ಮಿ ಖೇತರ್‌ಮ ಪಂಡಾ ಛಿಡ್ಕಾನಖ್ಹಾಜೆ ಗಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","ಯೋ ಪಂಡಾ ಛಿಡ್ಕಾನಿ ವಖ್ಹತ್‌ಮ ಥೋಡ ಪಂಡಾ ವಾಟ್ನ ಶೇಡೆ ಪಡೀನ್‌ ಜಿನಾವರ್‌ ಖ್ಹಾರು ಆಯಿನ್‌ ‍ಇನ ಚ಼ರಿಲಿದು. ");
INSERT INTO vaa_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","ಬಿಜು಼ ಥೋಡ ಪಂಡಾ ಜಾ಼ಖ್ಹತ್ ಮಾಟಿಕೊಂತೆ ಬಂಡಾನಿ ಜ಼ಮೀನ್‌ಪರ್ ಪಡ್ಯು, ಛಿವರ್‌ ಮಾಟಿ ಥೀತೆ ಇನಖ್ಹಾಜೆ ಪಂಡಾ ಒಗ್ಗಿಸ್‌ಮ ಫುಟಿ ಆಯು. ");
INSERT INTO vaa_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","ಕತೋಬಿ ದನ್ ಚ಼ಢೀನ್ ತಡ್ಕೊ ಪಡಾನ ಬಾದ್‌ಮ, ಯೋ ಶೊಶಿಯೆ ಮುರ್‌ಝೈ಼ಗಯು. ಅಜು಼ ಮಹಿತೋಡಿ ಜ಼ಡೆ ಕೋ ಮ್ಹೇಲಿರಾಖ್ಯುಥುಂತೆ ಇನಖ್ಹಾಜೆ, ಯೋ ಶೊಶಿಯೆ ಒಗ್ಗಿಸ್‌ಮ ಖ್ಹುಕೈಗಯು. ");
INSERT INTO vaa_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","ಅಜು಼ ಥೋಡ ಪಂಡಾ ಕಾಟಾನ ಡಾಗ್‌ಮ ಪಡ್ಯು. ಯೋ ಕಾಟಾನು ಝಿಕ್ರುಖ್ಹಾರು ಮೋಟುಹುಯಿನ್, ಯೋ ಶೊಶಿಯೇಪರ್‌ ಮೂಚೈ಼ಜೈ಼ನ್ ಫುಟಾನ ಕೋ ಮ್ಹೇಲ್ಯೂನಿ. ಅನಖ್ಹಾಜೆ ಯೋ ಶೊಶಿಯೆ ಪಂಡಾ ಮ್ಹೇಲ್ಯು ಕೊಯ್ನಿ. ");
INSERT INTO vaa_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","ಬಿಜು಼ ಥೋಡ ಪಂಡಾ ಅಛ್ಛಿ ಜ಼ಮೀನ್‌ಪರ್‌ ಪಡ್ಯ. ಯೋ ಪಂಡಾ ಫುಟೀನ್, ಮೋಟು ಹುಯು ಅಜು಼ ಪಂಡಾ ಮ್ಹೇಲ್ಯು: ಇನಾಮಾನು ಥೋಡು ಡೋಡಿಖ್ಹ್‌ ಪಂಡಾಲಗು, ಥೋಡು ತೀನಿಖ್ಹ್‌ ಪಂಡಾಲಗು, ಅಜು಼ ಥೋಡು ಖ್ಹೋ ಪಂಡಾಲಗು ಮ್ಹೇಲ್ಯು”. ");
INSERT INTO vaa_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","ಬಾದ್‌ಮ ಯೇಸುನೆ, “ಕಿನ-ಕಿನ ಖ್ಹಮ್‌ಜಾ಼ನ ಕಾನ್‌ ಛಾ಼ಕಿ, ಇವ್ಣೆ ಕಾನ್‌ ಜೋ಼ಡಿ ಖ್ಹಮ್‌ಜೊ಼!” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","ಬಾದ್‌ಮ ಯೇಸು ಎಕ್ಲೊ ರ‍್ಹವಾನಿ ವಖ್ಹತ್‌ಮ, ಇನು ಭಾರ ಶಿಷ್ಯರ್‌ ಅಜು಼ ಇನಜೋ಼ಡೆ ರ‍್ಹವಾಳು ಬಿಜು಼ ಖ್ಹಾರು ಅದ್ಮಿ ಇನಾಕನ ಐನ್, ಯೋ ಮತ್ಲಬ್‌ನಿ ಖೇಣಿಯೇನಿ ಬಾರೇಮ ಪುಛಾ಼ಯು. ");
INSERT INTO vaa_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","ತದೆ ಯೇಸುನೆ ಇವ್ಣುನ ಫರೈನ್ ಬೋಲ್ಯೋಕಿ, “ದೇವ್ನಿ ರಾಜ್ಯನಿ ಲಪಿರ‍್ಹೀತೆ ಖ್ಹಾಚಿ ವಾತೆಖ್ಹಾರಿ ತುಮೂನ ದೆವೈರ‍್ಹೀಸ್. ಕತೋಬಿ ಬಿಜು಼ ಖ್ಹಾರು ಭಾರ್‌ಲ್ಯು ಅದ್ಮಿ, ಯೋ ಖ್ಹಾರಿ ವಾತೆನ ಮತ್ಲಬ್‌ನಿ ಖೇಣಿಯೇಥಿ ಖ್ಹಮ್‌ಜಾ಼ಸ್‌. ");
INSERT INTO vaa_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","ಶನಕತೊ, ‘ಇವ್ಣೆ ಡೋಳೆಖ್ಹು ದೇಖ್ಯುತೋಬಿ ದೆಖಾವ್ಣು ನಾ; ಕಾನ್‍ಥಿ ಖ್ಹಮ್‌ಜುತೋಬಿ ಪರಖ್‌ಣು ನಾ. ಇಮ್‌ ಕಾಯಿತೋಬಿ ದೇಖಿ, ಪರ್ಖಿಲಿದುತೊ, ಇವ್ಣೆ ದೇವ್ ಭಣಿ ಫರಿಜಾ಼ಶೆ, ಅಜು಼ ದೇವ್ ಇವ್ಣುನ ಮಾಪ್‌ ಕರಿನಾಕ್‌ಶೆ ಕರೀಸ್, ಯೋ ಖ್ಹಾರಿ ಖ್ಹಾಚಿ ಲಪಡೈರ‍್ಹೀಸ್’. ");
INSERT INTO vaa_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","ಬಾದ್‌ಮ ಯೇಸುನೆ ಇವ್ಣುನ, “ಆ ಮತ್ಲಬ್‌ನಿ ಖೇಣಿ ತುಮೂನ ಮಾಲುಮ್‌ಪಡ್ಯು ಕೊಯ್ನಿಕಿ ಶು? ಇಮ್‍ಕತೊ, ಮೇ ಬೋಲುಸ್ತೆ ಬಿಜಿಖ್ಹಾರಿ ಮತ್ಲಬ್‌ನಿ ಖೇಣಿಯೇನ ತುಮೆ ಕಿಮ್ ಮಾಲುಮ್‌ ಕರ್ಶು? ");
INSERT INTO vaa_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","ಯೋ ಪಂಡಾ ಛಿಡ್ಕಾವಾಳೊ ಕತೊ ದೇವ್ನಿ ವಚನ್ನ ಬೋಲಿದ್ಯವಾಳೊ ಕರಿ. ");
INSERT INTO vaa_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","ಥೋಡು ಅದ್ಮಿ ದೇವ್ನಿ ವಚನ್ನ ಖ್ಹಮಜ಼್‌ತಾಸ್‌, ಶೈತಾನ್ ಐನ್ ಇವ್ಣಮಾನಿ ವಚನ್ನ ಕಾಡಿನಾಖಿದೇಸ್. ಅವ್ಣೇಸ್ ಪಂಡಾ ಪಡ್ಯಾತೆ ವಾಟ್ನ ಶೇಡೆನಿ ಮಾಟಿ ಹುಯಿರ‍್ಹುಸ್‍. ");
INSERT INTO vaa_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","17","ಬಿಜು಼ ಥೋಡು ಅದ್ಮಿ ದೇವ್ನಿ ವಚನ್ನ ಖ್ಹಮಜ಼್‌ತಾಸ್‌, ಖ್ಹುಶಿಥಿ ಒಗ್ಗಿಸ್‌ಮ ಮಾನಿಜಾ಼ಸ್. ಕತೋಬಿ ಯೋ ವಚನ್ನ ಇವ್ಣ ಮಹಿ ಜ಼ಡ್‌ ಮ್ಹೇಲಿನ್ ಫುಟಾದೇಯಿಕೊಯ್ನಿ. ಇವ್ಣೆ ಥೋಡಾಸ್ ದನ್ ದೇವ್ನಿ ವಚನ್ನ ನಂಬಾಸ್, ಬಾದ್‌ಮ ಯೋ ವಚನ್ನಖ್ಹಾಜೆ ಬಿಜಾ಼ಥಿ ಖ್ಹತಾಪ್ಣಿ ನಾತೊ ವದೇಖ್ಹೊ ಆಯುತೊ, ಜ಼ಲ್ದೀಸ್‍ಮ ಪಡಿಜಾ಼ಸ್‌. ಅವ್ಣೇಸ್ ಪಂಡಾ ಪಡ್ಯಾತೆ ಬಂಡಾಪರ್‌ನಿ ಮಾಟಿ ಹುಯಿರ‍್ಹೂಸ್. ");
INSERT INTO vaa_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","19","ಬಿಜು಼ ಥೋಡು ಅದ್ಮಿ ದೇವ್ನಿ ವಚನ್ನ ಖ್ಹಮ್‌ಜುತೋಬಿ, ಜಗತ್ನಿ ಸೋಚ್‌ಮಾಬಿ, ಧನ್‌-ದೌಲತ್‌ಪರ್‌ನಿ ಲಾಲಚ್‍ಮಾಬಿ, ಅಜು಼ ಬಿಜಿ ಖ್ಹಾರಿ ತರ‍್ಹಾನಿ ಆಖ್ಹ್ ಇವ್ಣ ಮಹಿ ಭರೈನ್, ಇವ್ಣೆ ಖ್ಹಮ್‌ಜುತೆ ದೇವ್ನಿ ವಚನ್ನ ಉಪ್ಪರ್ ಮೂಚಿನ್ ದಾಬಿದೇಸ್. ಇನಾಖ್ಹಾಜೆ ಇವ್ಣೆ ಫಲ್ ಕೋದೇಯ್ನಿ. ಅವ್ಣೇಸ್ ಯೋ ಕಾಟಾನಿ ಝಿಕ್ರಾವ್‌ಮ ಪಂಡಾ ಪಡ್ಯಾತೆ ಝ಼ಗೊ ಹುಯಿರ‍್ಹೂಸ್. ");
INSERT INTO vaa_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","ಬಿಜು಼ ಥೋಡು ಅದ್ಮಿ ಪಂಡಾ ಪಡ್ಯಾತೆ ಅಛ್ಛಿ ಜ಼ಮೀನ್ ಹುಯಿರ‍್ಹೂಸ್. ಅವ್ಣೆ ವಚನ್ನ ಖ್ಹಮ್‌ಜಿನ್‌, ಇನ ಮಾನಿಲೇಸ್ ಅಜು಼ ಡೋಡಿಖ್ಹ್‌ ತೋಡಿ, ತೀನಿಖ್ಹ್‌ ತೋಡಿ ಅಜು಼ ಖ್ಹೋ ತೋಡಿ ಜಾ಼ಖ್ಹತ್-ಜಾ಼ಖ್ಹತ್ ಪಂಡಾ ಮ್ಹೇಲಾಸ್” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","ಅತ್ರೇಸ್ ಕಾಹೆತೆ ಯೇಸುನೆ ಇವ್ಣುನ, “ಕೋಣ್‌ಬಿ ದೀವೊ ಲಗಾಡಿನ್ ಹಂಡಾಮಾಕಿ ನಾತೊ ಪಲಂಗ್‌ನ ಹೇಟ್‌ಕಿ ಲಪಾಡಿನ್ ಮ್ಹೇಲಾಸ್ಕಿ ಶು? ಇಮ್‌ ಕಾಹೆತೆ, ದೀವೊ ಮ್ಹೇಲಾನಿ ಖಂಬಾಪರ್‌ ಮ್ಹೇಲಾಕೊಯ್ನಿಕಿ ಶು? ");
INSERT INTO vaa_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","ಲಪೈರ‍್ಹೂತೆ ಖ್ಹಾರುಸ್‌ ಉಜಾ಼ಳಾಮ ಭಾರ್‌ ದೆಖಾವ್‌ಶೇಸ್‌ ದೆಖಾವ್‌ಶೆ, ಮೂಚೈ಼ರ‍್ಹವಾನು ಖ್ಹಾರು ನಿಕಳ್‌ಶೇಸ್ ನಿಕಳ್‌ಶೆ.‌ ");
INSERT INTO vaa_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","ಖ್ಹಮ್‌ಜಾ಼ನ ಕಾನ್‌ ರ‍್ಹವಾಳು ಖ್ಹಾರು ಕಾನ್‌ ಜೋ಼ಡಿ ಖ್ಹಮ್‌ಜೊ಼!” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","ಬಿಜು಼ ಇವ್ಣುನ ಯೇಸುನೆ, “ತುಮೆ ಖ್ಹಮ್‌ಜಾ಼ತೆ ವಚನ್ನ ಮನ್ ಲಗಾಡಿನ್ ಖ್ಹಮ್‌ಜೊ಼! ತುಮೆ ಅಲಕ್ನಿ ಬಾರೇಮ ಕಿಮ್ ಮಾಪಿನ್‌ ದೇಸ್ಕಿ, ಇಮ್ಮಸ್ ದೇವ್‌ಬಿ‌ ತುಮೂನ ಮಾಪ್‌ಶೆ, ಎತ್ರೇಸ್ ಕಾಹೆತೆ ಇನೇಥಿಬಿ ಜಾ಼ಖ್ಹತ್ ತೂಕ್‌ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","ಕಿನಾಕನ ಛಾ಼ಕಿ ತಿನ ಬಿಜೂ಼ಬಿ ದೆವಾವ್‌ಶೆ, ಕಿನಾಕನ ಕೊಯ್ನಿಕಿ ಇವ್ಣಕಂಥು ಛಾ಼ತೇಬಿ ಥೋಡು ಕಾಡಿಲಿಶೆ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","ಯೇಸುನೆ ಬಿಜೂ಼ಬಿ ಇವ್ಣುನ ಬೋಲ್ತೋಹುಯಿನ್, “ದೇವ್ನಿ ರಾಜ್ಯ ಅಮ್ ಛಾ಼, ಕಿಮ್‌ಕತೊ; ಏಕ್‌ ಜ಼ಣೊ ಇನಿ ಜ಼ಮೀನ್‌ಮ ಪಂಡಾ ಛಿಡ್‌ಕ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","ಅಜು಼ ಯೋ ಅದ್ಮಿ ರಾತ್‌ನು ಖ್ಹುವ್ವಾನು, ವ್ಹಾಣಾನು ಉಠಿರ‍್ಹವಾನು ಕರ್ತುರ‍್ಹೇಸ್‌. ಅಮ್ ರ‍್ಹವಾನಿ ವಖ್ಹತ್‌ಮ ಇನ ಮಾಲುಮಸ್ ಪಡಾಕೊಂತೆ ಪರಕ್ಮ ಯೋ ಪಂಡಾ ಫುಟಿನ್ ಮೋಟ ಹುವಾಸ್. ");
INSERT INTO vaa_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","ಜ಼ಮೀನ್ ಪಹಿಲೆ ಅನಾಜ಼್ ಉಬ್‌ಜಾ಼ವಸ್, ಕಿಮ್‌ಕತೊ ಪಹಿಲೆ ಡೀರಿಯೆ ದೆಖಾವಸ್, ಇನಾಕೇಡೆಥು ಬುಟ್ಟು ನಿಕ್ಳಾಸ್, ಬಾದ್‌ಮ ಬುಟ್ಟುಭರಿ ದಾಣ ಭರಾವಸ್. ");
INSERT INTO vaa_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","ಅನಾಜ಼್ ಪಿಕ್‌ವಾನ ಬಾದ್‌ಮ, ಯೋ ಅದ್ಮಿ ಖ್ಹುಗ್ಗೀನ ಹಗಾಮ್ ಐಗುಕರಿ, ಪಿಕಾವಾಳೊ ದರಾತಿಥಿ ಇನ ವ್ಹಾಡಲಗಾಸ್” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","ಬಿಜು಼ ಯೇಸುನೆ ಬೋಲ್ಯೋಕಿ, “ದೇವ್‌ನು ರಾಜ್ಯ ಅಮ್ ಕರಿ ಅಪ್ಣೆ ಶನ ಜೋ಼ಡೆ ಏಕ್‌ ಕರಿಯೆ? ನಾತೊ ಅಪ್ಣೆ ಖೆವಿ ಮತ್ಲಬ್‌ನಿ ಖೇಣಿ ಬೋಲಿನ್ ದೇವ್ನಿ ರಾಜ಼್‌ನ ವತಾಳೆ. ‌ ");
INSERT INTO vaa_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","ಯೋ ಅಮ್ ಹುಯಿರ‍್ಹೂಸ್, ಏಕ್‌ ಅದ್ಮಿ ಜಗತ್‌ಮ ಖ್ಹಾರೇಥಿ ನ್ಹಾನು ಪಂಡು ಹುಯಿರ‍್ಹೂತೆ, ರಾಯಿನ ದಾಣಾನ ಪಾಡಿನ್, ಜ಼ಮೀನ್‌ಮ ಗಾಡಸ್. ");
INSERT INTO vaa_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","ಥೋಡ ದನ್ನ ಬಾದ್‌ಮ ಯೋ ಮೋಟು ಹುಯಿನ್, ಖ್ಹಾರ ಭಾಜಿಪಾಲಾನ ಝಾ಼ಡೆಥೀಬಿ ಮೋಟು ಹುಯಿನ್, ಮೋಟಿ-ಮೋಟಿ ಡಾಳಿಯೆ ಮ್ಹೇಲಾಸ್. ತದೆ ಆಬ್‌ಮಾಥು ಉಡಂತು ಜಿನಾವರ್‌ ಖ್ಹಾರು ಮ್ಹಾಳೊ ಭಾಂದಿನ್ ವಖ್ಹಾಸ್” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","ಯೇಸುನೆ ಅಮ್ನಿ ಖ್ಹಾರಿ ಘಣಿ ಮತ್ಲಬ್‌ನಿ ಖೇಣಿಯೇಥಿ, ಅದ್ಮಿಖ್ಹಾರು ಕೆತ್ರೆ ಮನ್ ಲಗಾಡಿನ್ ಖ್ಹಮ್‌ಜಿನ್‌ ಪರ್ಖಾನ ಹುವ್ವಾಸ್‌ಕಿ, ಎತ್ರೇಸ್ ದೇವ್ನಿ ವಚನ್ ಬೋಲಿ ಖ್ಹಮ್‌ಜಾ಼ಡ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","ಯೋ ಶಾತ್‌ ಬೋಲ್ಯೊತೋಬಿ ಮತ್ಲಬ್‌ನಿ ಖೇಣಿಯೇಥೀಸ್‌ ಬೋಲ್ತೋಥೊ. ಕತೋಬಿ ಇನ ಶಿಷ್ಯರ್‌ಕನ ಅಲಕ್ ರ‍್ಹವಾನಿ ವಖ್ಹತ್‌ಮ, ಯೋ ಖ್ಹಾರಿ ಮತ್ಲಬ್‌ನಿ ಖೇಣಿಯೇನ ಛೋ಼ಡಿನ್ ಖ್ಹಮ್‌ಜಾ಼ಡ್‌ತೊಥೊ. ");
INSERT INTO vaa_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","ಯೋ ದನ್ನೆ ಖ್ಹಾಂಜ಼್ ಹುಯಿಜಾ಼ತಖ್ಹತರ್‌ ಯೇಸುನೆ ಇನ ಶಿಷ್ಯರ್‌ನ, “ಚಾ಼ಲೊ, ದರ‍್ಯಾವ್‍ನ ಪಾರ್ಲಿ ಕನಾರಿ ಜ಼ಯ್ಯೆ಼” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","ತದೆ ಶಿಷ್ಯರ್‌ಖ್ಹಾರು ಯೋ ಅದ್ಮಿನಿ ಭೀಡ್‌ಣ ಮ್ಹೆಂದಿನ್, ಯೇಸು ಬೆಠೋಥೋತೆ ಯೋಸ್ ಡೋಣ್‌ಪರ್‌ ಚ಼ಢಿನ್‌ ಇಮ್ಮಸ್ ಇನ ಬುಲೈಲಿನ್ ಗಯ. ಇವ್ಣ ಜೋ಼ಡ್ಮ ಬಿಜಿ ಖ್ಹಾರಿ ಡೋಣ್‌ಬಿ ಥಿ. ");
INSERT INTO vaa_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","ಜಾ಼ತಿವಖ್ಹತ್‌ಮ ಏಕ್‌ದಮ್ ಮೋಟೊ ವಹಿರೊ ವಾಗಿನ್, ಮೋಟೊ ಝೋ಼ಕಾಳ್ಯೊ ಉಠೀನ್ ಯೋ ಡೋಣ್ಣಾ ಮಾರ್ ಪಡ್‌ತಾಖ್ಹತರ್, ಯೋ ಡೋಣ್‌ಮ ಪಾಣಿ ಭರಾವಲಗ್ಯೂಥು. ");
INSERT INTO vaa_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","ಯೇಸು ಡೋಣ್ಣಾ ಪಾಛ಼್‌ಲಿ ಬಾಜು಼ಮ ಶಿರಾಣು ಟೇಕಿನ್ ಖ್ಹುತೋಥೊ. ತದೆ ಶಿಷ್ಯರ್‌ನೆ ಇನ ಉಠಾಡಿನ್, “ಗುರು, ಹಮೆ ಮರ್‌ವಾನ ಆಯಾನಿ ತುನ ಜ಼ರಾಬಿ ಫಿಕರ್‌ಕೊಯ್ನಿಕಿ ಶು? ಕರಿ ಬೋಲ್ಯ. ");
INSERT INTO vaa_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","ತದೆ ಯೇಸುನೆ ಉಠೀನ್ ಯೋ ವಹಿರಾನ, “ಖ್ಹೊಪ್‌ ರ‍್ಹೆ!” ಅಜು಼ ದರ‍್ಯಾವ್ನ “ಶೊಪೊ ಹುಯಿಜಾ಼!” ಕರಿ ಹುಕುಮ್‌ದಿದೊ. ಅಮ್ ಬೋಲ್ತಾಸ್‌ನ ವಹಿರೊ ಖ್ಹೊಪೊ ಪಡಿಗಯು, ಅಜು಼ ಖ್ಹಾರು ಖ್ಹೊಪೊ ಪಡಿಗಯು. ");
INSERT INTO vaa_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","ಬಾದ್‌ಮ ಯೇಸುನೆ ಇನ ಶಿಷ್ಯರ್‌ನ, “ತುಮೆ ಶನ ಡರೋಸ್ತೆ? ಅಜೂ಼ಬಿ ತುಮೂನ ವಿಶ್ವಾಸ್ ಕೊಯ್ನಿಕಿ ಶು?” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","ಕತೋಬಿ ಇವ್ಣೆ ಘಣು ಡರಿಜೈನ್, “ಆ ಅದ್ಮಿ ಕೋಣ್ ಉಶೆ? ವಹಿರೋಬಿ, ದರ‍್ಯಾವ್‌ಬಿ ಜಿನು ಆ ಬೋಲಾತೆ ಇಮ್‌ ಖ್ಹಮ್‌ಜಾ಼ಸ್‌ನಿ!” ಕರಿ ಏಕ್‌ಥಿ ಏಕ್‌ ಬೋಲಿಲಿದು. ");
INSERT INTO vaa_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","ಬಾದ್‌ಮ ಯೇಸುಬಿ ಇನು ಶಿಷ್ಯರ್‌ ಗಲಿಲಾಯ ದರ‍್ಯಾವ್‍ನ ಪಾರ್ಲಿ ಬಾಜೂ಼ಮ ಥೂತೆ, ಗೆರಸೇನವಾಳನ ತಬರ್‌ಖಾಮ ಗಯ. ");
INSERT INTO vaa_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","ಯೇಸು ಡೋಣ್‌ಮಾಥು ಭಾರ್‌ ಉತ್‌ರ‍್ಯೋತೆ ತದೇಸ್‌, ಭೂತ್‌ ಧರಿರಾಖ್ಯುಥೂತೆ ಏಕ್‌ ಜ಼ಣೊ ಮಖ್ಹಾಣ್ಯನು ಘವಿಮಾಥೊ ನಿಕ್ಳಿನ್‌ ಇನ ಖ್ಹಾಮೆ ಆಯು. ");
INSERT INTO vaa_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","4","ಯೋ ಅದ್ಮಿ ಮಖ್ಹಾಣ್ಯನಿ ಘವಿಯೇನಿ ಝ಼ಗೋಮಸ್‌ ರ‍್ಹೇತುಥು. ಘಣಿ ಹಲ್ಲ ಇನ ಬೇಡಿಥೀಬಿ, ಲ್ಹೋಡಾನಿ ಖ್ಹಂಕ್‌ಳಿಥೀಬಿ ಭಾಂದ್ಯುತೋಬಿ ಯೋ ಖ್ಹಂಕ್‌ಳಿನ ತೋಡಿನ್, ಬೇಡಿನ ಕಾಡಿನಾಖಿದೇತೂಥು. ಬಿಜು಼ ಕೋಣ್‌ಬಿ ಇನ ಖ್ಹಂಕ್‌ಳಿಥೀಬಿ ಭಾಂದಾನ ಕೋ ಹುಯುನಿ. ಯೋ ಭೂತ್‌ ಧರಿರಾಖವಾಳನ ದಾಬುಕ್ಮ ಲ್ಯಾವಾನ ಕಿನೊ ಹಾತ್‌ಬಿ ಕೋ ಹುಯುನಿ. ");
INSERT INTO vaa_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","ಯೋ ಕದೇಬಿ ರಾತ್‌-ದನ್ ಮಖ್ಹಾಣ್ಯನಿ ಘವಿಯೆ಼ಮಾಬಿ, ಪಹಾಡ್‌ಮಾಬಿ ಚಿಕ್ರಾಣ್ ಮ್ಹೇಲ್ತುಹುಯಿನ್, ಬಂಡಾಥಿ ಇನು ಯೋಸ್‌ ವ್ಹಾಡಿಲೇತುಥು. ");
INSERT INTO vaa_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","ಯೋ ದೂರ್‌ಥೊ ಯೇಸುನ ದೇಖಿನ್‌; ನಾಶಿ ಐನ್, ಇನ ಢುಕ್‌ಣ್ಯಟೇಕಿನ್, ");
INSERT INTO vaa_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","ಊಚಿ ಆವಾಜ಼್‌ಮ ಚಿಕ್ರಿನ್, “ಪರಮಂಡಲ್‌ನೊ ದೇವ್ನ ಛಿಯ್ಯಾ ಯೇಸು, ಮಾರೇಥಿ ತುನ ಶಾತ್‌ ಛಾ಼? ದೇವ್ನ ಖ್ಹಾಮ್‌ಬಿ, ಮನ ಖ್ಹತಾವ್ ನಕೊ” ಕರಿ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","ಶನಕತೊ, “ಏ ಭೂತ್‌, ಅನ ಮ್ಹೆಂದಿನ್ ಭಾರ್‌ ನಿಕಳ್” ಕರಿ ಯೇಸುನೆ ಅಗಾಡಿಸ್ ಬೋಲಿರಾಖ್ಯೊಥೊ, ಇನಾಖ್ಹಾಜೆ ಇನೆ ಇಮ್‌ ಬೋಲ್ಯುತೆ. ");
INSERT INTO vaa_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","ಅಜು಼ ಯೇಸುನೆ ಇನ, “ತಾರು ನಾಮ್ ಶಾತ್?” ಕರಿ ಪುಛಾ಼ವಖ್ಹತರ್, “ಮಾರು ನಾಮ್ ಝೂ಼ಂಡ್‌, ಶನಕತೊ ಹಮೆ ಢಿಂಡ್‌ಪಾಳಸ್ ಛಿಯ್ಯೆ಼!” ಕರಿ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","ಅಜು಼, “ಹಮೂನ ಆ ತಬರ್‌ಖಾಮಾಥು ನಕೊ ನಖ್ಹಾಡ್” ಕರಿ ಯೋ ಭೂತ್ ಧರೀರಾಖ್ಯುಥೂತೆ ಅದ್ಮಿನೆ ಯೇಸುನ ಘಣು ಗಿಂಗೈಲಿದು. ");
INSERT INTO vaa_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","ಹಿಜ್ಜಾ಼ ಖನ್ನೆಸ್‌ ಥೂತೆ ಪಹಾಡ್‌ಮ ಡೂಕರ್‌ನಿ ಮೋಟಿ ಝೂ಼ಂಡ್‌ ಚ಼ರೂಕರ್‌ತೂಥು. ");
INSERT INTO vaa_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","ತದೆ ಯೋ ಭೂತ್‌ಖ್ಹಾರು ಯೇಸುನ, “ಡೂಕರ್‌ನಿ ಝೂ಼ಂಡ್‌ನ ಮಹಿ ಪೇಖ್ಹಾನ ಹಮೂನ ಬೋಲಿಮೋಕಲ್‌” ಕರಿ ಗಿಂಗೈಲಿದು. ");
INSERT INTO vaa_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","ತದೆ ಯೇಸುನೆ ಇಮ್ಮಸ್ ಹುವಾದೆ, ಕರಿ ಹುಕುಮ್‌ ದೇತಾಖ್ಹತರ್‌ ಯೋ ಭೂತ್‌ ಖ್ಹಾರು ಯೋ ಅದ್ಮಿನ ಮ್ಹೆಂದಿನ್ ಭಾರ್ ನಿಕ್ಳಿನ್, ಡೂಕರ್‌ನಿ ಝೂ಼ಂಡ್‌ಮ ಪೇಶಿಗಯು. ತದೆ ಯೋ ಡೂಕರ್‌ಖ್ಹಾರು ನಾಶಿನ್, ಪಹಡ್‌ನಿ ಕಥಾರ್‌ಪರ್‌ಥು ದರ‍್ಯಾವ್‌ಮ ಪಡೀನ್ ದಮ್‌ ಘೋಟೈನ್‌ ಮರಿಗಯು. ಕಮ್‍ಶಿಕಮ್ ಬೇ ಹಜಾ಼ರ್‌ ಡೂಕರ್‌ ಥೂ. ");
INSERT INTO vaa_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","ಡೂಕರ್‌ ಚ಼ರಾವವಾಳು ಖ್ಹಾರು ನಾಶಿಜೈ಼ನ್ ಯೋ ಖ್ಹಯೇರ್‌ಮಾಬಿ, ಗಾಮ್ಮಾಬಿ ಇನಿ ಬಾರೇಮ ಬೋಲ್ತಖ್ಹತರ್‌ ಇನ ದೇಖಾನಖ್ಹಾಜೆ ಅದ್ಮಿಖ್ಹಾರು ಯೇಸು ಥೋತೆ ಹಿಜ್ಜಾ಼ ಆಯು. ");
INSERT INTO vaa_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","ಯೇಸು ಹಿಜ್ಜಾ಼ ಆಯೊ ತದೆ ಯೋ ಭೂತ್‌ನಿ ಝೂ಼ಂಡ್‌ ಧರಿರಾಖ್ಯುಥೂತೆ ಅದ್ಮಿ ಲುಂಗ್ಡಾವ್‍ನ ಪೇರ‍್ಹಿಲಿನ್, ಅಛ್ಛಿ ಖ್ಹಯಾಲ್‌ಥಿ, ಬೆಠುಥೂತೆ ದೇಖಿನ್, ಅದ್ಮಿಖ್ಹಾರು ಡರಿಗಯು. ");
INSERT INTO vaa_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","ಚಾ಼ಲ್ಯುತೆ ಇನಿ ಬಾರೇಮ ದೇಖಿರಾಖ್ಯುಥುತೆ ಇವ್ಣೆ, ಯೋ ಭೂತ್ ಧರಿರಾಖ್ಯುಥೂತೆ ಇನ ಅಮ್-ಅಮ್ ಹುಯುತೇಬಿ, ಬಿಜು಼ ಡೂಕರ್‌ನಿ ಬಾರೇಮಾಬಿ, ");
INSERT INTO vaa_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","ಯೋ ಐರ‍್ಹೂಥೂತೆ ಅದ್ಮಿನ ಬೋಲಾಖ್ಹತರ್ ಇವ್ಣೆ, ಇವ್ಣ ತಬರ್‌ಖಾನ ಮ್ಹೆಂದಿನ್ ಜಾ಼ ಕರಿ ಯೇಸುನ ಗಿಂಗೈಲಿದು. ");
INSERT INTO vaa_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","ಯೇಸು ಡೋಣ್‌ ಚ಼ಢಾನಿ ವಖ್ಹತ್‌ಮ, ಯೋ ಭೂತ್‌ಖ್ಹಾರು ನಿಕ್ಳಿಗಯೂತೆ ಅದ್ಮಿ, “ಮೇಬಿ ತಾರ ಕೇಡೆಸ್ ರ‍್ಹವುಸ್” ಕರಿ ಯೇಸುನ ಗಿಂಗೈಲಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","ಕತೋಬಿ ಯೇಸುನೆ ಇನ ರ‍್ಹವಾದಿದೊ ಕೊಯ್ನಿ. ಯೋ ಅದ್ಮಿನ, “ತೂ ತಾರ ಘರೇಬಿ, ತಾರ ಅದ್ಮಿಕನಾಬಿ ಜೈ಼ನ್‌, ಪ್ರಭುನೆ ತಾರಪರ್ ಗೋರ್‌ಕರೀನ್, ತುನ ಕೆತ್ರೆ ಮದತ್ ಕರ‍್ಯೊ ಕರಿ ಯೋ ಖ್ಹಾರಾನ ಇವ್ಣುನ ಬೋಲ್” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","ಇಮ್ಮಸ್ ಯೋ ಅದ್ಮಿ ಹಿಜ್ಜಾ಼ಥು ನಿಕ್ಳಿನ್ ದೆಕಪೊಲಿ ಕರಿ ತಬರ್‌ಖಾಮ ಜೈ಼ನ್, ಯೇಸುನೆ ಇನ ಕರ‍್ಯೋತೊ ಖ್ಹಾರಿ ಮದತ್‍ನ ಬೋಲಾನ ಶುರುಕರ‍್ಯು. ಅನ ಖ್ಹಮ್‌ಜಾ಼ವಾಳು ಖ್ಹಾರು ಆಶ್ಚರ್ಯಖಾದು. ");
INSERT INTO vaa_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","ಯೇಸು ಪಾಛೊ಼ ಫರೀನ್ ಡೋಣ್‌ಮ ದರ‍್ಯಾವ್‌ಮ ಹೈಕಡ್‌ಳಿ ಬಾಜು಼ಮ ಆಯೊ. ಹಿಜ್ಜಾ಼ ದರ‍್ಯಾವ್‍ನ ಕನಾರೆ ಅದ್ಮಿನಿ ಘಣಿ ಮೋಟಿ ಝೂ಼ಂಡ್‌ ಯೇಸುನ ಅಶ್‌ಪಿಶ್ ಐನ್ ಭರಾಯು. ");
INSERT INTO vaa_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","ತದೆ ಸಬಾಮಂದಿರ್‌ನೊ ಅದಿಕಾರಿ ಏಕ್‌ ಜ಼ಣೊ ಹಿಜ್ಜಾ಼ ಆಯೊ. ಇನು ನಾಮ್ ಯಾಯಿರ ಕರಿ. ಯೋ ಯೇಸುನ ದೇಖಿನ್, ಇನ ಗೋಡಾಪರ್ ಪಡಿನ್, ");
INSERT INTO vaa_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","“ಮಾರಿ ಅಡ್ಡಾಣಿ ಛೋ಼ಕ್ರಿ ಮರ್‌ವಾನ ಆಯಿ; ಯೊ ಅಛ್ಛಿಹುಯಿನ್ ಬಚಾ಼ನಖ್ಹಾಜೆ ದಯಕರಿನ್ ತೂ ಐನ್‌ ಇನಾಪರ್‌ ಹಾತ್‌ ಮ್ಹೇಲ್‌, ಕರಿ ಯೇಸುನ ಘಣು ಗಿಂಗೈಲಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","ತದೆ ಯೇಸು ಇನಜೋ಼ಡೆ ಗಯೊ, ಬಿಜು಼ ಅದ್ಮಿನಿ ಭೀಡ್‌ ಇನ ಅಶ್‌ಪಿಶ್ ಭರೈನ್ ಧಕೇಲ್‌ತುಹುಯಿನ್ ಇನ ಪೀಠೆ ಗಯು. ");
INSERT INTO vaa_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","ಹಿಜ್ಜಾ಼ ಭಾರ ವರಖ್ಹ್‌ಥು ಮುಟ್ನು ರೋಗ್‌ಥೀತೆ ಏಕ್‌ ತಯೇಡ ಥಿ. ");
INSERT INTO vaa_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","ಯೋ ಕೈಯೆಕ್ಕಿ ವೈದ್ಯಕನ ದೆಖಾಡಿತೋಬಿ ಘಣು ಲತಾಡ ಪಡಿರ‍್ಹೀಥಿ. ಥೂತೆ ಖ್ಹಾರು ಇನೆ ಖರ್ಚಿ ಕರಿತೋಬಿ ರೋಗ್‌ ಜಾ಼ಖ್ಹತ್ ಹುಯು ಪಣ್ಕಿ ಶಾತ್ಬಿ ಫಾಯಿದೊ ಕೋ ಹುಯುಥೂನಿ. ");
INSERT INTO vaa_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","ಯೋ ತಯೇಡ ಯೇಸುನಿ ಬಾರೇಮ ಖ್ಹಮ್‌ಜಿನ್‌, “ಮೇ ಯೇಸುನ ಲುಂಗ್ಡಾನ ಛೀಮೀತೊ ಬಶ್‌, ಮನ ಅಛ್ಛು಼ ಹುಯಿಜಾ಼ಶೆ” ಕರಿ ಸೋಚಿನ್, ಝೂ಼ಂಡ್‌ಮ ಪೀಠೇಥು ಐನ್ ಇನ ಲುಂಗ್ಡಾನ ಛೀಮಿ. ");
INSERT INTO vaa_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","ಛೀಮ್‌ತಾಸ್‌ ಇನ ಲ್ಹೊಯಿ ಝ಼ರಾನು ಭೀರಿಗಯು; ತದೆ ಇನೆ, ಇನ ಖ್ಹತವ್‌ಕರ್ತುಥೂತೆ ರೋಗ್‌ ನಿಕ್ಳಿಜೈ಼ನ್ ಅಛ್ಛು಼ ಹುಯಿಗಯು, ಕರಿ ಇನು ಯೋಸ್‌ ಮಾಲುಮ್‌ ಕರೀಲಿದಿ. ");
INSERT INTO vaa_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","ತದ್‌ನು ತದೇಸ್‌ ಯೇಸುನೆ ಇನಾಮಾಥು ಶಕತ್ ಗೈತೆ ಮಾಲುಮ್‌ ಕರಿಲೀನ್, ಝೂ಼ಂಡ್‌ಮ ಪೀಠೆ ಫರೀನ್, “ಮಾರ ಲುಂಗ್ಡಾನ ಛೀಮ್ಯೂತೆ ಕೋಣ್?” ಕರಿ ಪುಛಾ಼ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","ತದೆ ಇನ ಶಿಷ್ಯರ್‌ನೆ ಇನ, “ಅದ್ಮಿನಿ ಝೂ಼ಂಡಸ್ ತಾರಾಪರ್ ಪಡುಕರಾಸ್ ತೋಬಿ, ‘ಮನ ಛೀಮ್ಯೂತೆ ಕೋಣ್ ಕರಿ ಪುಛಾ಼ವಸ್ತೆ ಕಿಮ್?” ಕರಿ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","ಕತೋಬಿ ಯೇಸು ಇನ ಛೀಮ್ಯೂತೆ ಕೋಣ್ ಕರಿ ಅಶ್‌ಪಿಶ್ ದೇಖೂಸ್ ಕರ್ತೊಥೊ. ");
INSERT INTO vaa_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","ಯೋ ತಯೇಡ ಇನ ಹುಯೂತೆ ಮಾಲುಮ್‌ ಕರೀಲಿನ್‌, ಡರ್‌ಥಿ ಕಾಪ್ತಿಹುಯಿನ್‌ ಐನ್, ಯೇಸುನ ಗೋಡಾಪರ್ ಪಡೀನ್, ಖ್ಹಾರಿಸ್ ಖ್ಹಾಚಿನ ಬೋಲಿ. ");
INSERT INTO vaa_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","ತದೆ ಯೇಸುನೆ ಇನ, “ಛೋ಼ರಿ, ತಾರಿ ವಿಶ್ವಾಸ್‌ಥೀಸ್ ತುನ ಅಛ್ಛು಼ ಹುಯೂತೆ. ಸಮಾಧಾನ್‌ಥಿ ಜಾ಼, ತುನ ಬಿಜು಼ ಪಾಛು಼ ಯೋ ರೋಗ್ ಖ್ಹತಾವ್‌ಶೆ ಕೊಯ್ನಿ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","ಯೇಸು ಹಿಜ್ಜಾ಼ ಬಿಜೂ಼ಬಿ ವಾತೆ ಬೋಲುಕರ್ತೊಥೋತೆ, ಎತ್ರಾಮ ಮಂದಿರ್‌ನು ಅದಿಕಾರಿ ಭಣಿವಾಳು ಹಿಜ್ಜಾ಼ ಐನ್, “ತಾರಿ ಛೋ಼ರಿ ಮರಿಗೈ. ಅಜು಼ ಗುರುನ ಖ್ಹತಾವ್ ನಕೊ?” ಕರಿ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","ಇವ್ಣೆ ಬೋಲ್ಯುತೆ ವಾತೆನ ಯೇಸುನೆ ಮಜು಼ರಸ್ ಕರ‍್ಯೊಕೊಂತೆ ಮಂದಿರ್‌ನು ಅದಿಕಾರಿನ, “ಡರ್‌ನಕೊ, ಖಲಿ ವಿಶ್ವಾಸ್ ರ‍್ಹವಾದೆ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","ಬಿಜು಼ ಯೇಸುನೆ ಪೇತ್ರ, ಯಾಕೋಬ್ ಅಜು಼ ಯಾಕೋಬನೊ ನ್ಹಾನೊ ಭೈ ಯೋಹಾನ ಅವ್ಣುನ ಮ್ಹೆಂದಿನ್ ಕಿನಾಬಿ ಇನ ಕೇಡೆ ಆವಾದಿದೊ ಕೊಯ್ನಿ. ");
INSERT INTO vaa_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","ಇವ್ಣೆ ಅದಿಕಾರಿನ ಘರೆ ಆಯತದೆ, ಹಿಜ್ಜಾ಼ ಅದ್ಮಿಖ್ಹಾರು ಚಿಕ್ರಾಣ್ ಮ್ಹೇಲುಕರಾತೆ ಬಿಜು಼ ಥೋಡು ಅದ್ಮಿ ರೊವಣ್‌ಝೋ಼ವಣ್ ಕರುಕರಾತೆ ಯೇಸುನೆ ದೇಖ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","ಯೇಸು ಮಹಿ ಜೈ಼ನ್‌, “ಶನ ತುಮೆ ಚಿಕ್ರಾಣ್ ಮ್ಹೇಲುಕರಾಸ್ತೆ, ರೋವ್‌ಕರಾಸ್ತೆ? ಛೋ಼ಕ್ರಿ ಮರಿಕೊಯ್ನಿ, ಖ್ಹುತೀಸ್!” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","ಇವ್ಣೆ ಯೇಸುನ ದೇಖಿನ್ ನಕ್ಲೆ ಕರ‍್ಯು, ಇನಾಖ್ಹಾಜೆ ಯೇಸುನೆ ಖ್ಹಾರಾನ ಭಾರ್‌ ಮೋಕ್ಲೀನ್, ಯೋ ಛೋ಼ಕ್ರಿನ ಆಯ-ಬಾನ ಬಿಜು಼ ಇನ ತೀನ್ ಜ಼ಣ ಶಿಷ್ಯರ್‌ನ ಬುಲೈಲಿನ್ ಛೋ಼ಕ್ರಿ ಥೀತೆ ಹಿಜ್ಜಾ಼ಗಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","ಯೇಸುನೆ ಯೋ ಛೋ಼ಕ್ರಿನೊ ಹಾತ್ ಧರೀನ್, “ತಲಿಥಾಕೂಮ್” ಕರಿ ಬೋಲ್ಯೊ. ಇಮ್‌ ಕತೊ “ಅಡ್ಡಾಣಿ ಛೋ಼ಕ್ರಿ, ಮೇ ತುನ ಬೋಲುಕರುಸ್ ಉಪ್ಪರ್ ಉಟ್” ಕರಿ. ");
INSERT INTO vaa_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","ತದ್‌ನು ತದೇಸ್‌ ಯೋ ಛೋ಼ಕ್ರಿ ಉಠೀನ್ ಹೈಕಡ್‌ ಹೀಕಡ್‌ ಚಾ಼ಲಾಲಗಿ. ಯೋ ಭಾರ ವರಖ್ಹ್‌ನಿ ಹುಯಿರ‍್ಹೀಥಿ. ಅಮ್ ಹುವಾನು ದೇಖಿನ್ ಇವ್ಣೆ ಘಣು ಆಶ್ಚರ್ಯಖಾದು. ");
INSERT INTO vaa_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","ಯೇಸುನೆ ಇವ್ಣುನ, ಆ ಕಿನಾಬಿ ನಾ ಮಾಲುಮ್ ಪಡ್ಣು ಕರಿ ಘಣು ಝೇತೈನ್‌, “ಆ ಛೋ಼ಕ್ರಿನ ಖಾಣು ಖಡಾವೊ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","ಯೇಸು ಹಿಜ್ಜಾ಼ಥೊ ನಿಕ್ಳಿನ್ ಇನ ಗಾಮೆ ಗಯೊ, ಇನ ಶಿಷ್ಯರ್‌ಬಿ ಇನ ಪೀಠೆ ಗಯ. ");
INSERT INTO vaa_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","ಸಬ್ಬತ್‌ ದನ್ ಆವಾದಿನ್ ಯೇಸು ಸಬೆ ಭರಾವಾನು ಮಂದಿರ್‌ಮ ಜೈ಼ನ್‌, ದೇವ್ನಿ ವಚನ್ ಬೋಲಿ ದೆವಾನಿಕ್‌ಳ್ಯೊ. ಹಿಜ್ಜಾ಼ ಘಣು ಅದ್ಮಿಥು; ಇವ್ಣೆ ಇನಿ ವಾತೆ ಖ್ಹಮ್‌ಜಿನ್‌ ಘಣು ಆಶ್ಚರ್ಯಹುಯಿನ್, “ಆ ಖ್ಹಾರಿ ವಾತೆ ಅನ ಕಿಜ್ಜಾ಼ಥಿ ಮಳಿ? ಅನ ಅಮ್ನಿ ಗ್ಯಾನ್ ಕಿಜ್ಜಾ಼ಥಿ ಮಳಿ? ಅನ ಅದ್ಭುತ್‌ಖ್ಹಾರು ಕರಾನ ಶಕತ್ ಕಿಜ್ಜಾ಼ಥಿ ಆಯಿ?” ");
INSERT INTO vaa_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","ಆ ಅದ್ಮಿತೊ ಖೋಡ್‌ಶಾನು ಖ್ಹಾಮನ್‌ ಕರಾವಾಳೊನಿ, ಆ ಮರಿಯನೊ ಛಿಯ್ಯೋನಿ, ಯಾಕೋಬ್, ಯೋಸೆ, ಯೂದ ಅಜು಼ ಸೀಮೋನ್ನೊ ಮೋಟೊ ಭೈನಿ? ಅಜು಼ ಅನಿ ಭೇನೆಬಿ ಹಾ಼ಸ್‌ ರ‍್ಹೇಸ್‌ನಿ?” ಕರಿ ಬೋಲಿನ್ ಯೇಸುನ ಝಿಟ್ಕಾರ‍್ಯು. ");
INSERT INTO vaa_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","ತದೆ ಯೇಸುನೆ ಇವ್ಣುನ, “ಪ್ರವಾದಿಯೇನ ಬಿಜ಼ ಖ್ಹಾರ ಗಾಮ್ಮ ಮರ್ಯಾದಿ ದೇಸ್, ಕತೋಬಿ ಇನು ಶೊಂತ್‌ ಗಾಮ್ಮ, ಶೊಂತ್‌ ಅದ್ಮಿಮ ಅಜು಼ ಶೊಂತ್‌ ಘರ್‌ಮ ಇನ ಮರ್ಯಾದಿ ಕೋ ದೇಯ್ನಿ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","ಯೇಸುನೆ ಹಿಜ್ಜಾ಼ ರೋಗ್‍ವಾಳ ಥೋಡ ಅದ್ಮಿಪರ್ ಹಾತ್‌ ಮ್ಹೇಲಿನ್ ಅಛ್ಛು಼ ಕರಾನು ಕಾಹೆತೆ ಬಿಜು಼ ಶನೂಬಿ ಅದ್ಭುತ್‌ಕಾಮ್ನ ಕರಾನ ಕೋ ಹುಯೂನಿ. ");
INSERT INTO vaa_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","ಹಿಜ಼್ಜಾನ ಅದ್ಮಿಮ ವಿಶ್ವಾಸ್‌ಕೊಂತೆ ದೇಖಿನ್‌, ಯೇಸುನೆ ಘಣು ಆಶ್ಚರ್ಯಖಾದೊ. ಬಾದ್‌ಮ ಯೇಸು ಅಶ್‌ಪೀಶ್‌ನ ಗಾಮೆ ಜೈ಼ನ್, ದೇವ್ನಿ ವಚನ್ ಬೋಲಿದೆವಾನಿಕ್‍ಳ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","ಅಜು಼ ಭಾರ ಜ಼ಣ ಶಿಷ್ಯರ್‌ನ ಏಕ್‌ದಮ್ ಬುಲೈನ್, ಇವ್ಣುನ ಭೂತ್‌ಖ್ಹಾರು ಕಾಡಾನ ಅದಿಕಾರ್ ದಿದೊ, ಬೆಬ್ಬೆ ಜ಼ಣ ಕರಿನ್‌ ಮೋಕ್‌ಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","ಯೇಸುನೆ ಇವ್ಣುನ, “ಲಠ್ಠೊ ಮ್ಹೆಂದಿನ್ ಶಾತ್ಬಿ ನಕೊ ಲೀಜಾ಼ವೊ, ರೋಟೊ ರ‍್ಹವೊ, ಝೋ಼ಳಿ ರ‍್ಹವೊ, ಚ಼ಂಚಿಮ ಪೈಶಾ ರ‍್ಹವೊ ನಕೊ ಲೀಜಾ಼ವೊ. ");
INSERT INTO vaa_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","ಚಪ್ಲೆ ಘಾಲಿಲೆವೊ, ಅಜು಼ ಪೇರ‍್ಹಿರಾಖ್ಯಸ್ತೆ ಕುಡ್‌ತೂಸ್‌ ಬಶ್‌, ಬಿಜೇಕ್ ಕುಡ್‌ತು ನಕೊ ಲೀಜಾ಼ವೊ” ಕರಿ ಹುಕುಮ್‌ ದಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","ಎತ್ರೇಸ್ ಕಾಹೆತೆ ಯೇಸುನೆ ಇವ್ಣುನ, “ತುಮೂನ ಖೆವ ಘರ್‌ಮ ಬುಲೈಲೇಸ್ಕಿ, ಯೋ ಝ಼ಗೊ ಮ್ಹೇಲಿನ್‌ ಜಾ಼ವಾಲಗೂಬಿ ಯೋಸ್‌ ಘರ್‌ಮ ರ‍್ಹವಾಕರೊ. ");
INSERT INTO vaa_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","ಅಜು಼ ಕೆವ್ಹಾಬಿ ಝ಼ಗೊವಾಳು ತುಮೂನ ನಾ ಬುಲೈಲಿದುತೊ ಅಜು಼ ತುಮಾರಿ ವಾತೆನ ನಾ ಖ್ಹಮ್‌ಜುತೊ, ಯೋ ಝ಼ಗೋಥು ನಿಕ್ಳಿ ಜಾ಼ವೊ ಅಜು಼ ತುಮಾರ ಗೋಡಾನ ಲಾಗ್ಯುತೆ ಧೂಳ್‌ನ ಝ಼ಟ್‌ಕಿ ದೆವೊ. ಆ ಇವ್ಣುನ ಝೇತಾವನು ಸಾಕ್ಷಿ ಹುಯಿರ‍್ಹಿಶೆ!” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","ಬಾದ್‌ಮ ಇವ್ಣೆ ಹಿಜ್ಜಾ಼ಥು ಜೈ಼ನ್‌, ಅದ್ಮಿಖ್ಹಾರನ, “ಪಾಪ್ ಕರಾನು ಮ್ಹೇಲಿನ್ ದೇವ್ ಭಣಿ ಫರೊ” ಕರಿ ದೇವ್ನಿ ವಾತೆನ ಬೋಲಿವತಾಳ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","ಇವ್ಣೆ ಘಣು ಭೂತ್‌ಖ್ಹಾರು ಕಾಡ್ಯು ಅಜು಼ ರೋಗ್‍ವಾಳ ಘಣ ಅದ್ಮಿನ ತೇಲ್ ಲಗಾಡಿನ್ ಅಛ್ಛು಼ಕರ‍್ಯು. ");
INSERT INTO vaa_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","ಅಜು಼ ಹೆರೋದ ರಾಜಾ಼ನೆ ಯೇಸುನಿ ಬಾರೇಮ ಖ್ಹಮ್‌ಜೊ಼, ಶನಕತೊ ಯೇಸುನು ನಾಮ್ ಖ್ಹಾರಿ ಬಾಜು಼ಮ ಫೈಲಿಗಯುಥು. ಥೋಡು ಅದ್ಮಿ ಯೇಸುನಿ ಬಾರೇಮ, “ಬ್ಯಾಪ್ತಿಸ್ಮದ್ಯವಾಳೊ ಯೋಹಾನಸ್‌ ಪಾಛೊ಼ ಜಿವ್ತೊಹುಯಿನ್ ಐರ‍್ಹೋಸ್! ಇನಖ್ಹಾಜೇಸ್ ಮೋಟು ಅದ್ಭುತ್ ಕರಾನು ಶಕತ್ ಯೇಸುಮ ಛಾ಼ತೆ” ಕರಿ ಬೋಲ್ತುಥು. ");
INSERT INTO vaa_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","ಥೋಡು ಜ಼ಣು, “ಯೋ ಎಲೀಯ” ಕರಿ, ಬಿಜು಼ ಥೋಡು ಜ಼ಣು, “ಘಣ ವರಖ್ಹ್‌ನ ಪೀಠೆ ಥೂತೆ ಪ್ರವಾದೀನಿ ಘೋಣಿ ಆಬಿ ಏಕ್‌ ಪ್ರವಾದಿ ಹುಯಿರ‍್ಹೋಸ್’ ಕರಿ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","ಕತೋಬಿ ಹೆರೋದನೆ ಆ ಖ್ಹಾರಿ ವಾತೆನ ಖ್ಹಮ್‌ಜಿನ್‌, “ಮೇ ಮುಡ್‌ಕ್ಯು ಕತ್ರಾಯೊತೆ ಯೋಹಾನಸ್‌ ಆ, ಪಾಛೊ಼ ಜಿವ್ತೊಹುಯಿನ್ ಐರ‍್ಹೋಸ್!” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","ಹೆರೋದನೆ, ಇನೆ ರಾಖಿರಾಖ್ಯೊಥೋತೆ ಹೆರೋದ್ಯನಖ್ಹಾಜೆ ಯೋಹಾನ್ನ ಧರೈನ್, ಇನ ಜೇಲ್‌ಮ ಕೋಂಡಿ ಘಲೈರಾಖ್ಯೊಥೊ. ಯೋ ಹೆರೋದ್ಯ ಹೆರೋದನೊ ಭೈ ಫಿಲಿಪ್ಫನಿ ಬಾವಣ್‍. ");
INSERT INTO vaa_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","ಬ್ಯಾಪ್ತಿಸ್ಮ ದ್ಯವಾಳೊ ಯೋಹಾನ ಹೆರೋದಾನ, “ತೂ ತಾರ ಭೈನಿ ಬಾಯ್ಕೊನ ರಾಖಿರಾಖ್ಯೋತೆ ನಿಯಮ್‌ಕಾಹೆ!” ಕರಿ ಬೋಲ್ತೊರ‍್ಹೇತೋಥೊ. ");
INSERT INTO vaa_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","ಅನಖ್ಹಾಜೆ ಹೆರೋದ್ಯಬಿ ಯೋಹಾನಪರ್ ದಾವೊ ರಾಖಿನ್, ಇನ ಮರೈನಾಕ್ಣು ಕರಿ ಕೆತ್ರು ಕರಿತೋಬಿ ಇನೊ ಹಾತ್‌ ಕೋ ಹುಯುನಿ. ");
INSERT INTO vaa_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","ಹೆರೋದನ ಯೋಹಾನಕತೊ ಡರ್‌ ಥೊ ಶನಕತೊ, ಯೋಹಾನ ನೀತಿವಾಳೊಕರೀಬಿ ಅಜು಼ ಪವಿತ್ರ್‌ ಅದ್ಮಿಕರಿ ಇನ ಮಾಲುಮ್‌ ಥು, ಇನಾಖ್ಹಾಜೆ ಇನ ಜ಼ತನ್‌ಥಿ ರಾಖಿರಾಖ್ಯೋಥೊ. ಅಜು಼ ಯೋಹಾನ ಬೋಲಾತೆ ವಾತ್ನ ಖ್ಹಮ್‌ಜೊತೊ, ಇನ ದಿಲ್ಮ ಕಲಾವ್ಣಿ ಹುಯುತೋಬಿ, ಇನಿ ವಾತೆನ ಖ್ಹುಶಿಥಿ ಖ್ಹಮಜ಼್‌ತೋಥೊ. ");
INSERT INTO vaa_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","ಹೆರೋದ್ಯನೆ ಸೋಚಿರಾಖಿಥೀತೆ ವಖ್ಹತ್ ಆಯಿ. ಕಿಮ್‌ಕತೊ ಹೆರೋದನೊ ಪೈದಾ ಹುಯೋತೆ ದನ್ ಆಯೊ, ಯೋ ದನ್ಮ ಇನೆ ಖ್ಹಾರ ಅದಿಕಾರ್‌ಮ ರ‍್ಹವಾಳ ಶಾಣಾವ್ನ ಅಜು಼ ಇನು ದಂಡ್‌-ದಳವಾಯಿನ ಚ಼ಲಾವವಾಳ ಮೋಟಾವ್ನ, ಅಜು಼ ಗಲಿಲಾಯ ತಬರ್‌ಖಾನು ಧನ್‌-ದೌಲತ್‌ವಾಳ ಗಲ್‌ಢಾವ್‌ನ ಖ್ಹಾಜೆ ಮಿಝ಼್‌ವಾನ್ ಪಿಕಾಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","ತದೆ ಹೆರೋದ್ಯನಿ ಛೋ಼ರಿ ಮಹಿ ಅಯಿನ್ ಖೇಲಿನ್, ಹೆರೋದನಾಬಿ ಇನ ಜೋ಼ಡ್ಮ ಖಾಣನ ಬೆಠುಥೂತೆ ಖ್ಹಾರಾವ್‌ನ ಖ್ಹುಶಿಕರಿ. ತದೆ ರಾಜಾ಼ನೆ ಯೋ ಛೋ಼ಕ್ರಿನ, “ತುನ ಶಾತ್‌ ಹೋಣು ಬೋಲ್?‌ ತುನ ಶಾತ್ ಹೋಣುಕತೋಬಿ ದೆವುಸ್” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","ಇನೆ ಘಣಿ ಶಪತ್ ಲೀನ್, “ತೂ ಶಾತ್ ಬೋಲಿಲಿದಿತೋಬಿ ದೆವುಸ್ ಕರಿ ವಾತ್ ದೆವ್‍ಕರೂಸ್, ಮಾರ ರಾಜ್ಯಮಾಥು ಆಧು ರಾಜ್ಯನ ಮಾಂಗಿಲಿದಿತೋಬಿ ತುನ ದೆವುಸ್‌” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","ತದೆ ಯೋ ಛೋ಼ಕ್ರಿ ಭಾರ್‌ ಇನಿ ಆಯಕನ ಜೈ಼ನ್‌, “ಮೇ ಶಾತ್‌ ಮಾಂಗಿಲೆವ್?” ಕರಿ ಪುಛೈ಼. ತದೆ ಇನಿ ಆಯನೆ, “ಬ್ಯಾಪ್ತಿಸ್ಮದ್ಯವಾಳೊ ಯೋಹಾನನು ಮುಡ್‌ಕ್ಯು ಮಾಂಗಿಲೆ” ಕರಿ ಬೋಲಿ. ");
INSERT INTO vaa_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","ಇನಿ ಆಯ ಇಮ್‌ ಬೋಲ್ತಾಸ್‌ನ, ಒಗ್ಗಿಸ್‌ಮ ಯೋ ರಾಜ಼ಕನ ಐನ್, “ಹಮ್ಕೆಸ್‌ ಬ್ಯಾಪ್ತಿಸ್ಮದ್ಯವಾಳೊ ಯೋಹಾನನು ಮುಡ್‌ಕ್ಯು ಪತ್ತರ್‌ಮ ಮನ ಮಂಗೈನ್ ದೆ! ಯೋಸ್ ಮಾರಿ ಬಿಂತಿ” ಕರಿ ಬೋಲಿ. ");
INSERT INTO vaa_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","ಅನೇಥಿ ಹೆರೋದ ರಾಜಾ಼ನ ಘಣು ದುಖ್ ಹುಯು, ಕತೋಬಿ ಅಖ್ಖಾನ ಖ್ಹಾಮೆ ಇನೆ ವಾಗ್ದಾನ್‌ ದೀರಾಖ್ಯೊಥೋತೆ ಇನಖ್ಹಾಜೆ, ಹೆರೋದ್ಯನಿ ಛೋ಼ರಿನೆ ಬೋಲಿತೆ ಇನ ಕಾಡಾನ ಕೋ ಹುಯುನಿ. ");
INSERT INTO vaa_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","ಅನಾಖ್ಹಾಜೆ ರಾಜಾ಼ನೆ ಒಗ್ಗಿಸ್‌ಮ ಕಾವ್ಲಿಕರಾವಾಳ ಶಿಪಾಯಿನ, ಜೇಲ್‌ನ ಜೈ಼ನ್‌ ಯೋಹಾನನು ಮುಡ್‌ಕ್ಯು ಕತ್ರಿಲೀನ್ ಆವಾನ ಹುಕುಮ್‌ ದೀನ್ ಮೋಕ್‌ಲ್ಯೊ. ತದೆ ಇನೆ ಯೋಹಾನ್ನ ಕೋಂಡಿ ಘಾಲಿರಾಖ್ಯುಥೂತೆ ಹಿಜ್ಜಾ಼ಜೈ಼ನ್, ಇನು ಮುಡ್‌ಕ್ಯು ಕತ್ರೀನ್, ");
INSERT INTO vaa_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","ಇನ ಪತ್ತರ್‌ಮ ಲೈನ್‌, ಯೋ ಛೋ಼ಕ್ರಿನ ದಿದು. ಇನೆ ಯೋ ಮುಡ್‌ಕ್ಯಾನ ಇನಿ ಆಯನ ದಿದಿ. ");
INSERT INTO vaa_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","ಯೋಹಾನನು ಶಿಷ್ಯರ್‌ ಅನಿ ಬಾರೇಮ ಖ್ಹಮ್‌ಜಿನ್‌, ಹಿಜ್ಜಾ಼ ಐನ್, ಯೋಹಾನನು ಮುರ್ದು ಪಳ್ಳಿಜೈ಼ನ್‌, ಮಖ್ಹಾಣ್ಯನಿ ಘವಿಮ ಘಾಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","ಬಾದ್‌ಮ ಅಪೊಸ್ತಲರ್ ಖ್ಹಾರು ಯೇಸುಕನ ಪಾಛು಼ಫರಿ ಐನ್ ಮಳ್ಯು. ತದೆ ಇವ್ಣೆ ಅದ್ಮಿಮ ಕರ‍್ಯುತೆ ಅಜು಼ ಬೋಲಿದಿದೂತೆ ಖ್ಹಾರಸ್ನ ಯೇಸುನ ಖ್ಹಾಮ್ಣೆ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","ತದೆ ಯೇಸುನೆ ಇವ್ಣುನ, “ಖಲಿ ತುಮೆ ಮಾರ ಜೋ಼ಡೆ ಉಜ್ಜಾ಼ಡಿ ಝ಼ಗೋಪರ್‌ ಐನ್, ಅರಾಮ್‌ ಕರಿಲೆವೊ” ಕರಿ ಬೋಲ್ಯೊ. ಶನಕತೊ ಘಣು ಅದ್ಮಿ ಹಿಜ್ಜಾ಼ ಆವಾನು ಜಾ಼ವಾನು ಕರುಕರ್ತುಥೂತೆ ಇನಾಖ್ಹಾಜೆ, ಯೇಸುನಾಬಿ ಇನ ಶಿಷ್ಯರ್‌ನ ಖಾಣು ಖಾವನಿಬಿ ವಖ್ಹತ್ ಕೋ ಥೀನಿ. ");
INSERT INTO vaa_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","ಇನಾಖ್ಹಾಜೆ ಇವ್ಣೆ ಡೋಣ್‌ಮ ಬೇಶಿನ್ ಉಜ್ಜಾ಼ಡಿ ಝ಼ಗೋಪರ್‌ ಗಯ. ");
INSERT INTO vaa_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","ಇವ್ಣೆ ವಳ್ಯುಜಾ಼ತುಥೂತೆ ಘಣ ಅದ್ಮಿನೆ ದೇಖಿನ್‌, ಯೇಸುಬಿ ಇನು ಶಿಷ್ಯರ್‌ ಕರಿ ಖ್ಹಣೇದ್ ಧರ‍್ಯು. ತದೆ ಖ್ಹಾರ ಗಾಮ್‌ಥು ಅದ್ಮಿಖ್ಹಾರು ವಾಟ್‌ಧರಿ ನಾಖ್ಹ್‌ತುಹುಯಿನ್, ಇವ್ಣೆಥಿಬಿ ಅಗಾಡಿ ಯೋ ಝ಼ಗೋಪರ್‌ ಆಯು. ");
INSERT INTO vaa_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","ಯೇಸು ಹಿಜ್ಜಾ಼ ಐನ್ ಡೋಣ್‌ಪರ್‌ಥೊ ಉತ್ರಿನ್, ಘಣು ಅದ್ಮಿನಿ ಭೀಡ್ ಟಿವವ್‌ಕರ್‌ಥೂತೆ ದೇಖಿನ್‌, ಇವ್ಣಾಪರ್ ಗೋರ್‌ಖೈನ್, “ಅವ್ಣೆ ಕುರುಬಕೊಂತೆ ಮ್ಹೇಂಢವ್‌ನಿ ಘೊಣಿ ಛಾ಼ನಿ” ಕರಿ ಬೋಲಿನ್, ಇವ್ಣುನ ಘಣಿ ವಚನ್ ಬೋಲಿದಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","ಎತ್ರಾಸ್‌ಮ ಖ್ಹಾಂಜ಼್ ಹುಯಿಗುಥು. ಇನಟೇಕೆ ಯೇಸುನ ಶಿಷ್ಯರ್‌ ಇನಾಕನ ಐನ್, “ಆ ಉಜ್ಜಾ಼ಡಿ ಝ಼ಗೊ ಬಿಜು಼ ಖ್ಹಾಂಜ಼್‌ಬಿ ಹುಯಿಗಯು. ");
INSERT INTO vaa_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","ಅವ್ಣೆ ಖ್ಹಾರು ಅಶ್‌ಪಿಶ್‌ ಛಾ಼ತೆ ಗಾಮ್ಮ ಅಜು಼ ಖೇತರ್‌ಮ ಜೈ಼ನ್, ಇವ್ಣುನ ಖಾವನ ಶಾತ್‌ ಹೋಣುಕಿ ಯೋ ಲ್ಯವಾನಟೇಕೆ ಅವ್ಣುನ ಬೋಲಿಮೋಕಲ್‌” ಕರಿ ಬೋಲ್ಯ. ");
INSERT INTO vaa_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","ಇಮ್‌ ಬೋಲಾಖ್ಹತರ್ ಯೇಸುನೆ ಇವ್ಣುನ, “ತುಮೇಸ್ ಇವ್ಣುನ ಖಾವಾನ ಶಾತ್‌ತೋಬಿ ದೆವೊ” ಕರಿ ಬೋಲ್ಯೊ. ತದೆ ಇವ್ಣೆ, “ಹಮೆ ಜೈ಼ನ್, ಬೇಖ್ಹೊ ರೂಪಾನ ಕಾಖ್ಹ್‌ನು ರೋಟಾ ಲೀನ್‌, ಅವ್ಣುನ ಖಾವಾನ ದೇಣೂಕಿ ಶು?” ಕರಿ ಯೇಸುನ ಫುಛಾ಼ಯು. ");
INSERT INTO vaa_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","ತದೆ ಯೇಸುನೆ ಇವ್ಣುನ, “ತುಮಾರಕನ ಕೆತ್ರ ರೋಟಾ ಛಾ಼? ಕರಿ ಜೈ಼ನ್‌ ದೇಖೊ” ಕರಿ ಬೋಲ್ಯೊ. ಇವ್ಣೆ ಜೈ಼ನ್ ಮಾಲುಮ್ ಕರಿಲಿನ್, ಯೇಸುಕನ ಐನ್, “ಪಾಚ಼್ ರೋಟಾ ಅಜು಼ ಬೇ ಮಾಛ಼್‌ಲಾ ಛಾ಼” ಕರಿ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","ತದೆ ಯೇಸುನೆ ಇನ ಶಿಷ್ಯರ್‌ನ, “ತಮಾಮ್‌ ಅದ್ಮಿನ ಹರ‍್ಯಾ ಘಾಖ್ಹ್‌ಪರ್‌ ಝೂ಼ಂಡೆ-ಝೂ಼ಂಡೆ ಕರಿ ಬೆಖ್ಹಾಡೊ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","ತದೆ ಅದ್ಮಿಖ್ಹಾರು ಏಕ್‌-ಏಕ್‌ ಝೂ಼ಂಡ್‌ಮ ಖ್ಹೋ-ಖ್ಹೋ, ಅಡೈವಿಖ್ಹ್‌-ಅಡೈವಿಖ್ಹ್‌ ಜ಼ಣು ಶಾಲ್ ಹುಯಿನ್ ಬೇಶಿಗಯು. ");
INSERT INTO vaa_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","ಬಾದ್‌ಮ ಯೇಸುನೆ ಯೋ ಪಾಚ಼್ ರೋಟ ಬೇ ಮಾಛ಼್‌ಲಾನ ಪಾಡಿಲೀನ್, ಆಕಾಶ್‌ಭಣಿ ದೇಖಿನ್, ದೇವ್ನ ಧನ್ಯವಾದ್ ಕರಿನ್, ರೋಟಾವ್ನ ತೋಡಿನ್ ಅದ್ಮಿನ ವಾಟಪಾಡಿನ್ ದೆವೊ ಕರಿ ಇನ ಶಿಷ್ಯರ್‌ನ ದಿದೊ. ಬಿಜು಼ ಯೋ ಬೇ ಮಾಛ್ಲಾ಼ನಾಬಿ ಅಖ್ಖಾ ಅದ್ಮಿನ ವಾಟಪಡಾಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","ಇವ್ಣೆ ಖ್ಹಾರೂಸ್ ಪೇಟ್‌ಭರಿ ಖೈನ್ ಬಶ್‌ಹುಯು. ");
INSERT INTO vaa_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","ತದೆ ಶಿಷ್ಯರ್‌ನೆ ಉಭ್‌ರ‍್ಯುತೆ ರೋಟಾನ ಅಜು಼ ಮಾಛ಼್‌ಲಾನ ಟುಕ್ಡಾವ್‍ನ ಜ಼ಮಾಕರ್ತಖ್ಹತರ್‌ ಭಾರ ಟೋಕ್ರಾ ಭರಾಯು. ");
INSERT INTO vaa_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","ಖಾಣು ಖಾದುತೆ ಇನಾಮ ಪರ್ಖ್ಹಾ ಅದ್ಮಿಸ್‌ ಪಾಚ಼್ ಹಜಾ಼ರ್‌ಜ಼ಣು ಥೂ. ");
INSERT INTO vaa_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","ಅನ ಬಾದ್‌ಮ ಯೇಸುನೆ ಇನ ಶಿಷ್ಯರ್‌ನ, “ಮೇ ಆ ಅದ್ಮಿನಿ ಝೂ಼ಂಡ್‌ನ ಘರೆ ಬೋಲಿಮೋಕ್ಲಾನ ಮಹಿ, ತುಮೆ ಡೋಣ್‌ ಚ಼ಢೀನ್‌ ಮಾರೇಥಿ ಅಗಾಡಿ ಪಾರ್ಲಿ ಬಾಜು಼ಮ ಛಾ಼ತೆ ಬೆತ್ಸಾಯಿದ ಖ್ಹಯೇರ‍್ನ ಜಾ಼ವೊ” ಕರಿ ಜು಼ಲುಮ್‌ ಕರ‍್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","ಅದ್ಮಿನ ಮೋಕ್ಲಿದ್ಯವಾನ ಬಾದ್‌ಮ, ಯೇಸು ಪ್ರಾರ್ಥನೆ ಕರಾನಖ್ಹಾಜೆ ಪಹಡ್‌ಪರ್ ಗಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","ದನ್ ಡುಬಾನ ಬಾದ್‌ಮ, ಶಿಷ್ಯರ್‌ ಥಾತೆ ಡೋಣ್‌ ದರ‍್ಯಾವ್‍ನ ಇಚ಼್‌ಮ ಥು, ಕತೋಬಿ ಯೇಸು ಎಕ್ಲೋಸ್ ಕನಾರೆ ಥೊ. ");
INSERT INTO vaa_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","ಖ್ಹಾಮ್ಣೆನೊ ವಹಿರೊ ಜೋ಼ರೇಖ್ಹು ವಾಗುಕರ್ತೊಥೋತೆ ಇನಾಖ್ಹಾಜೆ, ಶಿಷ್ಯರ್‌ ಖ್ಹಾರು ಡೋಣ್ಣಾ ಖ್ಹಾಮ್ಣೆ ಲೀಜಾ಼ವಾನ ಕೋ ಹುವ್ವಾನಿತೆ ತರಪ್‌ಡುಕರ್ತುಥೂತೆ ಯೇಸುನೆ ದೇಖ್ಯೊ. ತದೆ ಕಮ್‌ಶಿಕಮ್ ವ್ಹಾಣ್‌ಖ್ಹತ್ರೆ ಚಾರ್‌ ಘಂಟಾ ಹುಯಿರ‍್ಹುಥು. ತದೆ ಯೇಸು ದರ‍್ಯಾವ್‌ಪರ್ ಚಾ಼ಲ್ತೊಹುಯಿನ್‌ ಇವ್ಣಭಣಿ ಐನ್, ಇವ್ಣುನ ಮ್ಹೆಂದಿನ್ ಖ್ಹಾಮ್ಣೆ ಜಾ಼ವ್ಣುಕರಿ ಥೊ. ");
INSERT INTO vaa_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","ಕತೋಬಿ ದರ‍್ಯಾವ್‌ಪರ್ ಚಾ಼ಲ್ತೊವಳ್ಯಾವಾತೆ ಯೇಸುನ ಇವ್ಣೆ ದೇಖಿನ್‌, ಭೂತ್‌ಕರಿ ಸೋಚಿನ್ ಜೋ಼ರೇಥಿ ಚಿಕ್ರಾಲಗ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","ಶನಕತೊ ಇವ್ಣೆ ಖ್ಹಾರು ಇನ ದೇಖಿನ್‌ ಘಬ್‌ರೈ ಗಯುಥು. ತದೆ ಒಗ್ಗಿಸ್‌ಮ ಯೇಸುನೆ ಇವ್ಣ ಜೋ಼ಡೆ ವಾತೆ ಬೋಲಿನ್ ಇವ್ಣುನ, “ಹಿಮ್ಮತ್‌ಥಿರ‍್ಹೆವೊ ಮೇಸ್, ಡರೊನಕೊ!” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","ಬಾದ್‌ಮ ಯೇಸು ಡೋಣ್‌ ಚ಼ಢೀನ್‌ ಇವ್ಣಾಕನ ಆಯೊ, ತದೆ ವಹಿರೊ ವಾಗಾನು ಭೀರಿಗಯು. ತದೆ ಶಿಷ್ಯರ್‌ ಖ್ಹಾರು ಘಣು ಆಶ್ಚರ್ಯಖಾದು. ");
INSERT INTO vaa_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","ಶನಕತೊ ಇವ್ಣೆ ಯೇಸುನೆ ಪಾಚ಼್ ರೋಟಾನ ಪಾಚ಼್ ಹಜಾ಼ರ್ ಅದ್ಮಿನ ಖಡಾಯೋತೆ ಇನಿ ಮತ್ಲಬ್‌ನ ಮಾಲುಮ್ ಕರ‍್ಯುಕೊಯ್ನಿ. ಇವ್ಣೊ ದಿಲ್‌ ಬಂಡೊ ಹುಯಿರ‍್ಹೋಥೊ. ");
INSERT INTO vaa_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","ಇವ್ಣೆ ದರ‍್ಯಾವ್‍ನ ಕಾಡಿನ್ ಗೆನೆಜರೇತ್‍ ತಬರ್‌ಖಾನ ಕನಾರೆ ಪೊಚಿನ್‌ ಡೋಣ್ಣಾ ಭಾಂದ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","ಇವ್ಣೆ ಡೋಣ್‌ಪರ್‌ಥು ಉತರ್‌ತಸ್ನ, ಹಿಜ್ಜಾ಼ನು ಅದ್ಮಿಖ್ಹಾರು ಯೇಸುನಿ ಖ್ಹಣೇದ್ ಧರ‍್ಯು. ");
INSERT INTO vaa_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","ತದೆ ಯೋ ತಬರ್‌ಖಾನು ಖ್ಹಾರು ಅದ್ಮಿ ನಾಖ್ಹ್‌ದಾಖ್ಹ್ ಕರ್ತುಹುಯಿನ್, ರೋಗ್‌ಮ ಪಡಿರ‍್ಹವಾಳ ಖ್ಹಾರಾವ್‌ನ ಬಿಛಾ಼ವ್ಣಿಮ ನಾಖಿಲಿನ್‌ ಯೇಸು ಕಿಜ್ಜಾ಼-ಕಿಜ್ಜಾ಼ ಛಾ಼ ಕರಿ ಖ್ಹಮ್‌ಜಾ಼ಸ್ಕಿ ಹಿಜ್ಜಾ಼-ಹಿಜ್ಜಾ಼ ಲೀನ್‌ ಆಯು. ");
INSERT INTO vaa_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","ಅಜು಼ ಯೇಸು ಖೆವ ಖ್ಹಯೇರ್‌ಮಾಬಿ, ಖೆವ ಗಾಮ್ಮಾಬಿ ನಾತೊ ಖೆವ ಖೇತರ್‌ಮಾಬಿ ಕತೊ ಕಿಜ಼್ಜಾ-ಕಿಜ಼್ಜಾ ಗಯೋಕಿ ಹಿಜ಼್ಜಾವಾಳು ರೋಗ್‌ರ‍್ಹವಾಳನ ಭಾರ್‌ ಬಜಾ಼ರ್‌ನಿ ಝ಼ಗೊ ಮ್ಹೇಲಿನ್ ಯೇಸುನ, “ತಾರು ಲುಂಗ್ಡಾನು ಕೋಣೊತೋಬಿ ಛೀಮಾನ ಮ್ಹೇಲಿದೆ” ಕರಿ ಇನ ಗಿಂಗೈಲಿದು. ಅಜು಼ ಇನ ಕೋಣ್-ಕೋಣ್ ಛೀಮ್ಯೂಕಿ ಇವ್ಣ ಖ್ಹಾರಾನೊ ರೋಗ್‌ ಅಛ್ಛು಼ ಹುಯಿಗಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","ಬಾದ್‌ಮ ಯೆರೂಸಲೇಮ್‌ಥು ಆಯುಹುಯು ಫರಿಸಾಯರ್‌ಬಿ, ಮೋಶೇನು ವಚನ್ ಶಿಕಾಡವಾಳು ಶಾಸ್ತ್ರೀಮ ಥೋಡು ಜ಼ಣು ಯೇಸುಕನ ಐನ್ ಅಶ್‌ಪಿಶ್‌ ಭರಾಯು. ");
INSERT INTO vaa_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","ತದೆ ಇವ್ಣೆ ಯೇಸುನು ಶಿಷ್ಯರ್‌ಮ ಥೋಡುಜ಼ಣು ಅಶುದ್ದ ಹಾಥ್ಥಿ ಕತೊ ಗುರುಗುರಬ್‌ಲ್ಯಥಿ ಚಾ಼ಲ್ತುಆಯುತೆ ಇಮ್‌ ಪರಿಸಾಯರ್ ಖ್ಹಾರು ಶಿಕಾಡ್ತುಥೂತೆ ಇಮ್‌, ಹಾತ್‌ ಧೋಯುಕೊಂತೆ ಖಾಣು ಖಾತಾನ ದೇಖ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","4","ಫರಿಸಾಯರ್ ಅಜು಼ ಯೆಹೂದ್ಯರ್‌ನ ಖ್ಹಾರುಜ಼ಣು, ಇವ್ಣ ಶಾಣವ್‌ಥಿ ಶಿಕ್ತು ಆಯುತೆ ಇಮ್‌, ಇವ್ಣೊ ಹಾತ್‌ ಬರೋಬರ್‌ನಿ ತರೀಕಾಥಿ ಧೊವಾಕೊಂತೆ ಖಾಣು ಕೋಖಾಯ್ನಿ. ಅಜು಼ ಬಜಾ಼ರೆ ಜೈ಼ನ್ ಆಯೂತೆ ಪಾಣಿ ಛಿಡ್ಕಿಲೇಯ್‌ ಕೊಂತೆ ಖಾಯಿಕೊಯ್ನಿ. ಅತ್ರೇಸ್ ಕಾಹೆತೆ ಇವ್ಣಾಮ ಗಿಳಾಖ್ಹ್, ಕಂಚ಼್‌ನೊತಾಂಬ್ಯೊ, ಹಂಡ್‌ಕು ಖ್ಹಾರು ಮಾಂಜಿನ್ ಧೊವಾನು ಅಜು಼ ಬಿಛಾ಼ವ್ಣಿನ ಧೊವಾನು, ಅಮ್ನು ಖ್ಹಾರು ಶಾಣಾವ್‌ಥಿ ಚಾ಼ಲ್ತು ಆಯುತೆ ಇನ ಬರೋಬರ್‌ಥಿ ಕರ್ತುಥು. ");
INSERT INTO vaa_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","ಇನಾಖ್ಹಾಜೆ ಫರಿಸಾಯರ್ ಅಜು಼ ಮೋಶೆನಿ ವಚನ್ ಶಿಕಾಡವಾಳು ಶಾಸ್ತ್ರಿಯೇನೆ ಯೇಸುನ, “ತಾರು ಶಿಷ್ಯರ್‌ ಶಾಣವ್‌ನೆ ಶಿಕಾಡ್ತು ಆಯುತೆ ಆದತ್‌ನ ಇಮ್‌ ಶನ ಕೋ ಕರಾನಿ? ಚಾ಼ಲ್ತು ಆಯೂತೆ ಇಮ್‌ ಹಾತ್‌ ಧೊವಾಕೊಂತೆ ಶುದ್ದಕೊಂತೆ ಹಾತೇಖ್ಹು ಶನ ಖಾಣು ಖಾಸ್‌?” ಕರಿ ಫುಛಾ಼ಯು. ");
INSERT INTO vaa_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","ಇಮ್‌ ಬೋಲ್ತಾನ ಯೇಸುನೆ, “ತುಮೆ ಠಗಾರು, ತುಮಾರಿ ಬಾರೇಮ ಯೆಶಾಯ ಪ್ರವಾದಿನೆ ಬರೊಬರ್‌ಥೀಸ್‌ ಪ್ರವಾದ್‌ನೆ ಕರಿರಾಖ್ಯೋಸ್. ಯೋ ಶಾತ್‌ಕತೊ, ‘ದೇವ್ನೆ ಬೋಲ್ಯೋಕಿ, ‘ಆ ಅದ್ಮಿಖ್ಹಾರು ವಾತೇಥಿ ಮನ ಖ್ಹರಾವಸ್‌, ಕತೋಬಿ ಅವ್ಣೊ ದಿಲ್‌ ಮಾರೇಥಿ ದೂರ್ ಛಾ಼’ ");
INSERT INTO vaa_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","ಅದ್ಮಿನ ಖ್ಹೂಜ಼್‌ನಿತರ ಶಿಕಾಡ್ತು ಆಯೂತೆ ಇನಾಸ್ ದೇವ್ನಿ ಹುಕುಮ್‌ನಿಘೋಣಿ! ಬೋಲಿಶಿಕಾಡವಾಳ ಅವ್ಣೆ ಮಾರ ಖ್ಹಾಮೆ ಆರಾದನೆ ಕರಾನು ಕಾಮ್ನಕೊಯ್ನಿ’ ಕರಿ ಯೋ ವಾತೆ ಹುಯಿರ‍್ಹೀಸ್! ");
INSERT INTO vaa_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","“ತುಮೆ ದೇವ್ನಿ ಹುಕುಮ್‌ನ ಮ್ಹೇಲಿದಿನ್ ಅದ್ಮಿನೆ ಶಿಕಾಡ್ಯುತೆ ಇನ ಧರಿರಾಖ್ಯಾಸ್‌” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","ಯೇಸುನೆ ಬಿಜೂ಼ಬಿ ಇವ್ಣುನ, “ತುಮೆ ಕೆತ್ರೆ ಅಕ್ಲಿ ದೇಖೊ! ತುಮೆ ತುಮಾರಿ ಪದತ್ತಿನ ಪಾಡಿಚಾ಼ಲ್ನು ಕರಿ ದೇವ್ನೆ ದಿದೋತೆ ಹುಕುಮ್‌ನ ಕಾಡಿನಾಖಿದೆವೊಸ್‌ನಿ. ");
INSERT INTO vaa_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","‘ಆಯ-ಬಾನ ಮರ್ಯಾದಿ ದೇವ್ಣು ಕರಿ, ಅಜು಼ ಆಯನ ರ‍್ಹವೊ ಬಾನ ರ‍್ಹವೊ ಶಾಪ್ನ-ಶಬರ್‌ ದೆವಾಳಾನ ಮಾರಿನಾಖಿದೆವ್ಣು’ ಕರಿ ಮೋಶೆನೆ ಹುಕುಮ್‌ ದೀರಾಖ್ಯೊಸ್. ");
INSERT INTO vaa_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","ಕತೋಬಿ ತುಮಾರಮ ಕೋಣ್‌ತೋಬಿ ಏಕ್‌ ಜ಼ಣು ಇನ ಆಯ-ಬಾನ ಶಾತ್‌ತೋಬಿ ದೀನ್, ಮದತ್‌ಕರ್‌ನು ಕರಿ ರ‍್ಹೇಸ್ತೆ ಯೋ ಖ್ಹಾರು ‘ಕೊರ್ಬಾನ್’ ಕರಿನಾಖ್ಯೊ” ಕರಿ ಬೋಲಿಲಿದೊತೊ, ");
INSERT INTO vaa_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","ಯೋ ಅದ್ಮಿ ಇನ ಆಯನ ರ‍್ಹವೊ, ಬಾನ ರ‍್ಹವೊ ಬಿಜು಼ ಶಾತ್ಬಿ ದೇಕ್-ಭಾಲ್‌ ಕರ್ನುನಾತೆ ಇಮ್‌ ಭಾಮ್‌ಥಿ ಛು಼ಕಿಜಾ಼ಸ್. ");
INSERT INTO vaa_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","ಅಮ್ ತುಮೆ ಏಕ್‌ಥಿ-ಏಕ್‌ ಬೋಲಿದೇತಾಹುಯಿನ್ ದೇವ್ನಿ ಪದತ್ತಿನ ಮರ್ಯಾದಿಕೊಂತೆ ಇಮ್‌ ಕರೋಸ್. ಅತ್ರೇಸ್ ಕಾಹೆತೆ ಅಮ್ನು ಖ್ಹಾರು ಬಿಜೂ಼ಬಿ ಕೈಯೆಕ್ಕಿ ಕರೋಸ್” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","ಬಾದ್‌ಮ ಯೇಸುನೆ ಅದ್ಮಿನಿ ಝೂ಼ಂಡ್‌ನ ಪಾಛೊ಼ ಖನ್ನೆ ಬುಲೈನ್ ಇವ್ಣುನ, “ಖ್ಹಾರು ಕಾನ್‌ ಜೋ಼ಡಿನ್‌ ಮಾರಿ ವಾತೆನ ಖ್ಹಮ್‌ಜೊ಼, ಅಜು಼ ಪರ್ಖಿಲೆವೊ. ");
INSERT INTO vaa_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","ಭಾರ್‌ಥು ಮಹಿ ಜೈ಼ನ್‌ ಏಕ್‌ ಅದ್ಮಿನ ಪದತ್ತಿನಿಘೋಣಿ ಮೈಲುಕರಾನು ಏಕ್‌ಬಿ ಕೊಯ್ನಿ. ಕತೋಬಿ ಏಕ್‌ ಅದ್ಮಿನ ಮಹಿತು ಭಾರ್‌ ನಿಕ್ಳಾನುಸ್‌ ಇನ ಮೈಲುಬಣಾವಸ್‌” ");
INSERT INTO vaa_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","“ಖ್ಹಮ್‌ಜಾ಼ನ ಕಾನ್‌ ಉಶೇತೊ ಖ್ಹಮ್‌ಜಾ಼ದೆ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","ಬಾದ್‌ಮ ಯೇಸು ಖ್ಹಾರ ಅದ್ಮಿನ ಮ್ಹೆಂದಿನ್ ಘರ್‌ಮ ಆವಾದಿನ್, ಇನ ಶಿಷ್ಯರ್‌ನೆ ಯೋ ಮತ್ಲಬ್‌ಥಿ ಬೋಲ್ಯೊತೆ ವಾತೆನಿ ಬಾರೇಮ ಇನ ಫುಛಾ಼ಯು. ");
INSERT INTO vaa_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","ತದೆ ಯೇಸುನೆ ಇವ್ಣುನ, “ಬಿಜಾ಼ನಿ ಘೋಣಿ ತುಮುನಾಬಿ ಎತ್ರೆ ಮಾಲುಮ್‌ ಪಡಾಕೊಯ್ನಿಕಿ ಶು? ಭಾರ್‌ಥು ಖಾವಾನು ರಾಛು಼ ಅದ್ಮಿನ ಮಹಿ ಜೈ಼ನ್‌ ಇನ ಗಲೀಜ಼್ ಕರಾಕೊಯ್ನಿ, ಕರಿ ತುಮೂನ ಮಾಲುಮ್‌ ಪಡ್ಯುಕೊಯ್ನಿಕಿ ಶು? ");
INSERT INTO vaa_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","ಭಾರ್‌ಥು ಅದ್ಮಿನ ಮಹಿ ಜಾ಼ವಾನು ಖ್ಹಾರು ಇನ ದಿಲ್ಮ ಜಾ಼ಯಿಕೊಂತೆ, ಪೇಟ್‌ಮ ಜೈ಼ನ್‌ ಬಾದ್‌ಮ ಭಾರ್‌ಮ ನಿಕ್ಳಿಜಾ಼ಸ್, ಯೋ ಖ್ಹಾರು ಯೋ ಅದ್ಮಿನ ಗಲೀಜ಼್ ಕರಾಕೊಯ್ನಿ” ಕರಿ ಬೋಲ್ಯೊ. (ಅಮ್ ಬೋಲಾಥಿ, ಖಾವಾನು ಖ್ಹಾರುಸ್ ರಾಛು಼ ಶುದ್ದಕರಿ ಯೇಸುನೆ ವತಾಳಿದಿದೊ). ");
INSERT INTO vaa_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","ಯೇಸುನೆ ಬಿಜೂ಼ಬಿ ಇವ್ಣುನ, “ಏಕ್‌ ಅದ್ಮಿನ ಮಹಿತು ನಿಕ್ಳಾನುಸ್‌ ಯೋ ಅದ್ಮಿನ ಗಲೀಜ಼್ ಕರಾಸ್. ");
INSERT INTO vaa_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","ಮಹಿತು ಕತೊ ಅದ್ಮಿನ ದಿಲ್ನ ಮಹಿತು ಆವಾತೆ ಖರಾಬ್‌ಸೋಚ್‌, ಬಿಜೇಕ್‌ಜ಼ಣಿನ ಖ್ಹಂಗ್‌ಕರಾನು , ಚೋ಼ರಿ, ಖೂನ್‌ಕರಾನು, ");
INSERT INTO vaa_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","ವ್ಯಬಿಚಾರ್, ಪೈಶಾನಿ ಲಾಲಚ್‌, ಬಿಜಾ಼ನ ಖರಾಬ್ ಕರಾನು, ಠಗಾವಾನು, ಪಾಪೇಲಿಆದತ್‌, ಬಳಾಪೊ ಕರಾನು, ಗಾಳೆ ದ್ಯವಾನು, ಹಂಕಾರ್, ಝ಼ಲಕ್‌ಭರ್‍ಯಾನಿ ಘೋಣಿ ಕರಾನು, ಅಮ್ನು ಖ್ಹಾರು ಖರಾಬ್ ಖ್ಹಯಾಲ್ ಭಾರ್‌ ನಿಕ್ಳಾಸ್‌. ");
INSERT INTO vaa_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","ಅಮ್ನು ಖರಾಬ್ ಖ್ಹಾರು ಅದ್ಮಿನ ಮಹಿಥು ನಿಕ್ಳಿನ್, ಯೋ ಅದ್ಮಿನ ಗಲೀಜ಼್ ಕರಿದೇಸ್” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","ಹಿಜ್ಜಾ಼ಥೊ ಯೇಸು ನಿಕ್ಳಿನ್ ತೂರ್ ಕರಿ ಬೋಲಾನು ಖ್ಹಯೇರ‍್ನ ಖನ್ನೇನು ತಬರ್‌ಖಾನ ಗಯೊ. ಹಿಜ್ಜಾ಼ ಏಕ್‌ ಘರ್‌ಮ ಥೊ, ಯೋ ಹಿಜ್ಜಾ಼ ಛಾ಼ ಕರಿ ಕಿನಾಬಿ ನಾ ಮಾಲುಮ್‌ಪಡ್ಣು ಕರಿ ಥೊ, ಕತೋಬಿ ಯೋ ಮಾಲುಮ್‌ ಪಡಾಕೊಂತೆ ರ‍್ಹವಾನ ಕೋ ಹುಯುನಿ. ‌ ");
INSERT INTO vaa_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","ಒಗ್ಗಿಸ್‌ಮ ಏಕ್‌ ತಯೇಡನೆ ಯೇಸು ಹಾ ಛಾ಼ ಕರಿ ಖ್ಹಮ್‌ಜಿನ್‌, ಐನ್ ಯೇಸುನ ಗೋಡಾನ ಖ್ಹಾಮ್ಣೆ ಪಡಿ. ಇನಿ ಛೋ಼ರಿನ ಭೂತ್ ಧರಿರಾಖ್ಯುಥು. ");
INSERT INTO vaa_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","ಯೋ ತಯೇಡ ಪರೈ ಜಾ಼ತ್‌ವಾಳಿ ಹುಯಿರ‍್ಹೀಥಿ. ಯೋ ಸಿರಿಯ ತಬರ್‌ಖಾನು ಸುರೋಪೊಯಿನಿಕ್ಯಮ ಪೈದಹುಯಿತೆ ಏಕ್‌ ಗ್ರೀಕ್‌ವಾಳಿ ಹುಯಿರ‍್ಹೀಥಿ. ಯೋ ತಯೇಡ ಇನಿ ಛೋ಼ರಿನ ಧರಿರಾಖ್ಯುಥೂತೆ ಭೂತ್‌ ಕಾಡ್ಣು, ಕರಿ ಯೇಸುನ ಗಿಂಗಾವಲಗಿ. ");
INSERT INTO vaa_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","ತದೆ ಯೇಸುನೆ ಇನ, “ಪಹಿಲೆ ಲಡ್ಕಾ ಪೇಟ್‌ಭರೀನ್‌ ಖವಾದೆ. ಲಡ್ಕಾ ಖಾವಾನು ರೋಟಾವ್ನ ಪಾಡೀನ್, ಕುತ್‌ರ‍್ಯಾನ ಚೆಲ್ಕಾನ ನಾಖಾನು ಬರೋಬರ್‌ಕೊಯ್ನಿ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","ತದೆ ಯೋ ತಯೇಡಾನೆ, “ಹೋಲಾ ಪ್ರಭು, ತೋಬಿ ಲಡ್ಕಾ ಖಾಣು ಖವಾನಿ ಮೇಜ್‌ಪರ್‌ಥು ನಾಖಿದೇಯಿತೆ ರೋಟಾನ ಟುಕ್ಡಾನ ಹೇಟ್‌ ರ‍್ಹೇಯ್ತೆ ಕುತ್‌ರ‍್ಯಾನ ಚೆಲ್ಕ ಖಾಸ್ನಿ” ಕರಿ ಬೋಲಖ್ಹತರ್‌, ");
INSERT INTO vaa_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","ಯೇಸುನೆ ಇನ, “ತುನೆ ಆ ವಾತ್ ಬೋಲಿತೆ ಇನಖ್ಹಾಜೆ, ತಾರಿ ಛೋ಼ರಿನ ಧರಿರಾಖ್ಯುಥೂತೆ ಭೂತ್‌ ಮ್ಹೆಂದಿದು! ಘರೆ ಜಾ಼” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","ಯೋ ಇನ ಘರೆ ಜೈ಼ನ್‌ ದೇಖಾತೊ ಇನಿ ಛೋ಼ರಿ ಬಿಛಾ಼ವ್ಣಿಪರ್ ಅರಾಮ್‌ಥಿ ಖ್ಹುತೀಥಿ; ಇನ ಧರಿರಾಖ್ಯುಥೂತೆ ಭೂತ್‌ ನಿಕ್ಳಿ ಗಯುಥು. ");
INSERT INTO vaa_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","ಬಾದ್‌ಮ ಯೇಸು ಯೋ ತೂರ್‌ನ ಖನ್ನೇನು ತಬರ್‌ಖಾನ ಮ್ಹೇಲಿನ್ ಸೀದೋನ್‌ನ ವಾಟೆಕರಿ ದೆಕಪೊಲಿ ತಬರ್‌ಖಾಮಾಕರಿ ಹುಯಿನ್ ಗಲಿಲಾಯ ದರ‍್ಯಾವ್‌ಕನ ಆಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","ತದೆ ಥೋಡು ಅದ್ಮಿನೆ ಭೈರೂಬಿ ತೊತ್‌ಳ್ಯು ಹುಯಿರ‍್ಹುಥೂತೆ ಏಕ್‌ ಜ಼ಣಾನ ಯೇಸುಕನ ಬುಲೈಲಾಯಿನ್‌, “ಅನ ಉಪ್ಪರ್ ತಾರೊ ಹಾತ್‌ ಮ್ಹೇಲ್‌” ಕರಿ ಇನ ಗಿಂಗೈಲಿದು. ");
INSERT INTO vaa_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","ತದೆ ಯೇಸುನೆ ಇನ, ಅದ್ಮಿನಿ ಭೀಡ್‌ಮಾಥು ಏಕ್‌ ಬಾಜು಼ಮ ಬುಲೈಲಿಜೈ಼ನ್, ಯೇಸುನೆ ಇನಿ ಅಂಗ್‌ಳಿನ ಯೋ ಅದ್ಮಿನ ಕಾನ್‌ಮ ಘಾಲಿನ್, ಥೂಕಿನ್, ಇನಿ ಜೀಬ್‌ನ ಲಗಾಡಿನ್ ");
INSERT INTO vaa_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","ಉಪ್ಪರ್ ಆಕಾಶ್‌ಭಣಿ ದೇಖಿನ್‌, ಜೋ಼ರೇಥಿ ದಮ್‌ ಲೀಮ್ಹೇಲಿನ್‌, ಇನ ‘ಎಪ್ಫಥಾ’ ಕರಿ ಬೋಲ್ಯೊ, ಅಮ್‌ಕತೊ “ಉಖ್‌ಡೈ ಜಾ಼!” ಕರಿ. ");
INSERT INTO vaa_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","ಅಮ್ ಬೋಲ್ತಾಸ್‌ನ ಇನೊ ಕಾನ್‌ ಖ್ಹಮಜ಼್ ಪಡಾಲಗ್ಯು, ಅಜು಼ ಇನಿ ಜೀಬ್‍ನಿ ಭಂದಣ್ ಛು಼ಟಿಗಿ, ಯೋ ಬರೋಬರ್‌ಥಿ ವಾತ್ ಬೋಲಾಲಗ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","ತದೆ ಯೇಸುನೆ ಇವ್ಣುನ, “ಹಾ ಚಾ಼ಲ್ಯುತೆ ಬಾರೇಮ ಕಿನಾಬಿ ನಾ ಬೋಲ್‌ನು” ಕರಿ ಝೇತೈನ್‌ ಬೋಲ್ಯೊ; ತೋಬಿ ಇನೆ ಎತ್ರೆ ಝೇತೈನ್‌ ಬೋಲ್ಯೊತೋಬಿ, ಇನೇಥಿಬಿ ಜಾ಼ಖ್ಹತ್ ಇವ್ಣೆ ಫೈಲೈದಿದು. ");
INSERT INTO vaa_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","ಅಜು಼ ಖ್ಹಮ್‌ಜಾ಼ವಾಳು ಖ್ಹಾರು ಘಣು ಅಶ್ಚರ್ಯ ಹುಯಿಜೈ಼ನ್‌, “ಯೇಸು ಖ್ಹಾರು ಅಛ್ಛು಼ಸ್ ಕರಾಸ್! ಭೈರು ಖ್ಹಾರಾನ ಕಾನ್‌ ಖ್ಹಮ್‌ಜಾ಼ವಾನಿಘೋಣಿ ಅಜು಼ ಮುಕ್ಕಾವ್ನ ಖ್ಹಾರು ವಾತೆ ಬೋಲಾನಿ ಘೋಣಿ ಕರಾಸ್!” ಕರಿ ಬೋಲಿಲಿದು. ");
INSERT INTO vaa_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","ಯೋ ದನೂಮ ಪಾಛು಼ ಅದ್ಮಿನಿ ಭೀಡ್‌ ಭರೈನ್ ಆಯು, ಇವ್ಣುನ ಖಾಣನ ಶಾತ್ಬಿಕೊಂತೆ ದೇಖಿನ್, ಯೇಸುನೆ ಇನ ಶಿಷ್ಯರ್‌ನ ಖನ್ನೆ ಬುಲೈನ್, ");
INSERT INTO vaa_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“ಆ ಖ್ಹಾರ ಅದ್ಮಿನ ದೇಖಿನ್‌ ಮನ ಗೋರ್‌ಲಾಗಸ್‌, ಅವ್ಣೆ ಮಾರಕನ ಐನ್ ತೀನ್ ರೋಜ಼್ ಹುಯಿಗಾ; ಅವ್ಣುನ ಖಾಣನ ಶಾತ್ಬಿ ಕೊಯ್ನಿ. ");
INSERT INTO vaa_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","ಅವ್ಣುನ ಅಮ್ಮಸ್ ಭುಕ್ಯು ಘರೆ ಮೋಕ್ಲಿದಿದೊತೊ, ವಾಟ್‌ಪರ್ ಭವ್‌ಳ್ಯಾಮಾರಿನ್ ರಡ್ಕಿಜಾ಼ಶೆ, ಶನಕತೊ ಅವ್ಣಾಮ ಥೋಡು ಜ಼ಣು ದೂರ್‌ಥು ಐರ‍್ಹೂಸ್‌ನಿ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","ಅನ ಖ್ಹಮ್‌ಜಿನ್‌ ಇನ ಶಿಷ್ಯರ್‌ನೆ, “ಆ ಉಜ್ಜಾ಼ಡಿ ಝ಼ಗೋಮ ಅತ್ರಾಅದ್ಮಿನ ಬಶ್‌ ಹುವ್ವಾಯೆತ್ರು ಖಾಣು ಕಿಜ಼್ಜಾಥು ಲ್ಯಾವಾನ ಉಶೆ?” ಕರಿ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","ಯೇಸುನೆ ಇವ್ಣುನ, “ತುಮಾರಕನ ಕೆತ್ರ ರೋಟಾ ಛಾ಼?” ಕರಿ ಫುಛಾ಼ಯೊ. ಇನ ಇವ್ಣೆ, “ಖ್ಹಾತ್ ರೋಟಾ ಛಾ಼” ಕರಿ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","ತದೆ ಯೇಸುನೆ ಅದ್ಮಿನಿ ಝೂ಼ಂಡ್‌ನ ಜ಼ಮೀನ್‌ಪರ್ ಬೇಖ್ಹೊ ಕರಿ ಹುಕುಮ್‌ದಿದೊ. ಬಾದ್‌ಮ ಯೋ ಖ್ಹಾತ್ ರೋಟಾನ ಪಾಡಿಲೀನ್, ದೇವ್ನ ಧನ್ಯವಾದ್ ಕರೀನ್, ಯೋ ರೋಟಾನ ಖ್ಹಾರು ತೋಡಿನ್, “ಅಖ್ಖಾನ ವಾಟಪಾಡಿ ದೆವೊ” ಕರಿ ಇನ ಶಿಷ್ಯರ್‌ನ ದಿದೊ; ಶಿಷ್ಯರ್‌ನೆ ಇಮ್ಮಸ್ ಕರ‍್ಯು. ");
INSERT INTO vaa_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","ಎತ್ರೇಸ್ ಕಾಹೆತೆ ಇವ್ಣಾಕನ ಥೋಡು ನ್ಹಾನಿಮಾಛ್ಲಿಬಿ ಥು. ಯೇಸುನೆ ಇನಾಬಿ ಪಾಡಿಲೀನ್ ದೇವ್ನ ಧನ್ಯವಾದ್‌ ಕರೀನ್, “ಅನಾಬಿ ವಾಟಪಾಡಿ ದೆವೊ” ಕರಿ ಶಿಷ್ಯರ್‌ನ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","ಅದ್ಮಿಖ್ಹಾರು ಪೇಟ್‌ಭರೀನ್‌ ಖಾದು. ಬಾದ್‌ಮ ಶಿಷ್ಯರ್‌ನೆ ಉಭ್‌ರ‍್ಯುತೆ ಟುಕ್ಡಾವ್‌ನ ಜ಼ಮಾಕರ್ತಖ್ಹತರ್ ಖ್ಹಾತ್ ಟೋಕ್ರಾ ಭರಾಯ. ");
INSERT INTO vaa_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","ಹಿಜ್ಜಾ಼ ಕಮ್‌ಶಿಕಮ್ ಚಾರ್ ಹಜಾ಼ರ್‌ ಅದ್ಮಿಥು. ಬಾದ್‌ಮ ಯೇಸುನೆ ಯೋ ಖ್ಹಾರ ಅದ್ಮಿನ ಮೋಕ್ಲಿದೀನ್, ");
INSERT INTO vaa_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","ತದ್‌ನು-ತದೇಸ್‌ ಇನ ಶಿಷ್ಯರ್‌ನ ಬುಲೈಲಿನ್, ಡೋಣ್‌ಪರ್‌ ಚ಼ಢೀನ್ ದಲ್ಮನೂಥ ಕರಿ ತಬರ್‌ಖಾಮ ಚ಼ಲೆಗಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","ಬಾದ್‌ಮ ಫರಿಸಾಯರ್‌ವಾಳು ಥೋಡು ಅದ್ಮಿ ಯೇಸುಕನ ಐನ್, ಇನಜೋ಼ಡೆ ಅಬ್ಬಾಜ಼ಬ್ಬಿ ವಾತೆ ಬೋಲಾಲಗ್ಯು. ಇನಾಮ ಗಲ್ತಿ ಢೂಂಡಾನಖ್ಹಾಜೆ, “ತೂ ದೇವ್‍ಥಿ ಆಯೊ ಹುಯೊ ಕರಿ ಮಾಲುಮ್‌ ಪಡಾನಟೇಕೆ, ಆಕಾಶ್‌ಮ ಏಕ್‌ ಖ್ಹಣೇದ್‍ನು ಕಾಮ್ ಕರೀನ್ ವತಾಳ್” ಕರಿ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","ಅನ ಖ್ಹಮ್‌ಜಿನ್‌ ಯೇಸುನೆ ಇನ ಮನ್‌ಮ ಜೋ಼ರೇಖ್ಹು ದಮ್‌ ಲೀಮ್ಹೇಲಿನ್‌, “ಆ ಪಿಳ್ಗೀನು ಅದ್ಮಿ ಅದ್ಭುತ್ ಕಾಮ್ ದೇಕ್ಣುಕರಿ ಶನ ಬೋಲಾಸ್ತೆ? ಮೇ ಖ್ಹಾಚಿಮಾಬಿ ಬೋಲುಸ್ಕಿ ಆ ಪಿಳ್ಗಿವಾಳ ಅದ್ಮಿನ ಶನು ಖ್ಹಣೇದ್‌ಬಿ ಮಳ್‌ಶೆಸ್‌ ಕೊಯ್ನಿ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","ಯೇಸುನೆ ಇವ್ಣುನ ಮ್ಹೆಂದಿನ್, ಪಾಛೊ಼ಫರಿ ಡೋಣ್‌ ಚ಼ಢೀನ್‌, ದರ‍್ಯಾವ್‍ನ ಪಾರ್ಲಿ ಕನಾರೆ ಚ಼ಲೆಗಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","ಯೇಸುನ ಶಿಷ್ಯರ್‌ನೆ ಪೂರಯೆತ್ರು ರೋಟ ಪಳ್ಳಿಜಾ಼ವಾನು ಭೈಕಿ ಗಯುಥು, ಅಜು಼ ಡೋಣ್‌ಮ ಇವ್ಣಾಕನ ಎಕ್ಕಸ್ ರೋಟೊ ಥೊ. ");
INSERT INTO vaa_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","ಯೇಸುನೆ ಇವ್ಣುನ, “ಜ಼ತನ್, ಫರಿಸಾಯರ್‌ನುಬಿ ಹೆರೋದನು ಶೋಡ ನಾಖ್ಯುಹುಯು ಆಟಾನಿ ಬಾರೇಮ ಬರೋಬರ್‌ಥಿ ದೇಖಿಲೆವೊ” ಕರಿ ಘಣು ಝೇತೈನ್‌ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","ತದೆ ಇವ್ಣೆ, “ಅಪ್ಣಕನ ರೋಟೊಕೊಂತೆ ಇನಟೇಕೆ ಅಮ್ ಬೋಲ್ಯೊಕಿ ಶುಕಿ” ಕರಿ ಇವ್ಣ ಇವ್ಣಾಮ ಬೋಲಿಲಿದು. ");
INSERT INTO vaa_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","ಯೇಸುನೆ ಇವ್ಣೆ ಬೋಲಿಲೆವ್‍ಕರಾತೆ ಮಾಲುಮ್‌ಕರಿನ್, “ರೋಟೊಕೊಂತೆ ಬಾರೇಮ ಶನ ಬೋಲಿಲೆವ್‍ಕರಾಸ್ತೆ? ಬಿಜೂ಼ಬಿ ಮಾಲುಮ್ ಪಡ್ಯುಕೊಯ್ನಿಕಿ ಶು? ತುಮಾರೊ ದಿಲ್‌ ಬಂಡೊ ಹುಯಿಗಯೊಕಿ ಶು? ");
INSERT INTO vaa_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","ಡೋಳ ರ‍್ಹೀನ್‌ಬಿ ದೆಖಾವ ಕೊಯ್ನಿಕಿ ಶು? ಕಾನ್‌ ಛಾ಼ತೋಬಿ ಖ್ಹಮಜ಼್ ಪಡಾಕೊಯ್ನಿಕಿ ಶು? ತುಮೂನ ಯಾದ್ ಕೊಯ್ನಿಕಿ ಶು? ");
INSERT INTO vaa_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","ಮೇ ಯೋ ಪಾಚ಼್ ರೋಟಾನ ತೋಡಿನ್ ಪಾಚ಼್ ಹಜಾ಼ರ್‌ ಅದ್ಮಿನ ದಿದೋತೆ ತದೆ ಉಭ್‌ರ‍್ಯುತೆ ಟುಕ್ಡಾವ್‍ನ ಕೆತ್ರ ಟೋಕ್ರಾಮ ಭರ‍್ಯಾಥ?” ಕರಿ ಪುಛಾ಼ವ್‌ತಖ್ಹತರ್‌, ಇವ್ಣೆ, “ಭಾರ ಟೋಕ್ರಾ” ಕರಿ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“ಅಜು಼ ಯೋ ಖ್ಹಾತ್ ರೋಟಾನ ತೋಡಿನ್ ಚಾರ್ ಹಜಾ಼ರ್‌ ಅದ್ಮಿನ ದಿದೋತೆ ತದೆ ಉಭ್‌ರ‍್ಯುತೆ ಟುಕ್ಡಾವ್‍ನ ಕೆತ್ರ ಟೋಕ್ರಾಮ ಭರ‍್ಯಾಥ?” ಕರಿ ಫುಛಾ಼ವ್‌ತಖ್ಹತರ್‌, ಇವ್ಣೆ, “ಖ್ಹಾತ್ ಟೋಕ್ರಾ” ಕರಿ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","ತದೆ ಯೇಸುನೆ ಇವ್ಣುನ, “ತುಮೂನ ಬಿಜೂ಼ಬಿ ಮಾಲುಮ್ ಪಡ್ಯುಕೊಯ್ನಿಕಿ ಶು? ಕರಿ ಪುಛಾ಼ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","ಬಾದ್‌ಮ ಯೇಸುಬಿ ಇನು ಶಿಷ್ಯರ್‌ ಬೆತ್ಸಾಯಿದ ಗಾಮ್‌ನ ಆಯು. ಹಿಜ್ಜಾ಼ ಥೋಡು ಅದ್ಮಿ ಏಕ್‌ ಕಾಣಾನ ಯೇಸುಕನ ಬುಲೈಲಾಯಿನ್‌, “ಆ ಕಾಣಾನ ಛೀಮ್” ಕರಿ ಇನ ಗಿಂಗೈಲಿದು. ");
INSERT INTO vaa_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","ಯೇಸುನೆ ಯೋ ಕಾಣಾನ ಹಾತ್ ಧರೀನ್ ಗಾಮ್‌ನ ಭಾರ್ ಬುಲೈಲೀಜೈ಼ನ್, ಇನ ಡೋಳಾಪರ್‌ ಥೂಕಿನ್, ಇನಾಪರ್‌ ಹಾತ್‌ ಮ್ಹೇಲೀನ್‌, “ತುನ ಶಾತ್‌ತೋಬಿ ದೆಖಾವಸ್ಕಿ ಶು?” ಕರಿ ಇನ ಪುಛಾ಼ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","ಇನೆ ಮುಡ್‌ಕ್ಯು ಪಾಡಿ ದೇಖಿನ್‌, “ಮನ ಅದ್ಮಿಖ್ಹಾರು ದೆಖಾವಸ್, ಕತೋಬಿ ಇವ್ಣೆ ಝಾ಼ಡಾವ್‌ನಿಮತ್‌ ದೆಖಾವಸ್‌ತೋಬಿ ಹೈಕಡ್‌ ಹೀಕಡ್‌ ಫರುಕರಾಸ್” ಕರಿ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","ತದೆ ಯೇಸುನೆ ಇನ ಡೋಳಾಪರ್‌ ಫಾಛೊ಼ ಇನೊ ಹಾತ್ ಮ್ಹೇಲ್ಯೊ. ಯೋ ಡೋಳ ಮ್ಹೇಲಿ ದೇಖಾಖ್ಹತರ್ ಇನ ಡೋಳ ಐಗಾಥ, ಅಜು಼ ಇನಅಖ್ಖು ಬರೋಬರ್‌ಥಿ ದೆಖಾಯು. ");
INSERT INTO vaa_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","ಬಾದ್‌ಮ ಯೇಸುನೆ ಇನ, “ಗಾಮ್‌ನ ಮಹಿ ನಕೊ ಜಾ಼” ಕರಿ ಬೋಲಿನ್ ಇನ ಘರೆ ಮೋಕ್ಲಿದಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","ಬಾದ್‌ಮ ಯೇಸುಬಿ ಇನು ಶಿಷ್ಯರ್‌ ಫಿಲಿಪ್ಪನು ಕೈಸರೆಯ ಕರಿ ಖ್ಹಯೇರ‍್ನ ಖನ್ನೆನು ಖ್ಹಾರ ಗಾಮ್‌ನ ಜಾ಼ವ್ಣುಕರಿ ನಿಕ್‌ಳ್ಯಾ. ವಾಟ್‌ಪರ್ ಯೇಸುನೆ, “ಅದ್ಮಿಖ್ಹಾರು ಮೇ ಕೋಣ್ ಕರಿ ಬೋಲಾಸ್?” ಕರಿ ಇನ ಶಿಷ್ಯರ್‌ನ ಫುಛಾ಼ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","ತದೆ ಇವ್ಣೆ, “ಥೋಡು ಜ಼ಣು ತುನ, ‘ಬ್ಯಾಪ್ತಿಸ್ಮದ್ಯವಾಳೊ ಯೋಹಾನ’ ಕರಿ ಬೋಲಾಸ್, ಥೋಡು ಜ಼ಣು ತೂ ‘ಎಲೀಯ’ ಕರಿ ಬೋಲಾಸ್, ಅಜು಼ ಥೋಡು ಜ಼ಣು, ‘ತೂ ಪ್ರವಾದೀಮ ಏಕ್‌ ಜ಼ಣೊ ಹುಯಿರ‍್ಹೋಸ್’ ಕರಿ ಬೋಲಾಸ್” ಕರಿ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","ಯೇಸುನೆ ಇವ್ಣುನ, “ತುಮೆ ಶಾತ್‌ ಬೋಲೋಸ್‌? ಮೇ ಕೋಣ್?” ಕರಿ ಫುಛಾ಼ವ್‌ತಖ್ಹತರ್‌, ಪೇತ್ರನೆ, “ತೂ ದೇವ್‍ಥಿ ಆವ್ಣುತೆ ಕ್ರಿಸ್ತ ಹುಯಿರ‍್ಹೋಸ್” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","ತದೆ ಯೇಸುನೆ, “ಮಾರಿ ಬಾರೇಮ ಕಿನಾಬಿ ನಾ ಬೋಲ್‌ನು” ಕರಿ ಇವ್ಣುನ ಝೇತೈನ್‌ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","ಅಜು಼ ಯೇಸುನೆ, “ಅದ್ಮಿನೊ ಛಿಯ್ಯೊ ಘಣು ಲತಾಡ ಪಡ್ನು ಅಜು಼ ಶಾಣಾವ್‍ಥೀಬಿ, ಗಲ್‌ಢಯಾಜಕರ್‌ಥಿ, ಅಜು಼ ಮೋಶೆನಿ ವಚನ್ ಶಿಕಾಡವಾಳು ಶಾಸ್ತ್ರಿಖ್ಹಾರು ಇನ ಝಿಟ್ಕಾರಿನ್ ಧಕೇಲಿದಿಶೆ. ಅಜು಼ ಇನ ಮಾರಿನಾಕ್‌ಶೆ, ಮರಿಜಾ಼ವಾನ ಬಾದ್‌ಮ, ತೀನ್‌ರೋಜ಼್ ಕೇಡೆ ಯೋ ಪಾಛೊ಼ ಜಿವ್ತೊಹುಯಿನ್ ಉಠೀನ್ ಆವ್‌ಶೆ” ಕರಿ ಇನ ಶಿಷ್ಯರ್‌ನ ಬೋಲಿದ್ಯವಾನಿಕ್‍ಳ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","ಯೇಸುನೆ ಆ ವಾತೆನ ಶಾತ್ಬಿ ಲಪಾಡ್ಯೊಕೊಂತೆ ಬೋಲ್ಯೊ. ತದೆ ಪೇತ್ರನೆ ಯೇಸುನ ಬಾಜು಼ಮ ಬುಲೈಲಿಜೈ಼ನ್ ಇನ, “ಅಮ್ ನಕೊ ಬೋಲ್” ಕರಿ ಜಿದ್‌ಕರ‍್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","ತದೆ ಯೇಸುನೆ ಪೀಠೆ ಫರೀನ್, ಇನ ಶಿಷ್ಯರ್‌ನ ದೇಖಿನ್‌, ಪೇತ್ರನ ಗುರ್‌ಕೈನ್, “ಶೈತಾನ್, ಮಾರ ಖ್ಹಾಮ್ಣೇಥೊ ಹಟಿಜಾ಼, ತಾರಿ ಸೋಚ್ ಅದ್ಮಿನಿ ಸೋಚಸ್‌ ಪಣ್ಕಿ ದೇವ್ನಿ ಸೋಚ಼್ ಕಾಹೆ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","ಬಾದ್‌ಮ ಯೇಸುನೆ ಇನ ಶಿಷ್ಯರ್‌ನ ಅಜು಼ ಅದ್ಮಿನಿ ಝೂ಼ಂಡ್‌ನ ಇನಾಕನ ಬುಲಾಯೊ. ಇನೆ ಇವ್ಣುನ ಬೋಲ್ಯೋಕಿ, “ಕೋಣ್‌ತೋಬಿ ಮಾರ ಪೀಠೆ ಆವ್ಣುಕರಿ ಮನ್ ಉಶೇತೊ, ಇನು ಯೋ ಭೈಕಿನ್, ಇನಿ ಶಿಲ್‌ಬೇನ ಪಾಡಿಲೀನ್, ಮಾರ ಪೀಠೆ ಆವಾದೆ. ");
INSERT INTO vaa_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","ಕೋಣ್‌ತೋಬಿ ಏಕ್‌ ಜ಼ಣು ಇನು ಜಾನ್‌ ಬಚಾ಼ಡಿಲೇವ್ಣು ಕರಿ ಕರ‍್ಯುತೊ, ಯೋ ಇನು ಜಾನ್‌ ಗುಮೈಲಿಶೆ; ಕತೋಬಿ ಮಾರಖ್ಹಾಜೆಬಿ ಅಜು಼ ದೇವ್ನಿ ಅಛ್ಛಿ ಖಬರ್‌ನಖ್ಹಾಜೆ, ಕೋಣ್‌ತೋಬಿ ಜಾನ್‌ ದಿದುತೊ, ಯೊ ಇನ ಬಚಾ಼ಡಿಲಿಶೆ. ");
INSERT INTO vaa_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","ಏಕ್‌ ಅದ್ಮಿ ಹಿಡಿ ಜಗತ್‍ನಾಸ್ ಜೂತಿಲೀನ್ ಇನು ಜಾನ್‌ ಗುಮೈಲಿದುತೊ ಇನ ಶನು ಫಾಯಿದೊ? ಶನೀಸ್ ಫಾಯಿದೊ ಕೊಯ್ನಿ! ");
INSERT INTO vaa_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","ಕೋಣ್‌ತೋಬಿ ಏಕ್‌ ಜ಼ಣು ಶಾತ್‌ತೋಬಿ ದೀನ್ ಇನೊ ಜಾನ್ನ ಪಾಛು಼ ಲಿಯ್ಯೆಜಾ಼ಯಿಕಿ ಶು? ");
INSERT INTO vaa_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","ವ್ಯಭಿಚಾರಣಿ ಘೋಣಿ ಛಾ಼ತೆ, ಆ ಪಾಪ್‍ಭರಿ ಪಿಳ್ಗಿಮ ಕೋಣ್‌ತೋಬಿ, ಮಾರಖ್ಹಾಜೆ ಅಜು಼ ಮೇ ಬೋಲಿಶಿಕಾಡುತೆ ವಚನ್ನಖ್ಹಾಜೆಬಿ ಖ್ಹರ್‌ಮಾಯೂತೊ, ಅದ್ಮಿನೊ ಛಿಯ್ಯೋಬಿ ಇನ ಬಾನಿ ಶಕತ್‌ಥೀಬಿ ಅಜು಼ ಉಜಾ಼ಖ್ಹ್‌ಥಿ ಭರೈನ್, ಅದಿಕಾರ್‌ಥಿ ಪವಿತ್ರ ದೇವ್‌ದೂತರ್‌ನ ಜೋ಼ಡೆ ಆವಾನಿ ವಖ್ಹತ್‌ಮ, ಯೊ ಅದ್ಮಿನಿ ಬಾರೇಮ ಖ್ಹರ್‌ಮಾವ್‌ಶೆ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","ಅಜು಼ ಯೇಸುನೆ ಇವ್ಣುನ, “ತುಮೂನ ಖ್ಹಾಚಾಮ ಬೋಲುಸ್ಕಿ, ಹಾ ಭಿಯ್ಯಾತೆ ತುಮಾರಾಮ ಥೋಡು ಜ಼ಣು ದೇವ್ನಿ ರಾಜ್ಯ ಶಕತ್‍ಥಿ ಆವಾನು ದೇಖಾತೋಡಿ ಮರ್‌ಶೆಸ್ ಕೊಯ್ನಿ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","ಛೊ಼ ದನ್ನ ಬಾದ್‌ಮ ಯೇಸುನೆ ಪೇತ್ರ, ಯಾಕೋಬ ಬಿಜು಼ ಯೋಹಾನ್ನ ಕೇಡೆ ಬುಲೈಲಿನ್ ಊಚಾ಼ ಪಹಾಡ್‌ಪರ್ ಗಯೊ. ಹಿಜ್ಜಾ಼ ಇವ್ಣುನ ಮ್ಹೆಂದಿನ್ ಕೋಣ್‌ಬಿ ಕೋ ಥೂನಿ. ಇವ್ಣ ಡೋಳಾನ ಖ್ಹಾಮ್ಣೇಸ್, ಯೇಸುನು ರೂಪ್ ಬದ್ಲಿಗಯು. ");
INSERT INTO vaa_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","ಯೇಸುನು ಪೆರ್ವಾಖ್ಹ್‌ಅಖ್ಖು ಧೋಳು ಫಟ್‌ ಹುಯಿನ್, ಝ಼ಮ್‌ಕಾಲಗ್ಯುಥು. ಜ಼ಮೀನ್‌ಪರ್ ಛಾ಼ತೆ ಕೆಹೊ ಧೋಬೀಬಿ ಎತ್ರೆ ಧೋಳು ಫಟ್‌ ಕರಾನ ಕೋ ಹುವ್ವಾನಿತೆ ಇಮ್‌ ಥು. ");
INSERT INTO vaa_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","ತದೆ ಎಲೀಯಬಿ ಮೋಶೆ ಯೇಸುನ ಜೋ಼ಡೆ ವಾತೆ ಬೋಲುಕರಾನು ಯೋ ತೀನ್ ಶಿಷ್ಯರ್‌ನೆ ದೇಖ್ಯ. ");
INSERT INTO vaa_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","ತದೆ ಪೇತ್ರನೆ ಯೇಸುನ, “ಗುರು, ಹಮೆ ಹಜ಼್ಜಸ್ ರ‍್ಹವಾನು ಅಛ್ಛು಼! ಹಮೆ ಹಜ್ಜಾ಼ ತೀನ್ ಡೇರಾ ಠೋಕೆಸ್, ಏಕ್‌ ತುನ, ಏಕ್‌ ಮೋಶೇನ ಅಜು಼ ಏಕ್‌ ಎಲೀಯನ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","ಶಾತ್‌ ಬೋಲ್‌ನು ಕರಿ ಮಾಲುಮ್‌ ಕೋ ಪಡ್ಯುನಿತೆ ಇನಾಖ್ಹಾಜೆ ಪೇತ್ರನೆ ಅಮ್ ಬೋಲ್ಯೊತೆ. ಶನಕತೊ ಇವ್ಣೆ ಘಣು ಡರೀರ‍್ಹುಥು. ");
INSERT INTO vaa_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","ಎತ್ರಾಸ್‌ಮ ವಾದ್‌ಳು ಐನ್ ಇವ್ಣಾಪರ್ ಢಪೈಗಯು. ಯೋ ವಾದ್ಳನ ಮಹಿಥು, “ಆ ಮಾರೊ ಪ್ಯಾರ್‌ನೊ ಛಿಯ್ಯೊ, ಅನಿ ವಾತೆನ ಖ್ಹಮ್‌ಜೊ಼!” ಕರಿ ಅವಾಜ಼್ ಆಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","ಫಕ್‌ ಕರಿ ಇವ್ಣೆ ಅಶ್‌ಪೀಶ್‌ ದೇಖಾಖ್ಹತರ್, ಇವ್ಣಿ ಜೋ಼ಡ್ಮ ಯೇಸುನ ಮ್ಹೆಂದಿನ್ ಬಿಜು಼ ಕೋಣ್‌ಬಿ ಕೋ ಥೂನಿ. ");
INSERT INTO vaa_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","ಇವ್ಣೆ ಯೋ ಪಹಾಡ್‌ಪರ್‌ಥು ಉತ್ರಿನ್ ಆವಾನಿ ವಖ್ಹತ್‌ಮ ಯೇಸುನೆ ಇವ್ಣುನ, “ತುಮೆ ಹಮ್ಕೆ ದೇಖ್ಯಾತೆ ಇನ ಅದ್ಮಿನೊ ಛಿಯ್ಯೊ ಮರಿನ್‌ ಜಿವ್ತೊ ಹುಯಿನ್ ಉಠಿ ಆವಾತೋಡಿ, ಕಿನಾಬಿ ನಾ ಬೋಲ್‌ನು” ಕರಿ ಝೇತೈನ್‌ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","ಇವ್ಣೆ ಯೋ ವಾತೆನ ಮಾನಿಗಯು, ಕತೋಬಿ, “ಮರಿನ್‌ ಜಿವ್ತೊಹುಯಿನ್ ಉಠಾನು ಕತೊ ಶಾತ್?” ಕರಿ ಇವ್ಣ-ಇವ್ಣ ಮಹಿಸ್ ವಾತೆ ಬೋಲಾಲಗ್ಯ. ");
INSERT INTO vaa_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","ಅಜು಼ ಇವ್ಣೆ ಯೇಸುನ, “ಮೋಶೆನಿ ವಚನ್ ಶಿಕಾಡವಾಳು ಶಾಸ್ತ್ರಿಖ್ಹಾರು ಎಲೀಯ ಅಗಾಡಿ ಆವಾನು ಜ಼ರೂರತ್ ಛಾ಼, ಕರಿ ಶನ ಬೋಲಾಸ್ತೆ?” ಕರಿ ಪುಛಾ಼ಯ. ");
INSERT INTO vaa_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","ತದೆ ಯೇಸುನೆ, “ಎಲೀಯ ಪಹಿಲೆ ಐನ್ ಖ್ಹಾರು ಖ್ಹವಾರ್‌ಶೇತೆ ಖ್ಹಾಚಸ್. ಕತೋಬಿ ಅದ್ಮಿನೊ ಛಿಯ್ಯಾನಿ ಬಾರೇಮ, “ಯೋ ಘಣು ಲತಾಡ ಪಡೀನ್ ಅದ್ಮಿಥಿ ಧಕೇಲೈಜಾ಼ಶೆ ಕರಿ ಲೀಖೈರ‍್ಹೂಸ್‌ನಿ, ಆ ಕಿಮ್? ");
INSERT INTO vaa_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","ಕತೋಬಿ ಮೇ ತುಮೂನ ಬೋಲೂಸ್ಕಿ, ಎಲೀಯ ಆಯೊ ಅಜು಼ ಇನಿ ಬಾರೇಮ ವಾಕ್ಯಾಮ ಲೀಖೈರ‍್ಹೂತೆ ಇಮ್‌ ಅದ್ಮಿಖ್ಹಾರು ಇವ್ಣ ಮನ್‌ಮ ಆಯುತೆ ಇಮ್‌ ಇನ ಖ್ಹತೈನ್ ಮಾರ‍್ಯು” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","ಬಾದ್‌ಮ ಯೇಸುಬಿ ಇನ ತೀನ್ ಶಿಷ್ಯರ್‌, ಉಭ್‌ರ‍್ಯಾತೆ ಬಿಜ಼ ಶಿಷ್ಯರ್‌ಕನ ಐನ್, ಇವ್ಣ ಅಶ್‌ಪಿಶ್ ಅದ್ಮಿನಿ ಮೋಟಿ ಭೀಡ್‌ ಭರೈರ‍್ಹುತೆ ಅಜು಼ ಮೋಶೆನಿ ವಚನ್ ಶಿಕಾಡವಾಳು ಶಾಸ್ತ್ರೀಮ ಥೋಡು ಜ಼ಣು ಇವ್ಣ ಜೋ಼ಡೆ ಅಬ್ಬಾಜ಼ಬ್ಬಿ ವಾತೆಕರುರಾತೆ ದೇಖ್ಯ. ");
INSERT INTO vaa_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","ಅಜು಼ ಇವ್ಣೆಖ್ಹಾರು ಯೇಸುನ ದೇಖಿನ್‌, ಘಣು ಆಶ್ಚರ್ಯಖಾದು, ಅಜು಼ ಇನಾಕನ ನಾಶಿ ಆಯಿ ಮಳಿನ್ ಖ್ಹಲಾಮ್ ಕರ‍್ಯು. ");
INSERT INTO vaa_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","ತದೆ ಯೇಸುನೆ ಇನ ಶಿಷ್ಯರ್‌ನ, “ಇವ್ಣ ಜೋ಼ಡೆ ಶಾತ್‌ ಅಬ್ಬಾಜ಼ಬ್ಬಿ ವಾತೆ ಕರುಕರ್ತಥಾತೆ?” ಕರಿ ಪುಛಾ಼ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","ತದೆ ಯೋ ಝೂ಼ಂಡ್‌ಮಾಥು ಏಕ್‌ ಜ಼ಣು, “ಗುರು, ಮಾರ ಛಿಯ್ಯಾನ ಏಕ್‌ ಮುಕ್ಕೊ ಭೂತ್‌ ಧರಿರಾಖ್ಯುಸ್, ಇನಾಖ್ಹಾಜೆ ತಾರಕನ ಬುಲೈಲಾಯೊಥೊ. ");
INSERT INTO vaa_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","ಯೋ ಭೂತ್‌ ಕದೆ ಇನಾಪರ್‌ ಆಯುತೋಬಿ, ಇನ ಹೇಟ್‌ ರಡ್‌ಕೈದೇಸ್‌, ಬಿಜು಼ ಯೋ ಮ್ಹೋಡಾವಾಟೆ ಜ಼ಲ್‌ಭು ಕಾಡ್ತೊಹುಯಿನ್‌, ಕರ್‌-ಕರ್‌ ದಾತ್‌ ಚಾ಼ವ್ತೊಹುಯಿನ್‌ ಅಕ್‌ಡೈಜಾ಼ಸ್‌. ಇನಾಮಾಥು ಯೋ ಭೂತ್‌ನ ಕಾಡೊ ಕರಿ ತಾರ ಶಿಷ್ಯರ್‌ನ ಬೋಲಿಲಿದೊ, ಕತೋಬಿ ಇವ್ಣ ಹಾತೆ ಕೋಹುಯುನಿ” ಕರಿ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","ತದೆ ಯೇಸುನೆ “ಏ ವಿಶ್ವಾಸ್‌ಕೊಂತೆ ಪಿಳ್ಗಿಯೆ! ಮೇ ಬಿಜು಼ ಕೆತ್ರ ದನ್ ತುಮಾರ ಜೋ಼ಡೆ ರ‍್ಹೇಣು? ಅಜು಼ ಕೆತ್ರ ದನ್ ತುಮೂನ ಖ್ಹಮಾಳ್‌ಣು? ಇನ ಮಾರಾಕನ ಬುಲೈಲ್ಯಾವೊ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","ಇವ್ಣೆ ಇನ ಯೇಸುಕನ ಬುಲೈಲಾಯು. ಯೇಸುನ ದೇಕ್ತಾಸ್‌ನ, ಯೋ ಭೂತ್‌ ಯೋ ಛೋ಼ಕ್ರಾನ ಧಡಾಶ ಮರಾವಲಗ್ಯು, ಯೋ ಛೋ಼ಕ್ರು ಜ಼ಮೀನ್‌ಪರ್ ಪಡೀನ್ ಮ್ಹೋಡಾವಾಟೆ ಜ಼ಲ್‌ಭು ಕಾಡ್ತುಹುಯಿನ್‌ ತರಪ್‌ಢಾಲಗ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","ಯೇಸು ಯೋ ಛೋ಼ಕ್ರಾನ ಬಾನ, “ಅನ ಆ ಭೂತ್‌ ಧರೀನ್ ಕೆತ್ರ ದನ್ ಹುಯ?” ಕರಿ ಪುಛಾ಼ವಖ್ಹತರ್, ಇನೆ, “ಅಡ್ಡಾಣಿಪರಸ್‌ ಆಯುಥು; ");
INSERT INTO vaa_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","ಅಜು಼ ಅನ ಮಾರ‍್ನು ಕರಿ ಘಣಿ ಹಲ್ಲ ಆಗ್‌ಮಾಬಿ, ಪಾಣಿಮಾಬಿ ನಾಕ್ತುಥು. ತಾರ ಹಾತೆ ಶಾತ್ತೊಬಿ ಹೋತು ಉಶೇತೊ! ಹಮಾರಪರ್ ಗೋರ್‌ಕರೀನ್, ಮದತ್ ಕರ್‌” ಕರಿ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","ಯೇಸುನೆ ಇನ, “ತಾರ ಹಾತೆ ಹೋತು ಉಶೇತೊ! ಕರಿ ಬೋಲಾಸ್ ಕಿಶು? ನಂಬವಾಳಾನ ಖ್ಹಾರುಸ್‌ ಹುವಾಸ್” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","ಇಮ್‌ ಬೋಲ್ತಾಸ್‌ನ ಯೋ ಛೋ಼ಕ್ರಾನ ಬಾನೆ, “ನಂಬುಸ್‌, ಮಾರಿ ವಿಶ್ವಾಸ್‌ಕಮ್‌ ಉಶೆತೋಬಿ, ಮದತ್‌ಕರ್‌” ಕರಿ ಚಿಕ್ರಿನ್ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","ತದೆ ಯೇಸುನೆ ಬಿಜೂ಼ಬಿ ಅದ್ಮಿನಿ ಝೂ಼ಂಡ್‌ ಇವ್ಣ ಭಣಿ ನಾಶಿ ಉಳ್ಯಾವತೆ ದೇಖಿನ್‌, ಯೋ ಭೂತ್‌ನ ಗುರ್‌ಕೈನ್, “ಏಯ್, ಭೈರಾ ಮುಕ್ಕಾಭೂತ್‌, ಅನ ಮ್ಹೆಂದಿನ್ ಭಾರ್‌ನಿಕಳ್‌, ಪಾಛು಼ ಅನ ನಾ ಧರ್‌ನು! ಕರಿ ಮೇ ತುನ ಹುಕುಮ್‌ ದೆವ್‌ಕರುಸ್” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","ತದೆ ಯೋ ಭೂತ್‌ ಚಿಕ್ರಾಣ್ ಮ್ಹೇಲಿನ್, ಯೋ ಛೋ಼ಕ್ರಾನ ಧಡಾಶ ಮರೈನ್, ಇನ ಮಹಿತು ಭಾರ್‌ ನಿಕ್ಳಿಗಯು. ತದೆ ಯೋ ಛೋ಼ಕ್ರು ಮರ‍್ಯಾಹುಯಾನಿಘೋಣಿ ಪಡ್ಯುಥೂತೆ ದೇಖಿನ್‌ ಘಣ ಅದ್ಮಿನೆ, “ಆ ಮರಿಗಯು!” ಕರಿ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","ಕತೋಬಿ ಯೇಸುನೆ ಯೋ ಛೋ಼ಕ್ರಾನ ಹಾತ್‌ ಧರಿನ್ ಉಠಾಡ್‌ತಾಖ್ಹತರ್‌, ಯೋ ಉಠಿ ಭೀರಿಗಯು. ");
INSERT INTO vaa_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","ಯೇಸು ಘರ್‌ಮ ಆವಾದಿನ್, ಎಕ್ಲೋಸ್ ರ‍್ಹಾವಾನಿ ವಖ್ಹತ್‌ಮ, ಇನ ಶಿಷ್ಯರ್‌ನೆ, “ಯೋ ಭೂತ್‌ನ ಕಾಡಾನ ಹಮಾರೇಥಿ ಶನ ಕೋ ಹುಯೂನಿ?” ಕರಿ ಯೇಸುನ ಪುಛಾ಼ಯು. ");
INSERT INTO vaa_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","ತದೆ ಯೇಸುನೆ, “ಆ ಜಾ಼ತ್ನು ಭೂತ್‌ನ, ಪ್ರಾರ್ಥನೆಥೀಸ್ ಪಣ್ಕಿ ಬಿಜು಼ ಶನೇಥೀಬಿ ಕಾಡಾನ ಕೋ ಹುವಾನಿ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","ಯೇಸುಬಿ ಇನು ಶಿಷ್ಯರ್‌ ಹಿಜ್ಜಾ಼ಥು ನಿಕ್ಳಿನ್ ಗಲಿಲಾಯ ತಬರ್‌ಖಾಮಾಕರಿ ವಳ್ಯಜಾ಼ತಾಥ. ಯೋ ಕಿಜ಼್ಜಾ ಛಾ಼ ಕರಿ ಕಿನಾಬಿ ನಾ ಮಾಲುಮ್‌ಪಡ್ಣು ಕರಿ ಯೇಸುನ ದಿಲ್ಮ ಥು. ");
INSERT INTO vaa_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","ಶನಕತೊ ಯೇಸು ಇನ ಶಿಷ್ಯರ್‌ನ ಬೋಲಿ ದೇತೊಹುಯಿನ್, “ಅದ್ಮಿನ ಛಿಯ್ಯಾನ, ಇನ ಮಾರಿನಾಖವಾಳಾನ ಹಾತ್‌ಮ ದೆವೈಜಾಶೆ, ಇವ್ಣೆ ಇನ ಮಾರಿನಾಕ್‌ಶೆ. ಕತೋಬಿ ಮರೀನ್ ತೀನ್ ರೋಜ಼್ ಕೇಡೆ, ಯೋ ಪಾಛೊ಼ ಜಿವ್ತೊ ಹುಯಿನ್ ಉಠಿ ಆವ್‌ಶೆ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","ಕತೋಬಿ ಇವ್ಣೆ ಯೋ ವಾತೆನ ಪರ್‌ಖ್ಯುಕೊಯ್ನಿ, ಅಜು಼ ಇನಿ ಬಾರೇಮ ಯೇಸುನ ಪುಛಾ಼ವನಾಬಿ ಡರಿಗಯು. ");
INSERT INTO vaa_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","ಇವ್ಣೆ ಕಪೆರ್ನೌಮ್ ಗಾಮ್ಮ ಆಯ. ಅಜು಼ ಯೇಸು ಘರ್‌ಮ ರ‍್ಹವಾನಿ ವಖ್ಹತ್‌ಮ, ಇನ ಶಿಷ್ಯರ್‌ನ, “ತುಮೆ ವಾಟ್‌ಪರ್ ತುಮಾರ ತುಮಾರಸ್‌ಮ ಶಾತ್ ಅಬ್ಬಾಜ಼ಬ್ಬಿ ವಾತೆ ಕರುಕರ್ತಥಾತೆ?” ಕರಿ ಫುಛಾ಼ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","ಕತೋಬಿ ಇವ್ಣೆ ಜವಾಬ್‌ ಕೋ ದಿದೂನಿ, ಶನಕತೊ ಇವ್ಣೆ ವಾಟ್‌ಪರ್, ಅಖ್ಖೇಥಿ ಮೋಟೊ ಕೋಣ್ ಕರಿ ಇವ್ಣ-ಇವ್ಣಾಮ ಅಬ್ಬಾಜ಼ಬ್ಬಿ ವಾತೆ ಕರುಕರ್ತಥ. ");
INSERT INTO vaa_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","ಯೇಸು ಬೇಶಿನ್, ಇನ ಭಾರ‍ಜ಼ಣ ಶಿಷ್ಯರ್‌ನ ಬುಲೈನ್ ಇವ್ಣುನ, “ತುಮಾರಮ ಕೋಣ್‌ತೋಬಿ ಅಖ್ಖಾಮ ಅಗಾಡಿ ರ‍್ಹೇವ್ಣುಕರಿ ಉಶೇತೊ ಇನು ಯೋ ಅಖ್ಖೇಥಿ ಪಾಛ಼್‌ಲ್ಯೊ ಹೋಣು ಅಜು಼ ಅಖ್ಖಾನೊ ಸೇವಕ್ ಹುಯಿರ‍್ಹೇವ್ಣು” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","ಅಜು಼ ಇನೆ ಏಕ್‌ ಅಡ್ಡಾಣಿ ಲಡ್ಕಾನ ಬುಲೈನ್ ಶಿಷ್ಯರ್‌ನ ಇಚ಼್‌ಮ ಭೀರಖಾಡಿನ್‌, ಇನ ಬಥೈನ್‌ ಇವ್ಣುನ, ");
INSERT INTO vaa_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“ಕೋಣ್‌ತೋಬಿ ಮಾರ ನಾಮ್‌ಪರ್‌ ಅಮ್ನ ಅಡ್ಡಾಣಿ ಲಡ್ಕಾಮ ಏಕ್‌ನ ಮಳೈಲಿದೊತೊ, ಯೋ ಮನ ಮಳೈ ಲ್ಯಾವದಾಖ್ಹಲ್, ಅಜು಼ ಕೋಣ್‌ತೋಬಿ ಮನ ಮಳೈಲಿದೊತೊ, ಮನಾಸ್ ಕಾಹೆತೆ ಮನ ಮೋಕ್‌ಲ್ಯೊತೆ ಇನಾಬಿ ಮಳೈಲ್ಯಾವದಾಖ್ಹಲ್‌” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","ತದೆ ಯೋಹಾನನೆ ಯೇಸುನ, “ಗುರು, ಕೋಣ್‌ಕಿ ಏಕ್‌ ಜ಼ಣು ತಾರು ನಾಮ್ ಬೋಲಿನ್ ಭೂತ್ ನಖ್ಹಾಡುಕರ್ತುಥೂತೆ ಹಮೆ ದೇಖಿನ್, ಯೋ ಅಪ್ಣ ಭಣಿವಾಳು ಕಾಹೆತೆ ಇನಖ್ಹಾಜೆ, ಇನ ಭಿರಾಕಡ್, ಕರಿ ಬೋಲ್ಯ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","ತದೆ ಯೇಸುನೆ, “ಇನ ನಕೊ ಭಿರಾಖಡೊ, ಮಾರ ನಾಮ್‌ಪರ್‌ ಅದ್ಭುತ್‌ ಕರೀನ್ ಏಕ್‌ದಮ್ ಮಾರಿ ಬಾರೇಮ ಖರಾಬ್ ಬೋಲಾನ ಕಿನಾಬಿ ಕೋ ಹುವಾನಿ. ");
INSERT INTO vaa_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","ಅಪ್ಣಪರ್ ದಾವೊ ಕರಾಕೊಂತೆ ಇವ್ಣೆ ಅಪ್ಣಾಸ್‌ ಭಣಿವಾಳ ಹುಯಿರ‍್ಹುಸ್‍. ");
INSERT INTO vaa_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","ಮೇ ಖ್ಹಾಚಮಾಬಿ ಬೋಲುಸ್ಕಿ, ತುಮೆ ಕ್ರಿಸ್ತಭಣಿವಾಳ ಕರಿ, ಕೋಣ್‌ತೋಬಿ ಏಕ್‍ಜ಼ಣೊ ತುಮೂನ ಏಕ್‌ ತಾಂಬ್ಯೊ ಪಾಣಿ ಪಿಯ್ಯಾನು ದಿದುತೋಬಿ, ಇವ್ಣುನ ಮಳ್‌ಶೆತೆ ಇನಾಮ್ ಛು಼ಕ್‌ಶೆಸ್‌ ಕೊಯ್ನಿ”. ");
INSERT INTO vaa_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","ಅಜು಼ ಕೋಣ್‌ತೋಬಿ ಮನ ನಂಬವಾಳ ಆ ನ್ಹಾನಾವ್‍ಮ ಏಕ್‌ನಿ ವಿಶ್ವಾಸ್ ಮಾರಪರ್‌ಥು ತುಟಿ ಜಾ಼ವಾನಿಘೋಣಿ ಕರ‍್ಯೂತೊ, ಯೋ ಅದ್ಮಿನ ಘಲೆಂಡ ಕೇಡೆ ಮೋಟೊ ಘಟ್ಟಿನೊ ಬಂಡೊ ಭಾಂದೀನ್‌ ದರ‍್ಯಾವ್‌ಮ ನಾಖಿ ದಿದುತೋಬಿ ಇನ ಅಛ್ಛು಼ಸ್. ");
INSERT INTO vaa_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","ಅತ್ರೇಸ್ ಕಾಹೆತೆ, ತಾರೊ ಹಾತ್ ತುನ ಪಾಪ್‌ಮ ಖ್ಹಪ್‌ಡಾವ್‌ತೊ ಉಶೇತೊ ಇನ ಕತ್ರಿ ನಾಖಿದೆ; ");
INSERT INTO vaa_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","ಬೇ ಹಾತ್‌ ರಾಖಿನ್ ಕದೇಬಿ ಉಝಾ಼ವಾನಿ ಕಾಹೆತೆ ಆಗ್ ಹುಯಿರ‍್ಹೀತೆ ನರಕ್ಮ ಪಡಾಥೀಬಿ, ಹಾತ್‌ಕೊಂತೆ ಹರ್‌ಹಮೇಶ ರ‍್ಹವಾನಿ ಜಿ಼ಂದ್‌ಗಿ ಜಾ಼ವಾನು ತುನ ಅಶೇಲ್. ");
INSERT INTO vaa_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","ಅಜು಼ ತಾರೊ ಗೋಡೊ ತುನ ಪಾಪ್‌ಮ ಖ್ಹಪ್‌ಡಾವ್‌ತೊ ಉಶೇತೊ ಇನ ಕತ್ರಿ ನಾಖಿದೆ; ");
INSERT INTO vaa_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","ಬೇ ಗೋಡ ರ‍್ಹೀನ್ ನರಕ್ಮ ಪಡಾಥೀಬಿ ಲಂಗ್ಡೊ ಹುಯಿನ್ ಹರ್‌ಹಮೇಶ ರ‍್ಹವಾನಿ ಜಿ಼ಂದ್‌ಗೀಮ ಜಾ಼ವಾನು ತುನ ಅಶೇಲ್. ");
INSERT INTO vaa_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","ತಾರೊ ಡೋಳೊ ತುನ ಪಾಪ್‌ಮ ಖ್ಹಪ್‌ಡವಾನು ಉಶೇತೊ, ಇನ ಕಚ಼್‌ಕೋರಿ ಕಾಡಿ ಫೇಕಿದೆ! ಬೇ ಡೋಳ ರ‍್ಹೀನ್ ನರಕ್ಮ ಪಡಾಥೀಬಿ ಎಕ್ಕಸ್ ಡೋಳೊ ರ‍್ಹೀನ್ ದೇವ್ನಿ ರಾಜ್ಯಮ ಜಾ಼ವಾನು ತುನ ಅಶೇಲ್. ");
INSERT INTO vaa_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","ನರಕ್ಮ ಇವ್ಣುನ ಕಲ್ಡಾವಾಳೊ ಕೀಡೊ ಮರ್‌ಶೆಸ್ ಕೊಯ್ನಿ, ಇವ್ಣುನ ಬಳಾತೆ ಆಗ್ ಉಝಾ಼ವ್‌ಶೆಸ್‌ ಕೊಯ್ನಿ. ");
INSERT INTO vaa_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","ಬಲಿ ದೆವಾನು ರಾಛಾ಼ನ ಮೀಟ್‌ಥಿ ಪಾಕ್ ಕರಾತೆ ಇಮ್‌, ಹರೇಕ್ ಅದ್ಮಿ ಆಗ್‌ಥಿ ಪಾಕ್‌ ಉಶೆ. ");
INSERT INTO vaa_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","ಮೀಟ್‌ ಏಕ್‌ ಅಛ್ಛು಼ ರಾಛು಼ಸ್; ಕತೋಬಿ ಮೀಟಸ್‌ ಫಿಕ್ಕು ಹುಯಿಗುತೊ, ಇನ ತುಮೆ ಕಿಮ್ ಮೀಟ್‌ಣು ಲಜ಼ತ್‌ ದ್ಯವಾನ ಉಶೆ? ತುಮಾರಮ ಮೀಟ್‍ನಿಘೋಣಿ ಏಕ್‌ಥಿ-ಏಕ್‌ ಮಾನಿರ‍್ಹವಾಳಹುಯಿನ್ ಸಮಾಧಾನ್‌ಥಿ ರ‍್ಹವೊ. ");
INSERT INTO vaa_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","ಯೇಸು ಹಿಜ್ಜಾ಼ಥೊ ನಿಕ್ಳಿನ್, ಯೂದಾಯ ತಬರ್‌ಖಾನ ಗಯೊ, ಅಜು಼ ಯೊರ್ದನ್‌ ನದ್ದಿನು ಬಿಜೇಕ್‌ ಆಡಿನು ತಬರ್‌ಖಭಣಿ ಆಯೊ. ಹಿಜ್ಜಾ಼ ಅದ್ಮಿನಿ ಝೂ಼ಂಡೆ ಇನಾಕನ ಐನ್ ಭರಾವಖ್ಹತರ್, ಯೋ ಕದೇಬಿ ಕರ್ತೊಥೋತೆ ಇಮ್ಮಸ್ ವಚನ್ ಬೋಲಿದಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","ತದೆ ಫರಿಸಾಯರ್‌ವಾಳು ಯೇಸುಕನ ಆಯಿನ್‌ ಇನ ಫಖ್ಹಾವ್ಣು ಕರಿ ಕರ‍್ಯು. ತದೆ ಇವ್ಣೆ ಇನ, “ಅಪ್ಣಿ ಖಾನುಲ್‌ಮ, ಕೋಣ್‌ತೋಬಿ ಏಕ್‌ ಜ಼ಣೊ ಇನಿ ಬಾವಣ್ಣ ಮ್ಹೇಲಿದ್ಯವಾನು ಬರೊಬರ್‌ಕಿ ಶು? ಕರಿ ಪುಛಾ಼ಯು. ");
INSERT INTO vaa_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","ಅನ ಖ್ಹಮ್‌ಜಿನ್‌ ಯೇಸುನೆ, “ಮೋಶೆನೆ ತುಮೂನ ಶಾತ್ ಹುಕುಮ್‌ ದೀರಾಖ್ಯೊಸ್?” ಕರಿ ಪುಛಾ಼ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","ತದೆ ಇವ್ಣೆ, ತಲಾಕ್‌ನು ಕಾಗತ್‌ ಲೀಖಿದೀನ್‌, ಇನಿ ಬಾವಣ್ಣ ಮ್ಹೇಲಿದಿಯ್ಯೆಜಾ಼ಯ್ ಕರಿ ಮೋಶೇನೆ ಹುಕುಮ್‌ ದೀರಾಖ್ಯೊಸ್” ಕರಿ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","ತದೆ ಯೇಸುನೆ ಇವ್ಣುನ, “ತುಮಾರ ಮೊಂಡಿದಿಲ್‌ನ ದೇಖಿನ್, ಮೋಶೆನೆ ಅಮ್ನಿ ಹುಕುಮ್ ದೀರಾಖ್ಯೋಸ್ತೆ. ");
INSERT INTO vaa_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","ದೇವ್‌ನೇತೊ ಖ್ಹಾರು ಉಬ್‌ಜಾ಼ಯೋತೆ ತಪ್‌ಥೋಸ್‌, ‘ಅದ್ಮಿನ ಪರ್‌ಖ್ಹೊ ತಯೇಡಕರಿ ಬಣಾಯೊ, ");
INSERT INTO vaa_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","ಅನಖ್ಹಾಜೆಸ್ ಪರ್ಖ್ಹೊ ಇನ ಆಯ-ಬಾನ ಮ್ಹೇಲಿನ್, ಇನಿ ಬಾವಣ್‍ಥಿ ಮಳಾಸ್, ಅಜು಼ ಇವ್ಣೆ ಭೇ ಜ಼ಣ ಎಕ್ಕಸ್ ಶರೀರ್ ಹುಯಿಜಾ಼ಸ್’ ಕರಿ ಲೀಖೈರ‍್ಹುಸ್. ");
INSERT INTO vaa_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","ಅಮ್ ಬಿಜು಼ ಖ್ಹಾಮ್ಣೆ ಇವ್ಣೆ ಬೇಜ಼ಣ ಕಾಹೆ, ಎಕ್ಕಸ್ ಶರೀರ್‌ ಹುಯಿರ‍್ಹಾಸ್. ");
INSERT INTO vaa_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","ಇನಾಖ್ಹಾಜೆ ದೇವ್ನೆ ಮಳಾಯಹುಯಾನ, ಅದ್ಮಿ ಅಲಕ್‌ನಾಸ್ ಕರ‍್ನು” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","ಇವ್ಣೆ ಘರ್‌ಮ ಆವಾದಿನ್, ಶಿಷ್ಯರ್‌ನೆ ಅನಿಸ್‌ ಬಾರೇಮ ಯೇಸುನ ಪುಛಾ಼ಯು. ");
INSERT INTO vaa_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","ತದೆ ಯೇಸುನೆ ಇವ್ಣುನ, “ಕೋಣ್‌ತೋಬಿ ಏಕ್‌ ಜ಼ಣೊ ಇನಿ ಬಾವಣ್ಣ ಮ್ಹೇಲಿನ್, ಬಿಜೇಕ್‌ ಜ಼ಣಿನ ವ್ಯಹಾ ಕರೀಲಿದೊತೊ ಯೋ ಶೊಂತ್‌ ಬಾವಣ್ಣ ಧೋಕೊ ದ್ಯಾವಾಳೊ ಹುಯಿನ್, ವ್ಯಬಿಚಾರ್ ಕರಾವಾಳೊ ಹುಯಿರ‍್ಹೋಸ್. ");
INSERT INTO vaa_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","ಇಮ್ಮಸ್ ಏಕ್‌ ಬಾವಣ್ ಇನ ಬಾವ್ರಿನ ಮ್ಹೇಲಿನ್, ಬಿಜೇಕ್ ಜ಼ಣಾನ ಕರೀಲಿದೀತೊ ಯೋಬಿ ವ್ಯಬಿಚಾರ್ ಕರಾವಾಳಿ ಹುಯಿರ‍್ಹೀಸ್” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","ಬಾದ್‌ಮ ಥೋಡು ಜ಼ಣು ಅಡ್ಡಾಣಿ ಲಾಡ್ಕಾವ್‍ಪರ್‌ ಯೇಸುನೊ ಹಾತ್ ಮ್ಹೆಲಾವ್ಣು ಕರಿ ಇನಾಕನ ಲಾಯು, ತದೆ ಇನ ಶಿಷ್ಯರ್‌ನೆ ಇವ್ಣುನ ಗುರ್‌ಕಾಯು. ");
INSERT INTO vaa_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","ಯೇಸುನೆ ಅನ ದೇಖಿನ್‌, ಖೀಜ಼್ ಖೈನ್, ಇನ ಶಿಷ್ಯರ್‌ನ, “ಅಡ್ಡಾಣಿ ಲಡ್ಕಾವ್ನ ಮಾರ ಖನ್ನೆ ಆವಾನ ಮ್ಹೇಲೊ; ಇವ್ಣುನ ಭೀರಾಕೊ ನಕೊ, ಶನಕತೊ ದೇವ್‌ನು ರಾಜ್ಯ ಅಮ್‌ನಾಸ್‌ವಾಳಾನು. ");
INSERT INTO vaa_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","ತುಮೂನ ಖ್ಹಾಚಮಾಬಿ ಬೋಲುಸ್ಕಿ ಕೋಣ್‌ತೋಬಿ ಅಡ್ಡಾಣಿ ಲಡ್ಕಾನಿ ಘೋಣಿ ದೇವ್ನಿ ರಾಜ್ಯನ ನಾ ಮಾನ್ಯೂತೊ, ಯೋ ದೇವ್ನಿ ರಾಜ್ಯಮ ಜಾ಼ಶೇಸ್ ಕೊಯ್ನಿ”. ");
INSERT INTO vaa_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","ಅಮ್ ಬೋಲೀನ್‌ ಯೋ ಲಡ್ಕಾವ್ನ ಬಥೈನ್, ಇವ್ಣಾಪರ್ ಹಾತ್‌ ಮ್ಹೇಲಿನ್, ಆಶೀರ್ವಾದ್‌ ಕರ‍್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","ಯೇಸು ನಿಕ್ಳಿನ್‌ ವಾಟ್‌ ಧರೀನ್ ಜಾ಼ವಾನಿ ವಖ್ಹತ್‌ಮ, ಏಕ್‌ ಜ಼ಣೊ ನಾಖ್ಹ್‌ತೊ ಐನ್, ಇನ ಖ್ಹಾಮೆ ಗುಡ್‍ಘ್ಯ ಟೇಕಿನ್, “ಅಛ್ಛೊ಼ ಗುರು, ಹಮೇಶಾನಿ ಜಿ಼ಂದ್‌ಗಿ ಮಳ್‌ಣುಕತೊ, ಮೇ ಶಾತ್‌ ಕರ‍್ನು?” ಕರಿ ಫುಛಾ಼ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","ತದೆ ಯೇಸುನೆ ಇನ, “ಮನ ಅಛ್ಛೊ಼ಕರಿ ಶನ ಬೋಲಾಸ್ತೆ? ದೇವ್ನ ಮ್ಹೇಲೀನ್‌ ಬಿಜು಼ ಕೋಣ್‌ಬಿ ಅಛ್ಛು಼ ಕಾಹೆ. ");
INSERT INTO vaa_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","‘ಖೂನಿ ನಾಹೋಣು; ವ್ಯಬಿಚಾರ್ ನಾ ಕರ‍್ನು; ಚೋ಼ರಿ ನಾ ಕರ‍್ನು; ಬಿಜಾ಼ಪರ್ ಝೂ಼ಟಿ ಇಂಜಾ಼ಮ್ ನಾ ಲಗಾಡ್‌ಣು; ಕಿನಾಬಿ ಠಗಾವ಼್ಣು ನಾ; ಆಯ-ಬಾನ ಮರ್ಯಾದಿ ದೇವ್ಣು ಕರಿ ದೇವ್ನಿ ಹುಕುಮ್‌ ಖ್ಹಾರಿ ತುನ ಮಾಲುಮ್‌ ಛಾ಼ನಿ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","ಇನೆ ಯೇಸುನ, “ಗುರು, ಮೇ ಅಡ್ಡಾಣಿಪರ್‌ಥೋಸ್‌, ಆ ಖ್ಹಾರಿ ವಾತೆನಿ ಘೋಣಿ ಚಾ಼ಲ್ತೊ ವಳ್ಯಾವ್‌ಸ್‌” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","ತದೆ ಯೇಸುನೆ ಇನ ಠರ್‌ಕೈ ದೇಖಿನ್‌ ಪ್ಯಾರ್‌ಥಿ ಇನ, “ತಾರಮ ಏಕ್‌ ಕಮ್ ಛಾ಼. ಜಾ಼ ತಾರಕನ ಛಾ಼ತೆ ಖ್ಹಾರು ವೇಚಿನಾಖಿದೀನ್‌ ಗರೀಬ್‌ನ ದೆ, ತದೆ ತುನ ಪರ್‌ಲೋಕ್‌ಮ ಶೊತ್‌ರ‍್ಹಿಶೆ ಅಜು಼ ತು ಐನ್ ಮಾರ ಪೀಠೆ ಆವ್” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","ಕತೋಬಿ ಯೋ ಅದ್ಮಿ ಘಣು ಧನ್‌-ದೌಲತ್‌ವಾಳು ಹುಯಿರ‍್ಹುಥೂತೆ ಇನಾಖ್ಹಾಜೆ, ಯೇಸುನೆ ಅಮ್ ಬೋಲ್ತಾನ ಖ್ಹಮ್‌ಜಿನ್‌, ಮ್ಹೋಡು ಮುರ್‌ಝೈ಼ಲೀನ್‌, ದುಖ್‌ಥಿ ಚ಼ಲೆಗಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","ತದೆ ಯೇಸುನೆ ಅಶ್‌ಪೀಶ್‌ ಇನ ಶಿಷ್ಯರ್‌ ಭಣಿ ದೇಖಿನ್ ಇವ್ಣುನ, “ಧನ್‌ದೌಲತ್‌ವಾಳು ದೇವ್ನಿ ರಾಜ್ಯಮ ಜಾ಼ವಾನು ಘಣು ಮುಶ್ಕಿಲ್!” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","ಶಿಷ್ಯರ್‌ನೆ ಆ ವಾತೆನ ಖ್ಹಮ್‌ಜಿನ್‌ ಆಶ್ಚರ್ಯಖಾದು, ಯೇಸುನೆ ಪಾಛೊ಼ ಇವ್ಣುನ, “ಮಾರ ಲಡ್ಕಾ, ದೇವ್ನಿ ರಾಜ್ಯಮ ಜಾ಼ವಾನು ಘಣು ಮುಶ್ಕಿಲ್! ");
INSERT INTO vaa_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","ಶೌಕಾರ್ ಅದ್ಮಿ ದೇವ್ನಿ ರಾಜ್ಯಮ ಜಾ಼ವಾಥೀಬಿ ಊಟ್‍ ಖ್ಹುಯಿನ ಡೋಳವಾಟೆಕರಿ ಪೇಶಿಜಾ಼ವನು ಶುಲ್ಬ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","ಅನ ಖ್ಹಮ್‌ಜಿನ್‌ ಶಿಷ್ಯರ್‌ನೆ ಬಿಜೂ಼ಬಿ ಆಶ್ಚರ್ಯಖೈನ್, “ಇಮ್‍ಕತೊ, ಕಿನ ರಕ್ಷಣೆ ಮಳ್‌ಶೆ?” ಕರಿ ಇವ್ಣ-ಇವ್ಣಾಮ ಬೋಲಿಲಿದು. ");
INSERT INTO vaa_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","ತದೆ ಯೇಸುನೆ ಇವ್ಣುನ ಠರ್‌ಕೈ ದೇಖಿನ್, “ಆ ಅದ್ಮಿನ ಹಾಥ್ಥಿ ಕೋ ಹುವಾನಿ ಕತೋಬಿ ದೇವ್ನ ಹಾತೆ ಹುವ್ವಾಸ್‌; ದೇವ್‌ನೊ ಹಾತೆ ಕೋ ಹುವ್ವಾನಿತೆ ಏಕ್‌ಬಿ ಕೊಯ್ನಿ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","ತದೆ ಪೇತ್ರನೆ ಯೇಸುನ, “ಹಂದೇಕ್‌! ಹಮೆ ಖ್ಹಾರು ಮ್ಹೆಂದಿನ್‌ ತಾರ ಪೀಠೆ ಐಗಯ” ಕರಿ ಬೋಲಾಲಗ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","ತದೆ ಯೇಸುನೆ, “ತುಮೂನ ಖ್ಹಾಚ ಬೋಲುಸ್ಕಿ, ಕೋಣ್‌ತೋಬಿ ಮಾರಖ್ಹಾಜೆಬಿ ಅಜು಼ ದೇವ್ನಿ ಅಛ್ಛಿ ಖಬರ್‌ನಖ್ಹಾಜೆ ಇನ ಘರ್‌ನರ‍್ಹೆವೊ, ಭೈಯೇನ ರ‍್ಹವೊ, ಭೇನೇನ ರ‍್ಹವೊ, ಆಯಾನ ರ‍್ಹವೊ, ಬಾನ ರ‍್ಹವೊ, ಲಡ್ಕಾವ್ನ ರ‍್ಹವೊ, ಖೇತರ್‌ನ ರ‍್ಹವೊ ಮ್ಹೆಂದಿದೊ ಉಶೇತೊ, ");
INSERT INTO vaa_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","ಇನ ಜ಼ಮೀನ್‌ಪರ್ ರ‍್ಹವಾನಿ ವಖ್ಹತ್‌ಮ ಖ್ಹೋ ಪಟ್‌ ಜಾ಼ಖ್ಹತ್ ಕೈಯೆಕ್ಕಿ ಘರ್, ಭೇನೆ, ಭೈಯೇ, ಆಯ, ಲಡ್ಕಾ, ಖೇತರ್‌ ಅಜು಼ ಅದ್ಮಿಥಿ ಲತಾಡಾಬಿ ಮಳ್‌ಶೆಸ್‌ ಮಳ್‌ಶೆ. ಅಜು಼ ವಳ್ಯಾವಾತೆ ಜಂಗ್‌ಮ ಹರ್‌ಹಮೇಶ ರ‍್ಹವಾನಿ ಜಿ಼ಂದ್‌ಗಿ ಮಳ್‌ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","ಕತೋಬಿ ಆಜ಼್ ಅಗಾಡಿ ರ‍್ಹವಾಳು ಕೈಯೆಕ್ಕಿ ಜ಼ಣು ಪಾಛ಼ಳ್ ಹುಯಿಜಾ಼ಶೆ, ಅಜು಼ ಆಜ಼್ ಪಾಛ಼ಳ್ ರ‍್ಹವಾಳು ಕೈಯೆಕ್ಕಿ ಜ಼ಣು ಖ್ಹಾಮ್ಣೆ ಹುಯಿಜಾ಼ಶೆ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","ಯೇಸುಬಿ ಇನು ಶಿಷ್ಯರ್‌ ಯೆರೂಸಲೇಮ್‌ನಿ ವಾಟ್‌ ಧರೀನ್ ವಳ್ಯಜಾ಼ತಾಥ. ಯೇಸು ಇವ್ಣ ಖ್ಹಾಮ್ಣೆ-ಖ್ಹಾಮ್ಣೆ ವಳ್ಯೊಜಾ಼ತೋಥೊ, ಅನ ದೇಖಿನ್‌ ಶಿಷ್ಯರ್‌ನೆ ಘಣು ಧಡುಕೊ ಘಾಲಿಲಿದು; ಅಜು಼ ಇನ ಪೀಠೆ ಆವಾಳು ಖ್ಹಾರು ಡರಿಗಯು. ತದೆ ಯೇಸುನೆ ಇನ ಭಾರ ಜ಼ಣ ಶಿಷ್ಯರ್‌ನ ಪಾಛೊ಼ ಬಾಜೂ಼ಮ ಬುಲೈಲಿಜೈ಼ನ್, ಖ್ಹಾಮ್ಣೆ ಇನ ಉಷೇತೆ ಇನಿ ಬಾರೇಮ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","ಇನೆ ಇವ್ಣುನ, “ಹಂದೇಖೊ, ಅಪ್ಣೆ ಯೆರೂಸಲೇಮ್‌ನ ವಳ್ಯಾಜಯ್ಯೇಸ್‌, ಹಿಜ್ಜಾ಼ ಅದ್ಮಿನೊ ಛಿಯ್ಯಾನ ಗಲ್‌ಢಯಾಜಕರ್‌ನ ಅಜು಼ ಮೋಶೆನಿ ವಚನ್ ಶಿಕಾಡವಾಳ ಶಾಸ್ತ್ರಿಯೇನ ಹಾತ್‌ಮ ಧರಿದಿಶ್ಶೆ. ಇವ್ಣೆ ಇನ ಮಾರಿನಾಕ್ಣು ಕರಿ ಬೋಲಿದೀನ್‌ ಇನ ಪರೈ ಜಾ಼ತ್‌ವಾಳ ಅದ್ಮಿನ ಹಾತ್‌ಮ ದಿನಾಕ್‌ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","ಇವ್ಣೆ ಇನ ಚಿಂಘಾವ್‌ಶೆ, ಇನಾಪರ್‌ ಥೂಕ್‌ಶೆ, ಇನ ಮೇಕ್‌ನ ಕೊಳ್ಡೇಥಿ ಮಾರ್‌ಶೆ ಅಜು಼ ಇನ ಮಾರಿನಾಕ್‌ಶೆ; ಕತೋಬಿ ತೀನ್ ರೋಜ಼್‌ನ ಬಾದ್‌ಮ ಯೋ ಪಾಛೊ಼ ಜಿವ್ತೊಹುಯಿನ್ ಉಠಿ ಆವ್‌ಶೆ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","ಬಾದ್‌ಮ ಜೆಬೆದಾಯನ ಛಿಯ್ಯಾ ಹುಯಿರ‍್ಹಾಥಾತೆ ಯಾಕೋಬಬಿ ಯೋಹಾನ, ಯೇಸುಕನ ಐನ್, “ಗುರು, ಹಮೆ ಏಕ್‌ ಬಿಂತಿಕರಿಲಿಯೇಸ್, ಇನ ತೂ ಹಮಾರಖ್ಹಾಜೆ ಚ಼ಲೈದೇಣು” ಕರಿ ಬೋಲ್ಯ. ");
INSERT INTO vaa_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","ಯೇಸುನೆ ಇವ್ಣುನ, “ಶಾತ್ ಯೋ?” ಕರಿ ಪುಛಾ಼ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","ತದೆ ಇವ್ಣೆ, “ತಾರಿ ಮಹಿಮೆನಿ ರಾಜ಼್‌ಮ ತು ಸಿಂಹಾಸನ್‌ಪರ್ ಬೇಖ್ಹಾನಿ ವಖ್ಹತ್‌ಮ, ಹಮೆ ಬೇ ಜ಼ಣಾಮ ಏಕ್‌ ಜ಼ಣೊ ತಾರಿ ಖಾವಿ ಬಾಜು಼ಮ, ಬಿಜ್ಜೇಕ್‌ ಜ಼ಣೊ ತಾರಿ ಡಾವಿ ಬಾಜು಼ಮ ಬೇಖ್ಹಾನಿ ಘೋಣಿ ಕರ‍್ನು” ಕರಿ ಬೋಲ್ಯ. ");
INSERT INTO vaa_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","ಕತೋಬಿ ಯೇಸುನೆ ಇವ್ಣುನ, “ತುಮೆ ಶಾತ್‌ ಮಾಂಗಿಲಿದ ಕರಿ ತುಮುನ ಮಾಲುಮ್‌ ಕೊಯ್ನಿ. ಮೇ ಪೀಣುತೆ ವದೇಖ್ಹಾನ ರಾಛ಼ಮ ತುಮೆ ಪಿಯ್ಯಾನ ಉಶೇಕಿ ಶು? ಮನ ಉಷೇತೆ ಬ್ಯಾಪ್ತಿಸ್ಮ ಲ್ಯಾವಾನ ತುಮುನ ಉಶೇಕಿ ಶು?” ಕರಿ ಪುಛಾ಼ವಖ್ಹತರ್, ");
INSERT INTO vaa_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","ಇವ್ಣೆ, “ಹಮಾರೇಥಿ ಹುವಾಸ್” ಕರಿ ಬೋಲ್ಯ. ತದೆ ಯೇಸುನೆ ಇವ್ಣುನ, “ಮೇ ಪೀಣುತೆ ರಾಛ಼ಮ ತುಮೇಬಿ ಪೀಶು, ಮನ ಉಷೇತೆ ಬ್ಯಾಪ್ತಿಸ್ಮ ತುಮುನಾಬಿ ಉಶೆತೆ ಖ್ಹಾಚಸ್. ");
INSERT INTO vaa_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","ಕತೋಬಿ ಮಾರಿ ಖಾವಿ ಬಾಜು಼ಮ ರ‍್ಹವೊ, ಡಾವಿ ಬಾಜು಼ಮ ರ‍್ಹವೊ ಬೇಖ್ಹಾನಿ ಘೋಣಿ ಚೂ಼ಣಾನು ಮಾರ ಹಾತ್‌ಮ ಕೊಯ್ನಿ. ಯೋ ಕಿನಾಖ್ಹಾಜೆ ಕರಿ ದೇವ್ನೆ ಬಣೈರಾಖ್ಯೋಸ್ಕಿ, ಇವ್ಣುನಾಸ್ ಮಳ್‌ಶೆ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","ಉಬ್‌ರ‍್ಯಾತೆ ದಖ್ಹ್‌ ಜ಼ಣ ಶಿಷ್ಯರ್‌ನೆ ಅನ ಖ್ಹಮ್‌ಜಿನ್‌, ಯಾಕೋಬ್ ಅಜು಼ ಯೋಹಾನಪರ್‌ ಖೀಜ಼್‌ಖಾದು. ");
INSERT INTO vaa_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","ತದೆ ಯೇಸುನೆ ಖ್ಹಾರಾನ ಎಕ್ಕದಮ್ ಬುಲೈನ್ ಇವ್ಣುನ, “ಯೆಹೂದ್ಯರ್‌ಕಾಹೆತೆ ಅದ್ಮಿಮ, ಅದಿಕಾರ್‌ಮ ರ‍್ಹವಾಳು ಇವ್ಣಾಪರ್ ಹಂಕಾರ್‌ಥಿ ಅದಿಕಾರ್ ಚ಼ಲಾವಸ್. ಅಜು಼ ಇವ್ಣಾಮ ಮೋಟು ಖ್ಹಾರು ಜು಼ಲಮ್ಜ಼ಸ್ತಿಥಿ ಅದಿಕಾರ್ ಚ಼ಲಾವಸ್ ಕರಿ ಬೋಲಾನು ತುಮುನ ಮಾಲುಮ್‌ ಛಾ಼. ");
INSERT INTO vaa_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","ಕತೋಬಿ ತುಮಾರಮ ಇಮ್‌ ನಾರ‍್ಹೇವ್ಣು. ತುಮಾರಮ ಕೋಣ್‌ತೋಬಿ ಮೋಟು ಹೋಣುಕರಿ ಉಶೇತೊ; ಯೋ ಬಿಜ಼ ಖ್ಹಾರಾನಿ ಸೇವಕ್ ಹುಯಿರ‍್ಹೇವ್ಣು. ");
INSERT INTO vaa_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","ತುಮಾರಾಮ ಕೋಣ್‌ತೋಬಿ ಅಖ್ಖೇಥಿ ಖ್ಹಾಮ್ಣೆ ರ‍್ಹೇವ್ಣುಕರಿ ಉಶೇತೊ, ಯೋ ಅಖ್ಖಾನೊ ಗುಲಾಮ್ ಹುಯಿರ‍್ಹೇಣು. ");
INSERT INTO vaa_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","ಅದ್ಮಿನೊ ಛಿಯ್ಯೋಬಿ ಸೇವೆ ಕರೈಲ್ಯವಾನಖ್ಹಾಜೆ ಕೋ ಆಯೋನಿ; ಬಿಜಾ಼ನಿ ಸೇವೆ ಕರಾನ ಅಜು಼ ಇನೊ ಜಾನ್ನ ದೀನ್ ಕೈಯೆಕ್ಕಿ ಅದ್ಮಿನ ಛೋ಼ಡೈಲ್ಯವಾನಖ್ಹಾಜೆ ಆಯೊ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","ಬಾದ್‌ಮ ಇವ್ಣೆ ಯೆರಿಕೋನ ಆಯು. ತದೆ ಯೇಸು ಇನ ಶಿಷ್ಯರ್‌ನ ಜೋ಼ಡೆ ಹಿಜ್ಜಾ಼ಥೊ ನಿಕ್ಳಿನ್ ವಳ್ಯೊಜಾ಼ತೋಥೊ, ಅಜು಼ ಇನಜೋ಼ಡೆ ಅದ್ಮಿನಿ ಮೋಟಿ ಝೂ಼ಂಡ್‌ ಥಿ, ತದೆ ತಿಮಾಯನೊ ಛಿಯ್ಯೊ ಬಾರ್ತಿಮಾಯ ಕರಿ ಏಕ್‌ ಕಾಣೊ ಧರಮ್ ಮಾಂಗವಾಳೊ ಮಾರಗ್‌ನ ಶೇಡೆ ಬೆಠೋಥೊ. ");
INSERT INTO vaa_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","ಆ ವಾಟೆ ವಳ್ಯೊಜಾ಼ಸ್ತೆ ನಜ಼ರೇತ್‌ನೊ ಯೇಸು ಕರಿ ಇನೆ ಖ್ಹಮ್‌ಜಿನ್‌, “ದಾವೀದ್‌ನ ಛಿಯ್ಯಾ, ಮಾರಪರ್ ಗೋರ್‌ಕರ್‌!” ಕರಿ ಜೋ಼ರೇಖ್ಹು ಚಿಕ್ರಾಲಗ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","ಕೈಯೆಕ್ಕಿ ಅದ್ಮಿ, “ಖ್ಹೊಪೇಥಿ ರ‍್ಹೇ!” ಕರಿ ಇನ ಗುರ್‌ಕಾಯು. ತೋಬಿ ಯೋ, “ದಾವೀದ್‌ನ ಛಿಯ್ಯಾ, ಮಾರಪರ್ ಗೋರ್‌ಕರ್‌!” ಕರಿ ಬಿಜೂ಼ಬಿ ಜಾ಼ಖ್ಹತ್ ಚಿಕ್ರಿಲಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","ತದೆ ಯೇಸುನೆ ಭೀರಿನ್, “ಇನ ಬುಲಾವೊ” ಕರಿ ಬೋಲ್ಯೊ. ಅಮ್ ಬೋಲ್ತಾನ ಇವ್ಣೆ ಯೋ ಕಾಣಾನ ಬುಲೈನ್, “ಭಾಲಿಥಿರ‍್ಹೇ, ಉಟ್, ಯೇಸು ತುನ ಬುಲಾವ್‌ಕರಾಸ್‌” ಕರಿ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","ತದೆ ಯೋ ಇನ ಝ಼ಗ್ಗಾನ ಕಾಡಿ ಫೇಕಿನ್, ಭಶ್‌ಡಕ್ ಕರಿ ಉಠೀನ್, ಯೇಸುಕನ ಆಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","ಯೇಸುನೆ ಇನ, “ಮೇ ತುನ ಶಾತ್ ಕರ‍್ನು?” ಕರಿ ಪುಛಾ಼ಯೊ. ತದೆ ಯೋ ಕಾಣಾನ, “ಗುರು, ಮನ ಡೋಳ ದೆಖಾವಾನಿ ಘೋಣಿ ಕರ್ಲಾ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","ಯೇಸುನೆ ಇನ, “ಜಾ಼, ತಾರಿ ವಿಶ್ವಾಸ್‌ಥೀಸ್ ತುನ ಅಛ್ಛು಼ ಹುಯಿಗಯು” ಕರಿ ಬೋಲ್ಯೊ. ಅಮ್ ಬೋಲ್ತಾಸ್‌ನ ಇನ ದೆಖಾವಲಗ್ಯು ಅಜು಼ ಯೋ ಮಾರಗ್‌ವಾಟೆ ಕರಿ ಯೇಸುನ ಪೀಠೆ ಗಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","ಇವ್ಣೆ ಯೆರೂಸಲೇಮ್‌ನ ಖನ್ನೆ-ಖನ್ನೆ ಐನ್, ಆಲಿವ್‌ನ ಪಹಾಡ್‌ಕನ ಛಾ಼ತೆ ಬೆತ್ಫಗೆ ಅಜು಼ ಬೇಥಾನ್ಯ ಕರಿ ಗಾಮ್‌ಕನ ಆಯ. ತದೆ ಯೇಸುನೆ ಇನ ಶಿಷ್ಯರ್‌ಮ ಬೇ ಜ಼ಣಾನ ಬುಲೈನ್, ");
INSERT INTO vaa_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","ತುಮಾರ ಖ್ಹಾಮ್ಣೆ ಛಾ಼ತೆ ಗಾಮ್ಮ ಜಾ಼ವೊ, ತುಮೆ ಯೋ ಗಾಮ್‌ನ ಮಹಿ ಜಾ಼ತಸ್‌ನ, ಹಿಜ್ಜಾ಼ ಏಕ್‌ ಗಧೇಡಾನು ಚೆಲ್ಕು ಭಂದೈರ‍್ಹೀಶೆತೆ ತುಮೆ ದೇಕ್‌ಶು. ಹಂಕೆತೋಡಿ ಇನಾಪರ್‌ ಕೋಣ್‌ಬಿ ಕೋ ಬೆಠೂನಿ. ಇನ ಛೋ಼ಡಿನ್ ಹಜ್ಜಾ಼ ಲೀನ್‌ ಆವೊ. ");
INSERT INTO vaa_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","ಅಜು಼ ಕೋಣ್‌ತೋಬಿ ತುಮುನ ಶನ ಅಮ್ ಕರುಕರಸ್ತೆ ಕರಿ ಪುಛಾ಼ಯುತೊ, ಪ್ರಭುನ ಆ ಹೋಣುಕಸ್‌, ಅಜು಼ ಒಗ್ಗಿಸ್‌ಮ ಅನ ಪಾಛು಼ ಬೋಲಿ ಮೋಕಲ್‌ಶೆ ಕರಿ ಬೋಲೊ” ಕರಿ ಬೋಲಿನ್ ಮೋಕ್‌ಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","ತದೆ ಇವ್ಣೆ ಜೈ಼ನ್‌, ವಾಟ್ನ ಶೇಡೆಥೂತೆ ಘರ್‌ನ ಬಾಕಲ್‍ಕನ ಗಧೇಡಾನು ಚೆಲ್ಕು ಭಂದ್ಯೂತೆ ದೇಖ್ಯು. ಇನ ಛೋ಼ಡುಕರಾನಿ ವಖ್ಹತ್‌ಮ, ");
INSERT INTO vaa_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","ಹಿಜ್ಜಾ಼ ಭಿಯುಥೂತೆ ಥೋಡು ಜ಼ಣು, “ಆ ಚೆಲ್ಕಾನ ಛೋ಼ಡಿನ್, ಶಾತ್‌ ಕರಾನ ಆಯ?” ಕರಿ ಪುಛಾ಼ಯು. ");
INSERT INTO vaa_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","ಇವ್ಣೆ ಯೇಸುನೆ ಬೋಲಿ ಮೋಕ್‌ಲ್ಯೊಥೋತೆ ಇಮ್ಮಸ್ ಬೋಲ್ಯು, ತದೆ ಯೋ ಅದ್ಮಿಖ್ಹಾರು ಜಾ಼ವಾನ ಮ್ಹೇಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","ಇವ್ಣೆ ಯೋ ಗಧೇಡಾನ ಚೇಲ್ಕಾನ ಯೇಸುಕನ ಲೈನ್‌, ಇವ್ಣ ಲುಂಗ್ಡಾವ್‍ನ ಇನಾಪರ್‌ ನಾಖ್ಯು, ತದೆ ಯೇಸು ಇನಾಪರ್ ಚ಼ಢೀನ್ ಬೇಶಿಗಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","ತದೆ ಘಣ ಅದ್ಮಿನೆ ಇವ್ಣ ಲುಂಗ್ಡಾವ್‍ನ ವಾಟ್‌ಪರ್ ಬಿಛಾ಼ಯು. ಬಿಜು಼ ಥೋಡು ಜ಼ಣು ಬಾಗ್‌ಮಾಥು ಡಾಳಿಯೇನ ಕತ್ರಿಲೈನ್ ವಾಟ್‌ಪರ್ ಬಿಛಾ಼ಯು. ");
INSERT INTO vaa_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","ಯೇಸುನ ಖ್ಹಾಮ್ಣೆಬಿ ಪೀಠೆಬಿ ಒಳಿಜಾ಼ತುಥೂತೆ ಅದ್ಮಿಖ್ಹಾರು ಚಿಕ್ರಾಣ್ ಮ್ಹೇಲ್ತುಹುಯಿನ್, “ಹೊಸನ್ನ! ಪ್ರಭು ದೇವ್ನ ನಾಮ್‌ಪರ್‌ ಆವಾಳಾನ ದೇವ್ ಆಶೀರ್ವಾದ್‌ ಕರಾದೆ! ");
INSERT INTO vaa_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","ಅಪ್ಣೊ ಬಾ ಹುಯಿರ‍್ಹೋತೆ ದಾವೀದ್‌ನಿ ರಾಜ್ಯ ಆವ್‌ಶೆ, ದೇವ್ ಇನ ಆಶೀರ್ವಾದ್‌ ಕರಾದೆ. ಉಪ್ಪರ್‌ಲ್ಯ ಲೋಕಾಮ ಛಾ಼ತೆ ದೇವ್ನ ಧನ್ಯವಾದ್ ಹುವಾದೆ!” ಕರಿ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","ಬಾದ್‌ಮ ಯೇಸು ಯೆರೂಸಲೇಮ್‌ನ ಗಯೊ, ಹಿಜ್ಜಾ಼ ಮಂದಿರ್‌ಮ ಜೈ಼ನ್, ಚಾರ‍್ಹೆ ಬಾಜು಼ ಥೂತೆ ಖ್ಹಾರೂಸ್ ದೇಖ್ಯೊ. ಎತ್ರಾಸ್‌ಮ ಖ್ಹಾಂಜ಼್ ಹುಯಿಗಯುಥು, ಇನಾಖ್ಹಾಜೆ ಇನ ಭಾರ ಜ಼ಣ ಶಿಷ್ಯರ್‌ನ ಕೇಡೆ ಬೇಥಾನ್ಯನ ಚ಼ಲೆಗಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","ತಿನವ್ಹಾಣೆ ಇವ್ಣೆ ಬೇಥಾನ್ಯಥು ಪಾಛು಼ ಆವಾನಿ ವಖ್ಹತ್‌ಮ, ಯೇಸುನ ಭುಕ್‌ಲಾಗ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","ತದೆ ಪಾಂದ್‌ಡು ಮ್ಹೇಲೈರ‍್ಹುಥೂತೆ ಏಕ್‌ ಅಂಜೀರ್‌ನ ಝಾ಼ಡಾನ ಯೇಸುನೆ ದೂರ್‌ಥೊ ದೇಖಿನ್‌, ಇನಾಮ ಎಖಾದು ಪಂಡು ಮಳ್‌ಶೆ ಕರಿ ಹಿಜ್ಜಾ಼ ಗಯೊ. ಕತೋಬಿ ಹಿಜ್ಜಾ಼ ಜಾ಼ವಾದಿನ್ ಖಲಿ ಪಾಂದ್‍ಡುಸ್ ಪಣ್ಕಿ, ಬಿಜು಼ ಶಾತ್ಬಿ ಕೋ ಥೂನಿ, ಶನಕತೊ ಯೋ ಅಂಜೀರ್‌ನ ಪಂಡಾ ಮ್ಹೇಲಾನ ದನ್‌ಕಾಹೆ. ");
INSERT INTO vaa_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","ತದೆ ಯೇಸುನೆ ಯೋ ಝಾ಼ಡಾನ, “ಹಂಕೇಥು ಕೋಣ್‌ಬಿ ತಾರಾಮ ಕದೇಬಿ ಪಂಡು ನಾ ಖಾಣುತೆ ಇಮ್‌ ಹುವಾದೆ!” ಕರಿ ಬೋಲ್ಯೊ. ಅಜು಼ ಇನ ಶಿಷ್ಯರ್‌ನೆ ಆ ವಾತೆನ ಖ್ಹಮ್‌ಜ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","ಇವ್ಣೆ ಯೆರೂಸಲೇಮ್‌ನ ಅವಾದಿನ್, ಯೇಸು ಮೋಟಿ ಮಂದಿರ್‌ಮ ಜೈ಼ನ್, ಹಿಜ್ಜಾ಼ ವೇಚ಼ವಾಳಾನ ಲ್ಯವಾಳಾನ ಭಾರ್ ನಖ್ಹಾಡಲಗ್ಯೊ. ಅಜು಼ ಇನೆ ಪೈಶಾ ತೋಡಾವಾನು ಧಂದೊ ಕರಾವಾಳಾನ ಖುಡ್‌ಶಿನಾಬಿ, ಪರ‍್ಯಾವೊ ವೇಚ಼ವಾಳಾನು ಮೇಜ್‌ನ ರಡ್‌ಕೈನಾಖಿದಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","ಏಕ್‌ ಜ಼ಣಾನಾಬಿ ಮಂದಿರ್‌ನ ಮಹಿಕರಿ ಶಾತ್ಬಿ ಪಳ್ಳಿನ್‌ ಜಾ಼ವಾದಿದೊಕೊಯ್ನಿ. ");
INSERT INTO vaa_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","ಅಜು಼ ಯೇಸುನೆ ದೇವ್ನಿ ವಚನ್ನ ಬೋಲಿ ದೇತೊಹುಯಿನ್, “ದೇವ್ನೆ ಬೋಲ್ಯೊತೆ ಇಮ್‌, ‘ಮಾರಿ ಮಂದಿರ್‌ ಖ್ಹಾರ ಜಾ಼ತ್‌ವಾಳ ಅದ್ಮಿನ ಪ್ರಾರ್ಥನೆನು ಘರ್ ಕರಿ ಬೋಲೈಲೀಶೆ’ ಕರಿ ಲೀಖೈರ‍್ಹೂಸ್‌ನಿ? ಕತೋಬಿ ತುಮೆ ಅನ ಚೋ಼ರ್‌ನಿ ಘವಿ ಬಣೈರಾಖ್ಯಾಸ್!” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","ಅನ ಖ್ಹಮ್‌ಜಿನ್‌ ಗಲ್‌ಢಯಾಜಕರ್‌ ಅಜು಼ ಮೋಶೆನಿ ವಚನ್ ಶಿಕಾಡವಾಳು ಶಾಸ್ತ್ರಿಯೆ಼ ಯೇಸುನ ಕೆವ್ಹಿ ಭಾಮ್‌ಥಿ ಮಾರೇಜಾ಼ಯ್‌ ಕರಿ ಸೋಚಾಲಗ್ಯು. ಕತೋಬಿ ಅದ್ಮಿಖ್ಹಾರು ಯೇಸುನಿ ವಾತೆನ ಖ್ಹಮ್‌ಜಿನ್‌ ಘಣು ಅಶ್ಚರ್ಯ ಹುಯುತೆ ಇನಾಖ್ಹಾಜೆ, ಇವ್ಣೆ ಯೇಸುನ ದೇಖಿನ್‌ ಡರಿನ್ ಥು. ");
INSERT INTO vaa_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","ಖ್ಹಾಂಜ಼್ ಹುವ್ವಾದೀನ್ ಯೇಸುಬಿ ಇನು ಶಿಷ್ಯರ್‌ ಖ್ಹಯೇರ‍್ನ ಮ್ಹೇಲಿ ಗಯ. ");
INSERT INTO vaa_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","ತಿನವ್ಹಾಣೆ ಇವ್ಣೆ ಮಾರಗ್ ಧರಿನ್ ಆವಾನಿ ವಖ್ಹತ್‌ಮ, ಯೋ ಅಂಜೀರ್‌ನು ಝಾ಼ಡ್‌ಣ ಇವ್ಣೆ ದೇಖ್ಯ. ಯೋ ಜ಼ಡ್‌ ಖ್ಹಮೇದ್‌ಥೂಸ್‌ ಖ್ಹುಕೈಗಯೂಥು. ");
INSERT INTO vaa_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","ತದೆ ಪೇತ್ರನೆ ಗಯೋತೆ ದನ್ನೆ ಚಾ಼ಲ್ಯುಥೂತೆ ಇನ ಯಾದ್‌ಕರಿನ್ ಯೇಸುನ, “ಗುರು ಹಂದೇಕ್‌, ತುನೆ ಶಾಪ ದಿದೊಥೋತೆ ಅಂಜೀರ್‌ನು ಝಾ಼ಡ್ ಖ್ಹುಕೈಗಯು!” ಕರಿ ಬೋಲ್ಯೊ, ");
INSERT INTO vaa_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","ತದೆ ಯೇಸುನೆ ಇವ್ಣುನ ಫರೈನ್ ಬೋಲ್ಯೋಕಿ, “ದೇವ್‌ಪರ್‌ ವಿಶ್ವಾಸ್‌ ರ‍್ಹವಾದೆ. ");
INSERT INTO vaa_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","ಮೇ ತುಮುನ ಖ್ಹಾಚ ಬೋಲುಸ್, ಕೋಣ್‌ತೋಬಿ ಆ ಪಹಾಡ್‌ನ, ‘ತೂ ಉಖ್‌ಡೈ ಜೈ಼ನ್, ದರ‍್ಯಾವ್‌ಮ ಪಡ್’ ಕರಿ ಬೋಲಿನ್ ಇನ ದಿಲ್ಮ ಗುಮಾನಿ ಕರ‍್ಯೊಕೊಂತೆ, ಯೋ ಬೋಲ್ಯೊತೆ ಇಮ್ಮಸ್ ಉಷೆಕರಿ ನಂಬ್ಯೋತೊ, ಯೋ ಬೋಲ್ಯೊತೆ ಇಮ್ಮಸ್ ಇನ ಉಶೆ. ");
INSERT INTO vaa_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","ಇನಾಖ್ಹಾಜೆಸ್ ಮೇ ತುಮೂನ ಬೋಲುಸ್ಕಿ: ತುಮೆ ಪ್ರಾರ್ಥನೆ ಕರಿನ್‌ ಶಾತ್ ಮಾಂಗೋಸ್‌ಕಿ ಯೋ ತುಮೂನ ಮಳೀರ‍್ಹುಸ್ ಕರಿ ನಂಬೊ, ತದೆ ತುಮೆ ಶಶ್ಶಾತ್ ಮಾಂಗಿಲಿದಾಕಿ ಯೋ ತುಮುನ ಮಳ್‌ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","ಎತ್ರೇಸ್ ಕಾಹೆತೆ ತುಮೆ ಭೀರಿನ್‌ ಪ್ರಾರ್ಥನೆ ಕರಾನಿ ವಖ್ಹತ್‌ಮ, ತುಮೂನ ಕಿನಾಪರ್‌ಬಿ ಶಾತ್‌ತೋಬಿ ದಾವೊ ರ‍್ಹಯೂತೊ ಇನ ಮಾಪ್‌ ಕರೊ, ತದೆ ಪರಲೋಕ್‍ಮ ಛಾ಼ತೆ ತುಮಾರೊ ಬಾಬಿ ಜಿನು ತುಮೆ ಕರ‍್ಯಾತೆ ಗಲ್ತಿನ ಮಾಪ್‌ ಕರಿನಾಕ್‌ಶೆ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","ಕತೋಬಿ ತುಮೆ ಮಾಪ್‌ ನಾಕರ‍್ಯಾತೊ ಪರಲೋಕ್‍ಮ ಛಾ಼ತೆ ತುಮಾರೊ ಬಾಬಿ ಜಿನು ತುಮಾರಿ ಗಲತ್ನ ಮಾಪ್‌ ಕೊಕರ್‌ಶೇನಿ. ");
INSERT INTO vaa_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","ಇವ್ಣೆ ಪಾಛು಼ ಫರೀನ್ ಯೆರೂಸಲೇಮ್‌ನ ಆಯ. ಹಿಜ್ಜಾ಼ ಯೇಸು ಮಂದಿರ್‌ನ ಮಹಿ ಜೈ಼ನ್‌ ಫರುಕರಾತೆ ವಖ್ಹತ್‌ಮ, ಗಲ್‌ಢಯಾಜಕರ್‌ನ ಮೋಶೆನಿ ವಚನ್ ಶಿಕಾಡವಾಳು ಶಾಸ್ತ್ರಿಯೆ ಅಜು಼ ಶಾಣು ಖ್ಹಾರು ಯೇಸುಕನ ಐನ್, ");
INSERT INTO vaa_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","“ತೂ ಖೆವಿ ಹಕ್‌ಥಿ ಆ ಖ್ಹಾರು ಕರಾಸ್ತೆ? ಅಮ್ನಿ ಹಕ್ ತುನ ಕೋಣ್ ದಿದು?” ಕರಿ ಇನ ಪುಛಾ಼ಯು. ");
INSERT INTO vaa_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","ಯೇಸುನೆ ಇವ್ಣುನ, “ಮೇಬಿ ತುಮೂನ ಏಕ್‌ ಸವಾಲ್‌ ಫುಛಾ಼ವುಸ್‌, ಮನ ಜವಾಬ್‌ ದಿದಾತೊ, ಬಾದ್‌ಮ ಮೇ ಕೆವ್ಹಿ ಹಕ್‌ಥಿ ಆ ಖ್ಹಾರು ಕರುಸ್ ಕರಿ ತುಮುನ ಬೋಲುಸ್” ಕರಿ ಬೋಲಿನ್ ");
INSERT INTO vaa_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","ಬ್ಯಾಪ್ತಿಸ್ಮ ದ್ಯವಾನಿ ಹಕ್‌ ಯೋಹಾನ್ನ ಪರಲೋಕ್‌ಥಿ ಆಯುಕಿ: ಕೊಯ್ನಿ ಅದ್ಮಿಥಿ ಆಯು? ಜವಾಬ್‌ ದೆವೊ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","ತದೆ ಇವ್ಣೆ ಇವ್ಣ-ಇವ್ಣ ಮಹಿಸ್ ವಾತೆಚೀತೆ ಕರ್ತುಹುಯಿನ್, “ಅಪ್ಣೆ ಶಾತ್ ಬೋಲಿಯೆ? ‘ಪರಲೋಕ್‌ಥಿ ಆಯು’ ಕರಿ ಅಪ್ಣೆ ಬೋಲ್ಯಾತೊ, ‘ಇಮ್‍ಕತೊ ತುಮೆ ಶನ ಯೋಹಾನ್ನ ನಂಬ್ಯಾಕೊಯ್ನಿ?’ ಕರಿ ಬೋಲ್‌ಶೆ, ");
INSERT INTO vaa_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","‘ಅದ್ಮಿಥಿ ಆಯು’ ಕರಿ ಬೋಲ್ಯಾತೊ ಶಾತ್‌ ಹುವ್ವಾಸ್‌ಕಿ” ಕರಿ ಬೋಲಾಲಗ್ಯು. ಶನಕತೊ ಯೋಹಾನ ಏಕ್‌ ಪ್ರವಾದಿ ಕರಿ ತಮಾಮ್‌ ಅದ್ಮಿ ಗುಮಾನಿಕೊಂತೆ ನಂಬಿರಾಖ್ಯುಥು. ಇನಾಖ್ಹಾಜೆ ಇವ್ಣುನ ಅದ್ಮಿನೊ ಡರ್‌ ಥೊ. ");
INSERT INTO vaa_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","ಅನಖ್ಹಾಜೆ ಇವ್ಣೆ, “ಹಮೂನ ಮಾಲುಮ್‌ ಕೊಯ್ನಿ” ಕರಿ ಯೇಸುನ ಜ಼ಬಾಬ್‌ದಿದು. ತದೆ ಯೇಸುನೆ ಇವ್ಣುನ, “ಮೇಬಿ ಖೆವಿ ಹಕ್‌ಥಿ ಆ ಖ್ಹಾರು ಕರೂಸ್ಕಿ, ಯೋ ತುಮುನ ಕೋ ಬೋಲೂನಿ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","ತದೆ ಯೇಸುನೆ ಇವ್ಣ ಜೋ಼ಡೆ ಮತ್ಲಬ್‌ನಿ ಖೇಣಿಯೇಥಿ ಬೋಲಾಲಗ್ಯೋಕಿ, “ಏಕ್‌ ಅದ್ಮಿನೆ ಏಕ್‌ ದ್ರಾಕ್ಷಿನು ಬಾಗ್ ಬಣೈನ್, ಇನ ಅಶ್‌ಪೀಶ್‌ ವಾಡ್‌ಗಿ ನಖೈನ್, ದ್ರಾಕ್ಷಿನೊ ರಖ್ಹ್‌ ಕಾಡಾನಖ್ಹಾಜೆ ಖಾಡ್ ಖೋಂದಾಯೊ ಅಜು಼ ಕಾವ್ಲಿನಖ್ಹಾಜೆ ಉಪ್ಪರ್ ಅಟ್‌ಲೊ ಭಂದಾಯೊ. ಅಜು಼ ಇನೆ ಯೋ ದ್ರಾಕ್ಷಿನಬಾಗ್‌ನ ವಾರ್‌ ಕರಾವಾಳವ್‌ನ ದೀನ್, ಘರ್‌ಥೊ ನಿಕ್ಳಿನ್ ದೇಖ್ಹ್‌ಪರ್ ಚ಼ಲೆಗಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","ಪಂಡು ಪಾಕಾನ ಹಗಾಮ್‌ ಆವಾದಿನ್, ವಾರ್‌ನ ದೀರಾಖ್ಯೊಥೋತೆ ಇವ್ಣಾಕಂಥು ದ್ರಾಕ್ಷಿನ ಪಂಡಾಮ ಭಾಗ್‌ ಲ್ಯವಾನಟೇಕೆ, ಏಕ್‌ ಆಳ್‌ನ ಇವ್ಣಾಕನ ಮೋಕ್‌ಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","ಇವ್ಣೆ ಯೋ ಆಳ್‌ನ ಧರಿಲೀನ್, ಇನ ಮಾರಿನ್, ಖಾಲಿಹಾತೆ ಮೋಕ್ಲಿದಿದು. ");
INSERT INTO vaa_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","ತದೆ ಯೋ ಬಾಗ್‌ನ ಯಜಮಾನ್ನೆ ಬಿಜ್ಜೇಕ್‌ ಜ಼ಣ ಆಳ್‌ನ ಮೋಕ್‌ಲ್ಯೊ; ಯೋ ವಾರ್‌ನ ಲೀರಾಖ್ಯುಥೂತೆ ಇವ್ಣೆ ಇನ ಮುಡ್‌ಕ್ಯಪರ್ ಮಾರಿನ್ ಖ್ಹರಮ್‌ ಕಾಡಿನ್ ಮೋಕ್‌ಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","ಅನ ಬಾದ್‌ಮ ಯೋ ಬಾಗ್‌ನ ಯಜಮಾನ್ನೆ ಬಿಜ್ಜೇಕ್‌ ಜ಼ಣ ಆಳ್‌ನ ಮೋಕ್ಲಾಖ್ಹತರ್‌ ಇನ ಮಾರಿ ನಾಖಿದಿದು; ಅಜೂ಼ಬಿ ಕೈಯೆಕ್ಕಿ ಜ಼ಣಾನ ಮೋಕ್‌ಲ್ಯೊ, ಇವ್ಣಾಮ ಥೋಡ ಜ಼ಣಾನ ಮಾರ‍್ಯು ಅಜು಼ ಥೋಡ ಜ಼ಣಾನ ಕತ್ರಿನಾಖಿದಿದು. ");
INSERT INTO vaa_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","ಯೋ ಬಾಗ್‌ನೊ ಯಜಮಾನ್ನೆ ಬಿಜು಼ ಎಕ್ಕಸ್ ಜ಼ಣೊ ರಹಿಗಯೋಥೊ. ಯೋ ಕೋಣ್‌ಕತೊ ಇನೊ ಲಾಡ್‌ನೊ ಛಿಯ್ಯೊ. ತದೆ ಇನೆ ಸೋಚ್ಯೊಕಿ, ‘ಮಾರ ಛಿಯ್ಯಾನ ದೇಖಿನ್‌ ಮರ್ಯಾದಿ ದಿಶೆ’ ಕರಿ ಯಜಮಾನ್ನೆ ಖ್ಹರ್ತಿಮ ಇನ ಛಿಯ್ಯಾನ ಯೋ ವಾರ್ ಕರವಾಳಾವ್‌ಕನ ಮೋಕ್‌ಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","ಕತೋಬಿ ಯೋ ವಾರ್‌ನ ಕರಿರಾಖ್ಯೂಥೂತೆ ಅದ್ಮಿಖ್ಹಾರು ಇನ ದೇಖಿನ್‌, ‘ಆಸ್ ಬಾಗ್‌ನೊ ಯಜಮಾನ್ನೊ ಛಿಯ್ಯೊ. ಆವೊ, ಅನ ಮಾರಿನಾಖಿದಿಯ್ಯೆ, ತದೆ ಇನು ಶೊತ್ ಖ್ಹಾರು ಅಪ್ಣು ಹುಯಿಜಾ಼ಶೆ!” ಕರಿ ಏಕ್‌ನ ಜೋ಼ಡೆ ಏಕ್‌ ವಾತೆ ಕರಿಲೀನ್, ");
INSERT INTO vaa_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","ಇನ ಛಿಯ್ಯಾನ ಧರೀನ್ ಮಾರಿನಾಖಿದೀನ್‌, ದ್ರಾಕ್ಷಿನ ಬಾಗ್‌ನ ಭಾರ್ ಫೇಕಿದಿದು. ");
INSERT INTO vaa_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","ಇಮ್‍ಕತೊ, ದ್ರಾಕ್ಷಿನ ಬಾಗ್‌ನೊ ಯಜಮಾನ್ ಶಾತ್‌ ಕರ್ಶೆ? ಯೋ ಐನ್ ದ್ರಾಕ್ಷಿನ ಬಾಗ್‌ನ ವಾರ್‌ನ ಲೀರಾಖ್ಯುಥೂತೆ ಇವ್ಣುನ ಮಾರಿನಾಖಿದೀನ್‌, ಇನು ದ್ರಾಕ್ಷಿನ ಬಾಗ್‌ನ ಬಿಜಾ಼ನ ದಿನಾಕ್‌ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","‘ಘರ್ ಭಾಂದಾವಾಳು ನಕೊಕರಿ ಧಕೇಲೈ ಗಯೋತೆ ಬಂಡೋಸ್, ಹೋಣುತೆ ಕೋಣಾನೊ ಬಂಡೊ ಹುಯೊ. ಅಮ್ಕರಿ ಧರ್ಮಶಾಸ್ತ್ರಮ ಪಢಿರಾಖ್ಯಸ್ನಿ! ");
INSERT INTO vaa_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","ಹೈರುತೆ ಪ್ರಭುನೇಸ್ ಕರ‍್ಯೊತೆ; ಆ ಅಪ್ಣ ಡೋಳಾಮ ಅಶ್ಚರ್ಯ ದೆಖಾವಸ್ನಿ!” ");
INSERT INTO vaa_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","ಆ ಅಪ್ಣೀಸ್‌ ಬಾರೇಮ ಆ ಮತ್ಲಬ್‌ನಿ ಖೇಣಿ ಬೋಲ್ಯೊ ಕರಿ ಇವ್ಣೆ ಮಾಲುಮ್‌ ಕರಿಲೀನ್ ಯೇಸುನ ಧರ್‌ನು ಕರಿ ಕೋಶಿಶ್ ಕರ‍್ಯು. ಕತೋಬಿ ಅದ್ಮಿನ ಡರ್‌ಥಿ ಇನ ಮ್ಹೆಂದಿನ್ ಚ಼ಲಿಗಯು, ");
INSERT INTO vaa_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","ಅನ ಬಾದ್‌ಮ ಇವ್ಣೆ ಯೇಸುನ ವಾತೆಮ ಫಖ್ಹಾವ್ಣು ಕರಿ, ಫರಿಸಾಯರ್ ಅಜು಼ ಹೆರೋದನಿ ಝೂ಼ಂಡ್‌ಥು ಥೋಡ ಜ಼ಣಾನ ಇನಾಕನ ಮೋಕ್‍ಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","ಇವ್ಣೆ ಇನಾಕನ ಐನ್ ಬೋಲ್ಯೂಕಿ, “ಗುರು, ತೂ ಖ್ಹಾಚಿಸ್ ಬೋಲಾಸ್, ಕಿನಾಬಿ ದೇಖಿನ್‌ ಡರಾಕೊಯ್ನಿ, ತು ಅದ್ಮಿನು ಮ್ಹೋಡುದೇಖಿನ್‌ ವಾತೆ ಕೋ ಬೋಲಾನಿ. ಕತೋಬಿ ಅದ್ಮಿನಿ ಬಾರೇಮ ದೇವ್ನಿ ಮರ್ಜಿ ಶಾತ್‌ ಛಾ಼ಕಿ ಯೋ ಬೋಲಿವತಾಳಸ್ ಕರಿ ಹಮೂನ ಮಾಲುಮ್‌. ಕೈಸರ್‌ನ ಶುಂಕ ದೆವಾನು ನಿಯಮ್‌ಕಿ ಕೊಯ್ನಿ? ದೇಣೂಕಿ ನಾ ದೇವ್ಣು” ಕರಿ ಯೇಸುನ ಪುಛಾ಼ಯು. ");
INSERT INTO vaa_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","ತದೆ ಯೇಸುನೆ, ಇವ್ಣೆ ಮಶ್ಲತ್ ಭಂದೈನ್ ಐರ‍್ಹೂತೆ ದೇಖಿನ್, “ಮನ ಫಖ್ಹಾವ್ಣು ಕರಿ ಶನ ದೇಖೊಸ್ತೆ? ಮನ ಏಕ್‌ ರೂಪಾನು ಬಿಲ್ಲು ಲೈನ್‌ ವತಾಳೊ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","ತದೆ ಇವ್ಣೆ ಏಕ್‌ ಬಿಲ್ಲು ಲಾಯು, ತದೆ ಯೇಸುನೆ, “ಆ ಬಿಲ್ಲಾನ ಉಪ್ಪರ್ ಛಾ಼ತೆ ಮ್ಹೋಡಾನಿ ರೂಪ್‌ಬಿ ನಾಮ್ ಕಿನು?” ಕರಿ ಪುಛಾ಼ವಖ್ಹತರ್ ಇವ್ಣೆ, “ಕೈಸರ್‌ನು” ಕರಿ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","ತದೆ ಯೇಸುನೆ, “ಇಮ್‍ಕತೊ, ಕೈಸರ್‌ನು ಶಾತ್‌ ಛಾ಼ಕಿ ಯೋ ಕೈಸರ್‌ನ ದೆವೊ, ದೇವ್ನ ದೇವ್ಣುತೆ ದೇವ್ನ ದೆವೊ” ಕರಿ ಬೋಲ್ಯೊ. ಯೇಸುನೆ ಅಮ್ ಬೋಲ್ಯೋತೆ ದೇಖಿನ್ ಇವ್ಣೆ ಘಣು ಆಶ್ಚರ್ಯಖಾದು. ");
INSERT INTO vaa_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","ಅನ ಬಾದ್‌ಮ ಸದ್ದುಕಾಯವಾಳು ಥೋಡು ಜ಼ಣು ಯೇಸುಕನ ಆಯು.ಅವ್ಣೆ ಮರ‍್ಯುಹುಯು ಅದ್ಮಿ ಪಾಛು಼ ಜಿವ್ತುಹುಯಿನ್ ಉಠಾಕೊಯ್ನಿ ಕರಿ ಬೋಲಾವಾಳು. ಅವ್ಣೆ ಯೇಸುನ ಪುಛಾ಼ಯುಕಿ, ");
INSERT INTO vaa_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“ಗುರು, ಏಕ್‌ ಜ಼ಣೊ ಲಡ್ಕಾಕೊಂತೆ ಮರಿಗೋತೊ, ಇನಿ ಬಾವಣ್ಣ ಇನೊ ಭೈ ಕರಿಲೇವ್ಣು. ತದೆ ಇವ್ಣುನ ಲಡ್ಕಾ ಹುಯಾತೊ, ಯೋ ಲಡ್ಕಾ ಮರ‍್ಯೋತೆ ಭೈನ ಲಡ್ಕಾ ಹುಯಿರ‍್ಹಿಶೆ’ ಕರಿ ಮೋಶೆನೆ ಹಮಾರಖ್ಹಾಜೆ ಲೀಖಿರಾಖ್ಯೊಸ್. ");
INSERT INTO vaa_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","ಖ್ಹಾತ್‌ಜ಼ಣ ಭೈಯೆ ಥಾ; ಇವ್ಣಾಮ ಪಹಿಲೊ ಭೈ ವ್ಯಹಾ ಕರೀನ್ ಲಡ್ಕಾಕೊಂತೆ ಮರಿಗಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","ಇನಿ ಬಾಯ್ಕೊನ ಇನ ಪೀಟ್‌ಣೊ ಭೈನೆ ಕರಿಲೀನ್ ಯೋಬಿ ಲಡ್ಕಾಕೊಂತೆ ಮರಿಗಯೊ. ಇಮ್ಮಸ್ ತೀನ್ನೊ ಭೈನಾಬಿ ಹುಯು, ");
INSERT INTO vaa_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","ಇಮ್ಮಸ್ ಖ್ಹಾತೆ ಜ಼ಣಾಬಿ ಯೋ ತಯೇಡಾನ ಕರಿಲೀನ್ ಲಡ್ಕಾಕೊಂತೆ ಮರಿಗಯ. ಖ್ಹಾರಾನ ಬಾದ್‌ಮ, ಯೋ ತಯೇಡಾಬಿ ಮರಿಗೈ. ");
INSERT INTO vaa_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","ಇಮ್‍ಕತೊ, ಮರವಾಳು ಜಿವ್ತುಹುಯಿನ್ ಆವ್‌ಶೇತೆ ಯೋ ದನ್ಮ, ಯೋ ತಯೇಡ ಖೆವಾನಿ ಬಾವಣ್‍ ಹುಯಿರ‍್ಹಿಶೆ? ಶನಕತೊ ಖ್ಹಾತೆ ಜ಼ಣಾಬಿ ಇನ ಕರಿಲಿದಾಥಾನಿ” ಕರಿ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","ಯೇಸುನೆ ಇವ್ಣುನ, “ತುಮೆ ಕೆತ್ರೆ ಗಲ್ತಿಮ ಶನ ಛಾ಼ಕರಿ ಮಾಲುಮ್ ಕಿಶು? ಶನಕತೊ ತುಮೂನ ದೇವ್ನಿ ವಚನ್‌ಬಿ ನಾತೊ ದೇವ್ ಕೆತ್ರೆ ಶಕತ್‌ವಾಳೊ ಕರೀಬಿ ಮಾಲುಮ್‌ಕೊಯ್ನಿ. ");
INSERT INTO vaa_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","ಮರವಾಳು ಜಿವ್ತುಹುಯಿನ್ ಆವ್‌ಶೇತೆ ತದೆ, ಇವ್ಣೆ ಸೊರ್ಗಥು ದೇವ್‌ನು ದೂತರ್‌ನಿ ಘೋಣಿ ರ‍್ಹಿಶೆ ಅಜು಼ ವ್ಯಹಾ ಕರ್‌ಶೆಬಿ ಕೊಯ್ನಿ, ವ್ಯಹಾ ಕರಿದಿಶೇಬಿ ಕೊಯ್ನಿ. ");
INSERT INTO vaa_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","ಕತೋಬಿ ‘ಮರವಾಳು ಜಿವ್ತುಹುಯಿನ್ ಉಟ್‍ಶೇತೆ’ ಇನಿ ಬಾರೇಮ ಬೋಲ್‌ನು ಕತೊ, ‘ಮೇ ಅಬ್ರಹಾಮ್‌ನೊ ದೇವ್, ಇಸಾಕನೊ ದೇವ್, ಯಾಕೋಬನೊ ದೇವ್’ ಕರಿ ದೇವ್ನೆ ಮೋಶೆನ ಬೋಲ್ಯೊತೆ ಇನ ಮೋಶೇನು ಪುಸ್ತಕ್‌ಮ ಆಗ್‍ನಿ ಡಾಗ್‌ನಿ ಬಾರೇಮ ಛಾ಼ತೆ ವಚನ್ನು ಭಾಗ್‌ಮ ಪಢಿರಾಖ್ಯಕೊಯ್ನಿಕಿ ಶು? ");
INSERT INTO vaa_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","ಇವ್ಣೆ ಮರಿಗಯಾತೋಬಿ ದೇವ್ನ ಜೋ಼ಡ್ಮ ಜಿವ್ತು ಹುಯಿನ್ ಛಾ಼; ಇನಖ್ಹಾಜೆ ಯೋ ಜಿವ್ತಾನೊ ದೇವ್ ಹುಯಿರ‍್ಹೋಸ್ತೆ ಪಣ್ಕಿ ಮರ‍್ಯಾಹುಯಾನೊ ಕಾಹೆ, ತುಮೆ ತೀರ್‌ಚಾಸ್ ಗಲ್ತಿಮ ಪಡ್ಯಾಸ್” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","ಹಿಜ್ಜಾ಼ ಮೋಶೆನಿ ವಚನ್‍ ಶಿಕಾಡವಾಳೊ ಶಾಸ್ತ್ರಿಮ ಏಕ್‌ ಜ಼ಣೊ ಇವ್ಣೆ ಚರ್ಚೆ ಕರುಕರಾತೆ ಖ್ಹಮ್‌ಜಿನ್‌, ಯೇಸುನೆ ಸದ್ದುಕಾಯವಾಳನ ಅಛ್ಛು಼ ಜವಾಬ್‌ ದಿದೋತೆ ದೇಖಿನ್, ಯೇಸುಕನ ಐನ್, “ಖ್ಹಾರಿ ಹುಕುಮ್‌ಮ ಮೋಟಿ ಹುಕುಮ್‌ ಖೆವಿ” ಕರಿ ಪುಛಾ಼ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","ತದೆ ಯೇಸುನೆ, “ಇಸ್ರಾಯೇಲ್‌ನು ಅದ್ಮಿ ಖ್ಹಮಜ಼್! ಖ್ಹಾರೇಥಿ ಮೋಟಿ ಹುಕುಮ್ ಖೆವಿಕತೊ, ‘ಅಪ್ಣೊ ದೇವ್ ಹುಯಿರ‍್ಹೋತೆ ಪ್ರಭು ಎಕ್ಕಸ್ ಜ಼ಣೊ ದೇವ್ ಹುಯಿರ‍್ಹೋಸ್.’ ");
INSERT INTO vaa_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","ತಾರೊ ದೇವ್ ಹುಯಿರ‍್ಹೋತೆ ಪ್ರಭುನ ಪೂರ ದಿಲ್‌ಥಿ, ಪೂರ ಜಾನ್‌ಥಿ, ಪೂರ ಮನ್‌ಥಿ, ಪೂರ ಶಕಥ್ಥಿ ಪ್ಯಾರ್ ಕರ‍್ನು. ");
INSERT INTO vaa_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","ಅಜು಼ ಬೇನಿ ಮೋಟಿ ಹುಕುಮ್ ಖೆವಿಕತೊ, ‘ತಾರು ತು ಕಿಮ್ ಪ್ಯಾರ್ ಕರಾಸ್ಕಿ ಇಮ್ಮಸ್ ತಾರ ಭೀಡೆವಾಳಾನ ಪ್ಯಾರ್ ಕರ‍್ನು’. ಆ ಬೇ ಹುಕುಮ್‌ಥಿ ಮೋಟಿ ಹುಕುಮ್‌ ಬಿಜೇಕ್ ಖೆವಿಬಿ ಕೊಯ್ನಿ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","ತದೆ ಯೋ ಶಾಸ್ತ್ರಿನೆ, “ಗುರು, ತೂ ಅಶೇಲ್ ಬೋಲ್ಯೊ, ‘ದೇವ್ ಹುಯಿರ‍್ಹೋತೆ ಪ್ರಭು ಎಕ್ಕಸ್ ಜ಼ಣೊ, ಇನ ಮ್ಹೇಲೀನ್‌ ಬಿಜು಼ ಕೋಣ್‌ಬಿ ದೇವ್ ಕೊಯ್ನಿ, ಕರಿ ತುನೆ ಬೋಲ್ಯೊತೆ ಖ್ಹಾಚಿ. ");
INSERT INTO vaa_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","ಇನ ಪೂರ ದಿಲ್‌ಥಿ, ಪೂರ ಮನ್‌ಥಿ ಅಜು಼ ಪೂರ ಶಕಥ್ಥಿ ಪ್ಯಾರ್ ಕರ‍್ನು; ಅಜು಼ ಇನು ಯೋ ಕಿಮ್ ಪ್ಯಾರ್ ಕರಿಲೇಸ್ಕಿ, ಇಮ್ಮಸ್ ಇನ ಭೀಡೆವಾಳಾನ ಪ್ಯಾರ್ ಕರ‍್ನು. ಆ ಬೇ ಹುಕುಮ್‌ ದೇವ್ನ ಖ್ಹಾಮೆ ಅಖ್ಖಯೇಕ್‌ ಶರೀರ್‌ನ ಬಲಿದ್ಯವಾನು ದೆವಾಥೀಬಿ ಅಜು಼ ಬಿಜಿ ಖ್ಹಾರಿ ಜಾನ್ವರ್‌ನ ಬಲಿಥೀಬಿ ಮೋಟು ಹುಯಿರ‍್ಹೂಸ್” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","ಇನೆ ಸೋಚಿಪರ್‌ಖಿನ್ ಜವಾಬ್‌ ದಿದೊತೆ, ಯೇಸುನೆ ದೇಖಿನ್‌, “ತೂ ದೇವ್ನಿ ರಾಜ್ಯಥಿ ದೂರ್‌ಲ್ಯೊ ಕಾಹೆ” ಕರಿ ಬೋಲ್ಯೊ. ಅನ ಬಾದ್‌ಮ ಯೇಸುನ ಬಿಜು಼ ಶಾತ್ಬಿ ಪುಛಾ಼ವನ ಕಿನೇಬಿ ಹಿಮ್ಮತ್ ಕೋ ಕರ‍್ಯುನಿ. ");
INSERT INTO vaa_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","ಯೇಸು ಮಂದಿರ್‌ಮ ವಚನ್ ಬೋಲಿದೇವ್‌ಕರ್‌ತೋಥೊ, ತದೆ ಇನೆ ಪುಛಾ಼ಯೊಕಿ, “ಮೋಶೆನಿ ವಚನ್ ಶಿಕಾಡವಾಳು ಶಾಸ್ತ್ರಿಖ್ಹಾರು ಮೆಸ್ಸೀಯ ದಾವೀದ್‌ನೊ ಛಿಯ್ಯೊ, ಕರಿ ಬೋಲಾಸ್ನಿ, ಯೋ ಕಿಮ್ ಉಶೆ? ");
INSERT INTO vaa_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","‘ಮೇ ತಾರು ದುಶ್‌ಮನ್ನ ಖ್ಹಾರು ತಾರ ಗೋಡಾನ ಹೇಟ್‌ ನಾಖಾಲಗು ಮಾರಿ ಖಾವಿ ಬಾಜು಼ಮ ಬೆಠೋರೆ, ಕರಿ ಪ್ರಭು ಹುಯಿರ‍್ಹೋತೆ ದೇವ್ನೆ ಮಾರ ಮಾಲಿಕ್‌ನ ಬೋಲ್ಯೊ’ ಕರಿ ಪವಿತ್ರಾತ್ಮನೆ ದಾವೀದನ ಮ್ಹೋಡಾವಾಟೆ ಬೋಲಾಯೋನಿ. ");
INSERT INTO vaa_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","ದಾವೀದಸ್‌ ಕ್ರಿಸ್ತನ ಪ್ರಭುಕರಿ ಬೋಲಾಪರ್ ಕ್ರಿಸ್ತ ದಾವೀದ್‌ನೊ ಛಿಯ್ಯೊ ಕಿಮ್ ಉಶೆ?” ಯೇಸುನಿ ವಾತೆನ ಘಣು ಅದ್ಮಿ ಖ್ಹುಶೀಥಿ ಖ್ಹಮ್‍ಜು಼ಕರ್ತುಥು. ");
INSERT INTO vaa_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","ಯೇಸುನೆ ವಚನ್ ಬೋಲಿ ದೇತೊಹುಯಿನ್ ಬೋಲ್ಯೋಕಿ, “ಮೋಶೇನು ವಚನ್ ಶಿಕಾಡವಾಳು ಶಾಸ್ತ್ರಿಯೇನಿ ಬಾರೇಮ ಹೊಷಾರ್‌ಥಿ ರ‍್ಹವೊ. ಇವ್ಣೆ ಘಣ ಮೋಲ್ನು ಝ಼ಗ್ಗೊ ಪೇರ‍್ಹಿಲೀನ್‌ ಹೈಕಡ್‌ಹೀಕಡ್‌ ಫರ್‌ವಾನು, ದುಕಾನೇನಿ ಗಲ್ಲಿಮ ಅದ್ಮಿಖ್ಹಾರು ಇವ್ಣುನ ಮರ್ಯಾದಿ ದೀನ್ ಖ್ಹಲಾಮ್ ಕರ್ನುಕರಿ, ");
INSERT INTO vaa_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","ಅಜು಼ ಸಬೆ ಭರಾವಾನು ಮಂದಿರ್‌ಮ ಅಖ್ಖಾನ ಖ್ಹಾಮೆ ಬೇಖ್ಹ್‌ಣು ಕರಿ, ಮಾನ್-ಮಿಝ಼್‌ವಾನೇನಿ ಝ಼ಗೋಮ ಅಖ್ಖಾನ ದೆಖಾವಾನಿ ಘೋಣಿ ಖ್ಹಾಮೆ ಬೇಖ್ಹ್‌ಣು ಕರಿ ಖಲಿ ಅಮ್ಮಸ್ ಆಖ್ಹ್ ಕರ್ತುರ‍್ಹೇಸ್‌. ");
INSERT INTO vaa_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","ಇವ್ಣೆ ಮುಂಡಚ್ಚಿ ತಯೇಡಾವ್‌ನ ಠಗೈನ್ ಇವ್ಣ ಘರ್‌ನ ಲೂಟಿಲೇಸ್ ಅಜು಼ ಅದ್ಮಿನ ವತಾಳಿಲ್ಯಾವನಖ್ಹಾಜೆ ಲಾಂಬಿ ಪ್ರಾರ್ಥನೆ ಕರಾಸ್. ಅವ್ಣಪರ್ ಘಣೇಥಿ ಘಣಿ ನಿಶತ್‌ ಮಳ್‍ಶೆ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","ಯೇಸು ಮಂದಿರ್‌ನಿ ಹುಂಡಿನ ಖ್ಹಾಮ್ಣೆನಿ ಬಾಜೂ಼ಮ ಬೇಶಿನ್, ಅದ್ಮಿಖ್ಹಾರು ಪೈಶಾ ನಾಖಾತೆ ದೇಖುಕರ್ತೊಥೊ. ಕೈಯೆಕ್ಕಿ ಧನ್‌-ದೌಲತ್‌ವಾಳು ಅದ್ಮಿ ಘಣು-ಘಣು ನಾಖ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","ತದೆ ಹಿಜ್ಜಾ಼ ಏಕ್‌ ಗರೀಬ್ ಮುಂಡಚ್ಚಿ ತಯೇಡ ಐನ್, ಬೇ ತಾಂಬಾನು ಕಾಖ್ಹ್‌, ಕತೊ ಏಕ್‌ ಪೈಶಾ ನಾಖಿ. ");
INSERT INTO vaa_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","ತದೆ ಯೇಸುನೆ ಇನ ಶಿಷ್ಯರ್‌ನ ಖನ್ನೆ ಬುಲೈನ್, “ಮೇ ತುಮೂನ ಖ್ಹಾಚ ಬೋಲುಸ್ಕಿ ಹುಂಡಿಮ ಖ್ಹಾರೇಥಿ ಜಾ಼ಖ್ಹತ್ ಆ ಗರೀಬ್ ಮುಂಡಚ್ಚಿ ತಯೇಡ ನಾಖಿರಾಖಿಸ್‌. ");
INSERT INTO vaa_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","ಕಿಮ್ ಕತೊ, ಖ್ಹಾರು ಇವ್ಣುನ ಬಶ್‌ಹುಯಿನ್ ಉಭ್‌ರ‍್ಯುತೆ ಇನಾಮಾಥು ಥೋಡು ನಾಖ್ಯು; ಕತೋಬಿ ಆ ಹೈರಿತೆ, ಅತ್ರೆ ಗರೀಬ್ ರ‍್ಹೀನ್‌ಬಿ, ಇನಾಕನ ಥೂತೆ ಖ್ಹಾರುಸ್‌ ನಾಖಿದಿದಿ, ಇನು ಜಿವ್ಣು ಚ಼ಲಾವಾನ ಥೂತೆ ಖ್ಹಾರೂಸ್ ನಾಖಿದಿದಿ”. ");
INSERT INTO vaa_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","ಮಂದಿರ್‌ನ ಮ್ಹೆಂದಿನ್ ಜಾ಼ವಾನಿ ವಖ್ಹತ್‌ಮ, ಇನ ಶಿಷ್ಯರ್‌ಮ ಏಕ್‌ ಜ಼ಣಾನೆ ಇನ, “ಗುರು, ಹಂದೇಕ್‌ ಕಿಮ್ನ ಬಂಡಾ! ಆ ಮಂದಿರ್‌ನ ಕಿಮ್ ಬಣೈರಾಖ್ಯೂಸ್ತೆ!” ಕರಿ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","ತದೆ ಯೇಸುನೆ, “ಆ ಕೆತ್ರೆ ಮೋಟುಘರ್ ಬಣೈರಾಖ್ಯೂಸ್‌ ಕರಿ ತೂ ದೇಖುಕರಾಸ್‌ ಕೊಯ್ನಿಕಿ ಶು? ಹಜ್ಜಾ಼ ಏಕ್‌ ಬಂಡಾಪರ್ ಬಿಜೇಕ್ ಬಂಡೊ ಭೀರಿಶೆ ಕೊಯ್ನಿ; ಅಖ್ಖಾಸ್ನ ರಡ್‌ಕೈನಾಖಿದಿಶೆ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","ಬಾದ್‌ಮ ಯೇಸು ಆಲಿವ್‌ ಪಹಾಡ್‌ಪರ್ ದೇವ್ನಿ ಮೋಟಿ ಮಂದಿರ್‌ ಭಣಿ ಮ್ಹೋಡು ಕರೀನ್ ಬೆಠೋಥೊ. ತದೆ ಪೇತ್ರ, ಯಾಕೋಬ್, ಯೋಹಾನ ಅಜು಼ ಅಂದ್ರೆಯ ಯೇಸು ಎಕ್ಲೊ ರ‍್ಹವಾನಿ ವಖ್ಹತ್‌ಮ ಇನಾಕನ ಆಯ. ");
INSERT INTO vaa_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","ತದೆ ಇವ್ಣೆ ಇನ, “ಆ ಖ್ಹಾರು ಕದೆ ಉಶೆ? ಆ ಖ್ಹಾರು ಹುವಾನ ವಖ್ಹತ್ ಐಗಿ ಕರಿ ಮಾಲುಮ್ ಪಡಾನಟೇಕೆ ಶಾತ್ ಚಾ಼ಲ್‌ಷೆ, ಕರಿ ಹಮೂನ ಬೋಲ್” ಕರಿ ಪುಛಾ಼ಯ. ");
INSERT INTO vaa_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","ತದೆ ಯೇಸುನೆ ಇವ್ಣುನ, “ಹೊಷಾರ್‌ಥಿ ರ‍್ಹವೊ, ಅಜು಼ ತುಮೂನ ಕೋಣ್‌ಬಿ ಠಗಾವ್ಣುನಾತೆ ಇಮ್‌ ದೇಖಿಲೇವೊ. ");
INSERT INTO vaa_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","ಕೈಯೆಕ್ಕಿ ಜ಼ಣು ಆಯಿನ್ ಮಾರು ನಾಮ್ ಬೋಲಿಲಿನ್, ‘ಮೇ ಕ್ರಿಸ್ತ, ಮೇ ಕ್ರಿಸ್ತ’ ಕರಿ ಘಣ ಅದ್ಮಿನ ಧೋಕ ಕರ್ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","ಅತ್ರೇಸ್ ಕಾಹೆತೆ ತುಮೆ, ಖನ್ನೆ ಜಂಗ್ ಭೀಡುಕರಾತೆ ಅವಾಜ಼್ ಅಜು಼ ದೂರ್ ಜಂಗ್ ಭೀಡುಕರಾತೆ ಖಬರ್‌ನ ಖ್ಹಮ್‌ಜ್ಯಾತೊ ಘಬ್ರಾವೊ ನಕೊ. ಅಮ್ನು ಖ್ಹಾರು ಚಾ಼ಲ್ನುಸ್ ಚಾ಼ಲ್ನು. ಕತೋಬಿ ಅನಿ ಮತ್‌ಲಬ್ ಜಗತ್‌ ಖತಮ್ ಹುಯಿಜಾ಼ವಾನ ಆಯುಕರಿ ಕಾಹೆ. ");
INSERT INTO vaa_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","ದೇಖ್ಹ್‌ಥಿ ದೇಖ್ಹ್‌ ಲಡೈ ಪಡ್‌ಶೆ; ಏಕ್‌ ರಾಜ್ಯಪರ್ ಬಿಜೇಕ್‌ ರಾಜ್ಯ ಲಡೈನ ಉಟ್‌ಶೆ. ಖ್ಹಾರಿ ತರಬ್‌ ಜ಼ಮೀನ್ ಹಲ್‌ಶೆ, ಅಜು಼ ಕಾಳ್ದುಕಾಳ್ ಉಶೆ. ಆ ಖ್ಹಾರು ಲಡ್ಕು ಪೈದಾ ಹುವಾನಿ ವಖ್ಹತ್‌ಮ ಆವಾತೆ ಪಹಿಲಿ ಅಜಾ಼ನಿಘೋಣಿ ಹುಯಿರ‍್ಹುಸ್‍. ");
INSERT INTO vaa_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","ಕತೋಬಿ ತುಮೆ ತುಮಾರಿ ಬಾರೇಮ ಹೊಷಾರ್‌ಥಿ ದೇಖಿಲೆವ್ಣು. ತುಮೂನ ಧರೀನ್ ನ್ಯಾವ್ ಕರಾನಿ ಸಭೆಮ ಖೇಚಿಲಿಜಾ಼ಶೆ. ತುಮುನ ಸಬೆ ಭರಾವಾನು ಮಂದಿರ್‌ಮ ಮಾರ್‌ಶೆ; ಮಾರಖ್ಹಾಜೆ ತುಮೆ ರಾಜ಼್‌ಭಾರ್‌ ದೇಖಿಲೆವಾಳಾನ ಖ್ಹಾಮ್ಣೆಬಿ ಅಜು಼ ರಾಜಾ಼ನ ಖ್ಹಾಮ್ಣೆ ಸಾಕ್ಷಿಕರಿನ್ ಭೀರಾಕ್‌ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","ಕತೋಬಿ ಜಗತ್‌ ಖತಮ್ ಹುವಾನ ಅಗಾಡಿ, ತಮಾಮ್‌ ಜ಼ಗ್‌ಜಾ಼ತ್‌ವಾಳನ ದೇವ್ನಿ ಅಛ್ಛಿ ಸಮಾಚಾರ್‌ನ ಬೋಲ್‌ನು. ");
INSERT INTO vaa_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","ತುಮುನ ಧರೀನ್ ನ್ಯಾವ್ ಕರಾನಿ ಝ಼ಗೊ ಲೀಗಯೂತೊ, ಶಾತ್‌ ಬೋಲ್ನುಕರಿ ಪಹಿಲೇಸ್ ಧಡುಕೊ ನಕೊಘಾಲೊ. ಯೋ ವಖ್ಹತ್‌ಮ ಶಾತ್‌ ಬೋಲ್ನುಕರಿ ದೇವ್ ಯಾದ್ ದೇಸ್ಕಿ ಯೋಸ್‌ ಬೋಲೊ. ಶನಕತೊ ತುಮೆ ಬೋಲ್‌ಶುತೆ ವಾತೆ ತುಮಾರಿ ಕಾಹೆ; ಪವಿತ್ರಾತ್ಮಾಥಿ ಐತೆ ವಾತೆ ಹುಯಿರ‍್ಹಿಶೆ. ");
INSERT INTO vaa_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","ಅತ್ರೇಸ್ ಕಾಹೆತೆ ಏಕ್‌ ಭೈ ಇನ ಶೊಂತ್ ಭೈನ ಮಾರಿನಾಖಾನ ದಿನಾಕ್‌ಶೆ, ಇಮ್ಮಸ್ ಬಾಬಿ ಇನ ಲಡ್ಕಾವ್ನ ಮರಾವ್‌ಶೆ. ಲಡ್ಕಾ ಉಠೀನ್ ಇವ್ಣ ಆಯ-ಬಾನ ಧೋಕೊದೀನ್ ಮರಾವ್‌ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","ಅಜು಼ ಮಾರ ನಾಮ್ನಟೇಕೆ ಹರೇಕ್ ಅದ್ಮಿ ತುಮುನ ವಹೇರ್‌ ಕರ್ಶೆ. ಕತೋಬಿ ಆಖ್ರಿ ದಮ್‌ತೋಡಿ ಖ್ಹಮಾಳಿಲ್ಯವಾಳು ದೇವ್ನಿ ನ್ಯಾವ್‍ನಿ ತೀರ್ಪ್‌ಥಿ ರಕ್ಷಣೆಲೀನ್ ಪರ್‌ಲೋಕ್‌ಮ ಜಾ಼ವಾನ ಲ್ಹಾಯಕ್‌ ಉಶೆ. ");
INSERT INTO vaa_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","ಅತ್ರೇಸ್ ಕಾಹೆತೆ ‘ಬರ್ಬಾತ್ ಕರಾವಾಳು ಖರಾಬ್ ರಾಛು಼’ ಯೋ ಭೀರೆವ್ಣುನಾತೆ ಝ಼ಗೋಪರ್ ಭೀರಾವನು ತುಮೆ ದೇಕ್‌ಶು. ಅನ ಪಢವಾಳು, ಅನಿ ಮತ್ಲಬ್‌ನ ಪರ್ಖಿಲ್ಯಾವದೆ. ತದೆ ಯೂದಾಯಮ ರ‍್ಹವಾಳು ಪಹಾಡೋಮ ಮಿಲೈಜಾ಼ಣು. ");
INSERT INTO vaa_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","ಕೋಣ್‌ತೋಬಿ ಏಕ್‍ಜ಼ಣೊ ಇನ ಘರ್‌ನ ಛ಼ತ್‍ಪರ್‌ ರ‍್ಹಯೋತೊ, ಯೋ ಹೇಟ್ ಉತ್ರಿನ್ ಶಾತ್‌ತೋಬಿ ಪಾಡಿಲೇಣು ಕರಿ ಘರ್‌ನ ಮಹಿ ಜೈ಼ನ್, ವಖ್ಹತ್ ಬರ್ಬಾತ್ ನಾ ಕರ‍್ನು. ");
INSERT INTO vaa_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","ಖೇತರ್‌ಮ ರ‍್ಹವಾಳು ಕೋಣ್‌ತೋಬಿ ಝ಼ಗ್ಗೊ ಪಾಡಿಲೇಣು ಕರಿ ಪಾಛು಼ಫರಿ ಘರೆ ನಾ ಜಾ಼ವ್ಣು. ");
INSERT INTO vaa_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","ಕತೋಬಿ ಯೋ ದನೂಮ ಬೇಜೂನಿ ಅಜು಼ ದೂದ್ ಪಿಡಾವವಾಳಿ ತಯೇಡಾವ್ನ ಉಷೇತೆ ವದೇಖ್ಹ್‌ನ ಶಾತ್‌ ಬೋಲು! ");
INSERT INTO vaa_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","19","ಯೋ ದನೂಮ ಘಣು ಲತಾಡ ರ‍್ಹಿಶೆ. ಇನಾಖ್ಹಾಜೆ ಆ ಖ್ಹಾರು ವರ್ಖ್ಹಾತ್ ಅಜು಼ ಠಣ್ಣಾ ದನೂಮ ನಾ ಹೋಣು ಕರಿ ಪ್ರಾರ್ಥನೆ ಕರೊ, ಶನಕತೊ ಇಮ್‌ನೊ ವದೇಖ್ಹೊ ದೇವ್ನೆ ಜಗತ್‌ ಉಬ್‌ಜಾ಼ಯೋತೆ ತಪ್‌ಥು ಧರೀನ್ ಹಮ್ಕೆಲಗು ಕೋ ಹುಯಿರ‍್ಹೂನಿ; ಖ್ಹಾಮ್ಣೇಬಿ ಅಮ್ ಕೋ ಉಶೇನಿ. ");
INSERT INTO vaa_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","ಪ್ರಭು ಯೋ ಖ್ಹಾರ ದನ್ನ ಕಮ್ ನಾ ಕರ‍್ಯೋತೊ, ಏಕ್‌ ಅದ್ಮಿಬಿ ಬಚಿಕೊರ‍್ಹಿಷೇನಿ. ಕತೋಬಿ ಇನೆ ಚೂ಼ಣಿಲಿದೊತೆ ಖ್ಹಾರ ಅದ್ಮಿನಖ್ಹಾಜೆ ಯೋ ಖ್ಹಾರ ದನ್ನ ಕಮ್ ಕರಿರಾಖ್ಯೋಸ್. ");
INSERT INTO vaa_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","ತದೆ ಕೋಣ್‌ತೋಬಿ ತುಮುನ, “ದೇಖೊ, ಕ್ರಿಸ್ತ ಹಜ್ಜಾ಼ ಛಾ಼! ನಾತೊ ‘ಹಂದೇಖೊ, ಯೋ ಹಿಜ್ಜಾ಼ ಛಾ಼!” ಕರಿ ಬೋಲ್ಯುತೊ ಇನ ನಕೊ ನಂಬ್‌ಶು. ");
INSERT INTO vaa_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","ಶನಕತೊ ಝೂ಼ಟುಕ್ರೈಸ್ತರ್‌ ಖ್ಹಾರು ಅಜು಼ ಝೂ಼ಟು ಪ್ರವಾದಿಖ್ಹಾರು ದೆಖೈನ್, ಇವ್ಣೇಥಿ ಹುಯೂತೊ ದೇವ್‍ಥಿ ಚೂ಼ಣೈರ‍್ಹವಾಳನಾಬಿ ಠಗಾವಾನಖ್ಹಾಜೆ ಅದ್ಭುತ್‌ಕಾಮ್‌ ಅಜು಼ ಅಶ್ಚರ್ಯನು ಕಾಮ್‌ಖ್ಹಾರು ಕರಿ ವತಾಳ್‌ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","ಇನಾಖ್ಹಾಜೆ ತುಮೆ ಹೊಷಾರ್‌ಥಿ ರ‍್ಹವೊ! ಯೋ ಖ್ಹಾರು ಹುವಾನ ಅಗಾಡಿಸ್ ಇನಿ ಬಾರೇಮ ಮೇ ತುಮುನ ಬೋಲಿರಾಖ್ಯೊಸ್. ");
INSERT INTO vaa_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","ಅತ್ರೇಸ್ ಕಾಹೆತೆ ಯೋ ದನೂಮ ಯೋ ವದೇಖ್ಹೊ ಖತಮ್ ಹುಯಿಜಾ಼ವಾನ ಬಾದ್‌ಮ ಚಾ಼ಂದ್ ಕಾಳೊಪಡಿಜಾ಼ಶೆ. ಚ಼ಂದರ್‌ಮೊ ಉಜಾ಼ಳು ಕೋ ದಿಶೇನಿ, ");
INSERT INTO vaa_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","ಆಕಾಶ್‌ಪರ್‌ಥು ಶುಕ್ಕರ್‌ಖ್ಹಾರು ಖಂಕ್ರಾಲಗ್‌ಶೆ, ಆಕಾಶ್‌ಮ ಛಾ಼ತೆ ಶಕತ್ ಖ್ಹಾರಿ ಕಾಪಿನ್‌ ಹಟ್‌ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","ತದೆ ಅದ್ಮಿನೊ ಛಿಯ್ಯೊ ಘಣಿ ಶಕತ್‌ಥೀಬಿ, ಉಜಾ಼ಖ್ಹ್‌ಥಿ ಘೈಗ್‌ತೊಹುಯಿನ್‌, ವಾದ್ಳಮಕರಿ ಆವಾನು ಅದ್ಮಿಖ್ಹಾರು ದೇಕ್‌ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","ತದೆ ಯೋ ಇನ ದೂತರ್‌ನ ಜ಼ಮೀನ್ನಿ ಚಾರ‍್ಹೆ ಬಾಜೂ಼ಮ ಮೋಕ್ಲಿನ್‌ ಧರ್ತಿನ ಕಡೇಶಿಥು ಧರೀನ್ ಆಬ್‍ನಿ ಖ್ಹರ್ತಿಲಗು, ಇನೆ ಚೂ಼ಣಿಲಿದೊತೆ ಖ್ಹಾರ ಅದ್ಮಿನ ಜಗತ್‌ನು ಏಕ್‌ ಬಾಜು಼ಥು ಧರಿನ್ ಬಿಜೇಕ್ ಬಾಜೂ಼ಲಗು ಎಕ್ಟು ಕರ್ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","ಮೋಟ ಅಂಜೀರ್‌ನ ಝಾ಼ಡಾಥಿ ಮತ್ಲಬ್‌ನಿ ಅಕ್ಕಲ್ ಶಿಕೊ. ಇನಿ ಡಾಳಿಯೆ ಹರಿಗಾರ್ ಕವ್ಳಿ ಹುಯಿನ್, ಪಾಂದ್‌ಡ ಮ್ಹೇಲಾಲಗ್ಯುತೊ, ತಡ್ಕಾನ ಹಗಾಮ್‌ ಖನ್ನೆ ಐಗು ಕರಿ ಮಾಲುಮ್‌ ಕರಿಲೇವೊಸ್ನಿ. ");
INSERT INTO vaa_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","ಇಮ್ಮಸ್ ತುಮೇಬಿ ಆ ಖ್ಹಾರು ಹುವಾನು ದೇಖ್ಯಾತೊ, ಬಾಕಲ್‌ನ ಖನ್ನೆಸ್‌ ಥೋಕರಿ ಮಾಲುಮ್‌ ಕರಿಲೆವೊ. ");
INSERT INTO vaa_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","ಮೇ ತುಮೂನ ಖ್ಹಾಚಮಾಬಿ ಬೋಲುಸ್ಕಿ ಆ ಜ಼ಮಾನಾನು ಅದ್ಮಿಖ್ಹಾರು ಮರ್‌ವಾನ ಮಹಿಸ್ ಆ ಖ್ಹಾರು ಚಾ಼ಲ್‌ಶೇತೆ ಕರಿ ಯಾದ್‌ರಾಖೊ. ");
INSERT INTO vaa_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","ಆಬ್-ಧರ್ತಿ ಖ್ಹಾರು ಮಟಿಜಾ಼ಶೆ, ಕತೋಬಿ ಮಾರಿ ವಾತೆಖ್ಹಾರಿ ಮಟ್‌ಶೆಸ್ ಕೊಯ್ನಿ. ");
INSERT INTO vaa_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","ಎತ್ರೇಸ್ ಕಾಹೆತೆ ಯೋ ದನ್ನಿ ಬಾರೇಮ ರ‍್ಹವೊ ನಾತೊ ಯೋ ಘಡಿನಿ ಬಾರೇಮ ರ‍್ಹವೊ ಮಾರ ಬಾನ ಮಾಲುಮ್ ಪಣ್ಕಿ ಬಿಜು಼ ಕಿನಾಬಿ ಮಾಲುಮ್‌ಕೊಯ್ನಿ; ಪರ್‌ಲೋಕ್‌ಮ ಛಾ಼ತೆ ದೇವ್‌ನು ದೂತರ್‌ನಾಬಿ ಮಾಲುಮ್‌ಕೊಯ್ನಿ, ಛಿಯ್ಯಾನಾಬಿ ಮಾಲುಮ್‌ಕೊಯ್ನಿ. ");
INSERT INTO vaa_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","ಯೋ ವಖ್ಹತ್ ಕದೆ ಆವ್‍ಶೆಕರಿ ತುಮುನ ಮಾಲುಮ್‌ಕೊಂತೆ ಇನಾಖ್ಹಾಜೆ ಹೊಷಾರ್‌ಥಿರ‍್ಹವೊ, ಕದೇಬಿ ಜ಼ತನ್‌ಥಿರ‍್ಹವೊ. ");
INSERT INTO vaa_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","ಏಕ್‌ ಅದ್ಮಿ ಇನು ಘರ್‌ನ ಮ್ಹೇಲಿನ್ ದೇಖ್ಹ್‌ಪರ್ ಜಾ಼ವಾನಿ ವಖ್ಹತ್‌ಮ, ಇನ ಸೇವಕರ್‌ನ ಬುಲೈನ್ ಘರ್‌ನ ದೇಕ್-ಭಾಲ್‌ ಕರಾನು ಕಾಮ್ನಿ ಅದಿಕಾರ್‌ನ ದಿದೊ. ಏಕೇಕ್‌ ಜ಼ಣಾನ ಇವ್ಣು-ಇವ್ಣು ಕಾಮ್‌ದೀನ್‌, ಘರ್‌ನಿ ಕಾವ್ಲಿ ಕರಾವಾಳನ ಹೊಷಾರಿ ರ‍್ಹೇಣು ಕರಿ ಹುಕುಮ್‌ ದಿದೊ. ಇಮ್ಮಸ್ ಮೇ ತುಮುನ ಹುಕುಮ್‌ ದೆವ್‍ಸ್. ");
INSERT INTO vaa_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","ಘರ್‌ನೊ ಯಜಮಾನ್ ಖ್ಹಾಂಜೇಕಿ, ಅಧಿರಾತ್ಮ, ಮುರ್‌ಗಾ ಬಾಂಗೆಕಿ, ದನ್ ನಿಕ್ಳಾದೀನ್‌ಕಿ, ಕದೆ ಆವ್‍ಶೆಕರಿ ತುಮುನ ಮಾಲುಮ್‌ಕೊಂತೆ ಇನಾಖ್ಹಾಜೆ ಹೊಷಾರ್‌ಥಿ ರ‍್ಹವೊ. ");
INSERT INTO vaa_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","ಯೋ ಮಾಲುಮಸ್ ಪಡಾಕೊಂತೆ ಇಮ್‌ ಆಯೋತೊ, ತುಮೆ ಖ್ಹುತಾರ‍್ಹವಾನು ನಾ ದೇಕ್ಣು. ");
INSERT INTO vaa_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","ಮೇ ತುಮುನ ಬೋಲೂಸ್ತೆ ಇನ ಅಖ್ಖಾನ ಬೋಲುಸ್, ಹೊಷಾರ್‌ಥಿ ರ‍್ಹವೊ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","ಪಸ್ಕ ಪೂಜ಼ ಅಜು಼ ಖಾಟುಕೊಂತೆ ರೋಟಾನಿ ಪೂಜಾ಼ನ ಬೇ ದನ್ ಥಾತೆ ತದೆ, ಗಲ್‌ಢಯಾಜಕರ್‌ ಅಜು಼ ಮೋಶೆನಿ ವಚನ್ ಶಿಕಾಡವಾಳು ಶಾಸ್ತ್ರಿಯೆ ಕಿನಾಬಿ ಮಾಲುಮ್ ನಾಪಡ್ಣುತೆ ಇಮ್‌ ಯೇಸುನ ಧರೀನ್ ಮಾರಿನಾಕ್ಣು ಕರಿ ದೇಖುಕರ್ತುಥು. ");
INSERT INTO vaa_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","ಕತೋಬಿ ಇವ್ಣೆ, “ಪೂಜಾ಼ನಿ ವಖ್ಹತ್‌ಮ ಯೇಸುನ ನಾ ಧರ್‌ನು, ಶನಕತೊ ಅದ್ಮಿಖ್ಹಾರು ಅಪ್ಣಪರ್ ಕಲ್ಹಾಗಟ್‌ನ ಉಟ್‌ಶೆ” ಕರಿ ವಾತೆ ಬೋಲಿಲಿದು. ");
INSERT INTO vaa_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","ಯೇಸು ಬೇಥಾನ್ಯ ಗಾಮ್ಮ ಸೀಮೋನ್ನ ಘರ್‌ಮ ಥೊ, ಆ ಸೀಮೋನ್ನ ಖೋಡ್‍ ಲಾಗಿರ‍್ಹೂಥು. ಹಿಜ್ಜಾ಼ ಯೇಸು ಖಾಣು ಖಾವಾನಿ ವಖ್ಹತ್‌ಮ, ಏಕ್‌ ತಯೇಡ ನಾರ್ಡ್‌ಥಿ ಬಣಾಯುಹುಯು, ಘಣ ಮೋಲ್ನು ವಾನು ತೇಲ್ನ ಬಂಡಾನಿ ಶೀಶಿಮ ಲೀನ್ ಐನ್, ಯೋ ಶೀಶಿನ ಫೋಡಿನ್, ತೇಲ್ನ ಯೇಸುನ ಮಾಥಪರ್ ರಂಚಿ. ");
INSERT INTO vaa_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","ಕತೋಬಿ ಹಿಜ್ಜಾ಼ ಥೂತೆ ಥೋಡು ಜ಼ಣು ಇವ್ಣ-ಇವ್ಣಮ ಖೀಜ಼್ ಖೈನ್, “ವಾನುತೇಲ್‌ನ ಲುಕ್ಷಾನ್ ಕರಾಥಿ ಶನಿ ಫಾಯಿ‍ದೊ? ");
INSERT INTO vaa_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","ಆ ತೇಲ್ನ ತೀನ್‌ಖ್ಹೊ ರೂಪಾನು ಪಾವ್ಲನ ವೇಚಿನ್ ಗರೀಬ್‌ನ ದಿಯ್ಯೆಜಾ಼ಯಿಥೂನಿ!” ಕರಿ ಬೋಲಿನ್ ಗಾಳೆ ದಿದು. ");
INSERT INTO vaa_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","ಕತೋಬಿ ಯೇಸುನೆ, “ಅನ ಮ್ಹೇಲೊ! ಶನ ಅನ ಖ್ಹತಾವಸ್ತೆ? ಆ ತಯೇಡ ಮಾರಖ್ಹಾಜೆ ಘಣು ಅಛ್ಛು಼ಕಾಮ್ ಕರಿರಾಖೀಸ್. ");
INSERT INTO vaa_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","ಗರೀಬ್ ಅದ್ಮಿಖ್ಹಾರು ಕದೇಬಿ ತುಮಾರ ಜೋ಼ಡೆ ರ‍್ಹಿಶೆ, ತುಮುನ ಮನ್ ಆವಾತೆ ತದೆ, ಇವ್ಣುನ ಮದತ್ ಕರೆಜಾ಼ಯ್, ಕತೋಬಿ ಮೇ ಕದೇಬಿ ತುಮಾರಕನ ರ‍್ಹೀಶ್‌ಕೊಯ್ನಿ. ");
INSERT INTO vaa_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","ಅನೆ ಇನೊ ಹಾತ್‌ ಕೆತ್ರೆ ಹುವ್ವಾಸ್‌ಕಿ ಎತ್ರೆ ಕರಿರಾಖೀಸ್. ಮೇ ಮರ್‌ವಾನ ಅಗಾಡಿಸ್, ಮಾರು ಶರೀರ್‌ನ ಮಖ್ಹಾಣ್ಯು ಕರಾನ ಖ್ಹವಾರನಖ್ಹಾಜೆ ಅನೆ ಅಗಾಡಿಸ್ ಮಾರ ಆಂಗ್‌ತನ್‌ಪರ್ ವಾನು ತೇಲ್‌ಲಗಾಡಿರಾಖಿಸ್‌. ");
INSERT INTO vaa_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","“ಹಿಡಿ ಜಗತ್‌ಮ ದೇವ್ನಿ ಅಛ್ಛಿ ಖಬರ್ ಕಿಜ಼್ಜ-ಕಿಜ಼್ಜ ಬೋಲಾವ್‌ಶೇಕಿ, ಹಿಜ್ಜಾ಼-ಹಿಜ್ಜಾ಼ ಅನೆ ಕರೀತೆ ಇನಾಬಿ ಅನಿ ಯಾದ್‌ನಖ್ಹಾಜೆ ಬೋಲ್‌ಶೆ”ಕರಿ ತುಮುನ ಖ್ಹಾಚಮಾಬಿ ಬೋಲುಸ್ ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","ಅನ ಬಾದ್‌ಮ ಭಾರ ಜ಼ಣ ಶಿಷ್ಯರ್‌ಮ ಏಕ್‌ ಜ಼ಣೊ ಹುಯಿರ‍್ಹೊಥೋತೆ ಇಸ್ಕರಿಯೋತ ಯೂದಾನೆ, ಯೇಸುನ ಗಲ್‌ಢಯಾಜಕರ್‌ನ ಧರಿದೇಣು ಕರಿ ಇವ್ಣಾಕನ ಗಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","ಇನೆ ಬೋಲ್ಯೋತೆ ವಾತೆನ ಖ್ಹಮ್‌ಜಿನ್‌ ಇವ್ಣುನ ಖ್ಹುಶಿ ಹುಯು, ಅಜು಼ ಯೂದಾನ, “ತುನ ಪೈಶಾ ದಿಶು ಕರಿ” ವಾತೆದಿದು. ಇನಾಖ್ಹಾಜೆ ಯೂದ ಯೇಸುನ ಧರಿದ್ಯವಾನಿ ಬರೋಬರ್‌ನಿ ವಖ್ಹತ್‌ನಖ್ಹಾಜೆ ಜ಼ಪೂಕರ್ತೊಥೊ. ");
INSERT INTO vaa_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","ಖಾಟುಕೊಂತೆ ರೋಟಾನು ಪೂಜಾ಼ನ ಪಹಿಲ ದನ್ನೆ, ಕತೊ ಪಸ್ಕಾನಿ ಪೂಜಾ಼ನಮೆಂಢಾನ ಚೆಲ್ಕ ರ‍್ಹೇಖ್ಹಾನ ದನ್ನೆ, ಯೇಸುನ ಶಿಷ್ಯರ್‌ ಇನ, “ಹಮೆ ಕಿಜ಼್ಜಾ ಜೈ಼ನ್‌ ತಾರಾಖ್ಹಾಜೆ ಪಸ್ಕಾನು ಖಾಣನ ಖ್ಹವಾರ್‌ನು?” ಕರಿ ಪುಛಾ಼ಯ. ");
INSERT INTO vaa_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","ಯೇಸುನೆ ಇನ ಶಿಷ್ಯರ್‌ಮ ಬೇ ಜ಼ಣಾನ ಬುಲೈನ್, “ತುಮೆ ಖ್ಹಯೇರ‍್ನ ಮಹಿ ಜಾ಼ವೊ, ಹಿಜ್ಜಾ಼ ಏಕ್‌ ಅದ್ಮಿ ಪಾಣಿನೊ ಘಡೊ ಪಳ್ಳಿನ್‌ ತುಮಾರ ಖ್ಹಾಮ್ಣೆ ಆವ್‌ಶೆ; ಇನ ಪೀಠೆ ಜಾ಼ವೊ. ");
INSERT INTO vaa_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","ಯೋ ಖೆವ ಘರ್‌ಮ ಜಾ಼ಶೆಕಿ, ಯೋ ಘರ್‌ನ ಯಜಮಾನ್ನ, “ಮಾರ ಶಿಷ್ಯರ್‌ಬಿ ಮೇ ಪಸ್ಕಾನು ಖಾಣು ಖಾವಾನಖ್ಹಾಜೆ ಖಾಣಾನಿ ಝ಼ಗೊ ಕಿಜ಼್ಜಾ ಛಾ಼, ಕರಿ ಗುರುನೆ ಪುಛಾ಼ಯೊ ಕರಿ ಬೋಲೊ. ");
INSERT INTO vaa_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","ತದೆ ಯೋ ಹೋಣುತೆ ಖ್ಹಾಮನ್‌ ಖ್ಹಾರು ಬರೋಬರ್‌ಥಿ ಖ್ಹವಾರೈರ‍್ಹಿಶೇತೆ, ಛ಼ತ್‍ನ ಉಪ್ಪರ್‌ಲ್ಯೊ ಮೋಟ ಕೋಣಾನ ತುಮುನ ವತಾಳ್‌ಶೆ, ಹಿಜ್ಜಾ಼ ಅಪ್ಣಖ್ಹಾಜೆ ಖ್ಹಾರು ಖ್ಹವಾರೊ” ಕರಿ ಬೋಲಿನ್ ಮೋಕ್‌ಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","ತದೆ ಯೋ ಶಿಷ್ಯರ್‌ ಹಿಜ್ಜಾ಼ಥು ನಿಕ್ಳಿನ್, ಖ್ಹಯೇರ್‌ಮ ಜೈ಼ನ್‌, ಯೇಸುನೆ ಇವ್ಣುನ ಬೋಲ್ಯೋತೆ ಇಮ್ಮಸ್ ಥೂತೆ ದೇಖಿನ್‌; ಪಸ್ಕಾನ ಖಾಣನ ತೈಯಾರ್ ಕರ‍್ಯು. ");
INSERT INTO vaa_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","ಖ್ಹಾಂಜ಼್ ಹುವಾನ ಬಾದ್‌ಮ, ಯೇಸು ಇನ ಭಾರ ಜ಼ಣ ಶಿಷ್ಯರ್‌ನ ಜೋ಼ಡ್ಮ ಆಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","ಇವ್ಣೆ ಖಾಣು ಖವಾನಿ ವಖ್ಹತ್‌ಮ ಯೇಸುನೆ, “ತುಮುನ ಖ್ಹಾಚಮಾಬಿ ಬೋಲುಸ್ಕಿ, ತುಮಾರಮ ಏಕ್‌ ಜ಼ಣೊ ಮನ ಧೋಕೇಥಿ ಧರಿದಿಶೆ, ಯೋ ಮಾರ ಜೋ಼ಡ್ಮ ಖಾಣು ಖಾವಾಳೋಸ್ ಹುಯಿರ‍್ಹೋಸ್” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","ತದೆ ಇವ್ಣೆ ದುಖ್‌ಥಿ, “ಮೇತೊ ಕಾಹೆನಿ, ಮೇತೊ ಕಾಹೆನಿ” ಕರಿ ಏಕ್‌ನ ಬಾದ್‌ಮ ಏಕ್‌ ಇನ ಬೋಲಾಲಗ್ಯ. ");
INSERT INTO vaa_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","ತದೆ ಯೇಸುನೆ ಇವ್ಣುನ, “ಯೋ ಮಾರ ಭಾರ ಜ಼ಣ ಶಿಷ್ಯರ್‌ಮ ಏಕ್‌ ಜ಼ಣೊ, ಯೋ ಮಾರ ಜೋ಼ಡ್ಮ ಕಟೋರಿಮ ಇನೊ ರೋಟೊ ಚೋ಼ಪ್‍ಡಿನ್ ಖಾವಾಳೋಸ್. ");
INSERT INTO vaa_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","ಅದ್ಮಿನೊ ಛಿಯ್ಯೊ ಇನಿ ಬಾರೇಮ ಲೀಖೈರ‍್ಹೂಸ್ತೆ ಇಮ್ಮಸ್ ಮರ್‌ಶೇತೆ ಖ್ಹಾಚಸ್; ಕತೋಬಿ ಕೋಣ್, ಅದ್ಮಿನೊ ಛಿಯ್ಯಾನ ಧೋಕೊದೀನ್ ಧರಿದಿಶೇಕಿ ಇನಿ ಹಾಲ್ನ ಶಾತ್‌ ಬೋಲು! ಯೋ ಅದ್ಮಿ ಪೈದ ನಾಸ್ ಹುಯುಹೊತ್ತೊ ಇನ ಅಛ್ಛು಼ ರ‍್ಹಯುಹೋತ್‌!” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","ಇವ್ಣೆ ಖಾಣು ಖವ್‍ಕರಾನಿ ವಖ್ಹತ್‌ಮ, ಯೇಸುನೆ ರೋಟಾನ ಪಾಡಿನ್, ದೇವ್ನ ಧನ್ಯವಾದ್‌ ಕರೀನ್, ಇನ ತೋಡಿನ್, “ಅಲ್ಲೇವೊ, ಆ ಮಾರು ಶರೀರ್” ಕರಿ ಬೋಲಿನ್ ಇನ ಶಿಷ್ಯರ್‌ನ ದಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","ಬಾದ್‌ಮ ಕಟೋರಿನ ಪಾಡಿನ್,ದೇವ್ನ ಧನ್ಯವಾದ್ ಕರೀನ್, ಇವ್ಣುನ ದಿದೊ; ಇವ್ಣೆ ಖ್ಹಾರೂಸ್ ಇನಾಮ ಪೀದು. ");
INSERT INTO vaa_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","ತದೆ ಯೇಸುನೆ ಇವ್ಣುನ, “ಆ ಮಾರು ಲ್ಹೋಯಿ, ಆ ದೇವ್ನೆ ಇನ ಅದ್ಮಿನ ಜೋ಼ಡೆ ಕರ‍್ಯುಹುಯು ನವು ಒಪ್ಪಂದಾನನು ಮಾರು ಲ್ಹೋಯಿ; ಆ ಘಣ ಅದ್ಮಿನಖ್ಹಾಜೆ ರಂಚಾ಼ಯುತೆ ಲ್ಹೋಯಿ. ");
INSERT INTO vaa_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","ಮೇ ಖ್ಹಾಚಮಾಬಿ ತುಮುನ ಬೋಲುಸ್ಕಿ, “ಹಂಕೇಥು ಧರೀನ್ ಮೇ ದೇವ್ನಿ ರಾಜ್ಯಮ ನವು ದ್ರಾಕ್ಷಿನು ರಖ್ಹ್‌ನ ಪಿಯ್ಯಾನ ದನ್‌ತೋಡಿ ಅನ ಪಾಛು಼ ಪೀಶಸ್‌ಕೊಯ್ನಿ”. ");
INSERT INTO vaa_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","ಬಾದ್‌ಮ ಇವ್ಣೆ ಸ್ತುತಿನು ಗೀದ್‌ ಬೋಲಿನ್ ಆಲಿವ್ ಪಹಡ್‌ಕನ ಚ಼ಲೇಗಯ. ");
INSERT INTO vaa_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","ತದೆ ಯೇಸುನೆ ಇವ್ಣುನ, “ತುಮೆ ಖ್ಹಾರುಸ್ ಮನ ಮ್ಹೆಂದಿನ್ ಮಿಲೈಜಾ಼ಶು, ಶನಕತೊ, ‘ದೇವ್ ಮೇಂಢ ಚ಼ರಾವವಾಳಾನ ಮರ್‌ನಾಕಿಶ್, ತದೆ ಮಂಧಾಮಾಥು ಮೇಂಢ ಛಿಡ್‌ಗರ್‌ ಹುಯಿಜಾ಼ಶೆ’ ಕರಿ ಲೀಖೈರ‍್ಹೂಸ್‌ನಿ. ");
INSERT INTO vaa_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","ಕತೋಬಿ ಮೇ ಜಿವ್ತೊಹುಯಿನ್ ಉಠಾನ ಬಾದ್‌ಮ, ತುಮಾರೇಥಿ ಅಗಾಡಿ ಗಲಿಲಾಯ ಜೈ಼ಶ್”. ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","ಕತೋಬಿ ಪೇತ್ರನೆ, “ಖ್ಹಾರು ಡರಿನ್ ತುನ ಮ್ಹೆಂದಿದುತೋಬಿ, ಮೇ ಕೋ ಮ್ಹೇಲೀಶ್‌ನಿ!” ಕರಿ ಬೋಲ್ತಖ್ಹತರ್‌, ");
INSERT INTO vaa_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","ಯೇಸುನೆ ಪೇತ್ರನ, “ಖ್ಹಾಚಮಾಬಿ ತುನ ಬೋಲುಸ್ಕಿ ಆ ರಾತೇಸ್ ಮುರ್‌ಗೊ ಬೇ ಹಲ್ಲ ಬಾಂಗ್‌ ದ್ಯವಾನ ಅಗಾಡಿ, ತು ಮಾರಿ ಬಾರೇಮ, ‘ಯೋ ಮನ ಮಾಲುಮ್‌ಕೊಯ್ನಿ’ ಕರಿ ತೀನ್ ಹಲ್ಲ ಬೋಲಿಶ್” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","ಕತೋಬಿ ಪೇತ್ರನೆ ಬಿಜೂ಼ಬಿ ಕಡಕ್‌ಥಿ, “ಮೇ ತಾರ ಜೋ಼ಡ್ಮ ಮರ‍್ನುಕತೋಬಿ, ‘ತೂ ಮನ ಮಾಲುಮ್‌ ಕೊಯ್ನಿ’ ಕರಿ ಕೋಸ್ ಬೋಲಿಶ್‌ನಿ!” ಕರಿ ಬೋಲ್ಯೊ. ಅಜು಼ ಖ್ಹಾರ ಶಿಷ್ಯರ್‌ನೇಬಿ ಇಮ್ಮಸ್ ಬೋಲ್ಯ. ");
INSERT INTO vaa_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","ಬಾದ್‌ಮ ಇವ್ಣೆ ಅಖ್ಖಾಜ಼ಣ ಗೆತ್ಸೆಮನೆ ಕರಿ ಬಾಗ್‌ಕನ ಆಯ, ಯೇಸುನೆ ಇನ ಶಿಷ್ಯರ್‌ನ, “ಹಜ್ಜಾ಼ಸ್ ಬೇಖ್ಹೊ, ಮೇ ಪ್ರಾರ್ಥನೆ ಕರೀನ್ ಆವುಸ್‌” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","ಅಮ್ ಬೋಲಿನ್ ಖಲಿ ಪೇತ್ರ, ಯಾಕೋಬ್ ಅಜು಼ ಯೋಹಾನ್ನ ಇನ ಜೋ಼ಡ್ಮ ಬುಲೈಲಿ ಗಯೊ. ತದೆ ಯೇಸುನ ಘಣು ಘಬ್ರಾವ್‍ಣಿ ಹುಯು ಅಜು಼ ದುಖ್‌ಥಿ ಭರೈಗೊ. ");
INSERT INTO vaa_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","ಅಜು಼ ಇನೆ ಇವ್ಣುನ, “ಮಾರೊ ಜಾನ್‌ ಮರ‍್ವಎತ್ರೆ ದುಖ್‌ಮ ಛಾ಼. ತುಮೆ ಹಜ಼್ಜಾಸ್ ರ‍್ಹೀನ್ ಹೊಷಾರಿ ರ‍್ಹವೊ” ಕರಿ ಬೋಲಿನ್, ");
INSERT INTO vaa_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","ಜ಼ರ ಖ್ಹಾಮ್ಣೆ ಜೈ಼ನ್, ಜ಼ಮೀನ್‌ಪರ್ ಆಡೊ ಪಡೀನ್, ಹೋತು ಉಶೇತೊ, ಯೋ ವದೇಖ್ಹಾನಿ ವಖ್ಹತ್ ಇನ ಮ್ಹೆಂದಿನ್ ಜಾ಼ವಾನಿತರ ಪ್ರಾರ್ಥನೆ ಕರೀನ್, ");
INSERT INTO vaa_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","“ಓ ಬಾ, ಓ ಮಾರೊ ಬಾ! ತಾರೇಥಿ ಖ್ಹಾರುಸ್‌ ಹುವ್ವಾಸ್‌. ಆ ವದೇಖ್ಹಾನ ರಾಛಾ಼ನ ಮಾರೇಥಿ ಹಟಾವ್‌. ತೋಬಿ ಮಾರಿ ಮರ್ಜಿನಿ ಘೋಣಿ ಕಾಹೆತೆ ತಾರಿ ಮರ್ಜಿನಿ ಘೊಣಿಸ್ ಹುವಾದೆ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","ಬಾದ್‌ಮ ಯೇಸು ಪಾಛೊ಼ಫರಿ ಐನ್ ದೇಖಾತೊ ಯೋ ತೀನ್ ಜ಼ಣ ಶಿಷ್ಯರ್‌ ನಿಂದರ್‌ ಲೆವ್‌ಕರ್ತುಥು. ತದೆ ಇನೆ ಪೇತ್ರನ, “ಸೀಮೋನ್, ಖ್ಹುತೋಸ್ಕಿ ಶು? ಏಕ್‌ ಘಡೀಬಿ ತುನ ಹೊಷಾರಿರ‍್ಹವಾನ ಕೋ ಹೋಯ್ನಿಕಿ ಶು?” ");
INSERT INTO vaa_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","ಅಜು಼ ಇವ್ಣುನ ಬೋಲ್ಯೋಕಿ, “ಶೋದನೆಮ ಪಡ್ಣುನಾತೆ ಇಮ್‌ ಹೊಷಾರಿ ರ‍್ಹೀನ್ ಪ್ರಾರ್ಥನೆ ಕರೊ. ಮನ್ ಛಾ಼ ಖ್ಹಾಚಸ್, ಕತೋಬಿ ಶರೀರ್‌ನ ಶಕತ್ ಪೂರಕೊಯ್ನಿ.” ");
INSERT INTO vaa_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","ಬಾದ್‌ಮ ಪಾಛೊ಼ ಜೈ಼ನ್‌, ಯೋಸ್‌ ವಾತೆನ ಬೋಲ್ತೊಹುಯಿನ್ ಪ್ರಾರ್ಥನೆ ಕರ‍್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","ಪಾಛೊ಼ ಐನ್ ದೇಖಾನಿ ವಖ್ಹತ್‌ಮ ಇವ್ಣೆ ಬಿಜೂ಼ಬಿ ನಿಂದರ್‌ ಲೆವ್‌ಕರ್ತುಥು; ಇವ್ಣ ಡೋಳಾಮ ನಿಂದರ್‌ ಚು಼ವ್‌ಕರ್ತುಥು. ಇನಾಖ್ಹಾಜೆ ಯೇಸುನೆ ಪುಛಾ಼ಯೋತೆ ಇನ, ಶಾತ್‌ ಬೋಲ್‌ನು ಕರಿ ಇವ್ಣುನ ಮಾಲುಮ್‌ ಕೋ ಪಡ್ಯುನಿ. ");
INSERT INTO vaa_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","ಯೇಸುನೆ ತೀನ್ನೆ ಹಲ್ಲ ಪ್ರಾರ್ಥನೆನ ಜೈ಼ನ್ ಐನ್ ಇವ್ಣುನ, “ತುಮೆ ಹಂಕೆತೋಡಿ ಖ್ಹುಯಿನ್, ಅರಾಮ್‌ ಕರುಕರಾಸ್ಕಿ ಶು? ಬಶ್‌! ಹಂದೇಖೊ, ಅದ್ಮಿನೊ ಛಿಯ್ಯಾನ ಧರೀನ್ ಪಾಪಿ ಅದ್ಮಿನ ಹಾತ್‌ಮ ದೆವೈಜಾ಼ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","ಉಠೊ, ಜ಼ಯ್ಯೆ. ಮನ ಧೋಕೇಥಿ ಧರಿದ್ಯವಾಳೊ ಖನ್ನೆಸ್‌ ಐರ‍್ಹೋಸ್, ದೇಖೊ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","ಯೇಸು ಅಜೂ಼ಬಿ ವಾತೆ ಬೋಲುಕರಾತೆ ತದ್ದೇಸ್, ಇನ ಭಾರಜ಼ಣ ಶಿಷ್ಯರ್‌ಮ ಏಕ್‌ ಜ಼ಣೊ ಹುಯಿರ‍್ಹೊಥೋತೆ ಯೂದ, ಹಿಜ್ಜಾ಼ ಆಯೊ. ಇನ ಜೋ಼ಡ್ಮ ಗಲ್‌ಢಯಾಜಕರ್‌, ಮೋಶೆನಿ ವಚನ್ ಶಿಕಾಡವಾಳು ಶಾಸ್ತ್ರಿಯೆ ಅಜು಼ ಶಾಣುಖ್ಹಾರು ಬೋಲಿ ಮೋಕ್‍ಲ್ಯುಹುಯು ಏಕ್‌ ಟೋಳ್‌, ತಲ್ವಾರೆ ಅಜು಼ ಲಠ್ಠ ಧರಿಲಿನ್‌ ಹಿಜ್ಜಾ಼ ಆಯು. ");
INSERT INTO vaa_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","ಯೇಸುನ ಧೋಕೇಥಿ ಧರಿದ್ಯವಾಳೊ ಯೋ ಝೂ಼ಂಡ್‌ವಾಳನ, “ಮೇ ಕಿನ ಬುಚ್ಚಾ಼ ದೆವ್‌ಸ್ಕಿ ಯೋಸ್‌ ತುಮೂನ ಹೋಣುತೆ ಅದ್ಮಿ. ಇನ ಧರೀನ್ ಹೊಷಾರ್‌ಥಿ ಲೀಜಾ಼ವೊ” ಕರಿ ಖ್ಹಣೇದ್ ಬೋಲಿ ದೀರಾಖ್ಯೊಥೊ. ");
INSERT INTO vaa_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","ಯೂದ ಹಿಜ್ಜಾ಼ ಆವ್‌ತಾಸ್ನ, ಇನೆ ಯೇಸುನ ಖನ್ನೆ ಜೈ಼ನ್‌, “ಗುರು!” ಕರಿ ಬೋಲಿನ್ ಇನ ಬುಚ್ಚಾ಼ ದಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","ತದೆ ಇವ್ಣೆ ಯೇಸುಪರ್ ಹಾತ್‌ ನಾಖಿನ್ ಇನ ಧರ‍್ಯು. ");
INSERT INTO vaa_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","ತದೆ ಹಿಜ್ಜಾ಼ ಖನ್ನೆಸ್‌ ಭಿಯ್ಯುಥೂತೆ ಏಕ್‌ ಜ಼ಣು ಇನಿ ತಲ್ವಾರ್‌ನ ಕಾಡಿನ್, ಗಲ್‌ಢಯಾಜಕ್‌ನ ಆಳ್‌ನ ಮಾರಿನ್, ಇನೊ ಕಾನ್‌ ಕತ್ರಿನಾಖ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","ತದೆ ಯೇಸುನೆ ಇವ್ಣುನ, “ಚೋ಼ರ್‌ನ ಧರಾನಿಘೋಣಿ ತಲ್ವಾರೆ, ಲಠ್ಠ ಪಳ್ಳಿನ್‌ ಮನ ಧರಾನಖ್ಹಾಜೆ ಆಯಾಕಿ ಶು? ");
INSERT INTO vaa_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","ಮೇ ದನ್‌ರೋಜ಼್‌ ತುಮಾರ ಜೋ಼ಡ್ಮಾಸ್ ರ‍್ಹೀನ್ ಮೋಟಿ ಮಂದಿರ್‌ಮ ವಚನ್ ಬೋಲಿ ದೆವ್‌ಕರ್ತೊಥೋತೆ, ತದೆ ತುಮೆ ಮನ ಧರ‍್ಯಾಕೊಯ್ನಿ. ತೋಬಿ ವಚನ್‌ಮ ಲೀಖೈರ‍್ಹೂತೆ ಪೂರಹುವಾನಖ್ಹಾಜೆ ಆ ಖ್ಹಾರು ಹುಯೂತೆ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","ತದೆ ತಮಾಮ್‌ ಶಿಷ್ಯರ್‌ ಯೇಸುನ ಮ್ಹೆಂದಿನ್ ನಾಶಿ ಚ಼ಲೇಗಯ. ");
INSERT INTO vaa_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","ಹಿಜ್ಜಾ಼ ಏಕ್‌ ಜಾ಼ನ್ಜ಼ಮಾನ್ ಅದ್ಮಿ, ಖಾಲಿ ಆಂಗ್‌ಪರ್‌ ಘಣ ಮೋಲ್‌ನುಲುಂಗ್ಡು ಲಪೇಟಿಲೀನ್, ಯೇಸುನ ಪೀಠೆ-ಪೀಠೆ ವಳ್ಯುಜಾ಼ತೂಥು. ಇವ್ಣೆ ಇನಾಬಿ ಧರಿಲೇವ್ಣು ಕರಿ ಕರ‍್ಯು, ");
INSERT INTO vaa_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","ಕತೋಬಿ ಯೋ ಇನು ಕೋರಲುಂಗ್ಡಾನ ಮ್ಹೆಂದಿನ್, ಖಾಲಿಆಂಗೇಸ್‌ ನಾಶಿಗಯು. ");
INSERT INTO vaa_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","ಬಾದ್‌ಮ ಇವ್ಣೆ ಯೇಸುನ ಗಲ್‌ಢಯಾಜಕ್‌ನ ಘರ್‌ಕನ ಲೀನ್‌ಗಯು, ಹಿಜ್ಜಾ಼ ಗಲ್‌ಢಯಾಜಕರ್‌, ಮೋಶೆನಿ ವಚನ್ ಶಿಕಾಡವಾಳು ಶಾಸ್ತ್ರಿಯೆ ಅಜು಼ ಶಾಣು ಖ್ಹಾರು ಭರೈರ‍್ಹೂಥು. ");
INSERT INTO vaa_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","ಪೇತ್ರ ದೂರ್‌ಥೋಸ್ ಯೇಸುನ ಪೀಠೆ-ಪೀಠೆ ಜಾ಼ತೋಹುಯಿನ್‌ ಗಲ್‌ಢಯಾಜಕ್‌ನ ಘರ್‌ನ ಖ್ಹಾಮ್ಣೆನು ಚೌ಼ಕ್‌ಕನ ಗಯೊ. ಹಿಜ್ಜಾ಼ ಆಗ್ ಶೇಕು ಕರ್ತುಥೂತೆ ಕಾವ್ಲಿ ಕರಾವಾಳನ ಜೋ಼ಡ್ಮ ಬೇಶಿನ್, ಯೋಬಿ ಆಗ್ ಶೇಕಾಲಗ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","ತದೆ ಗಲ್‌ಢಯಾಜಕರ್‌ ಅಜು಼ ಮೋಟಿ ಸಬೇನು ಖ್ಹಾರು ಯೇಸುನ ಮರೈನಾಖಿದೇಣು ಕರಿ ಸಬೂತ್ ಢೂಂಡ್ಯು. ಕತೋಬಿ ಬರೋಬರ್‌ನಿ ಸಾಕ್ಷಿ ಮಳ್ಯುಕೊಯ್ನಿ. ");
INSERT INTO vaa_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","ಘಣು ಅದ್ಮಿ ಯೇಸುಪರ್‌ ಝೂ಼ಟಿ ಸಾಕ್ಷಿಖ್ಹಾರಿ ಬೋಲ್ಯುತೋಬಿ ಇವ್ಣಿ ಸಾಕ್ಷಿ ಏಕ್‌ಥಿ-ಏಕ್‌ ಬರೋಬರ್ ಕೋ ಲಾಗ್ಯುನಿ. ");
INSERT INTO vaa_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","58","ಬಾದ್‌ಮ ಥೋಡು ಅದ್ಮಿ ಉಠಿ ಭೀರಿನ್‌, “ಅದ್ಮಿನೆ ಭಾಂದಿರಾಖ್ಯುಸ್ತೆ ಆ ಮಂದಿರ್‌ನ ಮೇ ಫೋಡಿನಾಖಿನ್, ಅದ್ಮಿನ ಹಾತೇಖ್ಹು ಭಾಂದಾನ ಕೋ ಹುವ್ವಾನಿತೆ ಬಿಜೇಕ್‌ ಮಂದಿರ್‌ನ, ತೀನ್ ದನ್ಮ ಭಾಂದೀಶ್’ ಕರಿ ಆ ಬೋಲ್ಯೊತೆ ಹಮೆ ಖ್ಹಮ್‌ಜಿರಾಖ್ಯಾಸ್‌” ಕರಿ ಯೇಸುಪರ್‌ ಝೂ಼ಟಿ ಸಾಕ್ಷಿ ಖ್ಹಾರು ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","ತದೇಬಿ ಇವ್ಣಿ ಸಾಕ್ಷಿ ಖ್ಹಾರು ಏಕ್‌ಥಿ-ಏಕ್‌ ಬರೋಬರ್ ಕೋ ಲಾಗ್ಯುನಿ. ");
INSERT INTO vaa_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","ತದೆ ಗಲ್‌ಢೊಯಾಜಕ್‌ನೆ ಉಠೀನ್ ಖ್ಹಾರಾನ ಖ್ಹಾಮ್ಣೆ ಭೀರಿನ್, “ತೂ ಶಾತ್ಬಿ ಜವಾಬ್ ಕೋ ದೇಯ್ನಿಕಿ ಶು? ಅವ್ಣೆ ತಾರಪರ್ ಬೋಲುಕರಸ್ತೆ ಆ ಸಾಕ್ಷಿ ಖ್ಹಾಚಸ್‌ಕಿ ಶು?” ಕರಿ ಯೇಸುನ ಪುಛಾ಼ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","ತೋಬಿ ಯೇಸುನೆ ಶಾತ್ಬಿ ಫರೈ ಕೋ ಬೋಲ್ಯೊನಿತೆ ಖ್ಹೊಪ್‌ ಥೊ. ಪಾಛೊ಼ ಗಲ್‌ಢಯಾಜಕ್‌ನೆ, “ತೂ ಮಹಾನ್ ದೇವ್‌ನೊ ಛಿಯ್ಯೊ ಹುಯಿರ‍್ಹೋತೆ ಕ್ರಿಸ್ತಸ್‌ಕಿಶು?” ಕರಿ ಯೇಸುನ ಪುಛಾ಼ವಖ್ಹತರ್, ");
INSERT INTO vaa_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","ಯೇಸುನೆ, “ಒಹೊ, ಮೇಸ್; ಎತ್ರೇಸ್ ಕಾಹೆತೆ ಅದ್ಮಿನೊ ಛಿಯ್ಯೊ, ಮಹಾನ್ ಶಕತ್‌ವಾಳೊ ದೇವ್ನ ಖಾವಿಬಾಜು಼ಮ ಬೆಠೊರ‍್ಹಿಶೇತೆ ಅಜು಼ ಆಬ್‍ನ ವಾದ್ಳಪರ್ ಬೇಶಿನ್ ಆವ್‌ಶೇತೆ ತುಮೆಖ್ಹಾರು ದೇಕ್‌ಶು!” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","ಅನ ಖ್ಹಮ್‌ಜಿನ್‌, ಗಲ್‌ಢಯಾಜಕ್‌ನೆ ಇನ ಝ಼ಗ್ಗಾನ ಫಾಡಿಲೀನ್, “ಅಪ್ಣುನ ಅನೇಥಿಬಿ ಅಜು಼ ಖೆವಿ ಸಾಕ್ಷಿ ಹೋಣು! ");
INSERT INTO vaa_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","ಅನೆ ದೇವ್ನ ಗಾಳೆಕರಾನಿ ವಾತೆ ಬೋಲ್ಯೋತೆ ತುಮೆ ಖ್ಹಮ್‌ಜ್ಯಾನಿ. ತುಮುನ ಕಿಮ್ ದೆಖಾವಸ್?” ಕರಿ ಬೋಲ್ತಖ್ಹತರ್‌, ಇವ್ಣೆ ಖ್ಹಾರು ಯೇಸುನಿ ವಿರೋದ್ ಹಾತ್‌ ಪಾಡಿನ್, “ಆ, ಮರ್‌ವಾನ ಲ್ಹಾಯಕಸ್ ಛಾ಼” ಕರಿ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","ಬಾದ್‌ಮ ಇವ್ಣಾಮ ಥೋಡು ಜ಼ಣು ಯೇಸುಪರ್‌ ಥೂಕಿನ್, ಇನ ಮ್ಹೋಡಾಪರ್ ಲುಂಗ್ಡು ನಾಖಿನ್, ಗುಖ್ಹ್‌ತೊ ದೀನ್, “ಕಿನೆ ಮಾರ‍್ಯೂಕಿ ಪ್ರವಾದ್‌ನೆ ಬೋಲ್‌ನು ದೇಖೆ!” ಕರಿ ಬೋಲ್ಯು. ಅಜು಼ ಕಾವ್ಲಿ ಕರಾವಾಳನೆ ಇನ ಕಲ್ಲಪರ್ ಮಾರಿನ್ ಇವ್ಣ ಜೋ಼ಡ್ಮ ಬುಲೈಲಿ ಗಯು. ");
INSERT INTO vaa_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","ಯೋಸ್‌ ವಖ್ಹತ್‌ಮ ಪೇತ್ರ ಹೇಟ್‌ ಘರ್‌ನ ಖ್ಹಾಮ್ಣೆ ಥೊ. ತದೆ ಗಲ್‌ಢಯಾಜಕ್‌ನ ಆಳ್‌ಮ ಏಕ್‌ ಜ಼ಣಿ ಹಿಜ್ಜಾ಼ ಐನ್, ");
INSERT INTO vaa_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","ಪೇತ್ರ ಆಗ್ ಶೇಕುಕರ್ತೊಥೋತೆ ದೇಖಿ. ಅಜೂ಼ಬಿ ಇನ ಖನ್ನೆಥು ಠರ್‌ಕೈ ದೇಖಿನ್, “ತೂಬಿ, ಯೋ ನಜ಼ರೇತ್‌ನೊ ಯೇಸುನ ಜೋ಼ಡ್ಮ ಥೋನಿ” ಕರಿ ಬೋಲಿ. ");
INSERT INTO vaa_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","ತದೆ ಪೇತ್ರನೆ, “ಕೊಯ್ನಿ, ತು ಶಾತ್‌ ಬೋಲುಕರಾಸ್ಕಿ ಮನ ಮಾಲುಮ್‌ಕೊಯ್ನಿ” ಕರಿ ಬೋಲಿನ್ ಭಾರ್‌ಲಿ ಝ಼ಗೋಪರ್‌ ಗಯೊ. ಎತ್ರಾಸ್‌ಮ ಮುರ್‌ಗೊ ಬಾಂಗ್‌ ದಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","ಹಿಜ್ಜಾ಼ ಯೋ ಆಳ್‌ನೆ ಪಾಛು಼ ಇನ ದೇಖಿನ್, ಖನ್ನೆಸ್‌ ಭಿಯುಥೂತೆ ಅದ್ಮಿ ಖ್ಹಾರಾವ್‌ನ, “ಆಬಿ ಇವ್ಣಾಮ ಏಕ್‌ ಜ಼ಣೊ” ಕರಿ ಬೋಲಾಲಗಿ. ");
INSERT INTO vaa_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","ಕತೋಬಿ ಪೇತ್ರನೆ, “ಕಾಹೆ” ಕರಿ ಪಾಛೊ಼ ಬೋಲ್ಯೊ. ಜ಼ರಘಡಿನ ಬಾದ್‌ಮ ಹಿಜ್ಜಾ಼ ಭಿಯುಥೂತೆ ಇವ್ಣೆ ಪೇತ್ರನ, ಖ್ಹಾಚ಼ಮಾಬಿ “ಯೇಸುನ ಜೋ಼ಡ್ಮ ಥೂತೆ ಇವ್ಣಾಮ ತೂಬಿ ಏಕ್‌ ಜ಼ಣೊ ಕರಿ ಹಮೂನ ಮಾಲುಮ್, ತೂಬಿ ಗಲಿಲಾಯವಾಳೋಸ್‌” ಕರಿ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","ಕತೋಬಿ ಪೇತ್ರನೆ, “ಖ್ಹಾಚಮಾಬಿ, ತುಮೆ ಬೋಲುಕರಾಸ್ತೆ ಯೋ ಅದ್ಮಿ ಮನ ಮಾಲುಮ್‌ಕೊಯ್ನಿ! ಮೇ ಝೂ಼ಟಿ ಬೋಲುಕರ್ತೊ ಉಶೇತೊ, ದೇವ್ನ ಮಾರ್ ಮಾರಪರ್ ಆವಾದೆ ಕರಿ” ಬೋಲಿನ್ ಶಪತ್‌ ಖಾವಲಗ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","ಯೋಸ್‌ ವಖ್ಹತ್‌ಮ, ಮುರ್‌ಗೊ ಬೇನೆ ಹಲ್ಲ ಬಾಂಗ್‌ ದಿದೊ. ತದೆ ಪೇತ್ರನೆ, “ಮುರ್‌ಗೊ ಬೇ ಹಲ್ಲ ಬಾಂಗ್‌ದ್ಯವಾನ ಅಗಾಡಿ, ತೂ ಮಾರಿ ಬಾರೇಮ ತೀನ್ ಹಲ್ಲ ‘ಯೋ ಮನ ಮಾಲುಮ್ ಕೊಯ್ನಿ’ ಕರಿ ಬೋಲಿಶ್” ಕರಿ ಯೇಸುನೆ ಇನ ಬೋಲ್ಯೊಥೋತೆ ವಾತೆನ ಯಾದ್‌ಕರಿನ್, ಯೋ ಖ್ಹಡ್‌ಕ್ಯಾ ಭರಿನ್ ರೋಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","ವ್ಹಾಣ್‌ಖ್ಹತ್ರೇಸ್ ಗಲ್‌ಢಯಾಜಕರ್‌, ಮೋಶೆನಿ ವಚನ್ ಶಿಕಾಡವಾಳು ಶಾಸ್ತ್ರಿಯೆ, ಮೋಟಿ ಸಬೆವಾಳು ಅಜು಼ ಶಾಣುಖ್ಹಾರು ಮಳಿನ್ ವಾತೆಕರಿಲೀನ್, ಯೇಸುನ ಭಂದೈನ್ ಲೀಜೈ಼ನ್, ಪಿಲಾತನ ಹಾತ್‌ಮ ದಿದು. ");
INSERT INTO vaa_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","ತದೆ ಪಿಲಾತನೆ ಯೇಸುನ, “ತು ಯೆಹೂದ್ಯರ್‌ನೊ ರಾಜಾ಼ಕಿ ಶು?” ಕರಿ ಪುಛಾ಼ವಖ್ಹತರ್. ಯೇಸುನೆ, “ತುನೇಸ್ ಬೋಲ್ಯೋನಿ” ಕರಿ ಜವಾಬ್‌ ದಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","4","ಗಲ್‌ಢಯಾಜಕರ್‌ ಯೇಸುಪರ್‌ ಘಣಿ ಗಲ್ತಿ ಲಗಾಡುಕರ್ತಾಥ. ತದೆ ಪಿಲಾತನೆ ಬಿಜೇಕ್‌ ಹಲ್ಲ ಯೇಸುನ, “ತು ಶಾತ್ಬಿ ಜವಾಬ್‌ ಕೋ ದೇಯ್ನಿಕಿ ಶು? ದೇಕ್, ಅವ್ಣೆ ತಾರಪರ್ ಕೆತ್ರು ಬೋಲುಕರಾಸ್ತೆ!” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","ಕತೋಬಿ ಯೇಸುನೆ ಶಾತ್ಬಿ ಜವಾಬ್‌ ಕೋ ದಿದೋನಿ. ಅನ ದೇಖಿನ್ ಪಿಲಾತನೆ ಆಶ್ಚರ್ಯಖಾದೊ. ");
INSERT INTO vaa_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","ಪಸ್ಕ ಪೂಜಾ಼ನಿ ವಖ್ಹತ್‌ಮ ಕೋಂಡಿ ಘಾಲಿರಾಖಾತೆ ಅದ್ಮಿಮ, ಅದ್ಮಿಖ್ಹಾರು ಕಿನ ಬೋಲಸ್ಕಿ ಇನ, ಭಾರ್‌ ಮ್ಹೇಲಾನಿ ಆದತ್ ಥು. ");
INSERT INTO vaa_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","ತದೆ ಬರಬ್ಬ ಕರಿ ಏಕ್‌ ಜ಼ಣೊ ಥೊ. ಕಲ್ಹಾಗಟ್‌ ಪಡಾನಿ ವಖ್ಹತ್‌ಮ, ಅದ್ಮಿನ ಮಾರಿನಾಖಿ ದೇಯಿತೆ ಇವ್ಣ ಜೋ಼ಡ್ಮ ಇನ ಧರಿನ್ ಕೋಂಡಿ ಘಾಲಿರಾಖ್ಯುಥು. ");
INSERT INTO vaa_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","ತದೆ ಅದ್ಮಿಖ್ಹಾರು ಪಿಲಾತಕನ ಆಯಿ ಭರೈನ್, “ತುನೆ ಹಮೂನ ಕರ್ತೊ ಆಯೋತೆ ಇಮ್‌ ಕರ್‌” ಕರಿ ಗಿಂಗಾಯು. ");
INSERT INTO vaa_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","10","ತದೆ ಗಲ್‌ಢಯಾಜಕ್‍ಖ್ಹಾರು ಬಳಾಪೇಥಿ ಯೇಸುನ ಧರಿ ದೀರಾಖ್ಯುಸ್‌ ಕರಿ ಪಿಲಾತನೆ ಮಾಲುಮ್‌ ಕರಿಲೀನ್, “ಮೇ ಯೆಹೂದ್ಯರ್‌ನ ರಾಜಾ಼ನ ತುಮುನ ಮ್ಹೇಲಿದೇಣು ಕರಿ ತುಮಾರಿ ಆಖ್ಹ್‌ಕಿ ಶು?” ಕರಿ ಪುಛಾ಼ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","ತದೆ ಗಲ್‌ಢಯಾಜಕರ್‌ಖ್ಹಾರು, “ಬರಬ್ಬನಾಸ್ ಮ್ಹೇಲಿದೆ ಕರಿ ಬೋಲ್‌ನು” ಕರಿ ಅದ್ಮಿನ ಬೋಲಿದಿದು. ");
INSERT INTO vaa_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","ತದೆ ಪಿಲಾತನೆ ಇವ್ಣುನ, “ಇಮ್‍ಕತೊ, ತುಮೆ ಯೆಹೂದ್ಯರ್‌ನೊ ರಾಜ಼ ಕರಿ ಬೋಲುಕರಾತೆ ಅನ, ಮೇ ಶಾತ್‌ ಕರ‍್ನು ಕರಿ ತುಮೆ ಬೋಲೋಸ್?” ಕರಿ ಪಾಛೊ಼ ಬೋಲ್ತಖ್ಹತರ್‌. ");
INSERT INTO vaa_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","ಇವ್ಣೆ, “ಇನ ಶಿಲ್‌ಬೇಪರ್ ಮರಾವ್!” ಕರಿ ಚಿಕ್ರಿನ್ ಬೋಲಾಲಗ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","ತದೆ ಪಿಲಾತನೆ, “ಶನ? ಅನೆ ಶನಿ ಗಲ್ತಿ ಕರಿರಾಖ್ಯೋಸ್?” ಕರಿ ಬೋಲ್ಯೊ. ಕತೋಬಿ ಇವ್ಣೆ, “ಇನ ಶಿಲ್‌ಬೆಪರ್ ಮರಾವ್!” ಕರಿ ಅಜೂ಼ಬಿ ಜೋ಼ರೇಖ್ಹು ಬಳೇಳಿನ್‌ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","ತದೆ ಪಿಲಾತನೆ ಅದ್ಮಿನ ದಿಲ್ನ ಖ್ಹುಶಿ ಕರಾವ್ಣು ಕರಿ ಬರಬ್ಬಾನ ಇವ್ಣಖ್ಹಾಜೆ ಮ್ಹೇಲಿದಿದೊ. ಅಜು಼ ಯೇಸುನ ಮೇಕ್‌ನ ಕೊಳ್ಡೇಥಿ ಮರೈನ್ ಶಿಲ್‌ಬೆಪರ್ ನಾಖಾನ ದಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","ಶಿಪಾಯಿಖ್ಹಾರು ಯೇಸುನ ಪಿಲಾತನಿ ಮಹೇಲ್‌ನ ಖ್ಹಾಮ್ಣೆನಿ ಝ಼ಗೋಮ ಬುಲೈಲೀಜೈ಼ನ್, ದಂಡ್‌-ದಳ್‌ವಾಯಿನ ಎಕ್ಕದಮ್‌ ಬುಲಾಯು. ");
INSERT INTO vaa_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","ಹಿಜ್ಜಾ಼ ಶಿಪಾಯಿಖ್ಹಾರು ಯೇಸುನ ಲಾಲ್‌ಭಗ್ಮ ರಂಗ್ನು ಲುಂಗ್ಡು ಹೋಡೈನ್‌, ಕಾಟಾನಿ ಕಿರೀಟ್ನ ವಣಿನ್‌ ಇನ ಮಾಥಪರ್‌ ಘಾಲಿನ್, ");
INSERT INTO vaa_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","“ಯೆಹೂದ್ಯರ್‌ನ ರಾಜ಼, ತುನ ಖ್ಹಲಾಮ್” ಕರಿ ಬೋಲಿನ್, ");
INSERT INTO vaa_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","ಬೈತ್‌ನಿ ಲಾಕ್ಡಿಥಿ ಇನ ಮುಡ್‌ಕ್ಯಪರ್ ಮಾರಿನ್, ಇನಪರ್ ಥೂಕಿನ್, ಇನಾಖ್ಹಾಮೆ ಢುಕ್‌ಣ್ಯಟೇಕಿನ್, ಆಡು ಪಡ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","ಅಮ್ ಇವ್ಣೆ ಯೇಸುನಿ ನಕ್ಲೆ ಕಾಡಾನ ಬಾದ್‌ಮ ಯೋ ಲಾಲ್‌ಭಗ್ಮ ರಂಗ್‌ನ ಲುಂಗ್ಡಾನ ಕಾಡಿನಾಖಿದೀನ್ ಇನ ಲುಂಗ್ಡಾವ್‍ನಸ್ ಪಾಛು಼ ಫೇರೈನ್ ಶಿಲ್‌ಬೆಪರ್ ಮಾರಾನಖ್ಹಾಜೆ ಬುಲೈಲಿ ಗಯು. ");
INSERT INTO vaa_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","ತದೆ ಖೇತರ್‌ಮಾಥು ಯೋಸ್ ವಾಟೆ ಉಳ್ಯಾವ್ತೊಥೋತೆ ಕುರೇನೆ ಖ್ಹಯೇರ‍್ನೊ ಸೀಮೋನ್ನ, ಯೇಸುನಿ ಶಿಲ್‌ಬೆ ಪಾಡ್‌ಕರಿ ಶಿಪಾಯಿಖ್ಹಾರು ಜು಼ಲಮ್‌ ಕರ‍್ಯು. ಆ ಸೀಮೋನ್ ಅಲೆಕ್ಸಾಂಡರ್ ಅಜು಼ ರೂಫ ಕರಿ ಥಾತೆ ಇವ್ಣೊ ಬಾ ಹುಯಿರ‍್ಹೋಥೊ. ");
INSERT INTO vaa_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","ಅಜು಼ ಯೇಸುನ ‘ಗೊಲ್ಗೊಥಾ’ ಕರಿ ಝ಼ಗೋಪರ್ ಬುಲೈಲಿ ಗಯು. ಗೊಲ್ಗೊಥಾ ಕತೊ “ಖೋಪ್ರಿನಿ ಝ಼ಗೊ” ಕರಿ. ");
INSERT INTO vaa_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","ಹಿಜ್ಜಾ಼ ಇನ ರಕ್ತಬೋಳ ಮಳೈಹುಯು ದ್ರಾಕ್ಷಿನು ರಖ್ಹ್‌ನ ಪಿಯ್ಯಾನ ದಿದು. ಕತೋಬಿ ಯೇಸುನೆ ಇನ ಪೀದೊಕೊಯ್ನಿ. ");
INSERT INTO vaa_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","ಇವ್ಣೆ ಯೇಸುನ ಶಿಲ್‌ಬೆಪರ್ ಮಾರ‍್ಯು ಅಜು಼ ಇನ ಲುಂಗ್ಡಾವ಼್‌ಮ ಕೆಹು-ಕೆಹು, ಕಿನ-ಕಿನ ಜಾ಼ವ್ಣು ಕರಿ ಬೋಲಿನ್ ಚೀಟ್ ನಾಖಿನ್ ಇವ್ಣಾಮಸ್ ವಾಟ ಪಾಡಿಲಿದು. ");
INSERT INTO vaa_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","ಇವ್ಣೆ ಯೇಸುನ ಶಿಲ್‌ಬೆಪರ್ ಮಾರ‍್ಯೂತೆ ತದೆ ವ್ಹಾಣನ ನೌ ಘಂಟ ಹುಯಿರ‍್ಹಾಥ. ");
INSERT INTO vaa_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","ಇವ್ಣೆ ಯೇಸುಪರ್‌ ಲಗಾಡ್ಯುತೆ ಯೋ ಗಲ್ತಿನ ದೆಖಾವನಿ ಘೋಣಿ ಶಿಲ್‌ಬೆಪರ್ ಲೀಖಿರಾಖ್ಯುಥು. ಯೋ ಶಾತ್‌ಕತೊ, “ಯೆಹೂದ್ಯರ್‌ನೊ ರಾಜ಼” ಕರಿ. ");
INSERT INTO vaa_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","ಯೇಸುನ ಜೋ಼ಡ್ಮ ಬೇ ಜ಼ಣ ಚೋ಼ರ್‌ನಾಬಿ ಲೈನ್‌ ಏಕ್‌ ಜ಼ಣಾನ ಇನಿ ಖಾವಿ ಬಾಜೂ಼ಮ ಅಜು಼ ಬಿಜೇಕ್‌ ಜ಼ಣಾನ ಇನಿ ಡಾವಿ ಬಾಜೂ಼ಮ ಶಿಲ್‌ಬೆಪರ್ ಮಾರ‍್ಯು. ");
INSERT INTO vaa_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","ಆ ವಚನ್ ಗ್ರೀಕ್‌ನು ಥೋಡು ವಚನ್ನು ಭಾಗ್‌ಮ ಛಾ಼, ");
INSERT INTO vaa_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","ಹಿಜ್ಜಾ಼ಕರಿ ಜ಼ವ್‍ಕರ್ತುಥೂತೆ ಅದ್ಮಿಖ್ಹಾರು ಯೇಸುನಿ ನಕ್ಲೆ ಕಾಡ್ಯು: ಅಜು಼ ಮುಡ್‌ಕ್ಯು ಠಶ್‌ಕಾವ್ತು ಹುಯಿನ್, “ಓಹೊ, ತೂ ಮಂದಿರ್‌ನ ಫೋಡಿನ್ ತೀನ್ ದನ್ಮ ಭಾಂದೀಶ್ ಕರಿ ಬೋಲ್ಯೋಥೊ!” ");
INSERT INTO vaa_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","ಹಮ್ಕೆ ಶಿಲ್‌ಬೆಪರ್‌ಥು ಉತ್ರಿನ್ ಆವ್ ಅಜು಼ ತಾರು ತೂ ಬಚಾ಼ಡಿಲೆ!” ಕರಿ ಇನ ಚಿಂಘಾಯು. ");
INSERT INTO vaa_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","ಇಮ್ಮಸ್ ಗಲ್‌ಢಯಾಜಕರ್‌ಬಿ, ಮೋಶೆನಿ ವಚನ್‍ ಶಿಕಾಡವಾಳು ಶಾಸ್ತ್ರಿಯೇ಼ಬಿ, “ಇನೆ ಬಿಜಾ಼ನ ಬಚಾ಼ಡ್ಯೊ; ಕತೋಬಿ ಇನು ಯೋಸ್ ಬಚಾ಼ಡಿಲ್ಯವಾನ ಕೋ ಹೊಯ್ನಿ. ");
INSERT INTO vaa_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","ಇಸ್ರಾಯೇಲ್‌ನೊ ರಾಜ಼ ಹುಯಿರ‍್ಹೋತೆ ಆ ಕ್ರಿಸ್ತ ಹಮ್ಕೆ ಶಿಲ್‌ಬೆಪರ್‌ಥು ಉತ್ರಿನ್ ಆವಾದೆ! ಉತ್ರಿನ್ ಆಯೋತೊ ಹಮೆ ದೇಖಿನ್ ನಂಬ್‌ಶು” ಕರಿ ಏಕ್‌ಥಿಏಕ್‌ ಯೇಸುನಿ ನಕ್ಲೆ ಕಾಡಿನ್ ವಾತೆ ಬೋಲುಕರ್ತೂಥು. ಅಜು಼ ಇನ ಜೋ಼ಡ್ಮ ಶಿಲ್‌ಬೆಪರ್ ಮರೈರ‍್ಹೂಥೂತೆ, ಯೋ ಭೇ ಜ಼ಣಾನೇಬಿ ಇನಿ ಖ್ಹರಮ್‌ಕಾಡ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","ಧೊಪಾರ್‌ ಹುವ್ವಾದೀನ್ ಹಿಡಿ ದೇಖ್ಹ್‌ಪರ್ ಅಂಧಾರು ಢಪೈನ್, ತೀನ್ ಘಂಟತೋಡಿ ಇಮ್ಮಸ್‌ಥು. ");
INSERT INTO vaa_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","ತೀನ್ ಘಂಟಾನ ಯೇಸು, “ಎಲೋಹಿ, ಎಲೋಹಿ ಲಮಾ ಸಬಕ್ತಾನಿ” ಅಮ್‌ಕತೊ, “ಮಾರೊ ದೇವ್, ಮಾರೊ ದೇವ್, ತೂ ಶನ ಮನ ಹಾತ್‌ ಮ್ಹೆಂದಿದೊ?” ಕರಿ ಜೋ಼ರ್‌ ಆವಾಜ಼್‌ಥಿ ಚಿಕ್‌ರ‍್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","ಖನ್ನೆ ಭಿಯ್ಯುಥೂತೆ ಥೋಡು ಜ಼ಣು ಅನ ಖ್ಹಮ್‌ಜಿನ್‌, “ಹಂದೇಖೊ, ಯೋ ಎಲೀಯನ ಚಿಕ್ರುಕರಾಸ್!” ಕರಿ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","ತದೆ ಹಿಜ್ಜಾ಼ ಥೂತೆ ಏಕ್‌ ಜ಼ಣು ನಾಶಿಜೈ಼ನ್, ಗುಂಜ಼್‌ನ ಖಾಟ ರಖ್ಹ್‌ಮ ಡುಬೈನ್, ಲಠ್ಠಾಕೇಡೆ ಅಟ್‌ಕೈನ್ ಯೇಸುನ ಪಿಯ್ಯಾನ ದೀನ್, “ಠೇರೊ! ಎಲೀಯ ಐನ್ ಅನ ಶಿಲ್‌ಬೆಪರ್‌ಥು ಉತ್ರಾವಸ್ ಶುಕಿ ದೇಖೆ!” ಕರಿ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","ಕತೋಬಿ ಯೇಸುನೆ ಜೋ಼ರೆಖ್ಹು ಚಿಕ್ರಿನ್ ಜಾನ್‌ ಮ್ಹೇಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","ತದೆ ಮೋಟಿ ಮಂದಿರ್‌ನೊ ಪಡ್‌ದೊ ಉಪ್ಪರ್‌ಥು ಹೇಟ್‌ತೋಡಿ ಫಾಟಿನ್, ಬೇ ಭಾಗ್‌ ಹುಯಿಗಯು. ");
INSERT INTO vaa_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","ಯೇಸುನೆ ಆ ತರೀಕಾಥಿ ಜಾನ್‌ ಮ್ಹೇಲ್ಯೊತೆ ಇನ ಖ್ಹಾಮ್ಣೆಸ್ ಭಿಯೊಥೋತೆ ಖ್ಹೋಶಿಪಾಯಿನೊ ಮೋಟಾನೆ ದೇಖಿನ್, “ಖ್ಹಾಚಮಾಬಿ ಆ ಅದ್ಮಿ ದೇವ್‌ನೊ ಛಿಯ್ಯೊ ಹುಯಿರ‍್ಹೋಥೊ!” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","41","ಹಿಜ್ಗಾ಼ ದೂರ್‌ಥು ಭೀರಿನ್‌ ಥೋಡಿ ತಯೇಡಾಬಿ ಆ ಖ್ಹಾರು ದೇಖುಕರ್ತಿಥಿಯೆ. ಅವ್ಣಾಮ ಮಗ್ದಲನಿ ಮರಿಯ, ನ್ಹಾನೊ ಯಾಕೋಬ್ ಅಜು಼ ಯೋಸೆನಿ ಆಯ ಹುಯಿರ‍್ಹೀಥೀತೆ ಮರಿಯ ಅಜು಼ ಸಲೋಮೀಬಿ ಥಿಯೆ. ಅವ್ಣೆ ಯೇಸು ಗಲಿಲಾಯಮ ಥೋತೆ ತದೆ ಇನ ಕೇಡೆಸ್ ರ‍್ಹೀನ್ ಇನಿ ಸೇವೆ ಕರಿಹುಯೆ಼. ಎತ್ರೇಸ್ ಕಾಹೆತೆ ಯೇಸುನ ಜೋ಼ಡ್ಮ ಯೆರೂಸಲೇಮ್ ‌ಆಯೆಥೀತೆ ಬಿಜಿ ತಯೇಡಾವ್‌ಬಿ ಹಿಜ್ಜಾ಼ ಥಿಯೆ. ");
INSERT INTO vaa_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","ತದೆ ಖ್ಹಾಂಜ಼್ ಹುಯಿಗಯುಥು; ಅಜು಼ ಯೋ ದನ್ ಖ್ಹವಾರಾನೊ ದನ್ ಹುಯಿರ‍್ಹೋಥೊ, ಕತೊ ಸಬ್ಬತ್ ದನ್ನ ಪೀಠೆನೊದನ್‌ ಹುಯಿರ‍್ಹೋಥೊ. ");
INSERT INTO vaa_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","ತದೆ ಅರಿಮಥಾಯ ಗಾಮ್‌ನೊ ಯೋಸೇಫ ಕರಿ ಏಕ್‌ ಜ಼ಣೊ ಘಟ್ ಜಾನ್‌ಥಿ ಪಿಲಾತಕನ ಐನ್, ಯೇಸುನ ಶರೀರ್‌ನ ಮನ ದೇ ಕರಿ ಬೋಲಿಲಿದೊ. ಆ ಯೋಸೇಫ ಮೋಟಿ ಸಭೆಮ ಘಣು ಮರ್ಯಾದಿನು ಅದ್ಮಿ ಹುಯಿರ‍್ಹೋಥೊ ಅಜು಼ ದೇವ್ನಿ ರಾಜ್ಯ ಕದೆ ಆವ್‍ಶೆಕರಿ ಜ಼ಪಿರ‍್ಹೋತೊ. ");
INSERT INTO vaa_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","ಪಿಲಾತನೆ ಯೇಸು ತದ್ದೇಸ್ ಮರಿಗಯೊ ಕರಿ ಖ್ಹಮ್‌ಜಿನ್‌ ಆಶ್ಚರ್ಯಖಾದೊ. ಅಜು಼ ಖ್ಹೋಶಿಪಾಯಿನೊ ಮೋಟಾನ ಬುಲೈನ್, “ಯೋ ತದ್ದೇಸ್ ಮರಿಗಯೊಕಿ ಶು?” ಕರಿ ಇನ ಪುಛಾ಼ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","ಖ್ಹೋಶಿಪಾಯಿನ ಮೋಟಾಥಿ ಖ್ಹಮ್‌ಜಾ಼ನ ಬಾದ್‌ಮ, ಪಿಲಾತನೆ ಯೇಸುನ ಮುರ್ದಾನ ಯೋಸೇಫನ ದೆವಾಡ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","ಯೋಸೇಫನೆ ಘಣ ಮೋಲ್ನು ಲುಂಗ್ಡಾನ ಮೋಲ್ ಲೈನ್‌, ಯೇಸುನ ಶಿಲ್‌ಬೆಪರ್‌ಥು ಉತಾರಿನ್‌, ಯೋ ಲುಂಗ್ಡಾಥಿ ಇನ ಲಪೇಟಿನ್, ಬಂಡಾನಿ ಘವಿಮ ಮ್ಹೇಲಿನ್ ಯೋ ಘವೀನ ಬಾಕಲ್‌ನ ಮೋಟೊ ಬಂಡಾಥಿ ಮೂಚ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","ಹಿಜ್ಜಾ಼ ದೇಖುಕರ್‌ತಿಥಿಯೆ಼ತೆ ಮಗ್ದಲನಿ ಮರಿಯ ಅಜು಼ ಯೋಸೆನಿ ಆಯ ಮರಿಯನೆ ಯೇಸುನ ಶರೀರ್‌ನ ಮ್ಹೇಲ್ಯುತೆ ಝ಼ಗೋನ ದೇಖಿಯೆ಼. ");
INSERT INTO vaa_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","ಸಬ್ಬತ್‌ ದನ್ ಖತಮ್ ಹುವಾನ ಬಾದ್‌ಮ, ಮಗ್ದಲನಿ ಮರಿಯ, ಯಾಕೋಬ್‍ನಿ ಆಯ ಮರಿಯ ಅಜು಼ ಸಲೋಮಿ ಯೇಸುನ ಮುರ್ದಾನ ಲಗಾಡನಖ್ಹಾಜೆ ಅಛ್ಛು಼ ವಾನುತೇಲ್‌ನ ಮೋಲ್ ಲಿದಿಯೆ಼. ");
INSERT INTO vaa_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","ವಾರಾನು ಪಹಿಲ ದನ್ನೆ ವ್ಹಾಣ್‌ಖ್ಹತ್ರೆಸ್, ದನ್ ನಿಕಳ್‌ತಾಸ್‌ನ, ಇವ್ಣೆ ಯೇಸುನ ಮ್ಹೇಲಿರಾಖ್ಯುಥೂತೆ ಘವಿಕನ ನಿಕ್ಳಿಯೆ಼. ");
INSERT INTO vaa_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","ಘವಿನ ಬಾಕಲ್‌ನೊ ಬಂಡೊ ಘಣೊ ಮೋಟೊ ಥೊ. ಅನಖ್ಹಾಜೆ ಇವ್ಣೆ ಆವಾನಿ ವಖ್ಹತ್‌ಮ, “ಯೋ ಬಂಡಾನ ಅಪ್ಣಟೇಕೆ ಕೋಣ್ ಕಾಡ್‌ಶೆಲಿ?” ಕರಿ ಇವ್ಣೆಇವ್ಣೇಸ್ ವಾತೆ ಬೋಲ್ತಿ ಉಳ್ಯಾವ್‌ತಿಥಿಯೆ. ");
INSERT INTO vaa_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","ಕತೋಬಿ ಮುಡ್‌ಕ್ಯು ಪಾಡಿ ದೇಖಾತೊ ಯೋ ಬಂಡೊ ನಿಕ್ಳಿರ‍್ಹೋಥೊ. ");
INSERT INTO vaa_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","ತದೆ ಇವ್ಣೆ ಘವಿನ ಮಹಿ ಜೈ಼ನ್, ಹಿಜ್ಜಾ಼ ಏಕ್‌ ಜಾ಼ನ್ಜ಼ಮಾನ್ ಅದ್ಮಿ ಧೋಳು ಲುಂಗ್ಡು ಪೇರ‍್ಹಿಲೀನ್‌, ಖಾವಿ ಬಾಜು಼ಮ ಬೆಠುಥೂತೆ ದೇಖಿನ್, ಇವ್ಣೆ ಡರೀಗಯ್ಯೆ಼. ");
INSERT INTO vaa_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","ತದೆ ಇನೆ ಇವ್ಣುನ, “ಡರೊನಕೊ, ಶಿಲ್‌ಬೆಪರ್ ಮಾರ‍್ಯೂಥೂತೆ, ನಜ಼ರೇತ್‌ನೊ ಯೇಸುನ ಢೂಂಡುಕರಾಸ್ ಕರಿ ಮನ ಮಾಲುಮ್. ಯೋ ಹಜ್ಜಾ಼ ಕೊಯ್ನಿ, ಯೋ ಜಿವ್ತೊ ಹುಯಿನ್ ಉಠಿರ‍್ಹೋಸ್! ಹಂದೇಖೊ, ಆಸ್ ಇನ ಮ್ಹೇಲಿರಾಖ್ಯುಥೂತೆ ಝ಼ಗೊ. ");
INSERT INTO vaa_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","ಹಮ್ಕೆ ಜಾ಼ವೊ ಅಜು಼ ಆ ಖಬರ್‌ನ ಇನ ಶಿಷ್ಯರ್‌ನ ಅಜು಼ ಪೇತ್ರನಬಿ ಬೋಲೊ, ‘ಯೇಸುನೆ ತುಮೂನ ಬೋಲ್ಯೊಥೋತೆ ಇಮ್ಮಸ್, ತುಮಾರೇಥಿ ಅಗಾಡಿ ಗಲಿಲಾಯನ ವಳ್ಯೊಜಾ಼ಸ್; ಹಿಜ್ಜಾ಼ ತುಮೆ ಇನ ದೇಕ್‌ಶು ಕರಿ ಬೋಲೊ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","ತದೆ ಇವ್ಣೆ ಘಬ್‌ರೈಜೈ಼ನ್, ಕಾಪ್ತಿಹುಯಿನ್‌ ಭಾರ್‌ಆಯಿನ್, ಯೋ ಮಖ್ಹಾಣ್ಯನಿ ಘವಿಕಂಥು ನಾಶಿ ಚ಼ಲೀಗಯ್ಯೆ. ಇವ್ಣೆ ಡರ್‌ಥಿ, ಕಿನಾಬಿ ಶಾತ್‌ಬಿ ಕೋ ಬೋಲ್‌ಯೇನಿ. ");
INSERT INTO vaa_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","ವಾರಾನೊ ಪಹಿಲೊ ದನ್ನೆನು (ಐತ್‍ವಾರ್‌ನ) ವ್ಹಾಣೆ, ಯೇಸು ಜಿವ್ತೊ ಹುಯಿನ್ ಉಠಾನ ಬಾದ್‌ಮ, ಮಗ್ದಲನಿ ಮರಿಯನ ಪಹಿಲಿ ಬಾರ್ ದೆಖಾಯೊ, ಆ ಮರಿಯಮಾಥು ಯೇಸುನೆ ಖ್ಹಾತ್ ಭೂತ್‌ನ ಕಾಡ್ಯೋಥೊ. ");
INSERT INTO vaa_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","ತದೆ ಇನೆ ಜೈ಼ನ್, ಇನಕೇಡೆ ಥೂತೆ ಇವ್ಣುನ ಬೋಲಿ; ಇವ್ಣೆ ಘಣು ದುಖ್‌ಥಿ ರೊವ್‌ಕರ್ತುಥು; ");
INSERT INTO vaa_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","“ಯೇಸು ಜಿವ್ತೊಹುಯಿನ್ ಉಠಿರ‍್ಹೋಸ್, ಮನ ದೆಖಾಯೊ” ಕರಿ ಇನೆ ಬೋಲಿತೆ ವಾತೆನ ಖ್ಹಮ್‌ಜ್ಯು, ಕತೋಬಿ ಇವ್ಣೆ ಇನ ವಿಶ್ವಾಸ್ ಕರ‍್ಯುಕೊಯ್ನಿ. ");
INSERT INTO vaa_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","ಅನ ಬಾದ್‌ಮ, ಶಿಷ್ಯರ್‌ಮ ಬೇ ಜ಼ಣ ಏಕ್‍ ಗಾಮ್‌ನ ಚಾ಼ಲಿ ಜಾ಼ವಾನಿ ವಖ್ಹತ್‌ಮ, ಯೇಸು ಕೋಣ್‌ಬಿ ಖ್ಹಣೇದ್ ಧರಾನ ಕೋ ಹುವ್ವಾನಿತೆ ಇಮ್ನಿ ರೂಪ್‌ಮ ಇವ್ಣುನ ದೆಖಾಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","ಇವ್ಣೆ ಜೈ಼ನ್ ಬಿಜ಼ ಖ್ಹಾರಾನ ಬೋಲ್ಯು, ಕತೋಬಿ ಅವ್ಣಿ ವಾತೆನಾಬಿ ಇವ್ಣೆ ನಂಬ್ಯುಕೊಯ್ನಿ. ");
INSERT INTO vaa_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","ಬಾದ್‌ಮ ಗ್ಯಾರ‍್ಹ ಜ಼ಣ ಶಿಷ್ಯರ್‌ ಭರೈನ್ ಖಾಣು ಖವ಼್‌ಕರ್ತಥಾತೆ ತದೆ ಯೇಸು ಇವ್ಣುನಾಬಿ ದೆಖಾಯೊ. ಯೋ ಜಿವ್ತೊ ಹುಯಿನ್ ಉಠಾನ ಬಾದ್‌ಮ, ಇನ ದೇಖಾವಾಳನಿ ವಾತೆನ ಇವ್ಣೆ ನಂಬ್ಯುಕೊಂತೆ ಇನಾಖ್ಹಾಜೆ ಯೇಸುನೆ, ಇವ್ಣುನ ವಿಶ್ವಾಸ್‍ಕೊಂತೆ ಅಜು಼ ಇವ್ಣ ಬಂಡಾನ ದಿಲ್‌ನಖ್ಹಾಜೆ ಇವ್ಣುನ ಗುರ್‌ಕಾಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","ಅನ ಬಾದ್‌ಮ ಇವ್ಣುನ, “ತುಮೆ ಜಗತ್ನಿ ಖ್ಹಾರಿ ಬಾಜು಼ಮ ಜೈ಼ನ್‌ ತಮಾಮ್‌ ಅದ್ಮಿನ ದೇವ್ನಿ ಅಛ್ಛಿ ಖಬರ್‌ನ ಬೋಲ್‌ನು. ");
INSERT INTO vaa_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","ನಂಬಿನ್, ಬ್ಯಾಪ್ತಿಸ್ಮ ಕರೈಲೆವಾಳು ದೇವ್ನಿ ನ್ಯಾವ್‍ನಿ ತೀರ್ಪ್‌ಥಿ ಬಚಿನ್ ಪರ್‌ಲೋಕ್‌ಮ ಜಾ಼ಶೆ; ಕೋಣ್ ನಂಬಾಕೊಯ್ನಿಕಿ ಇವ್ಣುನ ನಿಶತ್‌ಮಳ್‌ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","ಅತ್ರೇಸ್ ಕಾಹೆತೆ, ನಂಬವಾಳಾನ ಅದ್ಭುತ್ ಕರಾನಿ ಶಕತ್ ದೆವಾವ್‌ಶೆ; ಮಾರು ನಾಮ್ ಬೋಲಿನ್ ಭೂತ್‌ಖ್ಹಾರು ನಖ್ಹಾಡ್‌ಶೆ; ಇವ್ಣೆ ಬೋಲಿಸ್‍ರಾಖ್ಯುಕೊಂತೆ ನವಿ ಬೋಲಿಥಿ ಬೋಲ್‌ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","ಇವ್ಣೆ ಖ್ಹಾಪ್‌ನಖ್ಹಾರು ಪಾಡ್ಯುತೋಬಿ ನಾತೊ ಝಾರ್‌ ಪೀಲಿದುತೋಬಿ ಇವ್ಣುನ ಶಾತ್ಬಿ ಖರಾಬ್ ಕೋ ಉಶೇನಿ; ಇವ್ಣೆ ರೋಗ್‌ವಾಳನ ಉಪ್ಪರ್ ಹಾತ್‌ ಮ್ಹೇಲಿತೊ ಯೋ ರೋಗ್‌ವಾಳನ ಅಛ್ಛು಼ ಹುಯಿಜಾ಼ಶೆ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","ಯೇಸು ಪ್ರಭುನೆ ಇವ್ಣ ಜೋ಼ಡೆ ಆ ಖ್ಹಾರು ಬೋಲಿನ್ ಹುಯಿಜಾ಼ವಾನ ಬಾದ್‌ಮ ಇಮ್ಮಸ್ ಸೊರ್ಗಮ ಪಡೈಗಯೊ ಅಜು಼ ಯೇಸು ದೇವ್ನ ಖಾವಿ ಬಾಜು಼ಮ ಬೇಶಿಗಯೊ. ");
INSERT INTO vaa_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","ಹೈಕಡ್ ಇನು ಶಿಷ್ಯರ್‌ ಚ಼ಲ್ಯೂಜೈ಼ನ್ ಖ್ಹಾರಿ ಬಾಜು಼ ದೇವ್ನಿ ಅಛ್ಛಿ ಖಬರ್‌ನ ಬೋಲ್ಯು. ಅಜು಼ ಪ್ರಭುನೆ ಇವ್ಣ ಜೋ಼ಡೆಸ್ ರ‍್ಹೀನ್ ಖ್ಹಣೇದ್‍ನು ಅದ್ಭುತ್ ಕಾಮ್‌ಖ್ಹಾರು ಕರಿನ್, ಇವ್ಣೆ ಬೋಲಾತೆ ಖ್ಹಾರು ಖ್ಹಾಚಿಸ್‌ಕರಿ ವತಾಳಿದೇತೊ ರ‍್ಹೇತೊಥೊ.");
INSERT INTO vaa_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","2","ಪ್ಯಾರ್‌ನೊ ಥಿಯೊಫಿಲ, ಅಪ್ಣ ಇಚ಼್‌ಮ ಚಾ಼ಲಿರ‍್ಹೀತೆ ಕಾಮ್‍ಅಖ್ಖಾನ ಇನಿ ಬಾರೇಮ ಪಹಿಲೇಥು ಡೋಳೆಖ್ಹು ದೇಖಿನ್, ದೇವ್ನಿ ಅಛ್ಛಿ ಖಬರ್‌ನ ಬೋಲಿದ್ಯವಾಳು ಅಪ್ಣುನ ಖ್ಹಮ್‌ಜಾ಼ಡ್ಯುಥೂತೆ ಇಮ್ಮಸ್, ಲೀಖಾನ ಕೈಯೆಕ್ಕಿ ಅದ್ಮಿನೆ ಕೋಶಿಶ್ ಕರಿರಾಖ್ಯುಸ್. ");
INSERT INTO vaa_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","ಮೇಬಿ ಜ಼ಡ್‌ಥುಧರಿ ಮೂಳಿಲಗು ಅಛ್ಛಿನಿತರ ಪುಛೈ಼ನ್, ಮಾಲುಮ್‌ ಕರಿರಾಖ್ಯೋಸ್ತೆ ಇನಾಖ್ಹಾಜೆ, ಯೋ ಖ್ಹಾರಸ್ನ ಏಕಾಡಿಥು ಥಿಯೊಫಿಲ ಹುಯಿರ‍್ಹೋತೆ ತುನ ಲೀಖಿನ್ ವತಾಳನು ಅಛ್ಛು಼ಕರಿ ಮನ ಸೋಚಾ಼ಯು. ");
INSERT INTO vaa_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","ಅನೇಥಿ ತುನ ಶಿಕಾಡ್ಯೂತೆ ಖ್ಹಾರುಸ್ ಖ್ಹಾಚು಼ಕರಿ ತೂ ಮಾಲುಮ್ ಕರಿಲಿಶ್‌. ");
INSERT INTO vaa_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","ಹೆರೋದ ಯೂದಾಯ ಮುಲಕ್‌ನೊ ರಾಜ಼ ಹುಯಿರ‍್ಹೊಥೋತೆ ಹಗಾಮ್ಮ, ಜಕರೀಯ ಕರಿ ಏಕ್‌ ಯಾಜಕ್ ಹಿಜ್ಜಾ಼ ಥೊ, ಯೋ ಅಬೀಯ ಯಾಜಕ್‌ನೊ ಖೂಮ್‌ವಾಳೊ ಹುಯಿರ‍್ಹೋಥೊ. ಇನಿ ಬಾವಣ್ಣು ನಾಮ್ ಎಲಿಜ಼ಬೇತ್‍, ಯೋ ಆರೋನ್ನಿ ಕುಟುಂಬ್‌ವಾಳಿ ಹುಯಿರ‍್ಹೀಥಿ.‌ ");
INSERT INTO vaa_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","ಇವ್ಣೆ ಭೇ ಜ಼ಣ ದೇವ್ನ ಡೋಳಾಮ ಅಛ಼್ಛ ಹುಯಿರ‍್ಹಾಥ ಅಜು಼ ಪ್ರಭುನಿ ಖ್ಹಾರಿಸ್ ಖಾನುಲ್‌ ಅಜು಼ ಹುಕುಮ್‌ನ ಪಾಡಿ ಚಾ಼ಲಿನ್, ಜ಼ರಾಬಿ ಗಲ್ತಿಕೊಂತೆ ಇಮ್‌ ಥಾ. ");
INSERT INTO vaa_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","ಕತೋಬಿ ಎಲಿಜ಼ಬೇತ್‌ ವಾಂಝ಼್‌ಣಿ ಹುಯಿರ‍್ಹಿಥೀತೆ ಇನಾಖ್ಹಾಜೆ ಇವ್ಣುನ ಲಡ್ಕಾ ಕೋ ಥಾನಿ. ಎತ್ರೇಸ್ ಕಾಹೆತೆ ಇವ್ಣೆ ಭೇ ಜ಼ಣ ಬುಢಾ ಹುಯಿಗಾಥ. ");
INSERT INTO vaa_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","ಅಮ್ ರ‍್ಹಾವಾನಿ ವಖ್ಹತ್‌ಮ, ಏಕ್‌ ದನ್ನೆ ಜಕರೀಯಾನಿ ಶಾಲ್‌ವಾಳಾನ ದೇವ್ನಿ ಮಂದಿರ್‌ಮ ಯಾಜಕ್ನು ಕಾಮ್ ಕರಾನಿ ವಖ್ಹತ್ ಆವ್ತಾನ, ಜಕರೀಯ ದೇವ್ನ ಖ್ಹಾಮ್ಣೆ ಯಾಜಕ್‍ನಿಸೇವೆ ಕರುಕರ್ತೊಥೊ. ");
INSERT INTO vaa_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","ಯಾಜಕ್‌ಖ್ಹಾರು ಮಳಿನ್, ಪ್ರಭುನಿ ಮಂದಿರ್‌ನ ಮಹಿ ಜೈ಼ನ್, ಢಪ್ಕಾರ್‌ ದ್ಯವಾನಟೇಕೆ ಚೀಟಿ ನಾಖಿನ್ ಏಕ್‌ ಯಾಜಕ್‌ನ ಚೂ಼ಣ್‌ತೂಥು. ಇಮ್‌ ಕರಾಖ್ಹತರ್ ಜಕರೀಯ ಚೂ಼ಣಾಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","ಢಪ್ಕಾರ್‌ ದ್ಯವಾನಿ ವಖ್ಹತ್‌ಮ ಭಾರ್ ಭರೈರ‍್ಹುಥೂತೆ ಅದ್ಮಿಖ್ಹಾರು ದೇವ್ನ ಪ್ರಾರ್ಥನೆ ಕರುಕರ್ತುಥು. ");
INSERT INTO vaa_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","ತದೆ ಪ್ರಭುನೊ ದೂತ ಢಪ್ಕಾರ್‌ ದ್ಯವಾನಿ ಢಾಕ್ಣಿನ ಖಾವಿ ಬಾಜು಼ಮ ಆಯಿ ಭೀರಿನ್, ಜಕರೀಯಾನ ದೆಖಾಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","ಜಕರೀಯಾನೆ ದೇವ್‌ನೊ ದೂತನ ದೇಖಿನ್ ಧರ್‌ಧರ್‌ ಕಾಪಿನ್, ಡರ್‌ಘಲ್ಲಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","ಕತೋಬಿ ದೇವ್‌ನೊ ದೂತನೆ ಇನ, “ಜಕರೀಯ, ಡರ್‌ನಕೊ! ದೇವ್ನೆ ತಾರಿ ಬಿಂತಿನ ಖ್ಹಮ್‌ಜಿಲಿದೊ. ತಾರಿ ಬಾವಣ್‍ ಹುಯಿರ‍್ಹೀತೆ ಎಲಿಜ಼ಬೇತ್‌ ತುನ ಏಕ್‌ ಪರ್ಖ್ಹೊ ಲಡ್ಕಾನ ಜ಼ಣಿ ದಿಶೆ. ತೂ ಯೋ ಲಡ್ಕಾನ ಯೋಹಾನ ಕರಿ ನಾಮ್ ಮ್ಹೇಲ್ನು. ");
INSERT INTO vaa_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","ಯೋ ಲಡ್ಕಾಥಿ ತುನ ಘಣು ಖ್ಹುಶಿ ಅಜು಼ ಶಂತೋಖ್ಹ್‌ ಉಶೆ, ಎತ್ರೇಸ್ ಕಾಹೆತೆ ಯೋ ಪೈದಹುಯೊತೆ ಇನಾಟೇಕೆ ಕೈಯೆಕ್ಕಿ ಜ಼ಣು ಖ್ಹುಶೀಕರ್‌ಶೆ! ");
INSERT INTO vaa_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","ಪ್ರಭುನ ಡೋಳಾಮ ಯೋಹಾನ ಮಹಾನ್ ಅದ್ಮಿ ಹುಯಿರ‍್ಹಿಶೆ. ಕಂದಾಯುಹುಯು ದ್ರಾಕ್ಷಿನು ರಖ್ಹ್‌ನ ರ‍್ಹವೊ ನತರ್‌ಕಿ ಕೆಹೂಬಿ ನಿಶಾನುರಖ್ಹ್‌ನ ರ‍್ಹವೊ ಯೋ ಪೀಶೆಸ್‌ ಕೊಯ್ನಿ. ಪೈದಾಖ್ಹ್‌ಥೋಸ್‌ ಯೋ ಪವಿತ್ರಾತ್ಮಥಿ ಭರೈರ‍್ಹೀಶೆ. ");
INSERT INTO vaa_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","ಅಜು಼ ಇಸ್ರಾಯೇಲ್‌ನ ಘಣ ಅದ್ಮಿನ ಇವ್ಣೊ ದೇವ್ ಹುಯಿರ‍್ಹೋತೆ ಪ್ರಭುಭಣಿ ಫರಾವ್‌ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","ಯೋ ಪ್ರಭುನ ಅಗಾಡಿ ಜೈ಼ನ್, ಪ್ರವಾದಿ ಎಲೀಯನಿಘೋಣಿ ಮಹಿಮೆಮಾಬಿ ಶಕತ್‍ಮಾಬಿ ಭರೈನ್, ಬಾನ ದಿಲ್ನ ಲಡ್ಕಾವ್‌ಭಣಿ ಫರಾವ್‌ಶೆ, ಅಜು಼ ಮೊಂಡಿ ಖ್ಹಾರಾನ ನೀತಿನಿ ವಾಟ್‌ಭಣಿ ಫರಾವ್‌ಶೆ. ಅಮ್‍ ಪ್ರಭುನ ಅಛ಼್ಛ ಅದ್ಮಿನ ತೈಯಾರ್ ಕರ್ಶೆ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","ತದೆ ಜಕರೀಯಾನೆ ದೇವ್ನ ದೂತನ, “ತೂ ಬೋಲುಕರಾಸ್ತೆ ಉಷೆಕರಿ ಮೇ ಶನೇಥಿ ಮಾಲುಮ್‌ಕರು?‌ ಶನಕತೊ ಮೇ ಬುಢೋ ಹುಯಿಗಯೊ, ಮಾರಿ ಬಾವಣ್‌ಬಿ ಬುಢಿಯಾ ಹುಯಿಗೈ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","ಇಮ್‌ ಬೋಲಾಖ್ಹತರ್ ದೇವ್‌ನೊ ದೂತನೆ, “ಮಾರು ನಾಮ್ ಗಬ್ರಿಯೇಲ್, ಮೇ ದೇವ್ನ ಖ್ಹಾಮ್ಣೆ ಭೀರ‍್ಯಾವವಾಳೊ, ತಾರ ಜೋ಼ಡೆ ವಾತೆಬೋಲಿನ್, ಆ ಸುವಾರ್ತೆನ ತುನ ಖ್ಹಮ್‍ಜಾ಼ಡನಖ್ಹಾಜೆ ದೇವ್ನೆ ಮನ ಮೋಕ್ಲಿರಾಖ್ಯೊಸ್. ");
INSERT INTO vaa_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","ಆ ಮಾರಿ ವಾತೆ ಬರೋಬರ್‌ನಿ ವಖ್ಹತ್‌ಮ ಪೂರಉಶೆ. ಕತೋಬಿ ತುನೆ ಆ ವಾತೇನ ನಂಬ್ಯೊಕೊಂತೆ ಇನಖ್ಹಾಜೆ, ಆ ಖ್ಹಾರು ಹುವಾನ ದನ್‌ತೋಡಿ ತೂ ವಾತೆ ಕೋಬೋಲಿಶ್‍ನೀತೆ, ಮುಕ್ಕೊ ಹುಯಿರ‍್ಹೀಶ್” ಕರಿ ಜವಾಬ್‌ ದಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","ಯೋಸ್ ವಖ್ಹತ್‌ಮ ಜಕರೀಯಾನ ಖ್ಹಾಜೆ ಭಾರ್‌ ಟಿವವ್‍ಕರ್ತುಥೂತೆ ಅದ್ಮಿಖ್ಹಾರು, ಔಡಿ ಘಡಿಲಗೂ ಯೋ ಮಂದಿರ್‌ನ ಮಹಿ ಶನ ಛಾ಼ತೆ ಕರಿ ಬೋಲಿನ್ ಆಶ್ಚರ್ಯಖಾದು. ");
INSERT INTO vaa_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","ಯೋ ಮಂದಿರ್‌ಮಾಥೊ ಭಾರ್‌ಆಯಿನ್, ಇವ್ಣ ಜೋ಼ಡೆ ಏಕ್‌ ವಾತ್‍ಬಿ ಬೋಲ್ಯೊಕೊಂತೆ ದೇಖಿನ್, ಅನ ಮಂದಿರ್‌ಮ ಶಾತ್ಕಿ ದರ್ಶನ್ ಹುಯು ಉಶೆ ಕರಿ ಮಾಲುಮ್ ಕರಿಲಿದು. ತಪ್‌ಥೊ ಜಕರೀಯ ಮುಕ್ಕೋಸ್ ರ‍್ಹೀನ್ ಹಾತ್‌ನೊ ಝಾ಼ಲೊಥೀಸ್ ಬೋಲಿವತಾಳ್‌ತೋಥೊ. ");
INSERT INTO vaa_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","ಮಂದಿರ್‌ಮ ಇನಿ ಯಾಜಕ್‌ನಿ ಸೇವೆನೊ ದನ್‌ಖ್ಹಾರೊ ಖತಮ್ ಹುವಾನ ಬಾದ್‌ಮ, ಜಕರೀಯ ಪಾಛೊ಼ ಇನ ಘರೆ ಚ಼ಲೆಗಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","ಥೋಡ ದನ್ನ ಬಾದ್‌ಮ ಇನಿ ಬಾಯ್ಕೊ ಎಲಿಜ಼ಬೇತ್‌ ಬೇಜೂನಿ ಹುಯಿನ್, ಪಾಚ಼್ ಮಹಿನಾತೋಡಿ ಘರ್‌ಥಿ ಭಾರ್‌ ಕೋ ನಿಕ್ಳಿನಿ. ");
INSERT INTO vaa_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","ತದೆ ಎಲಿಜ಼ಬೇತ್‌ನೆ, “ಆ ಉಂಬರ್‌ಮ ಪ್ರಭುನೆ ಮಾರಪರ್ ಡೋಳಪಾಡಿ ದೇಖ್ಯೊ. ಅನೇಥಿ ಅದ್ಮಿಮ ಮನ ಥೂತೆ ಚಿಂಘಾವ್ಣಿನ ದೂರ್ ಕರ‍್ಯೊ” ಕರಿ ಬೋಲಿ. ");
INSERT INTO vaa_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","ಎಲಿಜ಼ಬೇತ್‌ ಛೊ಼ ಮಹಿನಾನಿ ಬೇಜೂನಿ ಥೀತೆ ತದೆ, ದೇವ್ನೆ ಗಬ್ರಿಯೇಲ್ ಕರಿ ನಾಮ್ನ ದೂತನ ಗಲಿಲಾಯ ತಬರ್‌ಖಾನು ನಜ಼ರೇತ್ ಕರಿ ಗಾಮ್ಮ ಥೀತೆ ಏಕ್‌ ಕವಾರಿಕನ ಮೋಕ್‌ಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","ಯೊ ಕವಾರಿನು ನಾಮ್ ಮರಿಯ. ದಾವೀದ್‌ ರಾಜಾ಼ನಿ ಪಿಳ್ಗಿವಾಳೊ ಹುಯಿರ‍್ಹೊಥೋತೆ ಯೋಸೇಫ್‌ನ ಜೋ಼ಡೆ ಇನಿ ಖ್ಹಗೈ ಪಡಿರ‍್ಹೀಥಿ. ");
INSERT INTO vaa_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","ಯೋ ದೇವ್‌ನೊ ದೂತನೆ ಮರಿಯನ, “ದೇವ್ನಿ ಆಶೀರ್ವಾದ್‌ವಾಳಿ, ತುನ ಸಮಾಧಾನ್ ಹುವಾದೆ! ಪ್ರಭು ದೇವ್ ತಾರ ಜೋ಼ಡೆ ಛಾ಼!” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","ದೇವ್‌ನು ದೂತರ್‌ನಿ ವಾತೇನ ಖ್ಹಮ್‌ಜಿನ್‌ ಮರಿಯ ಘಬ್‌ರೈಗೈ ಅಜು಼ ಆ ವಾತೆನಿ ಮತ್‌ಲಬ್ ಶಾತ್‌ ಉಶೆ? ಕರಿ ಸೋಚಾಲಗಿ. ");
INSERT INTO vaa_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","ತದೆ ದೇವ್‌ನೊ ದೂತನೆ ಇನ, “ಮರಿಯ ಡರ್‌ನಕೊ, ದೇವ್ನೆ ತಾರಪರ್ ಘಣಿ ಮೋಟಿ ವಾರ್‌ಖ್ಹೊ ಕರಿರಾಖ್ಯೋಸ್. ");
INSERT INTO vaa_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","ಹಂದೇಕ್, ತೂ ಬೇಜೂನಿ ಹುಯಿನ್ ಏಕ್‌ ಪರ್ಖ್ಹೊ ಲಡ್ಕಾನ ಜ಼ಣಿಶ್, ಯೋ ಲಡ್ಕಾನ ಯೇಸು ಕರಿ ನಾಮ್ ಮ್ಹೇಲ್ನು. ");
INSERT INTO vaa_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","ಯೋ ಮೋಟೊ ಅದ್ಮಿಹುಯಿನ್ ಪರಮಂಡಲ್‌ನೊ ದೇವ್‌ನೊ ಛಿಯ್ಯೊ ಕರಿ ಬೋಲೈಲಿಶೆ. ದೇವ್ ಹುಯಿರ‍್ಹೋತೆ ಪ್ರಭು ಇನೊ ಗುರುಗುರಬ್‌ಲ್ಯೊ ಹುಯಿರೋತೆ ದಾವೀದ್‌ನಿ ಸಿಂಹಾಸನ್ನ ಇನ ದಿಶೆ. ");
INSERT INTO vaa_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","ಅಜು಼ ಯೋ ಯಾಕೋಬ್‍ನಿ ಪಿಳ್ಗಿಪರ್ ಹರ್‌ಹಮೇಶಾನಖ್ಹಾಜೆ ರಾಜ್‍಼ಕರ್‌ಶೆ. ಇನಿ ರಾಜ್ಯ ಖತಮಸ್ ಕೋ ಉಶೇನಿ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","ತದೆ ಮರಿಯನೆ, “ಆ ಕಿಮ್ ಉಶೆ? ಮೇ ಕವಾರಿನಿ” ಕರಿ ದೇವ್‌ನೊ ದೂತನ ಬೋಲಿ. ");
INSERT INTO vaa_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","ತದೆ ದೇವ್‌ನೊ ದೂತನೆ ಮರಿಯನ, “ತಾರಪರ್ ಪವಿತ್ರಾತ್ಮ ಆವ್‌ಶೆ ಅಜು಼ ದೇವ್ನಿ ಶಕತ್‍ ಆಯಿನ್ ತಾರಪರ್ ಢಪಾವ್‌ಶೆ, ಅನಖ್ಹಾಜೆಸ್ ಪೈದಾ ಉಷೇತೆ ಯೋ ಪವಿತ್ರ ಲಡ್ಕು ದೇವ್‌ನೊ ಛಿಯ್ಯೊ ಕರಿ ಬೋಲೈಲಿಶೆ” ಕರಿ ಜವಾಬ್‌ ದಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","ಎತ್ರೇಸ್ ಕಾಹೆತೆ ತಾರಿ ಖನ್ನೆವಾಳಿ ಹುಯಿರ‍್ಹೀತೆ ಎಲಿಜ಼ಬೇತ್‌ ಛಾ಼ನಿ, ಯೋ ಬುಢಿಯಾ ಹುಯಿಗಿತೋಬಿ ಬೇಜೂನಿ ಛಾ಼. ಇನ ಪೇಟ್‌ಮ ಪರ್ಖ್ಹೊ ಲಡ್ಕು ಛಾ಼, ವಾಂಝ಼್‌ಣಿ ಕರಿ ಬೊಲೈಲಿದಿಥೀತೆ ಇನ ಆ ಛೋ಼ನೆ ಮಹಿನೊ. ");
INSERT INTO vaa_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","ಶನಕತೊ ದೇವ್ನ ಹಾತೆ ಹುವ್ವಾಕೊಂತೆ ಏಕ್‌ಬಿ ಕೊಯ್ನಿ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","ತದೆ ಮರಿಯನೆ, “ಮೇ ಪ್ರಭುನಿ ದಾಸಿ, ತುನೆ ಕಿಮ್ ಬೋಲ್ಯೋಕಿ ಇಮ್ಮಸ್ ಮನ ಹುವಾದೆ” ಕರಿ ಬೋಲಿ. ಅನ ಬಾದ್‌ಮ ಯೋ ದೇವ್‌ನೊ ದೂತ ಇನಕಂಥೊ ಚ಼ಲೆಗಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","ತದ್‌ನು-ತದ್ದೇಸ್ ಮರಿಯನೆ ಖ್ಹವಾರಿಲೀನ್, ಒಗ್ಗಿ-ಒಗ್ಗಿಸ್ ಪಹಾಡ್‌ನು ಮುಲಕ್‌ಭಣಿ ಥೂತೆ ಯುದಾಯ ತಬರ್‌ಖಾನು ಏಕ್‌ ಗಾಮ್‌ನ ಗೈ. ");
INSERT INTO vaa_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","ಹಿಜ್ಜಾ಼ ಜಕರೀಯಾನ ಘರ್‌ಮ ಜೈ಼ನ್ ಎಲಿಜ಼ಬೇತ್‌ನ ಖ್ಹಲಾಮ್ ಕರಿ. ");
INSERT INTO vaa_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","ಮರಿಯನೆ ಖ್ಹಲಾಮ್ ಕರಿ ಬೋಲಿತೆ ಅವಾಜ಼್ ಎಲಿಜ಼ಬೇತ್‌ ಖ್ಹಮಜ಼್‌ತಾನ, ಇನ ಪೇಟ್‌ಮಾನು ಲಡ್ಕು ಉಛ಼್‌ಳಿ ಪಡ್ಯು. ಅಜು಼ ಎಲಿಜ಼ಬೇತ್‌ ಪವಿತ್ರಾತ್ಮಥಿ ಭರೈಗಿ. ");
INSERT INTO vaa_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","ಜೋ಼ರ್ ಆವಾಜ಼್‌ಥಿ ಚಿಕ್ರಿನ್ ಬೋಲಿಕಿ, “ಮರಿಯ, ದೇವ್ನೆ ತುನ ಬಿಜಿ ಖ್ಹಾರಿ ತಯೇಡಾಥೀಬಿ ಜಾ಼ಖ್ಹತ್ ಆಶೀರ್ವಾದ್‌ ಕರಿರಾಖ್ಯೋಸ್. ತೂ ಪೈದಾ ಕರೀಶ್ತೆ ಲಡ್ಕಾನ ದೇವ್ನೆ ಆಶೀರ್ವಾದ್‌ ಕರಿರಾಖ್ಯೋಸ್. ");
INSERT INTO vaa_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","ಮಾರ ಪ್ರಭುನಿ ಆಯ ಮಾರಕನ ಆವಾಯೆತ್ರೆ ಭಾಗ್ಯ, ಮನ ಕಿಜ್ಜಾ಼ಥಿ ಮಳ್‌ಷೆ? ");
INSERT INTO vaa_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","ಹಂದೇಕ್, ತೂ ಖ್ಹಲಾಮ್ ಕರಿ ಬೋಲಿತೆ ಅವಾಜ಼್ ಮಾರ ಕಾನ್‌ಮ ಪಡ್‌ತಾಸ್‌ನ, ಮಾರ ಪೇಟ್‌ಮಾನು ಲಡ್ಕು ಖ್ಹುಶೀಥಿ ಉಛ಼್‌ಳಿ ರಹಿಗು. ");
INSERT INTO vaa_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","ಪ್ರಭುನೆ ತುನ ಬೋಲ್ಯೋತೆ ವಾತೆ ಉಷೆಕರಿ ನಂಬಿತೆ ಇನಖ್ಹಾಜೆ ತೂ ಧನ್ಯಹುಯಿರ‍್ಹೀಸ್”! ");
INSERT INTO vaa_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","ತದೆ ಮರಿಯನೆ, “ಮಾರೊ ಜಾನ್‌ ಪ್ರಭುನ ಸ್ತುತಿ ಕರಾಸ್. ");
INSERT INTO vaa_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","ದೇವ್ ಮನ ಬಚಾ಼ಡವಾಳೊ ಹುಯಿರ‍್ಹೋಸ್ತೆ ಇನಖ್ಹಾಜೆ ಮಾರು ಆತ್ಮ ಖ್ಹುಶಿ ಛಾ಼. ");
INSERT INTO vaa_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","ದೇವ್ನಿ ದಾಸಿ ಹುಯಿರ‍್ಹೀತೆ ಮೇ, ಲ್ಹಾಯಕ್‌ಕೊಂತೆ ಇಮ್‍ಥೀತೆ ತದೆ, ಇನೆ ಮನ ಯಾದ್ ಕರ‍್ಯೊ! ಖ್ಹಾಚಮಾಬಿ ಹಂಕೇಥು ತಮಾಮ್‌ ಅದ್ಮಿ ಮನ ದೇವ್ನಿ ಆಶೀರ್ವಾದ್‌ವಾಳಿ ಕರಿ ಚಿಕರ್‌ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","ಶನಕತೊ ಘಣಿ ಶಕತ್‌ವಾಳೊ ದೇವ್ ಮಾರಖ್ಹಾಜೆ ಮಹಾನ್ ಕಾಮ್‌ಖ್ಹಾರು ಕರಿರಾಖ್ಯೋಸ್. ಇನು ನಾಮ್ ಪವಿತ್ರ್‌ ಹುಯಿರ‍್ಹೂಸ್. ");
INSERT INTO vaa_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","ಕೋಣ್ ದೇವ್‌ಮ ಪೂರ ಮನ್‌ಥಿ ಡರಿನ್ ಚಾ಼ಲಸ್ಕಿ ಇವ್ಣಾಪರ್ ದೇವ್ ಮುಂಡಿಥು ಧರಿನ್ ಮುಂಡಿಲಗೂ ಗೋರ್‌ ಕರಾವಾಳೊ ಹುಯಿರ‍್ಹೊಸ್. ");
INSERT INTO vaa_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","ದೇವ್ನೆ ಇನಿ ಭುಜ಼್‌ನಿ ಶಕತ್ ವತಾಳಿನ್, ಹಂಕಾರ್ ಭರ‍್ಯಾ ದಿಲ್‌ವಾಳಾನ ಛಿಂಧೊಭಾಂಗ್‌ ಕರಿನಾಖ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","ದೇವ್ನೆ ರಾಜಾ಼ವ್‌ನ ಸಿಂಹಾಸನ್‌ಪರ್‌ಥು ಧಕೇಲಿನ್, ಶಾತ್ಬಿಕೊಂತೆ ಗರೀಬ್‌ನ ಉಪ್ಪರ್ ಲೈರಾಖ್ಯೊಸ್. ");
INSERT INTO vaa_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","ಯೋ ಭುಕ್ಯಾವ್‌ನ ಮಿಝ಼್‌ವಾನ್ ಖಡಾಯೊ, ಕತೋಬಿ ಧನ್‌-ದೌಲತ್‌ವಾಳಾನ ಖಾಲಿ ಹಾತೆ ಮೋಕ್ಲಿದಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","ದೇವ್ನೆ ಅಪ್ಣ ಗುರುಗುರಬ್‍ಲ್ಯನ ವಾಗ್ದಾನ್ ದಿದೊತೆ ಇಮ್ಮಸ್, ಇನೊ ಸೇವಕ್ ಹುಯಿರ‍್ಹೋತೆ ಇಸ್ರಾಯೇಲ್‌ನೊ ಹಾತ್‌ ಧರಿರಾಖ್ಯೋಸ್‌. ");
INSERT INTO vaa_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","ಅಬ್ರಹಾಮ್‌ನಾಬಿ ಇನಿ ಪಿಳ್ಗಿವಾಳಾನ ಹರ್‌ಹಮೇಶ ಗೋರ್‌ ವತಾಳ್ಣು ಕರಿ ಯಾದ್ ಕರಿರಾಖ್ಯೋಸ್!” ಕರಿ ಬೋಲಿ. ");
INSERT INTO vaa_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","ಮರಿಯ ತೀನ್ ಮಹಿನಾತೋಡಿ ಎಲಿಜ಼ಬೇತ್‌ನ ಜೋ಼ಡೆ ರ‍್ಹೀನ್ ಪಾಛಿ ಫರೀನ್ ಇನ ಘರೆ ಗೈ. ");
INSERT INTO vaa_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","ದನ್ ಭರಾವಾನ ಬಾದ್‌ಮ ಎಲಿಜ಼ಬೇತ್‌ನೆ ಏಕ್‌ ಪರ್ಖ್ಹೊ ಲಡ್ಕು ಜ಼ಣಿ. ");
INSERT INTO vaa_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","ತದೆ ಎಲಿಜ಼ಬೇತ್‌ನ ಅಶ್‌ಪಿಶ್‌ವಾಳು ಅಜು಼ ಮಾಯಮಾತ್ರಾವ್ನೆ ಪ್ರಭುನೆ ಇನಾಪರ್‌ ಘಣು ಗೋರ್‌ ಕರ‍್ಯೊತೆ ಇನಿ ಬಾರೇಮ ಖ್ಹಮ್‌ಜಿನ್‌, ಇನಜೋ಼ಡೆ ಮಳಿನ್ ಖ್ಹುಶಿ ಕರ‍್ಯು. ");
INSERT INTO vaa_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","ಆಟ್ ರೋಜ಼್ ಹುವ್ವಾದೀನ್, ಯೋ ಲಡ್ಕಾನ ಖ್ಹತ್ನ ಕರ‍್ನು ಕರಿ ಲಾಯು. ಇವ್ಣೆ ಯೋ ಲಡ್ಕಾನ ಜಕರೀಯಕರಿ ಬಾನೂಸ್ ನಾಮ್ ಮ್ಹೇಲ್ನು ಕರಿ ಥು. ");
INSERT INTO vaa_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","ಕತೋಬಿ ಯೋ ಲಡ್ಕಾನಿ ಆಯ ಎಲಿಜ಼ಬೇತ್‌ನೆ, “ನಕೊ! ಯೋಹಾನ ಕರಿ ಮ್ಹೇಲ್ನು” ಕರಿ ಬೋಲಿ. ");
INSERT INTO vaa_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","ಇಮ್‌ ಬೋಲಾಖ್ಹತರ್ ಇವ್ಣೆ, “ಕತೋಬಿ ಅಮ್ನು ನಾಮ್ ತಾರ ಮಾಯಮಾತ್ರಾಮ ಕಿನೂಸ್ ಕೊಯ್ನಿನಿ!” ಕರಿ ಇನ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","ಬಾದ್‌ಮ ಇವ್ಣೆ ಯೋ ಲಡ್ಕಾನ ಬಾನ, ಹಾತ್‌ನೊ ಝಾ಼ಲೊ ಕರಿನ್, “ಆ ಲಡ್ಕಾನ ಕೆಹುನಾಮ್‌ ಮ್ಹೇಲ್ನು” ಕರಿ ಪುಛಾ಼ಯು. ");
INSERT INTO vaa_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","ತದೆ ಜಕರೀಯಾನೆ ಏಕ್‌ ಲೀಖಾನು ಪಲ್ಗು ಮಂಗೈನ್ ಇನಾಪರ್, “ಇನು ನಾಮ್ ಯೋಹಾನ” ಕರಿ ಲೀಖ್ಯೊ. ತದೆ ತಮಾಮ್‌ ಅದ್ಮಿನ ಆಶ್ಚರ್ಯ ಹುಯಿಗಯು. ");
INSERT INTO vaa_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","ತದ್‌ನು-ತದ್ದೇಸ್ ಜಕರೀಯ ಪಾಛು಼ ವಾತೆ ಬೋಲಾಲಗ್ಯೊ. ಅಜು಼ ವಾತೆ ಬೋಲ್ತೊಹುಯಿನ್ ದೇವ್ನಿ ಸ್ತುತಿ ಕರಾಲಗ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","ಅನ ಖ್ಹಮ್‌ಜ್ಯೂತೆ ಅಶ್‌ಪೀಶ್‌ವಾಳ ಅದ್ಮಿಮ ಡರ್‌ ಪೇಶಿಗೊ, ಅಜು಼ ಯೂದಾಯ ತಬರ್‌ಖಾನು ಪಹಾಡಿ ಮುಲಕ್ನು ಖ್ಹಾರಿ ಬಾಜು಼ಮ ಆ ವಾತೆ ಫೈಲಿಗು. ");
INSERT INTO vaa_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","ಖ್ಹಮ್‌ಜ್ಯೂತೆ ಖ್ಹಾರು ಅದ್ಮಿ ಆಶ್ಚರ್ಯ ಹುಯಿನ್, “ಆ ಲಡ್ಕು ಖ್ಹಾಮ್ಣೆ ಕಿಮ್ನು ಉಶೇಕಿ?” ಕರಿ ಅನಿ ಬಾರೇಮ ಮನ್‌ಮ ಸೋಚಾಲಗ್ಯು, ಅಜು಼ ಪ್ರಭುನೊ ಹಾತ್ ಯೋ ಲಡ್ಕಾಪರ್ ಥೊ. ");
INSERT INTO vaa_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","ತದೆ ಯೋಹಾನ್ನೊ ಬಾ ಜಕರೀಯಾನೆ ಪವಿತ್ರಾತ್ಮಥಿ ಭರೈನ್ ಅಮ್ ಪ್ರವಾದ್‌ನೆ ಬೋಲ್ಯೊ: ");
INSERT INTO vaa_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“ಇಸ್ರಾಯೇಲ್‌ನೊ ದೇವ್ ಹುಯಿರ‍್ಹೋತೆ ಪ್ರಭುನ ಧನ್ಯವಾದ್ ಹುವಾದೆ! ಇನ ಅದ್ಮಿಕನ ಐನ್, ಇವ್ಣಾಪರ್ ಗೋರ್‌ಕರೀನ್, ಇವ್ಣುನ ಛುಟ್ಕಾರ್‌ ಕರಿರಾಖ್ಯೋಸ್; ");
INSERT INTO vaa_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","ಇನೊ ಸೇವಕ್ ಹುಯಿರ‍್ಹೊಥೋತೆ ದಾವೀದ್‌ನ ಖಾನ್‌ದಾನ್‌ಮಾಥು ಅಪ್ಣಖ್ಹಾಜೆ ಘಣಿ ಶಕತ್‌ವಾಳೊ ಏಕ್‌ ರಕ್ಷಕ್‌ನ ದೀರಾಖ್ಯೊಸ್. ");
INSERT INTO vaa_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","ದೇವ್ನೆ ತದೇಸ್‌ ಇನು ಪವಿತ್ರ ಪ್ರವಾದಿ ಖ್ಹಾರಾವ್‌ನ ಮ್ಹೋಡಾಥಿ ಬೋಲಾಯೊ ಥೋತೆ ಇಮ್ಮಸ್, ");
INSERT INTO vaa_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","ಅಪ್ಣುನ ಕೋಣ್-ಕೋಣ್ ವಹೇರ್‌ ಕರುಕರ್ತುಥೂಕಿ ಇವ್ಣ ಹಾತೇಥಿ ಛೋ಼ಡೈನ್, ಅಪ್ಣ ದುಶ್‌ಮನ್‌ಥಿ ಅಪ್ಣುನ ಬಚಾ಼ಡಿರಾಖ್ಯೊಸ್. ");
INSERT INTO vaa_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","ದೇವ್ನೆ ಅಪ್ಣ ಗುರುಗುರಬ್‍ಲ್ಯನ ಗೋರ್‌ಖೈನ್, ಪವಿತ್ರ ಒಪ್ಪಂದನ ಯಾದ್‌ಕರಿನ್, ");
INSERT INTO vaa_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","ಅಪ್ಣೊ ಗಲ್‌ಢೊ ಹುಯಿರ‍್ಹೋತೆ ಅಬ್ರಹಾಮ್‌ನ ಜಿಭಾನ್‌ ದೀರಾಖ್ಯೋಥೋತೆ ಇಮ್‌, ");
INSERT INTO vaa_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","ಅಪ್ಣುನ ದುಶ್‌ಮನ್ನ ಹಾತೇಖ್ಹು ಛೋ಼ಡೈನ್, ಡರ್‌ಕೊಂತೆ ಇಮ್‌ ಇನಿ ಸೇವೆ ಕರಾನಿಮತ್‌ ಅಪ್ಣುನ ಅಕ್ಲಾಶ್‌ ಬಣೈರಾಖ್ಯೊಸ್. ");
INSERT INTO vaa_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","ಅನೇಥಿ ಅಪ್ಣೆ ಜಿವಿರ‍್ಹವಾನ ದನ್‌ಖ್ಹಾರೊ, ಇನಖ್ಹಾಮ್ಣೆ ಇಮಾನ್‌ದಾರ್ ಅಜು಼ ನೀತಿಥಿ ರ‍್ಹೇಣು ಕರಿ ಅಮ್ ಕರಿರಾಖ್ಯೋಸ್. ");
INSERT INTO vaa_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","ಅಜು಼ ಜಕರೀಯಾನೆ, “ಮಾರು ಲಡ್ಕು, ತೂತೊ, ಪರಮಂಡಲ್‌ನೊ ದೇವ್‌ನೊ ಪ್ರವಾದಿ ಕರಿ ಬೋಲೈಲಿಶ್. ತೂ ಪ್ರಭುನ ಅಗಾಡಿ ಜೈ಼ನ್, ಇನಿ ವಾಟ್ನ ಖ್ಹವಾರವಾಳೊ ಹುಯಿರ‍್ಹೀಶ್. ");
INSERT INTO vaa_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","“ಪಾಪ್‌ಖ್ಹಾರು ಮಾಪ್‌ ಹುವಾಥೀಸ್ ರಕ್ಷಣೆ ಮಳಾನು ಕರಿ, ಇನ ಅದ್ಮಿನ ಬೋಲವಾಳೊ ಹುಯಿರ‍್ಹಿಶೆ. ");
INSERT INTO vaa_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","ಅಪ್ಣೊ ದೇವ್ ದಯಕರವಾಳೊ, ಇನಿ ಗೋರ್‌ಥಿ ಅಪ್ಣುನ ಭಾಗಳ್ ಫಾಟಿ. ಅನೇಥಿ ಉಪ್ಪರ್‌ಥು ದನ್ ನಿಕ್ಳಿನ್, ಅಪ್ಣಕನ ಆವ್‌ಶೆ, ");
INSERT INTO vaa_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","ಅಜು಼ ಅಂಧಾರಮಾಬಿ, ಮರಣ್ಣಿ ಛಾ಼ಳಿಮ ರ‍್ಹವಾಳ ಖ್ಹಾರಾನ ಉಜಾ಼ಳು ದಿಶೆ, ಅಪ್ಣುನ ಸಮಾಧಾನ್ನಿ ವಾಟ್‌ ವತಾಳಿನ್ ಚ಼ಲಾವ್‌ಷೆ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","ಯೋ ಲಡ್ಕು ಮೋಟು ಹುಯಿನ್ ಆತ್ಮಮಾಬಿ ಅಜು಼ ಶಕತ್‍ಮಾಬಿ ಭಡ್ಯು, ಅಜು಼ ಇಸ್ರಾಯೇಲ್‌ ಅದ್ಮಿಯೇನ ಯೋಹಾನ ದೆಖಾವಾನ ದನ್‌ಲಗೂ ಉಜ್ಜಾ಼ಡಿ ಜ಼ಂಗಳ್‌ಮ ಥೊ. ");
INSERT INTO vaa_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","ಯೋ ದನೂಮ ಕೈಸರ್ ಅಗಸ್ಟಸ್‌ನೆ ರೋಮ್‍ನು ರಾಜ಼್‌ಭಾರ್‌ ಚಾ಼ಲುಕರಾಸ್ತೆ ಖ್ಹಾರಾಸ್ ದೇಖ್ಹ್‌ಮ ಅದ್ಮಿಖ್ಹಾರಾನಿ ಗಣ್ತಿ ಹೋಣುಕರಿ ಹುಕುಮ್ ದಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","ಆ ಪಹಿಲಿ ಬಾರ್ ಚಾ಼ಲಿತೆ ಅದ್ಮಿನಿ ಗಣ್ತಿ ಹುಯಿರ‍್ಹುಥು. ಕುರೇನ್ಯ ಸಿರಿಯ ದೇಖ್ಹ್‌ನೊ ರಾಜ್ಯಪಾಲ್ ಹುಯಿರ‍್ಹೊಥೋತೆ ತದೆ ಆ ಚಾ಼ಲ್ಯುತೆ. ");
INSERT INTO vaa_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","ತಮಾಮ್‌ ಅದ್ಮಿ, ಇವ್ಣು-ಇವ್ಣು ನಾಮ್ ಲಿಖಾವನಖ್ಹಾಜೆ ಇವ್ಣ-ಇವ್ಣ ಗಾಮೆ ಗಯು. ");
INSERT INTO vaa_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","ಇನಖ್ಹಾಜೇಸ್ ಯೋಸೇಫ್‌ಬಿ ಗಲಿಲಾಯನು ನಜ಼ರೇತ್ ಕರಿ ಗಾಮ್‌ಥು ನಿಕ್ಳಿನ್ ಯೂದಾಯ ತಬರ್‌ಖಾನು ಬೇತ್ಲೆಹೇಮ್ ಕರಿ ಗಾಮ್‌ನ ಗಯೊ. ಯೋಸೇಫ ದಾವೀದ್‌ನೊ ಖಾಂದಾನ್‌ವಾಳೊ ಹುಯಿರ‍್ಹೊಥೋತೆ ಇನಖ್ಹಾಜೆ, ದಾವೀದ್‌ನು ಗಾಮ್‍ ಹುಯಿರ‍್ಹೂತೆ ಬೇತ್ಲೆಹೇಮ್‌ನ ಗಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","ಯೋಸೇಫ್‌ನಿ ಜೋ಼ಡ್ಮ ಖ್ಹಗೈ ಪಡಿರ‍್ಹಿಥೀತೆ ಮರಿಯನಾಬಿ ಕೇಡೆ ಬಲೈಲಿನ್ ಇನು ನಾಮ್ ಲಿಖಾಡೈಲ್ಯವಾನಖ್ಹಾಜೆ ಗಯೊ. ತದೆ ಯೋ ಪೂರ ದನ್ನಿ ಬೇಜೂನಿ ಥಿ. ");
INSERT INTO vaa_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","ಇವ್ಣೆ ಬೇತ್ಲೆಹೇಮ್ಮ ಥೂತೆ ತದೆ, ಮರಿಯನ ಲಡ್ಕು ಪೈದಾ ಹುವಾನಿ ವಖ್ಹತ್ ಆಯಿ. ");
INSERT INTO vaa_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","ತದೆ ಇನೆ ಇನು ಪಹಿಲೋಟು ಪರ್ಖ್ಹೊ ಲಡ್ಕಾನ ಜ಼ಣಿನ್ ಲುಂಗ್ಡಾಮ ಲಪೇಟಿನ್, ಛ಼ತ್ತರ್‌ಮ ರ‍್ಹವಾನ ಝ಼ಗೊಕೊಂತೆ ದೇಖಿನ್, ಇನ ಗೋದ್‌ಡಿಮ ಖ್ಹುಡೈ. ");
INSERT INTO vaa_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","ಯೋ ತಬರ್‌ಖಾಮ ಮೇಂಢ ಚ಼ರಾವವಾಳು ಥೋಡು ಜ಼ಣು, ಯೋ ರಾತ್ಮ ಖೇತರ್‌ಮ ಇವ್ಣ ಮೇಂಢಾವ್‍ನಿ ಮಂಧಾನ ದೇಕ್‌ಭಾಲ್ ಕರುಕರ್ತುಥು. ");
INSERT INTO vaa_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","ತದೆ ಪ್ರಭುನೊ ಏಕ್‌ ದೂತ ಐನ್, ಮೇಂಢ ಚ಼ರಾವವಾಳಾನ ಖ್ಹಾಮ್ಣೆ ಭೀರ‍್ಯೊ. ಪ್ರಭುನು ಉಜಾ಼ಖ್ಹ್‌ ಇವ್ಣ ಅಶ್‌ಪಿಶ್‍ ಭರಾಯು. ಅನ ದೇಖಿನ್ ಇವ್ಣೆ ಡರ್‌ಥಿ ಘಬ್‌ರೈಗಯು. ");
INSERT INTO vaa_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","ಕತೋಬಿ ದೇವ್‌ನೊ ದೂತನೆ ಇವ್ಣುನ, “ಡರೊ ನಕೊ! ಮೇ ತುಮಾರಖ್ಹಾಜೆ ಅಛ್ಛಿಸಮಾಚಾರ್‌ನ ಲೈರಾಖ್ಯೊಸ್, ಅನೇಥಿ ತಮಾಮ್‌ ಅದ್ಮಿನ ಘಣು ಖ್ಹುಶಿ ಉಶೆ. ");
INSERT INTO vaa_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","ಯೋ ಶಾತ್‌ಕತೊ, ಆಜ಼್ ದಾವೀದ್‌ನ ನಂಗರ್‌ಮ ತುಮಾರಖ್ಹಾಜೆ ಏಕ್‌ ರಕ್ಷಕ್ ಪೈದಾ ಹುಯಿರ‍್ಹೋಸ್, ಯೋ ಕೋಣ್‌ಕತೊ ಪ್ರಭು ಹುಯಿರ‍್ಹೋತೆ ಕ್ರಿಸ್ತ. ");
INSERT INTO vaa_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","ಯೋ ತುಮೂನ ಮಾಲುಮ್ ಪಡಾನ ಖ್ಹಣೇದ್ ಶಾತ್‌ಕತೊ, ಲುಂಗ್ಡಾಥಿ ಲಪೇಟಿಹುಯು ಏಕ್‌ ಲಡ್ಕು, ಗೋದ್‌ಡಿಮ ಖ್ಹುತುರ‍್ಹಿಶೇತೆ ತುಮೆ ದೇಕ್‌ಶು” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","ಯೋಸ್ ವಖ್ಹತ್‌ಮ ಪರಲೋಕ್‌ಥು ದೇವ್ ದೂತರ್‌ನು ಮೋಟಿ ಝೂ಼ಂಡ್‌ ಆಯಿನ್, ಯೋ ಪಹಿಲು ದೇವ್ ದೂತನ ಜೋ಼ಡೆ ಮಳಿನ್, ದೇವ್ನ ಸ್ತುತಿ ಕರ‍್ಯು: ");
INSERT INTO vaa_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“ಉಪ್ಪರ್‌ಲ್ಯಲೋಕ್‍ಮ ದೇವ್ನ ಮಹಿಮೆ ಹುವಾದೆ, ಅಜು಼ ಧರ್ತಿಪರ್ ದೇವ್ನ ಕೋಣ್ ಖ್ಹಾಜ಼ಸ್ಕಿ ಇವ್ಣುನ ಶಾಂತಿ. ");
INSERT INTO vaa_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","ದೇವ್‌ದೂತರ್‌ ಇವ್ಣಕಂಥು ಪಾಛು಼ ಪರ್‌ಲೋಕ್ ಚ಼ಲ್ಯುಜಾ಼ವಾನ ಬಾದ್‌ಮ, ಮೇಂಢ ಚ಼ರಾವವಾಳು ಏಕ್‌ಥಿ ಏಕ್‌, “ಅಪ್ಣೆ ಹಮ್ಕೇಸ್ ಬೇತ್ಲೆಹೇಮ್‌ನ ಜೈ಼ನ್, ಪ್ರಭುನೆ, ಅಪ್ಣುನ ಮಾಲುಮ್ ಕರಾಯೋತೆ ಆ ಬಾರೇಮ, ಚಾ಼ಲ್ಯುತೆ ಇನ ದೇಖೆ” ಕರಿ ವಾತೆ ಬೋಲಿಲಿದು. ");
INSERT INTO vaa_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","ತದೆ ಇವ್ಣೆ ಒಗ್ಗಿಸ್‌ಮ ಜೈ಼ನ್, ಮರಿಯನಾಬಿ ಯೋಸೇಫ್‌ನಾಬಿ ಅಜು಼ ಗೋದ್‌ಡಿಮ ಖ್ಹುತೂಥೂತೆ ಲಡ್ಕಾನಾಬಿ ದೇಖ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","ಮೇಂಢ ಚ಼ರಾವವಾಳನೆ ಲಡ್ಕಾನ ದೇಖಿನ್, ಇನಿ ಬಾರೇಮ ದೇವ್‌ನೊ ದೂತನೆ ಇವ್ಣುನ ಬೋಲ್ಯೋತೆ ವಾತೇನ ಇವ್ಣ ಖ್ಹಾಮ್ಣೆ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","ಇನ ಖ್ಹಮ್‌ಜ್ಯೂತೆ ಖ್ಹಾರಾಸ್‌ನೆ, ಮೇಂಢ ಚ಼ರಾವವಾಳು ಇವ್ಣುನ ಬೋಲ್ಯೂತೆ ವಾತೇನಖ್ಹಾಜೆ ಆಶ್ಚರ್ಯಖಾದು. ");
INSERT INTO vaa_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","ಕತೋಬಿ ಮರಿಯನೆ ಆ ಖ್ಹಾರಿ ವಾತೆನ ಇನ ಮನ್‌ಮ ರಾಖಿನ್, ಇನಿ ಬಾರೇಮ ಸೋಚಾಲಗಿ. ");
INSERT INTO vaa_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","ಮೇಂಢ ಚ಼ರಾವವಾಳು ಇವ್ಣೆ ದೇಖ್ಯೂತೆ ಅಜು಼ ಖ್ಹಮ್‌ಜ್ಯೂತೆ ಯೋ ಖ್ಹಾರಾನಖ್ಹಾಜೆ, ದೇವ್ನ ಗೀದ್‌ ಬೋಲ್ತು ಅಜು಼ ಸ್ತುತಿ ಕರ್ತುಹುಯಿನ್ ಪಾಛು಼ಫರಿ ಚ಼ಲ್ಯೂಗಯು. ದೇವ್‌ನೊ ದೂತನೆ ಇವ್ಣುನ ಬೋಲ್ಯೊಥೋತೆ ಇಮ್ಮಸ್ ಖ್ಹಾರು ಚಾ಼ಲಿರ‍್ಹೂಥು. ");
INSERT INTO vaa_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","ಆಟ್ ದನ್ ಹುವ್ವಾದೀನ್, ಯೋ ಲಡ್ಕಾನ ಖ್ಹತ್ನ ಕರಾನಿ ವಖ್ಹತ್ ಆಯಿ. ತದೆ ಇನ ಯೇಸು ಕರಿ ನಾಮ್ ಮ್ಹೇಲ್ಯು. ಯೋ ಬೇಜೂನಿ ಹುವಾನ ಅಗಾಡಿಸ್ ದೇವ್‌ನೊ ದೂತನೆ ಆಸ್ ನಾಮ್ ಮ್ಹೇಲ್ನು ಕರಿ ಬೋಲ್ಯೊಥೊ. ");
INSERT INTO vaa_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","ಪಾಕ್‍ ಹುವಾನಿ ಬಾರೇಮ ಮೋಶೇನು ಧರ್ಮಶಾಸ್ತ್ರಮ ಹುಕುಮ್‌ ದೆವೈರ‍್ಹೀಸ್‌ತೆ ಇಮ್‌ ಕರಾನ, ಯೋಸೇಫ್‌ನಾಬಿ ಮರಿಯನ ಯೋ ವಖ್ಹತ್ ಆಯಿ. ಇನಖ್ಹಾಜೆ ಇವ್ಣೆ ಯೋ ಲಡ್ಕಾನ ದೇವ್ನ ಕರಿ ಸಮರ್ಪಣ್‌ ಕರಾನ ಯೆರೂಸಲೇಮ್‌ನು ಮಂದಿರ್‌ಮ ಲೀನ್‌ ಗಯ. ");
INSERT INTO vaa_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","ಶನಕತೊ ಪ್ರಭುನಿ ಧರ್ಮಶಾಸ್ತ್ರಮ ಲೀಖೈರ‍್ಹೂತೆ ಇಮ್‌, ಪಹಿಲೋಟು ಪರ್ಖ್ಹೊ ಲಡ್ಕಾನ ದೇವ್ನ ಕರಿ ಸಮರ್ಪಣ್‌ ಕರ‍್ನು. ");
INSERT INTO vaa_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","ಎತ್ರೇಸ್ ಕಾಹೆತೆ ಇವ್ಣೆ ಪ್ರಭುನ, ಧರ್ಮಶಾಸ್ತ್ರಮ ಲೀಖೈರ‍್ಹೂತೆ ಇಮ್‌, ಏಕ್‌ ಜೋ಼ಡು ಢೋಳ್‍ನ ನಾತೊ ಬೇ ಪರ‍್ಯಾವಾನು ಚೆಲ್ಕಾನ ಬಲಿ ದೇವ್ಣುಥು. ");
INSERT INTO vaa_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","ಯೋ ಹಗಾಮ್ಮ ಯೆರೂಸಲೇಮ್ಮ ಸಿಮೆಯೋನ್‌ ಕರಿ ಏಕ್‍ಜ಼ಣೊ ಥೊ. ಯೋ ಏಕ್‌ ನೀತಿವಾಳೊ ಅಜು಼ ದೇವ್‌ಥಿ ಡರವಾಳೊ ಅದ್ಮಿ ಹುಯಿರ‍್ಹೋಥೊ, ಇಸ್ರಾಯೇಲ್‌ ಅದ್ಮಿಯೇನ ಸಮಾಧಾನ್‍ ಕರಾವಾಳೊ ಕದೆ ಆವ್‍ಶೆಕರಿ ಟಿವವ್‍ಕರ್‌ತೊಥೊ. ಅಜು಼ ಪವಿತ್ರಾತ್ಮ ಇನಿ ಜೋ಼ಡೆ ಥೊ. ");
INSERT INTO vaa_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","ಅತ್ರೇಸ್ ಕಾಹೆತೆ ಪ್ರಭು ಮೋಕಲ್‌ಶೇತೆ ಕ್ರಿಸ್ತನ ದೇಖಾತೋಡಿ, ತೂ ಮರಿಶ್‌ ಕೊಯ್ನಿ ಕರಿ ಪವಿತ್ರಾತ್ಮನೆ ಇನ ಬೋಲಿರಾಖ್ಯೋಥೊ. ");
INSERT INTO vaa_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","ಪವಿತ್ರಾತ್ಮಥಿ ಸಿಮೆಯೋನ್‌ ಮಂದಿರ್‌ಮ ಗಯೊ, ತದೆ ಯೋಸೇಫ್‌ಬಿ ಮರಿಯನೆ ಲಡ್ಕು ಯೇಸುನ ಧರ್ಮಶಾಸ್ತ್ರನಿ ಪದತ್ತಿಘೋಣಿ ಕರ‍್ನು ಕರಿ ಮಂದಿರ್‌ನ ಮಹಿ ಲೀನ್‌ಆಯ. ");
INSERT INTO vaa_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","ಸಿಮಿಯೋನ್ನೆ ಯೋ ಲಡ್ಕಾನ ಹಾತ್‌ಮ ಪಾಡೀನ್, ದೇವ್ನ ಧನ್ಯವಾದ್ ಕರ್ತೊಹುಯಿನ್, ");
INSERT INTO vaa_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“ಪ್ರಭು, ತಾರಿ ವಾತೆ ಚಾ಼ಲಿಗಿ, ಹಮ್ಕೆ ಸಮಾಧಾನ್‌ಥಿ ಜಾ಼ವಾನ ತಾರೊ ಸೇವಕ್‌ನ ಹುಕುಮ್ ಹುವಾದೆ. ");
INSERT INTO vaa_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","ಶನಕತೊ, ಖ್ಹುದ್ ಮಾರ ಡೋಳೆಖ್ಹು ತುನೆ ದಿದೋತೆ ರಕ್ಷಣೆನ ದೇಖಿಲಿದೊ, ");
INSERT INTO vaa_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","ಖ್ಹಾರ ಅದ್ಮಿವೋನ ದೇಖಾನಿಘೋಣಿ ಇನ ದೀರಾಖ್ಯೊಸ್. ");
INSERT INTO vaa_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","ಯೋ ಪರೈ ಜಾ಼ತ್‌ವಾಳ ಅದ್ಮಿನ ತಾರಿ ಮರ್ಜಿ ವತಾಳವಾಳೊ ಉಜಾ಼ಳು ಹುಯಿರ‍್ಹೋಸ್ ಅಜು಼ ತಾರು ಇಸ್ರಾಯೇಲ್ ಅದ್ಮಿವೋನ ಮಹಿಮೆ ಉಶೆ. ");
INSERT INTO vaa_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","ಸಿಮಿಯೋನ್ನೆ ಯೋ ಲಡ್ಕಾನಿ ಬಾರೇಮ ಬೋಲ್ಯೋತೆ ವಾತೇನ ಖ್ಹಮ್‌ಜಿನ್‌, ಇನ ಆಯ-ಬಾನೆ ಆಶ್ಚರ್ಯಖಾದು. ");
INSERT INTO vaa_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","ಸಿಮೆಯೋನ್ನೆ ಇವ್ಣುನ ಆಶೀರ್ವಾದ್‌ ಕರೀನ್, ಇನಿ ಆಯ ಮರಿಯನ, “ಆ ಲಡ್ಕಾಥಿ ಇಸ್ರಾಯೇಲ್‌ ದೇಖ್ಹ್‌ಮ ಕೈಯೆಕ್ಕಿ ಜ಼ಣು ಪಡಿಜಾ಼ಶೆ ಅಜು಼ ಕೈಯೆಕ್ಕಿ ಉಟ್‌ಶೆ. ಕೈಯೆಕ್ಕಿ ಜ಼ಣು ಅನಿ ವಿರೋದ್ ವಾತೆ ಬೋಲ್‌ಶೇತೇಸ್, ಆ ದೇವ್‍ಥಿ ಆಯೋತೆ ಕರಿ ಬೋಲಾನು ಖ್ಹಣೇದ್ ಹುಯಿರ‍್ಹಿಶೆ. ");
INSERT INTO vaa_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","ಅಮ್ ಘಣ ಅದ್ಮಿನಿ ದಿಲ್ನಿ ವಾತೆಖ್ಹಾರಿ ಭಾರ್‌ ನಿಕಳ್‌ಶೆ. ಅಜು಼ ತಾರ ದಿಲ್ನ ತಲ್ವಾರ್‌ ಭೋಕಾವನಿಮತ್ ದುಖ್ ಉಶೆ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","ಆಸ್‌ಕಾಹೆತೆ ಅಸೇರನೊ ಖೂಮ್‌ವಾಳೊ ಫನುವೇಲನಿ ಛೋ಼ರಿ ಅನ್ನಕರಿ ಏಕ್‌ ಜ಼ಣಿ ಪ್ರವಾದ್‌ನೆ ಕರಾವಾಳಿ ಥೀ. ಯೋ ವ್ಯಹಾ ಹುಯಿನ್ ಖ್ಹಾತ್ ವರಖ್ಹ್ ಬಾವ್ರಿನ ಜೋ಼ಡೆ ಬಚಿನ್ ಅಜು಼ ಯೋ ಘಣಿ ಬುಢಿಯಾ ಹುಯಿರ‍್ಹೀಥಿ. ");
INSERT INTO vaa_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","ತದೆ ಇನ ಚಾರ್ ಉಪ್ಪರ್ ಚಾರಿಖ್ಹ್ ವರಖ್ಹ್ ಹುಯಿರ‍್ಹಾಥ ಅಜು಼ ಯೋ ಮುಂಡಚ್ಚಿ ಹುಯಿರ‍್ಹೀಥಿ. ಯೋ ದೇವ್ನಿ ಮಂದಿರ್‌ನ ಕದೇಬಿ ಮ್ಹೇಲಿನ್ ಕೋ ಜಾ಼ತಿಥಿಂತೆ, ಉಪವಾಸ್ ಅಜು಼ ಪ್ರಾರ್ಥನೆ ಕರ್ತಿಹುಯಿನ್, ರಾತ್-ದನ್ ದೇವ್ನಿ ಆರಾದನೆ ಕರ್ತಿ ರ‍್ಹೇತಿಥಿ. ");
INSERT INTO vaa_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","ಯೋಸ್ ವಖ್ಹತ್‌ಮ, ಅನ್ನ ಯೋ ಲಡ್ಕಾನ ಆಯ-ಬಾಕನ ಅಯಿನ್, ದೇವ್ನ ಧನ್ಯವಾದ್‌ಕರಿ ಕರಿ ಅಜು಼ ಯೆರೂಸಲೇಮ್‌ನಿ ಛುಟ್ಕಾರ್‌ನಿ ಬಾರೇಮ ಟಿವವ್‍ಕರ್ತುಥೂತೆ ಖ್ಹಾರಾವ್‌ನ, ಯೋ ಲಡ್ಕಾನಿ ಬಾರೇಮ ಬೋಲಿ. ");
INSERT INTO vaa_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","ಇವ್ಣೆ ಧರ್ಮಶಾಸ್ತ್ರಮ ಪ್ರಭುನೆ ಬೋಲಿರಾಖ್ಯುತೆ ಖ್ಹಾರುಸ್ ಕಾಮ್ ಕರಾನ ಬಾದ್‌ಮ, ಯೋಸೇಫ ಅಜು಼ ಮರಿಯ ಪಾಛು಼ಫರಿ ಗಲಿಲಾಯ ತಬರ್‌ಖಾನು ನಜ಼ರೇತ್ ಕರಿ ಗಾಮ್‌ನ ಗಯು. ");
INSERT INTO vaa_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","ಯೋ ಲಡ್ಕು ಮೋಟು ಹುಯಿನ್, ಶಕತ್‍ಮಾಬಿ ಅಜು಼ ಗ್ಯಾನ್‌ಮಾಬಿ ಭರಾಯು. ದೇವ್ನಿ ದಯಾ ಇನ ಉಪ್ಪರ್‌ ಥೂ. ");
INSERT INTO vaa_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","ಹರೇಕ್ ವರಖ್ಹ್‌ಬಿ ಯೇಸುನ ಆಯ-ಬಾ ಪಸ್ಕ ಪೂಜಾ಼ನಖ್ಹಾಜೆ ಯೆರೂಸಲೇಮ್ ಜಾ಼ತೂಥೂ. ");
INSERT INTO vaa_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","ಯೇಸುನ ಭಾರ ವರಖ್ಹ್ ಹುವ್ವಾದೀನ್, ಇವ್ಣೆ ಜಾ಼ತೂಥೂತೆ ಇಮ್ಮಸ್, ಪಸ್ಕ ಪೂಜಾ಼ನಖ್ಹಾಜೆ ಯೆರೂಸಲೇಮ್‌ನ ಗಯು. ");
INSERT INTO vaa_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","ಇವ್ಣೆ ಪೂಜಾ಼ನೊ ದನ್‌ಖ್ಹಾರು ಖತಮ್ ಕರೀನ್ ಪಾಛು಼ಫರಿನ್ ಆವಾನಿ ವಖ್ಹತ್‌ಮ ಛೋ಼ಕ್ರು ಯೇಸು ಯೆರೂಸಲೇಮ್ಮಸ್ ರಹಿಗು. ಇನ ಆಯ-ಬಾನ ಅನಿ ಬಾರೇಮ ಮಾಲುಮ್ ಕೋ ಥೂನಿ. ");
INSERT INTO vaa_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","ಯೋಸೇಫ್‌ಬಿ ಮರಿಯ ಯೇಸು ಝೂ಼ಂಡ್‌‍ಮಾಸ್ ಉಷೆಕರಿ ಸೋಚಿನ್, ಏಕ್‌ ರೋಜ಼್‌ನಿ ಚಾ಼ಲ್ ಎವ್ಡಿ ಚಾ಼ಲ್‌ನಿ ಬಾದ್‌ಮ, ಇವ್ಣ ಮಾಯಮಾತ್ರಕನಾಬಿ, ರ‍್ಹವಾಳು ಖ್ಹಾರಾಕನಾಬಿ ಜೈ಼ನ್ ಢೂಂಡ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","ಕತೋಬಿ ಕಿಜ್ಜಾ಼ಬಿ ಮಳ್ಯೊಕೊಂತೆ ಇನಖ್ಹಾಜೆ, ಯೇಸುನ ಢೂಂಡ್‌ತುಹುಯಿನ್ ಯೆರೂಸಲೇಮ್‌ನ ಪಾಛು಼ ಗಯು. ");
INSERT INTO vaa_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","ತೀನ್ನೆ ರೋಜ಼್‌ಮ ಯೇಸುನ ಮಂದಿರ್‌ಮ ದೇಖ್ಯು, ಯೋ ಯೆಹೂದ್ಯರ್‌ನ ಬೋಧನೆ ಕರಾವಾಳಾನ ಜೋ಼ಡ್ಮ ಬೇಶಿನ್, ಇವ್ಣೆ ಬೋಲಾತೆ ಖ್ಹಮಜ಼್‌ತೊಹುಯಿನ್, ಅಜು಼ ಪಾಛು಼ ಫರೈನ್ ಸವಾಲ್‌ ಕರುಕರ್ತೊಥೊ. ");
INSERT INTO vaa_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","ಯೇಸುನಿ ವಾತೇನ ಖ್ಹಮ್‌ಜಾ಼ವಾಳು ಖ್ಹಾರು, ಯೋ ಸೋಚಿ ಪರ್ಖಿನ್ ಗ್ಯಾನ್‌ಥಿ ಜವಾಬ್‌ ದೇಯಿತೆ ದೇಖಿನ್ ಆಶ್ಚರ್ಯಖಾದು. ");
INSERT INTO vaa_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","ಯೇಸುನ ಆಯ-ಬಾನೆ ಇನ ಹಿಜ್ಜಾ಼ ದೇಖಿನ್ ಮ್ಹೊಡಾಪರ್ ಹಾತ್‌ ಜೋ಼ಡಿಲಿದು. ತದೆ ಇನಿ ಆಯಾನೆ, “ಮಾರ ಛಿಯ್ಯಾ, ತುನೆ ಹಮೂನ ಶನ ಅಮ್ ಕರ‍್ಯೊ? ದೇಕ್, ತಾರೊ ಬಾಬಿ ಮೇ ಘಬ್‍ರೈನ್‌, ಢೂಂಡಿನ್ ಆಯಾನಿ” ಕರಿ ಬೋಲಿ. ");
INSERT INTO vaa_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","ತದೆ ಯೇಸುನೆ ಇವ್ಣುನ, “ತುಮೆ ಮನ ಶನ ಢೂಂಡ್‌ಣು ಥು? ಮೇ ಮಾರ ಬಾನ ಘರ್‌ಮ ರ‍್ಹೇಣು ಕರಿ ತುಮೂನ ಮಾಲುಮ್‌ ಕೊಯ್ನಿಕಿ ಶು? ಕರಿ ಜವಾಬ್‌ ದಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","ಕತೋಬಿ ಇನೆ ಬೋಲ್ಯೋತೆ ಜ಼ವಾಬ್‌ನ ಇವ್ಣೆ ಮಾಲುಮ್ ಕರ‍್ಯುಕೊಯ್ನಿ. ");
INSERT INTO vaa_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","ಬಾದ್‌ಮ ಯೇಸು ಇವ್ಣ ಜೋ಼ಡೆ ನಜ಼ರೇತ್‌ನ ಗಾಮ್‌ನ ಐನ್, ಹಿಜ್ಜಾ಼ ಇವ್ಣಿ ವಾತೆನ ಖ್ಹಮ್‌ಜಿನ್‌ ಥೊ. ಕತೋಬಿ ಇನಿ ಆಯ ಆ ಖ್ಹಾರಿ ವಾತೇನ ಇನ ಮನ್‌ಮ ರಾಖಿರಾಖಿಥಿ. ");
INSERT INTO vaa_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","ಯೇಸು ಗ್ಯಾನ್‌ಮಾಬಿ ಅಜು಼ ಆಂಗ್‌ತನ್ನಿ ಶಕತ್‍ಮಾಬಿ ಭಡ್ತೊ ಆಯೊ. ಅತ್ರೇಸ್ ಕಾಹೆತೆ ದೇವ್ನಿ ಅಜು಼ ಅದ್ಮಿನಿ ದಯಾ ಇನ ಉಪ್ಪರ್‌ ಜಾ಼ಖ್ಹತ್ ಹೋತು ಆಯು. ");
INSERT INTO vaa_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","ತಿಬೇರಿಯಸ್ ಕೈಸರ್ ಅದಿಕಾರ್ ಚ಼ಲಾವ್‍ ಕರ್ತೊಥೋತೆ ಪಂಧ್ರಾನೆ ವರಖ್ಹ್‌ಮ, ಪೊಂತ್ಯ ಪಿಲಾತ ಯೂದಾಯ ತಬರ್‌ಖಾನೊ ರಾಜ್ಯಪಾಲ್ ಹುಯಿರ‍್ಹೋಥೊ, ಹೆರೋದ ಗಲಿಲಾಯ ತಬರ್‌ಖಾನ ಚ಼ಲಾವವಾಳೊ ಹುಯಿರೋಥೊ ಅಜು಼ ಇನೊ ನ್ಹಾನೊ ಭೈ ಫಿಲಿಪ್ಪ ಇತುರಾಯ ಅಜು಼ ತ್ರಕೋನಿತಿ ಕರಿ ಮುಲಕ್ನ ಚ಼ಲಾವ್‍ಕರ್ತೋಥೊ. ಲೂಸನ್ಯ ಅಬಿಲೇನೆ ಮುಲಕ್ನ ಚ಼ಲಾವ್‍ಕರ್ತೊಥೋತೆ ವಖ್ಹತ್‌ಮ, ");
INSERT INTO vaa_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","ಅನ್ನ ಅಜು಼ ಕಾಯಫ ಮಹಾಯಾಜಕ ಹುಯಿರ‍್ಹೊಥೋತೆ ಹಗಾಮ್ಮ, ಜಕರೀಯಾನೊ ಛಿಯ್ಯೊ ಯೋಹಾನ ಉಜ್ಜಾ಼ಡಿ ಝ಼ಗೋಮ ದೇವ್ನಿ ವಚನ್‍ ಬೋಲಾಯು. ");
INSERT INTO vaa_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","ಇನೆ ಯೊರ್ದನ್‌ ನದ್ದಿನು ಅಶ್‌ಪಿಶ್‍ ಥೂತೆ ಖ್ಹಾರ ತಬರ್‌ಖಾಮ ಜೈ಼ನ್ ಅದ್ಮಿವೋನ “ತುಮೆ ಪಾಪ್‌ ಕರಾನು ಮ್ಹೇಲಿನ್, ದೇವ್‌ಭಣಿ ಫರೊ ಅಜು಼ ಬ್ಯಾಪ್ತಿಸ್ಮ ಲೇವೊ, ತದೆ ದೇವ್ ತುಮಾರು ಪಾಪ್ ಮಾಪ್‌ ಕರ್ಶೆ” ಕರಿ ಬೋಲ್ತೊನಿಕ್‌ಳ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","ಆ ಖ್ಹಾರು ಯೆಶಾಯ ಕರಿ ಪ್ರವಾದಿನ ದಪ್ತರ್‌ಮ ಲೀಖೈರ‍್ಹೂತೆ ಇಮ್ಮಸ್ ಚಾ಼ಲ್ಯು: ಯೋ ಶಾತ್‌ಕತೊ, ಏಕ್‌ ಜ಼ಣಾನಿ ಅವಾಜ಼್ ಉಜ್ಜಾ಼ಡಿ ಝ಼ಗೋಮ ಅಮ್ ಚಿಕ್ರುಕರಾಸ್: ‘ಪ್ರಭುನಿ ವಾಟ್ನ ಖ್ಹವಾರೊ, ಇನಿ ವಾಟ್ನ ಖ್ಹೂದು ಕರೊ. ");
INSERT INTO vaa_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","ಹರೇಕ್ ಖಾಡೊಗುಂಟೊ ಮೂಚೈ಼ಜಾ಼ಶೆ, ಹರೇಕ್ ಪಹಾಡ್-ಪರ್ಭತ್ ಶದ್ದರ್ ಹುಯಿಜಾ಼ಶೆ, ಬಿಂಗೊ ಮಾರಗ್ ಅಖ್ಖು ಖ್ಹತ್ತಡ್‍ ಉಶೆ, ಖಡ್‌ದೊಂಗ್‌ಡು ವಾಟ್‌ಖ್ಹಾರು ಶದ್ದರ್ ಉಶೆ, ");
INSERT INTO vaa_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","ತಮಾಮ್‌ ಅದ್ಮಿ ದೇವ್ನಿ ರಕ್ಷಣೆನ ದೇಕ್‌ಶೆ” ಕರಿ ಯೋ ಅವಾಜ಼್ ಹುಯಿರ‍್ಹೂಸ್. ");
INSERT INTO vaa_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","ಅದ್ಮಿನಿ ಝೂ಼ಂಡೆಖ್ಹಾರು ಯೋಹಾನ್ನ ಹಾತೇಥಿ ಬ್ಯಾಪ್ತಿಸ್ಮ ಕರೈಲ್ಯವಾನಟೇಕೆ ಆಯು. ತದೆ ಯೋಹಾನನೆ ಇವ್ಣುನ, “ಅಲಾ ಖ್ಹಾಪ್‌ನಿ ಪಿಳ್ಗಿವಾಳವೊ! ಖ್ಹಾಮ್ಣೆ ಉಳ್ಯಾವತೆ ದೇವ್ನ ಇರಾದೇಥಿ ಛು಼ಕಿಜಾ಼ವಾನಿಮತ್, ತುಮುನ ಝೇತಾಯುತೆ ಕೋಣ್? ");
INSERT INTO vaa_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","ತುಮೆ ತುಮಾರು ಪಾಪ್‌ಖ್ಹಾರು ಮ್ಹೇಲಿನ್ ದೇವ್ ಭಣಿ ಫರಿಗಯ ಉಶೇತೊ, ಇನ ಬರಾಬರ್‌ಥಿ ಚಾ಼ಲ್‌ಮ ವತಾಳೊ. ಅಜು಼ ಹಮೆ ಅಬ್ರಹಾಮ್‌ನಿ ಪಿಳ್ಗಿವಾಳ ಕರಿ ತುಮಾರು ತುಮೇಸ್ ಬಡೈ ನಕೊ ಮಾರಿಲೆವೊ. ಮೇ ಬೋಲುಸ್ಕಿ, ದೇವ್‌ ಅಬ್ರಹಾಮ್‌ನಖ್ಹಾಜೆ ಆ ಬಂಡೇವ್‌ಥಿಬಿ ಲಡ್ಕಾವ್ನ ಉಬ್‍ಜಾ಼ವ್‍ಶೆ ಕರಿ ತುಮೂನ ಬೋಲುಸ್ ");
INSERT INTO vaa_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","ಹಮ್ಕೇಸ್ ಕತ್ರಾನಟೇಕೆ ಝಾ಼ಡಾವ್‍ನಿ ಜ಼ಡ್‌ಪರ್‌ ಕುರ‍್ಹಾಡಿ ಮ್ಹೇಲೈರ‍್ಹಿಸ್. ಅಛ್ಛು಼ ಪಂಡು ದೇಯಿಕೊಂತೆ ಹರೇಕ್ ಝಾ಼ಡಾವ್‌ನ ಕತ್ರಿನ್‌ ಆಗ್‌ಮ ನಾಕ್‌ಶೆ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","ತದೆ ಯೋ ಅದ್ಮಿಖ್ಹಾರು, “ಇಮ್‌ ಕತೊ, ಹಮೆ ಶಾತ್ ಕರ‍್ನು?” ಕರಿ ಪುಛಾ಼ಯು. ");
INSERT INTO vaa_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","ತದೆ ಯೋಹಾನನೆ, “ತುಮಾರಾಮ ಕಿನಾಕನ ಬೇ ಕುಡ್‌ತಾ ಛಾ಼ಕಿ ಇವ್ಣೆ, ಕೊಯ್ನಿತೆ ಅದ್ಮಿನ ದ್ಯವಾದೆ; ಖಾಣು ರ‍್ಹವಾಳು ವಾಟಪಾಡಿ ದೇವ್ಣು” ಕರಿ ಜವಾಬ್‌ ದಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","ಶುಂಕ ವಶೂಲ್ ಕರಾವಾಳು ಥೋಡು ಜ಼ಣು ಬ್ಯಾಪ್ತಿಸ್ಮ ಕರಿಲೇವ್ಣುಕರಿ ಆಯಿನ್, “ಗುರು, ಹಮೆ ಶಾತ್‌ ಕರ‍್ನು?” ಕರಿ ಇನ ಪುಛಾ಼ಯು. ");
INSERT INTO vaa_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","ತದೆ ಯೋಹಾನನೆ ಇವ್ಣುನ, “ತುಮೂನ ಬೋಲಿರಾಖ್ಯುತೆ ಇನೇಥಿ ಜಾ಼ಖ್ಹತ್, ತುಮೆ ವಶೂಲ್ ನಕೊ ಕರೊ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","ತದೆ ಥೋಡು ಜ಼ಣು ಶಿಪಾಯಿಖ್ಹಾರುಬಿ ಆಯಿನ್, “ಹಮೆ ಶಾತ್‌ ಕರ‍್ನು?” ಕರಿ ಬೋಲಾಖ್ಹತರ್, ಇನೆ, “ಕಿನಾಪರ್‌ಬಿ ಜು಼ಲಮ್ಜ಼ಸ್ತಿ ಕರಿನ್ ಪೈಶಾ ಛಿನಾವಾನು ರ‍್ಹವೊ, ಕಿನಾಪರ್‌ಬಿ ಜ್ಹೂ಼ಟು ಇಂಜಾ಼ಮ್ ಲಗಾಡನು ರ‍್ಹವೊ ನಕೊ ಕರೊ. ತುಮೂನ ಮಳಾತೆ ಶಂಬ್‌ಳಾಮ ಖ್ಹುಶೀಥಿ ರ‍್ಹವೊ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","ಅಮ್ ರ‍್ಹಾವಾನಿ ವಖ್ಹತ್‌ಮ, ಇಸ್ರಾಯೇಲ್‌ನು ಅದ್ಮಿಖ್ಹಾರು ಕ್ರಿಸ್ತ ಆವ್‍ಶೆಕರಿ ಜ಼ಪೀರ‍್ಹೂಥೂತೆ ಇನಖ್ಹಾಜೆ, ಯೋಹಾನ್ನಿ ಬಾರೇಮ ಆಶ್ಚರ್ಯಖೈನ್, “ಆಸ್ ಕ್ರಿಸ್ತ ಹುಯಿರ‍್ಹೋಸ್ಕಿ ಶುಕಿ” ಕರಿ ಇವ್ಣ ಮನ್‌ಮ ಖ್ಹಯಾಲ್ ಕರ್ಲಿದು. ");
INSERT INTO vaa_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","ತದೆ ಯೋಹಾನನೆ ಇವ್ಣುನ, “ಮೇತೊ ತುಮೂನ ಪಾಣಿಥಿ ಬ್ಯಾಪ್ತಿಸ್ಮ ದೆವ್‍ಕರೂಸ್; ಕತೋಬಿ ಮಾರೇಥಿಬಿ ಶಕತ್‌ವಾಳೊ ವಳ್ಯಾವಸ್, ಇನಿ ಖೋಖ್ಹ್‌ಡಾನಿ ಡೋರಿ ಛೋ಼ಡಾನಾಬಿ ಮೇ ಲ್ಹಾಯೇಕ್‍ಕೊಯ್ನಿ. ಯೋ ತುಮೂನ ಪವಿತ್ರಾತ್ಮಥಿಬಿ ಅಗ್‌ಥೀಬಿ ಬ್ಯಾಪ್ತಿಸ್ಮ ದಿಶೆ. ");
INSERT INTO vaa_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","ಇನ ಹಾತ್‌ಮ ಖ್ಹುಪ್‌ಡು ಧರಿರಾಖ್ಯೋಸ್‌, ಇನ ಖಳಾಮಾನು ಘವ್‌ನಿ ರಾಶ್‌ನ ತೂರಿನ್‌, ಅಛ಼್ಛ ಕರೀನ್, ಘವ್‌ನ ಕಣ್ಗಿಮ ಭರಿಲಿಶೆ, ಕತೋಬಿ ಪೊಟ್ಟಾನ ಉಝಾ಼ವಕೊಂತೆ ಆಗ್‌ಮ ಬಾಳಿನಾಕ್‌ಷೆ” ಕರಿ ಜವಾಬ್‌ ದಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","ಯೋಹಾನನೆ ಬಿಜೂ಼ಬಿ ಘಣಿ ತರಿಕಾಥಿ ಅದ್ಮಿ ಖ್ಹಾರಾನ ಅಛ್ಛಿ ಖಬರ್‌ನ ಬೋಲಿದೇತೊಹುಯಿನ್‌, ತುಮಾರಿ ಸೋಚ್ನ ಬದ್‌ಲೈಲೇವ್ಣು ಕರಿ ಇವ್ಣುನ ಖ್ಹಮ್‌ಜಾ಼ಡ್‌ತೊಥೊ. ");
INSERT INTO vaa_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","ರಾಜ್ಯಪಾಲ್ ಹುಯಿರ‍್ಹೋತೆ ಹೆರೋದನೆ ಇನಿ ಭೈನಿ ಬಾವಣ್‍ ಹುಯಿರ‍್ಹೀತೆ ಹೆರೋದ್ಯನ ಕರಿಲಿದೊಥೋತೆ ಅಜು಼ ಇನೆ ಕರ‍್ಯೊಥೋತೆ ಬಿಜಾ಼ಖ್ಹಾರ ಖರಾಬ್ ಕಾಮ್ನಟೇಕೆ ಯೋಹಾನನೆ ಇನ ಬರಾಬರ್‌ಥಿ ಗುರ್‌ಕಾಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","ಇನಖ್ಹಾಜೆ ಹೆರೋದನೆ ಯೋಹಾನ್ನ ಧರೈನ್ ಜೇಲ್‌ಮ ಕೋಂಡಿ ಘಲಾಯೊ, ಅನೇಥಿ ಇನು ಖರಾಬ್ ಕಾಮ್ ಬಿಜೂ಼ಬಿ ಜಾ಼ಖ್ಹತ್ ಹುಯು. ");
INSERT INTO vaa_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","ಅದ್ಮಿಖ್ಹಾರು ಬ್ಯಾಪ್ತಿಸ್ಮ ಕರೈಲ್ಯವಾನ ಬಾದ್‌ಮ, ಯೇಸುಬಿ ಬ್ಯಾಪ್ತಿಸ್ಮ ಕರೈಲಿದೊ. ಯೋ ಪ್ರಾರ್ಥನೆ ಕರುಕರಾನಿ ವಖ್ಹತ್‌ಮ, ಸೊರ್ಗ ನಿಕ್‌ಳ್ಯು, ");
INSERT INTO vaa_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","ಅಜು಼ ಪವಿತ್ರಾತ್ಮ ಶರೀರ್‌ನಿ ರೂಪ್‍ಹುಯಿನ್ ಪರ‍್ಯಾವಾನಿಘೋಣಿ ಇನಾಪರ್‌ ಉತ್‌ರ‍್ಯು. ತದೆ ಪರಲೋಕ್‌ಮಾಥು, “ತೂ ಮಾರೊ ಲಾಡ್‌ನೊ ಛಿಯ್ಯೊ, ತಾರೇಥಿ ಮೇ ಘಣು ಖ್ಹುಶಿ ಛೂ಼” ಕರಿ ಏಕ್‌ ಆವಾಜ಼್ ಆಯು. ");
INSERT INTO vaa_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","ಯೇಸು ಸೇವೆ ಕರಾನ ಶುರುಕರ‍್ಯೊತೆ ತದೆ, ಯೋ ಡೋಡಿಖ್ಹ್‌ ವರಖ್ಹ್‌ನೊ ಥೊ. ಅದ್ಮಿನ ಡೋಳಾಮ ಯೇಸು ಯೋಸೇಫನೊ ಛಿಯ್ಯೊ, ಯೋಸೇಫ ಹೇಲಿನೊ ಛಿಯ್ಯೊ, ");
INSERT INTO vaa_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","ಹೇಲಿ ಮತ್ಥಾತನೊ ಛಿಯ್ಯೊ, ಮತ್ಥಾತಿ ಲೇವಿನೊ ಛಿಯ್ಯೊ, ಲೇವಿ ಮೆಲ್ಕಿನೊ ಛಿಯ್ಯೊ, ಮೆಲ್ಕಿ ಯನ್ನಾಯನೊ ಛಿಯ್ಯೊ, ಯನ್ನಾಯ ಯೋಸೇಫನೊ ಛಿಯ್ಯೊ, ");
INSERT INTO vaa_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","ಯೋಸೇಫ ಮತ್ತಥಿನೊ ಛಿಯ್ಯೊ, ಮತ್ತಥಿ ಆಮೋಸನೊ ಛಿಯ್ಯೊ, ಆಮೋಸ ನಹೂಮನೊ ಛಿಯ್ಯೊ, ನಹೂಮ ಎಸ್ಲಿನೊ ಛಿಯ್ಯೊ, ಎಸ್ಲಿ ನಗ್ಗಾಯನೊ ಛಿಯ್ಯೊ, ");
INSERT INTO vaa_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","ನಗ್ಗಾಯ ಮಹಾಥನೊ ಛಿಯ್ಯೊ, ಮಹಾಥ ಮತ್ತಾಥಿನೊ ಛಿಯ್ಯೊ, ಮತ್ತಾಥಿಯ ಶಿಮಿನೊ ಛಿಯ್ಯೊ, ಶಿಮಿ ಯೋಸೇಖನೊ ಛಿಯ್ಯೊ, ಯೋಸೇಖ ಯೂದಾನೊ ಛಿಯ್ಯೊ, ");
INSERT INTO vaa_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","ಯೂದ ಯೋಹಾನನೊ ಛಿಯ್ಯೊ, ಯೋಹಾನ ರೇಸನೊ ಛಿಯ್ಯೊ, ರೇಸ್‍ ಜೆರುಬ್ಬಾಬೇಲ್‌ನೊ ಛಿಯ್ಯೊ, ಜೆರುಬ್ಬಾಬೇಲ್‌ ಸಲಾಥಿಯೇಲ್‌ನೊ ಛಿಯ್ಯೊ, ಸಲಾಥಿಯೇಲ್ ನೇರಿನೊ ಛಿಯ್ಯೊ, ");
INSERT INTO vaa_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","ನೇರಿ ಮೆಲ್ಕಿನೊ ಛಿಯ್ಯೊ, ಮೆಲ್ಕಿ ಅದ್ದಿನೊ ಛಿಯ್ಯೊ. ಅದ್ದಿ ಕೋಸಾಮನೊ ಛಿಯ್ಯೊ, ಕೋಸಾಮ ಎಲ್ಮದಾಮನೊ ಛಿಯ್ಯೊ, ಎಲ್ಮದಾಮ ಏರ್‌ನೊ ಛಿಯ್ಯೊ, ");
INSERT INTO vaa_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","ಏರ್‌ ಯೆಹೋಶುವನೊ ಛಿಯ್ಯೊ, ಯೆಹೋಶುವ ಎಲಿಯೇಜರನೊ ಛಿಯ್ಯೊ, ಎಲಿಯೇಜರ್ ಯೋರೈಮನ್ನೊ ಛಿಯ್ಯೊ, ಯೋರೈಮನ್‌ ಮತ್ತಾತಿನೊ ಛಿಯ್ಯೊ, ಮತ್ತಾತಿ ಲೇವಿನೊ ಛಿಯ್ಯೊ, ");
INSERT INTO vaa_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","ಲೇವಿ ಸಿಮೆಯೋನ್ನೊ ಛಿಯ್ಯೊ, ಸಿಮಿಯೋನ್ ಯೂದಾನೊ ಛಿಯ್ಯೊ, ಯೂದ ಯೋಸೇಫ್‌ನೊ ಛಿಯ್ಯೊ, ಯೋಸೇಫ ಯೋನಾಮ್‍ನೊ ಛಿಯ್ಯೊ, ಯೋನಾಮ್ ಎಲಿಯಕೀಮ್‌ನೊ ಛಿಯ್ಯೊ, ");
INSERT INTO vaa_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","ಎಲಿಯಕೀಮ್‌ ಮೆಲೆಯಾನ್ನೊ ಛಿಯ್ಯೊ, ಮೆಲೆಯಾನ್ ಮೆನ್ನಾನ್ನೊ ಛಿಯ್ಯೊ, ಮೆನ್ನಾನ್‌ ಮತ್ತಾಥನ್ನೊ ಛಿಯ್ಯೊ, ಮತ್ತಾಥ ನಾತಾನ್ನೊ ಛಿಯ್ಯೊ, ನಾತಾನ್ ದಾವೀದನೊ ಛಿಯ್ಯೊ, ");
INSERT INTO vaa_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","ದಾವೀದ ಇಷಯನೊ ಛಿಯ್ಯೊ, ಇಷಯ ಓಬೇದನೊ ಛಿಯ್ಯೊ, ಓಬೇದ್‌ ಬೋವಜನೊ ಛಿಯ್ಯೊ, ಬೋವಜ ಸಲ್ಮೋನ್ನೊ ಛಿಯ್ಯೊ, ಸಲ್ಮೋನ್‌ ನಹಸ್ಸೋನ್ನೊ ಛಿಯ್ಯೊ, ");
INSERT INTO vaa_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","ನಹಸ್ಸೋನ ಅಮ್ಮಿನಾದಾಬನೊ ಛಿಯ್ಯೊ, ಅಮ್ಮಿನಾದಾಬ ಅದ್ಮಿನ್‌ನೊ ಛಿಯ್ಯೊ, ಅದ್ಮಿನ್‌ ಅರ್‌ನೈನ್ನೊ ಛಿಯ್ಯೊ, ಅರ್‌ನೈನ್‌ ಎಸ್ರೋನ್‌ನೊ ಛಿಯ್ಯೊ, ಎಸ್ರೋನ್‌ ಪೆರೆಸನೊ ಛಿಯ್ಯೊ, ಪೆರೆಸ ಯೂದಾನೊ ಛಿಯ್ಯೊ, ");
INSERT INTO vaa_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","ಯೂದ ಯಾಕೋಬನೊ ಛಿಯ್ಯೊ, ಯಾಕೋಬ ಇಸಾಕನೊ ಛಿಯ್ಯೊ, ಇಸಾಕ್ ಅಬ್ರಹಾಮನೊ ಛಿಯ್ಯೊ, ಅಬ್ರಹಾಮ್‌ ತೆರಹನೊ ಛಿಯ್ಯೊ, ತೆರಹ ನಾಹೋರನೊ ಛಿಯ್ಯೊ, ");
INSERT INTO vaa_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","ನಾಹೋರ ಸೆರೂಗನೊ ಛಿಯ್ಯೊ, ಸೆರೂಗ ರೆಗೂವನೊ ಛಿಯ್ಯೊ, ರೆಗೂವ ಪೆಲೆಗನೊ ಛಿಯ್ಯೊ, ಪೆಲೆಗ ಹೆಬೇರನೊ ಛಿಯ್ಯೊ, ಹೆಬೇರ ಸಾಲನೊ ಛಿಯ್ಯೊ, ");
INSERT INTO vaa_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","ಸಾಲ ಕಾಯಿನ್ನೊ ಛಿಯ್ಯೊ, ಕಾಯಿನ್ ಅರ್‌ಫಾಕ್ಷದನ್ನೊ ಛಿಯ್ಯೊ, ಅರ್‌ಫಾಕ್ಷದನ್‌ ಶೇಮ್‌ನೊ ಛಿಯ್ಯೊ, ಶೇಮ್‍ ನೋಹಾನೊ ಛಿಯ್ಯೊ, ನೋಹ ಲಾಮೆಕನೊ ಛಿಯ್ಯೊ, ");
INSERT INTO vaa_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","ಲಾಮೆಕ ಮತೂಷಲನೊ ಛಿಯ್ಯೊ, ಮತೂಷಲ ಹನೋಕನೊ ಛಿಯ್ಯೊ, ಹನೋಕ ಯೆರೆದ್‌ನೊ ಛಿಯ್ಯೊ, ಯೆರೆದ್ ಮಹಲಲೇಲ್‌ನೊ ಛಿಯ್ಯೊ, ಮಹಲಲೇಲ್ ಕಾಯಿನ್ನೊ ಛಿಯ್ಯೊ, ");
INSERT INTO vaa_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","ಕಾಯಿನ ಎನೋಷನೊ ಛಿಯ್ಯೊ, ಎನೋಷ ಸೇತನೊ ಛಿಯ್ಯೊ, ಸೇತ್‌ ಆದಾಮನೊ ಛಿಯ್ಯೊ, ಅದಾಮ್‌ ದೇವ್‌ನೊ ಛಿಯ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","ಯೇಸು ಪವಿತ್ರಾತ್ಮಾಥಿ ಭರೈನ್, ಯೊರ್ದನ್‌ ನದ್ದಿಥು ಪಾಛೊ಼ಫರಿನ್ ಆಯೊ. ತದೆ ದೇವ್‌ನು ಆತ್ಮಾನೆ ಇನ ಉಜ್ಜಾ಼ಡಿ ಝ಼ಗೋಮ ಚ಼ಲಾಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","ಹಿಜ್ಜಾ಼ ಶೈತಾನ್‌ಥಿ ಯೇಸು ಚಾ಼ಳಿಖ್ಹ್ ರೋಜ಼್‌ ಶೋದನೆಮ ಪಡ್ಯೊ. ಇನ ಪಾಪ್‌ಮ ಪಖ್ಹಾವಾನ ಕರ‍್ಯೊ; ಯೋ ದನೂಮ ಯೇಸುನೆ ಶಾತ್ಬಿ ಕೋ ಖಾದೋನಿ, ಇನಖ್ಹಾಜೆ ಯೋ ಖ್ಹಾರ ದನ್ ಖತಮ್ ಹುವಾನ ಬಾದ್‌ಮ ಇನ ಭುಕ್‌ಲಾಗ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","ತದೆ ಶೈತಾನ್ನೆ ಯೇಸುನ, “ತೂ ದೇವ್‌ನೊ ಛಿಯ್ಯೊ ಉಶೇತೊ, ಆ ಬಂಡಾನ ರೋಟೊ ಹುವಾನಿಘೊಣಿ ಹುಕುಮ್‌ ದೇ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","ಕತೋಬಿ ಯೇಸುನೆ, “ಅದ್ಮಿ ಖಲಿ ರೋಟೊ ಖಾವಾಥೀಸ್‌ ಕೋ ಬಚಾ಼ನಿ, ಕರಿ ಲೀಖೈರ‍್ಹುಸ್” ಕರಿ ಜವಾಬ್‌ ದಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","ಅಜು಼ ಶೈತಾನ್ನೆ ಯೇಸುನ ಉಪ್ಪರ್ ಬುಲೈಲಿಜೈ಼ನ್‌, ಎಕ್ಕಸ್ ಘಡೀಮ ಜಗತ್‌ನು ಖ್ಹಾರಸ್ ರಾಜ್ಯನ ವತಾಳಿನ್, ");
INSERT INTO vaa_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","“ಮೇ ತುನ ಅನಿ ಖ್ಹಾರಿಸ್ ಅದಿಕಾರ್‌ನಾಬಿ, ಶನ್‌ಗಾರ್‌ನಾಬಿ ತುನ ದೆವುಸ್” ಕರಿ ಶೈತಾನ್ನೆ ಇನ ಬೋಲ್ಯೊ, “ಆ ಖ್ಹಾರು ಮಾರ ಹಾತ್‌ಮ ಛಾ಼, ಮೇ ಕಿನ ಹೋಣುಕತೋಬಿ ಆ ದಿಯ್ಯೆಜಾ಼ಯ್”. ");
INSERT INTO vaa_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","ತೂ ಮನ ಆಡ್‍ಪಡಿನ್ ಆರಾದನೆ ಕರ‍್ಯೋತೊ, ಆಖ್ಹಾರು ತಾರು ಉಶೆ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","ತದೆ ಯೇಸುನೆ, “ತಾರೊ ದೇವ್ ಹುಯಿರ‍್ಹೋತೆ ಪ್ರಭುನ ಎಕ್ಕಸ್ ಜ಼ಣಾನ ಆರಾದನೆ ಕರ‍್ನು ಅಜು಼ ಸೇವೆ ಕರ‍್ನು ಕರಿ ಲೀಖೈರ‍್ಹೂಸ್‌ನಿ” ಕರಿ ಜವಾಬ್‌ ದಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","ಅನ ಬಾದ್‌ಮ ಶೈತಾನ್ನೆ ಯೇಸುನ ಯೆರೂಸಲೇಮ್‌ನ ಬುಲೈಲಿಜೈ಼ನ್ ಮಂದಿರ್‌ನ ಉಪ್ಪರ್‌ಲಿ ಟೇಕ್‌ಡಿನಿ ಝ಼ಗೋಪರ್ ಭೀರಾಖಿನ್, “ತೂ ದೇವ್‌ನೊ ಛಿಯ್ಯೊ ಉಶೇತೊ ಹಜ್ಜಾ಼ಥೊ ಹೇಟ್ ಕೂದ್, ");
INSERT INTO vaa_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","‘ದೇವ್ ತುನ ಬಚಾ಼ಡಾನಟೇಕೆ ಇನ ದೂತರ್‌ನ ಹುಕುಮ್‌ ದಿಶೆ, ");
INSERT INTO vaa_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","ತಾರ ಗೋಡೊ ಬಂಡಾನ ಠೋಕರ್ ನಾಲಗ್ನುತೆ ತಿಮ್‌ ಯೋ ತುನ ಹಾತ್‌ಮ ಪಾಡಿಲಿಶೆ. ಕರೀಬಿ ಪವಿತ್ರ ದಪ್ತರ್‌ಮ ಲೀಖೈರ‍್ಹೂಸ್‌ನಿ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","ಕತೋಬಿ ಯೇಸುನೆ, “ತಾರೊ ದೇವ್‌ ಹುಯಿರ‍್ಹೋತೆ ಪ್ರಭುನ ತರೀಪ್‌ಶ ನಾ ಕರ‍್ನು ಕರೀಬಿ ಲೀಖೈರ‍್ಹೂಸ್‌ನಿ” ಕರಿ ಜವಾಬ್‌ ದಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","ಶೈತಾನ್ ಯೇಸುನ ಖ್ಹಾರಿ ತರ‍್ಹಾನು ಶೋದನೆ ಕರಾನ ಬಾದ್‌ಮ, ಥೋಡಿ ವಖ್ಹತ್‌ನಖ್ಹಾಜೆ ಇನ ಮ್ಹೆಂದಿನ್ ಚ಼ಲೆಗಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","ಅನ ಬಾದ್‌ಮ ಯೇಸು ಪವಿತ್ರಾತ್ಮನಿ ಶಕತ್‍ಥಿ ಭರೈನ್, ಪಾಛೊ಼ಫರಿ ಗಲಿಲಾಯ ತಬರ್‌ಖಾನ ಗಯೊ. ಯೋ ತಬರ್‌ಖಾನು ಖ್ಹಾರಿ ಬಾಜು಼ಮ ಯೇಸುನಿ ಬಾರೇಮಾನು ಖಬರ್ ಫೈಲಿಗಯು. ");
INSERT INTO vaa_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","ಯೇಸು ಸಬೆ ಭರಾವಾನು ಮಂದಿರ್‌ಮ ಖ್ಹಾರು ಅಛ್ಛಿ ಖಬರ್‌ನ ಬೋಲಿದೆವಾಲಗ್ಯೊ, ಖ್ಹಾರುಸ್ ಅದ್ಮಿ ಇನ ಖ್ಹರಾಯು. ");
INSERT INTO vaa_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","ಯೇಸು ಯೋ ಪಳ್ಯೋತೆ ಗಾಮ್‍ ಹುಯಿರ‍್ಹೂತೆ ನಜ಼ರೇತ್‌ನ ಆಯೊ. ಯೋ ಕರ್ತೊಥೋತೆ ಇಮ್ಮಸ್, ಸಬ್ಬತ್‌ ದನ್ಮ ಸಬೆ ಭರಾವಾನು ಮಂದಿರ್‌ಮ ಜೈ಼ನ್, ಪಢಾನಖ್ಹಾಜೆ ಉಠಿ ಭಿಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","ತದೆ ಯೆಶಾಯ ಕರಿ ಪ್ರವಾದಿನು ದಪ್ತರ್‌ನಿ ಪುಂಗ್‍ಳೀನ ಯೇಸುನ ಹಾತ್‌ಮ ದಿದು. ಇನೆ ಯೋ ಪುಂಗ್‍ಳೀನ ಛೋ಼ಡಿನ್, ಲೀಖೈರ‍್ಹೂತೆ ಝ಼ಗೋನ ದೇಖಿನ್ ಪಢ್ಯೊ, ಯೋ ವಾತೆ ಶಾತ್‌ಕತೊ, ");
INSERT INTO vaa_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","ಪ್ರಭುನು ಆತ್ಮ ಮಾರಪರ್ ಛಾ಼, ಗರೀಬ್‌ನ ಸುವಾರ್ತೆ ಬೋಲಾನಟೇಕೆ ದೇವ್ನೆ ಮನ ಅಬಿಷೇಕ್ ಕರಿರಾಖ್ಯೋಸ್, ಧರೈಗೂತೆ ಅದ್ಮಿನ, “ತುಮೆ ಛು಼ಟಿಗಯ ಕರಿ ಅಜು಼ ಕಾಣಾವ್ನ, ತುಮುನ ಡೋಳ ದೆಖಾವ್‌ಶೆ’ ಕರಿ ಬೋಲಾನಟೇಕೆ, ಅಜು಼ ಖ್ಹತಾವ್ಣಿಮ ಛಾ಼ತೆ ಇವ್ಣುನ ಛೋ಼ಡಾವನಟೇಕೆ, ");
INSERT INTO vaa_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","ಪ್ರಭುನೆ ಇನ ಅದ್ಮಿನ ಬಚಾ಼ಡಾನಖ್ಹಾಜೆ ನೇಮ್‌ಶಾಯೋತೆ, ವಖ್ಹತ್ ಐಗೈ ಕರಿ ಪ್ರಚಾರ್ ಕರಾನಟೇಕೆ ದೇವ್ನೆ ಮನ ಬೋಲಿ ಮೋಕ್ಲಿರಾಖ್ಯೊಸ್” ಕರಿ ");
INSERT INTO vaa_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","ಪಢಾನ ಬಾದ್‌ಮ, ಯೋ ಪುಂಗ್‌ಳಿನ ಲಪೇಟಿನ್ ಸಬೆ ಭರಾವಾನು ಮಂದಿರ್‌ನ ಸೇವಕ್‌ನ ಹಾತ್‌ಮ ದೀನ್ ಬೇಶಿಗಯೊ. ಹಿಜ್ಜಾ಼ ಥೂತೆ ತಮಾಮ್‌ ಅದ್ಮಿನಿ ನಜ಼ರ್ ಯೇಸುಪರ್ ಥೂ. ");
INSERT INTO vaa_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","ತದೆ ಯೇಸುನೆ ಇವ್ಣುನ, “ಮೇ ಹಮ್ಕೆ ಪಢ್ಯೋತೆ ವಚನ್ನ ತುಮೆ ಖ್ಹಮ್‌ಜೂ಼ಕರ್ತಥಾತೆ ತದ್ದೇಸ್ ಯೋ ಪೂರಹುಯು” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","ತಮಾಮ್‌ ಅದ್ಮಿ ಇನ ಖ್ಹರಾವಲಗ್ಯು ಅಜು಼ ಇನ ಮ್ಹೋಡಾವಾಟೆ ನಿಕ್ಳಾತೆ ವಾರ್ಖ್ಹಾನಿ ವಾತೆನ ಖ್ಹಮ್‌ಜಿನ್‌ ಆಶ್ಚರ್ಯಖೈನ್, “ಆ ಯೋಸೇಫ್‌ನೊ ಛಿಯ್ಯೊ ಕಾಹೆಕಿ ಶು? ಕರಿ ವಾತೆ ಬೋಲಿಲಿದು. ");
INSERT INTO vaa_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","ತದೆ ಇನೆ ಇವ್ಣುನ, “ತುಮೇತೊ, ವೈದ್ಯ ತಾರು ತೂ ಅಛ್ಛು಼ ಕರಿಲೆ’ ಕರಿ ಛಾ಼ತೆ ಮತ್ಲಬ್‌ನ ಬೋಲ್‌ಶು ಕರಿ ಮನ ಅಛ್ಛಿನಿತರ ಮಾಲುಮ್‌, ಅಜು಼ ಕಪೆರ್ನೌಮ್ಮ ತುಮೆ ಖ್ಹಮ್‍ಜ್ಯಾತೆ ಯೋಸ್, ಕಾಮ್ ಆ ತಾರ ಶೊಂತ್‌ ಗಾಮ್ಮಾಬಿ ಕರ್‌ ಕರಿ ಮನ ಬೋಲ್‌ಶು, ");
INSERT INTO vaa_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","ಕತೋಬಿ ಮೇ ತುಮೂನ ಖ್ಹಾಚ ಬೋಲುಸ್ಕಿ, ಖೆವ ಪ್ರವಾದಿನಾಬಿ ಶೊಂತ್‌ ಗಾಮ್‌ವಾಳು ಮಾನಕೊಯ್ನಿ. ");
INSERT INTO vaa_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","ಮಾರಿ ವಾತೇನ ಖ್ಹಮ್‌ಜೊ಼: ಎಲೀಯನ ಹಗಾಮ್ಮ ತೀನ್ ವರಖ್ಹ್‌ ಛೊ಼ ಮಹಿನ ಆಬ್‍ಥು ಪಾಣಿ ಕೋ ವರ್‌ಶ್ಯೋನಿ, ತದೆ ದೇಖ್ಹ್‌ನಿ ಖ್ಹಾರಿಸ್ ಬಾಜು಼ಮ ಕಾಳ್ದುಕಾಳ್ ಹುಯು, ಅಜು಼ ಯೋ ವಖ್ಹತ್‌ಮ ಇಸ್ರಾಯೇಲ್‌ ದೇಖ್ಹ್‌ಮ ಕೆತ್ರಿಸ್ಕಿ ಮುಂಡಚ್ಚಿ ತಯೇಡ ಥೀತೆ ಖ್ಹಾಚಸ್. ");
INSERT INTO vaa_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","ಕತೋಬಿ ದೇವ್ನೆ ಇವ್ಣಾಮ ಏಕ್‌ಜ಼ಣಾನಬಿ, ಎಲೀಯನ ಬೋಲಿ ಮೋಕ್‌ಲ್ಯೊಕೊಂತೆ, ಸೀದೋನ್ ದೇಖ್ಹ್‌ನು ಸರೆಪ್ತ ಕರಿ ಗಾಮ್ಮ ಥೀತೆ ಏಕ್‌ ಮುಂಡಚ್ಚಿನ ಘರೆ ಮೋಕ್‌ಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","ಅಜು಼ ಎಲೀಷ ಕರಿ ಪ್ರವಾದಿನ ಹಗಾಮ್ಮ ಇಸ್ರಾಯೇಲ್ ಅದ್ಮಿಮ ಕೆತ್ರುಕ್ಕಿ ಜ಼ಣಾನ ಖೋಡ್‍ ಲಾಗಿರ‍್ಹೂತು. ಕತೋಬಿ ಇವ್ಣಾಮ ಏಕ್‌ ಜ಼ಣಾನಾಬಿ ಅಛ್ಛು಼ ಕೋ ಹುಯೂನಿತೆ ಸಿರಿಯ ದೇಖ್ಹ್‌ನೊ ನಾಮಾನ್‌ ಕರಿ ಎಕ್ಕಸ್ ಜ಼ಣಾನ ಅಛ್ಛು಼ ಹುಯು” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","ಆ ವಾತೇನ ಖ್ಹಮ್‌ಜಿನ್‌ ಸಬೆ ಭರಾವಾನು ಮಂದಿರ್‌ಮ ಥೂತೆ ತಮಾಮ್‌ ಅದ್ಮಿ ಘಣು ಇರಾದೊ ಖೈನ್, ");
INSERT INTO vaa_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","ಉಠಿ ಭೀರಿನ್, ಯೇಸುನ ಗಾಮ್‌ಥು ಭಾರ್ ಧಕೇಲಿದಿದು. ಅಜು಼ ಇವ್ಣೆ ಯೇಸುನ ಇವ್ಣು ಗಾಮ್‍ ಭಂದೈರ‍್ಹೂಥೂತೆ ಪಹಾಡ್‌ನು ಕಥಾರ್‌ಪರ್ ಲೀ ಜೈ಼ನ್ ಹಿಜ್ಜಾ಼ಥು ಹೇಟ್ ಧಕೇಲಿದೇವ್ಣು ಕರಿ ಥೂ. ");
INSERT INTO vaa_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","ಕತೋಬಿ ಯೇಸು ಇವ್ಣ ಇಚ಼್‌ಮಾಕರಿ ನಿಕ್ಳಿನ್ ಚ಼ಲೆಗಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","ಬಾದ್‌ಮ ಯೇಸು ಗಲಿಲಾಯ ತಬರ್‌ಖಾನು ಕಪೆರ್ನೌಮ್ ಕರಿ ಗಾಮ್‌ನ ಗಯೊ. ಹಿಜ್ಜಾ಼ ಸಬ್ಬತ್‌ ದನ್ನೆ ಇವ್ಣುನ ವಚನ್‍ ಬೋಲಿದಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","ಇನೆ ಅದಿಕಾರ್‌ಥಿ ವಚನ್ ಬೋಲ್ಯೋತೆ ದೇಖಿನ್, ಇವ್ಣೆ ಘಣು ಆಶ್ಚರ್ಯಖಾದು. ");
INSERT INTO vaa_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","ಯೋ ಸಬೆ ಭರಾವಾನು ಮಂದಿರ್‌ಮ ಭೂತ್‌ ಧರಿರಾಖ್ಯುಥೂತೆ ಏಕ್‌ ಅದ್ಮಿ ಥೂ. ಯೋ ಜೋ಼ರ್ ಆವಾಜ಼್‌ಥಿ ಚಿಕ್ರಿನ್, ");
INSERT INTO vaa_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“ನಜ಼ರೇತ್‌ನೊ ಯೇಸು ಹಮಾರೇಥಿ ತುನ ಶಾತ್‌ ಛಾ಼? ಹಮೂನ ಬರ್ಬಾತ್ ಕರಾನ ಹಜ್ಜಾ಼ ಐರ‍್ಹೋಸ್ಕಿ ಶು? ತೂ ಕೋಣ್ ಕರಿ ಮನ ಮಾಲುಮ್. ತೂ ದೇವ್‍ಥಿ ಬೋಲಿಮೊಕ್‌ಲ್ಯೊ ಹುಯೊ ಪರಿಶುದ್ದ ಹುಯಿರ‍್ಹೋಸ್! ಕರಿ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","ತದೆ ಯೇಸುನೆ ಯೋ ಭೂತ್‌ನ ಗುರ್‌ಕೈನ್, “ಖ್ಹೊಪ್‌ರ‍್ಹೆ! ಅನ ಮ್ಹೆಂದಿನ್ ಭಾರ್‌ನಿಕಳ್‌” ಕರಿ ಬೋಲ್ಯೊ. ಯೋ ಭೂತ್‍ನೆ ಯೋ ಅದ್ಮಿನ ಇವ್ಣ ಖ್ಹಾಮ್ಣೆ ಹೇಟ್‌ ರಡ್‌ಕೈನ್‌, ಇನ ಶನೂಸ್ ಟಚ಼್‌ಕೊ ದಿದುಕೊಂತೆ ಮ್ಹೆಂದಿನ್ ಚ಼ಲಿಗಯು. ");
INSERT INTO vaa_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","ಅನ ದೇಖಿನ್‌ ಅದ್ಮಿಖ್ಹಾರು ಆಶ್ಚರ್ಯಖೈನ್, “ಆ ಕಿಮ್ನಿ ವಾತೆ? ಆ ಅದಿಕಾರ್‌ಥಿ ಅಜು಼ ಶಕತ್‍ಥಿ ಭೂತ್‌ಅಖ್ಖಾನಬಿ ಹುಕುಮ್‌ ದೇಸ್‌ನಿ, ಇವ್ಣೇಬಿ ಭಾರ್‌ ನಿಕ್ಳಿಜಾ಼ಸ್‌ನಿ! ಕರಿ ಏಕ್‌ಥಿ ಏಕ್‌ ವಾತೆ ಬೋಲಿಲಿದು. ");
INSERT INTO vaa_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","ಅಜು಼ ಯೇಸುನಿ ಬಾರೇಮನಿ ಖಬರ್ ಯೋ ತಬರ್‌ಖಾನು ಖ್ಹಾರಿ ಬಾಜು಼ಮ ಫೈಲಿಗಯು. ");
INSERT INTO vaa_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","ಯೇಸು ಸಬಾಮಂದಿರ್‌ಥ ನಿಕ್ಳಿನ್ ಸೀಮೋನ್ನ ಘರ್‌ಕನ ಗಯೊ. ಹಿಜ್ಜಾ಼ ಸೀಮೋನನಿ ಖ್ಹಾಖ್ಹು ಜಾ಼ಖ್ಹತ್ ತಾವ್ ಚ಼ಢೀನ್ ತಲ್‌ಖುಕರ್ತಿಥಿ, ಇನಿ ಬಾರೇಮ ಇವ್ಣೆ ಯೇಸುನ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","ತದೆ ಯೇಸುನೆ ಇನಾಕನ ಜೈ಼ನ್ ಭೀರಿನ್, ಇನ ಮ್ಹೆಂದಿನ್ ಜಾ಼ವಾನಿ ಘೋಣಿ ಯೋ ತಾವ್‌ನ ಹುಕುಮ್‌ ದೇತಾಖ್ಹತರ್‌, ತಾವ್ ಉತ್ರಿಗಯೊ. ತದ್‌ನು ತದ್ದೇಸ್ ಯೋ ಉಠೀನ್ ಇವ್ಣಿ ಸೇವಾ-ಚಾ಼ಕ್ರಿ ಕರಿ. ");
INSERT INTO vaa_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","ದನ್ ಡುಬಾನ ಬಾದ್‌ಮ ಥರಥರಾನು ರೋಗ್‌ವಾಳು ಥೂತೆ ತಮಾಮ್‌ ಘರ್‌ವಾಳು, ಜಾನ್ನ ಅಛ್ಛು಼ಕೊಂತೆ ಅದ್ಮಿನಖ್ಹಾರು ಯೇಸುಕನ ಬುಲೈಲಾಯು. ಹರೇಕ್ ರೋಗ್‌ವಾಳಪರ್ ಯೇಸುನೆ ಹಾತ್‌ ಮ್ಹೇಲಿನ್ ಇವ್ಣುನ ಅಛ್ಛು಼ ಕರ‍್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","ಭೂತ್‌ಖ್ಹಾರು ಜಿನುಕು, “ತೂ ದೇವ್‌ನೊ ಛಿಯ್ಯೊ” ಕರಿ ಬಳೆಳ್ಹಾಟ್ ಮ್ಹೇಲ್ತುಹುಯಿನ್, ಕೈಯೆಕ್ಕಿ ಅದ್ಮಿನ ಮಹಿತು ನಿಕ್ಳಿಗಯು. ಯೋ ಕ್ರಿಸ್ತ ಕರಿ ಭೂತ್‌ ಖ್ಹಾರಾನ ಮಾಲುಮ್‍ಥೂತೆ ಇನಟೇಕೆ, ಯೇಸುನೆ ಇವ್ಣುನ ವಾತೆ ನಾ ಬೋಲ್‌ನು ಕರಿ ಹುಕುಮ್‌ ದಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","ವ್ಹಾಣ್‌ಖ್ಹತ್ರೆ ಯೇಸು ಘರ್‌ನ ಮ್ಹೇಲಿನ್ ಉಜ್ಜಾ಼ಡಿ ಝ಼ಗೋನ ಗಯೊ. ಅದ್ಮಿಖ್ಹಾರು ಯೇಸುನ ಢೂಂಡ್‌ತುಹುಯಿನ್, ಯೊ ಥೋತೆ ಝ಼ಗೋಕನ ಆಯಿನ್, ಇವ್ಣುನ ಮ್ಹೆಂದಿನ್ ನಾ ಜಾ಼ವ್ಣುತೆ ಇಮ್‌ ಇನ ಭೀರಾಖಾನ ದೇಖ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","ಕತೋಬಿ ಯೇಸುನೆ ಇವ್ಣುನ, “ಮೇ ಬಿಜ಼ಖ್ಹಾರ ಗಾಮ್ಮಾಬಿ ದೇವ್ನಿ ರಾಜ್ಯನಿ ದೇವ್ನಿ ಅಛ್ಛಿ ಖಬರ್‌ನ ಬೋಲ್‌ನು, ಅನಖ್ಹಾಜೆಸ್ ದೇವ್ನೆ ಮನ ಮೋಕ್ಲಿರಾಖ್ಯೋಸ್ತೆ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","ಅನ ಬಾದ್‌ಮ ಯೇಸುನೆ ಯೂದಾಯ ದೇಖ್ಹ್‌ನು ಸಬೆ ಭರಾವಾನು ಮಂದಿರ್‌ಮ ಖ್ಹಾರು ಅಛ್ಛಿ ಖಬರ್‌ನ ಬೋಲ್ತೊಹುಯಿನ್ ನಿಕ್‌ಳ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","ಏಕ್‌ ದನ್ನೆ ಯೇಸು ಗೆನೆಸರೇತ್‍ ದರ‍್ಯಾವ್‍ನ ಕನಾರಿಕನ ಭೀಯೋಥೊ. ತದೆ ಅದ್ಮಿಖ್ಹಾರು ದೇವ್ನಿ ವಚನ್ ಖ್ಹಮ್‌ಜಾ಼ನಖ್ಹಾಜೆ ಧಕೇಲ-ಧಕೇಲಿ ಹೋತುಹುಯಿನ್, ಇನ ಅಶ್‌ಪಿಶ್ ಆಯಿನ್ ಭರಾಯು ");
INSERT INTO vaa_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","ತದೆ ದರ‍್ಯಾವ್‍ನಿ ಕನಾರಿಕನ ಭೀರಿಥೀತೆ ಬೇ ಡೋಣ್ಣಾ ಯೇಸುನೆ ದೇಖ್ಯೊ. ಮಾಛ್ಲು಼ ಖ್ಹಾವಾಳು ಖ್ಹಾರು ಡೋಣ್‌ಮಾಥು ಭಾರ್ ಆಯಿನ್, ಇವ್ಣು-ಇವ್ಣು ಜಾ಼ಳು ಧೊವ್‍ಕರ್ತೂಥು. ");
INSERT INTO vaa_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","ಯೋ ಡೋಣೆಮಾಥು ಸೀಮೋನ್ನಿ ಏಕ್‌ ಡೋಣ್‌ಮ ಯೇಸು ಚ಼ಢೀನ್, ಕನಾರೆಕಂಥು ಜ಼ರದೂರ್ ಡೋಣ್ಣಾ ಧಕೇಲ್‍ ಕರಿ ಇನ ಬೋಲಿಲಿದೊ. ಬಾದ್‌ಮ ಡೋಣ್‌ಮ ಬೇಶಿನ್, ಯೋ ಅದ್ಮಿನಿ ಭೀಡ್‌ಣ ವಚನ್ನ ಬೋಲಿದಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","ವಚನ್‍ ಬೋಲಿದ್ಯವಾನ ಬಾದ್‌ಮ ಯೇಸುನೆ ಸೀಮೋನ್ನ, “ಗಧಾರ್ ಪಾಣಿನಿ ಝ಼ಗೋಮ ಡೋಣ್ಣಾ ಚ಼ಲೈನ್, ಮಾಛ್ಲು಼ ಧರಾನ ಖ್ಹಾಜೆ ತುಮಾರು ಜಾ಼ಳು ನಾಖೊ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","ತದೆ ಸೀಮೋನ್ನೆ, “ಗುರು, ಹಮೆ ರಾತ್ ಅಖ್ಖು ಮ್ಹಿನತ್ ಕರ‍್ಯಾತೋಬಿ, ಏಕ್‌ ಮಾಛ್ಲು಼ಬಿ ಕೋಮಳ್ಯುನಿ, ಕತೋಬಿ ತಾರಿ ವಾತ್‌ಪರ್, ಮೇ ಜಾ಼ಳು ನಾಖುಸ್” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","ತದೆ ಇವ್ಣೆ ಜಾ಼ಳಾವ್‍ನ ನಾಖ್ಯು. ತದೆ ಮಾಛ಼್‌ಲಾನಿ ಗುಡ್ಡಾರಾಶೆ ಜಾ಼ಳಾವ್‍ಮ ಖ್ಹಪ್‌ಡ್ಯು. ಅನೇಥಿ ಇವ್ಣು ಜಾ಼ಳು ಫಾಟಾನ ಐಲಾಗ್ಯೂಥು. ");
INSERT INTO vaa_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","ತದೆ ಇವ್ಣೆ ಬಿಜಿ ಡೋಣ್‌ಮ ಥೂತೆ ಇವ್ಣು ಜೋ಼ಡೆವಾಳನ ಹಾತ್‌ನೊ ಝಾ಼ಲೊ ಕರೀನ್, ಮದತ್ನಖ್ಹಾಜೆ ಬುಲಾಯು. ಇವ್ಣೆ ಆಯಿನ್ ಭೇ ಡೋಣ್‌ಮ ಮಾಛ್ಲು಼ ಭರಾಖ್ಹತರ್, ಯೋ ಡೋಣೆ ಡುಬಾನಿಘೋಣಿ ಹುವ್ವಾಲಗ್ಯೂಥು. ");
INSERT INTO vaa_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","ಅನ ದೇಖಿನ್ ಸೀಮೋನ್ ಪೇತ್ರನೆ ಯೇಸುನ ಗುಡ್‌ಘ್ಯಪರ್ ಪಡೀನ್, “ಪ್ರಭು ಮನ ಮ್ಹೆಂದಿನ್ ಜಾ಼! ಮೇ ಪಾಪಿ ಅದ್ಮಿ ಹುಯಿರ‍್ಹೋಸ್!” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","ಸೀಮೋನ್ನಾಬಿ ಇನ ಜೋ಼ಡ್ಮ ಥೂತೆ ಬಿಜ಼ ಖ್ಹಾರಾನಾಬಿ, ಇವ್ಣೆ ಧರ‍್ಯೂತೆ ಮಾಛ಼್‌ಲಾವ್ನ ದೇಖಿನ್ ಆಶ್ಚರ್ಯ ಹುಯು. ");
INSERT INTO vaa_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","ಸೀಮೋನ್ನ ಜೋ಼ಡ್‍ವಾಳ ಹುಯಿರ‍್ಹಾಥಾತೆ ಜೆಬೆದಾಯನ ಛಿಯ್ಯಾ ಯಾಕೋಬ ಅಜು಼ ಯೋಹಾನನೆಬಿ ಇಮ್ಮಸ್ ಆಶ್ಚರ್ಯಖಾದು. ತದೆ ಯೇಸುನೆ ಸೀಮೋನ್ನ, “ಡರ್‌ನಕೊ, ಆಜ಼್‌ಥು ತೂ ಅದ್ಮಿನ ಖ್ಹಾವಾನು ಕಾಮ್ ಕರೀಶ್!” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","ಇವ್ಣೆ ಇವ್ಣು ಡೋಣೇನ ಕನಾರಿಕನ ಲಯಿನ್, ತಮಾಮ್‌ ರಾಛಾ಼ನ ಮ್ಹೆಂದಿನ್, ಯೇಸುನ ಕೇಡೆ ಗಯ. ");
INSERT INTO vaa_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","ಏಕ್‌ ದನ್ನೆ ಯೇಸು ಏಕ್‌ ಗಾಮ್ಮ ಥೊ. ಹಿಜ್ಜಾ಼ಸ್ ಆಂಗ್‌ತನ್‌ ಅಖ್ಖುಸ್ ಖೋಡ್‍ ಲಾಗಿಹುಯು ಏಕ್‌ ಅದ್ಮಿ ಥೂ. ಯೋ ಯೇಸುನ ದೇಖಿನ್, ಇನಖ್ಹಾಮ್ಣೆ ಆಡು ಪಡೀನ್, “ಪ್ರಭು, ತೂ ಮನ್ ಕರ‍್ಯೋತೊ ಮನ ಶುದ್ದಿ ಕರೆಜಾ಼ಯ್! ಕರಿ ಗಿಂಗೈಲಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","ಯೇಸುನೆ ಇನೊ ಹಾತ್ನ ಭಡೈನ್, ಇನ ಛೀಮಿನ್‌, “ಮನ ಮನ್ ಛಾ಼, ಶುದ್ದಿ ಹೂ” ಕರಿ ಬೋಲ್ಯೊ. ತದ್‌ನು ತದ್ದೇಸ್ ಯೋ ಅದ್ಮಿನೊ ಖೋಡ್‍ ಖ್ಹಾರು ನಿಕ್ಳಿಗಯು. ");
INSERT INTO vaa_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","ತದೆ ಯೇಸುನೆ ಇನ, “ತೂ ಕಿನಾಬಿ ನಕೊ ಬೋಲಿಶ್, ಕತೋಬಿ ಯಾಜಕಕನ ಜೈ಼ನ್ ತಾರು ಆಂಗ್‌ತನ್ನ ವತಾಳ್, ಮೋಶೇನೆ ಹುಕುಮ್ ದೀರಾಖ್ಯೋತೆ ಕಾಣ್ಕೆದೀನ್ ತಾರಿ ಅಶ್ನಾನ್‍ಧಾನ್ನ ಚ಼ಲಾವ್‍, ಅದ್ಮಿನ ಆ ಸಾಕ್ಷಿ ಹುಯಿರ‍್ಹವಾದೆ” ಕರಿ ಹುಕುಮ್ ದಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","ತೋಬಿ ಯೇಸುನಿ ಬಾರೇಮ ಅಜೂ಼ಬಿ ಜಾ಼ಖ್ಹತ್ ಫೈಲೈಗಯು, ಅದ್ಮಿಖ್ಹಾರು ಇನಿ ವಚನ್ ಖ್ಹಮ್‌ಜಾ಼ನಖ್ಹಾಜೆ ಅಜು಼ ಇವ್ಣು-ಇವ್ಣು ರೋಗ್‌ ಅಛ್ಛು಼ ಕರೈಲ್ಯವಾನಟೇಕೆ, ಝೂ಼ಂಡೆ-ಝೂ಼ಂಡೆ ಹುಯಿನ್ ಇನಾಕನ ಆಯು. ");
INSERT INTO vaa_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","ಕತೋಬಿ ಯೇಸುತೊ ಉಜ್ಜಾ಼ಡಿ ಝ಼ಗೋಮ ಜೈ಼ನ್, ಪ್ರಾರ್ಥನೆ ಕರುಕರ್ತೊಥೊ. ");
INSERT INTO vaa_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","ಏಕ್‌ ದನ್ನೆ ಯೇಸು ವಚನ್‍ ಬೋಲಿ ದೆವ್‍ಕರ್‌ತೋಥೊ. ಗಲಿಲಾಯ ಅಜು಼ ಯೂದಾಯ ತಬರ್‌ಖಾನು ತಮಾಮ್‌ ಗಾಮ್‌ಥು ಅಜು಼ ಯೆರೂಸಲೇಮ್‌ಥು ಆಯುಹುಯು ಫರಿಸಾಯರ್‌ಬಿ, ಮೋಶೇನು ಧರ್ಮಶಾಸ್ತ್ರ ಶಿಕಾಡವಾಳು ಶಾಸ್ತ್ರಿಯೆ ಹಿಜ್ಜಾ಼ ಬೆಠೂಥು. ರೋಗ್‌-ರಾಯೊ ಅಛ್ಛು಼ ಕರಾನವಾಖ್ಹ್‌ತೆ ಪ್ರಭುನಿ ಶಕತ್ ಯೇಸುಮ ಥೀ.‌ ");
INSERT INTO vaa_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","ತದೆ ಥೋಡ ಪರ್ಖ್ಹಾವ್‍ನೆ ಏಕ್‌ಜ಼ಣೊ ಲಕ್‍ವೊ ಮಾರ‍್ಯುಹುಯಾನ ಬಿಛಾ಼ವ್ಣಿಪರ್ ಪಾಡಿಲಿನ್ ಆಯು. ಕತೋಬಿ ಇನಮಹಿ ಲೀಜೈ಼ನ್, ಯೇಸುನ ಖ್ಹಾಮ್ಣೆ ಮ್ಹೇಲ್ನುಕರಿ ಕರ‍್ಯುತೋಬಿ, ");
INSERT INTO vaa_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","ಅದ್ಮಿನಿ ಭೀಡ್ ಥೀತೆ ಇನಾಖ್ಹಾಜೆ, ಇನಮಹಿ ಲೀಜಾ಼ವಾನ ವಾಟ್‌ಕೊಂತೆ ದೇಖಿನ್‌, ಇನ ಪಾಡಿಲಿನ್ ಛ಼ತ್‍ನ ಉಪ್ಪರ್ ಜೈ಼ನ್, ಛ಼ತ್‍ನ ಕಾಡಿನ್, ಇನ ಬಿಛಾ಼ವ್ಣಿ ಖ್ಹಮೇದ್ ಯೇಸುನ ಖ್ಹಾಮ್ಣೆ ಉತಾರ‍್ಯು. ");
INSERT INTO vaa_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","ಯೇಸುನೆ ಇವ್ಣಿ ವಿಶ್ವಾಸ್‌ನ ದೇಖಿನ್‌, ಯೋ ಲಕ್‍ವೊ ಮಾರಿರಾಖವಾಳನ, “ದೇಕ್‌ಲಾ ದೋಸ್, ತಾರು ಪಾಪ್‌ಖ್ಹಾರು ಮಾಪ್‌ ಹುಯಿಗಯು” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","ತದೆ ಮೋಶೇನು ವಚನ್‍ ಶಿಕಾಡವಾಳು ಶಾಸ್ತ್ರಿಯೆ ಅಜು಼ ಫರಿಸಾಯರ್ ಖ್ಹಾರು ಇವ್ಣ-ಇವ್ಣಾಮಸ್‌, “ಆ ಅದ್ಮಿ ಕೋಣ್ ಉಶೆ, ದೇವ್ನ ವಿರೋದ್ ವಾತೆ ಬೋಲಾಸ್ತೆ? ದೇವ್ನ ಮ್ಹೇಲಿನ್ ಬಿಜು಼ ಕಿನೇಥಿ ಪಾಪ್‌ಖ್ಹಾರು ಮಾಪ್‌ ಕರಾನ ಹುವಾನು? ಕರಿ ಸೋಚಾಲಗ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","ಕತೋಬಿ ಯೇಸುನೆ ಇವ್ಣೆ ಇಮ್‌ ಸೋಚುಕರಾತೆ ಮಾಲುಮ್‌ ಕರೀಲಿನ್‌ ಇವ್ಣುನ, “ತುಮೆ ತುಮಾರ ಮನ್‌ಮ ಅಮ್ ಶನ ಸೋಚೋ಼ಸ್ತೆ? ");
INSERT INTO vaa_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","ಕೆಹು ಶುಲ್ಬ? ತಾರು ಪಾಪ್‌ಖ್ಹಾರು ಮಾಪ್‌ ಹುಯಿಗು ಕರಿ ಬೋಲಾನುಕಿ? ಉಠಿ ಚಾ಼ಲ್ ಕರಿ ಬೋಲಾನು? ");
INSERT INTO vaa_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","ಕತೋಬಿ ಜ಼ಮೀನ್‌ಪರ್ ಪಾಪ್‌ಖ್ಹಾರು ಮಾಪ್‌ ಕರಾನ ಅದ್ಮಿನೊ ಛಿಯ್ಯಾನ ಅದಿಕಾರ್ ಛಾ಼ ಕರಿ ಬೋಲಾನು ತುಮೂನ ಮಾಲುಮ್‌ ಪಡ್ಣು, ಕರಿ ಬೋಲಿನ್ ಯೋ ಲಕ್‌ವೊ ಮಾರಿರಾಖವಾಳ ಭಣಿ ದೇಖಿನ್‌, ‘ಉಟ್ ತಾರಿ ಬಿಛಾ಼ವ್ಣಿನ ಪಳ್ಳಿನ್‌ ಘರೆ ಜಾ಼ ಕರಿ ತುನ ಬೋಲುಸ್” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","ಇಮ್‌ ಬೋಲ್ತಾಸ್‌ನ ಯೋ ಇವ್ಣ ಖ್ಹಾಮ್ಣೆಸ್ ಉಠೀನ್, ಯೋ ಖ್ಹುತೊಥೋತೆ ಬಿಛಾ಼ವ್ಣಿನ ಪಳ್ಳಿನ್, ದೇವ್ನ ಖ್ಹರಾವ್‌ತೊ ಹುಯಿನ್, ಘರೆ ಗಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","ದೇಖ್ಯೂತೆ ತಮಾಮ್‌ ಅದ್ಮಿನೆ ಘಣು ಆಶ್ಚರ್ಯಖಾದು! ಅಜು಼ ಡರ್‌ಥಿ ಭರೈನ್ ದೇವ್ನ ಖ್ಹರಾಯು, ಅಜು಼ ಬೋಲ್ಯೂಕಿ, “ಆಜ಼್ ಹಮೆ ಆಶ್ಚರ್ಯನು ಬಾರೇಮ ದೇಖ್ಯ!” ");
INSERT INTO vaa_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","ಅನ ಬಾದ್‌ಮ, ಯೇಸು ಹಿಜ್ಜಾ಼ಥೊ ಬಹರ್ ಜೈ಼ನ್, ಶುಂಕ ಮಾಂಗಾನಿ ಝ಼ಗೋಪರ್‌ ಬೆಠೊಥೋತೆ ಏಕ್‌ ಜ಼ಣಾನ ದೇಖ್ಯೊ. ಇನು ನಾಮ್ ಲೇವಿ. ಯೇಸುನೆ ಇನ, “ಮಾರ ಪೀಠೆ ಆವ್” ಕರಿ ಬುಲಾಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","ಇನೆ ಉಠೀನ್, ಖ್ಹಾರುಸ್ ಮ್ಹೆಂದಿನ್, ಯೇಸುನ ಪೀಠೆ ಗಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","ಬಾದ್‌ಮ ಲೇವಿನೆ ಇನ ಘರ್‌ಮ ಯೇಸುನಖ್ಹಾಜೆ, ಏಕ್‌ ಮೋಟಿ ಮಿಝ಼್‌ವಾನ್ ಪಿಕಾಯೊ. ಹಿಜ್ಜಾ಼ ಶುಂಕ ವಶೂಲ್ ಕರಾವಾಳು ಅಜು಼ ಬಿಜು಼ ಅದ್ಮಿಖ್ಹಾರು ಝೂ಼ಂಡ್‌ ಭರೈನ್ ಇವ್ಣ ಜೋ಼ಡೆ ಖಾಣನ ಬೆಠೂಥು. ");
INSERT INTO vaa_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","ಅನ ದೇಖಿನ್, ಫರಿಸಾಯರ್ ಅಜು಼ ಇವ್ಣಿ ಝೂ಼ಂಡ್‌ನ ಮಳಿಹುಯು ಮೋಶೇನು ಧರ್ಮಶಾಸ್ತ್ರ ಶಿಕಾಡವಾಳು ಶಾಸ್ತ್ರಿ ಖ್ಹಾರು ಯೇಸುನ ಶಿಷ್ಯರ್‌ಪರ್ ಮಶ್ಲಾ ಮಾರ್‌ತುಹುಯಿನ್, “ತುಮೆ ಶುಂಕ ಮಾಂಗವಾಳನ ಅಜು಼ ಪಾಪಿ ಖ್ಹಾರಾನ ಜೋ಼ಡೆ ಶನ ಖಾಣುಖಾಸ್ತೆ?” ಕರಿ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","ಅನ ಖ್ಹಮ್‌ಜಿನ್‌ ಯೇಸುನೆ ಇವ್ಣುನ, “ಅಛ್ಛು಼ರ‍್ಹಾವಾಳನ ವೈದ್ಯನಿ ಜ಼ರೂರತ್ ಕೋ ಪಡಾನಿ, ಕತೋಬಿ ರೋಗ್‌ರಾಯಮ ರ‍್ಹಾವಾಳನ ವೈದ್ಯ ಹೋಣು ಪಡಾಸ್‌” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","ದೇವ್‌ಭಣಿ ಫರೊ ಕರಿ,ನೀತಿವಾಳ ಅದ್ಮಿಯೇನ ಬುಲಾವನ ಕಾಹೆ, ಪಾಪಿ ಖ್ಹಾರಾನ ಬುಲಾವನ ಆಯೋತೆ” ಕರಿ ಜವಾಬ್‌ ದಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","ಥೋಡು ಅದ್ಮಿ ಯೇಸುನ, “ಯೋಹಾನನು ಶಿಷ್ಯರ್‌ ಖ್ಹಾರು ಘಡಿಕೇಡೆ ಉಪವಾಸ್ ರ‍್ಹೇಸ್‌ ಅಜು಼ ಬಿಂತಿನಿ ಪ್ರಾರ್ಥನೆ ಕರ್ತು ರ‍್ಹೇಸ್‌, ಇಮ್ಮಸ್ ಫರಿಸಾಯರ್‌ನು ಶಿಷ್ಯರ್‌ಬಿ ಉಪವಾಸ್ ಕರಾಸ್, ಕತೋಬಿ ತಾರು ಶಿಷ್ಯರ್‌ ಕದೇಬಿ ಖಾವಣ್‌ಪಿವಾಣ್‌ ಕರ್ತು ರ‍್ಹೇಸ್‌ನಿ” ಕರಿ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","ತದೆ ಯೇಸುನೆ ಇವ್ಣುನ, “ವ್ಯಹಾನ ಛ಼ತ್‍ಮ ಅದ್ಮಿನ ಜೋ಼ಡೆ ನೌಶೊ ರ‍್ಹವಾನಿ ವಖ್ಹತ್‌ಮ ಇವ್ಣುನ ಉಪವಾಸ್ ಕರಾವಾನ ತುಮಾರೇಥಿ ಉಶೇಕಿ ಶು? ಕೊಯ್ನಿ! ");
INSERT INTO vaa_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","ಕತೋಬಿ ನೌಶೊನ ಇವ್ಣಾಕಂಥು ದೂರ್ ಲೀಜಾ಼ವಾನ ದನ್ ಆವ್‌ಶೆ, ತದೆ ಇವ್ಣೆ ಉಪವಾಸ್ ಕರ್ಶೆ” ಕರಿ ಜ಼ವಾಬ್‌ದಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","ಯೇಸುನೆ ಇವ್ಣುನ ಏಕ್‌ ಮತ್ಲಬ್‌ನಿ ಖೇಣಿನ ಬೋಲ್ಯೊ: ಯೋ ಶಾತ್‌ಕತೊ, ಕೋಣ್‌ಬಿ ನವು ಲುಂಗ್ಡಾನು ಏಕ್‌ ಥಿಗ್‍ಳಾನ ಫಾಡಿನ್, ಫಾಟಿಹುಯು ಜೂ಼ನ ಲುಂಗ್ಡಾಕೇಡೆ ಲಗಾಡಿನ್ ಶಿವಾಕೊಯ್ನಿ. ಇಮ್‌ ಶಿವ್ಯುತೊ, ಯೋ ನವು ಲುಂಗ್ಡಾನ ಫಾಡಿನ್ ಖರಾಬ್ ಕರಾದಾಖ್ಹಲ್, ಎತ್ರೇಸ್ ಕಾಹೆತೆ ನವ ಲುಂಗ್ಡಾನು ಥಿಗ್‌ಳು, ಯೋ ಜೂ಼ನ ಲುಂಗ್ಡಾಪರ್‌ ಖ್ಹಾಜ಼ಕೊಯ್ನಿ. ");
INSERT INTO vaa_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","ಕೋಣ್‌ಬಿ ಜೂ಼ನಿ ಚಾ಼ಂಬ್ಡಾನಿ ತಿತ್ತಿಯೇಮ ನವು ದ್ರಾಕ್ಷಿನು ರಖ್ಹ್‌ನ ಭರಿನ್ ಮ್ಹೇಲಾಕೊಯ್ನಿ. ಶನಕತೊ ಯೋ ನವು ದ್ರಾಕ್ಷಿನು ರಖ್ಹ್‌, ಜೂ಼ನು ಚಾ಼ಂಬ್ಡಾನಿ ತಿತ್ತಿಯೇನ ಫೋಡಿನ್ ಭಾರ್ ರಂಚೈ಼ಜಾ಼ವಾನು ಕಾಹೆತೆ, ತಿತ್ತಿಯೇಬಿ ಖರಾಬ್ ಹುಯಿಜಾ಼ಸ್. ");
INSERT INTO vaa_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","ಇನಖ್ಹಾಜೇಸ್ ನವು ದ್ರಾಕ್ಷಿನು ರಖ್ಹ್‌ನ ನವಿ ಚಾ಼ಂಬ್ಡಾನಿ ತಿತ್ತಿಯೇಮ ಭರಿ ಮ್ಹೇಲಾಸ್! ");
INSERT INTO vaa_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","ಜೂ಼ನು ದ್ರಾಕ್ಷಿನು ರಖ್ಹ್‌ ಪೀದುಹುಯು ಅದ್ಮಿ, ನವು ದ್ರಾಕ್ಷಿನು ರಖ್ಹ್‌ ಹೋಣು ಕರಿ ಬೋಲಾಕೊಯ್ನಿ. ಯೋ ಜೂ಼ನು ದ್ರಾಕ್ಷಿನು ರಖ್ಹ್‌ನಾಸ್ ಅಛ್ಛು಼ಕರಿ ಬೋಲಾಸ್. ");
INSERT INTO vaa_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","ಸಬ್ಬತ್‌ ದನ್ಮ ಯೇಸು ಅನಾಜ಼್ ಪಿಕಿಹುಯು ಖೇತರ್‌ಮಾಕರಿ ಚಾ಼ಲಿ ಒಳೆಜಾ಼ತೊಥೊ. ತದೆ ಇನ ಶಿಷ್ಯರ್‌ನೆ ಬುಟ್ಟಾ ತೋಡಿನ್, ಹಾತ್‌ಮ ಮಖ್ಹ್‌ಳಿನ್ ಖಾವಾಲಗ್ಯಾಥ. ");
INSERT INTO vaa_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","ಅನ ದೇಖಿನ್ ಫರಿಸಾಯರ್‌ವಾಳು ಥೋಡು ಜ಼ಣು, “ಧರ್ಮಶಾಸ್ತ್ರ ಸಬ್ಬತ್‌ ದನ್ಮ ಕರ್ನುನಾತೆ ಕಾಮ್ನ ತುಮೆ ಶನ ಕರೋಸ್ತೆ?” ಕರಿ ಪುಛಾ಼ವಖ್ಹತರ್, ");
INSERT INTO vaa_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","ಯೇಸುನೆ ಇವ್ಣುನ, “ದಾವೀದ್‌ನಾಬಿ ಇನ ಜೋ಼ಡ್ಮ ರ‍್ಹಾವಾಳನ ಭುಕ್ ಲಾಗಾನಿ ವಖ್ಹತ್‌ಮ, ದಾವೀದ್‌ನೆ ಶಾತ್‌ ಕರ‍್ಯೊ ಕರಿ ತುಮೆ ಪಢ್ಯಾಕೊಯ್ನಿಕಿಶು? ");
INSERT INTO vaa_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","ಇನೆ ದೇವ್ನ ಘರ್‌ಮ ಜೈ಼ನ್, ಅಪ್ಣಿ ಖಾನುಲ್‌ಮ ಯಾಜಕವ್ನ ಮ್ಹೆಂದಿನ್ ಕೋಣ್‌ಬಿ ನಾ ಖಾಣುತೆ, ದೇವ್ನ ಖ್ಹಾಮ್ಣೆ ಮ್ಹೇಲಾತೆ ರೋಟಾನ ಪಾಡಿಖೈನ್, ಇನ ಜೋ಼ಡ್ಮ ರ‍್ಹಾವಾಳನಾಬಿ ದಿದೋನಿ” ಕರಿ ಜವಾಬ್‌ ದಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","ಅಜು಼ ಯೇಸುನೆ, “ಅದ್ಮಿನೊ ಛಿಯ್ಯೊ ಸಬ್ಬತ್‌ ದನ್ನ ಪ್ರಭು ಹುಯಿರ‍್ಹೋಸ್” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","ಬಿಜೇಕ್ ಸಬ್ಬತ್‌ ದನ್ನೆ ಯೇಸು ಸಬೆ ಭರಾವಾನು ಮಂದಿರ್‌ಮ ಜೈ಼ನ್, ವಚನ್ ಬೋಲಿ ದೆವ್‍ಕರ್ತೋಥೊ. ಖಾವೊ ಹಾತ್‌ ಝೂ಼ಟೊ ಪಡೆಹುಯೊ ಏಕ್‌ ಜ಼ಣೊ ಹಿಜ್ಜಾ಼ ಥೊ. ");
INSERT INTO vaa_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","ಮೋಶೇನು ಧರ್ಮಶಾಸ್ತ್ರ ಶಿಕಾಡವಾಳು ಶಾಸ್ತ್ರಿಯೆ ಅಜು಼ ಫರಿಸಾಯರ್‌ವಾಳು ಯೇಸುಪರ್ ಗಲ್ತಿ ಲಗಾಡನಖ್ಹಾಜೆ ಶಾತ್‌ತೋಬಿ ಮಳಾದೆ ಕರಿ, ಯೇಸು ಸಬ್ಬತ್ ದನ್ಮ ಅಛ್ಛು಼ ಕರಾಸ್ಕಿ ಶುಕಿ ಕರಿ ಜ಼ಪೀನ್ ದೇಖುಕರ್ತುಥು. ");
INSERT INTO vaa_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","ಕತೋಬಿ ಯೇಸುನೆ ಇವ್ಣಿ ಸೋಚ್ನ ಮಾಲುಮ್ ಕರಿಲೀನ್, ಹಾತ್‌ ಝೂ಼ಟೊ ಪಡ್ಯೊಹುಯೊ ಯೋ ಅದ್ಮಿನ, “ಉಠೀನ್, ಇಚ಼್‌ಮ ಐನ್ ಭೀರೆ” ಕರಿ ಬೋಲ್ಯೊ. ಯೋ ಅದ್ಮಿ ಉಠೀನ್ ಹಿಜ್ಜಾ಼ ಭೀರಿಗಯು. ");
INSERT INTO vaa_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","ತದೆ ಯೇಸುನೆ ಇವ್ಣುನ, “ತುಮುನ ಏಕ್‌ ವಾತ್ ಪುಛಾ಼ವ್‍ಸ್: ಸಬ್ಬತ್‌ ದನ್ಮ ಖೆವು ಕರ್ನುಕರಿ ಅಪ್ಣಿ ಖಾನುಲ್‌ಮ ಛಾ಼? ಅಛ್ಛು಼ಕರಾನುಕಿ ಖರಾಬ್‌ಕರಾನು? ಜಾನ್‌ ಬಚಾ಼ಡಾನುಕಿ, ಜಾನ್‌ ಕಾಡಾನು? ");
INSERT INTO vaa_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","ಅಜು಼ ಯೇಸುನೆ ಅಶ್‌ಪಿಶ್‍ ಥೂತೆ ಖ್ಹಾರಾವ್‌ನ ದೇಖಿನ್ ಯೋ ಅದ್ಮಿನ, “ತಾರೊ ಹಾತ್‌ ಖ್ಹಾಮ್ಣೆ ಕರ್‌” ಕರಿ ಬೋಲ್ಯೊ. ಇನೆ ಇಮ್ಮಸ್ ಕರ‍್ಯೊ, ತದೆ ಇನೊ ಹಾತ್‌ ಅಛ್ಛು಼ಹುಯಿಗಯು. ");
INSERT INTO vaa_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","ಕತೋಬಿ ಪರಿಸಾಯರ್‌ಬಿ ಮೋಶೇನು ಧರ್ಮಶಾಸ್ತ್ರ ಶಿಕಾಡವಾಳು ಶಾಸ್ತ್ರಿಯೆ ಖೀಜ಼್ ಖೈನ್, “ಆ ಯೇಸುನ ಅಪ್ಣೆ ಶಾತ್‌ ಕರಿಯೆ?” ಕರಿ ಇವ್ಣ-ಇವ್ಣಾಮ ವಾತೆ ಬೋಲಾಲಗ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","ಬಾದ್‌ಮ ಏಕ್‌ ದನ್ನೆ ಯೇಸು ಪ್ರಾರ್ಥನೆ ಕರಾನಖ್ಹಾಜೆ ಪಹಡ್‌ಪರ್ ಜೈ಼ನ್, ಹಿಡಿ ರಾತ್‌ ಯೋ ದೇವ್ನ ಪ್ರಾರ್ಥನೆ ಕರಾಮಸ್ ಕಾಡ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","ವ್ಹಾಣು ಹುವಾನ ಬಾದ್‌ಮ, ಇನ ಶಿಷ್ಯರ್‌ನ ಖನ್ನೆ ಬುಲೈನ್, ಇವ್ಣಾಮ ಭಾರ ಜ಼ಣಾನ ಚೂ಼ಣಿನ್ ಇವ್ಣುನ ಅಪೊಸ್ತಲರ್’ ಕರಿ ನಾಮ್ ಮ್ಹೇಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","ಇವ್ಣೆ ಕೋಣ್-ಕೋಣ್‌ಕತೊ, ಯೇಸುನೆ ಪೇತ್ರ ಕರಿ ನಾಮ್ ಮ್ಹೇಲ್ಯೋತೆ ಸೀಮೋನ, ಇನೊ ನ್ಹಾನೊ ಭೈ ಅಂದ್ರೆಯ, ಯಾಕೋಬ ಅಜು಼ ಯೋಹಾನ, ಫಿಲಿಪ್ಪ, ಬಾರ್ತೊಲೊಮಾಯ, ");
INSERT INTO vaa_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","ಮತ್ತಾಯ, ತೋಮ, ಅಲ್ಫಾಯನೊ ಛಿಯ್ಯೊ ಯಾಕೋಬ, ಅಜು಼ ಸೀಮೋನ (ದೇಖ್ಹ್‌ನಪ್ಯಾರ್ ಕರಾವಾಳೊ ಕರಿ ಬೋಲೈಲಿದೋತೆ), ");
INSERT INTO vaa_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","ಯಾಕೋಬನೊ ಛಿಯ್ಯೊ ಯೂದ, ಯೇಸುನ ಧೋಕೇಥಿ ಧರಿದ್ಯಾವಾಳೊ ಇಸ್ಕರಿಯೋತ ಯೂದ ಅವ್ಣೇಸ್. ");
INSERT INTO vaa_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","ಅನ ಬಾದ್‌ಮ ಯೇಸುನೆ ಇನ ಅಪೊಸ್ತಲರ‍್ನ ಜೋ಼ಡೆ ಪಹಾಡ್ ಉತ್ರಿ ಹೇಟ್‌ ಆಯಿನ್, ಇನ ಬಿಜಾ಼ಖ್ಹಾರ ಶಿಷ್ಯರ್‌ನಿ ಮೋಟಿ ಝೂ಼ಂಡ್‌ನ ಜೋ಼ಡೆ ಶದ್ದರ್ ಜ಼ಮೀನ್‌ಪರ್ ಭೀರಿಗಯೊ. ಯೂದಾಯ ತಬರ್‌ಖಾಥು, ಯೆರೂಸಲೇಮ್‌ ಖ್ಹಯೇರ್‌ಭಣಿಥುಬಿ, ದರ‍್ಯಾವ್‍ನ ಖನ್ನೆ ಛಾ಼ತೆ ತೂರ್ ಅಜು಼ ಸೀದೋನ್ ಖ್ಹಯೇರ್‌ಥು ಆಯುಹುಯು ಅದ್ಮಿನಿ ಮೋಟಿ ಭೀಡ್ ಹಿಜ್ಜಾ಼ ಥೂ. ");
INSERT INTO vaa_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","ಯೇಸು ಬೋಲಾತೆ ವಚನ್ನ ಖ್ಹಮ್‌ಜಾ಼ನ, ಅಜು಼ ರೋಗ್‌-ರಾಯೊ ಅಛ್ಛು಼ ಕರೈಲ್ಯವಾನಟೇಕೆ ಯೋ ಅದ್ಮಿಖ್ಹಾರು ಐರ‍್ಹುಥು. ಭೂತ್‌ ಧರಿರಾಖ್ಯುಹುಯು ಅದ್ಮಿ ಖ್ಹಾರುಬಿ ಆಯು, ಇವ್ಣಾಮಬಿ ಅಛ್ಛು಼ ಹುಯು. ");
INSERT INTO vaa_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","ಅದ್ಮಿಖ್ಹಾರು ಯೇಸುನ ಛೀಮ್‌ಣು ಕರಿ ಕರ‍್ಯು, ಶನಕತೊ ಇನಾಮಾಥಿ ಶಕತ್‍ ನಿಕ್ಳಿನ್ ಖ್ಹಾರಾವ್‌ನ ಅಛ್ಛು಼ ಕರುಕರ್ತುಥು. ");
INSERT INTO vaa_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","ಯೇಸುನೆ ಇನ ಶಿಷ್ಯರ್‌ ಭಣಿ ದೇಖಿನ್ ಬೋಲ್ಯೋಕಿ, “ಗರೀಬ್ ಹುಯಿರ‍್ಹವಾಳ ತುಮೆ ಖ್ಹುಶಾಲಿವಾಳು ಹುಯಿರ‍್ಹುಸ್, ದೇವ್‌ನು ರಾಜ್ಯ ತುಮಾರುಸ್! ");
INSERT INTO vaa_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","ಭುಕ್ಯ ಛಾ಼ತೆ ತುಮೆ ಧನ್ಯ ಹುಯಿರ‍್ಹಾಸ್; ತುಮಾರು ಪೇಟ್ ಭರಾವ್‌ಶೆ! ಹಮ್ಕೆ ರೊವವಾಳ ತುಮೆ ಧನ್ಯ ಹುಯಿರ‍್ಹುಸ್; ತುಮೆ ಹಾಖ್ಹ್‌ಶು! ");
INSERT INTO vaa_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","ಅದ್ಮಿನ ಛಿಯ್ಯಾನ ಖ್ಹಾಜೇಥಿ ಅದ್ಮಿಖ್ಹಾರು ತುಮೂನ ಖ್ಹರಮ್‌ ಕಾಡಿನ್, ದಾವೊ ಕರೀನ್, ಭಾರ್ ಕಾಡಿನಾಖಿನ್, ತುಮಾರು ನಾಮ್ ಬೋಲಾನುಬಿ ಖರಾಬ್‌ಕರಿ ಝಿಟ್ಕಾರ‍್ಯುತೊ, ತುಮೆ ಧನ್ಯ ಹುಯಿರ‍್ಹಾಸ್. ");
INSERT INTO vaa_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","ಅಮ್ ಖ್ಹಾರು ಹುಯೂತೊ ಖ್ಹುಶಿಥಿ ಖೇಲ್‌ಕೂದ್ ಕರೊ, ಶನಕತೊ ಸೊರ್ಗಾಮ ತುಮೂನ ಘಣು ಇನಾಮ್ ಮಳ್‌ಶೆ. ಆ ಅದ್ಮಿನು ಗುರುಗುರಬ್‍ಲ್ಯಬಿ ಪ್ರವಾದಿನ ಖ್ಹಾರು ಅಮ್ಮಸ್ ಕರ‍್ಯುನಿ. ");
INSERT INTO vaa_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","ಕತೋಬಿ ಹಮ್ಕೆ ಶೌಕಾರ್ ರ‍್ಹವಾಳ ತುಮಾರಿ ಹಾಲ್ನ ಶಾತ್‌ ಬೋಲು! ತುಮೆ ಅರಾಮ್‍ನಿ ಜಿ಼ಂದ್‌ಗಿ ಚ಼ಲೈಲಿದ! ");
INSERT INTO vaa_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","ಹಮ್ಕೆ ಪೇಟ್ ಭರೈರ‍್ಹುತೆ ತುಮಾರಿ ಹಾಲ್ನ ಶಾತ್‌ ಬೋಲು! ತುಮೆ ಭುಕ್ಯು ರ‍್ಹಿಶು! ಹಮ್ಕೆ ಹಾಖ್ಹವಾಳ ತುಮಾರಿ ಹಾಲ್ನ ಶಾತ್‌ ಬೋಲು; ತುಮೆ ಕುರ್‌ಲ್ಹಾವ್‌ಶು ಅಜು಼ ರೊವ್‌ಶು! ");
INSERT INTO vaa_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","ಅದ್ಮಿಖ್ಹಾರು ತುಮೂನ ಖ್ಹರಾಯೂತೊ, ತುಮಾರಿ ಹಾಲ್ನ ಶಾತ್‌ ಬೋಲು! ಇವ್ಣ ಗುರುಗುರಬ್‍ಲ್ಯನೇಬಿ ಝೂ಼ಟಪ್ರವಾದಿ ಖ್ಹಾರಾನ ಇಮ್ಮಸ್ ಖ್ಹರಾಯು. ");
INSERT INTO vaa_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“ಕತೋಬಿ ಮಾರಿ ವಾತೇನ ಖ್ಹಮ್‌ಜಾ಼ವಾಳಾನ ಮೇ ಶಾತ್‌ ಬೊಲುಸ್‌ಕತೊ, ತುಮಾರ ದುಶ್‌ಮನ್ನ ಪ್ಯಾರ್ ಕರೊ, ತುಮಾರಪರ್ ದಾವೊ ಕರಾವಾಳಾನ ಅಛ್ಛು಼ಕರೊ. ");
INSERT INTO vaa_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","ತುಮಾರಪರ್ ಶಾಪ್ನ-ಶಬರ್ ದ್ಯವಾಳಾನ ಆಶೀರ್ವಾದ್‌ ಕರೊ, ತುಮಾರಪರ್ ಶಬರ್‌ ದ್ಯವಾಳನಖ್ಹಾಜೆ ಪ್ರಾರ್ಥನೆ ಕರೊ. ");
INSERT INTO vaa_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","ಕೋಣ್‌ತೋಬಿ ಏಕ್‌ಜ಼ಣು ತಾರ ಕಲ್ಲಪರ್ ಮಾರ‍್ಯುತೊ, ಇನ ಬಿಜೇಕ್ ಕಲ್ಲು ವತಾಳೊ. ತಾರು ಉಪ್ಪರ್‌ಲ್ಯು ಝ಼ಗ್ಗಾನ ಖೇಚಿ ಲ್ಯಾವಳಾನ ಮಹಿನು ಕುಡ್‌ತಾನಾಬಿ ದಿನಾಕ್. ");
INSERT INTO vaa_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","ತಾರಕನ ಕೋಣ್‌ತೋಬಿ ಶಾತ್ತೋಬಿ ಮಾಂಗ್ಯುತೊ, ಇನ ದೇ, ತಾರು ಶೊತ್ ಛಿನೈಲ್ಯವಾಳಾನ, ಪಾಛು಼ ದೇ ಕರಿ ನಕೊ ಬೋಲ್. ");
INSERT INTO vaa_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","ಅದ್ಮಿಖ್ಹಾರು ತುಮೂನ ಶಶ್ಯಾತ್‌ ಕರ‍್ನುಕರಿ ತುಮೆ ಆಖ್ಹ್ ಕರೋಸ್ಕಿ, ಯೋಸ್‌ ತುಮೆ ಇವ್ಣುನ ಕರೊ. ");
INSERT INTO vaa_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","ತುಮೂನ ಪ್ಯಾರ್ ಕರಾವಾಳನಾಸ್‌ ತುಮೆ ಪ್ಯಾರ್ ವತಾಳ್ಯಾತೊ, ತುಮೂನ ಶಾತ್‌ ಖ್ಹರಾವ್ಣಿ ಮಳ್‌ಶೆ? ಪಾಪಿ ಅದ್ಮಿ ಖ್ಹಾರುಬಿ ಇವ್ಣುನ ಕೋಣ್ ಲಾಡ್‌ಪ್ರೀತ್‌ ಒತಾಳಸ್ಕಿ ಇವ್ಣುನಾಸ್ ಲಾಡ್‌ಪ್ರೀತ್‌ ಕರಾಸ್ನಿ. ");
INSERT INTO vaa_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","ತುಮೂನ ಅಛ್ಛು಼ಕರಾವಾಳನಾಸ್‌ ತುಮೆ ಅಛ್ಛು಼ಕರ‍್ಯಾತೊ, ತುಮೂನ ಶಾತ್‌ ಖ್ಹರಾವ್ಣಿ ಮಳ್‌ಶೆ? ಪಾಪಿ ಅದ್ಮಿ ಖ್ಹಾರುಬಿ ಇಮ್ಮಸ್ ಕರಾಸ್ನಿ. ");
INSERT INTO vaa_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","ತುಮೂನ ಕೋಣ್ ಉಧಾರ್ ಫೇಡಸ್ಕಿ, ಇವ್ಣುನಾಸ್ ಉಧಾರ್ ದಿದಾತೊ, ತುಮೂನ ಶಾತ್‌ ಖ್ಹರಾವ್ಣಿ ಮಳ್‌ಶೆ? ಪಾಪಿ ಅದ್ಮಿ ಖ್ಹಾರುಬಿ ಇವ್ಣೆ ದಿದೂತೆ ಎತ್ರು ಇವ್ಣುನ ಪಾಛು಼ ಮಳ್‌ಶೆ ಕರಿ ಪಾಪಿ ಅದ್ಮಿ ಖ್ಹಾರಾನ ಉಧಾರ್ ದೇಸ್‌ನಿ. ");
INSERT INTO vaa_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","ಇನಖ್ಹಾಜೆ, ತುಮಾರ ದುಶ್‌ಮನ್ನ ಲಾಡ್‍ಪ್ರೀತ್ ಕರೊ ಅಜು಼ ಇವ್ಣುನ ಅಛ್ಛು಼ಕರೊ. ತುಮೆ ಇವ್ಣುನ ಉಧಾರ್ ದ್ಯವಾನಿ ವಖ್ಹತ್‌ಮ, ಫಾಛು಼ ಇವ್ಣೇಥಿ ಮಳ್‌ಶೆ ಕರಿ ಬೋಲಾನಿ ಆಖ್ಹ್‌ನ ಮ್ಹೆಂದಿನ್, ಉಧಾರ್ ದೆವೊ. ತದೆ ತುಮುನ ಘಣು ಇನಾಮ್ ಮಳ್‍ಶೆ ಅಜು಼ ತುಮೆ ಪರಮಂಡಲ್‌ನೊ ದೇವ್ನ ಲಡ್ಕಾಉಶು. ಯೋತೊ ಕರ್ಮಿಷ್ಟಿನಾಬಿ, ಖರಾಬ್‌ನಾಬಿ ಅಛ್ಛೊ಼ ಹುಯಿರ‍್ಹೋಸ್. ");
INSERT INTO vaa_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","ಪರ್‌ಲೋಕ್‌ನೊ ತುಮಾರೊ ಬಾ ಗೋರ್‌ಕರಾವಾಳೊ ಹುಯಿರ‍್ಹೋತೆ ಇಮ್ಮಸ್, ತುಮೇಬಿ ಗೋರ್‌ ಕರಾವಾಳೊ ಹುಯಿರ‍್ಹೇವೊ. ");
INSERT INTO vaa_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“ಕಿನಿ ಬಾರೇಮಾಬಿ ತೀರ್ಪ್‌ ನಕೊ ಕರೊ, ತದೆ ದೇವ್‌ಬಿ ತುಮೂನ ತೀರ್ಪ್ ಕರ್ಶೆ ಕೊಯ್ನಿ; ಕಿನಾಪರ್‌ಬಿ ಗಲತ್‌ ನಕೊ ಲಗಾಡೊ, ತದೆ ದೇವ್‌ಬಿ ತುಮಾರಪರ್ ಗಲತ್‌ ಕೋ ಲಗಾಡ್‌ಶೇನಿ. ಬಿಜಾ಼ನ ಮಾಪ್‌ ಕರೊ, ತದೆ ದೇವ್‌ಬಿ ತುಮುನ ಮಾಪ್‌ ಕರ್ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","ಬಿಜಾ಼ನ ದೆವೊ, ತದೆ ದೇವ್‌ಬಿ ತುಮೂನ ದಿಶೆ. ದಾಬಿ ಹಲೈನ್, ಭಾರ್‌ ರಂಚಾ಼ವಖ್ಹರ್‌ಕು ಮಾಪಿನ್‌, ತುಮಾರಿ ಝೋ಼ಳಿಮ ನಾಕ್‌ಶೆ, ತುಮೆ ಬಿಜಾ಼ನ ಕಿಮ್ ಮಾಪಿನ್ ದೇಸ್ಕಿ, ಇಮ್ಮಸ್ ದೇವ್‌ಬಿ ತುಮೂನ ಮಾಪ್‌ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","ಅಜು಼ ಯೇಸುನೆ ಇವ್ಣುನ ಏಕ್‌ ಮತ್ಲಬ್‌ನಿ ಖೇಣಿನ ಬೋಲ್ಯೊ: ಯೋ ಶಾತ್‌ಕತೊ, “ಕಾಣೊ ಕಾಣಾನ ವಾಟ್‌ ವತಾಳನ ಕೋ ಹುವಾನಿ; ಇಮ್‌ ಕರ‍್ಯೂತೊ, ಭೇ ಜ಼ಣ ಖಾಡ್‌ಮ ಪಡಿಜಾ಼ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","ಶಿಷ್ಯ ಇನ ಗುರುಥಿ ಮೋಟೊ ಕಾಹೆ, ಕತೋಬಿ ಶಿಷ್ಯ ತಮಾಮ್‌ ಶಿಕಾನ ಬಾದ್‌ಮ, ಇನ ಗುರುನಿಮತ್‌ ಹುಯಿಜಾ಼ಸ್. ");
INSERT INTO vaa_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","ತಾರ ಡೋಳಾಮ ಛಾ಼ತೆ ಪೇದಡ್‌ನಿ ಬಾರೇಮ ಸೋಚ್ಯೊಕೊಂತೆ, ತಾರ ಭೈನ ಡೋಳಾಮ ಛಾ಼ತೆ ಕಾಕ್ರಿನಿ ಬಾರೇಮ ಶನ ಸೋಚಸ್ತೆ? ");
INSERT INTO vaa_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","ತಾರ ಡೋಳಾಮ ಛಾ಼ತೆ ಪೇದಡಸ್‌ ತುನ ದೆಖಾವ ಕೊಯ್ನಿನಿ. ಅಮ್ ರ‍್ಹಾವಪರ್, ತೂ ತಾರ ಭೈನ, ‘ಭೈ ತಾರ ಡೋಳಾಮ ಛಾ಼ತೆ ಕಾಕ್ರಿನ ಕಾಡುಸ್‌ ಆವ್’ ಕರಿ ಕಿಮ್ ಬೋಲಾಸ್? ಅಲ ಠಗಾರು ಪಹಿಲೆ ತಾರ ಡೋಳಾಮಾನು ಪೇದಡ್‌ನ ಕಾಡ್, ಬಾದ್‌ಮ ತಾರ ಭೈನ ಡೋಳಾಮಾನು ಕಾಕ್ರಿನ ಕಾಡಾನ ತುನ ಅಛ್ಛಿನಿತರ ದೆಖಾವ್‌ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","ಅಛ್ಛು಼ ಝಾ಼ಡು ಖರಾಬ್ ಪಂಡು ದೇಯಿಕೊಯ್ನಿ, ಇಮ್ಮಸ್ ಖರಾಬ್ ಝಾ಼ಡು ಅಛ್ಛು಼ ಪಂಡು ದೇಯಿಕೊಯ್ನಿ. ");
INSERT INTO vaa_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","ಹರೇಕ್ ಝಾ಼ಡು ಕಿಮ್ನು ಕರಿ ಬೋಲಾನು ಯೋ ಮ್ಹೇಲಾತೆ ಪಂಡಾಥೀಸ್‌ ಮಾಲುಮ್‌ ಪಡಾಸ್‌. ತುಮೆ ಕಾಟಾನಿಡಾಗ್‍ಮ ಅಂಜೀರ್‌ನು ಪಂಡು ತೋಡಾಕೊಯ್ನಿ ನತರ್‌ಕಿ ಕಾಟಾನಿ ಡಾಗೇಮ ದ್ರಾಕ್ಷಿನು ಪಂಡಾವ್‍ನ ಎಕ್ಟು ಕರಾಕೊಯ್ನಿ. ");
INSERT INTO vaa_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","ಅಛ್ಛು಼ ಅದ್ಮಿ ಇನ ಮನ್‌ಮ ಜ಼ಮಕರಿರಾಖ್ಯೂತೆ ಅಛ್ಛಿ ಕಣ್ಗಿಮಾಥು ಅಛ್ಛಾ಼ನ ಭಾರ್‌ ಕಾಡಸ್‌; ಕತೋಬಿ ಖರಾಬ್ ಅದ್ಮಿ ಇನ ಮನ್‌ಮ ಜ಼ಮಕರಿರಾಖ್ಯೂತೆ ಖರಾಬ್ ಕಣ್ಗಿಮಾಥು ಖರಾಬ್‌ನ ಭಾರ್ ಕಾಡಸ್‌. ಮನ್‌ಮ ಶಾತ್‌ ಛಾ಼ಕಿ ಯೋಸ್‌ ಮ್ಹೋಡವಾಟೆ ನಿಕ್ಳಸ್‌.‌ ");
INSERT INTO vaa_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“ತುಮೆ ಮನ, ‘ಪ್ರಭು, ಪ್ರಭು’ ಕರಿ ಚಿಕ್ರೀನ್‌ಬಿ, ಮೇ ಬೋಲುಸ್ತೆ ಇಮ್‌ ಶನ ಕೋ ಕರಾಂತೆ? ");
INSERT INTO vaa_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","ಕೋಣ್ ಮಾರಕನ ಆಯಿನ್, ಮಾರಿ ವಾತೇನ ಖ್ಹಮ್‌ಜಿನ್‌, ಅನೀನಿಘೋಣಿ ಚಾ಼ಲವಾಳು, ಯೋ ಕಿಮ್ನೊ ಹುಯಿರ‍್ಹಿಶೆ ಕರಿ ತುಮೂನ ವತಾಳುಸ್‌. ");
INSERT INTO vaa_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","ಯೋ ಅಛ್ಛಿನಿತರ ಖೋಂದೈನ್, ಬಂಡಾಪರ್ ಹದಿ ನಖೈನ್, ಘರ್ ಭಾಂದಾಸ್ತೆ ಅದ್ಮಿನಿಘೋಣಿ ಹುಯಿರ‍್ಹೊಸ್. ನದ್ದಿ ಭರೈನ್, ತೋಫಾನ್ ಯೋ ಘರ್‌ನ ಮಾರ್‌ಪಡ್ಯುತೋಬಿ, ಯೋ ಘರ್‌ನ ಹಲಾವಾನ ಇನ ಕೋಹುಯುನಿ. ಶನಕತೊ ಇನ ಬಂಡಾಪರ್ ಭಾಂದಿರಾಖ್ಯುಥು. ");
INSERT INTO vaa_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","ಕತೋಬಿ ಮಾರಿ ವಾತೇನ ಖ್ಹಮ್‌ಜಿನ್‌ಬಿ, ಇನೀನಿಘೋಣಿ ಚಾ಼ಲಕೊಂತೆ ಅದ್ಮಿ ಹದಿಕೊಂತೆ ಜ಼ಮೀನ್‌ಪರ್ ಘರ್ ಭಾಂದಾವಾಳಾನಿ ಘೋಣಿ ಹುಯಿರ‍್ಹುಸ್. ತೋಫಾನ್‌ ಆಯಿನ್, ಯೋ ಘರ್‌ನ ಮಾರ್‌ಪಡ್‌ತಾನ, ಯೋ ಘರ್ ರಡ್ಕಿನ್, ಪೂರ ಬರ್ಬಾತ್ ಹುಯಿಗಯು. ");
INSERT INTO vaa_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","ಯೇಸುನೆ ಅದ್ಮಿನ ಆ ಖ್ಹಾರಿ ವಾತೆನ ಬೋಲಿನ್ ಖ್ಹಮ್‌ಜಾ಼ಡನ ಬಾದ್‌ಮ, ಯೇಸು ಕಪೆರ್ನೌಮ್‌ನ ಗಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","ಹಿಜ್ಜಾ಼ ಖ್ಹೋಶಿಪಾಯಿನೊ ಮೋಟಾನೊ, ಪ್ಯಾರ್‌ನೊ ಆಳ್‌ ಏಕ್‌ ಜ಼ಣೊ, ರೋಗ್‌ ಆಯಿನ್ ಮರಾನಿ ಹಾಲ್‌ಮ ಥೊ. ");
INSERT INTO vaa_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","ಯೋ ಖ್ಹೊ ಶಿಪಾಯಿನೊ ಮೋಟಾನೆ, ಯೇಸುನಿ ಬಾರೇಮ ಖ್ಹಮ್‌ಜಿನ್‌, ಯೆಹೂದ್ಯರ್‌ನ ಶಾಣವ್‍ಮ ಥೋಡ ಜ಼ಣಾನ ಇನಾಕನ ಮೋಕ್ಲಿನ್, ಇನ ಆಳ್‌ನ ಅಛ್ಛು಼ ಕರ‍್ನು ಕರಿ ಬೋಲಿಲಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","ಇವ್ಣೆ ಯೇಸುಕನ ಆಯಿನ್, “ತಾರೇಥಿ ಮದತ್ ಕರೈಲ್ಯವಾನ ಯೋ ಅದ್ಮಿ ಲ್ಹಾಯಕ್‌ ಹುಯಿರ‍್ಹುಸ್‍. ");
INSERT INTO vaa_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","ಯೋ ಅಪ್ಣ ಅದ್ಮಿನ ಪ್ಯಾರ್ ಕರಾವಾಳೊ ಹುಯಿರ‍್ಹೋಸ್ ಅಜು಼ ಇನೇಸ್‌ ಅಪ್ಣಖ್ಹಾಜೆ ಸಬೆ ಭರಾವನು ಮಂದಿರ್‌ನ ಭಂದೈದಿದೊತೆ” ಕರಿ ಬೋಲಿನ್ ಯೇಸುನ ಗಿಂಗಾವಲಗಾಖ್ಹತರ್‌, ");
INSERT INTO vaa_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","ಯೇಸು ಇವ್ಣ ಜೋ಼ಡೆ ಗಯೊ. ಯೇಸು ಘರ್‌ಕನ ಆಯಿನ್ ಪೋಚಾ಼ನ ಜ಼ರ ದೂರ್ ಥೋತೆ ತದ್ದೇಸ್, ಯೋ ಖ್ಹೋಶಿಪಾಯಿನೊ ಮೋಟಾನೆ ಇನ ದೋಸ್ತ್ ಖ್ಹಾರಾವ್‌ನ ಯೇಸುಕನ ಬೋಲಿ ಮೋಕ್ಲಿನ್, “ಪ್ರಭು, ತೂ ಖ್ಹತ್‌ನಕೊ, ತೂ ಮಾರ ಘರ್‌ಕನ ಆವಾಯೆತ್ರೆ ಲ್ಹಾಯೇಕ್‌ ಮಾರಮ ಕೊಯ್ನಿ. ");
INSERT INTO vaa_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","ಅತ್ರೇಸ್ ಕಾಹೆತೆ ತಾರಕನ ಆವಾನಾಬಿ ಮೇ ಲ್ಹಾಯೇಕ್‌ನೊ ಕಾಹೆ. ಕತೋಬಿ ತೂ ಖಲಿ ಏಕ್‌ ವಾತೆ ಬೋಲ್ಯೋತೊ ಬಶ್‌ ಮಾರ ಸೇವಕ್‌ನ ಅಛ್ಛು಼ ಉಶೆ. ");
INSERT INTO vaa_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","ಮೇಬಿ ಬೀಜಾ಼ನ ಹಾತ್‍ಹೇಟ್ ಕಾಮ್ ಕರಾವಾಳೊ ಹುಯಿರ‍್ಹೋಸ್. ಮಾರ ಹಾತ್‌ಹೇಟ್ ಸಿಪಾಯಿಖ್ಹಾರು ಛಾ಼. ಮೇ ಇವ್ಣಾಮ ಏಕ್‌ ಜ಼ಣಾನ ಜಾ಼ ಕರಿ ಬೋಲ್ಯೊತೊ ಯೋ ಜಾ಼ಸ್‌, ಬಿಜ್ಜೇಕ್‌ ಜ಼ಣಾನ ಆವ್ಣುಕರಿ ಬೋಲ್ಯೋತೊ ಆವಸ್. ಮಾರ ಆಳ್‌ನ ಅಮ್ನು-ಅಮ್ನು ಕಾಮ್ ಕರ್‌ ಕರಿ ಬೋಲ್ಯೋತೊ ಯೋ ಕರಸ್” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","ಆ ವಾತೆನ ಖ್ಹಮ್‌ಜಿನ್‌ ಯೇಸುನೆ ಇನಿ ಬಾರೇಮ ಆಶ್ಚರ್ಯಖೈನ್, ಇನ ಪೀಠೆ ವಳ್ಯಾವ್‌ತುಥೂತೆ ಝೂ಼ಂಡ್‌ಣ ಫರಿ ದೇಖಿನ್‌, “ಮೇ ತುಮೂನ ಬೋಲುಸ್ಕಿ, ಮೇ ಅತ್ರೆ ಮೋಟಿ ವಿಶ್ವಾಸ್‌ನ ಇಸ್ರಾಯೇಲ್‌ ಆದ್ಮಿಮಾಬಿ ಕೋ ದೇಖ್ಯೋನಿ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","ಅನ ಬಾದ್‌ಮ ಯೋ ಟಪಾಲ್ ದ್ಯವಾಳು ಪಾಛು಼ ಫರಿ ಯೋ ಅದಿಕಾರಿನ ಘರ್‌ಕನ ಜೈ಼ನ್‌, ಯೋ ಆಳ್‌ನ ಅಛ್ಛು಼ ಹುಯಿರ‍್ಹುಥೂತೆ ದೇಖ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","ಅನ ಬಾದ್‌ಮ ಯೇಸು ನಾಯಿನ್ ಕರಿ ಏಕ್‌ ಗಾಮ್‌ನ ಗಯೊ. ಇನ ಜೋ಼ಡ್ಮ ಇನು ಶಿಷ್ಯರ್‌ ಅಜು಼ ಅದ್ಮಿನಿ ಮೋಟಿ ಝೂ಼ಂಡ್‌ಬಿ ಥೂ. ");
INSERT INTO vaa_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","ಯೇಸು ಗಾಮ್‌ನ ಮಹಿ ಜಾ಼ವಾನು ದರ‍್ವಾಜ಼ಕನ ಆವಾದಿನ್, ಮರಿಗಯೂತೆ ಏಕ್‌ ಮುರ್ದಾನ ಗಾಮ್‌ಥಿ ಭಾರ್ ಪಳ್ಳಿನ್‌ ಉಳ್ಯಾವ್ತೂಥು. ಯೋ ಮರಿಗಯೂತೆ ಅದ್ಮಿ ಇನಿ ಆಯಾನ ಏಕ್‍ನೊ ಏಕ್‌ ಛಿಯ್ಯೊ ಹುಯಿರ‍್ಹೋಥೊ. ಇನಿ ಆಯ ಮುಂಡಚ್ಚಿ ಹುಯಿರ‍್ಹೀಥಿ, ಯೋ ಗಾಮ್‌ನು ಅದ್ಮಿನಿ ಮೋಟಿ ಝೂ಼ಂಡಸ್ ಯೋ ತಯೇಡ ಕೇಡೆ ಥು. ");
INSERT INTO vaa_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","ಪ್ರಭುನೆ ಯೋ ತಯೇಡಾನ ದೇಖಿ ಗೋರ್‌ಖೈನ್, “ರೋವ್‌ ನಕೊ” ಕರಿ ಇನ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","ಅಜು಼ ಖಾಟ್ಲಾಕನ ಜೈ಼ನ್, ಇನ ಛೀಮ್‌ತಖ್ಹತರ್‌, ಪಳ್ಳಿನ್‌ ಜಾ಼ವವಾಳು ಭೀರಿಗಯು. ತದೆ ಯೇಸುನೆ, “ಜಾ಼ನ್ಜ಼ಮಾನ್ ಛೋ಼ಕ್ರಾ ಉಟ್, ಕರಿ ಮೇ ತುನ ಬೋಲುಸ್!” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","ತದೆ ಯೋ ಮರಿಗಯುಥೂತೆ, ಯೋ ಛೋ಼ಕ್ರು ಉಠಿ ಬೇಶಿನ್, ವಾತೆ ಬೋಲಾಲಗ್ಯು, ತದೆ ಯೇಸುನೆ ಯೋ ಛೋ಼ಕ್ರಾನ ಇನಿ ಆಯಾನ ದಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","ಅನ ದೇಖಿನ್, ಹಿಜ್ಜಾ಼ ಥೂತೆ ತಮಾಮ್‌ ಅದ್ಮಿ ಡರಿನ್, ದೇವ್ನ ಸ್ತುತಿ ಕರ್ತುಹುಯಿನ್, “ಏಕ್‌ ಮಹಾನ್ ಪ್ರವಾದಿ ಅಪ್ಣಕನ ಐರ‍್ಹೋಸ್! ದೇವ್ ಇನ ಅದ್ಮಿನ ಬಚಾ಼ಡಾನ ಐರ‍್ಹೋಸ್” ಕರಿ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","ಯೇಸುನಿ ಬಾರೇಮಾನಿ ಆ ಖಬರ್‌, ಯೂದಾಯ ದೇಖ್ಹ್‌ಮ ಅಜು಼ ಇನ ಅಶ್‌ಪಿಶ್‌ನು ತಮಾಮ್‌ ಮುಲಕ್‌ಮ ಫೈಲಿಗಯು ");
INSERT INTO vaa_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","ಯೋಹಾನನು ಶಿಷ್ಯರ್‌ ಚಾ಼ಲ್ಯುತೆ ಖ್ಹಾರಿ ಬಾರೇಮ ಯೋಹಾನ್ನ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","ತದೆ ಯೋಹಾನನೆ ಇನ ಶಿಷ್ಯರ್‌ಮ ಬೇ ಜ಼ಣಾನ ಬುಲೈನ್, “ತೂಸ್‌ಕಿ ಶು ಯೋ ಆವ್‌ಶೇತೆ ಅದ್ಮಿಕಿ? ನಾತೊ ಹಮೆ ಬಿಜೇಕ್‌ನಖ್ಹಾಜೆ ಟಿವಾವ್‌ಣು” ಕರಿ ಪುಛಾ಼ವಾನಖ್ಹಾಜೆ, ಇವ್ಣುನ ಮಾಲಿಕ್‍ಕನ ಮೋಕ್‌ಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","ಇವ್ಣೆ ಯೇಸುಕನ ಆಯಿನ್, “ತೂಸ್‌ಕಿ ಶು ಯೋ ಆವ್‌ಶೇತೆ ಅದ್ಮಿ? ಕೊಯಿನ್ತೊ ಹಮೆ ಬಿಜ್ಜೇಕ್‌ ಅದ್ಮಿನಖ್ಹಾಜೆ ಟಿವಾವ್‌ಣು? ಕರಿ ಫುಛಾ಼ವಾನಟೇಕೆ ಬ್ಯಾಪ್ತಿಸ್ಮದ್ಯವಾಳೊ ಯೋಹಾನನೆ ಹಮೂನ ತಾರಕನ ಮೋಕ್ಲಿರಾಖ್ಯೊಸ್” ಕರಿ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","ಯೋಸ್‌ ವಖ್ಹತ್‌ಮ, ಯೇಸುನೆ ಕೈಯೆಕ್ಕಿ ಅದ್ಮಿನು ರೋಗ್‌ರಾಯೊನ ಅಛ್ಛು಼ ಕರ‍್ಯೊ, ಅಜು಼ ಭೂತ್‌ ಧರಿರಾಖವಾಳನ ಛೋ಼ಡಾಯೊ. ಅತ್ರೇಸ್ ಕಾಹೆತೆ ಘಣ ಕಾಣ ಅದ್ಮಿನ ಡೋಳಾನ ಜೋ಼ತ್ ದಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","ಬಾದ್‌ಮ ಯೇಸುನೆ ಯೋಹಾನ್ನ ಶಿಷ್ಯರ್‌ನ, “ತುಮೆ ಹಜ಼್ಜಾ ದೇಖ್ಯಾತೆ ಅಜು಼ ಖ್ಹಮ್‍ಜ್ಯಾತೆ ಇನಿ ಬಾರೇಮ ಯೋಹಾನ್ನ ಜೈ಼ನ್ ಬೋಲೊ. ಕಾಣು ದೇಕ್‌ಶೆ, ಲಂಗ್ಡು ಚಾ಼ಲ್‌ಷೆ, ಖೋಡ್‍ ರ‍್ಹವಾಳು ಪಾಕ್‌ ಉಶೆ, ಭೈರು ಖ್ಹಮಜ಼್‌ಶೆ, ಮರಿಗಯುಹುಯು ಜಾನ್‌ ಲೀಲಿಶೆ ಅಜು಼ ಗರೀಬ್‌ನ ಸುವಾರ್ತೆ ಬೋಲವ್‍ಕರಸ್. ");
INSERT INTO vaa_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","ಮಾರಿ ಬಾರೇಮ ಶಕ್ ಕರಾಕೊಂತೆ ಇವ್ಣೇಸ್ ಧನ್ಯ ಹುಯಿರ‍್ಹುಸ್ ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","ಯೋಹಾನನು ಶಿಷ್ಯರ್‌ ಚ಼ಲ್ಯೂಜಾ಼ವಾದೀನ್, ಯೇಸುನೆ ಅದ್ಮಿನಿ ಝೂ಼ಂಡ್‌ನ ಯೋಹಾನ್ನಿ ಬಾರೇಮ ಬೋಲಾಲಗ್ಯೋಕಿ, “ಶಾತ್‌ ದೇಕ್ಣು ಕರಿ ತುಮೆ ಯೋಹಾನಕನ ಉಜ್ಜಾ಼ಡಿ ಝ಼ಗೋಮ ಗಯಾಥ? ವಹಿರಾಮ ಹಲಾಸ್ತೆ ಘಾಖ್ಹ್‌ನ ಡಂಟ್‍ನಾಕಿಶು? ");
INSERT INTO vaa_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","ನಾತೊ ತುಮೆ ಶಾತ್‌ ದೇಕ್ಣುಕರಿ ಗಯಾಥ? ಶನ್ಗಾರ್‌ನ ಲುಂಗ್ಡ ಪೇರ‍್ಹಿರಾಖಾಸ್ತೆ ಅದ್ಮಿನಾಕಿಶು? ಅಮ್ನು ಲುಂಗ್ಡು ಪೇರ‍್ಹಿನ್‌ ಅರಾಮ್‌ನಿ ಜಿ಼ಂದ್‌ಗಿ ಚ಼ಲಾವವಾಳು ಖ್ಹಾರು ಮಹೇಲ್‌ಮ ರ‍್ಹೇಸ್! ");
INSERT INTO vaa_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","ಇಮ್‍ಕತೊ ಮನ ಬೋಲೊ, ಶಾತ್‌ ದೇಕ್ಣು ಕರಿ ಬಹರ್ ಗಯಾಥ? ಪ್ರವಾದೀನಾಕಿ ಶು? ಒಹೊ ಖ್ಹಾಚಮಾಬಿ, ಮೇ ಬೋಲುಸ್ಕಿ ಏಕ್‌ ಪ್ರವಾದಿಥೀಬಿ ಮೋಟಾನ ತುಮೆ ದೇಖ್ಯ. ");
INSERT INTO vaa_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","‘ದೇವ್ನೆ ಹಂದೇಕ್‌, ಮಾರ ದೂತಾನ ತಾರ ಖ್ಹಾಮ್ಣೆ ಮೋಕ್ಲಿಶ್, ಯೋ ತೂ ಜಾ಼ವಾನಿ ವಾಟ್ನ ಖ್ಹೂದು ಕರ್ಶೆ’ ಕರಿ ಲೀಖೈರ‍್ಹೂಸ್ತೆ ಯೋ ಯೋಹಾನನಿಸ್ ಬಾರೇಮ ");
INSERT INTO vaa_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","ಮೇ ತುಮೂನ ಬೋಲುಸ್ಕಿ, “ಜ಼ಮೀನ್‌ಪರ್ ತಯೇಡಾನ ಪೇಟೆ ಪೈದಹುಯುತೆ ಹರೇಕ್ ಅದ್ಮಿಮ ಯೋಹಾನಸ್‌ ಮೋಟೊ. ಕತೋಬಿ ದೇವ್ನಿ ರಾಜ್ಯಮ ಅಖ್ಖೇಥಿ ನ್ಹಾನೊ ಜಿನ್‌ಕುಬಿ ಯೋಹಾನಥಿ ಮಹಾನ್ ಹುಯಿರ‍್ಹೋಸ್. ");
INSERT INTO vaa_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","ಯೋಹಾನ ಬೋಲ್ಯೋತೆ ಇಮ್‌ ತಮಾಮ್‌ ಅದ್ಮಿ ಅಜು಼ ಶುಂಕ ವಶೂಲ್ ಕರಾವಾಳುಬಿ ದೇವ್‌ನೊ ಮಾರಗ್ ಖ್ಹಾಚಕರಿ ಮಾನಿಲಿದು. ಇನಖ್ಹಾಜೆ ಇವ್ಣೆ ಖ್ಹಾರು ಯೊಹಾನ್ನ ಹಾತೇಥಿ ಬ್ಯಾಪ್ತಿಸ್ಮ ಕರೈಲಿದು. ");
INSERT INTO vaa_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","ಕತೋಬಿ ಫರಿಸಾಯರ್ ಅಜು಼ ಮೋಶೇನು ಧರ್ಮಶಾಸ್ತ್ರ ಶಿಕಾಡವಾಳು ಇವ್ಣಿ ಬಾರೇಮ ದೇವ್ನಿ ಮರ್ಜಿನ ಝಿಟ್ಕಾರಿನ್, ಯೋಹಾನ್ನ ಹಾತೇಖ್ಹು ಬ್ಯಾಪ್ತಿಸ್ಮ ಕೋ ಲಿದೂನಿ. ");
INSERT INTO vaa_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","ಅಜು಼ ಯೇಸುನೆ ಅಮ್ ರ‍್ಹವಾಪರ್, “ಆ ಹಗಾಮ್ನ ಅದ್ಮಿನ ಖಿವಿ ಪರಕ್ಮ ಬೋಲು? ಇವ್ಣೆ ಕಿಮ್ಕಿ ಘೋಣಿ ಛಾ಼? ");
INSERT INTO vaa_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","ಬಜಾ಼ರ್‌ಮ ಬೇಶಿನ್, ಹಮೆ ತುಮಾರಖ್ಹಾಜೆ ವಾಖ್ಹ್‌ಳಿ ವಜಾ಼ಡ್ಯ, ತುಮೆ ಖೇಲ್ಯಕೊಯ್ನಿ; ಹಮೆ ಅಂದ್ರೋಖ್ಹ್‌ನು ಗೀದ್‌ ಬೋಲ್ಯ, ಕತೋಬಿ ತುಮೇತೊ ರೋಯಾ ಕೊಯ್ನಿ” ಕರಿ ಬೋಲಾತೆ ಲಡ್ಕಾನಿಘೊಣಿ ಛಾ಼. ");
INSERT INTO vaa_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","ಕಿಮ್‌ಕತೊ, ಬ್ಯಾಪ್ತಿಸ್ಮದ್ಯವಾಳೊ ಯೋಹಾನ ಆಯೊ, ಯೋ ರೋಟೊ ಖಾತೋಥೊಕೊಯ್ನಿ ಅಜು಼ ದ್ರಾಕ್ಷಿನು ರಖ್ಹ್‌ ಪೀತೋಥೊಕೊಯ್ನಿ, ತುಮೆ ಇನ ಭೂತ್‌ ಧರಿರಾಖ್ಯುಸ್ ಕರಿ ಬೋಲೋಸ್. ");
INSERT INTO vaa_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","ಅದ್ಮಿನೊ ಛಿಯ್ಯೊ ಆಯೊ, ಯೋ ಖಾಣುಪಾಣಿ ಲ್ಯವಾಳೊ ಹುಯಿರೋಸ್. ‘ತುಮೆ ಬೋಲೊಸ್ಕಿ, ದೇಖೋಲೊ, ಆ ಅದ್ಮಿ ಖಾಣನು ಮರ್‌ತೇಲ್‌ ಅಜು಼ ಪೀಕುಡ್ಕ, ಪಾಪಿಬಿ ಖರಾಬ್ ಅದ್ಮಿನೊ ದೋಸ್ತಿ” ಕರಿ. ");
INSERT INTO vaa_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","ಕತೋಬಿ ದೇವ್ನಿ ಗ್ಯಾನ್‌ತೊ ಖ್ಹಾಚಸ್‌ಕರಿ, ಇನ ಮಾನಿಲ್ಯಾವಾಳಥೀಸ್ ಮಾಲುಮ್‌ಪಡಸ್” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","ಫರಿಸಾಯರ್‌ಮ ಏಕ್‌ ಜ಼ಣಾನೆ, ಯೇಸುನ ಖಾಣನ ಆವ್ಣುಕರಿ ಬೋಲಿಲಿದೊ. ಇನಾಖ್ಹಾಜೆ ಯೇಸು ಇನ ಘರೆ ಜೈ಼ನ್ ಖಾಣು ಖಾವಾನ ಬೇಶಿಗಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","ಯೋ ಗಾಮ್ಮ ಏಕ್‌ ಪಾಪೇಲಿ ತಯೇಡ ಥೀ. ಇನೆ ಯೇಸು ಯೋ ಫರಿಸಾಯರ್‌ನ ಘರ್‌ಮ ಛಾ಼ ಕರಿ ಮಾಲುಮ್‌ ಕರಿಲೀನ್, ಏಕ್‌ ಬಂಡಾನಿ ಶೀಶಿಮ ವಾನು ತೇಲ್ನ ಲೀನ್ ಹಿಜ್ಜಾ಼ ಆಯಿ. ");
INSERT INTO vaa_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","ಯೋ ಯೇಸುನ ಪೀಠೆ ಇನ ಗೋಡಾಕನ ಭೀರಿನ್, ರೊವ್‌ತಿಹುಯಿನ್, ಇನ ಗೋಡಾನ ಆಂಝೇ಼ಖ್ಹು ಭಿಜೈ಼ನ್, ಬಾದ್‌ಮ ಇನ ಮುಡ್‌ಕ್ಯಾನ ಕೇಖ್ಹ್‌ಥಿ ಯೇಸುನ ಗೋಡ ನೂಛಿ ಅಜು಼ ಇನ ಗೋಡಾನ ಬುಚ್ಚಾ಼ ದೀನ್, ಯೋ ವಾನು ತೇಲ್ನ ಇನ ಗೋಡಾಪರ್ ನಾಖಿ. ");
INSERT INTO vaa_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","ಯೇಸುನ ಖಾಣನ ಬುಲಾಯೊಥೋತೆ ಫರಿಸಾಯರ್‌ನೆ ಅನ ದೇಖಿನ್, “ಆ ಪ್ರವಾದಿಸ್ ರ‍್ಹಯೊಹೋತ್ತೊ, ಇನ ಛೀಮುಕರಾತೆ ಕೋಣ್ ಕರಿ ಮಾಲುಮ್‌ ಕರಿಲಿದೊಹೋತ್; ಆ ಕಿಮ್ನು ಪಾಪ್‌ಮ ಜಿವ್ಣು ಚ಼ಲಾವ್‍ಕರಾಸ್‌ ಕರಿ ಮಾಲುಮ್‌ ಕರಿಲಿದೊಹೋತ್!” ");
INSERT INTO vaa_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","ತದೆ ಯೇಸುನೆ, “ಸೀಮೋನ್, ತುನ ಬೊಲಾನಿ ಏಕ್‌ ವಾತ್ ಛಾ಼” ಕರಿ ಬೋಲ್ಯೊ. ತದೆ ಸೀಮೋನ್ನೆ, “ಗುರು, ಬೋಲ್” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","ತದೆ ಯೇಸುನೆ, “ಏಕ್‌ ಶೌಕಾರ್‌ನ ಬೇ ಜ಼ಣ ಕರ್‌ಜ್ಯಾ ಥಾ; ಏಕ್‌ ಜ಼ಣೊ ಪಾಚ಼್ ಖ್ಹೊ ರೂಪಾನ ಬಿಲ್ಲಾ ದೇವ್ಣುಥು; ಬಿಜ್ಜೇಕ್‌ ಜ಼ಣೊ ಅಡೈವಿಖ್ಹ್‌ ರೂಪಾನಬಿಲ್ಲಾ ದೇವ್ಣುಥು. ");
INSERT INTO vaa_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","ಯೋ ಭೇ ಜ಼ಣಾನಾಬಿ ಫೇಡಾನ ಹಾತ್‌ ಕೋ ಹುಯೂನಿ. ಇನಖ್ಹಾಜೆ ಯೋ ಭೇ ಜ಼ಣಾನು ಕರಜ಼್ ಮ್ಹೆಂದಿದೊ. ಇಮ್‍ಕತೊ, ಯೋ ಭೇ ಜ಼ಣಾಮ ಕೋಣ್ ಯೋ ಶೌಕಾರ್‌ನ ಜಾ಼ಖ್ಹತ್ ಪ್ಯಾರ್ ಕರ್ಶೆ?” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","ಸೀಮೋನನೆ, “ಕಿನೆ ಜಾ಼ಖ್ಹತ್ ಕರಜ಼್ ಲೀರಾಖ್ಯೊಥೋಕಿ ಯೋಸ್‌ ಕರಿ ದೆಖಾವಸ್” ಕರಿ ಬೋಲ್ಯೊ. ತದೆ ಯೇಸುನೆ ಇನ, “ತುನೆ ಬರಾಬರ್‌ಥಿ ತೀರ್ಪ್‌ ದಿದೊ. ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","ತದೆ ಯೇಸುನೆ ಯೋ ತಯೇಡ ಭಣಿ ಫರಿನ್, ಸೀಮೋನ್ನ, “ಆ ತಯೇಡಾನ ದೇಖ್ಯೊಕಿ ಶು? ಮೇ ತಾರ ಘರೆ ಆಯೊ, ತೂ ಮಾರ ಗೋಡಾನ ಪಾಣಿ ಕೋ ದಿದೋನಿ. ಕತೋಬಿ ಆತೊ, ಇನ ಡೋಳಾನ ಆಂಝೇ಼ಥಿ, ಮಾರ ಗೋಡ ಧೋಯಿನ್‌, ಇನ ಮುಡ್‌ಕ್ಯಾನ ಕೇಖ್ಹ್‌ಥಿ ನೂಛಿ. ");
INSERT INTO vaa_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","ತುನೆ ಮನ ಏಕ್‌ ಹಲ್ಲಾಬಿ ಬುಚ್ಚಾ಼ ಕೋ ದಿದೋನಿ, ಆತೊ ಮೇ ಮಹಿ ಆಯೊ ತಪ್‌ಥೊ ಮಾರ ಗೋಡಾನ ಬುಚ್ಚಾ಼ ದ್ಯವಾನ ಕೋ ಮ್ಹೇಲಿನಿ. ");
INSERT INTO vaa_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","ತೂ ಮಾರ ಮುಡ್‌ಕ್ಯಾನ ತೇಲ್‌ ಲಗಾಡ್ಯೊಕೊಯ್ನಿ, ಕತೋಬಿ ಆತೊ ಮಾರ ಗೋಡಾನ ವಾನುತೇಲ್ ಲೋಥಿ. ");
INSERT INTO vaa_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","ಇನಖ್ಹಾಜೆ ಮೇ ಬೋಲುಸ್ಕಿ, ಅನೆ ವತಾಳಿತೆ ಜಾ಼ಫ ಪ್ಯಾರ್ ದೇಖ್ಯೂತೆ, ಅನು ಪಾಪ್ ಘಣು ರ‍್ಹಯುತೋಬಿ ಮಾಪ್‌ ಹುಯಿಗಯು. ಕತೋಬಿ ಕಿನ ದರ್ರಾಖ್ಹು ಪಾಪ್ ಮಾಪ್‌ ಹುಯುಕಿ, ಯೋ ದರ್ರಾಖ್ಹು ಪ್ಯಾರ್ ಕರಾಸ್. ");
INSERT INTO vaa_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","ತದೆ ಯೇಸುನೆ ಯೋ ತಯೇಡಾನ, “ತಾರು ಖ್ಹಾರೂಸ್ ಪಾಪ್ ಮಾಪ್‌ ಹುಯಿಗಯು” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","ಯೇಸುನ ಜೋ಼ಡ್ಮ ಖಾಣನ ಬೆಠುಥೂತೆ ಖ್ಹಾರು, “ಪಾಪ್ ಖ್ಹಾರುಬಿ ಮಾಪ್‌ ಕರಿನಾಖಿದ್ಯವಾನ ಆ ಕೋಣ್?” ಕರಿ ಇವ್ಣ-ಇವ್ಣಾಮಸ್ ಬೋಲಿಲಿದು. ");
INSERT INTO vaa_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","ಕತೋಬಿ ಯೇಸುನೆ ಯೋ ತಯೇಡಾನ, “ತಾರಿ ವಿಶ್ವಾಸಸ್ ತುನ ಬಚಾ಼ಡ್ಯು; ಶಾಂತಿಥಿ ಜಾ಼” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","ಅನ ಬಾದ್‌ಮ ಯೇಸು ಖ್ಹಾರ ಖ್ಹಯೇರ್‌ಮ ಅಜು಼ ಗಾಮ್ಮಾಕರಿ ಫರ್ತೊಹುಯಿನ್, ದೇವ್ನಿ ರಾಜ್ಯನಿ ಅಛ್ಛಿ ಖಬರ್‌ನ ಬೋಲ್ತೊನಿಕ್‌ಳ್ಯೊ. ಭಾರ ಜ಼ಣ ಶಿಷ್ಯರ್‌ಬಿ ಇನಜೋ಼ಡೆ ಥಾ. ");
INSERT INTO vaa_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","ಥೋಡಿ ತಯೇಡಾಬಿ ಇನಜೋ಼ಡೆ ಥಿ. ಆ ತಯೇಡಾವ್‍ನ ಯೇಸುಥಿ ರೋಗ್‌-ರಾಯೊ ಅಛ್ಛು಼ ಹುಯೂಥು ಅಜು಼ ಭೂತ್‌ ಖ್ಹಾರು ನಿಕ್ಳಿಗಯೂಥು. ಅವ್ಣಾಮ, ಖ್ಹಾತ್ ಭೂತ್ ನಿಕ್ಳಿಗಯುಥೂತೆ (ಮಗ್ದಲ ಗಾಮ್‌ನಿ) ಮರಿಯ, ");
INSERT INTO vaa_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","ಹೆರೋದನು ಘರ್‌ಭಾರ್‌ನು ಇಶಾಬ್ ದೆವಾಳೊ ಹುಯಿರ‍್ಹೊಥೋತೆ ಕೂಜನಿ ಬಾಯ್ಕೊ ಯೋಹಾನ್ನ, ಸುಸನ್ನ ಅಜು಼ ಕೈಯೆಕ್ಕಿ ಬಿಜಿ ತಯೇಡಾಬಿ ಥಿ. ಅವ್ಣೆ ಇವ್ಣು ಶೊಂತ್ ಪೈಶಾಥಿ ಯೇಸುನಿ ಅಜು಼ ಇನ ಶಿಷ್ಯರ್‌ನಿ ಚಾ಼ಕ್ರಿ ಕರ್ತಿಥಿಯೆ. ");
INSERT INTO vaa_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","ಖ್ಹಯೇರೆ-ಖ್ಹಯೇರೇಥು ಕೈಯೆಕ್ಕಿ ಅದ್ಮಿಯೆ ಅವ್‌ಕರ್ತೂಥು; ಅಜು಼ ಅದ್ಮಿನಿ ಮೋಟಿ ಭೀಡ್ ಭರಾವಾದೀನ್‌, ಯೇಸುನೆ ಇವ್ಣುನ ಮತ್ಲಬ್‌ನಿ ಖೇಣಿಯೇಥಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","ಏಕ್‌ ಜ಼ಣೊ ಪಂಡಾ ಛಿಡ್ಕಾನಖ್ಹಾಜೆ ಖೇತ್ರೆ ಗಯೊ, ಯೋ ಪಂಡಾ ಛಿಡ್ಕಾನಿ ವಖ್ಹತ್‌ಮ, ಥೋಡ ಪಂಡಾ ವಾಟ್ನ ಶೇಡೆ ಪಡೀನ್, ಖುಂದ್‌ಲೈಗು. ಆಬ್‍ಥು ಉಡಂತು ಜಿನಾವರ್ ಖ್ಹಾರು ಆಯಿನ್‌ ಇನ ಚ಼ರಿಲಿದು. ");
INSERT INTO vaa_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","ಅಜು಼ ಥೋಡ ಪಂಡಾ ಬಂಡಾಪರ್‌ನಿ ಮಾಟಿಪರ್‌ ಪಡ್ಯು, ಯೋ ಫುಟಿನ್‌ ಮಾಟಿ ಭಿಗ್ಗಿಕೊಂತೆ ದೇಖಿನ್, ಖ್ಹುಕೈಗು. ");
INSERT INTO vaa_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","ಅಜು಼ ಥೋಡ ಪಂಡಾ, ಕಾಟಾನ ಡಾಗ್‌ಮ ಪಡ್ಯು, ಆ ಕಾಟಾನು ಝಾ಼ಡಾ ಯೋ ಪಂಡಾವ್‍ನ ಜೋ಼ಡೆ ಫುಟಿನ್, ಶೋಶಿಯೇನ ದಾಬಿನಾಖ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","ಬಿಜು಼ ಥೋಡ ಪಂಡಾ ಅಛ್ಛಿ ಜ಼ಮೀನ್‌ಪರ್‌ ಪಡೀನ್, ಫುಟಿನ್, ಏಕ್‌ ಪಂಡಾಪಿಟ್ ಖ್ಹೊ ಎತ್ರೆ ಪಂಡಾ ಮ್ಹೇಲ್ಯು”. ಆ ಖ್ಹಾರಿ ವಾತೆ ಬೋಲಾನ ಬಾದ್‌ಮ, ಯೇಸುನೆ, “ಕಿನ-ಕಿನ ಖ್ಹಮ್‌ಜಾ಼ನ ಕಾನ್‌ ಛಾ಼ಕಿ ಇವ್ಣೆ ಖ್ಹಮ್‌ಜಾ಼ದೆ!” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","ಯೇಸುನು ಶಿಷ್ಯರ್‌ ಇನ, “ಆ ಮತ್ಲಬ್‌ನಿ ಖೇಣಿನು ಮತ್‌ಲಬ್ ಶಾತ್‌” ಕರಿ ಪುಛಾ಼ಯು, ");
INSERT INTO vaa_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","ಯೇಸುನೆ, “ದೇವ್ನಿ ರಾಜ್ಯನಿ ಖ್ಹಾಚ಼ನ ಮಾಲುಮ್ ಕರಿಲ್ಯವಾನಿ ಗ್ಯಾನ್ ತುಮೂನ ದೆವೈರ‍್ಹೂಸ್. ಕತೋಬಿ ಬಿಜಾ಼ಖ್ಹಾರ ಅದ್ಮಿನ ಡೋಳ ರ‍್ಹಯುತೋಬಿ ದೆಖಾವ್ಣುನಾತೆ, ಅಜು಼ ಕಾನ್‌ ರ‍್ಹಯುತೋಬಿ ಖ್ಹಮ್‌ಜಾ಼ವ್ಣುನಾತೆ ಇಮ್‌ ಮತ್ಲಬ್‌ನಿ ಖೇಣಿಯೇಥಿ ಬೋಲುಸ್” ಕರಿ ಜವಾಬ್‌ ದಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“ಆ ಮತ್ಲಬ್‌ನಿ ಖೇಣಿನು ಮತ್‌ಲಬ್ ಶಾತ್‌ಕತೊ, ಯೋ ಪಂಡು ಕತೊ ದೇವ್ನಿ ವಚನ್. ");
INSERT INTO vaa_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","ಥೋಡು ಅದ್ಮಿ ವಚನ್ನ ಖ್ಹಮಜ಼್‌ತಾಸ್‌ನ ಶೈತಾನ್ ಆಯಿನ್, ಇವ್ಣೆ ನಂಬಿನ್, ಇವ್ಣ ರಕ್ಷಣೆ ನಾ ಮಳ್‌ಣು ಕರಿ, ಯೋ ವಚನ್ನ ಇವ್ಣ ಮನ್‌ಮಾಥು ಕಾಡಿನಾಖಿದೇಸ್. ಅವ್ಣೇಸ್ ವಾಟ್ನಶೇಡೆ ಪಡ್ಯಾತೆ ಪಂಡಾ ಹುಯಿರ‍್ಹೂಸ್. ");
INSERT INTO vaa_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","ಥೋಡು ಅದ್ಮಿ ವಚನ್ನ ಖ್ಹಮಜ಼್‌ತಾಸ್‌ನ, ಖ್ಹುಶಿಥಿ ಇನ ಮಾನಿಲೇಸ್. ಅವ್ಣುನ ಜ಼ಡ್‌ಕೊಂತೆ ಇನಖ್ಹಾಜೆ ಜ಼ರಘಡಿಸ್ ಖಲಿ ನಂಬಸ್‍ ಶೋದನೆನ ಹಗಾಮ್ಮ ಪಡಿಜಾ಼ಸ್‌. ಅವ್ಣೇಸ್ ಬಂಡಾಪರ್ ಪಡ್ಯಾತೆ ಪಂಡಾ ಹುಯಿರ‍್ಹಾಸ್‌. ");
INSERT INTO vaa_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","ಕಾಟಾನ ಝಿಕ್ರಾನು ಝ಼ಗೋಪರ್ ಪಡ್ಯಾತೆ ಪಂಡಾ ಕೆಹುಕತೊ, ಥೋಡು ಅದ್ಮಿ ದೇವ್ನಿ ವಚನ್ನ ಖ್ಹಮ್‌ಜಾ಼ಸ್‌, ಕತೋಬಿ ಆ ಜಿವ್ಣಾನಿ ಪಶ್ತಾವ್ಣಿ, ಧನ್‌-ದೌಲತ್‌ನಿ ಭೋಗ್‌ಮ ಡುಬಿಜೈನ್, ಇವ್ಣು ಫಲ್ ಕೋದೇಯ್ನಿ. ");
INSERT INTO vaa_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","ಪಲ್‍ವಾಯಿಹುಯಿ ಜ಼ಮೀನ್‌ಪರ್‌ ಪಡ್ಯುಹುಯು ದಾಣೊ ಕತೊ ದೇವ್ನಿವಚನ್ನ ಖ್ಹಮ್‌ಜಿನ್‌, ಖ್ಹಾಚು಼ ಅಜು಼ ಅಛ಼್ಛ ಮನ್‌ಮ ಇನ ರಾಖಿನ್, ಇವ್ಣೆ ಖ್ಹಮಾಳಿನ್ ಫಲ್ ದೇಸ್. ");
INSERT INTO vaa_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","ಕೆಹು ಅದ್ಮಿಬಿ ದೀವೊ ಲಗಾಡಿನ್, ಹಂಡ್ಕಾನ ಹೇಟ್‌ ರ‍್ಹವೊ ನತರ್‌ಕಿ ಪಲಂಗ್‌ನ ಹೇಟ್ ರ‍್ಹವೊ ಲಪಾಡಿನ್ ಮ್ಹೇಲಾಕೊಯ್ನಿ. ಘರ್‌ಮ ಆವಾಳಾನ ಉಜಾ಼ಳು ದೆಖಾವಾನಿಘೋಣಿ, ದೀವೊ ಮ್ಹೇಲಾನಿ ಖಂಬಾಪರ್‌ ಮ್ಹೇಲಾಸ್. ");
INSERT INTO vaa_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","ಖ್ಹಾರಿಸ್ ಖ್ಹಾಚಿ ಭಾರ್‌ ನಿಕಳ್‌ಶೆ, ಅಜು಼ ಲಪೈರ‍್ಹೂತೆ ಖ್ಹಾರಸ್ನ ಢೂಂಡಿನ್ ಭಾರ್‌ ಲ್ಯಾವ್‌ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","ಇನಖ್ಹಾಜೇಸ್, ತುಮೆ ಖ್ಹಮ್‍ಜಾ಼ನಿ ವಖ್ಹತ್‌ಮ, ಹೊಷಾರ್‌ಥಿ ಖ್ಹಮ್‌ಜೊ಼; ಶನಕತೊ ಕಿನಾಕನ ಛಾ಼ಕಿ ಇವ್ಣುನ ಬಿಜೂ಼ಬಿ ದೆವಾವ್‌ಶೆ, ಕತೋಬಿ ಕಿನಾಕನ ಕೊಯ್ನಿಕಿ ಇವ್ಣಾಕಂಥು, ಯೋ ಇನುಕರಿ ಸೋಚಾಸ್ತೆ ಇನಾಬಿ ಛಿನೈಲಿಶೆ. ");
INSERT INTO vaa_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","ತದೆ ಯೇಸುನಿ ಆಯಾಬಿ ಇನ ಭೈಯೇ ಯೋ ಥೋತೆ ಹಿಜ್ಜಾ಼ ಆಯಿನ್, ಅದ್ಮಿನಿ ಝೂ಼ಂಡ್‌ಥೀತೆ ಇನಖ್ಹಾಜೆ ಯೇಸುನ ಖನ್ನೆ ಆವಾನ ಕೋ ಹುಯೂನಿ. ");
INSERT INTO vaa_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","ಹಿಜ್ಜಾ಼ ಥೂತೆ ಇವ್ಣಾಮ ಏಕ್‌ ಜ಼ಣಾನೆ ಯೇಸುನ, “ತಾರಿ ಆಯಾಬಿ ತಾರ ಭೈಯೇ ಅಯಿನ್ ತುನ ದೇಕ್ಣು ಕರಿ, ಭಾರ್‌ ಭಿಯ್ಯುಸ್” ಕರಿ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","ತದೆ ಯೇಸುನೆ ಇವ್ಣ ಖ್ಹಾರಾನ, “ಕೋಣ್ ದೇವ್ನಿ ವಚನ್ನ ಖ್ಹಮ್‌ಜಿನ್‌, ಇನೀನಿಘೋಣಿ ಚಾ಼ಲಸ್ಕಿ ಇವ್ಣೆಸ್ ಮನ ಆಯಾಬಿ, ಭೈಯೇಬಿ ಹುಯಿರುಸ್‌” ಕರಿ ಜವಾಬ್‌ ದಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","ಏಕ್‌ ದನ್ನೆ ಯೇಸು ಇನ ಶಿಷ್ಯರ್‌ನ ಜೋ಼ಡೆ, ಏಕ್‌ ಡೋಣ್‌ಮ ಚ಼ಢೀನ್ ಬೇಶಿಗಯೊ, ಅಜು಼ ಇವ್ಣುನ, “ಚಾ಼ಲೊ, ಅಪ್ಣೆ ದರ‍್ಯಾವ್‍ನಿ ಪಾರ್ಲಿ ಬಾಜೂ಼ನ ಜೈ಼ಯೆ” ಕರಿ ಬೋಲ್ಯೊ. ತದೆ ಇವ್ಣೆ ಡೋಣ್ಣಾ ಪಾಣಿಮ ಧಕೇಲಿನ್ ನಿಕ್‌ಳ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","ಇವ್ಣೆ ಜ಼ವ್‍ಕರ್ತುಥೂತೆ ತದೆ ಯೇಸುನ ನಿಂದರ್‌ ಆಯಿನ್ ಖ್ಹುಯಿಗಯೊ. ಏಕ್‌ದಮ್ ಮೋಟೊ ವಹಿರೊ ವಾಗಿನ್, ಡೋಣ್‌ಮ ಪಾಣಿ ಭರಾವಲಗ್ಯೂಥು. ಅನೇಥಿ ಇವ್ಣೆ ಘಣಿ ಮುಶ್ಕಿಲ್‌ಮ ಪಡಿಗಯ. ");
INSERT INTO vaa_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","ತದೆ ಶಿಷ್ಯರ್‌ ಖ್ಹಾರು ಯೇಸುಕನ ಐನ್, “ಗುರು, ಗುರು, ಹಮೆ ಮರ್‌ವಾನ ಆಯಾನಿ!” ಕರಿ ಬೋಲ್ಯ. ತದೆ ಯೇಸುನೆ ಉಠೀನ್ ವಹಿರನಾಬಿ, ಪಾಣಿನು ಝೋ಼ಕಾಳ್ಯನಾಬಿ ಗುರ್‌ಕಾಯೊ. ಗುರ್‌ಕಾವಖ್ಹತರ್ ಯೋ ಭೀರಿಗಯು ಅಜು಼ ಖ್ಹೊಪೊ ಹುಯಿಗಯು. ");
INSERT INTO vaa_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","ಬಾದ್‌ಮ ಯೇಸುನೆ ಇನ ಶಿಷ್ಯರ್‌ನ, “ತುಮಾರಿ ವಿಶ್ವಾಸ್‌ ಕಿಜ಼್ಜಾ ಗೈ?” ಕರಿ ಪುಛಾ಼ಯೊ. ಕತೋಬಿ ಇವ್ಣೆ ಆಶ್ಚರ್ಯಖಾದು ಅಜು಼ ಡರಿಗಯು, ಅಜು಼ ಬೋಲ್ಯೂಕಿ, “ಆ ಅದ್ಮಿ ಕೋಣ್ ಉಶೆ? ವಹಿರನಾಬಿ, ಝೋ಼ಕಾಳ್ಯನಾಬಿ ಹುಕುಮ್‌ ದೇಸ್‌ನಿ; ಯೋಅಖ್ಖುಬಿ ಆ ಬೋಲಾತೆ ಇಮ್‌ ಖ್ಹಮ್‌ಜಾ಼ಸ್‌ನಿ!” ಕರಿ ಏಕ್‌ಥಿ-ಏಕ್‌ ಬೋಲಿಲಿದು ");
INSERT INTO vaa_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","ಯೇಸು ಅಜು಼ ಇನು ಶಿಷ್ಯರ್‌ ಗಲಿಲಾಯಥು ಗೆರಸೇನವಾಳನು ತಬರ್‌ಖಾನ ಆಯಿನ್ ಪೋಚ್ಯಾ. ");
INSERT INTO vaa_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","ಯೇಸು ಕನಾರಿಪರ್ ಉತರ್‌ತಸ್ನ, ಯೋ ಗಾಮ್‌ನು ಏಕ್‌ ಜ಼ಣೊ ಇನಖ್ಹಾಮ್ಣೆ ಆಯು, ಇನ ಭೂತ್‌ ಖ್ಹಾರು ಧರಿರಾಖ್ಯುಥು. ಆ ಕೈಯೆಕ್ಕಿ ದನ್‌ಥು ಲುಂಗ್ಡುಸ್ ಫೇರ‍್ಯುಥು ಕೊಯ್ನಿ ಅಜು಼ ಘರ್‌ಮಾಬಿ ರ‍್ಹೇತೂಥು ಕೊಯ್ನಿ. ಮಖ್ಹಾಣ್ಯನಿ ಘವಿಯೆಮಾಸ್ ರ‍್ಹೇತೂಥು. ");
INSERT INTO vaa_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","ಇನೆ ಯೇಸುನ ದೇಖಿನ್ ಬಳೇಳಿನ್‌, ಇನಖ್ಹಾಮ್ಣೆ ಪಡೀನ್, ಚೋ಼ರ್ ಆವಾಜ಼್‌ಥಿ, “ಪರಮಂಡಲ್‌ನೊ ದೇವ್ನ ಛಿಯ್ಯಾ, ಯೇಸು! ಮಾರೇಥಿ ತುನ ಶಾತ್‌ ಛಾ಼? ಮನ ಖ್ಹತೈಶ್‌ ನಕೊ ಕರಿ ತುನ ಗಿಂಗಾವುಸ್” ಕರಿ ಬೋಲಿಲಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","ಶನಕತೊ, “ಆ ಅದ್ಮಿನ ಮ್ಹೆಂದಿನ್ ಜಾ಼!” ಕರಿ ಯೇಸುನೆ ಯೋ ಭೂತ್‌ನ ಹುಕುಮ್‌ ದಿದೋಥೊ. ಘಣಿ ಹಲ್ಲ ಯೋ ಭೂತ್‌ ಇನ ಧರ್ತುಥು, ಎತ್ರೇಸ್ ಕಾಹೆತೆ ಯೋ ಅದ್ಮಿನ ಕೋಂಡಿಘಾಲಿನ್, ಹಾತ್-ಗೋಡಾನ ಖ್ಹಂಕಳ್‌ಥಿ ಭಾಂದ್ಯುತೋಬಿ, ಯೋ ಖ್ಹಂಕ್‌ಳಿನ ತೋಡಿ ನಾಕ್ತೋಥೊ ಅಜು಼ ಯೋ ಭೂತ್ ಇನ ಉಜ್ಜಾ಼ಡಿ ಝ಼ಗೋಮ ನಖ್ಹಾಡ್‌ತೂಥು. ");
INSERT INTO vaa_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","ಯೇಸುನೆ ಇನ, “ತಾರು ನಾಮ್ ಶಾತ್?” ಕರಿ ಪುಛಾ಼ವಖ್ಹತರ್, ಇನೆ, “ಮಾರು ನಾಮ್ ಝೂ಼ಂಡ್‌” ಕರಿ ಜವಾಬ್‌ ದಿದೊ. ಶನಕತೊ ಇನ ಘಣು ಭೂತ್ ಧರಿರಾಖ್ಯುಥು. ");
INSERT INTO vaa_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","ಯೋ ಭೂತ್‌ಖ್ಹಾರು ಯೇಸುನ, “ಹಮೂನ ಅಂತಸ್‌ಕೊಂತೆ ಪಾತಾಳ್ಮ ನಕೊ ನಖ್ಹಾಡ್” ಕರಿ ಗಿಂಗೈಲಿದು. ");
INSERT INTO vaa_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","ಹಿಜ್ಜಾ಼ ಖನ್ನೆಸ್‌ ಥೂತೆ ಪಹಾಡ್‌ಪರ್ ಡೂಕರ್‌ನಿ ಏಕ್‌ ಮೋಟಿ ಝೂ಼ಂಡ್‌ ಚ಼ರೂಕರ್‌ತೂಥು. ತದೆ ಯೋ ಭೂತ್ ಖ್ಹಾರು, “ಯೋ ಖ್ಹಾರ ಡೂಕರ್‌ಮ ಪೇಖ್ಹಾನ ಹಮೂನ ಹುಕುಮ್ ದೇ” ಕರಿ ಯೇಸುನ ಗಿಂಗೈಲಿದು. ಯೇಸುನೆ ಇಮ್ಮಸ್ ಹುವಾದೆ ಕರಿ ಬೋಲಾಖ್ಹತರ್, ");
INSERT INTO vaa_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","ಭೂತ್‌ಖ್ಹಾರು ಯೋ ಅದ್ಮಿನ ಮಹಿತು ಭಾರ್ ಆಯಿನ್, ಡೂಕರ್‌ಮ ಪೇಶಿಗಯು. ತದೆ ಯೋ ಡೂಕರ್‌ನಿ ಝೂ಼ಂಡ್‌ ನಾಶಿನ್, ಕಥಾರ್‌ನಿ ಝ಼ಗೋಥು, ದರ‍್ಯಾವ್‌ಮ ಪಡೀನ್, ದಮ್‌ ಘೋಟೈನ್‌ ಮರಿಗಯು. ");
INSERT INTO vaa_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","ಡೂಕರ್‌ ಚ಼ರಾವವಾಳು ಚಾ಼ಲ್ಯುತೆ ಇನ ದೇಖಿನ್, ನಾಶಿಜೈ಼ನ್, ಯೋ ಗಾಮ್ಮಾಬಿ ಅಜು಼ ಅಶ್‌ಪಿಶ್‌ನು ಖೇತರ್‌ಮಾನು ಅದ್ಮಿನ ಚಾ಼ಲ್ಯುತೆ ಇನಿ ಬಾರೇಮ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","ತದೆ ಯೋ ಅದ್ಮಿಖ್ಹಾರು ಚಾ಼ಲ್ಯುತೆ ಇನ ದೇಖಾನಖ್ಹಾಜೆ ಯೇಸು ಥೋತೆ ಹಿಜ್ಜಾ಼ ಆಯು. ತದೆ ಭೂತ್‌ಖ್ಹಾರು ನಿಕ್ಳಿಗಯುಥೂತೆ ಯೋ ಅದ್ಮಿ ಲುಂಗ್ಡಾವ್‍ನ ಪೇರ‍್ಹಿಲಿನ್‌, ಅಛ್ಛಿ ಖ್ಹಯಾಲ್‌ಥಿ, ಯೇಸುನ ಗೋಡಾಕನ ಬೆಠುಥೂತೆ ದೇಖಿನ್, ಇವ್ಣೆ ಖ್ಹಾರು ಡರಿಗಯು. ");
INSERT INTO vaa_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","ಚಾ಼ಲ್ಯುತೆ ಯೋ ಖ್ಹಾರಾನ ದೇಖ್ಯೂತೆ ಇವ್ಣೆ, ಯೋ ಭೂತ್ ಧರಿರಾಖ್ಯುಥೂತೆ ಇನ ಕಿಮ್ ಅಛ್ಛು಼ಹುಯು ಕರಿ ಯೋ ಖ್ಹಾರ ಅದ್ಮಿನ ಬೋಲಿವತಾಳ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","ಗೆರಸೇನವಾಳನು ತಬರ್‌ಖಾನು ಖ್ಹಾರಾನ ಘಣು ಡರ್‌ಲಾಗ್ಯೂತೆ ಇನಖ್ಹಾಜೆ, ಇವ್ಣೆ ಯೇಸುನ, “ತೂ ಹಮೂನ ಮ್ಹೆಂದಿನ್ ಜಾ಼” ಕರಿ ಬೋಲಿಲಿದು. ಇನಖ್ಹಾಜೆ ಯೇಸು ಡೋಣ್ಣಾ ಚ಼ಢೀನ್‌, ಪಾಛು಼ ಫರಿ ಚ಼ಲೆಗಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","ಯೇಸು ಜಾ಼ವಾನಿ ವಖ್ಹತ್‌ಮ, ಭೂತ್‌ಖ್ಹಾರು ನಿಕ್ಳಿಗಯೂತೆ ಯೋ ಅದ್ಮಿ ಯೇಸುನ, “ಮೇಬಿ, ತಾರ ಕೇಡೆಸ್ ರ‍್ಹವುಸ್‌” ಕರಿ ಯೇಸುನ ಗಿಂಗೈಲಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","ಕತೋಬಿ ಯೇಸುನೆ ಇನ, “ತೂ ಪಾಛೊ಼ ತಾರ ಘರೆ ಜಾ಼ ಅಜು಼ ದೇವ್ನೆ ತಾರಖ್ಹಾಜೆ ಶಶ್ಶಾತ್ ಕರ‍್ಯೊ ಕರಿ ಬೋಲ್” ಕರಿ ಬೋಲಿನ್ ಮೋಕ್ಲಿದಿದೊ. ಯೋ ಅದ್ಮಿ ಹಿಜ್ಜಾ಼ಥು ಚ಼ಲ್ಯೂಜೈ಼ನ್, ಯೇಸುನೆ ಇನ ಶಶ್ಶಾತ್ ಕರ‍್ಯೊ ಕರಿ ಯೋ ಗಾಮ್ಮಾಕರಿ ಬೋಲ್ತುನಿಕ್‌ಳ್ಯು ");
INSERT INTO vaa_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","ಯೇಸು ಪಾಛೊ಼ಫರಿ ಆವಾದಿನ್ ಅದ್ಮಿಖ್ಹಾರು ಇನ ಬುಲೈಲಿದು, ಶನಕತೊ ಇವ್ಣೆ ಖ್ಹಾರು ಯೇಸುನಖ್ಹಾಜೆ ಜ಼ಪಿರ‍್ಹೂಥು. ");
INSERT INTO vaa_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","ತದೆ ಸಬಾಮಂದಿರ್‌ನೊ ಅದಿಕಾರಿ ಹುಯಿರ‍್ಹೊಥೋತೆ ಯಾಯಿರ ಕರಿ ನಾಮ್ನೊ ಏಕ್‌ ಜ಼ಣಾನೆ ಹಿಜ್ಜಾ಼ ಆಯಿನ್, ಯೇಸುನ ಗೋಡಾಪರ್ ಪಡೀನ್, ಇನ ಘರೆ ಆವ್ಣುಕರಿ ಯೇಸುನ ಗಿಂಗೈಲಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","ಶನಕತೊ, ಭಾರ ವರಖ್ಹ್‌ನಿ ಹುಯಿರ‍್ಹಿಥೀತೆ, ಇನಿ ಏಕ್‌ನಿ-ಏಕ್‌ ಛೋ಼ರಿ, ಮರಾನಿ ಹಾಲ್‌ಮ ಥಿ. ಯೇಸು ಯಾಯಿರನ ಘರೆ ವಳ್ಯೊಜಾ಼ತೊಥೋತೆ ತದೆ, ಅದ್ಮಿನಿ ಭೀಡ್ ಇನ ಅಶ್‌ಪಿಶ್‍ ಭರೈನ್ ಆಯು. ");
INSERT INTO vaa_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","ಯೋ ಭೀಡ್‌ಮ ಭಾರ ವರಖ್ಹ್‌ಥು, ಮುಟ್ನು ರೋಗ್‌ಥೀತೆ ಏಕ್‌ ತಯೇಡ ಥಿ. ಯೋ ಇನಾಕನ ಥೂತೆಖ್ಹಾರುಸ್ ಖರ್ಚಿ ಕರಿತೋಬಿ, ಕೋಣ್‌ಬಿ ಇನ ಅಛ್ಛು಼ ಕೊಕರ‍್ಯುನಿ. ");
INSERT INTO vaa_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","ತದೆ ಯೋ ತಯೇಡ ಝೂ಼ಂಡ್‌ಮ ಯೇಸುನ ಪೀಠೇಥು ಐನ್, ಇನ ಲುಂಗ್ಡಾನ ಕನಾರೀನ ಛೀಮಿ. ಛೀಮ್‌ತಾಸ್ನ ಇನ ಲ್ಹೋಯಿ ಝ಼ರಾನು ಭೀರಿಗಯು. ");
INSERT INTO vaa_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","ತದೆ ಯೇಸುನೆ, “ಮನ ಛೀಮ್ಯೂತೆ ಕೋಣ್?” ಕರಿ ಪುಛಾ಼ಯೊ. ತಮಾಮ್‌ ಅದ್ಮಿನೆ ‘ಮೇ ಕಾಹೆ, ಮೇ ಕಾಹೆ’ ಕರಿ ಬೋಲ್ತಾನ, ಪೇತ್ರನೆ ಯೇಸುನ, “ಗುರು, ಅದ್ಮಿನಿ ಭೀಡ್ ತಾರ ಅಶ್‌ಪಿಶ್‍ ಭರೈನ್, ತಾರಪರ್ ಪಡುಕರಾಸ್‌ನಿ” ಕರಿ ಬೋಲ್ಯೊ ");
INSERT INTO vaa_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","ತೋಬಿ ಯೇಸುನೆ, “ಕೋಣ್‌ಕಿ ಏಕ್‌ ಜ಼ಣು ಮನ ಛೀಮ್ಯು. ಮಾರೇಥಿ ಶಕತ್ ಗೈತೆ ಮನ ಮಾಲುಮ್‌ಪಡ್ಯು” ಕರಿ ಬೋಲಾಖ್ಹತರ್, ");
INSERT INTO vaa_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","ಯೋ ತಯೇಡ ಅಜು಼ ಮೇ ಲಪಿರ‍್ಹಾವಾನ ಉಶೆಕೊಯ್ನಿ ಕರಿ ಮಾಲುಮ್‌ ಕರಿಲೀನ್, ಕಾಪ್ತಿಹುಯಿನ್‌ ಐನ್ ಯೇಸುನ ಗೋಡಾಪರ್ ಪಡೀನ್, ಇನೆ ಶನಖ್ಹಾಜೆ ಛೀಮೀತೆ ಕರಿ ಅಖ್ಖಾನ ಖ್ಹಾಮೆ ಬೋಲಿ. ಎತ್ರೇಸ್ ಕಾಹೆತೆ ಛೀಮ್‌ತಾಸ್‌ನ ಇನ ಅಛ್ಛು಼ ಹುಯಿಗಯು ಕರಿ ಬೋಲಿ. ");
INSERT INTO vaa_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","ತದೆ ಯೇಸುನೆ ಇನ, “ಛೋ಼ರಿ, ತಾರಿ ವಿಶ್ವಾಸ್‌ಥೀಸ್‌ ತುನ ಅಛ್ಛು಼ಹುಯು. ಶಾಂತಿಥಿ ಜಾ಼” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","ಯೇಸು ಆ ವಾತೆ ಬೋಲುಕರಾನಿ ವಖ್ಹತ್‌ಮ, ಸಬೆ ಭರಾವಾನು ಮಂದಿರ್‌ನು ಅದಿಕಾರಿ ಭಣಿವಾಳು ಏಕ್‌ ಜ಼ಣು ಐನ್ ಯಾಯಿರನ, “ತಾರಿ ಛೋ಼ರಿ ಮರಿಗೈ, ಅಜು಼ ಗುರುನ ಖ್ಹತಾವ್ ನಕೊ” ಕರಿ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","ಕತೋಬಿ ಯೇಸುನೆ ಅನ ಖ್ಹಮ್‌ಜಿನ್‌, ಯಾಯಿರನ, “ಡರ್‌ನಕೊ, ಖಲಿ ವಿಶ್ವಾಸ್ ರ‍್ಹವಾದೆ, ಇನ ಅಛ್ಛು಼ ಉಶೆ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","ಯೇಸು ಯೋ ಘರ್‌ಕನ ಆವಾದಿನ್ ಪೇತ್ರ, ಯೋಹಾನ, ಯಾಕೋಬ್ ಅಜು಼ ಯೋ ಛೋ಼ಕ್ರಿನ ಆಯ-ಬಾ ಇವ್ಣುನ ಮ್ಹೆಂದಿನ್, ಕಿನಾಬಿ ಇನಾಕೇಡೆ ಮಹಿ ಕೊ ಆವಾದಿದೋನಿ. ");
INSERT INTO vaa_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","ಹಿಜ್ಜಾ಼ ಥೂತೆ ತಮಾಮ್‌ ಅದ್ಮಿ ಯೋ ಛೋ಼ಕ್ರಿನಖ್ಹಾಜೆ ರೊವ್‌ತುಹುಯಿನ್, ಛಾ಼ತಿ ಕೂಟುಕರ್ತೂಥೂ. ಅನ ದೇಖಿನ್ ಯೇಸುನೆ, “ನಕೊ ರೋವೊ, ಛೋ಼ಕ್ರಿ ಮರಿಕೊಯ್ನಿ, ಖ್ಹುತೀಸ್!” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","ಛೋ಼ಕ್ರಿ ಮರಿಗೈ ಕರಿ ಇವ್ಣುನ ಮಾಲುಮ್‍ಥೂತೆ ಇನಖ್ಹಾಜೆ, ಇವ್ಣೆ ಖ್ಹಾರೂಸ್ ಯೇಸುನ ದೇಖಿನ್ ಹಾಶ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","ಕತೋಬಿ ಯೇಸುನೆ ಯೋ ಛೋ಼ಕ್ರಿನೊ ಹಾತ್‌ ಧರೀನ್, “ಪಪ್ಪಾ, ಉಪ್ಪರ್ ಉಟ್!” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","ತದ್‌ನು-ತದ್ದೇಸ್ ಇನ ಜಾನ್‌ಆಯು. ಯೋ ಉಠೀನ್ ಭೀರಿಗೈ. ತದೆ ಯೇಸುನೆ ಇವ್ಣುನ, “ಅನ ಖಾವಾನ ಶಾತ್‌ತೋಬಿ ದೆವೊ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","ಯೋ ಛೋ಼ಕ್ರಿನ ಆಯ-ಬಾನೆ ಆಶ್ಚರ್ಯಖಾದು, ಕತೋಬಿ ಯೇಸುನೆ ಅನಿ ಬಾರೇಮ ಕಿನಾಬಿ ನಾ ಬೋಲ್‌ನು ಕರಿ ಇವ್ಣುನ ಹುಕುಮ್ ದಿದೊ ");
INSERT INTO vaa_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","ಯೇಸುನೆ ಭಾರ ಜ಼ಣ ಅಪೊಸ್ತಲರ‍್ನ ಏಕ್‌ದಮ್ ಬುಲೈನ್, ಇವ್ಣುನ ಭೂತ್‌ಖ್ಹಾರು ಕಾಡಾನ ಅಜು಼ ರೋಗ್-ರಾಯೊ ಅಛ್ಛು಼ಕರಾನ ಶಕತ್‍ ಅಜು಼ ಅದಿಕಾರ್ ದಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","ಅಜು಼ ದೇವ್ನಿ ರಾಜ್ಯನಿ ಬಾರೇಮ ಬೋಲಿವತಾಳಾನ ಅಜು಼ ರೋಗಿನ ಅಛ್ಛು಼ ಕರಾನ ಇವ್ಣುನ ಮೋಕ್‌ಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","ಮೋಕ್ಲಾನಿ ವಖ್ಹತ್‌ಮ ಇವ್ಣುನ, “ಜಾ಼ವಾನಿ ವಖ್ಹತ್‌ಮ ತುಮೆ ಶಾತ್ಬಿ ನಕೊ ಲೀಜಾ಼ವೊ: ಲಠ್ಠೊ ರ‍್ಹವೊ, ಝೋ಼ಳಿ ರ‍್ಹವೊ, ಖಾಣಾನು ಬುತ್ತು ಅಜು಼ ಪೈಶಾ ರ‍್ಹವೊ ನಕೊ; ಬಿಜೇಕ್ ಕುಡ್‌ತು ಜಿನ್‌ಕುಬಿ ನಕೊ. ");
INSERT INTO vaa_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","ತುಮೂನ ಖೆವ ಘರ್‌ಮ ಬುಲೈಲೇಸ್ಕಿ, ಯೋ ಗಾಮ್‍ ಮ್ಹೇಲಿನ್ ಜಾ಼ವಾಲಗೂಬಿ ಯೋಸ್ ಘರ್‌ಮ ರ‍್ಹವಾಕರೊ. ");
INSERT INTO vaa_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","ಅಜು಼ ಖೆವ ಗಾಮ್ಮತೋಬಿ ತುಮೂನ ನಾ ಬುಲೈಲಿದುತೊ, ಯೋ ಗಾಮ್‌ನ ಮ್ಹೆಂದಿನ್ ಜಾ಼ವೊ ಅಜು಼ ತುಮಾರ ಗೋಡಾನ ಲಾಗಾತೆ ಧೂಳ್‌ನ ಝ಼ಟ್‌ಕಿ ದೆವೊ. ಯೋ ಇವ್ಣುನ ಝೇತಾವನು ಸಾಕ್ಷಿ ಹುಯಿರ‍್ಹಿಶೆ. ");
INSERT INTO vaa_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","ತದೆ ಶಿಷ್ಯರ್‌ಖ್ಹಾರು ಹಿಜ್ಜಾ಼ಥು ನಿಕ್ಳಿನ್, ಏಕ್‌ ಗಾಮ್‌ಥು ಬಿಜೇಕ್ ಗಾಮ್‍ ಜಾ಼ತುಹುಯಿನ್, ಹರೇಕ್‍ಆಡಿ ದೇವ್ನಿ ಸುವಾರ್ತೆನ ಬೋಲ್ತುಹುಯಿನ್, ರೋಗ್‌ಮ ರ‍್ಹಾವಾಳನ ಅಛ್ಛು಼ಕರ‍್ಯು ");
INSERT INTO vaa_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","ಗಲಿಲಾಯ ತಬರ್‌ಖಾಮ ಅದಿಕಾರ್ ಚ಼ಲಾವವಾಳೊ ಹೆರೋದನೆ, ಚಾ಼ಲುಕರಾತೆ ಆ ಖ್ಹಾರಾನಿ ಬಾರೇಮ ಖ್ಹಮ್‌ಜಿನ್‌, ಇನ ಘಣು ಕಲಾವ್ಣಿ ಹುಯು. ಶನಕತೊ ಬ್ಯಾಪ್ತಿಸ್ಮದ್ಯವಾಳೊ ಯೋಹಾನ ಪಾಛೊ಼ ಜಿವ್ತೊಹುಯಿನ್ ಐರ‍್ಹೋಸ್ ಕರಿ ಥೋಡು ಅದ್ಮಿ ಬೋಲುಕರ್ತೂಥು. ");
INSERT INTO vaa_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","ಅಜು಼ ಥೋಡು ಜ಼ಣು ಎಲೀಯ ಅಪ್ಣ ಇಚ಼್‌ಮ ಐರ‍್ಹೋಸ್ ಕರಿ, ಬಿಜು಼ ಥೋಡು ಜ಼ಣು ಜೂ಼ನ ಹಗಾಮ್‍ನೊ ಪ್ರವಾದೀಮ ಏಕ್‌ ಜ಼ಣೊ ಜಿವ್ತೊಹುಯಿನ್ ಉಠಿ ಐರ‍್ಹೋಸ್ ಕರಿ ಬೋಲಿಲೆವ್‍ಕರ್ತೂಥು. ");
INSERT INTO vaa_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","ಕತೋಬಿ ಹೆರೋದನೆ, “ಯೋಹಾನನು ಮುಡ್‌ಕ್ಯು ಕತ್ರಾಯೊತೆ; ಕತೋಬಿ ಆ ಕೋಣ್? ಅನಿ ಬಾರೇಮ ಅತ್ರುಖ್ಹಾರು ಮೇ ಖ್ಹಮ್‌ಜು಼ಸ್‌ನಿ?” ಕರಿ ಬೋಲಿನ್ ಯೇಸುನ ದೇಕ್ಣು ಕರಿ ಕರುಕರ್ತೊಥೊ ");
INSERT INTO vaa_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","ಅಪೊಸ್ತಲರ್ ಖ್ಹಾರು ಪಾಛು಼ಫರಿ ಐನ್, ಇವ್ಣೆ ಕರ‍್ಯುತೆ ಅಖ್ಖಾನ ಯೇಸುನ ಖ್ಹಾಮ್ಣೆ ಬೋಲ್ಯು. ತದೆ ಯೇಸುನೆ ಇವ್ಣುನ ಅಲಕ್ ಕಾಡಿಲೀನ್, ಇನಜೋ಼ಡೆ ಬೆತ್ಸಾಯಿದ ಕರಿ ಗಾಮ್‌ನ ಬುಲೈಲಿ ಗಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","ಅದ್ಮಿನಿ ಭೀಡ್ ಅನ ಖ್ಹಮ್‌ಜಿನ್‌, ಯೇಸುನ ಪೀಠೆ ಗಯು ಯೇಸುನೆ ಇವ್ಣುನ ಬುಲೈಲಿನ್, ಇವ್ಣುನ ದೇವ್ನಿ ರಾಜ್ಯನಿ ಬಾರೇಮ ಬೋಲ್ಯೊ. ಅಜು಼ ಕಿನ-ಕಿನ ರೋಗ್‌ಥಿ ಅಛ್ಛು಼ ಹೋಣುಥೂಕಿ ಇವ್ಣುನ ಅಛ್ಛು಼ ಕರ‍್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","ದನ್ ಡುಬಾಲಗ್ಯೋಥೊ, ತದೆ ಯೋ ಭಾರ ಜ಼ಣ ಶಿಷ್ಯರ್‌ ಯೇಸುಕನ ಐನ್, “ಆ ಅದ್ಮಿನಿ ಝೂ಼ಂಡ್‌ನ ಮೋಕ್ಲಿದೆ, ಅವ್ಣೆ ಅಶ್‌ಪಿಶ್‌ ಛಾ಼ತೆ ಖ್ಹಾರ ಗಾಂಬ್‌ಡಿಮ ಜೈ಼ನ್, ಖಾವಾನ ಖಾಣು, ಖ್ಹುವ್ವಾನ ಝ಼ಗೋನ ಢೂಂಡಿಲ್ಯವಾದೆ. ಶನಕತೊ ಆ ಉಜ್ಜಾ಼ಡಿ ಝ಼ಗೊ” ಕರಿ ಬೋಲ್ಯ. ");
INSERT INTO vaa_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","ತದೆ ಯೇಸುನೆ, “ತುಮೇಸ್ ಅವ್ಣುನ ಖಾಣು ದೆವೊ” ಕರಿ ಇವ್ಣುನ ಬೋಲ್ಯೊ. ತದೆ ಇವ್ಣೆ, “ಹಮಾರಕನ ಪಾಚ಼್ ರೋಟಾ ಅಜು಼ ಬೇ ಮಾಛ಼್‌ಲಾ ಮ್ಹೆಂದಿನ್, ಶಾತ್ಬಿ ಕೊಯ್ನಿ. ಹಮೆ ಜೈ಼ನ್ ಆ ಖ್ಹಾರ ಅದ್ಮಿನಖ್ಹಾಜೆ ಖಾಣು ಮೋಲ್‌ಲೀನ್ ಆವ್ಣುಕಿ ಶು?” ಕರಿ ಪುಛಾ಼ಯ. ");
INSERT INTO vaa_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","ಹಿಜ್ಜಾ಼ ಪರ್ಖ್ಹಾ ಅದ್ಮಿಸ್‌ ಪಾಚ಼್ ಹಜಾ಼ರ್‌ಜ಼ಣು ಥೂ. ತದೆ ಯೇಸುನೆ ಇನ ಶಿಷ್ಯರ್‌ನ, “ಅದ್ಮಿನ ಖ್ಹಾರು ಏಕೇಕ್‌ ಶಾಲ್‌ಮ ಅಡೈವಿಖ್ಹ್‌-ಅಡೈವಿಖ್ಹ್‌ ಅದ್ಮಿ ಕರೀನ್ ಹೇಟ್ ಬೆಖ್ಹಾಡೊ” ಕರಿ ಬೋಲ್ತಾನ, ");
INSERT INTO vaa_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","ಇವ್ಣೆ ಇಮ್ಮಸ್ ಬೆಖ್ಹಾಡ್ಯ. ");
INSERT INTO vaa_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","ಬಾದ್‌ಮ ಯೇಸುನೆ ಯೋ ಪಾಚ಼್ ರೋಟಾ ಅಜು಼ ಬೇ ಮಾಛ಼್‌ಲಾನ ಪಾಡಿಲೀನ್, ಪರಲೋಕ್‌ ಭಣಿ ದೇಖಿನ್, ಯೋ ರೋಟಾ ಅಜು಼ ಮಾಛ್ಲಾ಼ವ್‍ನಟೇಕೆ ದೇವ್ನ ಧನ್ಯವಾದ್ ಕರೀನ್, ಇನ ತೋಡಿನ್, ಅದ್ಮಿ ಖ್ಹಾರಾವ್‌ನ ವಾಟ ಪಡಾನಟೇಕೆ ಶಿಷ್ಯರ್‌ನ ಹಾತ್‌ಮ ದಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","ಅದ್ಮಿಖ್ಹಾರು ಪೇಟ್‌ಭರಿ ಖೈನ್, ಬಶ್‌ಹುಯು ಅಜು಼ ಶಿಷ್ಯರ್‌ನೆ ಉಭ್‌ರ‍್ಯುತೆ ಟುಕ್ಡಾವ್‍ನ ಜ಼ಮಾಕರ್ತಖ್ಹತರ್‌ ಭಾರ ಟೋಕ್ರಾ ಭರಾಯ. ");
INSERT INTO vaa_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","ಏಕ್‌ ದನ್ನೆ ಯೇಸು ಎಕ್ಲೋಸ್ ಪ್ರಾರ್ಥನೆ ಕರುಕರಾನಿ ವಖ್ಹತ್‌ಮ, ಇನ ಶಿಷ್ಯರ್‌ ಇನಾಕನ ಆಯ. ತದೆ ಯೇಸುನೆ ಇವ್ಣುನ, “ಅದ್ಮಿಖ್ಹಾರು ಮೇ ಕೋಣ್ ಕರಿ ಬೋಲಾಸ್?” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","ತದೆ ಶಿಷ್ಯರ್‌ನೆ, “ಥೋಡು ಅದ್ಮಿ ತುನ ಬ್ಯಾಪ್ತಿಸ್ಮದ್ಯವಾಳೊ ಯೋಹಾನ ಕರಿ ಬೋಲಾಸ್, ಅಜು಼ ಥೋಡು ಜ಼ಣು ಎಲೀಯ ಕರಿ ಬೋಲಾಸ್, ಅಜು಼ ಥೋಡು ಜ಼ಣು ಜೂ಼ನ ಹಗಾಮ್‍ನೊ ಪ್ರವಾದೀಮ ಏಕ್‌ ಜ಼ಣೊ ಜಿವ್ತೊಹುಯಿನ್ ಐರ‍್ಹೋಸ್ ಕರಿ ಬೋಲಾಸ್” ಕರಿ ಜವಾಬ್‌ ದಿದಾ. ");
INSERT INTO vaa_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","ಕತೋಬಿ ಯೇಸುನೆ ಇವ್ಣುನ, “ತುಮೆ ಮನ ಕೋಣ್ ಕರಿ ಬೋಲೋಸ್?” ಕರಿ ಪುಛಾ಼ವಖ್ಹತರ್, ಪೇತ್ರನೆ, “ತೂ ದೇವ್‌ನೊ ಕ್ರಿಸ್ತ” ಕರಿ ಜವಾಬ್‌ ದಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","ತದೆ ಯೇಸುನೆ ಇವ್ಣುನ ಅನಿ ಬಾರೇಮ ಕಿನಾಬಿ ನಾ ಬೋಲ್‌ನು ಕರಿ ಝೇತಾಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","ಅನ ಬಾದ್‌ಮ ಯೇಸುನೆ ಇವ್ಣುನ, “ಅದ್ಮಿನೊ ಛಿಯ್ಯೊ ಘಣು ಲತಾಡ ಪಡ್ನು, ಯೆಹೂದ್ಯರ್‌ನು ಶಾಣಾವ್‍ಥೀಬಿ, ಗಲ್‌ಢಯಾಜಕರ್‌ಥಿ ಅಜು಼ ಮೋಶೆನಿ ಧರ್ಮಶಾಸ್ತ್ರ ಶಿಕಾಡವಾಳ ಶಾಸ್ತ್ರಿಯೇಥಿ ಧಕೇಲೈಜಾ಼ಶೆ, ಅಜು಼ ಇನ ಮಾರಿನಾಕ್‌ಶೆ, ಕತೋಬಿ ತೀನ್ ದನ್ನ ಬಾದ್‌ಮ, ಯೋ ಜಿವ್ತೊಹುಯಿನ್ ಉಠಿ ಆವ್‌ಶೆ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","ಅತ್ರೇಸ್ ಕಾಹೆತೆ ಯೇಸುನೆ ಇವ್ಣ ಖ್ಹಾರಾವ್‌ನ ಶಾತ್ ಬೋಲ್ಯೊಕತೊ, “ಕೋಣ್‌ತೋಬಿ ಮಾರ ಜೋ಼ಡೆ ಆವ್ಣುಕರಿ ಉಶೇತೊ, ಇನು ಯೋ ಭೈಕಿಜೈ಼ನ್, ಹರ್‌ದನ್‌ ಇನಿ ಶಿಲ್‌ಬೇನ ಪಳ್ಳಿನ್‌, ಮಾರ ಪೀಠೆ ಆವಾದೆ. ");
INSERT INTO vaa_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","ಕೋಣ್ ಇನೊ ಜಾನ್‌ ಬಚಾ಼ಡಿಲೇವ್ಣುಕರಿ ಕರಾಸ್ಕಿ, ಯೋ ಇನೊ ಜಾನ್‌ ಗುಮೈಲಿಶೆ, ಕತೋಬಿ ಮಾರಖ್ಹಾಜೆ ಕೋಣ್ ಇನೊ ಜಾನ್‌ ಗುಮೈಲಿಶೆಕಿ, ಯೋ ಇನೊ ಜಾನ್‌ ಬಚಿಜಾ಼ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","ಏಕ್‌ ಅದ್ಮಿ ಹಿಡಿ ಜಗತ್‍ನಾಸ್ ಜೂತಿಲೀನ್‌ಬಿ, ಇನೊ ಜಾನ್‌ ಗುಮೈಲಿದೊತೊ, ಇನ ಶನೀಸ್ ಫಾಯಿದೊ ಕೊಯ್ನಿ! ");
INSERT INTO vaa_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","ಕೋಣ್‌ತೋಬಿ ಮನಾಬಿ ಅಜು಼ ಮಾರಿ ವಚನ್ನಖ್ಹಾಜೆಬಿ ಖ್ಹರ್‌ಮಾಯೂತೊ, ಇನ ಅದ್ಮಿನೊ ಛಿಯ್ಯೊ ಯೋಬಿ ಇನ ಬಾನಿ ಪರಿಶುದ್ದ ದೂತರ್‌ನಾಬಿ ಛಾ಼ತೆ ಮಹಿಮೆನಿ ಜೋ಼ಡೆ ಆವಾನಿ ವಖ್ಹತ್‌ಮ ಇನಿ ಬಾರೇಮ ಖ್ಹರ್‌ಮಾವ್‌ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","ತುಮೂನ ಖ್ಹಾಚಾಮ ಬೋಲುಸ್ಕಿ, ಹಜ್ಜಾ಼ ಭಿಯುತೆ ಇವ್ಣಾಮ ಥೋಡು ಜ಼ಣು ದೇವ್ನಿ ರಾಜ್ಯ ದೇಖಾತೋಡಿ ಮರ್‌ಶೆಸ್ ಕೊಯ್ನಿ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","ಯೇಸುನೆ ಆ ಖ್ಹಾರಿ ವಾತೇನ ಬೋಲಿನ್, ಆಟ್‍ದನ್ ಹುವಾನ ಬಾದ್‌ಮ, ಪೇತ್ರ, ಯಾಕೋಬ ಅಜು಼ ಯೋಹಾನ್ನ ಬುಲೈಲಿನ್ ಪ್ರಾರ್ಥನೆ ಕರಾನಖ್ಹಾಜೆ, ಪಹಾಡ್‌ಪರ್ ಗಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","ಯೇಸು ಪ್ರಾರ್ಥನೆ ಕರುಕರಾನಿ ವಖ್ಹತ್‌ಮ, ಇನು ಮ್ಹೋಡು ಬದ್ಲಿಗಯು, ಅಜು಼ ಇನು ಲುಂಗ್ಡು ಧೋಳುಫಟ್‍ಹುಯಿನ್, ಝ಼ಮ್‌ಕಾಲಗ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","ತದ್ದೇಸ್ ಬೇ ಪರ್ಖ್ಹಾ ಇನಜೋ಼ಡೆ ವಾತೆ ಬೋಲುಕರ್ತಾಥ. ಅವ್ಣೆ ಕೋಣ್‌ಕತೊ, ಮೋಶೆ ಅಜು಼ ಎಲೀಯ. ");
INSERT INTO vaa_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","ಅವ್ಣೆ ಪರಲೋಕ್‌ನಿ ಮಹಿಮೆಥಿ ದೆಖೈನ್, ಯೆರೂಸಲೇಮ್ಮ ಯೇಸು ಮರಿನ್‌, ದೇವ್ನಿ ಮರ್ಜಿನ ಪೂರ ಕರ್‌ಶೇತೆ ಇನಿ ಬಾರೇಮ, ಇನಜೋ಼ಡೆ ವಾತೆ ಬೋಲುಕರ್ತೂಥು. ");
INSERT INTO vaa_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","ಪೇತ್ರ ಅಜು಼ ಇನ ಜೋ಼ಡ್ಮ ರ‍್ಹವಾಳು ಭರ್‌ನಿಂದರ್‌ಮ ಥೂ, ಕತೋಬಿ ನಿಂದರ್‌ಮಾಥು ಜಾ಼ಗಿ ಉಠೀನ್, ಯೇಸುನಿ ಮಹಿಮೆನ ಅಜು಼ ಇನಜೋ಼ಡೆ ಭಿಯಾಥಾತೆ ಯೋ ಭೇ ಜ಼ಣಾನಾಬಿ ದೇಖ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","ಮೋಶೆ ಅಜು಼ ಎಲೀಯ ಯೇಸುನ ಮ್ಹೆಂದಿನ್, ಜಾ಼ವಾನಿ ವಖ್ಹತ್‌ಮ, ಪೇತ್ರನೆ ಯೇಸುನ, “ಗುರು, ಹಮೆ ಹಜ಼್ಜಸ್ ರ‍್ಹವಾನು ಕೆತ್ರೇಕ್ಕಿ ಅಛ್ಛು಼! ಹಮೆ ಹಜ಼್ಜಾ ತೀನ್ ಡೇರಾ ಠೋಕೆಸ್, ಏಕ್‌ ತುನ , ಏಕ್‌ ಮೋಶೇನ ಅಜು಼ ಏಕ್‌ ಎಲೀಯನ ” ಕರಿ ಬೋಲ್ಯೊ. ಪೇತ್ರನ, ಯೋ ಶಾತ್ ಬೋಲುಕರಾಸ್‌ ಕರಿ ಇನಾಸ್ ಮಾಲುಮ್ ಕೋ ಥೂನಿ. ");
INSERT INTO vaa_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","ಪೇತ್ರ ಆ ಬೋಲುಕರಾನಿ ವಖ್ಹತ್‌ಮ, ವಾದ್‌ಳು ಐನ್, ಇನೊ ಛಾ಼ಳೊ ಇವ್ಣಾಪರ್ ಢಪಾಯು. ಅನೇಥಿ ಶಿಷ್ಯರ್‌ ಡರಿಗಯು. ");
INSERT INTO vaa_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","ತದೆ ಯೋ ವಾದ್ಳಮಾಥು, “ಆ ಮಾರೊ ಛಿಯ್ಯೊ, ಮೇ ಚೂ಼ಣ್ಯೋತೆ ಅನಾಸ್, ಅನಿ ವಾತೇನ ಖ್ಹಮ್‌ಜೊ಼!” ಕರಿ ಏಕ್‌ ಅವಾಜ಼್ ಆಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","ಯೋ ಅವಾಜ಼್ ಭೀರಿಜಾ಼ವಾನ ಬಾದ್‌ಮ, ಯೇಸು ಎಕ್ಕಸ್ ಜ಼ಣಾನ ದೇಖ್ಯು. ಯೋ ಶಿಷ್ಯರ್‌ ಇವ್ಣೆ ದೇಖ್ಯುತೆ ಇನಿ ಬಾರೇಮ, ಏಕ್‌ ಜ಼ಣಾನಾಬಿ ಯೋ ದನೂಮ ಬೋಲ್ಯುಕೊಂತೆ ಖ್ಹೊಪೊ ಪಡಿಗಯು. ");
INSERT INTO vaa_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","ತಿನ ಅಗ್‍ಲ್ಯ ದನ್ನೆ ಯೇಸು ಅಜು಼ ಇನ ತೀನ್ ಶಿಷ್ಯರ್‌ ಪಹಾಡ್ ಉತ್ರಿನ್ ಆಯ. ತದೆ ಅದ್ಮಿನಿ ಮೋಟಿ ಭೀಡ್‌ ಯೇಸುನ ಖ್ಹಾಮ್ಣೆ ಆಯಿ. ");
INSERT INTO vaa_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","ಯೋ ಭೀಡ್‌ಮಾಥು ಏಕ್‌ಜ಼ಣಾನೆ, “ಗುರು, ಮಾರ ಛಿಯ್ಯಾನ ದೇಕ್‌ಕರಿ, ತುನ ಗಿಂಗಾವುಸ್. ಮನ ಆ ಎಕ್ಕಸ್ ಛಿಯ್ಯೊ ಛಾ಼ತೆ. ");
INSERT INTO vaa_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","ಅನ ಭೂತ್ ಧರಾಸ್, ಧರ್‌ತಾಸ್‌ನ ಆ ಬಳೆಳಾಲಗಸ್, ಮ್ಹೋಡವಾಟೆ ಜ಼ಲ್‌ಭು ನಿಕ್ಳಾ ಏತ್ರೆ ಅನ ಧಡಾಶ ಮರಾವಸ್, ಅಜು಼ ಘಣು ಖ್ಹತೈನ್, ಝ಼ಗ್‌ದಾಶೆ ಯೋ ಭೂತ್ ಅನ ಮ್ಹೇಲಾಕೊಯ್ನಿ! ");
INSERT INTO vaa_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","ಯೋ ಭೂತ್‌ನ ಕಾಡೊ ಕರಿ, ತಾರ ಶಿಷ್ಯರ್‌ನ ಗಿಂಗೈಲಿದೊ. ಕತೋಬಿ ಇವ್ಣ ಹಾತೆ ಕೋ ಹುಯೋನಿ” ಕರಿ ಚಿಕ್ರಿನ್ ಯೇಸುನ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","ತದೆ ಯೇಸುನೆ, “ಏ ವಿಶ್ವಾಸ್‌ಕೊಂತೆ ಖರಾಬ್ ಪಿಳ್ಗಿಯೆ, ಮೇ ಬಿಜು಼ ಕೆತ್ರ ದನ್ ತುಮಾರ ಜೋ಼ಡೆ ರ‍್ಹೀನ್, ತುಮೂನ ಖ್ಹಮಾಳ್‌ಣು?” ಕರೊ ಜ಼ವಾಬ್‌ದಿದೊ. ಅಜು಼ ಯೋ ಅದ್ಮಿನ, “ತಾರ ಛಿಯ್ಯಾನ ಹಜ಼್ಜಾ ಬುಲೈಲಿ ಆವ್” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","ಯೋ ಛೋ಼ಕ್ರು ಆವ್‍ಕರಾನಿ ವಖ್ಹತ್‌ಮ, ಯೋ ಭೂತ್‌ ಇನ ಜ಼ಮೀನ್‌ಪರ್ ರಡ್‌ಕೈನ್‌, ಘಣು ಧಡಾಶ ಮರಾಯು. ಕತೋಬಿ ಯೇಸುನೆ ಯೋ ಭೂತ್‌ನ ಗುರ್‌ಕೈನ್, ಯೋ ಛೋ಼ಕ್ರಾನ ಅಛ್ಛು಼ ಕರೀನ್, ಇನ ಬಾನ ಹಾತ್‌ಮ ದಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","ಅನ ದೇಖಿನ್ ಅದ್ಮಿಖ್ಹಾರು ದೇವ್ನಿ ಮಹಾನ್ ಶಕತ್ನಖ್ಹಾಜೆ ಆಶ್ಚರ್ಯಖಾದು. ಅದ್ಮಿಖ್ಹಾರು ಯೇಸುನೆ ಕರ‍್ಯೊತೆ ಖ್ಹಾರಿಸ್ ಕಾಮ್ನಿ ಬಾರೇಮ ಬಿಜೂ಼ಬಿ ಆಶ್ಚರ್ಯ ಕರುಕರಾತೆ ತದ್ದೇಸ್, ಯೇಸುನೆ ಇನ ಶಿಷ್ಯರ್‌ನ, ");
INSERT INTO vaa_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“ಮೇ ಬೋಲುಕರುಸ್ತೆ ವಾತೇನ ಭೈಕ್‌ಶು ನಕೊ; ಅದ್ಮಿನ ಛಿಯ್ಯಾನ ಅದ್ಮಿಖ್ಹಾರಾನ ಹಾತ್‌ಮ ದೆವೈಜಾಶೆ” ");
INSERT INTO vaa_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","ಕತೋಬಿ ಇನ ಶಿಷ್ಯರ್‌ನೆ ಅನಿ ಮತ್ಲಬ್‌ನ ಪರ್‌ಖ್ಯುಕೊಯ್ನಿ. ಯೋ ವಾತೆ ಇವ್ಣೇಥಿ ಲಪೈರ‍್ಹೀಥೀತೆ ಇನಖ್ಹಾಜೆ, ಇವ್ಣೆ ಮಾಲುಮ್ ಕರ‍್ಯುಕೊಯ್ನಿ. ಅಜು಼ ಅನಿ ಬಾರೇಮ ಯೇಸುನ ಬೋಲಾನ ಡರಿಗಯು. ");
INSERT INTO vaa_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","ಶಿಷ್ಯರ್‌ಮ ಕೋಣ್ ಮೋಟೊ ಕರಿ ಬೋಲಾನಿ ಬಾರೇಮ ವಾತೆ ನಿಕ್ಳಾಲಗಿ. ");
INSERT INTO vaa_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","ತದೆ ಯೇಸುನೆ ಇವ್ಣಿ ದಿಲ್ನಿ ವಾತೇನ ಮಾಲುಮ್ ಕರಿಲೀನ್, ಏಕ್‌ ಅಡ್ಡಾಣಿ ಲಡ್ಕಾನ ಬುಲೈನ್, ಇನ ಪಾಕ್ತಿಮ ಭಿರಾಖಿನ್, ");
INSERT INTO vaa_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","ಇವ್ಣುನ ಬೋಲ್ಯೊಕಿ, “ಕೋಣ್‌ತೋಬಿ ಏಕ್‌ ಜ಼ಣು ಮಾರ ನಾಮ್‌ಪರ್‌ ಆ ಅಡ್ಡಾಣಿ ಲಡ್ಕಾನ ಬುಲೈಲೇಸ್ಕಿ, ಇವ್ಣೆ ಮನ ಬುಲೈಲ್ಯವಾದಾಖ್ಹಲ್‌; ಅಜು಼ ಕೋಣ್ ಮನ ಬುಲೈಲೇಸ್ಕಿ, ಯೋ ಮನ ಮೋಕ್‌ಲ್ಯೊತೆ ಇನಾಸ್ ಬುಲೈಲ್ಯವಾದಾಖ್ಹಲ್‌. ಇನಖ್ಹಾಜೇಸ್ ತುಮಾರಾಮ ಕೋಣ್ ನ್ಹಾನೋಕಿ ಯೋಸ್ ಖ್ಹಾರೇಥಿ ಮೋಟೊ ಹುಯಿರ‍್ಹಿಶೆ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","ಯೋಹಾನನೆ, “ಗುರು, ಕೋಣ್‌ಕಿ ಏಕ್‌ ಜ಼ಣು ತಾರು ನಾಮ್ ಬೋಲಿನ್ ಭೂತ್ ನಖ್ಹಾಡುಕರ್ತುಥೂತೆ ಹಮೆ ದೇಖಿನ್, ಯೋ ಹಮಾರ ಭಣಿವಾಳು ಕಾಹೆತೆ ಇನಖ್ಹಾಜೆ, ಹಮೆ ಇನ ‘ಭಿರಾಕಡ್ ಕರಿ ಬೋಲ್ಯ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","ಅನ ಖ್ಹಮ್‌ಜಿನ್‌, ಯೇಸುನೆ ಯೋಹಾನ್ನ ಅಜು಼ ಬಿಜಾ಼ಖ್ಹಾರ ಶಿಷ್ಯರ್‌ನ, “ಇನ ನಕೊ ಭೀರಾಖೊ. ಶನಕತೊ ತುಮೂನ ವಹೇರ್‌ ಕರಾಕೊಂತೆ ಇವ್ಣೆ ತುಮಾರ ಭಣಿವಾಳುಸ್ ಹುಯಿರ‍್ಹೂಸ್” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","ಯೇಸು ಪರ್‌ಲೋಕ್‌ಮ ಪಡೈಲೆವಾನಿ ವಖ್ಹತ್ ಖನ್ನೆ ಆವಲಗಿಥೀತೆ ಇನಖ್ಹಾಜೆ, ಯೋ ಯೆರೂಸಲೇಮ್‌ನ ಜಾ಼ವಾನಟೇಕೆ ಘಟ್‌ಜಾನ್ ಕರಿಲೀನ್, ");
INSERT INTO vaa_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","ಇನೇಥಿ ಅಗಾಡಿ ಟಪಾಲ್ ದ್ಯವಾಳಾನ ಮೋಕ್‌ಲ್ಯೊ. ಅವ್ಣೆ ಜೈ಼ನ್ ಯೇಸುನ ಹೋಣುತೆಖ್ಹಾರು ಖ್ಹವಾರನಖ್ಹಾಜೆ ಸಮಾರ್ಯವಾಳಾನು ಗಾಮ್ಮ ಆಯು. ");
INSERT INTO vaa_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","ಯೇಸು ಯೆರೂಸಲೇಮ್‌ನ ಒಳೆಜಾ಼ತೊಥೋತೆ ಇನಖ್ಹಾಜೆ, ಹಿಜ್ಜಾ಼ನು ಅದ್ಮಿ ಇನ ಬುಲೈಲಿದುಕೊಯ್ನಿ. ");
INSERT INTO vaa_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","ಅನ ದೇಖಿನ್, ಯೇಸುನು ಶಿಷ್ಯರ್‌ ಯಾಕೋಬ ಅಜು಼ ಯೋಹಾನನೆ, “ಪ್ರಭು, ಪರಲೋಕ್‌ಥು ಆಗ್ ಪಡೀನ್, ಅವ್ಣುನ ಬರ್ಬಾತ್ ಕರ್‌ ಕರಿ, ಹಮೆ ಹುಕುಮ್ ದೇವ್ಣು ಕರಿ, ತೂ ಆಖ್ಹ್‌ಕರಾಸ್ಕಿ ಶು?” ಕರಿ ಪುಛಾ಼ವಖ್ಹತರ್, ");
INSERT INTO vaa_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","ಯೇಸುನೆ ಫರಿನ್, ಇವ್ಣುನ ಗುರ್‌ಕಾಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","ಬಾದ್‌ಮ ಇವ್ಣೆ ಬಿಜ಼ ಗಾಮ್‌ನ ಗಯು. ");
INSERT INTO vaa_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","ಇವ್ಣೆ ವಾಟ್‌ಪರ್ ಜಾ಼ತುರ‍್ಹವಾನಿ ವಖ್ಹತ್‌ಮ, ಕೋಣ್ಕಿ ಏಕ್‌ ಜ಼ಣು ಯೇಸುನ, “ತು ಕಿಜ್ಗಾ಼ ಗಯೊತೋಬಿ ಮೇ ತಾರ ಪೀಠೇಸ್ ಆವ್‌ಸ್” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","ತದೆ ಯೇಸುನೆ ಇನ, ‘ನ್ಹೋರಿಯೆನ ಘವಿಯೆ ಛಾ಼, ಅಜು಼ ಆಬ್‌ಪರ್ ಉಡಾತೆ ಜಿನಾವರ್‌ನ ಖ್ಹಾರು ಮ್ಹಾಳೊ ಛಾ಼, ಕತೋಬಿ ಅದ್ಮಿನ ಛಿಯ್ಯಾನ ಮುಡ್‌ಕ್ಯು ಟೇಕಯೆವ್ಡಿ ಝ಼ಗೋಬಿ ಕೊಯ್ನಿ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","ಅಜು಼ ಇನೆ ಬಿಜೇಕ್ ಜ಼ಣಾನ, “ಮಾರ ಪೀಠೆ ಆವ್” ಕರಿ ಬೋಲ್ಯೊ. ಕತೋಬಿ ಇನೆ, “ಪ್ರಭು, ಮೇ ಪಹಿಲೆ ಜೈ಼ನ್‌ ಮಾರ ಬಾನ ಧಪ್‌ನೈದೀನ್‌ ಆವಾನ ಮನ ಹುಕುಮ್ ದೆ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","ತದೆ ಯೇಸುನೆ ಇನ, “ಮರ‍್ಯಹುಯಾಸ್‌ ಇವ್ಣಮ ಮರಿಗಯೂತೆ ಇನ ಮಾಟಿ ಕರಾದೆ! ತೂ ಜೈ಼ನ್, ದೇವ್ನಿ ರಾಜ್ಯನಿ ಬಾರೇಮ ಬೋಲಿವತಾಳ್” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","ಬಿಜ್ಜೇಕ್‌ ಜ಼ಣಾನೆ, “ಪ್ರಭು, ಮೇ ತಾರ ಪೀಠೆ ಆವುಸ್, ಕತೋಬಿ ಮಾರ ಘರ್‌ವಾಳಕನ ಪಹಿಲೆ, ‘ಜೈ಼ನ್ ಆವುಸ್’ ಕರಿ ಬೋಲಿನ್ ಆವುಸ್” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","ತದೆ ಯೇಸುನೆ ಇನ, “ನಾಗರ್‌ಪರ್ ಹಾತ್‌ ನಾಖಿನ್, ಪೀಠೆಫರಿ ದೇಖಾವಾಳು ಕೋಣ್‌ಬಿ, ದೇವ್ನಿ ರಾಜ್ಯನ ಲ್ಹಾಯೇಕ್‌ನು ಕಾಹೆ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","ಅನ ಬಾದ್‌ಮ ಯೇಸು ಪ್ರಭು ಬಿಜೂ಼ಬಿ ಬೇ ಉಪ್ಪರ್ ಖ್ಹಡ್‌ತೀನಿಖ್ಹ್ ಜ಼ಣಾನ ಚೂ಼ಣಿನ್, ಬೆಬ್ಬೆ ಜ಼ಣ ಕರೀನ್, ಯೋ ಜಾ಼ವ್ಣುಕರಿ ಥೋತೆ ಹರೇಕ್ ಗಾಮ್‌ನ ಅಜು಼ ಝ಼ಗೋನ ಇನೇಥಿ ಅಗಾಡಿ ಇವ್ಣುನ ಮೋಕ್‌ಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","ಮೋಕ್ಲಾನಿ ವಖ್ಹತ್‌ಮ ಇವ್ಣುನ, “ಅನಾಜ಼್ ಜಾ಼ಖ್ಹತ್ ಛಾ಼, ಕತೋಬಿ ಎಕ್ಟು ಕರಾನ ಕಾಮ್ ಕರಾವಾಳು ಕಮ್ ಛಾ಼. ಇನಖ್ಹಾಜೆ ಅನಾಜ಼್‌ನೊ ಪ್ರಭುನ ‘ತಾರು ಅನಾಜ಼್‌ನ ಎಕ್ಟು ಕರಾನಖ್ಹಾಜೆ ಕಾಮ್‌ವಾಳಾನ ಮೋಕಲ್’ ಕರಿ ಬಿಂತಿ ಕರೊ. ");
INSERT INTO vaa_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","ಜಾ಼ವೊ! ಜ಼ರಕ್‌ನ ಮಹಿ ಮೇಂಢಾವ್ನ ಮೋಕ್ಲಾತೆ ಇಮ್‌, ಮೇ ತುಮೂನ ಮೋಕ್ಲುಕರುಸ್. ");
INSERT INTO vaa_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","ದೇಖೊ, ಪೈಶಾನಿ ಚ಼ಂಚಿ ರ‍್ಹವೊ, ಮಾಂಗಾನಿ ಝೋ಼ಳಿ ರ‍್ಹವೊ, ಖೋಖ್ಹ್‌ಡಾ ರ‍್ಹವೊ ನಕೊ ಲೀಜಾ಼ವೊ. ಜಾ಼ವಾನಿ ವಖ್ಹತ್‌ಮ, ವಾಟ್‌ಪರ್ ಕಿನಾಬಿ ಖ್ಹಲಾಮ್ ಕರಿ ಬೋಲಿನ್, ವಖ್ಹತ್ ಬರ್ಬಾತ್ ನಕೊ ಕರ್ಶು. ");
INSERT INTO vaa_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","ಎತ್ರೇಸ್ ಕಾಹೆತೆ ತುಮೆ ಖೆವ ಘರ್‌ಮ ಗಯಾತೋಬಿ, ‘ಆ ಘರ್‌ನ ಶಾಂತಿ ಹುವಾದೆ’ ಕರಿ ಬೋಲೊ. ");
INSERT INTO vaa_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","ಶಾಂತಿಥಿ ರ‍್ಹವಾನ ಆಖ್ಹ್ ಕರಾವಾಳು ಅದ್ಮಿ ಹಿಜ್ಜಾ಼ ರ‍್ಹಯೂತೊ, ತುಮಾರಿ ಆಶೀರ್ವಾದ್‌ ಇನಾಪರ್ ಟಿಕ್‌ಶೆ, ನತರ್‌ಕಿ ಯೋ ಆಶೀರ್ವಾದ್‌ ಪಾಛು಼ಫರಿ ತುಮೂನ ಆವ್‌ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","ಯೋಸ್ ಘರ್‌ಮ ರ‍್ಹವಾಕರೊ, ಇವ್ಣೆ ಶಾತ್‌ ದೇಸ್ಕಿ ಯೋ ಖಾವೊ, ಪೀಯೊ. ಕಾಮ್ ಕರಾವಾಳ ಆಳ್‌ ಕೂಲಿನ ಲ್ಹಾಯೇಕ್ ಎತ್ರೇಸ್. ಇನಖ್ಹಾಜೆ ಏಕ್‌ ಘರ್‌ನ ಮ್ಹೆಂದಿನ್ ಬಿಜೇಕ್ ಘರ್‌ಮ ಜೈ಼ನ್ ನಕೊ ರ‍್ಹವೊ. ");
INSERT INTO vaa_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","ಅಜು಼ ತುಮೆ ಖೆವಾತೋಬಿ ಏಕ್‌ ಗಾಮ್ಮ ಜಾ಼ವಾನ ಬಾದ್‌ಮ, ಹಿಜ್ಜಾ಼ನು ಅದ್ಮಿ ತುಮೂನ ಬುಲೈಲಿದೊತೊ, ಇವ್ಣೆ ಶಾತ್‌ ದೇಸ್ಕಿ ಯೋ ಖಾವೊ. ");
INSERT INTO vaa_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","ಹಿಜ್ಜಾ಼ ರೋಗ್-ರಾಯಮ ರ‍್ಹೇಸ್ತೆ ಇವ್ಣ ಅಛ್ಛು಼ಕರೊ, ಅಜು಼ ಹಿಜ್ಜಾ಼ನು ಅದ್ಮಿಖ್ಹಾರಾನ ದೇವ್ನಿ ರಾಜ್ಯ ತುಮಾರ ಖನ್ನೆ ಐರ‍್ಹೀಸ್ ಕರಿ ಬೋಲೊ. ");
INSERT INTO vaa_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","ಕತೋಬಿ ತುಮೆ ಖೆವಾತೋಬಿ ಏಕ್‍ ಗಾಮ್ಮ ಜಾ಼ವಾನ ಬಾದ್‌ಮ, ಹಿಜ್ಜಾ಼ನು ಅದ್ಮಿ ತುಮೂನ ನಾ ಬುಲೈಲಿದುತೊ, ಯೋ ಗಾಮ್‌ನಿ ಗಲ್ಲಿಯೇಮ ಜೈ಼ನ್, ");
INSERT INTO vaa_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘ಹಮಾರ ಗೋಡಾನ ಲಾಗೀತೆ, ತುಮಾರ ಗಾಮ್‌ನಿ ಧೂಳ್‌ನ ಜಿನ್‌ಕುಬಿ, ಹಮೆ ತುಮಾರಿ ವಿರೋದ್‌ ಝ಼ಟ್ಕಿ ದೆವ್‌ಕರೇಸ್. ಕತೋಬಿ ದೇವ್ನಿ ರಾಜ್ಯ ತುಮಾರ ಖನ್ನೆ ಐರ‍್ಹೀಸ್ ಕರಿ ತುಮೂನ ಮಾಲುಮ್ ರ‍್ಹವಾದೆ ಕರಿ ಬೋಲೊ.’ ");
INSERT INTO vaa_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","ಮೇ ತುಮೂನ ಬೋಲುಸ್ಕಿ, ನ್ಯಾವ್‍ನಿ ತೀರ್ಪ್‌ನ ದನ್ಮ ಯೋ ಗಾಮ್‌ನಿ ಹಾಲ್‌, ಸೊದೋಮ್ ಗಾಮ್‌ನಿ ಹಾಲ್‌ಥೀಬಿ ಖರಾಬ್ ರ‍್ಹಿಶೆ. ");
INSERT INTO vaa_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","ಅಯ್ಯೋ, ಖೊರಾಜಿನ್‌ ಖ್ಹಯೇರ್‌, ತಾರಿ ಹಾಲ್ನ ಶಾತ್‌ಬೋಲು ಬೆತ್ಸಾಯಿದ ತುಮಾರಿ ಹಾಲ್ನ ಶಾತ್‌ ಬೋಲು! ತುಮಾರಾಮ ಚಾ಼ಲ್ಯುತೆ ಮಹಾನ್ ಕಾಮ್‌ಖ್ಹಾರು ತೂರ್ ಅಜು಼ ಸೀದೋನ್ ಖ್ಹಯೇರ್‌ಮ ಚಾ಼ಲ್ಯುಹೋತ್ತೊ, ಹಿಜ್ಜಾ಼ವಾಳು ಕದೇಸ್‌ಕಿ ಛೈ಼ನೊಕೋಥ್‌ಳೊ ಲಪೇಟಿಲೀನ್, ರಾಕ್‌ಮ ಬೇಶಿನ್, ದೇವ್ ಭಣಿ ಫರಿಗಯೂಹೋತ್. ");
INSERT INTO vaa_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","ಕತೋಬಿ ನ್ಯಾವ್‍ನಿ ತೀರ್ಪ್‌ನ ದನ್ಮ ತುಮೂನ ಉಷೇತೆ ಹಾಲ್‌ಥೀಬಿ ತೂರ್ ಅಜು಼ ಸೀದೋನ್ ಖ್ಹಯೇರ್‌ನ ಹುಯುತೆ ಹಾಲತ್ಪರ್ ದೇವ್‌ ಘಣು ಗೋರ್‌ ಕರ್ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","ಕಪೆರ್ನೌಮ್, ತೂ ಪರಲೋಕ್‌ನ ಚ಼ಢೀನ್ ಜೈ಼ಶ್‌ನ? ಕೊಯ್ನಿ! ತುನ ಪಾತಾಳ್ಮ ನಾಕ್‌ಶೆ! ");
INSERT INTO vaa_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","ಯೇಸುನೆ ಇವ್ಣುನ, “ತುಮಾರಿ ವಾತೇನ ಖ್ಹಮ್‌ಜಾ಼ವಾಳು ಮಾರಿ ವಾತೆ ಖ್ಹಮ್‌ಜಾ಼ವಾಳು ಹುಯಿರ‍್ಹೂಸ್; ತುಮೂನ ಝಿಟ್ಕಾರವಾಳು ಮನ ಝಿಟ್ಕಾರವಾಳು ಹುಯಿರ‍್ಹೂಸ್; ಮನ ಝಿಟ್ಕಾರವಾಳು ಮನ ಮೋಕ್‌ಲ್ಯೊತೆ ಇನಾಸ್ ಝಿಟ್ಕಾರವಾಳು ಹುಯಿರ‍್ಹೂಸ್” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","ಯೋ ಬೇ ಉಪ್ಪರ್ ಖ್ಹಡ್‌ತೀನಿಖ್ಹ್ ಜ಼ಣು ಘಣು ಖ್ಹುಶಿಥಿ ಪಾಛು಼ಫರಿ ಆಯಿನ್, “ಪ್ರಭು, ತಾರು ನಾಮ್ ಬೋಲ್ತಾನ ಭೂತ್‌ಖ್ಹಾರು ಜಿನ್‌ಕುಬಿ ಹಮಾರಿ ಹುಕುಮ್‌ನ ಮಾನ್ಯು” ಕರಿ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","ತದೆ ಯೇಸುನೆ ಇವ್ಣುನ, “ಶೈತಾನ್ ವಿಜ಼್‌ಳೀನಿಮತ್‌ ಪರ್‌ಲೋಕ್‌ಥು ಹೇಟ್ ಪಡಾತೆ ಮೇ ದೇಖ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","ಹಂದೇಖೊ, ಖ್ಹಾಪ್‌ಪರ್‌ಬಿ, ವಿಛ್ಛಿಪರ್‌ಬಿ ಚಾ಼ಲಾನ ಅಜು಼ ದುಶ್‌ಮನ್ನಿ ಖ್ಹಾರೀಸ್‍ ಶಕತ್ನ ಹರಾವನ ಮೇ ತುಮೂನ ಅದಿಕಾರ್ ದೀರಾಖ್ಯೊಸ್. ಕೆಹೂಬಿ ತುಮೂನ ಖರಾಬ್ ಕೋ ಕರ್‌ಶೇನಿ. ");
INSERT INTO vaa_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","ಕತೋಬಿ ಭೂತ್‌ಖ್ಹಾರು ತುಮಾರಿ ವಾತೇನ ಖ್ಹಮ್‌ಜಾ಼ಸ್‌ ಕರಿ ಬೋಲಿನ್ ಖ್ಹುಶಿ ನಕೊ ಕರೊ, ತುಮಾರು ನಾಮ್‌ಖ್ಹಾರು ಪರ್‌ಲೋಕ್‌ಮ ಲೀಖೈರ‍್ಹುಸ್ ಕರಿ ಬೋಲಿನ್ ಖ್ಹುಶಿ ಕರೊ”. ");
INSERT INTO vaa_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","ಯೋಸ್ ವಖ್ಹತ್‌ಮ ಯೇಸು ಪವಿತ್ರಾತ್ಮಥಿ ಖ್ಹುಶಿಹುಯಿನ್, ಅಮ್ ಪ್ರಾರ್ಥನೆ ಕರ‍್ಯೊ, “ಬಾ, ಸೊರ್ಗ ಅಜು಼ ಧರ್ತಿನೊ ಯಜಮಾನ್! ಮೇ ತುನ ಧನ್ಯವಾದ್‌ ಕರುಸ್. ಶನಕತೊ ತುನೆ ಗ್ಯಾನಿ ಅಜು಼ ಅಕ್ಲಿಥಿ ಆ ವಾತೇನ ಲಪಾಡಿನ್, ಲಡ್ಕಾವ್ನ ಮಾಲುಮ್ ಕರೈರಾಖ್ಯೋಸ್. ಓಹೋಲಾ ಬಾ, ಅಮ್ಮಸ್ ತೂ ಕರ‍್ನು ಕರಿ ಥೊ. ");
INSERT INTO vaa_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","ಮಾರೊ ಬಾ ಮನ ಖ್ಹಾರುಸ್‌ ಮಾರ ಹಾತ್ಮ ದೀರಾಖ್ಯೊಸ್, ಛಿಯ್ಯೊ ಕೋಣ್ ಕರಿ ಬಾನಸ್ ಮಾಲುಮ್ ಪಣ್ಕಿ ಬಿಜಾ಼ನ ಕಾಹೆ. ಬಾ ಕೋಣ್ ಕರಿ ಛಿಯ್ಯೋಸ್ ಪಣ್ಕಿ ಬಿಜು಼ ಕೋಣ್‌ಬಿ ಮಾಲುಮ್ ಕೋಕರಿರಾಖ್ಯೂನಿ. ಅಜು಼ ಛಿಯ್ಯೊ, ಕಿನ ಬಾನಿ ಬಾರೇಮ ಮಾಲುಮ್ ಕರಾವಸ್ಕಿ, ಇವ್ಣೆಸ್ ಬಾನ ಮಾಲುಮ್‌ ಕರಿಲ್ಯವಾಳು ಹುಯಿರ‍್ಹೂಸ್”. ");
INSERT INTO vaa_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","ಅನ ಬಾದ್‌ಮ ಯೇಸುನೆ ಇನ ಶಿಷ್ಯರ್‌ ಭಣಿ ಫರೀನ್, ಖಲಿ ಇವ್ಣುನ ಬೋಲ್ಯೋಕಿ, “ತುಮೆ ದೇಖುಕರಾಸ್ತೆ ಆ ಖ್ಹಾರು ದೇಖವಾಳು ಧನ್ಯರ್ ಹುಯಿರ‍್ಹೂಸ್! ");
INSERT INTO vaa_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","ಶನಕತೊ ಘಣು ಪ್ರವಾದಿಖ್ಹಾರು ಅಜು಼ ರಾಜ಼ಖ್ಹಾರು ತುಮೆ ದೇಖುಕರಾತೆ ಆ ಖ್ಹಾರಾನ ದೇಕ್ಣು ಕರಿ ಆಖ್ಹ್ ಕರ‍್ಯುತೋಬಿ, ಇವ್ಣೆ ದೇಖ್ಯು ಕೊಯ್ನಿ. ತುಮೆ ಖ್ಹಮ್‌ಜು಼ಕರಾತೆ ಖ್ಹಮಜ಼್‌ಣು ಕರಿ ಆಖ್ಹ್‌ ಕರ‍್ಯುತೋಬಿ ಖ್ಹಮ್‌ಜ್ಯು ಕೊಯ್ನಿ ಕರಿ ಮೇ ತುಮೂನ ಬೋಲುಸ್”. ");
INSERT INTO vaa_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","ತದೆ ಮೋಶೇನು ಧರ್ಮಶಾಸ್ತ್ರ ಶಿಕಾಡವಾಳು ಶಾಸ್ತ್ರಿ ಏಕ್‌ ಜ಼ಣು ಉಠಿ ಐನ್, ಯೇಸುನ ಖ್ಹಪ್‌ಡಾವ್ಣು ಕರಿ, “ಗುರು, ಹಮೇಶಾನಿ ಜಿ಼ಂದ್‌ಗಿ ಮಳ್‌ಣುಕತೊ ಮೇ ಶಾತ್‌ ಕರ‍್ನು? ಕರಿ ಯೇಸುನ ಫುಛಾ಼ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","ತದೆ ಯೇಸುನೆ ಇನ, “ಮೋಶೇನು ಧರ್ಮಶಾಸ್ತ್ರಮ ಶಾತ್‌ ಲಿಖೈರ‍್ಹುಸ್? ಇನ ತೂ ಕಿಮ್ ಪಢ್ಯೋಥೊ?” ಕರಿ ಪುಛಾ಼ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","ಇನೆ ಜವಾಬ್‌ ದಿದೋಕಿ, “ತಾರೊ ದೇವ್ ಹುಯಿರ‍್ಹೋತೆ ಪ್ರಭುನ, ತಾರೊ ಪೂರ ದಿಲ್‌ಥೀಬಿ, ತಾರೊ ಪೂರ ಜಾನ್‍ಥೀಬಿ, ತಾರಿ ಪೂರ ಶಕತ್‌ಥೀಬಿ, ತಾರೊ ಪೂರ ಮನ್‌ಥೀಬಿ ಪ್ಯಾರ್ ಕರ‍್ನು, ಅಜು಼ ತಾರ ಭೀಡೆವಾಳಾನ ತಾರೀನಿಘೋಣಿಸ್ ಪ್ಯಾರ್ ಕರ‍್ನು ಕರಿ ಲಿಖೈರ‍್ಹುಸ್” ಕರಿ ಜವಾಬ್‌ ದಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","ಯೇಸುನೆ ಇನ, “ತುನೆ ಬರಾಬರ್‌ಥಿ ಜವಾಬ್‌ ದಿದೊ. ಇಮ್ಮಸ್ ಕರ್‌, ತದೆ ತೂ ಕದೇಬಿ ಜಿವ್ತು ರ‍್ಹೀಶ್ ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","ಕತೋಬಿ ಯೋ ಅದ್ಮಿ ಇನುಯೋಸ್ ಖ್ಹಾಚು಼ ಕರಿ ಬೋಲಿ ವತಾಳಿಲ್ಯಾವನಖ್ಹಾಜೆ ಆಖ್ಹ್‌ಕರೀನ್, “ಮಾರು ಭೀಡೆವಾಳು ಕತೊ ಕೋಣ್?” ಕರಿ ಯೇಸುನ ಪುಛಾ಼ವಖ್ಹತರ್; ");
INSERT INTO vaa_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","ಯೇಸು ಇನ ಜವಾಬ್‌ ದೇತೊಹುಯಿನ್ ಬೋಲ್ಯೋಕಿ, “ಏಕ್‌ ಅದ್ಮಿ ಯೆರೂಸಲೇಮ್‌ಥು ಟೇಕ್ಡಿ ಉತ್ರಿನ್, ಯೆರಿಕೋ ಜಾ಼ವಾನಿ ವಖ್ಹತ್‌ಮ, ಚೋ಼ರ‍್ನ ಹಾತ್‌ಮ ಖ್ಹಪ್‌ಡಿಗಯು. ಇವ್ಣೆ ಇನಾಕನ ಥೂತೆ ಖ್ಹಾರೂಸ್ ಲೂಟಿಲೀನ್, ಮರ್‌ವಾಯೆತ್ರೆ ಮಾರ್‌ತೋಡ್ ಕರೀನ್, ಮ್ಹೆಂದಿನ್ ಚ಼ಲ್ಯೂಗಯು. ");
INSERT INTO vaa_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","ತದೆ ಕಿಮ್ಕಿ, ಏಕ್‌ ಯಾಜಕ್ ಯೋಸ್ ವಾಟೆಕರಿ ಉತ್ರಿನ್ ಜಾ಼ವಾನಿ ವಖ್ಹತ್‌ಮ, ಇನ ದೇಖಿನ್, ವೇಢೀನ್ ಚ಼ಲೆಗಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","ಇಮ್ಮಸ್ ಏಕ್‌ ಲೇವಿಬಿ ಯೋ ಝ಼ಗೋಕನ ಆಯಿನ್, ಇನ ದೇಖಿನ್, ಮ್ಹೋಡು ಕರ್ವಟ್‌ ಕರಿಲೀನ್, ಬಿಜೇಕ್ ವಾಟೆ ಚ಼ಲೆಗಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","ಕತೋಬಿ ಏಕ್‌ ಸಮಾರ್ಯವಾಳು ಚಾ಼ಲ್ತೊಹುಯಿನ್‌, ಯೋ ಥೋತೆ ಹಿಜ್ಜಾ಼ ಐನ್, ಇನ ದೇಖಿ ಗೋರ್‌ಖೈನ್, ");
INSERT INTO vaa_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","ಇನ ಖನ್ನೆ ಜೈ಼ನ್, ಇನ ಘಾವ್‌ಪರ್ ತೇಲ್ ಅಜು಼ ದ್ರಾಕ್ಷಿನು ಕಂದಾಯುಹುಯು ರಖ್ಹ್‌ನ ನಾಖಿನ್, ಭಾಂದ್ಯು. ಅಜು಼ ಇನು ಶೊಂತ್ ಪಾಳ್ಯುಹುಯಾ ಜಾನ್ವರ್‌ಪರ್ ಇನ ಪಳ್ಳಿನ್‌, ಮಂಡಪ್‌ಕನ ಬುಲೈಲಿ ಜೈ಼ನ್, ಇನಿ ಚಾ಼ಕ್ರಿ ಕರ‍್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","ತಿನವ್ಹಾಣೆ ಯೋ ಸಮಾರಿಯವಾಳಾನೆ ಬೇ ರೂಪಾನು ಬಿಲ್ಲಾನ ಕಾಡಿನ್, ಛತ್ತರ್‌ವಾಳಾನ ದೀನ್, “ಅನ ದೇಕ್-ಭಾಲ್ ಕರ್‌, ಆ ಪೈಶಾಥಿ ಜಾ಼ಖ್ಹತ್ ಶಾತ್‌ತೋಬಿ ಖರ್ಚಿ ಹುಯೂತೊ, ಮೇ ಪಾಛೊ಼ಫರಿ ಆಯಿಶ್‍ತೆ ತದೆ ತುನ ದಿಶ್” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","“ಆ ತೀನ್ ಜ಼ಣಾಮ ಚೋ಼ರ್‌ನ ಹಾತ್‌ಮ ಖ್ಹಪ್‌ಡ್ಯೂತೆ ಇನ, ಖನ್ನೆವಾಳಾನಿಘೋಣಿ ಹುಯೋತೆ ಕೋಣ್ ಕರಿ ತುನ ಸೋಚಾ಼ವಸ್?” ಕರಿ ಪುಛಾ಼ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","ತದೆ ಯೋ ಮೋಶೇನು ಧರ್ಮಶಾಸ್ತ್ರ ಶಿಕಾಡವಾಳು ಶಾಸ್ತ್ರಿ, “ಇನಾಪರ್ ಗೋರ್‌ ಕರ‍್ಯೊತೆ ಯೋಸ್” ಕರಿ ಜವಾಬ್‌ ದಿದೊ. ತದೆ ಯೇಸುನೆ ಇನ, “ಜಾ಼, ತೂಬಿ ಇಮ್ಮಸ್ ಕರ್‌” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","ಯೇಸುಬಿ ಇನು ಶಿಷ್ಯರ್‌ ಫರ್ತುಹುಯಿನ್ ಏಕ್‌ ಗಾಮ್ಮ ಆಯು. ಹಿಜ್ಜಾ಼ ಮಾರ್ಥ ಕರಿ ನಾಮ್ನಿ ಏಕ್‌ ಜ಼ಣಾನೆ ಯೇಸುನ ಇನ ಘರ್‌ಮ ಬುಲೈಲಿದಿ. ");
INSERT INTO vaa_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","ಮಾರ್ಥನ ಮರಿಯ ಕರಿ ಏಕ್‌ ನ್ಹಾನಿ ಭೇನ್ ಥಿ. ಆ ಪ್ರಭುನ ಗೋಡಾಕನ ಬೇಶಿನ್, ಇನಿ ವಚನ್ನ ಖ್ಹಮ್‌ಜು಼ಕರ್‌ತೀಥಿ. ");
INSERT INTO vaa_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","ಜಾ಼ಖ್ಹತ್ ಕಾಮ್ ಥೂತೆ ಇನಖ್ಹಾಜೆ ಮಾರ್ಥನೆ ಖಟುಖೈನ್, ಯೇಸುಕನ ಆಯಿನ್, “ಪ್ರಭು, ಮಾರಿ ಭೇನ್ ಮನ ಎಕ್ಕಸ್ ಜ಼ಣಿನ ಕಾಮ್ ಕರಾದೆಕರಿ ಮ್ಹೇಲಿದಿದೀನಿ, ಆ ಬಾರೇಮ ತುನ ಫಿಕರ್ ಕೊಯ್ನಿಕಿ ಶು? ಮನ ಮದತ್ ಕರಾದೆ ಕರಿ ಇನ ಬೋಲ್‌ಕರಿ ಬೋಲಿ. ");
INSERT INTO vaa_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","ಕತೋಬಿ ಪ್ರಭುನೆ ಇನ, “ಮಾರ್ಥ, ಮಾರ್ಥ ತೂ ಕಾಮ್ನಕೊಂತೆ, ವೇಚ಼್‌ಣೆಮಾಬಿ, ಘಬ್ರಾಟಿಮಾಬಿ ಖ್ಹಪ್‌ಡಿರ‍್ಹೀಸ್. ");
INSERT INTO vaa_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","ಕತೋಬಿ ಜ಼ರೂರತ್‌ ಹೋಣುತೆ ಎಕ್ಕಸ್, ಮರಿಯನೆ ಅಛ಼್ಛು ಚೂ಼ಣಿರಾಖಿಸ್, ಕೋಣ್‌ಬಿ ಇನೇಥಿ ಯೋ ಕಾಡಾನ ಕೋ ಉಶೇನಿ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","ಏಕ್‌ ದನ್ನೆ ಯೇಸು ಏಕ್‌ ಝ಼ಗೋಪರ್ ಪ್ರಾರ್ಥನೆ ಕರುಕರ್ತೊಥೊ. ಪ್ರಾರ್ಥನೆ ಖತಮ್ ಹುವಾನ ಬಾದ್‌ಮ, ಇನ ಶಿಷ್ಯರ್‌ಮ ಏಕ್‌ ಜ಼ಣಾನೆ ಇನ, “ಪ್ರಭು, ಯೋಹಾನನೆ ಇನ ಶಿಷ್ಯರ್‌ನ ಪ್ರಾರ್ಥನೆ ಕರಾನ ಶಿಕಾಡ್ಯೋತೆ ಇಮ್ಮಸ್, ಹಮುನಾಬಿ ಪ್ರಾರ್ಥನೆ ಕರಾನ ಶಿಕಾಡ್” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","ತದೆ ಯೇಸುನೆ ಇವ್ಣುನ, “ತುಮೆ ಪ್ರಾರ್ಥನೆ ಕರಾನಿ ವಖ್ಹತ್‌ಮ, ಬಾ: ತಾರು ನಾಮ್ ಪರಿಶುದ್ದ ಕರಿ ಬೋಲಾವಾದೆ, ತಾರಿ ರಾಜ್ಯ ಆವಾದೆ. ");
INSERT INTO vaa_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","ಹಮೂನ ದನ್‌ಪರೋಜ಼್‌ನು ಖಾಣು ದೇ. ");
INSERT INTO vaa_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","ಹಮಾರಿ ವಿರೋದ್ ಗಲತ್‌ ಕರಾತೆ ಹರೇಕ್ನ, ಹಮೆ ಮಾಪ್‌ ಕರೇಸ್ತೆ ಇಮ್ಮಸ್, ಹಮಾರಿ ಪಾಪ್ನ ಮಾಪ್‌ ಕರ್‌. ಹಮೂನ ಕಠಣ್ ಶೋದನೆಮ ನಕೊನಾಕ್‌ ಕರಿ ಬೋಲಿಲೆವೊ ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","ಅಜು಼ ಯೇಸುನೆ ಇನ ಶಿಷ್ಯರ್‌ನ, “ತುಮಾರಾಮ ಏಕ್‌ ಜ಼ಣೊ ಅಧಿರಾತ್ಮ ಏಕ್‌ ದೋಸ್ತ್‌ನ ಘರ್‌ಕನ ಜೈ಼ನ್, ‘ದೋಸ್ ಮನ ತೀನ್ ರೋಟಾ ಉಧಾರ್ ದೇ. ");
INSERT INTO vaa_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","ಮಾರೊ ದೋಸ್ತ್‌ಮ ಏಕ್‌ ಜ಼ಣೊ ಕಿಜ್ಜಾ಼ಕಿ ಒಳೆಜಾ಼ತೊಥೋತೆ ವಖ್ಹತ್‌ಮ, ಮಾರ ಘರ್‌ಕನ ಐರ‍್ಹೋಸ್. ಇನ ಖಾಣು ಖಡಾವಾನ ಮಾರಕನ ಶಾತ್ಬಿ ಕೊಯ್ನಿ’ ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","ತದೆ ಯೋ ದೋಸ್ ಘರ್‌ನ ಮಹಿಥೋಸ್ ಇನ, ‘ಮನ ಖ್ಹತಾವ್ ನಕೊ; ಹಮ್ಕೆ, ಬಾಕಲ್ ಮೂಚೈ಼ರ‍್ಹೂಸ್; ಮಾರ ಅಡ್ಡಾಣಿ ಲಡ್ಕಾ ಮಾರ ಜೋ಼ಡೆ ಖ್ಹುತಾಸ್. ಮೇ ಉಠೀನ್, ತುನ ಶಾತ್ಬಿ ದ್ಯವಾನ ಕೋ ಹುವಾನಿ’ ಕರಿ ಜವಾಬ್‌ ದಿದೊತೋಬಿ ದಿಯ್ಯೆಜಾ಼ಯ್. ");
INSERT INTO vaa_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","ತೋಬಿ ದೋಸ್ತ್‌ನಖ್ಹಾಜೆ ಉಠೀನ್ ನಾ ದಿದೊತೋಬಿ, ಯೋ ಖ್ಹರ್ಮಾವಸ್‌ಕೊಂತೆ ಮಾಂಗ್‌ತೋಸ್ ರ‍್ಹಿಶೆ ಕರಿ ಬೋಲಿನ್, ಉಠಿ ಐನ್ ಯೋ ಬೋಲಾತೆಯೆತ್ರು ಇನ ದಿಶೆ ಕರಿ ಮೇ ತುಮೂನ ಬೋಲುಸ್” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“ಇನಖ್ಹಾಜೆ ಮೇ ತುಮೂನ ಬೋಲುಸ್ಕಿ, ಮಾಂಗಿಲೇವೊ, ತುಮೂನ ದೇವಾವ್‌ಶೆ. ಢೂಂಡೊ, ತುಮೂನ ಮಳ್‌ಶೆ. ಬಾಕಲ್‌ಪರ್ ಮಾರೊ, ತದೆ ತುಮೂನ ಬಾಕಲ್ ಕಾಡ್‌ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","ಶನಕತೊ, ಮಾಂಗವಾಳ ಹರೇಕ್‌ನ ದೆವಾವ್‌ಶೆ, ಢೂಂಡವಾಳನ ಮಳ್‌ಶೆ, ಬಾಕಲ್‌ ಖಟ್‌ಖಟಾವಸ್ಕಿ ಇನ ಕಡಾವ್‌ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","ತುಮಾರಾಮ, ಬಾ ಹುಯಿರ‍್ಹೋತೆ ಕೋಣ್‌ತೋಬಿ ಮಾಛ಼್‌ಲು ಮಾಂಗವಾಳ ಛಿಯ್ಯಾನ, ಖ್ಹಾಪ್ ದಿಶುಕಿ ಶು? ");
INSERT INTO vaa_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","ನತರ್‌ಕಿ ಇಂಡು ಮಾಂಗಾತೆ ಛಿಯ್ಯಾನ, ವಿಛ್ಛಿ ದಿಶುಕಿ ಶು? ");
INSERT INTO vaa_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","ಇಮ್‍ಕತೊ, ಖರಾಬ್ ಹುಯಿರ‍್ಹಾತೆ ತುಮೇಸ್, ತುಮಾರ ಲಡ್ಕಾವ್ನ ಅಛ್ಛು಼ ರಾಛು಼ಖ್ಹಾರು ದೆವಾಪರ್, ಪರಲೋಕ್‌ನೊ ತುಮಾರೊ ಬಾ, ಇನಾಕನ ಮಾಂಗಿಲ್ಯವಾಳನ ಕೈಯೆಕ್ಕಿ ಜಾ಼ಫ ಪವಿತ್ರಾತ್ಮನ ದಿಶೆ ಕೊಯ್ನಿಕಿ ಶು?” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","ಏಕ್‌ ಹಲ್ಲ ಯೇಸು ಮುಕ್ಕೊ ಭೂತ್‌ನ ನಖ್ಹಾಡುಕರ್ತೋಥೊ. ಕದೆ ಯೋ ಮುಕ್ಕೊ ಭೂತ್ ನಿಕ್ಳಿಗಯೂಕಿ, ತದೆ ಯೊ ಅದ್ಮಿ ವಾತೆ ಬೋಲಾಲಗ್ಯು. ಅನ ದೇಖಿನ್, ಅದ್ಮಿಖ್ಹಾರು ಆಶ್ಚರ್ಯಖಾದು. ");
INSERT INTO vaa_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","ಕತೋಬಿ, ಇವ್ಣಾಮ ಥೋಡು ಜ಼ಣು, “ಆ, ಭೂತ್ ಖ್ಹಾರಾನೊ ಯಜಮಾನ್ ಹುಯಿರ‍್ಹೋತೆ ಬೆಲ್ಜೆಬೂಲ್‌ನೊ ಶಕಥ್ಥಿ, ಭೂತ್ ಖ್ಹಾರಾನ ಕಾಡಸ್ತೆ” ಕರಿ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","ಬಿಜು಼ ಥೋಡು ಜ಼ಣು ಯೇಸುನ ಖ್ಹಪ್‌ಡಾವ್ಣು ಕರಿ, “ತೂ ಆಬ್‍ಮ ಏಕ್‌ ಅದ್ಭುತ್ ಕರಿನ್ ವತಾಳ್” ಕರಿ ಇನ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","ಯೇಸುನೆ ಇವ್ಣಿ ಸೋಚ್ನ ಮಾಲುಮ್‌ ಕರಿಲೀನ್, ಇವ್ಣುನ ಬೋಲ್ಯೊಕಿ, “ಇವ್ಣ-ಇವ್ಣಾಮಸ್‌ ಭಾಗ್‌ಪಡಿಲ್ಯವಾನೊ ರಾಜ್ಯ ಬರ್ಬಾತ್ ಹುಯಿಜಾ಼ಸ್, ಇವ್ಣ-ಇವ್ಣಾಮಸ್‌ ಭಾಗ್‌ಪಡೀನ್‌, ಲಗಾತ್‌ ಭೀಡಾಲಗಸ್ತೆ ಘರ್ ತುಟಿಜಾ಼ಸ್‌, ");
INSERT INTO vaa_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","ಇಮ್ಮಸ್ ಶೈತಾನ್, ಇನಿ ವಿರೋದ್ ಯೋಸ್‌ ಭೀಡಾಲಗ್ಯೋತೊ, ಇನಿ ರಾಜ್ಯ ಕಿಮ್ ಬಚ಼್‌ಶೆ? ಮೇ ಬೆಲ್ಜೆಬೂಲ್‌ನಿ ಶಕಥ್ಥಿ ಭೂತ್‌ ಕಾಡುಸ್‌ ಕರಿ ತುಮೆ ಬೋಲೋಸ್‌ನಿ. ");
INSERT INTO vaa_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","ಮೇ ಬೆಲ್ಜೆಬೂಲ್‌ನಿ ಶಕಥ್ಥಿ ಭೂತ್‌ಖ್ಹಾರು ಕಾಡ್ತೊ ಉಶೇತೊ, ತುಮಾರು ಅದ್ಮಿ ಕಿನಿ ಶಕಥ್ಥಿ ಭೂತ್‌ಖ್ಹಾರು ಕಾಡಸ್‌. ಅನಖ್ಹಾಜೆ ಇವ್ಣೇಸ್ ತುಮೆ ಗಲತ್‌ ಕರಿ ನ್ಯಾವ್ ಫೇಡ್‌ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","ಕತೋಬಿ ಮೇ ದೇವ್ನಿ ಶಕಥ್ಥಿ ಭೂತ್‌ಖ್ಹಾರನ ಕಾಡ್ತೊ ಉಶೇತೊ, ದೇವ್ನಿ ರಾಜ್ಯ ತುಮಾರಕನ ಐಗೈ ಕರಿ ಆಸ್ ವತಾಳಸ್‍. ");
INSERT INTO vaa_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","ಏಕ್‌ ಶಕತ್‌ವಾಳೊ, ಲಠ್ಠೊ, ತಲ್ವಾರ್‌ ಅಜು಼ ಜಂಗ್ ಭಿಡಾನ ಹೋಣುತೆ ಖ್ಹಾರಿಸ್ ತೈಯಾರಿ ಕರಿಲೀನ್, ಇನ ಘರ್‌ನ ವಖ್ಹ್‌ತಿ ಕರಾನಿ ವಖ್ಹತ್‌ಮ, ಇನು ರಾಛು಼ಖ್ಹಾರು ಜ಼ತನ್‍ಥೀಸ್‌ ರ‍್ಹೇಸ್‌. ");
INSERT INTO vaa_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","ಕತೋಬಿ, ಇನೇಥಿಬಿ ಶಕತ್‌ವಾಳೊ ಐನ್ ಇನ ಹರಾವನ ಬಾದ್‌ಮ, ಯೋ ಮಾಲಿಕ್ ಇನ ಘರ್‌ನ ಜ಼ತನ್‌ಥಿ ರಾಖಾನಟೇಕೆ, ರಾಖಿರಾಖ್ಯೊಥೋತೆ ಖ್ಹಾರುಸ್‌ ರಾಛಾ಼ನ ಛಿನೈಲಿನ್‌, ಇನೆ ಲೂಟಿಲಿದೊ ಯೋ ಖ್ಹಾರಾನ, ಇವ್ಣ ಅದ್ಮಿಮ ವಾಟಪಾಡಿಲೆಸ್. ");
INSERT INTO vaa_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","ಮಾರ ಭಣಿ ರ‍್ಹೇಯಿಕೊಂತೆ ಇವ್ಣೆ, ಖ್ಹಾಚಮಾಬಿ ಮಾರು ವಿರೋದಿ ಹುಯಿರ‍್ಹುಸ್. ಮಾರ ಜೋ಼ಡ್ಮ ಎಕ್ಟು ಕರಾನ ಮದತ್ ಕರಾಕೊಂತೆ ಇವ್ಣೆ, ಖ್ಹಾಚಮಾಬಿ ಛಿಡ್‌ಗರ್‌ ಕರಾವಾಳೊ ಹುಯಿರ‍್ಹೋಸ್. ");
INSERT INTO vaa_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","ಏಕ್‌ ಅದ್ಮಿಮಾಥು ಭೂತ್‌ ನಿಕ್ಳಿಜಾ಼ವಾನ ಬಾದ್ಮ, ಅರಾಮ್‌ ಕರಾನಖ್ಹಾಜೆ ಝ಼ಗೊ ಢೂಂಡ್‌ತುಹುಯಿನ್, ಪಾಣಿಕೊಂತೆ ಝ಼ಗೋಮ ವನ್‌ವನ್ತು ರ‍್ಹೇಸ್. ಕತೋಬಿ ಅರಾಮ್‌ ಕರಾನ ಝ಼ಗೊ ಮಳಾಕೊಂತೆ ದೇಖಿನ್‌, ಯೋ ಭೂತ್ ಇನುಯೋಸ್, ‘ಮೇ ಮ್ಹೆಂದಿನ್ ಆಯೋತೆ, ಮಾರ ಘರೆ ಪಾಛೊ಼ಫರಿನ್ ಆವುಸ್ ಕರಿ ಬೋಲಿನ್, ");
INSERT INTO vaa_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","ಯೋ ಘರ್‌ಕನ ಪಾಛೊ಼ಫರಿ ಆಯಿನ್, ಯೋ ಝ಼ಡೈನ್, ಅಚ್‌ಕಟ್ ಹುಯಿರ‍್ಹೂತೆ ದೇಖಸ್. ");
INSERT INTO vaa_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","ತದೆ ಹಿಜ್ಜಾ಼ಥೊ ಜೈ಼ನ್, ಇನೇಥಿಬಿ ಖರಾಬ್ ಹುಯಿರ‍್ಹೂತೆ ಬಿಜು಼ ಖ್ಹಾತ್ ಭೂತ್‌ನ ಬುಲೈಲ್ಯಾವಸ್‌, ಯೋ ಖ್ಹಾರು ಇನ ಮಹಿ ಪೇಶಿನ್ ಹಿಜ್ಜಾ಼ಸ್ ರ‍್ಹವಾಲಗಸ್‌. ತದೆ ಯೋ ಅದ್ಮಿನಿ ಖ್ಹರ್ತಿಮಾನಿ ಹಾಲ್‌, ಪಹಿಲೆಥೀಬಿ ತೀರ್‌ಚಾಸ್ ಬಿಗ್‌ಡಿಜಾ಼ಸ್” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","ಯೇಸು ಆ ವಾತೆಖ್ಹಾರು ಬೋಲುಕರಾನಿ ವಖ್ಹತ್‌ಮ, ಅದ್ಮಿನಿ ಝೂ಼ಂಡ್‌ಮಾಥು ಏಕ್‌ ತಯೇಡಾನೆ, “ತುನ ಜ಼ಣಿನ್, ದೂದ್ ಪಿಡೈನ್‌, ಪಾಳಿತೆ ಯೋ ತಯೇಡ ಧನ್ಯ ಹುಯಿರ‍್ಹೀಸ್‌!” ಕರಿ ಚಿಕ್ರಿನ್ ಬೋಲಿ. ");
INSERT INTO vaa_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","ತದೆ ಯೇಸುನೆ, “ಇನೇಥಿಬಿ, ದೇವ್ನಿ ವಚನ್ನ ಖ್ಹಮ್‌ಜೀನ್‌, ಇನ ಪಾಡಿಚಾ಼ಲವಾಳುಸ್‌ ಧನ್ಯರ್ ಹುಯಿರ‍್ಹುಸ್‍” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","ಅದ್ಮಿ ಝೂ಼ಂಡೆ-ಝೂ಼ಂಡೆ ಭರೈನ್ ಆವ್‍ಕರಾನಿ ವಖ್ಹತ್‌ಮ, ಯೇಸುನೆ ಇವ್ಣುನ, “ಆ ಪಿಳ್ಗಿ ಖರಾಬ್ ಪಿಳ್ಗಿ ಹುಯಿರ‍್ಹೂಸ್! ಅವ್ಣೆ ಅದ್ಭುತ್ ಕಾಮ್ ದೇಕ್ಣು ಕರಿ ಆಖ್ಹ್ ಕರಾಸ್, ಕತೋಬಿ ಯೋನಾನಿ ಜಿ಼ಂದ್‌ಗೀಮ ಚಾ಼ಲ್ಯುತೆ ಅದ್ಭುತಾಸ್ ಪಣ್ಕಿ ಬಿಜು಼ ಅದ್ಭುತ್ ಅವ್ಣುನ ಕೋ ಮಳ್‌ಶೇನಿ. ");
INSERT INTO vaa_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","ಯೋನ ನಿನವೆ ನಂಗರ್‌ವಾಳನ ಖ್ಹಣೇದ್ ಹುಯಿರ‍್ಹೊಥೋತೆ ಇಮ್ಮಸ್, ಅದ್ಮಿನೊ ಛಿಯ್ಯೊ ಆ ಪಿಳ್ಗಿವಾಳಾನ ಖ್ಹಣೇದ್ ಹುಯಿರ‍್ಹೋಸ್. ");
INSERT INTO vaa_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","ನ್ಯಾವ್‌ನ ತೀರ್ಪ್‌ನ ದನ್ಮ, ಶೇಬಾನಿ ರಾಣಿ ಉಠಿ ಭೀರಿನ್, ಆ ಪಿಳ್ಗಿವಾಳಾನ, ‘ತುಮೆ ಅಪರಾದಿ’ ಕರಿ ಬೋಲ್‌ಶೆ. ಯೋ ಸೊಲೊಮೋನ್ನಿ ಚಾ಼ತುರ್ ವಾತೇನ ಖ್ಹಮ್‌ಜಾ಼ನಖ್ಹಾಜೆ ಧರ್ತಿನ ಕೈಯೆಕ್ಕಿ ದಖ್ಖನ್‌ಥಿ ಆಯಿ. ಕತೋಬಿ ಮೇ ತುಮೂನ ಬೋಲುಸ್ಕಿ, ಸೊಲೊಮೋನ್‌ಥೀಬಿ ಮೋಟೊ ಹಜ್ಜಾ಼ ಛಾ಼. ");
INSERT INTO vaa_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","ನ್ಯಾವ್‍ನ ತೀರ್ಪ್‌ನ ದನ್ಮ ನಿನವೆ ನಂಗರ್‌ವಾಳು ಉಠಿ ಭೀರಿನ್‌, ಆ ಪಿಳ್ಗಿವಾಳಾನ, ‘ತುಮೆ ಅಪರಾದಿ’ ಕರಿ ಬೋಲ್‌ಶೆ. ಇವ್ಣೆ ಯೋನಾನೆ ಬೋಲ್ಯೋತೆ ವಚನ್ನ ಖ್ಹಮ್‌ಜಿನ್‌, ದೇವ್ ಭಣಿ ಫರಿಗಯು; ಕತೋಬಿ ಮೇ ತುಮೂನ ಬೋಲುಸ್ಕಿ, ಯೋನಾಥೀಬಿ ಮೋಟೊ ಹಜ್ಜಾ಼ ಛಾ಼! ");
INSERT INTO vaa_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","ಕೋಣ್‌ಬಿ ದೀವೊ ಖ್ಹಲ್‌ಗೈನ್, ಲಪಾಡಿನ್ ರ‍್ಹವೊ, ನತರ್‌ಕಿ ಕೋಳ್ಗಾನಹೇಟ್ ರ‍್ಹವೊ ಮ್ಹೇಲಾಕೊಯ್ನಿ. ಘರ್‌ನ ಮಹಿ ಆವಾಳಾನ ಉಜಾ಼ಳು ದೆಖಾವಾನಿಘೋಣಿ, ದೀವೊ ಮ್ಹೇಲಾನಿ ಖಂಬಾಪರ್ ಮ್ಹೇಲಾಸ್. ");
INSERT INTO vaa_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","ತಾರ ಡೋಳಾ ಶರೀರ್‌ನ ದಿವಾನಿಘೋಣಿ ಹುಯಿರ‍್ಹುಸ್‍. ತಾರ ಡೋಳ ಬರೋಬರ್ ರ‍್ಹಯಾತೊ, ತಾರು ಶರೀರ್ ಅಖ್ಖುಸ್ ಉಜಾ಼ಳು ರ‍್ಹಿಶೆ: ಕತೋಬಿ ತಾರ ಡೋಳ ಖರಾಬ್ ರ‍್ಹಯೂತೊ, ತಾರು ಶರೀರ್ ಅಖ್ಖುಸ್ ಅಂಧಾರು ಹುಯಿಜಾ಼ಶೆ ");
INSERT INTO vaa_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","ಇನಖ್ಹಾಜೇಸ್, ತಾರು ಉಜಾ಼ಳು ಅಂಧಾರು ನಾ ಹೋಣುತೆ ಇಮ್‌ ದೇಖಿಲೆ. ");
INSERT INTO vaa_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","ತದೆ ತಾರು ಆಂಗ್-ತನ್ ಅಖ್ಖುಸ್ ಉಜಾ಼ಖ್ಹ್‌ಥಿ ಭರೈನ್, ಖೆವಿ ಬಾಜು಼ಮಾಬಿ ಅಂಧಾರು ನಾರ‍್ಹಯುತೊ, ಯೋ ಉಜಾ಼ಖ್ಹ್‌ ಖ್ಹಾರಿಸ್ ಬಾಜು಼ಮ ಘೈಗ್‌ಶೆತೆ ಇಮ್ಮಸ್, ದೀವೊ ಘೈಗಾನಿ ವಖ್ಹತ್‌ಮ ಇನು ಉಜಾ಼ಖ್ಹ್‌ ತಾರಪರ್ ಘೈಗ್‌ಶೆ, “ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","ಯೇಸುನೆ ವಾತೆ ಬೋಲಿನ್ ಖತಮ್ ಕರಾನ ಬಾದ್‌ಮ, ಫರಿಸಾಯರ್‌ವಾಳೊ ಏಕ್‌ ಜ಼ಣಾನೆ ಯೇಸುನ ಖಾಣನ ಬುಲಾಯೊ. ತದೆ ಯೇಸು ಇನ ಘರ್‌ನ ಮಹಿ ಜೈ಼ನ್‌, ಖಾಣನ ಬೇಶಿಗಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","ಯೇಸುನೆ ಹಾತ್‌ ಧೋಯೊಕೊಂತೆ ಖಾಣನ ಬೆಠೂತೆ ಯೋ ಫರಿಸಾಯವಾಳನೆ ದೇಖಿನ್, ಆಶ್ಚರ್ಯಹುಯು. ");
INSERT INTO vaa_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","ತದೆ ಪ್ರಭುನೆ ಇನ, “ಫರಿಸಾಯರ್ ಹುಯಿರ‍್ಹಾತೆ ತುಮೆ ತುಮಾರು ಹಂಡ್‌ಕು ಅಜು಼ ಥಾಳಿ ಭಾರ್‌ ಪಾಕ್‌ಥಿ ಮಾಂಜ಼ಸ್. ಕತೋಬಿ ತುಮಾರ ಮಹಿ ಠಗಾವಾನು ಅಜು಼ ಖರಾಬ್ ಚಾ಼ಲ್ ಭರೈರ‍್ಹೂಸ್. ");
INSERT INTO vaa_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","ಖ್ಹಯಾಲ್‌ಭರ‍್ಯಾ! ಭಾರ್‌ಲ್ಯು ಬಣಾಯೋತೆ ದೇವ್ನೇಸ್, ಮಹಿನೂಬಿ ಬಣೈರಾಖ್ಯೊಸ್ನಿ. ");
INSERT INTO vaa_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","ಅನಖ್ಹಾಜೆಸ್ ಮಹಿ ಛಾ಼ತೆ ಇನ ಗೋರ್‌ಗರೀಬ್‌ನ ದೆವೊ, ತದೆ ತಮಾಮ್‌ ರಾಛು಼ ತುಮಾರಖ್ಹಾಜೆ ಪಾಕ್‌ ಹುಯಿಜಾ಼ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","ಅಲಾ ಫರಿಸಾಯರ್‌ವಾಳ, ತುಮಾರಿ ಹಾಲ್ನ ಶಾತ್‌ ಬೋಲು! ತುಮೆ ದೇವ್ನ ತುಮಾರಕನ ಛಾ಼ತೆ ಹರೇಕ್‌ಮ ದಖ್ಹ್‌ಮ ಏಕ್‌ ಭಾಗ್‌ ದೆವೋಸ್; ತುಮೆ ಪಿಕಾವಸ್ತೆ ಖ್ಹಾರಿಸ್ ತರ‍್ಹಾನು ಜ಼ಡಿಬೂಠಿನ ಅಜು಼ ಪುದೀನ, ಸದಾಪುಮಾಬಿ ಭಾಜಿಯೇಮ ದಖ್ಹ್‌ಮ ಏಕ್‌ ಭಾಗ್‌ ದೆವೋಸ್. ಕತೋಬಿ ನ್ಯಾವ್‌ಥಿ ಚಾ಼ಲಿಲ್ಯವಾನ ಅಜು಼ ಪ್ಯಾರ್ ವತಾಳನು ತುಮೆ ಭೈಕಿಗಯ. ಪಹಿಲೆ ತುಮೆ ಆ ಖ್ಹಾರು ಕರಾನ ಆದತ್ ಕರಿಲೇವ್ಣು, ಅಜು಼ ಯೋ ಖ್ಹಾರುಬಿ ನಾ ಭೈಕ್‌ಣು. ");
INSERT INTO vaa_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“ಫರಿಸಾಯರ್‌ವಾಳ, ತುಮಾರಿ ಹಾಲ್ನ ಶಾತ್‌ ಬೋಲು! ಸಬೆ ಭರಾವನು ಮಂದಿರ್‌ಮ ಪಹಿಲಿ ಝ಼ಗೊ ದ್ಯವಾನುಸ್ ತುಮೂನ ಪ್ಯಾರ್, ಅಜು಼ ದುಕಾನೇನಿ ಗಲ್ಲಿಯೇಮ ತುಮೂನ ಖ್ಹಲಾಮ್ ಕರ‍್ನು ಕರಿ ಬೋಲನುಸ್ ತುಮಾರಿ ಆಖ್ಹ್! ");
INSERT INTO vaa_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","ತುಮಾರಿ ಹಾಲ್ನ ಶಾತ್‌ ಬೋಲು! ತುಮೆ ದಬಿಗಯೂತೆ ಮಖ್ಹಾಣ್ಯನಿಘೋಣಿ ಛಾ಼. ಇನಾಪರ್ ಚಾ಼ಲವಾಳ ಅದ್ಮಿನ ತುಮೆ ಮಖ್ಹಾಣ್ಯುಕರಿ ಮಾಲುಮ್ ಕೊಯ್ನಿ. ");
INSERT INTO vaa_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","ತದೆ ಮೋಶೇನು ಧರ್ಮಶಾಸ್ತ್ರ ಶಿಕಾಡವಾಳು ಶಾಸ್ತ್ರಿಮ ಏಕ್‌ ಜ಼ಣು ಯೇಸುನ, “ಗುರು, ಆ ವಾತೆ ಬೋಲಾಥಿ ತೂ ಹಮುನಾಬಿ ಖ್ಹರಮ್‌ ಕಾಡದಾಖ್ಹಲ್ ಹುಯು” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","ಯೇಸುನೆ ಜವಾಬ್‌ ದಿದೋಕಿ, “ಮೋಶೇನು ಧರ್ಮಶಾಸ್ತ್ರ ಶಿಕಾಡವಾಳ ಶಾಸ್ತ್ರಿಯೆ, ತುಮಾರಿ ಹಾಲ್ನಬಿ ಶಾತ್‌ ಬೋಲು! ತುಮೆ ಅದ್ಮಿಪರ್ ಢೊವಾನ ಹುವಾಕೊಂತೆ, ಎತ್ರೊ ಬೋಜೊ಼ ನಾಖೋಸ್. ಕತೋಬಿ ತುಮೇತೊ, ಯೋ ಭೋಜಾ಼ನ ಏಕ್‌ ಅಂಗ್‌ಳಿಥೀಬಿ ಛೀಮಕೊಯ್ನಿ. ");
INSERT INTO vaa_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","ತುಮಾರಿ ಹಾಲ್ನ ಶಾತ್‌ ಬೋಲು! ತುಮೆ ಪ್ರವಾದಿಯೇನಖ್ಹಾಜೆ ಅಛ್ಛಿ-ಅಛ್ಛಿ ಮಖ್ಹಾಣ್ಯನಿ ಘವಿಯೇನ ಬಣಾವೋಸ್, ಇವ್ಣುನ ಮಾರ‍್ಯೂತೆ ತುಮಾರ ಗುರುಗುರಬ್‍ಲ್ಯನೇಸ್. ");
INSERT INTO vaa_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","ಅನೇಥಿ ತುಮಾರ ಗುರುಗುರಬ್‍ಲ್ಯನೆ ಕರ‍್ಯುತೆ ಇನ, ತುಮೇಸ್ ಸಾಕ್ಷಿ ಹುಯಿರ‍್ಹಾಸ್. ಇವ್ಣ ಕಾಮ್‍ಅಖ್ಖಾನ ಮಾನಿಲಿದ ಕರಿ. ಕಿಮ್‌ಕತೊ ಇವ್ಣೆ ಪ್ರವಾದಿಯೇನ ಮಾರ‍್ಯು, ತುಮೆ ಯೋ ಮಖ್ಹಾಣ್ಯನಿ ಘವಿಯೇನ ಭಾಂದೋಸ್. ");
INSERT INTO vaa_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","ಅನಖ್ಹಾಜೆಸ್ ದೇವ್ನಿ ಗ್ಯಾನ್ ಬೋಲಸ್ಕಿ, “ಮೇ ಇವ್ಣಾಕನ ಪ್ರವಾದಿಯೇನಾಬಿ, ಅಪೊಸ್ತಲರ್‌ನಾಬಿ ಮೋಕ್ಲೀಶ್, ಇವ್ಣಾಮ ಥೋಡ ಜ಼ಣಾನ ಮಾರಿನಾಕ್‌ಶೆ ಅಜು಼ ಥೋಡ ಜ಼ಣಾನ ಖ್ಹತಾವ್‌ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","ಅನಖ್ಹಾಜೆಸ್, ಜಗತ್‌ ಉಬ್‍ಜೂತೆ ತಪ್‌ಥು ಮರೈನಾಖಿ ದಿದೂತೆ ತಮಾಮ್‌ ಪ್ರವಾದಿಯೇನು ಮೋತ್‌ನ, ಆ ಜ಼ಗ್‌ನು ಅದ್ಮಿ ಹುಯಿರ‍್ಹಾತೆ ತುಮೂನ ದಂಡ್‌ ಮಳ್‌ಶೆ! ");
INSERT INTO vaa_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","ಹೇಬೆಲ್‌ಥು ಧರೀನ್, ಬಲಿನಿ ಚಾ಼ಚ಼ರ್‌ ಅಜು಼ ಮಂದಿರ್‌ನ ಇಚ಼್‌ಮ ಮರೈ ನಾಖ್ಯುತೆ ಜಕರೀಯನು ಮೋತ್‍ತೋಡಿನು ದಂಡ್‌ ತುಮೂನ ಮಳ್‌ಶೆ. ಒಹೊ, ಮೇ ತುಮೂನ ಬೋಲುಸ್ಕಿ ಯೋ ಖ್ಹಾರಾವ್‍ನಟೇಕೆ ಆ ಜ಼ಗ್‌ನು ಅದ್ಮಿನ ದಂಡ್‌ ಮಳ್‌ಶೆ! ");
INSERT INTO vaa_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","ಮೋಶೆನಿ ಧರ್ಮಶಾಸ್ತ್ರ ಶಿಕಾಡವಾಳ ಶಾಸ್ತ್ರಿಯೆ ತುಮಾರಿ ಹಾಲ್ನ ಶಾತ್‌ ಬೋಲು! ದೇವ್ನಿ ಬಾರೇಮ ಶಿಕಾನಟೇಕೆ ಛಾ಼ತೆ ಬೀಗಾನ ತುಮೇಸ್ ರಾಖಿಲಿದ, ತುಮೇಬಿ ಮಹಿ ಜಾ಼ಯ್‌ಕೊಯ್ನಿ, ಬಿಜಾ಼ನಾಬಿ ಜಾ಼ವಾನ ಕೋ ಮ್ಹೇಲಾನಿ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","ಯೇಸು ಹಿಜ್ಜಾ಼ಥೊ ನಿಕ್ಳಾನಿ ವಖ್ಹತ್‌ಮ, ಮೋಶೆನಿ ಧರ್ಮಶಾಸ್ತ್ರ ಶಿಕಾಡವಾಳು ಶಾಸ್ತ್ರಿಯೆ ಅಜು಼ ಫರಿಸಾಯರ್‌ವಾಳು ಯೇಸುನಿ ಚಾ಼ವ್‌ಣ್ಯ ಕಾಡ್ಯು, ಅಜು಼ ಘಣಿ ಬಾರೇಮ ಇನ ಪುಛಾ಼ಯು. ");
INSERT INTO vaa_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","ಯೇಸುನಿ ವಾತೇಮ ಶಾತ್‌ತೋಬಿ ಗಲತ್‌ ಮಳಾಸ್ಕಿ ಶುಕಿ ಕರಿ, ಇನ ಖ್ಹಪ್‌ಡಾವಾನಟೆಕೆ ಘಣು ಕೋಶಿಷ್ ಕರ‍್ಯು. ");
INSERT INTO vaa_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","ಎತ್ರಾಸ್‌ಮ ಹಜಾ಼ರೊ ಅದ್ಮಿನಿ ಭೀಡ್ ಉಪ್ರಾಥಾಳಿ ಪಡ್ತುಹುಯಿನ್‍, ಎಕ್ಟು ಹುಯು. ತದೆ ಯೇಸುನೆ ಪಹಿಲೆ ಇನ ಶಿಷ್ಯರ್‌ನ, “ಫರಿಸಾಯನು ಶೋಡನು ಆಟಾನಿ ಬಾರೇಮ ಕತೊ, ಇವ್ಣೆ ಠಗಾವನಿ ಬಾರೇಮ ಜ಼ತನ್‌ಥಿ ರ‍್ಹವೊ, ");
INSERT INTO vaa_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","ಲಪೈರ‍್ಹುತೆ ಖ್ಹಾರುಸ್‌ ಭಾರ್‌ ದೆಖಾವ್‌ಶೆ, ಖ್ಹಾರಿಸ್ ಖ್ಹಾಚಿ ವಾತೆ ಭಾರ್‌ ಮಾಲುಮ್ ಪಡ್‌ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","ಅನಖ್ಹಾಜೆಸ್, ತುಮೆ ಅಂಧಾರಾಮ ಬೋಲ್ಯಾತೆ ಯೋ ಖ್ಹಾರು, ದನ್ನು ಉಜಾ಼ಳಾಮ ಖ್ಹಮ್‌ಜಾ಼ವ್‌ಶೆ, ಅಜು಼ ಕೋಣಮ ಲಪೀನ್, ಕಾನ್‌ಮ ಶಿಕಾಡಿ ಬೋಲಾಸ್ತೆ ಖ್ಹಾರಿಸ್ ವಾತೆ ಘರ್‌ನ ಛ಼ತ್‍ಪರ್‌ಥು ಖ್ಹಮ್‌ಜಾ಼ವ್‌ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“ಮಾರ ದೋಸ್ ಹುಯಿರ‍್ಹಾತೆ ತುಮೂನ, ಮೇ ಬೋಲುಸ್ಕಿ, ಶರೀರ್‌ನ ಮರ್‌ನಾಖಿನ್, ಇನೇಥಿ ಜಾ಼ಖ್ಹತ್ ಶಾತ್ಬಿ ಕರಾಕೊಂತೆ ಇವ್ಣುನ ದೇಖಿನ್, ನಕೊ ಡರ್‌ಶು. ");
INSERT INTO vaa_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","ಕತೋಬಿ ತುಮೆ ಕಿನ ದೇಖಿನ್ ಡರ‍್ನು ಕರಿ ಮೇ ತುಮೂನ ಬೋಲಿದೆವುಸ್‍, ಮರಿಜಾ಼ವನ ಬಾದ್‌ಮ, ನರಕ್ಮ ನಾಖಾನಿ ಅದಿಕಾರ್ ರ‍್ಹವಾಳೊ ದೇವ್ನ ದೇಖಿನ್ ಡರೊ. ಓಹೊ, ಇನ ಎಕ್ಕಸ್ ಜ಼ಣಾಥಿ ತುಮೆ ಡರ‍್ನೂತೆ. ");
INSERT INTO vaa_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","ಪಾಚ಼್ ಚು಼ರಕ್‌ಲಿಯೇನ ಬೇಕಾಖ್ಹ್‌ನ ವೇಚಾ಼ಕೊಯ್ನಿಕಿ ಶು? ತೋಬಿ, ಇನಾಮಾಥು ಏಕ್‌ನಾಬಿ ದೇವ್ ಭೈಕಕೊಯ್ನಿ. ");
INSERT INTO vaa_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","ತುಮಾರೊ ಮುಡ್‌ಕ್ಯಾನೊ ಕೇಖ್ಹ್‌ ಜಿನ್‌ಕುಬಿ ಗಣೈರ‍್ಹೂಸ್‌. ಇನಖ್ಹಾಜೆ ಡರೊ ನಕೊ, ಕೈಏಕ್ಕಿ ಚು಼ರಕ್‌ಲಿಯೇಥೀಬಿ ತುಮೇಸ್ ಘಣ ಮೋಲ್‌ವಾಳ ಹುಯಿರ‍್ಹಾಸ್‌! ");
INSERT INTO vaa_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“ಮೇ ತುಮೂನ ಬೋಲಸ್ಕಿ, ಕೋಣ್ ಅದ್ಮಿನ ಖ್ಹಾಮ್ಣೆ ಯೋ ಮಾರವಾಳೊಕರಿ ಮಾನಿಲೇಸ್ಕಿ, ಅದ್ಮಿನೊ ಛಿಯ್ಯೋಬಿ, ದೇವ್‌ನು ದೂತರ್‌ನ ಖ್ಹಾಮ್ಣೆ ಯೋ ಮಾರವಾಳೊಕರಿ ಮಾನಿಲಿಶೆ. ");
INSERT INTO vaa_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","ಕತೋಬಿ ಕೋಣ್ ಅದ್ಮಿನ ಖ್ಹಾಮ್ಣೆ ಯೋ ಮಾರವಾಳೊ ಕಾಹೆಕರಿ ಬೋಲಸ್ಕಿ, ಇನ ಮೇಬಿ ಮಾರ ದೇವ್ನ ದೂತರ್‌ನ ಖ್ಹಾಮ್ಣೆ, ಯೋ ಮಾರ ಭಣಿವಾಳೊ ಕಾಹೆಕರಿ ಬೋಲಿಶ್” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","ಅದ್ಮಿನೊ ಛಿಯ್ಯಾಪರ್ ಶಾತ್‌ತೋಬಿ ಗಲತ್‌ ವಾತೆ ಬೋಲ್ಯೂತೊ, ಇವ್ಣುನ ಮಾಪಿ ಮಳ್‌ಶೆ; ಕತೋಬಿ ಪವಿತ್ರಾತ್ಮನ ವಿರೋದ್ ಖರಾಬ್ ಬೋಲವಾಳಾನ ಮಾಪಿಕೊಯ್ನಿ. ");
INSERT INTO vaa_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“ಇವ್ಣೆ ತುಮೂನ, ಸಭೆ ಭರಾವನು ಮಂದಿರ್‌ಮ ರ‍್ಹವೊ, ಅದಿಕಾರಿಕನ ರ‍್ಹವೊ, ರಾಜ್ಯಪಾಲ್‌ಕನ ರ‍್ಹವೊ, ರಾಜ಼್‌ಭಾರ್‌ ಚ಼ಲಾವವಾಳ ಖ್ಹಾಮ್ಣೆ ರ‍್ಹವೊ ಖೇಚಿಲಿಗಯೂತೆ, ಇವ್ಣುನ ಶಾತ್‌ ಜವಾಬ್‌ ದೇವ್ಣು, ಕಿಮ್ ಬೋಲ್ನುಕರಿ ವೇಚ಼್‌ಣೆ ನಕೊ ಕರ್ಶು. ");
INSERT INTO vaa_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","ಶನಕತೊ ಯೋ ವಖ್ಹತ್‌ಮ, ತುಮೆ ಶಾತ್‌ ಬೋಲ್ನುಕರಿ ಪವಿತ್ರಾತ್ಮಾಸ್‌ ತುಮೂನ ಬೋಲಿದಿಶೆ. ");
INSERT INTO vaa_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","ಅದ್ಮಿನಿ ಝೂ಼ಂಡ್‌ಮಾಥು ಏಕ್‌ ಜ಼ಣು ಯೇಸುನ, “ಗುರು, ಮರಿಗಯೋತೆ ಹಮಾರ ಬಾನಿ ಆಸ್ತಿನ ಭಾಗ್‌ಪಾಡಿ ದ್ಯವಾದೆಕರಿ ಮಾರ ಮೋಟ ಭೈನ ಬೋಲ್’ ಕರಿ ಬೋಲಖ್ಹತರ್‌, ");
INSERT INTO vaa_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","ತದೆ ಯೇಸುನೆ ಇನ, “ಅಲಾ ದೋಸ್, ನಯ್ಯೊಹುಯಿನ್ ರ‍್ಹವೊ ನತರ್‌ಕಿ ಆಸ್ತಿನ ಭಾಗ್‍ಪಾಡವಾಳೊ ಹುಯಿನ್ ರ‍್ಹವೊ, ಮನ ತುಮಾರ ಭೇ ಜ಼ಣಾಪರ್ ನೇಮಕ್ ಕರ‍್ಯುತೆ ಕೋಣ್?” ಕರಿ ಪುಛಾ಼ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","ಅಜು಼ ಹಿಜ಼್ಜಾಥೂತೆ ಖ್ಹಾರುಸ್‌ ಅದ್ಮಿನ, “ಜ಼ತನ್‌ಥಿ ರ‍್ಹವೊ ಅಜು಼ ಹರೇಕ್ ತರ‍್ಹಾನು ಲಾಲಚ್‌ಥಿ ದೂರ್ ರ‍್ಹವಾನಿಮತ್ ತುಮಾರು ತುಮೆ ಬರಾಬರ್‌ಥಿ ದೇಖಿಲೆವೊ. ಶನಕತೊ ಏಕ್‌ ಜ಼ಣಾನ ಕೆತ್ರು ಧನ್‌-ದೌಲತ್ ರ‍್ಹಯುತೋಬಿ, ಯೋ ದೌಲತ್‌ ಇನ ಜಾನ್ನ ಆಧಾರ್ ಕೋ ಹುವಾನಿ. ");
INSERT INTO vaa_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","ಅನ ಬಾದ್‌ಮ ಯೇಸುನೆ ಇವ್ಣುನ ಏಕ್‌ ಮತ್ಲಬ್‌ನಿ ಖೇಣಿನ ಬೋಲ್ಯೊ: ಏಕ್‌ ಶೌಕಾರ್ ಅದ್ಮಿ ಥೂ. ಏಕ್‌ ಹಲ್ಲ ಇನಿ ಜ಼ಮೀನ್‌ಮ ಅಛ್ಛಿನಿತರ ಅನಾಜ಼್ ಪಿಕ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","ತದೆ ಯೋ ಇನ ಮನ್‌ಮ, ‘ಮೇ ಶಾತ್‌ಕರು? ಮಾರು ಅನಾಜ಼್ ಅಖ್ಖು ಭರಿನ್ ಮ್ಹೇಲಾನ ಝ಼ಗೊ ಕೊಯ್ನಿನಿ!’ ಕರಿ ಸೋಚಿನ್, ");
INSERT INTO vaa_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","‘ಮೇ ಏಕ್‌ ಕಾಮ್ ಕರುಸ್; ಮಾರಿ ಕಣ್ಗೀನ ಫೋಡೈನ್, ಇನೇಥಿಬಿ ಮೋಟಿ ಕಣ್ಗಿನ ಭಂದೈನ್, ಹಿಜ್ಜಾ಼ ಮಾರು ಖ್ಹಾರೂಸ್ ಅನಾಜ಼್‌ನ ಅಜು಼ ಬಿಜು಼ ಖ್ಹಾರೂಸ್ ರಾಛಾ಼ನ ಮ್ಹೇಲುಸ್’ ");
INSERT INTO vaa_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","ಬಾದ್‌ಮ ಮಾರು ಮೇ, ಹೇ ಜಾನ್‌, ಕೆತ್ರಾಸ್ಕಿ ವರಖ್ಹ್ ಬೇಶಿನ್ ಖಾವಯೆತ್ರು ಅನಾಜ಼್ ತಾರಕನ ಪಡ್ಯೂಸ್. ಅರಾಮ್ ಕರಿಲೆ, ಖೈಪೀನ್ ಖ್ಹುಶಿ ಕರ್‌’ ಕರಿ ಇನು ಯೋಸ್ ಬೋಲಿಲಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","ಕತೋಬಿ ದೇವ್ ಇನ, “ಬಿಣ್‍ಅಕ್ಲಿ, ಆ ರಾತೇಸ್ ತಾರ ಜಾನ್ನ ಕಾಡಿಲಿಶೆ; ತದೆ ತುನೆ ತಾರಖ್ಹಾಜೆ ಜ಼ಮಾಕರೀನ್ ಮ್ಹೇಲಿರಾಖ್ಯೊತೆ ಯೋ ಖ್ಹಾರು ಕಿನ ಉಶೆ?” ಕರಿ ಪುಛಾ಼ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","ಇನಖ್ಹಾಜೆ ಯೋಸ್‌, ಧನ್‌-ದೌಲತ್‌ನ ಜ಼ಮಕರಿಲ್ಯವಾಳಾನಿ ಹಾಲ್‌ಬಿ ಅಮ್ಮಸ್, ಕತೋಬಿ ದೇವ್ನ ಡೋಳಾಮ ಇವ್ಣೆ ಶೌಕಾರ್ ಕಾಹೆ. ");
INSERT INTO vaa_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","ಅಜು಼ ಯೇಸುನೆ ಇನ ಶಿಷ್ಯರ್‌ನ, “ಅನಖ್ಹಾಜೆಸ್ ಮೇ ತುಮೂನ ಬೋಲುಸ್ಕಿ, ಜಿವಿರ‍್ಹವಾನಟೇಕೆ ಶಾತ್ ಖಾಣು ಖಾಶುಕರಿ ರ‍್ಹವೊ, ನತರ್‌ಕಿ ಶರೀರ್‌ನ ಪೆರ‍್ಹಾನ ಲುಂಗ್ಡಾವ್‍ನಟೇಕೆ ರ‍್ಹವೊ ವೇಚ಼್‌ಣೆ ನಕೊ ಕರೊ. ");
INSERT INTO vaa_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","ಖಾಣಥೀಬಿ ಜಾನ್‌, ಅಜು಼ ಲುಂಗ್ಡಾವ್‌ಥೀಬಿ ಶರೀರ್ ಮಹಾನ್ ಹುಯಿರ‍್ಹೂಸ್. ");
INSERT INTO vaa_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","ಕಾಂಗಣ್ಣ ಅಖ್ಖು ದೇಖೊ, ಯೋ ಪಿಕಾವಕೊಯ್ನಿ ವ್ಹಾಡಾಬಿ ಕೊಯ್ನಿ; ಇವ್ಣುನ ಜ಼ಮಕರಾನು ಘರ್‌ಬಿ ಕೊಯ್ನಿ, ಕಣ್ಗಿಬಿ ಕೊಯ್ನಿ; ಇಮ್‌ ರ‍್ಹಯುತೋಬಿ, ದೇವ್ ಇವ್ಣುನ ಖಡೈನ್ ಪಾಳಸ್. ಉಡಂತು ಜಿನಾವರ್‌ಥೀಬಿ ತುಮೆ ಕೆತ್ರೇಕ್ಕಿ ಊಚ಼ ಹುಯಿರ‍್ಹಾಸ್. ");
INSERT INTO vaa_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","ಅನಿ ಬಾರೇಮ ವೇಚ಼್‌ಣೆ ಕರಾಥಿ, ತುಮಾರಿ ಉಂಬರ್ ಭಡಾವನ ಕೀನೇಥಿಬಿ ಉಶೇಕಿ ಶು? ");
INSERT INTO vaa_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","ನ್ಹನ್ನಾನು ಕಾಮ್ ಕರಾನಸ್‍ ತುಮಾರ ಹಾತೆ ಕೋ ಹುವ್ವಾನಿತೆ, ಮೋಟು-ಮೋಟು ಕಾಮ್ನಿ ಬಾರೇಮ ತುಮೆ ಶನ ವೇಚ಼್‌ಣೆ ಕರೊಸ್ತೆ? ");
INSERT INTO vaa_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","ಜ಼ಂಗ್‍ಳಿಫೂಲ್‍ ಫುಟಾಸ್ತೆ ತರಿಕಾನ ದೇಖೊ; ಯೊ ಮ್ಹಿನತ್ ಕರಕೊಯ್ನಿ ಅಜು಼ ಇನಖ್ಹಾಜೆ ಲುಂಗ್ಡಾವ್‍ನಾಬಿ ಶಿವಿಲೆಯಿಕೋಯ್ನಿ. ತೋಬಿ ಮೇ ತುಮೂನ ಬೋಲುಸ್ಕಿ, ರಾಜ಼ ಸೊಲೊಮೋನ್ನಾಬಿ, ಇನಾಕನ ಥೂತೆ ಖ್ಹಾರುಸ್‌ ಖ್ಹೋನ್ನುಖ್ಹರಪ್‌ ಅಜು಼ ರಾಜಾ಼ನು ಪೇರ್‌ವಾಖ್ಹ್‌ನ ಫೇರ‍್ಯೊತೋಬಿ, ಆ ಫೂಲ್‌ಮ ಏಕ್‌ನ ಛಾ಼ತೆ ಶನ್‌ಗಾರ್ ಇನ ಕೋ ಥೂನಿ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","ಅಲಾ, ದರ್ರಾಶಿ ವಿಶ್ವಾಸ್‍ವಾಳ, ಹಮ್ಕೆರ‍್ಹೀನ್ ಕಾಲೆ ಚು಼ಲ್ಹಾಮ ಬಳಿಜಾ಼ವಾನ ಜ಼ಂಗ್‌ಳಿ ಘಾಖ್ಹ್‌ನ ದೇವ್ ಅಮ್‍ ಪೇರ‍್ಹಾಯೋತೊ ಅನೇಥಿಬಿ ಜಾ಼ಖ್ಹತ್ ತುನ ಹೊಢೈಫೆರಾವ್‍ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","ಅನಖ್ಹಾಜೆಸ್ ಶಾತ್‌ ಖಾಣು? ಶಾತ್‌ ಪೀಣು? ಕರಿ ಬೋಲಿನ್, ಕದೇಬಿ ಸೋಚ಼್‌ತಾಹುಯಿನ್‌, ಪಸ್ತಾವೊ ನಕೊ. ");
INSERT INTO vaa_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","ಅನಿ ಖ್ಹಾರಿ ಬಾರೇಮ, ಆ ಜಗತ್‍ನುಅದ್ಮಿ ಕದೇಬಿ ಪಸ್ತಾವಸ್. ಆ ಅಖ್ಖು, ತುಮೂನ ಜ಼ರೂರತ್ ಛಾ಼ಕರಿ ಪರಲೋಕ್‌ನೊ ತುಮಾರ ಬಾನ ಮಾಲುಮ್‌. ");
INSERT INTO vaa_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","ಅನಬದಲ್, ದೇವ್ನು ರಾಜ್ಯನಖ್ಹಾಜೆ ತರ್ಖ್ಹೊ, ತದೆ ಆ ಖ್ಹಾರು ಯೋಸ್‌ ತುಮೂನ ದಿಶೆ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“ನ್ಹಾನಿ ಝೂ಼ಂಡ್‌, ಡರ್‌ನಕೊ; ಯೋ ರಾಜ್ಯನ ತುಮೂನ ದ್ಯವಾನ ತುಮಾರೊ ಬಾನ ಖ್ಹುಶಿ ಛಾ಼. ");
INSERT INTO vaa_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","ತುಮಾರಕನ ಛಾ಼ತೆ ಖ್ಹಾರುಸ್‌ ವೇಚಿನ್, ಆವಸ್ತೆ ಪೈಶಾನ ಗೋರ್‌-ಗರೀಬ್‌ನ ದೇವೊ. ತುಮಾರಕನ ಫಾಟಕೊಂತೆ ಚ಼ಂಚಿಯೇನ ಕರಿಲೆವೊ, ಪರ್‌ಲೋಕ್‌ಮ ಕಮ್ ಹುವಾಕೊಂತೆ ಶೊತ್ನ ಜ಼ಮಕರಿಲೇವೊ, ಕೆಹೊ ಚೋ಼ರ್‌ಬಿ ಇನ ಖನ್ನೆ ಆವಾನ ಕೋ ಆವಾನಿ ಅಜು಼ ಇನ ಕೋರ‍್ಹ ಖೈನ್‌ ಬರ್ಬಾತ್ ಕೋ ಉಶೇನಿ. ");
INSERT INTO vaa_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","ತುಮಾರಿ ಶೊತ್‌ ಕಿಜ್ಜಾ಼ ರ‍್ಹೇಸ್ಕಿ, ಹಿಜ್ಜಾ಼ಸ್ ತುಮಾರೊ ದಿಲ್‌ಬಿ ರ‍್ಹೇಸ್‌. ");
INSERT INTO vaa_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“ಶಾತ್ಬಿ ಆವೊ ತೈಯಾರ್ ರ‍್ಹವೊ, ಲುಂಗ್ಡ ಪೇರ‍್ಹಿನ್‌ ಖ್ಹವಾರಿರಾಖೊ, ತುಮಾರೊ ದೀವೊಖ್ಹಾರು ಲಾಗ್ತುರ‍್ಹವಾದೆ, ");
INSERT INTO vaa_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","ತುಮೇತೊ, ಇವ್ಣೊ ಯಜಮಾನ್ ಆಯಿನ್, ಬಾಕಲ್ ಮಾರ್‌ತಾಸ್ ಕಾಡಾನ ತೈಯಾರ್ ರ‍್ಹೀನ್, ವ್ಯಹಾನು ಖಾಣು ಖೈನ್, ಕದೆ ಪಾಛೊ಼ಫರಿ ಆವ್‍ಶೆಕರಿ ಜ಼ಪಿರ‍್ಹೇಸ್ತೆ ಆಳ್‌ನಿಮತ್‌ ರ‍್ಹವೊ. ");
INSERT INTO vaa_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","ಯಜಮಾನ್ ಐನ್ ಬಾಕಲ್ ಮಾರಾನಿ ವಖ್ಹತ್‌ಮ, ಇವ್ಣೆ ಬಾಕಲ್ ಕಾಡಸ್‌. ಪಾಛೊ಼ ಪ್ರಭು ಫರಿಅಯಿನ್‌, ಕೆಹೊಖ್ಹಾರೊ ಆಳ್‌ ತೈಯಾರ್ ಹುಯಿರ‍್ಹಿನ್, ಇನಖ್ಹಾಜೆ ಜ಼ಪಿರ‍್ಹೇವಾನು ಯೋ ದೇಖಾಸ್ಕಿ ಇವ್ಣೆ ಧನ್ಯ ಹುಯಿರ‍್ಹಿಶೆ! ಮೇ ತುಮೂನ ಖ್ಹಾಚಾಮ ಬೋಲುಸ್ಕಿ, ಯೋ ಇನಿ ಕಂಬರ್‌ನ ಲುಂಗ್ಡು ಭಾಂದಿಲೀನ್, ಇವ್ಣುನ ಖಾಣನ ಬೆಖ್ಹಾಡಿನ್‌, ಇವ್ಣ ಖನ್ನೆ ಐನ್, ಇವ್ಣಿ ಚಾ಼ಕ್ರಿ ಕರ್ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","ಯೋ ಅಧಿರಾತ್ಮಾಸ್‌ಕಿ, ನತರ್‌ಕಿ ಇನೇಥಿಬಿ ಜಾ಼ಖ್ಹತ್ ವಖ್ಹತ್ ಲಗಾಡಿನಸ್ಕಿ ಆಯೊತೋಬಿ, ಕೋಣ್ ತೈಯಾರ್ ಹುಯಿರ‍್ಹೇಸ್ತೆ ಯೋ ದೇಖಾಸ್ಕಿ, ಇವ್ಣೆ ಧನ್ಯ ಹುಯಿರ‍್ಹೂಸ್. ");
INSERT INTO vaa_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","ಆ ವಾತೆ ತುಮಾರಿ ಯಾದ್ಮ ರ‍್ಹವಾದೆ; ಚೋ಼ರ್ ಆವಾನಿ ವಖ್ಹತ್ ಘರ್‌ನ ಯಜಮಾನ್ನ ಮಾಲುಮ್ ರ‍್ಹಯುಹೋತ್ತೊ, ಯೋ ಹೊಷಾರಿ ರ‍್ಹೀನ್, ಇನ ಘರ್‌ನ ಲೂಟದಿದೊಹೋತ್‌ ಕೊಯ್ನಿ. ");
INSERT INTO vaa_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","ಇಮ್ಮಸ್, ತುಮೇಬಿ ತೈಯಾರ್ ರ‍್ಹೇಣು, ಶನಕತೊ ತುಮೆ ಸೋಚಾಸ್‌ಕೊಂತೆ ವಖ್ಹತ್‌ಮ ಅದ್ಮಿನೊ ಛಿಯ್ಯೊ ಆವ್‌ಶೆ.” ");
INSERT INTO vaa_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","ತದೆ ಪೇತ್ರನೆ, “ಪ್ರಭು, ತುನೆ ಆ ಮತ್ಲಬ್‌ನಿ ಖೇಣಿನ ಬೋಲ್ಯೊತೆ ಹಮಾರ ಟೇಕೆಕಿ, ಹರೇಕ್ ಅದ್ಮಿನ ಟೇಕೆ?” ಕರಿ ಪುಛಾ಼ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","ಯೇಸುನೆ ಶಾತ್‍ಬೋಲ್ಯೊಕತೊ, ವೇಳ್‍ವೇಳ್ನ ಹೋಣುತೆ ಯೊ ಜಿನಖ್ಹ್‌ನ ಮಾಪಿನ್‌ ದ್ಯವಾನಖ್ಹಾಜೆ ಯಜಮಾನ್ನೆ ಇನ ಘರ್‌ಮ ನೇಮ್‌ಶಾಯೋತೆ ನಿಯತ್‍ವಾಳೊಬಿ ಅಕ್ಲೀಬಿ ಹುಯಿರೋತೆ ಘರ‍್ನೊಸೇವಕ ಕೋಣ್? ");
INSERT INTO vaa_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","ಘರ್‌ನೊ ಯಜಮಾನ್ ಐನ್, ಕೆಹೊ ಆಳ್‌ ಆ ಖ್ಹಾರು ಕರುಕರಾತೆ ಕರಿ ದೇಕ್‌ಶೇಕಿ, ಯೋ ಆಳ್‌ ಧನ್ಯ ಹುಯಿರ‍್ಹೋಸ್. ");
INSERT INTO vaa_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","ಯೋ ಯಜಮಾನ್ ಇಮ್ನ ಆಳ್‌ನ ಇನು ಖ್ಹಾರೂಸ್ ಧನ್‌-ದೌಲತ್‌ಪರ್ ಅದಿಕಾರಿಹುಯಿನ್ ನೇಮ್‌ಶಾವ್‌ಶೆ ಕರಿ ಮೇ ತುಮೂನ ಖ್ಹಾಚಮಾಬಿ ಬೋಲುಸ್, ");
INSERT INTO vaa_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","ಕತೋಬಿ ಯೋ ಆಳ್‌, ಇನೊ ಯಜಮಾನ್ ಒಗ್ಗಿಸ್‌ಮ ಕೋ ಆವ್‌ಶೇನಿ ಕರಿ ಇನ ಮನ್‌ಮ ಸೋಚಿಲೀನ್, ಬಿಜಾ಼ಖ್ಹಾರ ತಯೇಡ-ಪರ್ಖ್ಹಾ ಆಳ್‌ನ ಮಾರ್‌ತೊಹುಯಿನ್, ಖೈ-ಪೀನ್ ಉರಾಳಲಗ್ಯೊತೊ, ");
INSERT INTO vaa_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","ತದೆ ಯೊ ಆಳ್‌ ಸೋಚಾಸ್‌ಕೊಂತೆ ದನ್ಮ ಅಜು಼ ಇನ ಮಾಲುಮಸ್ ಪಡಾಕೊಂತೆ ವಖ್ಹತ್‌ಮ, ಇನೊ ಯಜಮಾನ್ ಐನ್, ಇನ ಕತ್ರೀನ್ ಟುಕ್‌ಡಾ-ಟುಕ್‌ಡಾ ಕರೀನ್, ವಿಶ್ವಾಸ್‌ಕೊಂತೆ ಅದ್ಮಿನ ನಾಖಸ್ತೆ ಝ಼ಗೋಪರ್ ಇನ ನಾಕ್‌ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","ಏಕ್‌ ಆಳ್‌, ಇನೊ ಯಜಮಾನ್ನ ಇನೇಥಿ ಶಾತ್‌ ಹೋಣುಕರಿ ಮಾಲುಮ್ ರ‍್ಹೀನ್‌ಬಿ, ಯೋ ತೈಯಾರ್‌ಹುಯಿನ್, ಯೋ ಕಾಮ್ನ ನಾ ಕರ‍್ಯೋತೊ, ಇನ ಬರೊಬರ್‌ನೊ ಮಾರ್ ಪಡ್‌ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","ಕತೋಬಿ ಏಕ್‌ ಆಳ್‌ನ, ಇನೊ ಯಜಮಾನ್ನ ಇನೇಥಿ ಶಾತ್‌ ಹೋಣುಕರಿ ಮಾಲುಮ್‌ ಕೊಂತೆ, ಮಾರ್ ಖಾವಖ್ಹರ್ಕು ಕಾಮ್ ಕರ‍್ಯೋತೊ, ಇನಾಬಿ ದಂಡ್‌ ಮಳ್‌ಶೆ. ಕತೋಬಿ ಇನು ಕಾಮ್ ಶಾತ್‌ಕರಿ ಮಾಲುಮ್‌ ಕರೀನ್‍ಬಿ, ಇನ ಕರ‍್ಯುಕೊಂತೆ ಯೋ ಆಳ್‌ಥೀಬಿ, ಅನ ಕಮ್ ಮಾರ್ ಪಡ್‌ಶೆ. ಕಿನ ಜಾ಼ಖ್ಹತ್ ದೆವೈರ‍್ಹೂಸ್ಕಿ, ಇನೇಥಿ ಜಾ಼ಖ್ಹತ್ ಮಳ್‌ಶೆಕರಿ ಆಖ್ಹ್ ಕರ್ಶೆ, ಬಿಜೂ಼ಬಿ ಜಾ಼ಖ್ಹತ್ ದೆವೈರ‍್ಹೂತೆ ಇನಾಕಂಥು, ಬಿಜೂ಼ಬಿ ಜಾ಼ಖ್ಹತ್ ಮಳ್‌ಶೆಕರಿ ಆಖ್ಹ್ ಕರ್ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“ಮೇ ಆಯೋತೆ, ಜ಼ಮೀನ್‌ಪರ್ ಆಗ್ ನಾಕ್ಣುಕರಿ; ಅತ್ರಾಸ್‌ಮ ಯೋ ಲಾಗಿಗಯುಹೋತ್ತೊ ಮನ ಕೆತ್ರೇಕ್ಕಿ ಖ್ಹುಶಿ ಹುಯುಹೋತ್! ");
INSERT INTO vaa_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","ಕತೋಬಿ, ಮನ ಬಿಜೇಕ್ ತರ‍್ಹಾನು ಬ್ಯಾಪ್ತಿಸ್ಮ ಏಕ್‌ ಮಳ್‌ಣು. ಯೋ ಮಳಾತೋಡಿ, ಮೇ ಘಣಿ ಖ್ಹತಾಪ್ಣಿಮ ಛೂ಼. ");
INSERT INTO vaa_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","ಜ಼ಮೀನ್‌ಪರ್ ಶಾಂತಿ ದ್ಯವಾನಟೇಕೆ, ಮೇ ಆಯೊಕರಿ ತುಮೆ ಸೋಚೋ಼ಸ್‌ಕಿ? ಕೊಯ್ನಿ! ಶಾಂತಿ ದ್ಯವಾನ ಕಾಹೆ, ಕತೋಬಿ ತೋಡಾವಾನ ಐರ‍್ಹೋಸ್! ಕರಿ ಮೇ ತುಮೂನ ಬೋಲುಸ್. ");
INSERT INTO vaa_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","ಕಿಮ್‌ಕತೊ, ಹಂಕೇಥು ಎಕ್ಕಸ್ ಘರ್‌ಮ ಛಾ಼ತೆ ಪಾಚ಼್ ಅದ್ಮಿಮ, ಬೇ ಜ಼ಣಾನ ವಿರೋದ್ ತೀನ್ ಜ಼ಣ ಉಠ್‍ಶೆ, ತೀನ್ ಜ಼ಣಾನ ವಿರೋದ್ ಬೇ ಜ಼ಣ ಉಟ್‌ಶೆ, ಅಮ್ ಇವ್ಣಾಮ ಭಾಗ್‌ ಪಡಿಜಾ಼ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","ಛಿಯ್ಯಾನಿ ವಿರೋದ್ ಬಾ, ಬಾನಿ ವಿರೋದ್ ಛೀಯ್ಯೊ; ಛೋ಼ರಿನಿ ವಿರೋದ್ ಆಯ, ಆಯಾನಿ ವಿರೋದ್ ಛೋ಼ರಿ, ವ್ಹವ್‌ನಿ ವಿರೋದ್ ಖ್ಹಾಖ್ಹು, ಖ್ಹಾಖ್ಹುನಿ ವಿರೋದ್ ವ್ಹವ್ ಉಟ್‌ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","ಎತ್ರೆಸ್ ಕಾಹೆತೆ ಯೇಸುನೆ ಅದ್ಮಿ ಖ್ಹಾರಾನಾಬಿ ಬೋಲ್ಯೋಕಿ, “ತುಮೆ ಪಶ್ಚಿಮ್ ದಿಕ್ಮ ಪಾಣಿನೊ ಮೋಡ್ ದೆಖಾವ್‌ತಾಸ್‌ನ, ‘ಪಾಣಿ ವರಖ್ಹ್‌ಶೆ’ ಕರಿ ಬೋಲಾಸ್ನಿ, ಇಮ್ಮಸ್ ಪಾಣಿ ವರ್ಖ್ಹಾಸ್. ");
INSERT INTO vaa_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","ದಕ್ಷಿಣ್ ದಿಕ್‌ಮಾಥು ವಹಿರೊ ವಾಗಲಗ್ಯೋತೊ, ‘ಗರ್ಮಿ ಉಟ್‌ಶೆ’ ಕರಿ ತುಮೆ ಬೋಲೋಸ್, ಯೋಬಿ ಇಮ್ಮಸ್ ಹುವಾಸ್. ");
INSERT INTO vaa_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","ಠಗಾರ‍್ಯ, ತುಮೆ ಆಬ್‍ ಧರ್ತಿನ ದೇಖಿನ್, ಇನು ಮೋಸಮ್‌ನ ತುಮೆ ಮಾಲುಮ್ ಕರಿಲೆವೋಸ್‌ನಿ, ಇಮ್‌ ರ‍್ಹವಾಪರ್, ಆ ವಖ್ಹತ್‌ನ ಪರ್ಖಾನ ತುಮೂನ ಕೋ ಹುವ್ವಾನಿಕಿ ಶು? ");
INSERT INTO vaa_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","ಖ್ಹಾಚು಼ ಖಿವು ಕರಿ ತುಮೇಸ್ ಶನ ತೀರ್ಪ್‌ಕರಾಕೊಯ್ನಿ? ");
INSERT INTO vaa_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","ತಾರಪರ್ ಹೊಜ಼್ಜತ್‌ಕರ್ನು ಕರಿ ಛಾ಼ತೆ ಇನ ಜೋ಼ಡೆ ನೈಯಾಕನ ಜಾ಼ವಾನಿ ವಖ್ಹತ್‌ಮ, ವಾಟ್‌ಪರಸ್ ಝ಼ಗ್ಡಾನ ಪರಿಹಾರ್‌ ಕರಾನ ಕೋಶಿಶ್ ಕರ್‌. ನತರ್‌ಕಿ ಯೋ ತುನ ನೈಯಾಕನ ಖೇಚಿಲಿಜಾ಼ಶೆ, ಯೋ ನಯ್ಯೊ ಜೇಲ್‌ನ ಶಿಪಾಯಿನ ಹಾತ್ಮ ದಿಶೆ ಅಜು಼ ಯೋ ತುನ ಜೇಲ್‌ಮ ಕೋಂಡಿಘಾಲ್‌ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","ಏಕ್‌ ಪೈಶೂಬಿ ಜಿನುಕು ಮ್ಹೇಲ್‌ಶೆಕೊಂತೆ, ಅಖ್ಖುಸ್ ಪೈಶು ಫೇಡಾವಲಗೂಬಿ, ತೂ ಹಿಜ಼್ಜಾಥೊ ಭಾರ್‌ ಛು಼ಟಿಶ್‌ಕೊಯ್ನಿ ಕರಿ ಮೇ ತುನ ಬೋಲುಸ್” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","ಯೋಸ್ ವಖ್ಹತ್‌ಮ, ಹಿಜ್ಜಾ಼ ಥೂತೆ ಥೋಡು ಜ಼ಣು, ಪಿಲಾತನೆ ಗಲಿಲಾಯವಾಳನು ಲ್ಹೋಯಿನ, ಇವ್ಣೆ ದೇವ್ನ ಬಲಿದಿದೂತೆ ಲ್ಹೋಯಿನ ಜೋ಼ಡೆ ಮಳಾಯೋತೆ ಬಾರೇಮ ಯೇಸುನ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","ತದೆ ಯೇಸುನೆ ಇವ್ಣುನ, “ಯೋ ಗಲಿಲಾಯವಾಳು ಇಮ್ನಿ ತರಿಕಾಥಿ ಮರ‍್ಯುತೆ ದೇಖಿನ್, ಇವ್ಣೆ ಬಿಜಾ಼ಖ್ಹಾರ ಗಲಿಲಾಯವಾಳಾಥೀಬಿ ಪಾಪಿ ಕರಿ ಸೋಚೋ಼ಸ್ಕಿ ಶು? ");
INSERT INTO vaa_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","ಇಮ್‌ ನಾ ಸೋಚ್‌ನು! ಕರಿ ಮೇ ತುಮೂನ ಬೋಲುಸ್. ದೇವ್‌ಭಣಿ ಫರ‍್ಯನಾತೊ ತುಮೆಅಖ್ಖು ಇಮ್ಮಸ್ ನಾಶ್ ಹುಯಿಜಾ಼ಶು. ");
INSERT INTO vaa_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","ಸಿಲೋಮ್‌ಮ ಊಚಿ ಭೀತ್ ಪಡೀನ್ ಮರ‍್ಯುತೆ ಯೋ ಅಠಾರ ಅದ್ಮಿ, ಯೆರೂಸಲೇಮ್ಮ ಛಾ಼ತೆ ಬಿಜಾ಼ಖ್ಹಾರಾಸ್‌ ಅದ್ಮಿಥೀಬಿ ಅಪರಾದಿ ಕರಿ ಸೋಚೋ಼ಸ್ಕಿ ಶು? ");
INSERT INTO vaa_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","ಇಮ್‌ ಕಾಹೆ! ಕರಿ ಮೇ ತುಮೂನ ಬೋಲುಸ್. ತುಮಾರು ಪಾಪ್ನ ಮ್ಹೇಲಿನ್ ನಾ ಫರ‍್ಯಾತೊ, ತುಮೆಖ್ಹಾರುಬಿ ಇಮ್ಮಸ್ ಮರ್‌ಶು” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","ಅನ ಬಾದ್‌ಮ ಯೇಸುನೆ ಏಕ್‌ ಮತ್ಲಬ್‌ನಿ ಖೇಣಿನ ಬೋಲ್ಯೊ: ಯೋ ಶಾತ್‌ಕತೊ, “ಏಕ್‌ ಅದ್ಮಿನೆ ಇನು ದ್ರಾಕ್ಷಿನು ಬಾಗ್‌ಮ ಏಕ್‌ ಅಂಜೀರ್‌ನು ಝಾ಼ಡ್‌ಣ ಪಾಳಿರಾಖ್ಯೋಥೊ. ಏಕ್‌ ಹಲ್ಲ ಯೋ ಅದ್ಮಿ ಯೋ ಝಾ಼ಡಾಮ ಪಂಡು ಢೂಂಡ್‌ತುಹುಯಿನ್, ಹಿಜ್ಜಾ಼ ಆಯು, ಕತೋಬಿ ಏಕ್‌ಬಿ ಮಳ್ಯುಕೊಯ್ನಿ. ");
INSERT INTO vaa_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","ತದೆ ಯೋ ಅದ್ಮಿ ಬಾಗ್‌ ದೇಖಿಲ್ಯವಾಳಾನ, “ಹಂದೇಕ್, ಮೇ ತೀನ್ ವರಖ್ಹ್‌ಥೋಬಿ ಆ ಅಂಜೀರ್‌ನ ಝಾ಼ಡಾಮ ಪಂಡು ಢೂಂಡ್ತೊ ಆಯೊ, ಕತೋಬಿ ಏಕ್‌ಬಿ ಮಳ್ಯುಕೊಯ್ನಿ. ಅನ ಕತ್ರಿ ನಾಕ್! ಅನೇಥಿ ಧರ್ತಿನ ಶನಖ್ಹಾಜೆ ಫಾಯಿದೊಕೊಂತೆ ಇಮ್‌ ಹೋಣು” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","ತೋಬಿ ಯೋ ಬಾಗ್‌ನ ದೇಖಿಲ್ಯವಾಳಾನೆ, “ಪ್ರಭು, ಆ ವರಖ್ಹ್‌ಬಿ ಅನ ಮ್ಹೆಂದೆ; ಎತ್ರಾಮ ಮೇ ಅನ ಅಶ್‌ಪಿಶ್‍ ಖೋಂದಿನ್, ಗೋಬರ್ ನಾಖುಸ್. ");
INSERT INTO vaa_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","ಹಮ್ಕೆನ ವರ್‌ಖ್ಹೆತೋಬಿ ಅಂಜೀರ್‌ ಮ್ಹೇಲ್ಯೂತೊ ಮ್ಹೇಲಾದೆ, ನತರ್‌ಕಿ ಅನ ಕತ್ರಿ ನಾಖಿದಿಯೇಜಾ಼ಯಿ” ಕರಿ ಜ಼ವಾಬ್‌ದಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","ಏಕ್‌ ದನ್ನೆ ಸಬ್ಬತ್‌ಮ ಯೇಸು ಸಬೆ ಭರಾವಾನು ಮಂದಿರ್‌ಮ ವಚನ್ ಬೋಲಿದೆವ್‍ಕರ್ತೋಥೊ. ");
INSERT INTO vaa_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","ಹಿಜ್ಜಾ಼ ಅಠಾರ ವರಖ್ಹ್‌ಥು ಭೂತ್‌ ಧರೀನ್, ಆಂಗ್‌ತನ್‌ಮ ರೋಗ್‌ ಥೂತೆ ಏಕ್‌ ತಯೇಡ ಥಿ. ಇನು ಢೋಪ್‌ರು ಝು಼ಕಿರ‍್ಹೂಥು ಅಜು಼ ಇನ ಜ಼ರಾಬಿ ಮುಡ್‌ಕ್ಯು ಉಪ್ಪರ್ ಪಾಡೀನ್, ಉಭು ಭೀರ‍್ಯಾವನ ಕೋ ಹೋತುಥೂನಿ. ");
INSERT INTO vaa_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","ಯೇಸುನೆ ಇನ ದೇಖಿನ್, ಖನ್ನೆ ಬುಲೈನ್ ಇನ, “ಬಾಯಿ, ತಾರ ರೋಗ್‌ಥಿ ತೂ ಛು಼ಟಿಗಿ!” ಕರಿ ಬೋಲಿನ್, ");
INSERT INTO vaa_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","ಇನಾಪರ್ ಇನೊ ಹಾತ್‌ ಮ್ಹೇಲ್ಯೊ, ಮ್ಹೇಲ್‌ತಾಸ್‌ನ ಯೋ ಉಭು ಭೀರಿಗೈ ಅಜು಼ ಇನೆ ದೇವ್ನ ಸ್ತುತಿ ಕರಿ. ");
INSERT INTO vaa_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","ಕತೋಬಿ ಯೋ ಸಬೆ ಭರಾವಾನು ಮಂದಿರ್‌ನು ಅದಿಕಾರಿನೆ ಅನ ದೇಖಿನ್, ಸಬ್ಬತ್‌ ದನ್ಮ ಯೇಸುನೆ ಅಛ್ಛು಼ ಕರ‍್ಯೋನಿ ಕರಿ ಬೋಲಿ ಇರಾದೊ ಖೈನ್, ಅದ್ಮಿ ಖ್ಹಾರಾನ, “ಕಾಮ್ ಕರಾನ ಛೊ಼ ದನ್ ಛಾ಼, ಯೋ ದನೂಮ ಐನ್ ಅಛ್ಛು಼ ಕರೈಲೆವೊ; ಸಬ್ಬತ್‌ ದನ್ಮ ಪಣ್ಕಿ ನಕೊ!” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","ಯೋ ವಾತೇನ ಖ್ಹಮ್‌ಜಿನ್‌ ಪ್ರಭುನೆ ಇನ, “ತುಮೆ ಠಗಾರು ತುಮಾರಾಮ ಹರೇಕ್ ಜ಼ಣು ಸಬ್ಬತ್‌ ದನ್‌ಮಾಬಿ, ಇವ್ಣು ಢಾಂಡೊ ರ‍್ಹವೊ, ಗಧೇಡಾನ ರ‍್ಹವೊ ಕೋಠಾಮಾಥು ಛೋ಼ಡಿನ್, ಪಾಣಿ ಪಿಡಾವಾನಟೇಕೆ ಧರ್‌ಲಿ ಜಾ಼ಸ್‌ನಿ. ");
INSERT INTO vaa_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","ಇಮ್‍ಕತೊ, ಅಠಾರ ವರಖ್ಹ್‌ಥು ಶೈತಾನ್ನೆ ಭಾಂದಿರಾಖ್ಯೋತೆ, ಆ ಅಬ್ರಹಾಮ್‌ನಿ ಪಿಳ್ಗಿವಾಳಿನ ಸಬ್ಬತ್‌ನ ದನ್ಮ ಭಂದಣ್‍ಮಾಥು ಛೋ಼ಡಾವ್‍ಣು ನಾಕಿಶು?” ಕರಿ ಜವಾಬ್‌ ದಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","ಯೇಸುನಿ ಆ ವಾತೇನ ಖ್ಹಮ್‌ಜಿನ್‌, ಯೇಸುನ ವಹೇರ್‌ ಕರಾವಾಳು ಖ್ಹಾರಾನ ಖ್ಹರಮ್‌ಲಾಗ್ಯು. ಕತೋಬಿ ಅದ್ಮಿಖ್ಹಾರು ಯೇಸುಥಿ ಹುಯೂತೆ ತಮಾಮ್‌ ಮಹಾನ್‍ ಕಾಮ್ನಟೇಕೆ ಖ್ಹುಶಿ ಕರ‍್ಯು. ");
INSERT INTO vaa_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","ಯೇಸುನೆ ಪುಛಾ಼ಯೋಕಿ, “ದೇವ್ನಿ ರಾಜ್ಯ ಕಿನೀನಿಮತ್‌ ಛಾ಼? ಇನ ಮೇ ಶನೇಥಿ ಏಕ್‌ಕರು? ");
INSERT INTO vaa_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","ಯೋ ರಾಯಿನ ದಾಣಾನಿ ಘೋಣಿ ಛಾ಼. ಏಕ್‌ ಅದ್ಮಿನೆ ಇನ ಲೀಜೈ಼ನ್ ಇನ ಖೇತರ್‌ಮ ಗಾಡ್ಯು. ತದೆ ಯೋ ಮೋಟುಹುಯಿನ್, ಝಾ಼ಡು ಹುಯು ಅಜು಼ ಆಬ್‍ಪರ್‌ ಉಡಾತೆ ಜಿನಾವರ್ ಖ್ಹಾರು ಆಯಿನ್, ಯೋ ಝಾ಼ಡಾನಿ ಡಾಳಿಯೆಪರ್ ಮ್ಹಾಳ ಭಾಂದಿಲಿದು. ");
INSERT INTO vaa_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","ಯೇಸುನೆ ಬಿಜೂ಼ಬಿ ಪುಛಾ಼ಯೋಕಿ, “ದೇವ್ನಿ ರಾಜ್ಯನ ಮೇ ಶನೇಥಿ ಏಕ್‌ಕರು? ");
INSERT INTO vaa_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","ಯೋ ಶೋಡಾನಿ ಘೋಣಿ ಛಾ಼. ಏಕ್‌ ತಯೇಡ ಇನ ಲೀಜೈ಼ನ್, ತೀನ್ ಶೇರ್ ಆಟಾಮ ಕಲೈನ್ ಮ್ಹೇಲಾಖ್ಹತರ್‌, ಯೋ ಆಟೊ ಖ್ಹಾರುಸ್‌ ಫುಗಿಆಯು. ");
INSERT INTO vaa_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","ಯೇಸು ಹರೇಕ್ ಖ್ಹಯೇರ್‌ಮ ಅಜು಼ ಗಾಮ್ಮ ವಚನ್ ಬೋಲಿದೇತೊಹುಯಿನ್‌, ಯೆರೂಸಲೇಮ್‌ ಭಣಿ ವಳ್ಯೊಜಾ಼ತೋಥೊ. ");
INSERT INTO vaa_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","ತದೆ ಏಕ್‌ ಜ಼ಣಾನೆ ಯೇಸುನ, “ಪ್ರಭು, ಥೋಡು ಅದ್ಮಿನಾಸ್ ರಕ್ಷಣೆ ಮಳ್‌ಶೇಕಿ?” ಕರಿ ಪುಛಾ಼ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","ಯೇಸುನೆ ಜವಾಬ್‌ ದಿದೋಕಿ, ನ್ಹಾನ ಬಾಕಲ್‌ ವಾಟೆಕರಿ ಮಹಿ ಜಾ಼ವಾನ ಕೋಶಿಶ್‌ ಕರೊ, ಶನಕತೊ ಘಣು ಅದ್ಮಿ ಮಹಿ ಜಾ಼ವ್ಣುಕರಿ ಕರಸ್, ಕತೋಬಿ ಇವ್ಣೊ ಹಾತ್‌ ಕೋಹುಯುನಿ. ");
INSERT INTO vaa_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","ಘರ್‌ನೊ ಯಜಮಾನ್ ಉಠೀನ್, ಬಾಕಲ್‌ ಮೂಚಾ಼ನ ಬಾದ್‌ಮ, ತುಮೆ ಭಾರ್‌ಭೀರಿನ್, ಬಾಕಲ್‌ಪರ್ ಮಾರಿನ್, ‘ಪ್ರಭು, ಮಹಿ ಆವಾನ ಬಾಕಲ್ ಕಾಡ್! ಕರಿ ಬೋಲ್‌ಶು”. ತದೆ ಯೋ, ತುಮೆ ಕಿಜ್ಜಾ಼ವಾಳ ಕರಿ ಮನ ಮಾಲುಮ್ ಕೊಯ್ನಿ! ಕರಿ ಜವಾಬ್‌ ದಿಶೆ. ");
INSERT INTO vaa_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","ತದೆ ತುಮೆ, “ಹಮೆ ತಾರ ಜೋ಼ಡೆ ಖಾದಾಥ, ಪೀದಾಥ. ಹಮಾರಿ ಗಲ್ಲಿಯೇಮ ತುನೆ ಹಮೂನ ವಚನ್ ಬೋಲಿದಿದೋಥೊ ಕರಿ ಬೋಲ್‌ಶು”. ");
INSERT INTO vaa_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","ತೋಬಿ ಯೋ ತುಮೂನ, “ತುಮೆ ಕೋಣ್‌ಕಿ, ಕಿಜ್ಜಾ಼ಥ ಐರ‍್ಹಾಸ್ಕಿ ಮನ ಮಾಲುಮ್ ಕೊಯ್ನಿ! ಹಜ್ಜಾಥೊ ಹಟಿಜಾ಼ವೊ, ತುಮೆ ಖ್ಹಾರು ಖರಾಬ್ ಅದ್ಮಿ! ಕರಿ ಬೋಲ್‌ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","ಅಬ್ರಹಾಮ್, ಇಸಾಕ್, ಯಾಕೋಬ ಅಜು಼ ತಮಾಮ್‌ ಪ್ರವಾದಿ ಖ್ಹಾರು ದೇವ್ನಿ ರಾಜ್ಯನ ಮಹಿ ರ‍್ಹಿಶೆ, ಕತೋಬಿ ತುಮೆ ಪಣ್ಕಿ ಭಾರ್‌ ರ‍್ಹಿಶು! ಅನ ದೇಖಿನ್ ಇವ್ಣೆ ರೊವ್‌ಶೆ ಅಜು಼ ಕರ್‌-ಕರ್‌ ದಾತ್‌ ಚಾ಼ವಾನು ಉಶೆ. ");
INSERT INTO vaa_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","ಅತ್ರೇಸ್ ಕಾಹೆತೆ ಪೂರ್ವ, ಪಶ್ಚಿಮ್, ಉತ್ತರ್ ಅಜು಼ ದಕ್ಷಿಣ್ ದಿಕ್‍ಥು ಅದ್ಮಿಖ್ಹಾರು ಐನ್, ದೇವ್ನಿ ರಾಜ್ಯಮ ಮಿಝ಼್‌ವಾನ್ ಖಾಣನ ಬೇಖ್ಹ್‌ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","ಹಮ್ಕೆ ಪಾಛ಼ಳ್ ಛಾ಼ತೆ ಅದ್ಮಿಖ್ಹಾರು, ತದೆ ಅಗಾಡಿ ರ‍್ಹಿಶೆ, ಅಜು಼ ಹಮ್ಕೆ ಅಗಾಡಿ ಛಾ಼ತೆ ಖ್ಹಾರು, ತದೆ ಪಾಛ಼ಳ್ ರ‍್ಹಿಶೆ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","ಯೋಸ್ ವಖ್ಹತ್‌ಮ ಥೋಡು ಜ಼ಣು ಫರಿಸಾಯರ್ ಯೇಸುಕನ ಐನ್, ತೂ ಹಜ್ಜಾಥೊ ಚ಼ಲ್ಯೊಜಾ಼! ಹೆರೋದ ತುನ ಮಾರಿನಾಕ್ಣು ಕರಿ ಛಾ಼” ಕರಿ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","ತದೆ ಯೇಸುನೆ ಇವ್ಣುನ, “ತುಮೆ ಜೈ಼ನ್, ಆಜ಼್ ಅಜು಼ ಕಾಲ್ ಮೇ ಭೂತ್ ಕಾಡ್ತೊಹುಯಿನ್‌, ರೋಗ್‌ರಾಯೊನ ಅಛ್ಛು಼ ಕರ್ತೊಹುಯಿನ್, ಪರ್‌ಶುನ ದನ್ನೆ ಮೇ ಮಾರು ಕಾಮ್ ಖತಮ್ ಕರ‍್ನು, ಕರಿ ಯೋ ನ್ಹೋರಿನ ಬೋಲೊ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","ತೋಬಿ ಆಜ಼್ ಅಜು಼ ಕಾಲ್, ಅಜು಼ ಪರ್‌ಶುನ ದನ್ನೆತೋಡಿ ಮೇ ಫರ್‌ವಾನು ಛಾ಼. ಪ್ರವಾದಿನ ಯೆರೂಸಲೇಮಸ್ ಪಣ್ಕಿ ಬಿಜಿ ಝ಼ಗೋಪರ್ ನಾ ಮಾರ‍್ನು. ");
INSERT INTO vaa_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","ಯೆರೂಸಲೇಮ್‌, ಯೆರೂಸಲೇಮ್‌ ತೂ, ಪ್ರವಾದಿ ಖ್ಹಾರಾನೊ ಜಾನ್‌ ಕಾಡಾವಾಳಿ. ದೇವ್ನೆ ತಾರಕನ ಮೋಕ್‌ಲ್ಯೊತೆ ಖ್ಹಾರಸ್ನ, ಬಂಡೊ ಫೇಕಿನ್ ಮಾರವಾಳಿ, ಮುರ್‌ಗಿ ಇನ ಚೇಲ್ಕಾನ ಇನಿ ಪಾಖ್ಡಿಯೆಮ ಪೆಖ್ಹಾಡಿಲೇಯಿತೆ ಇಮ್‌, ತಾರ ಲಡ್ಕಾವ್ನ ಮೇ ಪೆಖ್ಹಾಡಿಲೇವ್ಣು ಕರಿ ಮನ ಕೆತ್ರಿಕ್ಕಿಹಲ್ಲ ಮನ್‍ಹುಯು, ಕತೋಬಿ ತುನೆ ಅಮ್ ಕರಾನ ಮ್ಹೇಲಿಕೊಯ್ನಿ! ");
INSERT INTO vaa_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","ಹಂದೇಕ್ ತಾರಿ ಮಂದಿರ್‌ ಉಜ್ಜಾ಼ಡಿ ಪಡಿಜಾ಼ಶೆ. ‘ಪ್ರಭುನ ನಾಮ್‌ಪರ್‌ ಆವಾಳಾನ ಆಶೀರ್ವಾದ್‌ ಹುವಾದೆ’ ಕರಿ ತುಮೆ ಬೋಲಾತೋಡಿ, ತುಮೆ ಮನ ದೇಕ್‌ಶುಸ್ ಕೊಯ್ನಿ, ಕರಿ ಮೇ ತುಮೂನ ಬೋಲುಸ್” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","ಏಕ್‌ಹಲ್ಲ ಸಬ್ಬತ್‌ ದನ್ನೆ ಯೇಸು ಫರಿಸಾಯರ್‌ನು ಮೋಟಾವ್‍ಮ ಏಕ್‌ ಜ಼ಣಾನ ಘರೆ ಖಾಣನ ಗಯೊ. ಹಿಜ್ಜಾ಼ನು ಅದ್ಮಿಖ್ಹಾರು ಯೇಸುನ ನಿಘಾ ಲಗಾಡಿನ್ ದೇಖುಕರ್ತುಥು. ");
INSERT INTO vaa_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","ಹಿಜ್ಜಾ಼ ಯೇಸುನ ಖ್ಹಾಮೆ ಪೆಶರ್‌ ರೋಗ್‌ ಥೋತೆ ಏಕ್‌ ಜ಼ಣೊ ಥೊ. ");
INSERT INTO vaa_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","ತದೆ ಯೇಸುನೆ ಮೋಶೇನು ಧರ್ಮಶಾಸ್ತ್ರ ಶಿಕಾಡವಾಳು ಶಾಸ್ತ್ರಿಯೆ ಅಜು಼ ಫರಿಸಾಯರ್‌ನ, “ಅಪ್ಣಿ ಖಾನುಲ್‌ಮ ಸಬ್ಬತ್‌ ದನ್ಮ ಅಛ್ಛು಼ ಕರಾನು ಬರಾಬರ್‌ಕಿ ಕೊಯ್ನಿ”? ಕರಿ ಪುಛಾ಼ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","ಕತೋಬಿ ಇವ್ಣೆ ಶಾತ್ಬಿ ಫರೈನ್ ಬೋಲ್ಯು ಕೊಯ್ನಿ. ತದೆ ಯೇಸುನೆ ಯೋ ಅದ್ಮಿನು ಹಾತ್‌ ಧರೀನ್, ಇನ ಅಛ್ಛು಼ ಕರೀನ್ ಬೋಲಿಮೋಕ್ಲಿದಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","ತದೆ ಯೇಸುನೆ ಇವ್ಣುನ, “ತುಮಾರಾಮ ಕಿನಾತೋಬಿ ಏಕ್‌ ಜ಼ಣಾನೊ ಛಿಯ್ಯೊ ನತರ್‌ಕಿ ಢಾಂಡೊ ಸಬ್ಬತ್‌ ದನ್ಮ ಬಾವ್ಡಿಮ ಪಡಿಗಯೂತೊ ಯೋ ಇನ ಸಬ್ಬತ್ ದನ್‌ಮಾಬಿ ಉಪ್ಪರ್ ಪಾಡಕೊಯ್ನಿಕಿಶು?” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","ಕತೋಬಿ ಇವ್ಣೆ ಅನಿ ಬಾರೇಮ ಶನೂಸ್ ಜವಾಬ್‌ ದ್ಯವಾನ ಕೋಹುಯುನಿ. ");
INSERT INTO vaa_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","ಖಾಣನ ಬುಲೈ ಮಂಗಾಯುತೆ ಅದ್ಮಿಖ್ಹಾರು, ಖಾಣಾನಿ ಪಹಿಲಿ ಶಾಲ್‌ಮಾನಿ ಅಛ್ಛಿ ಝ಼ಗೋಪರ್ ಬೇಖ್ಹ್‌ಣು ಕರಿ ಝ಼ಗೊ ಚೂ಼ಣುಕರ್ತುಥೂತೆ ದೇಖಿನ್, ಯೇಸುನೆ ಇವ್ಣುನ ಏಕ್‌ ಮತ್ಲಬ್‌ನಿ ಖೇಣಿನ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","ಯೋ ಶಾತ್‌ಕತೊ, “ಕೋಣ್‌ತೋಬಿ ಏಕ್‌ ಜ಼ಣು ತುನ ವ್ಯಹಾನು ಖಾಣು ಖವಾನ ಬುಲಾಯೂತೊ, ಪಂತಿಮ ಪಹಿಲೆಸ್ ನಕೊ ಬೇಶಿಶ್. ಏಕ್‌ ವೇಳ್ ತಾರೆಥೀಬಿ ಮಹಾನ್ ಅದ್ಮಿನ ಇನೆ ಬುಲೈರಾಖ್ಯೊ ಉಶೆ. ");
INSERT INTO vaa_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","ಅಜು಼ ತುಮೂನ ಭೇ ಜ಼ಣಾನ ಬುಲಾಯೋತೆ ಯೋ ಐನ್, ‘ಆ ಝ಼ಗೊ ಅನ ಮ್ಹೆಂದೆ’ ಕರಿ ತುನ ಬೋಲಾನಿ ವಖ್ಹತ್‌ಮ, ತೂ ಖ್ಹರ್‌ಮೈನ್ ಖ್ಹಾರೇಥಿ ಛೇಟುನಿ ಝ಼ಗೋಪರ್ ಜೈ಼ನ್ ಬೇಖ್ಹ್‌ಣು ಪಡ್‌ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","ಕತೋಬಿ ಕೋಣ್‌ತೋಬಿ ತುನ ಬುಲಾಯೂತೊ, ತೂ ಜೈ಼ನ್ ಖ್ಹಾರೇಥಿ ಛೇಟುನಿ ಝ಼ಗೋಪರ್ ಬೇಖ್ಹ್‌. ಅಮ್ ಕರ‍್ಯೋತೊ ತುನ ಬುಲಾಯೋತೆ ಯೋ ಐನ್, ‘ದೋಸ್, ಉಟ್ ಉಪ್ಪರ್‌ಲಿ ಝ಼ಗೋಪರ್ ಐನ್ ಬೇಖ್ಹ್‌’ ಕರಿ ಬೋಲ್‌ಶೆ. ತದೆ ತಾರ ಜೋ಼ಡ್ಮ ಬೆಠೂತೆ ಖ್ಹಾರಾನ ಖ್ಹಾಮೆ ತಾರಿ ಇಜ಼್ಜತ್‌ ಭಡ್‌ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","ಶನಕತೊ ಕೋಣ್ ಇನುಯೋಸ್ ಮೋಟೊಕರಿ ಬೋಲೈಲ್ಯವಾಳೊ ಹರೇಕ್‌ಜ಼ಣೊ ಹೇಟು ಹುಯಿಜಾ಼ಶೆ, ಅಜು಼ ಇನುಯೋಸ್ ಹೇಟುಕರಿ ಬೋಲೈಲ್ಯವಾಳೊ ಯೋ ಮೋಟೊ ಹುಯಿಜಾ಼ಶೆ ಕರಿಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","ಅಜು಼ ಯೇಸುನೆ ಇನ ಖಾಣನ ಬುಲಾಯೋತೆ ಇನಾಬಿ ಏಕ್‌ ವಾತ್ ಬೋಲ್ಯೊ. ಯೋ ಶಾತ್‌ಕತೊ, “ತೂ ಧೊಪಾರ್‌ನಿ ವಖ್ಹತ್‌ಮ ರ‍್ಹವೊ ನತರ್‌ಕಿ ಖ್ಹಾಂಜ಼್‌ನಿ ವಖ್ಹತ್‌ಮ ರ‍್ಹವೊ, ಖಾಣಾನಖ್ಹಾಜೆ ತಾರ ದೋಸ್ತ್‌ನ ರ‍್ಹವೊ, ಭೈಯೇನ ರ‍್ಹವೊ, ತಾರ ಮಾಯಮಾತ್ರಾನ ರ‍್ಹವೊ, ಧನ್‌ದೌಲತ್‌ವಾಳ ಖನ್ನೆವಾಳ ರ‍್ಹವೊ ನಕೊಬುಲೈಶ್. ಬುಲಾಯೋತೊ, ಇವ್ಣೇಬಿ ತುನ ಪಾಛು಼ ಖಾಣನ ಬುಲಾಯೇಜಾ಼ಯ್, ಅನೇಥಿ ತುನೆ ಕರ‍್ಯೊತೆ ಕರ್ನಿನ ಭರ್ನಿ ಮಳಿಜಾ಼ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","ಕತೋಬಿ ತೂ ಮಿಝ಼್‌ವಾನ್ ಪಿಕಾವಾನಿ ವಖ್ಹತ್‌ಮ, ಗೋರ್‌-ಗರೀಬ್‌ನ, ಪಾಂಗ್‌ಳ್ಯಾವ್ನ, ಲಂಗ್ಡಾವ್‍ನ ಅಜು಼ ಕಾಣಾವ್ನ ಬುಲಾವ್. ");
INSERT INTO vaa_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","ತದೆ ತೂ ಧನ್ಯ ಹುಯಿಶ್, ಇವ್ಣೆ ಪಾಛು಼ಫರಿ ಶಾತ್ಬಿ ಕರಾನಕೊಂತೆ ಇವ್ಣೆ, ನೀತಿವಾಳುಖ್ಹಾರು ಮರ್‌ಣ್‌ಮಾಥು ಪಾಛು಼ ಜಿವ್ತುಹುಯಿನ್‍ ಆವಾನಿ ವಖ್ಹತ್‌ಮ ದೇವ್ ತುನ ದೇವ್ಣುತೆ ಇನ ದಿಶೆ. ");
INSERT INTO vaa_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","ಖಾಣನ ಬೆಠುಥೂತೆ ಇವ್ಣಾಮ ಏಕ್‌ ಜ಼ಣು ಆ ವಾತೇನ ಖ್ಹಮ್‌ಜಿನ್‌, ಯೇಸುನ, “ದೇವ್ನಿ ರಾಜ್ಯಮ ಮಿಝ಼್‌ವಾನ್ ಖಾವಾನ ಬೇಖ್ಹವಾಳೋಸ್ ಧನ್ಯ ಹುಯಿರ‍್ಹೊಸ್” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","ತದೆ ಯೇಸುನೆ ಇನ ಬೋಲ್ಯೋಕಿ, “ಏಕ್‌ ಅದ್ಮಿನೆ ಏಕ್‌ ಮೋಟಿ ಮಿಝ಼್‌ವಾನ್ ಪಿಕೈನ್, ಕೈಯೆಕ್ಕಿ ಅದ್ಮಿನ ಬುಲಾಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","ಮಿಝ಼್‌ವಾನ್ ಖಾವಾನಿ ವಖ್ಹತ್ ಆವಾದಿನ್, ಯೋ ಅದ್ಮಿನೆ, ‘ಆವೊ, ಖಾಣು ತೈಯಾರ್ ಛಾ಼!’ ಕರಿ, ಬುಲಾಯೊಥೋತೆ ತಮಾಮ್‌ ಅದ್ಮಿನ ಬುಲಾವಾನಟೇಕೆ ಆಳ್‌ನ ಮೋಕ್‌ಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","ಕತೋಬಿ ಇವ್ಣೆ ಖ್ಹಾರೂಸ್, ಮಾಪ್‌ ಕರ‍್ನುಕರಿ ಎಕ್ಕಸ್‌ ದಿಲ್‌ಥಿ ಬೋಲಾಲಗ್ಯು. ಪಹಿಲೆವಾಳೊ ಯೋ ಆಳ್‌ನ ದೇಖಿನ್ ಬೋಲ್ಯೋಕಿ, ‘ಮೇ ಏಕ್‌ ಖೇತರ್‌ನ ಮೋಲ್ ಲೀರಾಖ್ಯೋಸ್, ಮೇ ಜೈ಼ನ್, ಯೋ ಖೇತರ್‌ನ ದೇಖಾನು ಜ಼ರೂರತ್ ಛಾ಼; ಮನ ಮಾಪ್‌ ಕರ್‌ ಕರಿ ಬೋಲಿಲಿದೊ ಕರಿ ಬೋಲ್.’ ");
INSERT INTO vaa_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","ಬಿಜ್ಜೇಕ್‌ ಜ಼ಣಾನೆ ಬೋಲ್ಯೋಕಿ, ‘ಮೇ ಪಾಚ಼್ ಜೋ಼ಡಿ ಢಾಂಡಾವ್‍ನ ಲೀರಾಖ್ಯೋಸ್, ಇನ ದೇಖಿನ್ ಪರ್ಖಾನ ವಳ್ಯೊಜವುಸ್. ಮನ ಮಾಪ್‌ಕರ್‌ ಕರಿ ಬೋಲ್ಯೊ, ಕರಿ ಬೋಲ್.’ ");
INSERT INTO vaa_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","ಅಜೇಕ್ ಜ಼ಣಾನೆ, ‘ಹಮ್ಕೇಸ್ ಮಾರೊ ವ್ಯಹಾ ಹುಯಿರ‍್ಹೋಸ್, ಇನಖ್ಹಾಜೆ ಮನ ಆವಾನ ಕೋ ಉಶೇನಿ’ ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","ಯೋ ಆಳ್‌ ಪಾಛು಼ಫರಿನ್, ಇನ ಯಜಮಾನ್‍ಕನ ಐನ್, ಚಾ಼ಲ್ಯುತೆ ಇನಿ ಬಾರೇಮ ಬೋಲ್ಯು. ತದೆ ಯೋ ಘರ್‌ನ ಯಜಮಾನ್ನೆ ಖೀಜ಼್ ಖೈನ್, ಇನ ಆಳ್‌ನ, ‘ತೂ ಒಗ್ಗಿಸ್‌ಮ, ಆ ಗಾಮ್‌ನು ಗಲ್ಲಿಯೇಮಾಬಿ, ಓಣಿಯೇಮಾಬಿ ಜೈ಼ನ್, ಗೋರ್‌-ಗರೀಬ್‌ನ, ಪಾಂಗ್‌ಳ್ಯಾವ್ನ, ಲಂಗ್ಡಾವ್‍ನ, ಕಾಣಾವ್ನ ಖ್ಹಾರು ಹಜ್ಜಾ಼ ಬುಲೈಲ್ಯಾವ್’ ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","ಒಗ್ಗಿಸ್‌ಮ ಯೋ ಆಳ್‌ನೆ, ‘ಯಜಮಾನ್ ತಾರಿ ಹುಕುಮ್ ಚಾ಼ಲಿಗಿ, ಕತೋಬಿ ಬಿಜೂ಼ಬಿ ಝ಼ಗೊ ಛಾ಼’ ಕರಿ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","ತದೆ ಇನ ಯಜಮಾನ್ನೆ ಯೋ ಆಳ್‌ನ ಬೋಲ್ಯೋಕಿ, ‘ತೂ ಜೈ಼ನ್, ಖ್ಹಾರು ಖೇತರ್‌ನು ವಾಟ್‌ಪರ್ ಅಜು಼ ವಾಡ್‌ಗಿಯೆಕನ ಛಾ಼ತೆ ಹರೇಕ್ನ ಜು಼ಲಮ್‌ಥಿ ಮಹಿ ಬುಲೈಲ್ಯಾವ್. ಮಾರು ಘರ್ ಭರಾವಾದೆ’ ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","ಕತೋಬಿ ಮೇ ತುಮೂನ ಬೋಲುಸ್ಕಿ, ‘ಮೇ ಅಗಾಡಿ ಬುಲಾಯೊಥೋತೆ ಇವ್ಣಾಮ ಏಕ್‌ ಜ಼ಣುಬಿ ಮೇ ಕರಾಯೋತೆ ಖಾಣಾನಿ ಲಜ಼ತ್‌ನ ಛಾ಼ಕಿಬಿ ನಾ ದೇಕ್ಣು!’ ಕರಿ ಬೋಲ್ಯೊ.” ");
INSERT INTO vaa_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","ಏಕ್‌ ಹಲ್ಲ ಘಣ ಅದ್ಮಿನಿ ಭೀಡ್ ಯೇಸುನ ಕೇಡೆ ಜ಼ವ್‍ಕರಾತೆ ವಖ್ಹತ್‌ಮ, ಯೇಸುನೆ ಫರಿನ್, ಇವ್ಣುನ ಅಮ್ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","ಮಾರಕನ ಆವಾಳು ಮಾರೇಥಿ ಜಾ಼ಖ್ಹತ್, ಇನ ಆಯಬಾನ, ಬಾವಣ್‍, ಲಡ್ಕಾವ್‍ನ, ಮೋಟ ಭೈಯೆ ಭೇನೆ ಅಜು಼ ಇನ ಜಾನ್ನಬಿ ನಾ ವಹೇರ್‌ ಕರ‍್ಯೊತೊ ಯೋ ಮಾರೊ ಶಿಷ್ಯ ಹುಯಿರ‍್ಹೇವಾನ ಕೊಹುವಾನಿ. ");
INSERT INTO vaa_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","ಕೋಣ್‌ತೋಬಿ ಇನಿ ಶಿಲ್‌ಬೇನ ಪಳ್ಳಿನ್‌, ಮಾರ ಪೀಠೆ ನಾ ಆಯೂತೆ, ಯೋ ಮಾರೊ ಶಿಷ್ಯ ಹುಯಿರ‍್ಹೇವಾನ ಕೋ ಹೊಯ್ನಿ. ");
INSERT INTO vaa_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","ತುಮಾರಾಮ ಕೋಣ್‌ತೋಬಿ ಏಕ್‌ ಜ಼ಣು, ಏಕ್‌ ಊಚು಼ಗುಂಬಜ್‍ ಭಾಂದ್‌ಣು ಕರಿ ರ‍್ಹಯೂತೊ, ಇವ್ಣೆ ಪಹಿಲೆ ಬೇಶಿನ್, ಇನ ಭಂದಾವಾನ ಕೆತ್ರು ಖರ್ಚಿ ಉಶೆ ಕರಿ ಸೋಚ಼ಸ್‌. ಶನಕತೊ, ಯೋ ಕಾಮ್ ಪೂರ ಕರಾಯೆತ್ರೆ ಪೈಶಾ ಛಾ಼ಕಿ ಕೊಯ್ನಿ ಕರಿ ದೇಖಾನಟೇಕೆ. ");
INSERT INTO vaa_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","ಅಮ್ ಇಶಾಬ್ ಕರ‍್ಯುಕೊಂತೆ, ಹದಿ ನಾಖಾನ ಬಾದ್‌ಮ, ಯೋ ಕಾಮ್ ಭೀರಿಗಯೂತೊ, ");
INSERT INTO vaa_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","ದೇಖಾವಾಳು ಖ್ಹಾರು, ‘ಆ ಅದ್ಮಿ ಭಂದಾವಾನ ಶುರುಕರ‍್ಯು, ಕತೋಬಿ ಅನ ಪೂರ ಕರಾನ ಕೋಹುಯುನಿ!’ ಕರಿ ಬೋಲಿನ್, ಇನಿ ನಕ್ಲೆ ಕಾಡ್‌ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","ಏಕ್‌ ರಾಜ಼ ಬಿಜೇಕ್ ರಾಜಾ಼ನ ಜೋ಼ಡೆ ಜಂಗ್ ಭೀಡಾನ ಜಾ಼ವಾನ ಅಗಾಡಿ, ವೀಖ್ಹ್‌ ಹಜಾ಼ರ್ ದಂಡ್‌-ದಳ್‌ವಾಯಿನ ಲೀನ್, ಜಂಗ್‌ನ ವಳ್ಯಾವಾತೆ ಯೋ ರಾಜಾ಼ನ ಜೋ಼ಡೆ, ದಖ್ಹ್‌ ಹಜಾ಼ರ್ ದಂಡ್‌-ದಳ್‌ವಾಯಿನ ಲೀಜೈ಼ನ್, ಹರಾವನ ಉಶೇಕಿ ಕೊಯ್ನಿ, ಕರಿ ಪಹಿಲೇಸ್ ಬೇಶಿನ್ ಸೋಚ಼ಸ್‌. ");
INSERT INTO vaa_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","ಇಮ್‌ ಹರಾವನ ಕೋ ಉಶೇನಿ ಕರಿ ಮಾಲುಮ್ ಪಡ್ಯೂತೊ, ಯೋ ವಳ್ಯಾವಾತೆ ರಾಜ಼ ದೂರ್ ರ‍್ಹವಾನಿಸ್ ವಖ್ಹತ್‌ಮ, ಇನು ಖಬರ್ ದ್ಯವಾಳಾನ ಮೋಕ್ಲೀನ್, ಶಾಂತಿನು ಒಪ್ಪಂದ ಕರಿಲಿಯೆ, ಕರಿ ಬೋಲಿಲೇಸ್. ");
INSERT INTO vaa_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","ಇಮ್ಮಸ್, ತುಮಾರಮ ಕೋಣ್‌ಬಿ ರ‍್ಹವೊ, ಇನಛಾ಼ತೆ ಖ್ಹಾರಸ್ನ ನಾ ಮ್ಹೇಲ್ಯೂತೊ, ಯೋ ಮಾರೊ ಶಿಷ್ಯ ಹುಯಿರ‍್ಹೇವಾನ ಕೋ ಹುವಾನಿ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","ಮೀಟ್‌ ಏಕ್‌ ಅಛ್ಛು಼ ರಾಛು಼ಸ್. ಮೀಟಸ್‌ ಫಿಕ್ಕು ಹುಯಿಗುತೊ, ಇನ ಬಿಜು಼ಪಾಛು಼ ಶನೇಥಿ ರುಚ಼್‌ಲ್ಯಾವನು ಉಷೆ? ");
INSERT INTO vaa_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","ಇಮ್ನು ಮೀಟ್‌ಥಿ ಜ಼ಮೀನ್ನ ರ‍್ಹವೊ, ಖಾತ್‌ನ ರ‍್ಹವೊ ಶನೂಸ್ ಫಾಯಿದೊ ಕೊಯ್ನಿ. ಇನ ಭಾರ್‌ ಫೇಕಿದೇಸ್. ಖ್ಹಮ್‌ಜಾ಼ನ ಕಾನ್‌ರ‍್ಹವಾಳು ಖ್ಹಮ್‌ಜಾ಼ದೆ!” ಕರಿ ಬೋಲ್ಯೊ ");
INSERT INTO vaa_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","ಏಕ್‌ ದನ್ನೆ ಯೇಸು ಬೋಲಾತೆ ವಾತೇನ ಖ್ಹಮ್‌ಜಾ಼ನಖ್ಹಾಜೆ, ಘಣು ಅದ್ಮಿ ಶುಂಕ ವಶೂಲ್ ಕರಾವಾಳು ಅಜು಼ ಪಾಪಿಖ್ಹಾರು ಇನಾಕನ ಆಯು. ");
INSERT INTO vaa_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","ಅನ ದೇಖಿನ್ ಫರಿಸಾಯರ್ ಅಜು಼ ಮೋಶೇನು ಧರ್ಮಶಾಸ್ತ್ರ ಶಿಕಾಡವಾಳು ಶಾಸ್ತ್ರಿಯೇನೆ, “ಆ ಪಾಪಿ ಖ್ಹಾರಾನ ಜೋ಼ಡೆ ಮಳಿನ್, ಇವ್ಣ ಜೋ಼ಡೆ ಖಾಣು ಖಾಸ್ನಿ” ಕರಿ ಯೇಸುಪರ್ ಮಶ್ಲಾ ಮಾರ‍್ಯು. ");
INSERT INTO vaa_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","ತದೆ ಯೇಸುನೆ ಇವ್ಣುನ ಏಕ್‌ ಮತ್ಲಬ್‌ನಿ ಖೇಣಿನ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","ಯೋ ಶಾತ್‌ಕತೊ, “ತುಮಾರಾಮ ಕೋಣ್‌ತೋಬಿ ಏಕ್‌ ಜ಼ಣು, ಇನಾಕನ ಖ್ಹೋ ಮೇಂಢುರ‍್ಹೀನ್, ಇನಾಮಾನು ಏಕ್‌ ಗುಮೈಗಯೂತೆ, ಯೋ ನೌ ಉಪ್ಪರ್ ಖ್ಹಡ್‌ಚಾರೀಖ್ಹ್‌ನ ಝೂ಼ಂಡ್‌‍ಮಾಸ್ ಮ್ಹೆಂದಿನ್, ಗುಮೈಗಯೂತೆ ಯೋ ಮೇಂಢು ಮಳಾತೋಡಿ, ಇನ ಢೂಂಡಿನ್ ಜಾ಼ಯಿಕೊಯ್ನಿಕಿ ಶು? ");
INSERT INTO vaa_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","6","ಯೋ ಮಳಾನ ಬಾದ್‌ಮ, ಯೋ ಅದ್ಮಿ ಖ್ಹುಶಿ ಕರ್ತುಹುಯಿನ್, ಮೇಂಢಾನ ಇನ ಖಾಂದಪರ್ ಮ್ಹೇಲಿಲೀನ್, ಘರೆಆಯಿನ್, ಇನಖ್ಹಾರ ದೋಸ್ತ್‌ನ ಅಜು಼ ಖನ್ನೆವಾಳಾನ ಎಕ್ಟುಕರಿನ್, ‘ಗುಮೈಗಯುಥೂತೆ ಯೋ ಮೇಂಢು ಮಳ್ಯು, ಮಾರ ಜೋ಼ಡೆ ಖ್ಹುಶಿಕರೊ’ ಕರಿ ಇವ್ಣುನ ಬೋಲಾಕೊಯ್ನಿಕಿ ಶು? ");
INSERT INTO vaa_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","ಇಮ್ಮಸ್, ದೇವ್‌ಭಣಿ ಫರಾನ ಮನ್‌ಕೊಂತೆ, ನೌ ಉಪ್ಪರ್ ಖ್ಹಡ್‌ಚಾರೀಖ್ಹ್ ನೀತಿವಾಳ ಅದ್ಮಿಥೀಬಿ, ದೇವ್‌ಭಣಿ ಫರಾಸ್ತೆ ಏಕ್‌ ಪಾಪಿನಿ ಬಾರೇಮ, ಪರ್‌ಲೋಕ್‌ಮ ಘಣು ಖ್ಹುಶಿಹುವ್ವಾಸ್ ಕರಿ ಮೇ ತುಮೂನ ಬೋಲುಸ್”. ");
INSERT INTO vaa_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","ಏಕ್‌ ತಯೇಡಾಕನ ದಖ್ಹ್‌ ರೂಪಾನು ಬಿಲ್ಲು ಛಾ಼ ಕರಿ ಸೋಚೊ. ಇನಾಮಾನು ಏಕ್‌ ಬಿಲ್ಲಾನ ಯೋ ಗುಮೈಲಿದಿತೊ ಯೋ ಶಾತ್‌ ಕರ್ಶೆ? ಯೋ ತಯೇಡ ದೀವೊ ಲಗಾಡಿನ್, ಹಿಡಿ ಘರ್‌ನಾಸ್ ಝಾ಼ಡೀನ್, ಗುಮೈಗಯೂತೆ ಯೋ ಬಿಲ್ಲು ಮಳಾತೋಡಿ, ಹೊಷಾರ್‌ಥಿ ಢೂಂಡಾ ಕೊಯ್ನಿಕಿ ಶು? ");
INSERT INTO vaa_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","ಮಳಾನ ಬಾದ್‌ಮ, ಇನಿ ದೋಸ್‌ತಿಯೆ ಖ್ಹಾರಿನ ಎಕ್ಟು ಕರಿಲೀನ್, ‘ಗುಮೈಗಯೂತೆ ಯೋ ಮಾರು ಬಿಲ್ಲು ಮಳ್ಯು, ಮಾರ ಜೋ಼ಡೆ ಖ್ಹುಶಿ ಕರೊ’ ಕರಿ ಬೋಲಾಕೊಯ್ನಿಕಿ ಶು? ");
INSERT INTO vaa_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","ಅಮ್ಮಸ್, ದೇವ್ ಭಣಿ ಫರಾಸ್ತೆ ಏಕ್‌ ಪಾಪಿನಿ ಬಾರೇಮ, ದೇವ್‌ನು ದೂತರ್ ಖ್ಹಾರು ಖ್ಹುಶಿಕರಸ್” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","ಅನ ಬಾದ್‌ಮ ಯೇಸುನೆ ಅಮ್ ಬೋಲ್ಯೊ, “ಏಕ್‌ ಅದ್ಮಿನ ಬೇ ಛಿಯ್ಯಾ ಥಾ. ");
INSERT INTO vaa_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","ನ್ಹಾನೊ ಛಿಯ್ಯಾನೆ ಇನ ಬಾನ, ‘ಬಾ, ಆಸ್ತಿಮ ಮನ ಆವ್ಣುತೆ ಭಾಗ್ನ ಹಮ್ಕೇಸ್ ದೇ’ ಕರಿ ಬೋಲ್ಯೊ. ತದೆ ಬಾನೆ ಇನಿ ಆಸ್ತಿನ ಭೇ ಛಿಯ್ಯಾನ ವಾಟ ಪಾಡಿದಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","ಥೋಡ ದನ್ನ ಬಾದ್‌ಮ, ಯೋ ನ್ಹಾನ ಛಿಯ್ಯಾನೆ ಇನಥೂತೆ ಖ್ಹಾರೂಸ್ ವೇಚಿನ್, ಪೈಶಾ ಕರಿಲೀನ್, ದೂರ್‌ಲ್ಯಾ ದೇಖ್ಹ್‌ನ ಜೈ಼ನ್. ಹಿಜ್ಜಾ಼ ಇನ ಮನ್ ಆವಾತೆ ಇಮ್‌ ಜಿವ್ಣುಕರಿನ್, ಇನಿ ಶೊತ್ನ ಗುಮೈಲಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","ಅಮ್ ಯೋ ಖ್ಹಾರೂಸ್ ಬರ್ಬಾತ್ ಕರಿಲ್ಯವಾನ ಬಾದ್‌ಮ, ಯೋ ದೇಖ್ಹ್‌ಮ ಕಾಳ್ದುಕಾಳ್ ಐನ್, ಶಾತಸ್‌ಕೊಂತೆ ಇಮ್ನಿ ಹಾಲ್‌ ಹುಯಿಗೈ. ");
INSERT INTO vaa_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","ತದೆ ಯೋ ಜೈ಼ನ್, ಯೋ ದೇಖ್ಹ್‌ನ ಏಕ್‌ ಅದ್ಮಿಕನ ಕಾಮ್ಮ ಪೇಶಿಗಯೊ. ಯೋ ಅದ್ಮಿ ಇನ ಡೂಕರ್‌ ಚ಼ರಾವಾನಟೆಕೆ, ಇನ ಖೇತರ್‌ಮ ಮೋಕ್‌ಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","ಅಮ್ ರ‍್ಹಾವಾನಿ ವಖ್ಹತ್‌ಮ, ಡೂಕರ್‌ ಖಾಸ್ತೆ ಫಳಿಯೆ ಖೈನ್‌ತೋಬಿ, ಪೇಟ್ ಭರಿಲೇವ್ಣು ಕರಿ ಯೋ ಆಖ್ಹ್ ಕರ‍್ಯೊತೋಬಿ, ಕೋಣ್‌ಬಿ ಇನ ಕೋ ದಿದೂನಿ. ");
INSERT INTO vaa_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","ತದೆ ಇನ ಅಕ್ಕಲ್ ಅಯಿನ್, ‘ಮಾರ ಬಾಕನ ಕೈಯೆಕ್ಕಿ ಕೂಲಿಆಳ್‍ನ ಖೈನ್, ಬಶ್‌ಹುವಾಯೆತ್ರೆ ಖಾಣು ಛಾ಼. ಕತೋಬಿ ಮೇತೊ ಹಜ಼್ಜ ಭುಕ್ಯೊ ಮರುಕರೂಸ್!’ ");
INSERT INTO vaa_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","ಮೇ ಉಠೀನ್, ಮಾರ ಬಾಕನ ಜೈ಼ನ್, ಇನ ‘ಬಾ, ಪರ್‌ಲೋಕ್‌ನಿ ವಿರೋದ್ ಅಜು಼ ತಾರಿ ವಿರೋದ್ ಪಾಪ್ ಕರಿರಾಖ್ಯೋಸ್. ");
INSERT INTO vaa_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","ಅಜು಼ ಖ್ಹಾಮ್ಣೆ ಮೇ ತಾರೊ ಛಿಯ್ಯೊ ಹುಯಿರ‍್ಹವಾನ ಲ್ಹಾಯೇಕ್ ಕೊಯ್ನಿ, ತಾರ ಕೂಲಿಆಳ್‍ಮ ಏಕ್‌ನಿಘೋಣಿ ಮನ ದೇಕ್’ ಕರಿ ಸೋಚಿಲಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","ತದೆ ಯೋ ಉಠೀನ್, ಪಾಛು಼ ಇನ ಬಾಕನ ಗಯೊ. ಯೋ ಅಜೂ಼ಬಿ ದೂರ್ ರ‍್ಹವಾನಿಸ್ ವಖ್ಹತ್‌ಮ, ಇನೊ ಬಾ ಇನ ದೇಖಿನ್, ಗೋರ್‌ಖೈನ್, ನಾಶಿಆಯಿನ್‌, ಇನ ಬಥೈನ್ ಬುಚ್ಚಾ಼ ದಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","ಕತೋಬಿ ಛಿಯ್ಯಾನೆ ಇನ, ‘ಬಾ, ಪರ್‌ಲೋಕ್ನ ವಿರೋದ್ ಅಜು಼ ತಾರ ಖ್ಹಾಮ್ಣೆಬಿ ಪಾಪ್ ಕರಿರಾಖ್ಯೋಸ್. ಅಜು಼ ತಾರ ಖ್ಹಾಮ್ಣೆ ಮೇ ಛಿಯ್ಯೊ ಹುಯಿರ‍್ಹವಾನ ಲ್ಹಾಯೇಕ್ ಕೊಯ್ನಿ’ ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","ಕತೋಬಿ ಬಾನೆ ಇನ ಆಳ್‌ನ, ‘ಫಟ್‌ ಕರಿ ಘಣ ಅಛ಼್ಛ ಝ಼ಗ್ಗಾನ ಲಯಿನ್ ಅನ ಪೇರ‍್ಹಾವೊ. ಅನಿ ಅಂಗ್‌ಳೀಮ ಅಂಘೂಟಿ ಅಜು಼ ಗೋಡಾಮ ಖೋಖ್ಹ್‌ಡಾ ಘಾಲೊ. ");
INSERT INTO vaa_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","ಅಜು಼ ಪಲೈಹುಯೊ ಕೆಲ್ಡಾನ ಲೈನ್‌ ರ‍್ಹೇಖ್ಹೊ, ಮಿಝ಼್‌ವಾನ್ ಪಿಕೈನ್ ಖ್ಹುಶಿ ಕರಿಯೆ! ");
INSERT INTO vaa_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","ಆ ಮಾರೊ ಛಿಯ್ಯೊ ಮರಿಗಯೋಥೊ, ಪಾಛೊ಼ ಬಚಿ ಐರ‍್ಹೋಸ್; ಗುಮೈಗಯೋಥೊ ಹಮ್ಕೆ ಮಳಿರ‍್ಹೋಸ್‌’ ಕರಿ ಬೋಲ್ಯೊ. ತದೆ ಇವ್ಣೆ ಖ್ಹುಶಿ ಕರಾಲಗ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","ಯೋಸ್ ವಖ್ಹತ್‌ಮ, ಇನೊ ಮೋಟೊ ಛಿಯ್ಯೊ ಖೇತರ್‌ಮ ಥೊ. ಯೋ ಘರ್‌ನ ಖನ್ನೆ-ಖನ್ನೆ ಆವಾನಿ ವಖ್ಹತ್‌ಮ, ವಾಜು಼ ವಜಾ಼ಡಿನ್, ಖೇಲ್‌ಕೂದ್ ಕರುಕರಾತೆ ಅವಾಜ಼್‌ನ ಖ್ಹಮ್‌ಜ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","ತದೆ ಇನೆ ಆಳ್‌ಮ ಏಕ್‌ ಜ಼ಣಾನ ಇನಾಕನ ಬುಲೈನ್, ‘ಆ ಶಾತ್‌ ಚಾ಼ಲುಕರಾಸ್ತೆ’? ಕರಿ ಪುಛಾ಼ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","ತದೆ ಆಳ್‌ನೆ ಇನ, ‘ತಾರೊ ನ್ಹಾನೊ ಭೈ ಪಾಛು಼ಫರಿ ಐರ‍್ಹೋಸ್. ಯೋ ಜ಼ತನ್‌ಥಿ ಆಯೋತೆ ಇನಖ್ಹಾಜೆ, ತಾರ ಬಾನೆ, ಯೋ ಪಲ್ಯುಹುಯು ಕೆಲ್ಡಾನ ರ‍್ಹೇಖ್ಹಾಯೊ’ ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","ಅನ ಖ್ಹಮ್‌ಜಿನ್‌, ಇನ ಮೋಟ ಭೈನೆ ಇರಾದೊ ಖೈನ್, ಘರ್‌ನ ಮಹಿ ಗಯೊಕೊಯ್ನಿ; ತದೆ ಇನೊ ಬಾ ಭಾರ್‌ಆಯಿನ್, ‘ಮಹಿ ಆವ್’ ಕರಿ ಇನ ಗಿಂಗೈಲಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","ಕತೋಬಿ ಇನೆ ಇನ ಬಾನ, ‘ದೇಕ್, ಅತ್ರಾವರಖ್ಹ್ ಮೇ ಆಳ್‌ನಿಮತ್‌, ತಾರಿ ಚಾ಼ಕ್ರಿ ಕರ‍್ಯೊ, ಅಜು಼ ತಾರಿ ಏಕ್‌ ವಾತೆನಾಬಿ ಝಿಟ್ಕಾರ‍್ಯೊ ಕೊಯ್ನಿ. ಇಮ್‌ ರ‍್ಹಯೊತೋಬಿ, ಮೇ ಮಾರ ದೋಸ್ತ್‌ಖ್ಹಾರಾನ ಜೋ಼ಡೆ ಖ್ಹುಶಿ ಕರಾನ ಏಕ್‌ ಬೋಕ್‍ಡೋಬಿ ತುನೆ ದಿದೊಕೊಯ್ನಿ. ");
INSERT INTO vaa_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","ಕತೋಬಿ ಶೂಳೆಖ್ಹಾರಿನ ಭಾಂದಿಲೀನ್, ತಾರಿ ಆಸ್ತಿನ ಝ಼ಡ್‌ಪಿನ್ ಖಾದೋತೆ, ಆ ತಾರೊ ಛಿಯ್ಯೊ, ಆವ್ತಾನ, ಪಲ್ಯಹುಯ ಕೆಲ್ಡಾನ ಇನಖ್ಹಾಜೆ ರ‍್ಹೇಖ್ಹಾಯೋನಿ’ ಕರಿ ಜವಾಬ್‌ ದಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","ತದೆ ಇನ ಬಾನೆ, ‘ಛಿಯ್ಯಾ, ತೂ ಕದೇಬಿ ಮಾರ ಜೋ಼ಡೆ ಥೊ, ಅಜು಼ ಮಾರಕನ ಛಾ಼ತೆ ಖ್ಹಾರು ತಾರುಸ್‌. ");
INSERT INTO vaa_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","ತೋಬಿ ಖ್ಹುಶಿ ಕರಾನು, ಶಂತೋಖ್ಹ್‌ ಕರಾನು ಬರಾಬರಸ್‌. ಶನಕತೊ ಆ ತಾರೊ ಭೈ ಮರಿಗಯೋಥೊ ಪಾಛೊ಼ ಜಿವ್ತೊಹುಯಿನ್ ಐರ‍್ಹೋಸ್, ಗುಮೈ ಗಯೋಥೊ ಮಳಿರ‍್ಹೋಸ್‌” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","ಯೇಸುನೆ ಇನ ಶಿಷ್ಯರ್‌ನ ಬೋಲ್ಯೋಕಿ, “ಏಕ್‌ ಶೌಕಾರ್ ಅದ್ಮಿಥು. ಇನೆ, ಇನ ಧನ್‌-ದೌಲತ್‌ನ ದೇಖಿಲ್ಯವಾನಖ್ಹಾಜೆ ಏಕ್‌ ಸೇವಕ್‌ನ ನೇಮಕ್ ಕರ‍್ಯೊಥೊ. ಥೋಡ ದನ್ನ ಬಾದ್‌ಮ, ಯೋ ಶೌಕಾರ್‌ನ ಮಾಲುಮ್ ಪಡ್ಯೂಕಿ, ಯೋ ಸೇವಕ್ ಇನ ಯಜಮಾನ್ನ ಪೈಶಾಖ್ಹಾರು ಬರ್ಬಾತ್ ಕರುಕರಸ್ ಕರಿ. ");
INSERT INTO vaa_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","ತದೆ ಇನೆ ಸೇವಕ್‌ನ ಬುಲೈನ್, “ಆ ಶಾತ್‌? ಮೇ ತಾರಿ ಬಾರೇಮ ಖ್ಹಮ್‌ಜು಼ಕರೂಸ್ತೆ. ಮಾರಿ ಧನ್‌-ದೌಲತ್‌ನಿ ಬಾರೇಮಾನು ಖ್ಹಾರಿ ಇಶಾಬ್‍ನ ತೂ ಮನ ದೇ; ಅಜು಼ ಖ್ಹಾಮ್ಣೆ ತೂ ಮಾರ ಘರ್‌ನೊಸೇವಕ ಹುಯಿರ‍್ಹೇವಾನ ಕೋ ಉಶೇನಿ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","ಅಮ್ ರ‍್ಹೇವಾನಿ ವಖ್ಹತ್‌ಮ, ಯೋ ಘರ್‌ನೊ ಸೇವಕ್‌ನೆ ಇನುಯೋಸ್, “ಮಾರೊ ಯಜಮಾನ್, ಮನ ಕಾಮ್ಮಾಥು ಕಾಡಿನಾಖಿದ್ಯವಾನ ಆಯೊ. ಮೇ ಶಾತ್‌ಕರು? ಖಾಡ್ ಖೋಂದಾನಾಬಿ ಮನ ಶಕತ್‌ಕೊಯ್ನಿ; ಧರಮ್ ಮಾಂಗಾನ ಮನ ಖ್ಹರಮ್‌ ಲಾಗಸ್. ");
INSERT INTO vaa_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","ಆ ಘರ‍್ನೊ ಸೇವಕ್‌ಹುಯಿರ‍್ಹೋತೆ ಮನ ಕಾಮ್ಮಾಥು ಕಾಡಿನಾಖಿದ್ಯವಾನ ಬಾದ್ಮ ಅದ್ಮಿಖ್ಹಾರು ಮನ ಇವ್ಣ ಘರ್‌ಮ ಬುಲೈಲ್ಯವಾನಿಘೊಣಿ ಮೇ ಶಾತ್‌ಕರ‍್ನುಕರಿ ಮಾಲುಮ್‍ಪಡ್ಯು ಕರಿ ಸೋಚಿಲಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","ಅನ ಬಾದ್‌ಮ, ಇನೆ ಇನೊ ಯಜಮಾನ್ನ ಕರಜ಼್ ದೇವ್ಣುತೆ ಹರೇಕ್ನ ಇನೆ ಬುಲಾಯೊ. ಪಹಿಲೆವಾಳಾನ, ‘ತೂ ಮಾರ ಯಜಮಾನ್ನ ಕೆತ್ರು ಉಧಾರ್ ದೇವ್ಣು?’ ಕರಿ ಇನೆ ಪುಛಾ಼ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","ತದೆ ಇನೆ, ‘ಖ್ಹೊ ತಿತ್ತಿ ತೇಲ್’ ಕರಿ ಜವಾಬ್‌ ದೇತಾಖ್ಹತರ್‌, ತದೆ ಯೋ ಸೇವಕ್‌ನೆ, ‘ಆ ತಾರು ಕಾಗತ್ ಪಾಡೀನ್, ಒಗ್ಗಿಸ್ ಬೇಶಿನ್, ಅಡೈವಿಖ್ಹ್‌ ಕರಿ ಲೀಕ್’ ಕರಿ ಇನ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","ಅಜು಼ ಇನೆ ಬಿಜ್ಜೇಕ್‌ ಜ಼ಣಾನ, ‘ಮಾರ ಯಜಮಾನ್ನ, ತೂ ಕೆತ್ರು ದೇವ್ಣು?’ ಕರಿ ಇನೆ ಪುಛಾ಼ವಖ್ಹತರ್, ಇನೆ, ‘ಏಕ್‌ ಹಜಾ಼ರ್ ಪಲ್ಲೊ ಘವ್‌ಕರಿ ಬೋಲ್ಯೊ. ತದೆ ಇನೆ, ‘ಅಲ್ಲೆ, ತಾರು ಕಾಗತ್, ಅನಾಪರ್ ಆಟ್ ಖ್ಹೊ ಕರಿ ಲೀಖ್’ ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","ತದೆ ಇನ ಯಜಮಾನ್ನೆ ಅನಿ ಬಾರೇಮ ಖ್ಹಮ್‌ಜಿನ್‌, ಯೋ ಠಗಾರ‍್ಯೊ ಹುಯಿರೋತೆ ಘರ‍್ನೊಸೇವಕ್‌ನ, ‘ತುನೆ ಚಾ಼ತುರ್‌ನು ಕಾಮ್ ಕರ‍್ಯೊ’ ಕರಿ ಬೋಲಿನ್ ಖ್ಹರಾಯೊ. ಶನಕತೊ, ಆ ಜಗತ್‌ನು ಅದ್ಮಿ ಇವ್ಣಿ ಬಾರೇಮ, ಉಜಾ಼ಖ್ಹ್‌ನು ರಾಜ್ಯನ ಅದ್ಮಿಥೀಬಿ ಚಾ಼ತುರ್ ಹುಯಿರ‍್ಹೂಸ್. ");
INSERT INTO vaa_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","ಯೇಸುನೆ ಬಿಜೂ಼ಬಿ ಬೋಲ್ಯೋಕಿ, “ಮೇ ತುಮೂನ ಬೋಲುಸ್ಕಿ, ಆ ಜಗತ್‌ಮ ಠಗಾಯಿಹುಯಿ ಧನ್‌-ದೌಲತ್‌ಥಿ, ತುಮೆ ಖ್ಹಾರಾನ ದೋಸ್ತ್ ಕರಿಲೆವೊ, ಅಮ್ ಕರ‍್ಯಾತೊ, ತುಮಾರಕನ ಛಾ಼ತೆ ಖ್ಹಾರು ನಿಕ್ಳಿಗಯೂತೋಬಿ, ಹರ್‌ಹಮೇಶ ರ‍್ಹವಾನು ಘರ್‌ಮ ತುಮೂನ ಮಳೈಲಿಶೆ. ");
INSERT INTO vaa_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","ಥೋಡಾಮ ವಿಶ್ವಾಸ್‍ಥಿ ರ‍್ಹವಾಳು, ಜಾ಼ಖ್ಹತ್‌ಮಾಬಿ ವಿಶ್ವಾಸ್‍ಥಿ ರ‍್ಹೇಸ್, ಕತೋಬಿ ಥೋಡಾಮಸ್ ವಿಶ್ವಾಸ್‌ಕೊಂತೆ ಇವ್ಣೆ ಜಾ಼ಖ್ಹತ್‌ಮಾಬಿ ವಿಶ್ವಾಸ್‍ಥಿ ರ‍್ಹೇಯ್‌ಕೊಯ್ನಿ. ");
INSERT INTO vaa_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","ಅಮ್ ರ‍್ಹವಾಪರ್, ಜಗತ್‌ನೂಸ್ ಧನ್‍ ದೌಲತ್‌ನಿ ಬಾರೇಮ ತುಮೆ ವಿಶ್ವಾಸ್‌ಕೊಂತೆ ರ‍್ಹಯಾತೊ, ಖ್ಹಾಚು಼ ಧನ್‌ ದೌಲತ್‌ನ ತುಮಾರ ಹಾತ್ಮ ಕೋಣ್ ದಿಶೆ? ");
INSERT INTO vaa_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","ಬಿಜಾ಼ನಿ ಧನ್‌ ದೌಲತ್‌ನಿ ಬಾರೇಮ, ತುಮೆ ನಿಯಥ್ಥಿ ನಾ ರ‍್ಹಯಾತೊ, ತುಮಾರಿ ಧನ್‌ ದೌಲತ್‌ನ ತುಮೂನ ಕೋಣ್ ದಿಶೆ? ");
INSERT INTO vaa_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","ಕೆಹೊ ಆಳ್‍ಬಿ ಬೇ ಯಜಮಾನ್ನ ಸೇವೆ ಕರಾನ ಕೋ ಹುವಾನಿ. ಯೋ ಏಕ್‌ನ ವಹೇರ್‌ ಕರೀನ್ ಬಿಜೇಕ್‌ನ ಪ್ಯಾರ್ ವತಾಳ್‌ಶೆ. ನತರ್‌ಕಿ ಏಕ್ಕನ ನಿಯ್ಯತ್‌ಥಿ ರ‍್ಹೀನ್, ಬಿಜೇಕ್‌ನ ಫಿಕ್ಕರ್‌ಕೊಕರ್ಷೇನಿ. ಇಮ್ಮಸ್, ತುಮೆ ದೇವ್‍ನಾಬಿ ಅಜು಼ ಪೈಶಾನ ಆ ಭೇನಿ ಸೇವೆ ಏಕ್‌ದಮ್ ಕರಾನ ಕೋ ಹುವಾನಿ. ");
INSERT INTO vaa_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","ಫರಿಸಾಯರ್‌ವಾಳು ಆ ಖ್ಹಾರಿ ವಾತೇನ ಖ್ಹಮ್‌ಜಿನ್‌, ಇವ್ಣುನ ಪೈಶಾನಿ ಲಾಲಚ್‍ಥೀತೆ ಇನಖ್ಹಾಜೆ, ಯೇಸುನ ನಕ್ಲೆ ಕಾಡ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","ತದೆ ಯೇಸುನೆ ಇವ್ಣುನ, “ಅದ್ಮಿನ ಖ್ಹಾಮ್ಣೆ, ತುಮೆ ಬರೊಬರ್‌ ಕರಿ ವತಾಳಿಲೇಸ್; ಕತೋಬಿ ದೇವ್ನೆ ತುಮಾರು ದಿಲ್‌ ಕಿಮ್ನು ಕರಿ ಮಾಲುಮ್‌ ಕರಿರಾಖ್ಯೋಸ್. ಅದ್ಮಿನ ಡೋಳಾಮ ಘಣ ಮೋಟಾ ಕರಿ ಬೋಲೈಲೇಸ್ತೆ ಇವ್ಣೆ, ದೇವ್ನ ಡೋಳಾಮ ಗಲೀಜ಼್ ಹುಯಿರ‍್ಹೂಸ್. ");
INSERT INTO vaa_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","ಮೋಶೇನು ಧರ್ಮಶಾಸ್ತ್ರ ಅಜು಼ ಪ್ರವಾದಿಯೇನೆ ಲೀಖ್ಯೂತೆ ಯೋ ಖ್ಹಾರು ಬ್ಯಾಪ್ತಿಸ್ಮ ದ್ಯವಾಳೊ ಯೋಹಾನತೋಡಿಸ್. ಅನ ಬಾದ್‌ಮ, ದೇವ್ನ ರಾಜ್ಯನಿ ಸುವಾರ್ತೆ ಬೋಲಾವ್‍ಕರಾಸ್. ಅನಾಮ ತಮಾಮ್‌ ಅದ್ಮಿಖ್ಹಾರು ಜು಼ಲಮ್‌ಥಿ ಪೇಖ್ಹ್‌ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","ಆಬ್ಬಿ ಧರ್ತಿ ಮಟಿಜಾ಼ಶೆ, ಕತೋಬಿ ಧರ್ಮಶಾಸ್ತ್ರನ ಮಹಿನು ಏಕ್‌ ಟಿಪ್‌ಕ್ಯುಬಿ ಜಿನುಕು ಮಟ್‌ಶೆ ಕೊಯ್ನಿ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","ಇನಿ ಬಾವಣ್ಣ ಮ್ಹೇಲಿನ್, ಬಿಜೇಕ್‍ನ ವ್ಯಹಾ ಕರಿಲ್ಯವಾಳು ಹರೇಕ್‍ಬಿ ವ್ಯಬಿಚಾರ್ ಕರಾವಾಳು ಹುಯಿರ‍್ಹೂಸ್. ಬಾವ್ರಿ ಮ್ಹೆಂದಿದೋತೆ ತಯೇಡಾನ ವ್ಯಹಾ ಕರಿಲ್ಯವಾಳು ವ್ಯಬಿಚಾರ್ ಕರಾವಾಳು ಹುಯಿರ‍್ಹೂಸ್. ");
INSERT INTO vaa_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","ಏಕ್‌ ಜ಼ಣೊ ಶೌಕಾರ್ ಥೊ. ಯೋ ಹರ್‌ಹಮೇಶ ಘಣಾಮೋಲ್‌ನು ರಾಯಿಜಾ಼ಮಣ್ಣ ರಂಗ್ನು ರೇಖ್ಹಮ್‌ನ ಲುಂಗ್ಡಾವ್‍ನ ಪೇರ‍್ಹಿಲೀನ್‌, ದನ್‌ರೋಜ಼್‌ ಘಣಿ ಅಕ್ಲಾಶ್‌ಥಿ ಜಿವ್ಣು ಚ಼ಲಾವ್‍ಕರ್ತೊಥೊ. ");
INSERT INTO vaa_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","ಇನ ಘರ್‌ನ ದರ‍್ವಾಜ಼ಕನ, ಲಾಜ಼ರ್‌ ಕರಿ ಧರಮ್ ಮಾಂಗವಾಳೊ ಏಕ್‍ಜ಼ಣೊ ಪಡ್ಯೋಥೊ. ಅನು ಆಂಗ್‌ತನ್‌ ಅಖ್ಖುಸ್ ಫೋಡ-ಫುಂಗ್‌ಣಿಯೆ ಥು. ");
INSERT INTO vaa_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","ಯೋ ಶೌಕಾರ್ ಖೈನ್ ನಾಖಸ್ತೆ ವಿಠ್ಯು ಖಾಣುತೋಬಿ ಖೈನ್, ಭುಕ್ ಮಟೈಲೇವ್ಣು ಕರಿ ಥು. ಅತ್ರೇಸ್ ಕಾಹೆತೆ ಕುತ್‌ರ‍್ಯಾ ಜಿನ್‌ಕುಬಿ ಇನು ಫೋಡಾವ್‍ನ ಚಾ಼ಟ್‌ತೂಥು. ");
INSERT INTO vaa_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","ಅಮ್‌ರ‍್ಹವಾನಿ ವಖ್ಹತ್‌ಮ, ಥೋಡ ದನ್ನ ಬಾದ್‌ಮ, ಯೋ ಧರಮ್ ಮಾಂಗವಾಳೊ ಮರಿಗಯೊ. ತದೆ ಪರ್‌ಲೋಕ್‌ನು ದೂತರ್ ಆಯಿನ್, ಇನ ಪಳ್ಳಿ ಜೈ಼ನ್, ಅಬ್ರಹಾಮ್‌ನಿ ಛಾ಼ತಿನ ಚಿಕಾಯು. ಯೋ ಶೌಕಾರ್‌ಬಿ ಮರಿಗಯೊ, ಇನು ಮಖ್ಹಾಣ್ಯು ಕರ‍್ಯು. ");
INSERT INTO vaa_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","ಯೋ ಪಾತಾಳ್ನ ಮಹಿ ಖ್ಹತಾಪ್ಣಿ ಪಡುಕರಾನಿ ವಖ್ಹತ್‌ಮ, ಡೋಳ ಪಾಡೀನ್, ದೂರ್‌ಥೊ ಅಬ್ರಹಾಮ್‌ನಾಬಿ ಇನಿ ಛಾ಼ತಿ ಚಿಕೈರ‍್ಹೋತೆ ಲಾಜ಼ರ್‌ನಾಬಿ ದೇಖ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","ತದೆ ಇನೆ, “ಬಾ, ಅಬ್ರಹಾಮ್! ಮಾರಪರ್ ಗೋರ್‌ ಕರೀನ್, ಲಾಜ಼ರ್‌ನ ಮೋಕಲ್. ಯೋ ಇನಿ ಅಂಗ್‌ಳಿನ ಪಾಣಿಮ ಡುಬೈನ್, ಮಾರಿ ಜೀಬ್‌ನ ಠಂಡು ಕರಾದೆ, ಶನಕತೊ ಆ ಆಗ್‌ಮ ಮೇ ಘಣು ಖ್ಹತುಕರೂಸ್” ಕರಿ ಚಿಕ್ರಿನ್ ಬೋಲಿಲಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","ಕತೋಬಿ ಅಬ್ರಹಾಮ್‌ನೆ ಇನ, “ಛಿಯ್ಯಾ, ತುನೆ ಆಖ್ಹ್ ಕರ‍್ಯೊತೆ ಖ್ಹಾರೀಸ್‍ ಖ್ಹುಶಿ, ತಾರಿ ಜಿ಼ಂದ್‌ಗೀಮ ತುನ ಮಳ್ಯು. ಇಮ್ಮಸ್, ಲಾಜ಼ರ್‌ನೆ ಲತಾಡ ಪಡ್ಯೊ ಕರಿ ಬೋಲಾನು ಯಾದ್ ಕರಿಲೆ. ಕತೋಬಿ ಹಮ್ಕೆ ಹಜ಼್ಜಾ ಅನ ಸಮಾಧಾನ್ ಛಾ಼, ಕತೋಬಿ ತುನ ಖ್ಹತಾಪ್ಣಿ ಮಳಿರ‍್ಹೀಸ್. ");
INSERT INTO vaa_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","ಅತ್ರೇಸ್ ಕಾಹೆತೆ ಹಮಾರ ಅಜು಼ ತುಮಾರ ಇಚ಼್‌ಮ ಏಕ್‌ ಮೋಟಿ ಖಾಡ್ ಛಾ಼. ಇನಖ್ಹಾಜೇಸ್, ಹೈಕಡ್‌ತು ತುಮಾರ ಭಣಿ ಜಾ಼ವ್ಣುಕರಿ ಕರ‍್ಯುತೋಬಿ, ಜಾ಼ವಾನ ಕೋ ಹುವಾನಿ ಅಜು಼ ಹೀಕಡ್‌ತು ಕೋಣ್‌ಬಿ ಉಲಾಂಗಿನ್ ಹಮಾರಕನ ಆವಾನ ಕೋ ಹುವಾನಿ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","ತದೆ ಯೋ ಶೌಕಾರ್‌ನೆ, ‘ಬಾ ಅಬ್ರಹಾಮ್, ಮೇ ತುನ ಗಿಂಗಾವುಸ್, ಲಾಜ಼ರ್‌ನ ಮಾರ ಬಾನ ಘರೆ ಮೋಕಲ್ ಕರಿ ಬೋಲಿಲಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","ಮನ ಪಾಚ಼್ ಭೈಯೇ ಛಾ಼. ಇವ್ಣೆತೋಬಿ ಆ ಖ್ಹತಾಪ್ಣಿನಿ ಝ಼ಗೋಪರ್ ನಾ ಆವ್ಣುತೆ ಇಮ್‌, ಲಾಜ಼ರ್‌ ಜೈ಼ನ್, ಇವ್ಣುನ ಝೇತಾವಾದೆ’ ಕರಿ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","ಕತೋಬಿ ಅಬ್ರಹಾಮ್‌ನೆ, ‘ತಾರ ಭೈಯೇಕನ ಮೋಶೆ ಅಜು಼ ಪ್ರವಾದಿಯೇನು ಪುಸ್ತಕ ಖ್ಹಾರು ಛಾ಼, ಇವ್ಣೆ ಇನ ಖ್ಹಮ್‌ಜಾ಼ದೆ’ ಕರಿ ಬೋಲ್ಯೊ ");
INSERT INTO vaa_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","ತದೆ ಯೋ ಶೌಕಾರ್‌ನೆ, ‘ಬಾ ಅಬ್ರಹಾಮ್, ಇಮ್‌ಕಾಹೆ! ಮರ‍್ಯುಹುಯು ಕೋಣ್‌ತೋಬಿ ಏಕ್‌ ಜ಼ಣು ಪಾಛು಼ ಜಿವ್ತುಹುಯಿನ್, ಗಯೂತೊ, ಇವ್ಣೆ ದೇವ್‌ಭಣಿ ಫರ್‌ಶೆ’ ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","ಕತೋಬಿ ಅಬ್ರಹಾಮನೆ ಇನ, ‘ಇವ್ಣೆ ಮೋಶೇನು ಅಜು಼ ಪ್ರವಾದಿಯೇನೂಸ್ ವಾತೇನ ಖ್ಹಮ್‍ಜ್ಯುನಾತೊ, ಮರ‍್ಯುಹುಯು ಏಕ್‌ ಜ಼ಣು ಜಿವ್ತುಹುಯಿನ್ ಉಠಿತೋಬಿ, ಇವ್ಣೆ ಮಾನ್‌ಶೆ ಕೊಯ್ನಿ’ ಕರಿ ಬೋಲ್ಯೊ.” ");
INSERT INTO vaa_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","ಯೇಸುನೆ ಇನ ಶಿಷ್ಯರ್‌ನ ಬೋಲ್ಯೋಕಿ, “ಅದ್ಮಿನ ಪಾಪ್‌ಮ ಚ಼ಲಾವವಾಳು ರಾಛು಼ ಆವ್‌ಶೆಸ್‌ ಆವ್‌ಶೆ, ಕತೋಬಿ ಇಮ್‌ ಹುವ್ವಾನಿಘೋಣಿ ಕರಾಸ್ತೆ, ಯೋ ಅದ್ಮಿನಿ ಹಾಲ್ನ ಶಾತ್ ಬೋಲು! ");
INSERT INTO vaa_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","ಆ ನ್ಹಾನಾವ್‍ಮ ಏಕ್‌ ಜ಼ಣಾನ ಪಾಪ್‌ಮ ಚ಼ಲಾವಥೀಬಿ, ಇನ ಘಲೆಂಡ ಕೇಡೆ ಘಟ್ಟಿನ ಬಂಡಾನ ಭಂದೈಲೀನ್, ದರ‍್ಯಾವ್‌ಮ ನಖೈಲ್ಯವಾನೂಸ್ ಇನ ಅಛ್ಛು಼! ");
INSERT INTO vaa_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","ಇನಖ್ಹಾಜೇಸ್, ತುಮೆ ಕರಾತೆ ಬಾರೇಮ ಜ಼ತನ್ ರ‍್ಹವೊ! ತಾರೊ ಭೈ ಪಾಪ್ ಕರ‍್ಯೋತೊ, ಇನ ಗುರ್‌ಕಾವ್, ಏಕ್‌ ವೇಳ್ ಯೋ ಪಾಪ್ನ ಮ್ಹೇಲಿನ್ ಫರಿಗಯೋತೊ, ಇನ ಮಾಪ್‌ ಕರ್‌. ");
INSERT INTO vaa_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","ಯೋ ದನ್ನ ಖ್ಹಾತ್ ಹಲ್ಲಾಬಿ ತುನ ಗಲತ್‍ಕರೀನ್ ಖ್ಹಾತ್‍ಹಲ್ಲಾಬಿ ತಾರಭಣಿ ಫರಿನ್, ‘ಮೇ ದಿಲ್‍ ದುಖೈಲೇವುಸ್, ಮನ ಕ್ಷಮಾಕರ್’ ಕರಿ ಬೋಲಿಲಿದೋತೊ ಇನ ಮಾಪ್‌ಕರ್‌ ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","ಅಪೊಸ್ತಲರ‍್ನೆ ಪ್ರಭುನ, “ಹಮಾರಿ ವಿಶ್ವಾಸ್‌ನ ಭಡಾವ್” ಕರಿ ಬೋಲಿಲಿದ. ");
INSERT INTO vaa_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","ತದೆ ಪ್ರಭುನೆ ಇವ್ಣುನ, “ರಾಯಿಯೆವ್ಡಿ ವಿಶ್ವಾಸ್‌ ತುಮೂನ ರ‍್ಹಯುತೊ, ತುಮೆ ಆ ಅಂಜೀರ್‌ನ ಝಾ಼ಡ್‌ಣ, ‘ಜ಼ಡ್‌ ಖ್ಹಮೇದ್ ಉಖ್‌ಡೈ ಜೈ಼ನ್‌, ದರ‍್ಯಾವ್‌ಮ ಗಡಿಜಾ಼!’ ಕರಿ ಬೋಲ್ಯಾತೋಬಿ, ಯೋ ತುಮಾರಿ ವಾತೇನ ಖ್ಹಮಜ಼್‌ಶೆ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“ತುಮಾರಾಮ ಕಿನಾತೋಬಿ ನಾಗ್ರಾವಾಳೊ ನತರ್‌ಕಿ ಮೇಂಢ ಚ಼ರಾವವಾಳೊ ಆಳ್‌ ಛಾ಼ ಕರಿ ಲ್ಹಾವೊ. ಯೋ ಆಳ್‌ ಖೇತರ್‌ಮಾಥು ಘರ್‌ಕನ ಆಯೂತೊ, ತುಮೆ ಇನ, ‘ಒಗ್ಗಿಆವ್, ಖಾಣನ ಬೇಖ್ಹ್‌’ ಕರಿ ಬೋಲಸ್ಕಿ ಶು? ");
INSERT INTO vaa_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","ಕೊಯ್ನಿಸಸ್ ಕೊಯ್ನಿ! ತುಮೆ ಇನ, ‘ಮನ ಖಾಣು ತೈಯಾರ್‌ಕರ್, ಅಜು಼ ಕಂಬರ್‌ನ ಲುಂಗ್ಡು ಭಾಂದಿಲೀನ್, ಮೇ ಖೈನ್‌ಪೀಯ್ಯಾತೋಡಿ, ಮಾರಿ ಚಾ಼ಕ್ರಿಕರ್‌, ಬಾದ್‌ಮ ತೂ ಖೈನ್‌ಪೀ ಕರಿ ಬೋಲಾಕೊಯ್ನಿಕಿ ಶು? ");
INSERT INTO vaa_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","ಇನಿ ಹುಕುಮ್‌ನಿಘೋಣಿ ಚಾ಼ಲ್ಯುತೆ ಯೋ ಆಳ್‌ನ, ‘ತುನ ಧನ್ಯವಾದ್’ ಕರಿ ಬೋಲ್‌ಶೇಕಿ ಶು? ");
INSERT INTO vaa_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","ಅಮ್ಮಸ್, ತುಮೆ ತುಮೂನ ಹುಕುಮ್ ಕರ‍್ಯುತೆ ಇನ, ಪೂರ ಕರಾನ ಬಾದ್‌ಮ, ‘ಹಮೆ ಫಾಯಿದೊಕೊಂತೆ ಆಳ್‌ ಹುಯಿರ‍್ಹಾಸ್, ಹಮೆ ಖಲಿ ಹಮಾರು ಕಾಮ್ನ ಕರಿರಾಖ್ಯಾಸ್’ ಕರಿ ಬೋಲ್‌ನು” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","ಯೇಸು ಯೆರೂಸಲೇಮ್‌ ಭಣಿ ಒಳೆಜಾ಼ತೊಥೋತೆ ತದೆ, ಗಲಿಲಾಯ ಅಜು಼ ಸಮಾರ್ಯ ತಬರ್‌ಖಾನು ಇಚ಼್‌ಮಾನಿ ವಾಟೆಕರಿ ಗಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","ಏಕ್‌ ಗಾಮ್ಮ ಆವಾದಿನ್, ಹಿಜ್ಜಾ಼ ಖೋಡ್‍ ಲಾಗಿರ‍್ಹೂಥೂತೆ ದಖ್ಹ್‌ ಜ಼ಣು ಇನಖ್ಹಾಮ್ಣೆ ಆಯಿನ್, ದೂರ್ ಭೀರಿನ್‌, ");
INSERT INTO vaa_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","“ಯೇಸು, ಗುರೂ, ಹಮಾರಪರ್‌ ಗೋರ್‌ಕರ್‌!” ಕರಿ ಚಿಕ್ರಿನ್ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","ಯೇಸುನೆ ಇವ್ಣುನ ದೇಖಿನ್‌, “ತುಮೆ ಜೈ಼ನ್‌, ಯಾಜಕವ್ನ ತುಮಾರು ಆಂಗ್‌ತನ್‌ ವತಾಳೊ” ಕರಿ ಬೋಲ್ಯೊ. ಇವ್ಣೆ ಜಾ಼ವನಿ ವಖ್ಹತ್‌ಮಸ್, ಇವ್ಣೆ ಪಾಕ್‌ ಹುಯಿಗಯು. ");
INSERT INTO vaa_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","ಇವ್ಣಾಮ ಏಕ್‌ ಜ಼ಣು ಇನ ಅಛ್ಛು಼ ಹುಯೂತೆ ದೇಖಿನ್‌, ಚೋ಼ರ್ ಆವಾಜ಼್‌ಥಿ, ದೇವ್ನಿ ಖ್ಹರಾವ್ಣಿ ಕರ್ತುಹುಯಿನ್, ಪಾಛು಼ಫರಿ ಆಯು. ");
INSERT INTO vaa_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","ಯೋ ಯೇಸುನ ಗೋಡಾಪರ್ ಪಡೀನ್, ಇನ ಧನ್ಯವಾದ್ ಕರ‍್ಯು. ಯೋ ಸಮಾರ್ಯವಾಳೊ ಹುಯಿರ‍್ಹೋಥೊ. ");
INSERT INTO vaa_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","ತದೆ ಯೇಸುನೆ ಇನ, “ದಖ್ಹ್‌ ಜ಼ಣಾನ ಅಛ್ಛು಼ ಹುಯೂನಿ? ಬಿಜು಼ ನೌ ಜ಼ಣ ಕ್ಯಾ?” ಕರಿ ಪುಛಾ಼ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","ದೇವ್ನಿ ಸ್ತುತಿ ಕರಾನಖ್ಹಾಜೆ, ಆ ಪರೈ ದೇಖ್ಹ್‌ವಾಳಾನ ಮ್ಹೆಂದಿನ್, ಬಿಜು಼ ಕೋಣ್‌ಬಿ ಪಾಛು಼ಫರಿ ಆಯು ಕೊಯ್ನಿ ಶು? ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","ಅಜು಼ ಯೇಸುನೆ ಇನ, “ಉಪ್ಪರ್ ಉಠೀನ್, ಜಾ಼; ತಾರಿ ವಿಶ್ವಾಸ್‌ಥೀಸ್‌ ತುನ ಅಛ್ಛು಼ಕರ‍್ಯು” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","ಫರಿಸಾಯರ್‌ಮ ಥೋಡು ಜ಼ಣು ಯೇಸುನ, “ದೇವ್ನಿ ರಾಜ್ಯ ಕದೆ ಆವ್‌ಶೆ?” ಕರಿ ಫುಛಾ಼ಯು. ತದೆ ಇನೆ ಇವ್ಣುನ, “ದೇವ್ನಿ ರಾಜ಼್ ದೆಖಾವಾನಿಘೋಣಿ ಆವಾನು ಕಾಹೆ, ");
INSERT INTO vaa_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","ಕೋಣ್‌ಬಿ, “ಹಂದೇಖೊ ಹಜ್ಜಾ಼ ಛಾ಼” ನತರ್‌ಕಿ “ಹಂದೇಖೊ ಹಿಜ್ಜಾ಼ ಛಾ಼” ಕರಿ ಬೋಲಾನ ಕೋ ಹುವಾನಿ. ಶನಕತೊ ದೇವ್ನಿ ರಾಜ್ಯ ತುಮಾರ ಮಹಿಸ್ ಛಾ಼” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","ಅಜು಼ ಯೇಸುನೆ ಇನ ಶಿಷ್ಯರ್‌ನ, “ಏಕ್‌ ವಖ್ಹತ್ ಆವ್‌ಶೆ, ತದೆ ತುಮೆ, ಅದ್ಮಿನೊ ಛಿಯ್ಯಾನ ದನ್ಮ ಏಕ್‌ ದನ್‌ತೋಬಿ ದೇಕ್ಣು ಕರಿ ಆಖ್ಹ್ ಕರ‍್ಯಾತೋಬಿ, ತುಮೆ ಇನ ದೇಕ್‌ಶು ಕೊಯ್ನಿ. ");
INSERT INTO vaa_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","ಅದ್ಮಿಖ್ಹಾರು ತುಮೂನ, ‘ಹಂದೇಖೊ, ಹಜ್ಜಾ಼ ಛಾ಼!’ ನತರ್‌ಕಿ, ‘ಹಂದೇಖೊ, ಹಿಜ್ಜಾ಼ ಛಾ಼’ ಕರಿ ಬೋಲ್‌ಶೆ. ಕತೋಬಿ ತುಮೆ ಇವ್ಣ ಪೀಠೆ ನಕೊಜಾ಼ಶು. ");
INSERT INTO vaa_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","ಶನಕತೊ, ವಿಜ಼್‌ಳಿ ಖಡ್ಕಿನ್‌, ಆಬ್‍ಮ ಏಕ್‌ ಬಾಜು಼ಥು ಬಿಜ್ಜೇಕ್‌ ಬಾಜು಼ತೋಡಿ ಚ಼ಮ್‌ಕಾಸ್ತೆ ಇಮ್ಮಸ್, ಅದ್ಮಿನೊ ಛಿಯ್ಯೊ ಇನ ದನ್ಮ ರ‍್ಹಿಶೆ. ");
INSERT INTO vaa_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","ಕತೋಬಿ ಅನೇಥಿಬಿ ಅಗಾಡಿ, ಅದ್ಮಿನೊ ಛಿಯ್ಯೊ, ಘಣಿ ಖ್ಹತಾಪ್ಣಿ ಖೈನ್, ಆ ಹಗಾಮ್ನ ಅದ್ಮಿಥಿ ಝಿಟ್ಕಾರವ್ಣು. ");
INSERT INTO vaa_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","ನೋಹಾನ ದನ್ಮ ಚಾ಼ಲ್ಯುತೆ ಇಮ್ಮಸ್, ಅದ್ಮಿನೊ ಛಿಯ್ಯಾನ ದನ್‌ಮಾಬಿ ಚಾ಼ಲ್‌ಷೆ. ");
INSERT INTO vaa_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","ತಮಾಮ್‌ ಅದ್ಮಿ, ಖಾತು-ಪೀತು ಹುಯಿನ್, ವ್ಯಹಾ ಕರಿದೇತುಹುಯಿನ್‌, ವ್ಯಹಾ ಕರಿಲೇತುಹುಯಿನ್‌ ಥು. ನೋಹಾನೆ ಜ಼ಹಾಜ಼್‌ನ ಮಹಿ ಚ಼ಢ್ಯೋತೆ ದನ್‌ಮಾಬಿ ಇವ್ಣೆ ಇಮ್ಮಸ್ ಕರುಕರ್ತುಥು. ತದೆ ತೋಫಾನ್‌ ಆಯಿನ್, ತಮಾಮ್‌ ಅದ್ಮಿನ ಬರ್ಬಾತ್ ಕರಿನಾಖ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","ಲೋಟನ ದನ್ಮ ಚಾ಼ಲ್ಯುತೆ ಇಮ್ಮಸ್ ಚಾ಼ಲ್‌ಷೆ. ಅದ್ಮಿಖ್ಹಾರು ಖಾತು-ಪೀತುಹುಯಿನ್‌, ಮೋಲ್ ಲೇತುಹುಯಿನ್‌, ವೇಚ಼್‌ತುಹುಯಿನ್‌, ಖೆತರ್‌ಮ ಗಾಡ್‌ತುಹುಯಿನ್‌, ಘರ್ ಭಾಂದ್‌ತುಹುಯಿನ್‌ ಥೂ. ");
INSERT INTO vaa_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","ಕತೋಬಿ ಲೋಟ ಸೊದೋಮ್ ಗಾಮ್‌ನ ಮ್ಹೆಂದಿನ್ ನೀಕ್‌ಳ್ಯೋತೆ ತದೆ, ಆಬ್‍ಪರ್‌ಥು, ಆಗ್‌ನೊ ಅಜು಼ ರಂಜ಼ಕ್‌ನೊ ಪಾಣಿ ವರ್ಶಿನ್‌ ಇವ್ಣ ಖ್ಹಾರಾವ್‌ನ ಬರ್ಬಾತ್ ಕರಿನಾಖ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","ಅದ್ಮಿನೊ ಛಿಯ್ಯೊ ದೆಖಾವ್‌ಶೇತೆ ದನ್‌ಮಾಬಿ ಅಮ್ಮಸ್ ರ‍್ಹಿಶೆ. ");
INSERT INTO vaa_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","ಯೋ ದನ್ಮ, ಇನ ಘರ್‌ನ ಛ಼ತ್‍ಪರ್‌ ರ‍್ಹವಾಳು, ಇನು ರಾಛು಼ ಪಾಡಾನಟೆಕೆ ಹೇಟ್ ಉತ್ರಿನ್, ಘರ್‌ಮ ನಾ ಆವ್ಣು. ಇಮ್ಮಸ್, ಖೇತರ್‌ಮ ರ‍್ಹವಾಳುಬಿ ಪಾಛು಼ಫರಿ ಇನ ಘರೆ ನಾ ಜಾ಼ವ್ಣು. ");
INSERT INTO vaa_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","ಲೋಟನಿ ಬಾವಣ್ಣ ಯಾದ್ ಕರಿಲೆವೊ! ");
INSERT INTO vaa_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","ಕೋಣ್ ಇನೊ ಜಾನ್‌ ಬಚಾ಼ಡಿಲೇವ್ಣುಕರಿ ಕರಾಸ್ಕಿ ಯೋ ಇನ ಗುಮೈಲಿಶೆ; ಕತೋಬಿ ಕೋಣ್ ಇನೊ ಜಾನ್‌ ಗುಮೈಲೇಸ್ಕಿ ಯೋ ಇನ ಬಚಾ಼ಡಿಲಿಶೆ. ");
INSERT INTO vaa_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","ಮೇ ತುಮೂನ ಬೋಲುಸ್ಕಿ, ಯೋ ರಾತ್ಮ ಎಕ್ಕಸ್ ಖಟಿಯಾಪರ್‌ ಬೇ ಜ಼ಣು ಖ್ಹುತುರ‍್ಹೀಶೆ, ಏಕ್‌ಜ಼ಣಾನ ಪಳ್ಳಿಶೆ, ಏಕ್‌ನ ಮ್ಹೆಂದಿಶೆ. ");
INSERT INTO vaa_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","ಬೇ ತಯೇಡ ಎಕ್ಕಸ್ ಘಟ್ಟಿಪರ್‌ ದಳುಕರ್‌ಶೆ, ಏಕ್‌ನ ಪಳ್ಳಿಶೆ, ಏಕ್‌ನ ಮ್ಹೆಂದಿಶೆ ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","ಖೇತರ್‌ಮ ರ‍್ಹವಾಳ ಬೇಜ಼ಣಾಮ ಏಕ್‍ಜ಼ಣೊ ಪಡೈಚ಼ಲ್ಯೊಜಾ಼ಶೆ ಬಿಜೇಕ್‍ಜ಼ಣೊ ಹಿಜ್ಜಾ಼ಸ್ ಮ್ಹೇಲೈಜಾ಼ಶೆ ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","ತದೆ ಶಿಷ್ಯರ್‌ನೆ, “ಪ್ರಭು, ಆ ಕಿಜ್ಗಾ಼ ಉಶೆ?” ಕರಿ ಫುಛಾ಼ವಖ್ಹತರ್‌, ಯೇಸುನೆ ಇವ್ಣುನ, “ಮುರ್ದು ಕಿಜ್ಜಾ಼ಕಿ, ಹಿಜ್ಜಾ಼ಸ್ ಗರದ್‍ಖ್ಹಾರು ಎಕ್ಟುಹುವಾಸ್” ಕರಿ ಜವಾಬ್‌ ದಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","ತದೆ ಯೇಸುನೆ ಖಟು ನಾ ಖಾಣುತೆ, ಹಮೇಶ ಪ್ರಾರ್ಥನೆ ಕರ್ತುರ‍್ಹೇವ್ಣು ಕರಿ ವತಾಳಾನಟೇಕೆ, ಇನ ಶಿಷ್ಯರ್‌ನ ಏಕ್‌ ಮತ್ಲಬ್‌ನಿ ಖೇಣಿನ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","ಯೋ ಶಾತ್‌ಕತೊ, “ಏಕ್‌ ಗಾಮ್ಮ ಏಕ್‌ ನಯ್ಯೊ ಥೊ. ಯೋ ದೇವ್‍ನಾಬಿ ದೇಖಿನ್ ಡರ್‌ತೋಥೊ ಕೊಯ್ನಿ, ಅಜು಼ ಅದ್ಮಿನ ಮಜೂ಼ರ್‌ ಕರ್ತೊಥೊ ಕೊಯ್ನಿ. ");
INSERT INTO vaa_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","ಯೋಸ್ ಗಾಮ್ಮ ಏಕ್‌ ಮುಂಡಚ್ಚಿ ತಯೇಡ ಥೀ. ಯೋ ಘಡಿಕೇಡೆ ಇನಾಕನ ಐನ್, ‘ಮಾರೊ ನ್ಯಾವ್‍ಫೇಡೈನ್, ಮಾರ ದುಶ್‌ಮನ್‌ಥಿ ಮನ ಬಚಾ಼ಡ್‍’ ಕರಿ ಬೋಲ್‍ತಿರ‍್ಹೇತೀಥಿ. ");
INSERT INTO vaa_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","ಥೋಡ ದನ್ ಇನೆ ಧ್ಯಾನ್ ಕೋ ದಿದೋನಿ. ಕತೋಬಿ ಬಾದ್‌ಮ ಇನು ಯೋಸ್, ‘ಮೇ ದೇವ್‍ನಾಬಿ ದೇಖಿನ್‌ ಡರಾವಾಳೊ ಕಾಹೆ, ಅದ್ಮಿನಾಬಿ ಮಜೂ಼ರ್‌ ಕರಾವಾಳೊ ಕಾಹೆ, ");
INSERT INTO vaa_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","ತೋಬಿ ಆ ಮುಂಡಚ್ಚಿ ತಯೇಡ ಘಡಿಕೇಡೆ ಆಯಿನ್, ಮನ ಬೋಲ್‍ತಿರ‍್ಹೇಸ್ತೆ ಇನಖ್ಹಾಜೆ, ಮೇ ಅನಿ ನ್ಯಾವ್ ಫೇಡೈನಾಖುಸ್. ನತರ್‌ಕಿ ಆ ಘಡಿಕೇಡೆ ಆಯಿನ್ ಮನ ಖ್ಹತಾವ್‌ಶೆ!’ ಕರಿ ಬೋಲಿಲಿದೊ.” ");
INSERT INTO vaa_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","ಅಜು಼ ಪ್ರಭುನೆ, “ಯೋ ಠಗಾರು ನೈಯಾನೆ ಬೋಲ್ಯೋತೆ ಇನ ಖ್ಹಮ್‌ಜೊ಼. ");
INSERT INTO vaa_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","ದೇವ್ನೆ ಚೂ಼ಣ್ಯೋತೆ ಅದ್ಮಿ ರಾತ್-ದನ್ ಇನ ಮದತ್‌ಖ್ಹಾಜೆ ಬಿಂತಿಕರ‍್ಯೊತೊ, ಯೋ ಇವ್ಣಿ ಬಾರೇಮ ದೇರ್‌ಕರ‍್ಯುತೋಬಿ ಇವ್ಣಿ ನ್ಯಾವ್‌ನ ಫೇಡವಸ್‍ಕೊಂತೆ ರ‍್ಹಿಶೇಕಿ ಶು? ಯೋ ಇವ್ಣಿ ಮದತ್ ಕರಾನ ವೇರಸ್‌ ಕರ್ಶೆ ಕೊಯ್ನಿ. ");
INSERT INTO vaa_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","ಮೇ ತುಮೂನ ಬೋಲುಸ್ಕಿ, ಯೋ ಒಗ್ಗಿಸ್‌ಮ ಇನ ಅದ್ಮಿ ಖ್ಹಾರಾನು ನ್ಯಾವ್‌ ಫೇಡ್‌ಶೆ. ಅಮ್ ರ‍್ಹಯುತೋಬಿ, ಅದ್ಮಿನೊ ಛಿಯ್ಯೊ ಆವ್‌ಶೇತೆ ತದೆ, ಜ಼ಮೀನ್‌ಪರ್ ವಿಶ್ವಾಸ್‌ನ ದೇಕ್‌ಶೇಕಿ ಶು?” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","ಅತ್ರೇಸ್ ಕಾಹೆತೆ, ಹಮೇಸ್ ನೀತಿವಾಳ ಕರಿ ಭರೋಖ್ಹೊ ಕರೀನ್, ಬಿಜ಼ ಖ್ಹಾರಾನ ಕಡ್‌ತೇಲ್‌ನಿಮತ್ ದೇಖಾತೆ ಇವ್ಣುನಾಬಿ, ಯೇಸುನೆ ಏಕ್‌ ಮತ್ಲಬ್‌ನಿ ಖೇಣಿನ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","ಏಕ್‌ ಹಲ್ಲ ಬೇ ಜ಼ಣ ಪ್ರಾರ್ಥನೆ ಕರ‍್ನು ಕರಿ ಮಂದಿರ್‌ನ ಗಯ, ಏಕ್‌ ಜ಼ಣೊ ಫರಿಸಾಯರ್‌ವಾಳೊ ಅಜು಼ ಬಿಜೇಕ್ ಜ಼ಣೊ ಶುಂಕ ವಶೂಲ್ ಕರಾವಾಳೊ. ");
INSERT INTO vaa_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","ಫರಿಸಾಯರ್‌ವಾಳೊ ಭೀರಿನ್, ಪ್ರಾರ್ಥನೆ ಕರಾನಿ ವಖ್ಹತ್‌ಮ, ‘ಓ ದೇವ್, ಲೂಟಿ ಕರಾವಾಳು, ಠಗಾವವಾಳು, ವ್ಯಬಿಚಾರ್‌ ಕರಾವಾಳು ಅಲಕ್ ಅದ್ಮಿವೊನಿಘೋಣಿ ಮೇ ಕಾಹೆ. ಆ ಶುಂಕ ವಶೂಲ್ ಕರಾವಾಳಾನಿ ಘೋಣಿಬಿ ಮೇ ಕಾಹೆತೆ, ಇನಖ್ಹಾಜೆ ತುನ ಧನ್ಯವಾದ್ ಕರುಸ್. ");
INSERT INTO vaa_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","ವಾರಾನ ಬೇಹಲ್ಲ ಉಪವಾಸ್ ರ‍್ಹವುಸ್, ಅಜು಼ ಮೇ ಕಮಾವ್‌ಸ್ತೆ ಖ್ಹಾರಾಸ್‌ಮಾಬಿ ದಖ್ಹ್‌ಮ ಏಕ್‌ ಭಾಗ್‌ ದೆವುಸ್’ ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","ಕತೋಬಿ, ಯೋ ಶುಂಕ ವಶೂಲ್ ಕರಾವಾಳೊ ದೂರ್ ಭೀರಿನ್, ಆಬ್‍ಭಣಿ ಡೋಳಪಾಡಿ ದೇಖಾನಾಬಿ ಮನ್‌ಕೊಂತೆ, ಛಾ಼ತಿ ಕೂಟ್‌ತೊ ಹುಯಿನ್, ‘ದೇವ್, ಪಾಪಿ ಹುಯಿರ‍್ಹೋತೆ ಮಾರಪರ್ ಗೋರ್‌ ಕರ್‌’ ಕರಿ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","ಮೇ ತುಮೂನ ಬೋಲುಸ್ಕಿ, ಆ ಶುಂಕ ವಶೂಲ್ ಕರಾವಾಳುಸ್ ದೇವ್ನ ಡೋಳಾಮ ಬರೊಬರ್‌ ಕರಿ ಬೋಲೈಲಿನ್, ಘರೆ ಗಯೊ. ಕತೋಬಿ ಯೋ ಪರಿಸಾಯವಾಳೊ ಇಮ್‌ ಕೊಗಯೋನಿ. ಇನುಯೋಸ್ ಮೋಟೊಕರಿ ಬೋಲೈಲ್ಯವಾಳೊ ಹರೇಕ್‌ಜ಼ಣೊ ಹೇಟು ಹುಯಿಜಾ಼ಶೆ, ಇನುಯೋಸ್ ಹೇಟುಕರಿ ಬೋಲೈಲ್ಯವಾಳೊ ಯೋ ಮೋಟೊ ಹುಯಿಜಾ಼ಶೆ ಕರಿಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","ಥೋಡು ಅದ್ಮಿ ಇವ್ಣ ಅಡ್ಡಾಣಿ ಲಾಡ್ಕಾವ್‍ಪರ್‌ ಯೇಸುನೊ ಹಾತ್ ಮ್ಹೆಲಾವ್ಣು ಕರಿ ಇನಾಕನ ಲಾಯು. ಕತೋಬಿ ಅನ ದೇಖಿನ್‌ ಶಿಷ್ಯರ್‌ಖ್ಹಾರು ಇವ್ಣುನ ಗುರ್‌ಕಾಯು. ");
INSERT INTO vaa_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","ಕತೋಬಿ ಯೇಸುನೆ ಲಡ್ಕಾವ್‍ನ ಇನ ಖನ್ನೆ ಬುಲೈನ್, “ಅಡ್ಡಾಣಿ ಲಡ್ಕಾವ್‍ನ ಮಾರಕನ ಆವಾನ ಮ್ಹೇಲೊ, ಇವ್ಣುನ ಭಿರಾಕೊ ನಕೊ, ಶನಕತೊ ದೇವ್‌ನು ರಾಜ್ಯ ಅಮ್‌ನಾಸ್‌ವಾಳಾನು. ");
INSERT INTO vaa_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","ತುಮೂನ ಖ್ಹಾಚಮಾಬಿ ಬೋಲುಸ್ಕಿ, ಕೋಣ್ ಅಡ್ಡಾಣಿ ಲಡ್ಕಾನಿ ಘೋಣಿ ದೇವ್ನಿ ರಾಜ್ಯನ ನಾ ಮಾನ್ಯೂತೊ, ಇವ್ಣೆ ಇನಮಹಿ ಕೋಸ್‌ಜಾ಼ಶೇನಿ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","ಯೆಹೂದ್ಯರ್‌ನೊ ಏಕ್‌ ಅದಿಕಾರಿ ಯೇಸುನ, “ಅಛ್ಛೊ಼ ಗುರು, ಹಮೇಶಾನಿ ಜಿ಼ಂದ್‌ಗಿ ಮನ ಮಳ್‌ಣುಕತೊ, ಮೇ ಶಾತ್‌ ಕರ‍್ನು? ಕರಿ ಪುಛಾ಼ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","ತದೆ ಯೇಸುನೆ ಇನ, “ಮನ ಅಛ್ಛೊ಼ ಕರಿ ಶನ ಬೋಲಾಸ್ತೆ? ದೇವ್ ಎಕ್ಕಸ್ ಜ಼ಣೊ ಅಛ್ಛೊ಼ ಪಣ್ಕಿ ಬಿಜು಼ ಕೋಣ್‌ಬಿ ಅಛ್ಛು಼ ಕಾಹೆ. ");
INSERT INTO vaa_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","ವ್ಯಬಿಚಾರ್ ನಾ ಕರ‍್ನು, ಖೂನಿ ನಾಹೋಣು, ಚೋ಼ರಿ ನಾ ಕರ‍್ನು, ಝೂ಼ಟಿ ಇಂಜಾ಼ಮ್ ನಾ ಲಗಾಡ್‌ಣು, ತಾರ ಆಯ ಬಾನ ಮರ್ಯಾದಿ ದೇವ್ಣು ಕರಿ ಛಾ಼ತೆ ದೇವ್ನಿ ಹುಕುಮ್‌ ಖ್ಹಾರಿ ತುನ ಮಾಲುಮ್‌ ಛಾ಼ನಿ.” ಕರಿ ಬೋಲ್ಯೊ ");
INSERT INTO vaa_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","ತದೆ ಯೋ ಅದ್ಮಿ, “ಮೇ ಅಡ್ಡಾಣಿಪರ್‌ಥೋಸ್‌ ಆ ಖ್ಹಾರು ಪಾಡಿ ಚಾ಼ಲ್ತೊ ಐರ‍್ಹೋಸ್” ಕರಿ ಫರೈನ್ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","ಅನ ಖ್ಹಮ್‌ಜಿನ್‌, ಯೇಸುನೆ ಇನ, “ತೂ ಕರ್ನುತೆ ಬಿಜ್ಜೇಕ್‌ ಕಾಮ್ ಛಾ಼, ತಾರಕನ ಛಾ಼ತೆ ಖ್ಹಾರುಸ್‌ ಶೊತ್ನ ವೇಚಿನ್, ಆವಸ್ತೆ ಪೈಶಾನ ಗರೀಬ್‌ನ ದೆ. ತದೆ ಪರ್‌ಲೋಕ್‌ಮ ತುನ ಶೊತ್ ರ‍್ಹಿಶೆ; ಅಜು಼ ತೂ ಆಯಿನ್, ಮಾರ ಪೀಠೆ ಆವ್” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","ಕತೋಬಿ ಯೋಅದ್ಮಿ ಘಣು ದನ್-ದೌಲತ್‌ವಾಳೊ ಹುಯಿರ‍್ಹೊಥೋತೆ ಇನಖ್ಹಾಜೆ, ಆ ವಾತೆನ ಖ್ಹಮ್‌ಜೀನ್‌, ಘಣು ದುಖ್‌ ಖಾದೊ. ");
INSERT INTO vaa_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","ತದೆ ಯೇಸುನೆ ಇನ ದೇಖಿನ್‌, ಧನ್‌ದೌಲತ್‌ವಾಳು ಅದ್ಮಿ ದೇವ್ನಿ ರಾಜ್ಯಮ ಜಾ಼ವಾನು ಕೆತ್ರೆಕ್ಕಿ ಮುಶ್ಕಿಲ್! ");
INSERT INTO vaa_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","ಶೌಕಾರ್ ಅದ್ಮಿ ದೇವ್ನಿ ರಾಜ್ಯಮ ಜಾ಼ವಾಥೀಬಿ, ಊಟ್‍ ಖ್ಹುಯಿನ ಡೋಳವಾಟೆ ಪೇಶಿಜಾ಼ವನು ಶುಲ್ಬ!” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","ಯೇಸುನಿ ಆ ವಾತೆನ ಖ್ಹಮ್‌ಜ್ಯೂತೆ ಇವ್ಣೆ, “ಅಮ್ ರ‍್ಹಯುತೊ, ಕಿನ ರಕ್ಷಣೆ ಮಳ್‌ಶೆ” ಕರಿ ಪುಛಾ಼ಯು. ");
INSERT INTO vaa_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","ಯೇಸುನೆ ಇವ್ಣುನ, “ಅದ್ಮಿನ ಹಾತೆ ಹುವ್ವಾಕೊಂತೆ ಕಾಮ್ ದೇವ್ನ ಹಾತೆ ಹುವ್ವಾಸ್‌” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","ತದೆ ಪೇತ್ರನೆ ಯೇಸುನ, “ಹಂದೇಕ್‌! ಹಮೆ ಹಮಾರು ಘರ್‌ಖ್ಹಾರು ಮ್ಹೆಂದಿನ್, ತಾರ ಪೀಠೆ ಐರ‍್ಹಾಸ್‍ನಿ!” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","ಅನ ಖ್ಹಮ್‌ಜಿನ್‌ ಯೇಸುನೆ ಇವ್ಣುನ, “ತುಮೂನ ಖ್ಹಾಚ ಬೋಲುಸ್ಕಿ, ಕೋಣ್ ದೇವ್ನಿ ರಾಜ್ಯನಖ್ಹಾಜೆ, ಘರ್‌ನ ರ‍್ಹವೊ, ಬಾವಣ್ಣ ರ‍್ಹವೊ, ಭೈಯೇನ ರ‍್ಹವೊ, ಆಯ-ಬಾನ ರ‍್ಹವೊ, ಲಡ್ಕಾನ ರ‍್ಹವೊ ಮ್ಹೆಂದಿದ ಉಶೇತೊ, ");
INSERT INTO vaa_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ಇನ ಆ ಜ಼ಗ್‌ಮಾಸ್ ಇನೇಥಿಬಿ ಜಾ಼ಖ್ಹತ್ ಮಳ್‌ಶೆ, ಅಜು಼ ಉಳ್ಯಾವತೆ ಜಂಗ್‌ಮ ಹರ್‌ಹಮೇಶ ರ‍್ಹವಾಳಿ ಜಿ಼ಂದ್‌ಗಿ ಮಳ್‌ಶೆ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","ಯೇಸುನೆ ಇನ ಭಾರ ಜ಼ಣ ಶಿಷ್ಯರ್‌ನ ಎಕಾಡಿ ಬುಲೈಲಿನ್, “ಖ್ಹಮ್‌ಜೊ಼! ಅಪ್ಣೆ ಯೆರೂಸಲೇಮ್‌ನ ವಳ್ಯಾಜಯ್ಯೇಸ್‌, ಅದ್ಮಿನೊ ಛಿಯ್ಯಾನಿ ಬಾರೇಮ ಪ್ರವಾದಿಯೇನೆ ಲೀಖಿರಾಖ್ಯುತೆ ಇಮ್ಮಸ್, ಹಿಜ್ಜಾ಼ ಚಾ಼ಲ್‌ಷೆ. ");
INSERT INTO vaa_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","ಇನ ಪರೈ ಜಾ಼ತ್‌ವಾಳಾನ ಹಾತ್‌ಮ ದಿನಾಕ್‌ಶೆ, ಇವ್ಣೆ ಇನ ಚಿಂಘಾವ್‌ಶೆ, ಇನಿ ಖ್ಹರಮ್‌ ಕಾಡ್‌ಶೆ, ಅಜು಼ ಇನಾಪರ್‌ ಥೂಕ್‌ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","ಇವ್ಣೆ ಇನ ಕೊಳ್ಡೇಥಿ ಮಾರ್‌ಶೆ ಅಜು಼ ಮಾರಿನಾಕ್‌ಶೆ, ಕತೋಬಿ ತೀನ್ನೊ ದನ್ಮ ಯೋ ಪಾಛೊ಼ ಜಿವ್ತೊಹುಯಿನ್ ಉಠಿ ಆವ್‌ಶೆ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","ಕತೋಬಿ ಅನಾಮ ಏಕ್‌ ವಾತೇನಾಬಿ ಶಿಷ್ಯರ್‌ ಪರ್‌ಖ್ಯುಕೊಯ್ನಿ; ಶನಕತೊ ಆ ವಾತೆನಿ ಮತ್ಲಬ್‌ನ ಇವ್ಣೇಥಿ ಲಪೈರ‍್ಹೂಥು, ಅಜು಼ ಯೇಸು ಶನಿ ಬಾರೇಮ ಬೋಲುಕರಾಸ್‌ ಕರಿ ಇವ್ಣುನ ಮಾಲುಮ್‌ಪಡ್ಯು ಕೊಯ್ನಿ. ");
INSERT INTO vaa_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","ಯೇಸು ಯೆರಿಕೋನ ಖನ್ನೆ ಆವ್‍ಕರಾನಿ ವಖ್ಹತ್‌ಮ, ಹಿಜ್ಗಾ಼ ಮಾರಗ್‌ನ ಶೇಡೆ ಬೇಶಿನ್, ಏಕ್‌ ಕಾಣು ಧರಮ್ ಮಾಂಗುಕರ್ತುಥು. ");
INSERT INTO vaa_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","ಅದ್ಮಿನಿ ಭೀಡ್ ವಳಿಜಾ಼ತಿಥೀತೆ ಖ್ಹಮ್‌ಜಿನ್‌, ಇನೆ, “ಆ ಶಾತ್‌ ಚಾ಼ಲುಕರಾಸ್ತೆ?” ಕರಿ ಪುಛಾ಼ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","ಇವ್ಣೆ ಇನ, “ನಜ಼ರೇತ್‌ನೊ ಯೇಸು, ಆ ವಾಟೆ ಕರಿ ವಳೇಜಾ಼ಸ್” ಕರಿ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","ತದೆ ಯೋ ಕಾಣು ಜೋ಼ರೆಥಿ ಚಿಕ್ರಿನ್, “ಯೇಸು! ದಾವೀದ್‌ನ ಛಿಯ್ಯಾ! ಮಾರಪರ್ ಗೋರ್‌ಕರ್‌” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","ಖ್ಹಾಮ್ಣೆ ವಳ್ಯುಜಾ಼ತುಥೂತೆ ಅದ್ಮಿ ಇನ, “ಖ್ಹೊಪ್‌ ರ‍್ಹೆ” ಕರಿ ಬೋಲಿನ್ ಗುರ್‌ಕಾಯು. ಕತೋಬಿ ಯೋ ಬಿಜೂ಼ಬಿ ಜೋ಼ರೇಥಿ ಚಿಕ್ರಿನ್, “ದಾವೀದ್‌ನ ಛಿಯ್ಯಾ! ಮಾರಪರ್ ಗೋರ್‌ ಕರ್‌” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","ತದೆ ಯೇಸುನೆ ಭೀರಿನ್, ಯೋ ಕಾಣಾನ ಇನಾಕನ ಬುಲಾವೊ ಕರಿ ಹುಕುಮ್‌ ದಿದೊ. ಯೋ ಕಾಣು ಖನ್ನೆ ಆವಾದಿನ್, ಯೇಸುನೆ ಇನ, ");
INSERT INTO vaa_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“ಮೇ ತುನ ಶಾತ್‌ ಕರ‍್ನು ಕರಿ ತಾರಿ ಆಖ್ಹ್?” ಕರಿ ಪುಛಾ಼ಯೊ. ತದೆ ಇನೆ, “ಮನ ಪಾಛು಼ ದೆಖಾವಾನಿ ಘೋಣಿ ಕರ್ಲಾ ಪ್ರಭು” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","ಯೇಸುನೆ ಇನ, “ತುನ ದೆಖಾವಾದೆ, ತಾರಿ ವಿಶ್ವಾಸ್‌ಥೀಸ್‌ ತುನ ಅಛ್ಛು಼ಹುಯು” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","ತದ್‌ನು-ತದ್ದೇಸ್ ಇನ ದೆಖಾಯು. ಯೋ ದೇವ್ನಿ ಸ್ತುತಿ ಕರ್ತೊಹುಯಿನ್, ಯೇಸುನ ಪೀಠೆ ಗಯೊ. ಅದ್ಮಿಖ್ಹಾರು ಚಾ಼ಲ್ಯುತೆ ಇನ ದೇಖಿನ್, ದೇವ್ನಿ ಸ್ತುತಿಕರ‍್ಯು. ");
INSERT INTO vaa_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","ಯೇಸು ಯೆರಿಕೋ ವಾಟೆಕರಿ ಒಳೆಜಾ಼ತೊಥೊ. ");
INSERT INTO vaa_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","ಹಿಜ್ಜಾ಼ ಶುಂಕ ಮಾಂಗವಾಳನೊ ಮೋಟೊ ಹುಯಿರ‍್ಹೊಥೋತೆ ಜಕ್ಕಾಯ ಕರಿ ಏಕ್‍ಜ಼ಣೊ ಥೊ. ಯೋ ಧನ್‌-ದೌಲತ್‌ವಾಳೊ ಹುಯಿರ‍್ಹೋಥೊ. ");
INSERT INTO vaa_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","ಯೋ ಯೇಸುನ ದೇಕ್ಣು ಕರಿ ಆಖ್ಹ್‌ಕರ‍್ಯೊ, ಕತೋಬಿ ಯೋ ಕುಳ್ಳೊ ಹುಯಿರ‍್ಹೊಥೋತೆ ಅಜು಼ ಅದ್ಮಿನಿ ಭೀಡ್‌ಥೀತೆ ಇನಖ್ಹಾಜೆ, ಯೇಸುನ ದೇಖಾನ ಕೋ ಹುಯೂನಿ. ");
INSERT INTO vaa_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","ಇನಖ್ಹಾಜೆ ಯೋ ಯೇಸುನ ದೇಕ್ಣು ಕರಿ, ಅದ್ಮಿನಿ ಭೀಡ್‌ಣ ಖ್ಹಾಮ್ಣೆ ನಾಶಿ ಜೈ಼ನ್, ಏಕ್‌ ವಡ್‌ನ ಝಾ಼ಡ್‌ಪರ್‌ ಚ಼ಢಿಗಯೊ. ಶನಕತೊ, ಯೇಸು ಯೋಸ್‌ ವಾಟೆಕರಿ ಆವಾಳೊ ಥೊ. ");
INSERT INTO vaa_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","ತದೆ ಯೇಸು ಹಿಜ್ಗಾ಼ ಆಯಿನ್, ಉಪ್ಪರ್ ದೇಖಿನ್‌, “ಜಕ್ಕಾಯ, ಫಟ್‌ ಕರಿ ಉತ್ರಿನ್ ಆವ್, ಶನಕತೊ ಆಜ಼್ ಮೇ ತಾರ ಘರ್‌ಮ ರ‍್ಹವಾನ ಆಯೊ” ಕರಿ ಇನ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","ತದೆ ಜಕ್ಕಾಯ ಒಗ್ಗಿಸ್‌ಮ ಉತ್ರಿ ಐನ್, ಖ್ಹುಶಿಥಿ ಯೇಸುನ ಸ್ವಾಗತ್ ಕರ‍್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","ಅನ ದೇಖಿನ್‌ ಅದ್ಮಿಖ್ಹಾರು, “ಯೇಸು ಪಾಪಿನ ಘರ್‌ಮ ಮೆಹಮಾನ್ ಹುಯಿನ್ ವಳ್ಯೊಜಾ಼ಸ್‌” ಕರಿ ಭಣ್‌ಕ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","ಕತೋಬಿ ಜಕ್ಕಾಯಾನೆ ಭೀರಿನ್‌, ಪ್ರಭುನ, “ಗುರು ಹಂದೇಕ್‌! ಮಾರಿ ಆಸ್ತಿಮ ಆಧು ಗೋರ್‌-ಗರೀಬ್ ದೆವುಸ್‌ ಅಜು಼ ಮೇ ಕಿನಾತೋಬಿ ಠಗೈರಾಖ್ಯೊ ಉಶೇತೊ, ಇನ ಏಕ್‌ನ ಚಾರ್ ದೆವುಸ್‌” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","ಅನ ಖ್ಹಮ್‌ಜಿನ್‌, ಯೇಸುನೆ ಇನ, “ಆಜ಼್ ಆ ಘರ್‌ನ ರಕ್ಷಣೆ ಐರ‍್ಹೀಸ್, ಶನಕತೊ ಆಬಿ ಅಬ್ರಹಾಮ್‌ನೊ ಪಿಳ್ಗಿವಾಳೊ ಹುಯಿರ‍್ಹೋಸ್‌ನಿ. ");
INSERT INTO vaa_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","ಶನಕತೊ ಅದ್ಮಿನೊ ಛಿಯ್ಯೊ, ಗುಮೈಗೂತೆ ಇನ ಢೂಂಡಿನ್ ಬಚಾ಼ಡನಖ್ಹಾಜೆ ಐರ‍್ಹೋಸ್ತೆ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","ಇವ್ಣೆ ಆ ವಾತೆಖ್ಹಾರಿ ಖ್ಹಮ್‌ಜು಼ಕರಾನಿ ವಖ್ಹತ್‌ಮ, ಯೇಸು ಯೋ ಯೆರೂಸಲೇಮ್‌ನ ಖನ್ನೆಸ್‌ ಪೋಚಿಗಯೊಥೋತೆ ಇನಖ್ಹಾಜೆ, ಅಜು಼ ಅದ್ಮಿಖ್ಹಾರು ದೇವ್ನಿ ರಾಜ್ಯ ಒಗ್ಗಿಸ್‌ಮ ದೆಖಾವ್‌ಶೆ ಕರಿ ಸೋಚ್ಯೂತೆ ಇನಖ್ಹಾಜೆ, ಯೇಸುನೆ ಬಿಜ್ಜೇಕ್‌ ಮತ್ಲಬ್‌ನಿ ಖೇಣಿನ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","ಯೋ ಶಾತ್‌ಕತೊ, “ಏಕ್‌ ಮೋಟ ಘರ್‌ನು ಶೌಕರ್‌ ಅದ್ಮಿಥು, ಯೋ ರಾಜ಼್‌ಭಾರ್‌ಲೀನ್, ಪಾಛು಼ಫರಿ ಇನ ಘರೆ ಆವ್ಣುಕರಿ ಖ್ಹೂಜ಼್ ಕರೀನ್, ದೂರ್‌ಲ್ಯೊ ದೇಖ್ಹ್‌ನ ನಿಕ್‌ಳ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","ಯೋ ಜಾ಼ವನ ಆಗಾಡಿ, ಇನ ಸೇವಕರ್‌ಮ ದಖ್ಹ್‌ ಜ಼ಣಾನ ಬುಲೈನ್, ಹರ್‌ ಏಕ್‌ನ ಖ್ಹೊನ್ನಾನು ಬಿಲ್ಲು ದೀನ್, “ಮೇ ಆವಾತೋಡಿ ಅನೇಥಿ ಧಂದೊ ಕರೊ” ಕರಿ ಇವ್ಣುನ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","ಕತೋಬಿ ಇನು ಶೊಂತ್‌ ಖ್ಹಯೇರ‍್ನು ಅದ್ಮಿ ಇನಾಪರ್‌ ದಾವೊ ಕರೀನ್, ಇನ ಪೀಠೆ ಖಬರ್ ದ್ಯವಾಳಾನ ಮೋಕ್ಲಿನ್, “ಆ ಹಮಾರಪರ್‌ ರಾಜ಼್‌ಭಾರ್‌ ಚ಼ಲಾವಾನು ಹಮೂನ ಅಛ್ಛು಼ ಲಾಗಕೊಯ್ನಿ” ಕರಿ ಇನ ಬೋಲ್ಯು.‌ ");
INSERT INTO vaa_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","ತೋಬಿ ಯೋ ಅದ್ಮಿ ರಾಜ್ಯನಿ ಅದಿಕಾರಿಹುಯಿನ್ ಫಾಛೊ಼ಫರಿ ಆಯೊ. ತದೆ ಇನೆ, “ಮೇ ಖ್ಹೊನ್ನಾನು ಬಿಲ್ಲು ದಿದೊಥೋತೆ ಸೇವಕರ್‌ನ ಮಾರ ಖ್ಹಾಮೆ ಬುಲಾವೊ. ಇವ್ಣೆ ಕೆತ್ರು ಕಮೈರಾಖ್ಯುಸ್‌ ಕರಿ ಮನ ಮಾಲುಮ್‌ ಪಡ್ಣು” ಕರಿ ಹುಕುಮ್‌ದಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","ಪಹಿಲೊ ಸೇವಕ್‌ನೆ ಇನಖ್ಹಾಮ್ಣೆ ಆಯಿನ್, “ಪ್ರಭು ತುನೆ ದಿದೋತೆ ಏಕ್‌ ಖ್ಹೊನ್ನಾನು ಬಿಲ್ಲಾಥಿ, ಮೇ ದಖ್ಹ್‌ ಖ್ಹೊನ್ನಾನು ಬಿಲ್ಲಾ ಕಮೈರಾಖ್ಯೋಸ್” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","ಯೋ ಇನ, “ಶಬಾಶ್! ತೂ ಅಛ್ಛೊ಼ ಸೇವಕ್! ತೂ ಥೋಡಾಮ ನಿಯಥ್ಥಿ ರ‍್ಹಯೋತೆ ಇನಖ್ಹಾಜೆ, ಮೇ ತುನ ದಖ್ಹ್‌ ಖ್ಹಯೇರ್‌ಪರ್‌ ಅದಿಕಾರಿಕರಿನ್ ಮ್ಹೇಲುಕರೂಸ್‌” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","ಬಿಜ್ಜೇಕ್‌ ಜ಼ಣೊ ಆಯಿನ್, “ಗುರು ತುನೆ ದಿದೋತೆ ಏಕ್‌ ಬಿಲ್ಲಾಥಿ, ಮೇ ಪಾಚ಼್ ಖ್ಹೊನ್ನಾನು ಬಿಲ್ಲಾ ಕಮೈ ಕರಿರಾಖ್ಯೋಸ್” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","ತದೆ ರಾಜಾ಼ನೆ ಅನ, “ತೂಬಿ ಪಾಚ಼್‌ ಖ್ಹಯೇರ್‌ಪರ್‌ ಅದಿಕಾರಿಹುಯಿನ್ ರ‍್ಹೇ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","ಅನ ಬಾದ್‌ಮ ಬಿಜ್ಜೇಕ್‌ ಜ಼ಣು ಐನ್, “ಪ್ರಭು, ಅಲಾ ತುನೆ ದಿದೋತೆ ಖ್ಹೊನ್ನಾನು ಬಿಲ್ಲು. ಅನ ಏಕ್‍ ಚೌ಼ಕಾಮ ಲಪೇಟಿನ್ ಮ್ಹೇಲಿರಾಖ್ಯೊಥೊ. ");
INSERT INTO vaa_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","ತೂ ತಾರು ಕಾಹೆತೆ ರಾಛ಼ನ ಫಳ್ಳಿ ಜಾ಼ವಾಳೊ, ತುನೆ ಛಿಡ್‌ಕ್ಯೊಕೊಂತೆ ಇನ ವ್ಹಾಡವಾಳೊ ಕಠಣ್‌ ಅದ್ಮಿಕರಿ ಬೋಲಿನ್, ತಾರೇಥಿ ಡರಿನ್, ಆ ಬಿಲ್ಲಾನ ಚೌ಼ಕಾಮ ಭಾಂದೀನ್‌, ಲಪಾಡಿರಾಖ್ಯೊಥೊ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","ಅನ ಖ್ಹಮ್‌ಜಿನ್‌ ಯೋ ರಾಜ಼ ಇನ, “ತೂ ಖರಾಬ್ ಸೇವಕ್! ತಾರಿ ವಾತೆಥೀಸ್‌ ತುನ ತೀರ್ಪ್‌ ಕರುಸ್. ಮೇ ಮಾರು ಕಾಹೆತೆ ರಾಛಾ಼ನ ಪಳ್ಳಿನ್‌ ಜಾ಼ವಾಳೊ, ಮೇ ಪಿಕಾಯೊಕೊಂತೆ ಇನ ವ್ಹಾಡವಾಳೊ ಕಠಣ್ ಅದ್ಮಿಕರಿ ತುನ ಮಾಲುಮ್‌ನಿ. ");
INSERT INTO vaa_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","ಇಮ್‍ಕತೊ, ತೂ ಮಾರು ಖ್ಹೊನ್ನಾನು ಬಿಲ್ಲಾನ ಬಡ್ಡಿಪರ್ ಶನ ಕೋ ದಿದೋನಿ?” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","ತದೆ ಖನ್ನೆ ಭಿಯ್ಯುಥೂತೆ ಇವ್ಣುನ ಇನೆ, “ಅನಕಂಥು, ಯೋ ಖ್ಹೊನ್ನಾನು ಬಿಲ್ಲಾನ ಲೀನ್‌, ದಖ್ಹ್‌ ಖ್ಹೊನ್ನಾನು ಬಿಲ್ಲಾ ಛಾ಼ತೆ, ಇನ ದೆವೊ” ಕರಿ ಬೋಲ್ಯೊ ");
INSERT INTO vaa_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","ಕತೋಬಿ ಇವ್ಣೆ ಇನ, “ಪ್ರಭು, ಇನಾಕನ ಅಗಾಡಿಸ್ ದಖ್ಹ್‌ ಖ್ಹೊನ್ನಾನ ಬಿಲ್ಲಾ ಛಾ಼ನಿ” ಕರಿ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","ತದೆ ರಾಜಾ಼ನೆ ಇವ್ಣುನ ಬೋಲ್ಯೋಕಿ, “ಮೇ ಬೋಲುಸ್ಕಿ, ಕಿನಾಕಿನ ಛಾ಼ಕಿ ಇವ್ಣುನ ಬಿಜೂ಼ಬಿ ದೇವಾವ್‌ಶೆ, ಕತೋಬಿ ಕಿನಾಕನ ಕೊಯ್ನಿಕಿ ಇವ್ಣಕಂಥು, ಛಾ಼ತೆಬಿ ಕಾಡಿಲಿಶೆ” ");
INSERT INTO vaa_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","ಅಜು಼ ಮೇ ಇವ್ಣಾಪರ್ ರಾಜಾ಼ ನಾ ಹುಯಿರ‍್ಹೇಣು ಕರಿ ಬೋಲ್ಯುಥೂತೆ ಯೋ ಮಾರ ದುಶ್‌ಮನ್ನ ಖ್ಹಾರು, ಹಮ್ಕೆ ಹಜ಼್ಜಾ ಲೈನ್‌, ಮಾರ ಖ್ಹಾಮ್ಣೆಸ್ ಇವ್ಣುನ ಮಾರಿ ನಾಕ್ಣು!” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","ಆ ಖ್ಹಾರು ಬೋಲಾನ ಬಾದ್‌ಮ, ಯೇಸು ಇವ್ಣೇಥಿ ಖ್ಹಾಮ್ಣೆ-ಖ್ಹಾಮ್ಣೆ ಚಾ಼ಲಿನ್, ಯೆರೂಸಲೇಮ್‌ ಭಣಿಗಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","ಅನ ಬಾದ್‌ಮ ಯೇಸು, ಆಲಿವ್ ತೇಲ್‌ನುಝಾ಼ಡ್ನ ಪಹಾಡ್‌ಕನ, ಥೂತೆ, ಬೆತ್ಫಗೆ ಅಜು಼ ಬೇಥಾನ್ಯ ಕರಿ ಗಾಮ್‌ನ ಖನ್ನೆ ಆವಾದಿನ್, ಶಿಷ್ಯರ್‌ಮ ಬೇ ಜ಼ಣಾನ ಬುಲೈನ್, “ತುಮಾರ ಖ್ಹಾಮ್ಣೆ ಛಾ಼ತೆ ಗಾಮ್ಮ ಜಾ಼ವೊ. ");
INSERT INTO vaa_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","ತುಮೆ ಯೋ ಗಾಮ್‌ನ ಮಹಿ ಜಾ಼ತಸ್‌ನ ಹಿಜ಼್ಜಾ ಭಂದೈರ‍್ಹೀಶೆತೆ, ಏಕ್‌ ಜಾ಼ನ್ಜ಼ಮಾನ್ ಗಧೇಡಾನ ಚೆಲ್ಕಾನ ದೇಕ್‌ಶು, ಹಂಕೆತೋಡಿ ಇನಾಪರ್‌ ಕೋಣ್‌ಬಿ ಕೋ ಬೆಠೂನಿ. ಇನ ಛೋ಼ಡಿನ್, ಹಜ್ಜಾ಼ ಧರಿಲೀನ್ ಆವೊ, ");
INSERT INTO vaa_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","ಕೋಣ್‌ತೋಬಿ ತುಮೂನ, ‘ಅನ ಶನ ಛೋ಼ಡುಕರಾಸ್ತೆ‌?’ ಕರಿ ಫುಛಾ಼ಯುತೊ, ಪ್ರಭುನ ಆ ಹೋಣುಕಸ್‌ ಕರಿ ಬೋಲೊ” ಕರಿ ಬೋಲಿನ್ ಮೋಕ್‌ಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","ಇವ್ಣೆ ಜೈ಼ನ್‌, ಯೇಸುನೆ ಬೋಲ್ಯೊಥೋತೆ ಇಮ್ಮಸ್ ಥೂತೆ ದೇಖ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","ಇವ್ಣೆ ಯೋ ಗಧೇಡಾನ ಚೆಲ್ಕಾನ ಛೋ಼ಡುಕರಾನಿ ವಖ್ಹತ್‌ಮ, ಇನ ಯಜಮಾನ್ನೆ, “ಇನ ಶನ ಛೋ಼ಡುಕರಾಸ್ತೆ?” ಕರಿ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","ತದೆ ಇವ್ಣೆ, “ಆ ಪ್ರಭುನ ಹೋಣುಕಸ್‌” ಕರಿ ಜವಾಬ್‌ ದಿದು. ");
INSERT INTO vaa_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","ಯೋ ಗಧೇಡಾನ ಯೇಸುಕನ ಲೈನ್‌, ಇವ್ಣ ಲುಂಗ್ಡಾವ್‍ನ, ಯೋ ಗಧೇಡಾನಚೆಲ್ಕನ ಉಪ್ಪರ್ ನಾಖಿನ್, ಯೇಸುನ ಇನಾಪರ್‌ ಬೆಖ್ಹಾಡ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","ಯೇಸು ಜಾ಼ತೊರ‍್ಹವಾನಿ ವಖ್ಹತ್‌ಮ, ಇವ್ಣೆ ಇವ್ಣ ಲುಂಗ್ಡಾವ್‍ನ ವಾಟ್‌ಪರ್ ಬಿಛಾ಼ಯು. ");
INSERT INTO vaa_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","ಯೇಸು ಯೆರೂಸಲೇಮ್‌ನ ಖನ್ನೆ, ಆಲಿವ್ ಪಹಾಡ್‌ನು ಉತರ್‌ತಿ ಝ಼ಗೋಕನ ಆವಾದಿನ್, ಇನ ಶಿಷ್ಯರ್‌ನಿ ಮೋಟಿ ಝೂ಼ಂಡ್‌ ಖ್ಹುಶಿ ಕರ್ತುಹುಯಿನ್, ಇವ್ಣೆ ದೇಖ್ಯೂತೆ ಖ್ಹಾರಿಸ್ ಮಹಾನ್ ಕಾಮ್ನಖ್ಹಾಜೆ ಜೋ಼ರ್ ಅವಾಜ಼್‌ಥಿ ದೇವ್ನಿ ಸ್ತುತಿ ಕರ‍್ಯು. ");
INSERT INTO vaa_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","“ಪ್ರಭುನ ನಾಮ್‌ಪರ್‌ ಆವಾಳ ರಾಜಾ಼ನ ಆಶೀರ್ವಾದ್‌ ಹುವಾದೆ ಪರ್‌ಲೋಕ್‌ಮ ಸಮಾಧಾನ್‍, ಉಪ್ಪರ್‌ಲ್ಯ ಲೋಕ್ಮ ಮಹಿಮೆ ಹುವಾದೆ!” ಕರಿ ಘಣಿಮೋಟಿ ಅವಾಜ಼್ ದೇವ್ನ ಸ್ತುತಿ ಕರಲಗ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","ಅದ್ಮಿನಿ ಝೂ಼ಂಡ್‌ಮ ಥೂತೆ ಥೋಡು ಫರಿಸಾಯರ್‌ವಾಳು ಯೇಸುನ, “ಗುರು, ತಾರ ಶಿಷ್ಯರ್‌ನ ಖ್ಹೊಪ್‌ ರ‍್ಹವೊ ಕರಿ ಗುರ್‌ಕಾವ್” ಕರಿ ಬೋಲ್ಯು, ");
INSERT INTO vaa_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","ತದೆ ಯೇಸುನೆ, “ಮೇ ತುಮೂನ ಬೋಲುಸ್ಕಿ, ಅವ್ಣೆ ಖ್ಹೊಪೊ ಹುಯಿಗಯೂತೊ, ಆ ಬಂಡಾಸ್ ಇವ್ಣು ಇವ್ಣೆ ಚಿಕರ್‌ಶೆ” ಕರಿ ಜವಾಬ್‌ ದಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","ಯೇಸು ಯೆರೂಸಲೇಮ್‌ ಖ್ಹಯೇರ‍್ನ ಖನ್ನೆ ಆಯಿನ್, ಇನ ದೇಖಿನ್, ಇನಿ ಬಾರೇಮ ರೋವ್‌ತೊಹುಯಿನ್‌, ");
INSERT INTO vaa_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","ಅಜು಼ ಬೋಲ್ಯೋಕಿ, “ಶಾಂತಿಥಿ ರ‍್ಹವಾನ ಶಾತ್‌ ಹೋಣು ಕರಿ ಬೋಲಾನು, ತೂ ಹಜ್ಜಾ಼ಸ್ ಮಾಲುಮ್‌ ಕರಿಲಿದಿಹೋತ್‌ತೊ ಕೆತ್ರೆಸ್ಕಿ ಅಛ್ಛು಼ ಥೂ! ಕತೋಬಿ ಹಮ್ಕೆ ತುನ, ಯೋ ದೇಖಾನ ಕೊ ಉಶೇನಿ, ");
INSERT INTO vaa_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","ಏಕ್‌ ವಖ್ಹತ್ ಆವ್‌ಶೆ, ತದೆ ತಾರು ದುಶ್‌ಮನ್‌ ಖ್ಹಾರು, ತಾರ ಅಶ್‌ಪೀಶ್‌ ಭೀತ್ ಭಾಂದಿನ್, ತುನ ಖ್ಹಾರಿಸ್ ಬಾಜು಼ಥು ಕಬ್‍ಜಾ಼ ಕರೀನ್, ");
INSERT INTO vaa_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","ಇವ್ಣೆ ತುನ ಅಜು಼ ತಾರಿ ಭೀತ್‌ನ ಮಹಿ ಛಾ಼ತೆ ಖ್ಹಾರ ಅದ್ಮಿನ ಬರ್ಬಾತ್ ಕರ್ಶೆ, ಏಕ್‌-ಬಂಡಾಪರ್ ಬಿಜ್ಜೇಕ್‌ ಬಂಡೊ ಭೀರೆವ್ಣುನಾತೆ ಇಮ್‌ ಇವ್ಣೆ ಕರ್ಶೆ, ಶನಕತೊ, ದೇವ್ನೆ ತುನ ಬಚಾ಼ಡ್‌ಣು ಕರಿ ಆಯೋತೆ ವಖ್ಹತ್‌ನ, ತೂ ಪರ್ಖಿ ಕೊಯ್ನಿ!” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","ಅನ ಬಾದ್‌ಮ ಯೇಸು ಮಂದಿರ್‌ಮ ಜೈ಼ನ್‌, ವೇಚ಼ವಾಳನ ಭಾರ್‌ ನಖ್ಹಾಡಲಗ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","ಅಜು಼ ಇವ್ಣುನ ಬೋಲ್ಯೊಕಿ, “ದೇವ್ನೆ ಬೋಲ್ಯೊ, ‘ಮಾರಿ ಮಂದಿರ್‌ ಪ್ರಾರ್ಥನೇನು ಘರ್ ಹುಯಿರ‍್ಹಿಶೆ’ ಕರಿ ಲೀಖೈರ‍್ಹೂಸ್‌ನಿ. ಕತೋಬಿ ತುಮೆ ಅನ ಚೋ಼ರ್‌ನಿ ಲಪಾನಿ ಘವಿ ಬಣೈನಾಖ್ಯ. ");
INSERT INTO vaa_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","ದನ್‍ರೋಜ್‍಼ ಯೇಸು ಮಂದಿರ್‌ಮ ವಚನ್‍ ಬೋಲಿದೆತೋಥೊ. ಕತೋಬಿ ಮಹಾಯಾಜಕ, ಮೋಶೆನಿ ವಚನ್ ಶಿಕಾಡವಾಳು ಶಾಸ್ತ್ರಿಯೆ ಅಜು಼ ಶಾಣು ಖ್ಹಾರು ಯೇಸುನ ಮರ್‌ನಾಖಿದೇವ್ಣು ಕರಿ ಕೋಶಿಶ್ ಕರ‍್ಯು. ");
INSERT INTO vaa_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","ಕತೋಬಿ ಇನ ಖೆವಿ ತರಿಕಾಥಿ ಮರ್‌ನಾಖಿ ದಿಯೆಜಾ಼ಯ್ ಕರಿ ಬೋಲಾನು ಇವ್ಣ ಮಾಲುಮ್‌ ಕೋ ಪಡ್ಯುನಿ, ಶನಕತೊ ಅದ್ಮಿಖ್ಹಾರು ಯೇಸುನಿ ವಾತೆನ ಚಿಂತ್‌ಲಗಾಡಿನ್, ಖ್ಹಮ್‌ಜ಼್‌ತೂಥು. ");
INSERT INTO vaa_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","ಏಕ್‌ ದನ್ನೆ ಯೇಸು ಮಂದಿರ್‌ಮ ಅದ್ಮಿನ ವಚನ್ನ ಬೊಲಿದೇತೊಹುಯಿನ್‌, ಸುವಾರ್ತೆನ ಬೋಲುಕರ್ತೊಥೋತೆ ತದೆ, ಮಹಾಯಾಜಕ, ಮೋಶೇನು ಧರ್ಮಶಾಸ್ತ್ರ ಶಿಕಾಡವಾಳು ಶಾಸ್ತ್ರಿಯೆ ಅಜು಼ ಶಾಣುಖ್ಹಾರು ಮಳಿನ್ ಯೇಸುಕನ ಆಯು. ");
INSERT INTO vaa_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","ಅಜು಼ ಇವ್ಣೆ ಇನ, “ಹಮೂನ ಬೋಲ್! ಆ ಖ್ಹಾರು ಕರಾನ ತುನ ಶನಿ ಅದಿಕಾರ್ ಛಾ಼?ಅಮ್ನಿ ಹಕ್ ತುನ ಕೋಣ್ ದಿದು?” ಕರಿ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","ತದೆ ಯೇಸುನೆ ಇವ್ಣುನ, “ಮೇಬಿ ತುಮೂನ ಏಕ್‌ ಸವಾಲ್‌ ಫುಛಾ಼ವುಸ್‌. ಮನ ಬೋಲೊ, ");
INSERT INTO vaa_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","ಬ್ಯಾಪ್ತಿಸ್ಮ ದ್ಯವಾನಿ ಹಕ್‌, ಯೋಹಾನ್ನ ಪರಲೋಕ್‌ಥಿ ಆಯುಕಿ, ಅದ್ಮಿಥಿ ಆಯು? ಕರಿ ಪುಛಾ಼ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","ತದೆ ಇವ್ಣೆ, “ಅಪ್ಣೆ ಶಾತ್‌ ಬೋಲಿಯೆ? ಪರ್‌ಲೋಕ್‌ಥು ಆಯು ಕರಿ ಅಪ್ಣೆ ಬೋಲ್ಯಾತೊ, ಇಮ್‍ಕತೊ, ತುಮೆ ಇನ ಶನ ನಂಬ್ಯಾಕೊಯ್ನಿ? ಕರಿ ಬೋಲ್‌ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","ಅದ್ಮಿಥಿ ಆಯು ಕರಿ ಬೋಲ್ಯಾತೊ, ಅದ್ಮಿಖ್ಹಾರು ಯೋಹಾನ ಪ್ರವಾದಿ ಕರಿ ನಂಬಿರಾಖ್ಯುತೆ ಇನಖ್ಹಾಜೆ, ಇವ್ಣೆ ಅಪ್ಣುನ ಬಂಡೊ ಫೇಕಿ ಮಾರ್‌ಶೆ” ಕರಿ ಇವ್ಣ-ಇವ್ಣಾಮಸ್‌ ಬೋಲಿಲಿದು. ");
INSERT INTO vaa_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","ಇನಖ್ಹಾಜೆ ಇವ್ಣೆ, “ಯೋ ಕಿಜ್ಗಾ಼ಥು ಆಯು ಕರಿ ಹಮೂನ ಮಾಲುಮ್‌ ಕೊಯ್ನಿ” ಕರಿ ಜಾ಼ವಾಬ್‌ ದಿದು. ");
INSERT INTO vaa_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","ತದೆ ಯೇಸುನೆ ಇವ್ಣುನ, “ಆ ಖ್ಹಾರು ಖೆವಿ ಹಕ್‌ಥಿ ಕರುಸ್ ಕರಿ ಬೋಲಾನು, ಮೇಬಿ ತುಮೂನ ಕೋ ಬೋಲೂನಿ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","ಬಾದ್‌ಮ ಯೇಸುನೆ ಅದ್ಮಿಯೇನ ಏಕ್‌ ಮತ್ಲಬ್‌ನಿ ಖೇಣಿನ ಬೋಲ್ಯೊ. ಯೋ ಶಾತ್‌ಕತೊ, “ಏಕ್‌ ಅದ್ಮಿ, ಏಕ್‌ ದ್ರಾಕ್ಷಿನು ಬಾಗ್‌ನ ಬಣೈನ್, ಇನ ವಾರ್‌ನ ದೀನ್, ಬಿಜೇ಼ಕ್‌ ದೇಖ್ಹ್‌ನ ಜೈ಼ನ್‌, ಘಣ ದನ್‌ತೋಡಿ ಹಿಜ಼್ಜಾಸ್‌ ಥೊ. ");
INSERT INTO vaa_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","ದ್ರಾಕ್ಷಿ ತೋಡಾನಿ ವಖ್ಹತ್ ಆವಾದಿನ್, ಏಕ್‌ ಆಳ್‌ನ ವಾರ್‌ನ ದೀರಾಖ್ಯೊಥೋತೆ ಇವ್ಣಾಕನ ಮೋಕ್‌ಲ್ಯೊ. ಕತೋಬಿ ಇವ್ಣೆ ಇನ ಮಾರಿನ್, ಖಾಲಿಹಾತೆ ಮೋಕ್ಲಿದಿದು. ");
INSERT INTO vaa_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","ತದೆ ಇನೆ ಬಿಜ್ಜೇಕ್‌ ಆಳ್‌ನ ಇವ್ಣಾಕನ ಮೋಕ್ಲಾಖ್ಹತರ್‌, ಇನಾಬಿ ಮಾರಿನ್, ಖ್ಹರಮ್‌ ಕಾಡೀನ್‌, ಖಾಲಿಹಾತೆ ಮೋಕ್ಲಿದಿದು. ");
INSERT INTO vaa_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","ತದೆ ಇನೆ ಬಿಜ್ಜೇಕ್‌ ಜ಼ಣಾನ ಮೋಕ್‌ಲ್ಯೊ; ಇವ್ಣೆ ಇನಾಬಿ ಫೋಡ ಹುವ್ವಾಎತ್ರೆ ಮಾರಿನ್, ಭಾರ್ ಫೇಕಿದಿದು. ");
INSERT INTO vaa_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","ತದೆ ಯೋ ದ್ರಾಕ್ಷಿನೊ ಬಾಗ್‌ನೊ ಮಾಲಿಕ್‍ನೆ ಮೇ ಶಾತ್‌ಕರು? ಮಾರೊ ಲಾಡ್‌ನೊ ಛಿಯ್ಯಾನ ಮೋಕ್ಲುಸ್‌! ಇನಾತೋಬಿ ದೇಖಿನ್‌ ಮರ್ಯಾದಿ ದೇಸ್ಕಿ ಶುಕಿ! ಕರಿ ಸೋಚಿನ್ ಮೋಕ್‌ಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","ಕತೋಬಿ ಯೋ ವಾರ್‌ನ ಲೀರಾಖ್ಯೂಥೂತೆ ಇವ್ಣೆ ಇನ ದೇಖಿನ್‌, “ಆಸ್ ಮಾಲಿಕ್‌ನೊ ಛಿಯ್ಯೊ. ಅನ ಮಾರಿನಾಖಿದಿಯ್ಯೆ, ತದೆ ಇನು ಶೊತ್ ಖ್ಹಾರು ಅಪ್ಣು ಹುಯಿಜಾ಼ಶೆ!” ಕರಿ ಏಕ್‌ಥಿ ಏಕ್‌ ಬೋಲಿಲಿದು. ");
INSERT INTO vaa_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","ಅಜು಼ ಇನ ದ್ರಾಕ್ಷಿನ ಬಾಗ್‌ಮಾಥು ಭಾರ್ ಧಕೇಲಿನ್, ಮಾರಿನಾಕ್ಯು. ಇಮ್‍ಕತೊ, ಯೋ ದ್ರಾಕ್ಷಿನು ಬಾಗ್‌ನೊ ಯಜಮಾನ್ ಆಯಿನ್, ಇವ್ಣುನ ಶಾತ್‌ ಕರ್ಶೆ?” ಕರಿ ಯೇಸುನೆ ಪುಛಾ಼ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","“ಯೋ ಆಯಿನ್, ವಾರ್‌ನ ಲೀರಾಖ್ಯುಥೂತೆ, ಇವ್ಣುನ ಮಾರಿನಾಖಿನ್, ಇನ ದ್ರಾಕ್ಷಿನ ಬಾಗ್‌ನ ಬಿಜಾ಼ವ್ನ ದಿಶೆ” ಕರಿ ಬೋಲ್ಯೊ. ಅನ ಖ್ಹಮ್‌ಜಿನ್‌ ಅದ್ಮಿಖ್ಹಾರು, “ಅಮ್ ನಾಹೊಣು!” ಕರಿ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","ಕತೋಬಿ ಇವ್ಣುನ ದೇಖಿನ್ ಯೇಸುನೆ, “ಘರ್ ಭಾಂದಾವಾಳು ನಕೊಕರಿ ಝಿಟ್ಕಾರಯೋತೆ ಬಂಡೋಸ್, ಹೋಣುತೆ ಕೋಣಾನೊ ಬಂಡೊ ಹುಯೊ” ಕರಿ ಲೀಖೈರ‍್ಹೂತೆ ಇನಿ ಮತ್‌ಲಬ್ ಶಾತ್‌?” ಕರಿ ಪುಛಾ಼ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","ಯೋ ಬಂಡಾಪರ್ ಪಡಾವಾಳು ಹರೇಕ್ ಜ಼ಣಾನ ಟುಕ್‌ಡಾ-ಟುಕ್‌ಡಾ ಕರಿನಾಕ್‌ಶೆ; ಅಜು಼ ಆ ಬಂಡೊ ಕಿನಾಪರ್ ಪಡ್‌ಶೇಕಿ, ಇನ ಬುಕ್‍ನು-ಬುಕ್‍ನು ಕರಿನಾಕ್‌ಶೆ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","ಮೋಶೇನು ಧರ್ಮಶಾಸ್ತ್ರ ಶಿಕಾಡವಾಳು ಶಾಸ್ತ್ರಿಯೆ ಅಜು಼ ಮಹಾಯಾಜಕ ಆ ವಾತೇವ್ನ ಖ್ಹಮ್‌ಜಿನ್‌, ಆ ಹಮಾರಿ ಬಾರೆಮಾಸ್‌, ಆ ಮತ್ಲಬ್‌ನಿ ಖೇಣಿನ ಬೋಲ್ಯೊ, ಕರಿ ಮಾಲುಮ್‌ ಕರಿಲೀನ್, ಯೋಸ್‌ ವಖ್ಹತ್‌ಮ, ಯೇಸುನ ಧರ್‌ನು ಕರಿ ಕರ‍್ಯು. ಕತೋಬಿ ಅದ್ಮಿನ ಡರ್‌ಥಿ ಇನ ಧರ‍್ಯು ಕೊಯ್ನಿ. ");
INSERT INTO vaa_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","ಅನ ಬಾದ್‌ಮ ಇವ್ಣೆ, ಯೇಸುನ ರೋಮ್‍ನು ಅಧಿಪತಿನಹಾತ್ಮ ಅಜು಼ ಇನಿ ಅದಿಕಾರಿನಾಬಿ ದೇವ್ಣು ಕರಿ ಸೋಚಿನ್, ಇನ ಧರ್‌ನು ಕರಿ ಜ಼ಪಾಲಗ್ಯು. ಅನಖ್ಹಾಜೆಸ್ ನೀತಿವಾಳಾನಿಮತ್‌ ನಾಟಕ್‍ಕರಾಸ್ತೆ ಥೋಡ ಜ಼ಣಾನ, ಯೇಸುನ ವಾತೇಮ ಖ್ಹಪ್‌ಡಾವ್ಣು ಕರಿ ಇನಾಕನ ಮೋಕ್‍ಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","ಅವ್ಣೆ ಯೇಸುನ, “ಗುರು, ತೂ ಬರೊಬರ್‌ಥೀಸ್‌ ವಾತೆ ಬೋಲಾಸ್ ಅಜು಼ ವಚನ್‍ ಬೋಲಿದೇಸ್, ಕರಿ ಹಮೂನ ಮಾಲುಮ್‌. ತು ಕಿನಾಬಿ ಮ್ಹೋಡು,ದೇಖಿನ್‌, ವಾತೆ ಬೋಲಾಕೊಯ್ನಿ. ಕತೋಬಿ ದೇವ್ನಿ ರಾಜ್ಯನಿ ಬಾರೇಮಾನಿ ಖ್ಹಾಚಿನ್‌ ಅದ್ಮಿನ ಬೋಲಿ ವತಾಳಸ್‍ ಕರೀಬಿ ಹಮೂನ ಮಾಲುಮ್‌. ");
INSERT INTO vaa_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","ಕೈಸರ್‌ನ ಶುಂಕ ಭಾಂದಾನು ನ್ಯಾವ್‌ಕಿಕೊಯ್ನಿ ಕರಿ ಹಮೂನ ಬೋಲ್” ಕರಿ ಫುಛಾ಼ಯು. ");
INSERT INTO vaa_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","ಕತೋಬಿ ಯೇಸುನೆ, ಇವ್ಣೆ ಇನ ವಾತೆಮ ಖ್ಹಪ್‌ಡವಾನ ಕರುಕರಸ್ ಕರಿ ಮಾಲುಮ್‌ ಕರಿಲೀನ್ ಇವ್ಣುನ, ");
INSERT INTO vaa_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“ಮನ ಏಕ್‌ ರೂಪಾನು ಬಿಲ್ಲು ವತಾಳೊ. ಇನಾಪರ್‌ ಕಿನು ನಾಮ್‌ಬಿ ರೂಪ್ ಛಾ಼?” ಕರಿ ಪುಛಾ಼ವಖ್ಹತರ್, ಇವ್ಣೆ, “ಕೈಸರ್‌ನು” ಕರಿ ಜಾ಼ವಾಬ್‌ದಿದು. ");
INSERT INTO vaa_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","ತದೆ ಯೇಸುನೆ ಇವ್ಣೆ, “ಇಮ್‍ಕತೊ, ಕೈಸರ್‌ನು ಶಾತ್‌ ಛಾ಼ಕಿ ಕೈಸರ್‌ನ ದೆವೊ, ಅಜು಼ ದೇವ್‌ನು ಶಾತ್‌ ಛಾ಼ಕಿ ಯೋ ದೇವ್ನ ದೆವೊ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","ಅದ್ಮಿನ ಖ್ಹಾಮ್ಣೆ ಯೇಸುನ ವಾತೆಮ ಖ್ಹಪ್‌ಡವಾನ ಕೋಹುಯುನಿ, ಇನಖ್ಹಾಜೆ ಇವ್ಣೆ ಖ್ಹೊಪ್‌ ಹುಯಿಗಯು ಅಜು಼ ಯೇಸುನೆ ದಿದೋತೆ ಜ಼ವಾಬ್‌ನ ಖ್ಹಮ್‌ಜಿನ್‌, ಆಶ್ಚರ್ಯ ಖಾದು. ");
INSERT INTO vaa_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","ಅನ ಬಾದ್‌ಮ, ಮರವಾಳು ಪಾಛು಼ ಜಿವ್ತುಹುಯಿನ್ ಉಠಾಕೊಯ್ನಿ’ ಕರಿ ಬೋಲಾವಾಳು ಹುಯಿರ‍್ಹೂತೆ ಸದ್ದುಕಾಯವಾಳಾಮ, ಥೋಡ ಜ಼ಣ ಯೇಸುಕನ ಐನ್, ");
INSERT INTO vaa_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“ಗುರು, ‘ಮೋಟೊ ಭೈನ ಬಾವಣ್‍ ರ‍್ಹೀನ್ ಯೋ ಲಡ್ಕಾಕೊಂತೆ ಮರಿಗೋತೊ, ಇನೊ ನ್ಹಾನೊ ಭೈ ಯೋ ಬಾವಣ್ಣ ಕರಿಲೀನ್ ಲಡ್ಕಾ ಪೈದಾ ಕರ‍್ನು ಅಜು಼ ಯೋ ಲಡ್ಕಾ ಮರ‍್ಯೋತೆ ಭೈನ ಲಡ್ಕಾ ಬೋಲೈಲಿಶೆ’ ಕರಿ ಮೋಶೆನೆ ಹಮಾರಖ್ಹಾಜೆ ಲೀಖಿರಾಖ್ಯೋಸ್‌ನಿ. ");
INSERT INTO vaa_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","ಖ್ಹಾತ್‌ಜ಼ಣ ಭೈಯೆ ಥಾ. ಇವ್ಣಾಮ ಮೋಟೊ ಭೈನೆ ಬಾವಣ್‍ ಕರೀನ್, ಲಡ್ಕಾಕೊಂತೆ ಮರಿಗಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","31","ಅನ ಬಾದ್‌ಮ ಬೇನೊ ಭೈನೆ ಇನ ವ್ಯಹಾ ಕರೀನ್, ಬಾದ್‌ಮ ಯೋಬಿ ಮರಿಗಯೊ. ತದೆ ತೀನ್ನೊ ಭೈನೆ ಇನ ಕರಿಲಿದೊ ಅಜು಼ ಯೋಬಿ ಮರಿಗಯೊ. ಅಮ್ಮಸ್ ಖ್ಹಾತೆ ಭೈಯೇಬಿ, ಯೋ ತಯೇಡಾನ ಕರಿಲೀನ್, ಲಡ್ಕಾಕೊಂತೆ ಮರಿಗಯ. ");
INSERT INTO vaa_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","ಆ ಖ್ಹಾರಾನ ಬಾದ್‌ಮ ಯೋ ತಯೇಡಾಬಿ ಮರಿಗೈ. ");
INSERT INTO vaa_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","ಇಮ್‍ಕತೊ ಪಾಛು಼ ಜಿವ್ತುಹುಯಿನ್ ಉಟ್‍ಶೇತೆ ತದೆ, ಯೋ ತಯೇಡ ಖೆವಾನಿ ಬಾವಣ್‍ ಹುಯಿರ‍್ಹಿಶೆ? ಶನಕತೊ ಖ್ಹಾತೆ ಜ಼ಣಾಬಿ ಇನ ಕರಿಲಿದಾಥಾನಿ” ಕರಿ ಪುಛಾ಼ಯು. ");
INSERT INTO vaa_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","ತದೆ ಯೇಸುನೆ ಇವ್ಣುನ, “ಆ ಜಗತ್‌ನು ತಯೇಡ ಪರ್ಖ್ಹಾ ವ್ಯಹಾ ಕರೀಲೆಸ್. ");
INSERT INTO vaa_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","ಕತೋಬಿ ಮರಿಗಯೂತೆ ಇವ್ಣಾಮಾಥು ಪಾಛು಼ ಜಿವ್ತುಹುಯಿನ್ ಉಠಿ ಆವಾನ ಲ್ಹಾಯಕ್ ಹುಯಿರ‍್ಹೂತೆ ಅಜು಼ ಆವ್‌ಶೇತೆ ಜ಼ಗ್‌ಮ ಜಿವ್‌ಶೇತೆ ತಯೇಡ ಪರ್ಖ್ಹಾ ವ್ಯಹಾ ಕರ್ಶೆ ಕೊಯ್ನಿ, ವ್ಯಹಾ ಕರಿಲಿಶೆಬಿ ಕೊಯ್ನಿ! ");
INSERT INTO vaa_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","ಇವ್ಣೆ ಅಜು಼ ಪಾಛು಼ ಮರ್‌ಶೆಸ್‌ಕೊಂತೆ, ದೇವ್‌ನು ದೂತರ್‌ನಿ ಘೋಣಿ ರ‍್ಹಿಶೆ. ಪಾಛು಼ ಜಿವ್ತುಹುಯಿನ್ ಉಠ್ಯೂತೆ ಇನಖ್ಹಾಜೆ, ಇವ್ಣೆ ದೇವ್ನ ಲಡ್ಕಾ ಹುಯಿರ‍್ಹಿಶೆ. ");
INSERT INTO vaa_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","ಮರವಾಳು ಜಿವ್ತುಹುಯಿನ್, ಉಟ್‍ಶೇತೆ ಇನಿ ಬಾರೇಮ ಮೋಶೇನೆ ಅಛ್ಛಿನಿತರ ವತಾಳಿರಾಖ್ಯೊಸ್. ಬಳುಕರಾತೆ ಆಗ್‍ನಿ ಡಾಗ್‌ನಿ ಬಾರೇಮ ಲೀಖಾನಿ ವಖ್ಹತ್‌ಮ, ಪ್ರಭುನೆ, ‘ಅಬ್ರಹಾಮ್‌ನೊ ದೇವ್, ಇಸಾಕನೊ ದೇವ್, ಯಾಕೋಬನೊ ದೇವ್’ ಕರಿ ಬೋಲಿರಾಖ್ಯೊಸ್. ");
INSERT INTO vaa_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","ಯೋ ಜಿವ್‌ತಾನೊ ದೇವ್ ಹುಯಿರೋಸ್, ಪಣ್ಕಿ ಮರ‍್ಯಾಹುಯಾನೊ ಕಾಹೆ, ಶನಕತೊ ಇನ ಡೋಳಾಮ ಇವ್ಣೆ ಖ್ಹಾರು ಜಿವ್ತುಸ್ ಛಾ಼. ");
INSERT INTO vaa_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","ಮೋಶೇನು ಧರ್ಮಶಾಸ್ತ್ರ ಶಿಕಾಡವಾಳು ಶಾಸ್ತ್ರಿಮ ಥೋಡು ಜ಼ಣು, “ಗುರು! ತು ಅಛ಼್ಛು ಜ಼ವಾಬ್‌ದಿದೊ” ಕರಿ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","ಅನೇಥಿ ಇವ್ಣೆ, ಬಿಜು಼ ಶಾತ್ಬಿ ಯೇಸುನ ಪುಛಾ಼ವಾನ ಡರ‍್ಯು. ");
INSERT INTO vaa_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","ತದೆ ಯೇಸುನೆ ಇವ್ಣುನ, “ಕ್ರಿಸ್ತ ದಾವೀದ್‌ನೊ ಛಿಯ್ಯೊ, ಕರಿ ಅದ್ಮಿಖ್ಹಾರು ಬೋಲಾಸ್ನಿ, ಯೋ ಕಿಮ್ ಉಶೆ? ");
INSERT INTO vaa_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","43","‘ಮೇ ತಾರ ವಹೇರ‍್ಯಾನ ತಾರ ಗೋಡಾನೊ ರಚ್ಚೊ಼ ಬಣಾವಲಗು ಮಾರಿ ಖಾವಿಬಾಜು಼ ಬೆಠೋರೆ’ ಕರಿ ಪ್ರಭುನೆ, ಮಾರ ಮಾಲಿಕ್‌ನ ಬೋಲ್ಯೊ, ಕರಿ ದಾವೀದ್‌ನೇಸ್ ಕೀರ್ತನೇನ ಪುಸ್ತಕ್‌ಮ ಲೀಖಿರಾಖ್ಯೊಸ್. ");
INSERT INTO vaa_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","ದಾವೀದಸ್‌ ಇನ ‘ಪ್ರಭು’ ಕರಿ ಬೋಲಿರಾಖಪರ್‌, ಕ್ರಿಸ್ತ ದಾವೀದ್‌ನೊ ಛಿಯ್ಯೊ ಕಿಮ್ ಉಶೆ? ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","ಅದ್ಮಿಖ್ಹಾರು ಇನಿ ವಾತೆ ಖ್ಹಮ್‌ಜು಼ಕರಾನಿ ವಖ್ಹತ್‌ಮ, ಯೇಸುನೆ ಇನ ಶಿಷ್ಯರ್‌, ");
INSERT INTO vaa_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","ಮೋಶೇನು ವಚನ್ ಶಿಕಾಡವಾಳು ಶಾಸ್ತ್ರಿಯೇನಿ ಬಾರೇಮ ಹೊಷಾರ್‌ಥಿ ರ‍್ಹವೊ. ಲಾಂಬೊ ಝ಼ಗ್ಗೊ ಪೇರ‍್ಹಿಲೀನ್‌ ಹೈಕಡ್‌ ಹೀಕಡ್‌ ಫರಾವಾಳು, ದುಕಾನೇನಿ ಗಲ್ಲಿಮ ಅದ್ಮಿಖ್ಹಾರು ಇವ್ಣ ಖ್ಹರಾವ್ಣಿ ಕರ‍್ನು ಕರಿ ಅಜು಼ ಸಭೆ ಭರಾವನು ಮಂದಿರ್‌ಮ ಪಹಿಲಿ ಝ಼ಗೋಪರ್‌ ಅಜು಼ ಮಿಝ್‍಼ವಾನೇನಿ ಝ಼ಗೋಮ ಅಛ್ಛಿ ಝ಼ಗೋಪರ್‌ ಬೇಖ್ಹ್‌ಣು ಕರಿ ಖಲಿ ಅಮ್ನಿಸ್ ಅಖ್ಹ್‌ ಕರಾವಾಳು ಹುಯಿರ‍್ಹುಸ್. ");
INSERT INTO vaa_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","ಅವ್ಣೆ ಮುಂಡಚ್ಚಿ ತಯೇಡಾವ್‌ನ ಘರ್‌ನ ಲೂಟಿನ್, ವತಾಳಿಲ್ಯಾವನಖ್ಹಾಜೆ ದೇವ್ನ ಲಾಂಬಿ ಪ್ರಾರ್ಥನೆ ಕರಾಸ್. ಅಥ್ರಾವ್ನ ಘಣಿ ನಿಶತ್‌ ಮಳ್‍ಶೆ!” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","ಯೇಸುನೆ ಮುಡ್‌ಕ್ಯು ಪಾಡೀನ್, ಶೌಕರ್‌ ಅದ್ಮಿಖ್ಹಾರು ಮಂದಿರ್‌ನಿ ಹುಂಡಿಮ ಕಾಣ್ಕೆ ನಾಖುಕರಾತೆ ಇನ ದೇಖ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","ಅಜು಼ ಏಕ್‌ ಗರೀಬ್ ಮುಂಡಚ್ಚಿ ತಯೇಡ ಐನ್, ಬೇ ನ್ಹಾನು ತಾಂಬಾನು ಕಾಖ್ಹ್‌ ನಾಖಿತೆ ಇನಾಬಿ ಇನೆ ದೇಖ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","“ಮೇ ತುಮೂನ ಖ್ಹಾಚ ಬೋಲುಸ್ಕಿ, ಆ ಗರೀಬ್ ಮುಂಡಚ್ಚಿ ತಯೇಡಾನೆ ಬಿಜಾ಼ಖ್ಹಾರೇಥಿ ಜಾ಼ಖ್ಹತ್ ನಾಖಿರಾಖಿಸ್‌. ");
INSERT INTO vaa_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","ಕಿಮ್‌ಕತೊ, ಬಿಜಾ಼ಖ್ಹಾರ ಅದ್ಮಿನೆಇವ್ಣುನ ಬಶ್‌ಹುಯಿನ್ ಉಭ್‌ರ‍್ಯುತೆ ಇನಾಮಾಥು ಕಾಣ್ಕೆನ ದಿದು; ಕತೋಬಿ ಆ ಎತ್ರೆ ಗರೀಬ್ ರ‍್ಹೀನ್‌ಬಿ, ಇನಾಕನ ಥೂತೆ ಜಿವ್ಣನ ನಾಖಿದಿದಿ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","ಶಿಷ್ಯರ್‌ಮ ಥೋಡು ಜ಼ಣು ಮಂದಿರ್‌ನಿ ಬಾರೇಮ, ಆ ಕೆತ್ರೆ ಖ್ಹಾಜ಼್‌ನ ಬಂಡಾವ್‍ಥಿ ಅಜು಼ ದೇವ್ನ ಕಾಣ್‌ಕೆ ದಿದೂತೆ ರಾಛ಼ವ್‍ಥಿ ಕೆತ್ರೆಕ್‌ ಅಛ್ಛು಼ ದೆಖವ್‍ಕರಾಸ್” ಕರಿ ಬೋಲಿಲಿದು. ");
INSERT INTO vaa_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","ತದೆ ಯೇಸುನೆ ಇವ್ಣುನ, “ತುಮೆ ಆ ಖ್ಹಾರು ದೇಖುಕರಾಸ್‌ನಿ, ಏಕ್‌ ದನ್ ಆವ್‌ಶೆ, ಯೋ ದನ್ಮ ಹಜ್ಜಾ಼ ಏಕ್‌ ಬಂಡಾಪರ್ ಬಿಜ್ಜೇಕ್‌ ಬಂಡೊ ಭೀರಿಶೆ ಕೊಯ್ನಿ; ಅಖ್ಖಾಸ್ನ ರಡ್‌ಕೈನಾಖಿದಿಶೆ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","ಇವ್ಣೆ ಯೇಸುನ, “ಗುರು, ಆ ಖ್ಹಾರು ಕದೆ ಉಶೆ? ಆ ಖ್ಹಾರು ಚಾ಼ಲಾನಿವಖ್ಹ್‌ತೆ ಖಿವಿ ಖ್ಹಣೇದ್ ಉಶೆ? ಕರಿ ಬೋಲಖ್ಹತರ್, ");
INSERT INTO vaa_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","ಯೇಸುನೆ ಇವ್ಣುನ, “ಜ಼ತನ್‌ಥಿ ರ‍್ಹವೊ! ತುಮೂನ ಕೋಣ್‌ಬಿ ಠಗಾವ್ಣುನಾತೆ ಇಮ್‌ ದೇಖಿಲೇವೊ. ಶನಕತೊ, ಕೈಯೆಕ್ಕಿ ಜ಼ಣು ಐನ್, ಮಾರು ನಾಮ್‌ಲೀನ್, ‘ಮೇಸ್ ಕ್ರಿಸ್ತ, ಮೇಸ್ ಕ್ರಿಸ್ತ’ ಕರಿ ಅಜು಼ ಯೋ ವಖ್ಹತ್ ಐಗೈ ಕರಿ ಬೊಲ್‌ಶೆ. ಕತೋಬಿ ಇವ್ಣ ಪೀಠೆ ನಕೊಜಾ಼ಶು. ");
INSERT INTO vaa_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","ಅತ್ರೇಸ್ ಕಾಹೆತೆ ಜಂಗ್ ಭೀಡುಕರಾತೆ ಅಜು಼ ಕಲ್ಹಾಗಟ್‌ ಪಡುಕರಾತೆ ಇನಿ ಬಾರೇಮ ತುಮೆ ಖ್ಹಮ್‌ಜ್ಯಾತೊ, ಡರ್‌ಶು ನಕೊ; ಪಹಿಲೆ ಆ ಖ್ಹಾರು ಚಾ಼ಲಾನು ಜ಼ರೂರತ್ ಛಾ಼. ತೋಬಿ ತದ್‌ನು-ತದ್ದೇಸ್ ಅಂತ್‌ ಕೋ ಆವ್‌ಶೇನಿ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","ಅಜೂ಼ಬಿ ಯೇಸುನೆ ಇವ್ಣುನ ಬೋಲ್ಯೊಕಿ, “ದೇಖ್ಹ್‌ನ ವಿರೋದ್ ದೇಖ್ಹ್‌, ರಾಜ್ಯನ ವಿರೋದ್ ರಾಜ್ಯ ಉಟ್‌ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","ಜ಼ಮೀನ್ ಹಲ್‌ಶೆ, ಹರೇಕ್ ಬಾಜು಼ಮ ಕಾಳ್ದುಕಾಳ್‌ಬಿ ಅಜು಼ ಪಿಳಾಕ್‌ನೊ ರೋಗ್‌ ಖ್ಹಾರು ಆವ್‌ಶೆ; ಆಬ್‍ಮ ಘಣು ಖ್ಹಣೇದ್ ಆಬ್‍ಮ ಮಾಲುಮ್‍ಪಡ್‍ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","ಕತೋಬಿ ಆ ಖ್ಹಾರು ಚಾ಼ಲಾನ ಅಗಾಡಿ, ಇವ್ಣೆ ತುಮೂನ ಧರೀನ್, ಖ್ಹತಾವ್‌ಶೆ; ತುಮೂನ ಸಬೆ ಭರಾವನು ಮಂದಿರ್‌ಮ ಜೇಲ್‌ನ ಅದಿಕಾರಿನ ದೀನ್ ಮಾರ ನಾಮ್ನಖ್ಹಾಜೆ, ರಾಜಾ಼ವ್‌ನ ಖ್ಹಾಮ್ಣೆ ಅಜು಼ ರಾಜ಼್‌ಭಾರ್ ಚ಼ಲಾವವಾಳಾನ ಖ್ಹಾಮ್ಣೆ ತುಮೂನ ಭೀರಾಕ್‌ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","ಅನೇಥಿ ಸಾಕ್ಷಿ ಬೋಲಾನ ತುಮೂನ ನಿರ‍್ವಾಳು ಉಶೆ. ");
INSERT INTO vaa_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","ಯೋ ವಖ್ಹತ್‌ಮ, ತುಮೆ ಶಾತ್‌ ಜವಾಬ್‌ ದೇವ್ಣುಕರಿ ಬೋಲಾನಿ ಬಾರೇಮ, ಪಹಿಲೆಸ್ ಕೊ ಸೊಚ಼್‌ಶೂನಿ ಕರಿ ತುಮಾರು ದಿಲ್‌ ಘಟ್ ಕರಿಲೆವೊ. ");
INSERT INTO vaa_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","ಶನಕತೊ ತುಮಾರು ದುಶ್‌ಮನ್‌ ಖ್ಹಾರು, ತುಮಾರ ವಿರೋದ್ ಭೀರ‍ವಾನ ಅಜು಼ ವಾತೆ ಫರೈನ್ ಬೋಲಾನ ಕೋ ಹುವ್ವಾನಿತೆ ಇಮ್ನಿ ವಾತೆ, ಅಜು಼ ಗ್ಯಾನ್ನ ಮೇ ತುಮೂನ ದಿಶ್. ");
INSERT INTO vaa_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","ತುಮಾರ ಆಯ-ಬಾ, ಭೈಯೇ ಮಾಯ-ಮಾತ್ರ ಅಜು಼ ದೋಸ್ತಸ್‌ ತುಮೂನ ಧರಿನ್ ದಿಶೆ. ಅಜು಼ ತುಮಾರಾಮ ಥೋಡು ಜ಼ಣಾನ ಮರ್‌ನಾಖಿದಿಶೆ. ");
INSERT INTO vaa_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","ಅತ್ರೇಸ್ ಕಾಹೆತೆ ಮಾರನಾಮ್ನಖ್ಹಾಜೆ ಹರೇಕ್ ಜ಼ಣು ತುಮೂನ ದಾವೊ ಕರ್ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","ತೋಬಿ, ತುಮಾರೊ ಮುಡ್‌ಕ್ಯಾನೊ ಏಕ್‌ ಕೇಖ್ಹ್‌ಬಿ ಲುಕ್‌ಶಾನ್ ಕೋ ಉಶೇನಿ. ");
INSERT INTO vaa_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","ತುಮೆ ಖ್ಹಮಾಳಿನ್ ಭೀರ‍್ಯಾತೊ, ತುಮಾರೊ ಜಾನ್ನ ತುಮೆ ಬಚಾ಼ಡಿಲಿಶು. ");
INSERT INTO vaa_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“ದಂಡ್‌-ದಳವಾಯಿಖ್ಹಾರು ಯೆರೂಸಲೇಮ್‌ ಖ್ಹಯೇರ‍್ನ ಘೇರಿಲಿದುತೆ ತುಮೆ ದೇಖ್ಯಾತೊ, ಯೋ ಒಗ್ಗಿಸ್‌ಮ ಬರ್ಬಾತ್ ಹುವಾನು ಹಗಾಮ್‌ ಖನ್ನೆಆಯಿಗುಕರಿ ತುಮೆ ಮಾಲುಮ್‌ ಕರಿಲಿಶು. ");
INSERT INTO vaa_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","ತದೆ ಯೂದಾಯಮ ರ‍್ಹವಾಳು ಪಹಾಡ್‌ಕನ ಮಿಲೈನ್‌ ಜಾ಼ವಾದೆ; ಯೋ ಖ್ಹಯೇರ್‌ಮ ರ‍್ಹವಾಳು ಇನ ಮ್ಹೆಂದಿನ್ ಚ಼ಲ್ಯುಜಾ಼ಣು ಅಜು಼ ಗಾಮ್ಮ ರ‍್ಹವಾಳು, ಯೋ ಖ್ಹಯೇರ‍್ನ ಮಹಿ ನಕೊಜಾ಼ವಾದೆ. ");
INSERT INTO vaa_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","ಶನಕತೊ ಲೀಖೈರ‍್ಹೂತೆ ಖ್ಹಾರು ಚಾ಼ಲಾನಖ್ಹಾಜೆ, ಯೋ ದನ್ ಖ್ಹಾರು ನಿಶತ್‌ನೊ ದನ್ ಹುಯಿರ‍್ಹಿಶೆ. ");
INSERT INTO vaa_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","ಯೋ ದನ್ಮ, ಬೇಜೂನಿ ತಯೇಡ ಅಜು಼ ದೂದ್ ಪಿಡಾವವಾಳಿ ತಯೇಡಾನಿ ಹಾಲ್ನ ಶಾತ್ ಬೋಲು! ಆ ತಬರ್‌ಖಾಪರ್ ಘಣಿ ಮೋಟಿ ವದೇಖ್ಹ್‌ ಆವ್‌ಶೆ ಅಜು಼ ದೇವ್ನೊ ಇರಾದೊ ಆ ಅದ್ಮಿ ಖ್ಹಾರಾಪರ್ ಆವ್‌ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","ಅವ್ಣಾಮ ಥೋಡ ಜ಼ಣಾನ ತಲ್ವಾರ್‌ಥಿ ಮಾರಿನಾಕ್‌ಶೆ, ಅಜು಼ ಬಿಜಾ಼ವ್ನ ಪರೈ ದೇಖ್ಹ್‌ವಾಳು ಖ್ಹಾರು ಧರೀನ್ ಲೀಜಾ಼ಶೆ. ಪರೈ ದೇಖ್ಹ್‌ವಾಳನು ದನ್‌ಖ್ಹಾರು ಪೂರ ಹುವ್ವಾತೋಡಿ, ಯೆರೂಸಲೇಮ್ ಇವ್ಣೇಥಿ ಖುಂದ್ಲಾವ್ತುಫಂಡ್‌ಷೆ. ");
INSERT INTO vaa_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","ಚಾ಼ಂದ್, ಚ಼ಂದರ್‌ಮೊ ಅಜು಼ ಶುಕ್ಕರ್‌ಮ ಖ್ಹಾರು ಖ್ಹಣೇದ್‍ನು ಕಾಮ್ ಮಾಲುಮ್ ಪಡ್‌ಶೆ. ಜ಼ಮೀನ್‌ಪರ್ ದರ‍್ಯಾವ್‍ನೊ ಅಜು಼ ಝೋ಼ಕಾಳ್ಯನು ಅವಾಜ಼್‌ಥಿ ಅದ್ಮಿಖ್ಹಾರು ಘಬ್‌ರೈಜಾ಼ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","ಆಬ್‍ನಿ ಶಕತ್ ಖ್ಹಾರಿ ಹಲ್‌ಶೆತೆ ಇನಾಖ್ಹಾಜೆ, ಅದ್ಮಿಖ್ಹಾರು ಡರ್‌ಥಿ, ‘ಆ ಜಗತ್‌ ಶಾತ್‌ ಹುವಾನ ಆಯು!’ ಕರಿ ಬೋಲಿನ್ ಘಬ್‌ರೈಜಾ಼ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","ತದೆ ಅದ್ಮಿನೊ ಛಿಯ್ಯೊ ಘಣಿ ಶಕತ್‌ಥೀಬಿ, ಮಹಾನ್ ಮಹಿಮೆಥೀಬಿ, ವಾದ್ಳಪರ್ ಆವ್‌ಶೇತೆ ಇವ್ಣೆ ದೇಕ್‌ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","ಆ ಖ್ಹಾರು ಚಾ಼ಲಾನಿ ವಖ್ಹತ್‌ಮ, ಉಠಿ ಭೀರ‍್ಹೆವೊ, ಅಜು಼ ಮುಡ್‌ಕ್ಯು ಪಾಡಿನ್ ಉಪ್ಪರ್‌ದೇಖೊ, ಶನಕತೊ ತುಮಾರಿ ಛುಟ್ಕಾರ್ ಖನ್ನೆಸ್‌ ಅಯಿರ‍್ಹೀಸ್‍!” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","ಅನ ಬಾದ್‌ಮ ಯೇಸುನೆ ಇವ್ಣುನ ಏಕ್‌ ಮತ್‌ಲಬ್ ಖೇಣಿನ ಬೋಲ್ಯೊ. ಯೋ ಶಾತ್‌ಕತೊ, “ಅಂಜೀರ್‌ನ ಝಾ಼ಡ್‌ಣ ಅಜು಼ ಬಿಜ಼ ಝಾ಼ಡಾವ್‍ನಾಬಿ ದೇಖೊ. ");
INSERT INTO vaa_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","ಯೋ ಚಿಗುರ್‌ತಾಸ್‌ನ ತುಮೆ, ತಡ್ಕಾನ ಹಗಾಮ್‌ ಖನ್ನೆ ಐಗು ಕರಿ ತುಮಾರು ತುಮೇಸ್ ಮಾಲುಮ್‌ ಕರಿಲೇವೊಸ್ನಿ. ");
INSERT INTO vaa_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","ಇಮ್ಮಸ್, ತುಮೆ ಆ ಖ್ಹಾರು ಹುವಾನು ದೇಖಾನಿ ವಖ್ಹತ್‌ಮ, ದೇವ್ನಿ ರಾಜ್ಯ ಖನ್ನೆ ಐಗು ಕರಿ ಮಾಲುಮ್‌ ಕರಿಲೆವೊ. ");
INSERT INTO vaa_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","ಮೇ ತುಮೂನ ಖ್ಹಾಚಮಾಬಿ ಬೋಲುಸ್ಕಿ, ಆ ಹಗಾಮ್ನು ಅದ್ಮಿಖ್ಹಾರು ಬಚಿರ‍್ಹವಾನಿ ವಖ್ಹತ್‌ಮಾಸ್‌, ಆ ಖ್ಹಾರು ಉಶೆ! ");
INSERT INTO vaa_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","ಆಬ್ ಧರ್ತಿ ಮಟಿಜಾ಼ಶೆ, ಕತೋಬಿ ಮಾರಿ ವಾತೆಖ್ಹಾರಿ ಮಟ್‌ಶೆಸ್ ಕೊಯ್ನಿ. ");
INSERT INTO vaa_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“ತುಮಾರಿ ಬಾರೇಮ ಜ಼ತನ್‌ಥಿ ರ‍್ಹವೊ! ಜಾ಼ಖ್ಹತ್ ಖಾವಾಣ್‌ಪಿವಾಣ್ಣಿ ಅಹಂಕಾರ್‌ಥೀಬಿ ಕಯೇಪ್‍ಥೀಬಿ ಜಗತ್ನಿ ಸೋಚ್‍಼ಥೀಬಿ ತುಮಾರು ಮನ್‌ ವಜ಼ನ್‍ಹುಯಿಗಯು. ");
INSERT INTO vaa_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","ಆ ದನ್ ತುಮಾರಉಪ್ಪರ್ ಫಾಖ್ಹಾನಿ ಮತ್‍ ಆವ್‌ಶೆ. ಯೋ ಜ಼ಮೀನ್‌ಪರ್ ಛಾ಼ತೆ ಹರೇಕ್‌ಪರ್ ಆವ್‌ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","ಇನಖ್ಹಾಜೇಸ್, ಖ್ಹಾರಿಸ್ ವಖ್ಹತ್‌ಮ ತೈಯಾರ್ ರ‍್ಹವೊ, ಚಾ಼ಲ್‌ಶೇತೆ ಆ ಖ್ಹಾರಾಮ ಬಚಿನ್, ಅದ್ಮಿನೊ ಛಿಯ್ಯಾನ ಖ್ಹಾಮ್ಣೆ ಭೀರ‍್ಯಾವನ ತುಮೆ ಶಕತ್‌ವಾಳ ಹುವಾನಟೇಕೆ, ಖ್ಹಾರಿಸ್ ವಖ್ಹತ್‌ಮ ದೇವ್ನ ಪ್ರಾರ್ಥನೆ ಕರ್ತಾಹುಯಿನ್ ಜ಼ತನ್‌ಥಿ ರ‍್ಹವೊ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","ಯೇಸು ದನ್ನು ಮಂದಿರ್‌ಮ ವಚನ್ ಬೋಲಿದೇತೋಥೊ ಅಜು಼ ಖ್ಹಾಂಜ಼್‌ನು ಆಲಿವ್‌ನು ಪಹಾಡ್‌ಕನ ಜೈ಼ನ್‌ ರಾತ್‌ ಅಖ್ಖು ಹಿಜ್ಜಾ಼ಸ್ ರ‍್ಹೇತೊಥೊ. ");
INSERT INTO vaa_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","ಅದ್ಮಿಖ್ಹಾರು ಇನಿ ವಚನ್ನ ಖ್ಹಮ್‌ಜಾ಼ನ ಟೇಕೆ, ದನ್‍ರೋಜ಼್ ಅಧಿರ‍್ಹೇಣೆಸ್‌ ಉಠೀನ್, ಮಂದಿರ್‌ಮ ಇನಾಕನ ಆವ್‌ತೂಥು. ");
INSERT INTO vaa_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","ಖಾಟುಕೊಂತೆ ರೋಟಾನಿ ಪೂಜಾ಼, ಕತೊ ಪಸ್ಕ ಪೂಜಾ಼ನೊ ದನ್ ಖನ್ನೆ ಐಗೋಥೊ. ");
INSERT INTO vaa_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","ಮಹಾಯಾಜಕ, ಅಜು಼ ಮೋಶೇನು ಧರ್ಮಶಾಸ್ತ್ರ ಶಿಕಾಡವಾಳು ಶಾಸ್ತ್ರಿಯೆ ಯೇಸುನ ಮರಾವ್ಣು ಕರಿ ಸೋಚಿನ್, ಅದ್ಮಿನ ಡರ್‌ಥಿ ಬರಾಬರ್‌ನಿ ವಖ್ಹತ್‌ನಖ್ಹಾಜೆ ಜ಼ಪಿರ‍್ಹೂಥು. ");
INSERT INTO vaa_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","ತದೆ ಶೈತಾನ್ ಭಾರ ಜ಼ಣ ಶಿಷ್ಯರ್‌ಮ ಏಕ್‌ ಜ಼ಣೊ ಹುಯಿರ‍್ಹೋತೆ, ಇಸ್ಕರಿಯೋತ ಯೂದಮ ಪೇಶಿಗಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","ತದೆ ಯೂದಾನೆ, ಮಹಾಯಾಜಕ ಅಜು಼ ಮಂದಿರ್‌ನ ವಖ್ಹ್‌ತಿ ಕರವಾಳಾವ್‌ಕನ ಜೈ಼ನ್‌, ಯೋ ಯೇಸುನ ಧೋಕೇಥಿ ಧರಿದ್ಯವಾನಿ ಬಾರೇಮ ಇವ್ಣ ಜೋ಼ಡೆ ವಾತೆ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","ತದೆ ಇವ್ಣೆ ಖ್ಹುಶಿಖೈನ್‌, “ತುನ ಪೈಶಾ ದಿಯ್ಯೆಸ್‌” ಕರಿ ವಾತೆದಿದು. ");
INSERT INTO vaa_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","ಇನೆ ಮಾನಿಜೈ಼ನ್, ಅದ್ಮಿನಿ ಗಲಾಟ್‌ಕೊಂತೆ ವೇಳ್ಮ, ಯೇಸುನ ಇವ್ಣುನ ಧರಿದೇಣುಕರಿ, ಬರೋಬರ್‌ನಿ ವಖ್ಹತ್‌ನಖ್ಹಾಜೆ ಜ಼ಪೀನ್ ದೇಖುಕರ್ತೊಥೊ.‌ ");
INSERT INTO vaa_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","ಖಾಟುಕೊಂತೆ ರೋಟಾನು ಪೂಜಾ಼ನೊ ದನ್ ಆಯು. ಯೋ ದನ್‌ಮ ಯೆಹೂದ್ಯರ್ ಅದ್ಮಿಖ್ಹಾರು ಪಸ್ಕನ ಖಾಣನಖ್ಹಾಜೆ ಮೇಂಢು ರೇಖ್ಹ್‌ತೂಥು. ");
INSERT INTO vaa_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","ಯೇಸುನೆ ಪೇತ್ರ ಅಜು಼ ಯೋಹಾನ್ನ, “ತುಮೆ ಜೈ಼ನ್‌, ಅಪ್ಣಖ್ಹಾಜೆ ಪಸ್ಕಾನು ಖಾಣನ ಖ್ಹವಾರೊ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","ಇವ್ಣೆ ಇನ, “ಹಮೆ ಕಿಜ಼್ಜಾ ಜೈ಼ನ್‌, ಖ್ಹವಾರ್‌ನು” ಕರಿ ಪುಛಾ಼ಯ? ");
INSERT INTO vaa_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","ತದೆ ಯೇಸುನೆ ಇವ್ಣುನ, “ಹಂದೇಖೊ, ತುಮೆ ಖ್ಹಯೇರ‍್ನ ಮಹಿ ಜಾ಼ತಸ್‌ನ, ಏಕ್‌ ಅದ್ಮಿ ಪಾಣಿನೊ ಘಡೊ ಪಳ್ಳಿನ್‌, ತುಮಾರ ಖ್ಹಾಮ್ಣೆ ಆವ್‌ಶೇತೆ ದೇಕ್‌ಶು. ಇನ ಪೀಠೇಸ್ ಜೈ಼ನ್, ಯೋ ಜಾ಼ಶೇತೆ ಘರ್‌ಮ ಜಾ಼ವೊ. ");
INSERT INTO vaa_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","ಅಜು಼ ಯೋ ಘರ್‌ನ ಯಜಮಾನ್ನ, “ಹಮಾರೊ ಗುರು, ಇನ ಶಿಷ್ಯರ್‌ನ ಜೋ಼ಡೆ ಪಸ್ಕಾನು ಖಾಣು ಖಾವಾನಖ್ಹಾಜೆ, ಕೋಣೊ ಕಿಜ಼್ಜಾ ಛಾ಼, ಕರಿ ತುನ ಫುಛಾ಼ಯೊ ಕರಿ ಬೋಲೊ. ");
INSERT INTO vaa_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","ಯೊ ತುಮುನ ಖ್ಹಾರೂಸ್ ಕುಡ್‌ಶಿ ಪಲಂಗ್‌ಥಿ ಖ್ಹವಾರೈರ‍್ಹಿಶೇತೆ, ಛ಼ತ್‍ನ ಉಪ್ಪರ್‌ಲ್ಯೊ ಮೋಟ ಕೋಣಾನ ವತಾಳ್‌ಶೆ, ಹಿಜ಼್ಜಾ ಖಾಣನ ಖ್ಹವಾರೊ” ಕರಿ ಬೋಲಿನ್ ಮೋಕ್‌ಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","ಇವ್ಣೆ ಜೈ಼ನ್‌, ಯೇಸುನೆ ಇವ್ಣುನ ಬೋಲ್ಯೊತೆ ಇಮ್ಮಸ್ ಥೂತೆ ದೇಖಿನ್, ಪಸ್ಕಾನ ಖಾಣನ ತೈಯಾರ್ ಕರ‍್ಯು. ");
INSERT INTO vaa_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","ವಖ್ಹತ್ ಆವಾದಿನ್, ಯೇಸು ಇನ ಭಾರ ಅಪೊಸ್ತಲರ‍್ನ ಜೋ಼ಡೆ ಖಾಣನ ಬೇಶಿಗಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","ತದೆ ಯೇಸುನೆ ಇವ್ಣುನ, “ಮೇ ಖ್ಹತಾಪ್ಣಿ ಖಾವಾನ ಅಗಾಡಿ, ತುಮಾರ ಜೋ಼ಡೆ ಆ ಪಸ್ಕಾನು ಖಾಣು ಖಾಣುಕರಿ ಘಣು ಆಖ್ಹ್ ಕರ‍್ಯೋಥೊ. ");
INSERT INTO vaa_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","ಮೇ ತುಮೂನ ಬೋಲುಸ್ಕಿ, ದೇವ್ನಿ ರಾಜ್ಯಮ ಅನಿ ಖ್ಹಾಚಿ ಮತ್‌ಲಬ್ ಪೂರ ಹುವ್ವಾತೋಡಿ, ಮೇ ಪಸ್ಕಾನು ಖಾಣನ ಪಾಛು಼ ಖೈಶಸ್‌ ಕೊಯ್ನಿ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","ಅನ ಬಾದ್‌ಮ ಯೇಸುನೆ, ದ್ರಾಕ್ಷಿನು ರಖ್ಹ್‌ನಿ ಕಟೋರಿನ ಪಾಡಿನ್, ದೇವ್ನ ಧನ್ಯವಾದ್‌ಕರೀನ್‌, ಅಲ್ಲೇವೊ, ಅನ ತುಮಾರಾಮ ವಾಟ ಪಾಡಿಲೆವೊ. ");
INSERT INTO vaa_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","ಹಂಕೇಥು ಧರೀನ್ ದೇವ್ನಿ ರಾಜ್ಯ ಆವಾತೋಡಿ, ಮೇ ಫಾಛು಼ ಆ ದ್ರಾಕ್ಷಿನು ರಖ್ಹ್‌ನ ಪೀಶಸ್ ಕೊಯ್ನಿ ಕರಿ ತುಮುನ ಬೋಲುಸ್” ಕರಿ ಬೋಲ್ಯೊ ");
INSERT INTO vaa_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","ಇನ ಬಾದ್‌ಮ ಯೇಸುನೆ ರೋಟಾನ ಪಾಡೀನ್, ದೇವ್ನ ಧನ್ಯವಾದ್‌ ಕರೀನ್, ಇನ ತೋಡಿನ್, ಇವ್ಣುನ ದೀನ್, “ಆ ತುಮಾರಖ್ಹಾಜೆ ದೆವೈರ‍್ಹೂತೆ ಮಾರಿ ಶರೀರ್, ಮನ ಯಾದ್‌ಕರಾನಖ್ಹಾಜೆ ಅಮ್‌ಕರೊ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","ಇಮ್ಮಸ್ ಖಾಣನ ಬಾದ್‌ಮ, ಯೇಸುನೆ ಕಟೋರಿನ ಪಾಡೀನ್, “ಆ ಕಟೋರಿ ತುಮಾರಖ್ಹಾಜೆ ರಂಚಾ಼ವನು ಮಾರು ಲ್ಹೋಯಿಥಿ ಬಣೈರ‍್ಹುತೆ. ನವಿ ಒಪ್ಪಂದ ಹುಯಿರ‍್ಹೂಸ್, ಅನ ಮಾರ ಲ್ಹೋಯಿಥಿ ಮುದ್ರೊ ಮರೈರ‍್ಹೂಸ್. ");
INSERT INTO vaa_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","“ತೋಬಿ, ಹಂದೇಖೊ! ಮನ ಧೋಕೇಥಿ ಧರಿದ್ಯವಾಳೊ ಮಾರ ಜೋ಼ಡೆಸ್‌ ಖಾಣು ಖವ್‍ಕರಾಸ್‌. ");
INSERT INTO vaa_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","ದೇವ್ನೆ ಸೋಚ್ಯೊತೆ ಇಮ್ಮಸ್, ಅದ್ಮಿನೊ ಛಿಯ್ಯೊ ಮರ್‌ಶೆ; ಕತೋಬಿ ಇನ ಧರಿದ್ಯವಾಳ ಅದ್ಮಿನಿ ಹಾಲ್ನ ಶಾತ್‌ ಬೋಲು! ");
INSERT INTO vaa_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","ಅನ ಖ್ಹಮ್‌ಜಿನ್‌ ಇವ್ಣೆ, “ಇನ ಧೋಕೇಥಿ ಧರಾವಾಳೊ ಅಪ್ಣಾಮ ಕೋಣ್ ಉಶೆ?” ಕರಿ ಇವ್ಣ-ಇವ್ಣಾಸ್‍ಮ ಬೋಲಿಲಿದು. ");
INSERT INTO vaa_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","ಅತ್ರೇಸ್ ಕಾಹೆತೆ, ಖ್ಹಾರೇಥಿ ಮಹಾನ್ ಕೋಣ್? ಕರಿ ಬೋಲೈಲಿಶೆ, ಕರಿ ಶಿಷ್ಯರ್‌ ಇವ್ಣ-ಇವ್ಣಾಮಸ್‌ ವಾತೆಚೀತೆ ಕರಾಲಗ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","ತದೆ ಯೇಸುನೆ ಇವ್ಣುನ, “ಯೆಹೂದ್ಯರ್‌ಕಾಹೆತೆ ರಾಜ಼ಖ್ಹಾರು, ಇವ್ಣ-ಇವ್ಣ ಅದ್ಮಿಪರ್ ರಾಜ಼್‌ಭಾರ್‌ ಚ಼ಲಾವಸ್, ಅಜು಼ ಇವ್ಣಾಪರ್ ಅದಿಕಾರ್ ಚ಼ಲಾವವಾಳು, ‘ಅದ್ಮಿಯೇವ್‌ನು ದೋಸ್ತ್’ ಕರಿ ಬೊಲೈಲೇಸ್. ");
INSERT INTO vaa_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","ಕತೋಬಿ ತುಮಾರಮ ಇಮ್‌ ನಾರ‍್ಹೇವ್ಣು. ತುಮಾರಮ ಮಹಾನ್ ಕರಿ ರ‍್ಹೇಸ್ತೆ ಇವ್ಣೆ ನ್ಹಾನಾವ್‍ನಿ ಮತ್‍ ರ‍್ಹೇವ್ಣು, ಶಾಣು ಕರಿ ರ‍್ಹವಾಳು ಸೇವಕನಿ ಘೋಣಿ ರ‍್ಹೇವ್ಣು. ");
INSERT INTO vaa_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","ಕೋಣ್ ಮಹಾನ್? ಖಾಣು ಖಾವನ ಬೆಠೂತೆ ಯೋಕಿ, ಇನಿ ಚಾ಼ಕ್ರಿ ಕರಾವಾಳೊ? ಖಾವನ ಬೆಠೋಸ್ತೆ ಯೋಸ್ ಕಾಹೆಕಿಶು, ಕತೋಬಿ ಮೇ ತುಮಾರಾಮ ಚಾ಼ಕ್ರಿ ಕರಾವಾಳನಿಘೋಣಿ ಛೂ಼. ");
INSERT INTO vaa_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","ತುಮೆ ಮಾರಿ ಖ್ಹಾರಿ ಖ್ಹತಾಪ್ಣಿಮ, ಮಾರ ಜೋ಼ಡೆ ರ‍್ಹಯಾಹುಯ. ");
INSERT INTO vaa_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","ಮಾರೊ ಬಾ, ಮನ ರಾಜ್ಯನ ಚ಼ಲಾವಾನ ಹಕ್‌ ದಿದೋತೆ ಇಮ್ಮಸ್, ಮೇಬಿ ತುಮೂನ ಅದಿಕಾರ್ ಚ಼ಲಾವಾನ ಹಕ್‌ ದೆವುಸ್‌. ");
INSERT INTO vaa_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","ಮಾರಿ ರಾಜ್ಯಮ ತುಮೆ, ಮಾರಿ ಮೇಜ್‌ಪರ್‌ ಖಾಶುಪೀಶು, ಅಜು಼ ಸಿಂಹಾಸನ್‌ಪರ್ ಬೇಶಿನ್, ಇಸ್ರಾಯೇಲ್‌ನ ಭಾರ ಖೂಮ್‍ವಾಳಪರ್ ಅದಿಕಾರ್ ಚ಼ಲಾವ್‌ಶು. ");
INSERT INTO vaa_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","ಸೀಮೋನ್, ಸಿಮೋನ್! ಹಂದೇಕ್! ಶೈತಾನ್‍ ತುಮೂನ ಘವ್‌ನ ತೂರಾನಿಘೊಣಿ ಹುಕುಮ್‌ನ ಮಾಂಗಿರಾಖ್ಯೊಸ್. ");
INSERT INTO vaa_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","ಕತೋಬಿ ತಾರಿ ವಿಶ್ವಾಸ್ ಕಮ್ ನಾ ಹೋಣುಕರಿ, ಮೇ ತಾರಿ ಬಾರೇಮ ದೇವ್ನ ಪ್ರಾರ್ಥನೆ ಕರಿರಾಖ್ಯೊಸ್ ಸೀಮೋನ್. ಅಜು಼ ತೂ ಮಾರಭಣಿ ಫರಾನ ಬಾದ್‌ಮ, ತಾರ ಭೈಯೇನ ಭಾಲಿ ದೇವ್ಣು” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","ಕತೋಬಿ ಇನೆ ಯೇಸುನ, “ಪ್ರಭು, ಮೇ ತಾರ ಜೋ಼ಡೆ ಜೇಲ್‌ಮ ಜಾ಼ವಾನಾಬಿ ಅಜು಼ ಮರನಾಬಿ ತೈಯಾರ್ ಛೂ಼!” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","ತದೆ ಯೇಸುನೆ ಇನ, “ಪೇತ್ರ, ಆ ರಾತೆ, ತೂ ಮಾರಿ ಬಾರೇಮ, ‘ಆ ಮನ ಮಾಲುಮ್ ಕೊಯ್ನಿ’ ಕರಿ ತೀನ್ ಹಲ್ಲ ಬೋಲಾತೋಡಿ, ಮುರ್‌ಗೊ ಬಾಂಗ್‌ ದಿಶೆ ಕೊಯ್ನಿ, ಕರಿ ಮೇ ತುನ ಬೋಲುಸ್” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","ಅಜು಼ ಯೇಸುನೆ ಇನ ಶಿಷ್ಯರ್‌ನ, “ಮೇ ತುಮೂನ ಚ಼ಂಚಿ, ಬಟ್‌ವೊ ನತರ್‌ಕಿ ಖೋಖ್ಹ್‌ಡಾ ಕೊಯ್ನಿತೆ ಮೋಕ್‌ಲ್ಯೊಥೋತೆ ತದೆ, ತುಮೂನ ಶಾತ್‌ತೋಬಿ ಕಮ್ ಹುಯುಕಿ ಶು? ಕರಿ ಪುಛಾ಼ವಖ್ಹತರ್, ಇವ್ಣೆ, “ಶಾತ್ಬಿ ಕೊಯ್ನಿ” ಕರಿ ಜವಾಬ್‌ ದಿದು. ");
INSERT INTO vaa_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","ತದೆ ಯೇಸುನೆ ಇವ್ಣುನ, “ಕತೋಬಿ ಹಮ್ಕೆ, ಕಿನ-ಕಿನಾಕನ ಚ಼ಂಚಿ ನತರ್‌ಕಿ ಬಟ್‌ವೊ ಛಾ಼ಕಿ ಇನ ಪಾಡಿಲೆವೊ; ಅಜು಼ ಕಿನಾಕನ ತಲ್ವಾರ್‌ ಕೊಯ್ನಿಕಿ ಇವ್ಣೆ, ಇವ್ಣು ಹೋಡ್‍ಣಿನ ವೇಚಿನ್, ಏಕ್‌ ತಲ್ವಾರ್‌ನ ಲೀಲೆವ್ಣು. ");
INSERT INTO vaa_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","ಶನಕತೊ, ಪ್ರವಾದಿಖ್ಹಾರು ಮಾರಿ ಬಾರೇಮ ಲೀಖೈರ‍್ಹೂತೆ ಇಮ್‌, ಅಪರಾದಿಮ ಏಕ್‌ ಜ಼ಣಾನಿಮತ್ ಮನ ಸೋಚ್ಯು, ಕರಿ ಬೋಲಾನು ಚಾ಼ಲ್ನುತೆ, ಇನಖ್ಹಾಜೆ ಯೋ ಪೂರ ಹುವಾನ ಆಯು.‌ ");
INSERT INTO vaa_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","ಶಿಷ್ಯರ್‌ನೆ ಇನ, “ಪ್ರಭು, ಹಂದೇಕ್‌! ಹಜ್ಜಾ಼ ಬೇ ತಲ್ವಾರ್‌ ಛಾ಼” ಕರಿ ಬೋಲ್ಯು, ತದೆ ಯೇಸುನೆ, “ಎತ್ರು ಬಶ್‌” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","ಯೇಸು ಯೆರೂಸಲೇಮ್‌ನ ಮ್ಹೇಲಿನ್, ಯೋ ಜಾ಼ತೊಥೋತೆ ಇಮ್ಮಸ್, ಆಲಿವ್ ಪಹಾಡ್‌ನ ಗಯೊ, ಶಿಷ್ಯರ್‌ಬಿ ಇನ ಕೇಡೆ ಗಯ. ");
INSERT INTO vaa_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","ಯೋ ಝ಼ಗೋಪರ್‌ ಆವಾದಿನ್, ಯೇಸುನೆ ಇವ್ಣುನ, “ತುಮೆ ಶೋದನೆಮ ಪಡ್ನುನಾತೆ ಇಮ್‌, ಪ್ರಾರ್ಥನೆ ಕರೊ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","ಅನ ಬಾದ್‌ಮ ಯೇಸು ಇವ್ಣುನ ಮ್ಹೆಂದಿನ್, ಬಂಡೊ ಫೇಕಎವ್ಡಿ ದೂರ್ ಜೈ಼ನ್, ಗುಡ್‍ಘ್ಯ ಟೇಕಿನ್ ಪ್ರಾರ್ಥನೆ ಕರ‍್ಯೊ, ");
INSERT INTO vaa_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“ಬಾ, ತಾರಿ ಮರ್ಜಿ ಉಶೇತೊ, ಆ ಖ್ಹತಾಪ್ಣಿನಿ ಕಟೋರಿನ, ಮಾರೇಥಿ ದೂರ್ ಹಟಾವ್‌; ತೋಬಿ, ಮಾರಿ ಮರ್ಜಿ ಕಾಹೆ, ತಾರಿ ಮರ್ಜಿಸ್‌ ಹುವಾದೆ” ಕರಿ ಬೋಲಿನ್ ಪ್ರಾರ್ಥನೆ ಕರ‍್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","ತದೆ ಪರಲೋಕ್‌ಥೊ ಏಕ್‌ ಧೂತ ಐನ್, ಯೇಸುನ ದೆಖೈನ್, ಇನ ಭಾಲಿ ದಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","ಯೋ ಘಣಿ ದುಖ್‌ಥಿ ಬಿಜೂ಼ಬಿ ಪ್ರಾರ್ಥನೆ ಕರುಕರಾನಿ ವಖ್ಹತ್‌ಮ, ಇನು ಪಶುನೊ ಲ್ಹೋಯಿನು ಬೂಂದಾವ್‍ನಿಮತ್‌ ಜ಼ಮೀನ್‌ಪರ್ ಪಡ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","ಪ್ರಾರ್ಥನೆಮಾಥು ಯೇಸು ಉಠೀನ್, ಪಾಛು಼ಫರಿ ಇನ ಶಿಷ್ಯರ್‌ಕನ ಆಯಿನ್, ದುಖ್‌ಥಿ ಭರೈನ್, ಇವ್ಣೆ ಖ್ಹುತೂಥೂತೆ ದೇಖಿನ್‌, ");
INSERT INTO vaa_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","ಯೇಸುನೆ ಇವ್ಣುನ, “ತುಮೆ ಶನ ಖ್ಹುತಾಸ್? ಉಪ್ಪರ್ ಉಠೊ, ಅಜು಼ ತುಮೆ ಶೋದನೆಮ ಪಡ್ನುನಾತೆ ಇಮ್‌ ಪ್ರಾರ್ಥನೆ ಕರೊ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","ಯೇಸು ವಾತೆ ಬೋಲುಕರಾನಿ ವಖ್ಹತ್‌ಮಾಸ್‌, ಅದ್ಮಿನಿ ಏಕ್‌ ಭೀಡ್ ಹಿಜ್ಜಾ಼ ಆಯಿ. ಭಾರಜ಼ಣ ಶಿಷ್ಯರ್‌ಮ ಏಕ್‌ ಜ಼ಣೊ ಹುಯಿರ‍್ಹೊಥೋತೆ ಯೂದ, ಇವ್ಣ ಖ್ಹಾಮ್ಣೆ-ಖ್ಹಾಮ್ಣೆ ಚಾ಼ಲ್ತೊ ಉಳ್ಯಾವ್ತೋಥೊ. ಯೋ ಯೇಸುನ ಬುಚ್ಚಾ಼ ದ್ಯವಾನಖ್ಹಾಜೆ ಖನ್ನೆ ಆಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","ತದೆ ಯೇಸುನೆ ಇನ, “ಯೂದ, ಬುಚ್ಚಾ಼ದೀನ್‌, ಧೋಕೇಥಿ ಅದ್ಮಿನೊ ಛಿಯ್ಯಾನ ಧರಿದ್ಯವಾನ ಆಯೋಕಿ ಶು?” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","ಯೇಸುನ ಜೋ಼ಡ್ಮ ಥಾತೆ ಶಿಷ್ಯರ್‌ಖ್ಹಾರು ಚಾ಼ಲ್‌ಶೆತೆ ಇನ ದೇಖಿನ್‌, ಯೇಸುನ, “ಪ್ರಭು, ಹಮೆ ಹಮಾರು ತಲ್ವಾರ್‌ಥಿ ಮಾರಿಯೇಕಿ ಶು?” ಕರಿ ಪುಛಾ಼ಯು. ");
INSERT INTO vaa_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","ಅವ್ಣಾಮ ಏಕ್‌ ಜ಼ಣೊ, ತಲ್ವಾರ್‌ಥಿ ಮಾರಿನ್, ಗಲ್‌ಢಯಾಜಕ್‌ನ ಆಳ್‌ನ ಖಾವಿ ಬಾಜು಼ನ ಕಾನ್ನ ಕತ್ರಿನಾಖ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","ಕತೋಬಿ ಯೇಸುನೆ ಇನ, “ಅತ್ರೇಸ್ ಬಶ್‌!” ಕರಿ ಬೋಲಿನ್, ಯೋ ಆಳ್‌ನು ಕಾನ್ನ ಛೀಮಿನ್‌, ಇನ ಅಛ್ಛು಼ ಕರ‍್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","ಬಾದ್‌ಮ ಯೇಸುನೆ ಇನ ಧರಾನ ಆಯೂತೆ, ಮಹಾಯಾಜಕನ, ಮಂದಿರ್‌ನ ಕಾವ್ಲಿ ಕರಾವಾಳ ದಂಡ್‌ ದಳ್‌ವಾಯಿನ ಅಜು಼ ಸಭೆನ ಶಾಣಾವ್‍ನಾಬಿ, “ಚೋ಼ರ್‌ನ ಧರಾನಿಘೋಣಿ,ತಲ್ವಾರೆ, ಲಠ್ಠ ಪಳ್ಳಿನ್‌ ಮನ ಧರಾನ ಆಯಾಕಿ ಶು? ");
INSERT INTO vaa_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","ಮೇ ದನ್‍ರೋಜ಼್ ದೇವ್ನಿ ಮಂದಿರ್‌ಮ ತುಮಾರ ಜೋ಼ಡೆ ಥೋತೆ ತದೆ, ತುಮೆ ಮನ ಧರ‍್ಯಾಕೊಯ್ನಿ. ಕತೋಬಿ ಆ ತುಮಾರಿ ವಖ್ಹತ್, ಅಂಧಾರನಿ ಶಕತ್ನ ಅದಿಕಾರ್ ಕರಾನಿ ವಖ್ಹತ್” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","ಇವ್ಣೆ ಯೇಸುನ ಧರೀನ್, ಗಲ್‌ಢಯಾಜಕ್‌ನ ಘರ್‌ನ ಮಹಿ ಲೀಗಯು. ಅಜು಼ ಪೇತ್ರ ದೂರ್‌ಥೊ ಇವ್ಣ ಪೀಠೆ-ಪೀಠೆ ಗಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","ಖ್ಹಾಮ್ಣೆನಿಝ಼ಗೋನ, ಇಚ಼್‌ಮ ಆಗ್ ಲಗಾಡಿನ್, ಇನ ಅಶ್‌ಪಿಶ್‌ ಬೆಠುಥೂತೆ, ಅದ್ಮಿನ ಜೋ಼ಡೆ ಪೇತ್ರಬಿ ಬೇಶಿಗಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","ಪೇತ್ರ ಹಿಜ್ಜಾ಼ ಉಜಾ಼ಳಾಮ ಬೆಠಿತೆ, ಏಕ್‌ ಜ಼ಣಿ ಆಳ್‌ನೆ ಠರ್‌ಖೈ ದೇಖಿನ್‌, “ಆಬಿ ಯೇಸುನ ಜೋ಼ಡೆ ಥೊ!” ಕರಿ ಬೋಲಿ. ");
INSERT INTO vaa_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","ಕತೋಬಿ ಪೇತ್ರನೆ, “ಮನ ಯೋ ಮಾಲುಮಸ್ ಕೊಯ್ನಿಲಿ, ಬಾಯಿ!” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","ಜ಼ರ ಘಡಿನ ಬಾದ್‌ಮ, ಏಕ್‌ ಜ಼ಣಾನೆ ಪೇತ್ರನ ದೇಖಿನ್‌, “ತೂಬಿ ಇವ್ಣಾಮ ಏಕ್‌ ಜ಼ಣೊ ಹುಯಿರ‍್ಹೋಸ್” ಕರಿ ಬೋಲ್ಯು. ಕತೋಬಿ ಪೇತ್ರನೆ “ಮೇ ಕಾಹೇಲ ಬಾಬ!” ಕರಿ ಜವಾಬ್‌ ದಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","ಅಜು಼ ಏಕ್‌ ಘಂಟಾನ ವಖ್ಹತ್‌ಮ, ಅಜೇಕ್‌ ಜ಼ಣಾನೆ, “ಖ್ಹಾಚಮಾಬಿ ಆಬಿ ಯೇಸುನ ಜೋ಼ಡೆ ರ‍್ಹಯೊಹುಯೊ, ಶನಕತೊ ಆಬಿ ಗಲಿಲಾಯವಾಳೊಸ್‌ನಿ!” ");
INSERT INTO vaa_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","ಕತೋಬಿ ಪೇತ್ರನೆ, “ತೂ ಶಾತ್‌ ಬೋಲುಕರಾಸ್ತೆಕಿ ಮನ ಮಾಲುಮ್‌ ಕೊಯ್ನಿ?” ಕರಿ ಜ಼ವಾಬ್‌ದಿದೊ. ಯೋ ಬೋಲುಕರಾತೆ ವಖ್ಹತ್‌ಮಾಸ್‌, ಮುರ್‌ಗೊ ಬಾಂಗ್‌ ದಿದು. ");
INSERT INTO vaa_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","ಪ್ರಭುನೆ ಪೀಠೆ ಫರಿನ್, ಪೇತ್ರನಸ್‌ ಠರ್‌ಕಿ ದೇಖ್ಯೊ, ತದೆ ಪೇತ್ರನೆ ಇನ, ಪ್ರಭು “ಮುರ್‌ಗೊ ಬಾಂಗ್‌ದ್ಯವಾನ ಅಗಾಡಿ, ತೂ ಮಾರಿ ಬಾರೇಮ, ‘ಯೋ ಮನ ಮಾಲುಮ್ ಕೊಯ್ನಿ’ ಕರಿ ತೀನ್‍ಹಲ್ಲ ಬೋಲಿಶ್” ಕರಿ ಬೋಲ್ಯೊಥೋತೆ ವಾತೆನ ಯಾದ್ ಕರಿಲಿನ್, ");
INSERT INTO vaa_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","ಭಾರ್‌ಜೈ಼ನ್‌, ಖ್ಹಡ್‌ಕ್ಯಾ ಭರಿನ್ ರೋಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","ಯೇಸುನ ಕಾವ್ಲಿ ಕರುಕರ್ತುಥೂತೆ ಇವ್ಣೆ, ಇನಿ ನಕ್ಲೆ ಕಾಡ್ಯು ಅಜು಼ ಇನ ಮಾರ‍್ಯು. ");
INSERT INTO vaa_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","ಇನ ಮ್ಹೋಡಾಪರ್ ಲುಂಗ್ಡು ನಾಖಿನ್, “ತುನ ಮಾರ‍್ಯೂತೆ ಕೋಣ್? ಕರಿ ಹಮೂನ ಪ್ರವಾದ್‌ನೆ ಬೋಲ್” ಕರಿ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","ಅಜು಼ ಇನಿಬಾರೇಮ ಕೈಏಕ್ ದೂಷಣೆ ಬೋಲಿನ್, ಖ್ಹರಮ್‌ ಕಾಡ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","ವ್ಹಾಣು ಹುವ್ವಾದೀನ್, ಶಾಣುಖ್ಹಾರು ಅಜು಼ ಮಹಾಯಾಜಕ, ಮೋಶೇನು ಧರ್ಮಶಾಸ್ತ್ರ ಶಿಕಾಡವಾಳು ಶಾಸ್ತ್ರಿ ಖ್ಹಾರು ಎಕ್ಟುಹುಯಿನ್, ಯೇಸುನ ನ್ಯಾವ್ ಫೇಡಾನಿಝ಼ಗೊಕನ ಲೀಗಯು. ");
INSERT INTO vaa_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","“ತೂ ಕ್ರಿಸ್ತ ಉಶೇತೊ, ಹಮೂನ ಬೋಲ್?” ಕರಿ ಬೋಲ್ಯು. ತದೆ ಯೇಸುನೆ ಇವ್ಣುನ, “ಮೇ ಬೋಲ್ಯೋತೊ, ತುಮೆ ನಂಬಾಕೊಯ್ನಿ” ಕರಿ ಜವಾಬ್‌ ದಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","ಅಜು಼, “ಮೇ ತುಮೂನ ಶಾತ್‌ತೋಬಿ ಬೋಲಿಲಿದೋತೊ ತುಮೆ ಜವಾಬ್‌ ಕೋ ದಿಶುನಿ. ");
INSERT INTO vaa_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","ಹಂಕೇಥು, ಕತೋಬಿ ಅದ್ಮಿನೊ ಛಿಯ್ಯೊ, ಮಹಾನ್ ಶಕತ್‌ವಾಳೊ ದೇವ್ನ ಖಾವಿಬಾಜು಼ಮ ಬೆಠೊರ‍್ಹೀಶೆ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","ಇವ್ಣೆ ಖ್ಹಾರೂಸ್, “ಇಮ್‍ಕತೊ, ತೂ ದೇವ್‌ನೊ ಛಿಯ್ಯೊಕಿ ಶು?” ಕರಿ ಪುಛಾ಼ಯು. ತದೆ ಯೇಸುನೆ ಇವ್ಣುನ, “ಮೇ ಯೋಸ್ ಕರಿ ತುಮೇಸ್ ಬೋಲ್ಯಾನಿ” ಕರಿ ಜವಾಬ್‌ ದಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","ಅನ ಖ್ಹಮ್‌ಜಿನ್‌ ಇವ್ಣೆ, “ಅಪ್ಣ ಬಿಜಿ ಖೆವಿ ಸಾಕ್ಷಿನಿ ಜ಼ರೂರತ್ ಕೊಯ್ನಿ! ಅಪ್ಣೆ ಖ್ಹುದ್ ಅನೆ ಬೋಲ್ಯೋತೆ ಇನ ಖ್ಹಮ್‌ಜ್ಯಾನಿ!” ಕರಿ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","ಹಿಜ಼್ಜಾ ಎಕ್ಟು ಹುಯಿರ‍್ಹುಥೂತೆ ತಮಾಮ್‌ ಅದ್ಮಿ ಉಠೀನ್, ಯೇಸುನ ಪಿಲಾತಕನ ಬುಲೈಲಿಗಯು. ");
INSERT INTO vaa_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","ಹಿಜ್ಜಾ಼ ಇವ್ಣೆ ಯೇಸುಪರ್, “ಆ ಅದ್ಮಿ, ಅಪ್ಣ ಅದ್ಮಿ ಖ್ಹಾರಾನ ಗಲತ್‌ ವಾಟ್‌ಪರ್ ಲೀವಳ್ಯೊಜಾ಼ಸ್, ಇವ್ಣುನ, ‘ತುಮೆ ಕೈಸರ್‌ನ ಶುಂಕ ನಕೊ ಭಾಂದೊ’ ಕರಿ ಬೋಲಸ್, ಅತ್ರೇಸ್ ಕಾಹೆತೆ ಇನು ಯೋಸ್, ‘ಮೇ ಕ್ರಿಸ್ತ ಕರಿ ಏಕ್‌ ರಾಜ಼’ ಕರಿ ಬೋಲ್ತೊಫಂಡಾಸ್” ಕರಿ ಬೋಲಿನ್ ಗಲತ್‌ ಲಗಾಡ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","ಪಿಲಾತನೆ ಯೇಸುನ, “ತೂ ಯೆಹೂದ್ಯರ್‌ನೊ ರಾಜಾ಼ಕಿ ಶು?” ಕರಿ ಪುಛಾ಼ಯೊ, ತದೆ ಯೇಸುನೆ ಇನ, “ತುನೇಸ್ ಬೋಲ್ಯೋನಿ” ಕರಿ ಜವಾಬ್‌ ದಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","ತದೆ ಪಿಲಾತನೆ ಮಹಾಯಾಜಕರ್‌ ಅಜು಼ ಅದ್ಮಿನಿ ಭೀಡ್ನ, “ಆ ಅದ್ಮಿಮ ಮನ ಶನೀಶ್ ಗಲತ್‌ ಕೋ ದೆಖಾಯುನಿ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","ಕತೋಬಿ ಇವ್ಣೆ, “ಯೂದಾಯನು ಖ್ಹಾರಸ್ ಅದ್ಮಿನ, ಆ ವಚನ್ನ ಬೋಲಿದೇತೊಹುಯಿನ್‌, ಇವ್ಣಾಮ ಕಲ್ಹಾಗಟ್ ನಾಖಿರಾಖ್ಯೋಸ್. ಅನೆ ಗಲಿಲಾಯಾಥು ಶುರು ಕರೀನ್, ಹಮ್ಕೆ ಹಜ಼್ಜಾ ಐರ‍್ಹೋಸ್ತೆ” ಕರಿ ಬಿಜೂ಼ಬಿ ಘಟ್‍ಥಿ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","ಅನ ಖ್ಹಮ್‌ಜಿನ್‌ ಪಿಲಾತನೆ, “ಆ ಅದ್ಮಿ ಗಲಿಲಾಯವಾಳೊಕಿ ಶು? ಕರಿ ಫುಛಾ಼ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","ಯೇಸು ಹೆರೋದ ಅದಿಕಾರ್ ಚ಼ಲಾವ್‍ಕರಾಸ್ತೆ ಗಾಮ್‌ವಾಳೊ, ಕರಿ ಪಿಲಾತನ ಮಾಲುಮ್ ಪಡ್‌ತಾನ, ಯೇಸುನ ಹೆರೋದಕನ ಮೋಕ್‌ಲ್ಯೊ, ಯೋ ದನ್ಮ ಹೆರೋದ ಯೆರೂಸಲೇಮ್ಮಾಸ್ ಥೊ. ");
INSERT INTO vaa_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","ಯೇಸುನ ದೇಖಿನ್‌, ಹೆರೋದನ ಘಣು ಖ್ಹುಶಿಹುಯು. ಶನಕತೊ, ಇನೆ ಯೇಸುನಿ ಬಾರೇಮ ಘಣು ಖ್ಹಮ್‌ಜಿರಾಖ್ಯೊಥೊ, ಇನಖ್ಹಾಜೆ ಘಣ ದನ್‌ಥು, ಇನ ದೇವ್ಣುಕರಿ ಥೊ, ಯೇಸು ಕೆಹುತೋಬಿ ಅದ್ಭುತ್ ಕರಾತೊ, ಇನ ದೇಕ್ಣು ಕರಿ ಆಖ್ಹ್‌ಥು. ");
INSERT INTO vaa_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","ತದೆ ಹೆರೋದನೆ ಯೇಸುನ ಕೆತ್ರು ಫುಛಾ಼ಯೊತೋಬಿ, ಯೇಸುನೆ ಇನ ಜವಾಬ್‌ ಕೋ ದಿದೋನಿ. ");
INSERT INTO vaa_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","ಗಲ್‌ಢಯಾಜಕರ್‌ ಅಜು಼ ಮೋಶೇನು ಧರ್ಮಶಾಸ್ತ್ರ ಶಿಕಾವಾಳು ಶಾಸ್ತ್ರಿಯೆ ಭೀರಿನ್‌, ಯೇಸುನಿ ವಿರೋದ್ ನೀಕೊಂತೇಸ್ ವಾತೆನ ಬೋಲುಕರ್ತೂಥು. ");
INSERT INTO vaa_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","ಹೆರೋದ ಅಜು಼ ಇನು ಸಿಪಾಯಿಖ್ಹಾರು ಯೇಸುನಿ ಛಿಂಘಾವ್ಣಿ ಕರೀನ್, ನಕ್ಲೆ ಕಾಡ್ಯು. ಅಜು಼ ಘಣು ಅಛ್ಛು಼ ಝ಼ಗ್ಗಾನ ಫೇರೈನ್, ಪಾಛು಼ ಪಿಲಾತಕನ ಮೋಕ್ಲಿದಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","ಯೋಸ್‌ ದನ್ನೆ ಹೆರೋದ ಅಜು಼ ಪಿಲಾತ ದೋಸ್ತ್‌ ಬಣ್ಯಾ. ಅನೇಥಿ ಅಗಾಡಿ ಇವ್ಣೆ ದುಶ್‌ಮನ್‌ ಹುಯಿರ‍್ಹಾಥ. ");
INSERT INTO vaa_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","ತದೆ ಪಿಲಾತನೆ, ಮಹಾಯಾಜಕರ್‌ನ, ಅದಿಕಾರಿನ ಅಜು಼ ಅದ್ಮಿ ಖ್ಹಾರಾವ್‌ನ ಏಕ್‌ದಮ್ ಬುಲೈನ್, ");
INSERT INTO vaa_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","ಇವ್ಣುನ, “ತುಮೆ ಆ ಅದ್ಮಿನ ಮಾರಕನ ಲೈನ್‌, ಅದ್ಮಿ ಖ್ಹಾರಾನ ಗಲತ್‌ ವಾಟ್‌ಪರ್ ಚ಼ಲಾವ್‍ಕರಾಸ್‌ ಕರಿ ಬೋಲ್ಯ, ಕತೋಬಿ ಮೇ ಅನ ತುಮಾರ ಖ್ಹಾಮ್ಣೆಸ್ ವಿಚಾರ್ ಕರ‍್ಯೊತೋಬಿ, ತುಮೆ ಲಗಾಡ್ಯತೆ ಗಲ್ತಿಮ, ಏಕ್‌ಬಿ ಆನಾಮ ಮನ ಮಳ್ಯುಕೊಯ್ನಿ. ");
INSERT INTO vaa_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","ಹೆರೋದನಾಬಿ ಅನಾಮ ಗಲತ್‌ ಕೋ ದೆಖಾಯುನಿ, ಇನಖ್ಹಾಜೆಸ್‌, ಇನೆ ಅನ ಪಾಛು಼ ಅಪ್ಣಕನ ಮೋಕ್‌ಲ್ಯೊತೆ. ಮರಣ್ ದಂಡ್‌ ಖಾವಾಖ್ಹರ್‌ಕು ಗಲತ್‌ ಯೇಸುನೆ ಕರಿರಾಖ್ಯೊಕೊಯ್ನಿ. ");
INSERT INTO vaa_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","ಅನಖ್ಹಾಜೆ, ಮೇ ಅನ ಕೊಳ್ಡೇಥಿ ಮರೈನ್, ಮ್ಹೆಂದೆವುಸ್” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","ಪಸ್ಕ ಪೂಜಾ಼ನಿ ವೇಳ್ಮ ಅದ್ಮಿಖ್ಹಾರು ಬೋಲಿಲೇಸ್ತೆ ಏಕ್‍ಜ಼ಣಾನ ಖ್ಹಾರ್ಕೊಟ್‌ಮಾಥು ಪಿಲಾತ ಭಾರ್‌ ಕಾಡಿಮ್ಹೇಲ್‍ನು ಪಡ್ಯುಥು. ");
INSERT INTO vaa_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","ಕತೋಬಿ ಇವ್ಣೆ ಜೋ಼ರೇಖ್ಹು ಚಿಕ್ರಿನ್, “ಅನ ಮರೈನಾಕ್‌! ಹಮಾರಖ್ಹಾಜೆ ಬರಬ್ಬನ ಮ್ಹೇಲಿದೆ” ಕರಿ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","ಖ್ಹಯೇರ್‌ಮ ಚಾ಼ಲ್ಯುಥೂತೆ ಕಲ್ಹಾಗಟ್‍ನಟೇಕೆ ಅಜು಼ ಅದ್ಮಿನ ಮರ್‌ನಾಖ್ಯುತೆ ಇನಖ್ಹಾಜೆ ಬರಬ್ಬಾನ ಜೇಲ್‌ಮ ಕೋಂಡಿ ಘಾಲಿರಾಖ್ಯುಥು. ");
INSERT INTO vaa_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","ಪಿಲಾತನೆ ಯೇಸುನ ಛೋ಼ಡಾವ್‍ಣು ಕರಿ ಬಿಜು಼ ಪಾಛು಼ ಇವ್ಣ ಜೋ಼ಡೆ ವಾತೆ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","ಕತೋಬಿ ಇವ್ಣೆ, “ಇನ ಶಿಲ್‍ಬೆಪರ್‌ ನಾಕ್! ಶಿಲ್‌ಬೆಪರ್ ನಾಕ್!” ಕರಿ ಚಿಕ್ರುಕರ್ತುಥು. ");
INSERT INTO vaa_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","ಕತೋಬಿ ಪಿಲಾತನೆ ತೀನ್ನೆಹಲ್ಲ, “ಶನ? ಆ ಖಾರಾಬ್‌ ಶಾತ್‌ ಕರಿರಾಖ್ಯೋಸ್? ಮರಣ್ ದಂಡ್‌ ದೆವಾಖ್ಹರ್‌ಖ್ಹು ಗಲತ್‌ ಅನಾಮ ಮನ ದೆಖಾಯು ಕೊಯ್ನಿ! ಅನಖ್ಹಾಜೆ, ಮೇ ಅನ ಕೊಳ್ಡೇಥಿ ಮರೈನ್, ಮ್ಹೆಂದೆವುಸ್” ಕರಿ ಇವ್ಣುನ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","ಕತೋಬಿ, ಇವ್ಣೆ ಬಿಜೂ಼ಬಿ ಜೋ಼ರೇಥಿ ಬಳೇಳ್‌ತುಹುಯಿನ್, ಯೇಸುನ ಶಿಲ್‌ಬೆಪರ್ ನಖಾವ್ಣು ಕರಿ ಬೋಲ್ಯು. ಖ್ಹರ್ತಿಮ ಇವ್ಣಿ ಚಿಕ್ರಾಣಸ್ ಜೂತಿಗೈ. ");
INSERT INTO vaa_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","ತದೆ ಪಿಲಾತನೆ ಇವ್ಣೆ ಬೋಲಿಲಿದುತೆ ಇಮ್ಮಸ್ ಹುವಾದೆ ಕರಿ ತೀರ್ಮಾನ್ ಕರೀನ್, ");
INSERT INTO vaa_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","ಕಲ್ಹಾಗಟ್ ಅಜು಼ ಅದ್ಮಿನ ಮರ್‌ನಾಖ್ಯುತೆ ಇನಾಟೇಕೆ, ಜೇಲ್‌ಮ ಕೋಂಡೈ ಘಲೈರ‍್ಹೂಥೂತೆ ಬರಬ್ಬನ ಮ್ಹೇಲಿದಿನ್, ಅದ್ಮಿನಿ ಮರ್ಜಿನಿಘೋಣಿ, ಯೇಸುನ ಇವ್ಣ ಹಾತ್‌ಮ ದಿನಾಖ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","ಸಿಪಾಯಿಖ್ಹಾರು ಯೇಸುನ ಬುಲೈಲಿನ್ ವಳ್ಯುಜಾ಼ತುಥೂತೆ ವಖ್ಹತ್‌ಮ, ಖೇತರ್‌ಥು ವಳ್ಯಾವ್‍ತೊಥೋತೆ ಸಿರೇನ್ ಖ್ಹಯೇರ‍್ನೊ ಸೀಮೋನ್ನ ಧರೀನ್, ಇನಾಪರ್ ಶಿಲ್‌ಬೇನ ನಾಖಿನ್, ಇನ ಪಳ್ಳಿನ್‌, ಯೇಸುನ ಪೀಠೆ ಆವಾನಿಘೋಣಿ ಕರ‍್ಯು. ");
INSERT INTO vaa_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","ಅದ್ಮಿನಿ ಮೋಟಿ ಭೀಡ್ ಇನ ಪೀಠೆಆಯಿ; ಇವ್ಣಾಮ ಥೋಡಿ ತಯೇಡಾಬಿ ಥಿಯೆ, ಇವ್ಣೆ ಯೇಸುನಖ್ಹಾಜೆ ಛಾ಼ತಿ ಕೂಟ್‌ತುಹುಯಿನ್, ರೋವ್‌ತಿ ಐಯ್ಯೆ. ");
INSERT INTO vaa_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","ತದೆ ಯೇಸುನೆ ಪೀಠೆ ಫರೀನ್ ಇವ್ಣುನ, “ಯೆರೂಸಲೇಮ್‌ನಿ ತಿರಿಯಾವೊ! ಮಾರಖ್ಹಾಜೆ ನಕೊ ರೋವೊ, ಕತೋಬಿ ತುಮಾರಖ್ಹಾಜೆ ಅಜು಼ ತುಮಾರ ಲಡ್ಕಾವ್‍ನಖ್ಹಾಜೆ ರೋವೊ. ");
INSERT INTO vaa_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","ಶನಕತೊ ಅಮ್ನದನ್‌ ಖ್ಹಾರ ವಳ್ಯಾವಾಸ್ಕಿ, ಯೋ ದನ್ಮ ಅದ್ಮಿಖ್ಹಾರು, ‘ವಾಂಝ಼್‌ಣಿ ಅಜು಼ ಬೇಜೂನಿ ಹುಯಿಕೊಂತೆ ಅಜು಼ ದೂದ್ ಪಿಡೈಕೊಂತೆ ತಯೇಡಾಸ್ ಧನ್ಯ’ ಕರಿ ಬೋಲ್‌ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","ಯೋ ದನ್ಮ ಅದ್ಮಿ, ‘ಪರ್ಭತ್‌ ಹಮಾರಪರ್ ಪಡ್! ಪಹಾಡ್ ಹಮೂನ ಢಾಪಿಲೆ!’ ಕರಿ ಬೋಲ್‌ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","ಝಾ಼ಡು ಹರ‍್ಯು ರ‍್ಹವಾನಿ ವಖ್ಹತ್‌ಮಾಸ್‌, ಅಮ್ನು ಖ್ಹಾರು ಹುಯೂತೊ, ಖ್ಹುಕೈ ಜಾ಼ಶೇತೆ ವಖ್ಹತ್‌ಮ ಶಾತ್ ಉಶೆ?” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","ಯೇಸುನ ಜೋ಼ಡೆಸ್ ಬಿಜ಼ ಬೇ ಜ಼ಣಾನಾಬಿ ಮಾರ‍್ನು ಕರಿ ಲೀವಳ್ಯುಜಾ಼ತುಥು, ಇವ್ಣೆ ಭೇ ಜ಼ಣಾಬಿ ಅಪರಾದಿ ಹುಯಿರ‍್ಹಾಥ. ");
INSERT INTO vaa_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","ಇವ್ಣೆ ‘ಖೋಪ್ರಿ’ ಕರಿ ಬೋಲಾನಿ ಝ಼ಗೋಕನ ಐನ್, ಹಿಜ್ಜಾ಼ ಯೇಸುನ ಶಿಲ್‌ಬೆಪರ್ ಮಾರ‍್ಯು, ಅಜು಼ ಯೋ ಬೇ ಅಪರಾದಿಮ ಏಕ್‌ ಜ಼ಣಾನ ಖಾವಿ ಬಾಜೂ಼ಮ ಅಜು಼ ಬಿಜೇಕ್‌ ಜ಼ಣಾನ ಡಾವಿ ಬಾಜೂ಼ಮ ಶಿಲ್‌ಬೆಪರ್ ಮಾರ‍್ಯು. ");
INSERT INTO vaa_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","ತದೆ ಯೇಸುನೆ, “ಬಾ, ಅವ್ಣುನ ಮಾಪ್‌ಕರ್‌! ಅವ್ಣೆ ಶಾತ್‌ ಕರುಕರಸ್ ಕರಿ ಅವ್ಣುನಾಸ್‌ ಮಾಲುಮ್‌ ಕೊಯ್ನಿ” ಕರಿ ಬೋಲ್ಯೊ. ಸಿಪಾಯಿಖ್ಹಾರು ಚೀಟಿ ನಾಖಿನ್, ಯೇಸುನ ಲುಂಗ್ಡಾವ್‍ನ ಇವ್ಣ-ಇವ್ಣಾಮಸ್ ವಾಟ ಪಾಡಿಲಿದು. ");
INSERT INTO vaa_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","ಅದ್ಮಿಖ್ಹಾರು ಭೀರಿನ್‌, ಯೆಹೂದ್ಯರ್‌ನ ಅದಿಕಾರಿಖ್ಹಾರು ಯೇಸುನಿ ನಕ್ಲೆ ಕಾಡುಕರ್ತುಥೂತೆ ಇನ ದೇಖುಕರ್ತುಥು. ಇವ್ಣೆ, “ಅನೆ ಬಿಜಾ಼ನ ಬಚಾ಼ಡ್ಯೊ, ಯೋ ದೇವ್ನೆ ಚೂ಼ಣ್ಯೋತೆ ಕ್ರಿಸ್ತ ಉಶೇತೊ, ಇನು ಯೋಸ್‌ ಬಚಾ಼ಡಿಲ್ಯವಾದೆ! ಕರಿ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","ಶಿಪಾಯಿ ಖ್ಹಾರುಬಿ ಯೇಸುನಿ ನಕ್ಲೆ ಕಾಡ್ಯು; ಇವ್ಣೆ ಯೇಸುನ ಖನ್ನೆ ಐನ್, ಕಮ್ ಮೋಲ್ನು ಕಂದಾಯುಹುಯು ದ್ರಾಕ್ಷಿನು ರಖ್ಹ್‌ನ ಪಿಯ್ಯಾನ ದೀನ್, ");
INSERT INTO vaa_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","“ತೂ ಯೆಹೂದ್ಯರ್‌ನೊ ರಾಜಾ಼ ಉಶೇತೊ, ತಾರು ತೂಸ್ ಬಚಾ಼ಡಿಲೆ” ಕರಿ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","ಯೇಸುನಿ ಶಿಲ್‌ಬೆನ ಉಪ್ಪರ್, “ಆ ಯೆಹೂದ್ಯರ್‌ನೊ ರಾಜ಼” ಕರಿ ಲೀಖೈರ‍್ಹೂಥು. ");
INSERT INTO vaa_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","ಹಿಜ್ಜಾ಼ ಶಿಲುಬೆಪರ್ ಠಂಗೈರಾಖ್ಯುಥೂತೆ ಅಪರಾದಿಮ ಏಕ್‌ ಜ಼ಣು ಯೇಸುನಿ ನಕ್ಲೆ ಕಾಡ್ತೊಹುಯಿನ್‌, “ತೂ ಕ್ರಿಸ್ತ ಕಾಹೆಕಿ ಶು? ಇಮ್‍ಕತೊ, ತೂಬಿ ಬಚಿ ಜಾ಼ ಹಮುನಾಬಿ ಬಚಾ಼ಡ್‍!” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","ಕತೋಬಿ ಬಿಜೇಕ್‌ ಜ಼ಣಾನೆ ಇನ ಗುರ್‌ಕೈನ್, “ತುನ ದೇವ್‌ನೂ ಡರ್‌ ಕೊಯ್ನಿಕಿ ಶು? ತುನಾಬಿ ಇಮ್ನಿಸ್ ನಿಶತ್ ಮಳಿರ‍್ಹೀಸ್‌ನಿ. ");
INSERT INTO vaa_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","ಅಪ್ಣುನತೋಬಿ, ನಿಶತ್ ಮಳಿರ‍್ಹೀಸ್ತೆ ಇನಾಮ ನ್ಯಾವ್‌ ಛಾ಼; ಶನಕತೊ ಅಪ್ಣೆ ಕರ‍್ಯಾತೆ ಗಲತ್‌ನಖ್ಹಾಜೆ, ಅಪ್ಣುನ ನಿಶತ್ ಮಳಿರ‍್ಹಿಸ್‌. ಕತೋಬಿ ಅನೆ ಶನೀಬಿ ಗಲತ್‌ ಕೋ ಕರ‍್ಯೋನಿ!” ");
INSERT INTO vaa_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","ಅಜು಼ ಇನೆ ಯೇಸುನ, “ಯೇಸು, ತೂ ರಾಜ್ಯಲೀನ್ ಆವಾನಿ ವಖ್ಹತ್‌ಮ, ಮನ ಯಾದ್ ಕರಿಲಿಜೊ!” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","ತದೆ ಯೇಸುನೆ ಇನ, “ಮೇ ತುನ ಖ್ಹಾಚ ಬೋಲುಸ್ಕಿ, ಹಮ್ಕೇಸ್ ತೂ ಮಾರ ಜೋ಼ಡೆ ಸೊರ್ಗಾಮ ರ‍್ಹೀಶ್” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","45","ತದೆ ಧೊಪಾರ್‌ ಹುಯಿಗಯುಥು, ಚಾ಼ಂದ್ ಉಜಾ಼ಳು ದ್ಯವಾನು ಭೀರಿಜೈ಼ನ್, ತೀನ್ ಘಂಟಾಲಗು, ಯೋ ಖ್ಹಾರ ದೇಖ್ಹ್‌ಪರ್ ಅಂಧಾರು ಢಫೈಗಯುಥು. ಮಂದಿರ್‌ಮ ಠಂಗೈರಾಖ್ಯುಥೂತೆ ಪಡ್‌ದೊ ಫಾಟಿನ್, ಬೇ ಭಾಗ್‌ ಹುಯಿಗಯು. ");
INSERT INTO vaa_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","ಯೇಸು ಜೋ಼ರೆಖ್ಹು ಚಿಕ್ರಿನ್, “ಬಾ, ತಾರ ಹಾತ್‌ಮ ಮಾರು ಆತ್ಮಾನ ದೆವುಕರುಸ್‌” ಕರಿ ಬೋಲಾನ ಬಾದ್‌ಮ, ಜಾನ್‌ ಮ್ಹೇಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","ತದೆ ಖ್ಹೋಶಿಪಾಯಿನೊ ಮೋಟಾನೆ ಚಾ಼ಲ್ಯುತೆ ಇನ ದೇಖಿನ್‌, “ಖ್ಹಾಚಮಾಬಿ ಆ ಅದ್ಮಿ ನೀತಿವಾಳೊಸ್‌ ಹುಯಿರ‍್ಹೋಥೊ!” ಕರಿ ದೇವ್ನ ಖ್ಹರಾಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","ಆ ಖ್ಹಾರು ದೆಖಾನ ಐರ‍್ಹೂಥೂತೆ ಅದ್ಮಿಖ್ಹಾರು, ಚಾ಼ಲ್ಯುತೆ ಇನ ದೇಖಿನ್‌, ದುಖ್‌ಥಿ ಛಾ಼ತಿ ಕೂಟ್‌ತುಹುಯಿನ್, ಇವ್ಣ ಘರೆ ಫಾಛು಼ಫರಿ ಗಯು. ");
INSERT INTO vaa_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","ಯೇಸುನು ವಳ್‌ಖಿನು ಅದ್ಮಿಖ್ಹಾರು ಅಜು಼ ಗಲಿಲಾಯಾಥು ಇನ ಭೀಡೆ ಆಯುಹುಯಿ ತಯೇಡ ಖ್ಹಾರಿ ದೂರ್ ಭೀರಿನ್‌, ಚಾ಼ಲ್ಯುತೆ ಯೋ ಖ್ಹಾರಾನ ದೇಖಿಯೆ. ");
INSERT INTO vaa_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","ಯುದಾಯ ತಬರ್‌ಖಾನು, ಅರಿಮಥಾಯ ಕರಿ ಗಾಮ್ಮ ಯೋಸೇಫ ಕರಿ ಏಕ್ಜ಼ಣೊ ಥೊ. ಯೋ ಏಕ್‌ ಅಛ್ಛು಼ ಅಜು಼ ನೀತಿವಾಳೊ ಅದ್ಮಿ ಹುಯಿರ‍್ಹುಥೊ, ದೇವ್ನಿ ರಾಜ್ಯ ಕದೆ ಆವ್‍ಶೆಕರಿ ಬೋಲಿನ್ ಟಿವವ್‍ಕರ್ತೊಥೊ. ಶಾಣಾವ್‍ನಿ ಸಭೆಮಾನು ಅದ್ಮಿಮ ಆಬಿ ಏಕ್‌ ಜ಼ಣೊ ಹುಯಿರ‍್ಹೋಥೊ, ಕತೋಬಿ ಯೆಹೂದ್ಯರ್‌ನು ಶಾಣುಖ್ಹಾರು ಯೇಸುನ ಮಾರ‍್ನು ಕರಿ ಕರ‍್ಯುತೆ ಇನ, ಅನೆ ಮಾನ್ಯೊಥೊ ಕೊಯ್ನಿ. ");
INSERT INTO vaa_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","ಯೋ ಪಿಲಾತಕನ ಜೈ಼ನ್‌, ಯೇಸುನು ಶರೀರ್ ಮನ ದೇ ಕರಿ ಬೋಲಿಲಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","ಇನೆ ಯೇಸುನು ಶರೀರ್‌ನ ಶಿಲ್‌ಬೆಪರ್‌ಥು ಉತಾರಿನ್‌, ಘಣ ಮೋಲ್ನು ಲುಂಗ್ಡಾಥಿ ಲಪೇಟಿನ್, ಬಂಡಾಮ ಖೋಂದಿ ರಾಖ್ಯುಥೂತೆ ಘವಿಮ ಮ್ಹೇಲ್ಯೊ. ಅನೇಥಿ ಪಹಿಲೆ ಇನಾಮ ಕಿನೂಬಿ ಮಖ್ಹಾಣ್ಯು ಮ್ಹೇಲ್ಯೂಥು ಕೊಯ್ನಿ. ");
INSERT INTO vaa_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","ಯೋ ದನ್ ಖ್ಹವಾರಾನೊ ದನ್ ಹುಯಿರ‍್ಹೋಥೊ, ಅಜು಼ ಜ಼ರ ಘಡಿಮಾಸ್ ಸಬ್ಬತ್‌ ದನ್ ಶುರು ಹುವಾಳು ಥು. ");
INSERT INTO vaa_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","ಗಲಿಲಾಯಥು ಯೇಸುನ ಭೀಡೆ ಆಯಿಹುಯಿ ತಯೇಡಾನೆ, ಯೋಸೇಫ್‌ನ ಜೋ಼ಡೆ ಜೈ಼ನ್‌, ಘವಿನಾಬಿ ಅಜು಼ ಯೇಸುನು ಶರೀರ್‌ನ ಮ್ಹೇಲೈರೂತೆ ತರಿಕಾನ ದೇಖ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","ತದೆ ಇವ್ಣೆ ಪಾಛು಼ಫರಿ ಘರೆಐನ್, ಅಛ್ಛು಼ ವಾನು ಜ಼ಡಿಬೂಠಿ ಅಜು಼ ವಾನುತೇಲ್‌ನ, ಯೇಸುನ ಶರೀರ್‌ಪರ್‌ ಲಗಾಡನಖ್ಹಾಜೆ ಖ್ಹವಾರಿಯೆ, ಮೋಶೇನು ಧರ್ಮಶಾಸ್ತ್ರಮ ಹುಕುಮ್‌ ದೀರಾಖ್ಯುತೆ ಇಮ್ಮಸ್ ಇವ್ಣೆ ಸಬ್ಬತ್ ದನ್ಮ ಅರಾಮ್‌ಕರಿಯೆ. ");
INSERT INTO vaa_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","ವಾರಾನು ಪಹಿಲದನ್ನೆ, ಅಧಿರ‍್ಹೇಣೆಸ್‌ ಯೋ ತಯೇಡ ಖ್ಹಾರಿ, ಇವ್ಣೆ ಖ್ಹವಾರಿಯೆಥೀತೆ ಅಛ್ಛು಼ ವಾನುತೇಲ್‌ನ ಪಳ್ಳಿನ್‌, ಘವಿಕನ ಗಯ್ಯೆ. ");
INSERT INTO vaa_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","ಘವಿನ ಮೂಚಿರಾಖ್ಯುಥೂತೆ ಬಂಡೊ ನಿಕ್‌ಳೈರ‍್ಹೂಥೂತೆ ಇವ್ಣೆ ದೇಖಿನ್, ");
INSERT INTO vaa_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","ಘವಿನ ಮಹಿ ಗಯ್ಯೆ, ಕತೋಬಿ ಹಿಜ಼್ಜಾ ಯೇಸು ಪ್ರಭುನು ಶರೀರ್ ಇವ್ಣುನ ಮಳ್ಯುಕೊಯ್ನಿ. ");
INSERT INTO vaa_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","ಇವ್ಣೆ ಭೀರಿನ್, ಅನಿ ಬಾರೇಮ ಘಬ್ರಾವ್‌ಕರಾನಿ ವಖ್ಹತ್‌ಮ, ಚ಼ಮಕ್‌ತು ಲುಂಗ್ಡು ಫೇರಿರಾಖ್ಯುಥೂತೆ ಬೇ ಪರ್ಖ್ಹಾ ಐನ್, ಇವ್ಣಾಕನ ಭೀರ‍್ಯು. ");
INSERT INTO vaa_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","ಯೋ ತಯೇಡ ಖ್ಹಾರಿ ಡರಿಗಯೇಥಿ. ಜ಼ಮೀನ್‍ತರಬ್‍ ಮುಡ್‌ಕ್ಯು ಝು಼ಕೈನ್‌, ಭೀರಿಗಯ್ಯೆ. ತದೆ ಇವ್ಣೆ ಇನ, “ಜಿವ್ತೊ ಹುಯಿನ್ ಉಠಿರ‍್ಹೋಸ್ತೆ ಇನ, ಮರ‍್ಯಾಹುಯಾಮ ಶನ ಢೂಂಡುಕರಾಸ್ತೆ? ");
INSERT INTO vaa_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","ಯೋ ಹಜ್ಜಾ಼ ಕೊಯ್ನಿ, ಉಠಿರ‍್ಹೋಸ್. ಯೋ ಗಲಿಲಾಯಮ ತುಮಾರ ಜೋ಼ಡೆ ಥೋತೆ ತದೆ, ಬೋಲ್ಯೊಥೋತೆ ಇನ ಯಾದ್ ಕರಿಲೆವೊ. ");
INSERT INTO vaa_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","ಅದ್ಮಿನೊ ಛಿಯ್ಯೊ ಪಾಪಿ ಅದ್ಮಿನ ಹಾತ್‌ಮ ದೆವೈನ್, ಶಿಲ್‌ಬೆಪರ್ ನಖೈನ್, ತೀನ್ನ ದನ್ಮ ಪಾಛೊ಼ ಉಠಿ ಆವ್‍ಶೆಕರಿ ಬೋಲ್ಯೊಥೋನಿ” ಕರಿ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","ತದೆ ಯೋ ತಯೇಡ ಖ್ಹಾರಿ ಯೇಸುನಿ ವಾತೆನ ಯಾದ್ ಕರಿಲೀನ್, ");
INSERT INTO vaa_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","ಮಖ್ಹಾಣ್ಯನಿ ಘವಿಕಂಥು ಪಾಛು಼ಫರಿ ಜೈ಼ನ್, ಗ್ಯಾರ‍್ಹ ಜ಼ಣ ಶಿಷ್ಯರ್‌ನ ಅಜು಼ ಬಿಜ಼ ಖ್ಹಾರಾನ ಅನಿ ಬಾರೇಮ ಬೋಲಿಯೆ. ");
INSERT INTO vaa_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","ಯೋ ಖ್ಹಾರಿ ತಯೇಡ ಕೋಣ್-ಕೋಣ್ ಕತೊ, ಮಗ್ದಲನಿ ಮರಿಯ, ಯೋಹಾನ್ನ, ಯಾಕೋಬ್‍ನಿ ಆಯ ಮರಿಯ; ಅವ್ಣೆ ಅಜು಼ ಅವ್ಣ ಜೋ಼ಡೆ ಥೀತೆ ಬಿಜಿ ತಯೇಡ ಖ್ಹಾರಿ ಅನಿ ಬಾರೇಮ, ಅಪೊಸ್ತಲರ‍್ನ ಬೋಲಿಯೆ. ");
INSERT INTO vaa_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","ಕತೋಬಿ, ಅಪೊಸ್ತಲರ್ ಖ್ಹಾರು ಅವ್ಣಿ ವಾತೇನ ವಿಶ್ವಾಸ್ ಕರ‍್ಯುಕೊಯ್ನಿ. ಆ ಖ್ಹಾರಿ ವಾತೆ ಚು಼ಪ್‌ಕೇನಿಸ್ ಕರಿ ಸೋಚ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","ಕತೋಬಿ ಪೇತ್ರನೆ ಉಠೀನ್, ಘವಿಕನ ನಾಶಿಜೈ಼ನ್, ಮಹಿ ಝು಼ಕಿ ದೇಖಿನ್, ಲಪೇಟಿಥೂತೆ ಘಣ ಮೋಲ್ನು ಲುಂಗ್ಡಾನಸ್ ಪಣ್ಕಿ ಬಿಜು಼ ಶಾತ್ಬಿ ದೇಖ್ಯೊ ಕೊಯ್ನಿ. ತದೆ ಪೇತ್ರನೆ ಚಾ಼ಲ್ಯುತೆ ಇನಿ ಬಾರೇಮ ಆಶ್ಚರ್ಯ ಖಾತೊಹುಯಿನ್, ಘರೆ ಚ಼ಲೆಗಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","ಯೋಸ್ ದನ್ನೆ ಯೇಸುನು ಶಿಷ್ಯರ್‌ಮ ಬೇ ಜ಼ಣ, ಯೆರೂಸಲೇಮ್‌ಥು ಗ್ಯಾರ‍್ಹ ಕಿಲೊ ಮೀಟರ್ ಥೂತೆ, ಎಮ್ಮಾಹು ಕರಿ ನಾಮ್ನ ಗಾಮೆ ವಳ್ಯಜಾ಼ತಾಥ. ");
INSERT INTO vaa_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","ಚಾ಼ಲ್ಯುತೆ ಯೋ ಖ್ಹಾರಿಸ್ ಬಾರೇಮ, ಇವ್ಣೆ ವಾತೆ ಬೋಲ್ತಾಹುಯಿನ್, ಒಳೆಜಾ಼ತಾಥ. ");
INSERT INTO vaa_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","ಇವ್ಣೆ ಏಕ್‌ಥಿ-ಏಕ್‌ ವಾತೆ ಬೋಲುಕರಾನಿ ವಖ್ಹತ್‌ಮ, ಯೇಸುಸ್‌ ಖ್ಹುದ್ ಇವ್ಣ ಖನ್ನೆ ಆಯಿನ್, ಇವ್ಣ ಜೋ಼ಡೆ ಚಾ಼ಲ್ತೊ ಗಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","ಇವ್ಣೆ ಇನದೇಖ್ಯು, ಕತೋಬಿ ಇನಿ ಖ್ಹಣೇದ್ ಧರ‍್ಯುಕೊಯ್ನಿ. ");
INSERT INTO vaa_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","ತದೆ ಯೇಸುನೆ ಇವ್ಣುನ, “ತುಮೆ ತುಮಾರ-ತುಮಾರಸ್‌ಮ ಶಾತ್‌ ಬೋಲ್ತಾಹುಯಿನ್, ಚಾ಼ಲ್ತ ವಳೆಜಾ಼ಸ್ತೆ?” ಕರಿ ಪುಛಾ಼ಯೊ. ತದೆ ಇವ್ಣೆ ಮ್ಹೋಡು ಮುರ್‌ಝೈ಼ಲೀನ್‌, ಭೀರಿಗಯು, ");
INSERT INTO vaa_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","ಇವ್ಣಾಮ, ಕ್ಲಿಯೋಫಸ್ ಕರಿ ನಾಮ್ನೊ ಏಕ್‌ ಜ಼ಣಾನೆ, “ಯೆರೂಸಲೇಮ್‌ ಬಹಾರ್‌ಥು ಆಯೂತೆ ಹರೇಕ್ನ, ಆ ದನೂಮ ಹಾ ಚಾ಼ಲಿರ‍್ಹೀಸ್ತೆ ವಾತೆನಿ ಬಾರೇಮ, ಮಾಲುಮ್‌ ರ‍್ಹವಾಪರ್ ತುನ ಮಾಲುಮ್ ಕೊಯ್ನಿಕಿ ಶು?” ಕರಿ ಪುಛಾ಼ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","ತದೆ ಯೇಸುನೆ, “ಖೆವಿ ವಾತೆ?” ಕರಿ ಪುಛಾ಼ಯೊ. ಇನ ಇವ್ಣೆ, “ನಜ಼ರೇತ್‌ನೊ ಯೇಸುನಿ ಬಾರೇಮ, ಯೊ ದೇವ್ನ ಅಜು಼ ಅದ್ಮಿನ ಡೋಳಾಮ ಪ್ರವಾದಿ ಹುಯಿರ‍್ಹೋಥೊ, ಕಾಮ್ಮಬಿ ಅಜು಼ ವಾತೇಮಾಬಿ ಮೋಟೊ ಪ್ರವಾದಿಹುಯಿರ‍್ಹೋಥೊ. ");
INSERT INTO vaa_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","ಹಮಾರ ಮಹಾಯಾಜಕ ಅಜು಼ ಅದಿಕಾರಿಖ್ಹಾರು ಇನ ಮರಣ್ ದಂಡನೆ ದೀನ್, ಶಿಲ್‌ಬೆಪರ್ ಛ಼ಡಾಯು. ");
INSERT INTO vaa_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","ಹಮೇತೊ, ಇಸ್ರಾಯೇಲ್‌ ಅದ್ಮಿವೋನ ಛೋ಼ಡಾವವಾಳೊ ಯೋಸ್ ಕರಿ ಭರೋಖ್ಹೊ ಕರಿರಾಖ್ಯಥ! ಯೋ ಖ್ಹಾರು ಚಾ಼ಲಿನ್, ಹಮ್ಕೆ ತೀನ್ ರೋಜ಼್‌ ಹುಯ. ");
INSERT INTO vaa_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","ತೋಬಿ ಹಮಾರಮ ಥೋಡಿ ತಯೇಡ ಖ್ಹಾರಿ, ಆಶ್ಚರ್ಯನು ವಾತೆನ ಬೋಲಿಯೆ; ಇವ್ಣೆ ವ್ಹಾಣೇಸ್ ವೇಳಿ ಘವಿಕನ ಜೈ಼ನ್, ");
INSERT INTO vaa_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","ಯೇಸುನು ಶರೀರ್ ಹಿಜ಼್ಜಾಕೊಂತೆ ದೇಖಿನ್, ಪಾಛು಼ಫರಿ ಐನ್, ಇವ್ಣೆ ದೇವ್‌ನು ದೂತರ್‌ನ ದೇಖಿಯೆ಼ ಅಜು಼ ಯೋ ಜಿವ್ತೊ ಹುಯಿರ‍್ಹೋಸ್ ಕರಿ ಬೋಲಿಯೆ. ");
INSERT INTO vaa_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","ಹಮಾರ ಜೋ಼ಡೆ ಥೂತೆ ಇವ್ಣಾಮ ಥೋಡುಜ಼ಣು ಮಖ್ಹಾಣ್ಯಕನ ಜೈ಼ನ್ ಯೋ ಖ್ಹಾರಿ ತಯೇಡ ಬೋಲಿತೆ ಇಮ್ಮಸ್ ದೇಖ್ಯು. ಕತೋಬಿ ಯೇಸುನ ಕೋ ದೇಖ್ಯೂನಿ” ಕರಿಬೋಲ್ಯಾ. ");
INSERT INTO vaa_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","ತದೆ ಯೇಸುನೆ ಇವ್ಣುನ, “ಅಲ ಬಿಣ್‍ಖ್ಹೈಲಾ, ಪ್ರವಾದಿಯೇನೆ ಬೋಲ್ಯಾತೆ ಇನ ವಿಶ್ವಾಸ್‌ ಕರಾಕೊಂತೆ ಮಂದ್‌ ದಿಲ್‌ವಾಳಾವೊ, ");
INSERT INTO vaa_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","ಕ್ರಿಸ್ತ ಅಮ್ನಿಖ್ಹಾರಿ ಖ್ಹತಾಪ್ಣಿ ಖೈನ್, ಇನಿ ಮಹಿಮೆಮ ಜಾ಼ವಾನು, ಜ಼ರೂರತ್ ಛಾ಼ನಿ ಕರಿ ಬೋಲಿನ್, ");
INSERT INTO vaa_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","ಮೋಶೆಥು ಧರೀನ್, ಖ್ಹಾರ ಪ್ರವಾದಿಯೇನು ಅಖ್ಖ ಪವಿತ್ರ ದಪ್ತರ್‌ಮ, ಇವ್ಣಿ ಬಾರೇಮ ಲೀಖೈರ‍್ಹೂತೆ ಖ್ಹಾರನ ಇವ್ಣುನ ಬೋಲಿವತಾಳ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","ಇವ್ಣೆ ಜಾ಼ವ್ಣುಥೂತೆ ಗಾಮ್‌ನ ಖನ್ನೆ ಇವ್ಣೆ ಆವಾದಿನ್, ಯೇಸು ಬಿಜೂ಼ಬಿ ಖ್ಹಾಮ್ಣೆ ಜಾ಼ವಾನಿ ಘೋಣಿ ದೆಖಾಯು. ");
INSERT INTO vaa_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","ಕತೋಬಿ ಇವ್ಣೆ ಇನ, “ಹಮ್ಕೆ ಖ್ಹಾಂಜ಼್ ಹುಯಿಗೈ, ರಾತ್ ಹೋತು ಉಳ್ಯುಜಾ಼ಸ್‌, ಹಮಾರ ಜೋ಼ಡೆ ರ‍್ಹೇ” ಕರಿ ಘಣು ಬೋಲಿಲಿದು. ");
INSERT INTO vaa_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","ತದೆ ಯೋ ಖಾಣಾನಖ್ಹಾಜೆ ಇವ್ಣ ಜೋ಼ಡೆ ಬೇಶಿನ್, ರೋಟಾನ ಪಾಡಿನ್, ದೇವ್ನ ಧನ್ಯವಾದ್ ಕರೀನ್, ತೋಡಿನ್ ಇವ್ಣುನ ದಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","ತದೆ ಇವ್ಣ ಡೋಳ ಉಖ್ಡಾಯ ಅಜು಼ ಇವ್ಣೆ ಯೇಸುನಿ ಖ್ಹಣೇದ್ ಧರ‍್ಯು, ಕತೋಬಿ ಯೇಸು ಇವ್ಣ ಡೋಳಾನ ಖ್ಹಾಮ್ಣೇಥೊ ಮ್ಹಾಯ ಹುಯಿಗಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","ತದೆ ಇವ್ಣೆ ಏಕ್‌ಥಿ-ಏಕ್‌, “ಯೇಸು ವಾಟ್‌ಪರ್ ಅಪ್ಣ ಜೋ಼ಡೆ ವಾತೆ ಬೋಲ್ತೊಹುಯಿನ್, ವಚನ್‍ಮ ಲೀಖೈರ‍್ಹೋತೆ ಇನ ಬೋಲಿವತಾಳ್ಯೋತೆ ತದೆ, ಅಪ್ಣ ದಿಲ್ನಮಹಿ ಆಗ್ ಬಳಾನಿಘೋಣಿ ಹುಯುಕೊಯ್ನಿಕಿ ಶು?” ಕರಿ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","ತದ್‌ನು ತದ್ದೇಸ್ ಇವ್ಣೆ ಉಠೀನ್, ಯೆರೂಸಲೇಮ್‌ನ ಗಯ. ಹಿಜ಼್ಜಾ ಗ್ಯಾರ‍್ಹ ಶಿಷ್ಯರ್‌ ಅಜು಼ ಬಿಜ಼ ಖ್ಹಾರಾನ ಜೋ಼ಡೆ ಎಕ್ಟು ಹುಯಿನ್, ");
INSERT INTO vaa_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","ಪ್ರಭು ಉಠಿರ‍್ಹೋಸ್ತೆ ಖ್ಹಾಚಸ್! ಸೀಮೋನ್ನ ಯೋ ದೆಖಾಯೊ!” ಕರಿ ಬೋಲುಕರ್ತೂಥು. ");
INSERT INTO vaa_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","ಅನ ದೇಖಿನ್, ಯೋ ಬೇ ಜ಼ಣಾನೇಬಿ ವಾಟ್‌ಪರ್ ಚಾ಼ಲ್ಯುತೆ ಇನ ಅಜು಼ ರೋಟೊ ತೋಡಾನಿ ವಖ್ಹತ್‌ಮ, ಇವ್ಣೆ ಇನಿ ಖ್ಹಣೇದ್ ಧರ‍್ಯೂತೆ ಇನ ಇವ್ಣುನ ಬೋಲಿವತಾಳ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","ಇವ್ಣೆ ಭೇ ಜ಼ಣ ಆ ಬಾರೇಮ ಬೋಲುಕರಾನಿ ವಖ್ಹತ್‌ಮ, ಯೇಸು ಪ್ರಭುಸ್ ಇವ್ಣ ಇಚ಼್‌ಮ ಆಯಿ ಭೀರಿನ್, “ತುಮೂನ ಸಮಾಧಾನ್ ಹುವಾದೆ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","ತದೆ ಇವ್ಣೆ ಡರ‍್ನ ಮಾರ‍್ನು ಮನ್‌ಮ ಘಬ್‌ರೈಜೈ಼ನ್, ಇವ್ಣೆ ದೇಖ್ಯೂತೆ ಭೂತ್ ಕರಿ ಸೋಚ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","ಕತೋಬಿ ಯೇಸುನೆ ಇವ್ಣುನ, “ತುಮೆ ಶನ ಘಬ್ರಾವೋಸ್ತೆ? ಶನ ತುಮಾರ ಮನ್‌ಮ ಗುಮಾನಿ ಹುಂಕರಾಸ್ತೆ? ");
INSERT INTO vaa_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","ಮಾರ ಹಾತ್ನ ಅಜು಼ ಗೋಡಾನ ದೇಖೊ, ಆ ಮೇಸ್ನಿ! ಮನ ಛೀಮಿ ದೇಖೊ, ತುಮೆ ದೇಖುಕರಾತೆ ಇಮ್‌ ಮನ ಬೋಟಿ ಅಜು಼ ಹಡ್‌ಕ್ಯಾ ಛಾ಼, ಕತೋಬಿ ಭೂತ್‌ನ ಆ ಖ್ಹಾರು ಕೋ ರ‍್ಹೇಯ್ನಿ. ");
INSERT INTO vaa_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","ಆ ಖ್ಹಾರು ಬೋಲಾನ ಬಾದ್‌ಮ, ಯೇಸುನೆ ಇನೊ ಹಾತ್‌ ಅಜು಼ ಗೋಡಾನ ಇವ್ಣುನ ವತಾಳ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","ಕತೋಬಿ, ಇವ್ಣೆ ಬಿಜೂ಼ಬಿ ವಿಶ್ವಾಸ್‌ಕರ‍್ಯುಕೊಂತೆ, ಖ್ಹುಶಿಥಿ ಆಶ್ಚರ್ಯ ಖಾತಾನ ದೇಖಿನ್, ಯೇಸುನೆ ಇವ್ಣುನ, “ಹಜ್ಜಾ಼ ತುಮಾರಕನ ಶಾತ್‌ತೋಬಿ ಖಾವಾನು ರಾಛು಼ ಛಾ಼ಕಿ ಶು?” ಕರಿ ಪುಛಾ಼ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","ಇವ್ಣೆ ಭೂಂಜಿಹುಯು ಮಾಛ಼್‌ಲಾನು ಏಕ್‌ ಟುಕ್ಡಾನ ಯೇಸುನ ದಿದು. ");
INSERT INTO vaa_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","ಯೇಸುನೆ ಇನಲೀನ್, ಇವ್ಣ ಖ್ಹಾಮ್ಣೇಸ್ ಖಾದೊ. ");
INSERT INTO vaa_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","ಅಜು಼ ಯೇಸುನೆ ಇವ್ಣುನ, “ಮೇ ತುಮಾರ ಜೋ಼ಡೆಸ್ ಥೋತೆ ತದ್ದೇಸ್, ಆ ಖ್ಹಾರು ತುಮೂನ ಬೋಲ್ಯೊಥೋನಿ. ಮೋಶೇನು ಧರ್ಮಶಾಸ್ತ್ರ, ಪ್ರವಾದಿಯೇನು ಪುಸ್ತಕ್‌ಮ ಅಜು಼ ಕೀರ್ತನೇಮ ಮಾರಿ ಬಾರೇಮ ಲೀಖೈರ‍್ಹೂತೆ ಅಖ್ಖು ಪೂರಹುವಾನು ಜ಼ರೂರತ್ ಛಾ಼ ಕರಿ ಮೇ ತುಮೂನ ಬೋಲ್ಯೊಥೊ ಕೊಯ್ನಿಕಿ ಶು?” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","ಅನ ಬಾದ್‌ಮ ಇವ್ಣೆ ವಚನ್‍ಮ ಲೀಖೈರ‍್ಹೂತೆ ಇನ ಪರ್ಖಿಲವಾನಿಮತ್, ಯೇಸುನೆ ಇವ್ಣಿ ಅಕ್ಕಲ್‍ನ ಛೋ಼ಡ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","ಅಜು಼ ಇವ್ಣುನ, ಕ್ರಿಸ್ತ ಖ್ಹತಾಪ್ಣಿ ಖೈನ್, ಮರಿನ್‌, ತೀನ್ನೊ ದನ್ಮ ಉಠಿ ಆವ್ಣು. ");
INSERT INTO vaa_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","ಅಜು಼ ಪಾಪ್ನ ಮಾಪಿ ಮಳ್‌ಣುಕತೊ, ದೇವ್ ಭಣಿ ಫರೊಕರಿ ಬೋಲಾನು, ಯೆರೂಸಲೇಮ್‌ಥು ಧರೀನ್, ತಮಾಮ್‌ ದೇಖ್ಹ್‌ಮ ಇನ ನಾಮ್‌ಪರ್‌ ಬೋಲಾವ್ಣು ಕರಿ ಲೀಖೈರ‍್ಹೂಸ್‌ನಿ, ");
INSERT INTO vaa_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","ಆ ಖ್ಹಾರಿ ಬಾರೇಮ, ತುಮೇಸ್ ಸಾಕ್ಷಿ ಹುಯಿರ‍್ಹಾಸ್‌. ");
INSERT INTO vaa_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","ಹಂದೇಖೊ! ಮಾರೊ ಬಾ ಜಿಭಾನ್‌ ದಿದೋತೆ ಇನ, ಮೇ ತುಮಾರಾಪರ್ ಬೋಲಿ ಮೋಕ್ಲಿಶ್. ಉಪ್ಪರ್‌ಥು ತುಮಾರಪರ್ ಶಕತ್‍ ಆವಾತೋಡಿ, ಆಸ್ ಖ್ಹಯೇರ್‌ಮ ತುಮೆ ಜ಼ಪಿರ‍್ಹೇಣು ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","ಅನ ಬಾದ್‌ಮ ಯೇಸುನೆ ಇವ್ಣುನ ಬೇಥಾನ್ಯತೋಡಿ ಬುಲೈಲಿ ಜೈ಼ನ್, ಇನೊ ಹಾತ್ ಪಾಡಿನ್, ಇವ್ಣುನ ಆಶೀರ್ವಾದ್‌ ಕರ‍್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","ಆಶೀರ್ವಾದ್‌ ಕರುಕರಾನಿ ವಖ್ಹತ್‌ಮ, ಯೋ ಇವ್ಣುನ ಮ್ಹೆಂದಿನ್, ಸೊರ್ಗಮ ಪಡೈಗಯೊ. ");
INSERT INTO vaa_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","ಇವ್ಣೆ ಯೇಸುನಿ ಆರಾದನೆ ಕರ‍್ಯು ಅಜು಼ ಘಣಿ ಖ್ಹುಶಿಥಿ ಯೆರೂಸಲೇಮ್‌ನ ಪಾಛು಼ಫರಿ ಗಯು. ");
INSERT INTO vaa_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","ಅಜು಼ ಇವ್ಣೆ ಕದೇಬಿ ಮಂದಿರ್‌ಮಾಸ್ ರ‍್ಹೀನ್, ದೇವ್ನಿ ಸ್ತುತಿಕರ‍್ಯು.");
INSERT INTO vaa_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","ಶುರುವಾತ್ನ ಪಹಿಲೆ ವಚನ್ ಥು; ಯೋ ವಚನ್‌ ದೇವ್‌ಕನ ಥು; ಯೋ ವಚನ್ ದೇವ್ ಹುಯಿರುಥು. ");
INSERT INTO vaa_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","ಯೋ ವಚನ್ ಶುರುವಾತ್‌ಥೂಸ್ ದೇವ್‌ಕನ ಥೊ. ");
INSERT INTO vaa_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","ಇನೇಥಿಸ್ ದೇವ್ನೆ ಅಖ್ಖೂಸ್ ಬಣಾಯೊ, ಬಣಾಯೋತೆ ಯೋ ತಮಾಮ್‌ ರಾಛಾ಼ಮ, ಏಕ್‌ಬಿ ಯೋ ಕೊಂತೆ ಉಬ್‍ಜ್ಯುಕೊಯ್ನಿ. ");
INSERT INTO vaa_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","ಇನಾಮ ಜಾನ್‌ ಥು. ಯೋ ಜಾನ್‌ ಅದ್ಮಿ ಖ್ಹಾರಾನ ಉಜಾ಼ಳು ಹುಯಿರ‍್ಹುಥು. ");
INSERT INTO vaa_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","ಯೋ ಉಜಾ಼ಳು ಅಂಧಾರಾಮ ಚ಼ಮ್‌ಕಾಸ್, ಅಜು಼ ಅಂಧಾರು ಇನ ಮಾಲುಮ್ ಕರ‍್ಯುಕೊಯ್ನಿ. ");
INSERT INTO vaa_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","ದೇವ್ನೆ ಏಕ್‌ ಖಬರ್‌ಲ್ಯಾವಳೊ ಏಕ್‌ ಅದ್ಮಿನ ಮೋಕ್‌ಲ್ಯೊ, ಇನು ನಾಮ್ ಯೋಹಾನ. ");
INSERT INTO vaa_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","ಯೋ ಖ್ಹಾರ ಅದ್ಮಿನ ಆ ಉಜಾ಼ಳನಿ ಸಾಕ್ಷಿ ದ್ಯವಾನ ಆಯೊ. ಶನಕತೊ ಖ್ಹಾರುಜ಼ಣು ಆ ಸಂದೇಶ್ನ ಖ್ಹಮ್‌ಜಿನ್‌ ವಿಶ್ವಾಸ್ ಕರ್ನುಕರಿ ಆಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","ಯೋಹಾನಸ್‌ ಯೋ ಉಜಾ಼ಳು ಕಾಹೆ, ಪಣ್ಕಿ ಯೋ ಉಜಾ಼ಳಾನಿ ಬಾರೇಮ ಸಾಕ್ಷಿ ದ್ಯವಾನ ಆಯೋತೆ. ");
INSERT INTO vaa_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","ಯೊ ಖ್ಹಾಚು಼ ಉಜಾ಼ಳು ಹುಯಿರುಥು ಅಜು಼ ಯೊ ಜಗತ್‌ಮ ಆವಾಳು ಥು, ಯೊ ಅಖ್ಖಾ ಅದ್ಮಿನ ಉಜಾ಼ಖ್ಹ್‌ ದೆವಾಳು ಹುಯಿರ‍್ಹುಥು. ");
INSERT INTO vaa_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","ವಚನ್ ಜಗತ್‌ಮ ಥು, ಅಜು಼ ದೇವ್ನೆ ಇನೇಥಿಸ್ ಜಗತ್ನ ಬಣಾಯೊ, ತೋಬಿ ಜಗತ್‌ ಇನ ಮಾಲುಮ್ ಕರ‍್ಯುಕೊಯ್ನಿ. ");
INSERT INTO vaa_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","ಯೋ ಇನ ಶೊಂತ್‌ ದೇಖ್ಹ್‌ಮ ಆಯೊ, ತೋಬಿ ಇನು ಶೊಂತ್ ಅದ್ಮಿಸ್‌ ಇನ ಮಳೈಲಿದುಕೊಯ್ನಿ. ");
INSERT INTO vaa_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","ಕತೋಬಿ ಕೋಣ್-ಕೋಣ್ ಇನ ಮಳೈಲಿದುಕಿ, ಕತೊ ಇನ ನಾಮ್‍ಪರ್ ವಿಶ್ವಾಸ್ ಕರ‍್ಯುಕೀ, ಇವ್ಣುನ ದೇವ್ನ ಲಡ್ಕಾ ಹುವಾನ ಹಕ್‌ ದಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","ಇವ್ಣೆ ಲ್ಹೋಯಿನಿ ಸಂಬಂದಾಥಿ ರ‍್ಹವೊ, ಶರೀರ್‌ನಿ ಆಖ್ಹ್‌ಥೀಬಿ ರ‍್ಹವೊ, ಪರ್ಖ್ಹಾನಿ ಖ್ಹಂಗ್‌ಥಿಬಿ ರ‍್ಹವೊ ಪೈದಹುಯುತೆ ಕಾಹೆ; ದೇವ್‌ಥೀಸ್ ಪೈದಹುಯುತೆ. ");
INSERT INTO vaa_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","ಯೋ ವಚನ್ ಅದ್ಮಿನು ರೂಪ್‍ನ ಲೀನ್ ವಾರ್‌ಖ್ಹೊಥೀಬಿ ಅಜು಼ ಖ್ಹಾಚಥೀಬಿ ಭರೈರ‍್ಹಾವಾಳೊ ಹುಯಿರೊಸ್. ಅಜು಼ ಅಪ್ಣಾಮ ಜಿವ್ಣುಕರ‍್ಯೊ. ಅಜು಼ ಅಪ್ಣೆ ಇನ ಮಹಿಮೆನ ದೇಖ್ಯ. ಯೊ ಬಾನೊ ಏಕ್‍ನೊ ಎಕ್ಕಸ್ ಛಿಯ್ಯಾನು ಮಹಿಮೆ ಹುಯಿರೊಥೊ. ");
INSERT INTO vaa_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","ಯೋಹಾನನೆ ಇನಿ ಬಾರೇಮ ಸಾಕ್ಷಿ ಬೋಲ್ಯೊ. ಅಜು಼ ಚಿಕರ್ತೊ ಹುಯಿನ್, “ಮೇ ಕಿನಿ ಬಾರೇಮ ಬೋಲಿರಾಖ್ಯೊಸ್ಕಿ ಯೋಸ್ ಆ ಹುಯಿರೊಸ್.” ‘ಮಾರ ಪಾಛ಼ಳ್ ಆವವಾಳೊ ಛಾ಼ ಕರಿ ಕಿನಿ ಬಾರೇಮ ಬೋಲ್ಯೊಥೋಕಿ ಯೊ ಮಾರೇಥಿಬಿ ಮಹಾನ್ ಹುಯಿರೊಸ್.‌ ಶನಕತೊ ಯೊ ಮಾರ ಪೈದಾಖ್ಹ್‌ನ ಅಗ್ಗಳಸ್ ಯೋ ಥೊ’. ");
INSERT INTO vaa_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","ಇನಿ ವಾರ್‌ಖ್ಹಾನಿ ಭರ್‌ಪೂರ್‌ಥಿಸ್, ಅಪ್ಣುನಖ್ಹಾರು ಆಶೀರ್ವಾದ್‍ಪರ್ ಆಶೀರ್ವಾದ್‌ ಮಳ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","ಧರ್ಮಶಾಸ್ತ್ರ ಮೋಶೆಥಿ ದೇವೈರ‍್ಹುಸ್ ಕತೋಬಿ ವಾರ್‌ಖ್ಹೊಬಿ ಖ್ಹಾಚ಼ಬಿ ಕ್ರಿಸ್ತಥಿ ಆಯುತೆ. ");
INSERT INTO vaa_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","ದೇವ್ನ ಕೋಣ್‌ಬಿ ಕದೇಬಿ ಕೊ ದೇಖ್ಯುನಿ, ಕತೋಬಿ ಏಕ್‍ನೊ ಏಕ್‌ ಛಿಯ್ಯೊ, ಯೊ ದೇವ್ನಿಘೋಣಿ ಛಾ಼. ಅಜು಼ ಬಾನಿ ಜೋ಼ಡ್ಮಾಸ್ ಛಾ಼ ಇನೇಸ್‌ ಅಪ್ಣುನ ಯೊ ಕೋಣ್ ಕರಿ ವತಾಳಿರಾಖ್ಯೊಸ್. ");
INSERT INTO vaa_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","ಯೆರೂಸಲೇಮ್‌ನು ಯೆಹೂದ್ಯರ್‌ನ ಅದಿಕಾರಿಯೋನೆ ಯಾಜಕರ್‌ ಅಜು಼ ಲೇವಿವಾಳಾನ ಯೋಹಾನಕನ ಮೋಕ್ಲಿನ್, “ತೂ ಕೋಣ್?” ಕರಿ ಪುಛಾ಼ವನಟೇಕೆ ಮೋಕ್‍ಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","ತದೆ ಯೋಹಾನನೆ ದಬಾಯೊಕೊಂತೆ, “ಮೇ ಕ್ರಿಸ್ತ ಕಾಹೆ” ಕರಿ ಖ್ಹಾರಾನ ಖ್ಹಾಮ್ಣೆ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","ಇಮ್‌ರ‍್ಹಯುತೊ, “ತೂ ಎಲೀಯಕಿ‍ ಶು? ಕರಿ ಇವ್ಣೆ ಬೋಲಖ್ಹತರ್, ತದೆ ಯೋಹಾನನೆ ‘ಕಾಹೆ’ ಕರಿ ಬೋಲ್ಯೊ. “ತೂ ಆವ್ಣುಥೂತೆ ಪ್ರವಾದಿ ಕಾಹೆಕಿ ಶು?” ಕರಿ ಪಾಛೊ಼ ಬೋಲಖ್ಹತರ್, “ಮೆ ಕಾಹೆ” ಕರಿ ಇನೆ ಫರಿನ್ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","ತದೆ ಇವ್ಣೆ, “ಇಮ್‍ಕತೊ, ತೂ ಕೋಣ್? ಹಮೂನ ಬೋಲ್, ಹಮೂನ ಮೋಕ್‌ಲ್ಯುತೆ ಇವ್ಣುನ ಹಮೆ ಜವಾಬ್‌ ದೇವ್ಣು; ತಾರಿ ಬಾರೇಮ ತೂ ಶಾತ್‌ ಬೋಲಾಸ್?” ಕರಿ ಪುಛಾ಼ಯು. ");
INSERT INTO vaa_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","ಯೋಹಾನಾನೆ, ಪ್ರವಾದಿ ಹುಯಿರೋತೆ ಯೆಶಾಯನೆ ಬೋಲಾನಿತರಸ್, ‘ಪ್ರಭುನಿ ವಾಟ್ನ ಖ್ಹೂದುಕರೊ ಕರಿ ಬೋಲಾನು ಉಜ್ಜಾ಼ಡಿ ಝ಼ಗೋಮ ಚಿಕ್ರಾವಾಳಾನಿ ಅವಾಜ಼್ ಮೇಸ್’ ಕರಿ ಜ಼ವಾಬ್‌ದಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","ಫರಿಸಾಯರ್‌ಥಿ ಮೋಕ್ಲಾಯುಹುಯು ಸಂದೇಶ್ ದ್ಯವಾಳು ಅದ್ಮಿ ಹುಯಿರುಥು. ");
INSERT INTO vaa_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","ಇವ್ಣೆ ಯೋಹಾನ್ನ ಬೋಲ್ಯು, “ತೂ ಕ್ರಿಸ್ತಬಿ ಕಾಹೆ ಕರಿ ಬೋಲಾನು ಉಷೇತೊ ಎಲೀಯಬಿ ಕಾಹೆ, ಪ್ರವಾದೀಬಿ ಕಾಹೆ, ಇಮ್‍ಕತೊ, ತೂ ಬ್ಯಾಪ್ತಿಸ್ಮ ಶನ ದೇಸ್?” ಕರಿ ಪುಛಾ಼ಯು. ");
INSERT INTO vaa_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","ತದೆ ಯೋಹಾನನೆ, “ಮೇ ಪಾಣಿಥಿ ಬ್ಯಾಪ್ತಿಸ್ಮ ದ್ಯವಾಳೊ, ಕತೋಬಿ ತುಮೂನ ಮಾಲುಮ್‌ಕೊಂತೆ ಏಕ್‌ ಜ಼ಣೊ ತುಮಾರ ಇಚ಼್‌ಮ ಛಾ಼. ");
INSERT INTO vaa_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","ಯೋಸ್ ಮಾರ ಪೀಠೆ ಆವಾಳೊ ಹುಯಿರ‍್ಹೋಸ್, ಇನಿ ಖೋಖ್ಹ್‌ಡಾನಿ ಡೋರಿ ಛೋ಼ಡಾನಾಬಿ ಮೇ ಲ್ಹಾಯೇಕ್‌ಕೊಯ್ನಿ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","ಆ ಅಖ್ಖೂಸ್ ಘಟನೆ ಬೇಥಾನ್ಯಮ ಚಾ಼ಲ್ಯು. ಆ ಯೊರ್ದನ್‌ ನದ್ದಿನ ಪೂರಬ್ ದಿಕ್ಮ ಛಾ಼ ಹಿಜ್ಜಾ಼ಸ್ ಯೋಹಾನ ಬ್ಯಾಪ್ತಿಸ್ಮ ದೆವ್‌ಕರ್ತೊಥೊ. ");
INSERT INTO vaa_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","ಇನವ್ಹಾಣೆ ಯೋಹಾನನೆ ಇನಾಖನ್ನೆ ವಳ್ಯಾವ್‍ತೊಥೋತೆ ಯೇಸುನ ದೇಖಿನ್, “ದೇವ್ನ ಮೇಂಢಾನ ಚೆಲ್ಕಾನ ದೇಖೊ, ಯೊ ಜಗತ್‌ನು ಪಾಪ್ನ ದೂರ್ ಕರ್ಶೆ.” ");
INSERT INTO vaa_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","ಅದ್ಮಿಖ್ಹಾರನ, ‘ಮಾರ ಪಾಛ಼ಳ್ ಆವಾಳೊ, ಮಾರೇಥಿಬಿ ಮಹಾನ್ ಹುಯಿರ‍್ಹೋಸ್, ಶನಕತೊ ಮೇ ಪೈದಾ ಹುವಾನ ಅಗಾಡಿಸ್ ಯೋ ಥೊ’ ಕರಿ ಮೇ ಬೋಲ್ಯೋತೆ ವಾತೆ ಅನಿಸ್ ಬಾರೇಮ ಹುಯಿರ‍್ಹೂಸ್. ");
INSERT INTO vaa_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","ಅಜು಼ ಯೋಹಾನನೆ ಇನಿ ಸಾಕ್ಷಿದಿದೊ, “ಯೋ ಕೋಣ್ ಕರಿ ಮನಾಬಿ ಮಾಲುಮ್ ಕೋ ಥೂನಿ, ಕತೋಬಿ ಇಸ್ರಾಯೇಲ್ ಅದ್ಮಿನ ಯೋ ಕೋಣ್ ಕರಿ ಮಾಲುಮ್‌ ಕರಾವಾನಖ್ಹಾಜೆ, ಮೇ ಪಾಣಿನು ಬ್ಯಾಪ್ತಿಸ್ಮ ದೆವಾಳೊ ಹುಯಿನ್ ಆಯೋತೆ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","ಅತ್ರೇಸ್ ಕಾಹೆತೆ ಯೋಹಾನ ಬೋಲ್ಯೋತೆ ಸಾಕ್ಷಿ ಶಾತ್‌ಕತೊ, “ದೇವ್‌ನು ಆತ್ಮ ಸೊರ್ಗಥು ಪರ‍್ಯಾವಾನಿಘೋಣಿ ಉತ್ರಿನ್ ಆಯೂತೆ ಅಜು಼ ಇನಾಪರ್ ಐನ್ ಬೆಠೂತೆ ಮೇ ದೇಖ್ಯೊ”. ");
INSERT INTO vaa_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","ಯೊ ಆಸ್‍ಕರಿ ಮನಾಬಿ ಮಾಲುಮ್‌ ಕೊಯ್ನಿ, ಕತೋಬಿ ದೇವ್ನೆ ಮನ ಪಾಣಿಥಿ ಬ್ಯಾಪ್ತಿಸ್ಮ ದ್ಯವಾನ ಮೋಕ್ಲಿರಾಖ್ಯೊಸ್. ಯೊ ಮನ ಪಹಿಲೇಸ್ ಬೋಲಿರಾಖ್ಯೊಸ್, ‘ತೂ ದೇವ್ನು ಆತ್ಮ ಉಪ್ಪರ್‌ಥು ಏಕ್‌ ಅದ್ಮಿಪರ್ ಉತ್ರಿಆವಾನು ದೇಖಿಶ್‌, ಯೋಸ್‌ ಪವಿತ್ರಾತ್ಮಥಿ ಬ್ಯಾಪ್ತಿಸ್ಮ ದೆವಾಳೊ ಹುಯಿರೋಸ್’ ");
INSERT INTO vaa_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","“ಮೇ ಇನ ದೇಖ್ಯೊ, ಅಜು಼ ಯೋಸ್ ದೇವ್‌ನೊ ಛಿಯ್ಯೊ ಕರಿ ಮೇ ಸಾಕ್ಷಿ ದೆವ್‍ಕರೂಸ್” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","ಇನ ಅಗ್‍ಲ್ಯ ದನ್ನೆ ಯೋಹಾನ ಇನ ಬೇಜ಼ಣ ಶಿಷ್ಯರ‍್ನ ಜೋ಼ಡ್ಮ ಭಿಯೋಥೊ. ");
INSERT INTO vaa_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","ತದೆ ಹಿಜ್ಜಾ಼ ಯೇಸು ಒಳೇಜಾ಼ತೊಥೋತೆ ದೇಖಿನ್, “ಹಂದೇಖೊ, ಬಲಿನಖ್ಹಾಜೆ ದೇವ್ನೆ ನೇಮಕ್ ಕರ‍್ಯೊತೆ ಮೇಂಢಾನು ಚೆಲ್ಕು!” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","ಯೋ ಭೇ ಶಿಷ್ಯರ್‌ ಯೋಹಾನ್ನಿ ಆ ವಾತೆನ ಖ್ಹಮ್‌ಜಿನ್‌, ಯೇಸುನ ಪೀಠೆ ಗಯ. ");
INSERT INTO vaa_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","ಇವ್ಣೆ ಪೀಠೆ ವಳ್ಯವತೆ ಯೇಸುನೆ ಪಾಛೊ಼ ಫರೀನ್ ದೇಖ್ಯೊ, ತದೆ ಯೊ ಇವ್ಣುನ ಬೋಲ್ಯೊ, “ತುಮೂನ ಶಾತ್ ಹೋಣು? ತದೆ ಇವ್ಣೆ ಜ಼ವಾಬ್ ದಿದು, “ರಬ್ಬಿ, ತೂ ಕಿಜ್ಗಾ಼ ಜಿವ್ಣು ಕರಸ್?” ಕರಿ ಬೋಲ್ಯ (ರಬ್ಬಿ ಕತೊ “ಗುರು” ಕರಿ). ");
INSERT INTO vaa_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","ಯೇಸುನೆ, “ಐನ್ ದೇಖೊ” ಕರಿ ಬೋಲ್ಯೊ. ತದೆ ಖ್ಹಾಂಜ಼್‌ನಿ ಖ್ಹುಮಾರ್, ಚಾರ್ ಘಂಟ ಹುಯಿರ‍್ಹಾಥ. ಇನಖ್ಹಾಜೆ ಇವ್ಣೆ ಇನಕೇಡೆ ಜೈ಼ನ್, ಯೋ ಥೋತೆ ಝ಼ಗೋನ ದೇಖ್ಯು, ಅಜು಼ ಯೋ ದನ್ ಇನ ಜೋ಼ಡೆಸ್ ರ‍್ಹಯು. ");
INSERT INTO vaa_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","ಯೋಹಾನ್ನಿ ವಾತೆನ ಖ್ಹಮ್‌ಜಿನ್‌ ಯೇಸುನಿ ಪೀಠೆ ವಳೇಜಾ಼ತಥಾತೆ ಯೊ ಬೇ ಶಿಷ್ಯರ್‌ಮ ಸೀಮೋನ್ ಪೇತ್ರನೊ ಭೈ ಹುಯಿರ‍್ಹೋತೆ ಅಂದ್ರೆಯಬಿ ಏಕ್‌ ಜ಼ಣೊ. ");
INSERT INTO vaa_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","ಅನೆ ಪಹಿಲೆ ಇನ ಭೈ ಹುಯಿರ‍್ಹೋತೆ ಸೀಮೋನ್‌ಕನ ಜೈ಼ನ್‌, “ಹಮೂನ ಮೆಸ್ಸೀಯ ಮಳಿರ‍್ಹೋಸ್‌” ಕರಿ ಬೋಲ್ಯೊ. (“ಮೆಸ್ಸೀಯ” ಕತೊ ಇಬ್ರಿಯಾಮ “ಕ್ರಿಸ್ತ” ಕರಿ) ");
INSERT INTO vaa_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","ಅಜು಼ ಸೀಮೋನ್ನ ಯೇಸುಕನ ಬುಲೈಲಾಯೊ. ಯೇಸುನೆ ಸೀಮೋನ್ನ ದೇಖಿನ್‌, “ತೂ ಯೋಹಾನನೊ ಛಿಯ್ಯೊ ಹುಯಿರ‍್ಹೋತೆ ಸೀಮೋನ್, ಕತೋಬಿ ಹಮ್ಕೆಥು ‘ಕೇಫ’ ಕರಿ ಬೋಲೈಲಿಶ್” ಕರಿ ಬೋಲ್ಯೊ. ‘ಕೇಫ’ ಕತೊ ಪೇತ್ರ ಕರಿ. ಅನಿ ಮತ್‌ಲಬ್ ‘ಚಿಪಾಟ್’. ");
INSERT INTO vaa_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","ಇನ ಅಗ್‍ಲ್ಯ ದನ್ನೆ ಯೇಸು ಗಲಿಲಾಯನ ಜಾ಼ವ್ಣುಕರಿ ಥೋತೆ ತದೆ, ಫಿಲಿಪ್ಪನ ದೇಖಿನ್‌, “ಮಾರ ಜೋ಼ಡೆ ಆವ್!” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","ಅಂದ್ರೆಯ ಅಜು಼ ಪೇತ್ರ ಬೆತ್ಸಾಯಿದ ಖ್ಹಯೇರ್‌ವಾಳ, ಫಿಲಿಪ್ಪಬಿ ಯೋಸ್ ಖ್ಹಯೇರ್‌ವಾಳೊ ಹುಯಿರ‍್ಹೋಥೊ. ");
INSERT INTO vaa_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","ಫಿಲಿಪ್ಪನೆ ನತಾನಿಯೇಲ್‌ಥಿ ಮಳಿನ್, ಇನ, “ಕಿನಿ ಬಾರೇಮ ಮೋಶೆನೆ ಧರ್ಮಶಾಸ್ತ್ರ ಲೀಖ್ಯೋಕಿ ಅಜು಼ ಪ್ರವಾದಿಖ್ಹಾರು ಲೀಖ್ಯೂಕಿ ಯೋ ಹಮೂನ ಮಳಿರ‍್ಹೋಸ್‌. ಯೋ ಕೋಣ್‌ಕತೊ ಇನು ನಾಮ್ ಯೇಸು ಯೋಸೇಫ್‌ನೊ ಛಿಯ್ಯೊ ಅಜು಼ ನಜ಼ರೇತ್‍ಮ ರ‍್ಹವಾಳೊ. ");
INSERT INTO vaa_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","ತದೆ ನತಾನಿಯೇಲನೆ, ‘ನಜ಼ರೇತ್‌ಥು ಶಾತ್‌ತೋಬಿ ಅಛ಼್ಛು ಆವ್‌ಶೆಕಿ ಶು’? ಕರಿ ಫಿಲಿಪ್ಪನ ಪುಛಾ಼ಯೊ. ಇನ ಫಿಲಿಪ್ಪನೆ, “ಐನ್, ದೇಕ್” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","ಯೇಸುನೆ ಇನಾಭಣಿ ವಳ್ಯಾವ್‌ಥೋತೆ ನತಾನಿಯೇಲ್‌ನ ದೇಖಿನ್‌, ಇನಿ ಬಾರೇಮ, “ಹಂದೇಖೊ, ಆ ಖ್ಹಾಚೊ಼ ಇಸ್ರಾಯೇಲ್‌ವಾಳೊ; ಅನಾಮ ಶನೀಶ್ ಗಲತ್‌ ಕೊಯ್ನಿ!” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","ಇನ ನತಾನಿಯೇಲನೆ ತೂ ಮನ ಕಿಮ್ ಮಾಲುಮ್ ಕರ‍್ಯೊ? ಕರಿ ಯೇಸುನ ಬೋಲಖ್ಹತರ್ ಇನೆ ಫಿಲಿಪ್ಪನೆ ತುನ ಬುಲಾವನ ಅಗಾಡಿಸ್ ತು ಯೋ ಅಂಜೀರ್‌ನ ಝಾ಼ಡ್‌ ಹೇಟ್ ಮೇ ದೇಖ್ಯೊ ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","ತದೆ ನತಾನಿಯೇಲನೆ ಇನ, “ಗುರು, ತೂ ದೇವ್‌ನೊ ಛಿಯ್ಯೊ! ತೂಸ್ ಇಸ್ರಾಯೇಲ್‌ನೊ ರಾಜ಼!” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","ಯೇಸುನೆ ಇನ, ತೂ ಅಂಜೀರ್‌ನ ಝಾ಼ಡಾನ ಹೇಟ್‌ ಥೊ, ತದೆ ಮೆ ತುನ ದೇಖ್ಯೊ. ಕರಿ ಬೋಲ್ಯೋತೆ ವಾತೆಥಿ ತೂ ನಂಬಾಸ್ಕಿ ಶು? ತೂ ಇನೇಥಿಬಿ ಜಾ಼ಖ್ಹತ್ ಮೋಟು ಕಾಮ್‌ಖ್ಹಾರು ದೇಖಿಶ್‌!” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","ಯೇಸುನೆ ಇವ್ಣುನ, “ಮೇ ತುಮೂನ ಖ್ಹಾಚ ಬೋಲುಸ್ಕಿ: ಸೊರ್ಗ ನಿಕ್‌ಳೈರ‍್ಹೀಶೆತೆ ಅಜು಼ ಅದ್ಮಿನೊ ಛಿಯ್ಯಾನ ಉಪ್ಪರ್ ಕರಿ ದೇವ್‌ನು ದೂತರ್ ಉತ್ರಿ ಆವಾನು ಅಜು಼ ಜಾ಼ವಾನು ತುಮೆ ದೇಕ್‌ಶು” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","ತೀನ್ನೆ ದನ್ಮ ಗಲಿಲಾಯನು ಕಾನಾಕರಿ ಗಾಮ್ಮ ಏಕ್‌ ವ್ಯಹಾ ಥೂ. ಯೇಸುನಿ ಆಯ ಹಿಜ್ಜಾ಼ ಥಿ. ");
INSERT INTO vaa_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","ಯೇಸುನ ಅಜು಼ ಇನ ಶಿಷ್ಯರ್‌ನಾಬಿ ವ್ಯಹಾನ ಬುಲೈರಾಖ್ಯುಥು. ");
INSERT INTO vaa_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","ದ್ರಾಕ್ಷಿನು ರಖ್ಹ್‌ ಪುರ‍್ಯೂಕೊಂತೆ ಇನಖ್ಹಾಜೆ, ಯೇಸುನಿ ಆಯಾ ಇನ ದ್ರಾಕ್ಷಿನು ರಖ್ಹ್‌ ಕೊಯ್ನಿ” ಕರಿ ಬೋಲಿ. ");
INSERT INTO vaa_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","ಯೇಸುನೆ ಇನ, “ಆಯಾ, ಮನ ಆ ಅಖ್ಖು ಶನ ಬೋಲಸ್? ಮಾರಿ ವಖ್ಹತ್ ಬಿಜೂ಼ಬಿ ಕೋ ಐರ‍್ಹೀನಿ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","ತದೆ ಯೇಸುನಿ ಆಯಾನೆ ಆಳ್‌ನ ಖ್ಹಾರು, “ಯೋ ತುಮೂನ ಶಾತ್‌ ಬೋಲಸ್ಕಿ, ಯೋ ಕರೊ” ಕರಿ ಬೋಲಿ. ");
INSERT INTO vaa_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","ಬಂಡಾಥಿ ಬಣೈಹುಯು ಛೊ಼ ಟೊಟ್ಟಿ ಮ್ಹೇಲಿರಾಖ್ಯುಥು, ಯೆಹೂದ್ಯರ್‌ನಿ ಪದತ್ತಿಮ ಶುದ್ದಿ ಕರಾನಟೇಕೆ, ಅನ ರಾಕ್‍ತುಥು. ಹರೇಕ್ ಟೊಟ್ಟಿಬಿ ಖ್ಹುಮಾರ್ ಚಾರಿಖ್ಹ್ ಥಿ ಏಕ್‌ ಖ್ಹೋ ವೀಖ್ಹ್‌ ಲೀಟರ್ ಪಾಣಿಭರಾವ ಎವ್ಡು ಮೋಟು ಥೂ. ");
INSERT INTO vaa_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","ಯೇಸು ಯೋ ಆಳ್‌ ಖ್ಹಾರಾನ, “ಹೈರಾತೆ ಟೊಟ್ಟಿಮ ಪಾಣಿ ಭರೊ” ಕರಿ ಬೋಲ್ಯೊ. ಇಮ್ಮಸ್ ಇವ್ಣೆ ಯೋ ಟೊಟ್ಟಿಮ ಪಾಣಿ ಬಮ್‌ಭರ‍್ಯು. ");
INSERT INTO vaa_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","ತದೆ ಯೇಸುನೆ ಇವ್ಣುನ, “ಹಮ್ಕೆ ಅನಾಮಾನು ಥೋಡು ಪಾಣಿನ ಕಾಡಿಲಿಜೈ಼ನ್‌, ಖಾಣು-ಪಾಣಿನಿ ಬಾರೇಮ ದೇಖಿಲೇವ್‌ಕರಾಸ್ತೆ ಮೋಟಾನ ದೆವೊ” ಕರಿ ಬೋಲ್ಯೊ. ಇವ್ಣೆ ಲೀಜೈ಼ನ್ ದಿದು, ");
INSERT INTO vaa_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","ತದೆ ಇನೆ ದ್ರಾಕ್ಷಿನು ರಖ್ಹ್‌ ಬಣಿರ‍್ಹುಥೂತೆ ಪಾಣಿನ ಚಾ಼ಖಿ ದೇಖ್ಯೊ. ಯೋ ದ್ರಾಕ್ಷಿನು ರಖ್ಹ್‌ ಕಿಜ್ಗಾ಼ಥು ಆಯು ಕರಿ ಇನ ಮಾಲುಮ್ ಕೋ ಥೂನಿ, ಕತೋಬಿ ಪಾಣಿ ಕಾಡ್ಯುತೆ ಯೋ ಆಳ್‌ ಖ್ಹಾರಾನ ಆ ಮಾಲುಮ್‌ ಥು. ತದೆ ಇನೆ ಯೋ ವ್ಯಹಾನೊ ವ್ಹೆತುಲ್ಡಾನ ಬುಲಾಯು. ");
INSERT INTO vaa_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","ಅಖ್ಖುಜ಼ಣು ಅಛ್ಛು಼ ದ್ರಾಕ್ಷಿನು ರಖ್ಹ್‌ನ ಪಹಿಲೆ ದೀನ್ ನಿಷಾಛ಼ಡಿಗತೊ ತದೆ ಮಾಮುಲಿನ ರಖ್ಹ್‌ನ ದೇಸ್. ತೂತೊ ಅಛ಼್ಛ ದ್ರಾಕ್ಷಿನ ರಖ್ಹ್‌ನ ಹಮ್ಕೆಲಗು ದೀರಾಖ್ಯೊಸ್ ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","ಯೇಸುನೆ ಆ ಪಹಿಲು ಖ್ಹಣೇದ್ನ ಕಾಮ್ನ ಗಲಿಲಾಯನು ಕಾನಾ ಕರಿ ಗಾಮ್ಮಕರ‍್ಯೊ. ಹಿಜ಼್ಜ ಯೇಸು ಇನ ಮಹಿಮೆನ ವತಾಳ್ಯೊ, ಅಜು಼ ಇನ ಶಿಷ್ಯರ್‌ನೆ ಇನಾಪರ್‌ ವಿಶ್ವಾಸ್‌ ಕರ‍್ಯಾ. ");
INSERT INTO vaa_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","ಅನ ಬಾದ್‌ಮ ಯೇಸು, ಇನಿ ಆಯಾ, ಭೈಯೇ ಅಜು಼ ಇನ ಶಿಷ್ಯರ್‌ನಿ ಜೋ಼ಡ್ಮ, ಕಪೆರ್ನೌಮ್ ಕರಿ ಗಾಮ್‌ನ ಜೈ಼ನ್‌, ಥೋಡ ದನ್ ಹಿಜ್ಜಾ಼ ಥಾ. ");
INSERT INTO vaa_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","ಯೆಹೂದ್ಯರ್‌ನ ಪಸ್ಕ ಪೂಜಾ಼ನೊ ದನ್ ಖನ್ನೆ ಐಗೂತೆ ಇನಖ್ಹಾಜೆ, ಯೇಸು ಯೆರೂಸಲೇಮ್‌ನ ಉಪ್ಪರ್ ಗಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","ಹಿಜ್ಜಾ಼ ಮಂದಿರ್‌ಮ ಅದ್ಮಿಖ್ಹಾರು ಢಾಂಡು, ಮೇಂಢು, ಅಜು಼ ಪರ‍್ಯಾವ ವೆಚು಼ಕರ್ತುಥೂತೆ ಯೇಸುನೆ ದೇಖ್ಯೊ, ಅಜು಼ ಪೈಶಾ ತೋಡಾವಾನು ಧಂದೊ ಕರಾವಾಳುಬಿ ಇವ್ಣಿ ಇವ್ಣಿ ಮೇಜ್‌ಪರ್‌ ಬೇಶಿನ್, ಧಂದೊ ಕರುಕರ್ತುಥು. ");
INSERT INTO vaa_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","ಇನಖ್ಹಾಜೆ ಯೇಸುನೆ ಶಿಂದ್ರಾಥಿ ವಾಟಿನ್ ಏಕ್‌ ಕೊಲ್ಡಾನ ಬಣಾಯೊ, ಇನೇಥಿ ಯೋ ಖ್ಹಾರಸ್ ಜಾನ್ವರ್‌ನ, ಢಾಂಡಾನ ಅಜು಼ ಮೇಂಢಾನ ಮಾರಿನ್, ಮಂದಿರ್‌ಮಾಥು ಭಾರ್‌ ಹಕೇಳ್ಯೊ; ಪೈಶಾ ತೋಡಾವಾಳಾನು ಮೇಜ್‌ನ ರಡ್‌ಕೈನ್‌, ಪೈಶ ರಂಚಿದಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","ಪರ‍್ಯಾವೊ ವೇಚ಼ವಾಳಾನ, “ಹಜ್ಜಾ಼ಥು ಅನ ಪಳ್ಳಿ ಜಾ಼ವೊ! ಮಾರ ಬಾನಘರ‍್ನ ಬಜಾ಼ರ್‌ನಿ ಝ಼ಗೊ ಕರಾನು ಭೀರಾಖೊ!” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","ತದೆ, “ತಾರಿ ಮಂದಿರ್‌ಪರ್‌ಲಿ ಘಣಿ ಪ್ಯಾರ್, ಮಾರ ಮಹಿ ಆಗ್‌ನಿಮತ್‌ ಬಳಾಸ್‌” ಕರಿ ವಚನ್‌ಮ ಲೀಖೈರ‍್ಹೂತೆ ಯೋ ವಚನ್ ಶಿಷ್ಯರ್‌ನಿ ಯಾದ್ಮ ಆಯು. ");
INSERT INTO vaa_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","ಯೆಹೂದ್ಯರ್ ಅದಿಕಾರಿನೆ ಯೇಸುನ ಖನ್ನೆ ಐನ್ ಬೋಲ್ಯು,ತೂ ಹಮೂನ ಖಿವು ಅದ್ಭುತ್ ಖ್ಹಣೇದ್‍ನು ಕಾಮ್ನ ಕರಿನ್ ವತಾಳಿಸ್ಕಿ ಅನೇಥಿ ತೂ ಶಾತ್ ಕರುಕರಾಸ್ಕಿ ಇನಿ ಹಕ್ ತುನ ಛಾ಼ ಕರಿ ಸಾಬಿತ್ ಉಷೆ. ");
INSERT INTO vaa_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","ತದೆ ಯೇಸುನೆ, “ಆ ಮಂದಿರ್‌ನ ರಡ್‌ಕೈನಾಖಿದೇವೊ, ಮೇ ತೀನ್ ದನ್ಮ ಅನ ಪಾಛು಼ ಭಾಂದೀಶ್” ಕರಿ ಜವಾಬ್‌ ದಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","ಯೆಹೂದ್ಯರ್‌ನೆ ಇನ, “ಆ ಮಂದಿರ್‌ನ ಭಾಂದಾನ ಛೊ಼ ಉಪ್ಪರ್ ಚಾ಼ಳಿಖ್ಹ್ ವರಖ್ಹ್‌ ಹುಯು! ತೂ ಅನ ತೀನಸ್ ದನ್ಮ ಭಾಂದಾನ ಓಳೆಜಾಸ್ಕಿ‍ ಶು?” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","ಕತೋಬಿ ಯೇಸು ಖಿವಿ ಮಂದಿರ್‌ನಿ ಬಾರೇಮ ಬೋಲುಕ‍ರ್ತೋಥೊ ಯೋ ಇನು ಶೊಂತ್ ಶರೀರ್ ಹುಯಿರುಥು. ");
INSERT INTO vaa_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","ಯೇಸು ಮರೀನ್, ಜಿವ್ತೊಹುಯಿನ್ ಉಠಾನ ಬಾದ್‌ಮ, ಆ ವಾತೆ ಇನ ಶಿಷ್ಯರ್‌ನ ಯಾದ್ಮ ಆಯು, ತದೆ ಇವ್ಣೆ ವಚನ್‌ಮ ಲೀಖೈರ‍್ಹೂತೆ ಅಜು಼ ಯೇಸುನೆ ಬೋಲ್ಯೋತೆ ವಾತೆನ ನಂಬ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","ಯೇಸು ಪಸ್ಕ ಪೂಜಾ಼ನಿ ವಖ್ಹತ್‌ಮ ಯೆರೂಸಲೇಮ್ಮ ಥೊ, ತದೆ ಇನೆ ಕರ‍್ಯೊತೆ ಅದ್ಭುತ್‌ಖ್ಹಾರು ಘಣ ಅದ್ಮಿನೆ ದೇಖಿನ್‌, ಇನ ನಾಮ್‍ಪರ್ ವಿಶ್ವಾಸ್‌ ಕರ‍್ಯು. ");
INSERT INTO vaa_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","ಕತೋಬಿ ಯೇಸುನೆ ಖುದ್ ಇನಾಸ್ ಇವ್ಣಿ ವಿಶ್ವಾಸ್‌ಪರ್ ಮ್ಹೇಲಿದಿದೊಕೊಯ್ನಿ, ಶನಕತೊ ಯೊ ಖ್ಹಾರಸ್ನ ಮಾಲುಮ್‌ ಕರಿರಾಖ್ಯೋಥೊ. ");
INSERT INTO vaa_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","ಯೋ ಹರೇಕ್ ಅದ್ಮಿನ ದಿಲ್ನ ಮಾಯ್ನನ ಮಾಲುಮ್ ಕರಿರಾಖ್ಯೊಥೋತೆ ಇನಖ್ಹಾಜೆ ಕೋಣ್‌ಬಿ ಖೆವ ಅದ್ಮಿನಿ ಬಾರೇಮ ಯೇಸುನ ಸಾಕ್ಷಿ ಬೋಲಿವತಾಳಾನು ಜ಼ರೂರತ್ ಕೋಥೂನಿ. ");
INSERT INTO vaa_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","ಏಕ್‌ ಜ಼ಣೊ ಯೆಹೂದ್ಯವಾಳೊ ಅದಿಕಾರಿ ಹುಯಿರೋಥೊ, ಇನು ನಾಮ್ ನಿಕೊದೇಮ ಅಜು಼ ಯೊ ಫರಿಸಾಯರ್‌ನಿ ಝೂ಼ಂಡ್‌ವಾಳಮ ಏಕ್‍ಜ಼ಣೊ ಹುಯಿರೋಥೊ. ");
INSERT INTO vaa_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","ಯೋ ಏಕ್‌ ರಾತೆ ಯೇಸುಕನ ಐನ್, “ರಬ್ಬಿ, ತು ದೇವ್‍ಥಿ ಆಯೋಹುಯೊ ಫಡಾವವಾಳೊ ಕರಿ ಹಮೂನ ಮಾಲುಮ್‌. ತು ಕರಾತೆ ಖ್ಹಣೇದ್‍ನು ಕಾಮ್ ಕರಾನ, ದೇವ್ನಿ ಮದತ್ ಕೊಯ್ನಿತೆ ಕಿನೇಥೀಬಿ ಕೋ ಹುವಾನಿ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","ಇಮ್‌ ಬೋಲ್ತಾನ ಯೇಸುನೆ, “ಮೇ ತುನ ಖ್ಹಾಚಮಾಬಿ ಬೋಲುಸ್ಕಿ, ಕೋಣ್‌ತೋಬಿ ಏಕ್‌ ಜ಼ಣು ದೇವ್ನಿ ರಾಜ್ಯಮ ಪಾಛು಼ ಪೈದಾ ನಾ ಹುಯೂತೊ, ದೇವ್‌ನು ರಾಜ಼್‌ನ ದೇಖಾನ ಕೋ ಹುವಾನಿ?” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","ತದೆ ನಿಕೊದೇಮನೆ ಯೇಸುನ, “ಏಕ್‌ ಅದ್ಮಿ ಬುಢು ಹುಯಿಜಾ಼ವಪರ್, ಪಾಛು಼ ಪೈದಾ ಹುವಾನ ಕಿಮ್ ಉಷೆ? ಯೋ ಅದ್ಮಿ ಪಾಛು಼ ಇನಿ ಆಯಾನ ಗರಬ್‌ಮ ಪೇಶಿನ್, ಪೈದಾ ಹುವಾನ ಕೋ ಹುವ್ವಾನಿನಿ! ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","ಇಮ್‌ ಬೋಲ್ತಾನ ಯೇಸುನೆ, “ಮೇ ತುನ ಖ್ಹಾಚಮಾಬಿ ಬೋಲುಸ್ಕಿ, ಏಕ್‌ ಅದ್ಮಿ ಪಾಣಿಥೀಬಿ, ಆತ್ಮಥಿ ಪೈದಾ ನಾ ಹುಯೂತೊ, ಯೋ ದೇವ್ನಿ ರಾಜ್ಯಮ ಜಾ಼ಶೇಸ್ ಕೊಯ್ನಿ. ");
INSERT INTO vaa_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","ಏಕ್‌ ಜ಼ಣೊ ಶರೀರ್‌ಥಿ ಪೈದಾ ಹುಯಿರೊಸ್. ಕತೋಬಿ ಆತ್ಮೀಕಥಿ ರ‍್ಹವಾಳೊ ಯೊ ಆತ್ಮಥಿ ಪೈದಾ ಹುವ್ವವಾಳು ಹುಯಿರ‍್ಹುಸ್‍. ");
INSERT INTO vaa_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","ತುಮೆ ನವೇಥಿ ಪೈದಾ ಹೋಣು ಕರಿ ಬೋಲ್ಯೋತೊ ಇನ ಆಶ್ಚರ್ಯ ನಾಖಾವ್ಣು. ");
INSERT INTO vaa_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","ವಹಿರೊ ಇನ ಕಿಮ್ ಹೋಣುಕಿ ತಿಮ್ ವಾಗ್‌ತು ರ‍್ಹೇಸ್‌; ಇನೊ ಅವಾಜ಼್ ತುನ ಖ್ಹಮಜ಼್ ಪಡಾಸ್‌, ಪಣ್ಕಿ ಯೋ ಕಿಜ್ಗಾ಼ಥು ಉಳ್ಯಾವಾಸ್‌ ಅಜು಼ ಕಿಜ್ಗಾ಼ ಉಳ್ಯುಜಾ಼ಸ್‌ ಕರಿ ತುನ ಮಾಲುಮ್‌ ಪಡಾಕೊಯ್ನಿ, ಆತ್ಮಥಿ ಪೈದಾ ಹುವ್ವವಾಳು ಖ್ಹಾರೂಬಿ ಇಮ್ನೀಸ್‌ಘೋಣಿ ಹುಯಿರ‍್ಹೂಸ್” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","ನಿಕೊದೇಮನೆ, “ಆ ಕಿಮ್ ಉಶೆ?’ ಕರಿ ಪುಛಾ಼ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","ಯೇಸುನೆ, “ತೂ ಇಸ್ರಾಯೇಲ್‌ ಅದ್ಮಿನ ಬೋಲಿ ವತಾಳವಾಳೊ ಗುರು ಹುಯಿರ‍್ಹೋಸ್, ತೋಬಿ ತುನ ಆ ಮಾಲುಮ್‌ ಪಡಾಕೊಯ್ನಿಕಿಶೂ? ");
INSERT INTO vaa_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","ಮೇ ತುನ ಖ್ಹಾಚ ಬೋಲುಕರುಸ್: ಹಮೂನ ಮಾಲುಮ್‌ ಛಾ಼ತೆ ಇನಿ ಬಾರೇಮ ಹಮೆ ಬೋಲೆಸ್, ಅಜು಼ ಹಮೆ ದೆಖೇಸ್ತೆ ಇನಿ ಬಾರೇಮ ಸಾಕ್ಷಿ ಬೋಲೆಸ್, ಕತೋಬಿ ತುಮೆ ಹಮೆ ಬೋಲೆಸ್ತೆ ಇನ ಮಾನಕೊಯ್ನಿ. ");
INSERT INTO vaa_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","ಮೆ ಜಗತ್ನಿ ವಾತ್ನಿ ಬಾರೇಮ ಬೋಲ್ಯೋತೊ ತುಮೆ ಇನ ಮಾನಕೊಯ್ನಿ, ಅಮ್ ರ‍್ಹವಾಪರ್ ಮೆ ತುಮೂನ ಸೊರ್ಗನಿ ವಾತೆನ ಬೋಲ್ಯೊತೊ, ತುಮೆ ಕಿಮ್ ವಿಶ್ವಾಸ್‌ ಕರ್ಶು? ");
INSERT INTO vaa_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","“ಸೊರ್ಗಥೊ ಉತ್ರಿನ್ ಆಯೋತೇಸ್‌ ಕತೊ, ಅದ್ಮಿನೊ ಛಿಯ್ಯೋಸ್ ಪಣ್ಕಿ, ಬಿಜು಼ ಕೋಣ್‌ಬಿ ಸೊರ್ಗಾನ ಚ಼ಢೀನ್‌ ಕೋ ಜೈ಼ರ‍್ಹೂನಿ”. ");
INSERT INTO vaa_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","ಮೋಶೆನೆ ಉಜ್ಜಾ಼ಡಿ ಝ಼ಗೋಪರ್‌ ತಾಂಬಾನು ಖ್ಹಾಪ್‍ನ ಊಚ಼ ಖಂಬಾಪರ್‌ ಮ್ಹೇಲ್ಯೋತೆ ಇಮ್ಮಸ್, ಅದ್ಮಿನೊ ಛಿಯ್ಯಾನಾಬಿ ಊಚು಼ ಪಾಡ್ನು. ");
INSERT INTO vaa_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","ಅನೇಥಿ ಇನಾಪರ್‌ ವಿಶ್ವಾಸ್‌ ಕರಾವಾಳು ಹರೇಕ್‌ನ ಹಮೇಶಾನಿ ಜಿ಼ಂದ್‌ಗಿ ಮಳ್‌ಶೆ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","ದೇವ್ನೆ ಆ ಜಗತ್‌ನು ಅದ್ಮಿನ ಕೆತ್ರೇಸ್ಕಿ ಜಾ಼ಖ್ಹತ್ ಪ್ಯಾರ್ ಕರೀನ್, ಇನೊ ಏಕ್‍ನೊ-ಎಕ್ಕಸ್ ಛಿಯ್ಯಾನ ದಿದೊ; ಇನ ನಂಬವಾಳು ಏಕ್‌ಬಿ ಮರ‍್ನುನಾತೆ ಹರೇಕ್ನ ಹಮೇಶಾನಿ ಜಿ಼ಂದ್‌ಗಿ ಮಳ್‌ಣು ಕರಿ ಇನ ದಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","ದೇವ್ನೆ ಇನ ಛಿಯ್ಯಾನ ಮೋಕ್‌ಲ್ಯೊತೆ ಆ ಜಗತ್ನ ಅದ್ಮಿನ ರಕ್ಷಣೆ ಹೋಣುಕರಿ ಮೋಕ್‌ಲ್ಯೊತೆ ಪಣ್ಕಿ, ತೀರ್ಪ್‌ ಕರಾನಖ್ಹಾಜೆ ಕಾಹೆ. ");
INSERT INTO vaa_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","ಇನ ನಂಬವಾಳಾನ ತೀರ್ಪ್‌ ಕೋ ಹೊಯ್ನಿ, ಕತೋಬಿ ನಂಬಕೊಂತೆ ಇನ ತದೇಸ್‌ ತೀರ್ಪ್‌ ಹುಯ್ಗಿ. ಶನಕತೊ ಇನೆ ದೇವ್ನ ಎಕ್ಕಸ್ ಛಿಯ್ಯಾನ ನಾಮ್ನ ಉಪ್ಪರ್ ಭರೋಖ್ಹೊ ಕರ‍್ಯೊಕೊಯ್ನಿ. ");
INSERT INTO vaa_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","ಯೋ ತೀರ್ಪ್‌ ಶಾತ್‌ಕತೊ ಉಜಾ಼ಳು ಜಗತ್‌ಮ ಆಯುತೋಬಿ ಅದ್ಮಿವೊನು ಕಾಮ್ ಖರಾಬ್‍ಥೂತೆ ಇನಖ್ಹಾಜೆ ಇವ್ಣೆ ಉಜಾ಼ಳೇಥಿಬಿ ಅಂಧಾರನ ಪ್ಯಾರ್ ಕರ‍್ಯು. ");
INSERT INTO vaa_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","ಖರಾಬ್‌ನ ಕರಾವಾಳು ಇವ್ಣು ಖರಾಬ್ ಕಾಮ್‍ಅಖ್ಖು ಭಾರ್‌ ಆವ್‍ತುರ‍್ಹೀಶೆಕರಿ ಉಜಾ಼ಳಮ ಆವಕೊಯ್ನಿ ಅಜು಼ ಉಜಾ಼ಳಾನ ವಹೇರ್‌ಕರಸ್. ");
INSERT INTO vaa_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","ಕತೋಬಿ ಖ್ಹಾಚ಼ನ ಲೀನ್ ಚಾ಼ಲವಾಳೊ ಯೋ ದೇವ್‍ಥಿ ಚ಼ಲೈಲ್ಯವಾಳೊ ಹುಯಿರಿನ್ ಇನ ಕಾಮ್ನ ಭಾರ್‌ ಲ್ಯಾವವಾಳೊ ಹುಯಿರೇಸ್. ");
INSERT INTO vaa_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","ಅನ ಬಾದ್‌ಮ, ಯೇಸು ಅಜು಼ ಇನ ಶಿಷ್ಯರ್‌ ಯೂದಾಯ ತಬರ್‌ಖಾನ ಗಯ. ಹಿಜ್ಜಾ಼ ಯೊ ಇವ್ಣ ಶಿಷ್ಯರ್‌ನಿ ಜೋ಼ಡೆ ರ‍್ಹೀನ್, ಬ್ಯಾಪ್ತಿಸ್ಮ ದಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","ಯೋಹಾನಾಬಿ ಸಲೀಮ್‌ ಗಾಮ್‌ನ ಖನ್ನೆ ಥೂತೆ ಐನೋನ್‌ಕನ ಬ್ಯಾಪ್ತಿಸ್ಮ ದೆವ಼್‌ಕರ್ತೋಥೊ. ಶನಕತೊ ಹಿಜ್ಜಾ಼ ಘಣು ಪಾಣಿ ಥೂ; ಅದ್ಮಿಖ್ಹಾರು ಹಿಜ಼್ಜಾಐನ್, ಬ್ಯಾಪ್ತಿಸ್ಮ ಕರೈಲೆವ್‌ ಕರ್ತುಥು. ");
INSERT INTO vaa_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","ತಬ್‌ಲಗು ಯೋಹಾನ ಜೇಲ್‌ಮ ಕೊಘರಾಖ್ಯುಥುನಿ ಹೈರುತೆ ಯೋಹಾನ್ನ ಜೇಲ್‌ಮ ಕೋಂಡಿ ಘಾಲಾನ ಪಹಿಲೇಸ್ ಚಾ಼ಲಿರುಥು. ");
INSERT INTO vaa_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","ಯೋಹಾನ್ನ ಥೋಡ ಶಿಷ್ಯರ್‌ಮ ಅಜು಼ ಏಕ್‌ ಯೆಹೂದ್ಯವಾಳನಿ ಧಾರ್ಮಿಕ ಪದತ್ತಿನಿ ಘೋಣಿನಿ ಅಶ್ನಾನ್‌ಧಾನ್ನಿ ಬಾರೇಮ ಚರ್ಚೆಹುಯು. ");
INSERT INTO vaa_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","ತದೆ ಇವ್ಣೆ ಯೋಹಾನಕನ ಐನ್, “ಗುರು, ಯೊರ್ದನ್‌ ನದ್ದಿನ ಪಾರ್ಲಿಬಾಜು ತಾರಕನ ಥೋತೆ ಏಕ್‍ಜ಼ಣಾನಿ ಬಾರೇಮ ತುನೆ ಸಾಕ್ಷಿ ಬೊಲ್ಯೊನಿ, ಯೋಸ್ ಹಮ್ಕೆ ಅದ್ಮಿಖ್ಹಾರಾನ ಬ್ಯಾಪ್ತಿಸ್ಮ ದೆವ್‌ಕರಾಸ್‌, ಅಜು಼ ಹರೇಕ್ ಜ಼ಣು ಇನಾಕನ ಒಳ್ಯುಜಾ಼ಸ್!” ಕರಿ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","ಯೋಹಾನನೆ ಸೊರ್ಗಥು ತಬ್‍ಲಗು ದೇವ್ ಕೊ ದೇಯ್ನಿಕಿ ತಬ್‍ಲಗು ಖೆವಾಬಿ ಅದ್ಮಿನ ಶಾತ್ಬಿ ಕೊ ಮಳ್‌ಶೇನಿ. ");
INSERT INTO vaa_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","ತುಮೆ ಅಖ್ಖು ಸಾಕ್ಷಿಹುಯಿರಾಸ್, ಮೆ ಬೋಲ್ಯೊಥೊ, “ಮೇ ಕ್ರಿಸ್ತ ಕಾಹೆ, ಕತೋಬಿ ಇನೇಥಿ ಅಗಾಡಿ ಮನ ಮೋಕ್ಲಿರಾಖ್ಯೊಸ್”. ");
INSERT INTO vaa_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","ವ್ಹೆತುಲ್ಡಾನ ಮಳಾಸ್ತೆ ವ್ಹೆತುಲ್ಡೀಸ್, ಕತೋಬಿ ವ್ಹೆತುಲ್ಡಾನೊ ದೋಸ್ ಇನ ಖನ್ನೆ ಭೀರಿನ್‌, ಇನಿ ಅವಾಜ಼್‌ನ ಖ್ಹಮ್‌ಜಿನ್‌ ಘಣು ಖ್ಹುಶಿಕರಸ್. ಆಸ್ ಮನ ಛಾ಼ತೆ ಖ್ಹುಶಿ, ಯೋ ಪೂರ ಹುಯು. ");
INSERT INTO vaa_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","ಯೋ ಉಪ್ಪರ್ ಪಡಾವ್ಣು ಅಜು಼ ಮೇ ಹೇಟೊ ಹೋಣು” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","ಕೋಣ್ ಜ಼ಮೀನ್‌ಪರ್ ಛಾ಼ಕಿ ಯೊ ಜ಼ಮೀನ್ನಿ ವಾತೆನಿ ಬಾರೇಮ ಬೋಲಸ್, ಕತೋಬಿ ಕೋಣ್ ಸೊರ್ಗಥಿ ಆವಾಳೋಕಿ ಯೋ ಖ್ಹಾರೇಥಿ ಮಹಾನ್ ಹುಯಿರ‍್ಹೋಸ್. ಆ ಜಗತ್‌ವಾಳು ಆ ಜಗತ್ನ ಮಳ್ಯೊಹುಯೊ ಹುಯಿರ‍್ಹುಸ್. ");
INSERT INTO vaa_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","ಯೋ ಶಾತ್‌ ದೇಖ್ಯೋಕಿ ಅಜು಼ ಖ್ಹಮ್‌ಜೋಕಿ ಇನಿ ಬಾರೇಮ ಸಾಕ್ಷಿ ಬೋಲಾಸ್, ತೋಬಿ ಇನಿ ಸಾಕ್ಷಿನ ಕೋಣ್‌ಬಿ ಮಾನಕೊಯ್ನಿ. ");
INSERT INTO vaa_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","ಕತೋಬಿ ಕೋಣ್ ಇನಿ ಸಾಕ್ಷಿನ ಮಾನಿಲೇಸ್ಕಿ, ಯೋ ಅಮ್ ಕರಾಥಿ ದೇವ್ ಖ್ಹಾಚು಼ ಕರಿ ಸಾಬಿತ್ ಕರಸ್. ");
INSERT INTO vaa_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","ಶನಕತೊ,ಕಿನದೇವ್‍ನೆ ಮೋಕ್ಲಿ ರಾಖ್ಯೋಸ್ಕಿ, ಯೋ ದೇವ್ನಿ ವಾತೇನ ಬೋಲಾಸ್. ಇನ ದೇವ್ನೆ ಆತ್ಮಥಿ ಭರ್‌ಪೂರ್‌ ಕರಾಸ್. ");
INSERT INTO vaa_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","ಅಜು಼ ಬಾ ಇನ ಲಾಡ್ನ ಛಿಯ್ಯಾನ ಇನಿ ಅಖ್ಖಿ ಅದಿಕಾರ್‌ನ ದೀರಾಖ್ಯೊಸ್. ");
INSERT INTO vaa_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","ಇನ ಛಿಯ್ಯಾನ ನಂಬವಾಳಾನ ಹಮೇಶಾನಿ ಜಿ಼ಂದ್‌ಗಿ ಛಾ಼; ಕತೋಬಿ ಛಿಯ್ಯಾನಿ ವಾತೆನ ಝಿಟ್ಕಾರಸ್ಕಿ ಇವ್ಣುನ ಯೋ ಜಿ಼ಂದ್‌ಗಿ ಮಳ್‌ಶೆ ಕೊಯ್ನಿ, ಅಜು಼ ದೇವ್‌ನೊ ಇರಾದೊ ಇವ್ಣಾಪರ್ ರ‍್ಹಿಶೆ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","ಯೇಸು ಯೋಹಾನ್‌ಥೀಬಿ ಜಾ಼ಖ್ಹತ್ ಶಿಷ್ಯರ್‌ನ ಕರುಕರಸ್, ಇವ್ಣುನ ಬ್ಯಾಪ್ತಿಸ್ಮ ದೆವ್‌ಕರಾಸ್ ಕರಿ ಬೋಲಾನಿ ಖಬರ್ ಫರಿಸಾಯರ್‌ವಾಳು ಖ್ಹಮ್‌ಜ್ಯು. ಆ ಯೇಸುನ ಮಾಲುಮ್ ಪಡ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","ಕತೋಬಿ ಖ್ಹಾಚಮ ಬ್ಯಾಪ್ತಿಸ್ಮ ದೆವ್‌ಕರ್ತೊಥೋತೆ ಯೇಸು ಕಾಹೆ, ಖಲಿ ಇನು ಶಿಷ್ಯರ್‌ ದೆವ್‌ಕರ್‌ತುಥೂತೆ. ");
INSERT INTO vaa_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","ಅದ್ಮಿಖ್ಹಾರು ಬೋಲಾನು ಯೇಸುನೆ ಖ್ಹಮ್‍ಜ್ಯೊತೆ ತದೆ ಯೂದಾಯ ತಬರ್‌ಖಾನ ಮ್ಹೆಂದಿನ್, ಪಾಛು಼ ಗಲಿಲಾಯನ ಚ಼ಲೆಗಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","ಯೋ ಜಾ಼ವಾನಿ ವಖ್ಹತ್‌ಮ, ಸಮಾರ್ಯ ತಬರ್‌ಖಾಪರ್ ಕರಿ ಜಾ಼ವ್ಣುಪಡ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","ಸಮಾರ್ಯನ ಮಳ್ಯುಹುಯು ಸುಖರ್‌ ಕರಿ ಗಾಮ್‌ನ ಆಯೊ, ಯೋ ಗಾಮ್‍ ಯಾಕೋಬ್‍ನೆ ಇನೊ ಛಿಯ್ಯೊ ಯೋಸೇಫನ ದಿದೊತೆ ಝ಼ಗೋನ ಖನ್ನೆ ಥೂ. ");
INSERT INTO vaa_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","ಯಾಕೋಬ್‍ನಿ ಬಾವ್ಡಿ ಹಿಜ್ಜಾ಼ ಥಿ, ಯೇಸು ಚಾ಼ಲಿನ್ ಥಕಿರ‍್ಹೋಥೋತೆ, ಇನಖ್ಹಾಜೆ ಯೋ ಬಾವ್ಡಿಕನ ಐನ್ ಬೇಶಿಗಯೊ. ತದೆ ಕಮ್‍ಶಿಕಮ್ ಧೊಪಾರ್‌ ಹುಯಿರ‍್ಹುಥು. ");
INSERT INTO vaa_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","ಏಕ್‌ ಸಮಾರ್ಯನಿ ತಯೇಡ ಪಾಣಿ ಭರಾನಟೇಕೆ ಹಿಜ್ಜಾ಼ ಆಯಿ, ತದೆ ಯೇಸುನೆ ಇನ, “ಪಿಯ್ಯಾನ ಥೋಡು ಪಾಣಿ ಮಳ್‍ಶೆ?” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","ತದೆ ಇನ ಶಿಷ್ಯರ್‌ ಖಾಣಾನು ರಾಛು಼ಲ್ಯವಾನಟೇಕೆ ಖ್ಹಯೇರ‍್ನ ಜೈ಼ರ‍್ಹೂಥು. ");
INSERT INTO vaa_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","ತದೆ ಯೋ ತಯೇಡಾನೆ, “ತೂ ಯೆಹೂದ್ಯರ್‌ವಾಳೊ, ಅಜು಼ ಮೇ ಸಮಾರ್ಯವಾಳಿ, ಅಮ್ ರ‍್ಹವಾಪರ್ ತೂ ಮಾರಕನ ಪಿಯ್ಯಾನ ಪಾಣಿ ಮಾಂಗೇಜಾ಼ಯ್ಕಿ ಶು?” ಕರಿ ಜಾ಼ವಾಬ್‌ ದಿದಿ. ಯೆಹೂದ್ಯವಾಳು ಸಮಾರ್ಯವಾಳನಿ ಜೋ಼ಡ್ಮ ಖಿವಿ ಸಂಬಂದ್ ರಾಕ್‍ತುಥು ಕೊಯ್ನಿ. ");
INSERT INTO vaa_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","ಯೇಸುನೆ ಯೊ ತಯೇಡನ ಬೋಲ್ಯೊಕಿ, “ತುನ ದೇವ್ನಿ ಬಾರೇಮ ಅತ್ರುಖ್ಹು ಮಾಲುಮ್ ರ‍್ಹಿಯುಹೊತ್ತೊ ಯೊ ಕೋಣ್ ಹುಯಿರೊಸ್, ದೇವ್ ಶಾತ್‌ ದೀರಾಖ್ಯೊಸ್ ಕರಿ, ತುನ ಮಾಲುಮ್ ರ‍್ಹಿಯುಹೊತ್.ತಾರಕನ ಪಿಯ್ಯಾನ ಪಾಣಿ ಮಾಂಗ್ಯೋತೆ ಯೋ ಕೋಣ್ ಕರಿ ಮಾಲುಮ್‌ ರ‍್ಹಯುಹೋತ್ತೊ, ತೂ ಇನಾಕನ ಮಾಂಗಿಲಿದಿಹೊತ್, ಅಜು಼ ಯೋ ತುನ ಜಾನ್ನಪಾಣಿನ ದಿದೋಹೊತ್‌” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","ಯೋ ತಯೇಡ ಇನ, “ಪ್ರಭು, ಪಾಣಿ ಶೇಂದಾನ ತಾರಕನ ಶಾತ್ಬಿ ಕೊಯ್ನಿ, ಬಾವ್ಡಿ ಘಣಿ ಗಧಾರ್ ಛಾ಼, ಅಮ್ ರ‍್ಹವಾಪರ್ ಯೋ ಜಾನ್ನು ಪಾಣಿ ತು ಕಿಮ್ ದಿಶ್? ");
INSERT INTO vaa_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","ಹಮಾರೊ ಗುರು ಯಾಕೋಬಥೀಬಿ ತೂ ಮೋಟೋಕಿ ಶು? ಇನೇಸ್‌ ಆ ಬಾವ್ಡಿನ ಹಮೂನ ದಿದೋತೆ; ಯೋಬಿ ಇನ ಲಡ್ಕಾಬಿ, ಇನೆ ಪಾಳ್ಯೊತೆ ಖ್ಹಾರುಸ್‌ ಜಾನ್ವರ್‌ ಆ ಬಾವ್ಡಿನು ಪಾಣಿ ಪೀದು” ಕರಿ ಬೋಲಿ. ");
INSERT INTO vaa_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","ಯೇಸುನೆ ಅಮ್ ಬೋಲ್ಯೊ, “ಆ ಪಾಣಿನ ಪಿಯ್ಯಾಸ್ತೆ ಹರೇಕ್ನ ಪಾಛು಼ ಠೋಖ್ಹ್‌ ಲಾಗ್‌ಶೆ, ");
INSERT INTO vaa_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","ಕತೋಬಿ ಮೇ ದೆವ್‍ಸ್ತೆ ಪಾಣಿನ ಕೋಣ್ ಪಿಯ್ಯಾಸ್‍ಕಿ ಇವ್ಣುನ ಕದೇಬಿ ಠೋಖ್ಹ್‌ ಲಾಗ್‌ಶೆ ಕೊಯ್ನಿ. ಮೇ ಇನ ದೀಶ್‌ತೆ ಪಾಣಿ ಇವ್ಣಾಮ ಭರೈನ್ ಝ಼ರುಕರ್‌ಶೆ. ಯೋ ಇನ ಹಮೇಶಾನಿ ಜಿ಼ಂದ್‌ಗೀನ ದಿಶೆ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","ಯೋ ತಯೇಡ ಯೇಸುನ, “ಗುರು, ಯೋ ಪಾಣಿನ ಮನ ದೇ! ತದೆ ಮನ ಕದೇಬಿ ಪಾಛು಼ ಠೋಖ್ಹ್‌ ಕೋ ಲಾಗ್‌ಶೇನಿ. ಅಜು಼ ಪಾಣಿ ಶೇಂದಾನ ಹಜ್ಜಾ಼ ಆವಾನಿ ಜ಼ರೂರತ್‌ಬಿ ಕೋ ರ‍್ಹಿಶೇನಿ” ಕರಿ ಬೋಲಿ. ");
INSERT INTO vaa_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","ಯೇಸುನೆ ಇನ, “ಜೈ಼ನ್‌, ತಾರ ಬಾವ್ರಿನ ಹಜ್ಜಾ಼ ಬುಲೈಲಿ ಆವ್” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","ಯೋ ತಯೇಡನೆ, “ಮನ ಬಾವ್ರಿ ಕೊಯ್ನಿ” ಕರಿ ಬೋಲಿ. ಯೇಸುನೆ ಇನ, “ತುನ ಬಾವ್ರಿ ಕೊಯ್ನಿ ಕರಿ ಬೋಲಿತೆ ವಾತೆ ಬರಾಬರಸ್‌. ");
INSERT INTO vaa_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","ತುನ ಪಾಚ಼್ ಜ಼ಣ ಬಾವ್ರಿ ಥಾ, ಅಜು಼ ತೂ ಹಮ್ಕೆ ಕಿನ ಜೋ಼ಡೆ ಛಾ಼ಕಿ ಯೋಬಿ ತಾರೊ ಬಾವ್ರಿ ಕಾಹೆ. ತುನೆ ಮನ ಖ್ಹಾಚಿಸ್ ಬೋಲಿ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","ಯೋ ತಯೇಡಾನೆ, “ಪ್ರಭು, ತೂ ಪ್ರವಾದಿ ಕರಿ ಮನ ದೆಖಾವಸ್” ಕರಿ ಬೋಲಿ. ");
INSERT INTO vaa_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","ಹಮಾರು ಗುರುಖ್ಹಾರು ಆ ಪಹಾಡ್‌ಪರ್ ಆರಾದನೆ ಕರ‍್ಯು, ಆ ನಾಹುಯಿನ್ ಅದ್ಮಿಖ್ಹಾರು ಆರಾದನೆ ಕರ್ನುಥೂತೆ ಝ಼ಗೊ ಯೆರೂಸಲೇಮ್‌ ಕರಿ ಯೆಹೂದ್ಯರ್ ಹುಯಿರ‍್ಹಾತೆ ತುಮೇಸ್ ಬೋಲಾಸ್.” ಕರಿ ಬೋಲಿ. ");
INSERT INTO vaa_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","ಯೇಸುನೆ ಯೊ ತಯೇಡಾನ ಅಮ್ಮ ಮಾರಿ ವಾತ್ನ ನಂಬ್, “ಏಕ್‌ ವಖ್ಹತ್ ಆವ್‌ಶೆ, ಯೋ ವಖ್ಹತ್‌ಮ ತುಮೆ ಬಾನ ಆರಾದನೆ ಕರಾನಖ್ಹಾಜೆ ಆ ಪಹಾಡ್‌ನಾಬಿ ರ‍್ಹವೊ, ಯೆರೂಸಲೇಮ್‌ನಾಬಿ ರ‍್ಹವೊ ಕೋ ಜಾ಼ಶುನಿ. ");
INSERT INTO vaa_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","ತುಮೆ ಸಮಾರಿಯವಾಳ ಕತೋಬಿ ಯೆಹೂದ್ಯರ್ ಹುಯಿರ‍್ಹಾತೆ ಹಮೆ ಕಿನ ಆರಾದನೆ ಕರೇಸ್ ಕರಿ ತುಮುನ ಮಾಲುಮ್‌ ಕೊಯ್ನಿ, ಶನಕತೊ ರಕ್ಷಣೆ ಯೆಹೂದ್ಯರ್‌ಥೀಸ್‌ ಆವ್‌ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","ಖ್ಹಾಚ ಆರಾದನೆ ಕರಾವಾಳು ಬಾನಿ ಆರಾದನೆ ಆತ್ಮಥೀಬಿ, ಖ್ಹಾಚಿಥೀಬಿ ಕರ್ಶೆ, ಯೋ ವಖ್ಹತ್ ಹಂಕೇಸ್‌ ಐಗು. ಬಾ ಇನ ಆರಾದನೆ ಕರಾವಾಳು ಅಮ್ನುಸ್ ರ‍್ಹೇವ್ಣುಕರಿ ಆಖ್ಹ್ ಕರಾಸ್. ");
INSERT INTO vaa_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","ದೇವ್ ಆತ್ಮ ಹುಯಿರ‍್ಹೋಸ್, ಇನ ಆರಾದನೆ ಕರಾವಾಳು ಆತ್ಮಥೀಬಿ, ಖ್ಹಾಚಿಥೀಬಿ ಆರಾದನೆ ಕರವಾಳು ಹುಯಿರೇಣು” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","ಯೋ ತಯೇಡಾನೆ ಇನ, “ಮೆಸ್ಸೀಯ ಆವ್‍ಶೆಕರಿ ಮನ ಮಾಲುಮ್‌ ಯೋಸ್ ಕ್ರಿಸ್ತ, ಅಜು಼ ಯೋ ಆವ್‌ಶೇತೆ ತದೆ ಹಮೂನ ಹರೇಕ್ ಬಾರೇಮ ಬೋಲಿವತಾಳ್‌ಶೆ” ಕರಿ ಬೋಲಿ. ");
INSERT INTO vaa_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","ತದೆ ಯೇಸುನೆ,ಇನ ಬೋಲ್ಯೊ “ತಾರಿ ಜೋ಼ಡೆ ವಾತೆ ಬೋಲುಕರುತೆ ಮೇಸ್ ಯೋ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","ಎತ್ರಾಸ್‌ಮ ಯೇಸುನ ಶಿಷ್ಯರ್‌ ಪಾಛು಼ಫರಿ ಆಯಾ, ಅಜು಼ ಯೇಸು ಏಕ್‌ ತಯೇಡಾನ ಜೋ಼ಡೆ ವಾತೆ ಬೋಲುಕರಾತೆ ದೇಖಿನ್‌, ಇವ್ಣೆ ಘಣು ಆಶ್ಚರ್ಯ ಕರ‍್ಯಾ. ಕತೋಬಿ, “ತುನ ಶಾತ್‌ ಹೋಣು?” ಕರಿ ರ‍್ಹವೊ, “ತೂ ಇನಜೋ಼ಡೆ ಶನ ವಾತೆ ಬೋಲುಕರಾಸ್‌?” ಕರಿ ರ‍್ಹವೊ, ಇವ್ಣಾಮ ಏಕ್‌ ಜ಼ಣಾನೇಬಿ ಕೋ ಫುಛಾ಼ಯಾನಿ. ");
INSERT INTO vaa_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","ತದೆ ಯೋ ತಯೇಡ ಇನಿ ಕೇಳಿನ ಹಿಜ್ಜಾ಼ಸ್ ಮ್ಹೆಂದಿನ್, ಪಾಛು಼ ಫರೀನ್ ಗಾಮ್‌ನ ಮಹಿ ಜೈ಼ನ್‌, ");
INSERT INTO vaa_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“ಮೇ ಹಂಕೆತೋಡಿ ಕರೀತೆ ಖ್ಹಾರಸ್ನ ಬೋಲ್ಯೊತೆ ಏಕ್‌ ಅದ್ಮಿ ಹಿಜ್ಜಾ಼ ಛಾ಼. ಐನ್ ದೇಖೊ, ಯೋಸ್‌ ಕ್ರಿಸ್ತಕಿ ಹುಯಿರೇಣು ಶುಕಿ?” ಕರಿ ಹಿಜ್ಜಾ಼ನು ಅದ್ಮಿ ಖ್ಹಾರಾನ ಬೋಲಿ. ");
INSERT INTO vaa_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","ಇನಖ್ಹಾಜೆ ಅದ್ಮಿಖ್ಹಾರು ಖ್ಹಯೇರ‍್ನ ಮ್ಹೆಂದಿನ್, ಯೇಸುಕನ ಆಯು. ");
INSERT INTO vaa_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","ಎತ್ರಾಸ್‌ಮ ಯೇಸುನ ಶಿಷ್ಯರ್‌, “ಗುರು, ಖಾಣು ಖಾ” ಕರಿ ಗಿಂಗಾಯು. ");
INSERT INTO vaa_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","ಯೇಸುನೆ ಇವ್ಣುನ, “ಮಾರಕನ ಖಾವಾನ ಖಾಣು ಛಾ಼, ಕತೋಬಿ ತುಮೂನ ಇನಿ ಬಾರೇಮ ಮಾಲುಮ್‌ ಕೊಯ್ನಿ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","ತದೆ ಶಿಷ್ಯರ್‌, “ಕೋಣ್‌ತೋಬಿ ಇನ ಪಹಿಲೇಸ್ ಖಾಣು ಲೈನ್‌ ದಿದುಕಿ ಶುಕಿ?” ಕರಿ ಇವ್ಣ-ಇವ್ಣಾಸ್‍ಮ ಪುಛಾ಼ವಲಗ್ಯಾ. ");
INSERT INTO vaa_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","ಯೇಸು ಇವ್ಣುನ ಬೋಲ್ಯೋಕಿ ಮಾರು ಖಾಣು ಶಾತ್‌ಕತೊ ಕೋಣ್ ಮನ ಮೊಕ್‍ಲ್ಯೊಕೀ ಇವ್ಣಿ ಆಖ್ಹ್‌ನ ಪೂರ ಕರಾನುಸ್ ಹುಯಿರುಸ್. ಅಜು಼ ಮನ ದಿದೂತೆ ಯೊ ಕಾಮ್ನ ಪೂರ ಕರ‍್ನು ");
INSERT INTO vaa_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","‘ಖ್ಹುಗ್ಗೀನು ಹಗಾಮ್‌ ಆವಾನ ಬಿಜು಼ ಚಾರ್ ಮಹಿನ ಛಾ಼’ ಕರಿ ತುಮೆ ಬೋಲೋಸ್‌ನಿ. ಕತೋಬಿ ಮೇ ತುಮೂನ ಬೋಲುಸ್ಕಿ, ತುಮಾರ ಡೋಳಾನ ಪಾಡೀನ್, ಖೇತರ್‌ ಭಣಿ ದೇಖೊ; ಯೋ ವ್ಹಡಾವ್ಣಿನ ತೈಯಾರ್ ಛಾ಼! ");
INSERT INTO vaa_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","ವ್ಹಾಡವಾಳನ ಹಮ್ಕೆಸ್‌ ಕೂಲಿ ಮಳ್‌ಶೆ ಅಜು಼ ಯೋ ಹಮೇಶಾನಿ ಜಿ಼ಂದ್‌ಗೀನಖ್ಹಾಜೆ ಅನಾಜ಼್‌ನ ಜ಼ಮ ಕರಾಸ್. ಅಮ್ ಪಿಕಾವವಾಳಾನ ಅಜು಼ ವ್ಹಾಡವಾಳಾನ ಭೇನ ಎಕ್ಕದಮ್‌ ಖ್ಹುಶಿ ಉಷೆ. ");
INSERT INTO vaa_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","‘ಪಿಕಾವವಾಳೊ ಏಕ್‌ ಜ಼ಣೊ, ವ್ಹಾಡವಾಳೊ ಏಕ್‌ ಜ಼ಣೊ’ ಕರಿ ಬೋಲಾಸ್ತೆ ಕಹಾವತ್ ಖ್ಹಾಚಸ್. ");
INSERT INTO vaa_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","ತುಮೆ ಮ್ಹಿನತ್ ಕರ‍್ಯಾಕೊಂತೆ ಅನಾಜ಼್‌ನ ವ್ಹಾಡಾನಟೇಕೆ ಮೇ ತುಮೂನ ಮೋಕ್‌ಲ್ಯೊ; ಬಿಜಾ಼ನೆ ಮ್ಹಿನತ್ ಕರ‍್ಯು, ಇವ್ಣಿ ಮ್ಹಿನಥ್ಥಿ ತುಮೂನ ಫಾಯಿದೊ ಮಳ್ಯು” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","‘ಮೇ ಕರೀತೆ ಖ್ಹಾರಸ್ನ ಇನೆ ಮನ ಬೋಲ್ಯೊ’ ಕರಿ ಸಾಕ್ಷಿಬೋಲಿತೆ ಯೋ ತಯೇಡಾನಿ ವಾತೆನ ಖ್ಹಮ್‌ಜಿನ್‌, ಯೋ ಗಾಮ್‌ನು ಸಮಾರಿಯವಾಳಾಮ ಘಣು ಜ಼ಣು ಯೇಸುನ ನಂಬ್ಯು.” ");
INSERT INTO vaa_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","ಸಮಾರಿಯವಾಳು ಯೇಸುಕನ ಐನ್, ಹಮಾರ ಜೋ಼ಡೆ ರ‍್ಹೇ ಕರಿ ಇನ ಗಿಂಗಾಯು, ಇನಖ್ಹಾಜೆ ಯೇಸು ಬೇದನ್ ಹಿಜ್ಜಾ಼ಸ್ ರ‍್ಹಯಿಗೊ ಥೊ. ");
INSERT INTO vaa_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","ಇನೆ ಬೋಲ್ಯೋತೆ ವಾತೆನ ಖ್ಹಮ್‌ಜಿನ್‌ ಬಿಜೂ಼ಬಿ ಘಣು ಅದ್ಮಿ ನಂಬ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","ಇವ್ಣೆ ಯೊ ತಯೇಡಾನ, ಹಮೆ ಇನ ನಂಬ್ಯಾತೆ ಅಜೂ಼ಬಿ ತಾರಿ ವಾತ್ನ ಉಪ್ಪರ್ ಕಾಹೆ. ಹಮೇಸ್ ಕಾನ್‍ಥಿ ಖ್ಹಮ್‌ಜಿನ್‌ ಇನ ಯೋಸ್ ಖ್ಹಾಚೇಥಿ ಜಗತ್ನ ಬಚಾ಼ಡವಾಳೊಕರಿ ಮಾಲುಮ್ ಕರಿರಾಖ್ಯಾಸ್ ಕರಿ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","ಬೇ ದನ್ ಹಿಜ಼್ಜ ರ‍್ಹವಾನ ಬಾದ್‌ಮ ಯೇಸು ಹಿಜ್ಜಾ಼ಥೊ ಗಲಿಲಾಯನ ಗಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","“ಪ್ರವಾದಿನ ಶೊಂತ್‌ ಗಾಮ್ಮ ಮರ್ಯಾದಿ ಕೊಯ್ನಿ” ಕರಿ ಖ್ಹುದ್ ಯೇಸುನೇಸ್‌ ಬೋಲಿರಾಖ್ಯೋಥೊ. ");
INSERT INTO vaa_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","ತದೆ ಯೇಸು ಗಲಿಲಾಯ ಜಾ಼ವಾಮ, ಗಲಿಲಾಯನು ಅದ್ಮಿಖ್ಹಾರು ಇನ ಸ್ವಾಗತ್ ಕರ‍್ಯು, ಶನಕತೊ ಯೊ ಯೆರೂಸಲೇಮ್ಮಾ ಪೂಜಾ಼ನ ದನ್ಮ ಕರಿರಾಖ್ಯೋಥೊತೆ, ಇವ್ಣೆಅಖ್ಖೂಸ್ ದೇಖಿರಾಖ್ಯೂಥು. ");
INSERT INTO vaa_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","ಯೇಸು ಪಾಛೊ಼ ಗಲಿಲಾಯನು ಕಾನಾ ಗಾಮ್‌ನ ಗಯೊ ಯೊ ಹಿಜ್ಜಾ಼ಸ್ ಇನೆ ಪಾಣಿನ ದ್ರಾಕ್ಷಿನು ರಖ್ಹ್‌ ಬಣಾಯೊಥೊತೆ. ಹಿಜ್ಜಾ಼ ಖ್ಹರ್ಕಾರ್‌ನೊ ಏಕ್‌ ಶೌಕಾರ್ ಅದಿಕಾರಿ ಥೊ. ಇನ ಛಿಯ್ಯಾನ ಕಪೆರ್ನೌಮ್ಮ ಜಾನ್ನ ಅಛ್ಛು಼ ಕೋ ಥೂನಿ. ");
INSERT INTO vaa_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","ಯೇಸು ಯೂದಾಯಥು ಗಲಿಲಾಯನ ಆಯೋತೆ ಖಬರ್‌ ಖ್ಹಮ್‍ಜ್ಯೊ ಶನಕತೊ ಇನೊ ಛಿಯ್ಯೊ ಮರಾನಲಾಗ್ಯೊ ಥೊ, ತದೆ ಯೊ ಯೇಸುಕನ ಜೈ಼ನ್, ಇನ ಛಿಯ್ಯಾನ ಅಛ್ಛು಼ ಕರ‍್ನು ಕರಿ ಗಿಂಗಾಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","ಯೇಸುನೆ ಇನ, “ತುಮೆ ಖ್ಹಣೇದ್‍ನು ಕಾಮ್ನ ಅಜು಼ ಅದ್ಭುತ್‌ಕಾಮ್ನ ದೇಖ್ಯುನಾತೊ ನಂಬಾಸಸ್ ಕೊಯ್ನಿ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","ಯೋ ಅದಿಕಾರಿನೆ, “ಗುರು, ಮಾರೊ ಛಿಯ್ಯೊ ಮರ್‌ವಾನ ಅಗಾಡಿ ತೂ ಮಾರ ಕೇಡೆ ಆವ್” ಕರಿ ಬೋಲಿಲಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","ಯೇಸುನೆ ಇನ, “ಜಾ಼, ತಾರೊ ಛಿಯ್ಯೊ ಜಿವ್‌ಶೆ” ಕರಿ ಬೋಲ್ಯೊ. ಯೋ ಅದ್ಮಿ ಯೇಸುನೆ ಇನ ಬೋಲ್ಯೊತೆ ವಾತೆನ ನಂಬಿನ್, ಚ಼ಲೆಗಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","ಯೋ ಘರೆ ಜಾ಼ವಾನಿ ವಖ್ಹತ್‌ಮ, ಇನೊ ಆಳ್‌ ಐನ್, “ತಾರೊ ಛಿಯ್ಯೊ ಜಿವ್ತೊ ಹುಯಿಗಯೊ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","ತದೆ ಇನೆ, “ಕೆತ್ರ ಘಂಟಾನ ಮಾರ ಛಿಯ್ಯಾನ ಅಛ್ಛು಼ ಹುಯೂತೆ?” ಕರಿ ಇನ ಪುಛಾ಼ವಖ್ಹತರ್, ಇವ್ಣೆ, “ಕಾಲೆ ಧೋಪಾರ್‌ನು ಏಕ್‌ ಘಂಟಾನ ಇನು ತಾವ್ ಉತ್ರಿಗು” ಕರಿ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","“ತಾರೊ ಛಿಯ್ಯೊ ಜಿವ್‌ಶೆ” ಕರಿ ಯೇಸುನೆ ಇನ ಬೋಲ್ಯೊತೆ ವಖ್ಹತ್‌ಮಾಸ್‌ ಅಛ಼್ಛುಹುಯು ಕರಿ ಬಾನೆ ಮಾಲುಮ್‌ ಕರಿಲಿದೊ, ಅಜು಼ ಯೋಬಿ, ಇನ ಘರ್‌ವಾಳು ಖ್ಹಾರು ಯೇಸುನ ನಂಬ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","ಯೇಸು ಯೂದಾಯಥು ಗಲಿಲಾಯ ಆವಾನ ಬಾದ್‌ಮ, ಕರ‍್ಯೊತೆ ಬೇನು ಅದ್ಭುತ್ ಕಾಮ್ ಆ. ");
INSERT INTO vaa_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","ಅನ ಬಾದ್‌ಮ, ಯೇಸು ಯೆಹೂದ್ಯರ್‌ನ ಪೂಜಾ಼ ಥೂತೆ ಇನಖ್ಹಾಜೆ, ಯೇಸು ಯೆರೂಸಲೇಮ್‌ನ ಗಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","ಯೆರೂಸಲೇಮ್ಮ ಮೇಂಢಾನು ಬಾಕಲ್ನಖನ್ನೆ ಏಕ್‌ ಕೋಳಮ್‌ ಥು, ಇಬ್ರಿಯ ವಾತೇಮ ಇನ “ಬೇತ್ಸಥಾ” ಕರಿ ನಾಮ್, ಹಿಜ್ಜಾ಼ ಪಾಚ಼್ ಛ಼ತ್ ಥು ");
INSERT INTO vaa_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","ಯೋ ಛ಼ತ್‌ಕನ ರೋಗ್‌ರಾಯೊ ರ‍್ಹವಾಳು ಘಣು ಅದ್ಮಿ ಪಡ್ಯುರ‍್ಹೇತೂಥು. ಇವ್ಣಾಮ ಕಾಣು, ಲಂಗ್ಡು, ಅಜು಼ ಲಕ್‍ವೊ ಮಾರ‍್ಯುಹುಯು ಥೂ.ಇವ್ಣೆ ಪಾಣಿ ಕದೆ ಹಲ್‍ಶೇಸ್‍ಕರಿ ಟಿವಯ್ ರ‍್ಹೇತುಥು. ");
INSERT INTO vaa_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","ಶನಕತೊ ಹರೇಕ್ ಬಾರ್ ಥೋಡು ವಖ್ಹತ್‌ನ ಬಾದ್‌ಮ ಪ್ರಭುನೊ ದೂತ ಉತ್ರಿ ಐನ್ ಕೋಳಮ್‍ನ ಪಾಣಿನ ಹಲಾವ್‍ತೊಥೊ ರೋಗ್‌ವಾಳು ಕೆಹೂಬಿ ಅದ್ಮಿ ಪಾಣಿ ಹಲಾದಿನ್ ಪಹಿಲೆ ಜಾ಼ತುಥೂಕಿ ಯೊ ಅಛ್ಛು಼ ಹುಯಿಜಾ಼ತುಥು. ");
INSERT INTO vaa_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","ಆಟ್‌ಉಪ್ಪರ್‌ ಡೋಡಿಖ್ಹ್‌ ವರಖ್ಹ್‌ಥೊ ರೋಗ್‌ಮ ಪಡ್ಯೊಥೋತೆ ಏಕ್‌ ಅದ್ಮಿ ಹಿಜ್ಜಾ಼ಥೊ. ");
INSERT INTO vaa_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","ಯೋ ಹಿಜ್ಜಾ಼ ಪಡ್ಯೋತೆ ಯೇಸುನೆ ದೇಖ್ಯೊ, ಯೋ ಘಣ ವರಖ್ಹ್‌ಥು ರೋಗ್‌ಮ ಥೋತೆ ಯೇಸುನ ಮಾಲುಮ್‌ ಥೂ. ಇನಖ್ಹಾಜೆ ಯೇಸುನೆ ಇನ, “ತುನ ಅಛ್ಛು಼ ಹೋಣು ಕರಿ ದಿಲ್‌ ಛಾ಼ ಕಿಶು?” ಕರಿ ಪುಛಾ಼ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","ಯೋ ರೋಗಿನೆ, “ಗುರು, ಪಾಣಿ ಹಲಾನಿ ವಖ್ಹತ್‌ಮ ಕೋಳಮ್ಮ ಮನ ಉತ್ರಾವವಾಳು ಕೋಣ್‌ಬಿ ಕೊಯ್ನಿ; ಮೇ ಉತರ‍್ನು ಕರಿ ಜಾ಼ವಾನ ಪಹಿಲೆಸ್, ಮಾರೇಥಿಬಿ ಅಗಾಡಿ ಬಿಜು಼ ಉತ್ರಿಜಾ಼ಸ್‌” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","ಯೇಸು ಇನ, “ಉಪ್ಪರ್ ಉಟ್, ತಾರಿ ಬಿಛಾ಼ವ್ಣಿನ ಪಳ್ಳಿನ್‌, ಚಾ಼ಲ್” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","ತದ್‌ನು-ತದೇಸ್‌ ಯೋ ಅದ್ಮಿನ ಅಛ್ಛು಼ ಹುಯಿಗಯು; ಇನೆ ಇನಿ ಬಿಛಾ಼ವ್ಣಿನ ಪಳ್ಳಿನ್ ಚಾ಼ಲ್ಯೊ. ತದೆ ಸಬ್ಬತ್‌ ದನ್ ಹುಯಿರುಥು. ");
INSERT INTO vaa_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","ಇನಖ್ಹಾಜೆ ಯೆಹೂದ್ಯರ್‌ನ ಅದಿಕಾರಿ ಯೋ ಅಛ್ಛು಼ ಹುಯೂತೆ ಅದ್ಮಿನ, “ಆಜ಼್ ಸಬ್ಬತ್‌ ದನ್, ಹುಯಿರುತೆ ಇನಾಖ್ಹಾಜೆ ಬಿಛಾ಼ವ್ಣಿನ ಪಾಡಾನು ಹಮಾರಿ ಖಾನುಲ್‌ನು ವಿರೋದ್ ಹುಯಿರ‍್ಹುಸ್‍” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","ತದೆ ಇನೆ, “ಮನ ಅಛ್ಛು಼ ಕರ‍್ಯೊತೆ ಇನೇಸ್‌, ‘ತಾರಿ ಬಿಛಾ಼ವ್ಣಿನ ಪಳ್ಳಿನ್‌, ಚಾ಼ಲ್’ ಕರಿ ಬೋಲ್ಯೊ” ಕರಿ ಜ಼ವಾಬ್ ದಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","ಇವ್ಣೆ ಇನ, “ತಾರಿ ಬಿಛಾ಼ವ್ಣಿನ ಪಳ್ಳಿನ್‌, ಚಾ಼ಲ್ ಕರಿ ತುನ ಬೋಲ್ಯುತೆ ಯೋ ಅದ್ಮಿ ಕೋಣ್?” ಕರಿ ಪುಛಾ಼ಯು. ");
INSERT INTO vaa_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","ಕತೋಬಿ ಯೋ ಅಛ್ಛು಼ ಹುಯೂತೆ ಅದ್ಮಿನ ಯೇಸು ಕೋಣ್ ಕರಿ ಮಾಲುಮ್‌ ಕೋ ಥೂನಿ. ಯೋ ಝ಼ಗೋಪರ್‌ ಅದ್ಮಿನಿ ಭೀಡ್ ಥೀತೆ ಇನಖ್ಹಾಜೆ ಯೇಸು ಹಿಜ್ಜಾ಼ಥೊ ಪಿಷ್‌ಲಿ ಚ಼ಲೆಗಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","ಅನ ಬಾದ್‌ಮ ಯೇಸು ಯೋ ಅದ್ಮಿನ ಮಂದಿರ್‌ಮ ದೇಖಿನ್‌, “ದೇಕ್, ಹಮ್ಕೆ ತುನ ಅಛ್ಛು಼ ಹುಯಿರ‍್ಹುಸ್‍ ಇನಖ್ಹಾಜೆ ಪಾಪ್ ಕರಾನು ಮ್ಹೆಂದೆ,ಶನಕತೊ ಅನೇಥಿ ತುನ ಖೆವೂಬಿ ಜಾ಼ಖ್ಹತ್ ಮುಶಿಬತ್ ನಕೊ ಆವಾದೆ.ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","ತದೆ ಯೋ ಅದ್ಮಿ ಹಿಜ್ಜಾ಼ಥು ಜೈ಼ನ್‌, ಇನ ಅಛ್ಛು಼ ಕರ‍್ಯೊತೆ ಯೇಸುನೇಸ್‌ ಕರಿ ಯೆಹೂದ್ಯರ್‌ನ ಅದಿಕಾರಿನ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","ಇನಾಖ್ಹಾಜೆ ಯೆಹೂದ್ಯವಾಳು ಯೇಸು ಸಬ್ಬತ್‌ ದನ್ಮ ಕಾಮ್ ಕರ‍್ಯೊತೆ ಇನಖ್ಹಾಜೆ, ಇನ ಖ್ಹತಾಯು. ");
INSERT INTO vaa_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","ಕತೋಬಿ ಯೇಸುನೆ ಇವ್ಣುನ, “ಮಾರೊ ಬಾ ಹಂಕೆತೋಡಿ ಕಾಮ್ ಕರುಕರಸ್,ಮೇಬಿ ಕಾಮ್ ಕರುಸ್” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","ಅತ್ರೇಸ್ ಕಾಹೆತೆ ಯೊ ಖಲಿ‍ ಸಬ್ಬತ್‌ ದನ್ನ ನಿಯಮ್ನ ಕೋ ತೋಡ್ಯೊನಿ, ಕತೋಬಿ ಯೊ ದೇವ್ ಇನೊ ಶೊಂತ್ ಬಾಕರಿ ಬೋಲ್ಯೊ ಅಜು಼ ಆಮ್ನಿಘೊಣಿ ಇನುಯೋಸ್ ದೇವ್ನು ಸಮಾನ್ ಕರಿಲಿದೋಥೊ. ಆ ವಾತೇನ ಬೋಲ್ಯೋತೆ ಇನೇಥಿ, ಯೆಹೂದ್ಯರ‍್ನು ಅದಿಕಾರಿ ಇನ ಮಾರ‍್ನುಸ್ ಮಾರ‍್ನು ಕರಿ ಖ್ಹಯಾಲ್‌ಥಿ ನಿರ್ಧಾರ್ ಕರ‍್ಯು. ");
INSERT INTO vaa_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","ತದೆ ಯೇಸುನೆ ಇವ್ಣುನ, “ಮೇ ತುಮೂನ ಖ್ಹಾಚಮಾಬಿ ಬೋಲುಸ್ಕಿ, ಬಾ ಕರಾಸ್ತೆ ಇನ ದೇಖಿನ್‌ ಛಿಯ್ಯೊ ಕರಾಸ್ ಪಣ್ಕಿ, ಇನೇಥಿ ಯೋಸ್‌ ಶಾತ್ಬಿ ಕರಾನ ಕೋ ಹುವಾನಿ. ಬಾ ಕರಾಸ್ತೆ ಇಮ್ಮಸ್ ಛಿಯ್ಯೋಬಿ ಕರಾಸ್. ");
INSERT INTO vaa_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","ಶನಕತೊ, ಬಾ ಇನ ಛಿಯ್ಯಾನ ಪ್ಯಾರ್ ಕರಾಸ್ ಅಜು಼ ಯೋ ಕರಾಸ್ತೆ ಖ್ಹಾರಾನ ಇನ ಒತಾಳಸ್. ಅತ್ರೇಸ್ ಕಾಹೆತೆ ಅನೇಥಿಬಿ ಮೋಟು ಕಾಮ್‌ಖ್ಹಾರು ಇನ ವತಾಳ್‌ಶೆ; ಇನ ದೇಖಿನ್‌ ತುಮೆ ಆಶ್ಚರ್ಯ ಕರ್ಶು. ");
INSERT INTO vaa_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","ಬಾ ಕಿಮ್ ಮರ‍್ಯಹುಯಾನ ಉಠಾಡಿನ್ ಜಾನ್‌ ದೇಸ್ಕಿ, ಇಮ್ಮಸ್ ಛಿಯ್ಯೋಬಿ ಇನ ಹೋಣುತೆ ಇವ್ಣುನ ಜಾನ್‌ ದೇಸ್. ");
INSERT INTO vaa_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","ಅತ್ರೇಸ್ ಕಾಹೆತೆ, ಬಾ ಕಿನಾಬಿ ತೀರ್ಪ್‌ ಕರ್ಶೆ ಕೊಯ್ನಿ. ತೀರ್ಪ್ ಕರಾನಿ ಭರ್‌ಪೂರ್‌ ಅದಿಕಾರ್‌ನ ಛಿಯ್ಯಾನ ದೀರಾಖ್ಯೊಸ್. ");
INSERT INTO vaa_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","ಶನಕತೊ, ತಮಾಮ್‌ ಜ಼ಣು ಬಾನ ಮರ್ಯಾದಿ ವತಾಳಸ್ತೆ ಇಮ್ಮಸ್, ಛಿಯ್ಯಾನಾಬಿ ಮರ್ಯಾದಿ ವತಾಳ್ಣು ಕರಿ ಇನೆ ಅಮ್ ಕರ‍್ಯೊತೆ, ಕೋಣ್ ಛಿಯ್ಯಾನ ಮರ್ಯಾದಿ ದೇಯಿಕೊಯ್ನಿಕಿ ಇವ್ಣೆ ಇನ ಮೋಕ್‌ಲ್ಯೊತೆ ಬಾನಾಬಿ ಮರ್ಯಾದಿ ಕೋ ದೇಯ್ನಿ. ");
INSERT INTO vaa_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“ಮೇ ತುಮೂನ ಖ್ಹಾಚ ಬೋಲುಸ್ಕಿ, ಮಾರಿ ವಾತೇನ ಖ್ಹಮ್‌ಜಿನ್‌, ಮನ ಮೋಕ್‌ಲ್ಯೊತೆ ಇನ ನಂಬವಾಳಾನ ಹಮೇಶಾನಿ ಜಿ಼ಂದ್‌ಗಿ ಮಳಿರ‍್ಹೀಸ್‌. ಇನ ತೀರ್ಪ್ ಕೋ ಉಶೇನಿ; ಯೋ ಮರಣ್ಣ ಉಲಾಂಗಿನ್, ಜಾನ್‌ಮ ಪೇಶಿರ‍್ಹೋಸ್‌. ");
INSERT INTO vaa_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","ಮೇ ತುಮೂನ ಖ್ಹಾಚ ಬೋಲುಸ್ಕಿ, ಮರಿಗಯೂತೆ ಅದ್ಮಿ ದೇವ್ನ ಛಿಯ್ಯಾನಿ ಅವಾಜ಼್ ಖ್ಹಮ್‍ಜಾ಼ನಿ ವಖ್ಹತ್ ಆವ್‌ಶೆ. ಯೋ ವಖ್ಹತ್ ಹಂಕೇಸ್‌ ಐರ‍್ಹೀಸ್, ಖ್ಹಮ್‌ಜಾ಼ವಾಳು ಜಿವ್‌ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","ಬಾನ ಜಾನ್‌ ದ್ಯವಾನಿ ಶಕತ್ ಛಾ಼ತೆ ಇಮ್ಮಸ್, ಛಿಯ್ಯಾನಾಬಿ ಜಾನ್‌ ದ್ಯವಾನಿ ಶಕತ್ನ ದೀರಾಖ್ಯೊಸ್. ");
INSERT INTO vaa_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","ಅಜು಼ ಛಿಯ್ಯೊ, ಅದ್ಮಿನೊ ಛಿಯ್ಯೊ ಹುಯಿರ‍್ಹೋತೆ ಇನಖ್ಹಾಜೆ ತೀರ್ಪ್ ಕರಾನಿ ಹಕ್‌ನ ಬಾನೆ ಇನ ದೀರಾಖ್ಯೊಸ್. ");
INSERT INTO vaa_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","ಅನಿ ಬಾರೇಮ ಆಶ್ಚರ್ಯ ನಕೊ ಕರೊ; ಏಕ್‌ ಹಗಾಮ್‌ ಆವ್‌ಶೆ, ತದೆ ಮಖ್ಹಾಣ್ಯಮ ಛಾ಼ತೆ ಅಖ್ಖು ಇನಿ ಅವಾಜ಼್‌ನ ಖ್ಹಮ್‌ಜಿನ್, ");
INSERT INTO vaa_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","ಅಜು಼ ಇವ್ಣೆ ಮಖ್ಹಾಣ್ಯಥು ಉಠೀನ್ ಆವ್‌ಶೆ, ಕೋಣ್ ಅಛ್ಛಾ಼ನ ಕರ‍್ಯುಕೀ ಇವ್ಣುನ ಹಮೇಶಾನ ಜಾನ್ನಖ್ಹಾಜೆ ಪಾಛು಼ಜಿವ್ತು ಹುಯಿನ್ ಆವ್‌ಶೆ. ಖರಾಬ್ ಕರವಾಳು ತೀರ್ಪ್‌ನಖ್ಹಾಜೆ ಪಾಛು಼ಜಿವಿನ್ ಉಟ್‌ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“ಮಾರು ಮೇಸ್ ಶಾತ್ಬಿ ಕರಾನ ಕೋ ಹುವಾನಿ; ಬಾ ಬೋಲಾತೆ ಇನ ಖ್ಹಮ್‌ಜಿನ್‌, ಮೇ ನ್ಯಾವ್ ಫೇಡಾವುಸ್, ಅನಖ್ಹಾಜೆ ಮಾರು ತೀರ್ಪ್‌ ಖ್ಹಾಚು಼ ಹುಯಿರುಸ್,ಅಜು಼ ಮಾರಿಸ್ ಮರ್ಜಿ ಚಾ಼ಲಾದೆ ಕರಿ ಆಖ್ಹ್ ಕರ‍್ಯೊಕೊಂತೆ, ಮನ ಮೋಕ್‌ಲ್ಯೊತೆ ಇನಿ ಮರ್ಜಿಸ್‌ ಚಾ಼ಲ್ನು ಕರಿ ಮೇ ಆಖ್ಹ್ ಕರುಸ್. ");
INSERT INTO vaa_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","ಮಾರಿ ಬಾರೇಮ ಮೇಸ್ ಸಾಕ್ಷಿ ಬೋಲಿಲಿದೋತೊ ಮಾರಿ ಸಾಕ್ಷಿ ಖ್ಹಾಚಿಸ್ ಕಾಹೆ. ");
INSERT INTO vaa_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","ಕತೋಬಿ ಮಾರಿ ಬಾರೇಮ ಸಾಕ್ಷಿ ಬೋಲವಾಳೊ ಏಕ್‌ ಜ಼ಣೊ ಛಾ಼, ಯೋ ಮಾರಿ ಬಾರೇಮ ಬೋಲಾಸ್ತೆ ಸಾಕ್ಷಿ ಖ್ಹಾಚು಼ ಕರಿ ಮನ ಮಾಲುಮ್‌. ");
INSERT INTO vaa_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","ತುಮೆ ಯೋಹಾನಕನ ಸಂದೇಶ್ ಪುಛೈ಼ಲ್ಯಾವಾಳ ಅದ್ಮಿನ ಮೋಕ್‌ಲ್ಯ, ಇನೆ ತುಮೂನ ಖ್ಹಾಚಿನಿ ಬಾರೇಮ ಸಾಕ್ಷಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","ಮಾರಿ ಬಾರೇಮ ಅದ್ಮಿನಿ ಸಾಕ್ಷಿ ಮನ ಜ಼ರೂರತ್ ಕೊಯ್ನಿ, ತೋಬಿ ತುಮೂನ ರಕ್ಷಣೆಮಳಾದೆ ಕರಿ ಆವಾತ್ನ ಬೋಲ್ಯೋತೆ. ");
INSERT INTO vaa_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","ಯೋಹಾನ ಬಳುಕರಸ್ತೆ ದೀವನಿಮತ್‌ ಥೊ,ಅಜು಼ ಯೊ ಉಜಾ಼ಳು ದಿದೊ. ಕತೋಬಿ ತುಮೆ ಇನ ಉಜಾ಼ಳಾಮ ಥೋಡ ದನ್ ಖ್ಹುಶಿ ಕರ‍್ಯಾ. ");
INSERT INTO vaa_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","ಮಾರಿ ಸಾಕ್ಷಿ ಯೋಹಾನ್‌ಥೀಬಿ ಮೋಟಿ ಸಾಕ್ಷಿ ಹುಯಿರಿಶ್. ಶನಕತೊ ಬಾ ಖೆವುಕಾಮ್ ಪೂರ ಕರಾನ ಮನ ದಿದೊತೆ ಯೋ ಕಾಮ್ನ ಕರುಕರೂಸ್.ಕರಿಬೋಲಾನ ಆ ಕಾಮಸ್ ಸಾಕ್ಷಿ. ");
INSERT INTO vaa_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","ಅತ್ರೇಸ್ ಕಾಹೆತೆ, ಮನ ಮೋಕ್‌ಲ್ಯೊತೆ ಬಾಸ್, ಮಾರಿ ಬಾರೇಮ ಸಾಕ್ಷಿ ಬೋಲಿರಾಖ್ಯೊಸ್. ಕತೋಬಿ ತುಮೆ ಇನಿ ಅವಾಜ಼್‌ನ ಕದೇಬಿ ಖ್ಹಮ್‌ಜಿರಾಖ್ಯಕೊಯ್ನಿ, ಇನಿ ರೂಪ್ ಕಿಮ್ ಛಾ಼ ಕರಿ ಕದೇಬಿ ಕೋ ದೇಖಿರಾಖ್ಯಾನಿ. ");
INSERT INTO vaa_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","ಅಜು಼ ಇನಿ ವಾಕ್ಯಾಬಿ ತುಮಾರಾಮ ಕೊಯ್ನಿ, ಶನಕತೊ ಬಾ ಮೋಕ್‌ಲ್ಯೊತೆ ಇನ ತುಮೆ ನಂಬಾಕೊಯ್ನಿ. ");
INSERT INTO vaa_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","ತುಮೆ ಕೆತ್ರುಕ್ಕಿ ಧರ್ಮಶಾಸ್ತ್ರನ ಪಢೋಸ್‌, ಯೋ ತುಮೂನ ಹಮೇಶಾನಿ ಜಿ಼ಂದ್‌ಗಿ ದಿಶೆ ಕರಿ ತುಮೆ ಸೋಚೋ಼ಸ್, ಕತೋಬಿ ಯೋ ಖ್ಹಾರು ದಪ್ತರ್ ಮಾರಿ ಬಾರೇಮಸ್ ಸಾಕ್ಷಿ ದ್ಯವಾನು ಹುಯಿರುಸ್. ");
INSERT INTO vaa_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","ತೋಬಿ ತುಮೆ ಮಾರಕನ ಐನ್ ಯೋ ಜಾನ್ನ ಲೀಲ್ಯಾವನ ತುಮೂನ ಮನ್‌ಕೊಯ್ನಿ. ");
INSERT INTO vaa_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“ಮನ ಅದ್ಮಿನಿ ಖ್ಹರಾವ್ಣಿ ಹೋಣು ಕೊಯ್ನಿ. ");
INSERT INTO vaa_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","ಕತೋಬಿ ತುಮೆ ಕಿಮ್ನು ಅದ್ಮಿಖ್ಹಾರು ಕರಿ ಮನ ಮಾಲುಮ್, ಅಜು಼ ತುಮಾರ ದಿಲ್ಮ ದೇವ್‌ಪರ್‌ ಪ್ಯಾರ್ ಕೊಯ್ನಿ ಕರೀಬಿ ಮನ ಮಾಲುಮ್. ");
INSERT INTO vaa_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","ಮೇ ಮಾರ ಬಾನ ನಾಮ್‍ಥಿ; ಕತೋಬಿ ಮನ ತುಮೆ ಸ್ವೀಕಾರ್ ಕರಕೊಯ್ನಿ, ಕತೋಬಿ ಕೋಣ್‌ತೋಬಿ ಶೊಂತ್ ಅದಿಕಾರ್‌ಥಿ ಆಯೂತೆ ತುಮೆ ಇನ ಸ್ವೀಕಾರ್ ಕರಿಲೆವೊಸ್. ");
INSERT INTO vaa_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","ತುಮೆ ಏಕ್‌ಥಿ ಏಕ್‌ ಮಾನ್-ಮರ‍್ಯಾದಿನ ಆಖ್ಹ್ ಕರೋಸ್, ಕತೋಬಿ ಏಕ್‍ನೊ ಎಕ್ಕಸ್ ದೇವ್‍ಥಿ ಆವಸ್ತೆ ಖ್ಹರಾವ್ಣಿನ ತುಮೆ ಹೋಣು ಕರಿ ಆಖ್ಹ್ ಕೋ ಕರೋನಿ. ಅಮ್ ರ‍್ಹವಾಪರ್ ತುಮೆ ಮನ ಕಿಮ್ ನಂಬ್‌ಶು? ");
INSERT INTO vaa_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","ಮಾರ ಬಾನ ಖ್ಹಾಮ್ಣೆ ಭೀರಿನ್ ಮೇ, ತುಮುನ ಅಪರಾದಿ ಕರಿ ಭೀರಾಕಿಶ್ ಕರಿ ನಕೊ ಸೋಚೊ ತುಮೆ ಭರೋಖ್ಹೊ ಕರಿರಾಖ್ಯಾತೆ ಮೋಶೆಸ್‌ ತುಮಾರಪರ್ ಅಪರಾದ್ ಲಗಾಡ್‌ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","ತುಮೆ ಖ್ಹಾಚಮಾಬಿ ಮೋಶೆನಿ ವಾತೆನಪರ್ ವಿಶ್ವಾಸ್ ಕರಾನು ರ‍್ಹಿಯಿತೊ, ಮಾರಪರ್‌ಬಿ ಭರೋಖ್ಹೊ ಕರ‍್ಯಾಹೋತ್‌. ಶನಕತೊ ಇನೆ ಮಾರಿ ಬಾರೇಮ ಲೀಖಿರಾಖ್ಯೊಸ್. ");
INSERT INTO vaa_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","ಅಜೂ಼ಬಿ ಮೋಶೆನೆ ಲೀಖ್ಯೋತೆ ವಾತೇನಸ್‌ ತುಮೆ ವಿಶ್ವಾಸ್‌ ನಾ ಕರ‍್ಯಾತೊ, ಮೇ ಬೋಲುಸ್ತೆ ವಾತೆನ ಕಿಮ್ ನಂಬ್ ಶು?” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","ಅನ ಬಾದ್‌ಮ ಯೇಸು ಗಲಿಲಾಯ ದರ‍್ಯಾವ್ನು ಪಾರ್ಲಿ ಬಾಜೂ಼ಮ ಚ಼ಲೆಗಯೊ ಇನ ತಿಬೇರಿಯಾನು ದರ‍್ಯಾವ್ ಕರೀಬಿ ಬೋಲಾಸ್. ");
INSERT INTO vaa_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","ಅದ್ಮಿನಿ ಘಣಿ ಮೋಟಿ ಭೀಡ್ ಯೇಸುನ ಪೀಠೆ ಗಯು, ಶನಕತೊ ಇವ್ಣೆ ಖ್ಹಾರು ಯೇಸುನೆ ರೋಗ್‌ಮ ರ‍್ಹವಾಳನ ಅಛ್ಛು಼ ಕರ‍್ಯೊತೆ ಅದ್ಭುತ್‌ನ ಖ್ಹಾರು ದೇಖ್ಯೂಥು. ");
INSERT INTO vaa_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","ತದೆ ಯೇಸು ಪಹಾಡ್‌ಪರ್ ಚ಼ಢೀನ್, ಇನ ಶಿಷ್ಯರ್‌ನ ಜೋ಼ಡೆ ಬೇಶಿಗಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","ಯೆಹೂದ್ಯರ್‌ನ ಪಸ್ಕ ಪೂಜಾ಼ನಿ ವಖ್ಹತ್ ಖನ್ನೆ ಐಗೈಥಿ. ");
INSERT INTO vaa_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","ಯೇಸುನೆ, ಇನಾಕನ ವಳ್ಯಾವ್‌ತುಥೂತೆ ಅದ್ಮಿನಿ ಮೋಟಿ ಭೀಡ್‌ಣ ದೇಖ್ಯೊ. ಅಜು಼ ಫಿಲಿಪ್ಪನ, “ಆ ಅದ್ಮಿ ಖ್ಹಾರಾನ ಪೂರಯೆತ್ರು ರೋಟಾ ಅಪ್ಣೆ ಕಿಜ್ಗಾ಼ಥು ಲೈಯೆ?” ಕರಿ ಪುಛಾ಼ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","ಫಿಲಿಪ್ಪನ ಪರ್ಖಾನಖ್ಹಾಜೆ ಯೇಸುನೆ ಅಮ್ ಪುಛಾ಼ಯೋತೆ; ಖ್ಹಾಚಿ ಶಾತ್ ಕತೊ, ಯೋ ಶಾತ್‌ ಕರ‍್ನು ಕರಿ ಇನ ಅಗಾಡಿಸ್ ಮಾಲುಮ್‌ ಥೂ. ");
INSERT INTO vaa_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","ತದೆ ಫಿಲಿಪ್ಪನೆ, “ಹಜ಼್ಜ ಛಾ಼ತೆ ಹರೇಕ್ ಅದ್ಮಿನ ಏಕೇಕ್‌ ಟುಕ್‌ಡೊ ರೋಟೊ ದೇಣುಕತೋಬಿ, ಬೇಖ್ಹೊ ರೂಪಾನ ಪಾವ್‍ಲೆಥೀಬಿ ಜಾ಼ಖ್ಹತ್ ಹೋಣು” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","ತದೆ ಯೇಸುನೊ ಬಿಜೇಕ್ ಜ಼ಣೊ ಶಿಷ್ಯ ಹುಯಿರ‍್ಹೊಥೋತೆ, ಸೀಮೋನ್‌ ಪೇತ್ರನೊ ಭೈ ಅಂದ್ರೆಯನೆ, ");
INSERT INTO vaa_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","ಯೇಸುನ, “ಹಜ್ಜಾ಼ ಛಾ಼ತೆ ಏಕ್‌ ಛೋ಼ಕ್ರಕನ ಪಾಚ಼್ ಘೌನ ರೋಟಾ ಅಜು಼ ಬೇ ಮಾಛ಼್‌ಲಾ ಛಾ಼, ಕತೋಬಿ ಅತ್ರಾಖ್ಹಾರ ಅದ್ಮಿನ ಯೋ ಪೂರ್‌ಶೆಕೊಯ್ನಿ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","ಯೇಸುನೆ ಇವ್ಣುನ, “ಅದ್ಮಿನ ಖ್ಹಾರು ಬೇಖ್ಹೊ ಕರಿ ಬೋಲ್” ಕರಿ ಬೋಲ್ಯೊ. ಯೋ ಝ಼ಗೋಪರ್‌ ಘಣು ಘಾಖ್ಹ್‌ ಫುಟಿರ‍್ಹೂಥು. ಅದ್ಮಿಖ್ಹಾರು ಘಾಖ್ಹ್‌ಪರ್‌ ಬೇಶಿಗಯು. ಇವ್ಣಾಮ ಪರ್ಖ್ಹಾ ಅದ್ಮಿಸ್‌ ಕಮ್‌ಶಿಕಮ್ ಪಾಚ಼್ ಹಜಾ಼ರ್‌ಜ಼ಣು ಥೂ. ");
INSERT INTO vaa_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","ಯೇಸುನೆ ಯೋ ರೋಟಾನ ಪಾಡೀನ್, ದೇವ್ನ ಧನ್ಯವಾದ್ ಕರೀನ್, ಹಿಜ್ಜಾ಼ ಬೆಠುಥೂತೆ ಅದ್ಮಿನ ವಾಟಪಾಡಿ ದಿದೊ. ಮಾಛ್ಲಾ಼ನಾಬಿ ಇಮ್ಮಸ್ ವಾಟಪಾಡಿ ದಿದೊ, ತಮಾಮ್‌ ಅದ್ಮಿ ಇವ್ಣುನ ಕೆತ್ರು ಹೋಣುಕಿ ಎತ್ರು ಖಾದು. ");
INSERT INTO vaa_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","ಇವ್ಣೆ ಖ್ಹಾರು ಖೈನ್, ಪೇಟ್ ಭರೈಜಾ಼ವಾನಿ ಬಾದ್‌ಮ ಯೇಸುನೆ ಇನ ಶಿಷ್ಯರ್‌ನ, “ಉಭ್‌ರ‍್ಯುತೆ ಟುಕ್ಡಾವ್‍ನ ಎಕ್ಟು ಕರೊ, ಕೆಹೂಬಿ ಖರಾಬ್ ನಾಹೊಣು” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","ತದೆ ಇವ್ಣೆ ಯೊ ಪಾಚ಼್ ಘೌನ ರೋಟಾನ ಟುಕ್ಡಾವ್‍ನ ಎಕ್ಟು ಕರಾಖ್ಹತರ್, ಭಾರ ಟೋಕ್ರಾ ಭರಾಯು. ");
INSERT INTO vaa_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","ಯೇಸುನೆ ಕರ‍್ಯೊತೆ ಆ ಅದ್ಭುತ್ ದೇಖ್ಯೂತೆ ತದೆ ಅದ್ಮಿಖ್ಹಾರು ಅಮ್ ಬೋಲ್ಯು, “ಖ್ಹಾಚ಼ಮಾಬಿ ಜಗತ್‌ಮ ಆವ್ಣುತೆ ಪ್ರವಾದಿ ಆಸ್ ಹುಯಿರೊಸ್” ಕರಿ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","ಅದ್ಮಿಖ್ಹಾರು ಇನ ಧರೀನ್, ಜು಼ಲಮ್‌ಥಿ ರಾಜ಼ಕರಾನ ಸೋಚುಕರಾಸ್ ಕರಿ ಯೇಸುನೆ ಮಾಲುಮ್‌ ಕರಿಲಿದೊ; ಇನಖ್ಹಾಜೆ ಯೋ ಹಿಜ್ಜಾ಼ಥೊ ಎಕ್ಲೋಸ್ ಪಾಛು಼ ಪಹಾಡ್‌ಪರ್ ಚ಼ಲೆಗಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","ಖ್ಹಾಂಜ಼್ ಹುವ್ವಾದೀನ್, ಯೇಸುನ ಶಿಷ್ಯರ್‌ ದರ‍್ಯಾವ್‌ಕನ ಆಯು. ");
INSERT INTO vaa_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","ಡೋಣ್‌ ಚ಼ಢೀನ್‌, ದರ‍್ಯಾವ್‍ನಿ ಪಾರ್ಲಿ ಬಾಜೂ಼ಮ ಥೂತೆ ಕಪೆರ್ನೌಮ್ಮ ಗಯು. ತದ್ದೇಸ್ ಅಂಧಾರು ಹುಯಿಗಯುಥು, ಅಜು಼ ಯೇಸು ಇವ್ಣಾಕನ ಬಿಜೂ಼ಬಿ ಕೋ ಐರ‍್ಹೋಥೋನಿ. ");
INSERT INTO vaa_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","ತದೆ ಘಣೊ ಮೋಟೊ ವಹಿರೊ ಜೋ಼ರೇಖ್ಹು ವಾಗುಕರ್ತೊಥೋತೆ ಇನಖ್ಹಾಜೆ, ದರ‍್ಯಾವ್‌ಮ ಝೋ಼ಕಾಳೊ ಜಾ಼ಖ್ಹತ್ ಹುವ್ವಾಲಗ್ಯೋಥೊ. ");
INSERT INTO vaa_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","ಇವ್ಣೆ ಡೋಣ್ಣಾ ಹುಟ್ ಘಾಲಿನ್ ಚ಼ಲಾವ್ತಹುಯಿನ್, ತೀನ್‌ಕಿ-ಚಾರ್ ಮೈಲ್ ಜೈ಼ನ್‌ ಪೋಚಾ಼ನ ಬಾದ್‌ಮ ಯೇಸು ಪಾಣಿಪರ್‌ ಚಾ಼ಲ್ತೊಹುಯಿನ್‌ ಡೋಣ್ಣಾ ಖನ್ನೆ ವಳ್ಯಾವಾತೆ ದೇಖಿನ್‌, ಇವ್ಣೆ ಡರಿಗಯಾ. ");
INSERT INTO vaa_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","ಯೇಸುನೆ ಇವ್ಣುನ, “ಡರೊ ನಕೊ, ಯೊ ಮೇಸ್”! ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","ತದೆ ಇವ್ಣೆ ಇನ ಡೋಣ್‌ಮ ಬುಲೈಲ್ಯವಾನ ಕರ‍್ಯಾ, ತದ್‌ನು-ತದ್ದೇಸ್ ಇವ್ಣೆ ಜಾ಼ವ್ಣುಥೂತೆ ಝ಼ಗೋಕನ ಡೋಣ್‌ ಜೈ಼ನ್‌ ಪೋಚಿಗಯ್. ");
INSERT INTO vaa_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","ಇನ ಅಗಲ್ಯದನ್ನೆ ದರ‍್ಯಾವ್‍ನಿ ಪಾರ್ಲಿ ಬಾಜೂ಼ಮ ಥೂತೆ ಅದ್ಮಿಖ್ಹಾರು ಹಿಜ್ಜಾ಼ ಎಕ್ಕಸ್ ಡೋಣ್‌ ಥೀಕರಿ ಇವ್ಣುನ ಮಾಲುಮ್‌ಥು. ಯೋ ಡೋಣ್‌ಮ ಖಲಿ ಶಿಷ್ಯರಸ್‌ ಗಯ, ಯೇಸು ಶಿಷ್ಯರ‍್ನ ಜೋ಼ಡೆ ಕೋ ಗಯೋನಿ ಕರಿ ಇವ್ಣುನ ಮಾಲುಮ್‌ ಥೂ. ");
INSERT INTO vaa_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","ಎತ್ರಾಸ್‌ಮ, ಬಿಜಿ ಡೋಣ್‌ ಖ್ಹಾರು ತಿಬೇರಿಯಾಥು ಐನ್, ಪ್ರಭುನೆ ಧನ್ಯವಾದ್ ಕರೀನ್, ಅದ್ಮಿನ ರೋಟ ಖಡಾಯೋತೆ ಝ಼ಗೋಕನಾಸ್‌ ಆಯು. ");
INSERT INTO vaa_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","ಅದ್ಮಿಖ್ಹಾರು, ಯೇಸುಬಿ ಇನ ಶಿಷ್ಯರ್‌ ಹಿಜ್ಜಾ಼ಕೊಂತೆ ದೇಖಿನ್‌, ಯೋ ಡೋಣೇಮ ಚ಼ಢೀನ್‌, ಯೇಸುನ ಢೂಂಡ್‌ತುಹುಯಿನ್, ಕಪೆರ್ನೌಮ್‌ನ ಗಯು. ");
INSERT INTO vaa_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","ದರ‍್ಯಾವ್‍ನಿ ಪಾರ್ಲಿ ಬಾಜೂ಼ಮ ಯೇಸು ಮಳಾದಿನ್, ಅದ್ಮಿಖ್ಹಾರು ಇನ, “ಗುರು, ತೂ ಕದೆ ಹಜ್ಜಾ಼ ಆಯೊ?” ಕರಿ ಪುಛಾ಼ಯು. ");
INSERT INTO vaa_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","ಯೇಸುನೆ ಇವ್ಣುನ, “ತುಮೂನ ಖ್ಹಾಚಮಾಬಿ ಬೋಲುಸ್ಕಿ, ತುಮೆ ಮನ ಢೂಂಡಾಸ್ತೆ ಮಾರು ಖ್ಹಣೇದ್ ಕಾಮ್ನ ಖ್ಹಾರು ದೇಖಿನ್‌ ಕಾಹೆ ಪಣ್ಕಿ, ಯೋ ರೋಟಾವ್ನ ಖೈನ್, ಪೇಟ್ ಭರೈಲಿದಾತೆ ಇನಖ್ಹಾಜೇಸ್. ");
INSERT INTO vaa_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","ಖ್ಹಡಿಜಾ಼ಸ್ತೆ ಖಾಣಾನಖ್ಹಾಜೆ ನಕೊ ರಾಬೊ; ತುಮೂನ ಹರ್‌ಹಮೇಶಾನಿ ಜಿ಼ಂದ್‌ಗಿ ದ್ಯವಾನ ಹುವಾಸ್ತೆ ಖಾಣಾನಖ್ಹಾಜೆ ರಾಬೊ, ಅಮ್ನು ಖಾಣನ ಅದ್ಮಿನೊ ಛಿಯ್ಯೊ ತುಮೂನ ದಿಶೆ, ಅನಖ್ಹಾಜೆಸ್ ಬಾ ಹುಯಿರ‍್ಹೋತೆ ದೇವ್ನೆ ಇನ ನೇಮಕ್ ಕರ‍್ಯೊ, ಶಾಸನ್ನೊ ಮುದ್ರೊ ಮಾರಿರಾಖ್ಯೋಸ್‌” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","ತದೆ ಅದ್ಮಿಖ್ಹಾರು ಯೇಸುನ, “ಹಮೆ ಕೆಹು ಕಾಮ್ ಕರ‍್ನು ಕರಿ ದೇವ್ ಆಖ್ಹ್ ಕರಾಸ್?” ಕರಿ ಪುಛಾ಼ಯು. ");
INSERT INTO vaa_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","ಯೇಸುನೆ,ಇವ್ಣುನ “ದೇವ್ನೆ ಮೋಕ್‌ಲ್ಯೊತೆ, ತುಮೆ ವಿಶ್ವಾಸ್‌ ಕರ‍್ನು ಕರಿ ಬೋಲಾನುಸ್ ದೇವ್ ತುಮಾರೇಥಿ ಆಖ್ಹ್ ಕರಾಸ್ತೆ ಕಾಮ್” ಕರಿ ಜ಼ವಾಬ್ ದಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","ಇವ್ಣೆ ಇನ, “ಇಮ್‍ಕತೊ, ತೂ ದೇವ್‍ಥಿ ಆಯೊಹುಯೊ ಕರಿ ಹಮೆ ದೇಖಿನ್‌, ತುನ ವಿಶ್ವಾಸ್‌ ಕರಾನಿಘೋಣಿ ಕೆಹು ಖ್ಹಣೇದ್ ಕರಿ ವತಾಳಸ್‌?” ಕರಿ ಪುಛಾ಼ಯು. ");
INSERT INTO vaa_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","“ಹಮಾರ ಗುರುಗುರಬ್‌ಲ್ಯವ್‌ನೆ ಉಜ್ಜಾ಼ಡಿ ಝ಼ಗೋಮ ಮನ್ನಾ ಖಾದು, ಸೊರ್ಗಾಥು ಇವ್ಣುನ ಖಾವಾನಖ್ಹಾಜೆ ಇನೆ ರೋಟೊ ದಿದೊ ಕರಿ ಧರ್ಮಶಾಸ್ತ್ರಮ ಲೀಖೈರ‍್ಹೂಸ್‌ನಿ” ಕರಿ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","ತದೆ ಯೇಸುನೆ ಇವ್ಣುನ, “ತುಮೂನ ಖ್ಹಾಚಮಾಬಿ ಬೋಲುಸ್ಕಿ, ಸೊರ್ಗಾಮ ತುಮೂನ ರೋಟೊ ದಿದೋತೆ ಮೋಶೆನೆ ಕಾಹೆ ಪಣ್ಕಿ ಮಾರೊ ಬಾ ಸೊರ್ಗಾಥು ಖ್ಹಾಚೊ಼ ರೋಟಾನ ದಿಶೆ. ");
INSERT INTO vaa_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","ದೇವ್ ದೇಸ್ತೆ ಯೋ ರೋಟೊ, ಸೊರ್ಗಾಥು ಉತ್ರಿ ಐರ‍್ಹುಥು, ಅಜು಼ ಜಗತ್ನ ಜಾನ್‌ ದೇಸ್. ");
INSERT INTO vaa_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","ತದೆ ಅದ್ಮಿಖ್ಹಾರು, “ಅಲಾ, ಗುರು, ಯೋ ರೋಟಾನ ಹಮೂನ ಹಮೇಶ ದೇ” ಕರಿ ಇನ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","ಯೇಸುನೆ ಇವ್ಣುನ, “ಮೇಸ್ ಜಾನ್ನೊ ರೋಟೊ,‌ ಮಾರಕನ ಆವಾಳಾನ ಕದೇಬಿ ಭುಕ್ ಕೋ ಲಾಗ್‌ಶೇನಿ. ಮಾರಾಮ ವಿಶ್ವಾಸ್‌ ಕರಾವಾಳನ ಕದೇಬಿ ಠೋಖ್ಹ್‌ ಕೋ ಲಾಗ್‌ಶೇನಿ. ");
INSERT INTO vaa_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","ಕತೋಬಿ ತುಮೆ ಮನ ದೇಖ್ಯಾತೋಬಿ, ವಿಶ್ವಾಸ್‌ ಕರ‍್ಯಾಕೊಂತೆ ಛಾ಼ ಕರಿ ಮೇ ಅಗಾಡಿಸ್ ಬೋಲ್ಯೋನಿ. ");
INSERT INTO vaa_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","ಬಾ ಮನ ದೇಸ್ತೆ ಇವ್ಣೆ ಖ್ಹಾರು ಮಾರಕನ ಆವ್‌ಶೆ, ಅಜು಼ ಮಾರಕನ ಆವಾಳಾನ ಪಾಛು಼ಮೇ ಧಕೇಲಿಶ್‌ ಕೊಯ್ನಿ. ");
INSERT INTO vaa_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","ಮೇ ಸೊರ್ಗಾಥು ಉತ್ರಿ ಆಯೋತೆ ಮಾರಿ ಮರ್ಜಿ ಕರಾನ ಕಾಹೆ, ಪಣ್ಕಿ ಮನ ಮೋಕ್‌ಲ್ಯೊತೆ ಇನಿ ಮರ್ಜಿಸ್‌ ಪೂರಕರಾನ. ");
INSERT INTO vaa_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","ದೇವ್ನೆ ಮನ ದಿದೋತೆ ಅದ್ಮಿಮ ಏಕ್‌ನಾಬಿ ಮೇ ಗುಮೈನಾಲೇವ್ಣುತೆ, ಅಂತಿಮ್‌ ದನ್ಮ ಮೇ ಇವ್ಣ ಖ್ಹಾರಾನ ಪಾಛು಼ ಜಿವ್ತು ಉಠಾಡ್ನು ಕರಿ ಬೋಲಾನುಸ್ ದೇವ್ನಿ ಮರ್ಜಿ. ");
INSERT INTO vaa_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","ಇನಾಟೇಕೆ ಛಿಯ್ಯಾನ ದೇಖಿನ್‌, ಇನಾಮ ವಿಶ್ವಾಸ್‌ ಕರಾವಾಳ ಹರೇಕ್ನ ಹರ್‌ಹಮೇಶಾನಿ ಜಿ಼ಂದ್‌ಗಿ ಮಳ್‌ಣು ಕರಿ ಬೋಲಾನು ಬಾನಿ ಮರ್ಜಿ ಹುಯಿರ‍್ಹುಸ್‍, ಅಜು಼ ಖ್ಹರ್ತಿನ ದನ್ಮ ಮೇ ಇವ್ಣುನ ಪಾಛು಼ ಜಿವ್ತು ಉಠಾಡಿಶ್‌” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","ಯೇಸುನೆ, “ಸೊರ್ಗಾಥು ಉತ್ರಿನ್ ಆಯೋತೆ ರೋಟೊ ಮೇಸ್” ಕರಿ ಬೋಲ್ಯೋತೆ ಇನಖ್ಹಾಜೆ, ಯೆಹೂದ್ಯವಾಳು ಇನಿ ಬಾರೇಮ ಮಶ್ಲಾ ಮಾರ‍್ಯು. ");
INSERT INTO vaa_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","ಅಜು಼, “ಆ ಯೋಸೇಫ್‍ನೊ ಛಿಯ್ಯೊ ಯೇಸು ಕಾಹೆಕಿ ಶು? ಅನ ಆಯಾ-ಬಾ ಅಪ್ಣುನ ಮಾಲುಮ್‌ನಿ? ಹಮ್ಕೆ ಆ, ಪರ್‌ಲೋಕ್‌ಥು ಉತ್ರಿನ್ ಆಯೊ ಕರಿ ಬೋಲಾಸ್ತೆ ಕಿಮ್?” ಕರಿ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","ತದೆ ಯೇಸುನೆ ಇವ್ಣುನ, “ತುಮಾರ ತುಮಾರಮ ಭಣ್‍ಕಾನು ಭೀರಾಖೊ.” ");
INSERT INTO vaa_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","ಮನ ಮೋಕ್‌ಲ್ಯೊತೆ ಬಾ ಮಾರಕನ ಅದ್ಮಿನ ಮೋಕ್ಲಾಸ್‌; ಅಜು಼ ಮೇ ಇವ್ಣುನ ಖ್ಹರ್ತಿನ ದನ್ಮ ಜಿವ್ತು ಉಠಾಡಿಶ್‌, ಬಾನೆ ಮೋಕ್‌ಲ್ಯೊಕೊಂತೆ ಕೋಣ್‌ಬಿ ಮಾರಕನ ಆವಾನ ಕೋ ಹುವಾನಿ. ");
INSERT INTO vaa_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","ಪ್ರವಾದಿಖ್ಹಾರು ಲೀಖಿರಾಖ್ಯುಸ್, ಅಜು಼ ಇವ್ಣೆಖ್ಹಾರು ದೇವ್‍ಥಿ ಶಿಕಿಹುಯು ಹುಯಿರ‍್ಹಿಶೆ, ಕೋಣ್ ಬಾಥಿ ಖ್ಹಮ್‌ಜಿನ್‌ ಶಿಕಾಸ್ಕಿ ಯೊ ಮಾರಕನ ಆವಸ್. ");
INSERT INTO vaa_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","ಅನಿ ಮತ್‌ಲಬ್, ಕೋಣ್ ತೋಬಿ ಬಾನ ದೇಖಿರಾಖ್ಯುಸ್‌ ಕರಿ ಕಾಹೆ, ದೇವ್‌ಕಂಥೊ ಆಯೋತೆ ಎಕ್ಕಸ್ ಜ಼ಣಾನೆ ಬಾನ ದೇಖಿರಾಖ್ಯೊಸ್. ");
INSERT INTO vaa_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","ಮೇ ತುಮೂನ ಖ್ಹಾಚಮಾಬಿ ಬೋಲುಸ್ಕಿ, ಕೋಣ್ ವಿಶ್ವಾಸ್‌ ಕರಾಸ್ಕಿ, ಇವ್ಣುನ ಹರ್‌ಹಮೇಶಾನಿ ಜಿ಼ಂದ್‌ಗಿ ಮಳಿರ‍್ಹಿಶೆ. ");
INSERT INTO vaa_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","ಮೇಸ್ ಜಾನ್ನೊ ರೋಟೊ. ");
INSERT INTO vaa_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","ತುಮಾರ ಗುರುಗುರಬ್‌ಲ್ಯ ಉಜ್ಜಾ಼ಡಿ ಝ಼ಗೋಮ ಮನ್ನಾ ಖಾದು, ಅಜು಼ ಇವ್ಣೆ ಮರಿಗಯು. ");
INSERT INTO vaa_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","ಸೊರ್ಗಾಥು ಉತ್ರಿನ್ ಆಯೋತೆ ರೋಟೊ ಕೋಣ್ ಕೋಣ್‍ಖಾಸ್ಕಿ, ಇವ್ಣೆ ಮರ್‌ಶೆ ಕೊಯ್ನಿ. ");
INSERT INTO vaa_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","ಕತೋಬಿ ಸೊರ್ಗಾಥು ಉತ್ರಿ ಆಯೋತೆ ರೋಟೊ ಕೋಣ್ ಖಾಸ್ಕಿ ಯೊ ಮರಕೊಯ್ನಿ. ಹರ್‌ಹಮೇಶ ಜಿವ್ತು ರ‍್ಹಿಶೆ; ಅಜು಼ ಮೇ ದೆವ್‍ಸ್ತೆ ರೋಟೊ ಮಾರಿ ಬೋಟಿಸ್‌, ಆ ಜಗತ್‌ ಜಿವಾದೆ ಕರಿ ಮೇ ಅನ ದೀಶ್‌ತೆ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","ತದೆ ಯೆಹೂದ್ಯವಾಳು, “ಆ ಅದ್ಮಿ ಇನಿ ಬೋಟಿನ ಅಪ್ಣುನ ಕಿಮ್ ಖವಾನ ದಿಶೆ?” ಕರಿ ಇವ್ಣ-ಇವ್ಣ ಮಹಿಸ್ ಅಬ್ಬಾಜ಼ಬ್ಬಿ ವಾತೆ ಕರಾಲಗ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","ಯೇಸುನೆ ಇವ್ಣುನ, “ಮೇ ತುಮೂನ ಖ್ಹಾಚಮಾಬಿ ಬೋಲುಸ್ಕಿ, ತುಮೆ ಅದ್ಮಿನೊ ಛಿಯ್ಯಾನು ಬೋಟಿನ ನಾ ಖಾದಾತೊ, ಅಜು಼ ಇನು ಲ್ಹೋಯಿನ ನಾ ಪೀದಾತೊ ತುಮಾರ ಮಹಿ ಜಾನ್‌ ಕೊ ರ‍್ಹಿಶೇನಿ. ");
INSERT INTO vaa_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","ಕೋಣ್ ಮಾರಿ ಬೋಟಿನ ಖಾಸ್ಕಿ, ಮಾರು ಲ್ಹೋಯಿನ ಪಿಯ್ಯಾಸ್‍ಕಿ ಇವ್ಣುನ ಹರ್‌ಹಮೇಶಾನಿ ಜಿ಼ಂದ್‌ಗಿ ಛಾ಼, ಅಜು಼ ಮೇ ಇನ ಖ್ಹರ್ತಿನ ದನ್ಮ ಜಿವ್ತು ಉಠಾಡಿಶ್‌. ");
INSERT INTO vaa_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","ಮಾರಿ ಬೋಟಿ ಖ್ಹಾಚ ಖಾಣು ಅಜು಼ ಮಾರು ಲ್ಹೋಯಿ ಖ್ಹಾಚ ಪಾನ್ಕ ಹುಯಿರ‍್ಹುಸ್‍. ");
INSERT INTO vaa_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","ಮಾರಿ ಬೋಟಿನ ಖೈನ್, ಮಾರೂ ಲ್ಹೋಯಿನ ಪಿಯ್ಯಾವಾಳು ಯೊ ಮಾರಾಮ ರ‍್ಹೇಸ್‌, ಅಜು಼ ಮೇ ಇವ್ಣಾಮ ಜಿವಿರ‍್ಹೀಶ್‌. ");
INSERT INTO vaa_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","ಜಿವ್ತೊ ಹುಯಿರ‍್ಹೋತೆ ಬಾನೆ ಮನ ಮೋಕ್ಲಿರಾಖ್ಯೊಸ್, ಅಜು಼ ಮೇ ಇನೇಥಿಸ್ ಜಿವ್‌ಸ್‌. ಇನಖ್ಹಾಜೆ ಕೋಣ್ ಮನ ಖಾಸ್ಕಿ ಯೋ ಮಾರೇಥಿ ಜಿವ್‌ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","ಹೈರುತೆ ಸೊರ್ಗಾಥು ಉತ್ರಿ ಆಯೋತೆ ರೋಟೊ ಆಸ್. ತುಮಾರ ಗುರುಗುರಬ್‌ಲ್ಯ ಮನ್ನಾ ಖಾದು ಅಜು಼ ಮರಿಗಯು. ಕತೋಬಿ ಕೋಣ್ ಆ ರೋಟಾನ ಖಾಸ್ಕಿ ಯೋ ಕದೇಬಿ ಜಿವ್ತೊ ರ‍್ಹಿಶೆ.” ");
INSERT INTO vaa_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","ಯೇಸುನೆ ಕಪೆರ್ನೌಮ್‌ನು ಸಭೆ ಭರಾವನು ಮಂದಿರ್‌ಮ ಆ ಖ್ಹಾರು ಬೋಲಿವತಾಳ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","ಅನ ಖ್ಹಮ್‌ಜಿನ್‌, ಇನ ಶಿಷ್ಯರ್‌ಮ ಘಣು ಜ಼ಣು, “ಆ ಜಾ಼ಖ್ಹತ್ ಕಠಣ್ಣಿ ವಾತ್ ಅನ ಕೋಣ್ ಖ್ಹಮಜ಼್‌ಶೆ” ಕರಿ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","ಇನ ಶಿಷ್ಯರ್‌ ಅನಿ ಬಾರೇಮ ಮಶ್ಲಾ ಮಾರುಕರಸ್ ಕರಿ ಯೇಸುನೆ ಮಾಲುಮ್‌ ಕರಿಲೀನ್, “ಆ ವಾತೇಥಿ ತುಮಾರ ದಿಲ್ನ ಟೋಚಾ಼ಯುಕಿ ಶು? ");
INSERT INTO vaa_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","ಏಕ್‌ ಬಾರ್ ತುಮೆ, ಅದ್ಮಿನೊ ಛಿಯ್ಯಾನ ಪಹಿಲೆ ಕಿಜ್ಜಾ಼ಥೋಕಿ ಹಿಜ಼್ಜ ಜಾ಼ಶೇತೆ ಇನ ದೇಖ್ಯಾತೊ ತುಮೆ ಶಾತ್‌ ಕರ್‌ ಶು? ");
INSERT INTO vaa_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","ಜಾನ್‌ ದೇಸ್ತೆ ದೇವ್‌ನು ಆತ್ಮ ಹುಯಿರುಸ್ ಅದ್ಮಿನು ಹಿಮ್ಮಥ್ಥಿ ಫಾಯಿದೊ ಕೊಯ್ನಿ; ಮೇ ತುಮೂನ ಖಿವು ವಾತ್ನ ಬೋಲ್ಯೋಕಿ ಯೊ ದೇವ್‌ನೊ ಆತ್ಮ ಹುಯಿರ‍್ಹೂಸ್. ಅಜು಼ ಯೋ ಜಾನ್ನ ದೇಸ್. ");
INSERT INTO vaa_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","ತೋಬಿ ತುಮಾರಾಮ ಥೋಡು ಜ಼ಣು ನಂಬಾಕೊಯ್ನಿ” ಕರಿ ಬೋಲ್ಯೊ. ಕೋಣ್ ಇನ ನಂಬುಕರಾಕೊಯ್ನಿ ಅಜು಼ ಕೋಣ್ ಇನ ಧೋಕೇಥಿ ಧರಿದಿಶೇತೆ ಕರಿ ಬೋಲಾನು ಪಹಿಲೇಥುಸ್ ಯೇಸುನ ಮಾಲುಮ್‌ ಥೂ. ");
INSERT INTO vaa_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","ಅಜು಼ ಯೇಸುನೆ ಬೋಲ್ತೊ ಹುಯಿನ್, “ಬಾನಿ ಮರ್ಜಿಕೊಂತೆ ಕೋಣ್‌ಬಿ ಮಾರಕನ ಆವಾನ ಕೋ ಹುವಾನಿ ಕರಿ ಮೇ ತುಮೂನ ಬೋಲ್ಯೊತೆ ಅನಾಖ್ಹಾಜೆ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","ತಪ್‌ಥು ಇನ ಶಿಷ್ಯರ್‌ಮ ಕೈಏಕ್ ಜ಼ಣು ಇನ ಮ್ಹೆಂದಿನ್ ಚ಼ಲಿಗಯು ಅಜು಼ ಯೇಸುನಿ ಜೋ಼ಡ್ಮ ಆವವಾಳು ಘಣುಜ಼ಣು ಇನ ಮ್ಹೆಂದಿನ್ ಪಾಛು಼ ಚ಼ಲಿಗಯು. ");
INSERT INTO vaa_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","ತದೆ ಯೇಸುನೆ ಇನ ಭಾರ ಶಿಷ್ಯರ್‌ನ, “ತುಮೇಬಿ ಚ಼ಲಜಾ಼ವ್ಣು ಕರಿ ಛಾ಼ಕಿ ಶು?” ಕರಿ ಪುಛಾ಼ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","ಸೀಮೋನ್‌ ಪೇತ್ರನೆ ಯೇಸುನ, “ಪ್ರಭು, ತುನ ಮ್ಹೆಂದಿನ್ ಹಮೆ ಕಿಜ್ಗಾ಼ ಜ಼ಯ್ಯೆ? ತಾರಕನ ಹರ್‌ಹಮೇಶಾನಿ ಜಿ಼ಂದ್‌ಗಿ ದ್ಯವಾನಿ ವಾತೆ ಛಾ಼. ");
INSERT INTO vaa_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","ಹಮೆ ತಾರಾಮ ವಿಶ್ವಾಸ್‌ ಕರಿಯೇಸ್, ಅಜು಼ ತೂ ದೇವ್‍ಥಿ ಆಯೋತೆ ಪರಿಶುದ್ ಅದ್ಮಿ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","ತದೆ ಯೇಸುನೆ, “ತುಮುನ ಭಾರ ಜ಼ಣಾನ ಮೇ ಚೂ಼ಣಿನ್ ಕಾಡ್ಯೊಕೊಯ್ನಿಕಿ ಶು? ರ‍್ಹಯುತೋಬಿ ತುಮಾರಾಮ ಏಕ್‌ ಜ಼ಣೊ ಶೈತಾನ್ ಹುಯಿರ‍್ಹೋಸ್” ಕರಿ ಜವಾಬ್‌ ದಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","ಯೇಸುನೆ ಸೀಮೋನ್ ಇಸ್ಕರಿಯೋತನೊ ಛಿಯ್ಯೊ ಹುಯಿರೋತೆ ಯೂದನಿ ಬಾರೇಮ ಆ ವಾತೆ ಬೋಲ್ಯೋತೆ. ಯೂದ ಭಾರ ಜ಼ಣ ಶಿಷ್ಯರ್‌ಮ ಏಕ್‍ಜ಼ಣೊ ಹುಯಿರೋಥೊ, ಯೇಸುನ ದೋಕೇಥಿ ಧರಿದೆವಾಳೊ ಯೋಸ್. ");
INSERT INTO vaa_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","ಆ ಖ್ಹಾರು ಹುವಾನ ಬಾದ್‌ಮ, ಯೇಸು ಗಲಿಲಾಯಮ ಫರುಕರ್ತೊಥೊ; ಯೆಹೂದ್ಯವಾಳು ಇನ ಮಾರಿನಾಖಾನ ಟಿವವ್‍ಕರ್ತೂಥು ಇನಖ್ಹಾಜೆ, ಯೂದಾಯಮ ಫರಾನ ಇನ ಮನ್ ಕೋ ಥೂನಿ. ");
INSERT INTO vaa_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","ಯೆಹೂದ್ಯರ್‌ನ ಡೆರಾನ ಘರ್ನಿಪೂಜಾ಼ನಿ ವಖ್ಹತ್ ಖನ್ನೆ ಐಗಿಥಿ. ");
INSERT INTO vaa_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","ಇನಖ್ಹಾಜೆ ಯೇಸುನ ಭೈಯೇ ಇನ, “ತೂ ಕರಾನು ಕಾಮ್‌ಖ್ಹಾರು ತಾರು ಶಿಷ್ಯರ್‌ಬಿ ದೇಖಾನ ಖ್ಹಾಜೆ, ಗಲಿಲಾಯ ಮ್ಹೇಲಿನ್ ಯೂದಾಯಾನ ಜಾ಼.ಕರಿ ಬೋಲಾಖ್ಹತರ್ ");
INSERT INTO vaa_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","ಖಿವು ಏಕ್‍ಜ಼ಣೊ ಅದ್ಮಿಮ ವತಾಳಿಲೇವ್ಣು ಕರಿ ಇಷ್ಟ ಪಡಸ್‍ಕಿ ಯೋ ಇನಕಾಮ್‍ನ ಲಪಾಡಿನ್ ಕರಾಕೊಯ್ನಿ. ಶನಕತೊ ತೂ ಅದ್ಭುತ್ ಕಾಮ್ನ ಕರಾಸ್, ಇನಖ್ಹಾಜೆ, ಆ ಜಗತ್ನ ಖ್ಹಾಮ್ಣೆ ತಾರುತೂಸ್ ವತಾಳಿಲೆ” ಕರಿ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","ಯೇಸುನ ಭೈಯೇಬಿ ಇನ ನಂಬ್‍ತುಥು ಕೊಯ್ನಿ. ");
INSERT INTO vaa_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","ಯೇಸುನೆ ಇವ್ಣುನ, “ಮಾರಿ ವಖ್ಹತ್ ಬಿಜೂ಼ಬಿ ಕೋ ಆಯಿನಿ. ಕತೋಬಿ ತುಮಾರಿ ವಖ್ಹತ್ ಕದೇಬಿ ತೈಯಾರ್ ರ‍್ಹೇಸ್. ");
INSERT INTO vaa_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","ಆ ಜಗತ್‌ ತುಮೂನ ವಹೇರ್‌ ಕರಾನ ಕೊ ಹೊಯ್ನಿ, ಕತೋಬಿ ಮೇ ಇನಿ ಕಾಮ್ ಅಖ್ಖಾನ ಖರಾಬ್ ಕರಿ ಸಾಕ್ಷಿಬೋಲುಸ್ತೆ ಇನಖ್ಹಾಜೆ ಯೋ ಮನ ವಹೇರ್‌ ಕರಾಸ್. ");
INSERT INTO vaa_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","ತುಮೇಸ್ ಪೂಜಾ಼ನ ಜಾ಼ವೊ. ಮನ ಬಿಜೂ಼ಬಿ ಬರಾಬರ್‌ನಿ ವಖ್ಹತ್ ಕೋಆಯಿನ್ತೆ ಇನಖ್ಹಾಜೆ, ಮೇ ಆ ಪೂಜಾ಼ನ ಆವ್‌ಕೊಯ್ನಿ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","ಆ ಬೋಲಾನ ಬಾದ್‌ಮ, ಯೋ ಗಲಿಲಾಯಮಸ್‌ ರಹಿಗೊ. ");
INSERT INTO vaa_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","ಇನ ಭೈಯೇ ಜಾ಼ವಾನ ಬಾದ್‌ಮ, ಯೇಸುಬಿ ಪೂಜಾ಼ನ, ಅದ್ಮಿನ ದೆಖಾವ್ಣುನಾತೆ ತಿಮ್, ಲಪೀನ್ ಗಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","ಪೂಜಾ಼ಮ ಯೆಹೂದ್ಯರ್‌ನ ಅದಿಕಾರಿ, “ಯೇಸು ಕಿಜ್ಗಾ಼ ಛಾ಼?” ಕರಿ ಪುಛಾ಼ವ್ತುಹುಯಿನ್‌, ಇನ ಢೂಂಡುಕರ್ತುಥು. ");
INSERT INTO vaa_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","ಅಜು಼ ಅದ್ಮಿನಿ ಝೂ಼ಂಡೇಮ ಯೇಸುನಿ ಬಾರೇಮ ಮಹಿ-ಮಹಿಸ್ ಗುಣ್‍ಗುಣೈನ್ ಬೋಲುಕರ್ತೂಥು. ಥೋಡು ಜ಼ಣು, “ಯೋ ಅಛ್ಛೊ಼” ಕರಿ ಬೋಲ್ಯು. ಅಜು಼ ಥೋಡು ಜ಼ಣು, “ಕೊಯ್ನಿ, ಯೋ ಅದ್ಮಿನ ಮಂಕ್ ಕರುಕರಸ್” ಕರಿ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","ಕತೋಬಿ ಕೋಣ್‌ಬಿ ಇನಿ ಬಾರೇಮ ಭಾಲ್‌ಥಿ ವಾತೆ ಕೋ ಬೋಲ್ಯೂನಿ.ಶನಕತೊ ಯೆಹೂದ್ಯರ್‌ನ ಅದಿಕಾರಿಥಿ ಡರುಕರ್ತುಥು. ");
INSERT INTO vaa_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","ಪೂಜಾ಼ ಖನ್ನೆ-ಖನ್ನೆ ಆಧು ಖತಮ್ ಹುವಾನ ಬಾದ್‌ಮ, ಯೇಸು ಮಂದಿರ್‌ಮ ಜೈ಼ನ್‌ ವಚನ್ ಬೋಲಿ ದೆವಾಲಗ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","ತದೆ ಯೆಹೂದ್ಯರ‍್ನು ಅದಿಕಾರಿಖ್ಹಾರು, “ಪಢ್ಯೊ-ಲೀಖ್ಯೊಕೊಂತೆ ಅನ, ಅತ್ರುಖ್ಹಾರು ಮಾಲುಮ್‌ಛಾ಼ತೆ ಕಿಮ್?” ಕರಿ ಬೋಲಿನ್ ಆಶ್ಚರ್ಯ ಕರ‍್ಯು. ");
INSERT INTO vaa_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","ಯೇಸುನೆ, “ಮೇ ಶಿಕಾಡುಸ್ತೆ ಮಾರಿ ವಚನ್ ಕಾಹೆ ಪಣ್ಕಿ, ಮನ ಮೋಕ್‌ಲ್ಯೊತೆ ದೇವ್ನಿ ವಚನ್ ಹುಯಿರ‍್ಹುಸ್‍. ");
INSERT INTO vaa_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","ದೇವ್ನಿ ಮರ್ಜಿನಿಘೋಣಿ ಚಾ಼ಲಾನ ಕಿನ ಮನ್ ಛಾ಼ಕಿ ಇವ್ಣುನ ಆ ವಚನ್ ದೇವ್‍ಥಿ ಆಯುಕಿ, ನತರ್ ಮೇಸ್ ಬಣೈನ್ ಬೋಲುಕರುಸ್ಕಿ ಕರಿ ಬೋಲಾನು ಮಾಲುಮ್‌ ಪಡಾಸ್‌. ");
INSERT INTO vaa_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","ಕೋಣ್ ಇನುಯೋಸ್ ವಾತೆಬೋಲಿಲೇಸ್ಕಿ ಇನಿ ಶೊಂತ್ ಇಜ಼್ಜತ್‌ನ ಢೂಂಡಸ್. ಇನುಯೋಸ್ ಖ್ಹಾಚ಼ನ ಲೀಲಾವನ ಕೋಶಿಶ್ ಕರಾಸ್, ಕತೋಬಿ ಕೋಣ್‌ಇನ ಮೋಕ್‌ಲ್ಯೊತೆ ಇನಿ ಇಜ್ಜತ್‍ನ ಢೂಂಡಾವಾಳೊ ಅದ್ಮಿಸ್‌ ಖ್ಹಾಚೊ಼; ಇನಾಮ ಶನೀಶ್ ಗಲತ್‌ ಕೊ ರ‍್ಹೇಯ್ನಿ. ");
INSERT INTO vaa_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","ಮೋಶೆನೆ ತುಮೂನ ಧರ್ಮಶಾಸ್ತ್ರ ದಿದೊ ಕೊಯ್ನಿಕಿಶು? ಕತೋಬಿ ತುಮಾರಮ ಕೋಣ್‌ಬಿ ಯೊ ಹುಕುಮ್ ಪಾಡಿನ್ ಚಾ಼ಲಕೊಯ್ನಿ. ತುಮೆ ಶನ ಮನ ಮರ್‌ನಾಕ್ಣು ಕರಿ ಕೋಶಿಶ್ ಕರಾಸ್?” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","ತದೆ ಯೋ ಅದ್ಮಿಖ್ಹಾರು, “ತುನ ಭೂತ್ ಧರಿರಾಖ್ಯುಸ್ ತುನ ಮರ್‌ನಾಕ್ಣು ಕರಿ ಕೋಣ್ ಢೂಂಡ್‌ಷೆ?” ಕರಿ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","ಯೇಸುನೆ ಇವ್ಣುನ, “ಮೇ ಏಕ್‌ ಅದ್ಭುತ್ ಕಾಮ್ನ ಕರ‍್ಯೊ, ಇನ ದೇಖಿನ್‌ ತುಮೆಖ್ಹಾರು ಆಶ್ಚರ್ಯ ಹುಯಾಥ. ");
INSERT INTO vaa_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","ಮೋಶೆನೆ ತುಮೂನ ಖ್ಹತ್ನ ಕರಾವ್ಣು ಕರಿ ಹುಕುಮ್‌ ದಿದೋಥೊ, ಕತೋಬಿ ಯೋ ಮೋಶೆಥಿ ಆಯೂತೆ ಕಾಹೆ, ಇನೇಥಿಬಿ ಅಗಾಡಿ ಥೂತೆ ತುಮಾರ ಗುರುಖ್ಹಾರಾಥೀಸ್ ಯೋ ಆಯೂತೆ. ಅಜು಼ ತುಮೆ ಸಬ್ಬತ್‌ ದನ್‌ಮಾಬಿ ಲಡ್ಕಾವ್ನ ಖ್ಹತ್ನ ಶನಕರೋಸ್‌. ");
INSERT INTO vaa_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","ಮೋಶೇನು ಧರ್ಮಶಾಸ್ತ್ರ ತೋಡ್ನು ನಾ ಕರಿ ಏಕ್‍ಜ಼ಣೊ ಸಬ್ಬತ್‌ನ ದನ್ಮ ಖ್ಹತ್ನ ಕರೈಲ್ಯವಾನು ರ‍್ಹಿಯುತೊ, ಮೇ ಸಬ್ಬತ್‌ ದನ್ಮ ಏಕ್‌ ಅದ್ಮಿನ ಗುಣ್ ಕರೀನ್ಅಛ್ಛು಼ ಕರ್ತಾನ, ಮಾರಪರ್ ಶನ ಇರಾದೊ ಕರೋಸ್? ");
INSERT INTO vaa_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","ಡೋಳಾಮ ದೆಖಾವಸ್ತೆ ಇನಾಪರ್‌ ತೀರ್ಪ್‌ ನಕೊ ಕರೊ; ಖ್ಹಾಚು಼ ಶಾತ್ಕಿ ಇನಾಪರ್‌ ತೀರ್ಪ್‌ ಕರೊ. ");
INSERT INTO vaa_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","ಯೆರೂಸಲೇಮ್‌ನು ಥೋಡುಜ಼ಣು ಅಮ್ ಬೋಲ್ಯು, “ಯೊ ಅದಿಕಾರಿಖ್ಹಾರು ಇವ್ಣೆ ಮಾರಿನಾಕ್ಣು ಕರಿ ಛಾ಼ತೆ ಆಸ್ ಕಾಹೆಕಿಶು? ");
INSERT INTO vaa_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","ಕತೋಬಿ ದೇಖೊ, ಆ ಹೈರೋತೆ ಖ್ಹಾರಾನ ಇಚ಼್‌ಮಾಸ್ ವಾತ್‍ಬೋಲ್‍ತೊ ಛಾ಼ಲ್ಯೊಫಂಡಾಸ್ ತೋಬಿ ಯೊ ಅದ್ಮಿ ಇನ ಶಾತ್ಬಿ ಕರುಕರಕೊಯ್ನಿ. ಅಮ್ಮಸ್ ಕಾಹೇಕಿಶು? ಅಮ್ನಿ ಪರಕ್ಮ ಯೆಹೂದ್ಯರ‍್ನು ಅದಿಕಾರಿಖ್ಹಾರು ಆಸ್ ಖ್ಹಾಚ಼ಮಾಬಿ ಕ್ರಿಸ್ತಸ್ ಕರಿ ಮಾಲುಮ್‌ ಕರಿಲಿದು. ");
INSERT INTO vaa_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","ಕತೋಬಿ ಆ ಅದ್ಮಿ ಕಿಜ್ಜಾ಼ಥು ಆಯೊಹುಯೊಕರಿ ಹಮೂನ ಮಾಲುಮ್‌, ಕ್ರಿಸ್ತ ಆವಾನಿ ವಖ್ಹತ್‌ಮ ಯೋ ಕಿಜ್ಜಾಥೊ ಆಯೊಹುಯೊ ಕರಿ ಏಕ್‌ನಾಬಿ ಮಾಲುಮ್ ಕೋ ಪಡ್‌ಶೇನಿ” ಕರಿ ವಾತೆ ಬೋಲಿಲೆವ್‌ಕರ್ತುಥು. ");
INSERT INTO vaa_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","ಯೇಸು ಮಂದಿರ್‌ಮ ಬೋಲಿ ದೇವ್ ಕರ್ತೊಥೊ. ತದೆ ಯೊ ಊಚಿ ಆವಾಜ಼್‌ಥಿ ಬೋಲ್ಯೊ, “ಯೊ ಕಿಜ್ಜಾಥೊ ಆಯೊಕರಿ ತುಮೂನ ಮಾಲುಮ್‍ಕಿಶು, ಮಾರಿ‍ಶೊಂತ್ ಅದಿಕಾರ್‌ಥಿ ಕೊ ಆಯೋನಿ ಮನ ಮೋಕ್ಲಿರಾಖ್ಯೊತೆ ಖ್ಹಾಚ ಏಕ್‍ಜ಼ಣಾನ ಖ್ಹಣೇದ್ ಕೊ ಧರಾನಿ.” ");
INSERT INTO vaa_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","ಕತೊ ಮನ ಯೋ ಮಾಲುಮ್‌, ಶನಕತೊ ಮೇ ಇನಾಕಂಥು ಆಯೊ ಅಜು಼ ಇನೇಸ್‌ ಮನ ಮೋಕ್ಲಿರಾಖ್ಯೊಸ್” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","ತದೆ ಇವ್ಣೆ ಇನ ಧರ್‌ನು ಕರಿ ಕರ‍್ಯು, ಕತೋಬಿ ಯೋ ವಖ್ಹತ್ ಬಿಜೂ಼ಬಿ ಕೋಆಯಿಂಥಿತೆ ಇನಖ್ಹಾಜೆ, ಕೋಣ್‌ಬಿ ಇನಾಪರ್‌ ಹಾತ್‌ ಕೋ ನಾಖ್ಯುನಿ. ");
INSERT INTO vaa_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","ಕತೋಬಿ ಝೂ಼ಂಡ್‌ಮ ಥೂತೆ ಘಣು ಅದ್ಮಿ ಇನಾಪರ್ ವಿಶ್ವಾಸ್‌ ಕರ‍್ಯು ಅಜು಼, “ಕ್ರಿಸ್ತ ಆಯೋತೊ ತದೆ, ಅನೆ, ಕರ‍್ಯೊತೆ ಅದ್ಭುತ್ ಕಾಮ್‍ಥೀಬಿ ಆಜೂ಼ಬಿ ಜಾ಼ಖ್ಹತ್ ಕಾಮ್ ಕರಾಸ್ಕಿಶುಕೀನಿ?” ಕರಿ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","ಯೊ ಅದ್ಮಿನು ಝೂ಼ಂಡ್‌ ಯೇಸುನಿ ಬಾರೇಮ ಮಹಿ-ಮಹಿಸ್ ಬೋಲಾತೆ ವಾತೇನ ಫರಿಸಾಯರ್‌ವಾಳು ಅಜು಼ ಮಹಾಯಾಜಕರ್‌ ಖ್ಹಮ್‌ಜ್ಯು, ಅಜು಼ ಯೇಸುನ ಧರಾನಖ್ಹಾಜೆ ಮಂದಿರ್‌ನು ಕಾವ್ಲಿ ಕರಾವಾಳನ ಮೋಕ್‍ಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","ತದೆ ಯೇಸು ಇವ್ಣುನ, “ಬಿಜು಼ ಥೋಡ ದನ್ ಮೇ ತುಮಾರ ಜೋ಼ಡೆ ರ‍್ಹೀಶ್, ಇನ ಬಾದ್‌ಮ ಮನ ಮೋಕ್‌ಲ್ಯೊತೆ ಇನಾಕನ ಮೇ ಚ಼ಲ್ಯೊಜೈ಼ಶ್‌. ");
INSERT INTO vaa_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","ತುಮೆ ಮನ ಢೂಂಡ್‌ಶು, ಕತೋಬಿ ಮೇ ತುಮೂನ ಕೋ ಮಳಿಶ್‌ನಿ, ಶನಕತೊ ಮೇ ಛೂ಼ತೆ ಹಿಜ್ಜಾ಼ ತುಮೂನ ಕೋ ಆವಾನ ಉಶೇನಿ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","ತದೆ ಯೆಹೂದ್ಯರ‍್ನು ಅದಿಕಾರಿಖ್ಹಾರು ಇವ್ಣ ಇವ್ಣಮಾಸ್ ವಾತೆ ಕರಿಲಿದು, “ಅಪ್ಣುನ ಮಳ್ಣುನಾತೆ ಆ ಕಿಜ್ಗಾ಼ ಜಾ಼ವ್ಣುಕರಿ ಛಾ಼? ಯೊ ಕಿಜ್ಜಾ಼ತೋಬಿ ಜಾ಼ವ್ಣುಕಿಶುಕಿ? ಕಿಜ಼್ಜ, ಮಾರು ಅದ್ಮಿ ಗ್ರೀಕ್ ಖ್ಹಯೇರ್‌ಮ ಜಿವ್ಣು ಕರುಕರಸ್, ಹೈರುತೆ ಗ್ರೀಕ್‌ವಳಾನ ಶಿಕಾಡ್‍ದಿಶೆಕಿ ಶು? ");
INSERT INTO vaa_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","ತುಮೆ ಮನ ಢೂಂಡ್‌ಶು, ಕತೋಬಿ ಮೇ ತುಮೂನ ಕೋ ಮಳಿಶ್‌ನಿ, ಶನಕತೊ ಮೇ ಛೂ಼ತೆ ಹಿಜ್ಜಾ಼ ತುಮೂನ ಕೋ ಆವಾನ ಉಶೇನಿ” ಕರಿ ಇನೆ ಬೋಲ್ಯೋತೆ ವಾತೆನಿ ಮತ್‌ಲಬ್ ಶಾತ್‌?” ಕರಿ ಇವ್ಣ-ಇವ್ಣ ಮಹಿಸ್ ಬೋಲಿಲಿದು. ");
INSERT INTO vaa_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","ಪೂಜಾ಼ನೊ ಖ್ಹರ್ತಿನೊ ಅಜು಼ ಮುಖ್ಯದನ್‌ ಹುಯಿರ‍್ಹೋತೆ ತದೆ ಯೇಸು ಭೀರಿನ್‌ ಊಚಿ ಅವಾಜ಼್‌ಥಿ ಬೋಲಾನು ಶುರುಕರ‍್ಯೊ, “ಕಿನ ಠೋಖ್ಹ್‌ ಲಾಗಸ್ಕಿ, ಯೊ ಅವಾದೆ ಅಜು಼ ಪಿಯ್ಯಾದೆ. ");
INSERT INTO vaa_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","ಧರ್ಮಶಾಸ್ತ್ರಮ ಬೋಲೈರ‍್ಹುತೆ ಇಮ್ಮಸ್, ‘ಕೋಣ್ ಮಾರಪರ್ ವಿಶ್ವಾಸ್‌ ಕರಾಸ್ಕಿ ಇನ ಮಹಿಥು ಜಾನ್ನಪಾಣಿನು ಝೀಲ್ ಇನಾಮ ವ್ಹವ್‍ಶೆ” ಕರಿ ಚಿಕ್ರಿನ್ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","ಕತೋಬಿ ಯೇಸುನೆ ಇನ ನಂಬಾವಾಳು ಲೀಲಿಶೇತೆ ಪವಿತ್ರಾತ್ಮ ವರಾನಿ ಬಾರೇಮ ಬೋಲ್ಯೊ. ಯೇಸು ಬೀಜೂಬಿ ಮಹಿಮೆನ ಲೀರಾಖ್ಯೊಥೊ ಕೊಯ್ನಿ ಶನಕತೊ ಪವಿತ್ರಾತ್ಮ ವರ ಅಜೂ಼ಬಿ ದೆವೈರ‍್ಹುಥು ಕೊಯ್ನಿ. ");
INSERT INTO vaa_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","ಅನ ಖ್ಹಮ್‌ಜಿನ್‌, ಭೀಡ್‌ಮ ಥೂತೆ ಥೋಡು ಅದ್ಮಿ, “ಖ್ಹಾಚ಼ಮಾಬಿ ಆ ಅದ್ಮಿ ಪ್ರವಾದಿ ಹುಯಿರ‍್ಹೋಸ್” ಕರಿ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","ಬಿಜು಼ ಥೋಡು ಜ಼ಣು, “ಆಸ್ ಕ್ರಿಸ್ತ” ಕರಿ ಬೋಲ್ಯು, ಕತೋಬಿ ಅಜು಼ ಥೋಡ ಅದ್ಮಿನೆ, “ಕ್ರಿಸ್ತ ಗಲಿಲಾಯಥೊ ಕೋ ಆವ್‌ಶೇನಿ!” ");
INSERT INTO vaa_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","ದಾವೀದ್‌ನ ಖಾನ್‌ದಾನ್‌ಥೀಬಿ ಅಜು಼ ದಾವೀದ್‌ ಥೋತೆ ಬೇತ್ಲೆಹೇಮ್ ಕರಿಬೋಲಾನು ಗಾಮ್‌ಥೂಬಿ ಕ್ರಿಸ್ತ ಆವ್‍ಶೆಕರಿ ಧರ್ಮಶಾಸ್ತ್ರಮ ಬೊಲಾವಸ್‍ನಿ” ಕರಿ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","ಅಮ್ ಯೇಸುನಿ ಬಾರೇಮ ಅದ್ಮಿಮ ಭಾಗ್‌ ಪಡಿಗಯು. ");
INSERT INTO vaa_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","ಇವ್ಣಾಮ ಥೋಡು ಜ಼ಣು ಯೇಸುನ ಧರ್‌ನು ಕರಿ ಥೂ, ಕತೋಬಿ ಏಕ್‌ ಜ಼ಣುಬಿ ಇನಾಪರ್‌ ಹಾತ್‌ ಕೋ ನಾಖ್ಯುನಿ. ");
INSERT INTO vaa_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","ಮಂದಿರ್‌ನು ಕಾವ್ಲಿ ಕರಾವಾಳು ಪಾಛು಼ಫರಿ ಆವಾದಿನ್, ಮಹಾಯಾಜಕರ್‌ ಅಜು಼ ಫರಿಸಾಯರ್‌ವಾಳು ಇವ್ಣುನ, “ತುಮೆ ಶನ ಇನ ಧರ್‌ಲಿ ಕೋ ಆಯಾನೀತೆ?” ಕರಿ ಪುಛಾ಼ಯು. ");
INSERT INTO vaa_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","ತದೆ ಕಾವ್ಲಿ ಕರಾವಾಳು, “ಕೋಣ್‌ಬಿ ಹಂಕೆತೋಡಿ ಆ ಅದ್ಮಿನಿಘೋಣಿ ವಾತೆ ಕೋ ಬೋಲ್ಯುನಿ” ಕರಿ ಜವಾಬ್‌ ದಿದು. ");
INSERT INTO vaa_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","ಅನ ಖ್ಹಮ್‌ಜಿನ್‌ ಫರಿಸಾಯರ್‌ವಾಳು, “ಇಮ್‍ಕತೊ, ಇನೆ ತುಮೂನಾಬಿ ಠಗೈನಾಖ್ಯೊಕಿ ಶು?” ಕರಿ ಪುಛಾ಼ಯು ");
INSERT INTO vaa_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","ಯೆಹುದ್ಯರ್‌ನ ಅದಿಕಾರಿರ‍್ಹವೊ, ಫರಿಸಾಯರ್‌ಮ ರ‍್ಹವೊ ಕೋಣ್‌ತೋಬಿ ಇನಾಪರ್ ವಿಶ್ವಾಸ್‌ ಕರಿರಾಖ್ಯುಸ್ಕಿ ಶು? ");
INSERT INTO vaa_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","ಧರ್ಮಶಾಸ್ತ್ರ ಮಾಲುಮ್‌ಕೊಂತೆ ಆ ಝೂ಼ಂಡ್‌ವಾಳು ಶಾಪಲ್ಯವಾಳು ಹುಯಿರುಸ್. ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","ಯೋ ಪಹಿಲೆ ಯೇಸುಕನ ಆಯೊಥೋತೆ ನಿಕೊದೇಮ ಇವ್ಣಾಮ ಏಕ್‌ ಜ಼ಣೊ ಹುಯಿರ‍್ಹೊಥೊ. ಯೇಸುನ ಮಳಾನ ಗಯೋಥೋತೆ ಆಸ್. ");
INSERT INTO vaa_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","ಇನೆ ಇವ್ಣುನ, “ಮಾರಿ ಧರ್ಮಶಾಸ್ತ್ರನಿ ಪರಕ್ಮ,ಕೋಣ್ ಶಾತ್ಬಿ ಖ್ಹಮ್‌ಜ್ಯುಕೊಂತೆ ಅಜು಼ ಯೊ ಶಾತ್‌ ಕರವಾಳೊಕರಿ ಮಾಲುಮ್‌ ಕರಕೊಂತೆ ಇನಿ ಬಾರೇಮ ತೀರ್ಪ್‌ ಬೋಲಾನ ಕೊಹುವಾನಿ.ಕರಿ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","ಇನ ಇವ್ಣೆ, “ತೂಬಿ ಗಲಿಲಾಯವಾಳೊಕಿ ಶು? ಧರ್ಮಶಾಸ್ತ್ರನ ಅಛ್ಛಿನಿತರ ಪಢೀನ್‌ ಶಿಕಿಲೆ. ಗಲಿಲಾಯಥು ಖೆವೂ ಪ್ರವಾದೀಬಿ ಆವ್‌ಶೆ ಕೊಯ್ನಿ ಕರಿ ತದೆ ತುನ ಮಾಲುಮ್‌ ಪಡ್‌ಶೆ” ಕರಿ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","ಇನಪಾರ್ ಅಖ್ಖುಜ಼ಣು ಇವ್ಣ-ಇವ್ಣ ಶೊಂತ್ ಘರೆ ಚ಼ಲಿಗಯು. ");
INSERT INTO vaa_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","ಕತೋಬಿ ಯೇಸು ಆಲಿವ್ ಪಹಡ್‌ನ ಗಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","ಯೋ ಪಾಛೊ಼ಫರಿ ಮಂದಿರ್‌ನ ಆಯೊ. ತದೆ ತಮಾಮ್‌ ಅದ್ಮಿ ಐನ್, ಇನ ಅಶ್‌ಪಿಶ್‍ ಭರಾಯು, ಅಜು಼ ಯೇಸು ಬೇಶಿನ್, ಇವ್ಣುನ ಬೋಲಿ ವತಾಳಲಗ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","ಮೋಶೆನಿ ವಚನ್ ಶಿಕಾಡವಾಳು ಅಜು಼ ಫರಿಸಾಯರ್‌ವಾಳು ವ್ಯಬಿಚಾರ್‌ಮ ಖ್ಹಪ್‌ಡೀತೆ ಏಕ್‌ ತಯೇಡಾನ ಇನಾಕನ ಲೈನ್‌, ಖ್ಹಾರಾನ ಖ್ಹಾಮ್ಣೆ ಭೀರಾಖ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","ಅಜು಼, “ಗುರು, ಆ ತಯೇಡ ವ್ಯಬಿಚಾರ್‌ ಕರಾನಿ ವಖ್ಹತ್‌ಮಾಸ್‌ ಖ್ಹಪ್‌ಡಿಗೈ. ");
INSERT INTO vaa_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","ಅಮ್ನಿ ತಯೇಡಾವ್‍ನ ಬಂಡೊ ಫೇಕಿನ್‌ ಮಾರ‍್ನು ಕರಿ ಮೋಶೆನೆ ಧರ್ಮಶಾಸ್ತ್ರಮ ಹಮೂನ ಹುಕುಮ್‌ ದೀರಾಖ್ಯೊಸ್. ಕತೋಬಿ ಅನಿ ಬಾರೇಮ ತೂ ಶಾತ್‌ ಬೋಲಾಸ್?” ಕರಿ ಇನ ಪುಛಾ಼ಯು. ");
INSERT INTO vaa_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","ಯೇಸುನಿ ವಾತೇಮ ಶಾತ್‌ತೋಬಿ ಗಲತ್‌ ಮಳ್ಯುತೊ, ಅಪ್ಣೆ ಇನ ಖ್ಹಪ್‌ಡಾಯೆಜಾ಼ಯಿ ಕರಿ ಇವ್ಣೆ ಯೇಸುನ ಸವಾಲ್‌ಕರ‍್ಯು? ಕತೋಬಿ ಯೇಸು ಮುಡ್‌ಕ್ಯು ಝು಼ಕೈನ್‌, ಇನಿ ಅಂಗ್‌ಳೀಥಿ ಜ಼ಮೀನ್‌ಪರ್ ಲೀಖಾಲಗ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","ಇವ್ಣೆ ಲಗತ್ತರ್‌ ಇನ ಪುಛಾ಼ವ್‌ ಕರ್ತುಥೂತೆ ಇನಖ್ಹಾಜೆ, ಯೇಸುನೆ ಮುಡ್‌ಕ್ಯು ಪಾಡೀನ್, ಇವ್ಣಾಮ ಏಕ್‌, “ತುಮಾರಮ ಕೋಣ್ ಪಾಪ್ ಕರಿರಾಖ್ಯುಕೊಯ್ನಿಕಿ, ಇವ್ಣೆ ಪಹಿಲೆ ಇನಾಪರ್‌ ಬಂಡೊ ಫೇಕಾದೆ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","ಅನಕೇಡೆಥು ಅಜು಼ಪಾಛು಼ ಮಡ್‌ಕ್ಯು ಝು಼ಕೈನ್‌ ಜ಼ಮೀನ್‌ಪರ್ ಲೀಖಾಲಗ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","ಆ ವಾತೇನ ಖ್ಹಮ್‌ಜಿನ್‌, ಪಹಿಲೆ ಶಾಣು ಅಜು಼ ಬಿಜು಼ಖ್ಹಾರು ಏಕೆಕೇಸ್ ನಿಕ್ಳಿನ್ ಚ಼ಲಿಗಯು. ಯೇಸು ಎಕ್ಕಸ್ ಜ಼ಣೊ ರಹಿಗೊ ಅಜು಼ ಯೋ ತಯೇಡ ಇನಖ್ಹಾಮ್ಣೆ ಭೀಥಿ. ");
INSERT INTO vaa_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","ಯೇಸು ಉಠಿ ಭೀರಿನ್, ಯೋ ತಯೇಡಾನ ದೇಖಿನ್‌, “ಅಲಿ ಬಾಯಿ, ಇವ್ಣೆ ಖ್ಹಾರು ಕ್ಯಾ? ತಾರಪರ್ ಗಲತ್‌ ಲಗಾಡನಖ್ಹಾಜೆ ಕೋಣ್‌ಬಿ ಕೋ ಬಚ್ಯೂನಿಕಿ ಶು? ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","ಯೋ ತಯೇಡಾನೆ, “ಕೋಣ್‌ಬಿ ಕೋ ಬಚ್ಯೂನಿಲಾ ಪ್ರಭು! ಕರಿ ಬೋಲಿ. ತದೆ ಯೇಸುನೆ ಇನ, “ಇಮ್‍ಕತೊ, ಮೇಬಿ ತಾರಪರ್ ಗಲತ್‌ ಕೋ ಲಗಾಡುನಿ. ಹಮ್ಕೆ ತೂ ಜಾ಼, ಅಜು಼ಪಾಛು಼ ಪಾಪ್ ನಕೊ ಕರೀಶ್” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","ಅನ ಬಾದ್‌ಮ ಯೇಸು ಪಾಛೊ಼ ಅದ್ಮಿಖ್ಹಾರನ ವಾತೆ ಬೋಲ್ತೊಹುಯಿನ್, “ಮೇಸ್ ಜಗತ್ನ ಉಜಾ಼ಳು ಹುಯಿರ‍್ಹೋಸ್, ಮಾರಪೀಠೆ ಆವಾಳು ಅಂಧಾರಮ ಚಾ಼ಲ್‌ಶೆಸ್‌ ಕೊಯ್ನಿ ಅಜು಼ ಯೊ ಜಾನ್ನು ಉಜಾ಼ಳು ಲೀರ‍್ಹಾವಳೊ ಹುಯಿರೊಸ್” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","ಫರಿಸಾಯರ್‌ವಾಳು ಯೇಸುನ, “ತಾರಿ ಬಾರೇಮ ತೂಸ್ ಸಾಕ್ಷಿ ಬೋಲಿಲೆಸ್; ತಾರಿ ಸಾಕ್ಷಿ ಖ್ಹಾಚು಼ ಕಾಹೆ” ಕರಿ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","ತದೆ ಯೇಸುನೆ ಜ಼ವಾಬ್ ದಿದೊ, “ಮೇಸ್ ಮಾರಿ ಬಾರೇಮ ಸಾಕ್ಷಿ ಬೋಲಿಲಿದೊತೊ ಯೋ ಖ್ಹಾಚು಼ ಹುಯಿರುಸ್. ಶನಕತೊ ಮೇ ಕಿಜ್ಜಾಥೊ ಆಯೊ ಅಜು಼ ಕಿಜ್ಗಾ಼ ಜೈ಼ಶ್ ಕರಿ ಬೋಲಾನು ಮನ ಮಾಲುಮ್‌. ಕತೋಬಿ ತುಮುನ ಮೇ ಕಿಜ್ಜಾಥೊ ಆಯೊ ಕಿಜ್ಗಾ಼ ಜೈ಼ಶ್ ಕರಿ ಮಾಲುಮ್‌ ಕೊಯ್ನಿ. ");
INSERT INTO vaa_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","ತುಮೆ ಅದ್ಮಿ ತೀರ್ಪ್‌ ಕರಾನಿತರ ಕರೋಸ್; ಕತೋಬಿ ಮೇ ಕಿನಾಬಿ ತೀರ್ಪ್ ಕೋ ಕರೂನಿ. ");
INSERT INTO vaa_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","ಕತೋಬಿ ಮೇ ತೀರ್ಪ್‌ ಕರ‍್ಯೊತೋಬಿ ಬರಾಬರಸ್‌ ರ‍್ಹೇಸ್‌, ಶನಕತೊ ಮೇ ಎಕ್ಕಸ್ ಜ಼ಣೊ ಕಾಹೆ; ಮನ ಮೋಕ್‌ಲ್ಯೊತೆ ಬಾಬಿ ಮಾರ ಜೋ಼ಡೆ ರ‍್ಹೇಸ್‌. ");
INSERT INTO vaa_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","ಬೇ ಜ಼ಣು ಬೋಲಾಸ್ತೆ ಸಾಕ್ಷಿ ಖ್ಹಾಚಿಕರಿ ತುಮಾರಿ ಧರ್ಮಶಾಸ್ತ್ರಮಾಸ್ ಬೋಲಾಸ್ನಿ. ");
INSERT INTO vaa_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","ಮಾರಿ ಬಾರೇಮ ಮೇ ಸಾಕ್ಷಿ ಬೋಲುಸ್ತೆ, ಮೆ ಏಕ್ಜ಼ಣೊ, ಅತ್ರೇಸ್ ಕಾಹೆತೆ ಮನ ಮೋಕ್‌ಲ್ಯೊತೆ ಬಾಬಿ ಬಿಜೇಕ್ ಸಾಕ್ಷಿ ಹುಯಿರೊಸ್” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","ತದೆ ಇವ್ಣೆ, “ತಾರೊ ಬಾ ಕಿಜ್ಗಾ಼ ಛಾ಼?” ಕರಿ ಪುಛಾ಼ಯು. ಯೇಸುನೆ, “ತುಮೂನ ಮೇ ರ‍್ಹವೊ, ಮಾರೊ ಬಾ ರ‍್ಹವೊ ಮಾಲುಮ್‌ ಕೊಯ್ನಿ. ತುಮೆ ಮನ ಮಾಲುಮ್‌ ಕರ‍್ಯಾಹೋತ್ತೊ, ಮಾರ ಬಾನಾಬಿ ಮಾಲುಮ್‌ ಕರಿಲಿದಾಹೋತ್‌” ಕರಿ ಜ಼ವಾಬ್ ದಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","ಯೇಸುನೆ ಮಂದಿರ್‌ಮ ಅದ್ಮಿ ಕಾಣ್ಕೇನಿ ಹುಂಡಿನಿ ಝ಼ಗೋಕನ ಭೀರಿನ್ ಶಿಕಾಡುಕರಾನಿ ವಖ್ಹತ್‌ಮ ಆ ವಾತ್ನ ಬೋಲ್ಯೊ. ಇನಖ್ಹಾಜೆ ಕೋಣ್‌ಬಿ ಇನ ಕೋ ಧರ‍್ಯುನಿ.ಶನಕತೊ ಇನಿ ವಖ್ಹತ್ ಬಿಜೂ಼ಬಿ ಕೋ ಐರ‍್ಹಿಥೀನಿ, ");
INSERT INTO vaa_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","ಯೇಸುನೆ ಪಾಛು಼ ಇವ್ಣುನ, “ಮೇ ಒಳೆಜ಼ವುಸ್ ತುಮೆ ಮನ ಢೂಂಡ್‌ಶು, ಅಜು಼ ತುಮಾರ ಪಾಪ್‌ಮ ತುಮೆ ಮರ್‌ಶು. ಮೇ ಜ಼ವುಸ್ತೆ ಹಿಜ್ಜಾ಼ ತುಮೆ ಕೋ ಆವಾನ ಉಶೇನಿ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","ಆ ಯೆಹೂದ್ಯರ್‌ನ, “ಮೇ ಜ಼ವುಸ್ತೆ ಹಿಜ್ಜಾ಼ ತುಮೆ ಆವಾನ ಕೋ ಉಶೇನಿ ಕರಿ ಬೋಲುಕರಾಸ್‌ ಕಿಶು? ಆ ಇನು ಯೋಸ್‌ ಮರಿಜಾ಼ವ್ಣು ಕರಿ ಛಾ಼ಕಿ ಶುಕಿ?” ಕರಿ ಬೋಲಿಲ್ಯವಾನಿತರ ಹುಯಿರೂಥು. ");
INSERT INTO vaa_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","ಯೇಸುನೆ, “ತುಮೆ ಹೇಟ್‌ಲ್ಯಾವಾಳ ಹುಯಿರ‍್ಹಾಸ್‌, ಮೆ ಉಪ್ಪರ್‌ವಾಳೊ ಹುಯಿರೊಸ್ ತುಮೆ ಆ ಜಗತ್‌ವಾಳ, ಕತೋಬಿ ಮೇ ಆ ಜಗತ್‌ವಾಳೊ ಕಾಹೆ. ");
INSERT INTO vaa_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","ಇನಖ್ಹಾಜೇಸ್ ತುಮೆ ತುಮಾರ ಪಾಪ್‍ಮಾಸ್‌ ಮರ್‌ಶು ಕರಿ ಮೇ ಬೋಲ್ಯೋತೆ. ಮೇ ಕೋಣ್ ಕರಿ ತುಮೆ ವಿಶ್ವಾಸ್‌ ನಾ ಕರ‍್ಯಾತೊ ತುಮಾರ ಪಾಪ್‌ಮ ತುಮೇಸ್ ಮರ್‌ಶು” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","ತದೆ ಇವ್ಣೆ ಇನ, “ತೂ ಕೋಣ್?” ಕರಿ ಪುಛಾ಼ಯು. ಯೇಸುನೆ, “ಮೇ ಕೋಣ್ ಕರಿ ಪಹಿಲೇಥೋಸ್‌ ತುಮೂನ ಬೋಲ್ತೊ ಆಯೊತೇಸ್ ಮೆ. ");
INSERT INTO vaa_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","ತುಮಾರಿ ತೀರ್ಪ್‌ನಿ ಬಾರೇಮ ವಾತೆ ಬೋಲಾನು ಮಾರಕನ ಘಣು ಛಾ಼. ಕತೋಬಿ ಮನ ಮೋಕ್‌ಲ್ಯೊತೆ ಯೋ ಖ್ಹಾಚೊ಼ ಹುಯಿರ‍್ಹೋಸ್ ಅಜು಼ ಇನೇಥಿ ಮೇ ಶಾತ್‌ ಖ್ಹಮ್‌ಜ್ಯೋಕಿ ಇನಾಸ್ ಆ ಜಗತ್ನ ಮೇ ಬೋಲುಸ್” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","ಯೇಸು ಬಾನಿ ಬಾರೇಮ ವಾತೆ ಬೋಲುಕರಾಸ್‌ ಕರಿ ಬೋಲಾನು ಇವ್ಣುನ ಮಾಲುಮ್‌ ಕೋ ಪಡ್ಯುನಿ. ");
INSERT INTO vaa_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","ಕತೋಬಿ ಇನೆ ಇವ್ಣುನ, “ತುಮೆ ಅದ್ಮಿನ ಛಿಯ್ಯಾನ ಉಪ್ಪರ್ ಪಾಡ್‌ಶುಕಿ, ತದೆ ‘ಮೇಸ್ ಯೋ’ ಕರಿ,ತುಮುನ ಮಾಲುಮ್ ಪಡ್‌ಶೆ. ಮೆ ಕರುಸ್ತೆ ಮಾರಿ ಶೊಂತ್ ಆಖ್ಹ್‌ಥಿ ಕಾಹೆ ಪಣ್ಕಿ, ಮಾರೊ ಬಾ ಬೋಲಾತೆ ಇಮ್ಮಸ್ ಶಿಕಾಡುಕರೂಸ್. ");
INSERT INTO vaa_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","“ಮನ ಮೋಕ್‌ಲ್ಯೊತೆ ಯೋ ಮಾರ ಜೋ಼ಡೆ ಛಾ಼; ಮನ ಎಕ್ಲೋಸ್ ಕೋ ಮ್ಹೇಲ್ಯೋನಿ, ಇನಖ್ಹಾಜೇಥಿ ಮೆ ಕೆದೇಬಿ ಇನ ಇಷ್ಟನಿತರಾಸ್ ಕರುಸ್ತೆ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","ಯೇಸು ಆ ವಾತೆ ಖ್ಹಾರು ಬೋಲಾನಿ ವಖ್ಹತ್‌ಮ ಘಣು ಅದ್ಮಿ ಇನಾಪರ್‌ ವಿಶ್ವಾಸ್‌ ಕರ‍್ಯು. ");
INSERT INTO vaa_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","ತದೆ ಯೇಸುನೆ ಇನಾಪರ್ ವಿಶ್ವಾಸ್‌ ಕರ‍್ಯೋತೊ ಯೆಹೂದ್ಯರ್‌ನ, “ತುಮೆ ಮಾರಿ ವಾತೇನಿತರ ಚಾ಼ಲ್ಯಾತೊ,ತುಮೆ ಖ್ಹಾಚ಼ಮಾಬಿ ಮಾರ ಶಿಷ್ಯ ಹುಯಿರ‍್ಹಿಶು. ");
INSERT INTO vaa_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","ತುಮೆ ಖ್ಹಾಚ಼ನ ಮಾಲುಮ್‌ ಕರಿಲಿಶು, ಅಜು಼ ಯೋ ಖ್ಹಾಚು಼ ತುಮೂನ ಛೋ಼ಡಾವ್‌ಶೆ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","ಇನ ಇವ್ಣೆ, “ಹಮೆ ಅಬ್ರಹಾಮ್‌ನಿ ಖಾಂದಾನ್‌ವಾಳ, ಹಮೆ ಕದೇಬಿ ಕಿನಾಬಿ ಗುಲಾಮ್ ಕೋಹೂಯಾನಿ. ಅಮ್ ರ‍್ಹವಾಪರ್, ‘ತುಮೆ ಛು಼ಟ್‌ಶು’ ಕರಿ ತೂ ಬೋಲಾಸ್ತೆ ಕಿಮ್?” ಕರಿ ಜವಾಬ್‌ ದಿದು. ");
INSERT INTO vaa_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","ಯೇಸುನೆ ಇವ್ಣುನ, “ತುಮೂನ ಖ್ಹಾಚಮಾಬಿ ಬೋಲುಸ್ಕಿ: ಪಾಪ್ ಕರಾವಾಳು ಖ್ಹಾರು ಪಾಪ್ನ ಗುಲಾಮ್ ಹುಯಿರ‍್ಹುಸ್‍. ");
INSERT INTO vaa_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","ಗುಲಾಮ್ ಘರ್‌ಮ ಹಮೇಶಾನಖ್ಹಾಜೆ ಕೋ ರಿಶೇನಿ, ಕತೋಬಿ ಛಿಯ್ಯೊ ಘರ್‌ಮ ಹಮೇಶಾನಖ್ಹಾಜೆ ರ‍್ಹೇಸ್‌. ");
INSERT INTO vaa_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","ಇನಖ್ಹಾಜೆ ಛಿಯ್ಯೊ ತುಮೂನ ಛೋ಼ಡಾಯೋತೊ, ತುಮೆ ಖ್ಹಾಚಮಾಬಿ ಛು಼ಟ್‌ಶು. ");
INSERT INTO vaa_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","ತುಮೆ ಅಬ್ರಹಾಮ್‌ನಿ ಪಿಳ್ಗಿವಾಳ ಕರಿ ಮನ ಮಾಲುಮ್‌. ತೋಬಿ ತುಮೆ ಮನ ಮರ್‌ನಾಕ್ಣು ಕರಿ ಕೋಶಿಶ್ ಕರೋಸ್, ಶನಕತೊ ಮಾರಿ ವಾತೇನ ತುಮೆ ಮಾನ ಕೊಯ್ನಿ. ");
INSERT INTO vaa_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","ಮಾರ ಬಾನೆ ಮನ ವತಾಳ್ಯೊತೆ ಇನಿ ಬಾರೇಮ ಮೇ ಬೋಲುಸ್, ಕತೋಬಿ ತುಮಾರ ಬಾನೆ ಶಾತ್‌ ಖ್ಹಮ್‍ಜಾ಼ಡ್ಯೋಕಿ ಯೋ ತುಮೆ ಕರೋಸ್” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","ಇವ್ಣೆ ಇನ, “ಹಮಾರೊ ಬಾ ಅಬ್ರಹಾಮ್‌” ಕರಿ ಜವಾಬ್‌ ದಿದು. ಯೇಸುನೆ ಇವ್ಣುನ, “ತುಮೆ ಅಬ್ರಹಾಮ್‌ನ ಲಡ್ಕಾ ಹುಯಿರ‍್ಹಾಹೋತ್ತೊ, ಅಬ್ರಹಾಮ್‌ನೆ ಕರ‍್ಯೊತೆ ಇಮ್ಮಸ್ ಕರ‍್ಯಾಹೋತ್‌. ");
INSERT INTO vaa_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","ಮೇ ದೇವ್‍ಥಿ ಖ್ಹಮ್‌ಜೋತೆ ಖ್ಹಾಚಿನ ತುಮುನ ಬೋಲಿವತಾಳ್ಯೋತೆ ಏಕ್ಜ಼ಣೊ ಮೆ ಹುಯಿರೊಸ್, ತೋಬಿ ತುಮೆ ಮನ ಮರ್‌ನಾಕ್ಣು ಕರಿ ದೇಖೊಸ್‍. ಅಬ್ರಹಾಮ್‌ನೆ ಅಮ್ ಶಾತ್ ಕೋ ಕರ‍್ಯೋನಿ! ");
INSERT INTO vaa_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","ತುಮೆ ತುಮಾರ ಬಾನ ಕಾಮ್ನ ಅಖ್ಖು ಕರುಕರಸ್ ಕರಿಬೋಲ್ಯೊ. ತದೆ ಇವ್ಣೆ, ಹಮೆ ಪಾಪೇಲ ಕಾಮ್‍ಥಿ ಪೈದಕೊಹುಯಾನಿ. ಹಮೂನ ಎಕ್ಕಸ್ ಜ಼ಣೊ ಬಾ, ಯೋ ದೇವಸ್ ಕರಿ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","ಯೇಸುನೆ ಯೆಹೂದ್ಯರ್‌ನ, “ಖ್ಹಾಚಮಾಬಿ ದೇವಸ್ ತುಮಾರೊ ಬಾ ಹುಯಿರ‍್ಹೊಹೋತ್ತೊ, ತುಮೆ ಮನ ಪ್ಯಾರ್ ಕರ‍್ಯಾಹೋತ್‌, ಶನಕತೊ ಮೇ ದೇವ್‌ಕಂಥೊ ಆಯೊ ಅಜು಼ ಹಮ್ಕೆ ಹಜ್ಜಾ಼ ಛು಼. ಮೇ ಆಯೋತೆ ಮಾರಿ ಶೊಂತ್‌ ಅದಿಕಾರ್‌ಪರ್‌ ಕಾಹೆ, ಪಣ್ಕಿ ದೇವ್ನೇಸ್ ಮನ ಮೋಕ್‌ಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","ತುಮೆ ಮಾರಿ ವಾತೇನ ಶನ ಖ್ಹಮ್‌ಜಾ಼ ಕೊಯ್ನಿ? ಶನಕತೊ ತುಮೆ ಮಾರಿ ವಾತೇನ ಕಾನ್‌ ಕೋ ದೆವ್‌ಕರಾನಿತೆ ಇನಖ್ಹಾಜೇಸ್. ");
INSERT INTO vaa_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","ಶೈತಾನಸ್ ತುಮಾರೊ ಬಾ, ಇನ ತುಮೆ ಛಿಯ್ಯಾ ಹುಯಿರಾಸ್, ಇನೀನಿಘೋಣಿ ಖರಾಬ್ ಆಖ್ಹ್‌ನ ಕರಾನ ದೇಖೊಸ್‍. ಯೋ ಶುರುವಾತ್‌ಥೋಸ್ ಖೂನಿಹುಯಿರ‍್ಹೊಸ್ ಅಜು಼ ಖ್ಹಾಚಾಮ ಟಿಕ್ಯೊಕೊಯ್ನಿ. ಶನಕತೊ ಇನಾಮ ರತ್ತಿಬಿ ಖ್ಹಾಚಿ ಕೊಯ್ನಿ, ಯೋ ಝೂ಼ಟಿ ಬೋಲಾನಿ ವಖ್ಹತ್‌ಮ ಆದತ್‌ನಿಘೋಣಿ ಬೋಲಾಸ್, ಶನಕತೊ ಯೋ ಝೂ಼ಟಿಸ್ ಬೋಲವಾಳೊ ಅಜು಼ ಹರ್ ಥರಾನು ಝೂ಼ಟಿನ ಬಾ ಹುಯಿರ‍್ಹೋಸ್. ");
INSERT INTO vaa_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","ಮೇ ಖ್ಹಾಚಿ ಬೋಲುಸ್ತೆ ಇನಖ್ಹಾಜೆ ತುಮೆ ವಿಶ್ವಾಸ್‌ ಕರಾಕೊಯ್ನಿ. ");
INSERT INTO vaa_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","ಮಾರಾಮ ಪಾಪ್ನ ವತಾಳವಾಳೊ ತುಮಾರಮ ಕೋಣ್‌ತೋಬಿ ಛಾ಼? ಮೇ ಖ್ಹಾಚಿ ಬೋಲ್ಯೊತೋಬಿ, ತುಮೆ ಮನ ಶನ ವಿಶ್ವಾಸ್‌ ಕರಾಕೊಯ್ನಿ? ");
INSERT INTO vaa_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","ಖಿವು ಏಕ್‍ಜ಼ಣು ದೇವ್‍ಥಿ ಪೈದಾಹುಯುಕಿ ದೇವ್ನಿ ವಾತೆನ ಖ್ಹಮ್‌ಜಾ಼ಸ್‌, ತುಮೆ ದೇವ್ನ ಸಂಬಂದ್ ನಾರ‍್ಹಯಾತೊ, ಇನಖ್ಹಾಜೆ ಇನ ಖ್ಹಮ್‌ಜಾ಼ಕೊಯ್ನಿ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","ತದೆ ಯೆಹೂದ್ಯರ್‌ನೆ ಯೇಸುನ ಬೋಲ್ಯು,ಹಮೆ ಬೋಲಾನು ಬರಾಬರ್‌ ಕಾಹೆಕಿ ಶು? “ತೂ ಸಮಾರಿಯಾವಾಳೊ ಅಜು಼ ತಾರಾಮ ಭೂತ್‌ ಛಾ಼” ಕರಿ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","ಯೇಸುನೆ, “ಮಾರಾಮ ಭೂತ್‌ ಕೊಯ್ನಿ, ಮೇ ಮಾರ ಬಾನ ಮರ್ಯಾದಿ ದೆವ್‌ಸ್‌, ಕತೋಬಿ ತುಮೆ ಮನ ಮರ‍್ಯಾದಿ ಕೋ ದೇಯ್ನಿ. ");
INSERT INTO vaa_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","ಮನ ಮರ್ಯಾದಿ ಮಳಾದೆ ಕರಿ ಮೇ ಆಖ್ಹ್ ಕೋ ಕರೂನಿ, ಕತೋಬಿ ಮನ ಮರ್ಯಾದಿ ಮಳ್‌ಣು ಕರಿ ಆಖ್ಹ್ ಕರಾವಾಳೊ ಏಕ್‌ ಜ಼ಣೊ ಛಾ಼, ಯೋ ಮಾರಭಣಿಥೊ ನ್ಯಾವ್‌ ಫೇಡಾವಾಳೊ. ");
INSERT INTO vaa_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","ಮೇ ತುಮೂನ ಖ್ಹಾಚಸ್ ಬೋಲುಸ್, ಮೆ ಶಿಕಾಡನು ಖ್ಹಮ್‌ಜಿನ್‌ ಇನೀನಿಘೋಣಿ ಚಾ಼ಲವಾಳು ಕದೇಬಿ ಮರ್‌ಶೆ ಕೊಯ್ನಿ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","ಇನ ಯೆಹೂದ್ಯವಾಳನೆ, “ತುನ ಭೂತ್‌ ಧರಿರಾಖ್ಯುಸ್ ಕರಿ ಹಮ್ಕೆ ಹಮೂನ ಮಾಲುಮ್ ಪಡ್ಯು! ಅಬ್ರಹಾಮ್‌ ಮರಿಗಯೊ, ಅಜು಼ ಪ್ರವಾದಿ ಖ್ಹಾರುಬಿ ಮರಿಗಯು, ತೋಬಿ ತೂ ಬೋಲಸ್ಕಿ, ಮೆ ಶಿಕಾಡನಿಘೋಣಿ ಚಾ಼ಲವಾಳು ಕದೇಬಿ ಮರ್‌ಶೆಕೊಯ್ನಿ ಕರಿ. ");
INSERT INTO vaa_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","ಹಮಾರೊ ಮೋಟೊ ಹುಯಿರ‍್ಹೋತೆ ಅಬ್ರಹಾಮ್‌ಥೀಬಿ ತೂ ಮೋಟೋಕಿ ಶು? ಅಬ್ರಹಾಮ್‌ಬಿ, ಪ್ರವಾದಿ ಖ್ಹಾರುಬಿ ಮರಿಗಯು. ಅಮ್ ರ‍್ಹವಾಪರ್, ತಾರು ತೂ ಕೋಣ್ ಕರಿ ಸೋಚಾ಼ಸ್‌?” ಕರಿ ಪುಛಾ಼ಯು. ");
INSERT INTO vaa_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","ತದೆ ಯೇಸುನೆ, “ಮಾರು ಮೇಸ್ ಖ್ಹರೈಲಿದೋತೊ, ಯೋ ಮರ್ಯಾದಿನ ಶನೀಶ್ ಬೆಲೆಕೊಯ್ನಿ. ಮನ ಮರ್ಯಾದಿ ದ್ಯವಾಳೊ ಮಾರೊ ಬಾ, ತುಮೆ ಇನ ಹಮಾರೊ ದೇವ್ ಕರಿ ಬೋಲೋಸ್‌. ");
INSERT INTO vaa_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","ತೋಬಿ ತುಮೆ ಇನ ಪರ್ಖಿರಾಖ್ಯಕೊಯ್ನಿ, ಕತೋಬಿ ಮನ ಯೋ ಮಾಲುಮ್‌. ಯೋ ಮನ ಮಾಲುಮ್‌ಕೊಯ್ನಿ ಕರಿ ಮೇ ಬೋಲ್ಯೊತೊ, ಮೇಬಿ ತುಮಾರಿನಿತರ ಝೂ಼ಟೊ ಹುಯಿಜೈ಼ಶ್‌. ಕತೋಬಿ ಮನ ಯೋ ಮಾಲುಮ್‌, ಅಜು಼ ಮೇ ಇನಿ ವಾತೆನಿಘೋಣಿ ಚಾ಼ಲುಸ್‌. ");
INSERT INTO vaa_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","ತುಮಾರೊ ಬಾ ಹುಯಿರ‍್ಹೋತೆ ಅಬ್ರಹಾಮ್‌ನೆ ಮೇ ಆಯಿಶ್‍ತೆ ದನ್ನ ದೇಖಿಶ್‌ ಕರಿ ಘಣು ಶಂತೋಖ್ಹ್‌ ಕರ‍್ಯೊ, ಅಜು಼ ಇನೆ ಯೋ ದನ್ನ ದೇಖಿನ್‌ ಖ್ಹುಶಿ ಕರ‍್ಯೊ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","ಇನ ಯೆಹೂದ್ಯರ್‌ನೆ, “ತುನ ಬಿಜೂ಼ಬಿ ಅಡೈವಿಖ್ಹ್‌ ವರಖ್ಹ್‌ ಕೋ ಹುಯಿರಾನಿ, ತುನೆ ಅಬ್ರಹಾಮ್‌ನ ದೇಖಿರಾಖ್ಯೋಸ್ಕಿ ಶು?” ಕರಿ ಯೇಸುನ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","ಯೇಸುನೆ, “ಮೇ ಖ್ಹಾಚ ಬೋಲುಸ್ಕಿ, ಅಬ್ರಹಾಮ್‌ ಪೈದಾ ಹುವಾನ ಅಗಾಡಿಸ್, ಮೇ ಥೊ!” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","ಆ ವಾತೆನ ಖ್ಹಮ್‌ಜಿನ್‌, ಇವ್ಣೆ ಇನ ಮಾರಾನಖ್ಹಾಜೆ ಬಂಡಾ ಪಾಡಿಲಿದು, ಕತೋಬಿ ಯೇಸು ಓಠೆಹೋತೊಹುಯಿನ್, ಮಂದಿರ್‌ನ ಮಹಿಕರಿ ಚ಼ಲೆಗಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","ಯೇಸು ಚಾ಼ಲ್ತೊ ಜಾ಼ವಾನಿ ವಖ್ಹತ್‌ಮ, ಪೈದಾಖ್ಹ್‌ಥೂಸ್‌ ಕಾಣು ಥೂತೆ ಏಕ್‌ ಅದ್ಮಿನ ದೇಖ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","ಯೇಸುನ ಶಿಷ್ಯರ್‌ನೆ ಇನ, “ಗುರು, ಆ ಅದ್ಮಿ ಕಾಣುಹುಯಿನ್‌, ಪೈದಾ ಹುಯೂತೆ ಕಿನ ಪಾಪ್‌ಥಿ? ಅನು ಪಾಪ್‌ಥೀಕಿ? ಅನ ಆಯ-ಬಾನ ಪಾಪ್‌ಥಿ?” ಕರಿ ಪುಛಾ಼ಯ. ");
INSERT INTO vaa_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","ಯೇಸುನೆ, “ಅನೇಬಿ ಪಾಪ್ ಕೋ ಕರ‍್ಯೋನಿ, ಅನ ಆಯಾ-ಬಾನ ಪಾಪ್ನಟೇಕೆ ಕಾಹೆ. ದೇವ್‌ನು ಕಾಮ್ ಅನಾಮ ಹುವಾನಟೇಕೆಸ್‌ ಅನ ಅಮ್ ಹುಯೂತೆ. ");
INSERT INTO vaa_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","ಮನ ಮೋಕ್‌ಲ್ಯೊತೆ ಇನು ಕಾಮ್ನ ಅಪ್ಣೆ ದನ್ನಿ ವಖ್ಹತ್‌ಮಾಸ್‌ ಕರ‍್ನು, ರಾತ್‌ ಆವ್‌ಶೆ ತದೆ ಕಿನೇಥೀಬಿ ಕಾಮ್ ಕರಾನ ಕೋ ಉಶೇನಿ. ");
INSERT INTO vaa_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","ಮೇ ಆ ಜಗತ್‌ಮ ರ‍್ಹವಾನಿ ವಖ್ಹತ್‌ಮ, ಮೇಸ್ ಆ ಜಗತ್ನ ಉಜಾ಼ಳು ಹುಯಿರ‍್ಹೋಸ್” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","ಅನ ಬೋಲಾನ ಬಾದ್‌ಮ, ಯೇಸುನೆ ಜ಼ಮೀನ್‌ಪರ್ ಥೂಕಿನ್, ಇನೇಥಿ ಚಿಕ್ಕಡ್‌ ಬಣೈನ್, ಯೋ ಅದ್ಮಿನ ಡೋಳಾನ ಲಗಾಡ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","ಅಜು಼ ಯೋ ಅದ್ಮಿನ ಬೋಲ್ಯೋಕಿ, “ಜೈ಼ನ್‌, ಸಿಲೋವ ಕೋಳಮ್ಮ ಧೊಯಿಲೆ” ಸಿಲೋವ ಕತೊ, ‘ಮೋಕ್‌ಲ್ಯೊಹುಯೊ’ ಕರಿ ಮತ್‌ಲಬ್. ಇಮ್ಮಸ್ ಯೋ ಅದ್ಮಿನೆ ಜೈ಼ನ್, ಧೊಯಿಲಿನ್ ಪಾಛೊ಼ಫರಾನಿ ವಖ್ಹತ್, ಅಜು಼ ಇನ ಡೋಳಾ ದೆಖಾವಲಗ್ಯ. ");
INSERT INTO vaa_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","ತದೆ ಇನ ಅಜು಼-ಬಾಜು಼ವಾಳು ಅಜು಼ ಯೋ ಅಗಾಡಿ ಧರಮ್ ಮಾಂಗುಕರ್ತೊಥೋತೆ ಇನ ದೇಖಿಹುಯು ಅದ್ಮಿಖ್ಹಾರು, “ಬೇಶಿನ್, ಧರಮ್ ಮಾಂಗ್‌ತೊಥೋತೆ ಆಸ್ ಕಾಹೆಕಿ ಶು?” ಕರಿ ಪುಛಾ಼ಯು. ");
INSERT INTO vaa_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","ಥೋಡು ಜ಼ಣು, “ಆಸ್ ಯೋ” ಕರಿ ಬೋಲ್ಯು, ಕತೋಬಿ ಬಿಜು಼ ಥೋಡು ಜ಼ಣು, “ಆ ಯೋ ಕಾಹೆ, ಇನೀನಿತರಸ್ ದೆಖಾವಸ್” ಕರಿ ಬೋಲ್ಯು, ತದೆ ಯೋ ಅದ್ಮಿನೇಸ್, “ಮೇಸ್ ಯೋ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","ತದೆ ಇವ್ಣೆ ಇನ, “ತುನ ಡೋಳಾ ಕಿಮ್ ಆಯಾ?” ಕರಿ ಇನ ಪುಛಾ಼ಯು. ");
INSERT INTO vaa_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","ಯೋ ಅದ್ಮಿನೆ, “ಯೇಸು ಕರಿ ಏಕ್‌ ಜ಼ಣೊ ಛಾ಼ನಿ, ಇನೆ ಚಿಕ್ಕಡ್‌ ಕರೀನ್, ಮಾರ ಡೋಳಾನ ಲಗಾಡಿನ್, ಸಿಲೋವ ತಲಾವ್ಮ ಜೈ಼ನ್‌, ಧೊಯಿಲೆ ಕರಿ ಬೋಲ್ಯೊ. ಇಮ್ಮಸ್ ಮೇ ಜೈ಼ನ್ ಧೊಯಿಲಿದೊ, ತದೆ ಮನ ಡೋಳಾ ದೆಖಾವಲಗ್ಯ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","ಯೊ ಅದ್ಮಿಖ್ಹಾರು ಇನ, “ಯೋ ಕಿಜ್ಗಾ಼ ಛಾ಼?” ಕರಿ ಪುಛಾ಼ಯು. ಯೋ ಅದ್ಮಿನೆ, “ಮನ ಮಾಲುಮ್‌ ಕೊಯ್ನಿ” ಕರಿ ಜವಾಬ್‌ ದಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","ತದೆ ಅದ್ಮಿಖ್ಹಾರು ಅಗಾಡಿ ಕಾಣು ಹುಯಿರ‍್ಹುಥೂತೆ ಯೋ ಅದ್ಮಿನ ಫರಿಸಾಯರ್‌ಕನ ಬುಲೈಲಿ ಗಯು. ");
INSERT INTO vaa_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","ಯೇಸುನೆ ಚಿಕ್ಕಡ್‌ ಕರೀನ್, ಇನ ಡೋಳಾನ ಅಛ್ಛು಼ ಕರ‍್ಯೊತೆ ದನ್ ಸಬ್ಬತ್‌ ದನ್ ಹುಯಿರ‍್ಹುಥು. ");
INSERT INTO vaa_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","ತದೆ ಫರಿಸಾಯರ್‌ನೆ ಪಾಛು಼ ಯೋ ಅದ್ಮಿನ, “ತುನ ಡೋಳಾ ಕಿಮ್ ದೆಖಾಯ?” ಕರಿ ಪುಛಾ಼ಯು. ಇನೆ ಇವ್ಣುನ, “ಇನೆ ಚಿಕ್ಕಡ್‌ನ ಮಾರ ಡೋಳಾಪರ್‌ ಲಗಾಡ್ಯೊ, ಅಜು಼ ಮೇ ಧೊಯಿಲಿದೊ, ಹಮ್ಕೆ ಮನ ದೆಖವ್‌ಕರಾಸ್‌” ಕರಿ ಜವಾಬ್‌ ದಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","ಫರಿಸಾಯರ್‌ಮ ಥೋಡಾನೆ, “ಆ ಅದ್ಮಿ ದೇವ್‍ಥಿ ಆಯೊಹುಯೊ ಕಾಹೆ, ಶನಕತೊ ಅನೆ ಸಬ್ಬತ್‌ದನ್ನು ಪಾಲನ್‍ ಕೊ ಕರಾನಿ” ಕರಿ ಬೋಲ್ಯು. ಬಿಜು಼ ಥೋಡಾನೆ, “ಖಿವು ಪಾಪಿ ಅಮ್ನಿ ಅದ್ಭುತ್ ಕಾಮ್‌ಖ್ಹಾರು ಕರಾಸ್?” ಕರಿ ಬೋಲ್ಯು. ಅಮ್ ಇವ್ಣ-ಇವ್ಣಾಸ್‍ಮ ಬೇ ಭಾಗ್‌ ಹುಯಿಗಯು. ");
INSERT INTO vaa_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","ಡೋಳ ದೆಖಾವಲಗ್ಯುತೆ ಯೊ ಅದ್ಮಿನ ಫರಿಸಾಯರ್‌ನೆ ಬಿಜೇಕ್‌ಹಲ್ಲ ಪುಛಾ಼ಯು. ತದೆ ಯೋ ಅದ್ಮಿನೆ, “ಯೋ ಏಕ್‌ ಪ್ರವಾದಿ” ಕರಿ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","ತೋಬಿ ಯೋ ಯೆಹೂದ್ಯವಾಳು, ಯೋ ಅದ್ಮಿನ ಆಯ-ಬಾನ ಬುಲಾಯು.ತಬ್‍ಲಗು ಕಾಣು ಥೂ ಕರಿ ಬೋಲಾನಿ ವಾತೇನ ಕೋ ನಂಬ್ಯುನಿ, ");
INSERT INTO vaa_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","ಇವ್ಣೆ ಇನ ಆಯ-ಬಾನ, “ಆ ತುಮಾರೊ ಛಿಯ್ಯೋಕಿ ಶು? ಆ ಪೈದಾಖ್ಹ್‌ಥೋಸ್‌ ಕಾಣೊ ಕರಿ ತುಮೆ ಬೋಲಾಸ್ತೆ; ಇಮ್‍ಕತೊ, ಹಮ್ಕೆ ಅನ ಡೋಳಾ ಕಿಮ್ ದೆಖವ್‌ಕರಾಸ್ತೆ?” ಕರಿ ಪುಛಾ಼ಯು. ");
INSERT INTO vaa_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","ಇನ ಆಯ-ಬಾನೆ, “ಆ ಹಮಾರೊ ಛಿಯ್ಯೊ ಕರಿ ಹಮೂನ ಮಾಲುಮ್ ಅಜು಼ ಆ ಪೈದಾಖ್ಹ್‌ಥೋಸ್‌ ಕಾಣೊ ಕರೀಬಿ ಹಮೂನ ಮಾಲುಮ್‌. ");
INSERT INTO vaa_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","ಕತೋಬಿ ಹಮ್ಕೆ ಅನ ಡೋಳಾ ಕಿಮ್ ದೆಖವ್‌ಕರಾಸ್‌ ಕರಿ ರ‍್ಹವೊ, ಅನ ಅಛ್ಛು಼ ಕರ‍್ಯುತೆ ಕಿನೆ ಕರಿ ರ‍್ಹವೊ ಹಮೂನ ಮಾಲುಮ್‌ ಕೊಯ್ನಿ. ಅನಾಸ್ ಪುಛಾ಼ವೊ, ಆ ಜಾ಼ನ್‌ಜ಼ಮಾನ್ನಿ, ಆಸ್ ಇನಿ ಬಾರೇಮ ಬೋಲ್‌ಶೆ” ಕರಿ ಜವಾಬ್‌ ದಿದು. ");
INSERT INTO vaa_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","ಇನ ಆಯ-ಬಾನೆ ಯೆಹೂದ್ಯರ್‌ನ ಅದಿಕಾರಿ ಡರಿನ್, ಅಮ್ನಿ ವಾತೇನ ಬೋಲ್ಯುತೆ, ಶನಕತೊ ಯೇಸುನ ಕ್ರಿಸ್ತ ಕರಿ ಕೋಣ್ ವಿಶ್ವಾಸ್ ಕರಾಸ್ಕಿ, ಇವ್ಣುನ ಯೆಹೂದ್ಯರ‍್ನು ಸಬಾ ಮಂದಿರ್‌ಮಾಥು ಭಾರ್‌ ನಾಕ್‌ಶು ಕರಿ ಇವ್ಣೆ ಬೋಲಿರಾಖ್ಯುಥು. ");
INSERT INTO vaa_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","ಇನಖ್ಹಾಜೇಸ್ ಇನ ಆಯ-ಬಾನೆ, “ಯೋ ಜಾ಼ನ್ಜ಼ಮಾನ್ ಹುಯಿರ‍್ಹೋಸ್‌ನಿ, ಇನಾಸ್ ಪುಛಾ಼ವೊ” ಕರಿ ಬೋಲ್ಯೂತೆ. ");
INSERT INTO vaa_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","ತದೆ ಯೆಹೂದ್ಯರ್‌ನ ಅದಿಕಾರಿ ಪಾಛು಼ ಭೇನೆಹಲ್ಲ, ಅಗಾಡಿ ಕಾಣೊ ಹುಯಿರ‍್ಹೊಥೋತೆ ಯೋ ಅದ್ಮಿನ ಬುಲೈನ್, “ತೂ ಖ್ಹಾಚಿ ಬೋಲಿನ್ ದೇವ್ನ ಮರ್ಯಾದಿದೆ, ತುನ ಅಛ್ಛು಼ ಕರ‍್ಯೊತೆ ಯೋ ಅದ್ಮಿ ಪಾಪಿಕರಿ ಹಮೂನ ಮಾಲುಮ್‌” ಕರಿಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","ತದೆ ಯೋ ಅದ್ಮಿನೆ, “ಯೋ ಅದ್ಮಿ ಪಾಪಿಕಿ, ಕೊಯ್ನಿಕಿ ಮನ ಮಾಲುಮ್‌ಕೊಯ್ನಿ, ಕತೋಬಿ ಮೇ ಕಾಣೊ ಥೊ, ಹಮ್ಕೆ ಮನ ದೆಖವ್‌ಕರಾಸ್‌ ಕರಿ ಬೋಲಾನು ಮನ ಮಾಲುಮ್‌” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","ತದೆ ಯೆಹೂದ್ಯರ್‌ನೆ ಇನ, “ಇನೆ ತುನ ಶಾತ್‌ ಕರ‍್ಯೊ? ಇನೆ ತಾರ ಡೋಳಾನ ಕಿಮ್ ಅಛ್ಛು಼ ಕರ‍್ಯೊ?” ಕರಿ ಪುಛಾ಼ಯು. ");
INSERT INTO vaa_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","ಯೋ ಅದ್ಮಿನೆ, “ಮೇ ತುಮೂನ ಅಗಾಡಿಸ್ ಬೋಲ್ಯೊನಿ, ತುಮೆ ಖ್ಹಮ್‌ಜ್ಯಾಕೊಯ್ನಿ, ಬಿಜು಼ ಪಾಛು಼ ಶನ ಖ್ಹಮಜ಼್‌ಣು ಕರಿ ಛಾ಼ತೆ? ತುಮೇಬಿ ಇನ ಶಿಷ್ಯರ್‌ ಹೋಣು ಕರಿ ಛಾ಼ಕಿ ಶು? ಕರಿ ಜವಾಬ್‌ ದಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","ತದೆ ಇವ್ಣೆ ಯೋ ಅದ್ಮಿನ ಖ್ಹರಮ್‌ ಕಾಡಿನ್, “ತೂ ಯೋ ಅದ್ಮಿನೊ ಶಿಷ್ಯ; ಕತೋಬಿ ಹಮೆ ಮೋಶೆನ ಪೀಠೆ ಜಾ಼ವವಾಳ ಹುಯಿರ‍್ಹಾಸ್. ");
INSERT INTO vaa_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","ಮೋಶೆನ ಜೋ಼ಡೆ ದೇವ್ನೆ ವಾತೆ ಬೋಲ್ಯೊ ಕರಿ ಹಮೂನ ಮಾಲುಮ್‌; ಕತೋಬಿ ಆ ಅದ್ಮಿ ಕಿಜ್ಜಾ಼ನೊ ಕರೀಬಿ ಹಮೂನ ಮಾಲುಮ್‌ ಕೊಯ್ನಿ!” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","ತದೆ ಯೋ ಅದ್ಮಿನೆ, “ಇನೆ ಮನ ಡೋಳಾ ದಿದೊತೋಬಿ, ಯೋ ಕಿಜ್ಗಾ಼ನೊ ಕರಿ ತುಮೂನ ಬಿಜೂ಼ಬಿ ಮಾಲುಮ್‌ಕೊಂತೆ ಆಶ್ಚರ್ಯ ಕಾಹೆಕಿ ಶು? ");
INSERT INTO vaa_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","ಹಮೂನ ಮಾಲುಮ್‌ ಪಾಪಿನು ಪ್ರಾರ್ಥನೇನ ದೇವ್ ಖ್ಹಮ್‌ಜಾ಼ಕೊಯ್ನಿ, ಕತೋಬಿ ಕೋಣ್ ದೇವ್ನಿ ಮರ್ಜಿನಿಘೋಣಿ ಚಾ಼ಲಾಸ್ಕಿ ಇನಿ ಪ್ರಾರ್ಥನೆ ಖ್ಹಮ್‌ಜಾ಼ಸ್‌ ಕರಿ. ");
INSERT INTO vaa_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","ಪೈದಾಖ್ಹ್‌ಥೂಸ್‌ ಕಾಣು ಹುಯಿರ‍್ಹೂತೆ ಏಕ್‌ ಅದ್ಮಿನ ಕೋಣ್‌ತೋಬಿ ಅಛ್ಛು಼ ಕರ‍್ಯುತೆ ಬಾರೇಮ ಜಗತ್‌ ಶುರುವಾತ್‌ಥು ಏಕ್‌ನೇಬಿ ಖ್ಹಮ್‌ಜಿರಾಖ್ಯು ಕೊಯ್ನಿ. ");
INSERT INTO vaa_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","ಆ ಅದ್ಮಿ ದೇವ್‍ಥಿ ಆಯೊಹುಯೊ ನಾ ರ‍್ಹಯೊಹೋತ್ತೊ, ಅನೇಥಿ ಶಾತ್ಬಿ ಕರಾನ ಕೋ ಹುಯು ಹೋತ್‌ನಿ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","ಆ ವಾತೆನ ಖ್ಹಮ್‌ಜಿನ್‌ ಇವ್ಣೆ, “ತೂ ಖಲಿ ಪಾಪ್‌ಮ ಪೈದಾ ಹುಯೊತೆ, ಹಮೂನ ಬೋಲಿವತಳಾಸ್ಕಿ ಶು?” ಕರಿಬೋಲಿನ್‌, ಸಬೇನು ಮಂದಿರ್‌ಮಾಥು ಇನ ಧಕೇಲಿ ಭಾರ್‌ ಕಾಡಿನಾಖ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","ಯೋ ಅದ್ಮಿನ ಭಾರ್‌ನಾಖ್ಯುಕರಿ ಯೇಸುನೆ ಖ್ಹಮ್‌ಜಿನ್‌, ಇನ ಮಳಿನ್, “ತೂ ಅದ್ಮಿನೊ ಛಿಯ್ಯಾನ ನಂಬಾಸ್ಕಿ ಶು? ಕರಿಪುಛಾ಼ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","ತದೆ ಇನೆ, ಪ್ರಭು ಯೋ ಅದ್ಮಿನೊ ಛಿಯ್ಯೊ ಕೋಣ್? ತೂ ಕಿನ ನಂಬ್‍ಣುಕರಿ ಬೋಲಸ್ಕಿ, ಮನ ಬೋಲ್, ಮೇ ಇನ ನಂಬುಸ್‌” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","ಯೇಸುನೆ ಇನ, “ತೂ ಇನ ಅಗಾಡಿಸ್ ದೇಖಿರಾಕ್ಯೋಸ್‌, ತಾರ ಜೋ಼ಡೆ ವಾತೆ ಬೋಲುಕರಾತೆ ಮೇಸ್ ಯೋ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","ಯೋ ಅದ್ಮಿನೆ, “ಒಹೊ ನಂಬುಸ್‍ಲಾ ಗುರು!” ಕರಿಬೋಲಿನ್‌, ಯೇಸುನ ಖ್ಹಾಮ್ಣೆ ಢುಕ್‌ಣ್ಯಟೇಕಿನ್ ಖ್ಹಲಾಮ್ ಕರ‍್ಯೊ. ಅಡ್‌ಪಡ್ಯೊ ");
INSERT INTO vaa_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","ಯೇಸುನೆ ಬೋಲ್ಯೊ, “ಮೇ ನ್ಯಾಯತೀರ್ಪ್‌ನ ಖ್ಹಾಜೆ ಆ ಜಗತ್‌ಮ ಐರ‍್ಹೋಸ್ತೆ, ಇನಖ್ಹಾಜೆ ಡೋಳಾಕೊಂತೆ ಇವ್ಣೆ ದೇಕ್‌ಶೆ, ಅಜು಼ ಕಿನ ಡೋಳಾ ಛಾ಼ಕಿ ಇವ್ಣೆ ಕಾಣು ಉಶೆ” ಕರಿಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","ಯೇಸುನ ಜೋ಼ಡ್ಮ ಥಾತೆ ಥೋಡ ಫರಿಸಾಯರ್‌ನೆ ಅನ ಖ್ಹಮ್‌ಜಿನ್‌ ಬೋಲ್ಯು, “ಹಮೇಬಿ ಕಾಣಕರಿ ಬೋಲುಕರಾಸ್ಕಿ ಶು?” ಕರಿ ಯೇಸುನ ಪುಛಾ಼ಯು. ");
INSERT INTO vaa_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","ಯೇಸುನೆ ಇವ್ಣುನ, “ತುಮೆ ಕಾಣ ಹುಯಿರ‍್ಹಾಹೋತ್ತೊ, ತುಮೂನ ಪಾಪ್ ಕೋ ರ‍್ಹಯುಹೋತ್ನಿ; ಕತೋಬಿ ಹಮೂನ ಡೋಳಾ ದೆಖವ್‌ಕರಾಸ್‌ ಕರಿ ಬೋಲೋಸ್‌ನಿ, ಇನಖ್ಹಾಜೆ ತುಮೆ ಪಾಪಿ ಹುಯಿರಾಸ್” ಕರಿ ಜವಾಬ್‌ ದಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","ಯೇಸುನೆ, “ಮೇ ತುಮೂನ ಖ್ಹಾಚ ಬೋಲುಸ್, ಮೇಂಢಾನು ಕೋಠಾನ ಬಾಕಲ್‌ನಿವಾಟೆ ಮ್ಹೆಂದಿನ್, ಬಿಜಿ ಬಾಜು಼ಥು ಚ಼ಢೀನ್‌, ಮಹಿ ಜಾ಼ವಾಳೊ ಚೋ಼ರ್ ಅಜು಼ ಲೂಟಿಲಿಜಾ಼ವವಾಳೊ ಹುಯಿರ‍್ಹೋಸ್. ");
INSERT INTO vaa_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","ಕೋಣ್ ಬಾಕಲ್‌ವಾಟೆ ಜಾ಼ವಾಳೊಕಿ ಯೊ ಮೇಂಢಾನ ಚ಼ರಾವವಾಳೊ ಹುಯಿರ‍್ಹೋಸ್. ");
INSERT INTO vaa_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","ನಾಮ್ ಧರೀನ್ ಚಿಕ್‌ರ‍್ಯುತೊ ಮೇಂಢ ಇನಿ ಅವಾಜ಼್‌ನ ಕಾನ್‍ದೇಸ್. ವಖ್ಹ್‌ತಿ ಕರಾವಾಳೊ ಯೋ ಮೇಂಢಾನ ಚ಼ಲೈಲಿನ್ ಜಾ಼ಸ್‌. ");
INSERT INTO vaa_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","ತದೆ ಯೋ ಕುರುಬ ಮೇಂಢಾನ ಖ್ಹಾರು ಭಾರ್‌ ಮ್ಹೇಲಾನಜಾ಼ಸ್ಕಿ ತದೆ, ಮೇಂಢ ಇನಪೀಠೆ ಜಾ಼ಸ್‌. ");
INSERT INTO vaa_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","ಮೇಂಢಖ್ಹಾರು ಇವ್ಣುನ ಮಾಲುಮ್‌ ಕೊಂತೆ ಅಲ್ಹಾವ್ ಅದ್ಮಿನ ಪೀಠೆ ಕೋಜಾ಼ಯ್ನಿ, ಪಣ್ಕಿ ಇಮ್ನ ಅದ್ಮಿಕಂಥು ಮಿಲೈ ಚ಼ಲ್ಯುಜಾ಼ಸ್‌, ಶನಕತೊ ಇವ್ಣುನ ಯೋ ಅದ್ಮಿನು ಗಳು ಮಾಲುಮ್‌ಕೊಯ್ನಿ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","ಆ ಮತ್ಲಬ್‌ನಿ ಖೇಣಿನ ಯೇಸುನೆ ಇವ್ಣುನ ಬೋಲ್ಯೊ, ಕತೋಬಿ ಇವ್ಣೆ ಇನಿ ವಾತೆನಿ ಮತ್ಲಬ್‌ನ ಮಾಲುಮ್ ಕರ‍್ಯುಕೊಯ್ನಿ. ");
INSERT INTO vaa_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","ಇನಖ್ಹಾಜೆ ಯೇಸುನೆ ಪಾಛೊ಼ ಬೋಲ್ಯೊ, “ಮೇ ತುಮೂನ ಖ್ಹಾಚ ಬೋಲುಸ್, ಮೇಸ್ ಮೇಂಢಾನ ಖ್ಹಾರು ದರ‍್ವಾಜು಼ ಹುಯಿರ‍್ಹೋಸ್. ");
INSERT INTO vaa_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","ಮೇ ಆವಾನ ಅಗಾಡಿ ಆಯೂತೆ ಖ್ಹಾರುಸ್‌ ಚೋ಼ರ್ ಅಜು಼ ಲೂಟವಾಳು ಹುಯಿರ‍್ಹುಸ್‍, ಕತೋಬಿ ಮೇಂಢು ಖ್ಹಾರು ಇವ್ಣುನ ಕಾನ್‌ ಕೋ ದಿದೂನಿ. ");
INSERT INTO vaa_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","ಮೇಸ್ ಯೋ ದರ‍್ವಾಜು಼, ಮಾರವಾಟೆ ಕೋಣ್-ಕೋಣ್ ಮಹಿ ಜಾ಼ಸ್ಕಿ ಇವ್ಣೆ ಬಚಿಜಾ಼ಶೆ ಅಜು಼ ಇವ್ಣೆ ಮಹಿ ಜಾ಼ಯೆಜಾ಼ಯ್‌, ಭಾರ್‌ಬಿ ಆಯೆಜಾ಼ಯ್‌, ಇವ್ಣುನ ಚ಼ರಣ್ಣು ಘಾಖ್ಹ್‌ ಮಳ್‌ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","ಚೋ಼ರ್ ಚೋ಼ರಿ ಕರಾನಖ್ಹಾಜೆ, ಮರ್‌ನಾಖಾನಖ್ಹಾಜೆ ಅಜು಼ ಬರ್ಬಾತ್ ಕರಾನಖ್ಹಾಜೆ ಆವಸ್ ಪಣ್ಕಿ, ಬಿಜು಼ ಶನಖ್ಹಾಜೆಬಿ ಕಾಹೆ. ಕತೋಬಿ ಮೇತೊ ಇವ್ಣುನ, ಖಲಿ ಜಾನ್‌ ಕಾಹೆ ಜಿವ್ಣು ದೇವ್ಣುಕರಿ ಐರ‍್ಹೋಸ್ ಯೊ ಜಾ಼ಖ್ಹತ್ ಭರ್‌ಪೂರ್‌ ಜಿವ್ಣು ದೇವ್ಣುಕರಿ ಆಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","ಮೇಸ್ ಅಛ್ಛೊ಼ ಕುರುಬ; ಅಛ್ಛೊ಼ ಕುರುಬ ಇನ ಮೇಂಢ ಖ್ಹಾರಾನಖ್ಹಾಜೆ ಇನು ಜಾನ್ನಾಸ್ ದೇಸ್. ");
INSERT INTO vaa_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","ಕತೋಬಿ ಕೂಲಿಆಳ್‌ ಬೋಲಾಸ್ತೆ ಚ಼ರಾವವಾಳೊಬಿ ಕಾಹೆ, ಮೇಂಢ ಖ್ಹಾರಾನ ಯಜಮಾನ್‌ಬಿ ಕಾಹೆ, ಮೇಂಢು ಶೊಂತ್‍ಬಿ ಕಾಹೆ ಇನಖ್ಹಾಜೆ ಜ಼ರಕ್‌ ಆವಾನು ದೇಕ್ತಾಸ್‌ನ, ಮೇಂಢ ಖ್ಹಾರಾನ ಮ್ಹೇಲಿನ್, ಮಿಲೈ ಚ಼ಲ್ಯೊಜಾ಼ಸ್‌. ತದೆ ಜ಼ರಕ್‌ ಮೇಂಢಪರ್ ಪಡೀನ್, ಝೂ಼ಂಡ್‌ನ ಛಿದ್‍ರೈನಾಖಸ್. ");
INSERT INTO vaa_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","ಯೋ ಕೂಲಿಆಳ್‌ ಮಿಲೈನ್‌, ಚ಼ಲ್ಯುಜಾ಼ಸ್‌ ಶನಕತೊ ಯೋ ಖಲಿಏಕ್‌ ಕೂಲಿ ಆಳ್‌ ಹುಯಿರ‍್ಹೊಸ್, ಇನಖ್ಹಾಜೇಸ್ ಮೇಂಢ ಖ್ಹಾರಾನಿ ಬಾರೇಮ ಇನ ಫಿಕರ್ ಕೋ ರ‍್ಹೇಯ್ನಿ. ");
INSERT INTO vaa_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","ಮೇಸ್ ಅಛ್ಛೊ಼ಕುರುಬ ಹುಯಿರೊಸ್; ಬಾನೆ ಮನ ಅಜು಼ ಮೇ ಬಾನ ಮಾಲುಮ್‌ ಕರಿರಾಖ್ಯೊತೆ ಇಮ್ಮಸ್, ಮೇ ಮಾರ ಮೇಂಢಾವ್ನ ಮಾಲುಮ್ ಕರಿರಾಖ್ಯೋಸ್. ಅಜು಼ ಯೊ ಮೇಂಢಾವ್ನೆ ಮನ ಮಾಲುಮ್ ಕರಿರಾಖ್ಯುಸ್. ಅಜು಼ ಮೇ ಮಾರ ಮೇಂಢಾವ್ನಖ್ಹಾಜೆ ಜಾನ್‌ ದ್ಯವಾನ ತಯಾರ್ ಹುಯಿರಿಶ್. ");
INSERT INTO vaa_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","ಅತ್ರೇಸ್ ಕಾಹೆತೆ, ಆ ಮಂಧಾಮ ಮಳ್ಯುಕೊಂತೆ ಬಿಜು಼ ಖ್ಹಾರು ಮೇಂಢಾಬಿ ಮನ ಛಾ಼, ಇನಾಬಿ ಮೇ ಲೀನಸ್ ಆವ್ಣು, ಇವ್ಣೆ ಮಾರಿ ಅವಾಜ಼್‌ನ ಖ್ಹಮ್‌ಜಾ಼ಸ್‌; ತದೆ ಎಕ್ಕಸ್ ಝೂ಼ಂಡ್‌ ಉಶೆ ಅಜು಼ ಎಕ್ಕಸ್ ಜ಼ಣೊ ಕುರುಬ ರ‍್ಹಿಶೆ. ");
INSERT INTO vaa_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“ಮಾರೊ ಬಾ ಮನ ಪ್ಯಾರ್ ಕರಾಸ್ ಶನಕತೊ ಮೇ ಮಾರ ಜಾನ್ನ ಪಾಛು಼ ಮಳ್‌ಶೆ ಕರಿ ಇನ ದೆವುಸ್. ");
INSERT INTO vaa_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","ಮಾರ ಜಾನ್ನ ಕೋಣ್‌ಬಿ ಮಾರೇಥಿ ಕಾಡಾನ ಕೋ ಹುವಾನಿ. ಮೇ ಮಾರಿ ಖ್ಹುದ್‌ನಿ ಮರ್ಜಿಥಿ ಮಾರ ಜಾನ್ನ ದೆವುಸ್‌ ಮಾರ ಜಾನ್ನ ದ್ಯವಾನ ಅಜು಼ ಪಾಛು಼ ಇನ ಲೀಲ್ಯಾವನ ಮನ ಹಕ್‌ ಛಾ಼. ಆ ಹುಕುಮ್‌ ಮನ ಮಾರ ಬಾಥಿ ಮಳಿರ‍್ಹೀಸ್‌” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","ಯೇಸುನಿ ಆ ವಾತೇಥಿ ಯೆಹೂದ್ಯರ್‌ಮ ಬಿಜು಼ ಪಾಛು಼ ಭಾಗ್‌ ಪಡಿಗಯು. ");
INSERT INTO vaa_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","ಇವ್ಣಾಮ ಘಣು ಜ಼ಣು, “ಅನಾಮ ಭೂತ್‌ ಛಾ಼, ಅನ ದಿವಾನು ಲಾಗಿರ‍್ಹೂಸ್, ತುಮೆ ಶನ ಇನಿ ವಾತೇನ ಖ್ಹಮ್‌ಜೋ಼ಸ್ತೆ?” ಕರಿ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","ಬಿಜು಼ ಥೋಡು ಜ಼ಣು, “ಭೂತ್‌ ಧರಿರಾಖ್ಯುತೆ ಅದ್ಮಿ ಅಮ್ನಿ ವಾತೆ ಕೋ ಬೋಲಾನಿ! ಕಿಮ್ ಭೂತ್‌ ಕಾಣಾನ ಡೋಳಾ ದೆಖಾವಾನಿ ಘೋಣಿ ಕರ್‌ಶೇಕಿ ಶು?” ಕರಿ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","ತದೆ ಯೆರೂಸಲೇಮ್ಮ ಮಂದಿರ್‌ನು ಉಜಾ಼ಖ್ಹ್‌ನಿ ಪೂಜಾ಼ ಚಾ಼ಲುಕರ್ತುಥು, ತದೆ ಠಣ್ಣಾ ದನ್ ಹುಯಿರ‍್ಹಾಥ. ");
INSERT INTO vaa_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","ಯೇಸು ಮಂದಿರ್‌ನ ಮಹಿ ಸೊಲೊಮೋನ್ನು ಮಂಡಪ್‌ಕನ ಚಾ಼ಲ್ಯೊಫಂಡ್‌ತೋಥೊ. ");
INSERT INTO vaa_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","ತದೆ ಯೆಹೂದ್ಯವಾಳು ಇನ ಅಶ್‌ಪಿಶ್ ಐನ್, ಭರಾಯು ಅಜು಼, “ಬಿಜು಼ ಕೆತ್ರ ದನ್ ಹಮಾರೆಥಿ ಖ್ಹಾಚ಼ನ ಮುಶ್ಕಿಲ್‌ಮ ರಾಖಿರಾಖಸ್? ತೂ ಕ್ರಿಸ್ತ ಉಶೇತೊ, ಹಮೂನ ನೇರ್‌ವಳಿಥಿ ಬೋಲ್” ಕರಿ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","ಯೇಸುನೆ, “ಮೇ ಅಗಾಡಿಸ್ ತುಮೂನ ಬೋಲ್ಯೊ, ಕತೋಬಿ ತುಮೆ ಮನ ವಿಶ್ವಾಸ್‌ ಕೋ ಕರ‍್ಯಾನಿ, ಮಾರ ಬಾನ ನಾಮ್‌ಪರ್‌ ಮೇ ಕರುಸ್ತೆ ಅದ್ಭುತ್ ಕಾಮಸ್ ಮನ ಸಾಕ್ಷಿ ಹುಯಿರ‍್ಹುಸ್‍. ");
INSERT INTO vaa_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","ಕತೋಬಿ ಮನ ವಿಶ್ವಾಸ್‌ಕರಾಕೊಂತೆ ಇನಖ್ಹಾಜೆ, ತುಮೆ ಮಾರ ಮೇಂಢ ಕೋ ಹುಯಿರಾನಿ ");
INSERT INTO vaa_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","ಮಾರ ಮೇಂಢ ಮಾರಿ ಅವಾಜ಼್‌ನ ಖ್ಹಮ್‌ಜಾ಼ಸ್‌; ಮನ ಇವ್ಣೆ ಮಾಲುಮ್‌ ಅಜು಼ ಇವ್ಣೆ ಮಾರ ಪೀಠೆ ಆವಸ್. ");
INSERT INTO vaa_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","ಮಾರ ಮೇಂಢಖ್ಹಾರಾನ ಮೇ ಹರ್‌ಹಮೇಶಾನಿ ಜಿ಼ಂದ್‌ಗಿ ದೀಶ್, ಅಜು಼ ಇವ್ಣೆ ಕದೇಬಿ ಮರ್‌ಶೆ ಕೊಯ್ನಿ. ಕೋಣ್‌ಬಿ ಇವ್ಣುನ ಮಾರ ಹಾತ್‌ಮಾಥು ಛಿನಾವಾನ ಕೋ ಉಶೇನಿ. ");
INSERT INTO vaa_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","ಆ ಅಖ್ಖಾನ ಮನ ದಿದೋತೆ ಮಾರ ಬಾ ಖ್ಹಾರೇಥಿ ಮೋಟೊ, ಅಜು಼ ಬಾನ ಹಾತ್‌ಮಾಥು ಕೋಣ್‌ಬಿ ಇವ್ಣುನ ಛಿನಾವಾನ ಕೋ ಹುವಾನಿ. ");
INSERT INTO vaa_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","ಬಾಬಿ, ಮೇ ಎಕ್ಕಸ್ ಹುಯಿರ‍್ಹಾಸ್‌” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","ಪಾಛು಼ ಯೆಹೂದ್ಯರ್ ಯೇಸುನ ಮಾರ‍್ನು ಕರಿ ಬಂಡಾ ಚೂ಼ಣಿಲಿದು. ");
INSERT INTO vaa_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","ತದೆ ಯೇಸುನೆ ಇವ್ಣುನ, “ಬಾನೆ ದಿದೋತೆ ಕೈಯೆಕ್ಕಿ ಅಛ್ಛು಼ ಕಾಮ್ನ ಮೇ ತುಮಾರ ಖ್ಹಾಮ್ಣೆ ಕರಿವತಾಳ್ಯೊ; ಯೋ ಖ್ಹಾರು ಕಾಮ್ಮಾಥು ಕೆಹು ಕಾಮ್ನಟೇಕೆ ಮಾರಪರ್ ತುಮೆ ಬಂಡಾ ಫೇಕ್‌ಣು ಕರಿ ಛಾ಼?” ಕರಿ ಪುಛಾ಼ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","ಯೆಹೂದ್ಯರ್‌ನೆ, “ಹಮೆ ತಾರಪರ್ ಬಂಡಾ ಫೇಕಾನ ಆಯಾತೆ ಅಛ಼್ಛ ಕಾಮ್ನಕರಿ ಕಾಹೆ, ತುನೆ ದೇವ್ನ ಛಿಂಗಾಯೋತೆ ಇನಖ್ಹಾಜೆ, ತೂ ಖಲಿ ಏಕ್‌ ಅದ್ಮಿ ಹುಯಿರ‍್ಹೋಸ್, ಅಜು಼ ತಾರು ತೂಸ್ ದೇವ್ ಕರಿಲ್ಯವಾನ ದೇಖಾಸ್ತೆ ಇನಖ್ಹಾಜೇಸ್ ಬಂಡಾ ಫೇಕಾನ ಆಯಾತೆ!” ಕರಿ ಜವಾಬ್‌ ದಿದು. ");
INSERT INTO vaa_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","ತದೆ ಯೇಸುನೆ, “ತುಮೆ ದೇವ್‌ಖ್ಹಾರು ಹುಯಿರ‍್ಹಾಸ್‌’ ಕರಿ ದೇವ್ನೆ ಬೋಲ್ಯೊತೆ ತುಮಾರಿ ಧರ್ಮಶಾಸ್ತ್ರಮ ಲೀಖೈರ‍್ಹುಸ್ ಕೊಯ್ನಿಕಿಶು?” ಕರಿ ಜವಾಬ್‌ ದಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","ಧರ್ಮಶಾಸ್ತ್ರ ಕದೇಬಿ ಝೂ಼ಟಿ ಕೋ ಹುವಾನಿ; ದೇವ್ನಿವಚನ್ನ ಲೀರಾಖವಾಳನ ದೇವ್‌ಖ್ಹಾರುಕರಿ ಯೋ ಬೋಲಾನು ರ‍್ಹಯುತೊ ");
INSERT INTO vaa_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","ಬಾನೇಸ್ ಇನು ಶೊಂತ್‍ಛಿಯ್ಯೊನ ಚೂ಼ಣಿಲೀನ್, ಜಗತ್‌ಮ ಬೋಲಿ ಮೋಕ್‌ಲೈರ‍್ಹೋತೆ ಇನ ತುಮೆ ‘ಮೇ ದೇವ್‌ನೊ ಛಿಯ್ಯೊ ಹುಯಿರ‍್ಹೋಸ್ ಕರಿ ಬೋಲ್ತಾನ, ‘ತೂ ದೇವ್ನಿ ದೂಷಣೆ ಕರಾಸ್’ ಕರಿ ಬೋಲಸ್ತೆ ಶನ? ");
INSERT INTO vaa_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","ಮೇ ಮಾರೊ ಬಾ ಬೋಲಾತೆ ಕಾಮ್ನ ನಾ ಕರ‍್ಯೊ ಉಶೇತೊ, ಮಾರಿ ವಾತೇನ ನಕೊ ನಂಬೊ. ");
INSERT INTO vaa_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","ಕತೋಬಿ “ಮೇ ಅಮ್ ಕರ‍್ಯೊತೆ ಇನಖ್ಹಾಜೆ ಮನ ತುಮೆ ವಿಶ್ವಾಸ್‌ ಕೊ ಕರಾನಿ, ಆ ಕಾಮ್ನ ದೇಖಿನ್‌ ತೋಬಿ ನಂಬೊ. ತದೆ ಮಾರ ಮಹಿ ಬಾ ಛಾ಼ ಕರೀಬಿ, ಅಜು಼ ಬಾನ ಮಹಿ ಮೇ ಛೂ಼ ಕರೀಬಿ ತುಮೆ ಮಾಲುಮ್‌ ಕರಿಲಿಶು” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","ಇವ್ಣೆ ಬಿಜು಼ ಪಾಛು಼ ಯೇಸುನ ಧರ್‌ನು ಕರಿ ಕರ‍್ಯು, ಕತೋಬಿ ಯೋ ಇವ್ಣೇಥಿ ಛು಼ಕಿನ್ ನಿಕ್ಳಿಗಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","ಅನ ಬಾದ್‌ಮ ಯೇಸು ಯೊರ್ದನ್‌ ನದ್ದಿನು ಪಾರ್ಲಿ ಬಾಜೂ಼ಮ ಯೋಹಾನ ಅಗಾಡಿ ಬ್ಯಾಪ್ತಿಸ್ಮ ದೆವಾಡು ಕರ್ತೊಥೋತೆ, ಯೋ ಝ಼ಗೋಕನ ಪಾಛು಼ ಜೈ಼ನ್‌, ಹಿಜ್ಜಾ಼ಸ್ ಥೊ. ");
INSERT INTO vaa_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","ಕೈಯೆಕ್ಕಿ ಅದ್ಮಿಖ್ಹಾರು ಇನಾಕನ ಐನ್, “ಯೋಹಾನನೆ ಕದೇಬಿ ಏಕ್‌ ಖ್ಹಣೇದ್‌ಬಿ ಕರ‍್ಯೊಕೊಯ್ನಿ, ಕತೋಬಿ ಆ ಅದ್ಮಿನಿ ಬಾರೇಮ ಯೋಹಾನನೆ ಬೋಲ್ಯೋತೆ ಹರೇಕ್ ವಾತೇಬಿ ಖ್ಹಾಚಿಸ್” ಕರಿ ವಾತೆ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","ಅಜು಼ ಯೊ ಝ಼ಗೊ ಕೈಯೆಕ್ಕಿ ಅದ್ಮಿ ಯೇಸುಪರ್ ವಿಶ್ವಾಸ್‌ ಕರ‍್ಯು. ");
INSERT INTO vaa_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","ಬೇಥಾನ್ಯಮ ಲಾಜ಼ರ್‌ ಕರಿ ಏಕ್‌ ಜ಼ಣೊ ಥೊ, ಇನ ಜಾನ್ನ ಅಛ್ಛು಼ ಕೋ ಥೂನಿ. ಮರಿಯ ಅಜು಼ ಇನಿ ಭೇನ್ ಮಾರ್ಥ ಆಸ್ ಗಾಮ್ಮ ರ‍್ಹೇತಿಥಿ. ");
INSERT INTO vaa_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","ಆ ಮರಿಯ ಕೋಣ್‌ಕತೊ, ಯೇಸು ಪ್ರಭು ಗೋಡಾನ ವಾನುತೇಲ್‌ನ ಲಗಾಡಿನ್, ಇನ ಕೇಖ್ಹ್‌ಥಿ ಗೋಡ ನೂಛಿತೆ ಆಸ್. ಜಾನ್ನ ಅಛ್ಛು಼ ಕೋಹುವಾಂತೆ ಲಾಜ಼ರ್‌ ಅನೋಸ್ ಭೈ. ");
INSERT INTO vaa_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","ಇನಖ್ಹಾಜೆ, ಇನಿ ಭೇನೇನೆ, “ಪ್ರಭು, ತಾರೊ ಪ್ಯಾರ್‌ನೊ ದೋಸ್ತಿನ ಜಾನ್ನ ಅಛ್ಛು಼ ಕೊಯ್ನಿ” ಕರಿ ಬೋಲಾನಿ ಖಬರ್‌ನ ಯೇಸುಕನ ಮೋಕ್ಲಿಯೆ಼. ");
INSERT INTO vaa_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","ಯೇಸುನೆ ಅನ ಖ್ಹಮ್‌ಜಿನ್‌ ಬೋಲ್ಯೊ, “ಲಾಜ಼ರ್‌ನ ರೋಗ್‌ ಐರ‍್ಹೂಸ್ತೆ ಮರಣ್ಣಖ್ಹಾಜೆ ಕಾಹೆ, ಅನೇಥಿ ದೇವ್ನ ಅಜು಼ ದೇವ್‌ನೊ ಛಿಯ್ಯಾನ ಮಹಿಮೆ ಮಳಾದೆ ಕರಿ ಆ ಐರ‍್ಹೂಸ್ತೆ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","ಯೇಸುನ ಮಾರ್ಥಪರ್, ಇನಿ ಭೇನ್‌ಪರ್ ಅಜು಼ ಲಾಜ಼ರ್‌ಪರ್ ಪ್ಯಾರ್ ಥೂ. ");
INSERT INTO vaa_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","ತೋಬಿ ಲಾಜ಼ರ್‌ನ ಜಾನ್ನ ಅಛ್ಛು಼ ಕೊಯ್ನಿ ಕರಿ ಖಬರ್‌ನ ಖ್ಹಮ್‌ಜಿನ್‌ಬಿ, ಯೋ ಥೋತೆ ಹಿಜ್ಜಾ಼ಸ್ ಬಿಜೂ಼ಬಿ ಬೇ ದನ್ ರ‍್ಹಿಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","ಅನ ಬಾದ್‌ಮ ಯೇಸುನೆ ಇನ ಶಿಷ್ಯರ್‌ನ, “ಅಪ್ಣೆ ಯೂದಾಯಾನ ಪಾಛು಼ ಫರಿ ಜ಼ಯ್ಯೆ಼” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","ತದೆ ಶಿಷ್ಯರ್‌ನೆ, “ಗುರು, ಥೋಡ ದನ್ನ ಅಗಾಡಿಸ್ ಯೆಹೂದ್ಯರ್ ತುನ ಬಂಡಾ ಫೇಕಿನ್‌ ಮಾರ‍್ನು ಕರಿ ಆಯುಥು. ಹಮ್ಕೆ ತೂ ಪಾಛು಼ ಹಿಜ್ಜಾ಼ ಜಾ಼ಸ್ಕಿ ಶು?” ಕರಿ ಬೋಲ್ಯ. ");
INSERT INTO vaa_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","ಯೇಸುನೆ, “ದನ್ನು ಭಾರ ಘಂಟಾ ಛಾ಼, ಕಾಹೆಕಿ ಶು? ದನ್ನಿ ವಖ್ಹತ್‌ಮ ಚಾ಼ಲವಾಳು ಠೋಕರ್‌ಖೈನ್‌ ರಡ್ಕಕೊಯ್ನಿ, ಶನಕತೊ ಆ ಜಗತ್‌ನು ಉಜಾ಼ಳು ಇವ್ಣುನ ದೆಖಾವಸ್. ");
INSERT INTO vaa_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","ಕತೋಬಿ ರಾತ್ನಿ ವಖ್ಹತ್‌ಮ ಚಾ಼ಲವಾಳು ಠೋಕರ್‌ ಖಾಸ್‌, ಶನಕತೊ ತದೆ ಕೆಹು ಉಜಾ಼ಳುಬಿ ಕೋ ರ‍್ಹೇಯ್ನಿತೆ ಇನಖ್ಹಾಜೆ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","ಯೇಸುನೆ ಆ ವಾತೇನ ಬೋಲಿನ್, “ಅಪ್ಣೊ ದೋಸ್ತಿ ಲಾಜ಼ರ್‌ ಖ್ಹುತೋಸ್‌, ಇನ ಉಠಾಡಾನಟೇಕೆ ಮೇ ಹಿಜ್ಜಾ಼ ವಳ್ಯೊಜ಼ವುಸ್‌” ಕರಿ ಇವ್ಣುನ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","ಶಿಷ್ಯರ್‌ನೆ, “ಪ್ರಭು, ಯೋ ಖ್ಹುತೊ ಉಶೇತೊ, ಇನ ಅಛ್ಛು಼ ಉಶೆ” ಕರಿ ಜ಼ವಾಬ್ ದಿದು. ");
INSERT INTO vaa_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","ಯೇಸುನೆ ಲಾಜ಼ರ್‌ ಮರಿಗಯೋತೆ ಬಾರೇಮ ಬೋಲ್ಯೋತೆ, ಕತೋಬಿ ಶಿಷ್ಯರ್‌ನೆ ಲಾಜ಼ರ್‌ ಖ್ಹುಯಿನ್ ಅರಾಮ್‌ ಕರುಕರಸ್ ಕರಿ ಇನೆ ಬೋಲ್ಯೋತೆ ವಾತೆನಿ ಮತ್‌ಲಬ್ ಕರಿ ಸೋಚ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","ಇನಖ್ಹಾಜೆ ಯೇಸುನೆ ನೇರ್‌ವಳಿಥಿ ಇವ್ಣುನ, “ಲಾಜ಼ರ್‌ ಮರಿಗಯೊ” ಕರಿ. ");
INSERT INTO vaa_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","ಮೇ ಹಿಜ್ಜಾ಼ ಕೋ ಥೋನಿತೆ ಇನಖ್ಹಾಜೆ, ತುಮಾರಿ ಬಾರೇಮ ಮೇ ಖ್ಹುಶಿ ಕರುಸ್, ಶನಕತೊ ಅನೇಥಿ ತುಮೆ ಮಾರಪರ್ ವಿಶ್ವಾಸ್‌ ಕರ್ಶು. ಆವೊ ಇನಾಕನ ಜ಼ಯ್ಯೆ಼” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","ತದೆ ದಿದುಮ ಕರಿ ನಾಮ್ನೊ ತೋಮನೆ ಇನ ಜೋ಼ಡ್ನ ಖ್ಹಾರ ಶಿಷ್ಯರ್‌ನ, “ಅಪ್ಣೇಬಿ ಪ್ರಭುನ ಕೇಡೆಸ್ ಜೈ಼ನ್‌, ಮರ‍್ವನಿತರ ಹುಯ್ಯೆ಼” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","ಯೇಸು ಬೇಥಾನ್ಯಮ ಆವಾದಿನ್, ಲಾಜ಼ರ್‌ನ ಮಖ್ಹಾಣ್ಯನಿ ಘವಿಮ ಮ್ಹೇಲಿನ್ ಚಾರ್ ದನ್ ಹುಯಿಗಾ ಕರಿ ಇನ ಮಾಲುಮ್‌ ಪಡ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","ಬೇಥಾನ್ಯ ಯೆರೂಸಲೇಮ್‌ಥು ಖ್ಹುಮಾರ್ ಬೇ ಮೈಲ್‍ಥಿ ಕಮ್ಮಸ್ ದೂರ್ ಥೂ. ");
INSERT INTO vaa_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","ಇನಖ್ಹಾಜೆ ಇವ್ಣೊ ಭೈ ಮರಿಗಯೋತೆ ಬಾರೇಮ ಭಾಲಿ ದ್ಯವಾನ.ಯೆಹೂದ್ಯರ್‌ಮ ಘಣು ಜ಼ಣು ಮಾರ್ಥ ಅಜು಼ ಮರಿಯಕನ ಐರ‍್ಹುಥು. ");
INSERT INTO vaa_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","ಯೇಸು ವಳ್ಯಾವಸ್ ಕರಿ ಮಾರ್ಥನೆ ಖ್ಹಮ್‌ಜಿನ್‌, ಇನ ಮಳಾನಖ್ಹಾಜೆ ಗೈ, ಕತೋಬಿ ಮರಿಯ ಘರ್‌ಮಾಸ್ ಥೀ. ");
INSERT INTO vaa_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","ಮಾರ್ಥನೆ ಯೇಸುನ, “ಪ್ರಭು, ತೂ ಹಜ಼್ಜ ರ‍್ಹಯೊಹೋತ್ತೊ, ಮಾರೊ ಭೈ ಮರ‍್ಯೊಹೋತ್‌ ಕೊಯ್ನಿ. ");
INSERT INTO vaa_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","ಕತೋಬಿ ಹಮ್ಕೇಬಿ, ತೂ ದೇವ್‌ಕನ ಶಾತ್‌ ಮಾಂಗ್ಯೊತೋಬಿ, ದೇವ್ ತುನ ದಿಶೆ ಕರಿ ಮನ ಮಾಲುಮ್‌” ಕರಿ ಬೋಲಿ. ");
INSERT INTO vaa_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","ಯೇಸುನೆ ಇನ, “ತಾರೊ ಭೈ ಜಿವ್ತೊಹುಯಿನ್ ಉಠಿಆವ್‌ಶೆ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","ತದೆ ಮಾರ್ಥನೆ, “ಅಂತಿಮ್‌ ದನ್ಮ ಯೋ ಪಾಛು಼ಜಿವ್ತೊಹುಯಿನ್ ಉಠಿ ಆವ್‍ಶೆಕರಿ ಮನ ಮಾಲುಮ್‌” ಕರಿ ಫರೈನ್ ಬೋಲಿ. ");
INSERT INTO vaa_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","ಯೇಸುನೆ ಇನ, “ಮೇಸ್ ಪಾಛು಼ಜಿವ್ತೊ ಹುಯಿರ‍್ಹವಾಳೋಬಿ, ಜಾನ್‌ಬಿ ಹುಯಿರ‍್ಹೋಸ್. ಮನ ನಂಬವಾಳೊ ಮರಿಗಯೊತೋಬಿ ಜಿವ್‌ಶೆ; ");
INSERT INTO vaa_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","ಅಜು಼ ಬಚಿರ‍್ಹವಾಳೊ ಹರೇಕ್‌ಜ಼ಣೊ , ಮನ ನಂಬ್ಯೊತೊ ಯೊ ಕದೇಬಿ ಮರ್‌ಶೆಕೊಯ್ನಿ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","ತದೆ ಇನೆ, “ಓಹೋಲಾ, ಪ್ರಭು! ಆ ಜಗತ್ನ ಆವ್ಣುತೆ ದೇವ್‌ನೊ ಛಿಯ್ಯೊ ಹುಯಿರ‍್ಹೋತೆ ಕ್ರಿಸ್ತ ತೂಸ್ ಕರಿ ಮೇ ನಂಬಿರಾಖಿಸ್‌” ಕರಿ ಬೋಲಿ. ");
INSERT INTO vaa_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","ಆ ಬೋಲಾನ ಬಾದ್‌ಮ ಮಾರ್ಥನೆ ಜೈ಼ನ್‌, ಇನಿ ಭೇನ್ ಮರಿಯನ ಕಿನಾಬಿ ಮಾಲುಮ್‌ಕೊಂತೆ ಇಮ್‌, “ಗುರು ಹಜ್ಜಾ಼ ಛಾ಼, ತುನ ಬುಲಾವ್ ಕರಾಸ್” ಕರಿ ಬೋಲಿ. ");
INSERT INTO vaa_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","ಅನ ಖ್ಹಮಜ಼್‌ತಾಸ್‌ನ ಮರಿಯ ಫಟ್‌ಕರಿ ಉಠೀನ್, ಒಗ್ಗಿಸ್‌ಮ ಯೇಸುಕನ ಚ಼ಲಿಗೈ. ");
INSERT INTO vaa_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","ಯೇಸು ಬಿಜೂ಼ಬಿ ಗಾಮ್‌ನ ಮಹಿ ಕೋ ಆಯೊಥೋನಿ, ಮಾರ್ಥನೆ ಇನ ಮಳಿತೆ ಝ಼ಗೋಕನಾಸ್‌ ಥೊ. ");
INSERT INTO vaa_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","ಮರಿಯನ ಜೋ಼ಡೆ ಘರ್‌ಮ ರ‍್ಹೀನ್, ಇನ ಭಾಲಿ ದೆವ್‌ಕರ್‌ತುಥೂತೆ ಯೆಹೂದ್ಯರ್, ಯೋ ಫಟ್‌ ಕರಿ ಉಠೀನ್ ಭಾರ್ ವಳಿಜಾ಼ಯಿತೆ ದೇಖಿನ್‌, ಆ ರೊವಾನಖ್ಹಾಜೆ ಘವಿಕನ ವಳಿಜಾ಼ಸ್ಕಿ ಶುಕಿ? ಕರಿ ಸೋಚಿನ್, ಇನ ಪೀಠೆ ಗಯು. ");
INSERT INTO vaa_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","ಮರಿಯ ಯೇಸು ಥೋತೆ ಹಿಜ್ಜಾ಼ ಐನ್, ಇನ ದೇಕ್ತಾಸ್‌ನ, ಇನ ಗೋಡಾಪರ್ ಪಡೀನ್ “ಪ್ರಭು, ತೂ ಹಜ್ಜಾ಼ ರ‍್ಹಯೊಹೋತ್ತೊ ಮಾರೊ ಭೈ ಮರ‍್ಯೊಹೋತ್‌ ಕೊಯ್ನಿ” ಕರಿ ಬೋಲಿ. ");
INSERT INTO vaa_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","ಮರಿಯಬಿ ಇನಜೋ಼ಡೆ ಆಯುಥೂತೆ ಯೆಹೂದ್ಯರ್‌ಖ್ಹಾರು ರೊವ್‌ಕರಾತೆ ಯೇಸುನೆ ದೇಖಿನ್‌, ಇನ ಆತ್ಮಮ ಪಶ್‍ತೈನ್ ಘಣು ದುಖ್‌ಹುಯು. ");
INSERT INTO vaa_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","ಯೇಸುನೆ, “ತುಮೆ ಇನ ಕಿಜ್ಗಾ಼ ಮ್ಹೇಲಿರಾಖ್ಯಸ್?” ಕರಿ ಪುಛಾ಼ಯೊ. ತದೆ ಇವ್ಣೆ, “ಐನ್, ದೇಕ್‌ಲಾ ಪ್ರಭು” ಕರಿ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","ಯೇಸು ರೋಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","ಇನ ಯೆಹೂದ್ಯರ್‌ನೆ, “ದೇಖೊ! ಆ ಇನಾಪರ್‌ ಕೆತ್ರೆ ಪ್ಯಾರ್ ರಾಖಿರಾಖ್ಯೋಸ್”! ಕರಿ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","ಕತೋಬಿ ಇವ್ಣಾಮ ಥೋಡು ಜ಼ಣು, “ಅನೆ ಯೋ ಕಾಣಾನ ದೆಖಾವಾನಿ ಘೋಣಿ ಕರ‍್ಯೋನಿ? ಲಾಜ಼ರ್‌ನಾಬಿ ಮರಣ್‌ಥು ಬಚಾ಼ಡೇಜಾ಼ಯ್‍ಥೂನಿ?” ಕರಿ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","ಯೇಸು ಪಾಛೊ಼ ಇನ ದಿಲ್ಮ ಘಣು ದುಖ್ ಕರ್ತೊಹುಯಿನ್, ಮಖ್ಹಾಣ್ಯನಿ ಘವಿಕನ ಗಯೊ, ಯೋ ಘವಿನ ಬಂಡಾನಿ ಚಿಪಾಟ್‌ಥಿ ಮೂಚಿರಾಖ್ಯುಥು. ");
INSERT INTO vaa_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","“ಯೋ ಬಂಡಾನ ಕಾಡೊ” ಕರಿ ಯೇಸುನೆ ಹುಕುಮ್‌ ದಿದೊ. ಮರ‍್ಯಾಹುಯಾನಿ ಭೇನ್ ಮಾರ್ಥನೆ, “ಪ್ರಭು, ಯೋ ಮರಿನ್‌ ಚಾರ್ ದನ್ ಹುಯಿಗಾ! ಹಿಜ್ಜಾ಼ ಘಣಿ ವಾಖ್ಹ್‌ ಉಶೆ” ಕರಿ ಬೋಲಿ. ");
INSERT INTO vaa_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","ಯೇಸುನೆ ಇನ, “ಮೇ ತುನ ಬೋಲ್ಯೊ ಕೊಯ್ನಿಕಿಶು ತೂ ನಂಬಿತೊ, ದೇವ್ನಿ ಮಹಿಮೆನ ದೇಖಿಶ್‌” ಕರಿಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","ಇವ್ಣೆ ಬಂಡಾನ ಕಾಡಿನಾಖ್ಯು. ತದೆ ಯೇಸುನೆ ಡೋಳಾ ಪಾಡೀನ್, ಉಪ್ಪರ್ ದೇಖಿನ್‌, “ಬಾ, ತೂ ಮಾರಿ ಪ್ರಾರ್ಥನೇನ ಖ್ಹಮ್‌ಜ್ಯೂತೆ ಇನಖ್ಹಾಜೆ ತುನ ಧನ್ಯವಾದ್. ");
INSERT INTO vaa_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","ತೂ ಕದೇಬಿ ಮಾರಿ ಪ್ರಾರ್ಥನೆ ಖ್ಹಮ್‌ಜಾ಼ಸ್‌ ಕರಿ ಮನ ಮಾಲುಮ್‌, ತೋಬಿ ತುನೇಸ್ ಮನ ಬೋಲಿಮೋಕ್‌ಲ್ಯೊ ಕರಿ ಬೋಲಾನು, ಅಶ್‌ಪೀಶ್‌ ಭಿಯುತೆ ಅದ್ಮಿಖ್ಹಾರು ವಿಶ್ವಾಸ್‌ ಕರಾದೆ ಕರಿ, ಮೇ ಆ ವಾತೇನ ಬೋಲ್ಯೊ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","ಆ ಬೋಲಾನ ಬಾದ್‌ಮ, ಯೇಸುನೆ ಜೋ಼ರೆಥಿ ಚಿಕ್ರಿನ್, “ಲಾಜ಼ರ್‌, ಭಾರ್‌ ಉಠೀನ್ ಆವ್!” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","ತದೆ ಮರಿಗಯೊಹುಯೊ ಉಠೀನ್ ಫಾದರ್ ಆಯೊ, ಇನ ಹಾತ್‌-ಗೋಡ, ಮ್ಹೋಡು ಮರ‍್ಯಮುರ್ದಾನ ಲುಂಗ್ಡಾಥಿ ಲಪೆಟೈರ‍್ಹೂಥು. ಯೇಸುನೆ ಇವ್ಣುನ, “ಇನ ಛೋ಼ಡೊ, ಯೋ ಜಾ಼ವಾದೆ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","ಮರಿಯನ ಮಳಾನ ಆಯುಥೂತೆ ಯೆಹೂದ್ಯರ್, ಯೇಸುನೆ ಕರ‍್ಯೊತೆ ಆ ಕಾಮ್ನ ದೇಖಿನ್‌, ಇವ್ಣಾಮ ಕೈಏಕ್ ಜ಼ಣು ಇನಾಪರ್‌ ವಿಶ್ವಾಸ್‌ ಕರ‍್ಯು. ");
INSERT INTO vaa_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","ಕತೋಬಿ ಇವ್ಣಾಮ ಥೋಡಾನೆ ಫರಿಸಾಯರ್‌ಕನ ಜೈ಼ನ್‌, ಯೇಸುನೆ ಕರ‍್ಯೊತೆ ಇನಿ ಬಾರೇಮ ಇವ್ಣುನ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","ತದೆ ಮಹಾಯಾಜಕರ್‌ ಅಜು಼ ಫರಿಸಾಯರ್‌ನೆ ಶಾಣಾವ್‍ನಿ ಸಭೆ ಎಕ್ಟು ಕರೀನ್, “ಆ ಅದ್ಮಿ ಘಣು ಅದ್ಭುತ್ ಕಾಮ್ ಕರಾಸ್ನಿ,ಅಪ್ಣೆ ಶಾತ್‌ ಕರಿಯೆ? ");
INSERT INTO vaa_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","ಅಪ್ಣೆ ಅನ ಅಮ್ಮಸ್ ಮ್ಹೆಂದಿದಾತೊ, ಹರೇಕ್ ಅದ್ಮಿ ಅನ ನಂಬಿಜಾ಼ಶೆ. ತದೆ ರೋಮ್‌ವಾಳು ಐನ್, ಅಪ್ಣಿ ಮಂದಿರ್‌ನ ಅಜು಼ ಅಪ್ಣ ದೇಖ್ಹ್‌ನ ಬರ್ಬಾತ್ ಕರಿನಾಕ್‌ಶೆ!” ಕರಿ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","ಇವ್ಣಾಮ ಕಾಯಫ ಕರಿ ಏಕ್‌ ಜ಼ಣೊ ಥೊ. ಯೋ ವರ್‌ಖ್ಹೆ ಯೋ ಮಹಾಯಾಜಕ್ ಹುಯಿರ‍್ಹೋಥೊ, ಇನೆ ಇವ್ಣುನ, “ತುಮುನ ಶಾತ್ಬಿ ಮಾಲುಮ್ ಕೊಯ್ನಿ! ");
INSERT INTO vaa_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","ಹಿಡಿ ದೇಖ್ಹ್‌ ಬರ್ಬಾತ್ ಹುವಾಥೀಬಿ, ಏಕ್‌ ಅದ್ಮಿ ತಮಾಮ್‌ ಅದ್ಮಿನಖ್ಹಾಜೆ ಮರ್‌ವಾನುಸ್‌ ಅಛ್ಛು಼ ಕರಿ ತುಮೆ ಶನ ಮಾಲುಮ್‌ ಕರಿಲೆವ್‌ಕರಾಕೊಂತೆ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","ಆ ವಾತೆ ಕಾಯಫಾನಿ ಶೊಂತ್ ಸೋಚ್ ಕೋ ಹುಯಿರ‍್ಹೀಥೀನಿ. ಯೋ ವರಖ್ಹ್‌ಮ ಯೋ ಗಲ್‌ಢೊಯಾಜಕ್‌ ಹುಯಿರ‍್ಹೊಥೋತೆ ಇನಖ್ಹಾಜೆ, ಯೇಸು ಯೆಹುದ್ಯರ್‌ ಅದ್ಮಿವೊನಖ್ಹಾಜೆ ಮರ್‌ಶೆ ಕರಿ ಪ್ರವಾದ್‌ನೆ ಬೋಲ್ಯೊತೆ. ");
INSERT INTO vaa_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","ಖಲಿ ಯೆಹೂದ್ಯರ್‌ನಖ್ಹಾಜೆ ಕಾಹೆ, ಪಣ್ಕಿ ಛಿದ್‍ರೈಗಯುತೆ ದೇವ್‌ನು ಅದ್ಮಿಖ್ಹಾರಾನ ಎಕ್ಟು ಕರಾನಖ್ಹಾಜೆ ಯೇಸು ಮರವಾಳೊ ಥೊ. ");
INSERT INTO vaa_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","ಯೋ ದನ್‌ಥು ಯೇಸುನ ಮಾರ‍್ನು ಕರಿ ಇವ್ಣೆ ಸೋಚಾಲಗ್ಯು,ಯೋ ಅಖ್ಖು ಪ್ರವಾದನೆ ಹುಯಿರ‍್ಹುಥು. ");
INSERT INTO vaa_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","ಅನಖ್ಹಾಜೆ ಯೇಸು ಯೆಹೂದ್ಯರ್‌ನ ದೆಖಾನಿಘೋಣಿ ಫರಾನು ಮ್ಹೆಂದಿನ್, ಉಜ್ಜಾ಼ಡಿ ಝ಼ಗೋನ ಖನ್ನೆ ಥೂತೆ, ಎಫ್ರಾಯಿಮ್‌ ಕರಿ ಖ್ಹಯೇರ್‌ಮ ಜೈ಼ನ್‌ ಶಿಷ್ಯರ್‌ನ ಜೋ಼ಡ್ಮ ರಹಿಗೊ. ");
INSERT INTO vaa_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","ಯೆಹೂದ್ಯರ್‌ನ ಪಸ್ಕ ಪೂಜಾ಼ನಿ ವಖ್ಹತ್ ಖನ್ನೆ ಐಗೈಥಿ, ಇನಖ್ಹಾಜೆ ಅದ್ಮಿಖ್ಹಾರು ಉಪ್ಲಿಬಾಜು಼ ಚ಼ಲಿಗಯುಥು. ಪೂಜಾ಼ಥಿ ಪಹಿಲೆ ಇವ್ಣುನ ಶುದ್ದಿಕರಣ್ ಕರಿಲೇವ್ಣು ಕರಿ ಗಾಮ್‌ಥು ಯೆರೂಸಲೇಮ್‌ ಆಯು. ");
INSERT INTO vaa_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","ಇವ್ಣೆ ಯೇಸುನ ಢೂಂಡ್‌ತುಹುಯಿನ್ ದೇವ್ನಿಮಂದಿರ್‌ಮ ಭೀರಿನ್‌, “ತುಮೂನ ಕಿಮ್ ಸೊಚಾವಸ್‌ ಯೋ ಪೂಜಾ಼ನ ಆವ್‌ಶೆಸ್‌ ಕೊಯ್ನಿಕಿ ಶು?” ಕರಿ ಏಕ್‌ಥಿ-ಏಕ್‌ ಬೋಲಿಲಿದು. ");
INSERT INTO vaa_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","ಮಹಾಯಾಜಕರ್‌ ಅಜು಼ ಫರಿಸಾಯರ್ ಯೇಸು ಕಿಜ್ಗಾ಼ ಛಾ಼ ಕರಿ ಕಿನಾಬಿ ಮಾಲುಮ್‌ ಪಡ್ಯುತೊ, ಹಮೂನ ಬೋಲ್‌ನು ಕರಿ ಹುಕುಮ್‌ ದಿದು. ಶನಕತೊ ಇವ್ಣೆ ಇನ ಧರ್‌ನು ಕರಿ ಥೂ. ");
INSERT INTO vaa_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","ಪಸ್ಕ ಪೂಜಾ಼ನ ಛೊ಼ ದನ್ನ ಪಾಛ಼ಳ್ ಯೇಸು ಬೇಥಾನ್ಯ ಗಾಮ್‌ನ ಗಯೊ, ಯೇಸುನೆ ಮರ‍್ಯಾಹುಯಾಮಾಥು ಜಿವ್ತೊ ಉಠಾಡ್ಯೋತೆ ಲಾಜ಼ರ್‌ಬಿ ಹಿಜ್ಜಾ಼ಸ್ ರ‍್ಹೇತೊಥೊ. ");
INSERT INTO vaa_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","ಯೇಸುನಖ್ಹಾಜೆ ಹಿಜ್ಜಾ಼ ಖಾಣು ತೈಯಾರ್ ಕರಿರಾಖ್ಯುಥು, ಮಾರ್ಥ ಖಾಣು ನಾಖಿನ್ ದೇವ್‌ಕರ್ತೀಥಿ, ಯೇಸುನ ಜೋ಼ಡೆ ಖಾಣನ ಬೆಠುಥೂತೆ ಇವ್ಣಾಮ ಲಾಜ಼ರ್‌ಬಿ ಏಕ್‌ ಜ಼ಣೊ. ");
INSERT INTO vaa_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","ತದೆ ಮರಿಯನೆ, ಘಣ ಮೋಲ್ನು ಜಟಮಂಸಿ ವಾನು ತೇಲ್ನ ಲೈನ್‌, ಯೇಸುನ ಗೋಡಾಪರ್ ರಂಚಿನ್, ಇನ ಮುಡ್‌ಕ್ಯಾನ ಕೇಖ್ಹ್‌ಥಿ ಯೇಸುನ ಗೋಡ ನೂಛಿ. ಯೋ ತೇಲ್ನಿ ಮಿಠ್ಠಿ ವಾಖ್ಹ್‌ ಹಿಡಿ ಘರ್ ಅಖ್ಖುಸ್ ಮಹಿಕವ್‍ಕರ‍್ತುಥು. ");
INSERT INTO vaa_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","ಇನ ಶಿಷ್ಯರ್‌ಮ ಏಕ್‌ ಜ಼ಣೊ ಹುಯಿರ‍್ಹೋತೆ, ಕತೊ (ಇನ ಧೋಕೇಥಿ ಧರಿದ್ಯವಾಳೊ ಇಸ್ಕರಿಯೋತ ಯೂದಾನೆ), ");
INSERT INTO vaa_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“ಆ ತೇಲ್ನ ತೀನ್‌ಖ್ಹೊ ರೂಪಾನು ಪಾವ್ಲನ ವೇಚಿನ್, ಗರೀಬ್‌ನ ಶನ ಕೋದಿದಿನಿ?” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","ಗೋರ್‌-ಗರೀಬ್‌ನಿ ಬಾರೇಮ ಫಿಕರ್ ಕರೀನ್, ಆ ವಾತೇನ ಬೋಲ್ಯೋತೆ ಕಾಹೆ, ಪಣ್ಕಿ ಯೋ ಚೋ಼ರ್ ಹುಯಿರ‍್ಹೊಥೋತೆ ಇನಖ್ಹಾಜೇಸ್ ಅಮ್ ಬೋಲ್ಯೋತೆ.ಅಜು಼ ಪೈಶಾನಿ ಚ಼ಂಚಿ ಇನ ಹಾತ್‌ಮ ರ‍್ಹೇತುಥು, ಯೋ ಚ಼ಂಚಿಮ ನಾಖಸ್ತೆ ಪೈಶಾನ ಯೋ ಕಾಡಿಲೇತೋಥೊ. ");
INSERT INTO vaa_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","ಕತೋಬಿ ಯೇಸುನೆ ಇನ, “ಅನ ಮ್ಹೇಲೊ! ಮನ ಮಖ್ಹಾಣ್ಯನ ದನ್ನುಕಾಮ್ ಹಮ್ಕೇಸ್ ಕರಿಲಿದಿ. ");
INSERT INTO vaa_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","ಗರೀಬ್ ಖ್ಹಾರು ಹಮೇಶ ತುಮಾರ ಜೋ಼ಡೆ ರ‍್ಹಿಶೆ, ಕತೋಬಿ ಮೇ ಹಮೇಶ ತುಮಾರ ಜೋ಼ಡೆ ಕೋ ರ‍್ಹೀಶ್‌ನಿ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","ಯೆಹೂದ್ಯರ್ ಅದ್ಮಿನಿ ಮೋಟಿ ಭೀಡ್, ಯೇಸು ಬೆಥಾನ್ಯಾಮ ಛಾ಼ ಕರಿ ಮಾಲುಮ್‌ ಕರಿಲೀನ್, ಖಲಿ ಇನ ದೇಖಾನಖ್ಹಾಜೆ ಕಾಹೆತೆ, ಇನೆ ಮರ‍್ಯಾಹುಯಮಾಥು ಜಿವ್ತು ಉಠಾಡ್ಯೋತೆ ಲಾಜ಼ರ್‌ನಾಬಿ ದೇಕ್ಣು ಕರಿ ಹಿಜ್ಜಾ಼ ಗಯು. ");
INSERT INTO vaa_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","ಕತೋಬಿ ಮಹಾಯಾಜಕರ್‌ ಲಾಜ಼ರ್‌ನಾಬಿ ಮರೈನಾಕ್ಣು ಕರಿ ಸೋಚ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","ಶನಕತೊ ಲಾಜ಼ರ್‌ನಟೇಕೆ ಘಣು ಅದ್ಮಿ ಯೆಹೂದ್ಯರ್ ಖ್ಹಾರು ಇವ್ಣುನ ಮ್ಹೆಂದಿನ್, ಯೇಸುನ ವಿಶ್ವಾಸ್‌ ಕರ‍್ಯು. ");
INSERT INTO vaa_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","ತಿನವ್ಹಾಣೆ, ಪಸ್ಕ ಪೂಜಾ಼ನ ಆಯುಥೂತೆ ಅದ್ಮಿನಿ ಭೀಡ್‌ನೆ, ಯೇಸು ಯೆರೂಸಲೇಮ್ಮ ವಳ್ಯಾವಸ್ ಕರಿ ಖ್ಹಮ್‌ಜ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","ತದೆ ಇವ್ಣೆ ಖಜೂ಼ರ‍್ನಿಡಾಳಿಯೇನ ಪಳ್ಳಿನ್‌, ಯೇಸುನ ಮಳಾನ ಗಯು, ಅಜು಼ ಚಿಕ್ರಿನ್ ಬೋಲ್ಯುಕಿ, “ಹೊಸನ್ನ! ಪ್ರಭುನ ನಾಮ್‌ಪರ್‌ ಆವಾಳ ರಾಜಾ಼ನ ದೇವ್ ಆಶೀರ್ವಾದ್‌ ಕರಾದೆ! ಇಸ್ರಾಯೇಲ್‌ನ ರಾಜಾ಼ನ ದೇವ್ ಆಶೀರ್ವಾದ್‌ ಕರಾದೆ!” ");
INSERT INTO vaa_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","ಯೇಸುನೆ ಏಕ್‌ ಗಧೇಡಾನ ದೇಖಿನ್‌, ಇನಾಪರ್‌ ಬೇಶಿಗಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“ಚೀಯೋನ್ ನಂಗ್ರಿ ಡರ್‌ನಕೊ! ಹಂದೇಕ್, ತಾರೊ ರಾಜ಼, ಗಧೇಡಾನ ಚೆಲ್ಕಪರ್‌ ಬೇಶಿನ್ ವಳ್ಯಾವಸ್ತೆ” ಕರಿ ಧರ್ಮಶಾಸ್ತ್ರಮ ಛಾ಼ತೆ ವಾತೆ ಅಮ್ ಚಾ಼ಲಿಗಿ. ");
INSERT INTO vaa_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","ಯೇಸುನ ಶಿಷ್ಯರ್‌ನ ಯೋ ವಖ್ಹತ್‌ಮ ಆ ಮಾಲುಮ್‌ ಕೋ ಪಡ್ಯುನಿ; ಕತೋಬಿ ಯೇಸು ಮಹಿಮೆನು ಪದವಿಮ ಆವಾನ ಬಾದ್‌ಮ, ಆ ಇನಿ ಬಾರೇಮಸ್ ಲೀಖೈರ‍್ಹೂಸ್ತೆ ಕರಿ, ಅಜು಼ ಅಪ್ಣೆ ಆ ಖ್ಹಾರಾನ ಯೇಸುನಖ್ಹಾಜೆ ಕರ‍್ಯಾ ಕರಿ ಇವ್ಣ ಯಾದ್ಮ ಆಯು. ");
INSERT INTO vaa_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","ಅತ್ರೇಸ್ ಕಾಹೆತೆ ಲಾಜ಼ರ್‌ನ ಘವಿನ ಮಹಿಥು ಚಿಕ್ರಿನ್‌, ಜಿವ್ತು ಉಠಾಡ್ಯೋತೆ ವಖ್ಹತ್‌ಮ, ಇನಜೋ಼ಡೆ ಥೂತೆ ಇವ್ಣೆ ದೇಖ್ಯುತೆ ಅದ್ಮಿಖ್ಹಾರು ಅನಿ ಬಾರೇಮ ಸಾಕ್ಷಿ ಬೋಲುಕರ್ತೂಥು. ");
INSERT INTO vaa_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","ಯೇಸುನೆ ಆ ಅದ್ಭುತ್ ಕಾಮ್ ಕರ‍್ಯೊ ಕರಿ ಖ್ಹಮ್‌ಜ್ಯೂತೆ ಇನಖ್ಹಾಜೆ ಅದ್ಮಿನು ಝೂ಼ಂಡ್‌ ಇನ ಮಳಾನ ಜೈ಼ರ‍್ಹೂಥು. ");
INSERT INTO vaa_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","ತದೆ ಫರಿಸಾಯರ್‌ವಾಳು ಏಕ್‌ಥಿ-ಏಕ್‌, “ಹಂದೇಖೊ, ಅಪ್ಣೊ ಹಾತ್‌ ಶಾತ್ಬಿ ಕರಾನ ಕೋ ಹೂಕರಾನಿ! ಆ ಜಗತ್‌ನು ಖ್ಹಾರು ಅದ್ಮಿ ಇನ ಪೀಠೆ ಒಳ್ಯುಜಾ಼ಸ್!” ಕರಿ ಬೋಲಿಲಿದು. ");
INSERT INTO vaa_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","ಪಸ್ಕಪೂಜಾ಼ನ ಆರಾದನೆ ಕರ್ನುಕರಿ ಯೆರೂಸಲೇಮ್‍ಥು ಆಯುಥೂತೆ ಇಸ್ರಾಯೇಲ್‍ವಾಳಮ ಥೋಡು ಜ಼ಣು ಗ್ರೀಕ್‌ವಾಳುಬಿ ಥೂ. ");
INSERT INTO vaa_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","ಇವ್ಣಾಮ ಯೊ ಗ್ರೀಕ್‍ವಾಳು ಗಲಿಲಾಯಮ ಛಾ಼ತೆ ಬೆತ್ಸಾಯಿದ ಗಾಮ್‌ನೊ ಫಿಲಿಪ್ಪಕನ ಜೈ಼ನ್‌, “ಮಾಲಿಕ್, ಹಮೆ ಯೇಸುನ ದೇಕ್ಣು” ಕರಿ ಇನ ಗಿಂಗಾಯು. ");
INSERT INTO vaa_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","ಫಿಲಿಪ್ಪನೆ ಜೈ಼ನ್‌, ಅಂದ್ರೆಯನ ಆ ಬಾರೇಮ ಬೋಲ್ಯೊ, ತದೆ ಫಿಲಿಪ್ಪ ಅಜು಼ ಅಂದ್ರೆಯ ಭೇಜ಼ಣನೆ ಯೇಸುನ ಬೋಲ್ಯ. ");
INSERT INTO vaa_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","ಯೇಸುನೆ ಇವ್ಣುನ ಜ಼ವಾಬ್ ದಿದೊ, “ಅದ್ಮಿನ ಛಿಯ್ಯಾನಿ ಮಹಿಮೆ ಮಳಾನಿ ವಖ್ಹತ್ ಐಗೈ. ");
INSERT INTO vaa_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","ಮೇ ತುಮೂನ ಖ್ಹಾಚ ಬೋಲು ಕರುಸ್; ಕಬ್ಲಗು ಘವ್‌ನೊ ದಾಣೊ ಜ಼ಮೀನ್‌ಮ ಪಡೀನ್, ಮರ‍ಕೊಯ್ನಿಕಿ, ತಬ್‍ಲಗು ಎಕ್ಕಸ್ ರ‍್ಹಿಶೆ; ಕದೆ ಮರ‍ಸ್ಕಿ ತದೆ, ಘಣು ದಾಣಾನ ದಿಶೆ. ");
INSERT INTO vaa_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","ಇನೊ ಶೊಂತ್‌ ಜಾನ್ನ ಪ್ಯಾರ್ ಕರಾವಾಳು ಇನ ಗುಮೈಲಿಶೆ, ಆ ಜಗತ್‌ಮ ಕೋಣ್ ಇನ ಶೊಂತ್ ಜಾನ್ನ ಕಾಡಿಲ್ಯವಾನಬಿ ಪೀಠೆ ಕೋ ಹಟಾನಿಕಿ, ಯೊ ಹರ್‌ಹಮೇಶಾನ ಖ್ಹಾಜೆ ಇನ ಬಚಾ಼ಡಿಲಿಶೆ. ");
INSERT INTO vaa_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","ಕೋಣ್ ಮಾರಿ ಸೇವೆ ಕರ್ನುಕರಿ ಛಾ಼ಕಿ ಮಾರ ಪೀಠೆ ಆವ್ಣುಸ್ ಆವ್ಣು, ತದೆ ಮೇ ಕಿಜ್ಜಾ಼ ರ‍್ಹೀಶ್‌ಕಿ ಹಿಜ್ಜಾ಼ಸ್ ಮಾರೊ ಸೇವಕ್‌ಬಿ ರ‍್ಹಿಶೆ. ಕೋಣ್ ಮಾರಿ ಸೇವೆ ಕರಾಸ್ಕಿ, ಇವ್ಣುನ ಮಾರೊ ಬಾ ಸನ್ಮಾನ್‌ ಕರ್ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“ಹಮ್ಕೆ ಮಾರೊ ಜಾನ್‌ ಘಬ್ರಾವ್‍ ಕರಾಸ್ ಅಜು಼ ಮೇ ಶಾತ್‌ ಬೋಲು? ಅಮ್‍ ಬೋಲುಕಿಶು ‘ಬಾ, ಆ ಖ್ಹತಾಪ್ಣಿನಿ ವಖ್ಹತ್‌ಮಾಥು ಮನ ಬಚಾ಼ವ್‍ಕರಿ? ಕತೋಬಿ ಅನಖ್ಹಾಜೆಸ್ ಮೇ ಆಯೋತೆ. ");
INSERT INTO vaa_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","ಬಾ, ತಾರು ನಾಮ್ ಮಹಿಮ ಕರಿಲೆ!” ಕರಿ ಬೋಲ್ಯೊ. ತದೆ ಸೊರ್ಗಮಾಥು ಆವಾಜ಼್ಆಯು, “ಮಾರು ನಾಮ್ನ ಮಹಿಮೆ ಕರಿಲಿದೊ, ಮೇ ಅಜು಼ ಪಾಛೊ಼ ಅನಿ ಮಹಿಮೆ ಕರೀಶ್” ಕರಿ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","ಹಿಜ್ಜಾ಼ ಭೀಯುಥೂತೆ ಝೂಂಡ್‍ಖ್ಹಾರು ಆ ಅವಾಜ಼್‌ನ ಖ್ಹಮ್‌ಜಿನ್‌, “ಗಲ್ಹಾರ‍್ಯು” ಕರಿ ಬೋಲ್ಯು. ಅಜು಼ ಥೋಡಾನೆ, “ದೇವ್‌ನೊ ದೂತಾನೆ ಯೇಸುನ ಜೋ಼ಡೆ ವಾತೆ ಬೋಲ್ಯೊ” ಕರಿ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","ಕತೋಬಿ ಯೇಸುನೆ ಇವ್ಣುನ, “ಆ ಅವಾಜ಼್ ಹುಯೂತೆ ಮಾರ ಅಛ್ಛಾ಼ನಖ್ಹಾಜೆ ಕಾಹೆ, ಪಣ್ಕಿ ತುಮಾರ ಅಛ್ಛಾ಼ನ ಖ್ಹಾಜೆಸ್. ");
INSERT INTO vaa_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","ಆ ಜಗತ್ನ ತೀರ್ಪ್ ಹುವಾನಿ ಘಡಿ ಆಸ್; ಯೊ ಆ ಜಗತ್ನ ರಾಜ಼್‌ಭಾರ್‌ ಚ಼ಲಾಯೊತೆ ಆ ಅದಿಪತಿನ ಭಾರ್‌ ಧಕೇಲ್‌ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","ಮೇ ಜ಼ಮೀನ್‍ಪರ್ಥೊ ಉಪ್ಪರ್ ಪಡೈಜೈ಼ಶ್‌ತೆ ತದೆ ಹರೇಕ್ನ ಮಾರಕನ ಖೇಚಿಲೀಶ್‌” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","ಯೋ ಮರಾನಿ ತರೀಖಾನ ಯೇಸುನೆ ಆ ವಾತೇಥಿ ವತಾಳಿಲಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","ತದೆ ಅದ್ಮಿನಿ ಭೀಡ್‌ನೆ, “ಕ್ರಿಸ್ತ ಹರ್‌ಹಮೇಶ ಜಿವ್ತೊ ರ‍್ಹಿಶೆ’ ಕರಿ ಧರ್ಮಶಾಸ್ತ್ರಮ ಬೋಲಾಸ್ನಿ? ಇಮ್‍ಕತೊ, ‘ಅದ್ಮಿನೊ ಛಿಯ್ಯೊ ಉಪ್ಪರ್ ಪಡೈಜಾ಼ಶೆ’ ಕರಿ ತೂ ಬೋಲಾಸ್ತೆ ಕಿಮ್? ಯೋ ಅದ್ಮಿನೊ ಛಿಯ್ಯೊ ಕೋಣ್?” ಕರಿ ಪುಛಾ಼ಯು. ");
INSERT INTO vaa_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","ತದೆ ಯೇಸುನೆ ಇವ್ಣುನ ಬೋಲ್ಯೊ, “ಬಿಜು಼ ಥೋಡ ದನ್ನಸ್‌ ಉಜಾ಼ಳು ತುಮಾರಾಮ ರ‍್ಹಿಶೆ, ಅಂಧಾರು ತುಮಾರಪರ್ ಢಪಾವನ ಅಗಾಡಿಸ್ ಉಜಾ಼ಳು ರ‍್ಹವಾನಿವಖ್ಹ್‌ತೆಸ್ ಚಾ಼ಲೊ. ಅಂಧಾರಾಮ ಚಾ಼ಲವಾಳಾನ ಯೋ ಕಿಜ಼್ಜಾ ವಳ್ಯೊಜಾ಼ಸ್ ಕರಿ ಮಾಲುಮ್‌ ಕೋಪಡಾನಿ. ");
INSERT INTO vaa_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","ತುಮಾರಕನ ಉಜಾ಼ಳು ರ‍್ಹವಾನಿ ವಖ್ಹತ್‌ಮಾಸ್‌ ಉಜಾ಼ಳಾನ ನಂಬೊ, ನಂಬ್ಯಾತೊ, ತದೆ ತುಮೆ ಉಜಾ಼ಳವಾಳ ಹುಯಿರ‍್ಹೀಶು” ಕರಿ ಬೋಲ್ಯೊ. ಆ ಬೋಲಾನ ಬಾದ್‌ಮ, ಯೇಸುನೆ ಇವ್ಣ ಖ್ಹಾಮೇಥೊ ಓಠೆಚ಼ಲೆಗಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","ಯೇಸುನೆ ಇವ್ಣ ಖ್ಹಾಮ್ಣೆಸ್ ಆ ಖ್ಹಾರು ಅದ್ಭುತ್‌ಕಾಮ್ ಕರ‍್ಯೊತೋಬಿ, ಇವ್ಣೆ ಇನಾಪರ್‌ ವಿಶ್ವಾಸ್ ಕೋ ಕರ‍್ಯುನಿ ");
INSERT INTO vaa_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","ಅನೇಥಿ ಪ್ರವಾದಿ ಯೆಶಾಯನೆ ಬೋಲ್ಯೋತೆ ವಾತೆ ಖ್ಹಾಚಿ ಹುಯಿಗು: ಯೋ ಶಾತ್‌ಕತೊ, “ಪ್ರಭು, ಹಮೆ ಬೋಲ್ಯಾತೆ ಖಬರ್‌ನ ಕೋಣ್ ವಿಶ್ವಾಸ್ ಕರ‍್ಯು? ಪ್ರಭುನಿ ಭುಜ಼್‌ನಿ ತಾಖತ್ ಕಿನ ದೆಖಾಯು?” ಕರಿ ಬೋಲಾನುಸ್. ");
INSERT INTO vaa_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","ಇವ್ಣೆ ನಂಬ್ಯುಕೊಂತೆ ಇನಖ್ಹಾಜೆ ಯೆಶಾಯನೆ ಬಿಜೇಕ್‌ ವಾತೆ ಬೋಲಿರಾಖ್ಯೊಸ್, ಯೋ ಶಾತ್‌ಕತೊ, ");
INSERT INTO vaa_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","‘ದೇವ್ನೆ ಇವ್ಣ ಡೋಳಾನ ಕಾಣು ಕರಿರಾಖ್ಯೋಸ್, ಅಜು಼ ಇವ್ಣ ದಿಲ್ನ ಕಠಣ್ ಕರಿರಾಖ್ಯೋಸ್, ಶನಕತೊ, ಇವ್ಣೊ ಡೋಳೊ ದೇಕ್ಣು ನಾ ಅಜು಼ ಇವ್ಣೊ ದಿಲ್‌ ಪರಖ್‌ಣು ನಾ’ ಕರಿ ಅಜು಼ ಇವ್ಣೆ ಇನಾಭಣಿ ಫರೀನ್, ಇನಖ್ಹಾಜೆ ಅಛ್ಛು಼ ನಾ ಹೋಣು ಕರಿ” ಬೋಲೈರ‍್ಹುಸ್ತೆ. ");
INSERT INTO vaa_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","ಯೆಶಾಯನೆ ಯೇಸುನಿ ಮಹಿಮೆನ ದೇಖ್ಯೋತೆ ಇನಖ್ಹಾಜೇಸ್ ಇನಿ ಬಾರೇಮ ಆ ವಾತೇನ ಬೋಲ್ಯೋತೆ. ");
INSERT INTO vaa_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","ತದೇಬಿ ಘಣು ಯೆಹೂದ್ಯರ್‌ನು ಅದಿಕಾರಿನೆ ಯೇಸುಪರ್‌ ವಿಶ್ವಾಸ್‌ ಕರ‍್ಯು, ಕತೋಬಿ ಸಭೆ ಭರಾವನು ಮಂದಿರ್‌ಮಾಥು ಭಾರ್ ನಾಖಿದಿಶೆ ಕರಿ ಫರಿಸಾಯರ್‌ನ ಡರ್‌ಥಿ, ಅದ್ಮಿನ ಖ್ಹಾಮೆ ಬೋಲಿಲಿದುಕೊಯ್ನಿ. ");
INSERT INTO vaa_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","ಶನಕತೊ ಇವ್ಣೆ ದೇವ್‍ಥಿ ಆವಸ್ತೆ ಖ್ಹರಾವ್ಣಿಥೀಬಿ, ಅದ್ಮಿಥಿ ಆವಸ್ತೆ ಮರ್ಯಾದಿಪರಸ್‌ ಇವ್ಣುನ ಘಣು ಪ್ಯಾರ್ ಥೂ. ");
INSERT INTO vaa_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","ಯೇಸುನೆ ಜೋ಼ರೇಖ್ಹು ಚಿಕ್ರಿನ್, “ಮಾರಪರ್ ವಿಶ್ವಾಸ್‌ ಕರಾವಾಳೊ ಖಲಿ ಮಾರಪರಾಸ್‌ ಕಾಹೆ, ಕತೋಬಿ ಮನ ಮೋಕ್‌ಲ್ಯೊತೆ ಇನಾಪರ್‌ಬಿ ವಿಶ್ವಾಸ್‌ ಕರಾವಾಳೊ ಹುಯಿರ‍್ಹೋಸ್. ");
INSERT INTO vaa_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","ಕೋಣ್‍ ಮನ ದೇಖವಾಳೊಕಿ, ಮನ ಮೋಕ್‌ಲ್ಯೊತೆ ಇನಾಬಿ ದೇಖವಾಳೊ ಹುಯಿರ‍್ಹೋಸ್. ");
INSERT INTO vaa_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","ಮೇ ಉಜಾ಼ಳು ಹುಯಿನ್ ಆ ಜಗತ್‌ಮ ಐರ‍್ಹೋಸ್ತೆ, ಮನ ನಂಬವಾಳು ಏಕ್‌ಬಿ ಅಂಧಾರಾಮ ನಾ ರ‍್ಹೇವ್ಣುಕರಿಸ್. ");
INSERT INTO vaa_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","ಕೋಣ್‌ತೋಬಿ ಮಾರಿ ವಾತೆಅಖ್ಖಾನ ಖ್ಹಮ್‌ಜಿನ್‌ಬಿ, ಇನಲೀನ್ ಚಾ಼ಲ್ಯನಾತೊ, ಇನ ಮೇ ತೀರ್ಪ್‌ ಕರುಕೊಯ್ನಿ. ಜಗತ್ನ ತೀರ್ಪ್ ಕರಾನಖ್ಹಾಜೆ ಮೇ ಆಯೊ ಕೊಯ್ನಿ, ಪಣ್ಕಿ ಆ ಜಗತ್ನ ಬಚಾ಼ಡಾನಖ್ಹಾಜೆ ಆಯೊತೆ. ");
INSERT INTO vaa_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","ಕೋಣ್ ಮನ ಝಿಟ್ಕಾರಿನ್, ಮಾರಿ ವಾತೇನ ಮಾನಕೊಂತೆ ಇವ್ಣುನ ತೀರ್ಪ್‌ ಕರಾವಾಳು ಏಕ್‌ ಛಾ಼. ಯೋ ಕೆಹುಕತೊ ಮೇ ಬೋಲ್ಯೋತೆ ಯೋ ವಾತೇಸ್‌, ಖ್ಹರ್ತಿನ ದನ್ಮ ಇವ್ಣುನ ತೀರ್ಪ್ ಕರ್ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","ಆ ಖ್ಹಾಚು಼, ಶನಕತೊ ಮಾರಿ ಅದಿಕಾರ್‌ಥಿ ಮೇಸ್ ವಾತೆ ಕೋ ಬೋಲ್ಯೋನಿ ಮನ ಮೋಕ್‌ಲ್ಯೊತೆ ಬಾನೇಸ್, ಮೇ ಶಾತ್‌ ಬೋಲ್‌ನು ಅಜು಼ ಖಿವಿವಾತೆ ಬೋಲಿ ವತಾಳ್ಣು ಕರಿ ಮನ ಹುಕುಮ್ ದೀರಾಖ್ಯೊಸ್. ");
INSERT INTO vaa_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","ಬಾನಿ ಹುಕುಮ್‌ ಹರ್‌ಹಮೇಶಾನಿ ಜಿ಼ಂದ್‌ಗಿ ದೇಸ್ ಕರಿ ಮನ ಮಾಲುಮ್‌. ಇನಖ್ಹಾಜೆ ಬಾನೆ ಮನ ಬೋಲಿದಿದೋತೆ ಇನಾಸ್ ಮೇ ಬೋಲುಸ್” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","ಪಸ್ಕ ಪುಜಾ಼ನ ಅಗಾಡಿ ಯೇಸು ಆ ಜಗತ್ನ ಮ್ಹೇಲಿನ್, ಬಾಕನ ಜಾ಼ವಾನಿ ವಖ್ಹತ್ ಐಗೈ ಕರಿ ಮಾಲುಮ್ ಕರೀನ್, ಆ ಜಗತ್‌ಮ ಛಾ಼ತೆ ಇನು ಕರಿ ಥೂತೆ ಯೋ ಖ್ಹರಾನ ಹಮೇಶ ಪ್ಯಾರ್ ಕರ‍್ಯೊ ಅಜು಼ ಖರ್ತಿಲಗೂಬಿ ಪ್ಯಾರ್ ಕರ್ತೊಸ್ ಆಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","ಯೇಸು ಅಜು಼ ಇನ ಶಿಷ್ಯರ್‌ ಖಾಣನ ಬೆಠಾಥ. ಯೇಸುನ ದೋಕೇಥಿ ಧರಿದೇಣು ಕರಿ ಬೋಲಾನಿ ಸೋಚ್ನ, ಸೀಮೋನನೊ ಛಿಯ್ಯೊ ಇಸ್ಕರಿಯೋತ ಯೂದಾನ ಮನ್‌ಮ ಶೈತಾನ್ನೆ ಅಗಾಡಿಸ್ ಘಾಲಿದಿದೋಥೊ. ");
INSERT INTO vaa_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","ಬಾನೆ ಖ್ಹಾರಿಸ್ ಅದಿಕಾರ್‌ನ ಇನ ಹಾತ್‌ಮ ದೀರಾಖ್ಯೊಸ್ ಕರಿ ಯೇಸುನ ಮಾಲುಮ್‌ ಥೂ; ಅತ್ರೇಸ್ ಕಾಹೆತೆ ಯೇಸುನ ದೇವ್‌ಕಂಥೊ ಐರ‍್ಹೋಸ್ ಅಜು಼ ಪಾಛೊ಼ ದೇವ್‌ಕನ ವಳ್ಯೊಜ಼ವುಸ್‌ ಕರೀಬಿ ಮಾಲುಮ್‌ ಥೂ. ");
INSERT INTO vaa_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","ತದೆ ಯೇಸುನೆ ಖಾಣನ ಮ್ಹೆಂದಿನ್, ಉಪ್ಪರ್ ಉಠೀನ್, ಇನು ಉಪ್ಪರ್‌ಲ್ಯು ಝ಼ಗ್ಗಾನ ಕಾಡಿನಾಖಿನ್, ಪಿಛೋ಼ಡಿನ ಪಾಡೀನ್, ಕಂಬರ್‌ನ ಭಾಂದಿಲಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","ಅಜು಼ ಏಕ್‌ ಕಟೋರಾಮ ಪಾಣಿ ಭರಿನ್, ಶಿಷ್ಯರ್‌ನ ಗೋಡ ಧೊವಾಲಗ್ಯೊ ಅಜು಼ ಇನೆ ಕಂಬರ್‌ನ ಭಾಂದಿರಾಖ್ಯೊಥೋತೆ ಪಿಛೋ಼ಡಿಥಿ ನುಛ್ಛಾ಼ಲಗ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","ಯೊ ಸೀಮೋನ್‌ ಪೇತ್ರಕನ ಆವಾದಿನ್, ಇನೆ, “ಪ್ರಭು, ತೂ ಮಾರ ಗೋಡ ಧೊವಾಸ್ಕಿಶು?” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","ಯೇಸುನೆ ಇನ, “ಮೇ ಶಾತ್‌ ಕರುಕರುಸ್ತೆ ಕರಿ ಹಮ್ಕೆ ತುನ ಮಾಲುಮ್‌ ಕೋ ಪಡ್‌ಶೇನಿ, ಕತೋಬಿ ಬಾದ್‌ಮ ತುನ ಮಾಲುಮ್‌ ಪಡ್‌ಶೆ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","ತದೆ ಪೇತ್ರನೆ, “ತೂ ಮಾರ ಗೋಡಾನ ಕದೇಸ್‌ ನಾ ಧೋವ್‌ಣು!” ಕರಿ ಬೋಲ್ಯೊ. ಯೇಸುನೆ ಇನ, “ಮೇ ತಾರ ಗೋಡ ನಾ ಧೋಯೋತೊ, ತೂ ಮಾರೊ ಶಿಷ್ಯ ಹುಯಿರ‍್ಹವಾನ ಕೋ ಹುವಾನಿ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","ತದೆ ಸೀಮೋನ್ ಪೇತ್ರನೆ, “ಪ್ರಭು, ಖಲಿ ಮಾರ ಗೋಡಾಸ್‌ ಕಾಹೆತೆ, ಮಾರ ಹಾತ್‌ನಾಬಿ, ಮುಡ್‌ಕ್ಯನಾಬಿ ಧೊವ್‌!” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","ಯೇಸುನೆ ಇನ, “ಪಾಣಿ ನ್ಹೊಯಿರಾಖವಾಳನು‌ ಆಂಗ್‌ತನ್‌ ಅಖ್ಖುಸ್ ಪಾಕ್‌ ರ‍್ಹೇಸ್, ಖಲಿ ಗೋಡ ಧೋಯೂತೊ ಬಶ್‌. ತುಮೆ ಖ್ಹಾರು ಪಾಕ್‌ ಹುಯಿರ‍್ಹಾಸ್‌, ಕತೋಬಿ ತುಮಾರಾಮ ಹರೇಕ್ ಜ಼ಣೊ ಪಾಕ್‌ ಕಾಹೆ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","ಯೇಸುನ ಇನ ಧೋಕೇಥಿ ಧರಿ ದಿಶೇತೆ ಕೋಣ್ ಕರಿ ಮಾಲುಮ್‌ ಥೂತೆ ಇನಖ್ಹಾಜೆ, ಇನೆ, “ತುಮಾರಾಮ ಹರೇಕ್ ಜ಼ಣು ಪಾಕ್‌ ಕಾಹೆ” ಕರಿ ಬೋಲ್ಯೋತೆ. ");
INSERT INTO vaa_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","ಯೇಸುನೆ ಇವ್ಣ ಗೋಡ ಧೊವಾನ ಬಾದ್‌ಮ, ಇನು ಉಪ್ಪರ್‌ಲ್ಯು ಝ಼ಗ್ಗಾನ ಪೇರ‍್ಹಿಲೀನ್‌, ಪಾಛು಼ ಹಿಜ಼್ಜಾ ಬೇಶಿನ್ ಇನೆ ಬೋಲ್ಯೊಕಿ, “ಮೇ ತುಮೂನ ಕರ‍್ಯೊತೆ ಶಾತ್‌ ಕರಿ ತುಮೂನ ಮಾಲುಮ್‌ ಪಡ್ಯುಕಿಶು?” ಕರಿ ಪುಛಾ಼ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","“ತುಮೆ ಮನ ಗುರು, ಪ್ರಭು ಕರಿ ಬುಲಾವಸ್‌, ತುಮೆ ಇಮ್‌ ಬುಲಾವಸ್ತೆ ಬರಾಬರಸ್‌, ಶನಕತೊ ಮೇ ಇಮ್‌ನೋಸ್‌. ");
INSERT INTO vaa_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","ತುಮಾರೊ ಪ್ರಭು ಅಜು಼ ಗುರು ಹುಯಿರ‍್ಹೋತೆ ಮೇ, ತುಮಾರ ಗೋಡಾನ ಧೋಯೋತೆ ಇಮ್ಮಸ್, ತುಮೇಬಿ ಬಿಜೇಕ್‍ನ ಗೋಡ ಧೋವ್‌ಣು. ");
INSERT INTO vaa_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","ಮೇ ತುಮೂನ ಕರ‍್ಯೊತೆ ಇಮ್ಮಸ್ ತುಮೇಬಿ ಕರ‍್ನು, ಕರಿ ಮೇ ತುಮೂನ ಖ್ಹಂಜ಼್‌ಕಾರ್ ವತಾಳಿರಾಖ್ಯೋಸ್‌. ");
INSERT INTO vaa_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","ಮೇ ತುಮೂನ ಖ್ಹಾಚ ಬೋಲುಕರುಸ್, ಆಳ್‌ ಯಜಮಾನ್‍ಥಿ ಮೋಟೊ ಕಾಹೆ, ಅಜು಼ ಖಬರ್‌ದ್ಯವಾಳೊ ಇನ ಮೋಕ್‌ಲ್ಯೊತೆ ಇನೇಥಿ ಮೋಟೊ ಕಾಹೆ. ");
INSERT INTO vaa_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","ತುಮೆ ಅನ ಮಾಲುಮ್‌ ಕರಿಲೀನ್, ಅನೀನಿಘೋಣಿ ಚಾ಼ಲಿಲಿದಾತೊ ತುಮೆ ಧನ್ಯರ್ ಹುಯಿರ‍್ಹಾಸ್‌! ");
INSERT INTO vaa_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“ಮೇ ತುಮಾರ ಖ್ಹಾರಾನಿ ಬಾರೇಮ ಕೋ ಬೋಲುಕರುನಿ: ಮೇ ಚೂ಼ಣಿರಾಖ್ಯೋಸ್ತೆ ಇವ್ಣಿ ಬಾರೇಮ ಮನ ಮಾಲುಮ್‌, ಕತೋಬಿ ‘ಮಾರ ಜೋ಼ಡೆ ಖಾಣು ಖಾವಳೋಸ್‌ ಮನ ಧೋಕ ದಿದೊ’ ಕರಿ ಧರ್ಮಶಾಸ್ತ್ರಮ ಛಾ಼ತೆ ವಾತೆ ಚಾ಼ಲ್ನು. ");
INSERT INTO vaa_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","ಯೋ ಚಾ಼ಲಾನಿ ವಖ್ಹತ್‌ಮ, ಮೇಸ್ ಕ್ರಿಸ್ತ ಕರಿ ತುಮೆ ನಂಬಾನಖ್ಹಾಜೆ, ಯೋ ಚಾ಼ಲಾನ ಬೋಲುಕರುಸ್. ");
INSERT INTO vaa_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","ತುಮೂನ ಖ್ಹಾಚ ಬೋಲುಸ್, ಮೇ ಮೋಕ್ಲುಸ್ತೆ ಇವ್ಣುನ ಬುಲೈಲ್ಯವಾಳು, ಮನಾಬಿ ಬುಲೈಲ್ಯವಾಳು ಹುಯಿರ‍್ಹುಸ್‍. ಅಜು಼ ಮನ ಬುಲೈಲ್ಯವಾಳು ಮನ ಮೋಕ್‌ಲ್ಯೊತೆ ಇನಾಸ್ ಬುಲೈಲ್ಯವಾಳು” ಹುಯಿರ‍್ಹುಸ್‍. ");
INSERT INTO vaa_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","ಯೇಸು ಆ ಬೋಲಾನ ಬಾದ್‌ಮ, ಯೇಸುನ ಆತ್ಮಮ ಘಣು ದುಖ್ ಹುಯು, ಅಜು಼ ಇನೆ, “ಮೇ ತುಮೂನ ಖ್ಹಾಚ ಬೋಲುಸ್, ತುಮಾರಾಮ ಏಕ್‌ ಜ಼ಣೊ ಮನ ಧೋಕೇಥಿ ಧರಿದಿಶೆ” ಕರಿ ಸಾಕ್ಷಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","ತದೆ ಇನ ಶಿಷ್ಯರ್‌ನೆ ಏಕ್‌ನ ಭಣಿ ಏಕ್‌ ದೇಖಿನ್, ಆ ಕಿನಿ ಬಾರೇಮ ಬೋಲುಕರಾಸ್ತೆ ಕರಿ ಗುಮಾನಿಕರ‍್ಯು. ");
INSERT INTO vaa_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","ಶಿಷ್ಯರ್‌ಮ ಯೇಸುನೊ ಪ್ಯಾರ್‌ನೊ ಶಿಷ್ಯ ಏಕ್‌ ಥೊ, ಯೊ ಇನ ಚಿಕೈನ್‌ ಬೆಠೋಥೊ. ");
INSERT INTO vaa_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","ತದೆ ಸೀಮೋನ್‌ ಪೇತ್ರನೆ ಯೋ ಶಿಷ್ಯನ, “ಯೋ ಕಿನಿ ಬಾರೇಮ ಬೋಲುಕರಾಸ್ತೆ ಕರಿ ಇನ ಪುಛಾ಼ವ್‌” ಕರಿ ಇಷಾರ್ಕೊ ಕರ‍್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","ಇನಖ್ಹಾಜೆ ಯೋ ಶಿಷ್ಯನೆ ಯೇಸು ಭಣಿ ಝು಼ಕಿನ್‌, “ಪ್ರಭು, ಯೋ ಕೋಣ್?” ಕರಿ ಪುಛಾ಼ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","ಯೇಸುನೆ, “ಮೇ ಆ ರೋಟಾನ ಚೋ಼ಪ್‍ಡಿನ್, ಕಿನ ದೆವ್‍ಸ್ಕಿ, ಯೋಸ್‌ ಯೋ ಅದ್ಮಿ” ಕರಿ ಬೋಲಿನ್, ರೋಟಾನ ಟುಕ್ಡಾನ ಪಾಡೀನ್, ಕಟೋರಿಮ ಚೋ಼ಪ್‍ಡಿನ್, ಸೀಮೋನ್‌ ಇಸ್ಕರಿಯೋತನೊ ಛಿಯ್ಯೊ ಯೂದಾನ ದಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","ಯೂದಾನೆ ಯೋ ರೋಟಾನ ಲೇತಾಸ್‌ನ, ಶೈತಾನ್ ಇನಾಮಹಿ ಪೇಶಿಗಯೊ. ತದೆ ಯೇಸುನೆ ಇನ, “ತೂ ಕರಾನ ವಳ್ಯೊಜಾ಼ಸ್ತೆ ಕಾಮ್ನ ಒಗ್ಗಿಸ್‌ಮ ಕರ್‌!” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","ಕತೋಬಿ ಯೇಸುನೆ ಇನ ಅಮ್ ಶನಖ್ಹಾಜೆ ಬೋಲ್ಯೊ ಕರಿ ಬೋಲಾನು ಖಾಣನ ಬೆಠುಥೂತೆ ಇವ್ಣಾಮ ಕಿನಾಬಿ ಮಾಲುಮ್‌ ಕೋ ಹುಯೂನಿ. ");
INSERT INTO vaa_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","ಇವ್ಣಾಮ ಥೋಡಾನೆ, ಯೂದಾನ ಹಾತ್‌ಮ ಪೈಶಾನಿ ಚ಼ಂಚಿಥೀತೆ ಇನಖ್ಹಾಜೆ ಯೇಸು ಇನ ಪೂಜಾ಼ನ ಅಪ್ಣುನ ಹೋಣುತೆ ಅಖ್ಖು ಲೀಲೆವೊ ಕರೀಕಿ, ನತರ್‌ಕಿ ಗರೀಬ್‌ನ ಶಾತ್‌ತೋಬಿ ದೇ ಕರಿ ಶುಕಿ, ಯೇಸುನೆ ಬೋಲ್ಯೊ ಕರಿ ಲ್ಹಾಯು. ");
INSERT INTO vaa_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","ಯೂದಾನೆ ಯೋ ರೋಟಾನ ಲೀನ್‌, ತದ್‌ನು-ತದ್ದೇಸ್ ಭಾರ್ ಚ಼ಲೆಗಯೊ. ತದೆ ರಾತ್ ಹುಯಿರ‍್ಹೀಥಿ. ");
INSERT INTO vaa_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","ಯೂದ ಜಾ಼ವಾನ ಬಾದ್‌ಮ, ಯೇಸುನೆ, “ಹಮ್ಕೆ ಅದ್ಮಿನೊ ಛಿಯ್ಯಾನ ಮಹಿಮೆ ಹುಯು; ಅಜು಼ ಇನೇಥಿ ದೇವ್ನ ಮಹಿಮೆ ಪ್ರಕಟ್ ಹುಯು. ");
INSERT INTO vaa_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","ಏಕ್‌ ವಖ್ಹತ್, ಅದ್ಮಿನೊ ಛಿಯ್ಯಾಥಿ ದೇವ್ನ ಮಹಿಮೆ ಹುಯು ಉಶೇತೊ, ಖ್ಹುದ್ ದೇವ್‌ಥೀಸ್‌ ಅದ್ಮಿನೊ ಛಿಯ್ಯಾನಾಬಿ ಮಹಿಮೆ ಉಶೆ,ಅಜು಼ ಇನ ಒಗ್ಗಿಸ್ ಮಹಿಮೆ ಕರ್ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","ಮಾರ ಲಡ್ಕಾ, ಬಿಜು಼ ಥೋಡಿ ವಖ್ಹತ್ ಮೇ ತುಮಾರ ಜೋ಼ಡೆ ರ‍್ಹೀಶ್. “ಮನ ಢೂಂಡ್‌ಶು, ಕತೋಬಿ ಯೆಹೂದ್ಯರ್‌ನ ಬೋಲ್ಯೋತೆ ಇಮ್ಮಸ್, ಮೇ ಜ಼ವುಸ್ತೆ ಹಿಜ್ಜಾ಼ ತುಮೆ ಕೋ ಆವಾನ ಉಶೇನಿ” ಕರಿ ಮೇ ಹಮ್ಕೆ ತುಮೂನಾಬಿ ಬೋಲುಸ್. ");
INSERT INTO vaa_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","ಹಮ್ಕೆ ಮೇ ತುಮೂನ ಏಕ್‌ ನವಿ ಹುಕುಮ್‌ ದೆವುಸ್ ತುಮೆ ಏಕ್‌ಥಿ-ಏಕ್‌ ಲಾಡ್‌ ಕರೊ. ಮೇ ತುಮೂನ ಲಾಡ್‌ ಕರ‍್ಯೊತೆ ತಿಮ್ಮಸ್, ತುಮೇಬಿ ಏಕ್‌ಥಿ-ಏಕ್‌ ಲಾಡ್‌ ಕರ್ನುಸ್‍ಕರ‍್ನು. ");
INSERT INTO vaa_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","ತುಮೆ ಏಕ್‌ಥಿ-ಏಕ್‌ ಪ್ಯಾರ್ ಕರ‍್ಯಾತೊ, ತದೆ ತುಮೆ ಹರೇಕ್ ಜ಼ಣು ಮಾರ ಶಿಷ್ಯರ್‌ ಕರಿ ಮಾಲುಮ್‌ ಉಷೆ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","ಸೀಮೋನ್‌ ಪೇತ್ರನೆ ಯೇಸುನ, “ಪ್ರಭು, ತೂ ಕಿಜ಼್ಜಾ ವಳ್ಯೊಜಾ಼ಸ್‌?” ಕರಿ ಪುಛಾ಼ಯೊ. ತದೆ ಯೇಸುನೆ, “ಮೇ ವಳ್ಯೊಜ಼ವುಸ್ತೆ ಹಿಜ್ಜಾ಼ ತೂ ಹಮ್ಕೆ ಆವಾನ ಕೋ ಉಶೇನಿ, ಕತೋಬಿ ಬಾದ್‌ಮ ತೂ ಮಾರ ಪೀಠೆ ಐಶ್‌” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","ಪೇತ್ರನೆ ಯೇಸುನ, “ಪ್ರಭು, ಮೇ ಶನ ಹಮ್ಕೆ ತಾರ ಪೀಠೆ ಆವಾನ ಕೋ ಉಶೇನಿ? ಮೇ ತಾರಖ್ಹಾಜೆ ಜಾನ್‌ ದೆವಾನಾಬಿ ತಯಾರ್ ಛು಼!” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","ಯೇಸುನೆ ಇನ ಪುಛಾ಼ಯೊ, “ತೂ ಖ್ಹಾಚಮಾಬಿ ಮಾರಖ್ಹಾಜೆ ಜಾನ್‌ ದ್ಯವಾನ ತಯಾರ್ ಛಾ಼ಕಿ ಶು? ಮೇ ತುನ ಖ್ಹಾಚ ಬೋಲುಸ್, ಮುರ್‌ಗೊ ಬಾಂಗ್‌ ದ್ಯವಾನ ಅಗಾಡಿ, ತೂ ಮಾರಿ ಬಾರೇಮ ‘ಯೋ ಮನ ಮಾಲುಮ್‌ ಕೊಯ್ನಿ’ ಕರಿ ತೀನ್‍ಹಲ್ಲ ಬೋಲಿಶ್” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","ಯೇಸುನೆ ಇವ್ಣುನ, “ತುಮಾರೊ ದಿಲ್‌ ಕಲಾವ್ಣಿ ನಕೊ ಹುವಾದೆ, ದೇವ್‌ಪರ್‌ ವಿಶ್ವಾಸ್‌ ಕರೊ ಅಜು಼ ಮಾರಪರ್‌ಬಿ ವಿಶ್ವಾಸ್‌ ಕರೊ. ");
INSERT INTO vaa_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","ಮಾರ ಬಾನ ಘರ್‌ಮ ಘಣ ಕೋಣ ಛಾ಼, ಇಮ್‌ ನಾ ರ‍್ಹಯುಹೋತ್ತೊ, ತುಮಾರಖ್ಹಾಜೆ ಝ಼ಗೊ ತಯಾರ್ ಕರಾನಟೇಕೆ ವಳ್ಯೊಜ಼ವುಸ್‌ನಿ. ");
INSERT INTO vaa_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","ಮೇ ಜೈ಼ನ್‌, ತುಮಾರಖ್ಹಾಜೆ ಝ಼ಗೊ ತಯಾರ್ ಕರಾನ ಬಾದ್‌ಮ, ಪಾಛೊ಼ಅಯಿನ್‌, ತುಮೂನ ಮಾರ ಜೋ಼ಡೆ ಬುಲೈಲಿ ಜೈ಼ಶ್. ಅಮ್ಮಸ್ ಮೇ ಛೂ಼ತೆ ಝ಼ಗೋಮಾಸ್‌ ತುಮೇಬಿ ರ‍್ಹಿಶು. ");
INSERT INTO vaa_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","ಮೇ ವಳ್ಯೊಜ಼ವುಸ್ತೆ ಝ಼ಗೋನು ಮಾರಗ್ ತುಮೂನ ಮಾಲುಮ್‌ ಛಾ಼” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","ತೋಮನೆ ಯೇಸುನ “ಪ್ರಭು, ತೂ ವಳ್ಯೊಜಾ಼ಸ್ತೆ ಕಿಜ್ಗಾ಼ ಕರಿ ಹಮೂನ ಮಾಲುಮ್‌ ಕೊಯ್ನಿ, ಅಮ್ ರ‍್ಹವಾಪರ್ ಯೋ ಮಾರಗ್ ಹಮೂನ ಕಿಮ್ ಮಾಲುಮ್‌ ಪಡ್‌ಶೆ?” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","ಯೇಸುನೆ ಇನ, “ಮೇಸ್ ಮಾರಗ್‌ಬಿ, ಖ್ಹಾಚಾಬಿ, ಜಾನ್‌ಬಿ ಹುಯಿರ‍್ಹೋಸ್. ಮಾರೇಥಿ ಕೊಂತೆ ಕೋಣ್‌ಬಿ ಬಾಕನ ಆವಾನ ಕೋ ಹುವಾನಿ. ");
INSERT INTO vaa_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","ತುಮೆ ಮನ ಖ್ಹಾಚಮಾಬಿ ಮಾಲುಮ್‌ ಕರಿಲಿದಾಹೋತ್ತೊ ಮಾರ ಬಾನಾಬಿ ಅಛ್ಛಿನಿತರ ಮಾಲುಮ್ ಕರಿಲಿದಾಹೋತ್‌, ಕತೋಬಿ ಹಂಕೇಥು ತುಮೆ ಬಾನ ಮಾಲುಮ್‌ ಕರಿರಾಖ್ಯಾಸ್, ಅಜು಼ ಇನ ದೇಖಿರಾಖ್ಯಾಸ್‌” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","ಫಿಲಿಪ್ಪನೆ ಯೇಸುನ, “ಪ್ರಭು, ಹಮೂನ ಬಾನ ವತಾಳ್; ಹಮೂನ ಎತ್ರೇಸ್ ಬಶ್‌” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","ಯೇಸುನೆ ಜ಼ವಾಬ್ ದೇತೊ ಹುಯಿನ್, “ಫಿಲಿಪ್ಪ, ಮೇ ಅತ್ರಾದನ್‌ ತುಮಾರ ಜೋ಼ಡೆ ರ‍್ಹಯೊತೋಬಿ, ತುನೆ ಮನ ಮಾಲುಮ್‌ ಕರಿಲಿದೊಕೊಯ್ನಿಕಿ ಶು? ಕೋಣ್ ಮನ ದೇಖ್ಯುಕಿ, ಇವ್ಣೆ ಬಾನಾಬಿ ದೇಖಿರಾಖ್ಯುಸ್‌. ಅಮ್ ರ‍್ಹವಾಪರ್, ತೂ, “ಹಮೂನ ಬಾನ ವತಾಳ್” ಕರಿ ಪುಛಾ಼ವಸ್ತೆ ಶನ? ");
INSERT INTO vaa_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","“ಮೇ ಬಾಮ ಛೂ಼, ಅಜು಼ ಬಾ ಮಾರಾಮ ಛಾ಼ ಕರಿ ತೂ ನಂಬಾಕೊಯ್ನಿಕಿ ಶು? ಮೇ ತುಮೂನ ಬೋಲುಸ್ತೆ ವಾತೆ, ಮಾರೇಥಿ ಮೇಸ್ ಬೋಲ್ಯೋತೆ ಕಾಹೆ; ಬಾ ಮಾರ ಮಹಿ ರ‍್ಹೀನ್, ಜಿವ್ಣುಕರೀನ್ ಇನು ಕಾಮ್ನ ಕರಾಸ್. ");
INSERT INTO vaa_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","ಮೇ ಬಾಮ ಛೂ಼, ಅಜು಼ ಬಾ ಮಾರಾಮ ಛಾ಼ ಕರಿ ಮೇ ಬೋಲುಸ್ತೆ ಆ ವಾತೇನ ನಂಬೊ. ನತರ್‌ಕಿ ಮೇ ಕರ‍್ಯೊತೆ ಖ್ಹಾರು ಅದ್ಭುತ್ ಕಾಮ್ನ ದೇಖಿನ್ ತೋಬಿ, ನಂಬೊ. ");
INSERT INTO vaa_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","ಮೇ ತುಮೂನ ಖ್ಹಾಚ ಬೋಲುಸ್, ಮನ ನಂಬವಾಳೊ ಮೇ ಕರ‍್ಯೊತೆ ಕಾಮ್ನಖ್ಹಾರು ಯೋಬಿ ಕರ್ಶೆ, ಎತ್ರೇಸ್ ಕಾಹೆತೆ ಇನೇಥಿ ಮಹಾನ್ ಕಾಮ್ನ ಖ್ಹಾರು ಕರ್ಶೆ, ಶನಕತೊ ಮೇ ಬಾಕನ ವಳ್ಯೊಜ಼ವುಸ್‌. ");
INSERT INTO vaa_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","ಅಜು಼ ತುಮೆ ಮಾರ ನಾಮ್‌ಪರ್‌ ಶಾತ್‌ ಮಾಂಗಿಲಿದಾತೋ, ಮೇ ತುಮಾರಖ್ಹಾಜೆ ಯೋ ಖ್ಹಾರುಸ್ ಚ಼ಲೈಶ್‌, ಅನಖ್ಹಾಜೆ ಛಿಯ್ಯಾಥಿ ಬಾನ ಮಹಿಮೆ ಉಶೆ. ");
INSERT INTO vaa_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","ತುಮೆ ಮಾರ ನಾಮ್‌ಪರ್‌ ಶಾತ್‌ ಮಾಂಗಿಲಿದತೋಬಿ, ಮೇ ಇನ ಪೂರ ಕರಿಶ್. ");
INSERT INTO vaa_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","ತುಮೆ ಮನ ಪ್ಯಾರ್‌ಕರವಾಳ ರ‍್ಹಯಾತೊ, ಮಾರಿ ಹುಕುಮ್‌ನ ಪಾಡಿ ಚಾ಼ಲ್‌ಶು. ");
INSERT INTO vaa_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","ತದೆ ಮೇ ಬಾಕನ ಬೋಲಿಲೀಶ್‌, ತದೆ ಯೋ ತುಮೂನ ಬಿಜೇಕ್‍ಜ಼ಣೊ ಮದತ್‌ ಕರವಾಳನ ತುಮಾರಿ ಜೋ಼ಡ್ಮ ರ‍್ಹವಾನ ಮೋಕಲ್‌ಶೆ. ಯೋ ಮದತ್ ಕರಾವಾಳೊ ಹರ್‌ಹಮೇಶ ತುಮಾರ ಜೋ಼ಡೆ ರ‍್ಹಿಶೆ. ");
INSERT INTO vaa_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","ಯೋ ಮದತ್ ಕರಾವಾಳೊ ಕೋಣ್‌ಕತೊ ಖ್ಹಾಚೊ಼ ಆತ್ಮಾಸ್‌. ಆ ಜಗತ್‌ ಇನ ದೇಖ್ಯುಕೊಯ್ನಿ, ಪರ್‌ಖ್ಯುಬಿ ಕೊಯ್ನಿ.ಇನಖ್ಹಾಜೆ ತುಮೆ ಇನ ಮಾಲುಮ್ ಕರಿಲಿಶು. ಕತೋಬಿ ತುಮಾರಿಜೋ಼ಡ್ಮ ಜಿವ್‌ಶೆ ಅಜು಼ ತುಮಾರ ಮಹಿರಿಶೆ. ");
INSERT INTO vaa_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","ಮೇ ತುಮೂನ ಅನಾದ್ರಿನಿತರ ಕೋ ಮ್ಹೇಲೀಶ್‌ನಿ; ಮೇ ತುಮಾರಕನ ಪಾಛೊ಼ ಐಶ್‌. ");
INSERT INTO vaa_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","ಬಿಜು಼ ಥೋಡ ದನ್ನ ಬಾದ್‌ಮ ಆ ಜಗತ್‌ ಮನ ದೇಕ್‌ಶೆ ಕೊಯ್ನಿ, ಕತೋಬಿ ತುಮೆ ಮನ ದೇಕ್‌ಶು; ಮೇ ಜಿವ್‌ಸ್ತೆ ಇನಖ್ಹಾಜೆ ತುಮೇಬಿ ಜಿವ್‌ಶು. ");
INSERT INTO vaa_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","ಯೋ ದನ್ಮ ಮೇ ಮಾರ ಬಾಮಾಬಿ, ತುಮೆ ಮಾರಮಬಿ, ಇಮ್ಮಸ್ ಮೇ ತುಮಾರಮಬಿ ಛೂ಼ತೆ ಮಾಲುಮ್‌ ಕರಿಲಿಶು. ");
INSERT INTO vaa_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","“ಮಾರಿ ಹುಕುಮ್‌ನ ಮಾನಿನ್‌, ಇನೀನಿಘೋಣಿ ಚಾ಼ಲವಾಳೋಸ್‌ ಮನ ಪ್ಯಾರ್ ಕರಾವಾಳೊ ಹುಯಿರ‍್ಹೋಸ್. ಕೋಣ್ ಮನ ಪ್ಯಾರ್ ಕರಾಸ್ಕಿ ಮಾರೊ ಬಾ ಇನ ಪ್ಯಾರ್ ಕರ್ಶೆ; ಮೇಬಿ ಇನ ಪ್ಯಾರ್ ಕರೀಶ್ ಅಜು಼ ಮೇಸ್ ಇನ ದೆಖೈಲೀಶ್‌” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","ತದೆ ಯೂದಾನೆ (ಆ ಇಸ್ಕರಿಯೋತ ಯೂದ ಕಾಹೆ) ಕತೋಬಿ “ಪ್ರಭು, ತೂ ಜಗತ್ನ ದೆಖೈಶ್‌ ಕೊಂತೆ ತೂ ಹಮೂನ ಖಲಿ ದೆಖೈಲ್ಯವಾನ ಕಿಮ್ ಉಶೆ?” ಕರಿ ಪುಛಾ಼ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","ಯೇಸುನೆ ಇನ, “ಕೋಣ್ ಮನ ಪ್ಯಾರ್ ಕರಾಸ್ಕಿ, ಇವ್ಣೆ ಮಾರಿ ವಾತೇನ ಪಾಡಿ ಚಾ಼ಲ್‌ಷೆ. ಮಾರೊ ಬಾ ಇನ ಪ್ಯಾರ್ ಕರ್ಶೆ, ಅಜು಼ ಮಾರೊ ಬಾಬಿ ಮೇ ಭೇಜ಼ಣ ಇನಾಕನ ಐನ್, ಇನಜೋ಼ಡೆ ಜಿವ್‌ಶು. ");
INSERT INTO vaa_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","ಮನ ಪ್ಯಾರ್‌ಕರಾಕೊಂತೆ ಇವ್ಣೆ ಮಾರಿ ವಾತೇನ ಪಾಡಿ ಚಾ಼ಲಾಕೊಯ್ನಿ; ತುಮೆ ಖ್ಹಮ್‌ಜು಼ಕರಾತೆ ಮಾರಿ ವಾತೆ ಕಾಹೆ, ಮನ ಮೋಕ್‌ಲ್ಯೊತೆ ಬಾನಿಸ್‌ ವಾತೆ. ");
INSERT INTO vaa_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","ಮೇ ತುಮಾರ ಜೋ಼ಡೆ ರ‍್ಹವಾನಿಸ್ ವಖ್ಹತ್‌ಮ, ಮೇ ಆ ಖ್ಹಾರು ತುಮೂನ ಬೋಲಿರಾಖ್ಯೊಸ್. ");
INSERT INTO vaa_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","ಕತೋಬಿ ಯೋ ಮದತ್‌ ಕರವಾಳೊ, ಕತೊ ಮಾರ ನಾಮ್‌ಪರ್‌ ಬಾ ಮೋಕ್‌ಲ್‌ಶೇತೆ ಪವಿತ್ರಾತ್ಮಸ್ ತುಮೂನ ಖ್ಹಾರೂಸ್ ಶಿಕಾಡ್‍ಶೆ ಅಜು಼ ಮೇ ಬೋಲ್ಯೋತೆ ಅಖ್ಖಾಸ್ನ ತುಮಾರಿ ಯಾದ್ಮ ಲ್ಯಾವ್‌ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","ಮೆ ಶಾಂತಿನ ತುಮಾರಮ ಮ್ಹೇಲಿನ್ ವಳ್ಯೊಜ಼ವುಸ್‌, ಮಾರಾಮ ಛಾ಼ತೆ ಶಾಂತಿನ ತುಮೂನ ದೆವುಸ್‌; ಆ ಜಗತ್‌ ದೇಸ್ತೆ ಇಮ್‌ ಕಾಹೆ, ಮೇ ತುಮೂನ ದೆವ್‍ಸ್ತೆ, ತುಮಾರೊ ದಿಲ್‌ ಕಲಾವಾದೆ ನಕೊ, ಅಜು಼ ತುಮೆ ಡರೊ ನಕೊ. ");
INSERT INTO vaa_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","ಮೇ ವಳ್ಯೊಜ಼ವುಸ್‌, ಕತೋಬಿ ಪಾಛೊ಼ಫರಿ ತುಮಾರಕನ ಐಶ್‌, ಕರಿ ಮೇ ಬೋಲ್ಯೋತೆ ವಾತೇನ ತುಮೆ ಖ್ಹಮ್‌ಜಿರಾಖ್ಯಾಸ್‌, ತುಮೆ ಮನ ಪ್ಯಾರ್ ಕರಾವಾಳು ಹುಯಿರ‍್ಹಾಹೊತ್ತೊ, ಮೇ ಬಾಕನ ವಳ್ಯೊಜ಼ವುಸ್ತೆ ಬಾರೇಮ ಖ್ಹುಶಿ ಕರ‍್ಯಾಹೋತ್‌; ಶನಕತೊ ಬಾ ಮಾರೇಥಿಬಿ ಮಹಾನ್ ಹುಯಿರ‍್ಹೋಸ್. ");
INSERT INTO vaa_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","ಆ ಖ್ಹಾರು ಚಾ಼ಲಾನ ಅಗಾಡಿಸ್, ಮೇ ತುಮೂನ ಹಂಕೇಸ್‌ ಆ ಖ್ಹಾರು ಬೋಲಿರಾಖ್ಯೊಸ್. ತದೆ ಯೋ ಚಾ಼ಲಾನಿ ವಖ್ಹತ್‌ಮ ತುಮೆ ನಂಬ್‌ಶು. ");
INSERT INTO vaa_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","ಬಿಜು಼ ಮೇ ತುಮಾರ ಜೋ಼ಡೆ ಜಾ಼ಖ್ಹತ್ ವಾತೆ ಕೋ ಬೋಲೂನಿ, ಶನಕತೊ ಆ ಜಗತ್ನ ಅದಿಕಾರಿ ವಳ್ಯಾವಸ್. ಇನ ಮಾರಪರ್ ಖೆವಿಸ್ ಹಕ್‌ ಕೊಯ್ನಿ. ");
INSERT INTO vaa_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","ತೋಬಿ ಮೇ ಬಾನ ಪ್ಯಾರ್ ಕರುಸ್ ಕರಿ ಅಜು಼ ಆ ಜಗತ್‌ ಶಿಕಿಲೇವ್ಣು ಕರಿ, ಬಾನೆ ಮನ ದಿದೋತೆ ಹುಕುಮ್‌ನಿತರಸ್ ಮೇ ಕರುಸ್. “ಆವೊ, ಅಪ್ಣೆ ಹಜ್ಜಾ಼ಥು ಜ಼ಯ್ಯೆ.” ");
INSERT INTO vaa_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","“ಮೇಸ್ ಖ್ಹಾಚೊ಼ ದ್ರಾಕ್ಷಿನೊ ವೇಲೊ, ಮಾರೊ ಬಾ ಬಾಗ್‌ನ ದೇಕ್-ಭಾಲ್‌ ಕರಾವಾಳೊ. ");
INSERT INTO vaa_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","ಮಾರಾಮ ರ‍್ಹೀನ್, ಪಂಡು ದೇಯಿಕೊಂತೆ ಹರೇಕ್ ಡಾಳಿನ ಯೋ ಕತ್ರಿನಾಖಸ್‌; ಅಜು಼ ಪಂಡು ದೇಸ್ತೆ ಹರೇಕ್ ಡಾಳಿನ ಬಿಜೂ಼ಬಿ ಜಾ಼ಖ್ಹತ್ ಪಂಡು ದ್ಯವಾನಿಘೋಣಿ ಇನ ಛಾ಼ಟಿನ್ ಪಾಕ್‍ಕರಾಸ್. ");
INSERT INTO vaa_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","ಮೇ ತುಮೂನ ಬೋಲ್ಯೊತೆ ವಚನ್‌ಥಿ ತುಮೆ ಅಗಾಡಿಸ್ ಪಾಕ್‌ ಹುಯಿರ‍್ಹಾಸ್‌. ");
INSERT INTO vaa_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","ತುಮೆ ಮಾರಾಮ ರ‍್ಹವೊ, ಮೇ ತುಮಾರಾಮ ರ‍್ಹೀಶ್. ಡಾಳಿಯೆ ವೇಲಾನ ಜೋ಼ಡೆ ನಾ ರ‍್ಹಿಯುತೊ, ಇನುಯೋಸ್ ಪಂಡು ದ್ಯವಾನ ಕೋ ಹುವ್ವಾನಿಕಿ, ಇಮ್ಮಸ್ ತುಮೆ ಮಾರಾಮ ನಾ ರ‍್ಹಯಾತೊ, ಫಲ್‍ದ್ಯವಾನ ಕೋ ಉಶೇನಿ. ");
INSERT INTO vaa_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","ಮೇ ದ್ರಾಕ್ಷಿನೊ ವೇಲೊ, ಅಜು಼ ತುಮೆ ಡಾಳಿಯೆ. ಏಕ್‌ ಜ಼ಣೊ ಮಾರಾಮ ಅಜು಼ ಮೇ ಇನಾಮ ರ‍್ಹಯೋತೊ, ಯೋಸ್‌ ಜಾ಼ಖ್ಹತ್ ಪಂಡು ದಿಶೆ; ಕತೋಬಿ ತುಮೆ ಮನ ಮ್ಹೆಂದಿನ್ ಶಾತ್ಬಿ ಕರಾನ ಕೋ ಹುವಾನಿ. ");
INSERT INTO vaa_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","ಕೋಣ್ ಮಾರಾಮ ಕೋ ರ‍್ಹೇಯ್ನಿಕಿ, ಯೋ ಭಾರ್ ಫೇಕೈಗಯೂತೆ ಡಾಳಿನಿತರ ಛಾ಼, ಯೋ ಡಾಳಿ ಖ್ಹುಕೈಜಾ಼ಸ್; ಯೋ ಡಾಳಿಯೇನ ಅದ್ಮಿ ಎಕ್ಟು ಕರೀನ್, ಆಗ್‌ಮ ಫೇಕಿನಾಖಸ್‌, ಹಿಜ್ಜಾ಼ ಯೋ ಬಳಿಜಾ಼ಸ್‌. ");
INSERT INTO vaa_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","ತುಮೆ ಮಾರಾಮಬಿ ಮಾರಿ ವಚನ್ ತುಮಾರಾಮ ರ‍್ಹಯೀತೊ, ಶಾತ್‌ ಮಾಂಗಿಲಿದಾತೋಬಿ ಯೋ ತುಮೂನ ಮಳ್‌ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","ತುಮೆ ಜಾ಼ಖ್ಹತ್ ಪಂಡು ದಿಶುತೆ ಇನೇಥಿಸ್ ಮಾರ ಬಾನ ಮಹಿಮೆ ಉಶೆ; ಅಜು಼ ಅಮ್ ತುಮೆ ಮಾರ ಶಿಷ್ಯರ್‌ಉಶು. ");
INSERT INTO vaa_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","ಬಾನೆ ಮನ ಕಿಮ್ ಪ್ಯಾರ್ ಕರ‍್ಯೋಕಿ ಇಮ್ಮಸ್, ಮೇ ತುಮೂನ ಪ್ಯಾರ್ ಕರುಸ್; ತುಮೆ ಮಾರಿ ಲಾಡ್ಮ ಮಳಿರ‍್ಹವೊ. ");
INSERT INTO vaa_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","ಮೇ ಮಾರ ಬಾನಿ ಹುಕುಮ್‌ನ ಪಾಡಿ ಚಾ಼ಲಿನ್, ಇನಿ ಲಾಡ್ಮ ಛೂ಼ತೆ ಇಮ್ಮಸ್, ತುಮೆ ಮಾರಿ ಹುಕುಮ್‌ನ ಪಾಡಿ ಚಾ಼ಲ್ಯಾತೊ, ಮಾರಿ ಲಾಡ್ಮ ಏಕ್‌ ಹುಯಿರ‍್ಹೀಶು. ");
INSERT INTO vaa_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","ಮಾರಾಮ ಛಾ಼ತೆ ಖ್ಹುಶಿ ತುಮಾರಮಾಬಿ ರ‍್ಹೇಣು ಕರಿ, ಅಜು಼ ತುಮಾರಿ ಖ್ಹುಶಿ ಭರೈನ್ ಝ಼ಲಕ್‌ಣು ಕರಿ ಮೇ ಆ ಖ್ಹಾರು ತುಮೂನ ಬೋಲಿರಾಖ್ಯೊಸ್. ");
INSERT INTO vaa_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","ಮೇ ತುಮೂನ ಪ್ಯಾರ್ ಕರ‍್ಯೊತೆ ಇಮ್ಮಸ್, ತುಮೇಬಿ ಏಕ್‌ಥಿ-ಏಕ್‌ ಪ್ಯಾರ್ ಕರ‍್ನು, ಕರಿ ಬೋಲಾನುಸ್ ಮಾರಿ ಹುಕುಮ್‌. ");
INSERT INTO vaa_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","ಇನೊ ಜಾನ್ನಾಸ್ ದೋಸ್ತ್ ಖ್ಹಾರಾನಖ್ಹಾಜೆ ದೇಸ್ತೆ, ಲಾಡ್‌ಥಿ ಮಹಾನ್ ಪ್ಯಾರ್ ಬಿಜು಼ ಕೆಹುಸ್‌ ಕೊಯ್ನಿ. ");
INSERT INTO vaa_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","ಮೇ ತುಮೂನ ದಿದೋತೆ ಹುಕುಮ್‌ನಿಘೋಣಿ ತುಮೆ ಚಾ಼ಲ್ಯಾತೊ, ತುಮೆ ಮಾರ ದೋಸ್ತ್. ");
INSERT INTO vaa_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","ಬಿಜು಼ ಖ್ಹಾಮ್ಣೆ ಮೇ ತುಮೂನ ಆಳ್‌ ಕರಿ ಬುಲಾವ್ ಕೊಯ್ನಿ, ಶನಕತೊ ಯಜಮಾನ್ ಶಾತ್‌ ಕರುಕರಸ್ ಕರಿ ಇನ ಆಳ್‌ನ ಮಾಲುಮ್‌ ಕೋ ರ‍್ಹೇಯ್ನಿ. ಅನಬದಲ್ ಮೇ ತುಮೂನ ದೋಸ್ತ್ ಕರಿ ಬುಲಾವುಸ್‌, ಶನಕತೊ ಬಾಥಿ ಮೇ ಶಾತ್ ಖ್ಹಮ್‌ಜ್ಯೋಕಿ ಖ್ಹಾರಸ್ನ ತುಮೂನ ಬೋಲಿರಾಖ್ಯೊಸ್. ");
INSERT INTO vaa_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","ತುಮೆ ಮನ ಚೂ಼ಣಿನ್ ಕಾಡಿರಾಖ್ಯಕೊಯ್ನಿ; ಮೇ ತುಮೂನ ಚೂ಼ಣಿನ್ ಕಾಡಿರಾಖ್ಯೊಸ್, ತುಮೆ ಜೈ಼ನ್‌, ಪಂಡು ದೇವ್ಣುಕರಿ ಅಜು಼ ಯೋ ಪಂಡು ಕೆದೇಬಿ ದ್ಯವಾನು ಹುಯಿರ‍್ಹೇಣು ಕರಿ, ಮೇ ತುಮೂನ ನೇಮ್‌ಶೈರಾಖ್ಯೋಸ್‌. ಅನಖ್ಹಾಜೆಸ್ ಮಾರ ನಾಮ್‍ಥಿ ತುಮೆ ಶಾತ್‌ ಮಾಂಗಿಲಿದಾತೋಬಿ ಬಾ ತುಮೂನ ಯೋ ದಿಶೆ. ");
INSERT INTO vaa_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","ತುಮೆ ಏಕ್‌ಥಿ-ಏಕ್‌ ಪ್ಯಾರ್ ಕರ‍್ನು, ಕರಿ ಬೋಲಾನುಸ್ ಮಾರಿ ಹುಕುಮ್‌. ");
INSERT INTO vaa_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“ಆ ಜಗತ್‌ ತುಮೂನ ವಹೇರ್‌ ಕರ‍್ಯೂತೊ, ಯೋ ಪಹಿಲೆ ಮನ ವಹೇರ್‌ ಕರ‍್ಯು ಕರಿ ತುಮೆ ಯಾದ್ ಕರಿಲೆವೊ. ");
INSERT INTO vaa_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","ತುಮೆ ಆ ಜಗತ್‌ವಾಳ ಹುಯಿರ‍್ಹಾಹೋತ್ತೊ, ಆ ಜಗತ್‌ವಾಳು ತುಮೆ ಇವ್ಣ ಭಣಿವಾಳ ಕರಿ ಪ್ಯಾರ್ ಕರ‍್ಯುಹೊತ್. ಕತೋಬಿ ತುಮೆ ಜಗತ್‌ ಭಣಿವಾಳ ಕಾಹೆತೆ ಇನಖ್ಹಾಜೆ, ಅಜು಼ ಮೇ ತುಮೂನ ಜಗತ್‌ಮಾಥು ಚೂ಼ಣಿನ್ ಕಾಡಿರಾಖ್ಯೋಸ್ತೆ ಇನಖ್ಹಾಜೆ, ಆ ಜಗತ್‌ ತುಮಾರಪರ್ ವಹೇರ್‌ ಕರಾಸ್. ");
INSERT INTO vaa_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","ಯಾದ್ ಕರಿಲೆವೊ ಆಳ್‌ ಯಜಮಾನ್‍ಥಿ ಮೋಟೊ ಕಾಹೆ’ ಕರಿ ಮೇ ಬೋಲ್ಯೋತೆ ವಾತೆ ಶಾತ್‍ಕತೊ ಇವ್ಣೆ ಮನ ಖ್ಹತಾಯೂತೊ, ತುಮೂನಾಬಿ ಖ್ಹತಾವ್‌ಶೆ; ಇವ್ಣೆ ಮಾರಿ ವಾತೇನ ಪಾಡಿ ಚಾ಼ಲ್ಯುತೊ, ತುಮಾರಿ ವಾತೆನಾಬಿ ಪಾಡಿ ಚಾ಼ಲ್‌ಷೆ. ");
INSERT INTO vaa_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","ಕತೋಬಿ ಇವ್ಣೆ ಮನ ಮೋಕ್ಲಿರಾಖ್ಯೊತೆ ಇನ ಮಾಲುಮ್ ಕರ‍್ಯುಕೊಂತೆ ಇನಖ್ಹಾಜೆ ಆ ಖ್ಹಾರುಮಾರ ನಾಮ್‍ಥಿ ತುಮೂನ ಕರ್ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","ಮೇ ಐನ್ ಆ ಜಗತ್ನಿ ಅದ್ಮಿವೊನಿ ಜೋ಼ಡೆ ವಾತೆ ನಾ ಬೋಲ್ಯೊಹೊತ್ತೊ, ಇವ್ಣುನ ಪಾಪಿ ದೋಷಿಕರಿ ಬೋಲಾಯುಹೊತ್‌ ಕೊಯ್ನಿ. ಕತೋಬಿ ಹಮ್ಕೆ ಮೇ ಐನ್ ವಾತೆ ಬೋಲಿರಾಖ್ಯೊಸ್ ಇನಖ್ಹಾಜೆ ಇವ್ಣ ಪಾಪ್ನ ಖಿವು ಭಾಣುಬಿ ಕೊಯ್ನಿ. ");
INSERT INTO vaa_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","ಮಾರಪರ್ ವಹೇರ್‌ ಕರಾವಾಳು ಮಾರ ಬಾಪರ್‌ಬಿ ವಹೇರ್‌ ಕರಾವಾಳು ಹುಯಿರ‍್ಹುಸ್‍. ");
INSERT INTO vaa_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","ಏಕ್‍ ವಖ್ಹತ್ ಖ್ಹಾರಕಾಮ್ನ ಮೇ ಇವ್ಣಾಮ ನಾಕರ‍್ಯೊಹೋತ್ತೊ, ಇವ್ಣಾಪರ್ ಪಾಪ್ ಕೋ ರ‍್ಹಯುಹೋತ್ನಿ, ಕತೋಬಿ ಹಮ್ಕೆ ಇವ್ಣೆ ದೇಖಿರಾಖ್ಯೂಸ್‌, ತೋಬಿ ಮಾರಪರ್‌ಬಿ ಮಾರ ಬಾಪರ್‌ಬಿ ವಹೇರ್‌ ಕರಾಸ್. ");
INSERT INTO vaa_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","‘ಇವ್ಣೆ ಮನ ನೀಕೊಯ್ನಿತೇಸ್‌ ವಹೇರ್‌ ಕರ‍್ಯು’ ಕರಿ ಇವ್ಣಿ ಧರ್ಮಶಾಸ್ತ್ರಮ ಲೀಖೈರ‍್ಹೂತೆ ವಾತೆ ಪೂರಹುವಾನಖ್ಹಾಜೆ ಅಮ್ ಹುಯೂತೆ. ");
INSERT INTO vaa_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“ಬಾ ಕಂಥು ಆವ್‌ಶೇತೆ ಯೋ ಮದತ್‌ ಕರವಾಳೊ ಆತ್ಮ ಹುಯಿರ‍್ಹೋಸ್. ಯೊ ದೇವ್ನು ಖ್ಹಾಚ಼ನ ಬೋಲಸ್, ಯೋ ತುಮುನ ಮಾರಿ ಬಾರೇಮ ಸಾಕ್ಷಿ ಬೋಲ್‌ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","ತುಮೆ ಶುರುವಾತ್‌ಥೂಸ್ ಮಾರ ಜೋ಼ಡೆ ಥಾತೆ ಇನಖ್ಹಾಜೆ, ತುಮೇಬಿ ಮನ ಸಾಕ್ಷಿ ಹುಯಿರಾಸ್. ");
INSERT INTO vaa_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","ಆ ಖ್ಹಾರಿ ವಾತೆ ಮಾರಿ ಬಾರೇಮ ಮೇ ತುಮುನ ಬೋಲ್ಯೊತೆ ಶನಖ್ಹಾಜೆ ಕತೊ ತುಮಾರಿ ವಿಶ್ವಾಸ್‌ ನಾ ಟುಟಿಪಡ್ನುಕರಿ. ");
INSERT INTO vaa_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","ಇವ್ಣೆ ತುಮೂನ ಸಬಾಮಂದಿರ್‌ಥು ಭಾರ್‌ ಕಾಡಿನಾಕ್‌ಶೆ; ಯೋ ಕೊಂತೆ ತುಮೂನ ಮಾರಿನಾಖವಾಳೊ ಇನೆ ದೇವ್ನ ಬಲಿದಿದೊಕರಿ ಸೋಚಾನ ಹಗಾಮ್ ಆವ್‌ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","ಅದ್ಮಿಖ್ಹಾರು ಬಾನ ರ‍್ಹವೊ, ಮನ ರ‍್ಹವೊ ಮಾಲುಮ್‌ ಕರಿರಾಖ್ಯುಕೊಯ್ನಿತೆ ಇನಖ್ಹಾಜೆ, ತುಮೂನ ಅಮ್ ಖ್ಹಾರು ಕರ್ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","ಕತೋಬಿ ಮೇ ತುಮೂನ ಆ ಖ್ಹಾರು ಅನಖ್ಹಾಜೆ ಬೋಲಿರಾಖ್ಯೊಸ್, ಶನಕತೊ ಆ ಖ್ಹಾರು ಚ಼ಲಾ಼ನಿ ವಖ್ಹತ್‌ಮ, ಮೇ ಪಹಿಲೆ ಬೋಲ್ಯೋತೆ ವಾತೆ ತುಮೆ ಯಾದ್ ಕರಿಲಿಶು. “ಮೇ ತುಮಾರ ಜೋ಼ಡೆ ಥೋತೆ ಇನಖ್ಹಾಜೆ ಅಗಾಡಿಸ್ ಆ ಖ್ಹಾರು ಕೋ ಬೋಲ್ಯೋನಿ. ");
INSERT INTO vaa_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","ಕತೋಬಿ ಹಮ್ಕೆ, ಮೇ ಮನ ಮೋಕ್‌ಲ್ಯೊತೆ ಇನಾಕನ ವಳ್ಯೊಜ಼ವುಸ್‌, ತೋಬಿ ತೂ ಕಿಜ್ಗಾ಼ ವಳ್ಯೊಜಾ಼ಸ್‌? ಕರಿ ತುಮಾರಾಮ ಏಕ್‌ನೇಬಿ ಮನ ಪುಛಾ಼ಯಕೊಯ್ನಿ. ");
INSERT INTO vaa_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","ಹಮ್ಕೆ ಮೇ ತುಮೂನ ಆ ಖ್ಹಾರಿ ವಾತೆ ಬೋಲ್ಯೋತೆ ಇನಖ್ಹಾಜೆ ತುಮಾರ ದಿಲ್ಮ ದುಖ್ ಭರೈರ‍್ಹೂಸ್. ");
INSERT INTO vaa_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","ಕತೋಬಿ ಮೇ ತುಮೂನ ಖ್ಹಾಚ ಬೋಲುಕರುಸ್, ಮೇ ಜಾ಼ವಾನು ತುಮೂನ ಅಛ್ಛು಼ ಹುಯಿರ‍್ಹುಸ್‍, ಶನಕತೊ ಮೇ ನಾ ಗಯೋತೊ, ಯೋ ಮದತ್‌ ಕರವಾಳೊ ತುಮಾರಕನ ಕೋ ಆವ್‌ಶೇನಿ.ಕತೋಬಿ ಮೇ ಗಯೋತೊ, ಇನ ತುಮಾರಕನ ಬೋಲಿ ಮೋಕ್ಲೀಶ್. ");
INSERT INTO vaa_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","ಯೋ ಆವ್‌ಶೇತೆ ತದೆ ಪಾಪ್, ನೀತಿ ಅಜು಼ ನ್ಯಾವ್ ತೀರ್ಪ್‌ನ ಬಾರೇಮ ಜಗತ್ನ ಮಾಲುಮ್‌ ಕರಾವ್‌ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","ಪಾಪ್ನಿ ಬಾರೇಮಾಬಿ ಇವ್ಣೆ ಮನ ವಿಶ್ವಾಸ್‌ ಕರ‍್ಯುಕೊಯ್ನಿ. ");
INSERT INTO vaa_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","ಮೇ ಬಾಕನ ಜೈ಼ನ್‌, ನೀತಿನಿ ಬಾರೇಮ ಅದ್ಮಿಖ್ಹಾರನ ಖ್ಹಾಮ್ಣೆ ಸಾಕ್ಷಿದಿಶ್, ಬಿಜು಼ ಅನಪಾರ್ ಮನ ಘಣಿ ವಖ್ಹತ್ ದೇಕ್‌ಶು ಕೊಯ್ನಿ. ");
INSERT INTO vaa_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","ನ್ಯಾವ್‌ನಿ ಬಾರೇಮ ಆ ಜಗತ್ನ ಅದಿಪತಿನ ನ್ಯಾವ್‍ನಿ ತೀರ್ಪ್ ಹುಯಿಗಯು. ");
INSERT INTO vaa_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","ಮೇ ತುಮೂನ ಬೋಲ್ನುತೆ ವಾತೆ ಬಿಜೂ಼ಬಿ ಘಣಿ ಛಾ಼, ಕತೋಬಿ ಹಮ್ಕೆ ಇನ ಝೇಲಾನ ತುಮೂನ ಕೋ ಉಶೇನಿ. ");
INSERT INTO vaa_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","ಕತೋಬಿ ಖ್ಹಾಚೊ಼ ಆತ್ಮ ಆವ್‌ಶೇತೆ ತದೆ, ಯೋ ತುಮೂನ ಖ್ಹಾರಿಸ್ ಬಾರೇಮ ಖ್ಹಾಚಾಮ ಚ಼ಲೈಲಿಜಾಷೆ. ಯೋ ಬೋಲ್‍ಶೇತೆ ಇನಿ ವಾತೆ ಕಾಹೆ, ಯೋ ಶಾತ್‌ ಖ್ಹಮ್‌ಜಾ಼ಸ್ಕಿ ಯೋಸ್‌ ತುಮೂನ ಬೋಲ್‌ಶೆ; ಅಜು಼ ಖ್ಹಾಮ್ಣೆ ಚಾ಼ಲ್‌ಶೇತೆ ಇನಿ ಬಾರೇಮ ತುಮೂನ ಬೋಲ್‌ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","ಯೋ ಮೇ ಬೋಲುಸ್ತೆ ವಾತೆ ಲೀನ್‌, ತುಮೂನ ಬೋಲಿ ವತಾಳಸ್ತೆ ಇನಖ್ಹಾಜೇಸ್ ಮನಾಸ್ ಮಹಿಮೆ ಕರಸ್. ");
INSERT INTO vaa_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","ಬಾಕನ ಛಾ಼ತೆ ಅಖ್ಖೂಸ್ ಮಾರುಸ್‌; ಇನಖ್ಹಾಜೇಸ್ ಪವಿತ್ರಾತ್ಮ ಮೇ ಬೋಲುಸ್ತೆ ಇನಾಸ್ ಲೀನ್‌, ಯೋ ತುಮೂನ ಬೋಲ್‌ಶೆ ಕರಿ ಮೇ ಬೋಲ್ಯೋತೆ.” ");
INSERT INTO vaa_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“ಥೋಡ ದನ್ನ ಬಾದ್‌ಮ ತುಮೆ ಮನ ದೇಕ್‌ಶು ಕೊಯ್ನಿ, ಕತೋಬಿ ಇನ ಬಾದ್‌ಮ ಥೋಡ ದನ್ ಕೇಡೆ ಮನ ದೇಕ್‌ಶು” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","ಅನ ಖ್ಹಮ್‌ಜಿನ್‌, ಇನ ಶಿಷ್ಯರ್‌ಮ ಥೋಡಾನೆ, “ಅನಿ ಮತ್‌ಲಬ್ ಶಾತ್‌? ಥೋಡ ದನ್ನ ಬಾದ್‌ಮ, ತುಮೆ ಮನ ದೇಕ್ಶುಕೊಯ್ನಿ,ಕತೋಬಿ ಅನ ಬಾದ್‌ಮ ಥೋಡ ದನ್‌ಕೇಡೆ ಮನ ದೇಕ್‌ಶು ಕರಿ ಬೋಲಾಸ್ನಿ? ಅಜು಼, ‘ಶನಕತೊ, ಮೇ ಬಾಕನ ವಳ್ಯೊಜ಼ವುಸ್‌ ಕರೀಬಿ ಬೋಲಾಸ್ನಿ?” ಕರಿ ಇವ್ಣ-ಇವ್ಣ ಮಹಿ ವಾತೆ ಬೋಲಿಲಿದು. ");
INSERT INTO vaa_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","ಅನೆ ಬೋಲ್ಯೊತೆ ‘ಥೋಡ ದನ್ನ ಬಾದ್‌ಮ’ ಕರಿ ಅನಿ ಮತ್‌ಲಬ್ ಶಾತ್‌? ಶಾತ್‌ ಬೋಲಸ್ಕಿ ಹಮೂನ ಮಾಲುಮ್‌ ಕೊಯ್ನಿ!” ಕರಿ ಬೋಲಿಲಿದು. ");
INSERT INTO vaa_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","ಯೇಸುನೆ ಇವ್ಣೆ ಇನ ಪುಛಾ಼ವ್ಣು ಕರಿ ಛಾ಼ ಕರಿ ಮಾಲುಮ್‌ ಕರಿಲೀನ್, ಇವ್ಣುನ, “ಥೋಡ ದನ್ನ ಬಾದ್‌ಮ ತುಮೆ ಮನ ದೇಕ್‌ಶು ಕೊಯ್ನಿ, ಕತೋಬಿ ಅನ ಬಾದ್‌ಮ ಥೋಡ ದನ್ನ ಕೇಡೆ ತುಮೆ ಮನ ದೇಕ್‌ಶು; ಆಸ್ಕಿ ಶು ತುಮೆ ತುಮಾರ-ತುಮಾರ ಮಹಿ ಪುಛಾ಼ವ್‌ ಕರಾಸ್ತೆ? ");
INSERT INTO vaa_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","ಮೇ ತುಮೂನ ಖ್ಹಾಚ ಬೋಲುಕರುಸ್, ತುಮೆ ರೊವ್‌ತಾಹುಯಿನ್, ಕುರ್‌ಲ್ಹಾವ್‌ಶು, ಕತೋಬಿ ಜಗತ್‌ವಾಳು ಖ್ಹುಶೀಕರ್‌ಶೆ; ತುಮೂನ ದುಖ್ ಉಶೆ, ಕತೋಬಿ ತುಮಾರು ದುಖ್ ಜೈ಼ನ್‌, ಖ್ಹುಶಿ ಆವ್‌ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","ಏಕ್‌ ತಯೇಡ ಜ಼ಣಾನಿ ವಖ್ಹತ್‌ಮ, ಇನಿ ಅಜಾ಼ನಿ ವಖ್ಹತ್ ಐಗೈ ಕರಿ ದುಖ್ ಕರಾಸ್, ಕತೋಬಿ ಲಡ್ಕು ಪೈದಾ ಕರಾನ ಬಾದ್‌ಮ, ಜಗತ್‌ಮ ಏಕ್‌ ಲಡ್ಕು ಪೈದಾ ಹುಯಿನ್ ಆಯುತೊ, ಯೋ ಖ್ಹುಶಿಥಿ ಅಜಾ಼ನ ಭೈಕಿಜಾ಼ಸ್‌. ");
INSERT INTO vaa_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","ಇಮ್ಮಸ್ ತುಮೂನಾಬಿ ಹಮ್ಕೆ ದುಖ್ ರ‍್ಹಯುತೋಬಿ, ಮೇ ತುಮೂನ ಪಾಛೊ಼ ದೇಖಿಶ್‌, ತದೆ ತುಮಾರು ದಿಲ್‌ ಖ್ಹುಶೀಥಿ ಭರೈಜಾ಼ಶೆ, ಅಜು಼ ಕಿನೇಥೀಬಿ ತುಮಾರಿ ಖ್ಹುಶಿನ ದೂರ್ ಕಾಡಾನ ಕೋ ಉಶೇನಿ. ");
INSERT INTO vaa_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","ಯೋ ದನ್ಮ, ತುಮೆ ಮನ ಶಾತ್ಬಿ ಕೋ ಪುಛಾ಼ವ್‌ಶುನಿ. ಮೇ ತುಮೂನ ಖ್ಹಾಚ ಬೋಲುಕರುಸ್, ತುಮೆ ಮಾರ ನಾಮ್‌ಪರ್‌ ಶಾತ್‌ ಮಾಂಗಿಲಿದಾತೋಬಿ ಬಾ ತುಮೂನ ಯೋ ದಿಶೆ. ");
INSERT INTO vaa_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","ತುಮೆ ಹಂಕೆತೋಡಿ ಮಾರ ನಾಮ್‌ಪರ್‌ ಶಾತ್ಬಿ ಮಾಂಗಿರಾಖ್ಯಕೊಯ್ನಿ; ಮಾಂಗಿಲೆವೊ ತುಮೂನ ಮಳ್‌ಶೆ, ತದೆ ತುಮಾರಿ ಖ್ಹುಶಿ ಭರೈನ್ ಝ಼ಲಕ್‌ಶೆ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","ಮೇ ಆ ಖ್ಹಾರು ಮತ್ಲಬ್‌ಥಿ ತುಮೂನ ಬೋಲಿರಾಖ್ಯೊಸ್. ಕತೋಬಿ ಬಿಜು಼ ಖ್ಹಾಮ್ಣೆ ಮತ್ಲಬ್‌ನಿ ಖೇಣಿಥಿ ಕಾಹೆತೆ ಬಾನಿ ಬಾರೇಮ ನೇರ್‌ವಳಿಥಿ ತುಮಾರ ಜೋ಼ಡೆ ವಾತೆ ಬೋಲಾನಿ ವಖ್ಹತ್ ಆವ್‌ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","ಯೋ ದನ್ಮ, ಮಾರ ನಾಮ್‌ಪರ್‌ ಮಾಂಗಿಲಿಶು; ಮೇ ಬಾಕನ ತುಮಾರಖ್ಹಾಜೆ ಮಾಂಗಿಲೀಶ್‌ ಕರಿ ಮೇ ತುಮೂನ ಬೋಲಿಶ್ ಕೊಯ್ನಿ. ");
INSERT INTO vaa_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","ತುಮೆ ಮನ ಪ್ಯಾರ್‌ಕರೀನ್ ಮೇ ಬಾಕಂಥೊ ಆಯೋಕರಿ ವಿಶ್ವಾಸ್‌ ಕರ‍್ಯಾತೆ ಇನಖ್ಹಾಜೆ ಬಾಸ್ ತುಮೂನ ಪ್ಯಾರ್‌ಕರಾಸ್‌. ");
INSERT INTO vaa_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","ಮೇ ಬಾಕಂಥೊ ಜಗತ್ನ ಆಯೊ; ಹಮ್ಕೆ ಆ ಜಗತ್ನ ಮ್ಹೆಂದಿನ್, ಬಾಕನ ವಳ್ಯೊಜ಼ವುಸ್‌” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","ತದೆ ಶಿಷ್ಯರ್‌ನೆ ಇನ, “ಹಮ್ಕೆ ತೂ ಮತಲಬ್‌ಥಿ ಕೋ ಬೋಲುಕರಾನೀತೆ ನೇರ್‌ವಳಿಥಿ ಬೋಲುಕರಾಸ್‌. ");
INSERT INTO vaa_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","ತುನ ಖ್ಹಾರುಸ್‌ ವಾತೆ ಮಾಲುಮ್‌ ಕರಿ,ಹಮೂನ ಮಾಲುಮ್. ಅಜು಼ ತುನ ಕೋಣ್‌ಬಿ ಪುಛಾ಼ವಾನಿ ಜ಼ರೂರತ್ ಕೊಯ್ನಿ ಅನೇಥಿ ತೂ ದೇವ್‌ಕಂಥೊ ಆಯೊಹುಯೊ ಕರಿ ಹಮೆ ವಿಶ್ವಾಸ್ ಕರಿಯೇಸ್” ಕರಿ ಬೋಲ್ಯ. ");
INSERT INTO vaa_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","ತದೆ ಯೇಸುನೆ ಇವ್ಣುನ, “ಹಮ್ಕೆ ವಿಶ್ವಾಸ್‌ ಕರೋಸ್ಕಿಶು? ");
INSERT INTO vaa_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","ಹಂದೇಖೊ, ವಖ್ಹತ್ ಐರ‍್ಹೀಸ್ ಹಂಕೇಸ್‌ ಯೋ ವಖ್ಹತ್ ಐರ‍್ಹೀಸ್, ತುಮಾರಾಮ ಏಕೇಕ್‌ ಜ಼ಣು, ಇವ್ಣಿ-ಇವ್ಣಿಝ಼ಗೋಮ ಛಿದ್‍ರೈಜಾ಼ಶು ಮನ ಏಕ್ಲನಾಸ್‌ ಮ್ಹೆಂದಿದ ಕರಿತುಮೆ ನಕೊಸೋಚೊ ಕತೋಬಿ ಮಾರೊ ಬಾ ಮಾರ ಜೋ಼ಡೆ ಛಾ಼. ");
INSERT INTO vaa_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","ತುಮೆ ಮಾರಾಮ ರ‍್ಹೀನ್, ತುಮೂನ ಶಾಂತಿ ಮಳ್‌ಣು ಕರಿ ಆ ಖ್ಹಾರು ತುಮೂನ ಬೋಲಿರಾಖ್ಯೊಸ್. ಜಗತ್‌ಮ ತುಮೂನ ಖ್ಹತಾಪ್ಣಿ ಛಾ಼, ಕತೋಬಿ ಘಟ್ ರ‍್ಹವೊ,ಶನಕತೊ ಮೇ ಜಗತ್ನ ಜೂತಿರಾಖ್ಯೋಸ್‌” ಕರಿಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","ಯೇಸುನೆ ಆ ವಾತೆ ಬೋಲಾನ ಬಾದ್‌ಮ, ಆಕಾಶ್‌ಭಣಿ ದೇಖಿನ್‌, “ಬಾ ವಖ್ಹತ್ ಐಗೈ; ತಾರ ಛಿಯ್ಯಾನ ಮಹಿಮೆ ಕರ್‌, ತದೆ ಛಿಯ್ಯೊ ತುನ ಮಹಿಮೆ ಕರಾನ ಉಶೆ. ");
INSERT INTO vaa_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","ತುನೆ ಇನಖ್ಹಾರ ಅದ್ಮಿಪರ್ ಅದಿಕಾರ್ ದೀರಾಖ್ಯೊಸ್. ತುನೆ ಇನ ಕಿನಕಿನ ದೀರಾಖ್ಯೊಸ್ಕಿ, ಇವ್ಣ ಖ್ಹಾರಾನ ಯೋ ಹಮೇಶಾನಿ ಜಿ಼ಂದ್‌ಗಿ ದೇವ್ಣುಕರಿ ಹುಯಿರ‍್ಹೀಸ್. ");
INSERT INTO vaa_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","ಎಕ್ಕಸ್ ಖ್ಹಾಚೊ಼ ದೇವ್ ಹುಯಿರ‍್ಹೋತೆ ತುನಾಬಿ, ತುನೆ ಮೋಕ್‌ಲ್ಯೊತೆ ಯೇಸು ಕ್ರಿಸ್ತನ ಮಾಲುಮ್‌ ಕರಿ ಲೆವಾನೂಸ್‌ ಹರ್‌ಹಮೇಶಾನಿ ಜಿ಼ಂದ್‌ಗಿ. ");
INSERT INTO vaa_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","ಕರ‍್ನು ಕರಿ ತುನೆ ಮನ ದಿದೋತೆ ಕಾಮ್ನ ಪೂರ ಕರೀನ್, ಜ಼ಮೀನ್‌ಪರ್ ತುನ ಮಹಿಮೆ ಕರಿರಾಖ್ಯೋಸ್. ");
INSERT INTO vaa_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","ಬಾ! ಹಮ್ಕೆ, ತೂ ತಾರ ಖ್ಹಾಮ್ಣೆ ಮನ ಮಹಿಮೆ ಕರ್‌, ಜಗತ್‌ ಉಬ್ಜಾ಼ನ ಅಗಾಡಿ ತಾರ ಜೋ಼ಡೆ ಮನ ಥೀತೆ ಯೋಸ್‌ ಮಹಿಮೆ ಮನ ದೇ. ");
INSERT INTO vaa_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","ಆ ಜಗತ್‌ಮ ಖೆವ ಅದ್ಮಿನ ಮನ ದಿರಾಖ್ಯೋಸ್ಕಿ, ಮೇ ತಾರ ನಾಮ್ನ ಮಾಲುಮ್ ಕರೈರಾಖ್ಯೋಸ್. ಇವ್ಣೆ ಮಾರುಸ್‌ ಹುಯಿರುಥು,ಅಜು಼ ತುನೇಸ್ ಇವ್ಣುನ ಮನ ದಿದೊ. ಇವ್ಣೆ ಮಾರಿ ವಚನ್ನ ಪಾಡಿನ್ ಚಾ಼ಲಿರಾಖ್ಯುಸ್‌. ");
INSERT INTO vaa_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","ತುನೆ ಮನ ದಿದೋತೆ ಖ್ಹಾರುಸ್‌ ತಾರೆಥೀಸ್‌ ಆಯೂತೆ ಕರಿ ಹಮ್ಕೆ ಅವ್ಣೆ ಮಾಲುಮ್‌ ಕರಿರಾಖ್ಯುಸ್. ");
INSERT INTO vaa_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","ತುನೆ ಮನ ದಿದೋತೆ ವಾತೆನ ಮೇ ಇವ್ಣುನ ದೀರಾಖ್ಯೊಸ್; ಅವ್ಣೆ ಯೋ ವಾತೇನ ಮಾನಿಲಿದು ಅಜು಼ ಖ್ಹಾಚ಼ಮಾಬಿ ಮೇ ತಾರಕಂಥೊ ಐರ‍್ಹೋಸ್ ಕರಿ ಮಾಲುಮ್ ಕರ‍್ಯು ಅಜು಼ ತುನೆ ಮನ ಮೋಕ್‌ಲ್ಯೊ ಕರಿ ವಿಶ್ವಾಸ್‌ ಕರಸ್. ");
INSERT INTO vaa_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","ಮೇ ಅವ್ಣಖ್ಹಾಜೆ ಪ್ರಾರ್ಥನೆ ಕರುಸ್; ಜಗತ್‍ವಾಳಾನಖ್ಹಾಜೆ ಕಾಹೆತೆ, ತುನೆ ಮನ ದೀರಾಖವಾಳನಖ್ಹಾಜೆ. ಪ್ರಾರ್ಥನೆ ಕರುಸ್. ಶನಕತೊ, ಅವ್ಣೆ ತಾರು ಅದ್ಮಿ ಹುಯಿರ‍್ಹುಸ್‍. ");
INSERT INTO vaa_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","ಮಾರಕನ ಛಾ಼ತೆ ಖ್ಹಾರು ತಾರುಸ್‌, ಅಜು಼ ತಾರಕನ ಛಾ಼ತೆ ಖ್ಹಾರುಸ್ ಮಾರು; ಅನೇಥಿ ಮನ ಮಹಿಮೆಹುಯು. ");
INSERT INTO vaa_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","ಅನಪಾರ್ ಮೇ ಜಗತ್‌ಮ ಕೋರ‍್ಹಿಶ್‍ನಿ. ಇವ್ಣೆತೋಬಿ ಜಗತ್‌ಮ ರ‍್ಹಿಶೆ. ಮೇ ತಾರಾಕನ ಆವ್‌ಸ್. ಪರಿಶುದ್ ಹುಯಿರೋತೆ ಬಾ, ಅಪ್ಣೆ ಏಕ್‍ಹುಯಿರಾತೆ ತಿಮ್ ಅವ್ಣೇಬಿ ಏಕ್‍ಹುಯಿರ‍್ಯವಾದೆಕರಿ, ತುನೆ ಮನ ದಿದೊತೆ ತಾರ ನಾಮ್‍ಥಿ ಇವ್ಣುನ ಜ಼ತನ್ ರಾಕ್. ");
INSERT INTO vaa_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","ಮೇ ಅವ್ಣ ಜೋ಼ಡೆ ಥೋತೆ ತದೆ ತುನೆ ಮನ ದಿದೋತೆ, ತಾರ ನಾಮ್ನಿ ಶಕಥ್ಥಿ ಅವ್ಣುನ ಜ಼ತನ್ ರಾಖ್ಯೊ. ಧರ್ಮಶಾಸ್ತ್ರನಿ ವಾತೆ ಪೂರಹುವಾನಿಘೊಣಿ, ನಾಶನಖ್ಹಾಜೆಸ್‌ ಕರಿ ಚೂ಼ಣಾಯೋತೆ ಯೋ ಏಕ್‌ ಅದ್ಮಿ ಮ್ಹೆಂದಿನ್, ಅವ್ಣಾಮ ಕೋಣ್‌ಬಿ ನಾಶ ಕೊಹುವಾನಿ. ");
INSERT INTO vaa_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","ಅಜು಼ ಹಮ್ಕೆ ಮೇ ತಾರಕನ ವಳ್ಯಾವ್‌ಸ್‌, ಇನಖ್ಹಾಜೆ ಅವ್ಣಾಮ ಮಾರಿ ಖ್ಹುಶಿ ಭರ್‌ಪೂರ್‌ ಹುವಾನಿ ಘೋಣಿ, ಅನ ಜಗತ್‌ ರ‍್ಹವಾನಿ ವಖ್ಹತ್‌ಮಾಸ್‌ ಆ ವಾತೆನ ಖ್ಹಾರು ಬೋಲುಕರುಸ್. ");
INSERT INTO vaa_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","ಮೇ ತಾರಿ ಸಂದೇಶ್ ಅವ್ಣುನ ದೀರಾಖ್ಯೊಸ್, ಮೇ ಆ ಜಗತ್ನ ಮಳ್ಯೊಹುಯೊ ಕಾಹೆತೆ ಇಮ್ಮಸ್, ಅವ್ಣೇಬಿ ಆ ಜಗತ್ನ ಮಳ್ಯುಹುಯು ಕಾಹೆ, ಅನಖ್ಹಾಜೆಸ್ ಆ ಜಗತ್‌ ಅವ್ಣುನ ವಹೇರ್‌ ಕರಾಸ್. ");
INSERT INTO vaa_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","ಅವ್ಣುನ ಜಗತ್ನ ಹಾತ್‌ಮಾಥು ಕಾಡಿಲಿ ಜಾ಼ ಕರಿ ಮೇ ತುನ ಬೋಲುಕೊಯ್ನಿ, ಕತೋಬಿ ಖರಾಬ್‌ಥಿ ಬಚಾ಼ಡಿನ್, ಜ಼ತನ್ ರಾಕ್ಣು ಕರಿ ಮೇ ತುನ ಬೋಲಿಲೆವ್‌ಸ್ ");
INSERT INTO vaa_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","ಮೇ ಆ ಜಗತ್ನ ಮಳ್ಯೊಹುಯೊ ಕಾಹೆತೆ ಇಮ್ಮಸ್, ಅವ್ಣೇಬಿ ಆ ಜಗತ್ನ ಮಳ್ಯುಹುಯು ಕಾಹೆ. ");
INSERT INTO vaa_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","ತು ಅವ್ಣುನ ಖ್ಹಾಚಾ಼ಥಿ ಸಮರ್ಪಣ್‌ ಕರಿಲೆ ತಾರಿ ವಚನ್ ಖ್ಹಾಚು಼ ಹುಯಿರ‍್ಹೀಸ್‌. ");
INSERT INTO vaa_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","ತುನೆ ಮನ ಆ ಜಗತ್‌ಮ ಮೋಕ್‌ಲ್ಯೊತೆ ಇಮ್ಮಸ್, ಮೇಬಿ ಅವ್ಣುನ ಆ ಜಗತ್‌ಮ ಮೋಕ್ಲಿರಾಖ್ಯೊಸ್. ");
INSERT INTO vaa_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","ಅವ್ಣಖ್ಹಾಜೆ ಮನಾಸ್ ಒಪ್‌ಶೈಲೇವ಼್ಸ್ ಇಮ್ಮಸ್ ಇವ್ಣೇಬಿ ಖ್ಹಾಚಥೀಸ್ ಮನ ಒಪ್‌ಶಾವದೆ. ");
INSERT INTO vaa_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“ಮೆ ಖಲಿ ಅವ್ಣಖ್ಹಾಜೆಸ್‌ ಕಾಹೆ, ಕೋಣ್ ಅವ್ಣ ಸಂದೇಶ್‍ಥಿ ವಿಶ್ವಾಸ್‌ ಕರಾಸ್ಕಿ ಇವ್ಣಖ್ಹಾಜೆಬಿ ಪ್ರಾರ್ಥನೆ ಕರುಸ್. ");
INSERT INTO vaa_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","ಬಾ ತುನೆ ಮನ ಮೋಕ್‌ಲ್ಯೊತೆ ಆ ಜಗತ್‌ ನಂಬಾನಖ್ಹಾಜೆ, ತೂ ಮಾರಾಮ ಅಜು಼ ಮೇ ತಾರಾಮ ಛೂ಼ತೆ ಇಮ್ಮಸ್ ಅವ್ಣೇಬಿ ಅಪ್ಣಾಮ ರ‍್ಹೇವ್ಣುಕರಿ ಇವ್ಣೆಖ್ಹಾರು ಏಕ್‌ ಹುಯಿರ‍್ಹೇಣು ಕರಿ, ಮೇ ಪ್ರಾರ್ಥನೆ ಕರುಸ್. ");
INSERT INTO vaa_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","ಅಪ್ಣೆ ಏಕ್‌ ಹುಯಿರ‍್ಹಾತೆ ಇಮ್ಮಸ್, ಅವ್ಣೇಬಿ ಏಕ್‌ ಹುಯಿರ‍್ಹವಾದೆ ಕರಿ ತುನೆ ಮನ ದಿದೋತೆ ಯೋಸ್‌ ಮಹಿಮೆ ಮೇ ಅವ್ಣುನ ದೀರಾಖ್ಯೊಸ್. ");
INSERT INTO vaa_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","ಮೇ ಇವ್ಣಾಮ ರ‍್ಹೀಶ್ ಅಜು಼ ತೂ ಮಾರಾಮ ರ‍್ಹೀಶ್ ಅನೇಥಿ ಇವ್ಣೆ ಅಮ್ಮಸ್ ಭರ್‌ಪೂರ್‌ಥಿ ಏಕ್‌ ಹುಯಿರ‍್ಹಿಶೆ, ತದೆ ತುನೇಸ್ ಮನ ಮೋಕ್ಯಲ್ಯೋತೆ ಕರಿ ಅಜು಼ ತುನೆ ಮನ ಪ್ಯಾರ್ ಕರ‍್ಯೊತೆ ಇಮ್ಮಸ್, ಅವ್ಣುನಾಬಿ ಪ್ಯಾರ್ ಕರಿರಾಖ್ಯೋಸ್ ಕರಿ ಆ ಜಗತ್ನ ತದೆ ಮಾಲುಮ್‌ ಪಡ್‌ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“ಬಾ! ತುನೆ ಅವ್ಣುನ ಮನ ದಿದೊ, ಅಜು಼ ಮೇ ಕಿಜ್ಗಾ಼ ರ‍್ಹವುಸ್‍ಕಿ ಹಿಜ್ಜಾ಼ಸ್ ಅವ್ಣೇಬಿ ರ‍್ಹೇವ್ಣುಕರಿ ಅಜು಼ ಆ ಜಗತ್ನ ಉಬ್ಜಾ಼ನ ಅಗಾಡಿಸ್, ತುನೆ ಮನ ಪ್ಯಾರ್ ಕರೀನ್, ಮನ ದಿದೋತೆ ಮಹಿಮೆನ ಅವ್ಣೆ ದೇಕ್ಣು ಕರಿ ಮೇ ಆಖ್ಹ್ ಕರುಸ್. ");
INSERT INTO vaa_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","ಧರ್ಮಿ ಹುಯಿರ‍್ಹೋತೆ ಬಾ! ಆ ಜಗತ್‌ ತುನ ಮಾಲುಮ್‌ ಕರಿರಾಖ್ಯುಕೊಯ್ನಿ, ಕತೋಬಿ ಮೇ ತುನ ಮಾಲುಮ್‌ ಕರಿರಾಖ್ಯೋಸ್, ಅಜು಼ ತುನೆ ಮನಮೋಕ್ಲಿರಾಖ್ಯೋಸ್‌ ಕರಿ ಅವ್ಣೆ ಮಾಲುಮ್‌ ಕರಿರಾಖೂಸ್. ");
INSERT INTO vaa_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","ಮೇ ಅವ್ಣುನ ತಾರ ನಾಮ್ನ ಮಾಲುಮ್ ಕರೈರಾಖ್ಯೋಸ್, ಬಿಜೂ಼ಬಿ ಇನ ಮಾಲುಮ್‌ ಕರವ್‌ಸ್ ಕರೀಶ್, ತುನೆ ಮಾರಪರ್ ಖಿವಿ ಪ್ಯಾರ್ ವತಾಳ್ಯೊಕಿ ಮೇಬಿ ಇವ್ಣಾಮ ರ‍್ಹೇವ್ಣುಕರಿ ಪ್ರಾರ್ಥನೆ ಕರುಸ್” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","ಆ ಪ್ರಾರ್ಥನೆ ಕರಾನ ಬಾದ್‌ಮ, ಯೇಸು ಇನ ಶಿಷ್ಯರ್‌ನ ಜೋ಼ಡೆ ಕೆದ್ರೋನ್‌ ವ್ಹೇಕ್ಳಾನ ಪಾರ್ ಚ಼ಲೆಗಯೊ. ಹಿಜ್ಜಾ಼ ಏಕ್‌ ಭಾಗ್‌ ಥೂ, ಯೇಸುಬಿ ಇನ ಶಿಷ್ಯರ್‌ ಇನಾಮಹಿ ಗಯ. ");
INSERT INTO vaa_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","ಯೇಸುನ ಧೋಕೊ ದಿದೋತೆ ಯೂದನಾಬಿ ಯೋ ಝ಼ಗೊ ಮಾಲುಮ್‌ಥು. ಶನಕತೊ ಯೇಸು ಘಣಿ ಹಲ್ಲ ಇನ ಶಿಷ್ಯರ್‌ನ ಹಿಜ್ಜಾ಼ಸ್ ಮಳ್ಯೋಥೊ. ");
INSERT INTO vaa_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","ತದೆ ಯೂದನೆ ಶಿಪಾಯ್ನಿ ಏಕ್‌ ಝೂ಼ಂಡ್‌ನ, ಮಹಾಯಾಜಕರ್‌ ಅಜು಼ ಫರಿಸಾಯರ್‌ನೆ ಮೋಕ್‌ಲ್ಯುತೆ ಮಂದಿರ್‌ನು ಥೋಡ ಕಾವ್ಲಿ ಕರಾವಾಳಾನ ಜೋ಼ಡ್ಮ ಬುಲೈಲಿನ್ ಆಗ್ನು ಢಿಟಂಬು ಅಜು಼ ಕಫ್ಫನ್‌ಅಖ್ಖು ಧರಿಲೀನ್, ಬಾಗ್‌ನ ಮಹಿ ಆಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","ಇನಜೋ಼ಡೆ ಚಾ಼ಲ್‌ಶೇತೆ ಖ್ಹಾರುಸ್‌ ಯೇಸುನ ಮಾಲುಮ್‌ ಥೂ, ಇನಖ್ಹಾಜೆ ಯೋ ಖ್ಹಾಮ್ಣೆ ಜೈ಼ನ್‌, “ತುಮೆ ಕಿನ ಢೂಂಡುಕರಾಸ್ತೆ?” ಕರಿ ಪುಛಾ಼ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","ಇವ್ಣೆ, “ನಜ಼ರೇತ್‌ನೊ ಯೇಸುಕಿಶು” ಕರಿ ಬೋಲ್ಯು. ತದೆ ಯೇಸುನೆ, “ಮೇಸ್ ಯೋ” ಕರಿ ಜವಾಬ್‌ ದಿದು. ಯೇಸುನ ಧೋಕೊ ದಿದೋತೆ ಯೂದಬಿ ಇವ್ಣಿ ಜೋ಼ಡೆ ಹಿಜ್ಜಾ಼ಸ್ ಭೀರ‍್ಯೋಥೊ. ");
INSERT INTO vaa_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","ಯೇಸುನೆ ಇವ್ಣುನ, “ಮೇಸ್ ಯೋ” ಕರಿ ಬೋಲ್ಯೊ. ತದೆ ಇವ್ಣೆ ಪೀಠೆ ಖ್ಹರ್ಕಿನ್‌, ಜ಼ಮೀನ್‌ಪರ್ ಪಡಿಗಯು. ");
INSERT INTO vaa_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","ಪಾಛೊ಼ ಯೇಸುನೆ ಇವ್ಣುನ, “ತುಮೆ ಕಿನ ಢೂಂಡುಕರಾಸ್ತೆ?” ಕರಿ ಪುಛಾ಼ಯೊ. ಇವ್ಣೆ, “ನಜ಼ರೇತ್‌ನೊ ಯೇಸುನ” ಕರಿ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","ತದೆ ಯೇಸುನೆ, “ಮೇಸ್ ಯೋ ಕರಿ ಅಗಾಡಿಸ್ ತುಮೂನ ಬೋಲ್ಯೋನಿ. ತುಮೆ ಮನಾಸ್ ಢೂಂಡುಕರ‍್ತಾ ಉಶೇತೊ, ಅವ್ಣುನ ಜಾ಼ವಾನ ಮ್ಹೇಲೊ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","ಇನಖ್ಹಾಜೆ ಬೋಲ್ಯೊ, “ಬಾ, ತುನೆ ಮನ ದಿದೋತೆ ಇವ್ಣಾಮ ಏಕ್‌ನಾಬಿ ಮೇ ಗುಮೈಲಿದೊಕೊಯ್ನಿ” ಕರಿ ಇನೆ ಬೋಲ್ಯೊಥೋತೆ ವಾತೆ ಅಮ್ ಪೂರಹುಯು. ");
INSERT INTO vaa_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","ಸೀಮೋನ್‌ ಪೇತ್ರಕನ ಏಕ್‌ ತಲ್ವಾರ್‌ ಥೀ, ತದೆ ಇನೆ ತಲ್ವಾರ್‌ನ ಕಾಡೀನ್‌, ಗಲ್‌ಢಯಾಜಕ್‌ನ ಆಳ್‌ನ ಮಾರಿನ್, ಇನು ಖಾವೊ ಕಾನ್ನ ಕತ್ರಿನಾಖ್ಯೊ. ಯೋ ಆಳ್‌ನು ನಾಮ್ ‘ಮಾಲ್ಕ’ ಕರಿ. ");
INSERT INTO vaa_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","ತದೆ ಯೇಸುನೆ ಪೇತ್ರನ, “ತಾರಿ ತಲ್ವಾರ್‌ನ ಕಷ್‌ಬಂದ್‌ನಿ ಚ಼ಂಚಿಮ ಪಾಛು಼ ಘಾಲ್‌; ತೂ ಸೋಚಕೊಯ್ನಿಕಿ ಶು? ಮಾರ ಬಾನೆ ಮನ ದಿದೋತೆ ಕಟೋರಿಮ ಮೇ ನಾ ಪೀಣು ಕರಿ” ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","ಅನಕೇಡೆಥು ರೋಮ್‍ನು ಶಿಪಾಯಿಖ್ಹಾರುಬಿ ಹಜಾ಼ರ್‌ ಶಿಪಾಯಿನೊ ಮೋಟೊಬಿ ಅಜು಼ ಯೆಹೂದ್ಯರ್‌ನ ಕಾವ್ಲಿ ಕರಾವಾಳು ಯೇಸುನ ಧರೀನ್ ಭಾಂದ್ಯು, ");
INSERT INTO vaa_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","ಇವ್ಣೆಪಹಿಲೆ ಅನ್ನಕನ ಬುಲೈಲಿಗಯು. ಆ ಅನ್ನ ಯೋ ವರಖ್ಹ್‌ಮ ಗಲ್‌ಢೊಯಾಜಕ್‌ ಹುಯಿರ‍್ಹೊಥೋತೆ ಕಾಯಫಾನೊ ಮಾಮ. ");
INSERT INTO vaa_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","ಆ ಕಾಯಫಾನೇಸ್, ‘ಏಕ್‌ ಅದ್ಮಿ ತಮಾಮ್‌ ಅದ್ಮಿನಖ್ಹಾಜೆ ಮರ್‌ವಾನುಸ್‌ ಅಛ್ಛು಼’ ಕರಿ ಯೆಹೂದ್ಯರ್‌ನ ಬೋಲಿದಿದೋತೆ. ");
INSERT INTO vaa_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","ಸೀಮೋನ್‌ ಪೇತ್ರ ಅಜು಼ ಶಿಷ್ಯರ್‌ಮ ಬಿಜೇಕ್‌ ಜ಼ಣೊ ಯೇಸುನ ಪೀಠೆ ಗಯೊ. ಯೋ ಬಿಜ್ಜೇಕ್‌ ಶಿಷ್ಯನ ಗಲ್‌ಢೊ ಯಾಜಕ್‌ ಅಛ್ಛಿಂತರ ಮಾಲುಮ್‌ ಥೂ. ಇನಖ್ಹಾಜೆ ಯೋ ಶಿಷ್ಯನೆ ಯೇಸುನ ಜೋ಼ಡೆ ಮಹಾಯಾಜಕ್‌ನು ಘರ್‌ನ ಖ್ಹಾಮ್ಣೇನಿ ಝ಼ಗೋಮ ಗಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","ಕತೋಬಿ ಪೇತ್ರ ಭಾರ್‌ ಬಾಕಲ್‍ಕನ ಟಿವೈರ‍್ಹೋಥೊ. ಮಹಾಯಾಜಕ್‌ನ ಮಾಲುಮ್‍ಥೋತೆ ಬಿಜ್ಜೇಕ್‌ ಶಿಷ್ಯನೆ ಪಾಛೊ಼ ಭಾರ್‌ಐನ್‌, ಬಾಕಲ್‍ಕನ ಕಾವ್ಲಿ ಕರಾವಾಳಿನ ಜೋ಼ಡೆ ವಾತೆ ಬೋಲಿನ್, ಪೇತ್ರಾನ ಮಹಿ ಬುಲೈಲಿಗಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","ತದೆ ಬಾಕಲ್‌ ಕಾವ್ಲಿ ಕರಾವಾಳಿ ಆಳ್‌ನೆ, “ತೂಬಿ ಯೋ ಅದ್ಮಿನೊ ಶಿಷ್ಯರ್‌ಮ ಏಕ್‌ ಜ಼ಣೊ ಕಾಹೆಕಿ ಶು?” ಕರಿ ಬೋಲಿ. ತದೆ ಪೇತ್ರನೆ, “ಕಾಹೆ ಮೇ ಕಾಹೆ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","ತದೆ ಠಣ್‌ ಥೀತೆ ಇನಾಖ್ಹಾಜೆ ಆಳ್‌ಖ್ಹಾರು ಅಜು಼ ಕಾವ್ಲಿ ಕರಾವಾಳು ಕೋಲ್‌ಖ್ಹಾಥಿ ಆಗ್ ಕರೀನ್, ಭೀರಿನ್‌ ಶೇಕುಕರ್ತುಥು, ಪೇತ್ರಬಿ ಜೈ಼ನ್‌, ಇವ್ಣಿ ಜೋ಼ಡೆ ಭೀರಿಗಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","ಗಲ್‌ಢಯಾಜಕ್‌ನೆ ಯೇಸುನ ಇನ ಶಿಷ್ಯರ್‌ನಿ ಬಾರೇಮ ಅಜು಼ ಇನೆ ಬೋಲಿವತಾಳ್ಯೋತೆ ಬಾರೇಮ ಫುಛಾ಼ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","ತದೆ ಯೇಸುನೆ, “ಮೇ ಕದೇಬಿ ಜಗತ್ನ ಖ್ಹಾಮ್ಣೆಸ್ ವಾತೆ ಬೋಲಿರಾಖ್ಯೊಸ್; ಯೆಹೂದ್ಯ ಅದ್ಮಿಖ್ಹಾರು ಎಕ್ಟು ಹುಯಿನ್ ಆವಸ್ತೆ ಸಭೆ ಭರಾವನು ಮಂದಿರ್‌ಮ ಅಜು಼ ಮೋಟಿ ಮಂದಿರ್‌ಮ ಮೇ ಕದೇಬಿ ಬೋಲಿವತಾಳ್‌ತೊ ಆಯೊ, ಮೇ ಲಪೀನ್ ಕದೇಬಿ ಶಾತ್ಬಿ ಕೋ ಬೋಲಿರಾಖ್ಯೊನಿ. ");
INSERT INTO vaa_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","ಅಮ್ ರ‍್ಹವಾಪರ್, ಮನ ಶನ ಪುಛಾ಼ವಸ್ತೆ? ಮೇ ಶಶ್ಶಾತ್ ಬೋಲಿರಾಖ್ಯೊಸ್ ಕರಿ ಇನ ಖ್ಹಮ್‌ಜ್ಯೂತೆ ಅದ್ಮಿನ ಪುಛಾ಼ವೊ; ಮೇ ಬೋಲ್ಯೊತೆ ಇವ್ಣುನ ಮಾಲುಮ್‌” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","ಯೇಸುನೆ ಆ ವಾತೆ ಬೋಲ್ಯೋತೆ ತದೆ, ಇನ ಖನ್ನೆ ಭೀರ‍್ಯುಥೂತೆ ಕಾವ್ಲಿ ಕರಾವಾಳಾಮ ಏಕ್‌ಜ಼ಣಾನೆ ಯೇಸುನ ಕಲ್ಲಪರ್ ಮಾರಿನ್, “ಮಹಾಯಾಜಕನ ಜೋ಼ಡೆ ಅಮ್ ವಾತೆ ಬೋಲಸ್ಕಿಶು? ತುನ ಕೆತ್ರೆ ದಮ್‌” ಕರಿ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","ಯೇಸುನೆ ಇನ, “ಮೇ ಶಾತ್‌ತೋಬಿ ಗಲತ್‌ ಬೋಲ್ಯೊ ಉಶೇತೊ, ಯೋ ಗಲತ್‌ನಿ ಬಾರೇಮ ಸಾಕ್ಷಿ ದೇ; ಕತೋಬಿ ಮೇ ಬೋಲ್ಯೋತೆ ಬರಾಬರ್‌ ಉಶೇತೊ, ತೂ ಮನ ಶನ ಮಾರಸ್?” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","ತದೆ ಅನ್ನನೆ ಯೋ ಕಿಮ್ ಭಂದ್ಯೊಥೋಕಿ ಇಮ್ಮಸ್, ಗಲ್‌ಢೊಯಾಜಕ್‌ ಕಾಯಫಕನ ಇನ ಮೋಕ್‌ಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","ಸೀಮೋನ್‌ ಪೇತ್ರ ಬಿಜೂ಼ಬಿ ಇಮ್ಮಸ್ ಹಿಜ್ಜಾ಼ ಭೀರಿನ್‌, ಆಗ್ ಶೇಕುಕರ್‌ತೋಥೊ. ತದೆ ಹಿಜ್ಜಾ಼ ಥೂತೆ ಇವ್ಣೆ ಇನ, “ತೂಬಿ ಯೋ ಅದ್ಮಿನೊ ಶಿಷ್ಯರ್‌ಮ ಏಕ್‍ಜ಼ಣೊ ಕಾಹೆಕಿ ಶು?” ಕರಿ ಪುಛಾ಼ಯು. ಕತೋಬಿ ಪೇತ್ರನೆ, “ಕಾಹೆ, ಮೇ ಕಾಹೆ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","ಗಲ್‌ಢಯಾಜಕ್‌ನೊ ಆಳ್‌ಮ, ಪೇತ್ರನೆ ಕಾನ್‌ ಕತ್ರಿನಾಖ್ಯೊಥೋತೆ ಇನ ಖನ್ನೆವಾಳಮ ಏಕ್ಜ಼ಣಾನೆ, “ಮೇ ತುನ ಬಾಗ್‌ಮ ಇನಜೋ಼ಡೆ ದೇಖ್ಯೋನಿ?” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","ಪಾಛೊ಼ ಪೇತ್ರನೆ, “ಕಾಹೆ” ಕರಿ ಬೋಲ್ಯೊ. ತದ್‌ನು-ತದೇಸ್‌ ಮುರ್‌ಗೊ ಬಾಂಗ್‌ ದಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","ಅನಕೇಡೆಥು ಇವ್ಣೆ ಯೇಸುನ ಕಾಯಫನ ಘರ್ ಕಂಥು ರಾಜ್ಯಪಾಲ್‌ನು ಮಹೇಲ್‌ನ ಬುಲೈಲಿಗಯು. ಯೆಹೂದ್ಯರ್‌ವಾಳನೆ ಇವ್ಣುನ ಮೈಲಾಪ್‍ ಹುಯಿನ್ ಪಸ್ಕನು ಖಾಣು ಖಾವಾನ ಅಡ್ಡಿಉಶೆಕರಿ ಮಹಾಲ್‌ನ ಮಹಿ ಕೋ ಗಯೂನಿ. ");
INSERT INTO vaa_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","ಇನಖ್ಹಾಜೆ ಪಿಲಾತ ಭಾರ್‌ ಇವ್ಣಾಕನ ಜೈ಼ನ್‌, “ಆ ಅದ್ಮಿಪರ್ ತುಮೆ ಶಾತ್‌ ಗಲತ್‌ ಲಾಗಡೋಸ್?” ಕರಿ ಇವ್ಣ ಪುಛಾ಼ಯು. ");
INSERT INTO vaa_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","ತದೆ ಇವ್ಣೆಬೊಲ್ಯು, “ಆ ಗಲತ್‌ ನಾಕರ‍್ಯೊಹೋತ್ತೊ, ಹಮೆ ಅನ ತಾರಕನ ಶನ ಲಾಯಹೋತ್‌?” ಕರಿ ಜವಾಬ್‌ ದಿದು. ");
INSERT INTO vaa_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","ಪಿಲಾತನೆ ಇವ್ಣುನ, “ಇಮ್‍ಕತೊ, ತುಮೇಸ್ ಅನ ಲೀಜೈ಼ನ್, ತುಮಾರಿ ಧರ್ಮಶಾಸ್ತ್ರನಿಘೊಣಿ ತೀರ್ಪ್‌ ಕರೊ” ಕರಿ ಬೋಲ್ಯೊ. ತದೆ ಯೆಹೂದ್ಯರ್‌ನೆ, “ಕಿನಾಬಿ ಮರಣ್ ದಂಡ್‌ ದ್ಯವಾನಿ ಹಕ್‌ ಹಮೂನ ಕೊಯ್ನಿ” ಕರಿ ಫರೈನ್ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","ಯೇಸುನೆ, ಮೇ ಕಿಮ್ಕಿ ಮೋತ್‌ಮ ಮರಿಶ್‌’ ಕರಿ ಬೋಲ್ಯೊಥೋತೆ ವಾತೆ ಅಮ್ ಪೂರಹುಯಿಗಿ ");
INSERT INTO vaa_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","ಅನಕೇಡೆಥು ಪಿಲಾತನೆ ಪಾಛೊ಼ಫರಿ ಮಹೇಲ್‌ಮ ಜೈ಼ನ್‌, ಯೇಸುನ ಬುಲೈನ್, “ತೂ ಯೆಹೂದ್ಯರ್‌ನೊ ರಾಜಾ಼ಕಿ ಶು?” ಕರಿ ಇನ ಪುಛಾ಼ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","ಯೇಸುನೆ, “ಆ ತಾರೇಥಿ ತೂಸ್ ಪುಛಾ಼ವ್‌ ಕರಾಸ್ಕಿ, ನತರ್‌ಕಿ ಮಾರಿ ಬಾರೇಮ ಬಿಜಾ಼ನೆ ತುನ ಬೋಲ್ಯುತೆ?” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","ತದೆ ಪಿಲಾತನೆ ಬೋಲ್ಯೊ, “ಮೇ ಯೆಹೂದ್ಯ ಕಿಶು? ತಾರು ಶೊಂತ್‌ ಅದ್ಮಿ ಅಜು಼ ಮಹಾಯಾಜಕರ‍್ನೆ ತುನ ಮಾರ ಹಾತ್‌ಮ ದೀರಾಖ್ಯೊಸ್. ತುನೆ ಶಾತ್‌ಕರ‍್ಯೊ?” ಕರಿ ಪುಛಾ಼ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","ಯೇಸುನೆ ಇನ, “ಮಾರಿ ರಾಜ಼್ ಆ ಜಗತ್‌ನು ಕಾಹೆ; ಮಾರಿ ರಾಜ್ಯ ಆ ಜಗತ್‌ನು ಹುಯಿರ‍್ಹೊಹೋತ್ತೊ, ಮೇ ಯೆಹೂದ್ಯರ್‌ನ ಹಾತ್‌ಮ ಮಳ್ಣುನಾತೆ ಇಮ್‌ ಮಾರು ಸೇವಕ್‌ಖ್ಹಾರು ಖ್ಹಾರು ಲಡ್ಯುಹೋತ್‌, ಕತೋಬಿ ಮಾರಿ ರಾಜ಼್ ಹಜ಼್ಜಾನು ಕಾಹೆ!” ಕರಿ ಜ಼ವಾಬ್‌ದಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","ತದೆ ಪಿಲಾತನೆ ಇನ ಬೋಲ್ಯೊ, “ಇಮ್‍ಕತೊ, ತೂ ರಾಜಾ಼ ಕಿಶು?” ಕರಿ ಪುಛಾ಼ಯೊ. ಯೇಸುನೆ, “ಮೇ ರಾಜ಼ ಕರಿ ತೂಸ್ ಬೋಲುಕರಾಸ್‌. ಮೇ ಖ್ಹಾಚಿನಿ ಬಾರೇಮ ಸಾಕ್ಷಿ ಬೋಲಾನಖ್ಹಾಜೆ ಪೈದಾಹುಯಿನ್‌, ಆ ಜಗತ್‌ಮ ಐರ‍್ಹೋಸ್. ಖ್ಹಾಚಿ ಭಣಿವಾಳು ಮಾರಿ ವಾತೇನ ಖ್ಹಮ್‌ಜಾ಼ಸ್‌” ಕರಿ ಜವಾಬ್‌ ದಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","ತದೆ ಪಿಲಾತನೆ, “ಖ್ಹಾಚಿಕತೊ ಶಾತ್‌?” ಕರಿ ಪುಛಾ಼ಯೊ. ಆ ಬೋಲಾನ ಬಾದ್‌ಮ ಪಿಲಾತ ಪಾಛೊ಼ ಯೆಹೂದ್ಯರ್‌ಕನ ಬಹರ್ ಜೈ಼ನ್‌, “ಮನ ಅನಾಮ ಖೆವಿಸ್ ಗಲತ್‌ ದೆಖವ಼್‌ಕರಾಕೊಯ್ನಿ. ");
INSERT INTO vaa_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","ಕತೋಬಿ ಪಸ್ಕ ಪೂಜಾ಼ನಿ ವಖ್ಹತ್‌ಮ ಕೋಂಡಿ ಘಾಲಿರಾಖಾತೆ ಇವ್ಣಾಮ ಏಕ್‌ನ, ಮೇ ತುಮಾರಖ್ಹಾಜೆ ಭಾರ್‌ ಮ್ಹೇಲಾನಿ ಆದತ್ ಛಾ಼. ಮೇ ಯೆಹೂದ್ಯರ್‌ನ ರಾಜಾ಼ನ ತುಮಾರಖ್ಹಾಜೆ ಭಾರ್‌ ಮ್ಹೇಲ್ನು ಕರಿ ತುಮಾರಿ ಆಖ್ಹ್‌ಕಿ ಶು?” ಕರಿ ಪುಛಾ಼ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","ತದೆ ಇವ್ಣೆ, “ಅನ ನಕೊ! ಬರಬ್ಬನಾಸ್ ಮ್ಹೇಲಿದೆ!” ಕರಿ ಚಿಕ್ರಿನ್ ಬೋಲ್ಯು. ಆ ಬರಬ್ಬ ಏಕ್‌ ಢಾಕು ಹುಯಿರ‍್ಹೋಥೊ. ");
INSERT INTO vaa_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","ತದೆ ಪಿಲಾತನೆ ಯೇಸುನ ಲೀಜೈ಼ನ್, ಕೊಳ್ಡೇಥಿ ಮರಾಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","ಅಜು಼ ಸಿಪಾಯಿಖ್ಹಾರು ಕಾಟಾನ ಡಾಳೀಥಿ ಏಕ್‌ ಕಿರೀಟ್ ವಣಿನ್‌, ಯೇಸುನ ಮಾಥಪರ್‌ ಘಾಲೀನ್‌, ಲಾಲ್ ಝ಼ಗ್ಗಾನ ಇನ ಫೇರಾಯು. ");
INSERT INTO vaa_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","ಅಜು಼ ಇನಾಕನ ಐನ್, “ಯೆಹೂದ್ಯರ್‌ನ ರಾಜಾ಼! ತುನ ಖ್ಹಲಾಮ್” ಕರಿ ಬೋಲಿನ್, ಇನ ಕಲ್ಲಪರ್ ಮಾರ‍್ಯು. ");
INSERT INTO vaa_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","ಅನ ಬಾದ್‌ಮ, ಪಿಲಾತನೆ ಪಾಛೊ಼ ಭಾರ್‌ ಜೈ಼ನ್‌, ಇವ್ಣುನ, “ಮನ ಇನಾಮ ಶನೀಶ್ ಗಲತ್‌ ಕೋ ದೆಖಾಯುನಿ ಕರಿ ತುಮೂನ ಮಾಲುಮ್‌ ಪಡಾನಿಘೋಣಿ, ಇನ ತುಮಾರ ಖ್ಹಾಮ್ಣೆ ಬಹರ್ ಲ್ಯಾವುಸ್‌ ದೇಖೊ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","ತದೆ ಯೇಸು ಬಹರ್ ಆಯೊ, ಇನ ಮಾಥಪರ್‌ ಕಾಟಾನಿ ಕಿರೀಟ್ ಘಲೀಥಿ ಅಜು಼ ಇನ ಲಾಲ್ ಝ಼ಗ್ಗೊ ಫೇರೈರಾಖ್ಯುಥು. ಪಿಲಾತನೆ, “ಹಂದೇಖೊ! ಹಜ್ಜಾ಼ ಹುಯಿರೊ ಯೋ ಅದ್ಮಿ!” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","ಮಹಾಯಾಜಕರ್‌ ಅಜು಼ ಮಂದಿರ್‌ನ ಕಾವ್ಲಿ ಕರಾವಾಳನ ಯೇಸುನ ದೇಖಿನ್‌, “ಇನ ಶಿಲ್‌ಬೆಪರ್ ಠಂಗಾವ್! ಇನ ಶಿಲ್‌ಬೆಪರ್ ಠಂಗಾವ್!” ಕರಿ ಚಿಕ್ರಾಲಗ್ಯು ತದೆ ಪಿಲಾತನೆ ಇವ್ಣುನ, “ಹೋಣುಕತೊ ತುಮೇಸ್ ಅನ ಲೀಜೈ಼ನ್, ಶಿಲ್‌ಬೆಪರ್ ನಾಖೊ. ಮನ ಅನಾಮ ಖೆವಿಸ್ ಗಲತ್‌ ದೆಖಾಯು ಕೊಯ್ನಿ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","ತದೆ ಯೆಹೂದ್ಯರ್‌ನೆ, “ಹಮೂನ ಏಕ್‌ ಖಾನುಲ್‌ ಛಾ಼, ಯೋ ಕಾನೂಲ್‌ನಿಘೋಣಿ ಅನ ಮರಣ್ ದಂಡ್‌ ಹೋಣುಸಸ್ ಹೋಣು. ಶನಕತೊ ಅನೆ ಇನು ಯೋಸ್‌, ‘ಮೇ ದೇವ್‌ನೊ ಛಿಯ್ಯೊ ಕರಿ ಬೋಲಿಲಿದೊ” ಕರಿ ಜವಾಬ್‌ ದಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","ಪಿಲಾತನೆ ಆ ವಾತ್ ಖ್ಹಮ್‌ಜಿನ್‌ ಬಿಜೂ಼ಬಿ ಜಾ಼ಖ್ಹತ್ ಡರಿಗಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","ಅಜು಼ ಪಾಛೊ಼ ಮಹೇಲ್‌ಮ ಜೈ಼ನ್‌, ಯೇಸುನ “ತೂ ಕಿಜ್ಜಾಥೊ ಐರ‍್ಹೋಸ್ತೆ?” ಕರಿ ಪುಛಾ಼ಯೊ. ಕತೋಬಿ ಯೇಸುನೆ ಜವಾಬ್‌ ಕೋ ದಿದೋನಿ. ");
INSERT INTO vaa_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","ಪಿಲಾತನೆ ಇನ, “ತೂ ಮಾರ ಜೋ಼ಡೆಬಿ ವಾತೆ ಕೋ ಬೋಲಾನಿ ಕಿಶು? ತುನ ಛೋ಼ಡಾವನಾಬಿ, ತುನ ಶಿಲ್‌ಬೆಪರ್ ನಖಾವಾನಾಬಿ ಮನ ಅದಿಕಾರ್ ಛಾ಼ ಕರಿ ತುನ ಮಾಲುಮ್‌ ಕೊಯ್ನಿಕಿ ಶು?” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","ಯೇಸುನೆ ಜ಼ವಾಬ್ ದಿದೊ, “ದೇವ್ ತುನ ಮಾರಪರ್ ಅದಿಕಾರ್ ನಾ ದಿದೊಹೋತ್ತೊ, ತುನ ಮಾರಪರ್ ಕೆವ್ಹೀಸ್‌ ಅದಿಕಾರ್ ಕೋ ರ‍್ಹಯುಹೋತ್ನಿ, ಇನಖ್ಹಾಜೇಸ್ ಮನ ತಾರ ಹಾತ್‌ಮ ದೀರಾಖ್ಯೊಸ್ತೆ ಅದ್ಮಿನ, ತಾರೆಥೀಬಿ ಘಣು ಪಾಪ್ ಛಾ಼” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","ಆ ವಾತೆನ ಖ್ಹಮ್‌ಜಿನ್‌, ಪಿಲಾತ ಯೇಸುನ ಕಿಮ್‍ತೋಬಿ ಛೋ಼ಡಾವ್‍ಣು ಕರಿ ಕರ‍್ಯೊ, ಕತೋಬಿ ಯೆಹೂದ್ಯರ್‌ನೆ, “ತೂ ಅನ ಛೋ಼ಡಾಯೋತೆ, ತೂ ಕೈಸರ್‌ನೊ ದೋಸ್ತಿಕಾಹೆ ಕರಿ ಮತಲಬ್. ಖ್ಹುದ್‌ನ ರಾಜ಼ ಕರಿಲ್ಯವಾಳೊ ಕೈಸರ್‌ನೊ ದುಶ್‌ಮನ್‌ ಹುಯಿರ‍್ಹೋಸ್!” ಕರಿ ಚಿಕ್ರಿನ್ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","ಆ ವಾತೆನ ಖ್ಹಮ್‌ಜಿನ್‌ ಪಿಲಾತನೆ ಯೇಸುನ ಭಾರ್‌ಬುಲೈನ್‌, ಬಂಡಾ ಭಿಛೈ಼ರ‍್ಹೂತೆ ರಚ್ಚೊ಼,ಇಬ್ರಿಯ ವಾತೇಮ ಗಬ್ಬಥಾ ಕರಿ ಬೊಲೈಲೇಸ್ತೆ ನಾಮ್ನು ಝ಼ಗೋಪರ್‌ ಜೈ಼ನ್‌, ನ್ಯಾವ್‍ನಿ ಖುಡ್‍ಶಿಪರ್ ಬೇಶಿಗಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","ತದೆ ಧೊಪಾರ್‌ ಹುಯಿಗಯುಥು ಅಜು಼ ಯೋ ದನ್ ಪಸ್ಕ ಪೂಜಾ಼ನ ಖ್ಹವಾರಾನೊ ದನ್ ಹುಯಿರ‍್ಹೋಥೊ. ಪಿಲಾತನೆ ಯೆಹೂದ್ಯರ್‌ನ, “ಹಂದೇಖೊ, ತುಮಾರೊ ರಾಜಾ಼ನ!” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","ಇವ್ಣೆ, “ಇನ ಮರೈನಾಕ್‌! ಇನ ಮರೈನಾಕ್‌! ಇನ ಶಿಲ್‌ಬೆಪರ್ ಠಂಗಾವ್!” ಕರಿ ಚಿಕ್‌ರ‍್ಯು. ಅಜು಼ ಪಿಲಾತನೆ ಯೆಹೂದ್ಯರ್‌ನ, “ತುಮಾರ ರಾಜಾ಼ನ ಶಿಲ್‌ಬೆಪರ್ ನಖಾವ್ಣು ಕಿಶು?” ಕರಿ ಬೋಲಾನಿ ವಖ್ಹ್‌ತೆ ಮಹಾಯಾಜಕರ‍್ನೆ ಹಮೂನ ಕೈಸರ್ ಮ್ಹೇಲಿನ್ ಬಿಜೊ಼ ರಾಜ಼ ಕೊಯ್ನಿ ಕರಿ ಜ಼ವಾಬ್ ದಿದು. ");
INSERT INTO vaa_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","ತದೆ ಪಿಲಾತನೆ ಯೇಸುನ ಶಿಲ್‌ಬೆಪರ್ ಮರಾವನಖ್ಹಾಜೆ ಇವ್ಣ ಹಾತ್‌ಮ ದಿನಾಖ್ಯೊ. ಇವ್ಣೆ ಯೇಸುನ ಲೀಗಯು. ");
INSERT INTO vaa_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","ಯೇಸುನೆ ಇನಿ ಶಿಲ್‌ಬೇನ ಪಾಡಿಲೀನ್, “ಖೋಪ್ರಿನಿ ಝ಼ಗೊ” ಕರಿ ಝ಼ಗೋಕನ ಗಯೊ. ಇಬ್ರಿಯ ವಾತೇಮ ಆ ಝ಼ಗೋನಾ, ‘ಗೊಲ್ಗೊಥಾ’ ಕರಿ ಬೋಲಾಸ್. ");
INSERT INTO vaa_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","ಹಿಜ್ಜಾ಼ ಯೇಸುನ ಶಿಲ್‌ಬೆಪರ್ ನಾಖ್ಯು. ಇನಜೋ಼ಡೆ ಬಿಜು಼ ಬೇ ಜ಼ಣಾನ ಹೈಕಡ್‌ ಏಕ್‌ಜ಼ಣಾನ, ಹೀಕಡ್‌ ಏಕ್‌ಜ಼ಣಾನ, ಅಜು಼ ಯೇಸುನ ಇವ್ಣ ಇಚ಼್‌ಮ ಶಿಲ್‌ಬೆಪರ್ ನಾಖ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","ಪಿಲಾತನೆ ಏಕ್‌ ಪಲ್ಗಾಪರ್‌, “ನಜ಼ರೇತ್‌ನೊ ಯೇಸು, ಯೆಹೂದ್ಯರ್‌ನೊ ರಾಜ಼” ಕರಿ ಲೀಖೈನ್, ಶಿಲ್‌ಬೆಪರ್ ಮ್ಹೇಲಾಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","ಯೆಹೂದ್ಯರ್‌ನೆ ಯೇಸುನ ಶಿಲ್‌ಬೆಪರ್ ನಾಖ್ಯುತೆ ಝ಼ಗೊ ಖ್ಹಯೇರ‍್ನ ಖನ್ನೆ ಥೂತೆ ಇನಖ್ಹಾಜೆ ಯೆಹೂದ್ಯರ್‌ಮ ಘಣ ಅದ್ಮಿನೆ ಯೋ ಪಲ್ಗಾಪರ್‌ ಲೀಖೈರ‍್ಹೂತೆ ಇನ ಪಡ್ಯು. ಯೋ ಇಬ್ರಿಯ, ಲ್ಯಾಟಿನ್‌ ಅಜು಼ ಗ್ರೀಕ್‌ವಾತೇಮ ಲೀಖೈರ‍್ಹೂಥು. ");
INSERT INTO vaa_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","ತದೆ ಮಹಾಯಾಜಕರ‍್ನೆ ಪಿಲಾತನ ಅಮ್‍ ಬೋಲ್ಯ, “ಯೆಹೂದ್ಯರ್‌ನೊ ರಾಜ಼ ಕರಿ ನಕೊಲೀಖೊ, ಮೇಸ್ ಯೆಹೂದ್ಯರ್‌ನೊ ರಾಜ಼ ಕರಿ ಬೋಲಿಲಿದೊ ಹುಯೊ’ ಕರಿ ಲೀಖಾವ್ಣು” ಕರಿ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","ಕತೋಬಿ ಪಿಲಾತನೆ, “ಮೇ ಲೀಖ್ಯೋತೆ ಲೀಖೈಗಯು” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","ಯೇಸುನ ಶಿಲ್‌ಬೆಪರ್ ನಾಖಾನ ಬಾದ್ಮ, ಸಿಪಾಯಿಖ್ಹಾರು, ಇನ ಲುಂಗ್ಡಾನ ಚಾರ್ ಭಾಗ್‌ ಕರೀನ್, ಶಿಪಾಯಿಪಿಟ್‌ ಏಕೇಕ್‌ ವಾಟಪಾಡಿಲಿದು. ಕಾಹೆತೆ ಯೇಸುನೊ ಮಹಿನು ಝ಼ಗ್ಗಾನಾಬಿ ಕಾಡಿಲಿದು, ಯೋ ಝ಼ಗ್ಗೋನ ಶಿವಣ್‌ ಕೋಥೂನಿ ಅಜು಼ ಯೋ ಉಪ್ಪರ್‌ಥು ಹೇಟ್‌ತೋಡಿ ಲಾಂಬುಸ್‌ ವಣಿರಾಖ್ಯುಥು. ");
INSERT INTO vaa_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","ಇನ ದೇಖಿನ್ ಇವ್ಣೆ, “ಅಪ್ಣೆ ಅನ ನಾ ಫಾಡ್‌ಣು; ಚಿಟ್ಟಿ ನಾಖಿನ್, ಆ ಕಿನ ಆವಸ್ಕಿ ದೇಖೆ” ಕರಿ ವಾತೆ ಬೋಲಿಲಿದು.ಇವ್ಣೆ ಅನೇಥಿ ‘ಮಾರ ಲುಂಗ್ಡಾನ ಇವ್ಣಾಮ ವಾಟ ಪಾಡೀಲಿದು, ಮಾರ ಝ಼ಗ್ಗಾನಖ್ಹಾಜೆ ಚೀಟಿ ನಾಖ್ಯು’ ಕರಿ ವಚನ್‌ಮ ಲೀಖೈರ‍್ಹೂತೆ ವಾತೆ ಚಾ಼ಲಿಗಿ. ಶಿಪಾಯಿಯೇನೆಬಿ ಆ ಖ್ಹಾರು ಕರ‍್ಯುತೆ. ");
INSERT INTO vaa_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","ಯೇಸುನಿ ಶಿಲ್‌ಬೇನ ಖನ್ನೆ ಇನಿ ಆಯ, ಇನಿ ಆಯಾನಿ ಭೇನ್, ಕ್ಲೋಪಾನಿ ಬಾಯ್ಕೊ ಮರಿಯ, ಮಗ್ದಲನಿ ಮರಿಯ ಖ್ಹಾಮ್ಣೆ ಭೀಯ್ಯೆ಼ಥಿ. ");
INSERT INTO vaa_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","ಯೇಸುನೆ ಇನಿ ಆಯನಾಬಿ, ಇನ ಖನ್ನೆ ಭಿಯೊಥೋತೆ ಪ್ಯಾರ್‌ನ ಶಿಷ್ಯನ ದೇಖಿನ್‌, “ಆಯಾ, ಆಸ್ ತಾರೊ ಛಿಯ್ಯೊ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","ಅನಕೇಡೆಥು ಯೋ ಶಿಷ್ಯನ, “ಆ ತಾರಿ ಆಯ” ಕರಿ ಬೋಲ್ಯೊ. ಯೋ ವಖ್ಹತ್‌ಥೂಸ್‌ ಯೋ ಶಿಷ್ಯನೆ ಮರಿಯನ ಇನ ಘರ್‌ಮಾಸ್ ರಾಖ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","ಆ ಖ್ಹಾರು ಹುವಾನ ಬಾದ್‌ಮ, ಹಮ್ಕೆ ಖ್ಹಾರುಸ್‌ ಖತಮ್ ಹುಯಿಗಯು ಕರಿ ಯೇಸುನೆ ಮಾಲುಮ್‌ ಕರಿಲೀನ್, ವಚನ್‌ಮಾನಿ ವಾತೆ ಚಾ಼ಲಾನಿಘೋಣಿ, “ಮನ ಠೋಖ್ಹ್‌ ಲಾಗುಕರಾಸ್‌” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","ಹಿಜ್ಜಾ಼ ಖ್ಹಖ್ಹ್‌ತು ದ್ರಾಕ್ಷಿನು ರಖ್ಹ್‌ನ ಏಕ್‌ ರಾಛ಼ಮ ಭರಿ ಮ್ಹೇಲಿರಾಖ್ಯುಥು. ತದೆ ಗುಂಜ಼್‌ನ ಯೋ ರಖ್ಹ್‌ಮ ಡುಬೈನ್, ಹಿಸ್ಸೋಪ್‌ ಝಾ಼ಡಾನು ಲಠ್ಠಾಕೇಡೆ ಅಟ್‌ಕೈನ್, ಉಪ್ಪರ್ ಪಾಡೀನ್, ಯೇಸುನ ಮ್ಹೋಡಾನ ಲಗ್ಯಾಡ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","ಯೇಸುನೆ ಯೋ ರಖ್ಹ್‌ನ ಪೀನ್, “ಖತಮ್ ಹುಯಿಗಯು!” ಕರಿ ಬೋಲಿನ್, ಮುಡ್‌ಕ್ಯು ಝು಼ಕೈನ್‌, ಇನಿ ಆತ್ಮಾನ ದೀನಾಖ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","ಯೋ ದನ್ ಶುಕ್ರವಾರ್‌ನೊ ದನ್ ಹುಯಿರ‍್ಹುಥು. ಇನಖ್ಹಾಜೆ ಯೆಹೂದ್ಯರ್‌ನ ಅದಿಕಾರಿಖ್ಹಾರನೆ ಸಬ್ಬತ್‌ ದನ್ಮ ಮುರ್ದು ಶಿಲ್‌ಬೆಪರ್ ನಾ ರ‍್ಹೇವ್ಣುಕರಿ ಪಿಲಾತಕನ, ಶಿಲ್‌ಬೇಪರ್ ಛಾ಼ತೆ ಇವ್ಣ ಗೋಡ ತೋಡೈನ್‌, ಹೇಟ್‌ ಉತಾರೈನಾಖನ ಹುಕುಮ್ ದೇ ಕರಿ ಬೋಲಿಲಿದು. ಶನಕತೊ ಯೋ ಸಬ್ಬತ್‌ ದನ್ ಘಣು ಪವಿತ್ರ ದನ್ ಹುಯಿರ‍್ಹುಥು. ");
INSERT INTO vaa_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","ಇನಖ್ಹಾಜೆ ಸಿಪಾಯಿಖ್ಹಾರು ಐನ್, ಯೇಸುನ ಜೋ಼ಡೆ ಶಿಲ್‌ಬೆಪರ್ ಲಟ್‍ಕೈರ‍್ಹೂಥೂತೆ ಇವ್ಣ ಭೇನು ಗೋಡ ತೋಡಿನಾಖ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","ಕತೋಬಿ ಯೇಸುಕನ ಆವಾದಿನ್, ಯೋ ತದೇಸ್‌ ಮರಿಗಯೋತೆ ಇವ್ಣೆ ದೇಖಿನ್‌, ಇನಗೋಡ ತೋಡ್ಯುಕೊಯ್ನಿ. ");
INSERT INTO vaa_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","ತೋಬಿ ಶಿಪಾಯಿಮ ಏಕ್‌ಜ಼ಣಾನೆ ಇನು ಭಾಲೇಥಿ ಯೇಸುನಿ ಪಾಖ್ಹ್‌ಳಿಮ ಭೋಕ್ಯೊ, ಭೋಕ್‌ತಾಸ್‌ನ ಲ್ಹೋಯಿಬಿ, ಪಾಣಿ ಬಹರ್ ರಂಚಾ಼ಯು. ");
INSERT INTO vaa_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","ಅನ ದೇಖ್ಯೋತೆ ಇನೇಸ್‌ ಸಾಕ್ಷಿ ಬೋಲಿರಾಖ್ಯೊಸ್, ಇನಿ ಸಾಕ್ಷಿ ಖ್ಹಾಚ಼ಸ್ ಶನಕತೊ ತುಮೇಬಿ ಅನ ವಿಶ್ವಾಸ್‌ ಕರ‍್ನು ಕರಿ ಇನೆ ಬೋಲಿರಾಖ್ಯೋಸ್ತೆ. ಅಜು಼ ಯೋ ಬೋಲುಕರಾತೆ ಖ್ಹಾಚಸ್ ಕರಿ ಇನ ಮಾಲುಮ್‌ ಛಾ಼. ");
INSERT INTO vaa_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","ಶನಕತೊ ‘ಇನ ಹಡ್‌ಕ್ಯಾಮ ಏಕ್‌ಬಿ ಹಡ್‌ಕ್ಯು ತುಟ್‌ಶೆ ಕೊಯ್ನಿ’ ಕರಿ ವಚನ್‌ಮ ಛಾ಼ತೆ ವಾತೆ ಪೂರಹುವಾನಖ್ಹಾಜೆ ಅಮ್‌ಹುಯೂತೆ. ");
INSERT INTO vaa_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","ಬಿಜ್ಜೇಕ್‌ ವಚನ್‌ಮ, “ಅದ್ಮಿಖ್ಹಾರು ಇವ್ಣೆ ಭಾಲೇಥಿ ಭೋಕ್ಯುತೆ ಇನ ಠರ್‌ಖೈನ್‌ ದೇಕ್‌ಶೆ” ಕರೀಬಿ ಲಿಖೈರ‍್ಹುಸ್. ");
INSERT INTO vaa_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","ಅನ ಬಾದ್‌ಮ, ಯೆಹೂದ್ಯರ್‌ನ ಡರ್‌ಥಿ ಲಪೀನ್ ಯೇಸುನೊ ಶಿಷ್ಯ ಹುಯಿರ‍್ಹೊಥೋತೆ, ಅರಿಮಥಾಯ ಗಾಮ್‌ನೊ ಯೋಸೇಫ್‌ನೆ, ಯೇಸುನ ಶರೀರ್‌ನ ಮನ ದೇಕರಿ ಪಿಲಾತನ ಬೋಲಿಲಿದೊ. ತದೆ ಪಿಲಾತನೆ ಯೇಸುನ ಶರೀರ್‌ನ ಪಳ್ಳಿಜಾ಼ ಕರಿ ಇನ ಹುಕುಮ್‌ ದೇತಾಖ್ಹತರ್‌, ಇನೆ ಯೋ ಶರೀರ್‌ನ ಪಳ್ಳಿನ್‌, ಗಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","ಪಹಿಲೆ ಏಕ್‌ಹಲ್ಲ ರಾತ್ನಿ ವಖ್ಹತ್‌ಮ, ಯೇಸುಕನ ಆಯೊಥೋತೆ ನಿಕೊದೇಮನೆ ಕಮ್‍ಶಿಕಮ್ ಡೋಡಿಖ್ಹ್‌ ಶೇರ್ ರಕ್ತಬೋಳ ಅಜು಼ ವಾನು ಜ಼ಡಿಬೂಠಿ ಮಳಾಯುಹುಯು ಟುಕ್ಡಾವ್‍ನ ಲೀನ್, ಯೋಸೇಫ್‌ನ ಜೋ಼ಡೆ ಗಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","ಅವ್ಣೆ ಭೇ ಜ಼ಣಾನೆ ಯೇಸುನ ಶರೀರ್‌ನ ಪಳ್ಳಿ ಜೈ಼ನ್‌, ಯೆಹೂದ್ಯರ್‌ಮ ಗಾಡಾಸ್ತೆ ಇಮ್ನಿ ತರೀಕಾಮ, ಇನಾಪರ್‌ ಯೋ ವಾನು ಜ಼ಡಿಬೂಠಿನ ನಾಖಿನ್, ಘಣ ಮೋಲ್ನು ಗಾದಿನ ಲುಂಗ್ಡಾಥಿ ಇನ ಲಪೇಟ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","ಯೇಸುನ ಶಿಲ್‌ಬೆಪರ್ ಲಟ್ಕಾಯುತೆ ಝ಼ಗೋಕನ ಏಕ್‌ ಭಾಗ್‌ ಥೂ, ಯೋ ಬಾಗ್‌ಮ ಏಕ್‌ ನವಿ ಘವಿಥೀ, ಯೋ ಘವಿಮ ತಪ್‌ತೋಡಿ ಕಿನೂಸ್ ಮುರ್ದು ಮ್ಹೇಲ್ಯುಥು ಕೊಯ್ನಿ. ");
INSERT INTO vaa_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","ಯೋ ದನ್ ಯೆಹೂದ್ಯರ್‌ನ ಖ್ಹವಾರಾನೊ ದನ್ ಶುಕ್ರವಾರ್ ಹುಯಿರ‍್ಹೊಥೋತೆ ಇನಖ್ಹಾಜೆ, ಯೋ ಘವಿ ಖನ್ನೆಸ್‌ ಥೀತೆ ಇನಾಟೇಕೆ ಯೇಸುನ ಮುರ್ದಾನ ಇನಾಮ ಮ್ಹೇಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","ವಾರಾನ ಪಹಿಲದನ್ನೆ ಅಧಿರ‍್ಹೇಣೆಸ್‌, ಬಿಜೂ಼ಬಿ ಅಂಧಾರು ರ‍್ಹವಾನಿಸ್ ವಖ್ಹತ್‌ಮ, ಮಗ್ದಲನಿ ಮರಿಯ ಘವಿಕನ ಐನ್, ಘವಿನ ಮೂಚಿರಾಖ್ಯುಥೂತೆ ಬಂಡೊ ನಿಕ್‌ಳೈರ‍್ಹೂಥೂತೆ ದೇಖಿ. ");
INSERT INTO vaa_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","ತದೆ ಇನೆ ಸೀಮೋನ್‌ ಪೇತ್ರ ಅಜು಼ ಯೇಸುನೊ ಪ್ಯಾರ್‌ನೊ ಬಿಜ್ಜೇಕ್‌ ಶಿಷ್ಯಕನ ಮಿಲೈಜೈ಼ನ್‌, ಇನೆ ಇವ್ಣುನ, “ಪ್ರಭುನ ಮಖ್ಹಾಣ್ಯನಿ ಘವಿನ ಮಹಿಥು ಪಳ್ಳಿಜೈ಼ನ್‌, ಕಿಜ್ಜಾ಼ ಮ್ಹೇಲಿರಾಖ್ಯುಸ್ಕಿ, ಹಮೂನ ಮಾಲುಮ್‌ ಕೊಯ್ನಿ!” ಕರಿ ಬೋಲಿ. ");
INSERT INTO vaa_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","ತದೆ ಪೇತ್ರ ಅಜು಼ ಯೋ ಬಿಜ್ಜೇಕ್‌ ಶಿಷ್ಯ ಘವಿಕನ ಗಯ. ");
INSERT INTO vaa_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","ಇವ್ಣೆ ಭೇ ಜ಼ಣ ಮಿಲಾಯ, ಕತೋಬಿ ಯೋ ಬಿಜ್ಜೇಕ್‌ ಶಿಷ್ಯ ಪೇತ್ರಥೀಬಿ ಒಗ್ಗಿಸ್ ಮಿಲೈನ್‌, ಘವಿಕನ ಪಹಿಲೆ ಐನ್, ಪೋಚ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","ಇನೆ ಝು಼ಕಿನ್‌, ಲಪೇಟಿಥೂತೆ ಘಣ ಮೋಲ್ನು ಗಾದಿನು ಲುಂಗ್ಡು ಪಡ್ಯುಥೂತೆ ದೇಖ್ಯೊ, ಕತೋಬಿ ಮಹಿ ಕೋಗಯೋನಿ. ");
INSERT INTO vaa_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","ಸೀಮೋನ್‌ ಪೇತ್ರನ ಪೀಠೆ ಐನ್, ಘವಿನ ಮಹಿ ಜೈ಼ನ್‌, ಯೋ ಘಣ ಮೋಲ್ನು ಗಾದಿನು ಲುಂಗ್ಡ ಪಡ್ಯುಥು. ");
INSERT INTO vaa_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","ಅಜು಼ ಯೇಸುನ ಮುಡ್‌ಕ್ಯಾನ ಭಾಂದ್ಯುಥೂತೆ ಲುಂಗ್ಡು, ಯೋ ಘಣ ಮೋಲ್ನ ಲುಂಗ್ಡಾನ ಜೋ಼ಡೆ ಪಡ್ಯುಥು ಕೊಯ್ನಿತೆ, ಲಪ್‌ಟೈನ್‌ ಏಕಾಡಿ ಅಲಕ್ ಮ್ಹೇಲಿರಾಖ್ಯುಥೂತೆ ದೇಖ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","ಅನಕೇಡೆಥು ಘವಿಕನ ಪಹಿಲೆ ಐನ್, ಪೊಚ್ಯೋತೆ ಯೋ ಬಿಜ್ಜೇಕ್‌ ಶಿಷ್ಯಬಿ ಮಹಿ ಜೈ಼ನ್‌ ದೇಖಿನ್‌, ವಿಶ್ವಾಸ್‌ ಕರ‍್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","ಯೇಸು ಮರ್‌ವಾನ ಬಾದ್‌ಮ ಜಿವ್ತೊ ಹುಯಿನ್ ಉಠಿ ಆವ್ಣುಕರಿ ವಚನ್‌ಮ ಲೀಖೈರ‍್ಹೂತೆ ವಾತೆ ಇವ್ಣುನ ಬಿಜೂ಼ಬಿ ಮಾಲುಮ್‌ ಕೋ ಥೂನಿ. ");
INSERT INTO vaa_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","ಅನಕೇಡೆಥು ಯೋ ಶಿಷ್ಯರ್‌ ಪಾಛು಼ಫರಿ ಘರೆ ಗಯು. ");
INSERT INTO vaa_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","ಕತೋಬಿ ಮರಿಯ ಭಾರ್‌ ಘವಿಕನ ರೊವ್‌ತಿಹುಯಿನ್, ಭೀಯಿಥಿ. ಯೋ ರೊವ್‌ತಿ ಹುಯಿನಸ್‌ ಘವಿನ ಮಹಿ ಝು಼ಕಿನ್‌, ದೇಖಿ. ");
INSERT INTO vaa_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","ತದೆ ಯೇಸುನು ಮುರ್ದು ಮ್ಹೇಲ್ಯುಥೂತೆ ಝ಼ಗೋಮ, ಧೋಳು ಲುಂಗ್ಡು ಪೇರ‍್ಹಿರಾಖ್ಯುಥೂತೆ ಬೇ ದೇವ್‌ನು ದೂತರ್‌ನ ದೇಖಿ. ಇನಾಮ ಏಕ್‌ ಜ಼ಣೊ ಮುಡ್‌ಕ್ಯೂ ಥೂತೆ ಭಣಿ, ಅಜು಼ ಏಕ್‌ ಜ಼ಣೊ ಗೋಡಾಭಣಿ ಬೆಠಾಥ. ");
INSERT INTO vaa_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","ಯೋ ದೇವ್‌ನು ದೂತರ್ ಮರಿಯನ, “ಅಲಿ ಆಯಾ, ತೂ ಶನ ರೊವ್‌ಕರಾಸ್ತೆ?” ಕರಿ ಪುಛಾ಼ಯ. ತದೆ ಇನೆ, “ಮಾರೊ ಪ್ರಭುನು ಮುರ್ದಾನ ಇವ್ಣೆ ಪಳ್ಳಿಚ಼ಲಿಗಯು, ಅಜು಼ ಇನ ಕಿಜ್ಗಾ಼ ಮ್ಹೇಲಿರಾಖ್ಯುಸ್ ಕರಿ ಮನ ಮಾಲುಮ್‌ ಕೊಯ್ನಿ!” ಕರಿ ಜಾ಼ವಾಬ್‌ ದಿದಿ. ");
INSERT INTO vaa_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","ಅಮ್ ಬೋಲಾನ ಬಾದ್‌ಮ, ಪೀಠೆ ಫರೀನ್, ಹಿಜ್ಜಾ಼ ಯೇಸು ಭೀರ‍್ಯೊಥೊತೆ ಇನೆ ದೇಖಿ; ಕತೋಬಿ ಯೋಸ್‌ ಯೇಸು ಕರಿ ಇನ ಮಾಲುಮ್‌ ಕೋ ಹುಯೂನಿ. ");
INSERT INTO vaa_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","ಯೇಸುನೆ ಇನ, “ಅಲಿ ಆಯಾ, ತೂ ಶನ ರೊವ್‌ಕರಾಸ್ತೆ? ತೂ ಕಿನ ಢೂಂಡುಕರಾಸ್ತೆ?” ಕರಿ ಪುಛಾ಼ಯೊ. ಹೈರೋತೆ ಬಾಗ್‌ನ ದೇಖಿಲ್ಯವಾಳೊಕಿ ಶುಕಿ ಕರಿ ಮರಿಯನೆ ಸೋಚಿನ್, ಇನ, “ಮಾಲಿಕ್, ತೂ ಇನ ಪಾಡಿಲೀನ್ ಜೈ಼ರೊ ಉಶೇತೊ, ಕಿಜ್ಗಾ಼ ಮ್ಹೇಲಿರಾಖ್ಯೋಸ್‌ ಕರಿ ಮನ ಬೋಲ್, ಮೇ ಇನ ಪಳ್ಳಿಜ಼ವ್‌ಸ್‌” ಕರಿ ಬೋಲಿ. ");
INSERT INTO vaa_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","ಯೇಸುನೆ ಇನ, “ಮರಿಯ” ಕರಿ ಬೋಲ್ಯೊ. ತದೆ ಇನೆ ಯೇಸು ಭಣಿ ಫರೀನ್, ಇಬ್ರಿಯ ವಾತೇಮ, “ರಬ್ಬೂನಿ!” ಕರಿ ಬೋಲಿ. ರಬ್ಬೂನಿ ಕತೊ, ‘ಗುರು’ ಕರಿ ಮತ್‌ಲಬ್. ");
INSERT INTO vaa_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","ಯೇಸುನೆ ಇನ, “ಮನ ಧರ್‌ನಕೊ, ಶನಕತೊ ಮೇ ಬಿಜೂ಼ಬಿ ಬಾಕನ ಕೋ ಜೈ಼ರ‍್ಹೋನಿ. ಕತೋಬಿ ತೂ ಮಾರ ಭೈಯೇಕನ ಜೈ಼ನ್‌, “ಮೇ ಮಾರೊ ಬಾ ಅಜು಼ ಇವ್ಣೊ ಬಾ, ಮಾರೊ ದೇವ್ ಅಜು಼ ಇವ್ಣೊ ದೇವ್ ಹುಯಿರ‍್ಹೋತೆ ಇನಕನ ಪಾಛೊ಼ ವಳ್ಯೊಜ಼ವುಸ್‌ ಕರಿ ಬೋಲ್” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","ತದೆ ಮಗ್ದಲನಿ ಮರಿಯ ಶಿಷ್ಯರ್‌ಕನ ಜೈ಼ನ್‌, ಇನೆ ಪ್ರಭುನ ದೇಖಿತೆ ಅಜು಼ ಯೇಸುನೆ ಇನ ಬೋಲ್ಯೋತೆ ಬಾರೇಮ ಇವ್ಣುನ ಬೋಲಿ. ");
INSERT INTO vaa_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","ಯೋಸ್‌ ದನ್ನೆಕತೊ, ವಾರಾನ ಪಹಿಲ ದನ್ನೆ ಖ್ಹಾಂಜೆ, ಶಿಷ್ಯರ್‌ ಯೆಹೂದ್ಯರ್ ಅದಿಕಾರಿನ ಡರ್‌ಥಿ ಇವ್ಣೆ ಥಾತೆ ಘರ್‌ನು ಬಾಕಲ್‌ ಮೂಚಿನ್, ಮಹಿ ಥಾ. ತದೆ ಯೇಸು ಐನ್, ಇವ್ಣ ಇಚ಼್‌ಮ ಭೀರಿನ್‌, “ತುಮೂನ ಸಮಾಧಾನ್ ಹುವಾದೆ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","ಆ ಬೋಲಾನ ಬಾದ್‌ಮ, ಇನ ಹಾತ್‌ನಾಬಿ, ಪಾಖ್ಹ್‌ಳಿನಾಬಿ ಇವ್ಣುನ ವತಾಳ್ಯೊ. ಪ್ರಭುನ ದೇಖ್ಯುತೆ ಇನಖ್ಹಾಜೆ ಶಿಷ್ಯರ್‌ ಖ್ಹಾರು ಖ್ಹುಶೀಥಿ ಭರೈಗಯು. ");
INSERT INTO vaa_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","ಯೇಸುನೆ ಇವ್ಣುನ, “ತುಮೂನ ಸಮಾಧಾನ್ ಹುವಾದೆ. ಬಾನೆ ಮನ ಮೋಕ್‌ಲ್ಯೊತೆ ಇಮ್ಮಸ್, ಮೇಬಿ ತುಮೂನ ಮೋಕ್ಲುಸ್‌” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","ಅಮ್ ಬೋಲಾನ ಬಾದ್‌ಮ, ಯೇಸುನೆ ಇವ್ಣಾಪರ್ ಫೂಕಿನ್‌, “ಅಲ್ಲೇವೊ ಪವಿತ್ರಾತ್ಮನ. ");
INSERT INTO vaa_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","ತುಮೆ ಕಿನು ಪಾಪ್ನ ಮಾಪ್‌ ಕರೋಸ್ಕಿ, ಇವ್ಣು ಪಾಪ್ ಮಾಪ್‌ ಉಶೆ; ಅಜು಼ ತುಮೆ ಕಿನು ಪಾಪ್ನ ಮಾಪ್‌ ಕೋ ಕರೋನಿಕಿ, ಇವ್ಣು ಪಾಪ್ ಮಾಪ್‌ ಕೋ ಉಶೇನಿ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","ಯೇಸು ಆಯೋತೆ ತದೆ, ಭಾರ ಶಿಷ್ಯರ್‌ಮ ಏಕ್‌ ಹುಯಿರ‍್ಹೊಥೋತೆ ದಿದುಮಕರಿ ತೋಮ ಇವ್ಣಿ ಜೋ಼ಡೆ ಕೊಥೋನಿ. ‘ದಿದುಮ’ ಕತೊ ಅವಳಿಜವಳಿ ಕರಿ. ");
INSERT INTO vaa_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","ಇನಖ್ಹಾಜೆ ಬಿಜಾ಼ಖ್ಹಾರ ಶಿಷ್ಯರ್‌ನೆ, “ಹಮೆ ಪ್ರಭುನ ದೇಖ್ಯ!” ಕರಿ ಇನ ಬೋಲ್ಯ. ಕತೋಬಿ ತೋಮನೆ, “ಮೇ ಇನ ಹಾತ್‌ಮ ಮೇಕೇಥಿ ಹುಯೂತೆ ಫೋಡಾನ ದೇಖಿನ್‌, ಯೋ ಮೇಕೆ ಮರೈತೆ ಝ಼ಗೋಮ ಮಾರಿ ಅಂಗ್‌ಳಿ ಘಾಲಿನ್, ಇನಿ ಪಾಖ್ಹ್‌ಳಿಮ ಮಾರಹಾತೇಥಿ ಛಿಮಾಶೆ ತುಮಾರಿ ವಾತೇನ ನಂಬುಕೊಯ್ನಿ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","ಆಟ್ ದನ್ ಬಾದ್‌ಮ, ಇನ ಶಿಷ್ಯರ್‌ ಪಾಛು಼ ಮಹಿ ಥಾತೆ ತದೆ, ತೋಮಾಬಿ ಇವ್ಣಿ ಜೋ಼ಡೆ ಥೊ. ಬಾಕಲ್‌ ಮೂಚೈ಼ರ‍್ಹೂಥು, ತದೆ ಯೇಸು ಐನ್, ಇವ್ಣ ಇಚ಼್‌ಮ ಭೀರಿನ್‌, “ತುಮೂನ ಸಮಾಧಾನ್ ಹುವಾದೆ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","ಅನಕೇಡೆಥು ಯೇಸುನೆ ತೋಮನ, “ತಾರಿ ಅಂಗ್‌ಳಿನ ಹಜ಼್ಜ ಮ್ಹೇಲಿನ್, ಮಾರ ಹಾತ್ನ ಛೀಮಿನ್‌ ದೇಕ್; ತಾರ ಹಾತ್ನ ಖ್ಹಾಮ್ಣೆ ಕರೀನ್, ಮಾರಿ ಪಾಖ್ಹ್‌ಳಿಮ ಘಾಲ್‌, ವಿಶ್ವಾಸ್‌ಕೊಂತೆ ನಕೊ ರ‍್ಹೇ, ವಿಶ್ವಾಸ್‌ ಕರ್‌!” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","ತೋಮನೆ ಯೇಸುನ, “ಮಾರೊ ಪ್ರಭು, ಮಾರೊ ದೇವ್!” ಕರಿ ಜವಾಬ್‌ ದಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","ಯೇಸುನೆ ಇನ, “ತೂ ಮನ ದೇಖ್ಯೋತೆ ಇನಖ್ಹಾಜೆ ವಿಶ್ವಾಸ್ ಕರ‍್ಯೊ; ಕತೋಬಿ ಮನ ದೇಖಾಕೊಯ್ನಿತೆ ವಿಶ್ವಾಸ್‌ ಕರಾವಾಳುಸ್‌ ಖ್ಹಾಚಮಾಬಿ ಧನ್ಯರ್” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","ಯೇಸುನೆ ಬಿಜೂ಼ಬಿ ಕೈಯೆಕ್ಕಿ ಅದ್ಭುತ್ ಕಾಮ್ನ ಖ್ಹಾರು ಇನ ಶಿಷ್ಯರ್‌ನ ಖ್ಹಾಮ್ಣೆ ಕರ‍್ಯೊ.ಎತ್ರ ಅಖ್ಖಾಕಾಮ್ನ ಥೋಡುಬಿ ಅದ್ಭುತ್‌ಖ್ಹಾರು ಆ ಪುಸ್ತಕ್‌ಮ ಕೋ ಲೀಖೈರ‍್ಹೂನಿ. ");
INSERT INTO vaa_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","ಕತೋಬಿ ಯೇಸುಸ್‌ ಕ್ರಿಸ್ತ ಕರೀಬಿ, ದೇವ್‌ನೊ ಛಿಯ್ಯೊ ಕರೀಬಿ ತುಮೆ ನಂಬಿನ್, ಇನ ನಾಮ್‍ಥಿ ತುಮೂನ ಜಾನ್‌ ಮಳಾದೆ ಕರಿ ಅತ್ರುಖ್ಹಾರು ಲೀಖೈರ‍್ಹುಸ್. ");
INSERT INTO vaa_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","ಅನ ಬಾದ್‌ಮ, ಯೇಸು ತಿಬೇರಿಯ ದರ‍್ಯಾವ್‌ಕನ ಇನ ಶಿಷ್ಯರ್‌ನ ದೆಖಾಯೊ. ಯೋ ಅಮ್ ಚಾ಼ಲ್ಯುತೆ. ");
INSERT INTO vaa_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","ಸೀಮೋನ್‌ ಪೇತ್ರಬಿ, ದಿದುಮಕರಿ ತೋಮಾಬಿ, ನತಾನಿಯೇಲ್‌ ಆ ಗಲಿಲಾಯನು ಕಾನಾ ಕರಿ ಗಾಮ್‌ವಾಳೊ, ಜೆಬೆದಾಯನ ಛಿಯ್ಯಾ, ಅಜು಼ ಯೇಸುನ ಬಿಜ಼ ಬೇ ಶಿಷ್ಯರ್‌ ಥಾ. ");
INSERT INTO vaa_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","ಸೀಮೋನ್‌ ಪೇತ್ರನೆ ಇವ್ಣುನ, “ಮೇ ಮಾಛ಼್‌ಲಾ ಖ್ಹಾವಾನ ವಳ್ಯೊಜ಼ವುಸ್‌” ಕರಿ ಬೋಲ್ಯೊ. ತದೆ ಇವ್ಣೆ, “ಹಮೇಬಿ ತಾರ ಜೋ಼ಡೆ ಐಯೇಸ್‌” ಕರಿ ಇನ ಬೋಲ್ಯ. ಇವ್ಣೆ ಜೈ಼ನ್‌, ಡೋಣ್‌ ಚ಼ಢ್ಯಾ, ಕತೋಬಿ ಯೋ ರಾತ್‌ ಅಖ್ಖು ಏಕ್‌ ಮಾಛ್ಲು಼ಬಿ ಮಳ್ಯುಕೊಯ್ನಿ. ");
INSERT INTO vaa_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","ವ್ಹಾಣು ಹುವ್ವಾದೀನ್, ಯೇಸು ಕನಾರೆಕನ ಭಿಯೋಥೊ; ತೋಬಿ ಶಿಷ್ಯರ್‌ನ ಯೋ ಯೇಸು ಕರಿ ಮಾಲುಮ್‌ ಕೋ ಪಡ್ಯುನಿ. ");
INSERT INTO vaa_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","ತದೆ ಯೇಸುನೆ ಇವ್ಣುನ, “ದೋಸ್ತಿವೊ ತುಮೂನ ಮಾಛ್ಲು಼ ಮಳ್ಯುಕಿ ಶು?” ಕರಿ ಪುಛಾ಼ಯೊ. ಇವ್ಣೆ, “ಕೊಯ್ನಿ” ಕರಿ ಜವಾಬ್‌ ದಿದಾ. ");
INSERT INTO vaa_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","ಯೇಸುನೆ ಇವ್ಣುನ, “ಡೋಣ್‌ನಿ ಖಾವಿ ಬಾಜು಼ಮ ಜಾ಼ಳು ನಾಖ್ಯಾತೊ, ತುಮೂನ ಥೋಡು ಮಾಛ಼್‌ಲಾ ಮಳ್‌ಶೆ” ಕರಿ ಬೋಲ್ಯೊ. ಇವ್ಣೆ ಇಮ್ಮಸ್ ಜಾ಼ಳು ನಾಕ್ತಾನ ಘಣು ಮಾಛ಼್‌ಲಾ ಮಳ್ಯುತೆ ಇನಖ್ಹಾಜೆ, ಜಾ಼ಳಾನ ಪಾಛು಼ ಮಹಿ ಖೇಚಾ಼ನ ಕೋ ಹುಯೂನಿ. ");
INSERT INTO vaa_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","ಯೇಸುನೊ ಪ್ಯಾರ್‌ನೊ ಶಿಷ್ಯನೆ ಪೇತ್ರನ, “ಯೋ ಪ್ರಭುಲಾ!” ಕರಿ ಬೋಲ್ಯೊ. ಸೀಮೋನ್ ಪೇತ್ರನೆ ಇನ ಖ್ಹಮ್‌ಜಿನ್‌, ಮಾಛ್ಲು಼ ಖ್ಹಾವಾನಖ್ಹಾಜೆ ಪೇತ್ರನೆ ಝೋ಼ಳ್‍ನಾನ ಕಾಡಿ ಮ್ಹೇಲಿರಾಖ್ಯೊಥೊ ಯೊ ಪಾಛು಼ ಉಪ್ಪರ್‌ಲ್ಯು ಝ಼ಗ್ಗಾನ ಪೇರ‍್ಹಿಲೀನ್‌ ದರ‍್ಯಾವ್‌ಮ ಕೂದಿ ಗಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","ದರ‍್ಯಾವ್‍ನಿ ಕನಾರಿ ದೂರ್ ಶಾತ್ಬಿ ಕೋ ಥೂನಿ, ಖಲಿ ಖ್ಹೋ ಮೀಟರ್ ದೂರ್ ಥೂತೆ ಇನಖ್ಹಾಜೆ, ಬಿಜ಼ ಶಿಷ್ಯರ್‌ ಮಾಛ಼್‌ಲು ಭರೈರ‍್ಹುಥೂತೆ ಯೋ ಜಾ಼ಳಾನ ಖೇಚ಼್‌ತು ಹುಯಿನ್, ಡೋಣ್‌ಮಾಸ್‌ ಆಯು. ");
INSERT INTO vaa_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","ಇವ್ಣೆ ಡೋಣ್‌ಮಾಥು ಉತ್ರಿನ್, ಕನಾರೆ ಆವಾದಿನ್, ಕೋಲ್‌ಖ್ಹಾನಿ ಆಗ್ ಅಜು಼ ಇನಾಪರ್‌ ಮ್ಹೇಲಿರಾಖ್ಯುಥೂತೆ ಮಾಛ಼್‌ಲಾ ಅಜು಼ ಥೋಡು ರೋಟಾನಾಬಿ ದೇಖ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","ಯೇಸುನೆ ಇವ್ಣುನ, “ತುಮೆ ಹಮ್ಕೆ ಧರ‍್ಯಾತೆ ಮಾಛ್ಲಾ಼ವ್‍ಮ ಥೋಡು ಲ್ಯಾವೊ” ಕರಿ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","ಸೀಮೋನ್‌ ಪೇತ್ರನೆ ಡೋಣ್ಣಾ ಮಹಿ ಜೈ಼ನ್‌, ಜಾ಼ಳಾನ ಕನಾರಿಕನ ಖೇಚಿ ಲಾಯೊ. ಯೋ ಏಕ್‌ಖ್ಹೊ ತೀನ್‌ಉಪ್ಪರ್‌ ಅಡೈವಿಖ್ಹ್‌ ಮೋಟಾ ಮಾಛ್ಲಾ಼ಥಿ ಭರೈರ‍್ಹೂಥು, ಎತ್ರುಬಲ್ಲ ಮಾಛ಼್‌ಲು ರ‍್ಹಯುತೋಬಿ ಜಾ಼ಳು ಫಾಟ್ಯುಕೊಯ್ನಿ. ");
INSERT INTO vaa_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","ಯೇಸುನೆ ಇವ್ಣುನ “ಐನ್, ಖಾಣು ಖಾವೊ” ಕರಿ ಬೋಲ್ಯೊ. ಯೋ ಪ್ರಭುಸ್ ಶಿಷ್ಯರ್‌ನ ಮಾಲುಮ್‌ ಥೂತೆ ಇನಖ್ಹಾಜೆ, “ತೂ ಕೋಣ್?” ಕರಿ ಇವ್ಣಾಮ ಕಿನೇಬಿ ಪುಛಾ಼ವಾನಿ ಭಾಲ್ ಕೋ ಕರ‍್ಯುನಿ. ");
INSERT INTO vaa_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","ಯೇಸುನೆ ಐನ್, ರೋಟಾನ ಪಾಡೀನ್, ಇವ್ಣುನ ದಿದೊ; ಇಮ್ಮಸ್ ಮಾಛ್ಲಾ಼ನಾಬಿ ಪಾಡಿನ್ ದಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","ಯೇಸು ಮರಿನ್‌, ಜಿವ್ತೊಹುಯಿನ್ ಉಠಾನ ಬಾದ್‌ಮ ಇನ ಶಿಷ್ಯರ್‌ ದೆಖಾಯೊತೆ ಆ ತೀನ್ನೆ ಹಲ್ಲ. ");
INSERT INTO vaa_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","ಇವ್ಣೆ ಖಾಣು ಖಾವಾನ ಬಾದ್‌ಮ, ಯೇಸು ಸೀಮೋನ್‌ ಪೇತ್ರನ, “ಯೋಹಾನ್ನ ಛಿಯ್ಯೊ ಸಿಮೋನ್, ತೂ ಅವ್ಣೆಥೀಬಿ ಜಾ಼ಖ್ಹತ್ ಮನ ಪ್ಯಾರ್ ಕರಾಸ್ಕಿಶು?” ಕರಿ ಪುಛಾ಼ಯೊ. ಪೇತ್ರನೆ, “ಓಹೋಲಾ, ಪ್ರಭು, ಮೇ ತುನ ಪ್ಯಾರ್ ಕರುಸ್” ಕರಿ ಬೋಲ್ಯೊ. ತದೆ ಯೇಸುನೆ ಇನ, “ಮಾರು ಮೇಂಢಾನು ಚೆಲ್ಕಾವ್ನ ಚ಼ರಾವ್‌” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","ಬೇನೆ ಹಲ್ಲ ಯೇಸುನೆ ಪೇತ್ರನ, “ಯೋಹಾನ್ನ ಛಿಯ್ಯಾ ಸೀಮೋನ್‌, ತೂ ಮನ ಪ್ಯಾರ್ ಕರಾಸ್ಕಿಶು?” ಕರಿ ಬೋಲ್ಯೊ. ತದೆ ಇನೆ, “ಓಹೋಲಾ, ಪ್ರಭು ಮೇ ತುನ ಪ್ಯಾರ್ ಕರೂಸ್‌ಕರಿ ತುನಾಸ್ ಮಾಲುಮ್‌” ಕರಿ ಬೋಲ್ಯೊ. ಯೇಸುನೆ ಇನ, “ಮಾರ ಮೇಂಢವ್‌ನಿ ಖ್ಹದರ್ ಕರ್‌” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","ತೀನ್ನೆಹಲ್ಲ ಯೇಸುನೆ, “ಯೋಹಾನ್ನ ಛಿಯ್ಯಾ ಸೀಮೋನ್‌, ತೂ ಮನ ಪ್ಯಾರ್ ಕರಾಸ್ಕಿ ಶು?” ಕರಿ ಪುಛಾ಼ಯೊ. ಯೇಸುನೆ ತೀನ್ನೆಹಲ್ಲ ಇನ, “ತೂ ಮನ ಪ್ಯಾರ್ ಕರಾಸ್ಕಿಶು?” ಕರಿ ಪುಛಾ಼ವ್‌ತಾನ, ಪೇತ್ರನ ದುಖ್‍ಹುಯು. ತದೆ ಇನೆ, “ಪ್ರಭು, ತುನ ಖ್ಹಾರುಸ್‌ ಮಾಲುಮ್‌; ಮೇ ತುನ ಪ್ಯಾರ್ ಕರುಸ್ ಕರೀಬಿ ತುನ ಮಾಲುಮ್‌!” ಕರಿ ಬೋಲ್ಯೊ. ಯೇಸುನೆ ಇನ, “ಮಾರ ಮೇಂಢವ್‌ನಿ ಖ್ಹದರ್‌ಕರ್‌” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","ಮೇ ತುನ ಖ್ಹಾಚ ಬೋಲುಕರುಸ್, ತೂ ಜಾ಼ನ್ಜ಼ಮಾನ್ ಥೋತೆ ತದೆ, ತಾರಿ ಕಂಬರ್‌ನ ಭಾಂದಿಲೀನ್, ತುನ ಕಿಜ್ಗಾ಼ ಅಛ್ಛು಼ ಲಾಗಸ್ಕಿ ಹಿಜ್ಜಾ಼ ಜಾ಼ತೋಥೊ; ಕತೋಬಿ ತೂ ಬುಢೋ ಹುಯಿಜೈ಼ಶ್ತೆ ತದೆ ತಾರ ಹಾತ್ನ ಪಖ್ಹಾರೀಶ್‌, ಅಜು಼ ಬಿಜ್ಜೇಕ್‌ ಜ಼ಣೊ ತಾರಿ ಕಂಬರ್‌ನ ಭಾಂದೀನ್‌, ತುನ ಅಛ್ಛು಼ ಲಾಗಕೊಂತೆ ಹೀಕಡ್‌ ತುನ ಲೀಜಾ಼ಶೆ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","ದೇವ್ನ ಮಹಿಮೆ ಕರಾನಖ್ಹಾಜೆ ಪೇತ್ರ ಕಿಮ್ನು ಮೋತ್ ಮರ್‌ಶೆ ಕರಿ ಆ ವಾತೇಥಿ ಯೇಸುನೆ ಬೋಲ್ಯೊ. ಅಮ್ ಬೋಲಾನ ಬಾದ್‌ಮ, ಯೇಸುನೆ ಇನ, “ಮಾರ ಪೀಠೆ ಆವ್!” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","ಪೇತ್ರ ಪೀಠೆ ಫರಿ ದೇಖಿನ್‌, ಯೇಸುನೊ ಪ್ಯಾರ್‌ನೊ ಶಿಷ್ಯ ಇವ್ಣ ಪೀಠೆ ವಳ್ಯಾವಾತೆ ದೇಖ್ಯೊ.ರಾತ್ಮ ಖಾಣು ಖಾವಾನಿ ವಖ್ಹತ್‌ಮ ಯೇಸುನಿ ಛಾ಼ತಿಕನ ಝು಼ಕಿನ್‌, “ಪ್ರಭು, ತುನ ಧೋಕೇಥಿ ಧರಿದಿಶ್ಶೆತೆ ಕೋಣ್?” ಕರಿ ಪುಛಾ಼ಯೋತೆ ಯೋಸ್‌ ಶಿಷ್ಯ. ");
INSERT INTO vaa_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","ಯೋ ಶಿಷ್ಯನ ದೇಖಿನ್‌, ಪೇತ್ರನೆ ಯೇಸುನ, “ಪ್ರಭು ಅನಿ ಬಾರೇಮ ಶಾತ್‌?” ಕರಿ ಪುಛಾ಼ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","ಯೇಸುನೆ ಇನ, “ಮೇ ಆವಾತೋಡಿ, ಆ ಜಿವ್ತೊ ರ‍್ಹೇವ್ಣುಕರಿ ಮನ ಮನ್ ರ‍್ಹಯೂತೊ, ಇನೇಥಿ ತುನ ಶಾತ್‌? ತೂ ಮಾರ ಪೀಠೆ ಆವ್” ಕರಿ ಜವಾಬ್‌ ದಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","ಅನೇಥಿ ಯೋ ಶಿಷ್ಯ ಮರ್‌ಶೆಕೊಯ್ನಿ ಕರಿ ಬೋಲಾನಿ ವಾತೆ ಯೇಸುನ ಭೈಯೇವ್‌ಮ ಫೈಲಿಗಯು. ಯೋ ಮರ್‌ಶೆಕೊಯ್ನಿ. ಕತೋಬಿ ಯೇಸುನೆ ಇನ ಬೋಲ್ಯೊಕೊಯ್ನಿ, “ಮೇ ಆವಾತೋಡಿ, ಯೋ ಜಿವ್ತೊ ರ‍್ಹೇವ್ಣುಕರಿ ಮನ ಮನ್ ರ‍್ಹಯೂತೊ, ಇನೇಥಿ ತುನ ಶಾತ್‌?” ಕರೀಶ್ ಯೇಸುನೆ ಬೋಲ್ಯೊತೆ. ");
INSERT INTO vaa_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","ಆ ಖ್ಹಾರಿ ಬಾರೇಮ ಲೀಖಿನ್, ಅನಿ ಬಾರೇಮ ಸಾಕ್ಷಿ ಬೋಲವಾಳೊ ಶಿಷ್ಯ ಆಸ್. ಯೋ ಬೋಲ್ಯೋತೆ ಖ್ಹಾಚ಼ಸ್ ಕರಿ ಹಮೂನ ಮಾಲುಮ್‌. ");
INSERT INTO vaa_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","ಅತ್ರೇಸ್ ಕಾಹೆತೆ, ಯೇಸುನೆ ಕರ‍್ಯುತೆ ಬಿಜೂ಼ಬಿ ಕೈಯೆಕ್ಕಿ ಛಾ಼. ಯೋ ಖ್ಹಾರಾನ ಏಕೇಕ್‌ ಕರಿ ಲೀಖ್ಯೂತೋ, ಲೀಖಾವ್ಣುತೆ ಪುಸ್ತಕ ಖ್ಹಾರು ಹಿಡಿ ಜಗತ್ತಸ್ ಬಶ್‌ ಕೋ ಉಶೇನಿ ಕರಿ ಮೇ ಸೋಚುಸ್.");
INSERT INTO vaa_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","ಪ್ಯಾರ್‌ನೊ ಥಿಯೊಫಿಲ, ಯೇಸುನೆ ಕರ‍್ಯೊತೆ ಕಾಮ್ನಿ ಬಾರೇಮ ಅಜು಼ ವಚನ್ನಿ ಬಾರೇಮ ಹರೇಕ್‍ನಾಬಿ ಮೆ ಮಾರ ಪಹಿಲ ಪುಸ್ತಕ್‌ಮ ಲೀಖಿರಾಖ್ಯೊಸ್. ");
INSERT INTO vaa_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","ಇನೆ ಪರಲೋಕ್‌ನ ಜಾ಼ವಾಲಗು ಇನು ಅಪೊಸ್ತಲರ‍್ನ ಚೂ಼ಣಾಯಹುಯ ಪವಿತ್ರಾತ್ಮನಿ ಶಕಥ್ಥಿ ಶಿಕಾಡ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","ಆ ಹೈರುತೆ ಯೊ ಮರಾನಿ ಬಾದ್‌ಮ ಚಾ಼ಲ್ಯುತೆ, ಇನೆ ಬಚಿನ್ ಆಯೋತೆ ಇನಿ ಬಾರೇಮ ಅಪೊಸ್ತಲರ‍್ನ ವತಾಳಿಲಿದೊ ಇನೆ ಜಿವೀನ್ ಉಠ್ಯೊತೆ ಘಣಿ ವಖ್ಹತ್‌ಲಗೂಬಿ ಕೈಏಕ್ ಜ಼ಣಾನ ದೆಖಾವ್ತೊರ‍್ಹಯೊ ದೇವ್ನಿ ರಾಜ್ಯನಿ ಬಾರೇಮ ಇವ್ಣಮ ಬೋಲ್ತೊರ‍್ಹಿಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","ಅಮ್ ರ‍್ಹವಾನಿ ವಖ್ಹ್‌ತೆ ಏಕ್‌ಬಾರ್ ಶಿಷ್ಯರ್‌ನಿ ಜೋ಼ಡ್ಮ ಖಾಣು ಖಾವನಿವಖ್ಹ್‌ತೆ ಇನೆ ಇವ್ಣುನ “ಮಾರೊ ಬಾ ಏಕ್‌ ಜಿಭಾನ್‌ ದಿರಾಖ್ಯೊಸ್ ಕರಿ ಅನಿ ಬಾರೇಮ ಪಹಿಲೇಸ್ ತುಮೂನ ಮೇ ಬೋಲಿರಾಖ್ಯುತೆ ಇನ ಖ್ಹಮ್‌ಜಿರಾಖ್ಯಥಾತೆ ಇಮ್‌ ಆ ವಾಗ್ದಾನ್ನಿ ವರ್‌ದಾನ್ ಲ್ಯವಾನಖ್ಹಾಜೆ ತುಮೆ ಯೆರೂಸಲೇಮ್ಮ ಟಿವೈರ‍್ಹೇಣುಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","ಯೋಹಾನನೆ ಅದ್ಮಿವೋನ ಪಾಣಿಥಿ ಬ್ಯಾಪ್ತಿಸ್ಮ ಕರಾಯೊ ಕತೋಬಿ ಬಿಜ಼ ಥೋಡಸ್ ದನ್ಮ ತುಮೂನ ಪವಿತ್ರಾತ್ಮಥಿಬಿ ಬ್ಯಾಪ್ತಿಸ್ಮ ಉಷೆ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","ಮಳಿರ‍್ಹುಥೂತೆ ಅಪೊಸ್ತಲರ್ ಖ್ಹಾರು, ಇವ್ಣೆ “ಪ್ರಭು, ತೂ ಇಸ್ರಾಯೇಲ್‌ ಅದ್ಮಿವೋನ ಹಮೇಶ ಪಾಛೊ಼ ಇವ್ಣಿ ರಾಜ್ಯನ ಆಸ್ ದನ್ಮ ದ್ಯವಾನ ಆಯೋಕಿ ಶು? ಕರಿ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","ಯೇಸು ಇವ್ಣುನ ಅಖ್ಖಿ ವಖ್ಹತ್‌ನ ರ‍್ಹವೊ ಹಗಾಮ್ನ ರ‍್ಹವೊ ಮಾಲುಮ್ ಕರಾನಿ ಅದಿಕಾರ್ ಬಾನ ಛಾ಼ ಪಣ್ಕಿ ಇನ ಮಾಲುಮ್ ಕರಾನು ಕಾಮ್ ತುಮಾರು ಕಾಹೆ. ");
INSERT INTO vaa_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","ಕತೋಬಿ ಪವಿತ್ರಾತ್ಮ ತುಮಾರಪರ್ ಆಯಿಗೋತೊ, ತುಮೆ ಶಕತ್‍ಲೀನ್ ಯೆರೂಸಲೇಮ್ಮಾಬಿ ಯೂದಾಯಮಬಿ, ಸಮಾರ್ಯ ತಬರ್‌ಖಾಮಾಬಿ ಅಜು಼ ಜಗತ್ನ ಕಡೆಷಿ ಲಗೂಬಿ ಮನ ಸಾಕ್ಷಿಹುಯಿರಿಶು. ");
INSERT INTO vaa_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","ಆ ವಾತೆ ಅಪೊಸ್ತಲರ‍್ನ ಬೋಲಿಹುಯಿಗು ತದೆ ಇವ್ಣೆ ದೇಖುಕರ್ತಥಾತೆ ತದೇಸ್‌ ಯೋ ಸೊರ್ಗಮ ಪಡೈಗಯೊ. ವಾದ್‌ಳು ಮೂಚಿನಾಖಿದಿದೂತೆ ಇನಖ್ಹಾಜೆ ಯೇಸುನ ಇವ್ಣೆ ದೆಖಾನ ಕೊಹುಯುನಿ. ");
INSERT INTO vaa_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","ಯೇಸು ಜಾ಼ವಾನಿವಖ್ಹ್‌ತೆ ಇನ ಇವ್ಣೆ ಆಬ್‌ನಾಸ್ ಠರ್‌ಕೈನ್ ದೇಖುಕರ್ತುಥು. ತದೆ, ಧೋಳು ಲುಂಗ್ಡು ಫೇರಹುಯ ಬೇಜ಼ಣ ಇನ ಭೀಡೆ ಭೀರಿನ್, ");
INSERT INTO vaa_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","ಗಲಿಲಾಯವಾಳ ಅದ್ಮಿವೊ, ತುಮೆ ಶನ ಆಸ್ಮಾನ್ನಾಸ್ ದೇಖುಕರಸ್? ತುಮಾರಕಂಥು ಯೇಸು ಕಿಮ್ ಪರ್‌ಲೋಕ್ನ ಛ಼ಡಿಗಯೊತೆ ತುಮೆ ದೇಖ್ಯಾಕಿ ಇಮ್ನಿ ಪರಕ್ಮಾಸ್ ಪಾಛು಼ ಆವ್‌ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","ಇನಕೇಡೆಥು ಅಪೊಸ್ತಲರ್ ಖ್ಹಾರು ಆಲಿವ್‌ನ ಟೇಕ್‍ಡಿ ಕಂಥು ಯೆರೂಸಲೇಮ್ನ ಪಾಛು಼ಗಯು. ಯೊ ಟೇಕ್‍ಡಿಥು ಯೋ ಖ್ಹಯೇರ್‌ಥು ಜಾ಼ಖ್ಹತ್ ಕತೊ ಆಧುಮೈಲ್ ದೂರ್ ಥು. ");
INSERT INTO vaa_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","ತದೆ ಇವ್ಣೆ ಖ್ಹಯೇರ್‌ಮ ಗಯ ಇವ್ಣೆಥೂತೆ ಘರ್‌ನ ಉಪ್ಲಿಬಾಜುಮ ಗಯ; ಇವ್ಣೆ ಕೋಣ್ ಕೋಣ್‌ಕತೊ, ಪೇತ್ರ, ಯೋಹಾನ. ಯಾಕೋಬ, ಅಂದ್ರೆಯ, ಫಿಲಿಪ್ಪ, ಅಜು಼ ತೋಮ, ಬಾರ್ತೊಲೊಮಾಯ, ಮತ್ತಾಯ, ಅಜು಼ ಅಲ್ಫಾಯನೊ ಛಿಯ್ಯೊ ಯಾಕೋಬ, ಜಾ಼ತ್ನೊಅಭಿಮಾನಿ ಕರಿ ಬೋಲೈಲಿದೋತೆ ಸೀಮೋನ ಅಜು಼ ಯಾಕೋಬನೊ ಛಿಯ್ಯೊ ಯೂದ ಇವ್ಣೆ ಖ್ಹಾರು ಹಿಜ್ಜಾ಼ ಥು. ");
INSERT INTO vaa_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","ಇವ್ಣೆ ಅಖ್ಖುಜ಼ಣು ಏಕ್‍ಮನ್‍ಥಿ ಎಕ್ಟುಹುಯಿನ್ ದೇವ್ನಿ ಪ್ರಾರ್ಥನೆಮ ಥು. ಹಿಜ್ಜಾ಼ ಥೋಡಿಜ಼ಣಿ ತಯೇಡಾಬಿ, ಯೇಸುನಿ ಆಯಾ ಮರಿಯಾಬಿ ಇನ ಭೈಯೇಬಿ ಅಪೊಸ್ತಲರ‍್ನಿ ಜೋ಼ಡ್ಮ ಥೂ. ");
INSERT INTO vaa_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","ಥೋಡದನ್ ಬಾದ್‌ಮ, ವಿಶ್ವಾಸಿಮ ಖ್ಹುಮಾರ್ ಏಕ್‌ಖ್ಹೊ ವೀಖ್ಹ್‌ ಜ಼ಣು ಸಭೆಮ ಮಳೀನ್‍ ಅಯಿರ‍್ಹವಾಮ, ಪೇತ್ರನೆ ಬೀಚ್ಮ ಉಠಿ ಭೀರಿನ್: ");
INSERT INTO vaa_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“ಭೈಯೇಭೇನೆವೊ, ಯೇಸುನ ಧರಿದ್ಯವಾಳನ ವಾಟ್‌ ವತಾಳ್ಯೊತೆ ಯೂದನಿ ಬಾರೇಮ ಪವಿತ್ರಾತ್ಮನೆ ದಾವೀದ್‍ಥಿ ಪವಿತ್ರ ಪುಸ್ತಕ್‌ಮ ಬೋಲೈರ‍್ಹುತೆ ವಾತೆ ಪೂರಹೋಣುಸ್‌ಪಡ್ಯುಥು, ");
INSERT INTO vaa_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","ಯೂದ ಅಪ್ಣುನ ಮಾಲುಮ್‌ರ‍್ಹಾವಳೊ ಹುಯಿರ‍್ಹೋಥೊ ಅಜು಼ ಸೇವೇನ ಚೂ಼ಣೈರ‍್ಹೋ ತೋಬಿ ಯೇಸುನ ಧರಿದ್ಯವಾಳನ ಯೂದನೆ ಮದತ್ ಕರ್ನುಥೂತೆ ಇನ ಪವಿತ್ರಾತ್ಮನೆ ಪಹಿಲೇಸ್ ದಾವಿದ್ನ ಮ್ಹೋಡೇಥಿ ಬೋಲಿರಾಖ್ಯೊಥೊ.” ");
INSERT INTO vaa_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","ಯೂದನೆ, “ಇನಿ ನೀಚ್‌ಕಾಮ್‍ಥಿ ಲಿದೋತೆ ಪೈಶಾಮ ಏಕ್‌ ಖೇತರ್‌ನ ಲೀಲಿದೊ ಥೊ. ಇನಮಾಸ್ ಇನ ಜಾನ್ನ ಕಳ್ಳಿದೊ. ಉಪ್ಪರ್ ಥು ಮುಡ್‌ಕ್ಯು ಹೇಟ್ ಹುಯಿನ್ ಪಡೀನ್, ಪೇಟ್ ಫುಟೀನ್, ಅತಲ್ಡಿ ಭಾರ್‌ ಅಯಿಗು. ");
INSERT INTO vaa_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","ಅನಿ ಬಾರೇಮ ಯೆರೂಸಲೇಮ್ನ ಖ್ಹಾರ ಅದ್ಮಿನ ಮಾಲುಮ್ ಪಡ್ಯು. ಯೊ ಜ಼ಮೀನ್ನ ಇವ್ಣಿ ಬೋಲಿಮ ‘ಅಕೆಲ್ದಾಮಾ’ ಕರಿ ನಾಮ್‌ಮ್ಹೇಲಾಯು. ‘ಅಕೆಲ್ದಾಮಾ, ಕತೊ ‘ಲ್ಹೋಯಿನು ಖೇತರ್‌’ ಕರಿ ನಾಮ್ ಆಯು. ");
INSERT INTO vaa_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","ಯೂದನಿ ಬಾರೇಮ ‘ಇನು ಘರ್‌ ಬರ್ಬಾತ್‌ ಹುವಾದೆ, ಯೋ ಅದ್ಮಿಕೊಂತೆ ಉಜ್ಜಾ಼ಡ್ ಹುವಾದೆ’ ಇನಿ ಅದಿಕಾರ್ ಬಿಜೇಕ್‍ಜ಼ಣಾನ ಜಾ಼ವಾದೆಕರೀಬಿ ಕೀರ್ತನೆ ಪುಸ್ತಕ್‌ಮ ಲೀಖೈರುಸ್. ");
INSERT INTO vaa_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","“ಇನಖ್ಹಾಜೆ ಅಲಕ್ ಏಕ್‍ಜ಼ಣೊ ಅಪ್ಣಿಜೋ಼ಡ್ಮ ಮಳಿನ್ ಪ್ರಭು ಯೇಸು ಮರೀನ್ ಜಿವ್‍ಯೊತೆ ಇನ ಸಾಕ್ಷಿಹುಯಿರೇಣು. ಎಥ್ರಾನವಾಳೊ ಯೇಸು ಫರೀನ್ ಸೇವೆಕರಾನಿ ಅಖ್ಖಿವಖ್ಹ್‌ತೆ ಅಪ್ಣ ಟೋಳ್‍ವಾಳಾಮ ರ‍್ಹವವಾಳೊ ಹುಯಿರೇಣು. ");
INSERT INTO vaa_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","ಇನಖ್ಹಾಜೆ ಬ್ಯಾಪ್ತಿಸ್ಮ ದ್ಯವಾಳೊ ಯೋಹಾನ ಬೋಧನೆ ಕರ‍್ಯೊತೆ ದನ್‌ಥು ಕತೊ ಯೋಹಾನ ಬ್ಯಾಪ್ತಿಸ್ಮ ಕರ‍್ಯೊತೆ ಹಿಜ್ಜಾ಼ಥು ಧರೀನ್ ಯೇಸು ಸೊರ್ಗಮ ಗಯೋತೆ ದನ್‍ಲಗೂಬಿ ಅಪ್ಣ ಜೋ಼ಡ್ಮ ರ‍್ಹವವಾಳೊ ಹುಯಿರೇಣು.” ಶನಕತೊ ಆ ವೇಳ್ಮ ರ‍್ಹವವಾಳೊ ಏಕ್ಜ಼ಣೊ ಯೇಸು ಪಾಛು಼ಜಿವ್ತೊಹುಯಿನ್ ಉಠ್ಯೊತೆ ಇನ ಸಾಕ್ಷಿಹುಯಿರೇಣು. ");
INSERT INTO vaa_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","ತದೆ ಬಾರ್ಸಬ ಕರಿ ನಾಮ್‍ವಾಳೊ ಯೋಸೇಫ್‌ನ ಯೂಸ್ತ ಕರೀಬಿ ಬೋಲ್ತುಥು. ಅಜು಼ ಬಿಜೇಕ್ ಜ಼ಣೊ ಮತ್ತೀಯ. ಆ ಬೇ ಜ಼ಣಾನ ಅಪೊಸ್ತಲರ‍್ನ ಸಭೆನ ಖ್ಹಾಮ್ಣೆ ಭೀರಾಖ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","ತದೆ ಇವ್ಣೆಅಮ್‍ ಪ್ರಾರ್ಥನೆ ಕರ‍್ಯುಕೀ, “ಪ್ರಭು, ತೂ ಅಖ್ಖಾನ ದಿಲ್‌ನೊಮಾಯಿನೊ ಮಾಲುಮ್ ಕರಿರಾಖ್ಯೊಸ್. ಆ ಬೇಜ಼ಣಾಮ ತೂ ಕಿನ ಚೂ಼ಣಿರಾಖ್ಯೊಸ್, ");
INSERT INTO vaa_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","ಯೂದನಿ ಝ಼ಗೋಮ ಅಪೊಸ್ತಲಹುಯಿನ್ ಸೇವೆಕರಾನ ಯೋ ಝ಼ಗೋನ ಮ್ಹೇಲಿನ್ ಕಿಜ್ಜಾ಼ ಇನಿ ಝ಼ಗೋಕಿ ಹಿಜ್ಜಾ಼ ಚ಼ಲೆಗಯೊ ");
INSERT INTO vaa_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","ತದೆ ಇವ್ಣಖ್ಹಾಜೆ ಚಿಟ್ಟಿನಾಖ್ಯು, ಇನಾಮ ಮತ್ತೀಯನು ನಾಮ್ ಪಡಾಯು.ತದೆ ಘ್ಯಾರಜ಼ಣ ಅಪೊಸ್ತಲರ‍್ನಿ ಜೋ಼ಡ್ಮಯೊ ಮಳಿಗೊ. ");
INSERT INTO vaa_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","ಪೆಂತಕೊಸ್ಟ್ ಪೂಜಾ಼ನ ದನ್ನೆ ಇವ್ಣೆ ಅಖ್ಖುಜ಼ಣು ಏಕ್‍ಝ಼ಗೊ ಮಳ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","ತದೆ ಜೊ಼ರೇಖ್ಹು ತುರಂತ್, ಅಪಟ್‌ಝ಼ಪಟ್‌ನೊ ವಹಿರೊ ವಾಗಾನಿಘೊಣಿ ಏಕ್‌ ಅವಾಜ಼್ ಆಬ್‍ಥು ಖ್ಹಮಜ್‍ಪಡ್ಯು. ಯೊ ಇವ್ಣೆ ಬೆಠಾಥಾತೆ ಘರ್ ಅಖ್ಖೂಸ್ ಭರಾಯು. ");
INSERT INTO vaa_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","ಅಜು಼ ಇವ್ಣಿ ಜೀಬ್‍ ಆಗ್‍ನಿ ಝ಼ಲ್‌ಪಟ್‍ನಿತರ ದೆಖಾಯು. ಯೊ ಅಖ್ಖು ಅಲಕ್ ಅಲಕ್‌ಹುಯಿನ್ ಹರೇಕ್ನ ಉಪ್ಪರ್‌ಬಿ ಆಯು. ");
INSERT INTO vaa_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","ಇವ್ಣೆಅಖ್ಖು ಪವಿತ್ರಾತ್ಮಥಿ ಭರೈನ್ ಅಲಕ್ ಅಲಕ್ ಬೋಲಿಮ ವಾತೆಬೋಲಲಗ್ಯು. ಪವಿತ್ರಾತ್ಮಸ್ ಇವ್ಣುನ ಆ ಶಕತ್ನ ದಿದೊ, ");
INSERT INTO vaa_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","ತದೆ ಜಗತ್ನು ಅಖ್ಖಿ ಬಾಜು಼ಥು ಆಯುಹುಯು ಕೈಏಕ್ ಜ಼ಣು ಭಕ್ತ ಯೆಹೂದ್ಯರ್ ಖ್ಹಾರು, ಯೊ ವೇಳ್ಮ ಯೆರೂಸಲೇಮ್ಮ ಥೂ. ");
INSERT INTO vaa_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","ಯೊ ಅವಾಜ಼್‌ನ ಖ್ಹಮ್‍ಜ್ಯುತೆ ಅದ್ಮಿವ್‌ನು ಮೋಟು ಝೂ಼ಂಡ್‌ ಹಿಜ಼್ಜ ಭರೈನ್ ಆಯು. ಅಜು಼ ಇವ್ಣಿ ಇವ್ಣಿ ಶೊಂತ್ ಬೋಲಿಮ ವಾತೆ ಬೋಲಾನು ಖ್ಹಮ್‌ಜಿನ್‌ ಆಶ್ಚರ್ಯಕರ‍್ಯು. ");
INSERT INTO vaa_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","ಇವ್ಣೆಅಖ್ಖು ಆಶ್ಚರ್ಯ ಹುಯಿನ್ “ಅಮ್ ವಾತೆ ಬೋಲುಕರಾತೆ ಅವ್ಣೆ ಖ್ಹಾರು ಗಲಿಲಾಯವಾಳು ಕಾಹೆಕಿ ಶು? ");
INSERT INTO vaa_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","ಹಮೆ ಅಲಕ್ ಅಲಕ್ ಝ಼ಗೋವಾಳ ಕತೋಬಿ ಅವ್ಣೆ ಅಪ್ಣಿ ಅಪ್ಣಿ ಬೋಲಿಮಾಸ್ ಬೋಲುಕರಾತೆ ಕಿಮ್? ");
INSERT INTO vaa_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","ಅಪ್ಣಾಮ ಪಾರ್ದಿವಾಳು, ಮೇದ್ಯವಾಳು, ಎಲಾಮ್ಯವಾಳು, ಮೆಸಪಟೋಮಿಯವಾಳು, ಯೂದಾಯಬಿ ಅಜು಼ ಕಪ್ಪದೋಕ್ಯವಾಳೂಬಿ ಛಾ಼. ಪೊಂತ ಅಜು಼ ಏಷ್ಯಾವಾಳುಬಿ, ");
INSERT INTO vaa_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","ಫ್ರಿಜಿಯ ಅಜು಼ ಪಂಫುಲ್ಯವಾಳೂಬಿ ಛಾ಼. ಈಜಿಪ್ಟ್ ಅಜು಼ ಸಿರೇನಿನ ಖನ್ನೆವಾಳು ಅಜು಼ ಲಿಬಿಯನು ತಬರ್‌ಖವಾಳೂಬಿ ಮಳಿರ‍್ಹೂಸ್‌. ಯೊ ಕೊಂತೆ ಅಪ್ಣಾಮ ಥೋಡುಜ಼ಣು ರೋಮ್‍ವಾಳೂಬಿ ಐರ‍್ಹೂಸ್, ");
INSERT INTO vaa_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","ಯೆಹೂದ್ಯರ್‌ಬಿನ್ ಯೆಹೂದ್ಯರ್‌ಕಾಹೆತೆ ಧರ್ಮ್‍ನ ಪಾಲನ್‍ಕರಾವಳು ಥೋಡು ಅದ್ಮಿಖ್ಹಾರು, ಕ್ರೇಟ್ ಅಜು಼ ಅರೇಬಿಯವಾಳೂಬಿ ಹಜ಼್ಜ ಛಾ಼. ಅಪ್ಣೆಖ್ಹಾರು ದೇವ್ನಿ ಮಹಾನ್ ಕಾಮ್ನಿ ಬಾರೇಮ ಬೋಲುಕರಸ್ತೆ ಯೊಅಖ್ಖು ಅಪ್ಣಿ ಅಪ್ಣಿ ಬೋಲೀಮ ಖ್ಹಮ್‍ಜು಼ ಕರಿಯೇಸ್‌ನಿ ಕರಿ ಆಶ್ಚರ್ಯ ಕರ‍್ಯು. ");
INSERT INTO vaa_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","ಅದ್ಮಿಖ್ಹಾರು ಆಶ್ಚರ್ಯ ಹುಯಿನ್, ಕಲಾವ್ಣಿಹುಯಿನ್ ಆ ಶಾತ್ ರ‍್ಹೇವ್ಣು ಕರಿ ಏಕ್‌ಥಿ ಏಕ್‌ ಬೋಲಲಗ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","ಥೋಡುಜ಼ಣು ಅಪೊಸ್ತಲರ‍್ನ ದೇಖಿನ್, “ಅವ್ಣೆ ಜಾ಼ಖ್ಹತ್ ಪೀಲಿನ್ ಕಯೇಪ್ ಛ಼ಡೀಗಿ” ಕರಿ ನಕ್ಲೆ ಕಾಡ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","ತದೆ ಪೇತ್ರನೆ ಜೋ಼ಡ್ಮಥಾತೆ ಗ್ಯಾರ‍್ಹಜ಼ಣ ಅಪೊಸ್ತಲರ‍್ನಿ ಜೋ಼ಡ್ಮ ಉಠಿಭೀರಿನ್, ಅದ್ಮಿನ ಟೋಳ್ನ ಊಚಿ ಆವಾಜ಼್‌ಥಿ ಅಮ್‍ ಬೋಲ್ಯೊಕಿ, “ಯೆಹೂದ್ಯವಾಳವೊ, ಯೆರೂಸಲೇಮ್ನ ಖ್ಹಾರ ಅದ್ಮಿವೊ, ಮಾರಿ ವಾತ್ನ ಖ್ಹಮ್‍ಜೊ, ತುಮೆ ಮಾಲುಮ್ ಕರಿಲೇವ್ಣುತೆ ವಾತೆ ಕಾನ್‌ ಲಗಾಡಿ ಖ್ಹಮಜ಼್‌ಣುಕರಿ ಮೇ ತುಮೂನ ಬೋಲುಸ್. ");
INSERT INTO vaa_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","ತುಮೆ ಲಾಝಿರ‍್ಯಾಖ್ಯತೆ ತಿಮ್ ಅವ್ಣೆಖ್ಹಾರು ಕಯೇಪ್ ಛ಼ಡೈಲಿದುಕಾಹೆ” ಹಮ್ಕೆ ಬಿಜೂ಼ಬಿ ವ್ಹಾಣಾನ ನೌ ಘಂಟಾ ಹುಯಿರಾಸ್ ಎತ್ರೇಸ್. ");
INSERT INTO vaa_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","ಕತೋಬಿ ಹಮ್ಕೆ ಚಾ಼ಲುಕರಾತೆ ಹಾಲತ್‌ನಿ ಬಾರೇಮ ಪ್ರವಾದಿ ಯೋವೇಲನೆ ಅಮ್‍ ಲೀಖಿರಾಖ್ಯೊಸ್; ");
INSERT INTO vaa_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","ದೇವ್ನೆ ಅಮ್‍ ಬೋಲ್ಯೊಕಿ, ‘ಖ್ಹರ್ತಿನ ದನ್ಮ ಖ್ಹಾರ ಅದ್ಮಿಪರ್, ಮಾರಿ ಆತ್ಮಾನ ಖ್ಹಾರ ಅದ್ಮಿವೋನ ಉಪ್ಪರ್ ರಂಚೀಶ್, ತುಮಾರ ತಯೇಡ ಪರ್ಖ್ಹಾ ಪ್ರವಾದ್‌ನೆ ಕರ್ಶೆ; ತುಮಾರ ಜಾ಼ನ್ಜ಼ಮಾನ್ ಖ್ಹಾರು ದರ್ಶನ್ ದೇಕ್‌ಶೆ; ಅಜು಼ ತುಮಾರು ಗಲ್‌ಢಖ್ಹಾರು ಖ್ಹೋಣ್ಯಮ ದೇಕ್‌ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","ಯೊ ದನ್ಮ ಮಾರ ಆತ್ಮಾನ ಮಾರ ದಾಸದಾಸಿನ ಉಪ್ಪರ್ ರಂಚೈ಼ಶ್. ತದೆ ಇವ್ಣೇಬಿ ಪ್ರವಾದ್‌ನೆ ಕರ್ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","ಪ್ರಭುನ ಆವಾನೊ ಮೋಟ ದನ್ ಆವಾನ ಅಗಾಡಿ ಆಬ್‌ನ ಉಪ್ಪರ್ ಅದ್ಭುತ್‌ಕಾಮ್ನ ವತಾಳಿಶ್. ಧರ್ತಿನ ಉಪ್ಪರ್ ಖ್ಹಣೇದ್ನಕಾಮ್ನ ಕರಿಶ್. ತದೆ ಲ್ಹೋಯಿ, ಆಗ್ ಅಜು಼ ಬಾಪ್ನಿತರ ಛ಼ಡಾನೊ ಧುವ್ವೊ ರ‍್ಹಿಶೆ. ");
INSERT INTO vaa_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","ಚಾ಼ಂದ್ ಅಂಧಾರ್‌ಗಡಪ್ ಬಣ್‍ಶೆ, ಚ಼ಂದರ್‌ಮೊ ಲ್ಹೋಯಿನಿತರ ಲಲೇಲಾಲ್ ಉಷೆ. ತದೆ ಪ್ರಭುನೊ ಮಹಾ ಮಹಿಮೆನೊ ದನ್ ಆವ್‌ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","ಕತೋಬಿ, ಕೋಣ್‌ ಪ್ರಭುನು ನಾಮ್ನ ಬೋಲಸ್ಕಿ ಯೊ ಹರೇಕ್‍ನಾಬಿ ರಕ್ಷಣೆ ಉಶೆ, ಕರಿ ದೇವ್ ಬೋಲುಕರಸ್. ");
INSERT INTO vaa_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“ಇಸ್ರಾಯೇಲ್ ಅದ್ಮಿವೊ, ಮಾರಿ ವಾತ್ನ ಖ್ಹಮ್‍ಜೊ; ನಜ಼ರೇತ್‌ನೊ ಯೇಸು ಛಾ಼ನಿ ದೇವ್ ತುಮುನಾಬಿ ಮಾಲುಮ್‌ ರ‍್ಹವಾನಿತರ ದೇವ್ನೆಸ್ ಇನೇಥಿ ಚ಼ಲಾಯೊತೆ ಮಹಾ ಕಾಮ್‍ಬಿ, ಅದ್ಭುತ್‌ಕಾಮ್‍ಥಿ ಇನ ಪಸಂದ್ ಹುವಾನಿತರ ತುಮೂನ ವತಾಳಿ ದಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","ಯೊ ಯೇಸುಸ್ ದೇವ್ನಿ ಘಟ್ ಖ್ಹೂಜ಼್‌ಥೀಬಿ, ಆವ್‌ಶೇತೆ ಹಗಾಮ್ನಿ ಪರಕ್ಮ ದೆವೈಜಾ಼ವದಿನ್, ತುಮೆ ಅಲಕ್ಅದ್ಮಿವೋನ ದೀನ್ ಶಿಲ್‌ಬೇಪರ್ ಮೇಕ್ ಮರೈನ್ ಮಾರಿನಾಖ್ಯ. ");
INSERT INTO vaa_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","ಯೇಸುನ ದೇವ್ನೆ ಮರಣ್ಣಿ ಖ್ಹತಾಪ್ಣಿಥಿ ಛೋ಼ಡೈನ್ ಉಠಾಡ್ಯೊ. ಶನಕತೊ ಮರಣ್ ಇನ ಧರಿಲ್ಯವಾನ ಕೊ ಹುಯುನಿ. ");
INSERT INTO vaa_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","ಯೇಸುನಿ ಬಾರೇಮ ದಾವೀದನೆ ಅಮ್ ಬೋಲಿರಾಖ್ಯೊಸ್ಕಿ, ‘ಪ್ರಭುತೊ ಕದೇಬಿ ಮಾರ ಖ್ಹಾಮ್ಣೆ ರ‍್ಹವಾನು ಮೆ ದೆಕ್ತೊಥೊ: ಮೇ ಖ್ಹಳಕ್ಣುನಾತೆ ತಿಮ್ ಯೊ ಮಾರ ಖಾವಿ ಬಾಜು಼ಮಾಸ್ ಛಾ಼. ");
INSERT INTO vaa_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","ಇನಖ್ಹಾಜೆ ಮಾರೊ ದಿಲ್‌ ಘಣು ಖುಷಿಕರಸ್. ಮಾರಿ ಜೀಬ್ ಖುಷಿನು ವಾತೆಬೋಲಸ್. ಮಾರು ಶರೀರ್‌ಬಿ ಭರೋಖ್ಹಾಥಿ ಟಿವೈರ‍್ಹುಸ್. ");
INSERT INTO vaa_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","ಶನಕತೊ ತೂ ಮಾರ ಜಾನ್ನಆತ್ಮನ ಪಾತಾಳ್ಮ ಮ್ಹೇಲಿಶ್ ಕೊಯ್ನಿ. ತಾರ ಪ್ಯಾರ್‌ನ ಅದ್ಮಿನ ಪಾತಾಳ್ಮ ಖ್ಹಡ್ವಾನ ಮ್ಹೇಲಿಶ್‍ಕೊಯ್ನಿ. ");
INSERT INTO vaa_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","ತಾರ ಜಾನ್ನೊ ಮಾರಗ್‌ ಮನ ಖ್ಹಮ್‍ಜಾ಼ಡಿರಾಖ್ಯೊಸ್. ತಾರ ಖ್ಹಾಮೆ ಮನ ಭರ್‌ಪೂರ್‌ ಖುಷಿಕರೈಷ್’ ಕರಿ ಬೋಲಿರಾಖ್ಯೊಸ್. ");
INSERT INTO vaa_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","‘ಮಾರಾ ಭೇನೆ ಭೈಯೇವೊ ಅಪ್ಣೊ ಗುರುಗುರಬ್‌ಲ್ಯೊ ದಾವೀದ್‍ನಿ ಬಾರೇಮ ಮೆ ತುಮೂನ ಭಾಲಿಥಿ ಬೋಲೆಜಾ಼ಯ್ ಶಾತ್‌ಕತೊ, ಯೊ ಮರಿನ್‌ ಮಖ್ಹಾಣ್ಯು ಹುಯೊ, ಇನು ಮಖ್ಹಾಣ್ಯು ಹಮ್ಕೆಲಗೂಬಿ ಅಪ್ಣ ಇಚ಼್‌ಮ ಛಾ಼. ");
INSERT INTO vaa_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","ದಾವೀದ್ ಏಕ್‌ ಪ್ರವಾದಿಹುಯಿರಿನ್ ತಾರಿ ಪಿಳ್‌ಗೀಮ ಏಕ್‍ಜ಼ಣಾನ ತಾರಿ ಸಿಂಹಾಸನ್‌ಪರ್ ಬೆಖ್ಹಾಡಿಶ್. ಕರಿ ಇನ ದೇವ್ನೆ ಆಣ್‍ಕರಿನ್ ಬೋಲ್ಯೊತೆಯಿನ ಮಾಲುಮ್‌ಕರಿರಾಖ್ಯೊಥೊ ");
INSERT INTO vaa_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","ಯೊ ಹುವಾನ ಅಗಾಡಿಸ್ ದಾವೀದನ ಮಾಲುಮ್‌ಥು. ಇನಖ್ಹಾಜೇಸ್ ದಾವೀದನೆ, ಮರೀನ್ ಜಿವ್ತೊಉಷೇತೆ ಕ್ರಿಸ್ತನಿ ಬಾರೇಮ ಅಮ್ ಬೋಲ್ಯೋಕಿ, ‘ಇನ ಪಾತಾಳ್ಮ ಮ್ಹೆಲಾವನ ಕೊ ಹುಯುನಿ, ಇನಿ ಶರೀರ್ ಖ್ಹಡ್ವಾನ ಮ್ಹೇಲಿಶ್‍ಕೊಯ್ನಿ’ ಕರೀಬಿ ಬೋಲಿರಾಖ್ಯೊಸ್. ");
INSERT INTO vaa_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","ಇನಖ್ಹಾಜೆ ದೇವ್ನೆ ಮರ‍್ಯಹುಯಾಮ ಜಿವ್ತೊಕರಿನ್ ಮ್ಹೇಲ್ಯೊತೆ ಯೇಸುನಾಸ್, ಇನ ಹಮೆಅಖ್ಖು ಸಾಕ್ಷಿ ಹುಯಿರಾಸ್. ");
INSERT INTO vaa_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","ಯೇಸು ಸೊರ್ಗನ ಪಡೈಗೊ. ಹಮ್ಕೆ ಯೇಸು ದೇವ್ನಿ ಜೋ಼ಡ್ಮ ಛಾ಼. ದೇವ್ನಿ ಖಾವಿ ಬಾಜು಼ಮ ಛಾ಼. ಹಮ್ಕೆ ಬಾ ಹುಯಿರೋತೆ ದೇವ್ ಪವಿತ್ರಾತ್ಮನ ಯೇಸುನ ದೀರಾಖ್ಯೊಸ್. ಪವಿತ್ರಾತ್ಮನ ದೇವುಸ್ ಕರಿ ದೇವ್ನೆ ವಾಗ್ದಾನ್ ಕರಿರಾಖ್ಯೊಥೊ. ಇನಖ್ಹಾಜೆ ಯೇಸು ಹಮ್ಕೆ ಯೊ ಪವಿತ್ರಾತ್ಮನ ರಂಚಿರಾಖ್ಯೊಸ್. ತುಮೆ ದೇಖುಕರಾತೆ ಅಜು಼ ಖ್ಹಮ್‌ಜು಼ಕರಾತೆ ಅನಾಸ್. ");
INSERT INTO vaa_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","35","ಸೊರ್ಗಾನ ಪಡೈಗಯೊತೆ ದಾವೀದ್ ಕಾಹೆ, ಯೊ ಯೇಸುಸ್. ದಾವೀದ್ ಇನಿ ಬಾರೇಮ ಅಮ್ ಬೋಲಸ್. ‘ಮೆ ತಾರ ವಹೇರ‍್ಯಾನ ತಾರ ಗೋಡಾನೊ ರಚ್ಚೊ಼ ಬಣಾವಲಗು ಮಾರಿ ಖಾವಿಬಾಜು಼ ಬೆಠೋರೆ’ ಕರಿ ಪ್ರಭುನೆ ಮಾರ ಮಾಲಿಕ್‌ನ ಬೋಲಿರಾಖ್ಯೊಸ್. ");
INSERT INTO vaa_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","ಇನಖ್ಹಾಜೆ ತುಮೆ ಶಿಲ್‌ಬೆಪರ್ ಛ಼ಡಾಯತೆ ಆ ಯೇಸುನಾಸ್ ದೇವ್ನೆ ಪ್ರಭುಕರೀಬಿ ಕ್ರಿಸ್ತಕರೀಬಿ ಹುಯಿರೊಸ್ ಕರಿ ಇಸ್ರಾಯೇಲ್‌ನ ಖುಮ್‍ವಾಳ ಅಖ್ಖಾನ ಮಾಲುಮ್ ಹುಯಿರ‍್ಹವಾದೆ ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","ಅನ ಖ್ಹಮ್‍ಜ್ಯುತೆ ಇವ್ಣುನ, ದಿಲ್ಮ ಖ್ಹುಯಿ ಟೋಚಾ಼ವನಿಘೊಣಿ ಹುಯು. ಇವ್ಣೆ ಪೇತ್ರನ ಅಜು಼ ಉಭ್‌ರ‍್ಯಾತೆ ಅಪೊಸ್ತಲರ‍್ನ, “ಭೈಯೇವೊ ಹಮ್ಕೆ ಹಮೆ‌ ಶಾತ್‍ಕರ್ನು?” ಕರಿ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","ಪೇತ್ರನೆ ಇವ್ಣುನ ತುಮಾರಮ ಹರೇಕ್‍ಜ಼ಣುಬಿ ತುಮಾರ ಪಾಪ್ನಖ್ಹಾಜೆ ಪಶ್ಚತ್ತಾಪ್ ಕರೀನ್ ದೇವ್‌ಭಣಿ ಫರಿನ್ ಯೇಸು ಕ್ರಿಸ್ತನ ನಾಮ್‍ಪರ್ ಬ್ಯಾಪ್ತಿಸ್ಮ ಲೇವೊ. ತದೆ ದೇವ್ ತುಮಾರಿ ಪಾಪ್ನ ಅಖ್ಖು ಕ್ಷಮಾ ಕರ್ಶೆ, ತದೆ ತುಮೆ ಪವಿತ್ರಾತ್ಮ ದಾನ್ನ ಲೀಲಿಶು. ");
INSERT INTO vaa_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","ಆ ವಾಗ್ದಾನ್ ತುಮೂನಾಬಿ ತುಮಾರ ಲಡ್ಕಾವ್‍ನಾಬಿ ಘಣ ದೂರ‍್ಮಛಾ಼ತೆ ಅದ್ಮಿವೊನಾಬಿ ದೆವೈರ‍್ಹೂಸ್. ಅಪ್ಣೊ ದೇವ್ ಹುಯಿರೋತೆ ಪ್ರಭು ಇನಕನ ಖುಷಿ ಲ್ಯವಾಳ ಹರೇಕ್ ಜ಼ಣಾನಾಬಿ ಆ ವಾಗ್ದಾನ ದೀರಾಖ್ಯೊಸ್ ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","ಪೇತ್ರನೆ ಅಜೂ಼ಬಿ ಕೈಏಕ್ ವಾಥ್ಥಿ ಖ್ಹಮ್‌ಜಾ಼ಡ್ತೊ ಹುಯಿನ್, “ಆ ಖರಾಬ್ ಪಿಳ್ಗಿವಾಳಥಿ ತುಮೂನ ಬಚಾ಼ಡಿಲೆವೊ” ಕರಿ ಝೇತಾಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","ಇನೆ ಬೋಲ್ಯೊತೆ ಖ್ಹಮ್‌ಜಿನ್‌ ಬ್ಯಾಪ್ತಿಸ್ಮ ಲೀಲಿದು. ಯೋ ದನ್ ಕಮ್‍ಶಿಕಮ್ ತೀನ್ ಹಜಾ಼ರ್ ಅದ್ಮಿಖ್ಹಾರು ವಿಶ್ವಾಸಿನ ಟೋಳ್ಮ ಮಳೀಗು. ");
INSERT INTO vaa_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","ಯೊ ಅದ್ಮಿಖ್ಹಾರು ಅಪೊಸ್ತಲರ‍್ನಿ ಉಪದೇಶ್‍ನ ಖ್ಹಮ್‍ಜಾ಼ಮಾಬಿ, ಭೈಯೇ಼ಮ ಮಳಿನ್ ರ‍್ಹವಾಮಾಬಿ, ಖಾಣು ಖಾವಮಾಬಿ, ಪ್ರಾರ್ಥನೆ ಕರಾಮಾಬಿ ಜೋ಼ಡ್ಮ ಅವ್ಣೆ ಮಳಿನ್ ಕರ್ತುಥು. ");
INSERT INTO vaa_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","ಅಪೊಸ್ತಲರ್ ಅಖ್ಖು ಕೈಏಕ್ ಶಕತ್ನುಬಿ ಅಜು಼ ಅದ್ಭುತ್‌ಕಾಮ್ನ ಕರ್ತುಥು. ಅಜು಼ ಹರೇಕ್ ಜ಼ಣಾನಾಬಿ ದೇವ್ನಿ ಡರ್‌ ಭಕ್ತಿ ಆಯು. ");
INSERT INTO vaa_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","ವಿಶ್ವಾಸ್‌ ಕರವಾಳು ಖ್ಹಾರು ಒಗ್ಗಟ್‌ಹುಯಿನ್ ಜಿವ್ಣು ಕರ್ತುಥು. ಇವ್ಣಾಮಥೂತೆ ಹರೇಕ್ ಚೀಜ಼್‌ನಾಬಿ ವಾಟಪಾಡಿಲ್ಯಾವಳು ಹುಯಿರುಥು. ");
INSERT INTO vaa_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","ಇವ್ಣಿ ಜ಼ಮೀನ್ನ ಅಜು಼ ಇವ್ಣಕನ ಥೂತೆ ಶೊತ್ನ ವೇಚಿನ್ ಮಳಾತೆ ಪೈಶಾನ ಜ಼ರೂರತ್ ರ‍್ಹವಳಾನ ವಾಟಪಾಡಿ ದೇತೂಥು. ");
INSERT INTO vaa_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","ಇವ್ಣೆ ಹರೇಕ್ ದನ್ ಏಕ್‍ದಿಲ್‍ಥಿ ದೇವ್ನಿ ಮಂದಿರ್‌ಮ ಮಳಿನ್ ಆವ್ತುಹುಯಿನ್, ಇವ್ಣೆ ಇವ್ಣ ಘರ್‌ಮ ರೋಟೊ ತೋಡಿನ್ ಒಟ್‍ಥಿ ಖಾಣು ಖಾತೂಥು. ಇವ್ಣೊ ದಿಲ್‌ ಖುಷಿಥಿ ಭರೈರ‍್ಹೆತೂಥು. ");
INSERT INTO vaa_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","ಇವ್ಣೆ ದೇವ್ನ ಖ್ಹರವ್‌ಕರ್ತೂಥು. ಅಜು಼ ಅದ್ಮಿಖ್ಹಾರಾನು ದಯಾನ ಲಿಲ್ಯಾವವಾಳ ಹುಯಿರ‍್ಹಾಥ. ಹರೇಕ್ ದನ್‍ಬಿ ಘಣು ಘಣು ಅದ್ಮಿಖ್ಹಾರು ರಕ್ಷಣೆ ಲೇವ್‍ಕರ್ತೂಥು. ಪ್ರಭುನೆ ಇವ್ಣುನ ಅಖ್ಖಾನ ವಿಶ್ವಾಸಿನಿ ಸಭೆಮ ಮಳವ಼್ ಕರ್ತೊಥೊ. ");
INSERT INTO vaa_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","ಏಕ್‍ದನ್ ಪೇತ್ರಬಿ ಯೋಹಾನ ಧೊಪಾರ‍್ನ ತೀನ್ ಘಂಟಾನ ಚಾ಼ಲ್ತಿಥೀತೆ ಪ್ರಾರ್ಥನೆನಖ್ಹಾಜೆ ದೇವ್ನಿಮಂದಿರ್‌ನ ಗಯ. ");
INSERT INTO vaa_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","ಪೈದಾಖ್ಹ್‌ ಥಿ ಲಂಗ್ಡೊ ಥೋತೆ ಏಕ್ಅದ್ಮಿನ ಕೋಣಸ್ಕಿ ಥೋಡುಜ಼ಣು ಢೊಯಿಲಿನ್ ಅಯಿನ್; ದೇವ್ನಿಮಂದಿರ್‌ನ ಮಹಿ ಜಾ಼ವಾಳಕನ ಧರಮ್ ಮಾಂಗಾನಖ್ಹಾಜೆ ಇನ ‘ಶನ್‍ಗಾರ‍್ನು ದರ‍್ವಾಜು಼ ಕರಿ ಬೋಲೈಲೇತೆ‍ ಬಾಕಲ್‍ಕನ ಹರ್‌ದನ್‌ ಬೆಖ್ಹಾಡ್‍ತೂಥು. ");
INSERT INTO vaa_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","ಇನೆ ದೇವ್ನಿಮಂದಿರ್‌ನ ಮಹಿ ಒಳೆಜಾ಼ಯ್ತೆ ಪೇತ್ರನ ಅಜು಼ ಯೋಹಾನನ ದೇಖಿನ್ ಧರಮ್ ದ್ಯವಾನ ಗಿಂಗಾಯು. ");
INSERT INTO vaa_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","ಪೇತ್ರ ಯೋಹಾನ ಭೇಜ಼ಣ ಠರ್‌ಕೈನ್ ದೇಖ್ಯ. ಪೇತ್ರನೆ ಇನ “ಹಮೂನ ದೇಕ್!” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","ಯೋ ಲಂಗ್ಡೊ ಇವ್ಣೇಥಿ ಶಾತ್‍ತೋಬಿ ಮಳ್‍ಶೆಕಿ ಶುಕಿ ಕರಿ ಖ್ಹಯಾಲ್ ಕರೀನ್ ಇವ್ಣಭಣಿ ದೇಖ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","ತದೆ ಪೇತ್ರನೆ, ಪೈಶ ಖ್ಹೊನ್ನು ಮಾರಕನ ಕೊಯ್ನಿ, ಕತೋಬಿ ಮಾರಕನ ಛಾ಼ತೆ ಯೊ ತುನ ದೆವುಸ್. ನಜ಼ರೇತ್ನ ಯೇಸುಕ್ರಿಸ್ತನ ನಾಮ್‍ಥೀಸ್ ಉಠೀನ್ ಚಾ಼ಲ್‍ಕರಿ ಬೋಲಿನ್, ");
INSERT INTO vaa_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","ಇನೊ ಖಾವೊ ಹಾತ್‍ ಧರೀನ್ ಉಠಾಡ್ಯೊ. ತದ್‌ನು ತದೇಸ್‌ ಇನ ಪಕ್ತೇಳಿಮಾಬಿ, ಪಂಜ಼ವ್‍ಮಾಬಿ,ಏಡಿಮಾಬಿ ಶಕತ್ ಆಯು. ");
INSERT INTO vaa_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","ಯೊ ಉಠೀನ್ ಭೀರಿನ್‌ ಗೋಡೆಥಿ ಚಾ಼ಲಾಲಗ್ಯೊ; ಯೊ ಚಾ಼ಲ್ತೊ ಖೇಲ್ತೊ ದೇವ್ನ ಖ್ಹರಾವ್‌ತೊಹುಯಿನ್ ಇವ್ಣಿಜೋ಼ಡ್ಮ ದೇವ್ನಿಮಂದಿರ್‌ನ ಮಹಿ ಗಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","ಯೋ ಚಾ಼ಲ್ತೊಹುಯಿನ್‌ ದೇವ್ನ ಖ್ಹರಾವ್‌ತೊ ವಳ್ಯಾವಾತೆ ಅದ್ಮಿಖ್ಹಾರಾನೆ ದೇಖ್ಯು; ");
INSERT INTO vaa_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","ಆ ಹೈರುತೆ ಮಂದಿರ‍್ನ ಶನ್‍ಗಾರ‍್ನು ದರ‍್ವಾಜು಼ ಕರಿ ಬಾಕಲ್‍ಕನ ಬೇಶಿನ್ ಧರಮ್ ಮಾಂಗ್‌ತೊಥೋತೆ ಆಸ್ ಕರಿ ಖ್ಹಣೇದ್ ಕರ‍್ಯು. ಯೋಸ್ ಅದ್ಮಿ ಚಾ಼ಲೀನ್ ದೇವ್ನ ಖ್ಹರಾವನು ದೇಖಿನ್ ಘಣು ಆಶ್ಚರ್ಯ ಕರ‍್ಯು. ");
INSERT INTO vaa_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","ಅಛ್ಛು಼ ಹುಯುತೆ ಲಂಗ್‍ಡಾನೆ ಪೇತ್ರ ಬಿಜು಼ ಯೋಹಾನನ ಜೋ಼ಡ್ಮ ಒಳೆಜಾ಼ಯ್ತೆ ತದೆ, ಆಶ್ಚರ್ಯ ಕರುಕರ್ತುಥೂತೆ ಅದ್ಮಿಖ್ಹಾರು ಸೊಲೊಮೋನ್ ಕರಿ ನಾಮ್ನ ಛ಼ತ್‌ಕನ ಎಕ್ಟು ಹುಯಿನ್ ನಾಶಿಆಯು. ");
INSERT INTO vaa_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","ಪೇತ್ರ ಅನ ದೇಖಿನ್, ಯೋ ಅದ್ಮಿಖ್ಹಾರಾನ; ಇಸ್ರಾಯೇಲ್‌ವಾಳವೊ, ಅನ ದೇಖಿನ್ ಶನ ಆಶ್ಚರ್ಯ ಹುಯಿರಾಸ್? ತುಮೆ ಹಮೂನ ಶನ ಅಮ್ ದೇಖುಕರಸ್? ಹಮೆ ಹಮಾರಿ ಶೊಂತ್ ಶಕಥ್ಥಿ ರ‍್ಹವೊ, ಹಮಾರಿ ದೇವ್ನಿ ಭಕ್ತಿಥಿ ರ‍್ಹವೊ ಅನ ಚಾ಼ಲ್ವಾನಿತರ ಕರ‍್ಯಕರಿ ನಕೊ ಲಾಝ಼್‌ಶು? ");
INSERT INTO vaa_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","ಅಪ್ಣೊ ಗುರುಗುರಬ್‌ಲ್ಯ ಹುಯಿರೋತೆ ಅಬ್ರಹಾಮ್ ಇಸಾಕ್ ಯಾಕೋಬನೊ ದೇವ್‌ ಅಜು಼ ಅಪ್ಣೊ ಗುರುಗುರಬ್‌ಲ್ಯನೊ ದೇವ್ ಇನೊ ದಾಸಹುಯಿರ‍್ಹೊತೆ ಯೇಸುನ ಮಹಿಮೆ ಕರಿರಾಖ್ಯೊಸ್. ಕತೋಬಿ ತುಮೆ ಇನ ಪಿಲಾತನ ಹಾತ್ಮ ಮಾರನ ಧರಿನ್‍ ದಿದಾ; ಬಿಜು಼ ಪಿಲಾತನೆ ಇನ ಛೋ಼ಡಾವ್ಣು ಕರಿ ಖ್ಹೂಜ಼್‌ ಕರಾದಿನ್, ಇನಖ್ಹಾಮ್ಣೆ ತುಮೆ ಯೇಸು ಹೋಣುಕೊಯ್ನಿ ಕರಿ ಬೋಲ್ಯ. ");
INSERT INTO vaa_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","ತುಮೆ ಪರಿಶುದ್ಧಬಿ ನೀತಿನೊ ಹುಯಿರೋತೆ ಯೇಸುನ ನಕೊ ಕರಿ ಬೋಲ್ಯ. ಇನಬದಲ್ ಹತ್ಯಾರ ಏಕ್‌ ಚೋ಼ರ್‌ನ ಛೋ಼ಡೈ ದೇವ್ಣು ಕರಿ ಪಿಲಾತನ ಬೋಲಿಲಿದ. ");
INSERT INTO vaa_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","ಅಮ್ ತುಮೆ ಜಾನ್‍ದೇವಳಾನಸ್ ಮರೈನಾಖ್ಯ. ಕತೋಬಿ ದೇವ್ನೆ ಇನ ಮರ‍್ಯಾಹುಯಾಮಾಥು ಉಠಾಡ್ಯೊ; ಅನಿ ಬಾರೇಮ ಹಮೇಸ್ ಸಾಕ್ಷಿಖ್ಹಾರು ಹುಯಿರಾಸ್. ");
INSERT INTO vaa_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","ತುಮೆ ಶಾತ್‌ ದೇಖ್ಯಕಿ ಅಜು಼ ತುಮೆ ಶಾತ್ ಖ್ಹಮ್‍ಜ್ಯಾಕಿ ಯೋ ಅಖ್ಖು ಇನ ನಾಮ್‍ಥೀಸ್ ಹುಯಿರುಸ್. ಯೊ ಲಂಗ್‍ಡಾನೆ ಯೇಸುನ ಉಪ್ಪರ್ ರಾಖಿರಾಖ್ಯೊತೆ ವಿಶ್ವಾಸ್‌ಥೀಸ್ ಇನ ಅಛ್ಛು಼ ಹುಯುತೆ ಅನಅಖ್ಖು ತುಮೆ ದೇಖಿರಾಖ್ಯಸ್. ");
INSERT INTO vaa_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","ಇಸ್ರಾಯೇಲ್‌ವಾಳವೊ, ಯೋ ರ‍್ಹವಾದೆ ತುಮೆ ಮಾಲುಮ್‌ ಕರ‍್ಯಕೊಂತೆ ಯೇಸುನ; ಅಮ್ ಕರ‍್ಯಕರಿ ಮನ ಮಾಲುಮ್ ಛಾ಼, ತುಮಾರ ಅದಿಕಾರಿ ಜಿನುಬಿ ಮಾಲುಮ್ ಕರೀಲಿದಾಕೊಯ್ನಿ. ");
INSERT INTO vaa_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","ಕ್ರಿಸ್ತಯೇಸು ಲತಾಡ ಲಿಶೆ ಕರಿ ದೇವ್ನೆ ಪ್ರವಾದಿಖ್ಹಾರಥಿ ಅಗಾಡಿಸ್ ಬೋಲಾಯೋತೆ ವಾತೆ ಅಮ್ನಿ ಪರಕ್ಮ ಚಾ಼ಲಾಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","ಅನಖ್ಹಾಜೇಥಿ ತುಮಾರ ಪಾಪ್ನಖ್ಹಾಜೆ ತುಮೆ ಪ್ರಾಯಶ್ಚಿತ್ ಕರಿಲೀನ್ ದೇವ್‌ಭಣಿ ಫರಿಜಾ಼ವೊ. ತದೆ ಯೋ ತುಮಾರಿ ಪಾಪ್ನ ಕ್ಷಮಾಪಣ್ ಕರಿಲಿಶೆ. ");
INSERT INTO vaa_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","ಪ್ರಭು ತುಮೂನ ಆತ್ಮೀಕ ಅರಾಮ್ ದಿಶೆ.ಅಜು಼ ದೇವ್ನೆ ಪಹಿಲೇಸ್ ಕ್ರಿಸ್ತಕರಿ ಚೂ಼ಣಿರಾಖ್ಯೊತೆ ಮೆಸ್ಸಿಯಾನ ತುಮಾರಖ್ಹಾಜೇಸ್ ಮೋಕಲ್‌ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","“ಕತೋಬಿ ಅಖ್ಖಾಸ್ನ ಬರೋಬರ್ ಕರಾನ ದನ್ ಆವಾಲಗು ಯೊ ಪರಲೋಕ್‌ಮಾಸ್ ರ‍್ಹೇವ್ಣುಕರಿ ದೇವ್ ಘಣಾದನ್ನ ಪಾಛ಼ಳ್ ಇನ ಪವಿತ್ರ ಪ್ರವಾದಿಥಿ ವಾತೆ ಬೋಲಾನಿ ವಖ್ಹತ್‌ಮ; ಆ ದನ್ನಿ ಬಾರೇಮ ಬೋಲ್ಯೊಥೊ. ");
INSERT INTO vaa_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","ಮೋಶೆನೆ ಬೋಲ್ಯೊತೆ ಶಾತ್‍ಕತೊ, ದೇವ್‍ಹುಯಿರ‍್ಹೋತೆ ಪ್ರಭು ಮಾರಿನಿತರ ತುಮಾರ ಅದ್ಮಿಮಾಸ್ ಏಕ್‌ ಪ್ರವಾದಿನ ತುಮಾರಖ್ಹಾಜೆ ಉಠಾಡ್‍ಶೆ, ಯೋ ಬೋಲ್‍ಶೇತೆ ಅಖ್ಖಿ ವಾತೆನ ತುಮೆ ಖ್ಹಮಜ಼್‌ಣು. ");
INSERT INTO vaa_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","ಯೊ ಪ್ರವಾದಿನಿ ವಾತೆನ ಖ್ಹಮ್‍ಜ಼ಕೊಂತೆ ಹರೇಕ್ ಜ಼ಣೊಬಿ ದೇವ್ನ ಅದ್ಮಿಥಿ ಅಲಕ್‌ಹುಯಿನ್ ನಾಶ್‌ಹುಯಿಜಾ಼ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","ಸಮುವೇಲ್‍ಥಿ ಧರೀನ್ ಇಂಥಿ ಪಛ಼್‌ಲ್ಯ ಪ್ರವಾದಿಖ್ಹಾರುಬಿ ಹಮ್ಕೇನಿ ಆ ದನ್ನಿ ಬಾರೇಮ ವಾತೆ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","ಯೊ ಪ್ರವಾದಿಖ್ಹಾರು ಬೋಲ್ಯಾತೆ ವಾತೆನ ತುಮೆ ಖ್ಹಮ್‍ಜಿಲಿದ. ದೇವ್ ತುಮಾರ ಗುರುಗುರಬ್‍ಲ್ಯಾನಿ ಜೋ಼ಡ್ಮ ಕರ‍್ಯೊತೆ ಒಪ್ಪಂದಾನನ ತುಮೆ ಸ್ವೀಕಾರ್ ಕರೀಲಿದಾ. ದೇವ್ ತುಮಾರೊ ಗುರು ಹುಯಿರೋತೆ ಅಬ್ರಹಾಮ್‌ನ, ‘ತಾರಿ ಖಾನ್‍ಧಾನ್‍ಥಿ ಜ಼ಮೀನ್‌ಪರ್ ಛಾ಼ತೆ ಅದ್ಮಿಖ್ಹಾರು ವಾರ್‌ಖ್ಹೊ ಲೀಲಿಶೆ ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","ದೇವ್ ಪಹಿಲೆ ತುಮಾರಖ್ಹಾಜೇಸ್ ಇನ ಸೇವಕ್‌ನ ಮರಣ್‌ಥು ಉಠಾಡಿನ್ ತುಮಾರಕನ ಮೋಕ್‌ಲ್ಯೊ. ತುಮೂನ ಆಶೀರ್ವಾದ್‌ ಕರಾನಖ್ಹಾಜೆ ದೇವ್ನೆ ಯೇಸುನ ಮೋಕ್‌ಲ್ಯೊ. ಯೋ ತುಮಾರಮ ಹರೇಕ್ ಜ಼ಣಾನಾಬಿ ಇವ್ಣಿ ಇವ್ಣಿ ಖರಾಬ್ ವಾಟ್‍ಥಿ ದೂರ್ ಕರೀನ್ ಆಶೀರ್ವಾದ್‌ ಕರ್ಶೆ.” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","ಪೇತ್ರಬಿ ಯೋಹಾನ ಅದ್ಮಿಖ್ಹಾರಾನಿ ಜೋ಼ಡ್ಮ ವಾತ್ ಬೋಲುಕರಾನಿ ವಖ್ಹತ್‌ಮಾಸ್‌ ಹಿಜ್ಜಾ಼ ಥೋಡು ಯಾಜಕ್ ಖ್ಹಾರು ದೇವ್ನ ಮಂದಿರ‍್ನ ಕಾವ್ಲಿಕರಾವಾಳನೊ ಮೋಟೊಬಿ ಸದ್ದುಕಾಯವಾಳು ಇವ್ಣಕನ ಆಯು. ");
INSERT INTO vaa_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","ಆ ಭೇಜ಼ಣ ಅಪೊಸ್ತಲರ‍್ನೆ ಅದ್ಮಿಖ್ಹಾರಾನ ಯೇಸುನಿ ಶಕತ್‍ಥಿ ಮರ‍್ಯಹುಯಾನ ಖ್ಹಾರಾನ ಪಾಛು಼ ಜಿವ್ತುಹುಯಿನ್ ಆವ್‌ಶೆ ಕರಿ ಬೋಧನೆ ಕರುಕರಾತೆ ದೇಖಿನ್ ಇವ್ಣುನ ಚ಼ಂಢಾಳ್ ಛ಼ಡ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","ಯೆಹೂದ್ಯರ್‌ನ ಗಲ್‍ಢಖ್ಹಾರಾನೆ ಪೇತ್ರನಾಬಿ ಯೋಹಾನನಾಬಿ ಧರೀನ್ ಖ್ಹಾರ್ಕೊಟ್‌ಮ ಘಲ್‍ದಿದು. ತದೆ ಅಂಧಾರು ಹುಯಿರ‍್ಹುಥು. ಇನಖ್ಹಾಜೆ ಇವ್ಣ ಭೇಜ಼ಣಾನ ಇನ ಆಗ್‍ಲ್ಯ ದನ್‌ಲಗು ಕೋಂಡಿರಾಖ್ಯುಥು. ");
INSERT INTO vaa_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","ಕತೋಬಿ ದೇವ್ನಿ ವಚನ್ ಖ್ಹಮ್‍ಜಾ಼ವಾಳಾಮ ಕೆತ್ರೂಕಿಜ಼ಣು ವಿಶ್ವಾಸ್ ಕರ‍್ಯು; ಪರ್ಖ್ಹಾನಿ ಗಣ್ತೀಸ್ ಖ್ಹುಮಾರ್ ಪಾಚ಼್ ಹಜಾ಼ರ್ಥಿ ಜಾ಼ಖ್ಹತ್ ಹುಯು. ");
INSERT INTO vaa_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","ಅಗ್‍ಲ್ಯದನ್ನೆ ಯೆಹೂದ್ಯರ‍್ನು ಅದಿಕಾರಿಬಿ ಗಲ್‌ಢಖ್ಹಾರು, ಬಿಜು಼ ಧರ್ಮ ಬೋಧನೆ ಕರವಾಳು ಯೆರೂಸಲೇಮ್ಮ ಸಭೆ ಮಳೀನ್‍ ಆಯು. ");
INSERT INTO vaa_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","ಹಿಜ್ಜಾ಼ ಅನ್ನಕರಿ ಪ್ರಧಾನ ಯಾಜಕ್‍ಬಿ ಕಾಯಫಬಿ ಯೋಹಾನಬಿ, ಬಿಜು಼ ಅಲೆಕ್ಸಾಂಡರ್‌ಬಿ ಥೊ.ಮಹಾಯಾಜಕನ ಪರಿವಾರ್ ವಾಳಾಮ ಮಳ್ಯುಹುಯು ಅಖ್ಖು ಜ಼ಣುಬಿ ಹಿಜ್ಜಾ಼ ಥೂ. ");
INSERT INTO vaa_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","ಅವ್ಣೆ ಪೇತ್ರಬಿ ಯೋಹಾ‍ನನ ಬೀಚ್ಮ ಭೀರಾಖಿನ್ ತುಮೆ ಖಿವಿ ಶಕಥ್ಥಿ ಅಜು಼ ಕಿನ ನಾಮ್‍ಥಿ ಆ ಅಖ್ಖು ಕರೋಸ್? ಕರಿ ಬೋಲಖ್ಹತರ್, ");
INSERT INTO vaa_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","ತದೆ ಪೇತ್ರನೆ ಪವಿತ್ರಾತ್ಮಥಿ ಭರೈನ್ ಇವ್ಣುನ; ಅದ್ಮಿನ ಅದಿಕಾರಿವೊ ಶಾಣವೊ, ");
INSERT INTO vaa_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","ಏಕ್‌ ಲಂಗ್ಡಾನ ಹುಯುತೆ ಮದತ್‍ನಿ ಬಾರೇಮ ಇನ ಆ ಕಿಮ್ ಗುಣ್‌ಹುಯು ಕರಿ ತುಮೆ ಹಮೂನ ಸವಾಲ್‌ ಬೋಲುಕರಸ್. ");
INSERT INTO vaa_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","ತುಮೆ ಶಿಲ್‌ಬೇಪರ್ ಛ಼ಡಾಯತೆ ಅಜು಼ ‘ದೇವ್ನೆ ಮರ‍್ಯಹುಯಮಾಥು ಉಠಾಡ್ಯೊತೆ ನಜ಼ರೇತ್‌ನೊ ಯೇಸುಕ್ರಿಸ್ತನ ನಾಮ್‍ಥೀಸ್ ಆ ಲಂಗ್ಡೊಥೋತೆ ಅದ್ಮಿ ಅಛ್ಛೊ಼ ಹುಯು. ಬಿಜು಼ ತುಮಾರ ಖ್ಹಾಮ್ಣೆ ಭಿಯೋಸ್ ಕರಿ ಬೋಲಾನು, ತುಮೂನಾಬಿ ಅಜು಼ ಇಸ್ರಾಯೇಲ್ ಅದ್ಮಿಖ್ಹಾರನ ಆವಾತೆ ಮಾಲುಮ್ ರ‍್ಹವಾದೆ. ");
INSERT INTO vaa_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","‘ಘರ್ ಭಾಂದಾವಾಳ ಹುಯಿರ‍್ಹಾತೆ ತುಮೆ ನಕೊಕರಿ ಮ್ಹೆಂದಿದಾತೆ ಯೊ ಬಂಡೋಸ್ ಯೇಸು. ಯೋಸ್ ಮುಖ್ಯ ಹುಯಿರ‍್ಹುತೆ ಕೋಣಾನೊ ಬಂಡೊ ಹುಯಿಗಯೊ’. ");
INSERT INTO vaa_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","ಆವ್ಣುತೆ ರಕ್ಷಣೆ ಬಿಜು಼ ಕಿನಾಮಬಿ ಮಳ್‍ಶೆಕೊಯ್ನಿ; ಇನ ನಾಮ್‍ಥೀಸ್ ಪಣ್ಕಿ ಆಬ್‌ನ ಹೇಟ್ ಅದ್ಮಿನ ದೀರಾಖ್ಯುತೆ ಬಿಜ಼ ಖೆವ ನಾಮ್‌ಥಿಬಿ ಅಪ್ಣುನ ರಕ್ಷಣೆ ಕೋಉಷೇನಿ. ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","ಪೇತ್ರ ಬಿಜು಼ ಯೋಹಾನ, ಭಾಲ್‌ಥಿ ವಾತೆ ಬೋಲಾನು ಯೋ ಅದ್ಮಿಖ್ಹಾರು ದೇಖಿನ್ ಇವ್ಣೆ ಶನೀಬಿ ಪಢಂತ್ ಕೊ ಶಿಕಿರಾಖ್ಯಾನಿ ತೋಬಿ ಡರ‍್ಯಕೊಂತೆ ಆ ಕಿಮ್ ಬೋಲಸ್ ಕರಿ ಘಣು ಆಶ್ಚರ್ಯ ಕರ‍್ಯು. ಪೇತ್ರಬಿ ಯೋಹಾನ ಯೇಸುನಿ ಜೋ಼ಡ್ಮಥೋತೆ ಕರಿ ಖ್ಹಣೇದ್ ಧರ‍್ಯು. ");
INSERT INTO vaa_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","ಅಜು಼ ಗುಣ್‌ಹುಯುತೆ ಯೊ ಲಂಗ್ಡು ಅದ್ಮಿಬಿ ಇವ್ಣಿ ಜೋ಼ಡ್ಮ ಭೀಯೂತೆ ದೇಖ್ಯು.ಯೆಹೂದ್ಯರ್‌ನೆ ಫರೀನ್ ಶಾತ್ಬಿ ಬೋಲಾನ ಕೋ ಹುಯುನಿ. ");
INSERT INTO vaa_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","ತದೆ ಯೆಹೂದ್ಯರ್‌ನ ಘಲ್ಡ ಖ್ಹಾರಾನೆ ಅಪೊಸ್ತಲರ‍್ನ ಭಾರ್‌ ಮೋಕ್ಲಿನ್, ");
INSERT INTO vaa_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","ಇವ್ಣೆ “ಆ ಅದ್ಮಿನ ಅಪ್ಣೆ ಶಾ‍ತ್ ಕರಿಯೆ? ಅವ್ಣೆ ಘಣು ಅಪ್‍ರೂಪ್‍ನು ಖ್ಹಣೇದ್‍ನು ಕಾಮ್ ಕರಿರಾಖ್ಯುತೆ ಯೆರೂಸಲೇಮ್‌ನ ಖ್ಹಾರಾಸ್ ಅದ್ಮಿನ ಮಾಲುಮ್‍ಪಡಿರ‍್ಹುಸ್, ಇನ ಝೂ಼ಟಿ ಬೋಲಾನ ಕೊಹೊಯ್ನಿ”. ");
INSERT INTO vaa_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","ಕತೋಬಿ ಆ ವಾತೆನ ಅದ್ಮಿಖ್ಹಾರು ಯೇಸುನ ನಾಮ್ನ ಪಾಡೀನ್ ಬಿಜು಼ ಕಿನಿ ಜೋ಼ಡ್ಮಾಬಿ ವಾತೆ ನಾಬೋಲ್ನುಕರಿ ಇವ್ಣುನ ಡರಾವ್ಣು ಕರಿ ಇವ್ಣೆ ವಾತೆ ಬೋಲಿಲಿದು. ");
INSERT INTO vaa_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","ತದೆ ಅಪೊಸ್ತಲರ‍್ನ ಮಹಿ ಬುಲೈನ್, ಯೇಸುನು ನಾಮ್‍ಲೀನ್ ಶಾತ್ಬಿ ನಾ ಬೋಲ್‌ನು ಬಿಜು಼ ಶಿಕಾಡ್‍ನುನಾ ಕರಿ ಇವ್ಣುನ ಝೇತಾಯು. ");
INSERT INTO vaa_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","ಇನಖ್ಹಾಜೆ ಪೇತ್ರಬಿ ಯೋಹಾನಾನೆ; ಇವ್ಣುನ, ದೇವ್ನಿ ವಾತೆ ಖ್ಹಮ್‍ಜಾ಼ಥೀಬಿ ತುಮಾರಿವಾತೆ ಖ್ಹಮ್‍ಜಾ಼ನು ಬರೋಬರ್‌ಕಿ ಶು? ಯೊ ದೇವ್ನ ಖ್ಹಾಮ್ಣೆ ನ್ಯಾವ್‌ಕಿ ಶು? ಇನ ತುಮೇಸ್ ತೀರ್ಪ್ ಕರಿಲೆವೊ. ");
INSERT INTO vaa_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","ಹಮೇತೊ ದೇಖಿನ್ ಖ್ಹಮ್‍ಜಿಹುಯಿ ವಾತೆನ ಬೋಲ್‌ಶು ಕೊಂತೆ ರ‍್ಹಿಶುಕೊಯ್ನಿ. ಕರಿ ಜ಼ವಾಬ್‍ದಿದಾ. ");
INSERT INTO vaa_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","ಚಾ಼ಲ್ಯುತೆ ಖ್ಹಣೇದ್ನ ಕಾಮ್ನಖ್ಹಾಜೆ ಅದ್ಮಿಖ್ಹಾರು ದೇವ್ನ ಖ್ಹರವ್‌ಕರ‍್ತುಥು, ಇನಖ್ಹಾಜೆ ಅಪೊಸ್ತಲರ‍್ನ ಖ್ಹತಾವನ ಕಾರಣ್ ಮಳಿಕೊಂತೆ ಇನಖ್ಹಾಜೆ ಇವ್ಣುನ ಅಜೂ಼ಬಿ ಝೇತೈನ್‍ಮ್ಹೇಲಿದಿದು. ");
INSERT INTO vaa_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","ಯೊ ಖ್ಹಣೇದ್‍ನು ಕಾಮ್‍ಥಿ ಅಛ್ಛು಼ ಹುಯುತೆ ಲಂಗ್ಡಾನ ಚಾ಼ಳಿಖ್ಹ್ ವರಖ್ಹ್‌ಥೀಬಿ ಜಾ಼ಖ್ಹತ್ ಉಂಬರ್ ಹುಯಿರುಥು. ");
INSERT INTO vaa_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","ಪೇತ್ರಬಿ ಯೋಹಾನ ಭೇಜ಼ಣ ಯೆಹೂದ್ಯರ್‌ನ ಗಲ್‌ಢಖ್ಹಾರಾನಿ ಸಬೆಮಾಥು ನಿಕ್ಳಿನ್, ಇವ್ಣ ಝೂ಼ಂಡ್‌ಮ, ಮಹಾಯಾಜಕ್ ಖ್ಹಾರಾನೆ ಬಿಜು಼ ಯೆಹೂದ್ಯರ್‌ನ ಶಾಣಖ್ಹಾರಾನೆ ಇವ್ಣು ಬೋಲ್ಯೊತೆ ವಾತೆಖ್ಹಾರೀಸ್ ಇವ್ಣಿ ಝೂ಼ಂಡ್‌‍ವಾಳಾನ ಖ್ಹಮ್‍ಜಾ಼ಡ್ಯ. ");
INSERT INTO vaa_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","ಅನ ಖ್ಹಮ್‍ಜ್ಯುತೆ ಖ್ಹಾರು ವಿಶ್ವಾಸಿ ಏಕ್‍ದಿಲ್‍ಥಿ ದೇವ್ನ ಜೋ಼ರೇಖ್ಹು ಚಿಕ್ರಿನ್ ಅಮ್ ಪ್ರಾರ್ಥನೆ ಕರ‍್ಯು. ಮಹಾಪ್ರಭು, ಆಬ್‌ ಧರ್ತಿನ, ದರ‍್ಯಾವ್‌ನಾಬಿ, ಇನಾಮ ಛಾ಼ತೆ ಖ್ಹಾರೂಸ್ ಉಬ್‍ಜಾ಼ಯೊಹುಯೊ ತೂಸ್, ");
INSERT INTO vaa_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","ಹಮಾರೊ ಗುರು ಹುಯಿರೋತೆ ದಾವೀದ್ ತಾರೊ ಸೇವಕ್ ಹುಯಿರೋಥೊ. ಇನೆ ಪವಿತ್ರಾತ್ಮನಿ ಮದಥ್ಥಿ ಆವಾತೆಖ್ಹಾರಿ ಲೀಖ್ಯೊ. ಯೆಹೂದ್ಯರ್‌ಕಾಹೆತೆ ಅದ್ಮಿಖ್ಹಾರು ಇರಾದೊ ಶನ ಕರ್ತುಉಷೆ? ಅಲಕ್ ಜಾ಼ತ್‌ಜ಼ಮಾತ್‌ಖ್ಹಾರು ಶನ ಫಾಯಿದೊಕೊಂತೆ ಸೋಚ್‌ತು ಉಷೆ? ");
INSERT INTO vaa_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","ಜಗತ್ನೊ ರಾಜ಼ಖ್ಹಾರು ತಯಾರ್ ಹುಯಿರುಸ್, ಪ್ರಭುನಾಬಿ ಇನೊ ಅಬಿಷೇಕ್ ಕರಿರಾಖ್ಯೊತೆ ಇನಾಬಿ ವಿರೋದ್ ಹುಯಿನ್ ಅದಿಕಾರಿಖ್ಹಾರು ಎಕ್ಟು ಹುಯಿರುಸ್. ಕರಿ ಬೋಲೈರಾಖ್ಯೊಸ್‍ನಿ? ");
INSERT INTO vaa_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","ಯೋ ವಾಥ್ಥಿಸ್ ಹೆರೋದಬಿ ಪೊಂತ್ಯ ಪಿಲಾತಬಿ, ತೂ ಅಬಿಷೇಕ್ ಕರ‍್ಯೊತೆ ತಾರೊ ಪವಿತ್ರ ಸೇವಕ್ ಹುಯಿರೋತೆ ಯೇಸುನ ವಿರೋದ್ ಯೆಹೂದ್ಯರ್‌ಕಾಹೆತೆ ಖ್ಹಾರು ಅಜು಼ ಇಸ್ರಾಯೇಲ್‌ನು ಅದ್ಮಿಖ್ಹಾರು ಒಟ್‍ ಹುಯಿನ್ ಭರೈರ‍್ಹೂಥು. ");
INSERT INTO vaa_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","ಯೇಸುನ ವಿರೋದ್ ಎಕ್ಟುಹುಯಿನ್ ಆಯುತೆ ಆ ಖ್ಹಾರು ಅದ್ಮಿನ ತಾರಿ ಖ್ಹೂಜ಼್ ಚಾ಼ಲನಿಘೊಣಿ ಕರ‍್ಯು. ತಾರಿ ಶಕಥ್ಥಿ ಅಜು಼ ತಾರಿ ಮರ್ಜಿಥೀಬಿ ಆ ಚಾ಼ಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","ಪ್ರಭು ಹಮ್ಕೆ ಅವ್ಣೆ ಬೋಲುಕರಾತೆ ಖ್ಹಮಜ಼್ ಇವ್ಣೆ ಹಮೂನ ಡರಾವ್‌ಕರಾತೆ ಇನ ತು ಕಾನ್‌ದೆ. ಪ್ರಭು ಹಮೆ ತಾರಿ ಸೇವಕ್ ಹುಯಿರಾತೆ ತಾರಿ ವಚನ್ನ ಭಾಲಿಥಿ ಬೋಲಾನ ತೂಸ್ ಮದತ್‍ಕರ್. ");
INSERT INTO vaa_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","ತಾರ ಹಾತ್ನ ಭಡಾಯೋತೊ, ತಾರ ಸೇವಕ್, ತಾರಿ ವಚನ್ನ ಹಿಮ್ಮಥ್ಥಿ ಬೋಲಾನಿತರ ರಕ್ಷಕ್ ಯೇಸುನ ನಾಮ್‍ಥಿ ಪವಿತ್ರ ಕಾಮ್ ಕರಾನ, ರೋಗ್‌ವಾಳನ ಗುಣ್‌ಕರಾನಖ್ಹಾಜೆ,ಅಶ್ಚರ್ಯ ಅದ್ಭುತ್‌ಕಾಮ್‌ ಕರಾನ ತಾರೊಹಾತ್‌ ಫೈಲಾವ್‌”. ");
INSERT INTO vaa_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","ಅಮ್ ವಿಶ್ವಾಸಿಖ್ಹಾರು ಪ್ರಾರ್ಥನೆ ಕರಾನಿ ವೇಳ್ಮ ಇವ್ಣೆಥಾತೆ ಝ಼ಗೊ ಕಾಪಿರ‍್ಹಹಿಗು. ತದೆ ಇವ್ಣೆ ಖ್ಹಾರುಸ್ ಪವಿತ್ರಾತ್ಮಥಿ ಭರೈನ್ ದೇವ್ನಿ ವಚನ್ನ ಡರ್‌ ಕೊಯಿನ್ತೆ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","ಅಖ್ಖ ವಿಶ್ವಾಸಿನೊ ದಿಲ್‌ಬಿ ಜಾನ್‌ಬಿ ಎಕ್ಕಸ್ ಹುಯಿರ‍್ಹುಥು. ಇವ್ಣ ಟೋಳ್‍ಮಾನು ಕೋಣ್‌ಬಿ ರ‍್ಹವೊ ಇವ್ಣುನ ಥೂತೆ ಶೊತ್ಮ ಖಿವು ಏಕ್‌ಬಿ ಹಮಾರು ಕರಿ ಬೋಲ್ಯುಥುಕೊಯ್ನಿ. ಇನ ಬದಲ್ ಹರೇಕ್‍ನಾಬಿ ವಾಟಪಾಡಿಲೇತೂಥು. ");
INSERT INTO vaa_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","ಪ್ರಭು ಹುಯಿರೋತೆ ಯೇಸು ಪಾಛು಼ಜಿವ್ತೊಹುಯಿನ್ ಉಠೀನ್ ಆಯೊಕರಿ ಅಪೊಸ್ತಲರ್ ಘಣ ಶಕಥ್ಥಿ ಅದ್ಮಿಖ್ಹಾರಾನ ಸಾಕ್ಷಿ ಬೋಲ್ತುರ‍್ಹೇತುಥು. ಅಜು಼ ದೇವ್ನಿ ದಯಾ ಜಾ಼ಖ್ಹತ್ ಕಾಮ್‍ಕರ‍್ಯು. ");
INSERT INTO vaa_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","ಇವ್ಣೆ ಜ಼ರೂರತ್ ಪೂರಹೋತುಥು, ಜ಼ಮೀನ್ ಬಿಜು಼ ಘರ್ ರ‍್ಹವಾಳು ಹರೇಕ್‌ಜ಼ಣು ಯೊ ಖ್ಹಾರು ವೇಚಿನ್ ಮಳಾತೆ ಪೈಶಾನ ಲೀನ್ ಆಯು. ");
INSERT INTO vaa_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","ಅಜು಼ ಇವ್ಣೆಖ್ಹಾರು ಅಪೊಸ್ತಲರ‍್ನ ಗೋಡಾಕನ ಲಯಿನ್ ಮ್ಹೇಲ್‍ತೂಥು; ಯೊ ಪೈಶಾನ ಜ಼ರೂರತ್ ರ‍್ಹವಳಾನ ವಾಟಪಾಡಿ ದೇತೂಥು. ");
INSERT INTO vaa_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","ಅಮ್ನಿಸ್ ಪರಕ್ಮ ಸೈಪ್ರಸ್ ಗಾಮ್ಮ ಪೈದಹುಯೊತೆ ಲೇವಿ ಹುಯಿರೊಥೋತೆ ಯೋಸೇಫಕರಿ ಏಕ್‍ಜ಼ಣೊ ಥೊ. ಇನ ಅಪೊಸ್ತಲ್‌ಖ್ಹಾರು ಬಾರ್ನಬ ಕರಿ ಬೋಲ್ತುಥು. ಇಮ್‍ಕತೊ “ಏಕ್‌ನ ಭಾಲಿ ದ್ಯವವಾಳೊ” ಕರಿ ಅರ್ಥ. ");
INSERT INTO vaa_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","ಇನೆ ಇನಥೂತೆ ಜ಼ಮೀನ್ನ ವೇಚಿನ್ ಯೊ ಪೈಶಾನ ಅಪೊಸ್ತಲರ‍್ನ ಲಯಿನ್ ದಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","ಅನನೀಯಕರಿ ಏಕ್‍ಜ಼ಣೊ ಥೊ. ಇನಿ ಬಾವಣ್ಣು ನಾಮ್ ಸಫೈರ.ಅವ್ಣುನ ಥೂತೆ ಥೋಡಿ ಜ಼ಮೀನ್ನ ವೇಚಿನ್, ಇಂಥಿ ಮಳಾತೆ ಪೈಶಾಮ, ");
INSERT INTO vaa_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","ಇನಿ ಬಾವಣ್ಣಿ ವಾತ್ ಖ್ಹಮ್‌ಜಿನ್‌ ಏಕ್‌ ಭಾಗ್‌ ಲಪಾಡಿನ್, ಬಿಜೇಕ್ ಭಾಗ್ನ ಅಪೊಸ್ತಲರ‍್ನ ಗೋಡಾಕನ ಲಯಿನ್ ಮ್ಹೇಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","ತದೆ ಪೇತ್ರನೆ; ಅನನೀಯನ, ತೂ ಯೊ ಜ಼ಮೀನ್ ವೇಚ್ಯೊತೆ, ಇನಾಮಾಥು ಥೋಡು ಲಪಾಡಿನ್ ಪವಿತ್ರಾತ್ಮನ ಠಗಾವ್ಣು಼ ಕರಿ ಛಾ಼.ಶೈತಾನ್ನೆ ತಾರ ದಿಲ್ಮ ಭರ್‌ದಿದೊತೆ ಶಾತ್? ");
INSERT INTO vaa_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","ವೇಚಾ಼ನ ಅಗಾಡಿ ಯೋ ಜ಼ಮೀನ್ ತಾರೀಸ್ ಹುಯಿರ‍್ಹಯಿಥೀನಿ. ತೂ ವೇಚ್ಯೊತೊಬಿ ಆಯೂತೆ ಪೈಶಾ ತಾರಾಸ್ ಹಕ್‌ಮ ಥು. ಆ ಖರಾಬ್ ಕಾಮ್ನ ತಾರ ದಿಲ್ಮ ಶನ ಸೋಚಿಲಿದೊ? ತೂ ಝೂ಼ಟಿ ಬೋಲ್ಯೊತೆ ದೇವ್ನ ಪಣ್ಕಿ,ಅದ್ಮಿನ ಕಾಹೆ ಕರಿ ಪೇತ್ರನೆ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","ಆವಾತೆಖ್ಹಾರಿ ಖ್ಹಮಜ಼್‌ತಾಸ್‌ ಅನನೀಯ ಹೇಟ್ ರಡ್ಕಿನ್ ಮರಿಗಯೊ; ಅನ ಖ್ಹಮ್‍ಜಾ಼ವಾಳ ಅಖ್ಖಾಸ್ನ ಘಣೊ ಡರ್‌ಲಾಗ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","ತದೆ ಜಾ಼ನ್‍ಜ಼ಮಾನ್‍ಖ್ಹಾರು ಉಠೀನ್ ಇನ ಶರೀರ್‌ನ ಲುಂಗ್ಡಾಮ ಲಪೇಟಿನ್ ಢೋಯಿಲಿಜೈನ್ ಮಖ್ಹಾಣ್ಯು ಕರ‍್ಯು. ");
INSERT INTO vaa_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","ಅನವಾರ್‌ ಖ್ಹುಮಾರ್ ತೀನ್ ಘಂಟಾನಿ ವೇಳ್ಮ ಅನನೀಯನಿ ಬಾವಣ್‍ ಇನ ಮಾಲುಮ್‌ಕೊಂತೆ ಹಿಜ್ಜಾ಼ ಆಯಿ. ");
INSERT INTO vaa_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","ತದೆ ಪೇತ್ರನೆ ಸಫೈರನ ದೇಖಿನ್-ತುಮೆ ಯೊ ಜ಼ಮೀನ್ ವೇಚ್ಯಾತೆ ಖ್ಹಾಚಮಾಬಿ ಅತ್ರಾಸ್‍ ಪೈಶಾನಕಿಶೂ? ತೂ ಮನ ಬೋಲ್‌ಕರಿ ಬೋಲಾನಿ ವೇಳ್ಮ “ಒಹೊ ಅತ್ರಾಸ್‍ ಪೈಶಾನ” ಕರಿ ಬೋಲಿ. ");
INSERT INTO vaa_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","ತದೆ ಪೇತ್ರ ಇನ-ತುಮೆ ಭೇಜ಼ಣ ಮಳಿನ್ ಪ್ರಭುನ ಆತ್ಮಾನ ಶನ ತರೀಪ್ಷಕರ‍್ಯಾ”? ಹಂದೇಕ್, ತಾರ ಬಾವ್ರಿನ ಗಾಡ್ಯಹುಯ, ಬಾಕಲ್‍ಕನ ಆಯಿನ್ ಭೀಯ. ತುನಾಬಿ ಇವ್ಣೆಸ್ ಢೊಯಿಲೀನ್ ಜಾ಼ಶೆ ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","ತದೇಸ್‌ ಯೋಬಿ ಪೇತ್ರನ ಗೋಡಾನ ಖ್ಹಾಮ್ಣೆ ಪಡೀನ್ ಮರಿಗೈ. ಯೋ ಜಾ಼ನ್ಜ಼ಮಾನ್ ಖ್ಹಾರಾನೆ ಮಹಿ ಆಯಿನ್ ಯೋ ಮರಿಗೈತೆ ದೇಖಿನ್ ಇನ ಢೊಯಿಲೀಜೈನ್ ಇನ ಬಾವ್ರಿನ ಮಖ್ಹಾಣ್ಯನ ಭೀಡೆ ಗಾಡಿದಿದು. ");
INSERT INTO vaa_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","ಆ ವಾತೆನ ಖ್ಹಮ್‍ಜ್ಯುತೆ ಅಖ್ಖಿ ಸಬೆನ ಅಜು಼ ಖ್ಹರಾಸ್ ಅದ್ಮಿವೊನ ಡರ್‌ಲಾಗ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","ಅಪೊಸ್ತಲರ್ ಖ್ಹಾರು ಕೈಏಕ್ ಖ್ಹಣೇದ್‍ನು ಕಾಮ್‍ಬಿ ಅದ್ಬುತ್‌ಕಾಮ್‌ಬಿ ಕರ‍್ಯು. ಅದ್ಮಿಖ್ಹಾರು ಯೋ ಕಾಮ್ನ ದೇಖ್ಯು. ಅಜು಼ ಅಖ್ಖುಜ಼ಣು ಎಕ್ಟು ಹುಯಿನ್ ಸೊಲೊಮೋನ್ನ ಛ಼ತ್‌ಕನ ಮಳಿನ್ ಆವ್ತುಥು. ");
INSERT INTO vaa_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","ಇವ್ಣ ಜೋ಼ಡ್ಮ ರ‍್ಹವಾನ ಬಿಜ಼ ಖೆವ ಏಕ್‌ ಜ಼ಣಾನ ಹಿಮ್ಮತ್ ಕೋಥಿನಿ. ಶನಕತೊ ಅದ್ಮಿಖ್ಹಾರು ಇವ್ಣುನ ಜಾ಼ಖ್ಹತ್ ಖ್ಹರಾವ್‌ತು ಥು. ");
INSERT INTO vaa_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","ರ‍್ಹಯುತೋಬಿ ಕೇತ್ರುಕಿಜ಼ಣು; ತಯೇಡ ಪರ್ಖೊಖ್ಹಾರು ಪ್ರಭುನ ನಂಬಾವಾಳು ಹುಯಿನ್ ಇವ್ಣ ಟೋಳ್ಮ ಮಳಿಜಾ಼ತುಥು. ");
INSERT INTO vaa_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","ಅಮ್‍ ರ‍್ಹವಾನಿ ವೇಳ್ಮ ಅದ್ಮಿಖ್ಹಾರು ರೋಗ್‌ವಾಳನ ಡೋಲಿಪರ್‌ ಪಾಡಿಲೀನ್ ಪೇತ್ರ ಆವಾನಿ ವಾಟ್‌ಪರ್ ಲಯಿನ್, ರೋಗ್‌ವಾಳನ ಉಪ್ಪರ್ ಇನಿ ಛಾ಼ಳಿಪಡಾದೆ ಕರಿ ವಾಟ್‌ಪರ್ ಮ್ಹೆಲ್ತುಥು. ಪೇತ್ರನಿ ಛಾ಼ಳಿ ಪಡಿತೋಬಷ್ ಕರಿ ಅದ್ಮಿಖ್ಹಾರಾನೆ ಸೋಚಿಲಿದು. ");
INSERT INTO vaa_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","ಯೆರೂಸಲೇಮ್ನ ಅಶ್‌ಪಿಶ್‍ ಖ್ಹಾರಗಾಮ್‍ನು ಅದ್ಮಿ ಆವ್ತುಥು. ಇವ್ಣೆ ರೋಗ್‍ವಾಳನಾಬಿ ಭೂತ್‌ ಧರಿರಾಖವಾಳನಾಬಿ ಢೊಯಿಲೀನ್ ಆವ್ತುಥು.ಆ ಅಖ್ಖೂಸ್‌ಜ಼ಣು ಗುಣ್‌ಹೋತುಥು. ");
INSERT INTO vaa_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","ಮಹಾಯಾಜಕ್‍ಬಿ ಇನ ಜೋ಼ಡ್‍ವಾಳು ಖ್ಹಾರು, ಸದ್ದುಕಾಯ ಭಣಿವಾಳು ಖ್ಹಾರು ಘಣು ಬಳಾಪೊ ಕರ‍್ಯು. ");
INSERT INTO vaa_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","ಇವ್ಣೆ ಅಪೊಸ್ತಲರ‍್ನ ಅಖ್ಖಾನ ಮಾಲುಮ್‌ರ‍್ಹೇಸ್ತೆ ಖ್ಹಾರ್ಕೊಟ್‌ಮ ಕೊಂಡಿನ್‌ ಘಾಲಿದಿದು. ");
INSERT INTO vaa_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","ಕತೋಬಿ ರಾತ್ಮ ಪ್ರಭುನೊ ಏಕ್‌ ಧೂತ ಜೇಲ್‌ನು ಬಾಕಲ್‍ಖ್ಹಾರು ಕಾಡಿನಾಖ್ಯೊ. ಯೊ ದೂತನೆ ಅಪೊಸ್ತಲರ‍್ನ ಭಾರ್‌ ಬುಲೈಲಾಯಿನ್‌, ");
INSERT INTO vaa_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“ತುಮೆ ಜೈ಼ನ್ ದೇವ್ನಿಮಂದಿರ್‌ನ ಮಹಿ ಭೀರಿನ್ ಆ ಜಿ಼ಂದ್‌ಗೀನಿ ಬಾರೇಮಾನಿ ಹರೇಕ್ ವಾತೇಬಿ ಅದ್ಮಿಖ್ಹಾರಾನ ಬೋಲೊಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","ಇನಖ್ಹಾಜೆ ಇವ್ಣೆ ಅಗಲ್ಯದನ್ನೆ ವ್ಹಾಣವೇಳಿಸ್ ದೇವ್ನಿಮಂದಿರ್‌ಮ ಜೈ಼ನ್ ಬೋಧನೆಕರಲಗ್ಯಾ. ಮಹಾಯಾಜಕ್‍ಬಿ ಇನ ಜೋ಼ಡ್‍ವಾಳು ದೇವ್ನಿಮಂದಿರ್‌ನ ಆಯ. ಇವ್ಣೆ ಯೆಹೂದ್ಯರ್‌ನ ಮೋಟಖ್ಹಾರಾನ ಅಜು಼ ಇಸ್ರಾಯೇಲ್‌ವಾಳನ ಘಲ್ಡಾವ್‍ನಿ ನ್ಯಾವ್‍ನಿ ಸಭೆ ಬೇಖ್ಹಾಡಿನ್‌. ಅಪೊಸ್ತಲರ‍್ನ ಇವ್ಣಕನ ಬುಲೈಲಿನ್ ಆವಾನಖ್ಹಾಜೆ ಥೋಡಜ಼ಣಾನ ಜೇಲ್‌ಕನ ಮೋಕ್‌ಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","ದೇವ್ನಿಮಂದಿರ್‌ನು ಸೇವೆ ಕರವಾಳು ಜೇಲ್‌ಮ ಜೈ಼ನ್ ದೇಖಾತೊ ಹಿಜ್ಜಾ಼ ಅಪೊಸ್ತಲರ್ ಕೊ ದೆಖಾಯುನಿ. ಇನಖ್ಹಾಜೆ ಪಾಛು಼ಫರಿ ಇವ್ಣೆ ಆಯಿನ್, ನ್ಯಾವ್‌ನಿ ಸಬೆವಾಳನ ಅಮ್ ಬೋಲ್ತೊಹುಯಿನ್; ");
INSERT INTO vaa_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“ಜೇಲ್ ಮೂಚೈ಼ನ್ ಕೀಲಿಲಗ್ಯುಥು. ಕಾವ್ಲಿ ಕರವಾಳು ಬಾಕಲ್‍ಕನ ಭಿಯೂಥು, ಕತೋಬಿ ಹಮೆ ಬಾಕಲ್ ಕಾಡ್ಯತೊ ಮಹಿ ಏಕ್‍ಜ಼ಣೂಬಿ ಕೋ ಥೂನಿ!” ಕರಿ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","ದೇವ್ನಿಮಂದಿರ್‌ನು ದಳಪತಿಬಿ ಬಿಜು಼ ಮಹಾಯಾಜಕ್ ಖ್ಹಾರು ಆ ವಾತೇನ ಖ್ಹಮ್‌ಜಿನ್‌ ಅನೇಥಿ ಶಾತ್‍ಉಷೇಕಿ ಕರಿ ಇವ್ಣುನ ಆಶ್ಚರ್ಯ ಹುಯು. ");
INSERT INTO vaa_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","ಅಮ್‌ರ‍್ಹವಾನಿ ವಖ್ಹ್‌ತೆ ಏಕ್‍ಜ಼ಣೊ ಅಯಿನ್ ಇವ್ಣುನ, “ಖ್ಹಮ್‍ಜೊ! ತುಮೆ ಜೇಲ್‌ಮ ಘಾಲ್ಯಥಾತೆ ಅದ್ಮಿಖ್ಹಾರು ಆಯಿನ್ ದೇವ್ನಿಮಂದಿರ್‌ಮ ಭಿರೀನ್ ಶಿಕಾಡುಕರಸ್” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","ತದೆ ಅದಿಕಾರಿ ಟಪಾಲ್‌ನ ಅದ್ಮಿನ ಜೋ಼ಡೆ ಜೈ಼ನ್ ಅಪೊಸ್ತಲರ‍್ನ ಪಾಛು಼ ಬುಲೈಲಾಯೊ. ಕತೋಬಿ ಶಿಪಾಯಿಖ್ಹಾರು ಇವ್ಣುನ ಜು಼ಲಮ್‌ ಕರ‍್ಯುಕೊಯ್ನಿ. ಶನಕತೊ ಅದ್ಮಿಖ್ಹಾರು ಹಮೂನ ಇರಾದೇಥಿ ಬಂಡೊ ಫೇಕಿನ್ ಮಾರಿನಾಕ್‌ಶೆ ಕರಿ ಡರಿಗಯು. ");
INSERT INTO vaa_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","ಇವ್ಣೆ ಅಪೊಸ್ತಲರ‍್ನ ಬುಲೈಲಿನ್ ನ್ಯಾವ್‌ನ ಸಭೆನಖ್ಹಾಮ್ಣೆ ಭೀರಾಖ್ಯು. ತದೆ ಮಹಾಯಾಜಕನೆ ಅಪೊಸ್ತಲರ‍್ನ ಸವಾಲ್‌ ಬೋಲ್ಯೊ; ");
INSERT INTO vaa_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“ತುಮೆ ಆ ನಾಮ್‌ಪರ್‌ ಬೋಧನೆ ನಾಸ್‍ಕರ‍್ನು ಕರಿ ತುಮೂನ ಹುಕುಮ್‌ ಕರ‍್ಯಥಾನಿ; ರ‍್ಹಯುತೋಬಿ ತುಮೆ ಕರ‍್ಯಾತೆಶಾತ್? ಯೆರೂಸಲೇಮ್‌ನ ತುಮಾರಿ ಬೋಧನೆಥಿ ಫೈಲೈದಿದ, ಆ ಮರೈರ‍್ಹುಥೆ ಅದ್ಮಿನ ಹಮೇಸ್ ಜಿಮ್ಮೇದಾರಿ ಕರಿ ಕರಾನ ತುಮೆ ಕೋಶಿಶ್ ಕರುಕರಸ್” ಕರಿ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","ತದೆ ಪೇತ್ರ ಅಜು಼ ಥೂತೆ ಅಪೊಸ್ತಲರ್ ಅಮ್ ಬೋಲ್ಯೊಕಿ, “ಹಮೆ ದೇವ್ನ ವಿಧೇಯ ಉಷು ಪಣ್ಕಿ ಅದ್ಮಿನ ಕಾಹೆ.” ");
INSERT INTO vaa_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","ತುಮೆ ಶಿಲ್‌ಬೆಪರ್ ಠಂಗೈನ್ ಮಾರ‍್ಯಾತೆ ಯೇಸುನ ಹಮಾರ ಗುರುಗುರಬ್‍ಲ್ಯನ ದೇವ್ನೆ ಮರಣ್‌ಥು ಉಠಾಡ್ಯೊ! ");
INSERT INTO vaa_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","ದೇವ್ ಇನಾಸ್ ಇಸ್ರಾಯೇಲ್ ಅದ್ಮಿನ ಮನ್ ಫರಾವನಾಬಿ, ಪಾಪ್ನ ಕ್ಷಮಾ ಕರಾನಖ್ಹಾಜೆಬಿ, ದೇವ್ನೆ ಇನ ಪ್ರಭು ಕರೀಬಿ ರಕ್ಷಕ್ ಕರೀಬಿ ಇನಿ ಖಾವಿ ಬಾಜು಼ಮ ಬೆಖ್ಹಾಡ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","ಆ ಕಾಮ್ನ ಹಮೇಸ್ ಸಾಕ್ಷಿ; ಹಮೇಸ್ ಕಾಹೆತೆ ವಿಧೇಯ ಹುವಾತೆ ಅಖ್ಖಾಸ್ ಅದ್ಮಿನ ದೇವ್ನೆ ದೀರಾಖ್ಯೋತೆ ಪವಿತ್ರಾತ್ಮಸ್ ಸಾಕ್ಷಿ ಹುಯಿರೋಸ್” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","ಯೆಹೂದ್ಯರ್‌ನ ಗಲ್‌ಢೊಖ್ಹಾರು ಆ ವಾತ್ನ ಖ್ಹಮ್‌ಜಿನ್‌ ಘಣು ಚ಼ಂಢಾಳ್ ಛ಼ಡಿನ್ ಅಪೊಸ್ತಲರ‍್ನ ಮಾರಿನಾಕ್ಣು ಕರಿ ಥೂ. ");
INSERT INTO vaa_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","ತದೆ ಅಖ್ಖಾ ಅದ್ಮಿನಿ ಮರ್ಯಾದಿಥಿ ನ್ಯಾವ್ನಿಸಬೆನೊ ಘಲ್ಡೊ ಗಮಲಿಯೇಲಕರಿ ಏಕ್‍ಜ಼ಣೊ ಫರಿಸಾಯರ್‌ವಾಳೊ ಘಲ್ಡಿ ಸಭೆಮ ಉಠಿಭೀರಿನ್ ಆ ಅದ್ಮಿಖ್ಹಾರನ ಜ಼ರಘಡಿ ಭಾರ್‌ ಮೋಕ್ಲೊಕರಿ ಹುಕುಮ್‌ ದಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","ತದೆ ಇನೆ ಸಬೆವಾಳನ; ಇಸ್ರಾಯೇಲ್ ಅದ್ಮಿವೊ, ತುಮೆ ಶಾತ್‌ ಕರ್ನುಕರಿ ಛಾ಼ಕಿ ಇನಿ ಬಾರೇಮ ಹೊಷಾರ್‌ಥಿ ರ‍್ಹವೊ. ");
INSERT INTO vaa_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","ಅನೇಥಿ ಅಗಾಡಿ ಥೈದಕರಿ ಏಕ್‌ಜ಼ಣಾನೆ ಮೇ ಮೋಟೊ ಅದ್ಮಿಕರಿ ಬೋಲಿಲೀದೊ. ಇನಿ ಜೋ಼ಡ್ಮ ಖ್ಹುಮಾರ್ ಚಾರ್ ಖ್ಹೋ ಅದ್ಮಿ ಮಳಿರ‍್ಹುಥು. ತ್ಯೋಬಿ ಯೋ ಮರೈಗಯೊ. ಅಜು಼ ಇನ ನಂಬಿಹುಯು ಅಖ್ಖೂಸ್ ಎಕ್ಕೋಸ್ಏಕ್‌ ಮಿಲೈಗು. ");
INSERT INTO vaa_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","ಇನಕೇಡೆಥು ಯೂದಕರಿ ಏಕ್‍ಜ಼ಣೊ ಗಲಿಲಾಯಮ ಥೊ, ತದೆ ಅದ್ಮಿನಿ ಗಣ್ತಿನ ಹಗಾಮ್ ಹುಯಿರಾಥ. ಯೂದಬಿ ಇನ ನಂಬಾವಳಾನು ಏಕ್‌ ಝೂ಼ಂಡ್‌ ಭಾಂದ್ಯೊ. ಯೋಬಿ ಮರೈಗಯೊ. ಇನ ನಂಬಿಹುಯು ಖ್ಹಾರೂಬಿ ಎಕ್ಕೋಸ್ಏಕ್‌ ಮಿಲೈಗು. ");
INSERT INTO vaa_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","ಇನಖ್ಹಾಜೆ ಮೇ ಹಮ್ಕೆ ತುಮೂನ ಶಾತ್ ಬೋಲಸ್‍ಕತೊ ಆ ಅದ್ಮಿವ್‌ಥಿ ದೂರ್ ರ‍್ಹವೊ ಇವ್ಣುನ ಮ್ಹೇಲಿದೆವೊ; ಶನಕತೊ ಆ ಖ್ಹೂಜ಼್ ನತರ್ ಕಾಮ್ ಅದ್ಮಿಥಿ ಹುಯಿರ‍್ಹು ಉಷೇತೊ ಇನು ಯೋಸ್ ಪಡಿಜಾ಼ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","ಕತೋಬಿ ಯೋ ದೇವ್‍ಥಿ ಹುಯಿರ‍್ಹವಾನು ಉಷೇತೊ ಇನ ಹರಾವನ ತುಮಾರೇಥಿ ಕೋಉಷೇನಿ; ತುಮೆ ದೇವ್ನವಿರುದ್ ಜಂಗ್‍ಭೀಡಾನಿಮತ್ ದೆಖೈಲಿಶು ಕರಿ ಬೋಲ್ಯೊ.ಇವ್ಣೆ ಗಮಲಿಯೇಲನಿ ಆ ವಾತೆನ ಮಾನಿಲಿದು. ");
INSERT INTO vaa_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","ಅಪೊಸ್ತಲರ‍್ನ ಬುಲೈಮಂಗೈನ್‌, ಮಾರ್‌ಖಡೈನ್‌, ಯೇಸುನು ನಾಮ್‍ಲೀನ್ ವಾತೆ ನಕೊಬೋಲ್‍ಶು ಕರಿ ಹುಕುಮ್‌ ದೀನ್ ಇವ್ಣುನ ಮ್ಹೇಲಿದಿದು. ");
INSERT INTO vaa_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","ಅಪೊಸ್ತಲರ್ ನ್ಯಾವ್‍ನಿ ಘಲ್ಡಾನಿ ಸಭೆಮಾಥು ನಿಕ್ಳಿನ್ ಚ಼ಲೇಗಯ. ಯೇಸುನ ನಾಮ್ನಖ್ಹಾಜೆ ಖ್ಹರಮ್‌ ಕಡೈಲ್ಯಾವಾನ ಹಮೆಯೋಗ್ಯರ್ ಹುಯಾಕರಿ ಖುಷಿಕರ‍್ಯು. ");
INSERT INTO vaa_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","ಇವ್ಣೆ, ಅದ್ಮಿಮ ಬೋಧನೆ ಕರಾನು ಭೀರಾಖ್ಯಕೊಯ್ನಿ. ಯೇಸುಸ್ ಕ್ರಿಸ್ತಕರಿ ಅದ್ಮಿನ ಸುವಾರ್ತೆ ಶಿಕಾಡನ ಶುರುಕರ‍್ಯ. ಇವ್ಣೆ ಹರ್‌ರೋಜ಼್ ದೇವ್ನ ಮಂದಿರ್‌ಮಾಬಿ, ಘರೂಮಾಬಿ ಬೋಧನೆ ಫೈಲಾಯು. ");
INSERT INTO vaa_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","ಯೋ ದನ್ಮ ಯೇಸುನ ಶಿಷ್ಯರ್‌ನಿ ಗಣ್ತಿ ಜಾ಼ಖ್ಹತ್ ಹೋತು ಆಯು, ಕತೋಬಿ ಯೊ ವಖ್ಹತ್‌ಮ ಗ್ರೀಕ್ ಬೋಲವಾಳ ಯೆಹೂದಿ ಶಿಷ್ಯರ‍್ನೆ, ಇಬ್ರಿಯ ಬೋಲವಾಳ ಯೆಹೂದಿನಿ ಬಾರೇಮ ಹರೇಕ್ ರೋಜ಼್ ಶಿಷ್ಯರ‍್ನ ದೇವ್ಣುಥೂತೆ ತಿನಮಾಥು ಹಮಾರಿ ಮುಂಡಚ್ಚಿಯೆನ ಮಳ್‌ಣುತೆ ಮದತ್ ಬರೋಬರ್‌ಥಿ ಮಳುಕರಕೊಯ್ನಿ ಕರಿ ಭಣ್‌ಕ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","ತದೆ ಭಾರಜ಼ಣ ಅಪೊಸ್ತಲರ್ ಖ್ಹಾರು ಅಖ್ಖಾಸ್ ಶಿಷ್ಯರ್‌ನ ಟೋಳ್ನ ಸಭೆ ಬುಲೈನ್ ಇವ್ಣುನ, “ದೇವ್ನಿ ವಚನ್ ಬೋಧನೆ ಕರಾನು ಅಪ್ಣು ಕಾಮ್. ಕತೋಬಿ ಯೊ ಕಾಮ್ ಭೀರಿಜಾ಼ವಾನು ಬರೋಬರ್ ಕೊಯ್ನಿ; ಅಪ್ಣೆ ಅದ್ಮಿಖ್ಹಾರನ ಖಾವಪೀಯಾನಿ ಮದತ್‌ಥೀಬಿ ದೇವ್ನಿ ವಚನ್ನು ಬೋಧನೆನ ಅಗಾಡಿ ಭಡಾವನು ಅಛ್ಛು಼. ");
INSERT INTO vaa_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","ಇನಖ್ಹಾಜೆ ಭೈಯೇವೊ ತುಮಾರಮ ಸಾಕ್ಷಿಥಿ ಜಿವವಾಳ ಖ್ಹಾತ್ ಜ಼ಣಾನ ಚೂ಼ಣಿಲೇವೊ. ಇವ್ಣೆ ಅದ್ಮಿಮ ಪವಿತ್ರಾತ್ಮಥಿ ಭರೈರ‍್ಹವಾಳ ಹುಯಿರ‍್ಹೇಣು ಅಜು಼ ಅಕ್ಲಿ ಹುಯಿರ‍್ಹೇಣು,ಇವ್ಣುನ ಹಮೆ ಆ ಕಾಮ್ ದಿಯೇಸ್. ");
INSERT INTO vaa_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","ತದೆ ಹಮಾರಿ ಖ್ಹಾರೀಸ್‍ ವೇಳ್ನ ಪ್ರಾರ್ಥನೆ ಕರಾನಬಿ ವಚನ್ನ ಬೋಧನೆ ಕರಾನು ಕಾಮ್ ದಿಶು” ಕರಿ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","ಆ ವಾತೆ ಅಖ್ಖಾಸ್ ಝೂ಼ಂಡ್‌‍ವಾಳಾನೆ ಅಛ್ಛು಼ಕರಿ ಸೋಚ್ಯು. ಇವ್ಣೆ ಪವಿತ್ರಾತ್ಮಥಿ ಭರಾಯೊಹುಯೊ. ಘಣು ವಿಶ್ವಾಸ್‌ವಾಳೊ ಹುಯಿರ‍್ಹೋತೆ. ಸ್ತೆಫನನಾಬಿ, ಫಿಲಿಪ್, ಪ್ರೊಖೋರ, ನಿಕನೋರ, ತಿಮೋನ, ಪರ್ಮೇನ, ಯೆಹೂದ್ಯರ್‌ನಿ ಜಾ಼ತ್‌ಮ ಮಳಿರ‍್ಹೋತೆ, ಅಂತಿಯೋಕ್ಯ ಗಾಮ್‌ವಾಳೊ ನಿಕೊಲಾಯ ಕರಿ ಅವ್ಣುನ ಚೂ಼ಣಿನ್ ಅಪೊಸ್ತಲರ‍್ನ ಖ್ಹಾಮ್ಣೆ ಭಿರಾಖ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","ಅಪೊಸ್ತಲರ‍್ನೆ ಇವ್ಣಾಪರ್ ಹಾತ್‍ ಮ್ಹೇಲಿನ್ ಪ್ರಾರ್ಥನೆ ಕರೀನ್ ಯೊ ಕಾಮ್ನಖ್ಹಾಜೆ ಇವ್ಣುನ ಖ್ಹಣೇದ್‌ ಕರ‍್ಯು. ");
INSERT INTO vaa_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","ದೇವ್ನಿ ವಚನ್ ಘಣು,ಘಣು, ಅದ್ಮಿಖ್ಹಾರಾನ ಪೋಚ್ಯು. ಯೆರೂಸಲೇಮ್ಮ ಶಿಷ್ಯರ್‌ನಿ ಗಣ್ತಿ ಘಣು ಭಡ್ತುಗಯು. ಯಾಜಕವ್‌ಮಾಬಿ ಘಣು ಅದ್ಮಿ ಯೇಸುನ ವಿಶ್ವಾಸ್‌ಮ ಮಳ್ತುಗಯು. ");
INSERT INTO vaa_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","ಸ್ತೆಫನ ದೇವ್ನಿ ವಾರ್‌ಖ್ಹಾಥೀಬಿ ಶಕಥ್ಥಿಬಿ ಭರೈರ‍್ಹವಾಳೊಹುಯಿನ್ ಅದ್ಮಿಖ್ಹಾರಾಮ ಘಣು ಅದ್ಭುತ್‌ಕಾಮ್‍ಬಿ, ಖ್ಹಣೇದ್‍ನು ಕಾಮ್‍ಬಿ ಕರ್ತೊಥೊ. ");
INSERT INTO vaa_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","ಕತೋಬಿ ‘ಛುಟ್ಕಾರ್‌ ಹುಯಿರಾಸ್‌’ ಕರಿ ಸಬೇನು ಸಬೆವಾಳು ಕುರೇನ್ಯವಾಳು, ಅಜು಼ ಅಲೆಕ್ಸಾಂಡ್ರಿಯವಾಳು, ಯೆಹೂದ್ಯರ್‌ಖ್ಹಾರು ಇವ್ಣೆ ಅಜು಼ ಥೋಡು ಕಿಲಿಕ್ಯ ಅಜು಼ ಏಷ್ಯಾ ತಬರ್‌ಖಾನು ಯೆಹೂದ್ಯರ್ ಉಠೀನ್ ಸ್ತೆಫನನಿ ಜೋ಼ಡ್ಮ ಅಬ್ಬಾಜ಼ಬ್ಬಿ ಬೋಲಲಗ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","ಕತೋಬಿ ಇನಿ ವಾತ್ಮ ದೆಖಾಯುತೆ ಗ್ಯಾನ್ನಾಬಿ ಪವಿತ್ರಾತ್ಮನಿ ಶಕತ್‍ನಾಬಿ ಅರಾಬರು ಬೋಲಾನ ಇವ್ಣುನ ಕೋಹುಯುನಿ. ");
INSERT INTO vaa_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","“ಸ್ತೆಫನನೆ, ಮೋಶೆನಾಬಿ ದೇವ್‍ನಾಬಿ ಖರಾಬ್‌ವಾತೆ ಬೋಲಸ್ ಯೋ ಅಖ್ಖು ಹಮೇಸ್ ಖ್ಹಮ್‍ಜಿರಾಖ್ಯಸ್” ಕರಿ ಅಖ್ಖಾಸ್ನ ಬೋಲ್ನುಕರಿ, ಥೋಡಜ಼ಣಾನ ಇವ್ಣೆ ಪೈಶ ದೀನ್ ಮನ್ ಫರಾಯು. ");
INSERT INTO vaa_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","ಅದ್ಮಿವ್‌ನಾಬಿ, ಯೆಹೂದ್ಯರ್‌ನ ಗಲ್‌ಢ ಖ್ಹಾರಮಾಬಿ, ಅಜು಼ ಧರ್ಮಾನು ಬೋಧನೆ ಕರವಾಳನಾಬಿ ಕಲಾವ್ಣಿಕರಾಯು. ಇವ್ಣೆಖ್ಹಾರು ಘಣ ಇರಾದೇಥಿ ಅಯಿನ್ ಸ್ತೆಫನನ ಧರಿಲೀನ್ ಯೆಹೂದ್ಯರ್‌ನ ನ್ಯಾವ್‍ನಿ ಸಭೆಮ ಲೀನ್‌ಗಯು. ");
INSERT INTO vaa_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","ತದೆ ಇವ್ಣೆ, ಥೋಡ ಸಾಕ್ಷಿ ಬೋಲವಾಳಾನ ಬುಲೈಲಾಯಿನ್‌ “ಆ ಅದ್ಮಿ ಆ ಪವಿತ್ರ ಝ಼ಗೋನ ವಿರುದ್ಧಹುಯಿನ್, ಮೋಶೆನಿ ಧರ್ಮಶಾಸ್ತ್ರನ ವಿರೋದ್ ಹುಯಿನ್ ಕದೇಬಿ ಝೂ಼ಟಿ ವಾತೆ ಬೋಲಸ್. ");
INSERT INTO vaa_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","ನಜ಼ರೇತ್‌ವಾಳೊ ಯೇಸು ಆ ದೇವ್ನಿಮಂದಿರ್‌ನ ರಡ್‌ಕೈನ್‌ ಮೋಶೆನಿ ಪದತ್ತಿನ ಅಖ್ಖಾನ ಬದ್ಲವ್‍ಕರಸ್‍, ಕರಿ ಆ ಬೋಲಸ್ತೆ ಹಮೆ ಖ್ಹಮ್‌ಜ್ಯ” ಕರಿ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","ನ್ಯಾವ್‌ನ ಸಭೆಮ ಬೇಠುಹುಯು ಖ್ಹಾರೂಸ್ ಸ್ತೆಫೆನನ ಮ್ಹೋಡಾನ ಠರ್‌ಕೈನ್ ದೇಖಾತೊ ಇನು ಮ್ಹೋಡು ದೇವ್ನ ದೂತನ ಮ್ಹೋಡಾನಿತರ ದೆಖವ್‌ಕರ್ತುಥು. ");
INSERT INTO vaa_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","ತದೆ ಮಹಾಯಾಜಕನೆ ಸ್ತೆಫನನ, “ಆ ಖಬರ್ ಖ್ಹಾಚು಼ಕಿ ಶು? ಕರಿ ಬೋಲ್ಯೊ. ತದೆ ಇನೆ ಅಮ್ ಜ಼ವಾಬ್ ದಿದೊ, ಮಾರ ಬಾ ಭೈಯೇವೊ, ಮಾರಿ ವಾತೇನ ಖ್ಹಮ್‍ಜೊ, ");
INSERT INTO vaa_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","ಅಪ್ಣೊ ಗುರುಗುರಬ್‌ಲ್ಯೊ ಹುಯಿರುತೆ ಅಬ್ರಹಾಮ್‌ನ ಅಪ್ಣೊ ಮಹಿಮೆನೊ ದೇವ್ ದೇಖಾಯೊ. ಅಬ್ರಹಾಮ್ ಖಾರಾನ್‍ ಗಮ್ಮ ಜಿವ್ಣುಕರಾನ ಪಹಿಲೆ ಮೆಸಪಟೋಮಿಯಮ ಥೊ. ");
INSERT INTO vaa_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","ದೇವ್ನೆ ಇನ ತೂ ‘ತಾರ ದೇಖ್ಹ್‌ನಾಬಿ ಮಾಯಮಾತ್ರನ ಮ್ಹೇಲಿನ್ ಮೇ ವತಾಳುತೆ ದೇಖ್ಹ್‌ನ ನಿಕ್‌ಳಿ ಜಾ಼’ ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","ಇನಖ್ಹಾಜೆ ಅಬ್ರಹಾಮ್‌ನೆ ಕಲ್ದಿಯ ದೇಖ್ಹ್‌ನ ಮ್ಹೇಲಿನ್ ಖಾರಾನ್‌ಮ ಜಿವ್ಣುಕರಾನ ಗಯೊ; ಅಬ್ರಹಾಮ್‌ನೊ ಬಾ ಮರಾನ ಬಾದ್ಮ ದೇವ್ನೆ ಇನ ಹಮ್ಕೆ ತುಮೆ ಜಿವ್ಣುಕರುಕರಾಸ್ತೆ ಆ ದೇಖ್ಹ್‌ನಾಸ್ ಬೋಲಿಮೋಕ್‌ಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","ಇಮ್ಮಸ್ ಆ ದೇಖ್ಹ್‌ಮ ಇನ ಹತೇಳಿಯೆತ್ರೆ ಝ಼ಗೋಬಿ ಶೊಂತ್‌ಕರಿ ದಿದೊಕೊಂತೆ; ಇನ ಲಡ್ಕಾಕೊಂತೆ ತದೇಸ್‌ ತೂ ಛಾ಼ತೆ ದೇಖ್ಹ್‌ನ ತುನಾಬಿ ತಾರಿ ಆವ್‌ಶೇತೆ ಖ್ಹಾಮ್ಣೇನಿ ಪಿಳ್ಗಿನ ಹಾತ್ಮ ದೇವ್‍ಕರೂಸ್‍ಕರಿ ವಾಗ್ದಾನ್ ಕರ‍್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","ಎತ್ರೇಸ್ ಕಾಹೆತೆ ದೇವ್ನೆ ಇನ ಜೋ಼ಡ್ಮ ಬೋಲ್ಯೊತೆ ಶಾತ್‌ಕತೊ ತಾರು ಪಿಳ್ಗಿವಾಳು ಬಿಜೇಕ್ ದೇಖ್ಹ್‌ಮ ಜಿವ್ಣುಕರ್ಶೆ, ಹಿಜ಼್ಜಾನು ಅದ್ಮಿಖ್ಹಾರು ಇವ್ಣುನ ಗುಲಾಮ್‌ಕರೀಲಿನ್ ಚಾರ್‌ಖ್ಹೊ ವರಖ್ಹ್‌ಲಗು ಖ್ಹತಾವ್‌ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","ಕತೋಬಿ ‘ತಾರು ಖಾನ್‌ದಾನ್‌ವಾಳು ಗುಲಾಮ್‌ಹುಯಿನ್ ಚಾ಼ಕ್ರಿಕರುಕರಾತೆ ಅಲ್ಹಾವ್‌ ಅದ್ಮಿನ ಮೇಸ್ ತೀರ್ಪ್‌ ದೀಶ್‍ಕರಿ ಬೋಲ್ಯೊ. ಅತ್ರೇಸ್ ಕಾಹೆತೆ ದೇವ್ನೆ, ಇನಪಾರ್ ಇವ್ಣೆ ಯೊ ದೇಖ್ಹ್‌ಮಾಥು ಆ ಝ಼ಗೋಮ ಐನ್ ಮನ ಆರಾದನೆ ಕರ್ಶೆಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","ಇನವಾರ್ ದೇವ್ನೆ ಅಬ್ರಹಾಮ್‍ಥಿ ಒಪ್ಪಂದ ಕರಿಲಿದೊ. ಯೊ ಖ್ಹಣೇದ್ನ ಖ್ಹಾಜೆ ಖ್ಹತ್ನ ಕರಾಯೊ. ಇನೇಥಿಸ್ ಅಬ್ರಹಾಮ್‌ನ ಏಕ್‌ ಛಿಯ್ಯೊ ಹುಯೊ. ಯೊ ಛಿಯ್ಯಾನ ಆಟ್ನ ದನ್ಮ ಖ್ಹತ್ನ ಕರ‍್ಯೊ. ಇನು ನಾಮ್ ಇಸಾಕ್. ಇಮ್ಮಸ್ ಇಸಾಕಬಿ ಇನ ಛಿಯ್ಯೊ ಯಾಕೋಬ್‍ನ ಖ್ಹತ್ನ ಕರ‍್ಯೊ. ಅಜು಼ ಯಾಕೋಬ್‍ನೆ ಇನ ಖ್ಹಾರಾಸ್ ಪರ್ಖ್ಹಾ ಲಡ್ಕಾವ್‍ನ ಖ್ಹತ್ನ ಕರ‍್ಯೊ. ಆ ಪರ್ಖ್ಹಾ ಲಡ್ಕಾಸ್ ಖ್ಹಾಮ್ಣೆ ಭಾರಜ಼ಣ ಗುರುಗುರುಬ್‌ಲ್ಯ ಹುಯು. ");
INSERT INTO vaa_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","ಯಾಕೋಬನ ಛಿಯ್ಯಾವ್‌ನೇಸ್ ಯೋಸೇಫನ ಉಪ್ಪರ್ ಬಳಾಪೊ ಕರ‍್ಯು. ಇವ್ಣೆಖ್ಹಾರು ಯೋಸೇಫನ ಧರೀನ್ ಈಜಿಪ್ಟ್‌ನ ಅದ್ಮಿನು ಗುಲಾಮ್ ಬಣೈನ್ ವೇಚಿನಾಖಿದಿದು. ಕತೋಬಿ ದೇವ್ ಯೋಸೇಫನ ಜೋ಼ಡ್ಮಾಸ್ ಥೊ. ");
INSERT INTO vaa_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","ಅಜು಼ ಇನ ಆಯೂತೆ ಮುಶ್ಕಿಲ್‌ಥಿ ಛೋ಼ಡೈನ್. ಈಜಿಪ್ಟ್ ದೇಖ್ಹ್‌ನೊ ರಾಜ಼ನ ಖ್ಹಾಮ್ಣೆ ಅಕ್ಕಲ್‌ವಾಳೋಬಿ ದಯಾಕರವಾಳೊಬಿ ಹುವಾನಿತರ ಕರ‍್ಯೊ.ಫರೋಹನೆ ಯೋಸೆಫ್‌ನ ಈಜಿಪ್ಟ್ ದೇಖ್ಹ್‌ನಪರ್‌ಬಿ ಮಹೇಲ್‌ನಪರ್‌ಬಿ ಅಧಿಕಾರಿಕರಿನ್ ನೇಮ್‌ಶಾಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","ತದೆ ಈಜಿಪ್ಟ್ ಅಜು಼ ಕಾನಾನ್ ದೇಖ್ಹ್‌ಮ ಕಾಳ್ದುಕಾಳ್ ಪಡೀನ್ ಜಾ಼ಖ್ಹತ್ ಅದ್ಮಿನ ಖ್ಹತಾಪ್ಣಿ ಹುಯು. ಖಾಣುಕೊಂತೆ ಅಪ್ಣ ಗುರುಖ್ಹಾರಾನ ಘಣು ಮುಶ್ಕಿಲ್‍ಹುಯು. ");
INSERT INTO vaa_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","ಕತೋಬಿ ಈಜಿಪ್ಟ್‌ಮ ಅನಾಜ಼್ ಛಾ಼ ಕರಿ ಬೋಲಾನು ಖಬರ್‌ನ ಖ್ಹಮ್‌ಜಿನ್‌ ಯಾಕೋಬನೆ ಪಹಿಲಿಬಾರ್ ಇನ ಛಿಯ್ಯಾವ್‍ನ ಹಿಜ್ಜಾ಼ ಮೋಕ್‌ಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","ಅಜು಼ ಇವ್ಣೆ ಬೇನಿವಖ್ಹತ್ ಮಳಾನ ಗಯ. ತದೆ ಯೋಸೇಫನೆ ಇನಿ ಖ್ಹಣೇದ್ ಮಳಾನಿತರ ಕರ‍್ಯೊ. ಅಜು಼ ಯೋಸೇಫನ ಘರ್‌ವಾಳಾನಿ ಬಾರೇಮ ಫರೋಹನ ಮಾಲುಮ್‌ ಪಡ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","ಇನಪಾರ್ ಯೋಸೇಫ ಇನೊ ಬಾ ಹುಯಿರೋತೆ ಯಾಕೋಬ್‌ನಾಬಿ ಅಜು಼ ಪಾಚ಼್‌ಉಪ್ಪರ್‌ ಖ್ಹಡ್‌ತೀನಿಖ್ಹ್ ಜ಼ಣು ಮಾಯಮಾತ್ರ ಖ್ಹಾರಾನ ಈಜಿಪ್ಟ್ ದೇಖ್ಹ್‌ಮ ಬುಲೈಲಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","ತದೆ ಯಾಕೋಬಬಿನ್ ಇನ ಛಿಯ್ಯಾ ಇವ್ಣೆ ಮರಾಲಗೂಬಿ ಈಜಿಪ್ಟ್‌ಮಾಸ್ ಥು. ");
INSERT INTO vaa_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","ಇನಪಾರ್ ಇನ ಶರೀರ್‌ನ ಶೇಕೆಮ್ಮ ಲೀನ್‌ ಜೈ಼ನ್, ಹಿಜ್ಜಾ಼ ಅಬ್ರಹಾಮ್‌ನೆ ಹಾಮೋರ‍್ನ ಛಿಯ್ಯಾಕನ ರೂಪಾನ ರಪ್ಯಾದೀನ್ ಮೋಲ್ ಲಿದೊಥೋತೆ ಝ಼ಗೋಮ ಮಖ್ಹಾಣ್ಯು ಕರ‍್ಯು. ");
INSERT INTO vaa_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","ಕತೋಬಿ ದೇವ್ನೆ ಅಬ್ರಹಾಮ್‍ಥಿ ವಾಗ್ದಾನ ಕರ‍್ಯೊತೆ ವೇಳ್ ಆವಾನಿ ವಖ್ಹತ್ ಈಜಿಪ್ಟ್‌ಮ ಅಪ್ಣು ಯೆಹೂದ್ಯರ್ ಭಡೀನ್ ಜಾ಼ಖ್ಹತ್ ಹುಯು. ");
INSERT INTO vaa_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","ತದೆ ಈಜಿಪ್ಟ್‌ಮ ಬಿಜೇಕ್ ರಾಜ಼ ರಾಜ಼್‌ಭಾರ್ ಕರಾನ ಆಯೊ. ಇನ ಯೋಸೇಫನಿ ಬಾರೇಮ ಶಾತ್ಬಿ ಮಾಲುಮ್‍ಕೋಥುನಿ. ");
INSERT INTO vaa_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","ಆ ರಾಜ಼ನೆ ಅಪ್ಣ ಗುರುಖ್ಹಾರಪರ್‌ ಬಳಾಪೊ ಕರೀನ್ ಇವ್ಣ ಪೈದಾಖ್ಹ್‌ನ ಲಡ್ಕಾವ್‍ನ ಮರ್‌ನಾಕ್ಣುಕರಿ ಭಾರ್‌ ಕಡೈನಾಖ್ಯೊ.ಅಜು಼ ಅಪ್ಣ ಗುರುಖ್ಹಾರಾನ ಘಣು ಖ್ಹತಾಯು. ");
INSERT INTO vaa_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","ಆ ಹಗಾಮ್ಮಾಸ್ ಮೋಶೆ ಪೈದಹುಯೊ. ಯೊ ಘಣು ಶನ್‍ಗಾರ‍್ನೊ ಥೊ ಅಜು಼ ಯೊ ಇನ ಬಾನ ಘರ್‌ಮ ತೀನ್ ಮಹಿನಲಗು ಪಳ್ಯೊ, ");
INSERT INTO vaa_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","ತದೆ ಇವ್ಣೆ ಮೋಶೆನ ಭಾರ್‌ ಕಾಡ್‍ನಾಖಮ ಫರೋಹನಿ ಛೋ಼ರಿ ಇನ ಪಾಡಿಲಿಜೈನ್ ಇನೊ ಶೊಂತ್ ಛಿಯ್ಯಾನಿ ಮತ್‍ ಪಾಳಿ. ");
INSERT INTO vaa_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","ಈಜಿಪ್ಟ್‌ವಾಳು ಮೋಶೆನ ಇವ್ಣುನ ಮಾಲುಮ್‍ಥೂತೆ ಹರೇಕ್ ಪಢಂತ್‍ನ ಶಿಕಾಡ್ಯು. ಯೋ ಅಕ್ಕಲ್‌ಮ ವಾತೆ ಬೋಲಾಮ ಅಜು಼ ಕಾಮ್ ಕರಾಮಾಬಿ ಜಾ಼ಖ್ಹತ್ ಅಕ್ಲಿಹುಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","ಯೊ ಚಾ಼ಳಿಖ್ಹ್ ವರಖ್ಹ್‌ನೊ ಹುಯೊ ತದೆ ಇನ ಇಸ್ರಾಯೇಲ್ ಭೈಯೇನ ಮಳಾನು ಅಛ್ಛು಼ಥು ಕರಿ ದಿಲ್‌ಮಹುಯು. ");
INSERT INTO vaa_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","ತದೆ ಈಜಿಪ್ಟ್‌ವಾಳು ಏಕ್‍ಜ಼ಣು ಇಸ್ರಾಯೇಲ್‌ವಾಳ ಏಕ್‍ ಜ಼ಣಾನ ಗಲತ್‌ಥಿ ಘಣು ಖ್ಹತಾಪ್ಣಿ ದೇವ್‍ಕರ್ತುಥುತೆ ಇನ ಮೋಶೆನೆ ಮಾರಿನ್ ಬದಲ್ ಕಾಡಿಲಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","ಅಮ್ಮಸ್ ದೇವ್ನೆ ಇನ ಹಾತೇಥಿ ಬಚಾ಼ವ್‍ಶೆ ಕರಿ ಇನ ಭೈಯೇನ ಮಾಲುಮ್‌ಪಡ್‍ಶೆ ಕರಿ ಲ್ಹಾಯೋಥೊ ಕತೋಬಿ ಇವ್ಣೆ ಮಾಲುಮ್ ಕೋ ಕರ‍್ಯಥಾನಿ. ");
INSERT INTO vaa_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","ಇನವ್ಹಾಣೆ ಮೋಶೆನೆ ಯೆಹೂದ್ಯರ್‌ನ ಬೇಜ಼ಣ ಮಾರಮಾರಿ ಖಾವಾನು ದೇಖ್ಯೊ. ಇವ್ಣುನ ಖ್ಹಮ್‍ಜಾ಼ಡಾನಟೇಕೆ ‘ದೋಸ್ತಿವೊ ಭೈಯೇ ಭೈಯೇಸ್ ಹುಯಿರಾಸ್! ತುಮೆ ಏಕ್‌ಥಿಏಕ್ ಠಗಾವಾನು ಶನಕರೋಸ್‌? ಕರಿ ಇವ್ಣುನ ಸಮಾಧಾನ್ ಕರಾನ ಆಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","ಬಿಜೇಕ್ ಜ಼ಣೊ ಗಲತ್‌ ಕರಾವಾಳೊ ಏಕ್‍ಜ಼ಣೊ ಮೋಶೆನ ಪೀಠೆ ಧಕೇಲ್‍ತೊ ಹುಯಿನ್, ತುನ ಹಮಾರಪರ್‌ ಅದಿಕಾರಿ ಕರೀನ್‌ಬಿ, ನ್ಯಾವ್ಣೊ ಕರೀನ್‌ಬಿ ಮ್ಹೇಲ್ಯುತೆ ಕೋಣ್‌? ");
INSERT INTO vaa_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","ಕಾಲೆ ಯೊ ಈಜಿಪ್ಟ್‌ವಾಳನ ಮಾರ‍್ಯೂತೆ ತಿಮ್ಮಸ್ ಮನಾಬಿ ಮಾರಿನಾಕ್ಣು ಕರಿ ಛಾ಼ಕಿಶು? ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","ಅನ ಖ್ಹಮ್‍ಜ್ಯೊತೆ ಮೋಶೆ ಡರಿನ್ ಈಜಿಪ್ಟ್‌ನ ಮ್ಹೇಲಿನ್ ಮಿದ್ಯಾನ್‍ ದೇಖ್ಹ್‌ಮ ಜೈ಼ನ್ ಖ್ಹಣೇದ್‌ಕೊಂತೆ ಅದ್ಮಿನಿತರ ಜಿವ್ಣು ಕರ‍್ಯೊ. ಹಿಜ್ಜಾ಼ ಯೊ ಬೇ ಪರ್ಖ್ಹಾ ಲಡ್ಕಾನೊ ಬಾಹುಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","ಚಾ಼ಳಿಖ್ಹ್ ವರಖ್ಹ್‌ನೊ ಹುಯೊತದೆ ಸೀನಾಯಿ ಪಹಾಡ್ನ ಖನ್ನೆಥೂತೆ ಜ಼ಂಗಳ್‌ನ ಏಕ್‌ ಕಾಟಾನಿ ಡಾಗ್‌ಮ ಆಗ್‍ನಿ ಝ಼ಲ್‌ಪಟ್‌ ಲಾಗುಕರ್ತುಥುತೆ ಇನಾಮ ದೇವ್‌ನೊ ದೂತ ಇನ ದೆಖಾಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","ಮೋಶೆನೆ ಆಶ್ಚರ್ಯಥಿ ದೇಖಾನ ಖನ್ನೆ ಗಯೊ. ತದೆ ಇನೆ ಪ್ರಭುನೊ ಏಕ್‌ ಅವಾಜ಼್ ಖ್ಹಮ್‍ಜ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","ದೇವ್ನೆಯಿನ, ಮೇಸ್ ತಾರೊ ಗುರುಗುರಬ್‌ಲ್ಯ ಹುಯಿರಾತೆ ಅಬ್ರಹಾಮ್ ಇಸಾಕ್ ಯಾಕೋಬನೊ ದೇವ್‌ ಕರಿ ಬೋಲ್ಯೊ. ಮೋಶೆ ಡರ್‌ಥಿ ಕಾಪಲಗ್ಯೊ. ಯೊ ಟಾಪ್‍ಣ್ಯನಾಬಿ ದೇಖಾನ ಭಾಲಿ ಕೋಥೂನಿ. ");
INSERT INTO vaa_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","ಪ್ರಭುನೆ ಇನ ತಾರು ಖೋಖ್ಹ್‌ಡು ಕಾಡಿನಾಖಿದೆ ಹಮ್ಕೆ ತು ಭಿಯೋತೆ ಝ಼ಗೊ ಪರಿಶುದ್ ಹುಯಿರುಸ್. ");
INSERT INTO vaa_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","ಅದ್ಮಿಖ್ಹಾರು ಈಜಿಪ್ಟ್ ದೇಖ್ಹ್‌ಮ ಜಾ಼ಖ್ಹತ್ ಖರಾಬ್ ಹಾಲತ್ಮ ರ‍್ಹವಾನು ಮೆ ದೇಖಿರಾಖ್ಯೊಸ್. ಮಾರ ಅದ್ಮಿಖ್ಹಾರಾನು ಅಂದ್ರೋಖ್ಹ್‌ನ ಮೆ ಖ್ಹಮ್‍ಜ್ಯೊ. ಮೆ ಇವ್ಣುನ ಬಚಾ಼ಡನಖ್ಹಾಜೆ ಉತ್ರಿರ‍್ಹೋಸ್. ಹಮ್ಕೇಸ್ ಮೆ ತುನ ಈಜಿಪ್ಟ್‌ಮ ಮೋಕ್ಲುಕರುಸ್ ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","ಇವ್ಣೆ ಖೆವ ಮೋಶೆನ ನಕೊಕರಿ ಝಿಟ್ಕಾರಿನ್, ‘ತುನ ಅದಿಕಾರಿ ಕರೀನ್‌ಬಿ, ನ್ಯಾವ್ಣೊ ಕರೀನ್‌ಬಿ ಮ್ಹೇಲ್ಯುತೆ ಕೋಣ್‌?’ ಕರಿ ಕಿನೆ ಬೋಲ್ಯುಕಿ, ಇನಾಸ್ ದೇವ್ನೆ ಡಾಗ್‌ಮ ದೆಖೈನ್ ದೂತಾಥಿ ಅದಿಕಾರಿಬಿ, ಛುಟ್ಕಾರ್‌ ಕರಾವಾಳನಬಿ ನೇಮಕ್‌ ಕರ‍್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","ಇನಖ್ಹಾಜೆ ಮೋಶೆನೆ ಅದ್ಮಿಖ್ಹಾರನ ಈಜಿಪ್ಟ್ ದೇಖ್ಹ್‌ಮಾಥು ಬುಲೈಲಿ ಆಯೊ. ಯೊ ಖ್ಹಣೇದ್‍ನು ಕಾಮ್‌ಖ್ಹಾರು, ಅದ್ಬುತ್‌ಕಾಮ್‌ಖ್ಹಾರಥಿ ಈಜಿಪ್ಟ್‌ಮಾಬಿ ಅಜು಼ ಲಾಲ್‍ದರ‍್ಯಾವ್‍ಮಾಬಿ ಚಾ಼ಳಿಖ್ಹ್ ವರಖ್ಹ್ ಜ಼ಂಗಳ್‌ಮ ಚ಼ಲೈಲಿನ್ ಆಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","ಯೋ ಮೋಶೆನೇಸ್, ದೇವ್ನೆ ಮನ ಉಠಾಡಾನಿ ತರಸ್ ತುಮಾರ ಅದ್ಮಿಮಾಸ್‌ ಏಕ್‌ ಪ್ರವಾದಿನ ತುಮಾರಮಸ್ ಉಠಾಡ್‌ಶೆ, ಕರಿ ಇಸ್ರಾಯೇಲ್‌ನ ಅದ್ಮಿಖ್ಹಾರಾನ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","ಇನೇಸ್ ಸೀನಾಯಿ ಪಹಾಡ್‌ಮ ಇನಿಜೋ಼ಡ್ಮ ವಾತೆಬೋಲ್ಯೊತೆ ದೇವ್ನ ದೂತನಾಬಿ ಅಪ್ಣ ಗುರುಖ್ಹಾರಾನಾಬಿ ಜ಼ಂಗಳ್‌ಮ ಥೂತೆ ಸಬೇಮರ‍್ಹೀನ್ ಜಾನ್ನಿ ವಚನ್ನ ಲೀನ್ ಅಪ್ಣುನ ದ್ಯವಾಳೊ ಹುಯಿರೋಸ್. ");
INSERT INTO vaa_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","ಕತೋಬಿ ಅಪ್ಣೊ ಗುರುಖ್ಹಾರು ಇನಿ ವಾತೆನ ಖ್ಹಮ್‌ಜಾ಼ನ ದಿಲ್‌ಕೊಂತೆ ಇನ ಮ್ಹೇಲಿನ್, ಈಜಿಪ್ಟ್‌ಮ ಪಾಛು಼ ಚ಼ಲೆಜಾ಼ವ್ಣು ಕರಿ ದೇಖ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","ಇವ್ಣೆಖ್ಹಾರು ಆರೋನ್ನ, ‘ಮೋಶೆನೆ ಈಜಿಪ್ಟ್ ದೇಖ್ಹ್‌ ಥು ಬುಲೈಲಾಯೊ. ಕತೋಬಿ ಇನ ಶಾತ್ ಹುಯಿಗಯು ಕರಿ ಹಮೂನ ಮಾಲುಮ್‌ ಕೊಹುಯುನಿ. ಇನಖ್ಹಾಜೆ ಹಮೆ ಖ್ಹಾಮ್ಣೆ ಜಾ಼ವಾನಟೇಕೆ ಅಜು಼ ಹಮುನ ಚ಼ಲಾವನಟೇಕೆ ದೇವ್‌ನು ಮೂರತ್‌ ಕರೀನ್ ದೇ ಕರಿ ಬೋಲ್ಯು’. ");
INSERT INTO vaa_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","ತದೆ ಯೊ ದನ್ಮ ಢಾಂಡನಿಘೊಣಿ ಏಕ್‌ ಫುತ್‍ಳು ಬಣೈನ್ ಇನಖ್ಹಾಮ್ಣೆ ಬಲಿದಿದು. ಅಜು಼ ಮಿಝ಼್‌ವಾನ್ಬಿ ಖಡಾಯು ಯೋ ಅದ್ಮಿಖ್ಹಾರು ಮಗನ್‌ ಹುಯು. ");
INSERT INTO vaa_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","ಇನಖ್ಹಾಜೆ ದೇವ್ನೆ ಇವ್ಣೇಥಿ ಮ್ಹೋಡು ಫರೈನ್, ಆಬ್‌ನ ಶುಕ್ಕರ್‌ನ ಪೂಜ಼ ಕರಿಲ್ಯವಾದೆಕರಿ ಇವ್ಣುನ ಮ್ಹೇಲಿದಿದೊ. ಅನಿಬಾರೇಮ ಪ್ರವಾದಿನ ಪುಸ್ತಕ್‌ಮ ಅಮ್ ಲೀಖೈರುಸ್; ದೇವ್ ಅಮ್‍ ಬೋಲಾಸ್, ಇಸ್ರಾಯೇಲ್‌ನ ಖಾನ್‌ದಾನ್‌ವಾಳವೊ! ತುಮೆ ಚಾ಼ಳಿಖ್ಹ್ ವರಖ್ಹ್‌ಲಗು ಜ಼ಂಗಳ್‌ಮರ‍್ಹಾವಾನಿ ವಖ್ಹ್‌ತೆ ತುಮೆ ಮನ ಬಲಿ ಚ಼ಢಾಯಾಥಾಕಿ ಶು? ");
INSERT INTO vaa_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","ತುಮೆ ತುಮಾರ ಜೋ಼ಡ್ಮ ಮೊಲೋಖ ದೇವ್‌ನು ಡೇರಾನಾಬಿ ಅಜು಼ ರೆಫಾನ್ ದೇವ್ತಿನೊ ಶುಕ್ಕರ್‌ನ ರೂಪ್‍ನು ಫುತ್‍ಳಿನ ಢೊಯಿಲೀನ್ ಆರಾದನೆಕರಾನ ವಳೇಜಾ಼ತಥಾತೆ ಇನಖ್ಹಾಜೆ ಮೆ ತುಮೂನ ಬಾಬಿಲೋನ್ನ ಖ್ಹಾರ್ಕೊಟ್‌ಮ ಮೋಕ್ಲಿದಿಶ್‌ಕರಿ ಲೀಖಿರಾಖ್ಯುಸ್. ");
INSERT INTO vaa_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","ದೇವ್ ರ‍್ಹೆತೊಥೋತೆ ಡೇರೊ ಜ಼ಂಗಳ್ಮ ಅಪ್ಣ ಗುರುಖ್ಹಾರಾಕನ ಥು. ಮೋಶೆನಿ ಜೋ಼ಡ್ಮ ವಾತೆ ಬೋಲ್ಯೊತೆ ದೇವ್‌, ತುನೆ ದೆಖ್ಯೋತೆ ಶಕಲ್ನಿ ಪರಕ್ಮಾಸ್ ಇನ ಕರ್ನುಕರಿ ಹುಕುಮ್ ದಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","ಅಪ್ಣ ಬಾಬ್‍ದಾದ್‍ವ್ನೆ ಇನ ಗುರುಗುರಬ್‍ಲ್ಯಥು ಲಿದು. ಇವ್ಣೆ ಯೆಹೋಶುವನ ಪಾಲನ್‍ ಕರ್ತು ಅಯಿನ್ ದೇವ್ನೆ ಧಕೇಲಿ ದಿದಾಹುಯ ಅಲಕ್ ಅದ್ಮಿನ ದೇಖ್ಹ್‌ನ ಕಬ್‍ಜಾ಼ ಕರಿಲಿದು. ತದೆ ಯೊ ಡೇರಾನ ಘರ್‌ನ ಇವ್ಣ ಜೋ಼ಡ್ಮಾಸ್ ಪಾಡಿಲಿನ್ ಕಾನಾನ್ ದೇಖ್ಹ್‌ಮ ಆಯು. ಅಜು಼ ದಾವೀದನು ಹಗಾಮ್ ಲಗೂಬಿ ಯೊ ಹಿಜ್ಜಾ಼ಸ್ ಥೂ. ");
INSERT INTO vaa_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","ದಾವಿದನೆ ದೇವ್ನಿ ಸನ್ನಿಧಿಮ ದಯಾಲೀನ್ ಯಾಕೋಬ್‍ನಿ ಪಿಳ್ಗಿನಖ್ಹಾಜೆ ಪ್ರಾರ್ಥನೇನಿ ಮಂದಿರ್‌ ಭಾಂದನ ಹುಕುಮ್ ದೇವ್ಣುಕರಿ ದೇವ್ನ ಬಿಂತಿ ಕರಿಲಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","ಕತೋಬಿ ಸೊಲೊಮೋನ್ನೇಸ್ ಪ್ರಾರ್ಥನೇನು ಮಂದಿರ್‌ನ ಭಂದಾಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","ಪ್ರವಾದಿ ಬೋಲಾತೆತಿಮ್ ಪರಮಂಡಲ್‌ನೊ ದೇವ್ ಅದ್ಮಿನ ಭಾಂದಾತೆ ಘರ್‌ಮ ರ‍್ಹವವಾಳೊ ಕಾಹೆ. ");
INSERT INTO vaa_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","ಪ್ರಭುನೆ ಅಮ್‌ ಬೋಲ್ಯೊ, ‘ಸೊರ್ಗ ಮಾರು ಸಿಂಹಾಸನ್ ಜ಼ಮೀನ್ ಮಾರೊ ಗೋಡಾನೊ ರಚ್ಚೊ಼ ತುಮೆ ಮನ ಕಿಮ್ನು ಘರ್ ಭಾಂದ್‍ಶು? ಮಾರು ಅರಾಮ್‌ನ ಬರೋಬರ್‌ನಿ ಝ಼ಗೊ ಕಿಜ್ಜಾ಼ ಛಾ಼? ");
INSERT INTO vaa_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","ಆ ಅಖ್ಖು ಮಾರ ಹಾತ್ನೆಸ್ ಬಣಾವಟ್ ಕರ‍್ಯುನಿ, ಕರಿ ಪ್ರಭುಸ್ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","ಸ್ತೆಫನನೆ ಅಮ್‍ ಬೋಲ್ಯೊಕಿ, “ಮೊಂಡಿಹುಯಿರಾತೆ ತುಮೆ ತುಮಾರ ದಿಲ್ನ ದೇವ್ನ ಕೋ ದಿದಾನಿ ಇನ ಕಾನ್‍ಲಗಾಡ್ಯಾಬಿ ಕೊಯ್ನಿ. ಪವಿತ್ರ ಆತ್ಮಾನ ಕಾಮ್ನ ವಿರುದ್ಧಥಿ ಚಾ಼ಲವಾಳ ಹುಯಿರಾಸ್. ತುಮಾರ ಗುರುಗುರಬ್‍ಲ್ಯ ಕಿಮ್‌ಥಾಕಿ ತುಮೇಬಿ ಇಮ್ಮಸ್ ಹುಯಿರಾಸ್. ");
INSERT INTO vaa_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","ಜಿವ್ತಥಾತೆ ಪ್ರವಾದಿಮ ಖ್ಹಾರಜ಼ಣನ ತುಮಾರ ಗುರುಖ್ಹಾರು ಖ್ಹತಾಯು. ನೀತಿವಾಳೊ ಎಕ್ಕಸ್‍ಜ಼ಣೊ ಹುಯಿರೋತೆ ಯೊ ಪಹಿಲೆಸ್ ಆವ್‍ಶೆಕರಿ ಖ್ಹಮ್‍ಜಾ಼ಯುಥು. ಕತೋಬಿ ತುಮಾರು ಗುರುಖ್ಹಾರು ಯೋ ಪ್ರವಾದಿಖ್ಹಾರನ ಮಾರಿನಾಖ್ಯು. ಹಮ್ಕೆ ತುಮೆ ಧರಿದೀನಸ್ ಇನ ಮರೈನಾಖ್ಯ. ");
INSERT INTO vaa_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","ತುಮೆ ಸೊರ್ಗ ದೂತರ್‌ಥಿ ನೇಮಕ್ ಹುಯೊತೆ ದೇವ್ನು ಧರ್ಮಶಾಸ್ತ್ರನ ಸ್ವೀಕಾರ್ ಕರ‍್ಯಾತೋಬಿ ಇನಿನಿತರ ಚಾ಼ಲ್ಯಕೊಯ್ನಿ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","ಆ ವಾತ್ನ ಖ್ಹಮ್‍ಜ್ಯುತೆ ನ್ಯಾವ್ನಿಸಭೆನು ಘಲ್ಡುಖ್ಹಾರು ಘಣು ಖಿಜೈನ್ ಸ್ತೆಫನನ ಉಪ್ಪರ್ ದಾತ್‍ಚಾ಼ಯು. ");
INSERT INTO vaa_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","ಕತೋಬಿ ಯೊ ಪವಿತ್ರ ಆತ್ಮಥಿ ಭರೈನ್ ಸೊರ್ಗಭಣಿ ದೇಖಿನ್, ದೇವ್ನಿ ಮಹಿಮೆನಬಿ, ದೇವ್ನ ಖಾವಿಬಾಜು಼ಮ ಭಿಯೋತೆ ಯೇಸುನಾಬಿ ದೇಖ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","ತದೆ ಇನೆ, “ದೇಖೊ ಪರ್‌ಲೋಕ್ ನಿಕ್‍ಳೈರ‍್ಹೂತೆ; ಅದ್ಮಿನೊ ಛಿಯ್ಯೊ ದೇವ್ನ ಖಾವಿಬಾಜು಼ಮ ಭಿಯೋತೆ ಮೆ ದೇಖುಕರುಸ್” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","ತದೆ ಯಹುದ್ಯರ್‌ಖ್ಹಾರು ಜೋ಼ರೇಥಿ ಚಿಕ್ರಿನ್, ಕಾನ್ನ ಮೂಚಿಲೀನ್, ಎಕ್ಟುಹುಯಿನ್ ನಾಶಿಆಯಿನ್, ");
INSERT INTO vaa_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","ಇನ ನಂಗರ‍್ನ ಭಾರ್‌ ಧಕೇಲಿಜೈ಼ನ್ ಮಾರಿನಾಖನ ಇನಪರ್ ಬಂಡೊ ಫೇಕ್ಯು. ಇನ ವಿರೋದ್‌ ಸಾಕ್ಷಿ ಬೋಲ್ಯುತೆ ಇವ್ಣೆ ಇವ್ಣ ಝ಼ಗ್ಗಾನ ಕಾಡಿನ್ ಸೌಲಕರಿ ಏಕ್‍ ಜ಼ಣಾನ ಗೋಡಾಕನ ಮ್ಹೇಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","ಸ್ತೆಫನನ ಉಪ್ಪರ್ ಬಂಡೊ ಫೇಕುಕರ್ತುಥೂತೆ ತದೆ ಯೋ ಪ್ರಾರ್ಥನೆ ಕರ್ತೊ ಹುಯಿನ್ “ಯೇಸು ಪ್ರಭು, ಮಾರ ಆತ್ಮಾನ ಸ್ವೀಕಾರ್‌ಕರೀಲೆ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","ಅಜು಼ ಯೊ ಢುಕ್‍ಣ್ಯ ಮಾಂಡೀನ್ ಪ್ರಭು, ಆ ಪಾಪ್ನ ಅವ್ಣಪರ್ ನಕೊ ಲಗಾಡಿಷ್!” ಕರಿ ಜೋ಼ರೇಖ್ಹು ಚಿಕ್ರಿನ್ ಮರಿಗೊ. ");
INSERT INTO vaa_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","ಸ್ತೆಫನನ ಮಾರಿನಾಖನ ಸೌಲನ ಒಪ್ಪಿಕೆಥು. ಯೊ ದನ್ಮ ಯೆರೂಸಲೇಮಥೂತೆ ಸಬೆವಾಳನ ಮೋಟಿ ಖ್ಹತಾಪ್ಣಿ ಪಡ್ಯು. ಅಪೊಸ್ತಲರ್ ನಾಹುಯಿನ್ ಖ್ಹಾರೂಸ್, ಯೂದಾಯ ಸಮಾರ್ಯ ತಬರ್‌ಖಾಮ ಛಿಡ್‍ಕೈಗಯು. ");
INSERT INTO vaa_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","ಥೋಡು ಭಕ್ತರ್‌ ಖ್ಹಾರು ಸ್ತೆಫನನ ಮಖ್ಹಾಣ್ಯು ಕರೀನ್ ಇನಖ್ಹಾಜೆ ಘಣು ರದನ್ ಕರ‍್ಯು. ");
INSERT INTO vaa_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","ಕತೋಬಿ ಸೌಲ ಘರ್ ಘರ್‌ಮ ಪೇಶಿನ್ ತಯೇಡ ಪರ್ಖ್ಹಾ ಖೇಚಿಲಾಯಿನ್ ಜೇಲ್‌ಮ ಧಕೆಲಿನ್ ಸಬೆನ ಅಖ್ಖು ನಾಶ್‌ಕರ್ತೊಥೊ. ");
INSERT INTO vaa_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","ಛಿಡ್‍ಗರ್‌ಪಡಿಗುತೆ ವಿಶ್ವಾಸಿಖ್ಹಾರು ಬಿಜಿಬಿಜಿ ಝ಼ಗೊ ಜೈ಼ನ್ ಸುವಾರ್ತೆನ ಬೋಲ್ತು ನಿಕ್‌ಳ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","ಫಿಲಿಪ್ ಸಮಾರ್ಯಕರಿ ಮುಖ್ಯ ಖ್ಹಯೇರ‍್ನ ಅದ್ಮಿವೊನ ಜೈ಼ನ್ ಕ್ರಿಸ್ತನಿ ಬಾರೇಮ ಬೋಲಿವತಾಳ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","ಝೂ಼ಂಡ್‌ಥಿ ಭರಾಯಹುಯ ಅದ್ಮಿಖ್ಹಾರು ಫಿಲಿಪ್ಫನಿ ವಾತ್ನ ಏಕ್‍ ಮನ್‌ಥಿ ಖ್ಹಮ್‌ಜ್ಯು. ಅಜು಼ ಇನೆ ಕರ‍್ಯೊತೆ ಖ್ಹಣೇದ್ನ ಅಖ್ಖಾ ಕಾಮ್ನ ದೇಖ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","ಶನಕತೊ ಕೆತ್ರಾಕಿ ಜ಼ಣಾಮಾಥೊ ಭೂತ್‌ಖ್ಹಾರು ಜೋ಼ರೇಖ್ಹು ಅವಾಜ಼್‌ಕರೀನ್ ಚಿಕರ್ತು ಹುಯಿನ್ ಭಾರ್‌ ಆಯು; ಬಿಜು಼ ಕೆತ್ರೂಕಿ ಲಕ್ವಾಭರ‍್ಯು, ಪಾಂಗ್‍ಳ್ಯು ಗುಣ್‌ಹುಯು. ");
INSERT INTO vaa_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","ಇನಖ್ಹಾಜೆ ಯೋ ಖ್ಹಯೇರ್‌ಮ ಜಾ಼ಖ್ಹತ್ ಖ್ಹುಶಿಹುಯು. ");
INSERT INTO vaa_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","ಕತೋಬಿ ಥೋಡ ದನ್‍ಥೂ ಯೋ ಖ್ಹಯೇರ್‌ಮ ಸೀಮೋನ್‍ಕರಿ ಏಕ್‍ಜ಼ಣೊ ಥೊ. ಯೋ ಇನ ಜಾ಼ದುಜ಼ಮ್ಕರ್‌ಥಿ ಸಮಾರ್ಯನ ಅದ್ಮಿನ ಆಶ್ಚರ್ಯ ಕರಾಯೊ. ಸಿಮೋನ್ ಇನು ಯೋಸ್ ಮಹಾತ್ಮಕರಿ ಬೋಲಿಲೇತೊಥೊ. ");
INSERT INTO vaa_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","ನ್ಹಾನೇಥಿ ಧರೀನ್ ಮೋಟಾಲಗು ಖ್ಹಾರು; ಆ ಹೈರೋತೆ ಮಹಾನ್ ಶಕತ್‍ಕರಿ ಬೋಲೈರ‍್ಹೋತೆ ದೇವ್‌ನೀಸ್ ಶಕತ್‍ಕರಿ ಬೋಲ್ತುಹುಯಿನ್ ಇನಿವಾತ್ನ ಖ್ಹಮಜ್‍ತೂಥು. ");
INSERT INTO vaa_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","ಘಣಾದನ್‌ಥೂಬಿ ಸೀಮೋನ್ನಿ ಜಾ಼ದುಜಮ್‍ಕರ್‌ಥಿ ಅದ್ಮಿಖ್ಹಾರು ಆಶ್ಚರ್ಯಥಿ ಇನಿ ವಾತ್ನ ಖ್ಹಮಜ್‍ತೂಥು. ");
INSERT INTO vaa_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","ಕತೋಬಿ ಫಿಲಿಪ್ ದೇವ್ನಿ ರಾಜ್ಯನಿ ಬಾರೇಮ ಅಜು಼ ಯೇಸುಕ್ರಿಸ್ತನಿ ನಾಮ್ನಿ ಬಾರೇಮಾಬಿ ಅದ್ಮಿಖ್ಹಾರಾನ ಸುವಾರ್ತೆ ಬೋಲ್ಯೊ. ಪರ್ಖ್ಹೊ ತಯೇಡ ಖ್ಹಾರುಸ್ ಫಿಲಿಪ್ ಬೋಲ್ಯೊತೆ ವಾತೆನ ವಿಶ್ವಾಸ್ ಕರೀನ್ ಬ್ಯಾಪ್ತಿಸ್ಮ ಕರೈಲಿದು. ");
INSERT INTO vaa_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","ತದೆ ಸೀಮೋನ್ನೇಬಿ ವಿಶ್ವಾಸ್‍ಕರಿನ್ ಬ್ಯಾಪ್ತಿಸ್ಮ ಕರೈಲೀನ್ ಅಜು಼ ಫಿಲಿಪ್ಫನಿ ಜೋ಼ಡ್ಮ ಕದೇಬಿ ರ‍್ಹೀನ್ ಯೋ ಕರಾತೆ ಅದ್ಭುತ್‌ ಕಾಮ್ನ ಅಜು಼ ಖ್ಹಣೇದ್ನ ಕಾಮ್ನ ದೇಖಿನ್ ಆಶ್ಚರ್ಯ ಹೋತೊಥೊ. ");
INSERT INTO vaa_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","ಸಮಾರ್ಯವಾಳು ದೇವ್ನಿ ವಚನ್ನ ಮಾನಿಲಿದೂತೆ ಸಮಚಾರ್‌ನ ಯೆರೂಸಲೇಮ್ಮ ಥೂತೆ ಅಪೊಸ್ತಲರ್ ಖ್ಹಾರು ಖ್ಹಮ್‌ಜಿನ್‌ ಪೇತ್ರ ಯೋಹಾನ ಇವ್ಣಕನ ಮೋಕ್‍ಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","ಅವ್ಣೆ ಹಿಜ್ಜಾ಼ ಆಯಿನ್ ಯೋ ಅದ್ಮಿಖ್ಹಾರಾನ ಪವಿತ್ರಾತ್ಮವರನ ಮಳ್‌ಣುಕರಿ ಇವ್ಣಖ್ಹಾಜೆ ಪ್ರಾರ್ಥನೆ ಕರ‍್ಯು. ");
INSERT INTO vaa_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","ಶನಕತೊ ಪವಿತ್ರಾತ್ಮ ಪೇತ್ರ ಯೋಹಾನ ಇವ್ಣ ಏಕ್‍ಜ಼ಣಪರ್‌ಬಿ ಬಿಜೂ಼ಬಿ ಕೋ ಆಯಿರ‍್ಹುಥೂನಿ. ಇವ್ಣೆ ಪ್ರಭು ಹುಯಿರ‍್ಹೋತೆ ಯೇಸುನ ನಾಮ್‍ಪರ್ ಖಲಿ ಬ್ಯಾಪ್ತಿಸ್ಮ ಕರೈರಾಖ್ಯಥ. ");
INSERT INTO vaa_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","ಯೋ ಬೇ ಅಪೊಸ್ತಲರ‍್ನೆ ಇವ್ಣಪರ್ ಹಾತ್ ಮ್ಹೇಲಾಖ್ಹತರ್‌ ಇವ್ಣೆ ಪವಿತ್ರಾತ್ಮನ ಲೀಲಿದು. ");
INSERT INTO vaa_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","ಅಪೊಸ್ತಲರ್ ಖ್ಹಾರು ಅದ್ಮಿಪರ್ ಇವ್ಣ ಹಾತ್ ಮ್ಹೇಲಾದಿನ್ ಅದ್ಮಿಖ್ಹಾರಾನ ಪವಿತ್ರಾತ್ಮ ಮಳಿರ‍್ಹೂತೆ ಸಿಮೋನ್‍ನೆ ದೇಖ್ಯೊ. ಇನಖ್ಹಾಜೆ ಸೀಮೋನ್ನೆ ಪೈಶಾಲಯಿನ್ ಅಪೊಸ್ತಲರ‍್ನ ಖ್ಹಾಮ್ಣೆ ಮ್ಹೇಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","ಅಜು಼ “ಮೆ ಕಿನಾಪರ್ ಹಾತ್ ಮ್ಹೇಲೂಸ್‍ಕಿ ಇವ್ಣೆ ಪವಿತ್ರಾತ್ಮನ ಲೀಲ್ಯಾವಾನಿತರ ಆ ಅದಿಕಾರ್ ಮನಾಬಿ ದೇವೊ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","ಕತೋಬಿ ಪೇತ್ರನೆ ಇನ “ತಾರ ಪೈಶ ತಾರಿಜೋ಼ಡ್ಮ ನಾಶಹುಯಿಜಾ಼ವಾದೆ. ದೇವ್ನಿ ವರಾನ ಪೈಶಾನ ಲಿಯೆಜಾ಼ಯ್ ಕರಿ ಲಾಝ್ಯೊಕಿ ಶು?” ಕರಿ ಜ಼ವಾಬ್ ದಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","ಆ ಕಾಮ್ಮ ತುನ ಭಾಗ್‍ಬಿ ಕೊಯ್ನಿ ವಾಟೊಬಿ ಕೊಯ್ನಿ; ತಾರೊ ದಿಲ್‌ ದೇವ್ನ ಖ್ಹಾಮ್ಣೆ ಬರೋಬರ್ ಕೊಯ್ನಿ. ");
INSERT INTO vaa_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","ಇನಖ್ಹಾಜೇಥಿ ಆ ತಾರ ಖರಾಬ್ ಕಾಮ್ನ ಮ್ಹೆಂದಿನ್ ದೇವ್‌ಭಣಿ ಫರಿಜೈನ್, ಅಜು಼ ಪ್ರಾರ್ಥನೆ ಕರೀಲೆ. ಪ್ರಭು ತಾರ ದಿಲ್ನಿ ಖ್ಹಯಾಲ್ನ ಮಾಪ್‌ಕರ್ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","ಶನಕತೊ ತೂ ಜಾ಼ಖ್ಹತ್ ಕಡ್‌ವ್ಹಾಟ್‌ನಿ ಬಳಾಪೆಥಿಬಿ ಭರೈರ‍್ಹಾವಾಳೊ, ಝರೇಲಿ ಅನೀತಿಥಿಬಿ ಭರೈರ‍್ಹೋತೆ ಮೇ ದೇಖುಕರುಸ್ ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","ಇನ ಸೀಮೋನ ಅಜು಼ ಪೇತ್ರ ಇವ್ಣ ಬೇಜ಼ಣಾನ, ‘ತುಮೆ ಬೋಲ್ಯಾತೆ ವಾತೆಮ ಖಿವೂಬಿ ಮಾರಪರ್ ನಾ ಆವ್ಣುತೆ ತಿಮ್ ಮಾರಖ್ಹಾಜೆ ಪ್ರಭುಮ ತುಮೆ ಪ್ರಾರ್ಥನೆ ಕರೊ’ ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","ಅಮ್‍ ರ‍್ಹವಾಪರ್ ಇವ್ಣೆ ಪ್ರಭುನಿ ಸಂದೇಶ್ನ ಖ್ಹಾಚ ದಿಲ್‌ಥಿ ಬೋಲಿಹುವಾದಿನ್ ಯೆರೂಸಲೇಮ್‌ನ ಜೈ಼ನ್ ಪಾಛು಼ ಫರಿ ಆವಾನಿವಖ್ಹ್‌ತೆ ಸಮಾರ್ಯವಾಳನ ಕೆತ್ರಾಕಿ ಗಾಮ್ಮ ಸುವಾರ್ತೆನ ಖ್ಹಮ್‌ಜಾ಼ಡ್ಯು ");
INSERT INTO vaa_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","ಪ್ರಭುನ ದೂತನೆ ಫಿಲಿಪ್ಪನ ತೂ ಉಠೀನ್ ದಕ್ಷಿಣ್ ರುಕ್‍ಮ ಯೆರೂಸಲೇಮ್‍ಥು ಗಾಜ ಗಾಮ್‌ನ ಜಾ಼ವಾನಿ ಜ಼ಂಗಳ್‌ನಿ ವಾಟೆ ಜಾ಼ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","ಇಮ್ನಿಪರಕ್ಮಾಸ್ ಫಿಲಿಪ್ ಉಠೀನ್ ಯೆರೂಸಲೇಮ್‌ನ ಪಾಛೊ಼ ಜಾ಼ತೊರ‍್ಹವಾನಿ ವಖ್ಹ್‌ತೆ ಇಥಿಯೋಪ್ಯವಾಳೊ ಏಕ್‌ ಅದ್ಮಿನ ದೇಖ್ಯೊ. ಯೋ ಹೀಜ್‍಼ಡೊ ಹುಯಿರ‍್ಹೊಥೊ. ಇಥಿಯೋಪ್ಯನಿ ರಾಣಿ ಕಂದಾಕೆನ ಹಾತ್‍ ಹೇಟ್‌ಳ್ಯೊ ಮೋಟೊ ಅಧಿಕಾರಿಬಿ ಬಿಜು಼ ಇನಿ ಧನ್‍ ದೌಲತ್ನಿ ಖಜಾನೇನ ದೇಖವಾಳೊ ಹುಯಿರ‍್ಹೋಥೊ. ಯೊ ಅದ್ಮಿ ಆರಾದನೆಕರಾನ ಯೆರೂಸಲೇಮ್‌ನ ಜೈ಼ರೋಥೊ. ");
INSERT INTO vaa_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","ಅಜು಼ ಇನ ಘರೆ ಪಾಛೊ಼ ಜಾ಼ವಾನಿವಖ್ಹ್‌ತೆ ಇನಿ ರಥ್‍ಮ ಬೇಶಿನ್ ಯೆಶಾಯನಿ ಪ್ರವಾದನೆನಿ ದಪ್ತರ್‌ನ ಫಡುಕರ್ತೋಥೊ. ");
INSERT INTO vaa_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","ಪವಿತ್ರಾತ್ಮನೆ ಫಿಲಿಪ್ಪನ ‘ತೂ ಯೋ ರಥ್‌ನ ಖನ್ನೆ ಜೈ಼ನ್ ಇನಿ ಜೋ಼ಡ್ಮಾಸ್ ಚಾ಼ಲ್’ ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","ಫಿಲಿಪ್ಪ ನಾಶಿಜೈ಼ನ್ ಯೋ ಅದ್ಮಿ ಯೆಶಾಯ ಪ್ರವಾದಿನು ದಪ್ತರ್‌ನ ಪಢುಕರಾತೆ ಖ್ಹಮ್‌ಜಿನ್‌, ‘ತೂ ಪಢುಕರಾತೆ ತುನ ಮಾಲುಮ್ ಪಡುಕರಸ್ಕಿ ಶು’? ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","ಇನೆ, ಕೋಣ್‌ತೋಬಿ ಮನ ಬರಬರ್ ನಾ ಖ್ಹಮ್‍ಜಾ಼ಡ್ಯುತೊ ಯೋ ಮನ ಕಿಮ್ ಅರ್ಥಪಡ್‍ಶೆ ಕರಿ ಬೋಲಿನ್ ತೂ ರಥ್ ಛ಼ಡಿನ್ ಮಾರಾಕನ ಬೇಶಿಜಾ಼ ಕರಿ ಫಿಲಿಪ್ಪನ ಬೋಲಿಲಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","ಯೊ ಫಡುಕರ್ತೊ ಥೋತೆ ಪವಿತ್ರ್‌ ದಪ್ತರ್‌ಮ ವಚನ್ನುಭಾಗ್‌ ಖೆವುಕತೊ ‘ಕತ್ರಾನ ಲೀಜಾ಼ಯಿತೆ ಮೇಂಢಾನ ಚೆಲ್ಕನಿತರ ಇನ ಲೀನ್‌ಗಯು; ಅಜು಼ ಮೇಂಢು ರುಯಿ ಕತ್ರಾವಾಳನ ಖ್ಹಾಮ್ಣೆ ಖ್ಹೊಪ್‍ರ‍್ಹವಾನಿತರ ಇನೆ ಮ್ಹೋಡು ಮ್ಹೆಲ್ಯೊಸ್‍ ಕೊಯ್ನಿ. ");
INSERT INTO vaa_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","ಇನ ಖ್ಹರಮ್‌ ಕಾಡ್ಯು. ಇನ ನ್ಯಾವ್ ಮಳ್ಯುಕೊಯ್ನಿ. ಇನಿ ಪಿಳ್‍ಗೀನಿ ಬಾರೇಮ ಕೋಣ್ ಬೋಲವಾಳು ಉಷೆ? ಶನಕತೊ ಜ಼ಮೀನ್‍ಪರ್ಥು ಇನ ಜಾನ್ನ ಕಾಡಿನಾಕ್‌ಶೆ ಕರಿ ಬೋಲನುಸ್. ");
INSERT INTO vaa_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","ಅದಿಕಾರಿನೆ ಫಿಲಿಪ್ಪನ, ಆ ವಚನ್ನಿ ಬಾರೇಮ ಪ್ರವಾದಿನೆ ಆ ವಾತ್ನ ಕಿನಿ ಬಾರೇಮ ಬೋಲಿರಾಖ್ಯೊಸ್ತೆ? ಮಾರಿ ಬಾರೇಮಾಕಿ? ಬಿಜೇಕ್ ಜ಼ಣಾನಿ ಬಾರೇಮ? ದಯಾಕರೀನ್ ಮನ ಬೋಲ್ನುಕರಿ ಫಿಲಿಪ್ಪನ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","ತದೆ ಫಿಲಿಪ್ಪನೆ ಬೋಧನೆ ಕರ್ತೊಹುಯಿನ್ ಯೋಸ್ ವಚನ್ನಿ ಆಧಾರ್ ಕರಿಲಿನ್ ಇನ ಯೇಸುನಿ ಬಾರೇಮಾನಿ ಸುವಾರ್ತೆನ ಖ್ಹಮ್‌ಜಾ಼ಡ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","ಇವ್ಣೆ ವಳ್ಯಜಾ಼ತಥಾತೆ ವಾಟೆ ಪಾಣಿನಿ ಝ಼ಗೋಕನ ಆಯ. ಅಜು಼ ಅದಿಕಾರಿನೆ, ಹಂದೇಕ್ ಪಾಣಿ ಹೈರು ಮೇ ಬ್ಯಾಪ್ತಿಸ್ಮ ಲ್ಯಾವಾನ ಅಡ್ಡಿಶಾತ್‍? ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","ತದೆ ಫಿಲಿಪ್ಪನೆ ಇನ “ತೂ ಖ್ಹಾಚ ದಿಲ್‌ಥಿ ವಿಶ್ವಾಸ್ ಕರಾವಾಳೊ ಉಷೇತೊ ಅಡ್ಡಿಕೊಯ್ನಿ” ಕರಿ ಬೋಲ್ಯೊ. ತದೆ ಅದಿಕಾರಿನೆ, “ಯೇಸುಕ್ರಿಸ್ತಾಸ್ ದೇವ್‌ನೊ ಛಿಯ್ಯೊಕರಿ ವಿಶ್ವಾಸ್ ಕರುಸ್” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","ತದೆ ರಥ್‌ನ ಭೀರಾಕ್ ಕರಿ ಹುಕುಮ್ ದಿದೊ. ಯೊ ವಖ್ಹತ್‌ಮ ಇವ್ಣೆ ಭೇಜ಼ಣ ಪಾಣಿಮ ಉತ್‍ರ‍್ಯ. ಫಿಲಿಪ್ಪನೆ ಇನ ಬ್ಯಾಪ್ತಿಸ್ಮ ಕರಾಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","ಇವ್ಣೆ ಪಾಣಿಮಾಥು ಉಪ್ಪರ್ ಆವಾದಿನ್, ಪ್ರಭುನ ಆತ್ಮನೆ ಫಿಲಿಪ್ಪನ ಲೀನ್‍ ಗಯೊ. ಅದಿಕಾರಿನೆ ಫಿಲಿಪ್ಪನ ಬಿಜು಼ ಕದೇಬಿ ದೇಖ್ಯೊಸ್‍ ಕೊಯ್ನಿ. ಯೋ ಘಣು ಖುಷಿಥಿ ಇನಿ ವಾಟ್‍ಧರಿನ್‍ ಚ಼ಲಿಗಯು. ");
INSERT INTO vaa_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","ಅನಕೇಡೆಥು ಫಿಲಿಪ್ಪ ಅಜೋತ್‍ಕರಿ ಖ್ಹಯೇರ್‌ಥು ದೆಖೈನ್ ಹಿಜ್ಜಾ಼ಥು ಕೈಸರೈಕರಿ ಖ್ಹಯೇರ್‌ಲಗು ಅಖ್ಖಾಸ್ ಗಾಮ್ಮ ಸುವಾರ್ತೆ ಬೋಲ್ತೊ ಗಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","‘ಪ್ರಭುನ ಶಿಷ್ಯರ‍್ನ ಡರಾವನ ಅಜು಼ ಮಾರಾನಖ್ಹಾಜೆ ಯೆರೂಸಲೇಮ್ಮ ಸೌಲ ಬಿಜೂ಼ಬಿ ಕೋಶಿಶ್ ಕರುಕರ್ತೊಥೊ. ಇನಖ್ಹಾಜೇಥಿ ಯೊ ಗಲ್‌ಢಯಾಜಕ್‌ಕನ ಜೈ಼ನ್, ");
INSERT INTO vaa_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","ದಮಸ್ಕ ಖ್ಹಯೇರ‍್ನಿ ಸಭೆನ ಚಿಟ್ಟಿ ಲೀಖಿನ್ ದಮಸ್ಕಮ ಕ್ರಿಸ್ತಾನ ಮಾರಗ್‍ಮ ಚಾ಼ಲವಾಳು ತಯೇಡ ರ‍್ಹವೊ ಪರ್ಖ್ಹೊ ರ‍್ಹವೊ ಇವ್ಣುನ ಬೇಡಿ ಘಾಲಿನ್ ಖ್ಹತಾವನ ಯೆರೂಸಲೇಮ್ಮ ಖೇಚಿಲಿ ಆವಾನ ಮನ ಹುಕುಮ್ ದೆವೊ ಕರಿ ಬೋಲಿಲಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","ಯೊ ದಮಸ್ಕನ ಖನ್ನೆ ಚಾ಼ಲ್ತೊಹುಯಿನ್‌. ಖ್ಹಯೇರ‍್ನ ಆವಾನಿ ವಖ್ಹ್‌ತೆ, ಆಕಾಶ್‌ಮಾಥು ಏಕ್‌ ಉಜಾ಼ಳು ಅಪ್‌ಗುಪ್‌ಥೀಸ್ ಐನ್ ಇನ ಅಶ್‌ಪಿಶ್‌ ಉಜಾ಼ಖ್ಹ್‌ಥಿ ಝ಼ಮ್‍ಕ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","ಯೊ ಜ಼ಮೀನ್‌ಪರ್ ರಡ್ಕಿಗಯೊ ತದೆ, “ಸೌಲ, ಸೌಲ ಮನ ಶನ ಖ್ಹತಾವಸ್?” ಕರಿ ಬೋಲಾನಿ ಆವಾಜ಼್‌ನ ಖ್ಹಮ್‍ಜ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","ಸೌಲನೆ, “ಪ್ರಭು ತೂ ಕೋಣ್?” ಕರಿ ಬೋಲ್ಯೊ. ಪ್ರಭುನೆ, “ತೂ ಖ್ಹತವ್‍ಕರಸ್ತೆ ಯೇಸುಸ್ ಮೇ” ");
INSERT INTO vaa_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","ಕತೋಬಿ ತೂ ಉಠೀನ್ ಖ್ಹಯೇರ‍್ನ ಮಹಿ ಜಾ಼, ತೂ ಕರ್ನುತೆ ಅಖ್ಖು ಹಿಜ಼್ಜ ತುಮುನ ಮಾಲುಮ್‌ ಪಡ್‌ಶೆ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","ಇನ ಜೋ಼ಡೆ ವಳೇಜಾ಼ತಥಾತೆ ಇವ್ಣೆ ಯೋ ಅವಾಜ಼್ ಖ್ಹಮ್‌ಜ್ಯು ಪಣ್ಕಿ ಕಿನಾಬಿ ದೇಖಾನ ಕೋಹುಯುಂತೆ ಮುಕ್ಕಪಡಿಗ. ");
INSERT INTO vaa_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","ಸೌಲ ಜ಼ಮೀನ್‍ಪರ್ಥೊ ಉಠೀನ್ ಡೋಳ ಪಾಡಮ ಶಾತ್ಬಿ ಕೋ ದೆಖಾಯುನಿ. ಇನಖ್ಹಾಜೆ ಇವ್ಣೆ ಇನ ಹಾತ್‍ಧರೀನ್ ದಮಸ್ಕಮ ಬುಲೈಲಿನ್ ಗಯ. ");
INSERT INTO vaa_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","ಇನ ತೀನ್ ದನ್ ಡೋಳ ಕೋ ದೆಖಾಯುನಿ,ಅಜು಼ ಇನೆ ಶಾತ್ಬಿ ಖಾದೊಪೀದೊ ಕೊಂತೆಥೊ. ");
INSERT INTO vaa_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","ತದೆ ದಮಸ್ಕಮ ಅನನೀಯಕರಿ ಏಕ್‍ಜ಼ಣೊ ವಿಶ್ವಾಸಿಥೊ. ಪ್ರಭುನೆ ದರ್ಶನ್‍ಮ, ‘ಅನನೀಯ’ ಕರಿ ಬೋಲಖ್ಹತರ್, ತದೆ ಇನೆ ಮೆ ಹಜ್ಜಾ಼ಸ್ ಛೂ಼ ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","ಪ್ರಭುನೆ ಅನನೀಯನ, “ತೂ ಉಠೀನ್ ಖ್ಹತ್ತಡ್‍ ಗಲ್ಲಿಕರಿ ಬೋಲಾನು ನಾಮ್ನಿ ಗಲ್ಲಿಮ ಜಾ಼. ಹಿಜ್ಜಛಾ಼ತೆ ಯೂದನ ಘರ್‌ಮ ದೇಖಿನ್ ತಾರ್ಸಸ್‍ ಖ್ಹಯೇರ‍್ನು ಸೌಲನಿ ಬಾರೇಮ ಪೂಛಾ಼ವ್ ಯೊ ಹಮ್ಕೆ ಪ್ರಾರ್ಥನೆ ಕರುಕರಸ್. ");
INSERT INTO vaa_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","ಸೌಲನೆ ಏಕ್‌ ದರ್ಶನ್ ದೇಖ್ಯೊ. ಅನನೀಯಕರಿ ಏಕ್‍ಜ಼ಣೊ ಆವ್‌ಶೆ ಇನ ಪಾಛು಼ ಡೋಳ ದೇಖಾವನಿತರ ಇನ ಉಪ್ಪರ್ ಹಾತ್‍ ಮ್ಹೆಲಾಖ್ಹತರ್ ಇನೆ ದೇಖ್ಯೊ ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","ತದೆ ಅನನೀಯನೆ ಪ್ರಭು,ಯೆರೂಸಲೇಮ್‌ನು ತಾರ ದೇವ್ನಅದ್ಮಿ ಖ್ಹಾರಾನ ಕೆತ್ರೇಕ್ಕಿ ಖ್ಹತಾಪ್ಣಿನ ದಿದೂತೆ ಅನಿ ಬಾರೇಮ ಕೈಯೇಕ್‍ಜ಼ಣಾಥಿ ಖ್ಹಮ್‍ಜಿರಾಖ್ಯೊಸ್. ");
INSERT INTO vaa_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","ಅಜು಼ ಹಜ್ಜಾ಼ಬಿ ಗಲ್‌ಢಯಾಜಕ್‌ಥಿ ಅದಿಕಾರ್ ಲೀರಾಖ್ಯೊಸ್‍ಕಿ, ತಾರ ನಾಮ್ನ ಬೋಲವಾಳಾನ ಬೇಡಿಘಾಲ್ನುಕರಿ. ");
INSERT INTO vaa_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","ಪ್ರಭುನೆ ಅನನೀಯನ “ತೂ ಜಾ಼; ಯೋ ಅದ್ಮಿಖ್ಹಾರ ಯೆಹೂದ್ಯರ್‌ಕಾಹೆತೆ ಅದ್ಮಿವೊನ ರಾಜಾ಼ವ್‌ನ, ಅಜು಼ ಇಸ್ರಾಯೇಲ್ ಅದ್ಮಿವೊನ ಮಾರ ನಾಮ್ನ ಖ್ಹಮ್‍ಜಾ಼ಡನಖ್ಹಾಜೆ ಮೇ ಚೂ಼ಣಿರಾಖ್ಯೊತೆ ಏಕ್‌ ಜಿನಖ್ಹ್‌ ಹುಯಿರೊಸ್. ");
INSERT INTO vaa_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","ಯೊ ಮಾರ ನಾಮ್ನಖ್ಹಾಜೆ ಕೆತ್ರು ಲತಾಡ ಲಿಶೆಕರಿ ಮೇಸ್ ಇನ ವತಾಳಿಶ್.” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","ತದೆ ಅನನೀಯ ಚಾ಼ಲ್ತೊ ಯೊ ಘರ್‌ಮ ಜೈ಼ನ್ ಇನಾಪರ್ ಇನೊ ಹಾತ್‍ ಮ್ಹೇಲಿನ್, “ಮಾರೊ ಭೈ ಸೌಲ, ತೂ ಆವಾನಿ ವಾಟ್ಮ ತುನ ದೆಖಾಯೊತೆ ಪ್ರಭು ಯೇಸು ತುನ ಪಾಛು಼ ಡೋಳೊ ದೆಖಾವಾನಿಘೊಣಿಬಿ, ತು ಪವಿತ್ರಾತ್ಮಾಥಿ ಭರಾವ್ಣು ಕರೀಬಿ ಮನ ಮೋಕ್ಲಿರಾಖ್ಯೊಸ್” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","ಯೋ ವೇಳ್ಮಾಸ್ ಸೌಲನ ಡೋಳೇಥಿ ಪಡದ್ನಿಘೋಣಿ ಶಾತ್ಕಿ ಹೇಟ್ ನಿಕ್ಳಿ ಪಡೀನ್ ಇನೊ ಡೋಳ ಪಾಛು಼ ದೆಖಾವಲಗ್ಯು. ಯೋ ಉಠೀನ್ ಬ್ಯಾಪ್ತಿಸ್ಮ ಲಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","ಇನಕೇಡೆಥು ಖಾಣು ಖಾವಖ್ಹತರ್ ಇನ ಶಕತ್ ಆಯು. ಸೌಲ ಥೋಡದನ್‍ಲಗು ದಮಸ್ಕಮ ಸುವಾರ್ತೆನ ಬೋಲ್ಯೊ. ಅಜು಼ ವಿಶ್ವಾಸಿನಿ ಜೋ಼ಡ್ಮ ಥೊ. ");
INSERT INTO vaa_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","ಪೌಲ ತದ್ನುತದೇಸ್, “ಯೇಸು ದೇವ್‌ನೊ ಛಿಯ್ಯೊ” ಕರಿ ಸಭೆ ಮಳಾನಿ ಝ಼ಗೋಮ ಬೋಲಾನ ಶುರು ಕರ‍್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","ಆ ವಾತೆನ ಖ್ಹಮ್‍ಜ್ಯುತೆ ಖ್ಹಾರು, “ಯೆರೂಸಲೇಮ್ಮ ಆ ಅದ್ಮಿಸ್‌ ಯೇಸುನ ನಾಮ್ನ ವಿಶ್ವಾಸ್ ಕರವಾಳನ ಮಾರಿನಾಖು ಕರ್ತೊಥೋತೆ ಆಸ್ ಕಾಹೆಕಿ ಶು? ಅಜು಼ ಇವ್ಣುನ ಗಲ್‌ಢಯಾಜಕ್‌ಕನ ಧರಿಲೀನ್ ಜಾ಼ವ್ಣುಕರೀಸ್ ಆ ಹಜ಼್ಜ ಐರ‍್ಹೋಸ್ತೆ?” ಕರಿ ಬೋಲಿಲಿದು. ");
INSERT INTO vaa_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","ಇನೆ ಅಜೂ಼ಬಿ ಘಣು ವಚನ್ನು ಆಧಾರ್‌ಥಿ ಯೇಸು ಕ್ರಿಸ್ತಾಸ್ ಜಗತ್ನ ಬಚಾ಼ಡವಾಳೊಕರಿ ಬೋಲಾನು ಖ್ಹಾಚಿಸ್ ಕರಿ ಸೌಲನೆ ದಮಸ್ಕಮಥೂತೆ ಯೆಹೂದ್ಯರ್‌ನ ಸಾಬಿತ್ ಕರಾಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","ಕೆತ್ರಾಕಿ ದನ್ನಪಾರ್ ಯೆಹೂದ್ಯವಾಳು ಸೌಲನ ಮಾರಿನಾಕ್ಣುಕರಿ ಖ್ಹೂಜ಼್ ಕರ‍್ಯು. ");
INSERT INTO vaa_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","ಯೆಹೂದ್ಯರ್‌ವಾಳು ಸೌಲ ಮಳಾನು ದೇಕ್‍ತುಹುಯಿನ್‍ ನಂಗರ‍್ನ ಖ್ಹಾರ ದರ‍್ವಾಜ಼ವ್‌ಕನ ರಾತ್ ದನ್ ಕಾವ್ಲಿ ಥು. ಕತೋಬಿ ಯೋ ಖ್ಹಾರು ಸೌಲನ ಮಾಲುಮ್‌ ಪಡ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","ಏಕ್‍ರಾತ್ ಪೌಲನ ಥೋಡ ಶಿಷ್ಯರ‍್ನೆ ಇನ ಖ್ಹಯೇರ‍್ನ ಭಾರ್‌ ಮೋಕ್ಲಾನಟೇಕೆ ಇನ ಏಕ್‌ ಟೋಕ್ರಾಮ ಬೆಖ್ಹಾಡಿನ್‌ ಖ್ಹಯೇರ‍್ನ ಭೀತ್‌ನ ಉಪ್ಪರ್‌ಥು ಹೇಟ್ ಉತಾರಿದಿದು. ");
INSERT INTO vaa_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","ಸೌಲ ಯೆರೂಸಲೇಮ್ಮ ಜೈ಼ನ್ ವಿಶ್ವಾಸಿ ಟೋಳ್ಮ ಮಳೀರ‍್ಹೇಣುಕರಿ ಕೋಶಿಶ್ ಕರ‍್ಯೊ. ಕತೋಬಿ ಇವ್ಣೆಖ್ಹಾರು, ಸೌಲನ ಖ್ಹಾಚಮಾಬಿ ಯೇಸುನೊ ಶಿಷ್ಯಕರಿ ನಂಬ್ಯುಕೊಂತೆ ಇನೇಥಿ ಡರಿಗಯು. ");
INSERT INTO vaa_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","ಕತೋಬಿ ಬಾರ್ನಬನೆ ಇನ ಮದತ್ ಕರಾನ ಅಪೊಸ್ತಲರ್‌ಕನ ಬುಲೈಲಿನ್ ಆಯೊ. ಸೌಲನೆ ದಮಸ್ಕನ ಮಾರಗ್‍ಮ ಪ್ರಭುನ ದೆಖ್ಯೊತೆ ಪ್ರಭು ಸೌಲಥಿ ವಾತೆ ಬೋಲ್ಯೊತೆ ಅಖ್ಖೂಸ್ ಖ್ಹಮ್‌ಜಾ಼ಡ್ಯೊ. ಕಾಹೆತೆ ದಮಸ್ಕಮ ಡರ್‌ಕೊಂತೆ ಪ್ರಭು ಯೇಸುನ ನಾಮ್‍ಲೀನ್ ಬೋಧನೆ ಕರ‍್ಯೊತೆಯಿನ ಇವ್ಣುನ ಬೋಲಿ ಖ್ಹಮ್‌ಜಾ಼ಡ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","ಇನಬಾದ್ಮ ಸೌಲ ಯೆರೂಸಲೇಮ್ಮ ವಿಶ್ವಾಸಿನಿ ಜೋ಼ಡ್ಮ ಮಳಿನ್ ಶಿಕಾಡ್ತೊಹುಯಿನ್ ಪ್ರಭುನ ನಾಮ್‍ಥಿ ಡರ್‌ಕೊಂತೆ ಬೋಧನೆ ಕರಾಲಗ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","ಗ್ರೀಕ್ ವಾತೆ ಬೋಲ್‍ತುಥೂತೆ ಯೆಹೂದ್ಯರ್‌ನ, ಜೋ಼ಡ್ಮ ಸೌಲ ಕದೇಬಿ ವಾದ ಕರ್ತೊಥೊ. ಇನಖ್ಹಾಜೆ ಇನ ಮಾರಿನಾಕ್ಣುಕರಿ ಕೋಶಿಶ್ ಕರ‍್ಯು. ");
INSERT INTO vaa_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","ಅನ ಮಾಲುಮ್ ಕರ‍್ಯುತೆ ವಿಶ್ವಾಸಿಖ್ಹಾರು ಇನ ಕೈಸರೈ ಖ್ಹಯೇರ‍್ನ ಬುಲೈಲಿಜೈ಼ನ್ ಹಿಜ್ಜಾ಼ಥು ತಾರ್ಸಸ್‍ ಖ್ಹಯೇರ‍್ನ ಮೋಕ್ಲಿದಿದು. ");
INSERT INTO vaa_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","ಇನಬಾದ್ಮ ಯೂದಾಯ, ಗಲಿಲಾಯ, ಅಜು಼ ಸಮಾರ್ಯನ ತಬರ್‌ಖಾಮ ಥೀತೆ ಖ್ಹಾರಿ ಸಭೆಮ ಸಮಾಧಾನ್‍ ಪಡ್ಯು. ಸಬೆ ಭಡ್ತುಹುಯಿನ್ ಪ್ರಭುನ ಡರ್‌ಮಾಬಿ ಭಕ್ತಿಮಾಬಿ ಜಿವ್ತುಹುಯಿನ್, ಪವಿತ್ರಾತ್ಮಥಿ ಜಾ಼ಖ್ಹತ್ ಹೋತುಹುಯಿನ್ ಭಡ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","ಯೆರೂಸಲೇಮ್‌ನು ಅಶ್‌ಪಿಶ್‍ಥೂತೆ ಖ್ಹಾರ ಗಾಮ್ಮ ಪೇತ್ರ ಫರ್ತೊಜಾ಼ವಾನಿ ವಖ್ಹ್‌ತೆ ಲುದ್ದಕರಿ ಗಮ್ಮರ‍್ಹವಾಳ ದೇವ್ನ ಅದ್ಮಿಖ್ಹಾರಾನ ಮಳ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","ಹಿಜ್ಜಾ಼ ಲಕ್ವೊಮಾರಿನ್ ಆಟ್ ವರಖ್ಹ್ ಥೊ ಬಿಛಾ಼ವ್ಣಪರ್ ಪಡ್ಯೊಥೋತೆ ಐನೇಯ ಕರಿ ಏಕ್‌ ಜ಼ಣಾನ ದೇಖ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","ಪೇತ್ರನೆ ಯೋ ಅದ್ಮಿನ, “ಐನೇಯ,ಯೇಸು ಕ್ರಿಸ್ತಾಸ್ ತುನ ಅಛ್ಛು಼ ಕರುಕರಸ್. ಉಟ್ ತಾರ ಬಿಛಾ಼ವ್ಣನ ತೂಸ್ ಬಿಚೈ಼ಲೇ” ಕರಿ ಬೋಲ್ಯೊ. ತುರಂತ್ ಯೋ ಉಠಿನಿಕ್‍ಳ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","ಲುದ್ದಮ ಅಜು಼ ಶಾರೋನ್‍ಮ ರ‍್ಹವಾಳು ಅದ್ಮಿಖ್ಹಾರು ಇನ ದೇಖಿನ್ ಪ್ರಭು ಯೇಸುನ ಉಪ್ಪರ್ ವಿಶ್ವಾಸ್ ಕರ‍್ಯು. ");
INSERT INTO vaa_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","ಯೊಪ್ಪ ಖ್ಹಯೇರ್‌ಮ ತಬಿಥಾಬಿ ಯೇಸುನಿ ಏಕ್‌ ಶಿಷ್ಯೇ ಥಿ. ಗ್ರೀಕ್‍ನಿ ಬೋಲಿಮ ಇನು ನಾಮ್ ‘ದೊರ್ಕ’ ಇನಿ ಮತ್‌ಲಬ್ ‘ಚೀತಳ್‌ಕರಿ’ ಯೋ ಕದೇಬಿ ಅಛ಼್ಛುಕಾಮ್ ಕರಾವಳಿ ಅಜು಼ ದಾನಧರಮ್‍ ದ್ಯವಾಳಿ ಹುಯಿರ‍್ಹಿಥಿ. ");
INSERT INTO vaa_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","ಯೋ ವಖ್ಹತ್‌ಮ ಇನ ರೋಗ್ ಅಯಿನ್ ಮರಿಗಯಿ. ಅಜು಼ ಇನ ಶರೀರ್‌ನ ಧೊಯಿನ್ ಉಪ್‌ಲ್ಯಖನ್ನ ಕೋಣಾಮ ಲಯಿನ್ ಮ್ಹೇಲ್ಯ. ");
INSERT INTO vaa_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","ಆ ‘ಲುದ್ದ’ ಯೊಪ್ಪ ಖ್ಹಯೇರ‍್ನ ಖನ್ನೆಸ್‌ ರ‍್ಹವಾಮ ಪೇತ್ರ ಹಿಜ್ಜಾ಼ ರ‍್ಹವಾನು ಶಿಷ್ಯರ‍್ನೆ ಖ್ಹಮ್‌ಜಿನ್‌ “ದಯಾ ಕರೀನ್ ಒಗ್ಗಿಸ್‌ಮ ಹಮಾರ ಗಮ್ಮ ಆವ್ಣು” ಕರಿ ಬೇಜ಼ಣಾನ ಬೋಲಿ ಮೋಕ್‌ಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","ಪೇತ್ರ ತಯಾರ್‌ಹುಯಿನ್ ಹಿಜ್ಜಾ಼ ಆಯೊ. ತದೆ ಇನ ಘರ್‌ನ ಉಪ್‌ಲ್ಯಖನ್ನ ಕೋಣಾಮ ಬುಲೈಲಿನ್ ಗಯು. ಹಿಜ಼್ಜಾಥೂತೆ ಮುಂಡಚ್ಚಿಖ್ಹಾರು ಪೇತ್ರನ ಅಶ್‌ಪಿಶ್‍ ರೋವ್‍ತೆಹುಯಿನ್,ಅಜು಼ ದೊರ್ಕ ಜಿವ್ತಿಥೀತೆ ತದೆ ಇವ್ಣಖ್ಹಾಜೇಥಿ ಬಣೈನ್ ದಿದಿಥೀತೆ ಪೇರ್‌ವಾಖ್ಹ್ ಅಜು಼ ಝ಼ಗ್ಗಾನು ಬಣಾವಟ್ನ ವತಾಳ್‍ಯೆ. ");
INSERT INTO vaa_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","ಅಜು಼ ಪೇತ್ರನೆ ಅದ್ಮಿಖ್ಹಾರಾನ ಭಾರ್‌ ಮೋಕ್ಲಿನ್ ಢುಕ್‍ಣ್ಯಮೇಟೆ ಹುಯಿನ್ ಪ್ರಾರ್ಥನೆ ಕರೀ ಶರೀರ್‌ಭಣಿ ಫರೀನ್, “ತಬಿಥಾ, ಉಪ್ಪರ್ ಉಟ್” ಕರಿಬೋಲ್ಯೊ. ಯೋ ಡೋಳಪಾಡಿನ್ ಪೇತ್ರನ ದೇಕ್‍ಥೀಸ್ ಉಠಿ ಭೀರಿಗಯಿ. ");
INSERT INTO vaa_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","ಇನೆ ಹಾತ್‍ದೀನ್‍ ಉಠಾಡಿ ಭೀರಾಖ್ಯೊ. ತದೆ ವಿಶ್ವಾಸಿಖ್ಹಾರು ಅಜು಼ ಮುಂಡಚ್ಚಿ ತಯೇಡಾವ್‍ನ ಯೊ ಕೋಣಾಮ ಬುಲೈ ಜಿವ್ತುಹುಯಿತೆ ಇನ ಇವ್ಣುನ ವತಾಳ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","ಯೊಪ್ಪಮ ಹರೇಕ್ ಬಾಜು಼ಮ ಥೂತೆ ಅದ್ಮಿವೋನ ಆ ವಾತೆ ಮಾಲುಮ್ ಪಡ್ಯು. ಯೊ ಅದ್ಮಿಖ್ಹಾರಾಮ ಕೆತ್ರೂಕಿ ಜ಼ಣು ಪ್ರಭುನ ವಿಶ್ವಾಸ್ ಕರ‍್ಯು. ");
INSERT INTO vaa_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","ಪೇತ್ರನೆ ಯೊಪ್ಪಮ ಚಾ಼ಂಬ್ಡಾನು ಕಾಮ್‍ಕರವಾಳೊ ಸೀಮೋನ್ನ ಘರ್‌ಮ ಘಣ ದನ್‌ಲಗು ರ‍್ಹಿಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","ಕೈಸರೈ ಖ್ಹಯೇರ್‌ಮ ಕೊರ್ನೆಲ್ಯ ಕರಿ ನಾಮ್ನೊ ಏಕ್‌ಜ಼ಣೊ ಥೊ. ಯೋ ಇಟಲಿನು ಫೊಜ಼್‌ನೊ ಖ್ಹೋಶಿಪಾಯಿನೊ ಅದಿಕಾರಿ ಹುಯಿರ‍್ಹೊಥೊ. ");
INSERT INTO vaa_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","ಯೊ, ಇನು ಕುಟುಂಬ್‍ವಾಳು ದೇವ್‌ಮ ಡರ್‌ ಭಕ್ತಿಥೀಬಿ ರ‍್ಹೀನ್ ಜಿವ್ಣು ಕರುಕರ್ತುಥು. ಅಜು಼ ಗರೀಬ್‌ನ ಜಾ಼ಖ್ಹತ್ ದಾನಧರಮ್‍ ಕರಾವಾಳೊ, ಕದೇಬಿ ದೇವ್ನ ಪ್ರಾರ್ಥನೆ ಕರಾವಾಳೊ ಹುಯಿರ‍್ಹೋಥೊ. ");
INSERT INTO vaa_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","ಏಕ್‍ದನ್ ಧೋಪಾರ‍್ನ ಖ್ಹುಮಾರ್ ತೀನ್ ಘಂಟಾನ ಕೊರ್ನೆಲ್ಯನ ದರ್ಶನ್ ಹುಯು ತದೆ ಏಕ್‌ ದೇವ್‌ನೊ ದೂತ ಇನಾಕನ ಐನ್, “ಕೊರ್ನೆಲ್ಯ” ಕರಿ ಚಿಕ್ರಾನು ನೇರ್‌ಥಿ ದೇಖ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","ಕೊರ್ನೆಲ್ಯ ಡರಿನ್ ದೇವ್ನದೂತನ ಠರ್‌ಕೈನ್ ದೇಕ್ತೊ ಹುಯಿನ್ “ಪ್ರಭು ಆ ಶಾತ್?” ಕರಿ ಬೋಲ್ಯೊ. ತದೆ ದೇವ್‌ನೊ ದೂತನೆ ಇನ, ತಾರಿ ಪ್ರಾರ್ಥನೆಬಿ, ತಾರಿ ದಾನ್ ಧರಮ್ ಅಖ್ಖು ದೇವ್ನಿ ಸನ್ನಿಧಿಮ ಖ್ಹಯಾಲ್‌ಥಿ ಪೊಚಿರ‍್ಹುಸ್; ");
INSERT INTO vaa_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","ಹಮ್ಕೆ ತೂ ಥೋಡು ಜ಼ಣಾನ ಯೊಪ್ಪನ ಮೋಕ್ಲಿನ್, ಪೇತ್ರಕರಿ ಬೋಲೈಲ್ಯವಾಳೊ ಸೀಮೋನನ ಬುಲಾವ್ಣು. ");
INSERT INTO vaa_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","ಯೋ ಚಾ಼ಂಬ್ಡಾನು ಕಾಮ್‌ಕರಾವಾಳೊ ಸೀಮೋನನ ಘರ್‌ಮ ಛಾ಼. ಇನುಘರ್‌ ದರ‍್ಯಾವ್ನ ಕಿನಾರೆ ಛಾ಼ ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","ಕೊರ್ನೆಲ್ಯನೆ ಇನ ಜೋ಼ಡ್ಮ ವಾತೆಬೋಲ್ಯಾತೆ ದೇವ್‌ನೊ ದೂತ ಚ಼ಲೇಗೊತದೆ, ಇನ ಘರ್‌ಮಥಾತೆ ಬೇಜ಼ಣ ಸೇವಕ್‌ನ ಅಜು಼ ಇನಿ ಜೋ಼ಡ್ಮ ರ‍್ಹವಾಳ ಶಿಪಾಯಿಮ ಏಕ್‌ ಜ಼ಣೊ ದೇವ್‌ಮ ಭಕ್ತಿರ‍್ಯಹವಾಳೊ‍ ಶಿಪಾಯಿನ ಬುಲೈನ್, ");
INSERT INTO vaa_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","ಇವ್ಣುನ ಕೊರ್ನೆಲ್ಯನೆ, ಆ ಚಾ಼ಲ್ಯುತೆ ಅಖ್ಖೂಸ್ ಇವ್ಣುನ ಬೋಲಿನ್ ಯೊಪ್ಪನ ಮೋಕ್‌ಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","ಇನ ಅಗಲ್ಯದನ್ನೆ ಯೊ ಅದ್ಮಿಖ್ಹಾರು ಯೊಪ್ಪನ ಚ಼ಲ್ಯಾವದಿನ್ ತದೆ ದೊಫಾರ್ನಿ ವೇಳ್ಮ ಪೇತ್ರ ಪ್ರಾರ್ಥನೆ ಕರಾನ ಘರ್‌ನ ಉಪ್‌ಲ್ಯ ಛ಼ತ್‍ಪರ್‌ ಗಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","ಪೇತ್ರನ ಘಣು ಭುಕ್‍ಲಾಗಿನ್ ಶಾತ್ತೋಬಿ ಖಾವ್ಣು ಕರಿ ಆಖ್ಹ್‌ಕರ‍್ಯೊ, ಯೋ ಖಾಣು ತಯಾರ್ ಕರುಕರಾಸ್ಮ,ಇನ ಏಕ್‌ ದರ್ಶನ್‍ಹುಯಿ. ");
INSERT INTO vaa_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","ತದೆ ಆಕಾಶ್‍ ನಿಕ್ಳಿನ್ ಚಾರ್ ಕೋಣಾನ ಭಂದಾಯುಹುಯು ಮೋಟಿ ಝೋ಼ಳಿನಿತರಾನು ಏಕ್‌ ಜಿನಖ್ಹ್‌ ಜ಼ಮೀನ್‌ಪರ್ ಉತ್ರಿ ಉಳ್ಯಾವ್‌ತುಥೂತೆ ದೇಖ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","ಇನಾಮ ಅಖ್ಖೀಸ್ ಥರಾನು ಜಾನ್ವರ್‌ಖ್ಹಾರು ಜ಼ಮೀನ್‌ಪರ್ ಖ್ಹವಳ್ತು ಚಾ಼ಲಾನು ಕೀಡ್‌ಕಮ್ಟು ಅಜು಼ ಆಬ್‌ಪರ್ ಉಡಂತು ಜಿನಾವರ್ ಖ್ಹಾರು ಹಿಜ಼್ಜಥೂ. ");
INSERT INTO vaa_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","ತದೆ, ‘ಪೇತ್ರ, ಉಠಿನ್, ವ್ಹಾಡಿ ಖಾ‘ ಕರಿ ಇನ ಏಕ್‌ ಅವಾಜ಼್ ಖ್ಹಮಜ಼್‌ಪಡ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","ಕತೋಬಿ ಪೇತ್ರನೆ, ಇಮ್‌ಕರಾನ ಕೊಹುವಾನಿ ಪ್ರಭು, ಕಚಿಂಡ್‌ ರಾಛು಼ ರ‍್ಹವೊ ಅಜು಼ ಅಶುದ್ದ ಹುಯುತೆ ಚೀಜ಼್‌ನ ಮೆ ಕದೇಬಿ ಖಾದೊಹುಯೊ ಕಾಹೆ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","ಕತೋಬಿ ಯೊ ಅವಾಜ಼್ ಬಿಜೇಕ್ ಹಲ್ಲ ಇನ, “ದೇವ್ನೆ ಪಾಕ್‌ ಕರಿರಾಖ್ಯೊತೆ ಅನಅಖ್ಖು ಮೈಲುಕರಿ ನಾಬೋಲ್ನು ಕರಿ ಪಾಛೊ಼ ಭೇನೆಹಲ್ಲ ಇನ ಠವ್‌ಕೊ ಖ್ಹಮಜ್‍ಪಡ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","ಅಮ್ಮಸ್ ತೀನ್‌ಹಲ್ಲ ಹುಯು ಇನ ಬಾದ್ಮ ಯೋ ಜಿನಖ್ಹ್‌ ಸೊರ್ಗಾಮ ಪಡೈಲೆವೈಗು. ");
INSERT INTO vaa_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","ಪೇತ್ರನೆ, ಇನೆ ದೇಖ್ಯೊತೆ ದರ್ಶನ್ ಶಾತ್‍ರ‍್ಹೇಣು ಕರಿ ಸೋಚಾನಿ ವಖ್ಹತ್‌ಮ ಕೊರ್ನೆಲ್ಯನೆ ಮೋಕ್‌ಲ್ಯೋಥೋತೆ ಅದ್ಮಿಖ್ಹಾರು ಸೀಮೋನ್ನ ಘರ್‌ನ ಪುಛಾ಼ವ್ತುಹುಯಿನ್‌ ಖ್ಹಣೇದ್ ಧರೀನ್ ಅಜು಼ ಯೋ ಘರ್‌ನ ಬಾಕಲ್‌ನ ಖ್ಹಾಮ್ಣೆ ಆಯಿನ್ ಭೀರ‍್ಯು. ");
INSERT INTO vaa_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","“ಪೇತ್ರಕರಿ ಬೋಲಸ್ತೆ ಸೀಮೋನ ಹಜ಼್ಜ ಛಾ಼ಕಿ ಶು?” ಕರಿ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","ಪೇತ್ರ ದರ್ಶನ್ನಿ ಬಾರೇಮ ಬಿಜೂ಼ಬಿ ಸೋಚುಕರಾನಿ ವಖ್ಹತ್‌ಮ ಪವಿತ್ರಾತ್ಮನೆ ಇನ, ಸೀಮೋನ ತೀನ್ ಅದ್ಮಿ ತುನ ಢೂಂಡ್‌ತುಹುಯಿನ್ ಐರ‍್ಹೂಸ್. ");
INSERT INTO vaa_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","ತೂ ಉಠೀನ್ ಹೇಟ್ ಉತ್ರಿನ್ ಶಾತ್ಬಿ ಗುಮಾನಿ ನಾಕರ‍್ನುತೆ ಇವ್ಣಿ ಜೋ಼ಡ್ಮ ಜಾ಼ ಅಜು಼ ಪಾಛೊ಼ ಧಕೀಶ್ ನಕೊ. ಮೇಸ್ ಇವ್ಣುನ ತಾರಕನ ಮೋಕ್ಲಿರಾಖ್ಯೊಸ್” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","ಪೇತ್ರ ತದೆ ಹೇಟ್ ಉತ್ರಿನ್ ಯೋ ಅದ್ಮಿವ್‍ಕನ ಜೈ಼ನ್, “ತುಮೆ ಢೂಂಡುಕರಾಸ್ತೆ ಯೊ ಅದ್ಮಿ ಮೇಸ್, ತುಮೆ ಹಜ಼್ಜ ಶನ ಆಯಾ? ಕರಿ ಪುಛಾಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","ತದೆ ಇವ್ಣೆ, “ಕೊರ್ನೆಲ್ಯಕರಿ ಖ್ಹೋಶಿಪಾಯಿನೊ ಮೋಟೊ ಛಾ಼. ಯೋ ನೀತಿಮ ಚಾ಼ಲವಾಳೊ; ದೇವ್‍ಥಿ ಡರಾವಾಳೊ ಅಜು಼ ಯೆಹೂದ್ಯರ‍್ನು ಅದ್ಮಿ ಖ್ಹಾರು ಇನ ಮರ್ಯಾದಿ ದೇಸ್. ತುನ ಇನ ಘರೆ ಬುಲೈನ್ ತೂ ಬೋಲಾನಿ ವಾತೇನ ಖ್ಹಮಜ಼್‌ಣುಕರಿ ದೇವ್‌ನೊ ದೂತಥಿ ಕೊರ್ನೆಲ್ಯನ ಬೋಲಿರಾಖ್ಯೊಸ್” ಕರಿ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","ಪೇತ್ರನೆ ಇವ್ಣುನ ಮಹಿ ಬುಲೈನ್, ಸತ್ಕಾರ್ ಕರೀನ್ ಯೋ ರಾತ್ ಹಿಜ್ಜಾ಼ಸ್ ರ‍್ಹವಾನಿತರ ಕರ‍್ಯೊ. ಇನವ್ಹಾಣೆ ಪೇತ್ರ ತಯಾರ್‌ಹುಯಿನ್ ಇವ್ಣ ಜೋ಼ಡ್ಮ ಗಯೊ. ಯೊಪ್ಪನು ವಿಶ್ವಾಸಿಮ ಥೋಡುಜ಼ಣು ಇನ ಜೋ಼ಡೆಗಯು. ");
INSERT INTO vaa_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","ಇನ ಅಗ್‍ಲ್ಯದನ್ನೆ ಇವ್ಣೆ ಕೈಸರೈ ನಂಗರ‍್ನ ಪೋಚ್ಯು.ತದೆ ಕೊರ್ನೆಲ್ಯನೆ ಇವ್ಣ ಮಾಯಮಾತ್ರಾನಾಬಿ ಅಜು಼ ಸಾಥೀನ ದೋಸ್ತ್‌ನ ಬುಲೈಲಿನ್ ಪೇತ್ರನಖ್ಹಾಜೆ ಟಿವೈರ‍್ಹೋಥೊ. ");
INSERT INTO vaa_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","ತದೆ ಪೇತ್ರ ಘರ್‌ಕನ ಆವಖ್ಹತರ್ ಕೊರ್ನೆಲ್ಯನೆ ಗೋಡಾಪರ್ ಪಡೀನ್ ಖ್ಹಲಾಮ್ ಕರ‍್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","ಕತೋಬಿ ಪೇತ್ರನೆ, “ಉಠೀನ್ ಭೀರೆ ಮೇಬಿ ತಾರಿನಿತರ ಅದ್ಮಿಸ್‌” ಕರಿಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","ಅಜು಼ ಇನ ಉಠಾಡಿನ್ ವಾತೆ ಬೋಲ್ತೊಹುಯಿನ್ ಮಹಿ ಗಯೊ. ಹಿಜ್ಜಾ಼ ಘಣು ಅದ್ಮಿನಿ ಝೂ಼ಂಡ್‌ ಭರೈರ‍್ಹುತೆ ಇನೆ ದೇಖ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","ಪೇತ್ರನೆ ಇವ್ಣುನ, “ಯೆಹೂದ್ಯವಾಳವೊ ಏಕ್‌ ಜ಼ಣೊ ಅಲಕ್‌ಅದ್ಮಿಥಿ ಮಳೀನ್‍ ರ‍್ಹವಾನುರ‍್ಹೇವೊ, ಇವ್ಣಿಜೋ಼ಡೆ ರ‍್ಹವಾನು ಯೆಹೂದ್ಯರ್‌ನ ಪದತ್ತಿನ ವಿರೋದ್ ಹುಯಿರ‍್ಹುಸ್ ಕರಿ ತುಮೂನ ಮಾಲುಮ್‌ ಛಾ಼. ಕತೋಬಿ ಖಿವಿ ಅದ್ಮಿನಾಬಿ ಕಮ್‍ಶಿಲ್‍ವಾಳೊ, ಅಪವಿತ್ರವಾಳೊ ಕರಿ ನಾ ಬೋಲ್‌ನು ಕರಿ ದೇವ್ನೆ ಮನ ವತಾಳಿರಾಖ್ಯೊಸ್. ");
INSERT INTO vaa_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","ಇನಖ್ಹಾಜೆ ತುಮೆ ಮನ ಬುಲಾವ್ಣುಕರಿ ಆವಾನಿ ವಖ್ಹತ್‌ಮ ಏಕ್‌ ವಾತ್‍ಬಿ ಬೋಲ್ಯೊಕೊಂತೆ ಆಯೊ. ಕತೋಬಿ, ತುಮೆ ಶನ ಬುಲಾಯಥಾ ಕರಿ ಹಮ್ಕೆ ತುಮೆ ಬೋಲೊ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","ತದೆ ಕೊರ್ನೆಲ್ಯನೆ, “ತೀನ್ ಚಾರ್ ದನ್ನ ಅಗ್ಗಳ್ ಮೇ ಮಾರ ಘರ್‌ಮ ಪ್ರಾರ್ಥನೆ ಕರಾನ ಧೋಪಾರ‍್ನ ತೀನ್ ಘಂಟಾನ ಅಪ್‍ಗುಪ್‍ಥೀಸ್ ಉಜಾ಼ಖ್ಹ್‌ನು ಲುಂಗ್ಡು ಫೇರಿರಾಖ್ಯೊಥೋತೆ ಏಕ್‍ಜ಼ಣೊ ಮಾರ ಖ್ಹಾಮ್ಣೆ ಭೀರಿಗೊ. ");
INSERT INTO vaa_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","ಇನೆ ಬೋಲ್ಯೊ, ಕೊರ್ನೆಲ್ಯ, ದೇವ್ನೆ ತಾರಿ ಪ್ರಾರ್ಥನೆನ ಖ್ಹಮ್‍ಜಿರಾಖ್ಯೊಸ್. ತೂ ಗರೀಬ್‌ನ ದಾನ್‌ ಧರಮ್‌ ಕರಾನು ದೇಖಿನ್ ತುನ ಪಸಂದ್ ಕರಿರಾಖ್ಯೋಸ್. ");
INSERT INTO vaa_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","ಇನಖ್ಹಾಜೆ; ತೂ ಕಿನಾತೋಬಿ ಯೊಪ್ಪನ ಮೋಕ್ಲಿನ್ ಪೇತ್ರಕರಿ ಬೋಲೈಲ್ಯವಾಳೊ ಸೀಮೋನನ ಬುಲಾವ್ಣು. ಯೋ ಚಾ಼ಂಬ್ಡಾನು ಕಾಮ್‌ಕರಾವಾಳೊ ಸಿಮೋನನ ಘರ್‌ಮ ಛಾ಼. ಯೋ ಘರ್‌ ದರ‍್ಯಾವ್ನ ಕಿನಾರೆ ಛಾ಼ ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","ಇಮ್ಮಸ್ ಮೇ ಒಗ್ಗಿಸ್‌ಮ ತುನ ಬುಲಾವನ ಮೋಕ್‌ಲ್ಯೊ.ತುಮೆ ಹಜ್ಜಾ಼ ಆಯೋತೆ ಅಛ್ಛು಼ಹುಯು. ಹಮೂನ ಬೋಲಾನು ಕರಿ ಹುಕುಮ್‌ ದೀರಾಖ್ಯೊಸ್ತೆ ಅಖ್ಖೂಸ್ ಹಮೆ ಖ್ಹಮಜ಼್‌ಣು ಕರಿ ಪ್ರಭುನಿ ಝ಼ಗೋಮ ಮಳಿರ‍್ಹಾಸ್.” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","ಪೇತ್ರನೆ ಉಪದೇಶ್ ಬೋಲ್ತೊಹುಯಿನ್ ಅಮ್ ಬೋಲ್ಯೊ, “ದೇವ್‌ಮ ಖ್ಹಾರುಜ಼ಣು ಎಕ್ಕಸ್ ಕರಿ ಬೋಲಾನು ಖ್ಹಾಚಿ ಕರಿ ಮನ ಹಮ್ಕೆ ಸೋಚಾ಼ಯು. ");
INSERT INTO vaa_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","ಇನ ಆರಾದನೆ ಕರಾಮ ಖಿವು ಅದ್ಮಿನರ‍್ಹವೊ ನೀತಿಥಿ ಅಜು಼ ಇನಾಮ ಡರಿನ್ ಚಾ಼ಲಸ್ಕಿ ಇವ್ಣುನ ದೇವ್ ಪಸಂದ್ ಕರಾಸ್‌ಕರಿ ಬೋಲಾನು ಮನ ಹಮ್ಕೆ ಗುಮಾನಿಕೊಂತೆ ಮಾಲುಮ್‌ಪಡುಕರಸ್. ಯೊ ಖೆವ ಜಾ಼ತ್ಜ಼ಮಾತ್ ಕರಿ ಬೋಲಾನು ಹಜ್ಜಾ಼ ಖ್ಹಾಯಿಕೊಯ್ನಿ. ");
INSERT INTO vaa_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","ದೇವ್ನೆ ಇಸ್ರಾಯೇಲ್‌ನ ಅದ್ಮಿನ ಜೋ಼ಡ್ಮ ಬೋಲ್ಯೊಥೊ ಯೋಸ್ ಖ್ಹಾರಜ಼ಣನ ಪ್ರಭು ಹುಯಿರ‍್ಹೋಸ್.ಯೊ ಯೇಸು ಕ್ರಿಸ್ತಾಥೀಸ್ ಸಮಾಧಾನ್ ಆವ್‍ಶೆಕರಿ ಬೋಲಾನು ಸುವಾರ್ತೆನ ದೇವ್ನೆ ಇವ್ಣುನ ಮೋಕ್‌ಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","ಬ್ಯಾಪ್ತಿಸ್ಮ ಕರೈಲೇವ್ಣುಕರಿ ಯೋಹಾನನೆ ಬೋಲಿ ಖ್ಹಮ್‌ಜಾ಼ಡ್ಯೊತೆ ಇನಕೇಡೆಥು ಆ ವಚನ್ ಗಲಿಲಾಯಥು ಧರಿನ್ ಯೂದಾಯ ತಬರ್‌ಖಾಮ ಫೈಲು. ");
INSERT INTO vaa_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","ದೇವ್ನ ನಜ಼ರೇತ್‌ನ ಯೇಸುನಿ ಬಾರೇಮ ಮಾಲುಮ್. ಇನ ಪವಿತ್ರಾತ್ಮಥಿಬಿ ಶಕಥ್ಥಿ ಅಬಿಷೇಕ್ ಕರ‍್ಯೊ ಯೊ ಅಖ್ಖೀಸ್ ಬಾಜೂ಼ಮ ಫರ್ತೊಹುಯಿನ್ ಅದ್ಮಿಖ್ಹಾರನ ಅಛ್ಛು಼ ಕರ‍್ಯೊ. ಭೂತ್ ಧರಿರ‍್ಹಾವಳನಬಿ ಗುಣ್‌ಕರ‍್ಯೊ. ಶನಕತೊ ದೇವ್ ಇನಿ ಜೋ಼ಡ್ಮ ಛಾ಼ಕರಿ ಬೋಲಾನು ವತಾಳಿದಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","ಯೆಹೂದ್ಯವಾಳನ ತಬರ್‌ಖಾಮ ಅಜು಼ ಯೆರೂಸಲೇಮ್ಮ ಯೇಸುನೆ ಕರ‍್ಯೊತೆ ಅಖ್ಖಾಸ್ ಕಾಮ್ನ ಹಮೆ ದೇಖ್ಯ. ಇನ ಹಮೆ ಸಾಕ್ಷಿ ಹುಯಿರ‍್ಹಾಸ್ ಕತೋಬಿ ಯೇಸು ಮರೈಗಯೊ. ಇವ್ಣೆ ಇನ ಶಿಲ್‌ಬೆಪರ್ ಮೇಕೆಮರಾಯು. ");
INSERT INTO vaa_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","ಕತೋಬಿ ದೇವ್ನೆ ಇನ ತೀನ್‌ದನ್‌ಮ ಮರಣ್‌ಥು ಜಿವ್ತೊ ಉಠಾಡ್ಯೊ. ನೇರ್ ದೇಖಾನ ಪಾಛೊ಼ದಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","ಕತೋಬಿ ಯೇಸು ಖ್ಹಾರಸ್ ಅದ್ಮಿನ ದೆಖಾಯೊ ಕೊಯ್ನಿ ದೇವ್‍ಥಿ ಪಹಿಲೇಸ್ ಸಾಕ್ಷಿಹುಯಿ ಚೂ಼ಣೈರ‍್ಹುಥೂತೆ ಇವ್ಣೆಖಲಿ ಇನದೇಖ್ಯು. ಯೇಸು ಮರಣ್‍ಥಿ ಜಿವ್ತೊಹುಯಿನ್ ಉಠೀನ್ ಆವಾನಿ ವಖ್ಹ್‌ತೆ ಅಪ್ಣೆ ಇನಿ ಜೋ಼ಡ್ಮ ಖಾಣು ಖಾದ ಅಜು಼ ಪಾಣಿ ಪೀದ. ");
INSERT INTO vaa_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","ಅಜು಼ ಯೋಸ್ ಜಿವ್ತುರ‍್ಹವಾಳನ, ಮರಿರ‍್ಹಾವಳನ ದೇವ್‍ಥಿ ನ್ಯಾವ್‍ನೊ ಅಧಿಪತಿಹುಯಿನ್ ಚೂ಼ಣಾಯೊಹುಯೊ ಕರಿ ವತಾಳನಖ್ಹಾಜೆ ಸಾಕ್ಷಿ ಬೋಲ್‌ನು ಕರಿ ಅಪ್ಣುನ ಹುಕುಮ್‌ ದಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","ಇನ ನಂಬಾವಾಳನು ಹರೇಕ್‍ಜ಼ಣು ಪಾಪ್ನ ಇನ ನಾಮ್‍ಥಿ ಕ್ಷಮಾಪಣ್ ಮಳ್‌ಶೇತೆ. ಆ ಖ್ಹಾಚಸ್‌ಕರಿ ಪ್ರವಾದಿಖ್ಹಾರು ಸಾಕ್ಷಿ ಬೋಲಿರಾಖ್ಯುಸ್” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","ಪೇತ್ರ ಬಿಜೂ಼ಬಿ ಇಮ್ಮಸ್ ಬೋಲಾತೆ ವಚನ್ ಖ್ಹಮ್‌ಜು಼ಕರಾತೆ ತದೇಸ್‌ ಇನಿ ವಚನ್ ಖ್ಹಮ್‍ಜ್ಯುತೆ ಅಖ್ಖಾನ ಉಪ್ಪರ್ ಪವಿತ್ರಾತ್ಮ ಉತ್ರಿನ್‌ ಆಯು. ");
INSERT INTO vaa_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","ಯೆಹೂದ್ಯರ್‌ಕಾಹೆತೆ ಅದ್ಮಿಖ್ಹಾರಾನ ಉಪ್ಪರ್ ಪವಿತ್ರಾತ್ಮನು ವರ ಉತ್ರಿ ಆವಾನು ದೇಖಿನ್ ಪೇತ್ರನಿಜೋ಼ಡ್ಮ ಯೊಪ್ಪಥು ಆಯುತೆ ಯೆಹೂದ್ಯರ್ ವಿಶ್ವಾಸಿಖ್ಹಾರು ಆಶ್ಚರ್ಯಕರ‍್ಯು. ");
INSERT INTO vaa_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","ಶನಕತೊ ಇವ್ಣೆ ಅಲಕ್ ಅಲಕ್ ಬೋಲಿನಿ ವಾತೇಮ ದೇವ್ನ ಆರಾದನೆ ಕರಾನು ಯೊ ಯೆಹೂದ್ಯರ‍್ನು ವಿಶ್ವಾಸಿಖ್ಹಾರು ಖ್ಹಮ್‌ಜ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","ತದೆ ಪೇತ್ರನೆ ವಾತೆ ಬೋಲ್ತೊಹುಯಿನ್, “ಆ ಅದ್ಮಿಬಿ ಪವಿತ್ರಾತ್ಮಥಿ ಭರಾಯು ಅವ್ಣುನ ಪಾಣಿಮ ಬ್ಯಾಪ್ತಿಸ್ಮ ಕರಾವನ ಶನೀಬಿ ಅಡ್ಡಿಕೊಯ್ನಿ?” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","ಅನಖ್ಹಾಜೆ ಇವ್ಣುನ ಕ್ರಿಸ್ತನ ನಾಮ್‍ಥಿ ಬ್ಯಾಪ್ತಿಸ್ಮ ಲೇವ್ಣುಕರಿ ಹುಕುಮ್‌ ದಿದೊ. ತದೆ ಇವ್ಣೆ, ಪೇತ್ರನ ಥೋಡ ದನ್ ಹಮಾರ ಜೋ಼ಡ್ಮ ರ‍್ಹೇವ್ಣುಕರಿ ಬೋಲಿಲಿದು. ");
INSERT INTO vaa_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","ಯೆಹೂದ್ಯರ್‌ಕಾಹೆತೆ ವಿಶ್ವಾಸಿಖ್ಹಾರು ದೇವ್ನಿ ವಚನ್ನ ಸ್ವೀಕಾರ್‌ಕರ‍್ಯು ಕರಿ ಅಪೊಸ್ತಲರ್‌ವಾಳನಾಬಿ ಯೂದಾಯಮ ಥೂತೆ ವಿಶ್ವಾಸಿನ ಮಾಲುಮ್‍ಹುಯು. ");
INSERT INTO vaa_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","ಪೇತ್ರ ಯೆರೂಸಲೇಮ್ಮ ಆಯೊತೆ ತದೆ ವಿಶ್ವಾಸಿಖ್ಹಾರನ ಜೋ಼ಡ್ಮ ಖ್ಹತ್ನಾನಿ ಬಾರೇಮ ವಾದ ಕರ್ತುಹುಯಿನ್; ");
INSERT INTO vaa_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","ತೂ, “ಯೆಹೂದ್ಯರ್ ಕಾಹೆತೆ ಇವ್ಣಕನಾಬಿ ಅಜು಼ ಖ್ಹತ್ನ ಕರಾಯುಕೊಂತೆ ಇವ್ಣ ಘರೇಬಿ ತುನೆ ಇವ್ಣಿಜೋ಼ಡ್ಮ ಜೈ಼ನ್ ಖಾಣುಬಿ ಖಾದೊ ಕರಿ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","ಇನಖ್ಹಾಜೆ ಪೇತ್ರನೆ ಹಿಜ್ಜಾ಼ ಶಾತ್ ಚಾ಼ಲ್ಯುಕಿ ಯೊ ಅಖ್ಖು ಬೋಲ್ತೊಹುಯಿನ್; ");
INSERT INTO vaa_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","ಪೇತ್ರನೆ ಇವ್ಣುನ, ಮೆ ಯೊಪ್ಪ ಖ್ಹಯೇರ್‌ಮ ಪ್ರಾರ್ಥನೆ ಕರಾನಿ ವಖ್ಹ್‌ತೆ “ಮನ ಏಕ್‌ ದರ್ಶನ್ ದೆಖಾಯು. ಯೋ ಶಾತ್‌ಕತೊ ಆಕಾಶ್‍ಥು ಚಾರ್ ಕೋಣಾನ ಶಿಂದ್ರೂ ಭಂದೈನ್ ಉತ್ರಿ ವಳ್ಯಾವ್ತು ಥೂತೆ ಝೋ಼ಳಿನಿತರಾನು ಏಕ್‌ ಜಿನಖ್ಹ್‌, ಮಾರಕನಾಸ್ ಉತ್ರಿ ಆಯು. ");
INSERT INTO vaa_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","ಮೆ ಇನಾಮಹಿ ದೇಖ್ಯೊ ಇನಾಮ ಧರ್ತಿನು ಜಾನ್ವರ್‌ ಅಜು಼ ಅಖ್ಖು ಛಂಡಾಳಿ ಜಾನ್ವರ್‌, ಖ್ಹವಳ್ತು ಚಾ಼ಲಾನು ಕೀಡ್‌ಕಮ್ಟು ಅಖ್ಖು ಆಬ್‌ಪರ್ ಉಡಂತು ಜಿನಾವರ್ ಖ್ಹಾರು ಹಿಜ಼್ಜಥೂ. ");
INSERT INTO vaa_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","ತದೆ ‘ಪೇತ್ರ, ಉಠಿನ್, ವ್ಹಾಡಿ ಖಾ’ ಕರಿ ಬೋಲಾನೊ ಏಕ್‌ ಆವಾಜ಼್ ಮನ ಠವ್‌ಕೊ ಖ್ಹಮ್‍ಜ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","ತದೆ ಮೆ, ‘ಮೆ ಇಮ್‌ಕರಾನ ಕೊಹುವಾನಿ ಪ್ರಭು’ ಕಚಿಂಡ್‌ ರಾಛು಼ ರ‍್ಹವೊ ಅಜು಼ ಅಶುದ್ದ ಹುಯುತೆ ಚೀಜ಼್‌ನ ಮೆ ಕದೇಬಿ ಖಾದೊಕೊಯ್ನಿ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","ಇನಖ್ಹಾಜೆ, ಆ ಅಖ್ಖಾನ ದೇವ್ನೆ ಪಾಕ್‌ ಕರಿರಾಖ್ಯೊತೆ ಅನಅಖ್ಖು ಮೈಲುಕರಿ ನಾಬೋಲ್ನು ಕರಿ ಬೇನೆಹಲ್ಲಬಿ ಆಬ್‌ಮಾಥು ಠವ್‌ಕೊ ಬೋಲಾಯು. ");
INSERT INTO vaa_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","ಅಮ್ಮಸ್ ತೀನ್‌ಹಲ್ಲ ಹುಯು. ಇನಪಾರ್ ಯೊ ಅಖ್ಖು ಜಿನಖ್ಹ್‌ ಸೊರ್ಗಾಮ ಪಡೈಲೆವೈಗು. ");
INSERT INTO vaa_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","ಯೋಸ್ ವೇಳ್ಮ ಮೇ ಥೋತೆ ಘರ್‌ನ ಖ್ಹಾಮ್ಣೆ ತೀನ್‍ಜ಼ಣ ಆಯಾ ಯೊ ತೀನ್‍ಜ಼ಣಾನ ಕೈಸರೈ ಖ್ಹಯೇರ್‌ಥು ಮಾರಕನ ಮೋಕ್‍ಲೈರ‍್ಹಾಥ. ");
INSERT INTO vaa_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","ಪವಿತ್ರಾತ್ಮನೆ ಮನ ಬೋಲ್ಯೊ ಗುಮಾನಿ ನಾಕರ‍್ನುತೆ ಇವ್ಣಿ ಜೋ಼ಡ್ಮ ಜಾ಼ ಕರಿ ಬೋಲ್ಯೊ. ಆ ಛೋ಼ ಜ಼ಣ ಭೈಯೇ ಮಾರಿಜೋ಼ಡ್ಮ ಆಯಾ ಹಮೆ ಕೊರ್ನೆಲ್ಯನ ಘರೆಗಯ. ");
INSERT INTO vaa_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","ತದೆ ಇನೆ ದೇವ್‌ನೊ ದೂತ ಮಾರ ಘರ್‌ಮ ಭಿಯೊಥೋತೆ ಇನ ಬಾರೇಮ ಮನ ಬೋಲ್ಯೊ. ಯೊ ದೇವ್‌ನೊ ದೂತನೆ ಕೊರ್ನೆಲ್ಯನ, ತೂ ಥೋಡ ಜ಼ಣಾನ ಯೊಪ್ಪನ ಮೋಕ್ಲಿನ್ ಪೇತ್ರಕರಿ ಬೋಲೈಲ್ಯವಾಳೊ ಸೀಮೋನನ ಬುಲೈಲೆ. ");
INSERT INTO vaa_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","ಯೊ ತುಮಾರಿ ಜೋ಼ಡ್ಮ ಉಪದೇಶ್ ಬೋಲ್‌ಶೆ ಯೊ ಬೋಲ್‍ಶೇತೆ ಬೋಧನೆಥಿ ತುನಾಬಿ ತಾರ ಪರಿವಾರ್ನಾಬಿ ರಕ್ಷಣೆಮಳ್‌ಶೆ ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","‘ಮೇ ಮಾರಿ ಉಪದೇಶ್‍ನ ಶುರುಕರ‍್ಯೊ ತದೆ, ಶುರೂಮ ಪವಿತ್ರಾತ್ಮ ಉತ್ರಿನ್‌ ಆಯು. ಇಮ್ಮಸ್ ಇವ್ಣ ಉಪ್ಪರ್‌ಬಿ ಆಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","ತದೆ ಮೆ ಪ್ರಭುನಿ ವಾತೆನ ಖ್ಹಯಾಲ್‍ಕರಿಲಿದೊ; ಇನೆ ‘ಯೋಹಾನನೆ ಅದ್ಮಿವ್‌ನ ಪಾಣಿಥಿ ಬ್ಯಾಪ್ತಿಸ್ಮ ಕರಾಯೊ ಕತೋಬಿ ತುಮೆ ಪವಿತ್ರಾತ್ಮಥಿಬಿ ಬ್ಯಾಪ್ತಿಸ್ಮ ಕರೈಲಿಶು’ ಕರಿ ಬೋಲಿರಾಖ್ಯೊಥೊ. ");
INSERT INTO vaa_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","ಪ್ರಭು ಯೇಸುಕ್ರಿಸ್ತಮ ವಿಶ್ವಾಸ್‌ರಾಖ್ಯಾತೆ ಆಪ್ಣುನ ದಿದೋತೆ ವರನಾಸ್ ದೇವ್ನೆ ಆ ಅದ್ಮಿವೋನಾಬಿ ದಿದೊ. ಅಮ್‍ರ‍್ಹವಾನಾಪರ್ ಮೆ ದೇವ್ನ ಕಾಮ್ನ ಭೀರಾಖಾನ ಮೇ ಕೋಣ್? ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","ಆ ವಾತೆನ ಇವ್ಣೆ ಖ್ಹಮ್‌ಜಿನ್‌ ಝಿಟ್ಕಾರ್‌ ಕರಾನು ಮ್ಹೆಂದಿನ್; ಇಮ್‍ಕತೊ ದೇವ್ ಯೆಹೂದ್ಯರ್‌ಕಾಹೆತೆ ಇವ್ಣುನಾಬಿ ಜಾನ್‍ದೇವ್ಣುಕರಿ ಇವ್ಣ ದಿಲ್ನ ಇನಾಭಣಿ ಫರಾಯೊ ಕರಿ ದೇವ್ನ ಖ್ಹರಾಯು. ");
INSERT INTO vaa_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","ಸ್ತೆಫನನ ಮರ್‌ನಾಖ್ಯುತೆ ತದೆ ಹಿಜ್ಜಾ಼ ಹುಯಿತೆ ಖ್ಹತಾಪ್ಣಿಥಿ ಥೋಡುಜ಼ಣು ವಿಶ್ವಾಸಿಖ್ಹಾರು ಛಿದ್ರಯ್‍ಗಯು, ಇವ್ಣೆ ಘಣಾದೂರ್‌ನಿ ಝ಼ಗೊಹುಯಿರಿಥೀತೆ ಫೊಯಿನಿಕೆ, ಸೈಪ್ರಸ್ ಅಜು಼ ಅಂತಿಯೋಕ್ಯನ ಗಯು. ವಿಶ್ವಾಸಿಖ್ಹಾರು ಆ ಝ಼ಗೋಮ ಖಲಿ ಯೆಹೂದ್ಯರ್‌ನ ಸುವಾರ್ತೆನ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","ಆ ವಿಶ್ವಾಸಿಮ ಥೋಡಜ಼ಣು ಸೈಪ್ರಸ್ ಅಜು಼ ಸಿರೇನ್ ಝ಼ಗೊವಾಳ ಹುಯಿರಾಥ. ಆ ಅದ್ಮಿಖ್ಹಾರು ಅಂತಿಯೋಕ್ಯನ ಆಯುತೆ ತದೆ ಇವ್ಣೆ ಪ್ರಭು ಹುಯಿರೋತೆ ಯೇಸುನಿ ಬಾರೇಮ ಸುವಾರ್ತೆನ ಹಿಜ್ಜಾ಼ ಥೋಡ ಗ್ರೀಕ್ ಅದ್ಮಿವೋನ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","ಪ್ರಭುನೊ ಹಾತ್ ಇವ್ಣಪರ್ ಥು,ಅಜು಼ ಅದ್ಮಿಖ್ಹಾರು ಕೈಏಕ್ ಜ಼ಣು ಪ್ರಭುಮ ಭರೋಖ್ಹೊ ಕರ‍್ಯು. ");
INSERT INTO vaa_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","ಆ ವಾತೆ ಯೆರೂಸಲೇಮ್ಮಥೂತೆ ಸಬೆನ ಪೋಚ್ಯು. ಇನಖ್ಹಾಜೆ ಬಾರ್ನಬನ ಅಂತಿಯೋಕ್ಯನ ಬೋಲಿ ಮೋಕ್‍ಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","ಬಾರ್ನಬ ಅಂತಿಯೋಕ್ಯನ ಪೋಚಾ಼ನಿವಖ್ಹತೆ ದೇವ್ನ ಅದ್ಮಿವೋನ ವಿಶ್ವಾಸ್ ಭಡಾವ್ತೊ ಹುಯಿನ್ ಪ್ರಭುಮ ಹುಮ್ಮಖ್ಹ್‌ ಕರಾಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","ಬಾರ್ನಬ ಯೋ ಏಕ್‌ ಅಛ್ಛೊ಼ಅದ್ಮಿ ಹುಯಿರೋಥೊ. ಯೊ ಪವಿತ್ರಾತ್ಮಥಿ ಭರಾಯೊಹುಯೊ ಪೂರ ವಿಶ್ವಾಸ್ಮ ಥೊ ಅಜು಼ ಘಣ ಅದ್ಮಿನ ಪ್ರಭುಭಣಿ ಬುಲೈಲಾಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","ಇನಕೇಡೆಥು ಬಾರ್ನಬನೆ ಸೌಲಾನ ಢೂಂಡ್ತೊಹುಯಿನ್ ತಾರ್ಸಸ್‍ ಖ್ಹಯೇರ‍್ನ ಗಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","ಬಾರ್ನಬನೆ ಸೌಲಾನ ಹಿಜ್ಜಾ಼ ದೇಖಿನ್ ಇನ ಅಂತಿಯೋಕ್ಯನ ಬುಲೈಲಿನ್ ಆಯೊ. ಸೌಲಾಬಿ ಅಜು಼ ಬಾರ್ನಬನೆ ಅಂತಿಯೋಕ್ಯಮ ಏಕ್‌ ವರಖ್ಹ್‌ಅಖ್ಖು ಸಬೆನ ಜೋ಼ಡ್ಮಾಸ್ ರ‍್ಹೀನ್ ಕೈಏಕ್ ಜ಼ಣಾನ ಶಿಕಾಡ್ಯ. ಆ ವಿಶ್ವಾಸಿನ ಪಹಿಲಿಬಾರ್ “ಕ್ರೈಸ್ತರ್” ಕರಿ ನಾಮ್ ಆಯುತೆ ಅಂತಿಯೋಕ್ಯಮಾಸ್. ");
INSERT INTO vaa_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","ಯೋ ಹಗಾಮ್ಮ ಥೋಡುಜ಼ಣು ಪ್ರವಾದಿಖ್ಹಾರು ಯೆರೂಸಲೇಮ್‍ಥು ಅಂತಿಯೋಕ್ಯನ ಗಯು. ");
INSERT INTO vaa_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","ಆ ಪ್ರವಾದಿಖ್ಹಾರಾಮ “ಅಗಬ” ಕರಿ ಏಕ್‍ಜ಼ಣೊ ಥೊ. ಅಗಬನೆ ಅಂತಿಯೋಕ್ಯಮ ಪವಿತ್ರಾತ್ಮನಿ ಖ್ಹಯಾಲ್‌ಥಿ, “ಹಿಡಿ ಜಗತ್‍ನಾಸ್ ಕಾಳ್ದುಕಾಳ್ ಆವ್‌ಶೆ” ಕರಿ ಬೋಲ್ಯೊ. ಯೋ ಕಾಳ್ದುಕಾಳ್‍ನ ಹಗಾಮ್ ಕ್ಲೌದಿಯ ರಾಜ಼ನು ಹಗಾಮ್ಮ ಆಯು. ");
INSERT INTO vaa_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","ಯೂದಾಯಮ ರ‍್ಹವಾಳು ಭೈಯೇ ಭೇನೆವೊನ ಮದತ್‌ಕರಾನ ಶಿಷ್ಯರ್‌ನೆ ನಿರ್ಧಾರ್ ಕರ‍್ಯು. ವಿಶ್ವಾಸಿಮ ಹರೇಕ್ ಜ಼ಣುಬಿ ಇವ್ಣೇಥಿ ಕೆತ್ರುಹುಯೂಕಿ ಇವ್ಣುನ ಬೋಲಿ ಮೋಕ್ಲಿನ್ ಖ್ಹಯಾಲ್ ಕರ‍್ಯು. ");
INSERT INTO vaa_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","ಇವ್ಣೆ ಪೈಶಾನ ಜ಼ಮಕರೀನ್ ಇನ ಬಾರ್ನಬ ಅಜು಼ ಸೌಲನ ಹಾಥ್ಥಿ ಯುದಾಯಮ ಥೂತೆ ಸಭೆನ ಗಲ್‌ಢಾವ್ನ ಲಯಿನ್ ದಿದಾ. ");
INSERT INTO vaa_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","ಯೋ ವೇಳ್ಮ ರಾಜ಼ ಹುಯಿರೊಥೋತೆ ಹೆರೋದನೆ ಸಬೆವಾಳಾಮ ಥೋಡಜ಼ಣಾನ ಖ್ಹತಾಪ್ಣಿ ದ್ಯಾವಲಗ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","ಯೋಹಾನನೊ ಭೈಥೋತೆ ಯಾಕೋಬನ ತಲ್ವಾರ್‌ಥಿ ಮರೈನಾಖ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","ಅನೇಥಿ ಯೆಹೂದ್ಯರ್‌ನ ಪಸಂದ್‌ ಹುಯಿರ‍್ಹುಸ್‌ಕರಿ ಜಾ಼ಣಿನ್, ಪೇತ್ರನಾಬಿ ಧರೈನ್ ಖ್ಹಾರ್ಕೊಟ್‌ಮ ಘಲಾಯೊ. ಯೋ ಹಗಾಮ್ಮ ಯೆಹೂದ್ಯರ್‌ನಿ ಪಸ್ಕ ಪೂಜ಼ ಚಾ಼ಲುಕರ್ತೂಥು. ಪಸ್ಕಕತೊ ಖಾಟುಕೊಂತೆ ರೋಟಾನಿ ಪೂಜ಼. ");
INSERT INTO vaa_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","ತದೆ ಇನೆ ಪಸ್ಕಪೂಜ಼ ಹುಯಿಗು ತದೆ ಅದ್ಮಿವೋನ ಖ್ಹಾಮ್ಣೆ ಪೇತ್ರನ ಭೀರಾಕ್‍ಣುಕರಿ ಸೋಚ್‌ಕರಿನ್ ಜೇಲ್‌ಮ ಘಲೈನ್ ಇನ ಕಾವ್ಲಿ ಕರಾನ ಚಾರ್‌ಜ಼ಣ ಶಿಪಾಯ್ನು ಚಾರ್ ಟೋಳ್ನ ನೇಮಕ್ ಕರ‍್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","ಪೇತ್ರ ಜೇಲ್‌ಮ ಘಾಲ್ಯು ತದೆ ಸಬೇನು ಅದ್ಮಿಖ್ಹಾರು ಇನಖ್ಹಾಜೆ ದೇವ್ನ ದಿಲ್‍ಲಗಾಡಿನ್ ಪ್ರಾರ್ಥನೆ ಕರ‍್ಯು. ");
INSERT INTO vaa_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","ಹೆರೋದನೆ ಇನ ಅದ್ಮಿವೋನ ಖ್ಹಾಮ್ಣೆ ಲ್ಯಾವ್ಣುಕರಿ ಕರ‍್ಯೊತೆ ಪಾಛ್ಲಿ಼ರಾತೆ, ಖ್ಹಾರ್ಕೊಟ್‌ಮ ಬೇ ಖ್ಹಂಕ್‌ಳಿಥಿ ಜ಼ಡ್‍ಕೈನ್ ತದೆ ಪೇತ್ರ ಬೇಜ಼ಣ ಶಿಪಾಯಿನ ಬೀಚ್ಮ ಖ್ಹುತೋಥೊ. ಶಿಪಾಯಿಖ್ಹಾರು ಜೇಲ್‌ನ ದರ‍್ವಾಜ಼ನ ಕಾವ್ಲಿ ಕರಿರಾಖ್ಯುಥು. ");
INSERT INTO vaa_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","ಅಪ್‌ಗುಪ್‍ಥೂಸ್ ಪ್ರಭುನೊದೂತ ಪೇತ್ರನ ಖ್ಹಾಮ್ಣೆ ಭೀರಿಗೊ. ಉಜಾ಼ಳು ಉಜಾ಼ಖ್ಹ್‌ಥಿ ಕೋಣಾಮ ಅಖ್ಖು ಭರೈಗು. ತದೆ ದೇವ್ನದೂತನೆ ಪೇತ್ರನ ಭುಜ಼್‌ನ ಧಕ್ಕೋದಿನ್ ಇನ ಬೋಲ್ಯೊ, “ಒಗ್ಗಿಉಟ್” ಕರಿ ಬೋಲ್ಯೊ. ತದ್ನುತದೇಸ್ ಇನ ಹಾತ್ನ ಭಂದೈರಿಥೀತೆ ಖ್ಹಂಕ್‌ಳಿಯೇ ಛು಼ಟಿಪಡಿಗಯೇ. ");
INSERT INTO vaa_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","ದೇವ್ನದೂತನೆ, “ಲುಂಗ್ಡಾನ ಫೇರಿಲಿನ್ ತಾರ ಕೊಖ್ಹ್‌ಡಾನ ಘಾಲಿಲೆ” ಕರಿ ಬೋಲ್ಯೊ. ಪೇತ್ರನೆ ಇಮ್ಮಸ್ ಕರ‍್ಯೊ. ತದೆ ದೇವ್ನದೂತನೆ, “ತಾರ ಝ಼ಗ್ಗಾನ ಲಪೇಟಿಲೀನ್ ಮಾರಿ ಜೋ಼ಡ್ಮ ಆವ್”. ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","ಇನೆ ಭಾರ್‌ ಆಯಿನ್ ದೇವ್ನದೂತನ ಪೀಠೆ ಜಾ಼ತೊಹುಯಿನ್, ದೇವ್ನ ದೂತಾಥಿ ಚಾ಼ಲ್ಯುತೆ ಇನ ಖ್ಹಾಚು಼ ಕರಿ ಮಾಲುಮ್‌ಕೊಂತೆಸ್ ಯೋ ಖ್ಹೋಣ್ಯು ದೇಖುಕರುಸ್ ಕರಿ ಇನೆ ಸೋಚಿರಾಖ್ಯೊಥೊ. ");
INSERT INTO vaa_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","ಪೇತ್ರನೆ ಪಹಿಲ ಅಜು಼ ಬೇನ ಕಾವ್ಲಿಕರವಾಳನ ಕಾಡಿಮ್ಹೆಂದೀನ್ ಖ್ಹಯೇರ‍್ನು ಜಾ಼ವಾನು ಲ್ಹೋಡಾನ ಬಾಕಲ್‍ಕನ ಆಯೊತೆ ತದೆ, ಯೊ ಬಾಕಲ್ ಇನೇಥಿ ಯೋಸ್ ನಿಕ್ಳಿಗಯೊ. ಪೇತ್ರಬಿ ದೇವ್ನ ದೂತ ಬಾಕಲ್‍ಮಾಥು ನಿಕ್ಳಿನ್ ಭಾರ್‌ಆಯಿನ್, ಯೋ ಗಲ್ಲೀನ ಮ್ಹೇಲಿನ್ ನಿಕ್‍ಳ್ಯ ತದೆ ಅಪ್‍ಗುಪ್‍ಥೀಸ್ ದೇವ್‌ನೊ ದೂತನೆ ಇನ ಮ್ಹೇಲಿನ್ ಚ಼ಲೇಗೊ. ");
INSERT INTO vaa_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","ತದೆ ಪೇತ್ರನೆ ಮಾಲುಮ್‌ಕರ್ಲಿನ್, “ಪ್ರಭುನೆ ಖ್ಹಾಚ಼ಮಾಸ್ ಇನ ದೂತನ ಮೋಕ್‍ಲ್ಯೊತೆ ಮನ ಹಮ್ಕೆ ಮಾಲುಮ್‌ ಪಡ್ಯು. ಯೊ ಮನ ಹೆರೋದನ ಹಾಥ್ಥಿ ಛೋ಼ಡೈನ್‌ಮ್ಹೆಲ್ಯೊ. ಮನ ಕೇಡ್ ಕರ್ನುಕರಿ ಯೆಹೂದ್ಯರ್‌ವಾಳನೆ ಸೋಚಿರಾಖ್ಯುಥು, ಪ್ರಭುನೆ ಆ ಅಖ್ಖಿ ಕೇಡ್‍ಮಾಥು ಮನ ಬಚಾ಼ಡ್ಯೊ” ಕರಿ ಇನೆ ಮಾಲುಮ್‌ಕರ‍್ಲಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","ಯೋ ಅನ ಮಾಲುಮ್‌ಕರ‍್ಲಿದೊ ತದೆ, ಮಾರ್ಕಕರಿ ಬೋಲೈಲ್ಯಾವಾಳೊ ಯೋಹಾನ್ನಿ ಆಯಾ ಮರಿಯನ ಘರೆ ಆಯೊ. ಹಿಜ್ಜಾ಼ ಘಣುಜ಼ಣು ಮಳಿನ್ ಪ್ರಾರ್ಥನೆ ಕರುಕರ್ತುಥು. ");
INSERT INTO vaa_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","ಪೇತ್ರನೆ ಬಾಕಲ್‍ಕನ ಆಯಿನ್ ಖಟ್‍ಖಟಾಯೊ ತದೆ ಯೊ ಕೋಣ್ ಕರಿ ಮಾಲುಮ್‌ ಕರಾನಖ್ಹಾಜೆ ರೋದೆಕರಿ ಸೇವಕಿ ಆಯಿ. ");
INSERT INTO vaa_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","ಇನೆ ಪೇತ್ರನಿ ಆವಾಜ಼್‌ನ ಖ್ಹಣೇದ್‌ಕರೀನ್ ಇನ ಘಣು ಖ್ಹುಶಿಹುಯು. ನಾಶಿಜೈ಼ನ್, “ಪೇತ್ರ ಬಾಕಲ್‍ಕನ ಭಿಯೋಸ್!” ಕರಿ ಬೋಲಿ. ");
INSERT INTO vaa_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","ಹಿಜ಼್ಜಾಥೂತೆ ಅಖ್ಖುಜ಼ಣು, “ಅನ ದಿವಾನು ಧರಾಖ್ಯುಸ್” ಕರಿ ಬೋಲ್ಯು. ಕತೋಬಿ ಮೆ ಆ ಬೋಲುಕರುತೆ ಖ್ಹಾಚಿಸ್ ಕರಿ ಇನೆ ಪಾಛು಼ ಇವ್ಣುನ ಬೋಲಿ, ಇನಖ್ಹಾಜೆ ಇವ್ಣೆಅಖ್ಖು, “ಯೊ ಪೇತ್ರನೊ ದೂತ ರ‍್ಹೇವ್ಣುಕರಿ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","ಕತೋಬಿ ಪೇತ್ರ ದರ‍್ವಾಜ಼ನ ಖಟ್‍ಖಟಾವ್‍ ಕರ್ತೊಥೊ. ತದೆ ಇವ್ಣೆ ಬಾಕಲ್ ಕಾಡಖ್ಹತರ್, ಪೇತ್ರನ ದೇಖಿನ್ ಆಶ್ಚರ್ಯ ಹುಯು. ");
INSERT INTO vaa_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","ಪೇತ್ರನೆ ಇವ್ಣುನ ಶೊಪೊರ‍್ಹೇವೊ ಕರಿ ಹಾತ್‌ನೊ ಇಷಾರ್ಕೊ ಕರೀನ್, ಪ್ರಭುನೆ ಇನ ಜೇಲ್‌ಮಾಥು ಕಿಮ್ ಛೋ಼ಡಾಯೊ ಕರಿ ಯೋ ಬಾರೇಮ ಇವ್ಣುನ ಅಖ್ಖು ಬೋಲಿ ಒತಾಳ್ಯೊ. “ಯಾಕೋಬ್‌ನಾಬಿ ಅಜು಼ ವಿಶ್ವಾಸಿವೊನಾಬಿ ಆ ಸಮಚಾರ್‌ನ ಬೋಲೊ” ಕರಿ ಬೋಲ್ಯೊ. ಇನಕೇಡೆಥು ಪೇತ್ರ ಬಿಜಿ ಝ಼ಗೊ ನಿಕ್ಳಿಗಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","ಇನವ್ಹಾಣೆ ಪೇತ್ರ ಶಾತ್‍ಹುಯೊ ಕರಿ ಶಿಪಾಯಿ ಖ್ಹಾರಾಮ ಮೋಟಿ ಘುಂಜ಼್‌ಳಾವ್ಣಿ ಉಠಿ. ");
INSERT INTO vaa_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","ಹೆರೋದನೆ ಇನ ಢೂಂಡ್ವಾಯೊ ಪೇತ್ರನ ದೇಖಾನ ಕೋ ಹುಯುನಿ ಇನಖ್ಹಾಜೆ ಹೆರೋದನೆ ಕಾವ್ಲಿ ಕರವಾಳನ ವಿಚಾರ್‌ಕರಿನ್ ಇವ್ಣುನ ಅಖ್ಖು ಮರಣ್ಣಿ ದಂಡಣೆನ ದಿನಾಖ್ಯೊ. ಹೆರೋದನೆ ಥೋಡ ಹಗಾಮ್ ಯೂದಾಯಥೊ ಜೈ಼ನ್ ಕೈಸರ ಖ್ಹಯೇರ್‌ಮ ರ‍್ಹಿಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","ತೂರ್ ಅಜು಼ ಸಿದೋಮ್ ಖ್ಹಯೇರ‍್ನ ಅದ್ಮಿವೋನ ಉಪ್ಪರ್ ಹೆರೋದನೆ ಜಾ಼ಖ್ಹತ್ ಇರಾದೊ ಕರಿರಾಖ್ಯೊಸ್‍ಕರಿ, ಯೊ ಅದ್ಮಿಖ್ಹಾರು ಹೆರೋದನ ಮಳಾನ ಜಮಹುಯಿನ್ ನಿಕ್‍ಳ್ಯು. ಇವ್ಣೆ ರಾಜ಼ನೊ ಮಹೇಲ್‌ನದೇಖಿಲ್ಯವಾಳೊ ಮೋಟೊ ಅದಿಕಾರಿ ಹುಯಿರೊಥೋತೆ ಬ್ಲಾಸ್ತನನ ಪೊಖ್ಹ್‌ಲೈನ್ ಮದತ್‌ಕರ್‌ ಕರಿ ರಾಜ಼ ಇವ್ಣಿ ಜೋ಼ಡ್ಮ ಶಾಂತಿಹುಯಿನ್ ಮಳಿಜಾ಼ವ್ಣುಕರಿ ಹೆರೋದನ ಬೋಲಿಲಿದು. ಶನಖ್ಹಾಜೆ ಕತೊ ಇವ್ಣ ಮುಲಕ್ನ ಹೆರೋದನ ಮುಲಕ್‍ಥು ಖಾಣಾನು ಜಿನಖ್ಹ್‌ ಮಂಗೈಲೆವ್ಣುಥು. ");
INSERT INTO vaa_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","ಇವ್ಣುನ ಮಳಾನಖ್ಹಾಜೆ ಹೆರೋದನೆ ಏಕ್‌ ದನ್ ಗೊತ್‍ಕರೀನ್ ಮ್ಹೇಲ್ಯೊ. ತದೆ ಹೆರೋದಾನೆ ಇನ ರಾಜಾ಼ನು ಪೆರ್ವಾಖ್ಹ್‌ ಫೇರಿಲಿನ್ ಇನೆ ಸಿಂಹಾಸನ್ನ ಉಪ್ಪರ್ ಬೇಶಿನ್ ಅದ್ಮಿವೋನ ಉಪದೇಶ್ ಕರ‍್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","ಹಿಜ್ಜಾ಼ ಅದ್ಮಿಖ್ಹಾರು ಆ ಹೈರುತೆ ಅದ್ಮಿನು ಟಹುಕೊ ಕಾಹೆ. ಆ ದೇವ್‌ನೊ ಟಹುಕೊ ಕರಿ ಕೂಘಾಟಿ ಕರ‍್ಯು. ");
INSERT INTO vaa_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","ಪ್ರಭುನ ದೂತನೆ ತುರಂತ್ ಹೆರೋದನ ದಂಬೇಡಿ ಹೇಟ್‌ನಾಖ್ಯೊ; ಯೋ ದೇವ್ನ ಮರ್ಯಾದಿ ಕೊದಿದೊಂತೆ ಇನಖ್ಹಾಜೆ ಯೊ ಕೀಡೊ ಪಡೀನ್ ಮರಿಗೊ. ");
INSERT INTO vaa_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","ಕತೋಬಿ ದೇವ್ನಿ ವಚನ್ ಭಡ್ಯು ಅಜು಼ ಜಾ಼ಖ್ಹತ್ ಹುಯು. ");
INSERT INTO vaa_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","ಬಾರ್ನಬಬಿ ಸೌಲನೆ ಇವ್ಣೆ ಕರ್ನುಥೂತೆ ಸೇವೆನ ಕಾಮ್ನ ಖ್ಹರ್ತಿಕರಿನ್ ಮಾರ್ಕಕರಿ ಬೋಲೈಲಿದೋತೆ ಯೋಹಾನಕನ ಬುಲೈಲಿನ್ ಯೆರೂಸಲೇಮ್‍ಥು ಪಾಛು಼ ಅಂತಿಯೋಕ್ಯನ ಆಯ. ");
INSERT INTO vaa_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","ಅಂತಿಯೋಕ್ಯಮ ಥೂತೆ ಸಬೆಮ ಖ್ಹಾರು ಪ್ರವಾದಿಬಿ ಬೋಧಕರ್‌ಬಿ ಥೂ; ಇವ್ಣೆ ಕೋಣ್‌ಕತೊ, ಬಾರ್ನಬ, ನೀಗರ್‌ಕರಿ ಬೋಲೈಲಾವಳೊ ಸಿಮೆಯೋನ್‌, ಕುರೇನ್ಯನೊ ಲೂಕ್ಯ,ಹೆರೋದ ರಾಜ಼ನಿ ಜೋ಼ಡ್ಮ ಪಳ್ಯೊತೆ ಮೆನಹೇನ, ಅಜು಼ ಸೌಲ. ");
INSERT INTO vaa_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","ಅವ್ಣೆಖ್ಹಾರು ಪ್ರಭುನಿ ಸೇವೆ ಕರುಕರ್ತುಥು ಅಜು಼ ಉಪವಾಸ್ (ಪಾರ‍್ನೆ) ಕರುಕರ್ತುಥು. ಪವಿತ್ರಾತ್ಮನೆ ಇವ್ಣುನ “ಮೇ ವಿಶೇಷ್ ಕಾಮ್ನಖ್ಹಾಜೆ ಬಾರ್ನಬ ಅಜು಼ ಸೌಲನ ಚೂ಼ಣಿಲಿದೊ ಯೋ ಕಾಮ್ನಖ್ಹಾಜೆ ಇವ್ಣುನ ಅಲಕ್‍ಕಾಡ್ಯೊ.” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","ಇನಖ್ಹಾಜೆ ಸಬೆವಾಳು ಉಪವಾಸ್ ರ‍್ಹೀನ್ ಪ್ರಾರ್ಥನೆ ಕರಿನ್ ಬಾರ್ನಬ ಸೌಲನ ಉಪ್ಪರ್ ಹಾತ್‍ಮ್ಹೇಲಿನ್‍ ಇವ್ಣುನ ಬೋಲಿ ಮೋಕ್‍ಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","ಬಾರ್ನಬ ಬಿಜು಼ ಸೌಲ ಪವಿತ್ರಾತ್ಮನೇಸ್ ಬೋಲಿಮೋಕ್‌ಲ್ಯೊ. ಇವ್ಣೆ ಸೆಲ್ಯೂಕ್ಯ ಖ್ಹಯೇರ‍್ನ ಜೈ಼ನ್, ಹಿಜ್ಜಾ಼ಥ ಸೈಪ್ರಸ್ ಟಾಪನ ಜ಼ಹಾಜ಼್‍ಮ ಗಯ. ");
INSERT INTO vaa_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","ಬಾರ್ನಬ ಅಜು಼ ಸೌಲ ಸಲಾಮಿಸ್ ಕರಿ ಖ್ಹಯೇರ‍್ನ ಜಾ಼ವಾದಿನ್, ಯೆಹೂದ್ಯರ‍್ನು ಸಬಾ ಮಂದಿರ್‌ಮ ದೇವ್ನಿ ಭೋದನೆನ ಬೋಲ್ಯ. ಮಾರ್ಕಕರಿ ಬೋಲೈರ‍್ಹೋತೆ ಯೋಹಾನ ಇನ ಸೇವೆ ಕರಾನಖ್ಹಾಜೆ ಇನಿ ಜೋ಼ಡ್ಮ ಥೊ. ");
INSERT INTO vaa_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","ಇವ್ಣೆ ಯೋ ಟಾಪಾನಿ ಅಖ್ಖಿಬಾಜು಼ ಜಾ಼ತಹುಯಿನ್ ಪಾಫೋಸ್ ಕರಿ ಗಾಮ್‌ನಗಯ. ಇವ್ಣೆ ಜಾ಼ದುಜ಼ಮ್‌ಕರ್‌ ಕರಾವಾಳ ಏಕ್‌ ಯೆಹೂದ್ಯವಾಳನ ಪಾಫೋಸ್ಮ ದೇಖ್ಯ. ಇನು ನಾಮ್ ‘ಬಾರ್‌ಯೇಸು’ ಯೋ ಏಕ್‌ ಝೂ಼ಟುಪ್ರವಾದಿ ಹುಯಿರ‍್ಹೊಥೊ. ");
INSERT INTO vaa_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","ಸೆರ್ಗ್ಯ ಪೌಲಕರಿ ನಾಮ್‍ವಾಳೊ ದೋಸ್ತ್ ಆ ರಾಜ್ಯಪಾಲ್‌ನ ಖನ್ನೆಸ್‌ ಕದೇಬಿ ರ‍್ಹೇತೊಥೊ. ಸೆರ್ಗ್ಯ ಪೌಲ ಅಕ್ಕಲ್‍ವಾಳೊ ಹುಯಿರ‍್ಹೊಥೊ. ಯೋ ದೇವ್ನಿ ವಚನ್ ಖ್ಹಮ್‌ಜಾ಼ನ ಬಾರ್ನಬ, ಸೌಲನ ಬುಲಾಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","ಕತೋಬಿ ಯೊ ಮಂತ್ರವಾದಿ ಹುಯಿರೋತೆ ಎಲುಮ (ಎಲುಮಕರಿ ನಾಮ್ನೊ ಮಂತ್ರವಾದಿ) ವಿರೋದ್ ಹುಯಿರ‍್ಹೋಥೊ. ರಾಜ್ಯಪಾಲ್‌ನೆ ಕ್ರಿಸ್ತಮ ವಿಶ್ವಾಸ್ ನಾ ಕರ್ನುತೆ ತಿಮ್ ಎಲಿಮನೆ ಕೋಶಿಶ್ ಕರ‍್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","ತದೆ ಪೌಲಕರಿ ಬೋಲೈಲ್ಯಾವಾಳೊ ಸೌಲ ಪವಿತ್ರಾತ್ಮಥಿ ಭರೈನ್,ಎಲಿಮ ಠರ್‌ಕೈ ದೇಖಿನ್; ");
INSERT INTO vaa_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","ಇನೆ “ತೂ ಶೈತಾನ್ನೊ ಛಿಯ್ಯೊ! ಹರ್ ಏಕ್‍ ಅಛ್ಛಾ಼ನಾಬಿ ತೂ ವಹೇರ‍್ಯೊ” ತು ಖರಾಬ್ ಚಾ಼ಲ್‌ಥೀಬಿ ಝೂ಼ಟೆಥೀಬಿ ಭರೈರ‍್ಹೋಸ್. ಅಖ್ಖಿ ನೀತಿನಾಬಿ ವಿರೋದ್ ಕರವಾಳೋಸ್ ತೂ, ಪ್ರಭುನ ಖ್ಹಾಚಾನ, ಝೂ಼ಟಿಕರಿ ಬದ್ಲಾವನ ತೂ ಕದೇಬಿ ಕೋಶಿಶ್ ಕರ್ತೊರ‍್ಹೇಸ್. ");
INSERT INTO vaa_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","ಹಂದೇಕ್ ಪ್ರಭು ತಾರಿ ವಿರೋದ್ ಹಾತ್‍ಪಾಡಿರಾಖ್ಯೊಸ್. ತೂ ಕಾಣೊಹುಯಿಶ್ ಥೋಡದನ್ ಶಾತ್ಬಿ ದೇಖಿಶ್‌ ಕೊಯ್ನಿ; ಚಾ಼ಂದ್‌ನು ಉಜಾ಼ಳುಬಿ ದೇಖಿಶ್‍ಕೊಯ್ನಿ.” ಕರಿ ಬೋಲ್ಯೊ. ತದೆ ಎಲಿಮನ ಅಖ್ಖೂಸ್ ಅಂಧಾರುಹುಯಿಗು. ಇನ ಕೋಣ್‌ತೋಬಿ ಹಾತ್‍ಧರಿ ಚ಼ಲಾವಾದೆಕರಿ ಯೋ ಢೂಂಡ್ತೊಹುಯಿನ್ ಫರುಕರ್ತೊಥೊ. ");
INSERT INTO vaa_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","ಅನ ದೆಖ್ಯೊತೆ ರಾಜ್ಯಪಾಲ್‌ನೆ ಪ್ರಭುಪರ್ ವಿಶ್ವಾಸ್‍ಕರಿನ್ ಪ್ರಭುನಿಬಾರೆನು ಶಿಕಾಡನು ಖ್ಹಮ್‌ಜಿನ್‌ ಆಶ್ಚರ್ಯ ಕರ‍್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","ಪೌಲ ಅಜು಼ ಇನ ಜೋ಼ಡ್‍ವಾಳು ಪಾಫೋಸ್‍ಥು ಜ಼ಹಾಜ಼್‌ಪರ್ ನಿಕ್ಳಿನ್, ಪಂಫುಲ್ಯ ತಬರ್‌ಖಾನು ಪೆರ್ಗೆಕರಿ ಖ್ಹಯೇರ‍್ನ ಇವ್ಣೆ ಆಯು. ಕತೋಬಿ ಯೋಹಾನ ಇವ್ಣುನ ಮ್ಹೇಲಿನ್ ಯೆರೂಸಲೇಮ್‌ನ ಪಾಛೊ಼ ಫರಿಗಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","ಇವ್ಣೆ ಪೆರ್ಗೆ ಗಾಮ್‍ಥ ನಿಕ್ಳಿನ್ ಪಿಸಿದ್ಯ ತಬರ್‌ಖಾನು ಮಳ್ಯುಹುಯು ಅಂತಿಯೋಕ್ಯನ ಆಯ. ಇವ್ಣೆ ಸಬ್ಬತ್‌ ದನ್ಮ ಯೆಹೂದ್ಯರ‍್ನು ಸಬಾಮಂದಿರ್‌ಮ ಜೈ಼ನ್ ಬೇಶಿಗಯ. ");
INSERT INTO vaa_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","ಮೋಶೆನ ಧರ್ಮಶಾಸ್ತ್ರಕನ ಅಜು಼ ಪ್ರವಾದಿಖ್ಹಾರನ ದಪ್ತರ್‌ನ ಪಢೈ ಹುಯಿಜಾ಼ವಾದಿನ್ ಸಬಾಮಂದಿರ್‌ನೊ ಗಲ್‍ಢಖ್ಹಾರಾನೆ ಪೌಲ ಬಾರ್ನಬ, “ಭೈಯೇ ಭೇನೆವೊ, ಅದ್ಮಿಖ್ಹಾರಾನ ಮದತ್ ಹುವಾನಿತರ ಶಾತ್ತೋಬಿ ಭಾಲಿನಿವಾತೆ ಬೋಲ್ನುಕರಿ ಉಷೇತೊ ತುಮೆ ಬೋಲೊ” ಕರಿ ಇವ್ಣಕನ ಬೋಲಿ ಮೋಕ್‍ಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","ತದೆ ಪೌಲನೆ ಉಠಿಭೀರಿನ್ ಇನಿವಾತ್ ಖ್ಹಮಜ಼್‌ಣುಕರಿ ಅದ್ಮಿಖ್ಹಾರಾನ ಹಾತ್‌ನೊ ಝಾ಼ಲೊದೀನ್ ಶಾತ್‍ಬೋಲ್ಯೊಕತೊ; ಮಾರ ಯೆಹೂದ್ಯ ಭೈಯೇವೊ, ಖ್ಹಾಚ ದೇವ್ನ ಆರಾದನೆ ಕರಾವಾಳು ಅದ್ಮಿವೊ ಮಾರಿವಾತೆನ ಕಾನ್‍ದೇವೊ! ");
INSERT INTO vaa_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","ಅಪ್ಣೊ ಇಸ್ರಾಯೇಲ್‌ನೊ ದೇವ್ ಹಮಾರ ಗುರುಗುರಬ್‌ಲ್ಯನ ಚೂ಼ಣಿಲಿದೊ. ಈಜಿಪ್ಟ್‌ಮ ಜಿವ್ಣುಕರುಕರ್ತುಥೂತೆ ಇನ ಅದ್ಮಿಖ್ಹಾರಾನ ದೇವ್ ಮದತ್‍ಕರಿನ್ ಮೋಟೊ ದೇಖ್ಹ್‌ಕರಿ ಭಡಾಯೊ. ದೇವ್ ಇನಿ ಮೋಟಿಶಕಥ್ಥಿ ಇವ್ಣುನ ಯೊ ದೇಖ್ಹ್‌ಮ ಚ಼ಲಾಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","ಯೊ ಖ್ಹುಮಾರ್ ಚಾ಼ಳಿಖ್ಹ್ ವರಖ್ಹ್ ಲಗು ಜ಼ಂಗಳ್‌ಮ ಇವ್ಣುನ ಖ್ಹಮಾಳಿಲಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","ಕಾನಾನ್ ದೇಖ್ಹ್‌ಮ ಥೂತೆ ಅಲ್ಹಾವ್‌ ಅದ್ಮಿವೋನು ಖ್ಹಾತ್ ಮುಲಕ್ನ ನಾಶ್‍ಕರಿನ್, ಯೋ ಝ಼ಗೋನ ಇವ್ಣುನ ವಾಗ್ದಾನ್ ಕರಿದಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","ಆ ಖ್ಹಾರು ಖ್ಹುಮಾರ್ ಚಾರ್ ಖ್ಹೊ ಅಡೈವಿಖ್ಹ್‌ ವರಖ್ಹ್ ಘಟಿಗಯು. ಇನಕೇಡೆಥು ಪ್ರವಾದಿಹುಯಿರೋತೆ ಸಮುವೇಲನ ಹಗಾಮ್‍ಲಗು ದೇವ್ ಅಪ್ಣ ಅದ್ಮಿನ ನ್ಯಾವ್‍ನೊ ಅದಿಪತಿನ ದಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","ಆ ಹುವಾದಿನ್ ಅದ್ಮಿಖ್ಹಾರು ಇವ್ಣುನ ರಾಜ಼ ಹೋಣುಕರಿ ಬೋಲಿದಿದು. ದೇವ್ ಇವ್ಣುನ ಕೀಷಾನೊ ಛಿಯ್ಯೊ ಸೌಲನ ದಿದೊ. ಸೌಲ ಬೆನ್ಯಾಮೀನ್ ಖೂಮ್‌ವಾಳೊ ಯೋ ಚಾ಼ಳಿಖ್ಹ್ ವರಖ್ಹ್ ರಾಜ಼ ಹುಯಿರೋಥೊ ");
INSERT INTO vaa_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","ದೇವ್ ಸೌಲನ ಕಾಡಿನಾಖನಪಾರ್ ದಾವೀದನ ಇವ್ಣೊ ರಾಜ಼ ಬಣಾಯೊ, “ಇಷಯನೊ ಛಿಯ್ಯೊ ದಾವೀದ ಮನ ಮಳ್ಯೊ, ಯೋ ಮಾರಾ ದಿಲ್ನ ಲಾಗ್ಯೊಹುಯೊ, ಯೊ ಮಾರಿ ಆಖ್ಹ್‌ನಿತರಾಸ್ ಕಾಮ್ ಕರಸ್. ಕರಿ ದೇವ್ ದಾವೀದ್‍ನಿ ಬಾರೇಮ ಸಾಕ್ಷಿ ಬೋಲಿರಾಖ್ಯೊಸ್. ");
INSERT INTO vaa_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","ದೇವ್ ಇನಿ ವಾಗ್ದಾನಿಘೋಣಿಸ್ ದಾವೀದ್‍ನಿ ಖಾನ್‍ದಾನ್‍ಮಾಥು ಏಕ್‍ಜ಼ಣಾನ ಇಸ್ರಾಯೇಲ್‍ವಾಳನೊ ರಕ್ಷಕ್ ಕರಿ ಮೋಕ್ಲಿರಾಖ್ಯೊಸ್, ಯೋಸ್ ಯೇಸು. ");
INSERT INTO vaa_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","ಯೇಸು ಆವಾನ ಅಗಾಡಿ ಯೋಹಾನ ಇಸ್ರಾಯೇಲ್ ಅದ್ಮಿಖ್ಹಾರಾನ, ‘ತುಮಾರಿ ಪಾಪ್ನಖ್ಹಾಜೆ ಪಶ್ಚತ್ತಾಪ್ ಕರೀನ್ ದೇವ್‌ಭಣಿ ಫರಿಜೈನ್ ಬ್ಯಾಪ್ತಿಸ್ಮ ಕರೈಲೇವೊ’ ಕರಿ ಬೋಧನೆ ಕರ‍್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","ಮೇ ಕೋಣ್‌ಕರಿ ತುಮೆ ಸೋಚೊಸ್? ಮೆ ಕ್ರಿಸ್ತಕಾಹೆ, ಯೋ ಮಾರ ಪಾಛ಼ಳ್ ಆವ್‌ಶೆ ಇನಿ ಖೋಖ್ಹ್‌ಡಾನಿ ಡೋರಿನಾಬಿ ಛೋ಼ಡಾನಾಬಿ ಮೇ ಲ್ಹಾಯೇಕ್‍ಕೊಯ್ನಿ’ ಕರಿ ಯೋಹಾನ ಇನು ಕಾಮ್‍ಕರಿನ್ ಖ್ಹರ್ತಿಕರಾನಿ ವೇಳ್ಮ ಬೋಲಿರಾಖ್ಯೊಸ್. ");
INSERT INTO vaa_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","ಮಾರ ಭೈಯೇವೊ, ಅಬ್ರಹಾಮ್‌ನಿ ಖಾನ್‍ದಾನ್‍ವಾಳವೋ, ಖ್ಹಾಚ ದೇವ್ನ ಆರಾದನೆ ಕರುಕರಾತೆ ಯೆಹೂದ್ಯರ್‌ಕಾಹೆತೆ ಅದ್ಮಿವೊ, ಖ್ಹಮ್‍ಜೊ! ಆ ರಕ್ಷಣೆನು ವಚನ್ ಮೋಕ್‍ಲೈರ‍್ಹುತೆ ಅಪ್ಣಖ್ಹಾಜೇಸ್. ");
INSERT INTO vaa_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","ಯೆರೂಸಲೇಮ್‍ ಜಿವ್ಣು ಕರುಕರ್ತುಥೂತೆ ಅದ್ಮಿಖ್ಹಾರು ಇವ್ಣು ಅದಿಕಾರಿ ಖ್ಹಾರುಬಿ ಯೋ ರಕ್ಷಕ್ ಕರಿ ಖ್ಹಣೇದ್ ಕರಿಲಿದುಕೊಯ್ನಿ. ಪ್ರವಾದಿಖ್ಹಾರು ಯೇಸುನಿ ಬಾರೇಮ ಲೀರಾಖ್ಯುಥೂತೆ ವಾತೆಖ್ಹಾರಿ ಮಾಲುಮ್ ಕೊ ಹುಯುನಿ ಹರೇಕ್ ಸಬ್ಬತ್ ದನ್ಮ ಇವ್ಣೆ ಫಡ್‍ತುಥೂತೆ ವಾತೆ ಪೂರಹುಯು. ಕತೋಬಿ ಇವ್ಣೆ ಮಾಲುಮ್‌ ಕರಿಲಿದುಕೊಯ್ನಿ. ಯೋ ಯೆಹೂದ್ಯರ್ ಖ್ಹಾರು ಯೇಸುನ ಅಪರಾದಿಕರಿ ತೀರ್ಪ್‌ದಿದು. ಅಮ್ ಕರಾಥಿ ಪ್ರವಾದಿಖ್ಹಾರಾನಿ ವಾತೆನ ಚಾ಼ಲಖ್ಹರ್ಕು ಕರ‍್ಯು.” ");
INSERT INTO vaa_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","ಯೇಸುನ ಮರಣ್ಣಿ ದಂಡನೆ ದ್ಯವಾನ ಬರೋಬರ್‌ನಿ ಕಾರಣ್ ನಾಮಳ್ಯುತೋಬಿ ಇನ ಮರಾವ್ಣುಕರಿ ಪಿಲಾತನ ಬೋಲಿಲಿದು. ");
INSERT INTO vaa_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","ಪವಿತ್ರ ಪುಸ್ತಕ್‌ಮ ಲೀಖೈರುತೆ ಪರಕ್ಮ ಯೇಸುನ ಹುವಾನುಥೂತೆ ಅಖ್ಖೀಸ್ ಖ್ಹತಾಪ್ಣಿನ ಯೆಹೂದ್ಯರ್‌ನೆ ಇನ ದಿದು. ಇನಪಾರ್ ಇವ್ಣೆ ಶಿಲ್‌ಬೆಪರ್‌ಥು ಯೇಸುನ ಹೇಟ್ ಉತಾರಿನ್‌ ಘವಿಮ ಘಾಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","ಕತೋಬಿ ದೇವ್ನೆ ಇನ ಮರ‍್ಯಹುಯಮಾಥು ಜೂತೊ ಕರೀನ್ ಉಠಾಡ್ಯೊ, ");
INSERT INTO vaa_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","ಆ ಹುಯಿಗು ತದೆ ಗಲಿಲಾಯಥು ಯೇಸುನಿ ಜೋ಼ಡ್ಮ ಯೆರೂಸಲೇಮ್ಮ ಆಯುಥೂತೆ ಇವ್ಣೆ ಕೈಏಕ್ ದನ್‌ಲಗು ಇನದೇಖ್ಯು. ಹಮ್ಕೆ ಇವ್ಣೇಸ್ ಅಪ್ಣ ಅದ್ಮಿಖ್ಹಾರಾನ ಸಾಕ್ಷಿಹುಯಿರ‍್ಹುಸ್. ");
INSERT INTO vaa_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","ದೇವ್ ಹಮಾರ ಗುರುಗುರಬ್‌ಲ್ಯನ ಕರ‍್ಯೊತೆ ವಾಗ್ದಾನ್ನಿ ಬಾರೇಮ ಸುವಾರ್ತೆನ ಹಮೆ ತುಮೂನ ಬೋಲಿಯೇಸ್. ");
INSERT INTO vaa_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","ತುಮೆ ಇವ್ಣ ಖಾನ್‍ದಾನ್‍ವಾಳ ಹುಯಿರ‍್ಹಾಸ್. ದೇವ್ ಯೇಸುನ ಮರ‍್ಯಹುಯಮಾಥು ಜೂತೊಕರೀನ್ ಉಠಾಡಾಥಿ ಯೋ ವಾಗ್ದಾನ್ನ ಅಪ್ಣಖ್ಹಾಜೆ ಚ಼ಲೈರಾಖ್ಯೊಸ್. ಅನಿ ಬಾರೇಮ ಬೇನಿ ಕೀರ್ತನೇಮ ಅಮ್ ಲೀಖೈರ‍್ಹುಸ್. ‘ತೂ ಮಾರೊ ಛಿಯ್ಯೊ ಹಮ್ಕೇಸ್ ಮೇ ತುನ ಬಾ ಹುಯಿರ‍್ಹೊಸ್.’ ");
INSERT INTO vaa_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","ದೇವ್ ಯೇಸುನ ಮರ‍್ಯಹುಯಮಾಥು ಜೂತೊಕರೀನ್ ಉಠಾಡ್ಯೊತೆ ಇನಖ್ಹಾಜೆ, ಯೋ ಬಿಜು಼ ಕದೇಬಿ ಮಖ್ಹಾಣ್ಯಮ ಪೇಶಿನ್ ಖ್ಹಡ್‍ಶೆಕೊಯ್ನಿ ಕರಿ ಬೋಲಾನಿ ಬಾರೇಮ ದೇವ್ನೆ ಅಮ್ ಬೋಲಿರಾಖ್ಯುತೆ ಶಾತ್‌ಕತೊ; ಮೇ ಖ್ಹಚ್ಚೆಂಬಿ ದಾವೀದನ ಕರ‍್ಯೊತೆ ವಾಗ್ದಾನ್ನ ವಾರ್ಖ್ಹಾ ಅಖ್ಖಾನ ತುಮುನಾಬಿ ದೆವುಸ್.” ಯೊ ವಿಶ್ವಾಸ್‌ನುಸ್ ಕರಿ ಬೋಲೆಜಾ಼ಯ್‌. ");
INSERT INTO vaa_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","‘ತೂ ತಾರ ವಿಶ್ವಾಸ್‌ನೊ ಸೇವಕ್‌ನ ಮಖ್ಹಾಣ್ಯನ ಖ್ಹಡ್ವಾನ ಮ್ಹೇಲಿಶ್‍ಕೊಯ್ನಿ’ ಕರಿ ಬೋಲಿರಾಖ್ಯೊಸ್. ");
INSERT INTO vaa_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","ದಾವೀದ್‌ನೆ ಜಿವ್ತೊಥೋತೆ ದನ್‌ಖ್ಹಾರು ದೇವ್ನಿ ಚಿತ್ತಾನಿಘೊಣಿ ಜಿವ್ಯೊ. ಇನಪಾರ್ ಯೊ ಮರಿಗಯೊ,ದಾವಿದನ ಇನ ಗುರುಖ್ಹಾರಾನಿ ಜೋ಼ಡ್ಮ ಮಖ್ಹಾಣ್ಯು ಕರ‍್ಯು. ಇನಿ ಶರೀರ್ ಖ್ಹಡಿಗಯು. ");
INSERT INTO vaa_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","ಕತೋಬಿ ದೇವ್ ಮರಣ್‌ಥು ಜಿವ್ತೊಹುಯಿನ್ ಉಠ್ಯೊತೆ ಯೇಸುನು ಶರೀರ್ ಮಖ್ಹಾಣ್ಯಮ ಖ್ಹಡೈಗಯುಕೊಯ್ನಿ. ");
INSERT INTO vaa_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","ಮೋಶೆನ ಧರ್ಮಶಾಸ್ತ್ರಥೀಸ್ ತುಮೆ ಛುಟ್ಕಾರ್‌ ಹುಯಿನ್ ನೀತಿವಾಳಕೊಯ್ನಿ ಕರಿ ಬೋಲೈರ‍್ಹಾಸ್.ಇನಖ್ಹಾಜೆ ಭೈಯೇವೊ, ಆ ತುಮೂನ ಮಾಲುಮ್ ರ‍್ಹವಾದೆ; ಯೇಸುಥೀಸ್ ತುಮಾರಿ ಪಾಪ್ನ ಕ್ಷಮಾಪಣ್ ಮಳ್‌ಶೆಕರಿ ಬೋಲುಸ್. ");
INSERT INTO vaa_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","ಅನಖ್ಹಾಜೆಸ್ ಯೇಸುಮ ವಿಶ್ವಾಸ್ ಕರಾವಾಳ ಹರೇಕ್‍ಜ಼ಣಾನ ಇನೇಥಿಸ್ ಇವ್ಣ ಅಖ್ಖಾಪಾಪ್‍ನ ಕ್ಷಮಾಪಣ್ ಮಳ್‍ಶೆ. ಧರ್ಮಶಾಸ್ತ್ರಥಿ ತುಮಾರಿ ಪಾಪ್ನ ಛೋ಼ಡಾವನ ಹುವಾಕೊಯ್ನಿ. ");
INSERT INTO vaa_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","ಇನಖ್ಹಾಜೆ ಪ್ರವಾದಿಖ್ಹಾರನ ದಪ್ತರ್‌ಮ ಬೋಲೈರ‍್ಹುತೆ ತುಮೂನ ನಾಚಾ಼ಲ್ನು ತಿಮ್ ದೇಖಿಲೇವೊ. ಯೋ ಶಾತ್‍ಕತೊ; ");
INSERT INTO vaa_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘ಹಂದೇಖೊ ಚಿಂಘಾವವಾಳವೊ, ಆಶ್ಚರ್ಯ ಕರ್ತಹುಯಿನ್ ನಾಶ್‍ಹುಯಿಜಾ಼ವೊ. ತುಮಾರ ಹಗಾಮ್ಮ ಮೇ ಏಕ್‌ ಕಾಮ್ ಕರೀಶ್; ಬಿಜೆಕ್‍ಜ಼ಣೊ ಇನ ಛೋ಼ಡಿವತಾಳ್ಯೊ ತೋಬಿ ಇನ ತುಮೆ ವಿಶ್ವಾಸ್ ಕರ್ಶು ಕೊಯ್ನಿ!’ ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","ಪೌಲ,ಬಾರ್ನಬ ಸಬಾಮಂದಿರ್‌ಮಾಥು ಜಾ಼ವಾನಿ ವಖ್ಹ್‌ತೆ ಆ ವಾತೆನಿ ಬಾರೇಮ ಬಿಜೂ಼ಬಿ ಜಾ಼ಖ್ಹತ್ ಹಮೂನ ಬೋಲಿ ದ್ಯವಾನಖ್ಹಾಜೆ ಅಗ್‍ಲ್ಯ ಸಬ್ಬತ್‌ ದನ್‌ಲಗು ಪಾಛ಼ ಆವ್ಣುಕರಿ ಅದ್ಮಿಖ್ಹಾರಾನೆ ಇವ್ಣುನ ಬೋಲಿಲಿದು. ");
INSERT INTO vaa_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","ಸಭೆ ಖ್ಹತಮ್ ಹುವಾದಿನ್ ಕೈಏಕ್ ಯೆಹೂದ್ಯರ್ ಖ್ಹಾರು ಹಿಜ಼್ಜಾಥೂತೆ ಬಾರ್ನಬನ ಪೀಠೆಗಯು. ಯೆಹೂದ್ಯನಿ ಜಾ಼ತ್ಮಮಳ್ಯುಹುಯು ಅಜು಼ ಯೆಹೂದ್ಯರ್‌ಕಾಹೆತೆ ಇವ್ಣೆ ಇನಿ ಜೋ಼ಡ್ಮಥು. ಜಾ಼ಥ್ಥಿ ಜಾ಼ತ್‍ ಬದಲ್ಯುಹುಯು ಇವ್ಣೆಜಿನೂಬಿ ಖ್ಹಾಚದೇವ್ನ ಆರಾದನೆ ಕರ್ತುಥು. ಪೌಲ ಬಾರ್ನಬ ಇವ್ಣಿ ಜೋ಼ಡ್ಮ ವಾತ್ ಬೋಲಿನ್, ದೇವ್ನಿ ವಾರ್ಖ್ಹಮಾಸ್ ವಿಶ್ವಾಸ್‌ರಾಖಿನ್ ಅಗಾಡಿ ಭಡ್ನುಕರಿ ಇವ್ಣುನ ಹುಮ್ಮಖ್ಹ್‌ ಕರ‍್ಯಾ. ");
INSERT INTO vaa_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","ಅಗಲ್ಯ ಸಬ್ಬತ್ ದನ್ನೆ ಪ್ರಭುನು ವಚನ್ ಖ್ಹಮ್‌ಜಾ಼ನಖ್ಹಾಜೆ ಘಣುಜ಼ಣು ಖ್ಹಯೇರ‍್ನು ಅದ್ಮಿಖ್ಹಾರು ಆಯಿನ್ ಭರಾಯು. ");
INSERT INTO vaa_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","ಅನದೆಖ್ಯುತೆ ಯೆಹೂದ್ಯರ್ ಖ್ಹಾರಾನೆ ಘಣು ಬಳಾಪೊಕರಿನ್ ಪೌಲನೆ ಬೋಲ್ಯೊತೆ ವಾತೆನ ವಿರೋದ್ ಹುಯಿನ್ ಅಬ್ಬಾಜ಼ಬ್ಬಿಥಿ ದೂಷಣೆನಿ ವಾತೆಬೋಲ್‍ತು ರ‍್ಹಿಯು. ");
INSERT INTO vaa_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","ಕತೋಬಿ ಪೌಲ,ಬಾರ್ನಬನೆ ಜಾ಼ಖ್ಹತ್ ಹಿಮ್ಮಥ್ಥಿ ವಾತೆಬೋಲಿನ್, “ಹಮೆ ದೇವ್ನಿ ವಚನ್ ಯೆಹೂದ್ಯರ್ ಹುಯಿರಾತೆ ತುಮೂನ ಪಹಿಲೆ ಬೊಲ್ನುಸ್‍ ಬೋಲ್ನುಥು. ಕತೋಬಿ ತುಮೆ ಇನ ಧಕೇಲಿದಿನ್ ಹರ್‌ಹಮೇಶಾನಿ ಜಿ಼ಂದ್‌ಗಿ ಕೋ ಮಳ್‍ಶೇನಿಕರಿ ತೀರ್ಪ್‌ ಕರಿಲಿದಾತೆ ಇನಖ್ಹಾಜೆ, ಹಮೆ ಅಲ್ಹಾವ್‌ ಜಾ಼ತ್‍ವಾಳಭಣಿ ಜ಼ಯೇಸ್. ");
INSERT INTO vaa_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","ಶನಕತೊ ಪ್ರಭುನೆ ದಿದೋತೆ ಹುಕುಮ್‌ ಅಮ್‍ ಛಾ಼, ‘ಜಗತ್ನೊ ಖ್ಹರ್ತಿಲಗು ಛಾ಼ತೆ ಅದ್ಮಿಖ್ಹಾರಾನ ತೂ ರಕ್ಷಕ್ ಹುಯಿರ‍್ಹೇವ್ಣು ಕರಿ ಮೇ ತುನ ಯೆಹೂದ್ಯರ್‌ಕಾಹೆತೆ ಅದ್ಮಿನ ಉಜಾ಼ಳು ಕರಿ ಬಣೈರಾಖ್ಯೊಸ್.” ");
INSERT INTO vaa_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","ಪೌಲನಿ ಆ ವಾತೆನ ಖ್ಹಮ್‍ಜ್ಯುತೆ ಅಲ್ಹಾವ್‌ ಅದ್ಮಿಖ್ಹಾರು ಘಣು ಖುಷಿಕರೀನ್ ಪ್ರಭುನಿ ವಾತೇನಖ್ಹಾಜೆ ಸ್ತುತಿ ಕರ‍್ಯು. ಹಮೇಶಾನಿ ಜಿ಼ಂದ್‌ಗಿ ಲೀಲ್ಯಾವನ ಚೂ಼ಣೈರ‍್ಹುತೆ ಖ್ಹಾರೂಸ್ ವಿಶ್ವಾಸ್ ಕರ‍್ಯು. ");
INSERT INTO vaa_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","ಪ್ರಭುನಿ ವಚನ್ನ ಯೋ ಖ್ಹಯೇರ‍್ನಿ ಅಖ್ಖಿಸ್‍ಬಾಜು಼ ಫೈಲಾಯು. ");
INSERT INTO vaa_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","ಕತೋಬಿ ಯೆಹೂದ್ಯರ್ ಖ್ಹಾರು ಥೋಡಿ ಇವ್ಣಿ ಜಾ಼ತ್ನಿ ಭಕ್ತೆ ಶೌಕಾರ್ ತಯೇಡಾವ್‍ನ ಅಜು಼ ಖ್ಹಯೇರ‍್ನ ಗಲ್‌ಢಖ್ಹಾರು ದೇವ್ನ ಆರಾದನೆ ಕರುಕರ್ತುಥು. ಇವ್ಣೆ ಖ್ಹಾರು ಮಳಿನ್ ಪೌಲ ಬಾರ್ನಬನ ಉಪ್ಪರ್ ಇರಾದೊ ಕರ್ನುತೆ ತಿಮ್ ಇವ್ಣುನ ವಹೇರ‍್ಯ ಬಣ್ಣುತೆ ತಿಮ್ ಕರೀನ್, ಪೌಲ ಬಾರ್ನಬನ ಯೊ ತಬರ್‌ಖಾಥು ಭಾರ್‌ ನಖ್ಹಾಡಿದಿದು. ");
INSERT INTO vaa_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","ಇನಖ್ಹಾಜೆ ಪೌಲ,ಬಾರ್ನಬನೆ ಇವ್ಣುನ ಝೇತೈನ್‌ ಇವ್ಣ ಗೋಡಾನಿ ಧೂಳ್‌ನ ಝ಼ಟ್ಕಿನಾಖಿದೀನ್, ಇಕೋನ್ಯ ಖ್ಹಯೇರ‍್ನ ಗಯ. ");
INSERT INTO vaa_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","ಅಂತಿಯೋಕ್ಯಮ ಥೂತೆ ವಿಶ್ವಾಸಿಖ್ಹಾರು ಖ್ಹುಶಿಥಿ ಥು. ಬಿಜು಼ ಪವಿತ್ರಾತ್ಮಥಿ ಭರೈರೂಥು. ");
INSERT INTO vaa_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","ಪೌಲಬಿ ಬಾರ್ನಬ ಇಕೋನ್ಯ ಖ್ಹಯೇರ‍್ನ ಜೈ಼ನ್, ಹರೇಕ್ ಖ್ಹಯೇರ್‌ಮ ಇವ್ಣೆ ಕರ್ತಥಾತೆ ತಿಮ್ಮಸ್ ಹಜ್ಜಾ಼ಬಿ ಯೆಹೂದ್ಯರ‍್ನು ಸಬಾಮಂದಿರ್‌ಮ ಜೈ಼ನ್ ಅದ್ಮಿಖ್ಹಾರಾನ ಬೋಧನೆ ಕರ‍್ಯಾ. ಪೌಲ, ಬಾರ್ನಬನಿ ಶನ್‍ಗಾರ‍್ನಿ ಬೋಧನೆನ ಖ್ಹಮ್‌ಜಿನ್‌ ಕೈಯೇಕ್ ಯೆಹೂದ್ಯರ್ ಅಜು಼ ಗ್ರೀಕ್‍ವಾಳು ಯೇಸುಕ್ರಿಸ್ತನ ವಿಶ್ವಾಸ್‍ಕರ‍್ಯು. ");
INSERT INTO vaa_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","ಕತೋಬಿ ವಿಶ್ವಾಸ್ ಕರ‍್ಯುಕೊಂತೆ ಯೆಹೂದ್ಯರ್‌ನೆ ಅಲ್ಹಾವ್‌ ಅದ್ಮಿಖ್ಹಾರಾನ ವಿಶ್ವಾಸಿ ಭೈಯೇನ ವಿರೋದ್ ಉಠಾಡಿ ಭೀರಾಖ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","ಅಮ್‍ರ‍್ಹಾವಮ ಇವ್ಣೆ ಘಣಾದನ್ ರ‍್ಹೀನ್ ಪ್ರಭುನಿ ಬಾರೇಮ ಹಿಮ್ಮಥ್ಥಿ ವಾತೆಬೋಲ್ಯು. ಪ್ರಭು ಇವ್ಣಹಾತೆ ಖ್ಹಣೇದ್‍ನು ಕಾಮ್ ಬಿಜು಼ ಅದ್ಭುತ್‌ಕಾಮ್‍ಅಖ್ಖು ಕರೀನ್ ಇನಿ ವಾರ್‌ಖ್ಹಾನಿ ವಚನ್ನ ವತಾಳಿಲಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","ಇನಖ್ಹಾಜೆ ದೇವ್ನ ಉಪ್ಪರ್ ಭರೋಖ್ಹೊ ರಾಖಿನ್ ಹಿಮ್ಮಥ್ಥಿ ವಾತೆಬೋಲ್ತುಥು. ತದೆ ಯೊ ಖ್ಹಯೇರ‍್ನ ಅದ್ಮಿಮ ಥೋಡು ಯೆಹೂದ್ಯರ್‌ನಿ ವಾತೆನಾಬಿ ಬಿಜು಼ ಥೋಡುಜ಼ಣು ಅಪೊಸ್ತಲ ಭಣಿವಾಳಾನಿ ವಾತೆನಾಬಿ ವಿಶ್ವಾಸ್ ಕರ್ತುಥೂತೆ ಇನಖ್ಹಾಜೆ ಇವ್ಣಮಾಸ್ ಬೇ ಭಾಗ್‍ಹುಯು. ");
INSERT INTO vaa_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","ಅಲ್ಹಾವ್‌ ಅದ್ಮಿಬಿ ಯೆಹೂದ್ಯರ್‌ಮಾನು ಥೋಡುಜ಼ಣು ಇವ್ಣ ಅದಿಪತಿ ಖ್ಹಾರನಿ ಜೋ಼ಡ್ಮ ಮಳಿನ್, ಪೌಲಬಿ ಬಾರ್ನಬನ ಬಂಡೊ ಫೇಕಿನ್ ಮಾರ‍್ನುಕರಿ ಥು. ");
INSERT INTO vaa_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","ತದೆ ಪೌಲ,ಬಾರ್ನಬನೆ ಅನ ಮಾಲುಮ್ ಕರಿಲಿನ್ ಯೋ ಖ್ಹಯೇರ‍್ನ ಮ್ಹೇಲಿದಿನ್ ಲುಕವೋನ್ಯಮ ಥೂತೆ ಲುಸ್ತ್ರ ಅಜು಼ ದರ್ಬೆಕರಿ ಖ್ಹಯೇರ್‌ನಾಬಿ, ");
INSERT INTO vaa_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","ಅಜು಼ ಯೋ ಖ್ಹಯೇರ‍್ನ ಅಶ್‌ಪೀಶ್‍ನು ತಬರ್‌ಖಾನ ಜೈ಼ನ್ ಹಿಜ್ಜಾ಼ ಇವ್ಣೆ ಸುವಾರ್ತೆ ಖ್ಹಮ್‌ಜಾ಼ಡ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","ಲುಸ್ತ್ರಖ್ಹಯೇರ‍್ಮ ಗೋಡಾವ್‍ಮ ಶಕತ್‌ಕೊಂತೆ, ಪೈದಾಖ್ಹ್‌ಥು ಲಂಗ್ಡೊ ಹುಯಿರೋತೆ ಏಕ್‍ಜ಼ಣೊ ಬೆಠೋಥೊ. ");
INSERT INTO vaa_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","ಕದೇಬಿ ಚಾ಼ಲ್ತೋಥೊಕೊಂತೆ ಯೋ ಅದ್ಮಿ ಬೇಠು ಬೇಠು ಪೌಲನಿ ವಾತೆನ ಪೌಲನಿ ವಾತೆನ ಖ್ಹಮ್‌ಜು಼ ಕರ್ತುಥು. ಪೌಲನೆ ಇನ ಠರ್‌ಕೈನ್ ದೇಖಿನ್, ದೇವ್ ಗುಣ್‌ಕರ್ಶೆ ಕರಿ ಬೋಲಾನಿ ವಿಶ್ವಾಸ್ ಇನಾಮಥೂತೆ ಇನ ಮಾಲುಮ್ ಕರಿಲಿನ್, ");
INSERT INTO vaa_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","ಯೋ ಲಂಗ್ಡಾನ “ಉಟ್ ಗೋಡಟೇಕಿ ಭೀರೆ!” ಕರಿ ಜೋ಼ರೇಖ್ಹು ಬೋಲ್ಯೊ. ತದೇಸ್‌ ಯೋ ಅದ್ಮಿ ಕೂದಿ ಭೀರಿನ್ ಚಾ಼ಲಲಗ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","ಪೌಲನೆ ಕರ‍್ಯೊತೆ ಆ ಕಾಮ್ನ ದೇಖಿನ್ ಹಿಜ್ಜಾ಼ನ ಅದ್ಮಿಖ್ಹಾರಾನೆ, “ದೇವ್ ಖ್ಹಾರು ಅದ್ಮಿನು ರೂಪ್‍ಲೀನ್ ಅಪ್ಣಕನ ಉತ್ರಿನ್ ಆಯ” ಕರಿ ಇವ್ಣೆ ಲುಕವೋನ್ಯ ವಾತೆಮ ಚಿಕ್ರಾಣ್ ಮ್ಹೇಲ್ಯು! ");
INSERT INTO vaa_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","ಅದ್ಮಿಖ್ಹಾರಾನೆ, ಬಾರ್ನಬನ ‘ದ್ಯೌಸ್’ ದೇವ್‍ಕರಿಬಿ, ಮುಖ್ಯ ಬೋಧನೆ ಕರಾವಾಳೊ ಥೋತೆ ಪೌಲನ ‘ಹೆರ್ಮೆ’ ದೇವ್‍ಕರಿಬಿ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","ದ್ಯೌಸ್‌ಕರಿ ಥೂತೆ ದೇವ್ನಿ ಘುಡೀನಿ ಖ್ಹಾಮ್ಣೆನಿ ಝ಼ಗೋಮ ಪೂಜಾರಿನೆ ಥೋಡ ಢಾಂಡನಾಬಿ, ಫೂಲ್ನ ಹಲ್ಡಾನಾಬಿ ಗಾಮ್ನಬಾಕಲ್‌ಕನ ಲೀನ್ ಖ್ಹಾರಾಅದ್ಮಿನಿ ಜೋ಼ಡೆ ಆಯಿನ್ ಪೌಲ ಬಾರ್ನಬನ ಖ್ಹಾಮ್ಣೆ ಬಲಿ ಛ಼ಡಾವ್‍ಣುಕರಿ ಥು. ");
INSERT INTO vaa_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","ಅನ ಖ್ಹಮ್‍ಜ್ಯಾತೆ ಅಪೊಸ್ತಲ ಹುಯಿರಾತೆ ಪೌಲ, ಬಾರ್ನಬನೆ ಇವ್ಣ ಲುಂಗ್ಡಾನ ಫಾಡಿಲೀನ್, ಅದ್ಮಿನಿ ಝೂ಼ಂಡ್‌ಮ ಪೇಶಿನ್, ಅಮ್ ಚಿಕ್ರಿನ್ ಬೋಲ್ಯ; ");
INSERT INTO vaa_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","ಲೋಗ್ ತುಮೆ ಅಮ್ ಶನ ಕರುಕರಸ್ತೆ? ಹಮೇಬಿ ತುಮಾರಿನಿ ತರಾಸ್ ಅದ್ಮಿ. ತುಮುನ ಸುವಾರ್ತೆ ಬೋಲಾನ ಆಯಾತೆ, ತುಮೆ ಅಥ್ರಾನು ಫಾಯಿದೊಕೊಂತೆ ಕಾಮ್ನ ಮ್ಹೇಲಿನ್ ಆಬ್‌ ಧರ್ತಿನ, ದರ‍್ಯಾವ್‌ನಾಬಿ, ಇನಾಮ ಛಾ಼ತೆ ಖ್ಹಾರೂಸ್ ಉಬ್‌ಜಾ಼ಯೋತೆ ಜಿವ್ತೊಜಾನ್ ರ‍್ಹವಾಳೊ ದೇವ್ನಿ ಸುವಾರ್ತೆನ ಬೋಲಾನ ಹಮೆ ಆಯಾತೆ. ");
INSERT INTO vaa_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","ಖ್ಹತಮ್ ಹುಯಿಗೂತೆ ಹಗಾಮ್ಮ ದೇವ್ನೆ ಖ್ಹಾರ ಅದ್ಮಿವೋನ ಇವ್ಣಿ ಇವ್ಣಿ ಮರ್ಜಿಥಿ ಇವ್ಣುನ ಹೋಣುತೆ ಮಾರಗ್‌ಪರ್ ಚಾ಼ಲಾನ ಮ್ಹೆಲಿದಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","ಕತೋಬಿ ಇನಿ ಬಾರೇಮ ಸಾಕ್ಷಿದಿದೊಕೊಂತೆ ಕೊಯ್ನಿ; ಮದತ್ ಕರ್ತೊಆಯೋತೆ ಇನೇಸ್‌ ತುಮೂನ ಸೊರ್ಗಥೊ ಪಾಣಿನಾಬಿ ಖ್ಹುಗ್ಗೀನ ದನ್‍ಬಿ ಅನಾಜ಼್ ದೀನ್ ತುಮಾರ ದಿಲ್ನ ಖುಷಿಥಿ ಭರ‍್ಯೊ, ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","ಇವ್ಣೆ ಆ ವಾತೆ ಬೋಲ್ಯೊತೋಬಿ ಅದ್ಮಿಖ್ಹಾರು ಇವ್ಣುನಖ್ಹಾರು ಬಲಿ ಚ಼ಢಾವಾನು ವಿರೋದ್ ಹುಯು. ");
INSERT INTO vaa_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","ಇನಕೇಡೆಥು ಥೋಡು ಯೆಹೂದ್ಯರ್, ಅಂತಿಯೋಕ್ಯಥೂಬಿ ಅಜು಼ ಇಕೋನ್ಯಥು ಐನ್ ಪೌಲನ ವಿರೋದ್ ಅದ್ಮಿಖ್ಹಾರಾನ ಭೀರಾಖಿನ್, ಪೌಲನಪರ್ ಬಂಡೊಫೇಕಿನ್ ಯೋ ಮರಿಗಯೊಕರಿ ಲಾಝಿನ್ ಖ್ಹಯೇರ್‌ಥಿ ಭಾರ್‌ ಖೇಚಿಲಾಯಿ ನಾಖೀದಿದು. ");
INSERT INTO vaa_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","ಕತೋಬಿ ಶಿಷ್ಯರ್‌ ಇನ ಅಶ್‌ಪಿಶ್‍ ಭರೈನ್ ಆಯ. ತದೆ ಯೋ ಉಠೀನ್ ಖ್ಹಯೇರ್‌ಮ ಗಯೊ. ಇನವ್ಹಾಣೆ ಬಾರ್ನಬನಿ ಜೋ಼ಡೆ ದೆರ್ಬೆ ಖ್ಹಯೇರ‍್ನ ಗಯ. ");
INSERT INTO vaa_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","ಪೌಲಬಿ ಬಾರ್ನಬನೆ ಯೋ ಖ್ಹಯೇರ್‌ಮ ಸುವಾರ್ತೆ ಬೋಲಿನ್ ಕೈಯೇಕ್ ಜ಼ಣಾನ ಶಿಷ್ಯರ್‌ ಬಣೈನ್ ಹುಯಿಗು ತದೆ, ಪಾಛ಼ ಫರೀನ್ ಲುಸ್ತ್ರನಾಬಿ ಇಕೋನ್ಯನಾಬಿ ಅಂತಿಯೋಕ್ಯ ಖ್ಹಯೇರ‍್ನ ಗಯ. ");
INSERT INTO vaa_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","ಹಿಜ಼್ಜಾನ ಶಿಷ್ಯರ‍್ನ ಭಾಲಿದೀನ್ ವಿಶ್ವಾಸ್ಮ ಘಟ್ ಭೀರಾವನ ಹಿಮ್ಮತ್ ದಿದಾ. “ಅಪ್ಣಿ ದೇವ್ನಿ ರಾಜ್ಯನ ಘಣು ಮುಶ್ಕಿಲ್‍ನ ಮಹಿಕರಿ ಜಾ಼ವ್ಣುಪಡಸ್” ಕರಿ ಬೋಲಿಲಿದ. ");
INSERT INTO vaa_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","ಪೌಲ,ಬಾರ್ನಬನೆ ಹರೇಕ್ ಸಭೆನ ಇವ್ಣಿ ಹುಕುಮ್‌ಲೀನ್ ಯೋ ಸಬೆನಖ್ಹಾಜೆ ಕರಿ ಶಾಣಖ್ಹಾರಾನ ಚೂ಼ಣ್ಯ. ಇವ್ಣೆ ಉಪವಾಸ್ ರ‍್ಹೀನ್ ಪ್ರಾರ್ಥನೆ ಕರೀನ್ ಇವ್ಣೆ ವಿಶ್ವಾಸ್ ಕರಿರಾಖ್ಯಥಾತೆ ಶಾಣಾಖ್ಹಾರನ ಪ್ರಭುನ ಹಾತ್ಮ ದಿದಾ. ");
INSERT INTO vaa_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","ಪೌಲ,ಬಾರ್ನಬ ಪಿಸಿದ್ಯ ತಬರ್‌ಖಾಥು ಪಂಫುಲ್ಯ ತಬರ್‌ಖಾನ ಜೈ಼ನ್, ");
INSERT INTO vaa_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","ಇನ ಮಳಿರ‍್ಹೂತೆ ಪೆರ್ಗೆ ಖ್ಹಯೇರ್‌ಮ ಪ್ರಭುನಿ ವಚನ್ ಬೋಲಿನ್ ಹಿಜ್ಜಾ಼ಥು ಅತ್ತಾಲಿಯ ಖ್ಹಯೇರ‍್ನ ಗಯ. ");
INSERT INTO vaa_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","ಹಿಜ್ಜಾ಼ಥು ಇವ್ಣೆ ಸಿರಿಯ ಅಂತಿಯೋಕ್ಯನ ದರ‍್ಯಾವ್‍ನ ಮಾರಗ್‍ಥಿ ಗಯ. ಹಜ಼್ಜಾಲಗು ಇವ್ಣೆ ಕರೀನ್ ಖತಮ್‍ ಕರ‍್ಯಾತೆ ಸೇವೆನ ಕಾಮ್ನಖ್ಹಾಜೆ, ಇವ್ಣುನ ದೇವ್ನೆ ವಾರ್‌ಖ್ಹೊಕರೀನ್ ಮೋಕ್‍ಲ್ಯುಥೂತೆ ಕಾಮ್ ಆಸ್ ಖ್ಹಯೇರ್‌ಮ ಪೂರ ಹುಯೂತೆ. ");
INSERT INTO vaa_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","ಪೌಲ,ಬಾರ್ನಬ ಅಂತಿಯೋಕ್ಯನ ಆಯಿನ್ ಹಿಜ಼್ಜಾನಿ ಸಬೆವಾಳನ ಎಕ್ಟು ಕರಿನ್, ದೇವ್ನೆ ಇವ್ಣಿಜೋ಼ಡೆ ರ‍್ಹೀನ್ ಕರ‍್ಯೊತೆ ಅಖ್ಖಾಕಾಮ್ನಿ ಬಾರೇಮ ಇವ್ಣುನ ಖ್ಹಮ್‍ಜಾ಼ಡ್ಯ. ಬಿಜು಼ “ಯೆಹೂದ್ಯರ್‌ಕಾಹೆತೆ ಇವ್ಣೇಬಿ ವಿಶ್ವಾಸ್ ಕರಾನಿತರ ದೇವ್ ಬಾಕಲ್ ಉಖ್ಡಿರಾಖ್ಯೋಸ್!” ಕರಿ ಬೋಲಿವತಾಳ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","ಹಿಜ್ಜಾ಼ ಪೌಲ, ಬಾರ್ನಬ ವಿಶ್ವಾಸಿನ ಜೋ಼ಡೆ ಘಣಾದನ್ ರ‍್ಹಯ. ");
INSERT INTO vaa_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","ತದೆ ಥೋಡು ಅದ್ಮಿಖ್ಹಾರು ಯೂದಾಯಥು ಅಂತಿಯೋಕ್ಯ ಖ್ಹಯೇರ‍್ನ ಆಯು. ‘ಮೋಶೆನಿ ದಪ್ತರ್‌ಮ ಬೋಲೈರ‍್ಹಯುತೆ ಪರಕ್ಮ ತುಮೆ ಖ್ಹತ್ನ ನಾ ಕರಾಯತೊ ತುಮೂನ ರಕ್ಷಣೆ ಕೊಉಷೇನಿ’ ಕರಿ ಯೆಹೂದ್ಯರ್ ಕಾಹೆತೆ ಭೈಯೇನ ಬೋಲಿ ಒತಾಳು ಕರ್ತುಥು. ");
INSERT INTO vaa_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","ಪೌಲ, ಬಾರ್ನಬನೆ ಆ ಉಪದೇಶ್‍ನ ವಿರೋದ್ ಕರಿನ್ ಇವ್ಣಿಜೋ಼ಡೆ ಅಬ್ಬಾಜ಼ಬ್ಬಿ ಬೋಲ್ಯ. ಆ ವಿವಾದ್ನಿ ಬಾರೇಮ ಅಪೊಸ್ತಲರ‍್ನಿ ಜೋ಼ಡೆ ಬಿಜು಼ ಗಲ್‌ಢಾವ್‌ನಿಜೋ಼ಡೆ ವಾತ್‍ಚೀತ್‍ ಕರಾನ ಪೌಲ,ಬಾರ್ನಬ ಬಿಜು಼ ಅಲಕ್‍ ಥೋಡಜ಼ಣಾನ ಯೆರೂಸಲೇಮ್ನ ಮೋಕ್ಲಾನ ಸಬೆವಾಳು ನಿರ್ಧಾರ್ ಕರ‍್ಯು. ");
INSERT INTO vaa_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","ಸಬೆವಾಳು ಇವ್ಣುನ ಮೋಕ್ಲಿ ಹುಯಿಜಾ಼ವಾದಿನ್ ಇವ್ಣೆ ಫೊಯಿನಿಕೆ, ಸಮಾರ್ಯ ತಬರ್‌ಖಾನಿ ವಾಟೆ ಜಾ಼ವಾನಿ ವಖ್ಹತ್‌ಮ ಅಲಕ್‌ ಅದ್ಮಿಖ್ಹಾರು ದೇವ್‌ಭಣಿ ಫರ‍್ಯುತೆ ಬಾರೇಮ ಹಿಜ಼್ಜಾಥೂತೆ ಭೈಯೇ ಖ್ಹಾರಾನ ಏಕೇಕ್‌ ವಾತ್ನಬಿ ಛೋ಼ಡಿ ಬೋಲಿವತಾಳಿನ್ ಇವ್ಣಖ್ಹಾರಾನ ಘಣು ಖ್ಹುಶಿಕರಾಯು. ");
INSERT INTO vaa_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","ಪೌಲ,ಬಾರ್ನಬ ಯೆರೂಸಲೇಮ್‌ನ ಐನ್ ಸಬೆವಾಳನ ಅಪೊಸ್ತಲರ್ ಖ್ಹಾರಾನ ಸಬೇನು ಗಲ್‌ಢವ್‍ಖ್ಹಾರಾನ ಜೋ಼ಡ್ಮ ಮಳಿಜೈ಼ನ್ ದೇವ್ ಇವ್ಣಜೋ಼ಡೆ ರ‍್ಹಯಿನ್ ಕರ‍್ಯೊತೆ ಕಾಮ್‍ಖ್ಹಾರಾನ ಪೌಲ,ಬಾರ್ನಬನೆ ಇವ್ಣುನ ಬೋಲಿ ವತಾಳ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","ಹಿಜ್ಜಾ಼ ಥೂತೆ ವಿಶ್ವಾಸಿ ಖ್ಹಾರಾಮ ಥೋಡು ಫರಿಸಾಯರ್‌ನ ಝೂ಼ಂಡ್‌‍ವಾಳುಬಿ ಥೂ. ಇವ್ಣೆ ಉಠಿಭೀರಿನ್ ವಿಶ್ವಾಸಿಕೊಂತೆ ಖ್ಹಾರು ಖ್ಹತ್ನ ಕರೈಲೇವ್ಣು. ಮೋಶೆನ ಧರ್ಮಶಾಸ್ತ್ರಕನ ಖ್ಹಾಮ್ಣೆ ಮುಡ್‌ಕ್ಯು ಝು಼ಕಾವ್ಣುಕರಿ ಅಪ್ಣೆ ಇವ್ಣುನ ಬೋಲ್‌ನು” ಕರಿ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","ತದೆ ಅಪೊಸ್ತಲರ್ ಖ್ಹಾರು ಬಿಜು಼ ಗಲ್‌ಢಖ್ಹಾರು ಆ ವಾತೆನ ಬಾರೇಮ ಸೋಚಾನಖ್ಹಾಜೆ ಎಕ್ಟು ಹುಯು. ");
INSERT INTO vaa_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","ಘಣಿ ವಖ್ಹತ್‌ಲಗು ವಾತ್‍ಚೀತ್‍ ಹುವಾನ ಬಾದ್ಮ ಪೇತ್ರ ಉಠಿಭೀರಿನ್ ಇವ್ಣುನ, “ಮಾರ ಭೇನೆ ಭೈಯೇವೊ, ಯೆಹೂದ್ಯರ್‌ಕಾಹೆತೆ ಅದ್ಮಿಖ್ಹಾರಾನ ಸುವಾರ್ತೆ ಬೋಲಾನಖ್ಹಾಜೆ ತುಮಾರ ಬೀಚ್ಮಾಥು ದೇವ್ನೆ ಮನ ಘಣದನ್ನಪಾರಸ್ ಚೂ಼ಣಿರಾಖ್ಯೊಸ್, ಅಜು಼ ಇವ್ಣೆ ಮಾರೇಥಿ ಸುವಾರ್ತೆ ಖ್ಹಮ್‌ಜಿನ್‌ ದೇವ್ನ ವಿಶ್ವಾಸ್ ಕರ‍್ಯು ತುಮುನ ಮಾಲುಮ್‌ಛಾ಼. ");
INSERT INTO vaa_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","ಖ್ಹಾರ ಅದ್ಮಿನಿ ಸೋಚ್ನ ಖ್ಹಮಜ್ಯೊಹುಯೊ ದೇವ್ ಕಿಮ್ ಪವಿತ್ರಾತ್ಮನ ವರಾನ ಅಪ್ಣುನ ದೀರಾಖ್ಯೊಕಿ ತಿಮ್ ಇವ್ಣುನಾಬಿ ದೀನ್ ಸಾಕ್ಷಿದಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","ಅತ್ರೇಸ್ ಕಾಹೆತೆ, ದೇವ್ನೆ ಅಪ್ಣುನಾಬಿ ಇವ್ಣುನಾಬಿ ಶನೂಸ್ ಗುಮಾನಿ ಕರ‍್ಯೊಕೊಂತೆ ಇವ್ಣ ದಿಲ್ನ ವಿಶ್ವಾಸ್‌ಥೀಸ್ ಶುದ್ದಿಕರ‍್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","ಅಮ್‍ರ‍್ಹವಾಪರ್, ಅಲ್ಹಾವ್‌ ವಿಶ್ವಾಸಿ ಶನ ಭೈಯೇವ್ನ ಖಾಂದಪರ್ ವಜ಼ನ್ನೊ ಭೋಜೊ ಶನ ಢೊವಾಡೊಸ್? ತುಮೆ ದೇವ್ನ ಇರಾದೊ ಛ಼ಡಾವಾನಿ ಕೋಶಿಶ್ ಕರುಕರಾಸ್ಕಿ ಶು? ಹಮೂನ ರ‍್ಹವೊ ಹಮಾರ ಗುರುಖ್ಹಾರಾನರ‍್ಹೇವೊ ಆ ಭೋಜೊ ಢೊವಾಡಯೆತ್ರೆ ಶಕತ್ ಕೋಥಿನಿ. ");
INSERT INTO vaa_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","ಇನಖ್ಹಾಜೆ ಹಮೆರ‍್ಹೇವೊ ಅವ್ಣೆ ರ‍್ಹವೊ ರಕ್ಷಣೆ ಲೀಲ್ಯಾವಾನು, ಪ್ರಭುಹುಯಿರ‍್ಹೋತೆ ಯೇಸುನಿ ಗೋರ್‌ಥೀಸ್ ಕರಿ ಹಮೆ ವಿಶ್ವಾಸ್ ಕರಿಯೇಸ್” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","ತದೆ ಝೂ಼ಂಡ್ ಭರೈರ‍್ಹುಥೂತೆ ಖ್ಹಾರಾಸ್‌ನೆ ಆ ವಾತೆಖ್ಹಾರಿ ಖ್ಹಮ್‌ಜಿನ್‌ ಶೊಪೊ ಪಡೀಗು. ಬಾರ್ನಬ ಅಜು಼ ಪೌಲಥಿ, ದೇವ್ನೆ ಅಲ್ಹಾವ್‌ ಅದ್ಮಿಮ ಕರ‍್ಯೊತೆ ಖ್ಹಾರು ಖ್ಹಣೇದ್‍ನು ಕಾಮ್ನಾಬಿ, ಅದ್ಭುತ್‌ಕಾಮ್‌ನಾಬಿ ಬೋಲ್ಯುತೆ ಇನ ಕಾನ್‍ದೀನ್ ಖ್ಹಮ್‌ಜ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","ಇವ್ಣೆ ವಾತ್ ಬೋಲಾನು ಭೀರಾಖಾದಿನ್ ಯಾಕೋಬನೆ, “ಮಾರ ಭೇನೆ ಭೈಯೇವೊ ಮಾರಿ ವಾತೆ ಖ್ಹಮ್‍ಜೊ, ");
INSERT INTO vaa_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","ಯೆಹೂದ್ಯರ್‌ಕಾಹೆತೆ ಅದ್ಮಿನ ದೇವ್ನೆ ದೇಕ್‌ಭಾಲ್‌ ಕಿಮ್ ಕರ‍್ಯೊಕರಿ ಸಿಮೋನನೆ ಖ್ಹಮ್‍ಜಾ಼ಡಿರಾಖ್ಯೊಸ್. ಪಹಿಲಿಬಾರ್ ಯೆಹೂದ್ಯರ್‌ಕಾಹೆತೆ ಅದ್ಮಿನ ಏಕ್‌ ಜ಼ಣಾನ ದೇವ್ನೆ ಇನಿ ಕೃಪೆಥಿ ಸ್ವೀಕಾರ್ ಕರಿರಾಖ್ಯೊಸ್, ಇವ್ಣುನ ಇನು ಅದ್ಮಿಕರಿ ಕರಿಲಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","ಪವಿತ್ರ ದಪ್ತರ್‌ಮ ಅಮ್ ಲಿಖೈರ‍್ಹುಸ್ ಪ್ರವಾದಿಖ್ಹಾರಾನಿ ವಾತೇಬಿ ಇನ ಮಾನಿಲೇವ್‍ ಕರಸ್ ಕಿಮ್‌ಕತೊ, ");
INSERT INTO vaa_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","ಆ ಹುವಾದಿನ್ ಮೇ ಫರಿನ್ ದಾವೀದನ ರಾಜ್ಯನ ಪಾಛೊ಼ ಭಾಂದುಸ್. ಯೋ ರಡ್ಕಿಗಯೂತೆ ರಾಜ್ಯನ ಟುಕ್ಡಾವ್‍ನ ಮೇ ಪಾಛೊ಼ ಏಕ್ಟುಕರೀನ್ ಘಟ್‍ಥಿ ನವು ಬಣವುಸ್. ");
INSERT INTO vaa_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","ತದೆ ಜ಼ಗ್‌ಜಾತ್‌ಮ ಉಭ್‍ರ‍್ಯುತೆ ಅದ್ಮಿಮ ಥೋಡು ಜ಼ಣು ಕತೊ ದೇವ್‌ನು ಅದ್ಮಿಕರಿ ಬೋಲೈರ‍್ಹುತೆ ಖ್ಹಾರೂಸ್ ಜ಼ಗ್‌ಜಾ಼ತ್‌ಬಿ ಪ್ರಭುನ ಢೂಂಡವಾಳು ಹುಯಿರುಸ್, ಯೆಹೂದ್ಯರ್‌ಕಾಹೆತೆ ಅದ್ಮಿನ ಮಾರು ಶೊಂತ್ ಕರೀಶ್. ");
INSERT INTO vaa_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","ಶುರುಮಾಥು ಆ ಖ್ಹಾರು ಕಾಮ್ನ ಖ್ಹಮ್‌ಜಾ಼ಡ್ಯೊತೆ ಪ್ರಭು ಬೋಲುಕರಸ್, ಕರಿ ಲೀಖೈರ‍್ಹುಸ್. ");
INSERT INTO vaa_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","“ಅಮ್‍ರ‍್ಹವಾಪರ್ ದೇವ್‌ಭಣಿ ಫರಾವಾಳ ಯೆಹೂದ್ಯರ್‌ಕಾಹೆತೆ ಅದ್ಮಿವೋನ ಅಡ್ಡಿ ನಾಕರ‍್ನು ಆ ಮಾರಿ ಖ್ಹೂಜ಼್‌. ");
INSERT INTO vaa_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","ಇನ ಬದಲ್‍ಥಿ ಅಪ್ಣೆ ಇವ್ಣುನ ಏಕ್‌ ಚಿಟ್ಟಿ ಲೀಖ್ಯೆ; ಯೊ ಶಾತ್‍ಕತೊ ಮೂರತ್ನ ಝಾ಼ಳ್ ಉತಾರಹುಯನಾಬಿ, ವ್ಯಬಿಚಾರ್‌ಥಿಬಿ, ಬಿಜು಼ ಲ್ಹೋಯಿನಾಬಿ, ನ್ಹೇಟಿ ಭೀಚಿನ್ ಮಾರ‍್ಯಹುಯ ಜಿನಾವರ್‌ನಬಿ ನಾಖಾವ್ಣು ಕರಿ ಅಕ್ಕಲ್ ದೇವ್ಣು. ");
INSERT INTO vaa_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","ಶನಕತೊ ಪೂರತ್‍ ಕಾಲಥು ಅಖ್ಖಾ ಖ್ಹಯೇರ್‌ಮ ಮೋಶೆನ ದಪ್ತರ್‌ನ ಬೋಧನೆ ಕರಾವಾಳು ಖ್ಹಾರು ಛಾ಼. ಕೈಏಕ್ ವರಖ್ಹ್ ಥು ಹರ್ ಸಬ್ಬತ್ ದನ್ಮ ಸಬಾಮಂದಿರ್‌ಮ ಮೋಶೆನಿ ವಾತೆಖ್ಹಾರಿ ಫಡವ್‍ಕರಸ್.” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","ತದೆ ಅಪೊಸ್ತಲರ್‌ಬಿ ಸಬೆನ ಗಲ್‌ಢಖ್ಹಾರಾಬಿ ಬಿಜು಼ ಸಬೇನು ಖ್ಹಾರೂಸ್, ಪೌಲ ಬಾರ್ನಬನಿ ಜೋ಼ಡೆ ಇವ್ಣಮಾಥುಸ್ ಥೋಡುಅದ್ಮಿನ ಚೂ಼ಣಿನ್ ಅಂತಿಯೋಕ್ಯ ಖ್ಹಯೇರ‍್ನ ಮೋಕಲ್ನುಕರಿ ತೀರ್ಮಾನ್ ಕರ‍್ಯು. ಇನಖ್ಹಾಜೆ ಬಾರ್ಸಬ ಕರಿ ಬೋಲೈರ‍್ಹೋತೆ ಯೂದನಾಬಿ, ಸೀಲನಾಬಿ ಚೂ಼ಣಿನ್,ಯೋ ಖ್ಹಾರಾನ ಮುಖ್ಯಖ್ಹಾರು ಕರ‍್ಯು. ");
INSERT INTO vaa_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","ಇವ್ಣ ಹಾತ್ಮ ಲೀಖಿನ್ ದೀರಾಖ್ಯುಥೂತೆ ಶಾತ್‍ಕತೊ, ಭಯೇಖ್ಹಾರ ಹುಯಿರಾತೆ ಅಪೊಸ್ತಲರ‍್ನೇಬಿ ಗಲ್‌ಢಖ್ಹಾರಾನೇಬಿ ಅಂತಿಯೋಕ್ಯ, ಸಿರಿಯ, ಕಿಲಿಕ್ಯ ತಬರ್‌ಖಾಸ್‍ಮ ಛಾ಼ತೆ ಯೆಹೂದ್ಯರ್‌ಕಾಹೆತೆ ಭೈಯೇ ಭೇನೇನ ಹಮಾರಿ ಖ್ಹಲಾಮ್; ");
INSERT INTO vaa_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","ಹಮಾರಕಂಥು ಆಯುತೆ ಥೋಡಜ಼ಣಾನೆ ಹಮಾರೇಥಿ ಖಿವಿ ಹುಕುಮ್‌ನ ಮಾನ್ಯುಕೊಂತೆ ಇವ್ಣಿ ವಾತೆಥಿ ತುಮರಾಮ ಸಮಾಧಾನ್‌ಕೊಂತೆ ಕರಿನಾಖಿನ್‌, ತುಮಾರ ದಿಲ್ನ ಕಲಾವ್ಣಿ ಕರ‍್ಯುಕರಿ ಹಮೂನ ಮಾಲುಮ್‌ ಪಡ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","ಇನಖ್ಹಾಜೆ ಹಮೆಖ್ಹಾರಾಸ್ ಎಕ್ಟಹುಯಿನ್ ಥೋಡಜ಼ಣಾನ ಚೂ಼ಣಿನ್ ಪ್ಯಾರ್‌ನ ಭೈಯೆ ಪೌಲ, ಬಾರ್ನಬನ ಜೋ಼ಡ್ಮ ತುಮಾರಕನ ಮೋಕ್ಲು ಕರಿಯೇಸ್. ");
INSERT INTO vaa_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","ಪೌಲ, ಬಾರ್ನಬನೆ ಅಪ್ಣೊ ಪ್ರಭು ಹುಯಿರೋತೆ ಯೇಸುಕ್ರಿಸ್ತನ ನಾಮ್‌ಥಿ ಸೇವೆನಖ್ಹಾಜೆ ಇವ್ಣ ಜಿವ್ಣನಾಸ್ ದಿನಾಖ್ಯ. ");
INSERT INTO vaa_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","ಇನಖ್ಹಾಜೆ ಹಮೆ ಯೂದನ ಬಿಜು಼ ಸೀಲನ ಇವ್ಣಿ ಜೋ಼ಡೆ ಮೋಕ್ಲಿರಾಖ್ಯೊಸ್. ಆ ಅಖ್ಖು ತುಮೂನ ಮ್ಹೋಡಾನಿ ವಾತೆಥಿ ಖ್ಹಮ್‍ಜಾ಼ಡ್‍ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","ಆ ಹೋಣುತೆ ಖಾನುಲ್‌ನ ಮ್ಹೇಲಿನ್ ತುಮಾರಪರ್ ಬಿಜು಼ ಖಿವೂಬಿ ಭೋಜ಼್‌ನ ನಾಕ್ಣುನಾತೆ ತಿಮ್ ಪವಿತ್ರಾತ್ಮ ಅಜು಼ ಹಮೆ ಮಾನಿರಾಖ್ಯಸ್. ");
INSERT INTO vaa_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","ಯೋ ಅಖ್ಖು ಖಿವುಕತೊ; ಮೂರತ್ನ ಝಾ಼ಳ್ ಉತಾರಹುಯನಾಬಿ, ಲ್ಹೋಯಿನಾಬಿ, ನ್ಹೇಟಿ ಭೀಚಿನ್ ಮಾರ‍್ಯಹುಯ ಜಿನಾವರ್‌ನಬಿ ನಾಖಾವ್ಣು. ಅಜು಼ ವ್ಯಬಿಚಾರ‍್ನು ಪಾಪ್ನಕಾಮ್‌ಥಿ ತುಮುನ ಬಚಾ಼ಡಿಲೆವೊ. ಆ ಅಖ್ಖು ನಾಕರ‍್ನುತೆ ತಿಮ್‌ ಹೊಷಾರ್‌ಥಿ ರ‍್ಹಯಾತೊ ತುಮೆ ಅಛ್ಛು಼ ಕರ್ಶು. ತುಮುನ ಅಛ್ಛು಼ ಹುವಾದೆ. ");
INSERT INTO vaa_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","ಅಮ್ ಪೌಲ, ಬಾರ್ನಬ ಬಿಜು಼ ಯೂದ, ಸೀಲ, ಯೆರೂಸಲೇಮ್‍ಥು ಅಂತಿಯೋಕ್ಯ ಖ್ಹಯೇರ‍್ನ ಜೈ಼ನ್ ಹಿಜ಼್ಜ ವಿಶ್ವಾಸಿಯೆವ್ನಿ ಸಭೆನ ಭರೈನ್, ಯೋ ಚಿಟ್ಟಿ ಇವ್ಣುನ ದಿದು. ");
INSERT INTO vaa_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","ತದೆ ಇನ ಜೋ಼ರೇಖ್ಹು ಪಢೀನ್‌ ಅಜು಼ ಯೊ ಭಾಲಿನಿ ವಾತೆ ಖ್ಹಮ್‌ಜಿನ್‌ ಇವ್ಣೆ ಘಣು ಖುಷಿಕರ‍್ಯು. ");
INSERT INTO vaa_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","ಯೂದ ಬಿಜು಼ ಸೀಲಬಿ ಪ್ರವಾದಿ ಹುಯಿರ‍್ಹಥಾತೆಖ್ಹಾಜೆ ಇವ್ಣಿ ಕೈಯೆಕ್ಕಿ ಥರಾನಿ ವಾತೆ ಖ್ಹಮ್‌ಜಿನ್‌ ಭೇನೆ ಭೈಯೇವ್‌ಖ್ಹಾರಾನ ಹಿಮ್ಮತ್‌ ಆಯು. ");
INSERT INTO vaa_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","ಯೂದ ಸೀಲ ಥೋಡದನ್ ಹಿಜ಼್ಜರ‍್ಹೀನ್ ಭಯೇಥಿ ಸಮಾಧಾನ್ನಿ ಆಶೀರ್ವಾದ್‌ ಲೀಲಿದ. ಅನಪಾರ್ ಇವ್ಣೆ ಪಾಛ಼ ಯೆರೂಸಲೇಮ್‌ನ ಇವ್ಣುನ ಮೋಕ್‍ಲ್ಯಥಾತೆ ವಿಶ್ವಾಸಿಕನ ಗಯ. ");
INSERT INTO vaa_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","ಕತೋಬಿ ಸೀಲನ ಹಿಜ್ಜಾ಼ಸ್ ರ‍್ಹಯೂತೊ ಅಛ್ಛು಼ಕರಿ ಮಾಲುಮ್‌ಕರ‍್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","ಕತೋಬಿ ಪೌಲ, ಬಾರ್ನಬ ಅಂತಿಯೋಕ್ಯಮಾಸ್ ರ‍್ಹೀನ್,ಅಜು಼ ಕೈಯೇಕ್ ಜ಼ಣಾನಿ ಜೋ಼ಡೆ ಮಳಿನ್ ಸುವಾರ್ತೆ ಬೋಲ್ತಹುಯಿನ್ ಬಿಜು಼ ಪ್ರಭುನಿ ವಚನ್ನ ಅದ್ಮಿಖ್ಹಾರಾನ ಶಿಕಾಡ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","ಥೋಡದನ್ ಹುವಾದಿನ್ ಪೌಲನೆ, “ಬಾರ್ನಬನ ಅಪ್ಣೆ ಕೈಯೇಕ್ ಖ್ಹಯೇರ್‌ಮ ಪ್ರಭುನಿ ವಚನ್ನ ಖ್ಹಮ್‍ಜಾ಼ಡ್ಯ. ಯೋ ಅಖ್ಖಾ ಖ್ಹಯೇರ್‌ಮ ಛಾ಼ತೆ ಅಪ್ಣ ಭೈ ಭೇನೆನ ಮಳಿನ್ ಇವ್ಣೆ ಕಿಮ್ ಛಾ಼ಕಿ ದೇಖಿನ್ ಐಯ್ಯೆ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","ಬಾರ್ನಬನೆ ಮಾರ್ಕಕರಿ ಬೋಲೈರ‍್ಹೋತೆ ಯೋಹಾನ ಇವ್ಣಿ ಜೋ಼ಡ್ಮ ಬುಲೈಲಿ ಜಾ಼ವ್ಣುಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","ತದೆ ಪೌಲನೆ, ಅಪ್ಣಿ ಜೋ಼ಡ್ಮ ಸೇವೇನ ಕಾಮ್ನ ಕೋ ಆಯೋನಿತೆ, ಪಂಫುಲ್ಯ ಗಾಮ್ಮ ಅಪ್ಣುನ ಮ್ಹೇಲಿನ್ ಜಾ಼ವಾಳನ ಬುಲೈಲಿನ್ ಜಾ಼ವಾನು ಬರೋಬರ್ ಕೊಯ್ನಿಕರಿ ದಿಲ್ಮ ಕರ‍್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","ಇನಿ ಬಾರೇಮ ಪೌಲ, ಬಿಜು಼ ಬಾರ್ನಬಮ ಘಣು ಅಬ್ಬಾಜ಼ಬ್ಬಿ ವಾತೆಹುಯಿನ್ ಇವ್ಣೆ ಬೇಜ಼ಣ ಅಲಕ್‌ಹುಯಿಗ. ಬಾರ್ನಬ ಮಾರ್ಕನ ಬುಲೈಲಿನ್ ದರ‍್ಯಾವ್‍ನ ಮಾರ್ಗೆ ಸೈಪ್ರಸ್ ಟಾಪನ ಗಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","ಪೌಲನೆ ಇನಜೋ಼ಡೆ ಸೀಲನ ಬುಲೈಲಿನ್ ಗಯೊ. ಅಂತಿಯೋಕ್ಯನ ಭಯೇಖ್ಹಾರಾನೆ ಪೌಲನ, ಪ್ರಭುನ ವಾರ್‌ಖ್ಹೇಥಿ ಹಿಜ್ಜಾ಼ಥು, ");
INSERT INTO vaa_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","ಇವ್ಣೆ ಸಿರಿಯ ಬಿಜು಼ ಕಿಲಿಕ್ಯ ತಬರ್‌ಖಾವ್‍ಮ ಕರಿ ಪಡ್ತಹುಯಿನ್ ಹಿಜ಼್ಜಾನಿ ಅಖ್ಖಿ ಸಬೆನ ಘಟ್ ಕರ‍್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","ಪೌಲನೆ ದೆರ್ಬೆ ಅಜು಼ ಲುಸ್ತ್ರಕರಿ ಖ್ಹಯೇರ್‌ಮ ಗಯೊ.ಹಿಜ್ಜಾ಼ ತಿಮೊಥೆಕರಿ ಏಕ್‍ಜ಼ಣೊ ಕ್ರಿಸ್ತನೊ ವಿಶ್ವಾಸಿ ಥೊ. ತಿಮೊಥೆನಿ ಆಯ ಯೆಹೂದ್ಯವಾಳಿ ಹುಯಿರ‍್ಹೀಥಿ ಅಜು಼ ಬಾ ಗ್ರೀಕ್‍ವಾಳೊ ಹುಯಿರ‍್ಹೋಥೊ. ");
INSERT INTO vaa_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","ಲುಸ್ತ್ರ ಅಜು಼ ಇಕೋನ್ಯ ಖ್ಹಯೇರ‍್ನು ವಿಶ್ವಾಸಿಖ್ಹಾರು ತಿಮೊಥೆನ ಮರ್ಯಾದಿ ದೇತುಥು. ಅಜು಼ ಇನಿ ಬಾರೇಮ ಅಛ್ಛೂ಼ಸ್ ಬೋಲ್ತುಥು. ");
INSERT INTO vaa_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","ಪೌಲ ತಿಮೊಥೆನ ಇನಕೇಡೆ ಬುಲೈಲಿನ್ ಜಾ಼ವ್ಣುಕರಿ ಇಷ್ಟಕರ‍್ಯೊ. ಯೊ ಝ಼ಗೋಮ ಥೋತೆ ಯೆಹೂದ್ಯರ್‌ನ ತಿಮೊಥೆನೊ ಬಾ ಗ್ರೀಕ್‍ನೊಕರಿ ಮಾಲುಮ್‌ಥೂತೆ ಇನಖ್ಹಾಜೆ ಇನ ಖ್ಹತ್ನ ಕರಾಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","ಇನಕೇಡೆಥು ಪೌಲ ಅಜು಼ ಇನ ಜೋ಼ಡೆ ರ‍್ಹವಾಳುಖ್ಹಾರು ನಂಗರ್‌ಥಿ ನಂಗರ್ ಫರ‍್ಯು. ಯೆರೂಸಲೇಮ್ಮಥೂತೆ ಅಪೊಸ್ತಲರ‍್ನಿ ಅಜು಼ ಗಲ್‌ಢವ್‍ನಿ ಖ್ಹೂಜ಼್‌ನ ಇವ್ಣೆ ವಿಶ್ವಾಸಿಖ್ಹಾರನ ಬೋಲಿನ್ ಇನ ಪಾಡೀನ್ ಚಾ಼ಲ್‌ನುಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","ಅಮ್ಮಸ್ ಕ್ರಿಸ್ತನು ಸಬೆಖ್ಹಾರು ದನ್‍ಥಿ ದನ್ ವಿಶ್ವಾಸ್ಮ ಭಡಾಲಗ್ಯು. ಸಬೆಖ್ಹಾರು ವಿಶ್ವಾಸ್ಮ ಘಟ್‍ಥಿ ಭೀರಿನ್ ವಿಶ್ವಾಸಿ ದನ್‍ಪರ್ ದನ್ ಜಾ಼ಖ್ಹತ್ ಹುವಾಲಗ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","ಏಷ್ಯಾ ಮುಲಕ್‌ಮ ಪೌಲ ಇವ್ಣೆಖ್ಹಾರು ಸುವಾರ್ತೆನ ಬೋಲಿನ್ ನಾ ವತಾಳ್ಣುಕರಿ ಪವಿತ್ರಾತ್ಮನೆ ಖ್ಹಮ್‍ಜಾ಼ಡಿರಾಖ್ಯೊಥೊ. ಇನಖ್ಹಾಜೆ ಇವ್ಣೆ ಫ್ರಿಜಿಯ, ಅಜು಼ ಗಲಾತ್ಯ ತಬರ್‌ಖಾನಿ ವಾಟೆ ಗಯ. ");
INSERT INTO vaa_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","ಪೌಲ ಅಜು಼ ತಿಮೊಥೆ ಇವ್ಣೆ ಮುಸಿಯ ನಂಗರ‍್ನ ಖನ್ನೆ ಗಯ. ತದೆ ಇವ್ಣೆ ಬಿಥೂನ್ಯ ನಂಗರ್‌ಮ ಜಾ಼ವ್ಣು ಕರಿ ಥಾ. ಕತೋಬಿ ಯೇಸುನ ಆತ್ಮನೆ ಹಿಜ್ಜಾ಼ಬಿ ಜಾ಼ವಾನ ಕೊ ಮ್ಹೆಲ್ಯುನಿ. ");
INSERT INTO vaa_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","ಇನಖ್ಹಾಜೆ ಇವ್ಣೆ ಮುಸಿಯ ನಂಗರ್‌ಪರ್ ಕರಿ ನೇರ್ ತ್ರೋವ ಖ್ಹಯೇರ್‌ಮ ಆಯ. ");
INSERT INTO vaa_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","ಯೋ ರಾತ್ಮ ಪೌಲನ ಏಕ್‌ ದರ್ಶನ್‌ಹುಯು. ಮೆಕೆದೋನ್ಯನೊ ಏಕ್‍ಜ಼ಣೊ ಹಿಜ್ಜಾ಼ಭೀರಿನ್; ಮೆಕೆದೋನ್ಯಮ ಐನ್ ಹಮೂನ ಮದತ್ ಕರ್‌” ಕರಿ ಗಿಂಗೈಲಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","ಪೌಲನೆ ಯೋ ದರ್ಶನ್ ದೇಖಿನ್, ತದ್‌ನು ತದೇಸ್‌ ಹಿಜ಼್ಜಾನ ಅದ್ಮಿನ ಸುವಾರ್ತೆನ ಖ್ಹಮ್‍ಜಾ಼ಡಾನಖ್ಹಾಜೆ ದೇವ್ನೆ ಹಮೂನ ಬುಲೈರಾಖ್ಯೊಸ್ ಕರಿ ಮಾಲುಮ್ ಕರಿಲಿನ್ ಮೆಕೆದ್ಯೋನ್ಯನ ಜಾ಼ವಾನ ಇವ್ಣೆ ತಯಾರ್ ಹುಯ. ");
INSERT INTO vaa_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","ಹಮೆ ತ್ರೋವಥು ಜ಼ಹಾಜ಼್ ಚ಼ಢೀನ್ ಸಮೊಥ್ರಾ ಐನ್, ಬಿಜೇಕ್ ದನ್ನೆ ನೆಯಾಪೊಲಿ ಖ್ಹಯೇರ‍್ನ ಪೋಚಿನ್ ಹಿಜ್ಜಾ಼ಥ ಫಿಲಿಪ್ಪಿನ ಆಯ. ");
INSERT INTO vaa_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","ಫಿಲಪ್ಪಿಕರಿ ಬೋಲಾನು ಮೆಕೆದೋನ್ಯನು ಖ್ಹಯೇರ್ ಹುಯಿರ‍್ಹುಥು. ರೋಮ್‍ವಾಳಾನು ರ‍್ಹವಾನು ಝ಼ಗೋ ಹುಯಿರ‍್ಹೀಥಿ. ಹಜ್ಜಾ಼ ಥೋಡ ದನ್ ರ‍್ಹಯ. ");
INSERT INTO vaa_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","ಖ್ಹಯೇರ‍್ನ ಭಾರ್‌ ಥೂತೆ ನದ್ದಿನ ಕನಾರಿನ ಖನ್ನೆ ಯೆಹೂದ್ಯರ‍್ನು ಪ್ರಾರ್ಥನೆನಿ ಝ಼ಗೊರ‍್ಹೆವ್ಣುಕರಿ ಸಬ್ಬತ್‌ ದನ್ಮ ಹಿಜ್ಜಾ಼ಗಯಾಥ. ಹಿಜ್ಜಾ಼ ಥೋಡಿ ತಯೇಡ ಅಯಿರ‍್ಹೀಥಿ. ತದೆ ಹಮೆ ಬೇಶಿನ್ ಇವ್ಣೇಥಿ ವಾತೆ ಬೋಲ್ಯ. ");
INSERT INTO vaa_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","ಹಮಾರಿ ಬೋಧನೆ ಖ್ಹಮ್‍ಜ್ಯುತೆ ತಯೇಡಾವ್ಮ ಲಿಡಿಯಾಬಿ ಏಕ್‍ಜ಼ಣಿ. ಆ ಹೈರಿತೆ ಥುವತೈರ ಖ್ಹಯೇರ್‌ವಾಳಿ; ಹೈರಿತೆ ರಾಯಿಜಾ಼ಮಣ್ಣ ರಂಗ್ನು ಲುಂಗ್ಡು ವೇಚಿನ್ ಧಂದೊ ಕರಾವಾಳಿ ಹುಯಿರ‍್ಹೀಥಿ. ಆ ಖ್ಹಾಚ ದೇವ್ನ ಆರಾದನೆ ಕರ್ತೀಥಿ. ಪೌಲನ ಬೋಧನೆನ ಕಾನ್‍ಜೋ಼ಡಿ ಖ್ಹಮ್‍ಜಾ಼ನಿತರ ಪ್ರಭುನೆ ಇನ ದಿಲ್ನ ಛೋ಼ಡಾಯೊ. ಪೌಲನೆ ಬೋಲ್ಯೊತೆ ಖ್ಹಾರು ಇನೆ ವಿಶ್ವಾಸ್‌ಕರಿ. ");
INSERT INTO vaa_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","ಲಿಡಿಯ ಅಜು಼ ಇನ ಘರ್‌ಮಥೂತೆ ಖ್ಹಾರುಜ಼ಣು ಬ್ಯಾಪ್ತಿಸ್ಮ ಕರೈಲಿದು. ಇನೆ, “ಪ್ರಭುನಿ ಖ್ಹಾಚ ವಿಶ್ವಾಸಿಕರಿ ತೀರ್ಮಾನ್‌ ಕರ್ತ ಉಷೇತೊ, ಹಮಾರ ಘರ್‌ಮ ಐನ್ ರ‍್ಹವೊ” ಕರಿ ಗಿಂಗೈನ್ ಹಮೂನ ಜು಼ಲಮ್‍ಕರಿ. ");
INSERT INTO vaa_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","ಏಕಹಲ್ಲ, ಹಮೆ ಪ್ರಾರ್ಥನೆ ಝ಼ಗೋನ ಜಾ಼ವಾನಿ ವೇಳ್ಮ ಗಾರೋಡಿನಿ ಏಕ್‍ಜ಼ಣಿ ದಾಸಿ ಹಮಾರ ಖ್ಹಾಮ್ಣೆ ಆಯಿ. ಯೋ ಫಾಲ್‌ಬೋಲ್‍ಥೀತೆ ಇನೇಥಿ ಇನೊ ಯಜಮಾನ್ನ ಘಣು ನಫ್ಫೊ ಹೋತುಥು. ");
INSERT INTO vaa_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","ಪೌಲಬಿನ್ ಹಮೆ ಜಾ಼ವನಿವಖ್ಹ್‌ತೆ, ಯೊ ಚಿಕ್ರಿ ಬೋಲ್ತಿಹುಯಿನ್, “ಆ ಅದ್ಮಿಖ್ಹಾರು ಘಣೊಊಚೊ಼ ದೇವ್ನು ಸೇವಕ್ ಹುಯಿರ‍್ಹಾಸ್; ತುಮಾರ ಜಾನ್ನ ರಕ್ಷಣೆನು ಮಾರಗ್‌ನ ಅವ್ಣೆ ಬೋಲುಕರಸ್” ಕರಿ ಬೋಲ್ತಿ ರ‍್ಹೇತಿಥಿ. ");
INSERT INTO vaa_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","ಕೈಏಕ್ ದನ್‍ಲಗೂಬಿ ಅಮ್ಮಸ್ ಬೋಲುಕರ್ತಿಥಿ. ಇನಖ್ಹಾಜೆ ಪೌಲ ಬೇಜಾರ್ ಹುಯಿನ್, ಯೊ ತಯೇಡಾಮ ಛಾ಼ತೆ ಖರಾಬ್ಆತ್ಮ, ‘ಮ್ಹೆಂದಿನ್ ನಿಕ್ಳಿಜಾ಼’ ಕರಿ ಯೇಸುಕ್ರಿಸ್ತನ ನಾಮ್‍ಥಿ ಹುಕುಮ್ ದೆವುಸ್ ಕರಿ ಬೋಲ್ಯೊ. ಯೋ ವಖ್ಹತ್‌ಮಾಸ್‌ ಯೋ ಖರಾಬ್ಆತ್ಮ ಇನ ಮ್ಹೇಲಿನ್ ಚ಼ಲಿಗಯು. ");
INSERT INTO vaa_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","ಯೋ ದೆಖ್ಯೊತೆ ದಾಸಿನೊ ಯಜಮಾನ್ನೆ ರಪ್ಯ ಕಮಾವನು ಉಷೆ ಕೊಯ್ನಿಕರಿ ಮಾಲುಮ್ ಕರಿಲಿನ್, ಪೌಲನಾಬಿ ಸೀಲನ ನಂಗರ‍್ನ ನ್ಯಾವ್ನ ಅದಿಕಾರಿಕನ ಖೇಚಿಲಿಗು. ");
INSERT INTO vaa_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","ಹಿಜ್ಜಾ಼ ಪೌಲನಾಬಿ ಸೀಲನ ಅಧಿಕಾರಿನ ಖ್ಹಾಮ್ಣೆ ಇವ್ಣುನ ಬುಲೈಲಿಜೈ಼ನ್ “ಆ ಅದ್ಮಿಖ್ಹಾರು ಯೆಹೂದ್ಯರ್ ಹುಯಿರುಸ್, ಅವ್ಣೆ ಖ್ಹಯೇರ‍್ನ ಕಲಾವ್ಣಿಕರಿನ್ ಗಲಾಟ್ ಉಠಾಡುಕರಸ್.” ");
INSERT INTO vaa_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","ರೋಮ್‌ವಾಳ ಹುಯಿರಾತೆ ಅಪ್ಣ ನಿಯಮ್‌ನಿ ವಿರೋದ್‌ನು ಕಾಮ್ ಅವ್ಣೆ ಅದ್ಮಿಖ್ಹಾರಾನ ಬೋಲುಕರಸ್ ಕರಿ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","ತದೆ ಅದ್ಮಿಖ್ಹಾರು ಪೌಲಬಿನ್ ಸೀಲನ ವಿರೋದ್ ಹುಯಿರ‍್ಹುಥು ತದೆ ಅದಿಕಾರಿನೆ ಪೌಲ ಸೀಲನ ಲುಂಗ್ಡಾವ್‍ನ ಫಾಡಿನ್ ಇವ್ಣ ಭೇಜ಼ಣಾನ ಲಠ್ಠೇಥಿ ಜಾ಼ಖ್ಹತ್ ಮಾರ್ ದೇವಾಡ್ಣುಕರಿ ಹುಕುಮ್‌ಕರ‍್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","ಇವ್ಣುನ ಘಣೇಥಿ ಮಾರ್‌ಖಡೈನ್‌ ಹುಯಿಗು ತದೆ ಜೇಲ್‌ಮ ಘಲೈನ್ “ಇವ್ಣುನ ಘಣು ಹೊಷಾರ್‌ಥಿ ಜೇಲ್‌ನ ಕಾವ್ಲಿಕರ‍್ನು ಕರಿ ಅಧಿಕಾರಿನ ಹುಕುಮ್‌ ದಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","ಇನೆ ಯೊ ಹುಕುಮ್‌ನ ಪಾಡಿನ್ ಇವ್ಣುನ ಜೇಲ್‌ನ ಮಹಿನ ಕೋಣಾಮ ಘಾಲಿನ್ ಇವ್ಣ ಗೋಡಾವ್‍ನ ಲಾಕ್ಡಾನ ಫಣಾಶಿನ ಇಚ಼್‌ಮ ಘಾಲಿನ್ ಖ್ಹಂಕಳ್‌ಥಿ ಜ಼ಡ್‍ಕಾಯು. ");
INSERT INTO vaa_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","ಅಧಿರಾತ್ಮ ಪೌಲಬಿ ಸೀಲನೆ ಪ್ರಾರ್ಥನೆ ಕರ್ತಹುಯಿನ್ ದೇವ್ನ ಸ್ತುತಿನು ಗೀದ್‌ ಬೋಲುಕರ್ತಾಥ. ಹಿಜ಼್ಜಾಥೂತೆ ಖೈದಿಖ್ಹಾರು ಖ್ಹಮ್‍ಜು಼ಕರ್ತುಥು. ");
INSERT INTO vaa_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","ತದೆ ಅಫ್ಪರ್‌ಥೂಸ್ ಮೋಟು ಭೂಕಂಪ್ ಹುಯು; ಖ್ಹಾರ್ಕೊಟ್‌ನು ಹದಿಪಾಯ ಹಲಿರ‍್ಹೀಗು. ಯೋಸ್ ವೇಳ್ಮ ಬಾಕಲ್‍ಅಖ್ಖು ನಿಕ್ಳಿಗಯು, ಅಖ್ಖಾಸ್ ಖೈದಿನು ಖ್ಹಂಕಳ್‌ಖ್ಹಾರು ಛು಼ಟಿ ಪಡಿಗಯು. ");
INSERT INTO vaa_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","ಜೇಲ್‌ನೊ ಅದಿಕಾರಿ ನಿಂದರ್‌ಥಿ ಹೊಷಾರಿಹುಯಿನ್, ಬಾಕಲ್ ಅಖ್ಖು ನಿಕ್ಳಿರ‍್ಹುಥೂತೆ ದೇಖಿನ್ ಖೈದಿಖ್ಹಾರು ಮಿಲೈಚ಼ಲಿಗೂ ಕರಿ ಲ್ಹಯಿನ್ ತಲ್ವಾರ್‌ಥಿ ಭೋಕೈನ್ ಮರಿಜಾ಼ವ್ಣು ಕರಿ ಥೊ. ");
INSERT INTO vaa_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","ಕತೋಬಿ ಪೌಲನೆ ಊಚಿ ಆವಾಜ಼್‌ಥಿ ಚಿಕ್ರಿನ್ ಇನ; ತೂ ಶಾತ್ಬಿ ಲುಕ್ಷಾನ್‌ ನಕೊ ಕರಿಲಿಶ್‌. ಹಮೆ ಅಖ್ಖಾಸ್‍ಜ಼ಣ ಹಜ್ಜಾ಼ಸ್ ಛಿಯೆ ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","ಖ್ಹಾರ್ಕೊಟ್‍ನೊ ಅಧಿಕಾರಿನೆ ಚಿಮ್ನಿನ ಮಂಗಾವ್ತೊಹುಯಿನ್ ಒಗ್ಗಿಸ್‌ಮ ಮಹಿ ಜೈ಼ನ್ ಡರ್‌ಥಿ ಕಾಪ್ತೊಹುಯಿನ್ ಪೌಲ ಅಜು಼ ಸೀಲನ ಗೋಡಾಪರ್ ಆಡ್‍ಪಡ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","ಅಜು಼ ಇವ್ಣುನ ಭಾರ್‌ ಬುಲೈಲಿನ್ ಐನ್, “ಮಾಲಿಕ್ ರಕ್ಷಣೆ ಮಳ್‌ಣುಕತೊ ಮೆ ಶಾತ್‌ ಕರ‍್ನು?” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","ಇವ್ಣೆ ಇನ, “ಪ್ರಭು ಯೇಸುಪರ್ ವಿಶ್ವಾಸ್ ಕರ್‌ ತದೆ ತುನಾಬಿ ತಾರ ಘರ್‌ವಾಳಾನಾಬಿ ರಕ್ಷಣೆ ಮಳ್‌ಶೆ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","ಯೋ ಅದಿಕಾರಿನಾಬಿ ಇನ ಘರ್‌ವಾಳ ಅಖ್ಖಾಸ್ನ ಪ್ರಭುನಿ ವಚನ್ ಖ್ಹಮ್‍ಜಾ಼ಡ್ಯ. ");
INSERT INTO vaa_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","ಇನಕೇಡೆಥು, ಯೋಸ್ ರಾತ್ನಿ ವಖ್ಹತ್‌ಮ ಬುಲೈಲಿಜೈ಼ನ್ ಇವ್ಣ ಘಾವ್ನ ಧೋಯೊ. ತದೇಸ್‌ ಯೋಬಿ ಇನ ಘರ್‌ವಾಳಾನ ಖ್ಹಮೇದ್ ಬ್ಯಾಪ್ತಿಸ್ಮ ಕರೈಲಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","ಇನಪಾರ್ ಪೌಲ ಅಜು಼ ಸೀಲನ ಇನ ಘರೆ ಬುಲೈಲೀಜೈ಼ನ್ ಖಾಣು ಖಡಾಯೊ. ಯೋ ಇನ ಘರ್‌ವಾಳಾನ ಜೋ಼ಡ್ಮ ದೇವ್ನ ನಂಬಿನ್ ಶಂತೋಖ್ಹ್‌ ಪಡ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","ಇನವ್ಹಾಣೆ ಅಧಿಕಾರಿನ ಮೋಟಾನೆ ರೋಮ್‍ನ ಖ್ಹಾರ್ಕೊಟ್‌ನ ಅಧಿಕಾರಿನ, “ಆ ಅದ್ಮಿಖ್ಹಾರಾನ ಮ್ಹೇಲಿದೆ” ಕರಿ ಥೋಡ ಶಿಪಾಯಿಥಿ ಬೋಲಿಮೋಕ್‌ಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","ಖ್ಹಾರ್ಕೊಟ್‍ನೊ ಅಧಿಕಾರಿನೆ ಪೌಲನ, “ಹಮಾರೊ ಮೋಟಾ ಅಧಿಕಾರಿನೆ, ತುಮೂನ ಮ್ಹೆಲಿದ್ಯವಾದೆ ಕರಿ ಬೋಲಿ ಮೋಕ್‍ಲೈರಾಖ್ಯೊಸ್. ಇನಖ್ಹಾಜೆ ತುಮೆ ಸಮಾಧಾನ್‌ಥಿ ಚ಼ಲೆಜಾ಼ವೊ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","ಪೌಲನೆ ಇನ, “ಹಮೆ ಕರ‍್ಯಾತೆ ಖರಾಬ್ ಕಾಮ್ ಶಾತ್‌ಕರಿ ಬೋಲ್ಯೊಕೊಂತೆ; ಹಮೂನ ಅಖ್ಖಾನ ಖ್ಹಾಮ್ಣೆ ಮಾರಿನ್ ಜೇಲ್‌ಮ ಘಲಾಯು; ಹಮೆ ರೋಮ್‍ನ ಪ್ರಜೇಸ್ ಹಮ್ಕೆ ಹಮೂನ ಲಪಾಡಿನ್ ಭಾರ್‌ ಮೋಕ್ಲಸ್‍ಕೀ ಶು? ಇಮ್‌ ನಾಹೋಣು; ಯೋಸ್ ಐನ್ ಹಮೂನ ಭಾರ್‌ ಬುಲೈಲಿ ಜಾ಼ವ್ಣು.” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","ಶಿಪಾಯಿಖ್ಹಾರನೆ, ಅಧಿಕಾರಿಖ್ಹಾರನ ಬೋಲಖ್ಹತರ್ ಪೌಲನೆ ಹಮೆ ರೋಮ್‍ನ ಪ್ರಜೆಕರಿ ಬೋಲ್ತಾನ ಇನ ಅಧಿಕಾರಿಖ್ಹಾರು ಡರಿಗಯು. ");
INSERT INTO vaa_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","ಇನಖ್ಹಾಜೆ ಪೌಲ ಅಜು಼ ಸೀಲನ ಪೊಖ್ಹ್‌ಲೈ ವಾತೆ ಬೋಲ್ತುಹುಯಿನ್ ಇವ್ಣುನ ಭಾರ್‌ ಬುಲೈಲಿಗಯು. ತುಮೆ ಆ ಖ್ಹಯೇರ‍್ನ ಮ್ಹೇಲಿದಿನ್ ಚ಼ಲೆಜಾ಼ವೊ ಕರಿ ಬೋಲಿಲಿದು. ");
INSERT INTO vaa_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","ಕತೋಬಿ ಪೌಲಬಿ ಸೀಲನೆ ಜೇಲ್‌ಥು ನಿಕ್ಳಿನ್ ಲಿಡಿಯಾನ ಘರೆಗಯ. ಹಿಜ್ಜಾ಼ ಇವ್ಣೆ ಥೋಡ ವಿಶ್ವಾಸಿನ ದೇಖಿನ್ ಇವ್ಣುನ ಭಾಲಿದೀನ್ ಹಿಜ್ಜಾ಼ಥ ಚ಼ಲೇಗಯ. ");
INSERT INTO vaa_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","ಪೌಲ ಅಜು಼ ಸೀಲನೆ ಅಂಫಿಫೊಲಿ ಅಜು಼ ಅಪೊಲೋನ್ಯನಿ ವಾಟೆಕರಿ ಚಾ಼ಲ್ತಹುಯಿನ್ ಥೆಸಲೋನಿಕ ಖ್ಹಯೇರ್‌ಮ ಆಯ. ಹಿಜ್ಜಾ಼ ಯೆಹೂದ್ಯರ್‌ನಿ ಏಕ್‍ ಸಬಾಮಂದಿರ್‌ ಥು. ");
INSERT INTO vaa_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","ಪೌಲನೆ ಕದೆ ಕದೇಬಿ ಜಾ಼ತೊಥೋತೆ ಇಮ್ಮಸ್ ಯೆಹೂದ್ಯರ್‌ನ ಮಳಾನಖ್ಹಾಜೆ ಸಭೆಮ ಗಯೊ. ಇನೆ ತೀನ್ ವಾರ ಸಬ್ಬತ್‌ ದನ್ಮ ಯೆಹೂದ್ಯರ್‌ನ ಜೋ಼ಡೆ ದೇವ್ನಿ ವಚನ್ನಿ ಆಧಾರ್‌ಥಿ ಬೋಲಿವತಾಳ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","ಜಗತ್ನ ಉದ್ಧಾರ್ ಕರಾವಾಳೊ, ಖ್ಹತಾಪ್ಣಿನ ಲೇವ್ಣೂಸ್‍ ಪಡ್ಯುಥು. ಅಜು಼ ಮರಿಜೈನ್ ಪಾಛು಼ ಉಟ್ನುಸ್ ಪಡ್ಯುಥು ಕರಿ ಮೇ ಬೋಲುಕರುಸ್ತೆ ಯೋ ಕ್ರಿಸ್ತ” ಕರಿ ಮಾಲುಮ್‌ ಕರಾಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","ಇವ್ಣಾಮ ಥೋಡಜ಼ಣು ದೇವ್ನು ಭಕ್ತರ್‌ ಹುಯಿರುತೆ ಗ್ರೀಕ್‌ನು ಮೋಟು ಝೂ಼ಂಡ್‌ ಅಜು಼ ಮುಖ್ಯ ತಯೇಡಾಮ ಕೈಯೆಕ್‍ಜ಼ಣಿ ಪೌಲ ಅಜು಼ ಸೀಲಾನಿ ಜೋ಼ಡೆ ಮಳಿಗಯು. ");
INSERT INTO vaa_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","ಕತೋಬಿ ನಂಬ್ಯುಕೊಂತೆ ಯೆಹೂದ್ಯಖ್ಹಾರು ಬಳಾಪೊ ಕರ‍್ಯು. ಇವ್ಣೆ ಖ್ಹಯೇರ್‌ಮ ಥೂತೆ ಥೋಡ ಖರಾಬ್ ಅದ್ಮಿವೋನ ಪೈಶಾದೀನ್ ಬುಲೈಮಂಗೈನ್‌ ಗಮ್ಮ ಗಲಾಟ್ ಕರೈನ್, ಪೌಲಬಿನ್ ಸೀಲನ ಖ್ಹಯೇರ‍್ನ ಸಭೆನ ಖ್ಹಾಮ್ಣೆ ಲೀನ್‍ ಆವ್ಣುಕರಿ ಯಾಸೋನನ ಘರ್‌ನ ಘೇರ್ತುಹುಯಿನ್ ಆಯು. ");
INSERT INTO vaa_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","ಕತೋಬಿ ಇವ್ಣೆ ಹಿಜ್ಜಾ಼ ದೆಖಾಯುಕೊಂತೆ ಇನಖ್ಹಾಜೆ ಇವ್ಣೆ ಯಾಸೋನನಾಬಿ ಥೋಡ ವಿಶ್ವಾಸಿಖ್ಹಾರಾನ ನಂಗರ‍್ನ ಅಧಿಕಾರಿನ ಖ್ಹಾಮ್ಣೆ ಖೇಚಿಲೈನ್‌; ಆ ಅದ್ಮಿಖ್ಹಾರು ಜಗತ್ನಿಅಖ್ಖಿಸ್ ಬಾಜು಼ ಗಲಾಟ್ ಉಠಾಡಿನ್ ಹಮ್ಕೆ ಹಜ್ಜಾ಼ಬಿ ಐರ‍್ಹಾಸ್. ");
INSERT INTO vaa_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","ಯಾಸೋನನೆ, ಇನ ಘರ್‌ಮಾಸ್ ಇವ್ಣುನ ರಾಖಿರಾಖ್ಯೋಸ್. ಅಜು಼ ಇವ್ಣೆಖ್ಹಾರು ಯೇಸುಕರಿ ಬಿಜೇಕ್‍ಜ಼ಣೊ ರಾಜ಼ ಛಾ಼ಕರಿ ಬೋಲಿನ್, ಕೈಸರ್‌ನಿ ಹುಕುಮ್‌ನ ವಿರೋಧ್‍ಥಿ ಚಾ಼ಲುಕರಸ್ ಕರಿ ಚಿಕ್‌ರ‍್ಯು. ");
INSERT INTO vaa_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","ಆ ವಾತೆ ಖ್ಹಮ್‍ಜ್ಯುತೆ ಖ್ಹಯೇರ್‌ವಾಳು ಅಜು಼ ಖ್ಹಯೇರ‍್ನ ಅಧಿಕಾರಿನ ಘಣು ಕಲಾವ್ಣಿ ಹುಯಿನ್ ");
INSERT INTO vaa_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","ಯಾಸೋನಥೀಬಿ ಬಿಜ಼ ಥೋಡ ವಿಶ್ವಾಸಿಥೀಬಿ ಜಾ಼ಮೀನ್‍ಲೀನ್ ಇನ ಪಾಛ಼ಳ್ ಇವ್ಣುನ ಮ್ಹೇಲಿದಿದು. ");
INSERT INTO vaa_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","ಯೋಸ್ ರಾತ್ಮ ವಿಶ್ವಾಸಿಖ್ಹಾರು ಪೌಲ ಸೀಲನ ಬೆರೋಯ ಕರಿ ಬೋಲಾನು ಬಿಜೇಕ್ ಖ್ಹಯೇರ‍್ನ ಮೋಕ್‍ಲ್ಯು. ಬೆರೋಯಮ ಪೌಲ ಸೀಲನ ಯೆಹೂದ್ಯರ್‌ನ ಸಭೆಮ ಗಯ. ");
INSERT INTO vaa_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","ಆ ಯೆಹೂದ್ಯವಾಳು ಥೆಸಲೋನಿಕನ ಯೆಹೂದ್ಯರ್‌ಥಿಬಿ ಪೌಲ ಸೀಲನೆ ಬೋಲ್ಯಾತೆ ಅಛ್ಛಿ ಸಂದೇಶ್ನ ಖುಲ್ಲ ದಿಲ್‌ಥಿ ಘಣು ಶಂತೋಖ್ಹ್‌ ಥಿ ಖ್ಹಮ್‌ಜ್ಯು. ಅಜು಼ ಯೋ ವಾತೆ ಖ್ಹಾಚು಼ಸ್‍ಕರಿ ಬೋಲಾನು ಮಾಲುಮ್ ಕರಿಲ್ಯವಾನಖ್ಹಾಜೆ ಪವಿತ್ರ ಪುಸ್ತಕನ ಹರೇಕ್ನೆ ಬರೋಬರ್ ಫಢ್ಯುತೆ ಇನಖ್ಹಾಜೆ ಥೆಸಲೋನಿಕ ವಾಳೇಥಿಬಿ ಅಛ್ಛಿಗುಣ್‌ವಾಳು ಹುಯಿರ‍್ಹುಥು ");
INSERT INTO vaa_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","ಅಮ್‍ರ‍್ಹಾವಮ ಕೈಯೆಕ್ಕಿ ಜ಼ಣು ನಂಬ್ಯು. ಅಜು಼ ಗ್ರೀಕ್‍ನಿತಯೇಡ ಪರ್ಖ್ಹಾ ವಿಶ್ವಾಸ್ ಕರ‍್ಯು. ");
INSERT INTO vaa_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","ಕತೋಬಿ ಪೌಲ ಬೆರೋಯಮ ದೇವ್ನು ವಚನ್ನ ಬೋಲುಕರಸ್ ಕರಿ ಬೋಲಾನು ಖ್ಹಮ್‌ಜಿನ್‌ ಥೆಸಲೋನಿಕನು ಯೆಹೂದ್ಯಮಾಬಿ ಬೆರೋಯಮಾಬಿ ಐನ್ ಹಿಜ಼್ಜಾನ ಅದ್ಮಿಖ್ಹಾರಾನ ಕಲಾವ್ಣಿಕರಿನ್ ಗಲಾಟ್ ಉಠಾಡ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","ಇನಖ್ಹಾಜೆ ವಿಶ್ವಾಸಿಖ್ಹಾರು ತದ್‌ನು ತದೇಸ್‌ ಪೌಲನ ದರ‍್ಯಾವ್ನ ಕನಾರಲಗು ಮೋಕ್ಲಿದಿದು. ಕತೋಬಿ ಸೀಲ ಅಜು಼ ತಿಮೊಥೆ ಇವ್ಣೆ ಬೆರೋಯಮಾಸ್ ರ‍್ಹೀಗ. ");
INSERT INTO vaa_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","ಪೌಲನ ಮ್ಹೇಲಿದ್ಯವಾನ ಗಯುಥೂತೆ ಖ್ಹಾರು ಇನ ಜೋ಼ಡ್ಮ ಅಥೇನ್ಸಲಗು ಗಯು. ಸೀಲನಾಬಿ ತಿಮೊಥೆಯನಾಬಿ ಮಳಿಹುಯಿಗುತೊ ತದೇಸ್‌ ಒಗ್ಗಿಸ್ ಇನಕನ ಆವ್ಣುಕರಿ ಪೌಲನಿ ಹುಕುಮ್‍ಥಿ ಪಾಛ಼ ಆಯ. ");
INSERT INTO vaa_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","ಪೌಲ ಇವ್ಣಖ್ಹಾಜೆ ಅಥೇನ್ಸ್‌ಮ ಟಿವೈರ‍್ಹವಾನಿ ವೇಳ್ ಯೋ ಖ್ಹಯೇರ್‌ಮ ಕಿಜ್ಜಕಿಜ್ಜಾಬಿ ಮೂರತ್ತಸ್‍ ಅಖ್ಖು ರ‍್ಹವಾನು ದೇಖಿನ್ ಇನೊ ಮನ್ ಉಕ್ಳಿರ‍್ಹೀಗು. ");
INSERT INTO vaa_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","ಇನಖ್ಹಾಜೆ ಇನೆ ಸಭೆಮ ಜೈ಼ನ್ ಯೆಹೂದ್ಯರ್ ಅಜು಼ ದೇವ್ನಿ ಭಕ್ತಿರ‍್ಹಾವಳು ಗ್ರೀಕ್‍ವಾಳಾನಿ ಜೋ಼ಡೆ ಅಜು಼ ಖ್ಹಯೇರ್‌ಮ ಬೇಪಾರ್‌ಕರಾನಿ ಝ಼ಗೋಮ ದೇಖವಾಳಾನಿ ಜೋ಼ಡ್ಮ ಹರೇಕ್ ದನ್ ಚರ್ಚೆ ಕರಾಲಗ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","ಎಫಿಕೂರಿಯವಾಳು ಅಜು಼ ಸ್ತೋಯಿಕ ಕರಿ ನವಿ ಸೋಚ್ನಿ ಬಾರೇಮ ಬೋಲಾವಳು ಥೋಡುಜ಼ಣು, “ಆ ಅದ್ಮಿನ ಯೋ ಶನಿಬಾರೇಮ ವಾತೆ ಬೋಲುಕರಸ್ತೆ ಕರಿ ಬೋಲಾನು ಖ್ಹಾಚಮಾಬಿ ಮಾಲುಮ್ ಕೊಯ್ನಿ. ಯೋ ಶಾತ್ ಬೋಲ್ನುಕರಿ ಛಾ಼? ಕರಿ ಬೋಲ್ಯು. ಯೇಸು ಮರ‍್ಯಮಾಥು ಪಾಛು಼ಜಿವ್ತೊಹುಯಿನ್ ಉಠೀನ್ ಐರ‍್ಹೋಸ್ ಕರಿ ಬೋಲಾನಿ ಸುವಾರ್ತೆನ ಪೌಲ ಬೋಲುಕರ್ತೊಥೊ. ಅಜು಼ ಥೋಡುಜ಼ಣು ‘ಆ ಹುಯಿರುತೆ ಬಹಾರ್‌ಲ್ಯ ದೇವ್ನಿ ಬಾರೇಮ ಬೋಲಾನಿತರ ದೇಖಾವಸ್; ಕರಿ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","ಇವ್ಣೆ ಪೌಲನ ಅರಿಯೊಪಾಗನಿ ನ್ಯಾವ್‍ನಿ ಸಭೆಮ ಬುಲೈಲಿಗಯು. ಅವ್ಣೆ ಇನ “ತೂ ಶಾತ್ ಬೋಲಿ ವತಾಳ್ಣು ಕರಿ ಛಾ಼ಕಿ ಯೊ ನವಿ ಬೋಧನ್ನಿ ನಿಯಮ್ನ ಹಮುನಾಬಿ ವತಾಳ್. ");
INSERT INTO vaa_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","ತೂ ಬೋಲುಕರಾತೆ ಅಖ್ಖಿವಾತೆ ಹಮೂನ ನೌಖು ಹುಯಿರ‍್ಹುಸ್. ");
INSERT INTO vaa_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","ಅಥೆನ್ಸ್‌ಮ ಅಖ್ಖೂಸ್ ಅದ್ಮಿ ಅಜು಼ ಹಿಜ್ಜಾ಼ ಜಿವ್‍ಕರ್ತುಥೂತೆ ಬಿಜ಼ ದೇಖ್ಹ್‌ವಾಳು ನವ ಸೋಚ್ನಿ ಬಾರೇಮ ಬೋಲನಾಬಿ ಅಜು಼ ಖ್ಹಮ್‍ಜಾ಼ನಾಬಿ ಘಣು ಇಷ್ಟಕರ‍್ಯು. ");
INSERT INTO vaa_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","ತದೆ ಪೌಲನೆ ಅರಿಯೊಪಾಗನ ನ್ಯಾವ್‍ನಿ ಸಭೆನ ಖ್ಹಾಮ್ಣೆ ಉಠಿಭೀರಿನ್ ಅಮ್ ಬೋಲ್ಯೊ, “ಅಥೆನ್ಸ್‌ನ ಅದ್ಮಿವೊ ತುಮೆ ಅಖ್ಖೀಸ್ ಥರಮಾಬಿ ದೇವ್ನ ಜಾ಼ಖ್ಹತ್ ಭಕ್ತಿ ಕರಾವಾಳ ಕರಿ ಮನ ದೇಖಾವಸ್. ");
INSERT INTO vaa_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","ಮೆ ತುಮಾರ ಖ್ಹಯೇರ್‌ಮ ಚಾ಼ಲಿನ್ ವೇಳ್ಮ ತುಮೆ ಪೂಜ಼ಕರಾತೆ ದೇವ್ತಿನು ಮೂರತ್ನ ದೇಖಾನಿವಖ್ಹ್‌ತೆ ಏಕ್‌ ಚಾ಼ಚ಼ರ್‌ಪರ್ ‘ಮಾಲುಮ್‌ಕೊಂತೆ ದೇವ್ನ ಕರಿ ಲೀಖೈರ‍್ಹೂಥು. ಇನಖ್ಹಾಜೆ ತುಮೆ ಖೆವಾನ ಮಾಲುಮ್‌ಕೊಂತೆ ಪೂಜ಼ಕರಸ್ಕಿ ಇನಾಸ್ ತುಮೂನ ಮಾಲುಮ್‌ ಕರಾವುಸ್ ಖ್ಹಮ್‍ಜೊ಼” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","ಜಗತ್ನಾಬಿ ಇನಾಮಛಾ಼ತೆ ಅಖ್ಖಾನಾಬಿ, ಬಣಾಯೋತೆ ದೇವ್ ಆಬ್ ಧರ್ತಿನ ಯಜಮಾನ್ ಹುಯಿರ‍್ಹೋತೆ ಇನಖ್ಹಾಜೆ ಯೋ ಹಾತೇಖ್ಹು ಭಾಂದಿಹುಯು ದೇವಳ್ಮ ಜಿವ್ಣುಕರಾವಾಳೊ ಕಾಹೆ; ");
INSERT INTO vaa_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","ಯೋಸ್ ಹರೇಕ್ನ ಜಾನ್ನೊರಾವೊ಼ ಅಜು಼ ಜಿವಾನಖ್ಹಾಜೆ ಹೋಣುತೆ ಖ್ಹಾರುಸ್‌ದ್ಯವಾಳೊ ಯೋಸ್; ಇಮ್ಮಸ್ ಅದಮ್‍ಜ಼ಮಾನೊ ಇನಖ್ಹಾಜೆ ಮ್ಹಿನತ್‌ಕರಾನು ಕಾಮ್ ಇನ ಶಾತ್ಬಿಕೊಯ್ನಿ. ");
INSERT INTO vaa_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","ದೇವ್ನೆ ಏಕ್‌ ಅದ್ಮಿನ ಬಣಾವ್‍ತೊ ಹುಯಿನ್ ಅದಮ್‍ಜ಼ಮಾನಾನು ಝೂ಼ಂಡ್‌ ಶುರುಕರ‍್ಯೊ. ಇನೇಥಿ ಬಿಜು಼ ಅಖ್ಖೂಸ್ ಅದ್ಮಿನ ಜಗತ್‌ನು ಕಿಜ಼್ಜಕಿಜ್ಜಾ಼ಬಿ ಇವ್ಣೆ ಜಿವ್ಣು ಕರಾನಿತರ ಕರ‍್ಯೊ. ಇವ್ಣೆ ಕದೆ ಅಜು಼ ಕಿಜ಼್ಜಕಿಜ್ಜಾ಼ ರ‍್ಹೇವ್ಣುಕರಿ ಬೋಲಾನು ನಿರ್ಧಾರ್ ಕರ‍್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","ಏಕ್‌ ವೇಳ್ ಇವ್ಣೆ ಧೀರ್‌ಥಿ ತೋಬಿ ಮಾಲುಮ್ ಕರಿಲಿಶೆಕರಿ ಇನ ಢುಂಡಾನಿತರ ಕರ‍್ಯೊ. ಕತೋಬಿ ದೇವ್ ಅಪ್ಣಾಮ ಕಿನಾಬಿ ಜಾ಼ಖ್ಹತ್ ದೂರ್ ಕೊಯ್ನಿ. ");
INSERT INTO vaa_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","ಶನಕತೊ ಇನಾಸ್ಮ ಅಪ್ಣೆ ಜಿವ್‌ಕರಿಯೇಸ್. ಚಾ಼ಲುಕರಿಯೇಸ್ ಅಜು಼ ರ‍್ಹಿಯೇಸ್. ತುಮಾರ ಗೀದ್‌ ಲಿಖವಾಳಮ ಥೋಡುಜ಼ಣು, “ಹಮೆ ಇನ ಸಂತಾನ್‍ವಾಳಸ್” ಕರಿ ಬೋಲಿರಾಖ್ಯುಸ್. ");
INSERT INTO vaa_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","ಅಪ್ಣೆ ದೇವ್ನ ಲಡ್ಕ ಹುಯಿರ‍್ಯವಾಪರ್‌, ಅದ್ಮಿಖ್ಹಾರು ಸೋಚಾನಿ ಪರಕ್ಮ ಬಣಾವಟ್ನಿ ಮೂರತ್ನ ಪರಕ್‍ ರ‍್ಹವೊ ದೇವ್‌ ಛಾ಼ಕರಿ ತುಮೆ ಖ್ಹಯಾಲ್ ನಾಕರ‍್ನು. ಯೊ ರೂಪು ಖ್ಹೊನ್ನು ಅಜು಼ ಬಂಡಾನಿ ಶಕಲ್ಮ ಕೊಯ್ನಿ. ");
INSERT INTO vaa_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","ಗಯೂತೆ ಹಗಾಮ್ಮ ಅದ್ಮಿಖ್ಹಾರು ದೇವ್ನ ಮಾಲುಮ್ ಕರ‍್ಯುಕೊಯ್ನಿ. ಕತೋಬಿ ದೇವ್ನೆ ಯೊ ಶಾತ್ಬಿ ಕರ‍್ಯೊಕೊಯ್ನಿ. ಹಮ್ಕೆತೋಬಿ ಜಗತ್ನಿ ಅಖ್ಖಿಬಾಜು಼ಮ ರ‍್ಹವಾಳು ಅದ್ಮಿಖ್ಹಾರು ಖರಾಬ್ ಮಾರಗ್‌ನ ಮ್ಹೇಲಿನ್ ಇನಾಭಣಿ ಫರ್‌ನುಕರಿ ಹುಕುಮ್ ದೆವುಕರಸ್. ");
INSERT INTO vaa_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","ಜಗತ್ನ ಅದ್ಮಿಖ್ಹಾರಾನು ನ್ಯಾಯನ ಫೆಡಾವನಖ್ಹಾಜೆ ದೇವ್ನೆ ಏಕ್‍ದನ್ನ ಖ್ಹಣೇದ್ ಕರಿರಾಖ್ಯೋಸ್. ತದೆ ನ್ಯಾವ್‌ನ ಫೇಡಾವನಖ್ಹಾಜೆ ಇನೆ ಏಕ್‍ಜ಼ಣಾನ ಕೇತ್ರಾಕಿ ವರಖ್ಹ್‌ನ ಪಾರಸ್ ಚೂ಼ಣಿರಾಖ್ಯೊಸ್. ಅನ ಹರೇಕ್‌ಜ಼ಣಾನ ಮಾಲುಮ್ ಕರಾವನಖ್ಹಾಜೆ ಆ ಏಕ್‍ಜ಼ಣಾನ ಮರ‍್ಯಹುಯಮಾಥು ಜಿವ್ತು ಉಠಾಡಿರಾಖ್ಯೊಸ್. ");
INSERT INTO vaa_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","ಯೇಸು ಮರ‍್ಯಹುಯಮಾಥು ಪಾಛು಼ಜಿವ್ತೊಹುಯಿನ್ ಉಠೀನ್ ಐರ‍್ಹೋಸ್‍ಕರಿ ಬೋಲಾನಿ ವಾತೆನ ಖ್ಹಮ್‍ಜ್ಯೊತೆ ಅದ್ಮಿಮ ಥೋಡುಜ಼ಣು ನಕ್ಲೆ ಕರ‍್ಯು. ಅಜು಼ ಥೋಡುಜ಼ಣು “ಆ ವಾತೆನಿ ಬಾರೇಮ ತೂ ಬಿಜೇಕ್‍ಹಲ್ಲ ಬೋಲೆಜಾ಼ಯ್ ತದೆ ಹಮೆ ಖ್ಹಮಜ಼್‌ಶು” ಕರಿ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","ಇನಖ್ಹಾಜೆ ಪೌಲನೆ ಇವ್ಣಕಂಥು ನಿಕ್ಳಿ ಚ಼ಲೆಗಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","ಕತೋಬಿ ಯೋ ಅದ್ಮಿಖ್ಹಾರಾಮ ಥೋಡುಜ಼ಣು ಪೌಲನ ವಿಶ್ವಾಸ್ ಕರಿನ್ ಇನಕೇಡೆ ಎಕ್ಟು ಹುಯು. ನಂಬ್ಯುತೆ ಅದ್ಮಿಖ್ಹಾರಾಮ ಅರಿಯೊಪಾಗ ನ್ಯಾವ್‍ನಿ ಸಭೆವಾಳೊ ದಿಯೊನುಸ್ಯಬಿ, ದಾಮರಿ ಕರಿ ಏಕ್‍ಜ಼ಣಿ ಥಿ, ಇಮ್ಮಸ್ ಅಜೂ಼ಬಿ ಥೋಡುಜ಼ಣು ಥೂ. ");
INSERT INTO vaa_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","ಇನಕೇಡೆಥು ಪೌಲನೆ ಅಥೇನ್ಸನ ಮ್ಹೇಲಿನ್ ಕೊರಿಂಥ ಖ್ಹಯೇರ‍್ನ ಗಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","ಪೊಂತಾಮ ಪೈದಾಹುಯಿರೊಥೋತೆ ಆಕ್ವಿಲ ಕರಿ ಏಕ್‍ಜ಼ಣೊ ಯೆಹೂದ್ಯನ ಹಿಜ್ಜಾ಼ ದೇಖ್ಯೊ. ಚಕರ್‌ವರ್ತಿ ಕ್ಲೌದಿಯನೆ ರೋಮ್ ಖ್ಹಯೇರ‍್ನ ಮ್ಹೇಲಿಜಾ಼ವ್ಣುಕರಿ ಹುಕುಮ್‌ ದೀರಾಖ್ಯೋಥೋತೆ ಖ್ಹಾಜೆ ಅಕ್ವಿಲಬಿನ್ ಇನಿ ಬಾವಣ್‍ ಹುಯಿರ‍್ಹಿತೆ ಪ್ರಿಸ್ಕಿಲ್ಲ ಥೋಡದನ್ನ ಅಗ್ಗಳಸ್ ಇಟಲಿ ದೇಖ್ಹ್‌ ಥು ಹಿಜ್ಜಾ಼ ಐರ‍್ಹುಥು. ತದೆ ಪೌಲನೆ ಇವ್ಣುನ ದೇಖಾನ ಗಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","ತದೆ ಇವ್ಣೆ ಪೌಲನಿ ಘೋಣಿಸ್ ಡೇರಾನುಘರ್ ಬಣಾವಾಳು ಹುಯಿರ‍್ಹುಥೂತೆ ಇನಖ್ಹಾಜೆ ಇವ್ಣಕೇಡೆ ರ‍್ಹೀನ್, ಇವ್ಣ ಜೋ಼ಡೆ ಕಾಮ್‍ಕರ್ತೊ ಆಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","ಹರೇಕ್ ಸಬ್ಬತ್ ದನ್ಮ ಯೊ ಸಭೆನಿ ಝ಼ಗೊ ಯೆಹೂದ್ಯರ್‌ನಿ ಜೋ಼ಡೆಬಿ ಗ್ರೀಕ್‍ವಾಳಾನಿ ಜೋ಼ಡೆಬಿ ಚರ್ಚೆಕರೀನ್ ಇವ್ಣುನ ಮಳಾವ್ತೊಥೊ. ");
INSERT INTO vaa_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","ಇಮ್ಮಸ್ ಮೆಕೆದೋನ್ಯಮ ಥಾತೆ ಸೀಲ ಅಜು಼ ತಿಮೊಥೆ ಇವ್ಣೆ ಪೌಲಕನ ಆಯ. ಇನಪಾರ್ ಅದ್ಮಿಖ್ಹಾರಾನ ಇವ್ಣಿವಾತೆನ ಬೋಲಿ ಖ್ಹಮ್‌ಜಾ಼ಡಮ ಪೌಲನೆ ಇನಿ ವಖ್ಹತ್‍ಖ್ಹಾರು ಕಾಡಿನಾಖ್ಯೊ. ಯೇಸುಸ್ ಮೆಸ್ಸಿಯಕರಿ ಬೋಲಾನು ಇನೆ ಯೆಹೂದ್ಯರ್‌ನ ದೇಖಾಡಿದಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","ಕತೋಬಿ ಯೆಹೂದ್ಯರ್ ಪೌಲನಿ ಬೋಧನೆನ ಝಿಟ್ಕಾರಿನ್ ಅಜು಼ ಚಿಂಘಾವ್ಣಿ ಕರ‍್ಯು. ಇನಖ್ಹಾಜೆ ಪೌಲನೆ ಇನ ಲುಂಗ್ಡಾನ ಧೂಳ್ನ ಝ಼ಟ್‍ಕಿನ್ ಇವ್ಣುನ, ತುಮಾರಿ ನಾಶ್‌ನ ತುಮೇಸ್ ಜಿಮ್ಮೆದಾರಿ, ಮೇ ಶುದ್ದ ಹುಯಿರ‍್ಹೊಸ್. ಮೆ ಹಮ್ಕೇಥೊ ಅಲಕ್‌ ಅದ್ಮಿವೋಕನ ಜ಼ವುಸ್‌” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","ತದೆ ಪೌಲನೆ ಸಭೆನಿ ಝ಼ಗೊ ಮ್ಹೇಲಿನ್ ಇನಭೀಡೆಸ್ ಥೂತೆ ತೀತ ಯುಸ್ತ ಕರಿ ಏಕ್‌ ಜ಼ಣಾನ ಘರ್ ಗಯೊ. ಯೊ ಅದ್ಮಿ ಖ್ಹಾಚ ದೇವ್ನು ಆರಾದನೆ ಕರಾವಾಳೊ ಹುಯಿರ‍್ಹೋಥೊ. ");
INSERT INTO vaa_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","ಯೊ ಸಬಾಮಂದಿರ್‌ನೊ ಯಜಮಾನ್ ಕ್ರಿಸ್ಪಕರಿ ಏಕ್‌ ಜ಼ಣೊ ಅಜು಼ ಇನ ಘರ್‌ಮ ರ‍್ಹವಾಳು ಖ್ಹಾರುಜ಼ಣು ಪ್ರಭುನ ವಿಶ್ವಾಸ್ ಕರ‍್ಯು. ಕೊರಿಂಥನು ಬಿಜೂ಼ಬಿ ಕೆತ್ರುಕ್ಕಿ ಅದ್ಮಿ ಪೌಲನ ಬೋಧನೆನ ಖ್ಹಮ್‌ಜಿನ್‌ ನಂಬ್ಯು ಅಜು಼ ಬ್ಯಾಪ್ತಿಸ್ಮ ಲಿದು. ");
INSERT INTO vaa_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","ಏಕ್‍ದನ್ ರಾತ್ಮ ಪೌಲನ ದರ್ಶನ್ ಹುಯು. ಪ್ರಭುನೆ ಇನ, “ಡರ್‌ನಕೊ ಬೋಲ್ತೋಸ್‍ ರ‍್ಹೆ ಶೊಪ್‌ನಕೊ ರ‍್ಹೀಶ್, ");
INSERT INTO vaa_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","ಮೇಸ್ ತಾರಿ ಜೋ಼ಡ್ಮ ಛೂ಼. ಕೋಣ್‌ಬಿ ತುನ ಖರಾಬ್ ಕರಾನ ಕೊಉಷೇನಿ. ಆ ಖ್ಹಯೇರ್‌ಮ ಮಾರಭಣಿಥು ಕೆತ್ರೂಕಿ ಜ಼ಣು ಛಾ಼” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","ಇಮ್ಮಸ್ ಡೋಡ್‌ವರಖ್ಹ್ ಲಗು ಹಿಜ್ಜಾ಼ರ‍್ಹೀನ್ ದೇವ್ನಿ ವಚನ್ನ ಅದ್ಮಿಖ್ಹಾರಾನ ಬೋಧನೆ ಕರ‍್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","ಗಲ್ಲಿಯೋಕರಿ ಏಕ್‍ಜ಼ಣೊ ಅಖಾಯ ಮುಲಕ್‌ನೊ ರಾಜ್ಯಪಾಲ್ ಹುಯಿರ‍್ಹವಾನ ಖ್ಹಾಜೆ ಯೆಹೂದ್ಯರ್ ಪೌಲನಿ ವಿರೋದ್ ಎಕ್ಟುಹುಯಿನ್ ಇನ ಧರಿನ್ ನ್ಯಾವ್ನಿಝ಼ಗೊ ಲೀನ್‌ಗಯು. ");
INSERT INTO vaa_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","ಅಜು಼ “ದೇವ್ ಅದ್ಮಿಖ್ಹಾರಾನ ಅಪ್ಣ ಧರ್ಮಶಾಸ್ತ್ರಕನ ವಿರೋದ್‌ಥಿ ಆರಾದನೆ ಕರ್ನುಕರಿ ದಿಲ್‌ಬದ್ಲಾವನ ಕೋಶಿಶ್ ಕರುಕರಸ್” ಕರಿ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","ಪೌಲ ಪಾಛೊ಼ ಫರಿನ್ ವಾತೆ ಬೋಲ್ತೊ ರ‍್ಹವಾನಿವಖ್ಹ್‌ತೆ ಗಲ್ಲಿಯೋನನೆ ಯೆಹೂದ್ಯರ್‌ನ, “ಏಕ್‌ ವೇಳ್ಮ ಆ ಮೋಟಿ ಅಪರಾದ್ ಹುಯಿರ‍್ಹುಹೊತ್ತೊ ಅನ ಮೇ ಜಿಮ್ಮೇದಾರ್ ಲೀನ್ ಖ್ಹಮ್‍ಜ್ಯೊಹೊತ್. ");
INSERT INTO vaa_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","ಕತೋಬಿ ಆ ಹರೇಕ್ ಥರಾನು ವಿವಾದ್ ಬೋಧನೆನಾಬಿ, ನಾಮ್ನಾಬಿ, ತುಮಾರಿ ಧರ್ಮಶಾಸ್ತ್ರನಿ ಘೋಣಿಸ್ ಛಾ಼. ಇನ ತುಮಾರಿ ಪಸಂದ್‌ನಿತ್ರ ತುಮೇಸ್ ತೀರ್ಪ್ ಕರಿರಾಖ್ಯಸ್, ಅಥ್ರಾನಿ ವಾತೆನ ಮನ ನ್ಯಾವ್ ತೀರ್ಪ್ ಕರಾನ ಕೊಹುವ್ವಾನಿ.ಕರಿ ಬೋಲಿನ್ ");
INSERT INTO vaa_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","ಇವ್ಣುನ ನ್ಯಾವ್‍ನಿ ಝ಼ಗೊಮಾಥು ಭಾರ್‌ ಮೋಕ್‌ಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","ತದೆ ಅದ್ಮಿಖ್ಹಾರು ಸಬಾಮಂದಿರ್‌ನೊ ಅದ್ಯಕ್ಷ ಹುಯಿರ‍್ಹೊಥೋತೆ ಸೋಸ್ಥೆನಾನ ಧರಿಲೀನ್ ನ್ಯಾವ್ನಿಪಂಚ್‍಼ಕೋಟ್ಮಾಸ್ ಮಾರಲಗ್ಯು. ಗಲ್ಲಿಯೋನನೆ ಇನಾಮ ಏಕ್‌ಬಿ ಮಜೂ಼ರ್ ಕೊ ಕರ‍್ಯೋನಿ. ");
INSERT INTO vaa_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","ಪೌಲ ಕೈಏಕ್ ದನ್‌ಲಗು ವಿಶ್ವಾಸಿ ಭಯೇನಿ ಜೋ಼ಡ್ಮಾಸ್ ಥೊ. ಅನಕೇಡೆಥು ಪ್ರಿಸ್ಕಿಲ್ಲ ಅಜು಼ ಅಕ್ವಿಲನ ಜೋ಼ಡೆ ಜ಼ಹಾಜ಼್ ಚ಼ಢೀನ್ ಸಿರಿಯಾನ ನಿಕ್‌ಳ್ಯೊ. ಇನ ದೀಕ್ಷೆಥೂತೆ ಇನಖ್ಹಾಜೆ ಕೆಂಖ್ರೆಯ ಖ್ಹಯೇರ್‌ಮ ಮುಡ್‌ಕ್ಯಾನ ಕೇಖ್ಹ್‌ ಕಡಾಯೊ.ಶನಕತೊ ಯೋ ಶಪತ್ ಕರಿರಾಖ್ಯೊಥೊ. ");
INSERT INTO vaa_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","ಎಫೆಸಮ ಆವಖ್ಹತರ್ ಇನಿ ಜೋ಼ಡ್ಮ ರ‍್ಹವಾಳಾನ ಹಿಜ್ಜಾ಼ಸ್ ಮ್ಹೆಂದಿನ್ ಪೌಲ ಸಬೆನಿ ಝ಼ಗೊಕನ ಜೈ಼ನ್, ಯೆಹೂದ್ಯರ್‌ಥಿ ವಾದಕರ‍್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","ಇವ್ಣೆಖ್ಹಾರು ಇನ ಅಜೂ಼ಬಿ ಥೋಡದನ್ ಇವ್ಣಿ ಜೋ಼ಡ್ಮ ರ‍್ಹೇವ್ಣುಕರಿ ಬೋಲಿಲಿದು. ಕತೋಬಿ ಇನೆ ಮಾನ್ಯೊಕೊಯ್ನಿ. ");
INSERT INTO vaa_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","ಅನಬದಲ್ ಇನೆ ಇವ್ಣುನ “ದೇವ್ನಿ ಮರ್ಜಿ ರ‍್ಹಿಯಿತೊ ಮೆ ತುಮಾರಕನ ಪಾಛೊ಼ ಐಶ್‌”. ಕರಿ ಬೋಲ್ತೊಹುಯಿನ್ ಎಫೆಸಥು ಜ಼ಹಾಜ಼್‍ನಿ ಚಾ಼ಲ್ ಕರ‍್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","ಯೊ ಕೈಸರೈನ ಆವಾನಿ ವಖ್ಹ್‌ತೆ ಹಿಜ್ಜಾ಼ಥು ಯೆರೂಸಲೇಮ್ಮ ಜೈ಼ನ್ ಸಬೆನ ಮಳಿನ್ ಅಂತಿಯೋಕ್ಯನ ಗಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","ಪೌಲನೆ ಅಂತಿಯೋಕ್ಯಮ ಥೋಡದನ್ ರ‍್ಹೀನ್ ಫಾಚೊ಼ ಹಿಜ್ಜಾ಼ಥು ನಿಕ್ಳಿನ್ ಗಲಾತ್ಯಬಿ ಫ್ರಿಜಿಯ ತಬರ್‌ಖಾಮ ಫರ್ತೊಹುಯಿನ್ ಹಿಜ಼್ಜಾನ ವಿಶ್ವಾಸಿಖ್ಹಾರನ ಘಟ್‍ಥಿ ಭೀರಾಖ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","ಎತ್ರಾಮ ಅಲೆಕ್ಸಾಂಡ್ರಿಯಮ ಪೈದಹುಯೊತೆ ಅಪೊಲ್ಲೋಸ ಕರಿ ಯೆಹೂದ್ಯ ಏಕ್‍ಜ಼ಣೊ ಎಫೆಸಮ ಆಯೊ. ಯೋ ವಾತ್ಮ ಪುರ್‌ಗುಲ್‍ಬಿ ಅಜು಼ ಧರ್ಮಶಾಸ್ತ್ರನ ಅಛ್ಛಿನಿತರ ಮಾಲುಮ್ ಕರಿರಾಖ್ಯೊಥೊ. ");
INSERT INTO vaa_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","ಅಜು಼ ಯೊ ಘಣು ಮನ್‍ಲಗಾಡಿನ್ ಪ್ರಭು ಯೇಸುನಿ ಮಾರಗ್‌ನ ಬಾರೇಮ ಅಛ್ಛಿನಿತರ ಬೋಧನೆ ಕರ್ತೊಥೊ, ಅಜು಼ ಶಿಕಾಡುಕರ್ತೊಥೊ. ಕತೋಬಿ ಯೋಹಾನ ಕರಾಯೋತೆ ಬ್ಯಾಪ್ತಿಸ್ಮನಿ ಬಾರೇಮ ಖಲಿಮಾಲುಮ್ ಥು. ");
INSERT INTO vaa_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","ಅಪೊಲ್ಲೋಸನೆ ಸಬಾಮಂದಿರ್‌ಮ ಭಾಲಿಥಿ ಬೋಧನೆ ಕರ‍್ಯೊತೆ ಖ್ಹಮ್‍ಜ್ಯಾತೆ ಪ್ರಿಸ್ಕಿಲ್ಲ ಅಜು಼ ಅಕ್ವಿಲನೆ ಇವ್ಣೆ ಇನ ಘರೆ ಬುಲೈಜೈನ್ ಅಜು಼ ದೇವ್ನ ಮಾರಗ್‌ನ ಇನ ಬಿಜೂ಼ಬಿ ಜಾ಼ಖ್ಹತ್ ಅಛ್ಛಿನಿತರ ಬೋಲಿವತಾಳ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","ಇನಕೇಡೆಥು ಅಖಾಯನ ಜಾ಼ವ್ಣುಕರಿ ಇನ ಮನ್‍ಲಗಾಖ್ಹತರ್ ವಿಶ್ವಾಸಿ ಭಯೇಖ್ಹಾರು ಇನ ಮದತ್‍ಕರಿನ್ ಹಿಜ಼್ಜಾಥೂತೆ ವಿಶ್ವಾಸಿವ್‌ನ ಚಿಟ್ಟಿಲೀಖಿನ್ ಅಪೊಲ್ಲೋಸನ ಮಳೈಲೇವ್ಣು ಕರಿ ಬೋಲಿಲಿದು.ಯೊ ಹಿಜ್ಜಾ಼ ಜಾ಼ವಾನಿ ವಖ್ಹ್‌ತೆ ದೇವ್ನಿ ಕೃಪಾಥಿ ವಿಶ್ವಾಸ್ ಕರವಾಳನ ಏಕ್‌ ಮೋಟು ಮದತ್ ಹುಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","ಶನಕತೊ ಯೊ ಘಣಿ ಶಕ್ಕಥ್ಥಿ ಅಬ್ಬಾಜ಼ಬ್ಬಿ ಕರ್ತೊಹುಯಿನ್ ಆಖ್ಖಾನಖ್ಹಾಮ್ಣೆ ದೇಖಾವನಿತರ ಯೆಹೂದ್ಯರ್‌ನ ಧರ್ಮಶಾಸ್ತ್ರಥಿ ಯೇಸುಸ್ ಕ್ರಿಸ್ತಕರಿ ಸಬೂತ್‍ಕರೀನ್ ಇವ್ಣುನ ಹರಾಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","ಅಪೊಲ್ಲೋಸ ಕೊರಿಂಥಮ ಥೊ ತದೆ ಪೌಲನೆ ಪಹಾಡ್ ಪರ್ಬತ್ಮಕರಿ ಚಾ಼ಲ್ತೊಹುಯಿನ್‌ ಎಫೆಸಮ ಪೋಚ್ಯೊ. ಹಿಜ಼್ಜಥೋಡ ಶಿಷ್ಯರ‍್ನ ದೇಖಿನ್, ");
INSERT INTO vaa_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","“ತುಮೆ ವಿಶ್ವಾಸ್‍ಕರ‍್ಯಾತೆ ತದೆ ಪವಿತ್ರಾತ್ಮನ ಲೀಲಿದಾಕಿ ಶು”? ಕರಿ ಇವ್ಣುನ ಬೋಲಖ್ಹತರ್ ಇವ್ಣೆ ಇನ, ಕೊಯ್ನಿ ಪವಿತ್ರಾತ್ಮ ಕರಿ ಬೋಲಾನಿ ಬಾರೇಮ ಖ್ಹಮ್‌ಜಾ಼ಸ್‌ಕೊಯ್ನಿ ಕರಿ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","ಪೌಲನೆ ಇವ್ಣುನ “ತುಮೆ ಖಿವಿ ಥರಾನು ಬಾಪ್ತಿಸ್ಮ ಲೀರಾಖ್ಯಸ್? ಕರಿ ಬೋಲಖ್ಹತರ್, ಇವ್ಣೆ ಯೋಹಾನನು ಬ್ಯಾಪ್ತಿಸ್ಮ ಕರೈಲಿದ” ಕರಿ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","ಇನ ಪೌಲನೆ; ಯೋಹಾನನೆ ಪಶ್ಚಾತ್ತಾಪ್‌ ಕರೀನ್ ದೇವ್‌ಭಣಿ ಫರಿಜೈನ್ ಬ್ಯಾಪ್ತಿಸ್ಮ ಕರೈಲೀನ್. ಇನ ಪಾಛ಼ಳ್ ಆವಾಳಾನ ವಿಶ್ವಾಸ್ ಕರ್ನುಸ್ ಕರ್ನುಕರಿ ಬೋಲ್ಯೊಥೊ, ಯೊ ಯೇಸುಮಾಸ್. ");
INSERT INTO vaa_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","ಇನ ಇವ್ಣೆ ಖ್ಹಮ್‌ಜಿನ್‌ ಪ್ರಭುಹುಯಿರ‍್ಹೋತೆ ಯೇಸುನ ನಾಮ್‍ಥಿ ಬ್ಯಾಪ್ತಿಸ್ಮ ಕರೈಲಿದು. ");
INSERT INTO vaa_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","ಪೌಲನೆ ಇವ್ಣಪರ್ ಹಾತ್‍ಮ್ಹೇಲಾಮ ಪವಿತ್ರಾತ್ಮ ಇವ್ಣಪರ್ ಉತ್ರಿನ್ ಆಯೊ. ಇವ್ಣೆ ಕೈಏಕ್ ಥರಾನಿ ಬೋಲಿನಬೋಲಲಗ್ಯು, ಪ್ರವಾದ್‌ನೆಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","ಇವ್ಣೆ ಖ್ಹುಮಾರ್ ಭಾರಜ಼ಣ ಪರ್ಖ್ಹಾಥ. ");
INSERT INTO vaa_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","ಯೊ ಖ್ಹಯೇರ್‌ಮ ಪೌಲನೆ ಸಬಾಮಂದಿರ್‌ನ ಮಹಿ ಜೈ಼ನ್ ತೀನ್ ಮಹಿನಲಗು ಹಿಜ್ಜಾ಼ಸ್ ದೇವ್ನಿ ರಾಜ್ಯನಿ ವಾತೆನಿ ಬಾರೇಮ ಫೇಡ್‌ ಬೋಲ್ತೊಹುಯಿನ್ ಅದ್ಮಿಖ್ಹಾರನ ದಿಲ್ನ ಜೀತಾನ ಕೋಶಿಶ್ ಕರ‍್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","ಥೋಡುಜ಼ಣು ಇವ್ಣ ಮನ್ನ ಕಠಣ್ ಕರ‍್ಲಿನ್ ಪ್ರಭುನ ಮಾರಗ್‌ನ ಖರಾಬ್ ಕರಿ ಬೋಲ್ಯು.ಇನಖ್ಹಾಜೆ ಪೌಲನೆ ಇವ್ಣುನ ಮ್ಹೇಲಿನ್ ವಿಶ್ವಾಸಿವ್‌ನ ಇನ ಜೋ಼ಡೆ ಬುಲೈಲಿನ್ ಗಯೊ ಅಜು಼ ಇವ್ಣುನ ತುರನ್ನಕರಿ ಬೋಲೈಲ್ಯವಾಳಾನಿ ತರ್ಕಕರಾನಿ ಪಾಠಶಾಲಾಮ ಬುಲೈಲೀಜೈ಼ನ್ ಹರೇಕ್ ದನ್ ಚರ್ಚೆಕರ್ತೋಥೊ. ");
INSERT INTO vaa_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","ಅಮ್ಮಸ್ ಬೇ ವರಖ್ಹ್ ನಿಕ್ಳಿಗಯ. ಏಷ್ಯಾಮ ಜಿವ್ಣು ಕರುಕರ್ತುಥೂತೆ ಖ್ಹಾರು ಯೆಹೂದ್ಯರ್‌ಬಿ ಗ್ರೀಕ್‌ವಾಳುಬಿ, ಪ್ರಭುನಿ ಉಪದೇಶ್‍ನ ಖ್ಹಮ್‌ಜ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","ದೇವ್ನೆ ಪೌಲನ ಹಾತೇಖ್ಹು ಬೋಲಾನುಕೊಂತೆ ಎತ್ರು ಅದ್ಭುತ್‌ಖ್ಹಾರು ಕರಾವ್‍ತೊಥೊ. ");
INSERT INTO vaa_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","ಇನಖ್ಹಾಜೆ ಅದ್ಮಿಖ್ಹಾರು, ಇನ ಹಾತ್ಮನು ಚೌ಼ಕೊ ಅಜು಼ ಆಂಗ್‍ಪರ‍್ನು ಪಿಛೋ಼ಡಿಬಿ ಪಳ್ಳಿಜೈ಼ನ್‌ ರೋಗ್‌ವಾಳನ ಉಪ್ಪರ್ ನಾಖ್ಯುತೊ ಇವ್ಣು ರೋಗ್‍ಅಖ್ಖು ಪರಿಹಾರ್‌ಹುಯಿನ್ ಅಜು಼ ಭೂತ್‌ಖ್ಹಾರು ನಾಶಿ ಜ಼ವ್‍ಕರ್ತುಥು. ");
INSERT INTO vaa_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","ಭೂತ್ ನಖ್ಹಾಡವಾಳ, ಕರಿ ಬೋಲಿಲಿನ್ ಫರುಕರ್ತುಥೂತೆ ಥೋಡು ಯೆಹೂದ್ಯರ್‌ಬಿ ಪ್ರಭು ಯೇಸುನ ನಾಮ್‍ಥಿ ಭೂತ್ ಛೋ಼ಡಾವನ ಕೋಶಿಶ್ ಕರ‍್ಯು. ಅಜು಼ ಅವ್ಣೆ ಭೂತ್‌ನ, “ಪೌಲ ಬೋಲುಕರಸ್ತೆ ಯೇಸುನ ನಾಮ್‍ಥಿ ಹುಕುಮ್ ದೆವುಕರೇಸ್ ಕರಿ ಬೋಲುಕರ್ತುಥು. ");
INSERT INTO vaa_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","ಸ್ಕೇವಕರಿ ಏಕ್‌ ಯೆಹೂದ್ಯ ಗಲ್‌ಢಯಾಜಕ್‌ನ ಲಡ್ಕಾ ಹುಯಿರ‍್ಹಾತೆ ಖ್ಹಾತ್‌ಜ಼ಣ ಭೈಯೇಬಿ ಅಮ್ಮಸ್ ಕರುಕರ್ತಥ. ");
INSERT INTO vaa_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","ಕತೋಬಿ ಏಕ್‌ಹಲ್ಲ ಭೂತ್‍ನೆ ಇವ್ಣುನ, ಮನ ಯೇಸುಬಿ ಮಾಲುಮ್ ಪೌಲಬಿ ಮಾಲುಮ್ ಕತೋಬಿ ತುಮೆ ಕೋಣ್‌ಕರಿ ಫರೈನ್ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","ತದೆ ಭೂತ್ ಧರಿರಾಖ್ಯೊಥೋತೆ ಯೊ ಅದ್ಮಿನೆ ಯೆಹೂದ್ಯರ್‌ನ ಘಣು ಚ಼ಂಢಾಳ್‌ಥಿ ಇವ್ಣುನ ಖ್ಹಪ್‌ಡೈಲಿದು. ಯೊ ಯೆಹೂದ್ಯರ್‌ಥಿಬಿ ಘಣೊ ಶಕತ್‌ವಾಳೊ ಹುಯಿರುಥೂತೆ ಇನಖ್ಹಾಜೆ ಇವ್ಣುನ ಮಾರ್ ಪೀಟ್‍ಕರ‍್ಯು. ಇವ್ಣೆ ಘಾವ್ ಹುಯಿನ್ ಉಘಾಡು ಹುಯಿನ್ ಘರ್‌ಮಾಥು ನಾಶಿಚ಼ಲಿಗು. ");
INSERT INTO vaa_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","ಎಫೆಸಮ ಥೂತೆ ಯೆಹೂದ್ಯರ್ ಅಜು಼ ಯೆಹೂದ್ಯರ್‌ಕಾಹೆತೆ ಘಣುಜ಼ಣು ಖ್ಹಮ್‍ಜ್ಯುತೆ ಇವ್ಣೆ ಡರಿನ್ ಗೌರವ್ ದಿದು ಅಜು಼ ಪ್ರಭು ಯೇಸುನ ನಾಮ್ನ ಘಣು ಖ್ಹರಾಯು. ");
INSERT INTO vaa_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","ಇನ ವಿಶ್ವಾಸ್ ಕರ‍್ಯುತೆ ಕೈಯೇಕ್‌ಜ಼ಣು ಇವ್ಣೆ ಕರ‍್ಯಾಥಾತೆ ಪಾಪ್ನಕಾಮ್ನ ಬಾರೇಮ ಅದ್ಮಿವ್‌ನ ಖ್ಹಾಮ್ಣೆ ಬೋಲಿಲಿದು. ");
INSERT INTO vaa_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","ಯೋಬಿಕೊಂತೆ ಜಾ಼ದು ಮಂತರ್ ಕರವಾಳಾಮ ಕೈಯೇಕ್‌ಜ಼ಣು ಇವ್ಣ ಫಾಲ್ ಪುಸ್ತಕ್ನ ಜ಼ಮ ಕರಿಲೈನ್ ಅಖ್ಖಾನ ಖ್ಹಾಮ್ಣೆ ಬಾಳಿನಾಖ್ಯು. ಯೋ ಅಖ್ಖಾನು ಮೋಲ್ ಗಣ್ತಿ ಕರ‍್ಯುತೊ ಖ್ಹುಮಾರ್ ಅಡೈವಿಖ್ಹ್‌ ರೂಪಾನ ಪೈಶಾಯೆತ್ರು ಹುಯು. ");
INSERT INTO vaa_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","ಆ ಪರಕ್ಮ ಪ್ರಭುನಿ ವಚನ್ ಭಡ್ತುಜೈ಼ನ್ ಘಣೇಥಿ ಘಣ ಜ಼ಣಾಮ ಫೈಲಾಯು.ಯೊ ಘಣಿ ಶಕತ್ನು ಹುಯು. ");
INSERT INTO vaa_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","ಆ ಹುಯುತೆ ಇನಕೇಡೆಥು ಪೌಲ ಮೆಕೆದೋನ್ಯ ಅಜು಼ ಅಖಾಯ ದೇಖ್ಹ್‌ನಿ ವಾಟೆ ಯೆರೂಸಲೇಮ್ನ ಜಾ಼ವಾನಿ ಮನ್‌ಕರ‍್ಯೊ. ಹಿಜ್ಜಾ಼ ಮೇ ಜಾ಼ವಾನಿ ವಖ್ಹತ್‌ಮ ರೋಮ್ ನಂಗರ್‌ನಾಬಿ ಮಳ್‌ಣು” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","ಕತೋಬಿ ಇನೆ ತಿಮೊಥೆ ಅಜು಼ ಎರಸ್ತ ಕರಿ ಬೇಜ಼ಣು ಪೌಲನ ಮದತ್ ಕರಾವಾಳನ ಪೌಲನೆ ಇವ್ಣುನ ಪಹಿಲೇಸ್ ಮೆಕೆದೋನಿಯನ ಮೋಕ್ಲಿದಿದೊ.ಅಜು಼ ಯೊ ಬಿಜೂ಼ಬಿ ಥೋಡದನ್ ಏಷ್ಯಾಮಾಸ್ ರ‍್ಹೀಗಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","ಯೊ ಹಗಾಮ್ಮ ಎಫೆಸಮ ಕ್ರಿಸ್ತನಿ ಮಾರಗ್‌ನ ಮಾಲುಮ್ ಕರಾನಿ ಬಾರೇಮ ಜಾ಼ಖ್ಹತ್ ಗಲಾಟ್ ಹುಯು. ");
INSERT INTO vaa_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","ಯೋ ಕಿಮ್‌ಕತೊ ದೇಮೇತ್ರಿ ಕರಿ ಏಕ್‍ಜ಼ಣೊ ಖ್ಹೊನಾರ್‌ನೆ; ರೂಪಾಥಿ ಅರ್ತೆಮೀ ದೇವ್ತಿನಿ ಘುಢೀನಿ ಶಕಲ್ನಿ ನ್ಹಾನಿ ನ್ಹಾನಿಘುಡಿ ಕರೀನ್ ಯೋ ಕಾಮ್ ಕರಾವಾಳ ಅಖ್ಖಾನ ಘಣು ನಫ್ಫೊಕರಿ ದೆವ್‍ಕರ್ತೊಥೊ. ");
INSERT INTO vaa_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","ಇನೆ ಯೋ ಕಾಮ್‌ಕರಾವಾಳ ಅಖ್ಖಾಸ್ನ ಎಕ್ಟು ಕರಿನ್ ಇವ್ಣುನ, “ಅದ್ಮಿವೊ, ಆ ಕಾಮ್‍ಥಿ ಅಪ್ಣುನ ಕೆತ್ರುಕ್ಕಿ ನಫ್ಫೊ ಮಳುಕರಸ್, ಯೊ ತುಮೂನ ಮಾಲುಮ್‌. ");
INSERT INTO vaa_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","ಕತೋಬಿ ಹಾತೇಖ್ಹು ಕರಾನು ಮೂರತ್ ದೇವ್ ಕಾಹೆಕರಿ, ಪೌಲನೆ ಎಫೆಸಮ ಕಾಹೆತೆ ಕಮ್‍ಶಿಕಮ್ ಏಷ್ಯಾ ತಬರ್‌ಖಾನು ಘಣ ಅದ್ಮಿನ ಮನ್ನ ಖೇಚಿನ್ ಫರೈನಾಖ್ಯೊ. ಕರಿ ಬೋಲಾನು ತುಮೆ ದೇಖುಕರಸ್ ಖ್ಹಮ್‍ಜೂ಼ಬಿ ಕರಸ್. ");
INSERT INTO vaa_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","ಅನೇಥಿ ಅಪ್ಣ ಧಂದಾನ ಅಟ್ಕಣ್ ಉಷೆ ಅಜು಼ ಯೋ ಕೊಂತೆ ಅರ್ತೆಮೀ ಮಹಾದೇವಿನ ಮಂದಿರ್‌ ಮಜೂ಼ರ್ ಕೊಂತೆ ಹುಯಿಜಾಶೆ. ಇಮ್ಮಸ್ ಖ್ಹಾರು ಏಷ್ಯಾಮುಲಕ್‍ಬಿ, ಜಗತ್‍ಖ್ಹಾರು ಪೂಜ಼ಕರಾನ ಆ ದೇವಿನು ವೈಭೋಗ್ ಅಖ್ಖು ಮಟಿಜಾ಼ವನಿತರ ಛಾ಼, ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","ಇವ್ಣೆಖ್ಹಾರು ಆ ವಾತೆ ಖ್ಹಮ್‌ಜಿನ್‌ ಅದ್ಮಿವ್‌ನಿ ಝೂ಼ಂಡ್‌ ಖಿಜಾ಼ವ್ತುಹುಯಿನ್ ಎಫೆಸನು ಅರ್ತೆಮೀನಿ ದೇವಿಸ್ ಊಚಿ ಕರಿ ಚಿಕ್ರಾಣ್ ಮ್ಹೇಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","ತದೆ ಖ್ಹಯೇರ್‌ಮ ಕಿಜ಼್ಜ ಕಿಜ್ಜಾ಼ಬಿ ಫೈಲಾಯು.ಅಜು಼ ಪೌಲನಿ ಜೋ಼ಡ್ಮ ಚಾ಼ಲ್ಯಫಂಡ್‍ಥಾತೆ ಮೆಕೆದೋನಿಯನು ಗಾಯೋಸಬಿ ಅರಸ್ತಾರ್ಕಬಿ ಇವ್ಣುನ ಅದ್ಮಿಖ್ಹಾರು ಧರೀನ್ ಅಖ್ಖುಜ಼ಣು ಮಳಾನಿಝ಼ಗೋಮ ಧಕೇಲಿನ್ ಪೇಶಿಗಯು. ");
INSERT INTO vaa_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","ಅನ ಮಾಲುಮ್ ಕರ‍್ಯೊತೆ ಪೌಲನೆ ಮಹಿ ಪೇಶಿನ್ ಅದ್ಮಿಖ್ಹಾರಥಿ ವಾತೆ ಬೋಲ್ನುಕರಿ ಕರ‍್ಯೊ. ಕತೋಬಿ ವಿಶ್ವಾಸಿಖ್ಹಾರು ಇನ ಜಾ಼ವಾನ ಕೋ ಮ್ಹೆಲ್ಯುನಿ. ");
INSERT INTO vaa_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","ಅತ್ರೇಸ್ ಕಾಹೆತೆ ಏಷ್ಯಾ ಮುಲಕ್ನ ಅಧಿಕಾರಿಮ ಥೋಡುಜ಼ಣು ಪೌಲನ ದೋಸ್ತಿ ಹುಯಿರ‍್ಹುಥೂತೆ ಇನಖ್ಹಾಜೆ ಇನಾಕನ ಅದ್ಮಿನ ಮೋಕ್ಲಿನ್; ತೂ ಯೋ ನಾಟಕ್‌ನಮಾಳ್‌ಮ ನಕೊ ಜಾ಼ಕರಿ ಗಿಂಗೈಲಿದು. ");
INSERT INTO vaa_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","ಅದ್ಮಿವೋನ ಟೋಳ್ಮ ಗುಂಝ಼್‌ಲಾವ್ಣಿ ಹುಯು. ಥೋಡುಜ಼ಣು ಏಕ್‍ ಥರಾನಿ ಚಿಕ್ರಾಣ್ ಮ್ಹೇಲ್ಯುತೊ ಅಜು಼ ಥೋಡುಜ಼ಣು ಬಿಜೇಕ್‌ತರ ಚಿಕ್ರುಕರ್ತುಥು. ಹಿಜ಼್ಜಾಥೂತೆ ಘಣಾಜ಼ಣನ ಇವ್ಣೆ ಮಳಿನ್ ಐರ‍್ಹೂತೆ ಶನಖ್ಹಾಜೆ ಕರಿ ಬೋಲಾನು ಮಾಲುಮ್‌ ಕೊ ಥೂನಿ. ");
INSERT INTO vaa_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","ಯೆಹೂದ್ಯರ್ ಅಲೆಕ್ಸಾಂಡರ‍್ನ ಖ್ಹಾಮ್ಣೆ ಧಕೇಲಿನ್ ಝೂ಼ಂಡ್‌ಮ ಥೋಡುಜ಼ಣು ಇನ ಇಷಾರ್ಕೊ ಕರ‍್ಯು. ತದೆ ಅಲೆಕ್ಸಾಂಡರ‍್ನೆ ಇನಭಣಿಥು ಹಾತ್‌ನೊ ಝಾ಼ಲೊದೀನ್ ಭರೈರ‍್ಹುತೆ ಅದ್ಮಿಖ್ಹಾರಾನ ಶಾಂತಿಥಿ ರ‍್ಹವಾನ ಬೋಲ್ತೊ ಹುಯಿನ್ ಜ಼ವಾಬ್ ದೇವ್ಣುಕರಿ ಥೊ. ");
INSERT INTO vaa_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","ಕತೋಬಿ ಯೋ ಯೆಹೂದ್ಯರ್‌ನೊ ಕರಿ ಮಾಲುಮ್ ಕರಖ್ಹತರ್ ಇವ್ಣೆಖ್ಹಾರು ಎಕ್ಕಸ್ ದಮ್‍ಪರ್; ಎಫೆಸವಾಳಾನಿ ಅರ್ತೆಮೀ ದೇವಿಸ್ ಮಹಾದೇವಿ, ಕರಿ ಕೂಘಾಟಿ ಮ್ಹೇಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","ಖ್ಹರ್ತಿಮ ಖ್ಹಯೇರ‍್ನ ಯಜಮಾನ್ನೆ ಅದ್ಮಿನಝೂ಼ಂಡ್‌ನ ಸಮಾಧಾನ್ ಕರೀನ್ ಇವ್ಣುನ “ಎಫೆಸನು ಅದ್ಮಿವೊ ಆಕಾಶ್‍ಥು ಪಡ್ಯುತೆ ಅರ್ತೆಮೀ ಮಹಾದೇವಿನ ಮಂದಿರ‍್ನ ಅಜು಼ ಇನಿ ಮೂರತ್ನ ಜ಼ತನ್ ಕರುಕರಸ್ತೆ ಎಫೆಸ ನಂಗರಸ್ ಕರಿ ಹಿಡಿ ಜಗತ್‍ನಾಸ್ ಮಾಲುಮ್ ಛಾ಼ನಿ? ");
INSERT INTO vaa_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","ಆ ಸಮಾಚಾರ್ ಖ್ಹಾಚು಼ಕರಿ ಕೋಣ್ ಬೋಲಾನ ಕೊ ಹುವಾನಿ ಇನಖ್ಹಾಜೆ ಸಮಾಧಾನ್‌ಥಿ ಶೊಪೊರ‍್ಹೇವೊ ಅಜು಼ ದುಡ್ಕಿನ್ ಶಾತ್ಬಿ ನಾ ಕರ‍್ನು. ");
INSERT INTO vaa_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","ತುಮೆ ಧರೀನ್ ಲೈರಾಖ್ಯತೆ ಆ ಅದ್ಮಿಖ್ಹಾರು ದೇವ್ನಿಮಂದಿರ್‌ನ ಚೋ಼ರ್ ಕರವಾಳು ಕಾಹೆ, ಅಪ್ಣ ದೇವಿನ ದೂಷಣೆ ಕರಾವಾಳುಬಿ ಕಾಹೆ. ");
INSERT INTO vaa_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","ಇನಖ್ಹಾಜೇಥಿ ದೇಮೇತ್ರಿಯನಾಬಿ ಇನಾಭಣಿ ರ‍್ಹಾವವಾಳಾನ ಕಿನಾಪರ್ತೋಬಿ ಗಲತ್‌ ಲಗಾಡನು ಉಷೇತೊ ನಯ್ಯೊಬಿ ಛಾ಼ ಅಜು಼ ಮೋಟು ನ್ಯಾವ್‍ನಿ ಝ಼ಗೊಬಿ ಛಾ಼ ಹಿಜ್ಜಾ಼ ಫೆಡೈಲ್ಯಾವದೆ. ");
INSERT INTO vaa_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","ಶಾತ್ತೋಬಿ ಘಣು ಪೂಚ್‍ತಾಚ಼್ ಕರ್ನುಕತೊ ಯೊ ನ್ಯಾವ್‌ಥಿ ಭರಿಸಬೆಮ ತೀರ್ಮಾನ್ ಹೋಣುಪಡ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","ಆ ದನ್ನೆ ಚಾ಼ಲ್ಯುತೆ ಸಮಾಚಾರ‍್ನ ಎಕ್ಟುಹುಯಿರ‍್ಹಾತೆ ತುಮೂನ ಮೆ ಶನ ಬೋಲುಕರುಸ್‍ಕತೊ ಹಮ್ಕೇನು ಝ಼ಗ್‍ಡಾನ ದೇಖ್ಯಾತೆ ಥೋಡು ಅದ್ಮಿಖ್ಹಾರು ಹಮೆ ಝ಼ಗ್‍ಡೊ ಉಠಾಡಿರಾಖ್ಯಸ್ ಕರಿ ಗಲತ್‌ ಲಗಾಡನಿತರ ಥೂ. ಆ ಗಲಾಟ್‌ನ ಬಾರೇಮ ಬೋಲ್ಯುತೊ ಹಮೆ ಝ಼ಗ್ಡಾನ ಮಾನಿಲ್ಯವಾನ ಕೋ ಹುವಾನಿ ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","ತದೆ ಖ್ಹಯೇರ‍್ನೊ ಅದಿಕಾರಿ ಆ ಖ್ಹಾರಿವಾತೆನಿ ಬೋಧನೆ ಹುಯಿಜಾ಼ವದಿನ್ ಘರೆ ಜಾ಼ವೊಕರಿ ಖ್ಹಮ್‍ಜಾ಼ಡ್ತೊ ಹುಯಿನ್ ಸಬೆನ ಖತಮ್ ಕರ‍್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","ಗಲಾಟ್ ಭೀರ‍್ಯಾವನ ಬಾದ್ಮ ಪೌಲನೆ ಯೇಸುನ ವಿಶ್ವಾಸಿವ್‌ನ ಏಕ್‌ ಬಾಜು಼ ಬುಲೈಮಂಗೈನ್‌ ಇವ್ಣುನ ಭಾಲಿದೀನ್ ಜೈ಼ನ್ ಆವುಸ್ ಕರಿ ಹಿಜ್ಜಾ಼ಥೊ ಮೆಕೆದೋನಿಯನ ನಿಕ್ಳಿಗಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","ಯೋ ತಬರ್‌ಖಾಮ ಚಾ಼ಲ್‍ಕುಚ಼್ ಕರ್ತೊಹುಯಿನ್ ಹಿಜ್ಜಾ಼ವಾಳನ ಕೈಏಕ್ ವಾತೇಥಿ ಭಾಲಿ ದೇತೊಹುಯಿನ್ ಗ್ರೀಸ್‌ ದೇಖ್ಹ್‌ನ ಗಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","ಹಿಜ್ಜಾ಼ ತೀನ್ ಮಹಿನ ಕಾಡಾನ ಬಾದ್ಮ ಸಿರಿಯ ದೇಖ್ಹ್‌ನ ದರ‍್ಯಾವ್‍ನ ಮಾರ್ಗೆ ಜಾ಼ವ್ಣುಕರಿ ರ‍್ಹವಾನಿ ವಖ್ಹತ್‌ಮ, ಥೋಡ ಯೆಹೂದ್ಯವಾಳನೆ ಪೌಲನಿ ವಿರೋದ್ ಗಪ್ಲಥ್ಥಿ ಖರಾಬ್ ಕಾಮ್ ಕರ‍್ಯುತೆ ಮಾಲುಮ್‍ಹುಯಿನ್ ಯೋ ಪಾಛೊ಼ ಫರೀನ್ ಮೆಕೆದೋನಿಯಾಥೊ ಸಿರಿಯನ ಜಾ಼ವ್ಣುಕರಿ ಖ್ಹಯಾಲ್ ಕರಿಲಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","ತದೆ ಇನಿ ಜೋ಼ಡೆ ಬೆರೋಯಖ್ಹಯೇರ‍್ನೊ ಪುರ‍್ರನೊ ಛಿಯ್ಯೊ ಸೋಪತ್ರಾಬಿ, ಥೆಸಲೋನಿಕ ಖ್ಹಯೇರ‍್ನೊ ಅರಿಸ್ತಾರ್ಕ, ಅಜು಼ ಸೆಕುಂದ, ದರ್ಬೆ ಖ್ಹಯೇರ‍್ನೊ ಗಾಯ ಅಜು಼ ತಿಮೊಥೆ, ಯೋ ಕಾಹೆತೆ ಏಷ್ಯಾನ ತಬರ್‌ಖಾಮ ತುಖಿಕಬಿ, ತ್ರೊಫಿಮಾಬಿ, ಏಷ್ಯಾ ತಬರ್‌ಖಲಗೂಬಿ ಇನ ಜೋ಼ಡೆಗಯು. ");
INSERT INTO vaa_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","ಇವ್ಣೆ ಹಮಾರೇಥಿ ಅಗಾಡಿಸ್ ಜೈ಼ನ್, ಹಮಾರಖ್ಹಾಜೆ ತ್ರೋವ ಖ್ಹಯೇರ್‌ಮ ಟಿವೈರ‍್ಹಾಥ. ");
INSERT INTO vaa_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","ಯೆಹೂದ್ಯರ‍್ನು ಫುಗಕೊಂತೆ ರೋಟಾನಿ ಪೂಜ಼ ಹುವಾದಿನ್ ಹಮೆ ಫಿಲಿಪ್ಪಿ ಖ್ಹಯೇರ‍್ನಿ ಜ಼ಹಾಜ಼್ ಛ಼ಡಿನ್, ಪಾಚ಼್ ರೋಜ್‍಼ಕೇಡೆ ತ್ರೋವಮ ಇವ್ಣುನ ಮಳ್ಯ. ಹಿಜ್ಜಾ಼ ಖ್ಹಾ಼ತ್‍ದನ್‌ಲಗು ಥಾ. ");
INSERT INTO vaa_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","ವಾರಾನೊ ಸಬ್ಬತ್‌ನ ದನ್ನೆ ಹಮೆಖ್ಹಾರು ಪ್ರಭುನು ರಾತ್ನುಭೋಜನ್‍ನ ಖ್ಹಾಜೇಥಿ ಎಕ್ಟು ಹುಯಿನ್ ಆಯ. ತದೆ ಸಭೆ ಭರಾಯುತೆ ಅದ್ಮಿಖ್ಹಾರಾನಿ ಜೋ಼ಡೆ ವಾತೆ ಬೋಲಿನ್ ಇನವ್ಹಾಣೆ ಹಿಜ್ಜಾ಼ಥೊ ಜಾ಼ವ್ಣುಕರಿ ಪೌಲ ಖ್ಹಯಾಲ್‍ಕರ‍್ಯೊ. ಇನಖ್ಹಾಜೆ ಅಧಿರಾತ್‍ಲಗೂಬಿ ವಾತ್ ಬೋಲುಸ್ ಕರ್ತೊಥೊ. ");
INSERT INTO vaa_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","ಹಮೆಖ್ಹಾರು ಬೇಠಥಾತೆ ಘರ್‌ನ ಉಪ್ಲಿಬಾಜು಼ನ ಕೋಣಾಮ ಕೈಯೇಕ್ ದಿವೋ ಲಾಗುಕರ್ತುಥು. ");
INSERT INTO vaa_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","ಯೂತಿಖ ಕರಿ ಏಕ್‍ಜ಼ಣೊ ಜ಼ವಾನಿ ಛೋ಼ಕ್ರು ಕಿಟಕಿಕನ ಬೇಶಿನ್ ಭರ್ ನಿಂದರ್‌ಮ ಝು಼ಕಾರ‍್ಯ ಮಾರುಕರ್ತೊಥೊ. ಪೌಲ ಬಿಜೂ಼ಬಿ ಬೋಧನೆ ಕರುಕರಾನಿ ವಖ್ಹತ್‌ಮ ಯೊ ಜ಼ವಾನಿ ನಿಂದರ್‌ಥಿ ಘಣಿ ಝು಼ಕಾರ‍್ಯ ಮಾರಿನ್ ತೀನ್ನಿ ಮಹಡಿಪರ್ಥೊ ಹೇಟ್ ರಡ್ಕಿಗೊ; ಇನ ಉಠಾಡನ ಗಯುತೆ ತದೆ ಯೋ ಮರಿರ‍್ಹೋಥೊ. ");
INSERT INTO vaa_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","ಕತೋಬಿ ಪೌಲನೆ ಉತ್ರಿಜೈ಼ನ್,ಇನ ಪಾಡಿನ್ ಬಥೈನ್; ವೇಚ಼್‌ಣೆ ನಕೊಕರೊ, ಯೋ ಜಿವ್ತೊ ಛಾ಼ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","ಪೌಲ ಪಾಛೊ಼ ಉಪ್ಪರ್ ಜೈ಼ನ್ ರೋಟಾನ ತೋಡಿ ಖೈನ್ ಘಣಿ ವಖ್ಹತ್‌ಲಗು ವಾತೆ ಬೋಲ್ಯೊ. ಎತ್ರಾಮ ವ್ಹಾಣುಹುಯು ತದೆ ಪೌಲ ಚ಼ಲೆಗಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","ಇವ್ಣೆ, ಜಿವ್ತೊಹುಯೂತೆ ಯೋ ಜ಼ವಾನಿ ಛೋ಼ಕ್ರಾನ ಬುಲೈಲಿನ್ ಜಾ಼ವನಿವಖ್ಹ್‌ತೆ ಇವ್ಣುನ ಘಣು ಸಮಾಧಾನ್ ಹುಯು. ");
INSERT INTO vaa_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","ಹಮೆ ಅಗಾಡಿಸ್ ಜ಼ಹಾಜ಼್‍ಮ ಅಸ್ಸೊಸಿಕರಿ ಖ್ಹಯೇರ‍್ನ ಗಯ. ಹಮೆ ಪೌಲಾನ ಜೋ಼ಡ್ಮ ಜ಼ಹಾಜ಼್‌ಪರ್ ಜಾಶುಕರಿ ಥಾ. ಇನೇಸ್‌ ಗೋಡಾನಿ ವಾಟೇಥಿ ಚಾ಼ಲಿನ್ ಹಿಜ್ಜಾ಼ಥೊ ಒಳೆಜಾ಼ತೊಥೊ. ");
INSERT INTO vaa_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","ಇಮ್ಮಸ್ ಹಮೆ ಆವಾನಿ ವಖ್ಹ್‌ತೆ ಪೌಲ ಅಸ್ಸೊಸಿ ಖ್ಹಯೇರ್‌ಮ ಹಮೂನ ಮಳ್ಯೊ. ಹಿಜ್ಜಾ಼ಥೊ ಹಮೆಖ್ಹಾರು ಜ಼ಹಾಜ಼್‌ಪರ್ ಮಳಿನ್ ಮಿತಿಲೇನ ಖ್ಹಯೇರ‍್ನ ಗಯ. ");
INSERT INTO vaa_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","ಇನ ಅಗ್‍ಲ್ಯದನ್ನೆ ಹಮೆ ಹಿಜ್ಜಾ಼ಥ ಜ಼ಹಾಜ಼್‌ಪರ್ ಖಿಯೋಸ್ ಟಾಪನ ಖ್ಹಾಮ್ಣೆಥೂತೆ ಏಕ್‌ ಝ಼ಗೊಕನ ಆಯ, ಇನ ಅಗ್‍ಲ್ಯದನ್ನೆ ಸಾಮೋಸ್ ಟಾಪನ ಕಾಡಿನ್ ಇನ ಅಗ್‍ಲ್ಯದನ್ನೆ ಮಿಲೇತ ಖ್ಹಯೇರ‍್ನ ಜೈ಼ನ್ ಪೋಚ್ಯ. ");
INSERT INTO vaa_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","ಪೌಲನೆ ಪಂಚಶತ್ತಮ ಪೂಜಾ಼ನ ದನ್ನ ಯೆರೂಸಲೇಮ್ಮ ರ‍್ಹೇವ್ಣುಕರಿ ಉತ್ವಾಳಿ ಕರುಕರ್ತೊಥೋತೆ ಇನಖ್ಹಾಜೆ ಏಷ್ಯಾ ತಬರ್‌ಖಾಮ ದನ್ ಕಾಡನ ಇಷ್ಟಕೊಂತೆ ಎಫೆಸ ಖ್ಹಯೇರ‍್ನ ಮ್ಹೇಲಿನ್‌ ಜಾ಼ವಾನ ಖ್ಹೂಜ಼್‌ಕರ‍್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","ಪೌಲನೆ ಮಿಲೇತಥೊ ಎಫೆಸ ಖ್ಹಯೇರ‍್ನ ಸಬೆನ ಗಲ್‌ಢವ್‍ಖ್ಹಾರಾನ ಏಕ್‌ ಸಂದೇಶ್ ಬೋಲಿಮೋಕ್ಲಿನ್ ಇವ್ಣುನ ಬುಲೈಮಂಗಾಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","ಯೋ ಗಲ್‌ಢಖ್ಹಾರಾನ, ಪೌಲನೆ, “ಮೇ ಏಷ್ಯಾ ತಬರ್‌ಖಾಮ ಐನ್ ಗೋಡೊಮ್ಹೇಲ್ಯೊ ತಪ್‌ಥೂಬಿ ತುಮಾರ ಇಚ಼್‌ಮ ಅಖ್ಖಿ ವೇಳ್‌ಮಾಬಿ ಕಿಮ್ ಚಾ಼ಲಿಲಿದೊ ಕರಿ ತುಮುನಾಸ್ ಮಾಲುಮ್. ");
INSERT INTO vaa_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","ಯೆಹೂದ್ಯರ್ ಖ್ಹಾರಾನಿ ಮಶ್ಲಥ್ಥಿ ಮೆ ಘಣು ಖ್ಹತಾನು ಪಡ್ಯುಥು. ಕೈಏಕ್ ವಖ್ಹತ್ ಆಂಝು಼ ನಾಕ್ಣುಪಡ್ಯು. ಕತೋಬಿ ಮೇ ಖ್ಹಮಾಳಿನ್ ಕದೇಬಿ ಪ್ರಭುನು ಸೇವೆ ಕರ‍್ಯೊಕರಿ ತುಮೂನ ಮಾಲುಮ್. ");
INSERT INTO vaa_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","ಮೇ ತುಮೂನ ಖ್ಹಾರಾನ ಖ್ಹಾಮ್ಣೆಬಿ ಅಜು಼ ತುಮೂನ ಘರೂಮಾಬಿ ಐನ್ ತುಮುನ ಮದತ್ ಹುವಾನು ಶಿಕಾಡನಾಬಿ ಪೀಛೆ ಹಟ್ಯೊಕೊಯ್ನಿ, ಯೊ ತುಮೂನ ಮಾಲುಮಸ್ ಛಾ಼. ");
INSERT INTO vaa_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","ಯೆಹೂದ್ಯರ್‌ನ ಅಜು಼ ಗ್ರೀಕ್‍ವಾಳು ಪಾಪ್ನ ಮ್ಹೇಲಿನ್ ದೇವ್‌ಭಣಿ ಫರಿಜಾ಼ವ್ಣು ಅಜು಼ ಪ್ರಭು ಯೇಸುನ ನಾಮ್‌ಪರ್‌ ವಿಶ್ವಾಸ್ ರಾಕ್ಣುಕರಿ ಮೇ ಬೋಲಿರಾಖ್ಯೊಸ್. ");
INSERT INTO vaa_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","ಅಜು಼ ಹಮ್ಕೆ ಮೇ ಪವಿತ್ರಾತ್ಮನ ಖ್ಹಾಮ್ಣೆ ಮುಡ್‌ಕ್ಯು ಝು಼ಕೈನ್‌, ಯೆರೂಸಲೇಮ್ನ ವಳೆಜ಼ವುಸ್‌. ಹಿಜ್ಜಾ಼ಮನ ಶಾತ್ ಉಶೇಕಿ ಮಾಲುಮ್‌ಕೊಯ್ನಿ. ");
INSERT INTO vaa_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","ತುನ ಬೇಡಿಬಿ ಖ್ಹತಾಪ್ಣಿಖ್ಹಾರು ಮಾರಖ್ಹಾಜೆ ಟಿವೈರ‍್ಹೂಸ್‍ಕರಿ ಪವಿತ್ರಾತ್ಮನೆ ಝೇತೈನ್‌ ಹರೇಕ್ ಖ್ಹಯೇರ್‌ಮಾಬಿ ಮನ ಬೋಲುಕರಸ್ತೆ, ಮಾಲುಮ್ ಪಡುಕರಸ್. ");
INSERT INTO vaa_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","ಮೇ ಮಾರ ಶೊಂತ್ ಜಾನ್ನಿ ಬಾರೇಮ ಸೋಚುಕೊಯ್ನಿ. ಪ್ರಭು ಹುಯಿರ‍್ಹೋತೆ ಯೇಸುನೆ ಮನ ದೀರಾಖ್ಯೋತೆ ಕಾಮ್ನ ಪೂರ ಕರಾನುಸ್ ಮನ ಖ್ಹಾರೇಥಿ ಮುಖ್ಯ. ಯೊ ದೇವ್ನು ವಾರ್‌ಖ್ಹಾನಿ ಬಾರೇಮಾನಿ ಸುವಾರ್ತೆನ ಸಾಕ್ಷಿನು ಕಾಮ್ ಹುಯಿರ‍್ಹೂಸ್. ");
INSERT INTO vaa_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","ದೇಖೊ ತುಮಾರಿ ಜೋ಼ಡೆಥೂತೆ ಖ್ಹಾರಿ ವಖ್ಹತ್‌ಮ ದೇವ್ನಿ ರಾಜ್ಯನಿ ಬಾರೇಮಾನಿ ಸುವಾರ್ತೆನ ಮೆ ತುಮೂನ ಬೋಲಿ ಖ್ಹಮ್‌ಜಾ಼ಡ್ಯೊ. ಹಮ್ಕೆ ತುಮಾರಮ ಏಕ್‍ಜ಼ಣೂಬಿ ಮಾರ ಮ್ಹೋಡಾನ ಬಿಜು಼ ಕದೇಬಿ ದೇಕ್‌ಶು ಕೊಯ್ನಿಕರಿ ಮನಮಾಲುಮ್‌. ");
INSERT INTO vaa_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","ಇನಖ್ಹಾಜೆ ಹಮ್ಕೆ ಮೆ ತುಮೂನ ಖ್ಹಾಚ಼ಮಾಬಿ ಬೋಲಾನಿ ಏಕ್‌ ವಾತೆ ಶಾತ್‍ಕತೊ; ತುಮಾರಮ ಕೋಣ್‌ತೋಬಿ ನಾಶ್‌ಹುಯುತೊ ಇನ ಮೇ ಜಿಮ್ಮೆದಾರಿ ಕಾಹೆ. ");
INSERT INTO vaa_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","ಶನಕತೊ ಏಕ್‌ಬಿ ಲಪಾಡ್ಯೊಕೊಂತೆ ದೇವ್ನಿ ಖ್ಹೂಜ಼್‌ನ ತುಮೆ ಖ್ಹಮ್‌ಜಿಲೇವ್ಣುತೆ ಪರಕ್ಮ ಹರೇಕ್ ವಾತೆನಾಬಿ ಮೇ ತುಮೂನ ಖ್ಹಮ್‌ಜಾ಼ಡ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","ಇನಖ್ಹಾಜೆ ತುಮಾರಿ ಬಾರೇಮಾಬಿ ಪವಿತ್ರಾತ್ಮನೆ, ತುಮೂನ ದೆಖಾವಾನ ದೀರಾಖ್ಯೋತೆ ಮೇಂಢಾನಿ ಮಂಧಾನಿ ಬಾರೇಮಾಬಿ ಹೊಷಾರ್‌ಥಿ ರ‍್ಹವೊ. ಅಜು಼ ಸಬೆನ ತುಮೆ ಕುರುಬಹುಯಿರ‍್ಹಾಸ್. ಶನಕತೊ ದೇವ್ ಇನ ಛಿಯ್ಯಾನ ಲ್ಹೋಯಿಥಿ ಮೋಲ್ ಲೀರಾಖ್ಯೊಸ್. ");
INSERT INTO vaa_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","ಮೇ ಚ಼ಲ್ಯೊಜಾ಼ವದೀನ್ ಖರಾಬ್ ಜ಼ರಕ್‌ಖ್ಹಾರು ತುಮಾರಕನ ಆವ್‍ಶೆಕರಿ ಮನ ಮಾಲುಮ್. ಯೊ ಮಂಧಾನ ಗೋರ್‌ ಕರ್ಶೆಕೊಯ್ನಿ. ");
INSERT INTO vaa_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","ಆ ನಾಹುಯಿನ್ ತುಮಾರಿ ಸಬೆಮಾಸ್ ಥೋಡುಜ಼ಣು ದುರ್ಬೊಧನೆ ಕರವಾಳು ಹುಯಿನ್ ಯೇಸುನ ವಿಶ್ವಾಸಿವ್‌ ಥೋಡಜ಼ಣಾನ ಖ್ಹಾಜೇಥಿ ದೂರ್ ಚ಼ಲಾವ್‌ಷೆ. ");
INSERT INTO vaa_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","ಇನಖ್ಹಾಜೆ ಡೋಳಾನು ಆಂಝು಼ ನಾಕ್ತೊ ಹುಯಿನ್ ಮೇ ತೀನ್ ವರಖ್ಹ್ ದನ್ ತುಮಾರಿ ಜೋ಼ಡೆರ‍್ಹೀನ್ ಮೇ ತುಮೂನ ರ‍್ಹೇಣ್‍ದನ್ ಶಿಕಾಡ್ತೊಹುಯಿನ್ ತುಮೂನ ಹೊಷಾರ್ ಕರ‍್ಯೊತೆ ಯಾದ್ಮ ರಾಖೊ. ");
INSERT INTO vaa_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","“ಮೇ ಹಮ್ಕೆ ತುಮೂನ ದೇವ್‍ನಾಬಿ ಇನ ವಾರ್‌ಖ್ಹಾನಿ ವಚನ್ನಾಬಿ ದೆವುಕರೂಸ್. ಯೊ ತುಮಾರಮ ಭಕ್ತಿನ ಭಡಾವನಾಬಿ, ಪರಿಶುದ್‌ಥಿ ತುಮೂನ ಹಕ್ನ ದ್ಯವಾನಾಬಿ ಶಕತ್‌ವಾಳೊ ಹುಯಿರೋಸ್. ");
INSERT INTO vaa_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","ಮೇ ತುಮಾರಿ ಜೋ಼ಡೆ ರ‍್ಹವಾನಿ ವಖ್ಹತ್, ಖ್ಹೊನ್ನು, ರೂಪು, ಲುಂಗ್ಡಾವ್‍ನ ದೇಖಿ ಹರಖ್ಹ್‌ಯೊ ಕೊಯ್ನಿ. ");
INSERT INTO vaa_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","ಮೇ ಮಾರ ಶೊಂತ್ ಹಾತೇಖ್ಹು ಕಮಾವ್‍ತೋಥೊ. ಕದೇಬಿ ಮಾರಖ್ಹಾಜೆ ರ‍್ಹವೊ, ಮಾರಿಜೋ಼ಡೆ ರ‍್ಹವಳಾನಖ್ಹಾಜೆ ಹೋಣುತೆ ಜ಼ರೂರತ್ನ ಪೂರಕರ್ತೋಥೊ. ");
INSERT INTO vaa_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","ಅಖ್ಖೀಸ್ ಬಾರೇಮ ಮೇಸ್ ತುಮೂನ ಚಾ಼ಲಿನ್ ವತಾಳಿರಾಖ್ಯೊಸ್. ತುಮೇಬಿ ಇಮ್ಮಸ್ ಮ್ಹಿನತ್‌ಕರಿನ್ ತಾಖತ್‌ಕೊಂತೆ ಇವ್ಣುನ ಮದತ್ ಕರ‍್ನು ಅಜು಼ ಲ್ಯಾವಥೀಬಿ ದೇವಾಮ ಘಣು ವಾರ್‌ಖ್ಹೊ ಛಾ಼ಕರಿ ಪ್ರಭು ಹುಯಿರ‍್ಹೋತೆ ಯೇಸುನಿ ವಾತೆನ ಅಪ್ಣೆ ಖ್ಹಯಾಲ್ಮ ರಾಖೊಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","ಆವಾತೆಖ್ಹಾರಿ ಯೊ ಬೋಲಿ ಹುಯಿಜಾ಼ವಾದಿನ್ ಇವ್ಣಖ್ಹಾರಾನಿ ಜೋ಼ಡ್ಮ ಢುಕ್‍ಣ್ಯಮೇಟೆ ಹುಯಿನ್ ಪ್ರಾರ್ಥನೆಕರ‍್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","ಇನಕೇಡೆಥು ಪೌಲನೆ, ತುಮೆ ಮಾರ ಮ್ಹೋಡಾನ ಅಜು಼ ಕದೇಬಿ ದೇಕ್‌ಶುಕೊಯ್ನಿ ಕರಿ ಬೋಲಖ್ಹತರ್ ಇವ್ಣೆಖ್ಹಾರು ರೊಯಿನ್ ಆಂಝು಼ನಾಖ್ಯು ಅಜು಼ ಇನ ಬಥಾಯು ಅಜು಼ ಬುಚ್ಚಾ಼ದೀನ್ ಜೈ಼ನ್‌ಆಯೇಸ್ ಕರಿ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","ಇನೆ ಮಾರ ಮ್ಹೋಡಾನ ಬಿಜು಼ಪಾಛು಼ ದೇಕ್‌ಶು ಕೊಯ್ನಿಕರಿ ಬೋಲ್ಯೊತೆ ವಾತೆನ ಇವ್ಣೆ ಘಣು ದುಖ್‌ಪಡ್ಯು ಅಜು಼ ಇನ ಜ಼ಹಾಜ಼್‌ಲಗು ಜೈ಼ನ್ ಮ್ಹೇಲಿನ್ ಆಯು. ");
INSERT INTO vaa_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","ಹಮೆ ಇವ್ಣುನ ಮೋಕ್ಲಿನ್ ಇನಪಾರ್ ಜ಼ಹಾಜ಼್‌ಪರ್ ಛ಼ಡಿನ್ ಕೋಸ್ ಟಾಪಾಮ ಆಯ. ಪಾಛ಼್‌ಲ್ಯದನ್ನೆ ರೋದ ಟಾಪನ ಜೈ಼ನ್ ಹಿಜ್ಜಾ಼ಥ ಪತರ ಖ್ಹಯೇರ‍್ನ ಆಯ. ");
INSERT INTO vaa_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","ಹಿಜ್ಜಾ಼ ಫೊಯಿನಿಕೆ ಜಾ಼ವಾನಿ ಜ಼ಹಾಜ಼್‌ನ ದೇಖಿ ಇನಾಪರ್ ಚ಼ಢೀನ್ ಗಯ. ");
INSERT INTO vaa_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","ಖ್ಹಾಮ್ಣೆ ಕುಪ್ರ ಟಾಪು ದೆಖಾಯು. ಇನ ಡಾವಿಬಾಜು಼ ಮ್ಹೆಂದಿನ್ ಸಿರಿಯ ದೇಖ್ಹ್‌ ಭಣಿಕರಿ ಚಾ಼ಲ್ತಹುಯಿನ್ ತೂರ್ ಖ್ಹಯೇರ‍್ನ ಐನ್ ಉತ್‍ರ‍್ಯ. ಶನಕತೊ ಹಿಜ್ಜಾ಼ ಜ಼ಹಾಜ಼್‌ನು ಜಿನಖ್ಹ್‌ ಅಖ್ಖು ಉತಾರ‍್ನು ಥೂ. ");
INSERT INTO vaa_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","ಹಿಜ್ಜಾ಼ ವಿಶ್ವಾಸಿಖ್ಹಾರನ ಢೂಂಡಿಕಾಡಿನ್ ಖ್ಹಾತ್‍ದನ್ ರ‍್ಹಿಯ. ಇವ್ಣೆ ಪವಿತ್ರಾತ್ಮನಿ ಖ್ಹಯಾಲ್‌ಥಿ ಪೌಲನ, “ತೂ ಯೆರೂಸಲೇಮ್ಮ ಗೋಡೊ ನಕೊ ಮ್ಹೇಲಿಶ್” ಕರಿ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","ಕತೋಬಿ ಹಮಾರಿ ಭೇಟಿ ಖ್ಹತಮ್ ಕರೀನ್, ಹಿಜ್ಜಾ಼ಥ ನಿಕ್ಳಾನಿ ವಖ್ಹತ್‌ಮ ಯೊ ವಿಶ್ವಾಸಿ ಖ್ಹಾರು ಖ್ಹಯೇರ‍್ನ ಭಾರ್‌ಲಗು ಐನ್ ಇವ್ಣ ಬಾವಣ್‍ ಲಡ್ಕಾವ್‌ನಿ ಜೋ಼ಡ್ಮ ಮ್ಹೇಲಾನ ಆಯು.ಅಜು಼ ಹಮೆಖ್ಹಾರು ದರ‍್ಯಾವ್‍ನಿ ಕನಾರೆ ಢುಕ್‍ಣ್ಯಮೇಟೆ ಹುಯಿನ್ ಪ್ರಾರ್ಥನೆ ಕರೀನ್, ");
INSERT INTO vaa_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","ಬಾದ್ಮ ಹಮೆ ಏಕ್‌ಥಿ ಏಕ್‌ ಖ್ಹರ್ತಿನಿ ಖ್ಹಲಾಮ್ ಕರೀನ್ ಜ಼ಹಾಜ಼್ ಚ಼ಢೀನ್ ಇವ್ಣೆ ಪಾಛು಼ಫರಿ ಇವ್ಣ ಘರೆಗಯು. ");
INSERT INTO vaa_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","ಹಮೆ ತೂರ್ ಖ್ಹಯೇರ್‌ಥಿ ನಿಕ್ಳಿನ್ ಪ್ತೊಲೆಮಾಯ ಖ್ಹಯೇರ‍್ನ ಜೈ಼ನ್ ದರ‍್ಯಾವ್‍ನಿ ಚಾ಼ಲ್ ಖ್ಹತಮ್ ಕರ‍್ಯಾ. ಹಿಜ಼್ಜಾಥೂತೆ ವಿಶ್ವಾಸಿಖ್ಹಾರನ ಖ್ಹಲಾಮ್ ಕರೀನ್, ಇವ್ಣಿ ಜೋ಼ಡೆ ಏಕ್‍ರೋಜ಼್ ರ‍್ಹೀನ್, ");
INSERT INTO vaa_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","ಇನವ್ಹಾಣೆ ನಿಕ್ಳಿ ಕೈಸರೈನು ಖ್ಹಯೇರ‍್ನ ಆಯ. ಹಿಜ್ಜಾ಼ ಹಮೆ ಫಿಲಿಪ್ಪನ ಘರ್‌ಮ ರ‍್ಹಯ. ಸುವಾರ್ತೆ ಖ್ಹಮ್‍ಜಾ಼ಡನೂಸ್ ಫಿಲಿಪ್ಪನು ಕಾಮ್ ಹುಯಿರ‍್ಹುಥು. ಹೈರೋತೆ ಸೆಜರೇಯಮ ಮದತ್ ಕರಾವಾಳ ಖ್ಹಾತ್‍ಜ಼ಣಾಮ ಆಬಿ ಏಕ್‍ಜ಼ಣೊ ಹುಯಿರೋಥೊ. ");
INSERT INTO vaa_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","ಇನ ಚಾರ್‌ಜ಼ಣಿ ಕವಾರಿ ಛೋ಼ರಿಯೇಥಿ. ಇವ್ಣೆ ಖ್ಹಾರಿಜ಼ಣಿ ದೇವ್ನ ವಾತೇನ ಪ್ರವಾದ್‌ನೆ ಕರಾವಳಿಯೆ ಹುಯಿರ‍್ಹಿಥಿ. ");
INSERT INTO vaa_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","ಹಮೆ ಹಿಜ್ಜಾ಼ ಥೋಡದನ್ ರ‍್ಹವಾನವಾರ್ ಅಗಬ ಕರಿ ಏಕ್‌ ಪ್ರವಾದಿ, ಯೂದಾಯಥೊ ಮಾರಕನ ಆಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","ಯೊ ಹಮಾರಕನ ಐನ್ ಪೌಲನು ಕಂಬರ್‌ನು ಕಷ್‍ಬಂದ್‍ನ ಪಾಡಿನ್ ಇನ ಹಾತ್‌ಗೋಡಕೇಡೆ ಭಾಂಧಿಲೀನ್; ಆ ಕಷ್‌ಬಂದ್‌ ಕಿನೂಕಿ ಇನ ಯೆಹೂದ್ಯರ್‌ನ ಖ್ಹಾರು ಅಮ್ಮಸ್ ಯೆರೂಸಲೇಮ್ಮ ಭಾಂದಿನ್ ಯೆಹೂದ್ಯರ್‌ಕಾಹೆತೆ ಇವ್ಣ ಹಾತ್ಮ ದಿಶೆಕರಿ ಪವಿತ್ರಾತ್ಮ ಬೋಲುಕರಸ್ ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","ಕದೆ ಆ ವಾತೆನ ಖ್ಹಮ್‍ಜ್ಯಾಕಿ ಹಮೇಬಿ ಯೋ ಗಾಮ್‍ವಾಳುಬಿ ತೂ ಯೆರೂಸಲೇಮ್‌ನ ನಕೊ ಜಾ಼ಕರಿ ಪೌಲನ ಗಿಂಗೈಲಿದ. ");
INSERT INTO vaa_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","ಇನಖ್ಹಾಜೆ ಪೌಲನೆ, “ತುಮೆ ಆಂಝು಼ನಾಖಿನ್ ತುಮೆ ಶನ ಮಾರು ದಿಲ್‌ತೋಡಾವೊಸ್? ಮೆ ಯೇಸುನ ನಾಮ್ನಖ್ಹಾಜೆ ಯೆರೂಸಲೇಮ್ಮ ಭಂದಿಹುವಾನು ಕಾಹೆತೆ ಪ್ರಭುನಖ್ಹಾಜೆ ಮರನಾಬಿ ತಯಾರ್ ಛೂ಼” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","ಯೋ ಖ್ಹಮ್‍ಜ್ಯೊಕೊಂತೆ ದೇಖಿನ್ ಪ್ರಭುನಿ ಮರ್ಜಿ ಕಿಮ್ ಛಾ಼ಕಿ ತಿಮ್ ಚಾ಼ಲಾದೆ ಕರಿ ಹಮೆ ಖ್ಹೊಪ್‌ ರ‍್ಹೀಗಯ. ");
INSERT INTO vaa_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","ಆ ಖ್ಹಾರದನ್ ಹುವಾನಪಾರ್ ಹಮೆ ಖ್ಹುದ್ರೀನ್‌ ಯೆರೂಸಲೇಮ್ನ ನಿಕ್‍ಳ್ಯ. ");
INSERT INTO vaa_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","ಕೈಸರೈಥು ಥೋಡ ಶಿಷ್ಯರ್‌ ಹಮಾರಿ ಜೋ಼ಡ್ಮ ಐನ್, ಮ್ನಾಸೋನಕರಿ ಏಕ್‍ಜ಼ಣಾನ ಘರ್‌ಮ ಹಮೂನ ರ‍್ಹವಾನಖ್ಹಾಜೆ ಬುಲೈಲಿನ್ ಗಯು. ಯೋ ಕುಪ್ರಥು ಆಯುತೆ ಪಹಿಲ ಶಿಷ್ಯರ್‌ಮ ಏಕ್‍ಜ಼ಣೊ ಥೊ. ");
INSERT INTO vaa_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","ಹಮೆ ಯೆರೂಸಲೇಮ್ ಆವಾದಿನ್ ವಿಶ್ವಾಸಿಖ್ಹಾರು ಹಮೂನ ಖುಷಿಥಿ ಬುಲೈಲಿದಾ. ");
INSERT INTO vaa_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","ಅಗಲ್ಯದನ್ನೆ ಪೌಲನೆ ಹಮುನಖ್ಹಾರನ ಬುಲೈಲಿನ್ ಯಾಕೋಬನ ಮಳಾನ ಗಯ. ತದೆ ಸಬೇನು ಖ್ಹಾರಾಸ್ ಗಲ್‌ಢಬಿ ಹಿಜ್ಜಾ಼ಸ್ ಥಾ. ");
INSERT INTO vaa_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","ಪೌಲನೆ ಇವ್ಣುನ ಖ್ಹಲಾಮ್‍ಕರೀನ್ ಇನಿ ಸೇವೆಥಿ ದೇವ್ನೆ ಕರ‍್ಯೊತೆ ಪೂರ ಕಾಮ್ನ ಯೆಹೂದ್ಯರ್‌ಕಾಹೆತೆ ಅದ್ಮಿಖ್ಹಾರಾನ ಬೀಚ್ಮ ಯೊ ಬೋಲಿವತಾಳ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","ಇವ್ಣೆ ಯೋಖ್ಹಾರು ಖ್ಹಮ್‌ಜಿನ್‌ ದೇವ್ನ ಖ್ಹರಾಯು. ತದೆ ಇವ್ಣೆ ಪೌಲನ, “ಭೈ, ಹಜಾ಼ರೊ ಅದ್ಮಿ ಯೆಹೂದ್ಯರ್‌ಖ್ಹಾರು ವಿಶ್ವಾಸಿ ಹುಯಿರ‍್ಹುತೆ ತೂ ದೇಖಾಸ್ನಿ, ಇವ್ಣೆಖ್ಹಾರು ಧರ್ಮಶಾಸ್ತ್ರನ ದಿಲ್‌ಲಗಾಡವಾಳು ಹುಯಿರ‍್ಹುಸ್. ");
INSERT INTO vaa_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","ಯೆಹೂದ್ಯರ್‌ಕಾಹೆತೆ ಅದ್ಮಿನ ಬೀಚ್ಮ ರ‍್ಹವಾಳು ಖ್ಹಾರೂಸ್ ಯೆಹೂದ್ಯರ್‌ನ, “ತುಮೆ ತುಮಾರ ಲಡ್ಕಖ್ಹಾರನ ಖ್ಹತ್ನ ನಾಕರಾವ್ಣು ಇವ್ಣು ಪದತ್ತಿನಿಘೋಣಿ ನಾಚಾ಼ಲಿಲೇವ್ಣು ಕರಿ ಮೋಶೆ ಧರ್ಮಶಾಸ್ತ್ರನಿ ಘೋಣಿ ನಾಚಾ಼ಲ್ನುಕರಿ ಬೋಲಾನು ಶಿಕಾಡುಕರಸ್ ಕರಿ ತಾರಿ ಬಾರೇಮ ಬೋಲುಕರಸ್. ");
INSERT INTO vaa_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","ಅಮ್ ರ‍್ಹವಾನಪರ್ ಶಾತ್ ಕರ‍್ನು? ತೂ ಹಜ಼್ಜ ಅಯಿರ‍್ಹೊತೆ ವಾತೆ ಇವ್ಣುನ ಕಿಮ್‍ತೋಬಿ ಮಾಲುಮ್ ಪಡ್‌ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","ಇನಖ್ಹಾಜೆ ಹಮೆ ತುನ ಬೋಲ್‍ಯೇತೆ ಕಾಮ್ ಕರ್‌, ಹಮಾರಮ ಶಪತ್ ಕರ‍್ಯುಹುಯು ಚಾರ್ ಅದ್ಮಿಛಾ಼. ");
INSERT INTO vaa_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","ತೂ ಇವ್ಣುನ ಬುಲೈಲಿ ಜೈ಼ನ್ ಇವ್ಣಿಜೋ಼ಡ್ಮ ತುನಾಬಿ ಶುದ್ದಿಕರಿಲೀನ್, ಇವ್ಣಿ ಇವ್ಣಿ ಮುಡಪ್‍ ಖ್ಹತಮ್ ‍ಕರಾನಖ್ಹಾಜೇಥಿ ತೂ ಪೈಶಾ ಖರ್ಚಿಕರ್, ಅಮ್ ಕರ‍್ಯೊತೊ ಖ್ಹಾರುಜ಼ಣುಬಿ ತಾರಿಬಾರೇಮ ಇವ್ಣೆ ಖ್ಹಮ್‍ಜ್ಯುತೆ ಖಬರ್ ಖ್ಹಾಚು಼ ಕಾಹೆಕರೀಬಿ, ತೂಬಿ ಮೋಶೇನು ಧರ್ಮಶಾಸ್ತ್ರ ಪಾಡಿನ್ ಚಾ಼ಲವಾಳೊಕರಿ ಮಾಲುಮ್ ಕರ್ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","ಯೆಹೂದ್ಯರ್‌ಕಾಹೆತೆ ಅದ್ಮಿಮ ಯೇಸುನ ವಿಶ್ವಾಸ್ ಕರವಾಳನಿ ಬಾರೇಮಾತೊ, ಮೂರತ್ನ ಝಾ಼ಳ್ ಉತಾರಹುಯನಾಬಿ, ಲ್ಹೋಯಿನಾಬಿ, ನ್ಹೇಟಿ ಭೀಚಿನ್ ಮಾರ‍್ಯಹುಯ ಜಿನಾವರ್‌ನಬಿ ನಾಖಾವ್ಣು ಅಜು಼ ವ್ಯಬಿಚಾರ್‌ಥಿ ದೂರ್ ರ‍್ಹೇವ್ಣುಕರಿ ಹಮೆ ನ್ಯಾವ್‌ ಕರ‍್ಯಾತೆ ಲೀಖ್ಯ” ಕರಿ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","ತದೆ ಪೌಲನೆ ಯೋ ಖ್ಹಾರ ಅದ್ಮಿನ ಅಗ್‍ಲ್ಯದನ್ನೆ ಬುಲೈಲಿನ್ ಇವ್ಣಿಜೋ಼ಡೆ ಇನು ಯೋ ಶುದ್ದಿಕರಿಲೀನ್, ಮುಡಪ್‍ನ ದನ್ ಖ್ಹತಮ್ ಹುಯಿಗುಕರಿ ಖ್ಹಮ್‍ಜಾ಼ಡ್ತೊ ಹುಯಿನ್ ದೇವ್ನಿಮಂದಿರ್‌ಮ ಗಯೊ. ಹರೇಕ್‌ನಖ್ಹಾಜೆ ಕದೆ ಬಲಿದೇವ್ಣುಕರಿ ಹಿಜ್ಜಾ಼ ಮಾಲುಮ್ ಕರಾಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","ಯೊ ಖ್ಹಾತ್‍ದನ್ ಖ್ಹತಮ್ ಹುವಾನಿ ವಖ್ಹತ್‌ಮ ಏಷ್ಯಾ ತಬರ್‌ಖಾಥು ಆಯಿರ‍್ಹುಥೂತೆ ಯೆಹೂದ್ಯರ್‌ನೆ ಪೌಲನ ದೇವ್ನಿಮಂದಿರ್‌ಮ ದೇಖಿನ್, ಝೂ಼ಂಡ್‌ ಭರೈರ‍್ಹುಥೂತೆ ಅದ್ಮಿಖ್ಹಾರಾನ ಎಕ್ಕೋಸ್ಏಕ್‌ ಕರಿನ್ ಇನ ಧರೀನ್, ");
INSERT INTO vaa_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","“ಇಸ್ರಾಯೇಲ್‌ನ ಅದ್ಮಿವೊ, ಹಮೂನ ಮದತ್ ಕರೊ, ಅಪ್ಣ ಅದ್ಮಿನಾಬಿ, ಧರ್ಮಶಾಸ್ತ್ರನಾಬಿ ಆ ಝ಼ಗೋನಾಬಿ ವಿರೋದ್ ಹುಯಿನ್ ಖ್ಹಾರಾಸ್ ಅದ್ಮಿನ ಬೋಧನೆ ಕರಾವಾಳೊ ಯೋ ಅದ್ಮಿ ಆಸ್! ಅತ್ರೇಸ್ ಕಾಹೆ, ಆ ಗ್ರೀಕ್‍ವಾಳಾನ ದೇವ್ನಿಮಂದಿರ್‌ಮ ಬುಲೈಲಾಯಿನ್‌ ಹೈರಿತೆ ಪವಿತ್ರಝ಼ಗೋನ ಮೈಲು ಕರಿನಾಖ್ಯೊ.” ಕರಿ ಚಿಕ್‌ರ‍್ಯು. ");
INSERT INTO vaa_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","ಇವ್ಣೆ ಪಹಿಲೆ ಖ್ಹಯೇರ್‌ಮ ಎಫೆಸವಾಳೊ ತ್ರೊಫಿಮಕರಿ ಏಕ್‍ಜ಼ಣೊ ಪೌಲನಿ ಜೋ಼ಡ್ಮ ರ‍್ಹವಾನು ದೇಖ್ಯುಥೂತೆ ಇನಖ್ಹಾಜೆ ಪೌಲನೆ ಹಮ್ಕೆ ಇನ ದೇವ್ನಿಮಂದಿರ್‌ಮ ಬುಲೈರಾಖ್ಯೊ ಉಷೆಕರಿ ಲ್ಹಾಜ್ಯೊ಼. ");
INSERT INTO vaa_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","ತದೆ ಅಖ್ಖೀಸ್ ಬಾಜು಼ ಕಲಾವ್ಣಿ ಹುಯಿನ್ ಫೈಲೈಗಯು. ಅಜು಼ ಅಖ್ಖಾಸ್ ಖ್ಹಯೇರ್‌ಥು ನಾಶಿ ಐನ್ ಪೌಲನ ಧರಿಲೀನ್ ದೇವ್ನಿಮಂದಿರ್‌ಮಾಥು ಭಾರ್‌ ಖೇಚಿಲಾಯಿನ್ ತದ್ನುತದೇಸ್ ಬಾಕಲ್ ಮೂಚಿನಾಖ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","ಇವ್ಣೆ ಇನ ಮಾರಿನಾಕ್ಣುಕರಿ ಕೋಶಿಶ್ ಕರುಕರಾನಿ ವಖ್ಹತ್‌ಮ ಯೆರೂಸಲೇಮ್ಮ ಖ್ಹಾರಿಸ್ ಬಾಜು಼ ಗಲಿಬಿಲಿ ಹುಯುಕರಿ ಹಿಜ಼್ಜಾಥೂತೆ ರೋಮ್ನ ಹಜಾ಼ರ್‌ ಶಿಪಾಯಿನ ಮೋಟಾನ ಖಬರ್ ಆಯಿ. ");
INSERT INTO vaa_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","ಇನೆ ತದ್ನುತದೇಸ್ ದಂಡುದಳವೈನ ಲೀನ್ ಅದ್ಮಿನ ಝೂ಼ಂಡ್‌‍ಕನ ನಾಶಿಆಯೊ. ಇವ್ಣೆ ಖ್ಹೋಶಿಪಾಯಿನೊ ಮೋಟಾನ ಅಜು಼ ಶಿಪಾಯಿಖ್ಹಾರಾನ ದೇಖಿನ್ ಪೌಲನ ಮಾರಾನು ಭೀರಾಖ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","ಶಿಪಾಯಿನೊ ಮೋಟೊ ಖನ್ನೆ ಐನ್ ಇನ ಧರೀನ್ ಬೇ ಖ್ಹಂಕ್‌ಳಿಥಿ ಭಾಂದ್‌ಣುಕರಿ ಹುಕುಮ್‌ ದೀನ್; ಇವ್ಣುನ ಬೋಲ್ಯೊ, ಆ ಕೋಣ್, ಅನೆ ಶಾತ್‌ಕರ‍್ಯೊ? ಕರಿ ಪುಛಾಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","ತದೆ ಝೂ಼ಂಡ್‌‍ಮಥೂತೆ ಥೋಡುಜ಼ಣು ಏಕ್‌ಥರ ಬಿಜು಼ ಥೋಡುಜ಼ಣು ಬಿಜೇಕ್‌ತರ ಚಿಕ್ರುಕರ್ತುಥು. ಯೋ ಗಲಾಟ್‌ಥಿ ಖ್ಹಾಚು಼ಶಾತ್‍ ಕರಿ ಹಜಾ಼ರ್‌ ಶಿಪಾಯಿನ ಮೋಟಾನ ಖ್ಹಮ್‌ಜಾ಼ನ ಕೋ ಹುಯುನಿ ಇನಖ್ಹಾಜೆ ಪೌಲನ ಖ್ಹಾರ್ಕೊಟ್‌ಮ ಲೀನ್ ಜಾ಼ವಾನ ಹುಕುಮ್ ದಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","ಪೌಲ ಪಾಯಿರಿಯೇಕನ ಆವಾದಿನ್ ಅದ್ಮಿಖ್ಹಾರಾನಿ ಧಕ್ಕಾಮುಕ್ಕಿಥಿ ಶಿಪಾಯಿಖ್ಹಾರನೆ ಇನ ಢೊಯಿಲೀನ್ ಜಾ಼ವಾನು ಪಡ್ಯುಥು. ಶನಕತೊ ಹಿಜ಼್ಜಾನು ಅದ್ಮಿನು ಝೂ಼ಂಡ್‌ ಜಾ಼ಖ್ಹತ್ ಚ಼ಂಢಾಳ್‌ವಾಳು ಹುಯಿರ‍್ಹುಥು. ");
INSERT INTO vaa_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","ಇನಖ್ಹಾಜೆ ಧಕೇಲ್‍ತು ವಳ್ಯಾವ್‌ತುಥೂತೆ ಅದ್ಮಿನು ಝೂ಼ಂಡ್‌, ಇನ ಮಾರಿನಾಖೊಕರಿ ಚಿಕ್ರುಕರ್ತುಥು. ");
INSERT INTO vaa_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","ಶಿಪಾಯಿಖ್ಹಾರು ಪೌಲನ ಖ್ಹಾರ್ಕೊಟ್‌ಮ ಲೀಜಾ಼ವನಿ ವಖ್ಹತ್‌ಮ ಇನ ಶಿಪಾಯಿನೊ ಮೋಟಾನ, “ಮೇ ತಾರಿ ಜೋ಼ಡೆ ದರ್ರಾಶಿ ವಾತೆ ಬೋಲಾನ ಹುಕುಮ್‌ ಮಳ್‍ಶೇಕಿ ಶು?” ಕರಿ ಪುಛಾ಼ವದೀನ್ ಇನೆ ತುನ ಗ್ರೀಕ್‌ವಾತೆ ಆವಸ್ಕಿ ಶು? ");
INSERT INTO vaa_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","ಇಮ್‍ಕತೊ ಥೋಡದನ್ನಪಾರ್ ಲಡೈಉಠಾಡಿನ್ ಚಾರ್ ಹಜಾ಼ರ್ ಢಾಕುನ ಜ಼ಂಗಳ್‌ಮ ಬುಲೈಲಿನ್ ಗಯೋತೆ ಈಜಿಪ್ಟ್‌ವಾಳೊ ತೂಸ್ ಕಾಹೆಕಿ ಶು? ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","ಇನ ಪೌಲನೆ, “ಮೆ ಏಕ್‌ ಯೆಹೂದ್ಯವಾಳೊ ಅಜು಼ ಕಿಲಿಕ್ಯ ತಬರ್‌ಖಾನು ತಾರ್ಸಕರಿ ಪ್ರಸಿದ್ದಿನು ಹುಯಿರ‍್ಹುತೆ ಖ್ಹಯೇರ್‌ವಾಳೊ, ಗೋರ್‌ಕರೀನ್ ಆ ಅದ್ಮಿನಿ ಜೋ಼ಡೆ ವಾತೆಬೋಲಾನ ಮನ ಹುಕುಮ್‌ ದೆ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","ಸಿಪಾಯ್ನೊಮೋಟಾನೆ ಹುಕುಮ್‌ ದ್ಯಾವದೀನ್ ಪೌಲನೆ, ಪಾಯಿರಿಪರ್ ಭೀರಿನ್, ಅದ್ಮಿನಝೂ಼ಂಡ್‌ನ ಖ್ಹೊಪೊರ‍್ಹೇವೊಕರಿ ಹಾತ್‌ನೊ ಇಷಾರ್ಕೊ ದಿದೊ. ಇವ್ಣೆ ಜ಼ರ ಖ್ಹೊಪ್‍ಪಡಾದಿನ್ ಇವ್ಣುನ ಇನೆ ಇಬ್ರಿಯ ವಾತೆಮ ಬೋಲಾನ ಶುರುಕರ‍್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","“ಮಾರ ಬಾವೊ, ಯಹೂದಿ ದೋಸ್ತಿವೊ, ಮೇ ಹಮ್ಕೆ ತುಮೂನ ದೆವುಸ್ತೆ ಫೇಡ್ನ ಖ್ಹಮ್‍ಜೊ ಕರಿ ಚಿಕ್ರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","ಇವ್ಣಿಜೋ಼ಡೆ ಇಬ್ರಿಯ ಬೋಲಿಮ ವಾತೆ ಬೋಲಾನು ಖ್ಹಮ್‌ಜಿನ್‌ ಇವ್ಣೆ ಬಿಜೂ಼ಬಿ ಖ್ಹೊಪೊ ಪಡೀಗು. ತದೆ ಇನೆ ಶಾತ್ ಬೋಲ್ಯೊಕತೊ; ");
INSERT INTO vaa_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","ಮೇ ಕಿಲಿಕ್ಯಾನು ತಾರ್ಸ ಖ್ಹಯೇರ್‌ಮ ಪೈದಹುಯೊತೆ ಯೆಹೂದ್ಯವಾಳೊ. ಕತೋಬಿ ಆಸ್ ಖ್ಹಯೇರ್‌ಮ ಪಳ್ಯೊಹುಯೊ.ಯೆರೂಸಲೇಮ್ಮ ಮೇ ಗಮಲಿಯೇಲನೊ ಶಿಷ್ಯಹುಯಿನ್, ಹಮಾರ ಗುರುಗುರಬ್‌ಲ್ಯನು ಧರ್ಮಶಾಸ್ತ್ರನು ಖ್ಹಾರೂಸ್ ಶಿಕಿರಾಖ್ಯೊಸ್; ಹಮ್ಕೆ ತುಮೆಖ್ಹಾರು ಛಾ಼ತೆ ತಿಮ್ಮಸ್ ಮೇಬಿ ದೇವ್‌ನೊ ದಿಲ್‌ಲಾಗ್ಯೊತೆ ಹುಯಿರ‍್ಹೋಥೊ. ");
INSERT INTO vaa_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","ಆ ಮಾರಗ್‌ಪರ್‌ ಚಾ಼ಲವಾಳಾನ ಖ್ಹತಾವ್‍ತೊಹುಯಿನ್ ತಯೇಡ ಪರ್ಖ್ಹಾ ಖೇಚಿಲಾಯಿನ್ ಜೇಲ್‌ಮ ಧಕೆಲಿನ್ ಇವ್ಣುನ ಮರ್‌ನಾಖನಾಬಿ ಕಚ಼್ ಖಾದೊಕೊಯ್ನಿ. ");
INSERT INTO vaa_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","ಅನಿಬಾರೇಮ ಗಲ್‌ಢಯಾಜಕ್‌ಬಿ ಮೋಟಿಸಭೆವಾಳು ಖ್ಹಾರು ಸಾಕ್ಷಿ ಹುಯಿರ‍್ಹುಸ್. ಇವ್ಣೇಥಿಸ್ ದಮಸ್ಕಮ ಥೂತೆ ಯಹೂದಿ ದೋಸ್ತಿನ ದ್ಯವಾನಖ್ಹಾಜೆ ಅವ್ಣಕನ ಥೂತೆ ಚಿಟ್ಟಿನ ಮಾಂಗಿಲೀನ್ ಇವ್ಣುನ ಬೇಡಿ ಘಾಲಿನ್ ಖ್ಹತಾವನ ಯೆರೂಸಲೇಮ್ಮ ಖೇಚಿಲಿ ಆವಾನ ದಮಸ್ಕಮ ಮೇ ವಳ್ಯೊಜಾ಼ತೋಥೊ. ");
INSERT INTO vaa_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","ಖ್ಹುಮಾರ್ ಭಾರಘಂಟಾನಿ ವಖ್ಹತ್‌ಮ ಮೇ ದಮಸ್ಕನ ಖನ್ನೆ ಜೈ಼ರ‍್ಹೂಥು. ತದೆ ಅಪ್‌ಗುಪ್‌ಥೀಸ್ ಆಕಾಶ್‌ಮಾಥು ಏಕ್‌ ಉಜಾ಼ಳು ಮಾರ ಅಶ್‌ಪಿಶ್‌ ಉಜಾ಼ಖ್ಹ್‌ಥಿ ಝ಼ಮ್‍ಕ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","ಮೇ ಜ಼ಮೀನ್‌ಪರ್ ರಡ್ಕಿಗಯೊ. ತದೆ ‘ಸೌಲ’ ಸೌಲ, ಮನ ಶನ ಖ್ಹತಾವಸ್? ಕರಿ ಮನ ಬೋಲ್ಯುತೆ ಏಕ್‌ ಆವಾಜ಼್‌ನ ಖ್ಹಮ್‍ಜ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","ಇನ ಮೇ, ‘ಪ್ರಭು ತೂ ಕೋಣ್?’ ಕರಿ ಪುಛಾ಼ವದೀನ್, ‘ತೂ ಖ್ಹತವ್‍ಕರಸ್ತೆ ನಜ಼ರೇತ್‌ನೊ ಯೇಸುಸ್ ಮೇ’ ಕರಿ ಇನೆ ಮನ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","ಮಾರಿ ಜೋ಼ಡೆ ರ‍್ಹವಾಳು ಉಜಾ಼ಳಾನ ದೇಖ್ಯುಪಣ್ಕಿ ಮಾರಿ ಜೋ಼ಡೆ ವಾತೆಬೋಲ್ಯುತೆ ಯೋ ಅವಾಜ಼್ ಖ್ಹಮ್‍ಜ್ಯುಕೊಯ್ನಿ. ");
INSERT INTO vaa_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","ತದೆ ಮೆ ‘ಪ್ರಭು ಮೇ ಶಾತ್‍ಕರ್ನು?’ ಕರಿ ಪುಛಾ಼ಯೊ. ತದೆ ಪ್ರಭುನೆ, ತೂ ಉಠೀನ್‌’ ದಮಸ್ಕಮ ಜಾ಼, ತೂ ಶಾತ್ ಶಾತ್ ಕರ್ನುಕಿ ಯೋ ಖ್ಹಾರು ತುನ ಹಿಜ್ಜಾ಼ ಮಾಲುಮ್‌ ಪಡ್‌ಶೆ; ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","ಯೋ ಉಜಾ಼ಳಾನಿ ಮಹಿಮೆಥಿ ಮಾರ ಡೋಳ ಕಾಣಹುಯಿಗಾತೆ ಇನಖ್ಹಾಜೆ ಮಾರಿಜೋ಼ಡೆ ರ‍್ಹವಾಳುಖ್ಹಾರು, ಮಾರೊ ಹಾತ್‍ಧರೀನ್ ದಮಸ್ಕಮ ಬುಲೈಲಿನ್ ಗಯು. ");
INSERT INTO vaa_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","ಹಿಜ್ಜಾ಼ ಧರ್ಮಶಾಸ್ತ್ರನಿ ಬಾರೇಮ ಬರೋಬರ್ ಚಾ಼ಲಿಲ್ಯವಾಳೊ ದೇವ್‌ನೊ ಭಕ್ತಾಬಿ ಯೋ ಝ಼ಗೋನು ಯೆಹೂದ್ಯರ್ ಖ್ಹಾರಾಥಿ ಅಛ್ಛೊ಼ಕರಿ ನಾಮ್ ಕಮಾಯೊಹುಯೊ ಅನನೀಯಕರಿ ಏಕ್‍ಜ಼ಣೊ ಮಾರಕನ ಆಯಿ ಭೀರಿನ್, ");
INSERT INTO vaa_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","ಇನೆ, ‘ಮಾರೊ ಭೈ ಸೌಲ, ತುನ ಡೋಳ ದೆಖವಾದೆ’ ಕರಿ ಬೋಲ್ಯೊ. ತದ್‌ನು ತದೇಸ್‌ ಮನ ಡೋಳಾನಿ ಜೋ಼ತ್ ಆಯಿನ್ ಮನ ದೇಖವಲಗ್ಯು. ಮೇ ಇನ ದೇಖ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","ತದೆ ಅನನೀಯನೆ, ‘ತುಮಾರೊ ಗುರುಖ್ಹಾರಾನೊ ದೇವ್ ಘಣ ದನ್ನ ಪಾರಸ್ ತುನ ಚೂ಼ಣಿಲಿದೊ. ತೂ ದೇವ್ನಿ ಖ್ಹಯಾಲ್ನ ಮಾಲುಮ್ ಕರಿಲ್ಯವಾನಾಬಿ ನೀತಿವಾಳೊಸೇವಕ್ನ ದೇಕ್ಣುಕರಿಬೀ, ಯೊ ಇನಿ ಶೊಂತ್ ಅವಾಜ಼್‌ನಿ ವಾತೆನ ಖ್ಹಮಜ಼್‌ಣುಕರಿ ದೇವ್ನೆ ತುನ ನೇಮ್‌ಶಾಯೋತೆ. ");
INSERT INTO vaa_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","ತೂ ದೇಖಿನ್‍, ಖ್ಹಮ್‍ಜ್ಯೊತೆ ಬಾರೇಮ ಖ್ಹಾರಾಸ್ ಅದ್ಮಿನ ಖ್ಹಾಮ್ಣೆ ಇನಿ ಸಾಕ್ಷಿ ಬೋಲ್‌ನು. ");
INSERT INTO vaa_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","ತೂ ಹಮ್ಕೆ ಶನ ಖ್ಹೊಪ್‍ರ‍್ಹೇಸ್ ಉಟ್? ಪ್ರಭುನ ನಾಮ್ನ ಬೋಲವಾಳೊಹುಯಿನ್, ಬ್ಯಾಪ್ತಿಸ್ಮ ಕರೈಲೀನ್ ತಾರ ಪಾಪ್ನ ದ್ಹೋಯಿಲೆ ಅಜು಼ ತು ಇನಖ್ಹಾಜೆ ಪ್ರಾರ್ಥನೆ ಕರ್‌ ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","ಮೇ ಯೆರೂಸಲೇಮ್ಮ ಪಾಛೊ಼ ಫರೀನ್ ಐನ್ ದೇವ್ನಿ ಮಂದಿರ್‌ಮ ಪ್ರಾರ್ಥನೆ ಕರುಕರಾನಿ ವಖ್ಹತ್‌ಮ ಮೆ ಏಕ್‌ ದರ್ಶನ್ ದೇಖ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","ಮೇ ಪ್ರಭುನ ದೇಖ್ಯೊ. ಇನೆ ಮನ, “ಒಗ್ಗಿ ಯೆರೂಸಲೇಮ್‍ಥು ನಿಕಳ್ ಮಾರಿ ಬಾರೇಮ ತೂ ಬೋಲಾನಿ ಸಾಕ್ಷಿನ ಆ ಖ್ಹಾರು ಅದ್ಮಿ ಮಾನಿಲೇಯಿ ಕೊಯ್ನಿ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","ಇನ ಮೇ, ‘ಪ್ರಭು, ಮೇ ಅಖ್ಖಾಸ್ ಸಬೆನಿ ಝ಼ಗೋಮ ತಾರಾಮ ವಿಶ್ವಾಸ್ ರಾಖ್ಯಹುಯ ಅದ್ಮಿಖ್ಹಾರಾನ ಮೆ ಜೇಲ್‌ಮ ಧಕೆಲಿನ್ ಮರಾಯೊಹುಯೊ ಮೇಸ್ ಕರಿ, ");
INSERT INTO vaa_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","ಅಜು಼ ತಾರಿ ಸಾಕ್ಷಿ ಹುಯಿರೋತೆ ಸ್ತೆಫನನು ಲ್ಹೋಯಿ ರಂಚಾ಼ವನಿ ವಖ್ಹ್‌ತೆ, ಮೇಬಿ ಇನ ಮಾನಿನ್ ಇನ ಮಾರವಾಳಾನು ಝ಼ಗ್ಗಾಕನ ಟಿವೈನ್ ಭೀಯೊಥೋನಿ, ಕರಿ ಇವ್ಣೆ ಮಾಲುಮ್ ಕರಿರಾಖವಳು ಹುಯಿರುಸ್. ");
INSERT INTO vaa_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","ತದೆ ಪ್ರಭುನೆ; ಜಾ಼ ಮೇ ತುನ ದೂರ್ ಯೆಹೂದ್ಯರ್‌ಕಾಹೆತೆ ಅದ್ಮಿನ ತಬರ್‌ಖಾಮ ಮೋಕ್ಲುಸ್’ ಕರಿ ಮನ ಬೋಲ್ಯೊ.” ");
INSERT INTO vaa_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","ಆ ವಾತ್ ಬೋಲಲಗು ಅದ್ಮಿಖ್ಹಾರು ಪೌಲನಿ ವಾತ್ನ ಕಾನ್‍ಲಾಗಾಡಿ ಖ್ಹಮ್‌ಜ್ಯು; ಅನಪಾರ್ ಇವ್ಣೆ “ಅಥ್ರಾನವಾಳಾನ ಜ಼ಮೀನ್‍ಪರ್ಥು ಕಾಡಿನಾಕ್; ಆ ಬಚಾ಼ವನ ಲ್ಹಾಯೇಕ್‍ ಕೊಯ್ನಿ” ಕರಿ ಚಿಕ್ರಿ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","ಇವ್ಣೆ ಚಿಕ್ರಾಣ್ ಮ್ಹೇಲ್‍ತು, ಇವ್ಣು ಲುಂಗ್ಡಾನ ಫಾಡಿಲೇತು ಹುಯಿನ್, ಮಾಟಿ ಉಡಾವ್ತು ರ‍್ಹಯು. ");
INSERT INTO vaa_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","ತದೆ ರೋಮ್‌ನೊ ಸೇನಾಧಿಪತಿನೆ ಪೌಲನ ಕೋಟೆನ ಮ್ಹೇಲಿಜಾ಼ವ್ಣುಕರಿ ಹುಕುಮ್ ದೀನ್, ಅದ್ಮಿಖ್ಹಾರು ಅಮ್ ಪೌಲನಿ ವಿರೋದ್ ಚಿಕ್ರಾಣ್ ಮ್ಹೇಲುಕರಾಸ್ತೆ ಕಾರಣ್ ಶಾತ್ ಕರಿ ಫುಚಾ಼ವ್ಣುಕರಿ ಸೆನಾದಿಪತಿನು ಆಖ್ಹ್ ಹುಯಿರ‍್ಹೀಥಿ. ");
INSERT INTO vaa_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","ಇವ್ಣೆ ಪೌಲನ ಡುಗೈನ್ ಭಾಂದಿನ್ ಮಾರಾನಿ ವಖ್ಹ್‌ತೆ ಇನ ಖನ್ನೆ ಭಿಯುಥೂತೆ ಖ್ಹೋಶಿಪಾಯಿನ ಮೋಟಾನ, “ರೋಮ್ ಪ್ರಜೆ ಹುಯಿರ‍್ಹವಾಳ ಅದ್ಮಿನ ಅಪರಾದಿ ಕರಿನ್ ತೀರ್ಪ್ ಹುವಾನ ಅಗಾಡಿಸ್ ಕೋಲ್ಡೆಖ್ಹು ಮಾರ‍್ವಾನು ನ್ಯಾವ್‌ಕಿ ಶು?” ಕರಿ ಪುಛಾ಼ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","ಯೋ ಖ್ಹೋಶಿಪಾಯಿನ ಮೋಟಾನೆ ಅನ ಖ್ಹಮ್‌ಜಿನ್‌ ತದ್‌ನು ತದೇಸ್‌ ಸೈನಾಧಿಪತಿಕನ ಜೈ಼ನ್ “ತೂ ಶಾತ್‌ ಕರುಕರಸ್ ಕರಿ ತುನ ಮಾಲುಮ್‍ಕಿ ಶು? ಆ ಅದ್ಮಿ ರೋಮ್‌ನೊ ಪ್ರಜೆ!” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","ತದೆ ಸೇನಾಧಿಪತಿ ಪೌಲಕನ ಐನ್, “ಬೋಲ್ ತು ರೋಮ್‌ನೊ ಪ್ರಜೆಕಿಶು?” ಕರಿ ಪುಛಾ಼ವಮ, ಪೌಲನೆ “ಓಹೊ” ಕರಿ ಜ಼ವಾಬ್ ದಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","ತದೆ ಸೇನಾಧಿಪತಿನೆ, “ಮೇ ರೋಮ್‍ನು ಪ್ರಜೆ ಹುವಾನ ಘಣು ಪೈಶಾದಿದೊ” ಕರಿ ಬೋಲ್ಯೊ. ಕತೋಬಿ ಇನ ಪೌಲನೆ, “ಮೇ ಪೈದಾಖ್ಹ್‌ಥೋಸ್‌ ರೋಮ್‍ನು ಪ್ರಜೆ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","ಪೌಲನ ಪುಛಾ಼ವ್ಣು ಕರಿ ಆಯುಹುಯು ಖ್ಹಾರುಜ಼ಣು ತದ್‌ನು ತದೇಸ್‌ ಇನಕಂಥು ಚ಼ಲಿಗಯು. ಅತ್ರೇಸ್ ಕಾಹೆತೆ ಸೇನಾಧಿಪತಿನೆ ಪೌಲ ರೋಮ್‍ನು ಪ್ರಜೆಕರಿ ಮಾಲುಮ್ ಕರಿಲೀನ್, ಇನ ಭಂಧೈರಾಖ್ಯೊಥೋತೆ ಇನಖ್ಹಾಜೆ ಡರ‍್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","ಪೌಲನ ಉಪ್ಪರ್ ಯೆಹೂದ್ಯರ್ ಖ್ಹಾರು ಶನ ಅಪರಾದ್ ನಾಖುಕರಸ್ ಕರಿ ಮಾಲುಮ್‌ ಕರಿಲ್ಯಾವಾನಖ್ಹಾಜೆ ಸೇನಾಧಿಪತಿನೆ ತೀರ್ಮಾನ್ ಕರೀನ್, ಇನವ್ಹಾಣೆ ಪೌಲನ ಬೇಡಿನ ಛೋ಼ಡಿನ್ ಮಹಾಯಾಜಕಬಿ ನ್ಯಾವ್ನಿಸಬೆವಾಳು ಖ್ಹಾರುಸ್ ಭರಾವ್ಣುಕರಿ ಹುಕುಮ್‌ ದೀನ್, ಪೌಲನ ಬುಲೈಲೀಜೈ಼ನ್ ಇವ್ಣಖ್ಹಾಮೆ ಭೀರಾಖ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","ತದೆ ಪೌಲನೆ ಯೆಹೂದ್ಯರ್‌ನ ನ್ಯಾವ್ನಿಸಭೆನ ಠರ್‌ಕಿ ದೇಖಿನ್, “ಭೈಯೇವೊ, ಮೆ ಹಮ್ಕೆಲಗು ಅಛ್ಛಿ ದಿಲ್ನಿಸಾಕ್ಷಿಥಿ ದೇವ್ನಖ್ಹಾಮ್ಣೆ ಚಾ಼ಲಿರ‍್ಹೋಸ್” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","ಇನಖ್ಹಾಜೆ ಮಹಾಯಾಜಕ ಹುಯಿರೋತೆ ಅನಾನೀಯನೆ; ಪೌಲಕನ ಭಿಯಹುಯಖ್ಹಾರಾನ ಇನ ಮ್ಹೋಡಾಪರ್ ಮಾರೊ ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","ತದೆ ಪೌಲನೆ ಇನ ಅಮ್‍ ಬೋಲ್ಯೊ, “ದೇವ್ ತುನಾಬಿ ಮಾರ್‌ಶೆ. ಛು಼ನ್ನೊ ಲಗಾಡಿಹುಯು ಭೀತಸ್ ತು. ಶನಕತೊ ಮೋಶೆನ ಧರ್ಮಶಾಸ್ತ್ರನಿಘೊಣಿ ನ್ಯಾವ್‌ಕರಾನ ಹಿಜ್ಜಾ಼ ಬೇಶಿನ್, ಮನ ಮಾರ್‌ವಾನ ಇವ್ಣುನ ಬೋಲುಕರಸ್ ಕಿಶು? ಆ ಧರ್ಮಶಾಸ್ತ್ರನವಿರುದ್ ಹುಯಿರ‍್ಹುಸ್ನಿ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","ತದೆ ಪೌಲನ ಖನ್ನೆ ಭಿಯಹುಯಾನೆ, “ದೇವ್ನ ಮಹಾಯಾಜಕನ ಅಮ್ನಿ ಪರಕ್ ವಾತ್ ನಾ ಬೋಲ್‌ನು. ತೂ ಇನ ಖ್ಹರಮ್‌ ಕಾಡುಕರಸ್” ಕರಿ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","ಪೌಲನೆ, “ಭೈಯೇವೊ, ಆ ಅದ್ಮಿ ಮಹಾಯಾಜಕ ಕರಿ ಮನ ಮಾಲುಮ್ ಕೋಥೂನಿ. ಶನಕತೊ ಅದ್ಮಿಖ್ಹಾರಾನೊ ಅದಿಪತಿನಿ ಬಾರೇಮ ಖರಾಬ್ ವಾತ್ ನಾ ಬೋಲ್‌ನು ಕರಿ ಧರ್ಮಶಾಸ್ತ್ರ ಲೀಖೈರುಸ್” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","ಸಭೆಮ ಥೂತೆ ಅದ್ಮಿಮ, ಥೋಡು ಸದ್ದುಕಾಯವಾಳು,ಅಜು಼ ಥೋಡು ಫರಿಸಾಯರ್‌ವಾಳನ ದೇಖಿನ್ ಪೌಲನೆ, “ಮಾರ ಭೈಯೇವೊ, ಮೇ ಫರಿಸಾಯರ್‌ವಾಳೊ ಮಾರೊ ಬಾಬಿ ಪರಿಸಾಯ ಹುಯಿರ‍್ಹೋಥೊ ಮಾರವಾಳು ಪಾಛು಼ಜಿವ್ತು ಉಷೆಕರಿ ಕರಿ ಮೆ ವಿಶ್ವಾಸ್ ಕರೀನ್ ಹಜ಼್ಜ ನ್ಯಾವ್‌ನ ವಿಚಾರಣೆಮ ಪಡ್ಯೊಸ್” ಕರಿ ಚಿಕ್ರಿನ್ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","ಪೌಲ ಅಮ್ ಬೋಲಾಮ, ಫರಿಸಾಯರ್‌ಮಾಬಿ, ಸದ್ದುಕಾಯವಾಳಾಮ ಘಣಿ ಅಬ್ಬಾಜ಼ಬ್ಬಿ ವಾತೆ ಹುಯಿನ್ ಇವ್ಣಾಮಸ್ ಲಡೈ ಹುಯಿನ್ ಸಭೆ ಫುಟ್‍ವಾನಿ ಮತ್‍ ಹುಯು. ");
INSERT INTO vaa_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","ಶನಕತೊ ಮರ‍್ಯುಹುಯು, ಪಾಛು಼ ಜಿವ್ತುಹುವಾನು ರ‍್ಹವೊ, ದೇವ್ನದೂತ ರ‍್ಹವೊ, ಶರೀರ್‌ಕೊಂತೆ ಆತ್ಮರ‍್ಹೇವೊ ಕೊಯ್ನಿಕರಿ, ಸದ್ದುಕಾಯವಾಳು ಬೋಲಸ್. ಕತೋಬಿ ಆ ಭೇಬಿ ಛಾ಼ಕರಿ ಫರಿಸಾಯರ್ ಮಾನಿಲೇಸ್. ");
INSERT INTO vaa_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","ತದೆ ಯೋ ಯೆಹೂದ್ಯರ್‌ಮ ಘಣಿ ಗಲಾಟ್ ಹುಯು ಫರಿಸಾಯರ್‌ನ ಝೂ಼ಂಡ್‌‍ನು ಥೋಡು ಧರ್ಮ ಬೋಧನೆ ಕರವಾಳು ಉಠಿಭೀರಿನ್, “ಆ ಅದ್ಮಿಮ ಶನೀಬಿ ಅಪರಾದ್ ದೇಖವ್‌ಕರಕೊಯ್ನಿ. ದಮಸ್ಕನ ಜಾ಼ವಾನಿ ವಾಟ್‌ಮ ದೇವ್‌ದೂತರ್‌ಕೀ, ಆತ್ಮಾಕಿ, ಇನಜೋ಼ಡೆ ವಾತ್‍ಬೋಲಿರಾಕ್ಣು ಕರಿ ಅಬ್ಬಾಜ಼ಬ್ಬಿ ವಾತೆ ಚಾ಼ಲಿ. ");
INSERT INTO vaa_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","ಆ ಹೊಜ್ಜತ್ ಘಣಿ ಹುಯಿನ್, ಅದ್ಮಿನು ಝೂ಼ಂಡ್‌ ಪೌಲನ ಖೇಚ಼ತಾಣಿ ಕರೀನ್ ಫಾಡಿ ಟುಕ್‌ಡ ಟುಕ್‌ಡಾ ಕರಿನಾಕ್ಷೆಕರಿ ಡರ್‌ಥಿ ಸೇನಾಧಿಪತಿನೆ ಶಿಪಾಯಿಖ್ಹಾರಾನ ತುಮೆ ಹೇಟ್ ಉತ್ರಿಜೈ಼ನ್ ಪೌಲನ ಜು಼ಲಮ್‌ಥಿ ಇವ್ಣಕಂಥು ಛೋ಼ಡೈನ್ ಕೋಟೆಮ ಲ್ಯಾವ್ಣುಕರಿ ಹುಕುಮ್ ದಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","ಯೋ ದನ್ನಿ ರಾತ್ಮ ಪ್ರಭು ಪೌಲಕನ ಭೀರಿನ್, “ಭಾಲಿಥಿ ರ‍್ಹೇ; ತೂ ಯೆರೂಸಲೇಮ್ಮ ಮಾರಿಬಾರೇಮ ಬೋಲ್ಯೊತೆ ಇಮ್ಮಸ್ ರೋಮ್‍ನ ಅದ್ಮಿನಾಬಿ ಸಾಕ್ಷಿ ಬೋಲ್ನುಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","ಇನವ್ಹಾಣೆ ಥೋಡು ಯೆಹೂದ್ಯರ್‌ಖ್ಹಾರು ಎಕಾಡಿ ಐನ್ ಎಕ್ಟುಹುಯು ಅಜು಼ ಮಹಿ ಮಹಿಸ್ ಮಶ್ಲತ್ ಭಂದೈನ್ ಹಮೆ ಪೌಲನ ಮರಾಲಗು ಖಾಣುಪಾಣಿ ಛಿಮ್‍ಶುಕೊಯ್ನಿ. ಕರಿ ಆಣ್‌ಲಿದು. ");
INSERT INTO vaa_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","ಅಮ್ ಕರ‍್ಯಾಹುಯಾಮ ಚಾ಼ಳಿಖ್ಹ್‌ಜ಼ಣೇಥಿ ಜಾ಼ಖ್ಹತ್ ಥು. ");
INSERT INTO vaa_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","ಅವ್ಣೆ ಗಲ್‌ಢಯಾಜಕರ್‌ನ ಬಿಜು಼ ಗಲ್‌ಢಖ್ಹಾರಾಕನ ಜೈ಼ನ್, “ಪೌಲನ ಖೂನ್ ಕರಾಲಗು ಹಮೆ ಮ್ಹೋಡಾಮ ಶಾತ್ಬಿ ಘಾಲ್‍ಶುಕೊಯ್ನಿಕರಿ ಕಠಣ್‍ಥಿ ಆಣ್ ಲೀರಾಖ್ಯಸ್ ಕರಿ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","“ಇನಖ್ಹಾಜೆ ಹಮ್ಕೆ ತುಮೆ ಶಾತ್‍ಕರ‍್ನುಕತೊ, ನ್ಯಾವ್‌ನು ಸಭೆವಾಳಾನಿಜೋಡ್ಮ ರೋಮ್ನೊಸಿಪಾಯ್ನೊ ಮೋಟಾಕನ ಜೈ಼ನ್‌, ಪೌಲನಿ ಬಾರೇಮ ಬಿಜೂ಼ಬಿ ಜಾ಼ಖ್ಹತ್ ತರೀಪ್‌ಶ ಕರ್ನುಕರಿ ಭಾಣುಬೋಲಿನ್ ಇನ ಹಮಾರಕನ ಬುಲೈಲಿನ್ ಆವ್ಣುಕರಿ ಸೇನಾಪತಿನ ಖ್ಹಮ್‌ಜಾ಼ಡ್ ತದೆ ಪೌಲ ಹಜ಼್ಜ ಆವ್‍ತೊಸ್‍ ಜಾ಼ವ್ಣು ಹಮೆ ವಾಟ್‌ಪರ್ ಟಿವೈರ‍್ಹೀನ್, ಇನ ಮಾರಿನಾಖೇಸ್” ಕರಿ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","ಕತೋಬಿ ಅವ್ಣಿ ಮಶ್ಲತ್ ಪೌಲನ ಭೇನ್ನಛಿಯ್ಯಾನ ಮಾಲುಮ್ ಪಡ್ಯು. ಇನೆ ಶಿಪಾಯ್ನ ಕೋಟೆನ ಮಹಿಜೈ಼ನ್ ಪೌಲನ ಖ್ಹಮ್‍ಜಾ಼ಡ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","ತದೆ ಪೌಲನೆ ಏಕ್‌ ಖ್ಹೋಶಿಪಾಯಿನ ಮೋಟಾನ ಬುಲೈನ್, “ಆ ಜ಼ವಾನಿ ಛೋ಼ಕ್ರಾನ ಸೇನಾಧಿಪತಿಕನ ಬುಲೈಲಿನ್ ಜಾ಼. ಯೋ ಇನ ಖ್ಹಮ್‍ಜಾ಼ಡಾನಿ ಏಕ್‌ ವಾತ್ ಛಾ಼” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","ಇಮ್ಮಸ್ ಯೋ ಅಧಿಕಾರಿನ ಪೌಲನ ಭಾಣ್‍ಜ್ಯಾನ ಸೇನಾಧಿಪತಿಕನ ಬುಲೈಲಿನ್ ಗಯೊ. ಇನೆ ಸೇನಾಧಿಪತಿನ ಅಮ್‌ಬೋಲ್ಯೊ, “ಯೋ ಕೋಂಡೈರ‍್ಹೋತೆ ಪೌಲನೆ ಮನ ಬುಲೈನ್, ಆ ಛೋ಼ಕ್ರಾನ ಸೇನಾಧಿಪತಿಕನ ಲೀನ್‍ಜಾ಼ತೆ, ಇನ ಏಕ್‌ ವಾತ್‍ಬೋಲ್ನುಕರಿ ಛಾ಼” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","ಸೇನಾಧಿಪತಿನೆ ಯೋ ಜ಼ವಾನಿ ಛೋ಼ಕ್ರಾನ ಹಾತ್‍ಧರೀನ್ ಏಕ್ಲನಾಸ್ ಏಕಾಡಿ ಬುಲೈಲೀಜೈ಼ನ್, “ತೂ ಶಾತ್ ಬೋಲ್ನುಕರಿ ಛಾ಼?” ಕರಿ ಪುಛಾ಼ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","ತದೆ ಯೋ ಜ಼ವಾನಿ ಛೋ಼ಕ್ರಾನ, “ಪೌಲನಿ ಬಾರೇಮ ಘಣು ಮಾಲುಮ್ ಕರಿಲೇವ್ಣುಕರಿ ಭಾಣುಕರೀನ್, ಕಾಲ್ನ ನ್ಯಾವ್‍ನಿ ಸಭೆಮ ಪೌಲನ ಬುಲೈಲಿನ್ ಆವ್ಣುಕರಿ ತುನ ಯೆಹೂದ್ಯರ್ ಖ್ಹಾರು ಬೋಲಾನ ಕರುಕರಸ್. ");
INSERT INTO vaa_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","ಕತೋಬಿ ಇವ್ಣಪರ್ ವಿಶ್ವಾಸ್ ನಕೊ ಕರಿಶ್. ಪೌಲನ ಮಾರಾನಖ್ಹಾಜೆ ಚಾ಼ಳಿಖ್ಹ್‌ಥೀಬಿ ಜಾ಼ಖ್ಹತ್ ಯೆಹೂದ್ಯರ್‌ಖ್ಹಾರು ಲಪೀನ್ ಟಿವೈರ‍್ಹುಸ್ ಇವ್ಣೆ ಇನ ಮಾರ‍್ವಲಗು ಶಾತ್ಬಿ ಖಾಶು ಕೊಯ್ನಿ ಕರಿ ಆಣ್‌ಕರ‍್ಯು ಅಜು಼. ಹಮ್ಕೆ ತಾರಿ ಹುಕುಮ್‌ನಖ್ಹಾಜೆ ಟಿವೈರ‍್ಹೂಸ್” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","ತದೆ ಸೇನಾಪತಿನೆ ಯೋ ಜ಼ವಾನಿ ಛೋ಼ಕ್ರಾನ, “ಇವ್ಣಿ ಮಶ್ಲತ್ನಿ ಬಾರೇಮ ಬೋಲಿರಾಖ್ಯೊಸ್‍ಕರಿ ಕಿನಾಬಿ ನಕೊ ಬೋಲ್” ಕರಿ ಅಜು಼ ಜ಼ವಾನಿ ಛೋ಼ಕ್ರಾನ ಹುಕುಮ್‌ದೀನ್ ಮೋಕ್ಲಿದಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","ಇನಪಾರ್ ಖ್ಹೋಶಿಪಾಯಿನ ಮೋಟಾನೆ ಬೇಜ಼ಣ ಸೇನಾಧಿಕಾರಿನ ಬುಲೈನ್ ಇವ್ಣುನ, “ಆ ರಾತ್ ನೌಘಂಟಾನ ಕೈಸರೈ ಖ್ಹಯೇರ‍್ನ ಜಾ಼ವಾನ ಬೇಖ್ಹೋ ಶಿಪಾಯಿನಾಬಿ, ಖ್ಹಡ್‌ತೀನಿಖ್ಹ್‌ ಅದ್ಮಿ ಘೋಡಾಚ಼ಲಾವಳನಾಬಿ, ಬೇಖ್ಹೊ ಅದ್ಮಿ ಭಾಲವಳಾನಾಬಿ, ತಯಾರ್‌ಕರೊ. ");
INSERT INTO vaa_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","ಅಜು಼ ಘೋಡಾನ ತಯಾರ್‌ಕರ‍್ಲಿನ್, ಪೌಲನ ಬೆಖ್ಹಾಡಿನ್‌, ರಾಜ್ಯಪಾಲ್ ಹುಯಿರೋತೆ ಫೇಲಿಕ್ಸಕನ ಇನ ಜ಼ತನ್‍ಥೀಸ್‌ ಬುಲೈಲೀಜಾವ್ಣು” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","ಅಜು಼ ಸೇನಾಧಿಪತಿನೆ ಆ ನಾಹುಯಿನ್ ಇವ್ಣುನ ಅಮ್ ಏಕ್‌ ಚಿಟ್ಟಿ ಲೀಖಿನ್ ದಿದೊ: ");
INSERT INTO vaa_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“ಮಹಾಪ್ರಭು ಹುಯಿರೋತೆ ರಾಜ್ಯಪಾಲ್ ಫೇಲಿಕ್ಸ್‌ನ ಕ್ಲೌದ್ಯ ಲುಸಿಯಸ್‍ನಿ ಖ್ಹಲಾಮ್. ");
INSERT INTO vaa_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","ಆ ಅದ್ಮಿನ ಯೆಹೂದ್ಯರ್‌ಖ್ಹಾರು ಧರೀನ್ ಮಾರಿನಾಕ್ಣುಕರಿ ಥೂ. ಕತೋಬಿ ಆ ರೋಮ್‌ನೊ ಪ್ರಜೆಕರಿ ಮಾಲುಮ್ ಪಡ್ಯು. ಮೇ ಶಿಪಾಯಿಖ್ಹಾರಾನಿ ಜೋ಼ಡೆಜೈ಼ನ್ ಛೋ಼ಡಾಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","ಇವ್ಣೆ ಶನ ಅನಪಾರ್ ಅಪರಾದ್ ನಾಖುಕರಸ್ ಕರಿ ಮಾಲುಮ್‌ ಕರಿಲ್ಯಾವಾನಖ್ಹಾಜೆ ಕರಿ ಅನ ಇವ್ಣೆ ನ್ಯಾವ್‍ನಿ ಸಬೆಮ ಮೇ ಬುಲೈಲಿನ್ ಗಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","ಮನ ಹಿಜ್ಜಾ಼ ಮಾಲುಮ್ ಪಡ್ಯುತೆ ಶಾತ್‍ಕತೊ ಪೌಲ ಖರಾಬ್ ಕಾಮ್ ಕರಿರಾಖ್ಯೊಸ್ ಕರಿ ಯೆಹೂದ್ಯರ್‌ಖ್ಹಾರು ಬೋಲ್ಯುತೋಬಿ, ಇವ್ಣು ಅಪರಾದ್ ಖ್ಹಾರು ಇವ್ಣ ಧರ್ಮಶಾಸ್ತ್ರನಿ ಬಾರೇಮಾನಿ ವಾತೆನ ಪಾಡೀನ್, ಇನಪರ್ ಅಪರಾದ್ ಢೋವಡ್ಯು ಪಣ್ಕಿ ಮರಣ್ ದಂಡನೆ ರ‍್ಹವೊ ಬೇಡಿ ಘಾಲಾನ ರ‍್ಹವೊ ಕರಾಖ್ಹರ‍್ಕಿ ಖೇವಿಬಿ ಅಪರಾದ್ ಕೋಥಿನಿ. ");
INSERT INTO vaa_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","ಕತೋಬಿ ಯೆಹೂದ್ಯರ್‌ಮ ಥೋಡುಜ಼ಣು ಪೌಲನ ಮಾರಿನಾಖನ ಮಶ್ಲತ್‌ ಕರುಕರಸ್‍ಕರಿ ಮನ ಮಾಲುಮ್ ಪಡ್ಯು. ಇನಖ್ಹಾಜೆ ಮೇ ಇನ ತುರಂತ್ ತರಾಕನ ಮೋಕ್ಲುಕರುಸ್. ಆಸ್ ಕಾಹೆತೆ, ಪೌಲನಪರ್ ಅಪರಾದ್ ನಾಖವಳಾನಾಬಿ ತಾರಸ್‍ಖ್ಹಾಮ್ಣೆ ಯೋ ಅಪರಾದ್ನಿ ವಾತೆ ಬೋಲಾನ ಹುಕುಮ್ ದೀರಾಖ್ಯೊಸ್”. ");
INSERT INTO vaa_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","ಶಿಪಾಯಿಖ್ಹಾರು ಇವ್ಣುನ ಹುಕುಮ್ ಹುಯುತೆ ತಿಮ್ಮಸ್ ಪೌಲನ ಇವ್ಣಿಜೋ಼ಡೆ ರಾತೋರಾತ್ ಬುಲೈಲಿನ್ ಅಂತಿಪತ್ರಿಕರಿ ಗಾಮ್‌ನ ಬುಲೈಲೀಗಯು. ");
INSERT INTO vaa_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","ಇನ ಅಗಲ್ಯದನ್ನೆ ಪೌಲನ ಜೋ಼ಡೆ ಅಗಾಡಿ ಜಾ಼ವಾನ ಘೋಡ ಚ಼ಲಾವವಾಳಾನ ಮ್ಹೇಲಿನ್, ಸಿಪಾಯಿಖ್ಹಾರು ಪಾಛು಼ಫರಿನ್ ಕೋಟೆನ ಆಯು. ");
INSERT INTO vaa_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","ಇವ್ಣೆ ಕೈಸರೈ ಖ್ಹಯೇರ‍್ನ ಜೈ಼ನ್, ರಾಜ್ಯಪಾಲ್‌ನ ಚಿಟ್ಟಿದಿದೊ. ಇನಪಾರ್ ಪೌಲಾನ ಇನ ಹಾತ್ಮ ದಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","ರಾಜ್ಯಪಾಲ್‌ನೆ ಚಿಟ್ಟಿ ಫಡೀನ್, ಇನೆ ಪೌಲನ, “ತು ಖೆವ ದೇಖ್ಹ್‌ನೊ?” ಕರಿ ಪುಛಾ಼ವಮ ಕಿಲಿಕ್ಯವಾಳೊ ಕರಿ ಮಾಲುಮ್‌ಪಡ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","ರಾಜ್ಯಪಾಲ್ನ, “ವಿರೋದ್ ಹುಯಿರ‍್ಹುತೆ ಯೆಹೂದ್ಯರ್‌ಖ್ಹಾರು ಹಜ್ಜಾ಼ ಆವಾದಿನ್, ಮೇ ತಾರ ಅಖ್ಖಾಸ್ ಕಾಮ್ನ ವಿಚಾರ್ ಕರಿಶ್” ಕರಿ ಬೋಲಿನ್ ಪೌಲನ ಹೆರೋದಾನಿ ಮಹೇಲ್‌ಮ ರಾಖಿನ್ ಕಾವ್ಲಿ ಕರ್ನುಕರಿ ಹುಕುಮ್‌ ದಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","ಪಾಚ಼್ ದನ್‍ಹುವಾದಿನ್ ಗಲ್‌ಢಯಾಜಕ್ ಅನನೀಯನೆ, ಯೆಹೂದ್ಯರ್‌ನ ಥೋಡಘಲ್ಡಾನ ಅಜು಼ ತೆರ್ತುಲ್ಯಕರಿ ಏಕ್‌ ವಕೀಲ್ನ ಬುಲೈಲಾಯಿನ್‌, ರಾಜ್ಯಪಾಲ್‌ನ ಖ್ಹಾಮ್ಣೆ ಪೌಲನ ಉಪ್ಪರ್ ಫಿರಾದ್ ಬೋಲಾನ ಕೈಸರೈ ಖ್ಹಯೇರ‍್ನ ಆಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","ಪೌಲನ ನ್ಯಾವ್‍ಮ ಬುಲೈಮಂಗಾಯು. ತದೆ ತೆರ್ತುಲ್ಯನೆ, ಪೌಲನ ಉಪ್ಪರ್ ಇನಿಅಪರಾದ್ನಿ ವಾತ್ನ ಢೊವಾಡನ ಶುರುಕರ‍್ಯೊ. “ಮಹಾ ಪ್ರಭು ಫಿಲಿಕ್ಸ್‌ ತಾರೆಥೀಸ್ ಹಮಾರು ಅದ್ಮಿಖ್ಹಾರು ಸಮಾಧಾನ್‌ಥಿ ಜಿವ್ಣು ಕರುಕರಸ್. ತಾರಿ ಖ್ಹೂಜ಼್‌ಥೀಸ್ ದೇಖ್ಹ್‌ಮ ಕೆತ್ರಿಕ್ಕಿ ಬಿಗ್‍ಡಿಹುಯಿ ಹಾಲತ್ನ ಖ್ಹುದಾರಿರಾಖ್ಯೊಸ್. ");
INSERT INTO vaa_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","ಹರೇಕ್ ಬಾಜೂ಼ಬಿ ಹರೇಕ್ ಪರಕ್‍ಮಾಬಿ ಘಣು ಧನ್ಯವಾದ್ ಕರೀನ್ ಅನ ಹಮೆ ಮಾನಿಲಿಯೇಸ್.” ");
INSERT INTO vaa_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","ಕತೋಬಿ ಮೇ ತಾರಿ ವಖ್ಹತ್‌ನ ಬಿಜೂ಼ಬಿ ಜಾ಼ಖ್ಹತ್ ಕೋಲೇವುಂತೆ ಥೋಡಿಸ್ ವಾತೆ ಬೋಲುಸ್. ದಯಾಕರೀನ್ ಖ್ಹಮಜ಼್‌ಣುಕರಿ ತಾರಾಮ ಗಿಂಗೈಲೆವುಸ್. ");
INSERT INTO vaa_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","“ಆ ಅದ್ಮಿ ಖರಾಬ್‌ಛಾ಼ ಅಜು಼ ಬರಾಬರ್‌ಕೊಯ್ನಿ ಜಗತ್‌ಮ ಕಿಜ್ಜಾ಼ಬಿ ರ‍್ಹವೊ, ಯೆಹೂದ್ಯರ್‌ಮ ಲಡೈ ಉಠಾಡ್ತೊ ಫಂಡಸ್‌ಕರಿಬಿ, ಆ ನಜ಼ರೇತ್‌ನಿ ಖೂಮ್ನೊ ಮೋಟೊ ಕರಿಬಿ ಹಮೆ ದೇಖ್ಯ. ");
INSERT INTO vaa_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","ಆ ನಾಹುಯಿನ್ ಆ ಅದ್ಮಿ ದೇವ್ನಿ ಮಂದಿರ‍್ನ ಮೈಲುಕರಾನ ಕೋಶಿಶ್ ಕರ‍್ಯೊ. ಇನಾಖ್ಹಾಜೆ ಹಮೆ ಇನ ಬಂಧಿಕರ‍್ಯಾ. ಹಮೆ ಹಮಾರ ಶೊಂತ್ ನಿಯಮ್‌ನಿ ಪರಕ್ಮ ತೀರ್ಪ್ ಕರ್ನುಕರಿ ಖ್ಹೂಜ಼್‌ಕರ‍್ಯ. ");
INSERT INTO vaa_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","ಕತೋಬಿ ಸೇನಾಧಿಪತಿನ ಮೋಟೊ ಲುಸಿಯಸ್‍ ಆಯೊ.ಅಜು಼ ಖ್ಹತಾವನ ಪರಕ್ಮ ಹಮಾರಕಂಥು ಛೋ಼ಡೈಲೀನ್ ಗಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","ತದೆ ಲೂಸಿಯಸ್ನೆ ಇನ ಗಲತ್‌ ಲಗಾಡವಾಳನ ತಾರ ಖ್ಹಾಮ್ಣೆ ಆವಾನ ಹುಕುಮ್ ದಿದೊ. ತೂ ಅನ ಬೋಲಾಮಸ್, ಹಮೆ ಅನ ವಿರೋದ್‌ ಬೋಲುಕರೇತೆ ವಾತೆಖ್ಹಾರಿ ಖ್ಹಾಚಕರಿ ತುನ ಮಾಲುಮ್ ಪಡ್‌ಶೆ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","ತದೆ ಯೆಹೂದ್ಯರ್ ಖ್ಹಾರು ಯೋ ವಕೀಲ್ನಿಜೋ಼ಡ್ಮ ಮಳಿನ್ ಆ ಬೋಲುಕರಾತೆ ವಾತೆಖ್ಹಾರಿ ಖ್ಹಾಚಿಸ್‌ಕರಿ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","ರಾಜ್ಯಪಾಲ್‌ನೆ ಪೌಲನ, ತೂ ವಾತೆ ಬೋಲೆಜಾ಼ಯ್‌ ಕರಿ ಖ್ಹಂಜ಼್‌ಕಾರ್‌ ದ್ಯವಾಮ ಇನೆ ಪಾಛೊ಼ ಜ಼ವಾಬ್ ಶಾತ್‍ದಿದೋಕತೊ “ತೂ ಮನ ಕೈಏಕ್ ವರಖ್ಹ್‌ಥು ಆ ದೇಖ್ಹ್‌ನೊ ನ್ಯಾವ್‍ಣೊ ಬಣಿರೋಸ್ ಕರಿ ಮನ ಮಾಲುಮ್‌. ಇನಖ್ಹಾಜೆ ಖುಷಿಥಿ ಫೇಡ್‍ ದೆವುಸ್‌. ");
INSERT INTO vaa_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","ಮೇ ದೇವ್ನಿ ಆರಾದನೆ ಕರಾನ ಯೆರೂಸಲೇಮ್ನ ಜೈ಼ನ್, ಭಾರ ರೋಜ಼್ ಖಲಿ ಹುಯಿರಾಥ ಕರಿ ತೂ ಮಾಲುಮ್ ಕರಿಲೀಯೆಜಾ಼ಯ್. ");
INSERT INTO vaa_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","ಹಿಜ್ಜಾ಼ ದೇವ್ನಿಮಂದಿರ್‌ಮ ರ‍್ಹವೊ, ಸಬೆನ ಸಬಾಮಂದಿರ್‌ಮ ರ‍್ಹವೊ, ಖ್ಹಯೇರ್‌ಮ ರ‍್ಹವೊ, ಮೇ ಯೆಹೂದ್ಯರ್‌ನ ಜೋ಼ಡ್ಮಾಬಿ ಅಬ್ಬಾಜ಼ಬ್ಬಿ ಬೋಲುಕರಾನು ರ‍್ಹವೊ ನತರ್ ಟೋಳ್‌ ಭಂದಾವನು ರ‍್ಹವೊ ಅವ್ಣೆ ದೇಖ್ಯಕೊಯ್ನಿ. ");
INSERT INTO vaa_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","ಹಮ್ಕೆ ಮಾರಪರ್ ಇವ್ಣೆ ಢೋವಾಡುಕರಾತೆ ಗಲತ್‌ನ, ಸಬೂತ್‌ಕರಿ ತಾರಖ್ಹಾಮ್ಣೆ ಓತಾಳನ ಕೋ ಉಶೇನಿ. ");
INSERT INTO vaa_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","ಕತೋಬಿ ಏಕ್‌ ಖಲಿ ತಾರ ಖ್ಹಾಮ್ಣೆ ಮಾನಿಲೆವುಸ್‌, ಶಾತ್‌ಕತೊ, ಧರ್ಮವಿರೋದಿಕರಿ ಬೋಲಾನು ಮಾರಗ್‍ಮ ಚಾ಼ಲವಾಳೊ ಮೇ ಮಾರ ಗುರುಗುರಬ್‍ಲ್ಯನ ದೇವ್ನ ಆರಾದನೆ ಕರುಸ್. ಕತೋಬಿ ಮೋಶೇನು ಧರ್ಮಶಾಸ್ತ್ರನು ಪ್ರವಾದನೆ ದಪ್ತರ್‌ಮ ಲೀಖೈರುತೆ ಯೊ ಅಖ್ಖಾಸ್ನ ವಿಶ್ವಾಸ್ ಕರುಸ್. ");
INSERT INTO vaa_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","ಆ ನಾಹುಯಿನ್ ನೀತಿವಾಳನಾಬಿ ಅನೀತಿವಾಳನಾಬಿ ಖ್ಹಾರೂಸ್ ಪಾಛು಼ಜಿವ್ತು ಉಷೆಕರಿ ಆ ಯೆಹೂದ್ಯರ್ ದೇವ್‌ಮ ಖಿವಿ ಪರಕ್ಮ ಭರೋಖ್ಹೊ ರಾಖಿರಾಖ್ಯುಸ್ಕಿ ಯೋಸ್ ಪರಕ್ಮ ಮೇಬಿ ಭರೋಖ್ಹೊ ಕರಿರಾಖ್ಯೊಸ್. ");
INSERT INTO vaa_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","ಇನಾಖ್ಹಾಜೆ ದೇವ್ ಬಿಜು಼ ಅದ್ಮಿನ ಖ್ಹಾಮ್ಣೆ ಮಾರೇಥಿ ಹುವಾಯೆತ್ರೆ ದಿಲ್ನಿಸಾಕ್ಷಿನ ಕದೇಬಿ ಪಾಕ್‌ ರಾಖಾನ ಕೋಶಿಶ್ ಕರುಸ್. ");
INSERT INTO vaa_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","“ಥೋಡ ವರಖ್ಹ್‌ನ ವಾರ್ ಮೆ, ಮಾರ ಶೊಂತ್‌ ದೇಖ್ಹ್‌ವಾಳಾನ ಪೈಶಾ, ಕಾಣ್ಕೆ ಅಜು಼ ಮುಡಪ್‍ ದ್ಯಾವಾನ ಆಯೋಥೊ. ");
INSERT INTO vaa_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","ಮೇ ಶುದ್ದಿ ಕರಿಲೀನ್ ಯೋ ಖ್ಹಾರು ದೆವ್‍ಕರಾನಿ ವಖ್ಹತ್‌ಮ ಮನ ಅವ್ಣೆ ದೇವ್ನಿಮಂದಿರ್‌ಮ ದೇಖ್ಯು; ತದೆ ಮಾರಿಜೋ಼ಡ್ಮ ಅದ್ಮಿನು ಝೂ಼ಂಡ್‌ಬಿ ಶಾತ್ ಕೋಥೂನಿ, ಗಲಾಟ್‍ಬಿ ಕೋಥಿನಿ. ಮನ ದೇಖ್ಯುತೆ, ");
INSERT INTO vaa_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","ಏಷ್ಯ ತಬರ್‌ಖಾಥು ಆಯುತೆ ಥೋಡು ಯೆಹೂದ್ಯರ್ ಮಾರಾಮ ಶನೂಬಿ ಗಲತ್‌ ಉಷೇತೊ ಇವ್ಣೆ ತಾರಾಖ್ಹಾಮ್ಣೆ ಮಾರಪರ್ ವಿರೋದ್‌ಕರಾನ ಹಜ಼್ಜ ಆವ್ಣುಥು. ");
INSERT INTO vaa_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","ನಾಹುಯುತೊ, ಹಜ಼್ಜ ರ‍್ಹವಾಳು ಮೇ ನ್ಯಾವ್‍ನಿ ಸಬೆನಖ್ಹಾಮ್ಣೆ ಭೀರ‍್ಯವಾನಿವಖ್ಹತ್ಮ, ಮಾರಾಮ ಶನು ಅಪರಾದ್ ದೇಖ್ಯುಕರಿ ಬೋಲಾದೆ. ");
INSERT INTO vaa_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","ಮೇ ಇವ್ಣ ಖ್ಹಾಮ್ಣೆ ಭಿರೀನ್; ಪಾಛು಼ಜಿವ್ತು ಉಟ್‍ಶೇತೆ ಇನಿ ಬಾರೇಮ ಮೆ ವಿಶ್ವಾಸ್ ಕರ‍್ಯೊತೆ ಖ್ಹಾಜೆ ಹಜ಼್ಜ ನ್ಯಾವ್‌ಮ ಭೀಯೊಸ್ತೆ’ ಕರಿ ಮೆ ಎಕ್ಕಸ್ ವಾತೆನ ಚಿಕ್ರಿ ಬೋಲ್ಯೊ.” ");
INSERT INTO vaa_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","ಫೇಲಿಕ್ಸನೆ ಆ ಮಾರಗ್‌ನ ಬಾರೇಮ ಪಹಿಲೇಸ್ ಕೆತ್ರಕ್ಕಿ ಮಾಲುಮ್‌ ಕರಿರಾಖ್ಯೊಥೊ. ಇನಖ್ಹಾಜೆ ನ್ಯಾವ್‍ಕರಾನು ಭೀರಾಖಿನ್, “ಸೇನಾಧಿಪತಿ ಹುಯಿರ‍್ಹೋತೆ ಲುಸಿಯಸ್‍ ಹಜ಼್ಜ ಆವಾದಿನ್ ಆ ವಾತ್ನಿ ಬಾರೇಮ ತೀರ್ಪ್ ಕರಿಶ್” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","ಇನಕೇಡೆಥು ಪೌಲನ ಕಾವ್ಲಿಮ ರಾಖೇಜಾ಼ಯ್‌, ಕತೋಬಿ ಇನ ಶಾತ್ಬಿ ಅಡ್ಡಿ ನಾಕರ‍್ನು, ಇನ ದೇಖಿಲ್ಯವಾಳು ಇನ ಖ್ಹದ್ದರ್‌ಕರೀನ್ ಆಡು ಶಾತ್ಬಿ ನಾಕರ‍್ನುಕರಿ ಖ್ಹೋಶಿಪಾಯಿನ ಮೋಟಾನೆ ಹುಕುಮ್‌ ಕರ‍್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","ಥೋಡದನ್ನ ಪಾರ್ ಫೇಲಿಕ್ಸ್‌ ಇನಿ ಬಾವಣ್‍ ಹುಯಿರೀತೆ ದ್ರೂಸಿಲ್ಲಾನಿ ಜೋ಼ಡ್ಮ ಆಯೊ. ಯೋ ಯೆಹೂದ್ಯವಾಳಿ ಹುಯಿರ‍್ಹೀಥಿ. ಫೇಲಿಕ್ಸನೆ ಪೌಲನ ಬುಲೈಮಂಗೈನ್‌, ಯೋ ಕ್ರಿಸ್ತಯೇಸುನ ವಿಶ್ವಾಸ್‍ಕರಾನಿ ಬಾರೇಮ ವಾತೆ ಬೋಲಾನು ಖ್ಹಮ್‍ಜ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","ಕತೋಬಿ ಪೌಲನೆ, ನೀತಿ,ಅಜು಼ ಇನುಯೋ ದಾಬುಕ್ ರ‍್ಹವಾನು, ಅಜು಼ ಖ್ಹಾಮ್ಣೆ ಉಳ್ಯಾವತೆ ನ್ಯಾಯತೀರ್ಪ್‌ನಿ ಬಾರೇಮ ಬೋಲಾಮ ಫೇಲಿಕ್ಸನೆ ಡರಿನ್, “ಹಮ್ಕೆ ತೂ ಜಾ಼ ಮನ ವಖ್ಹತ್ ಮಳಾದಿನ್ ತುನ ಬುಲೈಮಂಗೈಷ್” ಕರಿಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","ಯೋಸ್ ವಖ್ಹತ್‌ಮ ಫೇಲಿಕ್ಸನೆ, ಪೌಲ ಶಾತ್ತೋಬಿ ಪೈಶಾ ದೇಸ್ಕಿಶುಕಿ ಕರಿ ಭರೋಖ್ಹೊ ಕರೀನ್, ಕದೆಕದೇಬಿ ಇನ ಬುಲೈಮಂಗೈನ್‌ ಇನಿಜೋ಼ಡ್ಮ ಪೊಖ್ಹ್‌ಲಾವ್ತೊ ರ‍್ಹೇತೊಥೊ. ");
INSERT INTO vaa_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","ಬೇ ವರಖ್ಹ್‌ನ ವಾರ್ ಫೇಲಿಕ್ಸ್‌ನ ಬದಲ್ ಪೋರ್ಕಿಯ ಫೆಸ್ತ ಕರಿ ರಾಜ್ಯಪಾಲ್‌ಹುಯಿನ್ ಆಯೊ. ಫೇಲಿಕ್ಸನೆ ಯೆಹೂದ್ಯರ್‌ನಿ ಪ್ಯಾರ್ ಕಮಾವ್ಣು ಕರಿ ಆಖ್ಹ್‌ಕರೀನ್ ಪೌಲನ ಜೇಲ್‌ಮಾಸ್ ಮ್ಹೆಂದಿನ್ ಗಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","ಫೆಸ್ತನೆ ಅಧಿಕಾರ್‌ಲೀನ್ ತೀನ್‌ದನ್ನ ಬಾದ್ಮ ಕೈಸರೈಯಾಥು ಯೆರೂಸಲೇಮ್ನ ಗಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","ಹಿಜ್ಜಾ಼ ಗಲ್‌ಢಯಾಜಕ್‌ಬಿ ಅಜು಼ ಯೆಹೂದ್ಯರ್‌ನ ಘಲ್ಡಾವ್‌ನ ಪೌಲನಿ ವಿರೋದ್ ಛಾ಼ಡಿ ಬೋಲ್ಯೊ. ಇನ ಯೆರೂಸಲೇಮ್ಮ ಪಾಛು಼ ಮೋಕಲ್ನುಕರಿ ಇವ್ಣೆ ಪೆಸ್ತಾನ ಗಿಂಗೈಲಿದು. ");
INSERT INTO vaa_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","ತೂ ದಯಾಕರೀನ್ ಇನ ಯೆರೂಸಲೇಮ್‌ನ ಮೋಕಲ್ನುಕರಿ ಪೌಲನ ಕೇಡ್ನಖ್ಹಾಜೆ‍ ಸೋಚ್ಯು. ಶನಕತೊ ಜಾ಼ವಾನ ಮಾರಗ್‌ಪರ್ ಇನ ಮಾರಿನಾಕ್ಣುಕರಿ ಜ಼ಪಿರ‍್ಹೂಥು. ");
INSERT INTO vaa_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","ಫೆಸ್ತನೆ ಅಮ್ ಜ಼ವಾಬ್ ದಿದೊ; ಪೌಲ ಕೈಸರೈನ ಖ್ಹಾರ್ಕೊಟ್‌ಮ ಛಾ಼. ಮೇ ಹಿಜ್ಜಾ಼ ಒಗ್ಗೀಸ್ ಪಾಛೊ಼ ಜಾ಼ವ್ಣುಕರಿ ಛೂ಼. ");
INSERT INTO vaa_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","ಇನಖ್ಹಾಜೆ ತುಮಾರಮ ಅಧಿಕಾರ್‌ವಾಳು ಮಾರಕೇಡೆ ಕೈಸರೈಮ ಐನ್ ಯೋ ಅದ್ಮಿಮ ಅಪರಾದ್ ಶನುತೋಬಿ ಉಷೇತೊ ಇನಾಪರ್ ಗಲ್ತಿ ಲಗಾಡೊ ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","ಫೆಸ್ತನೆ ಇವ್ಣಜೋ಼ಡ್ಮ ಆಟ್‍ಥಿ ಧರೀನ್ ದಖ್ಹ್‌ರೋಜ್‌ಲಗು ರ‍್ಹೀನ್ ಇನಪಾರ್ ಯೋ ಕೈಸರೈನ ಗಯೊ. ಬಿಜೇಕ್‍ದನ್ನೆ ನ್ಯಾವ್‍ನಿ ಝ಼ಗೋಮ ಜೈ಼ನ್ ಪೌಲನ ಬುಲೈಲಿನ್ ಆವ್ಣುಕರಿ ಶಿಪಾಯಿ ಹುಕುಮ್ ಕರ‍್ಯೊ. ಫೆಸ್ತ ನ್ಯಾವ್‍ನಿ ಝ಼ಗೋಮ ಬೆಠೋಥೊ. ");
INSERT INTO vaa_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","ಯೆರೂಸಲೇಮ್‌ಥು ಆಯುಥೂತೆ ಯೆಹೂದ್ಯರ್, ಪೌಲ ಹಿಜ್ಜಾ಼ ಆವಾದಿನ್ ಇನ ಅಶ್‌ಪಿಶ್ ಭೀರಿನ್ ಇನಪರ್ ಘಣು ಗಲತ್‌ ಲಗಾಡ್ಯು. ಇವ್ಣೆ ಶಾತ್ಬಿ ಸಾಬಿತ್ ಕರಾನ ಕೋಹುಯುನಿ. ");
INSERT INTO vaa_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","ಕತೋಬಿ ಪೌಲನೆ ಜ಼ವಾಬ್ ದೇತೊಹುಯಿನ್, “ಮೇ ಯೆಹೂದ್ಯರ್‌ನಿ ಧರ್ಮಶಾಸ್ತ್ರನಿ ವಿರೋದ್ ರ‍್ಹವೊ ದೇವ್ನಿಮಂದಿರ್‌ನಿ ವಿರೋದ್ ರ‍್ಹವೊ, ಚಕರ್‌ವರ್ತಿನಿ ಬಾರೇಮ ರ‍್ಹವೊ, ಮೇ ಖಿವು ಗಲ್ತಿಬಿ ಕರ‍್ಯೊಕೊಯ್ನಿ.” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","ಕತೋಬಿ ಫೆಸ್ತನೆ ಯೆಹೂದ್ಯರ್‌ಥಿ ದಯಾನ ಲ್ಯವಾನಖ್ಹಾಜೆ ಪೌಲನ “ತೂ ಯೆರೂಸಲೇಮ್ಮ ಜಾ಼ವನ ಕೋಶಿಶ್ ಕರಾನಿವಖ್ಹ್‌ತೆ, ಹಿಜ್ಜಾ಼ ಮಾರಖ್ಹಾಮ್ಣೆ ಆ ಗಲ್ತಿನಿ ಬಾರೇಮ ತೀರ್ಪ್‌ ಕರಿಲೇವ್ಣುಕರಿ, ತುನ ಖ್ಹಯಾಲ್ ಛಾ಼ಕಿ ಶು? ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","ತದೆ ಪೌಲನೆ ಬೋಲ್ಯೊ, “ಮೆ ಹಮ್ಕೆ ಕೈಸರ್‌ನ ನ್ಯಾವ್ನಿಝ಼ಗೊಮಾಸ್ ಭಿಯೋಸ್; ಮನ ತೀರ್ಪ್‌ಕರ‍್ನುತೆ ಹಜ್ಜಾ಼ಸ್. ಯೆಹೂದ್ಯರ್‌ನ ಮೆ ಶನು ಠಗಾಯೊ ಶಾತ್‌ಕೊಯ್ನಿ ಕರಿ ಬೋಲಾನು ತುಮುನಾಬಿ ಅಛ್ಛಿನಿತರ ಮಾಲುಮ್‌ಛೆ. ");
INSERT INTO vaa_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","ಮೇ ಅನ್ಯಾಯ್ ಕರವಾಳೊ ಹುಯಿನ್ ಶಾತ್ತೋಬಿ ಕರವಾಳೊ ಹುಯಿನ್ ಧರ್ಮಶಾಸ್ತ್ರನಿ ಪರಕ್ ಮನ ಮರಣ್ ದಂಡಣೆನ ಕಾರಣ್ ಹುಯೋತೊಬಿ ಇನ ಮೆ ಮಾನಿಲೇವ್ಸ್. ಕತೋಬಿ ಅವ್ಣೆ ಪೊಳ್ ಗಲತ್‌ನ ಮಾರಪರ್ ನಾಖನುರ‍್ಹಯೂತೊ, ಮನ ಕೋಣ್‌ಬಿ ಅವ್ಣ ಹಾತ್‌ಮ ದ್ಯವಾನ ಕೋ ಉಶೇನಿ. ಮೆ ಕೈಸರ್‌ನ ಖ್ಹಾಮ್ಣೆ ಬೋಲಿಲೆವುಸ್” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","ತದೆ, ಫೆಸ್ತನೆ ಇವ್ಣಸಭೆವಾಳಾನಿ ಜೋ಼ಡ್ಮ ಚರ್ಚೆಕರೀನ್ ತದೆ ಪೌಲನ, “ತೂ ಕೈಸರನ ಖ್ಹಾಮ್ಣೆ ಬೋಲಿಲೆವುಸ್‌ಕರಿ ಬೋಲ್ಯೊನಿ, ಇನಖ್ಹಾಜೆ ಕೈಸರಕನಾಸ್ ಜಾ಼ವ್ಣುಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","ಥೋಡದನ್ನ ಬಾದ್ಮ ಅಗ್ರಿಪ್ಪ ರಾಜ಼ಬಿ ಬೆರ್ನಿಕೆನಿ ಜೋ಼ಡ್ಮ ಫೆಸ್ತನ ಮಳಾನಖ್ಹಾಜೆ ಅಜು಼ ಸ್ವಾಗತ್ ಕರಾನ ಕೈಸರೈಮ ಆಯು. ");
INSERT INTO vaa_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","ಇವ್ಣೆ ಖ್ಹುಮಾರ್‌ದನ್ ಹಿಜ್ಜಾ಼ಸ್ ರಹಿಗು. ಇನಖ್ಹಾಜೆ ಫೆಸ್ತನೆ ಪೌಲನಿ ಬಾರೇಮ ರಾಜ಼ನ ಖ್ಹಮ್‌ಜಾ಼ಡ್ಯೊ ಶಾತ್‌ಕತೊ, “ಫೇಲಿಕ್ಸನೆ ಖ್ಹಾರ್ಕೊಟ್‌ಮಾಸ್ ಮ್ಹೇಲಿನ್ ಗಯೋತೆ ಏಕ್‍ಜ಼ಣೊ ಛಾ಼. ");
INSERT INTO vaa_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","ಮೆ ಯೆರೂಸಲೇಮ್ಮ ರ‍್ಹವಾನಿವಖ್ಹ್‌ತೆ ಯೆಹೂದ್ಯರ್‌ನ ಗಲ್‌ಢಯಾಜಕ್‍ಖ್ಹಾರು ಅಜು಼ ಗಲ್‌ಢಖ್ಹಾರು ಇನಿ ಬಾರೇಮ ಮನ ಆರೋಪ್ ಬೋಲಿನ್ ಇನ ತೀರ್ಪ್‌ಹುವಾದೆ ಕರಿ ಗಿಂಗಾಯು. ");
INSERT INTO vaa_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","ಮೆ ಇವ್ಣುನ; ಅಪರಾದಿಬಿನ್ ಅಪರಾದ್ ಲಗಾಡವಾಳು ಆಮಖ್ಹಾಮೆ ಭೀರೆವ್ಣು; ಇನಾಪರ್ ಲಗಾಡಿರಾಖ್ಯುತೆ ಅಪರಾದ್ನ ವಿರೋದ್ ಜ಼ವಾಬ್‍ದ್ಯವಾನ ಅಪರಾದಿನ ಅವಕಾಶ್ ಕರಿದೇವ್ಣು. ಇಮ್‌ ಕರ‍್ಯುಕೊಂತೆ ಹಾತ್ಮ ನೇರ್ ದೀನಾಖನು ರೋಮ್ನಿ ಪದತ್ತಿಕಾಹೆ ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","“ಇವ್ಣೆ ಹಜ಼್ಜ ಮಳಿನ್ ಆವಖ್ಹತರ್ ಮೇ ಜ಼ರಾಬಿ ಧೀರ್‌ಕೊಂತೆ ಬಿಜೇಕ್ ದನ್ನೇಸ್ ನ್ಯಾವ್‍ನಿ ಝ಼ಗೋಪರ್ ಬೇಶಿನ್ ಯೋ ಅದ್ಮಿನ ಬುಲಾವ್ಣುಕರಿ ಹುಕುಮ್ ದಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","ಯೆಹೂದ್ಯರ್ ಉಠಿಭೀರಿನ್ ಇನ ಉಪ್ಪರ್ ಅಪರಾದ್ ಲಗಾಡ್ಯು. ಕತೋಬಿ ಮೇ ಸೋಚಾನಿ ಪರಕ್ಮ ಇವ್ಣೆ ಇನಾಪರ್ ಖಿವು ಖರಾಬ್ ಅಪರಾದ್‍ಬಿ ಕೊ ಲಗಾಡ್ಯನಿ. ");
INSERT INTO vaa_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","ಇವ್ಣೆ ಬೋಲ್ಯುತೆ ವಾತೆಖ್ಹಾರು ಇವ್ಣ ಶೊಂತ್ ಧರ್ಮಾನು ಸಂಬಂದ್‌ನಿತರ ಹುಯಿರೂಥು. ಅಜು಼ ಯೇಸುಕರಿ ಏಕ್‍ಜ಼ಣ ಭಣೀಥು ಆ ವಿವಾದ್ ಹುಯಿರ‍್ಹುಥು. ಮರಿಗಯೋತೆ ಯೇಸು ಹಮ್ಕೆ ಜಿವ್ತೊ ಛಾ಼ ಕರಿ ಪೌಲನೆ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","ಆ ವಾತೆನಿ ಬಾರೇಮ ಮನ ಜಾ಼ಖ್ಹತ್ ಮಾಲುಮ್ ಕೊಥುನಿ ಇನಾಖ್ಹಾಜೆ ಮೇ ಪುಛಾ಼ವನ ಕೊಗಯೋನಿ ಕತೋಬಿ ಮೇ ಪೌಲನ, ‘ತೂ ಯೆರೂಸಲೇಮ್ಮ ಜೈ಼ನ್ ನ್ಯಾವ್ನ ತೀರ್ಮಾನ್ ದೇವ್ಣುಕರಿ ಮೆ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","ಇನಾಖ್ಹಾಜೆ,ಪೌಲನೆ ‘ಚಕರ್‌ವರ್ತಿ ಕೈಸರ್‌ಥೀಸ್ ಮಾರು ಜಾವಾಬ್‍ನ ಪೂಚ್‌ತಾಚ಼್‌ ಹುವಾದೆ ತಬ್‍ಲಗು ಮನ ಬಚಾ಼ಡ್ಣು’ ಕರಿ ಬೋಲಿಲಿದೊ. ಇನಾಖ್ಹಾಜೆ ರೋಮ್‍ನ ಚಕರ್‌ವರ್ತಿಕನ ಮೋಕ್ಲಲಗು ಇನ ಕಾವ್ಲಿಮ ರಾಕ್ಣುಕರಿ ಹುಕುಮ್‌ದಿದೊ”. ");
INSERT INTO vaa_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","ಅಗ್ರಿಪ್ಪನೆ ಫೆಸ್ತನ, “ಆ ಅದ್ಮಿ ಬೋಲಾಸ್ತೆ ಖ್ಹಮ್‌ಜಾ಼ನ ಮನಾಬಿ ಪಸಂದ್ ಛಾ಼” ಕರಿ ಬೋಲ್ಯೊ. ಪೆಸ್ತಾನೆ, “ಯೋ ಬೋಲಾನು ತೂ ಕಾಲೆ ಖ್ಹಮ್‍ಜೆಜಾ಼ಯ್” ಕರಿ ಜ಼ವಾಬ್ ದಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","ಅಗಲ್ಯದನ್ನೆ ಅಗ್ರಿಪ್ಪರಾಜ಼ ಅಜು಼ ಬೆರ್ನಿಕೆರಾಣಿ ಘಣು ರಂಗ್‌ರಾಜ಼್‌ಥಿ ಶಿಪಾಯಿನ ಮೋಟಕನ ಅಜು಼ ಕೈಸರೈನ ಗಲ್‌ಢವ್‍ನಿ ಜೋ಼ಡ್ಮ ಸಭೆನ ಆಸ್ತಾನ್ಮ ಆವಖ್ಹತರ್. ಪೌಲಾನ ಮಹಿ ಬುಲೈಲಿನ್ ಆವ್ಣುಕರಿ ಫೆಸ್ತನೆ ಶಿಪಾಯ್ನ ಹುಕುಮ್‌ ಕರ‍್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","ತದೆ ಫೆಸ್ತನೆ, “ರಾಜ಼ ಅಗ್ರಿಪ್ಪ, ಹಮಾರ ಜೋ಼ಡ್ಮ ಮಳಿಐರ‍್ಹಾತೆ ಖ್ಹಾರಾಸ್ ಅದ್ಮಿವೊ; ತುಮೆ ದೇಖುಕರಾತೆ ಆ ಅದ್ಮಿನಪರ್ ಹಜ್ಜಾ಼ಛಾ಼ತೆ ಅಜು಼ ಯೆರೂಸಲೇಮ್ಮ ರ‍್ಹವಾಳು ಖ್ಹಾರುಸ್ ಯೆಹೂದ್ಯರ್ ಮನ ಗಲತ್‌ ಬೋಲಿನ್, ಆ ಜಿವ್ತೊ ನಾರ‍್ಹೇಣು ಕರಿ ಚಿಕ್ರಾಣ್ ಮಾರ‍್ಯು. ");
INSERT INTO vaa_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","ಮೇ ಅನ ವಿಚಾರ್ ಕರಾನಿ ವಖ್ಹ್‌ತೆ ಶನು ಝೂ಼ಟುಬಿ ಕೋ ದೇಖ್ಯೋನಿ ಕತೋಬಿ ಕೈಸರ್‌ಥೀಸ್ ನ್ಯಾವ್‌ನು ತೀರ್ಪ್‌ಹುವಾದೆ ಕರಿ ಬೋಲಿಲಿದೊ. ಇನಖ್ಹಾಜೆ ಅನ ರೋಮ್‍ನ ಮೋಕ್ಲಾನ ತೀರ್ಮಾನ್ ಕರಿರಾಖ್ಯೊಸ್. ");
INSERT INTO vaa_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","ಕತೋಬಿ ಅನಿ ವಾತೆನಿ ಬಾರೇಮ ಕೈಸರೈನ ಲೀಖಾನ, ಬರಾಬರ್‌ನು ಅಪರಾದ್ ಶಾತ್ಬಿ ಮನ ಕೊದೆಖಾವನಿ, ಇನಖ್ಹಾಜೆ ಮೇ ಅನ ತುಮಾರ ಖ್ಹಾರಾನ ಖ್ಹಾಮ್ಣೇಬಿ ವಿಶೇಷ್‌ಥಿ ಛಾ಼ತೆ ರಾಜ಼ ಅಗ್ರಿಪ್ಪನ ಖ್ಹಾಮ್ಣೆ ಲೈರಾಖ್ಯೊಸ್. ಇನಖ್ಹಾಜೆ ತುಮೆ ಅನ ವಿಚಾರ್‌ಕರೀನ್ ಅನಿ ಬಾರೇಮ ಇನ ಲೀಖಾನ ಶನಿತೋಬಿ ವಾತೆ ದಿಶುಕರಿ ಬೋಲಿನ್ ಟಿವೈರ‍್ಹೋಸ್. ");
INSERT INTO vaa_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","ಮೇ ಸೋಚಾನಿತರ ಏಕ್‌ ಖೈದಿನ ವಿರೋದ್ ಛಾ಼ತೆ ಅಪರಾದ್ನ ಮಾಲುಮ್ ನಾ ಕರ‍್ಯುತೊ ಇನ ಸೀಜರ್‌ಕನ ಮೋಕ್ಲಾನು ಬರಬ್ಬರ್‌ ಕೊಯ್ನಿಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","ಅಗ್ರಿಪ್ಪ ಪೌಲನ, “ಹಮ್ಕೇಥೊ ತಾರ ಭಣೀಥು ವಾತೆ ಬೋಲೆಜಾ಼ಯ್” ಕರಿ ಬೋಲ್ಯೊ. ತದೆ ಪೌಲನೆ ಹಾತ್‍ಪಾಡಿನ್ ಜ಼ವಾಬ್ ದೇತೊಹುಯಿನ್ ಅಮ್ ಬೋಲ್ಯೊ; ");
INSERT INTO vaa_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","ರಾಜ಼ ಅಗ್ರಿಪ್ಪ, ಯೆಹೂದ್ಯರ್ ಮಾರಪರ್ ಅಖ್ಖಿ ಅಪರಾದ್ ಕರಸ್ಕಿ ಆಜ಼್ ತಾರ ಖ್ಹಾಮ್ಣೆ ಇನು ಜ಼ವಾಬ್ ದ್ಯವಾನಿ ಅವಕಾಶ್ ಮಳಿರ‍್ಹೂತೆ ಮಾರು ಮೇಸ್ ಧನ್ಯಕರಿ ಬೋಲಿಲೇವುಸ್. ");
INSERT INTO vaa_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","ಶನಕತೊ ಯೆಹೂದ್ಯರ್‌ಮ ಛಾ಼ತೆ ಅಖ್ಖುಸ್ ಚಾ಼ಲ್ ಚ಼ಲಣ್‌ಬಿ, ಅಜು಼ ಯೆಹೂದ್ಯರ್ ವಿಚಾರ‍್ನ ವಾದಕರುಕರಾತೆ ಬಾರೇಮ ತುನ ಅಛ್ಛಿನಿತರ ಮಾಲುಮ್ ಛಾ಼. ಇನಖ್ಹಾಜೇಥಿ ಮಾರಿ ವಾತೆನ ಧೀಮೆಥಿ ಖ್ಹಮಜ಼್‌ಣು ಕರಿ ಗಿಂಗೈಲೆವುಸ್. ");
INSERT INTO vaa_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","“ಮೆ ಅಡ್ಡಾಣಿಥೋಬಿ ಯೆರೂಸಲೇಮ್ಮ ಮಾರ ಶೊಂತ್ ದೇಖ್ಹ್‌ನ ಅದ್ಮಿವೋನಿಜೋ಼ಡೆ ರ‍್ಹೀನ್ ಜಿವ್ಣುಕರ‍್ಯುತೆ ರೀತಿ ಅಖ್ಖು ಯೆಹೂದ್ಯರ್‌ನ ಮನ ಮಾಲುಮ್‌ ಛಾ಼. ");
INSERT INTO vaa_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","ಹಮಾರಿ ಧರ್ಮ್‌ನು ಜಾ಼ಖ್ಹತ್ ಕಠಣ್‍ಥಿ ರ‍್ಹವಾನು ಫರಿಸಾಯರ್‌ನು ಪದತ್ತಿನಿ ಅನುಸಾರ್ ಫರಿಸಾಯ ಹುಯಿನ್ ಚಾ಼ಲಿಲಿದೊಕರಿ ಶುರುವಾತ್‌ಥೂಬಿ ಇವ್ಣುನ ಮಾಲುಮ್‌ ಛಾ಼. ಸಾಕ್ಷಿ ಬೋಲಾನು ದಿಲ್‌ ಉಷೇತೊ ಬೋಲೆಜಾ಼ಯ್. ");
INSERT INTO vaa_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","ದೇವ್ನೆ ಹಮ್ಕೇಬಿ ಅಪ್ಣ ಗುರುಗುರಬ್‍ಲ್ಯನ ಕರ‍್ಯೊತೆ ವಾಗ್ದಾನ್ನ ಉಷೆಕರಿ ವಿಶ್ವಾಸ್ನಖ್ಹಾಜೆ ಮೇ ಆಜ಼್ ನ್ಯಾವ್‌ನಿ ವಿಚಾರಣೆಮ ಭಿಯೋಸ್. ");
INSERT INTO vaa_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","ಹಮಾರು ಭಾರ ಖೂಮ್‍ವಾಳು ದನ್‍ರಾತ್ ಭರೋಖ್ಹಾಥಿ ದೇವ್ನ ಆರಾದನೆ ಕರ್ತುಹುಯಿನ್, ಯೋ ವಾಗ್ದಾನ್ನುಫಲ್ ಲೀಲ್ಯಾವನಖ್ಹಾಜೆ ಟಿವೈರ‍್ಹೂಸ್. ರಾಜ಼, ಯೋಸ್ ಭರೋಖ್ಹಾನಿ ಬಾರೇಮ ಯೆಹೂದ್ಯರ್‌ಖ್ಹಾರು ಮಾರಿ ವಿರೋದ್ ಅಪರಾದ್ ಲಗಾಡುಕರಸ್. ");
INSERT INTO vaa_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","ದೇವ್ನೆ ಮರ‍್ಯಾಹುಯಮಾಥು ಉಠಾಡ್ಯೊತೆ ನಂಬಾನ ಕೊಹುವಾನಿಕರಿ ತುಮೆ ಶನ ಖ್ಹೂಜ಼್‌ ಕರೋಸ್? ");
INSERT INTO vaa_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","ಏಕ್‌ ಹಗಾಮ್ಮ ನಜ಼ರೇತ್‌ನು ಯೇಸುನ ನಾಮ್ನ ವಿರೋದ್‌ಥಿ ಕೈಏಕ್ ಕಾಮ್ನ ಮೆ ಚ಼ಲಾವ್ಣುಕರಿ ಸೋಚಿರಾಖ್ಯೋಥೊ. ");
INSERT INTO vaa_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","ಯೆರೂಸಲೇಮ್ಮ ಇಮ್ಮಸ್ ವಿಶ್ವಾಸಿನ ವಿರೋದ್‍ಕರೀನ್ ಕೈಯೆಕ್ಕಿ ಕಾಮ್ ಕರ‍್ಯೋಥೊ. ಯೋ ವಿಶ್ವಾಸಿಖ್ಹಾರಾಮ ಕೆತ್ರಾಕಿಜ಼ಣಾನ ಜೇಲ್‌ಮ ಘಾಲಾನ ಮಹಾಯಾಜಕರ‍್ನೆ ಮನ ಅದಿಕಾರ್ ದಿದೊ. ಇವ್ಣುನ ಮರಣ್ಣಿ ತೀರ್ಪ್‍ನಿ ವಖ್ಹ್‌ತೆ ಮೇ ಇನ ಮಾನಿಲಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","ಅಖ್ಖಾ ಸಬೇನು ಮಂದಿರ್‌ಮಾಬಿ ಮೇ ಕೈಯೇಕ್‌ಹಲ್ಲ ಇನ ಖ್ಹತಾಪ್ಣಿ ದೀನ್ ಇನೇಥಿ ದೇವ್ನ ದೂಷಣೆನಿ ವಾತೆ ಬೋಲಾವಾನಿತರ ಕೋಶಿಶ್‌ಕರ‍್ಯೊ. ಯೋ ವಿಶ್ವಾಸಿಖ್ಹಾರಾಪರ್ ಇರಾದೊ ಕರ್ತೊಹುಯಿನ್ ಇವ್ಣುನ ಢೂಂಡಿನ್ ಲತಾಡ ದ್ಯವಾನಖ್ಹಾಜೆ ಭಾರ್‌ ದೇಖ್ಹ್‌ನ ಖ್ಹಯೇರ್‌ಮಾಬಿ ಗಯೋಥೊ. ");
INSERT INTO vaa_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","ಏಕ್‌ ಹಲ್ಲ ದಮಸ್ಕನ ಜಾ಼ವಾನ ಗಲ್‌ಢಯಾಜಕರ್‌ಥಿ ಅದಿಕಾರ್‌ನಾಬಿ ಹಕ್ನ ಲೀನ್‌ ದಮಸ್ಕನ ಜಾ಼ವಾನಿ ವಾಟ್‌ಪರ್ ವಳೇಜಾ಼ತೊಥೊ. ");
INSERT INTO vaa_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","ತದೆ ಧೊಪಾರ್‌ ಹುಯಿರ‍್ಹುಥು. ಅಫ್ಪರ್‌ಥೂಸ್ ಸೊರ್ಗಮಾಥು ಚಾ಼ಂದ್‍ಥೀಬಿ ಜಾ಼ಖ್ಹತ್ ಏಕ್‌ ಉಜಾ಼ಳು ಆಯಿನ್ ಮಾರಾ ಅಶ್‌ಪಿಶ್‍ ಅಜು಼ ಮಾರಾಕೇಡೆ ಉಳಿಯಾವ್ತುಥೂತೆ ಇವ್ಣ ಅಶ್‌ಪಿಶ್‌ ಉಜಾ಼ಖ್ಹ್‌ಥಿ ಝ಼ಮ್‍ಕ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","ಹಮೆ ಅಖ್ಖಾಸ್‍ಜ಼ಣ ಜ಼ಮೀನ್‌ಪರ್ ರಡ್ಕಿಗಯ. ತದೆ ಸೌಲ ಸೌಲ ಮನ ಶನ ಖ್ಹತಾವಸ್? ಕಾಟಾನ ಲಠ್ಠಾನ ಲಾತ್ ಮಾರಾಥಿ ತುನಾಸ್ ದರದ್, ಕರಿ ಇಬ್ರಿಯ ವಾತೆಮ ಬೋಲಾನಿ ಏಕ್‌ ಅವಾಜ಼್‌ನ ಖ್ಹಮ್‍ಜ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","ತದೆ ಮೇ, “ಪ್ರಭು, ತೂ ಕೋಣ್” ಕರಿ ಬೋಲಖ್ಹತರ್ ಪ್ರಭುನೆ, “ತೂ ಖ್ಹತವ್‍ಕರಸ್ತೆ ಯೇಸುಸ್ ಮೇ. ");
INSERT INTO vaa_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","ಕತೋಬಿ ತೂ ಉಠೀನ್ ಭೀರೆ; ತುನ ಮಾರೊ ಸೇವಕ್ ಕರೀನ್‍ಬಿ ಸಾಕ್ಷಿಕರೀನ್‍ಬಿ ನೇಮಿಶಾವನಖ್ಹಾಜೆ ಮೇ ತುನ ದೆಖಾಯೊತೆ ವಾತೆನಾಬಿ, ಮೇ ತುನ ದ್ಯವಾನು ದರ್ಶನ್‍ಖ್ಹಾರನಿ ಬಾರೆಮಾಬಿ ತೂ ಅದ್ಮಿಖ್ಹಾರನ ಸಾಕ್ಷಿ ಹುಯಿರ‍್ಹಾಸ್ ಅನಖ್ಹಾಜೆಸ್ ಆವಖ್ಹತ್ ಮೇ ತುನ ದೇಖಾಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","ಮೇ ತುನ ತಾರು ಇಸ್ರಾಯೇಲ್ ಅದ್ಮಿಥೀಬಿ ಯೆಹೂದ್ಯರ್‌ಕಾಹೆತೆ ಅದ್ಮಿಥೀಬಿ ತುನ ಖರಾಬ್ ನಾಹೊಣುತೆತಿಮ್ ಬಚಾ಼ಡಿಶ್‌ ಮೇ ತುನ ಇವ್ಣಕನ ಮೋಕ್ಲುಕರುಸ್. ");
INSERT INTO vaa_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","ತೂ ಇವ್ಣ ಖ್ಹಾರಾನ ಖ್ಹಾಚ಼ನ ಖ್ಹಮ್‌ಜಾ಼ಡಿನ್ ಇವ್ಣುನ ಅಂಧಾರಮ ಥೂತೆ ಇವ್ಣಡೋಳನ ಉಜಾ಼ಳಾಮ ಆವಾನಿತರಾಬಿ ಶೈತಾನ್‍ನಿ ಅದಿಕಾರ್‌ಥಿ ದೇವ್‌ಭಣಿ ಫರಾನಿತರಾಬಿ ಕರ‍್ನು. ತದೆ ಇವ್ಣು ಪಾಪ್‌ಖ್ಹಾರು ಮಾಪ್‌ಉಷೆ. ಪರಿಶುದ್ಧರ್‌ನಿ ಜೋ಼ಡ್ಮ ಹುಕುಮ್‌ ಲೀಲಿಶೆ. ಇವ್ಣ ಡೋಳ ಉಖಡ್‌ನುಕರಿ ಇವ್ಣಕನ ಮೇ ತುನ ಮೋಕ್ಲುಸ್‌ ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","ಅನಖ್ಹಾಜೆ ಅಗ್ರಿಪ್ಪ ರಾಜ಼, ಪರಲೋಕ್‌ಥು ಮನ ಹುಯೂತೆ ಯೊ ದರ್ಶನಾನ ಮೇ ಖ್ಹರಮ್‌ ಕಾಡುಕೊಯ್ನಿ. ");
INSERT INTO vaa_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","ಪಹಿಲೆ ಯೆರೂಸಲೇಮ್ಮ ಛಾ಼ತೆ ದಮಸ್ಕಮಾಬಿ, ಯೂದಾಯನ ಅಖ್ಖಾ ತಭರ್‌ಖಾಮಾಬಿ ಛಾ಼ತೆ ಇವ್ಣುನ ಅಜು಼ ಯೆಹೂದ್ಯರ್‌ಕಾಹೆತೆ ಅದ್ಮಿನಾಬಿ, ತುಮೆ ದೇವ್‌ಭಣಿ ಫರ್‌ನು ಕರೀಬಿ ತುಮಾರು ಪಾಪ್‌ಭರ‍್ಯು ಜಿವ್ಣನ ಮ್ಹೇಲಿನ್ ದೇವ್‌ಭಣಿ ಫರಿಜಾ಼ವ್ಣುಕರಿಬಿ ಆಸ್ ಯೋಗ್ಯಾನು ಅಛ಼಼್ಛಕಾಮ್ನ ಪ್ರಚಾರ್ ಕರ‍್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","ಯೊ ಕಾರಣ್ಣಖ್ಹಾಜೆ ಯೆಹೂದ್ಯರ್ ಮನ ದೇವ್ನ ಮಂದಿರ್‌ಮ ಧರೀನ್ ಮಾರಿನಾಕ್ಣುಕರಿ ಕೋಶಿಶ್ ಕರ‍್ಯು. ");
INSERT INTO vaa_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","ಕತೋಬಿ ದೇವ್ನೆ ಮನ ಯೋ ದನ್ಮ ಮದತ್ ಕರ‍್ಯೊ. ಯೊ ಹಮ್ಕೆಲಗೂಬಿ ಮನ ಮದತ್ ಕರುಕರಸ್. ಇನಾಖ್ಹಾಜೆಸ್ ಆಜ಼್ ಹಜ್ಜಾ಼ ಭಿಯೋಸ್ ಅಜು಼ ಮೆ ದೇಖ್ಯೋತೆ ಘಟನೇನಿ ಬಾರೇಮ ಅದ್ಮಿಖ್ಹಾರನ ಸಾಕ್ಷಿ ಬೋಲುಕರುಸ್. ಮೋಶೆ ಅಜು಼ ಪ್ರವಾದಿಖ್ಹಾರು ಖ್ಹಾಮೆ ಹುವಾನು ಬಾರೇಮ ಖ್ಹಮ್‌ಜಾ಼ಡ್ಯುತೆ ವಾತೇಸ್‌ ಪಣ್ಕಿ ಖಿವೂಬಿ ನವು ಕೊಬೋಲ್ಯೋನಿ. ");
INSERT INTO vaa_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","ಯೇಸುನೆ ಖ್ಹತಾಪ್ಣಿನ ಪಾಡಿನ್ ಅಜು಼ ಮರ‍್ಯಹುಯಮಾಥು ಪಾಛು಼ಜಿವ್ತೊ ಹುಯಿನ್ ಆವಾಮ ಪಹಿಲೊ ಹುಯಿನ್ ಉಠೀನ್ ಯೆಹೂದ್ಯರ್‌ನಾಬಿ ಯೆಹೂದ್ಯರ್‌ಕಾಹೆತೆ ಇವ್ಣನಾಬಿ ರಕ್ಷಣೆನ ಉಜಾ಼ಳನ ವತಾಳವಾಳೊ ಹುಯಿರ‍್ಹೋಸ್.” ");
INSERT INTO vaa_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","ಅಮ್ ಪೌಲನೆ ಇನಭಣಿಥು ಜ಼ವಾಬ್ ದ್ಯವಾನಿ ವಖ್ಹ್‌ತೆ; ಫೆಸ್ತನೆ, “ಪೌಲ, ತೂ ದಿವಾನೊ ಹುಯಿಗೊ ಜಾ಼ಖ್ಹತ್ ಪಢಂತ್‌ ತುನ ದಿವಾನನಿತರ ಕರಿನಾಖ್ಯು” ಕರಿ ಚಿಕ್ರಿನ್ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","ತದೆ ಪೌಲನೆ, “ಮೋಟೊ ಮಹರಾಜ಼ ಹುಯಿರ‍್ಹೋತೆ ಫೆಸ್ತ ಮೇ ದಿವಾನೊಕಾಹೆ ಮೇ ಅಛ್ಛಿ ದಿಮಾಕ್‍ಥಿ ಗಂಭೀರ್‌ಥಿ ಖ್ಹಾಚು಼ ವಾತೆನಾಸ್ ಬೋಲುಕರುಸ್. ");
INSERT INTO vaa_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","ಅಗ್ರಿಪ್ಪ ರಾಜ಼ ಆ ವಾತೆಖ್ಹಾರು ಅಛ್ಛಿನಿತರ ಮಾಲುಮ್ ಕರಾಖ್ಯೊಹುಯೊ; ಶನಕತೊ ಇನಖ್ಹಾಮ್ಣೆ ಬರಬ್ಬರ್‌ಥೀಸ್ ವಾತೆ ಬೋಲುಸ್ ಅನಾಮ ಏಕ್‌ಬಿ ಇನ ಲಪಿಛಪಿಕೊರ‍್ಹೂನಿ ಕರಿ ನಂಬಿರಾಖ್ಯೊಸ್, ಶನಕತೊ ಆ ಏಕ್‌ ಕೋಣಾಮ ಚಾ಼ಲ್ಯುತೆ ವಾತೆ ಕಾಹೆ. ");
INSERT INTO vaa_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","ಅಗ್ರಿಪ್ಪ ರಾಜ಼ ತೂ ಪ್ರವಾದಿ ಖ್ಹಾರಾನ ನಂಬಾಸ್ಕಿಶು? ತೂ ವಿಶ್ವಾಸ್ ಕರೀಶ್‌ಕರಿ ಮನ ಮಾಲುಮ್” ಕರಿ ಬೋಲ್ಯೊ; ");
INSERT INTO vaa_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","ತದೆ ಅಗ್ರಿಪ್ಪರಾಜ಼ನೆ ಪೌಲನ ಅಮ್ ಬೋಲ್ಯೊಕಿ, “ಘಣು ಶುಲ್ಬಾಥಿ ಮನ ಕ್ರಿಸ್ತಾನ್‍ವಾಳೊ ಕರ್ನುಕರಿ ತೂ ಸೋಚಿರಾಖ್ಯೋಸ್ಕಿ ಶು?” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","ಇನ ಪೌಲನೆ; ನ್ಹಾನಿ ಕೋಶಿಶ್‍ಥಿ ರ‍್ಹವೊ, ಮೋಟಿ ಕೋಶಿಶ್‍ಥಿ ರ‍್ಹವೊ, ಯೊ ಮನ ಮುಖ್ಯ ಕಾಹೆ. ತೂಸ್ ಖಲಿಕಾಹೆ ಆಜ಼್ ಮನ ಖ್ಹಮ್‌ಜು಼ಕರಾತೆ ಹರೇಕ್‌ಜ಼ಣು ಮಾರಿನಿತರ ಹೋಣುಕರಿ ಮೆ ದೇವ್ನ ಪ್ರಾರ್ಥನೆಕರುಸ್ ಕತೋಬಿ ಆ ಖ್ಹಂಕಳ್‌ಮ ಪಣ್ಕಿ ತುಮೆ ನಾಜ಼ಕ್‌ಡಾವ್ಣು ಕರಿಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","ರಾಜ಼ ಅಗ್ರಿಪ್ಪ, ರಾಜ್ಯಪಾಲ್ ಪೆಸ್ತ, ಬೆರ್ನಿಕೆ ಅಜು಼ ಇವ್ಣಜೋ಼ಡೆ ಬೆಠುಥೂತೆ ಅದ್ಮಿಖ್ಹಾರು ಉಠಿಭೀರ‍್ಯು. ");
INSERT INTO vaa_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","ಇನಪಾರ್ ಭಾರ್‌ಜೈ಼ನ್‌ ಇವ್ಣೆ, “ಆ ಅದ್ಮಿನ ಮರಣ್ಣಿ ದಂಡನೆ ನತರ್ ಬೇಡಿ ಘಾಲನು ಅನೆ ಶಾತ್ಬಿ ಕೊಕರ‍್ಯೋನಿ ಕರಿ ಇವ್ಣ ಇವ್ಣಾಮಸ್‌ ಬೋಲಾಲಗ್ಯು ");
INSERT INTO vaa_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","ತದೆ ಅಗ್ರಿಪ್ಪನೆ ಫೆಸ್ತನ, “ಆ ಅದ್ಮಿ ಕೈಸರನ ಖ್ಹಾಮ್ಣೆ ಬೋಲಿಲೆವುಸ್‌ಕರಿ ನಾಬೋಲ್ಯೊಹೊತ್ತೊ ಅನ ಛುಟ್ಕಾರ್ ಕರೇಜಾ಼ಯಿಥು ಕರಿಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","ಹಮೆ ದರ‍್ಯಾವ್ನ ಮಾರಗ್‍ಥಿ ಇಟಲಿನ ಜಾ಼ವ್ಣುಕರಿ ತೀರ್ಮಾನ್ ಹುಯು. ಪೌಲನಾಬಿ ಬಿಜು಼ ಥೋಡು ಖೈದಿಖ್ಹಾರಾನ ಯೂಲ್ಯ ಕರಿ ಏಕ್‍ಜ಼ಣೊ ಖ್ಹೋಶಿಪಾಯಿನೊ ಮೋಟೊ ಹುಯಿರ‍್ಹೋಥೊ. ಯೋ ರಾಜ಼ನಿ ಡಂಡ್ಮ ಕಾಮ್ ಕರಾವಾಳೊ ಹುಯಿರ‍್ಹೊಥೊ. ");
INSERT INTO vaa_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","ತದೆ ಅದ್ರಮಿತ್ತಿಯಥು ಐನ್ ಏಷ್ಯಾನ ಅಲಕ್ ಅಲಕ್ ತಬರ್‌ಖಾನು ಜಾ಼ವಾನ ತಯಾರ್ ಹುಯಿರ‍್ಹಿಥೀತೆ, ಜ಼ಹಾಜ಼್ ಹಮೆ ಚ಼ಢೀನ್ ಚಾ಼ಲ್‌ಕುಚ಼್‌ ಕರ‍್ಯ. ಇನಾಮ ಥೆಸಲೋನಿಕಥೊ ಆಯೋತೆ ಮೆಕೆದೋನ್ಯವಾಳೊ ಅರಿಸ್ತಾರ್ಕ ಹಮಾರಿ ಜೋ಼ಡ್ಮ ಥೊ. ");
INSERT INTO vaa_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","ಇನವ್ಹಾಣೆ ಹಮೆ ಸೀದೋನ್‍ಖ್ಹಯೇರ‍್ನ ಜೈ಼ನ್ ಪೋಚ್ಯ. ಯೂಲ್ಯನೆ ಪೌಲನಪರ್ ಗೋರ್‌ ಕರಾವಳೊಹುಯಿನ್, ಇನ ದೋಸ್ತಿಖ್ಹಾರನಕನ ಮದತ್ ಲೀಲ್ಯಾವನಖ್ಹಾಜೆ ಇನ ಹುಕುಮ್ ದಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","ತದೆ ಹಿಜ್ಜಾ಼ಥ ನಿಕ್ಳಿನ್ ಜ಼ಹಾಜ಼್‍ಮ ಜಾ಼ವಾನಿ ವಖ್ಹತ್‌ಮ ಖ್ಹಾಮ್ಣೆನೊ ವಹಿರೊ ವಾಗುಕರ್ತುಥೂತೆ ಇನಾಖ್ಹಾಜೆ ಹಮೆ ಸೈಪ್ರಸ್ ಟಾಪನ ಖನ್ನೆಕರಿ ಗಯ. ");
INSERT INTO vaa_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","ಕಿಲಿಕ್ಯನಾಬಿ ಪಂಫುಲ್ಯನಾಬಿ ಮ್ಹೋರೆ ಹುಯಿರೋತೆ ದರ‍್ಯಾವ್ನ ಉಲಾಂಗಿನ್, ಲುಕೀಯನು ‘ಮುರ’ ಕರಿ ಝ಼ಗೋಕನ ಆಯಿನ್ ಪೋಚ್ಯ. ");
INSERT INTO vaa_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","ಹಿಜ್ಜಾ಼ ಇಟಲಿನ ಜಾ಼ವಾನಿ ಅಲೆಕ್ಸಾಂಡ್ರಿಯ ಖ್ಹಯೇರ‍್ನಿ ಜ಼ಹಾಜ಼್‌ನ ಖ್ಹೋಶಿಪಾಯಿನ ಮೋಟಾನೆ ದೇಖಿನ್, ಹಮೂನ ಇನಾಮ ಛ಼ಡಾಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","ಹಮೆ ಹಳ್ಳೂಥಿ ಕೈಏಕ್ ದನ್‌ಲಗು ಜ಼ಹಾಜ಼್‌ನಿಚಾ಼ಲ್‌ ಕರ್ತಹುಯಿನ್ ಘಣು ಮುಶ್ಕಿಲ್‌ಥಿ ಖ್ಹರ್ತಿನ ಸ್ನೀಡ‌ ಖ್ಹಯೇರ‍್ನ ಐನ್ ಪೋಚ್ಯ. ಖ್ಹಾಮ್ಣೆನೊ ವಹಿರೊ ವಾಗುಕರ್ತುಥೂತೆ ಇನಖ್ಹಾಜೆ, ಯೋ ಮಾರಗ್‍ಮ ಅಗಾಡಿ ಜಾ಼ವಾನ ಹಮೂನ ಕೊಹುಯುನಿ. ಇನಖ್ಹಾಜೆ ಹಮೆ ಕ್ರೇಟ್ ಟಾಪಾನ ಕನಾರೆಕರಿ ಸಾಲ್ಮೋನೆನ ಖನ್ನೆ ಐನ್, ");
INSERT INTO vaa_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","ಹಮೆ ಮುಶ್ಕಿಲ್‌ಥಿ, ಯೋ ಟಾಪನ ಕನಾರೆ ಅಗಾಡಿ ಜಾ಼ತಹುಯಿನ್ ಶನ್‌ಗಾರ್ನುಕೊಲ್ಲಿ ಕರಿ ಏಕ್‌ ಝ಼ಗೊಕನ ಆಯ. ಯೋ ಲಸಾಯಕರಿ ಖ್ಹಯೇರ‍್ನ ಖನ್ನೆ ಥೂ. ");
INSERT INTO vaa_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","ಅಮ್ಮಸ್ ಘಣಾದನ್ ನಿಕ್ಳಿಗಯು. ಯೆಹೂದ್ಯರ್‌ನ ಪಟ್ನಿನೊ ದನ್‍ಬಿ ಖ್ಹತಮ್ ಹುಯಿಗಾಥ. ಇನಖ್ಹಾಜೆ ಪೌಲನೆ ದರ‍್ಯಾವ್‌ಮ ನಿಕ್ಳಾನು ಮುಶ್ಕಿಲ್ ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","ತದೆ ಪೌಲನೆ ಇವ್ಣುನ, “ಅದ್ಮಿವೊ ಆ ಚಾ಼ಲ್‌ಥಿ ಜ಼ಹಾಜ಼್‌ನಾಬಿ, ಇನಾಮಛಾ಼ತೆ ರಾಛಾ಼ನಾಬಿ, ಅತ್ರೇಸ್‍ಕಾಹೆತೆ ಅಪ್ಣ ಜಾನ್ನಬಿ, ಘಣು ವದೇಖ್ಹ್‌ಬಿ ಲುಕ್ಷಾನ್‌ಬಿ ಉಷೆಕರಿ ಮನ ದೆಖಾವಸ್” ಕರಿ ಝೇತಾಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","ಕತೋಬಿ ಪೌಲನೆ ಬೋಲ್ಯೊತೆ ವಾತೆಥೀಬಿ, ಜ಼ಹಾಜ಼್‌ನೊ ಯಜಮಾನ್ನಿಬಿ ಚ಼ಲಾವವಾಳನಿ ವಾತ್ನ ಖ್ಹೋಶಿಪಾಯಿನ ಮೋಟಾನೆ ಕಾನ್‍ದಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","ಯೋ ಬಂದರ್ನೊ ತಬರ್‌ಖೊ ಠಣ್ಣಹಗಾಮ್ ಕಾಡಾನ ಯೋ ಜ಼ಹಾಜ಼್ನ ಅಛ್ಛಿಝ಼ಗೊ ಕೋಥೂನಿ. ಇನಖ್ಹಾಜೆ ಹಿಜ್ಜಾ಼ಥು ನಿಕ್ಳಿನ್, ಜಾ಼ವಾನು ಹುಯುತೊ ಕಿಮ್‍ಬಿ ಫೆನಿಕ್ಸ್‌ ಗಾಮ್ನ ಜೈ಼ನ್ ಹಿಜ್ಜಾ಼ಸ್ ಯೋ ಠಣ್ಣಾ ಹಗಾಮ್‌ ಕಾಡ್ಣುಕರಿ ಘಣು ಅದ್ಮಿ ಖ್ಹೂಜ಼್‌ ಕರ‍್ಯು. ಫೆನಿಕ್ಸ್‌, ಕ್ರೇಟ್ ಟಾಪಾನು ಏಕ್‌ ಬಂದರ್ನೊ ತಬರ್‌ಖೊ, ಯೋ ಈಶಾನ್ಯ ದಿಕ್ನಾಬಿ, ಆಗ್ನೇಯ ದಿಕ್ನಾಬಿ, ಆಮಖ್ಹಾಮೆ ಥು. ");
INSERT INTO vaa_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","ತದೆ ದಕ್ಷಿಣ್ ಭಣೀಥು ವಹಿರೊ ಹಳ್ಳೇಖ್ಹು ವಾಗಲಗ್ಯೊ. ಇವ್ಣೆ ಉದ್ದೇಶ್ ಹಕ್ಲಾಲ್ ಹುಯುಕರಿ ಖ್ಹೂಜ಼್ ಕರೀನ್, ಲಂಗಾರ್‌ನ ಛೋ಼ಡಿಲಿನ್, ಕ್ರೇಟ್ ಟಾಪಾನ ಕನಾರೇಸ್‍ಕರಿ ಪಡ್ತಹುಯಿನ್ ಜ಼ಹಾಜ಼್‌ಪರ್ ನಿಕ್‍ಳ್ಯ. ");
INSERT INTO vaa_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","ಕತೋಬಿ ಜ಼ರಸ್‍ಘಡೀಮ ಈಶಾನ್ಯ ಮಾರುತ ಕರಿ ಅಪಟ್‌ಝ಼ಪಟ್‌ನೊ ವಹಿರೊ ಟಾಪಾಮ ವಾಗಲಗ್ಯುಥು. ");
INSERT INTO vaa_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","ಜ಼ಹಾಜ಼್ ಯೋ ವಹಿರಾಮ ಖ್ಹಪ್‍ಡಿನ್, ಹಮೆ ಕೋಶಿಶ್ ಕರಾನು ಮ್ಹೆಂದಿದ. ಅಜು಼ ಅಗಾಡಿ ಜಾ಼ವಾನ ಕೋ ಹುಯುನ್ತೆ ವಹಿರೊ ಕೀಕಡ್ ವಾಗಸ್ಕಿ ಥೀಕಡ್ ಕರಿಶ್ ಜ಼ಹಾಜ಼್‌ನ ಧಕೆಲಾವ್ತಹುಯಿನ್ ಗಯು. ");
INSERT INTO vaa_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","ಹಮೆ ಕ್ಲೌಡ ಕರಿ ಏಕ್‌ ನ್ಹಾನು ಟಾಪನ ಓಠೆಕರಿ ಗಯ. ತದೆ ಹಮೆ ಜ಼ಹಾಜ್‍಼ಮಥೂತೆ‍ ನ್ಹಾನಿದೋಣಿನ ಮಹಿ ಪಾಡಿನ್ ಬರೋಬರ್ ಕರ್ವಾನುಹುಯು. ");
INSERT INTO vaa_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","ಇನ ಉಪ್ಪರ್ ಪಾಡಿಹುಯಗು ತದೆ ಶಿಂದ್ರಾನ ಪಾಡಿನ್ ಜ಼ಹಾಜ಼್‌ನ ಹೇಟ್ ಭಾಂದ್ಯು. ಇನಕೇಡೆಥು “ಸುರ್ತಿಸ್” ಕರಿ ರೇತ್ನೊ ಟಿಮ್ಮಾಮ ಜ಼ಹಾಜ಼್ ಪೇಶಿಜಾ಼ಶೆಕರಿ ಡರ್‌ಥಿ, ಜ಼ಹಾಜ಼್‌ನ ಉಪ್ಲಿಬಾಜು಼ನು ಜ಼ಹಾಜ಼್‌ನ ಮಿಲಾವನ ಜಿನಖ್ಹ್‌ನ ಉತಾರಿನ್‌ ವಹಿರೊ ವಾಗುಕರಾತೆ ಬಾಜು಼ಸ್ ಜ಼ಹಾಜ಼್ ತೇಲಾದೆಕರಿ ಮ್ಹೇಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","ಇನವ್ಹಾಣೆ ತೋಫಾನ್ನೊ ವಹಿರೊ ಅಪಟ್ಜ಼ಫಟ್ ವಾಗಲಗ್ಯುತೆ ದೇಖಿನ್, ಅದ್ಮಿಖ್ಹಾರು ಜ಼ಹಾಜ಼್‍ಮ ಥೂತೆ ಥೋಡು ಖ್ಹಾಮನ್‍ಖ್ಹಾರು ಫೇಕಿದಿದು. ");
INSERT INTO vaa_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","ಇನ ತೀನ್ ದನ್ಮ ಜ಼ಹಾಜ಼್‌ವಾಳನೇಸ್, ಜ಼ಹಾಜ಼್‌ನು ರಾಛಾ಼ವ್‌ನಾಸ್ ಪಾಡಿನ್ ಫೇಕಿದಿದು. ");
INSERT INTO vaa_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","ಕೈಏಕ್ ದನ್‌ಲಗು ಚಾ಼ಂದ್‍ನ ರ‍್ಹವೊ, ಶುಕ್ಕರ್‌ನ ರ‍್ಹವೊ ದೇಖಾನ ಕೊಹುಯುನಿ. ತೋಫಾನ್ ಮೋಟುಸ್ ಹೋತುಆಯು. ಹಮೆ ಬಚಿಜಾಶುಕರಿ ಬೋಲಾನಿ ವಿಶ್ವಾಸ್ ಹಮಾರಮಾಥಿ ನಿಕ್ಳಿಗೈಥಿ. ");
INSERT INTO vaa_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","ಯೋ ಅದ್ಮಿಖ್ಹಾರು ಘಣಾದನ್‍ಥು ಖಾಣುಖಾದೂಥು ಕೊಯ್ನಿ. ತದೆ ಏಕ್‍ದನ್ ಪೌಲ ಉಠಿ ಭೀರಿನ್ ಇವ್ಣುನ “ಅಲಾ ಅದ್ಮಿವೊ, ಕ್ರೇಟ್ ಟಾಪಾಥು ನಿಕ್ಳೊನಕೊ ಕರಿ ಮೇ ತುಮೂನ ಬೋಲ್ಯೊ. ತುಮೆ ಮಾರಿವಾತೆ ಖ್ಹಮಜ಼್‌ಣುಥು. ತದೆ ತುಮೂನ ಅತ್ರೆ ವದೇಖ್ಹೊ ಲುಕ್ಷಾನ್‌ ಕೋ ಹುಯುಹೋತ್ನಿ. ");
INSERT INTO vaa_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","ಹಮ್ಕೆತೋಬಿ ತುಮೆ ಭಾಲಿಥಿ ರ‍್ಹೇವೊಕರಿ ತುಮೂನ ಬುದ್ದಿಬೋಲುಸ್; ಜ಼ಹಾಜ಼್ ನಾಶ್‍ಉಶೇ ಪಣ್ಕಿ ತುಮಾರಮ ಏಕ್‍ಜ಼ಣುಬಿ ಜಾನ್‌ ಕಾಡಿಲೆಶೆಕೊಯ್ನಿ. ");
INSERT INTO vaa_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","ಗೈತೆರಾತ್, ದೇವ್‍ಕಂಥೊ ಏಕ್‍ ದೂತ ಮಾರಕನ ಆಯೋಥೊ. ಯೋಸ್ ದೇವ್ನ ಮೇ ಆರಾದನೆ ಕರುಸ್ತೆ ಮೆ ಇನೋಸ್. ");
INSERT INTO vaa_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","ಯೋ ದೇವ್ನದೂತನೆ, ‘ಪೌಲ, ಡರ್‌ನಕೊ ತೂ ಕೈಸರೈನ ಖ್ಹಾಮ್ಣೆ ಭೀರೆವ್ಣು. ತಾರಿ ಜೋ಼ಡೆ ಜ಼ಹಾಜ಼್‍ಮ ಓಳೆಜಾ಼ಸ್‍ತೆ ಖ್ಹಾರಾಸ್ ಅದ್ಮಿನ ಜಾನ್ನ ಬಚಾ಼ಡುಕರುಸ್ತೆ, ತಾರ ಉಪ್ಪರ್‌ಲ್ಯ ದಯಾನಖ್ಹಾಜೆ ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","ಇನಖ್ಹಾಜೆ, ಅದ್ಮಿವೊ ಭಾಲ್‍ಥಿ ರ‍್ಹವೊ. ಮನ ಬೋಲೈರ‍್ಹುತೆ, ಪರಕ್ಮಸ್ ಉಷೆಕರಿ ಮೇ ದೇವ್‍ಪರ್ ವಿಶ್ವಾಸ್ ಕರುಸ್. ");
INSERT INTO vaa_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","ಕತೋಬಿ ಅಪ್ಣೆ ಕೆಹೂಕಿ ಏಕ್‌ ಟಾಪಾನಿ ಕನಾರಿನ ಫೋಚು಼ಕರಿಯೇಸ್, ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","ಚೌ಼ಧಾನಿ ರಾತ್ಮ ಹಮೆ ಆದ್ರಿಯ ದರ‍್ಯಾವ್‌ಮ ಯೊ ಜ಼ಹಾಜ಼್ ವ್ಹವ್‌ತುಹುಯಿನ್, ಜಾ಼ತರ‍್ಹವಾನಿ ವಖ್ಹತ್‌ಮ, ಖ್ಹುಮಾರ್ ಅಧಿರಾತ್ಮ ಇನ ಚ಼ಲಾವವಾಳನೆ ಹಮೆ ಜ಼ಮೀನ್ನ ಖನ್ನೆ ಅಯಿಗ ಕರಿ ಲಾಝ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","ತದೆ ಅಳ್ತಿನು ಗುಂಡ್ ಮ್ಹೇಲಿನ್ ಪಾಣಿನಿ ಗಧಾರ‍್ನ ತರೀಪ್ಷ ಕರಾಮ, ಯೋ ಖ್ಹುಮಾರ್ ಏಕ್‌ ಖ್ಹೋ ಡೋಡಿಖ್ಹ್‌ ಅಡಿ ಗಧಾರ್ ಛಾ಼ ಕರಿ ಮಾಲುಮ್ ಕರಿಲಿದ. ಇವ್ಣೆ ಬಿಜು಼ ಥೋಡಿ ದೂರ್ ಜೈ಼ನ್, ಪಾಛು಼ ಅಳ್ತಿನು ಗುಂಡ್ ಮ್ಹೇಲಿನ್ ದೇಖಾಮ, ಖ್ಹುಮಾರ್ ಯೋ ಖ್ಹಡ್‌ಚಾರೀಖ್ಹ್ ಅಡಿ ಥು. ");
INSERT INTO vaa_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","ಜ಼ಹಾಜ಼್ ಬಂಡಾನ ಟಕ್ಕರ್ ಖಾಶೆಕರಿ ಡರಿನ್ ಜ಼ಹಾಜ಼್‌ನ ಪೀಠೆಥು ಚಾರ್ ಲಂಗಾರ್‌ನ ಪಾಣಿನ ಮಹಿ ಮ್ಹೇಲಿನ್ ಒಗ್ಗಿ ವ್ಹಾಣು ಹುವಾದೆಕರಿ ಪ್ರಾರ್ಥನೆ ಕರ‍್ಯು. ");
INSERT INTO vaa_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","ಜ಼ಹಾಜ಼್ ಚ಼ಲವಾಳು ಥೋಡುಜ಼ಣು, ಲಪೀನ್ ದೋಣಿನ ದರ‍್ಯಾವ್‌ಮ ಉತ್‌ರೈನ್ ನಿಕ್ಳಿ ಜಾ಼ವ್ಣುಕರಿ ಜ಼ಹಾಜ಼್‌ನ ಖ್ಹಾಮ್ಣೆಥೂತೆ ಲಂಗಾರ್ ಅಖ್ಖಾನ ಹೇಟ್ ಉತಾರಾನು ಭಾಣು ಕರ‍್ಯು. ");
INSERT INTO vaa_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","ತದೆ ಪೌಲನೆ ಖ್ಹೋಶಿಪಾಯಿನ ಮೋಟನಾಬಿ ಶಿಪಾಯಿಖ್ಹಾರಾನ, “ಆ ಜ಼ಹಾಜ಼್ ಚ಼ಲವವಾಳೊ ಜ಼ಹಾಜ಼್‍ಮ ನಾರ‍್ಹಯುತೊ ತುಮಾರೊ ಜಾನ್‌ ಬಚಾ಼ವನ ಉಶೇಸ್‍ ಕೊಯ್ನಿ” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","ಇನಖ್ಹಾಜೆ ಶಿಪಾಯಿಖ್ಹಾರನೆ, ಶಿಂದ್ರಾವ್‍ನ ಕತ್ರೀನ್ ದೋಣಿಯೇನ ಪಾಣಿಮ ಮ್ಹೆಂದಿದ. ");
INSERT INTO vaa_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","ವ್ಹಾಣುಹುವಾನ ಮ್ಹಯಿಮಾ ಪೌಲನೆ ಇವ್ಣ ಖ್ಹಾರಾಜ಼ಣನ ಶಾತ್ಬಿ ಖಾವೊಕರಿ ಗಿಂಗೈಲಿದೊ ಅಜು಼ “ತುಮೆ ಗಯೋತೆ ಚೌ಼ಧರೋಜ್‍಼ಥೂಬಿ ಖಾಣುಸ್ ಖಾದಸ್‌ಕೋಯ್ನಿ. ");
INSERT INTO vaa_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","ಹಮ್ಕೆ ತುಮೆ ದರ‍್ರಾಖ್ಹುತೊಬಿ ಖಾಣು ಖಾವ್ಣುಕರಿ ತುಮೂನ ಗಿಂಗೈಲೆವುಸ್. ತುಮೆ ಜೂತುರ‍್ಹೀನ್ ಬಚ಼್‌ಣುಕತೊ, ತುಮೂನ ಖಾಣಾನಿ ಜ಼ರೂರತ್ ಛಾ಼. ತುಮಾರಮ ಕೋಣ್‌ಬಿ ತುಮಾರ ಮುಡ್‌ಕ್ಯಾನೊ ಏಕ್‌ ಕೇಖ್ಹ್‌ಬಿ ಗುಮೈಲಿಶುಕೊಯ್ನಿ. ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","ಅಮ್ ಬೋಲಿನ್ ಪೌಲನೆ, ರೋಟಾನ ಪಾಡಿ ಖ್ಹಾರಾನ ಖ್ಹಾಮ್ಣೆ ದೇವ್ನ ಧನ್ಯವಾದ್‌ಕರೀನ್‌ ತೋಡಿ ಖಾವಲಗ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","ತದೆ ಇವ್ಣೇಬಿಖ್ಹಾರು ಭಾಲ್‍ಲೀನ್, ಖಾಣುಖಾದು. ");
INSERT INTO vaa_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","ಯೋ ಜ಼ಹಾಜ಼್‍ಮ ಹಮೆ ಬೇಖ್ಹೊ ಛೋ಼ಉಪ್ಪರ್ ಖ್ಹಡ್‌ತೀನಿಖ್ಹ್ ಜ಼ಣು ಥಾ. ");
INSERT INTO vaa_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","ಹಮೆ ಬಶ್‍ಹುವಾಎತ್ರು ಖೈಹುವಾದೀನ್, ಬಿಜ಼ ಘವ್‌ನ ದರ‍್ಯಾವ್‌ಮ ಫೇಕಿನ್, ಜ಼ಹಾಜ಼್‌ನ ವಜನ್ನ ಕಮ್‍ಕರ‍್ಯ. ");
INSERT INTO vaa_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","ವ್ಹಾಣು ಹುವಾದಿನ್ ಜ಼ಹಾಜ಼್ ಚ಼ಲಾವವಾಳು ಜ಼ಮೀನ್ನ ದೇಖ್ಯು. ಕತೋಬಿ ಯೋ ಖೆವಿ ದೇಖ್ಹ್‌ನಿ ಝ಼ಗೊಕರಿ ಮಾಲುಮ್‌ ಪಡ್ಯುಕೊಯ್ನಿ. ಇವ್ಣೆ ದೇಖ್ಯುತೆ ಏಕ್‌ ರೇತ್ನಿ ಖಾರಿ ರ‍್ಹಯೂತೊ ಹಿಜ್ಜಾ಼ ಜ಼ಹಾಜ಼್‍ನ ಲೀಜೈ಼ನ್ ಭೀರಾಕ್ಣುಕರಿ, ಸೋಚ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","ಇನಖ್ಹಾಜೆ ಹಮೆಖ್ಹಾರು ಅಖ್ಖಾ ಲಂಗಾರ್ನ ಕತ್ರೀನ್ ದರ‍್ಯಾವ್‌ಮ ಮ್ಹೆಂದಿದ. ಅಜು಼ ಚುಕ್ಕಾಣಿನ ಶಿಂದ್ರಾವ್‍ನ ಗಾಟ್ನ ಛೋ಼ಡಿನ್ ಜ಼ಹಾಜ಼್‍ನ ಖ್ಹಾಮ್ಣೆ ಥೂತೆ ಜ಼ಂಡಾನ ವಹಿರಾಮ ಪಾಡಿಭಾಂದಿನ್ ಜ಼ಹಾಜ಼್‌ನ ಕನಾರಿಭಣಿ ಚ಼ಲಾವ್‌ತು ನಿಕ್‍ಳ್ಯ. ");
INSERT INTO vaa_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","ಕತೋಬಿ ಜ಼ಹಾಜ಼್ ರೇತ್‍ನ ದಿಬ್ಬನ ಟಕ್‌ರೈನ್, ಇನು ಮ್ಹೋರಾನು ನೋಕ್‍ ರೇತ್ಮ ಗಡೀಗು. ಜ಼ಹಾಜ಼್ ಅಗಾಡಿ ಚಾ಼ಲಾನ ಹುಯುಕೋಯ್ನಿ. ತದೆ ಮೋಟ ಝೋ಼ಕಾಳ್ಯ ಆಯಿನ್ ಜ಼ಹಾಜ಼್‌ನ ಪೀಠೆಥು ಮಾರ್‌ಪಡೀನ್, ಫುಟಿನ್‌ ಟುಕ್‌ಡಾ ಹುಯಿ ಪಡಾಲಗ್ಯುಥು. ");
INSERT INTO vaa_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","ತದೆ ಕೈದಿಖ್ಹಾರು ತೀರಾಕ್‌ಮಾರಿನ್ ಲಪಿನಿಕ್‌ಳಿ ಜಾ಼ಶೆಕರಿ ಶಿಪಾಯಿಖ್ಹಾರು ಇವ್ಣುನ ಮರ್‌ನಾಖಿ ದೇವ್ಣುಕರಿ ಸೋಚ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","ಕತೋಬಿ ಖ್ಹೋಶಿಪಾಯಿನ ಮೋಟಾನೆ ಪೌಲನ ಬಚಾ಼ಡ್ನುಥು. ಇನಖ್ಹಾಜೆ, ಇವ್ಣೆ ಇಮ್‌ ನಾ ಕರ್ನುತೆ ತಿಮ್ ದೇಖಿಲಿದೊ. ಅನಬದಲ್ ತೀರಾಕ್ ಮಾಲುಮ್‌ ರ‍್ಹವಾಳು ಪಾಣಿಮ ಉತ್ರಿನ್ ತೀರಾಕ್‌ಮಾರಿ ಕನಾರಿನ ಜಾ಼ವ್ಣುಕರಿ, ಹುಕುಮ್ ದಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","ಅಜು಼ ಉಭ್ರಿಹುಯು ಅದ್ಮಿಖ್ಹಾರು ಪಲ್ಗಾನ ಉಪ್ಪರ್ ನತರ್ ಜ಼ಹಾಜ಼್‌ನ ಟುಕ್ಡಾವ್‍ನ ಮದಥ್ಥಿ ಜಾ಼ವ್ಣುಕರಿ ಬೋಲ್ಯು. ಇಮ್ಮಸ್ ಹಮೆ ಖ್ಹಾರುಜ಼ಣು ಕನಾರಿನ ಬಚಿನ್ ಪೋಚಿಗಯ. ");
INSERT INTO vaa_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","ಹಮೆ ಜ಼ತನ್‌ಥಿ ಕನಾರಿನ ಬಚಿನ್ ಜಾ಼ವಾದಿನ್ ಯೋ ಮೆಲೀತೆ ಟಾಪು ಕರಿ ಮಾಲುಮ್‍ಹುಯು. ");
INSERT INTO vaa_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","ತದೆ ಪಾಣಿ ವರ್ಖ್ಹುಕರ್ತೊಥೊ ಅಜು಼ ಘಣು ಠಣ್‍ಥೂತೆಖ್ಹಾಜೆ ಯೋ ಟಾಪುನು ಅದ್ಮಿಖ್ಹಾರು ಪ್ಯಾರ್‌ಥಿ ಇವ್ಣೆ ಶೇಕಾನಖ್ಹಾಜೆ ಆಗ್ ಲಗಾಡಿನ್ ಹಮೂನ ಖ್ಹಾರಾನ ಬುಲಾಯು. ");
INSERT INTO vaa_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","ಪೌಲನೆ ಏಕ್‌ ಭಾರೊ ಲಾಕ್ಡಾನ ಎಕ್ಟುಕರಿನ್ ಲೈನ್‌ ಆಗ್ನಉಪ್ಪರ್ ನಾಖುಕರಾನಿವಖ್ಹ್‌ತೆ ಇನ ಅಂಚ಼್‌ನಮಾರ್ಮ ಖ್ಹಾಪ್‌ ಏಕ್‌ ಭಾರ್‌ಆಯಿನ್ ಪೌಲಾನ ಹಾತ್‍ಕೇಡೆ ಲಪ್‍ಟೈಗಯು. ");
INSERT INTO vaa_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","ಪೌಲನ ಹಾತ್ನ ಲಪ್‍ಟೈರ‍್ಹುಥೂತೆ ಯೋ ಖ್ಹಾಪ್‍ನ ದೇಖ್ಯೂತೆ ಟಾಪುವಾಳು, “ಆ ಅದ್ಮಿ ಖ್ಹಾಚ ಖೂನಿಸ್‌ ಹುಯಿರೊಸ್. ಆ ಹೈರೋತೆ ದರ‍್ಯಾವ್‍ಮಾಥೊ ಬಚಿನ್ ಆಯೋತೋಬಿ ನಶೀಬ್‌ ಇನ ಜಿವಾನ ಮ್ಹೇಲ್ಯುಕೊಯ್ನಿ.” ಕರಿ ಇವ್ಣ ಇವ್ಣಾಮ ಬೋಲಿಲಿದು. ");
INSERT INTO vaa_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","ಕತೋಬಿ ಪೌಲನೆ ಖ್ಹಾಪ್‍ನ ಆಗ್‌ಮ ಝ಼ಟ್ಕಿನಾಖ್ಯೊ; ಇನ ಶನು ಖತ್ರಾಬಿ ಕೊ ಹುಯುನಿ. ");
INSERT INTO vaa_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","ಇವ್ಣೆ ಇನು ಅಂಗ್‍ತನ್ ಫುಲಿಜಾಶೆ ನತರ್ ಆ ಅಫ್ಫರ್‌ಥೊಸ್ ಮರಿನ್ ಲಡಕ್‍ಶೆ ಕರಿ ಟಿವೈರ‍್ಹೂಥು. ಕತೋಬಿ ಕೆವ್ಡಿ ವಖ್ಹತ್ ಟಿವೈನ್ ದೇಖ್ಯುತೋಬಿ ಇನ ಶನು ಲುಕ್ಷಾನ್‌ಬಿ ಕೊಹುಯುನಿ. ಅನ ದೇಖ್ಯೂತೆ ಇವ್ಣೆ ಮನ್‍ಫರೈಲಿನ್ ಆ ಏಕ್‌ ದೇವಸ್‌ಕರಿ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","ಯೋ ಟಾಪುನೊ ಮೋಟೊ ಅಧಿಕಾರಿಮ ಏಕ್‍ಜ಼ಣೊ ಪೋಪ್ಲಿಯಾನು ಖೇತರ್‌ ಗದ್ದೆ ಹಮೆಥಾತೆ ಝ಼ಗೊನ ಖನ್ನೇಸ್‍ಮ ಥೂ. ಯೋ ಹಮೂನ ಸ್ವಾಗತ್ ಕರೀನ್ ತೀನ್ ದನ್‌ಲಗು ಹಮೆ ಇನೇಥಿ ಸತ್ಕಾರ್ ಲಿದ. ");
INSERT INTO vaa_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","ಪೋಪ್ಲಿಯಾನೊ ಬಾ ತಾವ್‍ಥೀಬಿ ಲ್ಹೊಯ್ಯವ್‌ಹುಯಿನ್ ಛಾ಼ದ್ರಿ ಧರಿರಾಖ್ಯೊಥೊ.ಪೌಲ ಇನಕನ ಜೈ಼ನ್ ಪ್ರಾರ್ಥನೆ ಕರೀನ್ ಇನ ಮುಡ್‌ಕ್ಯಪರ್ ಹಾತ್‍ಮ್ಹೇಲಿನ್‍ ಅಛ್ಛುಕರ‍್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","ಇನಪಾರ್ ಯೋ ಟಾಪನ ಅಜು಼ ಉಭ್‌ರ‍್ಯುತೆ ಖ್ಹಾರುಸ್ ರೋಗಿಬಿ ಪೌಲಕನ ಐನ್ ಗುಣ್‌ಹುಯು. ");
INSERT INTO vaa_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","ಇವ್ಣೆ ಹಮೂನ ಜಾ಼ಖ್ಹತ್ ಮರ್ಯಾದಿ ದಿದು. ಹಮೆ ಹಿಜ್ಜಾ಼ಥು ಜಾ಼ವನ ಖ್ಹವಾರನಿ ವಖ್ಹ್‌ತೆ ಹಮೂನ ಜ಼ರೂರತ್‌ಥೂತೆ ಖ್ಹಾರು ಚೀಜ಼್ ಲಯಿನ್ ದಿದು. ");
INSERT INTO vaa_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","ತೀನ್ ಮಹಿನಾನ ವಾರ್‌ ಅಲೆಕ್ಸಾಂಡ್ರಿಯಾಥು ಅಯಿನ್ ಯೋ ಟಾಪಾಮ ಠಣ್ಣಾದನ್‍ ಕಾಡಿಮ್ಹೇಲಿಜಾ಼ವನ ಖ್ಹಾಜೆ ಏಕ್‌ ಜ಼ಹಾಜ಼್‌ನ ಚ಼ಢೀನ್ ಗಯ. ಯೋ ಜ಼ಹಾಜ಼್‍ನ ಖ್ಹಾಮ್ಣೆ ಗ್ರೀಕ್ ಅವಳಿಜವಳಿ ದೇವ್ತಿನು ಖ್ಹಣೇದ್ ಥು. ");
INSERT INTO vaa_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","ಹಮೆ ಸುರಕೂಸ್ ಖ್ಹಯೇರ‍್ನ ಐನ್ ಹಿಜ್ಜಾ಼ ತೀನ್‍ದನ್‍ ಥಾ. ");
INSERT INTO vaa_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","ಹಿಜ್ಜಾ಼ಥ ಚಾ಼ಲ್ತ ಹುಯಿನ್ ರೇಗಿಯ ಖ್ಹಯೇರ್‌ಮ ಪೇಶ್ಯ. ಏಕ್‍ದನ್ನ ಬಾದ್ಮ ದಕ್ಷಿಣ್‍ನೊ ವಹಿರೊ ವಾಗಲಗ್ಯೊಥೊ. ಇನಖ್ಹಾಜೆ ಬೇನದನ್ನೆ ಪೊತಿಯೋಲಕರಿ‍ ಖ್ಹಯೇರ್‌ಮ ಆಯ. ");
INSERT INTO vaa_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","ಹಮೆ ಹಿಜ್ಜಾ಼ ಥೋಡು ವಿಶ್ವಾಸಿವ್‌ನ ದೇಖ್ಯ. ಇವ್ಣಜೋ಼ಡ್ಮ ಖ್ಹಾತ್ ದನ್‌ತೋಬಿ ರ‍್ಹೇವ್ಣುಕರಿ ಬೋಲಿಲಿದು. ಇನಖ್ಹಾಜೆ ಹಮೆ ರೋಮ್‍ನ ಆಯ. ");
INSERT INTO vaa_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","ಹಮೆ ಹಜ಼್ಜ ರ‍್ಹವಾನು ರೋಮ್ಮ ಥೂತೆ ವಿಶ್ವಾಸಿನ ಮಾಲುಮ್ ಪಡ್ಯು. ಹಮೂನ ಮಳಾನಖ್ಹಾಜೆ ಥೋಡುಜ಼ಣು “ಅಪ್ಪಿಯ ನಂಗರ್‌ಲಗು ಅಜು಼ ತ್ರಿಛತ್ರಕರಿ ಝ಼ಗೋಲಗೂಬಿ ಆಯು. ಪೌಲನೆ ಇವ್ಣುನ ದೇಖಿನ್ ದೇವ್ನ ಧನ್ಯವಾದ್‌ಕರೀನ್‌ ಭಾಲಿಥಿ ಹುಮ್ಮಖ್ಹ್‌ ಹುಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","ಇನಕೇಡೆಥು ಹಮೆ ರೋಮ್‍ನ ಪೋಚಾ಼ನಿವಖ್ಹತೆ, ಪೌಲ ಇನ ದೇಖಿಲ್ಯವಾಳೊ ಏಕ್‍ಶಿಪಾಯಿ ಇನಿ ಜೋ಼ಡ್ಮ ರ‍್ಹಿಯೇಜಾ಼ಯ್ ಕರಿ ಬೋಲಾನು ಹುಕುಮ್‌ ಲಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","ತೀನ್‍ದನ್‍ ಹುವಾನಪಾರ್ ಪೌಲನೆ ಹಿಜ಼್ಜಾನ ಯೆಹೂದ್ಯರ್‌ನ ಘಲ್ಡಾವ್‌ನ ಏಕ್‌ ಝ಼ಗೊ ಎಕ್ಟು ಬುಲಾಯೊ. ಇವ್ಣೆ ಆವಾಮ ಯೋ ಇವ್ಣುನ, “ಮಾರ ಭೈಯೇವೊ ಮೇ ಅಪ್ಣ ಅದ್ಮಿಥಿ ರ‍್ಹವೊ ಗುರುಗುರಬ್‍ಲ್ಯಥಿ ಆಯೂತೆ ವಿರೋದ್‌ಥಿ ರ‍್ಹವೊ ಶಾತ್‌ ಕರ‍್ಯುಕೊಯ್ನಿ. ಮನ ಯೆರೂಸಲೇಮ್ಮ ಖೈದಿಕರೀನ್ ಧರೀನ್ ರೋಮ್‌ವಾಳಾನ ಹಾತ್ಮ ದ್ಯವಾನಿತರ ಹುಯು. ");
INSERT INTO vaa_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","ಇವ್ಣೆ ಮನ ವಿಚಾರ್ ಕರೀನ್, ಮಾರಮ ಮರಣ್ಣಿ ದಂಡನೇನು ಆಪರಾದ್ ಖಿವೂಬಿ ಕೊಂತೆಖ್ಹಾಜೆ ಮನ ಛುಟ್ಕಾರ್ ಕರ್ನುಕರಿ ಥೂ. ");
INSERT INTO vaa_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","ಕತೋಬಿ ಯೆಹೂದ್ಯರ್ ವಿರೋದ್ ಕರ‍್ಯುತೆ ಇನಖ್ಹಾಜೆ, ಮೇ ಕೈಸರನ ಖ್ಹಾಮ್ಣೆ ಬೋಲಿಲೇವುಸ್ ಕರಿ ಬೋಲ್ನುಪಡ್ಯುಥು. ಕತೋಬಿ ಮಾರು ಶೊಂತ್‍ ಅದ್ಮಿಪರ್ ಗಲ್ತಿ ನಾಲಗಾಡ್ನುಕರಿ ಬೋಲ್ಯೊಕೊಯ್ನಿ. ");
INSERT INTO vaa_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","ಆ ಕಾರ‍ಣ್ಣಾಖ್ಹಾಜೆ ಮೇ ತುಮೂನ ಬೋಲ್ನುಕರಿ ಬುಲೈಮಂಗಯೋತೆ. ಇಸ್ರಾಯೇಲ್ ಅದ್ಮಿನ ವಿಶ್ವಾಸ್ನಖ್ಹಾಜೆ ಆ ಖ್ಹಂಕ್‌ಳಿಥಿ ಭಂದೈರ‍್ಹೋಸ್.” ಕರಿ ಬೋಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","ಇವ್ಣೆ ಇನ, “ತಾರಿ ಬಾರೇಮ ಯೂದಾಯಥು ಹಮೂನ ಖಿವು ಚಿಟ್ಟಿಬಿ ಕೋ ಆಯೂನಿ. ನತರ್ ಭೈಯೇವ್‌ಮ ಏಕ್‍ಜ಼ಣೂಬಿ ತಾರಿ ಬಾರೇಮ ಖಿವೂಬಿ ಖರಾಬ್ ವಾತ್ ಖ್ಹಮ್‌ಜಾ಼ಡ್ಯುಬಿ ಕೊಯ್ನಿ ಬೋಲ್ಯುಬಿ ಕೊಯ್ನಿ. ");
INSERT INTO vaa_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","ಕತೋಬಿ ತಾರಿ ಸೋಚ್ನ ತಾರ ಮ್ಹೋಡೇಖ್ಹೂಸ್ ಖ್ಹಮ್‌ಜಾ಼ನ ಪಸಂದ್ ಕರ್ಯೆಸ್. ಶನಕತೊ ಅಖ್ಖೂಸ್ ಅದ್ಮಿಖ್ಹಾರು ಆ ಝೂ಼ಂಡ್‌ಮ ಕ್ರಿಸ್ತನು ವಿರೋದ್ ಕರೀನ್ ವಾತೆ ಬೋಲುಕರಸ್‍ಕರಿ ಹಮೂನ ಮಾಲುಮ್‌” ಕರಿ ಬೋಲ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","ಇನಖ್ಹಾಜೆ ಪೌಲ ಅಜು಼ ಇವ್ಣೆ ಸಭೆ ಮಳಾನ ಏಕ್‍ದನ್ ಖ್ಹಣೇದ್‍ಕರ‍್ಯು, ಯೋ ರೋಜ಼್ಮ ಕೈಯೆಕ್ಕಿ ಜ಼ಣು ಪೌಲನ ಘರ್ಮ ಘಣಿ ಗಣ್ತೀಥಿ ಸಬೆಮಳ್ಯು. ಇನೆ ವ್ಹಾಣೇಥು ಖ್ಹಾಂಜ಼್‌‌ಲಗು ದೇವ್ನ ರಾಜ್ಯನಿ ಬಾರೇಮ ಇನಿ ವಾತೇನ ಇವ್ಣುನ ಸಾಕ್ಷಿನ ಬೋಲ್ತೊಹುಯಿನ್.ಅಜು಼ ಮೋಶೇನು ಧರ್ಮಶಾಸ್ತ್ರ ಪ್ರವಾದಿನು ದಪ್ತರ್‌ನ ಆಧಾರ್ ಲಿದೊ. ಯೇಸುನಿ ಬಾರೇನಿ ವಾತೆಮ ಇವ್ಣುನ ವಿಶ್ವಾಸ್ ರಾಖಾನಿಘೊಣಿ ಕೋಶಿಶ್ ಕರ‍್ಯೊ. ಅನಖ್ಹಾಜೆ ಇನೆ ");
INSERT INTO vaa_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","ಪೌಲನೆ ಬೋಲ್ಯೊತೆ ಥೋಡಿ ವಾತೆನ ಥೋಡಜ಼ಣ ಯೆಹೂದ್ಯರ್‌ನೆ ಮಾನಿಲಿದು. ಕತೋಬಿ ಥೋಡಾನೆ ವಿಶ್ವಾಸ್‌ ಕರ‍್ಯುಕೊಯ್ನಿ. ");
INSERT INTO vaa_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","ಇವ್ಣಾಮ ವಗ್ಗುಟ್‌ಕೊಂತೆ ವಳಿಜಾ಼ತುಥೂತೆ ದೇಖಿನ್ ಖ್ಹರ್ತಿಮ ಪೌಲನೆ ಇವ್ಣುನ ಪವಿತ್ರಾತ್ಮನೆ ಪ್ರವಾದಿ ಹುಯಿರೋತೆ ಯೆಶಾಯಥಿ ಗುರುಗುರಬ್‍ಲ್ಯನ ಖ್ಹಾರಾನ ಖ್ಹಾಚ಼ನ ಬಾರೇಮ ಬೋಲ್ತೊ ಹುಯಿನ್, ");
INSERT INTO vaa_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","‘ತೂ ಆ ಅದ್ಮಿಕನ ಜೈ಼ನ್ ಇವ್ಣುನ ‘ತುಮೆ ಖನ್ನೆ ರ‍್ಹೀನ್ ಖ್ಹಮ್‍ಜ್ಯುತೋಬಿ ಮಾಲುಮ್‌ ಕರಾಸ್ ಕೊಯ್ನಿ; ಡೋಳ ರ‍್ಹೀನ್ ದೇಖ್ಯತೋಬಿ ಪರ್‌ಖ್ಯಾಕೊಯ್ನಿ. ");
INSERT INTO vaa_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","ಶನಕತೊ, ಆ ಅದ್ಮಿನು ದಿಲ್‌ ಬಂಡೊ ಹುಯಿಗಯು; ಇವ್ಣು ಕಾನ್‌ ರ‍್ಹಯುತೋಬಿ ಕಾನ್‌ಖ್ಹಾರು ಮೂಚಿರಾಖ್ಯುಸ್ ಖ್ಹಾಚು಼ ರ‍್ಹಯುತೋಬಿ ದೇಖಾನ ಮನ್ ಕರಾಕೊಯ್ನಿ, ನತರ್ ಅವ್ಣೆ ಡೋಳೇಥಿ ದೇಖ್ಯುಹೋತ್ತ್‌, ಕಾನ್‍ಥಿ ಖ್ಹಮ್‍ಜ್ಯುಹೋತ್, ಮನ್‍ಲಗಾಡಿನ್ ಮಾಲುಮ್‌ ಕರ‍್ಯುಹೊತ್, ಮಾರಭಣಿ ಫರಿಗಯುಹೊತ್; ಮಾರೇಥಿ ಅಛ್ಛು಼ ಹುಯಿಗುಹೊತ್. ");
INSERT INTO vaa_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","ತದೆ ಪೌಲನೆ ದೇವ್‌ನು ಆ ರಕ್ಷಣೆನ ಯೆಹೂದ್ಯರ್‌ಕಾಹೆತೆ ಇವ್ಣುನ ಬೋಲಿ ಮೊಕ್‍ಲೈರ‍್ಹುಸ್‍ ಕರಿ ತುಮೂನ ಅಛ್ಛಿನಿತರ ಮಾಲುಮ್‌ ರ‍್ಹವಾದೆ; ಕರಿ ಬೋಲಿನ್ ಇನಿ ವಾತೆನ ಖ್ಹರ್ತಿಕರ‍್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","ಇನೆ ಆ ವಾತೆನ ಬೋಲಾನ ಪಾರ್ ಯೆಹೂದ್ಯರ್ ಘಣು ಖರಾಬ್‌ಥಿ ವಿವಾದ್ ಕರ್ತುಹುಯಿನ್ ಚ಼ಲೀಗು. ");
INSERT INTO vaa_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","ಇನಕೇಡೆಥು ಯೋಸ್ ಭಾಡು ಲೀರಾಖ್ಯೊಥೊತೆ ಘರ್‌ಮ ಬೇ ವರಖ್ಹ್‌ಲಗು ರ‍್ಹೀನ್, ಇನಕನ ಆವಾಳಾನ ಖ್ಹಾರಸ್ನ ಸ್ವಾಗತ್ ಕರೀನ್ ಬುಲೈಲೇತೊಥೊ. ");
INSERT INTO vaa_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","ತದೆ ಇನೆ ಘಣುಭಾಲಿಥಿ ಅಜು಼ ಖಿವಿ ಅಡ್ಡಿಕೊಂತೆ; ದೇವ್ನು ರಾಜ್ಯನಿ ಬಾರೇಮ ಉಪದೇಶ್ ಕರ್ತೊಹುಯಿನ್ ಪ್ರಭು ಯೇಸುಕ್ರಿಸ್ತನಿ ಬಾರೇನಿ ವಾತೇನ ಬೋಧನೆ ಕರ್ತೊರ‍್ಹಿಯೊ.");
INSERT INTO vaa_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","ಯೇಸು ಕ್ರಿಸ್ತನೊ ದಾಸಬಿ ಅಪೊಸ್ತಲ ಹುವಾನಖ್ಹಾಜೆ ಬುಲಾಯೊಹುಯೋಬಿ ದೇವ್ನು ಸುವಾರ್ತೆನ ಬೋಲಾನಖ್ಹಾಜೆ ಚೂ಼ಣಾಯೊಹುಯೊ ಪೌಲ, ");
INSERT INTO vaa_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","ದೇವ್ನೆ ಘಣ ಹಗಾಮ್ನಪಾರ್‌ ಪವಿತ್ರ ದಪ್ತರ್‌ಮ ಇನ ಪ್ರವಾದಿಖ್ಹಾರಾಥಿ ವಾಗ್ದಾನ್ ಕರ‍್ಯೊತೆ, ");
INSERT INTO vaa_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","ದೇವ್‌ನೊ ಛಿಯ್ಯೊಹುಯಿರೊತೆ ಅಪ್ಣೊ ಪ್ರಭು ಯೇಸುಕ್ರಿಸ್ತನಿ ಬಾರೇಮ ಬೋಲಾನು ಹುಯಿರ‍್ಹುಸ್. ಅದಮ್‍ಜ಼ಮಾನನಿ ರೂಪ್‌ಮ ಯೋ ದಾವೀದನು ಖೂಮ್ಮ ಪೈದಹುಯೊ. ");
INSERT INTO vaa_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","ದೇವ್ನೆ ಪಹಿಲೆ ಪವಿತ್ರ ದಪ್ತರ್‌ಮ ಇನ ಪ್ರವಾದಿಥಿ ಬೋಲೈರ‍್ಹೀತೆ ಆ ವಾಗ್ದಾನ್‌ಕರ‍್ಯೊತೆ ಸುವಾರ್ತೆ ಮರ‍್ಯಾಹುಯಾಮಾಥು ಪಾಛು಼ ಜಿವ್ತುಹುಯೋತೆ ಇನಿ ಶಕಥ್ಥಿ ದೇವ್‌ನೊ ಛಿಯ್ಯೊಕರಿ ವತಾಳೈಲಿದೊ. ಯೋಸ್ ಅಪ್ಣೊ ಪ್ರಭು ಯೇಸುಕ್ರಿಸ್ತ ಹುಯಿರೊಸ್. ");
INSERT INTO vaa_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","ಇನು ನಾಮ್ನಿ ಮಹಿಮೆನಖ್ಹಾಜೇಸ್ ಅಖ್ಖಾಸ್ ದೇಖ್ಹ್‌ನು ಅದ್ಮಿಖ್ಹಾರು ಅನ ವಿಶ್ವಾಸ್‍ಕರಿನ್, ವಿಧೇಯಹುಯಿನ್ ಚಾ಼ಲನಿತರ ಕರಾನ ಅಪೊಸ್ತಲಹುವಾನಿ ಮೋಕಾನ ಯೇಸುಕ್ರಿಸ್ತಥಿಸ್ ದೇವ್ನೆ ಮನ ದೀರಾಖ್ಯೊಸ್. ");
INSERT INTO vaa_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","ರೋಮಾಪುರಮ ರ‍್ಹವಾಳ ತುಮೂನಾಬಿ ಮಳೈಲೀನ್ ಕ್ರಿಸ್ತವಾಳ ಹುವಾನಖ್ಹಾಜೆ ತುಮೂನ ಬುಲಾಯೊ. ");
INSERT INTO vaa_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","ಅಜು಼ ಇಮ್ಮಸ್ ದೇವ್ ಪ್ಯಾರ್‌ಕರಾತೆ ಅಜು಼ ಇನು ಶೊಂತ್ ಅದ್ಮಿವೊ ಕರಿ ಹುಯಿರ‍್ಹುತೆ ರೋಮ್‌ವಾಳ ತುಮುನ ಲೀಖುಕರುತೆ‍ ಶಾತ್‌ಕತೊ: ಬಾ ಹುಯಿರ‍್ಹೋತೆ ದೇವ್‍ಥೀಬಿ ಪ್ರಭು ಯೇಸುಕ್ರಿಸ್ತಥೀಬಿ ತುಮೂನ ವಾರ್‌ಖ್ಹೊಬಿ ಶಾಂತಿಬಿ ಮಳಾದೆ. ");
INSERT INTO vaa_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","ಖ್ಹಾರೇಥಿ ಪಹಿಲೆ ತುಮಾರಿ ವಿಶ್ವಾಸ್‌ನಿ ಬಾರೇಮ ಜಗತ್ನ ಅಖ್ಖಿಬಾಜು಼ ಪೂಚ್‍ತಾಚ಼್ ಹೂಕರಸ್. ಇನಖ್ಹಾಜೆ ಮೇ ತುಮಾರಭಣೀಥು ಯೇಸುಕ್ರಿಸ್ತನ ನಾಮ್‌ಥಿ ದೇವ್ನ ಧನ್ಯವಾದ್ ಕರುಸ್. ");
INSERT INTO vaa_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","ದೇವ್ನ ಛಿಯ್ಯಾನಿ ಸುವಾರ್ತೆನ ಮನ್‍ಲಗಾಡಿನ್ ಬೋಲ್ತೊಹುಯಿನ್ ಇನಾಸ್ ಮಾರ ದಿಲ್‌ಥಿ ಸೇವೆ ಕರಾವಾಳೊಹುಯಿನ್ ಭೈಕೂಸ್ ಕೊಂತೆ, ತುಮಾರಖ್ಹಾಜೆ ಬಿಂತಿ ಕರುಕರಸ್. ಅನ ದೇವಸ್ ಸಾಕ್ಷಿ. ");
INSERT INTO vaa_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","ಮೇ ಹರೇಕ್ ಪ್ರಾರ್ಥನೆಮ ದೇವ್, ಇನಿಖ್ಹೂಜ಼್‍ನಿಘೊಣಿ ಹಮ್ಕೆತೋಬಿ ತುಮಾರಕನ ಆವಾನ ಮೋಕ ಮಳಾದೆಕರಿ ದೇವ್‌ಮ ಗಿಂಗೈಲೆವುಸ್. ");
INSERT INTO vaa_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","ತುಮೂನ ಮಳಿನ್ ಥೋಡಿ ಆತ್ಮೀಕ ಆಶೀರ್ವಾದ್‌ ತುಮಾರಿ ಜೋ಼ಡ್ಮ ವಾಟಪಾಡಿನ್ ದೀನ್ ತುಮೆ ಅನೇಥಿ ಶಕತ್‍ ಲೇವ್ಣುಕರಿ ಮಾರಿ ಶಂತೋಖ್ಹ್‌ಹುಯಿರ‍್ಹಿಸ್. ");
INSERT INTO vaa_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","ಮಾರಿ ವಿಶ್ವಾಸ್‌ಮ ತುಮೇಬಿ ತುಮಾರಿ ವಿಶ್ವಾಸ್‍ಥಿ ಮೇಬಿ ಏಕ್‍ಥಿಏಕ್‍ಜ಼ಣು ಮದತ್ನ ಲೀಲೆವ್ಣುಕರಿ ಮಾರಿ ಆಖ್ಹ್. ");
INSERT INTO vaa_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","ಭೈಯೇ ಭೇನೆವೊ, ಪರೈಆದ್ಮಿಯೇವ್‍ಮ ಜುತ್ಯೋತೆತಿಮ್‍ ತುಮಾರಮಬಿ ಜೂತಿಶ್‌ಕರಿ, ಮೇ ಕೈಯೆಕ್‍ಹಲ್ಲ ತುಮುನ ಮಳಾನಖ್ಹಾಜೆ ದಿಲ್‍ಕರ‍್ಯೊತೋಬಿ, ಹಮ್ಕೆಲಗು ಶಾತ್ಕಿ ಏಕ್‍ ಆಡು ಹೂಕರ್ತುಥು ಕರಿ ತುಮೇಬಿ ಮಾಲುಮ್‌ಕರಿರಾಕೊ ಕರಿ ಮಾರಿ ಆಖ್ಹ್‌. ");
INSERT INTO vaa_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","ಮೇ ಗ್ರೀಕ್‍ವಾಳನಾಬಿ ಅಜು಼ ಅಲಕ್‌ಅದ್ಮಿವೊನಾಬಿ ಅಕ್ಲಿನಾಬಿ, ಬಿಣ್‌ಖ್ಹೈಲಿನಾಬಿ ಫೇಡ್ನುತೆ ಏಕ್‌ ಕರ್ನಿ ಮಾರಪರ್ ಛಾ಼. ");
INSERT INTO vaa_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","ಅಮ್‍ಛಾ಼ತೆ ಇನಾಖ್ಹಾಜೆ ರೋಮ್ ಖ್ಹಯೇರ್‌ಮ ಛಾ಼ತೆ ತುಮೂನಾಬಿ ಸುವಾರ್ತೆ ಬೋಲಾನ ಮೇ ಹುಮ್ಮಖ್ಹ್‌ಥಿ ತಯಾರ್ ಹುಯಿರ‍್ಹೋಸ್. ");
INSERT INTO vaa_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","ಮಾರಿ ಸುವಾರ್ತೆನಿ ಬಾರೇಮ ಮನ ಪೂರ ಆತ್ಮ ವಿಶ್ವಾಸ್ ಛಾ಼. ಶನಕತೊ ಯೋ ಪಹಿಲೆ ಯೆಹೂದ್ಯರ್‌ನ ಇನಕೇಡೆಥು ಯೆಹೂದ್ಯಕಾಹೇತೆ ಇವ್ಣುನಾಸ್ ಕಾಹೆತೆ ವಿಶ್ವಾಸ್‌ಕರವಾಳ ಹರೇಕ್‌ನಬಿ ಆ ಸುವಾರ್ತೆ ರಕ್ಷಣೆನ ಉಬ್‍ಜಾ಼ವನಿ ದೇವ್ನಿ ಶಕತ್‍ಹುಯಿರ‍್ಹೀಸ್. ");
INSERT INTO vaa_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","ಕಿಮ್‌ಕತೊ ದೇವ್ ಸುವಾರ್ತೆಥಿ ಅದ್ಮಿವೋನ ಇನಭಣಿ ಅಛ಼್ಛುಹುವಾನಿಘೊಣಿ ಕರಸ್. ಅಥ್ರಾನು ಸಂಬಂದ ಶುರುವಾತ್‍ಥು ಖ್ಹರ್ತಿಲಗೂಬಿ ವಿಶ್ವಾಸ್‌ನಪರ್‌ ಭೀರೆಸ್. “ಅಮ್‌ ನೀತಿವಾಳೊ ವಿಶ್ವಾಸ್‌ಥೀಸ್ ಜಿವ್‌ಶೆ” ಕರಿ ಪವಿತ್ರಪುಸ್ತಕ್ಮ ಲಿಖೈರ‍್ಹುಸ್. ");
INSERT INTO vaa_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","ಖರಾಬ್ ಚಾ಼ಲ್‌ಥಿ ಖ್ಹಾಚ಼ನ ಲಪಾಡವಾಳು ಹುಯಿರ‍್ಹುತೆ ಅದ್ಮಿವೋನು ಅಖ್ಖಿಥರಾನು ಭಕ್ತಿಕೊಂತೆ ಅಜು಼ ಪಾಪ್ನುಚಾ಼ಲ್ನ ಉಪ್ಪರ್ ದೇವ್ನು ಇರಾದೊ ಪರ್‌ಲೋಕ್‌ಥು ಉತ್ರಿನ್‍ ಆವಸ್. ");
INSERT INTO vaa_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","ಶನಖ್ಹಾಜೆಕತೊ ದೇವ್ನಿಬಾರೇಮ ಇವ್ಣುನ ಬರೋಬರ್‌ಥಿ ಮಾಲುಮ್ ಹುಯಿರ‍್ಹುಸ್, ಯೊ ಇವ್ಣುನ ದೇವ್ನೆಸ್ ವತಾಳ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","ಕಿಮ್‌ಕತೊ ಡೋಳಾಮ ದೆಖಾವಕೊಂತೆ ಇನಿ ಚಾ಼ಲ್‍ಚ಼ಲಣ್‍ಅಖ್ಖು ಕತೊ ಇನಿ ಕದೇಬಿ ರ‍್ಹವಾನಿ ಶಕತ್‌ಬಿ, ದೇವ್ನಿಸ್ವಭಾವ್‍ಬಿ, ಜಗತ್‌ ಉಬ್‌ಜಾ಼ಯೋತೆ ಧರೀನ್ ಇನೆ ಕರ‍್ಯೊತೆ ಉಬ್‍ಜಾ಼ವ್ಣಿಥಿ ಯೋ ಮಾಲುಮ್‍ಪಡಸ್. ಅಮ್‍ ರ‍್ಹವಾಪರ್ ಇವ್ಣೆ ಖಿವು ಭಾಣುಬಿ ಬೋಲಾನ ಕೊಉಷೇನಿ. ");
INSERT INTO vaa_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","ಶನಕತೊ ಇವ್ಣೆ ದೇವ್ನ ಮಾಲುಮ್ ಕರಿರಾಖ್ಯುತೋಬಿ ಇನ ದೇವ್‌ಕರಿ ಖ್ಹರಾಯುಕೊಯ್ನಿ ಇನಿ ಮದತ್‍ನ ಯಾದ್‌ಕರಿನ್ ಧನ್ಯವಾದ್ ಕರ‍್ಯುಕೊಯ್ನಿ. ಇನ ಬದಲ್ ಇವ್ಣ ಕೊಂತೆಕಾಮ್ಮ ಮಘನ್ ಹುಯಿಗು. ಅಕ್ಕಲ್‌ಕೊಂತೆ ಇವ್ಣೊ ದಿಲ್‌ ಅಂಧಾರೇಥಿ ಭರೈರ‍್ಹುಸ್. ");
INSERT INTO vaa_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","ಇವ್ಣೆಸ್ ಗ್ಯಾನಿಕರಿ ಬೋಲಿಲಿನ್ ಇವ್ಣೆ ಬಿಣ್‍ಅಕ್ಲಿನು ಹುಯಿರ‍್ಹುಸ್. ");
INSERT INTO vaa_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","ಮಟಾಕೊಂತೆ ದೇವ್ನಿ ಮಹಿಮೆನ ಇವ್ಣೆ ನಾಶ್ ಹುಯಿಜಾ಼ಯಿತೆ ಅದ್ಮಿ, ಜಾನ್ವರ್‌, ಜಿನಾವರ್‌, ಖ್ಹವ್‍ಳಾತೆ ಕೀಡ್‌ಕಮ್ಟಾನ ಮೂರತ್ನ ಪೂಜ಼ಕರಲಗ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","ಇನಖ್ಹಾಜೆ ಅದ್ಮಿವೋನ ದಿಲ್ನಿ ಲಾಲಚ್‌ನಿಘೊಣಿ ಚಾ಼ಲಿಲಿನ್ ಇವ್ಣ ಇವ್ಣ ಶರೀರ್‌ನ ಇವ್ಣಮಹಿ ಖ್ಹರಮ್‌ ಕಡೈಲ್ಯವಾದೆಕರಿ ದೇವ್ನೆ ಇವ್ಣುನ ಕಚಿಂಡ್‌ ಚಾ಼ಲ್‌ಮ ಮ್ಹೇಲಿದಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","ಇವ್ಣೆ ದೇವ್ನು ಖ್ಹಾಚ಼ನ ಝೂ಼ಟುಕರಿ ಬದಲೈಲೀನ್, ಉಬ್‌ಜಾ಼ಯೋತೆ ದೇವ್ನ ಆರಾದನೆ ಕರ‍್ಯುಕೊಂತೆ ಉಬ್‍ಜ್ಯುಹುಯ ರಾಛಾ಼ನಸ್ ಆರಾದನೆ ಕರ‍್ಯು. ಅಖ್ಖ ಹಗಾಮ್ಮ ಉಬ್‍ಜಾ಼ಯೊತೆ ದೇವ್ನಾಸ್ ಹಮೇಶ ಸ್ತುತಿ ಹುವಾದೆ, ಆಮೆನ್. ");
INSERT INTO vaa_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","ಇವ್ಣೆ ಅಥ್ರಾನು ಕರ‍್ಯುತೆ ಇನಖ್ಹಾಜೆ ದೇವ್ ಇವ್ಣುನ ರ‍್ಹೇವ್ಣುತೆ ಶರೀರ್‌ನು ಪರಕ್ನು ಸುಖಭೋಗ್‍ನ ಮ್ಹೆಂದಿನ್ ನಾಕರ‍್ನುತೆ ಶರೀರ್‌ನು ಪರಕ್ನು ಸುಖಭೋಗ್‍ನ ಕರಾನ ಮ್ಹೇಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","ಇಮ್ಮಸ್ ಪರ್ಖ್ಹೊ ಮ್ಹಾಮುಲಿನು ತಯೇಡಾನಿ ಶರೀರಿಕ್‍ ಭೋಗ್‌ನ ಮ್ಹೇಲಿನ್ ಇವ್ಣ ಇವ್ಣಾಮಸ್ ಖ್ಹರಮ್‌ಕೊಂತೆ ಕಾಮ್ ಕರಾಥಿ ಇವ್ಣುನ ಮಳ್‌ಣುತೆ ನಿಶತ್‍ನ ಲೀಲಿದು. ");
INSERT INTO vaa_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","ಶನಖ್ಹಾಜೆಕತೊ ಯೊ ಅದ್ಮಿಖ್ಹಾರು ದೇವ್ನಿ ಗ್ಯಾನ್ನ ಝಿಟ್ಕಾರ‍್ಯುತೆ ಇನಖ್ಹಾಜೆ ಇವ್ಣುನ ಪಾಪ್ನುಕಾಮ್‍ ಕರಾನ ಮ್ಹೆಲಿದಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","ಇವ್ಣೆ ಅಖ್ಖಿಥರಾನು ಖರಾಬ್‍ಫನೈಮ ಭರೈರ‍್ಹವಾಳು ಹುಯಿರ‍್ಹುಸ್, ಶೈತಾನ್ನಿಬುದ್ಧಿ, ಪೈಶಾನಿಲಾಲಚ್, ಪೇಟ್ನೊಬಳಾಪೊ, ಭೋಕಾನು, ಝ಼ಗ್‍ಡೊ, ಠಗಾವನು, ಕೇಡ್‍ಕರಾನು, ಅಜು಼ ಚಾ಼ಡಿಬೋಲವಾಳು, ");
INSERT INTO vaa_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","ಏಕ್ನಪರ್‌ ಏಕ್‍ ಖರಾಬ್ ಬೋಲವಾಳು ದೇವ್ನವಹೇರ್ ಕರವಾಳುಬಿ, ಖ್ಹರಮ್‍ಕಡಾವಾಳೂಬಿ ಹಂಕಾರ್‌ವಾಳೂಬಿ, ಗಬ್ಬರ್‌ಕರವಾಳು ಅಜು಼ ಬಡೈಮಾರವಾಳೂಬಿ, ಇವ್ಣೆ ಕದೇಬಿ ಖರಾಬ್ ಕಾಮ್ ಕರಾನಸ್‍ ಸೋಚವಾಳು, ಆಯಾಬಾನಿ ವಾತೆನ ನಾ ಖ್ಹಮ್‍ಜಾ಼ವಾಳೂಬಿ, ");
INSERT INTO vaa_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","ಬಿಣ್‍ಸೋಚ್‍ವಾಳೂಬಿ, ವಾತ್ನ ಛು಼ಕಿಜಾ಼ಯಿತೆ, ಇವ್ಣೆ ಬಿಜೇಕ್ನ, ಗೋರ್‌ನಾರ‍್ಹವಾಳುಬಿ ಹುಯು. ");
INSERT INTO vaa_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","ಅಥ್ರಾನುಖ್ಹಾರು ಚ಼ಲಾವವಾಳು ಮರಣ್‍ಮ ಭಾಗ್‌ಲ್ಯಾವಾಳು ಕರಿ ಬೋಲಾನು ದೇವ್ನಿ ನಿಯಮ್‌ ಹುಯಿರ‍್ಹಿಶೆಕರಿ ಮಾಲುಮ್ ಥೂ. ಕತೋಬಿ ಖ್ಹಮ್‍ಜೀನ್‍ಬಿ ಇವ್ಣು ಇವ್ಣೇಸ್ ಯೋ ಅಖ್ಖಾ ಕಾಮ್ನ ಕರವಾಳು ನಾ ಹುಯಿನ್, ಇಮ್‌ ಕರವಾಳನ ಭಾಲ್ ದ್ಯವಾಳು ಹುಯಿರ‍್ಹೂಸ್. ");
INSERT INTO vaa_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","ಇನಖ್ಹಾಜೆ ‘ಬಿಜ಼ ಅದ್ಮಿನಿ ಬಾರೇಮ ತೀರ್ಪ್‌ ಕರಾವಾಳೊ ಮಾರೊ ದೋಸ್ತಿ, ತೂ ಕೋಣ್‌ರ‍್ಹಿಯೋತೊಬಿ ತುನ ಇನೇಥಿ ಕ್ಷಮಾಕೊಯ್ನಿ. ಶನಕತೊ ಬಿಜೇಕ್‍ಜ಼ಣಾನು ಗಲತ್ನ ಢೂಂಡಾವಾಳೊ ಹುಯಿರೋತೆ ತೂ, ಇವ್ಣೆ ಕರಾತೆ ಇನಾಸ್ ತೂಬಿ ಕರಸ್. ಇನಖ್ಹಾಜೆ ತಾರುತೂಸ್ ಅಪರಾದಿ ಕರಿ ಸಾಬಿತ್ ಕರಿಲೇಸ್. ");
INSERT INTO vaa_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","ಅಪರಾದ್ನ ಕರಾವಾಳಾನಿ ಬಾರೇಮ ದೇವ್ ಕರಾನು ತೀರ್ಪ್ ಖ್ಹಾಚನ ಲೀನಸ್ ರ‍್ಹೇಸ್‍ಕರಿ ಅಪ್ಣುನ ಮಾಲುಮ್ ಛಾ಼. ");
INSERT INTO vaa_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","ಕತೋಬಿ ಅಲಾ ಮಾರೊ ದೋಸ್ತಿ, ಎಥ್ರಾನುಖ್ಹಾರು ಚ಼ಲಾವವಾಳಾನ ಉಪ್ಪರ್ ನ್ಯಾವ್ನುತೀರ್ಪ್‌ ಕರಾತೆ ತೂ ದೇವ್ನ ತೀರ್ಪ್‌ಥಿ ಬಚಿಗಯೊಕರಿ ಸೋಚಸ್ಕಿ ಶು? ");
INSERT INTO vaa_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","ಇನಿ ಘಣಿ ದಯಾಬಿ, ಖ್ಹಮಾಳಿಲ್ಯವಾನು ಅಜು಼ ಹಮೇಶಾನಿ ಶಾಂತಿ ಅನಖ್ಹಾರು ತೂ ಝಿಟ್ಕಾರಸ್ಕಿ ಶು? ದೇವ್ನಿ ಅಛ್ಛಿಗುಣ್‍ ತುನ ದಿಲ್‌ ಫರೈಲ್ಯಾವಭಣಿ ಚ಼ಲಾವ್‍ಶೆಕರಿ ಬೋಲಾನು ತುನ ಮಾಲುಮ್ ಕೊಯ್ನಿಕಿ ಶು? ");
INSERT INTO vaa_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","ಕತೋಬಿ ತಾರೊ ದಿಲ್‌ ಮೊಂಡ್‍ಬಿ ಕಠಣ್ ಹುಯಿರುಸ್. ಇನಖ್ಹಾಜೆ ತುಮೆ ದೇವ್ನೊ ಇರಾದೊ ಅಜು಼ ನೀತಿಥಿರ‍್ಹವಾನು ನ್ಯಾವ್ನುತೀರ್ಪ್‌ನ ದನ್ಮ ತುಮೂನ ಉಷೇತೆ ನಿಶತ್ನ ಅಜೂ಼ಬಿ ಜ಼ಮಕರ್ತೊಹುಯಿನ್ ವಳೇಜಾ಼ಸ್. ");
INSERT INTO vaa_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","ಶನಕತೊ ದೇವ್ ಹರೇಕ್ ಜ಼ಣಾನಾಬಿ ಇವ್ಣ ಇವ್ಣ ಕಾಮ್ನ ದೇವ್ಣುತೆ ಇನಾಮ್ ದಿಶೆ. ");
INSERT INTO vaa_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","ಥೋಡುಜ಼ಣು ಅಛ್ಛಾ಼ನ ಕರ್ತುಹುಯಿನ್. ಮಹಿಮೆ, ಇಜ಼್ಜತ್‌, ಹಮೇಶನಜಾನ್ನ ಜಿವ್ಣನ ಢೂಂಡಸ್. ಇವ್ಣುನ ದೇವ್ ಹರ್‌ಹಮೇಶಾನಿ ಜಿ಼ಂದ್‌ಗಿ ದಿಶೆ. ");
INSERT INTO vaa_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","ಕತೋಬಿ ಉಭ್‌ರ‍್ಯುತೆ ಅದ್ಮಿಖ್ಹಾರು ಶೊಂತ್‍ ಅಖ್ಹ್‌ಕರವಾಳು ಖ್ಹಾಚ಼ನಲೀನ್ ಚಾ಼ಲಾನು ಮ್ಹೇಲಿನ್ ಠಗಾವ್ಣಿನ ಲೀನ್ ಚಾ಼ಲಸ್ಕಿ ಇವ್ಣಪರ್ ದೇವ್‌ನೊ ಇರಾದೋಬಿ ಚ಼ಂಢಾಳ್‍ಬಿ ರಂಚ಼್‌ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","ಪಹಿಲೆ ಯೆಹೂದ್ಯರ್‌ನ ಇನಪಾಛಾ಼ಳ್ ಯೆಹೂದ್ಯಕಾಹೇತೆ ಇವ್ಣುನ ಖರಾಬ್‌ಥಿ ಚಾ಼ಲವಾಳ ಹರೇಕ್‌ಜ಼ಣಾನ ಉಪ್ಪರ್‌ ವದೇಖ್ಹ್‌ಬಿ, ಲತಾಡಾಬಿ ಆವ್‌ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","ಕತೋಬಿ ಅಛ್ಛಿ ವಾಟ್‌ಪರ್ ಚಾ಼ಲವಾಳ ಅಖ್ಖಾಮ ಪಹಿಲೆ ಯೆಹೂದ್ಯರ್‌ನ ಇನಕೇಡೆಥು ಯೆಹೂದ್ಯಕಾಹೇತೆ ಇವ್ಣುನ ದೇವ್ ಮಹಿಮೆ ಮರ್ಯಾದಿ ಅಜು಼ ಸಮಾಧಾನ್ನ ದಿಶೆ. ");
INSERT INTO vaa_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","ಶನಕತೊ ದೇವ್, ಬೇದ್‌ಭಾವ್‌ ಕರಾಕೊಯ್ನಿ. ದೇವ್ ಹರೇಕ್‍ಜ಼ಣಾನ ಎಕ್ಕಸ್ ಆಳ್ತಿಮ ತೀರ್ಪ್ ದೇಸ್. ");
INSERT INTO vaa_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","ಯೆಹೂದ್ಯರ್‌ಕಾಹೆತೆ ಇವ್ಣೆ ಮೋಶೇನು ಧರ್ಮಶಾಸ್ತ್ರ ನಾರ‍್ಹೀನ್ ಪಾಪ್‍ಕರ‍್ಯುತೊ ಧರ್ಮಶಾಸ್ತ್ರ ನಾರ‍್ಹೀನಸ್ ನಾಶ್ ಹುಯಿಜಾ಼ಶೆ; ಅಜು಼ ಯೆಹೂದ್ಯರ್‌ನ ಧರ್ಮಶಾಸ್ತ್ರ ಛಾ಼, ಇವ್ಣೆ ಇನ ಮಹಿರ‍್ಹೀನ್ ಪಾಪ್‍ಕರ‍್ಯುತೊ ಧರ್ಮಶಾಸ್ತ್ರಥಿ ತೀರ್ಮಾನ್ ಲಿಶೆ. ");
INSERT INTO vaa_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","ಕೋಣ್‌ಬಿ ಖಲಿ ಧರ್ಮಶಾಸ್ತ್ರ ಖ್ಹಮ್‌ಜ್ಯುತೊ ದೇವ್ನಖ್ಹಾಮ್ಣೆ ನೀತಿವಾಳು ಉಶೆಕೊಯ್ನಿ. ಕತೋಬಿ ಧರ್ಮಶಾಸ್ತ್ರ ಬೋಲಾತೆ ಹರೇಕ್ನ ಪಾಡಿಚಾ಼ಲವಾಳುಸ್ ನೀತಿವಾಳುಕರಿ ಚೂ಼ಣೈಜಾ಼ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","ಯೆಹೂದ್ಯರ್‌ಕಾಹೆತೆ ಇವ್ಣುನ ಧರ್ಮಶಾಸ್ತ್ರ ಕೊಯ್ನಿ ಕತೋಬಿ ಇವ್ಣೆ ಶಾತ್‌ ಕರಸ್ಕಿ ಯೋಅಖ್ಖು ಧರ್ಮಶಾಸ್ತ್ರನಿಮತ್ ರ‍್ಹೇಸ್. ಇವ್ಣುನ ಧರ್ಮಶಾಸ್ತ್ರ ನಾ ರ‍್ಹಯುತೋಬಿ ಇವ್ಣುನ ಇವ್ಣೇಸ್ ಧರ್ಮಶಾಸ್ತ್ರ ಹುಯಿರ‍್ಹೂಸ್. ");
INSERT INTO vaa_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","ಇವ್ಣಿ ಚಾ಼ಲ್‍ಚ಼ಲಣಸ್ ಇವ್ಣ ದಿಲ್ಮ ಧರ್ಮಶಾಸ್ತ್ರನಿ ಹುಕಮ್‍ಅಖ್ಖು ಲೀಖೈರ‍್ಹುಸ್‍ಕರಿ ವತಾಳಿದೇಸ್. ಇವ್ಣಿ ದಿಲ್ನಿಸಾಕ್ಷಿಬಿ ಆಹೈರುತೆ ಖ್ಹಾಚು಼ಕರಿ ವತಾಳಿದೇಸ್. ಶನಖ್ಹಾಜೆಕತೊ ಏಕೇಕ್‍ಹಲ್ಲ ಇವ್ಣಿ ಸೋಚ್‍ಅಖ್ಖು ಇವ್ಣೇಸ್ ಗಲ್ತಿವಾಳಕರಿ ವತಾಳಿದೇಸ್. ಅಜು಼ ಏಕೇಕ್‍ಹಲ್ಲ ಇವ್ಣುನ ಬರೋಬರ್‌ಬಿ ಕರಸ್. ");
INSERT INTO vaa_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","ಇನಖ್ಹಾಜೆ ಮೇ ಬೋಲುತೆ ಸುವಾರ್ತೆನಿಘೋಣಿ ಯೋ ದನ್ಮ ಅಮ್ಮಸ್ ದೇವ್ ಯೇಸುಕ್ರಿಸ್ತಥಿ ಅಖ್ಖಾಮ ಗಪ್ಲಥ್ಥಿ ರ‍್ಹೇಯ್ತೆ ಸೋಚ್ನ ತೀರ್ಪ್‌ ಕರ್ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","ಕತೋಬಿ ತೂ ಯೆಹೂದ್ಯಕರಿ ಬೋಲೈಲ್ಯಾವಾಳ ಧರ್ಮಶಾಸ್ತ್ರನಸ್ ಆಧಾರ್ ಕರಿರಾಖ್ಯೊಸ್, ತೂ ದೇವ್ನಿಬಾರೇಮ ಬಡೈಮಾರಿಲೇಸ್. ");
INSERT INTO vaa_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","ಧರ್ಮಶಾಸ್ತ್ರಥಿ ಉಪದೇಶ್‌ನ ಲೀನ್‌, ಇನಿ ಖ್ಹೂಜ್‌ನ ಕರಿರಾಖವಾಳೊಬಿ, ಆಹೈರುತೆ ಬರೋಬರ್‌ನು ಯೋ ಬರೋಬರ್‌ನು ಕಾಹೆಕರಿಬಿ ತರೀಪ್‌ಶ ಕರಾವಾಳೊ ಹುಯಿರೊಸ್. ");
INSERT INTO vaa_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","ಕಾಣಾನ ತೂ ಏಕ್‍ ಮಾರಗ್ ವತಾಳವಾಳೊ ಹುಯಿರೊಸ್‍ ಅಜು಼ ಅಂಧಾರಮ ರ‍್ಹವಾಳನ ಉಜಾ಼ಳು ಹುಯಿರೊಸ್ ಕರಿ ತುನ ಮಾಲುಮಸ್ ಛಾ಼. ");
INSERT INTO vaa_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","ಶಾತ್ಬಿ ಮಾಲುಮ್‍ಕೊಂತೆ ಇವ್ಣುನ ಗುರುಹುಯಿನ್‍ಬಿ, ಧರ್ಮಶಾಸ್ತ್ರನಿ ಬಾರೇಮ ರ‍್ಹೇಸ್ತೆ ಅಖ್ಖಿ ಗ್ಯಾನ್ ಅಜು಼ ಖ್ಹಾಚು಼ ತುನ ಮಾಲುಮ್ ಛಾ಼. ");
INSERT INTO vaa_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","ಅಲಕ್‍ ಅದ್ಮಿವೋನ ಉಪದೇಶ್ ಕರಾವಾಳೊ ತೂ, ತಾರುತೂಸ್ ಶನ ಕೊ ಶಿಕಾನಿ? ಚೋ಼ರ್ ನಾಕರ‍್ನುಕರಿ ಬೋಧನೆ ಕರಾವಾಳೊ ತೂಸ್ ಚೋ಼ರ್ ಕರಸ್‍ಕಿಶು? ");
INSERT INTO vaa_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","ತೂ ವ್ಯಬಿಚಾರ್ ನಾಕರ‍್ನುಕರಿ ಬೋಲವಾಳೊ ತೂಸ್ ವ್ಯಬಿಚಾರ್ ಕರಸ್‍ಕಿಶು? ಮೂರತ್‍ಅಖ್ಖಾನ ವಿರೋದ್ ಕರಾವಾಳೊ ತೂ ಮಂದಿರ್‌ನಾಸ್ ಲೂಟಿ ಕರಾಸ್ಕಿಶು? ");
INSERT INTO vaa_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","ಧರ್ಮಶಾಸ್ತ್ರನಿ ಬಾರೇಮ ಬಡೈಮಾರಿಲ್ಯವಾಳೊ ತೂ ಯೋ ನಿಯಮ್ನ ತೋಡಿನ್ ದೇವ್ನ ಖ್ಹರಮ್‌ ಕಾಡಸ್‍ಕಿಶು? ");
INSERT INTO vaa_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","“ಯೆಹೂದ್ಯವಾಳ ತುಮಾರ ಖ್ಹಾಜೆ ಯೆಹೂದ್ಯರ್‌ಕಾಹೆತೆ ಅದ್ಮಿಯೇವ್‍ನ ಬೀಚ್ಮ ದೇವ್ನು ನಾಮ್ ದೂಷಣೆ ಹೂಕರಸ್” ಕರಿ ಪವಿತ್ರದಪ್ತರ್‌ಮ ಲೀಖೈರ‍್ಹುಸ್. ");
INSERT INTO vaa_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","ತೂ ಧರ್ಮಶಾಸ್ತ್ರನ ವಿಧೇಯ ಹುಯಿನ್ ಚಾ಼ಲ್ಯೊತೊ ತುನೆ ಕರೈರಾಖ್ಯೊತೆ ಖ್ಹತ್ನನ ಫಾಯಿದೊ ಹುಯಿರ‍್ಹಿಶೆ; ಕತೋಬಿ ತೂ ಧರ್ಮಶಾಸ್ತ್ರ ಮೀರಿನ್ ಚಾ಼ಲವಾಳೊ ರ‍್ಹಯೋತೊ, ತುನ ಖ್ಹತ್ನ ಹುಯಿರ‍್ಹುತೋಬಿ ಹುಯುಕೊಂತೆ ತಿಮ್ ಹುವಾಸ್. ");
INSERT INTO vaa_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","ಖ್ಹತ್ನ ನಾಕರೈರಾಖವಾಳೊ ಧರ್ಮಶಾಸ್ತ್ರನಿ ನಿಯಮ್‌ನಿ ಪರಕ್ಮ ಚಾ಼ಲ್ಯೊತೊ ಖ್ಹತ್ನವಾಳೊ ನಾರ‍್ಹಯೊತೋಬಿ, ಖ್ಹತ್ನ ರ‍್ಹಾವಾಳನಿತರ ಗಣ್ತಿಮ ರ‍್ಹೀಶ್‍ಕೊಯ್ನಿಕಿಶು? ");
INSERT INTO vaa_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","ತುಮೆ ಖ್ಹತ್ನಕರೈರಾಖ್ಯಸ್; ಲೀಖೈಹುಯು ಧರ್ಮಶಾಸ್ತ್ರನಬಿ ರಾಖಿಮ್ಹೇಲ್ಯಸ್ ತೋಬಿ ಇನ ಮೀರಿನ್ ಚಾ಼ಲಸ್. ಅಮ್‌ರ‍್ಹೀನ್, ಶರೀರ್‌ಥಿ ಖ್ಹತ್ನ ನಾಕರಾಯುತೋಬಿ ಮ್ಹಾಮೂಲಿಥಿ ಧರ್ಮಶಾಸ್ತ್ರನ ಪಾಡಿಚಾ಼ಲವಾಳು ಖ್ಹತ್ನಕರೈರಾಖ್ಯತೆ ತುಮೂನ ತೀರ್ಪ್‌ ದಿಶೆ. ");
INSERT INTO vaa_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","ಭಾರ್‌ ಖಲಿ ಯೆಹೂದ್ಯಹುಯಿರ‍್ಹವಾಳೊ ಯೆಹೂದ್ಯಕಾಹೆ; ಅಜು಼ ಭಾರ್‌ ಶರೀರ್‌ಮ ಖಲಿ ಕರಿರಾಖ್ಯುತೆ ಖ್ಹತ್ನ ಖ್ಹಾಚು಼ ಖ್ಹತ್ನಕಾಹೆ. ");
INSERT INTO vaa_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","ಕತೋಬಿ ದಿಲ್ನಮಹಿ ಯೆಹೂದ್ಯ ಹುಯಿರ‍್ಹಾವಾಳೋಸ್ ಖ್ಹಾಚೊ಼ ಯೆಹೂದ್ಯ; ಇಮ್ಮಸ್ ದೇವ್ನಆತ್ಮನ ಕಾಮ್‍ಥಿಹುವಾನು ಖ್ಹತ್ನ ದಿಲ್ಮ ಹುವಾಸ್. ಯೋ ಖಲಿ ನಿಯಮ್‌ನಿ ಲೀಖಾಪಟ್ ಹುಯಿರ‍್ಹುಕೊಯ್ನಿ. ದೇವ್‍ಥೀಸ್‍ ಆವಾನು ಹುಯಿರ‍್ಹುಸ್ ಪಣ್ಕಿ ಎಥ್ರಾನವಾಳನ ಖ್ಹರಾವ್ಣಿ, ಅದ್ಮಿಥಿ ಆವಾನು ಕಾಹೆ. ");
INSERT INTO vaa_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","ಇಮ್‌ರ‍್ಹಯುತೊ ಯೆಹೂದ್ಯರ್‌ಹುಯಿನ್ ಯೆಹೂದ್ಯರ್‌ಕಾಹೆತೆ ಅವ್ಣೇಥಿ ವಿಶೇಷ್ ಶಾತ್? ನತರ್ ಖ್ಹತ್ನ ಕರೈಲ್ಯವಾಥಿ ಹುಯುತೆ ಫಾಯಿದೊ ಶಾತ್? ");
INSERT INTO vaa_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","ಖ್ಹಾರಿ ಬಾರೇಮ ಬೋಲಾನುಬಿ ಘಣು ಫಾಯಿದೊ ಛಾ಼. ಪಹಿಲೆಥು ದೇವ್ನಿ ವಚನ್‍ ಯೆಹೂದ್ಯರ್‌ನ ದೆವೈರ‍್ಹೀಸ್. ");
INSERT INTO vaa_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","ಕತೋಬಿ ಇವ್ಣಾಮ ಥೋಡಜ಼ಣಾನೆ ವಿಶ್ವಾಸ್‌ ಕರ‍್ಯುನಾಕರ‍್ಯುತೋಬಿ ಶಾತ್? ದೇವ್ ಬಿಣ್‌ ವಿಶ್ವಾಸ್‌ವಾಳೊಕಿ ಶು? ");
INSERT INTO vaa_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","ಕದೇಬಿ ಕೊಯ್ನಿ. ಅದ್ಮಿಖ್ಹಾರು ಝೂ಼ಟು ರ‍್ಹಯುತೋಬಿ, ದೇವ್ ಎಕ್ಕಸ್ ಜ಼ಣೊ ಖ್ಹಾಚೊ಼. ಪವಿತ್ರ ದಪ್ತರ್‌ಮ ಅಮ್‍ ಲೀಖೈರುಸ್ಕಿ, “ತೂ ತಾರಿ ವಾತೇವ್‍ಮಾಸ್ ನೀತಿವಾಳೊಕರಿ ತೀರ್ಮಾನ್‌ ಹೋಣು. ಹೊಜ಼್ಜತ್‌ ಭಿಡಾನಿವಖ್ಹ್‌ತೆ ತೂ ಜೂತ್‌ನು” ಕರಿ ಲೀಖೈರ‍್ಹುಸ್. ");
INSERT INTO vaa_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","ಕತೋಬಿ ಅಪ್ಣಿ ಅನೀತಿಥಿ ದೇವ್ನು ಕಾಮ್‍ಅಖ್ಖು ನೀತಿಪರ್ ಭಿಯುಸ್‍ಕರಿ ದೆಖಾವಸ್ ಕರಿ ಬೋಲಿಲಿಯೇಕಿ ಶು? ದೇವ್ ಅಪ್ಣುನ ನಿಶತ್ ದಿದೊತೊ ಇನೆ ಅಪ್ಣುನ ಠಗಾಯೊ ಕರಿ ಬೋಲೆಜಾ಼ಯ್‍ಕಿ ಶು? ಅನ ಮೇ ಅದ್ಮಿನಿ ಪರಕ್ಮ ಬೋಲು ಕರುಸ್ತೆ. ");
INSERT INTO vaa_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","ದೇವ್ ನ್ಯಾವ್‍ಕರಾವಾಳೊ ನಾ ರ‍್ಹಯೊಹೋತ್ತೊ ಯೋ ಜಗತ್ನ ತೀರ್ಪ್‌ಕರಾನು ತೋಬಿ ಕಿಮ್‍ ಉಶೆ? ");
INSERT INTO vaa_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","ಮಾರಿ ಝೂ಼ಟಿಥಿ ದೇವ್ನು ಖ್ಹಾಚಿನ ಉಪ್ಪರ್ ಪಾಡೀನ್ ಇನಿ ಮಹಿಮೆನ ವತಾಳನು ಉಶೇತೊ ಮನ ಪಾಪಿಕರಿ ಕಿಮ್ ತೀರ್ಪ್‌ಹುಯಿಶ್? ");
INSERT INTO vaa_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","ಅಮ್ ರ‍್ಹವಾಪರ್ ಅಛ಼್ಛುಕರಿ ದೆಖಾವನು ರ‍್ಹಿಯುತೊ ಅಪ್ಣೆ ಖರಾಬ್‍ನಾ ಕರೇಜಾ಼ಯ್‍ಕರಿ ಶನ ನಾಬೋಲ್ನು. ಇನಖ್ಹಾಜೆ ಥೋಡುಜ಼ಣು ಮನ ದೂಷಣೆ ಕರೀನ್ ಮಾರಪರ್ ಕೈಏಕ್ ವಾತೆ ಬೋಲ್ತುಹುಯಿನ್ ಝಿಟ್ಕಾರುಕರಾಸ್. ಎಥ್ರಾನವಾಳನ ನಿಶತ್‌ ಹುವಾನು ನ್ಯಾವಸ್‌. ");
INSERT INTO vaa_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","ಇಮ್‍ಕತೊ ಶಾತ್? ಅಪ್ಣೆ ಯೆಹೂದ್ಯಕಾಹೇತೆ ಇವ್ಣೆಥಿಬಿ ಊಚಾ಼ಕಿ ಶು? ಕದೇಬಿ ಕೊಯ್ನಿನಿ! ಮೇ ತದೇಸ್‌ ಯೆಹೂದ್ಯರ್‌ರ‍್ಹವೊ ಯೆಹೂದ್ಯಕಾಹೆತೆ ರ‍್ಹವೊ ಖ್ಹಾರೂಸ್ ಪಾಪ್ನ ಮಹಿರ‍್ಹಾವಳು ಕರಿ ಮೇ ಪಹಿಲೇಸ್ ದೆಖಾಡಿರಾಖ್ಯೋಸ್. ");
INSERT INTO vaa_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","“ಪವಿತ್ರ ದಪ್ತರ್‌ಮ ಲೀಖೈರ‍್ಹೂತೆ ತಿಮ್; ಕೋಣ್‌ಬಿ ನೀತಿವಾಳು ಕೊಯ್ನಿ, ಏಕ್‍ ಜ಼ಣೂಬಿ ಕೊಯ್ನಿ. ");
INSERT INTO vaa_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","ಅಕ್ಲಿ ಏಕ್‍ ಜ಼ಣೂಬಿ ಕೊಯ್ನಿ. ದೇವ್ನ ಢೂಂಡಾವಾಳೊ ಏಕ್‌ಬಿ ಕೊಯ್ನಿ. ");
INSERT INTO vaa_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","ಖ್ಹಾರುಸ್ಜ಼ಣು ದೇವ್‍ಥಿ ದೂರ್ ಜೈ಼ರ‍್ಹೂಸ್‍, ಖ್ಹಾರೂಸ್ ಫಾಯಿದೊಕೊಂತೆ ಹುಯಿರ‍್ಹೂಸ್. ಅಛ್ಛು಼ ಕರಾವಾಳೊ ಕೋಣ್‌ಬಿ ಕೊಯ್ನಿ, ಏಕ್‍ ಜ಼ಣೂಬಿ ಕೊಯ್ನಿ, ");
INSERT INTO vaa_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","ಇವ್ಣೊ ನ್ಹೇಟೊಸ್ ನಿಕ್‍ಳಿರ‍್ಹುತೆ ಮಖ್ಹಾಣ್ಯು ಹುಯಿರ‍್ಹುಸ್. ಇವ್ಣೆ ಝೂ಼ಟು ಜಿಭಾನ್‌ವಾಳು ಹುಯಿರ‍್ಹುಸ್. ಇವ್ಣ ಹೋಟ್‌ನ ಪೀಠೆ ಖ್ಹಾಪ್‍ನೊ ಝಾರ್‌ ಛಾ಼ ");
INSERT INTO vaa_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","“ಇವ್ಣ ಮ್ಹೋಡಾಮ ಶಾಪ್ನ ಶಬರ್‌, ಭರೈರ‍್ಹುಸ್. ");
INSERT INTO vaa_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","“ಇವ್ಣ ಗೋಡ ಲ್ಹೋಯಿನ ಕಾಡಾನ ಖದ್‍ಬದುಕರಸ್. ");
INSERT INTO vaa_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","ಇವ್ಣೆ ಜಾ಼ಸ್ತೆ ಹಿಜ್ಜಾ಼, ಖ್ಹತಾಪ್ಣಿಬಿ ನಾಶ್‍ಬಿ ರ‍್ಹಿಶೆ. ");
INSERT INTO vaa_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","ಇವ್ಣೆ ಶಾಂತಿನೊ ಮಾರಗ್‌ನಸ್ ಮಾಲುಮ್ ಕರ‍್ಯುಕೊಯ್ನಿ, ");
INSERT INTO vaa_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","ಇವ್ಣ ದಿಲ್‌ಮ ದೇವ್‌ನೊ ಧಡುಕೊಸ್ ಕೊಯ್ನಿ.” ");
INSERT INTO vaa_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","ಧರ್ಮಶಾಸ್ತ್ರ ಶಾತಸ್ ಬೋಲ್ಯುತೋಬಿ ಧರ್ಮಶಾಸ್ತ್ರನ ಮಹಿರ‍್ಹಾವಾಳನಸ್ ಸಂಬಂದ್‍ಪಡಸ್‍ಕರಿ ಅಪ್ಣುನ ಮಾಲುಮ್‌ಛಾ಼. ಅಮ್ ಖ್ಹಾರಾಸ್‍ನು ಮ್ಹೋಡು ಖ್ಹೊಪೊ ಹುಯಿಜಾ಼ಶೆ. ಅಜು಼ ಜಗತ್‍ಖ್ಹಾರು ದೇವ್ನ ನ್ಯಾವ್‍ನತೀರ್ಪ್‌ನ ದನ್ಮ ಗಣ್ತಿದೆವ್ಣು ಪಡ್‌ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","ಶನಕತೊ ಖಿವು ಅದ್ಮಿ ರ‍್ಹಿಯೊತೋಬಿ ದೇವ್ನಿ ನಿಯಮ್ಮ ಧರ್ಮಶಾಸ್ತ್ರನ ಪಾಡಿಚ಼ಲಾಥಿ ನೀತಿವಾಳೊಕರಿ ಹುವಾನ ಕಿನೇಥೀಬಿ ಉಶೆಕೊಯ್ನಿ. ಧರ್ಮಶಾಸ್ತ್ರ ಅಪ್ಣಿ ಪಾಪ್ನಖಲಿ ವತಾಳಸ್‍ ಎತ್ರೇಸ್. ");
INSERT INTO vaa_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","ಕತೋಬಿ ಹಮ್ಕೆ ದೇವ್ ಧರ್ಮಶಾಸ್ತ್ರನಿ ಮದತ್‌ಕೊಂತೇಸ್ ಅದ್ಮಿವ್‍ನ ನೀತಿವಾಳೊ ಕರಿಬಣಾವನ ಮಾರಗ್‌ನ ವತಾಳಿರಾಖ್ಯೊಸ್. ಕತೋಬಿ ಆಹೈರುತೆ ಧರ್ಮಶಾಸ್ತ್ರ ಅಜು಼ ಪ್ರವಾದಿ ಖ್ಹಾರು ಆ ನವಮಾರಗ್‍ನಿ ಬಾರೇಮ ಅಪ್ಣುನ ಬೋಲಿರಾಖ್ಯೊಸ್. ");
INSERT INTO vaa_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","ಯೇಸುಕ್ರಿಸ್ತಮ ವಿಶ್ವಾಸ್‍ಕರಾವಾಳಥಿಸ್‌ ವಿಶ್ವಾಸಿಖ್ಹಾರವ್ನ ದೇವ್ನಿ ನೀತಿ ಆವ್‌ಶೆ. ಅನಾಮ ಖೆವುಬಿ ಅಶಿಲ್ ಕಮ್‌ಶಿಲ್ ಕೊಯ್ನಿ. ");
INSERT INTO vaa_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","ಶನಕತೊ ಖ್ಹಾರುಸ್‌ಜ಼ಣು ಪಾಪ್‍ಕರೀನ್ ದೇವ್ನಿ ಮಹಿಮೆಥಿ ದೂರ್‌ಹುಯಿಗು. ");
INSERT INTO vaa_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","ಕತೋಬಿ ದೇವ್ನು ಫುಗಟ್ ವಾರ್‌ಖ್ಹೇಥಿ ಇವ್ಣುನ ಛುಟ್ಕಾರ್ ದ್ಯವಾವಾಳೊ ಯೇಸುಕ್ರಿಸ್ತಥಿ ನೀತಿವಾಳುಕರಿ ತೀರ್ಪ್‍ಹುವಸ್. ");
INSERT INTO vaa_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","ಇನೆ ರಂಚ್ಯೊತೆ ಇನ ಲ್ಹೋಯಿಥಿ ಇನ ಉಪ್ಪರ್ ಭರೋಖ್ಹೊ ರಾಖವಾಳ ಹರೇಕ್ನ ಪಾಪ್‌ ಪರಿಹಾರ್ ಹೋಣುಕರಿ ಇನಾಸ್ ಸಮರ್ಪಣ್‌ ಕರಿಲಿದೊ. ಪಾಛ಼್‌ಲ್ಯ ಹಗಾಮ್ಮ ಅದ್ಮಿವೋನೆ ಕರ‍್ಯುತೆ ಪಾಪ್ನ ಬರೋಬರ್‌ನಿ ನಿಶತ್‍ ದಿದೊಕೊಂತೆ ದೇವ್ನೆ ಖ್ಹಮಾಳಿಲಿನ್ ಚಾ಼ಲ್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","ಅಮ್ನಿಪರಕ್ಮ ದೇವ್ ಮೇ ನೀತಿವಾಳೊಕರಿ ವತಾಳಿಲೇಸ್.ಅಜು಼ ಯೋ ಯೇಸುನ ವಿಶ್ವಾಸ್‍ಕರಾವಾಳ ಹರೇಕ್ನ ನೀತಿವಾಳಕರಿ ಬಣಾವಸ್. ");
INSERT INTO vaa_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","ಅಮ್‌ರ‍್ಹಾವಪರ್‌ ಅಪ್ಣಿ ಬಾರೇಮ ಬಡೈಮಾರಿಲ್ಯವಾನ ಶನುಬಿ ಮೋಕ ಛಾ಼ಕಿಶು? ಕೊಯ್ನಿ. ಅಪ್ಣೆ ಧರ್ಮಶಾಸ್ತ್ರನ ಪಾಡಿ ಚಾ಼ಲಿಯೇಸ್‍ಕಿ ಶು! ಶನ? ಅಪ್ಣೆ ಶನ ವಿಶ್ವಾಸ್‌ ಕರ್‌ಯೇಸ್‌ಕಿ ಯೊ ಅಪ್ಣುನ ಊಚು಼ ಕರಾನಖ್ಹಾಜೆ ಮೋಕ ದೇಸ್. ");
INSERT INTO vaa_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","ಧರ್ಮಶಾಸ್ತ್ರ ಬೋಲಾತೆ ಕಾಮ್‍ಥಿ ಕಾಹೆ ಪಣ್ಕಿ, ಖಲಿ ವಿಶ್ವಾಸ್‍ಥಿಸ್ ಖಿವೂಬಿ ಅದ್ಮಿ ನೀತಿವಾಳೊಕರಿ ಗಣ್ತಿಮ ಆವಸ್. ");
INSERT INTO vaa_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","ದೇವ್ ಯೆಹೂದ್ಯರ್‌ನ ಖಲಿ ದೇವ್‍ಕಿಶು? ಯೋ ಯೆಹೂದ್ಯರ್‌ಕಾಹೆತೆ ಇವ್ಣುನಾಬಿ ದೇವ್‍ಹುಯಿರ‍್ಹೇಸ್‍ ಕೊಯ್ನಿಕಿಶು? ಒಹೊ, ಯೆಹೂದ್ಯರ್‌ಕಾಹೆತೆ ಇವ್ಣುನಾಬಿ ದೇವ್ ಹುಯಿರ‍್ಹೋಸ್. ");
INSERT INTO vaa_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","ದೇವ್ನೆ ಖ್ಹತ್ನವಾಳಾನ ನೀತಿವಾಳುಕರಿ ತೀರ್ಪ್‌ಕರಾನ ಇವ್ಣಿ ವಿಶ್ವಾಸಸ್ ಆಧಾರ್. ಇಮ್ಮಸ್ ಖ್ಹತ್ನಕೊಂತೆ ಇವ್ಣುನ ತೀರ್ಪ್‌ಕರಾನಾಬಿ ವಿಶ್ವಾಸಸ್ ಕಾರಣ್ ಹುಯಿರುಸ್. ");
INSERT INTO vaa_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","ಇಮ್‍ಕತೊ, ಅಪ್ಣೆ ವಿಶ್ವಾಸ್‍ಥಿ ಧರ್ಮಶಾಸ್ತ್ರನ ಬಿಣ್‍ ಮತ್ಲಬ್‌ನು ಬಣೈನಾಖೆಸ್‍ಕಿಶು? ಕದೇಬಿ ಕೊಯ್ನಿ. ಅಪ್ಣೆ ಧರ್ಮಶಾಸ್ತ್ರನ ಖಲಿ ಪಾಡಿಧರಿಯೇಸ್. ");
INSERT INTO vaa_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","ಇಮ್‍ಕತೊ ಅಗ್ಲಿ ಪಿಳ್‌ಗಿವಾಳಾನ ಅಪ್ಣುನ ಗುರುಗುರಬ್‌ಲ್ಯೊ ಅಬ್ರಹಾಮ್‌ನೆ ಅನಿ ಬಾರೇಮ ಶಾತ್‍ಲೀಲಿದೊಕರಿ ಅಪ್ಣೆ ಬೋಲಿಯೆ? ");
INSERT INTO vaa_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","ಅಬ್ರಹಾಮ್ ಇನ ಅಛ಼್ಛಕಾಮ್‌ಥಿ ನೀತಿವಾಳೊಕರಿ ತೀರ್ಪ್‌ಲ್ಯವಾಳೊ ಹುಯಿರೊಹೊತ್ತೊ ಖ್ಹರಾವ್ಣಿ ಕರೈಲ್ಯಾವಾನ ಇನ ಮೋಕ ರ‍್ಹಿಯುಹೊತ್. ಕತೋಬಿ ದೇವ್ನ ಖ್ಹಾಮ್ಣೆ ಕಾಹೆ, ");
INSERT INTO vaa_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","“ಧರ್ಮಶಾಸ್ತ್ರ ಅಮ್‍ಬೋಲಾಸ್, ಅಬ್ರಹಾಮ್‌ನೆ ದೇವ್ನ ವಿಶ್ವಾಸ್‍ ಕರ‍್ಯೊ; ಯೋ ವಿಶ್ವಾಸ್‌ ಇನಿ ಗಣ್ತಿಮ ನೀತಿಕರಿ ಗಣ್ತಿ ಹುಯೊ”. ");
INSERT INTO vaa_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","ಕಾಮ್‍ಕರಾವಾಳನ ಮಳಾತೆ ಮಜ಼್‌ದೂರಿ ಕೃಪೆಥಿ ಕಾಹೆ. ಯೋ ಇನ ಮಳ್ನುಥೂತೇಸ್ ಕರಿ ಗಣ್ತಿ ಹುವಾಸ್. ");
INSERT INTO vaa_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","ಕತೋಬಿ ಏಕ್‌ ಜ಼ಣೊ ಇನು ಶೊಂತ್ ಕಾಮ್ನ ಉಪ್ಪರ್ ವಿಶ್ವಾಸ್ ಕರಾನು ಮ್ಹೇಲಿನ್, ಗಲ್ತಿವಾಳಾನ ನೀತಿವಾಳೊಕರಿ ಕರಾವಾಳ ದೇವ್ನ ಉಪ್ಪರ್ ಇನಿ ವಿಶ್ವಾಸ್ ಕರಾನುರ‍್ಹಿಯುತೊ ಆ ಇನೊ ಭರೋಖ್ಹೊ ಇನ ನೀತಿವಾಳೊಕರಿ ಗಣ್ತಿಕರಸ್‍. ");
INSERT INTO vaa_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","ದೇವ್ ಕಿನು ಅಛ್ಛು಼ ಕಾಮ್ನ ದೇಖಸ್ ಕೊಯ್ನಿತೆ ನೀತಿವಾಳೊ ಕರಿ ಗಣ್ತಿ ಕರಸ್ಕಿ ಯೋಸ್ ಧನ್ಯಕರಿ, ದಾವೀದಜಿನು ಅಮ್‍ ಬೋಲಸ್. ಕಿಮ್‌ಕತೊ, ");
INSERT INTO vaa_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","“ಕಿನು ಗಲತ್‍ಖ್ಹಾರು ಪರಿಹಾರ್ ಹುಯಿರ‍್ಹುಸ್ಕಿ, ಕಿನು ಪಾಪ್‌ಖ್ಹಾರು ಕ್ಷಮಾಪಣ್ ಹುಯಿರ‍್ಹುಸ್ಕಿ ಯೋಸ್ ಧನ್ಯ ಹುಯಿರ‍್ಹೋಸ್. ");
INSERT INTO vaa_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","ಪ್ರಭು ಕಿನ ಪಾಪ್‍ನ ಗಣ್ತಿಮ ಲೇಯ್‍ಕೊಯ್ನಿಕಿ ಯೋ ಅದ್ಮಿ ಖ್ಹಾಚ಼ಮಸ್ ಧನ್ಯ!” ");
INSERT INTO vaa_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","ಯೋ ಆಶೀರ್ವಾದ್‍ನಿ ವಚನ್‍ ಖಲಿ ಖ್ಹತ್ನ ಹುಯಿರ‍್ಹವಾಳನಕೀ ನತರ್ ಖ್ಹತ್ನ ಕರೈರಾಖಕೊಂತೆ ಇವ್ಣುನಾಬಿ ಛಾ಼ಕಿ ಶು? ಶನಖ್ಹಾಜೆಕತೊ ಪವಿತ್ರ ದಪ್ತರ್‌ಮ ಅಮ್‍ ಬೋಲೈರ‍್ಹುಸ್, “ಅಬ್ರಹಾಮ್‌ ಇನಿ ವಿಶ್ವಾಸ್‌ಥೀಸ್ ನೀತಿವಾಳೊಕರಿ ಗಣ್ತಿ ಹುಯೊ”. ");
INSERT INTO vaa_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","ಯೋ ಕದೆ ಹುಯುತೆ? ಇನ ಖ್ಹತ್ನ ಹುಯಿಗುತೆ ತದೇಕಿ ಖ್ಹತ್ನಹುವಾನ ಪಹಿಲೆ? ಯೋ ಖ್ಹತ್ನ ಹುಯುತೆ ತದೆಕಾಹೆ, ಖ್ಹತ್ನಹುವಾನ ಅಗಾಡಿಸ್. ");
INSERT INTO vaa_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","ಒಹೊ, ಖ್ಹತ್ನಹುವಾನ ಪಹಿಲೇಸ್ ಇನಥೂತೆ ವಿಶ್ವಾಸ್‍ನು ಖ್ಹಣೇದ್ ಹುಯಿನ್, ನೀತಿನು ಮುದ್ರಾನ ಲೀಲಿದೊ. ಅಮ್‍ರ‍್ಹವಾಪರ್ ಯೊ ವಿಶ್ವಾಸ್‍ಕರವಾಳ ಅಖ್ಖಾನಾಬಿ, ಇವ್ಣುನ ಖ್ಹತ್ನ ನಾ ಹುಯುತೋಬಿ ಅಬ್ರಹಾಮ್ ಅಖ್ಖಾಸ್ನ ಆತ್ಮೀಕ ಬಾಹುಯೊ. ಇನಖ್ಹಾಜೆ ಇವ್ಣೆ ನೀತಿವಾಳಕರಿ ಗಣ್ತಿಮಹುಯು. ");
INSERT INTO vaa_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","ಎತ್ರೇಸ್ ಕಾಹೆ ಖ್ಹತ್ನ ಹುಯಿರ‍್ಹವಾಳನಾಬಿ ಯೊ ಬಾ ಹುಯಿರೊಸ್, ಇವ್ಣುನಖಲಿ ಖ್ಹತ್ನ ಹುಯಿರ‍್ಹಿತೆ ಇನಖ್ಹಾಜೆ ಕಾಹೆ ಕತೋಬಿ ಅಪ್ಣೊ ಗುರುಗುರಬ್‌ಲ್ಯೊ ಹುಯಿರ‍್ಹೋತೆ ಅಬ್ರಹಾಮ್‌ನ ಖ್ಹತ್ನಹುವಾನ ಪಹಿಲೆ ಥೂತೆ ವಿಶ್ವಾಸ್‌ನ ಮಾರಗ್‌ಪರ್ ಇವ್ಣೇಬಿ ಚಾ಼ಲಸ್ ಇನಖ್ಹಾಜೆ ಇವ್ಣುನ ಯೊ ಬಾ ಹುಯಿರೊಸ್. ");
INSERT INTO vaa_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","ಜಗತ್‍ನಾಸ್ ಹಕ್‍ದಾರ್ ಉಷೆಕರಿ ಬೋಲಾನು ವಾಗ್ದಾನ್ ಅಬ್ರಹಾಮ್ ಧರ್ಮಶಾಸ್ತ್ರನ ಪಾಡಿ ಚಾ಼ಲುಕರ್ತೊಥೋತೆ ಇನಖ್ಹಾಜೆ ಕಾಹೆ. ವಿಶ್ವಾಸ್‍ಥಿ ಆವಾತೆ ನೀತಿಹುಯಿರ‍್ಹಿಸ್. ");
INSERT INTO vaa_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","ಶನಕತೊ ಧರ್ಮಶಾಸ್ತ್ರಥಿ ಜಿವವಾಳೂಸ್ ಹಕ್‌ದಾರ್‌ ರ‍್ಹಯೂತೊ, ವಿಶ್ವಾಸ್‌ನ ಮತ್‌ಲಬ್ ಕೊಂನ್ತೆ ಹುಯಿಜಾ಼ಶೆ. ವಾಗ್ದಾನ್ ಬಿಣ್‌ಫಾಯಿದಾನು ಹುಯಿಗು ");
INSERT INTO vaa_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","ಶನಕತೊ ಧರ್ಮಶಾಸ್ತ್ರ ಅದ್ಮಿವೋನ ದೇವ್ನ ಇರಾದಮ ನಾಖಸ್‍, ಕತೋಬಿ ಧರ್ಮಶಾಸ್ತ್ರ ನಾ ರ‍್ಹಿಯುಹೊತ್ತೊ ಇನ ವಿಧೇಯ ದ್ಯವಾನುಬಿ ಕೋ ರ‍್ಹಿಯುಹೊತ್ನಿ. ");
INSERT INTO vaa_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","ಇನಖ್ಹಾಜೆ ಯೋ ವಾಗ್ದಾನ ವಾರ್‌ಖ್ಹೇಥಿಸ್ ಮಳಸ್. ಆ ವಾಗ್ದಾನ್ ಧರ್ಮಶಾಸ್ತ್ರನ ಆಧಾರ್ ಹುಯಿರ‍್ಹುತೆ ಇವ್ಣುನಾಸ್ ಕಾಹೆತೆ, ಅಬ್ರಹಾಮ್‌ನಬಿ ಇನಿ ಪಿಳ್ಗಿವಾಳಾನ ಫುಗಟ್‍ಥಿ ಮಳಾಸ್ತೆ ವಾಗ್ದಾನಸ್ ಇನಾಮ್ ಹುಯಿರ‍್ಹುಸ್. ಅಮ್‌ ಅವ್ಣೆ ಅಬ್ರಹಾಮ್‌ನಿ ಘೋಣಿ ಭರೋಖ್ಹೊ ಕರ್ಶೆ ಶನಕತೊ ಯೋ ಅಪ್ಣಖ್ಹಾರಸ್‍ನ ಬಾ ಹುಯಿರ‍್ಹೋಸ್. ");
INSERT INTO vaa_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","“ಮೇ ತುನ ಕೈಏಕ್‌ ಜ಼ಗ್‌ಜಾ಼ತ್‌ನ ಅದ್ಮಿವೋನ ಬಾಕರಿ ದೀರಾಖ್ಯೊಸ್!” ಕರಿ ಪವಿತ್ರ ದಪ್ತರ್‌ಮ ಲಿಖೈರ‍್ಹುಸ್. ದೇವ್ ಮರಾವಾಳನ ಜಾನ್‌ ದ್ಯವಾಳೋಬಿ, ಕೋರ‍್ಹೆಂತೆ ಇನ ರ‍್ಹವಾನಿತರ ಕರವಾಳೋಬಿ ಹುಯಿರೋತೆ ದೇವ್‌ಮ ಅಬ್ರಹಾಮ್‌ನೆ ವಿಶ್ವಾಸ್‍ಕರ‍್ಯೊ. ಇನಖ್ಹಾಜೆ ಆ ವಾಗ್ದಾನ್ನ ದೇವ್‍ಥೀಸ್‍ ಇನೆ ಲಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","ಭರೋಖ್ಹೊ ರಾಖಾನ ಶನು ಆಧಾರ್ ನಾರ‍್ಹುಯುತೋಬಿ ಅಬ್ರಹಾಮನೆ ನಂಬ್ಯೊ ಅಜು಼ ಭರೋಖ್ಹೊ ಕರ‍್ಯೊ ಅಮ್ಮಸ್ ಕೈಯೇಕ್‌ ದೇಖ್ಹ್‌ನ ಆತ್ಮೀಕ ಬಾಹುಯೊ. ಪವಿತ್ರ ದಪ್ತರ್‌ಮ ತಾರಿ ಪಿಳ್ಗಿ ಆಬ್‌ನ ಶುಕ್ಕರ್‌ನಿತರ ರ‍್ಹಿಶೆ. ಕರಿ ಪವಿತ್ರ ದಪ್ತರ್‌ಮ ಬೋಲ್ಯುತೆ ತಿಮ್. ");
INSERT INTO vaa_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","ಯೋ ತದೇಸ್‌ ಖ್ಹುಮಾರ್ ಖ್ಹೋ ವರಖ್ಹ್‌ನೊ ಹುಯಿರ‍್ಹಿನ್ ಇನು ಶರೀರ್ ತದೇಸ್‌ ಕಮ್ಲಯಿಗೈಥಿ, ಇನಿ ಬಾವಣ್‍ ಸಾರನ ಲಡ್ಕಹುವಾನ ದನ್ ಖ್ಹತಮ್ ಹುಯಿಗುತೋಬಿ, ಯೋ ವಿಶ್ವಾಸ್‌ಮ ಕಮ್‍ಜೋ಼ರಿ ಹುಯೊಕೊಯ್ನಿ. ");
INSERT INTO vaa_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","ಇನೆ ದೇವ್ನಿ ವಾಗ್ದಾನ್ ಕರ‍್ಯೊತೆ ಬಾರೇಮ. ಯೋ ಅವಿಶ್ವಾಸ್‌ಥಿ ಗುಮಾನಿ ಕರ‍್ಯೊಕೊಯ್ನಿ. ಯೋ ಹಿಮ್ಮಥ್ಥಿ ಭರೈನ್. ಇನೆ ದೇವ್ನ ಮಹಿಮೆ ಕರ‍್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","ಯೋ ವಾಗ್ದಾನ್ನ ಚ಼ಲಾವನ ದೇವ್ ಶಕತ್‌ವಾಳೊ ಹುಯಿರ‍್ಹೋಸ್‍ಕರಿ ಪೂರ ಘಟ್‍ಥಿ ಭೀರವಾಳೊ ಹುಯೊ. ");
INSERT INTO vaa_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","ಇನಖ್ಹಾಜೆ ಅಬ್ರಹಾಮ್ ಇನಿ ವಿಶ್ವಾಸ್‌ಥೀಸ್ “ನೀತಿಕರಿ ಗಣ್ತಿ ಹುಯೊ”. ");
INSERT INTO vaa_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","ಯೋ ನೀತಿವಾಳೊ ಗಣ್ತಿಹುಯು, ಕರಿ ಬೋಲಾನಿ ವಾತೆಖಲಿ ಇನ ಏಕ್‍ಜ಼ಣಾನ ಖ್ಹಾಜೆಸ್ ಕಾಹೆ. ");
INSERT INTO vaa_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","ಹೈರುತೆ ಅಪ್ಣಖ್ಹಾಜೇಬಿ ಕತೊ, ಅಪ್ಣೊ ಪ್ರಭು ಯೇಸುಕ್ರಿಸ್ತನ ಮರ‍್ಯಹುಯಮಾಥು ಉಠಾಡ್ಯೋತೆ ದೇವ್ನ ವಿಶ್ವಾಸ್ ಕರಾವಾಳು ಅಜು಼ ನೀತಿವಾಳ ಕರಿ ಬೋಲೈರ‍್ಹಾತೆ ಅಪ್ಣುನಾಬಿ ಲಿಖೈರ‍್ಹುಸ್. ");
INSERT INTO vaa_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","ದೇವ್ ಯೇಸುನ ಅಪ್ಣ ಪಾಪ್ನಖ್ಹಾಜೆ ಮರಣ್ಣ ದೀನಾಖಿನ್ ಅಜು಼ ಅಪ್ಣುನ ನೀತಿವಾಳ ಕರಿ ತಿರ್ಮಾನ್‌ ಹುವಾನಖ್ಹಾಜೆಸ್‌ ಜಾನ್‌ಥಿ ಉಠಾಡೈಗಯೊ. ");
INSERT INTO vaa_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","ಅಮ್‌ರ‍್ಹವಾಪರ್ ವಿಶ್ವಾಸ್‍ಥಿ ನೀತಿವಾಳುಕರಿ ತೀರ್ಪ್ ಲೀಲಿದಾತೆ ಅಪ್ಣುನ ಅಪ್ಣೊ ಪ್ರಭು ಯೇಸುಕ್ರಿಸ್ತಥಿ ದೇವ್ನಿ ಜೋ಼ಡ್ಮ ಸಮಾಧಾನ್‍ ರ‍್ಹೇಸ್. ");
INSERT INTO vaa_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","ಇನೆ ಅಪ್ಣುನ ವಿಶ್ವಾಸ್‍ಥಿ ದೇವ್ನಿ ಕೃಪೆನ ಆಖ್ಹ್‌ರಾಮ ಲಾಯೊ. ಹಮ್ಕೆ ಅಪ್ಣೆ ಇನಮಹಿ ಜಿವುಕರಿಯೇಸ್. ಇನಖ್ಹಾಜೆ ದೇವ್ನಿ ಮಹಿಮೆಮ ಅಪ್ಣೆ ಭಾಗ್‍ಹುಯಿರ‍್ಹಾಸ್‍ಕರಿ ನಂಬಿನ್ ಇನಮಹಿ ಅಪ್ಣೆ ಹುಮ್ಮಖ್ಹ್‌ ಲಿಯೇಸ್. ");
INSERT INTO vaa_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","ಎತ್ರೇಸ್ ಖಲಿಕಾಹೆ, ಅಪ್ಣುನ ಆವಸ್ತೆ ಖ್ಹತಾಪ್ಣಿಮಾಬಿ ಖುಷಿಥಿ ಛಿಯೆ. ಕತೋಬಿ ಖ್ಹತಾಪ್ಣಿ ಖ್ಹಮಾಳಿ ರ‍್ಹವಾನ ಶಿಕಾಡಸ್‌ಕರಿ ಅಪ್ಣುನ ಮಾಲುಮ್‌ ಛಾ಼. ");
INSERT INTO vaa_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","ಖ್ಹಮಾಳಿಲ್ಯವಾನು ಹುಯಿರ‍್ಹುತೆ ಅಪ್ಣುನ ದೇವ್‌ಮ ಘಟ್‍ಥಿ ರ‍್ಹವಾಖ್ಹರ್‌ಕು ಕರಸ್, ಅಜು಼ ದೇವ್‌ಮ ಘಟ್‍ಥಿ ರ‍್ಹಿಯಾತೊ ಅಪ್ಣಾಮ ಭರೋಖ್ಹಾನ ಉಬ್‌ಜಾ಼ವಸ್. ");
INSERT INTO vaa_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","ಆ ಭರೋಖ್ಹೊ ಕದೇಬಿ ನಿರಾಶ್‍ ಕೋಕರ್‌ಶೇನಿ, ಶನಕತೊ ದೇವ್ನಿ ಪ್ಯಾರ್‌ ಅಪ್ಣುನ ಇನಿ ವರಹುಯಿರ‍್ಹಿತೆ ಪವಿತ್ರಾತ್ಮಥಿ ಅಪ್ಣ ದಿಲ್ಮ ರಂಚಿರಾಖ್ಯೊಸ್. ");
INSERT INTO vaa_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","ಅಪ್ಣೆ ಪಾಪ್‌ಥಿ ಬಿಣ್‍ ಶಕತ್‌ವಾಳ ಹುಯಿರಾತೆ ತದೇಸ್‌ ದೇವ್ನೆ ಚೂ಼ಣಿಲಿದೊತೆ ವೇಳ್ಮ ಕ್ರಿಸ್ತನೆ ಖರಾಬ್ ಅದ್ಮಿವೋನಖ್ಹಾಜೆ ಮರ‍್ಯೊ. ");
INSERT INTO vaa_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","ಏಕ್‍ ನೀತಿವಾಳನಖ್ಹಾಜೆ ಜಾನ್‍ದ್ಯವಾನು ಘಣು ಮುಶ್ಕಿಲ್. ಅಛ಼್ಛೊ ಏಕ್‍ಜ಼ಣಾನಖ್ಹಾಜೆ ಜಾನ್‍ದ್ಯವಾನು ಹಿಮ್ಮತ್‍ ಕರ‍್ಯುತೋಬಿ ಕರೆಜಾ಼ಯ್. ");
INSERT INTO vaa_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","ಕತೋಬಿ ಅಪ್ಣೆ ಪಾಪಿ ಹುಯಿರ‍್ಹವಾನಿ ವಖ್ಹ್‌ತೇಸ್ ಕ್ರಿಸ್ತನೆ ಅಪ್ಣಖ್ಹಾಜೆ ಮರೀನ್ ದೇವ್ನೆ ಅಪ್ಣಪರ್ ಇನಛಾ಼ತೆ ಪ್ಯಾರ್‌ನ ವತಾಳಿರಾಖ್ಯೊಸ್. ");
INSERT INTO vaa_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","ಕ್ರಿಸ್ತನ ಲ್ಹೋಯಿಥಿ ಅಪ್ಣೆ ಹಮ್ಕೆ ದೇವ್ನಿಜೋ಼ಡ್ಮ ನೀತಿವಾಳಕರಿ ಚೂ಼ಣೈರ‍್ಹಾಸ್. ದೇವ್ನ ಚ಼ಂಢಾಳ್‌ಥಿ ಇನಭಣಿಥು ಅಜೂ಼ಬಿ ಕೆತ್ರೆ ಘಣೇಥಿ ಬಚಿಜಾವಾಳ ಹುಯಿರ‍್ಹಿಶು? ");
INSERT INTO vaa_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","ಅಪ್ಣೆ ದೇವ್ನ ವಹೇರ‍್ಯ ಹುಯಿರ‍್ಹವಾನಿ ವಖ್ಹ್‌ತೇಸ್. ಅಪ್ಣುನ ಇನ ಛಿಯ್ಯಾನಿ ಮರಣ್‍ಥಿ ಅಪ್ಣುನ ಇನ ದೋಸ್ತಿಖ್ಹಾರ ಕರಿ ಬಣೈರಾಖ್ಯೊಸ್. ಹಮ್ಕೆ ಅಪ್ಣೆ ದೇವ್ನ ದೋಸ್ತಿಹುಯಿರಾತೆ ಇನಖ್ಹಾಜೆ ದೇವ್ ಇನ ಛಿಯ್ಯಾನ ಜಾನ್‌ಥಿ ಅಪ್ಣುನ ಕೆತ್ರೆ ಜಾ಼ಖ್ಹತ್ ರಕ್ಷಣೆ ನಾಮಳ್‍ನು? ");
INSERT INTO vaa_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","ಕತೋಬಿ ಅಪ್ಣುನ ದೇವ್ನ ದೋಸ್ತಿ ಹುವಾಖ್ಹರ್ಕು ಕರ‍್ಯೊತೆ ಅಪ್ಣೊ ಪ್ರಭು ಯೇಸುಕ್ರಿಸ್ತಥಿ ದೇವ್ ಕರ‍್ಯೊತೆ ಕಾಮ್ನಖ್ಹಾಜೆ ಅಪ್ಣೆ ಖುಷಿ ಕರ್ಯೆಸ್. ");
INSERT INTO vaa_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","ಇನಖ್ಹಾಜೆ, ಏಕ್‍ಜ಼ಣೇಥಿ ಜಗತ್‌ಮ ಪಾಪ್‍ಆಯು ಅಜು಼ ಯೋಪಾಪ್ ಇನಿಜೋ಼ಡ್ಮ ಮರಣ್ಣಾಬಿ ಲಾಯು. ಅನಖ್ಹಾಜೇಥಿ ಮರಣ್ ಅಖ್ಖಾ ಅದ್ಮಿವೋನ ಉಪ್ಪರ್ ಫೈಲಾಯು ಶನಖ್ಹಾಜೆಕತೊ ಅಖ್ಖುಜ಼ಣು ಪಾಪ್‍ಕರ‍್ಯು. ");
INSERT INTO vaa_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","ಧರ್ಮಶಾಸ್ತ್ರ ದೆವವಾನ ಅಗಾಡಿಸ್ ಪಾಪ್ ಜಗತ್‌ಮಾ ಥು. ಕತೋಬಿ ಧರ್ಮಶಾಸ್ತ್ರ ಕೊಯ್ನಿತೆ ತದೆ ಪಾಪ್ ಗಣ್ತಿಮ ಕೋ ಆಯುಹೋತ್ನಿ. ");
INSERT INTO vaa_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","ಕತೋಬಿ ಮರಣ್ ಅದಾಮ್‍ಥಿ ಮೋಶೆಲಗು ರಾಜ಼್ ಚ಼ಲವ್‍಼ಕರ್ತುಥು. ಆದಾಮನೆ ಕರ‍್ಯೊತೆ ಅಪರಾದ್‌ನಖ್ಹಾಜೆ ಪಾಪ್‍ಕೊಕರಾಂತೆ ಇವ್ಣ ಉಪ್ಪರ್‌ಬಿ ಯೋ ರಾಜ಼್ ಚ಼ಲವ್‍಼ಕರ್ತುಥು. ಯೊ ಆದಾಮ್ ಅಗಾಡಿ ಆವಾಳೊಥೋತೆ ಏಕ್‍ಜ಼ಣಾನ ಖ್ಹಣೇದ್ ಹುಯಿರ‍್ಹೋಸ್. ");
INSERT INTO vaa_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","ಕತೋಬಿ ಬೇಜ಼ಣಾಮ ಫರಕ್ ಛಾ಼. ಶನಕತೊ ದೇವ್ನಿ ಫುಗಟ್ ಇನಾಮ್ ಆದಾಮ್‍ನಿ ಪಾಪ್‍ನಿಘೊಣಿ ಕಾಹೆ. ಆ ಏಕ್‍ಜ಼ಣಾನಿ ಪಾಪ್ನಖ್ಹಾಜೆ ಕೈಯೇಕ್‌ಜ಼ಣು ಮರ‍್ಯುತೆ ಖ್ಹಾಚಿಸ್, ಕತೋಬಿ ದೇವ್ನಿ ವಾರ್‌ಖ್ಹೇಥಿ ಮಳಾತೆ ವರ ಯೇಸುಕ್ರಿಸ್ತ ಕರಿ ಆ ಏಕ್‌ ಜ಼ಣಾನ ಗೋರ್‌ಥಿ ಕೈಏಕ್ ಜ಼ಣಾನ ಮಳಾನುಬಿ ಖ್ಹಾಚಿಸ್. ");
INSERT INTO vaa_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","ದೇವ್ನಿ ಇನಾಮ್ ಅಜು಼ ಏಕ್‍ ಅದ್ಮಿನ ಪಾಪ್‌ಮ ಪರಕ್ ಛಾ಼. ಏಕ್‍ಜ಼ಣಾನ ಪಾಪ್ನ ನ್ಯಾವ್‌ನು ತೀರ್ಪ್‌ಹುಯಿನ್ ನಿಶತ್ ಮಳ್ಯು. ಕತೋಬಿ ಕೈಯೇಕ್ ಜ಼ಣಾನ ಪಾಪ್ನಪೀಠೆ ಗಲ್ತಿವಾಳೊ ಕಾಹೆಕರಿ ಬೋಲಾನು ಊಚು಼ ಇನಾಮ್ ಆಯು. ");
INSERT INTO vaa_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","ಏಕ್‍ಅದ್ಮಿನೆ ಕರ‍್ಯುತೆ ಅಪರಾದ್‍ಥಿ ಮರಣ್ ರಾಜ಼್ ಚ಼ಲಾಯುಕರಿ ಬೋಲಾನು ಖ್ಹಾಚು಼ಹುಯು. ಕತೋಬಿ ಕಾಮ್ನು ಪ್ರತಿಫಲ್ ಕೆತ್ರೆ ಮಹಾನ್ ಹುಯಿರ‍್ಹುಸ್ ಯೋಸ್‍ಯೇಸು ಕ್ರಿಸ್ತಹುಯಿರ‍್ಹೊಸ್. ದೇವ್ನಿ ಚೆಹೆಳ್ ವಾರ್‌ಖ್ಹಾನಾಬಿ ನೀತಿನಿ ವರನಾಬಿ ಲೀಲ್ಯಾವಾಳ ಖ್ಹಾರಸ್ ಅಜು಼ ಫುಗಟ್‍ಥಿ ನೀತಿವಾಳಕರಿ ಬೋಲೈಲ್ಯವಾಳುಬಿ ಹುಯಿನ್ ಯೇಸುಕ್ರಿಸ್ತಕರಿ ಆ ಏಕ್‍ಜ಼ಣಾನಿ ಜೋ಼ಡ್ಮ ಜಾನ್‌ಭರೈನ್ ರಾಜ಼್‌ಭಾರ್‌ ಕರಾನು ಹುಯು. ");
INSERT INTO vaa_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","ಅಮ್‌ರ‍್ಹವಾಪರ್ ಆದಾಮ್‍ನಿ ಏಕ್‌ ಅಪರಾದ್‍ಥಿ ಖ್ಹಾರಾಸ್ ಅದ್ಮಿಪರ್ ಮರಣ್‌ಕರಿ ಅಪರಾದ್ನಿ ತೀರ್ಪ್ ಕಿಮ್‌ನಾಖ್ಯುಕಿ ಇಮ್ಮಸ್ ಕ್ರಿಸ್ತನಿ ಎಕ್ಕಸ್‌ನೀತಿನ ಕಾಮ್‍ಥಿ ಖ್ಹಾರಾಸ್ ಅದ್ಮಿನ ನೀತಿವಾಳುಕರಿ ಛುಟ್ಕಾರ್‌ಹುಯು ಅಜು಼ ಜಾನ್‌ ದೆವಾಯು. ");
INSERT INTO vaa_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","ಕಿಮ್ ಏಕ್‌ ಅದ್ಮಿನಿ ಅವಿಧೇಯತೆಥಿ ಕೈಯೇಕ್‌ಜ಼ಣು ಪಾಪಿಕರಿ ಗಣ್ತಿ ಹುಯುಕಿ ತಿಮ್ಮಸ್, ಏಕ್‌ ಅದ್ಮಿನಿ ವಿಧೇಯಾಥಿ ಕೈಯೇಕ್‌ಜ಼ಣು ನೀತಿವಾಳುಕರಿ ಗಣ್ತಿಉಶೆ. ");
INSERT INTO vaa_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","ಗಲತ್‌ ಅಖ್ಖು ಜಾ಼ಖ್ಹತ್ ಹೋತುಆಯು ಕಿಮ್ಕಿ ಧರ್ಮಶಾಸ್ತ್ರಬಿ ಇನಜೋ಼ಡೆಸ್‌ ಆಯು. ಕತೋಬಿ ಪಾಪ್ ಜಾ಼ಖ್ಹತ್ ಕಿಮ್‍ಹುಯುಕಿ, ವಾರ್‌ಖ್ಹೊಬಿ ಬಿಜೂ಼ಬಿ ಜಾ಼ಖ್ಹತ್ ಹುಯು. ");
INSERT INTO vaa_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","ಕಿಮ್ ಪಾಪ್ ಮರಣ್‍ಥಿ ರಾಜ಼್ ಚ಼ಲಾಯುಕಿ ಇಮ್ಮಸ್ ದೇವ್ನಿ ವಾರ್‌ಖ್ಹೊ ಅಪ್ಣೊ ಪ್ರಭು ಯೇಸುಕ್ರಿಸ್ತಥಿ ಹರ್‌ಹಮೇಶಾನಿ ಜಿ಼ಂದ್‌ಗಿ ದ್ಯವಾನ ನೀತಿಥಿ ರಾಜ಼್ ಚ಼ಲಾವಸ್. ");
INSERT INTO vaa_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","ಇಮ್‍ಕತೊ ಅಪ್ಣೆಶಾತ್ ಬೋಲ್‍ಯೇ? ದೇವ್ನೊ ವಾರ್‌ಖ್ಹೊ ಜಾ಼ಖ್ಹತ್ ಹುವಾದೆಕರಿ ಅಪ್ಣೆ ಪಾಪ್‍ಮಸ್ ಭಡ್‌ಯೆಕಿ ಶು? ");
INSERT INTO vaa_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","ಇಮ್‌ ಕದೇಬಿ ನಾ ಹೋಣು. ಅಪ್ಣೆ ಪಾಪ್ನ ಭಾಗ್ನ ಮರಿಗಯ, ಅಪ್ಣೆ ಬಿಜೂ಼ಬಿ ಪಾಪ್‌ಮ ಬಚಾ಼ನು ಕಿಮ್? ");
INSERT INTO vaa_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","ನತರ್ ಕ್ರಿಸ್ತಯೇಸುನಿ ಗಳ್‌ಜೋ಼ಡ್ಮ ಭಾಗ್‌ ಲೀರಾಖವಾಳ ಹುಯಿನ್ ಬ್ಯಾಪ್ತಿಸ್ಮ ಕರೈಲಿದಾತೆ ಅಪ್ಣೆ ಇನ ಮರಣ್‍ಮ ಬ್ಯಾಪ್ತಿಸ್ಮ ಕರೈರಾಖ್ಯಸ್‍ಕರಿ ತುಮೂನ ಮಾಲುಮ್ ಕೊಯ್ನಿಕಿ ಶು? ");
INSERT INTO vaa_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","ಇನಖ್ಹಾಜೆ ಅಪ್ಣಿ ಬ್ಯಾಪ್ತಿಸ್ಮಥಿ ಅಪ್ಣೆ ಇನಿಮರಣ್‍ಮ ಭಾಗ್‌ಲ್ಯವಾಳಹುಯಿರ‍್ಹೀನ್, ಇನಿ ಜೋ಼ಡ್ಮ ಗಡೈಗಯ.ಅಮ್‍ರ‍್ಹವಾಪರ್ ಬಾನಿ ಮಹಿಮೆನಿ ಶಕಥ್ಥಿ ಕ್ರಿಸ್ತ ಮರ‍ಣ್‍ಮಾಥು ಉಠಾಡೈಗಯೋತೆ ತಿಮ್ಮಸ್ ಅಪ್ಣೇಬಿ ಏಕ್‌ ನವ ಜಾನ್‌ಮ ಜಿವವಾಳ ಹುಯಿರ‍್ಹಾಸ್. ");
INSERT INTO vaa_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","ಅಜು಼ ಇನಿಮರಣ್‍ಮ ಭಾಗ್‌ಲ್ಯವಾಳಹುಯಿರ‍್ಹಾಸ್. ಇಮ್ನೀಸ್‍ಪರಕ್‍ಮ ಇನಿಜೋ಼ಡ್ಮ ಏಕ್‍ಹುಯಿನ್‍ ಯೋ ಪಾಛು಼ ಜಿವ್ತುಹುಯಿನ್ ಆಯೋತೆ ಇನಮಾಬಿ ಅಪ್ಣೆ ಭಾಗ್‌ಲ್ಯವಾಳ ಹುಯಿರಾಸ್. ");
INSERT INTO vaa_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","ಅಪ್ಣು ಜೂ಼ನು ಚಾ಼ಲ್‍ಚ಼ಲಣ್‍ ನಾಶ್ ಹುಯಿಜೈ಼ನ್‌ ಬಿಜು಼ ಅಗಾಡಿ ಅಪ್ಣೆ ಕದೇಬಿ ಪಾಪ್ನ ಗುಲಾಮ್ ನಾ ಹೋಣುಕರಿ ಅಪ್ಣು ಪಾಪ್‌ಥಿ ಮರಿಹುಯು ಶರೀರ್ ಇನಜೋ಼ಡ್ಮ ಶಿಲ್‌ಬೆಪರ್ ಮರೈಗಯುಕರಿ ಅಪ್ಣುನ ಮಾಲುಮ್ ಛಾ಼. ");
INSERT INTO vaa_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","ಶನಕತೊ ಕೋಣ್ ಮರಿರ‍್ಹುಸ್ಕಿ ಇವ್ಣೆ ಪಾಪ್‌ಥಿ ಛುಟ್ಕಾರ್‌ ಹುಯಿರೇಸ್. ");
INSERT INTO vaa_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","ಅಪ್ಣೆ ಹಮ್ಕೆ ಕ್ರಿಸ್ತನಿ ಜೋ಼ಡ್ಮ ಮರಿರ‍್ಹಾತೊ, ಇನಿ ಜೋ಼ಡ್ಮ ಜಿವ್‍ಶುಕರಿ ವಿಶ್ವಾಸ್ ಕರ್ಯೆಸ್. ");
INSERT INTO vaa_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","ಶನಖ್ಹಾಜೆಕತೊ ಕ್ರಿಸ್ತ ಮರಣ್‍ಥಿ ಉಠಾಡೈಗಯೋತೆ ಇನಖ್ಹಾಜೆ ಯೋ ಬಿಜೊ಼ಪಾಛೊ ಮರ್‌ಶೆಕೊಯ್ನಿಕರಿ ಮಾಲುಮ್ ಕರಿರಾಖ್ಯಸ್. ಅನಪಾರ್ ಇನ ಉಪ್ಪರ್ ಮರಣ್ಣ ಶನೂಬಿ ಹಕ್‍ಕೊಯ್ನಿ. ");
INSERT INTO vaa_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","ಯೋ ಪಾಪ್ನ ಭಾಗ್ನ ಮರ‍್ಯೋತೆ ಎಕ್ಕಸ್‍ಹಲ್ಲ. ಕತೋಬಿ ಯೋ ಮರ‍್ಯೋತೆ ಖ್ಹಾರಸ್ನ ಖ್ಹಾಜೆ. ಯೋ ದೇವ್ನಿ ಜೋ಼ಡ್ಮ ಏಕ್‍ ಹುಯಿನ್ ಜಿವ್‌ಕರಸ್. ");
INSERT INTO vaa_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","ಯೋಸ್‍ಪರಕ್ಮ ತುಮೂಬಿ ಪಾಪ್ನಭಾಗ್‍ನ ಮರ‍್ಯಹುಯಕರಿಬಿ ಕ್ರಿಸ್ತಯೇಸುಥಿ ದೇವ್ನಖ್ಹಾಜೆ ಬಚಾ಼ವಾಳುಕರಿ ಗಣ್ತಿಕರಿಲೆವೊ. ");
INSERT INTO vaa_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","ಇನಖ್ಹಾಜೆ ತುಮೆ ಶರೀರ್‌ನ ಖರಾಬ್ ಆಖ್ಹ್‌ಮ ನಾ ಪಡ್‍ನೂತೆ ತುಮಾರ ಮಟಿಜಾ಼ವಾಳ ಶರೀರ‍್ಮ ಪಾಪ್ ಹುಕುಮ್‌ ಚ಼ಲಾವನ ನಕೊಮ್ಹೇಲಿದೆವೊ. ");
INSERT INTO vaa_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","ತುಮಾರ ಶರೀರ್‌ನು ಭಾಗ್ನ ನೀಚ್ ಕಾಮ್ನ ಚ಼ಲಾವವಾಳು ಕಫ್ಫನ್ನಿತರ ಪಾಪ್ನ ದಿನಾಖೊನಕೊ, ಕತೋಬಿ ಇನ ಬದಲ್ ಮರಣ್‌ಥು ಜಿವ್ತುಹುಯಿನ್ ತುಮೂನ ದೇವ್ನ ಸಮರ್ಪಣ್‌ ಕರಿನಾಖೊ. ತುಮಾರ ಶರೀರ್‌ನ ಭಾಗ್ನ ನೀತಿನು ಕಫ್ಫನ್ ಹುಯಿರ‍್ಹವಾನಖ್ಹಾಜೆ ದೇವ್ನ ಸಮರ್ಪಣ್‌ ಕರೊ. ");
INSERT INTO vaa_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","ಪಾಪ್ ತುಮಾರಪರ್ ಯಜಮಾನ್ ನಾ ಹುಯಿರ‍್ಹೇಣು, ಶನಕತೊ ತುಮೆ ಧರ್ಮಶಾಸ್ತ್ರನಿ ಅಧೀನ್‍ಮ ಕೊಯ್ನಿ, ದೇವ್ನಿ ವಾರ್‌ಖ್ಹಾನಿ ಅಧೀನ್‍ಮ ಹುಯಿರ‍್ಹಾಸ್. ");
INSERT INTO vaa_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","ಇಮ್‍ಕತೊ ಶಾತ್? ಅಪ್ಣೆ ಧರ್ಮಶಾಸ್ತ್ರನಿ ಅಧೀನ್‍ ನಾ ರ‍್ಹೇವ್ಣುತೆ ವಾರ್‌ಖ್ಹಾನಿ ಅಧೀನ್ ಹುಯಿರ‍್ಹಿಯೇಸ್‍ಕರಿ ಪಾಪ್ ಕರೇಜಾ಼ಯ್ಕಿ ಶು? ಕೊಯ್ನಿಕತೊ, ");
INSERT INTO vaa_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","ತುಮೆ ತುಮುನಾಸ್ ಗುಲಾಮ್‌ಹುಯಿನ್ ಕಿನಾತೋಬಿ ದೆವೈಜಾ಼ವಾನಿ ವಖ್ಹತ್‌ಮ ತುಮೆ ಯಜಮಾನ್ನ ವಿಧೇಯ ಹುಯಿರ‍್ಹವಾಳ ಸೇವಕ್ ಹುಯಿರ‍್ಹೆಸ್‍ಕರಿ ತುಮೂನ ಮಾಲುಮ್‌ ಛಾ಼. ಪಾಪ್‌ಮ ಪಡ್ಯುತೊ ಮರಣಸ್ ಫಲ್,ದೇವ್ನ ಭರೋಖ್ಹಾನ ದಾಸಹುಯಾತೊ ನೀತಿ ಮಳ್‍ಶೆ. ");
INSERT INTO vaa_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","ಕತೋಬಿ ದೇವ್ನ ಧನ್ಯವಾದ್‌ಹುವಾದೆ! ಶನಕತೊ ತುಮೆ ಏಕ್‌ ವಖ್ಹತ್‌ಮ ಪಾಪ್ನ ಗುಲಾಮ್ ಹುಯಿರ‍್ಹತೋಬಿ, ತುಮೆ ಶಿಕಿಲಿದಾತೆ ಖ್ಹಾಚಿ ಬೋಧನೆಮ ಭರ್‌ಪೂರ್‌ ಮನ್‌ಥಿ ವಿಧೇಯ ಹುಯಿರ‍್ಹಾಸ್. ");
INSERT INTO vaa_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","ತುಮೆ ಪಾಪ್‌ಥಿ ಛುಟ್ಕಾರ್ ಲ್ಯವಾಳಹುಯಿನ್ ನೀತಿನ ಗುಲಾಮ್‌ ಹುಯಿರ‍್ಹಾಸ್. ");
INSERT INTO vaa_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","ತುಮೆ ಶರೀರ‍್ನಿ ಖ್ಹಯಾಲ್ಮ ಕಮ್‍ಜೋ಼ರ್ ಹುಯಿರಾತೆ ಇನಖ್ಹಾಜೆ ಮೇ ದನ್‌ಪರೋಜ಼್‌ನಿ ವಾತ್ನಿತರಸ್‍ ಬೋಲುಕರುಸ್. ತುಮಾರ ಶರೀರ್‌ನು ತನ್‍ಬದನ್ನ ಮೈಲಾನಾಬಿ, ಖರಾಬ್‌ನಾಬಿ ಗುಲಾಮ್‍ಕರೀನ್ ದಿನಾಖಿದಿದಾಥಾಕಿ. ಇಮ್ನಿಸ್ ಪರಕ್ಮ ಹಮ್ಕೆ ತುಮೆ ತುಮಾರ ಶರೀರ್‌ನು ತನ್‍ಬದನ್ನ ಪರಿಶುದ್‌ರ‍್ಹವಾನಿ ನೀತಿನ ಗುಲಾಮ್‌ ಬಣೈನ್ ದಿನಾಖಿದೆವೊ. ");
INSERT INTO vaa_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","ತುಮೆ ಪಾಪ್ನ ಗುಲಾಮ್ ಹುಯಿರ‍್ಹಾಥಾತೆ ತದೆ ನೀತಿನ ಅಧೀನ್‍ಮ ಕೋಥಾನಿ. ");
INSERT INTO vaa_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","ತುಮೆ ಖರಾಬ್ ಕಾಮ್‍ಕರ‍್ಯ, ಹಮ್ಕೆ ತುಮೆ ಯೋ ಕಾಮ್ನಿಬಾರೇಮ ಖ್ಹರ್‌ಮಾವಸ್ನಿ? ಯೋ ಕಾಮ್‍ಥಿ ತುಮೂನ ಮರಣಸ್ ಹುಯಿರ‍್ಹುಸ್. ");
INSERT INTO vaa_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","ಕತೋಬಿ ಹಮ್ಕೆ ತುಮೆ ಪಾಪ್‌ಥಿ ಛುಟ್ಕಾರ್ ಲ್ಯವಾಳಹುಯಿನ್, ದೇವ್ನ ಗುಲಾಮ್‌ ಹುಯಿರಾಸ್. ತುಮೂನ ಮಳಾನು ಫಾಯಿದೊ ಪರಿಶುದ್ ಭಣಿ ಲೀಜಾ಼ಸ್ ಇನು ಫಲ್ ಹಮೇಶಾನಿ ಜಿ಼ಂದ್‌ಗಿ ಹುಯಿರ‍್ಹುಸ್. ");
INSERT INTO vaa_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","ಶನಕತೊ ಪಾಪ್ ದೇಯಿತೆ ಮಜ಼್‌ದೂರಿ ಮರಣ್ ಹುಯಿರುಸ್. ಕತೋಬಿ ದೇವ್ನು ಫುಗಟ್ ಇನಾಮ್ ಅಪ್ಣೊ ಪ್ರಭು ಕ್ರಿಸ್ತಯೇಸುನ ಗಳ್‌ಜೋ಼ಡ್ಮ ಅಪ್ಣುನ ದಿಶೇತೆ ಹಮೇಶಾನಿ ಜಿ಼ಂದ್‌ಗೀಸ್. ");
INSERT INTO vaa_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","ಭೈಯೇ ಭೇನೇವೊ, ಧರ್ಮಶಾಸ್ತ್ರನ ಮಾಲುಮ್ ಕರಿರಾಖವಾಳನ ಮೇ ಶಾತ್ ಬೋಲಸ್‍ಕತೊ, ಏಕ್‍ಅದ್ಮಿ ಬಚಿರ‍್ಹಾವಲಗು ಖಲಿ ಧರ್ಮಶಾಸ್ತ್ರ ಇನ ಉಪ್ಪರ್ ಅದಿಕಾರ್ ಕರಸ್‍ಕರಿ ತುಮೂನ ಮಾಲುಮ್ ಛಾ಼. ");
INSERT INTO vaa_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","ಉದಾಹರಣೆ ಏಕ್‌ ವ್ಹೆತ್ತಿ ತಯೇಡ ಇನೊ ಬಾವ್ರಿ ಜಿವ್ತೊರ‍್ಹವಾನಿ ವಖ್ಹ್‌ತೆ ಧರ್ಮಶಾಸ್ತ್ರನಿ ಪರಕ್ಮ ಇನ ಜೋ಼ಡ್ಮ ಬಂಧಣ್‍ಮರ‍್ಹೇಸ್. ಕತೋಬಿ ಬಾವ್ರಿ ಮರಿಗೋತೊ ಇನ ಜೋ಼ಡೆ ಭಂದೈರ‍್ಹೀತೆ ಧರ್ಮಶಾಸ್ತ್ರನಿ ಬಂಧಣ್‍ಥಿ ಛುಟ್ಕಾರ್ ಲೀರಾಖವಾಳಿ ಹುಯಿರ‍್ಹೇಸ್. ");
INSERT INTO vaa_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","ಅಮ್‍ರ‍್ಹವಾಪರ್, ಇನೊ ಬಾವ್ರಿ ಜಿವ್ತೊರ‍್ಹವಾನಿ ವಖ್ಹತ್‌ಮ ಯೋ ತಯೇಡ ಬಿಜೇಕ್ ಜ಼ಣಾನಿ ಜೋ಼ಡ್ಮ ಸಂಬಂದ್ ರ‍್ಹಯೂತೊ ವ್ಯಬಿಚಾರಿಣಿಕರಿ ಬೋಲೈಜಾ಼ಸ್. ಕತೋಬಿ ಬಾವ್ರಿ ಮರಿಗಯುತೊ ಯೋ ತಯೇಡ ಯೊ ನಿಯಮ್‌ಥಿ ಛುಟ್ಕಾರ್ ಹುಯಿತೆ ಇನಖ್ಹಾಜೆ, ಯೋ ಬಿಜೇಕ್ ಜ಼ಣಾನಿ ಜೋ಼ಡೆ ವ್ಯಹಾಕರಿ ಲಿದಿತೋಬಿ ವ್ಯಬಿಚಾರಿಣಿಕರಿ ಗಣ್ತಿ ಹುವಾಕೊಯ್ನಿ. ");
INSERT INTO vaa_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","ಇನಖ್ಹಾಜೆ ಮಾರ ಭೈಯೇ ಭೇನೇವೊ,ಧರ್ಮಶಾಸ್ತ್ರನಿ ಬಾರೇಮ ಬೋಲ್ನುಕತೊ ತುಮೇಬಿ ಕ್ರಿಸ್ತಾನು ಶರೀರ್‌ಮ ಭಾಗ್‌ ಹುಯಿರ‍್ಹಾಸ್ತೆಖ್ಹಾಜೆ ತುಮೇಬಿ ಮರಿರ‍್ಹಾಸ್ ಅಜು಼ ಹಮ್ಕೆ ಮರ‍್ಯಹುಯಮಾಥು ಜಿವ್ತೊಹುಯಿನ್ ಉಠ್ಯೊತೆ ಇನ ಮಳ್ಯಹುಯ ಹುಯಿರಾಸ್. ಅಮ್ ಅಪ್ಣೆ ದೇವ್ನಿ ಸೇವೆಮ ಫಾಯಿದೊ ಹುಯೆಜಾ಼ಯ್‌. ");
INSERT INTO vaa_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","ಅಪ್ಣೆ ಅದ್ಮಿನಿ ಖೂಜ಼್‌ಮ ಜಿವ್‍ಕರ್ತಥಾತೆ ತದೆ, ಪಾಪ್‌ಥಿ ಭರೈಹುಯು ಖರಾಬ್ ಆಖ್ಹ್‌ಖ್ಹಾರು ಅಪ್ಣ ಶರೀರ್‌ಮ ಕಾಮ್ ಕರುಕರ್ತುಥು. ಯೊ ಧರ್ಮಶಾಸ್ತ್ರನ ಖ್ಹೂಜ಼್‌ಥೀಸ್ ಹೋತುಥು. ಇನಖ್ಹಾಜೆ ಅಪ್ಣೆ ಕರಾನು ಫಲ್ ಮರಣ್ ಹುಯಿರ‍್ಹುಸ್. ");
INSERT INTO vaa_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","ಹಮ್ಕೆತೋಬಿ ಅಪ್ಣುನ ಬಂಧೈರುಥುತೆ ಧರ್ಮಶಾಸ್ತ್ರನ ಭಾಗ್‌ಮ ಮರ‍್ಯಹುಯ ಹುಯಿನ್, ಯೊ ಧರ್ಮಶಾಸ್ತ್ರಥಿ ಛುಟ್ಕಾರ್ ಲೀರಾಖ್ಯಸ್. ಅಮ್ ಲೀಖೈರ‍್ಹೂತೆ ಫಾಚ಼್‌ಲಿ ನಿಯಮ್‌ನಿ ಪರಕ್ಮ ಅಪ್ಣೆ ದೇವ್ನ ಸೇವೆ ಕರ‍್ಯಕೊಂತೆ, ಪವಿತ್ರಾತ್ಮಥಿ ನವಿ ಪರಕ್ಮ ಚಾ಼ಲವಾಳ ಹುಯಿರ‍್ಹಾಸ್. ");
INSERT INTO vaa_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","ಇಮ್‍ಕತೊ ಅಪ್ಣೆಶಾತ್ ಬೋಲಿಯೆ ಪಾಪ್ ಧರ್ಮಶಾಸ್ತ್ರಸ್ ಹುಯಿರ‍್ಹೂಸ್ಕಿಶು? ಕದೇಬಿ ಕೊಯ್ನಿ. ಕತೋಬಿ ಧರ್ಮಶಾಸ್ತ್ರನ ಮ್ಹೇಲಿನ್ ಬಿಜ಼ ಖೆವೆಥೀಬಿ ಪಾಪ್‍ಕತೊ ಶಾತ್‌ಕರಿ ಮನ ಖ್ಹಮ್‍ಜಿಲ್ಯವಾನ ಹುಯುಹೋತ್ ಕೊಯ್ನಿ. “ಬಿಜೇಕ್ ಜ಼ಣಾನ ರಾಛ಼ನ ತುಮೆ ಆಖ್ಹ್‌ನಾಕರ‍್ನು.” ಕರಿ ಧರ್ಮಶಾಸ್ತ್ರ ಬೋಲ್ಯುತೆ ಇನಖ್ಹಾಜೇಸ್ ಯೋ ಮನ ಮಾಲುಮ್‌ಪಡ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","ಕತೋಬಿ ಪಾಪ್ ಆ ಹುಕುಮ್‍ನಾಸ್‍ ಪಾಡಿಲೀನ್ ಮಾರಾಮ ಖ್ಹಾರಿಸ್ ಥರಾನು ಆಖ್ಹ್‌ನ ಲಾಯು. ಶನಕತೊ ಧರ್ಮಶಾಸ್ತ್ರ ಕೊಂತೆ ಪಾಪ್ ಮರ‍್ಯುಹುಯು ಹುಯಿರ‍್ಹೇಸ್. ");
INSERT INTO vaa_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","9","ಏಕ್‍ ವಖ್ಹತ್ ಮೇ ಧರ್ಮಶಾಸ್ತ್ರ ಕೊಂತೆ ಜಿವ್‌ಕರ್ತೊಥೊ. ಕತೋಬಿ ಕೆದೆ ನಿಯಮ್‌ ಕರಿ ಬೋಲಾನು ಆಯುಕಿತದೆ ಪಾಪ್ ಜೂತುಹುಯು. ");
INSERT INTO vaa_vpl VALUES ("RM7_10","075_7_10","ROM","7","10","10","ಅಜು಼ ಮೇ ಮರಿಗಯೊ. ಜಾನ್‌ಲೀನ್ ಆವಾನ ದೆವೈಗೈತೆ ಹುಕುಮಸ್ ಮಾರಿ ಬಾರೇಮ ಮರಣ್ಣ ಲೀನ್ ಆಯು. ");
INSERT INTO vaa_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","ಪಾಪ್ನ ಅವಕಾಶ್ ಮಳ್ಯು ಅಜು಼ ಯೊ ಹುಕುಮ್‌ನ ಪಾಡಿಲೀನ್ ಮನ ಠಗೈನ್, ಅಜು಼ ಮನ ಮರ್‌ನಾಖ್ಯು. ");
INSERT INTO vaa_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","ಅಮ್‍ರ‍್ಹವಾಪರ್, ಧರ್ಮಶಾಸ್ತ್ರ ಪರಿಶುದ್ ಹುಯಿರ‍್ಹೂಸ್, ಹುಕುಮ್‌ಬಿ, ಪರಿಶುದ್‌ಬಿ, ನ್ಯಾವ್‍ಬಿ, ಅಛ಼್ಛುಬಿ ಹುಯಿರ‍್ಹೂಸ್. ");
INSERT INTO vaa_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","ಇಮ್‍ಕತೊ ಅಛ಼್ಛುಸ್ ಮನ ಮರಣ್‌ಲಾಯುಕಿಶು? ಇಮ್ ನಾರ‍್ಹಯುತೊ! ಪಾಪಸ್ ಯೊ ಕರ‍್ಯು ಅಛ಼್ಛಥೀಸ್ ಮನ ಉಪಯೋಗ್ ಕರೀನ್ ಪಾಪ್ನೆ ಮರಣ್ ಆವಾನಿತರ ಕರ‍್ಯು. ಅನೇಥಿ ಪಾಪ್ ಇನು ಖ್ಹಾಚು಼ ಸ್ವಭಾವ್‌ನ ವತಾಳ್ಯು ಇನಖ್ಹಾಜೆ ಹುಕುಮ್‌ಥಿ ಪಾಪ್ ಯೋ ಕೆತ್ರೆ ಕಠೋರ್‌ಕರಿ ಮಾಲುಮ್‌ ಪಡಾಸ್‌. ");
INSERT INTO vaa_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","ಧರ್ಮಶಾಸ್ತ್ರ ಆತ್ಮೀಕ್ ಹುಯಿರ‍್ಹುಸ್‌ಕರಿ ಮಾಲುಮ್ ಛಾ಼. ಕತೋಬಿ ಅದಮ್‍ಜ಼ಮಾನೊ ಹುಯಿರೋತೆ ಮೇ ಪಾಪ್ನ ಗುಲಾಮ್ನಿತರ ವೇಚೈ಼ಜಾ಼ವಾಳೊ ಹುಯಿರ‍್ಹೋಸ್. ");
INSERT INTO vaa_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","ಮೇ ಶಾತ್‍ಕರೂಸ್‍ ಕರಿ ಬೋಲಾನು ಮಾಲುಮ್‌ಕೊಂತೆ ಹುಯಿರ‍್ಹೋಸ್. ಶನಕತೊ ಮೇ ಶಾತ್ ಕರ್ನುಕರಿ ಆಖ್ಹ್‌ಕರೂಸ್ಕಿ ಇನ ಕರುಕೊಯ್ನಿ, ಕೆವ್ಹಾನ ವಹೇರ್‌ಕರುಸ್ಕಿ ಇನಾಸ್ ಕರಾವಾಳೊ ಹುಯಿರ‍್ಹೋಸ್. ");
INSERT INTO vaa_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","ಮೇ ಕರಾನ ಆಖ್ಹ್ ಕರುಕೊಂತೆ ತಿನ ಕರಾವಾಳೊರ‍್ಹಯೋತೊ, ಧರ್ಮಶಾಸ್ತ್ರ ಅಛ್ಛು಼ಕರಿ ವತಾಳಸ್‍. ");
INSERT INTO vaa_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","ಅಮ್‍ರ‍್ಹವಾಪರ್ ಮೇ ಆಖ್ಹ್ ಕರುಕೊಂತೆ ತಿನ ಕರಾವಾಳೊ ಬಿಜು಼ ಮೇಕಾಹೆ, ಮಾರಾಮ ರ‍್ಹೇಸ್ತೆ ಪಾಪಸ್ ಇನ ಕರಸ್. ");
INSERT INTO vaa_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","18","ಮಾರಾಮ, ಕತೊ ಶರೀರ್‌ನ ಅಧೀನ್ ಸ್ವಭಾವ್‍ಥಿ ಅಛ್ಛು಼ಶಾತ್‍ಬಿ ಜಿವ್‍ಕರಾಕೊಯ್ನಿ ಕರಿ ಮಾಲುಮ್‌ಛಾ಼. ಶನಕತೊ ಅಛ಼್ಛು ಕರ್ನುಕರಿ ಬೋಲಾನು ದಿಲ್‍ ಮಾರಾಮ ರ‍್ಹಯುತೋಬಿ ಇನ ಕರಾನ ಮನ ಕೊಹೋಯ್ನಿ. ");
INSERT INTO vaa_vpl VALUES ("RM7_19","075_7_19","ROM","7","19","19","ಶನಕತೊ ಮೇ ಅಛ್ಛು಼ ಕರ್ನುಕರಿ ಆಖ್ಹ್ ಕರುಸ್ತೆ ಇನ ಯೊ ಅಛ್ಛಾ಼ನ ಕರುಕೊಂತೆ ಖರಾಬ್‌ನ ಕರನಾಸ್ ಆಖ್ಹ್ ಕರುಕರೂಸ್. ");
INSERT INTO vaa_vpl VALUES ("RM7_20","075_7_20","ROM","7","20","20","ನಾ ಕರ್ನುಕರಿ ಬೋಲಾತೆ ಕಾಮ್ನ ಮೇ ಕರುಕರುಸ್‍ಕತೊ ಇನ ಕರ‍್ಯೊತೆ ಮೇ ಕಾಹೆ ಮಾರಮ ಜಿವ್‌ಕರಾತೆ ಪಾಪಸ್ ಇನ ಕರುಕರಸ್. ");
INSERT INTO vaa_vpl VALUES ("RM7_21","075_7_21","ROM","7","21","21","ಇನಖ್ಹಾಜೆ ಖಿವು ಅಛ್ಛುಛಾ಼ಕಿ ಇನ ಮೇ ಕರ್ನುಕರಿ ಛೂ಼ ಕತೋಬಿ ಖರಾಬಸ್ ಮಾರಾಮ ಠಿಕಾಣಿ ಹುಯಿರ‍್ಹುಸ್‌ಕರಿ ನಿಯಮ್‌ಥಿ ಮಾಲುಮ್‌ಹುವಸ್. ");
INSERT INTO vaa_vpl VALUES ("RM7_22","075_7_22","ROM","7","22","22","ಶನಕತೊ ಮೇ ಪೂರದಿಲ್‍ಥಿ ದೇವ್ನು ಧರ್ಮಶಾಸ್ತ್ರಮ ಖುಷಿಕರವಾಳೊ ಹುಯಿರ‍್ಹೋಸ್. ");
INSERT INTO vaa_vpl VALUES ("RM7_23","075_7_23","ROM","7","23","23","ಕತೋಬಿ ಮಾರದಿಲ್ಮ ಬಿಜೇಕ್ ನಿಯಮ್ ಮೇ ದೇಖುಕರುಸ್ ಮಾರ ಶರೀರ್‌ಮ ಛಾ಼ತೆ ಪಾಪ್ನ ನಿಯಮ್ಮ ಕೊಂಡೈರ‍್ಹೋಸ್. ");
INSERT INTO vaa_vpl VALUES ("RM7_24","075_7_24","ROM","7","24","24","ಮೇ ಕೆಥ್ರಾನು ಖರಾಬ್ ಹಾಲತ್ನು ಅದ್ಮಿ! ಮನ ಆ ಮರಣ್ಣು ಶರೀರ್‌ಥಿ ಕೋಣ್ ಛೋ಼ಡಾವವಾಳು? ");
INSERT INTO vaa_vpl VALUES ("RM7_25","075_7_25","ROM","7","25","25","ಅಪ್ಣೊ ಪ್ರಭು ಯೇಸುಕ್ರಿಸ್ತಥಿ ಮನ ಬಚಾ಼ಡವಾಳ ದೇವ್ನ ಧನ್ಯವಾದ್ ಕರುಸ್. ಅಮ್‌ರ‍್ಹವಾಪರ್ ಮೇ ದೇವ್ನಿ ನಿಯಮ್ನ ಅಕ್ಕಲ್‌ಥಿ ಸೇವೆ ಕರಾವಾಳೊ ಹುಯಿರ‍್ಹೋಸ್, ಕತೋಬಿ ಶರೀರ್‌ನ ಪಾಪ್ನ ನಿಯಮ್‌ಥಿ ಆಳ್‌ ಹುಯಿನ್‌ಬಿ ಚಾ಼ಲುಕರುಸ್. ");
INSERT INTO vaa_vpl VALUES ("RM8_1","075_8_1","ROM","8","1","1","ಇನಖ್ಹಾಜೆ ಹಮ್ಕೆ ಯೇಸುಕ್ರಿಸ್ತಮ ಗಳ್‍ಜೋ಼ಡ್ ರ‍್ಹವವಾಳಾನ ಖಿವಿ ಅಪರಾದ್ನಿ ತೀರ್ಮಾನ್‍ಬಿ ಕೊಯ್ನಿ. ");
INSERT INTO vaa_vpl VALUES ("RM8_2","075_8_2","ROM","8","2","2","ಶನಕತೊ ಕ್ರಿಸ್ತಯೇಸುಮ ಛಿಯ್ಯೇ಼ತೆ ಅಪ್ಣುನ ಜಾನ್ನ ಲ್ಯಾವವಾಳು ಪವಿತ್ರಾತ್ಮನು ನಿಯಮ್ ಮನ ಪಾಪ್ ನಿಯಮ್‌ಥಿಬಿ ಅಜು಼ ಮರಣ್‌ಥಿ ಛುಟ್ಕಾರ್ ಕರಿರಾಖ್ಯುಸ್. ");
INSERT INTO vaa_vpl VALUES ("RM8_3","075_8_3","ROM","8","3","3","ಶನಕತೊ ಧರ್ಮಶಾಸ್ತ್ರ ಅದ್ಮಿನು ಸ್ವಭಾವ್‍ಥಿ ಕಮ್‍ಜೋ಼ರ್ ಹುಯಿನ್ ಖಿವು ಕಾಮ್ ಕರ್ನುನಾಕರಿ ಥೂಕಿ, ಇನ ದೇವ್ನೆಸ್ ಕರ‍್ಯೊ. ಕಿಮ್‌ಕತೊ ಇನೆ ಪಾಪ್ನ ಕಾಡಾನಖ್ಹಾಜೆ ಇನ ಛಿಯ್ಯಾನಸ್ ಪಾಪ್ನ ಕಬ್‌ಜಾ಼ಮಥೂತೆ ಶರೀರ್‌ನ ರೂಪ್‌ಮ ಮೋಕ್ಲಿನ್ ಯೋ ಶರೀರ್‌ಮಾಸ್ ಪಾಪ್ನ ಮಾರಿನಾಖಿದಿದೊ. ಅಮ್‍ರ‍್ಹವಾಪರ್, ಧರ್ಮಶಾಸ್ತ್ರ ಕರಾಕೊಂತೆ ತಿನ ದೇವ್ನೆ ಕರ‍್ಯೊ. ದೇವ್ ಇನ ಶೊಂತ್ ಛಿಯ್ಯಾನಸ್ ಪಾಪ್‌ಮಾನಿ ಅದ್ಮಿನಿ ಖ್ಹಯಾಲ್ಮ ಪಾಪ್ನ ಕಾಡಿನಾಖಾನ ಮೋಕ್‌ಲ್ಯೊ. ಇನಖ್ಹಾಜೆ ದೇವ್ ಪಾಪ್ನ ಮರಣ್ಣಿ ನಿಶತ್‌ ದ್ಯವಾನ ಅದ್ಮಿನಿ ಖ್ಹಯಾಲ್ನಾಸ್ ಲೀಲಿದೊ. ");
INSERT INTO vaa_vpl VALUES ("RM8_4","075_8_4","ROM","8","4","4","ಅಪ್ಣೆ ಅದ್ಮಿನಿ ಸ್ವಭಾವ್‌ವಾಳ ಹುಯಿನ್ ನಾ ಚಾ಼ಲ್ನುತೆ ಪವಿತ್ರಾತ್ಮನಿ ಪರಕ್ಮ ಚಾ಼ಲವಾಳ ಹುಯಿನ್ ಧರ್ಮಶಾಸ್ತ್ರನಿ ನಿಯಮ್‌ನಿ ಘೋಣಿ ಚಾ಼ಲನುಸ್ ಆ ವಾತೆನ ಭರ್‌ಪೂರ್‌ ಹುವಾನಿತರ ಕರ‍್ಯು. ");
INSERT INTO vaa_vpl VALUES ("RM8_5","075_8_5","ROM","8","5","5","ಶರೀರ್‌ನಿ ಖ್ಹಯಾಲ್‍ವಾಳ ಹುಯಿನ್ ಚಾ಼ಲವಾಳು ಶರೀರ್‌ನ ಸಂಬಂದ್ ರ‍್ಹೆಯಿತೆ ವಾತೆವ್ಮ ಮಘನ್‌ ರ‍್ಹೇಸ್. ಕತೋಬಿ ಪವಿತ್ರಾತ್ಮನ ಪೀಛೆ ಚಾ಼ಲಿಲ್ಯಾವಾಳನು ದಿಲ್‌ ಪವಿತ್ರಾತ್ಮನ ಸಂಬಂಧ ಹುವಾತೆ ತಿನಪರ್‌ ರ‍್ಹೇಸ್. ");
INSERT INTO vaa_vpl VALUES ("RM8_6","075_8_6","ROM","8","6","6","ಶರೀರ್‌ನು ಸ್ವಭಾವ್‌ನುದಿಲ್ ಮರಣ್ಣು ಹುಯಿರ‍್ಹುಸ್. ಕತೋಬಿ ಪವಿತ್ರಾತ್ಮನ ಮಹಿರ‍್ಹಿಯೋತೊ ಇನಪರ್ ದಿಲ್‍ರಾಖನು ಜಾನ್‌ಬಿ ಸಮಾಧಾನ್‍ಬಿ ಹುಯಿರ‍್ಹೇಸ್. ");
INSERT INTO vaa_vpl VALUES ("RM8_7","075_8_7","ROM","8","7","7","ಶರೀರ್‌ನಿ ಸ್ವಭಾವ್‌ಪರ್‌ ದಿಲ್‌ರಾಖನು ದೇವ್ನ ವಿರೋದ್‌ ಹುಯಿರ‍್ಹೇಸ್. ‍ಶನಕತೊ ಯೊ ದೇವ್ನಿ ನಿಯಮ್ನ ವಿಧೇಯ ಹುವಾಕೊಯ್ನಿ. ಅಜು಼ ಯೊ ಶಾತ್ಬಿ ಕರಾನ ಕೊಹೊಯ್ನಿ. ");
INSERT INTO vaa_vpl VALUES ("RM8_8","075_8_8","ROM","8","8","8","ಶರೀರ್‌ನ ಖ್ಹಯಾಲ್ನಿ ಸ್ವಭಾವ್‌ಮರ‍್ಹವಾಳು ದೇವ್ನ ಲ್ಹಾಯಕ್ ಕರಾವನಕೊಹೊಯ್ನಿ. ");
INSERT INTO vaa_vpl VALUES ("RM8_9","075_8_9","ROM","8","9","9","ಕತೋಬಿ ದೇವ್ನು ಆತ್ಮ ತುಮಾರಮ ರ‍್ಹವಾನು ಖ್ಹಾಚಸ್ ಉಶೇತೊ ತುಮೆ ಶರೀರ್‌ನ ಖ್ಹಯಾಲ್ನ ಮಹಿ ರ‍್ಹವಾಳಕಾಹೆ, ದೇವ್ನ ಆತ್ಮಾನ ಮಹಿರ‍್ಹೇಸ್. ಕ್ರಿಸ್ತನು ಆತ್ಮ ಕೋರ‍್ಹೆಯಿನಿತೆ ಯೊ ಕ್ರಿಸ್ತಮ ಮಳ್ಯೊಹುಯೊ ಕಾಹೆ. ");
INSERT INTO vaa_vpl VALUES ("RM8_10","075_8_10","ROM","8","10","10","ಕತೋಬಿ ಕ್ರಿಸ್ತ ತಾರಮ ರ‍್ಹವಾಳೊ ಉಶೇತೊ, ಆತ್ಮ ತುಮುನ ಜಾನ್‌ ಹುಯಿರ‍್ಹೊಸ್. ತುಮಾರು ಶರೀರ್ ಪಾಪ್ನಖ್ಹಾಜೆ ಮರಿರ‍್ಹುತೋಬಿ ತುಮೆ ದೇವ್ನಿ ಜೋ಼ಡ್ಮ ನೀತಿವಾಳಕರಿ ಜಿವ್‌ಶು. ");
INSERT INTO vaa_vpl VALUES ("RM8_11","075_8_11","ROM","8","11","11","ಯೇಸುನ ಮರ‍್ಯಹುಯಮಾಥು ಜಿವಾಡವಾಳನು ಆತ್ಮ ತುಮಾರಮ ಜಿವ್‍ಕರ‍್ಯುತೊ, ಕ್ರಿಸ್ತಯೇಸುನ ಮರಣ್‍ಥಿ ಉಠಾಡ್ಯೊಹುಯೊ ದೇವ್ನು ಆತ್ಮ ತುಮಾರಮ ರ‍್ಹಿಯುತೊ ನಾಶಹುವಾಳು ಶರೀರ್‌ನಾಬಿ ತುಮಾರಮ ಜಿವವಾಳ ಆತ್ಮಥೀಸ್ ಜಾನ್ನ ದಿಶೆ. ");
INSERT INTO vaa_vpl VALUES ("RM8_12","075_8_12","ROM","8","12","12","ಇನಖ್ಹಾಜೆ ಭೇನೆ ಭೈಯೇವೊ ಅಪ್ಣೆ ಶರೀರ್‌ನ ಸ್ವಭಾವ್‌ನ ಚ಼ಪ್ಪಣ್‌ಮ ಕೊಯ್ನಿ. ಇನು ಆಖ್ಹ್‌ದಾಖ್ಹ್‌ಮ ಜಿವ್ಣುಕರಾನು ಚ಼ಪ್ಪಣ್‌ಮಬಿ ಕೊಯ್ನಿ. ");
INSERT INTO vaa_vpl VALUES ("RM8_13","075_8_13","ROM","8","13","13","ಶನಕತೊ ತುಮೆ ಶರೀರ್‌ನ ಆಖ್ಹ್‌ನ ಖ್ಹಯಾಲ್‍ವಾಳಹುಯಿನ್ ಜಿವ್ಯಾತೊ ಮರ್‌ಶು. ಕತೋಬಿ ಆತ್ಮಥಿ ಶರೀರ್‌ನ ಪಾಪ್ನಕಾಮ್ನ ಮಾರ‍್ಯುತೊ, ತುಮೆ ಜಿವ್‌ಶು. ");
INSERT INTO vaa_vpl VALUES ("RM8_14","075_8_14","ROM","8","14","14","ಕೋಣ್ ದೇವ್ನ ಆತ್ಮಥಿ ಚ಼ಲೈಲೇಸ್ಕಿ ಇವ್ಣೆ ದೇವ್ನ ಲಡ್ಕಾ ಹುಯಿರ‍್ಹಿಶೆ. ");
INSERT INTO vaa_vpl VALUES ("RM8_15","075_8_15","ROM","8","15","15","ಶನಕತೊ ದೇವ್ನೆ ದೀರಾಖ್ಯೋತೆ ಆತ್ಮ ತುಮೂನ ಗುಲಾಮ್ ಕೊ ಕರ್‌ಶೇನಿ ಅಜು಼ ತುಮಾರ ಡರ್‌ಥಿ ಕೊಹುಯಿರಿಶೇನಿ ಅನಬದಲ್ ಪವಿತ್ರಾತ್ಮ ದೇವ್ನ ಲಡ್ಕಕರೀನ್ ಬಣಾವಸ್ ಅಜು಼ ಯೊ ಆತ್ಮಾನಿ ಶಕಥ್ಥಿ ಭರಾವವಾಳೊ ಹುಯಿನ್ ಅಪ್ಣೆ ದೇವ್ನ “ಬಾ, ಪಿತಾ!” ಕರಿ ಚಿಕ್ರಿಯೆಸ್. ");
INSERT INTO vaa_vpl VALUES ("RM8_16","075_8_16","ROM","8","16","16","ಅಪ್ಣೆ ದೇವ್ನ ಛಿಯ್ಯಾ ಹುಯಿರ‍್ಹಾಸ್, ಕರಿ ಬೋಲಾನ ಪವಿತ್ರಾತ್ಮಸ್ ಅಪ್ಣ ಆತ್ಮನಿಜೋ಼ಡ್ಮ ಸಾಕ್ಷಿ ದೇಸ್. ");
INSERT INTO vaa_vpl VALUES ("RM8_17","075_8_17","ROM","8","17","17","ಹಮ್ಕೆ ಅಪ್ಣೆ ಲಡ್ಕಾ ಹುಯಿರ‍್ಹಾತೊ, ಹಕ್‍ದಾರ್ ಹುಯಿರ‍್ಹಯೇಸ್; ದೇವ್ನ ಹಕ್‍ದಾರ್ ಅಜು಼ ಕ್ರಿಸ್ತನಿ ಜೋ಼ಡ್ಮ ಹಕ್‍ದಾರ್ ಹುಯಿರ‍್ಹಾಸ್. ಅಪ್ಣೆ ಕ್ರಿಸ್ತನು ಖ್ಹತಾಪ್ಣಿಮ ಖ್ಹಾಚಮಾಸ್ ಭಾಗ್‍ಲ್ಯಾವವಾಳ ರ‍್ಹಯಾತೊ, ಇನಿ ಮಹಿಮೆಮಾಬಿ ಭಾಗ್‌ಲ್ಯವಾಳ ಹುಯಿರ‍್ಹಿಶು. ");
INSERT INTO vaa_vpl VALUES ("RM8_18","075_8_18","ROM","8","18","18","ಅಪ್ಣುನ ಖ್ಹಾಮ್ಣೆ ಮಾಲುಮ್ ಪಡ್‌ಶೇತೆ ಮಹಿಮೆನಿ ಜೋ಼ಡ್ಮ ಏಕ್‍ಕರಿ ದೆಖಾನಿವಖ್ಹ್‌ತೆ ಹಮ್ಕೇನಿ ಖ್ಹತಾಪ್ಣಿಖ್ಹಾರು ಯೊ ಶಾತ್ಬಿಕೊಯ್ನಿ. ");
INSERT INTO vaa_vpl VALUES ("RM8_19","075_8_19","ROM","8","19","19","ದೇವ್ನ ಲಡ್ಕಾವ್‌ನಿ ಮಹಿಮೆ ಕದೆ ದೆಖಾವ್‍ಶೇಕರಿ ಉಬ್‍ಜಾ಼ವ್ಣಿ ಘಣು ಜ಼ರೂರ್‌ಥಿ ಖ್ಹಾಮ್ಣೆ ದೇಖುಕರಸ್. ");
INSERT INTO vaa_vpl VALUES ("RM8_20","075_8_20","ROM","8","20","20","ಶನಕತೊ ಉಬ್‍ಜಾ಼ವ್ಣಿ ಇನು ಉದ್ದೇಶ್‌ನ ಗುಮೈಲೀನ್ ಯೊ ಗುರ್‌ಕಾವ್ಣಿಮ ಪಡಿಗಯು, ಯೊ ಇನ ಶೊಂತ್ ಖ್ಹೂಜ಼್‌ಥಿ ಕಾಹೆ ಕತೋಬಿ ದೇವ್ನಿ ಖ್ಹೂಜ಼್‌ಥೀಸ್ ಹ