﻿USE sofia;
DROP TABLE IF EXISTS sofia.uvl_vpl;
CREATE TABLE uvl_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES uvl_vpl WRITE;
INSERT INTO uvl_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Nananga nenge te nana urume Iesus Kristus na tete mur iange Iesus ha nga mata nenge Teuit pe Teuit nette Apraham. ");
INSERT INTO uvl_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Iok, Isak temene Apraham pe Iakop temene Isak. Pe Iuta iri ul titina mur temeria Iakop. ");
INSERT INTO uvl_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Iok, Peres iri nai tina Sara temeria Iuta pe taria he Tamar. Pe Hesron temene Peres pe Rem temene Hesron. ");
INSERT INTO uvl_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Iok, Aminatap temene Rem pe Nason temene Aminatap. Pe Salmon temene Nason. ");
INSERT INTO uvl_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Pe Poas temene Salmon pe tana he Rahap. Iok, Opet temene Poas pe tana he Rut. Pe Iese temene Opet. ");
INSERT INTO uvl_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Pe Naungaala ana non soke ne Teuit temene Iese. Iok, Solomon temene laka ne Teuit pe tana laka ne Uraia nehei. ");
INSERT INTO uvl_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Pe Rehopoam temene laka non palau Solomon pe Apisa temene laka Rehopoam. Iok, Asa temene laka Apisa. ");
INSERT INTO uvl_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Pe Iehosapat temene ne Asa pe Iehoram temene ne Iehosapat. Pe Usae temene ne Iehoram. ");
INSERT INTO uvl_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Iok, Iotam temene ne Usae pe Ahas temene ne Iotam. Pe Hesakie temene ne Ahas. ");
INSERT INTO uvl_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Pe Manase temene ne Hesakie pe Amon temene ne Manase. Pe Iosae temene ne Amon. ");
INSERT INTO uvl_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Iok, Ekonia pe titina mur temeria ne Iosae nga etue nenge Papilon mur te hekou sue Israel mur pe te ua ia iri langa kileng nge Papilon. ");
INSERT INTO uvl_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Iok, tetu nga ich Papilon nem lo pe Siltiel temene Ekonia pe Serupapel temene Siltiel. ");
INSERT INTO uvl_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Iok laol, Apiut temene ne Serupapel pe Eliakim temene ne Apiut. Pe Asor temene ne Eliakim. ");
INSERT INTO uvl_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","pe Satok temene ne Asor pe Akim temene ne Satok pe Eliut temene ne Akim. ");
INSERT INTO uvl_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Iok, Eliesa temene ne Eliut pe Matan temene ne Eliesa pe Iakop temene ne Matan. ");
INSERT INTO uvl_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Iok ol, Iosep temene ne Iakop pe nehei he Maria. Pe he Maria hoe Iesus. Iesus nenge te hetue I ke Kristus. ");
INSERT INTO uvl_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Ke Iesus na tete mur ana lala iri analoch pe henel talun nge Apraham ke lange Teuit. Iok, analoch pe henel mule talun nge Teuit ke langa etue nenge tela nga ich lomona ngana nenge Papilon. Iok, analoch pe henel mule nga etue neu ke langa etue nenge Iesus tana hoe i ia. ");
INSERT INTO uvl_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Iesus Kristus tana hoho ngana ia lohot ke pomai koi. Tana he Maria te teke lape lei nge ne Iosep. Pe iri nai te lei hel ero kura pe hei neu sana nga Opepengpeng lo. ");
INSERT INTO uvl_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Pe Iosep letena tuanin ke teke lape hile mule hei neu pe teke poia ke nek mana iange i non urana ngana ia pe lemene ero nge hemeia he Maria nga hulua mataria. ");
INSERT INTO uvl_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Iok laol, letena tuanin hote ke het pe Non Soke na angkelo e la pe hele lange i nga opene ke teke, “Iosep! Iong lemte palaungana laka ne Teuit. O matau ero. O mene he Maria ke langa lem pele ke lem hei ia iange hei nem sana nga Opepengpeng. ");
INSERT INTO uvl_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","I lape hoe tuna tamane ngana e pe o hetue kol suna nem ke ene Iesus. Iange i lape mene mule nena hana mur nga reria poinga poreke ngana mur.” ");
INSERT INTO uvl_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Ure lochloch ngana nei lohot ke pete tote ure nemur nenge Non Soke hele hote nga hetatalonga hanna lo nenge hele ke teke, ");
INSERT INTO uvl_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Hei malolong e nge maluluch nge non e ero kura lape sana. Pe lape hoe tuna tamane ngana e pe lape te hetue i ke ene Imanuel.” Pe ene nem luna pomai, “NeHalang tu luluch nge ita.” ");
INSERT INTO uvl_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Iok laol, Iosep memete haka pe poia ure nenge NeHalang nena angkelo heleia lange i. Pomalam mene he Maria langa na pele ke nehei ia. ");
INSERT INTO uvl_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Pe iri nai tema luluch hel ero ke la he Maria hoe tuna tamane ngana neu. Pe Iosep heto sapele ke ene Iesus. ");
INSERT INTO uvl_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Iok, Iesus ha nge Petlehem nga kileng nenge Iutea nga etue nenge ne Herot i naungaala ana non soke nga kileng neu. Iesus ha ke ulo pe hana papalauna hel te lohaka nga kileng ilina hele nenga chaia haka ngana pe tela nge Ierusalem. ");
INSERT INTO uvl_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Pe te ontei ke te teke, “Mo teke mo nau nge kol sune nenge tana hoe i pe te teke Iuta mur aria naungaala ana non soke ia. Ana non ngai? Motu nga lemem kileng pe mo esia ana itoch nge tualeme nga chaia haka ngana. Ke ngana koi moat ke mo teke mo heto heke i.” ");
INSERT INTO uvl_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Pe naungaala ana non soke Herot pe hulua lochloch ngana nge Ierusalem te longe ure nei pe leteria tuanin rara ia ke halang. ");
INSERT INTO uvl_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Ol pe ne Herot iu sapele tunginga ana hana mur aria papalauna mur pe hotonga ana hetoronga mur pe ontei hote iri ke teke, “Kristus nem lape tana hoe i langai?” Pe iri te tuacholia, ");
INSERT INTO uvl_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","“Nge Petlehem nga kileng nenge Iutea. Iange hetatalonga e has ngana hele ke teke, ");
INSERT INTO uvl_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","“‘Petlehem iong otu nga ich nenge Iutea. Pe pingam iuiu ol iange Naungaala ana Non e lape lohot nge iong ke nauele lek hana mur nge Israel.’” ");
INSERT INTO uvl_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Ol pe ne Herot iu kome hana papalauna nemur pe ontei hote iri nga etue tei toto nenge itoch neu lohot ia. ");
INSERT INTO uvl_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Ke het pe kulosia iri ke tela nge Petlehem pe hele lange iri ke teke, “Ala pe a tango rara hote kol sune nem ke nek toto. A tango rere i ke a hottaua i pe a hele at nge iau. Ke iau pule ela ke e heto heke i.” ");
INSERT INTO uvl_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Te longe Herot na helenga ke het pe te i sapele. Pe te i ke te nanas mene itoch nenge te esia neu. Te nanasia lala ke la itoch neu mes pengpeng nga kileng unne nenge mamau neu maia. ");
INSERT INTO uvl_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Te esia itoch neu pe te iech toto. ");
INSERT INTO uvl_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Iok, te i teu langa pele neu letena pe te esia kol sune nem iri nai tana he Maria. Pe te tualou sio toto nga matana pe te heto heke i. Ke het pe te mene hote reria tunginga mur nenge ururia haka toto pe te tunge lange i. Tunginga mur nenge pomanga (machmach) um chalemlem ngana nenge uruna haka toto pe ure inangana ehech ngana pe ure pais ngana nenge inangana ehech. ");
INSERT INTO uvl_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Pe operia ke Non Soke teke tela mule nge Herot ero pomalam te i nga kue e nge altoto ke tela mule nga reria kileng. ");
INSERT INTO uvl_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Iok, hana papalauna nemur tela ol pe Iosep ma opene ia Non Soke na angkelo e nge hele lange i ke teke, “O lohaka nga kileng nei pe o mene kol sune nem iri nai tana pe a ua ke a lange Ekipto. Ala ke atu nga lamau pe o longo ala mana nge e hele la mule nge iong. Iange Herot lape tango rere kol sune nem ke teke hunune.” ");
INSERT INTO uvl_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Ol pe Iosep lohaka pe mene mamau neu iri nai tana pe te ua sapele nga miliko ke tela nge Ekipto. ");
INSERT INTO uvl_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Tetu nge Ekipto ke la ne Herot mete. Pe nem pule pete tote Non Soke na helenga nenge heleia lange hetatalonga mur nenge hele ke teke, “E iu hote tuk nga kileng nenge Ekipto.” ");
INSERT INTO uvl_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Pe ne Herot letena inin toto iange eteia ke hana papalauna mol nem te channangaia i lo. Pomalam tung hote helenga kerkereng ngana ke teke te hune aina tatamanna kinkino ngana lochloch nge Petlehem pe nga kileng mur nenge tetu rochroi nge Petlehem pule. Pe teke te hune iri nenge aria hesinga nai ke langa penpene ngana mur lochloch. Pe poia poinga neu iange ontei hote hana papalauna mol neu pe te hele lange i lo nga etue nenge te esia itoch neu. ");
INSERT INTO uvl_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Pe poinga nei lohot ke pete tote ure nenge hetatalonga Ieremaia heleia lo. Nenge hele ke teke: ");
INSERT INTO uvl_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Te longe tanginga pe utunga lolo nge Rama. Mele kou hepehoihoihoi. He Resel laka tangtang ia tutuna mur. Iange tutuna mur kou hana te hune iri ke ulolo. Pe lemene ero nge te hemaluche i.” ");
INSERT INTO uvl_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Iok, ne Herot mete ke ulo pe Non Soke na angkelo lohot mule nge Iosep nga ma opene ngana nge Ekipto. Pe hele lange i ");
INSERT INTO uvl_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","ke teke, “O lohaka pe o mene kol sune nem iri nai tana pe a la mule nga ich nenge Israel iange iri nenge te teke te hunune kol sune nem ngaria kou te mete lochloch lo.” ");
INSERT INTO uvl_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Pomalam Iosep lohaka pe mene kol sune nem iri nai tana pe tela mule nge Israel. ");
INSERT INTO uvl_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Pe Iosep matau nena nge la mule iange longe nge te teke ne Akelos mene mule temene munna ke i non palau pe nauele mule kileng nenge Iutea. Ol pe ma opene mule pe te hele lange i ke lange Kalelea ");
INSERT INTO uvl_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","pe la tetu nga kileng nenge Nasaret. Pomalam NeHalang na helenga nenge hetatalonga mur te hele hote lohot ke manmanna. Nenge hele ke teke, “Lape te hetue I ke nena nge Nasaret.” ");
INSERT INTO uvl_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Iok, nga etue nemur Ioanes nenge henunun la ke haliuliu nga ich sana lomona nenge Iutea ");
INSERT INTO uvl_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","ke teke, “A hulia letemo nga lemo poinga mur iange NeHalang nena naualanga pe nekinga heroi lo.” ");
INSERT INTO uvl_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Ioanes nenge henunun laka nenge hetatalonga Isaias heleia ke teke, “Non e kou haliuliu nga ich sana lomona ke teke, ‘A tatalo ele Non Soke na kue pe a poia ke pengpeng toto.’” ");
INSERT INTO uvl_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Pe Ioanes na hengeron te ume ia nga kamel pulpulna pe ana tal nenga luana te ume hote nga huros mur uliria. Pe ana ngaunga laka sis pe misou eina. ");
INSERT INTO uvl_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Pe hulua lochloch ngana nge Ierusalem pe nge Iutea pe nga kileng lochloch ngana nga ech Iortan te longe i pe te eukirau ke tela lochloch nge i. ");
INSERT INTO uvl_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Pe te hulia leteria pe te hele hote reia poinga poreke ngana mur pe Ioanes henun sapele iri nga ech nge Iortan. ");
INSERT INTO uvl_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Pe Paresio mur pe Satiusi mur tela pule nga kileng nenge Ioanes henunun hehei pe hana ia. Ol pe Ioanes esia iri pe hele lange iri ke teke, “Ilimo alete nemur itei toto nenge hemataua imo ke a ua nga NeHalang letena inin ngana nenge atat mam? ");
INSERT INTO uvl_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","A poia ute hel ke henonou hote imo nge a hulia letemo lo. ");
INSERT INTO uvl_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Eh! Imo a teke Apraham na tete mur imo ke lape NeHalang renge imo ae? Ero toto laka! E hele lange imo pengpeng NeHalang nakuna nge mene um nemur pe poia iri ke te lohot ke Apraham na tete mur ia iri! ");
INSERT INTO uvl_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Pe e hele lange imo pengpeng, ila kou ma nga ae huna lo pe lape te ris heke ae mur nga ularia. Ae nemur nenge te hei pe nganangaria urana ero lape te tele sue iri pe tesau heke iri langa oan. ");
INSERT INTO uvl_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“Iau e henun mene imo nga ech. Pe poinga nem henonou hote ke ahul mule letemo nga lemo poinga poreke ngana mur lo. Pe I nenge nanasia iau lape henune imo nga Opepengpeng pe nga oan. Ana Non I palaungana toto nge iau. Pe iau e urana ero pule nge e mene apena ana ae ulina. ");
INSERT INTO uvl_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Pe I rahite nena sulinga lo nenge lape sulhote uit nganngana mur nga kina. Pe uit nganngana nemur lape takiraua iri ke nek nga ana pele. Pe uit kina nemur lape chacharuch heke iri langa oan nenge remen ngana tu ke kokoes mana.” ");
INSERT INTO uvl_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Iok, Iesus lange Kalelea pe i ke langa ech nenge Iortan ke teke I pule mene henuninga nge Ioanes. ");
INSERT INTO uvl_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Pe Ioanes teke hulia Iesus letena pomalam hele ke teke, “Iau toinge e mene henuninga laka nge iong. Pe ngana iam o teke e henun mule iong mam! Pomerei mai?” ");
INSERT INTO uvl_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Pe Iesus hele, “O henune iau ol. I urana nge e mene henuninga nge iong pomalam lape ure lochloch ngana nenge NeHalang heleia lohot ke pengpeng.” Ol pe Ioanes longala ke henun sapele Iesus. ");
INSERT INTO uvl_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Iok, Iesus mene henuninga ke het pe lohaka sapele. Pe nga etue neu pengpeng tapa sana ulala pe Iesus esia NeHalang opene nge nakuna manga ngie chaulum nge sio at ke to haka mana nge I. ");
INSERT INTO uvl_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Pe helenga e nge sio at nga tapa hele ke teke, “Nenge nei Iau tuk toto nenge lemek tau tote pe e iech toto nge i.” ");
INSERT INTO uvl_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Ke het Opepengpeng poia Iesus ke i sapele ke langa ich sana lomona e ke la non poreke ngana olleke i. ");
INSERT INTO uvl_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Pe Iesus mete ana toto lo iange ngau ero ke sinanga koana iri ana non kina nai (40) pe miliko iri ana non kina nai (40) lo. ");
INSERT INTO uvl_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Pe non poreke ngana la pe olleke i ke teke, “Nenge teke iong NeHalang tuna o hele langa um nemur ke tehul ke iri ngaunga.” ");
INSERT INTO uvl_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Pe Iesus tuacholia pe hele, “NeHalang nena helenga nenge tehas sue ke ulolo, hele ke teke, ‘Non e tu ke maulul nga ngaunga mana ero. Nenge teke mele rahit lochloche helenga mur nenge lohot nga NeHalang hanna pengpeng mele nem lape tu ke maulul.’” ");
INSERT INTO uvl_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Ol pe non poreke ngana neu mene sapele Iesus ke langa tuele tana palaungana nge Ierusalem. Pe mene heke i langa NeHalang na pele palaungana ona nga lut toto. ");
INSERT INTO uvl_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Ol pe hele lange Iesus ke teke, “Nenge teke Iong NeHalang tuna toto o tamu hot nga lamai ke osio langa ich. Iange NeHalang nena helenga nenge tehas sue ke ulolo, hele ke teke, “‘NeHalang lape heleia iong lange nena angkelo mur ke te rahit heke mene iong nga peria. Pe lape otut hule apem nga um ero.’” ");
INSERT INTO uvl_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Ol pe Iesus tuachol mule lange i ke teke, “NeHalang nena helenga mur nenge tehas sue ke ulolo, hele pule ke pomai, ‘O olleke am Soke NeHalang ero toto.’” ");
INSERT INTO uvl_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Ol pe non poreke ngana neu mene heke Iesus langa hengene e nge haka langa lut toto pe henonoua I langa kileng lochloch ngana nga ich pe reia kerkerenga mur. ");
INSERT INTO uvl_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Pe hele lange Iesus ke teke, “Nenge teke o tualou sio pe o heto heke iau lape e tunge ure lochloch ngana nemur lange iong.” ");
INSERT INTO uvl_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Pe Iesus tuacholia lange i ke teke, “Iong Satan! O ua toto nge iau. NeHalang nena helenga mur nenge tehas sue ke ulolo, hele ke teke, ‘O heto heke am Soke NeHalang pe o ume mana nge i.’” ");
INSERT INTO uvl_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Ol pe non poreke ngana neu ua ke la ol pe angkelo mur teat ke te halaua Iesus. ");
INSERT INTO uvl_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Iok, nga etue nenge Iesus longe Ioanes pingana nge tu nga tuele au ngana, lohaka pe la sapele nge Kalelea. ");
INSERT INTO uvl_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Iesus hile kileng nge Nasaret pe la ke tu nge Kapernam. Pe kileng nem tunga ech hetaliliu ngana palaungana nenge Kalelea ilina. Nga ich nenga mata nenge Sepulun iri nai Naptali. ");
INSERT INTO uvl_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Pe Iesus poingana nem lohot ke pete tote ure nenge hetatalonga Isaias heleia lo. Ke hetatalonga Isaias hele ke teke, ");
INSERT INTO uvl_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Ich Sepulun pe Ich Naptali nga kue tana nenge langa ech hetaliuliu ngana palaungana nenge Kalelea pe nga ech Iortan ilina hele kileng Kalelea nenge hana lomonmona ngana mur te tuia. ");
INSERT INTO uvl_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Nga lamau hehei pe hana nenge tetu nga kileng au ngana lape te esia lemenge palaungana. Pe iri nenge metenga ana mulil ma hite iri lemenge nem tualeme hatalia iri pule.” ");
INSERT INTO uvl_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Iesus talun ke hetoro nga etue neu pengpeng pe haliu ke teke, “A hulia lemo poinga poreke ngana mur iange NeHalang nena naualanga pe nekinga heroi lo.” ");
INSERT INTO uvl_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Iok, Iesus i olole nga ech ilina nge Kalelea pe esia hana nai. Hana nai neu titiria hel. Ngana laka Simon nenge te hetue ke Petrus iri nai tina Antreas. Iri nai te hesisio hoat nga ruach sana iange iri hana nenge te holole ruo. ");
INSERT INTO uvl_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Pe hele lange iri nai, “A i at ke a nanasia iau pe e poia imo ke aole hana pule!” ");
INSERT INTO uvl_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Ueiuei mana iri nai te hile sue aria hoat pe tela ke te nanasia Iesus. ");
INSERT INTO uvl_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Iok, tei ole nga lamau ke telala pe Iesus esia hana nai pule. Iri nai titiria hel pule. Elle ene Ieims pe elle ene Ioanes. Pe iri ne Sepeti tutuna mur ia iri. Iri nai te manmana nga aka e pule luluch nge temeria Sepeti ke te palalala aria hoat. Iesus iua iri nai ");
INSERT INTO uvl_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","pe ueiuei mana te hile sue temeria luluch nga aria hoat pe tela ke te nanasia Iesus. ");
INSERT INTO uvl_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Iok, Iesus i ke langa kileng lochloch ngana nge Kalelea ke hetottoro nga pele hetoronga mur. Pe haliu hote helenga urana ngana nga NeHalang nena naualanga pe nekinga. Pe pule hemasmasia hehei pe hana nga aria haleles mur. ");
INSERT INTO uvl_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Ol pe Iesus pingana song ke te longe nga kileng lochloch ngana nge Siria. Pomalam te mene iri nenge aria haleles kuenkuena ke te laia iri nge I. Iri nenge te amneia inin palaungana pe iri nenge uneinei tetu nge iri pe iri nenge singiria loiloiloi pe iri nenge singiria metmete pe te laia iri nge Iesus ke hemas mule iri. ");
INSERT INTO uvl_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Ol pe hulua lochloch ngana nga kileng nenge Kalelea pe Tekapolis pe Ierusalem pe Iutea pe nga kileng nenge tu nga ech Iortan ilina hele te nanasia Iesus. ");
INSERT INTO uvl_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Iok, Iesus esia hulua nemur pe i haka ke la are nga sasana ilina. Ol pe nena hana mur tela nge I ");
INSERT INTO uvl_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","pe talun ke hetoro sapele iri. Pe hele, ");
INSERT INTO uvl_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Iri nenge te eteia ke reria ute e ero toto nga NeHalang matana te iech toto iange lape tetu teu langa NeHalang nena naualanga pe nekinga. ");
INSERT INTO uvl_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Iri nenge te tangtang heueu nei te iech toto ol iange lape NeHalang hemaluch mule leteria. ");
INSERT INTO uvl_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Pe iri nenge tetal sio totote iri te iech toto ol iange lape NeHalang tunge ich lochloch lange iri. ");
INSERT INTO uvl_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Iri nenge muteria tau tote NeHalang lemene ngana ke pomanga muteria taua ngaunga pe ech te iech toto ol. Iange NeHalang lape poia iri ke saria huna. ");
INSERT INTO uvl_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Pe iri nenge leteria porekreke ia pekngaria mur te iech toto ol iange lape NeHalang letena porekeia iri pule. ");
INSERT INTO uvl_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Pe iri nenge leteria lemlem te iech toto pule iange lape te esia NeHalang. ");
INSERT INTO uvl_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Pe pule iri nenge te hemetmete palinga hel pe hunelinga te iech toto iange lape te hetue iri ke NeHalang tutuna mur ia iri. ");
INSERT INTO uvl_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Pe iri nenge te nanas ia poinga nge pengpeng pe mele hel te poi poreke iri te iech toto iange lape teteu la pule nga NeHalang nena naualanga pe nekinga. ");
INSERT INTO uvl_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Pe imo nge a nanas ia iau pe te hele poreke imo pe te tunge amo melmelenga pe te channanga ia hehei pe hana nga helenga poreke ngana mur ke te heporeke imo ");
INSERT INTO uvl_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","letemo sio pe a iech toto iange urumo palaungana kou kulele imo nga lut nga tapa. Pe poinga nenge te poia lange imo nem te poi tele lange hetatalonga mur nenge tetu tala nge imo.” ");
INSERT INTO uvl_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Imo a pomanga mesmes nge hehei pe hana nga ich nei. Pe nenge teke mesmes nem lemene ngana het lape ta poia ke mesmes mule ke pomere? Lape ana ume ero ol. Pomalam lape ta saua pe ta hepapar hite ke lasus. ");
INSERT INTO uvl_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Pe imo a pomanga lemenge nenge tualeme hatalia ich nei. Nenge teke te ume heke tuele tana palaungana e nga sasana, kileng nem talkome ero toto. ");
INSERT INTO uvl_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Mele pele tonge lemenge pe hekom ite nga kaliu e ero. I lape heon heke nga ana heoninga ke tualeme hatal ia iri lochloch ngana nenga pele letena. ");
INSERT INTO uvl_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Ke pomalam mana imo a tualeme pule ke hehei pe hana te esia imo. Pe lape te esia lemo poinga urana ngana mur pe te heto heke Tememo nga lut nga Tapa. ");
INSERT INTO uvl_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“E at ngak nei e at ke e sisparai ia Moses nena hotonga mur pe hetatalonga mur te hetoro ngaria mur ero. E at ngak pete tote iri. ");
INSERT INTO uvl_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","E hele pengpeng lange imo! Tapa pe ich nei lape te het. Pe hasinga elle munna kinkino ngana nemur unne lape erue ero toto. Hotonga nemur lape tetu ke te rorol lochloch ke la het nga etue nenge helenga nemur nganangana lohot ke manmanna. ");
INSERT INTO uvl_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Nenge teke mele longo ole taua helenga nenge hotonga sune e hele ia pe hetore mele hel pule ke te longo ole, mele nem pingana lape iuiu ero toto nga NeHalang nena naualanga pe nekinga nenga tapa. Pe mele nenge nanas tau tote hotonga nemur pe hetottore lala nge mele hel, mele nem lape ene song ke palaungana toto nga naualanga pe nekinga nenga tapa. ");
INSERT INTO uvl_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","E hele lange imo, nenge teke a nanas tau pengpeng ia NeHalang lemene ngana ero pe lemo poinga urana ngana ristote poinga urana ngana nenge Paresio mur pe hotonga ana hengetoro mur ero lape ateu langa naualanga pe nekinga nenga tapa ero toto. ");
INSERT INTO uvl_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“A longe lo nge nike te hele lange hehei pe hana ke te teke, ‘O hune mele ero toto. Pe nenge teke mele hune mele lape tenau teu langa poinga nenge mele nem poia ke nek toto.’ ");
INSERT INTO uvl_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Pe e hele pengpeng lange imo. Mele nenge letena inin tau mule tina e, mele nem lape tenau teu lange i ke nek toto pule. Pe nenge teke o hele poreke tim e, lape hana papalauna tenau teu lange iong pule nga lem poinga nem. Pe nenge teke o hele ia mele ke ana hauaua, o nekia iong iange lape osio langa oan ngingina ngana. ");
INSERT INTO uvl_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“Pomalam nenge teke o lala ia lem tunginga nenge lala nga NeHalang nena hatanga pe letem metene tim e nge poia poinga e lange iong ");
INSERT INTO uvl_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","otal sue lem tunginga mur nga hatanga ilina mukam. Pe ola nge neingam nem ke imo nai a sisa perimo mukam. Ke het pe oat mule ke o tunge lem tunginga lange NeHalang ol. ");
INSERT INTO uvl_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Pe nenge teke lem ngarang e mene iong ke la ames nga hana nenge te longlongo helenga mataria, a i olole nga kue kura pe a hepeng hote nike. Ke a sisa perimo pe a nauel mule ke nek. Pe nenge teke ero lape lem ngarang nem tunge iong langa hana nemur peria pe hana nemur lape te tunge iong lange non papal hussu e ke tamal teua iong langa tuele au ngana. ");
INSERT INTO uvl_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Pe e hele ke manmanna toto lange iong lape o lohot ero toto ke la het nga etue nenge o saua umtutuna lochloch nenge te teke o saua. ");
INSERT INTO uvl_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Iok a longo, nge nike te teke, ‘Oma luluch nge none nehei ero.’ ");
INSERT INTO uvl_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","E hele lange imo, mele nenge esia heie pe memelei ia pe letena tuanin mana ke teke ma luluch nge i nga letena nge teu, poia poinga poreke ngana nem ke het lo. ");
INSERT INTO uvl_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Ke nenge teke matam nenga pen tamalmal poia iong ke o losio nga poinga poreke ngana o sulhote ke lasus. Pomalam singim unne elle mana lape lasus ol. Pe nenge teke ero lape te sausue iong pe singim lochloch ke langa oan ngingina ngana. ");
INSERT INTO uvl_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Iok, nenge teke perim nenga pen tamalmal poia iong ke o losio nga poinga poreke ngana o chato hote pe o saua ke lasus. Urana toto nge o hile hote singim unne ke lasus. Pe nenge teke ero lape tesau sue singim lochloch ke langa oan ngingina ngana. ");
INSERT INTO uvl_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Iok, te heleia pule ke te teke, ‘Nenge teke none lemene ke hile nehei non nem tung tele helenga toto e nga alalaha ke lange nehei. Iange alalaha nem hele tote iri nai aria leinga nge lape het.’ ");
INSERT INTO uvl_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Pe e hele lange imo pengpeng mele nenge hile nehei lape poia hei nem ke la pingana hota mule nge none. Pe hei neu poi ke mau iange ure huna nge iong non nenge o hile i nem. Ke iong non nem o eteia ke iong sipom o heporeke amo leinga. Ure huna nenge o teke o hile lem hei ngana koi nei; Nenge teke lem hei ma luluch nge none ke pingaria hota o hile sapele i. Pe non nenge lei heke mule hei nem lape amneia ke poreke toto iange nanas ia hotonga nenga leinga ero. ");
INSERT INTO uvl_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Iok, pule a longe lo nga helenga nenge te heleia lange ratete mur nge nike. Te teke, ‘Nenge teke o hele ke manmanna lange NeHalang ke o poia ute e, o poia ure nem ke lohot ke pomanga o hele ngam pe o pallaka ero iange Non Soke esia iong ke ulolo.’ ");
INSERT INTO uvl_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Pe e hele lange imo pengpeng, o teke o hele, o hetue kileng nga lut nga tapa ke hekerkereng ia lem helenga ero iange NeHalang na arenga nge heo ngana toto tu nga lut nga Tapa. ");
INSERT INTO uvl_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Pe pule o hele pe o hetue ich ke hekerkereng ia lem helenga ero iange ich nei NeHalang nena ure nge ala hote ke apena ma haka ia. Pe pule o hele pe o hetue kileng nge Ierusalem ke hekerkereng ia lem helenga ero iange Non Soke nenge i naungaala ana non soke toto laka na kileng nem. ");
INSERT INTO uvl_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Pe pule o hele ke manmanna toto nga palpalum ero iange o purpur ero toto nge o hulia palpalum ina elle ke hussu pe muna. ");
INSERT INTO uvl_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","O hele ke pengpeng mana. O hele ke ‘Oe’ ma o hele ke ‘Ero’. Iange helenga nemur nenge otal teu luluche langa lem helenga nenge ‘oe’ pe ‘ero’ nem non poreke ngana laka tunge lange iong ol. ");
INSERT INTO uvl_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Pe pule a longe lo nenge te teke, ‘Nenge teke mele pal ele matam iong o pal ele matana pule. Pe nenge teke mele pal hoa ngingim iong o pal hoa ngingina pule.’ ");
INSERT INTO uvl_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Pe e hele lange iong pengpeng o tuachol mule lange mele nenge poi poreke iong ero. Nenge teke mele tepele sose iong o hulia iong ke tepele iong nga ele pule. ");
INSERT INTO uvl_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Pe nenge teke mele hemes teua iong langa tuele nenge te longlongo helenga ia pe teke mene lem hengeron nenge teu ana o tunge lem hengeron nenge ot ana lange i pule. ");
INSERT INTO uvl_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Pe nenge teke mele echia iong ke o puotaua i ke sase pol o puotaua i ke sase toto. ");
INSERT INTO uvl_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Pe nenge teke mele onteia iong nga ute o tunge lange i. Pe pule nenge teke mele lemene ke hanok ia ute nge iong, o tunge ure nem lange i pule. ");
INSERT INTO uvl_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Pe pule a longe lo nenge te teke, ‘Lememo tau mene neingamo mur pe apoi poreke lemo ngarang mur.’ ");
INSERT INTO uvl_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Pe heueu nei e hele pengpeng lange iong. Lemem taua lem ngarang mur. Pe iri nenge te tunge amo melmelenga o hetalaulau aria nge NeHalang ke halaua iri. ");
INSERT INTO uvl_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Nenge teke apoi ke mai Tememo nga lut nga tapa tutuna mur toto imo. I sipona poia chaia matana ke haka ke tua hatal ia hana uranrana ngana mur pe nge hana porekreke ngana mur pule. Pe poia pitte ke sio nge hana nenge te nanas ia poinga nge pengpeng pe nge hana nenge te popoi poinga porekreke ngana mur pule. ");
INSERT INTO uvl_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Nenge teke lemem taua mele nenge lemene taua iong lape o mene urum unne ero toto. Hana nenge te lololoch umtutuna te popoi ke pomalam pule. ");
INSERT INTO uvl_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Pe nenge teke o apala hot mene neingam mur utar nge urana toto nge o poia? Hana nenge te eteia NeHalang ero iri te poi ke urana toto lala nge pekngaria mur. ");
INSERT INTO uvl_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Ke imo lochloch a hepengpeng ia imo pe a poia ure ke lohot ke pengpeng ke pomange Tememo nga lut nga tapa I non nge pengpeng toto. ");
INSERT INTO uvl_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Iok, letemo matana ke nek toto. Nenge teke a poia poinga urana ngana mur a poia pe a hemallaha hote ke hulua te esia ero. Iange nenge teke o hemallaha hote lape o mene urum unne nge Temem nga lut nga tapa ero. ");
INSERT INTO uvl_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Ke nenge teke o tung ure lange mele hel nenge reria ero o iua ana ngalum paena ero. Iange hana nenge aria hengetau nachnai te popoi ke pomalam. Te popoia poinga nem nga pele hetoronga mur pe nga kue matana mur ke te teke hehei pe hana te heto hekeke iri. Pe e hele lange imo pengpeng iri te mene ururia mur ke het lo. ");
INSERT INTO uvl_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Ke nenge teke a tung lange mele hel nenge reria ure ero ");
INSERT INTO uvl_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","apoi kome tote ke perimo nenge hoihoi eteia ure nenge perimo nenge tamalmal popoia ero. Pomalam lape a mene urumo nge Tememo. Iange I esia ure lochloch ngana nenge talkomkome. ");
INSERT INTO uvl_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Iok, nenge teke a hetalaulau apoi ke mange hana nenge aria hengetau nachnai ero. Iri lemeria toto nge temes ke te hetalaulau nga hetoronga ana pele letena pe nga kue ilinlina mur ke te teke hehei pe hana te esesia iri. Pe e hele lange imo pengpeng iri te mene ururia lochloch ke het lo. ");
INSERT INTO uvl_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Pe imo nenge teke a hetalaulau ateu langa lemo pele nga mullimo nenge a mamaia pe a hetalaulau lange Tememo nenge ta esia I ero. Pe Tememo esia ure nenge apoi kome pe nga hoena lape tunge urumo ol. ");
INSERT INTO uvl_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Iok, hana hel leteria manmanna nge NeHalang ero. Pe nenge teke a hetalaulau apoi ke ma nge iri ero. Iange iri te hetalaulau pe te heleleia helenga mur halang nenge luna ero pe te olole ke sasase toto. Pe te teke lape aria non soke longe iri nga reria helenga lochloch ngana nemur. ");
INSERT INTO uvl_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","A poi ke mange iri ero toto. Iange a onteia Tememo ero kura pe I etei ia ure nemur lo nenge lape a onteia. ");
INSERT INTO uvl_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","“Ke nenge teke a hetalaulau, a hetalaulau ke mai koi; “‘Tememem nga lut nga tapa em pengpeng toto. ");
INSERT INTO uvl_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Lem naualanga pe nekinga at ke mo longo taua iong lakoi nga ich ke pomanga te longo taua iong nga lut. ");
INSERT INTO uvl_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","O tunge emem ngaunga nga lapa pe nge he pe. ");
INSERT INTO uvl_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","O tuacholia nge imem ero ke pomanga mo tuacholia ero nge iri nenge te poi poreke imem. ");
INSERT INTO uvl_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","O poi ele imem nga olenga pe o hu hele ure poreke ngana mur nge imem.’ ");
INSERT INTO uvl_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Iange nenge teke letem ia mele nenge poi poreke iong lape Temem nga lut nga tapa lape letena ia iong pule. ");
INSERT INTO uvl_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Pe nenge teke letem ia iri nenge te poi poreke iong ero Temem lape letena porekeia iong nga lem poinga poreke ngana mur ero pule.” ");
INSERT INTO uvl_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Nenge teke oheo nga ngaunga o henonou hote nakum usus ngana ero. Iange hana nenge te channanga hali te popoi ke pomalam. Nenge teke teheo nga ngaunga te hemallaha hot tote lange hehei pe hana ke nakuria usus toto. Pomalam te eteia ke hana nemur teheo nga ngaunga. Pe E hele lange imo. Hana nemur te mene ururia mur lochloch ke het lo. ");
INSERT INTO uvl_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Nenge teke oheo nga ngaunga o lome matam pe o helemlem heke singim ");
INSERT INTO uvl_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","ke hehei pe hana te eteia ero nge oheo nga ngaunga. Pe Temem nenge ta kolkolia lape tunge urum nga hoena ol. Iange I toro mana nge esia ure lochloch ngana nenge talkome. ");
INSERT INTO uvl_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Pe a takiraua lemo ure urana ngana mur nga ich nei ero. Iange lape kankan te ngau hule pe lape tema sakilil pe singiria karkare hulu. Pe pule lape kemenge kina mur te tamu teu ke te kemeia iri. ");
INSERT INTO uvl_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Nenge teke a takirau lemo ure urana ngana mur a takiraua lakou nga lut nga tapa. Iange kankan lape ngaua ero pe ure hel te heporeke ero. Pe pule kemenge kina mur lape te kemeia ero. ");
INSERT INTO uvl_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Pomalam lape letem tu hit mene kileng nenge lem ure urana ngana mur te maia. ");
INSERT INTO uvl_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Matara i lemenge nenga singira. Nenge teke matam te urana mana singim lochloch lape tualeme. ");
INSERT INTO uvl_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Pe nenge teke matam te poreke singim lochloch lape tu ke au mana. Ke nenge teke lemenga e ero nga singim pe singim au mana lape au nem puo ke palaungana pe au hit sapele iong. ");
INSERT INTO uvl_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Mele pele ume nge hana nai ero. Iange lape lemene ero ia e pe lemene taua e. Nem pe la ke nanas mene e pe nau sio mene e. Mele nenge lemene tau tote umtutuna nakuna ero nge ume nge NeHalang. ");
INSERT INTO uvl_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Ke pomalam e hele lange imo letemo meena sakilil nga atu ngamo nga ich nei ero. Nga utar nenge lape a ngaua pe a inia pe nga utar nenge lape a heron hite nga singimo. A maul ngamo i ure nenge palaungana toto nga ngaunga pe singimo i ure nenge palaungana toto nga hengeron mur. ");
INSERT INTO uvl_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","A nau haka langa ngie mur nga lut. Iri tetua ngaunga ero pe te lulu erochro. Pe pule te takirau teueu ngaunga nga ana pele ero. Pe Tememo nga lut nga tapa hengaungaua iri kura. Pe ngie nemur iri ure nenge palaungana nga NeHalang matana ero. Ngana laka imo lo. ");
INSERT INTO uvl_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Iok, nenge teke letemo meena sakilil amo tei nge imo purpur nge tom ia ana etue nenge meteia ke elela polpol? ");
INSERT INTO uvl_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Pe pomere nenge letemo meena sakilil ia hengeron mur? A nau langa ae rorana mur nga ume. Iri te poia ume palaungana e ero pe iri siporia te sime aria tal nenge te hemale hite nge iri ero. ");
INSERT INTO uvl_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Pe e hele lange imo pengpeng Ne Solomon heron heke nena hengeron urana ngana mur pe i nakuna urana ero iange ae rorana nemur nakuria urana toto nge i. ");
INSERT INTO uvl_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Pe NeHalang Isipona hemele heilil lochloch ngana nenge tetu nga uraurau. Pe heilil nemur tetu ke te maulul heueu pe nge rou tesau heke iri nga oan. Ke pomalam imo nenge letemo manmanna ngana unne sune mana a etei tote ol ke NeHalang lape hemele imo pule! ");
INSERT INTO uvl_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Letemo meena ero pe a hele ke pomachmai ero: ‘Lape ta ngaua ara utar mai ol? Pe lape ta in langai mai? Pe lape ta heron ia utar?’ ");
INSERT INTO uvl_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Melehel nenge te eteia NeHalang ero toto lape te song ke te tango rere ure nemur. Pe Tememo nga lut nga tapa eteia lo ure nemur nenge purpur ero nge imo. ");
INSERT INTO uvl_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Ure nenge toi nge lememo tau tele ngana laka NeHalang nena naualanga pe nekinga pe pule nena poinga nenge pengpeng toto. Ol pe NeHalang lape tunge ure lochloch ngana nemur lange imo. ");
INSERT INTO uvl_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Pomalam letemo tuanin rara sakilil nga utar nenge lape lohot nge rou ero. Etue nenge rou nem i sipona letena tuaninin nge i sipona. Ke ure meena ngana mur te lohot ke te purpure etue elle pe elle. ");
INSERT INTO uvl_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“A henonou perimo lange mele hel ero toto. Mele nenge henonou penna lange mele NeHalang lape henonou penna lange i. ");
INSERT INTO uvl_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Kue nenge a henonou perimo lange mele hel kue nem mana NeHalang lape poia lange imo pule. ");
INSERT INTO uvl_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","“Pomere nenge o esia ae mumuna unne sune nge ma ele neingam matana pe o kolkolia ae chonna palaungana nenge ma ele iong sipom matam? ");
INSERT INTO uvl_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Pomere nenge ae chonna palaungana ma ele matam pe o hele lange neingam e neu ke o teke o poi hote ae mumuna unne nenge ma ele matana? ");
INSERT INTO uvl_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Iong am hengetau nai iam teke poi pe o mene hot tele ae chonna palaungana nenge ma ele matam mukam. Ke het o nau ke nek pe o poi hote ae mumuna unne sune nenge ma ele neingam e nem matana ol. ");
INSERT INTO uvl_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Lemo ure urana ngana mur nenge heo ngana a tunge lange kaone mur ero. Pe lemo holonga mur a tamal sue lange kie mur ero. Iange lape te hepapar hulu hit mene pe te ringha taua imo pe te lata hule imo. ");
INSERT INTO uvl_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“O ontei pe lape NeHalang tunge lange iong. O tango rara pe lape o hottaua. O ischong nga piunga pe piunga nem lohe lange iong. ");
INSERT INTO uvl_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Ke iri nenge te onteitei te menmene pe iri nenge te tango rarara te hottautau pe iri nenge te ischongchong nga piunga lape piunga olha lala nge iri. ");
INSERT INTO uvl_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“Amo tei nge imo nenge teke tuna tamane ngana e ontei loi lange i pe tunge um lange tuna? ");
INSERT INTO uvl_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Nem pe tuna ontei ruo pe tunge ilimo lange i? ");
INSERT INTO uvl_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Imo hana poreke ngana nemur a eteia utar nenge urana nge lape a tunge lange tutumo mur. Ke pomalam a etei tote ol ke Tememo nenga lut nga tapa lape tunge ure urana ngana mur lange iri nenge te onteitei lala nge I. ");
INSERT INTO uvl_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Pe nga ure lochloch poinga urana ngana mur nenge lememo ke mele hel te poia lange imo a poia lange iri pule. Moses nena hotonga mur pe hengetoro nenge hetatalonga mur luna toto koi nei. ");
INSERT INTO uvl_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Iok, imo a i teu laka nga piunga matana nenge kino. Iange piunga nenge soke pe ana kue mallaha pe song ke langa oan ngingina ngana. Pe hulua halang toto te i teueu nga piunga nem. ");
INSERT INTO uvl_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Pe piunga nenge kino ana kue tuna mana pe mallaha ero. Pe kue nem song ke langa maulinga ke koko ana kileng. Pe iri hel mana te saolia kue nem pe te nanasia. ");
INSERT INTO uvl_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Iok, a nauala amo ke nek nge hana nenge te channangnanga ke te teke iri hetatalonga mur. Iri lape teat nge imo pe te maluch ole mene imo ke pomanga sipsip mur. Pe i nge ero la. Nga leteria nge teu te poreke toto ke pomalaka nga kaone hinolo mur. ");
INSERT INTO uvl_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Lape a etei tote iri ke nek laka nga reria poinga mur ol. A nau at, uain nganangana te sohe hote nga kiki tana ero. Pe ae Popi nganangana te sohe hote nga heilil nenge memesanga ngana halang ero. ");
INSERT INTO uvl_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Ke pomalam mana ae nenge urana lape nganangana mur te urana mana pe ae nenge poreke lape nganangana mur te poreke. ");
INSERT INTO uvl_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Ke ae nenge urana nakuna ero nge nganangana poreke. Pe ae nenge poreke nakuna ero nge nganangana urana pule. ");
INSERT INTO uvl_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Pe ae nemur nenge nganangaria te poreke lape te tele sue iri pe tesau heke iri langa oan. ");
INSERT INTO uvl_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Ke pomalam mana lape a eteia hana nemur nga ure nemur nenge te popoia. ");
INSERT INTO uvl_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Hulua lape te hetue iau ke ‘Non Soke Non Soke’ pe iri lochloch lape teteu la ero toto nga naualanga pe nekinga nga lut nga tapa. Iri nenge te nanas taua Temek nenge tu nga lut lemene ngana iri mana lape teteu langa naualanga pe nekinga nenga tapa. ");
INSERT INTO uvl_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Pe hulua lape te hele at nge iau nga NeHalang nena haliunga ana etue nem ke mai, ‘Non Soke, Non Soke, imem mo haliu hote iong pe mo helope hote uneinei mur pe mo poia urelu mur ke te lohot nga iong em pule i.’ ");
INSERT INTO uvl_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Pe lape e hele ke mallaha toto lange iri ke e teke, ‘Imo nemur, e eteia imo ero toto. A ua toto nga matak. Imo hana porekreke ngana mur iam.’ ");
INSERT INTO uvl_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Ke pomalam iri nenge te longe lek helenga mur pe te nanas taua te poi ke pomanga non nenge letena matana ke hemes heke na pele nga um. ");
INSERT INTO uvl_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Pe nga etue nenge pitte molmol pe ech hotot pe tuttula at ke tah teu nga pele neu pe pele nem losio ero. Iange ana pele mes haka nga um ke kerkereng toto. ");
INSERT INTO uvl_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Pe iri nenge te longe lek helenga pe te nanas taua ero te poi ke pomalaka nge non nenge letena matana ero pe hemes sio mene na pele nga peipei. ");
INSERT INTO uvl_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Pe nga etue nenge pitte molmol pe ech hotot pe tuttla at ke tah teu nga pele neu pe pele nem hutu sio ke chach hulu.” ");
INSERT INTO uvl_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Iok, Iesus hele ia ure nemur ke het pe hulua nemur leteria tuanin ke halang nga Iesus hetoro ngana. ");
INSERT INTO uvl_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Iange i hetoro ke pomanga hotonga ana hetoronga mur ero. Hetoro ngana pomalaka nga none nge na kerkerenga palaungana toto. ");
INSERT INTO uvl_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Iok laol, Iesus i sio mule nga sasana neu pe hulua halang toto te nanasia i. ");
INSERT INTO uvl_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Ol pe none nge haleles poreke ngana mene i lange Iesus. Non neu lake tualou sio nga Iesus matana pe hele, “Non Soke, nenge teke lemem o hemas mule iau ke singik lemlem mule.” ");
INSERT INTO uvl_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Ol pe Iesus tul hot sapele penna pe la tal heke nge non neu pe hele, “Oe iau lemek. Singim lemlem mule ol.” Ueiuei mana pe haleles poreke ngana neu het sio sapele nga non neu singina. Haleles poreke ngana neu ngau hohoa singira. ");
INSERT INTO uvl_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Pe Iesus hele lange i ke teke, “Heueu o hele hote ure nei lange mele e ero toto. Ola ke o eteia iong lange tunginga ana none ke poia tunginga nenge Moses hele ia nga hana nenge te urana mule. Ke nem lape henonou hote utar nenge e poia lange hehei pe hana.” ");
INSERT INTO uvl_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Iok, Iesus la ke i teu nga kileng palaungana nenge Kapernam pe palinga hel ana hana mur aria soke e lake esia i pe hele lange Iesus ke halaua i. ");
INSERT INTO uvl_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Ke non soke neu hele lange Iesus ke teke, “Non Soke, lek non nenge umume nge iau kou ma mana nga pele. Singina inin hulu pe sachul rara ero toto.” ");
INSERT INTO uvl_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Pe Iesus hele, “Lape e la ke e hemasmasia i.” ");
INSERT INTO uvl_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Pe palinga hel ana hana mur aria soke neu hele, “Non Soke, iau e urana ero toto nge o teu at nga lek pele. O hele mana pe lek non neu urana mule. ");
INSERT INTO uvl_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Iange iau pule hana hel tenau ele iau. Pe iau enau ele lek hana mur hel pule. Nenge teke e hele lange iri ke, ‘Ola,’ pe ana non la. Pe e hele lange i neu ke, ‘O iat,’ pe ana non i at. Pe e hele lange lek non ke, ‘O poia ure nei,’ pe i poia.” ");
INSERT INTO uvl_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Iesus longe non neu nge hele ke mau pe letena tuanin ke halang. Ol pe hele lange iri nenge te nanasia i, “E hele ke manmanna toto lange imo, e hottaua none nge Israel nge poi ke mange non nei ero kura. Non nei letena manmanna ngana palaungana toto. ");
INSERT INTO uvl_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Hulua halang teat nga kileng hele nenga chaia haka ngana, pe nga chaia sio ngana pe la te kila ke te ngau luluch nge Apraham pe Isak pe Iakop, nga naualanga pe nekinga nenga tapa. ");
INSERT INTO uvl_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Pe hana nenge reria kileng neu toto, lape NeHalang lope hote iri ke la tetu nga kileng au ngana. Nga kileng nenge te tangtang pe ngingiria chatrekreke ia.” ");
INSERT INTO uvl_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Ol pe Iesus hele lange palinga hel ana hana mur aria soke neu, “O laol, Ure nem lape lohot ke pomanga letem manmanna ngana nenge o teke lape lohot ke pomam. Ol pe nena non nenge singina haleles neu, singina urana mule nga etue neu pengpeng.” ");
INSERT INTO uvl_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Iok, Iesus la ke i teu nga Petrus nena pele pe esia Petrus uene nge singina haleles ke ma nga hete. Ana hei singina milanglang. ");
INSERT INTO uvl_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Ol pe Iesus penna la ke rahite hei neu pe ana haleles het sio sapele. Pe hei neu lo haka pe tun sapele ngaunga pe hengaua Iesus. ");
INSERT INTO uvl_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Iok, nga ulei te laua iri nenge uneinei tu teu nge iri ke te laia iri nge Iesus. Pe Iesus hele pe helope hote uneinei nemur pe hemas mule iri lochloch ngana nenge singiria haleles. ");
INSERT INTO uvl_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Pe poinga nenge Iesus poia nem, poia ke pete tote NeHalang nena helenga e nge hetatalonga Isaias hele hote nge nike lo nenge hele ia ke teke, “Isipona amneia ara melmelenga pe takisia ara haleles mur.” ");
INSERT INTO uvl_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Iok, Iesus esia hulua nge te heliliu hite I ke tom, pe hele lange nena hana mur ke teke te lotele langa kolkolu palaungana neu ilina hele. ");
INSERT INTO uvl_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Ol pe hotonga ana hetoronga e la pe hele lange Iesus ke teke, “Hetoronga, nenge teke o la ke merei, iau lape e nanas mene iong.” ");
INSERT INTO uvl_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Pe Iesus hele lange i ke teke, “Kaone hinolo mur reria polo tu nga ich, polo nenge te mamaia. Pe ngie mur pule reria kiniu, pe Non Tuna munna e nge mama ia ero.” ");
INSERT INTO uvl_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Pe Iesus nena none hele ke teke, “Non Soke, e la ke e alo hite temek mukam, ke ulo pe e at ke e nanasia iong ol.” ");
INSERT INTO uvl_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Pe Iesus hele lange non neu ke teke, “Hana nenge te metmete pekngaria mur te alo hit mulmule iri. Pe iong o iat ke o nanasia iau.” ");
INSERT INTO uvl_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Iok, Iesus haka nga sulang e pe nena hana mur tela luluch nge I. ");
INSERT INTO uvl_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Te la ol pe kileng eingana haka sapele. Pe kileng eingana neu palaungana pe poia ruach ke poreke toto. Pe ruach ana mee teke hepuluch sue iri. Pe Iesus mamani. ");
INSERT INTO uvl_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Ol pe nena hana mur te hengo heke I pe te hele ke te teke, “Non Soke, o halaua ita ero kai? Ta metmete lo i!” ");
INSERT INTO uvl_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Pe Iesus hele, “Imo letemo manmanna ngana unne sune mana iam. A matau sakilil ia utar?” Ol pe Iesus lo haka pe hele ke kerkereng toto langa tuttula palaungana neu pe ruach poreke ngana neu. Ol pe tuttula palaungana neu het pe ruach poreke ngana neu ma ke mello mule. ");
INSERT INTO uvl_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Ol pe hana nemur te esia pe leteria tuanin ke halang pe te hele, “Non nei mai i utar toto? Tuttula pe ruach te longo tau mene I.” ");
INSERT INTO uvl_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Iok, Iesus lo tele la sapele nga kolkolu palaungana neu ilina hele nga Katara mur reria ich. Pe hana nai nge uneinei tu teu nge iri. Te lohot nga rika mur nenge hana koluria mur tema teu ia pe la te saolia Iesus. Pe hehei pe hana te matau tote hana nai neu ke te i rara nga lamau ero toto. Iange iri nai nakuria sisiling toto. ");
INSERT INTO uvl_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Iok laol, hana nai neu te alngaria sapele, “NeHalang Tuna, o teke oat ke o potaria ia imem? Emem etue nenge mo takisia emem melmelenga at ero kura.” ");
INSERT INTO uvl_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Pe kie ana tuangarung e te sesel ke sase ero mana nga iri te mes ngaria. ");
INSERT INTO uvl_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Ol pe uneinei nemur te echia Iesus, “Nenge teke o lope hote imem heueu, o kulosia imem ke mo teu heke kou kie ana tuangarung neu.” ");
INSERT INTO uvl_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Ol pe Iesus hele lange iri, “Iok, a laol!” Ol pe uneinei nemur te lohot nge hana nai neu pe la ke teteu heke kie nemur. Pe kie ana tuangarung neu te song hot sapele langa sasana neu ilina, pe te losio teu nga kolkolu neu pe te pulachlach ke te mete sapele. ");
INSERT INTO uvl_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Pe iri nenge tenau elele kie nemur te song sapele ke tela nga tuele tana pe te hele ia ure nenge lohot nga kie nemur, pe pule nge hana nai nenge uneinei tu teu nge iri neu. ");
INSERT INTO uvl_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Ol pe hulua lochloch ngana nga tuele tana palaungana neu, te i ke la te lohot nge Iesus. Te la te esia I pe te hele ke kerkereng toto lange I ke te teke, ua nga reria kileng unne neu pe la toto nga kileng unne. ");
INSERT INTO uvl_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Iok laol, Iesus lo haka mule nga sulang pe mana tele mule ke lange Kapernam, nga i sipona nena kileng huna. ");
INSERT INTO uvl_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Ol pe hana hel te takis ia none nge singina lochloch mete pe mamana nga tako. Pe Iesus esia hana nemur leteria manmanna ngana pe hele lange non nenge singina mete neu, “Letem huna sakilil ero ol. E saua lem poinga poreke ngana mur ke te lasus toto lo.” ");
INSERT INTO uvl_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Pe hotonga ana hetoronga mur hel, te hele chunuch mana nge iri ke pomai, “Non nei hele ngana pomalaka nga I NeHalang toto i. Poia helenga nei, heporeke tote NeHalang ene.” ");
INSERT INTO uvl_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Pe Iesus eteia leteria tuanin ngana mur ke ulolo. Ol pe hele ke teke, “Pomere nenge letemo inin ngana nem tu teu mana nge imo ke pomam? ");
INSERT INTO uvl_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Helenga tei nge semel nge lape te heleia? ‘E saua lem poinga poreke ngana,’ ma nenge e teke, ‘O mes haka pe o i.’? ");
INSERT INTO uvl_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Iau e teke e poia ke mam ke a eteia, ke Non Tuna na kerkerenga palaungana nga ich, nge saua hehei pe hana reria poinga poreke ngana mur ke lasus toto.” Ol pe Iesus hele lange non nenge singina mete neu, “O mes haka pe o mene lem manga pe o i ke o la nga lem pele.” ");
INSERT INTO uvl_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Non neu mes haka pe i ke la sapele nga na pele. ");
INSERT INTO uvl_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Pe hulua lochloch ngana te esia ke pomau pe leteria huna pe leteria tuanin ke halang. Pe te heto heke tote NeHalang ene iange tunge kerkerenga palaungana nei at nge ita non. ");
INSERT INTO uvl_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Iok, Iesus lo haka nga lamau pe i ole ke la pe esia none nge ene Mateus, nge arare nga hana nenge te lololoch umtutuna reria pele sune. Ol pe Iesus hele lange i ke teke, “O i at ke o nanasia iau.” Mateus lo haka pe nanas sapele Iesus. ");
INSERT INTO uvl_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Iok, Iesus pe na hana mur teare ke te ngaungau nga Mateus na pele pe hana nenge te lololoch umtutuna pe hana porekreke ngana mur teat ke te ngau luluch nge iri. ");
INSERT INTO uvl_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Pe Paresio mur te esia ke mau pe te onteia Iesus nena hana mur ke te teke, “Pomere nenge amo hetoronga ngau luluch nge hana porekreke ngana pe hana nenge te lololoch umtutuna mai?” ");
INSERT INTO uvl_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Pe Iesus longe pe hele, “Haleles kina mur mana tela nge non nenge hemasmas ia haleles kina mur, pe iri nenge singiria urana tela nge non nem ero. ");
INSERT INTO uvl_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Ala pe letemo tuanin hote helenga nei luna ke nek. ‘Lemek ero ia lemo tunginga pa nemur nenge a makmak huros. Lemek ke letemo ia hehei pe hana.’ Iange e at ke e iua hana porekreke ngana mur mana, pe hana nenge te urana e iua iri ero.” ");
INSERT INTO uvl_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Iok, Ioanes na hana mur teat pe te onteia Iesus ke te teke, “Pomerei nenge imem pe Paresio mur moheo nga ngaunga pe lem hana mur teheo ero?” ");
INSERT INTO uvl_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Pe Iesus tuacholia ke teke, “Nenge teke none nge lei heueu ngana at ke kila luluch nge nena hana mur, hana nemur lape te iech ke elela. Pe nga etue nenge non halangina nem i ero hatalia iri, hana nemur lape teheo nga ngaunga sapele. ");
INSERT INTO uvl_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Mele pele mene malenga heueu ngana sachana, pe sima hite hengeron nike ngana chach ngana ero. Nenge teke poia ke pomam, lape malenga sachana heueu ngana nem ta chach mule. Pe ure chach ngana nem palaungana toto sapele. ");
INSERT INTO uvl_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Nenge mele ling teua uain heueu ngana ke langa meme ulina ke kina ia, ling teua langa meme ulina nenge nike ngana ero, iange meme ulina nike ngana nem sosolos lo, pe uain heueu ngana nem lape una haka ke hemute meme ulina sosolos ngana nem ke chach. Pe uain nem lape pasiling hot pe kina pule poreke ke lasus. Nenge urana laka, ling teua uain heueu ngana ke langa kina meme ulina nenge heueu ngana. Pomalam iri nai tetu ke urana.” ");
INSERT INTO uvl_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Iok, Iesus helele kura pe non nenge nauelele pele hetoronga neu, at ke tualou sio nga Iesus matana pe hele, “Tuk nenge hei pau kou mete heueu mana nei. Pe e teke o i at ke la otal heke perim nge i ke maul mule.” ");
INSERT INTO uvl_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Iok laol, Iesus pe nena hana mur te lo haka pe tela luluch nge non neu sapele. ");
INSERT INTO uvl_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","21","Pe heie pule toho mala lohot nge i ke hesinga iri analoch pe nai lo. Pe ana hei helele nge i sipona ke teke, “Nenge teke e ra haka mana nga Iesus na hengeron, haleles nei lape het nge iau sapele.” Pomalam hei neu langa Iesus rumena pe rahaka nga Iesus nena hengeron ana horo. ");
INSERT INTO uvl_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Ol pe Iesus ralele pe esia i pe hele, “Hatong, letem huna ero ol. Letem manmanna ngana laka nenge hemaulia iong nga haleles nem.” Pe nga etue unne neu pengpeng haleles neu het sapele nge hei neu. ");
INSERT INTO uvl_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Iok laol, Iesus la ke i teu nga non nenge nauelele hetoronga ana pele nena pele pe esia hana nge te iuiua iu pe hulua nge te chauchai rara ke halang. ");
INSERT INTO uvl_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Ol pe Iesus hele, “Imo lochloch ngana nem a ua! He nem mete ero iam, mamani mana laka.” Pe hulua nemur te melmel lil ia Iesus. ");
INSERT INTO uvl_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Iok, hulua nemur tela ke tetu nge hot pe Iesus teu la ke ra hite he neu nga penna. Ol pe he neu opene teu mule nge i pe lo haka sapele. ");
INSERT INTO uvl_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Pe ure nenge Iesus poia neu ana helenga song ke kileng lochloch ngana nenga lamau te longe. ");
INSERT INTO uvl_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Iok, Iesus lohot nga lamau ke teke lalalo pe hana mata hit nai te nanas pe alngaria hot lange I ke te teke, “Ne Teuit tuna, letem poreke ia imem!” ");
INSERT INTO uvl_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Ol pe Iesus la ke i teu nga pele e pe mata hit nai neu tela nge i. Pe Iesus onteia iri ke teke, “Imo mam letemo manmanna toto ke lape e hemas mule imo ma?” Pe iri nai te hele, “Oe Non Soke, letemem manmanna toto i.” ");
INSERT INTO uvl_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Iok laol, Iesus ra haka nga iri nai mataria pe hele, “Lape e poia ure nem ke lohot nge imo nai ke pomanga letemo manmanna ngamo.” ");
INSERT INTO uvl_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Ol pe iri nai tenau mule sapele. Pe Iesus hele ke kerkereng toto lange iri nai ke teke, “A hele hote ure nei lange mele ero toto.” ");
INSERT INTO uvl_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Pe ero. Hana nai neu tela ol pe te hesongia ana helenga nga kileng lochloch ngana. ");
INSERT INTO uvl_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Iok, nga etue nenge hana nai nem te i ke tela, hana hel te takisia none pule lange Iesus. Non nem hele poreke iange uneinei tu teu nge i. ");
INSERT INTO uvl_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Iesus helope hote uneinei nem ke ua hot nge non nem. Iok laol non nenge hele poreke nem hele mule sapele. Ol pe hulua ngaria lohot pe te hele, “Imem mo kolkol ute e nge pomai nge lohot nge nike nge Israel.” ");
INSERT INTO uvl_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Pe Paresio mur te hele, “Uneinei mur aria soke laka hekerkereng ia i ke helope hotote uneinei mur.” ");
INSERT INTO uvl_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Iesus i ke rongo heke tuele tatana mur pe kileng kinkino ngana mur, ke hetottoro nga hetoronga ana pele mur. Iok, pe haliu hote helenga urana toto ngana nenga NeHalang nena naualanga pe nekinga pe pule hemasia hehei pe hana nga aria haleles mur. ");
INSERT INTO uvl_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Pe Iesus esia hulua nemur pe letena ia iri iange leteria meena pe tetu poreke, pe mele nge nauele iri ero ke pomanga sipsip mur nge aria naunga ala ero. ");
INSERT INTO uvl_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Ol pe hele lange nena hana mur ke pomai, “Ngaunga halang te mera tach lo. Pe lulunga ana hana mur iri unne sune mana. ");
INSERT INTO uvl_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","A hetalaulau lange ume tokoninga ke kulosia lulunga ana hana mur hel pule ke te halau ke te lulu.” ");
INSERT INTO uvl_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Iok laol, Iesus iua nena hana mur nge iri analoch pe nai ke te eukirau pe tunge kerkerenga palaungana lange iri. Te mene kerkerenga palaungana nem ke lape te helope hotote uneinei mur, pe te hemasmas ia hehei pe hana nga aria haleles mur. ");
INSERT INTO uvl_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","4","Pe Iesus nena hana mur analoch pe nai eria koi nemur: Simon (nenge ene e pule Petrus) Antreas (Simon tina) Ieims (ne Sepeti tuna) Ioanes (Ieims tina) Pilip Patolomius Tomas Mateus (nenge lololoch umtutuna.) Ieims (nenge Alpeus tuna) Tateus Simon (non nenge teke Israel mur iri siporia tenau ele iri) Iutas Iskariot (nenge tunge Iesus langa hana porekreke ngana mur peria) ");
INSERT INTO uvl_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Hana iri analoch pe nai nei, Iesus kulos hote iri pe hetoro tote iri ke mai, “Ala pe atu luluch nge hana lomonmona ngana mur ero. Pe pule ala nge iri nemur nge Samaria ero. ");
INSERT INTO uvl_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Ala manmana nge hehei pe hana nenge Israel iange iri te pomalaka nga sipsip mur nenge te erue toto lo. ");
INSERT INTO uvl_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Ala pe a haliu hote koi helenga nei, ‘NeHalang nena naualanga pe nekinga nenga tapa, ngana koi heroi lo.’ ");
INSERT INTO uvl_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Pe a hemasmas ia haleles kina mur, a hemaul heke mule iri nenge te metmete. Pe a helemlem mule iri nenge haleles poreke ngana ngau lala ke ngau hoa singiria pe a helope hotote uneinei mur. Kerkerenga nenge e tunge lange imo nei, a olia at nge iau ero. Pomalam, a la pe a poia lange iri pe a chepeia uruna ero pule. ");
INSERT INTO uvl_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Pe pule a in teua umtutuna unne e pe machmach unne e pe hake unne e nga amo melo matana ero toto. ");
INSERT INTO uvl_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Ai ia inga nei pe a takis kole ero pule. Pe a mene ke lemo hengeron nachnai ero pe apemo ana kalenga haka nachnai ero pule. Pe pule a ra hit heko ero. Iange ure nemur, non nenge umume uruna ia. ");
INSERT INTO uvl_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Nenge teke ateu langa kileng palaungana e, nem pe nga tuele kina sune, anau rara none nge na poinga urana pe pengpeng pe a la ke atu luluch nge i nga nena pele. Pe atu luluch nge i ke la het nga etue nenge a lo haka mule. ");
INSERT INTO uvl_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Ke nenge teke a i teu nga pele e, a hele ke a teke NeHalang pete imo. ");
INSERT INTO uvl_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Pe nenge teke iri nenga pele nem te iech ia lemo helenga, lemo helenga urana ngana nem lape tu luluch nge iri. Pe nenge teke ero, lemo petenga nem haka mule nge imo. ");
INSERT INTO uvl_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Pe nenge teke none longo lange imo ero pe mene imo langa nena pele ero, a pasis sue maruchrue nga apemo pe ai hot nga kileng nem. ");
INSERT INTO uvl_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","E hele ke manmanna toto lange imo. Nga NeHalang nena haliunga ana etue kileng nem lape mene tuangachol nge poreke toto nga nenge Sotom pe Komora.” ");
INSERT INTO uvl_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Iok, a longo at nge iau ke nek toto. E kulosia imo ke pomalaka nga mele nenge kulosia sipsip mur ke tela ke tetu teu luluch nge kaone hinolo mur. Pomalam letemo matana ke nek toto ke manga hilimo pe a nanas tau tote ngie chaulum nena poinga nenge tu ke neknek. ");
INSERT INTO uvl_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Pe anau ala amo ke nek toto nge hana mur. Iange lape te laua imo kela ames nga hana papalauna mataria pe pule lape te taklala teua imo langa hetoronga ana pele pe tepal hulu hite imo. ");
INSERT INTO uvl_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Pe te poia imo ke pomam iange lek hana mur imo. Ke lape te mene imo lange almasinga ana hana mur pe naunga ala mur. Pe lape a hele hote helenga urana toto ngana lange iri pe nge hana lomonmona ngana mur pule. ");
INSERT INTO uvl_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Pe nenge teke te laua imo, letemo song rara sakilil ero. Iange a hele ngamo nga ure nenge a heleleia lape ma ke mallaha hot mana nga letemo nga etue nem pengpeng. ");
INSERT INTO uvl_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Pe imo sipomo a hele ero, iange Tememo NeHalang opene lape hele hot nga halimo ol. ");
INSERT INTO uvl_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Non e lape tua hita mule tina ana pe te hune i ke mete. Pe none lape poia poinga nem lange tuna pule ke tua hita mule ana. Pe aina lape te pal hel luluch mule nge tetemeria mur pe tataria mur pe te hune iri ke te mete. ");
INSERT INTO uvl_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Hana lochloch lape lemeria ero ia imo iange Iau lek hana mur imo. Pe mele nenge mes ke kerkereng toto nga letena manmanna ngana, lape mene maulinga ke koko. ");
INSERT INTO uvl_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Nenge teke te poi poreke imo nga kileng e, a ua ke a langa kileng e pule. E hele ke manmanna toto lange imo koi. Imo lape a heulo hote amo ume nga kileng lochloch ngana nge Israel ero kura, pe Non Tuna lape at. ");
INSERT INTO uvl_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Mele nenge lala nga hengetoro kura, i muka mule nge ana hetoronga ero. I nanas tau mene ana hetoronga. Pe mele nenge umume nge none, i pule tamu tote ana ae huna ero. I longo la manmana nge ana ae huna. ");
INSERT INTO uvl_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Pe mele nenge lala nga hetoronga nem purpur pule nge lohot ke pomange ana hetoronga. Pe pule mele nenge umume nge none nem, purpur pule nge lohot ke pomange ana ae huna nem. Ke nenge teke te hetue non poreke ngana ene Pelsipul lange non soke e, lape te poia poinga nem ke palaungana toto lange non nem nena hana mur.” ");
INSERT INTO uvl_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Pe a mataua iri ero. Ure lochloch ngana nenge talkomkome lape lohot nga mallaha. Pe ure lochloch ngana nenge te hele komkome lape lohot ke hulua te eteia pule. ");
INSERT INTO uvl_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Utar nenge e heleia lange iong nga kileng au ngana, o hele hote nga sinanga. Pe utar nenge e mangun ia langa talngam, o mes haka ia nga pele ona pe o haliu hote. ");
INSERT INTO uvl_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","A matau heke mene hana nenge te hunun ero. Iri te hun mene singira pe te hune opere ero. A matau mene laka I nenge lape chacharuch heke singira pe opere nga oan nge henge lemlem. ");
INSERT INTO uvl_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Ngie kinkino ngana nai ururia haka toto ero. Pe te olia iri nga umtutuna elle mana. Pe nenge teke elle nge iri mete, Tememo eteia ke het lo. ");
INSERT INTO uvl_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Pe pule NeHalang amele palpalumo ina pe eteia iri ke het ta lo. ");
INSERT INTO uvl_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Ke a matau ero, iange imo a ele haka toto nga ngie nemur.” ");
INSERT INTO uvl_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Mele nenge mes haka nga hulua mataria pe hele hote letena manmanna ngana nge Iau, mele nem lohot ke lek non ia toto. Pe lape e heleia i lange Temek nga lut nga tapa. ");
INSERT INTO uvl_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Pe mele nenge hele ke teke eteia Iau ero nga hulua mataria, Iau lape e hele lange Temek nga lut nga tapa, ke e teke e eteia mele nem ero pule. ");
INSERT INTO uvl_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Imo a teke e at ke e hesue kilanga nge urana nga ich nei, ae? Ero nike. E at ia kakop nge matana kaliu ala i. Pe lape e heporeke lemo kilanga mur. ");
INSERT INTO uvl_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Lape e poia kol mele ke iri nai temene te hunel, pe he mele ke iri nai tana te hunel, pe heie ke iri nai na melei te hunel. ");
INSERT INTO uvl_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","“Lemo ngarang mur laka lemo hehei mur pe tutumo pe alomo mur pengpeng. ");
INSERT INTO uvl_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Imo nenge lememo tau tote tememo pe tamo ke te ele haka nge iau, imo lek hana mur ia imo ero. Pe imo nenge lememo tau tote tutumo mur ke te ele haka nge iau, imo lek hana mur ia imo ero. ");
INSERT INTO uvl_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Pe mele nenge lemene ero nge takis ia ana melmelenga pe nanas ia iau, lape e hile hote i ke pomalam pule. ");
INSERT INTO uvl_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Pe mele nenge teke tu ke maulul mana, lape mete pe lasus sapele. Pe mele nenge poia ak ume pe te hune i ke mete, lape maul haka mule pe tu ke maulul mana ol. ");
INSERT INTO uvl_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Mele nenge long ia iong, long ia Iau pule. Pe mele nenge long ia Iau, long ia I nenge kulosia Iau ke e at nei. ");
INSERT INTO uvl_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Mele nenge eteia nge none i hetatalonga pe long ia i, lape mene uruna nenge manga hetatalonga nem. Pe mele nenge eteia nge none i non nge pengpeng pe long ia i lape mene uruna nenge manga non nenge pengpeng toto. ");
INSERT INTO uvl_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","“Pe nenge teke mele eulia ech lololo ngana ke tunge lange hatong e nge umume nge iau, manmanna toto ke mele nem lape mene uruna.” ");
INSERT INTO uvl_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Iok, Iesus hetoro hite nena hana analoch pe nai neu ke het, pe lohaka sapele ke langa kileng nemur nge Kalelea. Pe nga lamau Iesus hetottore hehei pe hana pe haliu hote Helenga Urana Toto Ngana. ");
INSERT INTO uvl_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Pe Ioanes tu nga tuele au ngana pe longe Iesus pingana nge popoia ume nemur. Ol pe kulosia nena hana mur ke tela nge Iesus. ");
INSERT INTO uvl_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Pe te onteia I ke mai, “Iong nenge te heleleia nge o atat laka lom? Ma, lape mo kulele mele kau atat kura mau?” ");
INSERT INTO uvl_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Pe Iesus tuacholia lange iri ke teke, “Ala mule pe a hele lange Ioanes nga ure lochloch ngana nenge a longe pe a esia nga matamo ke ulolo. ");
INSERT INTO uvl_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Iri nenge mataria hit tenau mule lo pe iri nenge aperia mete te i mulmule lo. Pe iri nenge haleles poreke ngana tu nga singiria, singiria urana mule lo. Pe iri nenge talngaria hit te longo mulmule lo pe iri nenge te mete te maul haka mule lo. Pe iri nenge reria ure halang ero, te longlonge NeHalang na Helenga Urana Toto Ngana. ");
INSERT INTO uvl_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Hana nenge te longe lek helenga pe leteria manmanna ngana losio ero, lape te iech toto!” ");
INSERT INTO uvl_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Iok laol, Ioanes nena hana mur te i ke te lala pe Iesus talun ke heleia Ioanes lange hulua nenge te eukirau neu ke teke, “Nga etue nenge ai ke a la nga ich sana lomona, utar toto nenge a teke a la ke a esia? A teke a la ke a esia heilil ina e nge tuttula iua ke malau sio? ");
INSERT INTO uvl_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Eh, a teke a la ke a esia utar? Non e nge heronia heroninga urana ngana mur? Ero toto. Hana nenge te heronronia heroninga urana ngana mur, te tutu nga hana papalauna nenge iri Soksoke reria pele. ");
INSERT INTO uvl_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Ol pe a la lamau ke a teke a esia utar? A teke a la ke a esia hetatalonga e ae? Oe, non nem i hetatalonga pe i ele haka toto nge hetatalonga mur. ");
INSERT INTO uvl_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Iange nge non nei mana, NeHalang nena helenga nenge tehas sue ke ulolo, hele ke teke, “‘Lape e hekule lek none ke i muka nge iong pe i lape hepengpeng ia lem kue.’ ");
INSERT INTO uvl_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","“E hele ia helenga nei manmanna. Nge hulua lochloch ngana nenge te hoe iri ke te lohot nga ich, Ioanes nenge henunun i palaungana toto nge iri. Pe mele nenge i kino toto nga NeHalang nena naualanga pe nekinga, lape i palaungana toto nge Ioanes. ");
INSERT INTO uvl_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Talun nga Ioanes nenge henunun ana etue ke at heueu nei, NeHalang nena naualanga pe nekinga song ke pur kikina toto. Pe hana solaki ngana mur te ech taua ke te mene. ");
INSERT INTO uvl_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Iange hetatalonga mur pe NeHalang nena hotonga mur te haliu hotot nike ke at nga etue nenge Ioanes lohot ia. ");
INSERT INTO uvl_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ke nenge teke letemo manmanna nga helenga nemur, Ioanes i Elaisa nenge te teke lape at. ");
INSERT INTO uvl_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Imo nenge a longlonge iau, a longo ke neknek. ");
INSERT INTO uvl_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Lape e heilangia hehei pe hana nga etue nei ke pomere? Iri te pomalaka nge aina kinkino ngana nemur nenge te kilkila nga ingala matana pe te alngaria lala nge pekngaria mur ke te teke, ");
INSERT INTO uvl_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“‘Mo iuiua emem iu pe imo mam a hes ero ia? Pe mo utute utunga lolo pe a tang ero ia?’ ");
INSERT INTO uvl_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","“Ioanes at pe ngau ero pe in ech ero. Pe te hele ke te teke, ‘Non nei, uneinei ia i.’ ");
INSERT INTO uvl_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Pe Non Tuna, at pe ngaungau pe inin ech. Pe te heleia i ke te teke, ‘A nau la pam, non neu ngau ngana pe in ngana kou kura. Pe pekngana mur toto laka hana nenge te lololoch umtutuna pe hana porekreke ngana mur.’ Pe ure nemur nenge te lohotot nem, te lohot urume mene NeHalang letena matana ngana.” ");
INSERT INTO uvl_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Iok, nga kileng hel, Iesus poi hote ure nenge hele pe lohot manmana ke halang, pe hulua te hulia leteria ero. Pomalam Iesus hele ke kerkereng toto lange iri ke teke, ");
INSERT INTO uvl_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Imo nenge Korasin pe Petsaita a neknek ia imo. Iange e poi hote ure nemur ke a esia nga lamai pe a hulia letemo ero toto. Pe toinge e poi hote ure nemur nga kileng nenge Tir pe Saiton, hehei pe hana nga lamau lape te hulia leteria ke het lo. Pe toinge ngana kou te heron heke hengeron muna hulu ngana, pe te hepore heke kasu nge iri pe teare nga oan ina lo. Ke poinga nem henonou hote iri nge te hulia reria poinga mur lo. ");
INSERT INTO uvl_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","E hele lange imo Korasin pe Petsaita, nga NeHalang nena haliunga ana etue, imo lape a mene tuacholinga nge poreke toto nge Tir pe Saiton mur. ");
INSERT INTO uvl_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Pe imo nenge Kapernam lape ala ke merei? A haka langa lut nga tapa? E hele lange imo, lape ateu sio la pengpeng nga oan nge henge lemlem. Toinge e poia ure nemur ke te lohot nga kileng nenge Sotom nike, hehei pe hana lape te hulia leteria ke ueiuei mana. Pe kileng nem lape tu ke urana kura ke at nga etue nenge nei. ");
INSERT INTO uvl_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Pe e hele lange imo Kapernam, nga NeHalang nena haliunga ana etue, imo lape a mene tuangachol e nge poreke toto nge nenge Sotom.” ");
INSERT INTO uvl_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Ke het pe Iesus hele sapele ke teke, “Temek! E heto heke tote Iong. Iong Non nge Iong Soke toto nga lut nga tapa pe nga ich. Iange o hekome tote ure nei lange hana nenge te etei ngaria palaungana toto pe o etei hot mene lange hana nenge te etei sakilil ero ke mange aina kinkino ngana. ");
INSERT INTO uvl_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Oe Temek, Iong o iech nge lohot ke pomam nike. ");
INSERT INTO uvl_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","“Temek tung sue ure lochloch ngana at nga perik ke e nauele iri. Pe mele pele eteia Tuna ero. Temene I toro mana eteia Tuna. Pe mele pele eteia Temene ero. Tuna i toro mana eteia Temene. Pe iri nenge Tuna hetore iri lange Temene, iri toro mana te eteia Temene. ");
INSERT INTO uvl_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Imo nenge a takisia ure meena ngana pe kikimo ero ol, ai at nge iau pe a amneia ure meena ngana e ero ol. ");
INSERT INTO uvl_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","A longo taua iau pe a mene hengetoro nge iau iange e poi ke nek toto pe e tal sio tote Iau. Ke nenge teke a longo taua iau lape atah eingamo. ");
INSERT INTO uvl_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Iange hengetoro nenge e tunge lala nge imo nem polpolenga mana.” ");
INSERT INTO uvl_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Iok laol, nga Sapat ana etue, Iesus pe nena hana mur te i teu nga ume e letena. Ume neu tetue ana uit mur mana. Ol pe Iesus nena hana mur te mete aria pe te sohe uit nganangana hel ke te ngaua. ");
INSERT INTO uvl_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Ol pe Paresio mur te esia pe te hele lange Iesus ke te teke, “O nau langa lem hana mur te poi ngaria pam! Pomere nenge te nanasia hotonga nenga Israel mur aria etue nenge te hetalaulau ia ero?” ");
INSERT INTO uvl_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Pe Iesus tuacholia ke teke, “Nananga e nge nike hele ia non soke Teuit pe pekngana mur nge te mete aria. Pe imo mam a sisia nananga nei ero mana kura kai? ");
INSERT INTO uvl_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Ana non i teu langa NeHalang nena pele pe mene ngaunga nenge heo ngana ke pekngana mur te ngaua. Pe ngaunga nem heo ngana toto nge non pulut ngana e mana ngaua. Iange hotonga hele ke teke tunginga ana hana mur, iri toro mana te ngaua ngaunga nem. ");
INSERT INTO uvl_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Pe pule hotonga e nge Moses hasia hele ke teke, tunginga ana hana mur te umume nga NeHalang na pele nga Sapat ana etue. Te longo ole taua hotonga pe mele pele hele ia iri ero. ");
INSERT INTO uvl_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Pe e hele lange imo, mele nenge mes heueu nei, i palaungana toto nga NeHalang na pele palaungana nem. ");
INSERT INTO uvl_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","NeHalang nena helenga nenge tehas sue ke ulolo, hele ke teke, ‘Lemek ero ia lemo tunginga pa nemur nenge a makmak huros. Lemek ke letemo ia hehei pe hana.’ Toinge a eteia helenga nem luna ke nek, toi ngana koi a henonou perimo lange iri nenge te poia ute ke poreke ero. ");
INSERT INTO uvl_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Iange Non Tuna, I non Soke toto nga Sapat ana etue.” ");
INSERT INTO uvl_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Iok, Iesus i nga lamau pe la ke i teu nga hengetoro ana pele. ");
INSERT INTO uvl_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Pe none nge penna mete tu nga lamau pule. Pe mele hel te tango rara kue nenge te teke te laulaua Iesus. Pomalam te poi haka pulut mana ure huhuna mur pe te onteia I ke te teke, “Hotonga mai hele ke teke iri nenge singiria haleles, lape te hemas mule iri nga Sapat ana etue pule kai? Ae?” ");
INSERT INTO uvl_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Pe Iesus hele lange iri ke teke, “Nenge teke amo e na sipsip losio teu nga polo nga Israel mur aria etue nenge te hetalaulau ia, mele nem lape poia ke mere? E hele lange imo, heueu mana nei mele nem in haka hot mule nena sipsip nem. ");
INSERT INTO uvl_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Iok, anau langa ure nai nei, sipsip mur pe ita non. Tei nge iri nai nge NeHalang esia ke ure palaungana toto nga matana? Ure nenge palaugnana toto nga NeHalang matana, ngana koi ita non. Ke pomalam, i pengpeng nge ta halaua mele nga Sapat ana etue.” ");
INSERT INTO uvl_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Ol pe Iesus hele sapele lange non neu, “O tul hote perim.” Iok, non neu tul hote penna pe penna urana mule sapele ke pomanga penna nenga hele. ");
INSERT INTO uvl_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Pe ero, Paresio mur tehot lange hot pe tetal helenga ke te teke te hune Iesus. ");
INSERT INTO uvl_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Pe Iesus eteia lo. Ke pomalam lohaka nga kileng neu pe hulua te kumnana nge i ke hemasmasia haleles kina mur lochloch nga aria haleles mur. ");
INSERT INTO uvl_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Pe heo ele tote iri nge te hele hot rere lange mele hel. ");
INSERT INTO uvl_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Pe ure nei lohot ke pete tote NeHalang nena helenga nenge hetatalonga Isaias hele hote nge nike nenge teke, ");
INSERT INTO uvl_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Nenge nei, Iau lek non toto nge E henonou hote. Iau lemek tau tote I pe E iech toto nge I. Pe lape etal heke opek nge I, ke lape haliu hote lek poinga nenge e hemasmas lange mata mur nga kileng lochloch ngana. ");
INSERT INTO uvl_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Pe I lape hele ia letena inin ngana ero pe alngana rara ero. Pe lape te longe I nge haliu rara nga kue tana ero pule. ");
INSERT INTO uvl_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Pe lape hekerkereng mule iri nenge leteria manmanna ngana unne sune mana ol, ke te kerkereng mule. Pe lemenge nenge ngau ke unne sune mana, i hemete sapele ero. Teke poia poinga urana ngana nei, ke ris tote poinga lochloch pe mes hot ke mallaha toto. ");
INSERT INTO uvl_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Pe mata lochloch ngana nenga kileng lochloch lape leteria kerkereng mana nge lape te mene maulinga nga I toro mana ene.” ");
INSERT INTO uvl_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Ol pe hana hel, teat ia none nge matana hit pe hele erochro iange uneinei tu nge i. Te laia i ke Iesus hemas mule i. Ke het pe ana non matana charchara ke nau mule ke nek pe hele mule sapele. ");
INSERT INTO uvl_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Ol pe hulua te esia pe leteria tuanin ke halang pe te hele, “Non nei nge lape ne Teuit tuna i.” ");
INSERT INTO uvl_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Pe Paresio mur te longe pe te hele, “Ero iam! Uneinei mur aria soke Pelsipul laka hekerkereng ia non nem ke helope hotote uneinei mur.” ");
INSERT INTO uvl_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Pe Iesus eteia leteria tuanin ngana mur lo, pomalam hele lange iri ke teke, “Nenge teke hana mur nga tuele kina e te chach hel pe hunelinga lohot, kileng nem lape het sio sapele. Ke nenge teke hana nemur nga kileng nem te chach hel pe te ua rara, reria kileng nem lape tu ero ol. Pomalam mana nge none pe nehei pe tutuna mur. Nenge teke te chach hel pe te ua rara lape tetu ke muria elle mule ero ol. ");
INSERT INTO uvl_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Pe nenge teke non poreke ngana helope hot mule i sipona, ta etei mellehe mene ke non poreke ngana nena hana mur, te het sio sapele iange huria ero ol. ");
INSERT INTO uvl_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","“Imo a teke e helope hotote uneinei mur nga Pelsipul ene, pe lemo hana mur te popoia ume nem pule. Pe te popoia nga itei toto ene? Ke imo anau, lemo hana mur pengpeng lape te hele hot mule amo. ");
INSERT INTO uvl_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Nenge teke NeHalang opene hekerkereng ia iau, ke e helope hotote uneinei nemur, NeHalang nena naualanga pe nekinga at nge imo lo. ");
INSERT INTO uvl_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Amo non tei nakuna toto nge tale chachia non solaki ngana e na pele ke loloch hote nena ure mur? Nenge teke o poi ke pomam o nanasia koi kue nei. O kale hit tele non nem. Ke het pe o teu nga nena pele ke o loloch hote nena ure mur. ");
INSERT INTO uvl_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Mele nenge ma at nge iau ero, lek ngarang toto laka i. Pe mele nenge ume luluch nge iau ero, lape sisparai ia lek ume. ");
INSERT INTO uvl_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Pe e hele lange imo, NeHalang lape letena ia imo nga lemo poinga poreke ngana mur, pe lemo helenga porekreke ngana mur lochloch. Pe mele nenge hele poreke Opepengpeng, mele nem lape mene poreke tote. ");
INSERT INTO uvl_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Pe mele nenge hele poreke Non Tuna, lape NeHalang letena ia i. Pe mele nenge hele poreke Opepengpeng, mele nem lape NeHalang letena ia i ero toto, nga etue nei pe nga hoena pule. ");
INSERT INTO uvl_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Nenge teke o poia ae e ke urana, nganangana lape hot ke urana. Pe nenge teke o poi poreke ae e, nganangana lape hot ke poreke. Iange tanau urume ae elle pe elle nga nganangana mur. ");
INSERT INTO uvl_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Ilimo alete nemur! Imo hana porekreke ngana mur pa ne mam. Ol pe a teke a heleia ure nge urana ke mere? Iange lape halimo hele hot mene laka ure poreke ngana nemur nenge tu teu nga letemo nem lo. ");
INSERT INTO uvl_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Hana nenge leteria urana, te hele hotote ure urana ngana mur nenge tu teu nga leteria. Pe hana porekreke ngana mur, ure poreke ngana halang tu teu nga leteria, pomalam lape te hele hot menmene ure poreke ngana mur. ");
INSERT INTO uvl_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Pe e hele lange imo, NeHalang nena haliunga ana etue nem lape at, pe lape mele elle pe elle na poinga mur lape hele hot mule ana. ");
INSERT INTO uvl_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Lem helenga mur lape te hele hote iong. Nenge teke te urana, lape o urana nga NeHalang matana. Pe nenge lem helenga mur te poreke, lape o poreke nga NeHalang matana.” ");
INSERT INTO uvl_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Ol pe Paresio mur hel pe hotonga ana hetoronga mur te hele lange Iesus ke te teke, “Hetoronga, o hele pe ute lohot mana ke mo nau mukam.” ");
INSERT INTO uvl_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Pe Iesus tuacholia ke teke, “Imo hehei pe hana nga etue nei, a muta nga poinga poreke ngana mur pe letemo manmanna ngana tu hite NeHalang ero toto. Ol pe a ontei ke a teke a esia utar? Lape e poi hote ute pele ke a esia ero toto. Lape e hemallaha hot mene laka hengeilang nenge hetatalonga Iona lange imo. ");
INSERT INTO uvl_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Nge nike toto, ruo palaungana tone Iona. Pe Iona ma ke ana etue iri mol nga ruo nem letena. Ke pomalam mana, Non Tuna lape ma ke ana etue iri mol nga ich letena pule. ");
INSERT INTO uvl_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Pe lape etue palaungana nem at pe iri nenge Niniue lape te hele ia imo hehei pe hana nenga etue nei. Iange iri te hulia reria poinga mur nga etue nenge Iona haliu hot. Pe mele nenge i palaungana toto nge Iona, ngana koi helele heueu nei, pe pomere a hulia letemo ero? ");
INSERT INTO uvl_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Nga NeHalang ana etue nem pule, lape Hei Soke nem nenge nauele kileng Sipa lape heleia imo. Iange i lo haka nga na kileng pe la ke longo nga Non Solomon Palau nena helenga urana ngana mur. Pe mele nenge I palaungana toto nge ne Solomon, ngana koi helele heueu nei. Pe pomere a longo langa nena helenga mur ero?” ");
INSERT INTO uvl_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Nenge teke uneinei e lohot nge none, song sapele ke langa kileng nenge ana ech ero pe tango rara munna nge tuia. Pe lape hottaua munna e nge tuia ero. ");
INSERT INTO uvl_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Pe lape helele nge i sipona ke teke, ‘E ua hot nga lamau ke e at pe mullik ero nga lamai i. Lape e la mule nga lek pele iam.’ Iok laol, uneinei nem at mule pe esia na pele nge tu ke polpolo mana. Pe pele neu letena te sachalue ke lemlem, pe ure mur nga letena te talue ke tema ke nek toto. ");
INSERT INTO uvl_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Ol pe ana ure la mule pe la mene ke uneinei iri rahtele nai ke iri ul teat ke la tetu nga pele neu. Pe uneinei nemur nenge iri rahtele nai neu, te poreke toto nga uneinei elle nenge mene iri at. Pe non neu, tu ngana nga tele ngana urana pol, pe nei ol, tu ngana poreke toto ol. Ke hehei pe hana poreke ngana mur nga etue nei, tetu ngaria lape pomalam mana.” ");
INSERT INTO uvl_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Iok, Iesus hele lala nge hehei pe hana kura, pe tana pe titina mur teat ke te mes nge hot. Iri te teke te hele luluch nge Iesus. ");
INSERT INTO uvl_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Ol pe mele hele lange Iesus ke teke, “Tam pe titim mur kou te mes nge hot, pe te teke te hele luluch nge iong.” ");
INSERT INTO uvl_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Pe Iesus hele, “Iau mai hetak itei pe titik mur itei hel?” ");
INSERT INTO uvl_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Ol pe Iesus henonoua nena hana mur pe hele, “Hetak pe titik mur koi nemur. ");
INSERT INTO uvl_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Temek tu nga lut nga tapa, pe mele hel nenge te poia ume ke nanasia Temek lemene ngana, ke lohot nga ich nei, iau titik mur pe liliuk mur pe hatak mur ia iri.” ");
INSERT INTO uvl_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Iok, Iesus iuch hot nga pele nga etue neu pe la ke are nga kolkolu palaungana nenge Kalelea ilina. ");
INSERT INTO uvl_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Pe hulua tela ke te maimai ite i. Pomalam, lo haka ke are nga aka e pe mana hita nge hot. Pe hulua nemur te mes nga peipei ilina. ");
INSERT INTO uvl_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Ol pe Iesus nenene ure halang lala nge iri nga helenga opene mur. Iesus nanana ke teke, “A longo at, none lake sausaua ngaunga alona nga ana ume. ");
INSERT INTO uvl_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Sausaua iri pe hel te losio hot langa alingele pe ngie mur teat ke te tuais haka taua ke het. ");
INSERT INTO uvl_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Pe hel te losio teu langa um letentena nenge ana ich halang ero pe te haka ke ueiuei mana iange ich unne sune mana. ");
INSERT INTO uvl_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Iok, chaia matana haka ke sine iri pe te melu sapele iange ularia teu sio ero mana. ");
INSERT INTO uvl_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Pe ngaunga alona hel te losio teu nga kiki letentena. Pe kiki nem haka ke au hite pe makia iri ke te mete. ");
INSERT INTO uvl_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Pe ngaunga alona hel te losio haka nga ich nenge urana pe te haka ke nek pe te hei pe nganangaria sapele. Hel nganangaria mur iri ana non kina iri lime (100) pe hel nganangaria iri ana non kina mol (60) pe hel nganangaria iri ana non elle pe analoch (30). ");
INSERT INTO uvl_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Imo nenge a longo atat nge Iau, a longo ke neknek.” ");
INSERT INTO uvl_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Iok, Iesus nena hana mur tela nge i pe te ontei hote ke te teke, “Pomere nenge o hetore hehei pe hana nga helenga opene mur?” ");
INSERT INTO uvl_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Pe Iesus tuacholia lange iri ke teke, “Heteinga nga ure talkomkome ngana mur nga NeHalang nena naualanga pe nekinga nga tapa, imo a mene lo. Pe iri ero kura. ");
INSERT INTO uvl_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Mele hel nenge te etei lo lape te etei ke halang toto mule. Pe mele hel nenge te etei ke nek ero kura, te etei ngaria unne sune nem lape te ua toto mule ia nge iri. ");
INSERT INTO uvl_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Ke ngana laka nenge e nana manmana nga helenga opene lala nge iri: “Mataria charchara ke te nachnau pe te esia ute e ero. Pe talngaria longlongo pe te longe ute e ero pe te eteia ute e ero pule.” ");
INSERT INTO uvl_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Pe hehei pe hana te poi ngaria nei, pete tote helenga e nge hetatalonga Isaias hele hote nge nike ke teke, “‘Imo lape a longlongo pe a eteia luna e ero toto. Pe a nachnau pe a esia ute e ero toto. ");
INSERT INTO uvl_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Iange iri leteria hit toto lo, pe anali pule nge te longe ute e nga talngaria ol. Pe pule te poi hele mataria ke hit lo. Pe toinge ero, heueu nei te nachnau nga mataria pe te longlongo nga talngaria. Pe leteria matana ke te hulia reria poinga mur, pe teat ke e hemas mule iri. Pe nei ero.’ ");
INSERT INTO uvl_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Pe imo nenge a esia ure nga matamo pe a longe helenga nga talngamo a iech toto. ");
INSERT INTO uvl_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","E hele ke manmanna toto lange imo, hetatalonga mur pe NeHalang nena hana mur muteria toto ke te teke tenau nga ure nenge imo a esia nem. Pe ero, iri te kolkol toto. Pe pule te teke te longo nga ure nenge imo a longe nem. Pe ero, iri te longe ero toto. ");
INSERT INTO uvl_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Iok, a longo ke nek toto ol nga helenga opene nenge ngaunga alona nem luna. ");
INSERT INTO uvl_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Ngaunga alona nenge losio hot langa alingele nem, pomalaka nga mele nenge longe Helenga Urana Toto Ngana nga NeHalang nena naualanga pe nekinga pe eteia luna ke nek ero. Pe non poreke ngana at ke ua toto mule ia helenga nem nenge tu nga mele nem letena. Ke ngaunga alona nenge losio hot nga kue nem luna la nem. ");
INSERT INTO uvl_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Pe nenge te losio teu nga um letentena, ngana laka mele nenge mene sapele NeHalang nena helenga pe iech ele tote. ");
INSERT INTO uvl_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Pe mene helenga nem ke langa letena nge teu toto ero. Pe ra hite ke choro mana iange helenga nem ulana au ero. Pe nenge teke helenga nem lohot ia totoinga pe ure meena ngana, mele nem letena manmanna ngana losio ke ueiuei mana. ");
INSERT INTO uvl_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Pe ngaunga alona nenge te losio teu nga kiki letentena, pomalaka nga mele nenge longe Helenga Urana Toto Ngana lo, pe letena tu ke kerkereng toto nga ure lochloch ngana nenga ich. Nga nenge teke na umtutuna halang toto pe ure. Pe Helenga Urana Toto Ngana nem, haka pe nganangana ero iange ure nemur te poi hele mene. ");
INSERT INTO uvl_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Pe ngaunga alona nenge te losio haka nga ich nge urana, pomalaka nga mele nenge longe Helenga Urana Toto Ngana nem, pe eteia luna ke nek toto. Ke nganangana mur iri ana non kina iri lime (100), pe hel ana non kina mol (60) pe hel ana non kina elle pe analoch (30).” ");
INSERT INTO uvl_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Iok, Iesus heleia helenga opene e pule lange iri ke teke, “NeHalang nena naualanga pe nekinga nga tapa, pomalaka nga none nge tue ngaunga alona urana ngana mur nga ana ume. ");
INSERT INTO uvl_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Pe nga miliko hulua lochloch ngana te mamani, pe non nem na ngarang mur teat ke te tua teua heilil poreke ngana alona mur nga ume neu. Te tue iri ke het pe te ua sapele. ");
INSERT INTO uvl_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Iok, ngaunga alona nemur te talun ke te hei pe heilil poreke ngana nemur te haka pule. ");
INSERT INTO uvl_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","“Iok laol, non neu nena hana mur nenge te umume nge i, tela nge i pe te onteia i ke teke, ‘Non soke, ngaunga urana ngana alona mur mana kai nenge otue iri nga ume mai? Pe heilil poreke ngana nemur mai teat ke merei?’ ");
INSERT INTO uvl_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","“Pe non neu tuacholia ke teke, ‘Lape lek ngarang e laka tua teua heilil poreke ngana nemur.’ “Pe nena hana mur te ontei mule i, ‘Ke pomere? Lemem ke o teke mo la ke mo lalau hote iri?’ ");
INSERT INTO uvl_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","“Pe non neu hele, ‘Ero, iange ngaunga alona mur te haka lo. Lape a tak haka leke iri heueu. ");
INSERT INTO uvl_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Tetu ke te haka luluch mana mukam, ke la het nga etue nenge ngaunga te mera. Nga etue nem pengpeng lape e hele lange lulunga ana hana mur ke te lalau tele heilil poreke ngana nemur pe te kale pute iri pe la te chacharuch heke nga oan. Ke het pe te lule ngaunga mur pe te tatach teua iri langa ngaunga ana pele.’” ");
INSERT INTO uvl_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Iok, Iesus heleia helenga opene e pule lange iri ke teke, “NeHalang nena naualanga pe nekinga nga tapa, nakuna pomalaka nga ae nganngana e nge tuna mana. Pe ae nganngana nem, none mene ke tue nga ana ume. ");
INSERT INTO uvl_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","I nganangana tuna mana pe haka ngana, ris tote ae mur lochloch pe tana palaungana toto. Pomalam ngie mur nga lut tela ke te ole teu nge i, ke tetal kiniu pe te arare nga perperna mur.” ");
INSERT INTO uvl_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Pe Iesus hele hote helenga opene e pule ke teke, “NeHalang nena naualanga pe nekinga nakuna pomai pule. Pomalaka nga ure tutuna nenge heie mene pe poi teu luluche nga beret itach ngana. Pe ure nem poia beret ke una haka.” ");
INSERT INTO uvl_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Iesus heleia ure lochloch ngana lange hehei pe hana nga helenga opene mur mana. Utar nenge heleia, heleia nga helenga opene mana. ");
INSERT INTO uvl_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Pe poinga nenge poia nem, pete tote utar nenge hetatalonga e hele hote nge nike lo, nenge hele ke teke, “Lape e hele mana nga helenga opene mur mana. Pe lape e hele hote ure nemur nenge tetu ke te talkome, nga NeHalang ala hot ngana ia tapa pe ich ke at heueu nei.” ");
INSERT INTO uvl_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Iok, Iesus hele ke het pe la sapele ke i teu nga pele e. Ol pe nena hana mur tela nge i pe te hele, “O hele hote helenga opene nei luna at nge imem. Helenga opene nenga heilil poreke ngana nenge te haka nga ume.” ");
INSERT INTO uvl_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Ol pe Iesus hele, “Non Tuna laka nenge I mele nenge tue ngaunga alona urana ngana mur nga ume nem. ");
INSERT INTO uvl_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Pe ich nei, i ume nem. Pe ngaunga alona urana ngana nemur laka NeHalang tutuna mur, nenge tetu teu nga nena naualanga pe nekinga. Pe heilil poreke ngana mur laka, non poreke ngana nena hana mur. ");
INSERT INTO uvl_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Pe ngarang nenge tua sue heilil poreke ngana nemur, ngana laka Satan i sipona lo. Pe ngaunga mera ngana pe lulunga ana etue laka, etue nenga ich nei hetala toto ngana. Pe lulunga ana non mur laka NeHalang nena angkelo mur. ");
INSERT INTO uvl_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","“Ke nga ich nei hetala toto ngana, lape poi ke pomalaka nga te leke heilil nemur pe tesau heke iri langa oan. ");
INSERT INTO uvl_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Ke pomalam mana, nga NeHalang nena naualanga pe nekinga. Non Tuna lape kulos hote nena angkelo mur ke tesau hote iri lochloch ngana nenge te heporekreke hehei pe hana leteria manmanna ngana mur. Pe iri lochloch ngana nenge te popoia poinga poreke ngana mur, lape tesau hot luluche iri pule. ");
INSERT INTO uvl_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Ke lape tesau heke iri ke la te tangtang pe ngingiria chatrekreke la kou nga oan sapel lala ngana. ");
INSERT INTO uvl_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Pe NeHalang nena hana mur, lape singiria tua ke pomanga chaia matana nga Temeria nena naualanga pe nekinga. Imo nenge a longo atat nge Iau, a pal talngamo pe a longo ke nek! ");
INSERT INTO uvl_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Iok, NeHalang nena naualanga pe nekinga pomai koi pule. Pomalaka nga umtutuna putana e nge mele alo hit kome nga ich unne. Pe none hottaua pe iech ala toto i ia. Ol pe alo hit kome mule ke nek. Non neu letena iech toto pe la ke mene nena ure mur lochloch, pe la ia ke hehei pe hana te olia iri. Ke het, mene umtutuna neu, pe la ke ol hot mule ich unne nenge alo hit kome umtutuna putana neu ia, ke nena ich neu ol. ");
INSERT INTO uvl_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Pe pule NeHalang nena naualanga pe nekinga pomalaka nga none nge tango rerere holonga nenge uruna haka toto. ");
INSERT INTO uvl_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Iok laol, ana non hottaua pe la sapele ke mene nena ure mur lochloch, pe la ia ke hehei pe hana te olia. Ke het pe mene umtutuna neu pe la ke ol hote holonga neu. ");
INSERT INTO uvl_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Pe pule NeHalang nena naualanga pe nekinga pomalaka nga hoat nenge te hesue nga kolkolu palaungana pe ruo lochloch nenga mata pe mata te haia. ");
INSERT INTO uvl_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Hoat nem muta pe iri nenge te olole ruo nem, tetak heke sapele langa peipei, pe te kila sio sapele ia ruo eu hot ngana. Pe te loloch mene ruo urana ngana mur mana. Pe nenge te poreke tesaua iri ke te lasus. ");
INSERT INTO uvl_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Ke poinga nei lape lohot nga etue nenga ich nei hetala toto ngana. Angkelo mur lape teat ke te eukiraua hehei pe hana nenge te urana ke te mes ke kuena, pe porekreke ngana mur te mes ke kueria. ");
INSERT INTO uvl_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Pe lape tesau heke porekreke ngana nemur ke la te tangtang pe ngingiria chatrekreke nga oan sapel lala ngana.” ");
INSERT INTO uvl_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Pe Iesus onteia iri, “A eteia helenga nemur luria lo?” Pe iri te hele, “Oe mo eteia lo.” ");
INSERT INTO uvl_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ol pe Iesus hele mule lange iri, “Pomalam mana hotonga ana hetoronga mur nenge e hetore nga NeHalang nena naualanga pe nekinga, te pomalaka nga tokoninga nenga pele palaungana e. Ana non teu langa pele nenge tattalue ure urana ngana mur ia, pe mene hote ure heueu ngana pe nike ngana mur ke hot lochloch.” ");
INSERT INTO uvl_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Iok, Iesus hele hote helenga opene nemur ke het pe lo haka sapele nga kileng neu. ");
INSERT INTO uvl_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Pe i ke la mule nga nena kileng huna. La pe hetottore hehei pe hana nga reria hengetoro ana pele. Pe hehei pe hana leteria au ala pe leteria tuanin ke halang. Pe te ontei ke te teke, “Non nei mai mene letena matana ngana nei langai toto? Pe na kerkerenga nenge hele pe urelu te lohot manmana mai mene langai pule? ");
INSERT INTO uvl_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Non nei, non nenge hemesmes pele tuna koi. Pe tana ene laka he Maria. Pe titina mur laka Ieims pe Iosep pe Simon pe Iutas. ");
INSERT INTO uvl_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Pe liliuna mur pai, ita ul ke ta tutu panei. Pe I mai mene ure nemur langai toto?” ");
INSERT INTO uvl_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ol pe saria keke Iesus sapele. Pe Iesus hele lange iri ke teke, “Hetatalonga e pingana iuiu nga kileng pe kileng. Pe nga nena kileng huna pe nga na pele pengpeng, pingana unne hota ero toto.” ");
INSERT INTO uvl_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Hehei pe hana nga kileng neu leteria manmanna ero. Pomalam Iesus poi hote ure halang ero. ");
INSERT INTO uvl_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Nga etue neu ne Herot nauele kileng nenge Kalelea. Ana non longe Iesus pingana, ");
INSERT INTO uvl_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","pe hele lange hana nenge te umume nge i ke teke, “Ioanes nenge henunun laka nenge pingana sasasa nem. Ana non mete ke ulolo pe maul haka mule. Ke ngana laka nenge hele pe urelu te lohot manmana.” ");
INSERT INTO uvl_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Ne Herot hele ke mau iange nga tele ngana, laua Ioanes pe hele ke te kale penna pe tetal teua i langa tuele au ngana. Ne Herot poia poinga nei lange i iange Ioanes heleia i nge tak tote tina ne Pilipus nehei Herotias. ");
INSERT INTO uvl_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Ke Ioanes heleia ne Herot ke teke, “O nanasia hotonga tei toto nenge o poia poinga nem lange tim nehei?” ");
INSERT INTO uvl_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Ke nga helenga neu mana, ana non teke hune Ioanes. Pe ne Herot matau nena pule iange hulua te teke Ioanes i hetatalonga. ");
INSERT INTO uvl_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Pe nga etue nenge te eukirau ke te iech ia etue nenge ne Herot tana hoho ngana ia I, Herotias tuna heingana heses ke ne Herot pe nena lang mur te nachnau. Pe ne Herot esia he neu nge heses pe iech toto. ");
INSERT INTO uvl_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Pomalam ne Herot hele ke manmanna pe hele ke kerkereng toto ke teke, nenge teke he neu lemene taua ute e nge i, lape tung hot mene ke lange he neu. ");
INSERT INTO uvl_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Ol pe Herotias hele la sapele nge tuna heingana neu nga utar nenge lape onteia lange ne Herot. Ol pe he neu hele, “E teke otal heke Ioanes nenge henunun palpalna nga kaliu nei pe o mene at nge iau.” ");
INSERT INTO uvl_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Ne Herot longe helenga neu pe singina matau toto. Ol pe lape hele ke merei ol? Ngana paiau tamal hote helenga kerkereng ngana ke nena lang mur te longe mau lou. ");
INSERT INTO uvl_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Ol pe ne Herot hele sapele ke te chat hoa Ioanes kanna nga tuele au ngana ");
INSERT INTO uvl_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","pe tetal heke palpalna nga kaliu pe te mene lange he neu. Pe he neu mene pe laia nge tana. ");
INSERT INTO uvl_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Pe Ioanes nena hana mur tela ke te mene koluna ke la te alo hite. Ke het pe tela sapele ke la te hele toto Iesus nena. ");
INSERT INTO uvl_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Iok, Iesus longo hatal nena nga ure nenge lohot nge Ioanes ke ulolo. Ol pe lohaka kun mana nga sulang e ke la tu ke I toro mana nga kileng e nge tu loulou mana. Pe hulua te longo rusia pe te lohaka nga reria kileng mur pe te i nga ich ke te nanasia I ke tela. ");
INSERT INTO uvl_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Pe Iesus mana sio langa peipei pe esia hulua nge te eukirau, pe letena ia iri. Pomalam hemasia iri nenge singiria haleles. ");
INSERT INTO uvl_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Pe kileng lala ke ulei sisio lo, ol pe Iesus nena hana mur tela nge I pe te hele, “Teke poi pe o kulosia hulua nei ke tela nga tuele tana nemur ke te ol aria ngaunga mukam. Iange mele hel tetu nga lamai ero koi. Kileng unne nei, tu loulou mana pe kileng ulei sisio lokoi.” ");
INSERT INTO uvl_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Ol pe Iesus tuacholia lange nena hana mur ke teke, “Iri lape tetu lakoloi, pe imo a tango ngaunga ke a hengaua iri.” ");
INSERT INTO uvl_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Pe iri te hele, “Ero! Iange mioka iri lime pe ruo nai mana i tema mai.” ");
INSERT INTO uvl_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Pe Iesus hele, “Iok, a mene iri at nge Iau.” ");
INSERT INTO uvl_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Pe pule Iesus hele lange hehei pe hana ke te kila sio nga heilil. Ol pe Iesus mene mioka nemur pe ruo nai neu pe nau haka langa lut nga tapa, pe hele urana toto pe reke iri. Ke het pe tunge lange nena hana mur. Pe nena hana mur te heronge nge hehei pe hana. ");
INSERT INTO uvl_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Iri lochloch te ngau pe te ngau ke saria una toto. Pe Iesus nena hana mur te takirau mule ngaunga aluanuana mur. Pe chasang iri analoch pe nai, te muta mule ia ngaunga aluanuana nemur. ");
INSERT INTO uvl_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Iri nenge te ngaua ngaunga neu, te am ele iri pe te lohot ke hana iri 5000. Pe tesis hele hehei pe aina kinkino ngana ero. ");
INSERT INTO uvl_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Iok, Iesus poia nena hana mur ke te lohaka nga sulang ke iri muka tele langa hele. Ke het pe kulos sapele hulua nemur ke tela ol. ");
INSERT INTO uvl_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Ke het pe I toro mana i haka langa hengene ilina ke hetalaulau, pe tutu ke la ulei sio. ");
INSERT INTO uvl_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Pe sulang nenge nena hana mur te haka ia kou manmana nga leme tunangana unne lo. Pe ruach tamal ia iri ke sio pe haka iange kileng eingana heke. ");
INSERT INTO uvl_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Pe nga uachuach Iesus i ke nanas hote iri, pe i haka mana nga ruach ona. ");
INSERT INTO uvl_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Pe nena hana mur te esia i pe te matau toto pe te u haka iange te teke ma moiuk. ");
INSERT INTO uvl_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Pe ueiuei mana Iesus hele ele iri ke teke, “Samo loiloi pe a matau ero. Iau paiam.” ");
INSERT INTO uvl_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Pe Petrus hele, “Iok, o hele at nge iau ke e i mana nga ruach ona ke ela nge iong. Laka e eteia ke iong toto.” ");
INSERT INTO uvl_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Pe Iesus hele, “Iok, o i at.” Ol pe Petrus iuch hot nga sulang neu pe i sapele nga ruach ona ke lange Iesus. ");
INSERT INTO uvl_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Pe Petrus esia tuttula palaungana neu pe sana rora mule. Pomalam talun ke hekorong teu mule nga ruach. Ol pe alngana hot ke teke, “Non Soke! O halaua iau.” ");
INSERT INTO uvl_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Pe Iesus sie i nga penna ke ueiuei mana pe hele, “Iong letem manmanna ngana unne sune mana kura. Pomerei nenge o ra hite letem manmanna ngana ke kerkereng ero?” ");
INSERT INTO uvl_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Ke het pe iri nai te iuch teu la mule nga sulang neu, pe tuttula palaungana neu mete sio sapele. ");
INSERT INTO uvl_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Pe Iesus nena hana mur nenge teare nga sulang neu te heto heke i pe te hele, “Manmanna toto ke iong NeHalang Tuna.” ");
INSERT INTO uvl_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Iok, te lotele ke tela nga hele pe la te sio nga kileng nenge Kenesaret. ");
INSERT INTO uvl_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Pe hana nemur nga kileng neu tenau urume Iesus, pe te hesese pingana ke ueiuei mana ke song rara nga kileng mur nenga lamau. Ol pe hulua teat sapele ia haleles kina mur nge Iesus ke hemasia iri. ");
INSERT INTO uvl_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Pe haleles kina nemur te hele lange Iesus ke te teke, te ra haka mana nga nena hengeron ana horo ke aria haleles het. Ke iri nenge te ra haka nge Iesus, aria haleles het lochloch. ");
INSERT INTO uvl_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Pe Paresio mur pe hotonga ana hetoronga mur hel, te lohaka nge Ierusalem pe tei ke tela nge Iesus pe te onteia I, ");
INSERT INTO uvl_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Pomere nge lem hana mur? Te nanas ia hotonga mur nenge rera tete mur te hesio tele at nge ita ero. Hotonga nemur teke, ta lomo tele pera pe ta ngau ol. Pe lem hana mur te lome peria ero, te ngau pulut mana. Pomere mai?” ");
INSERT INTO uvl_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Pe Iesus hele, “Oe! Pe imo pomere nenge a nanas taua NeHalang na hotonga mur ero, pe a nanas mene lemo hotonga mur? ");
INSERT INTO uvl_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","NeHalang hele ke teke, ‘O heto heke tam pe temem pe o longo tau mene iri. Pe mele nenge hele poreke temene pe tana, lape te hune i ke mete.’ ");
INSERT INTO uvl_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Pe imo a teke poinga nei urana. Nenge a teke none hele lange temene pe tana ke, ‘E teke e halaua imo ke nek toto, pe ero. Iange lek halaunga nenge e teke e tunge lange imo, ngana kou e tung mule lange NeHalang lo. Ke nem, pomanga lek tunginga nenge lange I.’ ");
INSERT INTO uvl_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Mele nem poi ke urana lange NeHalang pe nge temene pe tana ero. Ke nga lemo poinga nem mana a tal sio tote NeHalang nena hotonga mur pe a teke a nanas tau mene imo sipomo lemo. ");
INSERT INTO uvl_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Imo hana nenge a pallaka hali! Hetatalonga Isaias hele hot pengpeng ia imo lo nenge hele ke teke ");
INSERT INTO uvl_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","“‘Hana nemur te heto heke Iau nga haria ulina mana nge hot, pe nga leteria nge teu tetu ke kangkanga toto nge Iau. ");
INSERT INTO uvl_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Te hetore hehei pe hana nga NeHalang na hotonga mur ero. Iange te hetoro mene iri nga iri siporia reria hotonga mur. Pe te channangnanga ke te heto hekeke Iau.’” ");
INSERT INTO uvl_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Ol pe Iesus iua hulua nemur ke tela nge i pe hele, “A longo ke nek nga helenga nemur nenge e heleleia nei luna mur. ");
INSERT INTO uvl_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Ngaunga nenge o mene ke otal teua langa halim, heporeke iong ke letem muna ero. Pe utar nenge lohot nga halim, ure nem poia iong ke letem muna.” ");
INSERT INTO uvl_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Pe Iesus nena hana mur tela nge I pe te hele, “Non Soke, o eteia pule? Paresio nemur te longe lem helenga nem nge o tung hote lange iri pe saria menin hulu toto ia.” ");
INSERT INTO uvl_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Pe Iesus hele ke teke, “Temek nga lut nga tapa eteia utar mur nenge tue iri nga ana ume. Pe ure lochloch ngana nenge tue iri ero, lape lalau heke iri luluch nga ularia mur. ");
INSERT INTO uvl_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","A reng mana lange iri. Mataria hit kura iam. Pe mele nenge matana hit pe teke henonoua mele e pule nge matana hit nga kue, lape iri nai ape ke te hekorong teu nga polo.” ");
INSERT INTO uvl_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Pe Petrus hele, “Iok, o hele urume helenga opene nem at nge imem.” ");
INSERT INTO uvl_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Pe Iesus hele, “Ia imo nge a etei ero kurkura kai? ");
INSERT INTO uvl_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Ure nenge a tal teua nga halimo, la sapele kela manga letemo. Ke het pe lohot mule nga letemo ke lasus. ");
INSERT INTO uvl_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Pe ure nenge lohot nga halimo, lohot at nga letemo nge teu toto. Pe ure nem lape poia mele nem ke letena muna hulu toto. ");
INSERT INTO uvl_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Ke ure nemur nenge poia mele nem ke letena muna hulu toto laka; letena tuanin rara ngana nga ure poreke ngana mur pe hune mele ke mete pe maluluch nge none nehei pe lau sisio hehei pe kemkeme, pe channanga halali pe ngunngunu halali pe poinga nenge taolo heke mene helenga chanangnanga ke ta heporeke mele ene. ");
INSERT INTO uvl_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Ke ure nemur, poia mele nem ke letena muna hulu toto. Pe nenge teke mele nem lome penna ero pe ngau mana, nem poia mele nem ke letena muna hulu ero.” ");
INSERT INTO uvl_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Iok, Iesus hile kileng neu pe langa kileng nenge Tir pe Saiton. Pe hei e nge nena nge Kanan tutu nga kileng neu. ");
INSERT INTO uvl_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Ana hei esia Iesus pe tang hot lange I ke teke, “Non Soke! Iong ne Teuit tuna laka iong. Letem poreke ia iau pe o halaua iau! Tuk heingana e, uneinei te poi poreke tote. Pomerei pe o iat ke o halaua i, iange tu ngana poreke toto lo.” ");
INSERT INTO uvl_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Pe Iesus tuacholia hei neu nena helenga ero. Ol pe nena hana mur tela nge I pe te totohita ke te teke, “O kulosia hei nei ke la ol. Ngana koi nenge nananas pe pur leme ero mana ia iunga atat nge ita.” ");
INSERT INTO uvl_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Pe Iesus hele, “NeHalang kulosia iau at nge Israel mur mana. Iri te pomanga sipsip mur nenge te erue.” ");
INSERT INTO uvl_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ol pe hei neu at ke tualou sio palana nga Iesus matana pe hele, “Non Soke! O halaua iau.” ");
INSERT INTO uvl_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Pe Iesus hele, “Nenge teke ta mene aina kinkino ngana aria ngaunga pe ta sau sue langa kaone mur, poinga nem poreke toto.” ");
INSERT INTO uvl_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Pe hei neu hele, “Oe Non Soke, nem manmanna. Pe hana hel te ngaungau nga aria hatanga pe ngaunga mumuna losisio. Pe reria kaone mur te ngau hekeke ngaunga mumuna nemur.” ");
INSERT INTO uvl_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Pe Iesus hele, “Hei nem, iong letem manmanna ngana palaungana toto. Pe utar nenge lemem taua nge iau lape lohot ke manmanna.” Pe nga etue unne neu pengpeng hei neu tuna heingana urana mule sapele. ");
INSERT INTO uvl_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Iok, Iesus hile kileng unne neu pe langa ech hetaliliu ngana nge Kalelea pe i ke henanas ole ruach nem ilina. Ol pe i haka langa hengene ilina pe kila sio. ");
INSERT INTO uvl_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Pe hulua te nanasia I pe tela ke te mene iri nenge aria haleles ke la tetal sue iri nga Iesus apena huna ke hemasia iri. Ngana laka iri nenge singiria metmete, pe nenge mataria hit, pe nenge aperia metmete pe nenge te hele erochro pe haleles tana huna hel pule. ");
INSERT INTO uvl_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Pe hulua nemur ngaria lohot, iange tenau pe iri nenge te hele erochro neu, te hele mulmule, pe nenge aperia mete tei mulmule, pe nenge singiria mete te urana mule, pe iri nenge mataria hit tenau mulmule. Ol pe te heto haka tote Israel mur aria Soke NeHalang. ");
INSERT INTO uvl_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Pe Iesus iua nena hana mur pe hele lange iri ke teke, “Letek poreke ia hulua lochloch ngana nei i. Iange iri te nananasia iau ke etue iri mol lo, pe te tam teua ute e ero toto. Pe atong mur te mete aria lo. Pe pule lemek ero nge e poi kulosinga ia iri. Iange heueu lape hel mataria liuliu pe te losio ke tema mana nga kue.” ");
INSERT INTO uvl_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Ol pe Iesus nena hana mur te hele, “Pe ita mai lape ta mene ngaunga langai ke ta hengaua hulua nenge pomai mai? Kileng e nge tu rochroi nga lamai ero i.” ");
INSERT INTO uvl_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Pe Iesus onteia iri, “Mioka hia nenge a ronronia mau?” Pe iri te hele, “Mioka iri rahtele nai pe ruo kinkino ngana hel i, mo ronronia.” ");
INSERT INTO uvl_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Ol pe Iesus hele lange hulua nemur ke te kila sio nga ich. ");
INSERT INTO uvl_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Pe mene hot sapele ngaunga nemur pe ruo neu. Pe hele urana toto lange NeHalang. Ke het pe reke ngaunga nemur pe tunge lange nena hana mur ke te heronge nge hehei pe hana. ");
INSERT INTO uvl_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Iri lochloch te ngau ke saria una toto. Pe Iesus nena hana mur te takiraua ngaunga aluanuana mur. Pe ngaunga aluana, te takiraua ke ana kaliu iri rahtele nai. ");
INSERT INTO uvl_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Iri nenge te ngaua ngaunga neu iri 4,000 pe tesis ele hehei pe aina kinkino ngana ero. ");
INSERT INTO uvl_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Iok, Iesus kulosia hulua nemur ke tela ol, pe I tamu haka nga sulang e pe mana tele langa kileng nenge Makatan. ");
INSERT INTO uvl_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Iok, Paresio mur iri ul Satiusi mur tela nge Iesus pe te ollaka hote I, ke te teke hele pe ute e lohot mana ke tenau. ");
INSERT INTO uvl_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Pe Iesus hele, “Imo lape a esia tapa sana nge remenmen nga ulei pe a hele pengpeng ke a teke, ‘Ochou kileng chaia pam lo, iange ririua pau kou ma hot nga tapa sana.’ ");
INSERT INTO uvl_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Pe nga uach a hele ke a teke, ‘Heueu lape pitte mol, iange muchmua halang kou ma hele tapa sana.’ Imo anau urume tapa sana pe a hele hot pengpeng ia ure nenge lape lohot. Pe pomere nge anau urume ure nenge lohotot nga etue nei pe ramamo chach ia ero toto? ");
INSERT INTO uvl_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Imo hana porekreke ngana mur nga etue nei, a teke e poi hote ute hel ke anau? Iau lape e poi hote ute pele ero toto. Pe ure nenge lohot nge Iona nge nike, lape e tunge lange imo.” Pe Iesus hulia rumena lange iri pe i ke la sapele. ");
INSERT INTO uvl_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Iok, Iesus pe na hana mur te lotele langa kolkolu palaungana neu ilina hele lo, pe Iesus nena hana mur leteria lilil nge te mene ngaunga. ");
INSERT INTO uvl_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Pe Iesus hele lange iri ke pomai, “Anau ala amo ke nek toto nge Paresio mur pe Satiusi mur. Iange hana nemur, te poi ke pomalaka nga ure nenge tetal teua langa beret itach ngana pe poia beret nem ke una haka. (is)” ");
INSERT INTO uvl_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Ol pe Iesus nena hana mur te hele tele hel mana nge iri ke te teke, “Pomere toto nenge Iesus tamal hote helenga nei mai? Lape ta mene ngaunga ero ke ngana kai?” ");
INSERT INTO uvl_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Pe Iesus eteia ure nenge te heleleia neu lo, pe hele lange iri ke teke, “Imo letemo manmanna ngana unne sune mana iam. Pomere nenge a heleleia ngaunga nge ero? ");
INSERT INTO uvl_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Letemo mallaha ero kura kai? Letemo la mule nga mioka lime nenge hana iri 5000 te ngaua pe saria una hatal ia. Pe kaliu iri hia nenge te muta ia aria ngaunga aluanuana mur? ");
INSERT INTO uvl_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Iok, letemo metene hulua nenge iri 4000 nem. Aria mioka iri rahtele nai mana, pe hehei pe hana lochloch ngana nem te ngau ke saria una. Pe kaliu iri hia te muta ia ngaunga aluanuana mur? ");
INSERT INTO uvl_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Pomere nge letemo alchach ero kura? Iau e hele lala nge imo nga ngaunga ero. E teke anau ala amo ke nek toto nga is nenge Paresio mur pe Satiusi mur.” ");
INSERT INTO uvl_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Ol pe Iesus nena hana mur leteria matana sapele nga ure nenge Iesus helele ia. Ke Iesus teke tenau ala aria nga is nenga beret ero. Iesus teke tenau ala aria laka nga hengetoro nenge Paresio mur pe Satiusi mur. ");
INSERT INTO uvl_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Iok laol, Iesus i ole ke langa tuele tana pengpeng ngana nenge Kaesarea Pilipai. Pe onteia nena hana mur ke teke, “Hana pe hehei te heleleia Non Tuna ke te teke I itei toto?” ");
INSERT INTO uvl_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Pe nena hana mur te hele, “Hehei pe hana hel te heleia Non Tuna ke te teke, I Ioanes nenge henunun; pe hel te teke I Elaisa; pe hel te teke Ieremias; nem pe te teke non hetatalonga e mana.” ");
INSERT INTO uvl_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Pe Iesus ontei mule iri ke teke, “Pe imo a teke Iau itei toto?” ");
INSERT INTO uvl_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Pe Simon Petrus tuacholia ke teke, “Iong Kristus. NeHalang nenge tu ke koko tuna iong.” ");
INSERT INTO uvl_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Pe Iesus hele, “Simon, iong ne Iona tuna iong. NeHalang pete iong. Ke ngana laka nenge o hele hote helenga nem. Pe mele nga ich nei hele ia helenga nem lange iong ero. Temek nenge tu nga lut nga tapa henonou iong ia helenga nem. ");
INSERT INTO uvl_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Pe e hele lange iong, iong Petrus nenge em luna laka, ‘um’, pe nga um nei lape e hemes heke lek hana mur nenge leteria manmanna nge iau. Pe kerkerenga nenga metenga lape hekou sue iri ero toto. ");
INSERT INTO uvl_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Pe lape e tunge lohenga mur nenga NeHalang nena naualanga pe nekinga nga tapa lange iong. Pe utar nenge o hu hele nga ich nei, lape NeHalang hu hele nga lut pule. Pe utar nenge o longele nga ich nei, lape NeHalang longele nga lut pule.” ");
INSERT INTO uvl_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Iesus i Kristus ke manmanna. Pe toto hita toto lange nena hana mur ke te hele rere helenga nem ero toto. ");
INSERT INTO uvl_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Iok, talun nga etue neu ke la ol, Iesus hele lala nge nena hana mur ke teke lange Ierusalem. Pe hele urume tote lange iri, ke teke lape amneia melmelenga halang nenge lape hana nemur te poia lange I. Ngana laka hana papalauna mur pe tunginga ana hana mur aria soksoke ngana mur pe hotonga ana hetoronga mur. Pe lape te hune I ke mete pe maul haka mule nga etue mol ngana. ");
INSERT INTO uvl_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Pe Petrus longe Iesus nge hele ke mau pe mene lele hote Iesus pe keres taua I ke teke, “Non Soke! O poi ke pomam ero. Lemek ero nge ure nem lohot nge iong.” ");
INSERT INTO uvl_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Pe Iesus ul mule ramana lange Petrus pe hele lange i ke teke, “Iong non poreke ngana iam, o la nga rumek! O poi ke malaka nga ure nenge teke poi hele lek kue pe hesingo ia Iau ke e losio mule. Iong letem tu mana nga ure nemur nga ich nei. Letem tu nge NeHalang ero toto.” ");
INSERT INTO uvl_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Ol pe Iesus hele lange nena hana mur ke teke, “Nenge teke mele koko nge Iau heueu, hilesue lemene ngana mur lochloch pe takisia ana melmelenga, pomalam nanasia iau ol. ");
INSERT INTO uvl_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Iange mele nenge ramana tuhit mene maulul ngana nga ich, lape maulul nga hoena ero ol. Pe mele nenge nanas tote iau kela i sipona mete, ana non lape mene mule maulul ngana nenge tu ke koko. ");
INSERT INTO uvl_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Nenge teke mele mutena tau tote ure lochloch ngana nga ich nei, lape mene maulinga ke koko ero. Iange lape ure nemur te halaua i nga hoena ke merei? Nem pe lape ol mule maulinga ke koko nga utar? ");
INSERT INTO uvl_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Non Tuna lape at luluch nga Temene na hemalmalinga. Pe at luluch nge nena angkelo mur. Pe lape tunge iechinga lange hehei pe hana ke nanas tau pengpengia reria poinga mur nga ich nei. ");
INSERT INTO uvl_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","E hele lange imo pengpeng, amo hel nge imo nenge te mes heueu nei, lape metenga mene iri ero kura pe te esia Non Tuna nge at luluch nga nena naualanga pe nekinga.” ");
INSERT INTO uvl_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Iok, etue iri rahtele elle lalo pe Iesus mene Petrus pe Ieims pe tina Ioanes ke iri ul te haka langa hengene ke iri toro mana. ");
INSERT INTO uvl_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Pe nga lamau te esia Iesus nge singina lohot ke altoto. Iesus ramana sina ele mataria ke pomanga chaia matana. Pe na hengeron tua huita toto ke pomanga lemenge e nge tualeme ngana sina ala toto. ");
INSERT INTO uvl_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Ol pe tenau mana pe te esia Iesus nge hele lululuch nge Moses iri nai Elaisa. ");
INSERT INTO uvl_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Pe Petrus hele lange Iesus, “Non Soke, imem nei motu lamai ke urana lo. Pe nenge teke lemem, e hemes haka ke pelpele iri mol, ke iong lem e pe Moses na e pe Elaisa na e.” ");
INSERT INTO uvl_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Petrus helele kura pe ulu lohot ke poi hite iri. Ulu neu hussu toto pe helenga e lohot nga ulu neu ke teke, “Tuk toto koi nei, nenge mutek tau tote pe e iech toto nge I. A longo taua I!” ");
INSERT INTO uvl_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Iesus nena hana mur te longe ke mau pe te matau toto pe te losio mana. Pe tema ke tenau sio mana nga ich. ");
INSERT INTO uvl_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Ol pe Iesus la ke ra lange iri pe hele, “A lohaka ol. A matau ero.” ");
INSERT INTO uvl_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Te teke tenau haka pe tenau mene Iesus i toro mana ol. Pe hana nai neu iri ero lo. ");
INSERT INTO uvl_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Iok, tei sio nga hengene neu ke tela mulmule pe Iesus toto hita toto lange iri ke teke, “A esia ure nenge lohot nei, a hele ia lange mele ero toto kela het nga etue nenge Non Tuna maul haka mule nga ana metenga.” ");
INSERT INTO uvl_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Pe nena hana mur te onteia I ke te teke, “Pe pomere nenge hotonga ana hetoronga mur te hele ke te teke, Elaisa lape at tala mai?” ");
INSERT INTO uvl_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Pe Iesus hele ke teke, “Nem manmanna, Elaisa lape at tala ke hepengia ure lochloch. ");
INSERT INTO uvl_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Pe e hele lange imo, Elaisa at lo pe hana nemur te eteia i ero. Te poia i ke nek ero pe te poi pulut mana lange i nga lemeria ngana. Pe poinga nem lape te poia lange Non Tuna pule ke amneia ana melmelenga palaungana.” ");
INSERT INTO uvl_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Ol pe Iesus nena hana mur te etei sapele ke I heleleia Ioanes nenge Henunun. ");
INSERT INTO uvl_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Iok, tela mule nge hulua nemur pe none lange Iesus pe tualou sio nga matana pe hele, ");
INSERT INTO uvl_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Non Soke, letem poreke ia tuk. Heueu nei tungana poreke toto iange ute poia ramana ke ana hauaua toto. Teke la ke mak hakaka nga oan pe mana puluch teueu nga ech. ");
INSERT INTO uvl_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","E mene i lange lem hana mur nenge te nananasia iong, pe nakuria ero taua nge te hemasia i.” ");
INSERT INTO uvl_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Ol pe Iesus hele ke teke, “Imo hana nem, letemo manmanna ero, pe ai ke a tuamasia lemo inga mur ero toto. Etu luluch nge imo ke mala lo. Pe nge ngingie ol pe a etei tote ume nei? A mene kol nem at nge Iau.” ");
INSERT INTO uvl_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Ol pe Iesus keres taua uneinei nenge tu nge kol neu, pe uneinei neu lohot sapele. Pe kol sune neu urana mule nga etue neu pengpeng. ");
INSERT INTO uvl_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Pe Iesus nena hana mur tela pe te ontei kome mene I ke teke, “Pomerei toto nenge mo helope hote uneinei nem pe longo taua imem ero mai?” ");
INSERT INTO uvl_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Pe Iesus tuacholia ke teke, “Iange imo letemo manmanna ngana unne sune mana. E hele ke manmanna toto lange imo. Nenge teke letemo manmanna ngana purpure hohos nganngana, a hele langa hengene neu pe hengene nem lape longo taua imo. Ke a teke, ‘Hengene nem, o lohaka nga lamai pe o loloun la lamau.’ Pe anau, hengene nem lo haka pe loloun ke la. Pe ute pele nge anali nge imo ero ol.  ");
INSERT INTO uvl_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Pe nenge teke a teke a helope hote uneinei nenge pomai, apoi mana nga poinga nenge a hetalaulau ke kokoes pe a hile ngaunga.” ");
INSERT INTO uvl_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Iok, Iesus iri ul nena hana mur tela ke te eukirau mule nge Kalelea pe Iesus hele la mule nge iri ke teke, “Lape te tung heke Non Tuna langa hana hel peria. ");
INSERT INTO uvl_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Pe te hune I ke mete pe nga etue mol ngana lape maul haka mule nga ana metenga.” Iesus hele ke mau pe nena hana mur leteria poreke toto ia I. ");
INSERT INTO uvl_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Iok, Iesus iri ul nena hana mur tela te lohot nge Kapernam pe hana nenge te lololoch umtutuna tela nge Petrus pe te onteia i ke te teke, “Amo hetoronga nem mam sausau umtutuna pule ma? Umtutuna nenge lala nga NeHalang na pele palaungana?” ");
INSERT INTO uvl_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Pe Petrus hele ke teke, “Oe, Ana non sausau umtutuna pule la.” Ol pe Petrus i teu la sapele nga pele. Pe Iesus ontei tele i ke mai, “Simon, iong letem tuanin ngana ma ke mere? Hana papalauna nemur nga ich nei te nananasia poinga nenge te lololoch umtutuna. Pe te menmene nge itei? Te menmene nge tuturia mur pengpeng ma te menmene nge hana lomonmona ngana mur?” ");
INSERT INTO uvl_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Pe Petrus tuacholia ke mai, “Te menmene nge hana lomonmona ngana mur mana.” Pe Iesus hele lange i ke teke, “Nem manmanna. Te loloch umtutuna nge tuturia mur pengpeng ero. ");
INSERT INTO uvl_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Pe lemere ero nge ta poia hana nemur ke saria menin hulu. Pomalam o la nga kolkolu palaungana nem pe o kona. Pe ruo elle nenge o kona heke tele, o poia hanna ke pangpanga pe lape o hottaua um tuna e nge mateu. Pe ita nai rera umtuna nenge ta saua lalom. O mene pe o laia nge hana nemur.” ");
INSERT INTO uvl_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Iok, nga etue neu Iesus nena hana mur tela nge i pe te onteia i ke te teke, “Itei toto nenge lape i soke nga NeHalang nena naualanga pe nekinga?” ");
INSERT INTO uvl_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Ol pe Iesus iua mele sune lange i pe hemes ia i nga mataria. ");
INSERT INTO uvl_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Pe hele, “E hele ke manmanna toto lange imo, nenge teke a hulia lemo poinga mur ero pe a tal sue imo ke mange aina kinkino ngana ero, lape ateu langa NeHalang nena naualanga pe nekinga ero toto. ");
INSERT INTO uvl_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Ke mele nenge talsio tote i ke mange mele sune nei, lape i soke nga NeHalang nena naualanga pe nekinga. ");
INSERT INTO uvl_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","“Pe mele nenge letena metene Iau pe poi ke urana lange mele sune e nge pomai, poi ke urana at nge Iau pule. ");
INSERT INTO uvl_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Aina kinkino ngana nge mai leteria manmanna nge Iau. Pe nenge teke mele heporeke elle nge iri letena manmanna ngana ke losio, urana nge te heon hite um palaungana nga mele nem kanna pe tesau sue langa leme chapopo ngana pe mana puluch ke lasus. ");
INSERT INTO uvl_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","“Hulua nga kileng lochloch lape te amneia melmelenga palaungana. Iange ute hel poia iri ke te losio nga poinga poreke ngana mur. Pe ure nemur lape te lohot ke manmanna. Pe non nem nenge poia iri ke te losio lape amneia melmelenga ke poreke toto! ");
INSERT INTO uvl_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Nenge teke perim ma apem, te poia iong ke o losio nga poinga poreke ngana, o chato hote iri pe o saua ke te lasus. Urana nge singim unne lasus nike. Pomalam lape o mene maulinga ke koko. Iange nenge teke apem nai pe perim nai ape ke tetu, lape tesau heke iong langa oan sapel lala ngana nenge tu ke kokoes mana. ");
INSERT INTO uvl_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Nenge teke matam poia iong ke o losio nga poinga poreke ngana, o sul hote pe o saua ke lasus. Urana nge matam elle ke o mene maulinga ke koko. Pe nenge teke matam iri nai ke tetu kura lape tesau heke iong langa oan nge Imperno.” ");
INSERT INTO uvl_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Anau ala ke nek! A poi poreke aina kinkino ngana nenge mai ero. Iange reria angkelo mur kou tetu luluch nge Temek nga lut nga tapa. Pe kokoes te esesia Temek nakuna.  ");
INSERT INTO uvl_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Pe Non Tuna at ke mene mule iri nenge te erue. ");
INSERT INTO uvl_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Imo letemo ma ke mere? Nga nenge teke none nena sipsip mur iri ana non kina iri lime (100) pe elle erue. Lape la ke tango rere ma ero? E hele lange imo, non nem lape hile sue nena sipsip mur pe langa hengene ke tango rere elle nenge erue nem. ");
INSERT INTO uvl_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Pe nenge teke hottaua mai loi, non nem lape iech ele tote. Pe sipsip nem pekngana nemur, non nem iech ele iri ero. ");
INSERT INTO uvl_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Ke pomalam mana, Tememo nga lut nga tapa lemene ero nge e nge iri kinkino ngana nemur erue. ");
INSERT INTO uvl_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Pe nenge teke tim e poia poinga poreke ngana e lange iong, ola ke nek mana nge i ke imo nai mana, pe o hele hote ure nenge poia ke poreke. Pe nenge teke longo lange iong ke nek, iong lape o halau mule i ke imo nai timo hel mule. ");
INSERT INTO uvl_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Pe nenge teke longo lange iong ke nek ero, ola ke o mene mele elle pule. Nem pe o mene ke aina nai pule. Iange nenge teke aina nai ma mol te hele, lape reria helenga mene hote ure nem ke lohot ke mallaha. ");
INSERT INTO uvl_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Pe nenge teke mele nem lemene ero nge longo lange iri nai ma mol nem, a heleia lange NeHalang nena hana mur. Pe nenge teke lemene ero nge longo lange NeHalang nena hana mur, anau mene i ke pomanga none nge eteia NeHalang ero. Nem pe a naue i ke pomanga non nenge lololoch umtutuna. ");
INSERT INTO uvl_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“E hele ke manmanna toto lange imo, utar nenge o hu hele nga ich, lape NeHalang hu hele nga lut pule. Pe utar nenge o long hele nga ich nei, lape NeHalang long hele nga lut pule. ");
INSERT INTO uvl_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Lape e hele lange imo ke mai pule, Nenge teke amo nai te ngata hel ke te hetalaulau nga ute, Temek nga lut nga tapa lape poia ke lohot ke manmanna. ");
INSERT INTO uvl_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Nei manmanna, iange nenge teke amo nai ma mol a eukirau nga Iau ek, Iau la etu luluch nge iri.” ");
INSERT INTO uvl_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Ol pe Petrus lange Iesus pe hele ke teke, “Non Soke, nenge teke tik e poia poinga poreke ngana at nge iau, pe lape letek porekeia i ke e hia? Ratele nai toto?” ");
INSERT INTO uvl_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Pe Iesus hele, “E hele ke e teke rahtele nai mana ero. E teke rahtele nai pe rahtele nai mule pe rahtele nai mule a poia ke koko tele mana kela pe a sis ele ero. ");
INSERT INTO uvl_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“Iange NeHalang nena naualanga pe nekinga pomalaka nge non soke ngana e nge iua nena hana mur ke te tuacholcholia reria hanganok mur. ");
INSERT INTO uvl_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Pe talune nge nena non nenge mene ke umtutuna iri halang toto (1-milion kina). ");
INSERT INTO uvl_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Pe non nem na umtutuna halang ero nge tuacholia ana soke nem nena umtutuna mur. Pomalam non soke neu hele ke lape mele hel te olia non neu pe nehei pe tutuna mur pe reria ure mur lochloch. Pe umtutuna lange non soke neu ke hemete non neu nena hanganok mur. ");
INSERT INTO uvl_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","“Ol pe non neu longe pe la ke tua mermero sio nga ana soke apena huna pe hele ke teke, ‘Non soke, letem ia iau mukam, pe lape e tuachol mule lem ure mur lochloch.’ ");
INSERT INTO uvl_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Ol pe non soke neu letena ia non neu pe hele ke teke hanganok neu lasus ol. Pe kulosia non neu kela sapele. ");
INSERT INTO uvl_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Iok, non neu i hot kela pe saolia neingana e nge hanok ke umtutuna ana non kina iri lime (100 kina) nge i. Pe sihe i pe teke inroke non neu nga kanna pe hele inin taua i ke teke, ‘Iong nem, heueu mana nei o tuacholia lem hanganok nenge o poia nge iau.’ ");
INSERT INTO uvl_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","“Pe neingana neu tuamermero sio nga matana pe hele, ‘Kole, letem poreke ia iau pe o kulala pol mana, pe lape e tuachol ia hanganok nem.’ ");
INSERT INTO uvl_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","“Pe non pa neu lemene ero nge kulala. Ol pe poia neingana neu kela mateu nga tuele au ngana kela het nga etue nenge tuachol taua nena hanganok mur. ");
INSERT INTO uvl_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Pe iri nai reria ume pekngana mur te esia poinga neu pe ma ke nek nga leteria ero. Pomalam tela nge aria soke neu pe te nene lange i. ");
INSERT INTO uvl_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","“Iok laol, non soke neu iu teua non neu la pe hele ke teke, ‘Iong nem, lem poinga poreke toto! Hanganok nenge o poia nge iau nem, e hele lange iong ke e teke lasus lo. Iange iong sipom o hele ke o teke letek poreke ia iong. ");
INSERT INTO uvl_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Pe pomere nenge letem poreke ia neingam neu ero?’ ");
INSERT INTO uvl_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Non soke neu letena inin pe heteu mule non neu langa tuele au ngana. Pe te poia i ke amneia ana melmelenga kela het nga etue nenge tuachol taua nena hanganok mur. ");
INSERT INTO uvl_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","“Pe Temek nga lut nga tapa lape poia imo elle pe elle ke pomalam pule. Pe nenge teke letemo ia neingamo mur, letemo ia iri nga letemo nge teu toto.” ");
INSERT INTO uvl_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Iesus hele ke het pe lohaka sapele nge Kalelea pe i ke langa kileng nenge Iutea, nga ech ilina hele nenge Iortan. ");
INSERT INTO uvl_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Pe hulua te nanasia I pe hemasia iri nga aria haleles mur. ");
INSERT INTO uvl_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Pe Paresio mur hel tela nge Iesus ke te tuamirik hote i pe te onteia i, “Rera hotonga mai hele ke teke, lape none hile nehei nga lemene ngana pule kai?” ");
INSERT INTO uvl_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Pe Iesus tuachol ia ke teke, “Imo nge lape a sisis nga NeHalang nena helenga ero iam. Alalaha nem hele ke teke, ‘Nga talun ngana toto, NeHalang ume hote iri ke none pe heie.’ ");
INSERT INTO uvl_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Pe pule alalaha nem hele ke teke, ‘Pomalam, none lape hile temene pe tana pe la ke tululuch nge nehei pe iri nai singiria lohot ke elle mana.’ ");
INSERT INTO uvl_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Ke iri nai te lohot ke iri elle pengpeng pe nai mule ero ol. Pe ure nai nenge NeHalang puotom tele, a chatoa ero toto.” ");
INSERT INTO uvl_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Pe hana nemur te hele, “Pe pomere nenge Moses hele ke teke, nenge teke none lemene ke hile nehei, non nem as hote alalaha e? Pe alalaha nem hele tote aria leinga nge lape het. Ke het pe tunge lange nehei pe kulosia i ke la mule nge temene pe tana. Pomere nge Moses hele ke pomam?” ");
INSERT INTO uvl_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Pe Iesus hele, “Moses longele imo ke a hile lemo hehei mur iange a nanasia NeHalang nena hengetoro mur ero. Pe nga tele ngana toto ute pele nge pomam ero. ");
INSERT INTO uvl_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Pe e hele lange imo pengpeng, mele nenge hile nehei pe lei heke mule hei e, poia poinga poreke ngana nga NeHalang matana ke het lo. Kue nenge o teke o hile lem hei, ngana laka nga nenge teke hei nem pingana hota hot nge none.” ");
INSERT INTO uvl_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Ol pe Iesus nena hana mur nenge te nananasia I, tela nge Iesus pe te hele, “Eh, ke nenge teke leinga kina mur te popoi ke machmai, urana ngana ta lei ero nike.” ");
INSERT INTO uvl_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Pe Iesus hele, “Hulua lochloch ngana te nanasia hengetoro nei ero. Pe NeHalang poia mele hel mana ke te nanasia. ");
INSERT INTO uvl_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Mele hel te lei ero iange te hoe iri pe te poi ke pomau nike. Pe hel, te lei ero iange none penna poia iri. Pe hel, te lei ero iange te teke te tung tote iri ke te poia NeHalang nena naualanga pe nekinga nenga tapa ana ume. Mele nenge lemene taua hengetoro nei, mene ke tal talue nga letena pe nanasia.” ");
INSERT INTO uvl_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Iok, te mene aina kinkino ngana hel lange Iesus ke te teke Iesus tal heke penna nge iri pe hetalaulau hite iri. Ol pe Iesus nena hana mur te hele inin taua iri nenge te lala ia aina kinkino ngana nemur. ");
INSERT INTO uvl_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Pe Iesus heleia nena hana mur ke teke, “Aina kinkino ngana nemur te teke teat nge Iau. Pe imo, apoi hele iri ero. Iange naualanga pe nekinga nenga tapa, nganangana mur laka iri nenge pomam.” ");
INSERT INTO uvl_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Iok, Iesus tal heke penna nge iri ke het pe i kela sapele. ");
INSERT INTO uvl_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Ol pe none lange Iesus pe ontei ke teke, “Hetoronga, lape e poia utar nge urana ke e mene maulinga ke koko?” ");
INSERT INTO uvl_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Pe Iesus tuachol ia ke teke, “Pomere nenge o onteia Iau nga ure nenge urana? Mele elle mana nge urana toto. Pe nenge teke lemem ke o mene maulinga ke koko, o longo tau mene hotonga mur.” ");
INSERT INTO uvl_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Pe non neu ontei, “Hotonga tei hel?” Pe Iesus tuacholia ke teke, “‘O hune mele ero. O tomtom hehei ero. O keme ero. O pallaklaka ia mele ero. ");
INSERT INTO uvl_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","O heto heke temem pe tam. Pe lemem taua neingam ke pomanga lemem taua iong sipom.’” ");
INSERT INTO uvl_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Pe non neu hele, “Hotonga nemur e nanas tau tote iri lo. Pe utar pule nge lape e poia?” ");
INSERT INTO uvl_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Pe Iesus hele, “O teke o lohot ke iong non nge pengpeng toto, o laia lem ure mur lochloch nge hana hel ke te olia, pe o tunge ana umtutuna mur lange iri nenge reria ute e ero toto. Ke nenge teke o poi ke pomai, lape lem ure halang tema ke te kulele iong nga lut nga tapa. O poia ume nem ke het pe o iat ke o nanasia Iau.” ");
INSERT INTO uvl_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Non neu longe ke mau pe nakuna poreke pe ua sapele, iange nena ure halang sakilil. ");
INSERT INTO uvl_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Ol pe Iesus hele lange nena hana mur ke teke, “E hele ke manmanna toto lange imo. None nenge na ure halang sakilil, anali toto nge teu langa naualanga pe nekinga nenga tapa. ");
INSERT INTO uvl_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Pe pule e hele lange imo, nenge teke kamel e i teu langa pakeka sune polona, nem semel toto. Pe non nenge na ure halang, anali toto nge teu langa NeHalang nena naualanga pe nekinga.” ");
INSERT INTO uvl_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Iesus nena hana mur te longe ke mau pe te rura toto pe te ontei, “Ol pe itei toto ol nenge lape mene maulinga ke koko?” ");
INSERT INTO uvl_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Pe Iesus nau lange iri pe hele, “Hana nakuria ero toto nge te poia ure nem. Pe nge NeHalang, i nakuna nge poia ure lochloch ngana.” ");
INSERT INTO uvl_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Pe Petrus hele, “O esia imem nei, mo hile sue lemem ure mur lochloch pe moat ke mo nananasia iong. Pe lape mo mene urumem utar?” ");
INSERT INTO uvl_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Pe Iesus hele lange iri ke teke, “E hele ke manmanna toto lange imo nenge a nanasia iau. Nga etue palaungana nenge lape ure lochloch ngana te heueu ngana mule, Non Tuna lape are nga nena arenga nenge te hemalmalia ke I Non Soke toto ngana ia. Pe nga etue palaungana nem, imo lape a kila nga arenga mur pule. Lape a kila nga arenga mur nge iri analoch pe nai ke a nauele mata iri analoch pe nai nenge Israel. ");
INSERT INTO uvl_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Pe iri lochloch ngana nenge leteria tu mana nge Iau pe te hile sue reria pele mur pe titiria mur pe liliuria mur pe tetemeria mur pe tataria mur pe tuturia mur pe reria ich mur, iri lape te mene mule ure nemur ke ele haka toto pe lape te mene maulinga ke koko pule. ");
INSERT INTO uvl_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Pe hulua nenge iri muka lape iri hoena mule, pe hulua nenge iri hoena lape iri muka mule.” ");
INSERT INTO uvl_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Pe Iesus hele “E hele ke pomam iange naualanga pe nekinga nenga lut nga tapa, i pomanga none nge tue uain mur nga nena ich unne. Pe ana non hoala hot nga uach uruna ke tango rara hana kela te ume nga uain ana late nem. ");
INSERT INTO uvl_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Hottaua hana hel pe hele lange iri ke teke, ‘Imo a ume nge iau heueu pe urumo laka umtutuna tolona elle.’ Pe iri te ngata helia uru nem. Hele lange iri ke het pe kulos sapele iri ke tela nga ume. ");
INSERT INTO uvl_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","“Iok, chaia matana mes haka pol lo pe lake tango rara hana hel mule. Esia hel nge te mes rara manmana nga ingala matana ");
INSERT INTO uvl_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","pe hele lange iri, ‘Imo nemur ai at. Ala ke a ume nga lek uain ana late. Pe lape e olia imo ke nanas urume mene a ume ngamo.’ ");
INSERT INTO uvl_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Hana nemur te lohaka pe tela sapele. “Iok, chaia matana heurunga (12 kilok) pe ana non la ke tango rara hana hel pule. Pe chaia matana pallele (3 kilok) pe la ke tango rara hana hel pule. ");
INSERT INTO uvl_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Pe nga ulei, nga chaia matana sisio lo (5 kilok), pe la ke tango rara hana hel pule. La pe esia hel nge te mes rara manmana pe hele lange iri, ‘Etue nei i lala lo, pe pomere nenge a mes rara manmana nga lamam mam?’ ");
INSERT INTO uvl_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","“Pe hana nemur te hele, ‘Motu rara mana iange none hekuleilei ia imem ke mo ume ana ero.’ “Ol pe non neu hele lange iri, ‘Iok, imo pule a la ke a ume nga lek uain ana late.’ ");
INSERT INTO uvl_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Iok, ulei sio nga chaia matana lala ke teu sisio lo (6 kilok), ume tokoninga neu hele lange nena non nenge nauelele hana mur nga ume ke teke, ‘O iua hana nenge te ume nem pe o tunge reria umtutuna. Pe o talun tala nge iri nemur nenge teat nga rume toto pe ramam ole lange iri nenge te talun tala ume.’ ");
INSERT INTO uvl_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","“Ke iri nenge teat rume toto neu te olia iri elle pe elle nga umtutuna tolona elle. ");
INSERT INTO uvl_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Pe iri nenge te mene tele iri ke te ume neu, te teke ma lape te mene ke haka pol nge iri nemur, pe ero. Iri elle pe elle te mene ke umtutuna tolona elle pule. ");
INSERT INTO uvl_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Te esia ke mau pe te ngunngunu ia ume tokoninga neu. Pe te hele lange i ke te teke, ");
INSERT INTO uvl_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘Iong, toinge o olia imem nenge moat tala ke urumem haka nge iri nemur nenge teat rume mana nei ol. Iange imem, mo talun tele ume nei nga chaia milang ngana nike. Pe iri nemur teat rume mana te ume ke etue choro mana. Pe pomere o tunge urumem ke elle mana ke mange iri?’ ");
INSERT INTO uvl_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Pe ume tokoninga neu tuachol ia pe hele lange elle nge iri ke pomai, ‘Kole, e poia poinga poreke ngana e lange iong ero i. Iange iong o ngata at nge iau lo nga nenge o teke, o ume pe o mene urum nenge pomam. ");
INSERT INTO uvl_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Ke o mene pe o la ol. Nga iau lemek ngak mana e tunge non nenge at rume mana nem uruna ke elle mana ke mange iong. ");
INSERT INTO uvl_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Umtutuna nei iau sipok lek ia, pomalam e poia nga lemek ngak. Pe pule e poia nga poinga urana ngana. Pe iong letem ma ke mere?’” ");
INSERT INTO uvl_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Pe Iesus hele, “Iri nemur nenge iri muka, lape tela ke iri hoena mule pe iri nenge iri hoena, lape tela ke iri muka ke pomalam mana.” ");
INSERT INTO uvl_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Iok, Iesus ramana haka lala nge Ierusalem lo, pe iu hot kelkel ia nena hana mur pe hele lange iri ke teke, ");
INSERT INTO uvl_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“A longo ke nek. Tai haka lala nge Ierusalem lokoi, pe lape te tung heke Non Tuna lange tunginga ana hana mur aria soksoke ngana mur, pe hotonga ana hetoronga mur. Pe lape te tuahit ana ke te teke mete. ");
INSERT INTO uvl_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Pe lape te tunge I lange hana lomonmona ngana mur ke te songlele ule, pe te heon heke I nga manga toto ke mete. Pe nga etue mol ngana lape maul haka mule!” ");
INSERT INTO uvl_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Ol pe ne Sepeti nehei pe tutuna mur nai tela nge Iesus. Pe hei neu tualou sio nga Iesus matana pe onteia Iesus ke teke Iesus poia ute lange i. ");
INSERT INTO uvl_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Pe Iesus onteia hei neu ke teke, “Lemem taua utar nge Iau?” Pe hei neu hele, “Nga etue nenge ta tutu nga lem naualanga pe nekinga, o talue tutuk mur nai nei ke elle kila nga ilim hele nenga pen tamalmal, pe e nga ilim hele nenga pen hoihoi.” ");
INSERT INTO uvl_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Ol pe Iesus hele, “Imo a eteia ute e ero. A ontei pulut rara mana iam. Nakumo nge a inia ure ehech ngana nga eulinga nenge lape e ininia nei kai?” Pe iri nai te hele, “Oe! Nakumem nge mo inia la.” ");
INSERT INTO uvl_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Pe Iesus hele lange iri ke teke, “Iok, urana pe nenge amo e at ke kila nga ilik hele nenga pen tamalmal pe amo e nga hoihoi, nem Iau lek nge e hele teu ia la ero. Temek i sipona lape hele teu langa nem. Iange iri nenge Temek hesilei hote iri lo, iri laka reria arenga nemur.” ");
INSERT INTO uvl_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Iesus nena hana analoch neu te longe pekngaria nai neu nge te poi ke mau pe leteria inin tau tote iri. ");
INSERT INTO uvl_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Ol pe Iesus eukiraua iri pe hele lange iri ke teke, “Imo a eteia lo ke hana lomonmona ngana aria soksoke ngana mur, lemeria toto ke te eteiteia reria kerkerenga lala nge hehei pe hana. ");
INSERT INTO uvl_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Pe imo, apoi ke pomam ero. Pe nenge teke amo e nge imo teke lohot ke i palaungana, talsio tote i pe ume nge imo mukam. ");
INSERT INTO uvl_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Pe mele nenge teke i muka toto nge imo, talsue i ke ume mana nge imo mukam. ");
INSERT INTO uvl_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Ke pomalam mana nge Non Tuna. I, at nga ich nei ke hehei pe hana te ume nge I ero. At pe ume ke halaua hehei pe hana. Pe pule takisia melmelenga ke mete ke hemasia hulua halang nga reria poinga poreke ngana mur.” ");
INSERT INTO uvl_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Iok, Iesus iri ul nena hana mur te lohaka nge Ieriko pe hulua halang te nanasia I. ");
INSERT INTO uvl_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Pe hana nai nge mataria hit te arare nga kue ilina. Te arare pe te longe nge te teke Iesus kou lopar toto aria ke lala neu lo. Ol pe te alngaria haka ke te teke, “Non Soke! Ne Teuit tuna, letem poreke ia imem!” ");
INSERT INTO uvl_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Pe hulua nemur te keres taua iri ke te teke te reng. Pe ero, iri nai alngaria haka ke soke toto ol, “Non Soke, ne Teuit tuna, letem poreke ia imem!” ");
INSERT INTO uvl_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Ol pe Iesus mes sapele pe onteia iri nai, “Imo nai lememo taua utar nge Iau?” ");
INSERT INTO uvl_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Pe iri nai te hele, “Mo teke o hemasia imem ke mo nau mule.” ");
INSERT INTO uvl_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Iesus letena ia iri pe tal heke penna langa iri nai mataria. Pe ueiuei mana iri nai mataria charchara pe tenau mule sapele. Ke het pe te nanasia Iesus ke tela. ");
INSERT INTO uvl_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Iok, tei ke ramaria lange Ierusalem pe la te lohot nga hengene nenge Oliua nga kileng nenge Petpage. Ol pe Iesus kulosia nena hana mur nai ");
INSERT INTO uvl_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","pe hele lange iri ke teke, “Imo a muka langa kileng nenge ta naue lala neu pe a esia tongki e nge te kale hite ke iri nai tuna te mes. Pe a une rur nge iri pe a mene iri at nge Iau. ");
INSERT INTO uvl_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Pe nenge teke none poi helenga lange imo, a hele lange i ke a teke, ‘Non Soke lemene taua iri ke poi ana ume ia mukam.’ Pomalam, non nem lape tung sapele tongki nai nem lange imo.” ");
INSERT INTO uvl_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Ure nei lohot ke pete tote hetatalonga e nena helenga nge poia nge nike toto ke teke: ");
INSERT INTO uvl_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“A hele hote helenga nei lange hehei pe hana nge Saion, ‘A esia lo, amo Non Soke kou are haka nga tongki, nga tongki lomele ngana ke atat neu. Pe ngana tano mana ke manga none nge pingana iuiu ero.’” ");
INSERT INTO uvl_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Iok laol, hana nai neu tela pe te poia ure lochloch ngana ke manga Iesus heleia lange iri. ");
INSERT INTO uvl_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Pe te mene tongki hei ngana neu luluch nge tuna. Pe te poi hote reria hengeron nenge hot ana pe te pallou heke nga tongki nemur patangaria ke Iesus are haka ia. ");
INSERT INTO uvl_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Pe hulua halang toto te lung ole reria hengeron mur nga kue. Pe hel te ringa ke te paria ae perperna luluche ina mur ke tetal sio ole nga kue pule. ");
INSERT INTO uvl_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Pe hulua nenge iri mukmuka nge Iesus pe hulua nenge iri hoena, iri lochloch te makul haka pe te hele, “Ta iech pe ta heto haka tote ne Teuit Tuna! NeHalang pete tote i, iange at nga Non Soke ene! Ta iech pe ta heto haka tote NeHalang nga lut nga tapa, iange mene mule ita lo!” ");
INSERT INTO uvl_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Iesus i teu nga kileng nenge Ierusalem pe iechinga palaungana lohot. Pe te ontei rara ke te teke, “Non tei toto nenge nei mai?” ");
INSERT INTO uvl_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Pe hulua te tuacholia ke te teke, “Ne Iesus nenge I hetatalonga! Ana non at nge Kalelea nga kileng nenge Nasaret.” ");
INSERT INTO uvl_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Ke ulo pe Iesus iteu la sapele nga NeHalang nena pele palaungana pe lope hote hehei pe hana nenge tei alala nga pele neu letena. Pe hekale hul sue hatanga nenge te hetata umtutuna ia. Pe lange iri nenge te laia ngie chaulum mur pe hesochare sue reria arenga mur. ");
INSERT INTO uvl_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Pe hele lange iri ke teke, “Helenga nenge tehas sue nga NeHalang na alalaha hele ke teke, ‘Lape te hetue lek pele ke hetalaulaunga ana pele.’ Pe imo a poia ke manga kemenge kina mur reria pele toto.” ");
INSERT INTO uvl_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Ol pe iri nenge mataria hit pe nenge aperia lul, tela nge Iesus nga NeHalang na pele palaungana neu letena pe Iesus hemasmasia iri. ");
INSERT INTO uvl_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Iesus poia ure urana ngana nemur pe aina kinkino ngana te makul hakaka ke te teke, “Ta iech pe ta heto haka tote ne Teuit Tuna.” Pe ure nemur poia tunginga ana hana mur aria soksoke ngana mur pe hotonga ana hetoronga mur ke leteria inin toto. ");
INSERT INTO uvl_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Ol pe te onteia Iesus, “Aina kinkino ngana nemur mau te hele ke merechre mau? O longe pule?” Pe Iesus hele, “Oe e longe pule la. Pe nga NeHalang na helenga nenge tehas sue ke ulolo, hele ke teke, “‘Iong sipom o hetore aina kinkino ngana pe mamau mur ke te heto heke iong.’” Ol pe Iesus ontei mule iri, “Imo nge a sisia nei ero kura kai?” ");
INSERT INTO uvl_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Ke het pe Iesus lohaka pe i hot sapele nga kileng neu ke lange Petani pe tu ke ana miliko elle. ");
INSERT INTO uvl_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Pe nga uach uruna toto, Iesus i ke la mulmule nge Ierusalem pe mete ana. ");
INSERT INTO uvl_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Pe esia popi tana e nge mes nga kue ilina. Ol pe teke la ke nau pe popi tana neu nganangana ero. Mes mana ia ina. Pomalam heleia popi tana neu ke teke, “Lape o rora mule ero ol!” Ueiuei mana pe popi tana neu kalum sapele. ");
INSERT INTO uvl_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Pe Iesus nena hana mur te esia ke mau pe ngaria lohot toto, pe te onteia Iesus ke pomai, “Pomere nenge popi tana nei kalum ke ueiuei mana mai?” ");
INSERT INTO uvl_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Pe Iesus tuacholia ke teke, “E hele ke manmanna toto lange imo, nenge teke letemo manmanna pe letemo nachnai ero, poinga nenge e poia langa popi nem, imo nakumo nge a poia pule. Nem pe a hele langa hengene neu ke a teke, ‘O lohaka nga lamam pe ola ke o losio teu nga ruach.’ Pe imo anau, ure nem lohot la. ");
INSERT INTO uvl_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Nenge teke letemo manmanna pe a hetalaulau, ure nemur nenge a hetalaulau ia lape te lohot ke manmanna.” ");
INSERT INTO uvl_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Iok, Iesus i teu langa NeHalang na pele palaungana letena pe hetottoro. Pe tunginga ana hana mur aria soksoke ngana mur pe hana nenge iri mukmuka nge hehei pe hana, tela nge I pe te onteia I ke pomai, “Iong mam o mene lem kerkerenga langai toto nenge o popoia ure nemur? Pe itei toto nenge tunge kerkerenga nem lange Iong?” ");
INSERT INTO uvl_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Pe Iesus hele lange iri ke teke, “Iau pule lape e onteia imo nga onteinga e pule. Pe nenge teke a tuacholia, lape e tuacholia lemo pule. Pe e hele hote kerkerenga nenge e poi hohote ure nemur. ");
INSERT INTO uvl_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Iok, a hele at nge Iau. Ioanes nenge henunun henune hehei pe hana. Pe henuninga nem at langai? At nga lut nga tapa ma at nge none mana nga ich nei?” Pe hana nemur te hele tele helia nge iri ke te teke, “Nenge teke ta hele ke ta teke, ‘Ure nem at nga lut nga tapa.’ I lape ontei mule ita ke mai, ‘Iok, pe pomere letemo manmanna nge i ero?’ ");
INSERT INTO uvl_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Pe nenge teke ta hele ke ta teke, ‘Ure nem at nge none mana,’ ta matau ala ara nge hehei pe hana pule. Iange iri lochloch leteria kerkereng toto lo nge Ioanes i hetatalonga.” ");
INSERT INTO uvl_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Pomalam te tuacholia Iesus na helenga ke te teke, “Mo eteia ero i.” Ol pe Iesus hele, “Ke pomalam Iau pule lape e hele hote lek kerkerenga nei lange imo ero.” ");
INSERT INTO uvl_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“Iok, imo letemo ma ke merei nga nei? None tutuna mur iri nai. Ana non lange tuna nenge soke pe hele, ‘Kolek, teke poi pe ola ke o ume nga uain ana late heueu.’ ");
INSERT INTO uvl_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","“Pe tuna neu hele, ‘Ah! Lemek ero i!’ Pe nga hoena letena hul mule pe i ke langa ume. ");
INSERT INTO uvl_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","“Iok, non neu lange tuna nenge kino pe hele, ‘Kolek, teke poi pe ola ke o ume nga uain ana late.’ Pe kon neu hele, ‘Oe temek, ela ke e ume heueu kura.’ Pe ero. I hele mana pe la ke ume ero. ");
INSERT INTO uvl_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","“Itei nge iri nai nanas taua temeria lemene ngana?” Pe hana nemur te hele, “Ngana laka tuna nenge soke.” Ol pe Iesus hele lange iri ke teke, “E hele lange imo pengpeng, iri nenge te lololoch umtutuna pe salaunga kina mur, lape iri muka nge imo ke teteu tala langa NeHalang nena naualanga pe nekinga. ");
INSERT INTO uvl_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Iange Ioanes at ke hetore imo nga kue nenge pengpeng toto ke a nanasia. Pe imo letemo manmanna nge i ero. Pe iri nenge te lololoch umtutuna pe salaulaunga kina mur leteria manmanna nge i. Pe imo, a esia iri nge te poi ke pomau pe a hulia letemo ero pe letemo manmanna ero pule.” ");
INSERT INTO uvl_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Iok, Iesus hele lange hana papalauna nemur ke teke, “A longo at nga lek helekinga ala nei pule. Nga etuene none tue uain nga nena ich unne. Ke het pe haua ana mapuo ke liuliu tom. Pe nga ume neu letena, non neu selia polo e ke uain nganangana ana nenge te pip hotote eina. Pe pule umeia pele sase ngana e ke iri nenge tenau elele ume neu te tutu ia. Ke het tunge ume neu ke langa hana hel peria ke tenau ele, pe i lohaka ke langa kileng tau ngana e. ");
INSERT INTO uvl_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Iok, nga etue nenge uain nganangana te mera, non neu kulosia nena hana mur lange hana nenge tenau elele ume neu, ke te mene nena uain nganangana mur pe te takisia lange i. ");
INSERT INTO uvl_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","“Pe ero. Tela pe hana nemur te sihe iri. Elle te pal hulu hite. Pe elle, te tamalia ana um. Pe elle, te hune ke mete. ");
INSERT INTO uvl_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Ol pe ume tokoninga neu kulosia nena hana mur hel ke tela pule. Neu ol, iri halang te lohaka ke tela. Tela pe hana nemur te poia iri ke pomau mana pule. ");
INSERT INTO uvl_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Ol pe nga hoena ume tokoninga neu kulosia i sipona tuna ke la ol. Pe hele, ‘Hana nemur, lape te poi nek lange i ol.’ ");
INSERT INTO uvl_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","“Pe ero. Hana nemur te esia ume tokoninga tuna nge atat pe te hele, ‘Ume tokoninga tuna la atat nem. Pe i nge lape mene temene nena ure mur lochloch laka. Ta hune i ke mete nike. Pomalam lape ta mene ure lochloch ngana nemur ke rera ia ol.’ ");
INSERT INTO uvl_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Iok laol, te laua i pe tesau hote i langa mapuo rumena, pe te hune i ke mete. ");
INSERT INTO uvl_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","“Iok, ume tokoninga neu i sipona la ol. Pe lape poia hana nemur ke merei?” ");
INSERT INTO uvl_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Pe hana nemur te hele, “Non nem lape at pe heporeke tote hana porekreke ngana nemur. Pe lape tunge ume nem lange mele hel nge altoto ke tenau ele pule. Pe nga etue nenge ume nem mera sio, hana nemur te lule pe te tunge lange ume tokoninga neu.” ");
INSERT INTO uvl_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Pe Iesus hele lange iri, “Imo nge a sisis nga NeHalang na helenga ero kai? Nenge hele ke teke; “‘Hana nenge te hemesmes pele te teke um e poreke pe tesau hote. Pe heueu nei, um nem lohot ke i um kerkereng ngana nenge ratua hele pele. Ure nei Non Soke i sipona poia ke lohot pe i urana toto nga matara.’ ");
INSERT INTO uvl_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Ke pomalam e hele lange imo. NeHalang lape piu hele nena naualanga pe nekinga ana kileng nge imo. Pe iri nenge te hulia leteria pe te longo taua nena helenga mur mana, lape teteu langa kileng neu. ");
INSERT INTO uvl_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Pe mele nenge losio haka nga um nem lape singina uch hulu ke het. Pe nenge teke um nem losio haka nge mele, mele nem menret sapele.” ");
INSERT INTO uvl_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Pe Paresio mur pe hana papalauna nemur te longe Iesus nena helenga mur pe te etei mellehe mene ke te teke Iesus helele ia iri. ");
INSERT INTO uvl_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Pomalam te tango rara kue e nge te teke te sihe I. Pe ero, iange te mataua hulua nemur. Iange hulua nemur leteria manmanna toto ke te teke Iesus I hetatalonga. ");
INSERT INTO uvl_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Pe Iesus nana mule nga helenga opene e pule ke mai, ");
INSERT INTO uvl_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“NeHalang nena naualanga pe nekinga nga lut nga tapa, pomalaka nge naungaala ana none nge popoia ngaunga unne nge tuna nenge lei heueu ngana. ");
INSERT INTO uvl_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Pe non palau nem hekulo mele hel aria lo ke tela nga ngaunga matana nem. Iok, kulosia hana nenge te umume nge i ke tela taua iri ke la te ngau, pe hana nemur lemeria ero. ");
INSERT INTO uvl_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","“Ol pe ana non kulosia nena hana mur hel pule pe hele lange iri ke teke, ‘Ala pe a hele lange iri nenge e hekulo aria nem ke e teke teat nga ngaunga nei ol, iange ngaunga kalum lo. A hele ke a teke palngen hel koi e ruruke iri lo, pe ure lochloch ngana e tatalo ele ke het lo. Pe teat ke te ngau mana ol!’ ");
INSERT INTO uvl_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","“Pe ero. Hana nemur te longo tau ero nge tela nga ngaunga matana neu. Tei ke tela nga lemeria ngana mana. Hel te takis selempo pe kakop ke teii, pe hel te lala nga aria ume mur nenge te menmene umtutuna ia. ");
INSERT INTO uvl_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Pe hel te laua non palau neu nena hana nemur pe te pal hulu hite iri pe te hune iri. ");
INSERT INTO uvl_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Ol pe non palau neu letena inin pe kulosia nena palinga hel ana hana mur ke te hun lapue hana nenge te hun neu, pe te tonoi heke reria pele mur pe kileng tana neu ngau lala ke het. ");
INSERT INTO uvl_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","“Pe hele lange nena hana mur nenge tetu neu ol ke teke, ‘Ngaunga matana nenga puongatau nei, e tatalo ele ke het lo. Pe iri nenge e hekulo aria teat ero iange te urana ero. ");
INSERT INTO uvl_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Pomalam ala ke a mes ele kue matana mur lochloch pe anau rara mele hel pe a hele lange iri ke teat nga ngaunga matana nei.’ ");
INSERT INTO uvl_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Iok laol, hana nemur tela pe te iua hana nge halang toto. Pe te mene hana nenge te urana pe nenge te poreke ke teat pule. Pe pele nenge te poi ngaunga matana neu ia, muta toto ia lang mur. ");
INSERT INTO uvl_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Iok laol, non palau neu i teu at sapele. At pe esia none nge heronia hengeron nenge ngaunga matana ana ia ero. ");
INSERT INTO uvl_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Ol pe hele, ‘Kole, o teu at lamai ke mere, nenge o heronia lem hengeron nenge ngaunga matana ana ero?’ Pe non neu na helenga ero pe reng mana. ");
INSERT INTO uvl_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","“Ol pe non palau neu hele lange nena hana mur, ‘A kale hite non nei penna pe apena pe a sau hote i langa kileng au ngana nge hot. Nga kileng nenge te amneia melmelenga pe te tangtang pe ngingiria chatrekreke ia.’ ");
INSERT INTO uvl_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","“Ke ngana laka nenge e hele ke e teke, ‘NeHalang iua hulua halang, pe hesilei hote hel mana ke teteu la.’” ");
INSERT INTO uvl_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Iok laol, Paresio mur aria papalauna mur tetal helenga ke te teke te tuamirik hote Iesus, ke heleia helenga poreke ngana e. ");
INSERT INTO uvl_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Pomalam te kulosia reria hana hel pe ne Herot nena hana hel pule ke tela nge Iesus pe te hele, “Hetoronga, imem mo eteia ke Iong o pallaklaka erochro. O hetottore ure nge manmanna nga NeHalang na poinga lala nge hehei pe hana. Pe lem poinga elle mana ke lange hulua lochloch. Nge iri nenge pingaria iuiu pe iri nenge pingaria iuiu ero pule. ");
INSERT INTO uvl_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Iok, o hele hote letem at nge imem. I mai urana nge ta sau umtutuna lange ne Kaesa pule kai? Ma ero?” ");
INSERT INTO uvl_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Pe Iesus eteia ke hana nemur leteria tuanin ngana mur te poreke lochloch. Pe hele, “Imo mam, a pallaklaka manmana iam! Pomerei nenge a teke a tuamirik hote Iau? ");
INSERT INTO uvl_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","A hetei hote lemo umtutuna nenge a sausaua ke enau.” Ol pe te mene hote umtuna elle pe te heteia lange Iesus. ");
INSERT INTO uvl_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Pe Iesus ontei mule iri, “Itei toto opene pe ene nenge ma haka nga umtutuna nei mai?” ");
INSERT INTO uvl_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Pe iri te hele, “Ne Kaesa.” Pe Iesus hele, “Ure nemur nenge ne Kaesa nena, a tung mule iri lange ne Kaesa. Pe ure nemur nenge NeHalang nena, a tung mule iri lange NeHalang.” ");
INSERT INTO uvl_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Hana nemur te longe Iesus na helenga pe ngaria lohot. Pomalam te lohaka mana pe tei ke tela. ");
INSERT INTO uvl_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Iok, Satiusi mur leteria manmanna ero nga nenge ta metmete pe ta maul haka mulmule nga metenga. Pomalam nga etue nem mana tela nge Iesus pe te onteia I ke te teke, ");
INSERT INTO uvl_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Hetoronga, ne Moses has sue nga alalaha ke teke, nenge teke none lei pe tutuna mur ero pe mete hatalia nehei, non nenge mete nem tina e lape lei haka mule metenga hatal nem. Pe iri nai tuturia mur, lape te heleia ke te teke, non nenge mete nem tutuna mur ia iri. ");
INSERT INTO uvl_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Nga etuene e, hana iri rahtele nai nge titiria mur hel. Tiria nenge soke lei pe tutuna mur ero kura pe mete mule. ");
INSERT INTO uvl_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Pe tiria neingana lei heke mule metenga hatal neu pe mete pule. Iok, tiria mol ngana pule poi ke pomalam ke la het nge tiria rahtele nai ngana. ");
INSERT INTO uvl_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Pe nga hoena ol, hei neu mete. ");
INSERT INTO uvl_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Iok, o hele at nge imem. Hana nemur iri lochloch ke te leia hei neu pe te mete. Pe hei neu pule mete. Pe nga etue nenge te maul haka mule nga metenga, itei toto lape nehei mule ia ol?” ");
INSERT INTO uvl_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Pe Iesus hele, “Nakuna nenge imo a eteia NeHalang nena helenga mur ero, pe a eteia na kerkerenga ero toto pule. Ke ngana laka nenge a tung hot pulut mene helenga nem. ");
INSERT INTO uvl_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Nga etue nenge hehei pe hana te maul haka mule nga metenga, lape tetu mana ke pomange angkelo mur nga lut nga tapa, pe te lei hel mule ero ol. ");
INSERT INTO uvl_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Pe nenga maulinga haka mule nga metenga nem, NeHalang hele lange imo lo. Pe imo mai, lape a sisia ero kura kai? NeHalang hele lange imo ke teke, ");
INSERT INTO uvl_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Iau NeHalang. ne Apraham pe ne Isak pe ne Iakop aria Soke Iau.’” Pe Iesus heloloune na helenga pe hele, “Iri nenge aria Soke NeHalang, ngana laka, iri nenge te maulul. Pe iri nenge te maulul ero, aria Soke NeHalang ero.” ");
INSERT INTO uvl_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Hengetoro nenge Iesus poia neu, hehei pe hana te longe pe ngaria lohotia. ");
INSERT INTO uvl_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Iok, Paresio mur te longe nge te teke Iesus pal mete tote Satiusi mur rea oan ke reria helenga ero. Pomalam te eu hel ke muria elle. ");
INSERT INTO uvl_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Pe elle nge iri etei teu la toto nga hotonga nenge Moses. Ana non teke tuamirik hote Iesus pe poia onteinga nenge teke, ");
INSERT INTO uvl_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Hetoronga, o amnei teu nga NeHalang nena hotonga nemur. Hotonga tei toto nge palaungana nge iri lochloch?” ");
INSERT INTO uvl_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Pe Iesus hele, “‘Mutemo taua NeHalang ara Soke nga kakahomo mur lochloch, pe mutemo taua I nga opemo mur lochloch, pe mutemo taua I nga letemo tuanin ngana mur lochloch.’ ");
INSERT INTO uvl_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Ke hotonga nenge palaungana toto nga hotonga mur lochloch koi nei. ");
INSERT INTO uvl_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Pe neingana nenge palaungana toto pule, ngana laka nenge: ‘Mutem taua neingam e nenge tu rochroi nge iong, ke pomanga mutem tau mule iong sipom.’ ");
INSERT INTO uvl_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Hotonga nemur nenge Moses pe alalaha nemur nenge hetatalonga mur tehas ia, kiria toto koi hotonga nai nei.” ");
INSERT INTO uvl_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Iok, Paresio mur te mes ke muria elle kura pe Iesus onteia iri ke teke, ");
INSERT INTO uvl_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Letemo tuanin ngana ma ke merei nge I nenge ene Kristus? Pe non tei tuna toto?” Pe iri te hele, “Ne Teuit Tuna laka nenge ene Kristus.” ");
INSERT INTO uvl_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Ol pe Iesus hele lange iri ke teke, “Iok, pe pomere nenge Opepengpeng poia ne Teuit ke hetue Non nem ke I Non Soke? Nenge ne Teuit hele ke teke, ");
INSERT INTO uvl_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","“NeHalang hele lange ak Non Soke ke pomai, ‘O are lakoi nga perik hele nenga pen tamalmal, pe e mene lem ngarang mur ke etal sue iri pe apem hepapar hitite iri.’ ");
INSERT INTO uvl_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","A esia lo, Non nem, ne Teuit hetue I ke ana Soke ia. Pe pomere nenge Non nem lohot ke I ne Teuit tuna mule?” ");
INSERT INTO uvl_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Iesus onteia Paresio nemur ke mau pe te tuacholia I ero toto. Ke talun nga etue neu pengpeng, te matau nge te poi onteinga la mule nge Iesus ol. ");
INSERT INTO uvl_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Ol pe Iesus hele lange hulua nemur pe nena hana mur ke teke, ");
INSERT INTO uvl_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Paresio mur pe hotonga ana hetoronga mur te mene Moses munna ke te hetottoro pe te hele ururume NeHalang nena hotonga mur. ");
INSERT INTO uvl_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Ke nenge teke te hele lange imo nga utar, a longo tau mana pe a poia. Pe reria poinga mur mana, a nanasia ero toto. Iange te hetottoro pe iri siporia te nanasia te hetoro ngaria ero toto. ");
INSERT INTO uvl_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Pe te poia hehei pe hana ke te amneia melmelenga halang, nga hotonga hel nenge iri siporia tetal hote. Pe iri te halau polia hehei pe hana ero toto nga melmelenga nemur. ");
INSERT INTO uvl_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","“Ure lochloch ngana nenge te popoia, te teke te poi heteinga ana mana ia. Ke te kale heke NeHalang nena helenga chorchorna mur nga ramaria pe nga peria pe te hemallaha hot tote ure nemur. Pe pule te kale rur sasase ngana nga reria hengeron mur. ");
INSERT INTO uvl_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Pe te kau toto elele arenga mur nga ngaunga matana. Pe nga pele hetoronga letena, te teke te kila manmana nga muka ke kokoes. ");
INSERT INTO uvl_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Pe muteria tau tote poinga nenge hehei pe hana te apala lange iri ke nek toto nga ingala matana. Pe te teke hehei pe hana te hetue iri ke iri hetoronga ana hana mur. ");
INSERT INTO uvl_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Pe imo, a teke te hetue imo ke pomau ero. Iange imo amo hetoronga elle mana. Pe imo lochloch titimo mur hel. ");
INSERT INTO uvl_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Pe a hetue mele nga ich nei ke tememo ia ero. Iange imo tememo elle mana. Ngana kou tu nga lut nga tapa. ");
INSERT INTO uvl_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Pe a poia hana pe hehei ke te hetue imo ke ‘Hetoronga’ ero iange imo amo Hetoronga laka Kristus I toro. ");
INSERT INTO uvl_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ke mele nenge umume nge imo lape lohot ke i non palaungana. ");
INSERT INTO uvl_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Iange mele nenge tal hekeke i lape tetal sue i, pe mele nenge talsio menmene i lape tetal heke tote i. ");
INSERT INTO uvl_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Pe imo Paresio mur pe imo hotonga ana hetoronga nemur, a neknek ia imo iange amo hengetau nachnai hali. A hetoro kokoua hehei pe hana pe a piu hele piunga nge iri, nga NeHalang nena naualanga pe nekinga nga tapa. Atong mur te teke teteu la toto nga kileng nem. Pe imo apoi helele iri. Pe lape ateu la ero toto ol.  ");
INSERT INTO uvl_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","“Pe imo Paresio mur pe imo hotonga ana hetoronga nemur, a neknek ia imo iange amo hengetau nachnai hali. A chananga ia hehei pakar mur ke a lolochia reria pele mur. Pe pule a hetalaulau ke sase toto nga hulua mataria. Pomalam, lape amo tuangachol poreke toto ol! ");
INSERT INTO uvl_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Pe imo Paresio mur pe imo hotonga ana hetoronga nemur, a neknek ia imo iange amo hengetau nach nai hali. Iange ai ke ala nga ich hel pe a mana nga ruach ke ala nga kileng hel ke a tango rara hana. Pe lape a mene none pe a poia i ke nanas tau pengpeng ia lemo poinga mur. Pe lape na poinga poreke ngana, ristoto mule imo lemo poinga poreke ngana mur pe la ke poreke toto ol. ");
INSERT INTO uvl_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Pe a neknek ia imo pule. Iange matamo hit pe a teke a henonoua hehei pe hana nga kue. A hetottore hehei pe hana ke a teke, nenge teke mele hekerkereng tote na helenga pe hele ke kerkereng toto nga NeHalang na pele, imo a heit kou sio mene pe a teke ute pele ero nga helenga nem. Pe nenge teke mele hekerkereng tote na helenga pe hele ke kerkereng toto nga um chalemlem ngana (gol) nenge ma teu nga NeHalang nena pele letena, nem a teke poia nena helenga ke kerkereng toto. ");
INSERT INTO uvl_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Imo letemo mallaha ero pe a etei teu langa NeHalang nena poinga mur ero toto. Ure tei nge palaungana toto? Ngana kau um chalemlem ngana nenge uruna haka neu mau? Iau e teke NeHalang na pele, iange pele nem poia ure nem ke heo ngana toto. ");
INSERT INTO uvl_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Pe imo a hele pule ke a teke, ‘Nenge teke mele teke hekerkereng tote na helenga pe hele ke kerkereng toto nga hatanga, nem a teke ute pele ero pule. Pe nenge teke mele heleia tunginga mur nenge tema haka nga hatanga nem, a teke ana ure toto ol la. Pe a teke letena matana hite nena helenga kerkereng ngana nem ke nek.’ ");
INSERT INTO uvl_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Imo nge matamo hit toto lo iam. Ure tei nge palaungana toto? Ngana kau tunginga neu mau? Iau e teke hatanga nem, iange hatanga nem poia tunginga nem ke heo ngana toto. ");
INSERT INTO uvl_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Mele nenge poia helenga kerkereng ngana nga hatanga nem, poia langa ure lochloch ngana nenge tema haka nga hatanga ona pule. ");
INSERT INTO uvl_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Pe mele nenge poia helenga kerkereng toto ngana nga NeHalang na pele, poia lange mele nenge tu teu nga pele nem pule. ");
INSERT INTO uvl_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Pe mele nenge poia helenga kerkereng ngana e langa tapa, poia langa NeHalang nena arenga nenge heo ngana toto. Pe pule poia lange I nenge kila nga arenga nem. ");
INSERT INTO uvl_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Ke imo Paresio mur pe hotonga ana hetoronga mur, a neknek ia imo pule iange amo hengetau nach nai. Nga ure lochloch ngana nenge a menmene iri pe ngaunga kinkino ngana mur nga ume, a tunge ke huna elle nge iri analoch lala nge NeHalang. Pe pomerei lememo ero nge a nanasia hengetoro palaungana nenga hotonga nenge helele ia; poinga nge pengpeng, pe poinga nenge letem poreke ia mele, pe poinga nenga letem manmanna ngana? Ure nemur nenge toinge apoi tettele iri koi nemur, pomalam lape a la nga kinkino ngana pe a nanasia ke nek pule. ");
INSERT INTO uvl_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Imo nge letemo mallaha ero mana iam. A poi ke malaka nga none nge sul hote lango e nge mateu nga ana ech kina ke lasus pe in teua kamel palaungana e. ");
INSERT INTO uvl_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Pe a neknek ia imo pule. Imo Paresio mur pe hotonga ana hetoronga mur. Iange amo hengetau nach nai hali. A teke a helemlem heke mene singimo nge hot. Pe letemo nge teu muta ia poinga poreke ngana mur lochloch. ");
INSERT INTO uvl_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Imo Paresio nemur matamo hit toto. Toinge a lomo hot tele kou letemo nge teu, laka singimo nge hot lape lemlem pule. ");
INSERT INTO uvl_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Pe a neknek ia imo pule. Iange apoi ke pomalaka nga polo e nge te alohit pum ia. Pe te hepore nge hot ke hussu pe nakuna urana mana. Pe nge teu mele nenge mete neu kina pe ure nemur nenge inangaria has, te maia. ");
INSERT INTO uvl_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Pe imo apoi ke pomalam toto. Nga singimo nge hot, nakumo pomanga hana nemur nenge te pengpeng toto. Pe letemo nge teu muta ia poinga poreke ngana mur, pe a channanga ele menmene imo. ");
INSERT INTO uvl_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Pe a nauala amo ke nek pule. Iange a ume heke polo mur pe a hemalmalia hetatalonga mur pe hana nenge te pengpeng toto aria polo. Pe hana nemur, lemo tete mur te hune iri nge nike. ");
INSERT INTO uvl_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Pe a hele ke a teke, ‘Toinge tatu nga rera tete mur aria etue nike, lape ta koko nge iri ero nike ke ta hune hetatalonga nemur.’ ");
INSERT INTO uvl_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Pe nga poinga nem, a henonou hot pengpeng ia ke imo alomo mur pengpeng laka te hune hana nemur. ");
INSERT INTO uvl_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Pomalam, a heulo hot tote ol! A heulo hot tote poinga poreke ngana nemur nenge lemo tete mur te talune nge nike lo! ");
INSERT INTO uvl_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“Nakumo manga ilimo! Ilimo nenge hunun tutuna mur laka imo! Pe NeHalang lape sau sue imo ke ala nga oan ngingina ngana. Pe lape a ua ke merei? ");
INSERT INTO uvl_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Pe lape e kulosia hetatalonga mur pe hana nenge te etei tote ure mur pe pule hetoronga mur nga hotonga nenge Moses ke tela nge imo. Pe hel nge iri lape a hune iri pe a heon heke iri nga manga toto. Pe hel lape a palia iri nga hengetoro ana pele pe lape a lope iri ke tela nga kileng pe kileng. ");
INSERT INTO uvl_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Ke pomalam, lape a etei tote nge imo sipomo a poia poinga poreke ngana nemur. Nenge a hune hana nenge te pengpeng toto nga ich nei. A talune nge Abel ke lange ne Perekia tuna Sakarias, nenge a hune nga NeHalang na pele pe hatanga tunangana. Ke imo lape singimo meena mana ia poinga nenge a poia nei. ");
INSERT INTO uvl_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Pe e hele lange imo pengpeng, poinga poreke ngana nemur ana tuangachol lape lohot nge imo hehei pe hana nenga etue nei. ");
INSERT INTO uvl_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Auoh! Kileng nge Ierusalem o! Lem hana mur te hun lapue hetatalonga mur pe te tamal hune iri nenge NeHalang kulosia iri lange iong. Kokoeses e teke e eukirauraua tutum mur ke manga pareo hei ngana nenge eukirau teua tutuna mur nga sahana ene. Pe iong lemem ero. ");
INSERT INTO uvl_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Ol pe lape lem pele ngana ngana ero ol. Lape tu mana ol. ");
INSERT INTO uvl_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Pe e hele lange iong pengpeng, lape o nau mule Iau ero ol ke la het nga etue nenge o hele ke o teke, ‘NeHalang poi ke urana toto lange I nenge at nga Non Soke ene.’” ");
INSERT INTO uvl_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Iok laol, Iesus i hot nga NeHalang na tuele ke teke lala lo, pe nena hana mur tela nge I ke te teke te henonou mule I langa pele mur. Pe te hele, “O nau la mule nga pele pane mur, nakuria urana mana.” ");
INSERT INTO uvl_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Pe Iesus hele, “Oe, pe pele nenge a esesia iri nem lape te heporeke iri. Pe um nemur nenge te lung heke iri nem lape te sisparai sio hulu.” ");
INSERT INTO uvl_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Iok, Iesus arare nga hengene nge Oliua pe nena hana mur tela kome mana nge I pe te ontei hote I ke pomai, “O hele hot lemem. Ure nem lape lohot nge ngingie? Pe utar nge lape lohot tala ke mo nau hilia oat mule ngam pe ich nei hetala toto ngana mai?” ");
INSERT INTO uvl_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Pe Iesus hele, “Imo a nauala amo ke nek, iange lape mele hel te channanga rere mene imo. ");
INSERT INTO uvl_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Iri halang lape tela nge imo pe te hetue ek, pe te channanga rere mene hehei pe hana ke te teke, ‘Iau Kristus koloi, Non nenge NeHalang kulosia at ke mene mule hehei pe hana.’ ");
INSERT INTO uvl_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Pe imo lape a longe nananga mur nga hunelinga palaungana, pe a longe pingana nge sasa ke at. Pe a matau ero. Ure nemur nenge pomam te lohot tattala pe ich nei hetala toto ngana, ngana kou atat kura. ");
INSERT INTO uvl_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Kileng papalauna nai aria mata i helel. Pe tuele kina e teia polong ke tela nga tuele kina e pule. Pe lape uringa lohotot pe mangila rurur nga kileng mur lochloch. ");
INSERT INTO uvl_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Pe ure nemur te lohot ke pomanga hei nenge amneia ana inin nga talun ngana toto nenge tuna sechia i. ");
INSERT INTO uvl_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Iau lek hana mur imo. Pe hulua nga kileng lochloch lape lemeria ero ia imo. Pe lape te laua imo pe a amneia melmelenga palaungana pe te hune imo ke a mete. ");
INSERT INTO uvl_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Pe nga etue nem, hana halang nenge leteria manmanna nge Iau, lape te hile leteria manmanna ngana nem pe lape te poi poreke hel mule nge iri. Pe lape te tung heke mule hel nge iri langa reria ngarang mur peria. ");
INSERT INTO uvl_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Pe hana halang lape te lohaka pe te channanga ke te teke iri hetatalonga mur pe te pallaklaka ia hulua halang. ");
INSERT INTO uvl_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Poinga poreke ngana lape salala hite kileng pe poinga urana ngana lape het sio. ");
INSERT INTO uvl_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Pe mele hel nenge te mes ke kerkereng kela het nga kileng nei hetala toto ngana, lape NeHalang mene iri. ");
INSERT INTO uvl_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Pe helenga urana toto ngana nga NeHalang nena naualanga pe nekinga, lape te hele hote nga kileng lochloch ngana nga ich, ke hehei pe hana lochloch te longe. Ke het pe ich nei hetala toto ngana lohot sapele.” ");
INSERT INTO uvl_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Pe Iesus hele pule ke teke, “Imo lape a naue ure poreke ngana nenge hetatalonga Taniel hele ia nge nike toto lo ke teke, ‘Ure poreke ngana nem mes nga NeHalang na tuele.’ Mele nenge sisia helenga nei letena tuanin hote luna ke nek. ");
INSERT INTO uvl_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Ke nga etue nem, iri nenge tetu nge Iutea te ua ke tela nga hengene mur. ");
INSERT INTO uvl_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Nenge teke otu nga pele ona, otu lola. Pe o teu la mule nga pele letena ke o mene mule ute ero ol. ");
INSERT INTO uvl_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Pe nenge teke otu nga ume, otu lola. Ola mule nga lem pele ke o mene lem hengeron sase ngana ero ol. ");
INSERT INTO uvl_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Nga etue nem, hehei nenge saria pe nenge te lololo peo lape te amneia ke meena toto nge iri. ");
INSERT INTO uvl_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Pomalam a hetalaulau lange NeHalang ke ure nem lohot nga etue lololo ngana ero, pe lohot nga Sapat ana etue ero. ");
INSERT INTO uvl_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Iange melmelenga pe ure meena ngana nenge palaungana toto lape lohot nga etue nem. Pe ure e nge pomam lohot nge nike ero toto, nga ich nei talun ngana nike. Pe nga hoena pule ure palaungana e nge pomai lape lohot ero. ");
INSERT INTO uvl_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Nenge teke NeHalang tom chore etue poreke ngana nem ero, hulua lochloch lape te het. Pe I letena ia nena hana mur nenge hesilei hote iri lo, pomalam tomia etue nem ke choro mana. ");
INSERT INTO uvl_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Nga etue nem, nenge teke mele hele lange imo ke teke, ‘A nau at! Kristus koi! Eh, ero! Ngana pau kou!’ A nau pe poinga nei lohot, letemo manmanna ia ero. ");
INSERT INTO uvl_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Iange hana nenge te channanga ke te teke iri Kristus pe te channanga ke te teke iri hetatalonga mur, lape te lohot ke te poia ure mur nenge te lohot manmana ke halang. Pe lape te teke te channanga ia NeHalang nena hana mur pule. Lape nakuria nge te poia ma ero. ");
INSERT INTO uvl_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","A longo ke nek! Ure nemur te lohot ero kura pe e hele tele lange imo nike. ");
INSERT INTO uvl_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Ke nenge teke mele hele ke teke, ‘Ana non pau kou tunga ich sana lomona,’ a longe helenga nem pe a la ero toto. Nem pe mele hele ke teke, ‘Ana non pai koi talkomkome nga pele pa nei letena.’ Helenga nemur, letemo manmanna ia iri ero. ");
INSERT INTO uvl_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Iange Non Tuna at ngana, pomalaka nga kileng chalem ngana nenge chalem nga chaia matana haka ngana pe tualeme ke la lochloch nga chaia matana puluch sio ngana. ");
INSERT INTO uvl_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Ngie pisou mur te euirau mana nga kileng unne nenge mele nge mete koluna maia.” ");
INSERT INTO uvl_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Iok, Iesus hele pule ke teke, “Nga etue nenge ure meena ngana nemur te lohot ke het, ure meena ngana hel pul lape lohot nenge: “‘Chaia matana au ala mana pe teio tua ero. Itoch mur lape te losio hot nga tapa sana, pe ure kerkereng ngana mur nga tapa sana lape te rur rara pule.’ ");
INSERT INTO uvl_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","“Pe ute lape lohot nga tapa sana nenge henonoua Non Tuna nge lape lohot. Pe mata lochloch ngana nga ich nei lape tenau heke Non Tuna langa ulu nga tapa sana pe te tang. Iange I at luluch nga nena kerkerenga pe hemalmalinga palaungana. ");
INSERT INTO uvl_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Pe lape ngalum paena alngana ke palaungana toto pe Non Tuna kulosia nena angkelo mur ke tela nga kileng lochloch ngana nga ich, ke te mene nena hana mur nenge i sipona hesilei hote iri lo.” ");
INSERT INTO uvl_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Iok, lemek ke e teke a mene hengetoro lakoi nga ae popi tana. Ae nem, nga etue nenge ta esia nge ina hou hot mumule nga perperna mur, ta eteia ke chaia ana etue heroi lo. ");
INSERT INTO uvl_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Pe imo pule apoi ke pomalam. Ke a esia ure nemur nenge te lohotot nei, pe a eteia ke etue nem at rochroi toto lo. ");
INSERT INTO uvl_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Pe e hele ke manmanna toto lange imo. Hehei pe hana nemur nga etue nei lape te mete ero kura pe ure nemur te lohot lochloch lo. ");
INSERT INTO uvl_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Tapa pe ich nei lape te het pe lek helenga hetala ngana ero toto.” ");
INSERT INTO uvl_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Mele pele eteia ero toto, nga etue nem lohot ngana pe nga etue koana tei toto nenge ure nem lape lohotia. Hekulkulonga mur nga lut nga tapa te eteia ero pe Non Tuna eteia ero pule. Temene I toro mana eteia. ");
INSERT INTO uvl_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Pe etue nenge Non Tuna at muleia, pomalaka nga ure nemur nenge te lohot nga etue nenge Noa. ");
INSERT INTO uvl_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Iange nga etue nemur nenge ech taua kileng ero kura, hehei pe hana te ngaungau pe te inin pe te helei helel kela het nga etue nenge Noa iuch teu nga nena imot. ");
INSERT INTO uvl_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Pe iri tetu pulut mana pe te eteia ure nenge lape lohot ero. Ol pe te rura mana pe ech kon haka pe taua iri lochloch ke te het. Ke poinga nem lape lohot mule nga etue nenge Non Tuna at mule ia. ");
INSERT INTO uvl_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Hana nai lape te tutu nga ume, pe lape te ua toto ia elle pe elle mana tu ol. ");
INSERT INTO uvl_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Pe hehei nai te ululo pas, pe lape te ua toto ia elle pe elle mana tu ol. ");
INSERT INTO uvl_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Ke pomalam a tatalo elele imo ke neknek nike. Iange a eteia etue nenge amo Non Soke lape at ia ero. ");
INSERT INTO uvl_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Pe letemo tuanin ia nei ke nek; Teke pele tokoninga e eteia etue nenge non kemenga kina e lape at nga miliko, manmanna toto ke i lape mamani ero pe mese ke nauala ke poi ele non kemenga nem nge at ke palchach teua nena pele. ");
INSERT INTO uvl_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Pe imo apoi ke pomalam pule. Anau ala mana iange a eteia Non Tuna at mule ngana ero.” ");
INSERT INTO uvl_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Itei nge imo hana nenge a umume, nge ramana song ke urana pe poia ume ke nek? I laka nenge ana non soke letena here nge nauele pele, pe tunge nena hekuleileinga mur aria ngaunga nga ngaunga ana etue pengpeng. ");
INSERT INTO uvl_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Nenge teke mele nem ana soke at pe hottaua i nge popoia ana ume ke nek ke pomam, mele nem iech toto. ");
INSERT INTO uvl_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","E hele ke manmanna toto lange imo, non soke nem lape talue mele nem ke nauele nena urelu mur lochloch. ");
INSERT INTO uvl_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Pe nenge teke mele nem i non nge poreke, lape letena tuanin nge i sipona ke teke, ‘Ah! Non soke panem at mule ke ueiuei ero paiam.’ ");
INSERT INTO uvl_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Pe talun ke nos lapue pekngana mur pe popoi ngaunga matana pe in lululuch nge hana porekreke ngana mur. ");
INSERT INTO uvl_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Pe non soke nem lape at mule nga etue nenge non neu kulele i ia ero. ");
INSERT INTO uvl_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","At pe lape chatulu hite pe sau hote i kela tululuch nge hana nenge aria hengetau nachnai hali, nga kileng nenge te tangtang pe ngingiria chatrekreke ia.” ");
INSERT INTO uvl_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Pe nga etue nem NeHalang nena naualanga pe nekinga nga tapa, pomalaka nge hehei malolong mur nge iri analoch. None nge lei heueu ngana teke atat, pe hehei malolong nemur te mene reria lemenge mur pe tela ke tei ele i ke te mene i at. ");
INSERT INTO uvl_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Pe hehei lime nge iri, leteria matana ke nek nga utar nenge lape te poia, pe lime te poi ke pomanga hauaua mur. ");
INSERT INTO uvl_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Ke iri lime nenge te poi ke manga hauaua neu, te mene reria lemenge mur pe te mene rir ana lochngasio ke halang ero. ");
INSERT INTO uvl_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Pe lime nenge leteria matana ke nek, te mene reria rir ana lochngasio ke halang. Iok, tela ");
INSERT INTO uvl_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","pe non halangina nem at ke ueiuei ero. Ol pe iri lochloch ke mataria nongnongo pe te mamani sio. ");
INSERT INTO uvl_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Pe nga miliko tuna, mele halngana hot ke teke, ‘Non halangina nei koloi! A hot at nge i ol!’ ");
INSERT INTO uvl_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Ol pe hehei malolong nemur te rura haka pe te kik taua reria lemenge mur ke te tongo mule iri. ");
INSERT INTO uvl_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","“Pe hehei lime nenge te poi ke manga hauhaua neu, te hele lange pekngaria nemur ke te teke, ‘Lemem lemenge mur i te chanuch sisio lo. A tung lemem rir ana lochngasio hel.’ ");
INSERT INTO uvl_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","“Pe iri te hele, ‘Ero, iange mo mene ke purpure ita lochloch ero. Pomalam ala ke a long rara lemo nge mele hel.’ ");
INSERT INTO uvl_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","“Iok, hehei nemur tela sapele kela te tango rara. Tei ke te lala kura pe non halangina neu puris. Pe hehei nenge tetu ke te kulele i neu, tela luluch nge i sapele. Pe te piu ele sapele iri pe te ngau luluch nge i nga ngaunga matana nenga leinga heueu ngana. ");
INSERT INTO uvl_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Pe nga hoena malolong nemur pekngaria mur teat mule. Ol pe te hele ke te teke, ‘Non halangina nem, imem koloi moat lo. O lohe piunga nge imem ol!’ ");
INSERT INTO uvl_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","“Pe non neu hele, ‘E hele ke manmanna toto lange imo, e eteia imo ero toto i.’ ");
INSERT INTO uvl_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","“Ke pomalam mana a tatalo ele imo pe atu ke a nauala mana, iange a eteia etue nenge Non Soke at mule ia ero.” ");
INSERT INTO uvl_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“NeHalang nena naualanga pe nekinga pomai pule. Pomanga none nge iua nena hana mur, pe hele lange iri ke tenau ele nena ure mur, pe i lohaka ke langa kileng tau ngana e. ");
INSERT INTO uvl_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Pe non palau neu eteia nena hana mur te ume ngaria, pomalam heronge umtutuna nge iri. Pe tunge ke umtutuna ana kole iri lime lange e pe umtutuna ana kole nai tunge lange e pule pe umtutuna ana kole elle lange mol ngaria. Ke het pe lohaka pe la sapele. ");
INSERT INTO uvl_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","“Pe non nenge mene ke umtutuna ana kole iri lime neu, mene umtutuna neu pe poi ume ia nenge mene umtutuna hel pule. Pe umtutuna nenge ume hote lohot ke ana kole iri lime mule. ");
INSERT INTO uvl_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Pe non nenge mene ke umtutuna ana kole iri nai poi ke mau pule. Pe la mene ke umtutuna ana kole nai mule. ");
INSERT INTO uvl_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Pe non nenge mene umtutuna ana kole elle neu, mene pe la ke alohite nga ich. ");
INSERT INTO uvl_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Iok, kileng mala lo pe non palau neu at mule sapele. Pe iua hana nemur pe onteia iri nga umtutuna nemur. ");
INSERT INTO uvl_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Pe non nenge mene ke kole iri lime takis teua nena la, luluch nga kole iri lime nenge i sipona ume hote pule pe hele, ‘Non soke, iong o tung ke umtutuna ana kole iri lime at nge iau. Pe e ume ia umtutuna nem pe e mene ke ana kole iri lime mule.’ ");
INSERT INTO uvl_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","“Ol pe non palau neu hele, ‘Urana toto. Lek non iong nge urana. O poia ume unne sune nem ke urana mana. Pe lape e talue iong ke o nauele ume hel pule. O iat ke o iech luluch nge iau.’ ");
INSERT INTO uvl_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Iok, non nenge mene ke umtutuna ana kole iri nai, i teu la pe hele, ‘Non soke, iong o tung ke umtutuna ana kole iri nai at nge iau. Pe e ume hot mule ke ana kole iri nai ke ngana koi.’ ");
INSERT INTO uvl_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","“Pe non palau neu hele, ‘Urana toto. Lek non iong nge urana. O poia ume unne sune nem ke urana mana. Pe lape e talue iong ke o nauele ume hel pule. O iat ke o iech luluch nge iau.’ ");
INSERT INTO uvl_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Ke het pe non nenge mene umtutuna ana kole elle neu i teu la ol. La pe hele, ‘Non soke, e eteia ke iong non nge letem inin hali. Iange o lulu heke mene hana kelkel ngana hel aria ume nge tetue. Pe o takirau heke mene hana hel aria ngaunga tutuna mur nge te sochia iri lo. ");
INSERT INTO uvl_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Nem poia iau ke e matau lek nge iong. Pomalam e mene lem umtutuna pe ealo hite nga ich. Ke lem umtutuna mur koi.’ ");
INSERT INTO uvl_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Pe non palau neu hele, ‘Iong non poreke ngana nenge lem melei tana hulu. O eteia iau nge e poi ke machmam lo. ");
INSERT INTO uvl_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Pe toinge o mene lek umtutuna pe o laia nge hana hel ke te poi aria ume ia mukam. Pe e at mule pe e mene mule nge iri. Pe lape e mene ke ele haka pol nga nenge o tunge lange iri nem.’ ");
INSERT INTO uvl_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","“Ol pe non palau neu hele lange nena hana mur hel pule ke teke, ‘A mene umtutuna nem nge i pe a tunge lange non nenge nena umtutuna ana kole iri analoch. ");
INSERT INTO uvl_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Iri nenge reria ure halang lape te heluluch tau mule ke halang toto ol. Pe iri nenge reria ure halang ero lape NeHalang mene mule ure nemur nge iri. ");
INSERT INTO uvl_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Pe a sau hote non poreke ngana nem ke lange hot nga kileng au ngana. Nga kileng nenge te tangtang pe ngingiria chatrekreke ia.’” ");
INSERT INTO uvl_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Nga etue nenge Non Tuna at, lape at luluch nga nena hemalmalinga palaungana pe hekulkulonga mur teat luluch nge I. Pe lape kila haka nga nena arenga palaungana nenge te hemalmalia nga lut nga tapa. ");
INSERT INTO uvl_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Pe hulua nga kileng lochloch ngana nga ich, lape tela ke te eukirau nga matana. Pe lape hesilei hotote nena hana mur elle pe elle nga hulua leteria. Ke pomanga non nenge nauelele huros mur nge hesilei hohote sipsip mur nga meme mur leteria. ");
INSERT INTO uvl_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Pe talue sipsip mur nga ilina hele nenga pen tamalmal pe meme mur nga ilina hele nenga pen hoihoi. ");
INSERT INTO uvl_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","“Ol pe Non Soke nem lape hele lange iri nenga pen tamalmal ke teke, ‘Imo nemur a i at. Temek na petanga tu nge imo lochloch, pe lape ateu langa naualanga pe nekinga nenge NeHalang. I ala hote ich nei ero kura pe tatalo ele tele kileng nem ke teke lemo ia. ");
INSERT INTO uvl_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Iange nga etue nenge e uri, a hengaua iau. E mete ak ech pe a heinia iau. E la nga kileng tau ngana pe a nek teua iau langa lemo pele. ");
INSERT INTO uvl_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Lek hengeron chachulu pe a hemele iau ke nek. Singik haleles pe a nauele iau ke nek. E ma teu nga tuele au ngana, pe anau totote iau.’ ");
INSERT INTO uvl_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Pe iri nenge te pengpeng toto te tuacholia ke te teke, ‘Non Soke, imem mo kolkol iong nge o uri pe mo tung am ngaunga. Pe o mete am ech pe mo tung am ech. ");
INSERT INTO uvl_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Pe nga etue tei mo esia iong ke pomanga none nge at nga kileng tau ngana pe mo nek teua iong langa lemem pele? Pe lem hengeron chachulu pe mo hemele iong ke nek? ");
INSERT INTO uvl_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Pe nga etue tei pule mo esia iong nge singim haleles pe mo poia iong ke nek pe otu teu nga tuele au ngana pe mo nau tote iong?’ ");
INSERT INTO uvl_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“Pe Non Palaungana neu lape tuacholia ke teke, ‘E hele ke manmanna toto lange imo, utar nenge a poia lange tik e nge ene sio manmana, a poia at nge Iau pule.’ ");
INSERT INTO uvl_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Pe lape hele lange iri nemur nga pen hoihoi ke teke, ‘Imo nemur a ua toto nga matak. NeHalang letena inin tau tote imo. Ke lape ala nga oan ngingina ngana nenge non poreke ngana pe nena hana mur te tutu ia. Pe oan nem ngau lala pe mete erochro! ");
INSERT INTO uvl_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Iange e mete ak pe a naue iau nga ngaunga unne ero. ");
INSERT INTO uvl_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Pe ei ke ela nga kileng tau ngana pe a mene teua iau langa lemo pele ero. Lek hengeron chachulu pe a tung lek ero. Singik haleles ke e ma pe a at ke a naue iau ero. Pe e mateu nga tuele au ngana pe a at ke a naue iau ero pule.’ ");
INSERT INTO uvl_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Pe hana nemur te tuachol ia ke pomai, ‘Non Soke imem mo kolkol iong nge o ururi pe o metmete am ech pe oii nga kue tau ngana pe lem hengeron chach ululu pe haleles menmene iong pe oma teueu nga tuele au ngana i. Toinge mo esia iong, mo halaua iong la.’ ");
INSERT INTO uvl_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“Pe Non Palaungana nem lape hele ke teke, ‘E hele ke manmanna toto lange imo, nenge teke a poia ute lange tik e nge ene sio mana ero, a poia at nge iau ero pule.’ ");
INSERT INTO uvl_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","“Ke iri lochloch ngana nemur lape te sio langa oan ngingina ngana. Pe iri nemur nenge te pengpeng nga NeHalang matana, lape te mene maulinga ke koko.” ");
INSERT INTO uvl_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Iesus hele ia ure lochloch ngana nemur ke het pe hele lange nena hana mur ke teke, ");
INSERT INTO uvl_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Imo a eteia lo? Etue nai ma ol, pe ngaunga matana palaungana nenga Ingatoto nem lape lohot. Pe lape te tung heke Non Tuna langa hana porekreke ngana mur peria, ke te hero heke I nga manga toto.” ");
INSERT INTO uvl_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Ol pe hana nenge te popoi tunginga aria soksoke ngana mur, pe Iuta mur aria papalauna mur, te eukirau nga ne Kaiapas na pele. Ne Kaiapas i tunginga ana hana mur aria ae huna nenge soke toto. ");
INSERT INTO uvl_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Pe tetal helenga ke te teke te lau kome Iesus pe te hune I ke mete. ");
INSERT INTO uvl_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Pe te hele, “Ta poia nga etue palaungana nei ero, iange lape hehei pe hana te esia pe palinga hel palaungana lohaka.” ");
INSERT INTO uvl_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Pe Iesus tu nge Petani nga ne Simon nena pele. Nge nike, non nem singina poreke toto ia haleles e. ");
INSERT INTO uvl_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Iesus are ke ngaungau nga hatanga, pe heie mene ure nenge inangana ehech pe uruna ele aka toto, pe la ke pasiling heke nga Iesus palpalna. (Ure nem mateu nga kina nge te umeia nga um e nge ene alampasta.) ");
INSERT INTO uvl_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Pe Iesus nena hana mur te esia pe leteria inin toto pe te hele, “Ure nei uruna haka toto i, pe pomere nenge hei pa nei at ke hesil sio mene nga lamai mai? ");
INSERT INTO uvl_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Toinge ure nei ta laia ke mele hel te olia pe ana umtutuna ta laia nge pakarkar una mur.” ");
INSERT INTO uvl_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Pe Iesus eteia leteria tuanin ngana mur ke het lo. Ol pe hele lange iri ke teke, “Pomere toto nenge a ulo heke mene letemo inin ngana lange hei nei? Poinga nenge hei nei poia nei, poia nga urana ngana. ");
INSERT INTO uvl_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Iau lape etu luluch nge imo ke mala ero. Pe atong nemur nenge reria ure halang ero lape tetu luluch nge imo ke kokoes. ");
INSERT INTO uvl_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Hei nem ling heke ure inangana ehech ngana nem nga singik, iange ak metenga heroi lo. ");
INSERT INTO uvl_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","E hele ke manmanna toto lange imo, lape te haliu hote Helenga Urana Toto Ngana nga kileng lochloch ngana nga ich nei, pe lape te hele hote poinga nenge hei nei poia pule, ke hulua lochloch ngana te hele ia pe leteria metene i.” ");
INSERT INTO uvl_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Iok, Iesus nena hana mur iri analoch pe nai. Pe elle nge iri ene Iutas Iskariot. Ana non, lange tunginga ana hana mur aria soksoke ngana mur, ");
INSERT INTO uvl_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","pe onteia iri ke pomai, “Nenge teke e tung heke Iesus langa perimo, pe uruk? Lape a tunge lek utar?” Ol pe hana nemur tesis ala ke umtutuna iri ana non kina elle pe analoch (30) pe te tunge lange i. ");
INSERT INTO uvl_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Ol pe talun sapele ke tango rara kue nenge lape tung heke Iesus langa hana nemur peria. ");
INSERT INTO uvl_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Iok, ngaunga matana nenga Beret Menini Ngana lohot, pe Iesus nena hana mur tela nge I pe te onteia I ke pomai, “Lemem ke o teke mo tatalo ele ngaunga nenga Ingatoto ana ure mur langai?” ");
INSERT INTO uvl_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Pe Iesus hele, “A iteu ke ala nga kileng palaungana neu pe a esia none pe a hele lange i ke a teke, ‘Hetoronga hele ke teke: Ak etue at rochroi lo, pe e teke Iau pe lek hana mur mo ngaua ngaunga matana nenga Ingatoto nga lem pele.’” ");
INSERT INTO uvl_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Ke Iesus na hana mur tela pe te poi mana ke pomanga hele ngana pe te tatalo ele sapele ure mur nga lamau. ");
INSERT INTO uvl_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Iok laol, nga miliko Iesus iri ul nena hana analoch pe nai neu teare ke te ngaungau nga hatanga. ");
INSERT INTO uvl_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Te ngaungau pe Iesus ra haka pe hele, “E hele ke manmanna toto lange imo, amo e nge imo lape tung heke iau langa hana porekreke ngana mur peria.” ");
INSERT INTO uvl_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Ol pe Iesus nena hana mur leteria poreke toto, pe elle pe elle te onteitei ia Iesus ke te teke, “Non Soke, lape o heleleia kai iau mai?” ");
INSERT INTO uvl_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Pe Iesus hele, “Mele nenge heteu luluche penna nge Iau nga kaliu nga ta ngaungau ngara, i lape tung heke Iau lange hana porekreke ngana mur. ");
INSERT INTO uvl_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Non Tuna lape mete ke pomanga NeHalang Nena Alalaha hele talue nge nike lo. Pe non nenge poi poreke Non Tuna nem lape tungana poreke toto. Urana toto ngana, toinge non nem tana hoe i ero nike.” ");
INSERT INTO uvl_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Pe non nenge lape tung heke Iesus lange hana porekreke ngana mur, ngana laka Iutas. Pe Iutas hele, “Hetoronga, lape ngana kai iau mai?” Pe Iesus hele, “Oe, ngana laka iong.” ");
INSERT INTO uvl_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Iok, te ngaungau ol pe Iesus mene beret nem pe hele urana toto lange NeHalang pe reke pe tunge lange nena hana mur pe hele, “A mene ke a ngaua. Mirak koi nei.” ");
INSERT INTO uvl_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Ke het pe mene heke uain nga eulinga pe hele urana toto lange NeHalang. Pe tunge lange nena hana mur pe hele, “Imo lochloch a mene nei ke a inia. ");
INSERT INTO uvl_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Eik koi, nenge lape pasiling hot ke hekerkereng ia Tomunga hel ana Helenga nem. Iange eik i sipona lomo sue hulua lochloch reria poinga poreke ngana mur. ");
INSERT INTO uvl_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Pe e hele lange imo, lape e inia uain nei ero ol kela het nga etue nenge ita ul ta in mule uain heueu ngana nga Temek nena naualanga pe nekinga.” ");
INSERT INTO uvl_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Iok, te peua aria peunga e ke het pe te lohaka nga kileng neu pe tei ke tela sapele nga hengene nge Oliua. ");
INSERT INTO uvl_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Tela te lohot pe Iesus hele lange nena hana mur ke teke, “Heueu nga miliko lape letemo manmanna ngana losio pe a ua ak. Iange NeHalang nena helenga nenge tehas sue ke ulolo, hele ke teke, “‘Lape e hun sue Non nenge nauelele sipsip mur pe nena sipsip mur lape te ua parai.’ ");
INSERT INTO uvl_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","E mete pe nga etue nenge e maul haka mule, lape Iau muka nge imo ke ela nge Kalelea.” ");
INSERT INTO uvl_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Pe Petrus lohaka pe hele, “Nenge teke iri lochloch ngana te ua, iau lape e ua am ero toto.” ");
INSERT INTO uvl_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Pe Iesus hele, “E hele ke manmanna toto lange iong. Heueu nga miliko, pareo tang ke hemol ero kura pe o channanga hemol ke o teke o eteia Iau ero.” ");
INSERT INTO uvl_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Pe Petrus hele ke kerkereng toto ke teke, “Iau lape e pallaka ke pomam ero toto! Nenge teke e mete luluch nge iong, helenga nenge e eteia iong ero lape e heleia ero toto!” Pe Iesus nena hana nemur lochloch te hele ke pomau pule. ");
INSERT INTO uvl_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Iok laol, Iesus la luluch nge nena hana mur ke tela nga kileng nenge te hetue ke ene Ketsemani. Ol pe hele lange nena hana mur ke pomai, “A are lakoloi pe ela lamau ke e hetalaulau mukam.” ");
INSERT INTO uvl_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Pe Iesus mene ke Petrus pe ne Sepeti tutuna mur nai ke tela luluch nge i. Pe talun ke amnei poreke tote letena meena ngana sapele. ");
INSERT INTO uvl_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Ol pe Iesus rahaka pe hele lange iri ke teke, “Letek meena ngana nei, palaugana sakilil pe eingak teke pulo toto ia. Atu lakoi pe ta mese ala mana.” ");
INSERT INTO uvl_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Iok, Iesus ila pol pe losio pe ma ke nau sio langa ich pe hetalaulau ke teke, “Nenge teke lemem, opoi ele ure meena ngana nenge teke lohotot nge Iau nei. Pe o nanasia lemek ngak ero. O nanas mene iong sipom lemem ngam.” ");
INSERT INTO uvl_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Iok, Iesus ila mule nge nena hana mol neu. La pe nau pe te mamani lo. Ol pe hele lange Petrus, “Pomere nenge a mese pe a nauala luluch nge iau ero? ");
INSERT INTO uvl_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Anau ala pe a hetalaulau lange NeHalang, ma lape poinga poreke ngana lohot nge imo pe a losio. Imo lememo toto ke a poia poinga urana ngana nemur pe ero iange singimo makuk leilei mana nge a poia.” ");
INSERT INTO uvl_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Iesus hile iri pe la mule ke hetalaulau, “Temek, nenge teke kue e ero ol lape e takis mene ure meena ngana nei. Pomalam lape lemem ngam lohot ke manmanna.” ");
INSERT INTO uvl_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Iok, Iesus la mule nge nena hana mol neu pe te mamani mule lo iange mataria meena toto. ");
INSERT INTO uvl_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Hile sue iri pe la mule ke hetalaulau ke pomanga tele ngana. ");
INSERT INTO uvl_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Ke het pe la mule nge iri pe hele, “A mamani kolo manmana lemo kura ma?! A nau, etue koana nei i at lo, nenge lape te tung heke Non Tuna langa hana porekreke ngana mur peria. ");
INSERT INTO uvl_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","A lohaka pe tala. Non nenge tung heke Iau langa hana nemur peria, ngana koloi.” ");
INSERT INTO uvl_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Iesus helele kura pe Iutas i hot sapele. Iutas i none nga Iesus nena hana analoch pe nai nem. Pe i laka nenge lape tung heke Iesus langa hana porekreke ngana mur peria. Pe hana nenge te popoi tunginga aria soksoke ngana mur pe hana papalauna mur te kulos ia hulua ke tela luluch nge Iutas. Pe te loloch ia reria tukmaul pe mese mur. ");
INSERT INTO uvl_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Pe Iutas hele la tala nge hulua nemur lo ke teke, “A nau pe e lau haka nge none, ana non lalom. Alau sapele i.” ");
INSERT INTO uvl_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Iok, Iutas la sapele nge Iesus pe hele, “Miliko hetoronga.” Pe lau haka sapele nge I. ");
INSERT INTO uvl_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Pe Iesus hele, “Neingak, o poia lem ume ol.” Ol pe hana nemur tei hot ke te heliliu hite Iesus pe te lau sapele I. ");
INSERT INTO uvl_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Ol pe Iesus nena none kik taua na mese pe teke likia tunginga ana hana mur aria soke nena none. Pe ero, mese neu mene hot mene non neu talngana. ");
INSERT INTO uvl_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Ol pe Iesus hele, “O tal teu mule lem mese langa munna. Mele nenge pal pe menmene mese lape te hune i nga mese. ");
INSERT INTO uvl_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Imo a eteia ero kura kai? Nenge lemek, e hele lange Temek pe heueu nei kulos sue angkelo mur nge iri halang toto ke te at ke te halaua Iau. ");
INSERT INTO uvl_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Pe nem lape ero iange ure nenge lohot nei, lohot ke pete tote NeHalang nena helenga mur nenge tehas sue ke ulolo.” ");
INSERT INTO uvl_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Ol pe Iesus hele lange hulua nemur ke teke, “Iau mai, Iau non poreke toto ngana e nge e hunun kai, nenge ai ia hulua ke aat taua Iau mai? Kokoeses e are ke e hetottoro nga NeHalang nena pele letena. Pe pomere a laua iau ero? ");
INSERT INTO uvl_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Pe ure nenge lohot heueu nei, lohot ke pete tote hetatalonga mur tehas ngaria.” Ol pe Iesus nena hana mur te lohaka pe te ua ana sapele. ");
INSERT INTO uvl_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Iri nenge te laua Iesus te mene I lange ne Kaiapas. Nga etue neu hotonga ana hetoronga mur pe hana papalauna mur, tela ke te eukirau nga ne Kaiapas na pele lo. Ne Kaiapas i non soke nenge nauele tunginga ana hana mur. ");
INSERT INTO uvl_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Pe Petrus i ke nanas ke la toto nga ne Kaiapas na pele ana kileng koana nge hot pe i ke kangkanga manmana. Ol pe i teu kela kila luluch nge palinga hel ana hana mur ke teke nau nga te poi ngaria ia Iesus. ");
INSERT INTO uvl_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Pe hana papalauna nenge te hemurung neu te teke te hune Iesus ke mete. Pomalam te tango rarara Iesus ana metenga huhuna mur nga helenga pallaklaka ngana hel ke te hune i. ");
INSERT INTO uvl_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Hulua halang te lohot ia reria helenga pallaklaka ngana mur pe te hottaua ero. Pe nga hoena ol hana nai tei hot ");
INSERT INTO uvl_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","pe te hele, “Non nem hele ke pomai, ‘Iau nakuk toto nge e toto sue NeHalang na pele palaungana, pe e hemes heke mule nga etue iri mol mana.’” ");
INSERT INTO uvl_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Ol pe ne Kaiapas mes haka pe hele lange Iesus, “O longo langa hana nemur te hele ngarngaria? Lape o tuachol ia ke mere?” ");
INSERT INTO uvl_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Pe Iesus mes ke reng mana. Ol pe ne Kaiapas hele mule ke teke, “NeHalang tu ke maulul pe iong o hele ke manmanna nga matana. E teke e onteia iong. Iong nge iong Kristus kaloi? Pe iong nge NeHalang tuna ma? O hele hote nem at nge imem ke mo longo.” ");
INSERT INTO uvl_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Pe Iesus tuacholia, “Oe, ngana laka iong sipom o hele hote nem lo. Pe e hele lange imo lochloch ngana nem: NeHalang i non Solaki ngana ia. Pe nge he kura lape a esia Non Tuna nge are nga NeHalang ilina ele nenga pen tamalmal. Pe pule lape anau heke I nge sio at nga ulu nga lut nga tapa.” ");
INSERT INTO uvl_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Ol pe ne Kaiapas tachach sue nena hengeron pe hele, “Non nei hele poreke tote NeHalang ene! A tango rere helenga utar ol? A longe helenga poreke ngana nem ke het lo! ");
INSERT INTO uvl_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Pe letemo ma ke mere?” Pe hana nemur te tuachol ia, “Urana nge ta hune I ke mete.” ");
INSERT INTO uvl_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Ol pe te ulut lolele matana pe te amruche peria pe te palia. Pe hel, te tepelehe i pe te songlele ia i pe te hele, ");
INSERT INTO uvl_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","“Kristus, iong hetatalonga ma? O hele at nge imem. Itei toto nenge palia Iong?” ");
INSERT INTO uvl_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Pe Petrus pau kou arare nge hot kura nga pele neu ana kileng koana. Pe heie nge umume nge ne Kaiapas i lange i pe hele, “Iong nem, Iesus nenge Kalelea nena non iong pule.” ");
INSERT INTO uvl_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Pe Petrus channanga nga iri lochloch ngana mataria ke teke, “Iau e eteia ure nenge o helele ia nem ero iam.” ");
INSERT INTO uvl_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Ol pe i hot sapele ke langa kileng koana nem ana kue teu ngana. Pe heie pule esia pe hele lange iri nemur nga lamau, “Iesus nenge Nasaret nem, nena none koi nei pule.” ");
INSERT INTO uvl_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Pe Petrus hele ke kerkereng toto ke teke, “Iau e eteia non nem ero toto iam!” ");
INSERT INTO uvl_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Mala pol lo pe iri nemur nenge te mesmes nga lamau tela nge Petrus pe te hele, “Manmanna toto ke iong pekngam mur laka iri. Iange o hele ngam pomange Kalelea mur.” ");
INSERT INTO uvl_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Pe Petrus hele, “E hele ke manmanna toto lange imo. Iau e eteia non nem ero toto. Nenge teke e channanga, NeHalang lape tuacholia ke poreke toto at nge iau.” Petrus hele ke mau ke het pe pareo tang sapele. ");
INSERT INTO uvl_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Ol pe letena metene sapele Iesus nena helenga nenge heleia. “Lape pareo tang ero kura pe o channanga hemol ke o teke o eteia iau ero.” Ol pe Petrus ua hot ke lange hot pe tang ke palaungana toto. ");
INSERT INTO uvl_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Pe nga uach uruna toto hana nenge te popoi tuninga aria soksoke ngana mur pe hana papalauna mur tetal helenga ke te teke te hune Iesus. ");
INSERT INTO uvl_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Pomalam te kale I pe te mene I ke lange ne Pilatus. Ne Pilatus i non nenge mene ne Kaesa munna ke nauele Iuta mur. ");
INSERT INTO uvl_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Pe Iutas, i non nenge tung heke Iesus langa hana nemur peria. Ana non esia Iesus nge hana nemur te teke te hunune pe letena la mule nga poinga poreke ngana nenge poia ke ulolo. Pomalam lohaka pe mene umtutuna nenge iri ana non kina elle pe analoch nem pe la mule ia nge hana papalauna nemur. ");
INSERT INTO uvl_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Pe hele, “Iau, e poia poinga poreke toto ngana nenge e tung heke mene non nei lange imo. Pe non nei poia ute ke poreke ero toto.” Pe hana nemur te hele, “Iong sipom lem ure ia. Nge imem, mo teke ute pele ero.” ");
INSERT INTO uvl_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Ol pe Iutas sau teua umtutuna neu langa NeHalang na pele palaungana letena pe ua sapele kela rua. ");
INSERT INTO uvl_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Pe hana nenge te popoi tunginga aria papalauna mur te mene heke umtutuna neu pe te hele, “Umtutuna nei ta tal teu luluche langa NeHalang na pele ana umtutuna mur ero, iange te ol none eina ia ke ulolo.” ");
INSERT INTO uvl_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Pomalam te hele hel ia nge iri pe te teke te ol hote ich e nga umtutuna nem. Ich nem non nenge ume hotot tuninga mur nga ich nena ich ia. Pe kileng unne nem te poia ke hana lomonmona ngana mur koluria ana kileng. ");
INSERT INTO uvl_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Pomalam te hetue ich nem ke None Eina. Pe nga etue nei te hetetue ke pomau kura. ");
INSERT INTO uvl_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","10","Pe hetatalonga Ieremaia nena helenga lohot ke manmanna sapele nenge hele ke teke, “Te mene ke umtutuna iri ana non kina elle pe analoch (30) pe te ol hote Pota nena ich nem ke pomanga Non Soke hele ngana ia at nge iau. Pe umtutuna nem, Israel mur hel te talue ke te teke non nem uruna.” ");
INSERT INTO uvl_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Iok laol, te mene Iesus ke lange ne Pilatus. Ne Pilatus i non nenge mene ne Kaesa munna ke nauele Iuta mur. Pe ne Pilatus onteia Iesus ke teke, “Iuta mur aria soke ma iong mam?” Pe Iesus hele, “Oe, iong sipom o hele hote lo.” ");
INSERT INTO uvl_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Hana papalauna nemur te tua hite helenga lange Iesus. Pe Iesus tuacholia helenga e ero toto. ");
INSERT INTO uvl_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Ol pe ne Pilatus onteia Iesus, “Iong mam o longo lala nga hana nemur reria helenga pule?” ");
INSERT INTO uvl_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Pe Iesus tuachol ia helenga unne e ero toto. Nem poia ne Pilatus ke letena tuanin rara toto. ");
INSERT INTO uvl_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Kokoeses nga ngaunga matana palaungana nenga Ingatoto ana etue, ne Pilatus nananas ia poinga nenge lohe hotote none nga tuele au ngana, nga hulua lemeria ngana. ");
INSERT INTO uvl_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Nga etue neu none nge pingana songong nga poinga poreke ngana tunga tuele au ngana. Ene laka Parapas. ");
INSERT INTO uvl_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Ke ne Pilatus onteia hulua nenge te eukirau neu ke pomai, “Lememo taua non tei nge hana nai nei, ke e tung mule i lange imo? Ngana kai ne Parapas mai? Eh, Ngana kai Iesus nenge te hetue I ke Kristus mai?” ");
INSERT INTO uvl_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Ne Pilatus hele ke mau iange eteia ke hana papalauna nemur saria keke Iesus kou nenge te mene lange i neu. ");
INSERT INTO uvl_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Nga etue nenge ne Pilatus are nga arenga palaungana nenge te hepengpeng ure meena ngana mur ia, nehei hekule helenga nei lange i ke teke, “O poia ute ke lohot nge non nem ero toto. Non nem I non urana ngana nge pengpeng toto. E hele ke mai iange e ma opek poreke toto ia I. Ke heueu nei singik meena mana.” ");
INSERT INTO uvl_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Pe ero. Hana papalauna nemur teteu nga hulua nemur leteria ke te long hote ne Parapas pe te teke te hune Iesus ke mete. ");
INSERT INTO uvl_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Ol pe ne Pilatus ontei mule iri ke teke, “Lememo taua non tei nge hana nai nei ke e tung mule lange imo?” Pe hana nemur te tuacholia, “Lememem taua ne Parapas!” ");
INSERT INTO uvl_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pe ne Pilatus ontei mule, “Pe Iesus nenge te hetue I ke Kristus, lape e poia I ke mere mai ol?” Pe iri lochloch ngana te tuachol ia ke te teke, “O heon heke I nga manga toto!” ");
INSERT INTO uvl_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Pe ne Pilatus hele, “Ia, i mai poia utar ke poreke?” Pe iri lochloch ngana te haliu hot ke te teke, “O heon heke I nga manga toto!” ");
INSERT INTO uvl_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Ne Pilatus esia lo ke teke ute pele nge urana lape lohot ero. Pe pule nau urume lo ke chauchainga palaungana lape lohaka nge hulua nemur. Pomalam, mene ech pe lomo sue penna nga hulua mataria pe hele, “Iau lek ute pele ero langa non nei ana metenga. Imo sipomo a mene I ke a heon heke I nga manga toto.” ");
INSERT INTO uvl_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Pe hulua lochloch ngana nemur te hele, “O tunge I at. Pe mete ngana nem ana helenga, hakaka nge imem pe tutumem mur ol!” ");
INSERT INTO uvl_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Pomalam ne Pilatus tung mule Parapas ke lange iri, pe tunge Iesus lange palinga hel ana hana mur ke te pal hulu hite pe te heon heke nga manga toto. ");
INSERT INTO uvl_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Ol pe ne Pilatus nena palinga hel ana hana mur te mene teua Iesus langa na pele pe iri lochoch te eukirau pe te heliliu hite Iesus. ");
INSERT INTO uvl_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Ke het pe te haka hote nena hengeron pe te heron heke hengeron remenmen ngana e lange I. ");
INSERT INTO uvl_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Pe te mene rur e nge matantana pe te helule, pe tetal heke langa palpalna. Pe pule te tunge kula e lange I ke rahite nga penna tamalmal ke nakuna manga naungaala ana non soke e. Pe te tualou palaria nge I pe te songlele hule I pe alngaria ke pomai, “Masin! Iuta mur aria non soke!” ");
INSERT INTO uvl_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Pe te ulut lolele I pe te mene kula nem pe te hechongia nga palpalna. ");
INSERT INTO uvl_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Te songlele hulu hite I ke het pe te haka hot mule hengeron neu nge I, pe te heron teu mule i sipona nena lange I. Ke het pe te mene I kela te heon heke I nga manga toto. ");
INSERT INTO uvl_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Iok, teii ke te lala kura pe te apenia Simon nenge nena nge Sirini. Pe te ech hote i ke halaua Iesus ke takis ia manga toto neu pule. ");
INSERT INTO uvl_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Pe tei kela te lohot nga kileng nenge ene Kolkota (Luna pomai, “Kittol Munna.”) ");
INSERT INTO uvl_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Pe nga lamau te tunge uain nenge te poi luluche nga ute e nge ehech. Pe in hot mene ke het pe lemene ero nge in mule ol. ");
INSERT INTO uvl_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Te hero hite I nga manga toto ke het pe te saua oio paena ke te teke tenau, itei toto nenge lape mene na hengeron. ");
INSERT INTO uvl_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Pe teare ke tenau ele Iesus nge heon. ");
INSERT INTO uvl_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Pe te hero heke asinga langa manga toto neu pule nenge hele ke teke, “IESUS NENGE IUTA MUR ARIA NAUNGA ALA ANA NON KOI NEI.” Iange helenga nem hele urume huna nga nenge te laua Iesus. ");
INSERT INTO uvl_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Pe hana kemenge kina nai, te heon heke iri pule. Elle heon nga Iesus hilina hele nenga pen tamalmal pe e nga pen hoihoi. ");
INSERT INTO uvl_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Ke iri nemur nenge tei tototo lamau, te esia pe te rurur palpalria pe te helele ke te teke, ");
INSERT INTO uvl_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“Iong utar pa nenge o teke o toto sue NeHalang na pele, pe o hemes heke mule nga etue iri mol mana? Nenge teke iong NeHalang tuna, O halaua Iong sipom ke osio nga manga toto nem!” ");
INSERT INTO uvl_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Pe hana nenge te popoi tuninga aria soksoke ngana mur pe hana papalauna mur pe hotonga ana hetoronga mur, te song lele hule Iesus ke pomalam pule. ");
INSERT INTO uvl_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Pe te hele, “Non nei Israel mur aria naungaala ana non. Pe I halaua hulua halang lo. Pe pomere nenge halaua i sipona ke sio nga manga toto nei ero mai?! Nenge teke halaua i sipona lape letera manmanna nge I. ");
INSERT INTO uvl_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Non nei hele ke teke I NeHalang tuna. Pe pule hele ke teke letena manmanna nge NeHalang. Nenge teke NeHalang mutena taua I, ta nauele nge halaua I.” ");
INSERT INTO uvl_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Pe hana porekreke ngana nai nenge te heon luluche iri nge Iesus neu, tesau hote helenga hel pule lange Iesus. ");
INSERT INTO uvl_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Pe nga chaia matana eurunga pengpeng, kileng lochloch ngana au. Pe tu mana ke pomau ke la ulei. ");
INSERT INTO uvl_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Iok, chaia pallele ke lala lo, (nga 3 kilok) pe Iesus hepehoihoihoi ke soke toto ke teke, “Eloi, Eloi, Lama Sapachtani?” Pe helenga nem luna pomai, “Ak Soke, Ak Soke, pomere nenge o hile hot mene iau ke pomai?” ");
INSERT INTO uvl_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Pe iri nenge te mes rochroi, te longe pe te hele, “Non nei iuiua Elaisa i!” ");
INSERT INTO uvl_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Pomalam elle nge iri song sapele ke mene ute nge manga lumlum pe kale hite nga io e mokona. Ke het pe panun teua nga uain nenge ehech pe tul heke lange Iesus ke inia. ");
INSERT INTO uvl_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Pe pekngana mur te hele, “O mes mukam pe ta nauala. Lape Elaisa at ke halaua i ma ero!” ");
INSERT INTO uvl_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Iesus alngana hot ke soke toto mule pe opene iuch hot kela, pe mete sapele. ");
INSERT INTO uvl_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Nga etue unne neu pengpeng huunga ala palaungana nenge heon sio nga NeHalang na pele letena, chach nga tunangana ke sachana nai. Pe talun ke chach nga lut ke ramana sio. Pe ich rurur pe um te chach hululu. ");
INSERT INTO uvl_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Pe hana nemur nenge te mete lo, aria polo mur te pangpanga mana ol. Pe iri halang nenge te pengpeng toto nga NeHalang matana pe te mete lo, koluria mur te maul haka mule nga metenga. ");
INSERT INTO uvl_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Pe tei hot mule nga reia polo mur. Pe nga etue nenge Iesus lohaka mule nga metenga, hulua lochloch ngana te esia hana nemur nge teteu langa kileng nenge Ierusalem. ");
INSERT INTO uvl_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Pe palinga hel ana hana mur iri ul aria soke, te mes ke tenau ele Iesus. Ol pe te amneia mangila pe te esia ure lochloch ngana neu nge lohot pe te matau toto. Pe te hele, “Manmanna toto ke Non nei, NeHalang Tuna koi.” ");
INSERT INTO uvl_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Pe hehei halang tela pule pe te mes nga tau mana, pe tenau la manmana nga ure nemur nge te lohotot. Iri, te koko nge Iesus nge Kalelea nike ke te halaulaua I nga kue. ");
INSERT INTO uvl_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Pe hei mol nge iri eria koi: Maria Mantalena pe Maria nenge Ieims iri nai Iosep taria pe Sepeti nehei. ");
INSERT INTO uvl_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Iok nga ulei, Iesus nena none nge nena ure halang at ke puris. Ana non nena nge Arimatea pe ene laka Iosep. ");
INSERT INTO uvl_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Iosep at pe lange ne Pilatus pe onteia ne Pilatus nga Iesus koluna. Pomalam ne Pilatus hele ke te tunge Iesus koluna lange Iosep. ");
INSERT INTO uvl_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Iok, Iosep mene Iesus koluna pe ruch hit sapele nga ruchinga hit heueu ngana e, ");
INSERT INTO uvl_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","pe tal teua langa isipona nena um polona nenge rech teua ke heueu ngana mana kura. Ke het pe hesasaul ia um palaungana e ke ma ele polo neu matana pe i ke laol. ");
INSERT INTO uvl_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Pe Maria Mantalena iri nai Maria e pule teare ke tenau alala nga polo neu ol. ");
INSERT INTO uvl_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Iok, Israel mur aria etue nenge te hetalaulauia lape lohot ke pomange rou. Pe hana nenge te popoi tunginga aria papalauna mur pe Paresio mur, tela ke te esia ne Pilatus. ");
INSERT INTO uvl_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Tela pe te hele, “Non soke, letemem metene non nenge channanga hali nem nena helenga e nge tamal hote. Nga etue nenge tu ke maulul kura helele ke teke, ‘Etue mol het pe lape e maul haka mule.’ ");
INSERT INTO uvl_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Pomalam o hele ke kerkereng ke tenau ele polo nem ke nek toto ke ana etue mol. Iange lape nena hana mur teat ke te keme hote koluna. Pe lape te channanga ia hehei pe hana ke te teke non nem, maul haka mule nga metenga lo. Pe chau ngana ero ngana nem, lape tang ngana meena toto nga nenge Isipona poia nga tele ngana.” ");
INSERT INTO uvl_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Ol pe ne Pilatus hele lange iri ke mai, “Heueu a mene palinga hel ana hana mur ke te mes pe tenau ele polo nem ke nek toto.” ");
INSERT INTO uvl_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Iok laol, hana nemur tela pe te hepile heke ute nga um nenge ma hele polo neu, pe te hemes sue palinga hel ana hana mur ke te mes pe tenau ala sapele. ");
INSERT INTO uvl_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Iok, Sapat ana etue het lo pe miliko sio sapele. Pe nga uachuach Maria Mantalena pe Maria e pule te teke tela ke tenau toto nga polo nenge Iesus koluna ma ia. ");
INSERT INTO uvl_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Ol pe mangila palaungana rur pe Non Soke na angkelo e sio at nga tapa, pe i langa polo nenge Iesus koluna ma ia. I la pe hesasa hul kelkelia um nenge te poi ele nga polo hanna pe kila haka ia. ");
INSERT INTO uvl_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Ana non lohot ke pomanga kileng chalem ngana pe na hengeron hussu pe sina ala toto. ");
INSERT INTO uvl_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Pe palinga hel ana hana nemur te esia angkelo neu pe te matau pe te loiloi toto. Pe ngaria lohot pe te unalou sio mene iri nga ich pe tema ke manga hana hel nge te mete. ");
INSERT INTO uvl_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Pe angkelo neu hele lange hehei nai neu ke teke, “Imo nai a matau ero. E eteia lo nge a teke anau toto Iesus nenge te heone nga manga toto. ");
INSERT INTO uvl_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Pe ana non, i ero nga lamai lo. Imo a iat ke anau nga munna nenge maia. Ngana kou maul haka mule ke lalo ke pomanga hele ngana. ");
INSERT INTO uvl_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Ala mule ke ueiuei mana pe a hele ia lange nena hana mur: ‘Iesus maul haka mule nga metenga lo. Pe ngana kou i muka ke lala nge Kalelea lo. Ala pe a esia I nga lamau.’ Ke e at ngak nei, e at ia laka helenga nem.” ");
INSERT INTO uvl_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Hehei nai neu ueiuei mana pe te ua nga kileng unne neu. Pe te matau pe te iech pe te song kela te hele nge Iesus nena hana mur. ");
INSERT INTO uvl_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Ol pe Iesus herura hot mene iri pe hele, “Uach toto nge imo nai.” Ol pe iri nai tela nge Iesus ke te rahit nga apena pe te heto heke I. ");
INSERT INTO uvl_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Ke het pe Iesus hele lange iri, “A matau ero. Ala pe a hele nge titik mur ke tela nge Kalelea, kela te esia Iau nga lamau.” ");
INSERT INTO uvl_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Iok, hehei ne mur te song ke te lala pe palinga hel ana hana mur hel, teteu lala nga kileng palaungana neu. Pe te hele ia ure lochloch ngana nenge lohot neu lange tunginga ana hana mur aria papalauna mur. ");
INSERT INTO uvl_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Ol pe iri nemur tela ke te hele luluch nge Israel mur aria soksoke ngana mur ke leteria tuanin hote utar nenge lape te poia. Pomalam te palpal hite palinga hel ana hana mur haria nga umtutuna palaungana pe ");
INSERT INTO uvl_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","te hele lange iri ke pomai, “Heueu a hele ke mai koi. A teke, ‘Non nem, nena hana mur teat nga miliko ke te takis hot kome koluna. Pe imem paikoi mo mamani.’ ");
INSERT INTO uvl_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Nenge teke ne Pilatus talngana pairia helenga nei, imem lape mo hemaluche letena ke poia ute pele lange imo ero.” ");
INSERT INTO uvl_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Ke palinga hel ana hana nemur te mene umtutuna neu pe te poia ure lochloch ngana ke pomanga hana nemur te hele ngaria. Pe helenga nenge te teke te kemeia Iesus koluna, ana nananga song ke halang nge iri Iuta mur. Pe nga etue nei te nenene nananga nem kura. ");
INSERT INTO uvl_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Iok laol, Iesus nena hana iri analoch pe elle nem, tei ke tela nge Kalelea nga hengene nenge hele ia lange iri ke telaia. ");
INSERT INTO uvl_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Te la pe te esia Iesus pe te heto heke I, pe hel nge iri leteria manmanna ero. ");
INSERT INTO uvl_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Ol pe Iesus i lange iri pe hele, “NeHalang hekerkereng tote iau ke enau ele tapa pe ich lochloch. ");
INSERT INTO uvl_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Ke pomalam e hele lange imo, ai ke ala nge hehei pe hana nga kileng lochloch ngana nga ich. Ala pe a poia iri ke lek hana mur ia iri. A poia ume nem pe a henune iri nga Temene ene pe Tuna pe Opepengpeng. ");
INSERT INTO uvl_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Pe a hetottore iri ke te longo taua ure lochloch ngana nenge e hetoro sue lange imo nem lo. Pe kokoeses, Iau lape etu luluch nge imo kela het nga etue nei hetala toto ngana.” ");
INSERT INTO uvl_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Helenga urana toto ngana nge Iesus Kristus nenge NeHalang tuna. ");
INSERT INTO uvl_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Helenga urana toto ngana nem talun ke pomanga hetatalonga Isaias has sue nga halang nike lo. “O longo, lape e kulosia lek hekulkulonga ke i muka nge iong. kela hepengia lem kue. ");
INSERT INTO uvl_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Hekulkulonga nem lape haliu nga kileng nenge ich sana lomona ke pomai, ‘A hepeng mule imo ke a urana iange Non Soke lape at. Pe a hepengia kue nenge i atia.’” ");
INSERT INTO uvl_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Ol pe Ioanes lohot nga ich sana lomona nem, henune hulua pe haliu ia na helenga pe hele ke teke, “A hul rumemo ia poinga poreke ngana pe a at ke e henune imo, laka NeHalang saua lemo poinga poreke ngana mur ke te lasus toto.” ");
INSERT INTO uvl_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Iok laol, iri halang toto nga tuele kina nenge Iuta pe nga kileng nenge Ierusalem te lohot ke te longe Ioanes na helenga. Pe te hele hote ria poinga poreke ngana mur pe Ioanes henune iri nga ech Iortan. ");
INSERT INTO uvl_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Ana non heronia hengeron nenge te taua nga kamel pulpunna pe kale hite ana tal nga luana pe ana ngaunga sis pe nina laka misou eina. ");
INSERT INTO uvl_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ke Ioanes haliu hot lange hehei pe hana ke teke, “Non e koi nanasia iau ke atat pe i palaungana toto nge iau. Iau e urana ero pe e purpur ero nga e tuatuch sio nge epoi hote nena ae ulina nga apena. ");
INSERT INTO uvl_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","E henune imo nga ech mana pe i lape henune imo nga Opepengpeng.” ");
INSERT INTO uvl_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Mala pol mana pe Iesus at nge Nasaret nga tuele kina e nge Kalelea pe Ioanes henune i nga ech nge Iortan. ");
INSERT INTO uvl_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Henune Iesus ke het pe Iesus lohot nga ech pe nau sapele tapaira nge alchach pe Opepengpeng sio at nge i ke pomanga ngie chaulum nge lehe sio. ");
INSERT INTO uvl_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Pe helenga e sio at nga tapa ke teke, “Tuk toto laka iong nenge mutek tau tote. Pe e iech toto nge iong.” ");
INSERT INTO uvl_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Iok, Opepengpeng kulosia i kela nga kileng nenge ich sana lomona mana. ");
INSERT INTO uvl_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Tu nga ana kileng ke teio elle pe hakekena (etue iri ana non kina nai) pe la Non Poreke ngana totoi ke helosio ia i. Pe ure mur nenge iri hinolo tetu pule. Mala pol pe NeHalang nena angkelo mur teat ke te halaua i. ");
INSERT INTO uvl_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Te laua Ioanes ke mala pol lo pe Iesus lange Kalelea ke hele hote NeHalang nena helenga. ");
INSERT INTO uvl_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Ke Ioanes hele, “Etue toto ngana at lo. Pe etue rochroi mana nge NeHalang lape at ke lohot nge imo! A hulia lemo poinga mur pe letemo manmanna nga nena helenga urana toto ngana!” ");
INSERT INTO uvl_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Iesus ii nga ech hetaliliu ngana nge Kalelea ilina, pe naue hana nai nge te olole ruo nga hoat. Iri nai aria ume nike, elle ene Simon pe elle ene Antrias pe iri nai titiria hel. ");
INSERT INTO uvl_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Iesus hele lange iri, “Ai luluch nge iau ke e hetore imo ke a mene hehei pe hana ke pomanga ruo nenge aole nga hoat.” ");
INSERT INTO uvl_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Te longe Iesus na helenga pe ueiuei mana te hile sue reria ume nga hoat pe te nanasia i. ");
INSERT INTO uvl_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Iesus i la pol pe esia Sepeti tutuna mur Iakop pe Ioanes. Iri nai te tutua hoat chach ngana nga himot tuna letena. ");
INSERT INTO uvl_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Iesus esia iri nai pe iua iri. Iua iri pe te ua hatalia temeria pe reria hana mur pe te nanasia Iesus. ");
INSERT INTO uvl_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Iesus pe na hana mur te lohot nga kileng nenge Kapernam. Pe tela nga hetoronga ana pela nga etue nenge te hatalaulau ia. Pe Iesus hetoro sapele hehei pe hana nga NeHalang nena helenga. ");
INSERT INTO uvl_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Hehei pe hana te longe pe te ruraia Iesus na helenga nge mallaha toto nge iri. I mallaha toto nge hana papalau ngana nemur nenge te hetottoro nga NeHalang nena hotonga. ");
INSERT INTO uvl_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Ol pe none nge uneinei tu nge i, tu nga hetoronga ana pele nem pe alngana haka lange Iesus ke teke, ");
INSERT INTO uvl_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Iesus nge Nasaret, Imem uneinei mur mo eteia iong lo la! Iong NeHalang nena hekulkulonga nge pengpeng. O teke oat ke o potaria imem? O teke oat ke o heporeke imem?” ");
INSERT INTO uvl_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Iesus keresia uneinei, “O reng, pe o lohot nge non nem.” ");
INSERT INTO uvl_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Uneinei rure non nem ke palaungana, pe alngana haka ke soke pe uahot nge ana non. ");
INSERT INTO uvl_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Hehei pe hana te rura toto pe te ontei hel mule nge iri, “Ee! Utar nei mai? Hetoronga heueu ngana kai? Non nge nena helenga milang ke hele lange uneinei mur ke te ua pe te longo taua i.” ");
INSERT INTO uvl_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Ol pe Iesus pingana song ke ueiuei mana nga kileng lochloch ngana nga ich nge Kalelea. ");
INSERT INTO uvl_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Te lohaka nga hetoronga ana pele nem pe tei pengpeng langa Simon pe tina Antrias ria pele pe Ieims pe Ioanes te koko luluch nge iri. ");
INSERT INTO uvl_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Simon uene nenge hei singina haleles ke ma nga hete pe Iesus lohot pe te heleia lange i. ");
INSERT INTO uvl_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Iesus lange ana hei, rahite penna pe halaua i ke are aka. Singina milang ngana makuk sio pe hengaua iri. ");
INSERT INTO uvl_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Miliko sio, pe hana te takisia iri nenge singiria haleles pe hel nenge uneinei mene iri ke tela nge Iesus. ");
INSERT INTO uvl_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Iri halang nga kileng nenge Kapernam te heuirau nga pele matana. ");
INSERT INTO uvl_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Iesus hemas ia iri halang nenge aria haleles altototo pe poia iri nenge uneinei mene iri ke te urana mule. Iesus poi ele uneinei mur ke te hele ero ol iange te eteia nge i NeHalang. ");
INSERT INTO uvl_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Nga uach uruna toto Iesus lohaka ke ua hatalia pele nem. Pe langa kileng e nge ngana ero, ke hele luluch nge Temene. ");
INSERT INTO uvl_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Ol pe Simon iri ul pekngana mur tela ke te tango rere i. ");
INSERT INTO uvl_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Te hot taua i pe te hele lange i ke te teke, “Hana lochloch ngaria kou te tango rerere iong.” ");
INSERT INTO uvl_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Pe Iesus hele, “Ita lape tai hot langa kileng hel pule nge rochroi. Iau e teke e hele toto lange iri pule iange Temek kulosia iau ke e heleia nena helenga lange hana lochloch.” ");
INSERT INTO uvl_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Ke ngana iam nenge, Iesus i langa kileng lochloch nge Kalelea, ke helele nga hetoronga ana pele mur leteria pe helope hotote uneinei mur. ");
INSERT INTO uvl_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Non e nge singina poreke at nge Iesus, tualou palana pe hele lange Iesus ke halaua i pe hele ke teke, “Teke lemem, o poia singik ke urana mule.” ");
INSERT INTO uvl_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Iesus letena ia i ke ra haka nge i pe hele, “Nga lemek ngak o urana mule!” ");
INSERT INTO uvl_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Ueiuei mana pe haleles poreke ngana het sapele nge i pe singina urana mule. ");
INSERT INTO uvl_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Iesus kulosia i pe toto hita lange i, ");
INSERT INTO uvl_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“O longo ke nek! Ola pe o hele hote lange mele e ero. Ola pengpeng nge tunginga ana non pe o hele lange i ke nau urume singim. Singim urana nga NeHalang matana lo pe o tunge lem tunginga ke manga Moses hele ngana, ke mallaha lange hana lochloch ke te eteia singim nge urana mule lo.” ");
INSERT INTO uvl_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ol pe non nem talkome helenga ero. Hele hote lange hana lochloch ngana. Ana non hele hot rara sakililia ke poia Iesus ke tu luluch nge hulua pe langa kileng palaungana ero ol. Ol pe tu mana nga kileng nge ngana ero pe hana nga kileng lochloch ngana te mana taua i. ");
INSERT INTO uvl_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Etue hel nga hoena Iesus la mule nge Kapernam ke tu nga pele e pe pingana song. ");
INSERT INTO uvl_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Hulua teat lochloch pe muria ero nge teu pe nga pele matana pule. Iesus hetottore helenga lange iri, ");
INSERT INTO uvl_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","pe hana henel nge te purpur ke te teke te takisia none nge apena mete at nge i. ");
INSERT INTO uvl_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Pe te raker nge te takisia non neu lange Iesus iange hulua halang sakilil. Ol pe te haka langa pele ona nga Iesus alangana haka pengpeng pe te alchachia pele pulpunna pe te hesue ana non luluch nga na hete lange i. ");
INSERT INTO uvl_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Iesus eteia leteria manmanna ngana pe hele lange non nenge apena mete ke teke, “Atong neingak, e saua lem poinga poreke ngana mur ke te lasus toto ol.” ");
INSERT INTO uvl_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Hana papalau ngana mur nenge te hetottoro, teare pe leteria tuanin nge iri siporia. ");
INSERT INTO uvl_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Pomere nenge i hele ke pomai? I hele poreke NeHalang iam. NeHalang i toro mana nge saua poinga poreke ngana mur ke te lasus toto.” ");
INSERT INTO uvl_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Ueiuei mana Iesus eteia leteria tuanin ngana pe hele lange iri, “Pomere nenge letemo tuanin ke pomai? ");
INSERT INTO uvl_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Semel nge ta hele lange non nenge apena mete ke mai, ‘E saua lem poinga poreke ngana ke te lasus toto.’ Pe semel ero nge ta hele, ‘O lohaka, olou heke lem tako pe oi.’ ");
INSERT INTO uvl_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Lape epoi hote ke mallaha lange imo ke a eteia Non Tuna na kerkerenga nga ich nge saua poinga poreke ngana mur ke te lasus toto.” Hele sapele lange non nenge apena mete, ");
INSERT INTO uvl_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“E hele lange iong, o lohaka, olou heke lem tako pe ola nga lem pele.” ");
INSERT INTO uvl_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Iri lochloch te nechnei kurkura pe ana non lohaka, pe lou heke na tako pe i hot. Pe hehei pe hana te esia pe te rura mana kela te heto heke NeHalang pe te hele, “Nge nike ta neue ure nge lohot ke pomai ero i!” ");
INSERT INTO uvl_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Iesus la mule nga ech hetaliliu ngana nge Kalelea. Hulua teat nge i pe talun ke tunge hengetoro. ");
INSERT INTO uvl_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Iesus i atat pe esia Alpeus tuna Liuai. Liuai i non nenge lololoch umtutuna. Ana non are teu nga nena ume ana pele sune pe Iesus hele lange i, “O nanasia iau.” pe Liuai lohaka ke nanasia i sapele. ");
INSERT INTO uvl_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Nga hoena Iesus la ke ngau nga Liuai na pele. Hana nenge te lololoch umtutuna iri ul hana porekreke ngana mur te nanasia Iesus. Pe iri halang nge teare luluch nge i pe nena hana mur ke te ngau. ");
INSERT INTO uvl_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Hana Paresio hel nge te hetottoro tenaue Iesus nge ngau luluch nge hana porekreke ngana mur, pe hana nge te menmene umtutuna pe tela ke te onteia Iesus nena hana mur, “Pomere nenge Iesus ngau luluch nge hana nenge pomai?” ");
INSERT INTO uvl_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Iesus longe iri pe tuacholia reria helenga, “Hana nenge te urana lemeria ero masmasinga pe iri nenge singiria haleles mana. Eat ke e iua hana urana ngana mur ero. Eat ke e iua hana porekreke ngana mur.” ");
INSERT INTO uvl_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Nga etue e Ioanes nena hana mur pe Paresio mur teheo nga ngaunga. Hana hel teat nge Iesus pe te onteia i, “Pomere nenge Ioanes nena hana mur pe Paresio mur teheo nga ngaunga pe lem hana mur ero?” ");
INSERT INTO uvl_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Iesus tuacholia lange iri ke teke, “Iri nenge tela nga ngesinga lape teheo nga ngaunga pule ma? Nenge teke ngesinga ana non tu luluch nge iri kura lape te poia poinga nem ero. ");
INSERT INTO uvl_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Ngesinga ana non la ol, laka teheo ol. ");
INSERT INTO uvl_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Mele pele sime malenga sachana nge heueu ngana ke tal ele nga nike ngana polona ero. Iange lape heueu ngana nem luluchou pe chach hot nga nike ngana pe poia chach ngana ke palaungana toto ol. ");
INSERT INTO uvl_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Mele pele ling teua uain heueu ngana nga kina nenge nike ngana ero. Iange lape kina sosolos pe chach pe lape iri nai te poreke. Urana ngana te ling teua uain heueu ngana nga kina nge heueu ngana pule.” ");
INSERT INTO uvl_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Nga Sapat ana etue Iesus pe nena hana mur teteu langa ume e. Tei la pe na hana mur te sohe uit nganangana ke te ngaua. ");
INSERT INTO uvl_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Pomalam Paresio mur te hele lange Iesus, “O longo, lem hana mur tepoi ke mere nei mai? Pomere nge te nanasia lemem hotonga mur nga Sapat ana etue ero?” ");
INSERT INTO uvl_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Iesus tuacholia reria onteinga ke teke, “Ia!? O sisia poponing nga non soke Teuit poi ngana nge nike ero? I pe na hana mur te mete aria ");
INSERT INTO uvl_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","pe la ke i teu nga NeHalang nena pele pe mene tunginga ke te ngaua. Te poia nga etue nenge Apiatar i tunginga ana non nenge palaungana. Ngaunga nem tunginga ana hana mur aria mana pe non soke Teuit ngaua pe hengau nena hana mur ia.” ");
INSERT INTO uvl_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Ol pe Iesus hele lange iri, “NeHalang talue Sapat ana etue ke halaua hana mur nenge te nanasia i. NeHalang ume hote hana mur ke Sapat ana etue ana ia ero. ");
INSERT INTO uvl_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Pomalam, Iau Non Tuna pe iau palaungana toto nga Sapat ana etue.” ");
INSERT INTO uvl_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Iok Iesus la mule nga hetoronga ana pele, pe nga pele nem none nge penna mete tu pule. ");
INSERT INTO uvl_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Pe Paresio mur te tango rere Iesus nena poinga huna ke te hele poreke i ia. Paresio mur te nechnei it tote Iesus nge hemasia non nem penna nga Sapat ana etue. ");
INSERT INTO uvl_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Iesus hele lange non nem, “O iat la koi nga mataria.” ");
INSERT INTO uvl_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Iok pe Iesus onteia hana mur, “Hotonga tei nge urana nge ta nanasia nga Sapat ana etue? Ta halaua mele ke tu ke maulul ma singira sisia i pe ta hune i?” Pe iri lochloch te reng mana. ");
INSERT INTO uvl_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Ol pe Iesus letena inin taua iri. Nau rara nge iri pe letena sisipu iange iri singiria sisis pe te hemas erochro. Pe Iesus hele lange non nem, “O hepeng hote perim.” Iok, non nem hepeng hote penna pe urana sapele. ");
INSERT INTO uvl_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","La ol Paresio mur te lohot nga hetoronga ana pele pe iri ul ne Herot nena hana mur te heuirau ke tetal reria helenga ke te teke te hune Iesus. ");
INSERT INTO uvl_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Iesus pe na hana mur tei hot nga ech hetaliliu ngana nenge Kalelea. Pe hulua halang nga kileng rochroi ngana mur Kalelea te nanasia i. ");
INSERT INTO uvl_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Pe halang nge Iutea, pe Ierusalem pule pe nga ele nga chaia haka ngana nge Iortan pe nge Tir pe Siton. Hana lochloch nga kileng nem mur te longe Iesus nge popoia ure mur pe teat nge I. ");
INSERT INTO uvl_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Iesus hele lange na hana mur ke te mene sulang ke ma ke kulkul ala, iange hulua halang te hemurung hite i. ");
INSERT INTO uvl_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","I hemasia hana halang lo pe haleles mur halang te ech teua iri ke te teke tera nge Iesus. ");
INSERT INTO uvl_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Iri hana nenge uneinei poia iri te esia Iesus pe te tualou sio nga matana pe te hele haka lange i, “Iong NeHalang Tuna!” ");
INSERT INTO uvl_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Iesus keresia uneinei ke te hele hote i ero nge i NeHalang. ");
INSERT INTO uvl_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Iok Iesus i haka langa chouchou ngana pe iua hana mur nenge lemene taua iri. Pe teat sapele nge i. ");
INSERT INTO uvl_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Pe Iesus hesilei hote nena hana iri analoch pe nai. Pe hetue eria ke Hekulkulonga mur. Iesus hele lange iri. “Iau e hesilei hote imo ke ai luluch nge iau. Pe lape e kulosia imo ke a haliu hote lek helenga. ");
INSERT INTO uvl_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Pe imo lape a mene lemo kerkerenga nenge a hele pe a helope hote uneinei mur.” ");
INSERT INTO uvl_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","19","Hana iri analoch pe nai nenge Iesus hesilei hote iri koi: Simon, (pe Iesus haua ke ene Petrus), Ieims pe tina Ioanes (nenge Sepeti tutuna mur pe Iesus haua eria ke Poanerkes. Luna laka, “kileng kurung ngana” iange leteria inin ngana manga kileng kurung ngana) Antreas Pilip Partolomius Mateus Tomas Ieims (nenge Alpeus tuna) Tateus Simon (non nenge teke Israel mur iri siporia tenau ele iri) Iutas Iskariot, (non nge tunge Iesus langa hana porekreke ngana peria). ");
INSERT INTO uvl_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Iesus iri ul nena hana mur tela mule nga pele pe hulua nge halang toto teat nge i. Ol pe i pe nena hana mur te ngau ero ol. ");
INSERT INTO uvl_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Iesus alona mur te longe pe tela ke te mene i iange hehei pe hana te teke ana hauaua. ");
INSERT INTO uvl_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Hotonga ana hetoronga hel nge teat nge Ierusalem, te teke Pelsipul tu nge i. Te teke uneinei mur aria soke tunge nena kerkerenga lange i ke helope hote uneinei mur. ");
INSERT INTO uvl_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Ke pomalam Iesus iua iri pe hele lange iri nga helenga opene hel ke teke, “Lape Satan lope hot mule Satan nge hehei pe hana ke pomere? ");
INSERT INTO uvl_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Nenge teke none las hule tuele kina e ke kinkino pe tepal hel mule nge iri, lape tuele kina nem tu ke elle ero ol. ");
INSERT INTO uvl_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Nenge teke mel hel tepal hel luluch mule nge aloria mur lape tetu ke elle ero ol. ");
INSERT INTO uvl_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Pe nenge teke Satan nena kileng nenge nauele telas hulu hel ke kinkino lape tu ke mala ero, het sio sapele. ");
INSERT INTO uvl_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Mele pele teu pulut mana nga non kerkereng ngana e nena pele ero. Teke poi ke pomam, kale hite non nem mukam, laka teu ke kemeia non nem nena ure mur ol. ");
INSERT INTO uvl_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“E hele ke manmanna lange imo, poinga poreke ngana mur lochloch nenge ta popoia pe ta heleleia, NeHalang lape letena ia pe saua ke lasus. ");
INSERT INTO uvl_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Pe poinga poreke ngana nenge ta hele poreke Opepengpeng, NeHalang lape letena poreke ia ero iange poinga poreke nem lohot nga letera toto pe lape tu ke koko.” ");
INSERT INTO uvl_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Iesus heleia helenga nei iange mele hel te hele ke teke, “Uneinei tu nge i.” ");
INSERT INTO uvl_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Iesus tana pe titina mur te puris pe temes nge hot nga pele pe te hekulo teua reria helenga lange i ke lohot at. ");
INSERT INTO uvl_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Hulua nenge teare liliu ele Iesus te hele lange i ke te teke, “Ola ke o nau tam pe titim mur pe lilium mur ngaria kou nge hot, te teke te esia iong.” ");
INSERT INTO uvl_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Pe Iesus tuacholia, “Itei hel nenge etak pe titik mur ia iri?” ");
INSERT INTO uvl_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Iesus nachneia hehei pe hana nenge teare liliu ele i pe hele, “A nau at, etak pe titik mur pe liliuk mur laka ");
INSERT INTO uvl_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","mele hel nenge te longo taua NeHalang ke te poia ume nenge lemene taua.” ");
INSERT INTO uvl_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Iesus talun ke hetoro mule nga ech hetaliliu ngana nenge Kalelea ilina hele. Pe hulua nge halang toto teare liliu ele i. Ol pe are nga sulang ke ote hot ke mana nga ech sana. Pe hulua temes nga ech ilina. ");
INSERT INTO uvl_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Iesus hele lange iri nga helenga opene ke hetore iri nga ure halang pe hele, ");
INSERT INTO uvl_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“A longo at! Etue e none la ke tua ngaunga alona. ");
INSERT INTO uvl_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Tue iri nga ume pe hel te losio nga kue pe ngie mur teat ke te tuais haka taua. ");
INSERT INTO uvl_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Hel te losio nga ich nenge ana um halang. Etue sase ero mana pe mataria hot mule iange ich une sune mana. ");
INSERT INTO uvl_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","La ol pe chaia haka pe sine ngaunga alona nemur ke te mete iange ularia sio langa ich letena nge sio ero. ");
INSERT INTO uvl_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Ngaunga alona hel te losio teu nga kiki letena pe kiki haka pe takue aria ngaunga ke hei ero. ");
INSERT INTO uvl_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Pe ngaunga alona tutuna nemur nenge non neu tue iri nga ich nge urana, pe mataria hot pe te haka ke nek pe ngana ngaria. Hel ngana ngaria iri ana non kina elle pe analoch (30), hel ana non kina mol (60) pe hel ana non kina iri lime (100).” ");
INSERT INTO uvl_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Ke het pe Iesus hele, “A pal talngamo pe a longo ke neknek!” ");
INSERT INTO uvl_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Iesus tu ke i toro mana pe na hana mur pe iri nenge te longe i teat ke te onteia i ke hemallaha hote helenga opene nemur. ");
INSERT INTO uvl_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Pe hele lange iri, “Imo a mene helenga talkomkome ngana nga NeHalang nena naualanga pe nekinga ke mallaha. Pe iri hel, e nana lange iri nga helenga opene mana. ");
INSERT INTO uvl_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Ke ngana laka nenge, “‘Tenau pe tenau pe leteria lilil, te longo pe te longo pe te eteia luna ero; pomalam te hulia leteria ero, pe NeHalang letena ia iri nga reria poinga poreke ngana mur ero.’” ");
INSERT INTO uvl_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Ol pe Iesus hele lange iri, “A eteia helenga opene nei ero kura kai? Pe lape a eteia helenga opene lochloch luna ke mere? ");
INSERT INTO uvl_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Non nge tutua ngaunga alona poi ke malaka nge non nenge hele hotote NeHalang nena helenga. ");
INSERT INTO uvl_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Pe ngaunga alona nenge te losio nga kue, pomalaka nge hehei pe hana nenge te longe NeHalang nena helenga pe nga etue nem mana non poreke ngana at pe uaia totoia helenga nenge NeHalang tue nga leteria. ");
INSERT INTO uvl_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Pe hehei pe hana hel te poi ke pomalaka nga ngaunga alona nenge te losio nga ich nenge ana um halang. Te longe helenga nem pe te mene ke ueiuei mana pe te iech ia. ");
INSERT INTO uvl_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Pe ularia ero. Tetu ke etue choro mana pe nga etue nenge ure meena ngana lohot pe mele hel te teke te hekou sue NeHalang na helenga, hehei pe hana nemur leteria manmanna ngana het sio ke ueiuei mana. ");
INSERT INTO uvl_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Iri hel te poi ke pomalaka nga ngaunga alona nenge te losio teu nga kiki letena. Te longe helenga ");
INSERT INTO uvl_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","pe leteria tuhit mene ure nemur nga ich pe muteria tau tote umtutuna pe ure eltit ngana mur. La ol pe leteria lilil ele NeHalang na helenga pe te ume hote ute e nge urana nga tetu ngaria ero. ");
INSERT INTO uvl_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Pe hehei pe hana hel te poi ke pomalaka nga ngaunga alona nenge tetue nga ich nge urana. Te longe helenga nem pe muteria taua ke hel ngana ngaria halang pe hel halang pol pe hel halang toto.” ");
INSERT INTO uvl_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Pe Iesus onteia iri, “Pomere, mele tonge lemenga pe tal teua nga chasang ma nga hete ene ke talkome? Lape ero! Lemenga nem lape te neue ero. Lemenga nem tetal heke nga lut ke tualeme nga kileng lochloch pe tenau ke mallaha ia. ");
INSERT INTO uvl_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Ke pomalam helenga lochloch nenge talkome heueu nei lape NeHalang hemallaha hote. ");
INSERT INTO uvl_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Apal talngamo pe a longo ke neknek! ");
INSERT INTO uvl_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","“Pe letemo tuanin ke nek toto nga ure nenge a longe iange NeHalang lape poia imo ke a etei ke purpur, urume ure nenge letemo tuanin ia. Pe NeHalang lape poia imo ke a etei tote. ");
INSERT INTO uvl_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Mele nenge nena unne ma lo, lape NeHalang tung ke nena halang toto. Pe mele nenge nena ero, lape NeHalang mene toto mule unne sune nenge tutu nge i.” ");
INSERT INTO uvl_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Iesus hele, “NeHalang nena naualanga pe nekinga pomalaka nga non nenge tutua kon nga ana ume. ");
INSERT INTO uvl_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Pe kon tutuna nemur mataria hot pe te haka nga etue nenge non nem mamamani nga miliko ma mesmese nga uach. Pe i eteia ure nemur te haka ngaria ero. ");
INSERT INTO uvl_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Ich isipona poia kon nemur ke te haka pe nganangaria. Nga tele ngana iria lohot, ke het pe te rora ke het pe nganangaria lohot sapele. ");
INSERT INTO uvl_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Pe nga etue nenge kon mera, ume tokoninga at ke sohe iri.” ");
INSERT INTO uvl_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Iesus ontei, “Lape e hele urume NeHalang nena naualanga pe nekinga ke pomere? Helenga opene tei nenge lape e heleia ke e hemallaha hote? ");
INSERT INTO uvl_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","NeHalang nena naualanga pe nekinga, pomalaka nga ae paele tutuna. Tutuna kinkino mana nga ae halang tuturia ");
INSERT INTO uvl_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","pe haka ke soke toto ke i ae palaungana nge perperna halang pe ngie mur te umeia reria kiniu pe tema ia.” ");
INSERT INTO uvl_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Iesus hetore nena helenga lange hehei pe hana nga helenga opene hel ke pomai ke teke poia iri ke te etei tote. ");
INSERT INTO uvl_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Iesus hetottore hehei pe hana nga helenga opene mana, pe nga etue nenge i toro tu luluch nge nena hana mur, hemallaha hote luna lange iri. ");
INSERT INTO uvl_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Nga ulei nga etue neu, Iesus hele lange na hana mur, “Ta lotele langa ech hetaliliu ngana ilina hele.” ");
INSERT INTO uvl_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Pe te hile sue hulua, pe te haka nga sulang nenge Iesus are haka ia lo. Pe te ote tele luluch nge i. Pe aka hel pule te ote tele luluch pule. ");
INSERT INTO uvl_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Ol pe tuttula palaungana heingana haka sapele pe ruach talun ke poi teu sapele nga sulang letena ke liu muta ke teke puluchluch lo. ");
INSERT INTO uvl_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Pe Iesus iam tal heke palpalna nga ulunga ke mamani nga sulang hoena. Na hekulkulonga mur te hengo heke i pe te hele, “Non soke, letemia ita nge lape ta puluch ero kai?” ");
INSERT INTO uvl_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Iesus mes haka pe hele langa tuttula, “Heingam ero!” Pe hele langa ruach, “O mana ke nek!” Tuttula nem mete sio pe ruach ma ke mello. ");
INSERT INTO uvl_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Iesus onteia nena hana mur, “Pomere nenge a matau? Letemo manmanna nge iau ero kura kai?” ");
INSERT INTO uvl_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Pe te rura toto pe te hele tele hel nge iri, “Non tei nei mai, nenge tuttula pe ruach te longo taua i?” ");
INSERT INTO uvl_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Iesus pe na hana mur te lohot nga ech hetaliliu ngana ilina nge Kalelea nga tuele tana nge Kerasa. ");
INSERT INTO uvl_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Iesus iuch sio nga sulang pe saol sapele none nge uneinei tu nge i. ");
INSERT INTO uvl_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Ana non nem tutu nga rika mur nenge te tattal hana koluria ia. Pe mele pele kikina halang ero nge kale hite i ol. Chaunga nenge kerkereng toto malam pe ero la. ");
INSERT INTO uvl_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Kokoes, te kale apena pe penna nga rur nenge kerkereng toto. Pe kokoes mana takhoa nga penna pe nga apena tutkolkole. Mele pele nakuna ero toto nge laua i iange kikina toto. ");
INSERT INTO uvl_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Kokoes nga sinanga pe miliko i rara nga rika hanna pe hengene, pe uu pe ririria singina nga um. ");
INSERT INTO uvl_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","I tu ke kangkanga pol pe esia Iesus pe song sapele lange i ke tualou sio nga matana pe kanna tuakolo tala lange i. ");
INSERT INTO uvl_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Pe alngana haka ke soke toto ke teke, “Iesus, NeHalang nenga lut toto tuna iong! Oat ke o potar nge iau?” Pe hemaluche Iesus nga NeHalang ene ke teke, “Iesus o heporeke iau ero!” ");
INSERT INTO uvl_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Non neu hele ke pomai iange Iesus hele lange i ke teke, “Uneinei o lohot nge non nem.” ");
INSERT INTO uvl_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Ol pe Iesus onteia i, “Em mere?” Pe non neu hele, “Ek laka ‘Hulua’ iange imem halang.” ");
INSERT INTO uvl_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Pe helaulau lange Iesus ke lope hote uneinei mur nga kileng nem ero. ");
INSERT INTO uvl_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Kie halang te tutua nga hengene ilina ");
INSERT INTO uvl_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","pe uneinei mur te helaulau lange Iesus ke te teke, “O kulosia imem kela mo teu heke kie mur.” ");
INSERT INTO uvl_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Ke Iesus longele iri ke tela. Pe uneinei mur te ua hot nge non nem pe teteu heke kie mur. Kie nemur lochloch iri 2000, pe tepoi koukou pe te sasaul sio nga liling kela te pachpach nga ech. ");
INSERT INTO uvl_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Ol pe hana nenge tenau elele kie nemur te ua kela te hesongia pingana nga tuele tana pe nga kileng kinkino ngana mur. Ke hehei pe hana tela kela tenau nga ure nenge lohot. ");
INSERT INTO uvl_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Iok, te song lange Iesus pe te esia non nenge uneinei ua hot nge i, pe iri te ruraia nge are ke nek mana pe heronia nena hengeron pe ramana mallaha mule lo. ");
INSERT INTO uvl_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Iri hel nenge te esia lo te nana lange hehei pe hana nga ure nenge lohot nge non neu pe nge kie nemur. ");
INSERT INTO uvl_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Ol pe hehei pe hana te kulosia Iesus ke teke lohot nga reria kileng. ");
INSERT INTO uvl_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Iesus lohaka nga sulang nem pe non nenge uneinei tu nge i ech ke teke, “Ita ul!” ");
INSERT INTO uvl_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Pe Iesus longele i ero. Ol pe Iesus hele lange i, “Ola mule nga lem kileng pe o heleia lange alom mur pe lem misili mur nga nenge Non Soke letena toto ia iong ke halaua iong.” ");
INSERT INTO uvl_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Ol pe ana non la ke i rara nga tuele kina nenge Tekapolis, pe heleia Iesus nge halaua tote i pe iri nenge te longe te ruraia. ");
INSERT INTO uvl_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Iesus pe na hana mur tela mule nga ech hetaliliu ngana ilina hele pe hulua teat ke te hemurung hite i. ");
INSERT INTO uvl_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Pe none nge i soke nga Israel mur reria hetoronga ana pele, ene Iairos. Ana non at ke esia Iesus pe tualou palana pe ma sio nga Iesus matana. ");
INSERT INTO uvl_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Pe hetalaulau toto lange i ke teke, “Tuk hei ngana nenge kino kou teke metmete lo. Auo! Atong, oi at ke ora haka nge i pe o hemasia ke maul mule!” ");
INSERT INTO uvl_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Iok, Iesus la luluch nge i pe hulua te nanas pe te maimai hite i ke liliu tom. ");
INSERT INTO uvl_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Pe hei e pule nge toho malasioia i ke ana hesinga iri analoch pe nai. ");
INSERT INTO uvl_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Hana nenge te hemasmas te totoi ke te halaua i pe ero. Hei nem esilia nena umtutuna lochloch ngana nge iri pe haleles nem het ero toto mana. ");
INSERT INTO uvl_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","I longo tote Iesus pe isipona letena tuanin ke teke, “Ela, e raua nena hengeron pe lape e urana.” La ol, echrir teua i nga hulua leteria kela lohot nga Iesus rumena ke raua na hengeron. ");
INSERT INTO uvl_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Raua pe haleles nem het sapele pe namneia pe eteia nge haleles nem het toto nge i lo. ");
INSERT INTO uvl_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Pe Iesus amnei sapele nena kerkerenga nge lohot nge i. Iok, ralele pe ontei, “Itei rahite lek hengeron?” ");
INSERT INTO uvl_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Pe na hana mur te hele, “O nau nga hulua nenge te maimai hite iong nei. Pomere nge o ontei ke, ‘Itei raua iau?’” ");
INSERT INTO uvl_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Pe Iesus nau rara nga itei toto nge raua i. ");
INSERT INTO uvl_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Ana hei eteia nge utar lohot nge i ke sana loiloi pe isipona lange Iesus ke tualousio nge i pe hele hot pengpeng lange i. ");
INSERT INTO uvl_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Iesus hele lange i, “Atong liuk, o urana nga letem manmanna ngam. Ola otu ke nek pe haleles nem tu nge iong ero ol.” ");
INSERT INTO uvl_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Iesus heleleia ure nei pe hana hel nga Iairos nena pele te song at ke te hele nge i, “Tum kou mete lo, pomere nge o hemakuk rere mene Non Soke ne mam?” ");
INSERT INTO uvl_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Iesus ma langa reria helenga ero pe hele lange Iairos, “O matau ero, letem manmanna mana.” ");
INSERT INTO uvl_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Pomalam, Iesus poi ele hulua ke tela luluch nge i ero. Petrus pe Ieims pe tina Ioanes iri toro mana te koko nge Iesus. ");
INSERT INTO uvl_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Tela ke te lohot nga Iairos na pele pe Iesus esia hulua nge te tangtang pe te hele loulou rarara. ");
INSERT INTO uvl_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Iesus i teu pe hele lange iri, “Pomere nenge a chauchai rara pe a tangtang mam? He nei mete ero i. Mamani mana pai!” ");
INSERT INTO uvl_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Ol pe te songlele ia Iesus pe Iesus kulos hote iri pe mene he nem alona mur pe nena hana mol ke tei teu langa pele letena nenge he nem maia. ");
INSERT INTO uvl_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Iesus rahite he neu nga penna pe hele lange i, “Talitha koum.” helenga nei luna laka, “He sune nem e hele lange iong, o lohaka.” ");
INSERT INTO uvl_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","He nem lohaka sapele pe talun ke i rara. (Pe he nem ana hesinga iri analoch pe nai) Pomalam ure nei lohot pe iri lochoch te rura toto. ");
INSERT INTO uvl_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Pe Iesus hele ele iri ke teke te hele hote lange mele hel ero. Pe hele, “A tunge ngaunga lange i ke ngau.” ");
INSERT INTO uvl_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Iesus lohaka nga kileng nem pe la mule nga isipona na kileng huna luluch nge nena hana mur. ");
INSERT INTO uvl_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Pe Iesus talun ke hetoro nga hetoronga ana pele nga Sapat ana etue. Pe iri halang nge te longe i pe te rura, pe te ontei hel, “Pomere ramana urana ngana kau tu nge i mau? Non nei mene letena matana urana ngana nemur langai mai? Pe itei tunge lange i ke umeia ure papalau ngana mur mai? ");
INSERT INTO uvl_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","I pele ana lelenga iam! Pe i Maria tuna pe titina mur laka Iakop pe Iosep, Iutas pe Simon. Pe liliuna mur pai itaul ke ta tutu panei mai!” Ol pe lemeria ero ia i. ");
INSERT INTO uvl_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Pe Iesus hele lange iri, “Hetalalonga e te longo taua i nga kileng lochloch ngana. Pe nga nena kileng huna pengpeng, alona mur pe titina mur pe na kileng ngana ngana mur te longo taua i ero.” ");
INSERT INTO uvl_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","6","Iesus rura iange hana leteria manmanna ero. Ke pomalam poi hote merakulo mur nga lamau ero. Tal heke penna nge hana ellechle mana nge singiria haleles ke hemasia iri. Pe Iesus i rara pe hetoro nga kileng pe kileng. ");
INSERT INTO uvl_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Iua nena hana iri analoch pe nai pe tunge kerkerenga nge iri ke te helope hote uneinei mur pe kulos hote iri ke nachnai ke tela nga kileng mur. ");
INSERT INTO uvl_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Pe hele lange iri ke pomai, “A i pe a mene ute kela luluch nga lemo inga ero. A rahit mene lemo eko. Pe a takis kole ero pe a mene ngaunga ero pe umtutuna ero. ");
INSERT INTO uvl_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","A heronia ae ulina pe lemo hengeron la ellechle nenge tu hite imo nem lo pe e ero ol. ");
INSERT INTO uvl_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Nenge teke ateu nga pele e, atu mana nga lamam kela het nga etue nenge a lohaka nga kileng nem. ");
INSERT INTO uvl_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Pe nenge teke ala nga kileng hel pe hehei pe hana lemeria ero ia imo pe te longo taua imo ero, a pasis sue ich nga apemo nga etue nenge a lohaka. Ke nem heneue iri nga NeHalang letena inin ngana.” ");
INSERT INTO uvl_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Iok, tei hot la pe te haliu hot lange hehei pe hana ke te hulia iri nga reria poinga porekreke ngana mur. ");
INSERT INTO uvl_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Pe te helope hote uneinei mur halang, pe te taune ae oliua eina nge iri nenge singiria haleles pe te hemasia iri ke te urana mule. ");
INSERT INTO uvl_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Naungaala ana non Herot longe nei iange Iesus pingana song ke hulua te eteia. Hana hel te teke, “Ioanes nenge henunun lohaka mule nga metenga. Pomalam nena kerkerenga tu nge i ke poi hote ure merakulo nemur.” ");
INSERT INTO uvl_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Pe hel te hele, “I Elaisa” pe hel pule te teke i hetatalonga e pule nenge pomange hetatalonga hel nge nike. ");
INSERT INTO uvl_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Ne Herot longe pe hele, “Ioanes nenge e hele ke te chatoa kanna laka, lohaka mule nga metenga nem.” ");
INSERT INTO uvl_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Ne Herot isipona tunge helenga ke te laua Ioanes pe te kale hite pe tetal teua nga tuele au ngana. Ne Herot poi ke pomam iange lei heke tina Pilip nehei Herotias, ");
INSERT INTO uvl_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","pe Ioanes hele lala nge ne Herot ke teke “Iong o leia tim nehei pe nem ma ke pengpeng nga rera hotonga ero.” ");
INSERT INTO uvl_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Pe Herotias hul haka ae lapusa ngana nge Ioanes ke teke une i. Pe ero. ");
INSERT INTO uvl_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Iange ne Herot matau ele Ioanes nge i non nge na poinga pengpeng pe nanas mene NeHalang. Ke pomalam Herot poi ele mene i nga tuele au ngana. Herot longlonge Ioanes pe letena tuanin rara halang pe lemene nge longo manmana nge i. ");
INSERT INTO uvl_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Iok laol, Herotias nena kue semel ngana nenge hune Ioanes lohot ol. Ngana laka nga etue nenge te poia ngaunga matana nenge leteria metene etue nenge Herot tana hoe i ia. Pe Herot iua ana lang mur. Hana papalauna mur nenge te nauele kileng mur pe iri nenge te mukmuka nge palinga hel ana hana mur pe hana papalau ngana mur nge Kalelea. ");
INSERT INTO uvl_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Nga etue nenge Herotias tuna teu at ke hes, poia ne Herot pe ana lang mur ke te iech toto. Pe non soke nem hele lange he malolong nem ke teke, “O hele at nge iau nga utar nenge lemem tau tote pe e tunge lange iong.” ");
INSERT INTO uvl_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Pe hele lange i ke kerkereng toto ke teke, “O teke o longia utar? Lemem ngam mana! Nenge teke lemem ke o mene ure lochloch ngana nenge enau ele, lape e chachia nga tuna ngana ke lem hele pe lek hele.” ");
INSERT INTO uvl_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Ol pe he nem i hot la, pe onteia tana, “Lape e longia utar mai?” Pe tana tuacholia, “Ola pe o longia Ioanes nenge henunun palpalna.” ");
INSERT INTO uvl_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Pe ueiuei mana he nem la mule nge naungala ana non neu pe hele, “Lemek ke o tunge Ioanes nge henunun palpalna ana kaliu at nge iau heueu mana nei.” ");
INSERT INTO uvl_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Ol pe naungaala ana non neu letena poreke toto, pe meia i nge teke lape channanga mana nga ana lang mur mataria. ");
INSERT INTO uvl_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Ol pe kulos sapele nena non nge hunun hana kela mene Ioanes palpalna. Non nem la pe chatoa Ioanes kanna nga tuele au ngana. ");
INSERT INTO uvl_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Pe mene palpalna nga kaliu ke at mule pe tunge lange he nem pe he nem tunge lange tana. ");
INSERT INTO uvl_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Ioanes na hana mur te longe nei pe teat ke te mene koluna kela tealo hite nga rika letena. ");
INSERT INTO uvl_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Iesus nena hana mur teat mule nga reria inga mur pe te nana luluch nge i. Pe te nene ure nenge te poia nenge te heleia lange hehei pe hana. ");
INSERT INTO uvl_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Hehei pe hana halang te atat pe te lala ke te poia Iesus pe nena hana mur ke te ngau ero. Ol pe Iesus hele lange na hana mur ke teke, “Ita ol, tala nga kileng unne ke ita toro ke a tah eingamo mukam.” ");
INSERT INTO uvl_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Ol pe te mene sulang pe teote langa kileng e nge mele tuia ero toto. ");
INSERT INTO uvl_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Pe hulua te neue iri nge tela pe te eteia lo. Pomalam te hile kileng lochloch pe te song nga ich ke iri muka langa kileng nenge lape Iesus pe nena hana mur tesio ia. ");
INSERT INTO uvl_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Iesus iuch hot nga sulang pe esia hulua pe letena poreke toto ia iri iange tepoi ke manga sipsip nenge aria naualanga ero. Pe talun ke hetore iri nga ure nge halang toto. ");
INSERT INTO uvl_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Chaia matana puluch sisio lo pe nena hana mur teat nge i pe te hele, “Kileng nei, ich sana lomona mana pe ngaunga ero pe chaia matana i sisio mai loi. ");
INSERT INTO uvl_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","O kulosia iri ke tela nga kileng mur nenge tetu rochroi ke teol aria ngaunga ke te ngau.” ");
INSERT INTO uvl_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Pe Iesus hele, “Imo sipomo a tunge aria ngaunga.” Pe te hele, “Mo hengaua iri ke mere mai? O teke mo olia aria ngaunga? Nem lape umtutuna halang toto paiam!” ");
INSERT INTO uvl_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Pe Iesus onteia iri, “Beret hia nge ma mau? Ala ke anau toto.” Te tango rara ke het pe te hele, “Beret iri lime iau pe ruo nai pule.” ");
INSERT INTO uvl_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Ol pe Iesus hele lange na hana mur ke te poia hulua ke teare sio nga heilil. ");
INSERT INTO uvl_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Pe teare nga tuluk mur ke te nanas tau hel. Tuluk hel iri ana non kina lime (100) pe hel iri ana non kina nai pe analoch (50). ");
INSERT INTO uvl_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Ol pe Iesus mene beret lime neu pe ruo nai neu. Pe nau haka langa tapa pe hele urana lange NeHalang. Reke beret nemur pe tunge lange nena hekulkulonga mur ke te heronge nge hehei pe hana. Pe heronge ruo nai neu nge iri lochloch pule. ");
INSERT INTO uvl_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Iri lochloch te ngau pe saria una toto. ");
INSERT INTO uvl_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Pe Iesus na hana mur te heua beret pe ruo aluana mur ke muta toto nga chasang nge iri analoch pe nai. ");
INSERT INTO uvl_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Hana nenge te ngau, iri 5,000. ");
INSERT INTO uvl_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Pe ueiuei mana Iesus hele lange na hana mur ke te haka nga sulang ke te muka lange Petsaita. Pe i tu pol mukam ke kulos mulmule hulua ke tela mule nga reria kileng. ");
INSERT INTO uvl_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Kulosia iri ke tela pe i haka langa hengene ke hetalaulau. ");
INSERT INTO uvl_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Kileng miliko sio pe nena hana mur te manmana nga ech hetaliliu ngana tunangana lo pe i toro tu nga ich. ");
INSERT INTO uvl_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Pe esia nena hekulkulonga mur nge te pur kikiria toto ia sulang ote ngana iange tuttula eingana tua ele iri. Pe nga uachuach Iesus i nga ech ona ke lange iri. Teke ris tote iri ");
INSERT INTO uvl_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","pe te esia i nge ii nga ech ona pe te teke ma moiuk iam pe alngaria haka. ");
INSERT INTO uvl_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Iange iri lochloch tenaue i pe te matau. Ueiuei mana pe hele lange iri ke teke, “A matau ero! A kerkereng, Iau pa i!” ");
INSERT INTO uvl_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Iuch haka lange iri nga sulang pe tuttula nem mete sio. Pe te rura pe leteria una ala, ");
INSERT INTO uvl_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","iange leteria mallaha ero toto nga beret nenge Iesus heronge nem luna. ");
INSERT INTO uvl_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Te ote tele nga ech hetaliliu ngana ke tela nga ich nge Kenesaret pe te hele heke reria sulang. ");
INSERT INTO uvl_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Te hile sue reria sulang pe ueiuei mana hehei pe hana tenau urume Iesus. ");
INSERT INTO uvl_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Ol pe te song langa kileng lochloch ngana nga kileng palaungana nem. Pe te takisia iri nenge singiria haleles nga hete ke te lala nga kileng nemur nenge Iesus tutu ia. ");
INSERT INTO uvl_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Pe nga kileng lochloch ngana nenge Iesus laia, te mene reria haleles kina mur lala nga ingaala munna mur. Pe te hele kerkereng lange Iesus ke te teke iri nenge singiria haleles te raua nena hengeron ilina. Pe iri nenge te raua te urana mule. ");
INSERT INTO uvl_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Paresio mur pe iri hel nenge te hetottore hotonga, teat nge Ierusalem pe te hemurung hite Iesus ke liliu tom. ");
INSERT INTO uvl_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Pe te neue Iesus nena hana mur hel nge te ngau hit mene peria muna ngana nga NeHalang matana pe te lome tele peria ero. ");
INSERT INTO uvl_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Iange Paresio mur pe Israel mur hel pule te ngau tangai mana ero. Te nanasia iri siporia reria poinga nenge te mene nge reria tete mur, ke te lomo sio tele peria ke nek mukam ke het pe te ngau ol. ");
INSERT INTO uvl_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Pe pule, nenge teke te mule nga ingala, te ngau tangai ero. Tenun tala mukam. Pe te nanasia poinga halang pule, manga nenge te lome aria ure lochloch nenge te inin ia pe te tuntun ia. Te teke te nanasia poinga nemur ke te urana nga NeHalang matana. ");
INSERT INTO uvl_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Pe Paresio mur pe iri nenge te hetottore hotonga, te onteia Iesus, “Lem hana mur te ngau luluch nga peria muna ngana. Pomere nge te nanasia poinga nemur nenge ratete mur te hesue ero?” ");
INSERT INTO uvl_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Iesus tuacholia ke teke, “Hetatalonga Isaias hele ke manmanna nga nenge has pe hele urume imo hana nenge amo hengetau nachnai ke teke: “‘Hana nei te heto heke iau nga haria ulina mana pe nga leteria tetu kelkel toto nge iau. ");
INSERT INTO uvl_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Te heto heke iau pe leteria manmanna ero nga ure nenge te heleia. Tepoi ke pomau iange te hile Non Soke nena hotonga pe te hetoro manmana nga hana mana reria poinga.’” ");
INSERT INTO uvl_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Pe Iesus hele, “Imo a hile hote NeHalang nena hotonga pe a nanas mene hengetoro nenge hana mur. ");
INSERT INTO uvl_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Oe, a etei tote poinga nenge a sausaua NeHalang nena hotonga pe a nanas mene imo sipomo lemo poinga. ");
INSERT INTO uvl_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","A poia ke pomam nga hotonga nenge Moses tunge lange imo. Iange Moses nena hotonga hele ke teke, ‘O longo taua temem pe tam.’ Pe pule hele ke teke, ‘Itei nge hele poreke tana pe temene, lape te hune i.’ Imo a saua hotonga nem pe a hetoro hel mana ia a pallaklaka ngamo. ");
INSERT INTO uvl_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Iange mele teke longo taua tana pe temene pe teke tunge tunginga lange iri, pe imo a hele ele i ke mene mule tunginga nem ke NeHalang nena ia. ");
INSERT INTO uvl_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Ke lemo poinga nenge a pallaklaka poia mele nem ke longo taua tana pe temene ero pe halaua iri nga tunginga ero ol. ");
INSERT INTO uvl_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Ke nga poinga nem a hetaua NeHalang nena hotonga nga lemo poinga. Pe a poia lange hana hel pule ke poinga nenge pomai lohot ke halang toto.” ");
INSERT INTO uvl_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Ol pe Iesus iu mule hulua nemur pe hele lange iri, “Imo lochloch a longo at nge iau pe letemo mallaha nga ure nenge e heleleia nei. ");
INSERT INTO uvl_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Ure nenge tu nge hot pe teu langa none letena, poia letena ke muna ulu nga NeHalang matana ero. Ure nenge tu nge teu pe lohot at, poia non nem ke muna ulu nga NeHalang matana. ");
INSERT INTO uvl_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Apal talngamo pe a longo ke neknek!” ");
INSERT INTO uvl_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Iesus hile sue hulua pe teu langa pele pe nena hana mur te onteia i nga helenga opene nei. ");
INSERT INTO uvl_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Pe Iesus hele lange iri, “Amo hauaua toto kura kai? Ure nenge tu nge hot ke teu langa mele letena poia i ke poreke nga NeHalang matana ero. ");
INSERT INTO uvl_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Iange teu langa kakaona ero. Teu la mana nga makanna pe lohot mule nga singina.” (Iesus nena helenga nei luna, teke ngaunga lochloch ngana te urana nge te ngaua.) ");
INSERT INTO uvl_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Pe Iesus helolo une na helenga ke teke, “Utar nenge tu teu nga none letena pe lohot at, poia non nem ke poreke nga NeHalang matana. ");
INSERT INTO uvl_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Iange ure poreke ngana nemur te lohot at nga non nem letena. Ngana laka; letena tuanin ngana poreke ngana mur, pe salaulau pe keme pe hunun hana pe poi poreke lala nge leinga kina mur, ");
INSERT INTO uvl_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","poinga nenge naulele ure mur pe na polo tantana pe channanga pe meia iri ero pe sana kekeke pe channanga ke heporeke mele ene pe longo olole, letena matana ero pe poi pulut mana pe ure poreke ngana hel pule. ");
INSERT INTO uvl_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Ure poreke ngana nemur tetu nga none letena nike pe te lohot at nge hot pe te poia i ke poreke nga NeHalang matana.” ");
INSERT INTO uvl_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Iesus hile sue kileng neu pe langa kileng mur nenge rochroi nga kileng nenge Tir. Teu nga pele e pe lemene ero nge mele e eteia i nge tu lamau. Pe tu ke talkome ero. ");
INSERT INTO uvl_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Hei e nge uneinei tu nge tuna heingana. Ana hei longe Iesus pe lange i ke ueiuei mana. La pe ma sio nga Iesus apena ke teke Iesus heurana ia tuna. ");
INSERT INTO uvl_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Ana heingana nena nge Israel ero. Te hoe i nge Poenisia nge Siria. Hele lange Iesus ke helope hote uneinei nge tuna heingana nem. ");
INSERT INTO uvl_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Pe Iesus hele, “Poinga nenge ta mene aina kinkino ngana aria ngaunga pe ta saua lange kaone mur pengpeng ero. Ta hengau tele aina kinkino ngana nenge Israel muka.” ");
INSERT INTO uvl_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Pe hei neu tuacholia ke teke, “Oe Non Soke, pe kaone mur te ngaua aina kinkino ngana aria ngaunga mumuna nga hatanga ene!” ");
INSERT INTO uvl_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Ol pe Iesus hele lange i, “Uneinei uahot nge tum lo nga tuacholinga nem. Ola nga lem pele ol.” ");
INSERT INTO uvl_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Ana hei la mule nga na pele pe naue tuna nge ma nga hete. Pe uneinei ua hot nge i lo. ");
INSERT INTO uvl_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Iesus hile kileng Tir pe i haka lange Siton pe i sio langa ech hetaliliu ngana nge Kalelea nga tuele kina nenge ene Tekapolis. ");
INSERT INTO uvl_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Hana hel te takisia none lange Iesus. Non neu talngana hit pe ana hengetau meena. Pe te hele lange Iesus ke tal heke penna nge i. ");
INSERT INTO uvl_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Pe Iesus mene kelkel ia non neu nge hulua pe puo teua penna kukana langa ana non talngana. Ulut pe raua non neu ana hengetau. ");
INSERT INTO uvl_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Ol pe Iesus nau haka langa tapa, eingana tah pe hele, “Epata!” Luna, “O longo mule!” ");
INSERT INTO uvl_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Ueiuei mana non nem longo ke nek pe ana hengetau polpolenga pe hele ke mallaha mule. ");
INSERT INTO uvl_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Pe Iesus hele lange hehei pe hana nemur ke teke te heleia lange mele e ero ol. Hele lala nge iri ke te hele ero pe iri te tamia ana helenga ke halang tototo ol. ");
INSERT INTO uvl_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Pe iri lochloch nenge te longe te rura toto nge Iesus pe te hele, “I umeia ure lochloch ke urana mana. Pe poia iri nenge te longo ero ke te longo mule pe iri nenge te hele ero ke te hele mule.” ");
INSERT INTO uvl_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Nga etue nem hulua teat ke te eukirau pe aria ute ero nge te ngaua ol. Pe Iesus iua na hana mur lange i pe hele, ");
INSERT INTO uvl_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Letek poreke ia hulua nemur iange tetu luluch nge iau ke etue mol pe ute nge ta tunge nge iri ke te ngaua ero. ");
INSERT INTO uvl_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Nenge teke e hengaua iri ero pe e kulosia iri langa ria kileng, lape te makuk leilei pe te mete par nga kue iange iri hel nge teat nga kileng nga tau.” ");
INSERT INTO uvl_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Pe nena hana mur te hele, “Kileng nei tu loulou mana pe mele hel tetu nga lamai ero, pe itei nakuna nge tango ke ngaunga halang pe hengaua hulua nei?” ");
INSERT INTO uvl_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Pe Iesus onteia iri, “Amo beret hia mau?” Pe te hele, “Rahtele nai.” ");
INSERT INTO uvl_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Ol pe Iesus hele lange hulua ke teare sio nga ich. Pe mene beret rahtele nai neu pe hele urana nge NeHalang. Reke iri pe tunge lange nena hana mur ke te heronge lange hulua nemur. Ol pe nena hana mur te mene ke te herongo sapele. ");
INSERT INTO uvl_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Iri aria ruo tutuna hel pule. Pe Iesus hele urana lange temene nga ruo nemur pe hele lange nena hana mur ke te heronge pule. ");
INSERT INTO uvl_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","9","Hulua lochloch te ngaua ke saria una. Hulua nemur iri 4,000. Pe na hana mur te mene ke chasang iri rahtele nai nge te muta nga ngaunga aluana mur. Te ngau ke het pe Iesus kulosia iri ke tela sapele. ");
INSERT INTO uvl_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Pe i lohaka sapele nga sulang luluch nge na hana mur pe tela nga kileng nenge Talmanuta. ");
INSERT INTO uvl_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Paresio hel teat nge Iesus pe te talun ke te heleia i. Te teke te hekoukou ele i pe te onteia i ke ume hote ure palaungana e ke te eteia nge i Non Palau tuna. ");
INSERT INTO uvl_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Iesus letena poreke nge leteria manmanna nge i ero pe eingana chup pe hele, “Pomere nga imo hana heueu ana nei a ontei nga ure papalau ngana nenge a rura ia? E hele ke manmanna lange imo, lape e umeia ure palaungana nem ke a neue ero.” ");
INSERT INTO uvl_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Iesus hile sue iri pe haka mule nga sulang pe te lotele langa ech hetaliliu ngana ilina ele. ");
INSERT INTO uvl_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Iesus na hana mur leteria lilil nge te mene ngaunga ke halang. Pe aria beret elle mana ma nga sulang letena. ");
INSERT INTO uvl_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Pe Iesus hetoro hite iri, “Anau ala amo ke nek nga Paresio mur pe Herot leteria tuanin ngana, iange leteria tuanin ngana poma laka nga ure tutuna nenge tetal teua langa beret pe poia ke una haka (is).” ");
INSERT INTO uvl_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Pe nena hana mur te hele tele hel nge iri siporia, “Ee! Iesus hele ke pomai iange ara beret ero.” ");
INSERT INTO uvl_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Iesus eteia utar nenge te heleleia pe onteia iri, “Pomere nenge a heleleia nga beret nge ero? Letemo matana ero kura kai? ");
INSERT INTO uvl_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Imo matamo pe a kolkol kai? Pe talngamo pe a longo ero kai? ");
INSERT INTO uvl_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","E reke beret lime ke hana iri 5,000 te ngaua. Letemo metene ero kai? Pe chasang hia nenge te muta ia ngaunga aluana mur?” Pe te tuacholia ke te teke, “Iri analoch pe nai.” ");
INSERT INTO uvl_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Pe Iesus ontei mule iri, “Pe nenge e reke beret iri rahtele nai lange hana iri 4,000, a mene chasang hia nenge te muta ia ngaunga aluana mur?” Pe te tuacholia ke te teke, “Iri rahtele nai.” ");
INSERT INTO uvl_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Pe Iesus onteia iri, “Letemo mallaha ero toto kura kai?” ");
INSERT INTO uvl_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Iesus pe na hana mur tela ke te lohot nga kileng nenge Petsaita pe hana hel te mene none nenge matana hit at nge Iesus pe te hele ke kerkereng lange i ke rahaka nge non neu. ");
INSERT INTO uvl_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Iesus rahite non nem nga penna pe he i ia i ke tei hot nga kileng neu ke tetu ke iri toro mana. Ol pe Iesus ulut haka nga non neu matana pe tal heke penna nge i pe onteia i, “O amnei langa matam? O esia ute kau?” ");
INSERT INTO uvl_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Non neu nau haka pe hele, “E neue hana pe te pomanga ae mur nge tei rara.” ");
INSERT INTO uvl_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Iesus tal heke mule penna nga non neu matana pe nau ke urana sapele pe esia ure lochloch ngana ke mallaha ol. ");
INSERT INTO uvl_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Pe Iesus kulosia i langa na kileng pe hele lange i ke teke, “Ola pe oteu la mule nge Petsaita ero.” ");
INSERT INTO uvl_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Pe Iesus pe na hana mur tei ke tela nga kileng nemur nge Kaesarea Pilipai. Teii nga kue pe Iesus onteia iri, “Hehei pe hana te teke iau itei?” ");
INSERT INTO uvl_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Pe te tuacholia ke te teke, “Hel te teke iong Ioanes nenge Henunun. Hel te teke iong Elaisa pe hel te teke iong hetatalonga e.” ");
INSERT INTO uvl_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Iesus onteia iri, “Pe imo? A teke iau itei?” Pe Petrus hele, “Iong Mesias, nenge NeHalang hele tala ia ke teke kulosia at.” ");
INSERT INTO uvl_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Iesus toto hita lange iri ke teke, “A hele hote iau lange mele e ero.” ");
INSERT INTO uvl_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Ol pe Iesus talun ke hetore nena hana mur, “Non Tuna lape takisia melmelenga palaungana. Pe hana papalauna pe tunginga ana hana mur aria papalauna mur pe hana nenge te hetottore hotonga mur, lape lemeria ero ia i pe te hune i ke mete. Pe nga etue mol ngana, lape maul haka mule.” ");
INSERT INTO uvl_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Iesus hemallaha hot tote nei lange iri. Ol pe Petrus mene hot kelkel ia i pe talun ke hele salia i. ");
INSERT INTO uvl_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Pe Iesus hulia i ke nau la mule nge na hana mur pe heleia Petrus ke teke, “Satan, oua nge iau. Letem tuanin ngana mur song ke nanasia NeHalang letena tuanin ngana ero iam. O nanas mene hana leteria tuanin ngana pa iam.” ");
INSERT INTO uvl_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Ol pe Iesus iua na hana mur pe hulua nemur ke teat nge i pe hele lange iri ke teke, “Mele nenge teke at luluch nge iau, hile hote i pe takisia ana manga toto ke nanasia iau. ");
INSERT INTO uvl_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Iange mele nge teke eleis maulngana nga ich, lape alparia maulngana toto ngana. Pe mele nge teke alparia maulngana nge iau, nga helenga urana toto ngana lape mene mule maulngana toto. ");
INSERT INTO uvl_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Pomere, urana nge none mene ure lochloch nga ich ke poia i ke alparia maulngana toto ngana? Nem lape ero! ");
INSERT INTO uvl_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Ute e ero toto nge tunge mele maulngana toto ngana. ");
INSERT INTO uvl_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Hehei pe hana nga etue poreke ngana nei, leteria manmanna nge NeHalang ero. Nenge teke mele meia i at nge iau pe nga lek hengetoro mur, Non Tuna lape meia i lange mele nem pule nga etue nenge sio at luluch nga Temene nena hemalmalinga luluch nge angkelo mur nenge te pengpeng.” ");
INSERT INTO uvl_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Iesus mene une nena helenga ke la pe hele ke teke, “E hele lange imo ke manmanna. Hel nge imo nenge ames nga lamai heueu nei, lape a maulul kura ke a esia NeHalang nena naualanga pe nekinga nge at luluch nga kikina ngana toto.” ");
INSERT INTO uvl_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Etue rahtele elle nga hoena Iesus mene Petrus pe Ieims pe Ioanes ke iri ul te haka langa hengene nga lut toto ke tetu ke iri toro mana. Tenau la pe Iesus singina pe na hengeron lohot ke altoto. ");
INSERT INTO uvl_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Na hengeron hussu pe sinaha toto. Mele nga ich nei purpur ero nge poia ke hussu ke pomau. ");
INSERT INTO uvl_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Ol pe iri mol te naue Elaisa pe Moses nge te hele lululuch nge Iesus. ");
INSERT INTO uvl_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Pe Petrus hele haka lange Iesus, “Non Soke, imem koi motu nei lo pe urana nge mo hemes ke pelpele iri mol ke lem e pe Moses na e pe Elaisa na e.” ");
INSERT INTO uvl_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Petrus pe pekngana mur te matau toto lo iau pe letena lilil nga utar nenge lape heleia. ");
INSERT INTO uvl_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Ol pe ulu lohot pe ana mulil ma hite iri pe te longe helenga e nge sio at nga ulu ke teke, “Tuk nge mutek tau tote koi. A longo taua i!” ");
INSERT INTO uvl_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Tenau rara ke ueiuei mana pe te neue mele ero ol. Tenau mene Iesus nge tu luluch nge iri. ");
INSERT INTO uvl_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Nga tesio mule ngaria nga hengene Iesus hele lange iri, “A hele lange mele ero nga utar nge a naue kela het nga Non Tuna maul haka mule ngana nga metenga.” ");
INSERT INTO uvl_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Te longo taua na helenga pe iri siporia te ontei hel mule nge iri, “Maulinga nga metenga luna ma ke mere?” ");
INSERT INTO uvl_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ol pe te onteia Iesus, “Pomere nenge iri nenge te hetottoro nga hotonga te teke Elaisa at tala?” ");
INSERT INTO uvl_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Pe Iesus tuacholia ke mai, “Manmanna ke Elaisa at tala ke he pengpengia ure lochloch. Pe pomere nenge NeHalang na helenga nenge tehas sue ke ulolo, hele ke teke Non Tuna lape takisia melmelenga palaungana pe lemeria ero ia i? ");
INSERT INTO uvl_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","E hele lange imo, Elaisa at lo pe hehei pe hana tepoi poreke i nga lemeria ngaria ke pomanga NeHalang na helenga nenge tehas sue nge nike hele ngana.” ");
INSERT INTO uvl_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Tesio at mule nga hengene pe te esia hulua nge temes liliu ele Iesus nena hana mur pe hana nenge te hetottoro nga hotonga, tetak ulu helelia helenga luluch nge iri. ");
INSERT INTO uvl_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Hulua te esia Iesus pe te rura pe te iech pe te song lange i. ");
INSERT INTO uvl_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Pe Iesus onteia na hana mur, “A tak ulu heleleia helenga nga utar?” ");
INSERT INTO uvl_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Pe None nga hulua leteria tuacholia, “Non Soke, e mene tuk at nge iong iange uneinei tuteu nge i pe poia i ke hele ero. ");
INSERT INTO uvl_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Etue hel uneinei teu heke i pe tamal sue langa ich pe melona tua nga hanna, pe tele hite ngingina pe ma ke tak ton. Pe e onteia lem hana mur ke te helope hote pe te alker taua.” ");
INSERT INTO uvl_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Iesus hele lange iri, “Etu luluch nge imo ke mala toto lo. Pomere nenge letemo manmanna ero mana mam? Etu luluch nge imo ke mere ol? Pe e halaua imo ke mere ol? A mene kol nem at nge iau!” ");
INSERT INTO uvl_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Te mene i lange Iesus. Mala ero pe uneinei esia Iesus pe tamal sue kol nem langa ich. Poia i ke loiloi pe sechul rara pe melona tua nga hanna. Ol pe Iesus onteia temene, ");
INSERT INTO uvl_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","“Ure nem tu nge i ke etue hia lo?” Pe kol neu temene hele, “Nga i kino ngana nike. ");
INSERT INTO uvl_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Kokoeses uneinei tamal heke i nga oan ngingina ngana ke teke une i. Pe tamal teua i nga ech. Pomere, nakum toto nge letem poreke ia imem pe o halaua imem kau?” ");
INSERT INTO uvl_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Pe Iesus hele, “Oe, iong o hele ke o teke, ‘Nakum toto?’ Pe iong nakum pule la! Mele nenge letena manmanna, nakuna toto nge poia ure lochloch ngana.” ");
INSERT INTO uvl_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Ueiuei mana kol neu temene hele, “Iau letek manmanna ngana koi tu, pe kerkereng ero. O halaua iau ke letek manmanna ngana tu ke kerkereng!” ");
INSERT INTO uvl_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Iesus esia hulua nge lape ueiuei mana pe te emurung taua iri, tunge helenga kerkereng ngana langa uneinei ke teke, “Iong uneinei nenge o poia kol nem ke talngana hit pe hanna hit, o lohot nge i pe otu teu mule nge i ero ol!” ");
INSERT INTO uvl_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Uneinei neu alngana haka pe heloiloi ia i pe iuch hot sapele. Pe kol neu nakuna pomanga mete. Kela iri lochloch te heleia, “Kol nem mete iam!” ");
INSERT INTO uvl_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","La ol pe Iesus rahite i nga penna pe isipona mes haka. ");
INSERT INTO uvl_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Iesus pe na hana mur teteu langa pele ke iri toro mana, pe na hana mur te ontei hote i, “Pomere nenge mo alker taua uneinei nemai?” ");
INSERT INTO uvl_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Iesus hele, “Hetalaulaunga mana helope hote ure nenge pomai. Ute e ero ol.” ");
INSERT INTO uvl_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Iesus pe na hana mur te lohaka nga kileng neu pe tei tele kileng nenge Kalelea. Iesus lemene ero nge mele eteia tu ngana, ");
INSERT INTO uvl_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","iange hetottore nena hana mur pe hele lange iri, “Lape mele tung heke Non Tuna langa hana peria ke te hune i. Pe nga etue mol ngana lape maul haka mule nga metenga.” ");
INSERT INTO uvl_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Iri te eteia hengetoro nei luna ero pe te matau pule nge te onteia i. ");
INSERT INTO uvl_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Te lohot nge Kapernam pe teteu nga pele letena pe Iesus onteia na hana mur, “A hele helel ia utar nga kue?” ");
INSERT INTO uvl_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Pe te tuacholia i ero iange nga kue te hele helel ia itei nge iri nge i palaungana toto. ");
INSERT INTO uvl_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Iesus kila sio pe iua nena hana analoch pe nai nem pe hele lange iri, “Itei nenge lemene ke teke i muka, au sue i ke i hoena pe ume mule nge iri lochloch.” ");
INSERT INTO uvl_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Iesus hele ke het pe mene mele sune pe hemesia i nga mataria. Lolo heke i pe hele lange iri, ");
INSERT INTO uvl_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Itei nenge longo taua iau ke poi ke urana lange mele sune nge mai, poi ke urana at nge iau pule. Pe itei nenge poi ke urana at nge iau, poia at nge iau toro ero. Poia la pule nge i nenge kulos sue iau at.” ");
INSERT INTO uvl_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Ioanes hele lange Iesus, “Non soke, mo esia none nge helope hotot uneinei nga lem kerkerenga, pe mo hele lange i ke poia ero iange pekngara ia i ero.” ");
INSERT INTO uvl_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Iesus hele lange iri, “Apoi ele i ero, iange mele nenge poi hotote merakulo nga lek kerkerenga lape hele poreke iau ke ueiuei mana ero. ");
INSERT INTO uvl_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Iange mele nenge hele poreke ita ero, i pekngara ia. ");
INSERT INTO uvl_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","E hele ke manmanna lange imo, mele nenge eteia ke lek hana mur imo pe tunge ech lange imo ke halaua imo, NeHalang lape tuacholia ke tunge ure urana ngana lange i.” ");
INSERT INTO uvl_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Nenge teke mele poia elle nge aina kinkino ngana nemur nenge leteria manmanna nge iau ke poia poinga poreke ngana, tuacholinga nga poinga nei poreke toto nga te heon hite um palaungana nga mele nem kanna pe tesau hote i nga leme. ");
INSERT INTO uvl_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","Pomalam, nenge teke perim poia iong ke o losio nga poinga poreke ngana, o chatoa ke lasus! Urana toto nge perim ero pe o mene maulinga nge Iesus. Pe poreke ngana, perim nai tetu pe osio langa oan nge henge lemlem. ");
INSERT INTO uvl_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Pe nenge teke apem poia iong ke o losio nga poinga poreke ngana, o chatoa ke lasus! Urana toto nge apem ero pe o mene maulinga nge Iesus. Pe poreke ngana, apem nai tetu pe osio lange oan nge henge lemlem. ");
INSERT INTO uvl_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Pe nenge teke matam poia iong ke o losio nga poinga poreke ngana, osul hote ke lasus! Urana toto nge matam ero pe o mene maulinga nge Iesus. Pe poreke ngana, matam nai tetu pe osio langa oan nge henge lemlem. ");
INSERT INTO uvl_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Nga kileng nenge matmata lape tole iri, pe ana oan mete erochro. ");
INSERT INTO uvl_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Lape oan helemlem ia iri lochloch. ");
INSERT INTO uvl_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“Mesmes urana. Pe nenge teke mesmes ngana het, lape mesmes mule ke mere ol? A poia atu ngamo ke manga mesmes pe a nauele imo ke nek.” ");
INSERT INTO uvl_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Iok, Iesus lohaka nga kileng nem pe i ke lange Iutea, pe lotele nga ech nge Iortan. Hulua teole taua i pe hetoro mule iri ke manga popoia ke kokoeses. ");
INSERT INTO uvl_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Pe Paresio hel tela nge Iesus pe te ollaka hote i. Te onteia i, “O hele at nge imem. Hotonga hele ke teke urana nge none hile nehei pule?” ");
INSERT INTO uvl_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Iesus tuacholia pe ontei, “Moses tunge hotonga tei lange imo?” ");
INSERT INTO uvl_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Pe iri te tuacholia. “Moses tunge hotonga lange Israel mur pe hele ke teke, ‘Mele nenge lemene ke hile nehei, isipona asia alalaha ke hele tote i nge hile nehei lo.’” ");
INSERT INTO uvl_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Pe Iesus hele lange iri, “Moses tunge hotonga nem iange te hetore imo pe anali toto nge a longo tau. ");
INSERT INTO uvl_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Pe nga talun ngana nga ure lochloch te lohot ngaria, ‘NeHalang ala hote none pe hei e ke pomanga NeHalang nena alalaha hele ngana.’ ");
INSERT INTO uvl_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","‘Ke pomalam non nem hile temene pe tana pe tu luluch nge nehei ");
INSERT INTO uvl_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","pe te lohot ke iri elle mana nga singiria.’ ");
INSERT INTO uvl_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Ke NeHalang puo tomia imo pe mele pele las mule imo ero ol.” ");
INSERT INTO uvl_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Iok Iesus pe na hana mur teteu la mule nga pele letena pe na hana mur te onteia i nga ure nemur. ");
INSERT INTO uvl_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Pe hele lange iri ke teke, “None nenge hile nehei pe lei haka mule, poia poinga nge poreke lange nehei. ");
INSERT INTO uvl_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Pomalam pule, hei e nenge hile ene pe lei haka mule, poia poinga nge poreke lange ene.” ");
INSERT INTO uvl_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Hehei pe hana nga kileng nem, te laia tuturia mur nge Iesus ke rahaka nge iri pe Iesus na hana mur tepoi ele iri. ");
INSERT INTO uvl_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Iesus esia poinga nei pe letena inin pe hele lange na hana mur, “Apoi ele iri ero, teat nge iau. Iange NeHalang nena mutenga tu nge iri nenge pomai. ");
INSERT INTO uvl_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","E hele ke manmanna lange imo, mele nenge mene NeHalang nena naualanga pe nekinga ke pomange mele sune ero, lape teu laia ero.” ");
INSERT INTO uvl_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Iok laol, Iesus lole aina kinkino ngana pe tal heke penna nge iri ke pete iri. ");
INSERT INTO uvl_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Iesus lohaka ke i mulmule lo pe none song la pe tualou nga matana pe onteia i, “Non Soke urana ngana ellem, lape epoi ke mere ke e mene maulinga ke koko?” ");
INSERT INTO uvl_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Iesus onteia i, “Pomere nenge o hetue iau ke urana? Mele e ero nge urana. NeHalang i toro mana. ");
INSERT INTO uvl_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","O eteia hotonga nenge NeHalang tunge lange Moses. ‘O hune mele ero. O tak tote mele nehei ero. O keme ero. O hele poreke mele ero. O topala hite lem kemenge ero. O longo taua temem pe tam.’” ");
INSERT INTO uvl_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Pe non neu hele, “Non Soke, e longo taua hotonga lochloch ngana nemur nga iau lolomele ngak nike.” ");
INSERT INTO uvl_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Iesus mutena taua non neu pe nau pengpeng lange i pe hele, “Ute elle mana o poia ero kura. O mene lem urelu mur pe o laia nga ingala matana ke te olia pe o tunge ana umtutuna lange pakar mur. Pomalam otu ke nek nga lut nga tapa. Iok, o nanasia iau ol.” ");
INSERT INTO uvl_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Non neu longe pe nakuna poreke pe ua iange letena ia nena ure nge halang. ");
INSERT INTO uvl_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Iesus nau lange na hana mur pe hele lange iri, “Anali toto nge iri nenge reria urelu halang pe teteu langa NeHalang naualanga pe nekinga!” ");
INSERT INTO uvl_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Iesus na hana mur te ruraia helenga nei pe Iesus hele sapele, “Pekngak mur, anali toto nge ateu langa NeHalang nena naualanga pe nekinga. ");
INSERT INTO uvl_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Semel ngana nge kamel palaungana iteu nga pakeka polona sune. Pe anali toto ngana nge mele nenge na ure halang pe iteu langa NeHalang nena naualanga pe nekinga.” ");
INSERT INTO uvl_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Iesus na hana mur leteria lilil toto nga helenga nei, pe te ontei hel mule nge iri, “Itei nenge lape NeHalang mene mule i mai ol?” ");
INSERT INTO uvl_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Iesus nau la mule nge iri pe tuacholia, “Imo sipomo nakumo ero toto nge a halau mule imo pe nge NeHalang semel mana. NeHalang nakuna nge poia ure lochloch ngana.” ");
INSERT INTO uvl_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Mala ero pe Petrus lohaka pe hele, “Onau, imem mo hile sue lemem urelu lochloch ngana pe mo nanasia iong.” ");
INSERT INTO uvl_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Iesus hele lange iri, “Oe, e hele lange imo ke manmanna, itei nenge hile sue na kileng pe titina mur pe liliuna mur pe temene pe tana pe aina kinkino ngana pe ich ke nanasia iau pe haliu hote lek helenga urana ngana, ");
INSERT INTO uvl_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","i lape mene mule ke halang toto nga etue nei. Lape mene mule ke ana non kina lime; nga pele mur pe titina mur pe liliuna mur pe tatana mur pe aina kinkino ngana pe ich. Pe pule lape hana hel tepoi poreke i pe nga hoena lape tu luluch nge iau ke kokoes. ");
INSERT INTO uvl_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Pe hulua nenge te heto heke iri ke iri nga muka, lape iri hoena. Pe hulua nenge te au sue iri ke iri hoena, lape iri muka.” ");
INSERT INTO uvl_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Iesus pe na hana mur tei nga kue ke te haka lange Ierusalem pe Iesus i muka ia iri. Pe na hana mur leteria tuanin rara ke halang pe iri nenge te nanasia iri te matau. Ol pe Iesus mene hot mule na hana analoch pe nai nem pe hele mule ia ure nemur nenge lape lohot nge i. ");
INSERT INTO uvl_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Iesus hele lange iri, “A longo at. Ta haka lala nge Ierusalem koi pe Non Tuna lape te tung heke i lange tunginga ana hana mur aria papalauna mur pe iri nenge te hetottoro hotonga. Iri lape te talue helenga ke te teke mete. Ke het pe lape te tunge i lange hana lomona ngana mur. ");
INSERT INTO uvl_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Pe lape te hele poreke i pe te ulut lolele i pe te palia i pe te hune i. Pe nga etue mol ngana nga hoena lape maul haka mule.” ");
INSERT INTO uvl_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Sepeti tutuna mur Ieims pe Ioanes, tela nge Iesus pe te hele, “Non Soke, mutemem ke mo teke o poia ute nge imem.” ");
INSERT INTO uvl_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Pe Iesus onteia iri, “Lememo taua utar nge iau?” ");
INSERT INTO uvl_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Pe iri te tuacholia, “Nga etue nenge ola nga temem na kileng nenge ririua tuia pe oare nga lem kilanga palaungana nenge te hemalmal heke iong ia, o hetakile emem e nga ilim hele nenge hoihoi pe e nga ilim hele nenge tamalmal ke imem soke luluch nge iong.” ");
INSERT INTO uvl_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Iesus hele lange iri, “A eteia utar nemam? A eteia ute ero iam! Iau lape e takisia melmelenga palaungana. Pe nakumo nge a takisia pule? Ure poreke ngana lape lohot nge iau ke e mete. Pe nakumo nge a mete ke pomau pule?” ");
INSERT INTO uvl_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Pe te tuacholia, “Oe, nakumem la.” Iesus hele lange iri, “Manmanna ke lape a takisia melmelenga palaungana ke pomange iau. Pe ure poreke ngana lohot nge imo ke a mete ke pomange iau. ");
INSERT INTO uvl_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Pe iau ak ume nenge e hesilei hote imo ke a are nga ilik hele pe hele ero. Mele hel nenge muria nem lape iri soke luluch nge iau pe NeHalang hesilei hote iri ke het lo.” ");
INSERT INTO uvl_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Iesus nena hana iri analoch nem te longe Ieims pe Ioanes reria helenga pe leteria inin taua iri. ");
INSERT INTO uvl_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Iesus eukirau mule iri lochloch pe hele, “Imo a eteia hana lomona ngana mur reria poinga lo. Aria soksoke ngana mur tetal hekeke iri ke te teke iri mukmuka nga ure lochloch. Pe te teke te mene kerkerenga palaungana pe tenau ele ure lochloch. ");
INSERT INTO uvl_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","A nanas taua poinga nenge mai ero. Mele lemene ke teke lohot ke i palaungana, talsue i pe ume mule nge imo lochloch. ");
INSERT INTO uvl_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Pe mele lemene ke i lohot ke i muka, iok, talsue i pe ume ke pomanga lemo hengekuleilei ana non ia. ");
INSERT INTO uvl_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Iange Non Tuna pule at pe tal heke i ero. Sio at pe talsio mene i pe takisia melmelenga palaungana nenge hemas mule hulua halang.” ");
INSERT INTO uvl_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Iesus pe na hana mur tela nge Ieriko. Te lohaka nge Ieriko pe tei mule pe hulua te nanasia iri. Pe ne Timias tuna Patimias matana hit pe arare nga kue ilina ke longlong umtutuna. ");
INSERT INTO uvl_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Ana non longe nge manga Iesus nge Nasaret kou atat pe alngana haka, “Iesus, Teuit tuna! Letemia iau ke o halaua iau!” ");
INSERT INTO uvl_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Pe iri halang tepoi hele pe te hele lange i ke reng. Pe ero. Non neu alngana ke soke toto ol, “Teuit tuna, letemia iau ke o halaua iau!” ");
INSERT INTO uvl_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Ol pe Iesus mes sapele pe hele, “A iua i ke at.” Te iu sapele non neu pe te hele, “Atong o lohaka pe o iech, iange i kou iuiua iong.” ");
INSERT INTO uvl_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Non neu sau sue nena hengeron nenge lololo ana pe tamu haka pe lange Iesus. ");
INSERT INTO uvl_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Iesus onteia i, “Lemem taua utar nge iau?” Pe non neu tuacholia, “Non Soke, e teke matak charchara mule.” ");
INSERT INTO uvl_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Pe Iesus hele, “Ola ol. Letem manmanna ngana poia iong ke o urana lo.” Non neu matana charchara sapele pe nanasia Iesus nga kue. ");
INSERT INTO uvl_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Tei ke heroi lange Ierusalem pe tei haka nga hengene nenge Oliua. Pe te lohot nga tuele tana nenge Petpage pe Petani. Iesus kulosia nena hana nai ");
INSERT INTO uvl_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","pe hetoro hite iri, “Imo nai ai langa tuele tana nenge a naue la neu. Ai ke ala pe a esia tongki nge te kale hite pe mele songia ero kura. Aun hote pe a mene at. ");
INSERT INTO uvl_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Pe nenge teke mele onteia imo, ‘A potatar ia ure nemam?’ Pe a hele lange i ke a teke, ‘Non Soke mutena taua ke teke la, pe at muleia kura.’” ");
INSERT INTO uvl_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Tei ke tela pe te hottaua tongki nge kalenga hit ke mes nga kue nga pele matana pe te un hote. ");
INSERT INTO uvl_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Hana hel nge temes luluch te ontomoia iri, “A un hote tongki nem ke a potaria?” ");
INSERT INTO uvl_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Pe te tuacholia ke pomanga Iesus hele ngana lange iri pe te renge iri ke tela. ");
INSERT INTO uvl_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Te mene tongki lange Iesus pe tesau heke reria hengeron langa ana ure ke Iesus are haka ia. ");
INSERT INTO uvl_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Hehei pe hana tesau parai ia reria hengeron nga kue tana. Pe hel tela nga ume ke te chatoa hakau ina mur pe te tatach hote nga kue. ");
INSERT INTO uvl_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Iri nenge tei nga muka nge Iesus pe iri nenga hoena, singiria kikele NeHalang pe te makul haka, “Ta heto heke NeHalang! Nena petanga tu nge i nenge kulos sue at nga Non Soke ene! ");
INSERT INTO uvl_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","NeHalang pete etue nenge atat ke pomanga pete etue nenge temere Teuit esele Israel mur nge nike. Ta heto heke NeHalang nga lut toto!” ");
INSERT INTO uvl_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Iesus iteu lange Ierusalem, pe iteu langa temene na pele. Pe nau rara nga ure lochloch. Nau rara ke het pe iri ul na hana analoch pe nai nem, tei sereng mana nga ulei ke tela nge Petani. ");
INSERT INTO uvl_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Pomange rou, te lohaka nge Petani ke tela mulmule nge Ierusalem pe Iesus mete ana. ");
INSERT INTO uvl_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Esia ae popi nge ina halang pe mes nga tau pe ila ke teke nau. Lape nganangana ma ero? La ke es pe ina mana pe nganangana ero iange ana etue nenge hei ero. ");
INSERT INTO uvl_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Iesus hele taua ae popi nem ke teke, “Nganangam ero ol!” Pe na hana mur te longe. ");
INSERT INTO uvl_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Tela ke tesau hot nge Ierusalem pe Iesus i teu langa temene na pele. Pe talun ke lope hote iri nenge tei alala nga temene na pele. Pe hekale hulia hatanga nenge te hetata umtutuna ia pe arenga nenge iri nenge tei alala ia ngie. ");
INSERT INTO uvl_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Pe heo ele iri nenge te loloch urelu pe te tamo tele rara nga temene na pele letena. ");
INSERT INTO uvl_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Pe lohaka pe hetore hehei pe hana ke pomai, “NeHalang nena alalaha nenge tehas sue ke ulolo, hele ke teke, “‘Lape te hetue lek pele ke hehei pe hana nga kileng pe kileng reria hetalaulaunga ana pele.’ Pe imo a poia ke nakuna pomanga kemenge kina mur reria pele nenge te talkomkome ia.” ");
INSERT INTO uvl_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Tunginga ana hana mur aria papalauna mur pe hana nenge te hetottoro hotonga te longe ke pomau pe te tango rara kue nenge lape te hune Iesus. Pe te mataua i iange hulua lochloch te rura ia non ngana na helenga. ");
INSERT INTO uvl_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Nga ulei Iesus pe nena hana mur te lohaka mule nga tuele tana neu. ");
INSERT INTO uvl_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Pomange rou nga uach te nanasia kue nem pe te naue ae popi neu nge kalum ke sio langa ulanlana mur. ");
INSERT INTO uvl_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Petrus letena metene utar nenge lohot pe onteia Iesus, “Non Soke, onau la! Ae popi nenge lem helenga makia kou mete!” ");
INSERT INTO uvl_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","23","Pe Iesus hele lange iri ke teke, “E hele ke manmana toto lange imo. Nenge teke letemo manmanna nge NeHalang, amo e hele langa hengene nei, ‘O lohaka pe ola ke osau teua iong nga ruach letena!’ Nenge teke letem nachnai ero pe letem kerkereng mana nga utar nenge o heleia, NeHalang lape poia ke lohot nge iong. ");
INSERT INTO uvl_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Ke pomalam e hele lange imo: Nga etue nenge a hetalaulau pe a ontei nga ute, letemo manmanna toto ke a mene ure nem, pe lape a mene ure e nenge a ontomoi iau ia. ");
INSERT INTO uvl_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Pe nenge teke omes ke o hetalaulau pe letem metene poinga poreke ngana nge mele poia lange iong, letem poreke ia mele nem mukam. Ke pomalam temere nga lut lape letena ia iong nga lem poinga poreke ngana mur pule. ");
INSERT INTO uvl_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Pe nenge teke letem poreke ia hehei pe hana nga reria poinga poreke ngana mur ero, temem nga lut lape letena ia iong nga lem poinga poreke ngana mur ero pule.” ");
INSERT INTO uvl_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Iesus pe na hana mur teat mule nge Ierusalem pe Iesus i teu nga NeHalang na pele palaungana. Pe tunginga ana hana mur aria papalauna mur pe hotonga ana hetoronga mur pe almasinga ana hana mur teat nge i. ");
INSERT INTO uvl_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Pe te onteia i, “O kerkereng ngam mere nge o poia ure nemur? Itei he kerkereng ia iong ke o poia iri?” ");
INSERT INTO uvl_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Iesus tuacholia iri, “Lape e onteia imo mukam. Pe nenge teke a tuacholia at nge iau, iok iau lape e tuacholia lemo onteinga. ");
INSERT INTO uvl_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","A hele at nge iau, Ioanes nena kerkerenga nenge henunun nem at langai? At nge NeHalang ma at nge mele nga ich?” ");
INSERT INTO uvl_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Te hele hel mule nge iri, “Lape ta hele ke mere mai? Nenge teke ta tuacholia ke ta teke, ‘At nge NeHalang.’ I lape ontei mule ita ke, ‘Pe pomere nenge letemo manmanna nge i ero?’ ");
INSERT INTO uvl_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Pe nenge teke ta teke, ‘At nge mele mana nga ich’ hulua nei lape te lope ita.” (Iri te matau iange hulua ramaria kerkereng toto nge Ioanes i hetatalonga.) ");
INSERT INTO uvl_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Ol pe te hele lange Iesus ke te teke, “Mo eteia ero i.” Pe Iesus hele lange iri, “Iok, iau pule lape e tuacholia lemo onteinga ero nga kerkerenga nenge e popoia urelu nemur.” ");
INSERT INTO uvl_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Ol pe Iesus hele lange iri nga helenga opene, “Nga etuene e none tue uain ana late pe haua ana mapuo ke liliu tom. Pe selia polo nenge lape poi hote uain nganangana eina ia. Pe hemesia naungaala ana pele ke ona langa lut ke tenau ele. Pe tung sue late nem lange hana hel ke tenau ele pe i kela ol. ");
INSERT INTO uvl_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Pe nga lulunga ana etue, ume tokoninga nem kulosia nena none ke la mene nena uain nganangana hele. ");
INSERT INTO uvl_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Pe iri nenge tenau elele ume nem, te laua ume tokoninga nena non pe tepal poreke i pe te kulosia i ke patpata mana la ol. ");
INSERT INTO uvl_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Ol pe ume tokoninga kulosia nena none pule ke lange iri. Pe iri nenge tenau elele ume nem tepal chachia palpalna pe tepoi poreke tote i. ");
INSERT INTO uvl_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Pe kulosia nena none pule pe te hune i. Pe kulosia nena hana mur hel pule pe hana nemur te palia iri pe te hune hel ke te mete. ");
INSERT INTO uvl_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Pe elle mana nge tu ol, ana non tuna nge mutena tau tote. Nga hoena toto ol kulosia tuna pe hele, ‘Lape te renge tuk pamla.’ ");
INSERT INTO uvl_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Hana nemur teare pe te neue ana non tuna nge i ke atat pe te hele tele hel nge iri, ‘Non nem tuna lape mene lochloche ure nemur. Ta hune i pe ta mene nena ure nemur ke rera ia.’ ");
INSERT INTO uvl_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Ol pe telaua i pe te hune ke mete pe tesau hote i nga ume.” ");
INSERT INTO uvl_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Pe Iesus ontei, “Ol pe ume tokoninga nem poia utar ol? I lape at pe hune hana nemur pe tunge ume nem lange hana hel pule ke tenau ele. ");
INSERT INTO uvl_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","A sisia NeHalang nena alalaha ero kai? ‘Iri nenge te hemesmes pele, te esia um e pe te teke ma um nem poreke. Pe um nei urana toto nga um lochloch ngana nge hekerkereng ia pele nem. ");
INSERT INTO uvl_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Ure nei NeHalang poia. Ta naue pe nakuna urana mana nga matara!’” ");
INSERT INTO uvl_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Iuta mur aria papalauna nemur te teke te laua Iesus iange te eteia ke Iesus heleleia iri nga helenga opene nem. Pe ero iange te mataua hulua. Ol pe te hile sue i pe tela. ");
INSERT INTO uvl_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Pe nga hoena te kulosia Paresio mur hel pe ne Herot nena hana mur hel ke tela nge Iesus ke te ollaka hote i nga onteinga mur. ");
INSERT INTO uvl_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Tela nge i pe te hele, “Non Soke, imem mo eteia nge o hele ke pengpeng pe manmanna toto lala nge hehei pe hana lochloch. Pe letem una ero nge hana nenge reria ure halang ma une sune mana. Pe o hetoro ngam ia NeHalang na poinga urana mana. Iok, o hele at nge imem. Pomere nga rera hotonga mur, lape ta saua umtutuna ke lange non soke nenge Rom, ma ero?” ");
INSERT INTO uvl_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Pe Iesus eteia reria ollakanga pe hele lange iri, “Pomere nenge a teke a ollaka hote iau mam? A mene umtutuna elle at ke enau.” ");
INSERT INTO uvl_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Te mene umtutuna elle lange i pe ontei ia iri, “Itei ramana pe ene mai?” Pe te hele, “Non Soke nenge Rom ramana pe ene laka.” ");
INSERT INTO uvl_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Ol pe Iesus hele, “Oe, ure nenge ne Kaesa nena, a tunge lange i pe ure nenge NeHalang nena, a tunge lange NeHalang.” Pe hana nemur te rura nga Iesus na helenga pe leteria tuanin raria. ");
INSERT INTO uvl_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Satiusi mur te teke hehei pe hana nenge te mete lape te maul haka mule ero ol. Pe hel nge iri tela ke tehot nge Iesus pe te hele ke te teke, ");
INSERT INTO uvl_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Non Soke, Moses hasia hotonga e at nge ita ke pomai, ‘Nenge teke none mete hatalia nehei pe tuna ero. Non nem tina lape lei heke hei pakar nem. Pe nenge teke turia, lape te hetue ke non nenge mete nem tuna.’ ");
INSERT INTO uvl_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Nga etuene e, aina iri rahtele nai titiria mur hel. Nenge tengene ana lei pe turia ero pe mete. ");
INSERT INTO uvl_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Pe tina nei ngana lei heke hei neu pe turia ero pe mete. Pe tina mol ngana poi ke pomau pule. ");
INSERT INTO uvl_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","La ol pe titina mur lochloch te leia hei nem pe tuturia mur ero pe te mete ke pomalam pule. Pe nga hoena toto ol, hei nem mete. ");
INSERT INTO uvl_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Iok, iri lochloch te leia hei nem lo pe nga etue nenge te maul haka mule, itei lape nehei ia ol?” ");
INSERT INTO uvl_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Pe Iesus tuacholia ke teke, “Ramamo mallaha nga NeHalang nena helenga pe na kerkerenga ero. Ke ngana laka nenge letemo matana ngana song ke pengpeng ero. ");
INSERT INTO uvl_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Iange nga etue nenge NeHalang hemaul heke hehei pe hana nga metenga, tepoi ke pomange angkelo mur nga lut ke telei ero. ");
INSERT INTO uvl_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","NeHalang heleia maulinga haka mule nga metenga ana helenga lange Moses nga oan nge ngaulala pe Moses has sue ke ulolo. Pe imo mam a sisia ero ma? NeHalang hele lange Moses ke teke, ‘Iau NeHalang pe Iau Apraham ana soke, Isak ana soke, pe Iakop ana soke.’ ");
INSERT INTO uvl_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Ke pomalam, NeHalang i hana nenge te maululul aria soke ia. Hana nenge te mete aria soke ia ero. Pe imo letemo matana ngana song ke pengpeng ero toto!” ");
INSERT INTO uvl_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Non e nge hetottoro hotonga at pe longe reria helenga. Pe longe Iesus nge tuacholia Satiusi mur reria onteinga ke urana pe onteia i, “Hotonga tei nge i palaungana toto nge iri lochloch?” ");
INSERT INTO uvl_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Pe Iesus hele, “Hotonga nenge palaungana toto koi nei: ‘Israel mur, a longo. Non Soke NeHalang i toro mana ara Non Soke ia. ");
INSERT INTO uvl_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Mutemo tau tote amo Non Soke NeHalang nga kakahomo pe nga opemo pe nga letemo tuanin ngana pe nga kikimo ngamo.’ ");
INSERT INTO uvl_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Pe NeHalang nena hotonga nai ngana nenge palaungana toto ngana koi nei: ‘Mutem taua nei ngam ke pomanga mutemo taua iong sipom.’ Ke hotonga e nge palaungana toto nga hotonga nai nei ero.” ");
INSERT INTO uvl_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Pe Non nenge hetottoro hotonga hele lange Iesus, “Oe, urana Non Soke. Manmanna toto pomanga o hele ngam, nenge Non Soke NeHalang i toro mana pe mele nge i NeHalang ero ol. Ngana laka lom i toro mana lo. ");
INSERT INTO uvl_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Pe urana nge tapoi ke nek ke mutera tau tote Non Soke NeHalang nga kakahora pe nga letera matana ngana pe nga kikira ngara. Pe pule mutem taua neingam ke pomanga mutem taua iong sipom. Urana nge o longo taua hotonga papalau ngana nai nei. Iange hotonga nai nei iri papalau ngana toto nga tunginga nemur nenge te chacharuche nga oan pe nga tunginga mur lochloch.” ");
INSERT INTO uvl_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Iesus longe non neu nge tuacholia helenga ke urana mana pe hele lange i, “Iong otu ke rochroi toto langa NeHalang nena naualanga pe nekinga.” Ol pe nga hoena te matau pe te onteia Iesus ero ol. ");
INSERT INTO uvl_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Iesus hetottoro nga NeHalang nena pele palaungana pe ontei, “Pomere nenge hana nenge te hetottoro hotonga te teke Kristus i ne Teuit nette ia? ");
INSERT INTO uvl_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Opepengpeng hepengia ne Teuit ke hele ke teke, “‘Non Soke NeHalang hele lange ak Non Soke: “Oare la koi nga ilik hele nga tamalmal kela het nga etue nenge e hekou sue lem ngarang mur ke etal sue iri nga apem huna.” ’ ");
INSERT INTO uvl_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Ne Teuit isipona hetue I ke ana Non Soke. Pe pomere nenge Kristus lohot mule ke ne Teuit nette ia?” ");
INSERT INTO uvl_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Iesus hetore iri ke lala pe hele, “A nauele imo ke nek nge hana nenge te hetottoro hotonga iange muteria tau tote poinga nenge te heronia hengeron sasase ngana pe tela nga ingala matana ke te teke hehei pe hana te apala ele iri. ");
INSERT INTO uvl_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Te teke te keke ele kilanga nemur nga muka toto nge hehei pe hana nga hetoronga ana pele pe nga ngaunga matana mur. ");
INSERT INTO uvl_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Te pallaka ia pakar mur pe te mene reria pele pe urelu mur. Pe te hetalaulau ke sase toto ke te teke te poia iri ke te urana nga hulua mataria. Hana nenge pomai aria tuangachol nga hoena lape poreke toto.” ");
INSERT INTO uvl_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Iesus are rochroi nga umtutuna ana kaliu nga Non Soke nena pele pe esesia hehei pe hana nge tetal teueu reria umtutuna. Pe hana nenge reria urelu halang tetal teu ke reria umtutuna halang toto. ");
INSERT INTO uvl_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Pe hei pakar e at pe tal teua umtutuna nai nge elio ero mana. ");
INSERT INTO uvl_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Pe Iesus iua nena hana mur ke teat nge i pe hele, “E hele lange imo ke manmanna, tunginga nenge hei pakar tal teua nei, halang toto nga hehei pe hana lochloch reria nenge tetal teu nga umtutuna ana kaliu. ");
INSERT INTO uvl_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Iri hel reria umtutuna halang ma pe te mene unne mana ke at tetal teua pe hei pakar nena umtutuna unne nenge ma elele i ngana koi hile hote nei.” ");
INSERT INTO uvl_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Iesus lohaka hatalia temene nena pele palaungana ke teke lala lo pe nena none hele, “Non Soke, onau la. Um pe pele nemur nakuria urana toto!” ");
INSERT INTO uvl_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Pe Iesus hele, “O esia pele papalau ngana nemur? Lape tetu ke mau ero ol. Te toto sue pe lape ute nge tunga muria ero ol.” ");
INSERT INTO uvl_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Iesus arare nga hengene nge Oliua pe nau tele langa temene na pele palaungana, pe Petrus pe Ieims pe Ioanes pe Antreas, iri toro mana teura hot tau i. ");
INSERT INTO uvl_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","Pe te onteia i ke te teke, “Ure nei lape lohot nge ngingie? Pe utar nge lape lohot tala ke mo esia pe mo eteia ke etue nenge ure nei lohotia heroi lo?” ");
INSERT INTO uvl_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Iesus hele lange iri, “Anau ala ke nek ma lape hana hel te channanga ia imo. ");
INSERT INTO uvl_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Hana halang lape teat pe te hele nga iau ek ke te teke, ‘Iau koloi! Iau non nenge e hemasmas!’ Pe lape te channanga ia hehei pe hana halang. ");
INSERT INTO uvl_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Lape a longe palinga hel nge lohot ke rochroi mana nge imo pe a longe palinga hel pingana nge at nga tau. Pe a matau ero. Ure nemur lape te lohot tala pe imo a teke ma etue hetala ngana iam lom, pe i ero la. ");
INSERT INTO uvl_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Kileng mur tepal helel. Hana nga ich hel tepal hel luluch nge iri nenga ich hel. Mangila lape rur nga kileng lochoch. Hana halang lape aria ngaunga ero ke te metmete. Ure nemur pomanga melmelenga tala ngana nenga hohonga. ");
INSERT INTO uvl_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Anau ala amo ke nek. Ma lape te laua imo pe te laia imo nga haliunga pe te palia imo nga reria hetoronga ana pele mur. Imo lape ames nga haliunga nga hana papalau ngana mur mataria iange a nanasia iau, pe a hele hote helenga urana toto ngana lange iri. ");
INSERT INTO uvl_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Nga kileng lochloch ngana te haliu hote helenga urana toto ngana lange hehei pe hana, ke het pe etue hetala ngana at sapele. ");
INSERT INTO uvl_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Nga etue nenge te laua imo ke la te ontei hotote imo, samo loiloi nga utar nenge lape a heleia ero. Etue nem at pe letemo metene utar pe a heleia, iange helenga nem lemo helenga ia ero. Opepengpeng tunge lange imo. ");
INSERT INTO uvl_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Iri nenge titiria hel te tung mule titiria mur ke la te hune iri. Pe hana te tunge tuturia mur kela te hune iri. Pe tuturia mur te hunel luluch nge tetemeria mur pe te tunge iri ke la te hune iri. ");
INSERT INTO uvl_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Hulua lape lemeria ero ia imo iange a nanasia iau. Itei nenge rahite letena manmanna ngana kela het nga etue hetala ngana, lape e mene i.” ");
INSERT INTO uvl_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Pe Iesus hele pule ke teke, “Imo lape a naue aetapuna nge mes nga NeHalang nena pele nenge heo ngana toto letena. Pe ure nem poreke toto nga NeHalang nau ngana. (Imo nenge asisis, letemo tuanin hote helenga nei luna ke nek!). Ol pe iri nenge Iutea te esia ure poreke ngana nem pe te ua kela te talkome nga hengene mur. ");
INSERT INTO uvl_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Non nenge tu nga pele ona, sio mule ero, nem pe teu ke la mene mule ute nga pele letena ero, ua mana ke la ol. ");
INSERT INTO uvl_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Pe non nenge tutu nga ume, la mule nga nena pele ke mene nena hengeron mur ero, ua mana pule. ");
INSERT INTO uvl_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Hehei nemur nenge saria pe nenge te lololo peo mur, atong mur lape te amneia ke meena toto nge iri! ");
INSERT INTO uvl_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","A hetalaulau lange NeHalang ke etue nem lohot nga lukunna ana etue ero ");
INSERT INTO uvl_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","iange melmelenga palau ngana nei poreke nenge poreke toto. Nga etue nenge NeHalang ala hote tapa pe ich ke at heueu nei, melmelenga palau ngana pele nge pomai lohot ero. Pe lohot ngana nei, lape lohot mule ero ol. ");
INSERT INTO uvl_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Pe NeHalang lape tom choro ia etue nemur. Pe toinge ero, hulua lochloch ngana lape te mete. NeHalang hesilei hote hehei pe hana nenge i nena, pomalam tom choro mene etue nemur. ");
INSERT INTO uvl_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Nga etue nem, mele hel lape te hele lange imo ke mai, ‘O nau at, non nenge hemasmas koi! O nau la e pule kou!’ Nenge teke a longe helenga nem mur, a longo taua iri ero. ");
INSERT INTO uvl_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Iange hana hel lape te pallaka ke te teke iri Kristus nenge hemasmas pe hel te teke iri hetatalonga. Pe lape te poia ure hel nge hehei pe hana nenge NeHalang hesilei hote iri ke te ruraia. Lape te poia ure nemur ke te teke te channanga ia iri. Pe ero, nakuria ero toto nge te channanga ia iri. ");
INSERT INTO uvl_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","E hele tala ia ure lochloch lala nge imo nike pe a nauala amo ke neknek!” ");
INSERT INTO uvl_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Ure poreke ngana mur te lohot ke het pe nga hoena chaia matana lape tua ero pe teio lape tua ero pule. ");
INSERT INTO uvl_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Pe itoch mur lape tei ke te nanasia muria ero ol, te song parai pulut mana pe kerkerenga hel pule nga tapa sana lape telot sio. ");
INSERT INTO uvl_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Nga etue nem Non Tuna lape lohot nga ulu pe lohot luluch nga kikina ngana palaungana pe nena hemalmalinga. ");
INSERT INTO uvl_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Pe lape kulos sue nena angkelo mur ke tesio at nga ich, ke te eukiraua nena hana mur nenge hesilei hote iri nga kileng mur lochloch ngana nga ich. ");
INSERT INTO uvl_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Anau langa ae keng, i lape hetore imo. Nga etue nenge perperna mur te rora mule, nakuna urana. Nem, letera metene ke chaia ana etue heroi lo. ");
INSERT INTO uvl_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Pomalam pule ta esia urelu nenge te lohotot pe letera metene ke Non Tuna at mule ngana ana etue talunun lo. ");
INSERT INTO uvl_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","E hele ke manmanna toto lange imo. Hulua lochloch nga etue nei lape te maulul kura pe ure nemur te lohot. ");
INSERT INTO uvl_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Tapa pe ich lape tehet pe lek helenga mur tehet ero. ");
INSERT INTO uvl_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Pe mele etei nekia etue nem lohot ngana ero. Angkelo mur te etei ero pe NeHalang Tuna etei ero. Temene i toro mana eteia. ");
INSERT INTO uvl_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Ke a nauala ke nek, iange a eteia ana etue lohot ngana ero. ");
INSERT INTO uvl_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","I nakuna nenge pomanga none nge lohaka hatalia nena pele pe tung sue ume mur lange nena hana mur pe langa kileng nga kileng tau ngana. Iri ellechle tenau ele aria ume mur pe hele lange elle ke naualala nga pele matana. ");
INSERT INTO uvl_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Ke pomalam a nauala ke nek ol, iange a eteia pele tokoninga at mule ngana ero. I lape at mule nga ulei ma miliko tuna ngana. Nga ngie chou tangtang ma nga uach ol. ");
INSERT INTO uvl_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","A mamani ero, iange lape at mule pe hottaua imo nge a mamani. ");
INSERT INTO uvl_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Utar nenge e heleia lange imo, e heleia lange iri lochloch: Anau ala ke nek!” ");
INSERT INTO uvl_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Etue nem lohot nenge Israel mur te ngaua ngaunga matana palau ngana nenga Ingatoto pe Ngaunga Menini Ngana. Iok laol, etue nai tu kura pe ngaunga matana palaungana nem lape lohot. Pe tunginga ana hana mur aria papalauna mur pe hana nenge te hetottoro hotonga te tango rara kue e nenge talkome ke te laua Iesus pe te hune i. ");
INSERT INTO uvl_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Pe lemeria ero nge te poia nga ngaunga matana ana etue iange lape hulua te esia pe tepal paria ia iri. ");
INSERT INTO uvl_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Iesus kila teu nga Simon Lepra nena pele nge Petani. Are ke ngaungau pe hei e i teu at pe mene um e nge nakuna pomanga ech kina pe mutaia ure inangana ehech ngana nenge singira ana ia. Ure neu uruna haka toto iange te ume hote nga ae e nge inangana ehech toto. Ana hei palhote matana pe pasiling heke nga Iesus palpalna. ");
INSERT INTO uvl_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Hana hel te esia pe leteria inin pe te hele tele hel nge iri, “Pomere pa nenge hei paneu hesil sio mene ure paneu mau? ");
INSERT INTO uvl_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Nenge teke te laia nga ingala matana, lape te olia nga umtutuna ana non kina analoch pe lime pe uruna te mene pe te laia nge pakarkar una mur!” Te heleia i nga matana pe te hemeia i. ");
INSERT INTO uvl_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Pe Iesus hele, “A hemeia i ero! A hele poreke i ke? ");
INSERT INTO uvl_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Pakar mur tetu luluch nge imo ke kokoes pe nenge teke lememo, a halaua iri pule. Iau etu luluch nge imo ke kokoes ero. ");
INSERT INTO uvl_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Hei nem poi une la. Atong poi heke tele nga singik iange nga hoena lape e mete pe te poia ure nem nga singik pule. ");
INSERT INTO uvl_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Letemo metene ke nek! NeHalang na helenga lape te heleia nga kileng lochloch ngana nga ich. Pe utar nenge hei nei poia at nge iau, lape te hele hote pule ke hehei pe hana leteria metene heke mule.” ");
INSERT INTO uvl_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Iok laol, Iesus nena hana iri analoch pe nai, pe elle ene Iutas Iskariot. Iutas tuahita Iesus ana nge tunginga ana hana mur aria papalauna mur ke teke tung heke Iesus lange iri. ");
INSERT INTO uvl_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Hana nemur te longe pe te iech pe te hele lange i ke lape teol hite i. Iutas tango rara sapele kue nenge lape mene Iesus pe tung heke lange iri. ");
INSERT INTO uvl_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Iok, Ngaunga Menini Ngana ana etue talun pe te hune Sipsip Tuna ke te ngaua, ke leteria metene etue nenge Ingatoto ana. Iesus nena hana mur te onteia i, “O teke ta ngaua ngaunga nem langai?” ");
INSERT INTO uvl_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Iesus hele lange nena hana nai, “Ai teu langa tuele tana neu pe none nge takisia ech kina lape tapang ia imo. A nanasia i ");
INSERT INTO uvl_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","kela nga pele nenge i teuia pe a hele lange pele tokoninga ke a teke, ‘Non Soke teke o henonoua imem nga pele letena unne nem, nenge lape i pe nena hana mur te ngaua ngaunga matana nenge letera metene etue nenga Ingatoto.’ ");
INSERT INTO uvl_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","I lape henonoua imo nga pele letena unne nge palaungana pol nga lut, nenge ngaunga ana hatanga pe arenga mur te maia lo. Pe a tatalo ele ara ngaunga mur nga lamam.” ");
INSERT INTO uvl_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Iesus nena hana mur tei teu langa tuele tana nem pe ure lochloch ngana lohot ke manga hele ngana ia lange iri ke ulolo. Ol pe te tatalo ele ure lochloch sapele. ");
INSERT INTO uvl_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Nga miliko Iesus iri hul nena hana analoch pe nai nem, teat sapele. ");
INSERT INTO uvl_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Te are ke te ngaungau pe Iesus hele, “E hele ke manmanna lange imo, amo elle nge imo nenge ita ul ta ngaungau nei, lape tung heke iau nga hana peria.” ");
INSERT INTO uvl_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Na hana mur leteria meena sapele pe iri ellechle te onteia i, “Lape ngana kai iau mai?” ");
INSERT INTO uvl_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Iesus tuacholia, “Ngana laka e nge imo analoch pe nai nem, nenge puo teua ana ngaunga nga ngaunga eina luluch nge iau. ");
INSERT INTO uvl_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Non Tuna lape mete ke pomanga NeHalang na helenga hele talaia lo. Pe tuacholinga poreke toto ngana, lape lohot nge i nenge tung heke Non Tuna langa hana poreke ngana mur peria, ke te hune! Nenge teke non nem tana hoe i ero nike, toinge urana nge i iam!” ");
INSERT INTO uvl_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Etue nenge te ngaungau, Iesus mene ngaunga nem pe hele urana lange Temene, reke pe heronge nge nena hana mur pe hele, “A mene. Iau mirak koi.” ");
INSERT INTO uvl_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Ke het mene eulinga, hele urana lange Temene pe tunge lange iri lochloch ke tein. ");
INSERT INTO uvl_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Iesus hele, “Iau eik koi. Iau lape e mete pe eik lele ke heneue imo lochloch nga Helenga Tomunga Hel nenge NeHalang hele talaia ke teke poia. ");
INSERT INTO uvl_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","E hele ke manmanna lange imo, Iau lape einia uain e ero ol ke la ein mule uain heueu ngana nga etue nenge hulua lochloch tenau haka lange NeHalang pe te heto heke i ke aria soke ia.” ");
INSERT INTO uvl_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Iok laol, te peua aria peunga elle ke te heto heke NeHalang ke het pe tei hot sapele ke tela nga hengene nge Oliua. ");
INSERT INTO uvl_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Iesus hele lange iri, “Imo lochloch ngana lape a ua ak pe a hile sue iau, ke pomanga NeHalang na helenga heleia lo, ‘Non palau ngana lape hune naualanga nenga sipsip mur pe sipsip nemur lape te ua parai.’ ");
INSERT INTO uvl_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Pe nga hoena lape e maul haka mule nga ak metenga pe iau muka nge imo ke ela nge Kalelea.” ");
INSERT INTO uvl_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Petrus tuacholia, “Nenge teke iri lochloch te teke te ua am, iau lape e ua am ero!” ");
INSERT INTO uvl_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Iesus tuacholia, “E hele ke manmanna lange iong. Pareo tang ke henai ero kura nga miliko nei, pe o hele he mol ke o eteia iau ero.” ");
INSERT INTO uvl_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Petrus tuacholia ke kerkereng toto, “Iau lape e hele ke pomam ero toto. Nenge teke tehun luluche iau nge iong, e ua am ero pule!” Iesus nena hana mur lochloch te hele ke pomau pule. ");
INSERT INTO uvl_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Tela nga kileng nenge Ketsemani pe Iesus hele lange nena hana mur, “A are la koloi pe ela e hele luluch nge Temek.” ");
INSERT INTO uvl_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Iok, mene Petrus pe Ieims pe Ioanes ke te koko nge i. Pe Iesus letena meena toto sapele ");
INSERT INTO uvl_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","pe hele lange iri, “Letek meena ngana nei, teke hemete tote iau. Atu la mai pe a nauala.” ");
INSERT INTO uvl_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","I la pol mana pe tamal sue i lange ich pe hele lange Temene ke teke, “Auoo! Temek! Teke nakum, o poia etue nenge melmelenga palaungana nei ana ke lohot nge iau ero.” ");
INSERT INTO uvl_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Iesus hele, “Temek, iong nakum nge o poia ure lochloch ngana. O poi ele melmelenga palaungana nei nge iau. Pe o poia nga lemek ngak ero, opoi mene nga iong sipom lemem ngam.” ");
INSERT INTO uvl_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Iesus at mule pe nena hana mol neu te mamani lo. Ol pe hele lange Simon Petrus, “O mamani ke? Onau ala pol ero?” ");
INSERT INTO uvl_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Pe hele lange iri, “Anau ala pol pe a onteia Temere nga lut ke halaua imo ke a losio nga totoinga poreke ngana ero. Lape lememo toto nge a poia ure nge urana, pe singimo kerkereng ero iange imo hana mana nga ich.” ");
INSERT INTO uvl_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Iesus la mule pe hele lange temene ke pomau mana, “Auoo! Temek! Iong nakum nge o poia ure lochloch ngana. O poi ele melmelenga palaungana nei nge iau. Pe o poia nga lemek ngak ero. O poi mene nga iong sipom lemem ngam.” ");
INSERT INTO uvl_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Iesus at mule pe na hana mur te mamani pullo, iange mataria nong nongo toto. Haria meena pule nge te tuacholia na helenga iange te eteia utar nenge lape te heleia ero. ");
INSERT INTO uvl_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","At mule hemol ngana pe hele lange iri, “A mamamani kura ma? A memete ol! Iange etue nei at lo! Te tunge Non Tuna langa hana porekreke ngana mur peria lo. ");
INSERT INTO uvl_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","A lohaka pe tala ol. Anau la non nenge tung heke iau kou!” ");
INSERT INTO uvl_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Iesus helele kura pe Iutas he hot. Iutas i Iesus nena none nga nena hana analoch pe nai nem. Hana papalauna pe tunginga ana hana mur aria papalauna mur pe hana nenge te hetottoro hotonga, te kulosia hulua ke te mene palinga hel ana mese pe pakpaka pe te nanasia Iutas. ");
INSERT INTO uvl_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Iutas hele hatal reria ke teke, “Anau pe e rahite elle nge iri penna, ana non la lom. Alau sapele.” ");
INSERT INTO uvl_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Iok laol, Iutas ila sapele nge Iesus. Rahite penna pe hele, “Non Soke!” ");
INSERT INTO uvl_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Pe tela sapele pe te laua Iesus. ");
INSERT INTO uvl_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Elle nge iri mene kakop pe ule lange tunginga ana hana mur aria non palau nena none pe chato hote talngana. ");
INSERT INTO uvl_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Iesus hele lange hana nemur, “A lolochia kakop pe pakpaka ke a laua iau ia? Iau non nge e palpal kai? ");
INSERT INTO uvl_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Kokoes etu luluch nge imo pe e hetottoro nga Temek na pele. Pe pomere a laua iau ero? Ure nei lohot ke pomanga NeHalang na helenga nenge hele tala ia.” ");
INSERT INTO uvl_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Ol pe Iesus nena hana mur lochloch te ua ana sapele. ");
INSERT INTO uvl_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Kol mele e nge na hengeron menini mana nananasia Iesus. Pe hana nemur te teke te laua i pe ");
INSERT INTO uvl_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","te rahit mene nena hengeron pe i ua ia lachlach ngana. ");
INSERT INTO uvl_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Te mene heke Iesus langa tunginga ana hana mur aria non palau nena pele. Pe tunginga ana hana mur pe hana nenge te hetottoro hotonga pe hana papalaunga hel pule, iri lochloch te eukirau nga pele neu. ");
INSERT INTO uvl_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pe Petrus nanas kome pe la ke i teu nga pele nem ana aeteme matana. Ol pe kila sio luluch nge palpal hussu mur ke alelel oan. ");
INSERT INTO uvl_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Pe tunginga ana hana mur aria papalauna mur, pe pekngaria mur hel pule nenge iri muka ia haliunga palaungana nem, te ontei rara mele hel ke te hele hote Iesus na poinga poreke ngana huuna mur, ke te hune i. Te ontei rara pe te hottaua mele e ero. ");
INSERT INTO uvl_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Hana halang te nana hot pe reria helenga ma ke pengpeng ero, iange te channanga mana. ");
INSERT INTO uvl_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Hana hel temes haka pe te channanga ke te teke: ");
INSERT INTO uvl_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Mo longe Iesus nge hele ke pomai, ‘Iau lape e toto sue NeHalang na pele palaungana nenge hana te umeia pe etue mol nga hoena lape e hemes heke mule e nge pomanga hana te ume ia nga peria ero.’” ");
INSERT INTO uvl_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Hana nemur reia helenga ma ke pengpeng ero pule. ");
INSERT INTO uvl_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Tunginga ana hana mur aria palau, mes haka nga iri lochloch ngana mataria pe ontei sapele Iesus, “O longe hana nemur nge te hele poreke iong ero ma, nenge o tuacholia iri ero mam?” ");
INSERT INTO uvl_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Iesus reng mana pe heleia helenga e ero. Non soke nem ontei mule i, “Iong Kristus ma? NeHalang nenge i soke toto, tuna ma iong mam?” ");
INSERT INTO uvl_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Iesus tuacholia, “Oe iau i loi. Pe imo lochloch ngana lape a esia Non Tuna nge are nga Non Soke NeHalang nenge kikina toto ilina hele nga pen tamalmal. Pe lape a naue iau nge e sio at luluch nga ulu nga tapa.” ");
INSERT INTO uvl_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Tunginga ana hana mur aria soke neu letena inin pe ta chachia isipona nena hengeron pe hele, “Ta onteia mele hel ke te nana mule nga Iesus nena poinga mur ero ol, ");
INSERT INTO uvl_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","iange a longe na helenga poreke toto ngana nem lo! Tal heke tote i ke teke i pupure NeHalang. Lape ta tuacholia lange i ke pomere nga nena helenga poreke ngana nei?” Iri lochloch te talue helenga ke te teke te hune i. ");
INSERT INTO uvl_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Hana hel nge iri te lohaka pe te ulut lolele i. Pe te kale ele matana pe tepal sapele i. Te songlele ia i pe te hele lange i ke te teke, “O hele hote mele nenge palia iong.” Palpal hussu mur te mene i pe te tapala ule i. ");
INSERT INTO uvl_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Pe Petrus pau kou tutu nga non soke neu nena pele matana ana aeteme kura. Ol pe hei e nge umume nge non soke neu i at ");
INSERT INTO uvl_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","pe esia Petrus nge alelel oan. Nach nei hite i pe hele, “Iong pule o koko luluch nge Iesus nenge Nasaret ae?” ");
INSERT INTO uvl_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Pe Petrus hele, “Iau e eteia non nem ero i! E eteia utar nenge o heleleia nem ero iam.” Ana non ua hot kela nga kue matana pe pareo tang sapele. ");
INSERT INTO uvl_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Hei nem es mule i nge hot pe hele la mule nge iri nenge temes rochroi ke teke, “Iesus nena hana mur, elle iam nem!” ");
INSERT INTO uvl_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Pe Petrus hele, “Itei, iau? Iau elle nge iri ero i!” Mala ero pe iri nenge temes rochroi te hele lange Petrus, “Manmanna toto ke iong pule o koko nge Iesus, iange iong lem nge Kalelea.” ");
INSERT INTO uvl_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Petrus echach ala ke teke, “E hele ke manmanna lange imo pe nenge teke e pallaka, NeHalang tuachol mule at nge iau! E eteia non nenge a heleleia nem ero!” ");
INSERT INTO uvl_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Petrus hele ke het pe pareo tang he nai ngana sapele. Pe Petrus letena metene mule Iesus nena helenga nenge hele tala ia lange i, “Pareo tang ke henai ero kura pe o hele he mol ke o teke o eteia iau ero.” Ana non maluluna sio pe tang sapele. ");
INSERT INTO uvl_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Nga uach uruna tunginga ana hana mur aria papalauna mur pe hana soksoke ngana nenge Israel pe hana nenge te hetottoro hotonga pe iri lochloch nga haliunga palaungana nem te eukirau pe te hele hel ia utar nenge lape te poia lange Iesus. Ol pe te kale Iesus ke het pe te mene i ke lange Pilatus. ");
INSERT INTO uvl_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pe Pilatus onteia Iesus, “O teke Israel mur aria naungaala ana non ma iong mam?” Iesus tuacholia, “Oe, pomanga o hele ngam.” ");
INSERT INTO uvl_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Tunginga ana hana mur aria papalauna mur tetue helenga lange Iesus nga ure halang. ");
INSERT INTO uvl_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Pomalam ne Pilatus ontei mule i, “O longo langa helenga lochloch ngana nenge tetue lange iong neu. Pomere nge o tuacholia ero?” Pe Iesus tuacholia ero toto. ");
INSERT INTO uvl_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Pe ne Pilatus rura iange Iesus tuacholia helenga e ero. ");
INSERT INTO uvl_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Nga ngaunga matana lochloch ngana nga Ingatoto ne Pilatus mene hote mele elle nga tuele au ngana nga hana lemeria ngaria. ");
INSERT INTO uvl_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Nga etue nem none nge ene Parapas tu nga tuele au ngana luluch nge pekngana mur iange tepal hel luluch nge Rom mur pe te hune none. ");
INSERT INTO uvl_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Hulua te eukirau pe te lohaka ke te onteia ne Pilatus ke mene hote none nga tuele au ngana ke pomanga popoia nge nike. ");
INSERT INTO uvl_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pe ne Pilatus onteia iri, “Lememo ke e mene hote itei? Lape e mene hote Israel mur aria naungaala ana non nei?” ");
INSERT INTO uvl_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Ne Pilatus ontei iange i eteia nge tunginga ana hana mur aria papalauna mur saria keke Iesus ke te mene Iesus at nge i. ");
INSERT INTO uvl_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Pe tunginga ana hana mur aria papalauna nemur, te tunge helenga lange hulua mur ke te teke Parapas lohot nga tuele au ngana. ");
INSERT INTO uvl_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pilatus ontei mule hulua nem, “Pe non nenge a hetue ke Israel mur aria naungaala ana non nei, lape e poia ke pomere?” ");
INSERT INTO uvl_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Pe Iri lochloch te hele aka ke te teke, “A hune i nga manga toto!” ");
INSERT INTO uvl_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pe ne Pilatus onteia iri, “Ia i mai poia poinga poreke ngana nge mere nenge a teke ta hune i?” Pe te hele haka ke palaungana toto, “A hune i nga manga toto!” ");
INSERT INTO uvl_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pilatus he maluche hulua nemur ke poia Parapas ke lohot nga tuele au ngana. Pe tunge Iesus lange palinga hel ana hana mur ke te pal ule i pe te hune i nga manga toto. ");
INSERT INTO uvl_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Te mene teua Iesus langa non soke e nga gavaman na pele pe te iua pekngaria mur ke te eukirau. ");
INSERT INTO uvl_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Te songlele ule Iesus pe te heronia hengeron popopo ngana ke pomanga i naungaala ana non. Pe te mania rur nge matantana pe te here nga Iesus palpalna. ");
INSERT INTO uvl_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Pe te songlele ia i pe te hele. “Iong Israel mur aria naungaala ana non nenge soke lape tu ke sase toto ol.” ");
INSERT INTO uvl_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Tepal chongia palpalna nga ae pe te ulut haka nge i pe te tualou palaria nge i pe te songlele ke te heto heke i. ");
INSERT INTO uvl_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Te esalang ule i ke het pe tepoi hote hengeron popopo ngana nem nge i pe te heron teu mule nena hengeron la mule nge i. Pe te ape hote i lange hot ke te hune i nga manga toto. ");
INSERT INTO uvl_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Tela nga kue pe te saolia none nge ene Simon nge mule nga ume ke la mulmule nge Ierusalem. Pe palinga ana hana mur te echia i ke takis halaua Iesus nga ana manga toto. (Simon nena nge Sirini pe tutuna mur laka Aleksantria pe Rupas) ");
INSERT INTO uvl_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Te mene Iesus kela nga kileng nenge te hetue ene ke Kolkota. Helenga nem luna, “Kittol ana Kileng.” ");
INSERT INTO uvl_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Pe te mene uain pe tepoi luluche nga ute ke hemete ana inin nga singina pe Iesus lemene ero ia. ");
INSERT INTO uvl_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Te heon heke Iesus nga manga toto ke het pe te mene nena hengeron mur pe te poia esalanginga e ke tenau nge itei nenge lape mene nena hengeron mur. ");
INSERT INTO uvl_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Chaia matana nakuna nenge lala ke eurunga, pe te heon heke Iesus. ");
INSERT INTO uvl_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Pe tehas heke helenga toto ke henonoua hulua nga Iesus nena poinga una nenge te hune i ia. Tehas ia ke pomai; “IUTA MUR ARIA NAUNGA ALA ANA NON.” ");
INSERT INTO uvl_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Te heon heke hana nai pule luluch nge Iesus. Elle nga ilina hele nenga pen tamalmal pe elle nga ilina hele nenga pen hoihoi. ");
INSERT INTO uvl_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Ure nemur te lohot ke pete tote NeHalang nena helenga nenge hele ke teke, “Iesus mete ke pomanga i non poreke ngana e.” ");
INSERT INTO uvl_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Hehei pe hana tei toto nga matana pe te rure palpalria pe te rochroch. Pe te hele poreke i, “Tom malaka! O teke iong pam nge o toto sue NeHalang na pele pe o hemes heke mule nga etue mol ngana? ");
INSERT INTO uvl_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Iok, heueu nei, o halau mule iong sipom ke osio at nga manga toto nem.” ");
INSERT INTO uvl_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Pe tunginga ana hana mur aria papalauna mur pe nenge te hetottore hotonga, te hele poreke Iesus pule pe te hele tele hel nge iri, “Pomere nenge halaua mele hel pe halau mule isipona ero? ");
INSERT INTO uvl_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Iok, tanau nga Mesaia pe Israel mur aria naungaala ana non nem. Nenge teke isipona sio nga manga toto nem heueu, lape letera manmanna nge i.” Pe hana nai nge te heon luluch nge Iesus, iri pule te hele poreke Iesus. ");
INSERT INTO uvl_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Chaia matana heurunga pengpeng pe kileng au lochloch ke la het nga sinanga matana mol ngana nga ulei. ");
INSERT INTO uvl_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Ol pe Iesus alngana hot ke soke toto nga isipona na helenga, “Eloi, Eloi, lama sabachtani?” Helenga nei luna pomai koi, “Temek Ou! NeHalang, pomere nge oua hatalia iau?” ");
INSERT INTO uvl_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Hana hel temes pe te longe Iesus nge hele pe te hele, “A reng pe ta longo. Ngana kou iuiua Elaisa!” ");
INSERT INTO uvl_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","E nge iri song kela mene lumlum pe kale hite nga kula mokona. Panun teua nga uain poreke ngana pe teke tul heke ke langa Iesus hanna. Pe hele, “Tames mukam pe ta nauala. Lape Elaisa at pe mene sue i nga manga toto ma ero?” ");
INSERT INTO uvl_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Pe Iesus alngana ke palaungana toto pe mete sapele. ");
INSERT INTO uvl_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Pe huunga palaungana nenge heon teu nga NeHalang na pele palaungana chach nga lut ke la het nge sio ke sachana nai. ");
INSERT INTO uvl_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Pe palinga hel ana hana mur aria soke mes rochroi nge Iesus pe longe Iesus nena tanginga pe esia mete ngana pe hele, “Manmanna toto, non nem i NeHalang tuna toto.” ");
INSERT INTO uvl_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Hehei hel temes nga tau pol pe tenau lala nge i. Elle nge iri, ene Maria Maktala pe e ene Salome pe Maria e pule nenge tutuna mur laka Ieims kol ene nenge kino pe Iosep. ");
INSERT INTO uvl_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Nga etue nenge Iesus tu nge Kalelea, hehei nemur te nanasia i pe te halaua i. Pe hehei halang pule nenge te koko nge Iesus ke tela nge Ierusalem. Iri temes pe tenau lala nge i. ");
INSERT INTO uvl_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Nga ulei Iosep nenge Arimatea lohot. Iosep i non soke e nge Israel pe i non urana ngana nga hehei pe hana tenau ngaria. I pule kulelele etue nenge hehei pe hana tenau haka lange NeHalang ke aria soke ia. Iok, Sapat ana etue lohot ke pomange rou, pe heueu i etue nenge te tatalo ele ure mur lochloch nike. Pomalam atong Iosep matau ero toto pe langa ne Pilatus matana pe onteia i nga Iesus koluna. ");
INSERT INTO uvl_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Ne Pilatus longe nge Iesus mete lo pe rura. Pe iua palinga hel ana hana mur aria soke at pe onteia i, “Iesus mete ke mala lo?” ");
INSERT INTO uvl_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Pilatus longe non nem na helenga pe hele lange Iosep, “O mene Iesus koluna.” ");
INSERT INTO uvl_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Pomalam Iosep olia ruchinga hit hussu ngana pe mene sue Iesus koluna ke sio at pe ruch hite pe te teuia langa polo letena. Polo neu pomanga rika nenge hana te selia. Te hemara sue Iesus koluna ke het pe Iosep hesasa hulia um kela ma totele polo hanna. ");
INSERT INTO uvl_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Maria Maktala pe Maria nenge tuna Iosep tenau alala pe tenau urume kileng unne nenge tetal teua Iesus koluna ia. ");
INSERT INTO uvl_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Etue nenge heo ngana het lo pe Maria Maktala pe Maria nenge tuna Ieims pe Salome te olia ure mur nenge inangana ehech. Te teke tela ke teun hite nga Iesus koluna. ");
INSERT INTO uvl_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Nga Sande nga uach uruna tela nga kileng nenge tealo hit Iesus ia. ");
INSERT INTO uvl_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Tei pe te ontei helel nge iri ke te teke, “Itei nenge lape halaua ita ke ta hesasa hulia um palaungana nem nga polo hanna?” ");
INSERT INTO uvl_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Ol pe tenau haka pe um nem ma nga polo ilina ke ulolo. ");
INSERT INTO uvl_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Tela ke tei teu nga polo letena pe te esia non lomele ngana e nge nena hengeron hussu pe are nga iliria hele nga pen tamalmal. Pe te matau toto. ");
INSERT INTO uvl_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Pe non nem hele lange iri, “A matau ero! E eteia nge ai at ke anau rere Iesus nenge Nasaret nenge te heon heke nga manga toto. I ero nga lamai! I kou lohaka mule lo. Anau la, munna nenge ma ia kou! ");
INSERT INTO uvl_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Ala ke a hele toto nge Petrus pe Iesus na hana mur ke pomai, ‘Ngana kou i muka lange Kalelea lo. Lape a naue i nga kileng nem ke pomanga hele ngana ia lange imo lo.’” ");
INSERT INTO uvl_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Saria loiloi pe te lohot nga polo hanna pe te song sapele. Pe te hele lange mele ero iange te matau toto. ");
INSERT INTO uvl_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Iesus maul haka mule nga uach uruna nga Sande pe lohot tala nge Maria Maktala. Nge nike, Iesus poi hote uneinei iri rahtele nai nge hei nem. ");
INSERT INTO uvl_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Ana hei la pe hele lange pekngana mur, iri nenge leteria milang ia Iesus pe te tangtang ia i. ");
INSERT INTO uvl_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Te longe Maria nge hele, “Iesus kou maul haka mule pe e neue i lo!” Te longe helenga nem pe leteria manmanna nge ana hei ero. ");
INSERT INTO uvl_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Nga hoena Iesus nena hana nai, tei ke te lala nga kileng e. Pe Iesus lohot taua iri pe nakuna nenge i ero ol. ");
INSERT INTO uvl_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Teat mule pe tenene ure nenge lohot nge iri nga kue lange pekngaria mur. Pe pekngaria mur leteria manmanna nge iri nai ero. ");
INSERT INTO uvl_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Nga hoena Iesus nena hana mur nge iri analoch pe elle teare kirau ke te ngaungau pe Iesus lohot taua iri. Pe hele inin taua iri iange ramaria kerkereng pe leteria manmanna ero nge hehei pe hana nenge te teke te esia Iesus nge maul haka mule lo. ");
INSERT INTO uvl_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Iesus hele lange iri, “Ala nga kileng pe kileng nga ich pe a haliu hote helenga urana toto ngana nei lange hulua lochloch. ");
INSERT INTO uvl_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Non e nenge letena manmanna pe mene henuninga, lape maulul ke koko. Pe none nenge letena manmanna ero lape NeHalang tunge ana melmelenga. ");
INSERT INTO uvl_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","NeHalang lape tunge kerkerenga lange iri nenge leteria manmanna ke tepoi ke pomai; Lape te helope hote uneinei mur nga Iesus ene pe te hele nga helenga hel nge altoto pule. ");
INSERT INTO uvl_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Pe te mene heke hilimo mur nga peria; pe te in heke ech poreke ngana nenge he metmete hana pe te mete ero. Tetal heke peria nge haleles kina mur pe haleles pe singiria urana mule.” ");
INSERT INTO uvl_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Iesus hele lange iri ke het pe lohaka la sapele nga lut nga tapa pe are nga temene ilina hele nga pen tamalmal. ");
INSERT INTO uvl_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Ol pe Iesus nena hana mur tei hot pe te talun sapele ke te haliu hote NeHalang nena helenga nga kileng mur lochloch. Pe Iesus ume luluch pe hekerkereng ia iri ke te hele pe urelu te lohot manmana ke hehei pe hana te esia pe leteria manmanna nga helenga nem. ");
INSERT INTO uvl_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","3","Oe Teopilos mur; Iri nenge te esia Iesus pe te haliu hote na helenga iri te hetoro sue ure lochloch ngana nemur at nge ita. Pomalam hana halang muteria toto ke tehas nanasia. Pe pule iau sipok e etei teu la toto nga ure nemur nenge lohot nga tunangara. Ke ngana koi nenge e teke urana toto nge iau sipok ehas urume ke nek toto lange imo. (Ure nemur ehas sue iri nenge Iesus poia nga talun ngana toto ke la het nga mete ngana pe maul haka mule ngana nga polo.) ");
INSERT INTO uvl_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Pomalam lape a eteia ure manmanna toto ngana nga ure lochloch nenge te hetoro imo ia ke ulolo. ");
INSERT INTO uvl_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Nga etue nenge Herot i naungaala ana non nga kileng nenge Iutea, none iri nai nehei te tutu. Pe non nem ene laka Sakarias. Pe i tu teu nga mata nenge te umume nga NeHalang nena pele. Ana mata ene laka Apisa. Pe nehei ene Elisapet. Pe Elisapet tuteu nga mata nenge Aron. ");
INSERT INTO uvl_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Pe iri nai tetu toto nga NeHalang matana pe te nanas pengpeng ia NeHalang nena hotonga mur. ");
INSERT INTO uvl_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Pe iri tuturia mur ero iange Elisapet hoho erochro pe iri nai te tuauna lo. ");
INSERT INTO uvl_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Iok, nga etuene e Sakarias alona mur aria etue lohot. Aria etue nenge te umume nga NeHalang nena pele letena. ");
INSERT INTO uvl_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Pe iri te nanasia poinga nenge te saua oio paena pe ana maelepa lohot ke henonou hote none nenge lape teu langa Non Soke tu ngana nenge heo ngana toto. Pe nga etue nem te henonou hote Sakarias ke teu la. ");
INSERT INTO uvl_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Ana non teu la pe rau hekheke ure nenge inangana ehech nga ana hatanga. Pe hulua lochloch te hetalaulau mana nge hot. ");
INSERT INTO uvl_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Ol pe NeHalang nena angkelo lohot nge i pe mes pengpeng nga hatanga nem ilina ele nenga pen tamalmal. ");
INSERT INTO uvl_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Pe Sakarias esia pe rura pe matau toto. ");
INSERT INTO uvl_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Pe angkelo neu hele lange i, “Sakarias o matau ero! NeHalang longe o hetalaulau ngam lo. Pomalam lem hei Elisapet lape hoe tum tamane ngana e. Pe o hetue tum nem ke ene Ioanes. ");
INSERT INTO uvl_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Pe lape o iech toto pe hulua lochloch ngana nemur lape te iech toto pule nga etue nenge lem hei hoe tum tamane ngana nem. ");
INSERT INTO uvl_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Te iech nge i iange i lape lohot ke NeHalang nena non ia. Pe i heo ngana toto nge inia uain pe ech kerkereng ngana mur. Iange nga etue nenge tana hoe i, Opepengpeng lape hemuta sapele i. ");
INSERT INTO uvl_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Pe i lape mene mule hulua halang nge Israel ke tela mule nge aria Soke NeHalang. ");
INSERT INTO uvl_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Pe pule lape i muka ia Non Soke pingana. Pe na kerkerenga palaungana toto ke mange hetatalonga Elaisa. Pe hemakuke tetemeria mur leteria ke tuturia mur te kila mule ke muria elle. Pe pule poia iri nenge te longo olole ke ramaria la mule nga poinga nenge pengpeng toto pe nga etue nenge Non Soke at te nanas mene i ol.” ");
INSERT INTO uvl_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Sakarias onteia angkelo neu. “Lape e eteia ke mere nge lape ure nei lohot ke manmanna? Iau e tuauna lo i! Pe lek hei pule ke pomalam.” ");
INSERT INTO uvl_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Pe angkelo neu hele, “Iau Kapriel. Pe etu toto nga NeHalang matana pe i sipona kulosia iau ke teke e at ke e hele ia helenga urana toto ngana nei lange iong. ");
INSERT INTO uvl_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Pe iong letem manmanna nga helenga nei ero nge lape lohot ke manmanna toto nga ana etue pengpeng. Pomalam lape NeHalang poi ele halim ke o hele ero. Lape o reng mana ke la het nga etue nenge lek helenga manmanna ngana nei lohot. Iange iong letem manmanna nga helenga nei ero.” ");
INSERT INTO uvl_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Nga etue nenge angkelo neu lohot nge Sakaraia hulua te kulele i pe leteria tuanin ke halang iange tu ke mala toto nga NeHalang nena pele letena. ");
INSERT INTO uvl_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Iok laol, Sakarias i hot at pe teke hele pe te longe na helenga ero ol. Pe poi urume na helenga mur nga penna. Pe hulua te eteia ke ute lohot nge i nga NeHalang nena pele palaungana letena. ");
INSERT INTO uvl_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","La Sakarias ana etue nenge umume nga NeHalang na pele het pe la mule nga nena pele. ");
INSERT INTO uvl_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Pe nga hoena nehei Elisapet sana pe tuteu mana nga pele letena ke teio iri lime. ");
INSERT INTO uvl_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Pe Elisapet hele, “Nga etue nemur ol e iech toto nge NeHalang halaua iau ke sak! Pe e meia iau nga hulua mataria ero ol!” ");
INSERT INTO uvl_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Elisapet mes ke ana teio iri rahtele elle (6) pe NeHalang kulosia angkelo Kapriel ke langa kileng e nge Kalelea nge ene Nasaret. ");
INSERT INTO uvl_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Pe angkelo neu laia helenga nge hei malolong ngana e nge te hele hite ke te teke lei nge none nge ene Iosep. Iosep i ne Teuit alona. Pe he neu ene Maria. ");
INSERT INTO uvl_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Hekulkulonga lake lohot nge i pe hele, “Atong otu ke nek pe Non Palaungana tu luluch nge iong pe pete tote iong.” ");
INSERT INTO uvl_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Maria longe angkelo nem pe rura toto pe letena tuanin rara nga na helenga luna. ");
INSERT INTO uvl_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Pe angkelo neu hele lange i, “He Maria o matau ero. NeHalang iech toto nge iong pe teke pete tote iong. ");
INSERT INTO uvl_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Ke lape sam pe ohoe tum tamane ngana e pe o hetue i ke ene Iesus. ");
INSERT INTO uvl_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Pe i nge lape lohot ke NeHalang nena non kerkereng ngana ia. Pe pingana song pe te hetue i ke NeHalang Nge I Soke Nga Lut Toto Tuna. ");
INSERT INTO uvl_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","NeHalang lape poia i ke i Israel mur aria naungaala ana non ke pomange nette Teuit. Pe i lape nauele iri nga etue lochloch sapele.” ");
INSERT INTO uvl_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Pe Maria hele lange angkelo, “Iau etu luluch nge none ero kura i. Pe ure nei lape lohot ke pomere?” ");
INSERT INTO uvl_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Pe angkelo neu tuacholia, “Opepengpeng lape sio at nge iong pe NeHalang Nge I Soke Nga Lut Toto nena hekerkerenga lape tu hite iong. Pomalam lape te hetue tum nem ke i NeHalang Tuna nge pengpeng toto. ");
INSERT INTO uvl_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Onau lange alom Elisapet. Te teke i hoho erochro pe nga etue nei tuauna lo pe mes mule ke nena teio iri rahtele elle. ");
INSERT INTO uvl_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Ure lochloch ngana nenge anali toto nge hana te poia NeHalang nakuna nge poia.” ");
INSERT INTO uvl_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Ol pe Maria hele, “Iau i loi. Iau Non Soke na hekuleileinga. E nanas mene NeHalang lemene ngana nenge o heleia lo.” Pe angkelo neu hile i pe la sapele. ");
INSERT INTO uvl_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Mala ero mana pe Maria lohaka ke langa kileng e nga lut nge Iutea. ");
INSERT INTO uvl_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","La pe i teu nga Sakarias na pele pe hele “Uach toto.” lange Elisapet. ");
INSERT INTO uvl_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Pe Elisapet longe Maria na helenga pe amneia tuna nge sechsech nga letena pe Opengpeng hemute i ");
INSERT INTO uvl_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","pe hele haka sapele, “NeHalang pete tote iong nge hehei lochloch pe pete tote tum nenge lape o hoe nem. ");
INSERT INTO uvl_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Pomere toto nge ak Non Soke tana at ke nau tote iau? ");
INSERT INTO uvl_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Iange e longe iong nge o hele uach at nge iau pe tuk iech toto pe sechsech nga letek. ");
INSERT INTO uvl_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Non Soke pete iong lo iange letem manmanna ia na helenga nge lape lohot ke manmanna toto.” ");
INSERT INTO uvl_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Maria hele, “Nga letek lochloch e heto heke Non Soke. ");
INSERT INTO uvl_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Iau e iech toto nge NeHalang nge mene mule iau! ");
INSERT INTO uvl_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Iange iau heie mana nga ich pe i letena metene iau. Hulua nenge tetu nga etue nei pe nga etue lochloch nga hoena lape te hetue iau ke hei nge NeHalang heiech ia. ");
INSERT INTO uvl_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Iange NeHalang na kerkerenga halang poia ure papalau ngana ke lohot nge iau. Ia I na poinga pengpeng toto. ");
INSERT INTO uvl_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","NeHalang letena poreke ia iri lochloch nenge te mataua I. Iri nenge te tu nga etue nei pe nga hoena pule ");
INSERT INTO uvl_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Hana nenge tetal heke iri nga leteria toto NeHalang tul hote penna pe na kerkerenga sisparai sue iri. ");
INSERT INTO uvl_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Naungaala nemur nenge tetal heke iri ke kokoes NeHalang tal sio tote iri. Pe iri nenge teau sio tote iri nga NeHalang matana, NeHalang tal haka tote iri langa lut. ");
INSERT INTO uvl_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","NeHalang tunge ure urana ngana mur lange iri nenge reria ute hel ero. Pe iri nenge reria ure halang NeHalang kulosia iri pe te patpata mana ke tela ol. ");
INSERT INTO uvl_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","NeHalang halaua Israel mur pe letena ia Apraham pe na tete mur nga etue lochloch. Iange letena metene helenga utona nem nenge heleia lange rera tete mur nge nike.” ");
INSERT INTO uvl_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Iok laol, Maria tu luluch nge Elisapet ke teio mol het pe la mule nga na kileng. ");
INSERT INTO uvl_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Elisapet ana etue nenge hoho ia lohot pe hoe tuna tamane ngana e. ");
INSERT INTO uvl_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Elisapet na kileng ngana mur pe alona mur te longe nge Non Soke poi ke urana toto lange i pe iri lochloch te iech luluch nge i. ");
INSERT INTO uvl_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Pe kol nem ana etue iri rahtele mol (8) pe te riria i pe te teke te hetue i ke ene Sakarias. ");
INSERT INTO uvl_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Pe tana hele ele iri, “Ero! Ene laka Ioanes.” ");
INSERT INTO uvl_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Pe alona mur te hele, “Iong alom mur eria pomam ero!” ");
INSERT INTO uvl_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Ke het pe tepoi urume reria onteinga nga peria lange Sakarias pe te onteia i, “Kol nei lape ene pomere?” ");
INSERT INTO uvl_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Pe Sakarias ontei rara alalaha sachana ke has haka ia. Pe la has sue ke ene Ioanes. Ol pe iri lochloch te esia pe te rura. ");
INSERT INTO uvl_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Pe nga etue neu pengpeng Sakarias hanna olha ke hele mule pe heto heke NeHalang. ");
INSERT INTO uvl_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Pe na kileng ngana mur te rura toto pe singiria matau nga urene nge lohot. Pe te hesongia helenga ke ronge kileng mur nga lut nge Iutea. ");
INSERT INTO uvl_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Iri lochloch ngana nenge te longe leteria tuanin raraia pe te ontei, “Kol nem mam lape lohot ke i utar?” Pe te eteia nge Non Soke na kerkerenga tu hit mene i. ");
INSERT INTO uvl_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Opepengpeng hemuta heke Ioanes temene Sakarias pe haliu hot sapele NeHalang na helenga: ");
INSERT INTO uvl_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Ta heto haka tote NeHalang Israel mur aria Non Soke! Iange i sio at ke halaua nena hana mur pe mene mule iri nga reria poinga poreke ngana mur. ");
INSERT INTO uvl_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Pe tung sue hemasinga e nge na kerkerenga halang ke hemas mule ita lochloch. Pe i nenge hemasmas nem at nga mata nenge Teuit (NeHalang nena hekuleileinga). ");
INSERT INTO uvl_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Hetatalonga mur nge nike te hele hote na helenga kerkereng ngana mur. ");
INSERT INTO uvl_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Ke te teke NeHalang mene mule ita nga rera ngarang mur peria pe nge iri nenge muteria taua ita ero. ");
INSERT INTO uvl_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Pe NeHalang hele ke teke lape letena ia rera tete mur pe letena metene helenga tomunga hel nenge pengpeng toto. ");
INSERT INTO uvl_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Nena helenga utona nenge heleia lange Apraham ma ke mai: ");
INSERT INTO uvl_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","NeHalang lape mene mule ita nga rera ngarang mur peria ke ta ume mana nge i pe ta mataua rera ngarang mur ero ol. ");
INSERT INTO uvl_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Pomalam laka poinga poreke ngana e tu nge ita ero pe ta pengpeng toto nga NeHalang matana nga etue lochloch nenge tatu nga ich.” ");
INSERT INTO uvl_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Sakarias hele lange tuna, “Iau tuk iong pe lape te hetue iong NeHalang nenge I Soke nga Lut Toto nena hetatalonga. Iong lape iong muka nge Non Soke ke o hepengia nena kue. ");
INSERT INTO uvl_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Pe o hele lange hana lochloch ke NeHalang lape hemas mule iri ke pomai: lape saua reria poinga poreke ngana mur ke te lasus toto. ");
INSERT INTO uvl_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","NeHalang letena poreke hali ia ita nga rera poinga poreke ngana mur pe tangtang ia tutuna mur ita ke poi ke manga chaia matana nenge haka ");
INSERT INTO uvl_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","pe tualeme sio at nga tapa pe tua hatalia ita nenge ta tuteu nga metenga ana mulil. Pe henonoua ita nga kue nenge langa tunga nge nek.” ");
INSERT INTO uvl_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Iok, Ioanes lumngana pupuo pe opene pupuo ke soksoke pe kerkereng. Pe tu manmana nga ich sana lomona e ke la het nga etue nenge i sipona hetei hote i langa hulua mataria nge Israel. ");
INSERT INTO uvl_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Nga etue nemur non soke nenge Rom ene Agastus tunge helenga kerkerengana nga sisalanga nge hehei pe hana ke lape hot nga kileng lochloch nenge Rom nauele iri. ");
INSERT INTO uvl_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Pe sisalanga nem talun nga etue nenge Kirinius nauele kileng Siria. ");
INSERT INTO uvl_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Pe hulua lochloch tela mule nga reria kileng una mur ke tehas sue eria mur. ");
INSERT INTO uvl_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Ol pe Iosep lohaka nge Nasaret nge Kalelea ke la mule nga na kileng una nge Petlehem nge Iutea. Iange kileng nem non soke Teuit na kileng huna. Pe Teuit i Iosep nette pengpeng. Pomalam Iosep la mule nga kileng neu. ");
INSERT INTO uvl_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Iosep iri nai Maria tela iange tetal helenga ke telei hel. Tela pe Maria sana lo. ");
INSERT INTO uvl_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Pe nga etue nenge tetu nge Petlehem Maria hoho. ");
INSERT INTO uvl_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Hoe tuna tamane ngana e pe ruchite i nga ruchinga hit sachanchana mur. Ruchite pe hemara sue i nga pulumakau mur aria ngaunga ana manga. Iange pele nenge lang mur te muta lochloch lo. ");
INSERT INTO uvl_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Sipsip ana naungaala mur hel te umume nga miliko neu pe tetu ke kangkanga pol nga kileng nenge Petlehem. ");
INSERT INTO uvl_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Ol pe Non Soke na angkelo e lohot nge iri pe kerkerenga palau ngana nenge NeHalang tualeme sio lange iri. Te esia pe te matau toto. ");
INSERT INTO uvl_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Pe angkelo nem hele, “A matau ero! Iau eat ia helenga urana toto ngana nge imo, pe lape poia hulua lochloch ke te iech toto pule. ");
INSERT INTO uvl_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Nga etue nei pengpeng nga Teuit na kileng huna te hoe non nenge hemasmas. Pe i Kristus, ara Non Soke nenge NeHalang hele tala ia ke teke kulosia at. ");
INSERT INTO uvl_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Poinga nenge hemallaha hote ke helenga nei manmanna lape lohot ke pomai koi; ala pe a naue i nge te ruchite i nga ruchinga hit sachanchana mur pe te hemara sue i nga pulumakau mur aria ngaunga ana manga.” ");
INSERT INTO uvl_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Angkelo nem hele ke het pe ueiuei mana angkelo mur hel pule nge iri halang toto temes luluch nge i pe te heto heke NeHalang ene ke pomai: ");
INSERT INTO uvl_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Ta heto heke NeHalang nge i Non Soke nga lut nga tapa. Pe tunga nge nek lape tu hite iri nenge NeHalang iech ia iri!” ");
INSERT INTO uvl_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","La ol pe angkelo nemur te hile iri pe te haka la mule nga lut nga tapa. Pe sipsip ana naungaala nemur te hele tele hel nge iri, “Ita ol! Tala nge Petlehem ke tanau urume ure nenge Non Soke hele at nge ita lo!” ");
INSERT INTO uvl_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Iok laol, te song ke ueiuei mana ke tela pe te lohot nge Maria pe Iosep pe turia nge masio mana nga pulumakau mur aria ngaunga ana manga. ");
INSERT INTO uvl_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Te esia ke ulo pe te hesong sapele helenga nenge angkelo heleia lange iri. ");
INSERT INTO uvl_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Pe iri lochloch nenge te longe helenga nem te rura ia pe leteria tuanin rara ia. ");
INSERT INTO uvl_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Pe Maria letena metene ke nek toto pe talhit tote nga letena nge teu. ");
INSERT INTO uvl_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","La sipsip ana naungaala nemur tela mule pe te heto heke tote NeHalang, nga ure nenge te longe pe te esia lo. Iange ure nemur te lohot ke pengpeng toto ke pete tote utar nenge angkelo nem hele tala ia ke ulolo. ");
INSERT INTO uvl_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Kol sune nei ana etue iri rahtele mol pe te riria singina. Pe te hetue ke ene Iesus. Ene nenge Iesus, angkelo nem tung tele nike nga tana sanaia i ero kura. ");
INSERT INTO uvl_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Nga etue nem Maria iri nai Iosep te nanas tau pengpeng ia hotonga nenge Moses. Ke Maria helemlem mule i nga hohonga. Ke het pe te mene turia Iesus ke iri ul tela nge Ierusalem ke te tunge i langa NeHalang matana ke pomanga tehas ia nga nena hotonga. ");
INSERT INTO uvl_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Pe hotonga nem hele ke teke, “Aina tatamanna nenge tengene ana lape te tung tote iri lange NeHalang ke tutuna mur ia iri.” ");
INSERT INTO uvl_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Pe pule te nanasia NeHalang na hotonga ke te makia reria tunginga nenge ngie chaulum nai. ");
INSERT INTO uvl_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Nga etue neu none nge ene Simion tu nge Ierusalem pule. Pe i non urana nge longo tau totote NeHalang pe kulele NeHalang nge mene mule hana nenge Israel. Pe Opepengpeng tu luluch nge i. ");
INSERT INTO uvl_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Pe Opepengpeng hele toto lange i lo ke teke, “Lape o esia Kristus nenge Non Soke kulosia at, ke het pe o mete ol.” ");
INSERT INTO uvl_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Iok laol, Opepengpeng poi heke letena pe ana non ii ke la iteu nga NeHalang na pele palaungana. Nga etue nenge Maria iri ul Iosep te mene teua Iesus langa NeHalang na pele palaungana nem ");
INSERT INTO uvl_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simion lake lolo heke Iesus pe heto heke NeHalang pe hele; ");
INSERT INTO uvl_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Non Soke lem hekuleileinga ana non koi iau. O longala ke e mete sio ke nek mana ol. Iange lem helenga pete tote ");
INSERT INTO uvl_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","ke enau tote lem hemasinga ana non nga matak pengpeng. ");
INSERT INTO uvl_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Pe iong sipom otal hote i ke hulua lochloch te esia nga mataria pule ");
INSERT INTO uvl_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","ke pomanga lemenge palaungana nge tualeme hatalia kue nge hana lomona mur ke iong o mene mule iri. Pe lape hulua te esia i pe te heto heke lem hana mur nge Israel.” ");
INSERT INTO uvl_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Iosep iri nai Maria te longe non nem na helenga pe te rura totoia. ");
INSERT INTO uvl_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simion pete iri pe hele lange Maria, “Tum sune nem lape helosio ia hulua halang nge Israel pe pule lape hemaul heke mule hulua halang pule nge Israel. NeHalang henonou hote tum sune nem ke hemallaha hote NeHalang lemene ngana nga ich pe hulua lape lemeria ero ia pe te hele poreke i. ");
INSERT INTO uvl_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Pe i lape hemallaha hote hana leteria tuanin ngana mur nenge te talkome nga leteria toto. Pe iong lape o amneia melmelenga palaungana nga letem kolkol ngana mur pe lem tanginga mur ke pomanga io nge mes teu nga singim.” ");
INSERT INTO uvl_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","37","Hei pakar e i hetatalonga pule. Ene laka Ana. Pe he neu temene ene laka Panuel. Pe i tu teu nga mata nenge Asa. Hei neu lei mukam ke iri nai ene tetu ke aria hesinga iri rahtele nai ol pe ene mete. La ke la hei pakar neu tu ke i toro kela tuauna toto ke ana hesinga iri ana non kina henel pe henel (84). Pe kokoes mana la ke umume nga NeHalang na pele pe heto hekeke NeHalang. Heo nga ngaunga pe hetalaulau manmana. ");
INSERT INTO uvl_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Pe nga etue neu saolia Iosep iri nai Maria nge te laia Iesus nga NeHalang na pele. Saolia iri pe heto heke NeHalang sapele pe heleia kol sune neu lange iri nenge te kulele mene etue nenge lape NeHalang mene mule Israel mur. ");
INSERT INTO uvl_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Iosep pe Maria te nanas taua Non Soke nena hotonga ke het pe tela mule sapele nga reria kileng nge Nasaret nge Kalelea. ");
INSERT INTO uvl_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Pe turia Iesus pupuo ke soke pe letena matana ngana urana toto pe NeHalang pete tote i. ");
INSERT INTO uvl_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Nga hesinga lochloch Iosep iri nai Maria telala nge Ierusalem nga ngaunga matana nenga Ingatoto. ");
INSERT INTO uvl_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Iesus ana hesinga iri analoch pe nai pe iri ul ke tela ke pomanga reria poinga nike. ");
INSERT INTO uvl_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","44","Iok, etue palaungana neu het pe Iosep iri nai Maria tela mulmule nga reria kileng pe iri nai te teke ma Iesus koi iri ul ke teii. Teii ke sase toto lo, ol pe te rara sapele Iesus pe la te ontei rere i nge aloria mur pe pekngaria mur. ");
INSERT INTO uvl_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Pe te hottaua i ero toto. Ol pe tela te tango rara mule i nge Ierusalem. ");
INSERT INTO uvl_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Pe nga etue mol ngana te hottaua i nge are luluch nge hetoronga ana hana mur nga NeHalang na pele palaungana letena. Pe i kila ke longo lala nge hana nemur pe onteiteia iri pule. ");
INSERT INTO uvl_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Iri lochloch nenge te longe Kol sune nem na helenga mur te rura toto iange hele ke manga none nge letena matana toto. ");
INSERT INTO uvl_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Temene pe tana te esia i pe leteria lilil toto lange i. Pe tana hele lange i, “Tuk, o poia imem ke pomere? Iau pe temem letemem toto ia iong ke moat mo tango rere iong i!” ");
INSERT INTO uvl_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Pe Iesus tuacholia iri, “A tango rere iau ke? Iau etu manmana nga temek nena pele pe imo a eteia ero kai?” ");
INSERT INTO uvl_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Pe temene pe tana iri nai te eteia na helenga luna ero. ");
INSERT INTO uvl_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","La Iesus lohaka luluch nge temene pe tana ke tela mule nge Nasaret. Pe nge Nasaret Iesus longo tau totote iri. Ure lochloch ngana nemur Maria talhit tote nga letena nge teu. ");
INSERT INTO uvl_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Iesus puo haka luluche singina pe letena matana ngana nge lohot ke nek toto. Pe NeHalang pe hulua lochloch leteria urana mana nge i. ");
INSERT INTO uvl_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","2","Nga etuene e NeHalang na helenga lohot nge Sakarias tuna Ioanes nga ich sana lomona e. Pe nga etue neu Pontius Pilatus nauele kileng nenge Iutea. Pe Herot nauele kileng nenge Kalelea pe tina Pilipus nauele kileng nenge Iturea pe kileng Trakonitis pule. Pe Lisanias nauele kileng nenge Apilene. Pe Teperius i non soke toto nge Rom nge nauele iri lochloch. Pe Anas iri nai Kaiapas iri tungina ana hana mur aria papalauna mur. Nga etue neu pengpeng NeHalang nena helenga lohot nge Ioanes. ");
INSERT INTO uvl_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","La ol, i ke langa ech nge Iortan pe haliu hote NeHalang na helenga pe hele, “A hile lemo poinga pulut ngana mur pe e henune imo. Pomalam lape NeHalang saua lemo poinga poreke ngana mur ke te lasus toto.” ");
INSERT INTO uvl_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Haliunga nei nanas taua hetatalonga Isaias na helenga nenge has sue nga na alalaha ke teke, “None kou haliuliu nga ich sana lomona. Haliu ke teke, ‘A hepengia Non Soke na kue ke kulele i. A hepengia na kue ke pengpeng toto iange lape at pe i ia. ");
INSERT INTO uvl_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Kileng talloko sio ngana mur lape te hemuta heke mule iri pe sasana pe hengene mur lape tesel sue iri. Pe kue chachau ngana nemur lape te umeia iri ke pengpeng mule. Pe kue poreke ngana mur lape telau hit mule iri pe te hepeng mule. ");
INSERT INTO uvl_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Hulua lochloch ngana nga ich lape te esia NeHalang penna nge mene mule iri lochloch.’” ");
INSERT INTO uvl_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Iok laol, hulua lochloch ngana tela nge Ioanes ke henune iri. Pe hele inin taua iri, “Ilimo alete nemur! A teke NeHalang eteia letemo tuanin ngana ero ma? Imo a sere at ke a menmene henuninga pe imo a teke ma ech nem poi ele NeHalang letena inin ngana nga lemo poinga poreke ngana mur. Ero toto la! A hul tote letemo! ");
INSERT INTO uvl_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Pe a poia lemo poinga urana ngana mur ke mo eteia ke ahul mule nga lemo poinga poreke ngana mur lo. Imo nenge a teke Apraham na tete mur imo a pengpeng ero kura la. NeHalang nakuna nge ume hote Apraham nena tete mur nga um mur pe imo a teke Apraham na tete mur imo. Ute pele ero! ");
INSERT INTO uvl_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Selempo koi te rahite nga ae mur huria lo ke te tele sue iri. Pe ae lochloch ngana nenge nganangaria lohot ke urana ero lape te tele sue iri pe tesau heke nga oan.” ");
INSERT INTO uvl_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Pe hana nemur te onteia i, “Lape mopoi ke pomere ol?” ");
INSERT INTO uvl_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Pe Ioanes hele, “Itei nenge nena hengeron nai tunge elle lange mele nenge na ero pe itei nenge ana ngaunga lo reke lange mele nenge ana ngaunga ero pe mete ana.” ");
INSERT INTO uvl_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Hana hel nenge te lololoch umtutuna teat nga henuninga pule pe te onteia Ioanes, “Hetoronga imem lape mopoi ke pomere pule?” ");
INSERT INTO uvl_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Pe Ioanes hele, “Te talue umtutuna hia nenge lape a mene, a mene pengpengia pe aele heke ero.” ");
INSERT INTO uvl_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Pe palinga hel ana hana mur te onteia i pule, “Pe imem? Lape mopoi ke pomere ol?” Pe Ioanes hele lange iri, “A palia mele hel pe a loloch mene reria umtutuna ero. Pe a pallaka ia mele hel pe a keme mana nge iri ero. A iech mana nga urumo nenge a mene.” ");
INSERT INTO uvl_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Te longe Ioanes na helenga mur pe leteria haka pe nga ramaria te teke lape i Kristus nenge NeHalang hele tala ia nike ke lape kulosia at. ");
INSERT INTO uvl_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Pomalam ol pe Ioanes hele lange iri lochloch, “Iau lape e henun mene imo nga ech mana pe mele nge palaungana toto nge iau lape nananas. Pe iau e urana ero pule nge e poi hote apena ana ae ulina. Pe mele nem lape henune imo nga Opepengpeng pe nga oan. ");
INSERT INTO uvl_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Pe i lape mene mule nena hana mur ke pomai; lape mene kakop pe sochote mioka ulina mur pe nganngana mur takiraua iri ke muria elle. Ke het pe sau heke ulina mur nga oan sapel lala ngana nenge tu ke koko.” ");
INSERT INTO uvl_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Pe nga poinga hel pule Ioanes haliu ia NeHalang na helenga urana toto ngana lange hehei pe hana ke te hile reria poinga pulut ngana mur. ");
INSERT INTO uvl_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Non soke Herot nauele kileng nenge Kalelea pe lei mule ene tana Herotias. Pe pule poia poinga hel nge poreke toto. Pe Ioanes na helenga nei tua tau pengpeng ia Herot. ");
INSERT INTO uvl_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Pomalam Herot poia poinga poreke toto ngana nenge tal teua Ioanes nga tuele au ngana. ");
INSERT INTO uvl_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Iok, Ioanes henune hehei pe hana lochloch ke het pe henune Iesus ol. Iesus hetalaulau pe ulu alchach hatalia tapa. ");
INSERT INTO uvl_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Pe Opepengpeng sio at pe nakuna pomanga ngie chaulum. Pe helenga e sio at nga tapa, “Iong mana tuk toto nge e mete pe e iech toto nge iong.” ");
INSERT INTO uvl_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Iesus ana hesinga teke lala ke iri ana non kina elle pe analoch (30) pe talun sapele ana ume. Pe hulua te teke Iesus temene Iosep pe Iosep temene Heli. ");
INSERT INTO uvl_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Pe Heli temene Matat. Pe Matat temene Liuai. Pe Liuai temene Melki. Pe Melki temene Ianai. Pe Ianai temene Iosep. ");
INSERT INTO uvl_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","La Iosep temene Matatias pe Matatias temene Amos. Amos temene Nahum pe Nahum temene Esli. Esli temene Nakai pe Nakai temene Mat. ");
INSERT INTO uvl_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Mat temene Matatias pe Matatias temene Semein. Semein temene Iosech pe Iosech temene Iota. ");
INSERT INTO uvl_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Iota temene Ioanan pe Ioanan temene Resa. Resa temene Serupapel pe Serupapel temene Sealtil. Sealtil temene Neri pe Neri temene Melki. ");
INSERT INTO uvl_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Melki temene Atti pe Atti temene Kosam. Kosam temene Elmatam pe Elmatam temene Er. ");
INSERT INTO uvl_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er temene Iosua pe Iosua temene Elieser. Elieser temene Iorim pe Iorim temene Mattat. Mattat temene Liuai pe Liuai temene Simeon. ");
INSERT INTO uvl_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Simeon temene Iuta pe Iuta temene Iosep. Iosep temene Ionam pe Ionam temene Eliakim. ");
INSERT INTO uvl_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliakim temene Melea pe Melea temene Menna. Menna temene Mattata pe Mattata temene Natan. Natan temene Teuit pe Teuit temene Iesi. ");
INSERT INTO uvl_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Iesi temene Opet pe Opet temene Poas. Poas temene Salmon pe Salmon temene Nason. ");
INSERT INTO uvl_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nason temene Aminatap pe Aminatap temene Atmin. Atmin temene Ani pe Ani temene Hesron. Hesron temene Peres pe Peres temene Iuta. ");
INSERT INTO uvl_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","La Iuta temene Iakop pe Iakop temene Isak. Isak temene Apraham pe Apraham temene Tera. Tera temene Nahor pe Nahor temene Seruk. ");
INSERT INTO uvl_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Seruk temene Reu pe Reu temene Pelek. Pelek temene Eper pe Eper temene Sela. ");
INSERT INTO uvl_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sela temene Kainan pe Kainan temene Arpaksat. Arpaksat temene Sem pe Sem temene Noa. Noa temene Lamek pe Lamek temene Metusela. ");
INSERT INTO uvl_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Metusela temene Enok pe Enok temene Iaret. Iaret temene Mahalalel pe Mahalalel temene Kenan. ");
INSERT INTO uvl_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kenan temene Enos pe Enos temene Set. Set temene Antam pe Antam temene NeHalang. ");
INSERT INTO uvl_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Ioanes henune Iesus nge Iortan ke het pe Opepengpeng hemute i pe mene i ke langa ich sana lomona. ");
INSERT INTO uvl_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Pe nga lamau Iesus tuke ana etue iri ana non kina nai (40) pe non poreke ngana totoi ke helosio ia i. Nga etue lochloch ngana nemur Iesus ngaua ngaunga e ero pe nga hoena mete ana toto ol. ");
INSERT INTO uvl_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Iok laol, Non Poreke ngana neu hele lange i, “Teke iong NeHalang tuna toto o tunge helenga kerkereng ngana langa um nei ke hul ke am ngaunga ia.” ");
INSERT INTO uvl_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Pe Iesus tuacholia, “NeHalang nena hotonga hele ke teke, ‘Hana pe hehei te mene maulinga ke koko nga ngaunga mana ero.’” ");
INSERT INTO uvl_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Pe Non Poreke ngana mene heke i langa kileng e nga hengene palaungana. Pe mala ero mana pe henonoua i langa kileng lochloch ngana nga ich. ");
INSERT INTO uvl_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Pe hele lange i, “Lape e tunge lem kerkerenga palaungana nenge o nauele kileng lochloch ngana nemur. Pe ure lochloch ngana nga kileng nemur iong lem ia ol. O esia ure lochloch ngana nemur te tung lochloche at nge iau lo. Pe lape e tung pulut mene lange mele pele mana nga iau lemek ngak. ");
INSERT INTO uvl_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Nenge teke o heto heke iau lape e tunge ure lochloch ngana nei ke lem ol.” ");
INSERT INTO uvl_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Pe Iesus tuacholia, “NeHalang nena hotonga hele ke teke, ‘O heto heke NeHalang am Soke pe oume mana nge i!’” ");
INSERT INTO uvl_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Ol pe non poreke ngana neu mene Iesus lange Ierusalem pe hetakila heke i nga NeHalang na pele palaungana ona nga lut toto pe hele lange i, “Nenge teke iong NeHalang tuna toto, o tamu hot lamai ke o losio langa ich. ");
INSERT INTO uvl_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Iange NeHalang nena hotonga hele ke teke, “‘NeHalang lape kulosia na angkelo mur ke tenau ele iong. ");
INSERT INTO uvl_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Lape tera hit heke mene iong nga peria pe lape um riria apem ero toto.’” ");
INSERT INTO uvl_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Pe Iesus tuacholia, “NeHalang na hotonga hele ke teke, ‘O totoi ia am Non Soke NeHalang ero. Pe oech ia i ke nanasia lemem ngam mana ero toto.’” ");
INSERT INTO uvl_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Non Poreke ngana neu totoi ke helosio ia Iesus nga poinga lochloch. Ke het pe ua ana iange nga hoena lape at tau mule i. ");
INSERT INTO uvl_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","La ol pe Iesus la mule nge Kalelea pe Opepengpeng na hekerkerenga tu luchluch nge i. Pe pingana song nga kileng lochloch ngana nga lamau. ");
INSERT INTO uvl_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Iesus hetoro nga hetoronga ana pele mur pe hulua lochloch ngana te heto heke i. ");
INSERT INTO uvl_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","La Iesus la mule nge Nasaret nga kileng nenge i soke ia. Pe nga Sapat ana etue Iesus la mule nga hetoronga ana pele ke pomanga popoia lo. Mes haka ke sisia NeHalang nena hotonga mur ");
INSERT INTO uvl_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","pe te tunge alalaha nenge hetatalonga Isaias lange i. Iesus ulele alalaha neu langa helenga nenge tehas ia ke pomai, ");
INSERT INTO uvl_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Non Soke opene koi tu luluch nge iau iange i sipona hesilei hote iau ke e haliu hotote nena helenga urana toto ngana. Helenga urana toto ngana nei e haliu hote lala nge hehei pe hana nenge eria haka ero pe reria ure ero toto nga ich nei. Pe kulosia iau ke e haliu hot ke pomai: Iri nenge tetu teu nga kileng au ngana te lohotot. Pe iri nenge mataria hit te nachnau. ");
INSERT INTO uvl_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Pe e haliu ke e teke, etue nem at lo nenge lape Non Soke mene mule na hana mur lochloch.” ");
INSERT INTO uvl_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Iesus lulit mule hetatalonga Isaias nena alalaha tunge lange mele nenge atia pe are sio. Pe hulua lochloch ngana nenga hetoronga ana pele letena neu mataria tuit mene i. ");
INSERT INTO uvl_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Ol pe hele lange iri, “Helenga chonna nenga NeHalang nena hotonga nei lohot ke manmanna heueu nei, ngana laka e sisia ke a longe ke ulolo.” ");
INSERT INTO uvl_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Pe iri lochloch leteria urana toto pe te rura iange ana non hele ngana ia helenga nemur ma ke urana toto. Pe te hele, “I mai Iosep tuna kai!?” ");
INSERT INTO uvl_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Pe Iesus hele lange iri, “Imo lape a hele at nge iau ke pomai, ‘Iong o hemaul mule iong. Iange iong non nenge o nauelele haleles kina mur. Ure nemur nenge o poia nge Kapernam o poia nga lem kileng pengpeng.’ ");
INSERT INTO uvl_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","“E hele ke manmanna toto lange imo. Hetatalonga e nena kileng nganangana mur pengpeng lemeria ero ia i. ");
INSERT INTO uvl_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Nge nike pakarkar una mur halang toto nge Israel nga etue nenge Elaisa. Pe nga etue nem pitte mol ero ke hesinga iri mol pe hakekena. Pe uringa palaungana toto lohot nga ich lochloch. ");
INSERT INTO uvl_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","A longo at nge iau. Manmanna toto ke NeHalang kulosia Elaisa ke lange pakarkar una mur nge Israel ero. Kulos mene i ke lange pakar e nge tutu nge Sarepat nga kileng nenge Saiton. ");
INSERT INTO uvl_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","“Pe nge Israel nga etue nenge Elisa, hulua halang temene haleles poreke toto ngana nenge ngaungaua singiria. Pe elle nge iri Elisa hemas mule i nga haleles nem ero toto. Pe Elisa hemas mene ne Naman nge na nge Siria.” ");
INSERT INTO uvl_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Iok laol, hulua lochloch ngana nenga hetoronga ana pele te longe helenga nei pe leteria inin toto. ");
INSERT INTO uvl_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Te lohaka pe te onrung hote Iesus nga kileng neu pe temene i langa hengene. Pe te teke tesau hot tote i ke losio ke mete. ");
INSERT INTO uvl_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Pe ero, ana non iteu mana nga hulua nemur tunangaria pe la sapele. ");
INSERT INTO uvl_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Ol pe Iesus i sio lange Kapernam nga kileng nge Kalelea. Pe nga Sapat ana etue Iesus hetore hehei pe hana. ");
INSERT INTO uvl_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Hehei pe hana te rura totoia Iesus na helenga iange meena pe tua tote leteria. ");
INSERT INTO uvl_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Nga hetoronga ana pele neu letena none nge uneinei tuteu nge i alngana hot ke palaungana toto. ");
INSERT INTO uvl_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Ah! Iesus nenge Nasaret o teke oat ke o potaria imem? O teke oat ke opoi poreke imem? E eteia iong ke ulolo. Iong pengpeng toto nge NeHalang kulosia iong ke oat.” ");
INSERT INTO uvl_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Pe Iesus keres taua uneinei neu pe hele, “O reng ol pe oua hot nge non nem!” Pe uneinei neu tamal sue non neu langa ich pe ua hot sapele nge i pe non neu singina urana mana. ");
INSERT INTO uvl_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Pe hehei pe hana te esia ure nei pe te rura toto pe te hele el nge iri, “Helenga utar nemai? Helenga nei kerkereng toto i nenge keresia uneinei mur pe te ua hot.” ");
INSERT INTO uvl_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Pe Iesus pingana song ke rongo heke kileng lochloch ngana nga kileng neu. ");
INSERT INTO uvl_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","La Iesus i hot nga hetoronga ana pele neu pe langa Simon na pele. Pe Simon uene, haleles poia ke singina milanglang toto pe te hele urume i lange Iesus. ");
INSERT INTO uvl_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Ol pe Iesus la ke mes nga ana hei na hete ilina pe hele ke kerkereng toto langa haleles neu. Iesus hele pe haleles neu het sapele nge hei neu. Haleles het pe hei neu loaka pe tun sapele aria. ");
INSERT INTO uvl_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Sinanga matana puluch lo pe hulua halang te atia aria haleles mur nge Iesus. Pe Iesus tal heke penna nge iri pe iri lochloch aria haleles het. ");
INSERT INTO uvl_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Pe uneinei mur te ua hot nge hana halang pe te alngaria ke mai, “Iong NeHalang tuna!” Pe Iesus hele ke kerkereng toto lange uneinei nemur, pe poia iri ke te hele ero iange te eteia ke Iesus i Kristus nem. ");
INSERT INTO uvl_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Uach sio lo pe Iesus i ke langa kileng e nge mele tuaia ero. Pe hulua te tango rere i pe te hottaua i pe te hele ele i ke lohaka hatalia iri ero. ");
INSERT INTO uvl_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Pe ero. Iesus hele lange iri, “Iau lape ela nga kileng hel pule ke e haliu hote Temek nena helenga urana toto ngana lange hehei pe hana. E haliu nga etue nenge hehei pe hana tenau haka lange NeHalang aria Soke. Pe NeHalang nauele iri lochloch ngana ke nek. Ela nga ume palaungana nem iange NeHalang kulos sue iau ke e poia.” ");
INSERT INTO uvl_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ol pe Iesus la ke haliu nga hetoronga ana pele mur nge Iutea. ");
INSERT INTO uvl_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Iok, nga etuene e Iesus mesmes nga ech hetaliliu ngana palaungana ililna nge Kenesaret. Ol pe hulua halang te emurung hite i pe hel te teke te longo toto nga NeHalang na helenga. Pomalam te pururum teu nga pekngaria mur koaria ke tela rochroi toto. ");
INSERT INTO uvl_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Pe Iesus esia aka nai nge te ele heke nga peipei. Pe hana nenge te olole ruo nga sulang nemur ngaria kou te lomlomo hoat. ");
INSERT INTO uvl_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Ol pe Iesus lake kila teu nga Simon nena sulang pe hele lange i ke ele hote sulang neu ke mana hot la pol nge hot. Ke Iesus are teu nga sulang neu pe hetore hulua nemur. ");
INSERT INTO uvl_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Iesus hetore hulua nemur ke het pe hele lange Simon, “O hepu hote lem sulang ke lange ech leme ngana pe imo ul pekngam mur a hemes sue hoat ke a hole ruo.” ");
INSERT INTO uvl_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Pe Simon tuacholia, “Non Soke, imem pum toto ia hoat nei hesio ngana nga miliko lo i! Pe emem ero toto. Pe lape e hesio mule hoat nei ke pomanga o hele ngam.” ");
INSERT INTO uvl_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Iok laol, te hesue hoat nemur pe te hole ruo nge halang toto nge poia hoat nemur ke te teke te uch ulu. ");
INSERT INTO uvl_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Pe te iua pekngaria mur nga aka e pule ke teat ke te halaua iri. Teat ke te hemuta heke sulang nai neu nga ruo ke te puluch par. ");
INSERT INTO uvl_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Pe Simon Petrus esia ure nenge lohot pe tualou sio nga Iesus matana pe hele lange i, “Non Soke oua toto ak iange iau lek poinga poreke!” ");
INSERT INTO uvl_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Petrus poi ke pomau iange iri ul pekngana mur te rura toto nga ruo lochloch ngana nenge teole. ");
INSERT INTO uvl_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Pe Petrus pekngana nai pule Ieims pe Ioanes Sepeti tutuna mur te rura pule. Ol pe Iesus hele lange Simon, “O matau ero. Heueu pe laol lape o menmene hana ke pomanga ruo nge o hole nga hoat.” ");
INSERT INTO uvl_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Iok, te ele heke sulang mur nga peipei pe te hile sue ure lochloch pe te hile sue aria ume mur nenge te holole hoat pe te nanasia Iesus. ");
INSERT INTO uvl_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Iok, Iesus langa kileng e pe nga kileng neu none tu. Pe non nem tu poreke toto ia haleles poreke toto ngana nenge ngau hohoa singira. Pe nga etue nenge esia Iesus talsio tote i pe hele ke teke, “Non Soke, nenge teke lemem toto o hemasia iau!” ");
INSERT INTO uvl_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Pe Iesus tal heke penna nge non neu pe hele, “Oe lemek toto. Singim lemlem mule!” Pe haleles neu het sapele nge non neu. ");
INSERT INTO uvl_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Pe Iesus hele ke kerkereng toto lange i, “O hele pulut rara lange mele ero toto. Ola ke o heteia singim lange tunginga ana non. Pe o makia lem tunginga hel ke o nanasia hotonga nenge NeHalang tunge lange Moses. Pomalam hulua lochlolch te eteia ke singim urana mule lo.” ");
INSERT INTO uvl_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Pe Iesus pingana song ke langa tau toto pe hulua halang te atat ke te longo nge i pe te teke Iesus hemaulia iri nga aria haleles mur. ");
INSERT INTO uvl_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Pe kokoes Iesus ua kome ke hetalaulau nga kileng nenge nganangana ero. ");
INSERT INTO uvl_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Nga etuene e Iesus hetottoro pe Paresio mur pe hotonga ana hetoronga mur teat nga kileng nemur nge Kalelea pe Iutea pe Ierusalem. Hana nemur teare lamau pule. Pe Non Soke tunge na hekerkerenga palaungana lange Iesus ke hemas mule haleles mur. ");
INSERT INTO uvl_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Hana hel te takisia none nge apena mete luluch nga na hete pe te teke te teuia langa pele letena ke tetal sue i nga Iesus matana. ");
INSERT INTO uvl_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Hulua halang ol pe te tango rara kue e nge te mene teua non neu lange teu. Ol pe te takis heke i langa pele ona teal hatalia pele pulpulna pe te heon sue pe te hesue i luluch nga nena hete ke langa hulua tunangaria nga Iesus matana pengpeng. ");
INSERT INTO uvl_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Iesus esia leteria manmanna ngana pe hele lange non neu, “Neingak, e saua lem poinga poreke ngana mur ke te lasus toto lo.” ");
INSERT INTO uvl_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Pe hotonga ana hetoronga mur pe Paresio mur te hele te hele hel nge iri, “Itei pane mai? Mele nei hele poreke tote NeHalang i! Teke i utar toto pamai? NeHalang i toro mana nge saua rera poinga poreke ngana mur ke te lasus!” ");
INSERT INTO uvl_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Iesus eteia leteria tuanin ngana mur pe hele lange iri, “Pomere nenge letemo tuanin rara ke pomam ia ure nemur? ");
INSERT INTO uvl_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Semel ngana nge e hele ke e teke, ‘E saua lem poinga poreke ngana mur ke te lasus toto lo.’ Pe anali toto nge e hele ke e teke ‘O loaka pe oi.’ ");
INSERT INTO uvl_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Heueu lape aes tote nga matamo nge Non Tuna na kerkerenga palaungana nga ich nge saua poinga poreke ngana mur.” Iok, hele lange non nenge apena mete neu, “E hele lange iong, o lohaka pe o mene lem tako pe ola nga lem pele!” ");
INSERT INTO uvl_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Ueiuei mana pe non neu lohaka nga iri lochloch mataria mene heke nena manga pe langa nena pele pe heto hekeke NeHalang. ");
INSERT INTO uvl_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Pe hulua lochloch ngana nemur te rura toto pe te matau pe haria kangkanga mana nga ure nenge lohot pe te heto heke NeHalang pe te hele, “Heueu mana nei ta naue ure nemur nenge ta esia iri erochro nge nike.” ");
INSERT INTO uvl_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Iok, Iesus hile kileng neu pe i ke la pe esia Liuai nge arare nga nena ume ana pele nenge lololoch umtutuna ia. Pe Iesus hele lange i, “O nanasia iau.” ");
INSERT INTO uvl_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Pe Liuai lohaka pe hile sue ure mur lochloch ngana pe nanasia Iesus. ");
INSERT INTO uvl_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Ol pe Liuai poia Iesus ana ngaunga palaungana pe hana halang toto nge iri nenge te lololoch umtutuna pe hana hel pule tela ke te ngau luluch nge Iesus. ");
INSERT INTO uvl_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Paresio mur iri ul aria hotonga ana hetoronga mur te ngunngunu pe te hele lange Iesus na hana mur. Pe te ontei, “Pomere pa nenge o ngau pe oin luluch nge hana nenge te lololoch umtutuna pe nge hana porekreke ngana nemur pamam?” ");
INSERT INTO uvl_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Pe Iesus tuacholia reria helenga, “Iri nenge singiria haleles mana tela nge non nenge umume nga haleles ana pele pe iri nenge singiria haleles ero tela ero nike. ");
INSERT INTO uvl_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Iau eat mana nge iri nenge muteria toto ke te hulia reria poinga poreke ngana mur pe te nanas mule iau. Pe iri nenge te teke iri siporia te pengpeng lo eat nge iri ero.” ");
INSERT INTO uvl_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Hana hel te onteia Iesus, “Pomere nenge Ioanes nena hana mur pe Paresio mur reria hana mur teheo nga ngaunga pe te hetalaulau ke kokoes pe lem hana mur ero?” ");
INSERT INTO uvl_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Iesus tuacholia, “Nenge teke none ngesia nehei, lape heo ele hulua nga ngaunga pule? Ero toto la! ");
INSERT INTO uvl_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Pe non nenge ngesnges ana etue nenge lohaka hatalia iri lape at. Nga etue nem hulua lochloch ngana nem lape teheo nga ngaunga ol.” ");
INSERT INTO uvl_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Iok, Iesus heleia helenga opene e pule, “Mele chach ia nena hengeron heueu ngana pe sima hite langa hengeron nike ngana ero. Nenge teke poia ke pomam lape poi poreke hengeron heueu ngana nem nge tachach ia. Pe lape poia hengeron nike ngana nem ke nakuna poreke pule. ");
INSERT INTO uvl_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Pe pule mele ling teua uain heueu ngana langa kina nenge nike ngana ero iange sosolos. Nenge teke poia ke pomam lape poia kina nike ngana nem ke chach pe pasiling hot, pe kina nem poreke sapele. ");
INSERT INTO uvl_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Ke lape a ling teua uain heueu ngana langa kina nenge heueu ngana pe makuk. ");
INSERT INTO uvl_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Pe mele lemene taua uain heueu ngana ero ol nenge teke inia nike ngana lo. Pe mele neu hele, ‘Nike ngana nem urana.’” ");
INSERT INTO uvl_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Nga Sapat ana etue Iesus iri ul nena hana mur tei teu langa ume e. Pe Iesus nena hana mur te sohe uit nganangana pe te soch hote paena pe te ngaua. ");
INSERT INTO uvl_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Pomalam Paresio mur te onteia Iesus, “Rera hotonga hele ke teke tapoi ke pomam nga Sapat ana etue ero. Pe pomere nenge lem hana mur tepoi ke pomam?” ");
INSERT INTO uvl_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Pe Iesus tuacholia iri, “Imo mam a sisia non soke Teuit poi ngana nge nike ero? Nga etue nenge iri ul nena hana mur te mete aria? ");
INSERT INTO uvl_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Te mete aria toto pe ana non i teu langa NeHalang nena pele pe mene ngaunga nenge heo ngana ke te ngaua. Pe rera hotonga hele ke teke ngaunga nem tunginga ana hana mur mana aria.” ");
INSERT INTO uvl_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Pe Iesus hele pule ke mai, “Sapat ana etue nem tokoninga koi iau Non Tuna.” ");
INSERT INTO uvl_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Nga Sapat ana etue e pule Iesus hetottoro nga hetoronga ana pele. Hetottoro pe none nge penna tamalmal mete tu pule. ");
INSERT INTO uvl_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Paresio mur pe hotonga ana hetoronga mur hel te tango rara kue nenge te ollaka hote Iesus ke poia poinga poreke ngana e. Pe te teke tenau ala tote i pe te nachnei hit tote i nge hemas ia non neu nga Sapat ana etue. ");
INSERT INTO uvl_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Pe Iesus eteia iri lochloch ramaria ke het lo pe hele lange non nenge penna mete neu, “Omes haka pe oi hot at lakoi nga muka.” Non neu mes haka pe la sapele nga muka. ");
INSERT INTO uvl_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","La ke mes pe Iesus hele lange iri, “E onteia imo lochloch. Hotonga nenge ita hele ke teke ta poia ume utar mur nga Sapat ana etue? Ta halau hel mule nge ita ma ta hunel mule nge ita? Nenge teke mele nge ana haleles palaungana tu tahun sapele i ma ta hemas mule i?” ");
INSERT INTO uvl_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Iesus nau rara nge iri lochloch pe hele lange non nenge penna mete neu, “Otul hote perim mete ngana nem ke pengpeng.” Pe non neu teke tul hote penna mete ngana neu ke mai pe penna urana mule sapele. ");
INSERT INTO uvl_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Pe hana nemur te esia ke mau pe leteria inin toto pe te hele tele hel nge iri nga utar nge lape te poia lange Iesus. ");
INSERT INTO uvl_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Nga etuene e Iesus i haka langa kileng chouchou ngana e ke hetalaulau. Pe hetalaulau nga kileng neu ke la uach sio. ");
INSERT INTO uvl_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Ol pe iua nena hana mur lochloch pe hesilei hot ke analoch pe nai pe hetue iri ke nena hekulkulonga mur. ");
INSERT INTO uvl_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Eria koi nemur: Simon (nenge Iesus hetue ke ene Petrus) pe tina Antreas pe Ieims pe Ioanes pe Pilipus pe Patolomius ");
INSERT INTO uvl_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","pe Mateus pe Tomas pe Ieims (nenge Alpeus tuna) pe Simon (nenge te hetue i ke Emo Kina) ");
INSERT INTO uvl_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","pe Iutas (nenge Ieims tuna) pe Iutas Iskariot (nenge Iesus nena non ia pe poi poreke mule lange Iesus). ");
INSERT INTO uvl_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Iesus hile kileng chouchou ngana neu pe iri ul nena hana nemur tei sio. Tei sio pe la temes nga kileng mosngana luluch nge na hana mur hel pule nge halang toto. Pe hulua halang teat nge Iutea pe nge Ierusalem pe nga ruach ilina pule nge Tir pe Siton. ");
INSERT INTO uvl_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Iri lochloch te teke teat ke te longo Iesus nge hetottoro pe te teke hemas mule iri nga aria haleles mur. Iri nenge uneinei tuteu nge iri teat pule pe Iesus hemas mule iri. ");
INSERT INTO uvl_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Pe hulua lochloch ngana te teke tera nge i iange kerkerenga nem lohot manmana nge i pe hemasia iri lochloch. ");
INSERT INTO uvl_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Ol pe Iesus naula nge na hana mur pe hele, “Imo nenge lemo ure halang ero, a iech toto iange atu teu nga NeHalang nena naualanga lo! ");
INSERT INTO uvl_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Imo nenge a meteamo nga ich heueu nei, a iech pule iange lape samo una nga hoena. Imo nenge a tangtang pe letemo meena toto heueu nei, a iech iange nga hoena lape a melmel mule. ");
INSERT INTO uvl_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","“Imo nenge a nanas tote Non Tuna pe hana muteria taua imo ero toto pe te tanga selel amo, a iech! ");
INSERT INTO uvl_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Nenge teke ure nei lohot nge imo, a iech toto pe ahes haka iange urumo palaungana kou kulele imo nga lut nga tapa. ");
INSERT INTO uvl_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Pe imo nenge lemo ure halang heueu nei, a iech ero ol iange atu ngamo nenge urana toto a mene ke ulolo! ");
INSERT INTO uvl_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Pe imo nenge samo huna heueu nei, a iech ero ol iange nga hoena lape a meteamo toto! Imo nenge a melmelmel heueu nei, a iech ero ol iange nga hoena lape a tang manmana ol! ");
INSERT INTO uvl_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Pe imo nenge hulua te heto hekeke imo, a iech ero ol iange nge nike hulua nemur reria tete mur te heto hekeke hana nemur nenge te pallaklaka ke iri hetatalonga.” ");
INSERT INTO uvl_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Pe Iesus hele mule, “E hele lange imo nenge a longo atat nge iau. Letemo la mule pe lememo tau mule lemo ngarang mur pe apoi ke urana mule lange iri nenge lemeria ero ia imo pe te tanga selel amo. ");
INSERT INTO uvl_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","A pete iri nenge te hele tautaua imo pe a hetalaulau iri nenge tepoi porekreke imo aria. ");
INSERT INTO uvl_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Nenge teke mele te pele iong o hulia hengem ele lange i ke te pele pule. Pe nenge teke mele achatote lem hengeron nenge hot ana, o ngata mana ke mene lem hengeron nenge teu ana pule. ");
INSERT INTO uvl_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Nenge teke mele hel te onteia iong nga ute hel, o tung mene lange iri pe nenge teke mele mene lem ute o ontei haka mule i ero ol. ");
INSERT INTO uvl_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Poinga urana ngana nenge lemem ke mele hel te poia lange iong o poia lange iri. ");
INSERT INTO uvl_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Nenge teke lememo tau mene hana nenge muteria taua imo lape a mene urumo utar? Anau lange hana porekreke ngana mur. Iri kau lemeria tautaua hana nenge muteria tautaua iri pule mau pe te mene ururia e ero. ");
INSERT INTO uvl_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Teke apoi ke urana lange iri nenge tepoi ke urana lange imo pe apoi ke pomam lange iri toro mana, pomere toto nenge lape a mene urumo? Pe hana nenge te poreke kau tepoi ke mau pule mau! ");
INSERT INTO uvl_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Pe nenge teke a tunge ute lange mele pe a teke tuachol mule pomere toto nenge a teke a mene urumo? Pe hana porekreke ngana mur kau te tung helel reria urelu mau pe te teke te mene pengpeng mule reria ure nenge te tunge la! ");
INSERT INTO uvl_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","A poia poinga nemur ero! Letemo la mule pe lememo tau mule lemo ngarang mur. Pe a tung ure lange mele hel pe lememo tau mule ero ol. Pomalam lape urumo palaungana toto pe NeHalang Nge I Soke Nga Lut Toto tutuna mur imo. Iange I poi ke nek toto lange iri nenge te poreke manmana pe iri nenge te hele urana erochro. ");
INSERT INTO uvl_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Letemo porekeia pekngamo mur lochloch ke pomange tememo nge letena porekeia imo lochloch ngana nga ich.” ");
INSERT INTO uvl_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“O henonou perim lange hehei pe hana nga reria poinga mur ero. Pomalam lape NeHalang henonou penna lange iong nga lem poinga poreke ngana mur ero pule. Pe o hele hote hehei pe hana reria poinga poreke ngana mur ero. Pomalam lape NeHalang hele hote lem poinga poreke ngana mur ero pule. Letem poreke ia hehei pa hana nga reria poinga poreke ngana mur. Pomalam NeHalang lape letena ia iong nga lem poinga poreke ngana mur. ");
INSERT INTO uvl_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Lem poinga nenge o tungtung o poia lange mele hel. Pomalam lape NeHalang poia lange iong pule. Pe i manmanna toto lape tuacholia lange iong ke pomai: nenge teke o tunge chasang elle NeHalang tuacholia nga chasang elle nge rure pe pip hite pe hemuta heke mule ke pararai pe tunge lange iong. Lem halaunga meena ngana nenge o poia lange mele hel lape NeHalang tuachol mule lange iong.” ");
INSERT INTO uvl_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Pe Iesus heleia helenga opene nei lange iri, “Nenge teke none nge matana hit koke neingana e nge matana hit pule lape iri nai te losio teu nga polo. ");
INSERT INTO uvl_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Pe kol mele nge lala nga hengetoro i palaungana nge ana hetoronga ero. Pe teke heulo hote ana hesinga nemur nga hengetoro lape poi ke mange ana hetoronga ol. ");
INSERT INTO uvl_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Pomere nenge o esia ae mumuna unne nge mateu nga tim e matana pe o kolkol taua ae chonna palaungana nge maele matam? ");
INSERT INTO uvl_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Pomalam lape o hele lange tim e neu ke pomai, ‘Kole tik, o iat ke e sulhote ae mumuna unne langa matam.’ Iong o hele ke mau pe iong sipom o kolkol taua ae chonna palaungana nem nenge maele matam. Iong opoi ke manga mamulou ero! Opoi hot tele ae chonna palaungana nenge maele matam. Ke het laka onau ke nek toto pe o sulhote ae mumuna nenge maele tim matana.” ");
INSERT INTO uvl_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Ae nenge haka pe nganngana lohot ke urana i ae poreke ngana ia ero. Pe ae nenge haka pe nganangana lohot ke poreke i ae urana ngana ia ero. ");
INSERT INTO uvl_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Ta eteia ae elle pe elle nga nganngana mur ke pomalam, o teke o sohe kon ola nga raka tana ero. Pe o teke o sohe here, ola nga kore tana ero. ");
INSERT INTO uvl_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Pe non nenge urana lape ta esia poinga urana ngana nge lohot nge i iange poinga nem at nga letena toto. Pe non nenge poreke lape ta esia poinga poreke ngana nge lohot nge i iange poinga nem at nga letena toto. Iange harra hele hote utar nenge muta nge ita nga letera toto.” ");
INSERT INTO uvl_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Pomere nenge o hetue iau ke am Soke iau pe opoi ke pomanga e hele ngak ero? ");
INSERT INTO uvl_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Mele nenge at nge iau pe longe lek helenga pe longo taua iri lape e henonou hote i ke i non nge pomai: ");
INSERT INTO uvl_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","I pomanga non nenge hemesia na pele pe selsio tote na pele huna munna pe ume heke nga um. Pe nga lukunna ech ngau reke kileng pe teke tak hote pele pe pele nem mes ke kerkereng toto iange te umeia ke nek toto nike. ");
INSERT INTO uvl_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Pe mele nenge longe lek helenga pe nanas taua ero lape poi ke pomanga mele nenge hemes mene na pele nga lut mana pe sel sue munna ero. Pe nga lukunna ech ngau reke ke at pe tak hote pele nem pe losio sapele. Pe pele nem uchulu ke poreke toto.” ");
INSERT INTO uvl_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Iok laol, Iesus heleia ure lochloch ngana nei lange hehei pe hana ke het pe i ke lange Kapernam. ");
INSERT INTO uvl_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Pe nga lamau non nenge i mukmuka nga palinga hel ana hana mur tu. Pe nena non nenge umume nge i singina haleles toto pe teke metmete lo. Pe ana non ana soke mutena tau tote i. ");
INSERT INTO uvl_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Ana soke longe Iesus pingana, ol pe kulosia hana papalaungana hel nge Israel ke tela taua Iesus ke hemas mule non soke neu nena non. ");
INSERT INTO uvl_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Tela ke te lohot nge Iesus pe te ech tote i pe te hele, “Lememem toto ke ola ke o hemas mule non soke neu nena non. Iange i poia ume palaungana toto at nge imem Israel mur. ");
INSERT INTO uvl_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Pe i mutena tau tote imem Israel mur pe lele lemem hetoronga ana pele.” ");
INSERT INTO uvl_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","La ol pe Iesus koko sapele nge iri. Tela rochroi nga pele lo pe non soke neu kulosia pekngana hel ke la te heleia i sipona na helenga lange Iesus, “Non Soke, lemek ero nge e hekuleileia iong. Iau e urana ero toto nge oteu at nga lek pele. ");
INSERT INTO uvl_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Pe pule e urana ero toto nge iau sipok ela ke e esia iong. Lemek ke e teke o hele mana pe lek non nenge umume nge iau urana mule. ");
INSERT INTO uvl_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Iau pule eume pe e longo tau menmene ak ae huna mur pe pule iau sipok enau ele palinga hel ana hana mur. E hele lange elle ke e teke, ‘Ola!’ pe ila. Pe e hele lange e pule ke e teke, ‘O i at!’ pe i at. Pe e hele lange lek non nenge umume nge iau ke e teke, ‘O poia ume nei!’ Pe i ume ia.” ");
INSERT INTO uvl_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Iesus rura toto nga Non Soke neu nena helenga nei. Longe ke het pe ralele taua hulua nenge te nananas ia i pe hele lange iri, “E hele lange imo pengpeng, e hottaua none nge letena manmanna ngana pomai ero kura. Pe nge Israel pule e hottaua e ero!” ");
INSERT INTO uvl_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Hana nenge te atia non soke neu na helenga tela mule nga pele pe haleles palaungana nenge poia non soke nena non neu het mule lo. ");
INSERT INTO uvl_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Pomange rou Iesus langa kileng e nge ene Naen. Pe nena hana mur pe hulua halang pule te nanasia i. ");
INSERT INTO uvl_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Te ii ke la te lohot nga kileng neu ana kue matana pe tesaol haka nga hei pakar e tuna koluna nge telolo hotote ke la tealo hitite. Pe hei pakar neu tuna elle mana ke ngana kolou nenge mete neu lo. Pe hulua halang nga kileng neu tei luluch nge i. ");
INSERT INTO uvl_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Ol pe Iesus esia hei pakar neu pe letena poreke toto ia i pe hele lange i, “Atong o tang ero.” ");
INSERT INTO uvl_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Pe Iesus i ke la rahaka nga metenga ana hete pe hana nenge te takisia temes. Pe Iesus hele, “Kol nem! E hele lange iong. O lohaka!” ");
INSERT INTO uvl_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Pe kol nenge mete neu are haka pe hele sapele. Pe Iesus tung mule i lange tana. ");
INSERT INTO uvl_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Pe hulua nemur te esia pe te matau pe te heto heke NeHalang pe te teke, “Hetatalonga e nge na kerkerenga palaungana toto i! Tu luluch nge ita! NeHalang at lo ke hemas mule nena hana mur!” ");
INSERT INTO uvl_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Iesus poia ure nei pe pingana song nga kileng lochloch ngana nge Iutea pe kileng nemur nenge tetu rochroi. ");
INSERT INTO uvl_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Iok, Ioanes nena hana mur te hele lange i nga ure lochloch ngana nei. Ioanes longe pe iu ke nena hana nai ");
INSERT INTO uvl_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","pe kulosia iri kela te onteia Iesus. Pe te teke, “Iong laka lom nenge NeHalang hele ke teke lape kulosia ke at? Eh, Mele nenge mo kulele kau lape atat kura mau?” ");
INSERT INTO uvl_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","La hana nai neu tela nge Iesus pe te hele, “Ioanes nenge henunun kulosia imem ke at mo onteia iong. Ioanes teke, ‘Iong laka lom nenge NeHalang hele ke teke lape kulosia ke at? Eh, Mele nenge mo kulele kau? Lape atat kura mau?’” ");
INSERT INTO uvl_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Nga etue neu pengpeng Iesus hemas mule hulua halang nga aria haleles mur pe helope hote uneinei mur pe poia iri nenge mataria hit ke tenau mule. ");
INSERT INTO uvl_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Pomalam Iesus tuacholia Ioanes nena hana mur ke teke, “Ala mule pe a hele lange Ioanes nga utar nenge a esia pe a longe lo. Iri nenge mataria hit tenau mulmule lo. Iri nenge aperia mete tei mulmule lo. Iri nenge haleles poreke ngana lohot nga singiria te urana mule lo. Iri nenge talngaria hit te longo mule lo. Iri nenge te mete te maul haka mule lo. Pe iri nenge reria ure halang ero pe tetu poreke toto nga ich te longlonge NeHalang na helenga urana toto ngana. ");
INSERT INTO uvl_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Hana nenge te longe lek helenga pe leteria manmanna ngana losio ero lape te iech toto!” ");
INSERT INTO uvl_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Iok, Ioanes nena hana mur tela ol pe Iesus talun ke nana urume Ioanes na poinga mur lange hehei pe hana. Pe hele ke teke, “Nenge ala nge Ioanes nga ich sana lomona nem pe nga ramamo a teke a esia utar toto? A teke a esia heilil ina a nge tutula iu rusia pe pellou rara mana? ");
INSERT INTO uvl_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Teke ramamo tunga nem ero pe a teke ala ke a esia utar? A teke A esia none nge heronia hengeron urana ngana mur? Hana nenge te heronia hengeron nenge pomam pe te ngaungaua ngaunga urana ngana mur tetu mana nga pele palaungana nenge uruna haka toto! ");
INSERT INTO uvl_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Iok, a hele at nge iau ol. Nga ramamo a teke a esia utar toto? A teke a esia hetatalonga e? Oe i manmanna ke i hetatalonga. Pe i altoto nga hetatalonga mur lochloch. ");
INSERT INTO uvl_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Ioanes i sipona nenge NeHalang na helenga nenge tehas sue hele tala ia lo. Ke NeHalang hele, “‘Lape e kulosia non nenge mene lek helenga ke imuka nge iong ke helue lem kue.’” ");
INSERT INTO uvl_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Pe Iesus hele pule, “E hele lange imo, Ioanes i palaungana toto nge hana lochloch nenge tetu nge nike ke at heueu nei. Pe nga NeHalang nena naualanga pe nekinga nge ita, iri nenge teat nga hoena lape te ele haka toto nge Ioanes.” ");
INSERT INTO uvl_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Hulua lochloch ngana nemur te longe pe iri ul hana nenge te lololoch umtutuna mana te heto heke NeHalang nge na poinga pengpeng mana. Iri te poi ke pomam iange Ioanes henune iri lo. ");
INSERT INTO uvl_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Pe Paresio mur iri ul hotonga ana hetoronga mur ero. Iri lemeria ero toto nge te nanasia NeHalang. Iange iri tela nge Ioanes ke henune iri ero nike. ");
INSERT INTO uvl_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Iesus hele mule, “Nga enau ngak nge hulua nga etue nei nakuria te teke tepoi ke pomere mai? ");
INSERT INTO uvl_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Tepoi ke pomalaka nga aina kinkino ngana nenge aria tuluk nai ke te arare nga ingala munna. Pe leteria inin tau helel pe hel te chusi. Iok, hel te alngaria tele lange pekngaria mur, “‘Pomere nenge mo palia emem hario pe ahes ero? Pe moute pum ana utunga pe a tang ero?’ ");
INSERT INTO uvl_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Oe, imo nga etue nei a pomanga aina nemur iange Ioanes nenge henunun at pe heo nga ngaunga pe inia ech kerkereng ngana e ero pe a hele ke a teke, ‘Non pa nem, uneinei tu nge i iam!’ ");
INSERT INTO uvl_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Iok, Non Tuna at. Ngaungau pe inin pe imo a hele, ‘Anau langa non pa neu! Non nei ngau halali! Pe in sakilil i! Pe kokoko nge hana nenge te lololoch umtutuna pe hana nenge reria poinga poreke toto!’ ");
INSERT INTO uvl_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Pe iri nenge te nanasia NeHalang iri te hemallaha hote ke NeHalang i pengpeng toto pe manmanna.” ");
INSERT INTO uvl_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Non Paresio e iua Iesus kela ngau nga na pele. Iok Iesus iteu langa pele neu pe kila sio ke te ngaungau ol. ");
INSERT INTO uvl_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Pe nga kileng neu heie nge poinga poreke ngana muta toto nge i tu. Ana hei longe Iesus nge lake ngaungau nga non Paresio neu na pele pe mene ech kina e nge te ume hote nga um. Pe ech kina nem muta ia ure nenge inangana ehech. ");
INSERT INTO uvl_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Pe la ana hei mes nga Iesus rumena nga apena mangana pe tangtang ol. Tangtang pe matana eina sio ke la lome Iesus apena. Ke het pe taune Iesus apena nga palpalna ina pe saka hite Iesus apena. (poi ngana nei, manga teke talsio tote i pe heto heke tote Iesus) Pe heusiling heke ure nenge inangana ehech neu nga Iesus apena. ");
INSERT INTO uvl_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Pe non Paresio neu esia pe hele mana nga letena, “Teke non nei i hetatalonga ke manmanna lape eteia hei nenge rachraua i neu. Pe pule eteia ke hei nem i hei poreke ngana toto.” ");
INSERT INTO uvl_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Iok, Iesus rahaka helenga pe hele lange i, “Simon, e teke e hele ia ute lange iong.” Pe Simon hele, “Iok, Non Soke, o hele ia at nge iau.” ");
INSERT INTO uvl_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Pe Iesus talun ke hele lange i sapele, “None tunge umtutuna lange hana nai pe teke nga hoena te tuacholia ke pengpeng la mule nge i. Elle nge iri mene ke umtutuna iri ana non kina lime iri lime (500) pe neingana mene ke umtutuna iri ana non kina nai pe analoch mana. (50) ");
INSERT INTO uvl_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Pe iri nai ape te teke te tuachol mule pe reria umtutuna ero toto. Ol pe non nenge tunge umtutuna lange iri hele lange iri nai, ‘Hanganok nemur nenge a poia nge iau lape lasus ol.’” Iesus hele ke het pe onteia Simon, “Non tei nge iri nai lape mutena tau tote non nenge tunge umtutuna nemur?” ");
INSERT INTO uvl_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Pe Simon lohaka pe hele, “Iau e teke ngana laka nenge mene ke umtutuna halang.” Pe Iesus hele, “Nem pengpeng.” ");
INSERT INTO uvl_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Pe Iesus naula nge hei neu pe hele mule lange Simon, “O esia hei nei? E i teu at nga lem pele pe o tunge ech ke e lome apek ero. Pe hei nei lome apek nga matana heina pe taune mule nga palpalna ina. ");
INSERT INTO uvl_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Pe iong, eat nga lem pele pe o iech ele iau pe olau hite iau ero pe hei nei saka hitite apek nga eat ngak nike. Ngana i popoia ne kura. ");
INSERT INTO uvl_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Pe iong opoi heke oliua eina nga palpaluk ero pe hei nei heusiling heke ure nenge inangana ehech nga apek. ");
INSERT INTO uvl_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Pomalam e hele lange iong hei nei eteia nge lape letek poreke ia i nga nena poinga poreke ngana mur lochloch ngana koi nenge mutena tau tote iau. Pe mele nenge na poinga poreke ngana unne sune mana pe letek poreke ia i nga na poinga nem mutena taua iau ke unne sune mana.” ");
INSERT INTO uvl_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Pe Iesus hele lange hei neu, “Atong, e saua lem poinga poreke ngana mur lochloch ke te lasus toto lo.” ");
INSERT INTO uvl_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Pe hana hel pule nenge iri ul te ngaungau neu te hele tele hel nge iri, “Itei pane mai ol, nge teke saua hehei pe hana reria poinga poreke ngana mur ke te lasus toto?” ");
INSERT INTO uvl_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Pe Iesus hele lange hei neu, “Letem manmanna ngana laka hemas mule iong. Ola mule pe otu ke nek ol.” ");
INSERT INTO uvl_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Iok, nga hoena ol Iesus i ke langa kileng elle pe elle pe haliu hote NeHalang nena helenga urana toto ngana. Helenga urana toto ngana nem hemallaha hote NeHalang nena naualanga urana ngana pe nena nekinga. Iesus i rara neu pe nena hana analoch pe nai neu tei luluch nge i. ");
INSERT INTO uvl_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Iok, hehei hel nge uneinei pe haleles poia iri Iesus hemas mule iri. Ke hehei nemur te koko pule. Hehei nemur eria mai koi: Maria (nenge ene e pule Mantalena) Ana hei Iesus poi hot ke uneinei iri rahtele nai nge i. ");
INSERT INTO uvl_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Hei e pule ene Ioana. Pe ana hei ene umume nga NeHerot na pele pe ene laka ne Kusa. Iok, hei e pule ene Susana. Ke hehei nemur pe hehei halang pule te halaua Iesus pe na hana mur nga iri siporia reria umtutuna mur. ");
INSERT INTO uvl_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Hulua halang te atat nge Iesus nga kileng pe kileng. Iri halang teat te emurung ol pe Iesus hele hote helenga opene nei lange iri. ");
INSERT INTO uvl_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","Pe hele, “None langa ume ke tata ngaunga tutuna alona. Tataua ngaunga tutuna nemur pe hel te losio hot ke tema nga alingele ke heitite iri pe ngie mur teat ke te tuais heke ke het. ");
INSERT INTO uvl_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Pe hel te losio teu nga um koana mur nga ich nenge ana um halang. Pe ngaunga tutuna nemur mataria hot pe te kalum mule iange ich nem poreke. ");
INSERT INTO uvl_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Pe ngaunga tutuna hel te losio teu nga kiki letena munna pe te haka luluch nga kiki pe kiki au hite iri ke te mete. ");
INSERT INTO uvl_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Pe ngaunga tutuna hel te losio haka nga ich nge urana pe te haka ke nek pe nganangaria halang toto. Ngaunga tutuna nemur nganangaria lohot ke ana non kina iri lime (100) nga tana elechle.” Pe Iesus haliu haka, “A pal talngamo pe a longo ke neknek!” ");
INSERT INTO uvl_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Iesus nena hana mur te onteia i nga helenga opene nei luna. ");
INSERT INTO uvl_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Pe Iesus tuacholia, “NeHalang hesilei hote imo ke a eteia ke mallaha nga helenga talkome ngana nga NeHalang nena naualanga. Pe iri hel lape te longo mene nga helenga opene ol. Ke pomalam, “‘Tenau pe tees ero. Pe te longe pe te eteia ero.’” ");
INSERT INTO uvl_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Helenga opene nem luna toto koi: Ngaunga tutuna nem pomalaka nga NeHalang nena helenga. ");
INSERT INTO uvl_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Pe ngaunga tutuna nenge te losio nga alingele nem te pomalaka nga iri nenge te longe NeHalang nena helenga. Ol pe Non Poreke ngana at pe ua toto ia NeHalang nena helenga nga leteria ke leteria manmanna ero ke pomalam te mene hemasinga ero. ");
INSERT INTO uvl_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Pe ngaunga tutuna nenge te losio haka nga ich nenge ana um halang te pomalaka nga iri nenge te longe helenga pe leteria manmanna mukam pe ure meena ngana lohot nge iri pe te losio mule ke ueiuei mana. ");
INSERT INTO uvl_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Pe ngaunga tutuna nenge te losio teu nga kiki letena munna te pomalaka nga iri nenge te longe helenga nem pe iri reria ure halang nga ich ke pomanga umtutuna pe ure urana ngana mur hel pule. Pomalam leteria tuit tote pe te umeia ume e nge urana ero. ");
INSERT INTO uvl_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Pe ngaunga tutuna nenge te losio nga ich urana ngana te pomalaka nge iri nenge leteria urana. Te longe helenga nem pe te talue ke nek toto nga leteria. Leteria manmanna ngana nem tu ke kerkereng kela aria ume nganangana mur lohot ke nek toto.” ");
INSERT INTO uvl_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Mele pele tonge lemenga pe hesalakou hite ero. Nem pe tal teua langa hete ene ero pule. Mele nem tonge pe tal heke mene nga lut ke hehei pe hana te esia tualeme ngana pe teteu at nga pele. ");
INSERT INTO uvl_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Utar nenge tetal komkome lape te mene hote langa mallaha. Pe utar nenge te esalakou hite lape te hottaua pe te mene hote langa mallaha. ");
INSERT INTO uvl_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Letemo tuanin ke nek toto nga a longo ngamo. Mele nenge nena ure hel malo lape te tunge nena hel pule. Pe mele nenge nena ure ero pe nga letena teke nena lo nem lape te ua toto ia nge i.” ");
INSERT INTO uvl_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Iesus tana pe titina mur te teke tela ke te neue i pe hulua halang tepoi ele i. ");
INSERT INTO uvl_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Pe mele hele lange Iesus, “Tam pe titim mur kou te mesmes nge hot te teke teat ke te esia iong.” ");
INSERT INTO uvl_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Pe Iesus hele lange iri lochloch, “Etak pe titik mur laka iri nenge te longe NeHalang na helenga pe te nanas taua.” ");
INSERT INTO uvl_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Nga etuene e Iesus iri ul nena hana mur te haka nga sulang e pe Iesus hele lange iri, “Ta lotele langa ech hetaliliu ngana nei ilina hele.” Iok laol, teote hot sapele. ");
INSERT INTO uvl_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Te mana ole ke te lala pe Iesus mamani sio. Ol pe kileng eingana palaungana lohaka sapele nga ech hetaliliu ngana neu. Pe ech pasiling teu nga reria sulang ke te teke te puluch. ");
INSERT INTO uvl_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Ol pe Iesus na hana mur telange i pe te engo heke i. Pe te hele, “Non Soke! Non Soke! Ta puluchluch lo i!” Iesus lohaka pe hele ke kerkereng toto langa kileng eingana palaungana nem pe ruach poreke ngana nem. Pomalam kileng eingana palau ngana nem mete sio pe ruach poreke ngana nem ma ke nek mule pe kileng urana mule. ");
INSERT INTO uvl_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Pe Iesus hele lange nena hana mur, “Letemo manmanna ngana tu langai?” Pe iri te rura pe te matau toto pe te hele tele hel nge iri, “Non tei nemai? I tunge na helenga kerkereng ngana langa kileng eingana palau ngana nei pe ruach ana mee papalau ngana nemur pe te longo tau mene i!” ");
INSERT INTO uvl_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Iesus pe nena hana mur te mana nga sulang nem kela te lohot nga kileng nenge Kerasa. Kileng Kalelea tu nga ech hetaliliu ngana palaungana neu ilina ele pe ana kileng tu nga ele. ");
INSERT INTO uvl_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Tela tesio nga kileng neu pe Iesus i sio ke langa peipei. Pe none nga kileng neu saol haka nge i. Non neu uneinei halang tetu teu nge i. Pe uneinei te poia i ke lachlach manmana nga halang nike pe tu ke nek nga pele e ero. Tu manmana nga um polona mur nenge tetal teueua hana nenge te metmete. ");
INSERT INTO uvl_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Non neu esia Iesus pe halngana haka ke soke toto pe tamal sue i nga Iesus apena huna pe alngana ke teke, “Iesus! Iong NeHalang Nge I Soke Nga Lut Nga Tapa Tuna! O teke o potaria iau? O tunge melmelenga palaungana at nge iau ero!” ");
INSERT INTO uvl_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Non neu hele ke pomai lange Iesus iange Iesus hele lo ke teke helope hote uneinei nemur nge i. (Kokoeses hana te kele non neu penna pe apena ana rur kerkereng ngana pe tenau ala tote i. Pe uneinei nemur tera hit tote i. Pe i tak hoa rur kerkereng ngana nemur pe uneinei nemur te heua ia i ke langa ich sana lomona.) ");
INSERT INTO uvl_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Iok laol, Iesus onteia i, “Em mere?” Pe non neu tuacholia, “Ek laka, Hulua” Ene pomam iange uneinei halang tetu teu nge i. ");
INSERT INTO uvl_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Pe uneinei nemur te echia Iesus ke te teke kulosia iri langa polo poreke ngana ero. Iange polo nem takolkol hetala ngana pe te amneia melmelinga palaungana. ");
INSERT INTO uvl_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Pe kie ana tuangarung hel te tutua nga sasana palaungana e ilina. Pe uneinei nemur te echia Iesus ke tela ke teteu langa kie nemur. Pe Iesus longele lange iri ke la teteu langa kie nemur. ");
INSERT INTO uvl_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Iok laol, te lohot nge non nem pe teteu heke sapele kie nemur. Teteu heke kie nemur pe iri lochloch te song kela te losio hot nga kileng talloko sio ngana nem kela te pachpach nga ech. ");
INSERT INTO uvl_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Pe hana nenge tenau elele kie nemur te esia ke mau pe te song ke la te hesongia ana helenga nga tuele tana pe nge iri nenge tetu kangkanga nge hot pule. ");
INSERT INTO uvl_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Helenga song pe iri nenge te longe tela kela tenau nga ure nenge lohot nga lamam. Tela kela te lohot nge Iesus pe te esia non nenge uneinei mur te ua hot nge i. Ana non letena urana mule lo pe heron ke nek toto pe are sio nga Iesus apena una. Iri lochloch te esia ke mau pe te matau toto. ");
INSERT INTO uvl_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Iri nenge tees tote Iesus nge helope hote uneinei nemur te hele urume lange pekngaria mur. ");
INSERT INTO uvl_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Hana lochloch ngana nga kileng neu te matau toto pe te hele lange Iesus ke ua toto aria. Pomalam Iesus lohaka sapele ke teke langa sulang. ");
INSERT INTO uvl_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Pe non nenge Iesus hemas mule i neu la pe la hele ke kerkereng toto lange Iesus, “O hele ele iau ero pe ela luluch nge iong.” Pe Iesus kulos mule i pe hele, ");
INSERT INTO uvl_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Ola mule nga lem kileng pe o hele hote ure palaungana nenge NeHalang poia lange iong lo.” Iok laol, non neu langa tuele tana neu pe hele hote ure palaungana nenge Iesus poia lange i. ");
INSERT INTO uvl_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Iok, Iesus pe nena hana mur te lotele la mule nga ech palaungana neu ilina ele pe hehei pe hana te iech ele i iange te kulele i ke mala lo. ");
INSERT INTO uvl_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Ol pe none nge ene Iairos puris. I nge nauelele hetoronga ana pele nga kileng neu. I at pe tamal sue i langa Iesus apena pe hele ke kerkereng toto lange Iesus ke teke langa na pele, ");
INSERT INTO uvl_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","iange tuna heingana e singina haleles ke metmete lo. Pe non neu tuna elle mana ke ngana kolou neu lo. Pe tuna nem ana hesinga iri analoch pe nai. Iesus i ole ke lala nga non neu na pele pe hulua te emurung hit tote i. ");
INSERT INTO uvl_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Hei e nge haleles poreke ngana mene i ii luluch nge iri pule. Hei neu toho mala tu nge i ke hesinga iri analoch pe nai pe mele e nge nakuna ero toto nge hemasia i. ");
INSERT INTO uvl_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","La ol pe hei neu echrir teu mene i nga hulua leteria kela raua Iesus nena hengeron ana horo nga rumena. Hei neu raua Iesus na hengeron pe haleles neu het sapele nge i. ");
INSERT INTO uvl_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Pe Iesus ontei, “Itei nenge raua iau mai?” Pe iri lochloch te hele ke te teke te raua Iesus ero. Pe Petrus lohaka pe hele, “Non Soke pomere nenge o ontei ke pomam? Onau nga hulua lochloch ngana nenge te maimai hite iong nem.” ");
INSERT INTO uvl_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Pe Iesus hele mule, “Ero, mele nenge raua iau nei rau pulut mene iau ero koi. Raua iau ke e hemas mule i iange e amnei urume nga lek kerkerenga nenge lohot nge iau.” ");
INSERT INTO uvl_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Hei neu eteia nge lape i talkome ero ol pe loiloi ele i pe la tamal sue i nga Iesus apena. Pe nga hulua mataria hei neu hele urume ke i sipona raua Iesus pe ana haleles het sapele. ");
INSERT INTO uvl_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Pe Iesus hele ke nek mana lange hei neu, “Atong heek, letem manmanna ngana hemas mule iong. Ola pe otu ke nek ol.” ");
INSERT INTO uvl_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Iesus helele kura pe te kulosia none at nga Iairus na pele pe hele lange Iairus, “Tum kou mete lo. O hemakuk mene non soke nem ero ol.” ");
INSERT INTO uvl_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Iesus longe reria helenga pe hele lange Iairos, “O matau ero. O rahit ele mene letem manmanna ngana ke heem maul mule.” ");
INSERT INTO uvl_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Iok, tei kela te lohot nga Iairus na pele pe Iesus mene Petrus pe Ioanes pe Ieims pe he sune neu temene pe tana ke teteu langa pele letena. ");
INSERT INTO uvl_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Pe hehei pe hana te tangtang pe te chauchai sakililia he sune neu nge mete. Pe Iesus hele lange iri, “A tang ero ol. He sune nem mete ero iam. I mamani mana!” ");
INSERT INTO uvl_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Pe iri lochloch ngana te melmel lilia Iesus iange iri te eteia ke he sune neu mete toto lo. ");
INSERT INTO uvl_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Ol pe Iesus rahite he sune neu nga penna pe hele haka ke soke, “Heek sune nem, o lohaka ol!” ");
INSERT INTO uvl_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Pe he neu opene at mule pe lohaka sapele. Lohaka pe Iesus hele ke te tung ngaunga lange i ke ngau. ");
INSERT INTO uvl_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","He neu tana pe temene te rura toto pe Iesus hele lange iri ke te hele rara lange mele hel ero nga ure nenge lohot nei. ");
INSERT INTO uvl_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Iesus iua nena hana analoch pe nai nem ke tunge kerkerenga lange iri. Pe tunge na kerkerenga palaungana nenge iri siporia te poia ume ke te helope hote uneinei pe te hemasmas ia haleles mur. ");
INSERT INTO uvl_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Ke het pe kulos hote iri ke la te haliu hote NeHalang nena naualanga urana toto ngana pe te hemasmas haleles. ");
INSERT INTO uvl_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Kulosia iri pe tunge helenga nei lange iri, “A teke a lohaka a mene ute e ero toto nga lemo inga nenge ai ke a poia ume nemur. A mene heko ero, kole ero, ngaunga ero, umtutuna ero pe pule lemo hengeron naingana ero. ");
INSERT INTO uvl_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","A lohot nga kileng e pe ama nga pele tei atu lola. Atu nga pele nem ke la het nga etue nenge a ume ke het nga kileng nem. ");
INSERT INTO uvl_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Pe teke ala nga kileng e pe hehei pe hana te iech ele imo ero ai hot nga kileng nem pe a pasis sue ich mumuna nga apemo. Pomalam a henonou hote NeHalang letena inin ngana lange iri.” ");
INSERT INTO uvl_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Iesus nena hana mur te lohaka sapele pe tei ke tela nga kileng lochloch ngana ke te haliu hote NeHalang na helenga urana toto ngana pe te hemas mule hehei pe hana nga aria haleles mur. ");
INSERT INTO uvl_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Pe Herot non soke nenge nauele kileng Kalelea longe ure nemur nge te lohotot pe letena tuanin raraia ke halang iange mele hel te teke, “Ioanes nenge henunun kou maul haka mule lo!” ");
INSERT INTO uvl_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Pe hel te teke Elaisa lohot ke i mallaha. Pe hel te teke hetatalonga e nge nike iam maul haka mule nem. ");
INSERT INTO uvl_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Pe Herot hele, “Iau e chatoa Ioanes nga kanna lo pe non tei nemai nenge e longlonge nge popoia ure peltit ngana nemur?” Pe Herot letena toto ke teke es tote Iesus. ");
INSERT INTO uvl_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Iok laol, Iesus nena hekulkulonga (Apostel mur) teat mule nge Iesus pe te hele urume ure lochloch ngana nenge te poia nga reria inga nem lange i. Te nana lange Iesus ke het pe Iesus mene iri ke iri hul mana tela nga kileng nenge ene Petsaita. ");
INSERT INTO uvl_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Pe nga hoena hulua te longo rusia ol pe te nanas sapele i. Iesus esia iri nge teat pe iech ele iri pe hetoro mule iri nga NeHalang nena naualanga urana ngana nge ita. Pe hemas mule iri nenge singiria haleles. ");
INSERT INTO uvl_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Chaia matana puluch sisio lo pe Iesus nena hana mur tela nge i pe te hele, “O kulosia hehei pe hana nemur ke tela nga kileng nemur nenge tetu rochroi lamai ke te tango aria ngaunga pe muria nenge te maia. Iange kileng nei ich sana lomona mana i.” ");
INSERT INTO uvl_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Pe Iesus hele lange iri, “Ero, imo sipomo a hengaua iri.” Pe iri te tuacholia, “Imem motal ke mioka iri lime pe ruo nai mana. Lemem ke mola mo ol hulua nei aria ngaunga?” ");
INSERT INTO uvl_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","(Hana nenge tetu lamau nakuna nenge iri 5000.) Pe Iesus hele lange na hana mur, “A hele lange hana nemur ke teare pe a sisele iri ke ana non kina nai pe analoch (50) nga tuluk elle pe elle.” ");
INSERT INTO uvl_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Iesus nena hana mur te nanasia na helenga ke te poia hana lochloch ngana neu ke teare sio. ");
INSERT INTO uvl_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Iesus mene mioka lime neu pe ruo nai neu pe nau haka langa tapa pe heto heke NeHalang pe hele urana toto lange i. Ke het pe reke pe tunge lange nena hana mur ke te heronge lange hulua nemur. ");
INSERT INTO uvl_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Hulua lochloch ngana neu te ngau ke saria una toto pe ngaunga nem aluana ma kura. Pe Iesus nena hana mur te eukiraua ngaunga aluana mur nge muta nga chasang nge iri analoch pe nai (12). ");
INSERT INTO uvl_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Nga etuene e Iesus hetalaulau nge isipona pe nena hana mur tetu luluch nge i. Pe onteia iri, “Hulua lochloch ngana te teke iau itei?” ");
INSERT INTO uvl_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Pe iri te tuacholia, “Mele hel te teke iong Ioanes nenge henunun. Pe hel te teke iong Elaisa pe hel pule te teke iong hetatalonga e nge nike nge maul haka mule.” ");
INSERT INTO uvl_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Pe Iesus ontei, “Pe imo? A teke iau itei?” Pe Petrus tuacholia, “Iong Kristus non nenge NeHalang hele tala ia ke teke kulosia at.” ");
INSERT INTO uvl_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Iesus longe Petrus tuachol ngana pe hele ke kerkereng toto lange iri ke te hele rara ia lange mele hel ero toto. ");
INSERT INTO uvl_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Pe Iesus hele pule, “Non Tuna lape amneia melmelenga palaungana. Pe hana papalauna pe tunginga ana hana mur aria papalauna mur pe hotonga ana hetoronga mur lape lemeria ero ia i. Pe lape te hune i ke mete pe nga etue mol ngana lape maul haka mule.” ");
INSERT INTO uvl_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Pe Iesus hele lange iri lochloch, “Nenge teke mele nem lemene toto ke nanasia iau poi ke pomai koi; Hile sue lemene ngana mur lochloch nga ich pe takisia ana melmelenga mur nga etue lochloch. Pomalam nanasia iau ol. ");
INSERT INTO uvl_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Iange itei nenge letena tu hit mene maulul ngana nga ich lape maulul ngana nem nga hoena ero ol. Pe mele nenge tung teu tote i pe hile sue lemene ngana mur lochloch nga ich lape mene mule maulul ngana nenge tu ke koko. ");
INSERT INTO uvl_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Pe nenge mele lolochia ure lochloch ngana nga ich nei pe nga hoena na poinga poreke ngana mur poia i ke amneia melmelenga palaungana lape ure pa nemur te halaua i ke mere? ");
INSERT INTO uvl_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Nenge teke mele meia i at nge iau pe nga lek helenga mur Non Tuna lape meia i lange i pule nga etue nenge sio at luluch nga lemenge palaungana nenge i pe nge Temene pe nge angkelo mur. ");
INSERT INTO uvl_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","E hele ke manmanna toto lange imo. Mele hel nge imo nenge te mesmes heueu nei lape tenau tele NeHalang nena naualanga urana toto ngana ke het pe te mete ol.” ");
INSERT INTO uvl_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Iesus heleia ure nemur ke het pe etue iri rahtele mol (8) nga hoena mene Petrus pe Ioanes pe Ieims ke te haka langa sasana ke hetalaulau. ");
INSERT INTO uvl_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Iesus hetalaulau ol pe hul ke nakuna lohot ke altoto. Pe nena hengeron sinaha pe tuahu toto. ");
INSERT INTO uvl_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Ol pe hana nai temes hot sapele ke te hele luluch nge i. Hana nai nem laka Moses iri nai Elaisa. ");
INSERT INTO uvl_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Iri te lohot luluch nga lemenge palaungana nga tapa pe te hele luluch nge Iesus. Te hele luluch nge Iesus nga mete ngana nge Ierusalem ke pomanga NeHalang talue lo. ");
INSERT INTO uvl_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Petrus pe pekngana mur te mamani un toto lo pe te lohaka pe te naue Iesus nge tu luluch nga lemenge palaungana pe hana nai neu temes luluch nge i. ");
INSERT INTO uvl_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Iok, hana nai neu te teke te hile susue Iesus lo pe Petrus hele lange Iesus, “Non Soke, urana toto nge imem koloi motu nei lo. Lape mo ume ke pelpele iri mol. Iong lem e pe Moses na e pe Elaisa na e.” (Pe Petrus eteia utar nenge helele ia ero.) ");
INSERT INTO uvl_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Petrus helele kura pe ulu lohot ke ana mulil ma hite iri pe Iesus nena hana nemur te matau toto nga ulu neu nge poi hite iri. ");
INSERT INTO uvl_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Pe helenga e lohot nga ulu ke teke, “Tuk toto koi nei nge e hesilei hote. A longo mana lange i.” ");
INSERT INTO uvl_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Helenga neu het ol pe Iesus i toro mana tu nga lamau ol. Pe Iesus nena hana nemur te reng hit tote ure nemur. Pe nga etue neu te heleia helenga unne lange mele ero toto nga ure nenge te naue ke ulolo. ");
INSERT INTO uvl_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Iok, pomange rou Iesus pe nena hana mol neu tei sio mule nga sasana neu pe la te saol haka nge hulua nge te kulelele i nge sio. ");
INSERT INTO uvl_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Pe none alngana hot nga hulua leteria, “Non Soke, letem ia iau pe onau lange tuk mukam. Iange tuk elle mana ke ngana i loi nenge uneinei te poia nei. ");
INSERT INTO uvl_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Uneinei nem teu hekeke i pe te tamal sue i ke sechul rara nga ich. Uneinei nemur te heporeke tote i ke melona tua nga hanna pe singina emurung ulu ke poreke toto ol pe tehet sio mule nge i. Ke mala ero mana pe teteu heke mulmule i. ");
INSERT INTO uvl_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","E hele ke kerkereng toto lange lem hana mur ke te kulos hote pe te alker taua.” ");
INSERT INTO uvl_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Pe Iesus hele lange iri, “Imo nemur nga etue nei letemo manmanna ngana mur te losio lo. Pe lemo poinga poreke ulu. Etu luluch nge imo ke mala lo pe pomere nenge letemo manmanna ero? Pe lape e halaua imo ke merei ol?” Pe Iesus hele lange non neu, “O mene tum at nge iau.” ");
INSERT INTO uvl_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Te mene kol neu ke lala pe uneinei nemur teteu haka mule i. Te tamal sue i langa ich pe te heloiloi ia i ke sasahul rara nga ich. Pe Iesus keres taua uneinei neu ke lohot nge kol neu. Hemas mule i ke nek pe tung mule i lange temene. ");
INSERT INTO uvl_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Pe hulua lochloch ngana nemur te rura toto nga NeHalang nena kerkerenga palaungana nei. Ure nenge Iesus poi nei, poia iri lochloch ke haria kangkanga manmana ia kura pe Iesus hele lange nena hana mur, ");
INSERT INTO uvl_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“A longo ke nek toto nga ure nenge e teke e heleia lange imo pe letemo lilil ele ero! Lape te tung heke Non Tuna langa hana hel peria.” ");
INSERT INTO uvl_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Pe Iesus nena hana mur leteria matana hote helenga nei luna ero. Pomalaka nga ute helau ele leteria matana ngana nga helenga nei ke te heilang hote luna ero. Pe te matau pule nge te ontei hot mule nga luna. ");
INSERT INTO uvl_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Iesus nena hana mur te hunel mule nge iri nga itei nge iri nge lape lohot ke i palaungna toto. ");
INSERT INTO uvl_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Pe Iesus eteia leteria tuanin ngana ke ulolo ke mene mele sune ke hemesia i nga ilina ");
INSERT INTO uvl_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","pe hele lange iri, “Mele nenge mutena taua aina sune nge mai mutena taua iau pule. Pe mele nenge mutena taua iau mutena taua itei nenge kulosia iau ke eat. Pomalam itei nenge talsio tote i nge imo lape i palaungana toto.” ");
INSERT INTO uvl_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Pe Ioanes hele haka, “Non Soke, mo naue none nge helope hotote uneinei mur nge hana pe i popoia nga kerkerenga nenga iong em. Pe mo hele ele ke poi ke mau ero ol iange i pekngamem ia ero.” ");
INSERT INTO uvl_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Pe Iesus hele lange i, “O hele ele i ero iange itei nenge lem ngarang ia ero i pekngam ia.” ");
INSERT INTO uvl_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Etue nenge Iesus haka langa lut nga tapa heroi lo. Ol pe Iesus letena haka toto ke teke lange Ierusalem. ");
INSERT INTO uvl_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Pe kulosia mele hel ke iri muka langa kileng e nge Samaria ke te tango rara pele e nge lape te maia. ");
INSERT INTO uvl_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Pe hehei pe hana nga kileng neu lemeria ero nge Iesus la ke tu nge iri iange te eteia ke i lala nge Ierusalem. ");
INSERT INTO uvl_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Ieims iri nai Ioanes te longe ke mau pe te hele, “Non Soke, lemem ke o teke moiu sue oan nga tapa ke at ngaulele kileng nei?” ");
INSERT INTO uvl_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Pe Iesus nau lange iri pe keres ele iri ");
INSERT INTO uvl_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","pe tei toto ke tela nga kileng e pule. ");
INSERT INTO uvl_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Iok, tei ole ke telala pe none hele lange Iesus, “Lape e nanas menmene iong lo koi. O teke oi ke ola nga kileng tei iau pule ela.” ");
INSERT INTO uvl_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Pe Iesus hele lange i, “Kaone inolo mur reria polo nge te mama ia pe ngie mur reria kiniu pe Non Tuna munna nga kileng e ero nge lake mateu ia.” ");
INSERT INTO uvl_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Pe Iesus hele lange none pule, “Iong nem o iat ke o nanasia iau.” Pe non neu hele, “Non Soke, o longele iau ke ela mule ke ealo hite temek mukam.” ");
INSERT INTO uvl_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Pe Iesus tuacholia, “Iri nenge te pomanga te mete lo, tela ke tealo hite pum nem. Pe iong ola ke ohaliu hote NeHalang nena naualanga urana toto ngana.” ");
INSERT INTO uvl_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Iok, none pule hele, “Non Soke, lape e nanasia iong. Eh, O longele iau ke ela mule nga lek kileng ke e ee ia lek hei pe tutuk mur mukam.” ");
INSERT INTO uvl_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Pe Iesus hele lange i, “Mele nenge talune lamonga pe letena tu hit tote ero, lamonga nem lape het ero. Pe nenge mele letena nachnai nge nanasia iau, nena kerkerenga e ero nge teu langa NeHalang nena naualanga urana toto ngana.” ");
INSERT INTO uvl_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Iesus henonou hot ke hana iri ana non kina mol pe analoch pe nai (72) pe kulos hote iri. Pe kulos ke nachnai ke iri muka nge i ke tela nga kileng lochloch ngana nenge lape i laia. ");
INSERT INTO uvl_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Pe Iesus hele lange iri, “Ume lochloch ngana nganangaria mur te mera tach lo pe lulunga ana hana mur iri unne sune mana. Ke a hetalaulau lange tokoninga nenga ume nemur ke kulos hote lulunga ana hana mur ke te lule ana ume mur. ");
INSERT INTO uvl_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Iok ala ol! E kulosia imo ke a pomanga sipsip tutuna mur nenge la tetu teu luluch nge kaone inolo mur. ");
INSERT INTO uvl_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Ala pe a mene umtutuna ero pe a takis kole ero pe a mene lemo ae ulina e ero pule. Nenge teke a saolia mele hel nga kue ames ke a hele sakilil ero. ");
INSERT INTO uvl_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Nenge teke ai teu nga pele e a hele tala ke pomai, ‘Non Palaungana na petanga tu luluch nge imo.’ ");
INSERT INTO uvl_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Nenge teke none nem na poinga urana pe purpure petanga nem lape lemo helenga urana ngana nem masio nge i ke nek. Pe nenge teke ero, lemo helenga urana ngana nemur lape haka mule nge imo. ");
INSERT INTO uvl_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Atu mana nga pele elle nem ke a ngaungau pe a ininia utar nenge te tunge lala nge imo iange a ume lamam pe urumo laka. Pe ama lilis rara nga pele hel pule ero ol. ");
INSERT INTO uvl_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Ala nga kileng e pe ai teu langa pele e pe a ngaua utar nenge te tunge lala nge imo. ");
INSERT INTO uvl_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","A hemas mule iri nenge aria haleles nga lamam pe a hele lange hehei pe hana ke a teke, ‘NeHalang nena naualanga urana toto ngana heroi taua imo lo.’ ");
INSERT INTO uvl_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Pe nenge teke a langa kileng e pe te ulo ele imo ai hot langa kue pe a heleia iri ke a teke, ");
INSERT INTO uvl_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Mo pasis sue lemo kileng ana maruchrue nga apemem ke a eteia nge NeHalang lemene ero toto ia lemo poinga poreke ngana mur. Imo letemo matana ke nek, NeHalang nena naualanga urana toto ngana at rochroi toto nge imo pe lememo ero ia lo!’ ");
INSERT INTO uvl_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","E hele ke manmanna toto lange imo. Nga etue palaungana nem lape NeHalang letena porekeia kileng nenge Sotom pe lemo kileng ero!” ");
INSERT INTO uvl_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Imo nenge Korasin lape atu ngamo poreke toto! Pe imo nenge Petsaita lape a poreke toto pule! Iange NeHalang poia ure papalaungana nge imo ke a esia lo pe letemo manmanna ia ero. Pe toinge NeHalang poia ure papalaungana nemur nge Tir pe Siton lape iri te hulia reria poinga mur nga halang nike. Iri te henonou hote iri nge te hulia reria poinga poreke ngana mur ke pomai; te heronia hengeron muna hulu ngana pe te hepore singiria ana apou! ");
INSERT INTO uvl_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Nga etue nenge NeHalang nau teu at nge ita elle pe elle nga rera poinga mur lape letena poreke ia iri nenge Tir pe Siton unne sune pe imo nem ero toto. ");
INSERT INTO uvl_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Pe imo nenge Kapernam nenge a teke ala nga lut nga tapa. Lape te tamal sue imo ke ala nge sio toto nga kileng au ngana!” ");
INSERT INTO uvl_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Iesus hele lange na hana mur, “Mele nenge longo taua imo longo taua iau pule pe mele nenge ulo ele imo ulo ele iau pule pe mele nenge ulo ele iau ulo ele I nenge kulosia iau at.” ");
INSERT INTO uvl_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Hana iri ana non kina mol pe analoch pe nai (72) neu teat mule pe te iech toto. Pe te hele lange Iesus, “Non Soke, uneinei mur pule mo kulos hote iri nga iong em pe te longo tau mana!” ");
INSERT INTO uvl_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Pe Iesus tuacholia lange iri, “E esia non poreke ngana nge losio at nga tapa ke pomanga kileng chalem ngana. ");
INSERT INTO uvl_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","A longo ke nek! Iau e tunge lek kerkerenga lange imo ke imo sipomo a poia ume nemur nenge pomai. Ai haka nga ilimo nenge te hunun pe a hekolkole iri. Pe ei mur nenge te hunun ita, lape apoia iri ke pomam pule. Pe a hekou sue lemo ngarang Non Poreke ngana nem nena kerkerenga. Pe ute pele nge heporeke imo ero. ");
INSERT INTO uvl_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Uneinei ne mur te longo taua imo pe a iech sakilil ero nge a mene kerkerenga palaungana nem. A iech toto mana nga emo nge tehas sue nga lut nga tapa.” ");
INSERT INTO uvl_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Nga etue unne neu Opepengpeng hemute Iesus nga iechinga pe hele, “Temek O! Iong Non Soke nenga lut nga tapa pe nga ich! E heto heke iong pe e hele urana toto lange iong nge o talkome ure nemur nge hana nenge leteria matana pe te etei toto nga ure lochloch ngana nga ich. Pe O hemallaha hot mene lange hana nenge leteria manga aina kinkino ngana pe te etei sakilil ero. Oe Temek, o iech toto nga ure nei nge lohot ke nanas tau tote lemem ngam. ");
INSERT INTO uvl_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","“Temek tunge ure lochloch ngana at nge iau lo. Mele e nga ich nei etei tote iau ero, Temek i toro mana etei tote iau. Pe mele e nga ich nei etei tote Temek ero, iau toro mana e etei tote pe pule iri nenge iau lemek ke e hetei hote iri lange Temek.” ");
INSERT INTO uvl_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Pe Iesus naula nga na hana mur pe hele mana lange iri, “Imo nemur a iech toto nga ure ne mur nenge aesia iri! ");
INSERT INTO uvl_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","E hele pengpeng lange imo. Hetalalonga mur pe naungaala ana hana mur nge nike eingaria chup tau tote ure nenge imo aesia pe iri te kolkolia. Pe eingaria chup tau tote ure nenge imo a longe pe iri te longe ero.” ");
INSERT INTO uvl_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Non hotonga ana hetoronga e iat ke teke totoia Iesus. Pe hele, “Non Soke, lape epoi ke merei ke e mene tunga nenga maulinga ke koko?” ");
INSERT INTO uvl_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Pe Iesus tuacholia, “Tehas sue ke mere nga NeHalang nena hotonga mur? Pe iong o sisia pe luna ma ke mere?” ");
INSERT INTO uvl_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Pe Non neu tuacholia, “Mutem taua NeHalang amo Soke nga letem toto pe nga opem pe nga kikim ngam toto pe nga letem tuanin ngana mur lochloch. Pe pule mutem taua neingam ke pomanga mutem taua iong sipom.” ");
INSERT INTO uvl_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Pe Iesus hele lange i, “Lem tuacholinga nem pengpeng toto. Opoi ke pomai pe nga hoena lape otu luluch nge NeHalang.” ");
INSERT INTO uvl_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Pe non hotonga ana hetoronga neu teke hepeng mule i sipona ene pe ontei mule Iesus, “Itei hel toto nenge iau neingak mur?” ");
INSERT INTO uvl_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Iok laol, Iesus tuacholia lange i ke pomai, “None lohaka nge Ierusalem pe i ke ramana sio lala nge Ieriko. Ol pe hana porekreke ngana hel te laua i pe te palia i ke mete par. Pe te haka hote nena hengeron mur pe te ua sapele. ");
INSERT INTO uvl_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Pe tunginga ana hana mur e nanas sio nga kue neu ke lala nge Ieriko pule pe esia non neu nge ma nga kue pe i kel nga kue ele pe la sapele. ");
INSERT INTO uvl_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Iok, none pule nge mata nenge Liuai nanas sue kue neu pule pe esia non neu nge ma pe kel ana pule. ");
INSERT INTO uvl_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Pe non Samaria e nanas sio ke la pe esia non neu nge tepal poreke ke ma pe letena poreke toto ia i. ");
INSERT INTO uvl_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Ol pe lake lome na chanchan mur nga oliua eina luluch nga uain. Ke het pe tal heke i nga nena tongki pe mene i ke langa pele nenge lang mur tema teueu ia pe nauele i. ");
INSERT INTO uvl_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Pomange rou non Samaria neu tung hot ke alak iri nai lange non nenge nauelele pele neu pe hele lange i ke teke, ‘O nauele non nei pe teke o hesilia ure hel nge i eat mule pe e tuacholia lange iong ol.’” ");
INSERT INTO uvl_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Iok, Iesus onteia hotonga ana hetoronga neu, “Nga ramam non tei nge hana mol nei nge o teke neingana toto non nenge te palia neu?” ");
INSERT INTO uvl_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Pe non hotonga ana hetoronga neu hele, “Ngana laka i nenge letena porekeia non nenge hana te palia nem.” Pe Iesus hele lange i, “Iok, Ola pe opoi ke pomalaka nge non nem.” ");
INSERT INTO uvl_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Iok laol, Iesus iri ul nena hana mur teila pe Iesus iteu nga kileng e. Pe heie ene Marta mene Iesus ke langa na pele. ");
INSERT INTO uvl_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Pe Marta tina e ene Maria. I kila sio nga Iesus apena huna ke longlongo Iesus nge hetottoro. ");
INSERT INTO uvl_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Pe Marta letena inin taua tina Maria iange halaua i nga tuninga ero. Ol pe la ke hele lange Iesus, “Non Soke, tik pai hile sio mene iau ke iau toro e popoia ume lochloch pamai. Heongana nge at ke halaua iau kai?” ");
INSERT INTO uvl_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Pe Iesus tuacholia Marta pe hele, “Atong liuk, iong letem tu nga ure halang sakilil. ");
INSERT INTO uvl_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Pe ure elle mana nge urana toto nge letem tu hite. Pe Maria hottaua ure nem pe lape e ua ia nge i ero ol.” ");
INSERT INTO uvl_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Iok, nga etuene Iesus hetalaulau nga kileng unne. Hetalaulau ke het pe nena none hele lange i, “Non Soke, o hetore imem ke mo hetalaulau pule ke pomange Ioanes nge hetore nena hana mur.” ");
INSERT INTO uvl_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Pe Iesus hele lange iri, “Nenge teke a hetalaulau, a hele ke mai koi: “‘Tememem, lememem toto ke hehei pe hana te heto heke em ke pengpeng toto. Pe pule lememem toto ke lem naunga ala urana ngana at. ");
INSERT INTO uvl_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","O tunge emem ngaunga nga lapa pe nge he pe ");
INSERT INTO uvl_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","O saua lemem poinga poreke ngana mur ke te lasus toto ke pomanga imem mo popoia lange hehei pe hana nga reria poinga poreke ngana mur nenge te popoia atat nge imem. Pe o helosio ia imem nga totoinga ero.’” ");
INSERT INTO uvl_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Iok, Iesus hele mule, “Teke elle nge imo langa neingana e na pele nga miliko tuna pe hele, ‘Neingak, e hanokia ngaunga unne e nge iong mukam ");
INSERT INTO uvl_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","iange neingak e nge at nga kileng tau ngana koi at ke lohot nge iau pe lek ute nge e heole i ia ero.’ ");
INSERT INTO uvl_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","“Pe i nenga pele letena tuacholia, ‘Ah! O hengo lala rara ia utar? Mopiu lo ke tutuk mur i imem hul ke moma nei. E lohaka ke e tunge ute nem lange iong ero ol.’” ");
INSERT INTO uvl_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Pe Iesus hele pule, “E hele lange imo pengpeng, non nem eteia ke i neingana ia pe i lemene ero toto nge lohaka ke tunge ngaunga nem lange i. Pe i lemene ero kou neingana neu nge pur mana ia onteinga lange i. Pomalam non nem lohaka ke tunge ure lochloch ngana nenge neingana nem lemene taua. ");
INSERT INTO uvl_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Ke e hele lange imo; nenge teke lememo taua ute nge NeHalang a ontei pe i tunge lange imo. Pe a tango rara ure pe lape a hottaua. Nenge teke o ischongia piunga te lohe piunga lange iong. ");
INSERT INTO uvl_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Ke nge iri lochloch ngana nenge te onteitei lape te menmene. Pe i nenge tango rarara hottautau pe i nenge ischongchong nga piunga te lohe piunga lala nge i. ");
INSERT INTO uvl_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“Nenge teke mele sune onteia temene nga ruo pe lape tunge ilimo has ngana lange i ma? ");
INSERT INTO uvl_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Nem pe tuna e onteia pareo tutuna lange i pe lape tunge ei nenge hunun ita lange i? ");
INSERT INTO uvl_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Ke imo hana mana nga ich nei a eteia ke a tunge ure urana ngana lala nge tutumo mur. Ke pomalam mana lape Temere nga lut nga tapa tunge Opepengpeng lange iri nenge te onteia i!” ");
INSERT INTO uvl_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Iok, nga etuene e Iesus helope hote uneinei e nge tu nge none pe poia i ke hele erochro. Kela uneinei neu lohot pe non nenge hele erochro neu hele mule sapele. Pe hulua lochloch te rura pe leteria tuanin rara. ");
INSERT INTO uvl_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Pe hel te hele, “Non nem lope hotote uneinei nemur nga Pelsipul ene. Uneinei mur aria soke.” ");
INSERT INTO uvl_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Pe hel te olleke Iesus ke te onteia i ke poi hote ute ke hot nga tapa ke pomalam te eteia i ke i NeHalang tuna. ");
INSERT INTO uvl_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Pe Iesus eteia leteria ke ulolo pe hele lange iri, “Kileng e nenge telas lele hel pe tepal hel mule nge iri lape tehet toto. Pe nenge teke none pe nehei pe tuturia mur telas lele hel lape tenau hel mule ero ol. ");
INSERT INTO uvl_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Pe nenge teke Non Poreke ngana nena hana mur telas lele hel pe tepal hel luluch mule nge iri lape tehet toto. E hele ke mai iange imo a teke e helope hote uneinei mur nga Pelsipul Non Poreke ngana ene. ");
INSERT INTO uvl_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Iok, nenge teke e helope hotote uneinei mur nga Pelsipul ene pe nga itei ene toto lemo hana mur te helope hotote uneinei mur? Ke imo anau, lemo hana mur te hemallaha hot pengpeng ia. ");
INSERT INTO uvl_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Pe nenge teke e helope hotote uneinei mur nga NeHalang nena kerkerenga, nem hemallaha hote ke NeHalang nena naualanga urana ngana at nge imo lo. ");
INSERT INTO uvl_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Nenge teke none nge kerkereng toto pe heronia palinga hel ana hengeron pe ra hite na io pe mes ke nauele na pele nena ure mur lape tetu ke nek. ");
INSERT INTO uvl_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Pe teke mele e nge kerkereng toto nge i at ke iri nai tepal hel pe hekou sue i lape mele nem haka hote palinga hel ana ure nemur nenge teke i non totoia pe heronge none nem nena ure mur lange mele hel. ");
INSERT INTO uvl_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Mele nenge halaua iau ero heporeke iau. ");
INSERT INTO uvl_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Iok, uneinei e lohot nge mele pe song ke la tango rara munna nge tuia. Song ke langa kileng hal ngana mur ke tango rara munna pe hottaua munna e ero. Pomalam hele, ‘Lape ela tau mule kou lek pele neu lo nenge etu tatala ia.’ ");
INSERT INTO uvl_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Iok laol, at mule pe teke nau pe pele neu te sachalue ke lemlem pe te poia ke nek toto. ");
INSERT INTO uvl_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Ol pe uneinei neu la mule ke la mene ke uneinei iri rahtele nai mule nenge te poreke toto nge i ke la tetu teu lamau. Ke mele neu tungana nenga tele ngana poreke pol mana pe nei ol poreke toto ol.” ");
INSERT INTO uvl_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Iesus nenene ure nemur ke pomau pe hei e alngana hot lange Iesus nga hulua leteria pe hele, “Hei e nenge hoe iong pe nauele iong lape mene iechinga.” ");
INSERT INTO uvl_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Pe Iesus tuacholia i ke teke, “Pa nem ero, iri nenge te longe NeHalang nena helenga pe te nanas tau tote iri laka nenge lape te mene iechinga nge palaungana toto.” ");
INSERT INTO uvl_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Hehei pe hana iri halang toto te emurung nge Iesus, ol pe Iesus hele, “Imo hehei pe hana nga etue nei, a poreke toto. A teke e poia ure palaungana e ke henonou hote lek hekerkerenga nenge at nge Non Palaungana. Pe lape e poia ure nem lange imo ero. Lape epoi hot mene ure palaungana nem nenge lohot nge Iona. ");
INSERT INTO uvl_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Ure palaungana nenge hehei pe hana nenge Niniue, ngana laka Iona. Pe ure palaungana nenge hehei pe hana nenga etue nei, ngana laka Non Tuna. ");
INSERT INTO uvl_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","“Etue palaungana nem lape at nenge NeHalang nau tote hehei pe hana lochloch reria poinga mur. Pe nga etue nem imo lape a meia imo. Iange nge nike hei soke nenge sio nem at nga kileng tau ngana ke longo nga Solomon na helenga urana ngana mur. Pe imo nei, none nge soke toto nge Solomon at nge imo lo pe imo a longo nge i ero. ");
INSERT INTO uvl_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Pe pule imo ul hana nenge Niniue lape ames haka nga etue nem pe lape a meia imo pule. Iange iri nenga etue neu Iona haliu hote NeHalang nena helenga mur pe te hulia reria poinga mur. Pe heueu nei none nge i soke toto nge Iona koi tu luluch nge imo.” ");
INSERT INTO uvl_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Mele pele tonge lemenge pe talue nga kileng unne nge talkome ero. Nem pe talkome teua nga kole palaungana letena ero. Lemenge nem te talkome ero. Te heon heke mene. Laka iri nenge te teu at te nau ke mallaha. ");
INSERT INTO uvl_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Matam i lemenge nenga singim. Teke matam te urana lochloch letem nge teu pe singim pule tualeme. Pe nenge teke matam te poreke letem nge teu pe singim pule tetu mana nga au. ");
INSERT INTO uvl_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Ke onau ke nek ol. Iange lape lemenge nga letem i chantom. ");
INSERT INTO uvl_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Ke ngana laka nenge teke singim lochloch tualeme pe unne nge chantom ero iong o tualeme lochloch sapelpele. Ke pomalaka nga lemenge palaungana nge tualeme hite iong.” ");
INSERT INTO uvl_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Iesus hele ke het pe non Paresio e hele lange Iesus ke la ngau luluch nge i. Iesus iteu nga ana non na pele pela kila sio sapele nga ngaunga munna nenge te ngaungau ia. ");
INSERT INTO uvl_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Iesus nun ero pe la ke are sio pe ngau mana. Ol pe non Paresio neu neue nge manga Iesus lome penna ero pe rura toto nga Iesus poi ngana neu. ");
INSERT INTO uvl_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Pe Iesus hele lange i, “Imo Paresio nemur, a lomo menmene amo eulinga pe amo pan mur singiria nenge hot pe nga letemo nge teu a muta toto ia poinga nenge kemenge pe sachumchum pe poinga poreke ngana hel pule. ");
INSERT INTO uvl_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Imo amo hauaua! I nenge umeia singira nge hot mai umeia leteria ero kai? ");
INSERT INTO uvl_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Pomalam a mene ngaunga pe ech nenge mateu nga pan pe eulinga nemur pe a tunge lange iri nenge aria ngaunga ero. Nenge apoi ke pomai pe ure lochloch ngana lape lemlem nge imo ol. ");
INSERT INTO uvl_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Imo Paresio nemur a neknek ia! Ure poreke ngana lape lohot nge imo iange imo a nanas tau mene hotonga kinkino ngana mur. Pe hotonga papalauna a nanas taua iri ero toto. A takiraua ngaunga kinkino ngana nge manga loi tana pe ngaunga ehech ngana ke huna iri analoch pe a tunge huna elle lange NeHalang. Pe hotonga nenge apoi ke nek lange pekngamo mur, a nanas taua ero toto. Pe hotonga nenge lememo tau tote NeHalang a nanas taua ero toto pule. Teke a nanas tau tote hotonga kinkino ngana nemur pomere nenge a nanas taua hotonga papalauna ke nek ero? ");
INSERT INTO uvl_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Imo Paresio mur a neknek ia imo! Iange lememo tau totote arenga nemur nga muka toto nga hetoronga ana pele. Pe lememo ke te hele ke urana toto lala nge imo nga ingala munna mur. ");
INSERT INTO uvl_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","“A neknek pule iange imo a pomalaka nga mele koluna nge tealo hite pe tetua ele ero. Pe hana nenge tei haka nga ona lape te poreke sapele iange te eteia ero.” ");
INSERT INTO uvl_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Ol pe none nge etei toto nga hotonga tuacholia Iesus, “Non Soke, o hele ke mam pe o hele poreke imem pule iam.” ");
INSERT INTO uvl_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Pe Iesus hele, “Imo nenge a etei toto nga hotonga mur a neknek ia pule iange imo a poia hana ke te takisia ure meena toto ngana nenge te alker taua. Pe imo sipomo a tunge perimo kukana elle ke a halaua iri ero toto. ");
INSERT INTO uvl_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","“A neknek ia pule iange a hemalmal heke hetatalonga mur aria metenga munna nenge lemo tete mur te hune iri nge nike. ");
INSERT INTO uvl_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Ke nga poinga nei imo sipomo a henonou hot pengpeng ia utar nenge lemo tete mur te poia. Iri te hune hetatalonga mur pe imo a hemalmalia aria polo. ");
INSERT INTO uvl_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","NeHalang eteia ke ulolo ke ngana laka nenge hele ke teke, ‘Lape e kulosia hetatalonga mur pe hekulkulonga mur. Pe hel nge hana nemur lape te hune iri pe hel lape tepoi poreke iri.’ ");
INSERT INTO uvl_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Ke pomalam tuangachol poreke ngana nga huninga nemur lochloch lape sio pengpeng nge hana nenga etue nei. ");
INSERT INTO uvl_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Talun ngana nga huninga nenge Apel ke langa huninga nenge Sakarias. (Sakarias te hune i nga hatanga pe NeHalang munna nenge heo ngana toto tunangaria). E hele pengpeng lange imo nenga etue nei lape a mene melmelenga palaungana nga ure nemur lochloch. ");
INSERT INTO uvl_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Imo nenge a etei toto nga hotonga mur a neknek ia pule iange hehei pe hana muteria toto ke te eteia NeHalang pe imo a unele lohenga nge hehei pe hana ke teteu langa eteinga nem ero. Pe imo ateu langa eteinga nenge NeHalang ero pule.” ");
INSERT INTO uvl_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Iesus lohaka ke ii lo pe Paresio mur pe hotonga ana hetoronga mur te hele poreke tote i pe te tutue i nga helenga pe te onteiteia i. ");
INSERT INTO uvl_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Tepoi ke pomau iange te teke te ollaka hotote Iesus. Pe nenge teke Iesus tamal hote helenga e nge poreke lape te hele hot sapele i. ");
INSERT INTO uvl_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Iok laol, hulua halang toto teat ol nenge te heit ulu hel iange kileng muta toto. Pe Iesus talun ke hele tala lange nena hana nemur nenge hetotore iri ke teke, “Anau ala amo ke nek toto nga poinga nenge Paresio mur te popoia iange iri hana nenge te heleia ute nem pe te poia ure e nge altoto! ");
INSERT INTO uvl_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Ure lochloch ngana nenge a talkomkome NeHalang lape hemallaha hote. Oe, ure lochloch ngana nenge a talkomkome NeHalang lape poi hote ke mallaha. ");
INSERT INTO uvl_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Utar nenge a hele komkome nga miliko NeHalang lape hemallaha hote nga sinanga. Pe utar nenge a mangun tele helel ia nga lemo pele letena lape temes hot ia nga aeteme pe te haliu hote lange hulua mur. ");
INSERT INTO uvl_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“E hele lange titik mur imo, a mataua iri nenge te hune singimo mana ero. Iange nga hoena ol lape te poia ute pele lange imo ero ol. ");
INSERT INTO uvl_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Iok, lape e henonoua mele nenge a mataua. A mataua laka i nenge nena kerkerenga palaungana nge hune ita ke het pe sau sue ita langa melmelenga ana kileng. Oe, e hele lange imo, a mataua laka i lo! ");
INSERT INTO uvl_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Ngie simsim iri lime te olia iri nga umtutuna nai mana (2 toea). Pe NeHalang letene metene iri lochloch pe hile hote e nge iri ero. ");
INSERT INTO uvl_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Pomalam mana palpalumo ina mur te sisala lochloche iri ke ulolo. A matau ero iange nga NeHalang matana NeHalang lemene tau tote ita nga ngie simsim mur. ");
INSERT INTO uvl_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Ke e hele lange imo pengpeng urana toto nge mele nenge mes haka pe haliu hote iau ke teke, ‘Iesus i Non Tuna. Pe Iau letek manmanna nge i.’ Nge mele nem Iau lape e haliu hote i lange NeHalang nena angkelo mur ke e teke, ‘Non nei, iau lek non ia.’ ");
INSERT INTO uvl_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Pe poreke toto nge mele nenge mes haka nga hulua mataria pe hele ke teke, ‘Iau letek manmanna nge Non Tuna ero.’ Iange iau pule lape e hele lange NeHalang nena angkelo mur ke e teke, ‘Iau e eteia non nei ero i.’ ");
INSERT INTO uvl_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Pe iri nenge te hele poreke Non Tuna lape NeHalang letena poreke mule ia iri. Pe iri nenge te hele poreke Opepengpeng, NeHalang lape letena porekeia iri ero toto. ");
INSERT INTO uvl_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Teke te laua iong pe te mene iong langa hetoronga ana pele ke te onteia iong, omes nga hana papalauna nemur mataria pe sam loiloi ero. Pe pule letem tuanin rara nga utar nenge lape o hele ia ero. ");
INSERT INTO uvl_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Iange nga etue nem pengpeng lape Opepengpeng hetore iong nga utar nenge urana nge o heleia.” ");
INSERT INTO uvl_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Pe none nga hulua leteria hele lange Iesus, “Non Soke o hele lange tik ke tunge ure nemur nenge temek mete hatalia unne at nge iau.” ");
INSERT INTO uvl_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Pe Iesus hele lange i, “Ia, itei nenge talue iau ke e poia ume nemam? Iau ak ume nem ero iam.” ");
INSERT INTO uvl_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Iok laol, Iesus hele lange iri, “Anau ala ke nek toto nga poinga nenge taeu lochloche ure pe ta teke ita toro mana rera. Iange mele nenge na ure halang nem, ure lochloch ngana nem tunge maulinga nge koko lange i ero.” ");
INSERT INTO uvl_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Ol pe Iesus heleia helenga opene e lange iri pe hele, “Non e nge na ure halang neu ana ume mur nganangaria ke halang toto. ");
INSERT INTO uvl_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Pe letena tuanin nge i sipona ol, ‘Lape epoi ke mere mai ol? Ure lochloch ngana nei muria ero ol i! Lape e tatach teua iri langai mai?’ ");
INSERT INTO uvl_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","“Ol pe ana non lohaka pe hele, ‘Eh! lape epoi ke mai i! Lape etoto sue pele nemur pe e lele mule hel nge papalauna toto. Ke lape e tatach teua ak ume nganngana mur pe lek ure mur. ");
INSERT INTO uvl_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Pe lape letek tuanin ke e teke: Lek ure halang pamlo nge lape tu ke hesinga halang toto. Lape e tutu manmanna ol. Pe lape eare ke e ngau haka manmana ol pe pule lape e inin pe e iech manmana ol!’ ");
INSERT INTO uvl_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","“Ol pe NeHalang hele lange i, ‘Iong nge am hauaua toto iam! Heueu nga miliko nei lape o mete. Pe ure lochloch ngana nenge o talue nem lape itei mene iri?’ ");
INSERT INTO uvl_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","“Ke i pomalam mana. Mele nenge heu kinia ure mur ke teke i toro nena, lape nena ute e ero toto nga NeHalang matana.” ");
INSERT INTO uvl_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Iok, Iesus hele lange nena hana mur nenge hetotore iri, “Ke pomalam e hele lange imo, letemo una sakilil nga atu ngamo nga ich nei ero. Letemo tuanin rara sakilil ero nga utar nenge lape a ngaua pe nga singimo pe nga utar nenge lape a mele. ");
INSERT INTO uvl_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","A maul ngamo, i palaungana toto nga ngaunga pe singimo, i palaungana toto nga ure nenge ta heronronia iri. ");
INSERT INTO uvl_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Anau langa ngie mur. Tetua aria ngaunga ero. Pe te lulu aria ero. Pe te lele pele ke te tatach teu aria ngaunga ia ero. Pe NeHalang i sipona hengaua iri. Pe imo nge a ele haka toto nge ngie mur laka! ");
INSERT INTO uvl_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Amo tei nge imo nge letemo una sakilil? Pomere? Letemo nem poia imo ke heloloune atu ngamo nga ich nei ke sase pol? ");
INSERT INTO uvl_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Nenge teke nakumo ero nge a poia ure sune nei, pomere nenge letemo una sakilil nga ure lochloch? ");
INSERT INTO uvl_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Anau langa ae nemur te haka ngaria. Tehei pe roraria te palola hot ke nakuria urana toto. Pe e hele lange imo pengpeng Ne Solomon nge nike nena ure urana ngana mur halang. Pe i heronia ure urana ngana pele nge urana toto ke pomanga ae rorana nemur ero. ");
INSERT INTO uvl_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Letemo metene ke nek NeHalang hemele heilil mur nenge tetu ke te maulul heueu nei pe nge rou te parsue pe tesau heke iri nga oan. NeHalang tunge malenga urana ngana langa ure nemur nenge tetu ke choro mana. Pe imo lape NeHalang tunge malenga lange imo pule? Imo nge letemo manmanna ngana unne sune mana iam! ");
INSERT INTO uvl_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Letemo una sakilil ero nga utar nenge lape a ngaua pe utar nenge lape a inia. Pe letemo meena ia ero. ");
INSERT INTO uvl_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Nenge letemo una sakilil nga ure nemur, apoi ke mange hulua nemur nenge te etia Tememo NeHalang ero toto. Leteria tu hit mene reria ure mur. Pe imo ero. Tememo nga lut eteia ke imo lememo taua ure nemur ke a mene pule la. ");
INSERT INTO uvl_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Urana ngana a tango rara tele ure nenge opemo ana ngaunga pe NeHalang nena naualanga urana ngana. Pomalam lape tunge ure nenge lememo tau tote lange imo pule. ");
INSERT INTO uvl_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Imo sipsip tutuna mur a matau ero iange Tememo iech toto nge mene imo ke atu teu nga nena naualanga nge urana toto. ");
INSERT INTO uvl_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","A laia lemo ure mur nga ingaala ke te olia iri pe a tunge umtutuna lange iri nemur nenge reria ero. Ol pe imo a mene laka lemo umtutuna ana mateunga e nge poreke erochro. Pe ure nem nganangana mur laka ure urana ngana mur nenga lut nga tapa nenge tetu ke koko. A tango rere ure nemur ke a mene iri pule. Ure nemur kemenge ana hana mur tekeme ia ero toto pe kankan ngau ule ero pule. ");
INSERT INTO uvl_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Ke imo lape letemo tuit menmene laka kileng nemur ol nenge a talue lemo ure urana ngana mur ia. ");
INSERT INTO uvl_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“A kale masia amo tal pe a tonge lemo lemenge ke remenmen pe anau alala nga utar nenge lape lohot. ");
INSERT INTO uvl_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Pe apoi ke pomanga hana hel nge te kulkulelele aria soke nge mule nga leinga heueu ngana e ana ngaunga matana. Pe teke non soke nem at ke ischong nga piunga te lohe piunga ke ueiuei mana lange i. ");
INSERT INTO uvl_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Ke iri nenge aria soke at pe hottaua iri nge te mesmese kura, iri nemur lape te iech toto. E hele lange imo pengpeng non soke nem lape nek hit tote imo pe lape hetakile imo pe hengaua imo. ");
INSERT INTO uvl_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Pe nenge teke Non Soke nem at nga miliko tuna ma nga uachuach pe hana nemur tenau alala kura, iri lape te iech toto. ");
INSERT INTO uvl_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Pe letemo metene nei ke nek; Nenge teke pele tokoninga eteia etue nenge kemenge ana hana mur te atat ia i lape nauala ke nek toto ke kemenge kina nemur te palchach teua nena pele ero. ");
INSERT INTO uvl_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Imo pule a nauala ke nek toto iange Non Tuna lape at mule nga etue nenge imo a teke i atia ero.” ");
INSERT INTO uvl_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Pe Petrus ontei, “Non Soke, iong mai o heleia helenga opene nei atat nge imem mana kai? Eh? Nge hana lochloch?” ");
INSERT INTO uvl_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Pe Iesus tuacholia, “Itei nge imo hana nenge a umume nge letena song ke urana pe poia ume ke nek? I laka nenge ana non soke letena here nge nauele pele pe tunge nena hekuleileinga mur aria ngaunga nga ngaunga ana etue pengpeng. ");
INSERT INTO uvl_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Mele nem lape iech toto nenge teke ana soke at pe hottaua i nge popoia ana ume. ");
INSERT INTO uvl_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","E hele ke manmanna toto lange imo mele nem lape non soke talue i ke nauele nena ure mur lochloch. ");
INSERT INTO uvl_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Pe lape mele nem letena tuaninin nge i sipona ke teke, ‘Ah! Ak non Soke nem lape at ke ueiuei ero iam.’ Ol pe talun ke nos lapue hehei pe hana nenge te umume. Pe pule popoi ngaunga matana pe inin ech kerkereng ngana pe poi rara hulu. ");
INSERT INTO uvl_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Pe ana soke lape at mule nga etue nenge ana non eteia ero ke kulele i ero. Non soke nem at pe lape chatulu hite pe lope hote i kela tu luluch nge hana nenge te longo tau erochro. ");
INSERT INTO uvl_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Iok, nenge teke none nenge umume pe eteia non soke nem lemene ngana pe na melei tana toto nge nanas taua non soke neu lemene ngana, lape tenos ulu hit tote i. ");
INSERT INTO uvl_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Pe mele nenge eteia non soke neu lemene ngana ero pe poia poinga nenge lape te nosia i ia lape ana nosinga meena ero. Iri nenge NeHalang tunge aria ume halang pe letena here iri nge te poia ke nek, lape NeHalang angala mana nge esia aria ume ngangana mur nge lohot ke halang toto. Pe iri nenge NeHalang tung ke aria ume halang nge halang toto lange iri pe letena here iri nge te poia aria ume ke nek, lape NeHalang angala mana nge esia aria ume nganangana mur nge lohot ke halang nge halang toto.” ");
INSERT INTO uvl_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Esio at ngak nei. E atia oan ke etun hite nga ich. Pe lemek toto ke oan nem ngaulala haka ke ueiuei. ");
INSERT INTO uvl_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Iau lape e mene henuninga e kura ke heueu nei letek meena toto ia kura. Pe letek meena ngana nem lape tu ke la het nga etue nenge e mene henuninga nem. ");
INSERT INTO uvl_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Imo mam a teke eat ke epoi hote tunga nge urana nga ich kai? Ero toto! E hele pengpeng lange imo eat ke e lasia. ");
INSERT INTO uvl_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Talun heueu nei ke la ol nga pele elle none pe nehei pe tuturia mur telas hel. Mol lape iri altoto nga nai pe nai lape iri altoto nga mol. ");
INSERT INTO uvl_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Lape telas hel ke non neu i altoto nge tuna tamane ngana pe tuna tamane ngana i altoto nge temene. Pe hei neu i altoto nge tuna hei ngana pe tuna hei ngana i altoto nge tana. Non neu lape i altoto nge uene pe uene i altoto nge i.” ");
INSERT INTO uvl_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Iesus hele lange hulua nemur, “Nenge teke a naue ulu nge ma hot nga tapa huna pe a hele sapele ke a teke, ‘Lape pitte mol heueu.’ Pe la pitte nem mol. ");
INSERT INTO uvl_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Pe teke a amneia tutula nge song ke ramana haka at nge sio pe a hele ke a teke, ‘Lape kileng milang toto heueu.’ Pe la kileng milang. ");
INSERT INTO uvl_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Imo apoi ke manga mamulou! Nenge teke a esia ute nge lohot nga ich nei pe nga tapa sana neu pe a etei pengpeng ia ure nem luna. Pe pomere toto nenge a esia ure mur nenge te lohot nga etue nei pe a eteia luna ero? ");
INSERT INTO uvl_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Pomere nenge imo sipomo a amnei urume poinga nenge poreke pe nga poinga nenge urana ero? ");
INSERT INTO uvl_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Nenge teke none hele ote iong nga ute pe mene iong ke a hepengia, iong opur kikim ke imo nai a hepeng olole nga kue nike. Teke ero lape non nem mene iong ke laia iong nge hana nenge te longlongo pe te amnei teu langa helenga mur. Pe hana nemur lape te tunge iong langa palpal hussu mur peria pe palpal hussu mur lape te tamal teua iong langa tuele au ngana. ");
INSERT INTO uvl_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Pe e hele pengpeng lange iong lape o lohot nga lamam ero toto ke la het nga etue nenge o tuachol taua lem hangonok mur.” ");
INSERT INTO uvl_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Iok, nga etue nem hana hel te hele lange Iesus ke teke, “Mele hel nge Kalelea te makmak pulumakau ke te heto hekeke NeHalang pe Pilatus nena hana mur te hune iri. Te hune iri pe eiria maluluch nga pulumakau nemur eiria.” ");
INSERT INTO uvl_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Pe Iesus tuacholia iri ke pomai, “Iri mam, te hune iri ia? Te poreke toto nge hana lochloch ngana nenge Kalelea ma? ");
INSERT INTO uvl_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Ero! Pe e hele pengpeng lange imo nenge teke a hulia lemo poinga poreke ngana mur ero lape a mete ke pomange iri. ");
INSERT INTO uvl_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Iok, anau lange hana analoch pe rahtele mol nenge Siloam. Hana nemur, pele sase ngana e losio haka nge iri ke te mete. Iri mau te poreke toto nge hana lochloch ngana nenge Ierusalem kau? ");
INSERT INTO uvl_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Ero! Pe e hele pengpeng lange imo, nenge teke a hulia lemo poinga poreke ngana mur ero lape a mete ke pomange iri.” ");
INSERT INTO uvl_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Iesus heleia helenga opene nei, “None ana popi tana e mes nga ana ume letena. Ana non i langa ae nem ke teke nau rara nganangana. Pe ae nem nganangana ero. ");
INSERT INTO uvl_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Ol pe hele lange non nenge umume nga ana ume. ‘Ae nei nganangana ero ke hesinga iri mol lo i! O telesue ol! Iange hesil mene ich i.’ ");
INSERT INTO uvl_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Ol pe non nenge umume neu hele, ‘Non soke, ae nem tu mukam ke hesinga elle mule. Pe esel hote ich nga huna pe etal teua ana ngaunga. ");
INSERT INTO uvl_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Pe teke nganangana mule nga hesinga nem, urana. Pe teke ero e telesue ol.’” ");
INSERT INTO uvl_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Nga Sapat ana etue Iesus hetottoro nga hetoronga ana pele. ");
INSERT INTO uvl_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Pe hei e nge uneinei poia i ke kina chachau tu lamau pule. Haleles neu tu nge i ke hesinga iri analoch pe rahtele mol. Pe mes haka ke pengpeng ero. ");
INSERT INTO uvl_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Iesus esia i pe iu lange i pe hele, “Hei nem, am haleles nem het ol.” ");
INSERT INTO uvl_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","La ol pe Iesus tal heke penna nge ana hei pe ueiuei mana mes haka ke pengpeng mule. Ol pe talun ke heto heke sapele NeHalang. ");
INSERT INTO uvl_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Pe non soke nenga hetoronga ana pele neu letena inin iange Iesus hemasmas nga Sapat ana etue. Ol pe hele lange hehei pe hana, “Etue iri rahtele elle ta umume ia ara ume mur. Pomalam aat nga etue nemur ke te hemasia imo. Pe nga Sapat ana etue ero.” ");
INSERT INTO uvl_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Ol pe Iesus tuacholia, “Imo mamulou mur! Nenge teke lemo pulumakau e ma tongki e mete ana ech nga Sapat ana etue, lape a einia ero ma? Imo lochloch lape a einia la! ");
INSERT INTO uvl_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Pe hei nei i Apraham tuna ia. Pe Non Poreke Ngana rahit tote i ke hesinga iri analoch pe rahtele mol (18). Ke ute pele nge poreke ero nge e hemas mule i nga Sapat ana etue.” ");
INSERT INTO uvl_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Iesus hele ke mau ol pe iri lochloch ngana nenge te hele poreke i temei tote iri. Pe iri hulua lochloch te iech toto nga ure lochloch ngana nenge Iesus poia ke urana. ");
INSERT INTO uvl_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Iok Iesus hele, “Lape e hele urume NeHalang nena naualanga pe nekinga ke mere? Pe lape e hele urume langa utar? ");
INSERT INTO uvl_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","I pomalaka nga ae tutuna nenge kinkino toto nenge none tue nga ana ume. Iok, ae nem haka ol pe tana palaungana toto. Pe ngie mur te talue reria kiniu nga perperna mur.” ");
INSERT INTO uvl_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Pe Iesus ontei mule, “Lape e hele urume NeHalang nena naualanga pe nekinga ke mere? ");
INSERT INTO uvl_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","I pomalaka nga is unne sune nenge tepoi teu luluche nga beret nge halang toto pe te hulia nga tuninga e nge palaungana toto. Pe is nem poia beret itach ngana ke una haka ke palaungana toto.” ");
INSERT INTO uvl_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Ol pe Iesus i ke lala nga kileng mur pe hetoro olole ke ramana lala nge Ierusalem. ");
INSERT INTO uvl_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Pe mele onteia i, “Non soke, iri nenge NeHalang lape mene mule iri lape iri unne sune mana kai?” Pe Iesus hele lange iri, ");
INSERT INTO uvl_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Apur kikimo toto ke a teu langa piunga matana hoholoch ngana sune nem. Iange hulua halang lape te teke teteu la toto. Pe e hele lange imo pengpeng hulua lape teteu la ero. ");
INSERT INTO uvl_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Nenge teke pele tokoninga piu hele piunga nem lo imo lape ames mana nge hot ol. A ischong teueu pe a tangtang ke a teke, ‘Kole, o lohe piunga nge imem!’ “Pe i lape tuacholia ke teke, ‘E eteia imo ero pe e eteia aat ngamo ero pule iam!’ ");
INSERT INTO uvl_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","“Pe imo lape a teke, ‘Imem laka nenge mo ngau pe moin luluch nge iong. Pe iong laka nge o hetottoro nga lemem kileng ana kue mur.’ ");
INSERT INTO uvl_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","“Pe lape tuacholia iri ke teke, ‘E eteia imo ero pe e eteia aat ngamo ero pule! A ua toto lamam. Imo nenge a popoi poinga poreke toto ngana laka. Lemek ero toto imo!’ ");
INSERT INTO uvl_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","“Imo lape atu manmana nge hot pe a tangtang pe ngingimo chatrekreke pe a amneia melmelenga palaungana. Lape a esia Apraham pe Isak pe Iakop pe hetatalonga nemur nge tetu teu nga NeHalang nena naualanga pe nekinga. Pe imo sipomo lape a lasus toto. ");
INSERT INTO uvl_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Hulua halang lape teat nga chaia aka ngana pe chaia sio ngana pe nga kileng rumena pe nga kileng sana. Ke lape teare teu nga ngaunga matana palaungana nem nga NeHalang nena naualanga urana toto ngana. ");
INSERT INTO uvl_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Pe manmanna toto ke iri nenge iri hoena lape iri muka pe iri nenga muka lape iri hoena mule.” ");
INSERT INTO uvl_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Iok nga etue neu Paresio mur hel teat nge Iesus pe te hele lange i ke teke, “O ua nga kileng nei ke ola nga kileng unne. Iange non soke Herot teke hunune iong.” ");
INSERT INTO uvl_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Pe Iesus tuacholia iri, “Ala ke a hele lange non pallaklakanga kina nem, ‘Iau lape e helope hote uneinei mur pe e hemas mule hehei pe hana heueu pe nge rou pe nga etue mol ngana lape e heulo hote ak ume mur.’ ");
INSERT INTO uvl_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Pe ute nenge palaungana heueu nei mai ngana laka nenge e teke ela toto nge Ierusalem. Ke iau lape ei heueu pe nge rou pe nge pong nai ke ela toto. Iange manmanna toto ke hetatalonga e tehun sio mene nga kileng unne ero. Tehun pengpeng ia nge Ierusalem. ");
INSERT INTO uvl_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“Ochou! Imo hana nenge Ierusalem! Imo ahun lapue hetatalonga mur pe a tamal hune hana nenge NeHalang kulosia iri ke teat nge imo. Kokoes e teke e eukiraua imo ke pomanga pareo heingana nenge eu teua tutuna mur nga sahana ene. Pe imo lememo ero nge e eukiraua imo. ");
INSERT INTO uvl_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Ke lape NeHalang nau langa lemo pele ero toto. Pe e hele pengpeng lange imo, lape anau mule iau ero ol kela het nga etue nenge lape a hele ke a teke, ‘Petenga nge palaungana toto lange i nenge at nga Non Soke ene.’” ");
INSERT INTO uvl_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Nga Sapat ana etue Iesus lake ngau nga Paresio mur aria soke nena pele. Pe hehei pe hana nga lamau tenau ala tote i. ");
INSERT INTO uvl_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Pe none nge ana haleles nenge singina hakokoia mes nga Iesus matana. ");
INSERT INTO uvl_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Ol pe Iesus onteia Paresio mur pe hana nenge te etei nga hotonga mur ke teke, “Ita mai ra hotonga e nge hele ke teke ta hemasmas nga Sapat ana etue pule? Ma ero?” ");
INSERT INTO uvl_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Pe Paresio nemur te reng mana. Iok laol, Iesus rahite non neu pe hemasia i sapele. Hemasia i ke het pe kulosia i ke la sapele. ");
INSERT INTO uvl_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Iok, Iesus hele lange iri pe onteia iri, “Nenge teke tumo e ma lemo pulumakau e losio teu nga ech ana polo nga Sapat ana etue lape a poia ke mere? Lape atak hote i ke ueiuei mana ma ero?” ");
INSERT INTO uvl_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Pe iri te reng mana iange nakuria ero nge te tuachol ia Iesus. ");
INSERT INTO uvl_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Iesus tu nga non soke neu na pele kura pe esia hana hel nenge ana non soke iua iri pule. Pe hana nemur tela ke te mene muria nge uranrana nga ngaunga ana manga. Ol pe Iesus heleia helenga opene nei. ");
INSERT INTO uvl_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Nenge teke none hekulo am ke oat nga ngaunga matana nenga leinga heueu ngana, o mene mullim e nge urana toto ero. Iange lape mele nge i soke toto nge iong lape te hekulo ana ke at pule. ");
INSERT INTO uvl_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Ke pomlam lape non nenge hekulo amo nem lape at pe hele lange iong ke pomai, ‘O ua nga non nei munna!’ Nga poinga nei lape non neu hemeia iong pe talsio tote iong ke lape ola mule nga hoena toto. ");
INSERT INTO uvl_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Ke nenge teke te hekulo am ke oat nga ngaunga matana nem o mene mullim e nga hoena toto nike. Pomalam lape non nenge hekulo am nem lape at pe hele lange iong ke teke, ‘Neingak, ola ke o kila nga muka toto.’ Nga poinga nei lape pekngam mur nenge imo ul atu nem te heto heke tote iong. ");
INSERT INTO uvl_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Iri nenge tetal heke mule iri siporia, lape Non Soke tal sio tote iri. Pe iri nenge tetal sue iri siporia mule lape Non Soke tal haka tote iri.” ");
INSERT INTO uvl_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","14","Iok Iesus hele mule lange tokoninga nenga ngaunga matana neu ke teke, “Nenge teke o poia ngaunga matana, o iua hana nenge reria ure halang ero. O iua laka iri nenge tetu poreke toto pe haleles poia iri ke singiria ele mete pe mataria hit. Pomalam lape Non Palaungana pete iong toto. Iange iri te tuacholia lange iong ero. Non Palaungana i sipona lape tuacholia lange iong nga etue nenge hana uranrana ngana mur te lohaka mule nga metenga. Pe nenge teke o iua pekngam mur pe titim mur pe alom mur pe lem kileng ngana mur nenge reria umtutuna halang lape iri siporia te tuachol mule lange iong ke o mene urum nge Non Palaungana ero ol.” ");
INSERT INTO uvl_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Non elle nge iri hana nenge te ngaungau neu, longe Iesus nena helenga pe hele lange Iesus, “NeHalang lape poia ngaunga matana palaungana nga nena naualanga pe nekinga urana ngana. Pe iri nenge teat ke te ngau nga ngaunga matana palaungana nem lape te iech toto.” ");
INSERT INTO uvl_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Pe Iesus tuacholia, “Non e teke poia ngaunga matana palaungana e. Ol pe hekulo helenga lange hulua halang ke teat nga ngaunga matana nem. ");
INSERT INTO uvl_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Nga ngaunga nem ana etue pengpeng non soke neu kulosia nena non nenge umume nge i ke song taua hana nenge te hekulo aria. Pe hele lange iri ke teke, ‘Aiat ol! Ngaunga kalum lo.’ ");
INSERT INTO uvl_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","“Pe iri lochloch ngana te hele ke teke tetu mule iange te teke tetu ke te poia aria ume hel pule. Elle nge iri lohaka pe hele, ‘Iau eol hote ich unne lo koi ke ela ke enau tote mukam.’ ");
INSERT INTO uvl_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","“Pe elle pule hele, ‘Iau heueu mana nei eol ke pulumakau iri analoch. Pomalam ela ke e totoi tote iri mukam.’ ");
INSERT INTO uvl_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","“Pe elle pule hele, ‘Iau elei heueu mana koi ke lape ela ero.’ ");
INSERT INTO uvl_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“La ol pe non neu i ke la mule pe la hele lange ana non soke. Ol pe pele tokoninga nem letena inin toto pe hele mule lange non nenge umume nge i ke teke, ‘O song ke ueiuei mana ke ola nga kue tana mur pe kue kinkino ngana lochloch pe o hele lange hana nenge tetu poreke toto pe haleles poia iri ke singiria ele mete pe mataria hit. O hele nge iri ke teat lochloch.’ ");
INSERT INTO uvl_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","“Iok laol, non nem la pe at mule pe hele lange ana non soke ke teke, ‘Ure nenge o heleia at nge iau e poia ke het lo. Pe pele neu muta ero kura.’ ");
INSERT INTO uvl_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","“Ol pe non soke neu hele la mule nge nena non neu, ‘O song hot ke ola nga kileng kinkino ngana nemur nga tau pe o ngai heke iri ke teat lochloch ke te hemute lek pele. ");
INSERT INTO uvl_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","E hele lange iong, none nge iri nenge e hekulo tala aria lape at ke ngau hote ngaunga unne nga lek ngaunga matana nei ero toto.’” ");
INSERT INTO uvl_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Hulua halang te koko nge Iesus pe Iesus naula mule nge iri pe hele, ");
INSERT INTO uvl_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Mele nenge teke nanasia iau hile tote temene pe tana pe nehei pe tutuna mur pe titina mur pe liliuna mur. Pe pule hile tote i sipona. Laka nanasia iau ol. ");
INSERT INTO uvl_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Mele nenge takiskis ia melmelenga luluch nge iau ero, iau lek non toto laka i ero. ");
INSERT INTO uvl_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Nenge teke none hemesia pele palaungana e, kila ke nek pe ume hote pele nem uruna pe eteia ke umtutuna purpur tote pele nem. ");
INSERT INTO uvl_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Pe nenge teke poia ero lape hemes heke pele nem haena pe aluana tu. Pe iri nenge te esia te songlele ia i pe te hele, ");
INSERT INTO uvl_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","‘Non panei hemes heke pele pe heule ero mana.’ ");
INSERT INTO uvl_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Non soke e nga kileng e teke pal luluch nge non soke e pule nga kileng e. E nena palinga hel ana hana mur iri halang toto pe e unne sune mana. Pe nenge nena hana iri unne sune mana nem, kila pe letena matana ke nek toto. Pe letena tuanin ke mai, ‘Lape ta hekou sue iri ma ero? Iri halang sakilil i!’ ");
INSERT INTO uvl_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","“Non soke nem letena tuanin ke mau pe eteia nge nakuna ero nge iri ul ke te palhel. Pomalam lape poi ke pomai; Hana nenge iri halang tetu ke sase kura pe i nenge na hana unne sune mana nem kulosia hana hel ke la te hele toto mule ke te teke palinga hel nem lasus ol.” ");
INSERT INTO uvl_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Ol pe Iesus hemallaha hote helenga opene nemur ke pomai, “Pomalam letem hile ure lochloch pe o nanas mene iau ol. ");
INSERT INTO uvl_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Mesmes i urana pe nenge teke mesmes ngana het opoi mule ke mesmes ero ol. ");
INSERT INTO uvl_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Ke nenge teke pomam i poreke lo. Pe o takiraua ke ich ana ngaunga ia ero pule. O saua ke lasus sapele. Apal talngamo pe a long ke neknek!” ");
INSERT INTO uvl_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Nga etuene e hana nenge te loloch umtutuna pe hana porekreke ngana mur te emurung ke te teke te longo Iesus nge helele. ");
INSERT INTO uvl_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Pe Paresio mur iri ul hotonga ana hetoronga mur te ngunngunu ia Iesus ke te teke, “Non pane lemene taua hana porekreke ngana mur pe ngau luluch manmana nge iri.” ");
INSERT INTO uvl_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Ol pe Iesus hele ia helenga opene nei lange iri. ");
INSERT INTO uvl_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Nenge teke elle nge imo nena sipsip iri ana non kina iri lime (100) pe elle erue lape poia ke mere? I lape hile sue sipsip nemur nenge te erue ero. Nenge iri ana non kina iri henel pe analoch pe rahtele henel (99). Hile sue sipsip lochloch ngana nemur pe la ke tango rere elle nem nenge erue. ");
INSERT INTO uvl_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Pe nenge teke hottaua lape iech toto pe takisia ");
INSERT INTO uvl_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","ke la mule ia. Ol pe la hele lange pekngana mur ke teke aiat ke a iech luluch nge iau. Iange e hottaua lek sipsip nenge erue lo. ");
INSERT INTO uvl_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Pomalam mana e hele lange imo, lape iechinga palaungana lohot nga lut nga tapa nge mele elle nge hul mule letena nga nena poinga poreke ngana mur. Iechinga nem palaungana toto nga nenge iri ana non kina riri henel pe analoch pe rahtele henel nem (99) iange te teke te urana nga NeHalang matana lo. Ke tehul mule leteria nga reria poinga poreke ngana ero. ");
INSERT INTO uvl_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Pe helenga e pule nga hei e nge nena umtutuna iri analoch. Pe nena umtutuna elle erue. (umtutuna nemur te ume nga siliua ke uruna aka) Ol pe lape poi ke mere ol? I lape tonge lemenge pe sachalue nena pele letena pe puria ana tangonga ol. ");
INSERT INTO uvl_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Pe teke hottaua lape lake hele nge pekngana mur pe na kileng ngana mur ke te emurung pe hele lange iri ke teke, ‘A iech luluch nge iau ol. Iange e hottau mule lek umtutuna lo.’” ");
INSERT INTO uvl_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Pe Iesus hele pule ke teke, “Pomalam mana iechinga palaungana toto lohot nge NeHalang nena angkelo mur nge mele elle nenge hul mule letena nga nena poinga poreke ngana mur.” ");
INSERT INTO uvl_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Iok, Iesus hesapele helenga ke teke, “None tuna iri nai. ");
INSERT INTO uvl_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Pe tuna nenge kino hele lange temene ke teke, ‘Temek, o tunge lek ure mur atat nge iau nike. Ure nemur nenge lape o mete pe mo mene nge iong.’ Ol pe temene herongo sapele nena ure mur nge iri nai tina. ");
INSERT INTO uvl_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","“Mala ero mana nga hoena kol neu takiraua nena ure mur pe laia ke te olia ke mene umtutuna ia. Ke het pe ua sapele ke langa kileng e nga tau toto. Pe nga kileng neu ana non hesil taua nena umtutuna mur nga poinga poreke ngana pe ure poreke ngana mur. ");
INSERT INTO uvl_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Ol pe uringa palaungana lohot sapele. Pe ana ngaunga ero pe tu ke poreke toto sapele nga kileng neu. ");
INSERT INTO uvl_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Ol pe lake tu luluch nge none nga kileng neu pe non neu poia kol neu ke la nauelele nena kie mur. ");
INSERT INTO uvl_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Pe mete ana toto pe lemene mana nge hemute sana nga kie nemur aria ngaunga. Pe ero. Mele pele tunge ngaunga unne lange i ero toto. ");
INSERT INTO uvl_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“Iok laol, ana non letena matana ke nek toto ol pe hele sapele, ‘Temek nena hana mur kou te ngau ke saria unna pe aria ngaunga aluana mama. Pe iau i! E meteak ke e metmete lo! ");
INSERT INTO uvl_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Lape ela mule nge temek pe e hele lange i, “Temek, e poia poinga poreke toto ngana lange NeHalang pe lange iong pule. ");
INSERT INTO uvl_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Iau e urana ero ol nge o hetue iau ke tum iau. Lemek ke o poia iau ke eume manmana nge iong ol.” ’ ");
INSERT INTO uvl_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Iok laol, ana non lohaka pe la sapele nge temene. “Pe ii nga tau kura pe temene esia i pe letena poreke toto ia tuna pe song ke la lau hite i pe tangia i. ");
INSERT INTO uvl_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Ol pe kol neu hele lange temene, ‘Temek, e poia poinga poreke toto ngana lange NeHalang pe lange iong pule. Iau e urana ero ol nge o hetue iau ke tum iau.’ ");
INSERT INTO uvl_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","“Pe temene hele lange nena hana mur nenge te umume nge i ke teke, ‘Ueiuei mana a hemalmalia i nga hengeron e nge urana toto pe apuo teua pon nga penna kukana pe ae ulina nga apena. ");
INSERT INTO uvl_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Pe a hune pulumakau tuna elle nge lum toto pe a lele hite pe tapeu ele ke ta ngau nge i. ");
INSERT INTO uvl_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Iange tuk nei mete lokoi pe mahul haka mule! Pe pule i erue toto lo pe ngana koi e hottau mule nei!’ Ol pe te talune iechinga palaungana nem. ");
INSERT INTO uvl_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Tepoi ke machmau pe non soke neu tuna tengene ana kou tu nga ume kura. Ol pe hot ume ana ke at rochroi nga pele pe longe iri nge te peupeu pe te heses. ");
INSERT INTO uvl_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Ol pe iua temene nena none pe onteia i ke teke, ‘Hana nemur te potatar mau?’ ");
INSERT INTO uvl_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Pe temene nena non neu tuacholia, ‘Tim pai at mule lo. Pe temem hune pulumakau e nge lum toto ke poia tim na kilanga unne iange ute heporeke tim ero. Urana mana ke at lohot mule nge temem.’ ");
INSERT INTO uvl_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","“Kol neu tina nenge soke letena inin pe lemene ero nge teu langa pele. Ol pe temene i hot taua i lange hot ke onteiteia pe puochenia i ke teke teu langa pele letena. ");
INSERT INTO uvl_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Pe ana non hele inin taua temene, ‘Onau at, nga hesinga lochoch ngana nei eume manmana nge iong pe e longo ole taua iong ero toto. Pe o tunge utar at nge iau? Pomere nenge o tunge meme e ero ke imem ul pekngak mur mo poia lek kilanga unne ke mo iech? ");
INSERT INTO uvl_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Pe tum poreke ngana nei hesil taua lem ure nge hehei kue tana ana mur. Pe heueu nei at mule nga ra kileng pe o hune ana pulumakau lum ngana ke ngaua.’ ");
INSERT INTO uvl_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“Pe non neu hele lange tuna ke teke, ‘Iong, otu luluch nge iau ke kokoes pe lek ure lochloch ngana nemur lape e tunge lange iong ke lem. ");
INSERT INTO uvl_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Pe heueu nei tapeu pe tahes iange tim nei mete lokoi pe maul haka mule. Pe pule erue pe e hottau mule i lo.’” ");
INSERT INTO uvl_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Iesus hele lange nena hana mur, “Nga etuene e, none umume nge non soke e nge nena ure halang. Pe ume ngana nauelele laka non soke neu nena ure mur. Ol pe helenga e song ke teke non neu hesil sio mene non soke neu nena umtutuna mur. ");
INSERT INTO uvl_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Ol pe non soke neu iu sapele non neu pe onteia i, ‘Pomere nenge ohesil sio mene lek umtutuna? Lape o ume nge iau ke het koi heueu lo. Pomalam ohas sue pe o hele urume umtutuna song ngana at nge iau pe ola ol.’ ");
INSERT INTO uvl_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“Ol pe non neu letena tuanin rara sapele, ‘Lape epoi ke mere mai ol? Non soke nei lemene ero iau nge eume nge i ol i! Iau lek kerkerenga ero nge e sesel ich pe e meia iau pule nge e long us rara i!’ ");
INSERT INTO uvl_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","La ol pe letena matana pe hele, ‘Eh! Oe, letek metene kue e lo! Nenge teke epoi ke pomai lape hulua te tung peria at nge iau nga etue nemur nenge e ume ero ol.’ ");
INSERT INTO uvl_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Ol pe non neu la ke hele nge hana nenge reria hanganok maite non soke neu. Pe iu teua iri elechle pe onteia iri. Iok, ontei tele nenge i muka, ‘Lem hanganok hia nenge maite ak non soke?’ ");
INSERT INTO uvl_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","“Pe non neu tuacholia ke teke, ‘Iau, e mene ae oliua eina nge non soke nem. Pe e mene ke kina papalau ngana iri ana non kina lime (100).’ “Iok laol, non nenge umume nge non soke neu hele lange non nenge poia hanganok neu ke teke, ‘O mene hanganok nem ana alalaha at ke ueiuei pe ohas mana ke ana non kina iri nai pe analoch (50).’ ");
INSERT INTO uvl_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","“Iok onteia e pule, ‘Pe iong lem hanganok hia?’ “Pe non nem tuacholia, ‘Iau, e mene uit nge non soke nem. Pe uit nenge e mene nem ana kole iri ana non kina iri lime iri analoch (1000).’ “Pe non soke nena non neu hele lange non nenge poia hanganok neu ke teke, ‘O mene lem hanganok ana alalaha pe oele sue ke uit kina nem iri ana non kina lime iri rahtele mol. (800)’ ");
INSERT INTO uvl_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Ol pe non soke neu heto heke nena non nenge na poinga pengpeng ero, iange letena song ke nek toto nge nauele i sipona. Hulua lochloch ngana nenge leteria tu mana nga ich nei, leteria tuanin ke nek toto nge te halau mule iri siporia. Iri te etei tote poinga nem. Pe iri nenge tetu teu nga lemenge tualeme ngana, leteria tuanin ke nek ero. Te poi ke pomange aina kinkino ngana kura. ");
INSERT INTO uvl_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","A mene umtutuna mur nga ich nei pe a tunge lange hehei pe hana pe apoi ke nek lange iri. Pomalam nga hoena lape umtutuna nem het pe ala ke atu ke nek mana nga kileng nenge tu ke koko. ");
INSERT INTO uvl_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Itei nenge leteria here i nga ure kinkino ngana lape leteria here i pule nga ure papalaungana. Pe itei nenge pallaklaka nga ure kinkino ngana lape pallaklaka pule nga ure papalaungana. ");
INSERT INTO uvl_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Ke nenge teke leteria manmana nge imo ero nga umtutuna pe ure hel pule nga ich, itei lape letena manmana nge imo nga ure urana ngana mur nga lut nga tapa? ");
INSERT INTO uvl_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Pe nenge teke leteria manmanna nge iong ero nga mele nena ure lape itei tunge iong sipom lem? ");
INSERT INTO uvl_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Non e ume nge hana soksoke ngana nai ero. Iange lape lemene tau tote e pe lemene ero totoia e. Pe mutena tau tote e pe e mutena taua ero. Ke aume mana nge NeHalang pe mutemo taua umtutuna ero.” ");
INSERT INTO uvl_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Pe Paresio mur te longe Iesus na helenga pe te songlele ia i. Iange iri muteria tau tote umtutuna. ");
INSERT INTO uvl_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Ol pe Iesus hele lange iri, “Imo sipomo a hetei hote imo lange hulua mur iange a teke a urana nga NeHalang matana. Pe NeHalang eteia letemo nge teu ke ulolo. Utar nge palaungana toto nge hana nga ich nei poreke toto nga NeHalang matana. ");
INSERT INTO uvl_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Moses nena hotonga mur pe hetatalonga mur tehas ngaria te nanasia ke la het nga etue nenge Ioanes. Pe nga etue neu pengpeng te hele hote NeHalang nena helenga urana toto ngana nga nena naualanga pe nekinga nge ita. Pe hulua halang tepur kikiria toto ke teke teteu. ");
INSERT INTO uvl_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Tapa pe ich lape tehet pe NeHalang Nena Hotonga ana hasinga unne e erue ero toto. ");
INSERT INTO uvl_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Mele nenge hile nehei pe lei haka mule i laka tomtom ia none nehei. Pe mele nenge lei heke mule none nehei nge hile poia poinga poreke toto ngana pule. ");
INSERT INTO uvl_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“None nenge nena ure halang pe none nenge tu ke poreke toto. Pe non nenge nena ure halang heronia hengeron urana ngana mur pe nga etue lochloch ngau ke sana una manmana. ");
INSERT INTO uvl_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Pe non nenge tu poreke toto nem ene Lasarus. I singina chanchan hulu pe kokoes mana te mene i langa non soke neu nena piunga matana ");
INSERT INTO uvl_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","ke nachnei alala ngaunga mumuna. Pe kaone mur teat ke te ramram ia nena chanchan mur. ");
INSERT INTO uvl_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Ol pe nga hoena ana non mete pe NeHalang nena angkelo mur te mene heke sapele i langa lut nga tapa ke la are nga Apraham penna tamalmal. Pe non nenge nena ure halang neu mete pule ke tealo hite. ");
INSERT INTO uvl_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Pe i nga ana metenga hoena amneia melmelenga palaungana toto iange opene lake tu nge imperno. Pe teke nau haka la pe esia Apraham nge tu ke kangkanga toto pe Lasarus tu luluch nge i. ");
INSERT INTO uvl_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Ol pe iu ke teke, ‘Temek, Apraham letem poreke ia iau, pe o hele lange Lasarus ke puo teua penna kukana mokona nga ech pe at ke hesipsipia ak hengetau. Iange e amneia melmelenga palaungana toto i, nga oan nei.’ ");
INSERT INTO uvl_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Pe Apraham tuacholia lange i, ‘Tuk, letem metene? Otu ngam nga ich, o mene ure urana ngana mur lochloch. Pe Lasarus mene ute pele nge urana ero toto. Ke heueu nei tu luluch nge iau ke nek pe iong o amneia am melmelenga pallem. ");
INSERT INTO uvl_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Pe pule liling e nge palaungana toto koi ma tote ita. Ke mele e nge imem lape lotele lalamam ero toto. Pe mele e nge imo lape lotele at lamai ero toto pule.’ ");
INSERT INTO uvl_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Pe non neu hele, ‘Iok temek, o kulosia Lasarus ke langa temek nena pele. ");
INSERT INTO uvl_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Iau titik mur iri lime pe e teke Lasarus la ke hele toto reria ke te hulia reria poinga mur. Pomalam lape teat nga kileng poreke ngana nei ero.’ ");
INSERT INTO uvl_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“Pe Apraham hele, ‘Hotonga nenge Moses pe hasinga nenge hetatalonga mur tehas ia ngana la ma lo. Pe nenge teke lemeria te longo taua.’ ");
INSERT INTO uvl_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","“Pe non neu hele, ‘Ero iam, Temek! Te longo taua ero toto la! Nenge teke mele nenge mete lo lake lohot nge iri, laka lape te longo taua i pe te hulia reria poinga mur.’ ");
INSERT INTO uvl_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","“Pe Apraham hele lange i, ‘Nenge teke te longo taua Moses pe hetatalonga mur ero lape mele nenge mete pe mahul haka mule lape te longo taua i ero pule.’” ");
INSERT INTO uvl_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Iesus hele lange nena hana mur ke pomai, “Manmanna toto ke ure nemur nenge hesingo ia hehei pe hana ke te losio nga poinga poreke ngana mur lape teat. Pe mele nenge poia singo nem nenge helosio ia hehei pe hana lape mene poreke tote. ");
INSERT INTO uvl_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Tuangachol nga poinga nem poreke toto. Pe teke te heon hite um palaungana nga mele nem kanna pe tesau hote langa leme i urana nga tuangachol nenge helosio ia mele sune letena manmanna ngana. ");
INSERT INTO uvl_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Ke pomalam a nauala amo ke nek. “Nenge teke tim losio nga poinga poreke ngana o heleia i ke hul mule letena. Pe nenge hul mule nena poinga lo, iok, letem metene poi ngana nemur ero ol. ");
INSERT INTO uvl_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Pe nenge teke tim poia poinga poreke ngana e lange iong pe nga hoena hul mule letena, o saua nena poinga poreke ngana mur ke te lasus toto. Pe nenge poi emule mene nga etue choro mana, o saua nena poinga poreke ngana mur ke emule mana pule ke kokoes.” ");
INSERT INTO uvl_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Pe Iesus nena hana mur nenge kulos hote iri te hele lange i, “O halaua imem ke letemem manmanna ngana lohot ke palaungana toto.” ");
INSERT INTO uvl_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Pe Iesus tuacholia, “Nenge teke letemo manmanna ngana tuna mana ke pomanga heilil tutuna, nakumo nge a hele langa ae e ke pomai, ‘O laka haka pe ola ke omes teu nga ruach.’ Pe ae nem longo taua iong la.” ");
INSERT INTO uvl_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Iok, Iesus onteia iri, “Imo lemo poinga mere? Nenge teke lem hengekuleilei ana non, mule nga ume nenge nauelele sipsip mur ke at, pe lape o hele lange i ke mere? Lape iteu at heueu mana pe o hele lange i ke are sio pe ngau sapele? ");
INSERT INTO uvl_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Ero toto la! Lape o hele lange i ke o teke, ‘Ola ke onun pe oat ke o poia ak ngaunga ke e ngau ol. E ngau ke het laka, iong o ngau ol.’ ");
INSERT INTO uvl_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Lem hekuleileinga ana non nem, poia ume nemur pe iong o heto heke i ero. Iange i popoia ana ume nenge popoia nike. ");
INSERT INTO uvl_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Ke pomalam nge imo pule, nenge teke apoi taua ure nemur nenge te hele lange imo ke a poia, a hele ke a teke, ‘Imem hana nenge te hekuleilei rere menmene imem. Mopoi mene ume nenge te tunge at nge imem ke mo poia.’” ");
INSERT INTO uvl_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Iesus ii nga kileng nge Samaria pe Kalelea tunangaria ke lala nge Ierusalem. ");
INSERT INTO uvl_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Iteu ke lala nga kileng sune pe saol haka nge hana iri analoch. Pe hana nemur haleles poreke ngana nenge ngau hooa singira poia iri. Pe iri tetu ke kangkanga toto nge hehei pe hana iange singiria poreke toto. Pomalam temes nga tau kura, ");
INSERT INTO uvl_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","pe teiu, “Non Soke Iesus, letem ia imem.” ");
INSERT INTO uvl_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Iesus esia iri pe hele lange iri, “Ala ke a esia hana nenge tunginga ana hana mur ke tenau ke nek nga singimo.” Iok laol, tei ke te lala kura pe singiria urana sapele. ");
INSERT INTO uvl_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Elle nge iri analoch nem nena nge Samaria. Ana non esia i sipona singina nge urana mule pe la mule pe haliu haka nenge heto heke tote NeHalang ene. ");
INSERT INTO uvl_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Lamule pe tamal sue i langa Iesus apena huna pe hele urana toto lange i. ");
INSERT INTO uvl_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Pe Iesus hele, “E hemas mule hana iri analoch i, pe rahtele henel nem te lake mere? ");
INSERT INTO uvl_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Pomere nenge non lomona nei i toro at ke heto heke NeHalang?” ");
INSERT INTO uvl_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Ol pe Iesus hele lange non lomona neu, “O lohaka pe ola ol. Letem manmanna ngana laka hemas mule iong.” ");
INSERT INTO uvl_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Iok, Paresio hel te onteia Iesus nga etue nenge NeHalang nena naualanga pe nena nekinga lape at. Pe Iesus tuacholia ke pomai, “Etue nenga NeHalang nena naualanga pe nekinga nem, lape at ke pomanga ure nenge ta esia nga matara ero. ");
INSERT INTO uvl_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Mele ero toto nge hele ke teke, ‘Anau at ngana i!’ Pe pule mele ero toto nge hele ke teke, ‘Eh, Ngana paukou!’ Mele nge lape hele ke pomam ero toto iange NeHalang nena naualanga pe nekinga, ngana laka tuteu nge imo lo.” ");
INSERT INTO uvl_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Ol pe Iesus hele lange nena hana mur, “Etue nem lape at, pe imo lememo toto ke a teke a naue Non Tuna nga etue nem. Pe lape a naue ero toto. ");
INSERT INTO uvl_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Lape iri hel pule nenge lape te hele lange imo ke te teke, ‘Anau lala mau! Eh, anau at lamai!’ Pe imo, a longo tau pulute iri ero. ");
INSERT INTO uvl_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Etue nenge Non Tuna at mule ia lape pomalaka nga kileng chalem ngana nenge inlem nga tapa sana pe song ke langa ele pe ele. ");
INSERT INTO uvl_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Pe ure nenge lohot tala nga Non Tuna ana etue ngana koi nei, lape Non Tuna amneia melmelenga palaungana pe hulua lochloch nga etue nei lemeria ero ia i mukam. Ke het pe etue nem lohot. ");
INSERT INTO uvl_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“Non tuna ana etue lape lohot ke pomanga etue nenge Noa. ");
INSERT INTO uvl_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Nenge hulua lochloch te ngaungau pe te inin pe te lechlei kela het nga etue nenge Noa iteu langa nena imot. Pe ech hot ke taua kileng pe te mete lochloch. ");
INSERT INTO uvl_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","“Pe pule Non Tuna ana etue lape lohot ke pomanga etue nenge Lot. Nenge hulua lochloch te ngaungau pe te inin pe te ialala pe te umume aria pe te lelele pele. ");
INSERT INTO uvl_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Pe nga etue nenge Lot ua hot nge Sotom, oan remenmen ngana pe um ngingina ngana telot parai sio at nga tapa ke pomanga pitte ke te hune iri lochloch ke te mete. ");
INSERT INTO uvl_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","“Ke Non Tuna ana etue nenge lape at muleia pomalam mana. ");
INSERT INTO uvl_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Nga etue nem pengpeng, mele nenge tutu nga one, teu langa pele letena ke lolochia nena ure mur ero ol. Pomalam mana none nenge tutu nga ume la mule nga na pele ero ol. ");
INSERT INTO uvl_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Letemo metene Lot nehei? ");
INSERT INTO uvl_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Mele nenge teke heleis maul ngana nga ich nei, lape tu ke maulul nga hoena ero ol. Pe mele nenge tungteu tote i, pe hile sue lemene ngana mur nga ich nei lape tu ke maulul mana nga hoena. ");
INSERT INTO uvl_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","E hele lange imo pengpeng, nga miliko nem aina nai tema nga hete elle pe elle nge iri lape te ua toto ia, pe elle mana lape ma ol. ");
INSERT INTO uvl_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Pe hehei nai lape te olole mioka pe elle nge iri lape te ua toto ia pe elle mana tu ol.  ");
INSERT INTO uvl_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Hana nai te umume nga ume pe elle nge iri te ua toto ia pe elle mana tu ol.” ");
INSERT INTO uvl_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Pe Iesus nena hana mur nenge hetotore iri te ontei, “Ure nemur lape te lohot langai?” Pe Iesus tuacholia ke pomai, “Nga kileng nenge ute has ngana maia, lape a esia lango cherchera mur halang, nge te emurung.” ");
INSERT INTO uvl_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Ol pe Iesus nene poponing e lange nena hana nemur. Poponing neu, nenge hetore iri ke te hetalau ke kokoes pe leteria manmanna ke NeHalang longe te hetalaulau ngaria pe halaua iri. ");
INSERT INTO uvl_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Iok, Iesus talune nena nananga ke pomai, “Nga kileng e none nge longlongo helenga tu. Pe non neu mataua NeHalang ero toto. Pe pule non neu letena porekeia hehei pe hana ero iange letena tu mana nge i sipona. ");
INSERT INTO uvl_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Pe nga kileng neu hei pakar e tu. Pe hei neu kokoes mana lala nge non nenge longlongo helenga pe hele urume poinga poreke ngana nenge none poia lange i. Pe hei neu hele ke teke, ‘O amnei langa poinga poreke ngana nenge non neu poia at nge iau. Lape o halaua iau ke pomere?’ ");
INSERT INTO uvl_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","“Nga tele ngana non neu longo taua hei neu ero. Pe nga hoena ol hele mule ke teke, ‘Iau e mataua NeHalang ero pe letek porekeia hehei pe hana ero. ");
INSERT INTO uvl_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Pe hei nei kokoes mana at ke pur leme ero mana ia iau nga letena una ngana nei. Ke pomalam lape e halaua i ke are ke nek laka at ke hemakuk tote iau ero ol.’” ");
INSERT INTO uvl_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Iesus nene poponing nem ke het pe hele mule ke teke, “A longo langa non poreke ngana nenge longolongo helenga neu hele ngana. ");
INSERT INTO uvl_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Lape NeHalang mai halaua nena hana mur ero kai? I sipona hesilei hote iri. Pe lape pomere? Nenge teke te tang lange i ke kokoes nga sinanga pe nga miliko lochloch lape NeHalang poi hulul mana nge halaua iri? ");
INSERT INTO uvl_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","E hele lange imo pengpeng lape halaua nena hana mur ke teare ke nek mule ke ueiuei mana. Pe pomere lape Non Tuna at pe hehei pe hana leteria manmanna lochloch lo?” ");
INSERT INTO uvl_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Pe pule Iesus nene poponing nei lange iri hel nenge te teke iri siporia te pengpeng toto lo pe tetal heke iri siporia pe tenau sio menmene hehei pe hana. ");
INSERT INTO uvl_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Pe Iesus nana lange iri ke pomai, “Hana nai tela nga NeHalang nena pele palaungana ke te hetalaulau. Non e nge iri i Paresio pe e i non nenge lololoch umtutuna. ");
INSERT INTO uvl_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Pe Paresio neu i toro mes ke kangkanga pe hetalaulau lange NeHalang ke pomai, ‘NeHalang, e hele urana toto lange iong nge iau e pomanga hana nemur ero. Hana nenge te kemkeme pe hana nenge te pallaklaka pe hana nenge tepoi poreke lala nge hehei. Pe e hele urana toto lange iong pule nge iau e pomange non nenge lololoch umtutuna nei ero. ");
INSERT INTO uvl_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Etue nachnai nga etue koana elle eheo nga ngaunga pe letek metene iong. Pe e mene hote umtutuna unne nga uruk ke e tunge lala nge iong. Pe e poia ke pomau nga lek ure mur lochloch.’ ");
INSERT INTO uvl_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Pe non nenge lololoch umtutuna mes ke kangkanga pe nau sio mana pe palia mautuna pe hetalaulau ke pomai, ‘NeHalang, letem ia iau. Iau non poreke ngana.’” ");
INSERT INTO uvl_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Ol pe Iesus hele, “E hele lange imo pengpeng, non nenge lololoch umtutuna nem la mule nga na kileng pe i toro mana lohot ke pengpeng toto nga NeHalang matana. Pe non Paresio nem ero toto. Iange mele hel nenge tetal heke iri lape NeHalang tal sio tote iri. Pe mele hel nenge tetal susue iri lape NeHalang tal haka tote iri.” ");
INSERT INTO uvl_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Hana hel te laia tuturia mur nge Iesus ke pete iri. Pe Iesus nena hana mur te esia pe te hele ele iri. ");
INSERT INTO uvl_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Pe Iesus hele lange na hana mur ke teke, “Aina kinkino ngana nem mur muteria ke te teke teat nge iau. Pe imo apoi ele iri ero. Iange hehei pe hana nenge te pomange aina kinkino ngana nemur, tetu teu nga NeHalang nena naualanga pe nekinga pule. ");
INSERT INTO uvl_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","E hele ke manmanna lange imo, mele nenge letena ia NeHalang nena naualanga pe nekinga ke mange aina kinkino ngana ero lape teu la ero.” ");
INSERT INTO uvl_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Ol pe non nenge i mukmuka nge Iuta mur onteia Iesus, “Non soke, o urana toto. Pe iau lape epoi ke mere ke e mene maulinga ke koko?” ");
INSERT INTO uvl_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Pe Iesus tuacholia, “Pomere nenge o hetue iau ke non nge urana? Mele e nge urana ero toto. NeHalang i toro mana. ");
INSERT INTO uvl_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","O eteia NeHalang nena hotonga mur. O tomtom ia hehei ero pe o hune mele ero pe okeme ero pe o pallaka ia mele ero pe o heto heke temem pe tam.” ");
INSERT INTO uvl_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Pe non neu tuacholia, “Nga iau lomele ngak nike ke at heueu nei e nanas taua hotonga nemur lochloch.” ");
INSERT INTO uvl_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Iesus longe ke mau pe hele lange i, “Ute elle la o poia ero kura. O laia lem ure lochloch ke te olia pe uruna, o laia nge pakar mur. Nenge teke opoi ke pomalam lape lem ure mur halang nge tetu ke koko. Pe ure nemur lape te kulele iong nga lut nga tapa. Opoi ke mam ke het pe o nanasia iau ol.” ");
INSERT INTO uvl_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Pe non neu longe helenga nei pe letena poreke toto iange i nena ure halang toto. ");
INSERT INTO uvl_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Pe Iesus esia i nge nakuna pomau pe hele, “Anali toto nge hana nenge reria ure halang nge teteu langa NeHalang nena naualanga pe nekinga. ");
INSERT INTO uvl_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Anali toto nge iri iam. Nenge teke te puo teua ae tana palaungana e ke teu nga pakeka sune polona, nem semel pol. Pe nenge teteu langa NeHalang nena naualanga pe nekinga nem nge anali toto iam.” ");
INSERT INTO uvl_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Iri nenge te longe i te ontei, “Nakuna nge mele ero toto nge lape mene maulinga ke koko. Lape mopoi ke mere ol?” ");
INSERT INTO uvl_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Pe Iesus tuacholia, “Utar nenge anali toto nge none poia semel mana nge NeHalang poia.” ");
INSERT INTO uvl_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Pe Petrus hele, “Onau at, imem mo hile sue lemem kileng mur pe moat ke mo nanasia iong.” ");
INSERT INTO uvl_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Pe Iesus hele lange iri, “Oe, atong pe e hele pengpeng lange imo iri lochloch nenge te ume teu nga NeHalang nena naualanga pe nekinga pe te hile sue reria kileng mur pe reria hehei pe tuturia mur pe tetemeria pe tataria mur, ");
INSERT INTO uvl_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","iri lape te mene ure urana ngana halang toto nga etue nei. Pe nga etue nenga hoena lape te mene maulinga nge koko.” ");
INSERT INTO uvl_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Iok, Iesus mene hot kelkelia nena hana analoch pe nai nem pe hele lange iri ke pomai, “A longo at. Ta lohaka lala nge Ierusalem koi pe lape hetatalonga mur tehas ngaria nge Non Tuna lape lohot ke manmanna. ");
INSERT INTO uvl_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Iange lape te tunge Non Tuna langa hana lomonmona mur peria. Pe lape tepoi poreke i ke te hesalang ia i pe te ulut lolele i pe lape te hune i. ");
INSERT INTO uvl_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Pe etue mol ngana nga hoena lape maul haka mule.” ");
INSERT INTO uvl_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Iesus hele ke pomau pe nena hana nemur te eteia utar nenge helele ia ero. Iange helenga luna mallaha nge iri ero. Pomalam te eteia utar nenge Iesus helele ia ero. ");
INSERT INTO uvl_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Iok, Iesus i ke heroi lala nge Ieriko pe none nge matana hit are nga kue ilina pe longlong ure nge hehei pe hana nge tei olole nga kue. ");
INSERT INTO uvl_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Ol pe longe hulua nge teii nga kue pe ontei, “Eh! Pomere mai?” ");
INSERT INTO uvl_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Pe hehei pe hana nemur te tuacholia i ke pomai, “Iesus nenge Nasaret koi i olole nga kue.” ");
INSERT INTO uvl_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Pe non neu halngana haka, “Iesus! Teuit tuna! Letem poreke ia iau!” ");
INSERT INTO uvl_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Pe hehei pe hana nenga muka te keres taua i pe te hele lange i ke teke reng. Pe ero. Non neu alngana haka ke soke toto ol, “Teuit tuna! Letem poreke ia iau!” ");
INSERT INTO uvl_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","La ol pe Iesus mes sapele. Pe ngai heke hehei pe hana ke te mene non neu lange i. Te mene ana non lange i pe Iesus onteia i, ");
INSERT INTO uvl_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Lemem ke o teke e poia utar lange iong?” Pe non neu tuacholia, “Non Soke, o halaua iau ke matak charchara mule.” ");
INSERT INTO uvl_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Pe Iesus hele lange i, “Iok, onau mule ol. Letem manmanna ngana laka poia iong ke o urana mule.” ");
INSERT INTO uvl_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Ueiuei mana pe non neu nau ke nek mule sapele pe nanasia Iesus pe heto heke NeHalang. Hulua nemur te esia pe iri lochloch te heto heke NeHalang pule. ");
INSERT INTO uvl_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Iok laol, Iesus iteu la sapele nge Ieriko pe i olole ke lala. ");
INSERT INTO uvl_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Pe hana nenge te lololoch umtutuna aria soke tu lamau pule. Pe i ene laka Sakius pe nena ure halang toto. ");
INSERT INTO uvl_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Ana non teke etei toto nga itei nenge i Iesus. Pe ero, iange hulua halang pe i choro mana, pomalam anali toto nge i. ");
INSERT INTO uvl_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Ol pe song ke i muka nge hulua nemur pe la haka nga ae siki mokona ke teke nau nge Iesus nge ila ke pomau. ");
INSERT INTO uvl_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Iok, Iesus i langa kileng unne neu pengpeng pe hele lange Sakius, “Sakius, osio at ke ueiuei iange heueu lape etu nga lem pele.” ");
INSERT INTO uvl_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Sakius sio ke ueiuei mana pe epele Iesus pe iech toto nge Iesus. ");
INSERT INTO uvl_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Hulua lochloch ngana nemur te esia i pe te ngunngunu ke teke, “Non panei i langa non nenge na poinga poreke toto na pele!” ");
INSERT INTO uvl_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Ol pe Sakius mes haka pe hele lange Iesus, “Non Soke, o longo at nge iau. Lape e tunge lek ure mur ele lochloch lange pakar mur. Pe pule nenge teke e pallaka ia iri lape e olia iri ke olinga huna henel la mule nge iri.” ");
INSERT INTO uvl_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Pe Iesus hele lange Sakius, “Heueu mana nei NeHalang mene mule iong. Iange iong Apraham nette iong pule. ");
INSERT INTO uvl_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Pe Non Tuna at ngana nei at ke tango rere iri nenge te erue pe mene mule iri.” ");
INSERT INTO uvl_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Iok, hehei pe hana te longlongo nga nei kura pe Iesus nana tele sapele nga poponing e. Iesus heroi toto lange Ierusalem pe hulua te teke mam pe NeHalang nena naualanga pe nekinga lape lohot sapele. ");
INSERT INTO uvl_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Ol pe Iesus hele, “Non e nenge tuteu nga mata nenge naungaala ana hana mur. Ana non soke teke i ke langa kileng tau ngana e ke tal heke i ke i aria naungaala ana non. Ke het pe lape at mule nga na kileng. ");
INSERT INTO uvl_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Lohaka ke la ero kura pe iua nena hana iri analoch nenge te umume nge i. Tunge reria umtutuna ellechle pe hele lange iri, ‘Anau at, iau lape e lala lo koi. Pe imo a mene umtutuna nem pe a ume mule ia umtutuna hel pule. Ke la het nga etue nenge eat mule.’ ");
INSERT INTO uvl_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","“Pe nena kileng nganangana mur lemeria ero ia i pe te kulosia hana hel langa kileng tau ngana nem pule ke te hele ke te teke, ‘Imem lememem ero toto nge non nei lohot ke i ara naungaala ana non.’ ");
INSERT INTO uvl_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Ol pe ana non la ol pe te poia i ke i aria naungaala ana non pe at mule sapele nga na kileng. Pe ueiuei mana tunge helenga kerkereng ngana lange nena hana nenge te umume nge i ke teat ke te neue i, pe ontei hote iri nga umtutuna hia lo nenge teume hote nga umtutuna nenge heronge lange iri. ");
INSERT INTO uvl_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Elle at tala pe hele, ‘Non soke, iau e mene ke umtutuna iri analoch mule nga elle nenge o tunge at nge iau.’ ");
INSERT INTO uvl_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","“Pe non Soke neu hele, ‘Iong oume ke urana toto iam! Ke iong non nge urana. Iok, iong letek here iong nge oume ke nek toto nga ume kinkino ngana lo pomalam, lape e talue iong ke onau ala ke kileng iri analoch.’ ");
INSERT INTO uvl_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","“Iok nena non naingana at pe hele, ‘Non soke, iau e mene mule ke umtutuna iri lime. Eume hote nga elle nenge o tunge at nge iau.’ ");
INSERT INTO uvl_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","“Pe non soke neu hele lange i, ‘Nga nem, lape onau ala ke kileng iri lime.’ ");
INSERT INTO uvl_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Iok, nena non mol ngana iteu at mule pe hele, ‘Non soke lem umtutuna nenge o tunge at nge iau koi, e ruchite pe e talkome ke ma. ");
INSERT INTO uvl_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","E mataua iong ke ngana laka nenge e talkome mene, iange iong non nge letem inin hali pe o menmene mele hel reria ure mur pe o lulule ngaunga nenge mele hel tetue.’ ");
INSERT INTO uvl_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","“Ol pe non soke neu hele lange i, ‘Iong hengekuleilei poreke ngana. Pe nga iong sipom lem helenga nge hot nga halim, lape o amneia melmelenga palaungana! Iong sipom o eteia lo ke iau non nge letek inin hali. E menmene mele hel reria ure mur pe e lulule ngaunga nenge mele hel tetue. ");
INSERT INTO uvl_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Iok, pomere toto nge o talue lek umtutuna nga umtutuna ana pele ero? Toi nge otal teua, lape eat mule pe e mene umtutuna nem pe ana manga hoho hel pule.’ ");
INSERT INTO uvl_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“Ke het, pe non soke neu hele lange hana hel nenge te mes rochroi nga henge kuleilei nem ke teke, ‘A mene mule umtutuna nge non nem pe at tunge lange non hengekuleilei nenge nena umtutuna iri analoch.’ ");
INSERT INTO uvl_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","“Pe hana nemur te hele lange non soke neu ke teke, ‘Non soke, non nei nena umtutuna iri analoch lo!’ ");
INSERT INTO uvl_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","“Pe non soke neu tuacholia, ‘E hele lange imo pengpeng, mele hel nenge reria halang toto lape te mene ke halang toto pule. Pe mele hel nenge reria unne sune mana lape te mene mule unne nem nge iri. ");
INSERT INTO uvl_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Pe lek ngarang nemur nenge lemeria ero ia iau a mene iri at pe a hune iri lakoi nga matak.’” ");
INSERT INTO uvl_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Iesus nana ke het pe i ke i mukmuka pe hulua te nanasia i ke tela nge Ierusalem. ");
INSERT INTO uvl_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Iok, Iesus i ke heroi nga kileng nenge Petpage pe Petani. Pe nga hengene nenge te hetue ke Ae Oliua, kulosia nena hana nai. ");
INSERT INTO uvl_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Pe hele lange iri ke pomai, “Imo muka ke ateu langa kileng neu pe lape a neue tongki lomele ngana e nenge mele are haka ia ero kura. Pe tongki nem, te kele ke mes. Aun hote pe a atia. ");
INSERT INTO uvl_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Pe nenge teke mele onteia imo, ‘Pomere nenge aun hote ure nem?’ Pe imo a hele lange i ke a teke, ‘Non soke lemene taua.’” ");
INSERT INTO uvl_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Iok laol, hana nemur tela pe te hottaua ure lochloch ngana nge lohot ke pomanga Iesus heleia lange iri. ");
INSERT INTO uvl_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Iok, teun hotote tongki lomele ngana neu pe non nenge nena ure neu onteia iri, “Pomere nenge aun hote ure nemam?” ");
INSERT INTO uvl_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Pe iri te hele, “Non soke lemene taua.” ");
INSERT INTO uvl_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Iok laol, te mene la sapele nge Iesus pe te tamal heke reria hengeron nga ure neu ona pe teare heke sapele Iesus. ");
INSERT INTO uvl_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Iesus are haka nga tongki ke iolole pe hehei pe hana te lung susue reria hengeron mur nga kue. ");
INSERT INTO uvl_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Iesus i ke langa kileng unne nenga hengene nge Oliua nenge ana kue nau sio lange Ierusalem. Pe nena hana lochloch ngana nemur nenge te nananasia i te iech toto pe te hele urana toto lange NeHalang. Singiria kik pe te heto heke tote NeHalang nga mirakulo nemur nenge Iesus poi hote iri ke te esia ke ulolo. ");
INSERT INTO uvl_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Pe te makul haka ke mai, “Petanga tunge Naunga ala ana non nenge at nga Non Soke ene! Pe tunga nge nek nga lut nga tapa! Ta heto heke tote NeHalang nga lut nga tapa nge i palaungana toto pe urana toto!” ");
INSERT INTO uvl_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Ol pe Paresio mur hel nge tei luluch nge iri te hele lange Iesus ke teke, “Non soke, o keres taua lem hana mur.” ");
INSERT INTO uvl_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Pe Iesus tuacholia, “E hele lange imo, nenge teke lek hana mur te reng, um lochloch ngana nemur tepeu pe te heto heke NeHalang ene.” ");
INSERT INTO uvl_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Iesus i ke heroi toto lange Ierusalem pe esia kileng nem pe letena poreke toto ia pe tang. ");
INSERT INTO uvl_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Pe hele, “Heueu nei, toinge o eteia utar nenge hetakile iong. Pe pa nei ero iange te talkome nga matam. ");
INSERT INTO uvl_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Pe etue nem lape at nenge lape lem ngarang mur teat ke te heliliu hite iong ke tom ke otu mana nge teu. ");
INSERT INTO uvl_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Pe lape te heporeke tote iong pe lem hana mur, iange o etei ilia etue nenge NeHalang atia ke halau iong ia ero!” ");
INSERT INTO uvl_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Ol pe Iesus iteu sapele langa NeHalang nena pele palaungana pe lope hote hana nge tei alala. ");
INSERT INTO uvl_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Lope hote iri pe hele, “NeHalang hele hote na hotonga ke tehas sue ke pomai, ‘Lek pele palaungana nei, i hetalaulaunga ana pele!’ Pe ero. Imo, a poia ke pomanga kemenge kina mur reria pele nge tetal komkome ia.” ");
INSERT INTO uvl_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Nga etue lochloch, Iesus hetottoro nga NeHalang nena pele palaungana pe tunginga ana hana mur aria papalauna mur pe hotonga ana hetoronga mur, pe hana papalauna hel pule te teke te hune i. ");
INSERT INTO uvl_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Pe iri te teke te tango rara kue e nge te laua Iesus. Pe ero toto, iange hehei pe hana te longo lala nge i kura. Iri lemeria ero nge te hile hote Iesus nena helenga unne. ");
INSERT INTO uvl_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Iok, etue e pule Iesus tu teu nga NeHalang nena pele palaungana letena. Ana non hetottoro pe haliu hote NeHalang nena helenga urana toto ngana. Ol pe tunginga ana hana mur aria papalauna mur pe hotonga ana hetoronga mur pe hana papalauna hel pule teat pe te hele lange i, ");
INSERT INTO uvl_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","“O hele urume lem kerkerenga nem, nenge o popoia ure nemur. At langai toto? Pe itei toto nenge tunge kerkerenga nem lange iong?” ");
INSERT INTO uvl_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Pe Iesus tuacholia iri, “Iok, iau pule e onteia imo nga onteinga elle pe imo a hele at nge iau. ");
INSERT INTO uvl_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Ioanes nenge henunun mai nena kerkerenga nem, at langai? At nge NeHalang ma at nge hana mur mana?” ");
INSERT INTO uvl_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Ol pe hana nemur te hele hel nge iri, “Lape ta hele ke mere mai? Nenge teke ta hele ke ta teke, ‘Ioanes nena hekerkereng nem at nge NeHalang’, lape Iesus hele ke teke, ‘Iok, pomere nenge letemo manmanna nge i ero?’ ");
INSERT INTO uvl_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Pe nenge teke ta hele ke ta teke, ‘Ioanes na kerkerenga nem at nge hana mur mana’, lape hulua nemur te tamal hune ita nga um. Iange iri leteria manmanna toto ke Ioanes i hetatalonga!” ");
INSERT INTO uvl_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Pomalam te tuacholia ke pomai, “Imem mo eteia Ioanes na hekerkerenga nem at ngana ero.” ");
INSERT INTO uvl_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Ol pe Iesus hele lange iri ke pomai, “Pomalam mana lape e tuacholia lemo helenga ero nga hekerkerenga nenge e popoia ure mur ia.” ");
INSERT INTO uvl_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Iok, Iesus nene poponing e lange hehei pe hana ke pomai, “Nga etuene e, none tue uain nga ume pe tunge lange hana hel ke te ume hot umtutuna ia. Pe i ulhot ke langa kileng unne sapele. ");
INSERT INTO uvl_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Nga lulunga ana etue, non nem kulosia nena hengekuleilei e ke lange hana nenge te umume nga uain ana ume neu ke te tunge uain nganangana hel lange i. Pe ero. Hana nemur te lohaka pe te palia i pe te kulosia i ke patpata mana ke la mule. ");
INSERT INTO uvl_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Iok, kulos mule nena hengekuleileinga e ke la pule. Pe hana nemur te lohaka pe tepal mule i pule pe te hemei sio tote i. Pe te kulosia i ke patpata mana ke la mule. ");
INSERT INTO uvl_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Iok, non neu kulos mule nena hengekuleilei mol ngana la pe tepal poreke tote i pe tesau hote i. ");
INSERT INTO uvl_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“Iok, ume tokoninga neu hele, ‘Lape epoi ke mere mai ol? Lape e kulosia tuk nenge mutek tau tote ke la, laka lape te renge i.’ ");
INSERT INTO uvl_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","“Ol pe non neu tuna la pe hana nemur te esia pe te hele, ‘Non soke nem tuna ol koi atat. I lape mene ure lochloch ngana nei ke nena. Pe heueu ta hune i ke mete. Pomalam lape ta mene ure lochloch ngana nei ke rera ia ol.’ ");
INSERT INTO uvl_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","La ol pe te laua non neu tuna pe tesau hote i nga ume letena pe tehun sapele i.” Iok laol, Iesus onteia iri, “Utar ol nge lape ume tokoninga neu poia lange hana nemur? ");
INSERT INTO uvl_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Non nem i sipona lape at ke hun lapue hana nemur pe tunge uain ana ume nem lange mele hel nge altoto ke tenau ele.” Pe hulua te longe helenga nei pe te hele, “Poreke toto nge ure nem lohot ke pomau!” ");
INSERT INTO uvl_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Iok, Iesus nau lange hulua nemur pe hele, “Helenga nenge tehas sue nga NeHalang nena hotonga nei, luna ma ke mere? Nenge tehas sue ke, ‘Um nenge pele ana lelenga mur lemeria ero ia ke te teke tesaua, i um urana toto ngana nenge mes ke rahtua ele pele.’ ");
INSERT INTO uvl_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","“Iri lochloch ngana nenge te losio haka nga um nem, lape um rir ule iri ke sachanchana ulu. Pe nenge teke um nem losio haka nge mele, mele nem lape menret sapele.” ");
INSERT INTO uvl_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Iok, Iesus nana ke het pe hotonga ana hetoronga mur pe tunginga ana hana mur aria papalauna mur te teke telau sapele i. Te teke te laua Iesus iange iri te eteia ke Iesus nana ngana latau pengpeng ia iri. Pe iri te mataua hehei pe hana ke pomalam te laua Iesus ero. ");
INSERT INTO uvl_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Ol pe tenau ele tote i ke nek toto, pe te tung hite ure lange hana hel pe te kulosia iri ke la te ollaka hote i nga onteinga mur. Pe hana nemur tela pe te chananga ke tepoi ke mange hana nenge leteria urana mana. Te teke te ollaka hote Iesus, pe nenge teke Iesus heleia ute nge tang ke poreke nga talngaria, lape te laua i pe tela sapele ia i nge Rom mur aria non soke. ");
INSERT INTO uvl_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Iok laol, hana nemur tela pe te onteia Iesus ke pomai, “Non soke, imem mo eteia ke iong o hele ke manmanna pe pengpeng toto mana. Pe iong o mataua mele ero toto ke o hetottoro ke nek toto nga NeHalang nena poinga mur. ");
INSERT INTO uvl_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Iok, o hele ke nek at nge imem. Ita mai urana nge tasau umtutuna lange non soke nenge Rom pule kai? Eh, ero?” ");
INSERT INTO uvl_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Pe Iesus eteia ke hana nemur te chananga ia i nga onteinga nem, ol pe hele lange iri ke pomai, “A teke a ollaka hote utar nge iau? ");
INSERT INTO uvl_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","A heteia umtutuna elle at nge iau ke enau.” Iok laol, te mene umtuna elle ke la te heteia lange Iesus. Pe Iesus onteia iri, “Itei opene pe ene nenge tunga nga umtuna nemai?” ");
INSERT INTO uvl_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Pe iri te hele, “Non soke nenge Rom opene pe ene laka tu nem.” Ol pe Iesus hele, “Oe, ke non soke nenge Rom nena ure mur a tunge lange i. Pe ure nemur nenge NeHalang nena, a tunge lange NeHalang.” ");
INSERT INTO uvl_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Ol pe hana nemur, anali toto nge iri nge te laua Iesus nga hulua nemur mataria. Pe teare ke te reng toktok mana ol. Iange te rura toto nga Iesus nena helenga nenge tunge lange iri. ");
INSERT INTO uvl_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Ol pe hana Satiusi hel tela ke te lohot nge Iesus. Pe iri te teke, nenge teke ta mete lape ta maul haka mule ero ol. ");
INSERT INTO uvl_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Pe te hele, “Non soke, Moses has sue hotonga nei ke teke ta nanasia: ‘Nenge teke none mete hatalia nehei pe i tutuna mur ero kura, non nenge mete nem, tina lape lei heke mule hei nem. Pe iri nai tuturia mur lape te heleia ke teke non nenge mete neu tutuna mur.’ ");
INSERT INTO uvl_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Iok, nga etuene e aina iri rahtele nai nge titiria mur hel tetu. Ol pe tiria nenge soke lei. Iok, telei ke tuturia mur ero kura pe kol neu mete. ");
INSERT INTO uvl_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Laol pe tina nenge nanasia i lei heke mule tina nehei. Iok la, tuturia ero kura pule, pe kol neu mete pule. ");
INSERT INTO uvl_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Pe tina mol ngana lei heke mule hei neu, pe i mete pule ke manga titina mur nenge iri tala nge i. La ke la iri rahtele nai neu telei mene hei elle mana. Pe te hoho ero mana pe iri lochloch ke te mete mule. ");
INSERT INTO uvl_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Pe hei neu mete nga hoena toto ol. ");
INSERT INTO uvl_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Iok, nga etue nenge ta maul haka mule, itei toto nenge lape leia hei neu ol? Iange hei neu, hana iri rahtele nai te leia i ke ulolo.” ");
INSERT INTO uvl_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Pe Iesus tuacholia iri ke pomai, “Hehei pe hana nenge tetu nga ich nei te lechlei. ");
INSERT INTO uvl_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Pe iri nenge te urana pe te maul haka mule nga metenga, telei ero ol. ");
INSERT INTO uvl_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Iri, NeHalang tutuna mur iri iange te maul haka mule nga metenga. Pe tepoi ke pomanga angkelo mur ke te mete ero ol. ");
INSERT INTO uvl_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Moses i sipona hemallaha hote lo. Nga nena hasinga, i has urume etue nenge oan ngau haka nga ae e pe chacharuch ero. Pe nga hasinga nem, i hetue NeHalang ke Abraham ana Non Soke pe Isak ana Non Soke pe Iakop ana Non Soke. ");
INSERT INTO uvl_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Ke NeHalang i hana nenge te maulul mana, aria Non Soke. Iange nge NeHalang iri lochloch te maulul” ");
INSERT INTO uvl_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Ol pe hotonga ana hetoronga mur hel te hele haka, “Non Soke, o tuacholia lemem onteinga ke pengpeng mana!” ");
INSERT INTO uvl_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Ke het pe hana nemur lemeria ero nge te ontei mule Iesus ol. ");
INSERT INTO uvl_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Iok laol, Iesus onteia hehei pe hana pe hotonga ana hetoronga mur, “Pomere nenge hotonga ana hetoronga mur te teke Kristus i Teuit tuna? ");
INSERT INTO uvl_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Iange Teuit i sipona heleia lo nga alalaha nenge Sam ke teke, “‘NeHalang hele lange ak Non Soke: “Oat ke oare lakoi nga ilik hele nenga tamalmal. ");
INSERT INTO uvl_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Pe e mene lem ngarang mur at ke apem ana nge otal hekeke ia. Pe o hepapar hite iri.” ’ ");
INSERT INTO uvl_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Pe Teuit hetue i ke i ana Non Soke, ke pomere nge i Teuit tuna?” ");
INSERT INTO uvl_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Iok, hulua lochloch ngana te longlongo pe Iesus hele lange nena hana mur nenge hetottore iri, ");
INSERT INTO uvl_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Anau ala amo ke nek toto nge hotonga ana hetoronga mur. Hana nemur, muteria toto nge te heronia hengeron sase ngana mur ke tei raraia pe lemeria toto nge hehei pe hana tepoi ke nek toto lange iri nga ingala munna mur. Pe muteria nge teare nga muka toto nga hehei pe hana mataria nga NeHalang nena pele palaungana letena. Pe pule muteria toto nge te lohot ke iri hana papalauna nga ngaunga matana ana etue ke te ngaua ngaunga nge nek toto. ");
INSERT INTO uvl_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Pe iri, tenau sio mene pakar mur pe te teke te lolochia reria ure mur. Pe te hetalaulau ke mala toto ke hulua te esia iri pe te teke iri hana urana ngana mur. Iri nemur, lape NeHalang tunge tuangachol poreke ngana toto lange iri nga hoena.” ");
INSERT INTO uvl_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Iok, Iesus tu nga NeHalang nena pele palaungana letena pe esia hana nenge reria ure halang toto nge tesau sisio umtutuna. Pe iri tesau sue umtutuna nemur ke pomanga reria tunginga nenge lange NeHalang. ");
INSERT INTO uvl_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Pe Iesus esia hei pakar una e nge la pe sau sio ke umtutuna kinkino ngana nai. ");
INSERT INTO uvl_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Ol pe hele, “E hele lange imo pengpeng. Hei pakar nei, sau teu ke umtutuna halang toto nge hana nemur. ");
INSERT INTO uvl_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Iange iri lochloch ngana tesau teu umtutuna pe reria umtutuna halang makura. Pe atong hei pakar nei, nena umtutuna unne nenge mama laka sau hot eule nem lo pe e ero ol.” ");
INSERT INTO uvl_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Iok, Iesus nena hana mur hel te heleleia NeHalang nena pele palaungana neu nge te teke nakuna urana toto. Iange te hemalmalia nga um nge singina chalemlem pe nga tunginga mur nenge lange NeHalang. Pe Iesus hele lange iri, ");
INSERT INTO uvl_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Ure lochloch nenge a esia nem lape tuke mau ero ol. Lape tetoto sue pe ute pele nge tunga munna ero ol.” ");
INSERT INTO uvl_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Pe Iesus nena hana mur te ontei, “Non soke, nge ngingie ol pe lape ure nemur te lohot? Pe lape utar lohot tala ke mo esia pe mo eteia ke ure nei rochroi nge lape lohot?” ");
INSERT INTO uvl_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Pe Iesus hele, “Anau ala ke nek iange lape hana hel te pallakaia imo. Hana halang lape teat pe te hele nga ek ke te teke, ‘Iau Kristus nenge a kulelele! Etue nem, ngana koi at lo.’ Te hele ke pomam pe imo a longo tau pulute iri ero! ");
INSERT INTO uvl_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Nenge teke a longe ure meena ngana pe palinga hel pingana nge lohot, samo loiloi ero pe a matau ero pule. Iange ure nemur lape te lohot tala pe imo a teke ma etue hetala ngana. Pe i ero la.” ");
INSERT INTO uvl_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Pe Iesus hele lange iri pule, “Kileng mur lape tepal helel pe hana hel pule lape tepal hel luluch nge hana hel. ");
INSERT INTO uvl_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Lape mangila palaungana rurur pe uringa lohotot pe haleles poreke ngana lohot nga kileng lochloch. Pe ure hel nenge ta kolkolkol iri nge nike lape te herura hot mene ita nga tapa sana. ");
INSERT INTO uvl_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Ure nemur lape te lohot ero kura pe lape hana hel te laua imo pe te palia imo pe tepoi poreke tote imo. Pe lape te poia amo helenga palaungana nga hetoronga ana pele letena pe tetal teua imo nga tuele au ngana. Pe pule lape te mene imo lange naungaala ana hana mur pe hana nenge tenau elele kileng mur ke ames nga mataria. Iange imo lek hana mur imo pe a popoia ume nenge a hele hotote Helenga Urana Toto Ngana. ");
INSERT INTO uvl_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Ure nemur lape te lohot pe amo etue koloi nenge a hele hote Helenga Urana Toto Ngana nem. ");
INSERT INTO uvl_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Pe letemo tuanin rara sakilil ero nga utar nenge lape a heleia. ");
INSERT INTO uvl_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Iange iau lape e hemellehe letemo tuanin ngana pe e hepeng ia halimo ke a hele ke nek. Pe lemo ngarang nemur lape te longe lemo helenga pe te reng toktok mana ol. ");
INSERT INTO uvl_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Tetememo mur pe tatamo mur pe titimo mur pe alomo mur pe neingamo mur, lape tehul mule nge imo pe lape te tung heke imo langa hana soksoke ngana mur peria. Pe lape te hune hel nge imo ke te mete. ");
INSERT INTO uvl_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Pe hulua lochloch ngana lape lemeria ero ia imo iange lek hana mur imo. ");
INSERT INTO uvl_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Pe imo lochloch lape atu ke nek mana pe a mete toto ero. ");
INSERT INTO uvl_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Ames ke kerkereng iange letemo manmanna ngana nem lape hemas mule imo. ");
INSERT INTO uvl_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Nenge teke a esia palinga hel ana hana mur nge te heliliu hite kileng nge Ierusalem, a etei mene ke a teke lape kileng nem lape het. ");
INSERT INTO uvl_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Pe iri nenge tetu nge Iutea te ua ke telala nga hengene mur pe iri nenge te tunga kileng neu te ua hotot pe iri nenge tetu nge hot nga kileng hel teteu langa kileng nem ero ol. ");
INSERT INTO uvl_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Iange nga etue e lape NeHalang lape heneue Ierusalem mur nga letena inin ngana. Nem lohot ke pete tote nena helenga nenge tehas sue ke ulolo. ");
INSERT INTO uvl_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Atong hehei nemur nenge saria pe nenge te lololo peo kura, lape anali toto nge iri. Iange NeHalang letena inin taua kileng nem ke lape poia ure poreke ngana ke lohot nge iri. ");
INSERT INTO uvl_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Hana hel lape te hune iri nga kakop pe lape te laua hel pe te mene iri langa kileng hel. Pe hana lomona ngana mur lape te hekou susue iri nenge Ierusalem pe tehun lapue iri kela het nga etue nenge NeHalang talue ke teke het. ");
INSERT INTO uvl_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Pe ure heueu ngana hel nge te esesia iri ero, lape te lohot nga chaia matana pe teio pe itoch mur. Pe kileng lochloch ngana nga ich lape te matau tote ruach ana mee papalauna pe aria hutu mur. ");
INSERT INTO uvl_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Hehei pe hana lape ngaria lohot pe te matau toto nga utar nenge lape lohot nga ich nei. Iange chaia matana pe teio pe itoch mur te nanasia muria ero ol. ");
INSERT INTO uvl_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Pe nga etue nem lape Non Tuna lohot nga ulu pe at luluch nga nena kerkerenga palaungana pe nena hemalmalinga. ");
INSERT INTO uvl_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Ure nemur nenge te lohot tala nga Non Tuna at ngana, lape te lohotot. Pe nga etue nem pengpeng ames ke anau haka mana iange NeHalang ana etue nenge at ke mene mule imo, heroi lo.” ");
INSERT INTO uvl_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Iok laol, Iesus nene poponing e lange iri, “Anau langa ae keng pe ae hel pule. ");
INSERT INTO uvl_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Nga etue nenge ae perperna te rora mule, ta etei mene ke chaia ana etue at rochroi lo. ");
INSERT INTO uvl_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Ke pomalam mana nenge teke a esia ure nemur nge te lohotot, a eteia ke NeHalang nena naualanga urana ngana pe nena nekinga nge ita at rochroi lo. ");
INSERT INTO uvl_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“E hele ke manmanna toto lange imo. Imo hel nga etue nei lape atu kura pe ure nemur te lohot. ");
INSERT INTO uvl_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Tapa pe ich pe ure lochloch ngana lape tehet pe lek helenga mur lape tetu ke koko sapele.” ");
INSERT INTO uvl_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Iok laol, Iesus hele lange nena hana mur nenge hetottore iri, “Anau ala amo ke nek, nenge teke a ngau sakilil pe ain sakilil ke amo hauaua pe letemo tu mana nga atu ngamo nga ich nei, ure nemur lape te poia imo ke letemo meena toto. Pe lape etue palaungana nem at pe herura hot mene imo ke pomanga kie nenge palnga palau. ");
INSERT INTO uvl_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Pe etue palaungana nem lape lohot nge iri lochloch ngana nenge tetu nga kileng lochloch ngana nga ich. ");
INSERT INTO uvl_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Ke imo a nauala amo ke nek toto pe a hetalaulau ke kokoes. Pomalam lape ames ke kerkereng nga etue poreke ngana nenge atat. Pe lape a matau ero nga etue nenge a lohot nge iau Non Tuna.” ");
INSERT INTO uvl_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Nga etue lochloch Iesus hetottoro nga NeHalang nena pele palaungana pe nga ulei kokoes, i ke la mulmule nga hengene nge Oliua iange mama lamau nga miliko. ");
INSERT INTO uvl_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Pe nga uach uruna hehei pe hana te hoala at mulmule ke te longlongo Iesus nge hetottoro nga NeHalang nena pele palaungana letena. ");
INSERT INTO uvl_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Etue palaungana nenge te ngaua ngaunga menini ngana heroi lo nenge te hetue ke Ingatoto. ");
INSERT INTO uvl_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Pe tunginga ana hana mur aria papalauna mur pe hotonga ana hetoronga mur te teke te hune Iesus pe ero. Iange te mataua hulua nenge te koko ke te longlongo nga nena helenga. Pomalam te tango rara kue e nge lape te nanasia ke te hune i. ");
INSERT INTO uvl_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Iutas Iskariot i Iesus nena none nga nena hana analoch pe nai nem pe Satan teu heke i. ");
INSERT INTO uvl_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Ol pe la sapele nge tunginga ana hana mur aria papalauna mur pe palpal hussu mur nenge tenau ele NeHalang nena pele palaungana pe hele lange iri nga kue nenge lape tunge Iesus langa peria. ");
INSERT INTO uvl_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Pe hana nemur te iech toto pe te teke te olia i nga umtutuna. Pomalam iri lochloch ke tetal helenga sapele. ");
INSERT INTO uvl_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Tetal helenga ke het pe Iutas tango rara sapele kue e, nenge lape tunge Iesus langa peria nga etue nenge hehei pe hana iri ero. ");
INSERT INTO uvl_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Iok, etue nenga ngaunga matana nenga ngaunga menini ngana nem hot ke ulo pe etue nenge lape te hune Sipsip Tuna nenge Ingatoto ana at. ");
INSERT INTO uvl_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Pe Iesus kulosia Petrus iri nai Ioanes pe hele lange iri ke pomai, “Ala ke a tatalo ele ngaunga nenga Ingatoto ana ke ma nike ke tala pe tangau.” ");
INSERT INTO uvl_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Pe iri te ontei mule Iesus, “Lape mola ke mo tatalo ele ngaunga nem langai?” ");
INSERT INTO uvl_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Pe Iesus tuacholia, “Ai teu ke ala nga kileng neu pe none nge takisia ech kina lape saolia imo. Pe a nanas mene i ke a langa pele nenge i teu ia. ");
INSERT INTO uvl_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Pe a hele lange pele tokoninga nem ke a teke, ‘Non Soke hele ke pomai: Pele letena unne nenge lang mur teat pe te tutu ia tu langai? Iau pe lek hana mur lape moat ke mo ngaua ngaunga nenge Ingatoto ana nga lamam.’ ");
INSERT INTO uvl_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Pe i lape henonoua imo nga pele letena e nge soke pe ngaunga ana hatanga pe ure mur hel pule tema ke mataria purpur lo. Ke nga lamam a tatalo ele ngaunga mur ke tema nike.” ");
INSERT INTO uvl_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Iok laol, tela pe te hottaua ure lochloch ngana nge lohot ke pete tote Iesus hele ngana pe te tatalo ele ngaunga mur sapele. ");
INSERT INTO uvl_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Iok, etue nem at nenge te ngaua ngaunga nem. Pe Iesus iri ul nena hekulkulonga mur tela ke teare tala sio ke te heliliu hite ngaunga ana hatanga. ");
INSERT INTO uvl_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Pe Iesus hele lange iri, “Iau lape e takisia melmelenga palaungana pe e mete. Pe lemek toto ke ita ul ta ngau tele ngaunga nenga Ingatoto nei. ");
INSERT INTO uvl_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Iange lape e ngau mule ngaunga e nge pomai ero, kela het nga etue nenge NeHalang nena naualanga pe nekinga lohot. Pe ngaunga matana nei, luna lape lohot ke mallaha toto nga etue nem.” ");
INSERT INTO uvl_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Iok laol, Iesus mene eulinga pe hele urana toto lange NeHalang pe hele lange nena hana mur, “A mene ke imo lochloch ainia. ");
INSERT INTO uvl_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","E hele lange imo pengpeng, heueu nei pe laol, lape e in mule uain e nge pomai ero kela het nga etue nenge NeHalang nena naualanga pe nekinga lohot.” ");
INSERT INTO uvl_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Iok Iesus mene mioka pe hele urana toto lange NeHalang pe reke pe tunge lange nena hana mur pe hele ke pomai, “Iau mirak koi nga ngaunga nenge e tunge ke halaua imo. A ngaua pe letemo metene iau.” ");
INSERT INTO uvl_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Ke pomalam mana, te ngau ke het pe Iesus mene heke eulinga pe hele, “Eulinga nei, i NeHalang nena helenga tomunga hel nenge heueu ngana, nge eik lele ite nga e mete ngak. ");
INSERT INTO uvl_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Pe anau at, mele nenge lape tung heke iau langa hana porekreke ngana mur peria, ngana koloi kila luluch nge iau nga hatanga heueu nei. ");
INSERT INTO uvl_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Non Tuna lape mete ke pomanga NeHalang heleia lo, pe mele nenge tung heke Non Tuna lange hana porekreke ngana nemur, lape mene tuangachol nge poreke toto.” ");
INSERT INTO uvl_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Ol pe Iesus nena hana mur te ontei hel nge iri sapele, nga itei toto nenge lape poia poinga nei. ");
INSERT INTO uvl_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Chaungachai palaungana lohot nge Iesus nena hana mur nga itei toto nge iri nge lape lohot ke i palaungana. ");
INSERT INTO uvl_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Pe Iesus hele lange iri, “Hehei pe hana nga ich aria naungaala ana hana mur reria poinga pomai koi; iri siporia tetal heke iri ke iri soksoke pe reria kerkerenga palaungana toto. Pe te teke hehei pe hana lochloch te heto pekngaria mur ia iri. “Pe hana soksoke ngana mur, reria kerkerenga palaungana toto nge tenau ele reria hana mur. Pe hana soksoke ngana nemur hel, te heto heke iri siporia ke te teke iri reria kerkerenga palaungana toto nge tenau ele hehei pe hana! ");
INSERT INTO uvl_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Pe imo, a nanasia poinga nei ero. Mele nenge teke i palaungana poi ke manga aina kinkino ngana. Ke mele nenge teke i muka nge imo talsio tote i pe ume mule nge nena hana mur imo.” ");
INSERT INTO uvl_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Iok, Iesus onteia nena hana mur, “Itei nge i palaungana toto? Ngana kai mele nenge are mana pe kulele mene ana ngaunga mai? Eh! ngana kai mele nenge ichich ngaunga mai? Mele nenge i palaungana laka nenge are mana pe kulele mene ana ngaunga. Pe iau etu luluch nge imo ke pomanga mele nenge ichich amo ngaunga. ");
INSERT INTO uvl_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Imo ames ke kerkereng luluch nge iau lo nga etue lochloch ngana nenge ure meena ngana lohot nge iau. ");
INSERT INTO uvl_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Pe temek tunge kerkerenga palaungana at nge iau ke enau ele nena hana mur. Pe kerkerenga nenge temek tunge at nge iau nem lape e tunge lange imo pule. ");
INSERT INTO uvl_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Imo lape a ngau pe ain luluch nge iau nga ak ngaunga ana hatanga, nga etue nenge NeHalang nena hana mur lochloch teat ke te eukirau nga ngaunga matana nem. Pe lape etal heke tote imo nga lut ke a nauele mata analoch pe nai nenge Israel.” ");
INSERT INTO uvl_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Pe Iesus hele lange Simon nenge ene e pule Petrus, “Simon o longo at, Non Poreke ngana lemene toto ke totoi ia imo. Pe i teke poia imo ke pomanga non nenge rur hotote uit nganangana nga paena. ");
INSERT INTO uvl_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Pe iau e hetalaulau amo lange NeHalang ke letemo manmanna ngana nem lape tu ke kerkereng. Pe nga etue nenge ohul mule letem, ola ke o hekerkereng mule pekngam mur leteria.” ");
INSERT INTO uvl_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Pe Petrus hele, “Non Soke, iau etu ke e angala mana nga utar nenge lape lohot. Nenge teke te mene iong langa tuele au ngana lape te mene iau la pule. Pe nenge teke te hune iong lape te hune iau pule.” ");
INSERT INTO uvl_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Pe Iesus hele lange Petrus, “E hele pengpeng lange iong, lape pareo tang ero kura pe o pallaka ke hemol ke o teke o eteia iau ero.” ");
INSERT INTO uvl_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Ol pe Iesus hele lange nena hana mur, “Nga etue nenge e kulos hote imo pe a patpata mana, a amneia ke pomere?” Pe iri te hele, “Mo amneia ke ute pele alpapa taua imem ero.” ");
INSERT INTO uvl_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Pe Iesus hele, “Iok heueu nei a mene lemo umtutuna mur pe amo hetanga mur. Pe mele nenge nena palinga hel ana kakop ero, mene nena hengeron kela teolia pe olia nena kakop e nga hengeron nem uruna. ");
INSERT INTO uvl_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Iange tehas ia nga NeHalang nena alalaha lo ke lape lohot ke manmanna toto nge iau. Helenga nem hele ke teke, ‘Hulua lape te esia i ke pomanga kemenge kina e.’” ");
INSERT INTO uvl_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Pe Iesus nena hana mur te hele, “Non Soke onau at, palinga hel ana kakop nai iloi.” Pe Iesus hele, “Het pam lo la!” ");
INSERT INTO uvl_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Iok laol, Iesus pe nena hana mur te lohaka nga kileng neu pe tei ke tela nga hengene nge Oliua ke pomanga tela hemulmule ngaria. ");
INSERT INTO uvl_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Tela ke te lohot nga kileng neu pe Iesus hele, “A hetalaulau ke NeHalang hekerkereng ia imo nga totoinga poreke ngana mur.” ");
INSERT INTO uvl_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Ol pe Iesus hile sue nena hana mur pe i hot ke kangkanga aria pela tualou sio pe hetalaulau ol. ");
INSERT INTO uvl_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Iesus hetalaulau ke mai, “Euo Temek O! Nenge teke lemem, opoi ele melmelenga palaungana nei ke lohot nge iau ero! Pe o nanasia lemek ngak ero, o nanas mene iong sipom lemem ngam.” ");
INSERT INTO uvl_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Ol pe NeHalang nena angkelo e lohot nge Iesus ke hekerkereng ia i. ");
INSERT INTO uvl_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Pe Iesus letena meena toto pe hetalaulau ke kerkereng toto pe hines sio porekeia i ke pomanga eina nge lele sio ke lala nga ich. ");
INSERT INTO uvl_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Ke het pe lohaka pe i la mule nge nena hana mur. Iesus la pe nena hana mur te mamani lo iange leteria meena toto. ");
INSERT INTO uvl_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Ol pe Iesus hele lange iri, “A mamani ia utar? A lohaka pe a hetalaulau ke NeHalang hekerkereng ia imo nga totoinga poreke ngana mur.” ");
INSERT INTO uvl_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Iesus helele kura pe hulua tei at nge i. Pe Iutas, Iesus nena none nga hana iri analoch pe nai nem, i mukaia iri. Iok, Iutas teke la ke lau haka nge Iesus ");
INSERT INTO uvl_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","pe Iesus hele lange i, “Iutas, nga poinga nenge olau haka nge iau nei, o tung heke Non Tuna langa hana porekreke ngana mur peria.” ");
INSERT INTO uvl_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Pe Iesus nena hana mur te esia hulua neu pe te hele, “Non soke! Ta potar mai ol! Mo palia iri nga kakop?” ");
INSERT INTO uvl_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Ol pe elle nge iri mene kakop ke teke hune non soke Kaepas nena none pe kakop mene hot mene talngana nenga tamalmal. ");
INSERT INTO uvl_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Ol pe Iesus hele, “Apoi ke pomam ero!” Pe penna langa non neu talngana pe hemas mule. ");
INSERT INTO uvl_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Ol pe Iesus hele lange tunginga ana hana mur aria papalauna mur pe palpal hussu mur nenge tenau ele NeHalang nena pele pe hana papalauna hel pule nenge teat ke te laua i neu ke teke, “Imo mam a mene huninga hel ana kakop mur pe lemo tukmaul mur ke at a laua iau ia? E hunun hana pe e kemkeme kai? ");
INSERT INTO uvl_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Etu luluch nge imo ke kokoes mana nga NeHalang nena pele palaungana pe pomere a laua iau ero? Pe heueu nei, amo etue ol koi. Iange imo ul non poreke ngana a ume ke kerkereng toto nga etue nei.” ");
INSERT INTO uvl_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Iok laol, te laua Iesus pe te mene i langa tunginga ana hana mur aria ae huna nena pele. Pe Petrus i ke nanas ia iri. ");
INSERT INTO uvl_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Ol pe Petrus iteu langa pele neu koana nge hot. Pe tetun hite oan ke remenmen nga kileng unne neu. Pe Petrus lake halel oan luluch nge iri nenge te halelel neu. ");
INSERT INTO uvl_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Pe heie nge umume lamau esia Petrus pe nachnei hit tote i pe hele, “Non nei, kokoko nge Iesus pule koi, enau urume i!” ");
INSERT INTO uvl_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Pe Petrus hele, “Hei nem, iau mam e kokoko nge non nem ia? E eteia i ma? E eteia i ero toto i!” ");
INSERT INTO uvl_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Mala pol sunem pe none esia Petrus pe hele lange i, “Iong pule, iong elle nge iri nenge te nananas ia Iesus!” Pe Petrus hele, “Ah! Iau ero i!” ");
INSERT INTO uvl_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Etue sase pol lo pe none pule esia Petrus pe hele ke kerkereng toto ke teke, “Manmanna toto ke non nei kokoko nge Iesus iange i pule nena nge Kalelea!” ");
INSERT INTO uvl_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Pe Petrus tuacholia, “Non nem, e eteia ure nenge o helele ia ero i!” Petrus helele kura pe pareo tang sapele. ");
INSERT INTO uvl_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Ol pe Iesus nau hot la pengpeng nge Petrus pe Petrus letena metene sapele Iesus nena helenga nenge heleia lange i, “Lape pareo tang ero kura pe o pallaka ke hemol ke o teke o eteia iau ero.” ");
INSERT INTO uvl_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Ol pe Petrus ua hot sapele nga kileng unne neu pe tang ke teke mete. ");
INSERT INTO uvl_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Iok, hana nenge tenau elele Iesus neu, te songlele ule i pe tepal ule i. ");
INSERT INTO uvl_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Pe te kale ele matana pe te hele lange i, “O hele, itei palia iong!” ");
INSERT INTO uvl_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Pe tesau hote helenga poreke ngana hel pule lange i. ");
INSERT INTO uvl_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Iok laol, uach sio pe tunginga ana hana mur aria papalauna mur pe hotonga ana hetoronga mur pe hana papalauna mur hel pule te eukirau. Pe iri nenge tenau elele Iesus te mene i kela mes nga hana nemur mataria. ");
INSERT INTO uvl_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Te mene i kela mes pe te onteia i, “Iong nge iong Kristus mam lom? Ae!?” Pe Iesus tuacholia, “Nenge teke e hele lange imo lape letemo manmanna nga lek helenga ero toto. ");
INSERT INTO uvl_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Pe nenge teke e onteia imo nga onteinga e lape a tuacholia ero toto pule. ");
INSERT INTO uvl_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Talun heueu ke laol, Non Tuna lape are nga NeHalang nenge kikina toto hilina ele nenga pen tamalmal.” ");
INSERT INTO uvl_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Pe hana nemur te ontei mule i, “Eke iong mam, iong NeHalang Tuna ma?” Pe Iesus tuacholia, “Imo sipomo a hele ke a teke iau NeHalang Tuna.” ");
INSERT INTO uvl_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Pe hana nemur te hele, “A longo la! Ita sipora ta longe helenga nei nge lohot nga i sipona hanna ke het lo. Ke ta mene mele ero ol.” ");
INSERT INTO uvl_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Iok laol, Iri hana papalaungana nemur te lohaka pe te mene sapele Iesus lange Pilatus. ");
INSERT INTO uvl_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Te mene i ke la mes nga Pilatus matana pe te hele ke te teke, “Non nei, mo hottaua i nge chanangaia hehei pe hana nenge ita ke teare ngaria poreke toto. Pe hele ele iri ke tesau umtutuna lange ne Kaesa ero. Pe pule hele ke teke i sipona i Kristus pe i naungaala ana non.” ");
INSERT INTO uvl_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Ol pe Pilatus ontei sapele Iesus. “Ae, Iuta mur aria naungaala ana non ma iong mam?” Pe Iesus hele, “Iong sipom o hele hote helenga nem.” ");
INSERT INTO uvl_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Ol pe Pilatus hele lange hana papalauna nemur pe nge hulua lochloch ngana nemur ke pomai, “Iau e hottaua ute e nge non nei poia ke poreke ero.” ");
INSERT INTO uvl_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Pe hana papalauna nemur te hele ke kerkereng toto ke pomai, “Non nei hetoro ngana poia hehei pe hana ke teare poreke nga kileng lochloch ngana nge Iutea! Talune nge Kalelea ke ngana koi atat nei lo!” ");
INSERT INTO uvl_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pilatus longe hana nemur nge te hele ke pomau pe ontei, “Non nei mai nena nge Kalelea kai?” ");
INSERT INTO uvl_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Ol pe Pilatus kulosia Iesus lange Herot iange eteia lo ke Iesus at nge Kalelea. Pe Herot nge nauele kileng Kalelea. Pe pule nga etue nem, Herot tu nge Ierusalem lo. ");
INSERT INTO uvl_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Herot esia Iesus pe letena iech toto iange longlonge Iesus pingana nga halang nike pe kolkol mana nakuna pe heueu nei esia i ol. Pe i lemene toto nge teke nau Iesus nge popoi mirakulo. ");
INSERT INTO uvl_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Ke pomalam Herot onteia Iesus nga onteinga halang pe Iesus tuacholia i ero toto. ");
INSERT INTO uvl_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Pe tunginga ana hana mur aria papalauna mur pe hotonga ana hetoronga mur temes haka pe te hele poreke tote Iesus. ");
INSERT INTO uvl_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Pe Herot pe nena palinga hel ana hana mur te songlele ule i pe te heron heke hengeron e nge uruna haka toto lange i pe kulos mule i ke lange Pilatus. ");
INSERT INTO uvl_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Pe Herot iri nai Pilatus, nge nike tenau hel ke nek erochro iange iri nai tehun helel. Pe nga etue nenge Iesus poi ke mai, iri nai tenek hel mule nge iri. ");
INSERT INTO uvl_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pilatus eukiraua tunginga ana hana mur aria papalauna mur pe hana papalauna hel pule pe hehei pe hana. ");
INSERT INTO uvl_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Pe hele lange iri ke pomai, “Imo, a mene non nei at nge iau pe a hele ke a teke, Non nei channangnanga ia hehei pe hana ke teare poreke toto. Pe heueu nei, imo lochloch ngana ames pe e ontei hote i nga matamo, pe e hottaua ute e nge non nei poia ke poreke ero toto. ");
INSERT INTO uvl_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Herot pule eteia ke non nei poia poinga poreke ngana e ero, ke ngana koi nenge kulos mule i at nge ita. Toinge non nei poia poinga poreke toto ngana e lape ta hune i ke mete pe nei ero koi. ");
INSERT INTO uvl_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Pomalam lape e hele lange lek palinga hel ana hana mur ke tenos ulu mene i pe i la mana ol.” ");
INSERT INTO uvl_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Kokoes, nga ngaunga matana nem ana etue, Pilatus popoia poinga nenge hile hotote non elle nga tuele au ngana lala nge iri Ierusalem mur. ");
INSERT INTO uvl_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Ol pe hehei pe hana lochloch alngaria haka ke pomai, “A hune i ke mete! Pe a tung hote Parapas at nge imem!” ");
INSERT INTO uvl_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(Parapas tetal teua i nga tuele au ngana iange poi heke palinga palaungana nge Ierusalem pe hune none ke mete.) ");
INSERT INTO uvl_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilatus hele hot mule letena lange hehei pe hana nga nenge teke hune Iesus ero. ");
INSERT INTO uvl_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Pe ero. Hulua nemur alngaria haka mule ke pomai, “A heon heke i! A heon heke i!” ");
INSERT INTO uvl_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Ol pe Pilatus hele hemol ngana mule lange iri, “Non nei poia poinga poreke ngana e nge uruna metenga ero koi! Lape e hele lange lek palinga ana hana mur ke te nos ulu mene i pe te kulosia i ke la mana ol.” ");
INSERT INTO uvl_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Pe ero. Hulua nemur te alngaria ke soke toto ke te heon heke Iesus. Ol pe aria sosolos ala ngana neu, lohot ke manmanna sapele. ");
INSERT INTO uvl_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Ke Pilatus hele ke teke poia utar nenge hulua nemur lemeria taua. ");
INSERT INTO uvl_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Mene hote Parapas nem nga tuele au, pe tung hote lange hulua nemur. Pe tunge Iesus lange iri ke te poia i nga lemeria ngana. ");
INSERT INTO uvl_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Ol pe te mene hote Iesus nga Pilatus na pele sapele. Tei ke tela pe te saolia Simon nenge nena nge Sirini. Ana non mule nga kileng nemur nge hot ke teu atat. Te laua i pe te poia i ke takisia Iesus ana manga toto. Te poia i pule ke nanas menmene Iesus. ");
INSERT INTO uvl_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Hulua halang toto iri hul hehei hel te nanasia Iesus. Hehei nemur leteria porekeia Iesus pe te tang ke soke toto. ");
INSERT INTO uvl_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Ol pe Iesus hulia i ke nau lange iri pe hele lange iri, “Imo hehei nenge Ierusalem, a tangia iau ero. A tangia imo sipomo pe tutumo mur. ");
INSERT INTO uvl_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Iange etue nei koi atat nenge lape hehei pe hana te hele ke teke, ‘Iri hehei nenge tehoho ero ke tuturia mur ero, te iech toto ol!’ ");
INSERT INTO uvl_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Nga etue nem, hehei pe hana lape te hele langa hengene mur ke teke, ‘O losio aka nge imem.’ Pe pule, te hele langa sasana mur ke te teke, ‘Otal kome imem.’ ");
INSERT INTO uvl_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Ure nemur nenge a esia heueu nei, lohot nga etue nenge ae itach kura. Pe etue nem lape at nga ae kalum ngana. Pe etue nem lape poreke toto.” ");
INSERT INTO uvl_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Palinga hel ana hana mur te mene hote hana porekreke ngana mur nai kela te heon luluche iri nge Iesus. ");
INSERT INTO uvl_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Iok, tei kela te lohot nga kileng nenge ene “Kittol” pe te heon haka sapele iri. None heon nga Iesus ilina hele nenga pen tamalmal pe e nga Iesus ilina hele nenga pen hoioi ");
INSERT INTO uvl_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Iesus hele, “Temek, letem ia iri, te eteia utar nenge te poia nei ero.” Iok laol, palinga hel ana hana nemur te hesalangia Iesus nena hengeron pe te saua oio paena pe ana maelepa lohot ke tenau nge itei nenge lape mene Iesus nena hengeron mur. ");
INSERT INTO uvl_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Hulua halang toto temes ke te nachnau pe hana papalauna nemur te hesalang langia Iesus pe te hele ke machmai, “I, hemaul mule hulua halang lo. Iok, nenge teke i Kristus nenge NeHalang kulosia at, tanau nge i sipona hemaul mule i!” ");
INSERT INTO uvl_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Iok, palinga hel ana hana nemur te hesalang ule i pe te tunge uain ehech ngana lange i. Pe te hele lange i, ");
INSERT INTO uvl_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","“Nenge teke Iuta mur aria naungaala ana non iong, o halaua iong sipom!” ");
INSERT INTO uvl_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Pe tetal heke helenga nei nga Iesus hou ngana, “IUTA MUR ARIA NAUNGAALA ANA NON KOI NEI.” ");
INSERT INTO uvl_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Ol pe non elle nge iri nai nenge te heon luluch nge Iesus neu, hele inin taua Iesus ke pomai, “Nenge teke iong Kristus, o halaua iong sipom pe imem pule!” ");
INSERT INTO uvl_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Pe neingana hele inin tau mule i ke teke, “Iong mam, o hele ke mam pe o mataua NeHalang ero ma? Ita ta takisia melmelenga elle mana koi. ");
INSERT INTO uvl_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Pe ita nai, te poia poinga nei at nge ita ke pete tote rera poinga poreke ngana mur. Pe Iesus poia poinga poreke ngana e ero pe takis mene melmelenga nei.” ");
INSERT INTO uvl_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Ol pe ana non loaka pe hele la sapele nge Iesus ke pomai, “Iesus, lem naualanga pe nekinga nge urana toto at pe letem metene iau.” ");
INSERT INTO uvl_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Pe Iesus hele lange i ke teke, “E hele ke manmanna toto lange iong, heueu nei lape otu luluch nge iau nge Paratiso.” ");
INSERT INTO uvl_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Nga chaia matana heurunga ngana, chaia tua ero pe chantom palaungana ma hite kileng lochloch kela chaia matana palele. ");
INSERT INTO uvl_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Pe huunga ala palaungana nenge heon teu nga NeHalang na pele letena, chach nga lut kela het nge sio ke sachana nai. ");
INSERT INTO uvl_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Ol pe Iesus alangana hot ke palaungana toto ke pomai, “Temek, e tung mene iau lange iong ol.” Iesus hele ke pomai pe mete sapele. ");
INSERT INTO uvl_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Palinga hel ana hana mur aria non soke esia ure nei nge lohot pe heto heke NeHalang pe hele sapele, “Manmanna toto ke non nei i non urana ngana toto!” ");
INSERT INTO uvl_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Pe hulua lochloch ngana nenge te emurungrung lamau te esia ure neu nge lohot pule. Pomalam tei ke tela mule nga reria kileng pe te palpalia mauturia iange leteria milang toto ia Iesus. ");
INSERT INTO uvl_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Iri nenge te etei tote Iesus pe hehei nenge te nanasia Iesus at nge Kalelea, temes ke kangkanga mana pe tenau manmana nga ure nemur nge te lohotot. ");
INSERT INTO uvl_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Iok, non urana ngana e ene Iosep. I, nena nge Arimatea, nga kileng nenge Iutea. Ana non, nanas tau tote NeHalang nena hotonga mur pe tu ke kulkulele mene NeHalang nena naualanga pe nekinga nge lape lohot. Pe i pule, tuteu luluch nge hana papalauna nenge te popoia Iesus ana helenga pe singiria sisisia i ke te teke te hunune i. Pe ana non letena urana ero nga helenga pe poinga poreke ngana nenge hana nemur te poia lala nge Iesus. ");
INSERT INTO uvl_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Ana non i kela lohot nge Pilatus pe onteia i nga Iesus koluna. ");
INSERT INTO uvl_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Ol pe i ke langa kileng nenge hana te heon heke Iesus ia pe lo losio sapele Iesus koluna. Ke het pe ruchit sapele, pela tal teua nga polo heueu ngana e nge te rech teua nga um ilina. (Polo neu, te poia ke hana nenge te metmete koluria ana ia nike.) ");
INSERT INTO uvl_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Tealo hite Iesus nga Praete, pe i etue nenge Israel mur tetu ke te tatalo ele Sapat ana etue. Pe etue palaungana nem heroi lo. ");
INSERT INTO uvl_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Pe hehei nenge te nanasia Iesus nge Kalelea nike tela luluch nge Iosep ke tenau nga Iesus ana polo pe tenau nga Iesus koluna nge tetal teua. ");
INSERT INTO uvl_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Ke het pe tela mule ke te mene ure nemur nenge inangaria ehech nenge lape teun hite nga Iesus koluna. Ke het pe tetutu sio mana ol. Iange iri te nanasia hotonga nenge Moses has sue ke teke te ume ero nga Sapat ana etue. ");
INSERT INTO uvl_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Nga Sante nga uach uruna toto, hehei nemur te mene ure inangana ehech ngana nemur pe te hoala ke te teke tela tenau Iesus koluna. ");
INSERT INTO uvl_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Tei ke la te lohot nga kileng nenge Iesus koluna maia, pe um nenge are ele polo anna, ma kelkel pe polo anna pangpanga mana ol. ");
INSERT INTO uvl_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Iok laol, tei teu la pe te tango rere Iesus koluna pe te hottaua ero. ");
INSERT INTO uvl_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Temes ke leteria tuaninin pe hana nai nge reria hengeron sinaala toto te lohot ke temes luluch nge iri. ");
INSERT INTO uvl_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Ol pe hehei nemur te rura manaia iri pe te matau toto pe te tualou sio pe te puosue palpalria langa ich. Pe hana nai neu te hele lange iri ke pomai, “Pomere? A tango rere itei? Kileng nei metenga ana kileng koi pe pomere toto nenge o tango rere I nenge maulul. ");
INSERT INTO uvl_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Pe non nem i ero lamai pule. Ngana kou maul haka mule lo. Letemo metene nena helenga mur nge heleia lange imo pule? Nga etue nenge tu luluch nge imo nge Kalelea, ana non hele ke teke, ");
INSERT INTO uvl_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‘Lape te tunge Non Tuna langa hana porekreke ngana mur peria, ke lape te heon heke i ke mete. Pe nga etue mol ngana nga hoena lape maul haka mule.’” ");
INSERT INTO uvl_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Ol pe leteria metene sapele Iesus na helenga nemur. ");
INSERT INTO uvl_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Hehei nemur tela mule pela te heleia ure lochloch ngana nei lange Iesus nena hana mur pe nge hulua lochloch ngana nenge te nananas ia Iesus. ");
INSERT INTO uvl_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Maria Mantalena pe Ioana pe Maria nenge Ieims tana pe hehei hel pule nenge tela luluch nge iri, te nana hote ure lochloch ngana nei lange Iesus nena hana mur. ");
INSERT INTO uvl_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Te nene pe Iesus nena hana mur leteria manmanna nga nananga nei ero, iange te teke hehei nemur te hele ngaria tang ke pomanga aria hauaua. ");
INSERT INTO uvl_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Ol pe Petrus lohaka pe song ke teke la ke nau nga polo nenge Iesus koluna mateuia. La ke tatuch sio ke teke nau pe um ponna ngana neu nganngana ero ol. Pe es mene ruchinga hit nenge te ruchit Iesus ia nge masio mana ol. Petrus esia ke mau pe letena hul rara ia ke halang pe ua ke la mule. ");
INSERT INTO uvl_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Iok, nga etue neu pengpeng Iesus nena hana nai tei ole ke te lala nga kileng e nge ene Emaus. Pe kileng neu tu ke sase pol nge Ierusalem. ");
INSERT INTO uvl_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Pe iri nai tei olole pe te heleleia ure lochloch ngana nenge lohot lo. ");
INSERT INTO uvl_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Iok, iri nai tei ke te hele tele helelia pe Iesus lohot nge iri, pe heroi taua iri kela iri ul tei ape. ");
INSERT INTO uvl_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Pe nena hana nai neu te etei hilia i ero. Te esia i pe te teke non pele mana. ");
INSERT INTO uvl_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Ol pe Iesus onteia iri nai, “Imo nai ai olole pe a hele tele helel ia utar?” Pe iri nai nakuria poi koukou mana pe temes. ");
INSERT INTO uvl_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Elle nge iri ene Kleopas. Iok, i nenge ene Kleopas lohaka pe hele, “Atong! Iong lape oi lang at nge Ierusalem heueu mana kai, nenge oetei ero nga ure nemur nenge te lohotot lamai?” ");
INSERT INTO uvl_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Pe Iesus ontei, “Iong mam o heleleia utar mur nenge te lohotot mam?” Pe iri nai te tuacholia, “Mo heleleia laka ure nemur nenge lohot nge Iesus nenge Nasaret. Non nei i NeHalang nena hetatalonga. Iange ure lochloch ngana nenge heleia pe poia henonou hote ke i mene kerkerenga nenge NeHalang. Pe ana helenga song ke hehei pe hana lochloch te longe. ");
INSERT INTO uvl_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Tunginga ana hana mur aria papalauna mur pe hana nenge tenau elele imem, te poia ana helenga ke te teke mete. Pomalam te heon heke i. ");
INSERT INTO uvl_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Pe imem lochloch ngana letemem manmanna ke i toto koloi, nenge lape mene mule Israel mur lochloch. Pe lape ero ol. Onau ure nenge lohot nem ana etue mol ngana koi heueu nei. ");
INSERT INTO uvl_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","“Pe hehei hel nge imem te herura mene imem. Iange nga uach uruna te oala ke te teke tenau toto nga um ponna nenge tetal teu Iesus koluna ia. ");
INSERT INTO uvl_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Tela pe te rere Iesus koluna pe te hottaua ero. Iok, teat mule pe te teke tenau operia ia NeHalang nena angkelo mur nge te hele lange iri ke te teke, ‘Iesus maul haka mule lo.’ ");
INSERT INTO uvl_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Ol pe mele hel pule nge imem tela ke tenau toto nga um ponna neu pule. Pe te esia ke ure lochloch ngana lohot ke pete tote hehei nemur te hele ngaria. Ke iri pule te kolkol Iesus koluna.” ");
INSERT INTO uvl_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Ol pe Iesus hele lange iri nai, “Imo nge lape letemo matana ngana unne ero iam, iange anali toto nge imo pule nge letemo manmanna nga ure lochloch ngana nenge hetatalonga mur te heleia. ");
INSERT INTO uvl_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Pomere? Imo nge a eteia ero kai? Toinge letemo matana pol, a eteia ke Kristus lape mene melmelenga palaungana tala, pe nga hoena, mene kerkerenga palaungana toto nge NeHalang.” ");
INSERT INTO uvl_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Ol pe Iesus hele hote asinga nemur nenge te heleleia i. Talune nga alalaha nenge Moses hasia kela het nga alalaha nenge hetatalonga mur tehas ia. ");
INSERT INTO uvl_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Iok, tei ke te heroi langa kileng nenge Emaus pe Iesus poi ke malaka nga i ke lala nga kileng e nge tunga tau kura. ");
INSERT INTO uvl_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Ol pe iri nai te hele ele i ke te teke, “O iat ke otu luluch nge imem muka, iange chaia matana puluch sisio lo i.” Pomalam Iesus lake tu luluch nge iri. ");
INSERT INTO uvl_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Iok laol, Iesus are sio ke ngau luluch nge iri, pe mene ngaunga pe hele urana toto lange NeHalang pe reke pe tunge lange hana nai neu. ");
INSERT INTO uvl_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Ol pe hana nai neu te esia Iesus nge poi ke pomau pe ngaria lohot. Pe te etei sapele ke non neu i Iesus. Te eteia ke i Iesus ol pe erue sio ke te kolkolia i sapele. ");
INSERT INTO uvl_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Ol pe iri nai te hele, “Tai olole nga kue nem pe ita nai letera iech toto nge ta longe i nge hele urumrume hasinga nemur, pe hemallaha hote luna mur atat nge ita.” ");
INSERT INTO uvl_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Iok, ol pe te lohaka sapele ke tela mule nge Ierusalem. Tela pe te lohot nge Iesus nena hana iri analoch pe elle nge te emurungrung luluch nge hulua nemur nenge te nanasia Iesus. ");
INSERT INTO uvl_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Pe te hele ke te teke, “Manmanna ke Iesus maul haka mule lo! Ke ngana laka nenge hetei hote i lange Simon!” ");
INSERT INTO uvl_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Iok, Iesus nena hana nai neu te hele hote utar nenge lohot nge iri nga kue nenge lala nge Emaus, pe pule te hele ururume te etei ngaria ia Iesus nga etue nenge reke ngaunga pe tunge lange iri. ");
INSERT INTO uvl_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Te helele kura, pe Iesus lohot ke mes luluch nge iri pe hele lange iri, “Lek miliko palaungana lange imo lochloch ngana.” ");
INSERT INTO uvl_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Pe iri lochloch ngana nemur te rura pe te matau toto iange te esia Iesus pe te teke ma moiuk. ");
INSERT INTO uvl_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Ol pe Iesus hele lange iri, “A mataua utar? Pomere nenge letemo manmanna ero?” ");
INSERT INTO uvl_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","40","Pe Iesus heteia penna pe apena lange iri pe hele, “Anau at nga perik pe apek, iau toto kai nemai. Pe a ra nga singik, moiuk pele mes hotia nganangana ke mange iau ero.” ");
INSERT INTO uvl_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Iesus hele ke mau pe hulua nemur leteria nachnai kura iange te iech toto. Ol pe Iesus onteia iri, “A talue ngaunga unne kau?” ");
INSERT INTO uvl_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Pe te mene ruo kalum ngana elle ke te laia nge i. ");
INSERT INTO uvl_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Iok laol, Iesus mene ruo neu pe ngau sapele nga hulua nemur mataria. ");
INSERT INTO uvl_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Ke het pe hele lange iri, “Ure nenge etu luluch nge imo pe e heleleia, ngana koi lohot nei. Iange hasinga nenge Moses pe hetatalonga mur pe nga alalaha nenge Sam te tuatautaua iau. Pe ure nemur lape te lohot ke mamanna nga NeHalang lemene ngana.” ");
INSERT INTO uvl_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Ol pe Iesus helete metene iri ke te eteia NeHalang nena helenga mur. ");
INSERT INTO uvl_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Pe hele lange iri ke pomai, “Helenga nenge tehas sue, tang ke mai koi: Kristus lape takisia melmelenga palaungana ke mete pe nga etue mol ngana lape maul haka mule. ");
INSERT INTO uvl_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Pe nga i sipona na kerkerenga lape te haliu hote nena helenga ke pomai, ‘A hulia letemo nga lemo poinga poreke ngana mur. Pomalam lape NeHalang letena porekeia imo pe saua lemo poinga poreke ngana mur ke te lasus toto.’ Helenga nemur lape te haliu hot tele nge Ierusalem ke het pe langa kileng lochloch ngana nga ich. ");
INSERT INTO uvl_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Pe imo sipomo anau urume ure nemur lo. Ke lape a haliu hote ol. ");
INSERT INTO uvl_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Pe iau lape e hekulo sue utar nenge temek hele ke teke tunge lange imo. Pe imo atu lakoloi. Iange Opepengpeng lape sio at nga lut ke hekerkereng tote imo, ke het pe a laol.” ");
INSERT INTO uvl_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Iok, ol pe Iesus mene hote nena hana mur nge Ierusalem ke tela rochroi nge Petani. Pe nga lamau, Iesus tul heke penna pe pete iri lochloch. ");
INSERT INTO uvl_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Iesus petpete iri kura pe hile iri pe lohaka la sapele ke langa lut nga tapa. ");
INSERT INTO uvl_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Pe hehei pe hana nemur te heto heke tote i nga lamau. Ke het pe tela mule nge Ierusalem. Tela mule pe iechinga palaungana toto lohot nge iri. ");
INSERT INTO uvl_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Ke kokoes tetu manmanna nga NeHalang nena pele palaungana ke te heto hekeke i. ");
INSERT INTO uvl_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Nga talun ngana toto ure lochloch ngana te lohot ero kura pe Helenga nem tu ke ulolo. Helenga nem tu luluch nge NeHalang pe i sipona i NeHalang. ");
INSERT INTO uvl_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","I tu luluch nge NeHalang nga talun ngana toto. ");
INSERT INTO uvl_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Nge i mana, NeHalang ala hote ure lochloch ngana. Ke ure lochloch ngana nei lohot nga kue e nge altoto ero ol. ");
INSERT INTO uvl_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Pe maulinga lochloch ngana huna nge i toro. Pe maulinga nem, tunge lemenge lange hehei pe hana lochloch. ");
INSERT INTO uvl_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Pe lemenge nem tualeme nga kileng au ngana. Pe kileng au ngana kikina ngana nenge poi hele lemenge nem nge ita ero. ");
INSERT INTO uvl_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Iok, NeHalang kulosia none ke at. Ana non ene laka Ioanes. ");
INSERT INTO uvl_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Pe i at ke hele hote Lemenge nem ke hehei pe hana lochloch te longe nena helenga pe leteria manmanna. ");
INSERT INTO uvl_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Pe Ioanes i sipona i lemenge nem ero. I at mana ke hele hote lemenge nem. ");
INSERT INTO uvl_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Pe lemenge toto ngana nenge tualeme hite hulua lochloch, lape sio at nga ich pe ngana koi atat lo. ");
INSERT INTO uvl_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Ana non tu nga ich lo nenge i sipona ala hote. Pe kileng nga ich tenau lange i ke nek ero. ");
INSERT INTO uvl_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Ana non at nga nena kileng pengpeng pe nena kileng nganangana mur lemeria ero ia i. ");
INSERT INTO uvl_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Pe iri nenge tenek teua i pe leteria manmanna nga Ene, i talue iri ke NeHalang tutuna mur ia iri. ");
INSERT INTO uvl_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Pe NeHalang tutuna mur iri nga poinga nenga leinga ero, nga nenge hehei pe hana te hohoe tuturia mur. Nem ero. Iri te lohot nga NeHalang lemene ngana. Ke iri temeria NeHalang. ");
INSERT INTO uvl_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Helenga nem lohot ke i non ke tu luluch nge ita. Pe ta naue nena hemalmalinga palaungana ke ulolo. Hemalmalinga palaungana nenge Temere Tuna elle nem. Pe i muta toto nga poinga urana toto ngana. Pe nena helenga mur manmanna lochloch. ");
INSERT INTO uvl_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Ke Ioanes hele urumrume ana non lala nge hehei pe hana, pe haliu ke teke, “Non nem koloi nenge e heleia ke e teke, ‘I nenge nanasia iau, i palaungana toto nge iau iange tehoe iau ero kura pe ana non tu ke ulolo.’” ");
INSERT INTO uvl_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Pe i muta toto nga poinga urana ngana mur. Ke pomalam ita lochloch ta menmene petanga mur nge halang toto nge i. ");
INSERT INTO uvl_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","NeHalang hesue hotonga mur lange Moses ke at nge ita. Pe poinga urana ngana mur pe helenga manmanna ngana mur teat nge ita nga kue nenge Iesus Kristus. ");
INSERT INTO uvl_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Mele pele naue NeHalang nakuna ero toto. Pe tuna elle nem i NeHalang ia. Pe i are teu la toto nga Temene taena ene. Pe i sipona henonou hote NeHalang at nge ita. ");
INSERT INTO uvl_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Iuta mur nenge Ierusalem te kulosia tunginga ana hana mur pe Liuai mur ke tela nge Ioanes pe te ontei hote i ke pomai koi, “Iong itei toto?” ");
INSERT INTO uvl_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Pe Ioanes topele helenga e ero. Hele hot pengpeng mene ke teke, “Iau Kristus ero.” ");
INSERT INTO uvl_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Pe hana nemur te ontei mule, “Ol pe iong non tei? Iong Elaisa?” Pe Ioanes hele, “Ero iam, iau non nem ero.” “Eh! Iong hetatalonga ma?” Pe Ioanes tucholia, “Ero.” ");
INSERT INTO uvl_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Pe hana nemur te hele, “Ol pe iong itei toto? O hele hote iong at nge imem pe mola ke mo heleia lange iri nenge te kulosia imem at. Pomalam o hele hot mene iong at nge imem ol.” ");
INSERT INTO uvl_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Ol pe Ioanes tuacholia nga hetatalonga Isaias nena helenga mur nenge hele ke teke, “Iau laka none alngana nenge haliuliu nga ich sana lomona nenge teke, ‘A hepeng ia Non Soke nena kue ke pengpeng.’” ");
INSERT INTO uvl_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Pe hel nenge iri Paresio nenge te kulosia iri at neu, ");
INSERT INTO uvl_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","te ontei mule i, “O teke iong Kristus ero, pe iong Elaisa ero pe iong hetatalonga ero. Pe pomerei o henunune hehei pe hana?” ");
INSERT INTO uvl_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Pe Ioanes tuacholia, “Iau e henune hehei pe hana nga ech mana. Pe mele la mes luluch nge imo, pe imo a eteia i ero. ");
INSERT INTO uvl_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Ana non koi nanasia iau ke atat. Pe iau e urana ero toto nge epoi hote apena ana ae ulina.” ");
INSERT INTO uvl_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Ure nenge nei lohot nga kileng nenge Petani nga ech Iortan ilina hele. Nga kileng unne nenge Ioanes henunune hehei pe hana ia. ");
INSERT INTO uvl_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Iok, pomange rou Ioanes naue Iesus nge i ke la tau pengpeng ia i pe hele, “Anau la NeHalang nena Sipsip Tuna kou atat neu. I lape saua poinga poreke ngana mur nga ich nei ke te lasus toto. ");
INSERT INTO uvl_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Ke i sipona laka nenge e heleia lala nge imo nenge e teke, ‘None koi nananas ia iau ke atat kura. Pe ana non i palaungana toto nge iau. Iange tehoe iau ero kura pe i tu tala nge iau ke ulolo.’ ");
INSERT INTO uvl_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Pe iau e eteia i ero. Eat pe e henune hehei pe hana nga ech mana. Pe nga poinga nenge e poia nei, lape hehei pe hana nge Israel te naue i ke mallaha toto.” ");
INSERT INTO uvl_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Ke het pe Ioanes hele hot mule ure manmanna ngana hel pule ke teke, “E naue Opepengpeng nge sio at nga tapa ke pomanga ngie chaulum, pe to haka mana nga ana non houngana. ");
INSERT INTO uvl_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Nga tele ngana toto e eteia i ero. Pe Non nenge kulosia iau at ke e henunun nga ech nei, hele at nge iau ke teke, ‘Onau pe o esia non nenge Opepengpeng sio at ke to haka nge i, ana non lalom nenge lape henunun nga Opepengpeng.’ ");
INSERT INTO uvl_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Ke ure nem e naue nge lohot ke ulolo. Pe e hele ke manmanna toto lange imo, Non nei i NeHalang tuna.” ");
INSERT INTO uvl_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Iok, pomange rou mule Ioanes mes luluch nge nena hana mur nai. ");
INSERT INTO uvl_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Pe naue Iesus nge i toto pe hele, “Anau la, NeHalang nena Sipsip Tuna kou!” ");
INSERT INTO uvl_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Pe hana nai neu te longe Ioanes nge hele ke mau pe te nanas sapele Iesus. ");
INSERT INTO uvl_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Ol pe Iesus ralele pe naue iri nge te nananas pe onteia iri, “Imo nai a nansia iau ke?” Pe iri nai te hele, “Hetoronga, o tutu langai?” ");
INSERT INTO uvl_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Pe Iesus hele, “Imo nai aiat kela anau.” Iesus hele pomau pe chaia matana sisio lo. Pomalam tei kela tenau nga Iesus tu nganngana pe tetu luluch mana nge i nga etue neu. ");
INSERT INTO uvl_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Pe hana nai nenge te longe Ioanes nge heleia Iesus pe te koko nge i neu, elle nge iri ene Antreas. Pe Antreas i Simon Petrus tina ia. ");
INSERT INTO uvl_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Ana non la ke tango rere tele tina Simon pe hele lange i, “Mo hottaua Mesias, non nenge mene tuangaola nge heo ngana lo.” (Nga helenga Krik te hetue non nem ke “Kristus”.) ");
INSERT INTO uvl_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Pe mene i ke lange Iesus. Pe Iesus nau lange i pe hele, “Iong em laka Simon nenge ne Ioanes tuna. Pe lape te hetue iong ke Sipas” (Nga helenga Krik te hetue ke “Petrus” luna laka “um”.) ");
INSERT INTO uvl_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Iok, pomange rou mule pe Iesus teke lohaka ke lange Kalelea. La pe hottaua Pilipus pe hele lange i ke teke, “Pilipus o iat ke o nanasia iau.” ");
INSERT INTO uvl_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Pe Pilipus pule nena nge Petsaita nga Antreas iri nai Petrus reria kileng huna. ");
INSERT INTO uvl_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Iok, Pilipus hottaua Nataniel pe hele lange i pule ke teke, “Mo hottaua non nenge Moses has urume nga hotonga ana alalaha mur lo. Pe pule hetatalonga mur tehas urume i nga reria alalaha mur. Ana non ene laka Iesus. Ne Iosep nenge Nasaret tuna.” ");
INSERT INTO uvl_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Pe Nataniel hele, “Ah! Ngana iam o hetue kileng nenge Nasaret mam! Utar nge urana toto nge lape lohot nga kileng nem mam, eh!?” Pe Pilipus hele, “Oi at mana ke onau.” ");
INSERT INTO uvl_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Iok, Iesus naue Nataniel nge i ke atat pe hele, “Kileng nenge Israel nganangana e toto koi atat nei. Pe pallakanga ana poinga unne tu nge i ero toto.” ");
INSERT INTO uvl_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Pe Nataniel onteia Iesus ke teke, “Iong mam o eteia iau ke merei toto?” Pe Iesus hele, “Pilipus la ke hele nge iong ero kura pe enau tele iong nge o arare nga ae popi ene.” ");
INSERT INTO uvl_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Ol pe Nataniel hele, “Hetoronga! Iong NeHalang Tuna Iong pe Israel mur aria Naungaala ana non!” ");
INSERT INTO uvl_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Pe Iesus hele, “Iong o longe iau nge e teke e naue iong nge o arare nga ae popi ene. Pomalam letem manmanna pe o hele ke mam, ae? Ure hel nge papalauna nga nei, lape o naue iri nge te lohot kura.” ");
INSERT INTO uvl_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Pe Iesus hele pule ke teke, e hele ke manmanna toto lange imo: lape a naue tapa sana nge ulala pe a esia NeHalang nena angkelo mur nge te haka lala pe tesio atat nge Non Tuna. ");
INSERT INTO uvl_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Iok, nga etue mol ngana nga hoena ngaunga matana e lohot nge Kana nga kileng nenge Kalelea, pe Iesus tana tu nga etue neu pule. (Ngaunga matana nem nga halangina heueu ngana hel nge te puotau hel.) ");
INSERT INTO uvl_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Pe Iesus pe nena hana mur te mene helenga ke tela nga puongatau neu pule. ");
INSERT INTO uvl_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Ol pe aria uain soso. Pe Iesus tana la ke hele lange Iesus ke teke, “Hana nemur aria uain soso lo i.” ");
INSERT INTO uvl_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Pe Iesus hele lange tana, “Etak, pomere nenge otal teu luluche iau langa ure nei? Iau ak etue at ero kura.” ");
INSERT INTO uvl_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Ol pe Iesus tana hele lange iri nenge te umume lamau ke teke, “Aua nei hele lange imo pe a longo tau mene i.” ");
INSERT INTO uvl_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Nga ngaunga matana nem, ech kina papalaungana nge iri rahtele elle tema. Pe ech kina nemur, iri papalauna nge lape ech ana ponge (lita) iri ana non kina lime (100) hemute kina elle. Pe pule, ech kina nemur te ume hote nga um pe ana ech Iuta mur te nununia ke te lemlem nga NeHalang matana. ");
INSERT INTO uvl_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Iok laol, Iesus hele lange hana nenge te umume neu ke teke, “A eulia ech pe a pasiling teua langa ech kina nemur.” Pe hana nemur te hemute heke tote ech kina nemur ke langa haria ilina toto. ");
INSERT INTO uvl_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Ke het pe Iesus hele lange iri, “Iok, a eulia unne pe ala ia nge non nenge i muka nga ngaunga matana nei.” Iok, te mene ech neu la, ");
INSERT INTO uvl_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","pe hul ke i uain lo pe la non neu in tote. Ana non in tote pe eteia uain neu at ngana ero pe iri nenge te eulia ana ech te eteia. Ol pe non neu iua non halangina heueu ngana neu ");
INSERT INTO uvl_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","pe hele lange i ke teke, “Hana lochloch te mene hote uain urana ngana mur ke aria lang mur tein tettele. Pe nau pe tein sakilil lo, mene hote uain nenge urana ero ke te inia nga hoena ol. Pe iong ero. Uain nenge urana toto koi nenge o tung hotote nei ol!” ");
INSERT INTO uvl_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Ke merakulo tengene ana nenge Iesus poia lohot nga kileng nenge Kana nge Kalelea. Pe nga lamau Iesus henonou hote i sipona nena hemalmalinga palaungana lange nena hana mur. Pomalam leteria manmanna nge i. ");
INSERT INTO uvl_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Ke het pe Iesus pe tana pe titina mur pe nena hana mur tei ke tesio lange Kapernam, pe tetu ke etue hel mule nga kileng neu. ");
INSERT INTO uvl_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Iok, etue palaungana nenga Ingatoto ana ngaunga matana heroi lo. Pomalam Iesus lohaka ke lange Ierusalem. ");
INSERT INTO uvl_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","La pe hulua tei alala nga NeHalang nena pele palaungana nge Ierusalem. Te loloch teua pulumakau mur pe sipsip mur pe ngie mur kela te ololia iri nga NeHalang nena pele letena. Pe iri nenge te hetataua umtutuna mur teare pule nga reria haonga mur. ");
INSERT INTO uvl_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Ol pe Iesus mania nena nosinga nga such ke lope hote huros nemur. Pe pule hekale hul sue hana nenge te hetataua umtutuna reria hatanga mur, ke reria umtutuna te pararai ulu. ");
INSERT INTO uvl_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Pe hele lange iri nenge reria ngie mur ke teke, “A mene hote ngie nemur lange hot. A poia Temek nena pele ke pomanga ingala ana pele ero.” ");
INSERT INTO uvl_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Pe nena hana mur leteria metene NeHalang nena helenga nenge tehas sue ke ulolo, nenge hele ke teke, “NeHalang lem pele ana mute tu toto nge iau. Pe ngaulala nga letek ke pomanga oan ngingina ngana.” ");
INSERT INTO uvl_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Ol pe Iuta mur aria papalauna mur te hele lange Iesus ke te teke, “O poi hote merakulo hel ke monau mukam. Pomalam lape mo eteia ke Iong lem kerkerenga palaungana nge o poia poinga nei.” ");
INSERT INTO uvl_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Pe Iesus hele, “A toto sue NeHalang nena pele palaungana nei, pe nga etue iri mol mana lape e hemes heke mule.” ");
INSERT INTO uvl_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Pe hana Iuta nemur te tuacholia ke te teke, “NeHalang nena pele palaungana nei te hemes heke pe te umume ia ke hesinga iri ana non kina nai pe rahtele elle. (46) Pe iong ma oteke o hemes heke mule nga etue iri mol mana mam?” ");
INSERT INTO uvl_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Pe Iesus helele ia NeHalang nena pele palaungana nem ero. Iesus helele ia i sipona singina. ");
INSERT INTO uvl_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Ke nga etue nenge Iesus maul haka mule nga metenga, nena hana mur nenge te nananas ia i, leteria metene mule nena helenga nei. Pomalam leteria manmanna nga NeHalang nena alalaha mur pe Iesus na helenga mur. ");
INSERT INTO uvl_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Iok, Iesus tunge Ierusalem nga ngaunga matana nenga Ingatoto ana etue pe poia merakulo halang ke te lohot. Pe hulua te esia pe leteria manmanna nga Iesus ene. ");
INSERT INTO uvl_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Pe Iesus etei tote hulua lochloch leteria tuanin ngana mur ke ulolo. Pomalam elechin teu la sakilil nge iri ero. ");
INSERT INTO uvl_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Mele nakuna ero toto nge hetore Iesus nga hana leteria tuanin ngana mur. Iange i etei tote leteria ke ulolo. ");
INSERT INTO uvl_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Iok, non Paresio e ene Nikotemus. Pe i non soke ia pule nenge tenau elele hehei pe hana nenge Iutea. ");
INSERT INTO uvl_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Ana non lange Iesus nga miliko e pe hele, “Hetoronga, imem mo eteia ke iong hetoronga nenge NeHalang kulosia ke at. Iange Iong o hele pe ure te lohot manmana. Nenge teke NeHalang tu luluch nge iong ero, lape nakum ero nge o poia ure papalaungana nemur.” ");
INSERT INTO uvl_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Pe Iesus tuacholia non neu na helenga ke teke, “E hele ke manmanna toto. Mele pele lape teu langa NeHalang nena naualanga pe nekinga ero toto. Iri nenge teha mule ke iri heueu ngana mule. Iri toro teteu la.” ");
INSERT INTO uvl_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Pe Nikotemus ontei mule, “Lape te hoho mule mele ke merei ol nga etue nenge tana hoho hote ke ulolo? Mele pele teu la henai ngana mule nga tana letena ke tana hoho mule i ero kura!” ");
INSERT INTO uvl_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Pe Iesus tuacholia ke teke, “E hele ke manmanna toto lange iong, mele pele lape teu langa NeHalang nena naualanga pe nekinga ero toto. Pe mele nenge mene hohonga nenga ech pe Opepengpeng, mele nem mana lape teu la. ");
INSERT INTO uvl_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Hohonga nenge lohot nge tara pe temere, i singira ana ia. Pe hohonga nenge lohot nga Opepengpeng i opere ana ia. ");
INSERT INTO uvl_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Ke o rura ero nga nenge e hele lange iong ke e teke, ‘Imo lochloch ala ke te hoho mule imo.’ ");
INSERT INTO uvl_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Tuttula song ke langa lemene ngana pe o longlonge. Pe o eteia tuttula nem at ngana kau? Pe o eteia la nganngana pule? Ke iri nenge te mene hohonga nenga Opepengpeng tepoi ke pomalam mana.” ");
INSERT INTO uvl_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Pe Nikotemus ontei mule, “Ke ure nenge nei lape lohot ke mere toto mai?” ");
INSERT INTO uvl_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Pe Iesus hele, “Iong non hetoronga e nge Israel, pe pomerei letem mallaha nga ure nemur ero? ");
INSERT INTO uvl_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","E hele ke manmanna toto lange iong, imem mo helele ia ure nemur nenge mo eteia iri pe mo nenene ure nemur nenge mo eses ia iri. Pe pomerei letemo manmanna nga ure nemur ero? ");
INSERT INTO uvl_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","E nenene ure nemur nga ich pe letemo manmanna ero. Pe nenge teke e nene ure nemur nga tapa, lape letemo manmanna ol kau? ");
INSERT INTO uvl_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Mele pele langa lut nga tapa ero toto. Non Tuna i toro mana. Iange i sio at nga lut nga tapa. ");
INSERT INTO uvl_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Pe Non Tuna nem lape te heon heke ke langa lut ke pomanga ilimo nenge Moses heon heke nga ae nga ich sana lomona. ");
INSERT INTO uvl_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Ke iri nenge leteria manmanna nge i lape te mene maulinga ke koko. ");
INSERT INTO uvl_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","“NeHalang lemene tau tote hehei pe hana nga ich nei. Pomalam tung hote tuna elle mana nem. Pe iri nenge leteria manmanna nge i lape te mene maulinga ke koko. Te mete sapele ero. ");
INSERT INTO uvl_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Iange NeHalang kulos sue Tuna at nga ich ke heporeke hehei pe hana ero. At ke mene mule hehei pe hana ke tela nge NeHalang. Pe kue nenge tela ia nge NeHalang, ngana laka nge Iesus i sipona lo. ");
INSERT INTO uvl_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Pe mele hel nenge leteria manmanna nge i lape te amnei teu langa reria poinga poreke ngana mur ero. Pe mele hel nenge leteria manmanna nge i ero, te amnei teu nga reria poinga poreke ngana mur ke het lo. Iange iri leteria manmanna nge NeHalang Tuna elle nem ero. ");
INSERT INTO uvl_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Te amnei teu langa reria poinga mur ke pomai koi: Lemenge sio at nga ich nei ke ulolo, pe hehei pe hana lemeria ero ia. Lemeria tau mene kileng au ngana iange reria poinga mur poreke toto. Pomalam NeHalang lape tuacholia ke poreke toto lange iri. ");
INSERT INTO uvl_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Iri lochloch ngana nenge te popoi poinga poreke ngana, lemeria ero lemenge. Pe lemeria ero nge tei hot nga kileng mesehe ngana, iange lape reria poinga poreke ngana mur, tetu ke mallaha hot mana. ");
INSERT INTO uvl_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Pe mele hel nenge te longo taua NeHalang nena helenga manmanna ngana, tei hot langa lemenge. Pomalam lape tees mellehe mene ke reria poinga nemur nenge te popoia, te poia nga NeHalang lemene ngana.” ");
INSERT INTO uvl_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Iesus hele ke mau ke het pe i pe nena hana mur nenge te nananas ia i, tehot langa ich nenge Iutea. Pe tu pol mana luluch nge iri pe henunune hehei pe hana. ");
INSERT INTO uvl_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Pe Ioanes pule henunune hehei pe hana nga kileng nenge Aenon. Kileng nei rochroi langa kileng nenge Salem pe ana ech halang. Pomalam hulua te atat ke kokoes ke Ioanes henunune iri. ");
INSERT INTO uvl_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","(Nenge nei lohot tala nga etue nenge tetal teua Ioanes nga tuele au ngana.) ");
INSERT INTO uvl_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Ol pe hunelinga unne lohot nge Ioanes nena hana mur nenge te nanansia i, pe non Iuta e. Te hunel nga poinga nenge Iuta mur te nananasia nenge te henun susue iri ke te helemlem mulmule iri nga reria poinga poreke ngana mur. ");
INSERT INTO uvl_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Ol pe tela nge Ioanes pe te hele, “Hetoronga, letem metene non nem nenge tu luluch nge iong nga ech ilina hele nge Iortan pe iong o haliu hotote i lala nge hehei pe hana. i kou henunun pule pe hulua te lala nge i.” ");
INSERT INTO uvl_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Ol pe Ioanes tuacholia ke teke, “Ure lochloch ngana nenge ta mene, teat mana nge NeHalang i toro pe nga kue e ero ol. ");
INSERT INTO uvl_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Imo sipomo a longe nge e heleia ke ulolo nenge e teke, ‘Iau Kristus ero koi. Iange iau, te kulosia iau ke iau muka at.’ ");
INSERT INTO uvl_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Non e lei pe mene hei nem ke nehei ia. Pe non nem na tula nenge longo tautaua i, kulala pe longo ala manmana. Pe nenge teke talngana pair ia non halangina neu kanna unne, non nem letena iech toto. Pe iau e iech toto ke pomange non nem pule. ");
INSERT INTO uvl_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Pe i lape lohot ke i palaungana toto. Pe iau, e ele sio toto. ");
INSERT INTO uvl_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","“I nenge sio at nga lut i palaungana nga ure lochloch. Pe i nenge at nga ich pe nena nga ich helele ia ure nemur nga ich. Ke i nenge sio at nga tapa i palaungana nga ure lochloch. ");
INSERT INTO uvl_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Ana non helele ia ure nemur nenge e sesia pe longlonge pe mele pele letena manmanna nge i ero toto. ");
INSERT INTO uvl_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Pe iri nenge leteria manmanna nge i, te henonou hote ke NeHalang pallaklaka ero. ");
INSERT INTO uvl_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Pe i nenge NeHalang kulosia ke at, hele hotote NeHalang nena helenga mur iange NeHalang tung tote Opepengpeng ke muta toto nge ana non. ");
INSERT INTO uvl_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Temene mutena tau tote Tuna, pomalam tal heke ure lochloch ngana nga Tuna penna. ");
INSERT INTO uvl_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Pe mele nenge letena manmanna nge Tuna lape mene maulinga ke koko. Pe mele nenge lemene ero ia Tuna lape teu langa maulinga ke koko nem ero. Iange NeHalang letena inin ngana lape tu manmana nge mele nem ke kokoes.” ");
INSERT INTO uvl_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Iok, Paresio mur te longo nge hulua halang toto te lala nge Iesus ke henunune iri pe Ioanes ero. ");
INSERT INTO uvl_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Pe ure manmanna ngana, Iesus nena hana mur laka nenge te popoia ume nem, nenge te henunune hehei pe hana. Pe Iesus i sipona ero. ");
INSERT INTO uvl_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Nga etue nenge Iesus eteia ke pomau, lohaka nga kileng nenge Iutea pe la mule nga kileng nenge Kalelea. ");
INSERT INTO uvl_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Pe la mule ngana lape i nga kue nenge langa tuele kina nenge Samaria. ");
INSERT INTO uvl_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Pomalam Iesus la ke lohot nga tuele tana e nge Samaria nge ene Sikar. Ana kileng tu ke rochroi langa ich unne nenge ne Iakop tunge lange tuna Iosep. ");
INSERT INTO uvl_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Pe ne Iakop ana ech matana e nge sel ia, tu nga lamau pule. Pe kileng sinanga toto lo iange chaia matana heurunga pengpeng. Pe Iesus i nga kue sase ngana pe makuk toto lo. Ol pe la ke are sio nga ech matana neu. ");
INSERT INTO uvl_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Pe hei Samaria e teke la ke eul ech, pe Iesus hele lange i ke teke, “Hei nem o eulia ech unne at ke ein mukam?” ");
INSERT INTO uvl_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","(Nga etue neu Iesus nena hana mur nenge te nananas ia i, ngaria kou tela nga tuele tana ke teol aria ngaunga.) ");
INSERT INTO uvl_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Pe hei Samaria neu hele lange Iesus ke teke, “Iong lem nge Iutea pe iau lek nge Samaria. Pe pomerei o onteia iau ke e eul am ech?” (Hei neu hele ke mau iange Iuta mur te teke te tu kangkanga toto nge Samaria mur.) ");
INSERT INTO uvl_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Pe Iesus hele, “Toinge o eteia urelu urana ngana mur nenge NeHalang tung menmene iri, pe o eteia mele nenge onteiteia iong nga ech nei, lape o ontei ech lange i pe lape tunge ech nenge maulinga ana lange iong.” ");
INSERT INTO uvl_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Pe hei neu hele, “Non Soke, lape o eul hote nga utar? Ech matana nei lange sio toto i. Eh, lape o mene ech nenga maulinga ke koko nem langai? ");
INSERT INTO uvl_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Eh iong palaungana toto nge lemem te ne Iakop ma? I kai nenge tunge ech matana nei at nge imem mai. Pe i pe tutuna mur pe reria sipsip mur te inin ia ech nei pule.” ");
INSERT INTO uvl_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Pe Iesus hele, “Iri lochloch ngana nenge te inin ech nga lamai lape te meteune ech mule. ");
INSERT INTO uvl_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Pe mele nenge inia ech nenge e tunge lange i, lape mete ana ech mule ero ol. Iange ech nem lape lohot ke i ech matana nenge pachpach hotot pe lelele nga letena ke tunge maulinga ke koko nge i.” ");
INSERT INTO uvl_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Pe hei neu hele lange Iesus, “Iok, Non Soke o tunge ech nem at nge iau. Pomalam lape mutenga nenga ech het nge iau, pe pule eat lamai ke e eul ech ero ol.” ");
INSERT INTO uvl_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Pe Iesus hele lange i ke teke, “Ola pe o hele nge em pe oi at mule.” ");
INSERT INTO uvl_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Pe hei neu hele, “Iau ek ero i.” Pe Iesus hele, “Helenga nenge o heleia nem manmanna, nenge o teke em ero. ");
INSERT INTO uvl_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Pe i manmanna ke em hana iri lime. Pe non nenge o mene i heueu nei, iong em ia ero. Ke lem helenga nem manmanna.” ");
INSERT INTO uvl_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Pe hei neu hele, “Non Soke, nga enau ngak e eteia ke iong hetatalonga e. ");
INSERT INTO uvl_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Lemem tete mur te hetalaulau pe te heto hekeke nga hengene nei. Pe imo Iuta mur a teke hetalaulaunga ana kileng nge Ierusalem mana.” ");
INSERT INTO uvl_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Pe Iesus hele, “Hei nem, letem manmanna nga lek helenga nei. Etue e lape at nenge lape a hetalaulau pe a heto heke Temere nga hengene nei ero. Pe lape a heto hekeke Temere nge Ierusalem ero pule. ");
INSERT INTO uvl_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Pe imo Samaria mur a eteia utar nenge a hetalaulau pe a heto hekeke ero. Pe imem Iuta mur mo eteia utar nenge mo hetalaulau pe mo heto hekeke. Iange maulinga ke koko chach hot nge Iuta mur. ");
INSERT INTO uvl_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Pe etue e pule lape at, nenge lape hetalaulaunga ana hana mur toto te hetalaulau lange Temere nga ope pe nga ure manmanna toto ngana. Ke ana etue koloi at lo. Iange Temere tango rerere hetalaulaunga ana hana mur nenge pomau. ");
INSERT INTO uvl_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","NeHalang i ope mana, pe nena hetalaulaunga ana hana mur lape te hetalaulau pe te heto heke i nga ope pe nga ure manmanna toto ngana.” ");
INSERT INTO uvl_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Pe hei neu hele, “Iau e eteia ke Mesias kou atat kura.” (Mesias te hetue ke Kristus). “Pe nga etue nenge at ke sau hot, lape hele urume ure lochloch ngana at nge imem ol.” ");
INSERT INTO uvl_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Ol pe Iesus hele, “Pe ana non kai iau mai loi, iau nenge e hele lala nge iong nei mai.” ");
INSERT INTO uvl_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Iesus hele ke mau ke het pe nena hana mur tela ke te lohot mule nge i. Pe te rura ia i nge hele lululuch nge heie. Pe e nge iri onteia Iesus nga onteinga nemur ero: “Lemem taua utar nge hei nei” nem pe “Pomerei nenge o hele luluch nge hei nei?” ");
INSERT INTO uvl_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Ol pe hei neu hile sue ana ech kina pe la mule nga tuele tana neu. La pe hele lange hehei pe hana ke teke, ");
INSERT INTO uvl_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Ai at ke anau nge Non nei. Non nei hele hote ure lochloch ngana nenge e popoia nge nike ke at heueu nei. Lape i Kristus ka loi?” ");
INSERT INTO uvl_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Iok laol, tei hot nga tuele tana neu pe tei ke ramaria lange Iesus. ");
INSERT INTO uvl_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Nga etue neu Iesus nena hana mur te echia i ke te teke, “Hetoronga, o ngau polia ute mukam.” ");
INSERT INTO uvl_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Pe Iesus hele lange iri ke mai, “Ak ngaunga nenge e ngaua, imo a eteia ero toto.” ");
INSERT INTO uvl_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Ol pe nena hana mur nenge te nananas ia i, te mangun tele hel nge iri ke te teke, “Lape mele at ia ana ngaunga lo kai?” ");
INSERT INTO uvl_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Pe Iesus hele lange iri ke teke, “Iau lape e nanas mene Non nenge kulosia iau at lemene ngana. Pe lape e heulo hote nena ume mur. Ke ak ngaunga laka nem lo. ");
INSERT INTO uvl_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Imo a helele ke a teke, ‘Teio henel koi tu kura. Teio henel nem het pe lulunga ana etue sapele.’ Pe e hele lange imo, anau haka pe anau langa ume mur! Ngaunga nga ume nemur te mera tah lo. Pe a lule iri nge ngingie ol? ");
INSERT INTO uvl_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Heueu nei lulunga ana hana mur kou te menmene ururia lo. Iange te lulu kiraua ngaunga nenga maulinga ke koko ana ke ulolo. Pe non nenge tue ngaunga nemur lape iech luluch nge lulunga ana hana nemur. ");
INSERT INTO uvl_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Pe helenga nei manmanna. Nenge te helele ia ke te teke, ‘Non e tue ngaunga nga ume pe none la ke lule.’ ");
INSERT INTO uvl_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Pomalam e kulosia imo kela a lulu nga ume nenge imo sipomo atue ero. Mele hel te poia ume palaungana lo, pe imo a lulu heke mene ume palaungana nem nganangana ol.” ");
INSERT INTO uvl_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Hulua halang nge Samaria nenge tetu nga kileng neu leteria manmanna nge Iesus. Iange te longe hei neu nena helenga nenge hele ke teke, “Non nei hele hote ure lochloch ngana nenge e popoia nge nike ke at heueu nei.” ");
INSERT INTO uvl_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Pomalam Samaria mur tela nge Iesus pe te echia i ke tu nge iri, pe tu luluch nge iri ke etue nai. ");
INSERT INTO uvl_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Pe te longlonge Iesus nena helenga mur pe hulua halang mule leteria manmanna. ");
INSERT INTO uvl_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Pe te hele lange hei neu, “Nga tele ngana, imem mo longe iong toro lem helenga pe letemem manmanna nge Non nei. Pe nei ol, imem sipomem mo longe i pe mo etei mellehe mene ke non nei i non nenge at ke mene mule hehei pe hana nga reria poinga poreke ngana mur, nga kileng lochloch ngana nga ich.” ");
INSERT INTO uvl_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Iok, etue nai het pe Iesus lohaka ke lange Kalelea. ");
INSERT INTO uvl_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","(Iesus hele hot tele ke ulolo ke teke non hetatalonga e lape pingana iuiu nga nena kileng huna ero toto.) ");
INSERT INTO uvl_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Iok, Iesus i kela lohot nge Kalelea pe iri nenge Kalelea te long teua i pe leteria manmanna nge i. Iange nga etue nenge tela nge Ierusalem nga ngaunga matana nenga Ingatoto, te esesia ure nemur nenge Iesus popoia iri. ");
INSERT INTO uvl_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Iesus tu nge Kalelea pe la ke lohot mule nga kileng nenge Kana, nga kileng nenge hulia ech pe lohot ke uain. Pe nge Kapernam, naungaala ana none nena non soke e tutu. Pe tuna tamane ngana singina haleles toto. ");
INSERT INTO uvl_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Non neu longe nge te teke Iesus lohaka nga kileng nenge Iutea, pe la ke lohot nge Kalelea ke ulolo. Pomalam, ana non la ke naue Iesus pe onteia i ke teke Iesus lange Kapernam kela hemas mule tuna nge singina haleles toto lo. ");
INSERT INTO uvl_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Pe Iesus hele lange i ke teke, “Imo nemur letemo manmanna ero toto. Nenge teke a naue ure mur nge te lohot manmana, laka lape letemo manmanna.” ");
INSERT INTO uvl_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Pe non neu hele, “Non Soke, osio la ke ueiuei mana iange lape tuk mete heueu.” ");
INSERT INTO uvl_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Pe Iesus hele, “Ola mule ol. Tum lape tu ke maulul.” Pe non neu letena manmanna nga Iesus nena helenga pe i kela sapele. ");
INSERT INTO uvl_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Ana non i ke lala kura pe nena hana mur nenge te umume nge i, te apenia i nga kue. Pe te hele lange i ke te teke, “Tum kou maul mule lo.” ");
INSERT INTO uvl_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Pe ana non ontei hote iri nga etue nenge tuna maula mule ia, pe te hele ke te teke, “Nge lona nga sinanga. Nga etue koana nenge tera haka mulmule ume ia.” ");
INSERT INTO uvl_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Ol pe kol neu temene eteia ke nge lona nga etue koana nem pengpeng, Iesus hele lange i ke teke, “Tum lape tu ke maulul.” Ol pe non neu pe iri lochloch ngana nenge tetu luluch nge i nga nena pele, iri lochloch ke leteria manmanna. ");
INSERT INTO uvl_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Pe nenge nei i merakulo naingana nenge Iesus poia nga etue nenge lohaka nge Iutea ke la tu nge Kalelea. ");
INSERT INTO uvl_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Iok, etue hel nga hoena Iesus lohaka ke lange Ierusalem iange Iuta mur te popoia ngaunga matana e. ");
INSERT INTO uvl_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Pe nge Ierusalem ech matana e tu. Ana ech matana tu ke rochroi mana nga kue matana nenge teu langa kileng neu. Pe kue matana palaungana neu te hetue ke ene Sipsip ana Kue Matana. Pe nga helenga Hipru te hetue ech matana neu ke ene, ech matana nenge Petsaita pe ech matana neu ana sauach iri lime. ");
INSERT INTO uvl_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","4","Pe hulua nge haleles poia iri tema sio rara mana nga lamau. Iri nenge mataria hit pe iri nenge aperia lul pe iri nenge singiria metmete. Nga etue hel Non Soke nena angkelo sio at ke tua maimai heke ech nga ech matana neu. Tua maimai heke ech pe mele nenge i muka sio kela nun teu nga ech neu, ana haleles nenge tutu nge i nem het sapelpele. ");
INSERT INTO uvl_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Pe none nge haleles tu nge i ke hesinga iri ana non kina elle pe analoch pe rahtele mol (38), tu nga lamau pule. ");
INSERT INTO uvl_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Pe nga etue nenge Iesus esia non neu, Iesus eteia ke haleles neu tunge non neu ke mala toto lo. Ol pe Iesus onteia non neu, “Lemem ke o teke o urana mule?” ");
INSERT INTO uvl_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Pe non haleles kina neu hele, “Non Soke, mele e nge halaua iau ero ka mai. Ech nei tua maimai haka pe e teke esio kela enun teu pe ero, mele hemuka toto ala lo.” ");
INSERT INTO uvl_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Ol pe Iesus hele lange i, “O lohaka! Pe o mene lem manga pe oi.” ");
INSERT INTO uvl_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Nga etue neu pengpeng haleles neu het nge non neu, pe lou heke nena tako nenge mamaia pe i sapele. Pe ure neu lohot pengpeng nga Sapat ana etue. ");
INSERT INTO uvl_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Pomalam Iuta mur te hele lange non nenge urana mule neu ke te teke, “Sapat ana etue i heueu mai. Pe hotonga hele ke teke o takisia lem manga ero.” ");
INSERT INTO uvl_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Pe non neu tuacholia ke teke, “Non nenge hemaulia iau hele at nge iau ke teke, ‘O lou heke lem tako nenge o mama ia pe oi.’” ");
INSERT INTO uvl_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Pe hana nemur te ontei mule i, “Non tei toto nemam, nenge hele lange iong ke teke o mene heke pe oi?” ");
INSERT INTO uvl_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Pe non neu eteia non nenge hemaulia i ero ol, iange Iesus kou salekleke teu nga hulua leteria kela lo. ");
INSERT INTO uvl_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Pe nga hoena, Iesus sahol mule non neu nga NeHalang na pele palaungana letena. Pe hele lange i ke teke, “O naue lo, o urana mule lo. Pe o poia poinga porekreke ngana mur ero ol, iange lape ute e nge poreke toto lape lohot mule nge iong.” ");
INSERT INTO uvl_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Ol pe non neu la sapele pela hele lange Iuta mur ke teke Iesus laka nenge poia i ke urana mule nem. ");
INSERT INTO uvl_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Iesus hemas mule non neu nga Sapat ana etue pomalam Iuta mur te talun sapele ke te tunge melmelenga lange i. ");
INSERT INTO uvl_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Pe Iesus hele lange iri ke teke, “Temek ume ke kokoes mana, ke pomalam e umume pule.” ");
INSERT INTO uvl_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Ke nga nenge nei, Iuta mur te totoi ke kerkereng ke te toto hita toto ke te teke te hune Iesus. Pe huna nga nenge neu mana ero. Nenge umume nga etue palaungana nenge Israel mur te hetalaulau ia. Huna e pule nga nenge hetetue NeHalang ke i sipona Temene, pe poia i sipona ke ana opo elle mana ke mange NeHalang. ");
INSERT INTO uvl_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Pe Iesus tuacholia lange iri ke teke, “E hele ke manmanna toto lange imo, NeHalang Tuna poia ute pele nge i sipona ero. I poia ure nemur nenge naue nge Temene popoia. Ke ure nemur nenge Temene popoia, Tuna popoia pule. ");
INSERT INTO uvl_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Pe Temene mutena tau tote Tuna, pomalam henonoua i nga ure lochloch ngana nenge popoia. Ke lape Temene henonoua Tuna nga ure hel nge papalauna toto nga nei, pe lape imo lochloch ngana letemo una ala mana ia. ");
INSERT INTO uvl_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Temene hemaul heke mule hana nenge te mete ke ulolo pe tunge maulinga ke koko lange iri. Pomalam mana, Tuna lape tunge maulinga ke koko lange mele hel nga lemene ngana mana. ");
INSERT INTO uvl_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Temene tunge kerkerenga lange Tuna ke amnei teu lala nge hehei pe hana nga reria poinga mur. Pe Temene poia ume nem ero. ");
INSERT INTO uvl_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Ke pomalam lape hulua te heto heke Tuna ke pomanga te heto heke Temene. Pe mele nenge heto heke Tuna ero, heto heke Temene ero, iange i kulosia Tuna ke at. ");
INSERT INTO uvl_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“E hele ke manmanna toto lange imo, mele nenge longe ure nenge e heleia pe letena manmanna nge i nenge kulosia iau at, mele nem lape mene maulinga ke koko. Mele nem lape te amnei teu lange i ke te hottaua ure poreke ngana e nge i ero ol. Iange i lohaka mule nga metenga ke mene maulinga ke koko lo. ");
INSERT INTO uvl_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Pe pule e hele ke manmanna lange imo, etue nenge atat ana etue koi nei lo nenge lape hana nenge te mete ke ulolo te longo hilia NeHalang Tuna kanna. Pe iri nenge te longe lape te mene maulinga ke koko. ");
INSERT INTO uvl_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Iange Temene nena kerkerenga nge tunge maulinga ke koko. Pe i tunge kerkerenga elle mana nem lange Tuna. ");
INSERT INTO uvl_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Pe Tuna mene kerkerenga nenge amnei teu lala nga hehei pe hana reria poinga mur. Temene tunge kerkerenga nem lange i, iange i Non Tuna. ");
INSERT INTO uvl_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","A rura nga helenga nei ero: Etue e lape at. Pe iri lochloch ngana nenge te mete ke tema nga polo ke ulolo lape te longe nena haliunga ");
INSERT INTO uvl_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","pe lape te lohot nga reria polo mur. Pe iri nenge te nanasia poinga nge pengpeng lape te lohaka mule pe te mene maulinga ke koko. Pe iri nenge te nanasia poinga nge pengpeng ero, lape te lohaka mule pe NeHalang amnei teu langa reria poinga poreke ngana mur. ");
INSERT INTO uvl_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“Iau e poia ute pele ke iau toro ero. E amnei teu langa hehei pe hana reria poinga mur ke pomanga Temek hele ngana ia at nge iau. Ke e amnei teu ngak nem song hot ke urana. E poia ume nei pe e heto haka ek ia ero. E teke e poia i nenge kulosia iau at ke iech. ");
INSERT INTO uvl_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Ke nenge teke e nenene iau sipok lala nge hehei pe hana, lek helenga nem ute pele ero. ");
INSERT INTO uvl_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Pe mele e nge altoto kou nana urumrume iau. Pe e eteia ke ure nemur nenge heleleia iri neu, manmanna. ");
INSERT INTO uvl_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","“Imo, a kulosia hehei pe hana lange Ioanes nenge henunun. Pe i hele urume iau pe nena helenga manmanna. ");
INSERT INTO uvl_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Nenge none mana hele urume iau, nem ure palaungana ero. E hele mene ke halaua imo ke a mene maulinga ke koko. ");
INSERT INTO uvl_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Ioanes poi ke pomalaka nga lemenge nenge sapel lala pe tualemleme. Pe a iech ele mene lemenge nenge Ioanes nga etue choro ngana mana. ");
INSERT INTO uvl_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","“Pe ure nenge ele haka toto nga Ioanes nena helenga mur, ngana koi ure nemur nenge e popoia nei. Ure nemur Temek tunge iri at nge iau, pe te henonou hot pengpeng ia ke Temek kulosia iau at. ");
INSERT INTO uvl_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Pe pule, Temek nenge kulosia iau at nei, i sipona hele urume iau. Pe imo, a naue nakuna ero pe a longe nena helenga ero. ");
INSERT INTO uvl_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Nena hengetoro ma teu nge imo ero iange letemo manmanna nge non nenge kulosia at ero. ");
INSERT INTO uvl_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Imo a sisisia NeHalang nena helenga mur nenge ta has sue iri ke nek tototo, iange a teke lape a mene maulinga ke koko. Pe NeHalang nena helenga nemur, te helele ia kai iau mai loi! ");
INSERT INTO uvl_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Pe pomerei a at nge iau ke a mene maulinga nem ero? ");
INSERT INTO uvl_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Iau lemek ke hehei pe hana te heto heke iau ero. ");
INSERT INTO uvl_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Iange e etei mellehe mene imo nge mutemo taua NeHalang nga kakahomo ero toto. ");
INSERT INTO uvl_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Iau, Temek kulosia iau pe e mene munna ke eat nge imo pe lememo ero ia iau. Pe nenge teke mele at pe hele nga i sipona ene, lape anek teua i. ");
INSERT INTO uvl_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Poinga nenge a heto haka helel nge imo a iech ia ke elela. Pe lememo ero nge a nansia kue urana ngana hel nenge NeHalang i sipona heto heke imo ia. Pe lape letemo manmanna nge iau ke merei ol? ");
INSERT INTO uvl_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","A teke iau nge lape emes nga Temek matana pe e hele hot amo kai? I nenge lape hele hot amo laka Moses. Imo letemo kerkereng nge i ke a teke lape mene mule imo. Pe i nge lape toto hita mule amo laka. ");
INSERT INTO uvl_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Nenge teke letemo manmanna toto nge Moses iok, letemo manmanna nge iau pule. Iange Moses nena hassinga mur helele ia i iau lo. ");
INSERT INTO uvl_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Pe nenge teke letemo manmanna nga Moses nena hassinga mur ero, ol pe lape letemo manmanna nge iau ke mere?” ");
INSERT INTO uvl_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Iok, Iesus hele ke het pe lotele sapele nga ech hetaliliu ngana palaungana nenge Kalelea ke langa ele. (Pe ech neu ene e pule laka Tiperias). ");
INSERT INTO uvl_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Pe hulua halang te nanasia i iange te esia merakulo mur nga etue nenge hemasmas ia haleles mur. ");
INSERT INTO uvl_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Iok laol, Iesus lohaka langa sasana ilina pe are sio luluch nge nena hana mur. ");
INSERT INTO uvl_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Pe ngaunga matana nenga Ingatoto heroi lo. ");
INSERT INTO uvl_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Pe Iesus nau rara pe esia hulua nge te atat nge i. Ol pe onteia Pilipus, “Lape ta olia hulua nemur aria ngaunga langai ke te ngau?” ");
INSERT INTO uvl_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Iesus eteia utar nenge lape poia lo, pe i teke olleke mene Pilipus nga onteinga nei. ");
INSERT INTO uvl_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Pe Pilipus hele, “Nenge teke ta mene none uruna nga teio iri rahtele mol (8) pe ta olia nga hulua nemur aria naunga, lape teram mene pe saria una ero toto.” ");
INSERT INTO uvl_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Pe Iesus nena none pule ene Antreas, nenge Simon Petrus tina. Ana non lohaka pe hele, ");
INSERT INTO uvl_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Kol suna nei mene ke loi iri lime pe ruo kinkino ngana nai. Pe lape purpure hulua nemur ke merei?” ");
INSERT INTO uvl_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Pe Iesus hele, “Iok, a hele lange hehei pe hana ke teare sio.” Kileng neu ana heilil halang pe hehei pe hana teare sio nga lamau. Pe tesis mene hana mur pe te lohot ke iri ana non kina lime iri analoch iri lime (5,000). ");
INSERT INTO uvl_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Ke het pe Iesus mene loi nemur pe hele urana toto lange NeHalang pe heronge lange hulua nemur nenge teare nga lamau. Pe poia ruo nemur ke pomau pule pe hulua nemur te ngau ke saria una toto nga lemeria ngaria. ");
INSERT INTO uvl_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Iok laol, hulua nemur te ngau ke saria una ol pe Iesus hele lange nena hana mur, “A takiraua ruo pe loi aluanuana mur. Pomalam lape ngaunga unne hesil ero.” ");
INSERT INTO uvl_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Iok, Iesus nena hana mur te takiraua loi lime nem aluana mur pe te takiraua ke ana chasang iri analoch pe nai ke te muta. ");
INSERT INTO uvl_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Hulua nemur te esia Iesus nge poia merakulo neu ke pomau pe te hele, “Manmanna toto ke non nei, i hetatalonga nem nenge te teke lape sio at nga ich nei.” ");
INSERT INTO uvl_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Iok, Iesus eteia hulua nemur leteria tuanin ngana mur ke ulolo. Iri te teke lape te laua Iesus pe te echia i ke te teke aria naungaala ana non ia. Pomalam Iesus i toro i haka la mule nga hengene e. ");
INSERT INTO uvl_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Iok, ulei sio lo pe Iesus nena hana mur tei sio langa ech hetaliliu ngana. ");
INSERT INTO uvl_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Pe Iesus at ke lohot nge iri ero mana. Ol pe te lohaka nga sulang pe te mana tele nga ech ke tela nge Kapernam. ");
INSERT INTO uvl_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Pe kileng heingana palaungana lohot pe poia ech ke ur haka ke halang. ");
INSERT INTO uvl_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Teote ke te siklou nga tunangana lo, pe te naue Iesus nge i mana nga ech sana kela tautaua iri. Ol pe te matau toto. ");
INSERT INTO uvl_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Pe Iesus hele lange iri, “A matau ero iau paiam.” ");
INSERT INTO uvl_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Ol pe te poia i ke haka luluch nge iri, pe ueiuei mana tesio nga ech hele nga kileng nenge te lala ia neu. ");
INSERT INTO uvl_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Iok, pomange rou hulua nenge tetu nga ech neu ilina hele kura, te eteia ke Iesus tamu haka luluch nge nena hana mur nga sulang ero. Nena hana mur tela pe i tu. Pe pule te eteia ke aka elle mana ma nga lamau. ");
INSERT INTO uvl_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Ol pe sulang hel teat nga kileng nenge Tiperias ke tesio nga kileng nenge Iesus mene loi pe hele urana toto lange NeHalang pe tunge ke hulua te ngaua. ");
INSERT INTO uvl_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Pe hulua nemur tenau pe Iesus iri hul nena hana mur iri ero mai ol, te lohaka sapele nga sulang nemur pe tela nge Kapernam ke te tango rere i. ");
INSERT INTO uvl_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Iok, nga etue nenge te hottaua Iesus nga ech ilina ele, te onteia i, “Hetoronga, O lotele at lamai nge ngingie?” ");
INSERT INTO uvl_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Pe Iesus tuacholia ke teke, “E hele ke manmanna toto lange imo. Imo a tango rerere iau iange a ngaua ngaunga nem pe samo una toto. Pe nga ure nemur nenge e hele pe te lohot manmana, a tango rere iau ia ero. ");
INSERT INTO uvl_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Ngaunga nenge het mule ke ueiuei, a pur sakilil ia ana tangonga ero. A tango rara tote laka ngaunga nenga maulinga ke koko, nenge Non Tuna lape tunge lange imo. Iange Temere NeHalang tal heke nena kerkerenga lange i ke ulolo.” ");
INSERT INTO uvl_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Pe iri te onteia Iesus, “Ke ume utar mur nenge NeHalang lemene ke teke mo poia?” ");
INSERT INTO uvl_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Pe Iesus hele, “Ume nenge NeHalang teke a poia, ngana koi nei: letemo manmanna nge non nenge i sipona kulosia at.” ");
INSERT INTO uvl_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Ol pe te ontei mule i, “Ke lape o hele mana pe utar lohot ke mo esia pe letemem manmanna nge Iong? Eh, lape o poia utar? ");
INSERT INTO uvl_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Lemem tete mur te ngaua ngaunga menini ngana nga ich sana lomona ke pomanga tehas sue nga NeHalang nena alalaha nge hele ke teke, ‘Ana Non tunge ngaunga nenga tapa ke te ngaua.’” ");
INSERT INTO uvl_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Pe Iesus hele, “E hele ke manmanna toto lange imo. Ngaunga nenga tapa nem Moses tunge lange imo ero. Temek laka nenge tungtunge ngaunga manmanna ngana nem. ");
INSERT INTO uvl_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Ke ngaunga nenge NeHalang, ngana laka i nenge sio at nga tapa ke hesue maulinga nga ich nei.” ");
INSERT INTO uvl_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Pe hulua nemur te hele, “Non Soke, talun heueu nei pe la ol, o tungtunge emem ngaunga nem.” ");
INSERT INTO uvl_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Ol pe Iesus hele ke teke, “Ngaunga nenga maulinga, ngana koi iau lo. Mele nenge at nge iau, lape meteana mule ero ol. Pe mele nenge letena manmanna nge iau lape meteana ech mule ero ol. ");
INSERT INTO uvl_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Pe imo e hele lange imo, a naue iau lo pe letemo manmanna ero toto. ");
INSERT INTO uvl_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Iri lochloch nenge Temek tunge iri at nge iau lape teat nge iau. Pe mele nenge at nge iau lape enek teua i. ");
INSERT INTO uvl_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Iange esio at nga tapa ke e umeia ume nenge NeHalang lemene taua ke teke e poia. Pe e umeia ume nga lemek ngak ero. ");
INSERT INTO uvl_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Ke i nenge kulosia iau at lemene ke teke: Iri lochloch ngana nenge NeHalang tunge iri at nge iau, e hile hote elle nge iri ero toto. Lape e hemaul heke mule iri nga etue nga rume. ");
INSERT INTO uvl_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Ke Temek lemene ke teke, iri nenge tenau la mana nge Tuna pe leteria manmanna nge i, lape te mene maulinga ke koko. Pe lape e hemaul heke mule iri lochloch nga etue nga rume.” ");
INSERT INTO uvl_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Pe Iuta mur te longe ke mau pe te tuainaunau hel rara sapele. Iange Iesus hele ke teke, “Iau laka ngaunga nem nenge sio at nga tapa.” ");
INSERT INTO uvl_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Ol pe te hele, “Non nei ene Iesus pe temene laka ne Iosep. Ita ta eteia temene pe tana. Pe pomerei hele ke teke, ‘Esio at nga tapa’?” ");
INSERT INTO uvl_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Pe Iesus hele, “A tuainaunau hel rara nge imo ero. ");
INSERT INTO uvl_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Mele at nge iau nga i sipona lemene ngana ero. Temek nenge kulosia iau at poia mele nem ke at nge iau. Pe lape e hemaul heke i nga etue nga rume. ");
INSERT INTO uvl_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Hetatalonga mur tehas ke, “‘Iri lochloch, lape NeHalang hetore iri.’ Ke iri lochloch nenge te longe NeHalang pe te nanasia, lape teat nge iau. ");
INSERT INTO uvl_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Mele pele naue Temek ero. Iau toro mana e naue Temek NeHalang iange eat nge i. ");
INSERT INTO uvl_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Pe e hele ke manmanna toto lange imo. Mele nenge letena manmanna nge iau, mene maulinga ke koko ke ulolo. ");
INSERT INTO uvl_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Ngaunga nenge tunge maulinga ke koko ngana koi iau. ");
INSERT INTO uvl_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Lemo tete mur te ngaua ngaunga menini ngana nga ich sana lomona pe te mete. ");
INSERT INTO uvl_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Pe ngaunga nenge sio at nga tapa nei altoto. Mele nenge ngaua ngaunga nei lape mete ero. ");
INSERT INTO uvl_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Pe ngaunga nenga maulinga ke koko nenge sio at nga tapa, ngana koi iau. Pe nenge teke mele ngaua ngaunga nei, lape tu ke maulul mana ol. Ke ngaunga nem, ngana koi iau sipok mirak, nenge lape e tunge. Pe e tunge ke hulua nga ich lochloch ngana te mene maulinga.” ");
INSERT INTO uvl_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Ol pe Iuta mur te hele inin hel rara nge iri pe te hele, “Non nei mai tunge mirana ke ta ngaua ke mere mai?” ");
INSERT INTO uvl_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Pe Iesus hele, “E hele ke manmanna toto lange imo. Nenge teke a ngaua Non Tuna mirana ero pe ainia eina ero, lape atu ke a maulul ero toto. ");
INSERT INTO uvl_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Pe iri nenge te ngaua mirak pe te inia eik, te mene maulinga ke koko. Pe lape e hemaul heke mule iri nga etue nga rume. ");
INSERT INTO uvl_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Iange mirak i ngaunga toto pe eik i ininga toto. ");
INSERT INTO uvl_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Iri nenge te ngaua mirak pe te inia eik, tetu teu luluch nge iau pe etu teu luluch nge iri. ");
INSERT INTO uvl_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Temek nenge tu ke maulul ke kokoes kulosia iau at, pe lape etu ke kokoes ke pomange i. Ke pomalam mana mele nenge ngaua mirak, lape tu ke kokoes ke pomange iau. ");
INSERT INTO uvl_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Iau ngaunga nenge sio at nga tapa pe epoi ke pomanga ngaunga menini ngana nenge lemo tete mur te ngaua ero. Iri te ngaua ngaunga menini ngana nem pe te mete. Pe mele nenge ngaua mirak, lape tetu ke te maulul mana ol.” ");
INSERT INTO uvl_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Iesus hetottoro nga hetoronga ana pele nge Kapernam pe helele ia ure nemur. ");
INSERT INTO uvl_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Pe Iesus nena hana mur te longe pe te ontei, “Hengetoro nei anali toto i. Itei nenge lape longo la ke nek kura mai?” ");
INSERT INTO uvl_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Pe Iesus eteia ke nena hana mur te tuainaunau hel rara lo. Ol pe hele lange iri, “Pomerei? Hengetoro nei helosio ia letemo manmanna ngana kai? ");
INSERT INTO uvl_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Heueu nei, nenge teke a naue Non Tuna nge lohaka la mule nga kileng nenge at ia, lape heporeke letemo manmanna ngana pule? ");
INSERT INTO uvl_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","NeHalang Opene tunge maulinga ke koko; pe none na kerkerenga ana ume pele ero. Ke helenga nemur nenge e heleia lala nge imo nem, Opepengpeng laka nena helenga mur. Pe helenga nemur te tunge maulinga. ");
INSERT INTO uvl_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Pe ero. Amo hel nge imo leteria manmanna ero.” Iesus etei tele iri ke het lo. Iri nenge leteria manmanna ero pe i nenge lape tung heke i langa hana porekreke ngana mur pereia. ");
INSERT INTO uvl_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Ol pe Iesus hele, “Ke ngana laka nenge e hele ke e teke, ‘Mele pele at nge iau ero. Iri nenge Temek poia ke teat nge iau, iri toro mana teat nge iau.’” ");
INSERT INTO uvl_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Iesus hele ke mau ke het pe nena hana mur halang nenge te nanasia i, te ua mule pe te nanasia i ero ol. ");
INSERT INTO uvl_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Pe Iesus onteia nena hana mur nenge iri analoch pe nai neu, “Imo a teke ala pule, ae?” ");
INSERT INTO uvl_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Pe Simon Petrus tuacholia, “Non Soke, lape mola mule nge itei ol? Helenga mur nga maulinga ke koko laka tunge Iong. ");
INSERT INTO uvl_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Pe letemem manmanna pe mo eteia ke Iong NeHalang nena non nenge heongana toto.” ");
INSERT INTO uvl_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Ol pe Iesus tuacholia, “Iau, e henonou hot ke imo analoch pe nai. Pe elle nge imo nanas tau tote non poreke ngana nena poinga mur.” ");
INSERT INTO uvl_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Iesus helele ia Iutas nenge Simon Iskariot tuna. Iutas i none nga Iesus nena hana analoch pe nai neu. Pe nga hoena tung heke mule Iesus lange hana porekreke ngana mur. ");
INSERT INTO uvl_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Ke het pe Iesus i rara nga kileng mur nge Kalelea. Iesus lemene ero nge lange Iutea iange Iuta mur te kulala tote i ke te hune i. ");
INSERT INTO uvl_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Iok, etue nenga ngaunga matana palaugana nenge Iuta mur te mahoch rara nga reria pelpele mur, heroi toto lo. ");
INSERT INTO uvl_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Ol pe Iesus titina mur te hele lange i, “Iong toinge o lohaka nga lamai pe ola nge Iutea ke lem hana mur nga lamau te esia ure nemur nenge o hele pe lohot manmana. ");
INSERT INTO uvl_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Iange mele nenge teke hulua lochloch ngana te eteia i, poi komkome ure mur ero. Ke ure nemur nenge o popoia iri nem, o poia ke hulua lochloch ngana nga ich te naue.” ");
INSERT INTO uvl_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Pe Iesus titina mur leteria manmanna nge i ero pule. ");
INSERT INTO uvl_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Pomalam Iesus hele lange iri, “Iau, ak etue toto ngana at ero kura pe imo etue lochloch urana nge imo. ");
INSERT INTO uvl_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Iange hulua lochloch ngana nga ich nei lape saria keke imo ero. Pe iau, lape saria keke iau iange e hele chach hote ure poreke ngana mur nenge te popoia. ");
INSERT INTO uvl_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Ke pomalam, imo ala nga ngaunga matana palaungana nem. Pe iau lape ela ero iange ak etue toto ngana at ero kura.” ");
INSERT INTO uvl_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Iesus hele ke mau ke het pe tu sapele nge Kalelea. ");
INSERT INTO uvl_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Iok, Iesus titina mur tela nga ngaunga matana palaungana neu lo. Pe Iesus haka la pule. La pe hetei hote i lange hehei pe hana ero. La kome mana. ");
INSERT INTO uvl_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Pe nga ngaunga matana neu, Iuta mur te tangtango pe te ontei rerere i, “Anau ke non nei ngai mai?” ");
INSERT INTO uvl_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Iok, te hele chunuchnuch ia Iesus ke halang toto nga hulua leteria. Hel te teke, “Non nem, non urana ngana iam.” Pe hel te hele, “Ero iam, non nem pallaklaka ia hehei pe hana.” ");
INSERT INTO uvl_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Pe elle nge iri ana seilil ero nge haliu hote Iesus, iange te mataua Iuta mur. ");
INSERT INTO uvl_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Iok laol, ngaunga matana neu teke hetet lo pe Iesus i haka langa NeHalang nena pele palaungana pe talun ke hetoro. ");
INSERT INTO uvl_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Pe Iuta mur leteria tuanin rara pe te hele, “Non nei langa hengetoro e ero toto i. Pe eteia ure lochloch ngana nemur ke merei?” ");
INSERT INTO uvl_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Pe Iesus hele, “Hengetoro nemur nenge e tung hotote nei, iau sipok lek ia ero. At pengpeng nge i nenge kulosia iau at. ");
INSERT INTO uvl_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Nenge teke mele mutena ke nanasia NeHalang lemene ngana, lape eteia ke lek hengetoro nemur teat nge NeHalang. Pe iau sipok lek ero. ");
INSERT INTO uvl_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Pe iri nenge te hetottoro nga iri siporia reria kerkerenga, te teke hehei pe hana te heto hekeke iri. Pe mele nenge lemene ke hehei pe hana te heto heke i nenge kulosia i ke at, heleia helenga nge manmanna pe pallaklaka ero. ");
INSERT INTO uvl_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Moses tunge hotonga mur lange imo. Pe amo e nge imo longo taua hotonga nemur ero. Pe pomerei toto nenge a teke a hune iau mam?” ");
INSERT INTO uvl_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Pe hana nemur te hele, “Iong nge lape uneinei tuteu nge iong iam. Itei nenge teke hunune iong mam e?” ");
INSERT INTO uvl_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Pe Iesus hele lange iri ke teke, “E hele mana pe ute e lohot pe imo lochloch letemo una mana ia. ");
INSERT INTO uvl_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Pe Moses tunge hotonga nenga us rir ngana lange imo. (Hotonga nem talun nge Moses ero. Talun nge lemo tete mur nike.) Pe imo arir us nga Sapat ana etue. ");
INSERT INTO uvl_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Imo a nanas tau pengpeng ia hotonga nem ke nenge teke a riria mamau sune nga Sapat ana etue, a teke ute pele ero. Pe pomerei nenge letemo inin taua iau nge e hemasia none nga etue nem pule? ");
INSERT INTO uvl_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","A henonou pulut mene perimo langa mele na poinga ero. A amnei teu la ke nek toto mukam. Ke het pe a heleia ke ma ke pengpeng.” ");
INSERT INTO uvl_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Nga etue neu pengpeng hana hel nge Ierusalem te talun ke te ontei sapele, “Non nenge te teke te hunune kaloi? ");
INSERT INTO uvl_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Ngana paiam haliuliu nga hulua leteria pe te poia helenga unne lange i ero mana pamam. Eh, lape hana nenge iri mukmuka te teke non nei i Kristus kai? ");
INSERT INTO uvl_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Ero nike. Ita ta eteia non nei na kileng. Pe nga etue nenge Kristus at, mele eteia at ngana ero.” ");
INSERT INTO uvl_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Iesus hetottoro nga NeHalang nena pele ana sauach kura pe alngana hot, “Oe, imo a eteia iau pe a eteia eat ngak. Pe eat lamai nga iau sipok lemek ngak ero. Pe i nenge kulosia iau at tu ke manmanna pe imo a eteia i ero. ");
INSERT INTO uvl_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Pe iau e eteia i iange etu luluch nge i pe i kulosia iau at.” ");
INSERT INTO uvl_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Iesus hele ke mau pe hana nemur te teke te laua i, pe ero. Iange ana etue toto at ero kura. ");
INSERT INTO uvl_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Pe hulua halang nga iri nenge temes neu, leteria manmanna nge Iesus. Pe te hele, “Iok, non nei poia ure halang ke te lohot ke ulolo, pe non nenge mene tuangaola nge heo ngana at pe lape poia ure halang toto ke te lohot ol?” ");
INSERT INTO uvl_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Ol pe Paresio mur te longe hulua nge te hele chunuchnuch ia ure nemur nge Iesus. Pomalam tunginga ana hana papalauna mur pe Paresio mur te kulosia NeHalang nena pele ana naungaala mur ke te laua Iesus. ");
INSERT INTO uvl_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Pe Iesus hele, “Iau lape etu luluch nge imo ke etue choro mana ol pe lape ela mule nge i nenge kulosia iau at. ");
INSERT INTO uvl_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Pe lape a tango rere iau pe a hottaua iau ero. Pe aat nga kileng nenge etu ia ero.” ");
INSERT INTO uvl_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Ol pe Iuta mur te ontei hel nge iri, “Non nei mai teke la langai nenge lape ta hottaua i ero mai? Ita rera hana mur tetu nga kileng papalauna nemur nge Krik. Pe lape non nei lange iri ke hetottore iri kai? ");
INSERT INTO uvl_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Na helenga nei luna merei? Nenge hele ke teke, ‘Lape a tango rere iau pe a hottaua iau ero. Pe kileng nenge etu ia, amo e at ia ero.’” ");
INSERT INTO uvl_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Iok, nga ngaunga matana neu ana etue nenge het ia, i etue palaungana ia. Pe Iesus mes haka pe hele ke palaungana toto, “Mele nenge meteana ech, at nge iau ke in ech. ");
INSERT INTO uvl_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Mele nenge letena manmanna nge iau, NeHalang nena alalaha hele ke teke, ‘Lape ech tana nenge tunge maulinga ke koko lape lelele nga letena.’” ");
INSERT INTO uvl_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Nga nenge nei Iesus helele ia Opepengpeng. Opepengpeng nem te tung hote ero kura. Pe nga etue nenge Iesus lohaka mule ke mene hemalmalinga palaungana ol, iri nenge leteria manmanna nge Iesus lape te mene Opepengpeng nem ol. ");
INSERT INTO uvl_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Hulua te longe Iesus nena helenga mur pe hel te hele, “Manmanna toto ke non nei i Hetatalonga.” ");
INSERT INTO uvl_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Pe hel te hele, “Non nei, i Kristus.” Pe hel pule te hele, “Kristus at nga kileng nenge Kalelea ero. ");
INSERT INTO uvl_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","NeHalang nena alalaha hele ke teke, Kristus at nge Petlehem nga kileng nenge ne Teuit tutu ia. Pe lohot pengpeng nge ne Teuit na tete mur.” ");
INSERT INTO uvl_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Nenge nei poia hulua nemur ke telas lele hel. ");
INSERT INTO uvl_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Ke hel te teke te laua Iesus pe mele pele sie i ero. ");
INSERT INTO uvl_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Ol pe NeHalang nena pele ana naungaala mur tela mule pe tunginga ana hana mur aria papalauna mur pe Paresio mur te onteia iri, “Pomerei nenge a mene Iesus at ero mam?” ");
INSERT INTO uvl_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Pe naungaala nemur te hele, “Non e hele ngana pomange non nei ero i.” ");
INSERT INTO uvl_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Pe Paresio mur te hele, “Luna pomanga a teke i pallaka ia imo pule. Ae? ");
INSERT INTO uvl_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Pe a longe hana papalauna hel pe Paresio hel nge leteria manmanna nge i pule? Ero le. ");
INSERT INTO uvl_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Pe hulua pa nemur nenge te eteia hotonga mur ero, NeHalang lape hemete iri.” ");
INSERT INTO uvl_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Pe non Paresio e nge ene Nikotemus la tala ke esia Iesus lo. Ana non lohaka pe hele ke teke, ");
INSERT INTO uvl_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Ita rera hotonga hele ke teke talau pulut mene none ero. Ta longo teu lange i ke nek pe tanau urume ure nemur nenge popoia mukam.” ");
INSERT INTO uvl_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Pe hana nemur te hele, “Iong mam lem nge Kalelea pule ma? Onau teu langa NeHalang nena alalaha ke nek mukam. Pe lape o eteia ke hetatalonga pele at nge Kalelea ero.”  ");
INSERT INTO uvl_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Ke het pe iri lochloch tela mule nga reria kileng mur. ");
INSERT INTO uvl_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Pe Iesus langa hengene nge Oliua. ");
INSERT INTO uvl_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Iok, nga uach uruna Iesus la mule nga NeHalang nena pele palaungana. Pe nga lamau hulua teat nge i. Ol pe Iesus are sio pe hetottore iri. ");
INSERT INTO uvl_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Pe hotonga ana hetoronga mur pe Paresio mur te mene teua hei salaunga kina e pe te poia hei neu ke mes nga hulua mataria. ");
INSERT INTO uvl_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Pe te hele lange Iesus, “Hetoronga, hei nei te hottaua i nge salaulau. ");
INSERT INTO uvl_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Pe hotonga nenge Moses hele ke teke hei nenge pomai ta tamal hune ana um. Iok o hele, lape mopoi ke mere?” ");
INSERT INTO uvl_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Iri te teke tetua laka hote i ke heleia helenga poreke ngana e. Pomalam te tamal hote onteinga neu. Pe ero. Iesus tatuch sio ke has nga ich nga penna kukanna. ");
INSERT INTO uvl_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Pe hana nemur te onteitei kura. Pomalam Iesus mes haka pe hele, “Nenge teke amo e nge imo poia poinga poreke ngana e ero toto, i muka ia imo ke tamal tele hei nem.” ");
INSERT INTO uvl_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Pe Iesus tatuch sio mule ke has nga ich. ");
INSERT INTO uvl_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Hana nemur te longe helenga neu pe te ua ke iri ellechle. Hana tuauna ngana mur te ua tala pe kulpo mur te nanasia iri. Lala kela Iesus i toro mana tu ol pe hei neu pule mes nga munna kura. ");
INSERT INTO uvl_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Ol pe Iesus mes haka pe onteia hei neu, “Hei nem, hana nemur ol? Pomere, mele e nge tu ke palot am melmelenga ana helenga ero kai?” ");
INSERT INTO uvl_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Pe hei neu hele, “Non Soke, mele ero ol i.” Pe Iesus hele, “Iau lape e hele hote iong ero pule. Ola pe o poia poinga poreke ngana ero ol.” ");
INSERT INTO uvl_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Iok, nga etue nenge Iesus hele la mule nge hehei pe hana, hele ke teke, “Iau lemenge nenga ich nei. Mele nenge nanasia iau lape i nga kileng au ngana ero ol. Iange lape mene lemenge nenga maulinga.” ");
INSERT INTO uvl_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Ol pe Paresio mur te hele, “Nga etue nenge o hele urumrume iong, iong toro mana o teke ure nemur manmanna. Pe imem mo teke o channanga.” ");
INSERT INTO uvl_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Pe Iesus hele, “Oe, iau sipok e hele urumrume iau. Pe lek helenga nemur manmanna iange iau e eteia eat ngak pe e eteia ela ngak. Pe imo a eteia eat ngak pe ela ngak ero. ");
INSERT INTO uvl_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Imo a amnei teu ngamo nga ure mur, a poia nga poinga nemur nga ich. Pe iau e henonou perik lange mele nga poinga poreke ngana e ero. ");
INSERT INTO uvl_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Pe nenge teke e amnei teu langa mele nena poinga, lek helenga mur manmanna iange iau toro e poia ero. Temek nenge kulosia iau at tu luluch nge iau pe e poia. ");
INSERT INTO uvl_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Imo lemo hotonga hele ke teke, ‘Nenge teke hana nai te hele hote helenga elle, helenga nem manmanna.’ ");
INSERT INTO uvl_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Pe iau, iau toro koi nenge e hele urumrume iau nei. Pe neingak laka Temek nenge kulosia iau at.” ");
INSERT INTO uvl_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Ol pe hana nemur te ontei, “Ke Temem ngai?” Pe Iesus hele, “Imo a eteia iau ero pe a eteia Temek ero. Nenge teke a eteia iau, lape a eteia Temek pule.” ");
INSERT INTO uvl_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Iesus hetottoro nga NeHalang nena pele palaungana letena nga tunginga mur tema ngaria, pe helele ia helenga nemur. Pe mele pele laua i ero iange ana etue at ero kura. ");
INSERT INTO uvl_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Pe pule Iesus hele lange hehei pe hana ke teke, “Iau e lala lo koi. Pe lape a tongo rere iau pe a mete hite lemo poinga poreke ngana mur. Pe lape a at nga kileng nenge e lala ia nei ero.” ");
INSERT INTO uvl_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Iuta mur te longe helenga neu pe te ontei hel mule nge iri ke mai, “Pomerei nenge hele ke teke, ‘Imo lape at nga kileng nenge e lala ia nei ero mai?’ Lape i sipona hun mule i kai?” ");
INSERT INTO uvl_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Pe Iesus hele, “Imo lemo nge sio pe iau lek nga lut. Imo lemo nga ich nei pe iau lek nga ich nei ero. ");
INSERT INTO uvl_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Pe e hele ke e teke lape a mete hite lemo poinga poreke ngana mur. Iau laka nenge e teke iau koloi. Pe nenge teke letemo manmanna nga nei ero, manmanna toto ke lape a mete hite lemo poinga poreke ngana mur.” ");
INSERT INTO uvl_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Pe hana nemur te ontei, “Ke iong itei nemam?” Pe Iesus tuacholia, “Iau itei? Nem e heleia lange imo ke ulolo. ");
INSERT INTO uvl_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Pe lek helenga halang nge lape e hele hote lemo poinga poreke ngana mur. Pe i nenge kulosia iau at na poinga mur pengpeng toto. Pe ure nemur nenge e longe nge i, e heleia ke pengpeng lange hehei pe hana nga ich nei.” ");
INSERT INTO uvl_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Iesus helele ia Temene pe hehei pe hana te eteia ero. ");
INSERT INTO uvl_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Ke pomalam Iesus hele, “Nga etue nenge a heon heke Non Tuna, lape a eteia ke iau laka nenge e teke iau koloi. Pe lape a eteia ke e poia ute pele nga lemek ngak ero. E hele ke pomanga Temek hetoro iau ia. ");
INSERT INTO uvl_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Iange i nenge kulosia iau at, ngana koi tu luluch nge iau; Hile iau ke iau toro ero iange e nanas mene lemene ngana ke kokoes.” ");
INSERT INTO uvl_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Iesus hele ke mau pe hulua leteria manmanna nge i. ");
INSERT INTO uvl_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Ol pe Iesus hele lange Iuta mur nenge leteria manmanna nge i ke teke, “Nenge teke a rahite lek hengetoro mur ke kerkereng, lape lek hana mur toto laka imo. ");
INSERT INTO uvl_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Pe lape a eteia helenga manmanna ngana. Pe helenga manmanna ngana nem lape un hote ure mur nenge rahit ele imo pe poia imo ke a ume manmanna nge mele ero ol.” ");
INSERT INTO uvl_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Pe iri te hele, “Apraham nena tete mur i imem. Pe mo ume nge mele ero kura i. Pe pomere nenge o hele ke o teke lape mo ume manmanna nge mele ero ol?” ");
INSERT INTO uvl_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Pe Iesus tuacholia, “E hele ke manmanna lange imo. Iri lochloch nenge te popoi poinga poreke ngana, poinga poreke ngana nem chiu hit tote iri ke tepoi manmana poinga poreke ngana ke kokoes. ");
INSERT INTO uvl_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Hekuleileinga ana non nenge tu luluch nge none pe nehei pe tutuna mur, i tuteu toto nge iri ero. Pe non nem tuna mana lape tu teu toto nge temene pe tana. ");
INSERT INTO uvl_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Ke nenge teke NeHalang Tuna poia imo ke atu ke nek, lape atu ke nek toto sapele. ");
INSERT INTO uvl_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","E eteia ke Apraham nena tete mur imo. Pe imo a teke a hune iau iange a mene lek hengetoro mur ero. ");
INSERT INTO uvl_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Pe e helele ia ure nemur nenge Temek henonou iau ia lala nge imo. Ke imo a poia laka ure nemur nenge Tememo NeHalang teke a poia.” ");
INSERT INTO uvl_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Pe iri te tuacholia, “Imem tememem laka Apraham.” Pe Iesus hele, “Toinge Apraham tutuna mur imo ke manmanna, lape lemo poinga mur pomanga Apraham nena poinga mur nike. Pe ero. ");
INSERT INTO uvl_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Helenga manmanna ngana mur nenge e longe nge NeHalang e hele hote lange imo. Pe ero, a teke a hunune iau kura. Pe Apraham poia poinga pele nge pomai ero. ");
INSERT INTO uvl_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Tememo nena poinga laka nenge a popoia nem.” Pe iri te hele, “Ouo! Iong o teke imem tememem itei? Imem tamem hei salaunga kina e ero i! Imem Tememem laka NeHalang i toro.” ");
INSERT INTO uvl_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Pe Iesus hele lange iri, “Nenge teke Tememo toto NeHalang toinge lememo taua iau. Iange iau etu luluch nge i koi nenge eat nei. Pe eat nga iau sipok lemek ngak ero; i sipona kulosia iau ke eat. ");
INSERT INTO uvl_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Pe lek helenga mallaha nge imo ero iange lememo ero ia lek hengetoro mur. ");
INSERT INTO uvl_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Imo tememo laka non poreke ngana ke a nanas tau menmene nena poinga mur. I hunun hana ke te metmete nga tele ngana toto nike. Pe i nge lemene ero ia helenga manmanna ngana iange helenga manmanna ngana e tu nge i ero toto. I hetei hot pengpeng ia i nga nena pallakanga mur. Iange i pallaka hali pe pallakanga kina i toto. ");
INSERT INTO uvl_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Pe iau e heleia helenga nge manmanna pe letemo manmanna ia lek helenga ero. ");
INSERT INTO uvl_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Amo tei hottaua iau nge e poia poinga poreke ngana e lo? Iau e helele ia helenga nge manmanna. Pe pomerei letemo manmanna nge iau ero? ");
INSERT INTO uvl_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","NeHalang tutuna mur laka iri nenge te longo taua nena helenga mur. Pe imo a longo taua nena helenga mur ero. Luna pomanga NeHalang tutuna mur imo ero.” ");
INSERT INTO uvl_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Pe Iuta mur te hele inin taua i, “Iong uneinei laka tuteu nge iong iange lem nge Samaria iam.” ");
INSERT INTO uvl_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Pe Iesus hele, “Iau uneinei tu teu nge iau ero. Iau e heto heke tote Temek pe imo atal sio tote iau. ");
INSERT INTO uvl_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Iau lemek ke hehei pe hana te heto heke iau ero. Mele e pule lemene ke teke hehei pe hana te heto heke iau. Pe i, ana ume nenge amnei urumrume poinga mur. ");
INSERT INTO uvl_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Pe e hele ke manmanna toto lange imo. Mele nenge longo taua lek hengetoro mur lape mete ero.” ");
INSERT INTO uvl_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Pe Iuta mur te hele, “Nenge nei mo eteia ke uneinei tu teu nge Iong! Iange Apraham pe hetatalonga mur te mete lo. Pe iong o teke, ‘Mele nenge nanasia lek hengetoro mur ke nek lape mete ero.’ ");
INSERT INTO uvl_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Ita rette Apraham mete ke ulolo. Pe pule hetatalonga mur te mete lo. Pe iong mam! O teke iong palaungana toto nge i ma? O teke iong itei panem mam?” ");
INSERT INTO uvl_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Pe Iesus hele, “Nenge teke e heto heke iau sipok ek, lape luna ero toto. Pe Temek NeHalang nenge a heto amo Soke ia, i sipona hemalmalia iau. ");
INSERT INTO uvl_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Iau e eteia i pe imo a eteia i ero toto. Pe nenge teke e hele ke e eteia i ero, lape iau non nenge e pallaklaka ke mange imo. Pe iau e rahite nena helenga mur iange e eteia i. ");
INSERT INTO uvl_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Tememo Apraham iech toto nge lape esia iau nga ak etue. I esia pe iech ele tote.” ");
INSERT INTO uvl_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Pe Iuta mur te hele lange i, “Ia iong mam o naue Apraham lo ma? Am hesinga iri ana non kina nai pe analoch ero kura iam.” (30) ");
INSERT INTO uvl_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Pe Iesus hele, “E hele ke manmanna toto lange imo. Apraham tana hoe i ero kura pe iau etu tala lo.” ");
INSERT INTO uvl_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Iesus hele ke mau pe Iuta mur te lolochia um ke te teke te tamal hune i. Pe ero. Iesus erue sio nga mataria pe i hot nga NeHalang na pele palaungana neu ke lange hot. ");
INSERT INTO uvl_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Iok, Iesus i olole pe naue none nge matana hit. Non neu tehoe i pe matana hit nike. ");
INSERT INTO uvl_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Ol pe nena hana mur te onteia i, “Hetoronga, itei toto poia poinga poreke ngana nenge non nei te hoe pe matana hit mai? Isipona ma alona mur?” ");
INSERT INTO uvl_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Pe Iesus hele, “Non nei tehoe pe matana hit. Isipona pe alona mur te poia poinga poreke ngana e ero. Pe ure nei lohot ke hemallaha hote NeHalang nena kerkerenga nge non nei. ");
INSERT INTO uvl_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Heueu nei uach mana kura pe ta popoia i nenge kulosia iau at nei ana ume. Iange miliko at pe mele lape ume ero ol. ");
INSERT INTO uvl_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Nga etue nenge e tutu nga ich nei, iau sipok iau lemenge nenga ich.” ");
INSERT INTO uvl_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Iesus hele ke mau ke het pe ulut sio nga ich pe poia melete nga melona. Ke het pe unhite nga non neu matana. ");
INSERT INTO uvl_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Ol pe hele lange non neu, “Ola ke onun nga ech matana nenge Siloam.” (helenga neu luna, Kulosia la.) Ke non neu la ke nun pe at mule pe nau ke nek sapele. ");
INSERT INTO uvl_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Pe non neu na kileng ngana mur pe iri nenge te naue i nge long usus ure nga tele ngana te ontei, “Non nenge arare pe long usus ure nge hehei pe hana mam lom?” ");
INSERT INTO uvl_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Pe hel te hele, “Oe, i laka lom.” Pe hel teke, “Ero, i mele e pule pe nakuna mange non nem iam.” Pe non neu hele, “Iau sipok i loi.” ");
INSERT INTO uvl_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Pe iri te ontei, “Pe matam urana mule ke merei?” ");
INSERT INTO uvl_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Pe non neu hele, “Non nenge te hetue ene ke Iesus, poia melete pe unhite nga matak. Pe hele at nge iau kela enun nge Siloam. Iok, ela ke enun pe enau mule sapele!” ");
INSERT INTO uvl_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Pe iri te ontei, “Ke ana non nem ngai?” Pe non neu tuacholia, “E etei ero i.” ");
INSERT INTO uvl_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Ol pe hana nemur te mene non mata hit neu lange Paresio mur. ");
INSERT INTO uvl_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Pe Iesus une melete nga non neu matana ke urana mule nga Sapat ana etue. ");
INSERT INTO uvl_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Pomalam Paresio mur te onteia non neu, “Iong mam onau mule ke merei?” Pe non neu hele, “Iesus poia melete nga matak pe enun pe enau mule sapele.” ");
INSERT INTO uvl_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Ol pe Paresio mur hel te hele, “Nakuna nenge non nei NeHalang kulosia at ero i, ngana kai nenge nanasia hotonga mur nga etue palaungana nei ero mai.” Pe hel te hele, “Nenge teke non nei i non nge popoi poinga poreke ngana, poi hote ure palaungana e nge pomai ero.” Pomalam telas lele hel sapele. ");
INSERT INTO uvl_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Ol pe te ontei mule non neu, “O amnei lange non nenge poia matam ke urana mule nem, non tei toto ia mau?” Pe ana non tuacholia, “Non nem i hetatalonga ia laka.” ");
INSERT INTO uvl_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Non neu matana hit tala mukam pe heueu nei nau mule ke nek ol. Pe Iuta mur leteria manmanna nga neu ero. Ol pe te hekulo non neu temene pe tana aria ");
INSERT INTO uvl_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","pe te onteia iri, “Tumo nenge a teke ahoe pe matana hit ka loi? Iok, heueu nei matana urana mule ke merei?” ");
INSERT INTO uvl_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Pe non neu temene pe tana te hele, “Mo eteia ke i tumem ia nge mo hoe pe matana hit. ");
INSERT INTO uvl_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Pe heueu nei matana charchara pe es ke nek mule. Nenge nem imem mo etei teu la ero ol. Itei toto nenge poia matana ke charchara mule? Ana non i palaungana lo. A onteia i pe hele lange imo la.” ");
INSERT INTO uvl_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Non neu temene pe tana te hele ke mai iange te mataua Iuta mur aria papalauna mur nge te hele ke te teke, nenge teke mele heleia Iesus nge i Non nge Hemasinga, lape tepoi ele mele nem ke langa hetoronga ana pele ero ol. ");
INSERT INTO uvl_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Ke ngana laka nenge temene pe tana te hele ke te teke, “Ana non i palaungana lo. A onteia i pe hele lange imo la.” ");
INSERT INTO uvl_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Iok, te iua non mata hit nenge matana urana mule neu henai ngana, pe te hele, “O heto haka tote NeHalang ene pe o hele ke manmanna. Imem mo eteia ke non nenge o helele ia nem i non poreke ngana.” ");
INSERT INTO uvl_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Pe non neu tuacholia, “A teke non nem i non poreke ngana, nem e eteia ero. Pe ute elle mana nge e eteia. Ngana laka nenge; iau matak hit mukam pe heueu nei e es mule ol.” ");
INSERT INTO uvl_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Ol pe hana nemur te ontei, “Iok, poia utar lange iong? Pe poia iong ke matam charchara ke merei?” ");
INSERT INTO uvl_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Pe non neu tuacholia, “E hele lange imo ke ulolo pe lememo ero nge a longe. Pe pomerei toto nenge a teke a longo mule? A teke a lohot ke nena hana mur imo pule? Ae?” ");
INSERT INTO uvl_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Ol pe te hele inin taua i ke te teke, “Non nem nena non laka iong. Imem, Moses nena non mur koi imem. ");
INSERT INTO uvl_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Pe mo eteia ke NeHalang hele lala nge Moses lo, pe non nem mo eteia at ngana ero iam.” ");
INSERT INTO uvl_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Pe non neu hele, “Apoi letek lilil iam. Non nei poia matak ke charchara mule. Pe pomere a teke a eteia at ngana ero? ");
INSERT INTO uvl_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Ita lochloch ta eteia ke NeHalang longo lala nge iri nemur nenge te heto hekeke i pe te longo tautaua i. Pe iri nemur nenge te popoi poinga poreke ngana NeHalang longo lange iri ero. ");
INSERT INTO uvl_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","A longe mele nge tehoe pe matana hit pe none hemas mule i lo? ");
INSERT INTO uvl_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Nenge teke NeHalang kulosia non nei ke at ero, lape poia ute pele ero.” ");
INSERT INTO uvl_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Pe hana nemur te hele, “Iong tam hoe iong pe poinga poreke ngana tu luluch nge iong nike. Pe o teke o hetoro mule kai imem mai?” Ol pe telope hote i nga hetoronga ana pele. ");
INSERT INTO uvl_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Iok, Iesus longe non neu nge te lope hote i nga hetoronga ana pele pe la ke hottaua i. Pe Iesus hele, “Letem manmanna nge Non Tuna?” ");
INSERT INTO uvl_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Pe non neu ontei, “Non Soke, Non Tuna mam itei toto ia? O heleia at nge iau. Pomalam lape letek manmanna nge i.” ");
INSERT INTO uvl_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Pe Iesus hele lange non neu, “Ngana iam o esesia i nemam lom. Non Tuna laka nenge hele lululuch nge iong nem.” ");
INSERT INTO uvl_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Pe non neu hele, “Non Soke, letek manmanna nge iong.” Ol pe non neu tualou sio pe heto heke Iesus. ");
INSERT INTO uvl_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Pe Iesus hele, “Eat nga ich nei ke e tatalo ele hehei pe hana nga etue palaungana nenge atat. Pe eat ke iri nemur nenge mataria hit tenau mulmule pe iri nenge te nachnau mataria hitit.” ");
INSERT INTO uvl_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Pe Paresio mur hel nge tetu rochroi nge Iesus, te longe Iesus nge hele ke mau pe te ontei, “Ke pomerei? Imem nei matamem hit pule kai?” ");
INSERT INTO uvl_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Pe Iesus hele, “Nenge teke matamo hit lape lete meena ngana nga poinga poreke ngana ero nge imo. Pe heueu nei a hele ke a teke a nachnau kura. Pomalam lete meena ngana nem tu nge imo kura.” ");
INSERT INTO uvl_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Pe Iesus hele pule ke teke, “E hele ke manmanna toto lange imo. Sipsip mur tetu teu nga mapuo letena. Pe mele nenge i teu nga mapuo nem matana ero pe tamu tote mapuo ke lange teu, mele nem i non nenge kemkeme pe hunun. ");
INSERT INTO uvl_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Pe non nenge i teu nga mapuo nem matana, mele nem i non nenge nauelele sipsip mur. ");
INSERT INTO uvl_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Pe non nenge nauelele mapuo nem matana lohe piunga nge i. Pe sipsip mur te longo urume non nenge nauelele iri kanna. Pe hetetue nena sipsip mur eria pe koko hote iri ke tela nge hot. ");
INSERT INTO uvl_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Nga etue nenge koko hote nena sipsip mur, ana non i ke i mukmuka nge nena sipsip mur. Pe nena sipsip mur te nanasia i iange te longo urume kanna. ");
INSERT INTO uvl_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Pe sipsip nemur te nanas pulut mene none ero. Iri lape te ua mule non nem ana iange te longo urume kanna ero.” ");
INSERT INTO uvl_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Iesus nene nananga nei lange hehei pe hana pe te eteia luna ero toto. ");
INSERT INTO uvl_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Ol pe Iesus hele mule, “E hele ke manmanna lange imo, sipsip nemur reria piunga matana koi iau. ");
INSERT INTO uvl_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Pe iri nemur nenge teat tala nge iau, iri hana nenge te kemkeme pe iri hana nenge te hunun. Pe sipsip nemur te longo urume karia ero. ");
INSERT INTO uvl_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Iau nge iau piunga matana koloi. Pe mele nenge iteu pengpeng nge iau, lape NeHalang mene mule i. Pe lape i teueu pe i hotot ke menmene ana ngaunga. ");
INSERT INTO uvl_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Kemenge kina mur teat ke te kemkeme pe te hunun pe te heporeke sipsip mur. Pe iau eat ia maulinga nge iri. Pe maulinga nem lape muta toto nge iri. ");
INSERT INTO uvl_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Iau sipok, iau non urana ngana nenge enau elele sipsip mur. Pe non urana ngana nenge nauelele sipsip mur, tung heke i sipona ke mete ke halaua nena sipsip mur. ");
INSERT INTO uvl_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Pe non nenge umume ke nauelele sipsip mur pe te ololia i, nena sipsip toto nemur ero. Nga etue nenge non nem naue kaone hinolo nge atat, lape ua pe sipsip nemur iri toro tetu ol. Pe kaone hinolo nem at ke hun lapue sipsip nemur pe telot parai. ");
INSERT INTO uvl_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Non nem poia poinga nei iange ume nenge teol mene i. Pe letena tu toto nge sipsip nemur ero. ");
INSERT INTO uvl_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","“Iau sipok, iau non urana ngana nenge enau elele sipsip mur. E etei tote lek sipsip mur pe iri te etei tote iau. ");
INSERT INTO uvl_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Pomalam mana nge Temek nge etei tote iau pe iau e etei tote i. Pe e tung heke iau ke e mete ke e halaua lek sipsip mur. ");
INSERT INTO uvl_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Pe lek sipsip mur hel pule tetu teu nga mapuo nei ero. Iri pule te longo urume kalik pe lape e mene iri at pule. Ke lape sipsip mur aria tuluk elle pe aria naungaala elle mana. ");
INSERT INTO uvl_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Temek mutena tau tote iau iange e tung heke iau ke e mete pe lape e maul haka mule. ");
INSERT INTO uvl_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Mele pele nakuna ero toto nge hemete tote iau. Iau sipok e tung heke iau nga lemek ngak. Nga iau sipok lek kerkerenga e tung heke iau ke e mete. Pe nga iau sipok lek kerkerenga e lohaka mule nga metenga. Nenge nei Temek i sipona heleia at nge iau.” ");
INSERT INTO uvl_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Iuta mur te longe Iesus na helenga nemur pe telas hel mule. ");
INSERT INTO uvl_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Pe halang nge iri te hele, “Uneinei tu teu nge i pe poia i ke ana hauaua tototo lola. A longo lange i ke?” ");
INSERT INTO uvl_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Pe hel te hele, “Non e nenge uneinei poia ke ana hauaua toto, heleia helenga nemur nenge pomai ero. Uneinei pele mam poia non mata hit e ke matana charchara mule loma, ae?” ");
INSERT INTO uvl_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Iok laol, hetalaulaunga ana etue palaungana lohot nge Ierusalem. Nga etue neu leteria metene mule nenge te tunge pele palaungana lange NeHalang ke nena ia nge nike. Pe etue neu lohot laka nga kileng lololo ngana ana etue. ");
INSERT INTO uvl_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Iok, Iesus ii nga NeHalang na pele palaungana. Pe ii nga pele palaungana nem unne nenge te etue ke ene Ne Solomon Nena Sauach. ");
INSERT INTO uvl_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Pe Iuta mur te heliliu hite i pe te hele, “Nge ngingie ol pe o hemallaha hote iong at nge imem? O hele pengpeng mana, iong Kristus mam lom ae?” ");
INSERT INTO uvl_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Pe Iesus hele, “E hele lange imo ke ulolo pe letemo manmanna ero. Ure nemur nenge e hele pe te lohot manmana, e poia nga Temek ene. Pe ure nemur te hemallaha hote iau. ");
INSERT INTO uvl_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Pe imo letemo manmanna nge iau ero toto iange lek sipsip mur imo ero. ");
INSERT INTO uvl_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Iau e eteia lek sipsip mur pe iri te longo urume kalik pe te nanasia iau. ");
INSERT INTO uvl_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Pe iri lape te mete ero ol iange e tunge maulinga ke koko lange iri pe tetu nga perik. Pe mele pele mene hote iri ero toto. ");
INSERT INTO uvl_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Temek tunge sipsip nemur at nge iau. Pe i, i palaungana toto nga hehei pe hana lochloch. Pe mele pele mene hote iri nga Temek penna ero toto. ");
INSERT INTO uvl_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Imem nai Temek imem elle mana.” ");
INSERT INTO uvl_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Ol pe Iuta mur te lochloch um ke te teke te tamal hun mule Iesus. ");
INSERT INTO uvl_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Pe Iesus hele lange iri, “Iau e henonou hote Temek nena kerkerenga lange imo, nga nenge e hele pe ure te lohot manmana. Pe tei toto nenge poia imo ke a teke a tamal hun iau ia, e?” ");
INSERT INTO uvl_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Pe Iuta mur te hele, “Mo tamal hune iong nga ure nemur ero. Mo teke mo tamal hune iong iange, iong none mana pe o hele poreke tote NeHalang, nga nenge o teke imo nai NeHalang imo elle mana!” ");
INSERT INTO uvl_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Pe Iesus hele lange iri, “NeHalang nena helenga masio nga lemo hotonga pule nenge hele ke teke, ‘Imo nehalang.’ ");
INSERT INTO uvl_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Nge nike hana nenge te longe NeHalang nena hotonga, NeHalang hetue iri ke iri nehalang. Pe helenga nenge masio nga NeHalang nena alalaha helenga nem manmanna. ");
INSERT INTO uvl_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Iau NeHalang i sipona hesilei hote iau pe kulosia iau ke esio at nga ich nei. Pe pomerei a hele ke a teke e hele poreke NeHalang nenge e hele ke e teke, ‘Iau NeHalang Tuna’? ");
INSERT INTO uvl_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Nenge teke e poia Temek ana ume ero, urana nge letemo manmanna nge iau ero. ");
INSERT INTO uvl_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Pe nei e popoia Temek ana ume. Pe pomerei letemo manmanna nge iau ero? Pomam, letemo manmanna nga ure nemur nenge e hele pe te lohot manmana. Pomalam lape letemo mallaha pe a eteia ke Temek tuteu luluch nge iau pe iau etu teu luluch nge Temek.” ");
INSERT INTO uvl_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Ol pe Iuta mur te teke te laua Iesus, pe Iesus sereha mana nga peria pe la. ");
INSERT INTO uvl_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Iok, Iesus lotele nga ech nge Iortan kela mule nga kileng nenge Ioanes henunun hehei pe hana ia nge nike, kela tu lamau. ");
INSERT INTO uvl_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Pe hulua halang tela nge i pe te hele, “Ioanes hele pe ure mur te lohot mana ero. Ure lochloch ngana nenge Ioanes helele ia nge non nei, lohot ke manmanna.” ");
INSERT INTO uvl_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Pe hulua halang nga kileng neu leteria manmanna nge Iesus. ");
INSERT INTO uvl_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Iok, none nge ene Lasarus singina haleles. Pe ana non tu nge Petani nga kileng nenge Maria iri nai tina Marta te tutu ia. ");
INSERT INTO uvl_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Pe Maria nei, i laka nenge nga hoena pasiling heke ure inangana ehech ngana nga Iesus apena pe unhite nga palpalna ina. Pe Lasarus nenge singina haleles neu, liliuna mur koi hehei nai nei. ");
INSERT INTO uvl_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Ke Maria iri nai Marta te hekulo helenga lange Iesus, “Non Soke, non nenge mutem tau tote koi singina haleles.” ");
INSERT INTO uvl_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Iok, Iesus longe ke mau pe hele, “Non nem lape mete hot ia haleles nem ero. Haleles nem lape poia hehei pe hana ke te naue NeHalang nena kerkerenga pe te heto heke tote NeHalang ene. Pe nga kue nem mana lape te heto heke tote NeHalang Tuna ene pule.” ");
INSERT INTO uvl_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Iesus mutena tau tote Marta pe tina pe Lasarus. ");
INSERT INTO uvl_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Pe nga etue nenge longe Lasarus pingana nge singina haleles la sapele ero. Tunga kileng nenge tutuia neu ke etue nai mule. ");
INSERT INTO uvl_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Ol pe Iesus hele lange nena hana mur, “Tala mule nge Iutea.” ");
INSERT INTO uvl_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Pe nena hana mur te hele, “Hetoronga, Iuta mur nga lamau te teke te tamal hune iong nga um. Pe etue halang la ero kura. Pe ngana ma o teke ola mulmule mam pulom?” ");
INSERT INTO uvl_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Pe Iesus hele, “Chaia matana haka nga uach pe sio mule nga ulei. Pe mele nenge ii nga etue nem lape losio ero, iange nachnau nga lemenge nenga ich nei. ");
INSERT INTO uvl_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Pe mele nenge ii nga miliko lape losio iange kileng au.” ");
INSERT INTO uvl_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Iesus hele ke mau ke het pe hele mule, “Pekngara Lasarus kou mamani lo, pe lape ela ke e hengo heke i.” ");
INSERT INTO uvl_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Pe nena hana mur te hele, “Non Soke, nenge teke mamani mana lape urana mule.” ");
INSERT INTO uvl_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Iesus helele ia Lasarus nge mete lo, pe nena hana mur te teke ma Iesus hele ke teke mamani mana. ");
INSERT INTO uvl_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Ol pe Iesus hele hot sapele, “Lasarus kou mete lo. ");
INSERT INTO uvl_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Pe letekia imo pe e iech nge e tunga etue neu ero. Iange lape e poia imo ke letemo manmanna. Iok, tala nge i ol.” ");
INSERT INTO uvl_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Ol pe Tomas (nenge ene e pule Titimus) hele lange pekngana mur, “Iok, ita lochloch tala kela ta mete luluch nge i.” ");
INSERT INTO uvl_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Iok, Iesus la ke lohot nge Petani pe Lasarus koluna ma nga polo ke etue henel ke ulolo. ");
INSERT INTO uvl_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Kileng nenge Petani rochroi mana nga kileng nenge Ierusalem. (sase ngana pomanga kilomita iri mol) ");
INSERT INTO uvl_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Pomalam Iuta mur halang tela ke te lohot nge Maria iri nai Marta ke tetu hite iri nga liuria nge mete. ");
INSERT INTO uvl_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Iok, nga etue nenge Marta longe Iesus pingana nge te teke, “Iesus koi atat lo.” Ana hei hile sue tina Maria ke tunga pele pe i la ke saolia Iesus nga kue. ");
INSERT INTO uvl_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Saolia i pe hele, “Non Soke, toinge o tunga lamai nike, liuk lape mete ero. ");
INSERT INTO uvl_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Pe iau e eteia. Nenge teke o onteia NeHalang nga ute heueu nei, NeHalang lape tunge lange iong.” ");
INSERT INTO uvl_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Pe Iesus hele, “Lium lape maul haka mule.” ");
INSERT INTO uvl_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Pe Marta hele, “E eteia ke i lape maul haka mule nga metenga nga etue nga rume, nga maulinga ana etue.” ");
INSERT INTO uvl_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Pe Iesus hele, “Maulinga haka nem ngana i iau lo. Pe iau pule iau maulinga ke koko. Iri nenge leteria manmanna nge iau pe te mete, lape te maul haka mule. ");
INSERT INTO uvl_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Pe iri nenge leteria manmanna nge iau (pe te tutu kura), lape te mete ero ol. Letem manmanna nga nei pule kai?” ");
INSERT INTO uvl_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Pe hei neu hele, “Oe Non Soke, pe letek manmanna pule ke iong Kristus. Pe iong NeHalang Tuna nenge te teke atat nga ich nei.” ");
INSERT INTO uvl_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Hei neu hele ke mau ke het pe la ke iu hot kome tina Maria pe hele, “Hetoronga koloi, pe ontei rerere iong.” ");
INSERT INTO uvl_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Maria longe ke mau pe lohaka ke ueiuei mana pe lange Iesus. ");
INSERT INTO uvl_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Pe Iesus i teu at nga kileng neu ero kura. Ngana kou tutu nga kileng unne nenge Marta saol i ia kura. ");
INSERT INTO uvl_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Maria kila nga pele pe Iuta mur te kila luchluch nge i ke te hemaluchluche letena. Pe Iuta nemur te naue Maria nge lohaka ke ueiuei mana pe i hot. Ol pe te nanas hote i iange te teke ma la ke tangtang nga tina koluna ma ngana. ");
INSERT INTO uvl_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Pe ero. Maria langa kileng unne nenge Iesus tuia pe esia Iesus. Ol pe tualou sio toto langa Iesus apena pe hele, “Non Soke, toinge o tunga lamai nike, lape liuk mete ero.” ");
INSERT INTO uvl_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Iesus naue Maria nge tangtang pe Iuta nemur nenge tela luluch nge i te tang pule. Ol pe Iesus letena poreke toto ke teke tang. ");
INSERT INTO uvl_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Ol pe ontei, “A alo hite i langai?” Pe iri te hele, “Non Soke, oi at ke oes.” ");
INSERT INTO uvl_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Pe Iesus tang. ");
INSERT INTO uvl_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Ol pe Iuta mur te hele, “Non nei mutena tau tote Lasarus.” ");
INSERT INTO uvl_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Pe Iuta mur hel te hele, “I hemas mule iri nenge mataria hit ke tenau mule. Pe pomerei Lasarus mete pe halaua i ero?” ");
INSERT INTO uvl_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Iesus langa polo neu pe letena meena toto kura. Polo neu pomanga rika nenge te hekom hitite hanna ana um. ");
INSERT INTO uvl_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Ol pe Iesus hele, “A alele um nem.” Pe Marta nenge liuna mete neu hele, “Non Soke, i mete ke etue henel lalo. Pe heueu nei inangana poreke lo.” ");
INSERT INTO uvl_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Pe Iesus hele, “E hele lange iong ke ulolo. Nenge teke letem manmanna lape o naue NeHalang nena kerkerenga.” ");
INSERT INTO uvl_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Ol pe alele sapele um nga polo hanna. Ke het pe Iesus nau haka langa lut pe hele, “Temek, e teke e hele urana toto lange Iong nge o longo at nge iau. ");
INSERT INTO uvl_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","E eteia ke kokoes o longo atat nge iau. Pe e teke e heleia helenga nemur ke halaua hehei pe hana nenge temes nei, ke leteria manmanna nge o kulosia iau at.” ");
INSERT INTO uvl_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Iesus hele ke mau ke het pe alngana ke soke toto, “Lasarus, oi hot at.” ");
INSERT INTO uvl_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Ol pe Lasarus i hot at sapele. I hot pe malenga sachanchana nenge telul hite nga penna pe apena pe nga ramana tetu kura. Ol pe Iesus hele lange iri, “A unhote malenga nemur nge i pe a poia i kela ol.” ");
INSERT INTO uvl_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Pe Iuta mur halang nenge tetu luluch nge Maria te naue ure neu nge Iesus poia pe leteria manmanna nge i. ");
INSERT INTO uvl_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Pe hel nge iri tela ke te heleia ure nenge Iesus poia lange Paresio mur. ");
INSERT INTO uvl_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Ol pe etue nenge hana papalauna te eukirau lohot sapele. Ke tunginga ana hana mur aria papalauna mur pe Paresio mur te eukirau pe te hele, “Non nei hele pe ure halang te lohot manmana. Pe ita, lape tapoi ke merei? ");
INSERT INTO uvl_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Nenge teke ta kila mana pe ta nachnei mene i nge popoi ke mau, lape hulua lochloch ngana leteria manmanna nge i. Pe lape Rom mur teat ke te heporeke NeHalang nena pele pe te heporeke rera hehei pe hana mur pule.” ");
INSERT INTO uvl_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Ol pe elle nge iri ene Kaipas. Kaipas i tunginga ana hana mur aria soke nenge palaungana toto nga hesinga neu. Ana non lohaka pe hele, “Imo a eteia ute pele ero toto! ");
INSERT INTO uvl_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Nenge teke anau ke nek lape a eteia. Urana toto nge mele elle mana mene hehei pe hana muria ke mete. Pomalam lape rera hehei pe hana tetu ke nek.” ");
INSERT INTO uvl_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Ne Kaipas sau hote helenga neu nga i sipona letena matana ngana ero. I tunginga ana hana mur aria soke nenge palaungana toto nga hesinga neu. Pe hele ngana neu hetatalo ke teke lape Iesus mete ke halaua Iuta mur lochloch. ");
INSERT INTO uvl_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Pe Iuta mur iri toro mana ero. Iesus mete ke halaua NeHalang nena hana mur nenge telot parai ke tetu nga kileng lochloch ngana nga ich, pe mene mule iri at ke muria elle pe poia iri ke te lohot ke iri elle mana. ");
INSERT INTO uvl_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Ke nga etue neu te talun sapele ke te henininia kue nemur nenge lape te hune Iesus. ");
INSERT INTO uvl_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Pomalam Iesus i rara sakilil luluch nge Iuta mur nga mallaha ero ol. Ol pe Iesus ua nga lamau pe la ke tu luluch nge nena hana mur nga kileng nenge te hetue ke ene Epraim. Ana kileng tu rochroi nga ich sana lomona. ");
INSERT INTO uvl_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Iok, ngaunga matana palaungana nenga Ingatoto heroi lo. Pomalam hulua halang nga kileng mur te lohaka ke tela nge Ierusalem ke te helemlem tettele iri nike, (iange ngaunga matana palaungana nem mam pe lohot.) ");
INSERT INTO uvl_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Pe hulua nemur te tango rerere Iesus. Te mes nga NeHalang nena pele pe te ontei hel rara nge iri, “Imo letemo ma ke merei? I mai lape at nga ngaunga matana palaungana nei pule ma ero?” ");
INSERT INTO uvl_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Hulua nemur te hele ke pomai iange tunginga ana hana mur, aria papalauna mur pe Paresio mur te tung hote helenga kerkereng ngana lo ke te teke, nenge teke mele eteia Iesus tu ngana, hele hote pe tela ke te laua i. ");
INSERT INTO uvl_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Iok, ngaunga matana nenga Ingatoto nem, ana etue iri rahtele elle (6) tu kura pe Iesus lange Petani nga kileng nenge Lasarus tu ia. Pe Lasarus i non nenge Iesus hemaul heke mule i nga metenga. ");
INSERT INTO uvl_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Nga lamau te poia ngaunga unne ke lange Iesus pe Lasarus kila luluch nge iri nenge te kila nga hatanga. Pe Marta ichichia aria ngaunga. ");
INSERT INTO uvl_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Ol pe Maria mene ure nenge inangana halang nge uruna haka toto pe la ke pasiling heke nga Iesus apena pe taunune nga palpalna ina. Pe pele neu letena muta ia ure neu inangana. ");
INSERT INTO uvl_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Pe Iesus nena none ene Iutas Iskariot. Pe nga hoena lape tung heke Iesus langa hana porekreke ngana mur peria. Ana non hele, ");
INSERT INTO uvl_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Toinge te laia ure nei ke te olia nga umtutuna nge halang toto. Pe uruna nem te tunge lange iri nenge reria ure ero.” ");
INSERT INTO uvl_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Non neu hele ke mau iange i kemenge kina. Pe iri nenge reria ure ero, non nem letena tu nge iri ero toto. Iange i nauelele umtutuna ana kole pe kokoeses mene hotote umtutuna pe i toro ngaungaua. ");
INSERT INTO uvl_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Pe Iesus hele, “O hele lange hei nem ero. Atong tatalo ele ke ak metenga ana ia nike. ");
INSERT INTO uvl_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Iange iri nemur nenge reria ure ero tetu luluch nge imo ke kokoes. Pe iau lape etu luluch nge imo ke kokoes ero.” ");
INSERT INTO uvl_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Ol pe Iuta mur halang toto te longe Iesus nge tu lamau pe tela sapele. Tela ke te teke tenau Iesus pe pule te teke tenau Lasarus nenge Iesus hemaul heke mule nga metenga. ");
INSERT INTO uvl_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Ol pe tunginga ana hana mur aria papalauna mur, tetal helenga ke te teke lape te hune Lasarus pule. ");
INSERT INTO uvl_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Iange Lasarus pingana song pe nem mana poia Iuta mur ke te ua aria papalauna mur aria pe leteria manmanna nge Iesus pe te nanasia i. ");
INSERT INTO uvl_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Iok, pomange rou hulua nenge tela nga ngaunga matana neu te longe nge te teke Iesus kou lala nge Ierusalem lo. ");
INSERT INTO uvl_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Pomalam te choloua akau perperna mur pe tela ke tei ele i. Pe alngaria ke te teke, “Ta heto heke NeHalang! NeHalang pete i nenge at nga Non Soke ene! NeHalang pete Israel mur aria Naungaala ana non!” ");
INSERT INTO uvl_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Iok laol, Iesus hottaua tongki heueu ngana e pe are haka ia ke pomanga NeHalang nena alalaha hele ngana nenge hele ke teke, ");
INSERT INTO uvl_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Imo hehei pe hana nenge Ierusalem, a matau ero ol! Anau la, amo naungaala ana non kou are haka nga tongki tuna ke atat.” ");
INSERT INTO uvl_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Ure nemur te lohotot pe Iesus nena hana mur leteria mallaha ero toto nga luria. Pe nga etue nenge NeHalang hemalmalia Iesus ke het ol, leteria metene sapele ke helenga nemur nenge te tetu nga NeHalang nena alalaha, helele ia Iesus nge te poia poinga nei lala nge i. ");
INSERT INTO uvl_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Iok laol, hulua nemur nenge temes pe Iesus iu hote Lasarus nga polo pe hemaul heke mule i nga metenga, te hekerkereng ia hehei pe hana leteria nga ume nemur nenge Iesus popoia. ");
INSERT INTO uvl_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Pe hulua tela ke tei ele i iange te longe i nge poia ure palaungana nei. ");
INSERT INTO uvl_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Ol pe Paresio mur te hele tele hel nge iri ke te teke, “Ita nakura ero toto nge ta poia ute pele. Anau langa hulua lochloch te nanas ngana ia i ke.” ");
INSERT INTO uvl_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Iok, Krik mur hel te koko luluch ke tela nga ngaunga matana neu pule. ");
INSERT INTO uvl_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Iri tela nge Pilipus pe te hele, “Non soke, mo teke monau Iesus.” Pe ne Pilipus nena nge Petsaita nga kileng nenge Kalelea. ");
INSERT INTO uvl_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Ol pe Pilipus heleia lange Antreas pe iri nai tela ke te heleia lange Iesus. ");
INSERT INTO uvl_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Pe Iesus hele, “Etue at lo nenge lape te hemalmal heke Non Tuna. ");
INSERT INTO uvl_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Pe e hele ke manmanna toto lange imo. Nenge teke uit nganangana elle losio hot ke langa ich pe punich ero lape tu ke elle ke pomam mana. Pe nenge teke punich lape matana hot ke haka pe hei ke nganangana halang toto. ");
INSERT INTO uvl_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Mele hel nenge leteria tu mana nge iri siporia, lape te mene maulinga ke koko ero. Pe mele hel nenge leteria tumana nge iri siporia ero, nga te tungaria nga ich nei, lape te mene maulinga ke koko. ");
INSERT INTO uvl_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Mele nenge lemene ke teke ume nge iau nanasia iau. Pe mele nenge umume nge iau nem lape tu luluch nge iau nga etu ngak. Pe Temek lape tal heke tote mele nenge umume nge iau. ");
INSERT INTO uvl_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“Heueu nei letek meena pe lape e hele ke merei? Lape e hele lange temek ke poi ele ure meena ngana nei ke lohot nge iau ero? Nem ero, iange esio at nga ich nei ke e takisia melmelenga nem. ");
INSERT INTO uvl_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","“Temek o hetei hote iong lange hehei pe hana ke iong non nge urana toto pe te heto heke tote em.” Ol pe NeHalang hele sio at nga tapa ke teke, “E hetei hote iau lange hehei pe hana ke iau non nge urana toto pe te heto heke tote iau ke ulolo, pe lape epoi mule pule.” ");
INSERT INTO uvl_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Pe hulua nemur nenge tetu nga lamau te longe pe te teke ma kileng kurung ngana. Pe hel te teke angkelo e hele lala nge i. ");
INSERT INTO uvl_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Pe Iesus hele, “Helenga nenge a longe nem lape halaua iau ero. Helenga nem lape halau tote laka imo. ");
INSERT INTO uvl_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Pe etue nenge NeHalang nau teu langa hulua lochloch ngana nga ich reria poinga mur ngana koloi at lo. Pe mele nenge nauele ich nei lape te lope hote i. ");
INSERT INTO uvl_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Pe Iau, nga etue nenge e mete pe e maul haka mule pe e mene kerkerenga nenge enau ele ure lochloch, lape e mene hehei pe hana lochloch ke teat nge iau.” ");
INSERT INTO uvl_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Iesus hele ngana nei hele urume i nga ana metenga. ");
INSERT INTO uvl_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Ol pe hulua nemur te hele, “Imem mo eteia nge lemem hotonga hele ke teke, Kristus i non nenge tu ke koko. Pe pomerei nenge o hele ke o teke, lape te heon heke Non Tuna? Non Tuna mam itei toto ia?” ");
INSERT INTO uvl_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Pe Iesus hele lange iri, “Lemenge lape tu luluch nge imo ke mala pol. Pe a esapele lemo inga mur nga etue nenge lemenge tu kura. Pomalam lape kileng au ngana poi hite imo ero. Pe mele nenge ii nga kileng au ngana eteia la nganngana ero. ");
INSERT INTO uvl_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Ke nga etue nenge lemenge tu luluch nge imo ke mai, letemo manmanna nge i nike. Pomalam lape a lohot ke imo hehei pe hana nenge tetu manmana nga lemenge.” Iesus hele ke mau ke het pe erue sio mana pe la sapele. ");
INSERT INTO uvl_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Iesus hele pe ure halang te lohot mana pe hulua nemur leteria manmanna ero. ");
INSERT INTO uvl_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Pe poinga neu te poia ke pete tote hetatalonga Isaias nena helenga mur. “Non Soke, itei hel leteria manmanna nga rera helenga mur? Pe Non Soke hetei hote nena kerkerenga lange itei hel?” ");
INSERT INTO uvl_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Leteria manmanna ero iange hetatalonga Isaias hele pule ke teke, ");
INSERT INTO uvl_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“NeHalang poia iri ke mataria hit pe poia leteria ke au ala toto. Pomalam te naue iau ero pe leteria mallaha nge iau ero. Pe e hemasia iri ero iange teat nge iau ero.” ");
INSERT INTO uvl_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Isaias naue hemalmalinga palaungana nenge Iesus ke ulolo, pomalam heleia Iesus ke pomam. ");
INSERT INTO uvl_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Pe hana papalauna nemur, halang nge iri leteria manmanna nge Iesus. Pe te hele hote leteria manmanna ngana ero iange te mataua Paresio mur. Pe pule te matau nge lape tepoi ele iri ke tela nga hetoronga ana pele ero ol. ");
INSERT INTO uvl_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Iange hana nemur muteria toto nge te teke hehei pe hana te heto heke totote iri. Pe leteria tu nge NeHalang ero. ");
INSERT INTO uvl_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Ol pe Iesus haliu hot ke palaungana toto ke teke, “Mele nenge letena manmanna nge iau, letena manmanna nge iau toro ero. Letena manmanna pule nge i nenge kulosia iau at nei. ");
INSERT INTO uvl_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Pe mele nenge esia iau esia i nenge kulosia iau at pule. ");
INSERT INTO uvl_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Esio at nga ich nei ke pomanga lemenge. Ke pomalam iri lochloch ngana nenge leteria manmanna nge iau lape tetu nga kileng au ngana ero ol. ");
INSERT INTO uvl_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","“Mele nenge longe lek helenga pe nanasia ero, iau sipok lape e amnei teu langa nena poinga poreke ngana nem ero. Iange iau eat nga ich nei ke e amnei teu langa hehei pe hana reria poinga poreke ngana mur ero. Eat nga ich nei ke e mene mule hehei pe hana. ");
INSERT INTO uvl_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Pe mele nenge hile hote iau pe nanasia lek helenga mur ero, lape te amnei teu lange i ke nek toto. Pe helenga nenge e heleia nem i sipona lape amnei teu lange mele nem nga etue nga rume. ");
INSERT INTO uvl_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Iange helenga nem e tamal hote nga iau sipok lemek ngak ero. Temek nenge kulosia iau at hele ke kerkereng at nge iau ke e heleia pe hele urume e hele ngak ia. ");
INSERT INTO uvl_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Iau e eteia ke nena helenga kerkereng ngana nem, i kue nenge langa maulinga ke koko. Ke pomalam utar nenge e heleia, e heleia ke pomanga Temek hele ngana ia at nge iau.” ");
INSERT INTO uvl_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Etue nenga ngaunga matana nenga Ingatoto heroi lo. Pe Iesus eteia ke ana etue heroi pule, nenge lape hile ich nei pe lange Temene. Pe mutena tau tote iri nemur nga ich nenge saria kikina nge i. Mutena tau tote iri kela het nga mete ngana. ");
INSERT INTO uvl_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Iok, nga ulei Iesus pe nena hana mur te kila hirau nga ngaunga. Te kila hirau ero kura pe Satan roro heke Iutas Iskariot nenge Simon tuna pe tung teua lete matana ngana lange i ke tung heke Iesus langa hana porekreke ngana mur peria. ");
INSERT INTO uvl_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Iesus eteia ke i at nge NeHalang pe lape la mule nge NeHalang. Pe pule eteia ke Temene tunge kerkerenga lange i ke nauele ure lochloch. ");
INSERT INTO uvl_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Pomalam nga etue nenge te ngaungau nga hatanga, Iesus mes haka pe haka hote nena hengeron nenge hot ana pe kale loua tauninga nga luana. ");
INSERT INTO uvl_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Ke het pe eusiling teua ech langa kaliu pe talun ke lomo sapele nena hana mur aperia. Lomlome nena hana mur aperia pe taunune nga tauninga nenge kale loua nga luana. ");
INSERT INTO uvl_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Iok, Iesus teke lake lome Simon Petrus apena pe Simon Petrus hele, “Non Soke, lape o lome apek pule kai?” ");
INSERT INTO uvl_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Pe Iesus hele, “Iong, o eteia ure nenge e popoia nei ero, pe nga hoena lape o eteia ol.” ");
INSERT INTO uvl_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Pe Petrus hele, “Ero! Lemek ero nge o lome apek.” Ol pe Iesus hele, “Nenge teke elome apem ero, lape lek non iong ero ol.” ");
INSERT INTO uvl_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Pe Simon Petrus hele, “Non Soke pomalam iok, o lomo mene apek ero. O lome perik pe palpaluk pule.” ");
INSERT INTO uvl_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Iesus hele, “Mele nenge nun ke singina lemlem ke ulolo, nun mule ero ol. Lape lomo mene apena ol. Pe imo nemur singimo lemlem ke ulolo pe mele elle nge imo singina lemlem ero.” ");
INSERT INTO uvl_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Iesus eteia mele nenge milmil ana ke pomalam hele ke teke, “Mele elle nge imo singina lemlem ero.” ");
INSERT INTO uvl_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Iok, Iesus lome nena hana mur aperia ke het pe heron heke mule nena hengeron nenge hot ana. Ke het pe la ke are mule nga munna nga hatanga pe onteia iri ke teke, “Ure nenge e poia lange imo nei mai a eteia luna pule kai? ");
INSERT INTO uvl_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Imo, nga etue nenge a hele atat nge iau, a hetue iau ke Hetoronga pe Non Soke. Pe a heto ngamo nem pengpeng iange iau non nenge pomam. ");
INSERT INTO uvl_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Ke iau, amo Non Soke pe amo hetoronga. E lome apemo pe imo a lome pekngamo mur aperia pule. ");
INSERT INTO uvl_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","E poia lange imo ke ulolo. Pomalam a poia lange pekngamo mur pule ke pomanga epoi ngak ia lange imo. ");
INSERT INTO uvl_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","E hele ke manmanna toto lange imo, hekuleileinga ana hana mur iri papalauna nge aria aehuna mur ero. Pe pule non nenge hesongong helenga, i palaungana nge non nenge hekule i ero. ");
INSERT INTO uvl_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Heueu nei a eteia ke helenga nenge e heleia nei manmanna. Pe nenge teke a poia ana ume, iechinga lape lohot nge imo. ");
INSERT INTO uvl_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Iau e heleia imo lochloch ero, iau e etei tote mele hel nenge e hesilei hote iri ke ulolo. Pe nei nenge poia NeHalang nena helenga nenge masio nga alalaha lo, ke lohot ke manmanna nenge hele ke teke, ‘Non nenge ngau luluch nge iau lape hul rumena mule nge iau.’ ");
INSERT INTO uvl_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","“Ure nem, lape lohot nga hoena kura pe e hele tele lala nge imo nike. Pe nga etue nenge ure nem lohot, lape letemo manmanna ke iau non nenge tu ke koko. ");
INSERT INTO uvl_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","E hele ke manmanna lange imo, mele nenge long teua lek hana mur nenge e kulosia iri, long teua iau pule. Pe mele nenge long teua iau, long teua i nenge kulosia iau.” ");
INSERT INTO uvl_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Iesus poia helenga nei ke het pe letena meena toto. Ol pe hele, “E hele ke manmanna lange imo. Amo e nge imo lape tung heke iau langa hana porekreke ngana mur peria.” ");
INSERT INTO uvl_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Pe nena hana mur ngaria lohot nga helenga neu pe leteria una toto. Ol pe tenau tele hel nge iri pe te ontei hel ke te teke, “Itei toto nenge non nei helele ia mai?” ");
INSERT INTO uvl_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Pe elle nge iri nenge Iesus mutena tau tote, kila rochroi toto nge Iesus. ");
INSERT INTO uvl_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Pomalam Simon Petrus pal nakuna lange i nenge Iesus mutena tau tote pe mangun lange i ke onteia Iesus, “O onteia Iesus. I mam helele ia itei toto?” ");
INSERT INTO uvl_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Pomalam non neu matu haka toto nge Iesus pe onteia i ke teke, “Non Soke o helele ia itei toto?” ");
INSERT INTO uvl_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Pe Iesus tuacholia, “Iau lape e panun teua ngaunga nei nga kaliu pe e tunge lange none. Pe non nenge e tunge ngaunga nei lange i, ana non lalom.” Iok, Iesus panun teua ngaunga neu ke het pe tunge lange Simon Iskariot tuna. Ana non ene laka Iutas. ");
INSERT INTO uvl_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Pe nga etue nenge Iutas mene ngaunga nei, non poreke ngana roro heke i sapele. Ol pe Iesus hele lange i ke teke, “Utar nenge o teke o popoia, o poia ke ueiuei.” ");
INSERT INTO uvl_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Pe helenga nenge Iesus heleia lange Iutas, mele e nga hatanga neu eteia luna ero. ");
INSERT INTO uvl_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Iutas i non nenge nauelele umtutuna ana kole. Pe pekngana nemur te teke ma Iesus hele lala nge i ke olol ngaunga. Pe pule te teke ma Iesus hele lange i ke mene umtutuna unne pe laia nge iri nenge reria ure ero. Pe ero. ");
INSERT INTO uvl_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Iutas mene ngaunga ele neu nge Iesus pe i hot sapelpele nga miliko neu. ");
INSERT INTO uvl_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Iok, Iutas i hot kela pe Iesus hele, “Heueu lape te heto haka tote Non Tuna. Pe lape te heto haka tote NeHalang pule iange Non Tuna hemallaha hote nena hemalmalinga. ");
INSERT INTO uvl_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Pomalam NeHalang i sipona lape hemalmalia i pe lape poia ke ueiuei toto. ");
INSERT INTO uvl_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","“Pe imo, apoi ke pomanga tutuk mur imo toto. Pe lape etu luluch nge imo ke etue choro mana pe nga hoena lape a tango rere iau. Pe helenga nenge e hele ia lange Iuta mur aria papalauna mur, heueu nei lape e hele ia lange imo pule. Ana helenga koi, ‘Imo lape a at nga kileng nenge etu ia ero.’ ");
INSERT INTO uvl_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","“Pe e tunge hotonga heueu ngana e lange imo: Mutemo taua pekngamo mur. Iau, mutek tau tote imo pomalam imo pule mutemo taua pekngamo mur. ");
INSERT INTO uvl_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Nenge teke mutemo taua pekngamo mur, lape hulua te eteia ke iau lek hana mur imo.” ");
INSERT INTO uvl_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Ol pe Simon Petrus onteia Iesus, “Non Soke, iong mam lape o lala langai?” Pe Iesus tuacholia, “Iong lape o nanasia iau nga lek inga nenge eii ia heueu nei ero. Pe lape o nanasia iau nga hoena kura.” ");
INSERT INTO uvl_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Pe Petrus ontei mule, “Non Soke, pomerei nenge e nanasia iong heueu ero? E teke e mete ke e mene mullim.” ");
INSERT INTO uvl_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Pe Iesus tuacholia, “O teke o mete ke o mene mullik ma? E hele ke manmanna toto lange iong. Nge rou nga uachuach pareo tang ero kura pe o channanga hemol ke o teke o eteia iau ero.” ");
INSERT INTO uvl_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Ol pe Iesus hele lange nena hana mur, “Letemo meena ero. Samo kikina nge NeHalang pe samo kikina nge iau pule. ");
INSERT INTO uvl_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Temek nena pele ana tokola halang. Nem manmanna iange ela ke e tatalo ele mullimo. ");
INSERT INTO uvl_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Ela ke e tatalo ele mullimo ke het pe lape eat tau mule imo pe e mene imo kela atu luluch nge iau. ");
INSERT INTO uvl_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Imo a eteia kue nenga kileng nenge e lala ia nei.” ");
INSERT INTO uvl_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Pe Tomas hele lange Iesus, “Non Soke mo eteia kileng nenge o lala ia nem ero i. Ke lape mo eteia ana kue ke merei?” ");
INSERT INTO uvl_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Pe Iesus tuacholia, “Iau sipok iau esinga tele nenge e hemallaha hote helenga manmanna toto ngana nenge NeHalang, pe iau kue nenge langa maulinga ke koko nenge NeHalang tunge. Pe iau sipok iau kue nenge song ke lange Temek. Kue e ero ol.” ");
INSERT INTO uvl_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Pe Iesus hele lange iri, “Nenge teke a etei tote iau lape a eteia Temek pule. Pe nga etue nei kela ol lape a eteia i iange a naue ramana nge iau ke ulolo.” ");
INSERT INTO uvl_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Ol pe Pilipus hele lange Iesus, “Non Soke, imem lape mo ontei mule iong nga ute e ero ol. Pe ure nenge mutemem tau tote ngana koi nei; O henonoua imem nge Temere ke mo naue nga matamem.” ");
INSERT INTO uvl_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Pe Iesus hele lange Pilipus, “Pilipus etu luluch nge imo ke mala ke ulolo, pe pomerei nenge o teke o eteia iau ero? Mele nenge naue iau lo, naue Temek pule. Pe pomerei nenge o teke e henonoua Temek lange imo? ");
INSERT INTO uvl_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Letem manmanna nga nei ero kai? Iau etu teu luluch nge Temek pe Temek tu teu luluch nge iau. Helenga nenge e heleia lala nge imo nei, iau sipok lek helenga mur ia ero. Temek nenge tu teu luluch nge iau pe e popoia ana ume koi nena helenga nemur. ");
INSERT INTO uvl_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Letemo manmanna nga lek helenga nenge e teke Temek tu teu luluch nge iau pe iau etu teu luluch nge Temek. Pe nenge teke letemo manmanna nga lek helenga nem ero, iok letemo manmanna nga urelu nenge e hele pe te lohot manmana. ");
INSERT INTO uvl_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","E hele ke manmanna toto lange imo. Mele nenge letena manmanna nge iau, lape hele pe urelu te lohot manmana ke pomange iau. Pe i lape poia ure hel nge papalauna toto nga nenge e popoia, iange iau e lala nge Temek lo. ");
INSERT INTO uvl_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Ure lochloch ngana nenge a hetalaulau pe a onteia nga iau ek lape e poia. Pomalam lape e hemallaha hote Temek nena hemalmalinga palaungana. ");
INSERT INTO uvl_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Ke ure lochloch nenge a ontei iau ia, iau lape e poia la.” ");
INSERT INTO uvl_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Nenge teke mutemo taua iau, lape a longo taua lek helenga mur. ");
INSERT INTO uvl_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Pe iau lape e onteia Temek ke tunge amo halaunga e pule nenge lape tu luluch nge imo ke koko. ");
INSERT INTO uvl_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Ke imo amo halaunga laka Opepengpeng. Pe Opepengpeng nem lape hemallaha hote helenga manmanna toto ngana mur nge NeHalang lange hehei pe hana. Pe hehei pe hana nga ich nenge leteria manamanna nge NeHalang ero, lemeria ero ia i iange te naue i ero pe te eteia i ero pule. Pe imo a eteia i iange tu teu luluch toto nge imo. ");
INSERT INTO uvl_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Iau lape e hile sio mene imo ke pomanga hatuong mur ero. Lape ela pe eat tau mule imo. ");
INSERT INTO uvl_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Etue choro mana tu ol pe hehei pe hana nga ich lape tenau mule iau ero ol. Pe imo lape anau mule iau iange lape e maul haka mule pe etu ke e maulul ke koko. Ke pomalam imo lape a mene maulinga ke koko nge iau. ");
INSERT INTO uvl_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Pe nga etue nenge e maul haka mule a eteia ke imem nai Temek imem elle mana pe imo pe iau ita elle mana pule. ");
INSERT INTO uvl_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Mele hel nenge muteria taua iau tera hite lek helenga mur pe te nanasia pe Temek mutena taua iri nenge muteria taua iau. Pe e hetei hote iau lange iri iange mutek taua iri. ");
INSERT INTO uvl_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Ol pe Iutas ontei, (Iutas nenge ene Iskariot ero, Iutas e pule) “Non Soke pomerei toto nenge o hetei hote iong at nge imem mana pe o hetei hote iong lange hehei pe hana nga ich nei ero?” ");
INSERT INTO uvl_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Pe Iesus tuacholia pe hele lange i ke teke, “Mele nenge mutena taua iau, longo taua lek hengetoro mur pe Temek lape mutena taua mele nem. Pomalam lape imem nai Temek moat ke motu luluch nge i. ");
INSERT INTO uvl_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Pe mele nenge mutena taua iau ero rahite lek hengetoro mur ero. Pe helenga nemur nenge a longlonge nem Temek nenge kulosia iau at laka nena helenga nemur. ");
INSERT INTO uvl_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“E heleia ure nemur lange imo nga etue nenge etu luluch nge imo. ");
INSERT INTO uvl_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Pe Opepengpeng nenge halaulaua imo lape Temek hekulo sue at nge imo nga iau ek. Pe i lape hetore imo pe helete metene imo nga ure lochloch ngana nenge e heleia lange imo ke ulolo. ");
INSERT INTO uvl_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Ke iau e lala lo pe e teke e tunge letek urana ngana lange imo ke letemo ma ke nek pe atu ke nek. Letemo meena ero pe a matau ero iange mele nga ich nei tunge lete urana ngana nenge pomam lange imo ero. ");
INSERT INTO uvl_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","“Imo a longe iau nge e hele lange imo ke ulolo nenge e hele ke e teke, ‘Lape ela pe lape eat mule nge imo.’ Pe nenge teke mutemo taua iau lape letemo iech mana nge ela nge Temek iange i palaungana toto nge iau. ");
INSERT INTO uvl_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","E heleia ure nemur lange imo nike ke nga etue nenge te lohot, lape letemo manmanna. ");
INSERT INTO uvl_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Iok, lape e hele sakilil lange imo ero ol iange non nenge nauele ich nei ngana koi atat lo. Pe iau kikik ngak palaungana toto nga i kikina ngana. ");
INSERT INTO uvl_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Iau e teke kileng lochloch ngana nga ich te eteia ke iau mutek tau tote Temek. Ke pomalam e poia ume lochloch ngana nenge i sipona heleia at nge iau. “Iok a lohaka pe tai!” ");
INSERT INTO uvl_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Iesus hele, “Iau uain tana toto ngana. Pe Temek i non nenge nauelele pe umume nga ume nenge tetue ana uain. ");
INSERT INTO uvl_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Pe Temek lape chato hote uain perperna mur nenge tetu teu nge iau pe tehei erochro. Pe perperna nemur nenge tehei, Temek lape ute iri ke almas mule iri ke te chorchoro. Pomalam, nga hoena lape nganangaria halang toto ol. ");
INSERT INTO uvl_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Pe imo, lek helenga nenge e heleia lange imo almasia imo ke ulolo. ");
INSERT INTO uvl_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Nenge teke atu teu luluch toto nge iau, iau etu teu luluch toto nge imo. Nenge teke uain penna e tuteu toto nga uain tana, uain penna nem lape hei. Pe uain penna e hei mana nge i ero. Ke pomalam mana nge imo, nenge teke atu teu luluch nge iau ero, lemo kerkerenga pele ero toto nge a poia ute pele ke lohot. ");
INSERT INTO uvl_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Ke iau uain tana pe imo uain perperna mur. Nenge teke mele tu teu luluch nge iau pe iau etu teu luluch nge i, mele nem lape poia ure urana ngana halang. Iange mele nenge tu teu luluch nge iau ero lape poia ute pele ero toto. ");
INSERT INTO uvl_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Pe iri nenge tetu teu luluch nge iau ero lape tepoi ke pomalaka nga uain perperna mur nenge tesau hote iri ke te kalum. Pe uain perperna nemur nenge pomam lape te lochloch heke pe tesau heke iri langa oan ngingina ngana ke te ngaulala. ");
INSERT INTO uvl_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Nenge teke atu teu luluch nge iau pe lek helenga mur tetu teu toto nga letemo, lape Temek tunge utar nenge lememo taua pe a ontei i ia. ");
INSERT INTO uvl_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Pe Temek lape mene hemalmalinga palaungana nga etue nenge a poia ure urana ngana mur pe a hetei hote imo ke lek hana mur imo. ");
INSERT INTO uvl_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","“Mutek tau tote imo ke pomange Temek nge mutena tau tote iau. Pomalam, letemo tu mana nge iau. ");
INSERT INTO uvl_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Ke nenge teke a longo taua lek hotonga mur letemo lape tu mana nge iau. Pomange iau nge e longo taua Temek nena hotonga mur pe letek tu mana nge i. ");
INSERT INTO uvl_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","E heleia helenga nemur lange imo ke lek iechinga tu hite letemo. Pe lape a iech toto. ");
INSERT INTO uvl_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Pe lek hotonga nenge e teke a nanasia ngana koi nei; Mutemo taua pekngamo mur ke pomange iau nge mutek taua imo. ");
INSERT INTO uvl_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Nenge teke mele tung heke i sipona ke mete ke halaua pekngana mur, mele nem mutena tau tote pekngana mur. ");
INSERT INTO uvl_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Ke nenge teke a poia ure nenge e heleia lange imo ke e teke a poia, iau pekngak mur imo. ");
INSERT INTO uvl_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Pe lape e hetue imo ke hengekuleilei ana hana mur ero ol iange hengekuleilei ana hana mur te eteia utar nenge non nenge nauele iri popoia ero. Iau e hetue imo ke pekngak mur iange utar nenge Temek hetoro iau ia e hetore lange imo ke a eteia pule. ");
INSERT INTO uvl_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Imo a hesilei hote iau ero, iau e hesilei hote imo. E hesilei hote imo pe etal hote imo ke a poia ume urana ngana mur pe amo ume urana ngana nemur nganangana lohot pe tu ke koko. Pomalam lape Temek tunge ure mur lange imo nenge teke a hetalaulau pe a onteia i nga iau ek. ");
INSERT INTO uvl_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Pe lek hotonga nenge e tunge lange imo ngana laka nenge e teke mutemo taua pekngamo mur.” ");
INSERT INTO uvl_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Pe nenge teke hehei pe hana nga ich nei te hesisia imo a eteia ke te hesis tele iau ke ulolo. ");
INSERT INTO uvl_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Pe te hesisia imo iange etal hote imo pe e mene hote imo nga ich nei ke ulolo. Pe nenge teke lemo nga ich nei kura lape muteria tau tote imo pe nei ero ol. Ke pomalam hehei pe hana nga ich nei te hesisia imo. ");
INSERT INTO uvl_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Letemo metene utar nenge e heleia lange imo ke ulolo. ‘Hengekuleilei ana none i palaungana nge ana aehuna ero.’ Ke pomalam nenge teke tepoi poreke iau lape tepoi poreke imo pule. Pe nenge teke te longo taua lek hengetoro mur lape te longo taua lemo hengetoro mur pule. ");
INSERT INTO uvl_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Pe iri te poia poinga nemur lange imo iange iau lek hana mur imo. Pe pule te eteia i nenge kulosia iau at nei ero. ");
INSERT INTO uvl_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Iau ela nge iri nga tele ngana pe e hele lange iri lo, pe nenge teke e hele lange iri ero, lape te etei teu nga poinga poreke ngana ero. Pe nei ero. E hele lange iri ke ulolo pe te longo ole, pomalam reria helenga e ero toto ol. ");
INSERT INTO uvl_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Pe mele nenge hesisia iau hesisia Temek pule. ");
INSERT INTO uvl_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Pe mele pele kikina ero toto nge hele pe ure te lohot manmana. Pe iau, e helele pe urelu te lohotot. Pe nenge teke e poia ume nem nga mataria nga tele ngana ero, lape te etei teu nga poinga poreke ngana ero. Pe nei ero. Iri te naue ure nemur nge epoi hote iri ke ulolo. Pe pomerei toto nenge te hesis apeia imem nai Temek mai? ");
INSERT INTO uvl_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Pe reria poinga nei lohot ke pete tote helenga hel nenge tehas sue nga reria hotonga mur ana alalaha lo nenge hele ke teke, ‘Iri te hesisia iau pe iau lek huna nga ute e nge iri ero.’ ");
INSERT INTO uvl_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Pe imo amo Halaunga, ngana kou tu luluch nge Temek kura. Pe i Ope nenge hele hote helenga manmanna toto ngana mur nge Temek iange lohot pengpeng nge Temek. Pe iau lape e hekule i ke at nge imo. Pe i lape at ke hemallaha hote iau lange imo pule. ");
INSERT INTO uvl_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Pe imo pule lape a hele hote helenga manmanna toto ngana mur ke mallaha, iange atu luluch nge iau nga etue nenge e talun ke e hetottoro ke at heueu nei. ");
INSERT INTO uvl_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“E heleia ure lochloch ngana nei lange imo ke a rahite letemo manmanna ngana mur ke kerkereng. ");
INSERT INTO uvl_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Iange lape te hile hote imo pe lape ala ke a hetalaulau luluch nge iri nga hengetoro ana pele ero ol. Pe nga hoena etue e lape at. Pe iri nenge te teke te hunune imo, te teke ma reria poinga nem pengpeng nga NeHalang matana. ");
INSERT INTO uvl_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Pe te popoia imo ke pomam iange te eteia Temek ero pe te eteia iau ero pule. ");
INSERT INTO uvl_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","E heleia ure nemur lange imo nike. Pe ana etue teke lohot ho olo, letemo metene ke e heleia ure nemur lange imo ke ulolo. E heleia ure nemur lange imo nga tele ngana ero iange etu luluch nge imo kura. ");
INSERT INTO uvl_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Pe heueu nei ela mulmule nge Temek lo. Temek nenge kulosia iau at nei. Pe pomerei amo e onteia iau ke pomai ero? ‘O lala langai?’ ");
INSERT INTO uvl_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","A onteia iau ero iange letemo una nga ure nemur nenge e heleia lange imo ke ulolo.” ");
INSERT INTO uvl_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","“Pe helenga nenge lape e heleia lange imo nei manmanna toto koi. Urana nge ela iange ela ngak nei lape halau tote imo. Pe nenge teke ela ero halaunga e lape at nge imo ero. Ke pomalam ela pe e kulosia halaunga nem ke at nge imo. ");
INSERT INTO uvl_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Pe nga etue nenge ana non at, lape hemallaha hot tote ure nemur lange hehei pe hana nga ich nei. Ngana laka; Poinga poreke ngana huuna mur pe poinga mur nenge tatu ke pengpeng nga NeHalang matana pe NeHalang nena haliunga lohot ngana nge he. ");
INSERT INTO uvl_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Pe lape hemallaha hot tote poinga poreke ngana hu una mur iange leteria manmanna nge iau ero. ");
INSERT INTO uvl_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Pe pule lape hemallaha hot tote poinga mur nenge tatu ke pengpeng nga NeHalang matana iange lape ela nge Temek pe a naue iau ero ol. ");
INSERT INTO uvl_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Pe pule lape hemallaha hot tote NeHalang nena haliunga lohot ngana nge he iange non poreke ngana nenge nauele ich nei, NeHalang hekou sue nena kerkerenga ke ulolo. ");
INSERT INTO uvl_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Lek helenga halang tetu kura pe lape e heleia lange imo ero iange lape a mene ke nek ero. ");
INSERT INTO uvl_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Pe Ope nenge hele hotote helenga manmanna ngana mur lape at. Pe nga etue nenge at i lape hepengia imo pe poia imo ke a eteia helenga manmanna ngana mur nge NeHalang. Pe helele ia i sipona nena helenga mur ero. I lape longe helenga mur pe at ke heleia lange imo. Pe ure nemur nenge te lohotot nga hoena lape heleia lange imo pule. ");
INSERT INTO uvl_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Ke i lape mene lek helenga mur pe heleia lange imo. Nga poinga nei lape hemallaha hote lek kerkerenga pe hehei pe hana te heto heke iau. ");
INSERT INTO uvl_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Ure lochloch ngana nenge Temek nena ia iau lek ia pule. Ke ngana laka nenge e hele ke e teke lape e tunge lek helenga lange Opepengpeng pe i lape heleia lange imo. ");
INSERT INTO uvl_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Etue choro mana tu ol pe lape a naue iau ero ol. Pe musuna pol mana lape anau mule iau.” ");
INSERT INTO uvl_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Ol pe Iesus nena hana mur hel te ontei hel nge iri, “Helenga nenge heleia at nge ita nei luna merei? Nenge hele ke teke, ‘Etue choro mana tu ol pe lape a naue iau ero ol. Pe musuna pol mana lape anau mule iau.’ Pe pule hele ke teke, ‘Iange lape ela nge Temek’.” ");
INSERT INTO uvl_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Pe te ontei hel mule, “Helenga nenge, ‘Etue choro mana tu ol’ luna merei? Ita ta eteia utar nenge helele ia luna ero i.” ");
INSERT INTO uvl_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Iesus eteia nge te teke te onteia i. Pomalam hele lange iri, “Iau e hele ke e teke, ‘Etue choro mana tu ol pe lape a naue iau ero ol pe musuna pol mana lape anau mule iau.’ A ontei helelia imo kai nga helenga nei mai? ");
INSERT INTO uvl_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","E hele ke manmanna toto lange imo. Iechinga palaungana lape lohot nge hulua nga ich nei. Pe imo lape a tangtang pe letemo kolkol ulu ke ahet. Pe lemo tanginga nem lape het pe a iech mule. ");
INSERT INTO uvl_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Hei e nge hoe nena mamau a amneia melmelenga palaungana nga hohonga ana etue. Pe nga etue nenge hoho ke het letena metene melmelenga nem ero ol, iange iech toto ia nena mamau nge ha nga ich nei. ");
INSERT INTO uvl_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Pomalam mana nge imo. Heueu nei lape a tangtang pe letemo milang toto. Pe iau lape enau mule imo kura. Pe nga etue nenge enau mule imo lape a iech toto pe mele pele mene tote iechinga nem nge imo ero. ");
INSERT INTO uvl_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Nga etue nem lape a onteia iau nga ute ero ol. Temek lape tunge utar nemur nenge a onteia lange i nga iau ek. Helenga nenge e heleia nei manmanna koi. ");
INSERT INTO uvl_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Nge nike ke at heueu nei a ontei ke a mene ute e nga iau ek ero kura. Ana etue at koloi. A ontei pe NeHalang tunge la. Pe lape a iech ele tote ure nemur nenge a mene. ");
INSERT INTO uvl_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“E heleia ure nemur nga helenga opene pe nga etue nenge atat nei, lape e poia helenga e nge pomam ero ol. Lape e hele ke e hemallaha hot tote Temek lange imo. ");
INSERT INTO uvl_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Nga etue nem lape a hetalaulau lange Temek ke halaua imo nga iau ek. Pe iau ak ume nenge e onteia i ke halaua imo ero ol. ");
INSERT INTO uvl_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Temek i sipona mutena tau tote imo pe mutena tau tote imo iange, mutemo tau tote iau pe letemo manmanna ke iau eat nge i. ");
INSERT INTO uvl_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Iau, eat nge Temek ke etu teu nga ich nei pe heueu nei lape e hile ich nei pe ela mule nge Temek.” ");
INSERT INTO uvl_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Ol pe Iesus nena hana mur te hele lange i ke te teke, “Lem helenga nem mallaha nge imem ol. Pe o hele nga helenga opene ero ol. ");
INSERT INTO uvl_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Pe heueu nei mo naue ke iong o eteia ure lochloch pe lape mele pele onteia iong nga onteinga e ero. Pe nem poia imem ke letemem manmanna toto nge oat nge NeHalang.” ");
INSERT INTO uvl_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Pe Iesus tuacholia, “Letemo manmanna nge iau lo? ");
INSERT INTO uvl_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Etue nenge atat ngana koloi at lo nenge lape imo lochloch alot parai ke ala nga lemo kileng mur. Pe a hilesue iau ke iau toro etu. Pe iau toro etu ero iange Temek tu teu luluch nge iau ke koko.” ");
INSERT INTO uvl_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","“E heleia ure nemur lange imo ke atu teu luluch nge iau pe letemo ma ke nek. Oe, hehei pe hana nga ich nei lape tepoi poreke imo. Pe imo ames ke kerkereng iange iau e hekou sue ich nei ke ulolo.” ");
INSERT INTO uvl_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Iesus hele lange nena hana mur ke het pe nau haka langa lut nga tapa pe hetalaulau ke teke, “Temek, etue nei sauhot lo. O tunge hemalmalinga nem lange Tum ke o heneue hehei pe hana. Pomalam mana lape e heneue hehei pe hana ke te heto heke tote iong. ");
INSERT INTO uvl_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Pe o tunge kerkerenga nge iau ke e muka nge hehei pe hana lochloch. Ke pomalam, e tunge maulinga ke koko nge iri nemur nenge o poia iri ke lek hana mur ia iri. ");
INSERT INTO uvl_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Pe maulinga ke koko luna, ngana kai nei mai: Te eteia iong nge iong toro iong NeHalang toto ngana pe te eteia Iesus Kristus nge o kulos ia at. ");
INSERT INTO uvl_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Ume nenge o tunge at nge iau e poia ke het lo. Ke e hemallaha hote lem hemalmalinga nga ich nei ke ulolo. ");
INSERT INTO uvl_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Temek, nga etue nenge oala hote tapa pe ich ero kura, etu luluch nge iong pe o tunge hemalmalinga palaungana at nge iau. Pe heueu nei eat ke etu luluch mule nge iong pe lape o tung mule hemalmalinga nem at nge iau.” ");
INSERT INTO uvl_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Iau, e hemallaha hote em lange hana nenge o tunge iri at nge iau nga ich nei. Hana nemur iong lem hana mur ia iri pe o tunge iri at nge iau pe te longo taua lem helenga ke ulolo. ");
INSERT INTO uvl_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Pe heueu nei te eteia ke ure lochloch ngana nenge o tunge at nge iau teat pengpeng nge Iong. ");
INSERT INTO uvl_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Pe e tunge hengetoro nenge o tunge at nge iau lange iri pe te mene. Pe te etei tote ke iau eat nge iong pe leteria manmanna toto nge o kulosia iau. ");
INSERT INTO uvl_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Pe iau e hetalaulau hehei pe hana nenga ich nei aria ero. E hetalaulau mana hana nenge o tunge iri at nge iau aria iange lem hana mur ia iri. ");
INSERT INTO uvl_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Pe lek hana mur lochloch iong lem hana mur ia iri. Pe iong lem hana mur lochloch iau lek hana mur ia iri. Pe iri te hemallaha hotote lek hemalmalinga ke ulolo. ");
INSERT INTO uvl_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Iau e lala nge iong heueu lola pe lape etu nga ich nei ero ol. Pe iri te tutu nga ich nei kura. Temek, Iong Non nge Heongana toto. O heneue iri nga kerkerenga nenga em, nga em nenge o tunge at nge iau. Pomalam, iri lape tetu ke elle ke pomange iong pe iau nge ita elle mana. ");
INSERT INTO uvl_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Nga etue nenge etu luluch nge iri e nekia iri nga kerkerenga nenga em nenge o tunge at nge iau. Pe elle nge iri erue ero. Non elle mana nge iri iskeke hot ke mete ke amneia melmelenga palaungana. Pe ure nem lohot ke pete tote lem helenga nenge masio nga alalaha. ");
INSERT INTO uvl_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","“Iau e lala nge iong heueu lola. Pe e heleia ure nemur nga etue nenge etu nga ich kura ke hana nemur leteria iech toto ke mange iau nge e iech toto. ");
INSERT INTO uvl_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","E heleia lem helenga lange lem hana mur ke ulolo pe hehei pe hana nga ich nei singiria sisia iri. Iange iri reria nga ich nei ero. Ke pomange iau nge lek nga ich nei ero pule. ");
INSERT INTO uvl_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Iau e onteia iong ke o mene hote iri nga ich nei ero. E onteia iong ke o nauele iri ke nek nge non poreke ngana. ");
INSERT INTO uvl_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Iange iri reria nga ich nei ero ke pomange iau nge lek nga ich nei ero pule. ");
INSERT INTO uvl_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Lem helenga lohot ke manmanna ke ulolo pe o poia lem helenga nem ke tuteu toto nge iri. Ke o mene iri ke lem hana mur ia iri pe o helemlem ia iri. ");
INSERT INTO uvl_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Iong o kulosia iau ke eat nga ich nei, pomalam mana iau e kulos hote iri ke te haliu hote lem helenga nga ich nei. ");
INSERT INTO uvl_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Pe e tung tote iau lange iong ke e halaua iri. Pomalam, nga lem helenga manmanna ngana lape te tung tote iri lange iong pule.” ");
INSERT INTO uvl_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Pe e hetalaulau lek hana mur mana aria ero. Iri hel pule nenge te longe lek hana mur reria helenga pe leteria manmanna nge iau, e hetalaulau aria pule. ");
INSERT INTO uvl_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Temek, e hetalaulau aria ke iri elle mana ke pomange ita nai. Iange iong otu teu luluch nge iau pe iau etu teu luluch nge iong. Pe pule e hetalaulau ke iri tetu teu luluch nge ita nai. Pomalam hulua lochloch ngana nga ich leteria manmanna ke iong o kulosia iau. ");
INSERT INTO uvl_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Pe e hemalmal ia iri ke pomange iong nge o hemalmal ia iau. Pe e hemalmal ia iri ke iri elle ke pomange ita nai nge ita elle. ");
INSERT INTO uvl_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Iong otu teu luluch nge iau pe iau etu teu luluch nge iri ke lape te lohot ke iri elle toto. Nga poinga nei kileng lochloch nga ich te eteia ke iong o kulosia iau pe mutem taua iri ke pomange iong nge mutem taua iau. ");
INSERT INTO uvl_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Temek, lemek ke hana nenge o tunge iri at nge iau nei tetu luluch nge iau ke te naue lek hemalmalinga nenge lape lohot. Hemalmalinga nem o tunge at nge iau iange mutem tau tele iau nike nga etue nenge oala hote tapa pe ich ero kura. ");
INSERT INTO uvl_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","“Temek, iong non nge pengpeng toto pe hehei pe hana nga ich nei te eteia iong ero. Pe iau e eteia iong pe lek hana mur nenge te nanasia iau te eteia ke iong o kulosia iau at. ");
INSERT INTO uvl_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Pe e hemallaha hote iong lange iri ke te eteia iong ke ulolo. Pe kokoes lape e hemallaha hottote iong lala nge iri. Pomalam lape muteria taua pekngaria mur ke pomange iong nge mutem taua iau pe pule lape etu teu luchluch nge iri.” ");
INSERT INTO uvl_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Iesus hetalaulau ke mau ke het pe iri ul nena hana mur te lotele langa ech nenge Kitron ilina ele. Pe nga lamau ume e nenge te tue ae oliua tu pe Iesus pe nena hana mur tei teu langa ume neu. ");
INSERT INTO uvl_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Iutas i non nenge lape tung heke Iesus lange hana porekreke ngana mur. Ana non eteia kileng neu iange kokoes Iesus pe nena hana mur te eukiraurau nga lamau. ");
INSERT INTO uvl_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Pomalam ana non sauhot nga ume neu. Pe tunginga ana hana mur aria papalauna mur pe Paresio mur te kulosia palpal hussu mur hel ke tela luluch nge Iutas. Pe pule, palinga hel ana hana mur nenge Rom te koke iri pe te lochloch ia reria lemenge mur pe rir pe palinga hel ana ure mur. ");
INSERT INTO uvl_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Pe Iesus eteia ure lochloch ngana nenge lape lohot nge i ke ulolo. Pomalam i hot lange iri pe onteia iri, “A tango rere itei?” ");
INSERT INTO uvl_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Pe iri te tuacholia ke te teke, “Mo tango rerere Iesus nenge Nasaret.” Pe Iesus hele, “Iau i loi.” (Pe Iutas i non nenge teke tung heke Iesus lange iri. Ngana kou mes luluch nge iri pule.) ");
INSERT INTO uvl_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Te longe Iesus nge hele ke teke, “Iau i loi.” Pe te ruka pe te losio langa ich. ");
INSERT INTO uvl_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Pe Iesus ontei mule iri, “A tango rere itei?” Pe iri te hele, “Mo tango rerere Iesus nenge Nasaret.” ");
INSERT INTO uvl_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Pe Iesus hele la mule nge iri, “E hele lange imo ke ulolo ke e teke iau koloi. Pe nenge teke a tango rerere iau, iok a hile hote lek hana nemur ke tela.” ");
INSERT INTO uvl_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","(Iesus hele ke mau pe pete tote nena helenga nenge hele talue ke ulolo. Nenge hele ke teke, “Temek, hana nenge o tunge iri at nge iau lape enau ele iri ke nek toto.”) ");
INSERT INTO uvl_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Pe Simon Petrus lachasiu hote nena palinga hel mese pe pasasal hote tunginga ana hana mur aria soke nena none talngana ele nenga pen tamalmal. (Ana non ene laka Malkas.) ");
INSERT INTO uvl_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Pe Iesus hele lange Petrus, “Otal teu mule mese langa ana manga teu! Pomerei, ak melmelenga lape lohot ke pomanga Temek letena tuanin hot ngana ia. Pe iong mam o teke lemek ero ia kai?” ");
INSERT INTO uvl_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Iok laol, Palinga hel ana hana mur nenge Rom (pe aria soke) pe palpal hussu mur nenge Iuta te laua Iesus pe teman pakiua penna pe te kale hite. ");
INSERT INTO uvl_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Pe te mene ke tela tala ia i nge Anas. Pe Anas i ne Kaipas uene. Pe i, tunginga ana hana mur aria soke ia nga hesinga neu. ");
INSERT INTO uvl_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Ne Kaipas i non nenge hetoro hite Iuta mur ke teke, “Urana nge non elle mana mete ke mene hulua muria.” ");
INSERT INTO uvl_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Pe Simon Petrus pe neingana e te nanasia Iesus ke tela. Pe neingana nem nanas teua Iesus langa Kaipas nena pele ana kileng koana nge hot iange non soke neu eteia i. ");
INSERT INTO uvl_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Pe Petrus kulkulala nge hot nga kue matana. Ol pe Petrus neingana nem at mule pe hele lange hei nenge nauelele kue matana pe mene teua Petrus la. ");
INSERT INTO uvl_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Ol pe hei neu onteia Petrus, “Non neu nena none laka iong pule, ae?” Pe Petrus tuacholia ke teke, “Ero! iau ero i!” ");
INSERT INTO uvl_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Iok, palpal hussu mur pe hekuleileinga ana hana mur temes ke te alelel oan iange kileng lololo. Pe Petrus mes luluch nge iri ke alelel oan pule. ");
INSERT INTO uvl_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Pe tunginga ana hana mur aria soke onteia Iesus nge nena hana mur pe nga hetoro nganngana mur. ");
INSERT INTO uvl_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Pe Iesus tuacholia ke teke, “Iau, e hetottoro nga mallaha nga hulua lochloch mataria. E hetottoro nga hengetoro ana pele pe nga NeHalang nena pele palaungana nenge Iuta mur te eukiraurau ia. Pe e heleia helenga e nga kileng e nge talkome ero. ");
INSERT INTO uvl_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Pe pomerei nenge o onteia iau? O onteia iri nenge te longe lek helenga iange iri te eteia utar nenge e heleia.” ");
INSERT INTO uvl_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Iesus hele ke mau pe palpal hussu e tepele i nga hengene pe hele, “Pomerei nenge o heleia tunginga ana hana mur aria soke ke pomam?” ");
INSERT INTO uvl_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Pe Iesus tuacholia ke teke, “Nenge teke e heleia ute e nge poreke iok, o hele hote lange hulua nemur. Pe nenge teke e heleia ure nenge manmanna, pomerei nenge o tepele iau?” ");
INSERT INTO uvl_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Ol pe Anas kulosia Iesus lange Kaipas pe rur tu hite penna kura. ");
INSERT INTO uvl_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Pe Simon Petrus mes ke alelel oan pe te onteia i, “Non neu nena none laka iong pule, ae?” Pe Petrus channanga pe hele, “Ero, iau ero i.” ");
INSERT INTO uvl_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Petrus hele ke mau pe tunginga ana hana mur aria soke nena none tu lamau pule. Non neu alona laka non nenge Petrus pasasal hote talngana. Ana non lohaka pe hele lange Petrus, “E naue iong pule nge otu luluch nge Iesus nga ae oliua ana ume nem.” ");
INSERT INTO uvl_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Pe Petrus channanga mule pule. Pe nga etue neu pengpeng pareo tang sapele. ");
INSERT INTO uvl_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Nga uach uruna toto te mene hote Iesus nga ne Kaipas nena pele pe te laia i nga non soke nenge Rom nena pele. Pe Iuta mur teteu la ero iange non Rom neu, ne Pilatus, i Iuta ero. Pe nenge te teke teu la lape singiria muna nga NeHalang matana pe lape te ngaua ngaunga nenga Ingatoto ero ol. ");
INSERT INTO uvl_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Ol pe ne Pilatus i hot la pe ontei, “Huna nga utar toto nenge a mene non nei at nge iau?” ");
INSERT INTO uvl_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Pe iri te tuacholia ke te teke, “Nenge teke non nei poia poinga poreke ngana e ero lape mo mene i at nge iong ero.” ");
INSERT INTO uvl_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Pe ne Pilatus hele, “Imo sipomo a mene pe a amnei teu langa nena poinga mur. Pe a poia ke a nanasia lemo hotonga mur.” Pe iri te hele, “Imem, heo ngana nge mo hune mele ke mete.” ");
INSERT INTO uvl_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Reria helenga nemur pete tote Iesus nena helenga nenge hele talue ke ulolo nenge Rom mur lape te hune i. ");
INSERT INTO uvl_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Ol pe ne Pilatus i teu la mule nga pele palaungana neu pe iua Iesus pe onteia i ke teke, “Iuta mur aria soke ma iong mam ae?” ");
INSERT INTO uvl_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Pe Iesus onteia i, “Helenga nem lohot nge iong sipom ma mele hel te heleia iau lange iong?” ");
INSERT INTO uvl_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pe ne Pilatus tuacholia ke teke, “Iong mam o teke iau Iuta kai ae? Lem kileng nganangana mur pe lem tunginga ana hana papalauna mur laka nenge te mene iong at nge iau. Iong mam o poia utar toto e?” ");
INSERT INTO uvl_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Pe Iesus hele, “Iau, lek naualanga pe nekinga ich nei ana ero. Toinge lek naualanga pe nekinga tunga ich nei lape lek hana mur nenge te umume nge iau, tepal pe poi ele Iuta mur nge te laua iau. Pe ero. Lek naualanga pe nekinga ich nei ana ero.” ");
INSERT INTO uvl_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Ol pe ne Pilatus ontei, “Ke hehei pe hana aria naungaala ana non ma iong mam ae!?” Pe Iesus tuacholia, “Lem helenga nem manmanna. Hehei pe hana aria naungaala ana non koi iau. Pe nga nem mana hetak hoe iau pe eat nga ich nei ke e hele hote helenga manmanna ngana. Pe iri lochloch nenge te longo lala nga helenga manmanna ngana mur te longo atat nge iau.” ");
INSERT INTO uvl_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pe ne Pilatus ontei, “Helenga manmanna ngana mam i utar ia?” Ol pe ne Pilatus i hot mule lange Iuta mur pe hele, “Iau, e hottaua ute e nge non nei poia ke poreke ero. ");
INSERT INTO uvl_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Nga soksoko lochloch nga ngaunga matana nenga Ingatoto ana etue, e tung hotote none nga tuele au ngana lange imo. Poinga nem e poia ke nanas urume lemo poinga. Lememo ke e tung hote Iuta mur aria naungaala ana non, ae?” ");
INSERT INTO uvl_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Pe iri alngaria la mule, “Ero, i ero! O tung hote Parapas at nge imem!” Pe Parapas i non nenge hunun hana pe kemkeme. ");
INSERT INTO uvl_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Ne Pilatus hele ke palinga hel ana hana mur te nosia Iesus. ");
INSERT INTO uvl_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Pe te helule rur nge matantana nenge pomanga pale pe tetal heke nga palpalna pe te heron heke hengeron kunkun ngana nge i. ");
INSERT INTO uvl_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Pe emule mana te songlele ia i ke te teke, “Masin! Iuta mur aria naungaala ana non! Lape omes ke kerkereng ol!” Pe te tepele nga ramana. ");
INSERT INTO uvl_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Ol pe ne Pilatus i hot la mule pe hele lange Iuta mur, “A longo at! Lape e hele ke te mene hote i at nge imo ke anau nge i. Ke lape a eteia nge iau e hottaua poinga poreke ngana e nge poia ero.” ");
INSERT INTO uvl_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Iok, Iesus i hot la luluch nga rur matantana ngana nenge tetal heke nga palpalna pe hengeron kunkun ngana neu. Pe ne Pilatus hele lange iri, “Anau at ana non koi!” ");
INSERT INTO uvl_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Pe tunginga ana hana mur aria papalauna mur pe palpal hussu mur te naue Iesus pe alngaria ke te teke, “O heon heke i nga manga toto! O heon heke i nga manga toto!” Pe ne Pilatus tuacholia lange iri ke teke, “Imo sipomo a mene i pe a heon heke i nga manga toto. Iange iau, e hottaua poinga poreke ngana e nge poia ero.” ");
INSERT INTO uvl_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Pe Iuta mur te hele, “Imem lemem hotonga e tu. Pe mo teke non nem mete urume hotonga nem hele ngana iange i sipona hele ke teke i NeHalang Tuna.” ");
INSERT INTO uvl_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Ne Pilatus longe hana nemur reria helenga pe matau toto. ");
INSERT INTO uvl_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Ol pe iteu la mule nga pele palaungana neu pe ontei mule Iesus, “Iong mam lem langai toto?” Pe Iesus heleia helenga e ero. ");
INSERT INTO uvl_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Pe ne Pilatus hele, “Pomerei nenge o tuacholia iau ero? Iau lek kerkerenga nenge e hele ala am pe lek kerkerenga nenge e hele ke palinga hel ana hana mur te heon heke iong nga manga toto. O eteia nei ero kai?” ");
INSERT INTO uvl_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Pe Iesus hele, “NeHalang tunge kerkerenga nem lange iong. Pe nenge teke ero mele pele nge tunge iau lange iong ero. Pe non nenge tunge iau lange iong, na poinga poreke ngana mur ele haka toto nga lem poinga poreke ngana mur.” ");
INSERT INTO uvl_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Ne Pilatus longe helenga nei pe letena tuanin rara ke teke hele ala Iesus ana. Pe ero Iuta mur alngaria ke te teke, “Nenge teke o hele ala ana lape neingam ne Kaesa ero ol. Ne Kaesa nena ngarang toto laka mele nenge hele ke teke i naungaala ana non.” ");
INSERT INTO uvl_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Ne Pilatus longe helenga nei pe mene hote Iesus lange hot pe la ke are nga arenga nenge te amnei urumrume helenga mur. Nga kileng unne nenge te hetue ke Um Arenga. Nga helenga Hipru te hetue ke Kapata. ");
INSERT INTO uvl_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Iok, ngaunga matana nenge Ingatoto ana etue mam pe lohot. Pe etue neu i etue nenge te tatalo elele ure mur pe lala ke sinanga luana lo. Pe ne Pilatus hele lange Iuta mur, “Anau at amo naungaala ana non koi.” ");
INSERT INTO uvl_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Pe iri alngaria ke te teke, “A mene hote i kela aheon heke nga manga toto.” Pe ne Pilatus onteia iri, “A teke e heon heke amo naungaala ana non nga manga toto?” Pe tunginga ana hana mur aria papalauna mur te tuacholia ke te teke, “Imem emem naungaala ana none ero ol, ne Kaesa i toro mana.” ");
INSERT INTO uvl_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Pomalam ne Pilatus tunge Iesus lange iri ke te heon heke nga manga toto. Ol pe Palinga hel ana hana mur te mene Iesus kela. ");
INSERT INTO uvl_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Pe Iesus i sipona takisia ana manga toto kela nga Kittol ana kileng (nenge iri Hipru te hetue ke Kolkota.) ");
INSERT INTO uvl_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Nga lamau te heon heke i nga manga toto pe te heone hana nai pule nga Iesus ilina ele pe ele. Elle heon nga pen tamalmal pe e nga pen hoihoi pe Iesus nga tunangana. ");
INSERT INTO uvl_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pe ne Pilatus hele ke tehas ia helenga toto e pe tetal heke nga manga toto. Helenga toto neu hele ke pomai, “IESUS NENGE NASARET, IUTA MUR ARIA NAUNGAALA ANA NON.” ");
INSERT INTO uvl_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Helenga toto neu tehas ia nga helenga Hipru pe helenga Latin pe helenga Krik. Pe hulua halang te sisia helenga neu iange kileng nenge te heon heke Iesus ia, tu rochroi mana nga tuele tana palaungana neu. ");
INSERT INTO uvl_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Ol pe tunginga ana hana mur aria papalauna mur te hele lange ne Pilatus ke te teke, “Iong ohas ia ke ‘Iuta mur aria naungaala ana non’. Pe imem mo teke ohas ia ke pomai koi, ‘Non nei hele ke teke i Iuta mur aria naungaala ana non.’” ");
INSERT INTO uvl_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pe ne Pilatus hele, “Utar nenge e hele ke tehas ia tu ke pomalalom.” ");
INSERT INTO uvl_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Iok, palinga hel ana hana mur te hero hite Iesus nga manga toto ke het pe te mene nena hengeron mur nenge hot ana pe te heronge nge iri. Pe te mene nena hengeron nenge teu ana pule nenge ana simanga nga ilina ero. ");
INSERT INTO uvl_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Pe te hele tele hel nge iri ke te teke, “Nena hengeron nei lape ta chachia ero. Ta poia hesalanginga e ke henonou hote non tei nenge lape mene ke nena ia.” Poinga nei lohot ke pete tote NeHalang nena helenga nenge masio nga alalaha ke ulolo nenge hele ke teke, “Te mene lek hengeron mur nenge hot ana pe te heronge nge iri. Pe te poia hesalanginga e nga lek hengeron nenge teu ana ke henonou hote non tei nenge lape mene ke nena ia.” Ke palinga hel ana hana mur te poia poinga nei. ");
INSERT INTO uvl_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Iok, Iesus tana pe tana tina pe Maria nenge Klopas nehei pe Maria nenge Maktala, temes rochroi nga manga toto nenge Iesus heon haka ia. ");
INSERT INTO uvl_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Pe Iesus nena non nenge mutena tau tote mes pule. Ol pe Iesus naue i pe hele lange tana ke teke, “Etak o naue i ke pomanga tumia.” ");
INSERT INTO uvl_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Pe pule Iesus hele lange nena non neu, “Pe iong o naue i ke pomanga tamia.” Ke nga etue neu pengpeng Iesus nena non neu mene he Maria langa nena pele ke nauele i. ");
INSERT INTO uvl_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Iok, Iesus eteia ke ure lochloch ngana umeia ke het lo. Ol pe hele, “E teke ein ech.” Iesus nena helenga nei lohot ke pete tote NeHalang nena helenga nenge masio nga alalaha ke ulolo. ");
INSERT INTO uvl_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Kaliu e nge muta ia uain ehech ngana ma. Pe te mene ute nge makuk pe te panun teua la ke rumia uain neu. Ke het pe te kale taua nga memeta kina pe tetul heke langa Iesus hanna. ");
INSERT INTO uvl_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Iesus inia uain neu ke het pe hele, “Het lo.” Ol pe Iesus palpalna tuakolo sio pe ngana iuch hot sapele. ");
INSERT INTO uvl_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Iok, ngaunga matana nenga Ingatoto ana etue mam pe lohot. Pe etue neu i etue nenge te tatalo elele ure mur. Pe Iuta mur aria papalauna mur lemeria ero hana nge te heon nga manga toto nga etue palaungana neu. Pomalam te onteia ne Pilatus ke te teke, “O longele imem ke mo pal hoa hana nemur aperia kina pe mo mene sue koluria mur nga manga toto.” ");
INSERT INTO uvl_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Ol pe palinga hel ana hana mur tela tala nge hana nai nem pe te pal hoa aperia kina ke te mete ke ueiuei. ");
INSERT INTO uvl_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Iok, te teke tela nge Iesus pe tenau pe mete lo. Pomalam te pal hoa apena kina ero. ");
INSERT INTO uvl_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Pe palinga hel ana none tua teua io nga Iesus alalina. Ol pe Iesus eina pe ech te pasiling hot. ");
INSERT INTO uvl_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Mele nenge naue ure nei nge lohot heleia ke teke ure nei lohot ke manmanna. Pe eteia ke teke i hele ke manmanna. Ke imo pule lape letemo manmanna. ");
INSERT INTO uvl_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Ure nemur te lohot ke pete tote NeHalang nena helenga nenge masio nga alalaha ke ulolo, nenge hele ke teke, “Lape te pal hoa kina e ero.” ");
INSERT INTO uvl_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Pe NeHalang nena helenga e pule nge masio nga alalaha lo hele ke teke, “Lape tenau lange non nenge tetue ana io.” ");
INSERT INTO uvl_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Iok, urelu lochloch ngana nemur te lohot ke ulo pe Iosep nenge nena nge Arimatea lake ontei tote Iesus koluna nge ne Pilatus ke teke alo hite. Pe ne Pilatus longala. Pomalam, Iosep lake mene sue Iesus koluna. Iosep i Iesus nena non ia pule pe talkome letena manmanna ngana pe heleia lange mele ero toto iange mataua Iuta mur aria papalauna mur hel pule. ");
INSERT INTO uvl_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Pe Nikotemus i non nenge lake naue Iesus nga miliko nga etuene lo, i pule la luluch nge Iosep. Ana non mene sini ana monri nge meena toto. Sini nemur teume hote ae nai eiria nge te heluluch tele pe inangaria ehech toto. ");
INSERT INTO uvl_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Iri nai te mene Iesus koluna pe te ruchite nga ruchinga hit hussu ngana. Pe teun hite Iesus koluna ana sini nemur. Te poia ke te nanasia poinga nenge Iuta mur te popoia nga aria pum mur, nenge tealo hitite iri. ");
INSERT INTO uvl_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Iok, metenga ana ich unne tunga kileng nenge te heon haka Iesus ia. Pe polo heueu ngana e nge mele koluna mateu ia ero kura, tunga metenga ana ich unne neu. ");
INSERT INTO uvl_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Pe tetal teu mene Iesus koluna nga polo neu iange polo neu tu ke rochroi mana. Pe pule etue neu i etue nenge te tatalo elele ure mur nga Israel mur aria etue palaungana nenge te hetalaulau ia. ");
INSERT INTO uvl_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Iok, nga Sante nga uach uruna toto kileng nonenone kura pe Maria Mantalena oala ke langa polo nenge Iesus koluna mateu ia. Oala kela pe um nenge tetal ele nga polo hanna tunga munna ero ol. ");
INSERT INTO uvl_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Ana hei naue ke mau pe song langa kileng nenge Simon Petrus iri nai Iesus nena non nenge mutena tau tote te tutu ia. Song la pe hele, “Te hemou hote Non Soke koluna lo pe mo eteia tetal ngaria ia ero.” ");
INSERT INTO uvl_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Ol pe Petrus iri nai i nenge Iesus mutena tau tote neu, te song sapele ke tela nga polo nenge Iesus koluna mateu ia. ");
INSERT INTO uvl_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Te song ke te lala pe Iesus nena non nenge mutena tau tote ris tote Petrus pe song kela sauhot tala, ");
INSERT INTO uvl_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","pe teu langa polo ero. Tatuch sio ke teke nau pe es mene ruchinga hit hussu ngana mur nge tema. ");
INSERT INTO uvl_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Pe Simon Petrus at ke sauhot pe teu la pengpeng nga polo pe naue ruchinga hit hussu ngana nemur nge tema. ");
INSERT INTO uvl_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Pe nenge te ruch hit Iesus palpalna ia, te loua ke ma ke altoto nga ruchinga hit hussu ngana nemur. ");
INSERT INTO uvl_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Iok, Iesus nena non nenge sauhot tala i pule nanas teu la. Teu la pe naue ure nemur pe letena manmanna. ");
INSERT INTO uvl_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","NeHalang nena helenga nenge masio nga alalaha ke ulolo hele ke teke, “Iesus lape maul haka mule nga metenga.” Helenga nei mallaha nge iri ero kura. ");
INSERT INTO uvl_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Ol pe iri nai te lohaka pe tela mule nga tetu ngaria. ");
INSERT INTO uvl_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Pe Maria mes ke tangtang nga polo hanna ol. Pe tatuch sio ke teke nau teu la, ");
INSERT INTO uvl_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","pe naue angkelo nai nge reria hengeron hussu pe teare nga Iesus koluna ma ngana. Elle are nga Iesus palpalna ma ngana pe elle are nga Iesus apena ma ngana. ");
INSERT INTO uvl_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Pe te onteia hei neu, “O tangtang ia utar?” Pe hei neu hele, “E tangtang ia ak Soke koluna, ngana i mele hel te hemou hote pe e eteia tetal ngaria ia i ero koi.” ");
INSERT INTO uvl_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Ana hei hele ke mau pe ralele pe naue Iesus nge mes pe lekleke i. ");
INSERT INTO uvl_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Ol pe Iesus onteia i, “O tangtang ia utar? Pe o tango rerere itei?” Pe hei neu teke ma non nenge nauelele metenga ana ich unne neu ke hele lange i ke teke, “Kole, nenge teke o hemou hote Iesus koluna, o heleia at nge iau pe mola ke mo lolo mule at.” ");
INSERT INTO uvl_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Pe Iesus hetue hei neu ene, “He Maria!” Pe Maria ralele lange Iesus pe hele nga helenga Hipru ke teke, “Raponi!” (Helenga nei luna, “Hetoronga.”) ");
INSERT INTO uvl_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Ol pe Iesus hele lange i, “Ora at nge iau ero iange e haka lange Temek ero kura. Ola ke o hele lange titik mur nenge leteria manmanna nge iau ke o teke, iau e haka lala nge Temek nenge iri pule Temeria pe i ak Soke ia nenge iri pule aria Soke.” ");
INSERT INTO uvl_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Iok laol, Maria Mantalena lange Iesus nena hana mur pe hele ke teke, “E naue Non Soke lo.” Pe nene ure nemur nenge Iesus heleia lange i nge iri pule. ");
INSERT INTO uvl_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Iok, nga Sante nga ulei Iesus nena hana mur te eukirau nga pele e pe tepiu ele iri ke kerkereng toto iange te mataua Iuta mur aria papalauna mur. Pe Iesus lohot mana ke mes nga tunangaria pe hele ke teke, “E hetalaulau amo ke letemo maluch sio ke nek mule.” ");
INSERT INTO uvl_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Iesus hele ke pomau ke het pe heteia penna mur pe alalina lange iri. Iesus nena hana mur leteria iech toto nge tenau mule i. ");
INSERT INTO uvl_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Pe Iesus hele mule lange iri, “E hetalaulau amo ke letemo maluch sio ke nek mule. Temek kulosia iau ke eat pomalam mana lape e kulosia imo ke ala.” ");
INSERT INTO uvl_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Iesus hele ke mau ke het pe ula hote eingana lange iri pe hele, “A mene Opepengpeng. ");
INSERT INTO uvl_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Nenge teke a saua hehei pe hana reria poinga poreke ngana ke te lasus toto, NeHalang lape poia ke pomalam pule. Pe nenge teke a saua hehei pe hana reria poinga poreke ngana mur ero, poinga poreke ngana nemur lape tetu kura.” ");
INSERT INTO uvl_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Iok, Iesus nena hana mur iri analoch pe nai pe elle nge iri ene Tomas (nenge tehau keke ke ene Titimus). Pe nga etue nenge Iesus lohot nge nena hana mur Tomas tunga etue neu ero. ");
INSERT INTO uvl_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Ol pe pekngana mur tela pe te hele lange i ke te teke, “Mo naue Non Soke lo!” Pe Tomas hele lange iri, “Imo a teke a naue Iesus pe iau letek manmanna nga lemo helenga nemur ero. Nenge teke e naue kirum munna nga penna mur pe io munna nga alalina pe e rahite iri lape letek manmanna.” ");
INSERT INTO uvl_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Iok, etue iri rahtele nai mule nga hoena Iesus nena hana mur tetu teu mule nga pele letena. Nga etue neu Tomas tu luluch nge iri ol. Pe tepiu ele pele matana mur ke kerkereng toto. Pe Iesus at mana ke mes nga tunangaria pe hele, “E hetalaulau amo ke letemo maluch sio ke nek mule.” ");
INSERT INTO uvl_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Ol pe Iesus hele lange Tomas, “O talue perim kukana at nga kirum munna nenga perik pe onau. Pe otul hote perim pe opoi teua nga alalik. Letem manmanna pe letem nachnai ero ol.” ");
INSERT INTO uvl_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Pe Tomas tucholia pe hele ke teke, “Iong NeHalang nenge e heto hekeke pe ak Non Soke iong!” ");
INSERT INTO uvl_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Ol pe Iesus hele lange i ke teke, “Urana hatong! Iong o naue iau pe letem manmanna pe iri nenge te kolkol ia iau pe leteria manmanna lape te iech toto.” ");
INSERT INTO uvl_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Tehas hote alalaha nei iange nga etue nenge Iesus tu luluch nge nena hana mur, poi hote merakulo mur nge halang toto. Pe ure nemur nenge Iesus poi hote iri nem, halang tehas sue nga alalaha nei ero. ");
INSERT INTO uvl_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Pe nemur nenge ehas sue iri nei, nenge poia ita ke letera manmanna ke Iesus i NeHalang Tuna pe i Kristus. Ke nenge teke letera manmanna nga nem, lape ta mene maulinga ke koko nga Iesus ene. ");
INSERT INTO uvl_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Iok, nga hoena Iesus hetei hot mule nge nena hana mur nga ech nge Kalelea. (ech nem ene e pule Tiperius) Pe hetei hot ngana ia i poi ke pomai: ");
INSERT INTO uvl_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Simon Petrus pe Tomas (nenge tehau keke ke ene Titimus) pe Nataniel (nenge nena nge Kana nge Kalelea) pe ne Sepeti tutuna mur pe Iesus nena hana nai pule, tetu ke muria elle nga lamau. ");
INSERT INTO uvl_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Pe Simon Petrus hele lange iri ke teke, “Iau lape e lohot kela euas.” Pe iri te hele, “Mo koko nge iong ke itaul ta uas.” Ol pe tela ke te lohaka sapele nga sulang. Pe nga miliko neu ruo e ha nga aria hoat ero toto. ");
INSERT INTO uvl_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Pe nga uach uruna kileng matale sisio pe Iesus mes nga peipei nga ech ilina pe nena hana mur te naue pe te lekleke i. ");
INSERT INTO uvl_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Ol pe Iesus ontei hot lange iri ke teke, “Hana, a uasia ruo hel kau?” Pe iri te tuachol ia ke teke, “Ero toto i!” ");
INSERT INTO uvl_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Pe Iesus hele lange iri, “A hesue amo hoat lakou nga sulang ilina ele nenga pen tamalmal. Nga lamam lape aole ruo hel.” Iok, te hesue hoat nem la pe te alker nge tetak haka mule iange ruo halang toto teha nga hoat. ");
INSERT INTO uvl_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Pe Iesus nena non nenge mutena tau totote hele lange Petrus, “Non Soke laka nenge hele hot atat nge ita nem!” Nga etue nenge Simon Petrus longe non neu nge hele ke teke “Non Soke laka nenge hele hot atat nge ita nem,” ueiuei mana kale loua nena hengeron nenge hot ana nga luana (iange i haka hot tele ke ulolo) pe tamu sio nga ech pe pasu sio ke langa peipei. ");
INSERT INTO uvl_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Pe pekngana mur teote sulang pe teole hoat luluch nga ruo ke tesio langa peipei iange malang nenge sio langa peipei sase ero. Sase ngana ana lome iri ana non kina lime mana. (100 mita) ");
INSERT INTO uvl_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Iok, tela ke temes nga peipei pe te naue oan ngingina ngana. Pe nga oan matana te naue ruo hel nge makmak pe ngaunga hel tema pule. ");
INSERT INTO uvl_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Ol pe Iesus hele lange iri ke teke, “Ruo nenge aole iri nem, a mene hel at.” ");
INSERT INTO uvl_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Iok, Simon Petrus tamu haka nga sulang pe halaua pekngana mur ke teole sue hoat ke langa peipei. Pe hoat neu muta ia ruo papalaungana mur nge iri ana non kina rahtele nai pe analoch pe mol (153). Ruo nemur iri halang pe hoat neu chach poreke. ");
INSERT INTO uvl_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Ol pe Iesus hele lange iri, “Aiat ke angau ol.” Iesus nena hana mur te eteia ke i Non Soke. Pe iri te here tau helia onteinga nenge, lape elle nge iri ontei lil hote i ke teke, “Ia iong itei mam?” ");
INSERT INTO uvl_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Ol pe Iesus lake mene ngaunga nem pe tunge lange iri pe poia ruo ke pomalam pule. ");
INSERT INTO uvl_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Ke Iesus maul haka mule nga metenga ke ulolo. Pe hetei hot ngana ia i lange nena hana mur hemol ngana koi nga nenge nei. ");
INSERT INTO uvl_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Iok, te ngau ke het pe Iesus onteia Simon Petrus, “Simon, iong ne Ioanes tuna. Imo lochloch ngana nei mutemo taua iau, pe iong mutem tau tote iau ma ero?” Pe Petrus tuacholia, “Oe Non Soke. O eteia ke iau mutek tau tote Iong.” Pe Iesus hele lange i ke teke, “O nauele lek hana mur ke nek ke pomanga o nauele sipsip mur.” ");
INSERT INTO uvl_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Pe Iesus ontei henai ngana, “Simon iong ne Ioanes tuna. Mutem tau tote iau ma ero?” Pe Simon tuacholia, “Oe Non Soke, o eteia ke iau mutek tau tote Iong.” Pe Iesus hele lange i ke teke, “Onek hite lek hana mur ke pomanga onek hite sipsip mur.” ");
INSERT INTO uvl_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Pe Iesus ontei hemol ngana ke teke, “Simon iong ne Ioanes tuna. Mutem tau tote iau ma ero?” Pe Petrus letena huna iange Iesus ontei hemol ia i ke ulolo ke teke. “Mutem taua iau ma ero?” Ol pe Petrus hele, “Non Soke Iong o eteia ure lochloch ngana pe o eteia ke mutek tau tote iong!” Pe Iesus hele lange i ke teke, “O nauele lek hana mur ke nek ke pomanga o nauele sipsip mur. ");
INSERT INTO uvl_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Pe e hele ke manmanna toto lange iong; Nga iong lomele ngam iong sipom o hemele iong pe oi ke ola nga lemem ngam. Pe nga etue nenge o tuauna ol lape otul hote perim pe mele at ke hemele iong. Pe lape mene iong langa kileng nenge lemem ero nge ola ia.” ");
INSERT INTO uvl_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","(Petrus mete ngana lape lohot ke mau kou nga Iesus hele ngana neu. Pe nga nem lape te heto heke tote NeHalang ene.) Iesus hele ke mau ke het pe hele, “Oi at ke o nanasia iau.” ");
INSERT INTO uvl_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Ol pe Petrus ralele pe naue Iesus nena non nenge mutena tau totote nge nananasia iri. (I laka nenge matu haka toto nge Iesus nga etue nenge te ngaungau pe onteia i ke teke, “Non Soke itei toto nenge lape tung heke iong langa hana porekreke ngana mur peria?”) ");
INSERT INTO uvl_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Ke Petrus naue i pe onteia Iesus ke teke, “Non Soke, pe non neu lape te poia i ke pomerei?” ");
INSERT INTO uvl_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Pe Iesus tuacholia ke teke, “Nenge teke lemek non nem lape tu ke maulul kela het nga etue nenge eat mule. Pe pomerei nenge letem una sakilil nga ure nei? O iat ke o nanasia iau!” ");
INSERT INTO uvl_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Ol pe Iesus nena hana mur nenge te nananas ia i, iri halang te longe pe te hele ke te teke Iesus nena non nem lape mete ero. Helenga nenge non nem lape mete ero Iesus heleia ero. Iesus hele mana ke teke, “Nenge teke lemek non nem lape tu ke maulul kela het nga etue nenge eat mule. Pe pomerei nenge letem huna sakilil nga ure nei?” ");
INSERT INTO uvl_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Iesus nena non nenge mutena tau tote esia ure lochloch ngana nei pe heleia helenga nemur pe has sue iri. Pe ita ta eteia ke nena helenga nemur manmanna. ");
INSERT INTO uvl_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Iesus poia ure lochloch ngana hel pule. Pe nenge teke tehas sue ure lochloch ngana nemur nga alalaha, iau e teke ich nei kino mana pe alalaha nemur lape muria ero nge tema ia. ");
INSERT INTO uvl_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Oe, Teopilos mur, iau Lukas koi ehas ia alalaha nei lange imo pe e teke e hele mule lange imo. Nga lek alalaha nenge ehas tele lange imo, e has urume ure lochloch ngana nenge Iesus popoia pe hetottore nga etue nenge talune ana ume, ");
INSERT INTO uvl_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","kela het nga etue nenge haka langa lut nga tapa. Ana non haka langa lut nga tapa ero kura pe Opepengpeng halaua i ke hele lange nena hana mur nenge hesilei hote iri. Pe i hele urume reria ume nenge lape te poia. ");
INSERT INTO uvl_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Iesus mete ke ulolo pe lohot mulmule nge nena hana mur ke etue iri ana non kina nai (40). Pe nga etue nemur, popoia ure halang ke te esia pe leteria manmanna ke Iesus maul haka mule nga ana metenga lo. Nena hana mur te esia i pe heleia NeHalang nena naualanga pe nekinga lange iri. ");
INSERT INTO uvl_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Nga etue nenge Iesus tu luluch nge iri kura pe tunge helenga kerkereng ngana nei lange iri ke teke, “Atu nge Ierusalem mukam ke a kulele tunginga nenge e hele ia lange imo lo. Tunginga nenge Temek heleia ke teke tunge lange imo. ");
INSERT INTO uvl_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Ioanes henune imo nga ech mana. Pe nge rou pongnai lape a mene henuninga nga Opepengpeng.” ");
INSERT INTO uvl_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Iesus nena hana mur teare luluch nge i pe te onteia i ke te teke, “Non Soke, lape otal haka mule Israel kai? Nga etue nemai?” ");
INSERT INTO uvl_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Pe Iesus hele, “Ure papalaungana nemur aria etue, Temek i sipona talue iri. Iange i nauele ure lochloch. Ke imo a eteia ure nemur te lohot ngaria ero. ");
INSERT INTO uvl_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Pe nga etue nenge Opepengpeng sio at nge imo, lape a mene kerkerenga nenge a haliu hote iau lange hehei pe hana lochloch. Ke lape a haliu nge Ierusalem pe nge Iutea lochloch pe nge Samaria pe nga kileng lochloch ngana nga ich.” ");
INSERT INTO uvl_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Iesus helele kura pe NeHalang mene heke i ke la sapele nga lut nga tapa. Pe hana nemur temes ke tenau ala tote i kela lele teu nga ulu. ");
INSERT INTO uvl_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Hana nemur mataria tu mana nga lut kura pe hana nai nge reria hengeron hussu te lohot ke temes luluch nge iri. ");
INSERT INTO uvl_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Pe te hele, “Imo hana nenge Kalelea, pomere nenge ames ke anau haka lamana nga tapa mam? A esia Iesus laka NeHalang mene heke i ke la nga lut nga tapa lo! Pe at mule ngana, lape pomalam mana nga haka la ngana nem.” ");
INSERT INTO uvl_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Ure nemur te lohotot pe Iesus nena hana mur tetu nga hengene nenge Oliua. Ke het pe tei sio ke tela mule nge Ierusalem. Pe kue sase ngana nenge lange Ierusalem ana lome iri ana non kina iri lime iri analoch. (kilomita elle) ");
INSERT INTO uvl_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Iok laol, tei teu lange Ierusalem pe tei haka langa lut nga pele letena unne nenge te tutuia. Iri lochloch eria koi: Petrus, Ioanes, Ieims, Antreas, Pilipus, Tomas, Patolomius, Mateus, Ieims nenge Alpeus tuna, Simon nenge seilil kina, pe Iutas nenge Ieims tuna. ");
INSERT INTO uvl_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Iri lochloch te eukirau ke kokoes mana ke te hetalaulau. Iri ul hehei nemur pe Maria nenge Iesus tana, pe Iesus titina mur. ");
INSERT INTO uvl_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Nga etue hel nga hoena iri lochloch ngana nenge leteria manmanna te eukirau. Iri nenge te lohot, iri ana non kina iri rahtele elle (120). Pe Petrus mes haka pe hele, ");
INSERT INTO uvl_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Titik mur pe liliuk mur, imo a eteia poinga nenge Iutas poia nem. NeHalang nena helenga lohot ke manmanna lo. Ke Opepengpeng hele hote nga Teuit anna ke teke, Iutas lape i non nenge henonou hote hana nenge te laua Iesus. ");
INSERT INTO uvl_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Nga tele ngana, imem pekngamem Iutas pe i rahite ume elle mana nenge pomange imem nei.” ");
INSERT INTO uvl_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(Iok Iutas poia poinga poreke ngana nem pe te olia i nga umtutuna. Pe mene umtutuna nem pela olia ich unne. Pe nga ich unne nem, ana non losio ke mete pe sana chach pe makanna pararai hot. ");
INSERT INTO uvl_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Hulua lochloch ngana nenge tetu nge Ierusalem, te longe pe te hetue kileng neu nga reria helenga ke ene Akaltama. Luna: Eina lele ich.) ");
INSERT INTO uvl_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Pe Petrus hele mule, “Helenga nenge Teuit has sue nga alalaha nenge Sam hele ke pomai, “‘Lape na pele nganngana ero pe mele tuia ero.’” Pe hasinga e pule hele ke teke, “‘Mele lape mene munna nga ana ume.’ ");
INSERT INTO uvl_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Ke pomlam lape ta henonou hote mele ke mene munna ol. Pe mele nem lape ta henonou hote nga iri hana nenge te i lululuch nge ita nga etue lochloch nenge Non Soke Iesus i luluch nge ita. ");
INSERT INTO uvl_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Talun ngana nga etue nenge Ioanes henunun, ke la het nga etue nenge NeHalang mene heke Iesus langa lut nga tapa.” ");
INSERT INTO uvl_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Iok laol, te henonou hot ke hana nai. E ene Iosep nenge te hetue ke Pasapas (pe ene e pule Iastus). Pe e ene Mateas. ");
INSERT INTO uvl_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Ol pe te hetalaulau lange NeHalang ke pomai, “Non Soke iong o eteia utar nenge tuteu nga hulua lochloch leteria. Ke pomalam o hemallaha hote non elle nge iri nai nei ol, nenge o henonou hote ");
INSERT INTO uvl_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","ke mene Iutas munna. Iange Iutas hile sue ume nei lo. Pe i kou lake amnei ana nga kileng unne nenge lape laia.” ");
INSERT INTO uvl_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Laol pe te mene um nai nenge hana nai neu eria maia, pe te saua ana maelpa pe Mateas ene mahot ia. Pomalam tesis luluche i lange Iesus nena hana analoch pe elle neu, ke mene Iutas munna. ");
INSERT INTO uvl_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Pentekos ana etue at pe iri lochloch te eukirau ke muria elle. ");
INSERT INTO uvl_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Pe ueiuei mana ute sio at nga tapa pe alngana pomanga tuttula palaungana. Sio at pe hemute pele letena nenge te tuia. ");
INSERT INTO uvl_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Ol pe te esia ute hel nge pomanga oan remen ngana nge la ke rongo heke iri elle pe elle pe tu haka mana nga houngaria. ");
INSERT INTO uvl_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Te muta nga Opepengpeng pe te talun ke te hele nga helenga altoto ngana mur nenge tunge lange iri. ");
INSERT INTO uvl_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Pe nge Ierusalem, Iuta mur hel nenge leteria metene NeHalang ke kokoes, te tu pule. Pe iri teat nga kileng lochloch ngana nga ich. ");
INSERT INTO uvl_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Te longe ure neu nge lohot pe teat ke te eukirau. Teat ke te eukirau pe te rura toto iange te longe hana nemur nge te helele nga kileng elle pe elle reria helenga mur pengpeng. ");
INSERT INTO uvl_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Ol pe ngaria lohot pe te hele, “Hana nemur reria nge Kalelea pe chauling mur ia iri. ");
INSERT INTO uvl_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Pe pomere nenge ta longe iri nge te hele nga ita sipora rera helenga mur mai? ");
INSERT INTO uvl_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Ita lochloch ngana nei ta at nga kileng nemur nge Patia pe nge Mitia, pe nge Ilam pe nga kileng nenge Mesapotamia pe nge Iuta pe nge Kapatosia pe nga kileng nenge Pontus pe Eisia pe nge ");
INSERT INTO uvl_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Prikia pe nge Pampilia pe nge Ekipto. Pe nga kileng nemur nenge Lipia nenge rochroi lange Sirini. Pe ara hel nge ita teat nge Rom. ");
INSERT INTO uvl_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","(Iri nenge teat nge Rom, hel iri Iuta pengpeng nike. Pe hel, iri Iuta ero mukam pe nga hoena te lohot ke iri Iuta.) Pe ara hel nge ita teat nge Krit pe nge Arapia. Pe ita lochloch ngana ta longe hana nemur nge te heleia ure papalaungana nemur nenge NeHalang popoia iri. Pe te heleia ure nemur nga ita sipora rera helenga mur pengpeng.” ");
INSERT INTO uvl_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Ngaria lohot pe leteria lilil toto pe te ontei hel mulmule nge iri ke te teke, “Ure nenge lohotot nemai, luna mere toto mai?” ");
INSERT INTO uvl_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Pe hel tetua sal haka ke te teke, “Hana nemur tein iam.” ");
INSERT INTO uvl_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Iok, Petrus mes haka luluch nge pekngana mur nenge analoch pe elle nem pe haliu ke palaungana toto lange hulua lochloch ngana ke teke, “Iuta mur pe imo lochloch ngana nenge atu nge Ierusalem, a longo at nge iau pe e hemallaha hote ure nenge te lohotot nei luna lange imo. ");
INSERT INTO uvl_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Imo a teke hana nemur tein. Pe iri tein ero iam, iange kileng uach mana kura! ");
INSERT INTO uvl_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","E hele lange imo pengpeng, ure nenge te lohotot nei, hetatalonga Ioel hele talue nge nike lo. Hele ke teke, ");
INSERT INTO uvl_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","“‘NeHalang hele ke pomai koi; Etue nemur nga hoena nge te lohot tala nga etue hetala ngana, iau lape e tunge Opepengpeng ke rongo heke iri lochloch. Tutumo mur tatamanna pe tutumo mur heheina, lape te haliu hote lek helenga mur. Pe lape lemo lolomele mur, lape tenau operia ia ure mur pe amo hana papalauna mur, lape tema operia rara. ");
INSERT INTO uvl_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Pe lek hekuleileinga ana non mur, manmanna toto ke te mene Opepengpeng nem pule, ke iri pule te haliu hote lek helenga mur. Iri nenge tatamanna pe heheina pule. ");
INSERT INTO uvl_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","20","Pe lape epoi hote ana lala hel nga lut nga tapa ke pomai, lape chaia tua ero ol, pe kileng au mana. Pe teio matana lape hul ke pomanga toho. Pe lape epoi hote ana lala hel nge sio nga ich ke pomai, lape e heremenia kileng nga toho pe e poia kileng ke oan ngaulele pe kileng pulu ala mana. Pe ure nemur lape te lohot tala nga NeHalang ana etue nenge palaungana toto. ");
INSERT INTO uvl_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Pe iri lochloch ngana nenge te tang la nge Non Soke ke halaua iri, lape tetu ke te maulul.’” ");
INSERT INTO uvl_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Pe Petrus hele pule, “Imo hana nenge Israel, a longo at nga lek helenga. E teke e hele urume Iesus nenge Nasaret lange imo. Imo sipomo a eteia ume papalaungana pe lala mur nenge Iesus poi hote lange imo ke a esesia lo. Nga NeHalang lemene ngana toto, poia ure nemur ke te lohot ke pomalam. Iange i teke heneue imo ke a eteia ke i sipona kulos sue Iesus at. ");
INSERT INTO uvl_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Pe nga NeHalang lemene ngana, tung heke Iesus langa perimo ke pomanga i sipona letena tuanin hot ngana ia nge nike, pe heleia ke teke poia. Ke imo sipomo a hune Iesus nenge a tunge i langa hana poreke ngana mur peria ke te heon heke i ke mete. ");
INSERT INTO uvl_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Pe NeHalang hemaul heke mule Iesus nga metenga. Hile hote i ke mete sapele ero, iange kerkerenga pele nga metenga nakuna ero nge hekou sue Iesus. ");
INSERT INTO uvl_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Non Soke Teuit heleia Iesus ke pomai, “‘Kokoes mana e esesia Non Soke. Pe ute pele ero nge heloiloi ia iau. Iange ana non tu ke rochroi mana nge iau. ");
INSERT INTO uvl_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Ke pomalam letek urana toto pe e hele ke e iech mana. Pe pule singik nei lape tuke angala mana nge NeHalang. ");
INSERT INTO uvl_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Iange NeHalang iong, o hile sio mene iau ke etu nga hana nenge te mete reria kileng ero. Pe lape o hile sio mene lem non nge pengpeng ke ma ke punich nga ich letena ero. ");
INSERT INTO uvl_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Iong, o henonoua iau nga maulinga ana kue lo. Ke lape o poia iau ke etu luluch nge iong pe o poia iau ke e iech toto.’” ");
INSERT INTO uvl_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Iok Petrus hele mule, “Titik mur e teke e hele hot pengpeng lange imo nge rette Teuit. Ana non mete ke tealo hite i lo. Pe ana polo tu luluch nge ita ke at nga etue nenge heueu nei. ");
INSERT INTO uvl_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Pe non soke Teuit nem i hetatalonga. Pe i eteia utar nenge NeHalang heleia ke teke poia. NeHalang talue helenga kerkereng ngana nge teke hemes heke Teuit nette e ke lohot ke i naungaala ana none, ke pomange Non Soke Teuit i sipona. ");
INSERT INTO uvl_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Iok, Non Soke Teuit eteia utar nenge NeHalang teke popoia, pomalam hele urume Mesias nem maul haka mule ngana ke teke, ana non lape tu ke lasus nga hana nenge te mete reria kileng ero. Pe pule lape koluna ma ke punich nga polo letena ero. ");
INSERT INTO uvl_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Ke Ne Iesus nei, ngana kou NeHalang hemaul heke mule i nga metenga lo. Ke imem lochloch ngana nei, Iesus maul haka mule pe at ke lohot nge imem. Ke ngana koi nenge mo hele hotote ure nemur, iange mo esia lo. ");
INSERT INTO uvl_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Ke Ne Iesus nem, ngana kou maul haka mule kela are nga Temene penna tamalmal lo. Pe mene Opepengpeng nga Temene penna lo. Ke pomanga Temene hele talaia lo ke teke tunge lange i. Pe nena tunginga nenge hekulo sue at nge imem, ngana koi nenge a esesia pe a longlonge heueu nei. ");
INSERT INTO uvl_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","“Iange Non Soke Teuit haka langa lut nga tapa ero. Pe Iesus i toro mana haka langa lut nga tapa. Pe Non Soke Teuit hele ke pomai, “‘Non Soke hele lange ak Non Soke ke pomai: “O haka at ke oare lakoi nga ilik ele nenga perik tamalmal. Oare lamai kela het nga etue nenge, ");
INSERT INTO uvl_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","e mene lem ngarang mur, ke e talue iri nga apem sana ene, ke apem ana manga mur ia iri.” ’ ");
INSERT INTO uvl_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Ke imo hana nenge Israel, nenge nei a etei tote ol, iange Iesus nenge a heon heke i nem, NeHalang tal heke tote i ke i soke toto ol. Ke i Mesias nenge mene mule NeHalang nena hana mur nenge hesilei hote iri lo.” ");
INSERT INTO uvl_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Iok laol, Petrus na helenga nemur tua tote hehei pe hana leteria, ol pe hehei pe hana nemur te hele lange Petrus pe pekngana mur ke mai, “Oe atong mur, pe imem lape mopoi ke pomere mai ol?” ");
INSERT INTO uvl_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Pe Petrus hele lange iri ke mai koi, teke, “Imo lochloch ngana nem, imo elle pe elle, a hulia letemo nga lemo poinga poreke ngana mur, pe a mene henuninga nga Iesus Krisus ene. Pomalam lape NeHalang letena ia imo nga lemo poinga poreke ngana mur. Pe lape a mene tunginga nenga Opepengpeng pule nenge NeHalang hekulo sue at nei. ");
INSERT INTO uvl_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","NeHalang talue helenga kerkereng ngana lo, nenge teke tunge Opepengpeng lange imo pe nge tutumo mur pe nge hulua lochloch ngana nenge tetu nga tau. Oe, tunge lange iri nenge i sipona iua iri.” ");
INSERT INTO uvl_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Pe Petrus hele hote helenga e pule lange iri pe hele ke kerkereng toto lange iri ke mai, “Anau ala amo, iange lape melmelenga palaungana nenge NeHalang tunge lange hana poreke ngana mur, lape mene imo pule!” ");
INSERT INTO uvl_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Petrus na helenga tua tote leteria pe hulua halang toto leteria manmanna nga helenga nemur. Ke pomalam te mene henuninga. Ke hehei pe hana iri ana non kina lime iri analoch iri mol (3,000) te lohot ke Iesus nena hana mur nga etue neu pengpeng. ");
INSERT INTO uvl_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Iok, iri lochloch ngana nenge te hulia leteria pe te mene henuninga nem, kokoes mana tela nge Iesus nena hana mur ke te hetottore iri. Pe tetu ngaria pomai, tenau hel mule nge iri ke pomanga iri lochloch titiria mur hel. Te eukirau pe te ngau ke elle pe te eukirau ke te hetalaulau. ");
INSERT INTO uvl_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Pe Iesus nena hana mur tepoi hotote lala mur pe ure papalaungana mur pe hulua te esesia pe te rura toto. Pe haria kangkanga manmana. ");
INSERT INTO uvl_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Ke iri lochloch ngana nenge leteria manmanna nge Iesus tetu manmana ke muria elle, pe te tung helel aria ure. ");
INSERT INTO uvl_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Nenge teke tetu pe mele na ure unne sune mana, te mene reria ure hel langa ingala, nem pe mele hel te olia reria ich unne pe uruna te laia nge mele nem. ");
INSERT INTO uvl_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Kokoes mana tela ke te eukirau nga NeHalang nena pele palaungana. Pe pule tela ke te eukirau ke te ngau nga reria pele mur. Te ngau pe te iech pe te tung helia aria ngaunga. ");
INSERT INTO uvl_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Pe te heto heke NeHalang ene pe te iech toto iange hehei pe hana lochloch nenge Ierusalem, leteria urana mana nge iri. Nga etue lochloch, NeHalang hesilei hotote nena hana mur. Ke nga poinga nem mana, iri nenge NeHalang mene mule iri pe leteria manmanna nge Iesus, te lohot ke iri hulua toto. ");
INSERT INTO uvl_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Nga ulei nga etuene e, Petrus iri nai Ioanes tei teu lala nga NeHalang nena pele palaungana. Tei teu lalamau ke te hetalaulau ke pomanga kokoes te popoia lo. ");
INSERT INTO uvl_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Pe NeHalang nena pele palaungana neu matana, te hetue ke ene Rerere. Pe none nge apena lul nga i kino ngana nike arare lamau. Kokoes mana te takisia i ke te laia nga pele matana neu, ke longlong umtutuna nge hehei pe hana nge tei teu lala nga NeHalang nena pele palaungana neu. ");
INSERT INTO uvl_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Iok, esia Petrus iri nai Ioanes nge tei teu lala, pe long umtutuna lange iri. ");
INSERT INTO uvl_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Ol pe Petrus iri nai Ioanes te nachnei hite i, pe Petrus hele, “Onau at nge imem!” ");
INSERT INTO uvl_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Iok, ana non naula nge iri nai pe teke ma lape te tunge ute lala nge i. ");
INSERT INTO uvl_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Pe Petrus hele mule lange i, “Iau lek umtutuna ero toto koi, nenge lape e tunge lange iong. Pe lek ure nenge e teke e tunge lange iong ngana koi nei; Nga Iesus Kristus nenge Nasaret ene, e hele lange iong ke omes haka pe oi!” ");
INSERT INTO uvl_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","La Petrus rahit heke non neu nga penna tamalmal pe ueiuei mana ana non apena takaha pe mes sapele. ");
INSERT INTO uvl_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Non neu mes nga apena pe tamu haka pe talun ke i rara sapele. Pe i pe Petrus pe Ioanes tei teu la sapele nga NeHalang nena pele palaungana neu letena. Pe non neu ii pe tamtamu pe heto hekeke NeHalang ene. ");
INSERT INTO uvl_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Pe hulua lochloch ngana nga lamau te esia non neu nge ii pe te longe i nge heto hekeke NeHalang, ");
INSERT INTO uvl_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","ol pe te rura toto pe leteria tuanin rara ke te teke, “Utar toto nenge poia non nem ke urana mule?” Iange tenau urume ke i non nenge arare ke long manmana umtutuna nga pele matana nenge Rerere. ");
INSERT INTO uvl_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Iok laol, hulua lochloch ngana te longe ure neu nge lohot pe te song ke tela nga sauach nenge te hetue ke Solomon na Sauach. Tela pe non neu lau hite Petrus pe Ioanes ke temes. ");
INSERT INTO uvl_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Pe Petrus esia hulua lochloch ngana nemur nge te rura ia non neu nge i mule pe hele, “Imo hana nenge Israel, pomere nenge a nachnei sakililia imem ke pomam? Imo a teke lemem kerkerenga palaungana pe imem toto kai, nenge mo poia non nei ke i mule mai? ");
INSERT INTO uvl_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Ra tete mur aria soke NeHalang nenge Apraham pe Isak pe Iakop te heto hekeke, tunge hemalmalinga lange nena hekuleileinga, Iesus lo. I laka nenge a tunge i langa hana nenge Rom peria. Pe Pilatus hele ke teke hottaua ute nge non nem poia ke poreke ero, pomalam teke papa ala ana nga helenga pallaklaka ngana nenge a poia lange i. Pe imo a hulia patangamo lange i pe a toto ita toto lange Pilatus ke a teke, non nei mete. ");
INSERT INTO uvl_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Non nei, NeHalang nena non toto. Ke na poinga pe na ume mur pengpeng mana. Pe imo lememo ero ia i ke a teke lake mete. Pe a hele lange Pilatus ke mene non nenge hunun hana munna. ");
INSERT INTO uvl_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Ke imo a hune non nenge tunge maulinga at nge ita laka. Pe ana non, NeHalang hemaul heke mule i lo. Imem nai mo esia ke ngana koi nenge mo heleia. ");
INSERT INTO uvl_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Ke imem nai letemem manmanna toto nge Iesus. Imo a esia non nenge apena lul nem, i urana mule nga kerkerenga nenga Iesus ene. Ke letemem manmanna ngana nge Iesus laka nenge poia non nem ke urana mule. ");
INSERT INTO uvl_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Pe titik mur, e eteia ke ulolo. Imo ul amo papalauna mur, a poia poinga nei lange Iesus iange a eteia ero. Ke ngana laka nenge lememo ero ia i. ");
INSERT INTO uvl_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Pe e hele lange imo pengpeng, NeHalang hele hote nga hetatalonga mur haria nge nike lo. Nenge hele ke teke, ‘Non Mesias nenge at ke mene mule nena hana mur, lape takisia melmelenga palaungana.’ Ke nga poinga nenge a poia nem, pete tote NeHalang hele ngana. ");
INSERT INTO uvl_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Pomalam apoi ke pomai koi; A hulia letemo nga lemo poinga poreke ngana mur pe a nanasia NeHalang. Pomalam lape NeHalang letena porekeia imo nga lemo poinga poreke ngana mur. ");
INSERT INTO uvl_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Nenge teke apoi ke pomam, lape NeHalang hekulo sue opemo ana ngaunga at nge imo. Ke lape kulosia Mesias nenge i sipona henonou hote lo, ke at mene mule nena hana mur nenge hesilei hote iri lo. Ke Mesias nem laka Iesus i sipona. ");
INSERT INTO uvl_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Pe i lape tunga tapa mukam ke kulele etue nenge NeHalang talue ke teke, poia ure lochloch ngana ke te lohot ke heueu ngana mule. Helenga nem, NeHalang i sipona hele hote nga nena hetatalonga mur haria nge nike. Pe hetatalonga nemur, NeHalang talue iri ke altoto ke te poia ume nem pengpeng. ");
INSERT INTO uvl_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Ke nge nike, Moses hele tote Ne Iesus ke mai, “‘Amo Soke NeHalang lape henonou hote mele e nge imo sipomo, pe talue i ke i hetatalonga ke mange iau. Pe teke hele ke mere lange imo, a longo taua nena helenga mur. ");
INSERT INTO uvl_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Pe mele hel nenge te longo taua hetatalonga nem nena helenga ero, lape tetu teu langa NeHalang nena hana mur ero. Pe lape NeHalang hun sue iri ke tehet.’ ");
INSERT INTO uvl_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","“Pe hetatalonga lochloch ngana nge nike, te hele hote utar nenge te lohotot heueu nei. Talun nge hetatalonga Samuel pe ole lange pekngana nemur nenge te nanasia i. ");
INSERT INTO uvl_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Pe imo lape a mene ure nemur nenge hetatalonga mur te heleia. Pe NeHalang hele hote ure nemur nga etue nenge, i pe lemo tete mur te talue helenga tomunga hel nem. Iange i hele lange Apraham ke pomai, ‘Lape e pete hulua lochloch nga ich, pe petanga nem lape at nge iong sipom alom.’ Nge nike, NeHalang tunge helenga nem lange Apraham, pe heueu nei, petanga nem sio at nge imo ol. ");
INSERT INTO uvl_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Ke pomalam NeHalang henonou hote nena non pe kulosia i ke at tala nge imo ke pete imo pe halaua imo elle pe elle, ke a hile lemo poinga poreke ngana mur.” ");
INSERT INTO uvl_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Iok, Petrus iri nai Ioanes te hele lala nge hehei pe hana kura pe tunginga ana hana mur pe non soke nenge nauelele NeHalang nena pele palaungana ana naungaala mur pe Satiusi mur hel teat ke te puris. ");
INSERT INTO uvl_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Teat pe leteria inin toto iange Petrus iri nai Ioanes te hetottore hehei pe hana nga Iesus nge maul haka mule nga metenga. Ke nem hemallaha hot tote ke, iri nenge te mete lape te maul haka mule. ");
INSERT INTO uvl_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Laol pe hana papalauna nemur te laua Petrus iri nai Ioanes ke te teke te onteia iri nai pe ero. Iange kileng ulei sio lo. Pomalam tetal teua iri langa tuele au ngana. ");
INSERT INTO uvl_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Pe hulua lochloch ngana nenge te longe iri nai reria helenga, leteria manmanna. Ke iri nenge leteria manmanna te lohot ke iri ana non kina lime iri analoch iri lime (5,000). ");
INSERT INTO uvl_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Iok, pomange rou almasinga ana hana mur pe hana nenge iri mukmuka nge Israel mur pe hotonga ana hetoronga mur, teat ke te eukirau nge Ierusalem. ");
INSERT INTO uvl_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Pe tunginga ana hana mur aria non soke, ene Anas. Ke Anas pe Kaepas pe Ioanes pe Aleksanta pe iri hel pule nenge te lohot nga mata nenge tunginga ana hana mur, iri lochloch tela ke te eukirau luluch nge hana nemur. ");
INSERT INTO uvl_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Laol pe te hemesia Petrus iri nai Ioanes nga mataria pe te onteia iri ke pomai, “A poia ure nei ke mere mai? A mene lemo kerkerenga langai nenge a poia ure nei? Pe a poia nga itei ene?” ");
INSERT INTO uvl_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Pe Opepengpeng teu ke muta toto nge Petrus pe tuacholia hana nemur reria helenga ke mai, “Imo almasinga ana hana mur pe imo hana nenge imo mukmuka nge Israel mur: ");
INSERT INTO uvl_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","A onteia imem nga halaunga nenge mo poia nge ape lul nei. Maul ke mere? ");
INSERT INTO uvl_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Imo lochloch pe imo Israel mur a longo ke nek. Non ape lul nei urana mule nga Iesus Kristus nenge Nasaret nena kerkerenga. Pe imo a hune ana non ke mete nga ana manga toto. Pe NeHalang hemaul heke mule i. Pe NeHalang nena helenga hele ia Iesus ke mai: ");
INSERT INTO uvl_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","“‘I laka, i um nenge imo hana nenge a lelele pele lememo ero ia. Pe i, lohot ke i um palaungana nenge rahtua ele pele.’ ");
INSERT INTO uvl_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Maulinga at nge mele ero ol. At mana nga Iesus ene.” ");
INSERT INTO uvl_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Hana papalauna nemur te esia Petrus pe Ioanes pe te rura. Iange iri nai temes ia aria seilil. Pe te eteia iri lo, nge iri hana mana nge ramaria alchach ero. Pomalam te eteia iri nai nge tetu luluch nge Iesus. ");
INSERT INTO uvl_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Pe te esia non ape lul nem nge mes luluch nge iri pe te reng toto ke te hele ia helenga e ero ol. ");
INSERT INTO uvl_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Hana papalauna nemur te kulos hote iri nai pe te hele tele el nge iri, ");
INSERT INTO uvl_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","“Lape ta poia iri nai ke pomere? Hehei pe hana lochloch ngana nge Ierusalem te esia iri nge tepoi hote ure palaungana nem nge hemallaha hote NeHalang na hekerkerenga. Ure nei, ta talkome ero ol i! ");
INSERT INTO uvl_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Teke poi, pe ta hele ke kerkereng lange iri nai ke te heto heke Iesus ene ero ol. Pomalam ure nei het la koloi pe te heloloune ero ol.” ");
INSERT INTO uvl_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Te iua iri nai pe te hele ke kerkereng lange iri nai ke te hetottoro pe te haliu nga Iesus ene ero ol. ");
INSERT INTO uvl_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Pe Petrus iri nai Ioanes te hele, “A mil teu la. Nga NeHalang matana, poinga tei nge urana? Mo longo taua NeHalang ma mo longo taua imo? ");
INSERT INTO uvl_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Imem, ute pele nge ra ele halimem ero ol iange mo longe pe moes tote lo.” ");
INSERT INTO uvl_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Pe hana papalauna nemur te hottaua ute ero toto nge poreke nge iri nai nge tetal teua iri nga tuele au ngana. Pomalam, te keres taua iri pe te kulos hote iri nai ke tela. Iange hulua te esia ure nem nge lohot pe te heto heke NeHalang. ");
INSERT INTO uvl_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Pe non nenge te hemasia i nei ana hesinga ele haka nga ana non kina nai (40). ");
INSERT INTO uvl_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Te kulos hote Petrus iri nai Ioanes ke het pe tela sapele nge pekngaria mur pe te heleia ure lochloch nenge almasinga ana hana mur pe tunginga ana hana mur aria papalauna mur te hele ia lange iri. ");
INSERT INTO uvl_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Iri te longe helenga nemur pe iri lochloch leteria elle pe te hetalaulau lange NeHalang ke pomai, “Non Soke, iong sipom oala hote tapa pe ich pe ruach pe ure lochloch ngana. ");
INSERT INTO uvl_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Nge nike toto, Opepengpeng hele hot nga lem hekuleileinga, lemem te ne Teuit hanna ke pomai: “‘Pomere nge hana lomonmona mur leteria inin hali? Pomere nge tetal hel ia helenga ke te heporeke Non Soke? ");
INSERT INTO uvl_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Kileng mur nga ich aria naungaala mur tetal helenga ke tei ia polong. Hana papalauna mur pule tetal helenga ke te hekou sue Non Soke pe Mesias nenge Non soke tal hote ke mene mule ita.’ ");
INSERT INTO uvl_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Oe Non Soke. Manmanna nge Herot iri nai Pilatus te heua hana lomonmona mur pe Israel mur ke teare nga tuele tana nge Ierusalem. Tetal helenga ke te hekou sue Iesus, lem hekuleileinga nenge otal hote. ");
INSERT INTO uvl_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Iri te poia poinga nem, nanas mene iong lemem ngam. Iange lohot nga lem kerkerenga nike. ");
INSERT INTO uvl_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Iok, Non Soke o nau sio at nge imem, lem hekuleileinga mur ke o halaua imem. Iange hana kai te hemataua imem mai. Ke o halaua imem ke momes ke kerkereng toto ke mo haliu hote lem helenga. ");
INSERT INTO uvl_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Otul hote perim ke mo hemasia haleles mur pe mopoi hote ure papalauna ke hemallaha hote lem kerkerenga. Mo poia ure nemur nga Iesus ene, lem hekuleileinga nenge iong sipom otal hote.” ");
INSERT INTO uvl_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Te hetalaulau ke ulo, pe kileng nenge te hetalaulau ia nem rur. Pe Opepengpeng hemute iri lochloch ke aria seilil ke te hele hote NeHalang na helenga. ");
INSERT INTO uvl_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Iri nenge leteria manmanna, leteria pe ramaria elle mana. E nge iri teke i toro nena ute ero, iange ure lochloch te teke iri lochloch reria. ");
INSERT INTO uvl_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","NeHalang tung sue hekerkerenga palaungana lange Iesus nena hekulkulonga mur ke te haliu hote Iesus maul haka mule ngana. Pe pete tote iri lochloch. ");
INSERT INTO uvl_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Iri lochloch reria ure pe ute e nge alpapa nge iri ero. Iange iri nenge reria ich pe reria pele, te hile hotote ke mele hel te ololia iri. ");
INSERT INTO uvl_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Pe te mene ure nemur ururia pe te tunge lange hekulkulonga nemur. Pe hekulkulonga nemur te heronge lange iri nenge reria ure mur ero. ");
INSERT INTO uvl_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","None nge ene Iosep, tana hoe i nge Saipras. Pe ana mata, Liuai. Pe hekulkulonga nemur te hetue i ke ene Parnapas. (Luna, non nge hekerkereng ia hehei pe hana leteria pe halachlaua iri.) ");
INSERT INTO uvl_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Ana non pule hile hote na ich unne ke mene uruna pe tunge lange hekulkulonga nemur. ");
INSERT INTO uvl_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Iok laol, none nge ene Ananias iri nai nehei Sapaera reria ich unne, mele hel te olia pule. Pe Ananias rahite umtutuna nenge ich neu uruna ele. ");
INSERT INTO uvl_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Nehei pule eteia pe ngata mana. Ol pe Ananias mene umtutuna ele mana, pe laia nge Iesus nena hana mur iange ele kou talkome lo. ");
INSERT INTO uvl_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Pe Petrus hele lange Ananias, “Pomere nenge ongata lange Non Poreke ngana ke o pallakaia Opepengpeng, ke o rahit mule umtutuna ele nga ich uruna nenge o mene nem? ");
INSERT INTO uvl_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Ich nem te olia ero kura pe iong lem nike. Pe te olia ke het pe umtutuna nem, iong lem pengpeng. Pe utar nenge pa heke iong ke o poia poinga nei? Iong o pallaklaka ia none mana ero, o pallakaia NeHalang laka nem.” ");
INSERT INTO uvl_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Ananias longe helenga nem, pe losio pe mete sapele. Pe iri nenge te longe ure nem nge lohot, mataunga palaungana laua iri. ");
INSERT INTO uvl_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Ol pe hana lolomele hel tela ke te ruchite non neu koluna pe te takis hote kela tealo hite. ");
INSERT INTO uvl_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Etue mala pol lo pe Ananias nehei iteu at. Pe i eteia utar nenge lohot tala nga etue neu ero. ");
INSERT INTO uvl_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Ol pe Petrus onteia i, “O hele at nge iau mukam, lemo ich unne nenge te olia lange imo nai, uruna kaloi?” Pe ana hei hele, “Oe, uruna lochloch lakalom.” ");
INSERT INTO uvl_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Ol pe Petrus hele mule lange i, “Pomere nenge imo nai em a ngata hel ke a totoia NeHalang opene ke pomam? Onau la, hana nenge tealo hite em iau temes nga pele matana neu pe lape te takis hote iong la pule!” ");
INSERT INTO uvl_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Nga etue unne neu pengpeng, hei neu losio pe mete sapele. Pe hana lolomele tei teu at pe ana hei mete lo, pomalam te takis hote kela tealo hite i nga ene rikena. ");
INSERT INTO uvl_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Ol pe iri lochloch ngana nenge leteria manmanna nge Iesus, pe iri hel pule nenge te longe ure nemur nge te lohotot, iri te matau toto ol. ");
INSERT INTO uvl_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Iesus nena hekulkulonga mur tepoi hote ure papalaungana halang ke hulua lochloch te esia. Pe iri nenge leteria manmanna, te lala ke te eukiraurau nga Solomon Nena Sauach. ");
INSERT INTO uvl_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Pe iri nenge te tu nge hot, leteria urana mana nge iri pe teteu pulut mana pe teare luluch nge iri ero. ");
INSERT INTO uvl_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Pe hulua halang toto, leteria manmanna nge Iesus pe teteu kela te koko teu nge Iesus nena hana mur. ");
INSERT INTO uvl_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Ol pe hehei pe hana tela ke te takis hote iri nenge singiria haleles ke teat ke te emara sue iri nga hete mur nga kue ilina. Pomalam, Petrus itoto pe opene ma hite iri pe temaul. ");
INSERT INTO uvl_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Pe hulua lochlolch ngana nga kileng nemur nenge tetu rochroi nge Ierusalem, te longe pe iri pule te takis hote haleles kina mur pe iri nenge uneinei poia iri. Te atia iri pe Iesus nena hana mur te hemas mule iri lochloch. ");
INSERT INTO uvl_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Ol pe tunginga ana hana mur aria soke pe pekngana mur nenge iri Satiusi, te esia ure nemur nenge Iesus nena hana mur te poia pe saria keke iri. ");
INSERT INTO uvl_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Pomalam te lohaka pe telaua Petrus iri nai Ioanes pe tetal teua iri langa tuele au ngana, kela tetu luluch nge hana porekreke ngana mur. ");
INSERT INTO uvl_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Pe nga miliko NeHalang nena angkelo e loe tuele au ngana neu matana pe mene hote Petrus iri nai Ioanes pe hele lange iri ke mai, ");
INSERT INTO uvl_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Ala ke a mes nga NeHalang nena pele palaungana letena pe a hemallaha hote helenga lange hehei pe hana ke nek nga tunga heueu ngana nei.” ");
INSERT INTO uvl_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Iok laol, uach sio pe iri nai teteu la sapele nga NeHalang nena pele palaungana pe te talun ke te hetottore hehei pe hana ke pomanga NeHalang nena angkelo neu heleia lo. Pe Anas iriul pekngana mur te iua hana papalauna nenge Israel te eukirau. Pe te hekulo helenga langa tuele au ngana ke te mene Petrus iri nai Ioanes at. ");
INSERT INTO uvl_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Iok palpal hussu mur tela ke te lohot nga tuele au ngana pe Iesus nena hana nai neu iri ero lo. Ol pe tela mule pe te hele lange hana papalauna nemur ke mai, ");
INSERT INTO uvl_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Mola ke mo lohot lamau pe mo esia piunga lochloch ngana nga tuele chantom ngana neu, aria chaunga tetu ke tekerkereng. Pe naualanga nemur nenge te umume lamau, temes ke te ronge piunga lochloch. Iok, mo lohe piunga e ke moi teu la, pe hana nemur iri ero.” ");
INSERT INTO uvl_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Nga etue nem, hana papalauna mur pe non soke nenge nauelele palpal hussu mur nga NeHalang nena pele pe tunginga ana hana mur aria papalauna mur te longe ke mau, pe ngaria lohot pe leteria tuanin rara ke te teke, hana pane tela ke merei? ");
INSERT INTO uvl_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Ol pe none at pe hele, “A nau at, hana nenge atal teua iri langa tuele au ngana nem, ngaria kou te hetottore hehei pe hana nga NeHalang nena pele palaungana letena.” ");
INSERT INTO uvl_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Ol pe palpal hussu mur iriul aria soke, tela ke te mene iri pe te mene iri ke nek mana pe te poia ute hel lange iri ero, iange te mataua hulua lochloch ngana nemur nge lape telope aria um. ");
INSERT INTO uvl_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Iok laol, palpal hussu nemur te mene iri ke tela te hemesia iri nga hana nenge te longlongo helenga mataria. Pe Anas lohaka pe hele, ");
INSERT INTO uvl_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Imem moheo ele tote imo nge a hetore hehei pe hana nga non nem ene. Pe ero. Imo a hetottoro pe kura, ke hehei pe hana nga kileng lochloch ngana nge Ierusalem te longe lemo helenga mur lo. Pe pule, imo a tue helenga at nge imem ke a teke mo hune non nem ke mete.” ");
INSERT INTO uvl_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Pe Petrus iri ul Iesus nena hekulkulonga mur te tuacholia hana nemur reria helenga ke mai, “Imem mo nanas tau pulut mene hana pele hel nga ich nei reria helenga ero. Mo nanas mene NeHalang na helenga mur!” ");
INSERT INTO uvl_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Imo a heon heke Iesus nga manga toto, ke nga poinga nem, a hune i ke mete. Pe ratete mur aria Soke NeHalang hemaul heke mule i nga metenga lo. ");
INSERT INTO uvl_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Pe mene heke i kela hetakile nga ilina nga penna tamalmal. Nga lamau Iesus lohot ke i naungaala ana non pe hemasinga ana non. Iange NeHalang teke Israel mur te hulia leteria pe te mene maulinga ke koko. ");
INSERT INTO uvl_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Imem mo esia utar nenge NeHalang poia lo. Pe imem toro ero. Imem ul Opepengpeng. I laka, NeHalang nena tunginga nenge tunge lange iri nenge te longo taua i. ");
INSERT INTO uvl_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Iri hana papalauna nemur nge Israel, te longe ke mau pe leteria inin toto nenge te teke te hune Iesus nena hana mur ke te mete. ");
INSERT INTO uvl_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Pe ero, Non Paresio e nge ene Kamaliel mes haka nga hana papalauna nemur leteria pe hele ke teke, te mene hote Iesus nena hana mur kela temes pol nge hot mukam. Ana non i hotonga ana hetoronga ke hulua lochloch ngana tepoi ke nek lala nge i. ");
INSERT INTO uvl_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Pe hele lange hana papalauna nemur ke mai, “Imo hana nenge Israel, anau ke nek toto nga utar nenge a teke a popoia lala nge hana nemur. ");
INSERT INTO uvl_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","A eteia, nga lia manmana none nge ene Tiutas lohot pe teke i non palaungana pe na kerkerenga halang. Pe hana iri ana non kina iri ana non kina elle (400) leteria manmanna nge i pe te nanasia i. Pe nga etue nenge te hune i ke mete, nena hana mur te ua parai pe tepoi hote ume pele ero. ");
INSERT INTO uvl_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Iok, nga hoena Iutas nenge na nge Kalelea lohaka. Lohaka nga etue nenga sisalanga nge hehei pe hana lohot, ke tehas susue eria. Ana non teu nga hulua leteria ke te nanasia i ke tepoi heke hunelinga, iange lemeria ero ure neu nge lohot. Iok te hune i ke mete pe iri lochloch ngana nenge te nanasia i nem te ua parai pule. ");
INSERT INTO uvl_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Pe nga ure nenge lohot heueu nei, e hele lange imo pengpeng, a poia ute lange hana nemur ero toto. A hile hote iri ke tela! Iange nenge teke ure nenge te popoia nei, iri siporia tepoi heke mene, lape ure nem sisparai sio mule. ");
INSERT INTO uvl_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Pe nenge teke NeHalang i sipona poi heke, imo nakumo ero toto nge apoi ele iri. Nenge teke apoi poreke iri heueu, apoi poreke NeHalang ke ulolo!” Laol pe hana papalauna nemur te nanas mene Kamaliel nena helenga. ");
INSERT INTO uvl_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Iok, teiu teu mule Iesus na hekulkulonga nemur at pe te palia iri. Te palia iri ke het pe te hele ke kerkereng toto mule lange iri ke te hetore hehei pe hana nga Iesus ene ero ol. Ke het pe te kulos hote iri ke tela sapele. ");
INSERT INTO uvl_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Iok laol, hekulkulonga nemur te hile sue hana papalauna nemur ke tela ol pe te iech toto iange NeHalang teke nakuria nge te mene meinga palaungana toto nga Iesus ene. ");
INSERT INTO uvl_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Pe kokoes mana nga etue lochloch tela ke te haliu hotote NeHalang nena helenga urana toto ngana lala nge hehei pe hana nge reria pele mur, pe pule nga NeHalang nena pele palaungana letena. Te haliu hote helenga urana toto ngana nenge Iesus i sipona i Mesias, nenge NeHalang kulosia ke at mene mule hehei pe hana nenge NeHalang hesilei hote iri lo. ");
INSERT INTO uvl_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Iok nga etue nemur iri nenge leteria manmanna nge Iesus te lohot ke iri halang toto. Ol pe ngunngunuga e lohaka nge Iuta mur nenge te helelia helenga Krik iri ul Iuta mur nenge iri Iuta pengpeng. Pe ngunngununga nem, huna nga ngaunga nenge te heronge ke kokoes lange pakar mur nga etue elle pe elle. Iange hei pakar mur nenge Krik nem, te menmene aria ngaunga ke nek ero. Pomalam te ngungu nge iri nemur nenge Iuta pengpeng. ");
INSERT INTO uvl_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Ol pe Iesus nena hana iri analoch pe nai nem te eukiraua iri lochloch nenge leteria manmanna nge Iesus pe te hele lange iri ke pomai, “Nenge teke mo hilesue ume nenge mo hetottore hehei pe hana nga NeHalang nena helenga pela mo herongo mulmule amo ngaunga, panem urana ero. ");
INSERT INTO uvl_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Ke pomalam, kole mur, imo sipomo a hesilei hot ke hana iri rahtele nai nge imo mule, ke tenau ele ume nem. A henonou hote mele hel nge Opepengpeng muta nge iri, pe leteria pe reria poinga mur urana mana. ");
INSERT INTO uvl_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Pe imem, lape motu pengpeng nga ume nenge mo hetalaulau pe mo hetottore hehei pe hana nga NeHalang nena helenga mur.” ");
INSERT INTO uvl_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Iok laol, iri lochloch lemeria ke te teke tepoi ke pomanga Iesus nena hana mur te hele ngaria. Pomalam te henonou hote Stipen, non nenge letena manmanna ngana tuke kerkereng toto, pe Opepengpeng muta nge i. Pe pule Pililpus pe Prokorus pe Nikanor pe Timon pe Parmenas pe Nikolaus. Nikolaus i nena nge Antiok pe i koko teu luluch nge Iuta mur nge leteria manmanna nge NeHalang. ");
INSERT INTO uvl_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Iok, te mene hana nemur ke te laia iri nge Iesus nena hana mur ke tetal heke peria nge iri pe te hetalaulau haka nge iri. ");
INSERT INTO uvl_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Pe NeHalang nena helenga song ke ronge kileng lochloch ngana. Pe hehei pe hana halang nge Ierusalem te lohot ke Iesus nena hana mur ia iri. Pe tunginga ana hana mur halang, leteria manmanna nga NeHalang nena helenga pule pe te nanasia. ");
INSERT INTO uvl_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Iok, Stipen i non nenge NeHalang pete tote i, pe tunge na kerkerenga palaungana nenge poi hote ure papalaungana hel nga hulua leteria ke te esesia. ");
INSERT INTO uvl_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Ol pe hana hel teat ke iriul Stipen tetak huluelia helenga. Pe hana nemur ria hetoronga ana pele e nge te hetue ke ene, hana nenge iri siporia tenau ele iri. Pe hana nemur reria nge Sirini pe Aleksantria, pe pekngaria hel pule teat nga ich nenge Silisia pe Eisia. ");
INSERT INTO uvl_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Pe Opepengpeng helete matana tote Stipen ke hana nemur nakuria ero nge te hekou sue Stipen nga helenga. ");
INSERT INTO uvl_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Ol pe la teol hite hana hel, nenge te pallaklaka ke te teke, “Mo longe Stipen nge hele poreke tote NeHalang iri nai Moses.” ");
INSERT INTO uvl_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Ke nga poinga nei te hesosolos heke tote hehei pe hana pe hana papalauna pe hotonga ana hetoronga mur leteria ke telaua Stipen. Pe la te hemesia nga hana papalauna nenge te longlongo helenga mataria nga NeHalang nena pele palaungana letena. ");
INSERT INTO uvl_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Pe te mene teua hana hel pule kela te channanga ke te teke, “Non nei, kokoes mana, hele poreke NeHalang na pele pe Moses nena hotonga mur. ");
INSERT INTO uvl_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Pe pule, mo longe i nge hele ke teke, Iesus nenge Nasaret nem lape toto sue NeHalang nena pele palaungana nei, pe hetaua rera poinga mur nenge rette Moses tung sue at nge ita nge nike.” ");
INSERT INTO uvl_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Ol pe hana papalauna nemur te nachnei hit tote Stipen, pe te esia Stipen nge nakuna pomalaka nga NeHalang nena angkelo toto. ");
INSERT INTO uvl_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Iok, non soke nenga tunginga ana hana mur, onteia Stipen ke teke, “Ure nemur nenge hana nei te hele hotote atat nge imem nemai, manmanna kai?” ");
INSERT INTO uvl_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Pe Stipen tuacholia lange hana papalauna nemur ke mai, “Titik mur pe temek mur, a longo at nge iau mukam! Nge nike, rette Apraham tu nge Haran ero kura pe NeHalang Non Palaungana nenge nena hemalmalinga nenge sina ala toto, lohot nge i nga tuele tana nge Mesapotamia. ");
INSERT INTO uvl_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Pe hele lange i ke teke, ‘O hile sue lem kileng pe lem hana mur pe ola ke otu nga ich nge lape e henonoua lange iong.’ ");
INSERT INTO uvl_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","“Pomalam Apraham lohaka nga na kileng huna nge Saltea pe la ke tu nge Haran. Iok, Apraham temene mete ke het pe NeHalang kulosia i ke at nga ich nenge a tutuia nei. ");
INSERT INTO uvl_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","NeHalang tunge ich unne lange Apraham ero toto. Pe NeHalang hele ke manmanna toto ke teke tunge ich neu lange Apraham pe na tete mur ke rea ich. NeHalang hele hote helenga kerkereng ngana nem pe Apraham hoe tutuna mur hel ero kura. ");
INSERT INTO uvl_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Ke NeHalang hele lange Apraham ke mai koi, ‘Iong lem tete mur lape tetu nga kileng tau ngana e nga ich nenge iri siporia reria ia ero. Pe lape tetu ke te hekuleilei menmene iri nga kileng nem. Pe hana nga kileng nem, lape tepoi poreke tote iri ke hesinga iri ana non kina iri ana non kina elle. (400) ");
INSERT INTO uvl_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Pe lape e poia ure meena ngana ke lohot nge hana nenge lemtete mur te umume nge iri nem. Pe lape nga hoena lem tete mur te ua hot nga kileng neu pe teat ke te heto heke iau nga kileng nei.’ ");
INSERT INTO uvl_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Ol pe NeHalang hele lange Apraham ke terir us. Ke nga poinga nenge terir us, poinga nem helete metene iri nga NeHalang nena helenga tomunga hel nenge heleia lange Apraham. Ke Apraham i Isak temene. Pe Isak, tana hoe i ke ana etue iri rahtele mol, pe temene Apraham rir us sapele. Pe nga hoena Isak lohot ke i Iakop temene. Pe Iakop hoe ra tete mur ke hana analoch pe nai nem. ");
INSERT INTO uvl_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Pe Iakop tutuna nemur saria keke tiria Iosep pe te mene i lange hana lomonmona ngana mur ke te olia i pe te mene sapele i ke lange Ekipto. Pe NeHalang tu luluch toto nge Iosep. ");
INSERT INTO uvl_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Ke nauele tote i nga ure meena ngana mur nenge lohotot nge i. Pe pule tunge letematana ngana palaungana toto lange i. Ke nem poia Parao, non soke nenge Ekipto, ke lemene tau tote i. Pomalam Parao talue Iosep ke nauele kileng nenge Ekipto, pe pule nauele ure lochloch ngana nenga Parao na pele. ");
INSERT INTO uvl_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","“Laol pe uringa palaungana lohot sapele nga kileng lochloch ngana nenge Ekipto. Pe nge Kanan, rera tete nemur te uri. ");
INSERT INTO uvl_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Ol pe Iakop longe nge te teke ngaunga kou nge Ekipto. Pomalam kulosia tutuna mur ke tela. ");
INSERT INTO uvl_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Iok, tela mule henai ngana pe Iosep hemallaha hote i lange titina mur pe Parao eteia ke Iosep titina mur teat. ");
INSERT INTO uvl_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Ke het pe, Iosep hekulo lange temene Iakop pe hele lange i ke teke, iri lochloch te lohaka pe tela nge Ekipto. Pe iri lochloch ngana nenge tetu lamau iri ana non kina iri mol pe analoch pe lime (75). ");
INSERT INTO uvl_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Iok laol, Iakop sio la sapele nge Ekipto. Pe nge Ekipto i pe ra tete hana nemur te mete. ");
INSERT INTO uvl_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Pe te takis mule koluria kela tealo hite iri nge Sekem, nga metenga ana polo nenge Apraham olia nga umtutuna lange hana nenge te lohot nga mata nenge iri Hamor. ");
INSERT INTO uvl_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Iok, etue at rochroi lo, nenge lape NeHalang nena helenga utona nenge heleia lange Apraham lape lohot ke manmanna. Pe Israel mur nenge tetu nge Ekipto neu iri hulua toto ol. ");
INSERT INTO uvl_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Iok, none nge altoto ol lohot ke i naungaala ana non nge Ekipto. Pe i eteia Iosep ero iange Iosep mete ke mala lo. ");
INSERT INTO uvl_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Pe ana non pallakaia rera tete hana nemur ke poia poinga poreke toto ngana lange iri. Poia iri ke tesau hote tuturia mur nenge kinkino ke te mete. ");
INSERT INTO uvl_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","“Pe nga etue nenge Moses tana hoe i, NeHalang lemene tau tote Moses. Pe tenau ele i nga temene na pele ke teio iri mol. ");
INSERT INTO uvl_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Pe nga etue nenge tesau hote i, naungaala ana non nem tuna hei ngana mene i pe nauele i ke pomanga tuna toto. Pe nauele i kela i soke. ");
INSERT INTO uvl_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Iok laol, Moses hele ngana pe ana ume mur lohot ke urana toto, iange mene tote hengetoro nenge Ekipto mur ke nek toto. ");
INSERT INTO uvl_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Iok nga etue nenge Moses ana hesinga iri ana non kina iri nai, (40) teke irara kela nau toto pekngana Israel mur. ");
INSERT INTO uvl_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Ol pe esia non Ekipto e nge poi poreke tote non Israel e. Pomalam Moses halaua non Israel neu ke hune non Ekipto neu. ");
INSERT INTO uvl_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Pe Moses teke ma hana nenge Israel te eteia ke, i sipona nge NeHalang talue i ke halaua iri ke mene hote iri nge Ekipto. Pe ero! Leteria mallaha ero toto! ");
INSERT INTO uvl_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Iok poma ngerou, Moses esia hana Israel nai nge tepal helel. Ol pe Moses lake poi hele iri pe hele lange iri ke mai, ‘Imo nai nem! Imo elle mana iam, iange lemo nge Israel. Pe pomere apal hel mule nge imo?’ ");
INSERT INTO uvl_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","“Pe non nenge teke palia neingana neu hepuo sose Moses pe hele, ‘Itei panenge talue iong ke emem soke iong pe o nauele imem pamam? ");
INSERT INTO uvl_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","O teke o hune iau ke pomanga non Ekipto nenge o hune nge lona ma?’ ");
INSERT INTO uvl_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Moses longe helenga neu pe ua sapelpele kela tu nga Mitian mur reria ich pe lei ke tutuna mur nai. ");
INSERT INTO uvl_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Iok, hesinga iri ana non kina nai (40) het, pe NeHalang nena angkelo e lohot nge Moses nga ich sana lomona e nge rochroi langa hengene nenge Sinai. Angkelo neu lohot nge Moses ke manga oan remenmen ngana nge ngau lalala nga ae tana sune nge mes. ");
INSERT INTO uvl_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Moses esia ke mau pe letena tuanin rara ia ke halang pe teke nau ke nek toto. Iok, la rochroi toto ke teke nau ke nek pe longe Non Soke nge hele lange i ke teke, ");
INSERT INTO uvl_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Iau NeHalang, lem tete mur aria Non Soke. Lem tete mur Apraham pe Isak pe Iakop, te heto hekeke iau.’ Moses longe ke mau ol pe loiloi pe matau toto ke naula mule ero ol. ");
INSERT INTO uvl_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","“Pe Non Soke NeHalang hele lange i, ‘Opoi hote ae ulina nenga apem, iange ich unne nenge o mesia nem, heo ngana toto. ");
INSERT INTO uvl_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","E esia poinga poreke ngana nenge te poia lange lek hana mur nge Ekipto ke ulolo. Pe e longe iri nge te tangtang ke ngana koi nenge esio at ke e teke e mene mule iri nga hana nenge Ekipto peria. Pomalam, oat nge iau ol pe lape e kulosia iong ke ola mule nge Ekipto.’ ");
INSERT INTO uvl_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Pe Moses nei, i sipona laka nenge Israel mur lemeria ero ia i, pe te hele lange i ke te teke, ‘Itei panenge talue iong ke emem Soke iong pe o nauele imem pamam?’ Ke ana non i sipona koloi nenge NeHalang kulosia na angkelo ke hele lala nge i nga oan sapelala ngana nei. Nenge hele lange i ke teke, la mule nge Ekipto ke mukaia Israel mur ke te ua toto nga kileng nem. ");
INSERT INTO uvl_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Iok, Moses mene hote Israel mur nge Ekipto. Pe nge Ekipto, NeHalang hekerkereng ia i ke poi hote merakulo mur. Pe poia hel pule nenge tei tele nga ruach nenge ene Ruach Remenmen. Pe pule nga ich sana lomona nge teii ia ke hesinga iri ana non kina nai (40). ");
INSERT INTO uvl_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","“Pe Moses nei, i sipona laka hele ke teke, ‘NeHalang lape kulosia hetatalonga e nge mange iau ke lape at. Pe hetatalonga nem, i mele e nge imo pengpeng.’ ");
INSERT INTO uvl_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Pe ana Moses laka nenge tu luluch nge rera tete mur nga ich sana lomona, pe NeHalang nena angkelo hele lala nge i, nga hengene nenge Sinai. Pe i nge mene NeHalang nena helenga urana toto ngana nenge maulinga ana pe tunge at nge ita. ");
INSERT INTO uvl_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Pe ero! Ratete mur lemeria ero nge te longo lange i. Te hile hote i iange lemeria toto nge tela mule nge Ekipto. ");
INSERT INTO uvl_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Ke pomalam te hele lange Aron ke te teke, ‘O ume hote ara ae tapuna e ke imuka nge ita ol. Iange Moses nenge mene hote ita nge Ekipto koi, ta eteia la ngana ero ol!’ ");
INSERT INTO uvl_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Ke nga etue neu, te les hote ae tapuna e nge nakuna pomalaka nga pulumakau tuna. Pe te tunge reria tunginga mur pe te heto hekeke aria soke ae tapuna nenge iri siporia te ume hote nga peria. ");
INSERT INTO uvl_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Pomalam, NeHalang hul patangana lange iri pe iri te heto heke itoch mur, pe teio pe chaia nga tapa sana. Pe poinga nenge te poia nem, pete tote hetatalonga mur tehas ngaria nenge te teke: “‘Imo hana nenge Israel! Hesinga iri ana non kina nai (40) nenge atu manaia nga ich sana lomona nem, a hunune pulumakau pe sipsip mur, ke a teke lemo tunginga mur nenge at nge iau. Pe tunginga nemur, at nge iau ero toto. ");
INSERT INTO uvl_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Amo soke Molek, nenge imo sipomo aume hote, laka nena pelpele ana as palaungana nenge a takis rerere nem. Pe itoch Repan opene laka nenge a takis rerere nem pule, amo soke itoch nenge a heto hekeke. Imo, a heto hekeke ae tapuna nemur nenge imo sipomo ales hote iri. Ke pomalam, lape e kulos hote imo ke a ume ke a amnei amo nga kileng tau ngana e. Ana kileng, lape ai ke a hile kileng Papilon pe ala toto.’ ");
INSERT INTO uvl_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Iok, nga etue nenge ratete mur tetu nga ich sana lomona, te umeia NeHalang nena pelpele ke nanas tau pengpeng ia opene nenge NeHalang henonoua lange Moses. ");
INSERT INTO uvl_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Iok, ita ratete mur te mene loloune pelpele nem nge tetemeria mur, pe Iosua i muka nge iri kela te mene ich. Ich neu, hana lomonmona ngana mur te tuia mukam. Pe nga etue nenge ratete mur iriul Iosua tela, NeHalang helope hote hana lomonmona ngana nemur pe iri te mene ich nem sapele. Pe te hemes heke mule pelpele nem nga ich neu, pe tu ke mala toto ke langa Teuit ana etue. ");
INSERT INTO uvl_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Pe NeHalang poi ke urana toto lange Teuit. Pe Teuit hetalaulau lange NeHalang pe hele ke teke lape umeia Iakop ana soke NeHalang na pele urana toto ngana e. ");
INSERT INTO uvl_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Pe ero. Nga hoena toto ol, Solomon hemes heke NeHalang nena pele palaungana nem. ");
INSERT INTO uvl_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“Pe NeHalang Nge I Soke Nga Lut Toto, tu teu nga pele nenge hana te umeia nga peria ero. Ke pomanga hetatalonga hele ngana nge hele ke teke, ");
INSERT INTO uvl_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","“‘Non Soke NeHalang hele ke teke, Mullik nenge eare pe enau ele kileng lochloch ngana nga ich, ngana kou tu nga lut nga tapa. Pe ich nei apek munna nge etal hekeke ia. Ke imo mam a teke a umeia lek pele e nge mere? Pe lape kileng unne nenge lape e arare ia, tu langai? ");
INSERT INTO uvl_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Pe iau ma nenge e ume hote ure lochloch ngana nemur mam.’” ");
INSERT INTO uvl_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Iok, Stipen hele lange hana papalauna nemur ke mai, “Imo hana nemur, a longo ole tototo iam! Letemo pe ramamo hit toto ke pomange hana nenge lemeria ero toto NeHalang. Pe talngamo nemur, tehit toto nge te longe NeHalang nena helenga mur! Apoi ke pomalaka nge lemo tete mur toto, ke lememo ero toto nge a longlonge Opepengpeng nena helenga mur. ");
INSERT INTO uvl_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Nge nike, NeHalang nena hetatalonga mur te haliu ke te teke, lape NeHalang i sipona nena none nge pengpeng toto lape at. Pe imo lemo tete mur te hun lapue hetatalonga nemur. Pe heueu nei, imo sipona a tunge NeHalang nena non nenge hetatalonga mur te helele ia nem, ke langa hana porekreke ngana mur peria, ke te hune i ke mete lo. ");
INSERT INTO uvl_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Imo sipomo a mene NeHalang nena hotonga mur nga NeHalang nena hekulkulonga mur peria. Pe pomere nenge a nanasia ero?” ");
INSERT INTO uvl_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Iok laol, Stipen na helenga nemur poia hana papalauna nemur ke leteria inin toto, pe te hala hit ngingiria nenge lape te hun tote i ol. ");
INSERT INTO uvl_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Pe Opepengpeng teu ke muta toto nge Stipen, pe nau haka langa lut nga tapa, pe esia NeHalang na hemalmalinga nge tualeme ke palaungana toto, pe esia Iesus nge mes nga NeHalang ilina ele nenge tamalmal. ");
INSERT INTO uvl_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Ol pe Stipen hele, “A longo at, e esia kue matana nenge langa lut nga tapa pau kou tu pa neu. Pe Non Tuna pule, ngana pau kou mes nga NeHalang ilina ele nenge tamalmal.” ");
INSERT INTO uvl_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Hana papalauna nemur te longe Stipen nge hele ke mau, pe te alngaria haka ke soke toto. Pe tepoi ele talngaria nga peria mur pe te song ke te latau pengpengia Stipen ke te laua i. ");
INSERT INTO uvl_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Ol pe teole hote i langa kileng neu ana mapuo patangana, pe te talun ke te tamal sapelpele ana um. Pe iri hana nenge tetua tettele Stipen nga helenga mur, tepoi hote reria hengeron sasase ngana mur, pela tetal sue nga kol kulpo e apena huna ke nauele iri. Ana non ene laka Sol. ");
INSERT INTO uvl_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Iok, hana nemur te tamalmalia Stipen pe i hetalaulau ke mai, “Non Soke Iesus, o mene heke opek lange iong.” ");
INSERT INTO uvl_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Ke het pe tualou sio pe alngana haka ke soke toto ke mai, “Non Soke o tuacholia poinga poreke ngana nei lange iri ero!” Stipen hele ke mau ke het pe mete sapele. ");
INSERT INTO uvl_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Pe Sol esia poinga nenge hana nemur te tamal hune Stipen ke mete, pe teke pengpeng toto nga matana. Iok, nga etue nenge te hune Stipen ke mete, te talun sapele ke heporeke tote NeHalang nena hana mur lochloch nge Ierusalem. Ol pe hehei pe hana lochloch ngana nenge leteria manmanna nge Iesus, te ua parai ke tela nga kileng mur nge Iutea pe nge Samaria. Pe Iesus na hekulkulonga nemur mana tetu ol. ");
INSERT INTO uvl_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Pe atong hana hel nge te nanas tau totote NeHalang lemene ngana, tela ke tealo hite Stipen koluna, pe te tangia i ke halang. ");
INSERT INTO uvl_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Pe Sol poi poreke tote NeHalang nena hehei pe hana mur. Ana non iteu nga pele elle pe elle ke takrung hote hehei pe hana, pe la tal teua iri nga tuele au ngana. ");
INSERT INTO uvl_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Iok, iri nenge te ua parai neu, te haliu hote NeHalang nena helenga mur nga kileng nemur nenge te tuia. ");
INSERT INTO uvl_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Iok, Pilipus langa kileng e nge Samaria pe haliu hote Iesus nge i Kristus. ");
INSERT INTO uvl_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Hulua halang toto te longo ke nek toto nga Pilipus nena helenga mur. Te longe i nge helele pe te esia merakulo mur nge Pilipus poi hotote iri. ");
INSERT INTO uvl_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Pilipus poia uneinei halang ke te alngaria haka ke soke toto, pe te iuch hot nge hulua halang ke tela. Pe iri nenge aperia ele mete pe aperia lul te urana mule. ");
INSERT INTO uvl_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Ol pe iechinga palaungana toto lohot nga kileng neu. ");
INSERT INTO uvl_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Pe none nge ene Simon tu nga kileng neu. Ana non popoi ure paluna pe herura ia hehei pe hana pe heto heke tote i ke teke i non palaungana. ");
INSERT INTO uvl_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Pe hana papalauna pe hehei pe aina kinkino ngana mur te longo ke nek toto langa ana non nena helenga mur, pe leteria manmanna nge i. Ol pe te hele, “NeHalang nena kerkerenga palaungana toto koi tunge non nei.” ");
INSERT INTO uvl_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Hehei pe hana te kerkereng toto ke te nanasia i, iange kokoes mana popoia nena ure paluna nemur pe hulua ramaria song raraia ke halang. ");
INSERT INTO uvl_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Iok laol, Pilipus at pe haliu hote helenga urana toto ngana nenge Iesus Kristus pe NeHalang nena naualanga pe nekinga. Haliu hote pe hehei pe hana lochloch leteria manmanna pe te henun sapele iri. ");
INSERT INTO uvl_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Pe Simon neu pule, letena manmanna nga helenga nemur pe mene henuninga pule. Ol pe koko manmana nge Pilipus ol. Pe esia merakulo halang, pe ure papalauna hel pule nge Pilipus popoia pe letena tuanin rara ke halang. ");
INSERT INTO uvl_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Iok, Iesus nena hana mur nenge tetu nge Ierusalem, te longo nge iri nenge Samaria te mene NeHalang nena helenga lo. Pomalam te kulosia Petrus iri nai Ioanes lange iri. ");
INSERT INTO uvl_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Iok, iri nai tela ke te lohot pe, te hetalaulau lange NeHalang ke hekulo sue Opepengpeng lange Samaria mur. ");
INSERT INTO uvl_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Iange iri te mene Opepengpeng ero kura. Te mene mene henuninga nem nga Non Soke Iesus ene. ");
INSERT INTO uvl_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Iok, Petrus iri nai Ioanes te hetalaulau ke het pe tetal heke peria nge iri ke te mene Opepengpeng. ");
INSERT INTO uvl_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Ol pe Simon esia hana nemur nge te mene Opepengpeng, nga etue nenge Petrus iri nai Ioanes tetal heke peria nge iri. Pomalam, mene umtutuna pe tunge lange Petrus iri nai Ioanes ");
INSERT INTO uvl_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","pe hele, “Imo nai a tunge kerkerenga nem at nge iau pule. Ke nenge teke etal heke perik nge mele, mele nem mene Opepengpeng pule.” ");
INSERT INTO uvl_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Pe Petrus lohaka pe hele, “Iong lape ola ke ohet luluch nga lem umtutuna nem nga oan remenmen ngana. Mele pele olia tunginga nenge at nge NeHalang nga umtutuna ero! ");
INSERT INTO uvl_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Pe iong, lem unne ero toto pule nge o hele teu ia at nga ume nei. Iange iong, letem ma ke pengpeng nga NeHalang matana ero toto. ");
INSERT INTO uvl_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","O hulia letem nga lem poinga poreke ngana nemur pe o hetalaulau lange Non Soke ke letena porekeia iong nge letem tu mana nga poinga poreke ngana nemur. ");
INSERT INTO uvl_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","E hele ke mai lange iong iange onau lele tote NeHalang nena tunginga nei. Ke nga letem toto, o teke opoi ke mange imem. Pe poinga poreke ngana lau hit tote iong laka nga onau lele ngam nem.” ");
INSERT INTO uvl_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Ol pe Simon tuacholia Petrus ke mai, “Imo nai a hetalau ak lange Non Soke ke ure e nge pomanga imo nai a heleia nem, lohot nge iau ero.” ");
INSERT INTO uvl_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Iok, Petrus iri nai Ioanes te haliu hote Non Soke nena helenga pe te hele lange hehei pe hana nga ure nemur nenge Non Soke poia lange iri ke ulolo. Ke het pe iri nai tela mule nge Ierusalem. Pe nga tela mule ngaria, te haliu hote helenga urana ngana nga kileng kinkino ngana halang nge Samaria. ");
INSERT INTO uvl_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Ol pe Non Soke na angkelo e hele lange Pilipus ke teke, “O lohaka pe oi ke ramam sio langa kue nenge song nge Ierusalem kela nge Kasa.” Kue nei, nga etue nei, tei ia ero ol. ");
INSERT INTO uvl_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Laol pe Pilipus lohaka pe i kela sapele. Pe nga kue neu, saolia non soke e nge nauelele hei soke Kantasi nena umtutuna mur. Pe hei soke nem nauele kileng nenge Itiopia. Pe nena non soke neu, lange Ierusalem ke heto hekeke NeHalang. ");
INSERT INTO uvl_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","La ol, ana non teke la mulmule lo. Pe are teu nga arenga e nenge oriong mur te takrungrunge pe sis olole alalaha nenge hetatalonga Isaias hasia. ");
INSERT INTO uvl_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Pe Opepengpeng hele lange Pilipus ke mai, “Oi ke ola rochroi toto nga arenga neu.” ");
INSERT INTO uvl_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Ol pe Pilipus song kela rochroi toto pe longe non neu nge sisisia alalaha neu nenge hetatalonga Isaias. Pe Pilipus ontei sapele ke mai, “O eteia ure nenge o sisisia nem luna pule laka?” ");
INSERT INTO uvl_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Pe ana non hele, “Ke lape e eteia ke mere? Nenge teke mele hele urume at nge iau laka lape e eteia. Pe nei ero i.” Ol pe non neu hele lange Pilipus ke haka lange i kela are luluch nge i. ");
INSERT INTO uvl_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Helenga nemur nenge non soke neu sisisia nga alalaha neu tang ke mai koi, “Ana non heleia helenga unne e ero toto. Hanna hit mana pe maluch mana ke pomanga sipsip nenge te takisia kela te hunune. Pe pule maluch mana ke manga sipsip tuna nenge te ut susue pulpunna. ");
INSERT INTO uvl_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Te hemeia i pe mele mes luluch ke halaua i ero. Tutuna mur lape iri ero ol iange te hune ke mete lo.” ");
INSERT INTO uvl_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Non soke neu sisia helenga nemur ke het pe onteia Pilipus ke mai, “O hele at nge iau mukam, hetatalonga nemai heleleia itei nemai? Heleleia i sipona kai, ma mele e pule?” ");
INSERT INTO uvl_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Ol pe Pilipus hele hote helenga urana toto ngana nenge Iesus lange non neu. Pe talun ke hele nga helenga nemur nenge non neu i sipona sis hote nga alalaha nenge hetatalonga Isaias. ");
INSERT INTO uvl_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Iok, te song ole ke te lala pela te lohot nga kileng unne nge ana ech. Pe non soke neu hele lange Pilipus ke teke, “O naula, ech i loi. O henune iau ol. Ute pele poi ele iau nge e mene henuninga ero.”  ");
INSERT INTO uvl_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Pe Pilipus hele, “Nenge teke letem manmanna toto, lape e henune iong.” Pe non neu tuacholia ke mai, “Iau, letek manmanna toto nge Iesus Kristus nge i NeHalang tuna.” ");
INSERT INTO uvl_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Iok laol, non soke neu hele lange hana nemur nenge te songongia oriong nemur ke tetak ele iri ke temes. Pe iri nai Pilipus te i sio langa ech neu kela Pilipus henune i. ");
INSERT INTO uvl_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Iri nai tei hot nga ech neu pe ueiuei mana NeHalang opene mene tote Pilipus ke non neu kolkol sapelpele. Ol pe ana non lohaka mule ke nanas mule kue neu pe iech ole ke laol. ");
INSERT INTO uvl_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Pe Pilipus la ke lohot nge Astot pe talun sapele ke hele hote helenga urana ngana lange hehei pe hana nga kileng lochloch ngana nga lamau, ke ramana ole lange Kaesarea. ");
INSERT INTO uvl_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Pe nga etue neu, Sol hele ke kerkereng toto ke teke lape hun lapue Non Soke nena hana mur. Ana non, lange tunginga mur aria soke ");
INSERT INTO uvl_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","pe hele lange i ke hasia alalaha mur. Ke alalaha nemur rongo heke hana nenge te mukmuka nga Iuta mur reia hetoronga ana pele mur nge Tamaskus. Pe alalaha neu tehas ia ke te teke, Sol tango rere hehei pe hana nenge tetu teu nga tuluk nenge Esinga Tele pe teke hottaua iri, kale hite peria pe laia iri kela tal teua iri nga tuele au ngana nge Ierusalem. ");
INSERT INTO uvl_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Iok laol, Sol lohaka nge Ierusalem pe la sapele nge Tamaskus. Sol i kela rochroi nge Tamaskus pe ueiuei mana lemenge palaungana e tua nga tapa pe at tualeme hite i. ");
INSERT INTO uvl_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Ol pe Sol losio ke langa ich pe longe helenga e ke pomai, “Sol, Sol, pomere nenge opoi poreke iau ke pomam?” ");
INSERT INTO uvl_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Pe Sol hele, “Non Soke, iong itei nemam?” Pe non neu hele, “Iau Iesus. Iau laka nenge opoi porekreke iau nem. ");
INSERT INTO uvl_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Heueu nei, o lohaka pe oiteu langa kileng neu. Pe nga lamau, lape te hele lange iong nga utar nenge lape o poia.” ");
INSERT INTO uvl_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Pe hana nenge tela luluch nge Sol neu, te rura toto nga ure neu nge lohot pe reia helenga ero ke temes mana ol. Iri pule te longe none nge hele, pe te kolkolia ana non. ");
INSERT INTO uvl_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Iok laol, Sol lohaka ke mes pe teke nau pe ero, kolkol toto. Matana nai ape ke teau ala mana. Pomalam hana nemur tera hite i nga penna pe te apea i ke iriul tei teu lange Tamaskus. ");
INSERT INTO uvl_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Pe Sol matana hit ke etue mol pe ngau pe inia ute e ero toto. ");
INSERT INTO uvl_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Iok, nge Tamaskus, Non Soke nena none tu. Ana non ene laka Ananias. Pe Ananias nau openene ia Non Soke nge iua i ke teke, “Ananias!” Pe i tuacholia ke teke, “Non Soke, utar?” ");
INSERT INTO uvl_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Pe Non Soke hele lange i ke mai, “O lohaka pe ola nga kue nenge ene, ‘Kue Pengpeng’. Pe ola nga Iutas na pele pe o ontei rere none nge na nge Tarsus. Ana non ene laka Sol, pe i la hetalaulau. ");
INSERT INTO uvl_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","I, matana hit pe nau opene pule ke esia none nge ene Ananias nge iteu lange i ke tal heke penna nge i, pe hele lange i ke teke nau mule.” ");
INSERT INTO uvl_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ol pe Ananias tuacholia Non Soke nena helenga ke mai, “Non Soke, iau e longe helenga halang toto nge non nei. I, poi poreke totote lem hana mur nge Ierusalem. ");
INSERT INTO uvl_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Pe heueu nei, tunginga ana hana mur aria papalauna mur, te longele Sol ke te teke, Sol at ke mene hehei pe hana nga kileng nei nenge te hetalaulau pe te heto hekeke iong.” ");
INSERT INTO uvl_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Pe Non Soke hele lange Ananias ke mai, “Ola! Non nem e henonou hote i ke lek non i lo. I lape lake haliu hote ek lange hana lomonmona ngana mur pe nge aria soksoke ngana mur pe nge Israel mur lochloch. ");
INSERT INTO uvl_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Ke nga iau ek mana, i lape takisia melmelenga pe ure meena ngana halang lape lohot nge i.” ");
INSERT INTO uvl_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Iok laol, Ananias i la pe la ke i teu sapele nga pele neu. Pe tal heke penna nge Sol pe hele lange i ke mai, “Tik Sol, Non Soke Iesus nenge lohot nge iong nga kue nenge oi atat ia nem, ngana koi nenge kulosia iau ke eat nge iong nei. Ke pomalam lape onau mule pe Opepengpeng muta nge iong.” ");
INSERT INTO uvl_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Ananias hele ke mau ke het pe ueiuei mana ute e nge pomanga ruo kilkilana nge maele Sol matana, losio pe Sol es ke nek mule sapele. Ke het pe Sol lohaka pe mes haka pe mene henuninga. ");
INSERT INTO uvl_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Iok, Sol ngau ke het pe amneia i nge kerkereng mule. Iok, Sol tu luluch nge Non Soke nena hana mur nge Tamaskus ke ana etue hel pule. ");
INSERT INTO uvl_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Tu pe langa hetoronga ana pele mur nenge Iuta mur pe haliu hote Iesus, ke teke, “Iesus i NeHalang tuna.” ");
INSERT INTO uvl_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Hulua lochloch te longe i nge hele ke mau, pe te rura toto pe te hele ke te teke, “Aina! Non nenge hunune Iesus nena hana mur nge Ierusalem iam lom. At ngana nem, at ke lololoch Iesus nena hana mur pullo la. Ke lalaia iri nge tunginga ana hana mur aria papalauna mur nge Ierusalem.” ");
INSERT INTO uvl_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Pe ero. Sol hetoro ngana song ke kerkereng toto pe palaungana toto ol. Pe halot tote helenga lange Iuta mur nenge tetu nge Tamaskus ke mai, “Iesus i Mesias nenge NeHalang kulosia ke at mene mule nena hana mur lochloch.” Pe Iuta nemur te longe Sol na helenga pe na helenga ma hoa iri. Pomalam te hetakine i nga helenga unne ero toto. ");
INSERT INTO uvl_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Iok, etue halang lalo pe Iuta mur te eukirau pe tetal helenga ke te teke te hune Sol. ");
INSERT INTO uvl_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Pe ero. Sol longo rusia utar nenge te teke te popoia ke het lo. Iok, Iuta mur temes ke tenau ala Sol ke nek toto nga kileng neu ana kue matana mur, ke te teke te hunune i. Kokoes mana temes ke tenau alala, nga sinanga pe nga miliko pule. ");
INSERT INTO uvl_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Pe ero. Sol nena hana mur hel te mene i nga miliko ke te haka langa kileng neu ana mapuo ona, ke te teke te halaua i ke uahot nga kileng neu. Pomalam te hele lange i ke are teu nga chasang palaungana e. Ol pe te heon ole sue i nga mapuo neu hilina ele nenge hile hot, ke sio langa ich pe ua sapele. ");
INSERT INTO uvl_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Iok laol, Sol lange Ierusalem ke teke koko teu luluch nge Iesus nena hana mur. Pe Iesus nena hana mur te mataua i. Iange iri, leteria manmanna ero nga nenge te teke, Sol hulia letena pe lohot ke i Iesus nena non lo. ");
INSERT INTO uvl_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Ol pe Parnapas at pe nene Sol lange Iesus nena hekulkulonga mur. Pe nana urume Sol nge esia Non Soke nga kue pe Non Soke hele lange i. Pe pule Parnapas nana urume Sol nge haliu ke kerkereng toto nga Iesus ene nge Tamaskus. ");
INSERT INTO uvl_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Iok laol, Sol tu luluch sapelpele nge Iesus nena hekulkulonga nemur. Pe iteu pe ihot ia ana seilil nga pele lochloch ngana nge Ierusalem ke haliu hotote Non Soke ene ke soke toto. ");
INSERT INTO uvl_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Ol pe Iuta mur nenge te helele helenga Krik te teke te hune i, iange hele lala nge iri pe iriul ke te hemes haka helelia helenga. ");
INSERT INTO uvl_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Iok, iri nenge leteria manmanna nge Iesus te longe ke mau pe te tau hote Sol lange Kaesarea pe te kulosia i ke la sapele nge Tarsus. ");
INSERT INTO uvl_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Ke hulua lochloch ngana nenge te ekiraurau nga Iesus ene nge Iutea pe nge Kalelea pe nge Samaria tetu ke nek mana ol. Iange mele hel nge teat ke tepoi poreke iri ero ol. Pe Opepengpeng hekerkereng ia iri pe halaulaua iri. Pe hulua halang te koko teu nge iri ke iri halang toto ol. Pe te nanasia poinga nenge tetal sio mene iri nga Non Soke matana. ");
INSERT INTO uvl_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Petrus i ke langa kileng lochloch ngana, pe pule lake nau tote NeHalang nena hana mur nga kileng nenge Lita. ");
INSERT INTO uvl_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Pe nge Lita, none nge ene Aeneas tu. Ana non ma manmana nga hete ke hesinga iri rahtele mol, iange singina mete lochloch. ");
INSERT INTO uvl_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Ol pe Petrus hele lange i ke mai, “Aeneas, Iesus Kristus hemaul mule iong ke o urana mule lo. O lohaka pe olou heke lem manga ol.” Petrus hele ke mau ke het, pe ueiuei mana Aeneas lohaka sapele. ");
INSERT INTO uvl_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Pe hulua lochloch ngana nga kileng nenge Lita pe Saron, te esia non neu nge urana mule, pe leteria manmanna nge Non Soke. ");
INSERT INTO uvl_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Pe nge Iopa, heie nge letena manmanna toto nge Iesus tu. Ana hei ene laka Tapita. Pe nga helenga Krik te hetue i ke ene Tokas. Hei neu kokoes mana halaulaua hehei pe hana nenge reria ure ero. ");
INSERT INTO uvl_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Pe nga etue neu pengpeng haleles mene ana hei pe mete. Iok, telome koluna pe te talue nga nena pele letena e nga lut. ");
INSERT INTO uvl_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Iok, kileng nenge Iopa, tuke rochroi mana langa kileng nenge Lita. Pe iri nenge leteria manmanna nge Iesus, te longe nge te teke Petrus kou tunge Lita. Pomalam, te kulosia hana nai ke tela pe te tunge helenga nei lange i. Te teke, “Kole, oat luluch nge imem ke itaul tala ke ueiuei mana.” ");
INSERT INTO uvl_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Iok laol, Petrus lohaka pe la luluch sapele nge iri. Petrus lake la puris pe te mene i ke tei haka langa pele letena nenga lut. Pe hei pakar mur lochloch ngana teat ke temes ite i pe te tangtang ol. Te tangtang pe te henonoua Petrus lala nga hengeron mur pe malenga mur, nenge Tokas umemeia iri nga maulul ngana. ");
INSERT INTO uvl_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Ol pe Petrus kulos hot sapele iri lochloch ngana nga pele letena unne neu, pe tualou sio nga palana pe hetalaulau ol. Ke het pe, nau langa hei neu koluna pe hele ke mai, “Tapita, o lohaka!” Ol pe hei neu matana charchara, pe esia Petrus pe are haka sapele. ");
INSERT INTO uvl_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Iok laol, Petrus rahit heke hei neu nga penna, pe halaua i ke mes haka. Ke het pe Petrus iu lange iri nenge leteria manmanna nge Iesus, pe hei pakar mur ke teat. Teat ol pe eteia hei neu nge maul haka mule lange iri, pe tung mule lange iri. ");
INSERT INTO uvl_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Iok laol, ure nenge Petrus poia neu, ana helenga song ke hulua lochloch ngana nge Iopa te longe. Pomalam, hulua halang leteria manmanna nge Non Soke. ");
INSERT INTO uvl_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Iok, Petrus tu nge Iopa ke etue halang toto. Pe i tu luluch nge none nge ene Simon. Pe Simon ana ume nenge lome pulumakau pe sipsip mur uliria. ");
INSERT INTO uvl_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Nge Kaesarea, none nge ene Kornelius nge tutu. I non nenge i mukmuka nga palinga hel ana hana mur nge Itali. ");
INSERT INTO uvl_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Ana non pe na pele ngana mur te matau tote NeHalang. Pe kokoes hetalaulau pe halau totote Iuta mur nenge reria ure ero. ");
INSERT INTO uvl_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Nga etuene e nga ulei, chaia matana pallele lo pe Kornelius nau opene ia NeHalang nena angkelo nge at nge i pe hele, “Kornelius!” ");
INSERT INTO uvl_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Kornelius nachnei ia i pe matau toto pe ontei, “Non Soke, pomere mai?” Iok, angkelo hele lange Kornelius ke pomai, “NeHalang longe lem hetalaulaunga lo pe iech toto nga lem poinga nenge o halaua iri nenge reria ure ero. Pe i letena metene kura. ");
INSERT INTO uvl_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Heueu, o kulosia hana hel ke tela nge Iopa pe te tango rere none nge ene Simon. Ene nei ngana laka, Petrus. Pe te hele lange i ke at. ");
INSERT INTO uvl_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Ana non tutu nga pele nenga none nge ene Simon pule. Pe i rahite ume nenge lomlome pulamakau ulina. Na pele mes nga ruach ilina.” ");
INSERT INTO uvl_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","NeHalang nena angkelo hele ke het, pe Kornelius iua nena ume ana hana nai luluch nge palinga hel ana none. Palinga hel ana non nem, i non nenge nanas tau tote NeHalang nena poinga mur. ");
INSERT INTO uvl_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Iua hana mol nem pe hele urume ure lochloch nenge lohot. Ke het pe kulosia iri ke tela nge Iopa. ");
INSERT INTO uvl_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Pomange rou, chaia matana heurunga pe hana mol nem te heroi hot lange Iopa. Pe nga etue neu pengpeng, Petrus haka nga pele ona ke hetalaulau. ");
INSERT INTO uvl_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Petrus mete ana pe teke ngau. Te tatatal ngaunga kura, pe Petrus nau opene ia ute nge hot nge i. ");
INSERT INTO uvl_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Pe esia tapa sana nge alchach pe malenga palaungana sio at. Pe ute e rahite ana oro henel ke pongponga ke sio at nga ich. ");
INSERT INTO uvl_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Pe huros lochloch ngana tema teu nga malenga nem. Huros nemur nenge aperia henechnel pe nemur nenge pomanga hole pe hilimo pe ngie mur tema teu pule. ");
INSERT INTO uvl_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Pe helenga e lohot nge Petrus pe hele, “Petrus, o lohaka pe o hune huros nemur ke o ngaua iri.” ");
INSERT INTO uvl_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Petrus tuacholia helenga ke pomai, “Non Soke, heo ngana toto nge e ngaua huros nenge muna pe lemlem ero.” ");
INSERT INTO uvl_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Helenga hot henei ngana mule ke pomai, “Ure nenge Non Soke ume ia ke lemlem pe urana, o hetue ke muna pe poreke ero.” ");
INSERT INTO uvl_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Ure nei hot hemol pe ueiuei mana pe malenga neu haka la mule nga lut nga tapa. ");
INSERT INTO uvl_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Petrus letena tuanin rara ia nau opene ngana nem luna kura, pe hana nenge Kornelius kulos ia iri te puris pe temes nga pele matana lo. Iange iri te onteitei ia hana hel nga Simon nena pele. ");
INSERT INTO uvl_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Pe Kornelius na hana nemur teiu lange iri pe te onteia iri, “Simon nenge ene e pule Petrus, ngana kau tutu mau?” ");
INSERT INTO uvl_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Petrus letena tuanin rara ia opene ngana kura pe Opepengpeng hele lange i, “Hana mol kou, te tango rerere iong. ");
INSERT INTO uvl_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Ke o lohaka pe osio la ke ola luluch nge iri. O matau ero iange iau sipok e kulos ia iri.” ");
INSERT INTO uvl_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Petrus sio la pe hele, “Non nenge a tango rere, ngana koi. A at ke a potar?” ");
INSERT INTO uvl_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Pe hana nemur te tuacholia, “Kornelius, non nenge mukmuka na palinga hel ana hana mur, kulos ia imem ke moat. I non urana ngana ia pe matautau nena nge NeHalang. Iri lochloch nenge Iutea te hele ia i ke teke non urana ngana ia. Pe NeHalang nena angkelo e hele lange i ke teke iong oat nga nena pele ke longo langa lem helenga.” ");
INSERT INTO uvl_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Ol pe Petrus mene teua iri ke tema nge i. Iok, pomange rou Petrus pe hana hel pule nge Iopa te koko luluch sapele nge iri. ");
INSERT INTO uvl_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Pe nga etue naingana te lohot nge Kaesarea. Pe Kornelius eukiraua pekngana mur pe alona mur nga nena pele ke te kulele hana nemur nenge Kornelius kulosia iri ke tela taua Petrus. ");
INSERT INTO uvl_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Iok, Petrus teu ke lala nga pele letena pe Kornelius song kela tamal sue i nga Petrus apena huna pe tualou sio lange i. ");
INSERT INTO uvl_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Pe Petrus hele, “Omes haka, iau non mana ke mange iong i.” ");
INSERT INTO uvl_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Petrus hele lala nge Kornelius pe i ke teu lala nga pele. La pe saol haka nge hulua lochloch ngana nemur nga pele letena. ");
INSERT INTO uvl_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Pe hele lange iri ke pomai, “Imo sipomo a eteia lo ke Iuta mur reria hotongo hele ke teke iri nenge Iuta tetu ke te kangkanga nge hana lomonmona ngana mur. Pe nei ol, NeHalang henonou hot tote at nge iau ol ke teke, E hetue mele ke muna pe lemlem ero toto. ");
INSERT INTO uvl_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Ke ngana laka nenge o hekulo ak pe e lohaka ke ueiuei mana ke eat. Iok, e onteia iong ol, pomere nenge o hekulo ak ke eat mai?” ");
INSERT INTO uvl_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Pe Kornelius hele, “Etue iri mol kou lalo pe kileng nakuna pomai. Pe iau e hetalaulau nga lek pele letena nga ulei. Ol pe none nge nena hengeron hussu pe sina ala toto mes hot mana nga matak, ");
INSERT INTO uvl_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","pe hele, ‘Kornelius! O hetalaulau pe NeHalang longe ke ulolo. Pe pule, esia lem poinga nenge o popoia lala nge iri nenge reria ure halang ero. ");
INSERT INTO uvl_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Ke pomalam o kulosia mele lange Iopa ke lataua none nge ene Simon Petrus. Ana non la tu luluch nge none pule nge ene Simon, nenge ana ume nenge nauelele huros mur singiria. Reria pele laka tu rochroi langa ruach ilina.’ ");
INSERT INTO uvl_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Pomalam e hekulo am sapele. Pe iong o poia nga poinga urana ngana ke oiat. Ke heueu nei, ita lochloch tames nga NeHalang matana koi, pe mo kulala mana nge mo longo nga utar nenge NeHalang hele ke teke oat ke o hele hote.” ");
INSERT INTO uvl_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Ol pe Petrus lohaka pe hele, “Oe, nei ol e eteia ke NeHalang poia hulua lochloch nga kileng lochloch ngana ke elle mana. ");
INSERT INTO uvl_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","NeHalang poi ke urana lange iri lochloch ngana nenge te mataua NeHalang pe te nanas tau tote i, NeHalang lape iech mana nge mene mule iri. ");
INSERT INTO uvl_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Imo a eteia helenga nem nenge NeHalang hesongia lange Israel mur lo. Ana helenga urana toto ngana nenge Iesus Kristus i Non Soke, pe i palaungana toto pe nauele ure lochloch. ");
INSERT INTO uvl_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Imo a eteia ure palaungana nem nenge lohot nge Israel. Talun laka nge Kalelea, nanasia henuninga nenge Ioanes haliu hote. ");
INSERT INTO uvl_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Pe imo a eteia Iesus nenge Nasaret. NeHalang hemuta ia i nga Opepengpeng pe hekerkereng tote i. Pe ana non i rara nga kileng mur pe popoia poinga urana ngana mur. Pe hemasmas ia iri nenge Non Poreke ngana rahite ke kerkereng. NeHalang tu toto nge Iesus ke ngana laka popoia ure nemur. ");
INSERT INTO uvl_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","“Imem mo esia nga matamem, ure nemur nenge Iesus popoia nge Israel pe nge Ierusalem. Te hune i nga ana manga toto ke mete. ");
INSERT INTO uvl_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Pe nga etue mol ngana nga ana metenga nga hoena, NeHalang hemaul heke mule i ke hana hel te esia i. ");
INSERT INTO uvl_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Hana lochloch te esia i ero. Imem toro nenge NeHalang hesilei hote nike. Ke imem mo esia i nga ana metenga nga hoena pe mo ngau pe mo in luluch nge i. ");
INSERT INTO uvl_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Pe hele at nge imem ke mo haliu hote na helenga urana toto ngana lange hehei pe hana. Pe tunge ume palaungana nenge mo hele ke Iesus i sipona NeHalang nena non toto nenge lape nau teu nga hehei pe hana lochloch reria poinga mur. Iri nenge te maulul pe iri nenge te mete lo. ");
INSERT INTO uvl_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Hetatalonga mur lochloch te hele urume i ke te teke, Nga Iesus ene, iri lochloch nenge leteria manmanna nge i lape NeHalang saua reria poinga poreke ngana mur ke te lasus toto.” ");
INSERT INTO uvl_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Petrus helele kura pe Opepengpeng sio at pe hemuta ia iri lochloch nenge te longlonge helenga nem. ");
INSERT INTO uvl_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Iuta mur hel nenge leteria manmanna nge Non Soke, nenge te koko luluch nge Petrus te rura. Iange te esia hana lomonmona ngana mur nge NeHalang hekule Opepengpeng ke rongo heke iri ke pomanga hemuta heke nge imem pule. ");
INSERT INTO uvl_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Pe te longe iri nge te helele ia helenga nge altoto pe te heto heke Non Soke ene. ");
INSERT INTO uvl_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Ol pe Petrus hele, “Itei nenge heo ele ech nenge te henune hana nemur? Iange iri te mene Opepengpeng ke pomange ita.” ");
INSERT INTO uvl_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Pomalam hele ke kerkereng ke te henune iri nga Iesus Kristus ene. Ol pe te hele lange Petrus ke tu luluch nge iri nga etue hel pule. ");
INSERT INTO uvl_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Iok laol, Iesus nena hekulkulonga mur pe iri lochloch ngana nenge leteria manmanna nge Iesus, te longe helenga e nge te heleia ke te teke, hehei pe hana lomonmona ngana mur, iri pule te mene NeHalang nena helenga ke ulolo. ");
INSERT INTO uvl_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Ke nga etue nenge Petrus la mule nge Ierusalem, iri (Iuta mur) nenge leteria manmanna nge Iesus pe te nanasia poinga nenge teririr us, te hele inin taua i ke pomai, ");
INSERT INTO uvl_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","“O poia poinga utar panenge oteu langa hana lomonmona ngana mur reria pele pe ongau luluch nge iri pamam? Hana nem terir us erochro iam!” ");
INSERT INTO uvl_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Iok laol, Petrus lohaka pe nana hote ure lochloch ngana lange iri ke nek toto. Pe hele, ");
INSERT INTO uvl_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Iau etu nge Iopa pe e hetalaulau. Ol pe enau opek ke e esia ute e nge pomanga malenga palaungana, nge sio at nga lut nga tapa. Pe ana ure, te rahit ele nga ana horo mur nge iri henel pe te hesue ke at toto nga matak. ");
INSERT INTO uvl_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Iok, e teke enau teu pe e esia huros mur nenge aperia henel pe nenge nakuria manga hole, pe ngie mur. ");
INSERT INTO uvl_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Ol pe e longe helenga e nge hele at nge iau ke teke, ‘Petrus, o lohaka ke ohun am huros ke o ngau!’ ");
INSERT INTO uvl_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","“Pe iau e tuacholia, ‘Non Soke, heo ngana toto iam, nge e ngaua huros nenge muna pe lemlem ero.’ ");
INSERT INTO uvl_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","“Ol pe helenga neu sio at henei ngana nga lut nga tapa pe hele mule at nge iau ke mai, ‘Ure lochloch ngana nenge NeHalang poia iri ke te lemlem, a hetue iri ke te lemlem ero, ero.’ ");
INSERT INTO uvl_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","E longe helenga neu nge hele at nge iau ke hemol. Ke het pe tetak heke mule ure lochloch ngana nemur la mule nga tapa. ");
INSERT INTO uvl_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","“Pe nga etue neu pengpeng hana mol nge te kulosia iri at nge Kaesarea, teat ke te lohot nga pele nenge e tutuia. ");
INSERT INTO uvl_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Pe Opepengpeng hele at nge iau ke teke, ‘O matau ero. O koko mana nge iri. Pe titik mur hana rahtele elle nei, tela luluch nge iau kela mo iteu nga non neu na pele.’ ");
INSERT INTO uvl_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","“Pe ana non, nana at nge imem nge teke esia angkelo e nge mes nga na pele. Pe angkelo neu, hele lange i ke pomai, ‘O kulosia hana hel ke tela taua Simon ke at. Ana non ene e pule laka Petrus. I kou tutu nge Iopa. ");
INSERT INTO uvl_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","I lape atia helenga e nge iong. Pe nga helenga nem, iong pe hulua lochloch ngana nenge tetu nga lem pele nem, lape a mene maulinga nge koko.’ ");
INSERT INTO uvl_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","“Iok laol, e talun ke e helele pe Opepengpeng sioat nge iri ke pomanga nenge sio at nge ita nga Pentikos ana etue nem. ");
INSERT INTO uvl_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Ol pe letek metene Non Soke nena helenga nenge teke, ‘Ioanes henune hehei pe hana nga ech pe imo lape a mene henuninga nga Opepengpeng.’ ");
INSERT INTO uvl_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Ita, letera manmanna nge Non Soke Iesus pomalam NeHalang tunge tunginga nem at nge ita. Pe heueu nei, NeHalang tunge tunginga nem lange iri pule. Pe iau utar toto nenge lape epoi ele ume nenge NeHalang i sipona poia lange iri?” ");
INSERT INTO uvl_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Hana nemur te longe Petrus nena helenga mur pe leteria maluch sio mule pe leteria inin ero ol. Pe te heto heke NeHalang pe te hele, “Eh! NeHalang teke hana lomonmona ngana mur pule, te hulia leteria pe te mene maulinga nge koko.” ");
INSERT INTO uvl_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Iok, iri nenge leteria manmanna nge Iesus pe ua parai nga etue nenge Stipen mete, hel tela toto nge Poenesia pe nga mimio nge Saiprus pe nga kileng nge Antiok. Pe nga kileng nemur, te haliu hote NeHalang nena helenga lala nge Iuta mur mana. ");
INSERT INTO uvl_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Pe hana hel nge iri, reria nga mimio nge Saiprus pe nga kileng nenge Sirini. Iri nemur tela nge Antiok pe te haliu hote helenga urana toto ngana nge Non Soke Iesus lange Krik mur pule. ");
INSERT INTO uvl_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Pe Non Soke nena kerkerenga palaungana tu luluch nge iri, pomalam hehei pe hana halang leteria manmanna pe te nanasia Non Soke. ");
INSERT INTO uvl_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Helenga nei, song kela NeHalang nena hana mur nenge Ierusalem te longe, pomalam te kulosia Parnapas ke lange Antiok. ");
INSERT INTO uvl_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Iok, Parnapas lake puris, pe es tote nga matana nga NeHalang halaungana ia hehei pe hana mur nga lamau. Ol pe iech toto pe hekerkereng ia hehei pe hana ke muteria tau tote Non Soke pe te nanasia i ke kokoes. ");
INSERT INTO uvl_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Parnapas i non urana ngana toto. I, letena manmanna ngana tu ke kerkereng toto, pe Opepengpeng tuke muta toto nge i. Ke nga etue neu, hulua halang toto mule, te koko teu luluch nge iri nenge leteria manmanna nge Non Soke. ");
INSERT INTO uvl_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Ke het pe Parnapas lange Tarsus ke tango rere Sol. ");
INSERT INTO uvl_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Tango rere Sol kela hottaua i pe mene i ke iri nai tela mule nge Antiok. Ke Parnapas iri nai Sol tetu luluch nge NeHalang na hana mur nge Antiok pe te hetottore iri halang toto ke hesinga elle. Ke nge Antiok, iri nenge leteria manmanna nge Iesus, te hetue iri hana nenge te lohot nga mata nenge Kristus pe eria nem talun pengpeng nge Antioch. ");
INSERT INTO uvl_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Pe nga etue neu pengpeng, hetatalonga mur hel te lohaka nge Ierusalem, ke tela nge Antiok. ");
INSERT INTO uvl_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Elle nge iri ene laka Akapus. Ana non mes haka nga Opepengpeng na kerkerenga pe haliu hote uringa palaungana e nge lape lohot nga kileng lochloch ngana nga ich. (Uringa nei lohot ke manmanna nga etue nenge Klatius nauele kileng nem.) ");
INSERT INTO uvl_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Ol pe Non Soke nena hana mur te longe helenga neu pe te hele ke te teke lape te halaua pekngaria mur, nenge Iutea nga aria ngaunga uruna. ");
INSERT INTO uvl_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Iok, te takiraua umtutuna ke het pe te tunge lange Parnapas iri nai Sol ke te laia lange pekngaria nemur nge Ierusalem, aria almasinga ana hana. ");
INSERT INTO uvl_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Iok, nga etue nem, naungaala ana non soke ne Herot talun ke heporeke mata nenge NeHalang. ");
INSERT INTO uvl_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Pomalam, mene Ieims nenge tina Ioanes ke hune i nga kakop. Pe Iuta mur te esia poinga nei pe te iech mana. ");
INSERT INTO uvl_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Ke nga ngaunga matana nenge Ingatoto ana at, Herot hele ke te laua Petrus. ");
INSERT INTO uvl_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Te laua i ke het pe tetal teu sapele i langa tuele au ngana. Pe Herot hele ke palinga hel ana hana mur ana tuluk iri henel tenau ele i. Pe nga tuluk elle pe elle ana hana iri henechnel ke tenau ele Petrus. Iange Herot teke Ingatoto ana etue het pe mene hote Petrus ke ontei hote i nga hulua mataria. ");
INSERT INTO uvl_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Pomalam, Petrus tumana nga tuele au ngana. Pe hehei pe hana nemur nenge leteria manmanna toto nge Iesus, te hetalaulau ke kerkereng toto lange NeHalang, ke halaua Petrus. ");
INSERT INTO uvl_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Pomange rou, Herot lape mene hote Petrus kela ontei hote i nga hulua mataria. Pe nga miliko, Petrus mamani mana nga palinga hel ana hana nai tunangaria pe tekale hite Petrus penna pe apena nge iri nai nem. Pe palinga hel ana hana hel pule temes ke tenau ele i nga piunga matana. ");
INSERT INTO uvl_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Ol pe NeHalang na angkelo lohot, pe lemenge tualeme nga tuele au ngana letena. Pe angkelo neu, lake rahite Petrus nga ekena pe hengo heke i pe hele, “O lohaka ke ueiuei mana.” Ol pe rur kerkereng ngana nenge tekale hite nga Petrus apena pe penna neu, un hot mana. ");
INSERT INTO uvl_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Ke het pe angkelo neu hele lange i, “O mele am tal pe o heron heke lem ae ulina.” Pe Petrus poia ure nemur Pe angkelo neu hele mule lange Petrus, “Iok, o heron heke lem hengeron nenge hot ana pe o nanasia iau.” ");
INSERT INTO uvl_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Pe Petrus nanas hot sapele angkelo neu, nga tuele au ngana. Pe angkelo neu poia ure neu ke lohot ke manmanna. Pe Petrus eteia ero toto. Teke ma nau opene mana ia ure nemur. ");
INSERT INTO uvl_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Iok, tei hot ke tela pe te saolia palinga ana hana mur hel pe tela mana. Te i ke la pe te saolia hel pule pe iri pule tepoi ele iri ero. Te la mana. Iok, tei la taua piunga matana nenge palaungana toto. Pe piunga matana neu, te chau hite ke kerkereng toto. Pe pule, piunga matana neu, nau hot la pengpeng nga kue tana. Tela pe piunga neu, i sipona olha. Pomalam, tei hot sapele ke tela. Tei ke sase pol nga kue tana, pe angkelo neu erue sio sapele. ");
INSERT INTO uvl_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Ol pe Petrus, ramana mallaha pe letena matana ke nek toto ol, nga ure nemur nenge te lohot nge i. Ol pe hele, “Nei ol, e etei tote ke ure nemur te lohot ke manmanna toto. Nenge Non Soke hekule nena angkelo ke mene hote iau nga Herot na kerkerenga. Pe pule, ure nenge hana Iuta mur te teke te esia nge lohot nge iau, lape lohot ero ol.” ");
INSERT INTO uvl_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Iok, Petrus ramana mallaha pe letena matana ke nek toto ol, pe i sapele ke langa pele nenge he Maria, nenge Ioanes Makus tana. Pe nga pele neu, hulua halang te eukirau ke te hetalaulau. ");
INSERT INTO uvl_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Iok, hei malolong e nge hekuleileinga ana tu lamau pule. Pe ene laka Rota. Ana hei, longe Petrus nge ischongchong nga piunga, pe teke lake loe piunga. ");
INSERT INTO uvl_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Pe ero. Iange longo il mene Petrus hele ngana pe letena iech toto. Ol pe song ke la mule pe hele ke teke, “Petrus laka ischongchong nga piunga matana nem!” ");
INSERT INTO uvl_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Pe iri nemur nga pele neu letena, te hele lange i, “Iong, lape am hauaua iam!” Pe ana hei helele kura ke teke ure nei lohot ke manmanna. Ol pe iri te lohaka pe te hele ke te teke, “Lape Petrus na angkelo iam.” ");
INSERT INTO uvl_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Pe ero, Petrus kou ischongchong nga piunga kura. Ol pe tela ke teloe piunga pe te esia i nge mes. Te esia Petrus pe ramaria au ala toto. ");
INSERT INTO uvl_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Pe Petrus penna poi lange iri ke te reng, pe nana urume i nge Non Soke mene hote i nga tuele au ngana. Ke het pe hele, “A heleia ure nei lange Ieims, pe titira mur lochloch ngana nenge leteria manmanna nge NeHalang.” Petrus hele ke mau ke het pe loloun ke langa kileng unne pule. ");
INSERT INTO uvl_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Pe nga uach ol, palinga hel ana hana nemur te poia chauchainga pe tangoraranga palauangana nga utar nenge lohot nge Petrus nga miliko. ");
INSERT INTO uvl_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Pe Herot tung hot sapele nena helenga kerkereng ngana, nenge te nanasia ke te tango rere Petrus. Tenau rere i pe tehot taua i ero toto. Pomalam, mene palinga hel ana hana nemur, pe ontei hote iri ke nek. Ontei hote iri ke het pe hele ke teke iri lochloch te mete. Ke het pe Herot lohaka nge Iutea pe la ke tu pol mana nga kileng nenge Kaesarea. ");
INSERT INTO uvl_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Nga Herot tu pol ngana nenge Kaesarea, letena inin tau totote hana nenge Tir pe Siton. Ol pe hana nemur nga kileng nai neu, te eukirau ke elle ke la te esia i pe tepoi ke nek lange i. Pe nga tele ngana, tela tala nge Plastus pe te hele lange i ke halaua iri. Iange Plastus i non nenge nauele Herot na pele. Ke het pe te hele lange Herot ke poi ke urana mule lange iri, iange iri nemur nga kileng nai neu, te menmene aria ngaunga nga Herot na kileng. ");
INSERT INTO uvl_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Iok laol, etue nem at nenge hana nemur te teke tela ke te esia Herot. Pe Herot heron heke hengeron mur nenge naungaala ana pe la ke are haka nga nena arenga palaungana pe tung hote nena helenga mur. ");
INSERT INTO uvl_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Ol pe hulua nemur te alngaria haka ke te teke, “Non pa nei tal haka tote i sipona ke i pomanga NeHalang toto i! Nakuna nenge NeHalang i sipona koi helele nei, iange non pulut ngana pele hele ngana pomai ero.” ");
INSERT INTO uvl_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Pe Herot hele ngana nemur, heto heke NeHalang ia ero toto. Pomalam, Non Soke nena angkelo poia i ke singina haleles pe matmata tole i pe mete sapele. ");
INSERT INTO uvl_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Pe NeHalang nena helenga mur, puo ke lala ke hehei pe hana halang te longlonge. ");
INSERT INTO uvl_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Ke Parnapas iri nai Sol te poia aria ume nge Ierusalem ke het pe tela mule nge Antiok. Pe te mene Ioanes Makus ke la luluch nge iri. ");
INSERT INTO uvl_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Nge Antiok, iri nenge leteria manmanna pe te heto hekeke Iesus te tutu. Pe hana hel nge iri, iri hetatalonga. Pe hel iri hetoronga. Hana nemur eria koi; Parnapas pe Simon (nenge singina muna) pe Lusius (nenge nena nge Sirini) pe Manaen (nenge ana lala Herot Antipas) pe Sol. ");
INSERT INTO uvl_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Iri nemur te hetalaulau pe te heto hekeke Non Soke pe teheo nga ngaunga pule. Pe Opepengpeng hele lange iri ke pomai, “A henonou hote Parnapas iri nai Sol. Iri lape te poia ume palaungana nenge e iua iri nai ke te poia.” ");
INSERT INTO uvl_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Iok, teheo nga ngaunga pe te hetalaulau ke het pe tetal heke peria nge Parnapas iri nai Sol pe te kulosia iri ke tela sapele. ");
INSERT INTO uvl_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Iok laol, Opepengpeng poia iri nai ke tei sio lange Selusia pe te mene imot pe tela sapele nga mimio nenge Saiprus. ");
INSERT INTO uvl_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Tela te lohot nge Salamis pe te hele hote NeHalang nena helenga nga Iuta mur reria hetoronga ana pele letena. Pe Ioanes Makus, kokoko nge iri ke halaulaua iri. ");
INSERT INTO uvl_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Iok, tela sapelpele nga mimio nem ilina ele nge Papos. Pe nga lamau, te saolia non Iuta e nge popoi ure paluna. Ene laka Par-Iesus pe i teke i hetatalonga pe ero. I chanangnanga mana. ");
INSERT INTO uvl_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Pe ana non tu ke rochroi nge non soke e nenge nauele mimio nem, ene laka Serkius Paulus. Pe Serkius Paulus nem, letena matana nga ure lochoch. Pe i hekulo Parnapas iri nai Sol aria, iange teke longo nga NeHalang nena helenga. ");
INSERT INTO uvl_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Pe Elimas non nenge popoi ure paluna nem, ramana urana nge iri ero toto. (Nga helenga Krik, te hetue non nenge popoi ure paluna nem ke ene Elimas) Ana non teke poi ele non soke neu nge letena manmanna nge Iesus. ");
INSERT INTO uvl_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Ol pe Opepengpeng hemuta heke sapele Sol, nenge ene epule Paulus. Pe Sol naula pengpeng nge Elimas pe hele, ");
INSERT INTO uvl_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","“Iong nem, Non poreke ngana tuna laka iong! Iange lemem ero toto ia ure lochloch ngana nenge te urana! Pe iong, o pallaka ngam kou kura. Ure lochloch ngana nenge te poia nga Non Soke ene, ure nemur manmanna. Pe iong, o hele ke o teke ure nemur te pallaklaka ia iri. ");
INSERT INTO uvl_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Ke heueu nei lape o amnei am nga Non Soke penna mukam. Lape matam hit ke o kolkol ia chaia matana mukam.” Ol pe non neu matana auala pe pal rara sapele, ke teke tango rara mele ke apea i. ");
INSERT INTO uvl_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Iok laol, non soke Serkius Paulus esia ure nei nge lohot ke mau pe letena manmanna toto sapele. Iange rura toto nga Non Soke nena hetoronga mur. ");
INSERT INTO uvl_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Paulus iri ul pekngana mur te mene imot nge Papos pe tela nge Perka, nga kileng nenge Pampilia. Pe nga lamau Ioanes Makus hile sue iri pe la mule nge Ierusalem. ");
INSERT INTO uvl_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Iok, iri nemur te lohaka nge Perka pe tela nge Antiok nga kileng nenge Pisitia. Pe nga Sapat ana etue, tei teu kela teare sio nga hetoronga ana pele letena. ");
INSERT INTO uvl_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Iok, te sisia alalaha nemur nenge Moses pe hetatalonga mur ke het pe te hekule helenga lange Paulus iri nai Parnapas ke te teke, “Atong mur, nenge teke lemo helenga hel nge a teke a hekerkereng ia hehei pe hana leteria, ames haka pe a hele.” ");
INSERT INTO uvl_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Ol pe Paulus mes haka sapele pe tul heke penna pe hele, “Imo hana nenge Israel pengpeng pe imo hana lomonmona ngana mur nenge a heto heke NeHalang, a longo at nge iau. ");
INSERT INTO uvl_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Israel mur aria soke NeHalang, henonou hote rera tete mur nge nike. Nga etue nenge tetu nge Ekipto, poia iri ke iri hulua. Pe nga i sipona na kerkerenga nenge palaungana toto, mene hote iri nga kileng nem. ");
INSERT INTO uvl_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Pe nga etue nenge te ii nga ich sana lomona, nauele iri ke nek toto ke hesinga iri ana non kina nai (40). ");
INSERT INTO uvl_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Pe hekou sue tuele tana iri rahtele nai nga ich nenge Kanan. Pe tunge ich nemur lange nena hana mur pengpeng ke reria ia. ");
INSERT INTO uvl_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Ure nemur te lohotot ke hesinga iri ana non kina lime iri henel pe ana non kina nai pe analoch (450). “Ke het pe NeHalang henonou hote hana mur hel ke iri muka ia nena hana mur, ke la het nga etue nenge hetatalonga Samuel. ");
INSERT INTO uvl_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Ol pe hehei pe hana lemeria ke te teke none lohot ke iri aria naungaala ana non ia. Pomalam te onteia NeHalang pe NeHalang henonou hote Sol nenge ne Kis tuna. Sol lohot nga mata nenge Pensamin pe nauele hehei pe hana ke hesinga iri ana non kina nai. (40) ");
INSERT INTO uvl_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Iok, NeHalang mene tote Sol pe henonou hote Teuit ke mene Sol munna. Pe NeHalang heleia Teuit ke teke, ‘Teuit i Iesi tuna. Pe utar nenge e hottaua nge i, i non nge urana. Ke iau lemek tau tote non nenge pomai. Iange i poia ure lochloch ngana nga iau lemek ngak.’ ");
INSERT INTO uvl_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","“Pe nge he, lape Iesus nenge Israel mur aria hemasinga lohot nge non nei na tete mur. Ure nem lohot iange NeHalang i sipona hele talue lo ke teke poia. ");
INSERT INTO uvl_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Pe Iesus lohot ero kura pe Ioanes haliu ke teke hehei pe hana lochloch ngana nge Israel te hulia reria poinga mur pe te mene henuninga. ");
INSERT INTO uvl_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Iok, Ioanes poia ana ume ke hetet lo pe hele lange hehei pe hana, ‘Imo a teke iau itei mai? A longo ke nek. Non nenge a kulelele, ngana kou atat kura. Pe a teke i nge iau ero. Iau e urana ero toto nge e halaua i ke epoi hote nena ae ulina nenge heronronia nga apena.’ ");
INSERT INTO uvl_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“Titik mur, imo nenge a lohot nge Apraham pe imo hana lomonmona ngana mur nenge a heto hekeke NeHalang, helenga nenga maulinga nge koko, te hekule at nge ita. ");
INSERT INTO uvl_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Iange hana nenge Iersalem pe aria papalauna mur ramaria mallaha nge Iesus ero. Pe pule te eteia hetatalonga mur ria helenga luna ero, nenge tesis hote ke kokoes mana nga Sapat ana etue. Ke pomalam tetal sio tote Iesus. ");
INSERT INTO uvl_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Pe te tango rere kue e nge te teke te hune Iesus ia. Pe ero. Ol pe te hele lange Pilatus ke te teke, lemeria toto nge Iesus mete. ");
INSERT INTO uvl_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Pe poinga nenge te poia nem, pete tote NeHalang nena helenga mur lochloch nenge tehas sue ke ulolo. Ke te takis sue i nga ana manga toto pe la tetal teua nga polo. ");
INSERT INTO uvl_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Pe NeHalang hemaul heke mule i nga metenga. ");
INSERT INTO uvl_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Pe Iesus hetei hote i ke emule mana lange iri nenge tei luluch nge i nge Kalelea ke lange Ierusalem. Ke heueu nei, iri nemur te hele hotote ure nemur nenge lohotot nge iri, lala nge Israel mur. ");
INSERT INTO uvl_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Ke imem mo hele hote helenga urana toto ngana nem lange imo pule. Nga utar nenge NeHalang hele ke kerkereng ke teke poia lange ratete mur nge nike. ");
INSERT INTO uvl_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Ke pomalam heueu nei, NeHalang nena helenga nem lohot ke manmanna ke tuturia mur ita ta naue. Nga nenge hemaul heke mule Iesus nga metenga, ure nenge lohot nem tehas urume tele nike nga alalaha chonna naingana nenge Sam. Ke ana helenga hele ke teke, “‘Tuk laka Iong; ke heueu nei Temem koi Iau’” ");
INSERT INTO uvl_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Manmanna toto ke NeHalang hemaul heke mule Iesus nga metenga. Pe i ma ke punich nga polo letena ero. Pomalam, NeHalang hele ke pomai, “‘Imo lape a mene petanga pengpeng ngana nenge e hele talue lange Teuit ke lape e tunge.’ ");
INSERT INTO uvl_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Pe nga alalaha nenge Sam, chonna e pule hele ke teke, ‘Iong onau sio mene lem non nenge pengpeng toto ke ma ke punich ero.’ ");
INSERT INTO uvl_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","“Iok, Teuit nanas tau mene NeHalang lemene ngana nga tungana nga ich. Pe nga etue nenge mete, tealo hite i nga na tete mur tema ngaria pe make punich nga polo letena. ");
INSERT INTO uvl_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Pe i nenge NeHalang hemaul heke mule nga metenga nem, ma ke punich mana nga polo letena ero. ");
INSERT INTO uvl_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Titik mur a longo ke nek, nge Iesus i toro mana, NeHalang lape ul rumena ia lemo poinga poreke ngana mur pe nau la mule nge iri ero ol. ");
INSERT INTO uvl_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Pe Iesus, i sipona lape mene mule iri nenge leteria manmanna nge i. Mene mule iri nga reria poinga poreke ngana mur nenge rahit tote iri ke kerkereng. Iange Moses na hotonga e nakuna ero toto nge poia poinga nem. ");
INSERT INTO uvl_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Iok, a nauala amo ke nek ol iange lape ure nem nenge hetatalonga mur te heleia, lape lohot nge imo. Hetatalonga nemur te hele ke pomai, ");
INSERT INTO uvl_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","“‘Imo nenge a tua salaklaka halali, a longo at. Lape ramamo auala mana pe a mete. Iange lape epoi hote ute nga atu ngamo nga ich. Pe imo lape letemo manmanna ia ero toto. Pe nenge te hele urume lange imo, lape letemo manmanna ero pule.’” ");
INSERT INTO uvl_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Iok, Paulus iri nai Parnapas te lohotot nga hetoronga ana pele lo, pe hehei pe hana te hele lange iri ke te teke, iri nai lape teat mule nga Sapat ana etue e pule ke te hetore iri ke nek toto nga ure nemur. ");
INSERT INTO uvl_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Iok, tehot lange hot lo pe Iuta mur pe hana lomonmona ngana mur nenge te nanasia Iuta mur te hetalaulau ngaria, te nanasia Paulus iri nai Parnapas. Pomalam Paulus iri nai Parnapas te hekerkereng ia hulua nemur leteria, ke te teke kokoes mana, leteria manmanna nge NeHalang pe tenau la mana nge i nga nena tunginga urana ngana mur nge tunge lala nge iri. ");
INSERT INTO uvl_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Iok laol, Sapat ana etue neu at pe nakuna nenge hulua lochloch ngana nenga kileng neu te lohaka ke la te longo nga Non Soke na helenga. ");
INSERT INTO uvl_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Ol pe Iuta mur, te esia hulua lochloch ngana neu pe saria keke Paulus pe te hele poreke i. ");
INSERT INTO uvl_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Pe Paulus iri nai Parnapas te haliu hot ke soke toto ke te teke, “Imem mo teke mo hele hot tele NeHalang na helenga lange imo. Pe imo, aulo ala pe lememo ero nge a mene helenga nei. Ke poinga nem henonou hote imo ke nakumo ero toto nge a mene maulinga nge koko. Pe pomalam lape mo hile sue imo pe mola nge hana lomonmona ngana mur. ");
INSERT INTO uvl_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Iange Non Soke hele ke kerkereng at nge ita ke teke, “‘E poia imo ke pomanga lemenge nenge lange hana lomonmona ngana mur. Ke pomalam lape kileng lochloch ngana nga ich te mene maulinga nge koko.’” ");
INSERT INTO uvl_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Iok laol, hana lomonmona ngana mur te longe ke mau pe te iech toto, pe te heto heke Non Soke na helenga. Pe iri nenge NeHalang henonou hote ke te mene maulinga nge koko, leteria manmanna toto sapele nga helenga nemur. ");
INSERT INTO uvl_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Ol pe Non Soke na helenga puo ke palaungana toto nga tuele kina neu. ");
INSERT INTO uvl_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Pe nge Antiok, Iuta mur teteu heke hehei pe hana papalauna leteria ke te talun ke tepoi poreke Paulus iri nai Parnapas pe telope hote iri nga reria tuele kina neu. ");
INSERT INTO uvl_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Iok laol, Paulus iri nai Parnapas tepasis sue kileng neu ana maruchrue nga aperia pe tei ke tela nge Ikonium. ");
INSERT INTO uvl_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Pe hulua nenge leteria manmanna nga NeHalang na helenga nge Antiok, te iech toto pe Opepengpeng tu ke muta toto nge iri. ");
INSERT INTO uvl_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Pe nge Ikonium, Paulus iri nai Parnapas tei teu nga hetoronga ana pele. Pe te haliu hote NeHalang na helenga ke nek toto. Ol pe Iuta mur pe hana lomonmona ngana mur halang leteria manmanna. ");
INSERT INTO uvl_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Pe iri Iuta mur nenge leteria manmanna ero, teteu nga hana lomonmona ngana mur leteria ke tetua lele sue leteria manmanna ngana. ");
INSERT INTO uvl_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Ke Paulus iri nai Parnapas tetu lamau ke mala toto, pe te haliu hote Non Soke na helenga ke kerkereng toto. Pomalam, Non Soke tunge kerkerenga nenge te popoia ure papalauna mur. Ke nga poinga nem, Non Soke hekerkereng ia iri nai. Te haliu hote Non Soke nge letena ia ita pe mene mule ita. ");
INSERT INTO uvl_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Pe hana nenga kileng neu telas hel. Ke hel tela nge Iuta mur pe hel tela nge Paulus iri nai Parnapas. ");
INSERT INTO uvl_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Ol pe hana lomonmona ngana mur pe Iuta mur te hele tele hel nge iri ke te teke tepoi poreke iri nai neu pe te tamal hune iri nga um. ");
INSERT INTO uvl_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Iok laol, Paulus iri nai Parnapas te eteia lo nge hana nemur te teke te poia poinga neu lala nge iri. Pomalam, te ua sapele ke tela nge Listra pe Tepi nga kileng nenge Likaonia. ");
INSERT INTO uvl_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Pe te hele hote NeHalang na helenga urana toto ngana nga tuele kina nem. ");
INSERT INTO uvl_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Iok, nga kileng nenge Listra, none tu. Non neu apena lul nga tana hoho ngana ia nike pe i rara ero toto. ");
INSERT INTO uvl_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Ana non are pe longo ke nek toto nga Paulus na helenga mur. Pe Paulus esia i pe eteia ke non nem letena manmanna toto. Ol pe teke hemasia i. ");
INSERT INTO uvl_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Iok laol, Paulus naula pengpeng nge non neu pe hele ke kerkereng toto lange i ke teke, “Apem kerkereng pe omes haka.” Ol pe non neu tamu haka pe talun ke irara sapele. ");
INSERT INTO uvl_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Pe hulua nemur, te esia ure neu nge lohot pe alngaria haka nga ria helenga nenge Likaonia ke te teke, “Ara soksoke ngana nai koi! Te hul ke iri non ke tesio at nge ita nei lo!” ");
INSERT INTO uvl_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Pomalam, te hetue Parnapas ke ene Seus pe Paulus te hetue ke ene Hemes. Iange i, i mukmuka nge iri ke haliu hotote NeHalang na helenga mur. ");
INSERT INTO uvl_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Iok laol, non nenge mene Seus hanna munna, mene pulumakau pe ae rorana mur ke laia nga kileng neu ana kue matana. Iange Seus na pele, te umeia ke rochroi mana nga kileng neu pe nge hot. Te teke te makia ure nemur ke pomanga ria tunginga nenge lange Paulus iri nai Parnapas. ");
INSERT INTO uvl_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Pe nga etue nenge Paulus iri nai Parnapas te longe, te tachach ia rea hengeron mur pe te song tele hulua nemur pe alngaria ke te teke, ");
INSERT INTO uvl_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Imo hana nemur, pomere nenge a teke a poia poinga nei at nge imem? Imem mo pomange imo mana. Pe imem hana mana ke pomange imo pule. Moat ke mo hele hot mene helenga urana toto ngana lange imo nenge mo teke a heto heke aetapuna mur ero pe a heto heke mene NeHalang i sipona nenge ala hote tapa pe ich pe ruach pe ure lochloch ngana nenge tetu teu nga ure nemur. ");
INSERT INTO uvl_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Nge nike, poia hehei pe hana lochloch ke tela nga lemeria ngana mana. ");
INSERT INTO uvl_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Pe i sipona teke hemallaha hot tote i ke teke manmanna toto nge i koi tu. Pomalam poia poinga urana toto ngana nenge tung sue pitte at nge ita pe poia ngaunga alona mur ke te haka pe tehei nga aria etue pengpeng. Pe pule poia ita ke ara ngaunga halang pe poia letera ke iech manmana.” ");
INSERT INTO uvl_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Paulus iri nai Parnapas te hele hote helenga nemur ke te teke, tepoi ele hana nemur pe ero. Hana nemur leteria kerkereng toto ke te teke te poia tunginga lange iri nai kura. ");
INSERT INTO uvl_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Iok, Iuta mur hel teat nge Antiok pe Ikonium. Iri, te ngai heke hehei pe hana ke tehul rumeria nge Paulus iri nai Parnapas. Pomalam, te tamalia Paulus ana um pe tehole hote lange hot. Pe iri, nga leteria te teke Paulus kou mete lo. ");
INSERT INTO uvl_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Pe ero. Iri nenge leteria manmanna nge Non Soke, teat ke te emurung hite Paulus. Ol pe ana non lohaka mule pe iteu langa kileng neu. Iok, poma nge rou Paulus iri nai Parnapas tela mule nga kileng nenge Tepi. ");
INSERT INTO uvl_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Iok, Paulus iri nai Parnapas te hele hote NeHalang nena helenga nge Tepi pe hulua leteria manmanna pe te koko teu nge iri nenge te nanasia Iesus. Ol pe Paulus iri nai Parnapas tela mule nge Listra pe Ikonium pe Antiok. ");
INSERT INTO uvl_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Pe te hele ke kerkereng toto lange iri nenge leteria manmanna ke tetu ke kerkereng toto nga leteria manmanna ngana mur. Pe te hele, “Nenge teke tateu langa NeHalang nena naualanga pe nekinga, lape tai rurung teu langa kileng chatala ngana mukam.” ");
INSERT INTO uvl_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Pomalam iri nai te henonou hote hana papalauna hel nga kileng nemur ke te mukaia iri nenge leteria manmanna nge Non Soke. Pe iri nai te hile ngaunga pe te hetalau aria pe te talue iri langa Non Soke nena naualanga. Iange iri leteria manmanna toto nge Non Soke. ");
INSERT INTO uvl_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Paulus iri nai Parnapas teteu langa tuele tana nenge Pisitia ke het pe tela nge Pampilia. ");
INSERT INTO uvl_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Pe nge Perka te haliu hote NeHalang nena helenga pe tesio la sapele nge Atalia. ");
INSERT INTO uvl_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Pe nge Atalia, te haka nga imot pe tela sapele nge Antiok nga kileng nenge te talune aria ume ia. Pe nga etue nenge te talune aria ume, hehei pe hana lamau te hetalaulau aria ke kerkereng toto ke NeHalang tunge poinga urana ngana lange iri kela het nga etue nenge te heulo hot mule aria ume neu. ");
INSERT INTO uvl_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Iok, nga etue nenge te lohot mule nge Antiok, Paulus iri nai Parnapas te eukiraua hehei pe hana lochloch pe te hele hote ure lochloch ngana nenge NeHalang poia ke pengpeng nge hana lomonmona ngana mur ke leteria manmanna. ");
INSERT INTO uvl_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Ke pomalam, iri nai tetu ke mala toto lamau luluch nge hehei pe hana nenge leteria manmanna nge NeHalang. ");
INSERT INTO uvl_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Iok, hana hel nge Iuta tela nge Antiok pe te talun sapele ke te hetore hana lomonmona ngana mur nenge leteria manmanna nge Iesus. Pe te hetore iri ke mai, “Imo, lape NeHalang mene mule imo ero toto iange te riria imo ero. Nenge teke lememo nge atu ke a maul, iok lape teriria imo ke pomanga hotonga nenge Moses hetoro ita ia.” ");
INSERT INTO uvl_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Pe Paulus iri nai Parnapas, te longe helenga nei pe ma ke nek nga iri nai leteria ero toto. Ol pe iri ul hana nemur te hele inin tau hel nga ure nei. Pomalam iri nenge Antiok te teke lape Paulus pe Parnapas pe hana hel tela nge Ierusalem ke te esia Iesus nena hana mur pe hana papalauna mur nga helenga nei. ");
INSERT INTO uvl_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Iok laol, iri nenge leteria manmanna nge Iesus nge Antiok te kulosia iri ke tela sapele. Pe tei ke tela nga kileng nenge Poenisia pe Samaria pe te nana urume hana lomonmona ngana mur nge leteria manmanna nge NeHalang. Pe helenga nei poia iri nenge leteria manmanna ke te iech toto. ");
INSERT INTO uvl_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Iok, tela te lohot nge Ierusalem pe Iesus nena hekulkulonga mur pe hana papalauna mur pe iri lochloch ngana nenge leteria manmanna nge Iesus te iech ele iri. Pe Paulus pe Parnapas pe hana nemur te nana urume ure lochloch ngana nenge NeHalang halaua iri ke te poia. ");
INSERT INTO uvl_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Iok, Parisio mur hel leteria manmanna nge Iesus. Pe iri te lohaka mule pe te hele ke te teke, “Hana nenge iri Iuta ero pe leteria manmanna nge Iesus, lape te riria iri. Pe lape ta hetore iri ke te nanasia hotonga nenge Moses.” ");
INSERT INTO uvl_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Iok, Iesus na hekulkulonga mur pe hana papalauna nemur te emurung ke te teke te hepeng hote helenga nei. ");
INSERT INTO uvl_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Te poia ana helenga ke lala ol pe Petrus mes haka pe hele, “Titik mur, imo a eteia lo ke NeHalang henonou hote iau nga tuna ngamo, ke e hele hote helenga urana toto ngana lange hana lomonmona ngana mur. Ke pomalam te longe pe leteria manmanna ia. Pe e talune ume nei ke mala toto lo. ");
INSERT INTO uvl_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Pe NeHalang nenge eteia hulua lochloch ramaria ume ngana, hetei hot pengpeng ia i lange hana lomonmona ngana mur ke hekulo sue Opepengpeng ke lange iri, ke pomalam mana nga nenge hekulo sue at nge ita. ");
INSERT INTO uvl_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","NeHalang poia iri ke manga poingana ia ita. Nenge leteria manmanna nge i, lape helemlem ia operia ke operia lemlem pule. ");
INSERT INTO uvl_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Pe imo heueu nei, a teke a totoia NeHalang. Iange a teke a poia hana lomonmona ngana mur nenge leteria manmanna ke singiria meena toto. Pe e hele pengpeng lange imo, rera tete mur nge nike pe ita heueu nei pule, nakura ero toto nge ta takisia ure meena ngana nenge pomanga nenge a poia nem. ");
INSERT INTO uvl_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","A longo ke nek, nenge teke letera manmanna toto nge NeHalang lape NeHalang mene mule ita ke pomange iri. Pe poinga nem lohot mana nga ara Non Soke Iesus letena poreke ngana pe lemene tau ngana ia ita.” ");
INSERT INTO uvl_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Ol pe hulua lochloch ngana nenge te emurung neu te reng toktok. Pe Paulus iri nai Parnapas te lohaka pe te hele hote ure papalauna nemur nenge NeHalang hekerkereng ia iri ke te poia pe hana lomonmona mur te esia pe leteria manmanna. ");
INSERT INTO uvl_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Iri nai te hele ke het pe Ieims lohaka pe hele, “Titik mur, a longo at nge iau! ");
INSERT INTO uvl_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simon hele hote lange imo lo, nga nenge teke NeHalang lemene taua hana lomonmona ngana mur pule. Ngana laka nenge hesilei hote hana hel nge iri ke i sipona nena hana mur. ");
INSERT INTO uvl_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Pe ure nenge lohot nei, lohot ke pomanga hetatalonga mur te hele ngaria ia nge nike. Nenge Non Soke hele ke teke, ");
INSERT INTO uvl_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","“‘Nga hoena lape eat mule pe Teuit na pele nei losio lo. Pe lape e hemes heke mule. Pe ure nemur nenge te poreke nga pele nei, lape eume heke mule iri ke nek pe etal mule iri nga muria mur. ");
INSERT INTO uvl_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Pomalam, hana lomonmona mur lochloch nenge iau lek non mur ia iri, lape te song ke teat mana nge iau. Iau, Non Soke, epoi hote ure nemur pe e hele ia ");
INSERT INTO uvl_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","ke te eteia nga halang nike lo.’” ");
INSERT INTO uvl_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Iok, Ieims lohaka pe hele mule ke mai, “Iau letek tuanin ke mai! E teke tanau pe hana lomonmona ngana nemur te teke leteria manmanna nge NeHalang, ita tapoi lange iri ero. ");
INSERT INTO uvl_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Pe e teke tahas mene alalaha e ke lange iri pe ta hele lange iri ke te ngaua ngaunga nenge tepoi tunginga ia lange aetapuna mur ero. Pe tema luluch nge hehei ero pe te ngaua huros nemur nenge te roke iri ero pe pule te inia toho ero. ");
INSERT INTO uvl_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Iange Moses na hotonga mur te haliu hotote nga NeHalang na pele mur nga kileng pe kileng. Pe te haliu hotote ke mala toto lo nga Sapat ana etue lochloch.” ");
INSERT INTO uvl_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Ol pe Iesus na hekulkulonga mur pe hana papalauna mur pe iri lochloch nenge te eukirau neu, te teke te henonou hote hana hel nge iri ke tela luluch nge Paulus iri nai Parnapas nge Antiok. Iok, te henonou hote Iutas (nenge ene e pule Parsapas) iri nai Sailas. Te henonou hote iri nai iange hulua nemur nenge leteria manmanna neu, tenau haka aria soksoke ngana mur nge iri. ");
INSERT INTO uvl_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Pe te hekule alalaha nei nenge hele ke teke; “Imem, Iesus nena hekulkulonga mur pe hana papalauna mur koi, mohas ia alalaha nei lange imo hana lomonmona mur nenge a tu nge Antiok pe Siria pe Silisia. Imem titimem mur laka imo iange letemo manmanna nge Ne Iesus. Uach pe miliko toto lange imo lochloch. ");
INSERT INTO uvl_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Imem mo eteia lo nge hana hel nge imem tela ke te poia imo ke ramamo au ala pe lemo arenga poreke toto ia reria helenga mur. Pe imem mo hele lange iri ke te poia poinga nem ero. ");
INSERT INTO uvl_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Pomalam mo eukirau pe mo henonou hote mele hel ke te mene helenga lange imo. Ke iri lape te koko luluch nge pekngara mur toto Paulus iri nai Parnapas. ");
INSERT INTO uvl_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Iange iri nai te matau singiria ero toto nga Non Soke Iesus Kristus nena ume mur. ");
INSERT INTO uvl_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Ke iri nenge mo kulosia at nge imo heueu nei, ngaria koi Iutas iri nai Sailas. Pe iri lape te hele lange imo pengpeng ke te hekerkereng ia helenga nemur nenge mohas sue iri nei. ");
INSERT INTO uvl_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Imem mo nanas mene Opepengpeng lemene ngana nenge mo teke a takisia ure meena ngana ero ol. Pe mo teke a nanas tau mene koi hotonga nemur; ");
INSERT INTO uvl_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","A ngaua ngaunga nenge tepoi tunginga ia lange aetapuna mur ero. A in toho ero pe a ngaua huros nemur nenge te roke iri ero. Pe pule, ama luluch nge hehei mur ero. Nenge teke a nanas tau tote hotonga nemur lape atu ngamo urana toto. Urana toto nge a olonge helenga nei pe atu malalom.” ");
INSERT INTO uvl_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Iok laol, iri nemur te lohaka pe tela sapele nge Antiok. Pe nge Antiok te eukiraua iri lochloch ngana nenge leteria manmanna pe te tunge alalaha neu lange iri ke tesisia. ");
INSERT INTO uvl_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Hulua nemur te sisia pe te iech toto iange helenga nemur nga alalaha neu hekerkereng ia iri nga leteria manmanna ngana mur. ");
INSERT INTO uvl_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Pe Iutas iri nai Sailas, iri hetatalonga pule. Pomalam te tunge helenga urana ngana mur nenge hekerkereng tote hulua nemur leteria. ");
INSERT INTO uvl_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Pe iri nai tetu ke mala pol nge Antiok. Ke het pe iri nenge Antiok tetal heke petanga nenga tunga nge nek lange iri pe te kulos mule iri ke tela mule nge iri nemur nenge te kulosia iri ke teat.  ");
INSERT INTO uvl_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Pe Sailas letena haka ke teke tunge Antiok ol. ");
INSERT INTO uvl_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Pe Paulus iri nai Parnapas tetu mana nge Antiok, pe iri ul hana hel pule ke te hetore hehei pe hana halang nga NeHalang na helenga, pe te hele hote helenga urana toto ngana nenge Non Soke. ");
INSERT INTO uvl_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Iok, etue hel nga hoena, Paulus hele lange Parnapas ke teke, “Lape ita nai tai ke tala mule nga kileng lochloch ngana nenge ta haliu hote Non Soke na helenga mur ia lo, ke tanau nga hehei pe hana tepoi ngaria.” ");
INSERT INTO uvl_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Iok, Parnapas teke mene Ioanes Makus ke iri ul. ");
INSERT INTO uvl_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Pe Paulus teke urana ero nge te mene i iange nga tele ngana reria ume het ero kura pe ua mule aria nge Pampilia. ");
INSERT INTO uvl_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Paulus iri nai Parnapas te hele inin tau helia ure nei ke halang. Pomalam iri nai te chach hel. Ke Parnapas mene Ioanes Makus ke iri nai te lohaka nga imot pe tela sapele nga kileng nenge Saipras. ");
INSERT INTO uvl_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Pe Paulus mene Sailas ke iri nai tei sapele. Pe iri lochloch ngana nenge leteria manmanna te hetalaulau aria ke te teke Non Soke tunge nena tunginga nge urana lange iri pe nauele iri ke nek. ");
INSERT INTO uvl_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Paulus langa kileng nenge Siria pe Silisia pe hekerkereng mule hehei pe hana mur nga leteria manmanna ngana. ");
INSERT INTO uvl_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Paulus langa kileng nenge Tebi pe Listra. Pe none nge ene Timoti tunga lamau pule. Pe ana non, iri ul tana leteria manmanna nge Iesus. Pe tana i Iuta pe temene i Krik. ");
INSERT INTO uvl_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Iri lochloch ngana nenge leteria manmanna nge NeHalang nga kileng nenge Ikonium pe Listra, te neue Timoti ke te teke i non urana ngana ia. ");
INSERT INTO uvl_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Iok, Paulus teke mene Timoti ke la luluch nge i pe Iuta mur te eteia ke Timoti temene i Krik. Pomalam Paulus riria Timoti singina ke Iuta mur te esia i ke manga i Iuta ol. ");
INSERT INTO uvl_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Iok laol, tei ke tela nga kileng mur pe te hele hote hotonga nemur nenge Iesus nena hekulkulonga mur pe hana papalauna nemur tetal hote nge Ierusalem. ");
INSERT INTO uvl_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Pomalam NeHalang nena hana mur temes ke kerkereng toto nga leteria manmanna ngana pe nga etue lochloch, hulua halang te hulia leteria pe te koko teu nge iri. ");
INSERT INTO uvl_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Iok laol, Paulus pe pekngana mur tela pe te sapele mana nga kileng mur nenge Prikia pe Kalasia. Iange Opepengpeng poi ele iri nge te hele hote NeHalang na helenga nga tuele kina nenge Eisia. ");
INSERT INTO uvl_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Iok, tei kela te lohot nga kileng Misia het ngana pe te teke teteu langa kileng nenge Pitinia pe Opepengpeng nenge Iesus poi ele iri iange kileng nem tu teu nga tuele kina nenge Eisia. ");
INSERT INTO uvl_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Pomalam te sapele mana ke tela nge Troas. ");
INSERT INTO uvl_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Iok, nga miliko Paulus nau opene ke esia none nge nena nge Mesatonia. Non neu mes pe hele ke kerkereng toto pe ech ia i ke teke, “O iat nge Mesatonia ke o halaua imem!” ");
INSERT INTO uvl_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Ke Paulus nau opene ngana neu het pe mo kik haka sapele nenge mola nge Mesatonia. Iange mo eteia ke NeHalang i sipona iua imem ke teke mola ke mo hele hote nena helenga lange iri nemur nga kileng neu. ");
INSERT INTO uvl_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Iok, mo tamu haka nga imot nge Troas pe mo song tele ke mola nge Samotras pe nga etue naingana mo song ke mola nge Neapolis. ");
INSERT INTO uvl_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Ke het pe moi nga apemem ke moteu lange Pilipai. Kileng Pilipai, i tuele tana nge Mesatonia pe Rom mur te ume heke pe tenau ele kileng nem. Oe, ke mo tuia etue hel nga lamau. ");
INSERT INTO uvl_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Pe nga Sapat ana etue, moi hot nga kileng neu ke mola nga ech ilina. Iange mo teke lape Iuta mur te eukirau nga lamau ke te hetalaulau. Iok, mo are sio pe mo hetore hehei hel nge te eukirau nga lamau. ");
INSERT INTO uvl_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Pe heie nge iri ene Litia. Ana hei nena nge Taiatira. Pe hehei pe hana tela ke teolol malmalenga mur nge i. Malenga nemur ururia haka toto. Ana hei heto hekeke NeHalang pule. Ke Non Soke i sipona poia i ke letena mallaha nga Paulus nena helenga mur. ");
INSERT INTO uvl_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Ke pomalam ana hei pe iri lochloch ngana nenge tetu luluch nge i nga na pele, te mene henuninga. Ke het pe hele ke teke, “Imo nenge a teke letek manmanna toto nge Non Soke, aiat ke atu luluch nge iau nga lek pele.” Hei neu ech tote imem ke mola nga nena pele. ");
INSERT INTO uvl_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Nga etue e moi ke mo lala nga kileng unne nenge te hetalaulau ia, pe mo saol haka nge heie nge uneinei tuteu nge i. Hei neu, mele hel te olia i ke umume nge iri. Pe te ololia i iange hele hot tettele ure nemur nenge te lohotot. Pomalam iri nenge tenau ele i, te mene umtutuna halang toto nga ana hei na ume neu. ");
INSERT INTO uvl_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Iok ana hei nanasia imem ul Paulus pe aliuliu ke teke, “NeHalang Nge I Soke Nga Lut Toto nena hana mur koi teii nei! Iri lape te hetore imo nga kue nenge NeHalang mene mule imo ia.” ");
INSERT INTO uvl_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Etue halang, hei neu helele ke machmau. Ol pe Paulus talngana pe letena inin pe ralele lange hei neu pe hele langa uneinei neu, “E hele lange iong, nga Iesus Kristus ene, o lohot nge hei nem ol!” Ueiuei mana pe uneinei neu ua hot sapele nge hei neu. ");
INSERT INTO uvl_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Pe iri nenge tenau ele hei neu te eteia ke reria umtutuna ana kue ero ol. Pomalam te laua Paulus iri nai Sailas pe te tak runge iri kela nga ingala matana pe te hemesia iri nga hana papalauna nemur nenge tenau ele kileng neu, mataria. ");
INSERT INTO uvl_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Iok, te mene iri lange hana Rom mur nenge te longlongo helenga pe te hele, “Hana nai nei iri Iuta koi. Iri teat ke te heporeke arenga nge urana nga kileng nei lo. ");
INSERT INTO uvl_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Iri te hetoro koukoua imem nga ure nemur nenge ita nenge Rom rera hotonga mur teheo ele tote nge ita ke ta nanasia ero.” ");
INSERT INTO uvl_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Iok laol, hulua te koko teu sapele nga iri nai aria palinga. Pe hana Rom nemur nenge te longlongo helenga te hele ke palinga hel ana hana mur te haka hote Paulus iri nai Sailas reria hengeron pe tenos ule iri. ");
INSERT INTO uvl_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Tenos poreke ule iri ke het pe tetal teu sapele iri langa tuele au ngana. Pe hana papalauna nemur te hele lange non nenge nauelele tuele au ngana neu ke chiu hit tote iri nai ke kerkereng toto. Pomalam iri nai ria kue ero toto nge te ua hot. ");
INSERT INTO uvl_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Non neu longe ke mau ol pe mene Paulus iri nai Sailas ke la tal teua iri nga tuel