﻿USE sofia;
DROP TABLE IF EXISTS sofia.uvh_vpl;
CREATE TABLE uvh_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES uvh_vpl WRITE;
INSERT INTO uvh_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Midi ka ya Kasira Aming Jisas ning papane arantagim wara'sining wap u tonga yarara' wara'ning. Ka Jisas ning papangni ki sini' wa Ebraham ka timinggi' sini' itarugu'. Ka Ebraham ning arantagim wari ira ababanga adining papangni nua'ni ka Devit wari ubu kadofigu'. Ka u kadofinga ira ababanga inga' sini' wa Devit ning arantagim wara'ganangsa' wa Kasira Aming Jisas wari kadofigu'. ");
INSERT INTO uvh_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Ka Jisas ning papane arantagim wari kadofinga ira abiging wara'ning wa ning, tim munumung sini' ka Ebraham wari Aisak ibegu'. Ka Aisak ning mindingni wa Jekop. A Jekop ning mindine wa Juda guk ka adining kuyane arantagim fam guk. ");
INSERT INTO uvh_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","A Juda ning mindine wa Peres guk ka Sira guk a adisining mamangsi' wa Tema. A Peres ning mindingni wa Hesron. A Hesron ning mindingni wa Ram. ");
INSERT INTO uvh_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","A Ram ning mindingni wa Aminadap. A Aminadap ning mindingni wa Nason. Nason ning mindingni wa Salmon. ");
INSERT INTO uvh_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmon ning mindingni wa Boas. Ka Boas ning mengni wa Rehap. A Boas ning mindingni wa Obet. Ka Obet ning mengni wa Rut. Ka Obet wari Jesi ibegu'. ");
INSERT INTO uvh_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","A Jesi ning mindingni wa Devit ka Juda ning king yagu'. A Devit ning mindingni wa Solomon. Solomon ning mengni wa taming ka tim Yuraia urang sangamgu' wang. ");
INSERT INTO uvh_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomon ning mindingni wa Riaboam. Riaboam ning mindingni wa Abaisa. Abaisa ning mindingni wa Esa. ");
INSERT INTO uvh_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Esa ning mindingni wa Jihosafat. Jihosafat ning mindingni wa Joram. Joram ning mindingni wa Asaia. ");
INSERT INTO uvh_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Ka Asaia adibu Jotam ibegu'. A Jotam ning mindingni wa Ehas. A Ehas ning mindingni wa Hesekaia. ");
INSERT INTO uvh_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hesekaia ning mindingni wa Manasa. Manasa ning mindingni wa Emos. Emos ning mindingni wa Josaia. ");
INSERT INTO uvh_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Ka Josaia ning mindine wa Jekonaia guk ka adining kuyane arantagim fam guk. Kama ka wara'ganang wa Babilon wari Isrel aming iyung kane kagaya slev titi ga' Babilon yongga' inagira aging. ");
INSERT INTO uvh_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Ka adi u inagira anga Babilon yong u ira Jekonaia wari Sialtiel ibegu'. Ka Sialtiel ning mindingni wa Serababel. ");
INSERT INTO uvh_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","A Serababel ning mindingni wa Abaiat. Abaiat ning mindingni wa Elaiakim. Elaiakim ning mindingni wa Eso. ");
INSERT INTO uvh_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Ka Eso ning mindingni wa Sedok. A Sedok ning mindingni wa Ekim. Ekim ning mindingni wa Elaiat. ");
INSERT INTO uvh_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Elaiat ning mindingni wa Eliesa. A Eliesa ning mindingni wa Matan. Matan ning mindingni wa Jekop. ");
INSERT INTO uvh_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jekop ning mindingni wa Josep. Ka Josep ning tamni wa Maria, wara' Maria wari saba kabasi' Jisas u ibegu'. Ka Jisas wara'ning wapni wa Anutuning Kasira Aming ning anitam. ");
INSERT INTO uvh_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Ka Kasira Aming Jisas ning papane ning arantagim ka Ebraham ganang do yodanga abanga Devit ganang bigu' wa aming arantagim 14 ning. Abanga Devit ganang u yodanga Babilon aming Isrel aming Babilon yong do iyung kane kalabus tanga iikga' inagira aging wara'ganang undu' papane arantagim 14 ning. A Babilon yong u iya' ababanga Kasira Aming Jisas wari kadofigu' ganang undu' papane arantagim 14 ning wari kuma' kadofinga ira biinga ganang kadofigu'. ");
INSERT INTO uvh_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Ka Kasira Aming Jisas wari kadofigu' wara'ning wa ning, adining mengni Maria wa ami nua'ni wapni Josep u sangam waraga' ning tonga kuma' totangkanga kabiging. Ka Maria adi sangam tanga kubap dabik ko mo' ira yangagumu' ganang ka Anutuning mini unggo warisa' adining kaba ganang saba u tipkadofingaminga Maria adi kaba guk yagu'. ");
INSERT INTO uvh_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Ka adining ufini Josep adi aming kadapmang didimeng kareng yaranga tanga itarugu' wara' adi taming wari naro' ko ira kaba guk kuma' yagu' u kanga kagabi titiga' sura ning togu', ka na sirengsa' mo' kabotik, taming waraga' aming ning dasi'ganang megang ma nako' wara' na tafafera da'ning tanga kapmo'sa' kabotik, ning togu'. ");
INSERT INTO uvh_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Ka Josep adi sasuk ka taming u kagabi ga' kuma' tanga arengagu' ganang ka dama deramak tugu' ka Anutuning kunung aming ensel nua'ni wari afanga ning anigu', ai Josep ka Devit ning arangni gu taming Maria wari kaba guk ita' u karang wa Anutuning mini unggo warisa' tipkadofira' wara' gu u kanga kaba mamareng naknga kagabi mo' totang, mokngang sangam sa' te'. ");
INSERT INTO uvh_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Ka taming ka wari saba wa ami ibewa'. Ka gu wapni wa Jisas ning yore'. Ka wap Jisas wara'ning kini girii wa ning, adi kadofinga giranga ira ami taming yotangkayap tinga adisining kadagang ning mamareng wari ifakadaga guk mo' to', adi kareng gi' giri ikni' wara'ning wari kadofo', ensel wari ning anigu'. ");
INSERT INTO uvh_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Ka Anutu wari napa' u tipkadofonga tugu' wa tim ana profet aniinga profet wari midi kuma' tokadofigu' wara'ning bengni wari kadofonga tugu'. ");
INSERT INTO uvh_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Ka midi ka profet wari u tokadofigu' wa ning, “inga' taming sababa nua'ni wari ami guk ko mo' dera ganang kaba guk ira saba ami nua'ni ibewa'ga'. Ibeinga saba kabasi' ka wa wapni Emanyuel ning anini'ga'.” (Ka midi wap ka Emanyuel wara'ning kini wa Anutu wari indiganang ita'.) Tim profet wari togu' wara'ning midi wa ningsa'. ");
INSERT INTO uvh_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Ka Josep adi dama deramak u tanga marara ning tanga nasi' midi ka Anutuning kunung aming ensel wari anigu' unggungsa'yaranga tanga tamni Maria kabingamging u sangam ubu tugu'. ");
INSERT INTO uvh_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Sangama ning tanga kubap guk mo' dera yangagumu', naro'sa' ko ikinga tamni Maria wari saba u kagu'. Kanga ning tanga Maria wari saba ami u ibeinga Josep wari wapni Jisas ning yoku'. ");
INSERT INTO uvh_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Ka Maria wari saba kabasi' Jisas wa Betlehem yong ka kama tubo Judia Provins tara' u ibegu'. Kama ka wara'ganang wa Juda aming yaptatora ning girii ka Herot wari tanga mera yaptatoregu' wara'ganang ibegu'. Ibeinga ning tanga ia' inga' sasuk aming girisi ka bam yapkedanga tugu ning ka mayam de ararap tara' do abiging wari Jerusalem yong girii u abanga kadofiging. Abanga kadofinga aming ka Jerusalem yong ganang yaging u ning yangkaging, ");
INSERT INTO uvh_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","saba kabasi' inga'ni ka inga' Juda arantagim sidi saptatora wara'ning kadofigu' wa indeng ita'. Indi mayam de ararap aming ka indi adi kadofigu' wara'ning bam girii u kigedanga marara saba kabasi' u kanga mandakni' upmama mesisiringa tangam waraga' bam u yaranga abem ning toging. ");
INSERT INTO uvh_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Ka king Herot adi midi ka aming girisi wari abanga toging u naknga sasuk mimeng sini' tanga base tugu'. Abanga Jerusalem yong ning aming arantagim kabi'mo' dabiksa' adindu' midi ka u naknga base tanga yareging. ");
INSERT INTO uvh_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Ning tanga Herot wari midi ka u nakdidima sini' tonga Juda ning aming girisi arantagim ka pris girisi a Moses ning kadapmang tapni ning sasuk aming girisi ka Jerusalm yong ganang unggung u katiana midi ning yangkagu', ai Anutuning Kasira Aming ga' fatuguting wa yong ka indeng sini' kagadofi ga' fatuguting. ");
INSERT INTO uvh_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ka adibu ning aniging, mo' wa Betlehem yong ka kama tubo Judia tara' u kadofo'ga' ning fatugutam. Ka Kasira Aming wari indiganang kagadofi wara'ning wa indi midi nua'ni ka tim profet wari yoking wa kuma'sa' naknga ikitam. ");
INSERT INTO uvh_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Adi ning yoking, “aming ka Betlehem yong ka Juda ning kamaganang iking sidi ning sanotik, sidi Juda arantagim ning bining ganang wa aming girii guk mokngang ning guk mo' sukanting, mokngang sidiganang wa aming girii sini' nua'ni wari kadofinga aming girii tim iyak sini' ning ira naning arantagim Isrel sidi kafakafa tasapma saptatoro'ga',” midi ning yoku' u kanga fatugutam ning aniging. ");
INSERT INTO uvh_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Ka girii Herot adi midi ka u naknga iguk aranga ai aming girii wa nagasa' yang ning tonga kaba mamareng naknga ning tanga aming girisi ka mayam de ararap do abiging u katiana kapmo' fonga kukyapma ning yanggu', ai bam girii ka u toging wa dari sini' kadofiinga kaging. ");
INSERT INTO uvh_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Ning tanga aming wari midi tubobu u aniinga naknga midi mandaga' ka ning yanggu', ningwara' sidi anga Betlehem yong do kadofinga saba kabasi' u katua sini' tanga tubobu undu' didimengsa' ingging abani'. Abanga naninga nandu' anga kanga mandakna upma mesisiringa tangamok. ");
INSERT INTO uvh_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Ning ina ibiinga aging. Anganga kadapmang bining ganang bam girii ka tim kanga yaranga abiging u nua'bu katuaging. Kataunga ning tanga bam girii wari kadapmang yangtinting tanga tim ira ira auinga adi bam unggungsa' kanga nakedanga yaranga aging. Anganga Betlehem yong u kadofinga yak ka saba kabasi' guk ka mengbe guk wari yaging wara'ganang wa bam girii wari unggung ningsa' anga adenga aradagu'. ");
INSERT INTO uvh_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","U tonga kanga kabaksi' karengsa' naknga aging. ");
INSERT INTO uvh_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Anga kadofinga yak iyung bane u amanga kaging ka saba ginggiming udi mengni Maria guk mareiagumu'. U kanga kabaksi' karengsa' naknga mandaksi' upma midi karesi fam tonga saba kabasi' wara'ning wap bema areging. Ning tanga saba kabasi' waraga' kafakafa tangama adisining ari' ganang napa' karesi fam tanga senga aging u dunga manggara saba kabasi' waraga' kukngamging. Napa' ka u kukngamging wa napa' karesi ka napa' gol diding guk karesi wari tiging, a napa' ka kudip seinga kudugo mupmu kareng danga kadofi wara'ning abanga napa' sanda wel mupmu kareng sini' ning u kukngamging. ");
INSERT INTO uvh_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Ning tanga deking. Ka Anutu wari kadapmang ka tubo yaranga aging unggung tubobu anga Herot mo' anini waraga' aramak ganang yangsefi tugu'. U kanga marara adi yaksingga' tubobu wa kadapmang nua'ni ubu yaranga mugoging. ");
INSERT INTO uvh_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Ka sasuk aming girisi ka mayam de ararap do abiging wari kuma' marara mugoinga ka Josep wari dama dera aramak tugu' ka Anutuning ensel nua'ni wari ning anigu', Josep gu ingging mo' marekotang, gu mamarak tanga saba kabasi' Jisas imengguk i inagiknanga bima tanga kama kamani ka Isip ga' mani'. Anga Isip donggung ikanting. Ka tubobu mabu ga' undu' nagasa' saninga wara'ganangsa' mabani'. Herot adi saba kabasi' i ugumak ga' sura marara wena tota' wara' sidi mugo tinting. ");
INSERT INTO uvh_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Anutuning ensel wari ning aniinga Josep adi u naknga kama ko mo' fasangandagu' ganang gaa' sini' marara saba kabasi' Jisas imengguk u inagiknanga bima tanga Isip ga' mugoging. ");
INSERT INTO uvh_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Anga Isip do kadofinga Herot wari kumoinga ganang abubu wara'ganangga'sa' ira aging. Ka inga' adi u anga yaging waraga' wa timinggi' profet wari Anutuning midi nua'ni ka ning kuma' ituagu', na naning sabana kama tubo Isip u ikita' u katinganinga abara'. Ning tuguinga yoking wara'ning wari beng guk kadofigu'. ");
INSERT INTO uvh_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Ka Herot wari sasuk aming girisi ka mayam de ararap do abiging wari tubobu guk mo' anga aniging u kanga ning togu', o idi mandaga' ba naramira mugoging. Ning tonga kaba kadagang sini' naknga saba kabasi' Jisas u uuk ga' sura aming fam u ning ina yangkaregu', sidi Betlehem yong do anga Betlehem yong a yong kababi' fam ka wara'ning du' ikyangaking u yangara saba ami kababi' inga'ni ka guraksi' kubanik a fama' ningsa' iking wa dipmasasu'na tanga yaranting. Ka Herot adi sababi' ning gurak wap ka u yanggu' wa tim mayam de ararap aming yangkainga bam girii kaging wara'ning ki ga' aniging u tanga ibeyapking wara'ning u didimeng kuma' sura ungungsa' didipmi ga' ina yangkaregu'. ");
INSERT INTO uvh_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Ka kadapmang ka king Herot wari saba kababi' u didipmi ga' togu' waraga' wa tim midi tokadofi aming profet Jeremaia wari togu'. Wa ning togu', ");
INSERT INTO uvh_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Rama yongganang wa taming wari mak kaking u nakem, Resel ning mindine kuma' kumakngamsasu'neinga adi waraga' bibiri' naknga maksa' fagata'. Ka aming wari yotangkangam tantam ning tonga ting ka mokngang, adi bibiri' siamo' naknga mak ningsa' ko fagata'.” Ning tuguinga yoking u fiderugu' wari beng guk sini' kadofigu'. ");
INSERT INTO uvh_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Ka Josep kurene wari Isip unggung ko ikinga king Herot udi kuma' kumogu'. Wara'ganang ka Josep wari dema dera aramak tugu' ka Anutuning kunung aming ensel nua'ni wari Josep u ning anigu', ");
INSERT INTO uvh_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","ai Josep, aming ka saba kabasi' i uuk ga' sura ikiting udi kuma' kumaking wara' gu mamarak tanga yong ka i kabinga saba kabasi' Jisas imengguk i inagiknanga Isrel aming sidaning kamaganangga' tubobu manting ning anigu'. ");
INSERT INTO uvh_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Ning tinga Josep wari u naknga saba kabasi' Jisas imengguk u inagiknanga Isrel anasining kamaganangga' tubobu mabiging. ");
INSERT INTO uvh_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Abanga kadofinga naking ka aming fam wari ning yangging, kama tubo Judia ning Herot wa kuma' kumakinga adining gipmam wa mindingni Akeleas adibu bema tanga mareta' ning toging. Ka Josep adi Akeleas wari beni ning kama gipmam bema tanga mareiagu' u naknga saba kabasi' Jisas ma uknamni' ning tonga mutu tanga ai, indi kama tubo Judia tara' ingging mo' ikantam ning togu'. Ning tanga Josep wari dama dera aramak tugu' ka Anutu wari midi ka yong ka adi anga iik waraga' u anatintingnegu'. Ning tinga adi marara kama tubo Judia tara' wa tatarafik sa' tanga kama tubo Galili Provins tara' waraga' ubu mugoging. ");
INSERT INTO uvh_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Anganga Nasaret yong ka kama tubo Galili tara' u kadofinga ning tanga unggung wadigi' ikiaging. Ning tinga midi nua'ni ka timinggi' profet arantagim wari Jisas waraga' toging wari beng guk sini' kadofigu'. Ka adi midi ka wa ning toging, adi Nasaretni aming ning anini'ga' ning toging. ");
INSERT INTO uvh_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Ka kama ka Josep kurene wari Nasaret yong u kuma' anga yaging ganang ka aming ama iyam ning ka wapni Jon wari kama bining sigesa' ka aming yong guk mokngang ka Judia tara' u anga ira midi tokadofi kane tanga yagu'. ");
INSERT INTO uvh_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Ka Jon wari midi ning tokadofigu', ai, aming wari Anutuning bining kareng ganang iik wara'ning kama wa kuma' kadofonga tara' yang. Ka aming dabiksa' sidi kabaksi' faranga kadagang tanga iking u kabisasu'na tini' ning fainarugu'. ");
INSERT INTO uvh_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Ka timinggi' midi tokadofi aming profet Aisaia wari Jon ga' wa midi ning kuma' tuguinga yoking, “ka aming nua'ni kama sigesa' ganang adenga ku ning katira', ai aming sidi girii wari abubu wara'ning kadapmang wa kafakafa kagaranga tipdidimanga yarani' ning togu' u yoking.” ");
INSERT INTO uvh_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Ka Jon Baptis wari midi u tokadofinga tanga itarugu' wara'ning iikni wa ning, adining kwi'ni paramu' ka kangkama tanga fatarugu' wa maga kamel ning dumni wari tanga muntofiging u kaminga ning tanga kwi' u tamtangka wara'ning aya letni wa maga bulmakau ning giknim wari tamtangkanga ning tanga fatarugu'. Ka adi nana undu' kareng mo' fanarugu', mokngang nanani wa gitara' ka nana tiaging a nimi' ameng ning unggungsa' manggara nanga ira fatarugu'. ");
INSERT INTO uvh_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Ka Jon wari midi u ituainga ami taming kabi'mo' ka Jerusalem yong girii u ikiaging a aming ka kama tubo Judia tara' wara'ni abanga aming ka Jodan ama gaga tara' ira yariaging wari adining midi u naknga abanga fakaiaging. ");
INSERT INTO uvh_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Abanga ning tanga adisining kadagang u Jon ga' sireng sa' ituangamsasu'neinga Jon wari Jodan ama u wara'ganang faimgu'. ");
INSERT INTO uvh_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Ka Juda ning aming girisi ka Farisi a Satyusi arantagim adisining aming fam undu' Jon wari ama iyam ga' sura fabiaging. Ka Jon wari u yapma ning ifang fainarugu', aming ka sidi kabaksi' sini' mo' faranga abing. Abanga ning sabarik ka sidi gimik kadagang ning mindine arantagim ka midi mandaga' tutugusi. Sidi mamareng ka inga' Anutu wari ami taming ka kadagang guk u didipmi ning wari sidiganang mo' kadofisam waraga'sa' sura wa ama isam ga' abing yang. ");
INSERT INTO uvh_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Ka i nakni', aming ka Anutu wari inga' aming ga' mamareng iyam u tarafaronga wa kaba beng sini' faranga kadapmang kadagang u kabisasu'nanga kadapmang karengsa' ubu tota'. Sidi kadapmang kareng sini' tipkadofanting wa ami taming wari u kanga sidi kabaksi' beng sini' faring wara'ning ki u sireng sini' kanting. ");
INSERT INTO uvh_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Ka sidi ning unda' sura abing, a indi aming didimesi karesi Ebraham ning papane, indi kabakni' nua'bu tipfara ning guk mokngang. Ka sidi wap ka Ebraham ning arantagim warisa' wa yotangkasap titining napa' kigineng ning sukiting waraga' wa ning torik, sasuk ka wa beng guk mokngang. Beng sini' ning sanotik, Anutu wari sidi tarakayosapma sidining gipmam bema arantagim inga'ni ka wap ka Ebraham ning arantagim wara'guk iik waraga' sura wa adi siasa' tanga napa' sige ka uningkim i ininga Ebraham ning arantagim ubu girisa' kadofinga ikanting. ");
INSERT INTO uvh_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Ka beng sini' Anutu adi firi mindip nananing wara'ning ki u ke ganang sini' doptaunga fununggong bema firi ki ganang unggung kuma' adera'. Firi ka beng kafakafa mo' tinga wa adi dindini tanga kudip ganang sawa'ga'. ");
INSERT INTO uvh_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Ka naga ama i isamarik yara'ning kini wa ning, sidi midi ka naga u tokadofirik u naknga kabaksi' faranga sidining kadagang u kabinga kadapmang didimeng ganang iik waraga' isamarik. Ka na ama sini' warisa' isamarik. Ka aming nua'ni ka mandang inga' abota' adi napa' kigineng kareng ka Anutuning mini unggo sini' ka kudip da'ning wari isaminga aming didimesi arantagim ning ubu ikanting. Ka adi aming sige naga ningyara' mo, adi aming girii sini' kigineng guk, naga ningyara' wari adining du'ganang iikning guk mokngang sini'. ");
INSERT INTO uvh_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Ka aming girii ka u torik wa adi aming tagagareyap kane ka aming wari wit mindip urang tagagareting ningda'ning tonga tugunung tanga sabol kafong ganang kuma' bema adera'. Adi wit mindip ka kuma' dopma kuking u sabol wari gira manggara gugubik ganang igukinga gugubik wari tutufuru u figira igukinga beng karesi unggungsa' manggara yak ganang urang dasiting ninda'ning tota'. Ning tanga tutufuru wa kudip kagaya ka bibi' titining guk mokngang wara'ganang seinga wadigi' dasasu'ninting ning yanggu' Jon wari. ");
INSERT INTO uvh_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Ka Jon wari aming ama u faimarugu' ganang ka Jisas adindu' Jon wari ama ingam ga' sura kama tubo Galili u kabinga marara kama ka Jon wari aming ama faimarugu' Jodan tara' waraga' agu'. ");
INSERT INTO uvh_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Anga kadofiinga Jon wari Jisas u kanga ning anigu', ai gu naga ama igam ga' abanga torang. Ka naga ningyara' wari gu igam ning guk mokngang, gu naga inamotang wa giri didimeng. ");
INSERT INTO uvh_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Ka Jisas wari ning anigu', wa beng guk torang de ka kami yara'ganang wa gundu' girisa' inamotang. Na Anutuning sasuk dabiksa' wa yaranga tasasu'na sa' totik wara' ama inam ning kadapmang undu' titisa' totik. Jisas wari ning tuguinga Jon wari adining midi u nakngama ama ingamgu'. ");
INSERT INTO uvh_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Ka Jon wari ama u ingaminga Jisas adi ama u kabinga gaga aranga adegu'. Adenga kagu' wa kunim wari tubo kidagang tanga Anutuning mini unggo ka yang mimbep da'ning wari didimeng ka Jisas ana adegu' ganang afanga Jisas ganang u meku'. ");
INSERT INTO uvh_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ning tinga midi nua'ni ka kunim ganang kuta kadofigu' wa ning togu', ya naganing sabana kareng na adining kadapmang u karengsa' kanga adita' siamo' nakitik ning togu'. ");
INSERT INTO uvh_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Ka Jon wari ama u ingama kabiinga Anutuning mini unggo wari Jisas u aming kadagang Setan wari mandaga' taramira kadagang titiga' andadide waraga' kama bining sige ka aming yong guk mokngang waraga' nagira agu'. ");
INSERT INTO uvh_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Ka Jisas adi kama bining sige wara'ganang wa kama paramu' sini' ka tiim sidii 40 ning ira agu'. Ka adi kama paramu' ka u yagu' wara'ganang wa adi nana guk mo' nanga sigesa' ira agu' wara' adi segi kagaya sini' naknga yagu'. ");
INSERT INTO uvh_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Ka aming kadagang Setan wari Jisas wari kadagang titiga' ning tonga mandaga' taramironga kadofinga ning anigu', ai gu Anutuning mindingni tangkunang guk, ka gu seka nakarang wa midisa' tuguinga uningkim yari nana igikaminga naya'. ");
INSERT INTO uvh_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Ka Jisas wari ning anigu', mokngang na ning guk mo' totik. Anutuning midi ka tim yoking wa ning tuguta', aming wari damdang naknga iik wara'ning ki wa nana warisa' mo' tanga ikiting, mokngang adi Anutuning midi naknga ning tanga wa kigineng guk ira ka' ningsa' ikiting ning yoking. ");
INSERT INTO uvh_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Ka Jisas wari midi ka u tuguinga Setan wari nua'bu taramikonga Jisas u nagira anga Jerusalem yong girii u kadofinga siring yak girii tempel wara'ning furo'ning sini' kura aranga adenga ");
INSERT INTO uvh_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Jisas u ning anigagu', gu Anutuning mindingni sini' udep wa i adenga aramping tanga kamaganang apa mangfanga kagaya kabi'guk mo' bemotang u gabotik. Ka gu kuma'sa' nakarang, waraga' Anutuning midi wa ning yoking, “Anutu wari adining kunung aming ensel u yangkareinga wari kuma' abanga yotangkagapmanting. Abanga adi kuma' surogabinga uningkim fasi' ni wari kaaga kabi'sini' guk mo' gorota' ning yoking waraga' sure'.” ");
INSERT INTO uvh_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Ka Jisas adibu ning anigu', mokngang na ning guk mo' totik. Tim Anutuning midi nua'ni undu' yoking wa ning, gu guning Anutu girii wa napa' ka adi mo' titining u titiga' mo' sura anidideutang mokngang, ning yoking ning anigu'. ");
INSERT INTO uvh_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Ning tanga Setan wari nua'bu taramikaunga Jisas u nagira kama bubo girii nua'ni waraga' ubu agumu'. Anga kadofinga kama bubo girii wara'ganang aranga adenga Setan wari kamaganangni aming arantagim kuni' kuni' dabiksa' ikiting a adisining mambongsi' girisi girisi a adisining tangkunangsi' u kafadudu yora anatintingnanga yaranga ");
INSERT INTO uvh_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","ning anigu', napa'napa' ka u defata' yabarang wa na guta' gamsasu'na wara'ning. Ka gu nagata' mandaka upma mesisiringa tanamotang wa napa'napa' u ibigamsasu'notik. ");
INSERT INTO uvh_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Ka Jisas wari Setan u ning anikagaregu', a Setan uri mugo te'. Kadapmang ka mesisiringa titi wara'ning ka timinggi' kuma' yoking u fideta' wa ning, gu kane a mandaka upma mesisiringa wa Anutu girii kubanik waraga'sa' tangamotang ning yoking. ");
INSERT INTO uvh_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Jisas wari ning tuguinga aming kadagang Setan wari Jisas u kabinga mugoinga Anutuning kunung aming ensel arantagim wari afanga Jisas u yotangkangama ning tanga adeging. ");
INSERT INTO uvh_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Ka Jisas adi midi ne ka Jon Baptis u kalabus iyung kuma' bema dasiging wara'ning u kuma' naku'. Ning tanga marara kama tubo Galili tara' waraga' ubu mugogu'. ");
INSERT INTO uvh_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Ka adi u anga kadofinga wa ananing yong ki Nasaret u mo' anga yagu', mokngang adi Nasaret wa tatarafik sa' tanga anga Kapaneam yong ga' agu'. Ka Kapaneam yong wa Galili gwang gaga ganang, ka kama dibing ka wa Sebyulan guk ka Naftalai guk adisining papase arantagim wara'sining kama waraga' mugogu'. ");
INSERT INTO uvh_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Ka Jisas wari yong ka u mugogu' waraga' wa midi ka tim profet Aisaia wari tuguinga yoking wari beng guk kuma' kadofigu'. Ka adi midi ka wa ning yoking, ");
INSERT INTO uvh_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“aming ka Sebyulan ya Naftalai ya sidi kama ka Jodan ama tubo do ning tara' ka kadapmang ka gwang girii ga' yaranga mugoting, abanga sidi Galili tara' wara'ning dibing ka Juda mo' wari ikiting sidi ning sanotik, ");
INSERT INTO uvh_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","aming arantagim ka gaa' kangkam ganang ikiting sidi inga' diok kareng girii kuma'sa' kaing. Aming arantagim ka kungkumak ning kadapmang kadagang yaranga ikiting sidi diok ka wari kadofinga kadapmang dioksangandasaminga sangang sa' ubu denga karengsa' iking, ning togu' u yoking.” ");
INSERT INTO uvh_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Ka kama ka wara'ganang Jisas wari Kapaneam yong u kadofinga Anutuning midi kareng u munumung sini' tokadofigu'. Ning ina yaregu', ai aming wari Anutuning bining ganang iik wara'ning kama wa kuma' kadofonga tara' yang. Ka sidi kabaksi' faranga kadagang u kabisasu'na tini' ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Ka Jisas wari Galili gwang gagu u yaranga agu'. Anganga yapku' ka aming fama' iguyangguk Saimon wapni nua'ni Pita guk ka kuyangni Andru guk wari kanesi' ka ama ging mamanggak ning tiagumu' u gwang wara'ganang umben kaminga fiaregumu'. ");
INSERT INTO uvh_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","U anga yaptuanga Jisas wari ning yanggu', ai aming fama' sidi ama ging wengmanggak kane ba titamu', ka ningwara' kane ka wa kagabi tanga nagok kubap manam. Ning tinga nagabu kane ka naning aming arantagim ka ama ging u manggakitamu' ningda'ning tanga inagikdemu' waraga' ubu sanggerotik. ");
INSERT INTO uvh_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Ning ininga aming fama' iguyangguk adi Jisas ning midi u naknga ninak sa' tanga adisining kane u kabinga Jisas u yaranga adigok kubap mugoging. ");
INSERT INTO uvh_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Ning tanga inagira gwang gaga u kabi'ning nua'bu yaranga anganga yapking ka Jems iguyangguk Jon ya udi babangsi' Sebedi guk bot ganang mera umbensi' u fatipdidimaging. U fonga yaptuanga Jisas wari aming fama' iguyangguk u adigok kane kubap tanga iik waraga' katianggu'. ");
INSERT INTO uvh_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Katianinga adi Jisas ning midi u ninak sa' tanga marara babangsi' Sebedi wa bot ganang unggung kabinga ning tanga kanesi' u wadigi' sini' kabinga marara Jisas guk kubap ubu aging. ");
INSERT INTO uvh_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Ka Jisas wari kama tubo Galili tara' wara'ning yong yong u yangara adisining siring yaksi' ganang amanga Anutuning midi kareng ka kama ka aming wari Anutuning bining ganang iik wari kagadofi wara'ning u ituaima yaranga ning tanga aming ka bagana kadagasi kuni' kuni' guk undu' ifakarenda ning tanga yaregu'. ");
INSERT INTO uvh_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Ning tinga midi ne ka Jisas wari kane kigineng u tugu' wara'ning wari kama tubo Siria tara' u dabiksa' feradanga mugoinga naknga yareging. Ning tinga aming kama tubo wara'ni wari midi u naknga amise bagana kadagasi guk a mamaresi kuni' kuni' ka aming masi' unggo kadagasi guk ibap amamosi a bagana ka aming wari kungkumak tanga masi' fe titiing ningwara' u inagira auinga Jisas wari dabiksa' ifakarendasasu'negu'. ");
INSERT INTO uvh_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Ning tinga ami taming kabi'mo' ka kama tubo Galili tara' a kama tubo Dekapolis tara' a Jerusalem yong girii tara' a kama tubo Judia tara' a Jodan ama fugung do ning tara' wara'ni dabiksa' wari Jisas ning kane kigineng u kanga kadidima sini' tonga ko yaranga fengakiaging. ");
INSERT INTO uvh_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","2","Ka Jisas wari ami taming arantagim girii kabi'mo' wari yaranga fengaging u yapma iibi tanga ananing arantagim sini' ungungsa' inagira anga kama bubo nua'ni ganang areging. Aranga kadofinga mera Jisas wari midi kareng yanggeronga ning yanggu', ");
INSERT INTO uvh_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“ka kadapmang ka aming kamaganangni wari mambong a wap girii wara'guk iik wa karengsa' ning urang kating wa na kadapmang nua'ni katik. Wa ning, aming ka kabaksi' ganang tangkunang guk mokngang ning sura ikiting wa karengsa' ning torik. Aming ka ningwara' wa Anutuning bining ganang iik wara'ning. ");
INSERT INTO uvh_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","A aming ka adisining kadagang ga' mamareng naknga ikiting wa karengsa' ning torik. Aming ka ningwara' wa Anutu wari kaba kugurang kuma' imota'. ");
INSERT INTO uvh_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","A aming ka anasining sasuk a wapsi' bema afuting undu' karengsa' ning torik. Aming ka ningwara' wa Anutu wari napa' kareng girii sini' kuma'sa' kabiamo'ga'. ");
INSERT INTO uvh_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Abanga aming ka Anutuning kadapmang didimeng kareng ga' siamo' ninak ka aming wari masi' pamparanganga ama topna ga'sa' urang nakiting ningda'ning tanga ikiting wa karengsa' ning torik. Nasi' ka adi bemna ga' sura sasuk mimeng titing wa Anutu wari didimengsa' iminga tangkunang ubu kuma' naknga ikanting. ");
INSERT INTO uvh_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","A aming ka aming nua'ni wari kadagang tangaminga kadagang kura' tubobu mo' tiamiting wa karengsa' ning torik. Inga' Anutu wari undu' aming ka tubobu guk mo' tiamting wara'siga' wa tubobu guk mo' tiamo'ga'. ");
INSERT INTO uvh_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","A aming ka sasuksi' ka kadapmang kareng waraga'sa' titing wara'siga' undu' karengsa' ning torik. Inga' adi Anutu guk iik wara'ning. ");
INSERT INTO uvh_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Abanga aming ka aming fam ning kabaksi' kagaya ifakureting wara'siga' undu' karengsa' ning torik. Inga' Anutu wari ananing mindine arantagim ning manggara kukyabo'ga'. ");
INSERT INTO uvh_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","A aming ka kadapmang didimengsa' tinga aming fam wari waraga' bibi' naknga mamareng imiting wara'siga' wa karengsa' ning torik. Aming ka ningwara' wa iik kareng sini' ka Anutuning bining ganang iik wara'ning. ");
INSERT INTO uvh_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Beng sini' sidi nagata' naktangka tanga kadapmang karengsa' yaranga ikanting ka aming fam wari u sapma midi sangkige tanga aroksam sige tanga napa' mamareng fam saramikanting undu' giri karengsa' ning torik. ");
INSERT INTO uvh_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Ka napa' mamareng ka u saramikanting wa kami sidita'sa' mo' tasamting, mokngang wa profet arantagim ka timinggi' Anutuning midi tokadofi kane tanga ira abinging undu' adi ningsa' iramikiaging. Beng sini' Anutu wari profet u yotangkayapku' ningsa' sidindu' kuma'sa' yotangkasabota'. Ka sidi sasuk ka inga' Anutu wari kunim yong ganang napa' kareng tasam waraga' suktangkanga ira mamareng bema wa kabaksi' kareng naknga mesisiringa sa' tanga ikanting.” ");
INSERT INTO uvh_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Ka naktangka aming sidi ami taming ning bining ganang ira sidining iiksi' wa kadapmang ka didimeng karengsa' titining u tanga firing marang guk ningda'ning kareng ikanting. Wa ning, firing ning kaneni wa nana a didik u tipmaranda wara'ning, ka sidindu' aming fam ning kabaksi' ifikarenda wara'ning ning ikanting. Ka firing ning marang wari bibi' tota' wa firing anasa' marang guk nua'bu iik ning guk mokngang, wa marangni kuma' binga wadigi' kuma' gigimera' wara' wa sige kura igukinga aming wari kama sa' ba ning tonga tipminga yangating. Ka sidindu' ningsa', sidi kadapmang kareng tanga aming ning kabaksi' ifikarenda wara'ning wara' sidi iiksi' ganang wa firing marang guk ningda'ning ira tinting. ");
INSERT INTO uvh_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Abanga sidi ami taming ning bining ganang wa sidi kamang diok kareng ningda'ning iking. Ka wara'ning wa ning, yong girii nua'ni ka kama bubo ganang adeuta' wa tiim ganang yong wara'ning kamang diok wa kapmo' guk mo' adeta', mokngang wa sireng sa' kuma' tonga kating. ");
INSERT INTO uvh_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Abanga aming wari lam yora gareting undu' ningsa'. Adi lam u yora garanga wa napa'ni wari tungkum tanga kapmo' mo' sebiting. Mokngang adi sirengsa' tabinga kamang diok wari yak iyung bane u diokinga sangang sa' adeting, ning titing. ");
INSERT INTO uvh_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Ka sidining iiksi' ganang undu' ningsa'. Anutuning tangkunang wari sidining kabaksi' ganang diok ningda'ning ita' wara' sidi aming ning bining ganang ira kadapmang didimeng kareng tiaminga diok u kanting. Ning tinga adi diok ka wari yangtintingneinga Anutuning kadapmang kareng u kigedanga kabaksi' kareng naknga babangsi' girii Anutu ka kunimganang ikita' waraga' mesisiringa tangamting.” ");
INSERT INTO uvh_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Ka sidi naning midi i kuni' nua'ni ning naknga ning mo' suknamting, a adi Anutuning kadapmang tangkunang ka Moses ga' tim amigu', abanga Anutuning midi ka timinggi' profet wari ituaging u ufafenga kadapmang inga'ni sa' tipmarak ga' unda' abugu'. Mokngang na midi a kadapmang tang timini u ufafe waraga' mo' abuguk. Na naning kadapmang inga'ni kigineng guk u tipmarakinga kadapmang tang a midi ka tim toging u tiptangkainga wari beng guk kagadofi waraga'sa' abuguk. ");
INSERT INTO uvh_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Beng sini' kadapmang tang ning midi a Anutuning midi fam ka tim u ituaging wa bibi' titining guk mokngang sini', kama a kunim wari ko ira auta' ganang undu' kadapmang tang wara'guk ka wara'ning midi dibing kababi' fam dabiksa' wa ni ka bibi' guk mo' to'ga' mokngang sini', wa tangkunang ko ningsa' ira anganga Anutu wari nasi' kane ka kadapmang tang wari titiga' tuguta' u tasasu'na wara'ningsa'. ");
INSERT INTO uvh_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Wara' aming ka ni wari midi tang wara'ning kadapmang dibing kabi'sini' ka ni tatarafik tanga aming fam yanggera midi ka a kadapmang dibing kabi'sini' ka wa indi kagabi tem wara' sidindu' girisa' kabinting ning inota' wa inga' kama ka aming wari Anutuning bining ganang iikning wari sireng kadofo' ganang wa Anutu wari aming ka ningwara' wa adining bining ganang anga iikning guk mokngang ning kawa'ga'. A aming ka kadapmang tang wara'ning bang bang fam u didimengsa' yarasasu'nanga aming fam undu' didimengsa' yara waraga' yanggerota' wa adi didimeng tara' wara' Anutuning bining kareng ganang wa adi wap girii guk irota'. ");
INSERT INTO uvh_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Ka kadapmang tang wara'ning sasuk aming girisi a Farisi arantagim adi ning fatuguting, o indi Anutuning kadapmang yaranga didimengsa' beng sini' tanga ikem. Ka na ning torik, mokngang kadapmang ka adi u titing wa Anutu adi kareng sini' mo' kata'. Ka sidi adi u titing ning mo' tinting, sidi kadapmang kareng nua'ni sini' ka Anutuning bining ganang iikning unggungsa' tinting.” ");
INSERT INTO uvh_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Ka sidi midi tangkunang nua'ni ka tim Moses wari papase yanggu' wara'ning u kuma'sa' nakiting. Wa ning yoku', gu aming mo' ura sebotang. Aming ka aming ura sebota' wa aming fam wari midi kigineng kot wara'ganang kaminting ning tuguting. ");
INSERT INTO uvh_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ka naganing kadapmang wa nua'ni ka kigineng sini' ka Moses ning midi kadapmang u tarafita'. Wa ning, aming midi ganang kangkami ning wa aming ka aming ning fugu ugumarota' unggungsa' mo', mokngang aming ka kuyangni ga' nakadangam ka kaba mang ganangsa' tota' undu' Anutuning kot kigineng ganang adeuta'. Abanga aming ka kuyangni nua'niga' kaba kadagang naknga anikadaga tota' undu' midi kigineng ka wara'ganang adeuta'. A aming ka kuyangni nua'niga' kaba kadagang naknga midi kadagang sini' anikigeuta' wa adining kadagang wara'ning mamareng kura'bu bimbem ning wa kudip kadagang ganang mugo wara'ningsa'. ");
INSERT INTO uvh_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Wara' sidi ning nakanting, sidi kuyasi' nua'niga' kabaksi' kadagang nakngama wa tipdidima tinting. Ka kadagang u tipdidima ning kadapmang nua'ni wa ning, gu Anutuga' sura adita' napa' ofa tanga sangamonga siring yak girii ganang amanga napa' ofa tanga sasa wara'ning alta ganang sini' kuma' kadofinga aradeutang, ka gu tim kuyaga ga' napa' kadagang ni guk tangamotang waraga' tubobu suknatama wa o Anutu wari naning kadagang i kanga ofa i mo' ma bemo' ning tonga ");
INSERT INTO uvh_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","ofa u ningsa' kabinga tubobu anga tim ka kuyaga wara'guk kadagang u tipdidimanga kabaksi' kubaniksa' kuma' kufara ning tanga abanga ofa wa inga' wara'ganang totang wa kadapmang didimengsa' totang. ");
INSERT INTO uvh_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Ka aming nua'ni wari kuyangni nua'niga' kadagang tangamota' u tipdidima wara'ning kadapmang nua'ni wa ning, gu aming nua'niga' napa' kadagang tangamotang ka adi waraga' kaba kadagang naknga midi kot ganang gipmonga ginagira auta'. Ka gu midiganang do ko mo' kadofinga kadapmang bining ganang mamareng u tipdidima ning kadapmang urapsa' kataunga tipdidima tantamu'. A gu ning urap mo' totang wa kot ganangsa' tonga gipmiinga midi nakdidima ning aming girii jas wari kot ning kadapmang sa' yaranga tanga plisman ga' iminga adibu bema tonga iyung dasigabinga gu iyung kane kagaya u tanga irotang. ");
INSERT INTO uvh_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Ka beng sini' kadapmang ka kot ganangga'sa' au ning wa mamareng u tipdidima ning guk mokngang, wa mamareng guk. Adi guning kadagang ning to u tanga anganga tipmiri waraga' sura gibiinga gu kalabus iyung ganang unggung kane kagaya kama paramu' sini' ningsa' tanga ira fautang. Ka sidi mamareng ka ningwaraga' sura kuyase guk kadagang tanga wa sida ganang unggung urapsa' tipdidima ning tinting.” ");
INSERT INTO uvh_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Ka Jisas wari midi nua'ni ning yanggu', ka sidi midi tangkunang nua'ni ka tim yaranga ikiaging wara'ning undu' kuma'sa' naking. Wa ning yoking, ami a taming ka ufini a tamni guk kuma' irota' wa ami a taming nua'ni guk sansaramik kabi'guk mo' tantamu', mokngang wa tapni tang guk ning yoking. ");
INSERT INTO uvh_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ka nagabu waraga' midi tangkunang sini' nua'ni ka ning toutik, kadagang ning ki wa ami taming wari napa' kadagang girii beng sini' tantamu' unggungsa' mo'. Mokngang, kadagang wa de warisa' kamamarenga napa' u titiga' bane warisa' surota' undu' Anutu adi kadagang ka aming wari napa' beng sini' kuma' titing wara'guk dabiksa' ning kata'. ");
INSERT INTO uvh_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Wara' gu sasuka a daga wari kadagang titiga' ginagira aunga tinga wa gu mo' titiga' kadapmang udanga daga fugung u wadigi' yobusurotang. Ning tanga gu daga fugung ga' nafek totang de ka gu kadagang u kabinga gi' iikning kadapmang ganang ubu itang. A gu kadapmang udaga ning guk mo' totang wa gu kadagang u tanga anganga wari gifakadaga sini' tinga inga' kudip kadagang ganangsa' maya'ga'. ");
INSERT INTO uvh_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Abanga kafaga undu' ningsa', kafaga nua'ni wari kadagang tonga tinga undu' doptaga tanga kayautang. Ning tanga kafaga fugungsa' ira kadagang guk mo' totang wara' gu inga' kareng gi' giri ire'. A gu kadagang titining kadapmang u udaga guk mo' tanga kafaga fama' guk ningsa' ko ira kadagang u tanga autang wa wari gifakadaga sini' tinga inga' gu kudip kadagang ganangsa' maya'ga'.” ");
INSERT INTO uvh_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Ka sidi midi tangkunang nua'ni ka tim Moses wari yoku' waraga' sukanting. Ka midi ka u yoku' wa ning, aming ka taming kuma' sananga irota' ka tamni waraga' bibi' ubu naknga kagabi tonga wa midi ka adi bibi' nakara' wara'ning midi totangka u umpang ganang yora yora bema taming waraga' aminga ning tanga wara'ganang inga' anigarota' wa giri, ning togu'. ");
INSERT INTO uvh_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Ka naganing kadapmang ka midi ka wara'ning wa nua'ni ka kigineng sini'. Wa ning, aming ka taming kuma' sanota' ka tamni wari aming nua'ni guk kadagang kabi'guk mo' tota' sige karengsa' ira auta' ka ufini wari tamni waraga' bibi' sigesa' naknga kabota' wa adi kadagang girii tara'. A tamni undu', ami wari kagabi tinga aming nua'ni ubu udep anga sangamota' undu' kadagang girii tara'. Abanga aming ka taming ka ufini timini wari sigesa' kabota' u sanota' wa adindu' kadagang tara'. Wara' aming ka taming munumung kabota' wari ananing iik u tipkadanga ning tanga tamni timini guk ka aming ka inga' anga sanota' wara'guk dabik ifakadauta'.” ");
INSERT INTO uvh_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Ka midi tangkunang nua'ni ka tim yoking u yaranga titing wara'ning wa sidindu' fafong sa'. Midi ka wa ning yoking, gu napa' ni beng guk sini' titiga' tonga ka aming wari o beng guk sini' ba ning tutugu waraga' sura midi totangka ka o beng guk sini' Anutu girii ganang kuta urang torik ning totangkautang wa napa' ka u titiga' toutang undu' titisa' totang wa giri didimengsa' ning yoking. ");
INSERT INTO uvh_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Ka naganing kadapmang wa nua'ni ka kigineng sini'. Wa ning, sidi midi totangka nua'ni tonga wa napa' tangkunasi ka kunim a kama wara'sining wap guk mo' yora tonting. Mokngang, kadapmang ka ganing midi u tiptangka ga' sura beng sini' kunimganang kuta urang torik ning tutugu waraga' wa na ning torik, kunim wa tare kareng ka Anutu wari marekita' wara' sidi wara'guk mo' yora tonting, wa tapni. ");
INSERT INTO uvh_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Abanga gu o beng sini' kamaganang i torik ning guk mo' toutang. Mokngang kama ya Anutu wari kunimganang kuta mera kayong wari tipminga marekita' wara'ning tare kareng. Abanga gu o beng sini' Jerusalem yong girii ganang do urang torik ning guk mo' toutang. Mokngang, yong girii Jerusalem wa king girii Anutu wara'ning yong kareng kuni' nua'ni. ");
INSERT INTO uvh_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","A napa' kababi'ga' beng guk torik ning tonga undu' ganing kiga wara'guk mo' yora toutang. Mokngang gu kafakafa surotang, gu ganing kiga wara'ning tuang mo' wara' gu midisa' tuguinga guning kiga sasa' wara'ning dumni fam wari fafa' wa ma giming ning iigik ning guk mokngang, Anutu anasa' guning kiga wara'ning tuang beng sini'. ");
INSERT INTO uvh_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Wara' gu aming fam wari midi totangka ka gu totang u beng guk wa ma beng guk mokngang ning waraga' nakedonga gangkainga wa gu weng beng guk wa ma mokngang, ning undu' didimengsa' inotang. A gu midi u tiptangka ga' sura napa' tangkunang nua'ni guk yora toutang wa aming kadagang Setan wari sige gangtintingneinga torang wara' wa kadagang.” ");
INSERT INTO uvh_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Ka sidi midi tangkunang nua'ni ka tim yoking u yaranga titing wa kuma'sa' naking. Midi ka wa ning yoking, aming nua'ni wari guning daga fugung u tipkadagaminga wa kura' undu' de fugung tipkadangamotang. A maga kati undu' ningsa', adi guguk tanga maga kati kubanik yaburomgaminga wa kura'bu undu' mini kati kubaniksa' upmamotang, ning yoking. ");
INSERT INTO uvh_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ka naganing kadapmang wa nua'ni ka kigineng sini'. Wa ning, aming nua'ni wari gifakadaga tinga wa gu kura'bu tipkadaga waraga' guk mo' surotang. A aming nua'ni wari faaga gupapeinga wa gu kura' tubobu guk mo' urotang. Abanga faaga tubo u gukinga undu' kura' guk mo' urotang, mokngang tubosa' kureng guta'. ");
INSERT INTO uvh_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Abanga aming nua'ni wari guta' kaba mamareng nakgama ning touta' gu nagaganang kadagang tugung wara' kura'bu wa guning siot kareng u name'. Ning tonga guning siot kareng u girombemnonga tinga wa gu saketga kareng undu' amotang. ");
INSERT INTO uvh_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","A aming girii nua'ni wari ai naning mambong i manggaknama kadak do tonga nipme' ning tuguinga wa gu kama ka adi tonga kami ga' touta' wara'ganang didimengsa' mo' tonga kamotang, mokngang gu kadapmang kareng tangama nagira au sa' tanga kamani sini' undu' girisa' tonga kamotang. ");
INSERT INTO uvh_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Beng sini' aming nua'ni wari napa' ni amimi ga' ganinga wa gu bibi' mo' nakotang, kadapmang kareng yaranga ninak sa' tanga amimi sa' totang. A aming nua'ni wari napa'ni amiinga kura'bu inga' ganggam ga' tuguinga wa gu sasuk ka kura' tubobu undu' kaga'sa' ganggam waraga' mo totang, mokngang gu tubosa' undu' girisa' amotang.” ");
INSERT INTO uvh_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Ka sidi midi tangkunang nua'ni ka tim aming ka sidigok digirap titi waraga' yoking u yaranga titing undu' kuma'sa' naking. Ka midi ka u yoking wa ning, gu guning digirapga ga' wa bibi'sini' nakngamotang a ganing amiga ga' wa kabaka guk naknga kafakafa tangamotang ning yoking. ");
INSERT INTO uvh_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Ka naganing kadapmang wa nua'ni ka kigineng sini'. Wa ning, kabaka guk ninak wa ganing amiga ga'sa' mo' naknga tangamotang. Mokngang gu aming nua'ni ka guta' digirap tita' waraga' undu' kabaka guk naknga kafakafa tangamotang. A aming wari guta' bibi' naknga kadagang tagaminga wa gu kabaka kadagang naknga marara kura'bu mo' tiamotang. Mokngang gu kadapmang kareng tanga kura'bu wa Anutu wari yotangkayap tinga kareng gi' ubu iik waraga' ibang toimotang. ");
INSERT INTO uvh_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Ka sidi Anutuning mindine arantagim ning iking wara' sidi kadapmang kareng ka u torik ningwara' u tinting wa kadapmang kareng sini' ka babangsi' Anutu girii wari kunimganang kuta ira tita' wara'guk dabiksa' tinting. Ka Anutu adi kadapmang kareng wa ning tita', adi aming yotangkayabita' wa adi tagagare tanga aming kareng kanga wa giri yotangkangam a nisi' aming kadagang kanga wa kagabi ning guk mo' tita' mokngang sini'. Adi kafakafa wa aming karesi a kadagasi wara'guk dabiksa' tasabita'. Ning tanga adining napa' girisi ka mayam a gimak wa aming karesi a kadagasi dabiksa' u yotangkasap waraga' saminga karengsa' naknga ikiting. ");
INSERT INTO uvh_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Ka sidindu' ningsa', sidi kadapmang ka aming nua'niga' ninakning waraga' wa ning mo' sukanting, a indi kuyane ga' siamo' ninak wa undu' kuma'sa' titam wara' Anutu adi u nipma kafakafa wa kuma'sa' tinimota'. Mokngang, kadapmang ka sidaning kuyase sini'ga'sa' naknga tiam wara'ning wa Anutu adi napa' girii ning mo' kata'. Kadapmang ka ningwara' wa aming ka aming kadagasi ning initing ka aming takis mamanggesi adindu' fafong kuma'sa' tanga ikiting. Ka sidi kadapmang ka unggungsa' tanga ikanting wa Anutu adi kareng ning kanga waraga' kura'bu wa indining tanga tasamota', mokngang. ");
INSERT INTO uvh_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Abanga sidi ngingeng bak kuguk ka sidaning amise sini' guksa' titi undu' Anutu adi napa' girii ning mo' kata'. Aming arantagim nua'ni ka Anutuning midi kabi'guk mo' ikiting adindu' kadapmang ka ning udi fafongsa' titing wara' sidi, a indi kadapmang kareng ka ning u tem wara' indi aming kadagasi ka u iirafik sini' tem ning guk mo' tonting, mokngang. ");
INSERT INTO uvh_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Sidi aming kadagasi a karesi dabiksa' wa kadapmang didimeng kareng kuni' nua'ni sini' kubaniksa' ka babangsi' Anutu girii ka kunimganang ikita' wari tanga ikita' ningsa' tiamting.” ");
INSERT INTO uvh_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Ka sidi kadapmang kareng ka Anutu wari titiga' nakita' u tonga wa kabaksi' guk beng sini' kufara tinting. Sidi sasuk usingsa' ka kadapmang kareng ka amingning dasi'ganang sireng tinga aming wari kareng ning sasap waraga' guk mo' sura tinting. Mokngang, sidi sasuk ka waraga' tanga tinting wa sidining babangsi' Anutu ka kunimganang ikita' adi kadapmang ka u kareng ning kanga waraga' to kareng kura'bu sansam ning guk mokngang. ");
INSERT INTO uvh_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Wara' gu aming ka mambong guk mokngang tatafak waraga' ai'dap tanga kafakafa tangama mambong ni amonga wa gu aming fam ning dasi'ganang sireng amiinga aming wari karengsa' gagap waraga' mo' sura totang. Kadapmang usingsa' ka ningwara' wa aming midi buburap tutugusi wari siring yak girii ganang a aming bak ganangsa' yangara kuma' tanga fiareting. Adi kadapmang ka wa tatafak aming ga' bibiri' beng guk mo' naknga titing, mokngang adi sasuk ka aming wari kareng ning iyap waraga'sa' sura sige titing. Beng guk sini' torik adisining kadapmang kareng waraga' mesisiringa wa aming warisa' titing, a Anutu adi waraga' wa kareng naknga mesisiringa guk mo' tita', mokngang sini'. ");
INSERT INTO uvh_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Ka gu tatafak aming beng sini' yotangkayap ga' sura wa gu aming ni guk mo' gabinga kapmo' tafaferanga amotang wa giri. ");
INSERT INTO uvh_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Ning tinga babangga girii Anutu ka nasi' nasi' aming wari kapmo' titing u kuma' yapsasu'neta' warisa' gapma napa' beng guk ning kanga kaba kareng naknga napa' kareng kura'bu gamota'. ");
INSERT INTO uvh_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Ka Anutuga' ibang tutugu waraga' undu' ningsa' toutik, sidi babangsi' Anutuga' ibang tounga wa sidi kadapmang ka aming arantagim ka midi buburap adi' wari tonga fiareting ning mo' tinting. Adi ibang tounga wa adi kadapmang usingsa' tanga aming wari aming kareng ning yapma adisining wap bema ara waraga'sa' sura siring yak ganang a kama bingking ka aming wari bak titing wara'gangangsa' adenga tonga fiareting. Ka beng sini' sanirik adisining kadapmang u kareng ning kanga mesisiringa wa aming kamaganangni warisa' yapma titing, a Anutu adi kadapmang u kareng ning kanga waraga' mesisiringa kabi'guk mo' tita' wara' adi nakiam guk mo' tita', mokngang sini'. ");
INSERT INTO uvh_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","A gu Anutuga' ibang beng sini' tounga wa gu ganing yak iyung bane ganang amanga faba isefinga gapmo' kapmo'sa' mera tongamotang. Ka beng sini' gu babangga Anutu wa kaga guk mo' tanga mera toutang de ka Anutu adi nasi' nasi' kapmo' yapsasu'na tuang wara' adi kuma' gapma guning ibang ning kadapmang wa kareng ning kanga waraga' mesisiringa tanga napa' kareng kura'bu kuma'sa' gamota'. ");
INSERT INTO uvh_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Ka sidi ibang tounga wa sidi midi ki guk mokngang ka paramu'sini' sige guk mo' tonga anting. Kadapmang ka paramu' sini' sige tonga au ningwara' wa aming ka anasining muraksi' nua'niga' sura tuguting wari muraksi' wari nakiam ga' ning tonga tuguting. ");
INSERT INTO uvh_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Ka sidi ibang paramu' sini' tonga au ka adi u titing ning mo' tinting, mokngang. Sidining babangsi' Anutu adi nasi' ka sidi nafera anini ga' suking wa ko mo' aniinga ganang timinggi' kuma'sa' kata'. ");
INSERT INTO uvh_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Wara' sidi adita' ibang tangamonga wa ibang ning kadapmang didimeng nua'ni ka naga i sanggerotik i yaranga toyanting. Wa ning, o sibengni' girii kunimganang ikitang aming indi guning wap girii wa kareng naro'sa' ning kantam. ");
INSERT INTO uvh_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Iik didimeng kareng ka guning bining ganang iikning unggungsa' tipkadofinimotang. Kunim aming wari guning midi nakam sa' titing ningsa' ka aming kamaganangni indindu' ai'sa' tagamtam. ");
INSERT INTO uvh_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Gusa' nana a nasi' kamining didimengsa' nimotang. ");
INSERT INTO uvh_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Aming wari indita' kadagang tinimging u kuma' tipdidimem ka sibeng gu indining kadagang u suknakubenim totang. ");
INSERT INTO uvh_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Gu napa' ka kadaga titiga' kigineng sini' indiramik ning wa kagabi sa' mo' tinga indiramikota'. Gu yotangkanip tinga kadagang wari mo' indifikadauta'. Gusa' napa dabiksa' u niptatoretang. Tangkunang a wap girii kigineng guk wa gupmo'sa' fikifiki ningsa' beng sini' ikitang, beng. ");
INSERT INTO uvh_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Ka beng sini' torik, aming nua'ni wari kadagang giramikinga gu adining kadagang waraga' sasuk mimeng mo' tanga urapsa' suknakubeutang wa babangga Anutu adindu' guning kadagang waraga' suknakube tota'. ");
INSERT INTO uvh_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","A gu aming nua'ni wari kadagang tagamota' ka gu waraga' suknakube guk mo' totang wa babangga Anutu adindu' guning kadagang u suknakube guk mo' tota', mokngang sini'. ");
INSERT INTO uvh_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Ka kadapmang ka ibang ka nana tapni guk tanga tuguting waraga' undu' ning sanotik, sidi napa' girii ni titiga' sura ibang nana tapni guk tanga tounga wa sidi kadapmang usingsa' ka aming fam wari tanga nondaksi' guk kadagainga aming wari beng sini' titining da'ning yapma adisining wap bema areting ning mo' tinting. Beng sini' aming ka wara'sining kadapmang waraga' mesisiringa wa Anutu wari mo' tita', aming warisa' titing. ");
INSERT INTO uvh_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Ka sidi Anutuga' ibang ka nana tapni guk kuma' tanga tonga aming ning dasi'ganang undu' aming wari sapkeda guk mo' titi waraga' tafafera tanga nondaksi' tipgadabanga mesisiringa sa' tanga tonting wa karengsa'. ");
INSERT INTO uvh_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Ning tinga sidining babangsi' Anutu ka kapmo' ikinga kaga guk mo' titing warisa' ibang kapmo' tonting u kuma' sapma naksam sa' tota'. ");
INSERT INTO uvh_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Ka sidi napa' mambong karesi ka kamaganangni sa' u manggara kukna waraga' sasuk mimeng sini' mo' tinting, mokngang. Napa' kamaganangni wa tangkunang ningsa' iikning guk mokngang. Napa' mambong kamaganangni ka wa ging wari nana a bubuyap titi a bataga tanga kadaga abanga kubu aming wari yak ibaramara anga iromanggakniap ning tanga bibi' titining guk. ");
INSERT INTO uvh_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","A Anutuning napa' kigineng ka iik kareng titi wara'ning wa napa' ka ging a bataga a aming wari kubuna ning titining guk mokngang sini', tangkunang fikifiki ningsa' iik wara'ning. Wara' sidi sidining mambong kigineng ning wa waraga'sa' naknga manggara kuknganting. ");
INSERT INTO uvh_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Ka sidi Anutuning napa' kiginesi ka ningsa' iikning u manggakna ga'sa' nakanting wa sidining sasuksi' wa napa' wara'ning tuang Anutuganang kuma' ita'. ");
INSERT INTO uvh_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Ka sidi kuma'sa' naking, aming ning deni wa sasukni wara'ning kamang diok ning ikita' wara' aming ka de kareng wa sasuk ka kaba ganang undu' sangang sa' tanga ikita'. ");
INSERT INTO uvh_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","A de wari kadaga tota' wa mokngang, adi napa' fam guk mo' yapma sasuk didimeng guk mo' tanga ira kaba ganang wa kangkam guk ikita'. Ka aming ning sasuk undu' de wari degareta' ningda'ning wara' aming ka sasuk ka napa' kadagang sa' fatota' wa adining iikni undu' kangkam ning ira kadaga tota'. ");
INSERT INTO uvh_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Abanga nua'ni ka ning, kane aming nua'ni wari aming girii nua'ni ning kane tangamota' undu' unggungsa' tota'. Adi kane ka u tanga anga aming girii nua'ni ning kane wara'guk mo' tota' mokngang. Adi fama' guk dabik tiamotik ning tonga tota' wa girini nua'niga' wa kaba guk naknga kafakafa tangamota' a nua'niga' wa kaba sini' mo' kufara kane kafakafa guk mo' tangamota'. Ka sidindu' ningsa', sasuksi' wari napa' girisi kamaganangni moni a mambong karesi fam waraga'sa' tinting wa wari sidining girisi' ningda'ning ira saptatoreinga sidi wara'ning kapmik ikanting. Ning tinga sidi sasuk mimeng ka waraga'sa' tanga ira Anutuning kane ga' wa kabaksi' sini' mo' kufara tinting. ");
INSERT INTO uvh_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Ka Jisas wari adining arantagimni u nua'bu ning yanggu', ka sidi napa' fuksi' yotangka ning waraga' sura ai, nana wa nasi' nantam a kwi' wa indining tanga manggaknantam ning tonga sasuk mimeng tanga kabaksi' mamareng mo' nakanting. Napa' ka nana a kwi' mambong wa aming wari damdang naknga gi' iik wara'ning ki mo' mokngang. ");
INSERT INTO uvh_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Ka sidi yang ning iiksi'ga' sukanting, yang adi nasi' nantam ning tonga sasuk mimeng tanga feng kane tangkunang tanga ifakadofiinga manggara yak ganang didasi ning guk mo' titing. Abanga Anutu adi yang wa napa' kababi' sini' sigening ning yabita' unggung ka adi kafakafa yaptatoreinga damdang sa' ikiting. Ka aming sidi Anutuning de ganang wa napa' kabasi' mo', napa' girii sini' ning iking wara' sidining babangsi' Anutu ka kunimganang ikita' adi sidi yotangkasap ga' wa nakube kabi'guk mo' tota', mokngang adi kuma'sa yotangkasabota'. ");
INSERT INTO uvh_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Ka beng sini' aming adi adining iikni wa ananing tang ganangsa' guk mo' tiparamundota' wara' adi ananing iikni waraga' sasuk mimeng tonga, mokngang. ");
INSERT INTO uvh_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Abanga kwi' tasase ga' mimeng titining undu' ningsa', sidi ai kwi' guk mokngang, ya fukni' bi'sa' ba yangakantam ning tonga waraga' kabaksi' mamareng naknga sasuk mimeng mo' tinting mokngang. Sidi napa' daberim karesi ka base ganang kadofiting waraga' sukanting, napa' karesi ka u yabitam wa anasining tang ganang kane girii mo' tanga kadofiting mokngang, Anutuning tanga ganangsa' kadofiting. ");
INSERT INTO uvh_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Beng guk sini' sanirik aming girii king Solomon ka tim itarugu' adi aming kangasi sini' ira adining kwi'ni tasase wa inga'ni karesi sini' tanga wara'ning wap guk itarugu'. Ka napa' daberim karesi baseni ka u torik wa karesi sini' ka wa aming kafasi' wari mo' tinga ikiting, wara' daberim wari kuni' sini' ira Solomon ning kwi' kareng ka aming kafasi' wari muntofiging u tarafikiting. ");
INSERT INTO uvh_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Ka daberim u torik undu' napa' tangkunang ka fikifiki ningsa' iikning mo', wa adi kabi' ningsa' adeia' tubobu urapsa' kaforanga mangfuinga kudip seinga wadigi' kuma' dasasu'neting. A aming sidi wa Anutu wari napa' girii sini' ning sabita' wara' sidi ning nakedanting, aming ka naktangka kabi'sini' titisi sidi wa Anutu adi kuma'sa' yotangkasap ning. ");
INSERT INTO uvh_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Ka sidi naning midi u naknga sasuk mimeng ka ai indi nasi' nantam, a nasi' tasasentam ning titing wa kagabi tinting. ");
INSERT INTO uvh_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Sasuk mimeng ka ningwara' wa aming ka Anutu girii beng guk wara'ning wap guk mo' nakiting wari tanga ikiting. Ka sidining babangsi' girii kunimganang ikita' adi sidi napa' ka nana titining a tasase ning waraga' nafek tinting wa kuma' sabara' wara' adi kuma'sa' yotangkasamota'. ");
INSERT INTO uvh_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Wara' naktangka aming sidi napa' kigineng ka sidi fikifiki sura iikning wa Anutuning bining ning kadapmang didimeng waraga'sa' sura ikanting. Ning tinga Anutu adi napa' fam ka nana a tasase ning undu' kuma'sa samota'. ");
INSERT INTO uvh_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Ka sidi midi kigineng ka waraga' sura ning tanga sasuk ka napa' inga' kagadofi ning waraga' tanga kabaksi' mamareng naknga ai inga' wa nafek ba tok wa ma napa' mamareng fam ba kadofinamo' ning mo' tonting, mokngang, Sidi napa' ka kama kubanik ganang kaga' kuma' ting waraga'sa' sukanting. A napa' ka inga' titining wa Anutu warisa' katatorara' wara' anasa' kuma' sangtintingnota'. ");
INSERT INTO uvh_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Ka Jisas wari adining arantagim u midi tangkunang nua'ni ka ning yanggu', ka sidi kadapmang ka amise fam ga' arokiam tanga usingsa' yapma tagagareyap wara'ning ka aming fam wari titing wa mo' sini' tinting, inga' Anutu wari sida undu' ningsa' ma tagagaresabo'. ");
INSERT INTO uvh_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Sidi aming fam ning kadapmang u kafakafa mo' kigedanga a aming ka wa kadagang tita' ning tonga bibi' urapsa' nakiamting wa inga' Anutu wari sidining kadapmang kadagang ka aming usingsa' tagagareyap ning u kanga wa a sidi aming kadagasi ning ma sano'. Sidi aming fam ga' kafakafa mo' tiamting wa Anutu adindu' sidining kadapmang wara'ganangsa' tagagaresapma kafakafa mo' ma tasamo'. A sidi kadapmang kareng tiamting wa Anutu adindu' sidita' kadapmang kareng tasamota'. ");
INSERT INTO uvh_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Abanga kadapmang nua'ni ka ning, aming ka de susu girii guk wari amingni nua'ni ning de susu kabasi' u kanga tanga kayo titiga' arokngam mimeng mo' tota'. Mokngang adi susu girii ka ananing de ganang u tanga kayo waraga'sa' surota'. ");
INSERT INTO uvh_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Ka adi de susu girii wari ko fideinga amingni u o kuyana na yotangkagam tanga daga susu u tanga kayogamotik ning anota' wa didimeng mo', kadagang tara'. ");
INSERT INTO uvh_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Adi tim ka susu girii ka ananing de ganang isefinga fidera' u tanga kayonga kafakafa degaranga ning tanga susu kabasi' ka kuyangni ning de ganang wa inga' kanga tanga kayongamota' wa giri didimeng. ");
INSERT INTO uvh_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Ka Anutuning midi kareng ka naga u sana yararik wa napa' kigineng kareng kuni' nua'ni sini' wara' sidi Anutuning midi u ituaimonga wa aming arantagim ka kabaksi' ka midi ka waraga' bibi' naknga anikige titing wara'siga' sige kayoim sa' mo' tinting. Wa adi napa' beng guk mokngang ning kanga kugwang wari seksi' nakinga ganang iiramik tinga aming urang dipminga nonga titing ningda'ning ma tasamni'. Abanga sidi aming wari adisining napa' kigineng kareng sini' u magaa ning bining ganang tanga igukinga magaa wari kigeda guk mo' tanga tipmififereinga kama sigesa' ubu urang ikiting ningda'ning ma tini'. Wara' sidi Anutuning midi i ituaunga wa kafakafa katatoranga ituanting. ");
INSERT INTO uvh_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Ka ning sanotik, sidi Anutu u napa' kareng ni ga' anonga wa anini sa' tinting. Ning tinga adi kuma'sa' samota'. A sidi Anutuning sasuk kareng ga' wena tangkunang ningda'ning tanga aninting wa Anutu wari kuma' sangtintingneinga kanga bemnanting. Abanga sidi Anutu guk iikga' sura adita' ibang ka aming wari faba kadakiam ga' urang anga ura tuguting ningda'ning tanga tonting wa Anutu adi aiga sa' tanga kadaksama sinagiknota'. ");
INSERT INTO uvh_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Beng sini' aming ka Anutu wari napa' kareng ni yotangkangam ga' sura anota' wa ma kadapmang kareng ga' wena tanga anota' wa ma Anutu guk iikga' ibang touta' wa Anutu adi nakngam sa' tanga kuma'sa' yotangkangamota'. ");
INSERT INTO uvh_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Ka sidi midi ka u torik waraga' nakedonga wa kadapmang ka aming kamaganangni sidi sidining sabase ga' tiamiting waraga' sukanting. Sidining sabase wari nana dibing ni iyam ga' tuguinga wa sidi napa' kadagang ka uningkim u sige guk mo' bema imiting mokngang. ");
INSERT INTO uvh_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Abanga adi keng ga' tuguinga undu' sidi gimik kafo ni u sige guk mo' bema imiting mokngang. ");
INSERT INTO uvh_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Ka aming kamaganangni kadapmang didimeng guk mo' titisi sidi sabase wari napa' ni iyam ga' tuguinga wa sidi ninak sa' tanga napa' kareng didimengsa' imiting. Ka sidi ai' dap ning kadapmang ka u titing ning wa babangsi' Anutu girii ka kunimganang ikita' ka ai' dap ning tuang beng sini' adi aming ni wari napa' ni amimi ga' anota' wa kareng girii sini' tanga amimi sa' tota' ning tita' waraga' sukanting. ");
INSERT INTO uvh_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Beng sini' kadapmang kareng ka gu aming fam wari guta' tagam ga' nakitang ning wa gu aming fam ga' undu' ningsa' tiamotang wa karengsa'. Midi ka aming ga' kafakafa tiam wara'ning u torik wa midi kigineng sini' ka Moses ning kadapmang tang a midi fam ka profet arantagim wari tokadofiaging dabiksa' u defata' wara'ning ki sini'. ");
INSERT INTO uvh_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Ka kadapmang ka fama' guk adeiamu', nua'ni wa kabasi ka kapmo' da'ning adeta' a nua'ni wa girii sirengsa' adeta'. Ka aming kabi'mo' adi kadapmang girii u karengsa' kanga kugurang sa' mugo waraga' sura u yaranga mugoting. Ka kadapmang girii ka wa kudip kadagang waraga' mugo wara'ning. Ka sidi kadapmang ka u mo' yaranting mokngang, sidi kadapmang ka kabasi' unggungsa' yaranting. ");
INSERT INTO uvh_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Ka kadapmang kabasi' ka u torik wa kabasi' sini' abanga kane girii guk tanga autang. Ka aming kabi'mo' adi wara'guk mo' katuanga auting. Mokngang, aming kubanik kubanik warisa' katuanga yaranga auting. Ka kadapmang kabasi' ka wa yong ka ka' ningsa' iik wara'ning wara' sidi kadapmang kabasi' unggungsa' yaranting. ");
INSERT INTO uvh_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Ka sidi kafakafa suktangkanga ikanting, profet mandaga' fam undu' iking. Ka wari kadapmang mandaga' fam sanggekinga kadaga ma tini'. Adi mandaga' ning fatuguting, o indi Anutuning midi kareng itua ning aming beng sini'. Ning tuguinga sidi adisining iiksi' undu' keng ka kagaya guk mo' titing, kugurasi sa' ka sipsip ningda'ning yabiting. Ka mokngang adisining kabaksi' mang ganang wa sasuk kadagang wari tanga kugwang kagaya guk ningda'ning ikiting. ");
INSERT INTO uvh_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Ka sidi adisining kanesi' unggungsa' kanga wara'ganang nakedanting. Ka u nakeda wara'ning wa ning, sidi firi mindip ka nana titining minditing undu' kuma'sa' yabiting. Firi mindip karesi ka nana titining ka grep wa aya kusung guk baseni wara'ganang guk mo' manggeting mokngang, grep undu' ananing ki ganang didimengsa' manggeting. A firi mindip karesi fam undu' firi kadagasi ning ki ganang guk mo' manggeting, mokngang wa ki ganang didimengsa' manggeting. ");
INSERT INTO uvh_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Abanga nana ka bong girii arota' wa beng girii afuting, a nana ka kiridang da'ning arota' wa bengni undu' girii mo' tota', kabi'sini' afota' ning titing. ");
INSERT INTO uvh_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Abanga firi karesi wa firi mindip ka nana titining guk mokngang wara'guk mo' minditing. A firi ka kadagasi mindip sigening titing undu' firi mindip karesi ka nana titining wara'guk minditing. ");
INSERT INTO uvh_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Ka firi mindip nana titining karesi ka uwafi titing wari kafakafa mo' minditing wa aming adi iibi sa' mo' titing, mokngang adi dinasasu'na tanga kudip ganang seting. ");
INSERT INTO uvh_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Ka profet kadagasi arantagim ka u torik undu' ningsa', sidi adisining kadapmang a kanesi' ka didimeng mo' tinting u yapkeda sa' tanga wa ning tonting, o adi mandaga' aming beng sini'. ");
INSERT INTO uvh_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Ka beng sini' sidi aming kabi'mo' wari o girini' ning fananing u yapma ning mo' sukanting, o adi Anutuning bining kareng ganang dabiksa' iikning unda'. Mokngang Anutuning bining kareng ganang iikning wa aming ka naning sibeng ka kunimganang ikita' adining sasuk sa' yaranga tanga na adisining girisi' ning beng sini' napma fananing warisa' wa giri ikni'ga'. ");
INSERT INTO uvh_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Beng sini' inga' kama kunim wari bibi' tonga to' ganang wa mandaga' aming kabi'mo' ka ningwara' adi naga abok u napma ning toni'ga', o girii gu bibiri' nibe', indi guning arantagim indi guning wap waraga' sura wa Anutuning midi kareng ituatam. Abanga indi masi' unggo kadagasi wa guning wap guk tonga tanga igura ning tanga kane tangkunasi fam mirakel kabi'mo' undu' kuma'sa' tanga ira abutam. ");
INSERT INTO uvh_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Ka adi ning udi giri nangni' de ka nabu ning tipfaranga inok ga', a sidi nisi' aming wari abanga toing, na sidi mo' sinagarotik. Sidi naganing arantagim sini' mo', sidi aming kadagang titisi sa' sabarik. Uri fonga mugo tini' ning inok ga'. ");
INSERT INTO uvh_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Ka aming ka midi ka naga fatorik i naknga naktangka tanga didimengsa' tanga irota' wa adi aming sasuk kareng guk wari yak kigineng mama ning ningda'ning tota'. Wa ning, aming ka sasuk kareng guk adi yak maunga wa adi tim ka kafakafa sura ning tanga kama kareng wara'ganangsa' tanga manota'. ");
INSERT INTO uvh_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Ka inga' gimak girii tanga ama gibung wari yak ganang u kagadofi a gugubik kigineng wari abanga yak u ifamota' wa mokngang, yak wara'ning mangkap wa mang sini' kuma' unanga kamota' wara' kigineng ningsa' adenga kadaga guk mo' tota'. ");
INSERT INTO uvh_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","A aming ka naning midi i sige ninak sa' tanga kabinting wa adi kadapmang ka aming sasuk guk mokngang wari yak kareng ka kama kafakafa guk mo' kadidimanga kama papekareng ganang urapsa' mamaning ningda'ning tota'. ");
INSERT INTO uvh_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ka inga' gimak girii tanga ama gibung wari yak ganang u kagadofi a gugubik kigineng wari abanga yak u ifamota' wa yak karengsa' kuma' mauta' unggung tapanga mangfuinga ama gibung wari wara'ganang wadigi'sini' tipkadauta'. ");
INSERT INTO uvh_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Ka Jisas wari midi u tosasu'neinga aming arantagim kabi'mo' ka unggung adeging wari adining midi u kuni' nua'ni sini' ning naknga base tiging. ");
INSERT INTO uvh_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Adi Jisas ning midi wa adisining yanggek aming ka Moses ning kadapmang tapni yanggekiaging wara'sining masi' ningda'ning mo' naking. Mokngang adi kigineng guk ka aming tangkunang girii guk wari tutugu ning ning naknga base tiging. ");
INSERT INTO uvh_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Ka Jisas wari arantagimni midi u yanggera ning tanga kama bubo u kabinga afuinga aming arantagim kabi'mo' wari abanga Jisas u yaranga aging. ");
INSERT INTO uvh_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Ka aming nua'ni bagana tangkunang fugu udi kadagasi lepa guk wari Jisas ganang anga manda upma mungkupnanga mera Jisas u ning anigu', o girii gu girisa' nifakarenda ning ning gabarik wara' gu bibiri' nabe'. ");
INSERT INTO uvh_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Ka Jisas adi nakngam sa' tanga fugu u suronga ning anigu', we' kuma' gifakarendarik. Ning aniinga udi kadagasi fugu ganang wari kaga'sa' bingaminga karenda tugu'. ");
INSERT INTO uvh_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Ning tanga Jisas wari aming u ning anisefigu', gu fuka i gifagarendarik yaraga' aming ka ni guk mo' anotang. Gu bagana aming wari karenda ning kadapmang didimeng titing waraga' sura pris ganang sa' autang. Auinga pris wari fuka tubobu kuma' karendotang u gapma wap aming kareng ning ubu gana gangkareinga anga Anutu ga' ofa ka tim Moses wari bagana aming karenda wara'ning waraga'sa' tangam waraga' togu' u tangamotang. Ning tinga aming wari u gapma gu wap aming kareng ning gana adisigok kubap iikga' tubobu ginagiknganting ning anigu'. Ning aniinga mugo tugu'. ");
INSERT INTO uvh_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Ka Jisas wari u anganga Kapaneam yong u kadofigu'. Ka Romni ami'ning soldia ning aming girii nua'ni wari Jisas ganang kadofinga ");
INSERT INTO uvh_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","midi tangkunang ning anigu', o girii naning kunung aming nua'ni bagana mamareng sini' ka kayong kafong kuma' kumara fugu kagaya girii sini' defara famindira'. ");
INSERT INTO uvh_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Ka Jisas wari ning anigu', we' kuma' anga tipkarendotik. ");
INSERT INTO uvh_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Ka soldia ning aming girii wari ning anisefigu', ka girii na aming kareng mo' wara' gu naning yak ganang do unggung aunga. Mokngang gu ingging adenga midisa' tuguinga kuma' karendota'. ");
INSERT INTO uvh_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Na kadapmang ka midisa' tuguinga kane aming u midisa' ininga titining undu' fafong titik. Na ami'ning aming wara'sining girisi' de ka nandu' aming girisi fam ning kapmik ganang ikitik. Abanga na aming arantagim fam undu' yaptatoretik wara' na naganing soldia arantagim u napa' niga' initik udi nakngamsa' tanga titisa' titing. Naga u maya' ning toutik udi au sa' tota' a abubu te' ning toutik udi abubu sa' tota'. Abanga aming ka naganing kane tita' u kane ni titiga' anitik udi ninak sa' tanga tita'. Ka girii gundu' ningsa', ingging adenga midisa' tuguinga kuma' karendota'. ");
INSERT INTO uvh_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Ning aniinga Jisas wari adining midi kareng u naknga aming kuni' nua'ni ning kagu'. Ning tanga faranga aming ka Jisas ana yaranga fengaging u ning yanggu', ning sanotik aming ka ya Juda aming mo' ka adi naktangkani kareng sini' karik. Na Juda aming indining kamaganang wa aming ka ni naktangkani kareng sini' ka ningwara' guk mo' katik mokngang sini'. ");
INSERT INTO uvh_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Ka beng sini' torik, aming arantagim kabi'mo' ka Juda mo' kama kamanini ka mayam de ararap tara' a mayam amama tara' u ira yareting wari inga' Anutuning bining ka kunim yongganang u anga mera ning tanga naktangka aming timini Ebraham guk ka Aisak a Jekop adisigok nana kubap mera nani'ga'. ");
INSERT INTO uvh_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","A aming ka tim Anutuning bining ganang iikning wap guk ning tonga tanga ikiting adi mokngang, adi Anutu wari manggara fugang tariabinga kama gaa' kangkam sini ganang ira fuksi' mamareng girii naknga mak kara kugwak sa' fatoni'ga'. ");
INSERT INTO uvh_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Jisas wari midi u ina ning tanga soldia ning aming girii u ning anigu', yakangga' tubobu girisa' mautang napa' gu naga tagam ga' naktangkanga torang wa didimengsa' kuma'sa' kadofigaminga kautang ning aniinga mugo tugu'. Ka didimeng ka Jisas wari midi u togu' wara'ganangsa' ami'ning aming girii wara'ning kane aming udi kaga'sa' kuma' karendagu'. ");
INSERT INTO uvh_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Ka Jisas wari Pita ning yak ganang u anga amanga kagu' ka Pita ning ipmang taming udi bagana fugu kagaya mamareng tanga defagu'. ");
INSERT INTO uvh_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","U kanga Jisas wari kafong u suroinga bagana u tanga defagu' wari kaga'sa' bigu'. Ning tanga bagana wari biinga karengsa' ubu naknga marara Jisas se' ga' nana siam kane tiamgu'. ");
INSERT INTO uvh_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Ning tanga nana u nanga mareia' kibiri ganang aming kabi'mo' wari amise fam masi' unggo kadagasi guk u inagira Jisas u kaunga abiging. Abuinga Jisas wari u yapma midisa' tuguinga masi' unggo kadagasi wari ibinga mugo tinga karendasasu'na tiging. Ning tanga aming fam ka baganasi' kuni' kuni' guk undu' ifakarendasasu'negu'. ");
INSERT INTO uvh_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Ka kane ka Jisas wari u tugu' waraga' midi nua'ni ka timinggi' profet Aisaia wari togu' wari beng guk kadofigu'. Midi ka u tuguinga yoking wa ning, “anasa' indining bagana kadagasi kuni' kuni' a mamareng girii u bemsasu'neinga binimara' ning yoking.” ");
INSERT INTO uvh_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Ka aming arantagim kabi'mo' wari Jisas ganang bak girii sini' tiging. Ka Jisas wari u yapma arantagimni u ning yanggu', indi aming i iibi tanga gwang fugung do manam. ");
INSERT INTO uvh_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Ning tonga mugo tonga tinga Moses ning kadapmang tang wara'ning sasuk aming girii nua'ni wari Jisas ganang u kadofinga ning anigu', yanggek aming gam na guning arantagim ira gugok kubap mantam. Gu indeng autang wa nandu' kubap sa' ayantam ga'. ");
INSERT INTO uvh_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Ka Jisas wari ning anigu', gu nagok kubap mugo ga' torang wa. Ka ning ganotik, kafakafa sura toya'. Kugwang baseni wa dama dekning kamasi' guk abanga yang undu' yorisi' guk yating. A Amingning Tim Iyak na yaknang a dama dekning kama gapmam sini' guk mokngang ning anigu'. ");
INSERT INTO uvh_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Ka aming nua'ni ka Jisas ning midi ga'sa' fanakarugu' adindu' unggung adegu'. Ka wari Jisas u ning anigu', girii nandu' gugok kubap mugo ga' sutik. Ka indining, tim ka naning sibeng tangandang u anga yotangkangama iya' adi kumoinga gugok wa inga' udi giri anam wa. ");
INSERT INTO uvh_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Ka Jisas wari ning anigu', babangga unafarafi ga' sura torang wa amine ka naning kane ga' guk mo' sura bibi' titining sa' iking wari kuma' unafarafani'. A gu nagok kubap mugo ga' torang wa kabaka kubaniksa' kufara nanawak sa' te' ning anigu. ");
INSERT INTO uvh_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Ka Jisas wari aming fama' midi u ina ina ning tanga arantagimni guk u inagiknanga bot ganang aranga mera gwang fugung ga' mugoging. ");
INSERT INTO uvh_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Ka adi bot ganang u anganga gwang bining do kadofiinga gugubik kigineng girii wari urapsa' kadofinga gwang u figikbibingeinga gwang sasabara girii wari marara bot bane ganang amatononga tugu. A Jisas udi dama tang deku'. ");
INSERT INTO uvh_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Ka arantagimni wari gugubik girii wari tanga bot amonga tugu' u kanga mutu tanga Jisas u tipseganga ning katiangaging, ai girii mamarak tanga yotangkanip te', bibi' tantam yang. ");
INSERT INTO uvh_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Ka Jisas wari u naknga seganga marara ning ifangyanggu', a sidi naktangkasi' guk mokngang wara' sidi mutu ba ting. Ning ina ning tanga gugubik kigineng u midisa' tuguinga gugubik wari kaga'sa' dagainga gwang sasabara girii undu' bibi' tanga kugurang gi'sa' ubu deiagu'. ");
INSERT INTO uvh_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Ning tinga ananing arantagim wari u kanga base tanga ai ya nasi' aming ya, napa' girii ka gugubik kigineng a gwang sasabara girii ningyara' undu' adining midi nakngam ning guk ba ning tonga sasuk mimeng tanga ko tanga mera aging. ");
INSERT INTO uvh_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Ning tanga anganga gwang gaga tubo ka aming Juda mo' ka Gadara ning iniaging wara'sining kamaganang do kadofiging. Ka aming masi' unggo kadagasi guk fama' wari Jisas u abanga katuagumu'. Aming fama' ka wa masi' papesi sini', dama deksi' wa kama ginang ka aming kungkumosi fonga faipmiaging wara'ganangsa' defara fengakiagumu'. Ka aming yong ki wara'ni adi aming fama' waraga' tanga mutu tanga kadapmang ka wara'guk mo' famaiaging. ");
INSERT INTO uvh_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Ka wari Jisas ganang kadofinga Jisas u urapsa' kuma' kigedanga ning togumu', ai Anutuning mindingni gu nasi' tinibonga abarang. Amingga' kagaya iyam ning kama ko mo' tinga gu indita' kagaya urapsa' wa naga' nimonga abarang. ");
INSERT INTO uvh_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","31","Ning katinga ning tanga masi' unggo kadagasi wari magaa arantagim girii ka fugung ning u fidenga fanaging u fonga yapma Jisas u ning aniging, ai gu indifi mo' totang, gu ningkagare tonga wa indibi sa' tinga magaa arantagim do wara'ganang anga amayapma iknam. ");
INSERT INTO uvh_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Ning tuguinga Jisas wari yankagare tinga aming fama' u ibinga anga magaa wara'ganangsa' anga amayapsasu'neging. Ning tinga magaa wari kugurang gi' fideging u kabinga bima tanga kama sam kadagang ganang u tabasananga amanga gwang ganang apa mangfanga gwang u topnakadara wadigi' dabiksa' kumaksasu'neging. ");
INSERT INTO uvh_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Ka yong ki wara'ni aming fam ka magaa u yaptatoranga fideging wari magasi' kungkumak tiging u yapma yong girii ga' tubobu unara anga midi ka nasi' magaa wari tiging, abanga nasi' aming fama' masi' unggo kadagasi guk wari tugumu' wara'ning u ituanga yareging. ");
INSERT INTO uvh_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Ning tinga aming yong ki wari midi u naknga marara kadidima sini' tonga Jisas u kaunga aging. Anga kadofinga Jisas u kanga ning aniging, ai mutu tem, gu indining kamaganang i ko mo' irotang, tubobu urapsa' maya', ning aniging. ");
INSERT INTO uvh_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","2","Ka Jisas guk ka arantagim guk adi kama ka u kabinga gwang fugung ga' tubobu maunga bot ganang areging. Arang mera ning tanga anganga Jisas ananing yong ki ganang u anga kadofiging. Ka aming yong ki wari aming nua'ni bagana agik mamareng kayong kafong kungkumosi u ipma bema Jisas u kaunga abiging. Ka Jisas wari bagana aming wara'ning amine wari Jisas ning kigineng ga' naktangka tanga bema abiging u yapma bagana aming u ning anigu', sabana gu sasuk mimeng mo' totang, guning kadagang wa kami kuma' tanga kayogamarik. ");
INSERT INTO uvh_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Ka Juda aming ning sasuk aming fam adi Jisas wari midi ka guning kadagang kami kuma' tanga kayogamarik ning togu' u naknga kabaksi' kadanga anasa' ning toging, ai aming ka wa midi ka Anutu anikige ningda'ning tora' nakem. ");
INSERT INTO uvh_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Ka Jisas adi adisining sasuksi' kabaksi'ganang u kuma' yapkedanga midi ning yanggu', sidi nagata' kadagang ba naknaming. ");
INSERT INTO uvh_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Ka sidi indining suking, sidi naga o na guning kadagang kuma' tanga kayogamarik ning u midisa' torik waraga' kabaksi' kadagang ba naknaming, a naga napa' sireng sini' ka mamarak tanga mugo te' ning toutik wa giri mamareng guk mo' u nakanting. Mokngang, midi fama' wara'ning ki wa kubaniksa' ka naning kigineng kuma' tipkadofiinga kaing wang. ");
INSERT INTO uvh_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ka sidi ning toing wara' na napa'ni tasamotik sidi u kanga o Anutu wari tangkunang ka aming ning kadagang tanga igukiam wara'ning wa Amingning Tim Iyak ga' kuma' ba amigu' ning u kanga nakeda waraga'. Ning ina ning tanga bagana aming u ning anigu', we' mamarak tanga kwi'ga mambong u manggaknanga yakangga' mugo te'. ");
INSERT INTO uvh_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Ning aniinga bagana aming wari mamarak sa' tanga yoring ga' mugo tugu'. ");
INSERT INTO uvh_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Ning tinga ami taming kabi'mo' ka unggung anga adeging wari u kanga base tanga Anutuning wap bema aranga ning toging, ai Anutuning kigineng ka ya aming ganang guk wa indining kadofiinga tinga kayam, ning toging. ");
INSERT INTO uvh_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Ka Jisas wari yongganang u kabi'ning nua'bu anganga takis manggak ning kane aming nua'ni wapni Matyu u adining takis mamanggak ning yak kabasi'ganang merafatugu' u anga katuagu'. U katuanga ning anigu', gu abubu tanga nagok kubap manam. Ning tinga Matyu adi Jisas ning midi u ninak sa' tanga marara adining kaneni ka takis mamanggak ning u wadigi' sini' kabinga Jisas u yaranga adisigok kubap ubu mugoging. ");
INSERT INTO uvh_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Ka inga' Matyu wari tangsana kabi' tanga Jisas guk ka arantagimni guk u adining yak ganang anga adigok nana kubap nana ga' katianggu'. Ka wara'ganang wa Matyu adi aming takis mamanggesi a aming fam ka Juda amise wari kadagang ning yapma aming sansaramik titisi ning iniaging undu' katiana abanga Jisas se' guk nana u kubap dabik mera naging. ");
INSERT INTO uvh_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Ka Juda arantagim ning sasuk aming girisi Farisi wari Jisas wari aming wara'siguk nana kubap mera naging u kanga Jisas ning arantagimni u ning yangging, ai, sidining girisi' wari aming takis mamanggesi a aming sansaramik titisi ning wara'guk nana kubap ba mera fining. ");
INSERT INTO uvh_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Ka Jisas adi Farisi wari midi u toging wara'ning u kuma' kanga midi tipfara tanga ning yanggu', beng sini' dokta adi aming karesi guk mo' yabiting, mokngang, adi aming ka bagana guk unggungsa' yabiting. ");
INSERT INTO uvh_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Ka midi ka u torik waraga' wa Anutuning midi nua'ni ka umpang ganang timinggi' yoking wa ning, na ofa ka keng sigesa' u nanam ga' bibi' nakarik, na ofa beng guk ka kadapmang ka aming fam ga' kabaksi' guk naknga kafakafa tiap wara'ning u nanam ga'sa' nakarik ning yoking, ka sidi midi ka wara'ning ki waraga' kafakafa sura nakedanting. Ka nandu' aming karesi ga' mo' abuguk, mokngang na aming kadagasi sa' yabonga abuguk, ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Ka Jon Baptis ning arantagimni wari abanga Jisas u ning aniging, ai indigok ka Farisi guk indi fiking ni Anutuga' sura ibang tounga wa indi nana tapni guk tanga fatugutam, ka guning arantagim adi tapni guk mo' tanga nanga au sa' wa indining fiting fiabem. ");
INSERT INTO uvh_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Ka Jisas wari midi tipfara tanga ning yanggu', sidi kadapmang ka aming wari kafauwe titiga' tangsana tanga titing waraga' sukni'. Wa ning, adi ning titing aming ka tangsana wara'ning nana u nana ga' ininga abuting adi aming ka kafauwe titining wari adisigok kubap ko marekiting ganang wa giri mesisiringa tanga nana sa' titing, ka inga' aming wari kafauwe titiga' abanga nagira auinga wa adi bibiri' naknga nana tapni wa wara'ganangsa' titing. Ka naning arantagim undu' ningsa', kami nagok kubap ikem ganang wa adi kabaksi' kareng naknga nana sa' tinting. Ka inga' naga ibiinga wa adi nagata' kabaksi' mamareng naknga nana tapni wa wara'ganangsa' tini'. ");
INSERT INTO uvh_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Ka naga abanga kadapmang kareng inga'ni yanggetik wara'ning wa midi nua'ni ka ning toutik, kwi' timini wari damarik tota' u kanga ginang u muntofi sefonga wa kwi' inga'ni sini' mo' dopma muntofotang, mokngang. Gu ning totang wa kwi' inga'ni wari tangkunang guk ko fideinga kwi' timini wari urapsa' nua'bu damirira ning tanga ginang wari girii sini' kadofota'. ");
INSERT INTO uvh_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","A nua'ni ka ning, wain ama inga'ni kigineng guk wa maga giknim kandang ka timini wara'ganang mo' tagarotang, mokngang, ning wa wain ama inga'ni kagaya guk wara'ning kigineng wari tanga kandang u ibaramak tanga wain ama wari kwasina tinga kandang undu' wadigi' kadauta', waraga' tanga adi wain ama inga'ni undu' kandang inga'ni ganang didimengsa' tagakinga ama guk ka kandang guk wa kareng ningsa' fidentamu' ning titing. Ka naning midi ka naga inga' abanga i torik wara'ning wa kigineng guk wara' Anutuga' sura titining kadapmang ka timini yaranga titing wara'guk dabiksa' mo', undu' nua'ni, ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Ka Jisas wari midi u ko araininga yong wara'ni siring yak katatora ning aming girii nua'ni adining ibingini kuma' kumakngamgu' waraga' kaba mamareng naknga abanga Jisas ganang u kadofinga manda upma mera Jisas u ning anigu', o girii abanga yotangkanam te', naning yapna kuma kumata' kanga abarik. Ka gu anga suro' tinga tubobu marara ka' irota'. ");
INSERT INTO uvh_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Ning tuguinga Jisas wari ninak sa' tanga marara arantagimni guk dabiksa' aming girii u yaranga adigok kubap aging. ");
INSERT INTO uvh_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Ka adi kadap ko aramugoging ganang ka taming nua'ni bagana amaa so guk ka kama paramu' gurak 12 ning sini' kuma' tanga ira abugu' wari karenda titiga' sura aming bak girii tanga aging wara'ning mang ganang anga Jisas ning kwi' kangkama paramu' wara'ning sunom u kapmo' tifemgu'. ");
INSERT INTO uvh_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Ka taming adi o na kwi'ni sa' tifemotik undu' giri kuma'sa' karendotik ning sura anga tifemgu'. ");
INSERT INTO uvh_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Ka Jisas adi taming wari tifemgu' udi sireng urapsa' kuma' nakedagu'. Ning tanga faranga kanga taming u ning anigu', yapna gu mutu mo' totang, naga girisa' gifakarenda ning ning napma naktangkarang warisa' tanga kami gu wadigi' kuma' karendarang. Ning tuguinga bagana kadagang amaa so fikifiki fatarugu' wari kaga' wara'ganangsa' bigu'. ");
INSERT INTO uvh_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Ning tanga anganga aming girii wara'ning yak ganang u kadofinga yapking ka aming fam wari taming u unafarafi wara'ning bibiri' waraga' kandang figiking a aming fam ka mak kara bumburang kabi'mo' ning tanga fatiangaging. ");
INSERT INTO uvh_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Ka Jisas wari u yapma ning katianggu', ai aming dabiksa' sidi fugang afasasu'nini', taming kabasi' wa kungkumak wadigi' mo' tara' mokngang, dama sa' dekara'. Ka aming u kura faging adi Jisas ning midi u naknga a gu mandaga' giknarang ning tonga kanggaga tanga anikige tiging. ");
INSERT INTO uvh_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Ning tanga Jisas wari ami taming u yangkagarenga ipmasasu'nanga iyung bane u amanga taming kabasi' kumogu' wara'ning kafong u suroinga taming wari ka' tubobu ira seranga maragu'. ");
INSERT INTO uvh_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ning tinga aming wari u kanga base ubu tiging. Ning tanga Jisas wari taming kabasi' tipmaragu' wara'ning midi u bema bema tiangainga midi wari kama yong yong u mugoinga naksasu'nanga yareging. ");
INSERT INTO uvh_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Ka Jisas se' wari yong ka u kabinga mugo tiging. Ka aming dasi' kadagasi fama' wari marara mandang yaranga anga Jisas u ku ning katinganggumu', o aming girii Devit ning irini gu nipbubure tanga yotangkanip te'. ");
INSERT INTO uvh_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Ka Jisas adi ningsa' nakiama anga yak nua'ni ganang amogu'. Ka dasi' kadagasi fama' adindu' ko yaranga anga yak wara'ganang mandang amogumu'. Amanga Jisas ganang didimeng kadofiinga Jisas wari u yapma ning yanggu', ma' sidi naga girisa' sifakarenda ning ning u nabiamu'. Ka adibu ning anigumu', weng girii gu indifikarenda titining ning gabiamuk. ");
INSERT INTO uvh_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Ning tuguinga Jisas wari dasi' u suroyapma ning yanggu', sidi naga girisa' sifakarenda ning ning naknga naktangkiamu' warisa' tanga wa kami kuma' tasaminga karendiamu'. ");
INSERT INTO uvh_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Ka Jisas wari midi ka u tuguinga dasi' kadagasi wari tarara' tinga karengsa' ubu degaregumu'. Ning tanga Jisas wari yangsefi tangkunang ning tugu', dasi' i tasaminga degariamu' waraga' wa aming ka ni kabi'sini' guk mo' anintamu'. ");
INSERT INTO uvh_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Ka Jisas adi yangsefi tangkunang ning kuma' tugu' de ka mokngang, adi dasi' danga aming yong yong ka kama tubo wara'ni u yangsasu'na tanga yaregumu'. ");
INSERT INTO uvh_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Ka aming dasi' kadagasi fama' karendagumu' wari Jisas se' u ibinga mugoinga aming fam wari aming ibap amamong nua'ni ka midi map fentarugu' ubu nagira abanga kadofiging. ");
INSERT INTO uvh_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Ka Jisas wari u kanga aming wara'ning mini unggo kadagang u tanga kayongamgu'. Ning tinga aming midi map fentarugu' udi midi kaga'sa' togu'. Ka aming arantagim ka unggung adeging wari u kanga base tanga ning tonga yareging, ai napa' kigineng ka ningyara' ya Juda indining kamaganang i tim guk mo' kadofiinga katam mokngang sini', ya kamisa' kadofiinga kayam. ");
INSERT INTO uvh_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Ka Farisi arantagim fam ka adisining bining ganang unggung adeging wari u kanga ning toging, a idi kuma' kayam mini unggo kadagasi ning girisi' wari tankunang amiinga tara' ning toging. ");
INSERT INTO uvh_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Ka Jisas wari yong ka u kabinga ning tanga marara kama tubo Galili tara' wara'ning yong yong u yangara adisining siring yaksi'ganang amanga Anutuning midi kareng ka Anutuning bining kareng wari kagadofi wara'ning u ituaima yaranga ning tanga aming ka bagana kadagasi kuni' kuni' guk undu' ifakarenda ning tanga yaregu'. ");
INSERT INTO uvh_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Ka Jisas wari ami taming kabi'mo' wari mamarengsi' kuni' kuni' guk ka maga sipsip yotangkayap titining tuang guk mokngang ningda'ning ira Anutuning midi waraga' nafek sini' tanga abiging u yapma bibiri' sini' naku'. ");
INSERT INTO uvh_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Ning tanga ananing arantagimni u ning yanggu', kane girii sini' kadofinamara' karik. Ka na ami taming bak ya nana feng girii ka kuma' kurasasu'na ning ningda'ning yabarik. Ka feng wara'ning kane titining wa kane aming mimeng guk mokngang fama'sa', ");
INSERT INTO uvh_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","wara' sidi feng wara'ning tuang Anutuga' ibang aninting. Ning tinga Anutu wari kane aming fam u nua'bu yapma yangkareinga yangara aming wari nana kuru' feng ganang u manggara bak urang kukiting ningda'ning tanga aming u manggara bak kukngaminga adining arantagim ganang kadofinting ning togu'. ");
INSERT INTO uvh_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Ka Jisas wari ananing arantagimni 12 u katiana ning tanga tangkunang ka aming masi' unggo kadagasi guk u tanga igukyam a aming bagana girisi a fuksi'ganang kagaya kuni' kuni' naknga mamareng girii bema iik u ifakarenda wara'ning u yamgu'. ");
INSERT INTO uvh_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Ka Jisas ning aposel arantagim 12 ka u katianggu' wara'sining wapsi' wa ning, tim sini' wa Saimon ka wapni nua'ni Pita wara'guk ka kuyangni Andru guk a Sebedi ning mindine fama' Jems iguyangguk Jon ya ");
INSERT INTO uvh_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","a Filip a Batolomiu a Tomas a Matyu aming ka wa tim takis manggatarugu' urang nagiku' wang abanga Jems nua'ni ka Alfias ning mindingni a Tadias, ");
INSERT INTO uvh_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","a Saimon ka Selot arantagim ning, arantagim ka wa adi Rom ning gavman wari Juda katatora ga' bibi' nakiaging wara'ning abanga Judas nua'ni ka Iskeriot, aming ka inga' Jisas tipkadofiaminga aming wari uuk titiga' urang bemging ning u katianggu'. ");
INSERT INTO uvh_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Ning tanga Jisas wari yangkara tonga kane ima ning yanggu', na sidi naganing kane titiga' sangkararik. Ka sidi aming arantagim nua'ni ka Juda mo' adisining kamaganang wara'guk mo' anga tinting. Abanga kama tubo Sameria tara' a adisining yong fam wara'guk mo' anga tinting, mokngang. ");
INSERT INTO uvh_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Sidi amise Isrel arantagim ka sipsip wari tuangsi' kabinga masira urang titing ningda'ning tanga iking unggungsa' anga tinting. ");
INSERT INTO uvh_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Ka sidi u anga midi ning ituaimting, Isrel aming sidi midi i nakni', kama kareng ka Anutu wari aming manggara fabanga adining bining ganang kukyabinga iik wara'ning wa kuma' kadofonga tara' yang. ");
INSERT INTO uvh_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Ning ina ning tanga bagana aming u ifakarendanga a aming ka kungkumak kuma' tanga deiak u ifamarara a aming bagana kadagang ka kasi' kafasi' ki natugupmuresi u tubobu ifakarendanga ning tanga aming ka masi' unggo kadagasi guk u tanga igukiama ning tanga yaranting. Ka sidi u yotangkayapma wa uningkim mambong wari tosap ga' guk mo' katiangting, mokngang. Na ai'dap tanga tangkunang ya sige samarik wara' sidindu' sigesa' yotangkayapma yaranting. ");
INSERT INTO uvh_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Ka sidi fuksi' yotangka ning mambong mimeng mo' manggaknganting. ");
INSERT INTO uvh_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Napa' ka moni a mambong fam wa ari'ganang guk mo' tanga senting. A siot undu' fama' mo' manggakanting, kubanik kubaniksa' tananga manting. Abanga kasi' giknim su a tong guk mo' manggakanting, sigesa' kuma' unda' adeing ningsa' mani'. Sidi kadapmang ka aming wari kane kareng tanga yotangkayabinga adi adisining kadapmang kareng u kanga napa'ga' nafek kabi' tinga wa kuma'sa' yotangkayapmanting ning titing waraga' sura sigesa' mani'. ");
INSERT INTO uvh_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Ka sidi i anga yong nua'ni ganang kadofinga aming ka ni wari kadapmang kareng tanga kafakafa tasapma adisigok dek ga' saninga wa sidi nakngam sa' tanga anga adining yak ganang unggungsa' dera tanga anganga kane ka yong wara'ganang u tasasu'nanga sa' wa giri kabinga mugo ning tanga ani'. ");
INSERT INTO uvh_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Ka sidi anga aming nua'ni ning yak ganang kadofinga wa tim ka midi pumpurum kabi' ka o amine Anutu wari sidigok ikinga sidi kabaksi' kugurang sa' ikanting ning tonga inga' wara'ganang anga amanting. ");
INSERT INTO uvh_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Ka yak wara'ning tuang wari kafakafa tasaminga wa midi ka beng guk kuma' kadofira'. A aming ka sasuk karesi guk mokngang wa sidining midi waraga' bibi' nakanting. Ning tinga midi sidi tonting wari adisigok mo' yotangkayapma sidita' unggung tubobu abota'. ");
INSERT INTO uvh_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Ka sidi anga yong girisi a yong kababi'ganang kadofiinga ka yong wara'ning tuang wari adisigok iikga' guk mo' sansang a midi ka sidi ituanting u ninak ga' bibi' naksam ning tinga yapma wa sidi adisining yong u kabinga mugo tinting. Ning tanga adi sapma o indi Anutuning midi ga' bibi' nakem wara' adi indining yongganang i nua'bu mo' abubu waraga' kadapmang wadigi' ba udaing ning nakedanga tutugu waraga' kasi' giknim u kifanga manggara difimaim tanga manting. ");
INSERT INTO uvh_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Beng sini' sanirik aming ka naning midi ninak ga' bibi' naknga kadapmang isefisamting wa kadagang tinting wara' adi inga' kama kigineng ari' ka Anutu wari aming ning kadapmang u yapma tagagareyabo' ganang wa mamareng girii ka adi bemni' wari mamareng ka timinggi' aming ka yong kadagasi fama' Sodom guk ka Gumora guk wara'ganang ikiaging wari bemni' u tarafaro'ga'. ");
INSERT INTO uvh_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Ka sidi aming ka naning midi ga' bibi' naknga ikiting wara'sining bining ganang ira titi waraga' wa kafakafa suktangkanga sasuk guk anting. Na aming fam ka sifakadaga titining guk iking wara'ganang ka sipsip nano tangkunang guk mokngang wari kugwang kagaya guk ning bining ganang urang mugoting ningda'ning tanga sangkararik. Wara' sidi sasuk ka tangkunang fama' ka nasi' kadapmang wa didimeng kareng unggungsa' titi waraga' kafakafa sasuk abanga aming u midi kugurang sa' ina yotangkayap titi ningwaraga' suktangkanga tanga anting. ");
INSERT INTO uvh_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Ka sidi kafakafa nakni', inga' aming kabi'mo adi sidi naning midi itua kane u tini' waraga' tanga kabaksi' kadagang naknga kadapmang kadagang kuni' kuni' ka ning siramikni'ga', adi manggaksapma fonga adisining kaunsil ning midi kigineng ganang kuksap a adisining siring yak ganang sinagira amanga fefasap titi ning tini'ga'. ");
INSERT INTO uvh_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Ning tanga adi sidi kane u tinting wara'ning midi u nakdidima waraga' midiganang kuksabinga gavman girisi a king arantagim wara'sining dimisi'ganang adeni'ga'. Ka adi mamareng ka wa sidi nagata' naknga naga yotangkanap ning kane tinting waraga' tanga saramikni'ga'. Ka sidi aming girisi a aming arantagim nua'ni ning bining ganang adenga wa sidi naganing midi kareng wa ituaim ning kadapmang guk u kanga ituaim sa' tini'. ");
INSERT INTO uvh_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","20","Ka adi midiganang u manggara kuksabingka wa sidi kabaksi' mamareng naknga ai, nasi' midi tontam ning tonga sasuk mimeng mo' tini' mokngang, midi wa sidasa' mo' toni'. Kama ka sidi midi u tutugu ga' anga adeni' ganang wa babangsi' ning mini unggo wari kaga'sa' kuma' santintingneinga toni'ga. ");
INSERT INTO uvh_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Ka kadapmang kadagang a mamareng ka adi sansaramik waraga' u sanirik wa aming fam warisa' mo' saramikni' mokngang, sidaning arantagim didimeng wari undu' kuma'sa' saramikni'ga'. Wa ning tini'ga', ananing beni sini' wari mindingni ka nagata' naktangka to' u kanga bibi' nakngama ananing mindingni unggung tipkadofiinga ugumak, a mindingni wari beni ka nagata' naktangka to' u kanga ananing beni unggung tipkadofiinga bema ugumak ning tanga yarani'ga'. ");
INSERT INTO uvh_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Ka aming kabi'mo' wari sidi naganing kane tini' u sapma sidita' bibi'sini' naksamni'ga'. Ka sidi mamareng ka waraga' bima guk mo' tanga tangkunang ningsa' tanga ira ani' wa na inga' kafakafa tasapma gi' manggara kuksabinga ikni'. ");
INSERT INTO uvh_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Ka sidi yong nua'ni u anga kadofiinga aming wari kadagang saramikonga tinga wa sidi yong ka wa urapsa' kabinga yong nua'niga' ubu anga gi' ira naganing kane i tanga ikanting. Beng sini' sidi kane ka ning u Isrel ning yong girisi wara'ganang u tanga yaranga ko mo' tipmiriinga ganang wa Amingning Tim Iyak naga abanga kadofok ga'. ");
INSERT INTO uvh_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Ka midi ka aming wari kadagang sansaramik ning u tongak wara'ning wa ning sura nakanting, girii wa nisi', aming ka skul tota' uba ma aming ka aninggek tota' uba. Mo' girini wa aming ka aninggek tota' wang. Abanga girii wa nisi', kane aming sige slev uba ma aming ka adining girini ka kane amiinga katatora tita' uba. Mokngang adining girini wa aming ka kane amita' wang. ");
INSERT INTO uvh_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Wara' aming wari adining girini ga' mamareng aminting wa aming ka skul tota' wa ma kane amingni sige slev adindu' aming wari kagaya aminting wa adi ning touta', o naning girina wa kagaya kuma' bemara' udi a adining kane aming na nifikadaga titining wap guk wara' na bimbem sa' totik. Ka sidi midi ka i kafakafa nakanting, na sidining girisi' ningda'ning itik. Ka adi mini unggo kadagang ning wap kadagang sini' ka Bielsebul ning nana naramikiting ka sidindu' naganing kane aming arantagim ning iking wara' sidi wa sigening ning sini' sapma sidi wap kadagang beng sini' sana saramikni'ga'. ");
INSERT INTO uvh_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Ka na naganing midi i itua ga' sanirik ka sidi aming ga' mutu tanga mo' ma ituani' mokngang, naning midi wa sirengsa' kadofiinga kaga wara'ning wara' na kuma'sa' yotangkasamotik. Ning tinga naning nasi' midi kadapmang kabi'sini' ka ni kapmo' guk mo' adeuta' mokngang, sirengsa' kuma' kadofiinga kani'ga'. ");
INSERT INTO uvh_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Ka beng sini' naganing midi ki ka sidi sanitik wa kami kapmo' da'ning sanitik. Ka inga' sidi midi ka u bema aming fam ga' ubu ituaimni' wa adi sireng sini' ka yong bining anga adenga tutugu ningda'ning nakni'ga'. ");
INSERT INTO uvh_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Ka sidi aming wari sidifikumak titi waraga' mutu mimeng mo' tinting, aming adi sidifi udi giri tinting ka adi urasi' guk mo' sifikadanting. Ka sidi mutu girii kubanik wa sidining girisi' Anutu waraga'sa' tinting. Adi aming ifakadaga ning kigineng girii guk wara' aming ifakadaunga wa adi fuksi'guk ka urasi'guk dabiksa' wadigi' beng sini' ifakadasasu'na wara'ning. ");
INSERT INTO uvh_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Ka sidi kuma'sa' yabiting yang kababi'sini' wa sigening wara' aming adi uningkim girii mo' kababi' sini' ka ten toea warisa' fama' ning tonga manggaknating. Yang wa napa' kababi' sini' de ka babangsi' Anutu adi kafakafa sini' yaptatoranga ning tanga kamaganang mangmek ga' undu' ana kuma' sukita' ganang mangmekiting. ");
INSERT INTO uvh_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","31","Ka aming sidi wa yang ningwara' mo', sidi babangsi' Anutu wari napa' girii sini' ning sabita'. Adi aming kubanik kubanik sidining kisi' sasa' a nasi' nasi' ka fuksi'ganang iking wara'ning nambani ka aming wari ninak ning guk mokngang wa Anutu adi kuma' yapma sidita'sa' sura ikita'. Wara' sidi mamareng ga' sura mutu tanga wa ning sukanting, o Anutu adi indita' wa nakube guk mo' tota' mokngang, kuma' yotangkanipma niptatoreta'. ");
INSERT INTO uvh_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Beng sini' aming ka aming fam ga' mutu guk mo' tanga midi ka o na girii Jisas ning arantagim ning u sirengsa' tonting wa nandu' aming ka wara'ning wap wa sibeng Anutu undu' sirengsa' anok. ");
INSERT INTO uvh_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","A aming ka nanuk ma tini' ning tonga naganing wap itua ga' mutu tota' wa na inga' adining wap wa naning sibeng undu' mo' anok. ");
INSERT INTO uvh_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Ka sidi ning mo' sukanting, o Jisas adi kamaganang yaraga' wa ami' a napa' kagaya u tipsibibainga aming wari kugurang gi'sa' iik waraga'sa' unda' afugu'. Mokngang na aming wari ami' tonga kwak guk urang manggara abuting ningda'ning abarik. ");
INSERT INTO uvh_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Ka naga i abarik ya aming udayap waraga' abarik. Wara' aming adi kami yara'ganang wa kadapmang ka ning u tinting, adi tubo kidagang tanga mindingni wari beni kaguradota' a ibingini undu' mengni kagurudanga naro' irota' abanga nabingini wari nabingi kaguradota' ning tanga yaranting. ");
INSERT INTO uvh_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Ka beng sini' kadapmang ka u tinting wa ki kubaniksa' ka aming wari nagata' nakota' waraga'sa' tanga ana kurene anasa' adita' kura' kagurudang tanga tubo kidagang titi, ning ubu tinting. ");
INSERT INTO uvh_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Wara' aming ka mengne bene ga'sa' naknga nagata' wa mimeng mo' nakota' wa adi naganing amina sini' ning iikning guk mokngang. Abanga mengbe undu' ningsa', adi sabase a yapse waraga' siamo' naknga nagata' wa mimeng mo' nakanting undu' adi naganing amane sini' ning iikning guk mokngang. ");
INSERT INTO uvh_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Ka na mamareng girii guk ka aming nua'ni firi ugari ganang uronga ananing ugari mamareng urang amiinga barungnanga mugoting ningda'ning tanga itik. Ka aming ka ni naganing amina kareng ironga undu' mamareng ka naga bemarik ningsa' bimbem sa' tota' wa giri. A mokngang, ning guk mo' tota' wa adi naganing amina mo' irota'. ");
INSERT INTO uvh_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","A aming ka ananing iikni wari gi' ningsa' iikga' sura ananing fugu katatora ning kane sa' tanga irota' wa adi bisasu'na wara'ning. A aming ka ananing fugu ga' sasuk mimeng guk mo' tanga naganing kane yotangkanama tanga kumarota' adi inga' ka' iik kareng sini' bema iro'ga'. ");
INSERT INTO uvh_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Ka sidi naganing kane tinga aming wari u sapma yotangkasap tinting wa sidisa' mo' yotangkasabing, mokngang wa nagata' kafakafa tanaming. Ka nandu' ningsa', aming ka ni nagata' kafakafa tanamota' wa adi nagata'sa' mo' tanamara', wa adi naganing sibeng ka nangkara tinga afuguk waraga' guk tangamara'. ");
INSERT INTO uvh_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Ka aming nua'ni wari Anutuning midi ituainga aming nua'ni wari u kanga o adi aming sige mo', Anutuning kane aming wara' na yotangkangam totik ning tonga yotangkauta' wa Anutu adi kafakafa ka profet ga' tangamota' ningsa' adita' undu' tangamo'ga'. Abanga aming didimeng ka ni abuinga aming nua'ni wari o aming ka wa Anutu wari adiganang beng sini' ita' karik ning tonga yotangkangam tota' wa Anutu adi kafakafa sini' ka aming didimeng ga' tangamo' ning adita' undu' ningsa' tangamo'. ");
INSERT INTO uvh_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Beng sini' naganing arantagim nua'ni wap guk mokngang wari auinga aming ka ni wari u kanga a idi Jisas ning arantagim karik ning tonga yotangkangam tanga kafakafa kabi'sini' ka ama kaa'sa' gikngamiinga topnota' wa Anutu adi napa' kabasi' ning mo' kauta' mokngang, adi napa' girii sini' ning kanga kura'bu undu' adita' wa kafakafa sini' tangamo'ga'. ");
INSERT INTO uvh_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Ka Jisas wari ananing arantagim 12 waraga' kane u ima ning tanga ibinga adi kama tubo Galili unggung wara'ning yong fam ga' anga ami taming u yanggera Anutuning midi u ituaima ning tanga yaregu'. ");
INSERT INTO uvh_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Ka Jon Baptis adi iyung kane kalabus u tanga itarugu'. Ka adi Jisas wari kane anga tanga yaregu' wara'ning midi ne u naknga adining arantagim u katiana ning tanga Jisas u anga kadidima waraga' ina yangkaregu'. ");
INSERT INTO uvh_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Yangkareinga abanga kadofinga Jisas u ning anigaging, tim Jon wari inga' Anutuning aming girii nua'ni wari abubu ga' togu' udi gusa' iba ma aming nua'ni ko u abuinga kanam ga'. ");
INSERT INTO uvh_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Ka Jisas wari ning yanggu', sidi naga midi ituarik a kane fam tirik u kuma'sa' kaing wara' sidi tubobu anga Jon u ning aninting, adi kane tanga yarara' wara'ning midi ka nana dani' wari kangam a aming wari nininga nakngam wara'ning wa ning, ");
INSERT INTO uvh_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","aming dasi' kadagasi wa tubobu degaring a aming ka kasi' kadagasi wa kadak didimengsa' ubu marara arengaking a aming ka bagana kadagasi lepa guk wa tubobu kuma' karendanga adisining fuksi' wa fafandangesi karesisa' ubu iking a aming masi' pipesi wa midi ubu naking. A aming ka bagana mamareng tanga wadigi'ga' ning tonga kuma' kumara deiak u tubobu ifamarak abanga tatafak aming wari adining midi waraga' naknga adiganang bak tinga adi midi u faituaimara'. ");
INSERT INTO uvh_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Abanga Jon u ning anga aninting, aming ka naganing midi a kane naga tirik yara'ning u naknga bibi'guk mo' nakota', adi naktangka sa' tota' wa karengsa', Anutu wari yotangkangam tota' ning ina yangkaregu'. ");
INSERT INTO uvh_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","8","Ka Jon ning arantagim wari tubobu mugoinga Jisas wari Jon Baptis ning wap bema aronga adining iik ning ki waraga' ami taming u ning yanggu', tim Jon wari kama bining sige ganang kadofinga ira midi itua kane tanga itarugu' ganang u tanga anga fakayaging wa sidi adining midi ne naknga aming beng wa aming sasuk fama' guk a aming baraganeng ka gugubik wari sigisap figira tipuwingna ningda'ning u kantam ning tonga u sura famayaging. Abanga sidi aming kangasi kwi' kangkamani inga'ni karesisa' tanga abara' u anga kantam ning tonga u famayaging. Mokngang, aming ka napa' inga'nisa' tanga iik ningwara' wa kama base ganang guk mo' yabiting, adi aming girisi king ning yak karesi ganangsa' ikinga yabiting. ");
INSERT INTO uvh_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Abanga sidi profet nua'ni u anga kantam ning tonga sura u famayaging. Ka u suking wa giri didimeng beng guk suking. Ka beng sini' Jon wa profet de ka adi profet sa' ka tim kadofinga ira abiging ningwara' mo', mokngang adi wap guk wara' adi profet tim iyak ning ita'. ");
INSERT INTO uvh_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Ka aming ka Jon u kadofigu' waraga' wa Anutuning midi nua'ni ka umpang ganang timinggi' ning kuma' yoking, aming ka wa naganing kane aming na u anigareinga adi tim anga midi ka gu abubu wara'ning u ina ning tanga guning kadapmang u tipdidimagamara' ning yoking. ");
INSERT INTO uvh_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Beng sini' Jon Baptis adi profet fam irafata' de, ka aming sige wap guk mokngang fam ka nagata' naktangka tanga Anutuning bining ganang ikanting adi adisining iikning wap kareng wari Jon ning wap girii u tarafikanting. ");
INSERT INTO uvh_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Ka aming wari Anutuning bining kareng ganang iik wara'ning midi tim munumung sini' wa Jon Baptis wari kadofinga ituagu'. Ka kami yara'ganang naga abanga ituarik ganang undu' ningsa'. Ka aming arantagim ka sasuksi' kareng guk mokngang adi ami taming wari au wara'ning kadapmang u udaima iik kareng ka wara'ganang anasa' iikga' tangkunang kabasi'mo' ting. ");
INSERT INTO uvh_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Tim sini' profet arantagim wari midi ituanga abiging a Moses ning midi tang u tanga ira ababanga midi ka Jon Baptis wari kadofinga ituagu' wara'ning ki girii kubaniksa' wa midi ka aming wari Anutuning bining ganang iik wara'ning kama wari kagadofi waraga'sa' tanga tonga abuting. ");
INSERT INTO uvh_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ka tim profet arantagim adi midi nua'ni ka inga' profet girii nua'ni ka Ilaija ningwara' wari abo'ga' ning toging. Wara' aming ka sasuk guk wa Jon Baptis wari abugu' waraga' wa nakeda tanga ning touta', o midi ka tim profet nua'ni wari abubu ga' urang toging wa kuma' abara' yaraga'sa' toging udi. ");
INSERT INTO uvh_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Aming ka sasuk guk wa giri midi ka i torik i kafakafa nakota'. ");
INSERT INTO uvh_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Ka na ning toutik, aming ka kami yara'ganang iking wa sasuksi' kareng guk mokngang wara' adi kadapmang ka ning u ting, adi sababi' wari bak kura sababi' amise fam ning urang katianiting ningda'ning, ");
INSERT INTO uvh_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","aa sidi indi mesisiringa titining mime karengsa' toyam ka sidi mime titiga' bibi' naking. Abanga mak kagak ning mime bibiri' kareng toyam undu' sidi mak kagak ga' bibi' naking wa indining da'ning ting, ning urang tuguting ningda'ning ting. ");
INSERT INTO uvh_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Ning tanga Jon Baptis ning kadapmang ka nana a ama tapni tanga yagu' u kanga wa adi a aming ka udi mini unggo kadagang guk kayam ning fanikigeging. ");
INSERT INTO uvh_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Ka inga' Amingning Tim Iyak nagabu kadofinga nana a ama wa tapni guk mo' tanga nana sa' ubu tinga adi kareng mo' napma aroknam tanga ning fananing, a ya nasi' aming, aming ka nana ama nuguk adi' ya. Abanga aming ka aming kadagasi a aming takis mamanggesi wara'siguk ngingeng kubap fengak, ning guk wa na ga' fatara' ning fatoing. Ka midi beng guk sini' wa ning fideta', aming ka Anutu wari sasuk kuma' imara' adi Anutuning kane kigeda ning sasuk kareng guk wara' adi aming ning kane wa didimeng wa ma didimeng mo' ning wa sirengsa' kuma' kanga nakedanting ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","21","Ka yong fam ka kama tubo Galili tara' wara'ning ka tim Jisas wari yangara kane tangkunasi fam u tanga yaregu' ka adi kabaksi' faranga naktangka guk mo' tiging waraga' tanga Jisas wari ning ifang yanggu', a Korasin aming sidi inga' mamareng girii sini' katuani'ga'. Abanga Betsaida aming sidindu' mamareng girii ningsa' katuani'ga'. Beng sini' na kane tangkunang sidining dasi'ganang kuni' nua'ni sini' tirik, ka mokngang sidi waraga' guk mo' suking. A naga kane tangkunang ka i tirik ning i aming arantagim ka yong fama' ka Taia guk ka Saidon guk ka Anutuning midi mo' naknga ikiting adisining dasi'ganang u anga tiamarok wa adi kabaksi' urapsa' faranga adisining kadagang u kabinga ning tanga adisining kadagang waraga' sura kwi' babam kadagasi tama ning tanga kunumbang sa' kuma' urang marafakianing. ");
INSERT INTO uvh_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Wara' ning torik, inga' Anutu wari aming tagagareyabo' ganang wa adi mamareng girii sini' samo'ga'. Beng sini' mamareng ka sidi bemni' wa mamareng ka yong fama' Saidon guk ka Taia guk wari bemni' u tarafaro'ga'. ");
INSERT INTO uvh_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Ka Kapaneam aming sidi, a indi aming karesi Anutuning yong kareng ganangsa' manam ga' ning tonga iking wa mokngang sini'. Sireng ning sanotik, sidi Anutu wari kudip ganangsa' manggara iguksabo'ga'. Tim aming ka ni wari kane tangkunang ka naga i tasamarik ningyara' i aming kadagasi ka Sodom yong do ikiaging wara'siga' anga tiamonga tugu' wa adi kabaksi' urapsa' faranga adisining kadagang u kabisasu'neinga Anutu wari iibi sa' tanga yong u mo' tipkadagainga adi kami yara'ganang undu' ko ikianing. ");
INSERT INTO uvh_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Ka beng sini' inga' Anutu wari aming tagagareyabo' ganang wa adi mamareng girii sini' samo'ga'. Mamareng ka sidi bemni' wa mamareng ka aming ka Sodom yong ikiaging wari bemni' u tarafaro'ga' ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Ka kama ka wara'ganang Jisas wari beni Anutuga' ibang ning togu', o sibeng gu kama a kunim wara'ning girii beng sini', na guning kadapmang kareng waraga' kabakna karengsa' naknga guta' mesisiringa tirik. Beng sini' gu kuma' sura guning kigineng a sasuk kareng wa aming ka sasuk guk giri ning tonga iking wara'siga' mo' tipsirendaimarang, mokngang gu aming sige wap guk mokngang wara'siga' imarang wara' na guning kadapmang kareng ka waraga' sura kabakna karengsa' naknga mesisiringa tagamarik. ");
INSERT INTO uvh_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","O sibeng beng guk sini' gu kadapmang ka wa kafakafa kuma' sura nakedanga tarang ning togu'. ");
INSERT INTO uvh_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Ka Jisas wari ibang u tonga biinga ning tanga aming u ning yanggu', naning sibeng wari adining napa'napa' wa mindingni nagasa' yaptatora ga' kuma' ibinamsasu'negu'. Ka naganing sasuk a kabakna undu' aming kamaganangni ka ni guk mo' kata' mokngang, sibeng warisa' kata'. Abanga sibeng ning iik undu' aming ka ni guk mo' nakedata' mokngang, wa mindingni nagok ka aming ka naga sasuk kuma' ima yantintingnarik wara'siguk indisa' wa giri nakedem. ");
INSERT INTO uvh_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Ka aming dabik ka mamareng kuni' kuni' a mamareng ka napa'ga' kabaksi' mamareng naknga sasuk mimeng titi wara'guk iking sidita' wa ning torik, na yotangkasap titi waraga' abuguk wara' sidi nagaganang sa' abani'. Ning tinga na yotangkasap tanga naganing kadapmang kareng ka kabaksi' kugurang iikning u saminga sidi kabaksi' kugurang guk ka mengkura kareng titining ningda'ning karengsa' naknga ikanting. ");
INSERT INTO uvh_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","30","Ka sidi nagaganang abanga naning kane i bemting. Kane ka wa mamareng guk mokngang ka aming fam wari kuyang tatagim dabiksa' urang barungnanga nakiting ningda'ning ararangeng sa' kuma' nakanting. Beng sini' na kadapmang ka fuksi' bema afu a kugurang gi' yanggek wara'ning tuang sini'. Ka sidi nagaganang abuinga naga sanggekinga sidindu' naning kadapmang kareng u bemting. Ning tinga sidining kabaksi' wa kugurang karengsa' beng sini' naknga ikanting. ");
INSERT INTO uvh_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Ka kabi'ning iya' inga' Juda adisining mengkura ning kama sabat nua'niganang Jisas guk ka ananing arantagimni guk kadak mugoging. Ka adi kadapmang wa wit feng bining ganang u mugoging. Ka Jisas ning arantagim wari seksi' naknga wit mindip u kubanik kubanik upma manggara buroma nang nanga mugoging. ");
INSERT INTO uvh_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Ka Farisi arantagim wari wit mindip manggara naging u yapma Jisas u ning aniging, ai Juda indining kadapmang tapni wa sabat ganang kane guk mo' titiga' tuguta' wara' indi sabat ganang wa indi kane guk mo' titam. Ka guning arantagim adi wit mindip wa sabat ganang guk ya naga' manggara ning ning aniging. ");
INSERT INTO uvh_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Ka Jisas adibu ning yanggu', mokngang adi kadagang mo' ting. Tim girii Devit guk ka adining ami'ning aming arantagim fam guk adindu' seksi' kagaya naknga kadapmang ka kami i ting ning undu' kuma'sa' tiging. Ka sidi u tiging wara'ning midi ka tim umpang tang ganang yoking wara'guk mo' ba indangira nakiting. ");
INSERT INTO uvh_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Adi ning tiging, adi ami' anga tanga abanga nanasi' guk mokngang ka seksi' kagaya sini' naknga Devit wari arantagimni u inagira siring yak wara'ganang amanga baret u manggara naging. Baret ka wa Anutuga' ning tonga kuma' animamangnanga kukngamging wara' tapni guk, aming sige ka Devit guk ka adining arantagim fam guk ningwari nana ning guk mokngang, aming girisi arantagim pris ka siring yak u katatoranga tanga ikiaging warisa' nana wara'ning unggung manggara nana ning. Ka Devit adi kadapmang ka wa Anutuning midi tapni udaga ning mo' ning u kuma' kanga wa u tugu' wang. ");
INSERT INTO uvh_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Abanga aming girisi pris arantagim adindu' sabat fikifiki wa siring yak girii tempel wara'ganang wa kane undu' fafong titing. Ka adi kane ka wa Moses ning midi tangkunang wari kuma' togu' ganangsa' titing, ka sidi midi ka wara'guk mo' ba indangira nakiting. Adi u titing wa adi sabat ning kadapmang tang u udagating, ka wa sidi kadagang ning yapma a kadagang ting ning guk mo' tuguting, mokngang sidi kareng ningsa' yabiting. ");
INSERT INTO uvh_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Ka na midi ka u tonga yararik wa napa' ka siring yak girii tempel wara'ganang amanga titing waraga' torik. Ka napa' beng guk sini' nua'ni ka tempel u tarafita' wa kami kuma' kadofinga adera' yang. ");
INSERT INTO uvh_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Ka sidi midi nua'ni ka tim Anutu wari tuguinga yoking waraga' sukni'. Midi ka wa ning yoking, na keng sigesa' tanga sanam waraga' mo' nakitik, mokngang na aming ka kaba ka aming ka napa'ga' nafek titi u kababurenga yotangkangam wara'guk iik waraga'sa' nakitik ning togu'. Wara' sidi midi ka u yoking torik wara'ning ki u kafakafa kuma' sura nakedianing ganang wa sidi kadapmang ka aming wari kadagang kabi'guk mo' tinga sigesa' yangbe ning guk mo' tianing. ");
INSERT INTO uvh_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Ka sidi sabat waraga' toing wa ning sanotik, Amingning Tim Iyak nagasa' sabat wara'ning tuang a ki sini' wara' nasi' kadapmang aming wari sabat ganang tinting u kigedotik. ");
INSERT INTO uvh_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Ka Jisas wari Farisi arantagim guk midi u tonga binga ning tanga ibinga anga yong wara'sining siring yak ganang ubu amogu'. ");
INSERT INTO uvh_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Ka aming nua'ni kafong kungkumong guk undu' siring yak iyung ganang kuma' amanga merafagu'. Ka aming fam ka Jisas ga' bibi' naknga Jisas wari napa' ni dasi'ganang nua'bu tinga midiganang bema kami waraga' sura kafatatoranga yaranga fengaging adindu' siring yak wara'ganang mandang yaranga anga amoging. Ka aming ka wari aming kafong kadagang guk u kanga Jisas u ning anigaging, ai Juda indining kadapmang tapni urang wa indining, mengkura ning kama sabat ganang wa aming ka ni girisa' tipkarenda ning wa. ");
INSERT INTO uvh_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Ka Jisas adibu ning tipfaranga yanggu', ka sidi wa indining titing. Sidining maga sipsip nua'ni wari kwang ginang manga mauta' wa sidi a kureng fidera' kami ya mengkura ning kama sabat, ning u tuguting. Mokngang, sidi magasi' kareng waraga' tanga kadaga ma to' ning tonga bibiri' naknga wengkami titi ning kane wa sabat ganang undu' unggung titing ning titing. ");
INSERT INTO uvh_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Wara' sidi ning nakanting, maga wa napa' kabasi' kamaganangni sa' a aming wa napa' girii sini'. Ka Juda indining kadapmang tang ganang undu' ningsa', aming ka ni mamareng guk kanga wa indi aming ka u yotangkangam ning kane wa mengkura ning kama sabat ganang undu' girisa' tantam. ");
INSERT INTO uvh_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Ning ina ning tanga Jisas wari aming kafong kungkumong u ning anigu', kafaga kadagang u wetatare te'. Ning aniinga wetatareinga kafong kungkumong wari kaga' wara'ganang urapsa' karendanga ning tanga kafong tubo kareng wara'guk dabik kareng ningsa' ubu adegumu'. ");
INSERT INTO uvh_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Ka Farisi arantagim adi Jisas wari aming u sabat ganang tipkarendagu' u kane titining ningda'ning kanga o kadagang tara' ning tonga kabaksi' kadagang sini' naking. Ning tanga marara siring yak u kabinga fugang afanga ning tanga Jisas u ugumak sini' titi waraga' midi tonga naking. ");
INSERT INTO uvh_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Ka Jisas adi Farisi arantagim wari ugumak titiga' midi tonga naking u kuma' yapma ning tanga yong u kabinga mugo tugu'. Ning tinga aming arantagim sige kabi'mo' wari undu' mandang yaranga mugoging. Ka Jisas wari mandang yaranga aging u yapma adisining bagana aming u ifakarendasasu'negu'. ");
INSERT INTO uvh_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Ning tanga aming ka ifakarenda tugu' waraga' aming fam mo' anga iyang waraga' yangsefi tang tugu'. ");
INSERT INTO uvh_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Ka Jisas wari u tiama yangsefigu' waraga' wa midi nua'ni ka tim profet Aisaia wari tuguinga yoking wara'ganang didimengsa' tugu'. Midi ka wa ning yoking, ");
INSERT INTO uvh_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“aming ka i kaing ya naganing kane aming kareng sini' tipkasirarik. Na adining kadapmang kareng kanga adita' siamo' nakitik. Na adita' naganing mana unggo u amotik. Ning tinga adi anga aming kabi'mo' ka arantagim nua'nining u naganing kadapmang didimeng wara'ning midi u ituaimo'ga'. ");
INSERT INTO uvh_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ka adi midi u ituaima ganang aming wari midi u naknga adigok arok tinting wa adi midi kura' tubobu aming guk arok tanga midi kigineng tutugu, abanga adi kama ka aming wari bak kuguk wara'ganang midi bang tutugu ning guk mo' tota' mokngang. ");
INSERT INTO uvh_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Ka adining kadapmang wa aming yotangkayap ning ka kugurang karengsa', adi sigisap ka tatapa tonga titi wa tiptapa titi ning guk mokngang. Abanga kamang mambaya' ka kuma' kungkumak ga'sa' kabi'sini' fada undu' adi usugumak mo' to'. Beng sini' adi adining kadapmang kareng ka aming ifakarenda ning wa kagabi guk mo' tanga tangkunang ningsa' tanga ira auinga kadapmang kareng ka wari kadapmang kadagang u ugamusinga tatarafik sini' to'ga'. ");
INSERT INTO uvh_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Ka aming dabiksa' wari adining kigineng girii u kanga o beng sini' anapmo' kubaniksa' yotangkanip ning ki sini' ning ita' ning tonting, Aisaia ning midi wa ning yoking.” ");
INSERT INTO uvh_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Ka aming fam wari aming nua'ni ka mini unggo kadagang wari tanga de kadanga a mini mamarenga midi guk mo' futorugu' u nagira Jisas ganang abiging. Ka Jisas wari u kanga tipkarenda tinga aming wari midi tonga a de kafakafa degaranga ning u kaga'sa' tugu'. ");
INSERT INTO uvh_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Ning tinga aming kabi'mo' ka unggung adeging wari Jisas wari adisining dasi'ganang napa' tangkunang sini' tugu' u kanga base tanga ning toging, ai aming ka idi kigineng girii guk. Idi Devit ning iri urang ubanda'. ");
INSERT INTO uvh_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Ka Farisi arantagim fam wari midi ka u naknga ning toging, a sidi sige mo' tonting, aming ka wa mini unggo kadagasi ning girisi' Setan ka Bielsebul ning tugutam wari amanga tangkunang amiinga tangkunang ka warisa' mini unggo kadagasi tanga igukita' u kanga toing. ");
INSERT INTO uvh_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Ka Jisas adi adisining sasuksi' u kuma' yapkedanga midi ning yanggu', indining, kama nua'ni wara'ning aming arantagim wari tubo kidagang tanga ami' tinting ka kama tubo wara'ning tangkunang wa ko ningsa' fideuta' wa. Mokngang, adisining tangkunang wa kuma' biuta'. Abanga yong kabasi'ning aming arantagim a aming ana kurene yak kubaniksa' wari tubo kidagang tanga ami' tinting, ka adisining tangkunang wa ko ningsa' u irota'. Mokngang, adisining tangkunang wa kuma' biwanga tota'. ");
INSERT INTO uvh_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Ka Setan ning arantagim undu' ningsa', adi anasa' ami' tanga kura' anikagareng tinting wa indi u kanga ning tontam, a adi pupusina kuma' ting adisining tangkunang wa kuma' biwanga tara' ning tontam. ");
INSERT INTO uvh_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Ka ning sanotik, sidi nagata' wa ning fararoknaming, a adi masi' unggo kadagasi ning girisi' Bielsebul wari amanga tanga fiarara' ning fananing. Ka indining, Farisi sidining arantagim fam adindu' masi' unggo kadagasi fufong tanga fayugukiting ning fatuguting. Ka adi tangkunang wa Bielsibul ganang udep bema titing wa warisa' kuma' saninga nakedani'. ");
INSERT INTO uvh_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Ka beng sini' na tangkunang wa Anutu ganangsa' bema tirik wara' sidi naning kane u ning nakedanga tonting, o beng sini' Anutuning bining ning tangkunang wa indiganang ingging kuma' kadofiinga kayam. ");
INSERT INTO uvh_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Abanga naga Setan ning napa' kadagasi tanga iguk wara'ning kamaga wa nua'ni ka ning, aming nua'ni wari aming tangkunang ni ning yak ganang amanga mambong fam iromanggaknonga wa adi kugurang sa' mo' anga amota'. Mokngang, adi tim ka napa' wara'ning tuang u bema kayong kafong ipma ipma kufara ning tanga wara'ganang inga' amanga bemnota'. Ning tota' wa giri kugurang sa' tanga mauta'. ");
INSERT INTO uvh_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Ka beng sini' aming ka kaba kareng guk ka naganing kabakna ningwara' mo' ira tota' wa naganing digirap. A aming ka naganing kane u yotangkanam ga' bak dabik mo' kura tantam undu' naganing kane tipkadanga yara wara'ning ning ita'. ");
INSERT INTO uvh_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Ka aming ka naganing digirap ning iik waraga' wa ning sanotik, aming wari midi kadagang a nasi' kadagang fam tinting wa Anutu adi suknakubeyam titining kadapmang guk. A kadagang ka aming wari Anutuning mini unggo kareng ning tangkunang u kuma' kanga a udi mini unggo kadagang ane'sa' tara' ning tonga anikige tinting wa Anutu adi suknakubeyam guk mo' tota' mokngang sini', adi kadagangsi' wara'guk ko ningsa' ira anting. ");
INSERT INTO uvh_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Abanga aming wari midi kadagang ka Amingning Tim Iyak naga nangkadanting undu' Anutu adi suknakubeyam ning kadapmang guk. A kadagang ka aming wari Anutuning mini unggo kareng ning kigineng u kuma' kanga a udi mini unggo kadagang ane'sa' tara' ning tonga anikige tinting wa Anutu adi suknakubeyam guk mo' tota' mokngang sini', kami yara'ganang a inga' undu' ko ningsa' ira anganga aming ka waraga' kagaya amimi waraga'sa' irota' ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Ka Jisas wari midi nua'ni ning yanggu', sidi kuma'sa' yabiting firi karesi ka mindip nana titining undu' mindip karesisa' titing. Beng sini' aming adi firi wara'ning mindip u yapma firi kareng wa ma kadagang ning u wara'ganangsa' yapkedating. ");
INSERT INTO uvh_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Ka aming ning kabaksi' undu' ningda'ning iking. Aming ka kaba ganang do sasuk a napa'napa' karesi guk irota' wa midini undu' kareng ningsa' touta' nakantam. Ka Farisi arantagim sidining kabaksi'ganang wa sasuksi' kadagang warisa' tonanga defata' wara' sidi beng kareng titining guk mokngang. Wara' na sidi gimik kadagang ning aranatagim ka aming mandaga' iiramikisi ning sabarik. ");
INSERT INTO uvh_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Abanga aming kareng adi adining kaba ganang wa sasuk kareng warisa' ikita' wara' adi kadapmang didimengsa' tita', a aming kadagang adi kaba ganang wa sasuk kadagang warisa' ikita' wara' adi nasi' kadapmang undu' kadagang ningsa' tita'. ");
INSERT INTO uvh_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Ka beng sini' ning sanotik, nasi' nasi' midi kadagang ka aming wari tuguting wa Anutu adi kuma'sa' kasusu'nanga ikita'. Wara' adi inga' aming midiganang kukyapma tagagareyabo' ganang wa Anutu wari anasining midi kadagang waraga' kagaya imo'ga'. ");
INSERT INTO uvh_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Aming ka midini didimengsa' tonga iik adi ananing midi didimeng warisa' tangaminga wa adi gi' iro'. A aming ka midi kadagang sa' tonga irota' wa adi inga' ananing midi kadagang warisa' taramikinga adi kadagang katuawa'ga' ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Ning tanga Juda arantagim ning sasuk aming wara'siguk ka Farisi arantagim guk wari Jisas u ning aniging, ai yanggek aming indi gu napa' tangkunang ni tanga ningtintingneinga kaga ga' nakem. ");
INSERT INTO uvh_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Ka Jisas wari ning yanggu', sidi napa' tangkunang ni tasaminga kaga waraga'sa' fatoing. Ka kadapmang ka u fiting wa aming ka naktangkasi' guk mokngang sasuksi' kadagang sa' tanga ikiting wari titing wara'ning unggungsa' yaranga tanga fananing sabarik. Wara' na napa' kigineng ni sidining dasi'ganang guk mo' totik, mokngang na napa' kigineng nua'ni ka tim profet Jona wari tugu' wara'ning ungungsa' wa giri tasaminga kanting. ");
INSERT INTO uvh_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Ka kadapmang ka tim ama ging pis girii wari profet Jona u kumenainga Jona wari ama ging ning kaba mang ganang do kama famineng urang kabigu' ningsa' ka Amingning Tim Iyak nandu' kama mang amanga kama famineng ning derok ga'. ");
INSERT INTO uvh_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Tim profet Jona wari aming arantagim nua'ni ka Juda mo' wara'sining yong girii kadagang ka wap Nineva u anga Anutuning midi ituainga adi midi u naknga kadagangsi' u kabinga kabaksi' faranga naktangka tiging. Wara' inga' Anutu wari aming midiganang kukyapma tagagareyap to' ganang wa Anutu wari Juda aming sidi naktangkasi' guk mokngang a arantagim nua'ni ka Juda mo' adi naktangka guk ning u kawa' warisa' tanga wa adi sidita' mamareng kabisamo'ga'. Ka beng sini' Jona wa aming girii de ka aming nua'ni ka kami yara'ganang ingging kuma' kadofinga ita' wa aming girii tim iyak sini' ka aming wari adining midisa' nakngam wara'ning wari kadofinga ita'. ");
INSERT INTO uvh_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Abanga nua'ni ka tim kwin taming girii nua'ni ka kama tubo saut tara' itarugu' wari king Solomon ning midi kareng u nakngamonga kama kamini sini' unggung kane girii tanga abugu'. Abanga kadofinga adining midi u naknga o beng guk sini' ning togu'. Wara' inga' kama ka Anutu wari aming midiganang kukyapma tagagareyabo' ganang wa Juda sidi naktangka guk mokngang a taming ka aming arantagim nua'nini adi naktangka guk ning kawa' warisa' tanga wa sidita' mamareng kabisamo'. Beng guk sini' sanirik Solomon wa aming girii de ka aming nua'ni ka kami i kadofinga ita' wa aming tim iyak sini' ka girii Solomon u tarafata'. ");
INSERT INTO uvh_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Ka na kadapmang ka mini unggo kadagang wari aming ning kabaksi'ganang iik waraga' wa ning toutik, aming ka tim mini unggo kadagang guk irota'. Ka inga' anikagare tinga aming ka u kabinga anga kama nua'ni ubu katuanga iikga' ning tonga anga kama base ka aming guk mokngang u wenanga yarota'. Ka mokngang adi yak nua'ni guk mo' katauta'. ");
INSERT INTO uvh_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Ning tanga ning surota', a na kama gipmam ka tim ira kabinga abuguk waraga' tubobu unda' mautik ning tonga adi aming ka wara'ganang tubobu ironga mauta'. Anga kauta' ka aming wara'ning kaba ganang wa napa' nua'ni guk mo' irota', mokngang adi kama gipmam u sumu kuma' tanga sigesa' tipgidibanga kabinga fideuta'. ");
INSERT INTO uvh_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","U kanga mini unggo kadagang adi ningsa' kanga kabinga amine mini unggo kadagasi fam ka seven ning ka kagaya sini' ubu inagiknonga mauta'. Anga inagira abanga aming wara'ning kaba wara'ganang amanga ikanting. Tim aming ka wa adining kaba ganang mini unggo kadagang kubaniksa' wari ikinga wa kadagang irota'. Ka inga' usap sini' ubu abanga ikinga wa adining iikni wa kadagang sini' ubu irota'. Ka kadapmang ka u torik ningsa' ka sidining aming fam ka nagata' naktangka kadagang guk ko iking undu' kuma'sa' abanga ifikadagainga inga' kadaga tini'ga' ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Ka Jisas wari ami taming midi u ko fianggu' ganang ka adining mengni a kuyane wari adita' wenanga abanga fugang do adenga toging. ");
INSERT INTO uvh_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Ka aming nua'ni wari yapma Jisas u ning anigu', ai guning mamangge a kuyage udi guta' wenanga abanga fidenga fatoing gam. ");
INSERT INTO uvh_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Ka Jisas adi midi kadapmang nua'ni ka mengne ganang u yora yangtintingnonga ning yanggu', naganing mamangne a kuyane wa unggungsa' mo'. ");
INSERT INTO uvh_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Ning tonga ananing arantagim u kafadudu yora ning yanggu', naganing mamangne a kuyane wa yang. ");
INSERT INTO uvh_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Beng sini' ning sanotik, aming ka naganing babangna kunimganang ita' wara'ning midi u ninaksa' tota' wa adi naganing kuyana a kuyana taming a mamangna sini' ning irota' ning togu'. ");
INSERT INTO uvh_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Ka kama ka wara'ganangsa' ka Jisas wari yong u kabinga amanga gwang gaga ganang u mareiagu'. ");
INSERT INTO uvh_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Ka aming arantagim kabi' kabi'mo' wari adining midi u nakonga anga adiganang bak girii tiging. Ka Jisas wari midi adenga tutugu ning kama guk mokngang waraga' tanga adi bot ganang aranga mera gwang ganang naro' dokning anga mareiagu'. Ning tinga ami taming adi gwang gaga u mera yareging. ");
INSERT INTO uvh_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Ka Jisas wari adining midi kareng u yanggeronga nakeda titi waraga' napa'napa' kabi'mo' u yora sireng sini' mo' yanggu'. Mokngang adi midi tipfara sa' tanga ina yaregu'. Ka adi ning yanggu', aming nua'ni wari nana wit mindip u manggara fonga feng ganang igura yarota'. ");
INSERT INTO uvh_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Ka wit beng udi feng ganangsa' mo' mangfanting, fam ka gaga sige kadapmang ganang mangfanting. Mangfanga sirengsa' marekiinga yang wari yora nanting. ");
INSERT INTO uvh_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","A wit mindip fam wa kama pamparangeng uningkim guk wara'ganang mangfanting. ");
INSERT INTO uvh_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Mangfanga kama fafageng kabi'guk waraga' tanga kagadofi udi giri urapsa' tinting. Ka kama kareng sini' mo' wara' fini tangkunang guk mokngang. Ka inga' mayam girii wari kama u danga wa tubobu urapsa' kaforanting. ");
INSERT INTO uvh_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","A wit mindip fam ka feng ganang gaga sini' mangfanting undu' ningsa'. Adi kagadofi udi giri tinting ka munggwak garas kusung guk wari kadofinga farafiabinga kirida tanga beng guk mo' tinting. ");
INSERT INTO uvh_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","A mindip beng ka feng bining kama kareng ganang didimeng mangfanting wa kareng giri kadofinga giranga fam ka beng karesi sini' kabi'mo' ka nambani 100 ning tinting a fam ka karesi ging ka nambani 60 ning tinting. ");
INSERT INTO uvh_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Ka Jisas wari midi tipfara u tanga ina ning tanga ami taming u ning yanggu', aming ka sasuk guk wa midi u torik wara'ning ki u sura nakedanting ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Ka Jisas ananing arantagim adi Jisas wari midi tipfara sa' tanga yanggu' waraga' tanga inga' Jisas u ning anigaging, ai girii gu ami taming yanggeronga wa midi tipfara sa' wa indining tanga fainarang. ");
INSERT INTO uvh_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","12","Ka Jisas wari ning yanggu', ning sanotik sidi naganing arantagim sini' wara' na Anutuning bining ning midi kapmo' wa sirengsa' ituasamitik a aming sige ga' wa na sireng sini' ning guk mo' taimirik. Beng sini' Anutu adi kadapmang ka ning tita', aming ka Anutu wari midi aniinga naknga bemdasi tota' wa Anutu adi inga' sasuk karesi fam kabi'mo' nua'bu amiinga adi aming sasuk guk ning irota'. A aming ka Anutu wari midi tuguinga kafakafa mo' nakota' adi sasuk ga' nafek tanga ananing sasuk kabi'sini' wara'guksa' ira auta'. Ka inga' Anutu wari adining sasuk kabi'sini' u tubobu irombemnainga adi aming sasuk kabi'guk mokngang sini' ning irota'. ");
INSERT INTO uvh_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Ka aming arantagim girii adisining kadapmang wa ning titing, na kane tangkunang adisining dasi'ganang titik ka adi kaga wa giri titing ka wara'ning ki sini' guk mo' kigedating. Abanga na naganing midi kareng ituatik ka adi ninak wa giri titing, ka mokngang midi wara'ning ki sini' guk mo' nakedating waraga' tanga na adisita' midi ituaimonga wa na midi tipfara sa' tanga fainarik. ");
INSERT INTO uvh_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Ning tinga midi kareng ka tim profet Aisaia wari ituagu' wari beng guk kadofigu'. Midi ka wa ning togu', “ka sidi midi u naknga kiga' ning tonga wenanting, ka mokngang wara'ning ki kabi'guk mo' katuanting. A sidi napa' ni u kanga kini ga' ning tonga wenanting, ka mokngang ki sini' guk mo' kigedanting. ");
INSERT INTO uvh_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Abanga aming arantagim ka wara'sining sasuksi' wa midi ka ning u bema dasi ning guk mokngang, adi maasi' kuma' isefing a dasi' undu' kuma' deguring. A adi ning guk mo' tianing ganang wa adi ki wa dasi' wari sireng sini' kuma' kigedianing. Ning tanga midini undu' maasi' wari naknga nakeda sini' tianing, a kabaksi' undu' midi ka u kuma'sa' bema dasianing. Ning tanga adi nagaganang tubobu faranga abuinga na kafakafa tiamarok ning togu'.” ");
INSERT INTO uvh_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Ka naganing arantagim sidi kafakafa sini' ka dasi' wari sireng sini' kanga kigeda sini' tanga a maasi' wari midi u naknga kini nakedanga ning kuma' ting. ");
INSERT INTO uvh_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Beng guk sini' sanirik tim profet arantagim kabi'mo' a Anutuning sasuk aming karesi kabi'mo' adi napa' girii ka sidita' i tasaminga kaing a midi kareng ka i saninga naking i kanga a ninak waraga' siamo' naknga tanga ira fabaiaging. Ka mokngang adi kaga a ninak kabi'guk mo' tanga kumoinga kami yara'ganangsa' kaga tanga a ninak tanga ning wa sidisa' ting. ");
INSERT INTO uvh_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Ka naganing arantagim sidi naga midi ka aming wari feng ganang wit mindip iyuguk ga' tongak waraga' nangkanging wara'ning ki wa ning sanotik, ");
INSERT INTO uvh_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","ka wit mindip fam ka kadapmang ganang mangfuinga yang wari yora nating ning tongak wara'ning ki wa ning, naga Anutuning bining ning midi kareng ituainga aming wari u kuma' nakiting de ka aming kadagang Setan wari Anutuga' naktangka ma tini' ning tonga adining sasuk kadagang wari ufafeim tita'. ");
INSERT INTO uvh_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","A wit mindip ka kama uningkim kuguru' guk wara'ganang mangfanga kadofakirida titing ning tongak wara'ning kini wa ning, aming fam adi naganing midi kareng u naknga o beng guk ning tonga mesisiringa urapsa' titing. ");
INSERT INTO uvh_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Ka adi midi ka wari kabaksi'ganang mang sini' mo' amota', usingsa' irota'. Ka inga' midi kareng waraga' tanga mamareng fam kadofingamonga titi wa ma aming fam wari kadagang ni taramikinga ganang wa adi mamareng waraga' mutu tanga midi kareng u urapsa' kabota'. ");
INSERT INTO uvh_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","A wit mindip ka feng gaga mangfuinga munggwak kadagasi wari kadofinga ipmusinga girakirida tanga beng guk mo' titing ning tongak wara'ning kini wa ning, aming fam ka Anutuning midi kareng u naknga sasukni ganang kuma' naktangkauta' ka inga' adi sasuk mimeng ka napa' mamareng adining iikni ganang kadofingamota' a sasuk ka kamaganangning napa' kangasi iikga' surota' wari mandaga' taramikinga adi wara'ning kanesa' tota' wari Anutuning midi kareng u ugamusinga adining naktangka wari beng guk mo' kadofota'. ");
INSERT INTO uvh_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","A wit mindip fam ka feng bining kama marang guk kareng ganang sini' mangfanga kadofiting ning urang tongak wara'ning kini wa ning, aming fam adi Anutuning midi kareng u naknga kabaksi'ganang beng sini' bema dasinga naktangka tanga ira kane karesi kuni' kuni' tanga yaranting wa wit ka beng karesi usap sini' tanga yaranting ning urang tongak wang ning yangtuanga yaregu'. ");
INSERT INTO uvh_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Ka Jisas wari kadapmang ka aming wari Anutuning bining ganang iikning waraga' midi tipfara kabi' nua'bu tanga ami taming u ning yanggu', aming wari wit mindip feng ganang ipmonga wa adi mindip iri karesi unggungsa' ipmota'. ");
INSERT INTO uvh_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Ipminga ning tanga kabinga anga kane aming arantagim guk adi dama kuma' dekinga adisining digirapsi' nua'ni wari tiim ganang kapmo' abanga feng u tipkadaunga wit baseni kiptasi mindip u manggara fabanga feng wara'ganang u igura yarota'. ");
INSERT INTO uvh_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Ka inga' wit wari kadofinga giranga beng tonga tinga kane aming wari wit baseni wa wara'ganangsa' yapkedanting. ");
INSERT INTO uvh_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Ning tanga anga feng wara'ning tuang u ning aninting, ai girii gu wit mindip karesisa' ba niminga ipmigum, ka wit kadagasi guk wa indining tanga kadofinga yabem. ");
INSERT INTO uvh_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Ka feng tuang adibu ning inota', o kuma' nakedarik naganing digirap ni wari kapmo' inga' unda' abanga tanamgu', ning touta'. Ka arantagimni wari ning aninting, ka gu indining sutang wit kadagasi u kadofing wa anga tamara iguk tantam wa. ");
INSERT INTO uvh_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Ka feng tuang wari ning inota', mo' wit karesi guk ma tamakni' wara' ningsa' kureng adeing. ");
INSERT INTO uvh_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Inga' wit wari beng tanga kuraga sini' tinga kane aming wit beng dudop ning unggungsa' ka ning kuma' inok, sidi tim ka wit kadagasi u tamara manggara kudip sasa waraga' bak naro' tini'. Ning tanga wit karesi unggungsa' dopma manggara fonga naganing wit yak ganang u dasanting ning kuma' inotik ning touta'. ");
INSERT INTO uvh_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Ka Jisas wari midi nua'ni ubu inonga midi tipfara nua'ni nua'bu ning tanga yanggu', ka Anutuning bining wari kagadofi ning wa kadapmang ka aming nua'ni wari firi mindip kabasi'sini' ka mastet u ipmiinga kagadofi ning ningda'ning tota'. Ka firi mastet mindip wa firi mindip fam ka girisi da'ning urang yating ningwara' mo', mokngang wa kababi'sini' ka didik fam ning mindip da'ning, kururusa' kautang. ");
INSERT INTO uvh_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Ka u bema tonga feng ganang ipmotang wa mindip kabasi'sini' ka wari kadofinga girii sini' ubu giranga nana fam ka feng ganang adenting u irafira firi da'ning ikinga yang wari wara'ganang yori udi girisa' manting ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Ning tanga Jisas wari midi tipfara nua'bu tanga ning yanggu', Anutuning bining wari kagadofi u nakeda wara'ning wa kadapmang nua'ni ka ning, ka sidi kuma'sa' yabiting napa' yis ka nana tanga sana ning wa napa' girisi mo', kururusa' yating. Ka taming wari baret tanga saunga wa adi palaua wa mimeng gira ning tanga yis wa kabi'sini'sa' karapnanga ipmating. Ning tanga palaua wara'guk tipfara tipfara tanga kamiinga baret anasa' girii bekinga wara'ganang seting ning titing waraga' sukni', ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Ka Jisas wari ami taming u midi ka Anutuning bining ning kadapmang wara'ning u ituaima abugu' wa adi midi sireng sini' ka ni guk mo' yanggu', mokngang adi midi tipfara sa' tanga yanggu'. ");
INSERT INTO uvh_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Ka midi ka Jisas wari tipfara sa' u tanga yanggu' waraga' ka tim profet wari tuguinga yoking wa ning, “naga napa' ni ning midi inonga wa midi tipfara sa' tanga inotik. Na midi ka napa' girisi ka aming wari wara'guk mo' naknga ira abuting wara'ning u inotik.” Ning yoking wari kama ka wara'ganang wa beng guk kadofigu'. ");
INSERT INTO uvh_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Ka Jisas adi aming arantagim ka midi kura fianggu' u ibinga yak ganang ubu amogu'. Amoinga Jisas ananing arantagim sini' wari mandang yaranga amanga ning anigaging, ai girii gam gu midi ka tim aming wari wit baseni feng ganang ipminga kagadofi waraga' tongang wara'ning kini wa indining. ");
INSERT INTO uvh_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Ka Jisas wari ning yanggu', midi ka u tongak wara'ning kini wa ning, aming ka wit mindip karesi ipmota' wa Amingning Tim Iyak wari Anutuning midi kareng u ipmira'. ");
INSERT INTO uvh_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","A feng ning tongak wa kamaganang yara'ning aming yong yong iking waraga' tongak. A wit mindip karesi wa aming karesi ka Anutuning bining ganang sini' iking wang. A wit mindip kadagasi baseni wa aming ka kadagang titisi aming kadagang Setan ning arantagim ka aming karesi ning bining ganang dabik ikiting waraga' tongak. ");
INSERT INTO uvh_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","A aming ka feng tuang wara'ning digirap wa aming kadagang Setan waraga'sa' tongak. A feng wari kuraga tinga wit beng u dopma manggak ga' tongak wa kama ka kunim a kama yari bibi' wara'ning kama ari' wari kadofiinga Anutu wari naktangka aming inagikna waraga' sura tongak. A wit beng u mamanggak ning kane aming arantagim wa Anutuning kunung aming arantagim ensel waraga' tongak. ");
INSERT INTO uvh_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Ka aming wari wit kadagasi u tamara kudip ganang kurasa ga' tongak wa inga' kama ari' wari kadofiinga ");
INSERT INTO uvh_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Amingning Tim Iyak naga naganing kunung aming ensel u yangkareinga anga aming kadagasi ka aming fam wari kadagang titiga' yangdidenga abanga aming ka kadagang titing ka kami yara'ganang aming arantagim karesi ka Anutuning bining ganang ikiting wara'guk dabik iking u yapma tagagarenga ");
INSERT INTO uvh_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","manggara fonga kudip kadagang ganangsa' igukinga dani'. Ning tinga adi kagaya girii bema maksa' kara ira ani'ga'. ");
INSERT INTO uvh_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Ning tinga aming karesi Anutuning arantagim adi anga babangsi' Anutuning bining ganang gi'sa' ira aming ka kadagang ni guk mokngang fafa' sini' ka mayam de ning diok urang katam ningda'ning ikinga yapni'ga'. Aming ka sasukni kareng guk wa midi ka u torik u kafakafa sura naknga tanga irota'. ");
INSERT INTO uvh_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Ka aming wari Anutuning bining kareng u kataunga karengsa' naknga iik wara'ning midi tipfarani nua'ni wa ning, aming nua'ni wari feng tanonga kama u dininga fauta'. Anganga kama wara'ning mang ganang napa' tangkunang nua'ni ka aming fam wari timinggi' sepma kayonting unggung dininga katua sa' tota'. Napa' ka u katuauta' wa moni girii a mambong karesi sini' ka moni girisi warisa' toning u bokis ganang dasinga kamaganang unafarafiinga defarota' u katuauta'. Kataunga de danga ning tanga anata' bemna ga'sa' sura ning touta', ai feng ya aming nua'nining kamaganang fatarik. Ka na indining da' tanga napa' tangkunang ya nagata' bemnotik ning tonga mambong bokis u tubobu ningsa' farafanga sepma anga kane girii tanga adining napa'napa' mambong u manggaksasu'nanga fonga kama tuang waraga' aminga ning tanga kama wa anata' ubu bemnota'. Ning tinga moni bokis u katuauta' wa ananing sa' ubu irota'. ");
INSERT INTO uvh_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Ka Anutuning bining kareng u kataunga karengsa' naknga iik wara'ning midi tipfara nua'ni undu' ning, aming nua'ni wari kaneni ka kungkum karesi sini' u manggara fonga aming fam ga' ima uningkim mambong manggakna ning tanga irota'. ");
INSERT INTO uvh_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Ka adi fiking ni ganang aming nua'nining kungkum tangkunang sini' u kauta'. Kungkum ka ningwara' wa nua'ni guk mokngang, kubanik warisa' ka kareng sini' wara' adi kungkum ka u kanga kaba marara bemna titi ga'sa' nakota'. Ning tanga adi ananing mambong tangkunasi tangkunasi a kungkum karesi fam u manggara bak girii dabiksa' tanga fonga aming ka kungkum kareng sini' bemnota' wara'ning tuang waraga' amota'. Ning tinga adibu kungkum kareng sini' u amota'. ");
INSERT INTO uvh_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Ka Anutuning bining wara'ning midi tipfara wa nua'ni ka ning, ka sidi ama ging mamanggak ning ari' girisi umben wara'ning kane undu' kuma'sa' tanga kating. Adi ama ging fis u manggaronga wa umben u manggara bot ganang mera anga umben wa gwang bining do ipmating. ");
INSERT INTO uvh_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Ning tinga ama ging kuni' kuni' wari umben wara'ganang amanga toneinga adi u wengbema tonga gaga do kadofinga kamaganang u kwasineting. Ning tanga mera tagagare tanga karesi wa manggara kama naro' kukna a kadagasi wa manggara iguk ning titing. ");
INSERT INTO uvh_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Ka kama yari ari' biunga to' ganang undu' ningsa', Anutuning kunung aming ensel arantagim wari kama kama u yangara didimesi karesi yapma mamanggak a kadagasi yapma tarayap ningsa' tanga yarani'ga'. ");
INSERT INTO uvh_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Ning tanga aming kadagasi ka u tarayapni' wa manggara kudip kagaya girii ganang kura ipmainga danga kagaya kadagang sini' naknga kugwak ningsa' tonga ira ani'ga'. ");
INSERT INTO uvh_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Ka Jisas wari arantagimni u ning yangkagu', ma' sidi midi ka u tonga yararik wara'ning ki guk u nakeding. Ka arantagimni adibu ning aniging, weng una kuma' nakedem. ");
INSERT INTO uvh_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ka Jisas wari ning yanggu', weng kuma' naking wara' sidi aming wa indining da'ning ubu iking waraga' ubu sangdidimotik. Beng sini' tim wa sidi Moses ning midi tang u naknga wara'ning sasuk guksa' ikiting. Ka inga' yara'ganang wa naga naning midi karesi fam ubu saminga naknga ning tanga sidi Anutuning bining ning kane aming arantagim kigineng guk ning ubu kadofinga iking. Wara' sidi aming kangasi sini' ka napa' mambong tangkunang timini a inga'ni ga' nafek guk mo' urang titing ningda'ning kuma' iking ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Ka Jisas wari midi u ina ina ning tanga biinga yong ka u kabinga marara ");
INSERT INTO uvh_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","ananing yong ki Nasaret waraga' ubu agu'. Anga Nasaret yong u kadofinga anasining siring yak ganang amanga midi kareng u ituaimgu'. Ning tinga aming ka ananing yong ki wari adining midi wa kuni' nua'ni sini' naknga iguk areging. Ning tanga ning tonga yareging, ai adining sasukni wa kabasi' mo' kayam. Adi sasuk ka wa indeng bema tora'. Abanga napa' kane tangkunang mirakel u tanga fiarara' wa adi tangkunang wa indeng bemgu' wari tanga fiarara'. ");
INSERT INTO uvh_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Adi aming yong nua'nining mo' wara' indi nafek tonga, mokngang adi kamanda ning mindingni sa' urang udi. A adining mengni iibe tugu' wa Maria yang a adining kuyane wa Jems Josep Saimon a Judas ning urang udi. ");
INSERT INTO uvh_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Abanga adining kuyane taming undu' i fengaking yang. Ka adi sasuk ka wa indeng kanga bema tabanga tara'. ");
INSERT INTO uvh_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ning tonga adita' bibi' nakngama manda ukngamging. Ka Jisas adi adisining kabaksi' u kuma' yapkedanga ning yanggu', beng sini' aming girii profet wa yong fam warisa' adining midi ga' naknga kafakafa tangamiting. A aming ka ananing yong dabik a arantagimni sini' adi mokngang, adining midi u naknga tara naknga bibi' nakngamiting. ");
INSERT INTO uvh_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Ka Jisas ananing yong ki aming adi bibi' nakngama adining midi guk mo' nakngamging waraga' tanga Jisas adi kane tangkunang mirakel wa yong ka wara'ganang wa mimeng sini' mo' tugu', kubanik kubaniksa' tugu'. ");
INSERT INTO uvh_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Ka kama ka king Herot wari kama tubo Galili tara' u katatoranga mareiagu' wara'ganang ka adi Jisas wari kane tangkunasi mirakel fam tanga agu' wara'ning midi ne u naknga base tugu'. ");
INSERT INTO uvh_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Herot adi mutu tanga ananing kane aming girisi u ning yanggu', aming ka u tanga abara' wa Jon Baptis urang gufadagagum wari tubobu marara tanga abara'. Adi tangkunang kigineng girii guk marara wa kane tangkunang u tanga abara' wang ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Ka tim king Herot wari Jon Baptis taramiku' wara'ning midi wa ning. Tim wa Herot adi ananing kuyang kabasi' Filip ning tamni wapni Herodias u iromkadara bema tonga sanagu' waraga' tanga Jon Baptis wari fikifiki Herot u ning anga fanirugu', gu kuyaga ning tamni iromkadagung wa kadagang tugung. Ka Herot adi midi ka u naknga bibi' naknga aming fam yangkareinga anga Jon u nagira tonga kalabus iyung dasiinga kalabus ganang unggung itarugu'. ");
INSERT INTO uvh_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Ka Herot adi Jon wari adining kadagang waraga' fikifiki fanirugu' waraga' tanga adi kaba kadagang sini' nakngama ning tanga Jon u ugumak titi waraga'sa' kuma' suku'. Ka ami taming kabi'mo wari Jon u profet girii ningda'ning kayaging waraga' tanga na uuk totik wa adi kadagang ma napni' ning tonga waraga' tanga sura kabiinga Jon adi iyung kane kalabus ganang unggungsa' itarugu'. ");
INSERT INTO uvh_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Ka kama nua'ni ganang Herot wari mengni wari ana ibegu' wara'ning kama u kataunga tangsana tugu'. Ning tanga amine fam u katiana abanga nana tangsana tugu' u mera naging. Ka Herot ning tamni Herodias ning ibingini sababa wari marara mime tugu'. Ka Herot wari u karengsa' kanga ");
INSERT INTO uvh_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","ning anigu', ai beng sini' ning ganirik gu napa' niga' naknga toutang wa na ganggam sa' totik. ");
INSERT INTO uvh_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Ning tuguinga taming sababa wara'ning mengni Herodias wari anga ibingini waraga' sasuk amiinga sababa wari Herot u ning anigu', na gu Jon Baptis ning ki kati u doptanga plet ganang sireng kaminaminga kaga ga' nakarik. ");
INSERT INTO uvh_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Ka king Herot adi midi ka u naknga kaba mamareng ubu naku'. Ka adi taming waraga' napa' ni amimi sa' titi waraga' midi u aming ning dasi'ganang kuma' totangkagu' waraga' sura kubase' aiganga adining kane aming fam u ning yanggu', sidi i anga napa' taming wari tora' u anga tini'. ");
INSERT INTO uvh_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Ning ina yangkareinga anga kalabus yak ganang u amanga Jon Baptis ning kadare u doptagaging. ");
INSERT INTO uvh_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Doptanga ki kati wa plet ganang kaminga bema tabanga taming sababa waraga' amiging. Amiinga adibu bema tonga mengni Herodias waraga' amigu'. ");
INSERT INTO uvh_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Ka Jon Baptis ning arantagim wari midi ne ka Jon gufadagaging wara'ning u naknga marara abanga Jon ning bapmo u bema tonga kama ginang ganang kamiging. Kaminga ning tanga tubobu anga Jisas u aniging. Ka Herot adi ning tugu' wara' adi midi ne ka Jisas wari kane kigineng ka tim Jon Baptis wari tugu' ningda'ning anga tugu' wara'ning u naknga o Jon Baptis ane' tubobu ba marata' ning togu' wang. ");
INSERT INTO uvh_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Ka Jisas adi midi ka Jon uking wara'ning u naknga ning tanga anapmo' naro'sa' anga fugu u kafakafa kabi' kaminga marek ga' sura kama tubo u kabinga marara bot ganang aranga mera kama tubo ka aming yong guk mokngang kama sigesa' waraga' mugogu'. Ning tinga kama tubo wara'ning ami taming kabi'mo' wari Jisas wari kama tubo waraga' anapmo'sa' mugogu' wara'ning midi u naknga kasi'ganang mandang yaranga anga bak girii tanga kapmeking. ");
INSERT INTO uvh_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Ka Jisas adi inga' anga kadofinga bot u irara bemkura amanga ami taming arantagim girii u tangkunang ga' nafek sini' tanga ingaging u yapma bibiri' siamo' yapku'. Yapma ning tanga aming wara'sining bagana aming kabi'mo' u ifakarendaima yaregu'. ");
INSERT INTO uvh_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Ka Jisas ananing arantagimni adi kibiri mandang inga' anga kadofinga kama kuma' tugu' u kanga Jisas u ning aniging, ai girii kama kuma' tara'. Kama ka ya aming yong guk mokngang kama sigesa' urang adeta' wang, ka ami taming ya iibi tinga yongganangga' anga nana fam yapma tonayangakni' ning aniging. ");
INSERT INTO uvh_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Ka Jisas wari ning yanggu', mokngang na mo' ibiinga manting, nana wa sidisa' yamni'. ");
INSERT INTO uvh_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Ka arantagimni adibu ning aniging, ai girii indi nana guk mokngang indining nana wa fama'sa' ka baret pumpungaresi kababi' sini' ka faiv ning a ama ging kafo undu' kababi' sini' ka fama'sa' ningsa' adeing, ka wa indining da'ning tanga nana ka ningwara' aming arantagim girii i yamtam. ");
INSERT INTO uvh_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Ka Jisas wari ning yanggu', nana fama'sa' toing u nagata' i manggaknama abani'. ");
INSERT INTO uvh_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Ning tuguinga arantagimni wari nana fama'sa' u manggara fonga Jisas ga' amigu'. Ning tinga Jisas wari ami taming arantagim girii u ning yanggu', aming sidi kwang mekni'. Ning ininga mera yareinga Jisas wari nana kafo baret faiv a ama ging kafo fama'sa' u manggara fonga kura beni Anutuga' ibang asekna ning togu'. Tonga ning tanga nana kafo u upma arantagimniga' iminga arantagimni adibu manggara fonga aming arantagim girii wara'siga' ima yareging. ");
INSERT INTO uvh_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Ning tinga aming arantagim kabi'mo' wari nana u dabiksa' nibera dibing wa nagaremik tanga ibiging. Ka arantagimni wari nana dibing nagaremira ibiging u manggara manggara fabanga bak kura unup ari' usap ka 12 ning u dasitoneging. ");
INSERT INTO uvh_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Ka aming arantagim girii ka Jisas wari nana u iminga naging wa kabi'kabi'mo' ami a taming a sababi' ning wari dabiksa' naging, ka adi ami ning namba unggungsa' indangiking wa faiv tausen ning a taming a sababi' undu' kabi'kabi'mo' ka adi wara'guk mo' indangiking. ");
INSERT INTO uvh_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Ning tanga Jisas wari arantagimni u ning yanggu', sidi bot ganang aranga mera gwang fugung ga' tubobu tim mani'. Na aming arantagim i yaksingga' yangkarasasu'nanga ning tanga mandang kuma' sawara autik. Ning ininga arantagimni adi tim mugoging. ");
INSERT INTO uvh_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Ning tanga Jisas adi aming arantagim u yangkarasasu'nanga anapmo'sa' adenga Anutuga' ibang tounga kama bubo ganang aregu'. Ning tinga kama kuma' garegu'. Ka adi anapmo'sa' mera ibang ko futogu'. ");
INSERT INTO uvh_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Ka arantagimni adi gwang fugung do urapmo' anga kadofiging, gugubik kigineng wari gwang u figikbibingeinga kane girii tanga gimanggi'sini' ko famugoging. ");
INSERT INTO uvh_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Ka adi gwang bining u ko famugoinga kama faunga dudure kuma' tugu' ganang ka Jisas wari mandang iwara anga gwang furo'ning u kamaganang da'ning tipminga agu'. ");
INSERT INTO uvh_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Anganga dudure tanga dokning ko aramugogu' ka arantagimni wari tonga kanga nasi' kayam ning tonga mutu girii tanga kugwak tonga ku ning katiging, ai wa nasi' kadagang kayam wa. ");
INSERT INTO uvh_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Ka Jisas wari ning urapsa' tabanga katianggu', sidi mutu mo' tinting gi' marekni' nagasa' abarik. ");
INSERT INTO uvh_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Ka Pita wari ning tonga katinganggu', ai beng wa torang girii, ga beng sini' wa. Ga beng udep wa katinang tinga gwang ganang wa sa'tatora agawak. ");
INSERT INTO uvh_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Ning tuguinga Jisas wari Pita u katinganinga Pita wari bot u kabinga bemkura amanga gwang furo'ning u tipminga aramugogu'. ");
INSERT INTO uvh_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Anganga gugubik kigineng u kanga sasukni wari waraga' ubu tanga mutu tinga gwang furo'ningsa' tipminga aramugogu' u mamare tanga gwang mang ubu mamonga tugu'. Ning tanga Jisas u katinganggu', ai girii urapsa' yotangkanam te', mang mugo tonga tirik yang. ");
INSERT INTO uvh_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Ning tinga Jisas wari urapsa' abanga suronga wenga bema kaminga ning anigu', a Pita gu nagata' naktangka sa' mo' tarang wara' u mamonga tarang ukaya'. Tim wa naga girisa' yotangkagapning ning napmang ka inga' wa mokngang ningda'ning ubu ba nabarang. ");
INSERT INTO uvh_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Ning aninga ning tanga Pita u bema bot ganang kaminga ning tanga Jisas ana undu' bot ganang dabik ubu aranga mera aramugoinga gugubik kigineng girii fabugu' wari kaga' urapsa' dagagu'. ");
INSERT INTO uvh_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Ning tinga arantagimni wari u kanga Jisas ning wap bema aranga ning toging, o gu Anutuning mindingni beng sini'. ");
INSERT INTO uvh_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Ning tanga Jisas guk ka arantagimni guk dabik bot ganang mera anga kama tubo Genesaret ubu kadofiging. ");
INSERT INTO uvh_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Anga kadofiinga aming ka kama fugung wara'ni adi Jisas u kuma' kigedanga ning tanga anga amise yong fam u ina yareinga adindu' bagana aming inagira Jisas kaunga abiging. ");
INSERT INTO uvh_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Abanga kadofinga Jisas u midi tangkunang ning aniging, o girii indining bagana aming wari guning kwi' sunom kabi'sini'sa' udi girisa' wa tifema karendanting. Ning tuguinga Jisas adi adisining midi u naknga aigaim sa' tanga ibiinga bagana aming kabi'mo' wa ningsa' tanga karendasasu'neging. ");
INSERT INTO uvh_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Ka Farisi arantagim guk ka Juda ning kadapmang tang wara'ning sasuk aming fam wari Jerusalem yong girii u kabinga Jisas kaunga aging. ");
INSERT INTO uvh_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","Anga kadofinga Jisas u ning aniging, ai indi ning yabem ka guning arantagim adi Juda indining tangandasi ning kadapmang tanga ikitam u kuma' kabing. Adi nana naunga wa Juda indining kadapmang yaranga kafasi' kafakafa guk mo' yotira sige manggarana sa' fating fayabem ning aniging. ");
INSERT INTO uvh_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Ka Jisas wari ning yanggu', udi giri toing ka ning sanotik sidindu' Anutuning midi kadapmang fam u kabing. Kabinga ning tanga midi kadapmang ka sidaning sasuksi' ganangsa' inggekiting wara'ning unggungsa' yaring. ");
INSERT INTO uvh_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Beng guk sini' Anutuning midi tangkunang wara'ning nua'ni wa ning fideta', sidi mamangse babangse ga'sa' sukanting. A aming ka mengbe ga' guk mo' sura adisining wap tipkadauta' wa kungkumak sa' tota' ning yoking. ");
INSERT INTO uvh_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","6","Ka sidi kadapmang tangkunang ka u tarafironga kadapmang mandaga' nua'ni ka ning fating, mamangse babangse wari ai sidi uningkim mambong guk wara' kabi'ning yotangkanipni' ning saninga wa sidi ning initing, o bibiri' sini' uningkim ka wa Anutuga' amimi waraga' kuma' totangkangam wara' na mo' yotangkasamotik ning fainiting. Ka beng sini' Anutuga' amimi ga' kuma' totangkaring waraga' sura udi giri initing. Ka mokngang sidi Anutuning midi tangkunang girii nua'ni ka mamangse babangse yotangkayap ga' togu' u tarafira sidaning sasuksa' yaranga tanga fainggeking. ");
INSERT INTO uvh_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Beng sini' sidi aming midi buburap tuang. Ka Anutuning midi ka tim profet wari tuguinga yoking wa kadapmang ka sidi u ting waraga' didimengsa' togu'. U yoking wa ning, ");
INSERT INTO uvh_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","“aming arantagim ka wa nagata' mesisiringa wa masi' wari using sigesa' tanamiting, a sasuksi' a kabaksi' wa nagata' kabi'guk mo' nakiting. ");
INSERT INTO uvh_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Adi Anutuning midi yanggekem ning tonga kadapmang ka aming anasaning sasuk ganangsa' u tanga yanggera ya Anutuning midi sanggekem ning wa sigesa' tuguting. Ning tanga nagata' mesisiringa ka adi titing wa using sigesa' titing ning yoking.” ");
INSERT INTO uvh_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Ning tanga Jisas wari aming arantagim sige u katiana fonga kukyapma ning yanggu', sidi midi ka i sanotik ya kafakafa mera nakni'. ");
INSERT INTO uvh_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Beng sini' napa' kadagang sini' ka kabaka tipkadaga wara'ning wa napa' ka nana titining u bema nautang wari tanga mo' ifakadagating. Mokngang wa napa' kadagang ka aming ning bane mang do irota' ka aming wari midi touta' ganang kadofota' wari'sa' wa aming ifakadagating wara'ning ki sini' ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Ka inga' Jisas ananing arantagim wari Jisas u ning aniging, girii gam midi ka u torang wa Farisi arantagim adi guning midi wa kadagang ning naknga kabaksi' kadagang nakaming udi kuma' ba yabarang. ");
INSERT INTO uvh_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","14","Ka Jisas wari ning yanggu', a adi barap ba ting. Ka kadapmang ka adi naganing midi ga' bibi' naking wara'ning waraga' wa ning toutik, naganing sibeng kunimganang ita' adi aming ka feng kane tanga ikiting ningda'ning tanga ita'. Adi feng ganang wa napa' karesisa' irobita', a napa' ka adi mo' irobita' ana kadofiting wa adi tamara iguk tita'. Wara' sidi nipbarap tinting waraga' kabaksi' mamareng naknga sasuk mimeng mo' tinting. Ka Farisi arantagim wari anasining sasuk ganangsa' fainggeking wa kadapmang ka aming de kadagang nua'ni wari de kadagang nua'ni u anatintingnonga tanga kwang ginang ganang fama'guk dabiksa' urang mangfanga kadagating ningda'ning titi wara'ning fating ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Ka Pita wari Jisas u ning anigagu', girii gu midi kabi' ka u torang wara'ning ki u ningdidima sini' tinga naknam. ");
INSERT INTO uvh_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Ka Jisas wari ning yanggu', a midi ka u torik wa sidindu' nafek ko ba ting. ");
INSERT INTO uvh_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Midi ka kadagang wari aming tipkadaga ning tongak wara'ning ki wa ning sanotik, napa' ka nana titining u nanga kumenotang wari amanga kabaka mo' tipkadauta' Mokngang adi amanga adeia' tubobu kuma' kadofinga mauta' wara' aming wa wari tipkadaga ning guk mokngang sini'. ");
INSERT INTO uvh_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","A aming tipkadaga ning sasuk kadagang wa aming ning kaba mang do ira aming wari tokadofiinga aming fam wari nakiting warisa' wa aming ifakadagata'. ");
INSERT INTO uvh_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Ka napa' kadagang ka aming ning kabaksi' mang do ira aming ifakadaga wara'ning kadapmang kadagasi wa ning, sasuk kadagang titi a aming nua'ni urasep a ananing tamni a ufini u kabinga taming a ami nua'ni guk mumungguk kadagang sansaramik titi, abanga kubu sasop a midi mandaga' a midi kadagang sige yangbe ning u titing. ");
INSERT INTO uvh_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Kadapmang kadagasi ka ningwara' warisa' aming ning kaba ganang do ira wa aming u tipkadauta'. A kadapmang ka nana naunga kafasi' guk mo' yotira manggarana waraga' tuguting wa aming ning kaba tipkadaga ning guk mokngang sini'. Wara' beng guk sini' sanarik, aming ka kafong guk mo' yotira nanasa' tota' wa kadagang mo' tara' ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Ka inga' Jisas se' wari yong ka u kabinga kama tubo ka yong girisi fama' ka Taia guk ka Saidon guk wari adeiagumu' tara' waraga' ubu aging. ");
INSERT INTO uvh_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Anga kadofiinga Kenan taming ka arantagim nua'ni Juda mo' unggung wara'ni wari Jisas ganang abanga Jisas u ning katinganggu', ai girii Devit ning iri gu napbubure tanga yotangkanam te'. Naning yapna udi mini unggo kadagang wari tanga tipkadaga sini' kuma' tara' ning togu'. ");
INSERT INTO uvh_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Ka Jisas adi midi tubobu kabi'guk mo' anigu'. Ka taming udi iibi guk mo' tugu'. Ko tonga iwara mugogu' u kanga arantagimni wari Jisas u ning aniging, ai girii taming i katinga indawara fabara' ikaya', anigara tinga tubobu mawa'. ");
INSERT INTO uvh_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Ka Jisas wari ning togu', na sibeng wari kamaganang i nangkareinga afuguk wa adi aming arantagim nua'ni ga' mo' nangkaregu'. Mokngang na Isrel arantagim ka sipsip papusana titining ningda'ning iking u yotangkayap waraga'sa' nangkaregu'. ");
INSERT INTO uvh_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ka taming wari Jisas ning midi u naknga Jisas ning kayong ganang u manda upma mera tangkunang sini' nua'bu anigu', o girii gu yotangkanap te'. ");
INSERT INTO uvh_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Ka Jisas adi Juda aming wari aming arantagim nua'ni wa kadagasi ning yabayaging waraga' sura midi tipfara tanga ning anigu', indining, na sababi' ning nana u iromkadakyap tanga kugwang ga' igukimotik wa. ");
INSERT INTO uvh_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Ka taming wari ning togu', beng sini' girii sababi' ning nana wa kugwang ga' guk mo' igukimiting de ka kugwang tuang wari nana kugo' nanga ifamating wa kugwang wari nating. ");
INSERT INTO uvh_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Ning tuguinga Jisas wari taming u ning anigu', o taming ka gu naktangka tangkunang guk ning gabarik warisa' tanga wa napa' ka gu tagam ga' naknga torang wari kuma'sa' kadofigamota'. Ning tinga kama ka wara'ganang kaga'sa' ibingini yak ganang donggung defagu' udi urapsa' karendagu'. ");
INSERT INTO uvh_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Ning tanga Jisas wari yong ka u kabinga kama tubo ka Galili gwang ganang tara' waraga' ubu agu'. Anga kadofinga kama bubo nua'ni ganang aranga mareiagu'. ");
INSERT INTO uvh_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Ning tinga aming yong ka kama tubo wara'ni aming arantagim kabi'kabi'mo' wari amise bagana kadagasi kuni' kuni' fam ka kasi' kadagasi a dasi' kadagasi a kafasi' kungkumosi a aming ka masi' mamaresi midi map fengak a aming fuksi'ganang bagana kadagasi kuni' kuni' guk u inagira fabanga Jisas ganang kuking. Ning tinga Jisas wari dabiksa' ifakarendasasu'nanga yaregu'. ");
INSERT INTO uvh_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Ka aming adi Jisas wari kane ka aming fuksi' ganang bagana tangkunasi kuni' kuni' guk ka midi map fengak u ifakarendainga midi ubu tutugu a aming kafasi' kungkumosi u nua'bu karenda a aming kasi' kadagasi wari kadak didimengsa' tubobu marara iyangak a dasi' kadagasi wari tubobu degara ning u tanga ifakarendanga yaregu' u yapma Anutuning wap bema aranga ning tonga yareging, o Isrel aming indining Anutu girii wara'ning tangkunang warisa' tara'. ");
INSERT INTO uvh_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Ning tanga Jisas wari ananing arantagimni u katiana ning yanggu', aming arantagim kabi'mo' ya indigok ingging kama paramu' sini' ka sidii famineng ning kuma' ikem ka nanasi' udi kuma' biamara'. Ka nana guk mo' nanga seksi' idiing yabarik, ka indi ning ganang yangkantam wa kadapmang bining anga dasi' pimpiring tanga kumade ma tini'. ");
INSERT INTO uvh_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Ka arantagimni wari ning aniging, ai girii ya nana guk mokngang kama bining sigesa'. Ka indi nana wa indeng kanga bema yamtam, aming fama'sa' indi ningyari aming arantagim girii ka ningyaraga' nana iyam ning guk mokngang ning toging. ");
INSERT INTO uvh_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Ka Jisas wari ning yanggu', ka sidining nana kafo wa indining adeing. Ka arantagimni adibu ning aniging, nana kafo kababi'sini' ka seven ningsa' adeing a ama ging kafo undu' fama'sa' adeiamu'. ");
INSERT INTO uvh_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Ning tuguinga Jisas wari aming arantagim girii u ininga kamaganang unggung mera yareging. ");
INSERT INTO uvh_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Marekinga Jisas wari nana kafo kababi' ka seven ningsa' a ama ging kafo fama' u manggara Anutuga' ibang asekni' ning tonga upma arantagimni ga' yamgu'. Ning tinga arantagimni adibu manggara fonga ami taming arantagim girii wara'siga' ima yareinga naging. ");
INSERT INTO uvh_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Nang nanga dabiksa' nibera ning tanga dibing wa nagaremik tanga ibiging. Ka Jisas ning arantagim wari nana dibing nagaremira ibiging u manggara fabanga unup ari' ka seven ning u dasitoneging. ");
INSERT INTO uvh_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Ka aming arantagim ka nana u naging wa kabi'kabi'mo' ami a taming a sababi' ning wari dabiksa' naging ka ami unggungsa' indangiking wara'ning nambani wa fo tausen ning. ");
INSERT INTO uvh_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Ning tanga adi nana u nanga biinga Jisas wari yaksingga' tubobu yangkareinga mugoging. U yangkaranga ning tanga Jisas se' adindu' bot ganang aranga mera gwang u fenga anga kama tubo Magadan tara' u tubobu abanga kadofiging. ");
INSERT INTO uvh_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Ka aming girisi arantagim fama' ka Farisi guk ka Satyusi guk wara'sining aming fam wari Jisas wari napa' kadagang ni tinga midiganang bema kami waraga' ning tonga anga Jisas u mandaga' ning taramaking, gu kunimganang ning napa' tangkunang ka ni tinga kanga o Anutu wari adiganang beng sini' ba ita' ning wa wara'ganang tontam ning aniging. ");
INSERT INTO uvh_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","3","Ka Jisas adibu ning tipfaranga yanggu', a sidi sasuksi' guk mokngang. Sidi sasuksi' kareng ka napa' kamaganangni gimak a mayam wari kadofonga tita' wa giri kigedanga tuguting. Kibiri ganang mayam de wari amama tanga giming danga muriang giming data' u kanga wa o mayam girii ba dauta' ning wa bengsa' tuguting. Abanga kamindap marara mungkong kangkam girii wari kama isefita' u kanga a gimak girii ba tota' ning undu' beng guksa' tuguting. Ka indining tanga sidi napa' girii sini' nua'ni ka kami yara'ganang sidining bining ganang kuma' kadofinga ita' wa kigeda guk mo' ting. ");
INSERT INTO uvh_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","A kuma' sabarik aming arantagim ka kami yara'ganang iking sidi Anutuga' kabi'guk mo' sura iking wara'ning ka sidining sasuksi' wa kareng kabi'guk mokngang wara' sidi naga kane tangkunang mirakel ni tasaminga kaga ga' toing wa na bibi' naksama titi guk mo' tirik. Ka na mirakel nua'ni ka tim profet Jona wari tugu' ningwara' unggungsa' wa giri tasaminga kanting. Ningsa' ina midi nua'bu guk mo' tonga ibinga mugo tugu'. ");
INSERT INTO uvh_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Ka Jisas se' adi bot ganang gwang fugung ga' mugoging u tanga wa Jisas ning arantagimni adi nana fam mamanggak ga' wa nakube tanga mugoging. ");
INSERT INTO uvh_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Ka Jisas wari Juda ning aming girisi wara'sining kadapmang waraga' arantagimni u yangnatamonga midi tipfara kabi' ning tanga yanggu', sidi Farisi a Satyusi wara'sining napa' kababi' sini' yis ka baret sasaning u mo' mamanggak waraga' kafakafa sura ikanting ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Ka arantagimni adi midi ka u naknga anasa' midi kapmo' ning toging, o baret urang ibingam waraga' unda' sura tora'. ");
INSERT INTO uvh_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Ka Jisas adi adisining sasuksi' u kuma' yapkedanga ning yanggu', a na midi ka wa sidi baret nakubenga abinging waraga' mo' sura sanirik. Beng guk sini' sidi nagata' naktangka guk mo' tanga toing sabarik. ");
INSERT INTO uvh_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Ka sidi naganing kigineng girii ka tim naga aming ga' nana urang yamguk waraga' sura nakedani'. Tim na nana kafo baret kababi' ka faiv ningsa' u manggara upma aming arantagim kabi' kabi'mo' faiv tausen ning waraga' iminga dabiksa' nibeking. Ka adi fam ka nagaremik guk u tanga ibiging wa usap sini' wa. ");
INSERT INTO uvh_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Abanga na kama nua'niganang undu' baret kababi'sini' ka seven ningsa' u manggara ning tanga upma aming arantagim girii ka fo tausen ning waraga' iminga dabiksa' adi didimengsa' nibeking. Ka adi fam ka nagaremik tanga ibiging undu' kabi'mo' waraga' sukni'. ");
INSERT INTO uvh_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Ka naga yis ga' torik ka sidi baret ka yis guk kuma' tanga seging u ibinga mabinging waraga'sa' sura toing. Ka mokngang na waraga' mo' sura torik, na sidi Farisi a Satyusi ning yis u kabi'sini' guk mo' bimbem waraga' sura sanirik. ");
INSERT INTO uvh_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Jisas wari ning tuguinga arantagimni adi kafakafa inga' nakedanga ning toging, o beng sini' adi yis ka baret ganang waraga' mo' tora'. Mokngang adi indi Farisi a Satyusi arantagim ning kadapmang a sasuk kadagasi fam ka Anutuning kadapmang didimeng u anasining sasuk u yis da'ning kamanga tipkadaunga fating u kabi'sini' guk mo' ninak waraga' tora' ning toging. ");
INSERT INTO uvh_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Ka inga' Jisas guk ka arantagimni guk wari kama ka u kabinga kama tubo ka yong nua'ni ka wap fama' guk ka Sisaria Filipai tara' aderugu' waraga' ubu aging. Anga kadofinga ning tanga Jisas wari arantagimni u ning yangkagu', ka aming adi Amingning Tim Iyak naga ya indining fanabing. ");
INSERT INTO uvh_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Ka arantagimni adibu ning aniging, mo' wa aming fam ka Jon Baptis ningda'ning gapma Jon Baptis ning faganing. A fam ka profet Ilaija wari tubobu abanga kane tangkunang sa' tara' ning fatoing. A fam ka profet Jeremaia wa ma profet nua'ni ning fatoing ning aniging. ");
INSERT INTO uvh_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Ka Jisas wari ning yanggu', a sida wa indining da'ning fanabing. ");
INSERT INTO uvh_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Ka Saimon Pita wari ning anigu', gu girii Kasira Aming, Anutu ka ka' ningsa' iik wara'ning mindingni beng guk sini'. ");
INSERT INTO uvh_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Ka Jisas wari ning anigu', o Saimon Jona ning mindingni gu Anutu wari kafakafa tagaminga beng guksa' torang. Sasuk ka u bema torang wa aming nua'ni wari ganggam ning mo', mokngang wa naganing sibeng kunimganang ita' warisa' sasuk ka u gaminga togadofirang. ");
INSERT INTO uvh_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ka beng guk sini' ning ganotik, gu wapka ka Pita ning ganiting wa uningkim tangkunang ning wapni beng guksa' ganiting. Ka midi tangkunang beng guk u tongang wa uningkim tangkunang da'ning ita'. Ka na uningkim ka wara'ning fugu using ganang wa naganing naktangka aming arantagim ifakadofotik. Ning tinga aming kadagang Setan ning tangkunang ka aming ifagumak ning wari naganing arantagim u ifakadaga kabi'guk mo' to'ga', mokngang adi tangkunang guk ningsa' ira ani'ga'. ");
INSERT INTO uvh_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Ka aming wari yak ning faba dua' ka ki' warisa' urang ubiting ningda'ning wa ki' ka aming wari Anutuning bining ga' mugo wara'ning kadapmang u upiam waraga' gamotik. Wa ning, kamaganang yara'ni nasi' ni ka gu kadagang ning kanga todaga tarotang wa Anutu adindu' gifitangka tanga napa' ka wa kuma' usefining ning karota'. A nasi' ka gu giri ning torotang wa Anutu adindu' o kareng beng guk giri ning torota'. ");
INSERT INTO uvh_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Ka Jisas wari Pita u ning aninga igu' ning tanga arantagimni dabik u yangsefi tangkunang ning tugu', sidi wap ka Anutuning Kasira Aming ning wa mo'sini' ituanting, sidaning sasuksi' ganangsa' wa giri naknga ikni' ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Ning tanga kama ka wara'ganang Jisas wari ananing arantagim u midi ka inga' ana kungkumak waraga' munumung sini' yangnatamonga ning yanggu', beng guk sini' ning sanotik na Jerusalm yong ganang do auinga aming girisi a pris girisi a sasuk aming arantagim wari kadagang naramira ning tanga kagaya namni'ga. Ning tanga kadagang ningsa' naramira anganga nugumak sini' tini'ga'. Nukinga na kama mang ganang kama fama' ning ibinga kama famineng ganang wa tubobu mararok ga' ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Ka Pita adi midi ka Jisas wari kungkumak titiga' togu' u naknga Jisas u anisefi tonga anga Jisas u suronga ning anigu', ai girii mokngang sini' Anutu wari kuma' udagaminga gu mamareng ka u mo' bemotang. ");
INSERT INTO uvh_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Ka Jisas wari u kanga ning anigu', a Setan gu tataba te', gu Anutuning sasuk mo' bema torang mokngang sini', gu amingning sasuksa' tanga torang wara' gu napa' kadagang ni ka naganing kadapmang kareng isefinamning ning itang wari abanga torang ning anigu'. ");
INSERT INTO uvh_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Ning tanga arantagimni dabik ubu yanggu', beng sini' ning sanotik aming ka naga nawara nagok kane dabik titiga' sura wa ananing sasukni u bema afasasu'nanga ning tanga sasuk kigineng ka nasi' mamareng girii wari kadofingaminga kaba tiptangkanga bimbem sa' titi wara'guk ira nawakota' wa giri. ");
INSERT INTO uvh_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Beng sini' aming ka ananing iik kareng ka kamaganang i tanga iik waraga'sa' sura nagata' guk mo' surota' adi inga' iikni wa kamaganang inggingsa' bisasu'no'ga'. A aming ka nagata' sura aming fam wari adining fugu u ugumak waraga' mutu guk mo' tanga kumarota' adi inga' ka' ningsa' ira awa'. ");
INSERT INTO uvh_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","A aming ka sasuk ka napa'napa' kamaganangni ga'sa' tanga napa'napa' unggungsa' manggara tanga surotangkanga irota' wa inga' adi kungkumak tota' ganang wa ananing napa' mambongni karesi wari tubobu yotangkangama tipmarak ning guk mokngang sini'. ");
INSERT INTO uvh_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Ka beng sini' inga' sibeng wari Amingning Tim Iyak nagata' tangkunang a wap girii u naminga yotangkanap titi waraga' ensel arantagim guk afok wara'ganang wa nasi' nasi' kadapmang ka aming wari tanga ikiting wara'ning toni kura' tubobu tiamonga wa anasining iiksi' unggungsa' yaranga kadagang undu' kadagang a kareng undu' kareng tiam ning u ana kuma' tanga ikiting wara'ganang didimengsa' tok. ");
INSERT INTO uvh_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Beng guk sini' sanarik aming ka i aradeing fam sidi ko mo' kumakinga ganang Amingning Tim Iyak naga girii ira kigineng guk tubobu abok wa sidi kuma'sa' napni'ga' ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Ning tanga iya' kama de 6 ning kuma' ibinga ka Jisas wari arantagimni famineng ka Pita a Jems iguyangguk Jon ya ning unggungsa' inagira kama bubo girii nua'ni ganang areging. ");
INSERT INTO uvh_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Aranga kadofinga ning tanga adeging. Adenga kaging ka Jisas ning fugu wari girigik tanga kuni' nua'ni sini' ubu igiku'. Jisas ning nonda wa diok kigineng sini' ka mayam de da'ning tugu'. Ning tinga adining kwi'ni ka kangkama tanga adegu' undu' fafa' sini' fagagu'. ");
INSERT INTO uvh_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Ning tinga papase fama' ka Moses guk ka Ilaija guk wari urapsa' kadofinga adenga Jisas guk midi aratoging. ");
INSERT INTO uvh_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Ka Pita wari napa' u kadofigu' u kanga Jisas u ning anigu', o girii indi kama bubo yara'ganang arapmam wa kareng sini' wara' gu tuguinga na sidita' yak kababi' famineng ning masamok, nua'ni ka guta' a nua'ni ka Moses ga' a nua'ni ka Ilaija ga' ning masamotik ning togu'. ");
INSERT INTO uvh_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Ka Pita wari midi u ko aratuguinga mungkong fafa' sini' ka diok da'ning wari kadofinga afanga tumukyapma ning tanga midi nua'ni wari mungkong wara'ning bining ganang u ning togu', aming ka i kaing ya naganing sabana kareng sini' na adita'sa' nakitik, adining kadapmang wa didimeng sini' katik wara' nasi' midi ka adi touta' wa sidi nakngam sa' tinting. ");
INSERT INTO uvh_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Ka Jisas ning arantagim famineng adi midi ka u kadofigu' u naknga mutu girii tanga kamaganang mangdera mungkupna tiging. ");
INSERT INTO uvh_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Ning tinga Jisas wari arantagimni wara'ganang anga suroyapma ning yanggu', ai sidi mutu mo' tinting mamarak tini'. ");
INSERT INTO uvh_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Ning tuguinga daranga kaging wa Jisas anapmo'sa' ubu adegu'. ");
INSERT INTO uvh_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Ning tanga biinga Jisas wari arantagimni famineng u inagiknanga kama bubo u kabinga tubobu afiging. Ka kadapmang ganang bining u afanga Jisas wari arantagimni u yangsefi tangkunang ning tugu', sidi napa' u kaing waraga' wa aming ka ni guk mo' aninting, sidasa' sura ikianting. Ira anganga inga' Amingning Tim Iyak naga kumara tubobu kuma' marakinga wara'ganang ga'sa' itua waraga'sa' sura ikianting ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Ka arantagimni wari Jisas u ning anikaging, ka girii, Kasira Aming wa gu kuma' kadofinga itang ning gabem. Ka Juda indining sasuk aming girisi adi Kasira Aming wari abonga wa tim ka profet Ilaija wari tubobu abo' ning guk wa nasi'ga' fatuguting. ");
INSERT INTO uvh_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Ka Jisas wari ning yanggu', weng midi ka wa beng guksa' fatuguting, Ilaija adi tim abanga napa'napa' u ifadidima wara'ning aming. ");
INSERT INTO uvh_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ka beng sini' sanirik, Ilaija u fatuguting wa tim kuma' abugu'. Ka adi kigeda tanga kabaksi' kareng naknga o Ilaija urang kuma' abara' yang ning guk mo' toging, mokngang sini' adi sasuk ka tipkadaga titi wara'ningsa' tanga kuma' tipkadagaging. Ka u taramaking ningsa' Amingning Tim Iyak nagata' undu' ningsa' tanamni'ga'. ");
INSERT INTO uvh_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Jisas wari ning tuguinga arantagimni adi wara'ganang inga' nakedanga ning toging, o beng sini' Ilaija udi Jon Baptis ga'sa' sura tora'. ");
INSERT INTO uvh_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Ning tanga kama bubo u kabinga amanga ami taming kabi'mo' ka kapmefak tiging wara'ganang amanga kadofiging. Ka aming nua'ni wari Jisas wari abugu' u kanga anga Jisas ning kayong ganang u upma mera Jisas u ning anigu', ");
INSERT INTO uvh_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","o girii gu naganing sabana wa bibiri' kanga yotangkangam te'. Adi fikifiki magi papenga kudip ganang udi kumara mangfu a ama ganang u kumara mangfu ning fatanamita'. ");
INSERT INTO uvh_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Ka na arantagimga wari udep tipkarendanamting ning tonga nagira abanga yangguk, ka mokngang adi tipkarendanam guk mo' tiging. ");
INSERT INTO uvh_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Ka Jisas adi midi ka u naknga kaba mamareng kabi' naknga ning tanga arantagimni guk ka aming arantagim sige wara'guk dabik u ning ifang yanggu', a aming arantagim ka sidi naktangkasi' guk mokngang a sasuksi' undu' didimeng guk mokngang beng sini'. Na sidigok kama paramu' kuma' ira sanggetik ka na ingging ko irotik wa na sidining mamareng ba fabemotik. Ning tonga ning tanga aming u ning anigu', magarik sabaga u nagira abe'. ");
INSERT INTO uvh_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Ning tuguinga aming wari mindingni u Jisas ganang nagira abuinga Jisas wari mini unggo kadagang ka saba wara'ganang yagu' u kafang aninga wadigi' sini' anikagarenga kayogu'. Ning tinga saba wari kama ka wara'ganang kaga'sa' karendagu'. ");
INSERT INTO uvh_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Ka Jisas ning arantagim warisa' Jisas ganang anga midi kapmo' ning anikaging, girii gam indi indining da'ning tanga mini unggo kadagang wa tangkayogisifa tangam. ");
INSERT INTO uvh_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Ka Jisas wari ning yanggu', tagisifa tinging wara'ning ki wa ning, sidi naktangka tangkunang guk mo' tanga tinging warisa' tanga wa tanga kayo guk mo' tinging wang. Ka beng guk sini' ning sanotik, naktangka wa napa' kigineng sini' wara' aming ka nagata' naktangka kabi'sini' ka firi mindip kababi'sini' ka mastet ningda'ning beng guksa' tota' wa adi napa' tangkunang girii ka kama bubo u gu fugung do anga adeia' ning u midisa' touta' undu' beng guk kuma'sa' kadofota'. Wara' aming ka nagata' naktangka guk tanga irota' adi napa' tangkunang ka ni mo' titi ning guk mokngang, adi kuma'sa' tinga kadofota'. ");
INSERT INTO uvh_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","(Ka sidi masi' unggo kadagasi tanga iguk ning tangkunang guk mokngang ning toing waraga' wa ning sanotik, napa' girii sini' ka mini unggo kadagang tanga kayoning ningwara' wa sige siasa' guk mo' tanga kayoutang. Mokngang gu Anutuga' ibang ka kabaka guk kufara nana tapni sini' tanga toutang wa napa' tangkunang sini' ka ning u tinga beng guksa' kadofigamota' ning yanggu'.) ");
INSERT INTO uvh_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Ka Jisas wari arantagimni dabiksa' ubu inagira kama ka u kabinga kama tubo Galili ga' ubu aging. Anga ning tanga Jisas wari ana kungkumak waraga' arantagimni u fonga bak kukyapma ning yanggu', beng sini' sanirik kabi'sini' aming wari Amingning Tim Iyak naga bemnapma tonga aming arantagim nua'ni ning kafasi'ganang yamting. ");
INSERT INTO uvh_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Iminga adibu nugumak tini'ga'. Nukinga kama mang ganang kama fama' ning dera famineng ganang wa tubobu seranga mararok ga' ning yanggu'. Ka arantagimni adi midi ka u naknga kabaksi' mamareng sini' naking. ");
INSERT INTO uvh_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Ka Jisas guk ka arantagimni guk wari Kapaneam yongga' mugoging. Anga kadofiinga aming arantagim ka siring yak girii tempel ning takis manggakiaging wari Pita u ning anikaging, ma' sidining girisi' udi indining tempel ning takis guk u tita'. ");
INSERT INTO uvh_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Ka Pita wari ning yanggu', weng una takis tita' udi. Ning ina ning tanga yak ka Jisas wari merafagu' wara'ganang ubu anga amogu'. Amanga Pita wari Jisas u ko mo' aniinga ganang ka Jisas wari Pita u takis mamanggak ning kadapmang waraga' urapsa' ning anikagu', Saimon gam gu indining sutang, aming girisi kamaganangni king wari takis manggaknating wa adi nisi' ganang manggeting, ana kurene ganang wa ma aming arantagim fam ganangsa' manggeting. ");
INSERT INTO uvh_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Ka Pita wari ning togu', mo' adi takis wa aming arantagim ganangsa' manggeting. Ka Jisas wari ning anigu', beng guk torang Pita, king ana kurene wa takis guk mo' titing. Ka nandu' king girii ka Anutu adining mindingni sini' ning itik wara' na mo' kangkami ning de. ");
INSERT INTO uvh_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Ka aming arantagim wari kadagang ning ma nipni' wara' indi takis wa kangkami tantam. Ning tonga ning tanga Pita u ning anigu', Pita gu gwang ganang do anga ama ging ga' huk kame'. Kaminga ning tanga ama ging ka tim munumung sini' wengbemotang wara'ning mini ginang ganang wa uningkim moni guk kautang ga'. Uningkim mambong ka u kautang wa gugok ka nagok indi takis u kangkami wari'ning didimengsa', Wara' gu uningkim mambong ka u kanga wa bimbem tanga takis wa wari tabanga kamotang ning anigu'. ");
INSERT INTO uvh_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Ka kama ka wara'ganang Jisas ning arantagimni wari Jisas u anigaunga anga ning aniging, girii gam aming wari Anutuning bining ganang iik ning tim iyak sini' wa nisi' wari ita'. ");
INSERT INTO uvh_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Ka Jisas adi midi ka u naknga saba kabasi' nua'ni katingana anga adeinga saba kabasi' u suronga ");
INSERT INTO uvh_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","ning yanggu', beng sini' ning sanotik sidi Anutuning bining kareng u anga iik ga' naknga wa sidi kabaksi' faranga iiksi' ka saba kabasi' i adera' ningda'ning tanga ikanting wa giri. A mokngang wa sidi Anutuning bining ganang iikning guk mokngang. ");
INSERT INTO uvh_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","A aming ka ananing sasukni a fugu bema afasasu'nanga aming fam ning kapmik ganangsa' ka saba kabasi' i adera' ningda'ning irota' wa adi Anutuning bining ganang iikning tim iyak aming ning beng sini' irota'. ");
INSERT INTO uvh_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Abanga aming ka nagata' sura saba kabasi' ningyara' u kafakafa tangamota' wa adi nagata' sini' tanam ning ningda'ning tara' ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Ka Jisas wari arantagimni u nua'bu yanggu', ka saba kabasi' i adera' ningyara' wari nagata' naktangka tota' wa kareng sini'. Ka aming nua'ni wari a gu adita' naktangka mo' totang ning tuguinga saba kabasi' wari adining midi u naknga naganing midi u nua'bu mo' nakota' wa aming ka u anota' wa kadagang girii tara'. Aming ka kadapmang ka ningwara' tong tinga wa adi ko mo' tinga ganang amine wari kadapmang udaga tanga aming ka u urapsa' bema uningkim girii kadare ganang tofanga ama bane kura kamainga ama topnanga wadigi' sini' kumarota' wa giri, mamareng katauta'. A kagabi sa' tinga saba kabasi' u tipkadauta' wa inga' Anutu girii wari waraga' mamareng girii sini' kabingamo'ga'. ");
INSERT INTO uvh_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Beng guk sini' kamaganang ya kama kareng mo', aming fam ka aming mandaga' iramakinga sasuk kareng kuma' tanga iik u kagabi wara'ning guk iking. Wara' aming kabi'mo' adi adisining midi u naknga kadaga tini' de. Ka aming ka adisining sasuksi' u ifakadauta' wa kadagang girii sini' tota' wara' adi mamareng girii sini' bemo'ga'. ");
INSERT INTO uvh_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","A ga undu' ningsa', sasuka wari kadagang titiga' kadofigabinga wa gu kadagang tanga kadaga ma te' wara' gu sasuk kadagang ka ningwari kadofigabinga wa gu kadapmang urapsa' udautang. Ka kadagang ning udaga wara'ning wa ning, kaga a kafaga wari kadagang titiga' ginagira aunga tinga wa gu iibi sa' mo' totang. Mokngang gu kaga fugung a kafaga u wadigi' doptautang. Gu wari giramakinga kudip kadagang ganang ma maya' wara' gu kaga a kafaga u doptanga igura ning tanga kaga a kafaga fugungsa' guk ira kadagang guk mo' tanga karengsa' ira autang. Wara' gu inga' wa ka' ningsa' ira aya'. ");
INSERT INTO uvh_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","A daga undu' ningsa', daga wari napa' ni kamamarenga kadagang tanga kudip kadagang ganang ma maya' wara' gu daga wari kadagang ga' ginagira aunga tinga wa gu daga fugung wa wadigi'sini' kadara kayoutang. Ning tanga gu daga fugung guksa' kareng gi' irotang, wara' gu inga' wa ka' ningsa' ira aya' ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Ning tanga Jisas wari arantagimni u ning nua'bu yanggu', sidi midi ka i sanirik i kafakafa nakni'. Sidi ning ma sukni', a sababi' wa napa' girisi uyata' wara' indi waraga' sasuk mimeng tonga, mokngang. Beng sini' sanirik, sababi' wa napa' kababi' sigening mo' wa napa' girii sini', adi yaptatora aming arantagim ka ensel naganing sibeng guk kunimganang kuta ikiting wari yaptatoranga anga Anutu undu' kuma' aniting. ");
INSERT INTO uvh_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","(Ka Amingning Tim Iyak nandu' aming ka yotangkayap titining guk mo' ikiting u yotangkayap waraga' afuguk ning yanggu'.) ");
INSERT INTO uvh_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Ka sidi kadapmang ka aming ka maga sipsip yaptatoreting wari titing waraga' sukanting. Aming nua'ni wari sipsipni wan handret ning u yaptatoranga irota'. Ka sipsip dabiksa' wa gi'sa' giri ikanting ka kubaniksa' wari sarofira anga sebota'. Ka sipsip tuang adi a kureng ning guk mo' tuguting mokngang sini', adi base tanga sipsip fam u gi' fonga kukyapma fidenga fanainga ibinga anga kubaniksa' ka naro' bimanga mauta' waraga' wenanga auta'. ");
INSERT INTO uvh_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Wenanga anganga katua tanga bemnanga wa adi kaba kareng siamo' nakota'. Adi sipsip fam ka gi' ikanting waraga' wa adi kaba kareng mimeng sini' mo' nakita', ka kubaniksa' waraga' wa kaba kareng mimeng sini' nakota' ning titing. ");
INSERT INTO uvh_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Ka aming ka maga sipsipsi' guk wari u titing ningsa' sidining babangsi' kunimganang ikita' adindu' saba kababi' ka i suronga aderik ningyaraga' undu' ningsa' tita'. Adi aming kubaniksa' wari nagata' naktangka kuma' tota' u kabinga kadaga titi waraga' bibi'sini' nakita' ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Ning tanga Jisas wari arantagimni u nua'bu ning yanggu', ka sidi kuyasi' nua'ni wari kadagang tinga tipdidima tonga wa kadapmang didimeng ka ning tinting. Kuyaga wari kadagang tinga kanga wa gu midi sireng aming ning dasi'ganang urapsa' mo' anotang mokngang, gu tim ka gapmo'sa' anga adining kadagang u tipdidima waraga' anotang. Ka adi guning midi u naknga kuma' tiptatareuta' wa gu adigok kabaksi' kubaniksa' nua'bu kufara ikantamu'. ");
INSERT INTO uvh_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","A adi guning midi u nakam guk mo' tinga wa gu aming kubanik wa ma fama' ning nua'bu inagira anga adining midi u nakdidimangamting. Ning tinga aming fam wari u nakdidimanga ning tonting, o beng sini' midi ka wa anapmo'sa' mo' tora, fama' a famineng dabiksa' toing wara' beng guk ning tonting. ");
INSERT INTO uvh_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ka adi gu a aming fama' wa ma famineng sidining midi u mo' nakinga wa sidi midi ka adining kadagang wara'ning wa naktangka aming arantagim ning bining ganang ubu ituaiminga dabiksa' u naksasu'nanting. Ka adi inga' kaba faranga adining kadagang u kagabi guk mo' tota' wa kagabi sa' tinga adi naro'sa' ira aming arantagim nua'nining a aming takis mamanggesi ka Anutuning midi mo' nakinga aming kadagasi urang yabiting ning kanga aming kadagang ning aninting ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Ning ina ning tanga ning yanggu', beng sini' ning sanotik sidi kamaganang ikanting ganang nasi' ka sidi kadagang kanga tosefi tinting wa Anutu adindu' sifitangka tanga beng guk toing ning touta'. A sidi nasi' kadapmang ka sidi kareng ning kanga tonting wa Anutu adindu' kareng beng guk ning touta'. ");
INSERT INTO uvh_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Ka nua'ni ka ning, sidi kamaganang ikanting ganang ka aming fama' wari Anutu wari napa' ni tiam ga' naknga kabaksi' kubaniksa' kufara ibang tontamu' wa naning sibeng kunimganang ikita' adi kuma'sa' naknga tiamota'. ");
INSERT INTO uvh_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Beng sini' urang sanirik, aming fama' wa ma faminengsa' wari nagata' sura kabaksi' kubaniksa' kufara tonting undu' kigineng guk, na adisigok ira kuma'sa' yotangkaimotik ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Ka Pita wari Jisas u ning anigu', indining girii kuyana nua'ni wari nagaganang kadagang tota' ka na kuma' suknakubengamotik. Ningsa' tang tanga anganga seven ning kuma' suknakubengamotik ganang ka inga' nua'bu tota' wa kureng wa. ");
INSERT INTO uvh_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Ka Jisas wari ning anigu', na kadagang ka seven ning tota' unggungsa' wa ari' suknakubeutang ning mo' torik mokngang. Na ning torik, aming wari kadagang usap sini' ka kabi'mo' seventi taims seven ning tota' undu' girisa' suknakubengama ira autang. ");
INSERT INTO uvh_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Ka na aming ka Anutuning bining ganang ira kadagang suknakubeiam tanga ikanting wara'sining kadapmang waraga' wa ning toutik. Aming girii king nua'ni wari adining kane aming ka adining kane tanga ira yaranting u yangara yapma yarota', adisining kane wa didimengsa' wa ma fam ka dinau guk wa ting ning waraga' uyapdidimonga yapma yarota'. ");
INSERT INTO uvh_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Ka aming girii wari kane aming u yapma arayarota' ganang ka aming fam wari kane aming kadagang nua'ni adi dinau girii sini' ka ten milion ning tota' u nagira anga aming girii u ning aninting, ai girii, aming ka i karang ya kadagang adi dinau girii sini' guk. ");
INSERT INTO uvh_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ka aming girii wari aming dinau girii guk u ning kauta' ka adi dinauni u tipdidima wara'ning kadapmang kabi'guk mokngang sini'. U kanga ning touta', a na adining dinau wara'ning toni tubobu tangam wa na aming anagok ka tamni a mindine dabiksa' u manggakyapma fonga aming fam ga' ima aming wari adisining slev kane tiam waraga' tonga manggakniabinga na uningkim mambong wa wara'ganang bemotik. ");
INSERT INTO uvh_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Ka kane aming dinau girii guk adi aming girii ning midi u naknga kaba mamareng girii sini' nakota'. Ning tanga anga girii ning kayong ganang u mangfanga mungkupnanga mera aming girii u midi tangkunang sini' ning anota', o girii gu ninibi sa' te', na dinau u tubobu kuma'sa' tipdidimagamotik. ");
INSERT INTO uvh_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Ning aniinga aming girii wari kaba tubobu sura tipfaranga bibiri' naknga ning anota', a sige girisa' mautang guning dinau girii wa na suknakubegam totik. Ning tinga dinau wari sigesa' kuma' anga biuta'. Ning tonga kabiinga sigesa' mauta'. ");
INSERT INTO uvh_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Ka girini wari midi u aning aninga kabiinga amanga fugang do kadofinga kauta' ka kane aming kuyangni nua'ni ka tim ana ganang dinau kabi'guk tugu' wari abota' u katuauta'. Kanga adi sasuk ka girini wari ai'dap girii tanga sige kabiinga mabota' wara'guk mo' surota', mokngang. Adi bane urapsa' giptanga aming wara'ning kadare u kasira ning anota', ai gu nagaganang dinau guk. Tim gu nagaganang dinau tugung u kami kaga'sa' tubobu name'. ");
INSERT INTO uvh_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Ka kuyangni wari adining midi u naknga manda upma irema mera midi tangkunang sini' ning anota', o kuyana gu dinau waraga' sasuk mimeng mo' totang. Na guning dinau wa kuma'sa' tiptataregamotik. ");
INSERT INTO uvh_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Ka mokngang kuyangni adi nakngam guk mo' tota'. Adi dinau waraga' sasuk mimeng sini' tanga bane giptanga ning tanga aming u bema tonga kane kagaya nua'ni ganang kamiinga adi kane kagaya u ira fatota'. Ka adi kane kagaya u ira fatota' wa tanga anganga adi dinau u tipmiringa kabiinga mugo waraga'sa' kabinga fatota'. ");
INSERT INTO uvh_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Ka aming girii ning kane aming fam wari adining kadapmang kadagang u kanga kabaksi' kadagang nakngama anga aming girisi' u aninting. ");
INSERT INTO uvh_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Ning tinga aming girii wari midi ne kadagang ka u naknga kaba kadagang sini' naknga kane aming ka kadagang tota' u katingana anga kadofiinga aming girii wari ning kafanga anota', a gu kane aming kadagang sini' sasuka kareng guk mokngang. Gu tim nagaganang dinau girii tugung ka gu naga sige gigibi ga' mak koinga na bibiri' gapma sige gibiinga mugogung. ");
INSERT INTO uvh_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Na tim guta' wa bibiri' nakamguk ka gu kuyaga ga' wa bibiri' guk mo' wa indining naknga kadapmang kadagang ka u tugung. ");
INSERT INTO uvh_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Ning kafang aning aninga ning tanga girini wari kaba kagaya sini' naknga arantagimni fam u ning inota', sidi aming i bema tonga kane kagaya sini' fam ganang kamiinga to'. Tanga adi dinau girii ka tim nagaganang tugu' u wadigi' tipmirisasu'nota'. Ning iniinga bema tonga kamiinga adi kane kagaya u tanga irota' ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Jisas wari arantagimni u ning ina ning tanga ning yanggu', beng sini' sanirik sidi dabiksa' sidi kuyasi' nua'ni wari sidiganang kadagang tinga wa sidi adining kadagang waraga' wa urapsa' suknakubengamting. A sidi suknakube guk mo' tinting wa naganing sibeng kunimganang ikita' adindu' kadapmang kagaya ka aming girii wari kane aming ga' tangamota' ningsa' tasamo'ga' ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Ka Jisas adi midi u ina ina ning tanga kama tubo Galili u kabinga kama tubo Judia tara' waraga' ubu anga Jodan ama u fenga fugung do waraga' aging. ");
INSERT INTO uvh_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Auinga aming arantagim kabi'mo' wari yaranga anga kainga Jisas wari adisining bagana aming u ifakarendiama yaregu'. ");
INSERT INTO uvh_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Ka Farisi arantagim wari Jisas wari kane anga tugu' wara'ning midi u naknga anga Jisas wari midi fam fe' tinga midiganang bema kamintam ning tonga midi nua'ni ka ning anikaging, ai gu kadapmang ka aming wari tamni kagabi ning waraga' wa indining sutang. Juda indining kadapmang tang ganang wa taming wari kadapmang kuni' kuni' u defata' u tinga ufini wari kagabi titi waraga' guk u tuguta'. ");
INSERT INTO uvh_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Ka Jisas wari ning yanggu', a sidi midi ka tim Anutu wari napa' napa' munumung sini' tugu' wara'ning ka ning yoking, Anutu wari ami tanga a taming tanga ning tugu' ning yoking wa sidi wara'guk mo' unda' indangira kating. Abanga nua'ni ka ning yoking, adi ami guk ka taming guk tiapku'. ");
INSERT INTO uvh_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Wara' ami a taming wari mamangse babangse ibinga abanga dabik kura ikantamu' wa adi napa' kubaniksa' ning ubu kuma' kadofinga ikiamu' ning yoking. ");
INSERT INTO uvh_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Beng sini' ami taming fama' adi tim wa naro' naro' ikantamu', ka inga' bak dabik kukantamu' wara'ganang wa adi fuksi' kubaniksa' ning ubu kuma' ikiamu'. Ka adi kubaniksa' ning u ikiamu' wa Anutu girii warisa' tiaminga ikiamu' wara' wa aming kamaganangni nua'ni wari nua'bu mo' udayabota'. ");
INSERT INTO uvh_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Ka Farisi arantagim wari ning aniging, a gu aming wari udayap ning guk mokngang ning torang. Ka nasi'ga' tanga tim papani' Moses wari midi ka aming wari tamni girisa' kagabi waraga' undu' kuma'sa' togu'. Adi ning togu', aming wari tamni kabonga wa adi aming wari kanga o adi tamni wadigi' ba kabira' ning tutugu waraga' midi umpang ganang yora aminga ning tanga wara'ganang anikagareuta'. ");
INSERT INTO uvh_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Ka Jisas wari ning yanggu', tim Anutu wari napa' napa' u munumung tugu' ganang wa adi ami wari taming kagabi wara'ning guk mo' togu' mokngang sini'. Ka inga' Anutu wari sidining kabaksi' wa tangkunang sini' ka adining midi ninak guk mokngang ning u kuma' sapma Moses u aniinga Moses wari kadapmang ka wa kabi' girisa' tinting ning wa wara'ganang sanggu'. ");
INSERT INTO uvh_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ka na ning toutik, tim Moses adi kadapmang ka aming wari taming girisa' kagabi wara'ning guk tugu' wara' sidi u yaranga tanga ira abuting. A naganing midi wa ning, aming ka tamni wari aming nua'ni guk sansaramik guk mo' tota' wa sige guk mo' kabinga anikagareuta'. A adi tamni sigesa' kabinga taming nua'ni ubu sanota' wa adi ufi imaraming ning kadapmang tang udanga kadagang girii tara' ning togu'. ");
INSERT INTO uvh_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Ka Jisas ananing arantagimni wari midi ka u naknga Jisas u ning aniging, ai girii gu kadapmang tang ka aming wari taming wa kagabi titining guk mokngang ning torang wa aming wari ufi imaraming guk mo' tanga iik ning da'ning nakem. ");
INSERT INTO uvh_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Ka Jisas wari ning yanggu', midi ka aming wari mengbe kabinga anga tamni guk kabaksi' kubaniksa' ningsa' iktangkanga ira au wara'ning wa aming aming dabiksa' wari didimeng ningsa' titining mo'. Mokngang, wa aming ka Anutu wari kadapmang didimeng ka ningwara' u titi waraga' tangkunang guk kuma' imita' warisa' titi wara'ning. ");
INSERT INTO uvh_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Beng sini' aming ka taming guk mo' sanayap wara'ning undu' ki guk. Aming fam ka mamangse wari kabaksi' ka taming ga' guk mo' ninak wara'guk ningsa' kuma' ibeyabiting. A aming fam wa taming guk mo' sana waraga' anasining fuksi' u tapni titing. A aming fam wa adi Anutuning bining ning kane fam u tanga iik waraga' sura anasa' taming sana ga' tapni tanga sige ikiting. Aming ka kaba ganang tangkunang ka taming guk iik wara'ning wara'guk irota' warisa' wa taming guk tangkunang giri ira kadapmang ka u girisa' tanga irota' ning togu'. ");
INSERT INTO uvh_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Ka kama ka wara'ganang ka aming fam wari Jisas wari sababi'si' u kisi' suroyapma ibang toyam ga' ning tonga sababi' u inagira Jisas ganang abiging. Ka Jisas ning arantagim adi u yapma ifangyang tiging. ");
INSERT INTO uvh_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Ka Jisas adi arantagimni wari ifangyang tiging u yapma arantagimni u ning yanggu', ai sidi yangsefi mo' tinting, iibi sa' tinga nagaganang i abani'. Beng sini' sanirik aming arantagim ka Anutuning bining ganang iikning wa sasuksi' kareng guk ka sababi' ka midi ninakisi u yabing ningwara' warisa' wa Anutuning bining ganang iik ning. ");
INSERT INTO uvh_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Ning ina ning tanga sababi' u fabanga mamamni ganang kukyapma kisi' suroyapma ibang totangkaimgu'. Ning tanga ibinga mugo tugu'. ");
INSERT INTO uvh_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Ka aming nua'ni wari adining iikni waraga' kafakafa nakdidimonga abanga Jisas u ning anigagu', ai girii na nasi' kadapmang kareng ni tanga ka' ningsa' irotik, gu wara'ning u naninga nakdidimok. ");
INSERT INTO uvh_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Ka Jisas wari ning anigu', gu nasi' kareng ni titiga' sura torang. Midi wap ka kareng u torang wa Anutu kubanik unggungsa' anitam. Ka gu kareng iikga' naknga wa gu Anutuning midi tangkunang u dabiksa' yarasasu'notang wa giri. ");
INSERT INTO uvh_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Ka aming wari anigu', ka nasi' nasi' midi tangkunang u yarotik. Ka Jisas wari ning anigu', midi ka wa ning. Gu aming nua'ni mo' ura sebotang a gu tamga kabinga taming nua'ni mo' sanotang a aming nua'nining napa' ni mo' iromkubanotang a mandaga' mo' giknotang. ");
INSERT INTO uvh_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","A gu mamangga babangga ga' surotang a gu aming nua'ni ga' kafakafa sini' ka ganing fuka yotangka ga' titang ningsa' tangamotang. Kadapmang tang ka ning u yaranga tanga iik waraga' torik. ");
INSERT INTO uvh_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Ka aming wari ning togu', midi ka u tonga yararang wa na kuma'sa' yarasasu'nanga tanga ikitik. Ka nua'bu wa nasi' unggungsa' totik ning anigu'. Ka aming ka wa aming kuru' mo' aming saba inga'ni. ");
INSERT INTO uvh_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Ka Jisas wari ning anigu', gu kadapmang ka u tipdidima sini' tonga wa napa' kubaniksa' ka ko adera' u totang wa ning. Gu i anga guning uningkim mambong a mambongga tangkunasi fam u manggara tatafak aming ga' yamsasu'nanga ning tanga naganing kane u wara'ganang nawara totang. Gu kamaganang ya sigesa' irotang de ka inga' Anutuning yongganang wa gu Anutu wari kafakafa tagabinga kangasi sini' ire'ga' ning anigu'. ");
INSERT INTO uvh_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Ka aming ka wa mambongni kabi'mo' guk wara' adi Jisas ning midi u naknga mambongni u kagabi ga' bibi' naknga kaba mamareng sini' naku'. Ning tanga Jisas u mo' yaregu', adi kagabi tanga yoringga' mugo tugu'. ");
INSERT INTO uvh_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Ning tanga Jisas wari ananing arantagimni u ning yanggu', beng guk sini' sanirik aming ka mambong a napa' kangasi mimeng tanga irota' adi Anutuning bining ganang iikga' wa siasa' mo' tota', mokngang adi kane girii sini' tota'. ");
INSERT INTO uvh_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Beng sini' sidi maga girisi kamel u kuma'sa' yabiting, napa' girii ningwari ginang kabasi' ganang sumupmanga kagadofi ning guk mokngang, yoyangak tota'. Wara' aming ka mambongni siamo' guk irota' undu' kadapmang ka Anutuning bining ganang iikga' au ning u yara waraga' udi kane girii sini' tota'. ");
INSERT INTO uvh_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Ka Jisas wari midi ka u tuguinga arantagimni adi u naknga base tiging. Ning tanga ning aniging, ai girii midi ka wa aming wari gi' iikning kadapmang wara'ganang au ning guk mo' torang nakem. ");
INSERT INTO uvh_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Ning tuguinga Jisas wari arantagimni u iyafa mimeng tanga midi tangkunang ning yanggu', beng sini' aming sidi kadapmang guk mokngang ning sura naking de, ka Anutu adi napa' napa' wa girisa' titining ning kata' wara' anasa' kuma' tiamota' ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Ka Pita wari ning anigu', girii, beng sini' indi aming fam ningwara' mo', indi guning midi u naknga indining napa'napa'ni' u ibisasu'nanga abanga gusa' giwara tanga ikem. Ka inga' Anutu adi indita' nasi' kareng tinimo'ga'. ");
INSERT INTO uvh_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Ka Jisas wari ning yanggu', beng guk sini' ning sanotik inga' Anutu wari kama a kunim a napa'napa' u inga'ni sini' nua'ni tipkadofo' ganang ka Amingning Tim Iyak naga tare ka wap girii guk wara'ganang mera kigineng girii guk ira napa'napa' u yaptatorok ganang wa naganing arantagim sidindu' nagok dabik mera Isrel ning papase 12 wara'ning arantagim dabiksa' u yaptatorani'ga'. ");
INSERT INTO uvh_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ka aming ka nagata' sura adining yak a kuyane mengbe a mindine ibingine a fening u ibinga naganing kane tanga irota' wa adi mambong a napa'napa'ni tangkunasi kabi'mo' ibota' de, ka inga' nagabu waraga' tubobu amok wa kabi'mo' wan handret taims ning udi girisa' amok. Abanga na adi napa' girii sini' ka ka' fikifiki ningsa' iik wara'ganang kamiinga iro'. ");
INSERT INTO uvh_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Beng sini' aming fam ka kami yara'ganang wap girii guk ira tim iyak ning iking adi inga' wa mandang ikni'ga'. A aming ka sige iking adibu wap girii guk ira tim ikni' ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Ka Jisas wari ami taming u ning yanggu', aming wari Anutuning bining ganang ikinga Anutu wari kafakafa tiap wara'ning bumara' nua'ni wa ning. Aming girii nua'ni ka wain fengni guk wari adining wain feng kane u tangam waraga' kane aming fam yapma inagirota'. ");
INSERT INTO uvh_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ka adi ning tota', kamindap gaa' marara aming fam u yapma inagira fonga ning inota', sidi naganing feng kane i tanamni'. Na kama kubaniksa' tinting wara'ning uningkim wa didimengsa' kuma' samotik ning ina ipminga fatinting. ");
INSERT INTO uvh_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Ning tanga mareia' mayam dasagainga yong ganangga' tubobu anga yabota' ka aming fam kane guk mokngang sige mafakanting. ");
INSERT INTO uvh_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","U yapma ning inota', sidindu' naganing kane anga tanamni'. Tinga sidi kane tanamting wara'ning uningkim wa didimengsa' kuma' tosabotik. ");
INSERT INTO uvh_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Ning ina yangkareinga anga fatinting. Ning tanga sidii sini' ganang aming fam u nua'bu yapma undu' ningsa' yangkarota'. Ning tanga mareia' mayam de wari tubobu kuma' farota' ganang undu' ningsa' tanga yangkarota'. ");
INSERT INTO uvh_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Ning tanga anganga kibiri sini' mayam de wari amama aratinga undu' yong ganangga' anga aming wari kane guk mokngang sigesa' ko ikanting u yapma ning inota', sidi kama paramu' sige iking wa na sapkigesina tirik. ");
INSERT INTO uvh_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Ka adibu ning aninting, indi aming kane ira tangam ning guk mokngang waraga' tanga indi sige ikem. Ning tuguinga aming girii wari ning inota', ningwara' sidi mamarak tanga naganing wain feng kane do anga tanamni' ning inota'. ");
INSERT INTO uvh_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Ning tanga anganga kama wari kibirida sini' tinga aming girii feng tuang wari adining aming ka kane aming fam yaptatora wara'ning u katingana ning anota', gu kane aming arantagim u katiana abanga uningkim mambong toyapma yare'. Aming ka kibiri sini' ari' abinging wara'ganang yodanga ima anganga aming ka kamindapking tim munumung sini' abinging wa ari' imotang. ");
INSERT INTO uvh_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Ning aniinga adi tim wa aming ka kibiri sini' yangkarota' u toyabota'. Adi kibiri sini' anga kane mimeng guk mo' tinting de ka aming uningkim toyabota' adi kamindapking sini' dabiksa' anga titining da'ning didimeng dabiksa' toyabota'. ");
INSERT INTO uvh_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Ka aming wari uningkim u ima arayarota' ganang ka aming ka kamindapking sini' anga tinting wari aming ka mandang inga' sini' anting wari uningkim dandameng da' bemting u yapma ning sura adenting, a indi kamindapking sini' abangam wara' indi dandameng sini' unda' bemtam ning sura adenga arakafanting. Ka mokngang aming uningkim toyapma yarota' adi namba kubaniksa' ka aming ka inga' anting wara'siga' imota' wara'guk dabik ningsa' imota'. ");
INSERT INTO uvh_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Ka adi uningkim u bema dabik ningsa' imota' u kanga aming girisi ka kane imota' waraga' kabaksi' kadagang nakngama arokngam tanga ning aninting, ");
INSERT INTO uvh_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","ai indining, gu aming ka kibiri inga'sini' abanga kane kabi'sa' tinging wara'guk dabik ningsa' ba nimarang. Indi kamindap gaa' sini' fabang kuknibinga tanga anganga mayam kagaya girii fukni' ganangsa' amara', ka gu naga' tanga ning guk indaramatang ning tonting. ");
INSERT INTO uvh_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Ka aming girii feng tuang wari midi ka u naknga aming nua'ni ka aming ka goi tinting wara'sining nua'ni u nagira tonga ning anota', amina ning ganotik na kadapmang ka u tirik wa kadagang mo' giramatik. Na tim kane i tanaam waraga' munumung sini' anga ginagarak ganang wa na uningkim ka ning u ganggam ga' ganinga gundu' aigasa' tinga tabanga gipmingak wara' na uningkim ka u didimengsa' togabirik. ");
INSERT INTO uvh_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Ka gu uningkim kuma' gamarik u bemnanga yakangga' gi'sa' maya'. ");
INSERT INTO uvh_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Na feng a uningkim wara'ning tuang wara' na kane aming toyabonga wa naganing sasuksa' tanga tosabotik. Aming ka tim abinging sidi a aming ka mandang ari'sini' abinging wara'guk dabiksa' tosabotik ning tonga undu' naganing sasuk ganangsa' tanga tosabotik. Ka gu naga ai' dapning kadapmang kareng tanga dabiksa' samarik waraga' kabaka kadagang ba naknamarang ning anota' ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Ka Jisas wari midi tipfara u tanga ina biinga ning tanga ning yanggu', beng guk sini' urang torik aming ka kami yara'ganang sigening ningda'ning mandang sini' iking adi inga' wa tim ikni'ga'. Ning tinga aming ka girisi ira tim iking adibu mandang ikni'ga' ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Ka Jisas guk ka arantagimni guk wari Jerusalem yong girii ga' areging. Araranga kadapmang bining ganang Jisas wari ananing arantagimni 12 unggungsa' inagira fonga sasa'ning u kukyapma ning yanggu', ");
INSERT INTO uvh_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","beng sini' sireng ning sanotik, kami ya Jerusalem yong girii ga' urang arem. Indi yong girii u aranga kadofintam ganang wa aming fam wari Amingning Tim Iyak naga bemnapma tonga pris girisi arantagim a Juda ning sasuk aming girisi wara'ganang nipmiinga adibu nugumak titi waraga' midi kadapmang nua'ni totangkani'ga'. ");
INSERT INTO uvh_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Ning tanga bema tonga aming arantagim nua'nining kafasi'ganang nipmiinga wari midi kadagasi kuni' kuni' nangkigenga fefinap tanga bema firi ganang ugarinapni'ga'. Ning tinga kama fama' ibinga famineng wara'ganang wa tubobu marakok ga' ning yanggu' Jisas wari. ");
INSERT INTO uvh_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Ka Sebedi ning tamni wari mindine fama' Jems ya Jon ya u inagira abanga Jisas wari napa' ni tangam ga' ning tonga sura Jisas ning kayong ganang u manda upma mera anigu'. ");
INSERT INTO uvh_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Ka Jisas wari taming u kanga ning anigu', nasi' tagam ga' ning tonga torang. Ka taming wari ning anigu', ma' girii gu beng sini' toya' inga' gu king girii ira marere' ganang wa gu naganing sabane fama' i tim iyak ning yapma manggara ni ka kafaga kareng ganang tara' a ni ka kafaga kesini ganang tara' ning kukyapma tanga marekni'. ");
INSERT INTO uvh_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Ka Jisas wari taming guk ka mindine fama' wara'guk u ning yanggu', a sidi midi ka wara'ning ki kafakafa guk mo' nakdidimanga abanga toing. Ning ina ning tanga iguyangguk u ning yanggu', ma' sidi mamareng ka naga bemonga fatirik wa sidindu' bimbem ning ba. Ka adibu ning togumu', a girii indindu' girisa' bimbem ning yang. ");
INSERT INTO uvh_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Ka Jisas wari ning yanggu', beng sini' sidindu' naganing mamareng dibing u kuma'sa' bemtamu'. A sidi nua'ni ka kafana kareng ganang a nua'ni ka kafana kesini ganang ning marek ga' toyamu' waraga' wa ning sanotik, nagasa' manggara sipmiinga marek ning guk mokngang. Naganing sibeng warisa' aming ka tare ka wara'ganang marek waraga' kuma' ifikasiringa ibigu' wara' adining sasuk ganangsa' manggara ipmiinga marek wara'ning ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Ka Jisas ning arantagim fam wari aming fama' iguyangguk wari midi ka Jisas u girii iikga' anigagumu' wara'ning u naknga kabaksi' kadagang nakiamging. ");
INSERT INTO uvh_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Ka Jisas wari u yapma arantagimni dabik u katiana fong kukyapma ning yanggu', sidi aming arantagim nua'ni kingsi' guk wara'sining kadapmang kuma'sa' yabiting. Adi ning titing, adi aming girisi kigineng guk wara' adi nasi' kane kagaya wa kane aming ga'sa' ima adi yaptatora sa' tanga marekiting. ");
INSERT INTO uvh_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","A sidi wa ning u titining guk mokngang. Sidi Anutuning de ganang wap girii guk iikga' naknga wa sidi kadapmang ka aming fam ning midi u nakiam sa' tanga adisining kane u tiam ning tinting wa giri. ");
INSERT INTO uvh_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Abanga sidi tim iyak aming ning ironga wa sidi kabaksi' bema afanga kane aming sige slev ning kadapmang u yaranga tanga ikanting. ");
INSERT INTO uvh_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Ka Amingning Tim Iyak nandu' ningsa'. Na kamaganang yaraga' afuguk wa na aming wari naganing kane tanam waraga' mo' afuguk, mokngang na adi yotangkayapma adisining kane tiama ning tanga kadagang wari tofiapma iking u udaim wara'ning toni ka naganing fukna ingging kabiaminga nukinga tubobu manggara fabanga gi' kukyap waraga' sura afuguk ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Ka Jisas guk ka arantagimni guk wari Jeriko yong u kabinga aramugoging. Ka yong wara'ning aming arantagim kabi'mo' wari Jisas wari napa' fam tiam waraga' sura marara mandang yaranga aging. ");
INSERT INTO uvh_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Ka kadapmang gaga ganang wa aming dasi' kadagasi fama' wari merafagumu'. Ka Jisas wari anga irafiku' u naknga ku bang sini' ning katigumu', o girii, Devit ning iri gu nipbubure tanga yotankanip te'. ");
INSERT INTO uvh_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Ka aming kabi'mo' ka Jisas u yaranga aging wari aming fama' wari ku katigumu' u yapma yangsefi tiging. Ka aming dasi' kadagasi fama' adi aming wari yangsefi tiging wara'guk mo' nakumu'. Adi ku bang mimeng sini' katinga ning togumu', ai girii, Devit ning iri gu nipbubure tanga kafakafa tinibe'. ");
INSERT INTO uvh_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Ka Jisas adi aming fama' wari ku mimeng sini' katigumu' u naknga anga ade tugu'. Adenga faranga yapma ning yanggu', nasi' tasamotik. ");
INSERT INTO uvh_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Ka aming dasi' kadagasi fama' wari ning anigumu', o girii indi gu dani' i tubobu ifakarendanim ga' nakiamuk. ");
INSERT INTO uvh_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Ning tuguinga Jisas wari bibiri' yapma anga dasi' u suroiminga dasi' wari tubobu kaga'sa' karendainga karengsa' ubu degaregumu'. Degaranga ning tanga Jisas wari mugoinga adi Jisas u yaranga ning tanga Jisas se' guk kubap mugoging. ");
INSERT INTO uvh_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Ka Jisas guk ka arantagimni guk wari araranga Jerusalem yong girii u kagadofi waraga' dudure kuma' tanga yong kabasi' nua'ni ka wapni Betfasi ning aniaging u aranga kadofiging. Yong ka wa kama bubo Oliv wara'ning du' aderagu' u aranga kadofiging. Kadofinga ning tanga Jisas wari arantagimni fama' u ning yanggu', ");
INSERT INTO uvh_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","sidi yong kabasi' do waraga' tim ademu'. Anga kadofinga kantamu' ka dongki meng nua'ni ka mindingni guk ka kuma' tofinga idefaring. U yapma aya u fadara nagata' inagiknama abantamu'. ");
INSERT INTO uvh_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Ka aming nua'ni wari u sapma ai nasi'ga' fadakiamu' ning udep saninga wa sidi ning yangtamu', mo' girii adi dongki yara'ganang wa kane guk waraga' tanga fadakiamuk. Ning ininga adi naksam sa' tanga sisibi sa' tota'ga'. Ning ina yangkareinga agumu'. ");
INSERT INTO uvh_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Ka midi ka Jisas wari arantagimni fama' u yong girii Jerusalm ga' yangkaregu' waraga' wa tim profet wari ning kuma' yoking, ");
INSERT INTO uvh_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“sidi anga yong girii Saion u ning anini', kami guning girii wari gu ganang kuma' kadofonga tara'. Adi kadapmang kugurang karengsa' tanga abara'. Adi maga dongki uyamang ka mambong mamanggak ning wara'ganang mera abara'.” Ning yoking wari kama ka wara'ganang wa beng guk kadofonga tugu'. ");
INSERT INTO uvh_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Ka aming fama' ka Jisas wari u yangkaregu' adi anga nasi' nasi' wa midi ka Jisas wari kuma' yanggu' wara'ganang didimengsa' tanga yaregumu'. ");
INSERT INTO uvh_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Ning tanga dongki fama' u inagira anga Jisas ganang do kadofinga ning tanga anasining saket u kifanga manggara dongki uyamang wara'ning fugu ganang ingaminga Jisas wari dongki uyamang wara'ganang aranga mareiagu'. ");
INSERT INTO uvh_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Ning tinga aming arantagim kabi'mo' wari anasining saket a kwi'si' u kifanga manggara kadapmang ka Jisas wari mugoning wara'ganang ingama yara a fam ka firi yongni karesi wara'ning sasa' u doptanga fonga ingama yara ning tinga Jisas adi dongki wara'ganang aranga mera dongki adi kwi' a napa' karesi kuma' ingama yareging wara'ning furo'ning ganangsa' tipminga aramugogu'. ");
INSERT INTO uvh_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Ka Jisas wari napa' ingama yareging wara'ning bining mera aramugoinga aming arantagim girii wari mesisiringa tanga fam ka tim a fam ka mandang ning anga ku bang ning kating katinga aging, o indi yotangkanip aming girii ka Devit ning arantagim guning wapsa' bema arantam. Adi Anutu girii wari anigareinga abara' wara' anasa' kafakafa sini' tangamota'. Ka indi Anutu girii ning wapsa' bema arantam. Ning kating katinga nagira aging. ");
INSERT INTO uvh_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Ning tanga nagira anganga Jerusalem yong girii bining sini' do amoinga yong girii wara'ning aming kabi'mo' wari u kanga iguk aranga ning tonga yareging, ai wa nisi' aming wari abara' kanga tanga nagira abing. ");
INSERT INTO uvh_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Ka aming ka Jisas u nagira aging wari ning tonga katiangging, ya profet nua'ni wapni Jisas ka yong Nasaret kama tubo Galili tara' do urang wara'ni wari abara' ning toging. ");
INSERT INTO uvh_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Ka Jisas wari Jerusalem yong girii u kadofinga ning tanga siring yak girii tempel wara'ganang anga amogu'. Amanga yapku' ka aming wari napa'napa' u manggara fonga tempel ning sinim iyung wara'ganang kura fatonaging. Maket ka wa Juda aming anasa' moni kura' aming fatiging. Aming sige wari moni u iminga aming arantagim ka tempel kane tiaging adibu moni ka tempel ananing u fiamging. Moni ka u fiamging wa tempel ananing sini' wara' aming wari tempel ganang u amonga wa moni ka u kaminga amama wara'ning u fiamging. Abanga yang mimbep fam ka Anutuga' ofa tangam wara'ning undu' manggara fonga kukinga fatonaging. Ka Jisas wari maket siring yak iyung bane ganang fatiging u yapma kadagang ning kanga yangkagare tanga basingsi' kababi' ka napa' u fonga kura fatiging wara'ning wa ifama igukiam tinga do manga papusinanga mayangaging. ");
INSERT INTO uvh_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ning tanga midi ning yanggu', Anutuning midi ka tim umpang ganang yoking wa ning, naganing yak wa aming wari Anutuga' ibang tongam wara'ning yak ningsa' aninting ning yoking. Ka sidi Anutuning yak ya yak ka kubu aming wari bak kukiting ningda'ning taramaking sabarik. Ning ina yangkagareinga mugo tiging. ");
INSERT INTO uvh_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Ka Jisas wari aming u kuma' yangkagarenga ning tanga adegu' ganang ka aming dasi' kadagasi a kasi' kafasi' kadagasi wari amanga Jisas ganang kadofiinga Jisas wari ifikarendasasu'na tugu'. ");
INSERT INTO uvh_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Ka Jisas wari napa' tangkunang kareng sini' u tinga sababi' adindu' siring yak girii iyung bane u amanga Jisas ning wap bema aranga adita' mesisiringam tanga ning katinga yareging, o karengsa' Devit ning irini kareng adining wap bema arem. Ka pris girisi a sasuk aming arantagim wari u kanga kabaksi' kadagang naknga ");
INSERT INTO uvh_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Jisas u ning aniging, ai gu aming girii Mesaia ning katiganing udi kuma' ba nakarang. Ka Jisas wari ning yanggu', a kuma' nakarik wang. Ka sidi midi nua'ni ka tim umpang ganang yoking u kuma' udep indangikiting wa waraga' sukanting. Midi ka u yoking wa ning, gasa' sababi' sini' waraga' sasuk iminga adi guta' mesisiringa bengsa' tagaming ning yoking. ");
INSERT INTO uvh_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Ning tanga Jisas adi aming arantagim u ibinga amanga Jerusalem yong girii u kabinga anga yong kabasi' Betani u deku'. ");
INSERT INTO uvh_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Ka Jisas adi Betani yong u deia' marara ning tanga kamindapking Jerusalem yong girii ga' tubobu abugu'. Ka adi nana kafakafa guk mo' nagu' wara' adi kadapmang bining ganang segi kagaya naknga ");
INSERT INTO uvh_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","firi fik ka kadapmang bining u aderugu' u kanga mindip beng guk ba ning tonga bema nana titiga' ning tonga agu'. Ka mokngang, mindip guk mokngang sasa' sigesa'. U kanga a firi ka gu sige guk wa nasi'ga' mafatang ning tonga ning anigu', gu beng nua'bu mo' totang, wadigi' bia'. Ning aniinga firi wari kaga'sa' kaforonga sasa' piriring sa' tabemgu'. ");
INSERT INTO uvh_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Ka arantagimni adi firi u kanga base tanga ning toging, ai firi ya nasi' tanga kaga'sa kaforara'. ");
INSERT INTO uvh_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Ka Jisas wari ning yanggu', beng guk sini' ning sanotik sidi ning mo' sukanting, ai indi napa' tangkunang ka ning i titining guk mokngang. Mokngang, sidi nata' naktangka ka kabaksi' guk kufara tinting wa napa' tangkunang ka naga firi ganang i tinga kaing ningyara' wa sidindu' girisa' titining. Ka sidi napa' kabasi' mo' tinting. Mokngang, sidi napa' girii sini' ka kama bubo i ning aninting, gu dadaga tanga gwang ganang do mangfe' ning aninting undu' kuma'sa' tota'. ");
INSERT INTO uvh_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Beng sini' urang sanirik sidi nagata' naktangka tanga naga napa' ni tasam ga' nangting wa na tasam sa' tinga bemnanting ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Ning tanga anga Jisas wari siring yak girii tempel wara'ganang nua'bu amanga ami taming u fainggeku'. Ka pris girisi a Juda ning aming girisi wari anga Jisas ganang u kadofinga ning aniging, ai aming ka gu wa nisi'. Nisi' wari' kane ka u titiga' gipmigu' wa nining tinga naknam. ");
INSERT INTO uvh_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Ka Jisas adi adisining sasuk ka mandaga' taramironga aniging u kuma' kigedanga ning yanggu', we', ka na urap mo' sanotik. Na tim ka sidi napa' nua'niga' sanotik wara'ning u naninga naknga iwatik wa giri naganing kane yara'ning ki u saninga nakanting. ");
INSERT INTO uvh_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Ning ina ning tanga ning yangkagu', tim Jon Baptis wari kadofinga abanga aming ama iyama yaregu' wara'ning ki wa nasi'. Anutu wari kamiinga tugu' wa ma aming warisa' kamiinga tugu'. Ka adi indining tontam ning tonga anasa' ning toging, ai indining da' anintam. Indi Anutu wari kamiinga tugu' ning tontam wa adi ning ma nino', ka naga' tanga sidi Jon ning midi u naknga naktangka guk mo' tiging. ");
INSERT INTO uvh_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","A indi ning tontam, mo' aming warisa' kamiinga tugu' wa ami taming adi Jon wa aming girii profet nua'ni Anutu wari kamigu' ning tuguting wara' adi indining midi ka aming warisa' kamiinga tugu' ning tontam u naknga indita' kabaksi' kadagang ma naknimni'. ");
INSERT INTO uvh_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Ning tonga naknga Jisas u ning aniging, mo' indi wara'ning ki guk mo' nakem. Ning tuguinga Jisas wari ning yanggu', ningwara' nandu' kane ya ni' wari nipminga tirik wara' ning ki undu' mo' sanotik ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Ning tanga Jisas wari Juda ning aming girisi u midi nua'ni ning yanggu', ka midi nua'ni ubu sanotik u nakni'. Wa ning, aming nua'ni adi mindine fama' guk. Ka babangsi' wari mindingni nua'ni u ning anota', gu naning wain feng kane anga te'. ");
INSERT INTO uvh_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Ka mindingni wari ning touta', a bibi' nakarik. Ning tonga mo' auta'. Ka inga' kaba ubu faranga angati tota'. ");
INSERT INTO uvh_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Ka beni adi mindingni nua'ni undu' ningsa' anga anota'. Ka adi we' sibeng una kuma' mautik. Ning kuma' touta' de, ka mokngang au guk mo' ubu tota'. ");
INSERT INTO uvh_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Ka kadapmang ka waraga' wa sidi indining suking, babangsi' ning midi ninaksa' wa indeng wari tara'. Ka aming wari ning toging, mo' beni ning midi ninaksa' wa mindingni ka tim anga anota' wari tara' ning nakem. Ka Jisas wari ning yanggu', weng wa beng guksa' toing. Ka midi u torik wara'ning kini sanotik i nakni'. Anutu adi aming wari adining bining ganang iik wara'ning tim iyak aming ning iik waraga' wa Juda ning aming girisi sidi sibinga aming ka wap kadagasi ning initing ka takis mamanggesi a taming sansaramik titisi ubu kuma' manggara kukyabara'. ");
INSERT INTO uvh_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Ka wara'ning kini wa ning, tim Jon Baptis wari kadapmang kareng kuma' abanga sangtintingnegu' ka sidi nakngam guk mo' tiging. A aming takis mamanggesi a taming sansaramik titisi adi Jon ning midi u naknga waraga' naktangka tiging. Ka inga' undu' ningsa', sidi adi naktangka tiging u kanga kabaksi' faranga Jon ning midi u ninak ning guk mo' tiging. Mokngang sidi sigesa' ka tim unda' ira abiging ningsa' ko iking yang ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Ka Jisas wari Juda ning aming girisi u midi nua'ni ning yanggu', ka sidi midi tipfara kabi' totik i kafakafa nakni'. Wa ning, aming girii nua'ni wari wain feng tota'. Tanga ning tanga wain feng wari gi' iik waraga' sinim tangkunang ipma yaranga a wain mindip giming u manggara fonga kura titipmi tinga ameng wari kadofinga bekinga gigik wara'ga' kama kwang unanga kabinga a aming wari wain feng u katatora waraga' yak kabasi' nua'ni ka sinim wara'ning gaga ganang u manga ning tota'. Adi ning tanga kabinga kama kamani anga iikga' sura aming fam u ning inota', sidi naganing feng i katatoranga tanga ira uningkim dibing ka sidata' manggakna a dibing ka nagata' nanam ning tianting. Ning ina kabiam mauta'. ");
INSERT INTO uvh_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Anga iya' aming girii wari wain mindip giming mamanggak ning kama farota' u kanga o naganing uningkim dibing kuma' unda' bema kaminaming ning tonga uningkim u anga bemama abu waraga' adining aming fam yangkareinga anting. ");
INSERT INTO uvh_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Anga kadofiinga aming ka feng u katatoranga tanga ikanting wari aming girii ning arantagim u yapma kabaksi' kadagang naknga ning tanga nua'ni wa ura kabi tanga nua'ni wa wadigi'sini' ugumakanting. Ning tanga nua'ni wa uningkim kwak wari ukanting. ");
INSERT INTO uvh_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Ka aming girii adi u kanga aming fam usap gi' nua'bu yangkarota'. Ka wari anga kadofiinga undu' aming ka feng kane u tanga ikanting adi u yapma amise fam ka tim iramakanting ningsa' unggung nua'bu iramakanting. ");
INSERT INTO uvh_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Ka aming girii feng tuang wari aming ka feng katatoranting wari kadapmang ka ning u tanga abanting u kanga ning surota', o aming fam yangkararik ka adi ning ting wara' na naganing sabana ingging ubu anigarotik. Ka feng katatora aming adi ananing nonda sini' kanga wa giri kagabi tanga kafakafa tangamting. Ning tonga ari' sini' wa ananing mindingni unggung anigareinga auta'. ");
INSERT INTO uvh_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Ka mokngang, adi mindingni wari anga kadofota' u kanga ning tonting, ai ananing mindingni sini' anabu abara' u kani'. Indi ugumak tanam. Ura ning tanga feng ya nanasa' uba katatoranga ikantam. ");
INSERT INTO uvh_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Adi midi ning totangkanga kabinga ning tanga feng tuang ning mindingni u wain feng iyung do bema sinim fugang kuragamanga amanga fugang do ugumakanting. ");
INSERT INTO uvh_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Ka indining naking sidi wa, inga' aming girii anabu abota' ganang wa aming arantagim ka feng katatoranting wa nasi'guk tiabora'. ");
INSERT INTO uvh_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Ka Juda ning aming girisi wari adibu ning toging, a adi aming kadagasi wa iibi guk mo' tota', dipmisasu'nasa' tota'. Dipminga ning tanga aming karesi ubu manggara kukyabinga feng kane u tanga ira anganga inga' feng wari beng titi ganang wa adi kadapmang didimeng tanga uningkim dibing wa feng tuang ga' aminting ning aniging. ");
INSERT INTO uvh_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Ka Jisas wari adisining midi u nakiama ananing kane waraga' yangnatamonga ning yanggu', ka midi ka u torik waraga' ka midi nua'ni ka tim ning tuguinga yoking, “uningkim ka aming yak mama ning wari kadagang ning kanga kabiging ka inga' girii adibu uningkim ka u bema adining yak tipmarak wara'ning mangkap girii tim iyak ning ubu kamira'. Beng sini' girii warisa' u tara' wa kareng beng sini' kayam ning yoking.” Ka sidi midi ka wara'guk mo' ba indangira nakiting. ");
INSERT INTO uvh_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Ka beng sini' ning sanotik, tim Anutu wari sidi adining bining ganang iikga' kuma' sifakasiregu'. Ka kami yara'ganang wa Anutu adi udasap tanga aming arantagim nua'ni ubu manggara kukyabinga ikanting. Ira kadapmang didimengsa' tanga Anutuning bining wara'ning iik kareng beng guk tipkadofanting. ");
INSERT INTO uvh_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","(Ka uningkim ka urang torik waraga' wa ning sanotik, uningkim ka wa fasi' kadagang ikita'. Ka aming ka uningkim ka wa sigening ning kanga uningkim wara'ning furo'ning ganang manga dipmota' wa uningkim fasi' wari ifikadaga sini' tota'. A uningkim fasi' ka wari aming ning fugu furo'ning mangfota' wa aming u wadiging manga dopsasugweinga kugo'sa' kadofota' ning yanggu'.) ");
INSERT INTO uvh_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Ka pris girisi a Farisi arantagim adi Jisas wari midi tipfara ka wa anasita' sura tiamgu' u kuma' sura nakedaging. ");
INSERT INTO uvh_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Ning tanga Jisas ga' kabaksi' kadagang nakngama bimbem titiga' ning tonga kuma' suking. Ka aming arantagim wari Jisas wa aming girii profet ningda'ning kaging waraga' tanga indi bimbem tantam wa aming wari kabaksi' kadagang ma naknimni' ning tonga sura kagabisa' tinga mugo tugu'. ");
INSERT INTO uvh_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Ka Jisas wari aming arantagim wara'siga' midi tipfara nua'ni ning tanga yanggu', ");
INSERT INTO uvh_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","ka kadapmang ka Anutu wari aming wari adining bining ganang iik waraga' inagikita' wara'ning wa aming girii king nua'ni wari adining mindingni wari taming kafauwe tonga tinga waraga' tangsana girii tota' ningda'ning. ");
INSERT INTO uvh_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Ka aming girii adi tangsana u ko mo' tanga ganang aming fam ka tangsana wara'ning nana u abanga nana waraga' tim kuma' ina ibota'. Ka inga' tangsana wari dudure tinga aming ka u inga ibota' u anga inagik waraga' kane aming fam yangkareinga anga ina yaranting. Ka mokngang, aming adi tangsana waraga' au ga' wa bibi' ubu nakanting. ");
INSERT INTO uvh_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Ka aming girii adi aming wari bibi' nakngama au guk mo' tinting u yapma aming fam nua'bu yangkaranga ning inota', sidi i anga aming ka tim i abubu ga' yangguk u ning nua'bu yangting, ai aming girii wari ning tora' tim tangsana ga' urang sanggu' wa kuma' kadofira'. Na bulmakau girisi a bulmakau amang boknisa' karesi u kuma' dipminga dopma a nana a napa'napa' fam undu' dabiksa' kuma' tugunungnasasu'narik wara' adi mo' fakanting, abubu sa' tinting. Ning ina yangkareinga anting. ");
INSERT INTO uvh_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Anga kadofinga yangara midi ka aming girii wari inota' ning u kuma' ina yaranting de. Ka mokngang adi kuma' nakiama bibi' naknga anasaning kanesi'ga' marara marara manting, ni ka feningga' mauta' a ni ka ananing stoa kanega' mauta'. ");
INSERT INTO uvh_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Ning tinga aming fam adi parap marara kane aming ka aming girii ning midi bema anga yangting u suroyapma ning tanga fam ka didipmi sa' tanga ibi a fam ka dipmakumak sini' titi ning tinting. ");
INSERT INTO uvh_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Ka aming girii king wari adining kane aming dipminting wara'ning midi ne u naknga kaba kadagang sini' naknga ning tanga adining ami'ning aming arantagim u yangkareinga anga aming ka adining kane aming ifakadanting u dipmisasu'nanga a yak siama ning tanga yaranting. ");
INSERT INTO uvh_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Ning tanga aming girii king wari kane amingni fam u katiana ning inota', naganing tangsana kuma' karendasasu'nara'. Na tim aming adi aming karesi ba ning tonga tangsana yara'ning nana i abanga nana ga' ning tonga kuma' yangguk ka mokngang, adi ningwara' wari nana i nana ning guk mokngang. ");
INSERT INTO uvh_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Ka aming nana i abanga nana ning guk mokngang wara' sidi anga yong yong u yangara nisi' aming ka ni indeng kataunga wa iyang sa' tinga abanting. ");
INSERT INTO uvh_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Ning ina yangkareinga kane amingni wari yong yong u nua'bu anga yangara nasi' aming karesi a aming kadagasi u dabiksa' ina inagira abanting. Inagira abuinga yak ka taming kafauwe ning tangsana tinting wara'ning iyung bane ganang u amanga tiptona sini' tanga kama dibing kabi' sige guk mo' aduta', amingsa' defarota'. ");
INSERT INTO uvh_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Aming wari iyung bane u amasasu'nanga marekinga aming girii king ka tangsana girii wara'ning tuang wari aming ka nana u nana ga' anga mareknganting wari tangsana wara'ganang marek ning kwi' didimeng mo' ipmanga au waraga' kuruma yapma yarota'. Ka aming aming dabiksa' adi giri, tangsana wara'ning kwi' didimeng ipmanga abanga marekanting. Ka aming kubaniksa' ka ananing kwi' sige kangkama tanga fengak ning unggungsa' kamanga amanga marerota'. ");
INSERT INTO uvh_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Ka aming girii wari aming ka u kagakesina sini' tanga aming ka u ning anota', amina gu kafauwe ning tangsana yara'ning kwi' inga'ni kareng guk mo' kamangang gabarik. Ka gu iyung bane ya gagap guk mo' wa indining tinga afanga maretang. Ka aming adi girii ning midi u naknga midi tubobu anini ga' nafek tanga marek sa' tota'. ");
INSERT INTO uvh_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Ka girii wari u kanga kane aming u ning inota', sidi aming i bema kayong kafong impa ipma bema fugang kama gaa' kangkam ganang do kurakamani'. Ning tinga adi aming fam guk kama ka kadaga titining wara'ganang ira kadaga sini' tanga ku ningsa' fagatota'. Ning ininga ipma bema kura kamanting ning titining ningda'ning. ");
INSERT INTO uvh_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Ka Jisas wari midi tipfara u tanga ina ina ning tanga ning yanggu', beng sini' Anutu adi aming arantagim kabi'mo' katianita' de ka aming ka adining bining ganang sini' iik ga' ifakasiranga manggara kukyabita' wa mimeng sini' mo' fama'sa' wari amanga ikiting ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Ka Farisi arantagim wari midi ka Jisas wari yanggu' u naknga anga midi fam ka Jisas u anigainga Jisas wari midi fam ka fe' tinga midiganang bema kaminga mamareng amimi waraga' tonga naknga totangkaging. ");
INSERT INTO uvh_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Adi midi u totangkanga ning tanga Farisi wari adisining arantagim guk ka Herot ning arantagim fam wara'guk u yangkareinga Jisas kaunga aging. Anga kadofinga Jisas u mandaga' taramikonga ning aninga yareging, ma' aming girii gam indi kuma' fagapkedem gu midi beng guksa' fatorang. Gu aming ka ni midi anonga wa gu a adi aming girii wara' na sireng sini' mo' anotik ning tonga tosasebe da' guk mo' titang. Mokngang gu Anutuning kadapmang wa didimengsa' ituatang. ");
INSERT INTO uvh_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Wara' indi napa' nua'niga' gangkantam wa gu didimengsa' ninotang. Gu indining sutang, Juda aming indining kadapmang wa indining adera', Romni girii Sisa wari takis kamingam ga' tuguta' ka indi adita' takis udi girisa' kamingamtam wa ma mokngang ning anigaging. ");
INSERT INTO uvh_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Ka Jisas adi kabaksi'ganang u sasuk kadagang guk tanga anga aniging u kuma' yapkedanga ning yanggu', a sidi kuma' sapkedarik sasuk kadagang guk abanga mandaga' naramironga ting. ");
INSERT INTO uvh_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Ningwara' moni ka ni namni'. Ning ininga moni ka ni bema amiging. ");
INSERT INTO uvh_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Aminga bema yangtintingnanga ning yanggu', moni yara'ganang aming uuring ning nondani a wap ya nisi'ning yoking. ");
INSERT INTO uvh_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Ka adibu ning aniging, mo' wa Rom ning girii Sisa adining nonda a wapni kayam. Ning tuguinga Jisas wari ning yanggu, beng sini' Sisa ning nonda wara' napa' ka Sisa ga' amimi ning wa Sisa anata' didimengsa' aminting. A napa' ka Anutuga' amimi ning undu' Anutuga' didimengsa' aminting ning yanggu;. ");
INSERT INTO uvh_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Jisas wari midi ka u ininga adi Jisas ning midi u kuni' nua'ni sini' naknga midi nua'bu guk mo' aniging, kagabi tanga mugo tiging. ");
INSERT INTO uvh_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Ka kama kubanik wara'ganangsa' ka arantagaim nua'ni ka Satyusi ning iniaging adibu abiging. Arantagim ka wa aming kungkumosi udi tubobu guk mo' marakiting ning toyaging wari abiging. ");
INSERT INTO uvh_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Abanga Jisas ganang kadofinga Jisas u ning aniging, ma' aming girii gam kadapmang ka tim Moses wari nimgu' u yaranga ikitam wa ning, aming nua'ni wari taming sananga saba guk mo' ibenga ganang kumarota'. Ka kuyangni mandangni adibu taming ka u sananga kuyangni ka u kumarota' wara'ning gipmam waraga' saba kabasi' tipkadofota' ning yoku'. ");
INSERT INTO uvh_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Ka indining, amine fam ka se'kuyane seven ning yaging, ka kuyasi' tangandang wari taming sananga ka saba guk mo' ibenga kumogu'. Ning tinga tamkasa'ni wa kuyang mandangni adibu sanagu;. ");
INSERT INTO uvh_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Ka adindu' ningsa' saba guk mo' ibenga ganang kumogu'. Ning tinga kuyangni mandangni nua'ni adibu sanagu'. Ka adindu' saba guk mo' ibenga kumogu'. Ning tinga kuyasi' biningni nua'ni adibu sana undu' sige ningsa' ira ganang kungkumak ningsa' tang tanga anganga kuyasi' mandangni ari'sini' ka seven ning adindu' ningsa' tana kumogu'. ");
INSERT INTO uvh_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Ka se'kuyane arantagim dabiksa' adi ningsa' kumaksasu'neinga mandang ari'sini' wa tamsi' wari kumogu'. ");
INSERT INTO uvh_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Ka girii gu waraga' wa indining sutang, inga' Anutu wari aming kungkumosi tubobu ifimararo' ganang wa aming ka u kumakanting wa taming wa nisi'ning tamni sini' iro'ga'. Adi aming kubaniksa' mo' sangamgu', mokngang adi se'kuyane seven ning sini' u dabiksa' siama anganga kumoging waraga' tanga indi ning sukem ka mokngang. ");
INSERT INTO uvh_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Ka Jisas wari ning yanggu', a sidi Anutuning midi kadapmang beng guk ka tim kuma yokinga fideta' wara'guk mo' kating. Abanga sidi Anutuning kigineng undu' kaga guk mo' titing wara' ning sanirik, sidi fe' sini' ting. ");
INSERT INTO uvh_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Ka aming kungkumosi wari tubobu marakni' ganang wa kadapmang ka ami taming wari imaraming iikning wara'guk mokngang, wa kuma' biwa'. Adi Anutuning kunim aming ensel wari ikiting ningsa' ira dadawang sa' ubu ikni'ga'. ");
INSERT INTO uvh_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Ka sidi aming kungkumosi wa tubobu mamarak ning guk mokngang ning tuguting waraga' sanotik. Ka midi ka wara'ning wa tim Anutu wari tuguinga kuma' yoksamging, ka sidi wara'guk mo' ba indangira nakedating. Midi ka wa ning yoking, ");
INSERT INTO uvh_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Anutu wari ning togu', na Ebraham ning Anutu a Aisak ning Anutu a Jekop ning Anutu wari itik. Ka beng sini' Anutu adi aming famineng ka wa timinggi' sini' kuma' kumoging ganang inga' togu' wa adi ka' ko ikinga yapma wa u togu' wang. Wara' indi u kanga ning sura nakedantam, Anutu adi ka' iik ning ki wara' adi aming ka ka' iik titining guk mokngang u yaptatora ning mo'. Mokngang adi aming ka ka' iik guk unggungsa' yaptatoreta' wara'sining Anutu, ning nakanting ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Ka ami taming arantagim ka midi u adenga naking wari Jisas ning midi u kigineng guk kuni' nua'ni ning naknga base tiging. ");
INSERT INTO uvh_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Ka Satyusi arantagim wari Jisas u anga anigaging ka Jisas wari iirafik sini' tugu' u kanga Farisi arantagim wari bak kura indining da' tinga bemtam ning tonga midi tonga naknga ");
INSERT INTO uvh_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","ning tanga Mosas ning kadapmang tangkunang ning sasuk aming nua'ni u anigareinga anga Jisas u ning anigagu', ");
INSERT INTO uvh_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","ma' aming girii gam Moses ning kadapmang tang ganang wa midi tangkunang ka tim iyak sini' wa indeng wari adera'. ");
INSERT INTO uvh_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Ka Jisas wari ning anigu', midi tangkunang wara'ning tim sini' adera' wa midi ka gu kabaka kubanik a ninaka kubanik a sasuka kubaniksa' wa guning giriiga Anutu waraga'sa' kufarotang. ");
INSERT INTO uvh_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Midi ka warisa' wa midi tangkunang wara'ning tim iik sini' ikita'. ");
INSERT INTO uvh_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","A midi ka wara'ning mandang ita' undu' kabi'sini' ka wara'guk dabiksa' wa ning, gu kabaka ka aming fam ga' siamo' naknga kafakafa tiap wara'guk ira ning tanga kafakafa sini' ka ganing fuka ga' titang ningsa' tiamotang wang wari ita'. ");
INSERT INTO uvh_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Beng sini' midi ki ka fama' warisa' Moses a profet arantagim ning kadapmang u defata' wara'ning tim iyak sini' ikitamu', midi tangkunang wara'ning nua'ni wari midi ki kiginesi fama' wara'guk mo' irafita', mokngang sini' ning anigu'. ");
INSERT INTO uvh_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Ning tanga Farisi arantagim udi bak ko kura mareiaging ka Jisas wari ning yangkagu', ");
INSERT INTO uvh_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","ma' sidi midi ka Kasira Aming wari abubu ga' fatuguting wa sidi nisi'ning arantagim ganang kagadofi waraga' fatuguting. Ka Farisi wari ning aniging, mo' wa girii Devit ning arantagim ganang kadofo'ga' ning fatugutam. ");
INSERT INTO uvh_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Ka Jisas wari ning yanggu', beng sini' sidi Kasira Aming wa Devit ning arantagim ganang kadofo' ning fatuguting. Ka Devit adi aming girii de ka timinggi' Anutuning mini unggo wari Devit ga' sasuk amiinga Devit adi Kasira Aming waraga' wa adindu' naning girii ning togu'. Ka midi ka Devit u togu' wa ning yoking, ");
INSERT INTO uvh_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","“girii wari naning girina u ning anira', gu naning kafana kareng ganang i abanga mera nagok girii dabik ikdam. Ning tanga na guning digirapka wa didipmi tanga fabanga guning kapmik ganangsa' kukyabinga gusa' yaptatorotang ning tuguinga yoking. ");
INSERT INTO uvh_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Ka sidi ning fatuguting, Kasira Aming wa Devit ning iri ganang didimengsa' kadofo'ga'. Ka Devit undu' aming girii, ka adi naning girii ning anigu;. Wara' ning nakedantam, Kasira Aming wa amingsa' mo' wara' Devit ning iri sa' ning anonga. Mokngang wa aming girii sini' ka kadapmang nua'ni ganang kagadofi ning. ");
INSERT INTO uvh_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Ka Farisi arantagim adi midi tubobu anini wara'ning kadapmang kabi'sini' guk mo' katuaging. Ning tanga adi kasara tanga kagabi tanga inga' midi fam nua'bu guk mo anigaging.” ");
INSERT INTO uvh_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Ka Jisas wari ananing arantagimni 12 wara'guk ka aming arantagim sige guk u ning yangnatamgu', ");
INSERT INTO uvh_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","sasuk aming arantagim guk ka Farisi guk adi Mosas ning kadapmang tang u yanggek wara'ning wap guk iking, ");
INSERT INTO uvh_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","wara' adi Mosas ning kadapmang tang u indangiksaminga wa sidi naknga yarasa' titing. Ka aming ka Moses ning kadapmang tang u indangiksamiting tuang ana wa kadapmang u yara guk mo' titing. Wara' sidi midi ka kadapmang wara'ning ungungsa' wa giri nakanting, a adisining iiksi' ning kadapmang wa mo' yaranting. ");
INSERT INTO uvh_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Ka Farisi arantagim adi kadapmang ka u titing wa adi aming wari napa' mamaresi kabi'mo' ka aming fam ning fuksi'ganang urang gufariaminga manggeting ningda'ning saramira kabi'sini' guk mo' yotangkasabiting. ");
INSERT INTO uvh_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Adi sasuk ka Moses ning kadapmang tang waraga' mimeng sini' mo' titing. Mokngang adi sasuk ka aming wari adisining wap bema ara waraga'sa' sura kadapmang ka u tanga ikiting. Adi kadapmang ka anasining fuksi' u bema ara wara'ning u titing wa sidindu' kuma'sa' yabiting. Adi aming wari iyap waraga' sura Anutuning midi fam u umpang ganang yora yora ning tanga yana tanga dimisi' a kafasi' ganang sirengsa' iptanga fengating. A kwi'si' iipma undu' napa'napa' karesi wara'guk kuma' tanga muntofiting unggungsa' ipmating. ");
INSERT INTO uvh_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Abanga kama ka aming wari tangsana girii tanga bak kuguk ganang a siring yak iyung amama ganang undu' adi aming wari iyap ga' ning tonga tare karesi ka aming girisi wari mimek ningsa' ka tim do ikiting wara'ganangsa' anga marekiting. ");
INSERT INTO uvh_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Abanga adi kama ka aming wari bak kukiting ganang undu' aming wari yapma o aming girii ba abara' ning tutugu waraga' ning tonga sirengsa' arengating. Adi kadapmang ka ningwara' u tanga ikiting. ");
INSERT INTO uvh_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Ka sidi wa ning sanotik, sidi kadapmang ka fuksi' bema ara ning ka adi u titing wa mo' tinting. Sidining bining ganang wa aming ka ni girii guk mokngang, sidi se'kuyane arantagim dabiksa' ka aming nua'nining kapmik ganangsa' iikning ning ikanting. Ka aming fam wari girii ning saninga wa sidi anisefi tinting. ");
INSERT INTO uvh_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Abanga sidi kamaganang yara'ni aming ka ni girii ning kanga babangsi' ning guk mo' aninting. Mokngang sidining babangsi' girii kubanik wa kunimganang ikita' unggungsa' wa giri aninting. ");
INSERT INTO uvh_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Abanga sidi aming nua'ni wari a gu indining tim iyak aming ning sansang waraga' aiga sa' mo' tinga sangting. Mokngang sidining tim iyak aming kubaniksa' wa Kasira Aming unggungsa' aninting. ");
INSERT INTO uvh_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ka sidining bining ganang aming ka ni wari tim iyak aming ironga wa adi tim ka arantagimni ning kapmik ganangsa' ira adisining kane tiamota' wa giri. ");
INSERT INTO uvh_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Aming ka girii irotik ning tonga ananing wap anasa' bema arota' wa Anutu adi mokngang ning kanga tipmakurati tota'. A aming ka ananing sasukni a fuguni bema afasasu'nanga aming fam ning kapmik ganang irota' wa Anutu adi aming ka wa aming girii beng sini' ning aninga yotangkangam tota' ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Ning tanga Jisas wari Farisi a sasuk aming arantagim u ning ifang yanggu', a aming ka sidi midi beng guksa' mo' fatoing. Sidi midi udi mandaga' a fisa' guk fatoing wara' sidi kadasasu'na titi wara'ningsa'. Sidi Anutuning bining ganang iikga' bibi' naknga aming sige wari Anutuning bining wara'ganang amanga irong tinga undu' kadapmang udaim wa sidasa' fating. Ning tinga adi yoingak tanga Anutuning bining ganang guk mo' ikiting. ");
INSERT INTO uvh_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","(Ka sasuk aming a Farisi arantagim sidi aming midi fisa' tutugusi beng sini' wari iking. Sidi kadasasu'na sa' titi wara'ning. Sidi tamkasa' arantagim wa a adi aming fam yotangkayap ning tangkunang guk mokngang ning tonga iibisa' mo' fating. Mokngang sidi fikifiki uningkim sansam ga' katianafak sa' tinga adi mambongsi' kabi' u samsasu'nanga nafek sini' tanga sigesa' ikiting. Sidi kadapmang kadagang ka ning u kuma' tanga ira megang kabi'guk mo' naknga aming ning dasi'ganang sirengsa' adenga ibang paramu' sini' sigesa' fatuguting. Ka sidi kadapmang ka ning u fating wara'ning mamarengni wa kabasi'mo' bemni'ga'.) ");
INSERT INTO uvh_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Ka sasuk aming a Farisi arantagim sidi midi fisa' tutugusi beng sini', sidi kadasasu'na sa' titi wara'ning wari iking. Sidi aming karesi fam yapma inagira fabanga sidining kadapmang u yanggera iik waraga' sura kama kamani indeng gwang ganang a kama bubo u yangara kane girii sini' tanga inagira fabuting de. Ka sidi kadapmang kareng sini' u mo' fainggeking, mokngang sidi fabanga kadapmang kadagang ka kudip ganang mugoning sa' ka sidi tanga ikiting ningwara' u yanggekinga adi kadagang girii sini' tanga adisining kadagang wari sidi sirafakiting. ");
INSERT INTO uvh_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Beng sini' sidi aming kadapmang yangtintingning ning iking. Ka mokngang sidi fe' tanga aming dasi' kadagasi da'ning inagira sidagok dabiksa' fayoingak ingating, sidi kadasasu'na sa' titi wara'ning. Abanga sidi aming u ning fainiting, sidi napa' niga' midi totangka tanga beng sini' siring yak girii ganang do torik ning kuma' tonting. Ka inga' napa' ni titiga' kuma' totangkanting u tatarafik wara'ning kadapmang kabi'guk giri kanga wa girisa' kabinting, ning ubu fainiting. A aming ka siring yak girii wara'ning napa' diding gol fideta' wara'ganang torik ning totangkauta' wa adi napa' tapni tangkunang sini' ning kanga inga' midi ka u tatarafik ning kadapmang guk mokngang, bengsa' tota' ning fainiting. ");
INSERT INTO uvh_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Ka sidi midi ka tempel wa napa' tangkunang sini' mo', a tempel ning gol wa napa' tangkunang ning tuguting wa ning torik, sidi masi' papesi a dasi' kadagasi beng sini'. Gol wa tempel ning kapmik ganangsa' ita' wara' tempel wa napa' girii wap guk beng sini' ikita'. ");
INSERT INTO uvh_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Abanga sidi ning fainggekiting, aming wari napa' ni tonga midi totangka tanga tempel ning alta wara'ning wap guk touta' wa napa' tangkunang sini' mo'. Inga' midi totangka ka u udaga ning kadapmang kabi'guk giri kanga wa girisa' kabinting, ning fainiting. A adi midi totangka tanga napa' ofa ka alta wara'ning furo'ning ganang kuknganting wara'ning wap touta' wa kigineng sini' wara' wa udaga titining guk mokngang ning tuguting. ");
INSERT INTO uvh_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Sidi aming dasi' kadagasi. Ka nasi' wari girii, alta beng uba ma ofa ka alta ganang kukiting uba. Mokngang alta wara'ganangsa' wa ofa u titing wara' alta wa napa' girii. ");
INSERT INTO uvh_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Ka na ning toutik, aming ka alta ning wapsa' touta' wa napa'napa' alta ganang ikiting wara'guk dabiksa' kuma' yora tora'. Wara' adi midi totangka ka u nua'bu udaga ning guk mokngang sini'. ");
INSERT INTO uvh_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Abanga aming ka napa' niga' midi totangka tanga beng sini' tempel ganang torik ning touta' wa napa' girii sini' tora'. Tempel wa Anutuga' kane tangam ning yak wara' tempel ning wap touta' wa Anutu ananing wap didimeng sini' tutugu ning ningda'ning tora' wara' napa' girii sini'. ");
INSERT INTO uvh_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Abanga aming ka ni midi totangka ka ni tanga ning touta', na kunim yongganang kuta torik wa adi kunim yongsa' mo' yora tora'. Mokngang kunim wa Anutu girii wari marekita' wara'ning tare ning ikita' wara' adi kunim kuta yora touta' wa adi tare wara'guk ka aming ka tare wara'ganang marekita' wara'ning wap tora' wara' wa napa' girii sini' ka nua'bu udaga titining guk mokngang. Beng sini' Anutu wa aming wari adining wap sige tutugu waraga' tapni girii ning ikita', ka napa' ka Anutuga' sura tangam ning undu' tapni girii. Ka sidi midi totangka ka aming wari midi tapni wara'ning wap guk tonga titi waraga' fainggeking wa sidi kadagang girii sini' fating. ");
INSERT INTO uvh_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Ka sasuk aming a Farisi arantagim sidi aming midi fisa' tutugusi beng sini', sidi kadasasu'na sa' titining wari iking. Sidi masi' papesi, napa' kababi' sini' ka nana ganangsa' ifamarandanga nana wara'ning u tagagareunga wa giri sidi Moses ning kadapmang tang yaranga Anutuga' amonga wa kane girii tanga didimengsa' tagagareting. A kadapmang karesi sini' fam ka Moses ning kadapmang tang wara'ganang ikiting ka aming ga' tiam wara'ning wa sidi wara'guk mo' fating. Kadapmang ka kagabi fating u torik wa ning, sidi kadapmang didimeng yaranga aming fam kafakafa tiap a yapbubure a midi a kadapmang beng guksa' tanga iik wang wa napa' girii sini'. Ka napa' kababi' ka u fating wa mo' titining mo', wa girisa' titining. Ka u tanga napa' girii ka kagabi fating undu' tanga ning tinting wa napa' beng guksa' tinting. ");
INSERT INTO uvh_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Ka sidi aming arantagim ning kadapmang yangtintingning tim iyak ning iking. Ka ning sanirik, sidi dasi' kadagasi sidi kadapmang ka u fainggeking wa kadapmang ka aming wari nana naunga susu kababi' sini' wa giri tanga igura napa' kubung kadagang ka nana ganang wa kaga guk mo' tanga wara'guk nanasa' urang titing ningda'ning sini' tanga iking. ");
INSERT INTO uvh_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Ka sasuk aming a Farisi arantagim sidi aming midi mandaga' tutugusi beng sini'. Sidi kadasasu'na sa' titi wara'ning wari iking. Sidi kadapmang kadagang ka napa' usingsa' tagagare ning u tanga iking. Abanga sidi aming nua'nining mambong kareng kamamarenga anigagare tanga sidata' irombemna ning u fating wa sidi kadapmang ka aming wari gafa fugu usingsa' yotik karendanga bane wa nana kugo' a napa' timini kubung kadagang wari ko fideinga nana wara'ning using ganang urang yora kura nating ningda'ning kadagang sini' tanga iking. ");
INSERT INTO uvh_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Ka Farisi arantagim sidi dasi' kadagasi beng sini', sidi gafa u yotironga wa tim ka gafa wara'ning bane u yotikanting wa kareng dabiksa' irota'. ");
INSERT INTO uvh_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Ka sasuk aming a Farisi arantagim sidi aming midi mandaga' tutugusi beng sini', sidi kadasasu'na sa' titi wara'ning wari iking. Sidining iiksi' wa kadapmang ka aming wari aming kungkumosi unafarafiapma aming fam wari aming kusik u kanga napa' kubung mang waraga' ma sukni' ning tonga kusik using wa kafakafa sini' urang tanga ifabambanenga ibiting ningda'ning beng sini' tanga iking. ");
INSERT INTO uvh_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Sidi kadapmang ka napa' usingsa' tabambanenga iik ning unggungsa' yaranga tanga ikinga aming wari aming didimesi ning fasabing. Ka sidining kabaksi'ganang wa kadapmang kadagang ka aming midi fisa' iyang a sasuk ka kadapmang kadagang titi wara'ning wari to'na sini' tanga defata' ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Ning tanga Jisas wari midi kigineng ning nua'bu ifang yanggu', ka sasuk aming Farisi arantagim sidi aming midi fisa' tutugusi beng sini', kadasasu'na sa' tini'ga'. Sidi profet arantagim a aming girisi ka tim kadapmang didimeng tanga ikiaging adisining kusik u kamaranga kafakafa ifagidabanga fiareting. ");
INSERT INTO uvh_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Ning tanga ning fatuguting, a papase' adi proget karesi wa naga' dipmikumoging. Indiganang wa mo' dipmikumaronga tugum ning fatuguting. ");
INSERT INTO uvh_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Ka na ning torik, sidi midi ka papane ning toing wa sidi papase ka tim profet u dipmikumoging wara'siguk kabaksi' kubaniksa' iikning ningda'ning beng sini' tanga iking. ");
INSERT INTO uvh_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Ka sidi kane ka tim papase wari aming dipmikumak ning u kuma' tipmarara tanga fabing wara' ning torik, girisa' u yaranga tanga tipmi tini'. ");
INSERT INTO uvh_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","A sidi gimik kagaya kadagasi wari aming dipming nonga bak urang titing ningda'ning ting sabarik. Sidi Anutu wari kudip kadagang ganangsa' manggara dipmisasu'na wara'ning, sidi kagaya girii u tatarafik wara'ning kadapmang guk mokngang sini'. ");
INSERT INTO uvh_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Ka na sirengsa' ning sanotik, na profet fam a sasuk aming a yanggek aming u sidining bining ganang ko yangkarotik. Ka wa sidi iibi mo' tini'ga' mokngang, sidi fam ka dipmikumak tanga fam ka firi ugari ganang manggara tapyapma dipmikumak ning tanga fam wa manggara fonga siring yak iyung bane ganang fefiap tanga yarani'ga'. A fam ka yangkagare sa' tanga fiareinga gi' guk mo' marekni'ga'. Sidi kadapmang ka ning u kuma'sa' iramakni'ga'. ");
INSERT INTO uvh_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Ka beng sini' tim sidining papase wari aming arantagim karesi kabi'mo' u dipminga abiging. Tim munumung sini' wa Abel u uking. Ningsa' tanga ababanga inga' Sekaraia ka Berekaia ning mindingni adi Anutuning kane tanga tempel iyung bane wara'ning iyung kabasi' nua'ni ka Anutuning iyung bane a Anutuga' ofa tangsangam wara'ning alta ning tanga bining wara'ganang unggung sini' ukumoging. Wara' mamareng girii ka tim papase wari dipminga abiging wara'ning guk ka sidi u uking wara'guk wara'ning mamareng wa sidasa' bemni'ga'. ");
INSERT INTO uvh_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Beng sini' torik aming arantagim karesi ka u dipminga abiging wara'ning mamareng girii wa aming arantagim ka kami i iking sidisa' bemnni'ga' ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Ka Jisas wari inga' Jerusalem yong girii wari kadaga waraga' sura nakedanga kaba mamareng naknga ning togu', o bibiri' sini' yong girii Jerusalem fikifiki gu Anutuning profet u dipmikumara ning tanga aming ka Anutu wari midi sangnatam ga' yangkareta' wa gu uningkim kwak wari dipmitang. Na kagare' meng wari nano u inagira fabanga firisi' kapmik dasinga munkupniap urang titing ningda'ning kafakafa sini' tasabotik ning tonga fatirik. Ka mokngang sidi kafakafa tasap ga' ninibi sa' mo' ting. ");
INSERT INTO uvh_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Wara' inga' wa yong girii Jerusalem gu wadigi' kadasasu'nanga kama sigesa' ubu ire'ga'. ");
INSERT INTO uvh_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Beng sini' sanirik sidi kami naganing nondakna ari' sini' nabing. Sidi narosi ningsa' tanga ira anganga inga' sini' ganangsa' napma ning nakedanga toni', o girii wari kafakafa tangama anigareinga adining tangkunang wara'guk beng sini' abara' ning toni' wara'ganang ga'sa' ikanting ning togu'. ");
INSERT INTO uvh_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Ka Jisas wari midi u ina ning tanga ibinga ning tanga siring yak girii tempel u kabinga kadofinga aramugogu'. Ka Jisas ananing arantagim wari siring yak girii wara'ning fuguni wa uningkim girisi tangkunasi karesi karesi warisa' tanga maging u kanga ning aniging, ai girii, yak girii ukaya' tangkunang karengsa' kayam. ");
INSERT INTO uvh_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Ka Jisas wari ning yanggu', beng guk sidi napa' tangkunang kareng sini' ning ba kanga toing. Ka beng guk sini' ning sanotik, uningkim tangkunasi karesi u yabing wa inga' aming wari kuma'sa' itataranga ipmasasu'neinga kamaganangsa' mangfasasu'nani'ga', uningkim kareng ka ni ka u garanga adeinga kaing ning guk mo' garanga adewa'ga' mokngang sini' ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Ning tanga anga Jisas adi kama bubo kabasi' Oliv u aranga merafagu'. Ka arantagimni wari anapmo'sa' mareiagu' u kanga o indi napa' fam ga' wa anapmo'sa' kuma' mareta' ning ganang anigantam ning tonga anga Jisas u ning anigaging, girii gam gu kamaganang i kabinga mautang ka inga' gu tubobu abe' wa kama yari wadigi' biwa' ning tongang. Ka wa kama wa nasi'ganang kadofo'ga', abanga nasi' kudi a tigigira wari tim kadofiinga kanga o kuma' dudurera' ning wa wara'ganang nakedanga tonam ning aniging. ");
INSERT INTO uvh_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Ka Jisas wari ning yanggu', i nakni' aming fam wari mandaga' siramakinga kama ka naga abubu wara'ning waraga' nafek ma tini' wara' sidi kafakafa suktangkanga ikanting. ");
INSERT INTO uvh_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Inga' aming kabi'mo' wari tim abanga mandaga' siramara naganing wap sige tonga ning tonga yarani'ga', na girii Kasira Aming urang wari tubobu kuma' abarik yang. Ning tuguinga aming wari u naknga bengsa' ba ning tonga iyawaksa' tini'ga'. ");
INSERT INTO uvh_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Beng sini' sidi aming wari ami' ka sidining du'ganang unggung tanga yarani' a kama kamani indeng u tanga yarani' wara'ning midi ne u naknga base tanga kabaksi' mamareng mo' nakni'. Mokngang, ami' a napa'napa' u tanga yarani' udi giri kadofo', ka wa kama wari bibi'ning ari' mo'. ");
INSERT INTO uvh_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Ka mamareng fam ka kamaganang yara'ni aming kabi'mo' wari marara aming arantagim girii nua'ni guk ami' a kama dibing nua'ni wari kama nua'ni guk ami' titi, abanga tugumung girii wari kadofinga yara a kining girii wari kagadofi ning tanga yaro'ga'. ");
INSERT INTO uvh_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Ka sidi mamareng ka u kadofinga yaro' u kanga wa ai, kama urang kuma' biwanga tara' ibanda' ning mo' sukni'. Mokngang, mamareng ka wa tim munumung kagadofi wara'ning ka taming wari saba ibeunga kagaya munumung sini' urang nakiting ningda'ning wari kadofo'ga'. ");
INSERT INTO uvh_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Ka wara'ning mandang ganang wa mamareng kabi'mo' fam ka ko kadofo' wa ning, aming wari sidita' bibi' naksama sinagira fonga aming fam ga' iminga adibu manggaksapma fonga kadagang siramira sidifikumak titi ning tini'ga'. Ning tanga aming kabi' kabi'mo' wari sidi naganing arantagim ikni' u sapma sidita' bibi'sini' naksamni'ga'. ");
INSERT INTO uvh_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Beng sini' kama ka wara'ganang wa aming kabi'mo' wari naga nibinga ning tanga nagata' naktangka guk mo' ubu tini'ga'. Ning tanga adi naktangka aming kuyase fam waraga' bibi' naknga yapguruda tanga adisining wapsi' wa digarapsi' ganang ituaimni'ga'. ");
INSERT INTO uvh_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Ning tinga aming ka midi togadofi profet mandaga' wari kadofinga ami taming u midi mandaga' fam ina yareinga adi u naknga bengsa' ba ning tonga waraga'sa' ubu nakni'ga'. ");
INSERT INTO uvh_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Ka kadapmang kadagang ka ningwara' wari kabi'mo' kadofinga yareinga aming ka nagata' naktangka tini' wari nagata' sasuk mimeng mo' ubu tini'ga'. ");
INSERT INTO uvh_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Beng sini' aming kabi'mo' adi kadapmang didimeng mo' ka ning u tini'ga'. Ka aming fam ka nagata' naktangka tanga kadapmang didimeng ganang tangkunang ningsa' ko ira ani' wa na yotangkayap tanga manggara kukyabinga kareng gi' giri ikni'. ");
INSERT INTO uvh_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Ka kama kadagang ka u kadofo' wa ari' mo'. Mokngang, aming arantagim nua'ni ka kamaganang indeng indeng ira yaring wara'siga' Anutuning bining ning midi kareng i bema ituaima yarasasu'neinga adi midi u dabiksa' naksasu'neinga wa giri kama yari bibi' wara'ning kama ari' wari kadofo' ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Ka Jisas wari midi ka u ina ning tanga ning nua'bu yanggu', kama kadagang ka u kadofo' wara'ganang wa napa' mumungguk kadagang sini' ka tim profet Daniel wari togu' wari kama ka Anutuning kama tapni sini' ning aniting wara'ganang kadofinga ikinga kani'ga'. (Kama tapni ka wa aming ka midi i yotik naga a Juda aming fam sidi midi i indangira wa kuma'sa' sura nakedating waraga' togu'.) ");
INSERT INTO uvh_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Ka napa' kadagang ka wari kadofiinga wa aming ka kama tubo Judia tara' ira yaring sidi bima tanga kama karang do marani'. ");
INSERT INTO uvh_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Ka napa' ka wari kadofo' ganang wa aming ka fugang marero' wari u kanga marara napa' ni bemnotik ning tonga yak iyung bane mo' amo', mokngang adi parap marara bimasa' tanga mawa'. ");
INSERT INTO uvh_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","A aming ka fening ganang kane fato' adi mamareng ka wari kadofiinga wa a saket anga bemnotik ning tonga yongganangga' tubobu mo' unara abo', mokngang adi bimasa' tanga mawa'. ");
INSERT INTO uvh_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Beng sini' kama ka wa kadagang sini' wari kadofo'ga'. Taming kabaksi' guk a taming ka saba munumung ibenga deiakni' wa bibiri' sini' adi mamareng waraga' tanga bima tanga mugoga' wa kane girii sini' tini'ga'. ");
INSERT INTO uvh_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Ka mamareng girii ka wa sibim ning kama a mengkura ning kama girii sabat wara'ganang ma kadofisamo'. Ning tinga sidi nasi' wari mukantam ning tonga ma tanga tini' wara' sidi Anutuga' ibang tuguinga mamareng ka wa kama sige ganang kadofisaminga sidi sia da'ning tanga mani'. ");
INSERT INTO uvh_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Beng sini' mamareng girii ka u kadofo' wa timinggi' Anutu wari kama i munumung sini' tugu' ganang ira ababanga kami yara'ganang wa mamareng girii ka ningwara' guk mo' kadofita' mokngang sini'. Abanga mamareng ka wari kuma' kadofinga biinga inga' ganang undu' ningwara' guk mo' kadofo'ga'. Mokngang mamareng ka wa kama ka wara'ganangsa' kadofo'ga'. ");
INSERT INTO uvh_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Ka mamareng girii ka wari kagadofi wa urap bibi' ning guk mokngang. Ka Anutu adi aming wari mamareng girii ka u kama paramu' bema ira au wara'ning tangkunang guk mokngang waraga' tanga adi pumpurum udaga waraga' kuma' sura kabigu'. Beng sini' Anutu adi aming arantagim ka anata' kuma' ifakasirinagu' waraga' tanga u yotangkayapma udaga tinga mamareng wa pumpurum da'ning kadofinga biwa' wang. ");
INSERT INTO uvh_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Ka mamareng wara'ning bining ganang ka aming fam wari ning saninga ai, Kasira Aming girii urang udi kuma' abara' yang, wa ma beng ka inga' do abara' wang ning tonga yarani' wa sidi bengsa' ba ning tonga mo' nakni'. ");
INSERT INTO uvh_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Beng sini' kama ka wara'ganang wa Kasira Aming mandaga' a profet mandaga' kabi'mo' wari kadofinga kane tangkunasi kuni' kuni' ka beng sini' da'ning tanga yarani'ga'. Ning tinga aming kabi'mo' wari u kanga iyawak sa' tini'ga'. Ka adisining kane tangkunang u kanga iwak titi ning wa aming arantagim sige warisa' mo' tini', mokngang aming ka bengsa' ba ning tonga kabi'sini' kuma' iyawak ga'sa' tini'ga'. ");
INSERT INTO uvh_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Ka na napa' wari ko mo' kadofiinga ganang tim ning sangnatamirik ka sidi waraga' suktangkanga ikianting. ");
INSERT INTO uvh_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","27","Ka Amingning Tim Iyak naga tubobu abubu wara'ning wa na kapmo'sa' abubu ning guk mokngang. Wara' aming nua'ni wari ning saninga ai, aming girii urang udi tubo do kuma' kadofinga tanga abara' wa ma kuma' kadofigu' ingging yang ning tuguinga wa sidi mo'sini' nakni', mokngang. Naga afufu wara'ning wa kadapmang nua'ni ka tifik girii da'ning urapsa' kadofiinga aming aming dabiksa' ka kamaganang ikiting adi u kanga urapsa' kuma' nakedani'ga'. ");
INSERT INTO uvh_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Ka sidi kuma'sa' naking, sidi yang mangambeng wari bak titing u yapma wa ning nakedanga tuguting, o napa' kubung ni unda' deita'. Ka Amingning Tim Iyak naga abubuning undu' ningsa'. Napa' kigineng girii ka tifik da'ning guk kadofok u kanga wa sidi nakeda sa' tanga ning toni', o Amingning Tim Iyak urang udi kuma' abara' wang ning toni' ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Ning tanga Jisas wari arantagimni u nua'bu yanggu', mamareng a kagaya girii ka u torik wari kadofinga biinga mayam de wari kangkamara tinga mayap undu' dada guk mo' to'. Ning tinga bam undu' mangfu tinga napa' tangkunasi fam ka kunimganang ikiting undu' kama gipmamsi' iik titing u ibinga kadapsa' mera mera yangakni'ga'. ");
INSERT INTO uvh_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Ka napa' napa' u tonga yararik wari kadofinga bisasu'neinga wara'ning ari'sini' wa aming wari kudi nua'ni ka kunimganang kuta kadofo' u kanga ning toni', o beng sini' Amingning Tim Iyak urang udi kuma' kadofonga tara' wang. Ning tonga aming kamaganangni dabiksa' wari mutu girii tanga adisining kadagang waraga' mamareng naknga mak kara yarani'ga'. Ning tanga napni' wa Amingning Tim Iyak naga kigineng girii guk ka wap girii guk mungkong bining ganang kuta arafok. ");
INSERT INTO uvh_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Ning tanga be girii wari tuguinga na naganing kunim aming arantagim u yangkareinga adi kama yara'ning kama kama dabiksa' u yangara aming karesi ka nagata' kuma' ifakasirinaguk u inagira fabanga nagata' namni'ga'. ");
INSERT INTO uvh_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Ka kama ari' wari kagadofi wara'ning kamaga wa sidi firi fam undu' kuma' yapkedating ningda'ning kadofonga to'ga'. Sidi firi wari sasa' afanga bidi' inga'ni kadofiinga wa sidi yapkeda sa' tanga o mayam ba dawata' ning tuguting. ");
INSERT INTO uvh_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Ka naga midi u tonga yararik wari kadofinga arayaro' u kanga wa sidi nakeda tanga ningsa' kigedanga toni'. ");
INSERT INTO uvh_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Ka ning sanotik, napa' ka u torik wa aming ka kami yara'ganang i iking adi fam ka ko mo' kumakni' ganang napa' wari kadofo' udi kuma'sa' kani'ga'. ");
INSERT INTO uvh_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Ka beng sini' torik, napa' tangkunang sini' ka kunim a kama wa kuma'sa' bisasu'no'. A naganing midi wa bibi' titining guk mokngang sini', wa fikifiki ko ningsa' ira awa'ga'. ");
INSERT INTO uvh_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Ka kama ka Amingning Tim Iyak naga tubobu afufu wara'ning wa aming ka ni wara'guk mo' nakedara' mokngang sini'. Kunim aming arantagim a Anutu ananing mindingni naga undu' wara'ning wara'guk mo' nakedarik, wa sibeng Anutu anapmo' kubaniksa' kama ka Amingning Tim Iyak naga tubobu afufu wara'ning u naknga ita'. ");
INSERT INTO uvh_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Ka kama ka naga afok wara'ganang wa aming kamaganangni adi suknafek sa' tanga kadapmang ka tim Noa wari yagu' u tanga ganang urang tiging ningsa' tini'ga'. ");
INSERT INTO uvh_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Tim Noa wari yagu' ganang wa ama gibung girii wari ko mo' kadofiinga aming arantagim adi ama gibung wari kadofiam wara'ning waraga' kabi'sini' guk mo' sura naknga kadapmang ka nana a napa' karesi tanga nanga iik a taming kafauwe titi ning tanga kugurang gi'sa' ikiaging. Tanga ira anganga Noa wari sip iyung bane ganang ibinga amoinga adi nakeda guk mo' tanga ningsa' ko yaging. ");
INSERT INTO uvh_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Ka inga' ama gibung girii wari kadofinga manggakyabinga wara'ganangsa' naknga iguk sa' areging. Ka Amingning Tim Iyak naga tubobu afok ganang undu' aming kamaganangni dabik adi kadapmang ka u tiging ningsa' tini'ga'. ");
INSERT INTO uvh_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Ka kama ka naga afok wara'ganang wa ning tok, aming fama' ka feng ganang fatademu' wa kubanik ka naga kuma' tipkasiranaguk unggungsa' bemnanga nua'ni wa unggung kabok. ");
INSERT INTO uvh_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","A taming fama' ka yongganang mera wit ka palawa titi waraga' mera fauninimbedemu' undu' na kubaniksa' bemnanga nua'ni wa unggung kagabi ning tanga yarok. ");
INSERT INTO uvh_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Beng sini' sidi sidining girisi' naga abubu wara'ning kama didimeng wara'guk mo' nakeding wara' sidi midi ka waraga' sura nakeda tanga sidining iiksi' u tugunung tanga ikanting. ");
INSERT INTO uvh_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Sidi kadapmang ka aming yak tuang wari midi ne ka kubu aming wari adining yongganang kagadofi wara'ning u kuma' naknga ka'sa' marerota' wa kubu aming wari kadofota' ganang wa adi marara iming u isefingamota' ning urang titing waraga' sukanting. ");
INSERT INTO uvh_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Ka sidindu' ningsa', kama ka sidi Amingning Tim Iyak naga abubuning guk mokngang ning kanga sidi sansaramik ikni' ganang ma kadofok wara' sidi tugunung tanga kaa'sa' iikning ningda'ning ikanting. ");
INSERT INTO uvh_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Ka na sidi naganing kane aming arantagim wara'ning kadapmang didimeng yaranga tanga iik waraga' wa ning sanotik, kane aming nua'ni ka aming girii wari adining kane aming arantagim u yaptatoranga tanga iik waraga' kamota'. Kamiinga yaptatoranga tanga ira kane aming wari nana ga' nafek tinga u yapma undu' adi nana wa urapsa' imota'. ");
INSERT INTO uvh_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Ka aming girini adi kama yong nua'ni mauta'. Ka adi tubobu abota' ganang wa aming ka kane aming arantagim yaptatora ga' u kamota' wari kane didimengsa' ning u tanga irota' u kanga wa aming girii adi aming ka waraga' kaba karengsa' nakngamota'. Ning tinga kane aming adindu' kaba karengsa' nakngamota'. ");
INSERT INTO uvh_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Beng sini' aming girini wari adining kadapmang kareng u kanga ning anota', kami naganing napa' napa' dabiksa' wa gusa' ubu yaptatorotang ning anota'. ");
INSERT INTO uvh_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","A kane aming kadagang adi ning guk mo' tota'. Mokngang adi a girina kuma' manga' adi tubobu urapmo' unda' abota' ning tonga suknakube sa' tanga ira kane aming u kafakafa mo' yaptatorota'. ");
INSERT INTO uvh_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Adi didipmi tanga kadagang iramira ibinga anga aming arantagim ka sansaramik tanga ama kagaya nasi' u topnanga papenga fatiangakasi wara'siguk tanga ikanting. ");
INSERT INTO uvh_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Adi kama ka girini wari tubobu abubu wara'ning wa paramu'sini' ko ba fidera' ning tonga waraga' kabi'guk mo' sura adi napa' sansaramik u fatiangarota' wara'ganang didimeng wa girini wari kadofota'. ");
INSERT INTO uvh_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Kadofinga ning tanga adining kadapmang kadagang u kanga bema kama kadagang sini' ka aming kadagasi ka girisi' ning kanega' guk mo' sukiting wari ikiting wara'ganang u kuragamainga adi kagaya girii sini' bema iyaga ningsa' tonga famindauta' ning titining ningda'ning kadofo'ga' ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Ka Jisas wari ana tubobu afufu waraga' midi nua'ni ka arantagimni u ning yanggu', Anutuning bining ning kane wara'ning kama ari' wara'ganang wa aming wari kadapmang ka ningda'ning tini'ga'. Wa ning, aming nua'ni wari taming kafauwe kaga' sini' tota' ka amine wari aming kafauwe tota' waraga' nana tangsana tanga kapmeikanting. Kapmera ning tanga taming sababa ten ning u yangkareinga aming u nagironga anting. Ka sababa adi kamangsi' lam u manggara ning tanga anga aming wari kafauwe u tanga biinga nagira abu waraga' kapmekanting. ");
INSERT INTO uvh_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","4","Ka taming ten ning wara'sining fam ka faiv ning adi sasuksi' kareng guk wara' adi kuma' nakedanga lamsi' wa karasin udi tagaktona sini' tinting, a faiv ning adi nakeda guk mo' tanga lamsi' wara'sining karasin wa king guk ningsa' manggaknanga manting. Anga ning tanga aming kafauwe titining u kapmefakanting. ");
INSERT INTO uvh_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Ka aming ka udi urap guk mo' abota' wara' taming adi sangkapmefafa' dasi' dama tanga dama mera fatinting. ");
INSERT INTO uvh_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Ka tiim bining sini' ganang aming fam wari ku ning kating kating abanting, ai aming ka taming kafauwe urang tanga' udi kuma' abara'. Sidi mamarak tanga abanga kabaksi' karengsa' nakngama kafakafa sini' tangama nagira ani'. ");
INSERT INTO uvh_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Ning tuguinga naknga taming adi marara kamangsi' diok dakungkumara tinting u kafakafa aratinting. ");
INSERT INTO uvh_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Ka taming faiv ka susuksi' guk mokngang wari adisining kamang udi kafakafa guk mo' danting u yapma taming amise faiv ning ka sasuksi' guk u ning yanting, ai aminese' indi kamang idi ama guk mokngang wara' sidi yotangkanip tanga sidining ama u kabi' tagaknimni'. ");
INSERT INTO uvh_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Ka taming ka sasuksi' guk adibu ning yangting, o mokngang indi karasin wa mimeng mo' manggaram indi lam ganang didimengsa' kuma' tagara manggaram wara' mokngang, mo' samtam. Sidi stoa ganang anga sidata' didimeng yapma tonanga tagaknani' ning yangting. ");
INSERT INTO uvh_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Ning tinga taming faiv ning ka karasinsi' guk mokngang wari karasin tononga kuma' marara mugoinga aming ka taming kafauwe tota' adi wara'ganang kadofota'. Ning tinga taming faiv ning ka amasi' guk unggung kapmeiakanting warisa' aming u nagira anga tangsana wara'ning yak ganang u amanga yak wara'ning faba u wadigi' isefitangkanting. ");
INSERT INTO uvh_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Ning tinga taming faiv ning ka amasi' guk mokngang adibu mandang inga'ga' anga kadofinga yak wara'ning faba u ura ku ning fakatinting, ai girii gu faba i abanga kadaknime'. ");
INSERT INTO uvh_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Ka aming girii ka taming kafauwe tota' wari iyung bane do adenga ning tafang inota', sidi nisi' na sidigok mo' sabitik. Ning tonga mo' kadakyamota'. Ka aming ka Anutuning bining kapmera tanga ikanting undu' kamaga fama' ka u torik ningda'ning tini'ga' ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Midi u ina ning tanga arantagimni u ning yanggu', ka sidindu' ningsa' sidi kama ka naga abubu wara'ning wara'guk mo' naking wara' tugunung ningda'ning tanga sasuk tangkunang ka naga tubobu abubuning wa ningsa' tanga ira anting. ");
INSERT INTO uvh_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Ka kama ka Anutuning bining wari sireng kadofisirendonga to' ganang wa kadapmang ka aming girii wari kane aming ga' kane iminga tinting ningda'ning wari kadofo'ga'. Wa ning, aming girii nua'ni wari kama kamani maunga kane aming fam wari adining kane u tanga iik waraga' adining uningkim mambong u kane aming famineng ga' udanga ima yarota'. ");
INSERT INTO uvh_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Ka aming girii adi kane aming kubanik kubanik wara'sining sasuk kareng a tangkunangsi' u yapma ning tanga uningkim mambong u wara'ganang udanga imota'. Nua'niga' wa faiv tausen kina ning amota' a nua'niga' wa tu tausen kina a nua'niga' wa wan tausen kina ning ima yarota'. Ning tanga ibinga mauta'. ");
INSERT INTO uvh_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Ka kane aming ka faiv tausen kina bemota' adi sasukni kareng guk wara' adi urapsa' anga faiv tausen kina u bemota' wari bisnis kane tanga faiv tausen kina nua'ni using nua'bu tipkadofota'. ");
INSERT INTO uvh_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Ka kane aming ka tu tausen kina bemota' adindu' ningsa' tota', adi anga tu tausen kina wari bisnis kane tanga tu tausen kina inga'ni using nua'bu tipkadofota'. ");
INSERT INTO uvh_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","A kane aming ka wan tausen kina bemota' wa mokngang. Adi uningkim mambong u bema anga kane ni guk mo' tota'. Adi aming girini ning uningkim girii tausen kina u bema tonga kamaganang unanga sebinga sige ningsa' fideuta'. ");
INSERT INTO uvh_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Ning tanga kama paramu' sini' ira anganga aming girii moni tuang wari tubobu abota'. Abanga ning tanga kane amingni wara'sining kanesi' u yapdidimonga katianinga adiganang anting. ");
INSERT INTO uvh_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Anga kadofinga kane aming ka faiv tausen kina bemota' wari aming girii u ning anota', girii tim gu faiv tausen kina urang namgung wa na kane tanga faiv tausen kina nua'ni nua'bu kuma' tipkadofigamguk yang. Ning tonga aming girii waraga' amota'. ");
INSERT INTO uvh_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Ka aming girii adi u kanga kaba karengsa' naknga ning anota', o gu kane aming kareng sini'. Na tim kane kabasi' gamguk ka gu didimengsa' kuma' tarang wara' na kami napa' girii katatora waraga' ubu gipmarik. Wara' gu nagok i abanga mesisiringa tanga marekdam ning anota'. ");
INSERT INTO uvh_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Ning tanga kane aming ka tu tausen kina amota' adibu anga aming girii u ning anota', girii tim gu nagata' tu tausen kina urang nama mugogung wa na uningkim mambong ka wari kane tanga tu tausen kina inga'ni nua'bu tipkadofigamirik i kaya'. Ning tonga bema tonga aming girii wara'ning kafong ganang amota'. ");
INSERT INTO uvh_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Ka aming girii wari ning anota', o gu kane aming kareng sini'. Tim guta' kane kabasi' gamguk ka gu didimengsa' kuma' tarang wara' na kami napa' girii katatora waraga' ubu bema gipmarik wara' gu nagok i abanga mesisiringa kubap tanga marekdam ning inota'. ");
INSERT INTO uvh_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Ka mandang ari' sini' wa aming ka uningkim mambong ka wan tausen kina ning amota' wari anga aming girii ganang u kadofinga aming girii u ning anota', girii na gu kuma'sa' gabitik gu aming kagaya. Nana a napa' karesi fam ka gu tanga nanga ikitang wa gu ganing tangkunang ganangsa' mo' tanga ikitang. Mokngang gu aming nua'ni wari tanga ifikadofigaminga manggakna sa' titang. ");
INSERT INTO uvh_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Gu kadapmang ka ning u titang waraga' tanga na mutu tanga gu uningkim mambong wan tausen kina ka kane titiga' ning tonga namgung wa na sige ma biwa' ning tonga bema tonga kamaganang unafarafinga sebinga gi' giri fidegamita'. Ka i kaya' na guning mambong ya kami gata' didimeng tubobu gamirik yang ning tonga amota'. ");
INSERT INTO uvh_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Ka aming girii wari u kanga aming ka u ning anota', a gu kane aming kadagang didirimang beng sini'. Gu aming nua'ni ning tangkunang ganangsa' tanga ikitik ning ba nabitang. ");
INSERT INTO uvh_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","A, gu naganing uningkim mambong idi sige ba sebinga fideta'. Gu tim bengk ganang kamonga tugung wa uningkim wari girii giragainga kami naga i kadofarik ning ganang wa beng guk bimbem ning, ka naga' tanga gu sige guk tonga sebinga fideta'. ");
INSERT INTO uvh_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Ning kafang aning aninga ning tanga kane aming fam u ning inota', sidi uningkim mambong wan tausen kina adining kafong ganang do anga iromkadara bema tabanga aming ka ten tausen kina guk waraga' amini'. ");
INSERT INTO uvh_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Beng sini' aming ka naga napa' kareng kuma' amiinga kafakafa tota' wa na fam nua'bu amiinga adi naganing napa' wara'ning kangasi sini' irota'. A aming ka naga napa' karesi kuma' amiinga kafakafa guk mo' tinga kabisira tota' wa na napa' kabi'sini' ka u tubobu irombemnainga adi tatafak sini' ubu ira auta'. ");
INSERT INTO uvh_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ning tanga adining kane aming karesi u ning inota', sidi kane aming kadagang ka napa' ni guk mo' tipkadofira' ya bimbem tini'. Bema fugang do kurakamainga adi kama gaa' kangkam ganang u ira kagaya ningsa' mindinga ira awa', ning inota' ningda'ning to'ga' ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Ka Jisas wari arantagimni u ning yanggu', inga' Amingning Tim Iyak naga aming girii ira tangkunang girii guk irok ganang naganing ensel arantagim guk tubobu afanga aming girii king ning tare ganang marekinga ");
INSERT INTO uvh_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","aming kamaganangni dabiksa' wari nagaganang bak abanga kukni'ga'. Ning tinga nagasa' yapma tagagareyapma arantagim fama' ning kidayabok, aming ka maga sipsip yaptatoreting wari sipsipsa' ka tubo a meme'sa' ka tubo ning urang tagagarenga tarayabiting ningda'ning tanga ");
INSERT INTO uvh_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","sipsipsa' wa kafana kareng tara' tarayabok a meme'sa' wa kafana kesini tara' tarayabok. ");
INSERT INTO uvh_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Ning tanga king nagasa' sipsip arantagim ka kafana kareng ganang tara' wa ning inok, sidi naganing sibeng ning arantagim wara' gi' iking. Timinggi' timinggi' sini' kama kunim wari ko mo' kadofigu' ganang sidi naganing bining kareng ganang iik waraga' kuma' sura tugunungnanga kabisamguk wara'ganang abanga ira kareng gi' ningsa' ikni'. ");
INSERT INTO uvh_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Tim naga nana ga' sekna niinga wa sidi nana namging. A ama ga' mana pamparangeinga sidisa' namging. Abanga na aming yong kamanini ka na sidining yongganang u kadofiinga wa sidi ninagik tanga tonga sidining yak ganang nipminga kafakafa tanap ning tiging. ");
INSERT INTO uvh_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Abanga naga nip ga' nafek tinga wa nip undu' sidisa' naminga tamguk. A naga bagana tinga undu' sidisa' naptatoreging. A naga kalabus kane tanga yainga undu' sidisa' abanga fanabiaging ning inokga' girii naga. ");
INSERT INTO uvh_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Ka aming didimesi arantagim ka kafana kareng ganang tara' adeni' wari naning midi ka u naknga ning toni', ai girii napa' ka nana yotangkagap a ama kaa' tagakam ");
INSERT INTO uvh_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","a kama kamanini ning abuinga ginagira tonga gigipmi a bi'sa' marekinga bibiri' gapma nip tabanga tamgam ");
INSERT INTO uvh_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","a bagana tinga yotangkagap titi a kalabus tinga angagap titi ning wa dari tagamgum waraga' torang indi napa' ka u tonga yararang wara'guk mo' nakedem. ");
INSERT INTO uvh_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Ka girii nagabu ning inok, beng guk sini' sidi nakeda guk mo' ting. Ka na ning sanotik, sidi tim aming sige ni ka napa'ga' nafek tinga kafakafa ka u tonga yararik ningwara' u tiamging wa sidi nagata' beng sini' tanamging. ");
INSERT INTO uvh_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Ning ina ning tanga aming arantagim ka kafana kesini ganang tara' tarayabok wa ning inok, a arantagim ka sidi wa kadasasu'na titi wara'ningsa' wari adeing. Sidi ninibi tanga kudip kadagang ganang mani'. Kudip kadagang ka wa Anutu wari aming kadagang Setan wara'guk ka adining ensel kadagasi arantagim guk wari kudip ka wara'ganang mugo waraga' kuma' tugunungnanga kabigu' wara'ning. ");
INSERT INTO uvh_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Aming ka sidi tim na sekna nakinga wa sidi nana guk mo' namging. A naga ama ga' mana pamparangeinga wa sidi ama kaa' kabi'guk mo' tagaknamging. ");
INSERT INTO uvh_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","A naga aming yong kamanini ning abuinga wa sidi kabi'guk mo' nanagira tonga nipmiging. Abanga naganing nip a kwi' wari damiriknam tinga undu' sidi nip a kwi' ni guk mo' namging. A na bagana tuguk undu' sidi yotangkanap guk mo' tiging. Abanga na kalabus ganang yaguk wa sidi anganap tanga yotangkanap guk mo' tiging. ");
INSERT INTO uvh_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Naga midi ka ning ininga aming arantagim ka wari ning nangni'ga', ai girii indi gu seka ninak a ama ga' maga pamparanga a gu aming yong kamanini ning abubu a kwi'ga' nafek titi a bagana agik a kalabus kane ganang iik ning tinga yotangkagap guk mo titi ning guk wa indeng tugum waraga' torang. Gu napa' mamareng ka u tonga yararang ningwara'guk tonga tugung ganang wa indi kuma'sa' yotangkagamianam. ");
INSERT INTO uvh_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Ka girii naga ning inokga', beng guk sini' sanirik tim aming tatafak sige fam ka naganing arantagim wari napa'ga' nafek ka u tonga yararik ning u tiging ka sidi kuma' yapma yotangkayap kabi'guk mo' tiging wa sidi nagata' bibi naknamging. ");
INSERT INTO uvh_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Ning ina ning tanga kama naro' sini' yangkagareinga adi kama ka wara'ganang anga ira fikifiki kagaya ningsa' bema ira ani'ga'. Ning tinga arantagim ka aming didimesi adi yong kareng ganang anga kafakafa gi' ningsa' ira ani'ga' ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Ka Jisas wari midi ka u ina ning tanga biinga ananing arantagimni u ning yanggu, ");
INSERT INTO uvh_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","sidi kuma'sa' naking kama fama'sa' ibinga wa sande girii ka Pasova wari kadofota'. Ka kama ka wara'ganang wa aming wari Amingning Tim Iyak naga bemnapma tonga aming fam ning kafasi'ganang iminga adibu firi ganang ugarinapni'ga' ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Ka Juda ning pris girisi a sasuk aming wara'siguk wari pris arantagim ning girisi' wapni Kaiafas wara'ning yak ganang anga bak tiging. ");
INSERT INTO uvh_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Adi bak u tanga kadapmang ka Jisas u mandaga' taramira bema tonga ugumak titi wara'ning waraga' tonga naking. ");
INSERT INTO uvh_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Ning tanga ning toging, indi napa' u tonga wa sande girii ganang mo' tantam. Indi sande girii ganang tantam wa aming kabi'mo' wari fam ka indi yotangkanim a fam ka indita' bibi' naknim ning tanga anasa' midi ganggarang tonga arok tinga Rom ning gavman wari adisigok ami'ga' ba tonga tem ning tonga indita' bibi' ma naknimo' ning toging. ");
INSERT INTO uvh_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Ka Jisas wari yong kabasi' Betani u anga kadofinga aming nua'ni wapni Saimon adining yak ganang amanga mareiagu'. Aming ka wa tim bagana kadagang lepa guk yagu' adining yak ganang amanga nana mera nagu'. ");
INSERT INTO uvh_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Ka taming nua'ni wari Jisas ga' naknga kafakafa sini' tangamonga wel sanda mupmu guk karengsa' u bema tabanga ning tanga Jisas ning ki ganang tagakngamgu'. Sanda ka wara'ning mupmuni wa kareng sini' wara' uningkimni toni wa girii sini' a sanda wara'ning kandang wa uningkim diding guk kareng wari tiging u bema tabanga tagakngamgu'. ");
INSERT INTO uvh_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Ka arantagimni adi u kanga goi tiging. Ning toging, ai indi napa' tangkunang ka uningkim mambong girii warisa' to ning ningwara' wa sige guk mo' kwasinetam. ");
INSERT INTO uvh_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Ka adi sanda kareng wa sige guk udi beng wa kwasinara'. Adi sanda u aming fam ga' ima uningkim mambong bema tatafak aming yotangkayap ga' wa adi sige ba kwasinara' ning toging. ");
INSERT INTO uvh_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Ka Jisas adi arantagimni wari goi tiging u kuma' yapma ning yanggu', a sidi taming wa mimeng mo' kanga tonting. Adi napa' u tanamara' wa napa' kareng sini' tanamara'. ");
INSERT INTO uvh_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Sidi tatafak aming ga' toing wa sidi ning nakni', adi sidigok ingging kama paramu' ko ikanting wara' sidi u yotangkayap ga' sura wa kuma'sa' yotangkayap ning. A na ya kama paramu' mo' irotik. Na inga' ingging kuma' sibinga mautik wara' na ning torik, adi kadapmang didimeng giri tara'. ");
INSERT INTO uvh_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Taming wari naganing fukna ganang wel sanda tagaknamara' wa inga' naga kungkumak tinga wel u fukna ganang ning tagara sufurunama yarani' wara'ning kamaga tanamara'. ");
INSERT INTO uvh_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Beng guk sini' ning sanotik, inga' aming wari kama kama yangara naganing midi kareng u ituanga yarani' ganang wa kami taming wari i tanamara' yaraga' undu' kuma'sa' toni'ga'. Ning tinga aming wari u naknga waraga' suktangkanga ikni'ga' ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Ning tanga Jisas ning arantagim 12 wara'ning nua'ni ka wapni Judas Iskariot wari Juda ning pris girisi arantagim wara'ganang anga ning yanggu', ");
INSERT INTO uvh_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","na Jisas u bemsamotik. Ka sidi waraga' uningkim mambong wa indining tonapmanting ga'. Ning tinga aming girisi wari adining midi u naknga aigangam tanga uningkim mambong silva ka 30 ning u indangira bema Judas ga' amiging. ");
INSERT INTO uvh_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Ka Judas adi uningkim mambong u bema ning tanga anga kadapmang ka Jisas u bema tonga aming girisi ning kafasi'ganang iminga uuk u katua waraga' sasuk mimeng aratugu'. ");
INSERT INTO uvh_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Ka Juda aming ning tangsana girii ka wapni Pasova ning tonga tiaging wara'ning tugunung titi ning kama munumung sini' udi kuma' kadofigu'. Ka Jisas ning arantagim wari Jisas ganang anga ning aniging, girii, Pasova nana ning kama kuma' dudurera' ka gu indi nana wa indeng mera nana ga' sutang. ");
INSERT INTO uvh_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Ka Jisas wari Jerusalem yong girini aming nua'ni wara'ning wap u ina ning yanggu, sidi yong girii do anga aming ka wara'ning yak ganang anga ning aninting, girii udi ning tora' naganing kama kuma' dudurera' wara' na kami naganing arantagim guk guning yak ganang nana Pasova u tanga nantam ning tora' ning aninting. Ning ina yangkaregu'. ");
INSERT INTO uvh_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Ning tinga arantagimni adi Jisas ning midi u naknga anga napa' ka Jisas wari yanggu' wara'ganang didimengsa' yaranga tiging. ");
INSERT INTO uvh_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Ka arantagimni wari nana u tugunungnasasu'nanga kabinga ning tanga kibiri ganang Jisas guk ka arantagimni 12 wara'guk dabiksa' wari yak ka wara'ganang amanga tangsana wap Pasova u mera naging. ");
INSERT INTO uvh_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Ka adi nana u mera naging ganang ka Jisas wari midi ning yanggu', beng guk sini' sanirik sidining nua'ni wari aming wari nifikadaga titi waraga' kuma' nifikadofara'. ");
INSERT INTO uvh_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Ka Jisas ning arantagim wari midi ka u naknga ai, kadapmang ka ning wa ni' wari tara' waraga' tora' ning tonga kabaksi' mamareng sini' naknga kubanik kubanik wari Jisas u ai, girii naga wa ma nisi' torang ning aniganga yareging. ");
INSERT INTO uvh_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Ka Jisas wari ning yanggu', beng guk sini' sanirik aming ka nagok gafa kubaniksa' ganang mera araniamuk anasa' wa u nifikadofara'. ");
INSERT INTO uvh_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Ka midi ka Amingning Tim Iyak wari kungkumak wara'ning wa tim umpang ganang kuma' yoking fideta' wara' na u tatarafik ning guk mokngang, kungkumaksa' totik. Ka aming ka nifikadofi tara' waraga' wa ning torik, bibiri' sini' adi mengni wari mo' ibeunga tugu' wa adi kadagang girii ka naga nifikadofi ning u tara' wari mo' tipkadaro'. Wara' ning torik, adi kadapmang ka naga nifikadofi ning u tara' wa napa' kadagang sini' tara'. ");
INSERT INTO uvh_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Ka aming tipkadofi titining ka Judas wari ning togu', ai tisa gu nagata' sura torang wa. Ka Jisas wari ning anigu', gasa' kuma torang una. ");
INSERT INTO uvh_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Ning tanga nana u ko mera naging ganang ka Jisas wari nana kafo baret u bema ning tanga beni Anutuga' ibang asekna ning tonga upma arantagimni ga' ima yaregu'. Ima ning tanga ning yanggu', sidi baret ka i bema nani' ya naganing fukna gom u samarik. ");
INSERT INTO uvh_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Ning tanga wain ama kap ganang ubu tagara bema Anutuga' ibang asekna ning u nua'bu tonga ning tanga arantagimni ga' ima ning yanggu', sidi dabiksa' ama i bema topnani'. ");
INSERT INTO uvh_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Ama ka ya naganing fukna amaa u samarik. Amaa ka ya Anutu wari ami taming kabi'mo' wara'sining kadagang u tanga igukiama suknakubeyam waraga' totangkagu' u tiptangka waraga' naga nukinga amaana kwasinara' wara'ning u samarik. ");
INSERT INTO uvh_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Beng sini' torik na ama i topnem ya sidigok nanga abutam wara'ning ari' mera topnem. Na sidigok nua'bu guk mo' topnantam, inga' sibeng Anutuning bining kareng ganang wa sidigok dabik nua'bu mera wain ama inga'ni kuni' nua'ni u topnanam waraga'sa' irotik. ");
INSERT INTO uvh_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Ning ina ning tanga siring nua'ni tonga biinga fugang kadofinga amanga yak ka u kabinga kama bubo kabasi' Oliv waraga' mugoging. ");
INSERT INTO uvh_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Ka Jisas guk ka arantagimni guk wari kama bubo kabasi' Oliv u kuma' anga kadofinga ning tanga Jisas wari arantagimni u ning yanggu', beng sini' sanirik kami tiim yara'ganangsa' wa napa' mamareng nua'ni wari nagaganang kadofota' waraga'sa' tanga wa sidi sidining naktangkasi' u kabisasu'nanting ga'. Ka napa' ka u kadofota' waraga' wa Anutuning midi tim ning kuma' yoking, na sipsip tuang u ugumakinga sipsipni wari sansaramik bimanga papusinanga manting ning yoking. Wara' Anutu adi wara'ganangsa' yaranga tinga kadofota'. ");
INSERT INTO uvh_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Ka na Anutu wari tubobu kuma' nifimarakinga tim anga kama tubo Galili do anga sipmerokga'. ");
INSERT INTO uvh_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Ka Pita wari Jisas ning midi u naknga Jisas u ning anigu', girii, beng guk sini' torik arantagim fam wari gibisasu'na udep tinting wa na gigibi guk mo' totikga', mokngang sini' na gugok tangkunang ningsa' adentamuk ga'. ");
INSERT INTO uvh_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Ka Jisas wari ning anigu', Pita sireng ning ganotik kami tiim yara'ganang ka kagare' wari ku ko mo' katinga ganang wa gu naganing wap u famineng ning sini' isasebeutang ga'. ");
INSERT INTO uvh_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Ka Pita wari ning anigu', girii beng guk sini' urang torik na isisebe guk mo'sini' totikga'. Adi nanuk tonga tinga undu' na mutu tanga isisebe kabi'guk mo' totikga'. Pita wari ning tuguinga arantagimni fam adindu' ningsa' tonga yareging. ");
INSERT INTO uvh_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Ning tanga Jisas wari arantagimni u inagira gwaya kabasi' bingking kareng ka wapni Getsemani ning aniaging waraga' aging. Anga kadofinga arantagimni u ning yanggu', sidi ingging nipmeiakni'. Na dota' anga sibeng Anutuga' ibang toutik. ");
INSERT INTO uvh_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Ning ina ning tanga arantagimni famineng ka Pita guk ka Sebedi ning mindine fama' wara'siguk ungungsa' inagira anagok kubap aging. Anga ning tanga Jisas wari kaba mamareng girii sini' naku'. ");
INSERT INTO uvh_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Ning tanga Jisas wari arantagimni famineng u ning yanggu', na kabakna mamareng girii sini' nakarik wari tanga kungkumak titining sa' nakarik. Ka sidi naga yotangkanama ingging ka' ningsa' marekni'. ");
INSERT INTO uvh_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Ning ina ning tanga ibinga kabi'ning anga kamaganang manga mungkupnanga Anutuga' ibang ning togu', o sibeng gu napa' yari nagaganang mo' kadofinamning ning udep karang wa usefinam te'. Ka naganing sasuk mo', ganing sasuksa' yaranga totang ning togu'. ");
INSERT INTO uvh_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Ning tonga biinga tubobu agu'. Anga yapku' ka arantagimni famineng udi dasi' dama tanga dama defaging. U yapma Pita u ning anigu', ai indining, sidi naga yotangkanama ka' kabi'sini' marek ning guk mokngang ba. ");
INSERT INTO uvh_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Sidi ka'sa' marekni', napa' sansaramik titining wari kadofinga siramakinga kadaga ma tini' wara' sidi ka'sa' mera ibang tangkunang toni'. Beng sini' kabaksi' wa napa' kareng titining sa' ka fuksi' warisa' baraganeng naking ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Ning ina ning tanga Jisas adi kabi'ning nua'bu ibinga anga ibang ning togu', o sibeng gu naga mamareng i tatarafik ning kadapmang guk mokngang, bimbem titi ningsa' udep karang undu' ganing sasuk unggungsa' yaranga kadofinaminga bemotik. ");
INSERT INTO uvh_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Ibang u tonga biinga ning tanga tubobu abugu'. Abanga yapku' ka arantagimni famineng udi dama mera fatiging. Adi ka' marek ning guk mokngang fuksi' baraganeng sini' naknga damasa' mera fatiging. ");
INSERT INTO uvh_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Ka Jisas adi u yapma ningsa' ibinga tubobu anga ibang ka tim kuma' togu' unggung gipmam guk ningsa' nua'bu togu'. ");
INSERT INTO uvh_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Jisas wari ibang u tonga biinga tubobu abanga arantagimni u ning yanggu', ai sidi mengkura kafakafa sini' tanga dama ba defaking. I nakni' aming wari Amingning Tim Iyak naga bemnapma tonga aming kadagasi arantagim nua'ni wara'sining kafasi'ganang nipminting. ");
INSERT INTO uvh_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Ka mamarak tini', aming ka nifikadofi titining udi kuma' dudurera' u anga kantam ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Ka Jisas wari arantagimni fam u midi ka u ko araininga ananing arantagimni nua'ni ka Judas wari aming arantagim girii ka bimbem titiga' u inagira abanga Jisas ganang u kadofiging. Ka aming arantagim ka u abiging wa Juda arantagim ning pris girisi a sasuk aming wari yangkareinga bainat a kwak u manggara suronga abiging. ");
INSERT INTO uvh_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Ka tim aming kadagang Judas wari ning kuma' yanggu', aming ka naga tutu' yokngamotik u kanga, a urang udi uba ning tonga anga wara'ganangsa' bemting. ");
INSERT INTO uvh_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Adi midi ning kuma' ina ning tanga inagira agu', Wara' Judas wari Jisas ganang u kadofinga ai gu ni', girii wa' ning tonga bedirik tanga tutu' yokngamgu'. ");
INSERT INTO uvh_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Ka Jisas wari u kanga ning anigu', amina napa' u tonga abarang wa kami kaga' urapsa' te'. Ning aninga tanga aratinga aming arantagim wari wara'ganang kigedanga anga Jisas u bemging. ");
INSERT INTO uvh_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Ning tinga Jisas ning arantagim nua'ni wari Jisas bemging u kanga kaba kadagang naknga adining bainat u weng bema Juda ning pris arantagim ning tim iyak wara'ning kane aming slev u uuk ga' ning tonga tanga adining magi tubo u gufadagagu'. ");
INSERT INTO uvh_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Ka Jisas wari u kanga ning anisefigu', ai gu ning guk mo' totang kagabi te', bainat wa yorini ganang tubobu dase'. Beng sini' kadapmang ka ami' ka kafasi' wari titiga'sa' nakiting wa ami' wara'ganang sigesa' kumara napa' kareng ni tipkadofi ning guk mokngang. ");
INSERT INTO uvh_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Gu naganing tangkunang wara'guk mo' nakedanga tarang. Na sibeng katinganinga adi naga yotangkanap waraga' adining kunim aming arantagim kabi' kabi'mo' ka nambani girii sini' udi kuma'sa' yangkaranam ning. ");
INSERT INTO uvh_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Ka mokngang na ning guk mo' totik. Na naganing kane ning kadapmangni wa Anutuning midi umpang ganang kuma' yoking unggungsa' yaranga totik wara' na kadapmang nua'ni naganing sasuk ganangsa' nua'bu guk mo' totik ning togu'. ");
INSERT INTO uvh_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Ning tanga Jisas wari aming arantagim ka bimbem tiging u ning ifang yanggu', ai indining. Sidi naga ya aming kadagang titining ning ba nabing wara' sidi nanuk tonga kwak a bainat tanga maraknaming. Na fikifiki siring yak ganang amanga ami taming inggera fiaretik ka sidi bemnap ga' naknga wa ning ganang kuma' bemnabonga tiging. Ka sidi kamisa' wa indining tanga tiim guk abanga bemnabing. ");
INSERT INTO uvh_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Ka sidi kadapmang ka i tanabing ya midi ka tim profet arantagim wari yoking wara'ganang didimeng yaranga tanabing ning yanggu'. Ning tinga Jisas ananing arantagim dabiksa' adi mamareng u kadofiamonga tugu' u kanga mutu tanga bima tanga kabinga mugo tiging. ");
INSERT INTO uvh_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Ning tanga aming arantagim ka Jisas bemging wari Jisas u nagira pris ning girisi' wapni Kaiafas adining yongganang ga' aging. Ka yak ka wara'ganang wa Juda ning sasuk aming a aming girisi arantagim wari bak girii kuma' tanga ipmefaging waraga' nagira aging. ");
INSERT INTO uvh_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Ka Pita adi bima sini' mo' tugu'. Adi mandang ira unggung iwara iwara famugogu'. Anganga yongganang u kadofinga aming ka Jisas bema aging wari Jisas u nagira yak iyung bane amoinga Pita adi iyung bane sini' mo' amogu'. Adi yak wara'ning sinim ganangsa' amogu'. Ka Pita adi nasi' nasi' kadapmang ka aming wari Jisas taramikonga tiging u kadidima waraga' sura amanga ami'ning aming arantagim wari merafaging wara'siguk mera fonga fiapku'. ");
INSERT INTO uvh_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Ka pris girisi a aming midi nakdidima ning kaunsil girii arantagim wari Jisas u ugumak titiga' sura nasi' midi kadagang ni animbenga wara'ganang ukantam sam ning tonga aming kabi'mo' wari Jisas u midi mandaga' animbeging u mera fanakdidimaimging. ");
INSERT INTO uvh_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Ka mokngang, adi Jisas ning kadagang kabi'sini' guk mo' katuaging. Ka inga' aming fama' wari marara ");
INSERT INTO uvh_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","ning togumu', adi kadagang nua'ni ka midi ka ning togu' nakum, na Anutuning siring yak girii tempel i kwetatarasasu'nanga tubobu tipmarak ning kane wa kama famineng ganangsa' tanga tipmararok ga' ning togu' ning togumu'. ");
INSERT INTO uvh_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Ka pris girii tim iyak Kaiafas wari aming fama' ning midi u naknga Jisas u ning anigagu', ai gu midi ka u toyamu' wara'ning tubobu guk mo' ba toutang. ");
INSERT INTO uvh_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Ka Jisas adi midi tubobu guk mo' anigu'. Adi mini isefinga midi map da'ning ade sa' tugu'. Ka pris girii wari nua'bu anigu', ai Anutu girii ka' iyak guk wara'ning wap ganang beng guk sini' ning gangkarik gu midi beng guksa' nine'. Ma' gu Anutuning mindingni Kasira Aming beng sini' wa. ");
INSERT INTO uvh_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Ka Jisas wari ning anigu', ga kuma' torang una. Ka beng sini' ning sanotik kami a inga' undu' Amingning Tim Iyak wari Anutu girii ning kafong kareng ganang marekarota' u kanga a inga' adi mungkong fafa'ganang mera arafo' u kanga ning tini'ga'. ");
INSERT INTO uvh_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Ka pris girii adi Jisas ning midi u naknga kaba kadagang sini' naknga bane giptanga ananing kwi' kangkama u ibaramara midi tangkunang sini' ning togu', ai napa' girii sini' ka adi Anutuning wap anikigera nakem. Indi adining kadagang waraga' aming nua'bu mo' yangkantam, midi kadagang wa ana sirengsa' kuma' tora' u nakni'. ");
INSERT INTO uvh_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Ka sidi wa indining suking. Ka aming arantagim wari ning katiging, a wa kadagang girii tara', ugumak titi wara'ning. ");
INSERT INTO uvh_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Ning tonga Jisas ning nonda u iguk sombara ning tanga fangi upapeging. ");
INSERT INTO uvh_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Ura ning tanga midi ning animbeging, a gu Kasira Aming girii ba. Gu aming Anutuning midi kapmo' udi beng guksa' ba tokadofitang. Ningwara' gu aming ka guguk ting wara'sining wapsi' u bengsa' toya' ning aninga yareging. ");
INSERT INTO uvh_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Ka Pita adi yak wara'ning fugang ganang fidegu'. Ka pris girii ning kunung taming nua'ni ka adining yak wara'ganang kane tarugu' wari Pita u abanga katuanga ning anigu', a gu udi kuma' gabarik Jisas Galilini adining amingni wari merafatang. ");
INSERT INTO uvh_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Ka Pita adi isisebe tanga ning togu', a na midi ka u torang wara'ning ki guk mo' nakarik. Ning u sirengsa' tuguinga aming ka unggung mareking adindu' kuma'sa' naking. ");
INSERT INTO uvh_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Ka Pita adi midi u tonga ning tanga anga yak wara'ning sinim ning iming ganang ubu afanga adegu'. Ning tinga kunung taming nua'ni adibu kanga aming arantagim ka kwang mareiaging u ning yanggu', ai i kani' aming ka idi Jisas Nasaretni guk kubap fengating u fagatik. ");
INSERT INTO uvh_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Ka Pita adi isisebe nua'ni tanga ifak tangkunang sini' tanga aming wari adining midi u naknga bengsa' ba ning tonga tutugu waraga' ning togu', beng guk sini' urang sanirik na aming ka u toing wara'guk mo'sini' katik. ");
INSERT INTO uvh_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Ning tanga kabi'ning adeia' aming fam ka unggung adeiangaging wari abanga bak tanga Pita u ning tiringa aniging, a beng guk sini' gu udi kuma' gapkedem gu adining arantagim nua'nu wari fadeiantang. Indi guning banaka ka Galili aming wari tipfaranga tuguting ning sini' torang udi kuma' nakedem. ");
INSERT INTO uvh_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Ka Pita wari isisebe tangkunang sini' nua'bu tanga Anutuning wap guk tonga ning togu', beng guk sini' kuta urang sanirik na aming ka wara'guk mo' sini' katik. Ning ina ning tanga naku' wa kagare' wari ku katigu'. ");
INSERT INTO uvh_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Ka Pita adi kagare' ku u naknga ning tanga midi ka tim Jisas wari Pita gu naganing wap kagare' wari ku ko mo' katinga ganang famineng sini' ning isisebeutangga' ning anigu' waraga' tubobu suknatama ning tanga yak ning sinim iyung u kabinga fugang amanga adining kadagang waraga' sura kaba mamareng girii naknga mak fidenga fukogu'. ");
INSERT INTO uvh_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Ka Jisas u pris girii tim iyak ning yak ganang unggung ningsa' kaminga katatoranga kama wari fasanganda tinga Juda ning pris a aming girisi arantagim wari Jisas u ugumak titiga' midi totangka tiging. ");
INSERT INTO uvh_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Adi midi u totangkanga ning tanga Jisas ning kafong u iptanga nagira tonga Romni kiap girii wapni Pailat adining kafong ganang ubu kamiging. ");
INSERT INTO uvh_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Ka aming kadagang Judas adi aming girisi wari midi ka Jisas u ugumak titi waraga' totangkaging u naknga tubobu sura tipfaranga o na kadapmang kadagang ba tangak ning tonga kaba mamareng naknga moni silva 30 ning amiinga manggegu' u pris a aming girisi wara'siga' tubobu fonga yamgu'. ");
INSERT INTO uvh_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Ka adi moni u ima ning tanga ning yanggu', na aming ka kadagang kabi'guk mo' tanga' u sigesa' tipkadofisaminga sidi ugumak titiga' toing wa na kadagang girii sini' tangak wara' na uningkim i tubobu fabanga samirik. Ka aming girisi arantagim adi adining midi u nakngam guk mo' tanga ning aniging, a wa indining napa' mo', gasa' kuma' tangang. ");
INSERT INTO uvh_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Ka Judas adi moni u wadigi' imotik ning tonga agu' wara' adi aming girisi ning midi u naknga bibi' naknga moni u siring yak girii wara'ning iyung bane ganang unggung u kura igukyama ning tanga kadofinga mugo tugu'. Anga anasa' ananing fugu ura bidanga amanga kungkumak tugu'. ");
INSERT INTO uvh_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Ka pris girisi adi Judas wari moni kura igukyamgu' u manggara ning toging, moni ka ya aming ugumak wara'ning amaa to wara'ning bingi kuma' tanga' wara' tapni guk. Ka indi Anutuning siring yakganang i mo' kamintam. ");
INSERT INTO uvh_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Ning tonga midi tonga naknga iging moni u bema anga kama dibing ka tim aming nua'ni wari kabak mera fagararugu' u tonga bemging. Ning tanga ning toging, kama ka i toyam ya aming yong kamanini wari abanga kumakinga unafarafiap wara'ningsa' itarota'. ");
INSERT INTO uvh_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Ka adi kadapmang ka ning u tiging wara' kama wara'ning wapni wa aming ning amaa to ning u ko anitam. ");
INSERT INTO uvh_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Ka adi kadapmang ka kama to ning u tiging waraga' wa tim profet Jeremaia wari ning kuma' togu', adi moni silva 30 ning ka Isrel aming wari aming to ga' kamiging u beming. ");
INSERT INTO uvh_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Bema anga midi ka girii wari nanggu', u yaranga aming ka kabak fagarita' wara'ning kama dibing u toing, ning tuguinga yoking wari beng guk kadofigu'. ");
INSERT INTO uvh_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Ning tanga Jisas u nagira tonga kiap Pailat ganang kamiging. Ning tinga kiap Pailat wari ning anigagu', ma' gu Juda arantagim ning king girii wa. Ka Jisas wari ning anigu', ga kuma' torang una. ");
INSERT INTO uvh_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Ka Juda ning pris a aming girisi arantagim adibu marara Jisas u midi sige fam animbeging. Ka Jisas adi midi tubobu kabi'guk mo' yanggu', adi sige ningsa' adegu'. ");
INSERT INTO uvh_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Ka Pailat wari sigesa' adegu' u kanga ning anigu', indining, gu midi u gangbenga yaring wa ninak guk mo' u tanga maga isefinga fiderang. ");
INSERT INTO uvh_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Ka Jisas adi midi tubobu kabi'sini' guk mo' togu', mokngang. Ka Pailat adi Jisas wari midi kabi'guk mo' togu' u kanga aming kuni' nua'ni ninga kanga sasuk mimeng tugu'. ");
INSERT INTO uvh_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Ka Romni kiap ka Juda ning kamaganang ikiaging adi kadapmang nua'ni ka ning tiaging, gurak kubanik kubanik fikifiki wa Juda ning tangsana girii Pasova wari kadofonga tinga Romni kiap adi Juda aming ning kabaksi' ifakarenda waraga' sura adisining aming ka iyung kane kalabus tiaging u kubanikning fadara kamaiminga mugo waraga' wa Juda aming anasa' anga tuguinga aming kubanikning wa wara'ganangsa' fadara ipmiamiaging. ");
INSERT INTO uvh_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","18","Wara' kiap Pailat adi Jisas ning kadagang guk mokngang u kanga anga Juda ning aming girisi wari adi iirafik waraga' sura sigesa' tabanga amiging u kuma' kigedanga kagabi tinga mugo ga' sura aming arantagim girii ka fugang abanga adeging u ning yangkagu', sige wa nisi' kabisaminga mugo ga' naking, Barabas wa ma Jisas ka wapni Kasira Aming ning aniting uba kabisamotik. Ka Barabas ka wa wap aming kadagang sini' guk itarugu' wara' Pailat adi ning suku', a Juda aming adi aming kadagang u kabiam ga' aiga ning guk mokngang. Ning sura wa adi aming didimeng Jisas u kabiaminga mugo ga' guk yanggu' wang. ");
INSERT INTO uvh_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Ka Pailat adi aming midi u yangkanga ning tanga Jisas ning midi waraga' ko mera arasukdidimagu' wara'ganang ka tamni wari midi nua'ni ning kamingamgu', aming ka wa aming didimeng kareng ka gu napa' mamareng ni mo' kabingamotang. Na tiim ganang dama deramak kuma' tanga kangak wara' na mamareng naknga wa u ganirik wang ning anigu'. ");
INSERT INTO uvh_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Ka Juda ning pris a aming girisi arantagim wari Juda arantagim sige u ning yangdideging, Pailat wari nisi' kabisamotik ning u nua'bu udep sangkainga wa sidi Barabas wa kagabi te' a Jisas wa ugumak ningsa' katinting ning kuma' yangging. ");
INSERT INTO uvh_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Ka Pailat wari nua'bu yanggu' ganang wa ami taming adi Barabas wa kagabi titi waraga'sa' sura Barabas kabanim ga' nakem ningsa' katinga yareging. ");
INSERT INTO uvh_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Ka Pailat wari u naknga ning yanggu', a Jisas ka wapni nua'ni ka Kraist ning aniting ya indining totik. Ka aming arantagim kabi'mo' wari ning katiging, a wa firi ganang bema ugare'. ");
INSERT INTO uvh_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Ka Pailat wari ning yanggu', ka adi nasi' kadagang guk tugu' wara' sidi firi ganang bema ugari ga' toing. Ka ami taming kabi'mo' wari a, ugari te' firi ganang ugare' ning u dabiksa' napa'yanga katinga yareging. ");
INSERT INTO uvh_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Ka Pailat wari ami taming kabi'mo' wari adining midi ninak ga' bibi'sini' nakngamging u yapma ning suku', o na midi mimeng mo' inotik. Adi banaksi' kagaya naknga anasa' ami' girii ma tipmarakni'. Ning sura ning tanga aming wari kanga o adining kadagang mo' ba ning nakedanga tugu waraga' ama dis bema kafong u adisining dasi'ganang yotiku'. Yotira ning tanga ami taming u ning yanggu', sidi naga kafana yotitik i napma ning nakedanting, aming yari kumarota' wa naganing kadagang guk mokngang. Sidi napa' ni titiga' suking wa naga nua' mo' nangting, sidasa' tini'. ");
INSERT INTO uvh_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Pailat wari ning tuguinga ami taming arantagim kabi'mo' wari ning katiging, a ning undu' girisa' adining kungkumak ning kadagang wa indi a indining irini' warisa' kuma' bemtam ning toging. ");
INSERT INTO uvh_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Ning tanga Pailat wari aming kadagang Barabas ka kalabus tarugu' u fadara kamiamgu'. Ning tanga Jisas wa arantagimni ga' iminga bema fifefi tiging. Fefang fefang kabinga aming arantagim u ning yanggu', giri bema tonga ugari tini'. ");
INSERT INTO uvh_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Ning tanga Pailat ning soldia wari Jisas u nagira kiap ning yak iyung bane ganang amoging. Amanga ning tanga soldia arantagim girii dabiksa' wari yak ganang u abanga amanga bak girii tanga ");
INSERT INTO uvh_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Juda ning king ningda'ning kanga anikige titi waraga' sura Jisas ning kwi' timini kamagu' u kifanga kayongama ning tanga kwi' timini kamagu' u kifanga kayongama ning tanga kwi' inga'ni paramu' giming kareng sini' ka king wari ipmiaging ningwara' u kamingamging. ");
INSERT INTO uvh_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Ning tanga king ning mungkup tigigira ning tonga aya kusung guk u bema gwenga ki ganang kuta kamingamging. Ning tanga king wari aming yaptatora ning tong kigineng tigigira ning tonga sigisap tong ka ni bema Jisas ning kafong kareng ganang garingaminga suronga adegu'. Ning tanga Jisas ning kayong ganang u mandaksi' uwap tigigira tanga mera ning anikigeging, o beng sini' gu Juda aming ning king girii. ");
INSERT INTO uvh_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ning tanga iguk sombara tong ka kafong ganang amiging u tubobu iromkadara bema ki kati u fefiging. ");
INSERT INTO uvh_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Adi kadapmang ka ning u taramira anikigenga anganga ning tanga kwi' giming kareng kamingamging u tubobu kifinga irombema ananing kwi' timini u tubobu kamingama ning tanga ugumak titi waraga' nagira aging. ");
INSERT INTO uvh_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Ka soldia wari Jisas u nagira anga Jerusalem yong wara'ning gaga u kabinga aramugoging ka yong Sairini wara'ni aming nua'ni wapni Saimon u katuaging. Katuanga ning tanga Jisas ning firi ugari u yotangkangama barungnangam waraga' aniging. ");
INSERT INTO uvh_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Ka adi midi ninak sa' tanga Jisas ning firi ugari u barungnanga kabi'ning anganga kama wap Golgota ning aniaging u kadofiging. Ka midi Golgota wara'ning kini wa ki kati ning aniaging u anga kadofiging. ");
INSERT INTO uvh_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Kama ka u kadofinga ning tanga aming ka uuk tonga nagira aging wari Jisas ga' ama kagaya ka napa' kagaya kadagasi fam guk kuma' tanga gipfaranga bema aging u amiging, ugari tinga kagaya mimeng ma nako' ning tonga magi tipapeinga kagaya mimeng mo' ninak waraga' tanga bema aging u amiging. Ka Jisas adi kabi'sini'sa' fipnanga naknga topna guk mo' tugu', kagabi tugu'. ");
INSERT INTO uvh_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Ning tanga aming wari Jisas u bema firi ganang ugariging. Jisas u firi ganang kuma' ugaringa kabinga ning tanga adining kwi' kangkamani kifang kamiging u tanga bemna waraga' kat mera aratiging. ");
INSERT INTO uvh_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Kat u tanga ning tanga unggung ko katatoranga merafaging. ");
INSERT INTO uvh_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ka Jisas u ugaringa wa firi dibing kabi' bema midi pumpurum kabi' nua'ni ka ning yoking, YA JISAS JUDA NING KING. Ning yora bema Jisas ning ki ganang using u tapking. ");
INSERT INTO uvh_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Ka Jisas u uking ganang wa aming kadagasi kuba sasop titisi fama' undu' inagira fonga nua'ni ka Jisas ning kafong kareng ganang tara' a nua'ni ka kafong kesini ganang tara' ning ugariapking. ");
INSERT INTO uvh_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Ning tinga ami taming sige wari yangara Jisas u tarang kanga ning anikigenga yangaging, ");
INSERT INTO uvh_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","a gu tangkunang guk ning tonga siring yak girii tempel wa kaga'sa' kwetataranga kama faminengsa' tubobu tipmarak ga' urang fatugutang wa magabem, tanga tipmaratang wa. Abanga gu na Anutuning mindingni ning fatugutang. Ka gu Anutuning mindingni sini' ganang wa ganing fuka u yotangkanga firi ugari i kabinga afuinga gapnam. ");
INSERT INTO uvh_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Ning tinga Juda arantagim ning pris a sasuk aming a aming girisi fam adindu' ningsa' anikigeging. ");
INSERT INTO uvh_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Adi ning toging, magayam adi aming fam tanga yotangkayapma faiareta' wa. Adi firi ugari u kabinga afuinga wa giri indi o adi Isrel ning king beng sini' ba ning tonga naktangka tantam. ");
INSERT INTO uvh_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Abanga adi Anutuning tangkunang ga' naktangka tanga a na Anutuning mindingni ning fatuguta'. Ka adi Anutu wari beng udep yotangkangamita' wa kaga'sa' yotangkangaminga kanam. ");
INSERT INTO uvh_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Ning tuguinga aming kadagang titisi fama' ka Jisas ning gagaa ganang ugariapking adindu' Jisas u ningsa' anikigegumu'. ");
INSERT INTO uvh_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Ka kama ka Jisas u uking ganang didimeng mayam de wari bining sini' ka 12 klok ning adegu' ganang mayam de wari kangkamara tanga kama kama dabiksa' kama garinga yaregu'. Kama u ningsa' kangkamaranga anganga ");
INSERT INTO uvh_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","kibiri 3 klok ganang Jisas wari kungkumak tonga fugu naknga Juda anasining midiganang ku bang ning katigu', ilai ilai lama sabaktani. Ka midi ka u togu' wara'ning kini wa ning, o naning Anutu naning Anutu gu ninibi guk wa naga' tarang. ");
INSERT INTO uvh_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Ning tinga aming ka unggung adeingaging wari adining ku ka ilai ning katigu' u naknga ning toging, ai u nakni' Ilaija katinganara'. ");
INSERT INTO uvh_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Ning tonga Jisas ning fugu kagaya u tipkura kabi' titi waraga' aming nua'ni wari urapsa' unara anga gunggurang amaganangni u bema kuyang ganang tanga ama kagaya wain u yogubura bema Jisas ning mini ganang do kamingamgu'. ");
INSERT INTO uvh_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ka aming fam wari ning aniging, a urapmo' tangamotang Ilaija wari kuma' udep abanga yotangkangamota' ning toging. ");
INSERT INTO uvh_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Ning tanga adeia' Jisas wari ku bang sini' ari' nua'bu katigu'. Ning tinga uring wari kadofinga mugoinga kungkumak wadigi' tugu'. ");
INSERT INTO uvh_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Ning tinga didimeng sini' ka wara'ganangsa' kwi' tantung girii ka siring yak girii tempel ning iyung bane ganang ka iyung kabasi' ka Anutuning iyung ning aniaging u isefi waraga' tapsiseinga isefanga fideragu' wari anasa' bining sini' ganang using kuta yodanga ibaramara amamanga kaing ari' apa ibaregu'. Ning tanga kining girii wari kadofigu'. Kadofiinga uningkim girisi girisi wari anasa' taunga mangfiangak, ");
INSERT INTO uvh_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","a aming kungkumosi ning kusik kama ginang ka wadigi' kuma' isefitangka wari tubobu dasanganda, ning tinga Anutuning arantagim kabi'mo' ka timinggi' kuma' kumoging wari tubobu maraging. ");
INSERT INTO uvh_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Marara ning tanga kusiksi' u ibinga kadak yangaging. Ka inga' Jisas wari tubobu seranga maragu' ganang wa aming kungkumosi arantagim ka wa Jerusalem yong girii ganang amanga sireng sini' kadofisirendainga aming fam wari kuma' yapking. ");
INSERT INTO uvh_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Ka ami'ning aming girii guk ka arantagimni ami'ning aming fam ka Jisas ugariging udi unggung katatoranga fideging wari kining girii a napa' fam ka kama ka wara'ganangsa' kadofigu' u kanga mutu sini' tanga kabaksi' tubobu sura tipfaranga ning toging, beng guk sini' idi Anutuning mindingni beng ba ugumogum ning toging. ");
INSERT INTO uvh_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Ka taming arantagim kabi'mo' ka Jisas u yotangkangama tanga kama tubo Galili u kubap kabinga aging adindu' dokning unggung ko fidenga tabanga fakatatoreging. ");
INSERT INTO uvh_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Ka taming fam wara'sining wapsi' wa ning, Maria Makdalani a Maria nua'ni ka Jems ya Josep ya ning mamangsi' a nua'ni ka Sebedi ning tamni Jems ya Jon ya ning mamangsi' ning wari fidenga fagaging. ");
INSERT INTO uvh_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Ning tanga anganga kama wari kibirida tinga aming mambongni siamo' guk nua'ni wapni Josep ka yong Arimatiani adi Jisas ga' naktangka tanga yagu' ");
INSERT INTO uvh_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","ka wari Jisas ning fugu ugari tiging u bema kama ginang ganang kangkami waraga' sura kiap Pailat ganang agu'. Anga kadofinga Pailat u aniinga Pailat wari aigangam tanga adining kane aming u ininga kabingam sa' tiging. ");
INSERT INTO uvh_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Kabingaminga Jisas ning fugu kungkumong u tataranga bema ning tanga ananing kwi' fafa' inga'ni kareng sini' wari' Jisas ning fugu u tumuku'. ");
INSERT INTO uvh_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Tumura ning tanga bema tonga kama ginang inga'ni sini' ka Josep anata' sura unanga kabigu' wara'ganang tonga dasigu'. Ning tanga uningkim pampangareng girii nua'ni u tipdaranga bema tonga kama ginang wara'ning de u isefitangkanga kabinga ning tanga yoringga' mugo tugu'. ");
INSERT INTO uvh_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Ka Maria Makdalani wara'guk ka Maria nua'ni guk adi kama ginang wara'ning du' mera Josep wari Jisas ning fugu bema tonga dasinga fatugu' u kuma' mera tonga fagagumu'. ");
INSERT INTO uvh_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Ka Jisas uking wa fraide kibiri ganang bema ugariinga kumogu'. Ka kamindapking kama fagainga Juda ning pris girisi a Farisi arantagim wari kiap Pailat ganang abanga kadofinga bak tiging. ");
INSERT INTO uvh_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Tanga Pailat u ning aniging, girii gam indi mandaga' aming ka kap urang ugariging waraga' ganonga abem. Adi ka' ko ikita' ganang wa ning fatuguta', na kungkumak tok wa na kama faminengsa' ibinga tubobu kuma' seranga mararokga' ning fatuguta', ka indi midi ka waraga' ko sukem. ");
INSERT INTO uvh_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Ka arantagimni wari fuguni u kapmo' anga bema, ai kuma' marara' ning wa ami taming sige ma yangni'. Wara' Pailat gu soldia fam yangkareinga anga adining kusik u kama faminengning som tangkunang katatoranting. A indi ning guk mo' tantam wa adi fugu u kapmo' beminga adining midi mandaga' ka tim togu' wari wara'ganang wa girii nua'bu ma girawa'. ");
INSERT INTO uvh_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Ning aniinga Pailat wari aigaim tanga ning yanggu', beng guk toing. Ka ningwara' sidi naganing ami'ning aming fam u inagira fonga sidaning sasuk ganangsa' ipminga tinting ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Ning tanga Juda arantagim wari Pailat ning ami'ning aming arantagim fam u inagira anga Jisas ning kama ginang de u aming wari mo' kagadak waraga' napa' fam u nua'bu manggara fabanga so tangkunang sini' tanga kabinga ning tanga ami'ning aming inagira aging u kukyabinga Jisas ning kusik u katatoranga fideging. ");
INSERT INTO uvh_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Ka Juda arantagim ning mengkura girii ka sabat u kanga tanga defaging wari biinga kama ka sande fagagu' wara'ning kamindap gaa' fabubureng ganang wa taming fama' ka Maria Makdalani guk ka Maria nua'ni guk wari Jisas ning fugu kungkumong ka kama ginang ganang tonga kufaging u kaunga marara agumu'. ");
INSERT INTO uvh_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Ka taming fama' wari kadapmang bining ko aramugogumu' ganang ka girii ning ensel wari kunimganang kuta afanga Jisas ning kusik ganang u kadofiinga kining girii wari kadofigu'. Ning tanga ensel wari uningkim pampangareng girii ka Jisas ning kama ginang de isefiging u tipdaranga tonga gaga irara ning tanga uningkim wara'ning furo'ning ganang unggung mareiagu'. ");
INSERT INTO uvh_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Ka ensel wara'ning nondani wa diok kigineng sini' guk a adining kwi'ni wa fafa'sini' ka mungkong fafa' da'ning wari mareiagu'. ");
INSERT INTO uvh_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Ning tinga ami'ning aming ka Jisas ning kama ginang kusik u katatoranga fideging wari napa' u kadofigu' u kanga mutu tanga paparap tanga tangkunang guk mokngang baraganesi sini' ka aming kungkumosi da'ning mangfiangaging. ");
INSERT INTO uvh_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Ka taming fama' wari anga kadofiinga ensel wari taming fama' u ning yanggu', sidi mutu mo' tantamu. Na kuma' sapkedarik sidi Jisas ka firi ganang ugariging u kaunga abiamu'. ");
INSERT INTO uvh_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Ka na ning sanirik, tim adi tubobu mamarak ga' kuma' togu' wara' adi kama ginang ganang ingging ko mo' defata', adi tubobu kuma' marara'. Ka sidi i abanga kama gipmamni defak tanga' ya sa'abanga kademu'. ");
INSERT INTO uvh_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Kanga ning tanga sidi tubobu urapsa' unara anga adining arantagimni u ning yangtamu', adi kuma' marara kama tubo Galili do tim kuma' anga sipmeta' ka sidi mandang anga kanting. Sidi midi ka i sanirik ya anga iyang sa' tantamu' ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Ka taming fama' adi ensel ning midi u naknga kabaksi' karengsa' naknga a ensel u kagumu' waraga' mutu udi titi ning tanga Jisas ning arantagim fam u inonga tubobu urapsa' unara mugogumu'. ");
INSERT INTO uvh_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Ka taming fama' wari kadapmang bining u ko unara aramugogumu' ganang ka Jisas wari urapsa' kadofinga kadapmang ganang u adenga ning yanggu', o kamindapking kareng. Ka taming fama' wari adining midi u nakedanga anga kayong ganang mangmungkupnanga Jisas ning kayong u suronga animamangna tugumu'. ");
INSERT INTO uvh_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Ka Jisas wari ning yanggu', sidi mutu mo' tantamu'. Sidi i anga naganing kuyane arantagim fam u ininga adi kama tubo Galili ga' anting. Anga kama ka wara'ganang wa naga naptuani' ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Ka taming fama' wari kadapmang bining ganang ko unara famugoinga ami'ning aming fam ka Jisas ning kama ginang u katatoranga fideging wari yong girii do urapsa' kuma' unara anga Juda ning pris girisi arantagim u napa'napa' ka u kadofigu' wara'ning u kuma' yangsasu'nanga yareging. ");
INSERT INTO uvh_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Ka pris girisi adi midi ka u naknga kabaksi' mamareng naknga sasuk mimeng tiging. Ning tanga anga Juda ning aming girisi fam guk bak tanga midi ka Jisas wari tubobu maragu' wara'ning u tipmiri waraga' midi totangkanga ning tanga uningkim mambong kabi'mo' manggara anga ");
INSERT INTO uvh_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","ami'ning aming arantagim u midi yangsefi tangkunang ning tiging, sidi midi ka adi tubobu beng kuma' marara' ning wa mo'sini' tonting. Sidi ningsa' toni', indi dama dekinga ganang arantagimni wari tiim kapmo' kadofinga bemninging ningsa' toni'. ");
INSERT INTO uvh_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ka sidi aming fam wari midi ne ka tubobu mamarak ning u kiap girii anga aninting waraga' sasuk mimeng mo' tinting. Kiap wa indisa' kuma' anga anididimantam. ");
INSERT INTO uvh_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Juda ning aming girisi arantagim wari ami'ning aming u midi tangkunang ning ina ning tanga uningkim mambong girii bema aging u toyapma yareging. Moni ka u yamging wa midi u mo' tutugu wara'ning kadapmang usefi tiging. Ning tinga ami'ning aming adi moni u bema ning tanga adisining midisa' yareging. Ka aming girisi adi mandaga' gikna ning kadapmang ka ning u tiging wara' ababanga kami yara'ganang undu' mandaga' ningsa' ko giknanga fiareting. ");
INSERT INTO uvh_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Ka Jisas ananing arantagimni sini' ka ileven ning wari Jisas wari tubobu kuma' maragu' wara'ning midi u naknga kama tubo Judia tara' u kabinga marara kama tubo Galili tara' waraga' mugo tiging. Anga kadofinga kama bubo ka tim wara'ganang ipmek ga' fainarugu' wara'ganang areging. ");
INSERT INTO uvh_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Aranga kadofinga Jisas u wara'ganang katuaging. Ka arantagimni fam adi Jisas ning nonda u kanga Jisas ga' kabaksi' kareng naknga animamangna tanga mesisiringa tangamging. Ka Jisas ning arantagimni fam kubanik kubanik adi Jisas ana beng sini' u kayam ning sura sasuk fama' kabi' ko tiging. ");
INSERT INTO uvh_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Ning tanga Jisas wari arantagim wara'sining du'ganang ararenga abanga midi ning yanggu', Anutu wari napa'napa' kunim a kamaganang ikiting u yaptatorasasu'na wara'ning girii kuma' nipmira'. ");
INSERT INTO uvh_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Wara' ning sanotik, sidi kamaganang yara'ni aming arantagim dabiksa' u anga ina yareinga adi naganing arantagim ning kadofinga naning kadapmang sa' yaranga ikanting. Ning tanga ama iyamonga wa sibeng Anutuning wap a mindingni naganing wap a mini unggo ning wap wara'ganangsa' iyamting. ");
INSERT INTO uvh_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Ning tanga nasi' nasi' midi ka naga aming wari tanga iik wara'ning waraga' sanitik u yanggeksasu'nanga yareinga naknga tanga ikianting. Beng sini' urang sanirik na sibibi guk mo' totik, sidigok ningsa' ikiantam. Ira anganga kama yari bibi' to' wara'ganang ga'sa', beng. ");
INSERT INTO uvh_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Midi ka ya Anutuning mindingni Kasira Aming Jisas adining iikni wara'ning midi kareng. ");
INSERT INTO uvh_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Ka midi ka ya timinggi' Anutu wari profet Aisaia aniinga Aisaia wari tuguinga yoking wara'ganangsa' yaranga abanga kadofigu'. Midi ka u togu' wa ning, ");
INSERT INTO uvh_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","“o sabana na aming nua'ni tim anigarotik, adi tim anga guning kadapmang kagaragamota'. Aming ka wa kama sigesa' ganang anga adenga ku ning kato'ga', ai girii ning kadapmang tipdidimangamni' adi abubu waraga', ning yoking.” ");
INSERT INTO uvh_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Ning tanga ira ababanga inga' aming wap Jon wari kadofigu'. Kadofinga ning tanga anga kama bining sigesa' ka aming guk mokngang wara'ganang naro' ira anga aming u ama iyamonga midi ning ina yaregu', ai aming sidi kadagang tanga iking u kabani'. Kadagang u kabinga kabaksi' faranga abuinga ama isamotik. Ning tinga Anutu wari sidining kadagang u suknakubesamota' ning ina yaregu'. ");
INSERT INTO uvh_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Ning tanga aming ka kama tubo Judia tara' a Jerusalem yong girii wara'ni kabi'mo' wari Jon ning midi nakonga marara abiging. Abanga kadofinga adisining kadagang u ifadaksasu'neinga Jon wari Jodan ama u iyamgu'. ");
INSERT INTO uvh_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Ka Jon Baptis wari kama sigesa' ganang ira fatarugu' wara'ning wa ning, adi kwi' kareng mo' kaminga fatarugu'. Mokngang, adi kwi' ka maga kamel ning dumni wari tanga muntofiging u kaminga ning tanga nip u tamtangka wara'ning wa maga giknim wari tama ning tanga nanani ka gitara' ka nana tiaging a nimi' ameng unggungsa' nanga tanga fentarugu'. ");
INSERT INTO uvh_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ning tanga yangara midi tokadofi tanga ning fatorugu', aming ka ni naganing kumana ganang mandang abota' adining tangkunang wa naga narafiro'ga'. Adi aming girii sini' wap guk naga ningyara' mo'. ");
INSERT INTO uvh_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Na tatafak aming sigesa' wara' na ama warisa' isamarik a adi mini unggo wari isamo'ga' ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Ning tanga iya' Jisas adi yong kabasi' Nasaret ka kama tubo Galili tara' u itarugu' u kabinga abugu'. Abanga Jon Baptis ganang u kadofiinga Jon wari Jodan ama ganang ingamgu'. ");
INSERT INTO uvh_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Ka Jisas wari ama mang amogu' u kabinga marara adenga kunimganang kuta taranga degaranga kagu' ka kunim wari tubo kidagang tinga Anutuning mini unggo wari yang mimbe da'ning igira kadofinga didimeng ka ana adegu' ganang u afugu'. ");
INSERT INTO uvh_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Afuinga ning tanga naku' wa Anutu wari midi nua'ni kunimganang kuta ning togu', gu naganing sabana kareng na guning kadapmang wa karengsa' kanga guta' siamo' nakitik. ");
INSERT INTO uvh_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Ning tanga Anutuning mini unggo wari Jisas u anigareinga adi kama bining sigesa' u ironga agu'. ");
INSERT INTO uvh_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Anga kadofinga kama bining sigesa' wara'ganang kama paramu'sini' tiim sidii 40 ning u aming uwa guk mokngang Jisas anapmo' kubaniksa' keng baseni guksa' ikiaging. Ka wara'ganang aming kadagang Setan wari kadofinga Jisas u kadagang titiga' anigagaregu'. Anigagarenga taramira tanga anganga kabing mugoinga Anutuning kunung aming ensel wari afanga Jisas u yotangkangamging. ");
INSERT INTO uvh_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Ning tanga iya' king aming wari Jon Baptis u bema kalabus iyung dasiging. Ning tinga Jisas adi kama tubo Galili ga' tubobu mugogu'. Anga kadofinga Anutuning midi kareng u tokadofinga yaregu'. ");
INSERT INTO uvh_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Ning togu', kama ka Anutu wari aming u manggara adining binging ganang gi' kukyabinga iik wara'ning wa kami kuma' kadofisamara' yang. Wara' aming sidi kadagangsi' u wadigi' kabisasu'nanga ning tanga abanga Anutuning midi kareng ingging sa' nakni', ning togu'. ");
INSERT INTO uvh_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Ning tanga kama nua'niganang ka Jisas wari Galili gwang gaga u yaranga agu'. Anganga aming fama' iguyangguk ka Saimon ya Andru ya u yaptuagu'. Adi ama ging wengmanggak ning kane tiagumu' wara' adi ama gwang wara'ganang anga ama ging kane fatugumu' u yaptuagu'. ");
INSERT INTO uvh_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Ka Jisas wari aming fama' u anga yaptuanga ning yanggu', ai aming fama' sidi ama ging wengmanggak kane ba titamu', ka ningwara' kane ka wa kagabi tanga nagok kubap manam. Ning tinga nagabu kane ka naning aming arantagim ka ama ging u manggakitamu' ningda'ning tanga inagikdemu' waraga' ubu sanggerotik. ");
INSERT INTO uvh_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Ning ininga adi ninaksa' tanga kanesi' u kabinga ning tanga Jisas ubu yaranga adigok kubap mugoging. ");
INSERT INTO uvh_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Ning tanga inagira gwang gaga u kabi'ning yaranga anganga aming fama' nua'bu yaptuaging wa Sebedi ning mindine fama' Jems ya Jon ya adi babangsi' Sebedi anagok ka kane aming fam guk bot furo'ning mera umben tiptatare kane fatiging u anga yaptuaging. ");
INSERT INTO uvh_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Yapma ning tanga Jisas wari katiang tugu'. Katianinga Jisas ning ku u naknga marara babangsi' Sebedi guk ka kane aming fam guk wa bot furo'ning ganang unggung ibinga bemkura abanga Jisas u yaranga adigok kudap mugoging. ");
INSERT INTO uvh_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Ka Jisas guk ka arantagimni guk wari Kapaneam yongga' aging. Anga kadofinga iya' ning tanga Juda ning mengkura ning kama wari kadofigu'. Wara'ganang ka Jisas wari siring yak ganang amanga aming u Anutuning midi kareng ituaima yaregu'. ");
INSERT INTO uvh_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Ka ami taming adi Jisas ning midi wa kigineng guk kuni' nua'ni sini' ka adisining sasuk amingning midi ningda'ning mo' naking waraga' tanga base tiging. ");
INSERT INTO uvh_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Ka kama ka wara'ganang aming nua'ni mini unggo kadagang guk adindu' siring yak iyung bane u amanga mareiagu' wari Jisas u kanga ku ning katigu', ");
INSERT INTO uvh_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","ai Jisas Nasaretni gu nasi' tinibonga abangang, indifi tonga abangang wa. A na gu udi kuma' gapkedarik aming ka Anutu wari kasiringa gangkaregu' udi gusa' ning togu'. ");
INSERT INTO uvh_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Ka Jisas wari mini unggo kadagang u ning anikagaregu', a kabap mini unggo kadagang gu aming u kagabi te'. ");
INSERT INTO uvh_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Ka mini unggo kadagang wari aming u kabonga tantaramik tinga aming wari paparap girii tugu'. Ning tinga mini unggo kadagang wari ku bang katinga ning tanga aming u kabinga mugo tugu'. ");
INSERT INTO uvh_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Ning tinga aming ka siring yak ganang Jisas ning midi u mera fanaking wari Jisas wari mini unggo kadagang anikagaregu' u kanga base tanga ning tonga yareging, ai ya nasi' aming, adining kadapmang wa kuni' nua'ni sini' kayam sanem. Adining midi udi kigineng guk wara' adi mini unggo kadagasi inara' udi nakngam sa' tanga maing, ning toging. ");
INSERT INTO uvh_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Adi Jisas ning tangkunang u kanga waraga' midi tonga yareging wari kama tubo Galili tara' dabik u urapsa' feradanga mugoinga naksasu'neging. ");
INSERT INTO uvh_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Ning tanga siring yak u kabinga fugang afanga Jisas guk ka Jems ya Jon ya wara'guk adi Saimon iguyangguk Andru ya adisining yak ganangga' mugoging. ");
INSERT INTO uvh_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Ka Saimon ning ipmang taming udi bagana fugu kagaya mamareng tanga defagu'. Ka Jisas wari anga kadofiinga waraga' aniging. ");
INSERT INTO uvh_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Jisas wari midi ka u naknga iyung amanga ning tanga taming wara'ning kafong u suronga wenga tipmarak tugu'. Ning tinga taming wara'ning bagana wari kaga' wara'ganang'sa' kabiinga karendanga marara Jisas se' anasita' nana siam kane tugu'. ");
INSERT INTO uvh_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","33","Ningtanga kibiri ganang yong wara'ni aming kabi'mo' wari amise fam ka bagana guk a masi' unggo kadagasi guk u inagira ning tanga abanga yak ka Jisas wari mareiagu' wara'ganang bak girii tiging. ");
INSERT INTO uvh_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Ning tinga Jisas wari aming bagana kuni' kuni' guk inagira aging u ifakarendasasu'nanga a aming ka masi' unggo kadagasi guk wa masi' unggo kadagasi u yangkagareimgu'. Ka masi' unggo kadagasi wari Jisas u kuma' kigedaging waraga' tanga Jisas wari yangkara tanga yangsefi tangkunang ning tugu', sidi naganing wap wa mo'sini' tonting. ");
INSERT INTO uvh_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Ning tanga deia' ka Jisas adi anapmo'sa' gaa' sini' marara yong ka u kabinga mugogu'. Anga kama ka aming guk mokngang wara'ganang kadofinga mera beni Anutuga' ibang futogu'. ");
INSERT INTO uvh_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Ka Saimon se' adi kamasa' marara denga adita' wenanga yareging. ");
INSERT INTO uvh_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Wenanga anga katuanga Jisas u ning aniging, ai aming kabi'mo' udi guta' siamo' toing kanga wenanga abem. ");
INSERT INTO uvh_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Ka Jisas wari ning yanggu', beng sini' na kane ka ningwaraga' afuguk de ka yong udi kubanik unggungsa' mo', yong fam ka ko adeing waraga' ubu anga midi ituaima yarotik. ");
INSERT INTO uvh_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Ning ina ning tanga yong ka u kabinga anga kama tubo Galili tara' unggung wara'ning yong yong u yangara adisining siring yakganang amanga Anutuning midi kareng ituaima yaregu'. Ning tanga aming masi' unggo kadagasi guk kabi'mo' wara'sining masi' unggo kadagasi u tanga igukima ning tugu'. ");
INSERT INTO uvh_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Ka aming nua'ni bagana kadagang sini' ka kayong kafong ki natugupmuresi lepa guk wari Jisas ganang kadofinga manda upma mera Jisas u ning anigu', o beng sini' girii gu bibiri' napma yotangkanam te', ning gabarik ka gu nifikarenda sini' titining, ning anigu'. ");
INSERT INTO uvh_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Ka Jisas wari u kanga bibiri' siamo' kanga ning tanga aming u suronga ning anigu', we' kuma' yotangkagamarik, karenda te'. ");
INSERT INTO uvh_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Ning aniinga bagana kadagang wari urapsa' kabiinga kayong kafong wari kaga' karendanga fafandangeng karengsa' ubu mareiagu'. ");
INSERT INTO uvh_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Ning tanga Jisas wari aming u anisefi tangkunang ning tugu', napa' i tagamarik ya aming sige fam guk mo'sini' anga inotang, gu didimeng i anga pris ganangsa' kadofinga fuka i anatintingnotang. Ning tanga pris wari fuka karengsa' u gabinga gu ofa ka aming wari fuksi' tubobu karendainga tiam wara'ning kadapmang ka tim Moses wari togu' u yaranga titing u totang. Ning tinga aming adi o fuka urang udi beng sini' ba karendara' ning wa inga' gapma tonting, ning aninga anigaregu'. ");
INSERT INTO uvh_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Jisas adi midi anisefi tang ning kuma' tugu' de, ka mokngang bagana aming adi Jisas wari napa' girii sini' tangamgu' u kanga de danga kaba karengsa' naknga ning tanga anga aming yong yong u napa' Jisas wari u tangamgu' wara'ning midi u yangsasu'na sa' tanga yaregu'. Ka Jisas wari adining midi ne wari yong yong kuma' semiriku' u naknga aming wari adiganang bak girii titi waraga' tanga yongganang guk mo' anga kadofigu', adi kama bining sige wara'ganang anga ikinga aming yong ka tubo tubo ikiaging wari marara abanga fagayaging. ");
INSERT INTO uvh_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Ka Jisas wari Kapaneam yongga' tubobu mugogu'. Anga kadofiinga aming wari adi tubobu kuma' agu' wara'ning midi ne u kuma' naking. ");
INSERT INTO uvh_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Naknga ning tanga abanga yak ka Jisas wari mareiagu' wara'ganang amanga kuking. Amanga kura bak girii tanga yak u tiptona sini' tanga fam ka fugang do mera yareging. ");
INSERT INTO uvh_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Ka Jisas wari yak iyung u adenga midi fianggu' ganang ka aming fama'gong fama'gong wari aming nua'ni bagana agik girii tanga kayong kafong kuma' kumoging u ipma bema Jisas kaunga abiging. ");
INSERT INTO uvh_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Ka adi aming u iyung bane bema ama ning kama guk mokngang, aming wari bak girii tanga kama kuma' tipkirikneging. U kanga Jisas wa indining tanga katuantam ning tonga yak furo'ning u kinga aranga yak ki kubing kuta kwetama ning tanga aming tagim u bema aranga aya wari tubo tofing tanga kamainga amanga Jisas ning mamamni ganang didimeng u deiagu'. ");
INSERT INTO uvh_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Ka Jisas wari bagana aming wara'ning amine wari Jisas ning kigineng ga' naktangka tanga kabaksi' kubaniksa' kufara kane tang sini' tiging u yapma bagana aming u ning anigu', sabana guning kadagang kuma' tipmiringa suknakubegamarik. ");
INSERT INTO uvh_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Ka Juda arantagim ning sasuk aming fam ka adisining bining ganang mareiaging wari Jisas ning midi u naknga anasa' ning toging, ");
INSERT INTO uvh_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","ai aming ka ya midi ka Anutu anikige ningda'ning wa indining tora'. Aming kamaganangni ka ni aming ning kadagang waraga' wa midisa' tuguinga bibi'ning tangkunang guk mokngang. Anutu anapmo' kubanik warisa' wa aming ning kadagang tipmiriam ning tang guk ning toging. ");
INSERT INTO uvh_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Ka Jisas adi adisining sasuk ka banaksi' ganangsa' sura mareiaging u kuma' yapkedanga ning yanggu', ka sidi wa indining suknaming. ");
INSERT INTO uvh_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Na gu kadagang kuma' bira' ning u midisa' torik wa kadagang tirik wa, a dasi'ganang sireng sini' aninga tipmarakinga marara mugoinga kayaning wa giri unda'. ");
INSERT INTO uvh_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Ka sireng ning sanotik, Amingning Tim Iyak na aming ning kadagang u tipmiri wara'ning tangkunang guk wara' na sangtinting tinga kanga beng ba ning tutugu waraga' totik i kani', ning yanggu'. Ning tanga Jisas wari aming kayong kafong kungkumosi u ning anigu', ");
INSERT INTO uvh_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","kuyana mamarak te'. Marara kwi'ga mambong i manggaknanga yakangga' karensa' maya', ning anigu'. ");
INSERT INTO uvh_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Ning tinga aming wari bagana aming u dabiksa' adenga arakafainga bagana aming wari dasi'ganang kaga' urapsa' karendanga maragu'. Marara ning tanga kwi'ni manggaknanga yoringga' mugo tugu'. Ning tinga aming adi Jisas wari napa' girii tugu' u kanga base tanga ning toging, o beng sini' indi tim napa' ka ningyara' guk mo' kanga ira abutam. Ning tonga Anutuning wap bema areging. ");
INSERT INTO uvh_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Ning tanga Jisas adi kama ka Galili gwang gaga tara' waraga' tubobu mugogu'. Ka aming arantagim kabi'mo' wari Jisas ganang abuinga Jisas wari Anutuning midi kareng yanggeku'. ");
INSERT INTO uvh_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Yanggera ning tanga ibinga kabi'ning nua'bu anganga aming nua'ni katuaging. Aming ka wa Alfias ning mindingni Livai, adi Juda aming ka adi Romni gavman ning kane aming ira takis mamanggak kane tarugu' wari ananing takis yak kabasi'ganang u mera kane fatugu' u anga katuanga Jisas wari ning anigu', ai abubu te'. Abanga naga naware'. Ning aniinga ninak sa' tanga marara kane fatugu' u kabinga Jisas ubu yaranga ning tanga adisigok mugoging. ");
INSERT INTO uvh_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Ning tanga iya' inga'ning Jisas guk ka arantagimni guk wari Livai ning yak ganang amanga aming takis mamanggesi a aming ka wap sansaramik titisi ning iniaging a aming fam ka Jisas u yaranga aging ning wara'siguk dabiksa' bak girii kura mera nana u naging. ");
INSERT INTO uvh_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Ka Juda ning sasuk aming fam ka Farisi arantagim ning wari Jisas wari aming kadagasi guk ka aming takis mamanggesi guk nana dabik mera naging u kanga anga Jisas ning arantagim u ning yangging, ai indining, adi aming kadagasi ka takis mamanggesi a aming sansaramik titisi wara'siguk nana kubap ba mera faning, ning yangging. ");
INSERT INTO uvh_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Ka Jisas adi adisining midi u naknga midi tipfaraim kabi' tanga ning yanggu', ning sanotik dokta adi kane girii wa bagana aming ifakarenda wara'ga'sa' titing. A aming kareng adi dokta ganang guk mo' auting wara' dokta adindu' aming karesi wara'guk mo' sukiting. Ka nandu' na aming karesi katiang ga' mo' afuguk, mokngang na aming kadagasi katiang ga' afuguk wara' na aming kadagasi guk mera nem yang ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Ka Jon Baptis ning arantagim guk ka Farisi ning arantagim guk adi fiking nua'ni ganang Juda anasining kadapmang yaranga nana tapni tiging. Ka aming sige fam wari adisining kadapmang u kareng ning kanga abanga Jisas u ning anigaging, ai Jon ning arantagim a Farisi adi nana tapni ting yabem a guning arantagim adi tapni guk mo' tanga nanasa' ba ting, ning aniging. ");
INSERT INTO uvh_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Ka Jisas wari ning tipfaranga yanggu', indining, aming nua'ni wari taming kafauwe tonga tangsana tota' wa adining amine adi nana ka wa mo' nanting wa. Mokngang adi wara'ganang wa kabaksi' karengsa' naknga ning tanga nana wa nanasa' tinting. ");
INSERT INTO uvh_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Ka inga' aming fam wari aming ka kafauwe titining u abanga nagira auinga amine adi kabaksi' mamareng naknga ning tanga nana tapni wa wara'ganangsa' tanga biinga marekanting. ");
INSERT INTO uvh_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Ning tanga nua'bu yanggu', a nua'ni ka ning, kwi' timini damirik tota' wara'ning ginang wa kwi' inga'ni kareng wari mo' dopma muntofotang. Mokngang, ning totang wa inga'ni wari tang ko adeinga timini wari nua'bu ibaramara kadaga sini' tota'. ");
INSERT INTO uvh_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Abanga nua'ni ka ning, wain ama inga'ni kigineng guk wa maga giknim kandang timini wara'ganang mo' tagarotang. Mokngang, ning totang wa wain inga'ni wara'ning kigineng wari tanga kandang timini u ibaramak tanga wain ama kareng wari kamaganangsa' masasu'neinga kandang undu' wadigi' kadauta'. Wara' kadapmang kareng wa ning, wain ama inga'ni undu' maga giknim kandang inga'ni ganangsa' tagarotang wa giri karengsa' gi' adeuta'. Ka naning arantagim adindu' kadapmang inga'nisa' yaranga tinting ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Ka fiking nua'ni mengkura ning kama sabat ganang Jisas guk ka arantagimni guk kadak mugoging. Anga wit feng ganang kadofinga arantagimni wari seksi' naknga wit u upma manggara buroma nanga nanga mugoging. ");
INSERT INTO uvh_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Ka Farisi arantagim fam wari wit manggara naging u yapma Jisas u ning aniging, ai arantagimga u yabe'. Kami ya mengkura ning kama urang udi, ka naga' tanga adi wit wa kama tapni ganang guk manggara naing. Juda aming indining kadapmang tangkunang wa ning, indi mengkura ning kamaganang wa napa'ni kabi'sini' ning guk mo' titam mokngang sini', ning aniging. ");
INSERT INTO uvh_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","26","Ka Jisas adibu ning yanggu', a timinggi' papani' Devit adindu' segi kagaya naknga kadapmang ka ningyara' udi kuma'sa' tugu'. Ka indining, sidi midi ka adi u tugu' wara'ning ka umpang ganang kuma' yoking wara'guk mo' ba indangira kating. Wa ning tiging, tim aming wap Abiata wari pris girii yagu' ganang wa Devit guk ka adining ami'ning aming arantagim fam guk adi ami' tanga nana guk mokngang waraga' tanga seksi' kagaya sini' naknga abanga siring yak ganang amanga baret ka Anutuga' ning tonga kuma' animamangnanga kukngamging unggung manggara naging. Ka indining kadapmang wa ning titam, baret ka Anutuga' ning tonga kuma' kamingamting wa aming sige wari nana ning guk mokngang, wa pris girisi warisa' nana wara'ning. Ka Devit adi unggung amanga manggara arantagimni ga' undu' ima ning tanga naging. Ka sidi waraga' wa indining suking, Devit adi kadagang tugu' wa. Mokngang. ");
INSERT INTO uvh_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Ka sidi ning nakanting, Anutu adi mengkura ning kama sabat wa aming ga' mamareng iyam ning mo' kamigu'. Mokngang sini' adi mengkura ning kama wa aming wari kabaksi' ararangeng karengsa' naknga ning tanga mesisiringa sa' tanga marek waraga' kamigu'. ");
INSERT INTO uvh_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Beng sini' sanarik, mengkura ning kama wara'ning tuang wa Amingning Tim Iyak nagasa' itik wara' naga mengkura ning kamaganang napa'ni ka kadagang mo' ning kanga wa girisa' totik, ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Ning tanga iya' mengkura ning kama sabat nua'ni ganang ka Jisas wari siring yak ganang u nua'bu amogu'. Ka aming nua'ni kafong tubo wadigi' kuma' kumara tangkagu' undu' siring yak iyung bane unggung amanga mareiagu'. ");
INSERT INTO uvh_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Ka aming fam ka Jisas ga' kabaksi' kadagang fanakngamiaging adindu' Jisas wari mengkura ning kamaganang u aming ni udep tipkarendainga wara'ganang animbenga bema midiganang kamintam ning tonga amanga mera kafatatoreging. ");
INSERT INTO uvh_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Ka Jisas wari aming kafong kadagang u tipkarendonga ning katinganggu', ai mamarak tanga ita' abanga adeya'. Ning aniinga anga adegu'. Ka Jisas adi aming amanga mareiaging wara'sining sasuksi' u kuma' yapkedagu' wara' tim ka ning yangkagu', ");
INSERT INTO uvh_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","ai, Juda aming indining kadapmang tangkunang urang wa indining, mengkura ning kama wa kane kareng ka aming yotangkayap ga' titining wa ma kane kadagang ka aming didipmi ning u titi wara'ning, ma' ning yanggu'. Ka mokngang adi midi tubobu kabi'guk mo' toging marek sa' tiging. ");
INSERT INTO uvh_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Ka Jisas adi midi tubobu guk mo' toging u yapma kuma' yapkedagu' adisining kabaksi'ganang wa sasuk ka aming fam ga' bibiri' naknga yotangkayap titi wara'ning guk mokngang waraga' tanga adi kaba mamareng nakyama yapgurada tugu'. Ning tanga Jisas wari aming u ning anigu', kafaga kadagang u wetatare te'. Ning aniinga wetatare tinga kafong wari kaga' wara'ganangsa' karendagu'. ");
INSERT INTO uvh_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Ning tinga Farisi arantagim adi u kanga kabaksi' kadagang naknga marara fugang amanga anga Herot ning arantagim guk bak tanga Jisas u uuk waraga' midi kapmo' tonga naking. ");
INSERT INTO uvh_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","8","Ning tanga Jisas guk ka arantagimni guk adi yong ka u kabinga Galili gwang ga' mugoging. Ka ami taming arantagim kabi'mo' wari Jisas wari kane tangkunang tanga yaregu' wara'ning midi ne u naknga Jisas u kadidima sini' tonga mandang iwara aging. Ka aming arantaim girii ka u aging wa kama tubo Judia tara' wara'ni a Jerusalem yong girii aming a Idumia tara' wara'ni a Jodan ama fugung tubo do ning tara' wara'ni a yong fama' ka Taia guk ka Saidon guk tara' wara'ni aming dabiksa' ka yong ka ning wari marara yaranga aging. ");
INSERT INTO uvh_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","10","Anga Jisas ganang kadofinga bak girii tinga Jisas wari adisining bagana aming kabi'mo' u ifikarendagu' waraga' tanga bagana aming fam wari Jisas ning fugu u tifema karenda titiga' ning tonga aming fam u sungniapma sungniapma anganga Jisas u tipkagade sini' tiging. Ka Jisas adi aming kabi'mo' wari kadofinga tipkagade sini' tiging u yapma arantagimni u ning yanggu', sidi bot nua'ni bema tabanga du' kaninamni'. Ning ininga bot u bemama abuinga Jisas adi bot wara'ganang aranga mera gwang ganang adenga midi fianggu'. ");
INSERT INTO uvh_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Ka aming ka masi' unggo kadagasi guk adindu' masi' unggo kadagasi wari Jisas u kuma' kigedanga abanga Jisas ning kayong ganang u mandaksi' upma mera ku ning fakatiging, ai indi kuma' gapkedem gu udi Anutuning mindingni. ");
INSERT INTO uvh_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ka Jisas adi yangsefi fatugu'. Ning fianggu', ai kabap naganing wap sirengsa' mo' tonting, ning fianggu'. ");
INSERT INTO uvh_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Ning tanga Jisas wari ananing kane aming sini' ifakasirinonga aming fam katiana inagira ning tanga aming arantagim girii u ibinga anga kama bubo nua'ni ganang areging. ");
INSERT INTO uvh_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Aranga kadofinga ning tanga aming 12 ning ka adigok kane kubap tanga iik waraga' ifakasirinanga wap aposel u yamgu'. Ima ning tanga ning yanggu', aming arantagim ka sidi wa nagok kubap dabik ningsa' ira anganga inga' naganing midi bema ituanga yara waraga' sangkarok ga'. ");
INSERT INTO uvh_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Ning tanga tangkunang ka aming ning masi' unggo kadagasi tanga igukyam wara'ning undu' saminga tanga yarani'ga', ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","17","Ka aming arantagim ka u ifakasiregu' wara'sining wapsi' wa ning, Saimon (wa Jisas wari wapni inga'ni ka Pita ning anigu'), a Sebedi ning mindine fama' Jems ya Jon ya wa Jisas wari wapsi' nua'ni Boanesis ning idefigu', ka wap Boanesis wara'ning kini wa mungkurapbe. ");
INSERT INTO uvh_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","19","Abanga Andru Filip Batolomiu Matyu Tomas a Jems nua'ni ka Alfias ning mindingni a Tadias a Saimon ka Selot arantagimni a Judas Iskeriot, aming ka wa inga' Jisas uuk titiga' tipkadofiaminga bemging ning u ifakasiregu'. ");
INSERT INTO uvh_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Ning tanga Jisas wari arantagimni u inagiknanga yaksing ki ganangga' tubobu mugoging. Anga kadofiinga aming kabi'mo' wari adiganang bak girii nua'bu abanga tiging. Ning tinga Jisas se' adi u yapmengkanga kanesa' tanga nana kafakafa guk mo' nanga ikiaging. ");
INSERT INTO uvh_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Ka Jisas ananing amine adi Jisas wari kane tinga aming wari bak mimeng tinga nana kafakafa guk mo' nagu' wara'ning midi u naknga ai, adi kadapmang ka ning guk wa inga'sa' wa nasi' wari abanga kanga tara' ning tonga base tanga ning toging. Adi kane mimeng sini' tanga magi ma pipewa' ning tonga ninagik tonga marara abiging. ");
INSERT INTO uvh_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Ka Juda arantagim ning sasuk aming fam ka Jerusalem yong girii kuta ikiaging adindu' afanga Jisas wari amingning masi' unggo kadagasi tanga igukyamgu' u kanga ning toging, a indi kuma' kigedem masi' unggo kadagasi ning girisi' Bielsebul anasa' abanga amanga tangkunang amiinga tanga iguta' ning toging. ");
INSERT INTO uvh_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Ka Jisas wari u naknga fonga kukyapma midi tipfara tanga ning yanggu', indining, Setan adi ana unggung tipfaranga anigagareuta' wa. ");
INSERT INTO uvh_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Abanga aming arantagim ka ni tangkunang guk ikanting ka adi arok tanga tubo kidagang kuma' tinting wa adisining tangkunang udi ko irota' wa. Mokngang. ");
INSERT INTO uvh_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Abanga aming ana kurene arantagim undu' ningsa' adi arok tanga tubo kidagang da' tanga ikanting undu' mokngang adisining tangkunang wari bibi' tota'. ");
INSERT INTO uvh_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Ka Setan ning arantagim undu' ningsa', adi anasa' kura' anigagareng tinting wa adisining tangkunang wari bibi' tota'. Ning tanga adi wadigi' bisasu'nanting wara' adi anasa' kura' anigagareng guk mo' titing. ");
INSERT INTO uvh_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","A nua'ni ka ning, aming nua'ni wari aming tangkunang ni ning yak ganang amanga mambong fam iromanggaknonga wa adi sigesa' mo' anga amota'. Mokngang adi tim ka aya tanga anga aming u bema kayong kafong ipma ipma kufara ning tanga wara'ganang inga' amota' wa giri manggaknota'. A adi ning guk mo' tanga sige anga ama sa' tota' wa yak tuang wari urota'. Ka naga aming kadagang Setan ning kane aming yangkagareunga undu' kugurang da'ning mo' totik kane girii sini' totik, ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Ning ina ning tanga ning yanggu', beng sini' sanirik aming wari midi kadagang a nasi' kadagang fam tinting wa Anutu adi suknakubeyam guk tota'. ");
INSERT INTO uvh_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","A kadagang ka aming wari Anutuning mini unggo kareng ning tangkunang u kuma' kanga a udi mini unggo kadagang anesa' tara' ning tonga anikige tinting wa Anutu adi suknakubeyam guk mo' tota'. Mokngang sini' adi kadagangsi' wara'guk ko ningsa' ira anting, ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Juda ning sasuk aming fam a aming fam wari a udi mini unggo kadagang wari abanga amanga tara' ning toging u naknga wa Jidas adi midi tangkunang u yanggu'. ");
INSERT INTO uvh_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Ka Jisas wari midi u ina ina ning tanga adegu'. Ka Jisas ananing mengne kuyane wari Jisas u nagikantam ning tonga wenanga anga kadofinga yak wara'ning iming ganang anga adeging. Adenga ning tanga aming nua'ni anigareinga amanga togu'. ");
INSERT INTO uvh_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Ka aming kabi'mo' Jisas ning midi u mera fanaking wari naknga Jisas u ning aniging, ai mamangge kuyage udi guta' abanga fidenga fatoing apang. ");
INSERT INTO uvh_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Ka Jisas adibu ning yanggu', naganing mamangne kuyane wa indeng. ");
INSERT INTO uvh_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","35","Ning ina aming u ifang yaranga ning tanga ning yanggu', beng sini' sanirik ami a taming ka Anutuning midi ninak sa' tota' wa naganing kuyana a kuyana taming a mamangna ning wa naganing midi mera naking yang, ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Ka Jisas wari Galili gwang do anga ami taming ga' Anutuning midi kareng ituaim ning kane u nua'bu tugu'. Ka aming kabi'mo' kadofiging waraga' tanga Jisas adi bot ganang aranga mera gwang ganang naro' dokning anga mareiagu'. Ning tinga ami taming adi gwang gaga u mera yareging. ");
INSERT INTO uvh_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Ning tanga Jisas wari aming wari Anutuning midi ki u nakeda waraga' midi tipfara sa' tanga ina yaregu'. ");
INSERT INTO uvh_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","Ning yanggu', sidi naga midi toutik i nakni' aming nua'ni wari nana tangkunang wit u feng ganang ipmonga karapnanga igura yarota'. ");
INSERT INTO uvh_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Ning tinga fam ka kadapmang ganang sirengsa' mangmarekanting wa yang wari ko mo' kadofiinga ganang urapsa' abanga yora nanting. A fam wa kama kareng mo' uningkim guk wara'ganang mangfanting. ");
INSERT INTO uvh_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Mangfanga kama fafageng kabi'guk waraga' tanga kagadofi udi giri urapsa' tinting. ");
INSERT INTO uvh_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Ka kama kareng sini' mo' wara' fini tangkunang guk mokngang. Ka inga' mayam girii danga wa tubobu urapsa' kaforanting. ");
INSERT INTO uvh_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","A wit mindip fam ka munggwak mang mangfanting. Mangfanga ning tanga kagadofi udi giri tinting ka munggwak wari tanga kirida tanga beng guk mo' tinting. ");
INSERT INTO uvh_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","A mindip fam wa giri kama kareng ganang mangfinting. Adi karesisa' kadofinga giranga beng undu' karesisa' tinting, ");
INSERT INTO uvh_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","fam ka dandamesi gi' 30 ning a fam ka girisi 60 ning a fam ka girisi sini' 100 ning tanga yaranting. Aming ka sasuk guk wa midi i torik i kafakafa sura nakedota' ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Ka Jisas wari midi u ina ning tanga anapmo'sa' mareiagu' ganang Jisas ananing arantagim 12 guk ka aming fam ka Jisas u kubap yaranga fengakiaging wari Jisas ganang anga ning anigaging, ai girii gam midi ka urang tonga yarangang wara'ning kini wa indining. ");
INSERT INTO uvh_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Ka Jisas wari ning yanggu', sidi naktangka kuma' ting wara' na Anutuning bining ning midi ki sireng sini' wa sidisa' fasanarik. A aming fam ka naktangka guk mo' tanga fugang ko iking wara'siga' wa ana inga' kuma' sura nakedanting ning tonga midi tipfaraim sa' tanga fainirik. ");
INSERT INTO uvh_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Ka aming ka wara'sining kadapmang waraga' midi tim ning kuma' tuguinga yoking, “adi kaga udi giri tinting ka adi kigeda sini' guk mo' tinting. A ninak undu' giri tinting ka nakeda sini' guk mo' tinting. Adi kigeda tanga a nakeda sini' tanga ning tanga kabaksi' farianing ganang wa Anutu wari adisining kadagang u tanga igukyamaro' ning yoking ning yanggu'.” ");
INSERT INTO uvh_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Ka Jisas wari arantagimni u ning yanggu', ma' ka sidi midi wara'ning ki wa nakeda guk mo' ba ting. Ka ning wa midi fam ka inga' nua'bu toutik wa indining tanga nakedanting ga'. ");
INSERT INTO uvh_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Ka midi u tongak wara'ning kini wa ning sanotik, aming ka wit mindip manggara fonga feng ganang igura yarara' wa aming wari Anutuning midi kareng ituara'. ");
INSERT INTO uvh_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Ka fikingni ganang aming wari Anutuning midi ituaimota' ka aming ka kabaksi' ka kadapmang aming wari fikifiki fitipmi ning ningda'ning guk ikiting adi midi u naknga bemdasi guk mo' tinga Setan wari urapsa' ufafeimota'. ");
INSERT INTO uvh_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","17","A aming fam ning kabaksi' ka kama uningkim guk ningda'ning ikiting adindu' ningsa' adi midi kareng u naknga kabaksi' udi giri marakota' ka naktangka guk mo' tinting. Adi midi u naknga mesisiringa sigesa' tanga ira ning tanga mamareng fam a mamareng ka adi Anutuning midi u yaranting waraga' tanga aming fam wari ifakadaga tonga tinting ganang wa adi o kagaya ma nimni' ning tonga waraga' mutu tanga Anutuning midi u urapsa' kabinting. ");
INSERT INTO uvh_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","19","A aming fam ning kabaksi' wa mungwak base ningda'ning wara'guk ikiting wara' adi Anutuning midi kareng u kuma' naknga ning tanga adi sasuk mimeng ka adisining iiksi' wara'ning mamareng a uningkim mambong mimeng manggakna a mambong karesi fam ga' sasuk mimeng titi ning wari adisining kabaksi'ganang ira Anutuning midi u urapsa' ufafereinga adi sigesa' ikiting. Wara' aming arantagim ka ningwara' wa inga' adi bengsi' guk mokngang, fisa'. ");
INSERT INTO uvh_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","A aming fam ning kabaksi' wa kama marang guk kareng ningda'ning adi midi u naknga naktangka tanga kabaksi' kubaniksa' kufara surotangkanga ira anting. Adi inga' adisining kanesi' kareng wara'ning bengni wa kareng sini' kadofo'ga' fam ka kabi' gi' a fam ka girisi a fam ka girisi sini' ning kadofasirendo'ga' ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Ning tanga Jisas wari arantagimni u Anutuning midi kareng wara'ning kini u nua'bu yangnatamonga ning yanggu', tiim ganang aming wari kamang gareting wa adi kamang diok wa kabak wa ma napa'ni wari tungkum tanga kapmo' mo' sebiting. Mokngang adi kamang u garinga ning tanga bema sirengsa' tabinga napa'napa' fam ka kama kangkam ganang kapmo' adenting wari sirengsa' kadofiinga yapmanting. ");
INSERT INTO uvh_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Beng sini' kadapmang ka aming wari u titing ningda'ning wa inga' Anutu wari nasi' nasi' ki a sasuk ning ki a napa'napa' fam ning ki ka kami yara'ganang kapmo' adeing wa sirengsa' ubu ifakadofiinga yapni'ga'. ");
INSERT INTO uvh_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Sidi sasuk guk wa midi i torik ya kafakafa sura nakedanting. ");
INSERT INTO uvh_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Ning tanga nua'bu yanggu', midi ka i sanotik ya ninak sa' mo' tanga kabinting, mokngang sidi naknga bema titi tinting. Tanga aming fam ga' iminga Anutu wari fam nua'bu samota'. ");
INSERT INTO uvh_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Beng sini' nasi' tangkunang ka Anutu wari aming ni ga' amota' ka adi tangkunang wara'ning kane didimeng beng guksa' tota' wa Anutu adi tangkunang kabi'mo' nua'bu amota'. A aming ka nasi' tangkunang ka Anutu wari amota' u bema kane ni guk mo' tota' wa tangkunang ka wa kabasirangam tanga anganga kabasi'sini' ikinga inga' Anutu wari u tubobu irombemnainga adi nafek sa' tanga irota' ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","27","Ka Jisas wari midi nua'ni ning yanggu', Anutu wari adining bining u tipkadofi wara'ning tipfarani wa ning, aming wari napa' mindip feng ganang ipmiting wari kadofinga giragating wa aming wari mo' tinga kadofiting. Mokngang adi iipmi sa' tanga kabinga adi dama dek a kane fam ning u nakube sa' tanga kapmera fatingainga napa' mindip adi anasa' kadofinga giragating. ");
INSERT INTO uvh_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Giranga ning tanga tim munumung ka mundung sa' kadofinga sasa' tanga bapmo wari giranga aranga ning tanga beng wa wara'ganang inga' titing. ");
INSERT INTO uvh_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Tanga adeia' beng wari kuraga tanga karenda sini' tinga wa feng tuang adi beng dudop ning kama wari kadofota' u kanga wa dopma manggakna titing ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Ning tanga Jisas wari Anutuning bining wara'ning midi tipfara nua'bu tanga ning yanggu', ");
INSERT INTO uvh_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Anutuning bining wara'ning midi tipfarani nua'ni wa ning, sidi firi mastet wara'ning mindip kuma'sa' yabiting adi dandamesi da'ning ka firi mindip fam ningda'ning mo' yating, mokngang wa kababi'sini'. ");
INSERT INTO uvh_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Ka aming wari u manggara fonga kamaganang ipmiting wa adi kadofinga girisi sini' giranga bang bang tanga yang wari yori girisa' manga dekning guk ubu yating. Ning tanga nasi' nasi' fam ka nana titining irobiting u irafakiting. ");
INSERT INTO uvh_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Ka Jisas wari ami taming u midi tipfara sa' tanga ina abugu' wa adi Anutuning bining u nakeda waraga' tanga napa' kamaganangni ka adisining dasi' wari kuma' yapma tanga iikning unggungsa' yora ina yaregu'. ");
INSERT INTO uvh_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Adi midi tosirenda sini' ni guk mo' tiamgu', ka inga' ananing arantagimni sini' guk anasapmo'sa' mera wara'ganang wa giri sirengsa' fainarugu'. ");
INSERT INTO uvh_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Ning tanga kama kibiri dainga Jisas wari arantagimni u ning yanggu', sidi abubu tini' indi gwang fugung tubo do waraga' ubu mantam. ");
INSERT INTO uvh_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Ning ininga arantagimni adi aming arantagim girii u ibinga anga bot ka Jisas wari tim kuma' aranga mera aming ga' midi fiamgu' wara'ganang aranga mera Jisas u nagiknanga mugo tiging. Ka aming fam adi u yapma adisining bot ganang aranga mera Jisas se' u mandang iwara mugoging. ");
INSERT INTO uvh_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Ka Jisas se' adi bot ganang u aranga mera anganga gwang bining do aramugoinga gugubik kigineng girii wari marara abanga bot wara'ganang amanga beronga tugu'. ");
INSERT INTO uvh_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Ka Jisas adi bot ning basing mandang ganang do dama kareng sini' defagu'. Ka arantagimni wari gugubik girii u kanga mutu tanga Jisas u tipseganga ku katinga ning toging, ai girii bibi' tonga tem ya mo' wa karang, gu dama ka tangkunang sini' wa indining detang. ");
INSERT INTO uvh_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Ka Jisas wari u naknga seganga marara ning tanga gugubik girii u kanga midisa' ning togu', a bibi' te'. Ning tuguyinga gugubik kigineng girii wari kaga'sa' dagagu'. Ning tanga gwang sasabara girii undu' midisa' ning anigu', kugura tanga gi'sa' deire'. Ning aniinga kaga'sa' kuranga amanga gi'sa' ubu deiagu'. ");
INSERT INTO uvh_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Ning tanga arantagimni u ning yanggu', ai sidi mutu ba ting. Ma sabarik sidi nagata' naktangka ting waa. A sidi nagata' naktangka tang guk mo' ting sabarik ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ka arantagimni adi Jisas wari napa' girii tugu' u kanga base tanga anasa' ning toging, ai ya nasi' aming ya gugubik a gwang sasabara girii ka midisa' ininga bibi' guk ya ning toging. ");
INSERT INTO uvh_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Ning tanga anganga gwang fugung kama tubo Geresa tara' u kadofiging. ");
INSERT INTO uvh_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Kadofinga ning tanga bot u kabinga bemkura aramugoging ka aming mini unggo kadagang guk magi papeng nua'ni wari aming kungkumosi ning kama ginang ganang detarugu' u kabinga abanga Jisas ganang kadofigu'. ");
INSERT INTO uvh_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","4","Aming ka wa mini unggo kadagasi wari taramakinga dama dekni wa kama ginang ka aming kungkumosi fonga fukukiabiaging ganang unggungsa' dera fentarugu'. Abanga adining tangkunangni wa kabasi' mo', fikifiki amine wari sen kigineng wari kayong kafong iip ga' ning tonga fatiaging udi mokngang, adi sen u udanga base bimanga famarugu'. Ning tinga bimbem guk mo' fatiaging. ");
INSERT INTO uvh_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Ning tanga tiim sidii fikifiki adi aming kungkumosi ning kusik ganang a kama bubo a gwaya base indeng u pipenga yangara ku katinga uningkim mini guk wari ananing fugu u dopma ning tanga fentarugu' u katuaging. ");
INSERT INTO uvh_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","8","Aming ka wari Jisas u kamani sa' tabang kanga urapsa' unara abanga Jisas ning kayong ganang u manda upma marekinga Jisas wari ning anigu', mini unggo kadagang gu aming i kagabi te'. Ka aming wari ku ning katigu', o Jisas gu Anutu kigineng sini' adining mindingni gu nasi' tanabonga abarang. Anutu girii ning wap ganang beng guk sini' ning ganarik, gu napa'ni mo' tanabotang. ");
INSERT INTO uvh_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Ka Jisas wari ning anigagu', ka guning wapka wa nisi'. Ka aming wari ning togu', indi aming siamo' ikem wara' indining wapni' wa amingkure. ");
INSERT INTO uvh_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ning tonga ning tanga Jisas u tangkunang ning anigagu', o bibiri' sini' gu mini unggo kadagasi wa kamani sini' mo' yangkagarenamotang. ");
INSERT INTO uvh_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","12","Ning tinga mini unggo kadagasi wari maga arantagim girii ka kama kagarangga' ganang du' unggung fenga faminiging u yapma Jisas u ning anigaging, ka indi aming i kabinga wa indeng mantam gu indibi sa' tinga maga do wara'ganang anga amayapmantam wa giri. ");
INSERT INTO uvh_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Ning tuguinga Jisas wari nakiam sa' tanga ibiinga mini unggo kadagasi adi aming u kabinga anga wara'ganang ubu anga amayapking. Ning tinga maga wari kama karang u unara tabasinanga gwang ganang apa mangfanga ning tanga ama gwang u topnanga wadigi'sa' kumaksasu'neging. Ka maga u kumoging wara'sining nambasi' wa 2 tausen ning wari kumoging. ");
INSERT INTO uvh_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Ning tinga maga wara'sining yaptatora aming wari u kanga bima tanga yongganang ga' anga amise u ina a aming ka yong kababi' fam ganang ira yariaging u ina yaranga ning tiging. Ning tinga aming adi midi u naknga napa' ka u kadofigu' u ana sini' ubu kadidimonga marara abiging. ");
INSERT INTO uvh_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Abanga Jisas se' ganang u kadofinga ning tanga kaging wa aming ka mini unggo kadagasi wari amanga papenga fentarugu' udi tubobu kuma' karendanga sasukni natama ning tanga nip ubu tamnanga merafagu'. U kanga base tanga mutu tiging. ");
INSERT INTO uvh_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Ning tanga adeinga aming ka Jisas wari napa' u tinga yapking wari midi ka aming wari karenda tugu' a maga wari mangfanga kumoging wara'ning u ina yareging. ");
INSERT INTO uvh_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Ning tanga kama tubo Geresa yong ki wara'ni aming wari Jisas wari kama ka u kabinga mugo titi waraga' anadide tiging. ");
INSERT INTO uvh_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Ning tanga Jisas guk ka arantagimni guk adi aming u ibinga tubobu maunga bot ganang aranga mareiaging. Ka aming u karendagu' wari Jisas se' u mandang iwara abanga Jisas u ning anigu', o aming girii na sidigok kubap dabik mantam. ");
INSERT INTO uvh_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Ka Jisas wari ning anigu', mo' gu ingging yakangga' tubobu anga napa' ka Anutu wari guta' bibiri' naknga napa' girii tagamara' yara'ning midi waraga' amige fam u inotang. ");
INSERT INTO uvh_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Ning anisefinga kabinga mugoinga adi yoringga' tubobu anga kama tubo Dikapolis tara' wara'ning yong yong u yangara napa' tangkunang ka Jisas wari tangamgu' wara'ning midi u yangsasu'na tanga yaregu'. Ning tinga ami taming wari midi u naknga base tanga ikiaging. ");
INSERT INTO uvh_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Ka Jisas guk ka arantagimni guk wari kama tubo Geresa u kabinga bot ganang tubobu anga Galili tara' u kadofiinga aming arantagim girii wari gwang gaga ganang u bak girii nua'bu abanga tiging. ");
INSERT INTO uvh_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","23","Ka wara'ganang siring yak katatora ning aming girii nua'ni wapni Jairas wari abugu'. Abanga Jisas u kanga ning tanga Jisas ning kayong ganang manda upma irema mera ning anigu', o girii naganing yapna bagana mamareng sini' tara' kabi'sini' kungkumak tota' wara' gu anga suronaminga tubobu seranga marara ka' iknamo', ning anigu'. ");
INSERT INTO uvh_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Ka Jisas adi aming girii wara'ning midi u nakngam sa' tanga mandang yaranga agu'. Ning tinga ami taming kabi'mo' adindu' Jisas u mandang yaranga anga tipkagade sini' tang tanga aging. ");
INSERT INTO uvh_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Ka wara'ganang taming nua'ni ka bagana kadagang amaa so ka kama paramu' gurak 12 ning sini' kuma' tanga yagu' adindu' Jisas u kanga marara mandang iwara anga aming bak girii tanga mugoging wara'ning bining ganang ira mugoging. ");
INSERT INTO uvh_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Taming ka wa baganani tangkunang waraga' tanga dokta ganang fikifiki anga uningkim mambong girii sige fagabarugu', ka dokta adi baganani wa tipmiringam guk mo' tiaging. Ning tinga bagana wari giraga giraga tugu'. ");
INSERT INTO uvh_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","29","Ka adi Jisas wari napa'napa' tangkunasi tanga yaregu' wara'ning midi u kuma' naknga yagu wara' adi Jisas wari agu' u kanga baganani wari bingam waraga' sura ning suku', na Jisas ning kwi' kapmo'sa' tifema wara'ganang karendotik. Ning sura marara aming bak tanga aging wara'sining bining ganang amanga anga Jisas ning kwi' u kapmo'sa' tifemgu'. Tifeminga baganani wari kaga' wara'ganangsa' bingaminga taming adi fuguni ararangeng karengsa' ubu naknga ning suku', o bagana kuma' ba binabara'. ");
INSERT INTO uvh_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Ka Jisas adi tangkunangni dibing mugogu' u kuma' nakedanga farang yapma ning yangkagu', ai naganing kwi' ya nisi' wari tifemara'. ");
INSERT INTO uvh_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ka arantagimni wari ning aniging, a girii aming kabi'mo wari guta' bak tanga tifemgabing wa ni' wari tifemnabara' ning guk wa indining torang ning aniging. ");
INSERT INTO uvh_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Ka Jisas adi aming titi sini' tugu' u katua waraga' ko deiangagu'. ");
INSERT INTO uvh_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Ka taming adi baganani wari Jisas u tifemgu' ganangsa' bigu' u nakedanga mutu tanga paparap tanga anga Jisas ning kayong ganang u mangmungkupnanga mera ning tanga midi ka tim bagana wari taramikinga tanga itarugu' a Jisas u tifeminga karendagu' wara'ning u ituangama yaregu'. ");
INSERT INTO uvh_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Ka Jisas wari ning anigu', o taming gu nagata' naktangka tarang warisa' tanga wadigi' kuma' karendarang, bagana ka wa nua' mo' bemgabo' mokngang. Gu tubobu anga kareng gi' ningsa' ubu ira autang ning anigu'. ");
INSERT INTO uvh_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Ka Jisas wari taming u midi ko aranigu' ganang ka aming fam ka aming girii Jairas ning yak ganang kane tiaging wari abanga kadofinga Jairas u ning aniging, ai Jairas yapka udi kuma' kumata' kanga abem, ka gu tisa wa sige ma nagira aya' ning toging. ");
INSERT INTO uvh_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Ka Jisas adi adisining midi u naknga Jairas u ning anigu', gu midi ka u abanga toing u naknga mutu mo' totang gu nagata' naktangka sa' te' ning anigu'. ");
INSERT INTO uvh_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Ning tanga Jisas wari aming arantagim girii wara'siguk ka ananing arantagimni fam guk wa unggung yangsefinga ning tanga arantagimni famineng sa' ka Pita a Jems iguyangguk Jon ya ning unggungsa' inagira ning tanga aging. ");
INSERT INTO uvh_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Ka siring yak katatora ning aming girii ning yak ka ibingini kabasi' wari defagu' ganang u kadofinga ning tanga yapking ka aming wari taming kabasi' kungkumong u mak kang kara napa' mumburang kabi'mo' fatiangaging. ");
INSERT INTO uvh_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","U yapma Jisas wari yak iyung bane u amanga aming u ning yanggu', ai mak kara napa' mumburang guk wa nasi'ga' ting. Taming kabasi' ya kungkumak mo' tara, mokngang ya damasa' deta' ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Ka aming adi kungkumak sini' tugu' udi kuma' kaging wara' adi Jisas wari midi ka damasa' deta' ning yanggu' u naknga midi fifiring ningda'ning naking. Ning tanga Jisas u kanggaga tanga anikige tiging. Ka Jisas wari aming ka mak anga mera fugoging u yangkagarenga ning tanga taming kabasi' wara'ning mengbe guk ka ananing arantagimni famineng ungungsa' inagira sababa kabasi' wara'ning iyung bane u amoging. ");
INSERT INTO uvh_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Amanga kadofinga Jisas wari sababa kabasi' kungkumak tanga defagu' wara'ning kafong u suronga Hibru anasining midiganang ning anigu', talita kumi. Ka midi ka u togu' wa sababa kabasi' mamarak te', ning anigu'. ");
INSERT INTO uvh_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Jisas wari midi u aninga suronga tipmarakinga taming kabasi' adi kaga'sa' seranga marara ning tanga kadap arengagu'. Ka taming kabasi' wara'ning gurakni wa 12 ning u tipmaragu'. Ning tinga saba kabasi' wara'ning mengbe wara'guk ka Jisas ning arantagim famineng guk adi napa' u kanga base tiging. ");
INSERT INTO uvh_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Ka Jisas wari ning yangsefigu', napa' i kaing ya aming fam mo'sini' yangting. Ning ina ning tanga mengbe u ning yanggu', giri nana kabi' amiinga nawa'. ");
INSERT INTO uvh_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Ning tanga Jisas adi yong ka u kabinga arantagimni u inagiknanga Jisas ananing yong ki Nasaret ga' tubobu mugoging. ");
INSERT INTO uvh_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Anga kadofinga iya' mengkura ning kama sabat wari kadofigu'. Wara'ganang ka Jisas wari siring yak ganang amanga aming u Anutuning midi kareng ituaimgu'. Ka aming kabi'mo' wari Jisas ning sasuk girii u kanga ning tonga yareging, ai aming ka ya midi a sasuk kareng ka ya inga'sa' wa indeng katuanga bema abanga tora'. Abanga napa' kane tangkunasi fam undu' tanga yarara' wa indining tanga tara'. ");
INSERT INTO uvh_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Indi mamaram mo' fafongsa' katam adi kamanda kane tita', adining mengni wa Maria yang a kuyane wa Jems a Joses a Judas a Saimon se', abanga kuyane taming undu' ingging i fengaking yang. Ning tonga aming sige ning kanga bibi' nakngamging. ");
INSERT INTO uvh_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Ka Jisas wari ning yanggu', beng sini' aming adi ning titing, midi tokadofi aming profet wa yong fam adi giri aming girii ning kanga adining midi nakngam sa' titing a aming ka ananing arantagim a yong ki sini' adi aming sige amisi'sa' ning kanga adining midi nakngam ga' bibi' nakiting. ");
INSERT INTO uvh_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Ka Jisas ananing yong ki aming adi Jisas ga' naktangka guk mo' tiging waraga' tanga Jisas adi yong ka wara'ganang wa kane tangkunang mirakel wa mimeng mo' tugu' mokngang, adi bagana aming kubanik kubaniksa' tanga ifimaragu'. ");
INSERT INTO uvh_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Aming ka Jisas ananing yong ki wari adita' naktangka guk mo' tiging u yapma Jisas adi waraga' sasuk mimeng tugu'. Ning tanga iibi tanga anga yong kababi' fam ka wara'ning du' ikiaging wara'siga' Anutuning midi kareng ituaima yaregu'. ");
INSERT INTO uvh_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Ning tanga Jisas wari arantagimni 12 u adining midi itua kane a adining kane fam u anga titi waraga' fama' fama' sabarayapma yangkaronga fabanga kukyapma ning tanga mini unggo kadagasi tanga iguk ning tangkunang u yamgu'. ");
INSERT INTO uvh_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","9","Midi ka wa ning yanggu', fuksi' yotangka ning mambong guk mo' manggakanting. Nana a kwi' a ari' mambong guk mo' manggakanting, tasase a kasi' giknim ka kuma' ipmanga adeing unggungsa' tanga tong mangaknanga ningsa' tanga mani'. ");
INSERT INTO uvh_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Anganga yong nua'ni ganang kadofinga wa aming ka tim katisanota' wara'ning yongganangsa' anga dekanting, yak ka wara'ganangsa' deia' mugo tonga wara'ganangsa' kabinga mani'. ");
INSERT INTO uvh_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","U deia' marara yong nua'niganang ubu anga kadofiinga yong ki wari kafakafa guk mo' tasapma sidining midi ga' bibi' naksaminga wa sidi adi sapkedanga o indi kadagang tangam wara' adi wadigi' ba indibinga maing ning tutugu waraga' kasi' susu u adisining dasi'ganang difimiama ning tanga iibi sa' tanga mani'. ");
INSERT INTO uvh_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Jisas wari arantagimni u ning ina yangkareinga mugoging. Anga yong yong u kadofinga dera yangara midi ning ina yareging, o aming sidi kadagang tanga iking u kabinga kabaksi' farani'. ");
INSERT INTO uvh_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Ning ina ning tanga aming ka masi' unggo kadagasi guk wara'sining masi' unggo kadagasi u tanga igukiama ning tanga bagana aming kabi'mo' u ibang toyama wel fuksi'ganang sufuraima ifakarenda ning tanga yangaging. ");
INSERT INTO uvh_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Ka Jisas wari napa'napa' kane tangkunasi tanga yaregu' wara'ning midi ne wari kama tubo wara'ning yong yong u dabiksa' kuma' mugosasu'neinga naking. Ka aming girii Herot adindu' kuma' naku'. Ka aming adi ning toging, Jon Baptis urang kumogu' wari tubobu marara tangkunang girii guk tanga abara'. ");
INSERT INTO uvh_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","A fam ka ning toging, profet timini Ilaija wari tubobu abanga tanga yarara'. A fam ka profet ka tim tanga yaging ningwara' wari abanga tara', ning tonga yareging. ");
INSERT INTO uvh_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Ka aming girii king Herot adindu' kuma' naknga ning togu', o udi Jon Baptis ka naga ininga kadare urang doptagaging warisa' tubobu marara tanga abara'. ");
INSERT INTO uvh_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","19","Ka tim Herot wari ininga Jon Baptis gufadagaging wara'ning midi wa ning tiging, tim Herot wari kuyang kabasi' Filip ning tamni Herodias u iromkadara sanagu'. Ka Jon Baptis wari u kanga fikifiki ning anga fanirugu', a Herot gu kadagang tangang kuyaga kabasi' ning tamni ya nasiga' iromkadara sanangang ning fanirugu' waraga' tanga Herot ning tamni Herodias wari u naknga Jon ga' kaba kadagang sini' nakngama ning tanga ufini Herot u aniinga Herot wari arantagimni yangkareinga anga Jon u bema kayong kafong ipma ipma bema tabanga iyung dasiinga kalabus kane tanga itarugu'. Ning tanga Herot ning tamni Herodias wari Jon u uuk titiga' ning tonga faturugu' de ka ufini Herot adi bibi' fanakngamarugu'. ");
INSERT INTO uvh_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Ka Herot adi Jon ning midi u naknga Jon u aming didimeng kareng Anutu wari anigaregu' ning u kuma' kanga kigedanga mutu tanga Jon ning midi u ninak ga'sa' fanakarugu' wara' adi Jon u uuk titiga' bibi' naknga kafagafasa' faturugu'. Ka Jon adi Herot ning kadagang u sirengsa' faituarugu' waraga' tanga Herot adi susuk mimeng tanga kaba mamareng guk naknga itarugu'. ");
INSERT INTO uvh_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Ning tanga iya' inga' Herot wari kama ka mengni wari iibe tugu' wara'ning u katuanga tangsana tugu' ganang wa tamni Herodias wari Jon uuk ga' fasukarugu' wara'ning kadapmang guk kuma' adegu'. Ka Herot wari tangsana waraga' kiap girisi a ami'ning aming ning girisi fam a Galilini aming girisi fam u katiana abanga ning tanga tangsana wara'ning nana u mera naging. ");
INSERT INTO uvh_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Ka Herot ning tamni Herodias ning ibingini girii wari anapmo' amanga ning tanga aming girisi wari nana mera naging ganang u meyam tugu'. Ning tinga Herot guk ka aming girisi nana mera naging wari taming wari meyam tugu' wa karengsa' kanga ning tanga Herot wari taming sababa u ning anigu', ai karengsa' merang gabarik wara' na napa'ni gamotik. Ka gu nasiga' nakarang wa sirengsa' tuguinga gamok. ");
INSERT INTO uvh_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Ning aninga ning tanga midi tangkunang sini' nua'bu anigu', beng sini' torik nasi' nasi' gu naga ganggam ga' toutang wa na ganggam sa' totik. Gu naganing nasi' mambong girii u udagam ga' toutang wa na bining sini' udanga ganggam sa' totik ning anigu'. ");
INSERT INTO uvh_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Ning tinga sababa adi Herot ning midi u naknga mime aratugu' u kabinga fugang amanga mengni u ning anigagu', simeng nasi' nanam ga' anotik. Ka mengni Herodias wari Jon Baptis uuk ning kadapmang u katuanga ning anigu', Jon ning ki kati ga' nakarik ning anga ane'. ");
INSERT INTO uvh_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Ning aniinga tubobu urapsa' amanga Herot u ning anigu', na Jon Baptis ning ki kati kami sa' gafa ganang kaminam ga' nakarik. ");
INSERT INTO uvh_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Ka Herot adi sababa ning midi u naknga kaba mamareng sini' ubu naku'. Ka adi sababa waraga' napa'ni amimi sa' titi waraga' midi aming girisi fam ning dasi'ganang kuma' totangkagu' waraga' tanga Herot adi kubase' sini' aigangamgu'. ");
INSERT INTO uvh_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Aiganga ning tanga Herot wari aming nua'ni kaga' wara'ganangsa' anigareinga anga kalabus yak iyung bane u amanga ning tanga Jon u ugumogu'. ");
INSERT INTO uvh_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Ning tanga Jon ning ki kati u doptanga bema gafa ganang kaminga ning tanga bema tonga sababa waraga' amigu'. Ning tinga sababa adibu bema tonga mengni Herodias ga' amigu'. ");
INSERT INTO uvh_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Ning tinga Jon ning arantagim adi midi ka Jon u kuma' uking u naknga Jon ning bapmo u anga bema tonga kama ginang ganang kamiging. Ka inga' Herot adi kane tangkunang ka Jisas wari tanga agu' wara'ning midi ne u naknga base tanga a udi Jon urang ukuk warisa' abara' ning togu'. ");
INSERT INTO uvh_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Ning tanga Jisas ning arantagim ka Jisas wari midi itua kane titiga' yangkaregu' wari kane u kuma' tasasu'nanga ning tanga Jisas kaunga tubobu abiging. Abanga kadofinga Jisas u nasi' nasi' midi ka adi kane tanga ingaging wara'ning u aninga yareging. ");
INSERT INTO uvh_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Ka Jisas wari adisining midi u naknga ning tanga aming wari adiganang bak girii fikifiki abanga fatinga adi nana a mengkura kafagafa guk mo' fatiaging waraga' tanga Jisas wari arantagimni u ning yanggu', indipmo'sa' kama nua'ni anga mengkura kafakafa tanga defakantam. ");
INSERT INTO uvh_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Ning ina ning tanga kama sigesa' aming guk mokngang waraga' maunga bot ganang aramugoging. ");
INSERT INTO uvh_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Ka Jisas se' adi aming bak siamo' fatiaging waraga' tanga kapmo' mantam ning tonga aramugoging ka aming kabi'mo' adi Jisas se' u kuma' fonga yapma ning tanga gwang gaga u unara yaranga anga kama ka Jisas se' wari anga kadofi ning u kuma' isefinga mera yareging. ");
INSERT INTO uvh_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Ka Jisas se' adi mandang inga' anga kadofinga bemkura anga ning tanga aming arantagim girii wari kuma' ipmefaging u yapking. Ka Jisas adi u yapma bibiri' yapku', adi aming nua'ni Anutuning kadapmang yangtinting ning guk mokngang waraga' tanga bibiri' yapma Anutuning midi u yanggeku'. ");
INSERT INTO uvh_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Ning tanga Jisas wari aming u Anutuning midi u yanggera anganga mayam de tipamoging. Ka Jisas ning arantagimni wari Jisas u ning aniging, ai girii kama kuma' garonga tara' yang ka kama ka ya nana guk mokngang sigesa' urang wang. ");
INSERT INTO uvh_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Ami taming ya yangkara tinga yong a kama fam ganang anga nana yapma tona yangakni'. ");
INSERT INTO uvh_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Ka Jisas wari ning yanggu', iyam tini' sida. Ka arantagimni adibu ning aniging, ai indi nana wa indeng kanga bema yamtam ya, aming arantagim kabasi' mo' adisita' nana stua ganang toiamtam udi moni girii 200 kina ning kabintam ning toging. ");
INSERT INTO uvh_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Ka Jisas wari ning yangkagu', ka sidi nana kafo kabi'guk wa, sa'anga yapkani'. Ning ininga anga yapma abanga ning aniging, indining nana kafo wa fama'sa', baret kababi' ka faiv a ama ging kafo wa fama' ningsa' adeing ning aniging. ");
INSERT INTO uvh_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Ning tonga Jisas wari kama bingking kareng u kanga arantagimni u ning yanggu', aming do ininga bak dawang dawang kura mera yarani'. ");
INSERT INTO uvh_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Ning ininga bak kababi' naro' naro' fam ka 100 a fam ka 50 ning kidanga kura mera yareging. ");
INSERT INTO uvh_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Ning tanga Jisas wari nana kafo baret a ama ging fama' u manggara kunim ganang kuta tarang degaranga adenga beni Anutu ga' ibang togu'. Tonga ning tanga arantagimni ga' upma iminga arantagimni wari u manggara aming ga' ima yareinga naging. Ning tanga ama ging kafo undu' ningsa' tanga yamging. ");
INSERT INTO uvh_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ning tinga aming aming dabik didimengsa' nibera ning tanga dibing wa iibi tiging. ");
INSERT INTO uvh_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Ka Jisas ning arantagim wari aming wari nana dibing nanga ibiging u manggara fabanga bak tanga unup ari' ka 12 ning wara'ganang dasitoneging. ");
INSERT INTO uvh_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Ka aming nana u naging wa kabi'mo' ami a taming a sababi' ning dabiksa' wari naging ka adi ami ning namba sa' indangiking wa faiv tausen ning, taming a sababi' wara'guk mo' indangiking. ");
INSERT INTO uvh_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Ning tanga kibiri sini' mayam de kuma' amanga sebonga tugu' ganang ka Jisas wari arantagimni u ning yanggu', Betsaida yongga' mantam. Ka sidi bot ganang aranga mera tim mani', na aming i yangkarasasu'nanga mandang kuma' autik. Ning ininga arantagimni adi bot ganang tim mugoging. ");
INSERT INTO uvh_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Ning tanga Jisas adi aming u yangkaranga adi mugosasu'neinga anapmo'sa' adenga kama bubo ganang ubu aregu'. Aranga mera beni Anutuga' ibang fatogu'. ");
INSERT INTO uvh_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","48","Ning tinga kama kuma' garegu'. Ka Jisas adi arantagimni u fonga yapku' ka gaga kabi'guk mo' anga kadofiging mokngang, adi gugubik girii ga' tanga kane girii tanga gwang bining sa' ko famugoging. Ka Jisas adi u yapma urap mo' anga yapku', adi ibang tonga anganga tiim bining sini' inga' iwara anga gwang furo'ning tipminga agu'. Anganga kama kuma' faunga tugu' ganang arantagimni u anga yaptuagu'. Yaptuanga ning tanga gagaga dota' ning u irafiku'. ");
INSERT INTO uvh_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","50","Ka arantagimni adi u kanga napa' kadagang ni ba kayam ning tonga ku ning katiging, ai u kani' wa nasi' wari aramara', udi aming uring unda' ning toging. Ka Jisas adi mutu tiging u kuma' fabanga yapkedanga ning katianggu', mutu mo' tinting nagasa' abarik. ");
INSERT INTO uvh_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","52","Ning ina ning tanga abanga bot wara'ganang aranga marekinga gugubik girii fabagu' wa wara'ganang wadigi' bigu'. Ka arantagimni adi Jisas ning tangkunang u kigeda guk mo' tanga napa' Jisas wari tinga kaging waraga' sura base tanga sasuk mimeng ko tanga mafaging. Adi tim sidii ganang Jisas wari aming siamo'ga' nana tipkadofiaminga naging waraga' a inga' Jisas wari gwang furo'ning tipminga agu' undu' kigeda guk mo' tiging wara' adi Jisas u kanga base tiging. ");
INSERT INTO uvh_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Ning tanga anga gwang gaga tubo yong Genesaret tara' do kadofiging. Anga kadofinga bemkura ning tanga bot u ara iptatangkaging, ");
INSERT INTO uvh_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","ka aming yong wara'ni adi Jisas u urapsa' kuma' kigedaging. ");
INSERT INTO uvh_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Kanga ning tanga yong yong u unara anga bagana aming kabi'mo' u ipma manggakyapma abiging. ");
INSERT INTO uvh_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Ka Jisas adi kama ka wara'ganang wa bagana aming ifamarak ning kane sa' tanga agu', adi yong girisi a yong kababi' u anga kadofiinga wa aming wari bagana aming ipma manggara fabanga kama bining ka aming wari bak tiaging wara'ganang kura Jisas u ning faniaging, o girii guning kwi' sa' tifemting udi giri wa, wa kane girii sini' mo' totang. Ning aniinga Jisas adi aigaim sa' tinga bagana aming kabi'mo' wari Jisas ning kwi' sa' tifema karendanga yareging. ");
INSERT INTO uvh_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Ka Farisi arantagim guk ka sasuk aming fam ka Jerusalem yong girii u kabinga abiging wari Jisas ganang abanga kadofiging. ");
INSERT INTO uvh_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Ka wara'ganang wa adi Jisas ning arantagimni wari nana naunga kafasi' yotik ka Juda aming wari adisining kadapmang tang ganang yaranga tanga niaging ning guk mo' tanga naging u kuma' yapking. ");
INSERT INTO uvh_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Ka Farisi a Juda aming fam adi ning tiaging, nana naunga undu' kafasi' yotik ka kadapmang tang ka papase wari timinggi' kuma' tanga ira abiging u yaranga tiaging. ");
INSERT INTO uvh_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","A maket ganang anga yangara abanga undu' kafasi' guk sa' yotikiaging. Abanga adisining sungkwang a gafa a kabak undu' kadapmang ka u yotik ningwara'ganangsa' yaranga yotik guk sa' tiaging. Yotira ning tanga nana wa inga' wara'ganang niaging. ");
INSERT INTO uvh_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Wara' Farisi a sasuk aming adi Jisas ning arantagim wari nana naunga kafasi' guk mo' yotira naging u yapma anga Jisas u ning anigaging, ai indining, guning arantagim adi Juda indining papane ning kadapmang tang wara'guk mo' sura kafasi' geng guk sansaramik sa' ba manggara ning. ");
INSERT INTO uvh_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Ka Jisas wari ning yanggu', a kuma' sabarik sidi aming fam wari aming karesi ba ning tonga sasap waraga'sa' sura fating. Tim profet Aisaia adi kuma' sapkedanga midi ka sidining kadapmang waraga' didimengsa' Anutuning midi ning kuma' yoksamgu', ");
INSERT INTO uvh_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","“aming arantagim ka wa nagata' ibang wa masi' wari using sigesa' fatoing, nagata' kabaksi' guk mo' kufara toing. Adi naga nangmamangnem ning tonga aming kamaganangni ning kadapmang sa' yaranga tanga aming u ya Anutuning midi ning wa sige faining wara' na adisita' bibi' nakyamitik ning tuguinga yoku'.” ");
INSERT INTO uvh_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Ka beng sini' kuma' sabarik sidi Anutuning midi u kabinga ning tanga aming kamaganangni sidining kadapmang sa' ubu yaring. ");
INSERT INTO uvh_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Ning ina ning tanga ning yanggu', ka sidi sidaning kadapmang u yara waraga'sa' naknga unggungsa' surotangkanga Anutuning midi wa bema tipmakurati titing. ");
INSERT INTO uvh_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Ning tanga sidi kadapmang kesini nua'ni ka ning fating, tim Anutu wari adining midi tangkunang ka Moses aniinga Moses wari togu' wa ning, gu mamangga babangga kafakafa tiabotang a aming ka mengbe midi kadagang sansaramik inota' wa ugumak tinting ning yoku'. ");
INSERT INTO uvh_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Ka sidi kadapmang ka u togu' u kabinga aming ning fainiting, aming ka uningkim mambong guk wa adi Anutuga' amimi ga' kuma' totangkauta' wa mengbe wari yotangkayap titiga' aniinga wa adi ning inota', mo' uningkim mambong ya Anutuga' amimi ga' kuma' totangkangak wara' mo' samotik ning inota' ning fainiting. ");
INSERT INTO uvh_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Ning tanga sidi midi ka u tiptangkaunga ning fatuguting, a beng guk napa' ka Anutuga' amimi ga' ning tonga kuma' totangka wa mamangse babangse nua'bu yotangkayap ning guk mokngang. ");
INSERT INTO uvh_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Sidi aming u kadapmang kadagang ka ning u fayanggeking wa sidi Anutuning midi wari sigening ningda'ning ubu kagadofi ga' fating. Ka sidi kadagang wa u torik unggungsa' mo' fating mokngang, sidi kadagang fam undu' fating ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Ka Jisas adi Juda aming girisi u ifang ina ning tanga ami taming sige ubu katiana ning yanggu', midi ka i sanotik ya kafakafa naknga suktangkanting. ");
INSERT INTO uvh_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Napa' sireng ning wari aming ning kabaksi' mang mo' amanga ifakadagating mokngang, napa' kadagang ka aming ning kabasi' mang ganang u kadofita' warisa' wa aming beng sini' ifakadagata'. ");
INSERT INTO uvh_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","(Aming ka sasuk guk wa midi ka i torik i kafakafa sura nakota', ning yanggu'.) ");
INSERT INTO uvh_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Ka Jisas wari midi u ina ning tanga ami taming u ibinga anga yak nua'niganang amogu'. Ka ananing arantagimni wari mandang yaranga amanga midi ka u yanggu' wara'ning kiga' anigaging. ");
INSERT INTO uvh_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Ka Jisas wari ning yanggu', sidindu' nafek ba ting. Midi wara'ning ki wa ning, nana a napa' fam fugang ning ka aming wari nana titing wari aming ning kabaksi' mo' amanga ifakadagating. ");
INSERT INTO uvh_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Mokngang nana wa napa' fugang ning wara' aming wari nana tinga kadapmangni ganangsa' yaranga anga kadofinga mugota' ning yanggu'. Jisas wari aming wa nana wari mo' ifakadagating ning togu' wara' aming indi ning nakantam, nana a napa' fam wa nanasa' titining tapni guk mokngang. ");
INSERT INTO uvh_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","21","Ning tanga nua'bu yanggu', aming ifikadaga wara'ning ki wa ning, aming anasa' kaba mang ganang do sasuk kadagang tipkadofiinga sasuk ka wari girii giranga ning tanga kadapmang kadagang titing. Adi kadapmang kadagang ka ning titing, ami a taming fam guk kadagang sansaramik fatiangak a kubu a aming nua'ni ura sep ");
INSERT INTO uvh_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","a tamni a ufini kabinga kadagang titi a anata' mambong siamo' manggakna ga'sa' ninak a kaba kadagang ninak a mandaga' a fuksi' ganang kadapmang mumungguk kadagang titi a aming nua'nining napa' kamamarenga nakadangam titi a aming fam midi sige yangbe a fuksi' bema aranga maasi' pipe mandaga' titi ning wa kadagang beng sini' titing. ");
INSERT INTO uvh_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Beng sini' sanirik, sasuk kadagasi ka ningwari aming ning kabaksi'ganang do kadofinga ning tanga aming beng sini' ifakadagata' a napa' fugang ning wa aming tipkadaga ning guk mokngang ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Ning tanga Jisas adi yong ka u kabinga kama tubo Taia yong tara' waraga' ubu agu'. Anga kadofinga aming bak mimeng fatiaging waraga' tanga mengkura kabi' totik ning tonga yak nua'niganang amanga kapmo'sa' mareiagu'. ");
INSERT INTO uvh_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","Ka yong wara'ni taming nua'ni adi ibingini kabasi' mini unggo kadagang wari amanga tipipenga faturugu' adi Jisas wari u agu' wara'ning midi udi kuma' naku' wara' urapsa' abanga Jisas ning kayong ganang u manda upma irema mera Jisas u ning anigu', o girii naganing yapna udi mini unggo kadagang guk ka gu u anga anikagarename'. Ka adi Juda taming mo' adi aming arantagim nua'ni Finisia kama tubo Siria tara' wara'ni ");
INSERT INTO uvh_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","wara' Jisas adi kuma' kigedanga ning anigu', nana wa tim ka sababi'ga' imiting wara' na sababi'ning nana i bema tim ka kugwang ga' imotik wa didimeng mo' ning anigu'. ");
INSERT INTO uvh_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ka taming adi kuma' nakedanga ning anigu', o beng sini' torang de girii ka kugwang adi sababi'ning nana kugo' ka nangifima titing undu' fafongsa' nating ning anigu'. ");
INSERT INTO uvh_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Ka Jisas wari adining naktangkani u kanga ning anigu', tangkunang sini' torang gabarik wara' yotangkagap tirik gi'sa' giri mautang, yapka ning mini' unggo kadagang wa kuma' tanga kayongamarik ning anigu'. ");
INSERT INTO uvh_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Ning tinga taming adi Jisas ning midi u ninaksa' tanga Jisas u kabinga yoring ga' tubobu anga kagu' wa beng guksa' ibingini wa mini unggo kadagang wari kabinga mugoinga kugurang kareng gi'sa' ubu defagu'. ");
INSERT INTO uvh_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Ning tanga Jisas adi kama ka Taia tara' u kabinga anganga Saidon yong u tarafira Galili gwang ga' maunga mugogu'. ");
INSERT INTO uvh_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ka kadapmang bining ka Dikapolis tara' u aramugogu' ganang ka aming fam wari aming nua'ni magi papeng midi kafagafa tutugu a ninak guk mokngang u nagira Jisas ana kaunga abiging u yaptuagu'. Ning tinga aming wari amisi' magi papeng u Jisas wari kafong wari suronga tipkarendaim ga' Jisas u tangkunang sini' aniging. ");
INSERT INTO uvh_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Ka Jisas adi adisining midi u nakyam sa' tanga aming magi papeng u nagira sasa' ning anasapmo'sa' anga ning tanga Jisas wari magi papeng wara'ning magi ginang u kafong yarimiyi wari sisingnanga a iguk songa bema mimbem ganang u gidengamgu'. ");
INSERT INTO uvh_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Ning tanga kunimganang kuta tarang degaranga adenga uring guk gimara midi o efata ning togu'. Ka midi wap ka efata u togu' wa tarara' te' ning togu'. ");
INSERT INTO uvh_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Ka Jisas wari midi u tuguinga magi guk ka mini guk dabiksa' wari kaga' wara'ganangsa' karendangamgu'. ");
INSERT INTO uvh_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Ning tanga Jisas wari amine nagira abu tiging u yangsefi tangkunang ning tugu', sidi napa' i tinga kaing ya aming fam mo'sini' anga yangting. Jisas adi yangsefi tangkunang ning kuma' tugu' de ka mokngang, adi napa' kuni' sini' tinga kaging waraga' tanga adi anga aming fam u ina yareging. ");
INSERT INTO uvh_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Ning tinga aming fam wari u naknga kabaksi' marara ning tonga yareging, ai beng sini' aming ka wa fikifiki napa' karesi tanga fiarara' fanakem. Ka kami aming magi papeng tipkarendainga midi naknga tutugu ning wa kaga'sa' udi beng wa tara' aa, ning toging. ");
INSERT INTO uvh_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Ka aming arantagim girii wari Jisas ganang bak girii nua'bu abanga tiging. Tanga anganga sanagimingsi' kuma' biamgu' u yapma Jisas wari arantagimni u ning yanggu', ");
INSERT INTO uvh_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","ai aming ya nagaganang bak kama famineng sini' ting ka nanasi' kuma' biaming ka na yapbubure siamo' tirik. ");
INSERT INTO uvh_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Aming fam ka kamani sini' abiging ka indi yaksingga' tubobu sigesa' yangkarantam wa adi anga dasi' pimpiring dipminga kadapmang bining ganang kumade ma tini' ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ka arantagimni adibu ning toging, ka indining tantam nasi' indeng bema yamtam, ya kama bining sigesa' urang wang nana ni guk mokngang ning toging. ");
INSERT INTO uvh_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Ka Jisas wari ning yangkagu', sidining nana kafo baret kabi' wa indining adeing. Ka adibu ning aniging, mo' seven ningsa' adeing. ");
INSERT INTO uvh_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Ning tuguinga Jisas wari aming u ning yanggu', kwang mekni'. Ning tinga kwang meksasu'nanga yareinga Jisas wari baret fama'sa' u manggara adenga beni Anutuga' mesisiringa tugu'. Tanga ning tanga upma arantagimni ga' iminga arantagimni wari u manggara ami taming wara'siga' ima yareging. ");
INSERT INTO uvh_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Ning tanga ama ging kafo kababi'sini' fama'sa' ka aming wari manggeging undu' manggara fonga Anutuga' mesisiringa tanga ning tanga upma arantagimni ga' iminga aming ga' ima yareging. ");
INSERT INTO uvh_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","9","Ka aming ka Jisas wari nana u iminga naging wa arantagim girii sini' ka fo tausen ning ningwari naging. Adi dabik didimengsa' nibera ning tanga dibing ka iibi tiging. Ka Jisas ning arantagim wari nana dibing nanga ibiangaging u manggara fabanga unup ari' seven ning sini' dasitoneging. Ning tanga Jisas wari ami taming u yangkara tinga mugo tiging. ");
INSERT INTO uvh_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Yangkaranga ning tanga arantagimni u inagiknanga bot ganang urapsa' aranga mera ning tanga kama tubo Dalmanuta ka gwang fugung waraga' mugoging. ");
INSERT INTO uvh_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Ka Jisas guk ka arantagimni guk wari u anga kadofiinga Farisi arantagim wari Jisas u mandaga' taramikonga abiging. Abanga kadofinga Jisas u ning anigaging, gu Anutuning napa' tangkunang ka ni tinga kanga wa indi o beng sini' gu Anutuning tangkunang guk ba itang ning tontam ning aniging. ");
INSERT INTO uvh_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Ka adi adisining midi u naknga fikifiki adi kane tangkunang titi ga'sa' faniaging waraga' tanga kaba mamareng sini' naknga uring guk gimara ning togu', o aming sidi Anutu ana nangkaregu' ning guk mo' nakedanga napa' tangkunang tasaminga dasi' wari kaga waraga'sa' fananing wara' na kami napa' tangkunang ni guk mo' tasaminga kanting mokngang sini'. ");
INSERT INTO uvh_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Ning ina ning tanga iibi tanga bot ganang tubobu aranga arantagimni guk gwang fugung ga' mabu tiging. ");
INSERT INTO uvh_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","15","Ka gwang bining ko arabiging ganang ka Jisas wari Farisi a Herot ning kadapmang mandaga' waraga' arantagimni u yangnatamonga ning yanggu', ai sidi Farisi arantagim a Herot ning arantagim napa' yis waraga' kafakafa denga ikni' ning yanggu'. Ka arantagimni adi nakube tanga baret guk mo' manggeging, kubaniksa' bemging ");
INSERT INTO uvh_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","wara' adi Jisas wari midi ka yis ga' togu' u naknga yis beng ga'sa' ba sura tora' ning tonga ning toging, ai baret urang nakubenga abangam waraga' unda' sura ninara'. ");
INSERT INTO uvh_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Ka Jisas adi sasuksi' kuma' yapkedanga ning yanggu', sidi baret ibinga mabinging waraga' sura sanirik ning tonga toing wa. Sidining sasuksi' wa indining wara' sidi naga midi fikifiki sana abarik wa nakeda guk mo' fating. ");
INSERT INTO uvh_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","19","Dasi' ka kigeda tanga a masi' ka nakeda tanga ning titi guk mo' wa indining. Na nana tipkadofi ning tangkunang guk wara' indi nana ga' nafek tanga wa na midi mimeng mo' toutik mokngang, na kuma'sa' tipkadofotik. Sidi tim naga aming faiv tausen ning wara'siga' nana iminga naging udi kuma' ba nafeking. Ka adi nagaremik tanga ibiging u manggara wa ari' wa indining dasiging. Ka aranatagimni adibu ning aniging, mo' wa ari' 12 ning dasitonegum. ");
INSERT INTO uvh_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Ning tanga nua'bu yanggu', a nua'ni ka aming bak girii fo tausen ning waraga' baret 7 ning sa' iminga naging wa adi nagaremik tanga ibiging wara'ning dibing wa indining dasiging ari' wa. Ka adibu ning toging, mo' undu' ari' 7 ning sini' dasigum. ");
INSERT INTO uvh_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Ka Jisas wari ning yanggu', beng guksa' toing de ka sidi naganing tangkunang waraga' nakeda sini' tini', na yis beng ga' mo' sura tongak kini nua'ni sura tongak u sura nakedani' ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Ning tanga abanga Betsaida yong u kadofinga mareiaging. Ka aming yong nua'nini wari aming de kadagang nua'ni u wenga nagira abanga Jisas wari suronga tipkarendaim titiga' aniging. ");
INSERT INTO uvh_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Ka Jisas adi nakyam sa' tanga aming de kadagang u wenga nagira tonga yong bibik ning u anasapmo'sa' adenga ning tanga Jisas wari de u iguk sombara sufurungama ning anigu', indining degaranga karang. ");
INSERT INTO uvh_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ning aniinga degaranga ning togu', mo' aming udi giri yabarik ka yapkeda sini' mo' tirik, uringsa' ka firi ki da'ning arengaking yabarik. ");
INSERT INTO uvh_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Ning tuguinga Jisas wari de u nua'bu surogu'. Suroinga tangkunang sini' nua'bu degaregu' wa aming a napa'napa' fam u sireng sini' ubu yapku'. Ning tinga de wa wadigi' sini' karendagu'. ");
INSERT INTO uvh_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Ning tanga Jisas wari aming u anisefi tangkunang ning tugu', yongganang sirengsa' mo' autang yak ganang kapmo'sa' maya' ning anisefiinga mugogu'. ");
INSERT INTO uvh_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Ning tanga Jisas guk ka arantagimni guk adi yong ka u kabinga yong kababi' ka yong girii wapni fama' guk aniaging Sisaria Filipai tara' waraga' ubu aging. Ka kadapmang bining ganang Jisas wari arantagimni u ning yangkagu', aming adi nagata' wa indining fatoing. ");
INSERT INTO uvh_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Ka adibu ning aniging, mo' adi ning faganing, Jon Baptis a fam ka Iliaja a fam ka profet girisi ka tim ikiaging ningwara' nua'ni ning fatoing ning aniging. ");
INSERT INTO uvh_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Ka Jisas wari ning yanggu', a sida wa indining fanabing. Ka Pita wari ning anigu', gu Anutuning Kasira Aming girii. ");
INSERT INTO uvh_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Ka Pita adi Jisas ning wapni bengsa' togu' waraga' tanga Jisas wari arantagimni u yangsefi tangkunang tanga ning yanggu', wap ka i toing ya aming fam wa mo'sini' yangting, sidisa' naknga ikni'. ");
INSERT INTO uvh_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Ning tanga arantagimni u midi sireng sini' ning ina yaregu', beng sini' ning sanotik inga' Amingning Tim Iyak nagaganang mamareng a kagaya girii wari kadofinamo'ga'. Aming wari nagata' bibi' naknga kadagang naramira bemnapma tonga aming fam ga' iminga nugumak sini' tini'ga'. Nukinga kumara kamaganang kama famineng ning ibinga tubobu seranga mararok ga'. ");
INSERT INTO uvh_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Jisas wari midi sirengsa' u iniinga naknga Pita adi midi ka waraga' bibi' naknga ning tanga anga Jisas ning kafong u wenga kabi'ning nagira tonga ning anisefigu', ai girii gu midi ka guguk tinga kungkumak guk wa indining torang, wa midi kadagang torang nakarik. ");
INSERT INTO uvh_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Ka Jisas wari arantagimni fam u faranga ifanga adenga Pita u ning kafanga anigu', a gu aming kamaganangni ning sasuksa' tanga Setan ning midi torang nakamarik wara' ning ganarik, gu Setan tataba te'. Gu Anutuning midi guk mo' sura nangsefi tonga tarang nakamirik ning anigu'. ");
INSERT INTO uvh_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Ning tanga Jisas wari ananing arantagimni guk ka aming sige fam ka unggung adeingaging u katiana fabanga kukyapma midi tangkunang ning yanggu', beng sini' aming ka ni naganing kane aming ning ironga wa adi sasukni ka iik kareng kamaganangni ga'sa' titi u udanga ning tanga mamareng girii sini' ka aming wari ugumak titi waraga' guk mo' sura nanawak sa' tota' wa karengsa'. ");
INSERT INTO uvh_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","A aming ka ananing fugu wari gi' ningsa' iikga'sa' sura a nugumak matini' ning tonga mutu tanga sige ningsa' irota' adi inga' kungkumakni ganang wa kamaganang ingging wadigi'sa' bisasu'no'. A aming ka naga nawara sibeng Anutuning midi kane tanga irota' waraga' tanga aming fam wari mamareng aminga ugumak tinting wa adi uringni wa ka' kareng fikifiki ningsa' irota'. ");
INSERT INTO uvh_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","A aming ka napa' kamaganangni karesi manggakna waraga'sa' sura tanga ira kangasi sini' kadofinga irota' wa adi inga' kungkumak tota' ganang wa mambongni wari uringni u yotangkangam ning guk mokngang. ");
INSERT INTO uvh_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Beng sini' aming ning uring wa napa' kabasi' mo', mokngang wa napa' girii kigineng sini'. A napa' mambong kamaganangni wa aming ning uring guk dabiksa' mo', wa napa' sige kuma' bisasu'na wara'ning. ");
INSERT INTO uvh_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Wara' sidi kafakafa sura nakanting, aming ka kadapmang sansaramik tanga Anutu beng guk kabinga Anutu mandaga'ga' mugo ning titing wa kabi'mo' kuma' iking. A aming ka naga nanawak ga' kuma' surota' de ka adi amine wari bibi' nakngam a midi anikige titi waraga' ubu sura bibi' nakota' wa adi inga' Amingning Tim Iyak naga kunim aming arantagim inagira sibeng Anutuning tangkunang kigineng girii guk ka diok girii guk tubobu afok ganang wa nandu' aming ka ningwara' wa kagabi tok ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Ning tanga Jisas wari nua'bu yanggu', beng sini' sanarik aming ka i adeing fam sidi ko mo' kumakinga ganang Anutuning bining wari tangkunang girii guk kadofasirendo' wa sidi kuma'sa' kani'ga' ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Midi u ina ning tanga iya' kama 6 ning ibinga ka Jisas wari arantagimni famineng ka Pita a Jems iguyangguk Jon ya ning unggungsa' inagira kama bubo girii nua'niganang naro' areging. Aranga kadofinga adenga ning tanga kaging ka Jisas ning fugu wari girigik tanga kuni' nua'ni sini' ubu kadofigu'. ");
INSERT INTO uvh_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Ning tinga adining kwi' kangkamani undu' fafa' sini' ka napa' kamaganangni ka ni ningwara'guk mo' ikita' ningwara' fagagu'. ");
INSERT INTO uvh_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Ning tanga yapking ka aming timini fama' ka Ilaija guk ka Moses guk wari urapsa' kadofinga abanga Jisas guk adenga midi aratoging. ");
INSERT INTO uvh_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","U yapma ning tanga Pita wari Jisas u ning urapsa' anigu', o girii indi gugok arapmam yaraga' wa karengsa' nakem wara' indi sidita' yak kababi' famineng masamtam, nua'ni ka guta' a nua'ni ka Moses ga' a nua'ni ka Ilaija ga' ning, ning anigu'. ");
INSERT INTO uvh_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Ka Jisas ning arantagim famineng adi aming famineng wari adeging wara'sining diok kigineng girii u kanga paparap senga mutu tanga Pita wari midi ka u sige toingagu'. ");
INSERT INTO uvh_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Pita wari midi u tuguinga ning tanga mungkong fafa' girii wari afanga tumukyapma midi nua'ni ka kunim ganang kuta afugu' wari mungkong wara'ning mang ganang ning kadofigu', aming ka u kaing wa naganing sabana kareng na adita' siamo' nakitik wara' nasi' midi adi touta' wa sidi nakngam sa' tinting ning togu'. ");
INSERT INTO uvh_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Midi ka wari kadofinga biinga Jisas ning arantagimni famineng wari midi wa nisi' wari tora' ning tonga deyangaging ka mokngang kamasa', aming fama' kadofinga adegumu' undu' kuma' kabinga mugoinga Jisas anapmo'sa' ubu adegu'. ");
INSERT INTO uvh_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Ning tanga kama bubo u kabinga afanga kadapmang bining ganang Jisas wari arantagimni famineng u yangsefi tangkunang ning tugu', sidi napa' ka i kadofiinga kaing yaraga' wa aming fam guk mo'sini' yangting, sidasa' sura ikianting. Inga' Amingning Tim Iyak naga tubobu marakinga wara'ganangsa' wa giri ituani' ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Ka midi ka Jisas wari u yangsefigu' wa inga' nua'bu guk mo' aniging. Ka anasa' wa giri ning toging, ai adi midi ka tubobu mamarak guk wa inding tora' ning tong tonga afiging. ");
INSERT INTO uvh_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ning tanga Jisas u ning anigaging, girii sasuk aming wari midi nua'ni ka ning fatuguting, Kasira Aming wari abonga wa tim ka Ilaija wari abo u kani' ning guk wa nasi'ga' fatuguting ning anigaging. ");
INSERT INTO uvh_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","13","Ka Jisas wari ning yanggu', midi ka wa beng guksa' Ilaija ning kane wa tim abanga kadapmang u tipdidima wara'ning. Ka aming ka ningwara' wa inga' ingging sini' kuma' kadofinga abanga tinga aming wari adita' bibi' nakngama adisining kabaksi' kadagang sa' yaranga kuma' urang ugumoging wang. Timinggi' sini' aming ka wari abubu waraga' wa Anutu wari midi kuma' tuguinga yoking wara' adi wara'ganangsa' yaranga abanga kadofiinga tiging. Ka adi midi nua'ni ka Amingning Tim Iyak wari abubu waraga' undu' ning yoking, “aming ka wari abuinga wa aming adi adita' bibi' nakngama kagaya girii aminga manda sini' ukngamni'ga' ning yoking ning yanggu'.” ");
INSERT INTO uvh_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Ka Jisas guk ka arantagimni famineng guk adi kama bubo u kabinga afanga kadofinga anga arantagimni fam ibinga areging wara'ganang anga kadofiging. Anga kadofinga ning tanga yapking ka aming kabi'mo' wari bak girii tanga Juda ning sasuk aming fam wari Jisas ning arantagim guk arok fatiging. ");
INSERT INTO uvh_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Ka aming kabi'mo' ka bak unggung kura faging wari Jisas wari nondani u nua'ni da'ning ubu kadofinga abugu' u kanga urasi' fungyanga kafaging. Ning tanga unara abanga Jisas ganang bak girii tiging. ");
INSERT INTO uvh_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Ka Jisas wari aranatagimni ka unggung ibigu' u ning yanggu', sidi nasi'ga' fararoking. ");
INSERT INTO uvh_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Ka aming arantagim girii ka Jisas ganang bak tiging wara'ning nua'ni wari Jisas u ning anigu', o girii gu ingging ba ning tonga naganing sabana i nagira abangak. Adi mini unggo kadagang wari tanga midi guk mo' tuguta'. ");
INSERT INTO uvh_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Ning tanga fikifiki adi mini unggo kadagang wari taramikinga kamaganang mangfanga mini fe dininga katapana titi ning tita' waraga' tanga nagira abanga gu girosinga guning arantagim u inak. Ka adi kuma' tinging de ka mokngang, adi tipkarendanam guk mo' tinging ning anigu'. ");
INSERT INTO uvh_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Ka Jisas wari aming wara'guk ka arantagimni guk ning u ifang yanggu', o aming sidi naktangka kabi'guk mo' ting. Na kama paramu'sini' kuma' sanggera abarik ka na nua'bu ko mo' sanggerotik. Ning ina ning tanga aming u ning anigu', saba kabasi' u nagiknam tanga abe'. ");
INSERT INTO uvh_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Ning tinga aming wari saba kabasi' u anga nagira abuinga mini unggo kadagang wari Jisas u kanga saba kabasi' u nua'bu taramakinga saba kabasi' wari Jisas ning de ganang unggung kumara mangfanga mini fe dininga siringgananga ingagu'. ");
INSERT INTO uvh_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Ka Jisas wari u kanga saba kabasi' wara'ning beni u ning anigagu', kungkumak ya inga'sa' tara' wa. Ka beni wari ning anigu', mo' timinggi' ginggiming ganang bemgu' ka ningsa' tanga abuta'. ");
INSERT INTO uvh_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Fikifiki kadagang wari taramakinga kudip ganang a ama ganang udi mangfu sa' tita'. Ka gu girisa' yotangkanapning ning kanga wa giri kabubure tanga tipmaraknam totang ning anigu'. ");
INSERT INTO uvh_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Ka Jisas wari ning anigu', gu nagasa' yotangkagam ga' torang. Ka gu nagata' naktangka sa' totang wa gu nasi' nasi'ga' toutang wa na kuma'sa' tagaminga kadofigaminga kautang. ");
INSERT INTO uvh_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Ka saba kabasi' wara'ning beni wari Jisas u ning urapsa' anigu', o girii na naktangka kuma' tirik de ka tangkunang sini' mo' tirik wara' gu yotangkanap tanga tiptangkanam te'. ");
INSERT INTO uvh_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Ning tinga aming wari bak girii tonga tiging u yapma Jisas wari saba kabasi'ning mini unggo kadagang u urapsa' anigaregu'. Ning anigu', a mini unggo ka amingning maasi' a masi' isefiam titing gu aming i kagabi tanga wadigi'sini' maya' tubobu guk mo' abotang. ");
INSERT INTO uvh_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Ning aniinga mini unggo kadagang wari saba kabasi' u kabonga ku bang katinga saba kabasi' u taramakinga paparap girii tinga kagabi tanga mugo tugu'. Ning tinga saba kabasi' wari kungkumak da'ning tanga kugurangsa' deiagu'. Ka aming adi u kanga kungkumak ba tara' ning tonga base tanga toging. ");
INSERT INTO uvh_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Ka Jisas wari kafong wenga tipmarainga marara karang tangkunang sa' ubu adegu'. ");
INSERT INTO uvh_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Ning tanga Jisas wari aming bak tiging u ibinga anga yak nua'niganang iyung ubu amanga mareiagu'. Ka ananing arantagimni wari anasapmo'sa' mareiaging ganang Jisas u ning anigaging, ai girii nasi' wari tanga indi mini unggo kadagang wa tangkayo guk mo' tangam. ");
INSERT INTO uvh_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Ka Jisas wari ning yanggu', napa' tangkunasi ningwara' wa sigesa' tanga yuguk ning guk mokngang, ibang warisa' wa napa' ningwara' u tanga kayoutang ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Ning tanga Jisas wari aranatagimni u inagiknanga yong ka u kabinga marara yong kababi' fam ka Galili unggung ikyangakiaging waraga' ubu mugoging. ");
INSERT INTO uvh_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Ka fikifiki aming wari Jisas ganang bak sa' fatinga Jisas wari arantagimni kafakafa guk mo' fianggeturugu' waraga' tanga kadapmang bining ganang anga arantagimni u yanggeronga ning yanggu', kapmo'sa' famantam. Ning ina ning tanga anga midi ning yanggera yaregu', inga' aming fam wari Amingning Tim Iyak naga bemnapma aming fam ning kafasi' ganang iminga adibu bemnapma tonga kadagang naramira ning tanga nugumak tini'ga'. Nukinga kumara deia' kama famineng ning ibinga inga' tubobu seranga mararok ga' ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Ka arantagimni adi Jisas ning midi u naknga midi wara'ning ki guk mo' nakedanga ning suking, o indi midi wara'ning kiga' nua'bu mo' anigantam soning ma to' ning sura sige ade sa' tiging. ");
INSERT INTO uvh_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Ning tanga anga Kapaneam yong do kadofinga Jisas wari yak nua'niganang amanga mera ning tanga arantagimni u ning yanggu', sidi kadapmang ganang do wa nasi'ga' tonga arora fabanging. ");
INSERT INTO uvh_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Ka arantagimni adi kadapmang ganang wa midi ka a na girii tim iyak a naga sirafatik ning tonga arora famugoging waraga' tanga adi kuma' nakedanga megang naknga midi tubobu guk mo' aniging. ");
INSERT INTO uvh_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Ning tanga Jisas wari arantagimni u fong kukyapma dabiksa' kura marekinga ning yanggu', beng sini' ning sanotik aming ka amine fam irafara girii tim iyak aming ning ironga wa adi ananing sasukni a fugu u bema afasasu'nanga ning tanga tim ka amine ning kane aming ning ira tiamota' wa giri. ");
INSERT INTO uvh_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Ning ina ning tanga saba kabasi' nua'ni u wenga nagira tonga kambiafinga mera arantagimni u ning yanggu', ");
INSERT INTO uvh_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","aming ka ni nagata' sura saba kabasi' ka i kaing ningyara'ga' kafakafa tangamota' wa adi nagata' tanamara'. Ning tinga sibeng Anutu ka nangkara tinga afuguk adindu' u kanga o adi naganing sabana ga' sura tangamara' wa nagata' tanamara' ning touta' ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Ka Jisas wari arantagimni midi u ina ina ning tanga mareiaging. Ka arantagimni nua'ni ka Jon wari Jisas u ning anigu', girii gam indi aming nua'ni ning kangam ka adi guning wap tonga aming ning masi' unggo kadagasi u tanga fayugukyama', ka adi guning arantagim mo' waraga' tanga indi anisefi tangam ning anigu'. ");
INSERT INTO uvh_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","40","Ka Jisas wari ning yanggu', anisefi guk wa nasi'ga' tinging, aming ka napa' kareng naganing wap ganang tonga tinga wa adi nagata' naknga tara' wara' sidi aming ka ningwara' u kanga wa kagabi sa' tinting. Beng sini' aming ka kane kareng ka ningwara' u tinga kanga wa sidi ning nakedanting, adi indining amini'sa' indining digirap mo'. ");
INSERT INTO uvh_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Ka ning sanotik, aming ka ni sidi Kasira Aming ning kane tinga nasi' kabi'sini' ning yotangkasabota' wa Anutu adi kuma'sa' kara' wara' adi waraga' suknakube guk mo' tota', inga' wa adi aming ka waraga' kafakafa wa napa' kabi'sini' waraga'sa' tanga tangamo'ga' ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Ka Jisas wari arantagimni u midi nua'ni ning yanggu', aming ka ni aming ka naktangkani tangkunang guk mokngang ka saba kabasi' ningyara' da'ning wara'ning naktangka u tipkadangamonga tinga wa aming fam wari u kanga urapsa' bema ugumak sini' tinting. A mokngang wa uningkim girii bema kadare ganang tofinga bema gwang ganang kuragamainga wadigi' kumarota'. Ning tinting wa kadapmang udagainga aming ka ifakadaga tonga tota' wari inga' kagaya girii sini' mo' bemo'. ");
INSERT INTO uvh_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Kadagang wari aming tipkadaunga tinga kadapmang udaga wara'ning wa ning, kafaga fugung wari kadagang ga' ginagara aunga tinga wa gu urapsa' doptanga kayoutang. Ning tanga gu kafaga fugung guksa' ira kane girii totang de ka gu inga' Anutuning yongganang wa marek kareng katuaya'. A gu kagabi sa' tanga kadagang ningsa' tanga ira autang wa bibiri' sini' gu kafaga karesi fama'guk dabiksa' kudip kadagang ganang anga kagaya girii beme'ga'. ");
INSERT INTO uvh_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","(Beng sini' kama ka wa kudip girii udi kungkumak guk mo' tita', abanga ging kadagasi undu' bibi' guk mo' tita' mokngang fikifiki ka' ningsa' fadetamu'.) ");
INSERT INTO uvh_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Ka kaga undu' ningsa', kaga wari kadagang titiga' ginagira aunga tinga undu' gu kaga fugung u urapsa' doptanga kayoutang. Ning tanga gu kaga fugung guksa' irotang de ka gu inga' Anutuning yong kareng ganang wa marek kareng katuaya'. A gu kagabisa' tanga kadagang ningsa' tanga ira autang wa bibiri' sini' gu kaga karesi fama' guk dabiksa' kudip kadagang ganang anga kagaya girii beme'ga'. ");
INSERT INTO uvh_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","(Beng sini' kama ka wa kudip girii udi kungkumak guk mo' tita', abanga ging kadagang undu' bibi' guk mo' tita' mokngang fikifiki ka' ningsa' fadetamu'.) ");
INSERT INTO uvh_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","A daga undu' ningsa', daga wari kadagang titiga' ganggagareinga wa daga fugung u wadigi' kadara kayoutang. Ning tanga gu daga fugung sa' guk kane girii totang de ka gu inga' Anutuning yong kareng ganang wa gi' giri ire'. A gu kagabi sa' tanga kadagang ningsa' tanga ira autang wa bibiri' sini' gu daga karesi fama' guk dabiksa' kudip kadagang ganangsa' anga kagaya girii beme'ga'. ");
INSERT INTO uvh_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Beng sini' kama ka wa kudip girii a ging udi bibi' guk mo' tita', fikifiki ningsa' ira auta'. ");
INSERT INTO uvh_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Abanga nua'ni ka ning, aming wari keng bataga titi ganang waraga' tanga firing siamo' kukiting. Ka aming wari Anutuganang iikning wa kadapmang ka aming wari keng bataga ma to' ning tonga firing siamo' urang kukiting ningda'ning Anutu adi indifikarenda titining napa' ni guksa' tinimota'. Napa' ka wa mamareng ni indiganang kadofanimota' u kabanim sa' tinga bemtam. ");
INSERT INTO uvh_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Ka indi napa' mamareng u bemtam wa indining napa' marang guk ka firing ningda'ning. Indi firing wa kuma'sa' yabitam adi tim inga'ni ganang wa marang guk yating ka inga' timinira tanga marang wari bibi' tinga wa iibi tinga sigesa' fideting. Ka sidining kabaksi'ganang undu' ningsa' sidi napa' kareng marang guk ningda'ning ira wa sidi kuyase fam guk kabasi' kubaniksa' kufara ning tanga kugurang gi'sa' ikanting ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Ning tanga Jisas adi kama tubo Galili u kabinga marara kama tubo Judia tara' waraga' ubu agu'. Anga Jodan ama u yama anga kadofinga aming wari adiganang bak girii abanga tinga kadapmang ka fikifiki fianggetarugu' ning u kama tubo wara'ganang ubu tanga yanggeku'. ");
INSERT INTO uvh_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Ka Juda ning sasuk aming ka Farisi arantagim wari Jisas u mandaga' taramaronga anga ning anigaging, ai Juda aming indining kadapmang tang ka aming wari tamni kagabi wara'ning wa indining adera' karang. ");
INSERT INTO uvh_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Ka Jisas adibu ning yangkagu', a wara'ning midi ka tim Moses wari yoku' wa indining. ");
INSERT INTO uvh_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Ka adibu ning toging, Moses wari yoku' wa ning, aming ka ni tamni kabonga wa sigesa' mo' kabota', adi tim ka midi dibing kabi' umpang ganang yora yora aminga ning tanga wara'ganang inga' anigarota' wa giri ning yoku'. ");
INSERT INTO uvh_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Ka Jisas wari ning yanggu', a Moses adi taming kagabi' ga' aigasam titining guk mokngang ka adi sidi aming midi ninak ning guk mokngang midi karangkang titisi waraga' tanga wa midi ka umpang iyok ga' u togu' wang. ");
INSERT INTO uvh_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Ka midi ka wara'ning ki sini' wa ning fideta', timinggi' sini' Anutu wari napa'napa' munumung sini' tugu' ganang wa adi ami tanga a taming tanga ning tugu'. ");
INSERT INTO uvh_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","8","Tanga ning togu', ami a taming wari mengbe guk ira anganga ami a taming sangama ning tanga mamangse babangse u ibinga abanga kabaksi' kubaniksa' kufara ning tanga napa' kubaniksa' ning ubu kadofinga iik waraga' tiabirik ning togu'. ");
INSERT INTO uvh_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Wara' napa' ka Anutu wari wadigi' ning tonga kuma' iptatangkayap wa aming wari nua'bu udayap guk mokngang sini' ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Jisas adi midi u ina ning tanga ibinga yak iyung bane ganang amogu'. Ka ananing arantagimni wari mandang yaranga amanga midi ka u togu' wara'ning ki ga' anigaging. ");
INSERT INTO uvh_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Ka Jisas wari ning yanggu', aming ka tamni kabinga taming nua'ni sanota' wa adi tamni ka kagabi tota' waraga' kadagang tangamara'. ");
INSERT INTO uvh_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","A taming undu' ningsa' ufini timini u kabinga ami inga'ni sangamota' wa adi ami taming fama' wari kabaksi' kubiniksa' iik wara'ning u tipkadaga sini' tara' ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Ka fiking nua'ni ganang aming fam wari Jisas wari sababi' u kisi' suroyapma ibang toyam waraga' ning tonga Jisas ga' inagikngama abiging. Ka Jisas ning arantagimni wari yapma ifangyang tanga yangsefi tiging. ");
INSERT INTO uvh_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Ka Jisas adi arantagimni wari yangsefi tiging u yapma ning yanggu', ai yangsefi guk wa naga' ting, iibi sa' tinga nagaganang i abani'. Sidi wara'ning ki guk mo' naknga yangsefing, sababi' karesi ningyara' wa Anutuning midi ninak sa' tanga Anutuning bining ganang iik wara'ning ningda'ning iking. ");
INSERT INTO uvh_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Beng sini' sanirik aming ka Anutuning kapmik ganangsa' ironga wa adining kabani wa saba kabasi' ningda'ning naktangkanga irota' wa giri, a mokngang wa adi Anutuning bining anga kaga ning guk mokngang ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Ning ina ning tanga saba kababi' u fabanga kukyapma kisi' suroyapma Anutu wari yotangkayap waraga' ibang toyamgu'. ");
INSERT INTO uvh_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Ka Jisas wari sababi'ga' ibang u toima ning tanga ibinga marara mugo tonga tinga aming nua'ni wari urapsa' unara abanga kadofinga Jisas ning kayong ganang u manda upma irema mera Jisas u ning anigu', o yanggek aming kareng na indining da'ning tanga ka' iik kareng fikifiki ningsa' irotik. ");
INSERT INTO uvh_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Ka Jisas adibu adining naktangkani u kadidimonga ning anigu', ka gu aming kareng ning guk wa naga' nanarang, midi wap ka kareng wa Anutu kubaniksa' urang anitam udi. ");
INSERT INTO uvh_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Ka gu midi ka ka' ningsa' iikga' torang wara'ning kadapmangni wa gu kuma'sa' nakitang midi tangkunang Anutu wari kaminga yaregu' wa ning, gu aming nua'ni mo' ura sebotang a gu tamga kabinga sansaramik mo' totang a kubu mo' totang a gu midi mandaga' mo' toutang a gu aming nua'ni mo' taramikotang ning tanga mamangga babangga kafakafa tiabotang ning tuguinga yoking. ");
INSERT INTO uvh_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Jisas wari midi ka u tuguinga aming wari ning togu', o girii beng sini' na timinggi' kabasi' ganang midi ka u tonga yararang u naknga yara tanga didimeng ningsa' ko ira abutik yang ning anigu'. ");
INSERT INTO uvh_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Ka Jisas adi aming Anutuning kadapmang didimengsa' kuma' tanga yagu' u kanga adita' kaba karengsa' naknga ning anigu', kadapmang didimeng wa giri yaranga ikitang ka napa' kubaniksa' wa titi guk mo' fatitang unggungsa' totang wa ning, gu i anga nasi' nasi' mambongga u manggara fonga tatafak amingga' yamsasu'notang. Beng sini' gu ning totang wa inga' kunim furo'ning ganang wa napa'niga' nafek guk mo' te' mokngang. Wara' gu u tanga inga' wara'ganang nawara abotang ning anigu'. ");
INSERT INTO uvh_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Ka aming adi kangasi mambongni kabi'mo' waraga' tanga adi Jisas ning midi u naknga mambongni girii u kagabi ga' bibi' naknga kaba mamareng sini' naknga ning tanga munggufa tanga Jisas u kabinga yoringga' mugo tugu'. ");
INSERT INTO uvh_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Ning tanga aming wari mugoinga Jisas wari arantagimni u ning yanggu', beng sini' sanirik aming ka mambongni siamo' guk adi kunim yongga' mugo wara'ning kadapmang u yara waraga' wa sia da'ning mo' tota' mokngang, kane girii sini' tota' ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Ka arantagimni adindu' midi ka u mamareng ning sura naknga base tiging waraga' tanga Jisas wari ning nua'bu yanggu', o sabane beng guk sini' urang sanirik aming wari Anutuning bining ganang ironga wa siasa' mo' tanga anting mokngang. ");
INSERT INTO uvh_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Midi ka wara'ning kamaga ni wa maga girisi wari ginang kabasi'sini' ganang aunga yotekna tanga kane girii sini' urang titing ningda'ning tinting. Ka aming ka mambong mimeng guk wari Anutuning bining ganang iikga' undu' kane girii ka ningsa' tinting ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Ka arantagimni adi Jisas ning midi u naknga ning tanga anasa' ning toging, ai midi ka wa bagi da' tara' nakem, aming wari kunimganang mugoning guk mokngang ba ning toging. ");
INSERT INTO uvh_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Ka Jisas wari u naknga faranga yapma ning yanggu', beng sini' aming sidi kadapmang guk mokngang ning sura naknga toing ka ning sanotik, Anutu adi napa'napa' aming wari mo' titing wa adi kuma'sa' tita' wara' adi aming wari adining bining iikning kadapmang undu' adisa' tiaminga anting ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Ning tanga adeging ka Pita wari Jisas u ning anigu', o beng sini' girii indi mambong ga' sasuk mimeng guk mo' tugum mokngang, indi mambongni' u ibinga marara gusa' giwara abanga wa gugok kane i tanga fengakem yang. ");
INSERT INTO uvh_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Ka Jisas wari ning yanggu', beng sini' kafakafa nakni' aming ka naga a Anutuning midi kareng ga' sura marara ananing yoring a mengbe kuyane a mindine fening a magani mambong u ibinga mauta' adi nafek guk mo' tanga irota' mokngang, adi inga'ni nua'bu wa kamaganang ingging kuma'sa' yaptuauta'. ");
INSERT INTO uvh_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","Tim wa adi mambongni fama'sa' ikngamting ka inga' adi kane u tanga irota' ganang wa Anutu wari yak a mengbe a kuyane mindine ibingine a feng a maga kabi'mo' kuma'sa' ibingaminga yaptuauta'. Ka adi kamaganang i ira wa napa' kareng unggungsa' mo' katuauta' mokngang, adi napa' mamareng undu' bemota'. Adi naganing kane tinga aming fam wari waraga' tanga kagaya aminting, ka inga' adi kunim yongganang wa marek sibim kareng bema marero'. ");
INSERT INTO uvh_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Beng sini' sanirik, aming fam ka kami yara'ganag tim iyakning ningda'ning iking adi inga' mandang ubu ikni'ga', a aming fam ka wap guk mokngang sige ningda'ning iking adibu inga' wa girisi ira wap guk ikni' ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Ka Jisas wari arantagimni midi u ina ning tanga kama ka u kabinga ning tanga Jerusalem yong girii ga' maronga Jerusalem ning kadapmang u yaranga mugoging. Ka Jisas adi tim a arantagimni adi mandang ning ira famugoging. Ka Jisas ning arantagimni adi Jisas wari kagaya ni bimbem ga' mutu kabi'guk mo' tugu' kane tangkunang sa' tanga agu' u kanga base tiging. Ka aming fam ka adisigok kubap mugoging adi napa'ni kagadofi ga' da'ning u kanga mutu guk tanga iwara aging. Ka Jisas wari mamareng girii ka adiganang kadofingam ga' kuma' duduregu' wara'ning midi u ari' inonga arantagimni 12 unggungsa' katiana fonga kukyapma ning yanggu', ");
INSERT INTO uvh_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","idi Jerusalem ga' urang marem. Aming wari Amingning Tim Iyak naga pris a sasuk aming girisi ganang nifikadofiinga wari bemnapma midiganang nipminga nugumak titi waraga' toni'ga'. Ning tanga ninagira tonga aming arantagim nua'nining kafasi'ganang ubu nipmini'ga'. ");
INSERT INTO uvh_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Ning tinga adibu bemnapma tonga iyung dasinapma napguruda tanga nangkige tanga iguk sombaknapma ning tanga nugumak tini'ga'. Nugumakinga kumara deia' kama famineng ning ibinga tubobu seranga mararok ga' ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Ka Jisas wari midi u ina ning tanga mugoging. Anganga Sebedi ning mindine fama' ka Jems ya Jon ya wari Jisas u ning anigagumu', girii gam gu napa'ni ka indi tinim ga' sura gangtuamuk udi girisa' u tinimotang. ");
INSERT INTO uvh_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Ka Jisas wari ning yanggu', nasi' tasam ga' naknga toyamu'. ");
INSERT INTO uvh_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Ka adibu ning anigumu', mo' inga' gu girii ira napa'napa' dabiksa' yaptatoranga marere' ganang wa gu ni ka kafaga kareng ganang tara' a ni ka kafaga kesini ganang tara' ning fonga kuknipma gugok girii dabik udi giri tanga mareknam wa. ");
INSERT INTO uvh_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Ka Jisas wari ning yanggu', a sidi kafakafa guk mo' nakedanga naniamu'. Sidi nagok girii dabik iikga' udi giri toyamu' ka sidi tim ka kagaya a mamareng ka naga bimbem ning u nagok dabik udi girisa' u bemtam. ");
INSERT INTO uvh_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Ka iguyangguk wari ning anigumu', ade indi gugok kagaya udi girisa' bimbem ning. ");
INSERT INTO uvh_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Ka Jisas wari ning yanggu', beng guk toyamu' kagaya a mamareng ka naga bemotik wa sidindu' kuma'sa' bemtamu' ka sidi naganing kafana kareng ganang marek ga' toyamu' wa naganing kane mo', mokngang wa sibeng Anutu warisa' yapma ibara' unggungsa' manggara kukyabo' ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Ka Jisas ning arantagimni fam adi midi ka girii iikga' anigagumu' u naknga nakadayam tanga aming fama' iguyangguk u ifangyang tiging. ");
INSERT INTO uvh_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Ning tanga Jisas wari arantagimni dabiksa' ubu yanggu', sidi kadapmang ka aming girisi kamaganangni wari titing wara'ning wa kuma'sa' naking aming girisi adi tangkunang guk wara' nasi' midi adi tuguting wa aming adi nakyam sa' tanga adisining kapmik ganangsa' ikiting. ");
INSERT INTO uvh_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Ka sidi kadapmang ka u titing u mo' yaranting mokngang. Aming ka ni ka sidining bining ganang wari girii iikga' naknga wa adi ananing fugu bema afanga ning tanga kadapmang ka amine ning kapmik ganang iikning ningda'ning tanga irota'. ");
INSERT INTO uvh_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Abanga tim iyak aming ning ironga undu' amine ning kane aming sige ningda'ning irota'. ");
INSERT INTO uvh_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Ka Amingning Tim Iyak nandu' ningsa' na aming wari naganing kane tanaminga gi' marek waraga' mo' sura afuguk mokngang sini', na aming kabi'mo' u yotangkayapma kadaga titining ganang iking u udanga tubobu manggakyap waraga' naning fukna i kabiaminga nugumak waraga' afuguk yang ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Midi u ina ning tanga anga Jeriko yong u kadofiging. Kadofinga ning tanga Jisas ananing arantagimni guk ka aming sige fam kabi'mo' wara'guk dabik yong u kabinga aramugoging. Ka aming de kadagang nua'ni adi fikifiki kadapmang gaga ganang mera aming fam wari mambong amimi ga' fagatianarugu'. Ka adi Timias ning mindingni wapni Batimias wari kadapmang ganang u merafagu'. ");
INSERT INTO uvh_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Ka adi aming fam wari Jisas Nasaretni wari abara' ning toging u naknga ku ning katigu', oi Jisas Devit ning mindingni gu napbubure tanga nifikarenda te'. ");
INSERT INTO uvh_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Ka aming fam wari kafangani tanga anisefi tiging. Ka aming de kadagang adi nakyam guk mo' tanga ku bang sini' ning nua'bu katigu', ai Devit ning mindingni napbubure tanga nifikarenda te'. ");
INSERT INTO uvh_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Ka Jisas wari adining ku u naknga anga adenga ning yanggu', anigara tinga abo'. Ning ininga aming fam wari de kadagang u ning aniging, ai kafakafa tagamonga tora' mamarak te'. ");
INSERT INTO uvh_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Ning aniinga aming de kadagang wari u naknga fungsa' marara saketni u kifinga kayonga ning tanga Jisas kaunga abugu'. ");
INSERT INTO uvh_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Abanga Jisas ganang kadofinga adeinga Jisas wari ning anigagu', nasi' tagam ga' ning tonga fakatinanarang. Ka aming wari ning togu', o girii dana i tubobu tipkarendanaminga degarok. ");
INSERT INTO uvh_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Ka Jisas wari adining naktangkani u kanga ning anigu', gu tubobu gi'sa' maya' ganing naktangka ka naga gifikarenda ga' tarang warisa' tanga tubobu kuma' karendarang. Ning aniinga de wari kaga' urapsa' karendanga ning tanga kaba karengsa' naknga Jisas se' u iwara adisigok kubap mugoging. ");
INSERT INTO uvh_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Ning tanga anganga yong kababi' fama' ka Betfasi guk ka Betani guk Jerusalem yong girii du' ka kama bubo kabasi' wapni Oliv ning aniaging u kadofiging. Anga kadofinga ning tanga Jisas wari arantagimni fama' dongki ka ni anga bemama abu waraga' tim yangkaregu'. ");
INSERT INTO uvh_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Adi ning ina yangkaregu', sidi yong kabasi' do anga yong bibik ganang kadofinga dongki uyamang nua'ni ka aming wari mimek guk mo' fatiting ka aya wari kuma' tofanga iraring u anga bema abademu'. ");
INSERT INTO uvh_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Ka sidi dongki u bemtamu' ganang aming ka ni wari ai nasiga' bemiamu' ning udep saninga wa ning anintamu', mo' girii adi kane kabi'guk wara' adi ningkarara' kanga abanga fadakiamuk. Adi kane kabi' u tanainga tubobu urapsa' kuma' bema abantam ning anintamu' ning ina yangkareinga agumu'. ");
INSERT INTO uvh_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Anga kadofinga kagumu' ka dongki uyamang nua'ni udi yak iming ganang kuma' tabanga tofinga irakinga fidegu'. U kanga anga aya u arafadagumu'. ");
INSERT INTO uvh_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Ka aming fam ka unggung mareiaging wari yapma ning yangging, ai dongki wa nasiga' fadakiamu'. ");
INSERT INTO uvh_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Ka adi midi ka Jisas wari kuma' yanggu' u ininga iibi sa' tiging. ");
INSERT INTO uvh_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Ibiinga fadara bema anganga Jisas ganang do kadofinga ning tanga anasining kwi' u manggara dongki wara'ning fugu furo'ning u ingaminga Jisas wari wara'ganang aranga meku'. ");
INSERT INTO uvh_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Jisas wari dongki furo'ning wara'ganang aranga mera aramugoinga aming kabi'mo' wari Jisas ning wap bema aronga anasining kwi' a fam ka firi yongni karesi ning sasa' u doptanga manggara fabanga kadapmang ganang u ingama yareinga Jisas adi wara'ning furo'ning ganangsa' mera tipminga aramugogu'. ");
INSERT INTO uvh_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ning tanga Jisas wa bining kaminga aming fam ka tim a fam ka mandang ning ira ning tanga kabaksi' karengsa' naknga mesisiringa tanga Anutu animamangnanga ku ning katiging, o Anutu kareng gu indita' kafakafa tinima girini' i anigaranimarang. ");
INSERT INTO uvh_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Adi Devit ning iri, tim Devit wari kafakafa sa' urang yaptatoregu' ningsa' adibu niptatora wara'ning kama kuma' faranimara'. A Anutu kareng gu kafakafa beng sini' tinima girini' kareng tipkadofiinga abara' ning kating katinga nagira aging. ");
INSERT INTO uvh_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Ning tanga nagira anganga Jerusalem yong girii bining do kadofinga Jisas wari siring yak girii wara'ganang amogu'. Amanga ning tanga aming wari kane fatiging u kuruma yapyangara yapyangara ning tanga kama kuma' garonga tugu' u kanga Jisas wari arantagimni 12 u inagira ning tanga yong kabasi' Betani u deronga tubobu mabiging. ");
INSERT INTO uvh_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Abanga kadofinga deia' kama fagainga marara Jerusalem yong girii ga' tubobu aging. Ka Jisas adi segi naku' ");
INSERT INTO uvh_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","wara' adi kadapmang bining ganang anga firi mindip nananing ka fik udi beng guk ba ning tonga mindip u manggara nana ga' ning tonga kagu' ka mokngang, kama mindip titining mo' faregu' wara' adi sasa' sigesa' ko fidegu'. ");
INSERT INTO uvh_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Ka firi wari sigesa' fidegu' u kanga Jisas wari ning anigu', a ningwara' gu mindip nua' mo' tiame' ning anigu'. Ka arantagimni adindu' Jisas wari midi ka firi u anigu' u kuma' naknga ning tanga mugoging. ");
INSERT INTO uvh_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Ning tanga anganga Jerusalem yong u kadofinga Jisas wari siring yak girii ning sinim iyung u nua'bu amogu'. Amanga ning tanga yapku' ka aming wari napa'napa' manggara famanga kura fatonaging. U yapma yangkagare tanga yaregu'. Ning tinga fam ka siring yak girii tempel ning moni u iminga kura'bu moni sini' iyam a fam ka yang iri u manggara fonga kukinga aming fam wari abanga tona ning fatiging wara'sining basingsi' kababi' ka napa' u kura to wara'ning u manggara kwasinaimsasu'nanga yaregu'. ");
INSERT INTO uvh_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Ning tanga aming fam ka siring yak ning sinim iyung unggung napa' mambong ko manggara yangaging wa kafong wari kusefiapma yangkura tugu'. ");
INSERT INTO uvh_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Ning tanga aming ka unggung adeging u ning ifang yanggu', tim midi ka Anutu wari tuguinga yoking wa ning, naganing yak girii kareng wa aming dabik wari nagata' ibang tonam wara'ning wapsa' adeuta' ning yoking. Ka sidibu aming kadagasi ning yak kapmo' ubu tipigironga fating ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Ka Juda ning pris a sasuk aming girisi adi Jisas wari aming siring yak ganang yangkagaregu', a midi kareng ituainga aming kabi'mo' wari adining midi u kuni' nua'ni sini' naknga kabaksi' marara fabiaging wara'ning midi u naknga aming wari adisa' ma yarasasu'nani' ning tonga mutu tanga uuk titi waraga' midi tonga naking. ");
INSERT INTO uvh_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Ning tanga kama gareinga Jisas guk ka arantagimni guk adi Jerusalem yong girii u kabinga yong kabasi' ka dek tiaging waraga' tubobu mugoging. ");
INSERT INTO uvh_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Anga deia' kamindapking tubobu marara abiging. Abanga kadapmang ganang firi ka Jisas wari midi anigu' u tonga kaging ka firi udi kafora tonga sasa' piriring sa' tabemgu'. ");
INSERT INTO uvh_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Ka Pita adi midi ka Jisas wari firi u anigu' udi kuma' naku' wara' adi waraga' suknatama Jisas u ning anigu' ai girii gu kap midi tangkunang firi urang anigugng wa kafora tonga tara' u kaya'. ");
INSERT INTO uvh_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Ka Jisas wari ning yanggu', beng sini' sanirik sidi sasuk tangkunang ka o Anutu adi beng guksa' kuma' tota' ningsa' suktangkanga tinting. ");
INSERT INTO uvh_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Aming ka Anutuga' naktangka tota' adi napa' ka naga i tinga kaing ningyara' udi girisa' tota'. Adi napa' girii sini' ka kama bubo do wari danga gwang ganang mangfu ga' tounga kaba kubiniksa' kufara touta' wa Anutu wari kuma'sa' tangaminga kadofota'. ");
INSERT INTO uvh_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Beng sini' sanirik sidi Anutu wari napa'ni tasam ga' naknga wa sidi kabaksi' a sasuksi' kubaniksa' ka Anutu adi girisa' titining ningsa' suktangkanga tinting wa napa' wari beng guksa' kadofisamota'. ");
INSERT INTO uvh_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Ka sidi Anutuga' ibang tounga wa sidi tim ka aming fam wari kadagang sidiganang tota' u anga tipdidimanga ning tanga Anutuga' ibang wa inga' tonting wa babangsi' girii ka kunimganang ikita' Anutu adindu' sidining ibang u naksam tanga sidining kadagang u kuma' suknakubesamota'. ");
INSERT INTO uvh_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","A sidi tim ka ning guk mo' tanga kadagang wari sidining kabaksi'ganang ko fideinga ibang sa' tonting wa Anutu adi sidining kadagang undu' mo' suknakubesamota' ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Ka Jisas wari arantagimni midi u ina ina ning tanga mugoging. Anganga Jerusalem yong girii u kadofinga Jisas adi siring yak girii ganang nua'bu anga amanga arengagu'. Ka Juda ning pris a sasuk aming girisi a aming girisi fam ka unggung mareiaging wari u kanga anga Jisas u ning anigaging, ");
INSERT INTO uvh_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","ai gu nasi' wap guk wara' gu kane i tanga fiararang a. Nisi' wari gipmigu' nining tinga naknam. ");
INSERT INTO uvh_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Ka Jisas wari ning yanggu', we' ningwara' tim ka naga midi nua'ni sangkautik u naninga wara'ganang inga' kuma' sanotik ning ina ning tanga ning yanggu', ");
INSERT INTO uvh_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","ka tim Jon Baptis wari ama iyam kane kadofinga tugu' wa tangkunang wa nisi' wari amiinga tugu', wa aming warisa' kaminga tugu' wa ma Anutu ana u kamigu' wara'ning u naninga nakok. ");
INSERT INTO uvh_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Ka adi midi tubobu guk mo' aniging, adi fe' ma tanam ning tonga anasa' midi kapmo' ning toging, indi Anutu wari kaminga tugu' ning tontam wa adi ning ma nino', ka naga' tanga sidi Jon ning midi u naknga kabaksi' guk mo' fareging. ");
INSERT INTO uvh_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","A indi aming warisa' kamiinga tugu' ning tontam wa aming arantagim adi Jon wa Anutuning kane aming sini' ning kuma' kaging wara' adi indining midi u naknga kabaksi' kadagang ma naknimni' ning tonga naknga ");
INSERT INTO uvh_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Jisas u ning aniging, o nafek ba tem. Ka Jisas wari ning yanggu', sidi nafek ting ning naning wara' nandu' kane i nisi' wari nipminga tirik wara'ning undu' mo' sanotik, ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Ka Jisas wari Juda arantagim ning aming girisi wara'siga' midi tipfaraim ning tugu', aming nua'ni wari grep mindip feng tanga sinim ipma a grep mindip giming u manggara fonga tipmiinga ameng wari kadofinga bekinga gigik waraga' kama kwang unanga ning tanga aming wari som titiga' yak kabasi' sinim furo'ning u manga kabota'. Ning tanga adi kane aming fam ka adining feng u katatoranga anata' manggara kukngama dibing ka anasita' manggakna ning titi waraga' manggara kukyapma ibinga ning tanga feng tuang adi kama kamani anga irota'. ");
INSERT INTO uvh_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Anga iya' inga' grep mindip giming mamanggak ning kama farota' u kanga feng tuang wari aming ka feng katatoranga ikanting u abanga yapma uningkim mambong dibing u bemama au waraga' kane aming ka ni anigareinga auta'. ");
INSERT INTO uvh_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Anga kadofiinga kane aming ka feng u katatoranga ikanting wari aming u bema fifefi tanga sige anigareinga tubobu mauta'. ");
INSERT INTO uvh_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Anga kadofiinga feng tuang wari u kanga aming nua'ni ubu anigarota'. Ka wari anga kadofiinga undu' ningsa' taramikanting, adi aming u bema ki kati bane ura ning tanga kadagang taramikanting. ");
INSERT INTO uvh_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Ning tinga feng tuang wari u kanga kane aming nua'ni ubu anigareinga auta'. Anga kadofiinga aming ka feng u katatoranga ikanting wari aming ka u bema wadiging sini' ugumakanting. Ning tinga kane aming fam nua'bu yangkarota' undu' ningsa' tanga fam ka dipming ibi tanga fam ka dipmigumak sini' titi ning tinting. ");
INSERT INTO uvh_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Kadapmang ka ningwara'sa' tanga anganga kane aming wari bisasu'neinga feng tuang wari kane aming ga' nafek tanga ananing mindingni kubaniksa' ka adita' siamo' nakota' ubu anigara ga' sura ning touta', a na kane aming yangkararik ka adi ning ting wara' na naganing sabana sini' ubu anigarotik. Ning tinga adi ananing nonda sini' kanga o ananing mindingni wari abara' ning tonga kagabi sa' tinting. Ning tonga ari'sini' wa ananing mindingni kareng kubaniksa' u anigareinga auta'. ");
INSERT INTO uvh_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Anga kadofiinga undu' ningsa' aming ka feng u katatoranga ikanting wari ananing mindingni ning nonda u kanga ning tonting, ai feng tuang ananing mindingni wari ubu abara' sam indi ugumak tanam. Ning tanga feng yari tuang guk mo' ikinga indita' wadigi' sini' ubu bemnantam. ");
INSERT INTO uvh_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Ning tonga naknga marara feng tuang ning mindingni u ugumara bema feng wara'ning sinim fugang do kuragamanting. ");
INSERT INTO uvh_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Ka wa indining, feng tuang adi aming ka wa iibi tota' wa. Mokngang adi kane aming timini ka u wadigi' dipmisasu'nanga ning tanga kane aming inga'nisa' ubu kukyabota'. ");
INSERT INTO uvh_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Ka sidi midi ka u torik wara'ning waraga' ka Anutu wari tim tuguinga yoking wara'guk mo' unda' indangira nakiting. Midi ka wa ning yoking, “aming wari uningkim yak maunga wa uningkim karesisa' yapma manggara nua'ni wa kadagang kanga kabing. Ka Anutu adi uningkim ka aming wari kadagang ning tonga kabing wa adibu bema yak ning mangkap kigineng girii tim iyak ning irata'. ");
INSERT INTO uvh_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Ka wa napa' girii sini' ka Anutu warisa' tara' wara' indi u kanga kabakni' karengsa' nakem ning yoking ning yanggu'.” ");
INSERT INTO uvh_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Ka Juda ning sasuk aming girisi adi Jisas wari midi tipfara ka u anasita' sura tiamgu' u kuma' sura nakedanga kabaksi' kadagang nakngama bimbem titiga' ning tonga kuma' suking. Ka ami taming kabi'mo' wari Jisas ning midi u naknga adita' naking waraga' tanga adi kadagang ning ma nipni' ning tonga kagabi tanga mugo tiging. ");
INSERT INTO uvh_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Ning tanga Juda ning aming girisi wari Jisas bimbem wara'ning kadapmang ga' wena tanga midi mandaga' fam taramakinga Jisas wari fe' tinga midi ganang bema kami waraga' sura Farisi arantagim a Herot ning arantagim fam u yangkareinga Jisas kaunga aging. ");
INSERT INTO uvh_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Yangkareinga anga Jisas ganang kadofinga mandaga' taramironga ning anigaging, o beng sini' yanggek aming indi guning kadapmang u kuma'sa' kayam gu midi beng guksa' tugutang, Anutuning midi ning nasi' kadapmang wa didimengsa' tugutang, aming fam ga' mutu tanga tipfara kabi'guk mo' titang wara' indi napa' niga' gangtam u nine'. Ka Juda aming indining kadapmang tang wa indining, Romni girii Sisa ga' takis girisa' amimi ga' tuguta' wa ma mo' amimi ning, wara'ning u nakdidimanga wa giri wara'ganangsa' yaranga tantam ning aniging. ");
INSERT INTO uvh_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Ka Jisas adi mandaga' taramikonga abanga aniging u kuma' yapkedanga ning yanggu', a sidi mandaga' naramikonga ting sabirik. Ka uningkim mambong moni ka ni naminga kawak. ");
INSERT INTO uvh_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Ning ininga uningkim moni u bema amiinga kanga ning yanggu', aming uuring ka uningkim ganang ya nisi'ning nonda tiging a wap ya nisi'ning yoking. Ka adibu ning toging, mo' wa Romni girii Sisa ning wap a uuring tiging. ");
INSERT INTO uvh_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Ka Jisas wari ning yanggu', didimengsa' toing ka ning sanotik, napa' ka Sisa ga' amimi ning undu' adita'sa' amintam a napa' ka Anutuga' amimi ning undu' Anutuga' didimengsa' amintam ning yanggu'. Ning tinga adi Jisas ning midi u naknga ning toging, ai aming sasuk guk ning midi tora' nakem ning tonga base tiging. ");
INSERT INTO uvh_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Ning tinga aming arantagim ka aming kungkumosi udi tubobu guk mo' marakiting ning toyaging wapsi' Satyusi adibu abiging. Abanga Jisas ganang kadofinga Jisas u ning anigaging, ");
INSERT INTO uvh_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","ai yanggek aming gam tim Moses wari midi yoknimgu' wa ning, aming ka ni taming sananga saba guk mo' ibenga kumarota', ning tinga adining tamkasa' wa kuyang mandangni adibu sanota'. Sananga saba ibenga aming ka kungkumak tota' wara'ning uni yokantamu' ning yoknimgu'. ");
INSERT INTO uvh_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Ka indining, se'kuyane seven ning ikanting ka kuyasi' timini wa taming u sananga saba guk mo' ibenga kungkumak tota'. ");
INSERT INTO uvh_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Ning tinga adining tamkasa' wa kuyang mandangni adibu sanota' undu' ningsa' saba guk mo' ibenga ganang kumarota'. Ning tinga kuyasi' biningni nua'ni wari ubu sanota' undu' ningsa' saba guk mo' ibenga sigesa' kumarota'. ");
INSERT INTO uvh_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Ning tinga kuyase fam adindu' ningsa' tinting, adi taming ka kubanik unggungsa' sananga saba guk mo' ibenga ganang kumara kumara anganga mandang ari' sini' wa tamsi' wari kumarota'. ");
INSERT INTO uvh_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Ka gu waraga' wa indining sutang aming kungkumosi wari tubobu marakni' ganang wa aming arantagim ka wari tubobu marara wa taming wara'ning ufini tuang sini' wa indeng wari irota', mokngang da'ning nakem ning aniging. ");
INSERT INTO uvh_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Ka Jisas wari ning yanggu', a sidi Anutuning midi a adining tangkunang kigeda guk mo' ting sabarik wara' sidi fe' sini' tanga Anutu adi aming tubobu ifamarak ning guk mokngang ning sura toing. Ka ning sanotik Anutu adi aming kungkumosi tubobu ifamarak wara'ning tangkunang guk beng sini' ita'. ");
INSERT INTO uvh_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Wara' inga' Anutu wari aming kungkumosi tubobu ifamarak ganang wa adi imaraming ning nua'bu mo' ikni', mokngang adi Anutuning kunung aming ensel arantagim ningsa' ubu ikanting. ");
INSERT INTO uvh_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Midi ka Anutu wari aming tubobu ifamarak wara'ning wa tim Anutu ana Moses aniinga Moses wari kuma' yoku' ka sidi wara'guk mo' faindangikiting. Midi ka wa Anutu ana afanga firi sasa' ka' ganang kudip da'ning danga Moses u ning anigu', na Ebraham ning Anutu a Aisak ning Anutu a Jekop ning Anutu wari itik ning anigu' u yoku'. Aming wap ka u togu' wa inga'ni mo' timinggi' sini' kuma' ira kumoging ka Anutu wari tubobu ifamarakinga adi ka' iyak nua'bu tinting u yapma wa adisining Anutu itik ning togu' wang. ");
INSERT INTO uvh_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Wara' sidi ning nakanting, aming arantagim ka Anutu wari adisining Anutu ning ikita' wa aming kungkumosi mo' mokngang, wa aming ka ka' ningsa' ikiting u yaptatoreta' wara'ning Anutu. Wara' sidi sasuk ka aming kungkumosi udi tubobu mamarak ning guk mokngang ning u tanga ikiting wa beng guk mokngang fe' sini' titing ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Ka Jisas wari Satyusi arantagim guk midi u ko fatoging ganang ka sasuk aming nua'ni adindu' abugu'. Ka adi Jisas wari midi tubobu karengsa' yanggu' u naknga Jisas u ning anigagu', o yanggek aming nasi' midi tang wari Anutuning midi tangkunang lo fam u irafara girii sini' adera'. ");
INSERT INTO uvh_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Ka Jisas wari ning anigu', midi tang wara'ning midi girii sini' yoking wa ning, o Isrel aming sidi ning nakanting sidining girisi' wa Anutu girii kubanik unggungsa'. ");
INSERT INTO uvh_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Sidi kabaksi' a sasuksi' a urisi' a fuksi' wa Anutu girii ga'sa' kufara ning tanga adita'sa' naknga ikanting. ");
INSERT INTO uvh_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","A midi girii nua'ni ka ning, gu aming fam ga' siamo' naknga kafakafa sini' ka ganing fuka tanga katatoreta' ningsa' tiamting ning yoking. Ka midi fama' ka wa midi ka ni wara'guk mo' irafata' ning anigu'. ");
INSERT INTO uvh_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Ka sasuk aming adi Jisas ning midi u naknga ning togu', o beng sini' torang girii indining girini' wa Anutu girii kubaniksa' nua'ni guk mokngang ");
INSERT INTO uvh_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","wara' indi kabakni' a sasukni' urini' a fukni' dabiksa' wa Anutuga'sa' amisasu'nanga nakngamtam. Ning tanga nua'ni ka aming fam ga' siamo' naknga kafakafa ka indining fukni'ga' titam ningsa' tiamtam. Indi midi fama' u yaranga tantam wa kadapmang fam ka Anutuga' nana a keng tangsangam a napa' karesi fam manggara fonga kukngam ning titam u tarafarota' ning togu'. ");
INSERT INTO uvh_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Ka Jisas wari ning anigu', o ning nakamarik ka guning midi wa aming ka Anutuga' naktangka tanga Anutuning bining ganang iikning midi torang ning anigu'. Ning tinga aming fam adi Jisas ning sasuk girii u kanga a nua' mo' anintam ning tonga ningsa' adeging. ");
INSERT INTO uvh_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Ka fiking nua'niganang Jisas wari siring yak ganang amanga Anutuning midi kareng yanggera ning tanga ning yanggu', sidining sasuk aming adi midi nua'ni ka ning fasaniting, Anutu wari Kasira Aming anigaranim ga' togu' wa Devit ning arantagim ganangsa' kadofo'ga'. ");
INSERT INTO uvh_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Ka sidi midi ka tim Anutuning mini unggo wari aninga Davit anasa' ning yoku', Kasira Aming wa naganing girina ning togu' waraga' sukni'. Ka midi ka u togu' wa ning yoking, “Anutu girii wari naning girina u ning anira', abubu te'. Abanga naganing mamamna ganang i marekinga aming ka guta' bibi' naking wa na manggara fabanga guning kapmik ganangsa' kukyabotik ning yoku'.” ");
INSERT INTO uvh_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Ka sidi midi ka waraga' wa indining suking, Devit ana wa Kasira Aming wa girii ning anigu'. Ka sidining sasuk aming adindu' Devit ning irini ning wa giri fatuguting ka adi wara'ning ki guk mo' u naknga fatuguting ning yanggu'. Ning tinga aming arantagim sige kabi'mo' ka bak tanga Jisas ning midi u mera fanaking adi Jisas ning midi u marang guk kareng ning naknga kabaksi' karengsa' naking. ");
INSERT INTO uvh_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Ka Jisas wari ami taming sige ubu yanggeronga midi ning yanggu', sidi kafakafa sura ikni' sidining sasuk aming girisi adi aming wari karengsa' iyap ga' ning tonga fuksi' bema aranga kwi' paramusi' karesi u ipmanga ning tanga kama ka aming wari bak titing wara'ning bining ganang u arengating. ");
INSERT INTO uvh_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Abanga adi siring yak ganang amanga undu' ningsa' titing adi amanga aming fam u irafiksasu'nanga anga tare karesi ka aming girisi wari mimekning ka tim do adeting wara'ganangsa' aranga marekiting. Abanga kama tangsana girii ganang a midi bak ganang undu' ningsa' titing. ");
INSERT INTO uvh_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Abanga adi tamkasa' tangkunang guk mokngang u mandaga' iramira ning tanga adisining mambong sige iromanggakniabiting. Adi kadagang girii ka ning u kuma' tanga ira megang guk mo' naknga Anutuga' ibang paramu' sini' wa sigesa' tuguting beng guk mokngang. Adi kadapmang kadagang ka ning u titing waraga' tanga inga' adi Anutuganang kagaya girii sini' katuani'ga' ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Ka Jisas wari midi u ina ning tanga mareia' yapku' ka aming wari Anutuga' uningkim mambong kolekta u fuguking. Ka ami taming fam adi aming kangasi wara' adi uningkim girisi girisi fuguking. ");
INSERT INTO uvh_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Ka inga' tamkasa' nua'ni wari abugu' adi nafek sini' tanga itarugu' mambongni guk mokngang wara' adi uningkim mambong kababi'sini' ka 2 toea u bema tabanga kamigu'. ");
INSERT INTO uvh_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Ka Jisas adi taming u kanga arantagimni u katiana ning yanggu', sidi taming i kani' adi tatafak mambongni guk mokngang sini' de ka adi mambongni kabi'sini' wa wadigi'sa' bema tabanga kamira' dibing ka nana tona ga' guk mo' kabira' wara' adi aming ka mambong girisi kura yaring u irafata'. ");
INSERT INTO uvh_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","A aming ka mambong girisi girisi kuking adi dibing kunik girii wa anasita' unggung udanga kabinanga ning tanga dibingsa' manggara fabanga kuking a tamkasa' adi ning mo' tara' wara' ning torik adi aming fam u irafik sini' tara' ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Ka Jisas guk ka arantagimni guk wari siring yak girii u kabinga amanga fugang kadofinga aramugoging ka Jisas ning arantagimni nua'ni wari siring yak girii tempel u tubobu tong kanga Jisas ning anigu', ai girii siring yak girii i kaya' karengsa' tiging, uningkim girisi girisi wari wadigi' sini' tiptangkanga yareging karik. ");
INSERT INTO uvh_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Ka Jisas wari ning anigu', beng sini' gu yak girii kareng kigineng sini' karang kadaga titining guk mokngang ning kanga torang. Ka sireng ning ganotik, inga' yak ka ya i adera' ningsa' mo' adewa'ga' mokngang sini', uningkim girisi girisi ka yak fugu ganang u adeing wa kubanik guk mo' garanga adewa'ga' dabiksa' kuma' itatarasasu'nanga ipmainga mangfasasu'nani'ga' ning anigu'. ");
INSERT INTO uvh_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Ning tanga anga Jerusalem yong girii u kabinga amanga kama bubo kabasi' Oliv u areging. Aranga kadofinga mareiaging. Ka Jisas adi dokning anga mera fasa' tanga siring yak girii tempel u tonga arakafagu' ka arantagimni fama'gong fama'gong ka Jems iguyangguk Jon ya a Pita iguyangguk Andru ya ning wari mandang yaranga anga Jisas u ning anigaging, ");
INSERT INTO uvh_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","ai girii gam gu mamareng ka siring yak girii wari kadaga a mamareng fam wari kagadofi waraga' tongang wa dari kadofo'ga'. Nasi' wari kadofiinga kanga o kuma' ba kadofonga tara' ning wa wara'ganang nakedanga tonam ning aniging. ");
INSERT INTO uvh_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Ka Jisas wari ning yanggu', ka wara'ning wa ning sangnatamotik, mandaga' aming fam wari kadofinga abanga mandaga' ma siramikni' wara' sidi kafakafa naknga suktangkanga ikanting. ");
INSERT INTO uvh_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Kama ka wara'ganang wa mandaga' aming kabi'mo' wari kadofinga abanga mandaga' ning saramikni'ga', na Jisas urang wari abarik ning sana yareinga aming kabi'mo' wari bengsa' ba ning tonga adisa' manga iwaksasu'nani'ga'. ");
INSERT INTO uvh_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Ning tinga midi ka ami' girii wari kadofo' u naknga ning tanga kani' wa ami' nua'ni ka sidiganang ingging kadofinga arabo'ga'. Ka sidi u kanga mutu tanga ning mo' toni', o kama wari bibi' titining urang udi kuma' kadofira' ibanda'. Mokngang napa' ka wa kagadofi titiningsa' wara' wa tim sige kadofinga biwa', a kama wari wadigi' bibi'ning wa ko'. ");
INSERT INTO uvh_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Ning tanga mamareng ka kamaganang yara'ning aming arantagim girii wari tubo kidagang tanga ami' titi a aming kama nua'nining wari aming kama dibing nua'nining guk ami' a kining a tugumung girii wari yong yong u kadofinga yaro'ga'. Ka sidi u kanga nakeda tanga ning toni', o mamareng girii tim kadofiinga aming wari u kanga kagaya girii ka taming wari saba ibeunga urang minditing ningda'ning ninak wara'ning wa kuma' ara kadofinimara' yang. ");
INSERT INTO uvh_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Ka sidi kafakafa suktangkanga ikanting inga' aming wari ning siramikni'ga', adi sinagira fonga midiganang kuksap a siring yak ganang amanga midi ara ituani' unggung manggaksapma fefisap tini'. Ning tanga naganing kane tinga aming fam wari manggara fonga gavman ning aming girisi a king ganang midi tosam ning tini'. Ka sidi wara'ganang wa yapsara tanga mutu mo' tini', mokngang sidi naganing midi kareng itua ning kama guk ning kanga kura'bu wa naganing midi kareng u ituaimni'. ");
INSERT INTO uvh_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Ning tanga anganga aming aming wari naganing midi u dabiksa' naksasu'neinga wa napa'napa' wari bisasu'na wara'ning kama ari' wa inga' wara'ganangsa' kadofo'. ");
INSERT INTO uvh_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Ka sidi aming wari midi ganang manggara sipmiinga wa sidi a nasi' midi tontam ning tonga sasuk mimeng mo' tini', mokngang nasi' midi ka sidi tutugu wara'ning sasuk wa Anutuning mini unggo warisa' kuma' samo' wara'ganangsa' yaranga toni'ga'. ");
INSERT INTO uvh_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Abanga kama ka wara'ganang undu' napa' mamareng nua'ni ka ning tini', kuyase fam wari kuyase fam ka nagata' naktangka tini' waraga' bibi' nakyama midiganang ifikadofiinga aming wari didipmi titi a babangsi' wari mindine ka naktangka titi u fonga ifikadofiinga didipmi a mindine undu' ningsa' anasining babangsi' unggung tipkadofiaminga ugumak ning tanga yarani'ga'. ");
INSERT INTO uvh_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Beng guk sini' aming kabi'mo' wari sidi naganing kane tini' u sapma sidita' kabaksi' kadagang sini' naksama ning tanga kadapmang kadagang ka ning u siramira yarani'ga'. Ka aming ka naganing midi a wap u kagabi guk mo' tanga tangkunang ningsa' surotangkanga tanga ira awa' wa na gi' bema kamiinga adi iik kareng ka ka' fikifiki ningsa' wara'ganang ira awa'. ");
INSERT INTO uvh_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Aming ka midi ka i toutik i indangira wa kafakafa sura nakedota'. Ka kama ka wari kadofonga wa tim ka napa' kadagang sini' nua'ni wari kama tapni tangkunang sini' ka adi iikning guk mokngang wara'ganang kadofinga adewa' u kani'ga'. Ka sidi u kanga wa unggung mo' marekni', mokngang sidi nakeda tanga aming ka kama tubo Judia tara' ikni' dabiksa' sidi marara bima tanga kama karang kamani do bimanga marani' wa giri gi' ikni'. ");
INSERT INTO uvh_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","A aming ka fugang marero' adi napa' u kanga marara napa'ni bemnanga iwak ning tonga yak iyung mo' amo', mokngang adi bima sa' tanga mawa'. ");
INSERT INTO uvh_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","A aming ka feng ganang anga fato' undu' ningsa', adi kwi'ni bemnonga yong ganangga' tubobu mo' unara abo', mokngang adindu' tubosa' bimanga mawa'. ");
INSERT INTO uvh_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","A taming ka saba kabaksi' ganang a saba ginggiming inga' ibenga deiro' wara'siga' wa ning torik, bibiri' sini' adi mamareng girii guk kubase'sini' bimanga marani'ga'. ");
INSERT INTO uvh_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Ka mamareng girii ka wa kama ka gimak a sibim girii wari kadofita' wara'ning bining ganang ma kadofisamo' wara' sidi waraga' sura Anutuga' ibang tangkunang tonga ira anting. Ning tinga mamareng ka wa kama sige ganang kadofisaminga sidi sia da' tini'. ");
INSERT INTO uvh_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Beng sini' mamareng ka ningwara' wa tim guk mo' kadofigu' mokngang, abanga inga' mamareng ka wari kadofinga biinga undu' mo' kadofo', mokngang bining wara'ganangsa' mamareng ka ningwara' wari kadofo'ga'. Tim Anutu wari kama a napa'napa' tugu' ganang u ira ababanga kami yara'ganang undu' mamareng ka ningwara' guk mo' katam kugurang karengsa' ira abutam. ");
INSERT INTO uvh_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Ka mamareng girii ka wari kadofo' wa urap bibi'ning guk mokngang, wa mamareng ningsa' kadofinga anganga Anutu warisa' udagainga bining biwa'ga'. A adi mo' udaga wa aming kabi'mo' bisasu'nasa' titining, a Anutu adi aming karesi kubanik kubanik ka kuma' ifakasirinanga ibinagu' wara'siga' sura wa adi pumpurum da' udawa' wang. ");
INSERT INTO uvh_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Ka wara'ganang aming fam wari yangara ning saninga ai, Kasira Aming urang udi kuma' abara' yang wa ma Kasira Aming ka do arabara' wang, ning sana yareinga wa sidi mo'sini' nakyamni'. ");
INSERT INTO uvh_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Beng sini' kama ka wara'ganang wa mandaga' aming kabi'mo' wari kadofinga abani'ga'. Abanga ning toni', na Anutuning Kasira Aming a fam ka na midi togadofi aming profet girii ning tonga napa'napa' tangkunasi' fam u beng sini' da'ning tanga yarani'ga'. Ning tinga aming arantagim ka Anutu wari ifakasirineinga adita' naktangka kuma' tanga ikni' adindu' bengsa' ba ning tonga manga iwak sa' titiga' da'ning tini'ga'. ");
INSERT INTO uvh_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Ka sidi bengsa' ba ning tonga ma manga iwakni' wara' sidi kafakafa suktangkanga ikanting. Midi ka mamareng wari kadofonga tinga napa' fam wari tim kadofinga yapkeda wara'ning wa kuma' sana yararik wang wara' sidi napa' ka wari arakadofiinga kanga wa sidi nakeda sa' tini' ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Ning tanga ning yanggu', napa' mamareng girii ka u tonga yararik wari binga kani' wa mayam de wari wadigi' kangkamaro'. Ning tinga mayap undu' kangkamara to'. ");
INSERT INTO uvh_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Ning tinga napa'napa' ka kunimganang kuta ikiting undu' tuntumurum tanga yaranga bam wa dura mangfu tini'ga'. ");
INSERT INTO uvh_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Ning tanga anganga napni' ka ari'sini' wa Amingning Tim Iyak naga tangkunang girii guk ka diok kigineng girii guk kunimganang kuta arafok. ");
INSERT INTO uvh_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Afanga naganing kuning aming ensel arantagim u yangkareinga anga kamaganang yara'ning yong yong u yangaksasu'nanga aming ka Anutu wari adita' kuma' ifakasiringa ibo' unggungsa' inagira abani'ga ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Ning ina ning tanga ning yanggu', ka sidi kama kareng daunga tinga wa firi fam undu' kuma'sa' yapkedating adi sasa' piriring tanga afuinga yapma wa sidi o kama kareng kuma' ba faronga tara' ning wa wara'ganang tuguting. ");
INSERT INTO uvh_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Ka napa'napa' ka naga u tonga yararik wari kadofinga arayaro' undu' firi u yapkedating ningsa' kanga nakedanga o girini' kabi'sini' afota' ning tonga dengyak sa' tini'. ");
INSERT INTO uvh_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Beng sini' sanirik ami taming ka kami yara'ganang iking wari dabiksa' ko mo' kumaksasu'neinga ganang napa' ka u torik wari bining ganang kadofo' u kuma'sa' kani'ga'. ");
INSERT INTO uvh_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Beng guk sini' torik kunim a kama a napa'napa' dabiksa' wa wadigi' kuma'sa' bisasu'naning a naganing midi wa mokngang fikifiki ko ningsa' ira au wara'ning ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Ning tanga nua'bu yanggu', beng sini urang sanirik kama ka Amingning Tim Iyak naga tubobu afufu wara'ning wa aming ka ni wara'guk mo' nakedara' mokngang sini'. Kunim aming undu' wara'guk mo' naking mokngang, a mindingni naga undu' wara'ning guk mo' nakedarik, mokngang sibeng Anutu anapmo' kubanik warisa' wa giri naknga ita'. ");
INSERT INTO uvh_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Ka sidi kama ka naga afufu wara'ning wara'guk mo' nakeding wara' sidi tugunung tanga sidining kadapmangsi' u tipdidimanga nipmekanting. ");
INSERT INTO uvh_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Ka naga tubobu afufu wara'ning wa kadapmang ka aming girisi wari kane aming ga' kane urang ima mugoting ningda'ning. Adi ning titing, aming girii wari kamani maunga wa adi kane amingni wara'siga' kane ima yaranga ning tanga kane aming ka adining yak katatora ning u ning anota', gu som tangkunang tanga irotang. Ning aninga ning tanga ibinga mugoting. ");
INSERT INTO uvh_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Ka sidindu' ningsa' sidi yak tuang ning kane aming arantagim ningda'ning iking a na yak tuang wara' sidi naganing napa' samirik ya kafakafa yaptatoranga tanga ikianting naga' tanga sidi kama ka naga tubobu afufu wara'ning guk mo' naking kibiri wa ma tiim bining wa ma kamindap gaa' sini' wa ma mayam kuma' kadofiinga ganang udep abok wara' sidi sasuk tangkunang tanga som da'ning tanga ikanting. ");
INSERT INTO uvh_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Ka na ko da' mo' tok, urapsa' afok ka sidi tugunung wa indining tanga tini'ga'. Mokngang, tugunung titining kama guk mokngang wara' sidi tugunung tim tanga nipmeiakni' wara' siasa' tini'. ");
INSERT INTO uvh_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Beng sini' midi ka i torik ya sidisa' mo' sanirik, mokngang ya aming dabiksa' inirik wara' midi ka i naknga tugunung tanga ikanting ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Ka sande girii wapni Pasova ka baret yis guk mo' sanga niaging wari kagadofi ga' kama fama'sa' ko adegu' ganang ka pris girisi a sasuk aming wari bak kura ning tanga Jisas u mandaga' taramira ugumak titiga' bimbem wara'ning kadapmang katua waraga' midi tonga naking. ");
INSERT INTO uvh_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Ka adi ning toging, indi bimbem tonga wa sande girii ganang didimeng mo' bemtam, wa aming arantagim wari u kanga a ning guk wa naga' ting ning tonga kabaksi' kadagang naknga banaksi' giptanga marara indi indifantam ning tonga tanga anasa' ma amini' ning toging. ");
INSERT INTO uvh_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Ka Jisas adi Betani yong u anga aming nua'ni ka tim bagana kadagang lepa kayong kafong natugupmuranga tanga karendagu' wapni Saimon adining yak ganang amogu'. Amanga ning tanga aming fam guk nana kubap mera naging. Ka taming nua'ni wari iyung amanga ananing wel mupmu adi' karengsa' ka uningkim mambong girii warisa' toyaging u kandang guk bema afanga de u dura ning tanga Jisas ning ki ganang u tagara sufurungama yaregu'. Wel ka wa tim aming kungkumosi ning fuksi'ganang sufuraimiaging ningwara' u tagakngamgu'. ");
INSERT INTO uvh_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Ka aming fam wari kigesini kanga ning toging, ai ya ning guk wa naga' tara' wel kareng toni girii ka sigesa' guk wa nasi'ga' tagakngamara'. ");
INSERT INTO uvh_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Wel kandang ka ning ya aming fam ga' ima uningkim mambong manggara tatafak aming arantagim u yotangkayabaro' wa karengsa' ning toging. Ning tanga taming u kafangani tiging. ");
INSERT INTO uvh_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ka Jisas wari ning yanggu', ai sidi nagata' kareng tanamonga tara' wa anisefi mo' tinting kagabi sa' tini'. ");
INSERT INTO uvh_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Ka ning sanotik, sidi tatafak aming yotangkayap ga' beng sini' sura toyaning ganang wa ning nakni', adi sidigok ingging kama paramu' ko iikning wara' sidi tatafak aming u yotangkayabonga wa inga' yotangkayapmanting a na ya kama paramu' iikning mo', inga' ingging kuma' sibinga mautik. ");
INSERT INTO uvh_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Wara' taming wari napa' i tanamara' ya girisa' tanamara', adi wel tagaknamara' ya inga' naga kungkumak tinga kama ginang ganang tonga nipmifaronga tanamni' wara'ning tigigira tanamara'. ");
INSERT INTO uvh_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Beng sini' sanirik inga' aming kama yong yong wari naganing midi naknga a kami taming wari kareng tanamara' yara'ning midi naknga ning tini'ga' ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Ka Jisas ananing arantagim nua'ni wapni Judas Iskeriot adi Jisas u tipkadofiam wara'ning midi tounga pris girisi yabonga ibinga agu'. ");
INSERT INTO uvh_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Anga aming girisi ganang u kadofinga midi ka Jisas u tipsarendaiminga bimbem wara'ning u yanggu'. Ning tinga aming girisi adi Judas ning midi u naknga kabaksi' karengsa' naknga Judas ga' uningkim mambong amimi waraga' midi totangkaging. Ka Judas adi tubobu ibinga anga Jisas u tipkadofiam ning kadapmang waraga' indining da'ning tanga tipkadofiamotik sam ning tonga sasuk mimeng tanga agu'. ");
INSERT INTO uvh_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Ka sande girii Pasova ka baret yis guk mo' sanga nana a Pasova waraga' sipsip u dipming dop ning tiaging wari kuma' kadofonga tugu' u kanga arantagimni wari Jisas u ning aniging, girii indi guta' Pasova ning tangsana wa indeng anga tagamtam. ");
INSERT INTO uvh_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Ka Jisas wari u naknga arantagimni fama' tim yangkaronga ning yanggu', sidi Jerusalem yong girii ga' tim ademu'. Anga kadofinga kantamu' ka aming nua'ni ka ama gira barungnanga ara abota' u katuanga adigok manting. ");
INSERT INTO uvh_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Anga yak ganang dabik amanga ning tanga yak wara'ning tuang u ning anintamu', ninggek aming udi ning tora' na arantagimna guk tangsana Pasova wa indeng tanga mera nantam ning anintamu'. ");
INSERT INTO uvh_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Ning tinga yak wara'ning tuang wari sinagira fonga iyung bane nua'ni ka tangsana wara'ning napa' kuma' fideing u sangtintingneinga yapma nana tugunung kafakafa tantamu' ning yangggu'. ");
INSERT INTO uvh_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Ning ininga agumu'. Anga yong girii do kadofinga ning tanga napa'napa' ka Jisas wari yanggu' udi beng guksa' kadofiinga yapma ning tanga nana tugunung kane u tugumu'. ");
INSERT INTO uvh_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Ning tanga Jisas guk ka arantagimni fam guk adi kibiri inga' anga kadofinga yapma ning tanga yak ka nana segumu' wara'ganang amanga arantagim 12 dabiksa' nana u mera naging. ");
INSERT INTO uvh_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Ka adi nana u ko mera naging ganang ka Jisas wari arantagimni u ning yanggu', beng sini' na sireng ning sanotik kami aming ka nana kubap mera nem dabiksa' sidining nua'ni wari anga naganing digirap ganang naganing wap u tipkadofiamota' ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Ka arantagimni adi midi ka u naknga kabaksi' mamareng naking. Ning tanga ning tonga yareging, ai girii nagata' u torang, naga mo' ning toging. ");
INSERT INTO uvh_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Ka Jisas wari ning yanggu', aming nua'ni mo' aming ka nagok nana dabik ka gafa kubaniksa' ganang mera niamuk anasa' nifikadofota'. ");
INSERT INTO uvh_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Beng sini' kadapmang ka Amingning Tim Iyak naga kungkumak titi wara'ning wa tim umpang ganang kuma' yoking wara' na u yaranga kungkumak sa' titining de ka aming ka naga nifikadofota' wa kagaya girii bimbem ning wara' na ning torik, bibiri' sini' aming ka wa mengni wari mo' ibeunga tugu' wa karengsa' adi kagaya girii wara'guk mo' bemaro' ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Ning tanga nana u ko mera naging ka Jisas wari baret dibing u bema Anutuga' mesisiringa tanga ning tanga upma arantagimni ga' ima yaranga ning yanggu', nana tini' ya naganing fukna gom samarik. ");
INSERT INTO uvh_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Ning tanga wain ama kap ganang ubu bema undu' Anutuga' mesisiringa ningsa' tanga arantagimni ga' iminga bema topnanga yareging. ");
INSERT INTO uvh_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Adi u topnainga ning yanggu, ama ka i topning ya naganing fukna amaa kwasanira' wara'ning u topning. Amaa ka yarisa' Anutuning midi ka aming dabik sidi yotangkasap wara'ning u kuma' iptatangkara'. ");
INSERT INTO uvh_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Beng guk sini' ning sanotik, kami na sidigok kamaganang i ira tanga nanga abutam wara'ning ari'sini' tanga topnem. Inga' nua'bu guk mo' nanga sige ningsa' ira anganga sibeng Anutuning yongganang do fabang kuksapma kabakni' ararangeng karengsa' naknga tanga wain ama inga'ni nua'ni mera nanam waraga'sa ikantam. ");
INSERT INTO uvh_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Ning ina ning tanga siring kubanik nua'bu tonga marara fugang kadofinga afanga yong u kabinga kama bubo kabasi' ka Oliv waraga' mugoging. ");
INSERT INTO uvh_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Ka Jisas wari arantagimni u ning yanggu', sireng ning sanotik sidi dabik kuma'sa' nibinga bimanga mani'ga'. Adi kadapmang ka wari kagadofi waraga' tim Anutuning midi ning kuma' yoking, na maga yaptatora aming u ukinga magani wari sansaramik bimanga papusinanga mani' ning yoking. ");
INSERT INTO uvh_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Beng sini' kuma' kumarok de ka naga tubobu marara wa na tim anga kama tubo Galili do sipmerok. Ka sidi mandang inga' anga naptuani' ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Ka Pita adibu ning anigu', ai girii aming fam wa giri gigibi tini' a na gigibi guk mo' tok mokngang sini'. ");
INSERT INTO uvh_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Ka Jisas wari ning anigu', beng sini' ganirik Pita gu kami tiim yara'ganangsa' kagare' wari ku fama' ko mo' katiinga gu naganing wap wa famineng ning sini' isisebeutang ga'. ");
INSERT INTO uvh_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Ka Pita wari tangkunang sini' nua'bu ning togu', a mokngang sini' girii na guning wap isisebe guk mokngang, nandu' udep nuronga tinga wa na gugok tangkunang dabiksa' adenga tanga kumakantamuk. Ning tinga arantagimni fam dabiksa' adindu' ningsa' tonga yareging. ");
INSERT INTO uvh_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Ning tanga Jisas wari arantagimni u inagira anga gwaya kabasi' binking kareng wapni Getsemani u famanga kukyapma ning yanggu', ingging marekni' na dota' anga ibang toutik. ");
INSERT INTO uvh_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Ning ina ning tanga arantagimni famineng ka Pita Jems a Jon ning unggungsa' inagira aging. Anga Jisas wari kaba mamareng girii naknga ");
INSERT INTO uvh_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","ning yanggu', o mokngang kabakna mamareng girii sini' nakarik kungkumak titiningsa' wara' sidi ingging nipmera naga yotangkanama ka' ningsa' marekni' ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Ning tanga kabi'ning ibinga anga ning tanga mamareng u tatarafik wara'ning kadapmang waraga' beni Anutu anonga kamaganang mangfanga mungkupna tanga dera ");
INSERT INTO uvh_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","ibang ning togu', o naning sibeng gu kagaya i mo' bimbemning ning udep sutang wa giri usefinam totang. Ka na naganing sasuk mo' yarotik guning sasuk sa' yaranga totik. ");
INSERT INTO uvh_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Ning tonga tubobu abanga yapku' ka arantagimni famineng udi dama sa' defaging. U yapma Jisas wari Pita u ning anigu', ai Saimon gu dama sa' ba defatang, tangkunang mera som kabi'guk mo' wa indining tarang ning anigu'. ");
INSERT INTO uvh_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Ning tanga famineng dabiksa' ubu yanggu', sidi dama mo' dekanting mamareng kadofota' mangfu ma tini', som tangkunang tanga ibang toni'. Beng sini' kabaksi' wa giri yotangkanap ga' suking de ka fuksi' warisa' tanga baragana ting. ");
INSERT INTO uvh_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Ning tanga tubobu ibinga anga ibang ka tim togu' ningsa' unggung nua'bu togu'. ");
INSERT INTO uvh_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Tonga ning tanga abanga yapku' ka arantagimni udi dama tangkunang sini' deking. Adi kwang mareiaging u mokngang, dama wari tanga fuksi' baragana sini' tanga dama ubu manga deking. Ning tanga seganga marara Jisas u kanga megang naknga midi guk mo' aniging. ");
INSERT INTO uvh_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Ka Jisas adi ningsa' yapma ibinga tubobu anga ibang nua'bu togu'. Tonga ning tanga abanga yapma ning yanggu', ai sidi mengkura kafakafa tanga dama ko ba defaking. Ka i kani' kabi'sini' aming nua'ni wari Amingning Tim Iyak naga ninagira tonga aming kadagang titisi ning kafasi'ganang nipmota'. ");
INSERT INTO uvh_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Mamarak tanga mugo tanam, aming nifikadofi titining kuma' kadofira' do kani' ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Ning tanga Jisas wari arantagimni famineng u midi ko araininga ananing arantagimni nua'ni Judas ka tipkadofi tugu' wari abanga kadofigu'. Adi aming arantagim girii ka pris a sasuk aming a aming girisi fam wari Jisas bimbem waraga' yangkareinga kwak suguk tanga marara abiging u inagira abanga kadofingamging. ");
INSERT INTO uvh_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Ka aming tipkadofi tugu' Judas adi aming u tim ning kuma' yanggu', aming ka naga suronga tutu' yorama aratotik u kanga wara'ganangsa' anga bemting. ");
INSERT INTO uvh_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Ning kuma' yanggu' wara' Judas adi Jisas ganang u kadofinga o girii wa' ning tonga suronga tutu' yorama tanga aratugu'. ");
INSERT INTO uvh_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Ning tinga digirapni adi wara'ganang kadofinga bemging. ");
INSERT INTO uvh_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Ning tinga Jisas ning arantagimni nua'ni wari u yapma adining kwak bainat u weng bema pris arantagim ning girisi' adining kane aming u gufadaga ga' ning tonga tugu' ka mokngang, fe' tanga magi sa' gufadagagu'. ");
INSERT INTO uvh_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Ka Jisas wari aming arantagim ka bimbem tiging u ning ifang yanggu', ai na aming kadagang wa wara' sidi naga bemnabonga wa suguk kwak tanga kapmo'sa' abing. ");
INSERT INTO uvh_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Sidi kami tiim yara'ganangsa' wa indining tanga kadofinga bemnabing. Bemnap titiga' naknga wa na fikifiki siring yak girii ganang amanga aming fainggekitik wara'ganang sirengsa' kuma' bemnabonga tiging. Beng sini' napa' yaraga' wa tim Anutuning midi kuma' yoking wara' sidi wara'ganang didimengsa' yaranga ba tanabonga ting ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Ning tinga arantagimni dabiksa' adi mutu tanga Jisas u kabinga bima tanga mugoging. ");
INSERT INTO uvh_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Ka saba uyamang nua'ni adi nip fafa' tama ning tanga Jisas ning kumo ganang unggung anapmo'sa' kuma' yaranga anga adegu'. ");
INSERT INTO uvh_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Ka aming wari bimbem tantam ning tonga bemging ka mokngang, kasi ururup tanga kwi'ni sa' iromfadakinga fugu bi' sigesa' bimanga mugogu'. ");
INSERT INTO uvh_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Ning tanga aming ka Jisas bemging wari Jisas u nagira pris girii tim iyak ning yak ganangga' aging. Ka pris girisi a aming girisi a sasuk aming adi yak ka wara'ganang abanga bak kuma' kura ipmeking. ");
INSERT INTO uvh_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Ka Pita adi aming wari Jisas nagira aging u kanga mandang iwara anga dokning ira famugogu'. Anganga pris girii ning yak wara'ning sinim iyung bane ganang unggung amanga Jisas u yak iyung u nagira amoinga Pita adi plisman ka pris girii ning yak katatora ning wara'siguk sinim iyung unggung kudip sanga mareiaging. ");
INSERT INTO uvh_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Ka pris girisi a Juda ning kaunsil girisi arantagim ka bak tanga Jisas u kapmeking wari Jisas ning kadagang u katuanga wara'ganang ugumak ga' ning tonga aming fam katianinga anga Jisas u midi mandaga' fam sige animbenga yareging. Ka mokngang midi mamareng sini' ni ka ugumak titining guk mo' katuaging. ");
INSERT INTO uvh_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Aming siamo' wari midi kadagasi kabi'mo' animbenga yareging ka mokngang, adi midi kubaniksa' mo' toging, kuni' kuni' toging wara' adisining midi wa beng guk mokngang ning tugu'. ");
INSERT INTO uvh_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Ning tanga aming fam wari midi ka tim Jisas ana siring yak girii tempel u kwetataranga ning tanga tubobu tipmarak ga' yanggu' wara'ning waraga' sige animbeunga tipfara tanga ning toging, aming ka idi tim midi nua'ni ka ning togu', ");
INSERT INTO uvh_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","na siring yak girii tempel idi kuma' kwetataranga kama faminengsa' tempel nua'ni ka aming wari titining guk mokngang u tanga mawak ga' ning togu' ning toging. ");
INSERT INTO uvh_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ka mokngang adisining midi ka u animbeingaging undu' beng guk mokngang fisa' toging. ");
INSERT INTO uvh_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Ka Juda ning pris girii wari ubu marara adenga Jisas u ning anigagu', indining, gu midi u toing wara'ning tuboni guk mokngangsa' ba, tubo guk udep wa tutugu tinga naknam. ");
INSERT INTO uvh_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Ka mokngang Jisas adi midi tubobu guk mo' togu', sigesa' aradegu'. U kanga nua'bu anigagu', ma' Anutu girii ka kadagang ni guk mokngang adining mindingni Kasira Aming udi gu uba. ");
INSERT INTO uvh_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Ka Jisas wari togu', weng u torang warisa' aderik. Inga' Amingning Tim Iyak na Anutu kigineng ning kafong kareng ganang tangkunang guk marerok u napni'. Ning tanga tubobu undu' mungkong ganang sa' afok ning togu'. ");
INSERT INTO uvh_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","64","Ning tinga aming girii wari u naknga bane giptanga ananing kangkama u ibaramara ning togu', ai kareng guk mo' nakarik midi ka wa Anutu anikige ningda'ning kadagang sini' tora' nakarik. Midi wa ana kuma' tuguinga nakem una, midi nua'ni wa nasi' nakonga. Sidi wa indining suking aming fam nua' mo' yangkantam, ning yanggu'. Ning tinga aming wari u naknga a wa kungkumak titining sa' ning tonga yareging. ");
INSERT INTO uvh_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Ning tanga aming wari Jisas u iguk sombara kwi' dibing bema Jisas ning de u iptasefangama uuk tanga ning anikigeging, a gu profet urang udi. Ka gu profet sini' ganang wa nisi' nisi' wari guking wapsi' u nine' ning aniging. Ning tinga polis ka siring yak girii u katatoriaging adibu tubosa' nagira tafanga fangi u pipeging. ");
INSERT INTO uvh_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","67","Ka Pita adi kudip sanga mareiaging ganang unggung ko merafagu'. Ka pris girii ning kunung taming nua'ni wari anga kanga ning anigu', a gu udi kuma' gapkedarik Jisas Nasaretni guk fengating. ");
INSERT INTO uvh_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Ka Pita adi isasura tanga ning togu', a gu sige torang na u torang wa nafek sa' ba tirik. Ning tonga marara sinim fugang amanga isisa unggung tigiringa adegu'. Adenga naku' wa kagare' wari ku katigu'. ");
INSERT INTO uvh_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Ning tinga taming wari nua'bu kanga aming fam u yanggu', ai aming i fidera' idi adining arantagim udi. ");
INSERT INTO uvh_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Ka Pita adi isasura tanga nua'bu tugu'. Ning tanga kabi'ning adeia' aming fam ka unggung adeging wari nua'bu aniging, a gu udi kuma' gapkedem Galili aming adining arantagmni. ");
INSERT INTO uvh_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Ka Pita adi isasura tangkunang sini' nua'bu tanga midi tangkunang ning yanggu', beng sini' Anutu ganang kuta urang sanirik na aming ka wara'guk mo' sini' katik. ");
INSERT INTO uvh_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Ning tuguinga kagare' wari ku nua'bu katigu'. U naknga Pita adi midi ka tim Jisas wari adining wap famineng sini' u isisebegu' waraga' anigu' wara'ning u suknatama ning tanga adining kadagang waraga' sura kaba mamareng girii naknga mak fidenga fakogu'. ");
INSERT INTO uvh_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Ning tanga kama fagainga pris girisi a aming girisi fam a sasuk aming a Juda ning kaunsil girisi arantagim wari bak kura midi nua'ni totangkaging. Tonga naknga ning tanga Jisas ning kafong u ipma bema tonga Romni kiap girii Pailat ning kafong ganang ubu kamiinga adegu'. ");
INSERT INTO uvh_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Ka Pailat wari Jisas u ning anigagu', ma' gu Juda ning girii wa. Ka Jisas wari ning anigu', weng ga kuma' torang una ningsa'. ");
INSERT INTO uvh_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Ning tinga pris girisi wari midi sige fam kabi'mo' animbenga yareging. ");
INSERT INTO uvh_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Ka Pailat wari u naknga Jisas u ning anigu', indining, adi midi kabi'mo' gangbeing wa gu midi tuboni guk mo' toutang wa. ");
INSERT INTO uvh_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Ka mokngang Jisas adi midi guk mo' togu', sige arade sa' tugu'. U kanga Pailat adi sasuk mimeng tugu'. ");
INSERT INTO uvh_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Ka kiap Pailat adi Juda aming ning kabaksi' ifakarenda waraga' sura kadapmang nua'ni ka ning tarugu', adi gurak kubanik kubanik ka sande girii Pasova wara'ganang fikifiki aming kalabus kane tanga ikiaging u kubanik ning fadara kamiam ga' aniinga fadara ipmiamarugu'. ");
INSERT INTO uvh_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Ka wara'ganang aming kadagang titiing nua'ni undu' kalabus iyung unggung fidegu' wapni Barabas. Adi tim amine fam guk Romni gavman tipkadaga ga' sura ami' tanga aming fam dipmakumoging waraga' tanga tabanga dasiinga Barabas adi iyung kane kalabus u tanga itarugu'. ");
INSERT INTO uvh_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Ka ami taming kabi'mo' wari bak girii tanga Pailat u ning katingangging, indi gu kadapmang ka aming kubanik fadara kamanim ning urang titang u nua'bu tinim ga' nakem ning katiging. ");
INSERT INTO uvh_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","10","Ka Pailat adi pris arantagim wari Jisas ga' nakadangam tanga tonga amiging udi kuma' yapkedagu' wara' adi ami taming u ning katianggu', sidi Juda ning girii i kabisaminga mugo ga' naking wa ma. ");
INSERT INTO uvh_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Ka pris girisi arantagim adi ami taming u Barabas ga'sa' tutugu ga' kuma' yangging wara' adi Barabas u kabiam waraga'sa' katingangging. ");
INSERT INTO uvh_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Ning tanga Pailat wari nua'bu yanggu', a aming ka Juda sidi sidining girisi' ning faniting ya indining totik. ");
INSERT INTO uvh_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ka adibu ning katiging, wa firi ugari ganang bema ugare'. ");
INSERT INTO uvh_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Ka Pailat wari ning yanggu', ka nasi' kadagang tanga' wara' na firi ganang ugarotik. Ka adibu nua' katiging, a wa firi ganang ugare' ning udi kabi'mo' katinga yareging. ");
INSERT INTO uvh_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Ning tinga Pailat adi u yapma mutu tanga adisining kabaksi' u ifikura waraga' Barabas u kabiamgu'. Ning tanga Jisas wa ananing ami'ning aming fam ga' ima ning yanggu', i fifefi tanga nagira tonga firi ganang ugarini'. ");
INSERT INTO uvh_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Ning ininga Pailat ning ami'ning aming wari Jisas u nagira gavman ning yak wara'ning sinim iyung nagira afanga ning tanga ami'ning aming fam u dabiksa' katiana abanga Jisas ganang u bak girii tiging. ");
INSERT INTO uvh_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Tanga Jisas u megang bimbem ning kadapmang taramironga adining kwi' kangkama timini u kifangama ning tanga kwi' giming kareng ka aming girisi king warisa' ipmanga yangakiaging ningwara' ubu kamingamging. Ning tanga king ning mungkup tigigira ning tonga aya kusung guk u gusinga bema ki ganang u kamingama ning tanga ");
INSERT INTO uvh_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","midi anikige ning tiging, o Juda ning aming girii i kani'. ");
INSERT INTO uvh_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Ning aninga ning tanga kwak kabasi' wari ki kati kuta ura iguk sombara ning tanga Jisas ning wap bema ara mandaga' tanga adining kayong ganang u mandaksi' sige upma mareking. ");
INSERT INTO uvh_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Adi kadagang ningsa' taramira anganga ning tanga midi anikige tiging u kabinga kwi' giming kareng kamingamging u tubobu iromkifing bema ananing kwi' kangkamani timini u tubobu bema dasingamging. Ning tanga ugari titi waraga' nagira aging. ");
INSERT INTO uvh_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Ka aming nua'ni wapni Saimon ka Aleksanda ya Rufus ya ning babangsi' ka kama tubo Sairini tara' u ikarugu' ka adi yoring kabinga Jerusalem yong girii ga' mabugu', ka yong bibik u arabugu' u katuaging. Katuanga ning tonga katingangging, ai i abanga aming yara'ning firi ugari i barungnangama ning tanga anam. Ka adi midi tangkunang sini' aniging waraga' tanga abanga Jisas ning firi ugari u barungnangama ning tanga aging. ");
INSERT INTO uvh_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Anganga kama wap Golgota u kadofiging. Ka wap ka Golgota wara'ning ki wa aming ki kati ning aniaging u kadofiging. ");
INSERT INTO uvh_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Kadofinga ning tanga ugari tinga kagaya mimeng ninak u tipkura waraga' ning tonga wain ama ka ama kiptang nua'ni guk kuma' tanga bema aging u tagara amiging. Ka mokngang Jisas adi bibi' naknga topna guk mo' tugu'. ");
INSERT INTO uvh_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Ning tanga Jisas u bema firi ugari ganang ugariging. Ugaringa kabinga ning tanga Jisas ning kwi' kangkamani kifang kufaging u tanga bemna waraga' kat tiging. ");
INSERT INTO uvh_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Ka kama ka Jisas u ugaringa wa 9 klok kamindapking ganang ugariging. ");
INSERT INTO uvh_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ugaringa ning tanga firi dibing bema finga kudi ning yoking, YA JUDA NING GIRISI'. Ning yora bema Jisas ning ki ganang using u tapking. Midi dibing kabi' ka u yoking wa Jisas ugumoging wara'ning ki u yora tapking. ");
INSERT INTO uvh_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Ning tanga kubu aming kadagasi fama' undu' inagira fabanga Jisas ning gagaa ganang ugariapking, nua'ni ka kafong kareng ganang tara' a nua'ni ka kafong kesini ganang tara' ning ugariapking. ");
INSERT INTO uvh_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","(Ka adi napa' ka u kadofigu' waraga' wa timinggi' Anutuning midi umpang ganang ning kuma' yoking, adi aming kadagasi guk adeinga adisigok dabiksa' ning kanga indangikyabing wara' wara'ganang didimengsa' kadofigu'.) ");
INSERT INTO uvh_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Ning tinga ami taming wari unggung tarafira yangara darang kanga sunumpup tangama midi anikige ning tiging, ai ma gabem gu siring yak girii kwetataranga kama famineng ganang kaga'sa' tipmarak ga' urang fatugutang wa indining. ");
INSERT INTO uvh_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Gu tangkunang guk udep wa giri, ganing fuka u yotangkanga firi ugari u kaga' urapsa' kabinga afuinga gapnam ning anikigenga tarafira yangaging. ");
INSERT INTO uvh_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Ning tinga pris a sasuk aming fam adindu' anikige tanga ning toging, a adi aming fam wa giri fayotangkaimita' a ananing fugu yotangkara' wa indeng. ");
INSERT INTO uvh_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Adi na Kasira Aming Isrel ning aming girii ning fatuguta' ka adi ugari u kabinga afuinga kanga wa giri o adi aming girii beng sini' ba ning wa wara'ganang tontam ning aniging. Ka aming kadagasi fama' ka Jisas ananing gagaa ganang ugariapking adindu' anikige ningsa' tugumu'. ");
INSERT INTO uvh_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Ka adi Jisas u bema firi ganang ugaringa ning tanga anganga 12 klok sidii sini' mayam de wari kangkamara tanga kama yong yong dabiksa' kama garinga yaregu'. Garinga anganga 3 klok kibiri wa kama wari tubobu fagagu'. ");
INSERT INTO uvh_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Fagainga Jisas wari kungkumak tonga ku ning katigu', ilai ilai lama sabaktani. Ka midi ka wara'ning kini wa o naning Anutu naga' nibirang ning togu'. ");
INSERT INTO uvh_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Ning tinga aming fam ka unggung ko fideging wari ku ka ilai u katigu' u naknga profet Ilaija ba katinganara' ning tonga ning toging, ai Ilaija katinganara' u nakni'. ");
INSERT INTO uvh_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Ning tonga aming nua'ni wari unara anga wain ama kiptang u bema abanga napa' ni wari tabara kuyang ganang tanga bema Jisas ning mini ganang u gidengamging. Ning tanga ning togu', ko do adeia' kanga inam, Ilaija wari udep yotangkangama tataranga kamota'. ");
INSERT INTO uvh_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Ning tanga Jisas wari ku bang sini' nua'bu ari' katinga kungkumak wadigi' tugu'. ");
INSERT INTO uvh_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Ka Jisas wari kumogu' wara'ganang didimeng sini' ka siring yak girii ning kwi' girii ka iyung bane kabasi'ning bagi tabinga isefinga fiderugu' wari anasa' using kuta ibaramara amanga kaing apa dapmagu'. Ning tanga tubo kidagang tinga iyung bane kabasi' wari sangangsa' ubu adegu'. ");
INSERT INTO uvh_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Ka ami'ning aming yaptatora wara'ning girii nua'ni adi Jisas ning ugari ganang unggung ko fidegu' wari Jisas wari kungkumak tonga ku katigu' u naknga ning togu', o idi Anutuning mindingni beng sini' karik. ");
INSERT INTO uvh_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Ka taming fam undu' dokning kura fidenga tabanga fakafaging. Ka taming u fideging wara'sining fam ning wapsi' wa ning, Maria ka yong Magdalani a Maria ka Jems nua'ni ya Joses ya adisining mamangsi' a Salomi abanga taming fam ning wari fideging. ");
INSERT INTO uvh_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Taming arantagim ka wa tim Jisas wari kane ka kama tubo Galili do ira tanga yaregu' u tanga yotangkangam fatiaging, ka inga' Jisas wari Jerusalem yong girii ga' areinga undu' kubap yaranga areging wari fidenga fakaging. ");
INSERT INTO uvh_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Ka Jisas wa Juda ning sande girii Pasova kayaging wari kamindapning kagadofi ga' yainga kami ning uking wara' Juda ning kaunsil arantagim wara'ning aming nua'ni wapni Josep ka yong Aramatiani adi aming ning dasi'ganang wap kareng guk itarugu' wari kibiri kaga' wara'ganangsa' Jisas ning fugu u bema tonga kama ginang ganang dadasi waraga' midi tounga kiap Pailat kaunga agu'. Ka Josep adi naktangka aming adi kama ka inga' aming wari Anutuning bining ganang iik wari kagadofi waraga'sa' sura itarugu' ka wari anga ananing fugu ga' mutu guk mo' tanga Pailat u ning anigagu', na Jisas ning fugu u bimbem ga' ning tonga abarik. ");
INSERT INTO uvh_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Ka Pailat adi u naknga iguk da'ning aranga ning anigu', beng torang wa, kuma' u kumara', urapsa' wa indining tanga kumara'. Ning tonga ami'ning aming yaptatora ning girii nua'ni u katingana ning anigagu', ma' aming urang ugaringing udi kuma' u kumara'. ");
INSERT INTO uvh_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Ka adi ning anigu', weng kuma' kumara'. Ning aniinga naknga Pailat wari Josep ga' aigangam sa' tugu'. ");
INSERT INTO uvh_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Ning tinga Josep wari aming fam ganang kwi' fafa' inga'ni kareng u tonga bema abanga Jisas ning fugu kungkumong firi ugari ganang fidegu' u tatarang bema kamanga ning tanga kwi' fafa' wari tumuku'. Tumura ning tanga bema tonga kama ginang ka tim kuma' unanga kabiging wara'ganang kufara ning tanga kama ginang wara'ning de wa uningkim pampangareng girii nua'ni u tipdaranga tabanga isefi tangkanga kabigu'. ");
INSERT INTO uvh_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Ka taming fama' ka Maria Magdalani guk ka Maria Joses ning mengni guk adindu' kubap yaranga anga kuma' fidenga fakagumu'. ");
INSERT INTO uvh_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Ka Juda ning sande girii Pasova wari kadofigu'. U kanga defafa' ka kibiri ganang taming famineng ka Maria Magdalani a Maria ka Jems ning mengni a Salomi ning wari Jisas ning fugu ganang sufurangam waraga' sura napa' mupmu guk karesi anga yapma toging. ");
INSERT INTO uvh_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Tonga ning tanga fabang kura deia' sande kamindap gaa' sini' marara Jisas ning fugu ka kama ginang ganang dasinga kufaging u kaunga aging. ");
INSERT INTO uvh_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Ka kama ginang ka Jisas ning fugu u tonga kufaging wara'ning deni udi uningkim girii sini' wari isefiging wara' adi kadap anga ning toging, ai indi taming sa' mayam ya, kama ginang de wa nisi' ami wari yotangkanga ning tonga tonga aramugoging. ");
INSERT INTO uvh_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Ning tanga anganga kadofinga dokning ira tonga kaging wa uningkim pampangareng girii ka kama ginang de isefiging udi kuma' daranga anga dokning adeinga kama ginang wari sigesa' adegu'. ");
INSERT INTO uvh_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","U kanga anga kama ginang iyung bane u amanga ning tanga kaging wa aming saba uyamang nua'ni wari kwi' fafa' guk kafong kareng ganang tara' mareiagu'. U kanga base tanga adeging. ");
INSERT INTO uvh_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Ka aming wari ning yanggu', sidi mutu mo' tinting, na kuma' sapkedarik sidi Jisas Nasaretni ugariging u kaunga abing. Ka ning sanotik Jisas wa ingging ko mo' defata', tubobu kuma' seranga marara'. Abubu tanga kama gipmam tabanga kufak tiging ya sa'kani'. ");
INSERT INTO uvh_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Ka sidi i kadidimanga tubobu anga Jisas ananing arantagimni ka Pita se' u yangting. Ka Jisas adi Galili do sipmeronga tim kuma' manga' wara' arantagimni adi mandang yaranga anga Galili do kuma' katuani' ana tim kuma' yanggu' ningsa' ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Ning tinga taming adi u kanga kama ginang u kabinga afanga mutu tanga tubobu bimanga mugoging. Ka adi napa' girii u kanga mutu girii tiging waraga' tanga aming fam guk mo' yangging. ");
INSERT INTO uvh_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","(Ka Jisas adi tubobu kuma' marara anga sande kamindapking ganang tim munumung sini' ka Maria Magdalani wara'ganang kadofigu'. Taming ka wa tim Jisas ana mini unggo kadagasi seven ning tanga igukngamgu' wara'ganang kadofigu'. ");
INSERT INTO uvh_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Ning tinga taming wari u kanga Jisas ananing arantagimni u inonga agu'. Ka arantagimni adi Jisas ga' sura mak kara kabaksi' mamareng naknga merafaging u anga yapma ning yanggu', ai Jisas urang udi tubobu kuma' marara' kanga abarik ning sanem. ");
INSERT INTO uvh_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Ka adi a wa wadigi' kuma' urang kumogu' udi, ning tonga adining midi nakngam guk mo' tiging. ");
INSERT INTO uvh_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Ka inga' Jisas wari kadapmang nua'ni ubu tanga arantagimni fama' wari yong girii u kabinga aramugogumu' ganang kadofiamgu'. ");
INSERT INTO uvh_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Ka aming fama' adi u kanga anga Jisas ning arantagimni u yanggumu' ka adindu' nakyam guk mo' tiging. ");
INSERT INTO uvh_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Ning tanga nua'bu ari' wa arantagimni 11 dabiksa' wari yak nua'niganang nana kura mera naging wara'ganang kadofiamgu'. Kadofinga ning ifang yanggu', sidi naktangka tangkunang guk mo' ba tanga ikiting wara' sidi naga aming fam ganang kadofarik u napma abanga saninga ninak kabi'guk mo' ting. ");
INSERT INTO uvh_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Ning ina ning yanggu', sidi naganing midi kareng i bema anga yong yong ka kama kama dabiksa' u yangara ituaima yarani'. ");
INSERT INTO uvh_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Ning tinga aming ka midi u naknga nagata' naktangka tinga ama ingamni' wa Anutu wari yotangkangaminga adi kadaga guk mo' to'. A aming ka naganing midi kuma' naknga naktangka guk mo' to' wa adi wadigi' bisasu'na wara'ning. ");
INSERT INTO uvh_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Ka aming ka nagata' naktangka tini' wa na yotangkayap tanga tangkunang iminga napa' tangkunasi fam guk tanga yarani'ga'. Aming fam ka naganing wap tonga masi' unggo kadagasi tanga igukyam wara'ning tangkunang imok a fam ka midi tipfara tanga midi nua'niganang tutugu wara'ning u imok. ");
INSERT INTO uvh_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Iminga adi tangkunang ka wara'guk ira gimik kagaya wa ma napa' kiptang kadagang ni ka nakeda guk mo' u tanga topnanting udi wari tanga kungkumak guk mo' tini'ga'. A aming fam wa tangkunang ka bagana aming u suroyap sa' tinga karenda wara'ning u imok ga', ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Ka Girii Jisas wari arantagimni ga' midi ari' u ima ima ning tanga adeinga beni Anutu wari kunim furo'ning ga' tubobu wadigi' nagira aregu'. Nagira taranga adining kafong kareng ganang kamiinga girii ira marekita'. ");
INSERT INTO uvh_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Ka arantagimni adi Jisas ning midi kareng u bema anga kama yong yong dabiksa' u yangara ituasasu'nanga yareging. Ka Jisas adi iibi sini' mo' tugu', mokngang adi arantagimni u ko yotangkayapma aming wari adining midi u naknga beng guk toing ning tutugu waraga' tanga napa' tangkunasi fam titi waraga' ifitangkainga tanga yareging.) ");
INSERT INTO uvh_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","2","O amina ka aming girii Tiofilas na guta' midi kareng umpang ganang i yokamotik. Midi ka ya tim Anutu wari aming indita' napa' girii ka Jisas ning iik ganang tinimgu' wara'ning, ka aming arantagim ka midi kareng wara'ning kane tanga ira napa' u munumung sini' kadofinga anganga ari'ni tubobu bibi' tugu' ganang u dabiksa' kuma' kasasu'neging anasa' ningging wara'ning. Ka aming fam adindu' midi ka u iyok waraga' sura kane girii kuma'sa' tanga yokyangaging. ");
INSERT INTO uvh_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Ka na midi wara'ning ki u nakdidima sini' titi waraga' kane kama paramu' sini' ira tanga ababanga naksasu'na sini' kuma' tanga wa kami nandu' guta' sura umpang ganang i yokamirik yang. ");
INSERT INTO uvh_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Wara' gu midi ka i kanga ning tanga midi ningyara' ka aming fam wari tim kuma' ganinga nakung waraga' sura o midi ka wa beng ba nakuk ning toutang. ");
INSERT INTO uvh_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Ka Herot wari kama tubo Judia tara' wara'ning aming girii king tanga mareiagu' ganang ka aming nua'ni wapni Sekaraia adi siring yak girii ning pris kane tanga itarugu'. Ka aming arantagim ka siring yak girii wara'ning kane tiaging wa arantagim ka Abaisa guk ka Eron guk wara'ning wari tiaging. Ka Sekaraia adi arantagim ka Abaisa wara'ning a tamni Elisabet undu' arantagim ka Eron wara'ning. ");
INSERT INTO uvh_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Ka imaraming adi Anutuning midi naknga ning tanga Anutuning kadapmang yaranga didimeng karengsa' tanga ikiagumu'. ");
INSERT INTO uvh_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Ka adi pingkek ikiagumu' wara' adi kama paramu' saba guk mo' ibenga ira anganga tanganda kuma' tugumu'. ");
INSERT INTO uvh_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","9","Ka aming ka siring yak girii ning kane u tiaging wa fiking ka arantagim nua'ni wari tanga anganga arantagim nua'ni adibu titi ning tiaging wara' kama ka arantagim ka Abaisa wari titining ubu kadofiamgu'. U kanga arantagim ka wari pris anasining kadapmang yaranga Sekaraia u kasiranga toging. Ning tanga Sekaraia adi pris kane tonga siring yak iyung amanga iyung bane kabasi' ka Anutuga' napa' mupmu karesi tanga sangam ning wara'ganang amanga adenga Anutuga' sura napa' mupmu karesi u tanga sangamgu'. ");
INSERT INTO uvh_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Ning tinga ami taming fam adi fugang unggung kapmera ibang kane sa' mera fatiging. ");
INSERT INTO uvh_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Ka Anutuning kunung aming ensel nua'ni wari kadofinga basing alta ka Sekaraia wari Anutuga' napa' mupmu guk kareng tanga fasangamgu' ganang ka kafong kareng tara' u kadofinga adegu'. ");
INSERT INTO uvh_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Ka Sekaraia adi u kanga iguk aranga mutu tugu'. ");
INSERT INTO uvh_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Ka kunung aming ensel wari ning anigu', o Sekaria gu naga abarik yaraga' mutu mo' totang. Fikifiki gu Anutu wari napa' ni tagam ga' sura ibang fatugutang wa Anutu adi kuma'sa' nakamita' wara' adi kami yara'ganang wa sidita' napa' ni u kuma' samonga tara'. Ka wa ning, guning tamga Elisabet adi kaba guk ubu ira ning tanga saba ami ibewa'ga'. Ka saba wari kagadofi tinga wa wapni Jon ning yore'. ");
INSERT INTO uvh_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Ning tanga sidi saba wari kadofo' u kanga kabaksi' karengsa' naknga mesisiringa sa' tidemu'ga'. Ning tinga adi kadofo' wara'ganang wa aming kabi'mo' undu' kabaksi' kareng guk ira mesisiringa tanga ikni'ga'. ");
INSERT INTO uvh_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Ka saba kabasi' wari kadofinga giraga to' ganang wa Anutu wari aming wap guk ning kawa'ga'. Abanga adi ama kagaya wain kabi'guk mo' topno', sigesa' ira awa'. Ka mengni wari iibe munumung tinga wa Anutu wari adining mini unggo u kamingaminga mini unggo ning tang wara'guk ningsa' ira anganga girawa'ga'. ");
INSERT INTO uvh_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Ning tanga giranga ira anganga Juda aming u ininga Juda aming kabi'mo' adi adisining Anutu girii ning midi kareng u naknga kabaksi' faranga abanga Anutuning kapmik ganangsa' ubu ikni'ga'. ");
INSERT INTO uvh_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Adi Anutuning midi togadofi aming ning ira ning tanga kane tangkunang sini' ka tim profet Ilaija wari tanga yagu' ningsa' to'ga'. Ning tanga adi midi ka aming wari kadapmang kareng titi wara'ning u ina yareinga aming adi u naknga kabaksi' faranga aming ka sabase ga' bibi' nakiting adi sabase ga' tubobu naknga kafakafa tiapma ikni'ga'. A aming ka Anutuning midi ninak ga' bibi' naknga Anutuga' manda ukngama ikiting adindu' kabaksi' faranga Anutuning midi ga' ubu nakni'ga'. Ning tanga kadapmang didimeng tanga ira girii wari adisining bining ganang kagadofi waraga'sa' sura ikni' ning anigu'. ");
INSERT INTO uvh_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Ka Sekaraia wari ensel u ning anigu', beng sini' u torang na tanganda kuma' tirik a tamna undu' tangandang. Ka na o beng guk torang ning wa indining tanga toutik ning anigu'. ");
INSERT INTO uvh_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Ka ensel wari ning anigu', na wapna Gebriel, Anutu ganang sini' ira adining kunung aming tanga ikitik wara' Anutu ana nangkareinga abanga adining midi kareng i ganirik. ");
INSERT INTO uvh_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Midi ka naga i ganirik ya beng guk sini'. Inga' kama ka midi i torik yari beng guk kagadofi ning wari kadofo' ganang wa beng guk to'ga'. Ka Sekaraia gu midi i naknga o beng guk ning guk mo' tonga suktangkarang wara' kami gu maga wadigi' isefagabota'. Ning tanga gu midi guk mo' tonga midi map sige ningsa' ira anganga napa' wari beng guk kadofiinga ganangsa' wa maga wari tubobu karendagapma midi toya'ga' ning anigu'. ");
INSERT INTO uvh_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Ka Sekaraia wari iyung bane do kunung aming ensel guk midi ko fatogumu' ka aming fam ka fugang kapmera ibang fatoging wari fafong sini' kapmekgisifa tanga ning toging, ai, Sekaraia ya ko sini' wa nasi' tanga sepma fata' sam. ");
INSERT INTO uvh_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Ka inga' Sekaraia wari fugang afanga aming u midi iyang ga' nafek tanga kafatinting sa' tiamgu' u kanga inga' nakedanga ning toging, o idi iyung bane ganang do Anutuning napa' ni wari unda' kadofingaminga kanga' ning toging. ");
INSERT INTO uvh_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Ka kama ka wa Sekaraia wari siring yak girii ning kane tanga au ko adengamgu' wara' adi tubobu amanga siring yak girii ganang unggung sande fam kane ningsa' tanga anganga adining kama wari bingaminga yoringga' tubobu wa inga' mugogu'. ");
INSERT INTO uvh_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","25","Ning tanga anga yoring ganang do kadofinga tamni guk ira anganga saba kabasi' wari tamni Elisabet ning kaba ganang u kadofigu'. Ka Elisabet wari saba kabasi' wari kaba ganang do kadofigu' u nakedanga ning togu', o beng sini' fikifiki na saba guk mo' ira megang naknga ira abutik. Ka kami yara'ganangsa' Anutu adi nagata' ai' dap kareng ning tanamara' wara' naning megang kuma' bira'. Ning tonga amine ngingeng guk mo' yangara fiabarugu', ananing yoring ganang unggungsa' mera anganga mayap 5 ning ibigu'. ");
INSERT INTO uvh_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Ka Elisabet wari kaba guk ira mayap 6 ning kuma' ibigu' ganang ka Anutu wari adining kunung aming ensel Gabriel u yong kabasi' Nasaret ka kama tubo Galili tara' waraga' anigareinga agu'. ");
INSERT INTO uvh_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Ka yong kabasi' Nasaret wara'ganang wa taming sababa nua'ni unggung itarugu'. Taming wara'ning wapni wa Maria. Ka adi ami nua'ni ka Josep ka girii Devit ning arantagim ganang kadofigu' u sangam ga' kuma' totangkaging. ");
INSERT INTO uvh_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Ka ensel wari Maria ganang kadofinga ning anigu', o taming, girii wari guganang ita'. Adi kafakafa tagapma napa' girii ka taming fam ganang tiam ning guk mokngang u tagamonga tara'. ");
INSERT INTO uvh_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Ka Maria adi midi ka u naknga sasuk mimeng tanga ning suku', o na taming sige ka adi midi ka ning guk wa indining tora'. ");
INSERT INTO uvh_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Ka ensel wari ning anigu', o Maria gu mutu mo' totang, Anutu wari guta' kaba karengsa' nakamara'. ");
INSERT INTO uvh_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Wara' ning ganotik, gu kabaka guk ira saba ami ibenga wapni Jisasa ning yore'. ");
INSERT INTO uvh_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Ka adi inga' giraga tanga wa aming sige mo' iro'. Adi aming girii ira wap guk ikinga aming wari Anutu girii ning mindingni ning anini'ga'. Ning tinga Anutu wari aming girii ka tim papangni Devit kamiinga yaptatoregu' ningsa' kamiinga ");
INSERT INTO uvh_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Jekop ning arantagim girii u adining tangkunangni ka bibi' titining guk mokngang wara'ganang fikifiki ningsa' yaptatoranga ira awa'. ");
INSERT INTO uvh_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Ka Maria wari ensel u ning anigu', ka na ami wa ko mo' sangamarik wa indining tanga napa' ka wari nagaganang urapsa' kadofinamota'. ");
INSERT INTO uvh_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Ka ensel wari ning anigu', udi giri torang de ka wa aming wari mo' tota'. Mokngang wa Anutuning mini ungggo wari gu ganang kadofinga mini unggo ning kigineng girii warisa' mungkupnagapma saba u tipkadofota'. Wara' inga' saba wari kagadofi to' ganang wa aming adi saba kuni' nua'ni naro'sa' iikning ning kanga wap Anutuning mindingni ning anini'ga'. ");
INSERT INTO uvh_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Ka wa gusa' mo'. I nake' guning kuyaga Elisabet ka saba guk mo' ibenga tanganda kuma' tara' ka aming wari pingkek ning aniting adi saba ami nua'ni wari adining kaba ganang kadofigu'. Ka Elisabet adi saba wara'guk ita' wa mayap 6 ning kuma' ibira'. ");
INSERT INTO uvh_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Beng sini' Anutu adi napa' ka ni mo' titining guk mokngang sini' wara' adi kuma'sa' tagamota' ning anigu'. ");
INSERT INTO uvh_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Ning tinga Maria wari aiga tanga ning togu', we' napa' u torang wa nagaganang girisa' kadofinamota'. Na taming Anutuning midi sa' nakngam ning, wara' adi napa' nagaganang tipkadofonga tara' u girisa' tanamota'. Maria wari ning tuguinga kunung aming ensel adi kagabi tanga mugo tugu'. ");
INSERT INTO uvh_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Ning tanga kabi'sini' sa' iya' Maria adi Elisabet ning midi u naknga yoring u urapsa' kabinga marara kuyangni Elisabet u kaunga kama karang ka kama tubo Judia tara' waraga' aregu'. ");
INSERT INTO uvh_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Aranga kadofinga ning tanga Sekaraia imaraming ning yong ganang amanga kuyangni Elisabet u kadofinga kanga kaba kareng ninak ning midi kabi' anigu'. ");
INSERT INTO uvh_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Ka Elisabet wari midi u nakinga saba kabasi' adining kaba ganang undu' iguk aranga tuntumurum girii tugu'. Ning tanga Anutuning mini unggo wari Elisabet ning kabaganang u amatona sini' tinga Elisabet wari kaba kareng siamo' naknga ");
INSERT INTO uvh_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","mesisiringa titining midi ning togu', o Maria gu girii wari kareng tagaminga napa' girii kareng ka wa taming fam ganang mo' kadofiamara' guganangsa' kadofigamara'. Abanga saba kabasi' ka guning kabaka ganang u ita' undu' Anutu wari yotangkangaminga kigineng guk ita'. ");
INSERT INTO uvh_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","O na taming sige ka indining tanga nagata' kafakafa tanama Anutu wari naganing girii ning mengni gu naganing yongganang i gangkareinga abarang. ");
INSERT INTO uvh_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Gu midi abanga nanirang u nakinga saba kabasi' naning kabakna ganang undu' kaba kareng naknga fungsa' marata' wara' na guning ki ka girii ning meng ning u wara'ganang nakedarik. ");
INSERT INTO uvh_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Abanga gu nasi' midi Anutu wari ganggu' wa gu u naknga waraga' bibi' guk mo' nakngamgung, gu aigangam tanga nakngam sa' tugung wa Anutu wari kafakafa sini' tagam waraga' karengsa' tugung ning togu' kuyangni Elisabet wari. ");
INSERT INTO uvh_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Ka Maria adindu' kaba kareng naknga Anutuning wap bema aronga ning togu', na Anutuga' kabakna karengsa' naknga ning torik, Anutu wa girii beng guk sini' ikita'. ");
INSERT INTO uvh_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Na Anutu wari yotangkanaminga gi' ikitik waraga' kabakna karengsa' nakarik. ");
INSERT INTO uvh_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","49","Na taming sige wap guk mokngang adining midi sa' nakngam ning ka adi nagata' ai' dap kareng sini' tanamara'. Inga' aming wari kami yara'ganang Anutu kigineng wari kareng i tanamara' yaraga' sura ning toyanting, o beng guk sini' taming ka wa Anutu wari karengsa' tangamara'. Wara' na waraga' sura adining wap bema aranga ning torik, Anutu wa kareng naro'sa' ikita' beng sini'. ");
INSERT INTO uvh_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Anutu adi aming ka adining midi naknga kapmik ikiting wara'siga' ai' dap beng sini' tiamita'. Ka adisita'sa' mo' tiamita', adi adisining sabase a papase wara'siga' undu' ko tiama auta'. ");
INSERT INTO uvh_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Adi kane kigineng titining tang guk. Ka aming ka anasining fuksi' bema aranga tang guk ning sura napa' ni tonga bak kukiting wa adi didipmi tinga papusana tanga wadigi' biting. ");
INSERT INTO uvh_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Aming girisi king arantagim ka tim iyak ning ikiting wa Anutu adi tipmakuratiap tita'. A aming sige ka wap guk mokngang wa adi yotangkayap tinga wap guk ubu ikiting. ");
INSERT INTO uvh_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Aming ka napa'ga' nafek tanga tatafak ikiting wa Anutu adi yotangkayap tanga fuksi' a urasi' ifitangka waraga' napa' kareng tiamita'. A aming ka kangasi tanga ikiting wa Anutu adi sige yangkagareinga mugoting. ");
INSERT INTO uvh_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Tim Anutu wari indining papani' Ebraham a papane fam adisita' bibiri' naknga kafakafa ningsa' tiapma ira anganga adisining iri undu' ningsa' tiapma ira au ga' kuma' togu' wara' kami Juda aming adining midi ninaksa' titam indita' kafakafa tanimara'. ");
INSERT INTO uvh_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Maria adi midi ka Anutuning wap bema ara ning u tonga anganga biinga kuyangni Elisabet guk unggung mayap famineng ning yagu'. Iya' ning tanga inga' yoringga' tubobu kabinga mugogu'. ");
INSERT INTO uvh_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Ka kama ka Elisabet wari saba kabasi' u iibe ning udi kuma' kadofigu'. Ning tinga Elisabet wari saba ami ibegu'. ");
INSERT INTO uvh_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Ning tanga adining arantagim a amine fam ka yong dabik ikiaging wari u naknga adindu' kabaksi' karengsa' naknga ning toging, o girii wari kafakafa tangama ai' dap kareng tangamara'. ");
INSERT INTO uvh_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Ning tanga iya' kama 8 ning kabinga Juda aming anasining kadapmang yaranga saba kabasi' wara'ning fugu tapni u giknim dopmama wap iyok waraga' amise wari abanga bak tiging. Tanga ning tanga amine fam wari ananing beni ning wap Sekaraia unggung iyok ga' ning tonga tiging. ");
INSERT INTO uvh_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Ka mengni Elisabet wari ning yanggu', mokngang ya wapni wa Jon ning yokantam. ");
INSERT INTO uvh_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ka adibu ning aniging, a guning amige indining ka ni wap ka Jon wara'guk mo' ikita'. Ka wa ka' sigesa' guk wa indining yokantam. ");
INSERT INTO uvh_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Ning tonga beni ubu aniging. Ka Sekaraia adi mini isefinga midi map itarugu' wara' kafasi' wari kafatinting sa' tangamging. ");
INSERT INTO uvh_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Ning tinga Sekaraia wari kudi iyok ning slet u bemam ga' kafatinting tiamgu'. Ning tinga u bemaminga Sekaraia wari saba kabasi' wara'ning wapni u Jon ning yora yamgu'. Ka aming adi imaraming fama' wari wap kubanik waraga'sa' tangkagumu' u yapma sasuk mimeng tiging. ");
INSERT INTO uvh_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Ning tanga didimeng ka wara'ganang kaga'sa' Sekaraia ning mini ka isefi tanga fiderugu' wari karendangam tinga midi tubobu tonga ning tanga kaba karengsa' naknga Anutuga' mesisiringa tangama animamangna tugu'. ");
INSERT INTO uvh_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Ning tinga amise a aming yong dabik ikiaging wari napa' girii ka aming wari titining guk mokngang wari dasi'ganang kadofigu' u kanga mutu tanga tonga yareging. Ning tanga midi ne u bema bema tiangainga aming ka kama tubo Judia karang tara' ira yariaging undu' dabiksa' kuma' naksasu'nanga yareging. ");
INSERT INTO uvh_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Ning tanga aming adi saba kabasi' ka wa Anutuning tangkunang guk iikning u kuma' kigedanga base tanga ning toging, o saba ka wa giraga tanga aming girii unda' iro'ga' ning tonga yareging. ");
INSERT INTO uvh_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Ka Anutuning mini unggo wari beni Sekaraia ning kaba ganang amatoneinga Sekaraia wari Anutuning wap bema aranga midi ka napa' inga' kagadofi ning waraga' ning tokadofigu', ");
INSERT INTO uvh_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","o beng sini' Isrel aming indining Anutu wa girii kareng sini' wara' indi adining wapsa' bema arantam. Adi indi adining arantagim yotangkanipma manggara gi' kuknibinga iik wara'ning tinimonga tara' ");
INSERT INTO uvh_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","wara' adi indi yotangkanip waraga' aming kigineng nua'ni ka Devit adining midi ninaksa' tarugu' wara'ning arantagim ganang sini' u anigaranimara'. ");
INSERT INTO uvh_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Ka u tanimara' wa midi ka timinggi' Anutu ana adining midi togadofi aming profet u ininga wari kuma' togadofiging unggungsa' yaranga tanimara'. ");
INSERT INTO uvh_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Ka Anutu adi aming indi yotangkanibinga aming ka indita' kabaksi' kadagnag sini' naknga bibi' naknima indining digirap ning ikiting wari indifikadaga guk mo' titi waraga' kuma' totangkagu'. ");
INSERT INTO uvh_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Beng sini' tim adi indining papane u kafakafa tiap ga' kuma' totangkagu' wara' adi adining midi totangka waraga' nakube guk mo' tita'. ");
INSERT INTO uvh_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","74","Ka tim Anutu wari indining papani' Ebraham u beng guk sini' urang ganirik ning anitangkanga ning tanga ning anigu', inga' na guning papage arantagim ka adisining digirap wari mamareng girii kabiaminga ira ani' u manggara mamareng u tanga kayoima fabanga gi' kukyabinga ikni'. Ning tinga adi kadapmang ka digirap ga' mutu a kadapmang kadagang u kabisasu'nanga gi' ira naganing kane kareng unggungsa' ubu tanga ira ani'. ");
INSERT INTO uvh_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Ning tanga kadapmang didimeng kareng ka naga tanga ikitik ningsa' tanga ikni' ning anigu'. ");
INSERT INTO uvh_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Ka sabana kabasi' gu inga' giraga tanga Anutu girii ning midi togadofi aming profet ning ira tim anga napa' napa' u ifadidimanga yareinga girii adi mandang wara'ganang inga' giwara awa'. ");
INSERT INTO uvh_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Ning tanga gu ami taming u girii wari kagadofi waraga' yangnatama yareinga aming adi u naknga girii wari kadofinga adisining kadagang u tanga igukyama manggara gi' kukyabinga iik waraga' sura ikni'. ");
INSERT INTO uvh_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Beng sini' Anutu adi ai' dap a kafakafa gi' tinip ga'sa' ninak wara'ning tuang sini' wara' adi indi yotangkanip waraga' sura aming nua'ni anigaranimonga tara'. Ka inga' aming ka wari kagadofi to' ganang wa kadagang wari tanga kama kangkam ganang ningda'ning ikem i wadigi' tipsangandanimo'. ");
INSERT INTO uvh_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Kami yara'ganang wa gaa' kangkam ganang ira aming kungkumosi ningda'ning ikem. Ka kama ka inga' adi u yotangkanibonga tara' wara'ganang wa adining diok sangang ganang ka' ira adining kadapmang didimeng ganang kabakni' kugurang sa' naknga iknam ga' ning togu'. ");
INSERT INTO uvh_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Ning tanga ira anganga inga' saba kabasi' Jon wari giraga tinga adining sasuk kareng undu' kigineng dabiksa' kadofigu'. Ning tanga giranga tangkunang guk ira yong u kabinga anga kama bining sigesa' ka aming uwa kabi'guk mokngang wara'ganang anga ira fentarugu'. Ka inga' Juda aming ga' midi ituaim kane tonga wara'ganangsa' kadofisarendainga kaging. ");
INSERT INTO uvh_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Ka kama ka wara'ganang wa Romni aming girii ka wapni Ogastas wari aming dabiksa' ka kama kama indeng ira yareging adisining wapsi' u manggakyapsasu'na waraga' midi kamigu'. ");
INSERT INTO uvh_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Ka adi kadapmang ka aming wap manggakyap wara'ning wa tim guk mo' tiaging. Mokngang adi kama ka Kwirinias wari kama tubo Siria tara' wara'ning kiap tanga mareiagu' wara'ganangsa' wa wap manggakyap wara'ning kadapmang u munumung sini' kamigu'. ");
INSERT INTO uvh_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Ning tinga aming ka tim yaksing ki u ibinga anga kama yong nua'ni ganang ikiaging adi midi ka u naknga wap manggakyap waraga' sura marara yong u ibinga anasaning yaksing ki ganangga' tubobu abiging. ");
INSERT INTO uvh_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","5","Ka Josep adi Maria u sangam ga' kuma' totangkaging. Ka adi girii Devit ning arantagim wara'ning iri wara' adindu' midi ka aming girii Ogastas wari aming wap manggakyap ga' togu' u naknga yong kabasi' Nasaret ka kama tubo Galili tara' u itarugu' u kabinga marara ananing yong ki ka tim papangni Devit wari timinggi' itarugu' ka Betlehem kama tubo Judia tara' waraga' abugu'. Ka tamni Maria undu' wap manggakyap waraga' kubap dabik abugumu'. Ka tamni udi kaba guk. ");
INSERT INTO uvh_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","7","Ning tanga ababanga Betlehem yong u kadofiging. Ka imaraming adi nurum yak ganang dek ga' ning tonga sura abugumu'. Ka mokngang nurum yak udi aming kabi'mo' wari kuma' kadofinga tiptonanga dera yareging waraga' tanga maga yak ganang anga dekumu'. Ka Maria wari saba iibe ning kama wari kadofiinga kainga kagaya naku'. Ning tanga Maria wari saba ami mamaram ibegu'. Ibenga bema ning tanga kwi' wari tumura maga dang ning gafa ganang kufainga defagu'. ");
INSERT INTO uvh_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Ka tiim ka wara'ganang ka yong wara'ning du' ganang wa aming fam ka magasi' sipsip u yaptatoranga ikiaging. ");
INSERT INTO uvh_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Ka Maria wari saba ibegu' wara'ganang didimeng ka Anutuning kunung aming ensel nua'ni wari maga yaptatora aming wara'ganang girii ning diok kigineng guk kadofinga adegu'. Ka adi u kanga paparap senga mutu girii tiging. ");
INSERT INTO uvh_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Ka ensel wari ning yanggu', o sidi mutu mo' tinting. Na sidita' midi kareng bemsama abarik u sanotik i nakni'. Midi kareng ka ya sidi a aming kamaganangni dabiksa' sidi naknga kabaksi' karengsa' naknga iik wara'ning. ");
INSERT INTO uvh_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Ka midi kareng ka wa ning, kami tiim yara'ganangsa' wa yong ka Devit wari itarugu' ganang dota' taming nua'ni wari saba ami kuma' ibera'. Aming ka wa sidi tubobu manggara gi' kuksabinga iik wara'ning ka Anutu wari sidi yotangkasap waraga' kasiregu' wari kadofira'. Adi girii tim iyak a Kasira Aming beng sini'. ");
INSERT INTO uvh_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ka sidi mamarak tanga yongganang do anga saba kabasi' u kwi' wari tumura maga ning gafa ganang kufainga defata' u kanga o beng sini' ba ninara' ning tonting ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Ning tinga Anutuning kunung aming arantagim girii wari ubu kadofinga adigok dabik adenga Anutuning wap bema aranga mesisiringa tangama ning toging, ");
INSERT INTO uvh_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","o aming kunim furo'ningni indi Anutuning kigineng girii waraga' mesisiringa tantam. A aming kamaganangni ka Anutuning kapmik ganang ikinga ai' dap tiamita' wa kabaksi' kugurang guk gi' ikanting ning toging. ");
INSERT INTO uvh_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Ka Anutuning kunung aming ensel arantagim wari midi u ina ning tanga tubobu kuma' ibinga mugoinga maga yaptatora ning aming wari ning toging, ai indi napa' ka girii wari Betlehem yongganang kadofira' u ningtintingnara' wa sa'anga kanam, uri ma mayam. ");
INSERT INTO uvh_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Ning tonga urapsa' marara anga Betlehem yong u kadofinga yapking ka Josep imaraming Maria ya udi maga yak ganang unggung mareiagumu' a saba gingiming kabasi' Jisas undu' kwi' wari tumura maga ning gafa ganang kufaging udi unggung ningsa' ko deiagu' u anga kaging. ");
INSERT INTO uvh_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Ning tanga nasi' midi kareng ka Anutuning kunung aming wari saba kabasi' wari kadofigu' wara'ning u anga ininga naking waraga' Josep imaraming u ina yareging. ");
INSERT INTO uvh_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Ning tinga aming fam ka Josep imaraming guk unggung kubap mareiaging wari midi ka u naknga sasuk mimeng tiging. ");
INSERT INTO uvh_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","A Maria adi midi u naknga kaba ganang kaminga suktangka tanga ira agu'. ");
INSERT INTO uvh_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Ning tanga maga yaptatora ning aming adi Josep imaraming u ibinga bingkingsi' ganangga' tubobu anga napa' didimengsa' ka ensel wari ininga naking ningsa' kadofigu' u kaging waraga' sura Anutuga' kabaksi' karengsa' naknga mesisiringasa' tanga tanga mugoging. ");
INSERT INTO uvh_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Ning tanga iya' kama 8 ning kabinga Juda aming anasining kadapmang yaranga saba ginggiming kabasi' wara'ning fugu tapni giknim u dopmama ning tanga wapni Jisas ning yoking. Ka wap ka Jisas wa saba u mengni ning kaba ganang do ko mo' kadofigu' ganang ka ensel wari Maria u wap ka u iyok waraga' timinggi' kuma' anigu' wara'ganang didimengsa' yoking. ");
INSERT INTO uvh_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Ning tanga iya' kane ka Moses ning kadapmang tang yaranga saba kabasi' guk ka mengni guk dabik u ifagidiba wara'ning tiaging udi kuma' duduregu' u kanga Josep imaraming wari saba kabasi' Jisas u Anutuga' kasiringam waraga' Jerusalem yongga' nagira aregumu'. ");
INSERT INTO uvh_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Ka midi tang ka Moses wari yoku' u yaranga tiaging wa ning yokinga fidegu', saba ami mamaram ibenga wa girii ga' tipkasiringamotang. U titi waraga' aregumu'. ");
INSERT INTO uvh_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Abanga kane nua'ni ka saba kabasi' guk ka mengni guk dabik u ifigidiba wara'ning u tiaging waraga' wa girii ning midi tangkunang ka ning yoking, Anutuga' amonga wa mimbep girisi fama' wa ma mimbep giming uyamang fama' u dipminga tangamotang ning yoking. Wara' adi kane fama' ka u titi waraga' saba kabasi' u nagira aregumu'. ");
INSERT INTO uvh_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Ka aming tangandang nua'ni undu' Jerusalem yongganang unggung itarugu' wapni Simion. Adi aming didimeng kareng Anutuning midi sa' naknga ning tanga kama ka Anutu wari Isrel aming yotangkayap wara'ning u kapmefatarugu'. Ka adi Anutuning mini unggo ning tang guk itarugu'. ");
INSERT INTO uvh_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Ka adi Anutuning mini unggo wari timinggi' sireng ning kuma' aniinga naknga itarugu', gu ko mo' kumare' ganang girii ning Kasira Aming wari kadofo' wa kuma' kaya'ga'. ");
INSERT INTO uvh_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Ka Josep imaraming Maria ya wari saba ginggiming kabasi' Jisas u bema siring yak iyung bane ganang amanga kane ka Moses ning kadapmang tang ganang yaranga tiaging u tangamonga aratugumu' wara'ganang didimeng ka Anutuning mini unggo wari Simion tangandang wara'ning kaba ganang amanga tipmarakinga adindu' siring yak iyung bane ganang amanga Josep ya u yaptuagu'. ");
INSERT INTO uvh_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Ning tanga Simion wari saba ginggiming kabasi' Jisas u kigedanga bimbem tugu'. Bema adenga Anutu u ning animamangnegu', ");
INSERT INTO uvh_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","31","o girii guning napa' kareng girii ka tim gu naga kaga ga' nanggung wa kuma' kadofiinga kami naganing dana wari kuma' karik yang. Wara' na kabakna kareng guk mareia' kungkumak tonga wa girisa' kumarotik. Aming ka gu aming kabi'mo' dabiksa' indi yotangkanipma manggara kuknibinga kareng gi' giri iik waraga' sura anigaregung wa kuma' karik yang. ");
INSERT INTO uvh_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Adi aming arantagim nua'ni ka Juda mo' wara'siga' guning kadapmang kareng ka diok sangang da'ning u tipkadofiamo'. Ning tinga adindu' u kanga ning toni', o beng sini' adi Anutuning arantagim ka Isrel wara'sining bining ganang kadofigu'. Ning tonga Isrel arantagim ning wap u tipgirani' Simion wari ning togu'. ");
INSERT INTO uvh_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Ka Jisas ning mengbe adi midi ka Simion wari u togu' u naknga base tanga sasuk mimeng tugumu'. ");
INSERT INTO uvh_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Ning tanga Simion wari Anutu wari imaraming u yotangkayap waraga' ibang toyamgu'. Ibang u tonga biinga ning tanga Maria u ning anigu', i nake' saba kabasi' ka ya inga' adi giraga tanga kane ka Anutu wari titiga' tipkasiregu' u to' ganang wa Juda aming wari ning tini', aming ka adining kane u kanga adita' bibi' nakngamni' wa kadaga tini'ga' a aming ka adita' nakni' adi kareng gi' giri ikni'ga'. Aming ka wara'ning iikni wa Anutu ananing kadapmang didimeng wara'ning kamaga da'ning ikinga aming kabi'mo' adita' bibi' naknga anikadaga tini'. ");
INSERT INTO uvh_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Ka inga' adisining sasuk kadagang wa sireng ubu kadofasirendo'. Ning tinga kadagang wara'ning mamareng girii wari mengni guning kabaka wa suguk fasi' ningda'ning goro'ga' ning togu' Simion wari. ");
INSERT INTO uvh_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Ka taming tangandang nua'ni undu' Jerusalem yongganang unggung itarugu' wapni Ana. Ka adi profet midi tokadofi taming adining beni wa Fanuel ka adi arantagim ka Asa ning toyaging wara'ni. Tim adi ami kuma' sangamgu' ka gurak seven ningsa' iya' ");
INSERT INTO uvh_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","ufini wari kabinga kumak tinga anapmo' tamkasa' kama paramu' ira agu'. Ka adi tanganda sini' kuma' tugu' gurakni 84 ning, ka adi kane nua'ni guk mo' tarugu'. Adi Anutuga' sura siring yak ganang u amanga nana tapni tanga tiim sidii ibang kanesa' tanga irarugu'. ");
INSERT INTO uvh_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Ka wara'ganang didimeng adindu' Josep imaraming u yapma abanga saba kabasi' u kigedanga Anutuga' mesisiringa tangamgu'. Ning tanga Jerusalem aming wari kadapmang ka Anutu wari yotangkayap titining waraga' sura ikiaging wara'siga' saba kabasi' wara'ning u tokadofiama yaregu'. ");
INSERT INTO uvh_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Ka Josep imaraming adi saba kabasi' Jisas wara'ning kane ka girii ning midi tang ka Moses wari yoku' u yaranga tiaging wara'ning u kuma' tasasu'nanga ning tanga yaksing Nasaret ka kama tubo Galili tara' waraga' tubobu mafugumu'. ");
INSERT INTO uvh_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Afanga kadofinga yaksing ganang unggung ikinga saba kabasi' Jisas undu' girangtangka tanga sasuk kareng a Anutuning tangkunang wara'guk yagu'. ");
INSERT INTO uvh_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Ka Juda aming adi gurak kubanik kubanik fikifiki wa sande girii Pasova u kaunga Jerusalem yong girii ga' ariaging wara' Jisas ning mengbe adindu' ningsa' tiagumu'. ");
INSERT INTO uvh_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Ka Jisas wari giranga gurakni 12 ning kuma' yagu' ganang ka Jisas ning mengbe wari sande Pasova u aranga kaga waraga' sura Jisas u Jerusalem yongga' nua'bu nagira areging. ");
INSERT INTO uvh_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Aranga Jerusalem yong do kadofinga deia' marara sande u kanga afanga ning tanga yaksing Nasaret ga' tubobu mafiging. Ka Jisas adi mengbe u iyang guk mo' tanga Jerusalem yongganang kuta unggung defagu' ");
INSERT INTO uvh_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","wara' imaraming adindu' kubap dabik kuma' ba mayam ning tonga mafu sa' tugumu'. Ning tanga afafanga kama gareinga kadak deking. Ka kama gareinga irosi tanga amiine a arantagimni fam u ina yaregumu'. ");
INSERT INTO uvh_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Ka mokngang katua guk mo' tugumu'. Ning tanga Jerusalem yongga' tubobu wenanga aregumu'. ");
INSERT INTO uvh_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Aranga kadofinga wenagisifa sa' tanga anganga kama famineng ganang wa siring yak girii ning iyung bane ganang u amanga katua tugumu'. Ka Jisas adi Juda ning yanggek aming girisi wari bak kura midi fatoging wara'sining bining amanga mera adisining midi u nakyama ning tanga adibu undu' Anutuning midi fam mera fainggeku' u amanga katuagumu'. ");
INSERT INTO uvh_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Ka aming girisi wari adining midi karengsa' yanggu' a sasukni girii u kanga base tiging. ");
INSERT INTO uvh_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Ka mengbe wari aming girisi guk marafaging u amanga kataunga ai, saba ka ya ning guk wa indining tara' ning togumu'. Ning tanga mengni Maria wari ning anigu', ai Jisas nasi'ga' tanga ning guk indaramatang. Babangga guk indi guta' tanga sura kabakni' mamareng naknga kane girii tanga wenanga abiamuk. ");
INSERT INTO uvh_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Ka Jisas adibu ning yanggu', wena guk wa nasi'ga' tanga fayariamu', Na naning sibeng ning yak yara'ganang kane guk ka sidi wara'guk mo' u nakedanga wenanga abanga naniamu'. ");
INSERT INTO uvh_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Ka imaraming adi midi wara'ning ki u nakeda guk mo' tugumu'. ");
INSERT INTO uvh_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Ning tanga mengbe ning midi u nakyam sa' tanga marara mengne bene u iwara yaksing Nasaret ga' kubap tubobu mugoging. Anga kadofinga ira mengne bene ning midi u ninak sa' tanga kadapmang kareng yaranga kafakafa sa' tanga ira agu'. Ka mengni Maria adi Jisas wari kadapmang karengsa' fatarugu' u kanga suktangka sa' tanga yagu'. ");
INSERT INTO uvh_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Ning tanga ira anganga Jisas wari giraga tanga aming sini' ikinga adining sasukni kareng undu' girii giranga kigineng guk kadofigu'. Ning tinga Anutu wari karengsa' kagu'. Ka aming adindu' Jisas ning kadapmang kareng u kanga adita'sa' nakiaging. ");
INSERT INTO uvh_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Ka Romni aming girii nua'ni Sisa Taibirias wari Rom a kama kama dabiksa' ka adi bemgu' u katatoranga mera anganga gurak 15 ning kuma' kabigu' ganang ka aming girisi fam ka kama wara'ning fam ganang tanga ira yaptatoreging wara'sining wapsi' wa ning, Romni kiap girii ka Pontias Pailat adi kama tubo Judia tara' u katatoregu' a king Herot adi kama tubo Galili u katatoregu' a Herot ning kuyang kabasi' Filip undu' girii king tanga kama tubo Ituria guk ka Trekonaitis guk u yaptatoregu' a king Laisenias adi kama tubo Abilini u katatoregu'. ");
INSERT INTO uvh_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","A Anas ya Kaiafas ya adi Juda ning pris girisi ning tim iyak tanga yagumu'. Ka aming girisi ka wari ning u tanga mera yareging ganang ka Sekaraia ning mindingni Jon Baptis adi yong u kuma' kabinga anga kama bining sigesa' ka aming uwa ni guk mokngang wara'ganang anapmo'sa' ikinga Anutu wari midi anigu'. ");
INSERT INTO uvh_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Ning tinga Jon adi kama bining sige u kabinga anga Jodan ama ganang tara' u yangara ami taming ga' midi tokadofiama yaregu'. Ning yanggu', o aming sidi kadapmang kadagang tanga iking u kabinga kabaksi' faranga abuinga Anutu wari sidining kadagang u suknakubesam tinga ama isamotik. ");
INSERT INTO uvh_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Ka inga' Jon Baptis wari kane ka aming u ininga iiksi' tipdidima wara'ning u tugu' waraga' wa timinggi' profet Aisaia wari midi ning kuma' tuguinga yoking, “aming nua'ni wari kama bining sigesa' ganang ira midi ning katira', ai aming sidi girii wari abubu waraga' kadapmang u kafakafa tipdidimangama yarani'. ");
INSERT INTO uvh_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Kadapmang ka kubak kungkong guk wa kama gira kuserik kafakafa tini'. A kadapmang ka kama bubo guk wa dinikubira tanga tiptatare kafakafa tini'. A kadapmang tingna undu' dinitatare kafakafa tanga yarani'. A kadapmang ka uningkim kuguru' guk wa kadara iguksasu'na tini'. ");
INSERT INTO uvh_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Ning tinga aming kabi'mo' adi Anutu wari yotangkayap wara'ning napa' beng guk wa wara'ganang kadofiinga kanting, ning togu' Aisaia wari.” ");
INSERT INTO uvh_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Ka Jon wari kane ka ama iyam ning u tanga ikinga aming kabi'mo' wari midi ka u naknga ama iyam ga' abuinga Jon wari ning ifang fainarugu', ka sidi kabaksi' sini' mo' faranga abing. Abanga ning sabarik ka sidi gimik kadagang ning mindine midi mandaga' tutugusi, sidi sasuk ka Anutu wari sidining kadagang waraga' kaba kagaya naknga sidifi titiga' sukita' u tipkura waraga'sa' tanga abing sabarik. ");
INSERT INTO uvh_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Ka sidi kabaksi sini' faranga wa kadapmang kareng sini' sa' tinga aming wari u kanga o adi kabaksi' beng sini' faranga ting, ning tonting. Ka sidi ning futuguting, a indi Ebraham ning arantagim wara' indi aming karesi. Ka sidi wap ka Ebraham ning arantagim wara'guk iik wa napa' girii ning mo' sukanting. Mokngang wa napa' girii mo'. Beng sini' Anutu adi kadagang ga' bibi' nakita' wara' adi sidining kadagang u kanga sidita' bibi' naksama aming karesi arantagim inga'ni ka wap Ebraham ning arantagim wara'guk iikga' sura uningkim ka i yabing i ininga girisa' marara iikning. Wara' sidi napa' usingsa' ka Ebraham ning arantagim ganang iking waraga' sasuk mimeng sini' mo' tinting. ");
INSERT INTO uvh_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","I nakni', aming ka firi kadagasi dininga igukning kabi'sini' abota'. Adi abanga firi ka mindip guk mo' mindinga fisa' sige marafaking wa dindini tanga kudip ganang kura siabo'ga' ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Ka aming wari Jon ning midi u naknga kabaksi' mamareng ubu naknga ning faniaging, ka indi nasi' kadapmang kareng sini' tanga kareng gi' ubu ikantam. ");
INSERT INTO uvh_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Ka Jon wari ning fainarugu', wa ning, aming ka fugu tasase ning kwi' fama' guk wa aming ka nafek tara' waraga' ni amota'. A aming ka nana guk adindu' aming ka nana ga' nafek guk titing waraga' fam sabaraimota' ningsa' tanga yaranting ning fainarugu'. ");
INSERT INTO uvh_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Ka aming takis mamanggesi fam undu' Jon wari ama iyam ga' unggung abiging. Adindu' Jon wari midi ka aming wari iiksi' tipdidima waraga' yangggu' u naknga Jon u ning anikaging, a yanggek aming, indi ya indining tantam. ");
INSERT INTO uvh_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ka Jon wari ning yanggu', sidindu' ningsa', kubu tonga sidaning sasuk ganang sige nua'bu guk mo' yorafanga manggakanting. Mokngang sidi uningkim mambong takis mamanggak ning bagi ka gavman wari kuma' saninga manggakiting wara'ganang didimengsa' manggakanting. ");
INSERT INTO uvh_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Ka ami'ning aming soldia fam undu' ama iyam ga' unggung abiging wari Jon u ning anigaging, a indi ya indining da' tantam. Ka Jon wari yanggu', sidi aming fam mandaga' iramira sidi kubu titiga' sura a sidi kadagang indiramaking wara' uningkim mambong tonipni' ning iramira mambongsi' kubu sige titining guk mo' tinting. Mokngang sidi mambongsi' didimeng ka girisi' wari samara' unggungsa' manggaknanga ning tanga kane didimengsa' tinting ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Ka aming kabi'mo' adi Jon Baptis wari kane kigineng sini' tugu' u kanga kabaksi' marara ning tonga yareging, ai, Kasira Aming ka yotangkanip titining urang udi kuma' abugu' ibanda'. ");
INSERT INTO uvh_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Ka Jon adi kuma' yapkedanga ning yanggu', a na aming sige ka naning kane wa ama isam ning wara' na ama sini' warisa' isamirik. A aming nua'ni ka naganing mandang abota' adi aming girii kigineng guk. Adining tangkunang wari naganing tang i tarafiro'ga'. Na ningyara' wari adining du'ganang iikning guk mokngang sini'. Aming ka wari abanga mini unggo sini' saminga mini ungggo ning tang wari kadagang ka sidining kabaksi' ganang ita' u kudip da'ning wadigi' danga tipsangando'ga'. ");
INSERT INTO uvh_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ka aming ka wa kane ka aming yapkedanga tagagareyap wara'ning kigineng guk wa kabi'sini' abota'. Adi abanga kadapmang ka aming wari wit mindip kuru' sa' urang dopma manggeting ningda'ning tanga beng karesi unggungsa' dopma manggara ning tanga giwang a tutufuru wa manggara fonga bak kura kudip girii ka fikifiki ningsa' fadata' wara'ganang siabo'ga'. ");
INSERT INTO uvh_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Ka Jon adi Anutuning midi kareng u ituaima ning tanga midi karesi fam ka aming ning kabaksi' ifimarakinga aming wari u naknga nakeda tanga adisining kadagang u kabinga midi kareng ga'sa' ninak waraga' undu' kabi'mo' kuma' ina yaregu'. ");
INSERT INTO uvh_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Ka kama tubo wara'ning king Herot wari kadagang tanga kuyang kabasi' Filip ning tamni Herodias u iromkadara sanagu'. Waraga' tanga Jon wari kadagang ka wara'guk ka kadagang fam tanga irarugu' waraga' Herot u anga fanirugu'. ");
INSERT INTO uvh_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Wara' Herot wari kaba kadagang naknga ning tanga Jon u bema kalabus iyung dasigu'. Ning tinga Herot ning kadagang ka Jon bema dasigu' wari adining kadagang timini wara'guk yorafinga girii giragagu'. ");
INSERT INTO uvh_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Ka Herot wari Jon u kalabus iyung ko mo' bema dasigu' ganang ka Jon wari ami taming fam u iyama anganga Jisas ubu ingamgu'. Ning tanga Jisas wari Anutuga' ibang aratuguinga kunim wari tubo kidagang tinga ");
INSERT INTO uvh_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Anutuning mini unggo wari yang mimbep da'ning igira didimeng ka Jisas wari adegu' ganang u arafugu'. U kanga ning tanga naking wa midi nua'ni wari kunim ganang kuta ning togu', gu naganing sabana kareng na guning kadapmang u karengsa' kanga guta' siamo' nakitik ning togu'. ");
INSERT INTO uvh_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Ka Jisas wari gurakni 30 ning kuma' ira ning tanga kaneni munumung sini' tipmarara tugu'. Ka aming wari Josep ananing mindingni sini' ba ning tonga suking. Ka Josep ning bene papane arantagim wa ning, Josep ning beni wa Hilai. ");
INSERT INTO uvh_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","A Hilai ning beni wa Matat. Matat ning beni wa Livai. Livai ning beni wa Melkai. Melkai ning beni wa Janai. Janai ning beni wa Josep. ");
INSERT INTO uvh_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Josep ning beni wa Matatias. Matatias ning beni wa Emos. Emos ning beni wa Neam. Neam ning beni wa Eslai. Eslai ning beni wa Nagai. ");
INSERT INTO uvh_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai ning beni wa Meat. Meat ning beni wa Matataias. Matataias ning beni wa Semen. Semen ning beni wa Josek. Josek ning beni wa Joda. ");
INSERT INTO uvh_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Joda ning beni wa Joanan. Joanan ning beni wa Resa. Resa ning beni wa Serababel. Serababel ning beni wa Sialtiel. Sialtiel ning beni wa Nerai. ");
INSERT INTO uvh_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Nerai ning beni wa Melkai. Melkai ning beni wa Edai. Edai ning beni wa Kosam. Kosam ning beni wa Elmedan. Elmedan ning beni wa Ea. ");
INSERT INTO uvh_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Ea ning beni wa Josua. Josua ning beni wa Eliesa. Eliesa ning beni wa Jorim. Jorim ning beni wa Matat. Matat ning beni wa Livai. ");
INSERT INTO uvh_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Livai ning beni wa Simion. Simion ning beni wa Juda. Juda ning beni wa Josep. Josep ning beni wa Jonam. Jonam ning beni wa Elaiakim. ");
INSERT INTO uvh_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Elaiakim ning beni wa Melia. Melia ning beni wa Mena. Mena ning beni wa Matata. Matata ning beni wa Natan. Natan ning beni wa Devit. ");
INSERT INTO uvh_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Devit ning beni wa Jesi. Jesi ning beni wa Obet. Obet ning beni wa Boas. Boas ning beni wa Salmon. Salmon ning beni wa Nason. ");
INSERT INTO uvh_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nason ning beni wa Aminadap. Aminadap ning beni wa Admin. Admin ning beni wa Anai. Anai ning beni wa Hesron. Hesron ning beni wa Peres. Peres ning beni wa Juda. ");
INSERT INTO uvh_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Juda ning beni wa Jekop. Jekop ning beni wa Aisak. Aisak ning beni wa Ebraham. Ebraham ning beni wa Tera. Tera ning beni wa Naho. ");
INSERT INTO uvh_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Naho ning beni wa Serak. Serak ning beni wa Riyu. Riyu ning beni wa Pelek. Pelek ning beni wa Iba. Iba ning beni wa Sila. ");
INSERT INTO uvh_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sila ning beni wa Kenan. Kenan ning beni wa Afaksat. Afaksat ning beni wa Sem. Sem ning beni wa Noa. Noa ning beni wa Lemek. ");
INSERT INTO uvh_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lemek ning beni wa Metusala. Metusala ning beni wa Inok. Inok ning beni wa Jeret. Jeret ning beni wa Mahalalil. Mahalalil ning beni wa Kenan. ");
INSERT INTO uvh_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kenan ning beni wa Inos. Inos ning beni wa Set. Set ning beni wa Adam. A Adam wa Anutu ana tugu' wara' adi Anutuning mindingni. ");
INSERT INTO uvh_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Ka Anutuning mini unggo wari Jisas ganang amatonanga tangkunang amiinga Jisas adi Jodan ama u kabinga mugo tugu'. Ning tanga Anutuning mini unggo wari kama bining sigesa' waraga' nagira agu'. ");
INSERT INTO uvh_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Anga kadofinga kama bining sige wara'ganang kama paramu' sini' ka tiim sidii 40 ning ira agu'. Ka wara'ganang wa aming kadagang Setan wari Jisas u kadagang titiga' anigagareunga Jisas ganang kadofingamgu'. Ka Jisas adi kama paramu' u yagu' wa nana kabi'guk mo' nanga sigesa' ira segi kagaya sini' naknga yagu'. ");
INSERT INTO uvh_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Ka Setan wari Jisas u ning anigagaregu', ai gu Anutuning mindingni tangkunang guk. Ka gu seka nakarang wa gu midisa' tuguinga uningkim yari nana igikaminga naya'. ");
INSERT INTO uvh_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Ka Jisas wari ning anigu', mokngang na ning guk mo' totik. Anutuning midi ka umpang ganang yoking wa ning, nana warisa' aming wari ka' iyak titining guk mokngang. ");
INSERT INTO uvh_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","6","Ning tanga Setan wari Jisas u nagira kama bubo nua'ni ka furo'ning sini' ganang ubu aranga adenga aming girisi ning tangkunang ka aming arantagim girisi yaptatora ning a adisining mambongsi' tangkunasi u urapsa' anatintingnanga yaranga ning anigu', nasi' nasi' tangkunasi u defata' yabarang wa nagata'sa' kuma' ibinamsasu'neging. Wara' naga aming ka ni ga' amonga wa naganing sasuk ganangsa' amimi sa' totik. ");
INSERT INTO uvh_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Ka gu mandaka upma mera o gu naganing girina ning nangmamangnotang wa na napa'napa' u yabarang u guta'sa' ibigaminga gusa' ubu yaptatorasasu'notang. ");
INSERT INTO uvh_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Ka Jisas wari ning anigu', mokngang Anutuning midi wa ning yoking, gu mandaka upma mesisiringa wa aming nua'niga' guk mo' tangamotang. Mokngang gu giriga Anutu kubaniksa' waraga'sa' tangama adining kapmik ganangsa' irotang ning anigu'. ");
INSERT INTO uvh_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","11","Ning tanga Setan wari Jisas u nagira Jerusalem yongga' ubu aregumu'. Aranga kadofinga siring yak girii ning fugu furo'ning sini' ganang kuta aranga adenga Setan wari Jisas u ning anigu', gu Anutuning midi ka ning yoking waraga' sure', adi ananing kunung aming ensel u ininga wari kafakafa kuma' gaptatoranting. Abanga nua'ni ka ning yoking, kunung aming ensel wari kuma' surogapmanting wara' gu uningkim fasi' ganang furo'ning mangfotang wa gu fuka kabi'sini' guk mo' tipkadautang ning yoking. Ka gu Anutuning mindingni urang wang sa' kuragamagaya', Anutuning kunung aming wari kuma' surogapmanting. ");
INSERT INTO uvh_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Ka Jisas wari ning anigu', mokngang sini'. Ning ganotik, Anutuning midi ka tangkunang sini' wa ning yoking, gu guning Anutu girii wa girisa' u tota' ma mokngang wa, ning sura sige mo' taramira anidideutang ning anigu'. ");
INSERT INTO uvh_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Ning tinga Setan adi Jisas wari tarafiku' u kanga ning suku', a fiking nua'ni ganang ubu kuma' taramikawak. Ning tonga Jisas taramira yaregu' u kabinga ning tanga kagabi tanga mugo tugu'. ");
INSERT INTO uvh_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","15","Ning tanga iya' Anutuning mini unggo wari Jisas ganang ira tangkunang amiinga Jisas wari tangkunang guk ira kama tubo Galili provins ga' tubobu mugogu'. Anga ira ning tanga Juda aming ning siring yak ganang amanga Anutuning midi kareng u yanggera yaregu'. Ning tinga aming wari adining kane kareng u kanga adining wap bema aranga midi siamo' tonga yareinga Jisas ning kane wara'ning midi ne wari kama tubo wara'ning yong yong u dabiksa' mugoinga naksasu'nanga yareging. ");
INSERT INTO uvh_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Ka Jisas adi ananing yong ki Nasaret ka tim ana ira giraga tugu' wara'ganang tubobu anga kadofigu'. Anga kadofinga iya' mengkura ning kama sabat wari kadofigu'. Ka fikifiki Jisas adi ning turugu' wara' adi aming ka siring yak ganangga' mugoging wara'siguk kubap mugoging. Anga siring yak ganang amanga ning tanga Jisas wari Anutuning midi umpang u indangik ga' tuguinga ");
INSERT INTO uvh_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","aming wari Anutuning midi umpang ka tim profet Aisaia wari yoku' u bema tabanga amiging. Amiinga adenga Jisas wari umpang u tananga midi nua'ni ka ning yoking u kanga indangikyamgu', ");
INSERT INTO uvh_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“ka Anutuning mini unggo wari nagaganang ira nangkareinga anga aming ka nafek tanga iking wara'siga' Anutuning midi kareng ituaimarik. Ning tanga aming ka kalabus kadagang ning kane kagaya ganang iking u udanga manggara kukyabinga kugurang gi' ubu ikanting. A aming ka degara guk mo' tanga iking wa degara ubu tinting. A aming ka mamareng girii guk ira kadaga sini' tanga iking wa na mamareng u tanga kayoima iik kugurang kareng kabiaminga sibim gi' ubu ikanting. ");
INSERT INTO uvh_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Ning tanga Anutuning mini unggo wari midi kareng ka Anutu wari aming tubobu manggakyabonga tara' wara'ning u yangtuang yara waraga' abarik ning yoking u indangikyamgu'.” ");
INSERT INTO uvh_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Ning tanga biinga Jisas wari midi umpang u kayopma kayopma bema umpang u katatora wara'ning tuang waraga' tubobu ima kwang meku'. Ning tinga ami taming kabi'mo' ka siring yak iyung bane u amanga mera yareging wari adining midi u naknga Jisas unggungsa' kafasaroging. ");
INSERT INTO uvh_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Ning tanga Jisas wari nua'bu marara midi ning togu', midi ka u indangikinga naking wa profet Aisaia wari timinggi' sini' yoku'. Ka kami yara'ganang wa midi ka wari beng guk kuma' kadofira'. ");
INSERT INTO uvh_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Ka aming wari adining midi kareng u naknga ning toging, ai midi karengsa' tora' nakem. Ka adi sasuk kareng ka ning wa indeng bemgu', ya Josep ning mindingni urang udi ning toging. ");
INSERT INTO uvh_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Ka Jisas wari ning yanggu', beng sini' na kuma' sabarik sidi naganing yong ki ning tonga midi nua'ni ka a dokta adi ananing fugu undu' girisa' tipkarendota' ning tuguting waraga' sura ning sura nafing, a adi kane tangkunang ka tim Kapaneam yongganang do tinga nakum ning wa ananing yong ki ganang ibu undu' girisa' tinga kantam ning suknaming. ");
INSERT INTO uvh_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Ka ning sanotik, aming kamaganangni adi kadapmang ka ni ka ning titing, midi tokadofi aming profet ning midi wa aming ka ananing yong ki sini' adi bibi' naknga nakyam guk mo' titing a aming yong fam adi giri nakyamiting. ");
INSERT INTO uvh_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Ka kadapmang ka profet ananing yong ki aming wari bibi' nakngam ning wa kami yara'ganang sidisa' mo' ting, mokngang wa timinggi' profet Ilaija wari yagu' ganang u tanga undu' ningsa' tanga ira abiging. Ka adi kadapmang ka ning u tanga yaging waraga' tanga kama ka Isrel aming indining kamaganang i gimak guk mo' tanga tugumung girii wari gurak famineng sini' tanga mayap 6 ning kadofiaminga yaging ganang ");
INSERT INTO uvh_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","wa Anutu adi Ilaija wa tamkasa' siamo' ka Isrel ingging yaging u yotangkayap ga' mo' anigaregu'. Mokngang adi tamkasa' kubaniksa' ka Isrelni mo' arantagim nua'nining ka Sarafet yong kama tubo Saidon tara' do itarugu' u anga yotangkangam waraga'sa' anikareinga agu'. ");
INSERT INTO uvh_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Ka profet nua'ni Ilaisa wari yagu' wara'ganang undu' ningsa' Isrel aming kabi'mo' adi bagana kadagang ka kasi' kafasi' natugupmura lepa u tanga ikiaging wa Anutu adi adisining nua'ni guk mo' tipkarendagu'. Mokngang sini' adi aming ka Isrel mo' arantagim nua'nini wapni Neman kubaniksa' unggungsa' tipkarendagu'. Ka kami yara'ganang wa naganing yong ki sidi nagata' undu' ningsa' naknaming, Jisas wari ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Ka aming ka siring yak iyung bane mera yareging wari midi ka Jisas wari anasining kadapmang waraga' unggung sura togu' u naknga kabaksi' kadagang sini' ubu naking. ");
INSERT INTO uvh_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Ning tanga marara Jisas u bema fugang amanga sam kadagang ka yong bibik ganang wara'ganang nagira tonga tarakama ga' ning tonga tiging. ");
INSERT INTO uvh_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Ka mokngang, Jisas adi aming anasining bining ganang unggung tafafaranga anganga ibinga mugo tugu'. ");
INSERT INTO uvh_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Ning tanga Jisas adi Kapaneam yong ka kama tubo Galili tara' waraga' mugogu'. Anga kadofinga iya' mengkura ning kama sabat ganang ka siring yak ganang amanga Anutuning midi yanggeku'. ");
INSERT INTO uvh_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Ka aming adi Jisas wari aming kigineng girii guk ning adenga midi u mutu kabi'guk mo' tanga kigineng sa' tokadofinga yaregu' u kanga base tiging. ");
INSERT INTO uvh_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Ka aming mini unggo kadagang guk nua'ni undu' unggung amanga mareiagu', ka wari Jisas u kanga ku bang ning katigu', ");
INSERT INTO uvh_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","ai Jisas Nasaretni gu nasi' tanibonga abangang. Gu indifikadaga unda' tonga abangang. Na kuma' gapkedarik gu udi Anutuning aming didimeng sini' ka Anutu wari gangkareinga abarang. ");
INSERT INTO uvh_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Ka Jisas wari aming wara'ning mini unggo kadagang u ning anisefigu', kabap aming u kagabi tanga mugo te'. Ning tuguinga mini unggo kadagang wari aming u kabonga tantaramik tinga aming wari kamaganang unggung mangfugu'. Ning tanga mini unggo kadagang wari aming u kagabi tanga mugo tugu'. Ka aming u mangfugu' wa fugu ganang kagaya ni guk mo' bemgu' karengsa' giri kaging. ");
INSERT INTO uvh_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Ka aming wari Jisas wari mini unggo kadagang anikagaregu' u kanga base tanga ning toging, ai napa' girii sini' tara' kayam. Adining midi udi kigineng guk wara' adi mini unggo kadagasi inara' udi nakngam sa' tanga maing. ");
INSERT INTO uvh_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Ning tanga anga napa' u kaging waraga' amise fam ubu ina yareinga midi ne ka Jisas wari aming u tipkarendagu' wara'ning wari kama tubo wara'ning yong yong u sura mugoinga naksasu'neging. ");
INSERT INTO uvh_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Ka siring wari bibi' tinga fugang kadofinga afanga ning tanga Jisas wari Saimon Pita ning yak ganangga' mugogu'. Anga kadofiinga aming wari ning aniging, o girii, Pita ning ipmangni udi bagana fugu kagaya mamareng tanga defata' ka gu yotangkangam te'. ");
INSERT INTO uvh_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Ning aniinga Jisas wari iyung ka taming wari bagana tanga defagu' ganang unggung amanga adenga bagana u anikagarengaminga bagana wari bingam tinga kaga'sa' karendagu'. Ning tanga fugu ararangeng karengsa' ubu naknga Jisas se' ga' nana siam kane tugu'. ");
INSERT INTO uvh_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Ning tanga defaging. Ka kibiri ganang ka aming wari amise fam ka bagana kuni' kuni' guk u Jisas wari ifakarendaim ga' sura inagira Jisas ganang abiging. Ning tinga Jisas wari bagana aming u suroyapma yareinga dabiksa' karendasasu'neging. ");
INSERT INTO uvh_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Ka aming masi' unggo kadagasi guk fam adi Jisas wari masi' unggo kadagasi u yangkagareyamgu' waraga' tanga barap nakngama Jisas u ku ning katinga yareging, ai indi kuma' gapkedem gu udi Anutuning mindingni. Ka Jisas adi wap ka Anutuning Kasira Aming ning u sirengsa' kuma' totuaging waraga' bibi' naknga yangsefi tangkunang sini' tugu'. ");
INSERT INTO uvh_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Ning tanga deia' kamindap gaa' sini' marara yong ka u kabinga kama base sige waraga' mugogu'. Ning tanga aming wari adita' wena tanga yareging. U wenanga anganga katua tanga Jisas u adisining yongganang unggungsa' iikga' anisefiging. ");
INSERT INTO uvh_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Ka Jisas wari ning yanggu', mo' na yong kubanik sidita'sa' mo' abuguk. Na Anutu wari kane ka kama yong yong dabik u yangara midi ka aming wari adining bining kareng ganang iik wara'ning u ina yara waraga' nangkareinga abuguk. ");
INSERT INTO uvh_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ning ina ning tanga ibinga anga kama tubo Judia tara' wara'ning yong yong u yangara adisining siring yak ganang amanga Anutuning midi kareng u ituaima fiararugu'. ");
INSERT INTO uvh_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Ka Jisas wari Genesaret gwang gaga u anga kadofiinga ami taming kabi'mo' wari Anutuning midi nakonga abanga Jisas ganang u bak girii tiging. ");
INSERT INTO uvh_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Ka Jisas adi midi adenga tugu ning kama guk mokngang waraga' tanga bot fama' ka aming ama ging mamanggak ning wari umben yotironga gaga fabang kuking u fonga yaptuagu'. ");
INSERT INTO uvh_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Fonga yapma ning tanga anga bot ka Saimon Pita ning wara'ganang aranga meku'. Ning tanga Jisas wari Pita u katinganinga anga Pita wari bot u gwang bining kabi'ning sungnanga tonga iragu'. Ning tinga Jisas adi wara'ganang mera ami taming kabi'mo' wara'siga' midi fiamgu'. ");
INSERT INTO uvh_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Ka Jisas wari midi u ina biinga ning tanga Saimon u ning anigu', amige fam do katiana abanga bot ganang arapma ning tanga gwang bining do anga ama ging ga' umben kamani'. ");
INSERT INTO uvh_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Ka Saimon wari ning anigu', ai girii kama ka idi ama ging kabi'guk mokngang gam. Indi kami tiim kuma' kamagisifanga anganga kubanik bemna guk mo' tanga kama sigesa' tipfangam. Ka gu torang wara' nua'bu kuma' kamigantam. ");
INSERT INTO uvh_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Ning tanga anga umben u bema gwang ganang kamainga ama ging kabi'mo' wari umben wara'ganang amanga to'na sini' tugu'. Ka ama ging kabi'mo' wari tanga mamarenga umben udi ibaramak tonga tugu'. ");
INSERT INTO uvh_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","U kanga amise fam ka bot nua'ni ganang aging wari bot u bema anga yotangkayap titiga' katiangging. Ning tinga anga ama ging u wenga manggara bot fama' wara'ganang kura ifitona sini' tanga manggara abiging. Ka ama ging wara'ning mamareng wari tanga bot fama' udi amama tonga tugumu'. ");
INSERT INTO uvh_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Ka Saimon Pita adi ama ging kabi'mo' ka Jisas wari midi togu' wara'ganangsa' manggeging u kanga mutu tanga Jisas ning kayong ganang u manda upma mera Jisas u ning anigu', o girii na aming kadagang, na ningyara' wari gugok marek ning guk mokngang wara' gu ninibi tanga mugo te'. ");
INSERT INTO uvh_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Ning tinga aming dabiksa' ka bot ganang u mareiaging adindu' u kanga mutu tanga base tiging. ");
INSERT INTO uvh_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Ka Saimon ning amine fama' ka fikifiki adigok kane kubap dabik tiaging adi Sebedi ning mindine ka Jems ya Jon ya adindu' napa' girii u kanga base tugumu'. Ka Jisas wari Saimon u ning anigu', gu mutu mo' totang. Inga' gu aming arantagim girii ka naganing arantagim ganang iikga' wa kami ama ging i manggatang ningsa' tanga inagire'ga' ning anigu'. ");
INSERT INTO uvh_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Ning tanga bot ganang u mera anganga gwang gaga do kadofinga botsi' a napa' mambongsi' fam u ibisasu'nanga ning tanga Jisas ning kanesa' ubu tonga Jisas u yaranga mugoging. ");
INSERT INTO uvh_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Ka Jisas wari yong nua'ni ganang ubu anga kadofigu'. Ka yong wara'ni aming nua'ni ka bagana kadagang fugu udi tangkunasi siamo' guk wari Jisas u kanga anga Jisas ning kayong ganang mangfanga mungkupnanga mera ning togu', o girii gu girisa' nifikarendaning ning gabarik wara' gu bibiri' nabe'. ");
INSERT INTO uvh_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Ka Jisas adi nakngam sa' tanga fugu u suronga ning anigu', we' kuma' gifikarendarik. Ning aniinga udi kadagasi fugu ganang wari kaga'sa' bingaminga karenda tugu'. ");
INSERT INTO uvh_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Ning tanga Jisas wari aming u anisefi tang ning tugu', napa i tagamarik ya aming fam mo' sini' inotang. Gu i anga pris ganang didimengsa' kadofotang. Ning tinga pris wari karengsa' ubu kadofirang u gapma kadapmang ka tim Moses wari togu' u titing u yaranga Anutuga' sura napa' karesi tanga sangamotang. Ning tinga aming wari u gapma ning tonting, o beng sini' adi tubobu kuma' karendanga fugu kareng nua'bu kuma' ba bema ita'. ");
INSERT INTO uvh_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Ka Jisas adi aming u anisefi tangkunang kuma' tugu' de ka aming fam ka Jisas wari kane u tugu' udi kuma' kaging. Ka wari anga tonga yareinga Jisas ning kane wara'ning midi ne wari girii giranga anga kama yong yong u dabiksa' kuma' naksasu'neging. Ning tanga aming kabi'mo' wari Jisas ning midi u ninak a bagana guk wa bagana u tanga yugukyam waraga' sura Jisas ganang fabiaging. ");
INSERT INTO uvh_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Ka fikifiki Jisas adi kane u tanga anganga aming u ibinga ning tanga base ganang anapmo'sa' anga Anutuga' ibang tutugu ning tanga itarugu'. ");
INSERT INTO uvh_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Ka inga' Jisas wari aming nua'ni ning yak ganang amanga ami taming fianggeku'. Ka Farisi arantagim a sasuk aming fam ka Jisas u kadidima waraga' ka yong yong kama tubo Galili a Judia tara' a Jerusalem yong girii wara'ni wari marara abiging ka adindu' dabik unggung marekinga yanggeku'. Ka Jisas adi kane wa Anutuning tangkunang guk tanga yangagu' wara' adi bagana aming ifakarenda ning undu' tugu'. ");
INSERT INTO uvh_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Ka Jisas wari aming u fianggeku' ganang ka yong wara'ni aming fam wari aming nua'ni bagana agik mamareng sini' tanga kayong kafong kuma' kumoging u Jisas wari tipkarenda ga' sura Jisas ganang ipma bema abiging. ");
INSERT INTO uvh_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Ka yak udi aming kabi'mo' wari kuma' amanga tiptoneging waraga' tanga iming ganang didimeng bema ama ga' tanafek tanga yak fugu furo'ning kuta bema areging. Aranga ning tanga yak mebik u kwetama aming basing u aya wari tofinga kamainga amanga Jisas ning mamamni ganang didimeng amanga deiagu'. ");
INSERT INTO uvh_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Ka Jisas wari bagana aming wara'ning amine wari Jisas ning kigineng ga' naktangka tanga kabaksi' kubaniksa' kufara kane tang sini' tiging u yapma bagana aming u ning anigu', kuyana guning kadagang wa kami kuma' bigamira'. ");
INSERT INTO uvh_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Ka Farisi arantagim a sasuk aming girisi fam wari midi ka Jisas wari kadagang kuma' bira' ning togu' u naknga yuguk aranga anasa' ning toging, ai adi midi ka Anutu anikige ning guk wa naga' tora'. Aming indi kadagang tanga yuguk ning tang guk mokngang. Anutu anapmo' kubaniksa' wa giri aming ning kadagang tanga yugukyam ning tangkunang guk ikita'. ");
INSERT INTO uvh_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Ka Jisas adi midi kapmo' toging u kuma' yapkedanga ning yanggu', indining, naga kadagang kuma' tanga kayogamirik ning u midisa' torik waraga' nakadanam ting wa. ");
INSERT INTO uvh_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","A naga mamarak te' ning u sidining dasi'ganang sirengsa' aniinga marara mauta' wa giri wa. Mokngang, undu' tangkunang guk dabik ningsa'. ");
INSERT INTO uvh_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Ka na sidi Anutu wari tangkunang ka aming ning kadagang tipmiri wara'ning wa Amingning Tim Iyak nagata' kuma' namgu' ning u kanga nakeda waraga' napa' ni tasamotik i kani'. Ning ina ning tanga bagana aming u ning anigu', we' mamarak tanga kwi'ga mambong u manggaknanga yakang ga' mugo te'. ");
INSERT INTO uvh_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Ning aniinga bagana aming wari aming kabi'mo' ning dasi'ganang u urapsa' marara kwi'ni mambong u manggaknanga ning tanga yoringga' anga Anutuga' mesisiringa sa' tanga tanga mugogu'. ");
INSERT INTO uvh_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Ning tinga aming wari u kanga base tanga o kami napa' tangkunang sini' kadofira' kayam ning tonga Anutuning wap bema Anutuga' mesisiringa ubu tiging. ");
INSERT INTO uvh_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Ka Jisas wari yak ka u kabinga fugang afanga ning tanga yongganang u kadak kabi' arengagu'. Ka aming takis manggakiaging wara'ning kane aming nua'ni ka wapni Livai a wapni nua'ni Matyu u anga katuagu'. Adi takis mamanggak ning yak kabasi'ganang unggung mera kane fatugu' u kataunga ning anigu', gu abubu tanga nagok kubap manam. ");
INSERT INTO uvh_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Ning tinga Livai adi Jisas ning midi u ninaksa' tanga marara adining kaneni a mambong fam u ibisasu'nanga Jisas u yaranga adisigok kubap ubu mugoging. ");
INSERT INTO uvh_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Ning tanga Livai wari Jisas u kafakafa tangam ga' sura inga' ananing yak ganang unggung Jisas ga' tangsanangam girii tugu'. Ka Livai adi nana u abanga nana waraga' adining amine fam ka tim adigok kane dabik tiaging wara'ning kabi'mo' abanga aming sige fam undu' katianinga dabiksa' abanga Jisas guk nana dabik u mera naging. ");
INSERT INTO uvh_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Ka Firisi guk ka adisining sasuk aming girisi fam guk wari Jisas wari aming kadagasi ka kadapmang didimeng mo' titisi wara'siguk nana kubap naging u yapma Jisas ning arantagimni u ning yangging, ai sidi aming kadagasi guk nana kubap ba mera faning. Indi aming kadagasi ka takis mamanggesi a aming ka sansaramik titisi adisigok nana kubap kabi'guk mo' natam. ");
INSERT INTO uvh_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Ka Jisas adi Farisi wari midi u toging wara'ning u kuma' kanga midi tipfara tanga ning yanggu', beng sini' dokta adi aming karesi guk mo' yabiting. Mokngang adi aming ka bagana guk unggungsa' yabiting. ");
INSERT INTO uvh_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Ka nandu' ningsa'. Na aming ka kadapmang didimeng kuma' yaranga tanga iking u ifimarak ga' mo' abarik. Mokngang na aming ka kadagang tanga iking u ifimarakinga kabaksi' faranga kadagang u kabinga kadapmang kareng ganang ubu iik waraga' abarik ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Ka aming sige fam ka anasigok unggung mareiaging wari Jisas u ning aniging, indi kadapmang ka Jon ning arantagim wari fating wa ning fiabem, adi Anutuga' sura ibang tounga wa adi nana tapni guk tanga fatuguting. Abanga Farisi arantagim adindu' ningsa' titing. Ka guning arantagim adi tapni guk mo' tanga nanga au sa' wa indining fating fiabem. ");
INSERT INTO uvh_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Ka Jisas wari midi tipfara tanga ning yanggu', sidi kadapmang ka aming wari kafauwe titiga' tangsana tanga titing waraga' sukni'. Adi ning titing, aming ka tangsana wara'ning nana u nana ga' ininga abuting adi aming ka kafauwe titining wari adisigok kubap ko marekiting ganang wa giri mesisiringa tanga nana sa' titing. ");
INSERT INTO uvh_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Ka inga' aming wari kafauwe titiga' abanga nagira auinga wa adi bibiri' naknga nana tapni wa wara'ganangsa' titing ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Ka Jisas wari adining kadapmang inga'ni kigineng guk waraga' midi tipfaraim nua'bu tanga ning yanggu', kadapmang nua'ni ka ning. Kwi' timini ginang guk wa kwi' inga'ni wari guk mo' dopma muntofotang. Mokngang, ning wa kadagang kautang. Wa kwi' inga'ni kareng tipkadauta'. Abanga kwi' inga'ni ning dibing wari kwi' timini ganang garinga adeuta' wa kadagang kesini kautang. ");
INSERT INTO uvh_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","A nua'ni ka ning, wain ama inga'ni kigineng guk wa maga giknim kandang ka timini wara'ganang mo' tagarotang. Mokngang ning wa wain ama inga'ni kagaya guk wara'ning kigineng wari tanga kandang u ibaramak tanga wain ama wari kwasina tinga kandang undu' wadigi' kadauta'. ");
INSERT INTO uvh_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Waraga' tanga wain ama inga'ni wa kandang inga'ni kareng wara'ganang didimengsa' tagarotang. ");
INSERT INTO uvh_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Abanga aming ka wain ama timini kuma' topnakabanga ikiting adi timini waraga'sa' kuma' nakiting. Wara' adi wain ama ka inga'ni u topnanga a ya kadagang ning tonga bibi' nakiting ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Ka inga' Juda ning mengkura ning kama sabat nua'ni ganang ka Jisas guk ka arantagimni guk wari kibiri ganang ka kama nua'ni ga' maunga kadapmang ka wit feng bining u yaranga mugoging. Anganga arantagimni wari seksi' naknga wit mindip kabi' u urifara manggara fagira nang nanga mugoging. ");
INSERT INTO uvh_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Ka Farisi arantagim fam wari u yapma anga Jisas u ning aniging, ai mengkura ning kama ya kane kabi' titiga' wa tapni sini' urang udi. Ka guning arantagim adi wit mindip u manggara kane guk tanga naing yabem. ");
INSERT INTO uvh_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Ka Jisas wari ning yanggu', ka sidi bumara' ka tim indining papani' Devit wari nana kama tapni ganang kuking u manggara nagu' wara'ning yoking u mo' ba indangira nakiting. Ka wa Devit adi ning tugu', fiking nua'ni ganang ka arantagimni guk seksi' kagaya sini' naking. ");
INSERT INTO uvh_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Ka adi nana guk mokngang u kanga siring yak ganang amanga baret ka Anutuga' ning tonga kuma' totangkanga kukngamging tapni guk u manggara ana nanga a arantagimni ga' undu' upiaminga naging. Baret ka wa tapni guk aming wari nana ning guk mokngang, pris warisa' nana ning de ka Devit adi unggung nagu'. ");
INSERT INTO uvh_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Ning ina ning tanga ning yanggu', wara' sidi ning nakanting mengkura ning kama sabat wa Amingning Tim Iyak nagasa' katatorarik. Wara' nasi' kadapmang ka aming wari sabat ganang tinting u kigedotik. ");
INSERT INTO uvh_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Ning tanga ira anganga mengkura ning kama sabat u nua'bu katuaging. Ka Jisas wari siring yak ganang u amanga ami taming fianggeku'. Ka aming nua'ni kafong kareng kungkumong guk adindu' unggung amanga Jisas ning midi u mera fanaku'. ");
INSERT INTO uvh_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Ka Farisi arantagim a sasuk aming fam adindu' Jisas wari aming ka ni sabat ganang tipkarendainga wara'ganang animbenga bimbem waraga' sura amanga mera fakafatatoreging. ");
INSERT INTO uvh_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Ka Jisas adi Farisi ning sasuk u kuma' yapkedanga aming kafong kadagang u ning anigu', gu mamarak tanga ita' abanga adeia'. Ning aniinga anga adegu'. ");
INSERT INTO uvh_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Ning tanga Jisas wari Farisi a sasuk aming u ning yangkagu', wa indining suking mengkura ning kama wa kane ka aming ifakadaga ga' titining wa ma kane kareng ka aming yotangkayap ga' u titining. ");
INSERT INTO uvh_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Ning ina ning tanga aming u ifang yaranga aming kafong kadagang u ning anigu', kafaga u wetatare te'. Ning aniinga wetatare tinga kafong kadagang wari kaga'sa' karendagu'. ");
INSERT INTO uvh_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Ka Farisi a sasuk aming arantagim adi u mengkura ning kama tapni tipkadaimgu' u kanga Jisas ga' kabaksi' kadagang sini' nakngamging. Ning tanga anasa' ning tonga naking, aming ka udi nasi' tantam sam. Tanga kadapmang udangaminga bibi' to ning toging. ");
INSERT INTO uvh_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Ning tanga iya' tiim nua'ni ganang ka Jisas wari beni Anutuga' ibang tounga kama bubo ganang anapmo'sa' aregu'. Aranga ibang u tonga anganga kamasa' tipfagagu'. ");
INSERT INTO uvh_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Tipfanga ning tanga arantagimni u katiana arantagimni wari aranga kainga aming 12 ka adining arantagim sini' ira adigok kane kubap titi waraga' ifakasiranga ning tanga wap ka aposel u yamgu'. ");
INSERT INTO uvh_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Ka aming ka Jisas wari u ifakasiregu' wara'sining wapsi' wa ning, Saimon wa Jisas wari wapni inga'ni Pita ning ubu yoku', a kuyangni kabasi' Andru a Jems iguyangguk Jon ya a Filip a Batolomiu. ");
INSERT INTO uvh_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","A Matyu a Tomas a Jems ka Alfias ning mindingni a Saimon nua'ni ka Selot arantagimni. Arantagim ka wa Rom ning gavman tipkadaga waraga' kane kapmo' fatiaging wara'ning. ");
INSERT INTO uvh_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Abanga Judas ka Jems nua'nining mindingni a Judas nua'ni Iskeriot ning mindingni ka inga' Jisas tipkadofiaminga digirapni wari uuk titiga' bemging ning u ifakasirinagu'. ");
INSERT INTO uvh_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Ning tanga Jisas guk ka arantagimni guk wari kama bubo u kabinga afanga kama kubing kareng ka aming arantagim girii ka Jisas u yaranga fengaging wari faging wara'ganang u dabik adeging. Ka ami taming kabi'mo' ka kama yong yong ka kama tubo Judia tara' wara'ni a Jerusalem yong girini a gwang girii gaga Taia yong a Saidon yong wara'ni ning wari Jisas u kaunga marara abiging. ");
INSERT INTO uvh_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Ka adi Jisas ning midi u naknga a Jisas wari aming bagana guk u ifakarendaim waraga' sura abiging. Ning tinga Jisas wari midi kareng yanggera a bagana aming u ifakarendanga ning tanga aming ka masi' unggo kadagasi guk wa masi' unggo kadagasi u tanga yugukiama ning tugu'. ");
INSERT INTO uvh_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Ka aming kabi'mo' wari bagana aming u Jisas ning tangkunang ganangsa' karendaging u kanga adindu' Jisas u tifema karenda titiga' sura Jisas ganang u bak girii sini' tiging. ");
INSERT INTO uvh_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Ka Jisas wari arantagimni u ning yanggu', sidi kamaganang ning napa' karesi ga' nafek tanga ira wa waraga' mamareng mo' nakanting. Mokngang sidi kabaksi' karengsa' naknga ikanting. Aming ka tatafak ka sidi ningwara' wa Anutuning bining ganang ira kareng gi' ningsa' ira au wara'ning. ");
INSERT INTO uvh_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Abanga sidi tugumung ira nanaga' seksi' naknga undu' kabaksi' karengsa' naknga ikanting. Inga' sidi kabaksi' damdangsa' ira seksi' guk mo' nakni'ga'. A sidi kabaksi' mamareng guk naknga ira undu' kabaksi' karengsa' naknga ikanting. Inga' sidi kabaksi' ararangeng kareng guk ira mesisiringa sa' ubu tanga ikni'ga'. ");
INSERT INTO uvh_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Ka aming fam wari sidi Amingining Tim Iyak naga nawara naganing kane tanga ikanting waraga' tanga sidita' bibi' sini' naknga manda uksama ning tanga a sidi aming kadagasi ning saninga undu' sidi waraga' kabaksi' mamareng mo' nakanting. Mokngang sidi kabaksi' karensa' naknga ikanting. ");
INSERT INTO uvh_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Ka aming ka sidita' kadagang siramikanting wa tim adisining papase wari Anutuning profet arantagim undu' kadagang ningsa' iramikiaging. Wara' sidi adi kadagang ning siramakinga wa sidi ning sukanting, o indi kane ka ya tim profet wari tiaging ningwara' tem wara' inga' kunim yongganang anam wa Anutu wari indita' napa' kareng girii sini' kuma' kuknimgu' u nimo'ga'. Ning sura kabaksi' karengsa' naknga mesisiringa sa' tanga ikanting ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Ning tanga aming ka mambongsi' kangasi titisi wa ning yanggu', a aming ka mambongsi' siamo' guk ira mambongsi' waraga'sa' naknga tanga iking sidi kabaksi' mamareng nakanting. Sidi napa' karesi manggara kareng gi' kuma' ira abing wara' sidi inga' wa Anutuning kafong ganang iik kareng guk mo' bemni'ga'. Mokngang fakara tini'ga'. ");
INSERT INTO uvh_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Sidi nana karesi kuma' nibera iking sidi kabaksi' mamareng nakanting. Inga' sidi fakara tanga seksi'sa' ubu naknga ikni'ga'. Sidi ararangeng karengsa' naknga mesisiringa sa' tanga iking sidi kabaksi' mamareng nakanting. Inga' sidi kabaksi' mamareng girii naknga mak sa' kara ikni'ga'. ");
INSERT INTO uvh_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Abanga sidi aming fam wari aming karesi ning sapma sidining wap sige bema areting undu' kabaksi' mamareng nakanting. Tim adisining papase wari profet mandaga' undu' yapkeda guk mo' tanga ningsa' iniaging. Wara' kami yara'ganang undu' aming kadagasi ning wap sa' bema areting ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Ka Jisas wari aming arantagim ka adining midi ga' naking u ning yanggu', ka aming ka naganing midi naknga naning arantagim iking sidi naganing kadapmang yara waraga' wa ning sanotik, aming wari sidita' bibi' naksama digirap ikinga wa sidi kafakafa sa' tiapmanting. ");
INSERT INTO uvh_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Abanga aming wari midi kadagang ka kadaga titiga' saninga wa sidi banaksi' giptanga midi kadagang kura' tubobu guk mo' yangting. A adi sidita' bibi' naknga sangkige tinga wa sidibu Anutu wari yotangkayap ga' ibangsa' toyamting. ");
INSERT INTO uvh_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Abanga aming wari faasi' tubo u sidifiinga wa kabaksi' kadagang mo' nakanting, mokngang. Sidi kugurang ning kadapmang tanga faasi' tubo undu' kabiam sa' tinga sidifinting. A aming wari sidining saket sarombemnainga wa sidi iibi sa' tanga siotsi' nua'ni undu' yamting. ");
INSERT INTO uvh_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","A aming ka ni sidining napa' ni amimi ga' saninga wa sidi ninaksa' tanga amimi sa' tinting. A adi sidining napa' ni wa sirombemnanga mugoinga wa sidi tubobu bemsama abu ga' guk mo' tonting. ");
INSERT INTO uvh_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Beng sini' kadapmang kareng ka gu aming fam wari guta' tagam ga' nakitang ning wa gu aming fam ga' undu' ningsa' tiamotang wa karengsa'. ");
INSERT INTO uvh_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Abanga kadapmang ka kura' nakngam ka sidaning amise ga'sa' tiam wa Anutuning de ganang wa wap guk mokngang. Kadapmang ka amise ga'sa' ninak ning ka ningwara' wa aming kadagasi ka Anutuning midi ga' manda ukngamiting adindu' fafong titing. ");
INSERT INTO uvh_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Abanga kafakafa ka aming wari tasaminga kura' tubobu tiam wara'ning undu' Anutu adi u kanga o karengsa' tara' ning guk mo' touta'. Mokngang kadapmang ka napa' kura' kura' titining ningwara' wa aming kadagasi adindu' fafong titing wara' wa napa' tangkunang mo'. ");
INSERT INTO uvh_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Abanga kadapmang ka aming ga' napa' ni imonga wa a adi aming ai' tita' wara' kura' tubobu kuma' namo' ning sura iyam wara'ning wa Anutu adi napa' kigineng ning mo' kata'. Mokngang wa aming ka Anutuning midi guk mo' nakiting wari amise ka ana ningwara' wara'siga' ima tubobu undu' didimeng ka ningwara'sa' iyam ga'sa' sura ikiting wara' wa napa' tangkunang mo'. ");
INSERT INTO uvh_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Ka sidi aming ka sidining digirap ka sidita' bibi' nakiting wara'siga' wa adi indita' bibi' nakiting wara' indindu' bibi' nakyamem ning guk mo' tonting. Mokngang sidi adisita' naknga kafakafa sa' tiapma ning tanga napa' ima undu' kura' tubobu sansam ga' guk mo' sura tubosa' iyam sa' tinting. Sidi kadapmang kareng ka ning u tinting wa inga' Anutu wari sidita' kafakafa girii sini' tasamo'ga'. Ka Anutu adi kadapmang kareng wa ning tita', adi aming kadagasi ka Anutu wari napa' karesi iminga Anutuga' asekna guk mo' tuguting wara'siguk kafakafa dabiksa' tiabita'. Ka sidi kadapmang kareng ka Anutu wari aming ka adita' guk mo' sukiting wara'siga' tubosa' tiamita' ningsa' tinting wa sidi Anutu girii sini' ning mindine arantagim ning kadapmang kareng beng sini' tanga ikanting. ");
INSERT INTO uvh_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Beng sini' Anutu adi aming ga' bibiri' siamo' nakita' wara' sidindu' aming fam ga' bibiri' siamo' ka sidaning babangsi' wari tita' ning nakyamting ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Ka sidi aming fam wari kadagang tinga wa sidi kadapmang ka usingsa' tagagareyap ning u yaranga a adi aming kadagang ning u urapsa' mo' tonting. Mokngang Anutu wari sidining kadagang ka aming usingsa' tagagareyapmanting waraga' ma sapkedanga tagagaresabo'. Ka aming wari sidita' kadagang tasaminga wa sidi adisining kadagang waraga' sasuk mimeng sini' ko tanga ira kadagang u kura'bu tiam ga' guk mo' sukanting. Mokngang adisining kadagang ka sidita' tasam ning wa suknakubeyam tinting. Ning tinga Anutu girii adindu' sidining kadagang u suknakubesamo'ga'. ");
INSERT INTO uvh_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Beng sini' sidi kadapmang kareng ka ai' dap ning u tanga aming fam ga' kafakafa sa' tiamting wa Anutu adindu' ai' dap tanga kadapmang ka sidi aming ga' tiamting ningsa' tasama sidita' napa' karesi kabi'mo' ka napa' mambong kandang ganang dasito'na sini' tinga fam ka manfu guk urang titing ningda'ning tasamo'ga'. A sidi aming fam ga' kabi'sa' tiamting wa Anutu adindu' kabi' ningsa' tasamo'. ");
INSERT INTO uvh_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Ning ina ning tanga Jisas wari aming wari Anutuning kadapmang didimeng titi u nakeda waraga' midi tipfaraim kabi' tanga ning yanggu', ka wa ning, aming de kadagang guk wari de kadagang nua'ni ning kafong wenga kadapmang mo' anatintingnanga antamu'. Mokngang ning wa kama kadagang ganang fama' guk dabiksa' mangdipmota'. ");
INSERT INTO uvh_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Abanga sumatin ka skul tota' adi aninggek aming tisa u mo' tarafarota'. Mokngang adi skul u tanga anganga sasuk u bemsasu'nanga wa giri adining sasukni wari tisani guk dabiksa' wa inga' irota'. ");
INSERT INTO uvh_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","A kadapmang nua'ni ka ning, aming ka de sasu girii guk wari amingni nua'ni ning de susu kabasi' u kanga tanga kayo titiga' arokngam mimeng mo' tota'. Mokngang adi susu girii ka ananing de ganang u tanga kayo waraga'sa' surota'. ");
INSERT INTO uvh_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Ka adi de susu girii wari ko fideinga amingni u o kuyana na yotangkagam tanga daga susu u tanga kayogamotik ning anota' wa didimeng mo', kadagang tara'. Adi tim ka susu girii ka anining de ganang isefinga fidera' u tanga kayonga kafakafa degaranga ning tanga susu kabasi' ka kuyangni ning de ganang wa inga' kanga tanga kayongamota' ning wa giri didimeng ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Ka Jisas wari aming ning kabaksi' waraga' midi tipfara nua'ni ning tugu', ka indi firi undu' kuma'sa' yabitam. Firi karesi ka mindip nana titining kuma' minditing wa firi mindip ka nana titining guk mokngang u mo' minditing. A firi ka kadagasi mindip sigening titing undu' firi mindip karesi ka nana titining wara'guk mo' minditing. ");
INSERT INTO uvh_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Wara' indi firi kareng wa ma kadagang ning wa mindipsi' unggungsa' yapkedatam. Abanga firi mindip karesi wa aya kusung guk baseni wa ma firi ka mindip kadagasi titing wara'ning giwang ganang guk mo' yabitam. Mokngang undu' giwangsi' ganang didimengsa' adeting yabitam. ");
INSERT INTO uvh_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Ka aming ning kabaksi' undu' ningsa'. Aming ka kaba ganang sasuk kareng guk irota' adi kane karengsa' tanga irota' kantam. A aming ka kaba ganang kadagang guk irota' wa adi fikifiki kadapmang kadagang sa' tanga ira auta' kantam. Beng sini' nasi' sasuk kareng wa ma kadagang ka aming ning kabaksi' ganang ikita' wa aming ana nasi' kadapmang tanga masi' wari togadofiting wara'gangangsa' yapma nakedatam. ");
INSERT INTO uvh_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Ka Jisas wari ami taming u ning yanggu', sidi fikifiki o gu naning girina ning wa giri fananing ka sidi naning midi wa kafakafa guk mo' fanaking. ");
INSERT INTO uvh_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Ka na aming ka naga nawara naganing midi ninaksa' titi u nakeda waraga' wa ning toutik, ");
INSERT INTO uvh_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","ka sidi kadapmang ka aming wari yak kiginesi tanga mating wara'ning undu' kuma'sa' yabiting. Adi yak u maunga wa tim ka kwang mimeng unanga amanga ning tanga mangkap tangkunasi sini' ipmanga yak kigineng sini' mating. Ka inga' gugubik kigineng wari abanga ifamota' wa mokngang, tuntumurum kabi'guk mo' tanga tangkunang ningsa' adeuta'. ");
INSERT INTO uvh_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","A aming ka naganing midi u naknga yara guk mo' titing adi yak ka kwang kafakafa guk mo' urang unanga tanga mating ningda'ning wari ikiting. Yak u kuma' tipkarendanga kabinga inga' gugubik kigineng wari kadofinga yak u ifaminga yak wari urapsa' tapating. Ning tanga napa'napa' ka kuma' ifakarendanga yareting wari wadigi' tubobu kadagating. ");
INSERT INTO uvh_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Ka Jisas wari aming u midi u ina ina ning tanga Kapaneam yongga' ubu mugogu'. ");
INSERT INTO uvh_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Ka Romni aming girii nua'ni ka ami'ning aming arantagim yaptatorarugu' wara'ning ka Kapaneam yong u itarugu' ka adining kane aming kareng nua'ni ka adita'sa' nakarugu' wari bagana mamareng sini' ka kungkumak titiga' sa' tugu'. ");
INSERT INTO uvh_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Ka adi midi ne ka Jisas ning kane kigineng wara'ning u naknga anga Juda ning aming girisi fam u ning yanggu', sidi anga Jisas u aninamting. Ning tinga naganing kane aming bagana mamareng sini' tara' i abanga tipmaraknamota'. ");
INSERT INTO uvh_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","5","Ning ininga anga Juda ning aming girisi wari Jisas u tangkunang sini' ning aniging, ai aming girii, Romni aming girii ka wa aming kareng sini' tita'. Adi aming arantagim nua'ni ning de ka adi Juda aming indita'sa' naknga yotangkanip tita'. Ning tanga adi siring yak magum u titi waraga' uningkim mambong girii sini' yotangkanipku'. Ka gu anga yotangkangam te' ning aniging. ");
INSERT INTO uvh_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Ka Jisas adi adisining midi u nakyam sa' tanga adisigok kubap aging. Anganga aming girii wara'ning yak ganang u kagadofi ga' dudure tinga aming girii wari u naknga amine fam u ning yanggu', ai sidi urapsa' anga girii do ning anini', ami'ning aming girii udi ning tora' na aming kareng mo' wara' girii adi naganing yak ganang ingging sini' mo' abota'. ");
INSERT INTO uvh_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Abanga na aming kareng mo', unggung anga kaga ning guk mokngang. Wara' adi kamani unggung ningsa' adenga midisa' tuguinga naning kunung aming yari karendanam tota'. ");
INSERT INTO uvh_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Abanga ning aninting, na aming girii tangkunang guk. Ka nandu' ami'ning girisi fam wara'ning kapmik ganang itik wara' na kadapmang ka midisa' tuguinga kane aming u midisa' ininga titining undu' fafong titik. Na naganing soldia arantagim u napa' ni ga' initik udi naknam sa' tanga titisa' titing. Naga u maya' ning toutik udi ausa' tota', a abubu te' ning toutik udi abubusa' tota'. Abanga aming ka naganing kunung tita' u kane ni titiga' anitik udi ninaksa' tanga tita'. Wara' girii adindu' unggung adenga midisa' tuguinga karendanamota'. Ning ina yangkareinga urapsa' anga Jisas u anisefinga midi ka u yanggu' u aninga yareging. ");
INSERT INTO uvh_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Ka Jisas wari midi ka aming girii wari togu' u abanga aniging udi kareng kuni' nua'ni sini' ka aming ka naktangka sini' tanga kabaksi' kubaniksa' kufara ikiting wari tutugu ning ning naku'. Ning tanga faranga aming arantagim girii ka mandang yaranga fengaging u ning yanggu', beng sini' aming ka wa arantagim nua'nini ka adining midi wa naktangka aming ning midi da'ning karengsa' nakarik. Fikifiki na Juda aming indining arantagim bining ganang aming sasuk kareng guk ka ni ningwara' guk mo' katuatik mokngang sini' ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Ning tinga aming ka Jisas anga aniging wari Jisas ning midi u naknga tubobu anga aming girii ning yak iyung amanga kaging wa aming girii ning kunung aming udi kaga' wara'ganang tubobu urapsa' kuma' karendagu'. ");
INSERT INTO uvh_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Ka Jisas adi Kapaneam yong unggung kabi'ning iya' ning tanga yong ka u kabinga yong nua'ni ka wapni Nen waraga' ubu mugogu'. Ka ananing arantagimni guk ka aming sige arantagim girii ka Jisas u yaranga aging undu' kubap aging. ");
INSERT INTO uvh_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Ka Jisas se' wari anganga yong bibik u kadofinga yapking ka yong wara'ni aming wari saba uyamang nua'ni kumogu' u unafarafi titiga' barungnanga abiging. Ka yong wara'ni ami taming kabi'mo' undu' aming u bema dabik abiging. Ka aming u kumogu' wara'ning mengni wa tamkasa' itarugu'. Adi mindine fam guk mokngang kubaniksa' ka kuma' kumogu' unggungsa' wara' adindu' bibiri' sini' naknga mak kara kubap iwara aging. ");
INSERT INTO uvh_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Ka Jisas wari aming kungkumong u kanga aming wara'ning mengni u bibiri' kanga ning anigu', o simeng gu mak mo' karotang. ");
INSERT INTO uvh_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Ning aninga ning tanga ararenga anga aming tagim u surogu'. Ning tinga aming ka barung tiging wari ade tinga Jisas wari aming kungkumong u ning anigu', saba uyamang gu mamarek te'. ");
INSERT INTO uvh_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Ning aniinga saba uyamang wari kaga' wara'ganang urapsa' karendanga tubobu seranga marara mera midi togu'. Ning tanga Jisas wari mengni u ning anigu', simeng giri, sabaga ka' tubobu kuma' ikamara'. Nagikna tanga mugo te'. ");
INSERT INTO uvh_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Ka aming adi Jisas wari aming kungkumong kaga'sa' tipmaragu' u napa' girii sini' ning kanga mutu tanga base tiging. Ning tanga Anutu animamangnanga ning toging, ai kami profet girii nua'ni ka Anutu wari aming indi yotangkanip ga' anigaregu' udi indiganang kuma' kadofira' yang. ");
INSERT INTO uvh_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ning tinga midi ne ka Jisas wari kane kigineng u tugu' wara'ning wari kama tubo Judia tara' a yong yong dabiksa' u girii giranga mugoinga naksasu'nanga yareging. ");
INSERT INTO uvh_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Ka Jon Baptis ning arantagim adindu' midi ne ka Jisas wari kane tangkunang tanga agu' wara'ning u naknga Jon u aniging. Ka Jon wari u naknga girii Jisas u kadidima sini' titi waraga' sura arantagimni fama' katiana ");
INSERT INTO uvh_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","ning yanggu', sidi i anga Jisas u kadidima sini' tanga ning anintamu', yotangkanip titining aming girii nua'ni ka Jon wari mandang abubu ga' togu' udi kuma' abarang gusa' iba ma nua'ni ko wa kapmekantam. Ning ina yangkareinga agumu'. ");
INSERT INTO uvh_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Anga kadofinga Jisas u ning anigumu', indi Jon wari gu gapdidima ga' ningkarara' kanga abiamuk. Adi ning nina', do anga kafakafa kadidimademu' aming ka naga mandang abubu ga' urang fatorik ane' wa ma nua'ni udep. Ning nina' ning anigumu'. ");
INSERT INTO uvh_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Ka kama ka wara'ganang wa Jisas wari aming bagana kuni' kuni' guk ka bagana mamaresi guk a fuksi'ganang udi kadagasi guk a masi unggo kadagasi guk, abanga dasi' kadagasi guk ning u kuma' ifakarendanga yaregu' ganang anga anigumu'. ");
INSERT INTO uvh_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Wara' Jisas wari aming fama' u ning yanggu', ka sidi napa' ka naga kane tirik wara'ning wa dasi' wari kanga a masi' wari naknga ning kuma' tiamu' wara' sidi tubobu anga Jon u ning anintamu', kane ka Jisas wari tara' wa ning. Aming dasi' kadagasi wa tubobu degaring a aming kasi' kadagasi undu' karenda tanga kadak didimengsa' ubu yangaking a aming ka fuksi' ganang bagana kadagang lepa guk undu' karenda tanga fuksi' fafandangesi karesi sa' ubu iking. A aming masi' pipesi undu' natam tanga midi ninaksa' ubu ting a aming kungkumosi undu' tubobu ifaseriinga maraking. Abanga adi aming ka mambong ga' nafek tanga tatafak ikiting wara'siga' Anutuning midi kareng ituaima yarara'. Ning anga anintamu' ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Ning ina ning tanga ning togu', beng sini' aming ka naga kane tangkunang tirik i kanga o beng guk sini' adi aming Anutu wari beng anigaregu' ning tonting adi sasuksi' kareng guk. ");
INSERT INTO uvh_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Ning tanga aming fama' ka Jon ning midi bema agumu' wari tubobu kuma' mugoinga Jisas wari Jon ning wap bema aronga ami taming u ning yanggu', ka tim sidi Jon kaunga kama bining sige ga' famayaging wa sidi aming beng wa aming sasuk fama' guk a aming baraganeng ka gugubik wari sigisap figira tipuwingna ningda'ning u kantam ning tonga u sura famayaging. ");
INSERT INTO uvh_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Abanga sidi aming kangasi ka kwi'ni a nasi' nasi' inga'ni sa'' tanga abara' u anga kantam ning tonga u famayaging. Mokngang, aming kangasi adi kama base sige ganang guk mo' dekiting. Adi napa' inga'ni sa' tanga yak karesi ganang unggung ningsa' ikiting. ");
INSERT INTO uvh_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Ka sidi dasi' wari ko mo' kanga wa aming girii profet u anga kantam ning sura mugoging undu' giri didimeng beng guksa' suking. Beng sini' Jon adi profet sini'. Ka adi profet ka tim kadofinga ira abiging u irafira profet tim iyak ning ita'. ");
INSERT INTO uvh_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Ka Jon wari kadofigu' waraga' wa tim profet nua'ni ka Malakai wari Anutuning midi ning kuma' yoku', na tim ka aming nua'ni ka tim anga guning kadapmang tipdidimagam waraga' anigareinga anga naning midi kareng u ituaima yarota'. Ning tinga gu mandang inga' wara'ganang aya' ning yoku'. ");
INSERT INTO uvh_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Ning ina ning tanga ning yanggu', ka Jon adi profet irafata' de ka aming sige wap guk mokngang ka nagata' naktangka tanga Anutuning bining ganang ikanting adi adisining iikning wap kareng wari Jon ning wap girii u tarafikanting ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Ka aming sige arantagim guk ka aming ka takis manggakiaging ka aming Juda arantagim ning fugang iikisi ning iniaging wara'siguk ka adi tim Jon ning midi naknga beng guk ning tuguinga ama kuma' iyamgu' wara' inga' adi Jisas ning midi u naknga undu' o Anutuning kadapmang wa didimeng kareng beng guk sini' ning tonga Jisas ga' naktangka tiging. ");
INSERT INTO uvh_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","A aming girisi arantagim ka Anutuning kane titi ning wap guk ka Farisi guk ka sasuk aming fam guk adi tim Jon wari ama iyam ga' bibi' Naking. Wara' adi inga' Jisas wari kadapmang kareng ka Anutu wari aming indi titiga' nakita' u yangtintingnegu' undu' kuma' kanga waraga' bibi' nakngamging. ");
INSERT INTO uvh_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Ka Jisas wari aming ka Anutuning kadapmang inga'ni kareng yangitintingnegu' waraga' bibi' naking wara'siga' midi tipfaraim ning tugu'. ");
INSERT INTO uvh_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Ka aming ka ningwara' wara'sining kadapmang wa sababi' wari yong bining mera sababi' amise fam ka napa'ga' igarang titisi u ning urang katianiting ningda'ning, a indi kabakni' kareng naknga mesisiringa tanga kandang figikem. Ka mokngang sidi mime ka waraga' mo' naknga mime guk mo' ting. Abanga indi mak kagak ning mime bibiri' toyam ka undu' mokngang, sidi bibi' naknga indigok dabik mo' toyam, ning urang titing ningda'ning ting. ");
INSERT INTO uvh_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Ning tanga Jisas wari aming ka adining midi ga' bibi' naking u ning yanggu', ka sidi aming midi tutubok tutugusi beng sini'. Tim Jon Baptis wari abanga nana tapni tanga nana karesi a wain ama u kabi'guk mo' nanga sigesa' yagu' u kanga wa sidi a, aming ka udi mini unggo kadagang guk kayam ning fanikigeging. ");
INSERT INTO uvh_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Ka inga' Amingning Tim Iyak nagabu abanga nana a ama u tapni guk mo' tanga nanga ausa' tirik u napma wa sidi ning fatoing, ai aming ka udi kadagang tara' adi nana a wain ama siamo' nuguta' kayam. Abanga adi fikifiki aming kadagasi ka aming takis mamanggesi a aming sansaramik titisi wara'siguk ngingeng kubap fengaking fagayam ning fatoing. ");
INSERT INTO uvh_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Ka midi beng guk sini' wa ning fideta', aming ka Anutu wari sasuk kuma' imara' adi Anutuning kane kigeda ning sasuk kareng guk. Wara' adi aming ning kane wa didimeng wa ma didimeng mo' ning wa sirengsa' kuma' kanga nakedanting ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Ka Farisi arantagim ning aming nua'ni ka wapni Saimon wari Jisas u adigok nana kubap angana ga' anigu'. Ning tinga Jisas wari Saimon ning yak ganang u amanga adisigok nana dabik mera naging. ");
INSERT INTO uvh_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Ka yong wara'ni taming nua'ni adi kadagang sansaramik fatarugu' ka adi aming wari Jisas udi Saimon ning yak ganang amanga adisigok nana kubap ning ning toging u naknga adining kadagang girii waraga' sura marara ananing iyung bane u amanga wel mupmu guk kareng tangkunang sini' ka uningkim diding guk kandang ganang tiging u bema Jisas kaunga agu'. ");
INSERT INTO uvh_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Anga Saimon ning yak iyung u amanga Jisas ning kayong ganang u upma mera ananing kadagang ga' sura mak kanga kogu'. Ning tinga mak ameng wari Jisas ning kayong ganang u mangfiging. Ka taming wari ananing ki sasa' paramu' wari urarafanangamgu'. Ning tanga Jisas ning kayong u bema tutu' yokngama wel mupmu adi' kareng bema agu' wari Jisas ning kayong ganang u tagara sufurungama yaregu'. ");
INSERT INTO uvh_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Ka Saimon wari u kanga ning suku', ai taming ya kadagang ka adi anikagare titiga' wa kagabi sa' wa indining tinga tangamara'. Adi profet sini' ganang wa giri taming i kigeda taro' ning sura mareiagu'. ");
INSERT INTO uvh_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Ka Jisas wari adining sasuk u kuma' kanga midi tipfara tangamonga ning anigu', Saimon midi kabi' ganotik. Ka Saimon wari anigu', we' girii tutugu te'. ");
INSERT INTO uvh_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Ning tuguinga Jisas wari ning anigu', wa ning. Aming fama' wari aming nua'niganang mambong dinau tanga sige manggakantamu', nua'ni adi girii 100 kina ning bemota' a nua'ni adi 10 kina sa' bemota'. ");
INSERT INTO uvh_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Ka dinausi' u tipmiri ning kadapmang nua'ni guk mokngang sini' wara' adi uningkim ga' nafek tanga kabiinga adisining dinau wari ko ningsa' fideuta'. Ka aming mambong tuang wari adisining dinau wari ko ningsa' fideuta' u kanga kaba ubu tipfaranga aming fama' u bibiri' yapma a na adisining dinau waraga' nua'bu mo' surotik ning tonga adisining wap u ifafeiaminga dinausi' wari wadigi' biuta'. Ka wa o gu nagata' bibiri' naknga kadapmang kareng sini' ba tanamarang ning wa mambong tuang wa aming ka indeng wari anota'. ");
INSERT INTO uvh_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Ka Saimon wari ning togu', mo' wa aming ka dinauni girii 100 kina ning tota' u udangamota' wari aninga tangamota'. Ka Jisas wari ning anigu', weng didimengsa' torang. ");
INSERT INTO uvh_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Ning tanga Jisas wari faranga taming u kafanga Saimon u ning anigu', ka Saimon gu taming yari naga ganang abanga napa' tanamara' u kanga waraga' suknamarang udi kuma' gabarik. Ka ning ganotik, na guning yak ganang i abangak ka gu Juda aming indining kadapmang didimeng yaranga kana yotik ning ama guk mo' giknamang. Ka gu taming i kaya' adi nagata' sura mak kara kana wa ananing de ameng wari' yotiknama ning tanga urarafinam undu' ki sasa' wari tara'. ");
INSERT INTO uvh_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Abanga na guning yak ganang i abangak ganang wa gu o kuma' abarang uba ning tonga kafana guk mo' wenamang. A taming adi nagata' siamo' naknga abanga naganing kana u bema tutu' mimeng yoknamara'. ");
INSERT INTO uvh_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Abanga gu kadapmang kareng tanga ganing wel mupmu guk ni bemnaminga kina mo' tagara sufurangak, mokngang. Ka taming adi nagata' kadapmang kareng tanam waraga' sura ananing napa' kigineng ka sanda mupmu guk kareng sini' unggung bema tabanga tagara sufurunama tipmirisasu'na sa' tara'. ");
INSERT INTO uvh_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Ka gu tim midi tipfara ka aming fama' wari mambong dinau u titining tanga ganak waraga' sure'. Wa sidi kadapmang fama' tanga iking waraga' sura tangak. Ka midi u tongak wara'ning kini wa ning, na taming yara'ning kadagang wa girii sini' u suknakubengamirik waraga' tanga adi nagata' kaba karengsa' naknga abanga tanamara'. A aming ka kadagang kabi'sa' tota' u suknakubengamotik wa adi nagata' mimeng mo' nakota', kabi'sa' nakota' ning anigu'. ");
INSERT INTO uvh_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Ning tanga Jisas wari taming u ning anigu', guning kadagang kuma' tanga kayogamirik. ");
INSERT INTO uvh_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ning tuguinga aming fam ka nana kubap mera naging wari u naknga mepgugung tanga anasa' ning toging, ai aming ka midi ka kadagang kuma' tanga kayogamirik ning guk tora' ya nisi'. ");
INSERT INTO uvh_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Ning tanga Jisas wari taming u ning anigu', gu nagata' naktangka tarang u gapma wadigi' kuma' gifikarendarik wara' gu i anga kabaka kugurang sa' naknga ira autang. ");
INSERT INTO uvh_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Ka u kabi'ning iya' ning tanga Jisas wari arantagimni 12 u inagira anga yong girisi a yong kababi' u yangara Anutuning midi kareng ka aming wari Anutuning bining ganang ikinga Anutu wari kafakafa tiap wara'ning u tokadofiama ina yareging. ");
INSERT INTO uvh_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Ka taming fam ka tim masi' unggo kadagasi a bagana guk yaging ka inga' Jisas wari tubobu ifikarendagu' adindu' Jisas u yaranga kubap mugoging. Ka taming wara'sining wapsi' wa ning, Maria yong Magdalani ka tim Jisas wari mini unggo kadagasi 7 ning tanga igukngamgu'. ");
INSERT INTO uvh_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","A nua'ni ka Joana wa king Herot ning kane aming arantagim u yaptatorarugu' wara'ning girii ka wapni Susa wara'ning tamni a Susana abanga taming fam undu' dabik iwara anga Jisas guk ka arantagimni guk u anasining uningkim mambong wari yotangkayapma tanga yangaging. ");
INSERT INTO uvh_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Ka yong yong wara'ni ami taming kabi'mo' wari abanga Jisas ganang u bak girii tinga Jisas wari midi tipfara ning tiamgu'. ");
INSERT INTO uvh_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","Ka aming nua'ni wari nana wit mindip u manggara fonga feng ganang igura yarota'. Ka wit mindip udi feng ganangsa' mo' mangfanting. Mokngang fam ka kadapmang ganang mangfanga sirengsa' marekinga aming wari tipmidadage tinting. A fam ka yang wari yora nanting. Ning tinga kagadofi guk mo' tinting. ");
INSERT INTO uvh_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","A mindip fam ka kama pamparangeng uningkim guk wara'ganang mangfanting. Mangfanga kagadofi udi giri kuma' tinting de ka mokngang, kama gom kareng mo', uningkim guk waraga' tanga mayam wari danga tubobu urapsa' kaforanting. ");
INSERT INTO uvh_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","A fam ka kama ka munggwak guk wara'ganang mangfanting. Mangfanga kagadofi udi giri kuma' tinting. Ka munggwak wari giranga ipmusiinga kirida tanga fatinting. ");
INSERT INTO uvh_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ka mindip fam wa kama gom kareng ganang feng bining sini' mangfanting. Mangfanga karesi kadofinga bong girisi giranga beng usap sini' ka ki kubanik kubanik wa wan handret wan handret ning dabiksa' tanga yaranting. Ka Jisas wari midi tipfara u tanga ina ning tanga ami taming u ning yanggu', aming ka sasuk guk wa midi u torik wara'ning ki u sura nakedanting. ");
INSERT INTO uvh_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Ka Jisas ananing arantagimni wari midi tipfara tiamgu' wara'ning kiga' nafek tanga Jisas u midi wara'ning kiga' anigaging. ");
INSERT INTO uvh_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Ka Jisas wari ning yanggu', na midi ki kapmo' ka Anutuning bining wara'ning wa sireng sini' wa sidisa' sanotik. A aming fam ga' wa midi tipfara sa' tanga inotik. Ning tinga adi kaga udi giri tinting ka mokngang kigeda sini' guk mo' tinting. Abanga adi ninak udi giri tinting ka adi nakeda sini' guk mo' tinting ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Ka Jisas wari arantagimni u ning yanggu', sidi midi tipfara tangak u naknging wara'ning kini wa ning. Wit mindip ka u ipmota' wa Anutuning midi kareng ipmira'. ");
INSERT INTO uvh_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Ka wit mindip ka kadapmang ganang mangfanting ning tongak wa aming ka Anutuning midi u naknga naktangka guk mo' tanga sasuksa' ko aratinga aming kadagang Setan wari Anutuning midi ga' naktangka tanga kareng gi' giri ma ikni' ning tonga adisining sasuksi' u urapsa' ufafeimita'. ");
INSERT INTO uvh_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","A wit mindip ka kama pamparangeng uningkim guk ganang mangfanting ning tongak wa aming ka Anutuning midi kareng u naknga kabaksi' munumung ganangsa' wa giri marakiting. Ka adi naktangka sini' guk mo' tanga kabi'sini' ning ikinga mamareng fam wari adiganang kadofiaminga adi mamareng waraga' tanga Anutuning midi kareng u urapsa' kabiting. Adi uningkim ga' tanga ke wari kama mang guk mo' urang amoting ningda'ning titing. ");
INSERT INTO uvh_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","A wit mindip ka mungwak mang mangfanting ning tongak wa aming ka Anutuning midi u kuma' naknga anga kabaksi' wari mambong karesi a napa' kamaganangni waraga'sa' naknga sasuk mimeng sini' tinga Anutuning midi kareng wari adisining kabaksi' ganang do giraga guk mo' tita'. ");
INSERT INTO uvh_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","A wit mindip ka feng bining kama marang guk kareng ganang mangfanting ning urang tongak wa aming ka Anutuning midi kareng u naknga waraga' kabaksi' kubaniksa' kufara naktangka sini' tanga baratarak guk mo' naknga kane tangkunang ningsa' tanga ira auinga Anutuning midi kareng a kane kareng wari girii giragata'. ");
INSERT INTO uvh_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Ka Jisas wari midi nua'ni ning yanggu', sidi kadapmang ka aming wari kamang gareting waraga' sukni'. Adi kamang u garinga bema napa' ni wari tungkum tanga kapmo' mo' sebiting. Mokngang adi kamang u garinga bema furo'ning sireng tabinga aming ka yak iyung u amoting wari sangang ganang sirengsa' degaranga marekiting. ");
INSERT INTO uvh_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Ka ning sanotik, Anutuning kadapmang kareng undu' kamang diok ningda'ning ikita'. Nasi' Anutuning sasuk kareng ning ki ka kami yara'ganang kapmo' ita' wa inga' diok ningda'ning sirengsa' ubu tokadofiinga naksasu'nani'ga'. ");
INSERT INTO uvh_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Ka beng sini' sanirik, sidi midi ka i torik ya ninak tanga suktangka kafakafa tinting. Aming ka naganing midi i naknga kaba guk kufara irota' adi Anutu wari midi ki mang mang fam kabi'mo' u amiinga naksasu'nanga irota'. A aming ka a na sasukna kareng guk giri ning tonga naganing midi u naknga waraga' kaba guk mo' kufarota' wa Anutu adi sasuk kareng kabi' ka adiganang kuma' adeuta' u tubobu irombemnota'. Ning tinga Anutuning sasuk kareng ga' nafek sini' tanga irota' ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Ka Jisas ning mengne kuyane wari Jisas u kaunga abiging. Ka ami taming kabi'mo' wari Jisas ganang u bak girii sini' tiging waraga' tanga fugang unggung ningsa' anga adeging. ");
INSERT INTO uvh_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Ka aming fam wari yapma Jisas u ning aniging, guning mamangge kuyage gu gabonga abanga fideing dong. ");
INSERT INTO uvh_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Ka Jisas adi midi kadapmang nua'ni ka mengne ganang u yora yangtintingnonga ning yanggu', udi giri kuma' nakarik. Ka ning sanotik, naning mamangne kuyane wa unggung sa' mo', mokngang. Aming fam ka Anutuning midi naknga kadapmang didimeng karengsa' tanga ikanting undu' naning mamangne a kuyane ning ina yanggera ning tanga mengne wa inga' amanga yapku'. ");
INSERT INTO uvh_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Ka kama nua'ni ganang ka Jisas wari arantagimni u ning yanggu', gwang fugung tubo do waraga' ubu mantam. Ning ina ning tanga arantagimni guk bot nua'ni ganang aranga mera Galili gwang ganang u mugoging. ");
INSERT INTO uvh_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Ka Jisas udi dama naknga bot furo'ning ganang unggung dama kuma' deku'. Ka adi gwang bining do kadofiinga gugubik kigineng wari kadofinga gwang u figikinga gwang sasabara girii wari marara abanga bot ganang u amanga toneinga bot wari gwang ganang u amoinga kabi'sini' kadaga tonga tiging. ");
INSERT INTO uvh_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Ka Jisas ning arantagim wari u kanga mutu tanga Jisas u tipseganga ning aniging, ai girii mamarak te', bibi' tonga tem yang. Ning tinga marara Jisas wari gugubik kigineng a gwang sasabara girii u midisa' ininga gugubik kigineng a gwang sasabara girii abugu' wari kaga'sa' biinga gwang wari kugurang gi'sa' ubu deiagu'. ");
INSERT INTO uvh_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Ning tanga Jisas wari arantagimni u ning yanggu', sidi nagata' naktangka tangkunang sini' mo' ba ting. Ka arantagimni adi Jisas wari napa' girii tugu' u kanga base tanga mutu tanga ai, ya nasi' aming. Adi gugubik a gwang udi midisa' ininga nakngamsa' tanga bibi'sa' ting. Ning tonga waraga' sasuk mimeng ko tanga mera aging. ");
INSERT INTO uvh_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Ning tanga bot ganang u mera anganga gwang fugung ka kama wap Gegesa ka Galili wara'ning tubo do ning tara' u kadofiging. Ka Gegesa wa aming arantagim nua'ni ka Juda mo' wara'sining kama u anga kadofiging. ");
INSERT INTO uvh_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Anga kadofinga ning tanga Jisas guk ka arantagimni guk wari bot u kabinga bemkura anga gaga u adeging. Ka kama tubo wara'ni yong aming nua'ni ka mini unggo kadagasi siamo' wari amanga magi tipipeinga fentarugu' wari Jisas ganang u abugu'. Aming ka wa yong guk mo' itarugu'. Adi magi pipenga fugu bi' sigesa' yangara anga kama ginang ka aming kungkumosi fonga iipmi ning wara'ganang dera base sa' bimanga fentarugu' wari abugu'. ");
INSERT INTO uvh_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","Ka adi bima tanga fentarugu' waraga' tanga fikifiki amine wari som tanga bema sen wari kayong kafong u kuma' tofitangkanga fagabiaging de, ka mokngang adi mini unggo kadagasini wari yotangkangaminga sen tangkunasi u udanga ning tanga base nagira auinga bimanga famarugu'. Ka Jisas wari u kanga aming wara'ning mini unggo kadagasi u ning yangkagaregu', sidi aming i kagabi tanga mugo tini'. Ning tuguinga aming wari ku bang katinga Jisas ning kayong ganang u mangfanga mungkupnanga dera midi bang ning togu', ai Jisas gu nasi' tanabonga abarang. Gu Anutu girii ning mindingni, o bibiri sini' gu napa' ni mo' tanabotang ning togu'. ");
INSERT INTO uvh_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Ka Jisas wari ning anigu', ka gu wapka wa nisi'. Ka adi mini unggo kadagasi siamo' guk waraga' tanga adibu ning anigu', naning wapna wa aming kure. ");
INSERT INTO uvh_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Ning tuguinga mini unggo kadagasi ka aming wara'ganang ikiaging wari Jisas u ning aniging, o gu kama kadagang sini' ganang mo' ningkarotang. ");
INSERT INTO uvh_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Ning tanga maga siamo' ka kama kagarangga' ganang do mininga fengaging u fonga yapma Jisas u ning anigaging, gu indibi sa' tinga indi aming i kabinga maga do wara'ganang anga amayapnam. Ning tuguinga Jisas wari aigaimsa' tanga ibiinga ");
INSERT INTO uvh_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","mini unggo kadagasi wari aming kabinga anga maga ganang ubu amayapking. Ning tinga maga wari uunak unara afanga sam kadagang ganang u tabasananga amanga gwang ganang apa mangfanga gwang u topnakadara wadigi' dabiksa' kumaksasu'neging. ");
INSERT INTO uvh_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Ka yong ki wara'ni aming fam ka magaa u yaptatoranga ikiaging wari napa' girii kadofigu' u kanga mutu tanga unara anga aming yong girii a yong kababi' fam u ina yareging. ");
INSERT INTO uvh_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Ning tinga yong aming wari u naknga napa' u kadidima sini' tonga marara abiging. Abanga kadofinga kaging ka aming magi pipenga fentarugu' udi Jisas wari mini unggo kadagasi u kuma' tanga igukngaminga magi tubobu natama ning tanga nip tamnanga Jisas ning kayong ganang unggung aming karengsa' ubu mareiagu'. U kanga ami taming wari mutu tiging. ");
INSERT INTO uvh_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Ning tinga aming fam ka unggung adenga Jisas wari aming u tipkarendagu' u kuma' kaging wari aming u napa' waraga' yangdidima sini' tanga yareging. ");
INSERT INTO uvh_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Ning tanga kama tubo Gegesa tara' wara'ning aming kabi'mo' wari Jisas wari napa' girii tugu' u kanga mutu tanga Jisas u ning aniging, ai mutu tem, indibi tanga mugo te'. Ning u napa'yanga anididenga anigareging. Ka Jisas guk ka arantagimni guk wari bot ganang u aranga tubobu mabonga tinga ");
INSERT INTO uvh_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","aming u tipkarendagu' wari Jisas yaranga kubap mabu ga' ning tonga Jisas anigu'. Ka Jisas wari ning anisefigu', mo' gu ingging yakangga' tubobu maya'. ");
INSERT INTO uvh_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","Anga ira napa' Anutu wari kareng tagamara' yaraga' ami taming fam u ina yarotang. Ning aniinga ninaksa' tanga ibinga yoringga' tubobu anga kama tubo wara'ning yong aming u midi ka Jisas wari napa' girii tangamgu' wara'ning u ina yareinga naksasu'neging. ");
INSERT INTO uvh_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Ka Jisas guk ka arantagimni guk wari gwang fugung kama tubo Galili tara' u tubobu abanga kadofiging. Ka yong aming kabi'mo' udi kapmefak tiging wara' adi Jisas wari tubobu kuma' abanga kadofigu' u kanga kabaksi' karengsa' nakngamging. ");
INSERT INTO uvh_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","42","Ka yong wara'ni aming girii nua'ni ka siring yak katatoranga itarugu' wapni Jairas wari adining ibingini kubaniksa' ka gurakni 12 ning wari bagana mamareng sini' ka kabi'sini' kungkumak titiga'sa' tugu'. U kanga tipkarendangam titiga' sura abanga Jisas ning kayong ganang u upma mera Jisas u ning anigu', o girii gu naganing yak ganang abanga yotangkanam te'. Ka Jisas wari adining midi u nakngam sa' tanga adining yak ganangga' yaranga agu'. Ning tinga aming kabi'mo' wari Jisas u yaranga anga bak girii tanga tipkagade sini' tang tanga aging. ");
INSERT INTO uvh_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Ka taming nua'ni ka bagana kadagang amaa so guk tanga itarugu' adindu' Jisas u kubap yaranga aging. Adi bagana kadagang wara'guk kama paramu' sini' ka gurak 12 ning ira karenda titiga' sura fikifiki dokta ganang anga uningkim mambong girii fagabarugu' de, ka mokngang karenda guk mo' tugu'. ");
INSERT INTO uvh_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Ka adi Jisas u kanga karenda titiga' sura aming bak girii tanga aging wara'ning mang ganang anga Jisas ning saket u kabi'ning kapmo'sa' tifemgu'. Ning tinga adining bagana kadagang amaa so tanga fentarugu' wari kaga'sa' bigu'. ");
INSERT INTO uvh_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Ka Jisas adi taming wari tifemgu' udi sireng urapsa' kuma' nakedagu'. Ning tanga faranga aming kabi'mo' bak girii tiging u ning yanggu', nisi' wari tifemnabara'. Ka aming adi mo' naga mo' naga mo' ning tonga yareging. Ka Pita wari ning anigu', a girii, aming kabi'mo' wari guganang bak girii ting wa kuma'sa' yabarang. Ka gu ni' wari tifemnabara' ning guk wa indining torang. ");
INSERT INTO uvh_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Ka Jisas wari ning togu', aming nua'ni wari tifemnabinga naganing tangkunangna dibing bira' udi kuma'sa' nakedarik. ");
INSERT INTO uvh_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Ning tinga taming ka titifem tugu' wari Jisas wari sirengsa' kuma' nakedanga togu' u naknga o kapmo' ning tonga tifemak udi kuma' ba naptuanga tora' ning tonga mutu tanga paparap senga abanga Jisas ning kayong ganang u upma mera aming ning dasi'ganang u sireng ning ituagu', o girii na bagana guk wara' na karenda titiga' sura tifemgabinga bagana wari kaga'sa' kuma' binabara'. ");
INSERT INTO uvh_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Ka Jisas wari ning anigu', kuyana gu mutu mo' totang. Gu naga girisa' gifikarenda ning ning napma tifemnabarang warisa' tanga wadigi' kuma' karendarang. Tubobu girisa' mautang. Anga kareng gi' ningsa' ubu itarotang ning anigu'. ");
INSERT INTO uvh_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Ka Jisas wari taming u midi ko aranigu' ganang ka aming nua'ni ka siring yak ning girii Jairas ning yak ganang wari abanga Jairas u ning anigu', guning yapka udi wadigi' kuma' kumata' wara' gu girii mo' anotang, kane girii mimbiring sige ma kabingame'. ");
INSERT INTO uvh_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Ka Jisas wari midi ka aming wari Jairas abanga anigu' u naknga Jairas u ning anigu', gu midi ka u naknga waraga' kabaka mamareng mimeng mo' nakotang, gu sasuk ka tim naga girisa' tipkarendagam ning sura abanga ninang unggungsa' suktangkaya', yapka udi tubobu kuma' marara kareng giri irota'. ");
INSERT INTO uvh_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Ning aninga anga Jairas ning yak ka taming kabasi' kumogu' ganang u kadofinga Jisas wari aming kabi'mo' yaranga fengaging wa fugang unggung yangsefiinga adeging. Ning tanga ananing arantagimni famineng ka Pita a Jon iguyangguk Jems ya a taming kabasi' wara'ning mengne bene unggungsa' inagira yak iyung bane u amoging. ");
INSERT INTO uvh_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Ka ami taming kabi'mo' udi taming kabasi' waraga' kabaksi' mamareng naknga mak mera fukoging. Ka Jisas wari u yapma ning yanggu', ai mak mo' kaknganting, taming kabasi' ya kungkumak wadigi' mo' tara' dama sa' deta'. ");
INSERT INTO uvh_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Ka adi kungkumak wadigi' tugu' udi kuma' kaging wara' adi Jisas ning midi u naknga kanggaga tanga anikige tiging. ");
INSERT INTO uvh_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Ning tanga Jisas wari iyung bane ka taming kabasi' kungkumong wari defagu' ganang u amanga kafong u suronga ning togu', ai sababa kabasi' gu mamarak te'. ");
INSERT INTO uvh_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Ning tuguinga uringni wari tubobu amoinga sababa kabasi' wari urapsa' maragu'. Ning tanga Jisas wari mengne bene u ning yanggu', nana tabanga amiinga nawa'. Ning ininga mengni wari nana tabanga amiinga nagu'. ");
INSERT INTO uvh_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Ka taming kabasi' wara'ning mengbe adi Jisas wari napa' girii tugu' u kanga base tanga sasuk mimeng tugumu'. Ning tanga Jisas wari yangsefi tangkunang ning tugu', ka sidi naga napa' i tinga kaing yaraga' wa aming mo' sini' yangting ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Ka Jisas wari arantagimni 12 u inagira fonga kukyapma tangkunang ka masi' unggo kadagasi tanga igukyam a bagana kuni' kuni' ifakarenda wara'ning u yamgu'. ");
INSERT INTO uvh_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Ning tanga kane ka aming wari Anutuning bining kareng ganang ikinga Anutu wari kafakafa tiap wara'ning midi kareng u ituaima yara a bagana aming ifimarak ning u tanga yangak waraga' yangkaronga midi yanggu'. ");
INSERT INTO uvh_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Ning yanggu', sidi napa' fuksi' yotangka ning ka tong a ari' girisi' a nana a uningkim mambong abanga kwi' a fuksi' tasase undu' fama' fama' mo' manggakanting, kubanik kabaniksa' ka fuksi'ganang kuma' ipmanga adeing ningsa' tananga mani'. ");
INSERT INTO uvh_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Anganga yong nua'ni ganang kadofiinga aming nua'ni wari adining yak ganang dek ga' saninga adigok deia' nua'ni ganang ubu au ning guk mo' tinting. Mokngang sidi yak ka tim kuma unda' anga dekanting wara'ganang ningsa' iya' mugo ning tinting. ");
INSERT INTO uvh_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Ka sidi i anga yong nua'ni ganang kadofiinga yong aming ka wari sidita' bibi' naknga kafakafa guk mo' tasabinga wa sidi yong ka wara'ganang guk mo' dekni', sidi kagabi sa' tanga anga kasi' susu difimiama ibinga mani'. Ning tinga adi u kanga ning toni', o indining kadagang sa' ba. Ning tonga inga' Anutu wari kagaya kabiam waraga' sura kabaksi' mamareng nakni'. ");
INSERT INTO uvh_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Jisas wari ning ina yangkareinga arantagimni wari yong yong u yangara Anutuning midi kareng ituaima yaranga a bagana aming ifakarendanga ning tanga ingaging. ");
INSERT INTO uvh_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","9","Ka aming fam wari midi ne ka Jisas wari kane tangkunasi kuni' kuni' tanga yangagu' wara'ning u naknga ning toging, o Jon Baptis urang kumogu' wari tubobu marara tanga abara', a fam ka profet Ilaija wari tubobu kadofinga tanga abara' ning toging. A aming fam ka profet girii timini nua'ni wari nua'bu marara tanga abara' ning tonga yareging. Ka Herot adi tim Jon Baptis wa kadare kuma' doptagagu' wara' adi midi ka aming wari toingaging u naknga a Jon Baptis wa naga ininga kadare kuma' urang doptagaging udi, a u abara' kanga toing wa nisi' ning tonga sasuk mimeng tanga Jisas u ananing de wari sini' ubu kadidima ga' suku'. ");
INSERT INTO uvh_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Ka Jisas ning aposel 12 ka tim Jisas wari kane anasapmo' tanga yangak ga' yangkaregu' wari kane u kuma' tasasu'nanga tubobu abanga kadofinga Jisas u midi ka adi kane tanga yangaging wara'ning u aninga yareging. Ning tanga Jisas wari arantagim 12 didimeng unggungsa' inagira kama bining ka Betsaida yong tara' waraga' ubu aging. ");
INSERT INTO uvh_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Ka aming arantagim girii wari Jisas se' wari mugoging u kuma' naknga marara mandang iwara anga yaptuaging. Ka Jisas adi u yapma yapgurida tanga yangkagare guk mo' tugu'. Mokngang adi kureng karengsa' abing ning tonga inagira fonga kukyapma ning tanga midi kareng ka aming wari Anutuning bining ganang iik wara'ning u ituaima yaranga a aming bagana guk u ifakarendanga ning tugu'. ");
INSERT INTO uvh_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Ka Jisas wari kane ka aming ga' midi ituaim a bagana aming ifimarak u ko fatinga kama kuma' kibiridagu'. Ka arantagimni wari u kanga Jisas u ning aniging, girii kama kuma' tara. Kama ka ya nana guk mokngang base sige urang wang wara' gu ami taming i yangkara tinga yongganang anga nana yapma nanga dekni'. ");
INSERT INTO uvh_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Ka Jisas wari ning yanggu', mo' nana wa sida yamni'. Ka arantagimni adibu ning toging, ai girii indi nana guk mokngang. Indi nana wa fama'sa' ka baret kababi' sini' ka faiv a ama ging kafo ka fama' ningsa' manggaram, ka wa aming arantagim girii ka ning yari nana ning guk mokngang sini'. Ma, adisita' nana toyamem ning tonga tanga uningkim mambong girii tipmiri ga' ning tonga ninarang wa. ");
INSERT INTO uvh_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Ka aming u abiging wara'sining nambasi' ka ami unggungsa' indangiking wa kabi' kabi'mo' arantagim girii sini' ka nambani faiv tausen ning wari kadofiging. Ning tanga Jisas wari arantagimni u ning yanggu', sidi aming do kidayapma bak kababi fifti fifti ning kukyabinga mera yarani'. ");
INSERT INTO uvh_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Ning ininga arantagimni wari aming u kidayapma yareinga bak kababi' kababi' kura mera yareging. ");
INSERT INTO uvh_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Ning tinga Jisas wari baret pumpungaresi kababi' sini' ka faiv a ama ging kafo undu' kababi' sini' ka fama'sa' u manggara adenga kunimganang kuta tarang degaranga Anutu animamangnegu'. Ning tanga arantagimni ga' upma iminga arantagimni wari manggara fonga aming wara'siga' sabaranga ima yareging. ");
INSERT INTO uvh_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Iminga aming kabi'mo' dabiksa' didimengsa' nibera dibing kunik girii ka iibi tiging. Ka Jisas ning arantagimni wari nana dibing nagaremira ibiging u manggara fonga bak kura unup ari' usap ka 12 ning dasitoneging. ");
INSERT INTO uvh_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Ka kama nua'ni ganang ka Jisas wari arantagimni u ibinga anapmo' dawang sasa'ning anga beni Anutuga' mesisiringa tanga ibang fatogu'. Ka arantagimni adi mandang inga' anga kaging. Ka Jisas wari ananing ki waraga' wa ning yangkagu', ka aming adi naga ya indining fanabing. ");
INSERT INTO uvh_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Ka arantagimni wari ning aniging, mo' wa aming fam ka Jon Baptis ning gapma fatoing a fam ka Ilaija wari tubobu abanga kane tangkunasi tara' ning fatoing a fam ka midi tokadofi aming profet timini nua'ni wari tubobu marara abara' ning fatoing ning aniging. ");
INSERT INTO uvh_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Ka Jisas wari yanggu', a sida wa indining fananing. Ka Pita wari ning anigu', mo' indi ning fagabem ka gu Anutuning Kasira Aming beng guk sini' ning anigu'. ");
INSERT INTO uvh_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Ka Jisas wari yangsefi tangkunang ning tugu', wap ka i toing ya aming fam guk mo' sini' yangting, sidasa' naknga ikni' ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Ka Jisas wari ning yanggu', beng sini' urang sanirik kadapmang ka Amingning Tim Iyak nagaganang kadofinam ning wa ning, inga' aming girisi a pris girisi a sasuk aming arantagim wari nagata' bibi' naknga manda uknama kadagang naramira nugumak tini'ga'. Ning tinga kama famineng ibinga Anutu wari tubobu nifimararo'ga'. ");
INSERT INTO uvh_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Ka Jisas wari ami taming u ning yanggu', aming ka naga nawara naganing kane tonga wa ananing sasukni u bema afasasu'nanga ning tanga nasi' mamareng ka aming fam wari naganing kane ga' tanga aminting u fikifiki kaba tiptangkanga bimbem sa' tanga nawara auta' wa giri. ");
INSERT INTO uvh_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Ka aming ka anata'sa' sura ananing iik wari kareng ningsa' ira au ga'sa' naknga ananing sasukni sa' yaranga irota' wa inga' adi kadaga to'ga'. A aming ka naganing kane ga'sa' sura adining iikni wa napa' sigening ning kanga nasi' mamareng girii u bimbem sa' tota' wa inga' adi gi' giri ira ka' iyak kareng ningsa' tanga awa'. ");
INSERT INTO uvh_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","A aming ka ananing iik kamaganangni u tiptangka waraga'sa' sura mambong kamaganangni kabi'mo' unggungsa' manggaknanga irota' wa inga' adi kungkumak tota' ganang wa nasi' wari yotangkangaminga ka' irota', mokngang adi kadaga titining sa'. ");
INSERT INTO uvh_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Abanga aming ka amine wari anikige titi waraga' sura nagata' bibi' naknga naganing midi kabinga sige irota' wa inga' Amingning Tim Iyak naga wap girii bema sibeng Anutuning tangkunang kigineng girii a adining kunung aming arantagim girii wara'guk kamaganangga' tubobu afok ganang wa nandu' adita' guk mo' naknga adining wap guk mo' towak. ");
INSERT INTO uvh_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Ka beng sini' urang sanirik, aming ka i adeing fam sidi ko mo' kumakni' ganang kama kareng ka aming wari Anutuning bining ganang iikning wari kadofisirenda sini' to' udi kuma'sa' kani'ga' ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Ka Jisas wari arantagimni midi u ina ning tanga iya' sande kubanik kabinga arantagimni famineng ka Pita a Jon iguyangguk Jems ya unggungsa' inagira ning tanga ibang tounga kama bubo ganang areging. ");
INSERT INTO uvh_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Aranga kadofinga Jisas wari ibang u aratuguinga nonda wari girigik tanga kuni' nua'ni sini' kadofigu'. Ning tinga kwi'ni undu' fafa' sini' fagagu'. ");
INSERT INTO uvh_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","31","Ning tinga aming timini fama' ka Moses guk ka Ilaija guk wari diok kigineng girii guk urapsa' kadofinga Jisas guk u adenga midi ka inga' Jisas wari Jerusalem yongganang anga Anutuning sasuksa' yaranga tanga kungkumak wara'ning u tonga naking. ");
INSERT INTO uvh_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Ka Pita se' adi dasi' dama naknga dama dekantam ning tonga aratiging ganang ka diok girii wari Jisas wari ibang fatogu' ganang do kadofigu' u kanga tong kaging wa aming fama' wari kadofinga Jisas guk dabik adenga midi aratoging. ");
INSERT INTO uvh_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Ning tanga aming fama' Moses guk ka Ilaija guk wari Jisas u kabinga mugo tonga tinga Pita wari Jisas u ning urapsa anigu', o girii indi gugok i arapmam wa karengsa' nakem wara' indi sidita' yak kababi' famineng masamtam, nua'ni ka guta' a nua'ni ka Moses ga' a nua'ni ka Ilaija ga' ning masamtam. Ka Pita adi kafakafa guk mo' naknga midi u sige urapsa' togu'. ");
INSERT INTO uvh_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Ka Pita wari midi u ko aratogu' ganang ka mungkong girii wari afanga tumukyapku'. Ka Pita se' adi u kanga mutu tiging. ");
INSERT INTO uvh_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Ning tanga naking wa midi nua'ni ka mungkong mang wara'ganang u ning kadofigu', aming ka u kaing wa naganing sabana, Adi naganing kane titi waraga' kuma' tipkasireguk wara' sidi adining midi wa nakngam sa' tinting ning togu'. ");
INSERT INTO uvh_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Ning tanga mungkong wari tarara' tanga sangangsa' adeinga kaging wa Jisas anapmo'sa' ubu adegu'. Ka Jisas ning arantagimni adi napa' u kaging waraga' wa aming fam urap mo' anga yangging, adi inga' sini' yangging. ");
INSERT INTO uvh_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Ning tanga kama bubo ganang unggung deia' tipfanga marara yongganangga' tubobu mafiging. Afanga kadofiinga aming kabi'mo' wari abanga Jisas ganang u bak girii tiging. ");
INSERT INTO uvh_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Ka aming nua'ni ka mindingni mini unggo kadagang guk wari Jisas u ning katinganggu', o girii gu naganing sabana i kaname', Na sabane mimeng mo' kubanik inggingsa' ");
INSERT INTO uvh_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","ka adi fikifiki mini unggo kadagang wari amanga taramikinga paparap senga ku katinga mini fe siamo' dinita'. Ning tanga tipkadaga sini' tanga anganga adi kabi'sini' wadigi' kungkumak ga'sa' yainga wara'ganangsa' kabita'. ");
INSERT INTO uvh_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Ka na tangkayongam titiga' ning tonga guning arantagim abanga yangak. Ka mokngang, adi tangkayongam guk mo' tinging. ");
INSERT INTO uvh_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Ka Jisas wari ning togu', a aming ka sidi kabaksi' a sasuksi' udi didimeng guk mokngang. Na sidigok ingging kama paramu' sini' kuma' ira tasama abirik, ka mokngang sidi Anutuning tangkunang ga' naktangka kabi'guk mo' ting sabarik. Ka sidi naktangka sini' wa dari tini'ga' ning yanggu'. Ning tanga saba kabasi' magi pipeng wara'ning beni u ning anigu', sabaga u nagiknam tanga abe'. ");
INSERT INTO uvh_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Ning aniinga saba kabasi' u nagira Jisas kaunga ko arabugumu'. Ka mini unggo kadagang wari saba u taramakinga saba wari kamaganang mangfanga girigiri' tiangagu'. Ka Jisas wari mini unggo kadagang u anikagarengama saba kabasi' u tipkarendanga ning tanga beni u ning anigu', girisa' kuma' tipkarendagamarik. Nagikna tanga mugo te'. Ning aniinga beni wari saba kabasi' u nagiknanga yaksingga' mugo tugumu'. ");
INSERT INTO uvh_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Ning tinga aming kabi'mo' adi Anutuning tangkunang u kanga base tanga sasuk mimeng tiging. Ka aming wari kane kiginesi ka Jisas wari tanga yaregu' u kanga waraga' base ko tanga adeging ka Jisas wari arantagimni u faranga yapma midi ka ana kungkumak ning waraga' nua'bu ning yanggu', ");
INSERT INTO uvh_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","ka sidi midi ka i toutik ya kafakafa nakni', inga' aming kamaganangni wari Amingning Tim Iyak naga bemnapma tonga amingga' yamni'ga' ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Ka arantagimni adi Jisas wari midi bupmosa' ka aming wari bimbem titiga' togu' u naknga midi wara'ning kiga' nafek tiging. Ka midi wara'ning ki wa Anutu ana tipfiferiam tugu' wara' adi nafek tiging. Ning tanga midi wara'ning kiga' Jisas u aniga ga' ning tonga suking ka kabibinga tanga anini guk mo' tiging. ");
INSERT INTO uvh_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Ka inga' Jisas ananing arantagimni wari adisining nua'ni wari tim iyak aming ira arantagim fam u yaptatora waraga' anasa' aroking. ");
INSERT INTO uvh_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Ka Jisas adi adisining sasuksi' u kuma' yapkedanga midi inonga saba kabasi' nua'ni u nagira tabanga kambiafinga ning tanga ");
INSERT INTO uvh_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","arantagimni u ning yanggu', ka ning sanotik aming wari tim iyak aming iik wara'ning kadapmang wa ning, aming ka nagata' naktangka tanga wa sababi' ka ningyara'siga' undu' naknga kafakafa sa' tiamting. A aming ka kafakafa ka sababi' ningyara'ga' tiamiting ningsa' Amingning Tim Iyak nagata' naknga tanamota' wa adi sibeng Anutu ka nangkara tinga afuguk waraga' guk tangamara'. Ka aming nua'ni wari tim iyak aming ning ira amine fam u yaptatoronga wa adi ananing kaba a sasukni u bema afanga amine fam ning kapmik ka saba kabasi' ningda'ning irota' wa Anutu wari adining bining ganang iikning aming girii ning kauta' ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Ka arantagimni nua'ni ka Jon wari Jisas u ning anigu', ai girii gam indi aming nua'ni ning kangam ka adi guning wap tonga aming fam ning masi' unggo kadagasi u tanga fiugukyama'. Ka adi guning arantagim sini' ka indi ningyara' mo' wara' indi mini unggo kadagasi guning wap ganang sige guk mo' tanga yugurota' ning tonga anisefi tangam. ");
INSERT INTO uvh_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Ka Jisas wari ning anigu', anisefi guk wa naga' tinging. Aming ka kane kareng ningwara' tinga wa kagabi sa' tinting, adi indining kane tipkadaga ning mo' wara' aming ka ningwara' wa indining amini' ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Ka kama ka Anutu wari Jisas u kunim ganangga' tubobu nagira ara wara'ning kama udi kuma' duduregu'. Wara' Jisas adi sasukni wari Jerusalem yongga' mugo ga'sa' tanga marara arantagimni u inagiknanga Jerusalem ga' mugoging. ");
INSERT INTO uvh_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Ka adi kadapmang nua'ni ka Sameria aming ning yongganang tara' ayaging u yaranga mugoging. Anganga Jisas wari Sameria yong ki u anga ininga nana a yak dekning u tugunungnanga ipmek waraga' sura arantagimni fam u Sameria yong nua'niga' tim yangkareinga aging. ");
INSERT INTO uvh_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Ka Jisas se' adi Juda aming'. Ka Sameria aming adi Juda guk bak kabi'guk mo' tiaging wara' adi Jisas se' wari Juda ning yong girii Jerusalem waraga' maunga mugoging u kuma' nakedanga kafakafa tiapma adisining yak ganang inagira fonga kukyabinga dek ga' bibi' nakyamging. ");
INSERT INTO uvh_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Ka Jisas ning arantagim iguyangguk fama' ka Jems ya Jon ya adi Sameria wari Jisas ga' bibi' naknga kafakafa guk mo' tiapking u kanga kabaksi' kadagang naknga Jisas u ning anigumu', ai girii adi kadagang ning indaramiking wara' indi Anutuga' ibang tuguinga Anutu wari kudip kamiaminga yong i wadigi' dasasu'no'. ");
INSERT INTO uvh_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Ka Jisas adi midi kigesini togumu' u naknga faranga yapma aming fama' u ifangyang tugu'. ");
INSERT INTO uvh_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Ning tanga yong ka wa tatarafik sa' tanga kabinga yong nua'niga' mugo tiging. ");
INSERT INTO uvh_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Ka Jisas se' wari kadapmang bining ko aramugoging ganang ka aming nua'ni wari kadofinga Jisas u ning anigu', i nake' na gugok kane kubap tanga yangak ga' nakarik. Gu yong fam ga' indeng autang wa nagok kubap sa' antam ning togu'. ");
INSERT INTO uvh_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Ka Jisas wari ning anigu', ka gu kuma'sa' nakedarang kugwang baseni wa dama dekning kama ginangsi' guk. Abanga yang undu' yorisi' guksa' yating. A Amingning Tim Iyak na mengkura kafakafa titining yak a dama dekning kama guk mokngang wara' gu naga nawuronga wa waraga' sura kafakafa nakedanga nawurotang ning anigu'. ");
INSERT INTO uvh_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Ning tanga kabi'ning nua'bu anganga aming nua'ni ubu katuaging. Katuanga Jisas wari ning anigu', gu nagok kane kubap tanga anam. Ka aming wari ning togu', we' girii una kuma' giwarotik. Ka na sibeng tangandang ga' tanga sutik wara' na tim ka u anga katatoranga tanga tanga adi kumoinga bema kamiinga inga' kuma' giwarok. ");
INSERT INTO uvh_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Ka Jisas wari ning anigu', a babangga tangandang unafarafi ga' torang wa amine ka kungkumak titiningsa' wari kuma' unafarafini'. A gu nagok abanga kane ka aming wari Anutuning bining ganang ikinga Anutu wari kafakafa tiap wara'ning midi kareng u ituaima yara wara'ning u tantamuk ning anigu'. ");
INSERT INTO uvh_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Ning tanga kabi'ning anga aming nua'ni nua'bu katuaging. Ka aming ka wari Jisas u kanga ning anigu', o girii nandu' gu gigiwak ga' nakarik de ka na tim ka tubobu anga naganing amine do yapma midi kafakafa yangdidimanga ning tanga inga' kuma' giwara awak. ");
INSERT INTO uvh_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Ka Jisas wari ning anigu', ka beng sini' aming ka ni kane nua'ni titiga' kuma' touta' ka adi napa' fam ga' ubu sura kane ka kuma' tota' u tangkabi tangkabi ningsa' tanga fauta' wa mokngang. Aming ka kadapmang ka ningwara' titing adi Anutuning arantagim sini' ira Anutuning bining ning kane kareng titining guk mokngang ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Ka Jisas wari yong girisi a yong kababi' fam ka inga' ana anga yangara kane tanga yara waraga' sura kane aming 72 ning u ifakasiringa fama' fama' sabarayapma tim yangkareinga yong kubanik kubanik tanga yareging. ");
INSERT INTO uvh_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ka adi kane aming u yangkaranga midi tipfara kabi' ning tiamgu', nana ka feng ganang kuma' kuraing wa kabi'mo' siamo' sini' ka indi nana u manggara yak ganang dadasi wara'ning kane aming mimeng guk mokngang. Wara' sidi feng tuang ga' ibang tonting. Ning tinga feng tuang wari kane aming fam nua'bu yangkarasaminga anga yotangkasapma nana kuru' u manggara bak kura yaranting. ");
INSERT INTO uvh_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Ning ina ning tanga ning yanggu', ka kane ka ya kabasi' mo' mamareng guk wara' na sidi sangkararik ya maga sipsip nano wari kugwang baseni kagaya guk wara'sining bining ganang anasapmo'sa' urang auinga dipmiting ningda'ning tanga sangkareinga anting. ");
INSERT INTO uvh_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Ka sidi fuksi' yotangka ning mambong ka ari' a kasi' giknim su a napa' mambong fam ningwara'guk mo' manggakanting, sigesa' mani'. Anganga aming fam kadapmang bining ganang yaptuanga wa sidi tingginge tanga adisigok midi guk mo' adenga tonting, mugosa' tinting. ");
INSERT INTO uvh_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Anganga yong nua'niganang kadofinga wa tim ka Anutu adi yong aming wara'siga' kaba kugurang iminga kafakafa tasap waraga' ibang kabi' ka o Anutu wari sidita' kaba kugurang samota' ning tonting. ");
INSERT INTO uvh_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Ka aming ka sasuk karesi guk adi sidining ibang kabi' u naknga wa adisigok unggung dek ga' sangsefinting wang. A aming ka sasuk karesi guk mokngang wa sidining midi waraga' bibi' nakanting. Ning tinga midi sidi tonting wari adisigok mo' yotangkayapma sidata' unggung tubobu abota'. ");
INSERT INTO uvh_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Abanga aming ka sidi manggaksap ga' kuma' aiganga sinagirota' wara'ganangsa' dek ning tinting. Sidi yak fam ganang mo' dera dera yangakanting. Ning tanga aming wari nana saminga wa sidi a indi kura' wa nasi' wari toyapmantam ning guk mo' sukanting. Mokngang kane aming wa toyap titining, ka sidi kane aming wara' adi nana u samting wa kane tinting wara'ning tosap ningda'ning tinting. ");
INSERT INTO uvh_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","9","Ka sidi yong girii nua'niganang anga kadofiinga aming fam wari nana ga' katisaninga wa sidi anga nana u nua'ni kanga igarang mo' tinting. Mokngang sidi nanasa' tinting. Ning tanga sidibu undu' yotangkayap tanga adisining bagana aming u ifakarendaima ning tanga ning yangting, kama ka aming wari Anutuning bining ganang iikning wari kadofisam wara'ning wa kuma' kadofonga tara' yang. ");
INSERT INTO uvh_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","A sidi anga yong girii nua'niganang kadofiinga yong wara'ning aming wari sidita' bibi' nakinga wa sidi adisining dasi'ganang unggung adenga midi sireng ning yangting, ");
INSERT INTO uvh_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","kama kareng ka aming wari Anutuning bining ganang iik wara'ning wa kuma' kadofonga tara'. Ka sidi indita' bibi' nakniming wara' indi kadapmang udanga wadigi' sibing maunga kani' susu difimisamem yang. Ning ina ning tanga kasi' giknim su u kifinga manggara yong wara'ning kama susu u difimiama ibing mugo tinting. ");
INSERT INTO uvh_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Ka beng sini' sanirik, inga' Anutu wari aming tagagareyabo' ganang wa yong ka midi karangkang titisi ningwara' wa Anutu wari mamareng girii sini' kabiamo'ga'. Mamareng girii ka u bemni' wa mamareng ka tim aming ka yong kadagang Sodom ganang ikiaging wari bemni' u tarafaro'ga' ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Ka Jisas wari yong fam ka adining midi ninak ga' bibi' fanakiaging waraga' ning togu', ka yong fama' ka Korasin guk ka Betsaida guk sidi aming midi tarakayo tuang beng sini' iking wara' sidi inga' mamareng girii sini' bemni'ga'. Na kane tangkunasi kuni' kuni' Juda aming sidining dasi'ganang kabi'mo' kuma' tanga abarik. Ka mokngang sidi napa' sigening ningda'ning kanga kabaksi' mo' faranga bibi' naknga fengaking. A naga kane tangkunasi kuni' kuni' ka sidita' i fatasamirik ning i tim ka aming arantagim nua'ni Juda mo' ka yong fama' ka Taia guk ka Saidon guk wara'siga' anga tiamonga tuguk wa adi kabaksi' timinggi' kuma' faronga tiging. Ning tanga adi adisining kadagang waraga' sura megang naknga fuksi' kwip sufurunga ning tanga kwi' babam kadagasi tama marafakianing. A sidi ya ning guk mo' ting sabarik. ");
INSERT INTO uvh_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Wara' ning torik, inga' Anutu wari aming tagagareyabo' ganang wa adi sidita' mamareng girii sini' samo'ga'. Beng sini' mamareng ka sidi bemni' wa mamareng ka yong fama' Saidon guk ka Taia guk wari bemni' u tarafaro'ga'. ");
INSERT INTO uvh_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ka Kapaneam aming sidindu' ningsa'. Sidi aming karesi ning tonga sidining wap bema aranga a indi kunim yongganang maranam ga ning fatoing. Ka ning sanotik, mokngang sini' sidi kudip kadagang ganangsa' mamasasu'nani'ga' ning togu'. ");
INSERT INTO uvh_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Ning tanga Jisas wari kane aming 72 u ning yanggu', aming ka sidining midi ninak sa' tinting wa naganing midi naking. A aming ka sidining midi ninak ga' bibi' naknga sidita' manda uksamting wa nagata' manda uknama ning tanga sibeng ka nangkara tinga afuguk waraga' undu' ukngaming. Ning yangkareinga aging. ");
INSERT INTO uvh_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Ning tanga kane aming 72 ning ka Jisas wari fama' fama' yangkaregu' wari kane u kuma' yangara tasasu'nanga tubobu abanga kadofinga kane tiging waraga' kabaksi' karengsa' naknga Jisas u ning aniging, o girii indi masi' unggo kadagasi tanga yuguronga guning wap fatoyam una. Adi naknim sa' tanga aming u ibinga mugoinga aming wari tubobu kaga'sa' fakarending. ");
INSERT INTO uvh_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Ka Jisas wari adisining midi u naknga ning yanggu', sidi mini unggo kadagasi u tanga igukinga aming kadagang Setan ning tangkunang wari tifik da'ning tanga sirengsa' mangfugu' udi kuma' kaguk. ");
INSERT INTO uvh_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Ka beng sini' na sidita' tangkunang fam undu' kuma' samguk wara' sidi nasi' kagaya ka gimik a siknanggik abanga napa' kagaya fam ka aming kadagang Setan wari sidi sifikadaga ga' ning tonga saramikota' u tarakayo wara'ning tang guk ubu kuma' iking. Wara' sidi kagaya ni bimbem ning guk mokngang. ");
INSERT INTO uvh_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Ka sidi masi' unggo kadagasi wari sidining midi naksam sa' ting u yapma waraga' kabaksi' karengsa' udi giri naknga toing. Ka ning sanotik, sidi kabaksi' kareng girii sini' wa sidi nagata' naktangka tinga Anutu wari sidi adining arantagim ning kuma' sabara' waraga' naknga fikifiki Anutuga' mesisiringa sa' tanga ikianting ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Ning tanga Anutuning mini unggo wari Jisas ganang amatoneinga Jisas wari kaba karengsa' naknga mesisiringa tanga Anutuga' animamangna ning tugu', o beng sini' sibeng gu kunim a kama wara'ning girii ka gu guning sasuk kareng wa sasuk aming ga' mo' imarang. Gu aming sige ga' imarang wara' na waraga' sura guta' mesisiringa tagama asekna ning torik. Ka gu u taranga wa sigesa' mo' tarang. Mokngang gu kuma' nakedanga didimengsa' tarang ning togu'. ");
INSERT INTO uvh_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Ka Jisas wari ibang u tonga biinga ning tanga aming u ning yanggu', ka na sibeng Anutu wari napa' napa' yaptatora waraga' kuma' nipmigu' ka aming adi Anutuning mindingni naganing ki sini' guk mo' fanakeding. Mokngang sibeng anapmo'sa' wa giri nakedanga ita'. Abanga adi sibeng ning iik wara'ning ki undu' nakeda guk mo' ting. Mindingni nagasa' wa giri naknga itik abanga aming ka mindingni naga kuma' yangtintingneinga naking adindu' sibeng ning iik u nakeding. ");
INSERT INTO uvh_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Ning tanga ananing arantagimni 12 u ning yanggu', ka sidi kane ka kami yara'ganang naga tinga kaing a midi ka naga tuguinga naking wa napa' girii sini' kadofiinga kaing. ");
INSERT INTO uvh_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Beng sini' tim profet a aming girisi king arantagim kabi'mo' adi napa' ka sidita' i tasaminga kaing a midi karesi ka i saninga naking i kaga a ninak waraga'sa' naknga ira abiging. Ka mokngang kaga guk mo' tiging. Ka kami yara'ganangsa' kadofiinga sidisa' kaing ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Ka Juda ning sasuk aming nua'ni wari Jisas u taramikonga abanga Jisas u ning anigagu', tisa na nasi' tanga ka' iik fikifiki ningsa' tanga irotik. ");
INSERT INTO uvh_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Ka Jisas wari ning anigu', a gu ka' iikning midi ka tim umpang ganang kuma' yoking wa indining indangira nakitang. ");
INSERT INTO uvh_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Ka sasuk aming wari ning togu', mo' wa ning yoking, gu Anutu girii ga' wa uriga a tangkunangga a sasuka ganang sini' kufara nakotang. Ning tanga aming fam ga' undu' kabaka guk siamo' naknga kafakafa ka ganing fuka yotangka ga' titang ningsa' tanga yotangkangamotang ning yoking ning togu'. ");
INSERT INTO uvh_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Ka Jisas wari ning anigu', weng midi ka u torang wa didimengsa' beng guk torang wara' gu midi ka unggungsa' yaranga totang wa ka' iyak kareng bema irotang. ");
INSERT INTO uvh_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Ka sasuk aming adi aming fam wari kadapmang ka u kuma' yaranga didimeng giri ba tanga ikita' ning kaga waraga' sura Jisas u nua'bu ning anigagu', ka midi ka aming fam ga' kafakafa tiamotang ning yoking wa nisi' aming ga' sura yoking. ");
INSERT INTO uvh_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Ka Jisas wari midi u sura nakeda waraga' midi tipfara nua'ni ka ning tangamgu'. Wa ning, Juda aming nua'ni wari Jerusalem yong u kabinga Jeriko yongga' mamota'. Ka kadapmang bining ganang ka kubu aming wari kadofinga aming u ukadanga kufara ning tanga kwi'ni mambong u iromanggaknanga kabinga mugoinga adi anapmo'sa' unggung kumaronga tanga defarota'. ");
INSERT INTO uvh_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Ka wara'ganang ka Juda ning pris nua'ni adindu' kadapmang ka unggung mandang yaranga amota'. Amanga aming ura kufara manting u katuanga de wari ningsa' tong kanga gagaga sa' tarafira kabinga mamota'. ");
INSERT INTO uvh_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Ka Livai arantagimni aming nua'ni ka siring yak giri tempel kane tota' undu' inga' mandang amota'. Amanga aming ura kufakanting u katuanga undu' ningsa' tota'. Adi de warisa' kanga gagaga sa' tarafira anga mugo tota'. ");
INSERT INTO uvh_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Ka Sameriani aming ka Juda wari yapgurada titing wara'ning nua'ni wari mandang inga' amota'. Amanga aming ura kufakanting u kanga bibiri' kauta'. ");
INSERT INTO uvh_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Ning tanga aming wara'ganang didimeng anga dongkini u kabinga bemkura amanga kafakafa tangama ananing wel marasin guk ka wain ama guk u manggara uuk tinting wara'ning gipmam ganang u ipmangama yaranga tumukngam tanga ning tota'. Ning tanga bema ananing dongki ganang u kaminga nagira anganga yongganang do kadofota'. Ning tanga yong wara'ning narum yak nua'niganang tonga kaminga nana fam tonga aminga ning tanga kafakafa katatoranga unggung tonga kamiinga derota'. ");
INSERT INTO uvh_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Deia' marara ning tanga yak wara'ning tuang ga' uningkim mambong dandameng aminga ning anota', aming i kafakafa katatora waraga' gamirik. Na mugo tirik, ka gu aming i yotangka ga' tanga guning uningkim mambong fam udep kabotang wa naga tubobu abanga ganang kura'bu kuma' gamok, ning anota'. Ka Sameria aming adi kadapmang kareng kuni' kuni' ka ning u tangamota'. ");
INSERT INTO uvh_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Ka Jisas wari midi u aninga anganga ning tanga Juda ning sasuk aming u ning anigu', ka gu indining nakarang nisi' wari aming uuk tiging u amingni sini' ningda'ning kanga yotangkauta'. ");
INSERT INTO uvh_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Ka sasuk aming adibu ning togu', mo' adining amingni sini' ningda'ning wa aming ka bibiri' kanga yotangkangam tota' wang. Ka Jisas wari ning anigu', beng guksa' torang. Ka gundu' kadapmang kareng ka adi u tota' ningsa' tanga aming kuni' kuni' yotangkayabotang ning anigu'. ");
INSERT INTO uvh_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Ka Jisas guk ka arantagimni guk adi kadak ka u mugoging wa anganga yong nua'ni ka taming fama' iguyangguk Mata ya Maria ya wari ikiagumu' ganang u kadofiging. Ka Mata wari Jisas ga' kafakafa tangama adining yak ganangga' nagira agu'. ");
INSERT INTO uvh_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Tonga kaminga ning tanga adi nana tugunung kane fatugu'. A kuyangni Maria adi Jisas ganang unggung abanga mera Jisas wari midi fatogu' u kafakafa mera fanaku'. ");
INSERT INTO uvh_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Ka Mata adi nana kane tanga Jisas ning midi u kafakafa mo' naku'. Ning tanga kane u tanga anganga inga' kuyangni Mata ga' kaba mamareng kabi' naknga Jisas u ning anigu', ai girii Maria u kaya' yotangkanam guk mo' tara'. Ka gu anini tinga abanga yotangkanam to'. ");
INSERT INTO uvh_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Ka Jisas wari ning anigu', ka Mata gu sasuk mimeng ka napa' fam ga'sa' tanga kane kareng sini' nua'ni waraga' guk mo' sutang gabarik. ");
INSERT INTO uvh_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","A kuyaga Maria adi kane kareng ka waraga' naganing midi mera fanakara' wara' na adi naning midi u ninak waraga' kadapmang mo' udangamotik ning anigu'. ");
INSERT INTO uvh_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Ka Jisas wari ibang tounga arantagimni u inagira ning tanga kama dawangsa' anga beni Anutuga' ibang fatogu'. Adi ibang u tonga biinga arantagimni nua'ni wari Jisas u ning anigu', girii gam, Jon Baptis adi arantagimni wa ibang tutugu ning kadapmang kafakafa kuma' yangdidimagu'. Ka indindu' gu ibang tutugu ning kadapmang didimeng u ningdidima ga' nakem ning anigu'. ");
INSERT INTO uvh_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Ka Jisas wari ning yanggu', sidi ibang tounga wa ibang ning kadapmang didimeng nua'ni ka naga i sanggerotik i yaranga toyanting. Wa ning, o sibengni' girii kunimganang ikitang aming indi guning wap girii wa kareng naro'sa' ning kantam. Iik didimeng kareng ka guning bining ganang iikning unggungsa' tipkadofinimotang. Kunim aming wari guning midi nakam sa' titing ningsa' ka aming kamaganangni indindu' ai'sa' tagamtam. ");
INSERT INTO uvh_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Gusa' nana a nasi' kami ning didimengsa' nimotang. ");
INSERT INTO uvh_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Aming wari indita' kadagang tinimging u kuma' tipdidimem ka sibeng gu indining kadagang u suknakubenim totang. Gu napa' ka kadaga titiga' kigineng sini' indiramik ning wa kagabi sa' mo' tinga indiramikota'. ");
INSERT INTO uvh_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","6","Ibang u yanggera ning tanga ning yanggu', ibang ka Anutu wari napa'ni sansam ga' sura tutugu wara'ning wa kadapmang ka aming nua'ni wari amine wari dama kuma' dekinga tiim bining sini' ganang abanga kadofinga faba kadakngam ga' urang katiting ningda'ning. Wa ning, aming nua'ni wari amine yabonga abanga amingni nua'ni ganang tiim bining sini' kadofota'. Ka amingni wari u kanga nana amimi ga' ning tonga surota'. Ka adindu' nana guk mokngang waraga' tanga adi kuyangni nua'ni ning yak ganang anga dama kuma' derota' u tipseganga ning anota', ai kuyana indining amini' nua'ni abara' ka na nana guk mokngang wara' gu gabonga abarik yang. Ka gu nana ka ni bemname' sangam totik. ");
INSERT INTO uvh_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Ka kuyangni adi dama kuma' derota' wara' adi gurudang naknga ning anota', a kureng tiim guk wa nasi'ga' tonga fentang, kamindapsa' inga' kuma' sangamtam. Taming sababi' dama kuma' deking. Abanga nandu' dama detik a faba undu' kuma' isefingak. ");
INSERT INTO uvh_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Ka kuyangni adi amisi' wari kama kamani abanga segi kagaya nakota' waraga' sura kuyangni nua'ni wara'ning midi u nakngam guk mo' tanga mimeng sini' anidideuta'. Ning tinga kuyangni ka dama derota' adi kuyangni wari midi mimeng tonga dama daguguru taramarota' waraga' tanga inga' aigangam ubu tanga nana u bemamota'. Ka kuyangni adi o wa kuyani' yotangka ga' ba abanga tora' ning sura mo' bemamota'. Mokngang adi kuyangni wari midi mimeng tonga dama daguguru taramarota' waraga'sa' tanga marara amimi sa' tota' ning titing. ");
INSERT INTO uvh_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Ka beng sini' kadapmang ka Anutu wari yotangkasap tanga kadapmang karesi fam tasam waraga' ibang tutugu ning undu' ningsa' wara' sidi Anutu wari kadapmang kareng ka ni sangtintingna ga' sura aniganting wa Anutu adi kuma'sa' sangtintingnota'. Abanga adining sasuk waraga' wena ningda'ning tinting undu' Anutu adi kuma'sa' sangtintingneinga kanting. A sidi Anutu guk ngingeng kareng ning iikga' naknga adita' ibang ka faba ukngam ning ningda'ning aniganting wa adi kadapmang kuma'sa' tasaminga adigok ikanting. ");
INSERT INTO uvh_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Ka wa beng sini' urang torik, aming dabiksa' ka Anutu wari napa' ni iyam ga' sura kabaksi' kubaniksa' sura tonting wa ma adining sasuk kareng ga' wena tinting a adigok iikga' ibang ka faba kadakyam ga' ningda'ning katingangting wa Anutu adi nakyam sa' tanga kuma'sa' tiamota'. ");
INSERT INTO uvh_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Ka sidi kadapmang ka sidaning sabase ga' tiamting waraga' sukni'. Indining, sidi sabase wari keng ama ging iyam ga' saninga wa sidi mandaga' iramira napa' ka nana titining guk mokngang gimik u imiting. Mokngang. ");
INSERT INTO uvh_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Abanga adi kagare' mindip iyam ga' tuguinga wa sidi napa' kagaya guk siknanggik uba bema imiting. Mokngang sidi napa' kareng ka adi iyam ga' sura saniting unggung didimengsa' iminga nating. ");
INSERT INTO uvh_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Ka aming kamaganangni sansaramik adi' sidi sabase ga' kadapmang kareng ka ning u tiamiting. A babangsi' girii ka kunimganang ikita' adi ai'dap ning ki sini' wara' adi aming ka adita' ibang tonting waraga' napa' kigineng sini' ka adining mini unggo u imota' ning tita' ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Ka kama nua'ni ganang ka Jisas wari aming nua'ni ka mini unggo kadagang guk midi map fentarugu' u kanga aming wara'ning mini unggo kadagang u tanga kayongama tipkarendainga midi kaga'sa' togu'. Ka ami taming adi Jisas ning kane kigineng u mamaram sa' kanga base tiging. ");
INSERT INTO uvh_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Ka aming fam adi anikige tanga a indi kuma' kayam idi masi' unggo kadagasi ning girisi' Bielsebul ning tangkunang warisa' tanga tara' ning toging. ");
INSERT INTO uvh_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Ka aming fam ka anikige tiging adi Jisas wari fe' titi waraga' sura mandaga' taramikonga kane tangkunang nua'ni ubu titiga' aniging. Ning aniging, indi gu kane tangkunang nua'bu tinga kanga wa o Anutu wari adiganang beng sini' ita' ning tontam ning aniging. ");
INSERT INTO uvh_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","18","Ka Jisas adi adisining sasuksi' mandaga' u kuma' yapkedanga ning yanggu', a sidi Bielsebul ning tangkunang wari tanga tirik ning ba toing. Ka waraga' wa ning toutik, aming dabiksa' ka gavman nua'ni ning kapmik ganang ikanting wari tubo kidagang tanga arantagim fama' ikanting wa adisining gavman undu' tang guk mo' ira kadaga tota'. Abanga aming arantagim ka ana kurene ning ikanting wara'ganang undu' ningsa', adi gi'sa' ikanting wa kigineng guk. A arantagim wari tubo kidagang tanga arantagim fama' ning ikanting wa adisining tangkunang undu' bibi' tinga kadaga tinting. Ka aming kadagang Setan ning arantagim undu' ningsa', adi anasa' tubo kidagang tanga marara fam ka mini unggo kadagasi u yotangkayap ga' tinting a fam ka mini unggo kadagasi u tanga yuguk ning kane tinting ning guk mo' titing, mokngang. ");
INSERT INTO uvh_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Abanga sidi sidining amise fam ka kane ka masi' unggo kadagasi tanga yugukiting waraga' sukni'. Adi nisi'ning wap kigineng tonga titing. Mokngang adi Anutuning wapsa' tonga titing. Wara' sidi u kanga ning nakedanting, o indi midi ka Bielsebul ning tangkunang wari tanga tara' ning toyam wa beng guk mokngang ning tonting. ");
INSERT INTO uvh_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Ka naga mini unggo kadagang tanga fiugukitik wa Anutu girii wari yotangkanabinga adining tangkunang warisa' fiugukitik wara' na ning torik, Anutuning bining ning kigineng wa kuma' kadofiinga kaing yang. ");
INSERT INTO uvh_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Ka waraga' wa midi nua'ni ka ning toutik. Ning, aming kigineng nua'ni ka adi mambongni kiginesi u manggara fabanga yoring ganang u dasinga ning tanga fikifiki suguk kwak tanga kigineng guk ningsa' ira auta'. ");
INSERT INTO uvh_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Ka inga' aming nua'ni ka tangkunangni girii guk kigineng sini' wari ubu kadofota'. Kadofinga aming wara'guk ami' tanga aming u ura adining tangkunangni u tipmiringama ning tanga suguk kwak ka adi adining tangkunangni ning yapdamdanga tanga irota' u iromkadara manggarota'. Ning tanga adining mambongni kiginesi fam undu' dabiksa' manggara arantagimni ga' sabaraimota'. ");
INSERT INTO uvh_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Ka beng sini' aming ka nagok dabik adenga yotangkanap mo' tota' wa naganing digirap ning irota'. Abanga aming ka sipsip bak fabang kukyap ning kane ka nagok dabik mo' tantamuk wa adi sipsip u iramira yubusara wara'ning aming ning ita'. ");
INSERT INTO uvh_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Ka Jisas wari masi' unggo kadagasi waraga' nua'bu ning yanggu', kadapmang ka masi' unggo kadagasi wari aming ganang ikiting wara'ning wa ning. Tim mini unggo kadagang wari aming nua'ni ganang irota'. Ka inga' aming nua'ni wari anikagare tota'. Ning tinga mini unggo kadagang adi aming u kabinga kama nua'ni ganang anga aming nua'ni ganang iikga' ning tonga wenota'. Ka mokngang, kama ka wa kadagang. Adi yong iikning guk mokngang u kanga ning surota', a na yong ikinga nangkagareging ka tim urang tubobu unda' anga kautik. ");
INSERT INTO uvh_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Ning tonga tubobu abanga kauta' ka yak ka tim adi iya' kabinga mauta' udi kafakafa kuma' sumunga tipgidabanga kabinga fideuta'. ");
INSERT INTO uvh_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","U kanga ningsa' kabinga masi' unggo kadagasi amine seven ning ka kadapmangsi' kadagasi sini' ubu inagiknonga tubobu mauta'. Anga inagira abanga aming wara'ning kaba ganang nua'bu amanga ikanting. Ka aming ka wa tim mini unggo kadagang kubaniksa' wari irota' ganang wa kadagang kabi'sa' tota'. Ka inga' wa kadapmang kadagang sini' ubu tanga irota', ning togu' Jisas wari. ");
INSERT INTO uvh_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Ka ami taming kabi'mo' adindu' bak abanga kura Jisas ning midi u mera fanaking. Ka Jisas wari midi u tonga biinga taming nua'ni wari Jisas ning midi waraga' kaba karengsa' naknga ku ning katigu', o gu aming kareng, ka guning mamangga gigibe tugu' adi guning kadapmang kareng waraga' sura kaba karengsa' naknga mesisiringa sa' tota'. ");
INSERT INTO uvh_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Ka Jisas wari ning togu', mokngang nagata' kaba kareng ninak ning wa naganing simeng ninibe tugu' warisa' mo' nakota', wa aming ka Anutuning midi kareng naknga yara sini' tinting adindu' nagata' kabaksi' kareng naknga mesisiringa sa' tanga ikanting ning togu'. ");
INSERT INTO uvh_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Ka ami taming kabi'mo' wari Jisas wari kane tangkunang u nua'bu tiaminga kaga waraga' sura anga adiganang u bak girii nua'bu tiging. Ka Jisas wari adisining kabaksi' u kuma' yapkedanga ning yanggu', o aming kamaganangni sidining kadapmang wa kadagang karik. Sidi sasuk ka Anutu wari kane tangkunang dasi'ganang sireng sini' tinga kanga o beng sini' Anutu wari indita' naknga tinimara' ning tutugu waraga'sa' tanga nawara abing sabarik. Ka ning sanotik, na kane tangkunang ni nua'bu guk mo' totik, mokngang. Ka na kane tangkunang ka tim profet Jona wari tugu' unggungsa' wa giri tipkadofisaminga kani'ga'. ");
INSERT INTO uvh_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Ka kane tangkunang ka wa tim Jona wari Niniva yong u tanga yangtintingneinga aming wari kudi ka u kanga Anutuga' tubobu urang suking ningsa' ka inga' yara'ganang undu' Amingning Tim Iyak naga tinga kanga aming wari Anutuga' tubobu sukni'ga'. ");
INSERT INTO uvh_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Ka kadapmang ka midi ninaksa' titi wara'ning wa tim kwin taming girii ka kama tubo saut tara' u katatoranga itarugu' wari king Solomon ning sasuk kareng wara'ning midi ne u naknga abangka tonga kamani sini' unggung marara kane girii tanga abugu'. Ka inga' yara'ganang undu' aming nua'ni ka sasukni kareng sini' guk ka Solomon ning sasuk u tarafita' wari sidining bining ganang kuma' abanga ita'. Ka sidi adining midi ninak ga' bibi' naking, wara' inga' kama ka Anutu wari aming midiganang kukyapma tagagareyap to' ganang wa kwin taming wara'ning kadapmang kareng wari sidining kadagang u tipkadofisamo'ga'. ");
INSERT INTO uvh_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Abanga aming ka tim Niniva yong u ikiaging adindu' profet Jona ning midi u naknga kabaksi' fareging. Ka beng sini' aming nua'ni ka adining sasukni kareng wari Jona tarafita' wari sidigok ingging kuma' ita'. Ka mokngang, sidi adining midi ninak guk mo' ting wara' kama ka Anutu wari aming midiganang kukyapma tagagareyabo' ganang wa Niniva aming ning kadapmang kareng wari sidining kadagang u tipkadofisamo'ga'. ");
INSERT INTO uvh_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Ka beng sini' aming wari kamang gareting wa adi garinga kapmo' sepma napa' ni wari tungkum mo' titing. Mokngang adi kamang u garinga bema furo'ning tabinga aming ka yak iyung u amoting wari sirengsa' desangandanga marekiting. ");
INSERT INTO uvh_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Ka aming ning de undu' ningsa'. De wa aming fugu a uringni wara'ning kamang diok ning ikita' wara' aming ka deni kareng guk irota' wa adi fuguni a uringni undu' karengsa' irota'. A de wari kadaga tota' wa aming ning fugu undu' kadaga tanga tangkunang guk mokngang ning irota'. ");
INSERT INTO uvh_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Ka aming sidi sasuksi' kareng ka kamang diok sangang ningda'ning u kafakafa katatoranting. Sasuksi' kareng ka kabaksi' ganang wari kadaga tinga sasuk kadagang guk gaa' kangkam ma ikni'. ");
INSERT INTO uvh_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","A sidi sasuksi' kareng ka diok da'ning u kafakafa katatoreinga sidining kabaksi' ganang u to'na sini' tanga irota' wa karengsa'. Sasuk kadagang ka kama kangkam da'ning wari sasuk kareng ka u tipkadaga ning kama guk mokngang. Beng sini' sidi kadapmang ka u torik ning u tanga ikanting wa sasuk kareng guk giri ira diok kigineng guk ning ikanting. ");
INSERT INTO uvh_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Ka Jisas wari midi ka u tonga biinga Farisi arantagim ning aming nua'ni wari Jisas u adining yak ganang adigok nana angana ga' anigu'. Ning tinga Jisas wari anga adining yak ganang u amanga adigok nana u mera naging. ");
INSERT INTO uvh_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Ka Jisas adi Juda ning kadapmang tapni fam ka nana tanga niaging u yaranga tanga kafong guk mo' yotira nagu'. Ka Farisi arantagim ning aming ka wari u kanga kigesini ning kanga sukadangam kabi' tanga mareiagu'. ");
INSERT INTO uvh_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Ka Jisas wari aming wara'ning sasukni u kuma' kigedanga midi kigineng ning anigu', ai Farisi arantagim sidi kadapmang tapni tang ka napa' fuksi' using ningsa' ka gafa wa ma sungkwang ning u yotik waraga' wa kigineng sini' giri tanga ikiting. A sidining kabaksi' mang ganang wa kadagang girii ka sasuk kadagang a aming nua'ni tipkadaga ga' sasuk ningwari to'na sini' tanga fata'. ");
INSERT INTO uvh_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Sidi aming masi' pipesi beng sini'. Anutu adi napa' kababi' fugang ning ka fukni' yaptatora ning unggungsa' kamigu' wara' sidi sasuk mimeng ka waraga'sa' fating. Mokngang, Anutu adi napa' girii sini' wa aming ning kaba u tugu'. Ka sidi waraga' sura kabaksi' u kafakafa katatoranga ikanting. ");
INSERT INTO uvh_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Ning tanga napa' karesi fam ka sidiganang iking u manggara amise fam ka napa'ga' nafek tanga tatafak ikiting wara'siga' ima yotangkayapmanting wa napa' isiotik titing wa beng guk ning tinting. ");
INSERT INTO uvh_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Ka beng sini' sanarik inga' Farisi arantagim sidi sidining kadagang waraga' mamareng bemni'ga'. Sidi sidining kadapmang tapni ka Anutuga' sura adita' napa' amimi ning u yaranga didik a napa' kababi'sini' karesi fam dabiksa' wa ni ka kagabi guk mo' titing, mokngang, didimengsa' udanga kukngamiting. Sidi ning wa giri titing ka sidi napa' girii sini' ka aming fam ga' kadapmang didimeng tiam a kadapmang ka Anutuga' siamo' beng guk sini' ninak ning wa kagabi fating. A sidi kadapmang ka wara'guk dabik tianing ganang wa giri Anutu wari didimengsa' ning karo'. ");
INSERT INTO uvh_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Abanga Farisi sidi kadapmang kadagang nua'ni ka ning fatiting, sidi aming arantagim wari aming girisi karesi ning sasap waraga' sura siring yak ganang amanga wa sidi fuksi' bema aranga tare karesi ka aming girisi wari mimek ning wara'ganangsa' marekiting. A kama ka aming wari bak titing ganang undu' ningsa' titing. Sidi ami taming wari sapma o aming girii ba ning tutugu waraga' sura sirengsa' arengating. Ka sidi kadapmang kadagang ka u titing waraga' wa inga' mamareng girii bemni'ga'. ");
INSERT INTO uvh_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Ka Farisi sidi kafakafa naknga tinting. Sidi kadapmang ka fuksi' bema ara ning u fating wa aming kungkumong ka kwang ganang mang apa kubudanga fainga aming wari iyap guk mo' tanga kusik using urang tipminga ingating ningda'ning tanga iking. Ka inga' sidi wara'ning mamareng girii bemni'ga' ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Ka Juda ning kadapmang tang ning sasuk aming nua'ni wari Jisas wari midi kigineng sini' yanggu' u naknga Jisas u ning anigu', o gu midi mamareng ka wa Farisi arantagim sa' mo' inarang, sasuk aming indigok dabik ninarang nakarik ning togu'. ");
INSERT INTO uvh_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Ka Jisas wari sasuk aming u ning yanggu', ka sasuk aming sidindu' kadagang ningsa' fating, sidi ami taming ga' midi tang a kane u ima adi mamareng girii u sanga fainga sidi yotangkayap titiga' kadapmang kareng ni kabi'sini' guk mo' tiamiting mokngang sini', wara' sidindu' wara'ning mamareng girii bemni'ga'. ");
INSERT INTO uvh_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Abanga sidi profet arantagim ka timinggi' kuma' kumoging wara'siga' sura adisining kusiksi' u kamaranga kafakafa tanga napa' isasua karesi iropyama ning titing. Ning tanga sidi, a indi aming karesi wara' tem ning tuguting. Ka profet wa anasa' mo' kumoging, wa sidaning papase wari dipmikumoging. ");
INSERT INTO uvh_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Ka kadapmang ka sidi profet ning kusik kafakafa fatiting wa sidi papase ka profet u dipmiging u yotangkayapma o papase' adi karengsa' tanga dipmiging ning tutugu ning ningda'ning fating wara' sidi wara'ning mamareng girii bemni'ga'. ");
INSERT INTO uvh_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Ka beng sini' Anutu adi napa' ka inga' kagadofi u yapkeda wara'ning sasuk kareng guk ikita' wara' adi kuma' kanga midi ning ininga yoking, na profet a kane aming fam yangkarotik. Ka adi fam ka didipmi sini' tanga fam ka ifakadaga sa' tanga ibiinga mani'ga' ning yoking. ");
INSERT INTO uvh_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Ka aming arantagim ka inga' yara'ganang iking sidi mamareng girii ka timinggi' profet dipminga abiging ababanga kami yara'ganang undu' ningsa' ko tanga ira abing wara'ning u bemni'ga'. ");
INSERT INTO uvh_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Tim munumung sini' ka Ken wari kuyangni Abel u ugumogu' u tanga ababanga inga' ganang undu' Sekaraia wari siring yak ganang amanga Anutuning kane tanga afuinga iyung bane kabasi' ka Anutuning iyung tapni ning toyaging a alta ning tanga bining sini' unggung ugumoging. Ka adi u tiging wara'ning kadagang wara'guk ka profet fam dipmiting wara'guk dabiksa' wara'ning kadagang girii wa aming ka kami yara'ganang iking sidiganang ita' wara' sidi wara'ning mamareng girii bemni'ga'. ");
INSERT INTO uvh_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Beng sini' sasuk aming sidi sasuk kareng bimbem ga' bibi' naking wa sidi aming fam wari sidiganang sasuk bimbem ga' ning tonga tinting wara'ning kadapmang faisefiaming, wara' sidi waraga' undu' mamareng girii bemni'ga'. ");
INSERT INTO uvh_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","54","Ka Jisas wari midi mamareng u ina ina ning tanga yak u kabinga mugo tinga Farisi arantagim guk ka Juda ning sasuk aming guk wari kabaksi' kadagang naknga banaksi' giptanga Jisas u midi kadagang animbenga ning tanga Jisas wari kadagang kabi' ni titi waraga' katatora tangkunang tanga marara mandang yaranga anga Jisas u midi mandaga' kabi'mo' animbenga yareging. ");
INSERT INTO uvh_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Ka ami taming kabi' kabi'mo' wari Jisas se' ganang u abanga bak girii tanga ifikagade sini' tiging. Ka Jisas wari arantagimni 12 u ning yanggu', sidi Farisi ning yis ka kadapmang kadagang ka didimeng sini' mo' tanga ira midi karengsa' ka aming karesi da'ning tuguting waraga' kafakafa denga ikanting. ");
INSERT INTO uvh_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Beng sini' nasi' kadapmang a sasuk ka aming wari kami yara'ganang kapmo' tem ning tonga tasebing wa inga' sirengsa' kadofisirendo'ga'. ");
INSERT INTO uvh_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","A nasi' midi kapmo' ka aming wari tiim ganang ningda'ning ira toing wa inga' kama da'ning fagainga sirengsa' tokadofiinga aming dabiksa' wari sirengsa' ubu naksasu'nani'ga'. Abanga yak iyung bane ganang mera midi sasagap kapmo'sa' tonting wa inga' aming wari sireng sini' ka yong bining ganang adenga tutugu ning ningda'ning nakni'ga'. ");
INSERT INTO uvh_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","5","Ka amine sidi mutu wa aming wari fuksi'sa' sidifikumak ning waraga' mo' sura tinting. Mokngang sidi mutu kubanik wa Anutuga'sa' tinting. Anutu anapmo' kubaniksa' wa aming ning fugu a uringni guk dabiksa' u kudip kadaganng ganang tipmirisasu'na wara'ning kigineng girii guk ikita' wara' sidi mutu wa adita'sa' tinting. ");
INSERT INTO uvh_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Beng sini' Anutu adi yang kababi'sini' ka aming wari sigening ningda'ning yapma moni 2 toea warisa' ka usapning tonga manggeting wara'siga' wa adi nakube guk mo' tita'. Mokngang adi kafakafa sa' yaptatoreta'. ");
INSERT INTO uvh_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Ka aming sidi wa napa' kababi' ka yang ningwara' mo'. Sidi napa' girisi adining de ganang sirengsa' ikiting wara' Anutu adi sidita' wa nakube guk mo' tota'. Adi nasi' nasi' kababi'sini' ka sidining fuksi'ganang iking kisi' sasa' dumni kubanik kubanik wara'ning nambani udi nafek guk mo' tanga ita', kuma'sa' naksasu'nanga ita'. Wara' aming sidi napa' niga' mutu mo' tinting. Mokngang, Anutu wari kuma'sa' saptatorota' ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Ka Jisas wari arantagimni u nua'bu yanggu', beng sini' aming ka nagata' naktangka tanga naganing wap u aming fam ning bining ganang itua ga' mutu guk mo' naknga itua sa' tota' wa inga' Amingning Tim Iyak nandu' adita' kabakna karengsa' nakngama Anutuning kunim aming u ning inok, aming ka wa naganing arantagim. ");
INSERT INTO uvh_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","A aming ka naganing wap a midi itua ga' mutu tanga bibi' naknga itua guik mo' tota' wa inga' nandu' Anutuning kunim aming u ning inok, aming ka wa naganing arantagim mo'. ");
INSERT INTO uvh_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Ka beng sini' aming ka midi kadagang ka Amingning Tim Iyak naga nangkadauta' ka inga' adi kaba tubobu kuma' tipfarota' wa giri Anutu wari adining kadagang wa suknakubengam guk tota'. A aming ka Anutuning mini unggo anikadauta' wa Anutu adi kadagang ka wa suknakube guk mo' tota', mokngang sini', kadagang ka wa ko ningsa' ira auta'. ");
INSERT INTO uvh_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Ka i nakni', inga' naning arantagim sidi aming fam wari manggaksapma fonga siring yak ning aming girisi a kiap wa ma king wara'ganang kuksabinga midi toni'ga'. Ka sidi adisining dimisi'ganang u adenga wa a nasi' midi indeng bema tontam ning tonga mutu tanga sasuk mimeng mo' tini', mokngang. ");
INSERT INTO uvh_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Kama ka wara'ganang wa nasi' midi kadapmang ka sidi tutugu ning wa Anutuning mini unggo warisa' sidining sasuksi' ganang kuma' tipkadofisaminga toni'ga' ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Ka Jisas wari midi ka arantagimni yanggu' u tonga biinga aming nua'ni ka aming kabi'mo' Jisas ganang u bak girii abanga tiging wari Jisas u ning anigu', o tisa na sibeng udi kuma' kumogu' ka naganing kuyana adi nagata' guk mo' sura sibeng adi mambong wa anata'sa' kuma' manggaknagu'. Ka gu aming girii tangkunang guk wara' gu yotangkanap tanga kuyana u aniinga adi mambong u nagata' fam udanga namota'. ");
INSERT INTO uvh_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Ka Jisas wari ning anigu', mo' Anutu wari kane ka iguyangguk sidi tagagaresapma sidining mambong u sabarasam wara'ning waraga' mo' nipmugu', mokngang sini'. ");
INSERT INTO uvh_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Ning aninga ning tanga ami taming kabi'mo' wara'siguk dabik ubu yanggu', sidi sasuksi' kabaksi'ganang u kafakafa katatoranga ikanting, sidi mambong a napa' kamaganangni manggakna ga'sa' ma nakni'. Aming wari marek kareng titi wara'ning ki wa kadapmang ka mambong mimeng manggakna ga'sa' ninak wa mo', mokngang undu' ki a kadapmangni nua'ni ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Ning tanga Jisas wari kadapmang ka aming wari mambong ga' siamo' ninak ning waraga' midi tipfara nua'ni ka ning tiamgu', ka aming kangasi nua'ni adi kamani girii guk. Ka adi fikifiki kama u dininga wit faipmota'. Ka wit wari karesi'sa' kadofinga garanga beng kabi'mo' tinting. ");
INSERT INTO uvh_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Ka feng tuang adi wit wari beng siamo' tinting u yapma ning touta', ai na wit i dopma kuguk wara'ning yak timini udi kababi'sa'. ");
INSERT INTO uvh_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Ka na kugwek tanga yak girisi ubu unda' mautik. Ning tanga mambongna tangkunasi fam wara'guk dabiksa' dasitangkanga kabiinga fideuta'. ");
INSERT INTO uvh_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Ning tanga sanagaming a mambong fam dabiksa' wari yak ganang u to'na sini' tanga iknaminga na fikifiki kane guk mo' tanga sigesa' mengkuranga mera nana kareng ningsa' nanga ira autik. Ning tonga kuma' tipdidimasasu'nanga tanga mera nauta'. ");
INSERT INTO uvh_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Ka Anutu wari ning anota', ai, gu aming sasuk guk mokngang. Gu guning kungkumak waraga' kabi'guk mo' sura tarang. Ka gu kungkumak wara'ning kama wa kami tiim sa' yang. Gu mambong kabi'mo' ka ganang fuka yotangka ga' sura kane tang tanga manggara fadasitang wa gu kane girii sige fatitang. Kami gu kumakinga aming nua'ni adibu manggaknota' ning anota'. ");
INSERT INTO uvh_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Ka beng sini' aming kangasi kabi'mo' adindu' ningsa' titing. Adi anasining fuksi' yotangka ga'sa' sura mambong kamaganangni unggungsa' manggara tatangkanga ikiting wa Anutu adi adining sasuk kareng waraga' tatafak ning yabita' ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Ka Jisas wari fukni' yotangka ning mambong ga' nafek tanga sasuk mimeng titi waraga' ka arantagimni u ning yanggu', ka sidi mamareng ka nana a kwi'ga' nafek titining wara'guk ira wa kabaksi' mamareng naknga sasuk mimeng tanga ai, kwi' wa indeng bemtam a nana wa nasi' nanga ikantam ning mo' toyanting. ");
INSERT INTO uvh_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Beng sini' aming wari damdang sa' naknga tangkunang guk kareng giri iik wara'ning wa kadapmang ka nana a mambong manggakna wari ifitangkainga iik ning guk mokngang undu' kini nua'ni. Wara' nana guk ka tasase guk wa napa' kabasi' a aming sidining kabaksi' a sasuk wa napa' girii sini'. ");
INSERT INTO uvh_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Ka sidi kadapmang ka yaang wari tanga ikiting waraga' sura nakedanting. Yaang adi fuksi' yotangka ga' sura feng kane tanga nana yak ganang manggara dadasi ka aming sidi titing ning guk mo titing. Mokngang, yaang adi sigesa' ira Anutu warisa' yotangkayabinga yapma nanga damdang sa' giri ikiting. Ka yaang wa napa' kababi' unggung ka Anutu adi kafakafa sini' yaptatoreta'. A aming sidi wa Anutu wari napa' girii ning sabita' wara' adi kuma'sa' yotangkasabinga ikanting. ");
INSERT INTO uvh_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Ka sidi sidining iiksi' waraga' wa kuma'sa' naking, sidi ka' kama paramu' ko ira au ga' naknga wa sidi iiksi' u nua'bu yorafa waraga' napa' ni sidaning tang ganangsa' tinga paramunda ning guk mokngang sini'. Sidining ka' iik wa Anutu warisa' katatoranga ita'. ");
INSERT INTO uvh_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Beng sini' napa' napa' dabiksa' u defata' wa Anutu warisa' yaptatoranga ikita' wara' sidi sidining iiksi' u yotangka waraga' sasuk mimeng mo' tinting. ");
INSERT INTO uvh_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Abanga sidi napa' isasua daberim karesi waraga' sukanting. Isasua adi daberim wa kane girii ka aming wari kwi' karesi tanga mantofinating ning guk mo' titing. Mokngang wa Anutu warisa' ifikadofiinga daberim karesi kuni' kuni' kabi'mo' u kadofiting. Ka tim king Solomon wari aming kangasi ira tanga itarugu' undu' kuma'sa' nakitam, Solomon adi kwi' inga'ni karesi kuni' kuni' tanga itarugu' de ka adining kwi' nua'ni ka kudini kareng sini' ka isasua ning daberim ningwara' sini' guk mo' yagu. Mokngang, daberim warisa' adining kwi' u tarafikiting. ");
INSERT INTO uvh_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Ka daberim wa napa' kama paramu' iikning mo' unggung ka Anutu warisa' tiabinga kadofiting. Daberim adi sidii kubaniksa' kadofinga adeia' tubobu urapsa' kaforanga mangfuinga aming wari sumu tanga fonga bak tanga kudip seting. Ka aming sidi daberim ningwara' mo', sidi Anutu wari napa' girii ning sabita' wara' adi aming ka naktangkasi' girii guk mokngang sidindu' kuma'sa' yotangkasabinga karengsa' giri ikanting. ");
INSERT INTO uvh_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Ka sidi napa' fuksi' yotangka ning waraga' nafek tanga a nana wa indeng kanga nantam ning tonga kabaksi' mamareng naknga sasuk mimeng mo' tanga ikanting, mokngang. ");
INSERT INTO uvh_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","31","(Kadapmang ka napa' fuksi' yotangka ning u manggakna waraga' sasuk mimeng titi ningwara' wa aming kamaganangni ka Anutuga' naktangka guk mo' titing wari tanga ikiting, wara' sidi kadapmang ka wa mo' tinting.) Beng sini' sidining babangsi' Anutu adi sidi nasi'ga' nafek tinting udi kuma'sa' kanga yotangkasabota'. Wara' sidi sasuk ka adining kane ka aming wari adining bining ganang iik wara'ning waraga'sa' tanga ning tanga adining midi u ninaksa' tinting wa Anutu wari yotangkasap tanga napa' ka sidi nafek titing undu' kuma'sa' saminga bemnanting ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Ka Jisas wari arantagimni u nua'bu ning yanggu', sidi aming arantagim girii mo' de ka sidi mutu mo' tinting. Sidi Anutuning sipsip arantagim ka Anutu wari yotangkasap tanga adining bining ganang kuksabinga iik waraga' kuma' totangkagu' wari iking. ");
INSERT INTO uvh_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Ka sidi sasuk mimeng ka mambong kamaganangni ga' titi ning wa kagabi tanga kadapmang kareng ka ning tinting, sidi mambongsi' u manggara fonga aming fam ga' ima ning tanga mambong wara'ning uningkim u manggara aming ka mambong ga' nafek tanga tatafak iking u yotangkayapma wara'siga' sabaranga ima yaranting. Ning tanga sidi kunimganangni mambong tangkunang ka kadaga guk mo' tita' u manggara bak gi' kuguk waraga' sura wara'ning kane sa' tinting. Ka mambong ka u torik wa tangkunang beng sini'. Mambong ka wa nua'bu bibi' a kubu aming wari kubuna wa ma kagayang wari nadamirik ning titining guk mokngang sini'. Mambong ka wa fikifiki fafandangeng kareng a kigineng ningsa' ira au wara'ning. ");
INSERT INTO uvh_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Beng sini' aming ka mambongsi' guk adi fikifiki sasuksi' kigineng wa kama ka mambongsi' tangkunasi' kuknainga fideting waraga'sa' fatiting. Ka aming ka tatafak aming yotangkayapmanting sidindu' ningsa' sidi kane ka u tinting wa kunimganangni mambong tangkunasi u manggara bak kuknanting ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Ka Jisas wari ana kapmek waraga' arantagimni u ning yanggu', sidi girisi' kapmera nip tamtangkanga a kamang garinga ning tanga adenting. ");
INSERT INTO uvh_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Sidi kadapmang ka kane aming wari amingsi' girii wari taming kafauwe ning tangsana u kabinga abanga faba kadakngam ga' katianinga urapsa' urang kadakyamiting ningda'ning tanga ka'sa' adenting. ");
INSERT INTO uvh_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Aming girisi' wari tubobu abanga kaneni aming wari adi kapmera ka' ningsa' ikanting u yapma kaba karengsa' nakyama kafakafa tiamonga ning inota', sidi aming naning kane sa' tanam ning de, ka sidi kwang mekinga naga kane fam tasamotik. Ning ininga kane aming adi aming girisi da'ning kwang mera mengkuranga marekinga aming girii wari nana u sabaranga ima yareinga mera nanting. ");
INSERT INTO uvh_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Beng sini' aming girisi' wari tiim bining wa ma inga'sini' ka 3 klok tiim bining ganang u kadofota'. Ka kane aming wari ka' ningsa' ko kapmefakanting wa adi aming girii wari karengsa' yabota' waraga' sura kabaksi' karengsa' nakanting. ");
INSERT INTO uvh_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Abanga nua'ni ka ning, aming yak tuang nua'ni adi kubu aming wari mambongna ma abanga nuromkubuno' ning tonga fikifiki som tang ningsa' tanga ira auta' wa kubu aming wari mo' kadofingaminga kaba kugurang guk ningsa' irota'. ");
INSERT INTO uvh_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Ka Amingning Tim Iyak naga tubobu abubu wara'ning undu' ningsa', sidi kama ka naga abubu wara'ning wara'guk mo' naking. Sidi ko ba ning tonga nakeda guk mo' tanga ikni' wara'ganang kubu aming da'ning kaga' urapsa' ma kadofisamok wara' sidi kafakafa suktangkanga som tang ningda'ning tanga ka'sa' ikanting ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Ning tanga Pita wari Jisas u ning anigu', ka girii gu midi tipfara ka aming wari aming girii kapmek wara'ning u tanga torang wa indita'sa' sura torang wa ma aming fam ga' guk dabik sura u torang. ");
INSERT INTO uvh_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Ka Jisas wari arantagimni wari nakeda titi waraga' midi tipfara kabi' nua'bu tanga ning togu', kadapmang ka wara'ning wa kane aming kareng wari girini ning midi ninak sa' tanga titining ninda'ning. Wa ning, aming girii wari yong kamani maunga kane amingni ga' kane ka adining yak u katatorangama a kane aming fam u yaptatoranga nana didimengsa' sabaraim ning u tanga iik waraga' kaminga ning tanga mauta'. ");
INSERT INTO uvh_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Ka kane aming adi kane ka girini wari titiga' anota' u didimengsa' kuma' tanga irota' wa adi girini wari tubobu abota' ganang girini u kanga kaba karengsa' naknga mesisiringa tota'. ");
INSERT INTO uvh_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Beng sini' kane aming ka midi ninak sa' tanga kane didimengsa' tanga irota' wa girii wari tubobu abanga adining kane didimeng u kanga kaba karengsa' naknga bema napa' napa' dabiksa' u yaptatora wara'ning tim iyak aming girii kamiinga tanga irota'. ");
INSERT INTO uvh_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","A kane aming ka wari midi ka girini wari kane titiga' anota' u kuma' naknga karangkang tanga kane u tasasu'na guk mo' tanga ning touta', a girii udi urap mo' abo'ga' nakarik inga' sini' abo'ga' ning tonga kane u kabinga suknakube sa' tanga sige ira nana karengsa' nanga ning tanga ama kagaya topnanga papenga fugu bema aranga kane ami fam u dipminga a kane taming udi didipmi ning fatota'. ");
INSERT INTO uvh_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Ning tanga kadapmang kadagang u tanga ira anganga kama ka girini wari tubobu abubu ning waraga' nakube kuma' tota' ganang ka girii wari abota'. Abanga kadofinga adining kadapmang kadagang u kanga kaba kadagang sini' naknga bane giptanga kane aming u bema kadagang sini' urota'. Ura ura ning tanga bema tonga aming kadagasi ka midi karangkang titisi wara'siguk dabik dawang naro' tarayabota'. ");
INSERT INTO uvh_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Beng sini' urang torik kane aming ka girii ning sasuk a midi u kuma' kasasu'nanga irota' ganang ka inga' girini wari kabinga mugoinga adi girini ning sasuk u kafakafa guk mo' yaranga tanga biritarak naknga sige ira auta' wa aming girii wari mimeng sini' ura tipkadaga sini' tota'. ");
INSERT INTO uvh_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","A kane aming ka girii ning sasuk kafakafa guk mo' kanga irota' wari kadagang kabi' tota' undu' dabik ningsa' uuk ning de, ka adi kafakafa guk mo' naknga tara' wara' aming girii adi kabi' gi' urota'. Abanga aming ka girii wari adining kane u kafakafa tangam ga' sura adining sasuk kareng kuma' amisasu'nota'. Ka adi kane u kafakafa guk mo' tota' wa girii adi midi kugurang sa' ka a, kafakafa guk mo' nakedanga tarang wara' giri, ning guk mo' anota'. Mokngang sini', adi sasuk guk kuma' ira kadapmang kadagang ka u tara' wara' girii adi aming ka waraga' kaba kadagang nakngama barap girii tota' ning togu' Jisas wari. ");
INSERT INTO uvh_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Ka Jisas wari arantagimni u ning yanggu', ka naga kamaganang i afuguk wa na kane kigineng ka kudip da'ning u seda waraga' afuguk. Wara' na kane ka u tinga wara'ning kigineng wari kudip ningda'ning mambaya' girii kadofinga kadagang u urapsa' danga tipmirisasu'na ga' nakarik. ");
INSERT INTO uvh_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Ka na inga' mamareng girii nua'ni wari mungkupnanabinga ama mang amanga putip titining ningda'ning tok ga'. Wara' na fikifiki mamareng ka waraga' sura kabakna mamareng naknga sasuk mimeng tanga gi' guk mo' itik. Ka ning torik, ningwara' mamareng ka wa urap kadofinga biwa'. ");
INSERT INTO uvh_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Ka aming sidi nagata' wa ning ma sukni', a adi kane ka aming wari kagaya tanga iking u tipmirisasu'nanga manggara fabanga kuknibinga sibim kareng gi' iik waraga'sa' unda' afugu'. Mokngang, na aming kidayabinga arantagim fama' ning ubu iik waraga' guk afuguk. ");
INSERT INTO uvh_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Ka aming kidayap wara'ning ki wa ning, kami naga afanga kane tirik yara'ganang wa aming ana kurene faiv ning ka yak kubanik ganang kafakafa ga'sa' kuma' ikiting. Ka inga' naganing midi wari adiganang auinga adisining aming fama' wari nagata' naktangka tantamu' wa amise famineng wari adisita' bibi' nakyamting. Ning tanga tubo kidagang tanga fama' undu' naro' a famineng undu' naro' ning ikanting. ");
INSERT INTO uvh_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Beng sini' aming adi kami yara'ganang wa kadapmang ka ning u tinting. Adi tubo kidagang tanga beni wari mindingni kagurudota', a mindingni undu' beni kagurudanga naro' irota'. Abanga mengni wari ibingini ga' bibi' nakngamota' a nabingi taming tangandang wari nabingini kagurudota'. Ning tanga adi dadawang sa' ikanting ning togu'. ");
INSERT INTO uvh_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Ka Jisas wari ami taming u midi nua'ni ka ning yanggu', ka aming sidi kadapmang ka napa ni wari kadofonga tinga kigedanga tugu wara'ning undu' fafongsa' titing. Sidi mungkong kangkam ka mayam de ararap tara' do kangkamareta' u kanga wa o gimak ba urota' ning tuguinga undu' gimak bengsa' ukita'. ");
INSERT INTO uvh_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Abanga sidi gugubik kigineng ka saut tara' do abuta' u kanga wa ning tuguting, o mayam ubu ba dauta' ning tuguting undu' mayam bengsa' data'. ");
INSERT INTO uvh_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Ka sidi aming nakedasi ning ira napa' ka ning wa giri yapkedanga tuguting. Ka kami yara'ganang Anutu wari kane tangkunang tara' wa sidi kigeda guk mo' wa indining ting. Wara' ning torik, sidi aming nakedasi mo' ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Ka Jisas wari kadapmang ka Anutu wari aming ning kadagang suknakube waraga' inonga midi tipfara kabi' tanga aming u ning yanggu', ka sidi Anutu girii wari sidining kadagang u suknakubesam wara'ning kadapmang kareng urapsa' katua waraga' sukanting. ");
INSERT INTO uvh_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Wa ning, gu aming nua'niga' kadagang tangamotang ka adi kaba kagaya naknga midi kigineng kot ganang gipmonga ginagira auta'. Ka gu kadapmang bining ko anga ganang wa sasuk kareng urapsa' katuanga aming wara'ning kaba kagaya u tipmiri waraga' kane tanga adigok midi tontamu' wa giri, aming wari kaba kuranga tubobu sura tipfaranga gigibi tinga yongga' tubobu mabotang. A gu kadapmang kareng ka ning u urap mo' sura adining kaba kagaya u urap mo' tipkurotang wa aming adi ginagira tonga jas ganang gipmota'. Ning tinga jas wari guning kadagang u kanga adibu plisman ga' iminga plisman adibu bemgapma tonga iyung kane kalabus ganang gipminting. ");
INSERT INTO uvh_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Ning tinga gu kalabus iyung ganang u ira guning kadagang wara'ning toni u tipmiri waraga' kane kagaya ningsa' tanga fautang. Ka sidi Anutu girii ning kot kigineng ganang ma adeni' wara' sidi waraga' sura kadapmang kareng ka Anutu wari sidining kadagang suknakubesam wara'ning u tinting ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Ka kama ka wara'ganang aming fam ka Jisas ganang abiging wari Jisas u ning aniging, ka gu kadagang ka kiap Pailat adining soldia fam yangkareinga anga siring yak girii ganang amanga Galili aming fam ka Anutuga' ofa tangamonga maga dipmonga tiging ganang didimeng gufadayapking waraga' wa gu indining sutang. ");
INSERT INTO uvh_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Ka Jisas wari ning yanggu', ka sidi waraga' wa ning unda' fasukiting, a adi kadagang girii tiging wara' gufudayapking a aming fam indi kadagang guk mokngang wara' kareng giri ikem. ");
INSERT INTO uvh_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Mokngang sini', aming dabik sidindu' kadagang guk ningsa' iking. Ka kami yara'ganang sidi kabaksi' faranga kadagangsi' u mo' kabinting wa sidindu' dabik ningsa' bisasu'nani'ga'. ");
INSERT INTO uvh_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Abanga nua'ni ka tim Jerusalem yong bibik ganang gwang wap ka Silom gaga wara'ganang yak paramu' maging wari tapanga manga aming 18 ning urang dipmigu' waraga' undu' sidi ning unda' fatuguting, a aming ka wa kadagang girii guk wara' adi yak wari tapanga dipmigu' wang. Mokngang. ");
INSERT INTO uvh_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Beng guk sini' urang sanirik, sidindu' kadagang guk. Ka kami sidi kabaksi' guk mo' faranga sidining kadagang u mo' kabinting wa sidindu' u kumoging ningsa' kumara bisasu'nani'ga'. ");
INSERT INTO uvh_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Ka Jisas wari midi tipfara nua'ni ka aming adisining iiksi' ning kadapmang kafakafa katatora wara'ning ka ning tugu', ka aming girii nua'ni wari firi ka mindip nana titining nua'ni u feng bining ganang iropma kabinga mauta'. Anga iya' inga' firi udi mindip kuma' unda' tara' ning tonga firi mindip u manggaknonga mabota'. Abanga kauta' ka firi udi beng guk mo' mindota', fisa' marafarota'. ");
INSERT INTO uvh_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Ka feng tuang adi u kanga kane amingni u ning anota', na firi idi beng guk udep mindira' ning tonga yangkweng gurak famineng sini' sige tanga karik ka mokngang, beng guk mo' tanga fisa' marafata'. Wara' gu diningkayo totang, adi kama marang sige tipmirira' karik. ");
INSERT INTO uvh_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Ka kane aming ka feng u katatoranga irota' wari feng tuang u ning anota', o girii ko urap mo' dininga kayontamuk. Naga kau kuma manggara kama guk tipfaranga ki ganang u kura kama gira mugurotik. Ning tanga gurak kubanik ning kapmeia' kanga inga' kuma' dininga kayodam. ");
INSERT INTO uvh_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","A naga kane u tinga beng guk kuma' udep mindota' wa giri kagabi sa' tinga ningsa' ira awa' ning touta' ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Ning tanga iya' inga' sabat ganang Jisas wari siring yak nua'ni ganang amanga ami taming u midi kareng fianggeku'. ");
INSERT INTO uvh_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Ka taming nua'ni ka mini unggo kadagang wari adiganang kama paramu' gurak 18 ning sini' ira taramakinga siging dindimenga kadak didimeng guk mo' fentarugu' undu' unggung amanga mareiagu'. ");
INSERT INTO uvh_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Ka Jisas wari taming u kanga bibiri' kanga katingana ning anigu', taming kami guning bagana wadigi' kuma' tipmirigamarik. ");
INSERT INTO uvh_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Ning aninga sasaro' tinga taming ning siging wari urapsa' karendanga tatare tugu'. Ning tinga taming adi karang didimengsa' ubu marara adenga kaba karengsa' naknga Anutu animamangnanga mesisiringa tugu'. ");
INSERT INTO uvh_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Ka siring yak wara'ning aming girii nua'ni wari Jisas wari taming u sabat tapni ganang tipkarendagu' u kanga kaba kadagang naku'. Ning tanga ami taming u ning yanggu', ai, sabat ya kama tapni mengkura titi wara'ningsa' ka aming sidi baganasi' u tanga yuguksam ga' naknga wa kama bining sige ka 6 ning wara'ganangsa' abuinga tasamting. A mengkura ning kama tapni ganang abanga ting ya kareng sini' mo' karik ning togu'. ");
INSERT INTO uvh_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Ka girii Jisas wari ning anigu', beng sini' sidi yaptatora aming mandaga' ning sabarik. Sidi kama tapni sabat ganang wa kane ka magasi' kau a dongki wa ama topna ga' udi fafongsa' fadara ipmiting. ");
INSERT INTO uvh_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","A naga taming i tipkarendarik ya maga u fadara ipmiting ningwara' mo', mokngang sini'. Ya Ebraham ning iri kareng ka aming kadagang Setan wari kama paramu' gurak 18 ning sini' bema tofitangkainga ikita' u kami sabat ganang fadara kamirik wara' na didimeng giri tirik ning togu'. ");
INSERT INTO uvh_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Ning tinga aming girisi arantagim ka Jisas ga' bibi' nakngamging adi kadapmang ka ningwara' wa bengsa' tanga ikiaging waraga' tanga Jisas ning midi u naknga megang girii naking. A ami taming sige ka Jisas ning midi u mera fanaking adi Jisas wari kane kareng beng guk tanga yaregu' u kanga Jisas ga' kabaksi' karengsa' nakngamging. ");
INSERT INTO uvh_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Ka Jisas wari aming u ning yanggu', na midi ka aming wari Anutuning bining ganang iik waraga' sanotik. Ka aming wari Anutuning bining ganang iik wara'ning wa tim ka napa' kabasi' ning kanting. Ka inga' ganang wa napa' girii sini' ning kani'ga'. ");
INSERT INTO uvh_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Ka sidi firi mastet ning mindip wa kuma'sa' yabiting. Mastet ning mindip wa girisi mo' kababi'sini' yating, ka aming wari u bema tonga ipmota' wa wari kadofinga giranga firi kabasi' mo' ubu ikinga yang wari yori guk manga dekiting. ");
INSERT INTO uvh_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","21","Abanga sidi napa' nua'ni ka yis undu' kuma' yabiting. Yis wa napa' kababi'sini' ka sigening ningda'ning yating. Ka taming wari baret songa wa adi plaua mimeng gira ning tanga yis wa kabi'sini' sa' kamota' warisa' tanga girii bekinga seting ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Ka Jisas wari yong ka u kabinga ning tanga Jerusalem yong girii ga' maronga mugogu'. Anga yong kababi' a yong girisi u dera Anutuning midi yanggera agu'. ");
INSERT INTO uvh_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Ka yong nua'ni ganang ka aming nua'ni wari Jisas u ning anigagu', girii gam, Anutu adi kafakafa wa aming fama'sa' unda' tiabo'ga'. ");
INSERT INTO uvh_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Ka Jisas wari ning togu', kadapmang ka aming wari Anutuning yongga' mugo wara'ning wa kabasi' ka iming tugo sini' ningda'ning adeta' wara' kane girii tanga mugoning. Ka sidi waraga' sura kane tangkunang sini' tinting. Beng sini' torik, aming kabi'mo' wari iming ka wara'ganang mugo ga' ning tonga tinting de, ka mokngang adi sang titi' tinting. ");
INSERT INTO uvh_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Ka inga' wa kadapmang nua'ni ka ning tini'ga', yak tuang wari marara faba u kuma' isefitangkawa' ganang ka sidi inga'ga' anga kadofinga faba u ura ning katingangni', girii, faba i kadaknime', o giri faba i kadaknime'. Ka adibu ning sano', sidi indeng wara'ni wari abing. Na sidigok mo' sabitik. ");
INSERT INTO uvh_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Ka sidibu ning toni', o indi guning amige ka tim gu anga ninggera ira gugok nana kubap urang nagum wang wari abem. ");
INSERT INTO uvh_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Ka aming girii yak tuang adibu ning sano', a sidi indeng abing na sidigok mo' sabitik. Sidi aming kadagang titisi wari abanga toing nakarik, uri fong mugo tini'. ");
INSERT INTO uvh_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Adi kuma' sangkagareinga adenga fonga yapni' ka Ebraham a Aisak a Jekop a profet timini fam dabiksa' udi Anutuning yong kareng ganang marekni'. Ka sidi u fonga yapma kabaksi' mamareng sini' naknga kafasi' ki singa ku katinga yangakni' de, ka mokngang aming girii adi faba u kadaksam guk mo' tinga sidi fugang unggung ningsa' ikni'ga'. ");
INSERT INTO uvh_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Ning tinga aming kabi'mo' ka Juda mo', arantagim nua'ni ka kama kamani ka mayam de ararap tara' a mayam de amama tara' ikiting a not a saut tanga u ira yareting wari abanga yak iyung u amanga ning tanga Anutuning bining kareng ganang mera kabaksi' karengsa' naknga mesisiringa sa' tanga nana u mera nani'ga'. ");
INSERT INTO uvh_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Ka kama ka wara'ganang wa tipfara ning to'ga', aming ka sige ikiting adi inga' wap guk ikni', a aming ka tim wap guk ikiting adibu wap guk mokngang sige ikni' ning yangggu'. ");
INSERT INTO uvh_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Ka kama ka Jisas wari aming midi u fianggu' wara'ganang didimeng ka Farisi arantagim ning aming fam ka Jisas ga' nakiaging wari abanga Jisas u ning aniging, ai, king Herot udi gugumak tonga tora' naknga abem. Ka gu kama ka i kabinga yong nua'ni ga' muto te'. ");
INSERT INTO uvh_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Ka Jisas wari ning yanggu', sidi tubobu anga aming ka kugwang kadagang da'ning wa ning anini', na kane guk. Kami na kane ka masi' unggo kadagasi tanga yugukyam a bagana aming ifakarenda wara'ning u ko totik. A kamindap undu' ningsa' ko totik ga'. A sara wa kane ari' tok. ");
INSERT INTO uvh_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Ka sidi naga urap mugo ga' naning wa kane ya kama nua'ni ga' mo' anga tirik, ya Jerusalem ga' anga tanga famarik. Beng sini' profet wa kama nua'ni ganang uuk ning guk mokngang, wa Jerusalem yong ganangsa' uukning. Wara' na Jerusalem ga' famarik yang ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Ning tanga Jerusalem aming ga' sura ning togu', Jerusalem aming sidi Anutuning midi tokadofi aming profet u dipmikumara fabing. Abanga sidi Anutuning aming ka Anutu wari sidita' sasuk sansam ga' ning tonga yangkarasamita' undu' uningkim kwak wari dipmikumakiting. Ka beng sini' na fikifiki sidi yotangkasap ga' sura kagare' wari nano firisi' kapmik ganang urang fabanga kiripyabiting ningda'ning tasabonga fatirik. Ka mokngang sidi nagata' bibi' fanaknaming. ");
INSERT INTO uvh_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Ka sidi kadapmang ka ning u tanga fabing wara' Anutu adi sidining yong i kuma' kabiinga samap sigesa' ubu adera'. Beng sini' urang sanirik sidi naganing nondakna nua'bu guk mo' napmanting, Mokngang sidi narosi ningsa' tanga ira anganga inga' sini' afuinga napma o beng sini' indi adining wap bema arantam, adi Anutu wari yotangkangaminga kigineng girii guk afara' ning toni' wara'ganangga'sa', ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Ka Farisi arantagim adi Jisas wari kane ka bagana aming ifikarenda ning u sabat tapni ganang tugu' u kanga nua'bu tinga midiganang bema kami waraga' sura Jisas ga' som tang tanga fakiaging. Ka sabat nua'ni ganang ka Farisi ning aming girii nua'ni wari Jisas u adigok nana angana ga' anigu'. Ning tinga Jisas wari aming girii wara'ning yak ganang u anga adisigok nana u mera naging. ");
INSERT INTO uvh_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Ka adi nana u mera naging ganang ka bagana aming nua'ni kayong kafong fugu bibek guk wari Jisas kaunga unggung agu'. ");
INSERT INTO uvh_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Ka Jisas wari bagana aming u kanga tipkarenda titiga' sura sasuk aming a Farisi arantagim ning aming fam ka anagok nana kubap mera nagging u ning yangkagu', ka ma', Juda indining kadapmang tapni wa indining, indi sabat ganang wa bagana aming ka ni guk mo' tipkarendantam wa. ");
INSERT INTO uvh_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Ka aming adi midi tubobu guk mo' aniging, mareksa' tiging. Ning tanga Jisas wari bagana aming u adisining dasi'ganang unggung kaga'sa' tipkarendanga anigara tinga yoringga' tubobu mugogu'. ");
INSERT INTO uvh_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Ning tanga Jisas wari Farisi aming u ning yanggu', ka sidi sidining saba kabasi' wa ma maga kau ni wari kwang ganang mantapanga fideuta' wa indining titing. A kami ya sabat tapni kane titining guk mokngang wara' kureng fidera' kamindapsa' kuma' wenga bemtam ning u tonga ibiting. Mokngang, sidi base tanga yotangkangam titining kane wa sabat ganang kaga'sa' undu' fafong titing. Ka sidi magasi'ga' tiamting ningsa' nandu' aming mamareng guk u sabat ganang girisa' yotangkaimotik ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Ka Farisi aming adi midi tubobu anini ga' nafek tanga marek sa' tiging. ");
INSERT INTO uvh_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Ka Jisas wari Farisi aming midi u ina ning tanga nana u mera naging. Ka aming fam ka nana u nonga aging udi tare karesi ka aming girisi wari mimek ning wara'ganangsa' anga mera naging. Ka Jisas wari u yapma midi tipfaraim tanga ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","9","Wa ning, aming nua'ni wari taming kafauwe titiga' tangsana girii tota'. Tanga aming wari adining nana u angana waraga' katianota'. Ka adi aming girii sini' nua'ni undu' kuma' katinganota' wara' aming sige ka tim auta' adi anga tare kareng ka aming girii wari marek ning wara'ganang urapmo' merota'. Adi urapsa' anga merota' wa inga' aming girii wari kadofiinga tangsana tuang wari aming ka tim merota' u ning anota', aming gu tabangam tanga tare ka u kabinga dota' anga mere'. Ning aniinga adi tare kareng ka kuma' merota' u kabinga marara adi marek ning kama guk mokngang u kanga anga gaga sini' dota' merota'. Ning tanga adi tare kareng u aming bane ning dasi'ganang aniinga kabota' waraga' sura megang girii naknga marafarota'. Ka sidi waraga' sura kadapmang ka fuka bema aranga aming girisi ning tare kareng ganang mimek ga'sa' ninak wara'ning wa mo' tianting. ");
INSERT INTO uvh_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Ka tare kareng ganang mimek wara'ning kadapmang kareng wa ning, aming fam wari tangsana tanga katisaninga wa sidi fuksi' bema afanga anga tim ka tare sige wa ma kamaganang mekanting. Ka inga' tangsana tuang anasa' sapma o amine gu tare ka uta' wara'ganang mere' ning tuguinga marara anga tare kareng wap guk wara'ganang wa inga' mekanting. Ning tinga aming fam ka nana kubap nana ga' anga marekanting wari aming wap guk ning sabinga sidi kabaksi' karengsa' naknga marekanting. ");
INSERT INTO uvh_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Beng sini' aming ka ananing wap bema ara ning kadapmang sa' tanga irota' wa inga' Anutu adi tipmikurata tinga aming sige ning kadofo'. A aming ka ananing wap bema afu ning kadapmang tanga irota' wa Anutu wari yotangkangam tinga adi aming wap guk ning iro' ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Ning tanga Jisas wari aming yak tuang ka nana ga' katianggu' u ning anigu', ka gu tangsana nua'bu tanga wa gu kura' tubobu tagam waraga' sura aming ka ganing tuang babangge mamangge kuyage namage a kagage wa ma aming kangasi fam ka ganing yongganangni ning unggungsa' mo' katianarotang. Kadapmang ka ganing tuang sa' katiang wara'ning wa napa' girii mo'. ");
INSERT INTO uvh_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Wara' gu tangsana nua'bu tanga wa gu aming fam ka guning arantagim mo', wa ma tatafak aming ka aming kasi' ginggebingesi a dasi' kadagasi undu' katiang sa' tarotang. ");
INSERT INTO uvh_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Ka gu napa' kareng u tiama adi kura' tubobu guk mo' tagaminga wa gu waraga' kabaka mamareng mo' nakarotang. Mokngang gu napa' tubosa' undu' girisa' tiamotang. Ka gu napa' tubosa' u tiamotang wara'ning tuboni wa inga' Anutu wari naktangka aming tubobu ifimararo' ganang napa' kareng sini' kuma'sa tagamo'ga'. Wara' gu waraga' sura kabaka karengsa' naknga tanga irotang ning anigu'. ");
INSERT INTO uvh_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Ka aming ka Jisas guk nana u kubap mera naging wara'ning nua'ni wari midi ka u naknga Jisas u ning anigu', beng sini' aming fam indi inga' Anutuning bining ganang mera kabakni' karengsa' ka aming wari tangsana girii ning bining ganang urang mera nakiting ningda'ning naknga mareknam ga' ning togu'. ");
INSERT INTO uvh_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Ka Jisas wari aming wara'ning midi u naknga kadapmang ka aming wari Anutuning bining ganang marekning waraga' midi tipfara tanga ning togu'. Wa ning, aming girii nua'ni wari tangsana girii tonga tota'. Ka adi tangsana wara'ning nana u anga nana waraga' aming fam tim kuma' ina ibinga yarota'. ");
INSERT INTO uvh_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Ning tanga iya' tangsana beng titi wara'ning kama wari kadofiinga aming girii tangsana tuang wari kane aming anigarota'. Anigareinga anga aming ka tim guk kuma' ina ibinting u ning ina yarota', ai aminese', tangsana urang sanggum wa kami kuma' kadofira' kanga sinagik tonga abarik yang. ");
INSERT INTO uvh_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Ka aming tangsana waraga' au ning adi kanesi'ga' sura bibi' ubu naknga kane aming u midisa' aninga yaranting. Aming nua'ni adi kane aming u ning anota', o amina bibiri' sini' na mo' unda' autik. Kap sa' kama dibing nua'ni inga' toguk wara' na kami kama u anga kadidimautik. ");
INSERT INTO uvh_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","A aming nua'ni adi ning anota', o bibiri' sini' amina, na feng ning kama dininam wara'ning maga kau ka sara toguk u anga yabonga aratirik yang wara' mo' autik. ");
INSERT INTO uvh_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Ka aming nua'ni adindu' ningsa' touta', o amina na taming kafauwe udi inga'sini' tanga maretik wara' bibiri' sini' mo' autik, ningsa' aninga yaranting. ");
INSERT INTO uvh_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Ning tinga kane aming adi tubobu anga aming girini u ning anota', o mokngang, dabiksa' adi kanesi'ga' ubu sura bibi' naknga mo' antam ningsa' tonga yaring kanga nagapmo' abarik. Ka aming girii tangsana tuang adi midi ka u naknga kaba kadagang sini' naknga ning touta', a na aming karesi wari abubu ga' ning tonga katianak. Ka adi bibi' ba naking. Girisa', ningwara' aming kadagasisa' ubu kuma' yapma inagikantam. Ning tonga kane amingni u ning anota', gu tubobu anga kadapmang kababi' u yaranga yangara tatafak aming kadagasi kasi' kafasi' ginggebingesi a dasi' kadagasi ka yong kababi' ganang kapmo' indeng iking unggungsa' yapma inagira abe'. Ning aninga anikareinga auta'. ");
INSERT INTO uvh_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Anga yong kababi' u yangaksasu'nanga aming u inagira anga aming girii u ning anota', girii na guning midi u yaranga didimengsa' kuma' tanga inagira abarik. Ka yak iyung ya to'na guk mo' tara' karik. ");
INSERT INTO uvh_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Ka aming girii wari ning anota', beng sini' torang nandu' naganing iyung bane i aming wari mekto'na sini' titiga' nakarik. Wara' gu tubobu anga kadapmang u yaranga yangara aming fam ka feyang yak ganang indeng deking u yapma ininga abani'. Adi abubu sa' tinting, na nana a kama fam sige fade ga' bibi' nakarik. ");
INSERT INTO uvh_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Beng guk sini' urang torik aming ka tim naganing nana yaraga' abubu ga' kuma' yangguk ka bibi' naking adi naganing nana i kabi'sini' nana ning guk mokngang sini'. Ning touta' ningda'ning ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Ka ami taming arantagim girii wari Jisas u yaranga aging. Ka Jisas wari u yapma faranga adenga midi kigineng nua'ni ning yanggu', ");
INSERT INTO uvh_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","aming ka naga naura naganing arantagim ira naganing kane tonga wa adi ananing napa' tangkunangni ka beni a mengni a kuyane a tamni a mindine ibingine mambong wara'siga' sasuk mimeng mo' tota'. Abanga kadapmang ka ananing sasuksa' yaranga tanga iikning undu' kagabi tanga naurota' wa adi naganing arantagim sini'. A adi ning guk mo' tanga naurota' wa adi naganing arantagim sini' mo' irota'. ");
INSERT INTO uvh_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Beng sini' aming ka naga naura mamareng fam ka ana uuk ning firi ugari ningda'ning wara'guk mo' sanga ira naurota' wa naganing arantagim sini' mo' irota', mokngang. Wara' aming ka naga nauronga wa adi tim ka mamareng a kagaya udi girisa' u bimbemning ningwaraga' kafakafa sura naknga ning tanga inga' naurota'. ");
INSERT INTO uvh_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Ka sidi kadapmang ka aming wari yak kareng manonga titining waraga' sukanting. Wa ning, aming nua'ni wari yak kareng manonga wa adi tim ka adining uningkim mambong waraga' kafakafa mera tanga kadidimota'. Adining uningkim mambong wa yak ka ningwara' udi girisa' manga tipmiri ning wa ma mokngang ning u tanga kadidimanga inga' tota' wa adi didimeng girisa' tanga tipmirota'. ");
INSERT INTO uvh_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","A adi kafakafa guk mo' sura parap marara mama sa' tota' wa simen sa' garota' ganang uningkim wari bingaminga adi tipmarak ga' nafek tanga kagabi tota'. ");
INSERT INTO uvh_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Ning tinga amine fam wari u kanga anikige tanga ning tonting, magayam adi tangkunang guk naknga tipmarara' wa indeng tipmirira' wa. ");
INSERT INTO uvh_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Abanga nua'ni ka ning, aming girii king nua'ni wari king nua'nining arantagim guk ami' titiga' touta'. Ka adining soldia arantagim wa mimeng sini' mo' ten tausen ningsa', a king nua'nining soldia arantagim wa usap sini' ka tuwenti tausen ning. Wara' adi adining soldia arantagim ka mimeng mo' u yangkara sa' mo' tota'. Mokngang, king adi tim ka kafakafa ning surota', o king ka wa adining soldia wa arantagim girii sini' a naganing soldia ya arantagim girii sini' mo' wara' indi arantagim ka wara'siguk ami' titi wa indi iirafik ning guk mokngang unda'. ");
INSERT INTO uvh_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Ka king ka ami' tipmarak ga' touta' wari mokngang ning sura wa adi king nua'ni wari ami'ga' ko mo' abuinga ganang adi kane aming fam urapsa' yangkareinga anga king nua'ni wara'guk midi tonga naknga adining kaba u tipkuranga ami' guk mo' tinting. ");
INSERT INTO uvh_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Ka aming sidindu' ningsa', sidi naga nauronga wa sidining amise a mambongsi' tangkunasi u iibi sini' mo' tanga nawakanting wa sidi naganing arantagim sini' ning mo' ikanting ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Ka sidi firing undu' kuma'sa' tanga yabiting. Firing wa nana ganang kura tipmarandanga nana ningwara'ning. Ka inga' firing wari timinira tanga marangni wari gisifa tota' ganang wa aming adi firing ning marang u nua'bu tipkadofi ning guk mokngang. ");
INSERT INTO uvh_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Abanga firing ka ningwara' wa kane nua'ni ka feng tipkarenda waraga' kamaganang kuguk ning guk mokngang. Wara' firing wari timinira tanga marangni wari gisifa tinga wa kaneni guk mokngang ning yapma sigesa' kura yugukiting. Ka naktangka aming sidi midi ka waraga' sura naktangka tangkunang tanga ikanting. Sidi naktangka kabinga firing marang guk mokngang ningda'ning sigesa' ma ikni' ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Ka aming takis mamanggesi guk ka aming sansaramik titisi ka Farisi wari kadapmang mumungguk titisi ning yapma bibi' nakiamiaging wari Jisas ning midi nakonga Jisas ganang ungung abiging. ");
INSERT INTO uvh_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Ka Farisi arantagim a Juda ning kadapmang tapni ning sasuk aming wari Jisas wari aming kadagasi u yangkagare guk mo' tugu' u kanga anasa' ning toging, ai fikifiki adi aming kadagang titisi wa yangkagare guk mo' tanga ngingeng kubap mera adisigok nana kubap nana ning guk wa indining fatara' ning toging. ");
INSERT INTO uvh_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Ka Jisas wari Farisi wari midi ka u toging u yapma midi tipfara nua'ni ning tiamgu', ");
INSERT INTO uvh_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","wa ning, aming nua'ni adi maga sipsip 100 ning ikngamting. Ka kubanik wari kapmo' surofara anga sebota'. Ka tuang wari sipsip u indangira yabota' ka kubanik wara'guk mokngang u kanga wa adi a kureng manga' ning touta' wa. Mokngang adi kubaniksa' u urosinga wa uring fungyanga base tanga wena tanga yarota'. Wenanga anganga katua sa' tota'. ");
INSERT INTO uvh_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Katuanga kaba karengsa' naknga ning tanga sipsip u bema barungnanga yongga' tubobu mabota'. ");
INSERT INTO uvh_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Ababanga yongganang i kadofinga adining amine a aming fam ka yong wara'ning dabiksa' u katiana fabanga kukyapma ning inota', maga urang sasu'negu' irosinga fuwenetik wa kami kuma' anga katuanga bema abarik yang. Wara' indi dabiksa' kabakni' karengsa' naknga tangsana tanga defakantam. ");
INSERT INTO uvh_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Ka beng sini' torik kadapmang ka u titing ningsa' ka Anutuning yongganang wa kunim aming adindu' ningsa' titing. Kunim aming adi aming kamaganangni ka kadapmang didimeng giri kuma' tanga ira kadagang guk mokngang ning ikiting wara'siga' wa adi kabaksi' kareng kabi'gi' nakiting. A aming ka tim kadapmang kadagang tanga ira kadagang guk ikita' wari kaba tubobu tipfaranga inga' kadapmang kareng ubu tota' waraga' wa kunim aming adi kabaksi' kareng siamo' naknga mesisiringa girii beng sini' titing ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Abanga nua'ni ka ning, taming nua'ni adi uningkim mambongni ten guk ka nua'ni wari mangfangam tota', wa taming adi waraga' sura kamang garinga sumu tanga wena tangkunang sini' fatota'. Tanga anganga uningkim u katuanga bema tanga wa kaba karengsa' nakota'. ");
INSERT INTO uvh_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Ning tanga tangsana kabi' tanga ananing amine a aming fam ka yong wara'ni u katiana ning inota', uningkim kubanik urang mangfanamgu' wa kami kuma' katuarik wara' naganing amine sidi abubu tanga nagok kabakni' karengsa' naknga tangsana tirik i mera nantam. Ning ina tanga marekanting. ");
INSERT INTO uvh_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Ka Anutuning yongganang undu' ningsa' titing. Anutuning kunung aming ensel adi aming ka tim kadagang tota' wari kaba faranga tubobu abota' waraga' wa kabaksi' kareng girii sini' nakiting ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Ka Jisas wari midi tipfara ka tim kuma' tiamgu' wara'ning unggung ka nua'bu ning yanggu', ka aming nua'ni adi mindine fama' guk. ");
INSERT INTO uvh_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Ka mindingni mandangni wari babangsi' u ning anota', ai sibeng gu inga' indita' guning mambong u sabaranim ga' urang togung wa kami sabaranima nagata' undu' nanam titiga' nakarik. Ka babangsi' adi mindingni ning midi u naknga aiga tanga mindine fama'ga' mambong u sabaraimota'. ");
INSERT INTO uvh_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Ka mindingni mandangni adi beni wari mambong u amiinga manggaknanga kabi'sini' sa' iya' bene kuyane u ibinga marara yong kamani ironga mauta'. Anga ira beni ga' suknakubenga kadapmang kadagang sansaramik tanga uningkim mambong u waraga' kuma' tipmirisasu'nanga sigesa' irota'. ");
INSERT INTO uvh_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Ka adi mambong kabi'guk mokngang sigesa' irota' wara'ganang ka kama tugumung wari yong ka wara'ganang u kadofota'. Ka adi uningkim mambong wa kuma' kayosasu'nota' wara' adi nana napa' tona ga' nafek sini' tanga sigesa' irota'. ");
INSERT INTO uvh_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Ning tanga nasi' notik ning tonga aming kama unggungni nua'ni u anga kainga aming ka wari adining maga yaptatorangam wara'ning kane kadagang ga' nagira tonga kamota'. Ning tanga adi kane mumungguk kadagang u tanga ira dama undu' maga guk unggung dabik dekiaging. ");
INSERT INTO uvh_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","17","Ka adi kane kadagang u tanga irota' ganang wa aming uwa ni guk mokngang anapmo' kubaniksa' irota'. Ka nana guk mokngang wara' adi segi kagaya sini' naknga maga ning nana kugo' udi manggara na titiga'sa' fiabota'. Ka aming ka ni nana kabi'guk mo' amiinga nauta'. Adi nafek ningsa' tanga ira anganga ananing iik kadagang waraga' sura tubobu suknatama ning touta', ai na aming mana pipeng ba. Nasi'ga' tanga na kama kamani i abanga saba kabak ningda'ning ira kane kadagang tanga mambong ga' nafera a tugumung ira sekna kagaya naknga itik. Sibeng ning kane aming dabiksa' adi nana nibek tanga karengsa' iking a na ananing mindingni sini' ka na iik kadagang ba tirik. ");
INSERT INTO uvh_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Ningwara' kami na kama ka i kabinga sibeng ning yongganangga' tubobu mautik. Anga sibeng ganang do kadofinga ning anotik ga', o sibeng na Anutuganang kadagang tuguk a guganang undu' kadagang tuguk. ");
INSERT INTO uvh_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Wara' naga ningyara' wari guning sabaga kareng ka tim urang yaguk ningwara' nua'bu iik ning guk mokngang. Gu kane aming sige slev ningsa' ubu napma bema nipmiinga tagama irotik ning toutik. ");
INSERT INTO uvh_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Ning tonga ning tanga marara yong ka u kabinga beni kaunga tubobu mauta'. Anganga yongganang do kadofinga beni ning yak ganang sini' ko mo' kadofinga kamani ko ara mauta' ganang ka beni wari tonga kanga bibiri' naknga urapsa' unara anga bedirik tota'. Bedirira mak kanga karota'. ");
INSERT INTO uvh_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Ka mindingni wari ning anota', o sibeng na guning sabaga ka tim urang ikaruguk ning nua'bu mo' irotik. Mokngang na Anutu ganang a gu ganang undu' kadagang girii kuma' tuguk wara' guning sabaga ning nua' mo' napma nanotang. ");
INSERT INTO uvh_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Ka mokngang, beni adi irosi tanga fikifiki adining nonda guk mo' kanga ira auta' wara' adi bibiri' naknga midi ka mindingni wari anota' u nakngam guk mo' tanga adining kane aming u ning katianota', ai sidi urapsa' unara anga kwi' kangkama inga'ni guk ka su a tungkum kareng ka gi' dasinga kuguk fideing wara'guk manggara fabanga ipmangamni'. ");
INSERT INTO uvh_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Ning tanga bulmakau uyamang bokni sa' ubu anga ura bema abani'. Kabakni' karengsa' nakem wara' indi dabiksa' tangsana tanga defakantam. ");
INSERT INTO uvh_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Beng sini' naganing sabana ka ya timinggi' sini' nibigu' wara' na irositangka sini' tanga ira wadigi' kuma' udep kumara nibigu' ning tonga ikitik. Ka adi ka' giri abanga nabinga tubobu kuma' bemnarik wara' indi kabakni' karengsa' nakantam. Ning ina kafakafa tangama bema tonga kaminga tangsana tanga mesisiringa girii tanga marafakanting. ");
INSERT INTO uvh_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Ka beni wari mindingni u bema kaminanga tangsana tanga marafakanting ganang ka mindingni tangandang udi feng ganang do fenganga' yongga' tubobu mabota'. Abanga yongganang u kadofinga ning tanga nakota' ka beni ning yak iyung bane ganang wa mime bibiri' ka kabaksi' kareng naknga tutugu ning u tonga faukanting wari' fakadofi sa' tota'. ");
INSERT INTO uvh_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","U naknga beni ning kane aming nua'ni katingana ning anikauta', ai mime ka sibeng ning yak ganang do wa nasi' tanga fatoing a. ");
INSERT INTO uvh_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Ka kane aming wari ning anota', mo' kuyaga urang mugogu' wari tubobu abanga kadofara' kanga babangga wari ka' tubobu bema kaminanga kaba karengsa' naknga bulmakau bokni sa' ura tangsana tanga mesisiringa tanga wa mime u mera fatoyam wang. ");
INSERT INTO uvh_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Ka mindingni tangandang adi midi ka u naknga kaba kadagang naknga yak iyung wara'guk mo' anga amota', adi fugangsa' anga fideuta'. Ka beni wari fugangsa' anga fideuta' u kanga afanga midi kafakafa anididimanga yak iyung u amama ga' anota'. ");
INSERT INTO uvh_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Ka mokngang, mindingni adi barap tangkunang sini' tota' wara' adi beni u ning anota', sibeng na gugok ingging ira guning kane aming sige slev ningda'ning ira kane girii kama paramu' sini' tagama ira abarik. Abanga na guning midi undu' karangkang guk mo' titik mokngang sini'. Ka na kane girii ka ning u tagama ira abutik waraga' wa sibeng gu nasi'guk namitang. Abanga gu naga kabakna kareng naknga naganing amine guk tangsana titiga' keng ni namgung wa indeng, wara' gu kami tangsana u tanga defatang. ");
INSERT INTO uvh_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Ka sabaga ka u abuinga kanga tangamarang wa adi kane guk mo' tagamita'. Mokngang, adi taming kadagasi guk kadapmang kadagang sansaramik tanga uningkim mambong girii amigung u sansaramik sa' kayosasu'nanga tipmiringa abara'. Ka gu adita' kabaka kareng naknga marara maga boknisa' ba ura tanga sangamarang. ");
INSERT INTO uvh_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","32","Ka beni wari ning anota', o ning nake' gu fikifiki nagok ingging kubap kuma' ikitamuk wara' naning napa'napa' wa guning sa'. A kuyaga ya timinggi' kuma' urang indibinga mugogu' irosinga ikitam wang. Indi wadigi' kuma' ba kumogu' ning tonga irosinga ikitam. Ka adi kami ka' tubobu abanga kadofiinga bemnem wara' gu a naga indi dabiksa' indi kabakni' kareng sini' naknga mesisiringa girii tantamuk ning anota'. ");
INSERT INTO uvh_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Ka Jisas wari arantagimni ga' midi tipfaraim nua'ni ka ning tiamgu'. Wa ning, aming kangasi nua'ni adi adining kane u katatorangam waraga' kane aming nua'ni ka tim iyak aming ning kamiinga tanga irota'. Ka adi kane kafakafa sini' mo' tota' u kanga kane aming sige fam wari aming girii u ning anga aninting, ai girii guning kane katatora ning aming ka wa kane kafakafa sa' mo' fatara'. Mokngang adi guning mambong fam ka sige guk kura fayuguta'. ");
INSERT INTO uvh_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Ka aming girii kane tuang wari midi ka u naknga kane katatora aming u katingana ning anota', na gu naganing kane kafakafa mo' katatoranga tarang wara'ning midi udi kuma'sa' nakarik wara' na gigibi totik. Gu naganing kane nua'bu mo' totang. Ka naganing napa'napa' mambong wara'ning dinau ka umpang ganang yora fakabitang u anga bemnama abe', kanga tipdidima totik. ");
INSERT INTO uvh_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Ka kane katatora aming adi aming girii wari anikagare titiga' anota' u naknga sasuk mimeng tanga ning touta', ai aming girii udi nangkagare tonga tora' ka na indining totik. Na feng kane titining tangkunang guk mokngang. Abanga na sige ikinga amane wari'sa' yotangkanap undu' megang wara' na adi nangkagare tinga iik waraga' kadapmang kareng nua'ni ka ning unda' totik. ");
INSERT INTO uvh_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Wa i anga aming fam ka girii ganang dinau guk u urapsa' yotangkaima adisining dinausi' u dibing ka udaim totik. Na ning totik wara' naga sige ikinga wa aming ka wari yotangkanapni'. ");
INSERT INTO uvh_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Ning tonga urapsa' anga aming ka tim girii ganang mambong dinau guk u katiana ning yangkanga yarota', gu naganing girii ganang dinau wa indining tugung. ");
INSERT INTO uvh_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Ka aming nua'ni wari ning anota', na adi ganang dinau wa sana titining wel kandang ka 100 ning manggeguk wari fidera'. Ka kane katatora aming wari ning anota', ka guning dinau wara'ning wap wa yang. Gu 100 ya ifafe tanga 50 ningsa' ubu yore' ning aniinga tota'. ");
INSERT INTO uvh_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Ning tanga aming nua'ni ubu anigauta', a gu wa naganing girii ganang dinau wa indining tugung. Ka aming wari ning touta', naganing dinau wa wit bek 100 ning aninga manggeguk fidera'. Ka kane katatora aming wari ning anota', ningwara' gu 100 i ifafenga 80 ningsa' ubu yore'. Ning tanga adi aming kubanik kubanik dabiksa' ka adining girii ganang dinau guk udi yotangkayap tanga ningsa' tiama yarota'. ");
INSERT INTO uvh_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Ka aming girii kane tuang adi kane aming kadagang u kuma' anikagareuta'. Ka kane aming wari ananing fugu yotangka waraga' sura kadapmang kareng urapsa' kuma' tanota' u kanga aming girii wari ning touta', o adi aming kadagang de ka adi sasukni kareng guk ba kuma' nakedanga tara' ning touta'. Ka beng sini' aming kamaganangni kabi'mo' adi anasining marek kareng ka fuksi'ning u katua waraga' sura kane tangkunang tanga kadapmang kuni' kuni' siamo' nakedanga titing. A aming ka Anutuning kane suronga tanga ikiting adi kane tangkunang sini' ka aming kamaganangni wari u titing ning guk mo' titing. Mokngang adi tabarataraka da'ning titing wara' adi aming kamaganangni ning kane tangkunang wari irafikita' ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Ning ina ning tanga ning yanggu', ka sidi uningkim mambong kamaganangni wara'guk iking wa sidi sidaning fuksi' yotangka ga'sa' mo' sura kayonting. Mokngang sidi aming fam u yotangkayabinga sidigok kabaksi' kubaniksa' kufara iik wara'ning kane undu' titing. Ning tinga inga' sidining iiksi' wari bibi' to' ganang wa Anutu wari sidining kadapmang kareng u kanga sidita' kaba karengsa' naknga kafakafa tasapma manggara adining yong kareng ganang kuksabinga ikni'. ");
INSERT INTO uvh_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Abanga kadapmang nua'ni ka ning, aming ka ananing nasi' kane kabasi' u kafakafa sa' kuma' katatoranga tanga irota' wa inga' kane girii kabingamting undu' kafakafa sa' tota'. A aming ka tim ananing nasi' kane kabasi'ganang didimeng mo' tanga ira midi mandaga' a kuba ning guk tanga irota' wa inga' aming wari kane girii ni titiga' kaminting ganang undu' adi kadapmang kadagang ka unggungsa' yaranga tanga kane u kafakafa guk mo' katatoranga tota' ning titing. ");
INSERT INTO uvh_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Ka Anutu ganang iikning undu' ningsa'. Sidi napa' mambong kamaganangni guk ira aming fam u kafakafa mo' yotangkayapmanting ganang ka Anutu wari adining mini unggo u samota' wa sidi kadapmang didimeng undu' mo' yaranga tinting, mokngang. ");
INSERT INTO uvh_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Abanga sidi aming nua'ni ning kane kafakafa guk mo' katatoranga tinting wa Anutu adi napa' kigineng ni ka sida sini' katatoranga tanga iik wara'ning undu' mo' samota'. ");
INSERT INTO uvh_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Beng sini' aming ka aming girisi fama' ning kane ira tiamiting adi kabaksi' kubaniksa' guk mo' kufara tiamiting. Mokngang adi girini nua'ni ga' wa kaba guk kufara adita' siamo' naknga tangamota' a aming girii nua'ni ga' wa mokngang, manda da'ning ukngama usingsa' sige fatangamota' ning titing. Ka sidindu' ningsa', sidi uningkim mambong kamaganangni ga'sa' siamo' nakanting wa sidi napa' kigineng sini' ka Anutu girii kareng waraga' kabaksi' kubaniksa' kufara ninak ning guk mokngang ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Ka Farisi arantagim adi uningkim mambong kamaganangni waraga' siamo' naknga ikiaging. Wara' adi midi ka Jisas wari uningkim mambong kamaganangni ga' siamo' mo' ninak wara'ning togu' u naknga kabaksi' kadagang naknga Jisas u anikige tiging. ");
INSERT INTO uvh_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Ka Jisas wari ning yanggu', a aming ka sidi napa' kareng aming ning dasi'ganang sireng tinga aming wari karengsa' ning sapma sidining wap bema ara waraga'sa' fanaking. Ka Anutu adi aming ning wap bema ara wara'ning wa kadapmang nua'ni tita'. Wa ning, napa' ka aming wari kareng ning kanga wap bema areting wa Anutu adi napa' sigening ning kata' wara' Anutu adi sidining kadagang ka sidaning wap bema ara wara'ning ka kabaksi'ganang ita' wa kuma'sa' kara'. ");
INSERT INTO uvh_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Ka kadapmang ka aming wari Anutuganang anga iik wara'ning wa tim Jon Baptis wari ko mo' kadofigu' u tanga wa Moses ning midi tang guk ka profet ning midi guk wari yagumu'. Ka inga' kama ka Jon Baptis wari kadofinga midi kareng ka aming wari Anutuning bining ganang iik wari kagadofi wara'ning u ituagu' u tanga ababanga kami naga kadofinga itawarik yara'ganang undu' aming kabi'mo' wari midi ka u naknga Anutuning bining ganang iikga'sa' naknga aming wari faba iming ganang urap tanga mamok ning tonga kura' urakayong guk urang tanga mamoting ningda'ning tanga mabing. ");
INSERT INTO uvh_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Ka na midi ka u torik wa Moses ning kadapmang tang u tipmikurita wara'ning mo' sura torik. Mokngang, Moses ning kadapmang tang wa Anutuning napa' kigineng ka bibi' titining guk mokngang. Beng sini' inga' kama kunim wari wadigi' biwa' ganang wa Moses ning kadapmang tang wara'ning midi dibing fam dabiksa' wa ni ka bibi' kabi'sini' guk mo' to'ga'. Mokngang, midi wara'ning dabiksa' wa tangkunang ningsa' ko ira awa' ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Ka Jisas wari kadapmang ka ufi imaraming tanga iikning waraga' midi nua'ni ka ning yanggu', ka aming ka tamni kabinga taming nua'ni sanota' wa adi ufi imaraming tanga iik wara'ning kadapmang didimeng u tipkadanga kadagang tara'. Abanga aming ka taming ka kadagang tinga ufini wari kagabi tota' u sanota' undu' kadagang tara' ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Ka Jisas wari kadapmang ka aming wari kangasi sini' tanga ira aming nua'ni yotangka ga' sasuk guk mo' titi waraga' midi tipfara ka ning tiamgu', ka aming kangasi nua'ni adi fikifiki kwi' a tasaseni udi inga'ni inga'ni karesi karesi sini'sa' faipmota'. Abanga adi nana undu' fikifiki karesi karesisa' nanga irota'. ");
INSERT INTO uvh_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Ka tatafak aming kadagang nua'ni fugu udi adi' ka wapni Lasaras undu' unggung irota'. ");
INSERT INTO uvh_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Ka fikifiki Lasaras adi segi kagaya naknga aming kangasi wari nana dibing nanga kwasina u manggara nana waraga' sura anga aming kangasi wara'ning yak iming ganang mera fatota', Ning tinga kugwang wari adining udi fugu ganang u fipnanga fiaranting. ");
INSERT INTO uvh_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Ning tanga Lasaras adi marek kadaga ningsa' tanga ira anganga inga' kungkumak tota'. Kumakinga Anutuning kuning aming ensel wari bema tonga yong kareng ka papangni Ebraham wari irota' wara'ganang kaminga Ebraham guk kunim ning tangsana girii wara'ning bining ganang mera nana nabek a napa'ga' nafek guk mo' ubu tanga irota'. Ka inga' aming kangasi ka undu' kungkumak tinga unafarafi tinting. ");
INSERT INTO uvh_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Ka aming kangasi adi kungkumak tota' ganang wa kudip kadagang ganang anga ira fikifiki kagaya girii ningsa' bema ira auta'. Adi kagaya u bema ira anganga ning tanga tonga kauta' ka papangni Ebraham udi aming kadagang Lasaras urang wara'guk yong kareng ganang marek kugurang kareng tanga kamani sini' marafakantamu'. ");
INSERT INTO uvh_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","U kanga yotangkangam titiga' sura ku ning tonga katinganota', o papa Ebraham gu bibiri' napma yotangkanam te', fukna kagaya ya mokngangsa' ba nakarik. Gu Lasaras u anigaranaminga afanga kafong ama ganang farafinga mambapna i susungenaminga kugurang kabi'ning guk nakok. ");
INSERT INTO uvh_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Ka Ebraham wari ning anota', o papana bibiri' sini' gu kafakafa sura nakedanga toya'. Tim gu ka' ira kamaganang ko yagung u tanga wa gu napa' fuka yotangka ning wa karesi karesisa' tanga nana nabek ning tanga kabaka kareng guksa' ikarugung. A Lasaras adi tasase kadagasi a nana ga' nafek ning tanga ira fikifiki adi kaba mamareng girii guk itarugu'. Ka kami yong ka yara'ganang wa adi marek kareng sini' tanga kaba ararangeng karengsa' ubu naknga ita'. A aming ka tim kabaka kareng guk naknga yagung gubu kabaka mamareng a kagaya girii bema itang. ");
INSERT INTO uvh_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Abanga napa' nua'ni ka indi a sidi ning tanga bining ganang wa Anutu wari kama sam girii ka bagi tangkunang ning kuma' kamigu' wara' indi u anga sap a sidi abanga nip ning ga' ning tonga tantam udi kadapmang guk mokngang sini' ning anota'. ");
INSERT INTO uvh_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Ka aming kangasi wari ning touta', o bibiri' sini' papa, ningwara' gu Lasaras u anigareinga adi naganing yongganang do anga naganing kuyane faiv ning ka ka' ko iking u kudip kadagang ning kagaya girii yaraga' yangnatamota'. ");
INSERT INTO uvh_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Ning tinga adi kabaksi' faranga kadagang u kabinga karengsa' ikanting wara' adi inga' kagaya girii yara'guk mo' bemni' ning touta'. ");
INSERT INTO uvh_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Ka Ebraham wari ning anota', ka gu kuyage ga' sura torang udi giri. Ka adi Moses ning midi a profet ning midi wara'guk kuma' ikiting wara' adi u kuma' kanga nakedanga tanga ikanting. ");
INSERT INTO uvh_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Ka aming kangasi wari anota', o papa, Moses a profet ning midi udi giri ikita' de ka mokngang. Adi kafakafa guk mo' nakiting. Wara' aming nua'ni ka kungkumak tanga napa' i kuma' kadidimota' wari tubobu marara anga yangdidima sini' tota' wa giri, adi mutu tanga anasining iiksi' u tipdidimanting. ");
INSERT INTO uvh_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Ka Ebraham wari ning anota', ka adi Moses a profet ning midi wa kuma'sa' kating, ka adi kafakafa yara waraga' bibi' naknga ikiting. Ka aming nua'ni wari kungkumak tanga napa' u kasasu'nanga marara tubobu anga inota' undu' adi nakngam guk mo' tinting. Mokngang ning anota' ning yanggu' Jisas wari. ");
INSERT INTO uvh_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Ka Jisas wari arantagimni u ning yanggu', ka beng sini' aming sidi siramikinga kadagang titi wara'ning wa kadapmang kuni' kuni' kabi'mo' kadofisamarota' de. Ka aming ka kadagang ka aming nua'ni kadapmang kadagang titiga' anidideinga tota' wa adi inga' kagaya girii beng sini' bemo'ga'. ");
INSERT INTO uvh_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Aming ka ningwara' wari ira naktangka aming ka sasuksi' tangkunang guk mokngang u iramikinga adi urapsa' mangfanga kadagang tanga kadaga ma tini' wara' aming ka ningwara' wa ka' ko mo' kabinga irota', kungkumak sa' tota'. Ka aming ka kadapmang ka ningwara' u tota' wa adi kadagang girii sini' tara' wara' sidi kadapmang u urapsa' udangama bimbem tanga uningkim mamareng girii bema kadare ganang tofinga gwang ganang kuragamainga wadigi' biwata'. Ka sidi kadapmang kadagang ka ningwara' u mo' titi waraga' wa kafakafa suktangkanga ikanting. ");
INSERT INTO uvh_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Ka sidi amisi' nua'ni wari kadagang tinga wa aninga tipdidima tinting. Ka adi sidining midi u naknga kaba faranga kadagang u kabiinga wa sidindu' adining kadagang waraga' suknakubengam tinting. ");
INSERT INTO uvh_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Ka kadagang suknakubengam wara'ning wa kubaniksa' tota' ungungsa' mo' suknakubengamotang. Mokngang wa kuyaga wari guganang kadagang fikifiki tanga kaba tubobu faranga adining kadagang u suknakubengam waraga' ka sidii kubanik ganang wa seven ning sini' ganota' undu' girisa' suknakubengamotang ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Ka Jisas ning aposel arantagim 12 wari Jisas ning midi ka u naknga Jisas u ning aniging, ka girii indi naktangka tang guk mokngang ka gu yotangkanip tinga indi naktangka kigineng guk iikga' nakem. ");
INSERT INTO uvh_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Ka Jisas wari ning yanggu', beng sini' kigineng iik wa aming ka naktangkani tangkunang guk warisa' kigineng guk iikning mo'. Sidindu' kuma'sa' naking, firi mindip fam wa kabasi' sini' de ka inga' wari girii girauta'. Ka aming ka naktangkani kabasi'sini' ka mindip kabasi' ka ningwara' guk irota' undu' kane kareng tangkunang girisa' tota'. Adi kane girii ka firi girii yari ki guk tamara anga gwang bining do kadofinga marek waraga' touta' wa firi udi didimengsa' beng guksa' kuma' tamara anga marerota' kanting ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Ka sidi sasuk ka aming girisi ka kane aming slev guk wari titing waraga' sukni'. Wa ning, aming girii adi kane aming wari kane ka feng iirop ning kama dindini wa ma maga yaptatora wara'ning u tanga anganga kibiri yak ganangga' tubobu mabota' wa aming girii adi kagabi sa' tinga nana nanga mengkura urapsa' mo' tota'. ");
INSERT INTO uvh_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Mokngang, aming girii adi kane aming wari yak ganang u abanga kadofiinga wa ning anota', ai gu tim ka nagata' nana u sanama iya' naga nana a ama u mera nainga gu inga' kuma' sanga naya'. ");
INSERT INTO uvh_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Ning tinga kane aming adi girini ning midi u naknga kaba tiptangkanga kane u titisa' tota'. Ka kane aming sige slev adi kane girii ka ning u tangamota' ka girini wari o asekna karengsa' tanamarang ning guk mo' anota' wa adi waraga' sasuk mimeng guk mo' tota'. Mokngang, adi kane aming sige slev wara' adi ananing kane ningsa' kanga tota' ning titing. ");
INSERT INTO uvh_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Ka sidindu' ningsa' sidi Anutuning kane aming sige slev ning iking wara' sidi nasi' kane ka Anutu wari sidi titiga' kuma' sura samira' u tonga wa sidi o indi kane u tantam ganang wa Anutu wari indining wap bema arota' ning sura kane u tinting. Mokngang sidi ning sura tinting, a indi kane amingsa', indi kane u titiga' bibi' mo' nakem, indi titisa' tantam. Ning tonga kane u tasasu'na waraga'sa' sura tanga ira au sa' tinting ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Ka Jisas wari Jerusalem ga' anga kadapmang nua'ni ka Sameria a Galili tara' mayaging u yaranga mugogu'. ");
INSERT INTO uvh_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Anganga yong nua'ni ganang kagadofi ga' dudure tanga yapku' ka aming 10 ning ka bagana tangkunang lepa kasi' kafasi' ki natugupmuresi guk wari abiging. Abanga Jisas wari agu' u kuma' tabang kanga bagana kadagang waraga' tanga kamani sa' adenga ");
INSERT INTO uvh_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","ku ning tabanga katinganging, o girii Jisas gu nipbubure tanga yotangkanip te'. ");
INSERT INTO uvh_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Ka Jisas wari adisining ku u naknga fonga yapma ning yanggu', girisa' kuma' yotangkasabarik. Ka sidi i anga Juda indining kadapmang ka bagana aming wari tubobu kuma' karenda wara'ning titam u yaranga pris ganang kadofinga fuksi' u yangtintingneinga sapmanting. ");
INSERT INTO uvh_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Ning ininga aramugoging. Anga yapking ka fuksi' udi tubobu kuma' karendayapking. U kanga aming nua'ni adi bagana kadagang wari kaga'sa' kabinga aming karengsa' tubobu yagu' waraga' sura Jisas ga' kaba karengsa' naknga amine fam u ibinga Jisas kaunga tubobu abanga Anutuning wap bema aranga mesisiringa tang tanga abugu'. ");
INSERT INTO uvh_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Tanga ababanga Jisas ganang kadofinga Jisas ning kayong ganang u mang mungkupnanga mera Jisas u asekna ning aninga adining wap bema aregu'. Ka aming ka tubobu u abugu' wa Judani mo', Sameriani aming wari abugu'. ");
INSERT INTO uvh_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","18","Ka Jisas wari nakeda tanga tubobu abanga adining wap bema aregu' u kanga ning togu', na aming bagana kadagang guk wa ten ning dabiksa' ifikarendangak ka nakeda tanga tubobu wa aming kubaniksa' ka yong nua'nini gapmo' ba abarang. Aming dabik ka nain ning wa indeng anga maing. Nagabu Anutuga' kabaksi' kareng naknga mesisiringa wa sidi dabik udep abanga tangamting ning tonga aderik. ");
INSERT INTO uvh_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Ning tonga ning tanga aming u ning anigu', giri, gu nagata' naktangka tarang warisa' tanga kami wadigi' kuma' karendarang. Mamarak tanga yakangga' mugo te'. ");
INSERT INTO uvh_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Ka Farisi arantagim wari Jisas u ning abanga anikaging, ai kama ka Anutu wari aming dabik indi manggaknipma fonga adining bining ganangsa' kuknipma niptatoreinga gi' iik wara'ning urang wa dari kadofo'ga'. Ka Jisas wari ning yanggu', kama ka Anutu wari aming adining bining ganang kukyapma yaptatora wara'ning wa aming wari dasi' wari sareng sini' kaga ning guk mokngang, wa kapmo'sa' ikita'. ");
INSERT INTO uvh_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Kama ka wa sarengsa' adeinga aming wari kanga ai i adera' yang a do adera' wang ning tutugu ning guk mokngang. Beng guk sini' sanirik Anutuning bining wa sidining bining ganang ingging kuma' kadofinga ita' ka sidi kigeda guk mo' tanga iking ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Ning tanga Jisas wari ananing arantagimni ubu yanggu', ka inga' na sidigok mo' ikinga sidi naganing nondakna narosi tanga ira Amingning Tim Iyak naga nua'bu abanga saptatora waraga' siamo' naknga ikni', ka mokngang na urap mo' abok. ");
INSERT INTO uvh_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Ka kama ka naga urap mo' abok wara'ganang wa aming fam wari ai', Jisas urang udi tubo ning tara' kuma' abara'. Wa ma ita' ingging kuma' abara' yang ning tonga yarani'. Ka sidi u naknga nagata' sura bengsa' ba ning tonga mo' marara tini', mokngang. ");
INSERT INTO uvh_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Kama ka Amingning Tim Iyak naga abubu wara'ning wa kadapmang ka tifik wari kama kama dabik kaga' urapsa' urang diokinga kating ningsa' tanga kaga' urapsa' kadofok ga'. ");
INSERT INTO uvh_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Ka tim ka na kagaya girii bemotik. Ning tinga aming arantagim ka i iking yari nagata' bibi' naknga manda uknama ikni'ga'. ");
INSERT INTO uvh_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Ka kama ka Amingning Tim Iyak naga abubu wara'ning wa kadapmang ka timinggi' Noa wari yagu' u tanga ka aming wari kama ka Anutu wari tagagareyap ning wari kagadofi waraga' suknakubenga tanga ikinga urang kadofiaminga tiging ningsa' kadofo'ga'. ");
INSERT INTO uvh_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Kama ka u tanga wa ama gibung girii wari kadofonga tinga Noa wari waraga' sura sip fatarugu' wa ami taming adi suknakube sa' tanga nana nasi' kareng nanga marek kareng tanga taming kafauwe ning unggungsa' tanga ira aging. Ira anganga ama gibung girii wari kadofiinga Noa kurene wari sip iyung amoinga adi bisasu'na sa' tiging. ");
INSERT INTO uvh_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Abanga tim Lot wari yong kadagang Sodom u itarugu' u tanga undu' adi ningsa' tiging. Kudip wari yong ka u dada ga' dudure kuma' tugu', ka yong wara'ning aming adi wara'guk mo' sura marek kareng tanga nana nasi' kareng nanga a maket titi a mambong inga'ni tona a feng kane a yak inga'ni kareng mana ning unggungsa' tanga ira aging. ");
INSERT INTO uvh_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Tanga ira anganga kama ka Lot wari Sodom yong u kabinga bima tanga mugogu' wara'ganangsa' ka Anutu wari kudip guk ka uningkim kuguduguk guk u kwasineinga Sodom yong wari danga dabiksa' bisasu'neging. ");
INSERT INTO uvh_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Ka kama ka Amingning Tim Iyak naga tubobu abok wara'ning undu' ningsa' kadofiinga kani'ga'. Aming kabi'mo' wari mambong ga'sa' sura suknakube sa' kuma' tanga ikni' wara'ganang kadofok ga'. ");
INSERT INTO uvh_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Ka kama ka naga abok wara'ganang wa ning tini', aming ka yak fugang marero' adi napa' u kanga parap marara mambongni bemnonga iyung bane mo' amo'. Abanga aming ka feng ganang anga fato' adindu' mambong ni bemnotik ning tonga yongganangga' tubobu mo' unara abo'. Mokngang adi tubosa' bimanga mawa'. ");
INSERT INTO uvh_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Ka wara'ning wa kadapmang ka tim Lot wari urang tugu' waraga' sukanting. Lot ning tamni adi kama kadagang wari kadofiinga bima tanga abanga mambongni tangkunasi fam waraga' sura yong u tubobu faranga kanga kadaga wadigi' tugu'. ");
INSERT INTO uvh_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Ka adi u tanga kadagagu' ningsa' ka aming ka napa' mambong ka fugu yotangka ning waraga'sa' sura fikifiki wara'ning kanesa' tanga irota' wa inga' adi fakara tanga kadaga to'ga'. A aming ka kadapmang ka ananing fugu yotangka ning waraga'sa' sasuk ning u kabinga aming fam yotangkayap ga' tanga mamareng girii bema kumarota' wa adi inga' iik kareng ka ka' ningsa' iikning u bema iro'. ");
INSERT INTO uvh_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Beng sini' urang torik, kama ka naga abok wara'ganang wa na kadapmang nua'ni ka ning tok, aming fama' ka basing kubaniksa' ganang deiakdemu' wa na kubaniksa' bemnanga kubanik ka unggung kabok. ");
INSERT INTO uvh_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Abanga taming fama' ka sanggom mera fakarakdemu' undu' ningsa', na kubaniksa' bema nua'ni wa kagabi tok. ");
INSERT INTO uvh_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","A aming fama' ka feng kane fatademu' undu' na kubaniksa' bema nua'ni wa unggung kagabi ningsa' tanga yarokga' ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Ka arantagimni wari midi ka u naknga ning aniging, ka girii, kadapmang ka aming kidanga manggakyap ga' u torang wa kama wa indeng tara' abanga tiabe'ga'. Ka Jisas wari ning yanggu', sidi yang mangambeng wari keng kubungni waraga' tanga bak kukiting u yapma wa nakeda sa' tanga o napa' kubungni unda', ning undu' beng guksa' tuguting. Ka kama ka wari kadofonga napa' ni kadofo' undu' sidi kuma'sa' kigedanga nakedani'ga' ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Ka Jisas wari kadapmang ka Anutuga' ibang tutugu baritarak guk mo' naknga fikifiki ningsa' tonga ira au waraga' arantagimni u yangdidimonga midi tipfara tanga ning yanggu', ");
INSERT INTO uvh_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","3","ka yong nua'ni ganang wa tamkasa' nua'ni guk irota', Ka aming nua'ni wari tamkasa' waraga' mamareng famota'. Ka taming adi mamareng u tipdidimangam wara'ning aming nua'ni guk mokngang wara' adi yong wara'ning aming girii nua'ni ka aming ning mamareng u naknga tipdidimayam ning wara'ganang anga ning anota', o aming girii gu yotangkanap tinga aming ka wari nagata' mamareng nua'bu mo' namota'. Ning udi fikifiki anga fanota'. Ka aming girii ka udi Anutuga' guk mo' naknga aming kafakafa tiap ga' undu' bibi' naknga ananing sasuk ganangsa' tanga irota'. ");
INSERT INTO uvh_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Ka aming girii adi taming wari yotangkangam titiga' fikifiki anga fanota' u kanga tim ka bibi' nakngamota'. Ka inga' ubu sura ning touta', a na kadapmang ka aming yotangkayap ning wara'guk mo' titik. Ka tamkasa' adi fikifiki yotangkangam titiga'sa' abanga fananara'. ");
INSERT INTO uvh_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Ka nagabu kagabi sa' totik wa adi ko ningsa' abanga fananinga nakguridangam sini' ma tok. Wara' na nagata' kane girii kabinam u udaga waraga'sa' tanga kubase' yotangkangamotik ning tonga tamkasa' u yotangkangam tota'. ");
INSERT INTO uvh_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Ka Jisas wari midi tipfara u ina ning tanga ning yanggu', beng sini' aming girii kamaganangni adi aming kadagang ai' dap titiing mo' de ka adi taming wari fikifiki anota' u kanga undu' aigangam tanga kuma'sa' yotangkangamota'. ");
INSERT INTO uvh_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Ka aming girii adi ai' dap wa kadapmang ka taming wari adita' kane girii amimi wara'ning u udaga waraga'sa' tanga tangamota'. A aming girii ka Anutu adi aming girii kamaganangni ningwara' mo'. Adi ai' dap ning ki beng sini' ikita' wara' adi aming ka ananing arantagim ning ikanting wari mamareng guk ira yotangkaim titiga' sura tiim sidii fikifiki katingana ira anting wa Anutu adi yotangkayap titiga' bibi' guk mo' nakota', mokngang sini'. ");
INSERT INTO uvh_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Anutu adi adisining ibang u nakyam sa' tanga adi nasi' mamareng guk ira tonting u urapsa' kuma' yotangkaima tipdidimaiminga adi kabaksi' kareng guk ubu ikanting. Ka sidi waraga' sura naktangka tanga ira wa sidi Anutuga' ibang fikifiki ningsa' tonga ira anting. Inga' Amingning Tim Iyak naga kamaganangga' tubobu abok ganang wa na aming fam ka naktangka tangkunang tanga ibang ko ningsa' tonga ira ausi wara'guk mo' ma yabok ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Ka Jisas wari Juda aming fam ka kadapmang didimeng giri tanga ikem ning tonga anasining wap bema aranga aming fam wa kadagasi ning yabiaging wari nakedanga adisining iiksi' u tipdidima waraga' sura midi nua'ni ka ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Wa ning, aming fama' nua'ni ka Farisi a nua'ni ka aming kadagang takis mamanggeng wari siring yak girii tempel ganang amanga Anutuga' ibang tontamu'. Ka Farisi adi tim mauta' a aming takis mamanggeng ka Farisi wari kadapmang mumungguk titiing ning yapma bibi' nakyamiting adi mandang mauta'. ");
INSERT INTO uvh_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Anga siring yak iyung u amanga adenga Farisi adi aming kadapmang didimengsa' titiing wara' adi iikni ganang wa kadagang ni guk mokngang ning sura naknga Anutuga' ibang ning touta', o Anutu na aming ka kadapmang kadagang ka kubu a ami taming fam guk sansaramik titi a kadagang fam ka ning u tanga ikiting ka i adera' ningyara' mo'. Abanga na kadapmang mumungguk kadagang titiing ka aming ka do abanga adera' ningwara' mo' wara' na asekna ning torik. ");
INSERT INTO uvh_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Na kadapmang didimeng tanga sande kubanik kubanik fikifiki guta' sura nana tapni kama fama' ning sini' titik. Abanga na fiki uningkim mambong a napa' mambong fam manggetik undu' guta' sura ten ning indangira wa guta' kubanik didimengsa' udanga gamitik ning touta'. ");
INSERT INTO uvh_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Ka aming takis mamanggeng adi wap aming kadagang wara'guk irota' wara' adi anga adining kadagang waraga' sura kaba mamareng naknga siring yak iyung bane sini' do mo' agu'. Mokngang adi iming ganang gaga sa' amanga mungkupna tanga mera ananing mamamni u ura kaba guk kufara Anutuga' ibang ning touta', o Anutu na aming kadagang tuang beng sini' tanga ikitik wara' gu bibiri' napma yotangkanam te' ning touta'. ");
INSERT INTO uvh_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Ka beng sini' urang sanirik, Anutu adi ibang tutugu ning kadapmang ka aming takis mamanggeng wari tanga touta' wa didimeng ning kanga adita' nakota'. A ibang ning kadapmang ka Farisi wari tanga touta' wa Anutu adi didimeng mo' kanga bibi' nakngamota'. Beng sini' aming ka kadapmang ka ananing wap bema ara wara'ningsa' tanga irota' wa Anutu adi napa' sigening ning kanga adining wap bema afota'. A aming ka kaba bema afanga kadapmang ka ananing wap bema afu wara'ning u tanga irota' wa Anutu adi didimeng ning kanga adita' naknga adining wap bema arota' ning yanggu' Jisas wari. ");
INSERT INTO uvh_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Ning tanga yong unggungni aming wari Jisas wari adisining sababi' u kisi' suroyapma ibang totangkaim waraga' sura Jisas ga' sababi' u inagikngama abiging. Ka Jisas ning arantagimni adi u yapma yangkagare tiging. ");
INSERT INTO uvh_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Ka Jisas wari yangkagare tiging u yapma sababi' u katiana fonga kukyapma arantagimni u ning yanggu', sidi yangsefi mo' tinting. Anutuning bining wa aming kabaksi' kareng guk ka saba kababi' ningyara' wari iik ning. ");
INSERT INTO uvh_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Beng sini' sanirik aming ka Anutuning bining ganang iikga' naknga wa adi kabaksi' inga'ni kareng guk ka sababi' ningyara' naktangkanga ikanting wa giri, Anutuning bining ganang ikanting. A adi ning guk mo' tinting wa adi Anutuning bining ganang iikning guk mokngang sini' ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Ning tanga unggung mareiaging. Ka Juda ning aming girii nua'ni wari abanga Jisas u ning anikagu', o ninggek aming girii kareng na indining da'ning tanga ka' iik fikifiki ningsa' irotik. ");
INSERT INTO uvh_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Ka Jisas wari adining sasukni u kadidima waraga' ning anigu', ai gu aming kareng ning guk wa indining nanarang. Wap ka kareng wa Anutu kubaniksa' urang anitam udi. ");
INSERT INTO uvh_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Ka gu nasi' kareng ni titiga' sura abanga torang. Kadapmang kareng ka aming wari tanga kareng iik wara'ning wa midi ka Anutuning midi tang wari tonga yareta' wa gundu' kuma'sa' nakitang. Ka midi ka u tuguta' wa ning, gu tamga a ufiga kabinga kadagang sansaramik mo' totang a aming mo' ugumarotang a kubu mo' totang a midi mandaga' mo' toutang. Ning tanga gu mamangga babangga ning kapmik irotang ning tuguta' u yaranga totang wa napa' kareng sini'. ");
INSERT INTO uvh_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Ka aming wari ning togu', o beng sini' midi kadapmang ka u torang wa na timinggi' kabasi' ganang yaranga tanga ababanga kami yara'ganang undu' didimeng ko ningsa' tanga itik yang. ");
INSERT INTO uvh_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Ka Jisas wari ning anigu', ka gu kadapmang tang u yaranga didimengsa' udi giri tanga ikitang, ka gu napa' tangkunang kubaniksa' wa kagabi fatitang. Napa' ka wa ning, gu i anga guning mambong dabik u manggara fonga aming fam ga' ima yaranga mambong wara'ning uningkim u manggara tatafak aming ga' sabaraimsasu'notang. Ning tanga gu naga nawara abotang. Gu kadapang ka u ganirik u totang wa inga' gu Anutuning yongganang napa' kareng sini' katuaya' ning anigu'. ");
INSERT INTO uvh_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Ka aming girii adi mambongni siamo' guk, aming kangasi sini'. Wara' adi midi ka Jisas wari mambongni u sabaraim ga' anigu' u naknga kaba mamareng naknga bibi' naknga Jisas u kabinga mugo tugu'. ");
INSERT INTO uvh_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Ka aming kangasi wari kaba mamareng naknga mugo tinga Jisas wari ning yanggu', beng sini' torik aming ka mambongsi' siamo' guk adi Anutuning bining ning kadapmang u yaranga au waraga' wa kane girii sihni' tinting. ");
INSERT INTO uvh_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Ka wara'ning wa sidi maga girisi kamel waraga' sukanting. Maga girii wari napa' ginang kabasi' sini' ganang au ning guk mokngang kirikna tota'. Ka aming ka mambong siamo' guk undu' ningsa'. Adi mambongsi' waraga' sura Anutuning bining iikga' wa kane girii sini' tintin, ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Ka aming wari u naknga fam ka ning toging, ai, ka gu midi ka mamareng ning guk torang aming kamaganangni ka ni Anutuning bining ganang guk mo' unda' iro'ga'. ");
INSERT INTO uvh_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Ka Jisas wari ning yanggu', beng sini' napa' ka aming wari mo' titining ning kating wa Anutu adi girisa' titining ning kata'. Wara' Anutu warisa' kuma' tiaminga ikanting ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Ka Pita wari Jisas u ning anigu', girii, a guning arantagim indi ya indining. Indi guning kane ga' sura marara indining yak ning ki a mambongni' tangkunasi a mamangne babangne u ibisasu'nanga abanga gu giwara guning kane ubu tanga yangakem yang. ");
INSERT INTO uvh_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Ka Jisas wari arantagimni dabik u ning yanggu', beng guk sini' sanirik aming ka Anutuning bining ning kane titiga' saimo' naknga marara adining yong ki a yak a tamni a mindine ibingine mambong a kuyane a mengbe u ibinga mauta' wa adi napa' niga' nafek guk mo' tanga irota' mokngang. ");
INSERT INTO uvh_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","Adi napa' mambong ka u ibota' wara'ning tuboni wa Anutu wari napa' fam kabi'mo' ubu aminga auta'. Ning tinga adi kamaganang ingging irota' ganang wa napa' niga' nafek guk mo' tanga ira anganga inga' Anutuning yongganang undu' napa' girii sini' ka ka' fikifiki ningsa' iik u amiinga tanga iro' ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Ka Jisas wari arantagimni 12 u inagira naro' fonga kukyapma ning yanggu', i nakni' idi Jerusalem yongga' wadigi' urang famayam. Ka midi ka tim profet wari napa' napa' ka inga' Amingning Tim Iyak wari titi waraga' urang yoking wa kami yara'ganang beng guk kuma' kadofonga tara'. ");
INSERT INTO uvh_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Ka adi Amingning Tim Iyak u bema tonga aming arantagim nua'ni ka Juda mo' waraga' iminga wari bema midi kadagang aninga anikige tanga yuguk sombakni'ga'. ");
INSERT INTO uvh_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Ning tanga aya tangkunang wari fefinga ugumak tini'ga'. Ugumakinga kumara deia' kama fama' ibinga famineng ning fawa' ganang wa adi ka' tubobu seranga mararo'ga' ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Ka arantagimni ning sasuksi' ganang wa midi ka wara'ning kini udi mang sini' ningda'ning adegu' wara' adi Jisas ning midi u naknga midi wara'ning kiga' nafek tiging. ");
INSERT INTO uvh_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Ka Jisas guk ka arantagimni a aming sige fam wara'siguk wari anga Jeriko yong u kadofinga aramugoging, ka aming de kadagang nua'ni udi unggung merafagu'. Adi fikifiki kadapmang gaga ganang u mera aming wari mambong fam amimi waraga' fakatianarugu'. ");
INSERT INTO uvh_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Ka adi aming kabi'mo' ka Jisas yaranga aging wari midi ganggarang tonga aging u naknga amine u ning katianggu', ai do wa nasi' tanga tonga maing nakarik. ");
INSERT INTO uvh_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Ka amine yong ki unggungni wari ning aniging, wa Jisas Nasaretni wari abara'. ");
INSERT INTO uvh_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Ka adi Jisas Nasaretni ning toging u naknga yotangkangam titiga' sura ku ning katigu', ai Jisas Devit ning mindingni gu napbubure tanga yotangkanap te'. ");
INSERT INTO uvh_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Ka aming fam ka tim abiging wari kuguruda tanga ai, kabap ning anisefiging. Ka mokngang adi nakyam guk mo' tanga ku bang sini' nua'bu katigu', o Devit ning mindingni gu bibiri' napma yotangkanap te'. ");
INSERT INTO uvh_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Ka Jisas wari adining ku u naknga bibiri' naknga abanga adenga ning yanggu', aming u i nagiknama abani'. Ning ininga nagikngama abuinga Jisas wari aming de kadagang u ning anigagu', ka gu nasi' tagam ga' naknga fakatinanarang. ");
INSERT INTO uvh_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","Ka aming de kadagang wari ning togu', o girii na dana nua'bu karendanam ga'sa' nakarik. ");
INSERT INTO uvh_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Ning tuguinga Jisas wari ning anigu', we' tubobu kuma' karendagabara', degara te'. Ganing naktangka tang ka nagata' kabaka kubaniksa' kufara tarang warisa' tanga kami gu wadigi' kuma' karendarang ning anigu'. ");
INSERT INTO uvh_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Ning tinga de kadagang udi kaga' urapsa' karendainga karengsa' ubu degaranga marara Jisas u yaranga anga kaba karengsa' naknga Anutuning wap bema aranga mesisiringa tanga tanga mugogu'. Ka ami taming fam adindu' Jisas wari napa' girii tugu' u kanga Anutuning wap bema aranga mesisiringa tiging. ");
INSERT INTO uvh_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Ning tanga anga Jisas wari Jeriko yong bining u kadofinga aramugogu'. ");
INSERT INTO uvh_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Ka yong wara'ni aming nua'ni wapni Sakias ka adi kane aming arantagim ka takis manggakiaging u yaptatorarugu' wara'ning aming girii ira mambong kanggasi tanga itarugu'. ");
INSERT INTO uvh_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Ka adi aming kabi'mo' wari Jisas u kanga abanga adiganang bak girii tiging u yapma adindu' Jisas u kafakafa sini' kadidima ga' sura abugu'. Ka mokngang, adi aming pumpurum sini' wara' adi Jisas u kaga ga' ning tonga tugu', udi mokngang kaga guk mo' tugu'. ");
INSERT INTO uvh_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Ning tanga kadapmang ka Jisas wari au ga' wara'ganang tim unara anga firi nua'ni ka wapni sikamo wara'ganang furo'ning aranga mera fadegaregu'. ");
INSERT INTO uvh_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Ka Jisas wari anganga adiganang u kadofinga tarang kanga adenga ning anigu', ai Sakias gu afufu te'. Kami na gugok guning yak ganangga' mantamuk. ");
INSERT INTO uvh_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Ka Sakias adi Jisas ning midi u naknga urapsa' afanga Jisas u kanga kaba karengsa' naknga ning tanga Jisas u nagiknanga adining yak ganangga' mugogumu'. ");
INSERT INTO uvh_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Ka aming kabi'mo' adi Jisas wari Sakias ning yak ganangga' mugogumu' u kanga kabaksi' kadagang naknga ai' adi aming kadagang ning yak ganang guk wa nasi'ga' mara' ning tonga yareging. ");
INSERT INTO uvh_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Ka Jisas adi Sakias guk adining yakang ganang u kuma' anga kadofinga mareiagumu'. Ka Sakias wari Jisas u ning anigu', o girii tim kadagang tanga ikitik. Ka kami na kabakna ubu kuma' fararik wara' na naganing napa' napa' mambong girii i bining didimeng udanga manggara tatafak aming u yotangkayapma yarotik. Abanga aming ka naga tim takis manggara mandaga' iramira uningkim mambong girii naminga dibing ka nagata' kubu tanga famanggaknatik wa na ning torik, kami kura'bu uya' ka girii sini' kuma' imotik. ");
INSERT INTO uvh_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Ka Jisas wari ning anigu', o beng sini' kami Anutu wari aming ka yak ka yara'ganang iking u kuma' manggakniabara'. Gu aming kadagang ning gapma aming fugang iikning ning ganiting de, ka kami gu Ebraham ning arantagim didimeng sini' ubu kuma' kadofirang. ");
INSERT INTO uvh_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Amingning Tim Iyak naga kama ganangga' afuguk wa aming ka Anutuning kadapmang didimeng kabinga kadaga titi ningsa' iking u yapma inagira fabanga kukyabinga gi' ubu iik waraga'sa' tanga afuguk ning anigu'. ");
INSERT INTO uvh_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Ka Jisas wari midi ka Sakias anigu' u naknga Jisas ananing arantagim guk ka aming fam guk wari ning suking, o ya Jerusalem yong girii u kagadofi ga' dudure kuma' tem. Ka indi yong girii do kadofintam ganang wa Jisas adi Anutuning bining munumung sini' unda' tipkadofo'ga'. Ka Jisas adi kuma' yapkedanga midi tipfara tanga ning yanggu', ");
INSERT INTO uvh_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Wa ning, aming girii king nua'ni ka adi tim ka aming arantagim kamaganang unggungsa' yaptatoranga irota'. Ka inga' aming ka kama nua'ni ganang ikanting wari adisining girii king ira adindu' yaptatora waraga' naknga katinganinga marara wap ka adisining king ning guk ubu iik wara'ning u bemonga kama kamani u auta'. Anga wap ka u bema tubobu abanga mera kama fama' guk ubu yaptatorota'. ");
INSERT INTO uvh_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Ka aming girii king adi wap ka u bemonga aunga wa adi tim ka adining kane aming ten ning u katiana abuinga aming kubanik kubanik wara'siga' 20 kina 20 kina ning u dabiksa' ima yarota'. Ning tanga ning inota', sidi uningkim i samarik ya manggara fonga sige mo' kukinga fidenting. Sidi i manggara fonga uningkim yari kane tanga uningkim yara'ning dibing kunik ka' nua'bu ifakadofinga yaranting. Ka inga' naga tubobu abok ganang wa na uningkim i kuma' ifigaranting wara' girii bemnok. Ning ina ning tanga ibinga mauta'. ");
INSERT INTO uvh_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Ka aming arantagim ka ananing yong ki ganang tim yaptatorota' adi adita' guk mo' nakanting wara' adi aming girii wari kuma' mugoinga kabaksi' kadagang naknga aming nua'ni mandang inga' aninga kamiinga anga king u ning anota', indi gu niptatora ga' bibi' nakem. Ka king adi midi ka u naknga midi tubobu guk mo' anota', adi ningsa' kabiamota'. ");
INSERT INTO uvh_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Ka adi inga' wap ka kama wara'ning king u bema yong kini ga' tubobu mabota'. Abanga kadofinga mera kane aming ka tim uningkim mambong ima mauta' wara'sining kanesi' u kadadima waraga' sura kane aming u urapsa' katianota'. ");
INSERT INTO uvh_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Katianinga abanga adenga kane aming nua'ni wari ning anota', o girii tim gu 20 kina urang namgung wa na kane tang tanga 200 kina ning kuma' tipkadofigamarik. ");
INSERT INTO uvh_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Ka girini wari adining midi u naknga kaba karengsa' nakngama ning anota', o karengsa' gu tim napa' kabasi' gamguk ka kafakafa sa' katatoranga tanga ikitang wara' kami na napa' girii ubu gaminga gu yong girisi ten ning u yaptatora wara'ning kigineng guk ubu ira yaptatorotang. ");
INSERT INTO uvh_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Ning tanga aming nua'ni adibu anota', o girii tim gu nagata' 20 kina namgung wa na kane tangkunang tanga ka' nua'bu wa dandameng sini' ka 100 kina ning kuma' tipkofigamarik. ");
INSERT INTO uvh_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Ka girii wari ning anota', o karengsa' tarang. Gu kane aming kareng gu didimengsa' giri taranga wara' na gundu' aming girii gipmotik. Ning tinga gu yong girisi ka faiv ning u yaptatorotang. ");
INSERT INTO uvh_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Ning tanga kane aming nua'ni adibu anota'. O girii gu tim nagata' 20 kina urang namgung wa na bema tonga kwi' kugo' wari yananga kapmo' gi' sepkaminga fideta'. Ka kami gata' didimengsa' tubobu bemgamarik yang. ");
INSERT INTO uvh_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Girii na gu kuma'sa' gabitik gu aming kagaya, nana a nasi' fam ka gu tanga nanga ikitang wa gu ganing tangkunangsa' mo' tanga ikitang. Mokngang gu aming wari tanga ifikadofigaminga manggakna sa' titang. Gu kadapmang ka ning u titang gabitik waraga' tanga na uningkim namgung wa gi' bema yananga kamigamguk ning touta'. ");
INSERT INTO uvh_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Ka girii wari ning anota', ai, gu kane aming kadagang sini'. Midi ka ganing maga wari u torang warisa' gata' mamareng gamara'. Beng ba, gu naga idi aming kadagang ira kadapmang ka aming fam ning napa' iromanggakniap a aming ning feng u nagata'sa' sura manggakna ning ba titik nabitang. Wara' gu nagata' mutu tanga uningkim u sige sebinga fideta'. ");
INSERT INTO uvh_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Ka gu nasi'ga' tanga naganing uningkim ya sige sebinga fideta'. Gu bema tonga kane tanga tipgaranam titiga' wa. ");
INSERT INTO uvh_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Aming girii wari ning kafanga aning aninga ning tanga kane aming fam u ning inota', sidi 20 kina u iromkadak tanga bema tonga kane aming ka kane tangkunang tanga 200 kina guk kuma' tipkadofigu' waraga' nua'bu amini'. ");
INSERT INTO uvh_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Ka kane aming fam adibu ning aninting, ai girii adi mambong girii 200 kina ning kuma' bemgu' ka gu 20 kina nua'bu guk wa indining amonga torang. Ka aming girii wari ning inota', naga kuma' torik amimi sa' tini'. ");
INSERT INTO uvh_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Beng sini' torik naganing kadapmang wa ning, aming ka naga napa' amotik ka tangkunang surouta' wa na fam nua'bu amotik. A aming ka naga napa' kabasi' amotik ka adi kafakafa guk mo' katatorota' wa na irombem tinga adi nafek sini' tota' ning titik. ");
INSERT INTO uvh_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Ka aming arantagim ka tim naga adisining girisi' ning ira yaptatora ga' bibi' urang naknamging wa sidi inagik tanga fabanga naganing dana ganang ingging dipmikumakni' ning inota' ning yanggu' Jisas wari. ");
INSERT INTO uvh_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Ka Jisas wari midi ka u ina biinga ning tanga adi Jerusalem yongga' tim ira mugoinga arantagimni guk ka aming fam guk adi mandang ira ning tanga mugoging. ");
INSERT INTO uvh_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Anganga yong kababi' fama' ka Betfasi guk ka Betani guk ka Jerusalem yong girii du' ka kama bubo wap Oliv ganang adeyagumu' waraga' arantagimni fama' tim yangkareinga agumu'. ");
INSERT INTO uvh_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Ning yanggu', sidi yong kabasi' do anga dongki uyamang nua'ni kuni'sa' ka aming wari tim guk mo' meking ka adi aya wari kuma' tofinga irakinga fidera' u kanga fadara bemnama abantamu'. ");
INSERT INTO uvh_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Ka aming tuang wari sapma ai, dongki wa nasi'ga' fadakiamu' ning udep saninga wa sidi ning anintamu', mo' girii wari dongki yara'ganang kane tonga ningkarara' kanga abanga fadakiamuk ning tontamu'. ");
INSERT INTO uvh_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Jisas wari aming fama' u ning ina yangkareinga anga kadofinga nasi' midi ka Jisas wari yanggu' u didimengsa' yapma ");
INSERT INTO uvh_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","ning tanga dongki ning aya u arafadagumu'. Ka dongki tuang wari yapma ning yangging, ai dongki wa nasi'ga' fadakiamu'. ");
INSERT INTO uvh_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Ka adibu ning yanggumu', mo' girii wari kane tonga ningkarara' kanga abanga fadakiamuk. ");
INSERT INTO uvh_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Ning tanga dongki u fadara bema ababanga Jisas ganang kadofinga anasining kwi' u manggara dongki ning fugu faro'ning ingamging. Inga ning tanga Jisas u bema dongki furo'ning u kamiinga meku'. ");
INSERT INTO uvh_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Ning tinga aming dabik ka Jisas u yaranga kubap mugoging wari anasining kwi' u manggara kadapmang ganang u ingama yareinga Jisas adi dongki wara'ganang mera kwi' furo'ningsa' tipminga aramugogu'. ");
INSERT INTO uvh_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Ning tanga kadapmang u yaranga anganga Jerusalem yong girii u dudure tanga kadapmang bining ka kama bubo Oliv u kabinga amayaging u kadofinga aming arantagim girii ka Jisas ga' fanakiaging wari Jisas wari kane tangkunang mirakel tinga fakayaging waraga' sura kabaksi' karengsa' naknga mesisiringa tanga Anutuning wap bema aranga ku bang ning katiging, ");
INSERT INTO uvh_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","o karengsa' indi gu Anutu girii wari aming girii gipminga indiganang abarang waraga' kabakni' karengsa' nakem. O beng sini' kami Anutu wari indita' kaba kugurang kuma' naknima ai' dap tinimara' wara' indi kabakni' karengsa' naknga Anutu girii ning wap bema arantam ning kating katinga abiging. ");
INSERT INTO uvh_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Ka Farisi arantagim ning aming fam ka aming ku katiging wara'sining bining unggung adeging adi aming kabi'mo' wari Jisas ning wap bema areging u kanga kigesini naknga Jisas u ning aniging, ai yanggek aming, adi kadapmang ka wa kareng mo' ting yabem. Gu arantagimga u sangsefi te'. ");
INSERT INTO uvh_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Ka Jisas adibu ning yanggu', naga aming u yangsefotik wa ku ka u kating ning udi uningkim adibu undu' kuma'sa' marara katinting ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Ka Jisas wari Jerusalem yong girii bibik u anga kadofinga Juda aming ka Jerusalem yong ki ikiaging wari adining midi tarakayonga ira abiging waraga' sura kaba mamareng naknga mak kara midi ning togu', ");
INSERT INTO uvh_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","o bibiri' sini' Jerusalem aming gu mamareng bimbem wara'ning kama wa kuma' dudurera'. Ka na kamisa' gu guning kadapmang u kafakafa sura gi' iikga' nakarik. Ka mokngang, kadapmang ka gu napa' waraga' sura kabaka faranga naga yotangkasap ga' ninang wara'ning wa gu sareng kaga ning guk mokngang, kapmo' adera' wara' gu kaga guk mo' tarang. ");
INSERT INTO uvh_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Ka inga' kama mamareng ka ning kadofigamo'. Guning digirapka wari kadofinga kadapmang a base indeng u isefigamsasu'nani'. Ning tanga ami'ga' kwang unanga du' sini' unggung ira gukni'ga'. ");
INSERT INTO uvh_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Adi gura gifikadaga sini' tanga yak undu' dipmisasu'nanga ning tanga yak wara'guk wadigi' kuma' ifikadagamsasu'nani'. Ning tinga yak wa ma sinim ning uningkim ka ni furo'ning unggung ko guk mo' garinga adewa'. Mokngang sini', uningkim dabiksa' wa adi ifikadasasu'na tinga kamaganangsa' kuma' mangfasasu'nani'ga'. Beng sini' gu Anutu wari yotangkagap tonga abara' wa gu kafakafa guk mo' kigedanga adining midi ninak ga' bibi' nakngama manda ukngamarang wara' inga' gu mamareng ka ning u beme'. ");
INSERT INTO uvh_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","46","Ka Jisas wari midi ka u tonga biinga ning tanga anga Jerusalem yong u kadofinga siring yak girii tempel wara'ganang amanga yapku' ka aming wari napa' mambong u manggara fabanga maket tanga kura fatonaging. U yapma barap naknga aming u yangkagare tanga ning yanggu', Anutuning midi ka siring yak yara'ga' wa ning yoking, naganing yak wa nagata' ibang tutugu wara'ningsa' ning yoking. Ka sidi yak ka kubu aming wari kapmo' sepma iikning ningda'ning tipigironga ting sabarik ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Ka Jisas wari aming u yangkagarenga ning tanga fikifiki adi siring yak girii wara'ganang amanga aming u midi kareng fianggetarugu'. Ka Juda ning pris girisi a sasuk aming a ami taming wara'sining tim iyak aming fam wari u kanga kabaksi' kadagang naknga Jisas u uuk titiga' bemtam ning tonga fatiaging. ");
INSERT INTO uvh_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Ka mokngang, fikifiki ami taming kabi'mo' wari adining midi u kafakafa sini' nakonga anga adiganang bak siamo' fatiaging wara' adi Jisas anapmo'sa' adeinga bimbem ning kadapmang kabi'guk mo' kanga bimbem guk mo' tiging. ");
INSERT INTO uvh_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Ka Jisas adi Jerusalem yong ganang unggung ko ira ning tanga siring yak girii tempel ganang u amanga ami taming ga' midi kareng faituaimgu'. Ka pris girisi a Juda ning kadapmang tang ning sasuk aming a aming wara'sining tim iyak aming fam wari Jisas ganang u abanga ");
INSERT INTO uvh_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","ning anigaging, ai gu kane ka u tanga fiararang wara'ning wap guk wa. A gu kane ka u titiga' wa nisi' wari gipmigu', wa nining tinga naknam. ");
INSERT INTO uvh_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Ka Jisas wari ning yanggu', ka ningwara' nandu' napa' nua'ni ga' sangkautik. ");
INSERT INTO uvh_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Ka sidi tim Jon Baptis wari kadofinga aming ama iyama yaregu' waraga' wa indining fasukiting, Anutu wari kamiinga tugu' wa ma aming warisa' kamiinga tugu'. ");
INSERT INTO uvh_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Ka aming girisi adi Jisas ning midi u naknga anasa' ning toging, indi weng Anutu wari kamigu' ning tontam wa adi ning ma nino', ka nasi'ga' tanga sidi Jon ning midi wa nakngam guk mo' tiging. ");
INSERT INTO uvh_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","A indi aming warisa' kamiinga tugu' ning tontam wa aming kabi'mo' adindu' Jon ning kane kuma' kanga o adi profet beng ning tonga Jon ga' naktangka kuma' tiging. Wara' aming adi indining midi u naknga kabaksi' kadagang naknima uningkim kwak wari ma indifini'. ");
INSERT INTO uvh_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Ning tonga naknga Jisas u ning aniging, indi Jon ning kane wara'ning ki guk mo' nakedem. ");
INSERT INTO uvh_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Ka Jisas wari ning yanggu', sidi nafek ting ning naning wara' nandu' nisi' wari nipmiinga tirik wara'ning kini undu' mo' sanotik ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Ka Jisas wari ami taming u midi tipfara nua'ni ka ning tanga yanggu', ka aming girii nua'ni wari grep mindip feng tota'. Tanga kane aming fam manggara fonga feng u katatora waraga' kukyabinga tanga ikanting. Ning tanga aming girii adi kama ka u kabinga anga kama kamanii nua'ni ganang unggung fafong irota'. ");
INSERT INTO uvh_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Ka aming girii grep feng tuang wari grep feng wari mindip mimindi ning kama wari kadofota' u kanga ning touta', o grep wari beng titining kama kuma' kadofira' karik wara' na kane aming ka ni anigarotik. Adi anga aming ka grep feng katatoranga iking u yapma grep wara'ning uningkim mambong guk udep bema kaming u bemnama abota'. Ning tonga kane aming nua'ni anigareinga abota'. Abanga kadofinga nasi' midi ka girini wari aninga kamota' u inota'. Ka aming ka feng u katatoranga ikanting adi feng tuang ning midi u naknga bibi' nakngamting. Ning tanga marara kane aming u bema uuk tanga tubobu sige anigareinga mauta'. ");
INSERT INTO uvh_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Anga aming girii feng tuang ganang do kadofiinga aming girii wari sigesa' auta' u kanga kane aming nua'ni ubu anigarota'. Ka wari anga kadofiinga undu' adi ningsa' taramikanting. Adi kane aming u bema uuk tanga kadapmang kadagang sini' taramira ning tanga tubobu sigesa' anigareinga auta'. ");
INSERT INTO uvh_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Ning tinga aming girii wari u kanga kane aming nua'ni ubu anigareinga auta' undu' ningsa'. Adi aming u bema uuk tanga anigara tinga tubobu sigesa' auta'. ");
INSERT INTO uvh_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Ka aming girii feng tuang adi aming ka feng u katatoranga ikanting wari kadapmang kadagang ka ning u tanga abinting u kanga kaba mamareng naknga ning touta', ai na kane aming fayangkararik ka adi ning ba ting. Aming fam ning nondaksi' yapma udep ting ningwara' na naganing sabana kubaniksa' ingging kuma' anigarotik. Ning tinga adi sabana ning nonda sini' kanga wa giri adining midi nakngamsa' udep tinting. Ning tonga ananing mindingni unggung sini' ubu anigareinga abota'. ");
INSERT INTO uvh_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Abanga kadofiinga aming ka feng u katatoranga ikanting wari feng tuang ananing mindingni u kanga ning tonting, ai feng tuang ananing mindingni ana sini' uba abara' sam. Indi bimbem tanga ugumak tanam. Ugumara ning tanga feng ya indita' wadigi' ubu bemnanga katatoranantam. ");
INSERT INTO uvh_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Ning tonga igiranga aming dabiksa' marara feng tuang ning mindingni u bema tamanga feng wara'ning sinim gaga ganang kaminga ugumakanting. Ka inga' feng tuang wari tubobu abota' ganang wa indining, adi aming arantagim ka mindingni ugumara feng irombemnanting udi iibi tota' wa. ");
INSERT INTO uvh_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Mokngang sini', aming girii adi abanga aming ka kadapmang kadagang tanga ikanting wa dipmisasu'na tota'. Ning tanga feng u katatora waraga' wa aming arantagim inga'ni sa' ubu manggara kukyabota' ning yanggu'. Ka aming adi Jisas wari midi tipfara tanga yanggu' wara'ning kini u nakeda guk mo' tanga ning toging, ai adi kadapmang ka ning guk wa indining tinting. Ning wa indi kadagang nakem ning toging. ");
INSERT INTO uvh_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Ka Jisas wari aming u ifang yaranga ning yanggu', ka adi midi nua'ni ka tim Anutuning midi umpang ganang ning yoking, “yak mama ning uningkim nua'ni ka tim aming wari kadagang ning kanga kabiging wa inga' aming fam adibu uningkim ka wa kigineng kareng sini' ning kanga bema yak ning mangkap tim iyak kigineng ning ubu kamiinga ita' ning yoking.” Ka sidi midi ka wara'ning kini waraga' sura nakedanting. ");
INSERT INTO uvh_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Ka uningkim ka wa fasi' sini' a mini siamo ikita'. Ka aming ka ni uningkim ka wara'ganang manga urota' wa uningkim ka wari adining fugu u wadigi' dopsasu'geinga kugo'sa' kadofota'. Abanga uningkim ka wari aming nua'ni ning fugu furo'ning mangfota' udi aming u wadigi' upapekaranga kayoinga kugo'sa' kadofota' ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Ka sasuk aming a pris girisi adi Jisas wari midi ka u togu' wa anasita' unggung sura togu' ning u kuma' nakedanga Jisas ga' kabaksi' kadagang nakngamging. Ning tanga bimbem titiga'sa' kuma' suking. Ka ami taming kabi'mo' ka Jisas ning midi nakonga Jisas ganang bak girii tiging waraga' tanga kagabi tiging. ");
INSERT INTO uvh_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Ka adi Jisas u bimbem ga' ning tonga fatiaging, ka mokngang fe'sa' fatiaging. Ning tanga adi indining tanga bemtam sam ning tonga Jisas u bimbem ning kadapmang u katua waraga' aming fam u inagira fonga ning yangging, sidi anga Jisas u midi mandaga' taramikinga adi fe' tinga indi wara'ganang bema tonga kiap ning kot ganang kamintam. Ning ina yangkareinga aging. ");
INSERT INTO uvh_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Anga Jisas ganang u kadofinga mandaga' taramironga ning aniging, ai yanggek aming, indi ning fagabem ka nasi' kadapmang a midi ka gu faninggetang udi didimengsa'. Abanga gu midi ka nasi' kadapmang ka Anutu wari aming girisi wa ma aming sige indi titiga' nakita' u ituanimonga undu' gu megang a mutu tanga tipfara da'ning guk mo' tanga tugutang. Mokngang gu kadapmang kubaniksa' yaranga didimengsa' ituanimitang. ");
INSERT INTO uvh_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Ka kami indi napa' nua'ni ga' gangkaunga abem undu' gu sarengsa' nininga naknam. Ka Juda aming indining kadapmang tang wa indining adera', Juda aming indi Romni girii Sisa ga' takis udi girisa' amintam wa ma mokngang ning anigaging. ");
INSERT INTO uvh_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Ka Jisas adi mandaga' tantaramik ning sasuk ka adisining kabaksi' ganang udi kuma' yapkedagu' wara' adi didimengsa' ning yanggu', ");
INSERT INTO uvh_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","ningwara' uningkim ka ni namni'. Ning ininga bema amiinga Jisas wari uningkim u bema yangtintingnanga ning yangkagu', aming uuring ka uningkim ganang i adera' ya nisi'ning uuring tiging. Ka adibu ning toging, mo' wa Romni girii Sisa ning uuring tiging. ");
INSERT INTO uvh_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Ka Jisas wari ning yanggu', wa giri didimeng toing wara' ning sanotik, napa' ka Sisa ga' amimi wara'ning wa adita' aminting. A napa' ka Anutuning undu' Anutuga' didimengsa' aminting ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Ka aming adi Jisas wari aming kabi'mo' ning dasi'ganang fe' tinga bimbem waraga' sura anga aniging. Ka mokngang, Jisas adi sasuk guk wara' adi Jisas ning midi warisa' irafiku' u kanga kagabi tanga mugo tiging. ");
INSERT INTO uvh_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Ka Juda aming ning aming arantagim wap guk nua'ni ka Satyusi ning iniaging ka adi naktangka aming kungkumosi wa tubobu mamarak ning guk mokngang ning tanga ikiaging, ka wari Jisas ganang kadofinga ");
INSERT INTO uvh_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","kadapmang ka aming kungkumosi wari tubobu mamarak ning waraga' nakdidimonga didimeng u ninota', ma fe' u tota' ning sura Jisas u ning aniging, tisa gam gu midi nua'ni ka tim Moses wari aming wari taming sananga saba guk mo' ibenga kungkumak waraga' ka Juda aming indita' yoknimgu' wa gundu' fafongsa'. Ka midi ka Moses wari u yoku' wa ning togu', aming ka ni taming sananga saba guk mo' ibenga ganang kumarota' wa kuyangni wari taming u sananga saba tipkadofinga kuyangni ka kungkumak tota' wara'ning uni yokantamu' ning yoku'. ");
INSERT INTO uvh_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Ka gu midi ka inga' aming kungkumosi wari tubobu mamarak ga' fatorang wa indining. Aming se'kuyane ka seven ning ikanting. Ka kuyasi' timini wari taming sananga saba guk mo' ibenga ganang kumarota'. ");
INSERT INTO uvh_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Ning tinga kuyangni nua'ni adibu adining taming u sanota' undu' ningsa' tanga saba guk mo' ibenga kumarota'. ");
INSERT INTO uvh_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Kumakinga kuyasi' biningni adibu adisining tamkasa' u sananga undu' ningsa', adi saba guk mo' ibenga sigesa' kabinga kumarota'. Ning tinga kuyasi' biningni nua'ni adibu sanota' undu' ningsa' tanga sigesa' kabinga kumarota'. Ka aming se'kuyane seven ning dabiksa' adi ningsa' tanga kumara kumara anganga kumaksasu'na tinga ");
INSERT INTO uvh_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","inga' tamsi' undu' kungkumak tota'. ");
INSERT INTO uvh_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Ami wa usap a taming wa kubaniksa' ning adeing ka gu waraga' wa indining sutang. Inga' aming kungkumosi wari tubobu marakni' ganang wa taming wara'ning ufini sini' wa indeng u todidimainga naknam ning aniging. ");
INSERT INTO uvh_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Ka Jisas wari ning yanggu', beng sini' ning sanotik, kamaganang i ira wa kadapmang ka ufi imaraming iikning guk wara' sidi taming a ami saniapma ufi imaraming tanga iking. ");
INSERT INTO uvh_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Ka inga' kama ka aming ka Anutu wari ka' iikga' kuma' ifakasiregu' wari tubobu marara ikni' ganang wa adi imaraming ning guk mo' ikni'. ");
INSERT INTO uvh_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Mokngang adi Anutu wari ifimarakinga Anutuning mindine arantagim ning ira naro' naro'sa' ka adining kunung aming ensel wari urang ikiting ningsa' ira kungkumak guk mo' tanga ka' fikifiki ningsa' ira ani'. ");
INSERT INTO uvh_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Ka midi ka aming kungkumosi wari tubobu marara ka' iik wara'ning wa tim Moses wari undu' kuma'sa' kanga yoknimgu'. Ka midi ka wa Anutu wari firi nua'ni ganang kadofinga adenga Moses ning de ganang firi sasa' wari kudip da'ning tanga midi ning anigu', na Ebraham a Aisak a Jekop adisining Anutu wari itik. Ning togu' u yoknimgu' undu' kuma'sa' katam. ");
INSERT INTO uvh_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Ka aming ka wari kungkumak tanga wadigi'sa' kuma' bisasu'nianing ganang wa Anutu adi na adisining Anutu itik ning guk mo' tounga tugu'. Mokngang adi anagok unggung ka' yaging u yapma wa u togu' wang. Wara' indi midi wap ka itik ning togu' u kanga ning tontam, o beng sini' Anutu wa napa' kungkumosi sige wara'sining Anutu mo', adi napa' napa' ka ka' iik guk u yaptatoreta' wara'sining Anutu. Wara' adi inga' aming kungkumosi tubobu kuma'sa' ifimararo'ga' ning yanggu' Jisas wari. ");
INSERT INTO uvh_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Ka Farisi arantagim adi aming kungkumosi udi tubobu kuma' marakni' ning toyaging wara' adisining sasuk aming fam ka unggung adeging adi Jisas wari midi ka adisining sasuk ganang didimengsa' togu' u naknga kabaksi' karengsa' naknga o tisa gu midi karengsa' torang nakem ning toging. ");
INSERT INTO uvh_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","A aming ka anga aniga' tiging Satyusi arantagim adi Jisas wari iirafik tugu' u kanga o kureng nua'bu mo' anigantam ning tonga kagabi tanga mugo tiging. ");
INSERT INTO uvh_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Ka Jisas wari Juda aming u ananing ki waraga' yangnatamonga ning yanggu', ka ma' sidi Kasira Aming wa Devit arantagim ganangsa' kadofo'ga' ning fatuguting wa. ");
INSERT INTO uvh_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Ka Devit adi aming girii de, ka adi Kasira Aming waraga' sura umpang wap ka Sam wara'ganang wa midi nua'ni ka ning yoku', “Anutu girii wari naganing girina u ning anira', gu naganing kafana kareng ganang i abanga mareke'. ");
INSERT INTO uvh_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Ning tinga na aming arantagim ka guta' bibi' naknga guning digirap ning iking wa manggara fabanga guning kaga kapmik ganangsa' kukyabinga gusa' tipmikuritiapma yaptatoreinga adi tangkunang guk mokngang ning ikanting ning yoku'.” ");
INSERT INTO uvh_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Ka sidi Kasira Aming wa Devit ning iri ka aming kamaganangsa' wari kadofo' ning fatuguting. Ka sidi midi ka Devit wari girii wari naning girina anira' ning togu' waraga' sukanting ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Ning tanga ami taming kabi'mo' ka Jisas ning midi mera fanaking undu' unggung ko mareiaging ganang ka Jisas wari arantagimni u ning yanggu', ");
INSERT INTO uvh_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","ka sidi sasuk aming wa aming karesi sa' ning tonga ma yapni' wara' na ning sangnatamotik, beng sini' sasuk aming adi aming wari aming karesi ning iyap waraga'sa' naknga kwi' inga'ni karesi ipmanga anga maket ganang a kama ka aming wari bak titi ganang u fideyangating. Abanga adi siring yak iyung bane ganang a kama tangsana titi ganang wa adi tare karesi ka aming girisi wap guk wari mimek ning wara'ganangsa' anga marekiting. ");
INSERT INTO uvh_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Abanga adi tamkasa' u mandaga' iramira adisining yak a mambong fam u iromanggakniabiting. Adi kadapmang mandanga' ka ning u kuma' tanga ira siring yak iyung amanga ibang tuguting ganang wa aming wari aming karesi ning iyap waraga' sura ibang paramu' sini' sige tonga auting. Ka adi kadapmang kadagang ka ning u titing wara' inga' Anutu wari mamareng girii sini' kabiamo'ga' ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Ka Jisas wari siring yak girii tempel ganang u amanga mera yapku' ka aming kangasi fam wari Anutuga' uningkim ofa u fakamiging. ");
INSERT INTO uvh_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Ka tamkasa' nua'ni ka tatafak sini' itarugu' adindu' uningkim mambong kababi' sini' fama' ka 2 toea ningsa' kamigu'. ");
INSERT INTO uvh_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Ka Jisas wari aming ka mambong fakamiging u fonga yapma tamkasa' u kanga ananing arantagimni u ning yanggu', beng sini' sanirik sidi tamkasa' do kani'. Adi uningkim girii mo' kamira' de ka adi aming ka uningkim mambong girii kaming u irafita'. ");
INSERT INTO uvh_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Wa ning, aming ka uningkim mambongsi' guk adi dibing kunik wa unggung udanga kabinanga Anutuga' dibingsa' tabanga kaming. A tamkasa' adi ning mo' tara'. Mokngang adi Anutuning kane u yotangka waraga' kaba guk sini' kufara adining uningkim kabi'sini' wa adi ananing fugu yotangka ga' guk mo' sura wadigi'sa' kuma' bema tabanga kamira' wara' adi aming kangasi u irafita' ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Ka inga' aming fam wari siring yak girii tempel u daranga kanga ning toging, ai yak girii ya uningkim tangkunasi a uningkim diding guk karesi sini' ka aming wari Anutuga' sura fabanga fugukiting wari' wadigi' sini' tiging wara' karengsa' kayam ning toging. ");
INSERT INTO uvh_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Ka Jisas wari ning yanggu', sidi yak girii ya uningkim karesi warisa' tiging u kanga napa' kigineng sini' ning udi giri kanga toing. Ka beng sini' ning sanotik, inga' mamareng nua'ni wari kadofiinga aming fam wari yak girii ning uningkim a napa' karesi u yapma toing udi wadigi' kuma' tipkadanga itataranga ipmasasu'neinga kamaganangsa' mangfani'ga'. Ning tinga uningkim kareng ka ni ka gipmamni ganang ning guk mo' garinga adewa', mokngang sini' ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Ka aming adi Jisas ning midi u naknga base tanga sasuk mimeng tanga Jisas u ning anigaging, ka tisa mamareng ka u torang wa kama wa nasi' ganang sini' kadofo'ga'. Abanga indi kanga o kama ka urang udi kuma' kadofonga tara' ibanda' ning nakedanga tutugu waraga' wa tim wa nasi' kudi wari kadofanimo'ga' ning aniging. ");
INSERT INTO uvh_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Ka Jisas wari ning yanggu', beng sini' sidi midi ka i torik yaraga' sura aming ka mandaga' tuang wara'siga' kafakafa suktangkanga ikanting. Inga' aming kabi'mo' ka ningwara' wari abanga mandaga' siramikonga ning sangni'. Kasira Aming wa nagasa' kuma' abarik yang. A kama ka tim urang toguk wa kami kuma' kadofonga tara' yang ning sangni'. Ka sidi adisining midi u naknga ai, Kasira Aming urang udi kuma' abara' ibanda' ning tonga mo' marara iwakni', mokngang. ");
INSERT INTO uvh_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Abanga kama ka wara'ganang wa sidi aming kama yong fam wari ami' girii tanga yarani' wara'ning midi ne undu' nakni'. Ka sidi u naknga o kama ari' urang udi kuma' kadofonga tara' ibanda' ning tonga mutu mo' tini'. Mokngang napa' mamareng udi giri tim kadofo' a kama ka kama yari ari' bibi'ning wa urapmo' inga'sini' kadofo'ga' ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Ning tanga Jisas wari nua'bu ning yanggu', beng sini' urang sanirik kama ka wara'ganang wa sidi kudi nua'ni ka ning kadofo' kani'. Kama yara'ning kama dibing fam dabiksa' wara'ning aming arantagim girii nua'ni wari aming arantagim girii nua'ni guk ami' ning tanga yarani'. ");
INSERT INTO uvh_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Abanga kining girii a kama tugumung girii iik a bagana kadagang kuni' kuni' ning wari kama dibing fam ganang u kadofinga yaro'. Ning tanga kunim ganang kutandu' napa' girisi girisi a kudi kuni' kuni' ka aming sidi kanga mutu titining wari undu' kadofiinga kani'ga'. ");
INSERT INTO uvh_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Ka napa' napa' u tonga yararik wari ko mo' kadofo' ganang wa tim ka aming wari naganing arantagim sidi nagata' naktangka tini' u sapma sidita' bibi' naknga naganing wap u tipkadaga ga' sura manggaksap tanga kadagang saramira sidifi tini'ga'. Ning tanga sinagira fonga siring yak iyung ganang kuksabinga midi fatoni'ga'. Abanga adi fiking ni ka sidita' kabaksi' kadagang naksama sinagira fonga aming girisi king a gavman ning girisi fam wara'sining dimisi' ganang sifikadofini'ga'. ");
INSERT INTO uvh_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Ka sidi nasi' midi tontam ning tonga sasuk mimeng mo' tini'. Mokngang sidi kama ka wara'ganang wa aming girisi ga' Anutuning midi kareng ituaim ning kadapmang guk ning kanga tangkunangsa' adenga ituaim sa' tini'. ");
INSERT INTO uvh_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Ka kama ka aming wari midiganang u kuksapni' ganang wa sidi nasi' midi ka sidi tutugu ning waraga' sasuk mimeng mo' tini'. Mokngang ");
INSERT INTO uvh_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","wa nagasa' midi kadapmang didimeng u sidining sasuksi' ganang kamisama sifadidimainga sidi midi wa didimengsa' kuma' toni'ga'. Ning tinga aming ka sidita' digirap tonga midiganang fonga kuksapni' adi sidining midi kadapmang didimeng u naknga karangkayosam guk mo' tini'. Mokngang adi mera naksamsa' tini'ga'. ");
INSERT INTO uvh_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Ka aming ka sidita' digirap ira midiganang kuksap ga' sifikadofi wa aming fam warisa' mo' tini'. Mokngang wa arantagim ka sidaning tuang sini' ka mamangse babangse a kuyase amaa dabik a amise yong dabik ana undu' sifikadofani'ga'. Ning tinga digirapsi' adibu manggaksapma kadapmang kadagang siramira fam ka sidifikumak sini' tini'ga'. ");
INSERT INTO uvh_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Beng sini' sidi nagata' naktangka tanga wap ka naganing arantagim ning guk ikni' u sapma kabaksi' kadagang naknga sidita' bibi' sini' naknga kadagang kuni' kuni' kabi'mo' ning saramikni' de. ");
INSERT INTO uvh_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Ka adi urisi' guk mo' sifikadani'. Mokngang urasi' wa kareng ningsa' ko iro'. ");
INSERT INTO uvh_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Ka sidi napa' mamareng girii ka u tonga yararik wari kadofo' wara'ning bining ganang ira kabaksi' u tiptangkanga tangkunang ko ningsa' ira ani' wa sidining ka' iiksi' wa bibi' guk mo' to'. Mokngang sidi ka' ningsa' ko ira ani' ning yanggu' Jisas wari. ");
INSERT INTO uvh_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Ka Jisas wari inga' Jerusalem yong girii wari wadigi' kadaga waraga' aming u ning yanggu', ka sidi inga' yong nua'ni ning ami'ning aming soldia arantagim girii wari kadofinga abanga Jerusalem yong girii i karamaknga du'sa' adeni' u kanga nakeda tanga ning toni', o yong i tipkadaga wara'ning kama urang udi kuma' kadofira' iba. ");
INSERT INTO uvh_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Ka sidi u kigedanga aming ka kama tubo Judia tara' u ikni' sidi marara bima tanga kama karang base do marani'. A aming ka yong girii ganang ingging marakni' sidindu' base ga' urapsa' bimanga mani'. A aming ka yong girii gaga base indeng ikni' sidi napa' u kanga marara yong bane ganangga' tubobu mo' abani'. Sidi base ga'sa' bimanga mani'. ");
INSERT INTO uvh_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Kama ka wara'ganang wa Anutu wari aming wari kadagang tanga ikiting waraga' mamareng kura'bu kamiamo'ga'. Ning tinga Anutuning midi ka napa' u kadofo' waraga' ka umpang ganang timinggi' kuma' yoking fideta' wari kama ka wara'ganang wa beng guk ning kadofo'. ");
INSERT INTO uvh_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Beng sini' kama ka wara'ganang wa Anutu wari Juda aming ka kami yara'ganang iking yara'sining kadagang waraga' kaba kagaya nakita' u kura' tubobu tiaminga ami taming adi mamareng girii bemni'ga'. Ka mamareng wari kadofo' ganang wa taming ka kabaksi' guk a saba ginggiming inga' ibenga deiakni' waraga' wa ning torik, bibiri' sini' adi mamareng girii sini' bimbem ning. ");
INSERT INTO uvh_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Ka wara'ganang wa kama dibing fam ning aming arantagim ka Anutuga' kabi'guk mo' nakedanga ikiting wari abanga Juda aming i dipmisasu'nanga ning tanga fam ka manggakyap tanga inagira fonga anasining kama indeng indeng wara'ganang kukyapma yaptatorani'ga'. Ning tanga adisining yong girii kareng Jerusalem ya adisining digirapsi' ka aming arantagim nua'ni wari sansaramik sa' ubu tanga ira tipminga yangakni'. Kama paramu' sini' ningsa' tanga ira anganga inga' Anutu ana tubobu udayabinga ganangsa' kabinga mani'ga'. ");
INSERT INTO uvh_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Ka inga' kama ka Amingning Tim Iyak naga tubobu afonga tok wara'ganang wa Anutu wari mayam mayap a bam u ififareinga kuni' sini' ubu dainga yapni'ga'. Abanga gwang undu' tipmarakinga sasabara girii wari marara gigii sa' aratowa'. Ning tinga aming kabi'mo' adi napa' u kanga a gwang sasabara girii wara'ning gigii u naknga mutu tanga kabaksi' mamareng girii naknga paparap senga yarani'ga'. ");
INSERT INTO uvh_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Ning tanga adi bam a napa' napa' ka kunimganang kuta ikiting wari tuntumurum tanga kadapmangsi' ganang didimeng mo' yaranga sansaramik sa' yangakni' u faranga yapma mutu sini' tanga kabaksi' mamareng girii naknga mamareng a mutu wari ifikadaga sini' tinga adi kadaga sini' tini'ga'. ");
INSERT INTO uvh_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Ka napa' mamareng ka u torik wari kadofiinga napni' wa Amingning Tim Iyak naga mungkong ganang tangkunang girii a diok kigineng guk arafok ga'. ");
INSERT INTO uvh_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Ka napa' u tonga yararik wari munumung ko arakadofiinga aming fam kabi'mo' wari u kanga mutu tini' wa aming ka nagata' naktangka ting sidi mutu mo' tini'. Mokngang sidi u kanga nakeda tanga kabaksi' tiptangkanga dasi' kunimganang kuta taranga degaranga adenga o indi kugurang gi' marek wara'ning kama urang udi kuma' kadofanimara' yang ning tonga ade sa' tini' ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Ning tanga Jisas wari kama ka ana tubobu abubu ning wari kadofonga tinga napa' fam kadofo' u kanga nakeda waraga' aming u ning yanggu', ka sidi kadapmang ka firi wap fik a firi fam wari tinga yabiting waraga' sukanting. ");
INSERT INTO uvh_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Wa ning, sidi firi wari sasa' timini afasasu'nanga inga'ni kadofonga titing u yapma wa sidi o mayam ning kama ba kadofira' ning nakedanga tuguting. ");
INSERT INTO uvh_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Ka sidi kadapmang ka firi u yapkedanga tuguting ningsa' ka napa' napa' ka naga u tonga yararik wari kadofinga yaro' u kanga nakeda sa' tanga ning toni', o kama ka Anutu wari aming dabik adining bining ganang manggara kuknipma niptatoreinga iik wara'ning urang udi kuma' kadofasirendonga tara' yang ning toni'. ");
INSERT INTO uvh_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Beng sini' urang sanirik, kama ka u torik wa aming ka kami yara'ganang iking wa fam ka ko mo' kumakni' ganang kadofo'ga'. ");
INSERT INTO uvh_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Ka kama a kunim a napa' napa' tangkunasi fam u defata' wa tubobu wadigi' kuma'sa' bisasu'no'. A napa' kigineng ka naganing midi kareng a nasi' kadapmang didimeng ka naga kamitik wa kadaga a bibi' kabi'guk mo' to', mokngang sini' wa kareng a tangkunang ko ningsa' ira awa'ga' ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Ka Jisas wari midi u tonga ning tanga ananing arantagimni ubu yanggu', ka naganing arantagim sidi kama ari' ka wari kagadofi waraga' sura kafakafa suktangkanga ikanting. Sidi kamaganang ning napa' tangkunasi ka fuksi' yotangka ning nana kareng nibek a ama kagaya siamo' topna ning waraga'sa' ma sura ikni'. Sidi napa' ka ningwaraga'sa' sura ikanting wa kama ka Anutu wari manggaksap titining wari kaga' urapsa' kadofo' wa sidi tugunung titiga' nafek tanga sige marek sa' ma tini' wara' sidi kafakafa suktangkanga tanga ikanting. ");
INSERT INTO uvh_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Ka kama ka wa kamaganang yara'ning kama dibing fam dabiksa' ka indeng ira yareting wara'guk dabiksa' kaga' urapsa' kadofinga yaro'ga'. ");
INSERT INTO uvh_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Ka sidi waraga' sura fikifiki Anutuga' ibang tangkunang tonga ira anting. Ning tinga Anutu wari yotangkasap tinga sidi tangkunang guk giri ikanting wara' napa' mamareng ka u torik wari mo' sifikadauta'. Ning tanga inga' sidi Amingning Tim Iyak naganing dimina ganang ararangeng karengsa' naknga sasoeng sa' adeni' sabok ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Ning tanga fikifiki Jisas adi siring yak girii tempel wara'ganang amanga ami taming u Anutuning midi kareng fianggetarugu'. Yanggera anganga kama garonga tinga wa adi Jerusalem yong girii u kabinga ning tanga kama bubo wapni Oliv u deronga famarugu'. ");
INSERT INTO uvh_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Ka ami taming kabi'mo' adi Jisas ning midi u karengsa' naknga kabaksi' marara fikifiki siring yak girii ga' kamindap gaa' sini' timsa' marara fabiaging. ");
INSERT INTO uvh_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Ka Juda aming wari tim Anutu wari yotangkayap tugu' waraga' sura baret yis guk mo' sanga niaging wara'ning sande girii wapni Pasova wari kagadofi ga' dudure kuma' tugu'. ");
INSERT INTO uvh_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Ka pris girisi a sasuk aming wari Jisas ga' bibi' naknga bak kura Jisas u ugumak waraga' midi tonga naking. Ka adi Jisas u ami taming ning dasi'ganang sarengsa' uuk wa aming wari adisita' bibi' nakyam waraga' sura kapmo'sa' ura tafafera da'ning titi wara'ning kadapmang u katua waraga' tonga naking. ");
INSERT INTO uvh_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Ka aming kadagang Setan wari Jisas ning arantagim 12 wara'ning nua'ni ka wapni Judas Iskariot wara'ganang ira sasuk kadagang ka Jisas u tipkadofaim wara'ning u kuma' amigu'. ");
INSERT INTO uvh_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Ning tinga Judas adi kadapmang ka Jisas u tipkadofaiminga bimbem wara'ning u sura kataunga ning tanga marara sasuk aming a aming arantagim ka siring yak girii tempel u katatoranga som tanga ikiaging wara'sining girisi u yabonga agu'. Anga aming girisi wara'ganang kadofinga kama ka Jisas wari fagu' u yangdidimanga yaregu'. ");
INSERT INTO uvh_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Ning tinga aming girisi adi Judas ning midi u naknga kabaksi' karengsa' naknga Judas u to tanga uningkim mambong amimi waraga' totangkaging. ");
INSERT INTO uvh_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Ka Judas adi aming girisi wari uningkim amimi ga' toging u naknga waraga' aiga sa' tugu'. Ning tanga adi kama ka Jisas wari aming fam guk mo' anapmo' kubaniksa' adeinga kanga anga ininga abanga bimbem waraga' sura Jisas u kafatatora tangkunang tugu'. ");
INSERT INTO uvh_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Ning tanga iya' sande girii Pasova ka Juda aming wari Anutuga' sura baret yis guk mo' sanga nana a sipsip uyamang dipminga sana ning tiaging wara'ning kama didimeng udi kuma' kadofigu'. ");
INSERT INTO uvh_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Ka Jisas wari nana Pasova u sangana waraga' sura ananing arantagimni fama' ka Pita guk ka Jon guk u ning yanggu', sidi yongganang do tim anga yak nua'ni ganang amanga indi mera nantam waraga' nana Pasova tugunung tantamu' ning ina yangkaregu'. ");
INSERT INTO uvh_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Ka adibu ning anigumu', ka girii, yak wa indeng wara'ganang tantamuk ga'. ");
INSERT INTO uvh_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Ka Jisas wari ning yanggu', sidi anga yong girii do kadofinga kantamu' ka aming nua'ni ama kandang gira barungnanga abota' u kanga aming ka u yaranga anga yak ka adi anga amota' wara'ganang adigok dabik amanga ");
INSERT INTO uvh_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","yak tuang u ning anintamu', ai, girii udi arantagimni guk nana merana wara'ning iyung ka ni kabingam ga' tora'. ");
INSERT INTO uvh_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Ning aniinga adi yak wara'ning basing nua'ni ka using kuta adera' u sinagira aranga iyung bane girii nua'ni u sangtintingnota'. Ning tinga sidi nana tugunung wa iyung bane ka wara'ganang tantamu' ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Jisas wari ning ina yangkareinga anga nasi' ka adi kuma' yanggu' wara'ganang didimengsa' kadofaiminga tanga yaranga anga yak wara'ganang amanga tangsana Pasova u tugunungnegumu'. ");
INSERT INTO uvh_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Ka Jisas adi arantagimni fam guk inga' anga kadofinga yak iyung u amanga nana Pasova u naunga kura mareiaging. ");
INSERT INTO uvh_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Ka Jisas wari adining aposel arantagim 12 u ning yanggu', na kagaya bimbem ning. Wara' na tim ka sidigok dabik mera nana Pasova i nana waraga' siamo' nakarik. Ning tanga kagaya wa inga' kuma' bemotik. ");
INSERT INTO uvh_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Ka beng sini' urang sanirik, na kamaganang i ira sidigok nana kubap nanga ira abutam wara'ning nana ari' wa kami mera nantam yang. Sidi nagok nana kubap nua'bu guk mo' nanga ira anganga inga' indi dabik ngingeng beng guk kareng ka Anutuning bining ganang u kura mera nanam waraga' sa' ira anting ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Ning tanga Jisas wari wain ama u bema kap ganang tagara beni Anutuga' ibang asekna ning tonga arantagimni u ning yanggu', sidi dabiksa' ama i bema topnanga yarani'. ");
INSERT INTO uvh_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Beng sini' torik wain mindip ama ka ningyara' wa na sidigok kamaganang i nua' mo' topnok. Mokngang na inga' Anutuning bining wari sareng kadofo' ganang fabanga kuksapma mera topnanam waraga'sa' irotik. ");
INSERT INTO uvh_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Ning ina ning tanga gom imonga nana kafo baret bema Anutuga' ibang asekna ning aninga ning tanga arantagimni wara'siga' upma ima yaranga ning yanggu', nana ka i samarik ya naganing fukna gom ka naga sidi yotangkasap ga' sura naganing fukna ingging kabiaminga nukanting wara'ning kamaga tanga samarik. Sidi i bema nanga nagata' tubobu suknatam tinga wari sidining iiksi' u sifitangkauta' ning ininga naging. ");
INSERT INTO uvh_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Adi u nanga marekinga ama ubu imonga undu' ningsa' tugu' adi ama u tagara kaminga ning tanga ning yanggu', sidi ama i bema topnani'. Ama ka i samarik ya naga sidi yotangkasap ga' sura naganing fukna amaa kwasinotik wara'ning kamaga tanga samarik. Amaa ka yarisa' wa kami Anutu wari sidi yotangkasabinga kareng gi' giri iik wara'ning midi totangka inga'ni tanga iptara'. ");
INSERT INTO uvh_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Ka aming nua'ni ka naga mamareng waraga' nifikadofi ning wa aming ka indigok ingging kubap kuma' marekem wari'sa' tota'. ");
INSERT INTO uvh_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Beng sini' Amingning Tim Iyak naga inga' mamareng u bimbem waraga' wa kadapmang ka na sibeng Anutu ana timinggi' kuma' kanga tanga kabigu' wara'ganangsa' yaranga totik de. Ka aming ka naganing digirapna ganang nifikadofota' waraga' wa ning torik, bibiri' sini' adi ana kadaga wara'ning kadapmang tota' ning togu'. ");
INSERT INTO uvh_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Ka arantagimni adi Jisas wari midi mamareng ka anasining bining ganang unggung yora togu' u naknga kabaksi' mamareng naknga base tanga anasa' kura' anigang tanga ning toging, ai kadapmang kadagang ka ning wa nisi' wari tota' waraga' tora' ning tonga yareging. ");
INSERT INTO uvh_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Ning tanga kama ka wara'ganangsa' arantagimni wari aming ka ni adisining bining ganang wari fam u irafira tim iyak aming ning ira yaptatora waraga' arok tiging. ");
INSERT INTO uvh_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Ka Jisas wari arantagimni wari wap girii bimbem ga' arok tiging u yapma ning yanggu', ka sidi aming girisi iikga' toing wa ning sanotik, aming girisi king kamaganangni adi tangkunang guk ikiting wara' adi girii wa anasining tang ganangsa' ira yaptatoreinga aming wari girii kareng ning yapma adisining wap bema areting. ");
INSERT INTO uvh_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Ka naganing arantagim sidi tim iyak aming wa ma aming wap guk ning ironga wa kadapmang ka adi u titing ning mo' tinting. Mokngang aming ka tim iyak aming ironga wa adi fugu a kabani u bema afanga aming sige wap guk mokngang ning ira amine fam yotangkayap wara'ning kaba guk ira adisining kane aming sige slev ning ira tota' wa giri. ");
INSERT INTO uvh_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Ka sidi kamaganang yara'ning kadapmang wa kuma'sa' naking. Wa ning, nana tugunung wa aming girisi wari guk mo' titing, mokngang. Adi marek sa' tinga nana tugunung kane wa kanesi' aming warisa' tiamiting. A naganing kadapmang ka aming wari girii iikning wa nua'ni ka ning, tim ka aming wari kane aming sige ning ira tota'. Wara' na kadapmang ka u yaranga tanga nasi' kane ga' wa na aming girii ningda'ning mera sidisa' mo' saninga tanamiting. Mokngang na naganing kabakna a wap girii u bema afanga sidining kane aming ningsa' ira yotangkasabitik. ");
INSERT INTO uvh_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Ka sidindu' nasi' mamareng wari kadofinamita' wa sidi mo' nibiting. Mokngang sidi nagok ira kuma'sa' yotangkanabiting. ");
INSERT INTO uvh_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Ka sidi nagok ira kadapmang kareng ka ning u kuma' tanga iking wara' na sibeng Anutu wari aming yaptatora ning girii nipmigu' ning wa nagabu sidindu' sipmotik. ");
INSERT INTO uvh_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Ning tinga inga' kama ka naga aming dabik mera yaptatorok ganang wa sidindu' nagok dabik mera nana kubap nanga ning tanga Isrel ning papase timini ka 12 wara'sining arantagim dabik u yaptatoranam ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Ning tanga Jisas wari inga' mamareng wari kadofingaminga arantagimni wari bima titi waraga' Pita u ning anigu', i nake' Saimon, Setan wari sidi siramira kadapmang ka aming wari wit beng tagagarenga urang titing ningda'ning tasabinga sidining naktangka wari sareng kadofiinga sapkeda waraga' Anutu adindu' aiga kuma' tara' karik. ");
INSERT INTO uvh_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Ka na waraga' sura Anutu wari Saimon gu gifitangkainga mangfu guk mo' titi waraga' wa na ibang undu' kuma' togamarik. Ka inga' gu kabaka faranga nagata' tubobu sura naktangka tanga kuyage fam yara'sining yotangkayap aming ning ire'ga'. ");
INSERT INTO uvh_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Ka Pita wari ning anigu', a girii na idi mangfu titi guk mokngang gam. Na tangkunang guk wara' gu iyung kane kalabus ganang gipminting wa ma nasi' mamareng ni bemotang udi mo' gibotik, nagok kubapsa' tantamuk. Abanga kungkumak totang undu' na guta' tanga gugok dabik kumakantamuk ning togu'. ");
INSERT INTO uvh_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Ka Jisas wari ning anigu', o Pita beng guk sini' urang ganarik kami tiim yara'ganangsa' anganga kama faunga kagare' wari ku munumung ko mo' katota' ganang wa aming wari naganing arantagim ning u kuma' gapkedanga ganinga gu naganing wap waraga' isasura tangkunang famineng ning sini' totang ga' ning anigu'. ");
INSERT INTO uvh_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Ning tanga Jisas wari arantagimni dabik ubu yanggu', ka sidi tim naga Anutuning midi itua kane ga' sangkareguk u tanga wa fuksi' yotangka ning napa' mambong ka ari' a uningkim mambong a kasi' giknim su a kwi' ning wara'guk mo' manggara sigesa' aging udi anga inga' napa' nafek guk tiging wa. Ka adibu ning toging, mokngang indi midi ituagum wa ami taming wari karengsa' naknga yotangkaniminga mambong a nana ni ga' nafek guk mo' tanga karengsa' giri tanga yangagum. ");
INSERT INTO uvh_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Ka Jisas wari ning yanggu', beng sini' kami ya kama ka tim u sangkareguk kama kareng ningwara' mo' kadofota'. Wara' sidi nakeda tanga ari' a nasi' mambongsi' fam wara'guk kubap manggakanting. A aming ka bainat guk mokngang adi ananing saket kareng wa ma mambong tangkunang ni u bema tonga aming fam ga' ima kura'bu wa bainat u amiinga bemnota'. ");
INSERT INTO uvh_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Ka kama mamareng u kadofota' waraga' wa adi midi nua'ni ka tim Anutuning midi umpang ganang ning kuma' yoking, adi aming wari aming kadagang ka kubu a aming dipming sep titiing wara'guk dabiksa' kaing. Ka beng sini' midi ka u yoking a midi fam dabiksa' ka nagata' sura yoking wa kami yara'ganang wari nagaganang beng guk kadofota'. ");
INSERT INTO uvh_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Ka arantagimni adi Jisas ning midi u naknga bainat beng ga' ba sura tora' ning tonga ning aniging, girii, bainat fama' wa giri yang. Ka Jisas adi yangtua guk mo' tanga giri ningsa' yanggu'. ");
INSERT INTO uvh_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Ka Jisas wari midi u ina ina ning tanga marara yak u kabinga fugang kadofinga afanga kadapmang ka ana fikifiki fatarugu' ning u nua'bu tonga arantagimni u inagiknanga kama bubo Oliv ga' mugogu'. ");
INSERT INTO uvh_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Ning tanga anga kadofinga Jisas wari arantagimni u ning yanggu', napa' sansaramik titining wari kadofinga siramikinga kadaga ma tini' wara' sidi dabiksa' ibang tangkunang toni'. ");
INSERT INTO uvh_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Ning ina ning tanga arantagimni u ibinga anapmo'sa' kabi'ning anga kaba mamareng sini' naknga mangmungkupnanga mera Anutuga' ibang ning togu', ");
INSERT INTO uvh_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","o sibeng kagaya i kadofinamonga tara' ya gu tubobu udi girisa' usefinamotang. Ning tinga mo' kadofinamota'. Ka wa naganing sasuk mo' ganing sasuksa' wara' gu nasi' tonga wa girisa' totang ning togu'. ");
INSERT INTO uvh_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","(Ning tinga Anutuning kunim aming nua'ni wari urapsa' afanga yotangkangam tugu'. ");
INSERT INTO uvh_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Ning tanga Jisas adi kaba a fugu mamareng girii sini' naknga ibang tangkunang sini' tonga agu'. Ning tinga fugu mandagam wari aming wari fuksi' gufiinga amaa urang kadofiting ningda'ning kabi'mo' kadofiging.) ");
INSERT INTO uvh_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Ibang u tonga biinga ning tanga marara arantagimni yabonga tubobu abugu'. Abanga kadofinga yapku' ka arantagimni udi kabaksi' mamareng girii naknga fengaging wara'ning ka adi fuksi' baraganeng naknga dama defaging. ");
INSERT INTO uvh_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","U yapma yubusega tanga ning yanggu', ai mamarak tini' dama guk wa nasi'ga' defaking. Mamarak tanga kigineng adenga ibang tangkunang toni', napa' mamareng ka sansaramik sa' titining wara'ganang ma kadani' ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Ka Jisas wari arantagimni u midi ko araininga aming arantagim ka Jisas u bimbem ga' abiging udi kuma' kadofiging. Ka Jisas ananing arantagimni 12 wara'ning nua'ni ka tipkadofiam titiga' yanggu' wapni Judas adi aming u ibinga tim abanga Jisas u bedirira tutu' tangamgu'. ");
INSERT INTO uvh_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Ka Jisas adi kuma' kigedanga ning anigu', aa gu aming wari Amingning Tim Iyak naga kadapmang ka yara'ganang napkedanga abanga bemnap waraga' ba abanga tarang. ");
INSERT INTO uvh_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Ning tinga Jisas ning arantagimni adi aming arantagim girii wari kadofinga Jisas bemonga tiging u kanga Jisas u ning aniging, ai girii indu' bainat guk kura'bu undu' girisa' dipmintam. ");
INSERT INTO uvh_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Ka adining arantagimni nua'ni adi bainatni u urapsa' wenga bema pris arantagim ning tim iyak girisi' ka wapni Kaiafas ning kane aming wara'ning magi kafong kareng tara' u urapsa' kuma' doptagagu'. ");
INSERT INTO uvh_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Ka Jisas wari u kanga ai ning mo' totang, kagabi te' ning anisefinga ning tanga aming wara'ning magi u suroinga magi wari tubobu kaga'sa' karendagu'. ");
INSERT INTO uvh_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Ning tanga Jisas wari pris girisi guk ka aming arantagim ka siring yak girii u katatoriaging a aming girisi fam ka bimbem tonga aging u ning yanggu', aa na idi aming digirap titiing ba wara' sidi kami naga bemnabonga kwak suguk tanga maraknaming. ");
INSERT INTO uvh_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Na fikifiki siring yak girii ganang unggung anga famotik ka sidi bemnap ga' naknga wa ning ganang kuma' bemnabonga tiging. Ka indining tanga sidi kami tiim yara'ganangsa' bemnabonga abing. Beng sini' tiim kangkam ya aming kadagang Setan guk sidining kama sini' wara' sidi kamisa' bemnabonga abing yang ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Ka Jisas wari midi u ina adeinga aming ka bimbem titiga' marakngamging wari Jisas u bema nagira anga pris arantagim ning girisi' Kaiafas wara'ning yak ganang u tonga kamiging. Ka Pita adindu' aming wari Jisas u nagira auinga mandang kubap yaranga anga bangap naro' ira ira famugogu'. ");
INSERT INTO uvh_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Anganga yak ganang u kadofinga Jisas u yak iyung bane nagira amoinga aming fam adi sibim naknga yak wara'ning sinim iyung bane unggung kudip sanga merafaging. Ka Pita adindu' aming wara'siguk kudip u dabik sanga mareiaging. ");
INSERT INTO uvh_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Ka Kaiafas ning kunung taming nua'ni wari Pita u kanga kagafa mimeng tanga ning togu', a idi kuma' kigedarik aming ka idi Jisas guk kubap fengating u fagatik. ");
INSERT INTO uvh_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Ka Pita adi isasura tanga ning togu', a na aming ka u torang wara'guk mo' sini' katik. ");
INSERT INTO uvh_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Ning tanga kabi'ning nua'bu mareia' aming nua'ni wari ubu kanga anigu', a gu udi kuma' gapkedem Jisas ning arantagim wara'ning nua'ni wari merafatang. Ka Pita adi isasura nua'bu tanga ning togu', a mokngang na adining arantagim mo'. ");
INSERT INTO uvh_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Ning tanga fafong da'ning mareia' aming nua'ni wari nua'bu kanga togu', a na midini kuma' nakedarik idi Galili aming Jisas guk beng fengating. ");
INSERT INTO uvh_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Ka Pita wari togu', beng sini' urang torik na aming ka u torang wa nafek sini' tirik. Pita wari Jisas ning wap ari' u isisebenga ning tanga naku' wa kagare' wari ku katigu'. ");
INSERT INTO uvh_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Ka Jisas ana undu' tuboning u tonga kamiinga kuma' tabanga fagagu' wara' Pita adi kagare' wari ku katigu' u naknga tonga kagu' ka Jisas wari kagafa tugu'. U kanga midi ka tim Jisas wari adining wap u isisebegu' waraga' anigu' waraga' tubobu suknatamgu'. ");
INSERT INTO uvh_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Ning tanga kaba mamareng naknga sinim fugang amanga adining kadagang waraga' sura mak fidenga fakogu'. ");
INSERT INTO uvh_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","64","Ning tanga aming ka Jisas u bemging wari Jisas u kadagang taramikonga kwi' kugo' bema Jisas ning de u iptasefingama uuk tanga anigige ning tiging, a gu profet urang udi. Ka gu profet sini' ganang wa aming guguk tara' wara'ning wap u didimengsa' nininga naknam. ");
INSERT INTO uvh_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ning aninga ning tanga midi kadagasi fam kabi'mo' undu' yora anikigenga yareging. ");
INSERT INTO uvh_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Ning tanga kama fagainga Juda ning kaunsil arantagim a pris girisi a sasuk aming ning wari bak tanga Jisas u bema midiganang kamiging. ");
INSERT INTO uvh_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Kaminga ning anigaging, ka gu Mesaia Kasira Aming sini' udep wa ningtua sini' tinga naknam. Ka Jisas wari ning yanggu', naga sangtua totik wa sidi naganing midi udi sigening ningda'ning naknamting. ");
INSERT INTO uvh_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Abanga naga midi ki fam waraga' sangkautik undu' sidi midi tubobu ninang ga' nafek tinting wara' na mo' sanotik. ");
INSERT INTO uvh_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Ka kabi'sini' Amingning Tim Iyak adi aranga Anutu kigigeng ning kafong kareng ganang u mera aming dabik ning girii ira yaptatorota'. ");
INSERT INTO uvh_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Ka kaunsil arantagim wari midi ka u naknga ning aniging, aa gu Anutuning mindingni ning ba torang. Ka Jisas wari yanggu', sida kuma' toing una udi didimengsa' toing. ");
INSERT INTO uvh_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Ka aming girisi wari Jisas ning midi u naknga ning toging, ai indi nua'bu wa nasi'ga' nakdidimonga kapmekantam. Midi kadagang wa ananing mini wari sini' kuma' tora' nakem yang. Indi aming fam nua'bu mo' yangkantam ning toging. ");
INSERT INTO uvh_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Ning tanga Juda ning aming girisi wari Jisas wari midi ka na Anutuning mindingni ning tutugu ningda'ning togu' midi kadagang ning u naknga Jisas u nagira Romni kiap Pailat ganang ubu aging. ");
INSERT INTO uvh_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Anga kiap Pailat ning de ganang u kamiinga adeinga midi ki guk mokngang ka ning tongamging, indi aming ka idi ning fakayam ka adi Juda indining amine kabi'mo' u mandaga' ning iramira fiarara', sidi Romni girii Sisa ning uningkim takis wa mo' kaminting. Abanga adi midi nua'ni ka ning fatora', na Anutuning Kasira aming girii. ");
INSERT INTO uvh_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Ka Pailat wari u naknga Jisas u ning anigagu', ka ma' gu Juda ning girii beng wa. Ka Jisas wari ning anigu', ga kuma' torang una ningsa'. ");
INSERT INTO uvh_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Ning tanga Pailat wari pris girisi guk ka aming arantagim girii guk u ning yanggu', na aming yara'ning kadagang girii ka ni ka kagaya amimi ning guk mo' karik. ");
INSERT INTO uvh_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Ka aming girisi adi u naknga midi tangkunang ning toging, a mokngang adi kadagang fatita'. Adi kane ka ami taming u aming girisi ning midi karangkang titi waraga' yanggek wara'ning wa tim kama tubo Galili do tipmarara tanga ababanga kama tubo Judia tara' i tasasu'nanga ning tanga wa Jerusalem yong girii ganang ibu tara' yang ning toging. ");
INSERT INTO uvh_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Ka kiap Pailat wari adisining midi u naknga ning yanggu', ka ma' idi Galili aming wa. ");
INSERT INTO uvh_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Ka adibu weng Galili aming ning toging. Ka kama tubo Galili u katatorarugu' wara'ning king Herot undu' Jerusalem yong girii ganang unggung kuma' anga yagu'. Wara' Pailat adi aming wari Galili aming ning toging u naknga aming u ning yanggu', ningwara' king Herot ga' ubu nagikngama auinga nakngamo'. Ning ininga aming wari Jisas u nagira king Herot ubu kaunga aging. ");
INSERT INTO uvh_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Ning tanga nagira anga Herot ganang u kadofiging. Ka Herot adi timinggi' Jisas wari kane tangkunang mirakel tanga fiararugu' wara'ning midi ne u naknga Jisas u kaga ga'sa' fanakarugu'. Ka mokngang, kaga guk mo' fatarugu' wara' adi Jisas u kanga kaba karengsa' naknga o girisa' nagiknama abing. Kami adi napa' u naganing dana ganang sini' ubu tinga kautik ning suku'. ");
INSERT INTO uvh_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Ning tanga king Herot wari Jisas u adining midiganang kaminga midi kadapmang kuni' kuni' kabi'mo' aniganga yaregu'. Ka mokngang, Jisas adi midi tubobu kabi'guk mo' togu'. ");
INSERT INTO uvh_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Ka pris girisi a sasuk aming arantagim adindu' du' unggung adenga midi mandaga' ki guk mokngang sige kabi'mo' u kigineng sini' animbenga yareging. ");
INSERT INTO uvh_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Ning tinga Herot guk ka adining ami'ning aming arantagim guk adindu' Jisas u kaguruda tanga anikigenga kadagang taramiking. Ning tanga kangkama kareng ka aming girisi king warisa' ipmayaging u bema tabanga sige kamingama anigara tanga kiap Pailat ga' tubobu nagikngama au ga' yangging. ");
INSERT INTO uvh_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Ka Herot guk ka kiap Pailat guk wa tim adi digirap ningda'ning naro' naro'sa' ikiagumu'. Ka inga' aming wari Jisas u bema adisining midiganang kamiinga Pailat wari nakngama Herot ga' ubu anigarangam a Herot adibu nakngama undu' Pailat ga' tubobu anigarangam ning u tugumu' wara'ganangsa' wa adi kabaksi' kubaniksa' ning ubu yagumu'. ");
INSERT INTO uvh_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Ning tanga Jisas u nagira kiap Pailat ganang tubobu abanga kadofinga adeging. ");
INSERT INTO uvh_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Ka Pailat wari pris girisi a aming girisi a ami taming sige wara'guk dabik u katiana abanga adiganang u bak kura adeinga ning yanggu', i nakni' sidi aming yaraga' wa ning tonging, adi ami taming ning kadapmang kareng tipkadanga fiarara'. Ka na waraga' wa sidining dasi'ganang kuma' anigangak. Ka mokngang, na midi ka sidi napa' sansaramik tanga fiarara' ning fatoing wara'ning ki sini' guk mo' katuarik. ");
INSERT INTO uvh_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Abanga Herot adindu' adining kadagang ni guk mo' katuanga wa nagata' tubobu anigaranamira' yang. Ka sidi ugumak titiga' toing wa adi nasi' kadagang guk tugu' wara' ugumakantam. Na adining kadagang ni gu mo' katuarik wara' na ugumak titiga' sige guk mo' aigasamotik, mokngang sini'. ");
INSERT INTO uvh_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Wara' ning torik, na naganing arantagim u ininga wari natam titiga' fifefi sa' tanga kabiinga mugo tota' ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Ka Romni kiap ka Juda ning kamaganang u ikiaging adi gurak kubanik kubanik fikifiki wa Juda aming ning kabaksi' ifikarenda waraga' sura Juda ning sande girii Pasova wara'ganang adisining aming fam ka iyung kane kalabus ganang iik u kubanik ning ka sige fadara kabiaminga mugo waraga' kuma' totangkaging. ");
INSERT INTO uvh_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Ka adi sande Pasova fikifiki wa kadapmang ka u yaranga tiamiaging wara' kama ka wara'ganang wa Juda aming adi Jisas wa sige ma kabiinga mawa' ning tonga ku ning katiging, gu Jisas wa ugumak te' a Barabas wa sige kabaniminga mawa' ning katiging. ");
INSERT INTO uvh_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Ka Barabas ka wa aming kareng mo', adi tim Jerusalem yong girii aming fam wara'sining kabaksi' u ifimarakinga adi gavman ga' digirap tanga marara ami' girii tiging. Abanga adi aming nua'ni ura sepku' waraga' tanga Romni gavman wari bema tonga kalabus iyung dasiinga tanga itarugu' u kabiam ga' toging. ");
INSERT INTO uvh_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Ka Pailat adi Jisas ugumak titining ki guk mo' kagu'. Wara' adi Jisas u sige kabiinga mugo ga' sura aming u midi ka tim kuma' yanggu' unggung nua'bu yanggu'. ");
INSERT INTO uvh_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Ka aming arantagim girii adi Pailat ning midi u naknga sige kabiinga mugo ga' bibi' naknga ku ning katiging, a gu Jisas wa mo' kabotang ugari tini' firi ganang ugarini', ning u dabiksa' kating yareging. ");
INSERT INTO uvh_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Ning tanga Pailat wari aming u midi ka tim kuma' yanggu' unggung ka gipmam ganang nua'bu yanggu', ka adi nasi' kadagang tugu', kadagang ni guk udep tugu' wa ninang tinga nakok. Na adi ugumak ning kadagang ni guk mo' karik mokngang sini' wara' na naganing arantagimna ina fifefi sa' tanga kabiinga mauta', ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","24","Ka mokngang aming arantagim girii adi Jisas u ugumak titiga' naknga ku bang sini' ning nua'bu katiging, a wa firi ganang ugarini' firi ganang ugarini', ning u kabi'mo' katinga yareging. Ning tanga adisining ku bang katiging wari tanga Pailat ning sasuk u bema afanga kaba tipfareinga adi uuk titiga' aigaim ubu tugu'. ");
INSERT INTO uvh_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Ning tanga Pailat adi adisining sasuk u yaranga aming kadagang Barabas ka tim aming ifimarakinga ami' girii tiging a aming dipming sep titiing wa kabiam tanga Jisas wa Juda aming arantagim wari napa' anasining sasuksi' ganangsa' tonga tantaramik waraga' soldia ning kafasi'ganang kabiamgu'. ");
INSERT INTO uvh_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Ning tanga soldia wari Jisas u firi ganang ugari waraga' ananing firi ugari u bema barungnangama nagira aging. Anganga kadapmang bining ganang yong Sairini wara'ni aming nua'ni ka wapni Saimon u katuaging. Adi yoring u kabinga abanga Jerusalem yong girii u kabi'sini' kagadofi ga' dudure kuma' tugu' u katuanga suronga ning aniging, gu Jisas ning firi ugari i barungnangama aya'. Ning tinga Saimon adi nakyam sa' tanga Jisas ning firi ugari u bema barungnanga adisigok kubap aging. ");
INSERT INTO uvh_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Ka aming arantagimni kabi'mo' ka Jisas ga' naknga yaranga fengakiaging adindu' kubap iwara anga taming fam adi Jisas ga' sura mak kara famugoging. ");
INSERT INTO uvh_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Ka Jisas wari adisining mak u naknga faranga yapma ning yanggu', Jerusalem taming sidi bibiri' wa nagata' mo' naknga kakanting. Mokngang sidi kabaksi' mamareng a bibiri' beng ka mamareng girii ka inga' sidi a sidining sabase ganang kadofisamo' waraga' naknga kakni'. ");
INSERT INTO uvh_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Beng sini' kama ka wara'ganang wa aming wari taming ka kami yara'ganang saba guk mo' ibenga sigesa' iking u yapma ning toni'ga', o adi saba guk mokngang wara' mamareng wa anasa' beming wara' sia da'ning yabem. A aming fam indi saba guk wara' indi mamareng girii sini' bemem ning toni'ga'. ");
INSERT INTO uvh_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Ning tanga kama ka wara'ganang wa adi kama kadagang sini' kadofiamo' u kanga kabaksi' mamareng girii naknga kama bubo u ning yangni', o kama bubo sidi urapsa' danga abanga farafanipsasu'na tini'. Ning tinga indi bisasu'na tanga mamareng girii i kabinam ning toni'ga'. ");
INSERT INTO uvh_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Beng sini' na aming didimeng kareng ka firi ka' ameng guk ka kudip wari dada ning guk mokngang ningda'ning unggung ka adi kami kadagang naramikonga ting. A aming ka kadagang titisi sidi firi kafo ningda'ning iking wara' sidi mamareng wari kudip da'ning wadigi'sa' dasapsasu'no'ga'. Wara' sidi mak wa waraga' sura kakni' ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Ka adi aming kadagang titisi fama' undu' Jisas guk dabik ugariap waraga' kubap inagiking. ");
INSERT INTO uvh_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Inagira ning tanga anganga kama wap ka Golgota ka ki kati ganang ning aniaging u kadofinga aming famineng u manggara firi ugari ganang ugariapking, Jisas ana ka bining a aming fama' wa nua'ni ka Jisas ning gagaa ka kafong kareng ganang tara' a nua'ni ka kafong kesini ganang tara' ning ugariabinga adeging. ");
INSERT INTO uvh_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Ka Jisas adi firi ugari ganang u tapma adenga beni Anutuga' ibang ning togu', o sibeng adi napa' i ting ya kafakafa guk mo' naknga ting wara' gu adisining kadagang wa suknakubeyam te' ning togu'. Ning tanga aming arantagim ka Jisas se' ugariapking adi Jisas ning kwi' a kangkama karesi u tanga manggakna waraga' kat tiging. ");
INSERT INTO uvh_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Ka aming arantagim sige kabi'mo' undu' unggung adenga Jisas se' ugariapking u fidenga fiapking. Ka Juda ning aming girisi adindu' unggung adenga Jisas u kanga anikige ning tiging, a adi Anutuning Kasira Aming sini' udep wa aming fam yotangkaimita' ning wa kami ananing fugu ubu yotangkanainga kanam ning toging. ");
INSERT INTO uvh_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Ning tinga Rom ning soldia ka fonga ugariap tiging adindu' unggung adenga wain ama kiptang ka viniga u yogubura aminga anikige ning tiging, ");
INSERT INTO uvh_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","ai, gu Juda ning girii beng udep wa ganing fuka ubu yotangkanainga gapnam. ");
INSERT INTO uvh_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Ka adi tim midi pumpurum kabi' ka parang dibing ganang ning kuma' yoking, aming ka ya Juda ning girii. Ning yora bema Jisas ning firi ugari furo'ning ka Jisas ning ki ganang didimeng tapking waraga' sura wa soldia adi midi anikige ka u tiging wang. ");
INSERT INTO uvh_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Ka aming kadagasi fama' ka Jisas guk dabik ugariapking wara'ning nua'ni wari Jisas u ning anikigegu', ai, gu Kasira Aming urang udi gu ganing fuka yotangkanga a indi yotaangkanipma ning guk mo' wa indining tarang. ");
INSERT INTO uvh_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Ka amingni nua'ni wari adining midi u naknga ning kafanga anigu', ai gu midi kadagang torang. Gu kami indi dabiksa' kungkumak tanga Anutuning de ganang adentam wara'guk mo' u sura torang. ");
INSERT INTO uvh_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Gugok ka nagok indi indining kadagang girii wara'ning kagaya didimeng bemiamuk. A adi kadagang ni guk mokngang kagaya sigesa' bemara' waraga' sure' ning anigu'. ");
INSERT INTO uvh_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Ning tanga Jisas ubu anigu', o Jisas inga' gu yong kareng ganang mera girii ira aming yaptatore' ganang wa gu nagata' undu' sure'. ");
INSERT INTO uvh_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Ka Jisas wari ning anigu', beng sini' ganirik kami kaga'sa' gu nagok yong kareng paradis ganang anga marekantamuk ning anigu'. ");
INSERT INTO uvh_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Ning tanga Jisas u ugaringa anganga kama wari sidii sini' ka 12 klok didimeng kadofinga mayam de wari kangkamara tanga kama kama dabiksa' kama garinga yaregu'. Garinga kangkamaranga anganga kama wari 3 klok kibiri ning kadofiinga wa kama kangkam wari tubobu fagagu'. ");
INSERT INTO uvh_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Ning tinga kama ka wara'ganang kaga'sa' siring yak girii tempel ning kwi' girii ka iyung bane kabasi' tapni wara'ning bagi tapsaseinga fiderugu' wari bining unggung ibaramara tubo kidagang tinga iyung kabasi' tapni wari sangangsa' ubu fidegu'. ");
INSERT INTO uvh_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Ning tanga Jisas wari kungkumak tonga ku ning katigu', o sibeng naganing urana guning kafaga ganang kuma' kabirik wang. Ning tonga kungkumak wadigi' tugu'. ");
INSERT INTO uvh_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Ka Romni soldia arantagim wara'sining yaptatora aming girii nua'ni adi Jisas ning midi ka u naknga kaba ubu faranga Anutuning wap bema aranga ning togu', o beng sini' aming ka idi aming didimeng beng guk karik ning togu'. ");
INSERT INTO uvh_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Ning tinga ami taming kabi'mo ka Jisas se' ugariapking u yabonga aging adi napa' girii ka Jisas ning kungkumak ganang kadofigu' u kanga base ubu tanga kafasi' ki singa yaksingga' tubobu mugoging. ");
INSERT INTO uvh_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Ka Jisas ning amine a taming fam ka tim Jisas yaranga Galili yong u kabinga Jerusalem yongga' kubap areging dabiksa' adindu' aming wari Jisas u uronga nagira aging wa mandang iwara anga dokning adenga napa'napa' ka Jisas u ura ganang tiging wa adi kuma'sa' fonga fiapking. ");
INSERT INTO uvh_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","52","Ka yong Arimatiani Juda aming nua'ni ka wapni Josep wari Jisas ning fugu kungkumong u bema tonga unafarafi waraga' sura kiap Pailat u anga anonga agu'. Ka Josep adi aming didimeng kareng adi Anutuning midi u naknga kama ka inga' Anutu wari aming dabik u adining bining ganang fonga kukyapma yaptatora wara'ning wari kagadofi waraga'sa' sura itarugu'. Abanga adi Juda ning kaunsil arantagim wara'ning nua'ni ka adi tim bak kura kaunsil fam wari Jisas uuk ga' midi totangkaging wa adi kadapmang ka waraga' bibi' nakyama aiga guk mo' tugu' wari agu'. ");
INSERT INTO uvh_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Anga kadofinga Pailat u anigu'. Ka adi aigangam sa' tinga anga Jisas ning fugu kungkumong firi ugari ganang ukinga kumara fidegu' u tataranga bema kwi' fafa' wari tumura ning tanga bema tonga kama ginang ka tim kuma' unanga kabiging wara'ganang dasinga kufagu'. Ka kama ginang ka wa kama bubo ganang dabak uneging. Ka adi aming kungkumong nua'ni tim guk mo' tonga kufaging, inga'ni sa' sige unanga kabiging wara'ganang tonga kufagu'. ");
INSERT INTO uvh_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Ka kama ka Jisas ning fugu u tonga kamigu' wa fraide kibiri ka Juda aming wari adisining mengkura ning kama sabat u kanga defak waraga' tugunung ari' tiaging wara'ganang didimeng bema tonga kamiging. ");
INSERT INTO uvh_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Ka taming fam ka tim Jisas guk kama tubo Galili do kabinga Jerusalem yongga' kubap dabik areging adindu' Josep u yaranga anga Josep wari Jisas ning fugu kama ginang ganang dasonga tugu' u adenga kadidimaging. ");
INSERT INTO uvh_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Kanga ning tanga anga taming adi Jisas ning fugu kungkumong wara'ganang sufurungam waraga' sura napa' mupmu guk karesi ka sanda a wel a firi amum mupmu guk karesi fam u yapma manggeging. Ka adi mengkura ning kama sabat ganang wa kane titiga' tapni tang tiaging wara' adi sabat udi kuma' kadofigu' u kanga tugunung sa' tanga fonga kura. ");
INSERT INTO uvh_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Ka Juda aming adisining mengkura ning kama sabat kadofigu' wari biinga taming fam ka Jisas ning fugu ganang sufurangam ga' napa' mupmu guk ka kuma' fonga kura deking wari sande kamindap gaa' sini' marara napa' mupmu guk tugunungneging u manggara Jisas ning fugu kama ginang ganang u kaunga aging. ");
INSERT INTO uvh_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Anga kama ginang ganang do kadofinga kaging ka uningkim pampangareng girii ka tim Jisas ning kama ginang u tipdaranga tabanga isefiging udi kuma' kadara kama ginang u kabinga daranga anga dokning defagu'. ");
INSERT INTO uvh_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","U kanga anga kama ginang iyung u mindigera amanga Jisas ning fugu u kaga ga' ning tonga deyangaging wa mokngang kamasa'. ");
INSERT INTO uvh_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","U kanga ai, ya indeng manga' ning tonga kama ginang iyung unggung ko basenga fideyangaging ka aming fama' wari anaganang ungung urapsa' kadofinga adegu'. Ka adisining kwi'si' wa diok kigineng guk. ");
INSERT INTO uvh_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Ka taming adi aming fama' wara'sining diok kigineng u kanga desansoringa tanga mutu tanga mungkupna sa' tanga adeging. Ning tinga aming fama' wari midi ning yanggumu', sidi aming ka ka' ningsa' ikita' adita' wa aming kungkumosi ning kama ganang yara'guk wa nasi'ga' abanga fawening. ");
INSERT INTO uvh_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Jisas adi kama ginang ganang ingging ko mo' defata'. Tubobu kuma' marara manga'. Sidi midi ka tim adi Galili do yaging u tanga sanggu' waraga' sura nakedani'. ");
INSERT INTO uvh_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Adi ning togu', inga' aming nua'ni wari Amingning Tim Iyak u tipkadofiaminga aming kadagasi arantagim wari bema tonga firi ganang ugariinga kungkumak to'ga'. Kumara kama fama' ibinga nua'bu fawa' ganang uya' ka tubobu mararo' ning urang sanggu' waraga' sukni' ning yanggumu'. ");
INSERT INTO uvh_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Ning tinga taming adi adisining midi u naknga midi ka tim Jisas ana yanggu' waraga' tubobu sura nakedanga o beng guk ning tonga kama ginang u kabinga yongga' tubobu mugoging. ");
INSERT INTO uvh_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Anga yongganang do kadofinga Jisas ning arantagim 11 guk ka naktangka aming fam guk dabik u napa' u kaging wara'ning midi u ininga naking. ");
INSERT INTO uvh_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Ka taming ka Jisas ning kama ginang u kanga anga aposel arantagim yangging wara'sining fam ning wapsi' wa Maria ka yong Makdalani a Joana a Maria ka Jems ning mengni abanga taming fam ka Jisas se' guk fengakiaging undu' dabik aging. ");
INSERT INTO uvh_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Ka aposel arantagim adi midi ka taming wari anga yangging u naknga ai, beng guk unda' ning sura naktangka guk mo' tiging. Mokngang adi midi sigening da'ning naknga mareiaging. ");
INSERT INTO uvh_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Ka Pita adi taming ning midi u naknga kadidima tonga marara urapsa' unara anga Jisas ning kama ginang ganang donggung mindigera amanga deyangagu' ka mokngang, aming beng guk mo' kagu'. Kwi'ni ka gipmam defak tugu' ganang ibinga mugogu' unggungsa' yapku'. ");
INSERT INTO uvh_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","14","Ning tanga kama ka wara'ganangasa' ka naktangka aming fama' wari amise fam u ibinga Jerusalem yong girii u kabinga yong kabasi' Emeas ga' mugogumu'. Ka kadapmang ka yong kabasi' waraga' ayaging udi paramu' gi' ka 11 kilomita ning ayaging. Ka adi u yaranga anga nasi' nasi' ka Jisas ura ganang tiging wara'ning midi u tong tonga famugogumu'. ");
INSERT INTO uvh_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Ka adi midi u tonga famugogumu' ganang ka Jisas udi sigisi' ganang unggung kadofinga iwara aramugogu'. ");
INSERT INTO uvh_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Ka adi u kanga faranga kanga aming nua'ni ba ning tonga kafera adegumu'. ");
INSERT INTO uvh_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Ka Jisas wari ning yangkagu', sidi midi wa nasi'ga' tonga fabayamu'. ");
INSERT INTO uvh_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Ka aming fama' adi Jisas uking waraga' sura kabaksi' mamareng naknga tonga famugogumu'. Wara' adi Jisas wari yangka tugu' u naknga aming nua'ni ka wapni Kliopas wari Jisas u ning anigu', ai, gu Jerusalem yongga' wa kamisa' abarang wa, a napa' girii nua'ni ka Jerusalem yong girii ganang i kadofigu' udi gu mo' ba kagung. Aming yong indeng wara'ni dabiksa' ka Jerusalem yongganang ingging fagum indi napa' ka u kuma'sa' kasasu'negum ning anigu'. ");
INSERT INTO uvh_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Ka Jisas wari nua'bu yanggu', nasi' kadofigu'. Ka adibu ning anigumu', mo' sara aming wari Jisas Nasaretni ugumoging waraga' tonga fabayamuk gam. Ka aming ka wa indi Anutuning profet nua'ni fagatam. Adi Anutu girii ning de ganang a ami taming ning dasi'ganang kane kigineng a midi itua tangkunang tanga yareinga ami taming dabik adi kuma'sa' fagating. ");
INSERT INTO uvh_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Ka indining pris girisi guk ka aming girisi fam guk wari bema Romni gavman ning kiap Pailat ga' amiinga kiap wari kungkumak titiga' tuguinga bema tonga firi ganang ugariging. ");
INSERT INTO uvh_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Ka indibu aming ka udi tim aming girii nua'ni ka inga' Juda aming indi gavman nua'ni ning kapmik ganang ira kane kagaya tanga ikitam u tubobu udanga manggaknip ning wari abubu ga' urang fatuguting ubadep ning tonga yaranga fengatam. Ka mokngang kuma' ugumoging. Ka adi u uking wara'ning wa kama fama'sa' mayamu' a famineng ning uya' kami fanga' yang. ");
INSERT INTO uvh_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Abanga napa' nua'ni ka undu' kami kamindapking ganang ka taming fam ka indining arantagim ganang wari gaa' marara anga Jisas ning kama ginang ganang do amanga ");
INSERT INTO uvh_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","kamasa' denga abanga nining waraga' undu' sasuk mimeng ko tanga fengakem. Adi ning abanga tonging, indi kama ginang ganang wa Jisas ning fugu guk mo' kayam. Ka Anutuning kunim aming ensel warisa' adenga ning niniamu', aming ka u kaunga abing wa ingging ko mo' defata', ka' tubobu kuma' marara ita' ning tonging. ");
INSERT INTO uvh_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Ka indi adisining midi u naknga aming fam wari kadidima sini' tonga marara anga Jisas ning kama ginang ganang do amanga Jisas ning fugu ga' ning tonga denging undu' mokngang kamasa', kaga guk mo' tinging. Adi napa' ka taming wari tim kuma' yapma abanga tonging unggung didimengsa' yapma yaranging ning aninga yaregumu'. ");
INSERT INTO uvh_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Ka Jisas wari ning yanggu', a sidi sasuksi' guk mokngang. Sidi midi ka tim profet wari umpang ganang kuma' yoking wara'guk mo' ba indangira nakitamu'. ");
INSERT INTO uvh_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Midi wa ning urang yoking udi, Kasira Aming adi tim ka kagaya bema ning tanga aming girii wa inga' iro' ning yoking. ");
INSERT INTO uvh_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Ning ina ning tanga midi tangkunasi fam ka tim Anutu wari inga' Jisas ana kadofinga kane a kungkumak ka u tugu' waraga' tim Moses a profet fam ininga umpang tang ganang kuma' yoking wara'ning ki u yangdidimanga yaregu'. ");
INSERT INTO uvh_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Ning tanga Jisas wari midi u ina ina anganga yong kabasi' u kadofinga aming fama' wari yong waraga' mugoinga Jisas adi kadapmang ka yaranga au tiging u ko yaranga maunga tugu'. ");
INSERT INTO uvh_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Ka kama udi kuma' kibiridagu' wara' aming fama' adi Jisas wari ko maunga tugu' u kanga ning anisefigumu', ai amina, mayam de kuma' mara' i kaya'. Mo' mautang, indigok ingging anga deknam. Ning aniinga nakyam sa' tanga aming fama' u iwara adisining yongganangga' mugoging. ");
INSERT INTO uvh_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Anga yongganang kadofinga mareia' nana naunga tiging. Ka Jisas wari nana kafo baret u bema Anutuga' ibang asekna ning tonga adisita' upma yamgu'. ");
INSERT INTO uvh_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Ning tinga aming fama' adi kadapmang ka nana tanga yamgu' wara'ganang urapsa' kigedanga nakedagumu'. Ka Jisas adi urapsa' tafaferanga ibinga mugoinga aming fama' adi adining nonda nua'bu guk mo' kagumu'. ");
INSERT INTO uvh_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Ning tanga aming fama' adi u kanga nakeda tanga ning togumu', ai beng sini' idi Jisas ane' unda' gam. Adi kadapmang ganang do Anutuning midi umpang ka tim profet yoking wara'ning ki u ningdidimanga fabanga' ganang u tanga wa indi adining midi wari kabakni' guk indifimarakinga karengsa' nakngamuk ning togumu'. ");
INSERT INTO uvh_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Ning tong tonga marara Jisas ning arantagim u inonga Jerusalem yong girii ga' tiim kaga'sa' tubobu agumu'. Anga kadofinga Jisas ning arantagim 11 guk ka naktangka aming fam guk u anga yapma nasi' midi ka adi tanga agumu' wara'ning u ko inonga tugumu' ka adi aming fama' u ning urapsa' yangging, ");
INSERT INTO uvh_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","ai, girii urang udi tubobu beng marara' Saimon Pita wari ubu kuma' anga kanga abanga ninara' yang. ");
INSERT INTO uvh_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Ning tinga aming fama' adindu' nasi' midi ka Jisas wari kadapmang ganang kadofinga tiamgu' a nana ibang tonga iminga kigedagumu' wara'ning u ina yaregumu'. ");
INSERT INTO uvh_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Ka arantagimni wari nasi' midi ka Jisas wari tubobu marara adiganang kadofiama napa' fam tiaminga kaging wara'ning u ko mera aratoging ka Jisas wari urapsa' kadofinga adisining bining ganang unggung adegu'. ");
INSERT INTO uvh_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Ka arantagimni adi u kanga aming uring ba ning tonga mutu girii tanga mareiaging. ");
INSERT INTO uvh_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Ka Jisas wari ning yanggu', ai sidi nagata' mutu tanga sasuk mimeng mo' tinting. Na aming uring mo', naga urang warisa' abanga aderik. ");
INSERT INTO uvh_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Sidi naganing kana kafana nil gipmam i abanga yapma sasaro' tanga nakni'. Aming uring adi fuksi' gom a kati guk mo' yating. ");
INSERT INTO uvh_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Ning ina ning tanga kayong kafong u yangtintingneinga arantagimni dabiksa' marara kasasu'neging. ");
INSERT INTO uvh_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Ka arantagimni adi Jisas u kanga kabaksi' karengsa' udi giri naking de ka adi o Jisas ana beng sini' ba ning guk mo' naktangkaging. Mokngang, adi sasuk usap ko tiangaging. Ka Jisas adi kigeda sini' titiga' sura yangitintingna sini' tonga ning yanggu', sidi nana dibing guk udep nanga kuring wa bemnam tini', nana totik. ");
INSERT INTO uvh_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","43","Ning ininga arantagimni wari ama ging kafo dibing nanga kamiging u bema tabanga amiinga adisining dasi'ganang unggung mera nainga adi dabiksa' kasasu'neging. ");
INSERT INTO uvh_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Ning tanga Jisas wari midi ning yanggu', ka sidi napa' ka nagaganang i kadofinaminga kaing yaraga' wa na sidigok kubap ira yangatam u tanga kuma'sa' sana abutik. Napa' yara'ning midi wa Moses ning midi kadapmang tang ganang a midi umpang ka profet fam wari yoking abanga midi dibing fam ka umpang wap ka Sam wara'ganang u yora yareging wari tuguting wa adi nagata'sa' sura yoking. Ka na midi ka wara'ning bengni wari kagadofi ga' urang sanitik wa kuma' kadofira' yang ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Ning tinga arantagimni adi Jisas wari yangdidimanga yaregu' u naknga Anutuning midi ka tim profet wari yora yareging wara'ning ki wa inga' sura nakedaging. ");
INSERT INTO uvh_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Ning tinga Jisas wari ning yanggu', beng sini' midi nua'ni ka timinggi' Anutuning midi umpang tang ganang yoking wa ning fideta', Kasira Aming adi kagaya bema kungkumak tanga kama famineng ning ibiinga wa Anutu wari tubobu tipmararo'ga'. ");
INSERT INTO uvh_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Ning tinga aming wari adining wap a midi u bema anga aming wari midi ka u naknga kabaksi' fareinga Anutu wari adisining kadagang u suknakubeyam waraga' ina yarani'ga' ning yoking. ");
INSERT INTO uvh_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Ka sidi naganing midi i bema ituanga yara wara'ning wa tim munumung ka Jerusalem yong girii ganang ingging tipmarara tinting. Tanga anganga kama dibing dabiksa' u tasasu'nanga yarani' ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Ka na tim ka sidi yotangkasap ning napa' tangkunang nua'ni ka tim sibeng Anutu wari sidita' sansam ga' totangkagu' u aranga anigarasamotik. Wara' sidi yong fam ga' wa urap mo' papusinanga manting, sidi Jerusalem yong girii ganang ingging bak dabiksa' kura ikni'. Iya' inga' tangkunang wari sidiganang afuinga u bema wa giri yong fam ga' ubu mani' ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Ka Jisas wari midi ari' u ina ina ning tanga arantagimni u inagira Jerusalem yong girii u kabinga yong kabasi' Betani waraga' inagira aging. Anga kadofinga arantagimni u fonga bak kukyapma Anutu wari yotangkayap waraga' kisi' u suroyapma ibang totangkayamgu'. ");
INSERT INTO uvh_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Jisas wari ibang u ko aratuguinga beni Anutu wari kunim ganangga' nagira areinga iibi tugu'. ");
INSERT INTO uvh_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Ning tinga arantagimni adi u kanga o adi indining girini' beng guk ning tonga kabaksi' karengsa' naknga mesisiringa girii tanga Jerusalem yongga' tubobu mugoging. ");
INSERT INTO uvh_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Anga kadofinga Jerusalem yongganang unggung ira fikifiki siring yak girii tempel ganang u amanga Anutuning wap bema aranga mesisiringa sa' tanga ikiaging. ");
INSERT INTO uvh_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Ka timinggi' timinggi'sini' napa' ni guk mo' kadofigu' ganang ka Midi adi ningsa' itarugu'. Ka Midi ka wa Anutu guk kubap ikiagumu'. Midi ka undu' Anutu. ");
INSERT INTO uvh_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Beng sini' Midi adi Anutu guk timinggi' ningsa' ira abugumu'. ");
INSERT INTO uvh_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Ka kama kunim a napa' napa' fam dabiksa' wa kadapmang nua'ni ganang guk mo' kadofigu', mokngang sini', Anutu wari Midi beng guk ka wara'ganangsa' tasasu'negu'. ");
INSERT INTO uvh_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Ka Midi ka wa ka' iyak a iyak didimeng ning ki sini' wara' amingga' ka' iyak a sasuk kareng ka diok sangang da'ning u nimita'. ");
INSERT INTO uvh_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Ka Midi wara'ning iik kareng ning kigineng ka diok sangang da'ning wari iik kadagang ning kama kangkam u dioksangandainga kama kangkam ka wari tipkangkamara guk mo' tita' mokngang sini'. ");
INSERT INTO uvh_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Ka diok kareng ka wari kagadofi ga' wa tim ka Anutu wari aming nua'ni tipkadofinga anikaregu'. Aming ka wa aming ama iyam ning ka wapni Jon. ");
INSERT INTO uvh_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","8","Ka diok wa Jon u mo', mokngang, adi Anutu wari kane ka diok wari kagadofi wara'ning midi ka aming u yangnataminga aming wari diok waraga' naktangka tanga iik waraga'sa' anikaregu'. ");
INSERT INTO uvh_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Ka diok ka Jon wari kagadofi ga' u togu' wa diok kareng kigineng guk ka ami taming ning kabaksi' ifasangandainga iik didimeng titi wara'ning ki beng sini'. ");
INSERT INTO uvh_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Ka beng sini' aming a napa'napa' wa anasa' tugu' wari kamaganangga' afugu' ka aming adi kigeda tanga o tuang ana ba abara' ning guk mo' toging. ");
INSERT INTO uvh_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Abanga adi yong nua'ni ganang mo' kadofigu'. Mokngang adi ananing amine ning yong ki ganang sini' kadofigu'. Ka amine adi adita' naknga kafakafa guk mo' tanga bema kamiging. ");
INSERT INTO uvh_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Ka aming fam ka kafakafa tangama adita' naktangka tiging wa giri, adi yotangkayap tinga naktangka tanga wap ka Anutuning mindine wara'guk ira aging. ");
INSERT INTO uvh_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Ka wap ka Anutuning minding wara'guk iikning wa mengbe anasa' ibenga iyok a kadapmang ka aming anasa' kaba marara titi ning wa ma aming ananing sasuk kigineng wari tanga iikning guk mokngang sini', wa Anutu warisa' ifikadofiinga ikiting. ");
INSERT INTO uvh_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Ka Midi ka wari afanga indining bining ganang i aming ubu igira kadofinga indigok ingging kubap yagum. Adining iik a midi wa didimeng kareng sini', ka adining kigineng girii wa kuma'sa' kagum. Adi Anutuning mindingni kubaniksa' beng sini' wara' adining kigineng wa beni Anutuning kigineng guk dabiksa'. ");
INSERT INTO uvh_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Ka Midi ka wari aming kuma' igira anga kadofiinga Jon Baptis wari u kanga aming u ning yanggu', aming ka wa tim na waraga'sa' sura midi ka ning urang fatoruguk wang, inga' aming girii sini' nua'ni ka naga ningyara' mo' wari abo'ga'. Aming ka wa timinggi' nagok mo' kadofiguk ganang ningsa' ira abugu' wari abara'. Beng sini' adi naga ganang inga' abara' de ka adi girii tim iyak sini' wara' adi naga narafata' ning togu' Jon wari. ");
INSERT INTO uvh_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Ka beng sini' aming girii ka wa kadapmang kareng ning tuang sini' wara' adi bibiri' nipma yotangkanip tanga adining sasuk kareng a tangkunang kabi' kabi'mo' u nimita'. ");
INSERT INTO uvh_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Ka Anutuning midi tapni tang u nakitam wa Anutu wari Moses ning kafong ganang amiinga nimgu'. A napa' tangkunang kareng sini' nua'ni ka kadapmang didimeng kareng sini' a midi beng guk kareng wa Anutu wari Kasira Aming Jisas ning ning kane ganangsa' tipkadofaniminga kayam. ");
INSERT INTO uvh_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Ka aming indi Anutu kabi'guk mo' katam wara' indi adining iik a sasuk ning ki u sura nakeda ning guk mokngang sini'. Ka adining mindingni kubaniksa' ka anagok iiksi' kubaniksa' titamu' warisa' afanga nininga wa indi Anutuning iikning ki u nakedasasu'nem. ");
INSERT INTO uvh_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Ka tim Jon Baptis wari Juda aming ga' midi tokadofigu' wa ning, Juda aming girisi ka Jerusalem yong u ikiaging wari Jon ning midi ne u naknga pris a Livai arantagim ning aming girisi fam u katiana ning tanga Jon u anga kadidima waraga' yangkareinga aging. Anga kadofinga Jon u ning anigaging, gu wa nisi' Anutuning Kasira Aming wa. ");
INSERT INTO uvh_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Ka Jon adi anining wap wa isisebe guk mo' tugu', adi sareng urapsa' ituaimgu'. Ning yanggu', na Kasira Aming mo'. ");
INSERT INTO uvh_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Ka nua'bu anigaging, ka gu wa nisi', midi tokadofi aming Ilaija wa. Ka Jon wari ning yanggu', na Ilaija mo'. Ning tanga nua'bu anigaging, ka gu wa nisi', profet nua'ni ka inga' kagadofi waraga' kapmekitam uba. Ka Jon adibu ning yanggu', mokngang na aming ka u toing ningwara' mo'. ");
INSERT INTO uvh_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Ning tanga ari' nua'bu ning aniging, ka gu nasiga' abugung, wa nining sini' te'. Ning tinga indi aming girisi ka ningkara tinga abangam wa didimeng anga yangtam. ");
INSERT INTO uvh_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Ka Jon adi midi u inonga tim ka Anutuning midi nua'ni ka tim profet Aisaia wari yoku' wara'ning u yanggu'. Ning yanggu', kane ka naga abanga tirik yaraga' wa midi nua'ni ka tim profet Aisaia wari ning urang tuguinga yoking wang, aming nua'ni wari kama bining sigesa' ganang adenga ku ning katira', ai, aming sidi girii wari abubu waraga' kadapmang tipdidimangamni' ning togu' waraga' sukni', ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","25","Ka aming ka Farisi arantagim wari yangkareging wari Jon u ning aniging, ka indining, gu midi ka na Kasira Aming mo' a na Ilaija mo' abanga na midi tokadofi aming girii ka ningwara' mo' ning torang, ka gu ami taming wa ama wa nasiga' faiyamarang. ");
INSERT INTO uvh_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","27","Ka Jon wari ning yanggu', na ama udi giri iyamarik. Ka na ama warisa' iyamarik a aming nua'ni ka sidining bining ganang unggung kuma' kadofinga ita' ka sidi kigeda guk mo' ting adi naning gipmam bemota'. Ka adi naga ningyara' mo', na aming sigesa' wap guk mokngang a adi aming girii sini' ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Midi ka u toging wa Jon Baptis wari aming ama iyamgu' u tanga ka Betani yong ka Jodan ama fugung tubo do ning tara' u adenga toging. ");
INSERT INTO uvh_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Ning tanga deking. Ka kamindapking marara Jon wari Jisas wari kadofinga aramugogu' u tabang kanga aming u ning yanggu', do kani' Anutuning sipsip nano ka aming kamaganangni dabiksa' indining kadagang tanga kayonim wara'ning wa kuma' do abara' wang. ");
INSERT INTO uvh_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Ka aming ka waraga' wa na midi ka ning urang fatugutik wang, aming ka naganing mandang abo' adi nanarafik to'ga'. Aming ka wa tim naga mo' nibeging ganang timinggi' timinggi' ningsa' ira abuta', ning urang fatugutik warisa' abara'. ");
INSERT INTO uvh_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Ka aming ka ama isamarik naga undu' kaga guk mo' titik. Ka na inga' aming beng ka wari kadofiinga Isrel aming sidi ama isamarik yaraga' sura nakeda waraga' tasamarik. ");
INSERT INTO uvh_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Ning tanga midi ning ituaimgu', beng sini' urang sanarik na aming u ama iyamguk ganang ka na Anutuning mini unggo wari yang mimbep da'ning igira kunimganang kuta afanga aming ka wara'ning ki ganang meku' wa nandu' kuma'sa' kaguk. ");
INSERT INTO uvh_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Ka na kigeda guk mo' tuguk. Ka na tim Anutu wari aming ama iyam ga' nangkaranga ning togu', inga' gu naganing mana unggo wari aming nua'ni ning ki furo'ning amanga mero' u kanga nakeda te', aming ka warisa' wa aming ga' naganing mana unggo u ama da'ning iyamo'ga' ning nanggu'. ");
INSERT INTO uvh_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Ka wari didimengsa' kuma' kadofigu' wara' inga' na naning dana wari kanga nakeda tanga ning torik, ka wa Anutuning mindingni beng guk sini'. Ning togu' Jon wari. ");
INSERT INTO uvh_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Ka kamindapning ganang Jon Baptis guk ka adining kane aming fama' wara'guk dabik mareiaging. ");
INSERT INTO uvh_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Ka Jisas wari nua'bu anga kadofinga irafara agu'. U kanga Jon wari ning yanggu', aming ka do wa Anutuning sipsip nano wari mara'. ");
INSERT INTO uvh_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Ka aming fama' adi u naknga marara Jon u kabinga ning tanga Jisas ubu yaranga mugogumu'. ");
INSERT INTO uvh_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Ka Jisas wari faranga yapma ning yanggu', ai nasiga' naknga wenanga abiamu'. Ka adibu ning anigumu', o Rabai gu yak wa indeng detang. Ka wap ka Rabai wa yanggek aming tisa ning anigumu'. ");
INSERT INTO uvh_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Ka Jisas wari ning yanggu', ningwara' naura abu tademu'. Ning ininga aming fama' adi Jisas u yaranga kubap mugoging. Anga yak ka adi deku' u 4 klok kibiri ganang anga kadofinga adigok ngingeng kubap merafaging. Merafafa' ning tanga tubobu wa inga' kabinga mugogumu'. ");
INSERT INTO uvh_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Ka aming fama' ka Jon ning midi naknga Jisas u yaranga agumu' wara'ning nua'ni wa Saimon Pita ning kuyangni ka wapni Andru wara'guk agumu'. ");
INSERT INTO uvh_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Ka Andru adi inga' tubobu anga kuyangni Saimon u ning urapsa' anigu, ai Saimon gam indi kami aming girii Mesaia urang u kayamuk. Ka wap ka Mesaia wara'ning kini wa Anutuning Kasira Aming. ");
INSERT INTO uvh_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Ning tanga deia' kuyangni Saimon ubu nagira Jisas kaunga tubobu agumu'. Anga kadofiinga Jisas wari Saimon u kanga ning anigu', a Jon ning mindingni Saimon udi gu iba. Ka kami guning wap inga'ni Sifas ning ubu gotik. Ka wap ka Sifas guk ka Pita guk wara'ning kini wa kubaniksa' ka uningkim katapineng ning toyaging u anigu'. ");
INSERT INTO uvh_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Ning tanga deia' marara ka Jisas wari kama tubo Galili ga' maunga tanga aming nua'ni Filip u kanga ning anigu', gu nagok kubap antamuk. ");
INSERT INTO uvh_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Ka Filip wa Andru iguyangguk Pita ya adisining yong dabik Betsaida wara'ni. ");
INSERT INTO uvh_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Ka Jisas wari Filip u aniinga Filip adibu naknga anga amingni nua'ni Nataniel ubu anigu'. Ning anigu', ai amina, aming ka wari kagadofi wara'ning midi ka Moses wari umpang ganang yoku' a profet arantagim wari urang yoking wa kami kuma' kayam. Aming ka wa Josep ning mindingni Jisas, Nasaret yongni. ");
INSERT INTO uvh_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Ka Nataniel adibu ning anigu', ai indining, napa' kareng ka ni Nasaret yong do wara'guk kagadofi ning ba, Ka Filip wari ning anigu', ningwara' mamarak tanga sa'abanga kaya'. Ning aniinga yaranga anga Jisas ganang u kadofigumu'. ");
INSERT INTO uvh_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Ka Jisas adi Nataniel wari arabugu' u tonga kanga ning togu', u kani' aming ka u abara' wa kadapmangni didimengsa', mandaga' kabi'guk mokngang. Aming ka ningyara' wa Isrel aming aming sini'. ");
INSERT INTO uvh_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Ka Nataniel adi Jisas ning midi u naknga ning anigu', ai gu urapsa' wa indining tanga napkedanga torang. Ka Jisas wari ning anigu', mo' na Filip wari ko mo' anga ganinga mambang ki ganang merafarang u tanga timinggi' kuma' tonga gapmak. ");
INSERT INTO uvh_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Ka Nataniel wari ning anigu', o tisa gu Anutuning mindingni, gu Isrel ning aming girii beng sini'. ");
INSERT INTO uvh_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Ka Jisas wari u naknga ning anigu', a Nataniel gu naga Filip wari ko mo' ganinga firi ki ganang do kuma' tonga gapmak ning torik waraga'sa' ka gu napa' girii ning kanga nagata' naktangka ba taring. Ka beng sini' ning ganotik, inga' napa' fam ka kigineng sini' napa' ka kami i karanga i tatarafik sini' tinga yabe'ga'. ");
INSERT INTO uvh_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Ning aninga ning tanga nua'bu wa dabik ubu yanggu', beng guk sini' urang sanarik inga' kunim wari tubo kidagang tanga sangang sa' adeinga Anutuning kunung aming ensel kabi'mo' wari Amingning Tim Iyak nagaganang afangara afangara tini' u kuma'sa' kani'ga', ning yangu'. ");
INSERT INTO uvh_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Ka kama fama' wari binga aming nua'ni ka Kena yong kama tubo Galili tara' wara'ning wari taming kafauwe tanga tangsana tugu'. Ka Jisas ning mengni Maria adindu' adisigok ungung kuma' anga marafagu'. ");
INSERT INTO uvh_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Ka tangsana u nana waraga' wa Jisas guk ka arantagimni guk u katianinga aging. ");
INSERT INTO uvh_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Ka wain ama ka tangsana u tanga fiamging udi kuma' biwanga tugu'. Ka Jisas ning mengni wari u kanga Jisas u midi kapmo' ka ning anigu', ai wain ama kuma' biamara' u yabe'. ");
INSERT INTO uvh_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Ka Jisas wari ning anigu', simeng gu mo' naninga totik. Naga kane titining kama wa ko adera'. ");
INSERT INTO uvh_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Ka mengni wari Jisas ning midi u naknga anga aming ka nana iyam kane tiging u midi sasagap ning yanggu', kuma' anirik, adi nasi' kane ni ka titiga' udep saninga wa sidi nakngam sa' tanga tinting. ");
INSERT INTO uvh_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Ka kama kabak fam ka 6 ning ka Juda aming ana anasining kadapmang yaranga kasi' kafasi' yotikiaging waraga' ama ka' tagara kukiaging wara'ning udi ama dibing beng guk unggung marafaging. Ka kabak kubanik kubanik wara'sining banaksi' gipmam wa girisi sini' ka 100 a 120 lita ning. ");
INSERT INTO uvh_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Ka Jisas wari aming ka nana sabara kane tiging u ning yanggu', sidi ama ka' anga gira abanga kabak ganang tagak yarani'. Ning ininga gira fabanga kabak ganang u tagara yareging. ");
INSERT INTO uvh_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Ning tanga Jisas wari ning yanggu', we' kabi'ning gira bema tanga aming ka tangsana katatorara' do waraga' amini'. Ning ininga gira bema tonga aming waraga' amiging. ");
INSERT INTO uvh_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Ka aming ka tangsana u katatoregu' wari kabi'ning gira topnagagu' udi marang siamo'. Ka adi wain kareng ka wa indeng bemging wara'ning guk mo' nakedagu', aming ka mamanggak tanga aging adi giri nakedaging. Ka adi marang siamo' u topnanga naknga aming ka kafauwe tugu' u sasa' kabi'ning nagira anga ");
INSERT INTO uvh_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","ning anigu', ai, gu kadapmang kareng sini' tarang. Aming fam adi ning guk mo' titing. Adi nataraga titi waraga' tanga wain ama kareng wa tim gama anganga kiptang kabi'guk wa inga' gamting ning titing. A gu ning mo' tarang. Tim munumung wa kareng gi' nima ning tanga kareng sini' wa kapmo' sepmang. Ka inga' niminga nem yang ning togu'. ");
INSERT INTO uvh_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Ka Jisas wari ama marang guk ka Kena yong Galili tara' ganang u tipigiku' wa Jisas wari adining tangkunang wari kane tangkunang mirakel munumung sini' tugu'. Ning tinga aming adi Jisas wari adining tangkunang yangtintingnegu' u kaging. Ka adining arantagimni adi u kanga a dita' naktangka tiging. ");
INSERT INTO uvh_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Ning tanga Jisas guk ka mengni Maria a kuyane fam abanga adining arantagimni wara'guk dabik adi Kena yong u kabinga Kapaneam yongga' mugoging. Anga Kapaneam u kadofinga unggung kabi'ning yaging. ");
INSERT INTO uvh_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Ka Juda ning sande girii nua'ni wapni Pasova u kayaging wari kagadofi waraga' dudure kuma' tugu'. Ka Jisas adi sande girii u kaga waraga' sura Jerusalem yongga' aregu'. ");
INSERT INTO uvh_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Ka adi Jerusalem yong u kadofinga siring yak girii tempel wara'ning sinim iung bane u amanga yapku' ka aming kabi'mo' wari yak wara'ganang bisnis kane tanga magaa kau a sipsip a yang ning u manggara fabanga iminga aming wari fatonaging. Ning tinga aming fam ka kane ka moni sini' iminga kura'bu wa siring yak ning moni tipfaranga iyam wara'ning tiaging adindu' kanesi' ka u anga mera fatiging. ");
INSERT INTO uvh_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Ka Jisas adi u yapma barap naku'. Ning tanga aming yangkagare tonga aya dibing bema titiri tanga anga sipsip a kau u fefiapma yubusara tinga fugang kadofinga bima tanga mugoging. Ning tanga anga aming ka moni kura' aming kane mera fatiguing wara'sining basing ubu manggara kwasinaiminga monisi' wari kamaganang do mangfayangaging. ");
INSERT INTO uvh_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Ning tanga aming ka yang tona ga' fong kura mafaging undu' yangkagare tanga ning yanggu', uri mambongsi' u manggaknanga fonga mugo tini'. Sidi maket kane wa yak ka yara'ganang nua' mo' abanga tinting, ya naming sibeng ning yak. ");
INSERT INTO uvh_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Ka Jisas ning arantagimni adi Jisas wari temple ga' sura wara'ning midi umpang timinggi' yoking waraga' sura nakedaging. Midi ka u yoking wa ning, na guning yak wari didimeng kareng ningsa' iik waraga'sa' nakarik, ning yoking. ");
INSERT INTO uvh_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Ka Juda aming adi Jisas wari aming yangkagaregu' u kanga kabaksi' kadagang nakngama ning aniging, ai gu kadapmang ka ning guk wa nasi'ga' abanga tarang. Nisi' wari kane u titiga' gipmugu'. Ka indining dani'ganang kane tangkunang ni wa sa' tinga kanam. ");
INSERT INTO uvh_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Ka Jisas wari midi nua'ni ning yanggu', sidi siring yak girii temple i kwetatarani'. Ning tinga naga kama faminengsa' tubobu kuma' tipmararotik. ");
INSERT INTO uvh_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Ka adibu ning toging, ai siring yak girii ya kane girii tanga kama paramu' sini' ka gurak foti siks ning ibinga inga' sini' tipkarendaging. ");
INSERT INTO uvh_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Ka Jisas adi midi ka u togu' wa adi siring yak tempel ga' mo' togu'. Mokngang adi inga' ana kungkumak tinga Anutu wari tubobu tipmarak waraga' sura midi tipfara tanga togu'. ");
INSERT INTO uvh_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Ka Jisas adi midi ka ning u kuma' togu' wara' adi inga' kungkumak tanga tubobu maragu' ganang wa arantagimni adi midi ka timinggi' u yoking wara'guk ka midi ka ananing mini wari inga' togu' waraga' sura Jisas anata'sa' suktangkaging. ");
INSERT INTO uvh_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Ka Jisas adi Jerusalem yong ganang unggung ko ningsa' ira sande girii Pasova wari kadofanga kaging. Ning tanga adi kane tangkunasi mirakel fam tugu'. Ka ami taming kabi'mo' wari u kanga ning toging, o adi aming girii beng sini' ba ning tonga adiganang abiging. ");
INSERT INTO uvh_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","25","Ka Jisas adi aming ning kabaksi' mang yapkeda tuang wara' adi aming wari o beng sini' ning wa masi' wari usingsa' toging u kuma' yapkedanga aming arantagim ka wa adining kapmik ganang beng sini' iik ning, ning mo' yapku' mokngang. ");
INSERT INTO uvh_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","2","Ka Juda ning aming girii nua'ni wapni Nikodimas ka adi arantagim ka Farisi wara'ni wari Jisas kaunga tiim ganang agu'. Anga kadofinga Jisas u midi kugurang ning anigu', o tisa indi kuma' gapkedem gu udi Anutu ana aming yanggek ga' gangkaregu' wara' gu nasi' nasi' tarang udi beng guksa' kadofira' kayam. A aming sigesa' wa ning titining guk mokngang. ");
INSERT INTO uvh_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Ka Jisas wari ning anigu', beng guk sini' ning ganotik, aming wari Anutuning bining ganang kadofinga iik wara'ning wa ning, adi inga'ni sini' ka taming wari saba ginggiming inga' iibe ning ningda'ning nua'bu mo' irota' wa adi Anutuning bining ganang kadofinga iikning guk mokngang. ");
INSERT INTO uvh_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Ka Nikodimas adibu ning togu', ai indining. Aming ka kuruga kuma' titi udi saba ginggiming nua'bu guk u ikinga ibeyabiting. Ma, mengni ning kaba ganang nua'bu amanga dekinga iibe ga' ba torang. Mokngang unda'. ");
INSERT INTO uvh_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Ka Jisas wari nua'bu anigu', beng sini' ganarik aming ka mengni warisa' ibeinga irota' wa Anutuning bining ganang iikning guk mokngang. A aming ka mengni wari ibeinga inga' Anutuning mini unggo wari undu' inga'ni ning tipigirota' warisa' wa giri Anutuning bining ganang iik ning. ");
INSERT INTO uvh_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Ka wara'ning kini wa ning, aming kamaganangni wari tinga aming wari inga'ni iigik ning guk mokngang. Aming adi aming fugu sa' ibeting. A uringni wa napa' girii sini' wara' Anutuning mini unggo warisa' inga'ni ning tipkadofita'. ");
INSERT INTO uvh_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Ka gu midi ka naga inga'ni sini' ka taming wari saba ginggiming iibe ning ninda'ning nua'bu iigik ga' ganak u naknga base tanga waraga' sasuk mimeng sini' mo' totang. Mokngang wa kadapmangni ganang didimengsa' kuma' yaranga tota'. ");
INSERT INTO uvh_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Ka gu kadapmang ka gugubik wari abuta' waraga' sure'. Gugubik wara'ning gigi wa giri nakitang de ka gugubik wara'ning beng wa indining da'ning abanga mugota' wara'guk mo' katang, mokngang wa ananing sasuk ganangsa' kadofinga mugota'. Ka aming ning kaba ka Anutuning mini unggo wari inga'ni tipigirota' undu' ningsa', kini sareng guk mo' kautang. ");
INSERT INTO uvh_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Ka Nikodimas adibu ning anigu', ka napa' u torang wa indining da'ning tanga kadofota'. ");
INSERT INTO uvh_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Ka Jisas wari ning anigu', ai gu Isrel ning tisa girii ka gu nakeda guk mo' wa indining tarang. ");
INSERT INTO uvh_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Beng sini' ganarik na napa' ka wa sige mo' fatorik mokngang. Na naganing dana wari kaga sini' tanga nakedanga fatorik ka Juda aming sidi ninak guk mo' fating. ");
INSERT INTO uvh_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Na midi ka wa napa' ka aming kamaganangni ganang kagadofi ning waraga' torik unggung ka sidi nafek ba ting. A naga napa' ka kunimganang kuta unggungsa' kagadofi ning waraga' torok wa nakeda titining guk mokngang. ");
INSERT INTO uvh_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Aming ka ni kunimganang guk mo' aregu' wara' wari todidimainga nakonga, mokngang. Kunim ganang kuta ning tara' wa Amingning Tim Iyak napmo' kubaniksa' afuguk wara' napa' kunimganang ning midi wa nagasa' toutik. ");
INSERT INTO uvh_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Ka tim Moses wari kama bining sige ganang Isrel aming wari kadaga guk mo' titi waraga' ain kopa wari gimik uuring tanga kuyang furo'ning tapma iragu', ningsa' inga' aming wari Amingning Tim Iyak naga bema firi furo'ning tapnapni'ga'. ");
INSERT INTO uvh_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Ning tinga aming ka nagata' naktangka tini' adi kadaga guk mo' tanga fikifiki ka' ningsa' ira ani'. ");
INSERT INTO uvh_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Ka beng sini' Anutu adi aming kamaganangni dabiksa' wari kadaga titiga' mo' naku'. Mokngang adi aming wari kareng gi' giri iik waraga' siamo' naknga yotangkayap titi waraga' ananing mindingni kubaniksa' unggung kabiamgu'. Ning tinga aming ka adita' naktangka tinting wa kadaga guk mo' tini', mokngang adi kareng gi' giri ira fikifiki ka' ningsa' ikni'. ");
INSERT INTO uvh_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Ka Anutu wari mindingni u anigaregu' wa adi aming u adisining kadagang waraga' midi ganang kukyapma yangbenga ifikadaga titi waraga' mo' anikaregu'. Mokngang sini' adi aming ka kadagang ganang iik u manggara kafakafa tanga kukyabinga kareng gi' ubu iik waraga'sa' sura anikareinga afugu'. ");
INSERT INTO uvh_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Wara' aming ka adita' naktangka tinting adi Anutu ganang midi ni guk mokngang. A aming ka adita' naktangka guk mo' tinting wa Anutu ganang midi guk wari iking. Beng sini' adi Anutuning mindingni kubaniksa' waraga' naktangka guk mo' ting wara' adi midi guk. ");
INSERT INTO uvh_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Ka adi midiganang adenga mamareng bimbem wara'ning ki wa ning, Anutu ananing mindingni wari afanga kama i tipsangandainga aming dabiksa' adi adining diok sangang ganang kuma' kadofisarendasasu'ning. Ka aming adi kadapmangsi' wa kadagangsa', wara' adi sangang wara'ganang iikga' bibi' naking. Ning tanga adi kangkam ganang iikga'sa' naking. ");
INSERT INTO uvh_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Beng sini' aming ka kadagang titiga'sa' naknga titing adi adisining kadagang wari sareng kagadofi ga' bibi' nakiting. Wara' adi diok sangang ga' bibi' naknga kangkam ganang unggung ningsa' ko ikiting. ");
INSERT INTO uvh_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","A aming ka kadapmang kareng beng guk u yaranga didimeng titing adi diok u kanga abanga wara'ganang iikga' nakiting. Ning tinga aming fam wari u yapma o adi Anutuning midi u naknga didimeng beng sini' ting ning tuguting. ");
INSERT INTO uvh_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Ning tanga iya' Jisas guk ka arantagimni guk kama tubo Judia tara' waraga' mugoging. Anga kadofinga ning tanga ami taming u ama iyamging. ");
INSERT INTO uvh_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Ka kama ka wara'ganang wa Jon Baptis adindu' Inon yong kabasi' ka Selim yong tara' wa ama guk wara' u anga yagu'. Ikinga ami taming wari adiganang auinga ama faiyamarugu'. ");
INSERT INTO uvh_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Ka Jon wari u yagu' wa girii Herot wari kalabus iyung ko mo' bema dasigu' u tanga ganang yagu'. ");
INSERT INTO uvh_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Ka Jon ning arantagimni guk ka Juda aming girii nua'ni guk adi Juda anasining kadapmang ka fuksi' a gafa napa' wara'guk dabik yotikinga aming karesi iyak wara'ning waraga' tonga naking. ");
INSERT INTO uvh_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Ning tanga Jon ning arantagim wari Jon u ning anga aniging, ai tisa, aming nua'ni ka tim gugok Jodan ama tara' do yagumu' ka adining midi kuma' urang ninggung wang udi ami taming kabi'mo' wari adiganang bak girii ubu tinga ama faiyamara' kayam ning aniging. ");
INSERT INTO uvh_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Ka Jon wari ning yanggu', undu' girisa', wa kadagang mo' tara'. Aming ka kane kareng ni ka u tara' ningwara' tinga wa ning nakedanting, Anutu ana tangkunang kuma' amira' wara'ganang didimengsa' tara'. ");
INSERT INTO uvh_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Ka sidi midi ka naga tim sangguk undu' kuma'sa' nakeding. Na sareng ning kuma' sangguk, na Kasira Aming mo'. Mokngang na Anutu wari Kasira Aming wari abubu wara'ning kadapmang u tipdidimangam waraga'sa' nangkaregu'. ");
INSERT INTO uvh_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Ka kadapmang ka aming ka wara'guk indi kane tiamuk wara'ning wa ning. Aming ka ni taming sanonga tota', ka kuyang kabasi' adi aming fam guk mesisiringa tanga fakanting. Ka adi midi ka kuyang tangandang wari kafauwe titiga' kuma' abota' wara'ning u naknga wa kuyang kabasi' adindu' kaba karengsa' naknga marara yotangkangam tanga dabik adentamu' ning titing. Ka nandu' kami yara'ganang wa kadapmang ka u titing ningda'ning tanga adita' kabakna karengsa' naknga mesisiringa girii sini' tirik. ");
INSERT INTO uvh_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Ning tinga adining wap wari giraga tinga naganing wap wa kabisira ubu tota'. ");
INSERT INTO uvh_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Ka beng sini' aming ka kunim kuta wara'ning wa girii sini'. A aming ka kama ganangni indi kama ganang inggingni sa' wara' indi midi wa kama ganangni napa' waraga'sa' tugutam. A aming ka kunim ganangni adi aming aming ning tim iyak girii sini'. ");
INSERT INTO uvh_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Adi kunim ganangni napa' girisi u yapma nakeda tanga ning kuma' tanga tora' ka aming adi adining midi waraga' bibi' nakngaming. ");
INSERT INTO uvh_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","A aming ka adining midi u naknga beng ning tonting wa adi o Anutuning midi wa didimeng beng guksa' ning tutugu ning ningda'ning tinting. ");
INSERT INTO uvh_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Ka beng sini' aming girii ka Anutu wari anikareinga afugu' wa Anutu wari adining mini unggo dabiksa' kuma' dasito'nangamgu' wara' adi Anutuning midi kareng didimengsa' ituata'. ");
INSERT INTO uvh_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Ka beni Anutu adi mindingni ka waraga' siamo' nakita' wara' adi napa'napa' dabik wa adisa' yaptatora waraga' kamigu'. ");
INSERT INTO uvh_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Ka aming ka Anutuning mindingni ga' naktangka tota' wa adi ka' iik kareng ka fikifiki ningsa' iik wara'guk irota'. A aming ka adining mindingni ning midi wara'guk mo' yarota' wa adi ka' kareng bema iik ning guk mokngang. Adi Anutu wari kagaya amimi wara'ningsa' irota'. ");
INSERT INTO uvh_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Ka Farisi arantagim wari midi nua'ni ka aming fam wari ning toging u naking, ami taming kabi'mo' ka Jisas wari ama iyaminga adining arantagim iik waraga' famaying wa aming arantagim girii ka tim Jon Baptis ganang famayaging u tarafita'. ");
INSERT INTO uvh_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Ka ama wa Jisas ana sini' mo' iyamgu', mokngang wa arantagimni warisa' iyamging wara'ning midi u naknga toging. ");
INSERT INTO uvh_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Ka Jisas adi Farisi wari midi ka adi kane tiging wara'ning udi kuma' naking u naknga marara arantagimni u inagiknanga kama tubo Judia tara' u kabinga kama tubo Galili tara' waraga' tubobu mugoging. ");
INSERT INTO uvh_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Ka kadapmang ka Judia u kabinga Galili tara' ga' mugo wara'ning wa kama bining Sameria tara' u mayaging ka adi u yaranga mugoging. ");
INSERT INTO uvh_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Anganga kama tubo Sameria wara'ning yong nua'ni ka Saika u kadofiging. Ka yong ka wa kama dibing ka tim Jekop wari mindingni Josep ga' kabingamgu' wara'ning du' u anga kadofiging. ");
INSERT INTO uvh_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Ka yong bibik ganang wa ama kwang ka timinggi' Jekop wari unegu' wara'ganang anga kadofigu'. Ka mayam de sidii sini' ganang kadofinga kama paramu' aging wara' Jisas adi mengkura tanga ama kwang gaga ganang unggung anapmo' mareiagu'. ");
INSERT INTO uvh_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Ka arantagimni adi nanasi' kuma' biamgu' waraga' tanga adi nana tononga yongga' tim kabinga mugoging wara' Jisas anapmo'sa' mareiagu'. Ka Sameria yong ki wara'ning taming nua'ni wari ama kwang u giknonga mabugu'. Abanga kadofiinga Jisas wari taming u ning anigu', ai taming gu ama kabi' giknaminga topnok. ");
INSERT INTO uvh_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Ka taming adibu ning anigu', ai gu udi kuma' gabarik Juda aming a na Sameria taming, ka gu ama gikam ga' guk wa indining nanarang. Ka taming wari midi u togu' wara'ning ki wa ning, Sameria aming wa Juda mo' arantagim nua'ni wara' Juda aming adi Sameria aming guk bak kabi'sini' titiga' tapni tang sini' tiaging waraga' tanga wa adi midi ka u togu' wang. ");
INSERT INTO uvh_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Ka Jisas wari ning anigu', beng sini' na ama giknam ga' ganarik ka gu naganing tangkunang kareng ka aming yotangkayap ning wara'guk itik wa napkeda guk mo' tarang. Abanga gu Anutuning kigineng ka Anutu wari aming ga' ai' dap tiamita' wara'ning kadapmang undu' kaga guk mo' tarang, mokngang. A gu tim guk kuma' naknga napkeda ganang wa ama ganggam ga' tim wa gu urapsa' kuma' nanonga tangang. Ning tinga na ama nua'ni ka ka' ningsa' iik wara'ning u gamonga tangak. ");
INSERT INTO uvh_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Ka taming adibu ning anigu', a tisa gu ama nanam ga' torang ka gu ama wa indeng girang, ama kwang ya paramu' sini' ka gu nasi' wari tanga gironga tangang. Abanga ama ka ka' iikning u torang wa indeng bemang, mokngang unda'. ");
INSERT INTO uvh_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Ama kwang ya timinggi' sini' papani' Jekop wari unegu'. Ka Jekop ana nanga anganga inga' adining arantagimni a magasi' mambong dabiksa' wa ama kwang ka kubanik inggingsa' nanga ikiaging. Ka inga' irisi' indibu kadofinga undu' kubanik inggingsa' bema nanga ira abutam. Ka indining, gu ama kuni' nua'ni tipkadofi ning tang guk wa. A gu papani' Jekop ba tarafaronga torang. ");
INSERT INTO uvh_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Ka Jisas wari ning anigu', beng guk sini' ganarik taming, aming ka ama kwang inggingsa' topnota' wa adi inga' ama ga' mini nua'bu guk pamparangauta'. ");
INSERT INTO uvh_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","A aming ka ama ka naga amotik u topnota' wa adi inga' ama ga' mini nua'bu guk mo' pamparangauta'. Mokngang adi ama ka wari amanga kaba ganang do ira ama de da'ning fikifiki ningsa' fakadofota'. Ning tanga aming u yotangkangaminga adi fikifiki ka' ningsa' ira auta'. ");
INSERT INTO uvh_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Ka taming wari ning anigu', a tisa ningwara' ama kareng ka u torang wa nanam tinga topna tok. Ning tanga na ama ga' mana guk mo' pamparanganga ama kwang yara'ganang ama gikna ga' wa kane girii nua'bu mo' abanga tarotik ning togu'. ");
INSERT INTO uvh_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Ka Jisas wari ning anigu', gu ufaga ubu anga nagira abademu'. ");
INSERT INTO uvh_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Ka taming adibu ning togu', a na ufana guk mokngang. Ka Jisas wari ning anigu', a beng guk torang ufaga guk mokngang. ");
INSERT INTO uvh_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Ka na kuma' gapkedarik gu tim ami siama abutang wa siamo' ka faiv ning sini' siamgung. Ka ami ka inga' yara'ganang ikiamu' undu' guning ufaga sini' mo', aming nua'ni guk ikiamu' wara' gu midi ka ufaga guk mokngang ning torang wa beng guksa' torang ning anigu'. ");
INSERT INTO uvh_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Ka taming wari ning anigu', o beng sini' tisa gu ning gabarik ka gu Anutuning sasuk aming nua'ni. ");
INSERT INTO uvh_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Ka indining, tim Sameria indining papane adi Anutu ga' ibang tounga wa adi kama bubo girii kubanik yara'ganangsa' aranga toyaging. Ka Juda aming sidi ning fatuguting, Anutu ga' ibang tutugu wara'ning kadapmang didimeng wa Jerusalem yong girii ganangsa' anga toutang ning tuguting. Ka wa indining nangdidima tinga nakok. ");
INSERT INTO uvh_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Ka Jisas wari ning anigu', o beng sini' taming ning ganotik, gu ibang tutugu ning kadapmang ka timini wara'ningsa' sura torang. Ka kadapmang inga'ni nua'ni kabi'sini' kadofota'. Kama ka wara'ganang wa aming wari Anutuga' ibang tounga wa adi kama bubo nua'ni ganang aranga tugu wa ma Jerusalem yong ganangsa' anga tugu ning nua'bu mo' tinting. Mokngang adi sibeng ga' ibang tounga wa kama nua'ni ganang indeng adenga undu' girisa' tonting. ");
INSERT INTO uvh_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Ka Sameria aming sidi ibang udi giri tuguting ka sidi Anutuning ki kafakafa sini' mo' nakedanga tuguting. A Juda aming indi Anutu wari aming manggara gi' kukyap wara'ning tim iyak ning ikitam wara' indi ibang wa Anutu beng guk waraga'sa' nakedanga tugutam. ");
INSERT INTO uvh_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Ka kadapmang inga'ni kabi'sini' kadofota' ning urang tongak wara'ning kama wa kami kuma' kadofara' yang. Wara' aming arantagim ka sibeng Anutuga' naktangka sini' titing adi ibang tounga wa mini unggo guk ka kadapmang beng guk wara'ganang sini' suktangkanga tonting. Sibeng Anutu adi aming wari ibang ning kadapmang ka beng guk ningwara' unggungsa' titiga' siamo' nakita'. ");
INSERT INTO uvh_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Ka beng sini' Anutu wa mini unggo sa' wara' aming wari adita' ibang tongamonga wa mini unggo guk ka kadapmang didimeng beng guk sini' wara'ganangsa' kaba guk kufara touta'. ");
INSERT INTO uvh_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Ka taming wari ning togu', o kuma' nakedarik, inga' girii Mesaia ka wap nua'ni Kasira Aming ning aniting wari abo'ga'. Ka aming ka wari abo'ganang wa adi napa'napa' waraga' ningsasu'nanga yaro'ga' ning tuguting wara'ning wa giri nakedarik. ");
INSERT INTO uvh_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Ka Jisas wari ning anigu', beng sini' aming ka u torang wa gagok kami kubap adenga midi kuma' toyamuk nagasa' yang ning anigu'. ");
INSERT INTO uvh_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Ka Jisas wari taming guk midi u fatogumu' ganang ka adining arantagimni ka yong ganangga' aging wari tubobu abiging. Abanga kadofinga Jisas wari taming nua'ni guk midi fatogumu' u kanga Juda aming anasining kadapmang tapni ka Sameria aming guk midi kabi'sini' guk mo' tutugu wara'ning waraga' sura yuguk aranga sasuk mimeng tiging. Ka adi midi wa nasi'ga' fatoyamu' wa ma indining tanga anirang ning guk mo' anigaging, mokngang adi mutu tiging. ");
INSERT INTO uvh_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Ning tinga taming adi Jisas ning midi kuni' sini' u naknga kaba karengsa' naknga marara ama kandang wa sige ningsa' kabinga yong girii ga' tubobu unara anga aming u ning yanggu', ");
INSERT INTO uvh_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","ai, aming nua'ni kanga abarik do anga kanam. Adi naga nasi'nasi' tanga abutik wa kuma'sa' napkedanga nana yarara'. Sa' abanga kani', Kasira Aming urang fatuguting ubanda'. ");
INSERT INTO uvh_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Ning ininga aming wari u naknga Jisas u kaunga marara abiging. ");
INSERT INTO uvh_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Ka aming wari ko mo' anga kadofiging ganang ka adining arantagimni wa Jisas u ning aniging, tisa gam nana kabi'ning naya'. ");
INSERT INTO uvh_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Ka adibu ning yanggu', na nanana guk. Ka naganing nana wa sidi kaga ning guk mokngang. ");
INSERT INTO uvh_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Ka arantagimni adi u naknga anasa' ning toging, ai nasi' nana ga' tora', aming fam wari kuma' unda' tabanga amiinga nanga'. ");
INSERT INTO uvh_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Ka Jisas wari ning yanggu', na nana sini' ka fukni' yotangka ning waraga' mo' torik, mokngang. Naganing nana wa ning, sibeng Anutu wari adining kane titiga' nangkaregu' wara' nasi' midi a kane adi namara' wa nakngam sa' tanga urapsa' tipmiri waraga' sura kanesa' totik. Ning tinga wari nifitangkainga damdang sa' nakotik. ");
INSERT INTO uvh_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Ka naga kanesa' titi ga' torik wara'ning waraga' wa ning sanotik, aming wari adisining fesing u yapkedanga ning tuguting, mayap fama'gong ibinga wa beng wari kuraga tinga dopma manggak tanam ga'. Ka sidi aming do arabing u fonga yapni', na aming wa nana feng ganang wari kuma' kuraga ning ningda'ning yabarik. Ka naga aming u manggakyap wara'ning kama wa kuma' kadofira' yang' ");
INSERT INTO uvh_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Ka sidi aming u Anutuning bining ganang iikga' manggara bak kukyapmanting wa kane aming wari nana kuru' feng ganang u manggaksasu'nanga tipmiringa kane aming guk ka feng tuang guk kabaksi' karengsa' naknga mesisiringa sa' urang titing ningda'ning ka sidi inga' kane ka nana fikifiki ningsa' iikning u manggakanting wara'ning toni kareng sini' u bema kabaksi' karengsa' naknga mesisiringa sa' tanga ikni'ga'. ");
INSERT INTO uvh_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Ka midi nua'ni ka nana kuru' feng ganang mamanggak ning waraga' ka ning tuguting undu' beng guksa', kane aming arantagim nua'ni ka iipmi sa' tinting a nua'ni ka beng dopma manggara kuk wara'ning kane sa' tinting. ");
INSERT INTO uvh_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Ka beng sini' naga sidi kane ga' sangkararik wa sidi anga feng ka aming nua'ni wari kuma' tanga iropking u anga tanga beng unggungsa' manggakanting ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","40","Ka Sameria yong ki wara'ning aming arantagim girii abiging udi Jisas se' ganang kuma' abanga kadofiging. Adi taming wari midi ka Jisas wari nasi' nasi' adi tanga itarugu' u kuma' kigedanga anigu' waraga' anga ininga naknga naktangka kuma' tanga Jisas u kaunga abiging. Abanga kadofinga Jisas u kanga adisigok dek ga' anisefi tiging. Ning tinga Jisas adi adisigok unggung tiim fama' deku'. ");
INSERT INTO uvh_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Dera ning tanga midi kareng ininga yong wara'ni aming kabi'mo' wari adining midi u naknga adita' naktangka tiging. ");
INSERT INTO uvh_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Ning tanga aming wari taming ka Jisas u kanga anga yanggu' u ning aniging, o beng sini' tim wa gusa' abanga nininga naktangkangam. Ka inga' nana sini' ubu kanga naktangka sini' tanga ning toyam, aming ka ya Anutu girii wari aming kamaganangni dabiksa' u manggara gi' kuknip waraga' urang anigaregu' wa kuma' abara' yang ning toging. ");
INSERT INTO uvh_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Ning tanga deia' Jisas se' adi Sameria tibi ning yong Saika ka u kabinga kama tubo Galili tara' waraga' mugo tiging. ");
INSERT INTO uvh_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Ka Jisas adi ananing yong ki Galili aming wari bibi' nakngam wara'ning u tim kuma' nakedanga ning togu', midi tokadofi aming profet wa anasining yong ki adi bibi' nakyamiting. Ka Jisas adi kadapmang ka aming wari bibi' nakngam ning u kuma' nakedagu' de ka adi bibi' mo' naku', mokngang adi au sa' tugu'. ");
INSERT INTO uvh_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Ning tanga anganga kama tubo Galili u kadofigu'. Ka Galili aming adi tim Juda ning sande girii Pasova u kaunga Jerusalem ga' areging u tanga ka Jisas wari kane tangkunasi fam tugu' udi kuma' kaging. Wara' adi Jisas wari anga kadofigu' u kanga wa kabaksi' karengsa' naking. ");
INSERT INTO uvh_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","47","Ka Jisas adi kama tubo Galili wara'ning yong nua'ni Kena ka tim ana ama kaa' tipfareinga wain urang igiku' u nua'bu anga kadofigu'. Ka kama tubo Galili tara' wara'ning king ning kane aming ofisa girii nua'ni ka Kapaneam yong u itarugu' wara'ning mindingni udi bagana agik mamareng sini' tanga defagu'. Ka saba kabasi' wara'ning beni adi Jisas wari kama tubo Judia kabinga Galili u kuma' anga kadofigu' wara'ning midi u naknga Jisas u kaunga Kena yongga' urapsa' abugu'. Abanga kadofinga Jisas u tangkunang sini' ning anigu', o girii naning sabana udi bagana agik mamareng sini' kabi'sini' kumarota'. Ka gu naganing yongganang do unggung anga tipkarendanam te'. ");
INSERT INTO uvh_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Ka Jisas wari ning togu', a na aming sidining kadapmang wa kuma' fasabarik, sidi nagata' naktangka wa naganing midi naknga wara'ganangsa' mo' fanaktangkaing. Mokngang sidi naga napa' tangkunang ni tasaminga kanga wara'ganangsa' wa giri fanaktangkaing wara' sidi napa' tangkunang titiga' kuma' abanga naning iba. ");
INSERT INTO uvh_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Ka aming girii adi tangkunang sini' nua'bu anigu', o girii, sabana kumaknam ma to' nagok urapsa' anga yotangkanam te'. ");
INSERT INTO uvh_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Ka Jisas wari ning anigu', o sabaga mo' kumakamota', ka' giri irota'. Yakangga' tubobu girisa' mautang. Ning aniinga aming girii adi Jisas ning midi u naknga naktangka sa' tanga kagabi tanga mugo tugu'. ");
INSERT INTO uvh_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Anganga kadapmang bining ko aramugogu' ka adining kane aming fam wari kadak abanga katuanga ning aniging, sabaga udi giri mo' kumarota'. Kuma' karendanga karang marara merafata'. ");
INSERT INTO uvh_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Ka aming girii adi u naknga wara'ning kiga' nakdidimonga ning yanggu', ka kama wa nasi' ganang karendagu'. Ka adibu ning aniging, mo' wa kap wan klok sidii ganangsa' ka fugu kagaya wari kabiinga karenda tugu'. ");
INSERT INTO uvh_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Ka beni adi kama didimeng ka adi u toging indik sini' ganang ka Jisas wari mindingni wari karendangam titiga' anigu' waraga' sura nakedanga o bengsa' ba nanggu' ning tonga Jisas ga' naktangka tugu'. Ning tinga ana kurene dabiksa' a kaneni aming fam undu' naktangka tiging. ");
INSERT INTO uvh_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Ka Jisas adi kama tubo Judia tara' u kabinga anga kama tubo Galili u kadofinga kane tangkunang ka u nua'bu tinga wa kama tubo Galili wara'ganang adining kane tangkunang mirakel wari fama' ning ubu kadofigu'. ");
INSERT INTO uvh_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Ka Jisas adi kama tubo Galili unggung yagu'. Ka inga' Juda anasining sande girii nua'ni wari kadofonga tugu'. Ka Jisas adi sande u kaunga Jerusalem yong girii ga' nua'bu aregu'. ");
INSERT INTO uvh_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Ka Jerusalem yong wara'ning sinim girii ning iming nua'ni ka wap sipsip ning aniaging wara'ganang ka iyung bane tara' wa ama iyi ning gwang kabasi' kareng nua'ni tiging. Ka Hibru anasining midiganang wa gwang wara'ning wapni ka Betesda ning aniaging wari aderugu'. Ka gwang wara'ning gaga ganang wa ayong marek waraga' yak kababi' faiv ning guk maging. ");
INSERT INTO uvh_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Ka yak kababi' wara'ganang wa bagana aming kuni' kuni' kabi'mo' ka dasi' kadagasi a kasi' kadagasi a kasi' kafasi' kungkumosi ning wari anga merafakiaging. ");
INSERT INTO uvh_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","(Ka bagana aming adi ning sura anga kapmekfakiaging, fiking ni ganang ka Anutuning kunung aming ensel nua'ni wari afanga gwang u tantumurum tinga bagana aming ka tim munumung sini' amota' wa baganani tangkunang wari urapsa' bingaminga karenda tota' ning sura anga kapmefakiaging.) ");
INSERT INTO uvh_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Ka bagana aming wara'sining nua'ni wa kayong kadagang. Ka adi kayong kadagang wara'guk kama paramu' sini' ka gurak 38 ning sini' kuma' ira kabigu' adindu' anga merafagu'. ");
INSERT INTO uvh_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Ka Jisas wari Jerusalem yong u aranga kadofinga aming ka u kanga bagana guk kama paramu' sini' yagu' u kuma' kigedanga ning anigu', ma' gu tubobu karenda ga' nakarang wa. ");
INSERT INTO uvh_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Ka adibu ning anigu', o beng sini' girii na tubobu karenda ga'sa' nakitik de ka na yotangkanap tinga karenda ning amane guk mokngang. Waraga' tanga na ama wari tantumurum tinga ko yanga fatinga bagana aming fam wari urapsa' kuma' narafira mamoinga na karenda guk mo' tirik ning togu'. ");
INSERT INTO uvh_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Ka Jisas wari ning anigu', mamarak tanga kwi'ga mambong u manggaknanga kadak maya'. ");
INSERT INTO uvh_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Ning aniinga aming wari kaga' urapsa' karendanga ning tanga marara mambongni u manggaknanga mugo tugu'. Ka Jisas wari aming u tipkarendagu' wa mengkura ning kama sabat ganang tugu'. ");
INSERT INTO uvh_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Ka Juda aming adi bagana aming wari mambong ka sabat ganang manggara agu' u kanga ning aniging, ai kami ya sande sabat kanga defakem. Ka indining kadapmang tangkunang wa sande ganang kane kabi'sini' guk mo' titi waraga' tapni tang titam. Ka gu kami ya mambong guk wa nasiga' manggara yentang. ");
INSERT INTO uvh_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Ka adibu ning yanggu', mo' aming nua'ni ka nifikarenda tanga' wari ning nana', mambongga u manggaknanga mugo te' waraga' tanga wa mambong guk manggara abarik yang. ");
INSERT INTO uvh_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Ka adi u naknga nua'bu aniging, ka aming ka mambong mamanggak ga' gana' wa nisi'. ");
INSERT INTO uvh_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Ka Jisas adi aming u tipkarendanga wa unggung fafong da'ning guk mo' adegu'. Mokngang adi urapsa' kuma' kabinga anga aming kabi'mo' ning bining ganang amanga fiferanga mugogu'. Ning tinga aming adi nonda kafakafa mo' kigedagu' wara' adi Jisas ning wap u iyang ga' nafek tanga iyang guk mo' tugu'. ");
INSERT INTO uvh_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Ka inga' Jisas wari siring yak girii ganang amanga aming ka tipkarenda tugu' u kataunga ning anigu', tubobu kuma' karendangang u kaya'. Ka gu kadagang nua' mo' totang, inga' mamareng girii sini' wari ubu ma kadofigamo'. ");
INSERT INTO uvh_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Ning tinga aming adi Jisas udi wara'ganang kigedagu'. Ning tanga anga Juda aming u ning yanggu', aming ka kana urang nifikarendanga' wara'ning wapni wa Jisas wari tanama' ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Ka Juda aming adi Jisas wari bagana aming ka sabat ganang tipkarendagu' wa sabat ganang kane tugu' ning kaging. Ning tanga kabaksi' kadagang naknga kadapmang kadagang tantaramik ga' suking. ");
INSERT INTO uvh_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Ka Jisas adi Juda aming wari adita' kabaksi' kadagang nakngamging u kuma' yapkedanga ning togu', naning sibeng adi kane ningsa' tanga auta' wara' nandu' kanesa' tanga autik. ");
INSERT INTO uvh_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Ka Juda aming adi Jisas ning midi u naknga kabaksi' kadagang sini' nua'bu naknga ning tanga sasuksi' kigineneg sini' ka uuk titi waraga'sa' tiging. Ka adi Jisas wari kama tapni sabat ganang aming tipkarendagu' a nua'ni ka midi ka Anutu wa naganing babangna ning togu' wa adi na Anutu guk dabik ningsa' ning tutugu ning ningda'ning kaging. Ning tanga adi Jisas wari adisining dasi'ganang napa' fama' u tugu' wa kadagang girii ning kaging wara' adita' kabaksi' kadagang nakngamging. ");
INSERT INTO uvh_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Ka Jisas wari sareng sini' ning yanggu', beng sini' ning sanotik Anutuning mindingni na nasi' kane wa naganing sasuk ganangsa' nakedanga titining guk mokngang. Na sibeng wari tita' u kanga unggungsa' yaranga titik wara' sibeng guk ka mindingni nagok indining kaneni' wa kubnaniksa' titamuk. ");
INSERT INTO uvh_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Beng sini' sibeng Anutu adi mindingni nagata' siamo' nakita'. Ning tanga nasi' ka adi tita' wa adi mindingni naga kuma' nangtintingneinga kasasu'nanga tanga itik. Ka beng sini', inga' mindingni nagaganang wa napa' tangkunasi girisi sini' tanamo'ga'. Ning tinga sidi u kanga base tanga sasuk mimeng tini'ga'. ");
INSERT INTO uvh_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Wa ning, sibeng Anutu wari aming kungkumosi u tubobu ifimarara ka' iyak iminga ikiting ningsa' ka mindingni nandu' aming ka ni naganing sasuk ganangsa' wa na ka' iyak kareng u girisa' amotik. ");
INSERT INTO uvh_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Abanga kane kigineng ka aming ning iik u yapma tagagareyap titi wara'ning wa sibeng Anutu ana mo' tita', mokngang wa mindingni nagata' kuma' namgu'. ");
INSERT INTO uvh_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Ning tinga aming wari sibeng ning wap girii u bema areting ningsa' mindingni nagata' undu' tanamting. Ka aming ka mindingni nagata' bibi' naknga mesisiringa guk mo' tanamota' wa adi sibeng Anutu ka nangkara tinga afuguk waraga' bibi' naknamara'. ");
INSERT INTO uvh_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Beng guk sini' urang sanarik, aming ka naning midi u ninaksa' tanga sibeng ka nangkara tinga afuguk waraga' undu' naktangka tota' wa giri, adi ka' fikifiki ningsa' iik wara'ning. Adi Anutuning midi kigineng ganang guk mo' adewa', mokngang adi bagi ka kungkumak titi wara'ning u kabinga ka' iikning ganang ubu kuma' ita'. ");
INSERT INTO uvh_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Beng sini' torik aming ka kadagang ganang ira kuma' kungkumak ning ningda'ning iking wari Anutuning mindingni naganing midi ninak wara'ning kama wa kuma' kadofira'. Ka aming ka naning midi u naknga yara tinting wa adi ka' ningsa' ikni'ga'. ");
INSERT INTO uvh_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Ka sibeng Anutu adi ka' iikning ki sini' wara' adi mindingni nandu' anagok ka' dabik ningsa' iik waraga' nipmugu'. ");
INSERT INTO uvh_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Ka mindingni na Amingning Tim Iyak ning itik wara' sibeng adi aming aming ning iik a kabaksi' u yapdidimanga tagagareyap wara'ning girii nipmugu'. ");
INSERT INTO uvh_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Ka sidi midi ka u torik u naknga iguk aranga ning ma sukni', ai, Anutu adi tangkunang ka udi beng wa amigu'. Mokngang wa beng guksa'. Kama ka aming kungkumosi wari mindingni naganing midi naknga ");
INSERT INTO uvh_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","tubobu maraksasu'na wara'ning wa kuma'sa' kadofo'ga'. Ka aming ka kadapmang didimengsa' tanga ikanting wa marara ka' ningsa' ikni'. A aming ka kadapmang kadagang tanga ikanting adi marara Anutuning midi kigineng ganang adenga ning tanga mamareng girii bemni'ga'. ");
INSERT INTO uvh_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Ka beng sini' na sibeng Anutu wari kane ka aming tagagareyap waraga' nipmiinga wap guk udi giri itik. Ka na kane ka u tonga wa naganing sasuk ganangsa' titining guk mokngang, na kadapmang didimeng ka sibeng wari nanita' wara'ganangsa' yaranga titik. Beng sini' na nasi' kane wa naganing sasuk ganangsa' mo' titik. Mokngang na girina ka nangkara tinga afuguk wari titiga' nakita' unggungsa' titik wara' naning kane ka aming midiganang kukyapma tagagareyap wara'ning wa fe' kabi'sini' guk mokngang, didimengsa' titining. ");
INSERT INTO uvh_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Ka midi ka na aming girii, ning u aming kubanik nagasa' torok ganang wa giri sidi naknam guk mo' tianing. ");
INSERT INTO uvh_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Ka naganing ki u sangnatam wara'ning wa aming nua'ni ka sibeng wari undu' kuma'sa' tuguta'. Ka midi ka sibeng wari naganing ki waraga' u tuguta' wa na ning torik, beng guksa'. ");
INSERT INTO uvh_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Abanga tim sidi aming fam yangkareinga anga Jon Baptis u anigainga naganing iik wara'ning midi beng guk wa Jon wari kuma' saninga naking. ");
INSERT INTO uvh_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Beng sini' nagapmo'sa' tangkunang guk giri wara' na aming nua'ni wari yotangkanama tonam waraga' guk mo' sukitik, mokngang na nagapmo'sa' undu' girisa' toutik. Ka na sidi midi u kafakafa nakdidimanga kadagang guk mo' tanga kareng gi' giri iik waraga' sura naganing midi u tiptangka waraga' wa midi beng guk ka tim Jon Baptis wari sanggu' waraga' u torik wang. ");
INSERT INTO uvh_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Ka beng sini' tim Jon wari kadofinga sanggu' wa adi sidi diok sangang ganang abubu waraga' kadapmang sangtintingnegu'. Ka sidi adining midi ka kama pumpurumsa' ira sanggu' u naknga wa waraga' kabaksi' marara karengsa' naknga mesisiringa sa' tiging. ");
INSERT INTO uvh_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Ka midi ka Jon wari u togu' wa nagata'sa' sura togu'. Wara' sidi ning nakanting, Jon ning midi wari naning midi i tiptangkainga naganing midi wa beng guk ning kadofira'. Ka naning midi u tiptangkara' wara'ning girii sini' wa Anutu wari kane naminga napa' tangkunasi fam u tanga yararik wang. Wara' sidi u kanga o beni Anutu wari beng sini' anigaregu' ning tonting. ");
INSERT INTO uvh_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Ka naning midi u tiptangka wara'ning wa midi fam ka sibeng Anutu ka nangkara tinga afuguk wari undu' tim aming fam ininga adining midi wa kuma' yoksamging. Ka Anutu ka wa sidi adining iikning ki u nakedanga nonda kanga a adining bane sini' naknga ning guk mo' titing. ");
INSERT INTO uvh_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Abanga sidi adi nangkareinga afuguk nagata' naktangka guk mo' ting wara' adining midi wa sidining kabaksi' ganang kabi'sini' guk mo' ita', mokngang sini'. ");
INSERT INTO uvh_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Ka sidi tangkunang bema ka' iik titi waraga' sura midi kiginesi ka tim Anutu wari aming fam ininga yoking u kane girii sini' tanga indangira tonga fanakiting. Ka midi ka ka' iik titiga' u yoking wara'ning ki wa nagasa' yang, nagata'sa' sura yoking. ");
INSERT INTO uvh_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Ka sidi nagata' naktangka tianing wa giri sidi ka' fikifiki ningsa' beng sini' iikning. Ka mokngang, sidi nagata' naktangka titiga' bibi' naking wa sidi ka' iikga' bibi' ninak wara'ning kadapmang ting. ");
INSERT INTO uvh_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Ka beng sini' na midi ka u torik wa na sidi nagata' ninak wa ma nagata' mo' ninak waraga' sasuk mimeng mo' tanga torik, mokngang. ");
INSERT INTO uvh_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Ka sidi nagata' mo' naking wara'ning wa na ning sabarik ka sidi aming arantagim didimesi mo'. Abanga sidi kabaksi' ganang wa Anutuga' beng guk mo' naking waraga' tanga wa u torik wang. ");
INSERT INTO uvh_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Ka beng sini' na sibeng wari ananing kigineng girii guk nangkareinga abuguk. Ka mokngang, sidi naganing midi u naknga kafakafa kabi'guk mo' fatanabing. A aming ka anasining sasuk ganangsa' abanga tuguting wa sidi nakyam sa' tanga adisining wap bema aranga kafakafa sa' tiabiting. ");
INSERT INTO uvh_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Ka sidi sasuk ka sidining wap kura' bema arang titi waraga'sa' wa giri fasuking. A sidi napa' girii sini' ka Anutu wari sidining iiksi' u didimeng wa ma didimeng mo' ning u sasap waraga' sura sidaning iiksi' u tipdidimanga iikga' guk mo' fasuking wara' sidi nagata' naktangka guk mo' ting wang. ");
INSERT INTO uvh_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Ka sidi naganing midi waraga' nafek tanga wa ning mo' sukanting, a adi inga' indining kadagang waraga' beni Anutuning de ganang adenga midiganang kuknip ning wari unda' abanga tora'. Mokngang, aming ka midiganang kuksapma sangbe wara'ning wa Moses wari adining kadapmang tang ka sidi kafakafa guk mo' yaranga yotangkasap titining napa' kigineng kareng ning wa usingsa' kanga titing waraga'sa' tanga wa midiganang manggara kuksapma sangbewa'. ");
INSERT INTO uvh_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Ka beng sini' midi kadapmang tang ka Moses wari aming wari iik didimeng titiga' u yoku' wara'ning ki beng sini' wa nagasa'. Ka sidi Moses ning midi waraga' naktangka beng sini' tanga ikianing ganang wa kami naga kadofarik yara'ganang undu' sidi nakeda sa' tanga nagata' naktangka kuma' tianing. ");
INSERT INTO uvh_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Ka mokngang, sidi Anutuning midi tangkunang ka tim Moses wari bema yoku' waraga' naktangka guk mo' titing wara' sidi naning midi u naknga nakeda tanga nagata' naktangka titining guk mokngang. ");
INSERT INTO uvh_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Ka inga' Jisas wari kama tubo Galili u nua'bu anga yagu' ganang ka bot nua'ni ganang aranga mera Galili gwang wara'ning fugung tubo do ning tara' waraga' mugogu'. Ka gwang wara'ning wapni nua'ni wa Taibirias ning aniaging. ");
INSERT INTO uvh_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Ka aming arantagim girii adi kane tangkunasi ka tim bagana aming ifikarendainga kuma' kaging wari Jisas ning tang u kanga nua'bu tiam ga' naknga mandang yaranga aging. ");
INSERT INTO uvh_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Ka Jisas adi gwang fugung u anga kuma' kadofinga ning tanga arantagimni wara'guk kama bubo nua'ni ganang aranga mareiaging. ");
INSERT INTO uvh_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Ka kama ka wa Juda ning sande girii wapni Pasova u kanga tiaging wari kagadofi waraga' dudure kuma' tugu' wara'ganang aging. ");
INSERT INTO uvh_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Ka Jisas wari aming arantagim girii wari aging u fabanga yapma Filip u ning anigu', ai Filip se' indi aming arantagim girii do abing wara'siga' nana wa indeng tonga bema yamtam. ");
INSERT INTO uvh_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Ka Jisas adi nana tipkadofi ning kadapmang waraga' nafek mo' tanga togu', mokngang adi kuma'sa' kagu' de ka adi Filip wari adining tangkunang ga' naktangka guk udep tugu' u kadidima waraga'sa' sura wa u anikagu' wang. ");
INSERT INTO uvh_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Ka Filip wari midi ka Jisas wari anigu' u naknga base tanga ning togu', ai girii, nana udi aming kabi'mo' ningyara'guk u iminga nating. Abanga indi nana stoa ganangni ga' uningkim mambong girii ka 200 ning u kabinga manggara fabanga yamtam undu' mokngang, nibek kabi'sini' guk mo' tinting ning yabarik. ");
INSERT INTO uvh_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Ka arantagimni nua'ni Saimon Pita ning kuyangni wapni Andru wari Jisas u ning anigu', ");
INSERT INTO uvh_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","ka girii, saba uyamang nua'ni adi nana kafo kababi' faiv ning a ama ging kafo undu' fama' ningsa' wa giri manggara' yang, ka ya aming kabi'mo' ka ningwari nana ning guk mokngang. ");
INSERT INTO uvh_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Ka kama ka Jisas se' wari anga merafaging udi bingking kareng wara' Jisas wari arantagimni u ning yanggu', sidi ami taming do ininga kwang mera yarani'. Ning ininga arantagimni wari ami taming u ininga kwang unggung mera yareging. Ka aming u meking wa kabi' kabi'mo' arantagim girii sini', ka adi ami unggungsa' yapking wa bak girii sini' ka faiv tausen ning yapking, a taming guk ka sababi' guk wara'guk mo' indangiking. ");
INSERT INTO uvh_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Ka aming wari kamaganang u mekinga Jisas wari baret kababi' ka saba uyamang wari manggegu' u manggara Anutuga' ibang ka asekna ning togu'. Ning tanga arantagimni ga' iminga wari manggara fonga aming wara'siga' ima yareging. Ning tanga ama ging kafo kababi' fama' undu' ningsa' tanga ima yareinga naging. Ka aming dabiksa' giri nibeking. ");
INSERT INTO uvh_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Nibera ning tanga fam wa nagaremik tanga ibiging. Ka Jisas wari nana dibing nanga ibiging waraga' arantagimni u ning yanggu', nana ka nanga iibi ting wa sige ma kadani' wara' sidi manggara fabanga bak tanga unup ari'ganang tubobu gi' dasani'. ");
INSERT INTO uvh_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Ning tinga arantagimni wari nana didibing nanga ibiangaging u manggara fabanga unup ari' usap ka 12 ning sini' dasitoneging. Tim baret kababi' ka wa faiv ningsa' adeging ka inga' wari kabi'mo' ubu kadofigu' wara'ning dibing u fabanga dasiging. ");
INSERT INTO uvh_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Ka aming ka nana u naging adi Jisas wari napa' girii sini' ka adisining dasi'ganang sarengsa' tugu' u kanga ning toging, o beng sini' tim aming wari profet girii nua'ni wari abubu ga' urang toging wa kuma' abanga tinimara' ina yang. ");
INSERT INTO uvh_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Ning tanga aming adi Jisas ning kigineng girii u kanga adisining girisi' ka fuksi'ning sareng ira yaptatora waraga' bema kamina ga' suking. Ka Jisas adi adisining sasuksi' ka udi kuma' yapkedagu'. Ning tanga Jisas adi kapmo' urapsa' tafaferanga ibinga anga kama bubo nua'ni ganang aranga aming uwa kabi'guk mokngang anapmo'sa' merafagu'. ");
INSERT INTO uvh_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","17","Ning tanga defafa' kibiri ka Jisas ning arantagimni adi Jisas wari tubobu guk mo' abanga yapku' u kanga kama kuma' tugu' waraga' sura gwang gaga ga' mama tiging. Amanga kadofinga kama kuma' garegu' waraga' tanga botsi' wara'ganang anasapmo' aranga mera Kapaneam yongga' tubobu mugoging. ");
INSERT INTO uvh_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","19","Ka gugubik kigineng wari abanga gwang u figikbibingeinga adi kane girii ko tanga famugoging. Anganga gwang bining sini' ka 5 wa ma 6 kilomita ning kuma' kabinga anga tabanga kaging ka Jisas udi mandang inga' iwara anga gwang furo'ning u kamaganang da'ning tang sa' tipminga agu'. Ka arantagimni adi Jisas wari ana ganang unggung iwara ara mugogu' u tabanga kanga ai, wa nasi' kayam wa ning tonga kasara tanga mutu siamo' tiging. ");
INSERT INTO uvh_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Ka Jisas adi bot ganang u anga kadofinga ning katianggu', ai mutu mo' tinting, naga urang warisa' abarik. ");
INSERT INTO uvh_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Ka arantagimni adi inga' kigedanga kabaksi' karengsa' naknga ning tanga adisigok bot ganang u anga mek ga' ubu aniging. Ning tanga Jisas wari u anga mekinga wa bot wari gaga tubo do urapsa' kuma' anga kadofigu'. ");
INSERT INTO uvh_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Ning tanga deia' kamindapning ka aming arantagim girii ka Jisas wari nana tipkadofinga yamgu' ka gwang fugung unggung ibinga mugoging wari Jisas u irosi tangka sini' tanga ning toging, ai, aming ka udi indeng agu' sam, bot kubaniksa' bema abiging wa arantagimni anasapmo'sa' ba mera mugoging yapkum. ");
INSERT INTO uvh_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","24","Ning tong tonga inga' nakedanga ning toging, mokngang idi arantagimni wari mugoging u yapma adindu' mandang kuma' unda' iwara agu'. Ning tonga marara bot fam ka Taibirias yong aming wari inga' manggara anga kama ka girii wari aming ga' nana ibang tonga yamgu' wara'ganang didimeng fonga kuking wara'ganang ubu aranga mera Jisas ga' wenonga Kapaneam yongga' mandang iwara aging. ");
INSERT INTO uvh_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Ka ami taming wari Jisas ga' u wenanga anganga gwang fugung do kadofinga Jisas u kataunga ning aniging, ai tisa gu wa dari mabugung. ");
INSERT INTO uvh_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Ka Jisas adibu ning yanggu', a sidi kuma' sapkedarik sidi nagata' wena wa naga napa' tangkunang tinga kaging waraga' naktangka mo' tanga wening. Mokngang sidi nana tipkadofisaminga karengsa' nanga naking waraga'sa' sura wenanga nawara abing. ");
INSERT INTO uvh_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Ka beng sini' ning sanotik, sidi kane tangkunang ka nana ka tangkunang guk mokngang urapsa' kuma' bataga ning waraga' mo' sura tinting. Mokngang sidi nana tangkunang guk kareng ka yotangkasap tinga ka' fikifiki ningsa' iik wara'ning waraga'sa' wa giri sukanting. Ka nana tangkunang ka wa sibeng Anutu wari Amingning Tim Iyak naga girisa' iyamning ning napma nagata' tangkunang kuma' namgu' wara' nana ka wa nagasa' sansam wara'ning. ");
INSERT INTO uvh_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Ka aming wari ning aniging, ka ningwara' indi nasi' kadapmang tinga Anutu wari didimeng girisa' ting ning nipma touta'. ");
INSERT INTO uvh_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Ka Jisas wari ning yanggu', kadapmang ka Anutuning sasuk ganang didimengsa' titi wara'ning ki wa ning, sidi aming ka Anutu wari nangkareinga afuguk nagata' naktangka sa' tanga ikanting. ");
INSERT INTO uvh_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Ka adibu ning aniging, ka ningwara' gu napa' tangkunang ka ni tanga ningtintingneinga kanga wa giri o adi aming girii beng sini' ba ning tonga guta' naktangka tantam. ");
INSERT INTO uvh_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Ka tim indining papane adi kama bining sigesa' ganang anga ira nana tangkunang wap mana u iminga manggara nanga ikiaging. Ka wara'ning wa umpang tang ganang ning kuma' urang yoking wang, adi kunimganangni nana iminga nanga yaging. ");
INSERT INTO uvh_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Ka Jisas wari ning yanggu', beng guk sini' ning sanotik, nana ka Moses wari papase ga' u yamgu' undu' kunimganangni yamgu' de ka wa tangkunang sini' mo'. Mokngang nana tangkunang ka kunimganang ning sini' wa naning sibeng anasa' sansam wara'ning. ");
INSERT INTO uvh_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Ka nana tangkunang ka Anutu warisa' sansam ga' u torik wa aming ka kunim kuta kabinga afanga ami taming dabik sidi ka' iik waraga' yotangkasabita'. ");
INSERT INTO uvh_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Ka aming wari u naknga ning aniging, o girii, ningwara' nana tangkunang ka u torang wa fikifiki niminga nanga ikiantam. ");
INSERT INTO uvh_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Ka Jisas wari ning yanggu', beng guk sini' urang sanarik, nagasa' wa amingga' ka' iyak tipkadofiaminga iik wara'ning nana tangkunang beng sini'. Wara' aming ka nagata' naktangka tanga nagaganang sini' irota' adi nana ga' segi ninak a ama ga' mini nua'bu pamparanga ning guk mo' sini' tota'. Mokngang adi fikifiki damdang naknga tangkunang ningsa' ira auta'. ");
INSERT INTO uvh_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Ka na kuma' sapkedanga tim ning urang sanak wang, sidi naganing tangkunang wa naga napa' tangkunang tuguk u tanga sareng sini' kuma' kaging ka sidi waraga' sura naktangka guk mo' ting. ");
INSERT INTO uvh_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Beng sini' aming dabiksa' ka sibeng wari nagata' nanam ning wa nagata' naktangka tanga nagaganang iik wara'ning. Ka aming nagananang kuma' ikanting wa na tubobu yangkagare ning guk mokngang sini', adi nagok kafakafa gi' ningsa' ira au wara'ning. ");
INSERT INTO uvh_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Ka na kunimganang kuta afuguk wa napa' ka naganing sasuk ganangsa' titi waraga' mo' afuguk. Mokngang na sibeng ka nangkara tinga afuguk adining sasuk ganangsa' yaranga titi waraga'sa' afuguk. ");
INSERT INTO uvh_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Ka sibeng ning sasuk wa ning, na aming ka adi nagata' kuma' ibinamita' wa kafakafa yaptatoreinga ni ka kadaga kabi'guk mo' titi waraga'sa' nakita'. Ning tinga kareng gi' giri ningsa' ira anganga inga' kama wari ari' biwa' ganang wa tubobu dabiksa' ifimaraksasu'nok. ");
INSERT INTO uvh_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Abanga sibeng ning sasuk kigineng nua'ni wa ning, aming ka mindingni naganing kane u kanga nagata' naktangka tinting wa yotangkayap tinga ka' ningsa' iikning kigineng guk ikanting. Wara' inga' kama wari ari' biwa' ganang undu' tubobu dabiksa' abanga ifimarakinga ka' ikni' ning yanggu'. ");
INSERT INTO uvh_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Ka Juda aming adi midi ka Jisas wari na kunimganangni nana tangkunang wari afuguk ning togu' u naknga kabaksi' kadagang naknga anasa' arora yareging. ");
INSERT INTO uvh_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Ning toging, ai adi kunim kabinga afuguk ning guk wa indining tora' nakem, ya Jisas ka Josep ning mindingni urang udi. Adining mengbe undu' indi kuma'sa' yabitam adindu' amingsa' ka indigok ningsa'. ");
INSERT INTO uvh_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Ka Jisas wari ning yanggu', a sidi midi gangarang mimeng mo' arokanting. ");
INSERT INTO uvh_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Aming wari naga ganang abubu wara'ning wa anasa' sura nakedanga abubu ning guk mokngang. Mokngang sini' wa sibeng ka nangkara tinga afuguk warisa' amingning kaba u tipdidimanga sasuk amiinga wa giri adi napkeda tanga nagananang abota'. Ning tinga na kama ari' biwa' ganang wa tubobu tipmarakinga adi ka' ningsa' ira awa'ga'. ");
INSERT INTO uvh_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Ka midi ka waraga' wa midi nua'ni ka tim profet wari kuma' yoking wa ning, Anutu warisa' aming aming ga' sasuk imo'ga' ning yoking. Wara' aming ka Anutuning midi u naknga nakeda guk kuma' tinting warisa' wa nagaganang abanting. ");
INSERT INTO uvh_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Ka beng sini' aming kamaganangni ka ni sibeng kabi'guk mo' kata'. Mokngang sini' nagapmo' kubaniksa' wa sibeng guk kubap iya' kabinga afuguk nagasa' wa sibeng ning iik u nakedanga itik. ");
INSERT INTO uvh_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Ka beng guk sini' urang sanarik, aming ka nagata' naktangka tota' adi ka' iyak kareng ka fikifiki ningsa' bema irota'. ");
INSERT INTO uvh_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Nagasa' na amingga' ka' ningsa' iyak kareng u tipkadofiam wara'ning nana tangkunang beng sini'. ");
INSERT INTO uvh_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Tim sidining papase adi kama bining sige ganang ira nana wap ka mana u kuma' nanga ikiaging de. Ka adi mana wari yotangkayabinga ka' ningsa' ko mo' ikiting. Mokngang aming dabik ka mana u nanga ikiaging wa inga' kungkumak kuma' tiging. ");
INSERT INTO uvh_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Ka nana tangkunang sini' nua'ni ka kunim ganang kuta afugu' ka ingging kuma' adera' wa kigineng guk. Ka aming wari nana ka u nanting wa kungkumak titining guk mokngang. ");
INSERT INTO uvh_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Ka nana tangkunang ka' iyak titining ka kunim ganangni ka u torik wa nagasa' yang. Ka aming wari nana ka u nauta' wa ka' fikifiki ningsa' irota'. Nana ka u torik wa naganing fukna gom ka aming dabiksa' wari nanga ka' ningsa' iik waraga' kabiamotik waraga' torik. ");
INSERT INTO uvh_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Ka Juda aming adi midi ka Jisas wari ananing fugu gom u nana ga' togu' u naknga kabaksi' kadagang sini' naknga anasa' ning toging, ai, aming ka ya fugu gom ka nana da'ning niminga nana ga' ba tora'. ");
INSERT INTO uvh_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Ka Jisas adi adisining sasuksi' u kuma' yapkedanga ning yanggu', beng sini' ning sanotik, sidi Amingning Tim Iyak naganing fukna gom u nanga a amaa u topnanga ning guk mo' tinting wa ka' iyak titining guk mokngang. ");
INSERT INTO uvh_vpl VALUES ("JN6_54","073_6_5