﻿USE sofia;
DROP TABLE IF EXISTS sofia.utr_vpl;
CREATE TABLE utr_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES utr_vpl WRITE;
INSERT INTO utr_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Odzɛ etɔ mgbi iYesu iKrestu Ongwɛ iDevedi, ongwɛ Abrahan. ");
INSERT INTO utr_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abrahan li otsɔ Adziki, Adziki li otsɔ iJeko, iJeko li otsɔ iJuda bɛyi emi ongwunɔn, ");
INSERT INTO utr_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","iJuda li otsɔ iPeredzi bɛyi iDzera, onɔ ma li iTama, iPeredzi li otsɔ iHezrɔn, iHerizɔn li otsɔ iRama, ");
INSERT INTO utr_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","iRama li otsɔ Aminada, Aminada li otsɔ iNashɔn; iNashɔn li otsɔ iSamon, ");
INSERT INTO utr_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","iSamon li otsɔ iBoadzi, ongwu onɔn li iRaha, iBoadzi li otsɔ Obɛdi, ongwu onɔn li iRutu, Obɛdi li otsɔ iJese; ");
INSERT INTO utr_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","iJese li otsɔ Utɔ iDevedi; iDevedi li otsɔ iSolomu ongwu onɔn li owa Uria, ");
INSERT INTO utr_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","iSolomu li otsɔ iRehobuan, iRehobuan li otsɔ Abyija, Abyija li otsɔ Asa, ");
INSERT INTO utr_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa li otsɔ iJehoshafa, iJehoshafa li otsɔ iJoran, iJoran li otsɔ Udzia; ");
INSERT INTO utr_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Udzia li otsɔ iJotan, iJotan li otsɔ Ahadzi, Ahadzi li otsɔ iHedzekia; ");
INSERT INTO utr_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","iHedzekia li otsɔ iManase, iManase li otsɔ Amɔn, Amɔn li otsɔ iJosia, ");
INSERT INTO utr_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","iJosia li otsɔ iJekonia bɛyi emi ongwunɔn. Taman a kwu ma ofyɛɛ lu ɛsɛ iBabyilon. ");
INSERT INTO utr_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Ngwi egbe mgbi ama mi iBabyilon wa ngyɛ nɛ; iJekonia mba iShetiɛ, iShetiɛ mba iDzerubabɛ, ");
INSERT INTO utr_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","iDzerubabɛ mba Abyidu, Abyidu mba Eliakin, Eliakin mba Azɔ; ");
INSERT INTO utr_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azɔ na di mba iDzadɔku, iDzadɔku mba Akin, Akin mba Elidu, ");
INSERT INTO utr_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Elidu mba Eliadza, Eliadza mba iMatan, iMatan mba iJeko; ");
INSERT INTO utr_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","iJeko mba iJose oba iMeri; li iMeri ongwu nmba iYesu ongwu a li kwun di iKrestu nani. ");
INSERT INTO utr_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Etɔ nwita mbi Abrahan nghataa kɛ mbi iDevedi li iwyodenɛ; Wita mbi iDevedi nghataa kɛ onɔ ngwi a gbe ma lu iBabyilon li etɔ iwyodenɛ yi onɔ ngwi a tɔ abɔ ofyɛɛ mi iBabyilon nghataa ba onɔ mgbi iMedzaya na kpaa li etɔ iwyodenɛ. ");
INSERT INTO utr_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Nɛnɛ li ngha ngwi ombaamba mgbi iYesu iKrestu dzɛ aani: Onɔn iMeri, ngwu iJose tsikwɔn dzɛ esɛ, kpaa duuse no kyon yɔ, a din yi ifewo mi mfye mgbi Onodzi Osaan. ");
INSERT INTO utr_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Nghaduu iJose oban li inggisɛ osuse, i minan onun ayiwi mi ododa ba nɛ, o kye weka gbɛɛ ongwu ka gha yan fyɛɛ. ");
INSERT INTO utr_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Dafi o le tsɛwodzɛ nɛ ngha nɛ, ongyesɔ mgbi Otsɛ wa tsetun mi elela, nyan gbɛɛ, <<IJose ongwɛ iDevedi, ka mio okyi kyelu iMeri lu udɛ abu gbɛɛ no li owa abu ba, ikyesinɛ ifu ngwi o byi na li mi Onodzi Osaan. ");
INSERT INTO utr_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","O ka wa mba ongwongyulɔ, ta abu ka kwun iyi gbɛɛ iYesu, lubana o ka dulu emidan tɔ mi ali ibwubwe mgbi ama.>> ");
INSERT INTO utr_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Ungwɔ ntonɛ duu kyɔ ikye ombwo ondu odzɛɛdzɛ mgbi Otsɛ ongwi o gbɔ nyɛ mbi oyegbɔ gbɛɛ, ");
INSERT INTO utr_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","<<Ongwongyaa ibidrua ka wa byifu mba ongwongyulɔ, a ka kwun iyi di Imanue,>> itan gbɛɛ, <<Imgbasho dzɛ yi eyi nani.>> ");
INSERT INTO utr_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Ngwi iJose kyɛ una nɛta, o kyɔ dafi ongyesɔ mgbi Otsɛ nyan mani, o kyi kyelu iMeri lu udɛ mgban yɛɛ owan. ");
INSERT INTO utr_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Kpaa o gbewo yan ba nghataa iMeri wa mba ongwongyulɔ, o si kwun iyi gbɛɛ iYesu. ");
INSERT INTO utr_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Ngwi a mba iYesu mi iBɛtlɛhɛn mi iJudia duu nɛta, iHerude li utɔ mi onɔ nani, inggisɛ ama oyodzɛ mi onosa wa kaka iJerosalin, ");
INSERT INTO utr_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","le byita gbɛɛ, <<Ongwɛ ongwu a mba nli Utɔ mgbi emi iJuda nɛ, a kyon ladzɛ ole? Lubana eyi di mcɛ mgban mi onosa, ngwi eyi ba owa sunun aani.>> ");
INSERT INTO utr_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Ngwi utɔ iHerude fwo odzɛ nɛ ngha nɛ, i kakan ewo bɛyi emi iJerosalin duu. ");
INSERT INTO utr_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","O kwu engyukwo ama ofifɛ mgbi Imgbasho bɛyi ama otso ola duu kwakye, o byi ma gbɛɛ li mi ole ngwi a ka mba iMedzaya ma? ");
INSERT INTO utr_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","A nyan gbɛɛ: <<Li mi iBɛtlɛhɛn mi iJudia, Lubana li ungwɔ ngwi oyegbɔ tsekise lɔ gbɛɛ: ");
INSERT INTO utr_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","<< <Kpaa abu, iBɛtlɛhɛn, mi ikpɛsɛ mgbi iJudia, o ka yama li igeli oyɛyikpa mi iJudia ba; lubana li mbi abu ngwi inggisɛ ogbe inggisɛ teyi ka tɔ nka ngyo emidani Israi.> >> ");
INSERT INTO utr_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Ta iHerude kwu ama oyodzɛ ntona ela daada di byi ma ita klɛklɛ ni ongwu ye onɔ ngwi mcɛ na tsetu ma mani. ");
INSERT INTO utr_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","O si nu ma ofɛ lu iBɛtlɛhɛn di nya ma gbɛɛ, <<Lu ka pitan saan na. Ni ema ka din taman yɛ wa nya ani, adzi ni ani kpaa ka su nun.>> ");
INSERT INTO utr_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Ngwi a fwo odzɛ ngwi utɔ gbɔ nɛ, a tasɛ lu ta mcɛ ongwi a di mi onosa ma gbe ma teyi nghataa ka kwulɛsɛ mi imbe ngwi ongwɛ na ladzɛ mani. ");
INSERT INTO utr_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Onɔ ngwi a di mcɛ na ma, a dzɛ yi atsa kwuba. ");
INSERT INTO utr_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Ta ama oyodzɛ kaka ozu di ongwɛ yi onɔn iMeri, a kwɛsɛ su nun, nɛ a kwulu igbe mgbi ama dulu abashi, engyie ogbungbɛ yi iMire gbe ghan umba. ");
INSERT INTO utr_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Nɛ ama oyodzɛ ntona yɛ nyɛ ofɛ oka lu ɛsɛ udɛ ma, lubana Imgbasho tsekise woma elela kwo ma adɔ gbɛɛ nu ma ka yɛ nyɛ mbi iHerude wuba. ");
INSERT INTO utr_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Onɔ ngwi ama oyodzɛ lu dzita emi iMeri nɛ, ongyesɔ mgbi Otsɛ wa tsetu iJose mi elela owoowo nyan gbɛɛ: <<IHerude ka wa pita ongwɛ nɛ gbɛɛ ni ongwu ngwɔn. Nghanɛ kyato, kyelu ongwɛ yi onɔn tsinya lu Igyibiti, to ele na nghataa ni ani wa nya ema gbɛɛ ni ema kyɛɛ yɛ se.>> ");
INSERT INTO utr_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","IJose kyato una mi otu na, kyi kyelu ongwɛ yi onɔn, lu Igyibiti. ");
INSERT INTO utr_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","O dzɛ ele nghataa ba onɔ ngwi iHerude wa kwulu. Ungwɔnɛ kyɔ ikye onu odzɛ ngwi Otsɛ Imgbasho gbɔ nyɛ mbi oyegbɔ gbɛɛ, <<Ani kwu Ongwani ela tasɛ mi Igyibiti,>> ma yɛɛ otsitsi. ");
INSERT INTO utr_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Onɔ ngwi iHerude difwi dafi ama oyodzɛ ntona kyɔn ikwangha ewo nɛ, eka kplɔkɔ lon. O noola gbɛɛ nu ma kye ngwɔlu ali ongwongyulɔ ama mmɛ onova efa yɛyikpa sini mi iBɛtlɛhɛn bɛyi agwɔ ama nwatse dɔn duu. O gbɔdzɛ nɛ mi ikye odzɛ ngwi ongwu fwo mbi ama oyodzɛ ntonani. ");
INSERT INTO utr_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Ta odzɛ ngwi oyegbɔ iJeremia teyi gbɔ ma yɛɛ otsitsi gbɛɛ: ");
INSERT INTO utr_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","<<A fwo ela akwɔ mi iRama, akwɔ ikwu otseetse kpakpa iRacɛ le makwɔ ikye ɛngbɛ mgban, o fwa onu ma gyilan, ikyesinɛ a kwulu.>> ");
INSERT INTO utr_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Ngwi iHerude kwulu nyɛ nɛ, ongyesɔ mgbi Otsɛ kɛ mbi iJose mi elela owoowo mi Igyibiti ");
INSERT INTO utr_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","ka gbɛɛ, <<kyato, kyelu ongwɛ yi onɔn, yɛ lu ɛsɛ Israi, ikyesinɛ ama nle fya ongwɔ ongwɛ nɛ ma kwulu wa.>> ");
INSERT INTO utr_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Man iJose kyato, kyi kyelu ongwɛ yi onɔn yɛ luba Israi. ");
INSERT INTO utr_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Nghaduu ngwi iJose fwo gbɛɛ Acelusi gyutɔ gbikye otsɔn iHerude mi iJudia nɛ, o wimio oka kaka ele, a di won elela kwon adɔ nɛman, o yɛ lu ayɛsɛ iGalalia ");
INSERT INTO utr_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","ka dzɛ igeli ngwi a kwun di iNadzareti nani. Nɛ odzɛ ngwi oyegbɔ tsekise gbɔgbɛɛ: <<A ka kwun di inggisɛ iNadzareti,>> na mbwumbwo. ");
INSERT INTO utr_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Mi onɔ na iJɔn okyɔ iBatisima badzɛ okwɛsɛ mi iJudia le gbeesɔ. ");
INSERT INTO utr_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","O gbɛɛ, <<Kyata mi ali ibwubwe mgbi ema na ikyekyɛ Esutɔ ongwi esho dzɛ kwɛkwɛ.>> ");
INSERT INTO utr_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","IJɔn li ongwu oyegbɔ Adzaya tsekise gbɔdzan mi onɔ ngwi o gbɛɛ: <<Inggisɛ le kweela mi okwɛsɛ gbɛɛ, <mɛlu ofɛ ikye Otsɛ, no byi yɛyɛ na.> >> ");
INSERT INTO utr_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","A mɛ angwuto mgbi iJɔn mi andu ilakwumyi; o kye okpa bwa oshi, ungwogye mgban li okpa yi enewo. ");
INSERT INTO utr_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Inggisɛ tɔkyɛ iJerosalin tole ba mbon bɛyi ali agwɔ mgbi iJudia yi ayɛsɛ nto kwɛkwɛ yi ekyoo mgbi iJodan duu. ");
INSERT INTO utr_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","A fwi ali ibwubwe mgbi ama man iJɔn kyɔ ma iBatisima mi ekyoo iJodan. ");
INSERT INTO utr_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Ngwi iJɔn di emi iFarasi yi emi iSadusi kwuba le ba mbon owa kyɔ iBatisima nɛ, o nya ma gbɛɛ: <<Ema engwɛ ogidzi ntonɛ! Li emɛ wɛ ema odzɛ gbɛɛ ni ema tsinya itingga mgbi Imgbasho nka wa ba na? ");
INSERT INTO utr_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Wa owaawa ntso ambɛ itukwu okyata-kyata mani. ");
INSERT INTO utr_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Dika tsɛwɛ gbɛɛ ema ka gbɔ yi ewema gbɛɛ, <Abrahan li otseyi ba.> Ani le nya ema gbɛɛ Imgbasho ka yagba kyata akwutsɛ ntonɛ nu ma yɛɛ etɔ mgbi Abrahan! ");
INSERT INTO utr_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Onɛnɛ kpaa Imgbasho kye ika ladzɛ akpekwɔ le fɛ odzɛɛdzɛ, ali ekwɔ nwa owaawa osuse ba duu a ka kye dzɛlu ngwuta di kye wokɛ ola. ");
INSERT INTO utr_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","<<Ani le kyɔ ema iBatisima yi eni otso ambɛ itukwu okyata-kyata. Kpaa ongwu nka wa ba mi iyikpa ani ma shewo ngha ani, ani mɛ ogben okpafɔ ba. O ka kyɔ ema iBatisima mi Onodzi Osaan bɛyi ola. ");
INSERT INTO utr_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Okwuga mgban ofo ungwɔ byidzɛ abɔ, o ka folu etɔ mgban kyi gbelu osuse duu wokɛ oba, ikpaflo yɔ, o ka gbe toola mi ola nka myunu ba mani.>> ");
INSERT INTO utr_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Mi onɔ na iYesu kyɛ mi iGalalia wa kaka si ba mbi iJɔn mi ekyoo iJodan owa kyɔ iBatisima mbon. ");
INSERT INTO utr_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Kpaa iJɔn fwa yan gbɛɛ, <<Li ani ngwu abu kika kyɔ ani iBatisima, ma kyɔnɛ ngwi abu ba mbi ani?>> ");
INSERT INTO utr_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Nghaduu iYesu nun uka gbɛɛ, <<Onɛnɛ yɔ no dzɛ ngha; lubana li kyɛmɛ ngwi eyi ka kyɔ oweka mgbi Imgbasho.>> Man iJɔn gbela. ");
INSERT INTO utr_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Ntunto ngwi iYesu kyɔ iBatisima di kyɛɛ mi eni nɛta, esho kwulu. Ta o di Onodzi Imgbasho kyɛ le ba dafi anyama wa dɔnkɛ ewo. ");
INSERT INTO utr_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ta ela tɔ mi esho gbɛɛ, <<Nɛnɛ li Ongwani, ongwi itukwu-itukwu; li mbon ngwi ani dzɛ yi atsa.>> ");
INSERT INTO utr_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Ta Onodzi Osaan kye iYesu lu okwɛsɛ ni iSatan ka mbadin. ");
INSERT INTO utr_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Dafi iYesu tukwondu egbe ngwusefa yi otu ngwusefa nyɛ nɛ, enbwa dɔn. ");
INSERT INTO utr_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Ta iSatan ba mbon wa nyan gbɛɛ, <<Kini abu li ongwɛ Imgbasho yɔ, wo akwutsɛ ntonɛ ola nu ma kyata yɛɛ ibredi.>> ");
INSERT INTO utr_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Kpaa iYesu nun uka gbɛɛ: <<Afɛ lɔ gbɛɛ, inggisɛ ka dzɛ oshishe mi ibredi ta ba, kpaa li mi ali elodzɛ ntɔ mi ondu mgbi Imgbasho mani.>> ");
INSERT INTO utr_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Ta iSatan di kyon lu ogalu osaan, kyon ka dɔkɛ ikyikye ozu osunu Imgbasho, ");
INSERT INTO utr_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","o nyan gbɛɛ, <<Ni abu li ongwɛ Imgbasho yɔ, bulu lu esɛ. Lubana Afɛ lɔ gbɛɛ, <<Imgbasho ka wo engyesɔ mgban ola ikye abu, a ka kye gbɛlu abu mi abɔ mgbi ama, ikyegbɛɛ ni abu ka kye afɔ tsɛ akwutsɛ ba.>> ");
INSERT INTO utr_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","IYesu nyan gbɛɛ, <<Afɛ di lɔ gbɛɛ, <ka mbadi Otsɛ Imgbasho mgbi abu ba.> >> ");
INSERT INTO utr_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","ISatan di kyon lu ka tɔkɛ unggwɔ nshigbo kpakpa di tson esutɔ mgbi ɛsɛ duu bɛyi okwɔkwɔ mgbi ɛsɛ. O nyan gbɛɛ: ");
INSERT INTO utr_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","<<Kini abu kwɛsɛ sunu ani yɔ, ungwɔ ntonɛ duu n ka gbe nu abu.>> ");
INSERT INTO utr_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Nghaduu iYesu nyan gbɛɛ, <<Yɛ enggengga iSatan! Lubana Afɛ lɔ gbɛɛ: <Sunu Otsɛ Imgbasho mgbi abu, di li ongwu ta kyɔn idɔ.> >> ");
INSERT INTO utr_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Ta iSatan lu dzanta, man engyesɔ mgbi Imgbasho ba wa tobyun. ");
INSERT INTO utr_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Ngwi iYesu fwo gbɛɛ a kye iJɔn wokɛ obawi nɛ, o yɛ lu iGalalia. ");
INSERT INTO utr_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","O dzata iNadzareti si lu ka dzɛ iKapenahun ndzɛ mi ewuutɔ iGalalia mi ayɛ mgbi iDzebulun bɛyi iNaftali ");
INSERT INTO utr_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","ikye ombwumbwo odzɛ ngwi oyegbɔ Adzaya tsekise gbɔ mani gbɛɛ: ");
INSERT INTO utr_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","<<Ɛsɛ iDzebulun yi iNaftali, ofɛ olu ekyoo okwukwo, mi olu iJodan, iGalalia mgbi emi agwɛsɛ ");
INSERT INTO utr_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","inggisɛ ama nlato iifu a di osa okwukwo; ama nlato iwulu ikwongye osa gbosa tu ma.>> ");
INSERT INTO utr_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Wita mi onɔ na nghataa lu iyayi iYesu wita ogbeesɔ gbɛɛ <<kyata mi ali ibwubwe mgbi ema na, lubana esutɔ ongwi esho dzɛ kwɛkwɛ.>> ");
INSERT INTO utr_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Dafi iYesu le kyikyɛ nyɛ ewekyoo okwukwo mgbi iGalalia nɛ, o di engwuneka nghi efa, iSaimɔn nli iPyita nani bɛyi ongwunɔn Andru. A tole ngwi ukɛ mi utɔ lubana a li ama okwu mmbweni. ");
INSERT INTO utr_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","IYesu nya ma gbɛɛ, <<Ba, wa kyɛdɔ ani na, ta ani ka kyata ema yɛɛ ama okwu inggisɛ.>> ");
INSERT INTO utr_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","A byakpa dzata ukɛ mgbi ama kyɛdɔn. ");
INSERT INTO utr_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","O gble kiyayi nɛ, o di engwunɔ angbeka efa, iJɛnsi bɛyi ongwunɔn iJɔn emi ongwɛ iDzebedi. A woto uwaa yi otsɔma, le mɛ akɛ. IYesu kwu ma ela, ");
INSERT INTO utr_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","plɛ nɛta a dzita otsɔma bɛyi uwaa si kyɛdɔn. ");
INSERT INTO utr_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","IYesu kyikyɛ kpatsɛ iGalalia, le tso mi ozu okwakye mgbi emi iJuda, le gbɔ Esɔ Osuse mgbi esutɔ, dile ngyɛlu inggisɛ ootse idzidza-dzidza. ");
INSERT INTO utr_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Odzɛ mgban si gbɔfwɛ kpatsɛ ali imbe mi iSiria, ta inggisɛ gbe ama ndotse ita idzidza-dzidza ba mbon, ama nle gyadzɛ yi owulu-wulu, yi ama ngwu esɛ dɔ ma ikye, ama odzɛkwulu yi ama ogbyikye tukwu esɛ, kpaa iYesu ngyɛlu ma ele duu. ");
INSERT INTO utr_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Ijiji inggisɛ mi iGalalia yi iDekapoli yi iJerosalin yi iJudia bɛyi ayɛsɛ nto oyombo ekyoo iJodan duu kyɛdɔn. ");
INSERT INTO utr_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Mi onɔ ngwi iYesu di ibyi inggisɛ nɛ, o tɔkɛ ewunggwɔ ka sɔkɛ esɛ. Engwafɔɔn ba mbon, ");
INSERT INTO utr_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","o si wita otso ma gbɛɛ: ");
INSERT INTO utr_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","<<Atsa dzɛ yi ama ndzɛ adzɛ mi onodzi, lubana esutɔ ongwi esho li mgbi ama. ");
INSERT INTO utr_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Atsa dzɛ yi ama ndzɛ yi etse inɛ onɛnɛni, lubana Imgbasho ka gyila ma! ");
INSERT INTO utr_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Atsa dzɛ yi ama nsulu itukwu iyu, lubana a ka gyokwudɛ ɛsɛ. ");
INSERT INTO utr_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Atsa dzɛ yi ama enbwa dɔ ma ngwi ekweni di kwu ma ikye osaan mani, lubana Imgbasho ka nu ma tolo. ");
INSERT INTO utr_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Atsa dzɛ yi ama odi elela, lubana Imgbasho ka di ma elela. ");
INSERT INTO utr_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Atsa dzɛ yi ama itukwu gbosa mi ifun, lubana a ka di Imgbasho. ");
INSERT INTO utr_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Atsa dzɛ yi ama oba yi iyu, lubana a ka kwu ma di engwɛ Imgbasho. ");
INSERT INTO utr_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Atsa dzɛ yi ama nli gbiisɔ ikye osaan mani, lubana esutɔ ongwi esho li mgbi ama. ");
INSERT INTO utr_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","<<Atsa dzɛ yi ema ngwu a fya ema ito di nu ema isɔ di mwonya ibwubwe bɛ ema ewo mi ikye ani mani. ");
INSERT INTO utr_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Dzɛ yi atsa kpakpa na, ikyekyɛ umba mgbi ema shewo mi esho, bana li ngha ngwi a nu ama ogbɛɛsɛ ama nteyi ema ma kpaa isɔ aali. ");
INSERT INTO utr_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","<<Ema li mmwaa mgbi ɛsɛ. Kpaa kini mmwaa fyumfya wuba ma, a ka kyɔsinɛse non yɛ fyumfya? Ungwɔ ntishi ngwi a ka kyɔ yan yɔ, se li okye yangwuta ni inggisɛ kye afɔ dzin. ");
INSERT INTO utr_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","<<Ema li osa mgbi ɛsɛ. Ogalu okwukwo ndɔdzɛ undɔ ka yagba dzɛ daada ba. ");
INSERT INTO utr_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Naadi inggisɛ ka kye ipitila dɔ di yile mgboko tukwun ba. Kpaa a ka kye dɔkɛ mi ododa, no nu osa mbi ali inggisɛ duu mi ifoozu. ");
INSERT INTO utr_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Mi itɔ ofɛ nɛ yɛyɛ, ni osa mgbi ema gbosa mbi inggisɛ, ikye nu ma di okyɔɔkyɔ mgbi ema osuse diyɛ tsɛ Otsema ongwi esho. ");
INSERT INTO utr_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","<<Ka tsɛwɛ gbɛɛ ani ba owa ndɛlu Ola naadi elodzɛ mgbi emi Oyegbɔ ba; ani ba owa ndɛlu ma ba kpaa li owa nu ma mbwumbwo. ");
INSERT INTO utr_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Ani nya ema otsitsi, esho yi esɛ ka nyɛ, kpaa ambɛ olɔ ungwɔ nnghao shanyɛ hona nghao yɛyikpa ngwi a lɔ mi Ola onyi kpaa ka byulu ba. Nghataa alungwɔ duu ka wa mbwumbwo. ");
INSERT INTO utr_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Ali inggisɛ nfoola onyi nnghao shanyɛ mi ola ntonɛ diyɛ tso angbeka okyɔ ngha yɔ, a ka kwun di olɛlɛ mi esutɔ ongwi esho, kpaa ali inggisɛ nkyɔ mi ola diyɛ tso ola ntonɛ, a ka kwun di ogbagbadzidzi mi esutɔ ongwi esho. ");
INSERT INTO utr_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Lubana ani nya ema gbɛɛ sede osaan mgbi ema ka ngha mgbi emi iFarasi bɛyi etsetse mgbi ola mgbi iMose bayɔ, ema kpaa ka kaka esutɔ ongwi esho na ba. ");
INSERT INTO utr_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","<<Ema teyi fwo a gbɔ yi inggisɛ tugbe gbɛɛ, <Ka ngwɔ inggisɛ ba, ma ali inggisɛ nngwɔ inggisɛ tayɔ a ka gbɔn ikwɔ.> ");
INSERT INTO utr_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Nghaduu ani le nya ema gbɛɛ inggisɛ nkyitingga yi ongwunɔn yɔ, mɛ ogbɔn ikwɔ. Ali inggisɛ ndi kwu ongwunɔn gbɛɛ, <Imbuu,> ka nu uka mi opiikwɔ okwukwo. Kpaa inggisɛ ta nkwu ongwunɔn gbɛɛ, <Abu ikwangha inggisɛ yɔ!> ka dzɛ inoola mgbi udola. ");
INSERT INTO utr_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","<<Nghanɛ, ni abu le nu umba mi iwashi wa wɛ gbɛɛ ongwunabu dzɛ yi okakewo yi abu yɔ, ");
INSERT INTO utr_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","dzita umba na mi iwashi. Teyi lu ka yile ide gye yi ongwunabu; ta yɛ wa nu umba mgbi abu. ");
INSERT INTO utr_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","<<Yile ide gye plɛ yi ongyikyili mgbi abu ongwu nkye abu le kɛ opiikwɔ. Kyɔ ngha yan ngwi abu ka kyɛ yan mi ofɛ mani, bana o ka kye abu wo inggisɛ ogbiikwɔ abɔ, inggisɛ ogbiikwɔ na dika kye abu wo adruba abɔ, man o ka kye abu wokɛ obawi. ");
INSERT INTO utr_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","N nya abu otsitsi, abu ka tɔ ba sede abu ka kpa mkpa ngwi abu dzɛyan ma klɛklɛ olifo onyi kpaa ka sisi ba. ");
INSERT INTO utr_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","<<Ema teyi fwo a gbɔgbɛɛ, <Ka kyɔ amah ba.> ");
INSERT INTO utr_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Kpaa n nya ema gbɛɛ inggisɛ ta ndi ongyaa inɛ mbe anggwɔ yɔ, tsekise kyɔ amah yan mi itukwu mgban. ");
INSERT INTO utr_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Kini inɛ mgbi abu abugye nu abu kyungwɔ obube, kyi todulu ngwuta. I tatase ni alewo mgbi abu onyi nyanya ngha onu ma kye ewo mgbi abu olɔlɔ ngwuta wokɛ udola. ");
INSERT INTO utr_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ni abɔ abugye mgbi abu di nu abu kyungwɔ obube yɔ, kye dzɛlu ngwuta. Bana ka tatase ni alewo mgbi abu onyi nyanya ngha onu ma kye ewo mgbi abu olɔlɔ ngwuta wokɛ udola. ");
INSERT INTO utr_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","<<A tsekise gbɔgbɛɛ, <Ali inggisɛ nlɔ owan onya yɔ, li kyɛmɛ ngwi o ka nun afɛ ogheeba.> ");
INSERT INTO utr_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Nghaduu ani nya ema gbɛɛ inggisɛ ta nlɔ owan onya, ni li mi itɔdzɛ mgbi amah bayɔ, o non yɛɛ ongyaa amah, inggisɛ ndi kye ongyaa ngwu a lɔn onya kyɔ amah. ");
INSERT INTO utr_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","<<Ema di fwo a nya inggisɛ tugbe gbɛɛ, <Ka ndɛlu ofaafa mgbi ema ba, kpaa ngyo ondu odzɛɛdzɛ ngwi ema dzɛ yi Otsɛ mani.> ");
INSERT INTO utr_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Kpaa n nya ema, ka fa ba duudu: ni li mi esho kpaa, lubana li itsuutɔ mgbi Imgbasho; ");
INSERT INTO utr_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","hona mi ikpɛsɛ, lubana li imbe okye atafɔ mgban dɔ ele; naadi mi iJerosalin, lubana li ogalu okwukwo mgbi Utɔ Ogbagbadzidzi. ");
INSERT INTO utr_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Dika fa mi ikye mgbi abu ba, lubana abu ka yagba onu alotu onyi mi ikye mgbi abu kpaa yɛɛ onzundzɛ hona onbyinbyi ba. ");
INSERT INTO utr_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Ungwɔ nli adzɛ bayɔ, <Ɛɛn> mgbi ema no li <Ɛɛn,> <Ei,> mgbi ema no li <Ei>; ungwɔ nnghaabɔ nɛ duu kyɛ mbi owapɛ olodu. ");
INSERT INTO utr_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","<<Ema teyi fwo a gbɔgbɛɛ, <Inɛ yi inɛ, aba yi aba.> ");
INSERT INTO utr_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Kpaa n nya ema, ka kpumkpa obube mi ikye obube ba. Kini inggisɛ ta abu afɛ mi atadɔ abugye, kyata agya oka na kpaa nun. ");
INSERT INTO utr_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Ni inggisɛ di mina okwu abu elikwɔ kye gbɛlu angwuto mgbi abu owoowo ongwi ifun yɔ, kye angwuto mgbi abu ongwi esɛ kpaa bankɛ ele. ");
INSERT INTO utr_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Kini inggisɛ si abu gbɛɛ ni abu kɛ afokyɛɛ onyi yan yɔ, kɛ yan afokyɛɛ efa. ");
INSERT INTO utr_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Inggisɛ nbɔ abu ungwɔ nun, dika fashi iyikpa tsɛ inggisɛ nmina ogbɛ mkpa mbi abu ba. ");
INSERT INTO utr_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","<<Ema teyi fwo a gbɔgbɛɛ, <Di inggisɛ nwotsuudɛ dɔ abu kpa abu itukwu yɛ di ongyikyili mgbi abu lanyi.> ");
INSERT INTO utr_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Nghaduu n nya ema: engyikyili mgbi ema nu ma kpa ema itukwu di bibɔ mi ikye ama nle nu ema isɔ, ");
INSERT INTO utr_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","adzi ni ema li engwɛ mgbi Otsema ongwi esho. O li nu onɔ mgban tsɛ emi obube yi emi osuse, di li kya mmbwo mbi emi osaan bɛyi emi ibwubwe kpaa. ");
INSERT INTO utr_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Kini ema tso okpitukwu mbi ama nkpa ema itukwu ta ma, li ali oyabɔ ema ka tu? Li ali ngwi ama ogbɛ udza ifyɛɛ kpaa li kyɔ daabaa? ");
INSERT INTO utr_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ni ema di ta engwunema ta angba ma, idzidza mgbi ema yi inggisɛ angbeka li ekyɛ? Li ngha ngwi ama o sunu Imgbasho ba kpaa li kyɔ daabawɛ? ");
INSERT INTO utr_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Wanɛ, dzɛ yɛyɛ na, dafi Otsema ongwi esho kpaa le yɛyɛ nɛni. ");
INSERT INTO utr_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","<<Gbɛwɛbyi ka kyɔ ali osuse mgbi ema mi inɛ inggisɛ ikyegbɛɛ nu ma di ema ba. Ni ema kyɔ ngha, ema ka tu umba mbi Otsema ndzɛ esho na ba. ");
INSERT INTO utr_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","<<Nghanɛ ni abu gha inggisɛ abubɔ umba yɔ, ka fo agba mi ele dafi emi ikpala li kyɔ mi ozu okwakye mgbi emi iJuda bɛyi ingɔfɛ ikye ni inggisɛ nu ma mmwɛ na ba. N nya ema otsitsi, a kyi gbɛlu umba mgbi ama ngyɛ wa. ");
INSERT INTO utr_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Ni abu gha inggisɛ abubɔ umba yɔ, ka nu abɔ abubɛ mgbi abu ye ungwɔ ngwi abugye le kyɔ ma ba. ");
INSERT INTO utr_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Ikye ni umba mgbi abu oghaagha no dzɛ mi odaada. Ta Otsabu, ongwu nli di mi odaada na, ka yilen kpa abu. ");
INSERT INTO utr_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","<<Ni ema di bibɔ yɔ, ka kyɔ dafi emi ikpala ba, lubana li kpa ma obibɔ kwuzunto mi ozu okwakye mgbi emi iJuda bɛyi mi okwokyiikwokyi mgbi ingɔfɛ ikye ni inggisɛ di ma. Ani nya ema otsitsi, a kyi gbɛlu umba mgbi ama ngyɛ wa. ");
INSERT INTO utr_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Yeba ni abu ka bibɔ yɔ, lu ifoozu mgbi abu, kye ofɛ tukwu man bibɔ mbi Otsabu, ngwu a li din ba nani. Ta Otsabu, nli di mi odaada na, ka nu abu umba. ");
INSERT INTO utr_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Nghaduu ni ema le bibɔ, ka kwondukwɔ dafi ama oye Imgbasho ba li kyɔ na ba, lubana a tsɛwɛ gbɛɛ li mi odzɛ mgbi ama ogbɔɔgbɔ kwuba ma ngwi a ka fwo ma aali. ");
INSERT INTO utr_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Ka dzɛ dafi ama ba na, lubana Otsema teyi ye ungwɔ ama ngwi ema mina duuse ema wa bɔn. ");
INSERT INTO utr_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","<<Nɛ, ka li ofɛ ngwi ema kale bibɔ aani: << <Otseyi ndzɛ esho, nu ma nu mmwɛ mi iyi mgbi abu, ");
INSERT INTO utr_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","esutɔ mgbi abu no ba, nu ma kyɔ owitukwu mgbi abu mi ɛsɛ nɛ dafi a li kyɔ mi esho mani. ");
INSERT INTO utr_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Nu eyi ungwogye mgbi eyi inɛ ongwi alegbe-alegbe. ");
INSERT INTO utr_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Dzɛ eyi ta yi obube mgbi eyi, dafi eyi kpaa li dzita ama nkyɔ eyi obube mani. ");
INSERT INTO utr_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Dika kye eyi kaka imbadi ba, kpaa dulu eyi tɔ mi abɔ inggisɛ obube.> ");
INSERT INTO utr_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Lubana ni ema dzata inggisɛ nkyɔ ema obube yɔ, Otsema ongwi esho kpaa ka dzata ema. ");
INSERT INTO utr_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Kpaa ni ema dzata inggisɛ yi obube bayɔ, Otsema kpaa ka dzata ema yi obube mgbi ema ba. ");
INSERT INTO utr_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","<<Alonɔ ngwi ema tukwondu yɔ, ka mbiinɛ ikye dafi emi ikpala li kyɔ na ba, bana a li mbiinɛ ikye otso inggisɛ gbɛɛ ama le tukwondu. N nya ema otsitsi a kyi gbɛlu umba mgbi ama ngyɛ wa. ");
INSERT INTO utr_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Nghaduu ni abu tukwondu yɔ, ngwunɛ di kye engyie juwo ikye. ");
INSERT INTO utr_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Ikye ni inggisɛ ka difwi gbɛɛ abu le tukwondu ba, kpaa no li mbi Otsabu kyoon, ongwu a li din ba; Otsabu nli di mi odaada na, ka kpa abu mkpa. ");
INSERT INTO utr_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","<<Ka kye aludu mgbi ema da mi ɛsɛ nɛ ba! Mi ɛsɛ nɛ ewa yi mnkpe ka mbelu ma, emumyi dika gbobu kaka kye yili. ");
INSERT INTO utr_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Kpaa kye aludu mgbi ema da mi esho, imbe ngwi ewa bɛyi mnkpe ka yagba mbe ba, ngwi emumyi kpaa ka yagba gbobu kaka kye yili ba nani. ");
INSERT INTO utr_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Bana li imbe ngwi aludu mgbi abu dzɛ ma ngwi itukwu mgbi abu kpaa li dzɛ aali. ");
INSERT INTO utr_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","<<Inɛ li osa mgbi ewo. Ni inɛ mgbi abu tishi, ewo mgbi abu duu ka mbwo yi osa. ");
INSERT INTO utr_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Kpaa ni inɛ mgbi abu tishi bayɔ, ewo mgbi abu duu ka mbwo yi iifu. Kini osa nwodzɛ mbi abu yifu yɔ, iifu na ka she saan! ");
INSERT INTO utr_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","<<Inggisɛ onyi ka kyɔ engyukwo efa idɔ ba. Kyayina o ka di oka lanyi, diyɛ di oka kpan itukwu, hona o ka nghao sunu oka di kwu oka shanyɛ. O ka yagba sunu Imgbasho yi awuya onɔ onyi ba. ");
INSERT INTO utr_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","<<Nghanɛ n nya ema, ka dzɛ yi okakewo mi oshishe mgbi ema mi ungwɔ ngwi ema ka gye hona wa naadi ewo mgbi ema mi ungwɔ ngwi ema ka wo ba. Oshishe dzɛ yi oyabɔ ngha ungwogye, ewo di dzɛ yi oyabɔ ngha angwuto baa? ");
INSERT INTO utr_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Di mbi ingwunɔ emi esho, a li kya naadi shɛ hona gbe da mi oba ba, nghaduu kpaa Otsema mi esho li nu ma ungwogye. Ema dzɛ yi oyabɔ ngha ma bana? ");
INSERT INTO utr_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Li ɛmɛ mbi ema mi itukwu ofeesho ka yagba ombwo ewon obyi onyi mi oshishe? ");
INSERT INTO utr_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","<<Nɛ kyɔsinɛ ngwi ema dzɛ yi okakewo mi odzɛ angwuto? Di onggaangga mgbi afutse dafi li she mani. A li kyidɔ naadi gbo angwuto ba. ");
INSERT INTO utr_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Nghaduu n nya ema gbɛɛ iSolomu yi okwɔkwɔ mgban duu kpaa wo angwuto kwɔ dafi onyi mbi afutse ntonɛ ba. ");
INSERT INTO utr_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Ni li ngha ngwi Imgbasho li to afutse nkwodzɛ mmɛnɛ inɛ ekeka a ka kye dzɛlu ngwuta wokɛ ola angwuto ma, kyɔsinɛse ngwi o ka nghao to ema angwuto ba? Ema ama oyɛyɛ sheema anyɛ nɛ? ");
INSERT INTO utr_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Nghanɛ ka dzɛ yi itukwu ofeesho gbɛɛ, <Li alungwɔ ngwi eyi ka gye?> Naadi <Li alungwɔ ngwi eyi ka wa?> Hona <Li alungwɔ ngwi eyi ka wo?> Ba. ");
INSERT INTO utr_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Lubana ama oye Imgbasho ba kpaa li le kyɛdɔ ungwɔ ntonɛni, kpaa Otsema ongwi esho ye gbɛɛ i wo ema yi ungwɔ ntonɛni. ");
INSERT INTO utr_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Tatase teyi pita esutɔ mgbi Imgbasho yi osaan mgban, ta ungwɔ ntonɛ duu a ka gbe bɛ ema kɛ ele. ");
INSERT INTO utr_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Dududu yɔ ka kye itukwu feesho mi ungwɔ ongwi ekeka ba, ni ekeka kye inɛ byi ewon. Alegbe dzɛ yi okakewo ngyɔ mi ikye ewon. ");
INSERT INTO utr_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","<<Ka fwikwɔ ba na, di ema kpaa a wa fwo ema ikwɔ. ");
INSERT INTO utr_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Lubana li mi itɔ ofɛ ngwi ema fwo angbeka ikwɔ ma, ngwi ema kpaa a ka fwo ema ikwɔ, di li itɔ ofɛ ngwi ema kye ofwo angbeka ikwɔ ma, ngwi a ka kye fwo ema ikwɔ aali. ");
INSERT INTO utr_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","<<Kyɔsinɛ ngwi abu di ofufu ekwɔ mi inɛ mbi ongwunabu kpaa ngwi abu gbɛwɛbyi otsokpla nwodzɛ inɛ mbi abu na ba? ");
INSERT INTO utr_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Ka kyɔsinɛse abu ka nya ongwunabu gbɛɛ, <Detse nin dulu abu ofufu ekwɔ mi inɛ,> ngwi alonɔ duu otsokpla wodzɛ inɛ mbi abu? ");
INSERT INTO utr_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Ema emi ikpala, ababɔ kyi dulu otsokpla nwodzɛ inɛ mbi abu, ta abu ka dinɛ saan odulu ofufu ekwɔ nwodzɛ inɛ mbi ongwunabu nani. ");
INSERT INTO utr_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","<<Ka kye ungwɔ nle saan nu obwe ba na, dika kye itagwude mgbi ema ngwuta la obyia ba, kini ema kyɔ ngha yɔ, a ka kye atafɔ tɔdɔ ma, di kyata kye ema kye nghalu ambulu-ambulu. ");
INSERT INTO utr_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","<<Bɔ ta a ka kye nu ema, pita ta ema ka tu, tsaabɔ ta a ka kwulu ema ofɛ. ");
INSERT INTO utr_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Bana ali inggisɛ nbɔ duu li gbɛ, inggisɛ npita li tu, inggisɛ ndi tsaabɔ, ofɛ ka kwulu mi ikye mgban. ");
INSERT INTO utr_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","<<Li emɛ mbi ema, kini ongwan bɔn ibredi, se o ka kye ikwutsɛ nun? ");
INSERT INTO utr_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Naadi kini o bɔn mmbweni, ngwi o ka kye ifa nun? ");
INSERT INTO utr_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Kini ema, ama nli obube, kpaa ye okye umba osuse nu engwɛ ema ma, ka kyɔsinɛse ngwi Otsema ongwi esho ka kye umba osuse nu ama nbɔn ba! ");
INSERT INTO utr_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Nghanɛ mi alungwɔ duu, kyɔ yi inggisɛ angbeka dafi ema mina gbɛɛ a ki kyɔ yi ema mani, bana li mi ungwɔnɛ ngwi Ola bɛyi emi Oyegbɔ kwulu ngwuo aani. ");
INSERT INTO utr_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","<<Kaka onufɛ ogalu okpenge. Lubana onufɛ ogalu otsɛɛ yi ofɛ ogbada-gbada li ofɛ olu imbe odzili-dzili, inggisɛ kwuba le nyɛ ele. ");
INSERT INTO utr_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Kpaa onufɛ ogalu ogyɛngyɛ yi ofɛ okpenge na le lu imbe oshishe, ma li inggisɛ gwee ta kpatsɛ ofɛ nani. ");
INSERT INTO utr_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","<<Gbɛwɛbyi oyegbɔ emi atsika. A li ba mbi ema kye okpa mmala tukwu ewo, kpaa mi idzidzɛ a li emi idukwlɛbɛ obube. ");
INSERT INTO utr_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Mi owawa mgbi ama ema ka difwi ma. Inggisɛ ka yagba shɛ mntsa mi olumu, naadi shɛ olumu mi ato gbɛɛ? ");
INSERT INTO utr_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Li ngha ngwi ekwɔ osuse duu li wa owawa osuse aali, kpaa ekwɔ obube yɔ li wa owawa obube. ");
INSERT INTO utr_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Ekwɔ osuse ka yagba wa owawa obube ba, ekwɔ obube dika wa owawa osuse gbɛ ba. ");
INSERT INTO utr_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Ali ekwɔ ta nwa owawa osuse bayɔ, a ka kye dzɛlu di kye ngwuta wokɛ ola. ");
INSERT INTO utr_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Nghanɛ, li mi owawa mgbi ama ngwi ema ka difwi ma. ");
INSERT INTO utr_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","<<Li ali inggisɛ nkwu ani gbɛɛ, <Otsɛ, Otsɛ,> ta ka kaka esutɔ mgbi Imgbasho ba, kpaa sede li ongwu nkyɔ mi itukwu mgbi Otsani ongwu ndzɛ esho nani. ");
INSERT INTO utr_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Inggisɛ kwuba ka nya ani mi egbe na gbɛɛ, <Otsɛ, Otsɛ, eyi yegbɔ mi iyi mgbi abu, di lɔ onodzi emɛsɛ onya tɔ di kyungwɔ ama okwulewo angbeka kwuba mi iyi mgbi abu baa?> ");
INSERT INTO utr_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Ta ani ka nya ma mi ododa gbɛɛ, <Ani ye ema ba. Lu enggengga na, ema emi ali ibwubwe ntonɛni!> ");
INSERT INTO utr_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","<<Nghanɛ ali inggisɛ nfwo elodzɛ mgbi ani ntonɛ di kyɔ mi ele dzɛ dafi inggisɛ okwiinɛ ngwu mbɛ ozu mgban mi ikye ikwutsɛ mani. ");
INSERT INTO utr_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Mmbwo kya, akpeni kyɛɛ, awo di fa tsɛkɛ ozu nani, nghaduu i yagba gbobu ba, ikyesinɛ a wo itan mi ikye ikwutsɛ. ");
INSERT INTO utr_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Nghaduu ali inggisɛ nfwo odzɛ mgbi ani ntonɛ di kyɔ mi ele bayɔ, o dzɛ dafi ikwangha inggisɛ ngwu mbɛ ozu mgban mi ikye mfyan mani. ");
INSERT INTO utr_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Mmbwo kya, akpeni kyɛɛ, awo di fa tsɛkɛ ozu nani, i yulu tukwu esɛ.>> ");
INSERT INTO utr_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Onɔ ngwi iYesu ngyɛlu ogbɔ ungwɔ ntonɛ nɛ, i kwulu ibyi inggisɛ ntona ewo mi otsootso mgban, ");
INSERT INTO utr_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","ikyesinɛ o tsungwɔ dafi inggisɛ ndzɛ yi mfye, li dafi mgbi etsetse mgbi ama, ama otso ola ba. ");
INSERT INTO utr_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Onɔ ngwi o tashulu mi ewunggwɔ nɛ, ibyi inggisɛ kyɛdɔn. ");
INSERT INTO utr_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Ongyulɔ ndzɛ yi otsoma ba wa kwonkɛ iyayi si nyan gbɛɛ, <<Otsɛ, ni abu gbela yɔ, o ka nu ani yɛɛ saan.>> ");
INSERT INTO utr_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","IYesu naabɔ gbon ewo nyan gbɛɛ, <<Ani gbela, yɛɛ saan.>> Plɛ nɛta otsoma mgban gbosa. ");
INSERT INTO utr_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Ta iYesu nyan gbɛɛ, <<Di gbɛɛ abu nya inggisɛ onyi kpaa ungwɔnɛ ba. Kpaa lu, ka kye ewabu tso mbi ama ofifɛ mgbi Imgbasho di nu umba ngwi iMose wo ema ola mani, otso obwɛndɛ mboma.>> ");
INSERT INTO utr_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Onɔ ngwi iYesu kaka iKapenahun nɛ, ongyukwo oblakwutsɛ ba mbon, wa mina oyabɔ. ");
INSERT INTO utr_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","O gbɛɛ, <<Otsɛ, ongbidɔ mgbi ani kwulu afɔ yi abɔ ladzɛ udɛ le gyadzɛ kpakpa.>> ");
INSERT INTO utr_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","IYesu nyan gbɛɛ, <<N ka kɛ ka ngyɛlun ootse.>> ");
INSERT INTO utr_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Ta ongyukwo oblakwutsɛ na si gbɛɛ, <<Otsɛ, ani mɛ abu ka kaka iwulu endu mgbi ani ba. Gbɔɔgbɔ odzɛ ta, ewo mgbi ongbidɔ mgbi ani sika ngyɛ. ");
INSERT INTO utr_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Lubana ani abuen li ongyulɔ nbyidzɛ abɔ mfye, yi ama oblakwutsɛ byito abɔ ani. Nin nya ongwunɛ gbɛɛ, <Lu>, O li lu, nin nya oka na gbɛɛ, <kwa!> O di li ba. Ani li gbɔ yi ongbidɔ mgbi ani gbɛɛ, <Kyungwɔnɛni!> O di li kyɔn.>> ");
INSERT INTO utr_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Onɔ ngwi iYesu fwo odzɛ nɛ nɛ, i kwulun ewo man o si gbɔ yi ama nkyɛdɔn ntona gbɛɛ, <<N nya ema otsitsi, ani tu inggisɛ onyi kpaa mi Israi yi itɔ oyɛyɛ onuunu okɔtɔndzi nɛ ye ba. ");
INSERT INTO utr_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","N nya ema gbɛɛ inggisɛ kwuba ka kyɛ mi onosa yi onɔdɛ ba, dika kwu imbe mgbi ama mi oga yi Abrahan, Adziki bɛyi iJeko mi esutɔ ongwi esho. ");
INSERT INTO utr_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Kpaa a ka lɔ ama esutɔ dzɛ ikye ma tasɛ lu iyifu, mi imbe ngwi ikwu otseetse yi aba ogyeegye ka dzɛ mani.>> ");
INSERT INTO utr_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Nɛ iYesu nya ongyukwo oblakwutsɛ na gbɛɛ, <<Lu! Ka dzɛ yɛyɛ dafi abu noyɛyɛ nani.>> Ta ootse ngyɛ lo ongbidɔ mgban na mi onɔ na yɛyɛ. ");
INSERT INTO utr_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Ngwi iYesu kaka udɛ iPyita nɛ, o di awo bwa onowa iPyita ladzɛ akwulo. ");
INSERT INTO utr_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","O kye abɔ gbon ta awo ngyɛ lon, o si kyato wita ogbe ungwogye to ma. ");
INSERT INTO utr_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Mi onɔnɔdɛ nɛ, a gbe inggisɛ kwuba ama esɛ dɔ ma ikye ba mbon, nɛ o lɔ onodzi ntona tɔ mi elodzɛ onyi ta di nu emi ootse duu yɛɛ saan. ");
INSERT INTO utr_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Nɛnɛ li ombwumbwo odzɛ ngwi oyegbɔ Adzaya tsekise gbɔn mani gbɛɛ: <<O kyi kyelu okakewo mgbi eyi di kyi kyelu ootse mgbi eyi duu.>> ");
INSERT INTO utr_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Ngwi iYesu di ibyi inggisɛ ntona to yan nɛ, o nondu gbɛɛ nu ma foye utɔ lu agya oka. ");
INSERT INTO utr_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Ta otsetse mgbi ola mgbi iMose oka ba mbon wa gbɛɛ, <<Otsetse, ani ka kyɛdɔ abu mi ali imbe ngwi abu le kɛ duu.>> ");
INSERT INTO utr_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","IYesu nyan gbɛɛ, <<Ogbalinya gbeka to yi ishɛ ingwunɔ emi esho kpaa to yi udɛ, nghaduu Ongwɛ Inggisɛ dzɛ yi imbe okye ikye da ba.>> ");
INSERT INTO utr_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Ongwafɔ oka nyan gbɛɛ, <<Otsɛ, ungwɔ ongwi ababɔ yɔ, detse nin ka kye Otsani ndzi se.>> ");
INSERT INTO utr_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Nghaduu iYesu nyan gbɛɛ, <<Kyɛdɔ ani, dzata emi ikwukwɔ nu ma ndzi ewoma.>> ");
INSERT INTO utr_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","IYesu si kaka uwaa man emi ongwafɔɔn kyɛdɔn. ");
INSERT INTO utr_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Vla nɛta, onikyɔ awo gbokyɛɛ mi utɔ nani, nghanɛ akpeni le kadu yaokɛ uwaa. Nghaduu iYesu le nuna. ");
INSERT INTO utr_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Emi ongwafɔɔn kɛ ka kyilen, nyan gbɛɛ, <<Otsɛ, dulu eyi tɔ! Di eyi le dzili!>> ");
INSERT INTO utr_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","O nya ma gbɛɛ, <<Ema ngwu oyɛyɛ onuunu mgbi ema shanyɛ nɛ, i kyɔsinɛ ema dzɛ yi imio kpakpa ngha?>> Ta o si kyato kyɔkyɔ yi awo bɛyi akpeni nani, i si kwulu tsiin. ");
INSERT INTO utr_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","I kwulu inggisɛ ntona ewo man a byita gbɛɛ, <<Nɛnɛ li ali itɔ inggisɛ dɛn? Ngwi awo yi akpeni kpaa li fwon!>> ");
INSERT INTO utr_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Ngwi iYesu foye dɔkɛ ayɛsɛ iGadarene nɛ, engyulɔ efa ama nto yi esɛ ikye tɔkyɛ imbe endzi wa tun. A sulu imoga ewo nghanɛ inggisɛ onyi kpaa li nyɛ ofɛ na ba. ");
INSERT INTO utr_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","A kweela gbɛɛ, <<Li alungwɔ wo abu yi eyi, Ongwɛ Imgbasho? Abu ba owa nu eyi isɔ duuse ni onɔ ma wa gyɔɔ?>> ");
INSERT INTO utr_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Ibyi obyia kwuto le gye ungwɔ, fyata yi ama gwee. ");
INSERT INTO utr_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Emɛsɛ ntona tɛkyɛ yi iYesu gbɛɛ, <<Kini abu lɔlu eyi tɔ yɔ, nu eyi ofɛ ni eyi ka kaka ibyi obyia ntonani.>> ");
INSERT INTO utr_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","IYesu nya ma gbɛɛ, <<Lu!>> Ta a si tɔ lu ka kaka ibyi obyia ntonani, man obyia ntona duu tsinya ka ngwuta mi agobo yaokɛ utɔ si kwulu mi eni. ");
INSERT INTO utr_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Ama ongyo obyia ntona si tsinya lu ka kaka igeli kye odzɛ nɛ gbɔfwɛ kpatsɛ duu yi ungwɔ nkyɔ yi engyulɔ ama nto yi esɛ ikye ntonani. ");
INSERT INTO utr_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Nɛ emi igeli na duu tasɛ ka tu iYesu. Ngwi a din nɛ, a tɛkyɛ yan gbɛɛ non lu dzata ayɛsɛ mgbi ama. ");
INSERT INTO utr_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","IYesu kaka uwaa, foye luba igeli mgban. ");
INSERT INTO utr_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Engyulɔ angbeka kye inggisɛ nkwulu afɔ yi abɔ ba mbon, ladzɛ amukwu. Ngwi iYesu di oyɛyɛ onuunu mgbi ama nɛ, o nya inggisɛ otummya na gbɛɛ, <<Ka teeyi ba, ongwani; a dzita abu yi ali ibwubwe.>> ");
INSERT INTO utr_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Mi ungwɔnɛ nɛ, etsetse mgbi ola mgbi iMose angbeka gbɔ yi ewoma gbɛɛ, <<Inggisɛ nɛ le fya Imgbasho ito!>> ");
INSERT INTO utr_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Ngwi iYesu ye ewodzɛ mgbi ama nɛ, o gbɛɛ, <<Kyɔsinɛ ngwi ema le tsɛwodzɛ ibwubwe mi itukwu nghaa? ");
INSERT INTO utr_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Li ole nghao sunɔ ba: li ogbɛɛ, <A dzita abu yi ali ibwubwe,> naadi ogbɛɛ, <Kyato kyikyɛ>? ");
INSERT INTO utr_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Kpaa li ikye ni ema ye gbɛɛ Ongwɛ Inggisɛ dzɛ yi mfye mi ɛsɛ nɛ odzɛ inggisɛ ta yi ali ibwubwe...>> Ta o nya inggisɛ ntummya ma gbɛɛ, <<Kyato, kye amukwu mgbi abu lu udɛ.>> ");
INSERT INTO utr_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Ongyulɔ ma si kyato lu udɛ. ");
INSERT INTO utr_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Ngwi ibyi inggisɛ ntona di ungwɔnɛ nɛ, imio wo ma; man a si tsɛ Imgbasho, ongwu nkye itɔ mfye na nu inggisɛ mani. ");
INSERT INTO utr_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Dafi iYesu dzata imbe na kiyayi nɛ, o di ongyulɔ ngwu a li kwun gbɛɛ iMatiu sɔdzɛ imbe mgbi ama ogbɛ udza ifyɛɛ. O nyan gbɛɛ <<Kyɛdɔ ani,>> ta iMatiu si kyato kyɛdɔn. ");
INSERT INTO utr_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Ngwi iYesu le gye oga ongwi onɔdɛ mi udɛ iMatiu nɛ, ama ogbɛ udza ifyɛɛ gwuba yi <<emi ali ibwubwe>> ba wa gye ungwogye yan bɛyi engwafɔɔn. ");
INSERT INTO utr_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Ngwi emi iFarasi di ungwɔnɛ nɛ, a byi engwafɔɔn gbɛɛ, <<Kyɔsinɛse otsetse mgbi ema le gye ungwogye yi ama ogbɛ udza ifyɛɛ bɛyi <emi ali ibwubwe>? >> ");
INSERT INTO utr_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Ngwi iYesu fwo odzɛ nɛ nɛ, o gbɛɛ, <<Inggisɛ ama nle saan mina inggisɛ obwe ootse ba, kpaa li ama ndotse ta. ");
INSERT INTO utr_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Nghaduu lu na ka kpayi ungwɔ ngwi odzɛ nɛ tso mani: <Ani mina elela odiidi, yama li ifɛ ofɛ-fɛ ba.> Ikyesinɛ ani ba owa kwu ama osaan ela ba, kpaa li emi ali ibwubwe.>> ");
INSERT INTO utr_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Nɛ engwafɔ iJɔn ba wa byi iYesu gbɛɛ, <<Kyɔsinɛ ngwi eyi yi emi iFarasi li tukwondu, kpaa engwafɔ abu li tukwondu ba?>> ");
INSERT INTO utr_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","IYesu nu uka gbɛɛ, <<Ka kyɔsinɛ ngwi ingyoga mgbi obongyaa ofufɛ ka kyelela ngwi o ka dzɛ yi ama? Onɔ ka wa ba ngwi a ka kyi kyelu obongyaa ofufɛ mboma; ta a ka tukwondu. ");
INSERT INTO utr_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","<<Inggisɛ onyi kpaa li kye ayɛ angwuto ofufɛ tukwu ishangli ba. Ikyesinɛ otukwu-tukwu na ka kwɔdzɛ vɔn. ");
INSERT INTO utr_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Naadi inggisɛ li kye eneekwɔ ofufɛ yaokɛ ikpɔkpɔ eneekwɔ ogbugbe kpaa ba. Kini otsungwɔ kyɔ ngha, ikpɔkpɔ na ka gbobu, eneekwɔ na ka yangwuta man ikpɔkpɔ na ka nyanya. Ei, a li kye eneekwɔ ofufɛ yaokɛ ikpɔkpɔ ofufɛ man ama duu ka nyanya ba.>> ");
INSERT INTO utr_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Dafi iYesu le gbɔdzɛ nɛ, ongye ogbe inggisɛ teyi ba wa gbe akwafɔ kwɛsɛ mi iyayi mbon si gbɛɛ, <<Ongwani ongwu ongyaa kuma kwulu ta aani. Nghaduu ba wa kye abɔ mgbi abu gbon, ta o ka dzɛ oshishe.>> ");
INSERT INTO utr_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","IYesu si kyato yi engwafɔɔn kɛ yan. ");
INSERT INTO utr_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Mi onɔ mata ongyaa nle yɛ eyi mɛ onova iwyodefa ba mi iyikpa mgbi iYesu wa kye abɔ gbon ondu angwuto. ");
INSERT INTO utr_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","O gbɔ yi ewon gbɛɛ, <<Ni ani kye abɔ gbon gbo-gbo angwuto kpata, ootse mgbi ani ka ngyɛ.>> ");
INSERT INTO utr_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","IYesu kyata din, si gbɛɛ, <<Fyumfye itukwu, ongwani; oyɛyɛ onuunu mgbi abu ngyɛlu abu ootse.>> Man ootse mgbi ongyaa na si ngyɛ mi onɔ nani. ");
INSERT INTO utr_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Ngwi iYesu kaka udɛ ongye ogbe inggisɛ teyi wa di ama ofo elete yi ibyi inggisɛ tole wulu nɛ, ");
INSERT INTO utr_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","o gbɛɛ, <<Lu enggengga na, ongwongyaa nɛ kwulu ba kpaa o le nanuna.>> A si shan isha. ");
INSERT INTO utr_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Ngwi a nu ibyi inggisɛ ntona tasɛ nɛ, iYesu kaka ifoozu ka byi ongwongyaa na mi abɔ, man o kyato. ");
INSERT INTO utr_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Odzɛ nɛ si gbɔfwɛ kpatsɛ ayɛsɛ na duu. ");
INSERT INTO utr_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Dafi iYesu dzata imbe na le lu nɛ, obinɛ nghi efa kyɛdɔn, le kweela gbɛɛ, <<Di eyi elela, Ongwɛ iDevedi!>> ");
INSERT INTO utr_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Ngwi o yɛ lu onufozu nɛ, obinɛ ntona si ba mbon, man o byi ma gbɛɛ, <<Ema noyɛyɛ gbɛɛ ani ka yagba kwulu ema inɛɛ?>> A gbɛɛ, <<Ɛɛn, Otsɛ.>> ");
INSERT INTO utr_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Nɛ o kye abɔ gbo ma inɛ si gbɛɛ, <<No kyɔ dafi oyɛyɛ onuunu mgbi ema dzɛ mani>> ");
INSERT INTO utr_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","ta inɛ mgbi ama kwulu. IYesu kwo ma adɔ kpɔklɔɔ gbɛɛ, <<Di gbɛɛ ema nu inggisɛ onyi ye odzɛ mi ungwɔnɛ ba na.>> ");
INSERT INTO utr_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Nghaduu a tasɛ ka kye odzɛ mgban gbɔ kpatsɛ ɛsɛ na duu. ");
INSERT INTO utr_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Ngwi iYesu yi engwafɔɔn le tasɛ nɛ, a kye inggisɛ ngwu onodzi ibwubwe bwan non yɛɛ ikplima ba mbon. ");
INSERT INTO utr_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","IYesu lɔ onodzi emɛsɛ na onya tɔ ta, inggisɛ ikplima na si gbɔdzɛ. I kwulu ibyi inggisɛ ntona ewo ta a gbɛɛ, <<Nkonyonyi itɔ nɛ kpaa kyɔ mi ɛsɛ Israi ye waba.>> ");
INSERT INTO utr_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Nghaduu emi iFarasi gbɛɛ, <<Li ongyukwo mgbi emɛsɛ nun mfye se ngwi o le dulu onodzi emɛsɛ tɔ aali.>> ");
INSERT INTO utr_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","IYesu kaka igeli yi agwudɛ duu le tsungwɔ mi ozu okwakye mgbi emi iJuda, le gbɔ Esɔ Osuse mgbi esutɔ dile ngyɛlu ali ootse yi ama ngwu i sisi loma ewo duu. ");
INSERT INTO utr_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Ngwi o di ibyi inggisɛ nɛ, elela kyɔn wo ma, ikyekyɛ a dzɛ yi okakewo di yɛɛ elela, inggisɛ ogbe ma teyi dzɛma ba, dafi mmala ndzɛ yi inggisɛ ongyo ma ba mani. ");
INSERT INTO utr_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Ta iYesu nya engwafɔɔn gbɛɛ, <<Etɔ oshɛ-shɛ le gwuba, kpaa emi idɔ le gwee ta. ");
INSERT INTO utr_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Bɔ Otsɛ mgbi etɔ oshɛ-shɛ no gbe emi idɔ ba okwɔ mgban.>> ");
INSERT INTO utr_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","IYesu kwu ama ogbikyon iwyodefa ntona ela ba mbon si kye mfye nu ma gbɛɛ nu ma lɔ onodzi ibwubwe onya di ngyɛlu ali inggisɛ ngwu i sisi lon ewo yi ali itɔ ootse duu. ");
INSERT INTO utr_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Nɛnɛ li iyi mgbi ama ogbikyon iwyodefa ma aani: Ababɔ li, iSaimɔn (ongwu a li kwun di iPyita nani) yi ongwunɔn Andru bɛyi iJɛnsi ongwɛ iDzebedi yi ongwunɔn iJɔn ");
INSERT INTO utr_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","bɛyi iFyilipi yi iBatlomi yi iTɔmɔsu yi iMatiu inggisɛ ogbɛ udza ifyɛɛ bɛyi iJɛnsi ongwɛ Alfeɔ yi iTedusu ");
INSERT INTO utr_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","yi iSaimɔn Ogbodami bɛyi iJuda iSkarɔti ongwu nkye iYesu gya nani. ");
INSERT INTO utr_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Emi iwyodefa ntonɛ iYesu dɔ ma esɔ wo ma ola ntonɛ gbɛɛ: <<Ka kɛ mbi Udzengye ba na dika kaka igeli mgbi emi iSamaria onyi ba. ");
INSERT INTO utr_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Kpaa kɛ mbi mmala mgbi emi Israi nbyulu mani. ");
INSERT INTO utr_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Ni ema kɛ yɔ, gbeesɔ nya ma gbɛɛ: <Esutɔ ongwi esho ma dzɛ kwɛkwɛ wa.> ");
INSERT INTO utr_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Ngyɛlu ama ndotse duu ootse, kyile emi ikwukwɔ, nu emi otsoma yɛɛ saan na, dulu onodzi emɛsɛ tɔ. Ema gbɛ ayayi, di kye nu ayayi na. ");
INSERT INTO utr_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Ka yama kye abashi naadi iyudza onyina-nyina naadi itigbla mi igbe mgbi ema ba; ");
INSERT INTO utr_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","ka kye igbe byi mi okyɛɛ nɛ ba, naadi angwuto oka hona okpafɔ naadi okwuta ba, ikyesinɛ inggisɛ idɔ mɛ ogye adzɛ mgban. ");
INSERT INTO utr_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","<<Ali igeli naadi agwudɛ ngwi ema kaka duu, pita inggisɛ ngwu mɛ di gbela ogbɛ ema dafi ingyoga mani, di dzɛ udan nghataa ni ema dzata imbe nani. ");
INSERT INTO utr_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Onɔ ngwi ema kaka udɛ yɔ, kye angba kwu ma. ");
INSERT INTO utr_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Ni udɛ ma gbɛ ema yɔ, ni iyu mgbi ema tila mi ele; non gbɛ ema bayɔ, iyu mgbi ema no yɛ lu mbi ema. ");
INSERT INTO utr_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Ni inggisɛ onyi gbɛ ema naadi fwo elodzɛ mgbi ema bayɔ, gbolu onbulu mi afɔ mi onɔ ngwi ema dzata udɛ na hona igeli na mani. ");
INSERT INTO utr_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","N nya ema otsitsi, ka tatase lo iSodon yi iGomora mi egbe ikwɔ ma ngha igeli nani. ");
INSERT INTO utr_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Ani le dɔ ema esɔ tasɛ dafi mmala mi idzidzɛ emi idukwlɛbɛ mani. Nghanɛ kwiinɛ dafi ifa dika dzɛ yi obube ba dafi anyama mani. ");
INSERT INTO utr_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","<<Gbɛwɛbyi inggisɛ na, a ka gbe ema wo ama ogbiikwɔ abɔ di gbo ema ibe mi ozu okwakye mgbi ama. ");
INSERT INTO utr_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Ikye odzɛ mgbi ani, a ka gbe ema ba wa kyɔ obwɛndɛ inai emi iGɔna yi emi utɔ bɛyi mbi emi Agwɛsɛ. ");
INSERT INTO utr_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Kpaa onɔ ngwi a bwa ema ma, ka teeyi mi odzɛ ngwi ema ka gbɔ naadi dafi ema ka gbɔn ba. Mi onɔ na Imgbasho ka nu ema elodzɛ ngwi ema ka gbɔ mani. ");
INSERT INTO utr_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Ikyekyɛ li ema kale gbɔdzɛ ba, kpaa li Onodzi mgbi Otsema kale gbɔdzɛ nyɛ mbi ema. ");
INSERT INTO utr_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","<<Inggisɛ ka kye ongwunɔn nu mi abɔ ikwongye nu ma ngwɔn, otsɔngwɛ kpaa dika kyɔ ngha yi ongwan; ɛngbɛ ka kye afɔ twɛɛsɛ yi otsɔma di nu ma tu ikwongye. ");
INSERT INTO utr_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Inggisɛ duu ka di ema taanyi mi ikye ani, nghaduu inggisɛ nkwulɛsɛ kpɔklɔɔ ka dondu ma ka watɔ. ");
INSERT INTO utr_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Ni a nu ema adzɛ mi imbe oka yɔ, tsinya lu imbe oka. N nya ema otsitsi, ema ka kpatsɛ ogalu ama nto ɛsɛ Israi duu bata Ongwɛ Inggisɛ ka yɛ. ");
INSERT INTO utr_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","<<Inggisɛ okpayi ungwɔ li ngha otsetse mgban ba, hona ongbidɔ li ngha ongyukwo mgban ba. ");
INSERT INTO utr_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Ni inggisɛ okpayi ungwɔ wa yɛɛ dafi otsetse mgban yɔ, i gyɔ, ni ongbidɔ kpaa wa yɛɛ dafi ongyukwo mgban yɔ, i gyɔ. Ni otsungwudɛ kpaa a kwun gbɛɛ iBɛdzɛbu ma, emidan ma a ka kwu ma sinɛ tsatso! ");
INSERT INTO utr_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","<<Nghanɛ ka mio ma ba. Ungwɔ onyi ngwi a kye tukwu se ngwi a ka kye dɛsɛ ba dzɛma ba, naadi kye da ngwi a ka nu ma ye ba dzɛma ba. ");
INSERT INTO utr_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Ungwɔ ngwi ani nya ema mi iyifu ma, gbɔn mi osa na; ungwɔ ngwi ani di nya ema mi odaada yɔ, dɔkɛ ikyendu gbɔn tasɛ na. ");
INSERT INTO utr_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Ka mio ama nka ngwɔ ikpewo kpaa ka yagba ngwɔ oshishe ba na ba. Tatase, mio ongwu nka dzili oshishe bɛyi ikpewo mi udola nani. ");
INSERT INTO utr_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","A li kye ifyilo efa gya mi anini onyi baa? Nghaduu onyi mboma kpaa ka ngwuta ba esɛ ba sede li mi oweka mgbi Otsema. ");
INSERT INTO utr_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Alotu mi ikye mgbi ema duu a ye umbwon. ");
INSERT INTO utr_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Nghanɛ ka wimio ba; ema dzɛ yi oyabɔ ngha ifyilo. ");
INSERT INTO utr_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","<<Ali inggisɛ ngbela ani mi inɛ inggisɛ yɔ, ani kpaa ka gbelan mi inɛ Otsani ndzɛ esho nani. ");
INSERT INTO utr_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Nghaduu ali inggisɛ nfwa ani mi inɛ inggisɛ yɔ, ani kpaa ka tangwan mi inɛ Otsani ndzɛ esho nani. ");
INSERT INTO utr_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","<<Ema tsɛwɛ gbɛɛ ani ba owa kye iyu ba ɛsɛɛ? Ani ba yi iyu ba, kpaa li okwusunkli. ");
INSERT INTO utr_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Ani ba owa kyata << <ongyulɔ yile afɔ twɛsɛ yi otsɔn, ongwongyaa oyile afɔ twɛsɛ yi onɔn owongwɛ ka kye iga fyi yi onoban ");
INSERT INTO utr_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","engyikyili mgbi inggisɛ ka li mi etɔ mgban.> ");
INSERT INTO utr_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","<<Ali inggisɛ ngwu otsɔn naadi onɔn kpan itukwu ngha ani yɔ, o mɛ oli ongwafɔ mgbi ani ba; ali inggisɛ ngwu ongwan ongyulɔ naadi ongyaa kpan itukwu ngha ani yɔ, o mɛ oli ongwafɔ mgbi ani ba; ");
INSERT INTO utr_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","ali inggisɛ ndi kye ekwatsi mgban kyɛdɔ ani bayɔ, o mɛ oli ongwafɔ mgbi ani ba. ");
INSERT INTO utr_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Ali inggisɛ nfya odulu oshishe mgban tɔ, oshishe na ka byulu lon, inggisɛ ngwu oshishe mgban byulu lon mi ikye ani ma ka tun. ");
INSERT INTO utr_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","<<Inggisɛ ngbɛ ema yɔ gbɛ ani, ongwu ndi gbɛ ani gbɛ ongwu ndɔ ani esɔ mani. ");
INSERT INTO utr_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Ali inggisɛ ngbɛ oyegbɔ ikyegbɛɛ o li oyegbɔ yɔ, ka gbɛ umba mgbi oyegbɔ, inggisɛ ndi gbɛ inggisɛ nle saan ikyegbɛɛ o le saan yɔ, ka gbɛ umba mgbi inggisɛ nle saan. ");
INSERT INTO utr_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ma ni inggisɛ kye eni oyuyu mi ibwɛ kpata kye nu onyi mbi ɛngbɛ ama oshilɛlɛ ntonɛ ikyegbɛɛ o li ongwafɔ mgbi ani yɔ, n nya ema otsitsi, umba mgban ka yama byulu lon ba duudu.>> ");
INSERT INTO utr_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Ngwi iYesu ngyɛlu owo ama ogbyikyon iwyodefa ola nɛ, o dzata imbe na lu le tsungwɔ dile gbeesɔ mi igeli emi iGalalia. ");
INSERT INTO utr_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Dafi iJɔn fwo mi obawi ungwɔ ngwi iYesu le kyɔ nɛ, o dɔ engwafɔ mgban esɔ ");
INSERT INTO utr_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","oka byi iYesu gbɛɛ, <<Abu li ongwu nka ba ma naadi ni eyi kye inɛ byi inggisɛ oka idzidza?>> ");
INSERT INTO utr_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","IYesu nu uka gbɛɛ, <<Yɛ lu ka nya iJɔn ungwɔ ngwi ema fwo diyɛ di nɛni: ");
INSERT INTO utr_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Ama nbinɛ le di, ama ntummya le kyikyɛ, ama ndzɛ yi otsoma, otsoma le ngyɛ loma, ama nkyadɔ le fwo, emi ikwukwɔ le kyɛɛ luba oshishe, a di gbɔ Esɔ Osuse nya emi adzɛ. ");
INSERT INTO utr_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Imgbasho ka kye mse bɛ ali inggisɛ nfwa ani ba duu ewo mi ikye ungwɔ ngwi ani le kyɔ nɛni.>> ");
INSERT INTO utr_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Dafi engwafɔ iJɔn le lu nɛ, iYesu si wita ogbɔdzɛ mgbi iJɔn nya inggisɛ ntona gbɛɛ: <<Li ekyɛ ngwi ema kɛ okwɛsɛ le ka di? Li atakwu ngwi awo le fan maa? ");
INSERT INTO utr_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Ni li ngha ba ma, li ekyɛ ngwi ema tasɛ le ka di? Li inggisɛ nwo angwuto osusee? Ei, ama nwo angwuto osuse to udɛ emi utɔ ma. ");
INSERT INTO utr_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Nɛ li ekyɛ ngwi ema tasɛ oka di? Li oyegbɔɔ? Ɛɛn, n nya ema, o nghaangha oyegbɔ. ");
INSERT INTO utr_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Nɛnɛ li ongwu a lɔ mi ikyen gbɛɛ: << <N ka dɔ ongyesɔ mgbi ani teyi abu, nka teyi ka mɛ abu ofɛ.> ");
INSERT INTO utr_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","N nya ema otsitsi: Mi idzidzɛ ama ngwu engyaa mba mi ɛsɛ nɛ duu, inggisɛ onyi kpaa shewo ngha iJɔn okyɔ iBatisima ba; nghaduu ongwu n yɛyikpa mi esutɔ ongwi esho ma, shewo nghan. ");
INSERT INTO utr_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Kyɛ mi egbe mgbi iJɔn okyɔ iBatisima nghataa ba onɛnɛni, esutɔ ongwi esho gyadzɛ mi anglama, emi anglama di kye gbɛlu mi oglijo. ");
INSERT INTO utr_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Ikyesinɛ Oyegbɔ duu yi Ola mgbi iMose yegbɔ nghataa ba onɔ mgbi iJɔn nani. ");
INSERT INTO utr_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ma ni ema dzɛ yi oweka ogbela yɔ, o li Elaija ongwu nkika ba mani. ");
INSERT INTO utr_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Inggisɛ ndzɛ yi adɔ yɔ, no fwo. ");
INSERT INTO utr_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","<<Li ekyɛ ngwi ani ka kye inggisɛ ongwu onɛnɛ mba yan? A to dafi ɛngbɛ sɔto mi ifyidu dile kwu angbeka ela gbɛɛ: ");
INSERT INTO utr_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","<< <Eyi fo oca mi ikye ema kpaa ema shufwe ba, eyi shashi ibɔ kpaa, ema tsukwu ba.> ");
INSERT INTO utr_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Lubana iJɔn ba le gye naadi le wa ba, nɛ a gbɛɛ, <O dzɛ yi onodzi emɛsɛ.> ");
INSERT INTO utr_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Ongwɛ Inggisɛ ba le gye dile wa, nɛ a gbɛɛ, <Inggisɛ nɛ li inggisɛ okyɔ nggwɔ di fyɛbyɛ, uka mgbi ama ogbɛ udza ifyɛɛ yi <<emi ali ibwubwe.>> > Kpaa ozoyeye tso tɔ yɛyɛ mi okyɔɔkyɔ mgban.>> ");
INSERT INTO utr_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Nɛ iYesu wita ogbɔdzɛ agya yi ogalu ama ngwi ongwu kyungwɔ okwulewo angbeka mi efu mani, ikyekyɛ a kyatitukwu ba. ");
INSERT INTO utr_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","<<Ahoo ikye abu, iKoradzin! Ahoo ikye abu, iBɛtsaida! Ni ungwɔ okwulewo ngwi a kyɔ mbi abu na ki li mi iTiru yi iSidon ngwi a kyɔn yɔ, a ki kyatitukwu gbegbe gbe ishangli wo ewo di mwa utɔ tukwu ewo. ");
INSERT INTO utr_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Kpaa n nya ema Imgbasho ka di iTiru yi iSidon elela ngha ema mi egbe ikwɔ mani. ");
INSERT INTO utr_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Ma abu, iKapenahun, a ka kyile abu esho wɛ? Ei, abu ka lu esɛ mi udola. Ungwɔ okwulewo ngwi a kyɔ mbi abu na, ki li mi iSodon yɔ, kika tila dzɛ nghataa ba inɛ. ");
INSERT INTO utr_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Nghaduu n nya ema gbɛɛ Imgbasho ka nghao di iSodon elela ngha abu mi egbe ikwɔ mani.>> ");
INSERT INTO utr_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Mi onɔ na iYesu gbɛɛ, <<Ani tsɛ abu, Otsani, Otsɛ mgbi esho yi esɛ, ikyekyɛ abu kye ungwɔ ntonɛ da ama oyodzɛ yi ama okpayi afɛ, di kye ma tso ɛngbɛ ama oshilɛlɛ. ");
INSERT INTO utr_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ɛɛn, Otsɔ, li ngha ngwi abu mina gbɛɛ no dzɛ aali. ");
INSERT INTO utr_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","<<Alungwɔ duu Otsani kye wo ani abɔ. Inggisɛ onyi kpaa ye Ongwɛ ba li Otsɔn ta, inggisɛ onyi kpaa di ye Otsɔngwɛ ba se li Ongwɛ ta bɛyi ama ngwu Ongwɛ sadu okyon tso ma mani. ");
INSERT INTO utr_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","<<Ba mbi ani na, ema ama ngwu ndɛ ngwi okye di lo ema mani, ta n ka nu ema onya. ");
INSERT INTO utr_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Kyelu onogblo mgbi ani di kpayi mbi ani na, ikyena ani le dumɔɔ di yile ewo esɛ mi itukwu, ta ema ka tu onya mi oshishe mgbi ema. ");
INSERT INTO utr_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Ikyekyɛ onogblo mgbi ani sunɔ ba, okye mgbi ani kpaa le pee.>> ");
INSERT INTO utr_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Mi onɔ na emi iYesu kyikyɛ nyɛ okwɔ ungwogyowe. Enbwa dɔ engwafɔɔn ta a sile wulɔ ekwu le ngwunu bukwu. ");
INSERT INTO utr_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Ngwi emi iFarasi di ungwɔnɛ nɛ, a nyan gbɛɛ, <<Dii! Engwafɔ mgbi abu le kyungwɔ nli ola ba mi egbe otonyewo.>> ");
INSERT INTO utr_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","IYesu nu ma uka gbɛɛ, <<Ema gbɔ ungwɔ ngwi utɔ iDevedi kyɔ mi onɔ ngwi ongwu bɛyi ama nkyɛ yan ngwi enbwa dɔ ma na ye wa lo? ");
INSERT INTO utr_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","O ka kaka ozu Imgbasho, kyi kyelu ibredi ongwi a kye nu Imgbasho umba, nli ola gbɛɛ se li ama ofifɛ mgbi Imgbasho ta ka gye mani. Kye gye di kye nu ama nkyɛ yan ma duu. ");
INSERT INTO utr_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Naadi ema gbɔ mi afɛ mgbi ola gbɛɛ mi egbe otonyewo ama ofifɛ mi ozu okwukwo osunu Imgbasho mi iJerosalin li kyidɔ kpaa ola li kye wuuta ba lo? ");
INSERT INTO utr_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","N nya ema ongwu nshewo ngha ozu okwukwo osunu Imgbasho mi iJerosalin na dzɛ mmɛnɛni. ");
INSERT INTO utr_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Ni ema ki ye itɔ elodzɛ ngbɛɛ, <N mina elela odiidi, yama li ifɛ ofɛ-fɛ ba,> na yɔ, ema kika ngwɔ emi emyɛmyɛ ikwɔ ba. ");
INSERT INTO utr_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Ikyena Ongwɛ Inggisɛ li Otsɛ mgbi egbe otonyewo.>> ");
INSERT INTO utr_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","IYesu dzita imbe na lu ka kaka ozu okwakye mgbi ama, ");
INSERT INTO utr_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","nɛ inggisɛ nwaawaa abɔ dzɛ imbe nani. Ngwi a le pita itɔdzɛ okye abɔ byi efu dulu ongwufabɔ mbi iYesu nɛ, a byun gbɛɛ, <<Li ola ongyɛlu inggisɛ ootse mi egbe otonyewoo?>> ");
INSERT INTO utr_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","IYesu nya ma gbɛɛ, <<Kini inggisɛ mgbi ema onyi dzɛ yi mmala, ma i gbɛsɛ wokɛ ishɛ mi egbe otonyewo ma, o ka dulun tɔ lo? ");
INSERT INTO utr_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Nghanɛ inggisɛ nghao dzɛ yi oyabɔ ngha mmala! Li ola okyɔ osuse mi egbe otonyewo.>> ");
INSERT INTO utr_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Ta o nya inggisɛ na gbɛɛ, <<Na abɔ mgbi abu.>> Nɛ o na abɔ man i yɛɛ saan dafi oka nani. ");
INSERT INTO utr_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Kpaa emi iFarasi tasɛ le ka tsɛwɛ dafi ama ka ngwɔ iYesu mani. ");
INSERT INTO utr_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Ngwi iYesu difwi ungwɔnɛ nɛ, o dzata imbe nani. Ibyi inggisɛ kyɛdɔn, o di ngyɛlu ama nto yi ootse duu ootse, ");
INSERT INTO utr_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","wo ma ola gbɛɛ nu ma ka gbɔdzɛ mgbi ongwu nya inggisɛ onyi ba. ");
INSERT INTO utr_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Ungwɔnɛ li ombwumbwo odzɛ ntɔ ikpewo oyegbɔ Adzaya mani gbɛɛ, ");
INSERT INTO utr_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","<<Nɛnɛ li ongbidɔ mgbi ani ngwu ani dulun, o kpa ani itukwu, n di dzɛ yi atsa yan; n kye Onodzi mgbi ani wokɛ mbon, o dika gbɔ otsitsi nya ɛsɛ. ");
INSERT INTO utr_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","O ka shɔdzɛ hona feela ba; inggisɛ onyi kpaa ka fwo ela mgban mi ingɔfɛ ba. ");
INSERT INTO utr_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","O ka gbikye engga nklɛ ba, naadi andɛkwɔ nle diwu ma kpaa, o ka myunun ba, nghataa ngwi o ka nu emyɛmyɛ fwi tɔ. ");
INSERT INTO utr_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Mi iyi mgban ɛsɛ duu ka gbɛwɛbyi.>> ");
INSERT INTO utr_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Ta a kye inggisɛ ngwu esɛ dɔn ikye binɛ di li ikplima ba mbi iYesu, nɛ iYesu ngyɛlun ootse, man o gbɔdzɛ yɛ di. ");
INSERT INTO utr_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","I kwulu inggisɛ ntona duu ewo, a si gbɛɛ, <<Nɛnɛ ka li Ongwɛ iDevedi ma hoo?>> ");
INSERT INTO utr_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Kpaa ngwi emi iFarasi fwo odzɛ nɛ mata, a si gbɛɛ, <<Li mi mfye mgbi iBɛdzɛbu utɔ emɛsɛ ta, ngwi inggisɛ nɛ lɔ onodzi emɛsɛ onya tɔ aali.>> ");
INSERT INTO utr_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","IYesu ye ewodzɛ mgbi ama, nɛ o gbɛɛ, <<Ali esutɔ n gha yi ewon ka bulu, ali ogalu hona etɔ ndi gha yi ewon ka yagba kwudzɛ ba. ");
INSERT INTO utr_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Ni iSatan lɔ iSatan onya tɔ, o gha yi ewon. Nghanɛ ka kyɔnɛse esutɔ mgban ka kwudzɛ? ");
INSERT INTO utr_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Nɛ ni ani lɔ onodzi emɛsɛ tɔ mi mfye mgbi iBɛdzɛbu ma, emidema ma, li lɔ mi ali mfye? Ngyɛse li ama ka fwo ema ikwɔ. ");
INSERT INTO utr_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Kpaa ni ani lɔ onodzi emɛsɛ tɔ mi Onodzi mgbi Imgbasho yɔ, esutɔ mgbi Imgbasho ba mbi ema sewaani. ");
INSERT INTO utr_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","<<Naadi inggisɛ ka kyɔsinɛ ka kaka udɛ inggisɛ ɛnɛpɛ gbelun okye gbɛ, sede o ka bwa inggisɛ ɛnɛpɛ na adi baa? Duuse o ka gben okye. ");
INSERT INTO utr_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","<<Ongye ndzɛ yi ani bayɔ, kye afɔ twɛsɛ yi ani. Ongwu ndi gbe ngwikwo yi ani ba le bulu-bulu. ");
INSERT INTO utr_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Nghanɛ n nya ema, alobube yi ito duu, a ka kye to inggisɛ mkpa, kpaa ito ofya Onodzi yɔ, a ka yama kye to inggisɛ mkpa ba. ");
INSERT INTO utr_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Ali inggisɛ ngbɔdzɛ mi ikpewo Ongwɛ Inggisɛ duu, a ka dzanta yi obube. Kpaa ongwu ngbɔdzɛ mi ikpewo Onodzi Osaan yɔ, a ka yama dzanta yi obube ba, mi onɔ ongwi onɛnɛ yi onɔ ongwi iyayi kpaa. ");
INSERT INTO utr_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","<<Ekwɔ osuse li wa owawa osuse, ekwɔ obube di li wa owawa obube. A li difwi ekwɔ mi owawa mgban. ");
INSERT INTO utr_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Ema emi ongwɛ ogidzi ntonɛ, ka kyɔsinɛ ngwi ema nli ibwubwe nɛ ka gbɔdzɛ osuse? Bana ewodzɛ ongwi itukwu li fwi tɔ mi ondu. ");
INSERT INTO utr_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Inggisɛ osuse li tɔ yi ewodzɛ osuse mi itukwu mgban, inggisɛ obube di li tɔ yi ewodzɛ obube mi itukwu mgban. ");
INSERT INTO utr_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Nghaduu n le nya ema gbɛɛ ali inggisɛ duu ka nu uka mi ali elodzɛ onbwaa ngwi a gbɔ ma mi egbe ikwɔ. ");
INSERT INTO utr_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Bana mi elodzɛ mgbi abu o ka gye emyɛmyɛ, mi elodzɛ mgbi abu, a dika ngwɔ abu ikwɔ.>> ");
INSERT INTO utr_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Nɛta emi iFarasi angbeka yi etsetse mgbi ola nyan gbɛɛ, <<Otsetse, eyi mina odi ambɛ okwulewo mbi abu.>> ");
INSERT INTO utr_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","O nu uka gbɛɛ, <<Etɔ imbali yi etɔ amah li byita ambɛ okwulewo! Kpaa a ka nun onyi ba sede li ambɛ mgbi oyegbɔ iJona ta. ");
INSERT INTO utr_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Dafi iJona nose la ifu mmbweni okwukwo egbe eta na, li ngha ngwi Ongwɛ Inggisɛ ka la mi ikpɛsɛ egbe eta aali. ");
INSERT INTO utr_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Emi iNinive ka kyato mi egbe ikwɔ yi etɔ nɛ di ngwɔ ma ikwɔ; ikyesinɛ a kyatitukwu mi esɔ ogbɔɔgbɔ mgbi iJona, ma onɛnɛ ongwu nshewo ngha iJona dzɛ mmɛnɛni. ");
INSERT INTO utr_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Apodza ongwi agwudu ka kyato mi egbe ikwɔ yi etɔ nɛ di ngwɔ ma ikwɔ; ikyena o tɔkyɛ imbe ngwi ɛsɛ dondu owa fwo ozoyeye mgbi iSolomu, ma onɛnɛ ongwu nshewo ngha iSolomu dzɛ mmɛnɛni. ");
INSERT INTO utr_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","<<Onɔ ngwi onodzi obube tɔ mbi inggisɛ ma, o li le ga mi imbe ongwɔngwɔ le pita imbe ngwi o ka tonya, kpaa non ka tu bayɔ, ");
INSERT INTO utr_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","o si li gbɛɛ, <N ka yidɔ lu imbe mgbɛn ogbugbe.> Ni o yɛ wa to, di ozu na la ayayi, a fyan di kye mɛlu saan yɔ. ");
INSERT INTO utr_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","O ka yɛ lu ka gbe angbeka ntimbali ngha ongwu nghi egyafa, man a ka ba wa sɔkɛ ele. Nghanɛ odzɛɛdzɛ mgbi inggisɛ na li timbi nghaabɔ ogbugbe. Li ngha nka dzɛ yi etɔ imbali nɛ aali.>> ");
INSERT INTO utr_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Ngwi iYesu kale gbɔdzɛ yi ibyi inggisɛ nɛ, onɔn yi engwunɔn kwudzɛ to esɛ, le mina ogbɔdzɛ yan.  ");
INSERT INTO utr_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Inggisɛ oka nyan gbɛɛ, <<Onabu yi engwunabu to esɛ, a mina ogbɔdzɛ yi abu.>> ");
INSERT INTO utr_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","IYesu byita gbɛɛ, <<Li emɛ li onani, di li ele li emi ongwunani?>> ");
INSERT INTO utr_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","O tso abɔ mbi engwafɔɔn si gbɛɛ, <<Li onani yi engwunani aani. ");
INSERT INTO utr_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Bana ali inggisɛ nkyɔ mi oweka mgbi Otsani ongwi esho yɔ, o li ongwunani ongwu ongyulɔ yi ongyaa bɛyi onani.>> ");
INSERT INTO utr_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Mi egbe na kpɔɔ iYesu tasɛ mi ozu dika sɔkɛ onduutɔ. ");
INSERT INTO utr_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Ibyi inggisɛ kwuba kwutokɛ yan nɛ o kaka ka sisɛ mi ifu uwaa, ta inggisɛ angbeka duu tokɛ agobo. ");
INSERT INTO utr_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Nghanɛ o gbɔdzɛ kwuba yi ama mi itaodzɛ gbɛɛ: <<Inggisɛ okwɔ tasɛ oka fwe etɔ mgban. ");
INSERT INTO utr_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Dafi o le fwe etɔ nɛ, angbeka yangwuta mi ofɛ, man ingwunɔ ba wa kyi salu gye. ");
INSERT INTO utr_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Angbeka yangwuta mi imbe akwutsɛ, mi imbe ngwi ekyɛ le kwuba ba. I lumbye vla, ikyekyɛ ekyɛ she mi ele ba. ");
INSERT INTO utr_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Kpaa ngwi onɔ wa tsɛ nɛ, ungwogye ntona ndzili, ikyekyɛ a taakpa ba. ");
INSERT INTO utr_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Etɔ angbeka yangwuta mi ato, ato she yi ama nu ma gbufyo. ");
INSERT INTO utr_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Etɔ angbeka kpɔɔ di yangwuta mi ekyɛ osuse wa owawa ngha ongwu a teyi kya ma akpe ideli, ngwuseta naadi osudiwyo. ");
INSERT INTO utr_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Inggisɛ ndzɛ yi adɔ yɔ, no fwo.>> ");
INSERT INTO utr_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Ta engwafɔ mgban ba mbon wa byita gbɛɛ, <<Kyɔnɛse ngwi abu le gbɔdzɛ yi inggisɛ mi itaodzɛ nghaa?>> ");
INSERT INTO utr_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","IYesu nu uka gbɛɛ, <<Ozoyeye mgbi ungwɔ ama odaada mgbi esutɔ ongwi esho ma, a kye nu ema, kpaa ama yɔ, a kye nu ma ba. ");
INSERT INTO utr_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Ali inggisɛ ndzɛyan yɔ, a ka mbwon mmbwo o dika dzɛyan kpakpa. Kpaa ali inggisɛ ndzɛ yi ungwɔ bayɔ, ogyɛngyɛ ngwi o dzɛyan ma kpaa a ka kye gbɛlu mbon. ");
INSERT INTO utr_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Li ikyengha ngwi ani le gbɔdzɛ yi ama mi itaodzɛ aali, <<Bana a le di, kpaa a le difwi ba; a dile fwo kpaa, le gbosa loma ba. ");
INSERT INTO utr_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Ungwɔ ntonɛ mbwumbwo odzɛ ngwi oyegbɔ Adzaya gbɔ ma yɛyɛ gbɛɛ, << <Ema kale fwo kpaa ka yama gbosa lo ema ba; Ema kale di kpaa ema ka yama difwi ba. ");
INSERT INTO utr_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Bana itukwu mgbi inggisɛ ntonɛ tiishu, li fyima mfye ofwo mi adɔ mgbi ama kpaa, a di kye inɛ mgbi ama kpaa tukwu. Bana a ki di mi inɛ, di fwo mi adɔ, di difwi mi itukwu mgbi ama, di kyata yɔ, ani kika ngyɛlu ma ootse.> ");
INSERT INTO utr_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Nghaduu mse dzɛ yi ema ikyekyɛ inɛ mgbi ema di, adɔ mgbi ema di fwo. ");
INSERT INTO utr_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Bana n nya ema otsitsi, i mina oyegbɔ kwuba bɛyi inggisɛ ama osaan odi ungwɔ ama ema di nɛ, kpaa a di ba, odi nu ma fwo ungwɔ ngwi ema fwo ntonɛ kpaa, a fwo ba. ");
INSERT INTO utr_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","<<Nghanɛ gadɔ mi ungwɔ ngwi itaodzɛ mgbi inggisɛ ofwe etɔ nɛ tso mani: ");
INSERT INTO utr_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Mi onɔ ngwi inggisɛ fwo esɔ mgbi esutɔ ma di difwi bayɔ, olodu li ba wa lafwa ungwɔ ngwi a kye kya mbon mani. Nɛnɛ li etɔ ngwi a fwe mi ondoofɛ ma aani. ");
INSERT INTO utr_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Ongwu ngbɛ etɔ n yangwuta mi imbe akwutsɛ ma li inggisɛ nfwo elodzɛ na di gban vla yi atsa. ");
INSERT INTO utr_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Kpaa ngwi o dzɛ yi akpa bayɔ, o la mi ongwonɔ gwee ta. Ngwi okakewo hona adzɛ ba mi ikye elodzɛ na man, o gbɛsɛ vla. ");
INSERT INTO utr_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Ongwu ngbɛ etɔ ama n yangwuta mi ifu ato ma li inggisɛ nfwo elodzɛ na kpaa okakewo ongwi ɛsɛ nɛ bɛyi okpagyewo mgbi awuya loka wo elodzɛ na, non wa owawa wuba. ");
INSERT INTO utr_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Nghaduu ongwu ngbɛ etɔ ama n yangwuta mi ekyɛ osuse ma li ongwu nfwo elodzɛ na di difwin. O wa owawa mɛ dafi ideli, ngwuseta naadi akpe osudiwyo mgbi ungwɔ ngwi a kye kya mani.>> ");
INSERT INTO utr_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","IYesu nya ma utsa oka gbɛɛ, <<Esutɔ ongwi esho dzɛ dafi inggisɛ nkye etɔ osuse ka kya mi okwɔ mgban. ");
INSERT INTO utr_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Kpaa mi onɔ ngwi ali inggisɛ duu nuna mata, ongyikyili mgban ba wa kya etɔ obube mi ifu ekwu, si yɛ lu. ");
INSERT INTO utr_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Mi onɔ ngwi ekwu na she dile fwɛ nɛta, etɔ obube ntona kpaa fwɛ. ");
INSERT INTO utr_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","<<Engbidɔ mgbi otsungwɔ okwɔ na ba mbon wa gbɛɛ, <Ongyukwo, li etɔ osuse ngwi abu kya mi okwɔ mgbi abu baa? Li mi ole ngwi etɔ obube ntona kyɛ se ba?> ");
INSERT INTO utr_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","<<O nu uka gbɛɛ, <Li ongyikyili kyungwɔnɛni.> <<Engbidɔ ntona si byun gbɛɛ, <I mina abu ni eyi ka kyi kwɔlu maa?> ");
INSERT INTO utr_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","<<O gbɛɛ, <Ei, ikyekyɛ ni ema le kwɔ etɔ obube ntona, ema ka kwɔlu ekwu tablikyi yi ama. ");
INSERT INTO utr_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Dzata ma duu nu ma she yi ewoma nghataa ba mi onɔ oshɛ-shɛ. Mi onɔ na se ani ka nya ama oshɛ etɔ gbɛɛ, <Teyi kyi gbelu etɔ obube ntona kyi bwalu mi indinde gbe toola; di kyi gbelu ekwu ntona kwakye gbe wa wo ani kɛ oba.> >> ");
INSERT INTO utr_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","IYesu di nya ama utsa oka gbɛɛ: <<Esutɔ ongwi esho dzɛ dafi inɛnɛ unkwodzi ngwi inggisɛ kye kya mi okwɔ mgban. ");
INSERT INTO utr_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Ngwi le gyɛngyɛ ngha ali etɔ ungwɔ duu nɛ kpaa, no lumbye yɔ, li she ngha ali ekwɔ duu man li yɛɛ ekwɔ okwukwo, nghanɛ ingwunɔ emi esho li ba wa ludɛ mi abɔn.>> ");
INSERT INTO utr_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","O di nya ma utsa oka kpɔɔ gbɛɛ: <<Esutɔ ongwi esho dzɛ dafi okwuna ngwi ongyaa kye takye yi ofumbu ngwi ganyan kpatsɛ ele mani.>> ");
INSERT INTO utr_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","IYesu gbɔ ungwɔ ntonɛ duu nya ibyi inggisɛ mi utsa; ungwɔ onyi ngwi o nya ma mi utsa ba dzɛma ba. ");
INSERT INTO utr_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Nghanɛ i mbwumbwo yɛyɛ mi ungwɔ ngwi a gbɔ nyɛ mbi oyegbɔ gbɛɛ: <<N ka kwulu ondu mgbi ani gbɔdzɛ mi utsa, n ka gbɔ ungwɔ ama nto daada wita kyɛ onɔ ngwi a ta ɛsɛ majo.>> ");
INSERT INTO utr_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Ta o dzata ibyi inggisɛ di lu ifoozu. Engwafɔɔn ba mbon wa gbɛɛ, <<Nu eyi osa mi utsa mgbi etɔ obube mi okwɔ nɛni.>> ");
INSERT INTO utr_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","O gbɛɛ, <<Ongwu nkya etɔ osuse ma li Ongwɛ Inggisɛ. ");
INSERT INTO utr_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Okwɔ na li ɛsɛ duu, etɔ osuse na kwudzɛ mi ikye mgbi emi ongwɛ esutɔ. Etɔ obube ntona li engwɛ mgbi onodzi ibwubwe, ");
INSERT INTO utr_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","ongyikyili ongwu nkya etɔ ntona ma li olodu. Onɔ oshɛ-shɛ na li egbe ngwi ɛsɛ ka ngyɛ, ama oshɛ etɔ ntona li engyesɔ. ");
INSERT INTO utr_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","<<Dafi a kwɔlu etɔ obube ntona gbe toola na, li ngha nka dzɛ mi egbe ongwi olɛlɛ aali. ");
INSERT INTO utr_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Ongwɛ Inggisɛ ka dɔ engyesɔ mgban esɔ tasɛ, man a ka wa kyi kwɔlu alungwɔ ama nle nu ungwɔ obube kyɔ bɛyi ama nle kyungwɔ ibwubwe duu tasɛ mi esutɔ mgban. ");
INSERT INTO utr_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","A ka ngwi ma wokɛ amoola, li imbe na ngwi a kale tsukwu diyɛ gyaaba aali. ");
INSERT INTO utr_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Nɛta ama osaan ntona ka kwɔ dafi onɔ mi esutɔ mgbi Otsɔma. Inggisɛ ndzɛ yi adɔ yɔ, no fwo. ");
INSERT INTO utr_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","<<Esutɔ ongwi esho dzɛ dafi aludu da dzɛ okwɔ. Onɔ ngwi inggisɛ oka wa tu nɛta, o yilen kye da si yidɔ lu yi atsa ka gbelu ungwɔ mgban duu gbe gya, kye udza ma ka gyalu okwɔ nani. ");
INSERT INTO utr_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","<<Esutɔ ongwi esho di dzɛ dafi inggisɛ okyummya le pita itagwude ama osuse mani. ");
INSERT INTO utr_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Ngwi o ka di ongwi ndzɛ yi oyabɔ kpakpa nɛta, o lu ka salu ungwɔ mgban duu gbe gya yile udza ma ka gyalu itagwude nani. ");
INSERT INTO utr_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","<<Esutɔ ongwi esho di dzɛ dafi ukɛ ngwi a kye wo mi utɔ di kwu ali itɔ mmbweni duu mani. ");
INSERT INTO utr_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Onɔ ngwi mmbwɛ mbwo ukɛ ma, ama otuntsɛ li kwon luba esɛ. Ta a li sisɛ salu mmbwɛ ama osuse gbe yaokɛ uya, kpaa ama obube ntona yɔ, a li gbe ma yangwuta. ");
INSERT INTO utr_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Li ngha nka dzɛ mi onɔ ngwi ɛsɛ ka dondu aali. Engyesɔ ka ba wa ghalu emi imbali mbi emi osaan ");
INSERT INTO utr_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","di ngwi ma wokɛ amoola, imbe ngwi ikwu otseetse yi aba ogyeegye ka dzɛ mani. ");
INSERT INTO utr_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","IYesu byi engwafɔɔn gbɛɛ, <<Ema difwi ungwɔ ntonɛ duu wɛ? A nu uka gbɛɛ, <<Ɛɛn.>> ");
INSERT INTO utr_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","O nya ma gbɛɛ, <<Nghanɛ ali otsetse mgbi ola ngwu a tson ungwɔ mgbi esutɔ ongwi esho dzɛ dafi otsungwudɛ ngbe ungwɔ ama ofufɛ yi ogbugbe mi oba mgban ba esɛ mani.>> ");
INSERT INTO utr_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Ngwi iYesu tsuutsa ntonɛ ngyɛ nɛ, o dzata imbe nani. ");
INSERT INTO utr_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Ngwi o luba ogalu mgban nɛ, o wita otso inggisɛ ungwɔ mi ozu okwakye mgbi ama, i di kwulu ma ewo. Ta a gbɛɛ, <<Li mi ole ngwi inggisɛ nɛ tu ozoyeye yi mfye ama okwulewo ntonɛ ngha?>> ");
INSERT INTO utr_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","<<Nɛnɛ li ongwɛ inggisɛ ogbokwo ungwɔ nɛ lo? Li ongwu onɔn li iMeri, ngwu emi ongwunɔn li iJɛnsi yi iJose yi iSaimɔn bɛyi iJuda nɛ baa? ");
INSERT INTO utr_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Emi ongwunɔn emi engyaa duu to yi eyi mmɛnɛ dɛn baa? Nghanɛ li mi ole ngwi inggisɛ nɛ tu ungwɔ ntonɛ duu nghaa?>> ");
INSERT INTO utr_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Man i kpa ma yan wuba. Nghaduu iYesu nya ma gbɛɛ, <<Oyegbɔ dzɛ yi mmwɛ mi igeli mgban bɛyi udɛ mgban ba.>> ");
INSERT INTO utr_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Ta o kyungwɔ ama okwulewo kwuba mi imbe na wuba ikyekyɛ a noyɛyɛ ba nghao. ");
INSERT INTO utr_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Mi onɔ na iHerude utɔ mgbi emi iGalalia fwo odzɛ mgbi iYesu, ");
INSERT INTO utr_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","ta o nya emi idɔ mgban gbɛɛ, <<Nɛnɛ li iJɔn okyɔ iBatisima mani, o kyato mi ikwu! Li ngha ngwi mfye okyungwɔ okwulewo le tɔ mbon aani.>> ");
INSERT INTO utr_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Lubana iHerude nu ma bwa iJɔn di bwan adi kyon wokɛ obawi mi ikye mgbi iHerodia, owa ongwunɔn iFyilipi, ");
INSERT INTO utr_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","ikyena iJɔn teyi nyan gbɛɛ, <<Li ola ba onu abu kyon.>> ");
INSERT INTO utr_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","IHerude mina ongwɔ iJɔn, kpaa o mio ibyi inggisɛ, ikyekyɛ a kyon wuuta dafi oyegbɔ mani. ");
INSERT INTO utr_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Ngwi egbe oga owɛ egbe ngwi a mba iHerude kwokyi nɛ, ongwɛ iHerodia ongwu ongyaa ba wa shufwe nu ma di man i kpa iHerude kpakpa ");
INSERT INTO utr_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","ta o zondu yɛ fa gbɛɛ alungwɔ ngwi ongwongyaa na mina duu ongwu ka kye nun. ");
INSERT INTO utr_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Nghaduu onɔn tunwo, man o gbɛɛ, <<Kye ikye mgbi iJɔn okyɔ iBatisima mi akpɛtɛ wa nu ani mmɛnɛni.>> ");
INSERT INTO utr_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","I kaka utɔ iHerude ewo, kpaa ikyegbɛɛ o teyi zondu mi inɛ ingyoga mgban nɛ, o woola gbɛɛ nu ma kyɔ ngha ");
INSERT INTO utr_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","si nu ma ka dzɛlu iJɔn ikye mi obawi. ");
INSERT INTO utr_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","A kye ikye ma mi akpɛtɛ kaka wa nu ongwongyaa nani, o kyi kye ka nu onɔn. ");
INSERT INTO utr_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Engwafɔ iJɔn ba wa kye ikwɔ mgban ka ndzi. Ta a lu ka nya iYesu. ");
INSERT INTO utr_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Ngwi iYesu fwo ungwɔ nkyɔ nɛta, o dzata imbe na kaka uwaa lu imbe ndede ka dzɛ yuon. Ngwi ibyi inggisɛ fwo ungwɔnɛ nɛ, a tɔ mi ifu igeli mi afɛɛsɛ kyɛdɔn. ");
INSERT INTO utr_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Ngwi iYesu ka kaka dili ibyi inggisɛ nɛ, elela kyɔn wo ma, o di ngyɛlu ma ootse. ");
INSERT INTO utr_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Dafi onɔ dzɛ kwɛkwɛ ogbɛsɛ nɛ, engwafɔɔn ba mbon wa gbɛɛ, <<Imbe nɛ li ifoshɛ, onɔ di gbɛsɛ wa, nu ibyi inggisɛ ntonɛ ofɛ nu ma lu, zukwu nu ma lu emi agwudɛ ka gya ewoma ungwogye.>> ");
INSERT INTO utr_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","IYesu gbɛɛ, <<Dzɛ mbisɔ a ka lu ba. Nu ma ungwogye nu ma gye na.>> ");
INSERT INTO utr_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","A gbɛɛ, <<Eyi dzɛ yi ibredi nghi eda ta yi abatsa efa.>> ");
INSERT INTO utr_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","O gbɛɛ, <<Kye wa nin na.>> ");
INSERT INTO utr_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Ta o woola ni ibyi ntona sisɛ mi oshɛ. O kyelu ibredi eda bɛyi abatsa efa ntona si kyile inɛ esho, ta Imgbasho angba man kye mwalu ibredi ntona kye nu engwafɔ mgban, engwafɔɔn si kye gha ibyi inggisɛ ntonani. ");
INSERT INTO utr_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Ama duu gye tolo, engwafɔ iYesu di sa ambulu ama nsisi ma mi uya nghi iwyodefa. ");
INSERT INTO utr_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Mmbwo inggisɛ ama ngye ungwogye ma mɛ dafi engyulɔ idubu eda hini, a kye engyaa yi ɛngbɛ wele ba. ");
INSERT INTO utr_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Mina nɛta iYesu nu emi ongwafɔɔn kaka uwaa teyi ongwu fooye, ikye ni ongwu nu ibyi inggisɛ ntona ofɛ lu se. ");
INSERT INTO utr_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Ngwi o wa nu ibyi inggisɛ ofɛ nyɛ nɛta, o tɔkɛ unggwɔ ongwu yuon oka bibɔ, ngwi onɔ wa gbɛsɛ nɛ, o dzɛ imbe na yuon, ");
INSERT INTO utr_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Nghaduu uwaa teyi fyata yi agobo wa, akpeni le ngwin ikyekyɛ awo le fa shayɛ. ");
INSERT INTO utr_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Mi ikyegbe nɛ, iYesu lu le ka tu ma, le kyikyɛ mi ikye eni. ");
INSERT INTO utr_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Ngwi engwafɔɔn din le kyikyɛ mi ikye eni nɛ, i kwulu ma ewo. A gbɛɛ, <<Li onodzi ikwukwɔ,>> a si makwɔ tɔ yi imio. ");
INSERT INTO utr_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Kpaa iYesu nya ma vla gbɛɛ: <<Fyumfye itukwu na! Li ani. Ka mio ba na.>> ");
INSERT INTO utr_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Ta iPyita si kwun ela gbɛɛ, <<Otsɛ, ni li abu yɔ, nya ani nin kyikyɛ mi ikye eni ka tu abu.>> ");
INSERT INTO utr_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","O si gbɛɛ, <<Ba.>> Ta iPyita tasɛ mi uwaa, kyikyɛ mi ikye eni le ka tu iYesu. ");
INSERT INTO utr_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Kpaa ngwi iPyita di awo nɛ, imio won man o wita osu lu iteeni, o makwɔ tɔ gbɛɛ, <<Otsɛ, dulin tɔ!>> ");
INSERT INTO utr_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Mina ta iYesu na abɔ byun. O gbɛɛ, <<Abu ndzɛ yi oyɛyɛ onuunu gyɛngyɛ nɛ, kyɔnɛ ngwi itukwu dzɛ abu efefa ngha?>> ");
INSERT INTO utr_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Ngwi a kaka uwaa mata, awo si kwulu. ");
INSERT INTO utr_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Ta ama nwoto uwaa na sunun, le gbɛɛ, <<Otsitsi otsitsi abu li Ongwɛ Imgbasho.>> ");
INSERT INTO utr_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Dafi a fooye nɛ, a kye afɔ dɔkɛ ikpɛsɛ iGenesareti. ");
INSERT INTO utr_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ngwi emi imbe na difwi iYesu nɛ, a dɛsɔ kpatsɛ imbe na duu. Ta inggisɛ gbe emidama ama ndotse duu ba mbon ");
INSERT INTO utr_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","di tɛkyɛ nun gbɛɛ no nu emi ootse ntona kye abɔ gbon ondu angwuto ta, nghanɛ ama nkye abɔ gbon duu, ootse gbosa loma. ");
INSERT INTO utr_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Ta emi iFarasi angbeka yi etsetse mgbi ola kyɛ mi iJerosalin ba mbi iYesu wa byin gbɛɛ, ");
INSERT INTO utr_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","<<Kyɔnɛ ngwi engwafɔ mgbi abu le mbelu aletɔ ngwi engyukwo tso eyi nghaa? A li sabɔ duuse gye ungwogye ba!>> ");
INSERT INTO utr_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","IYesu nu uka gbɛɛ, <<Kyɔnɛ ngwi ema li mbe ola mgbi Imgbasho mi ikye ungwɔ etɔ mgbi ema? ");
INSERT INTO utr_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Bana Imgbasho gbɛɛ, <Sunu otsabu yi onabu> ma <Ali inggisɛ nfya otsɔn yi onɔn ito yɔ, o ka kwulu kyɛmɛ.> ");
INSERT INTO utr_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Nghaduu ema li gbɛɛ li ayin ni inggisɛ nya ama omba ma gbɛɛ, <Gyen aba, n ka yagba tobyi ema ba. Ikyesinɛ n tsekise zondu okye ungwɔ ngwi ani kika kye nu ema ma, nu Imgbasho.> ");
INSERT INTO utr_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Mi itɔ ofɛ nɛ ema li gbɛɛ, dzɛ mbisɔ ngwi a ka sunu ama omba ma ba. Nghanɛ ema kyi ndɛlu elodzɛ Imgbasho ikye aletɔ mgbi ema. ");
INSERT INTO utr_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Ema emi ikpala ntonɛ! Oyegbɔ Adzaya teyi gbɔ ayin mi ikpewo ema gbɛɛ, ");
INSERT INTO utr_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","<< <Inggisɛ ntonɛ li sunu ani mi ikpondu mgbi ama ta, kpaa itukwu mgbi ama yɔ, dzɛ mbombo yi ani. ");
INSERT INTO utr_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","A le sunu ani ayayi; bana otsootso mgbi ama duu kpaa li ola mgbi inggisɛ ta.> >> ");
INSERT INTO utr_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","IYesu kwu ibyi inggisɛ ela ba mbon wa nya ma gbɛɛ, <<Gadɔ no di gbosa lo ema na. ");
INSERT INTO utr_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Li ungwɔ nkaka ondu mbi inggisɛ ma li nu otsungwɔn <tsiidza> ba, kpaa li ungwɔ ntasɛ mi ondu mbon ma, li non <tsiidza> aali.>> ");
INSERT INTO utr_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Ta engwafɔɔn wa byun gbɛɛ, <<Abu ye dafi itukwu wulu emi iFarasi ntona ngwi a fwo odzɛ nɛ ma wɛ?>> ");
INSERT INTO utr_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","O nu uka gbɛɛ, <<Ali ekwɔ ngwi li Otsani ongwi esho kye ye ba duu, a ka kye todulu yi akpa. ");
INSERT INTO utr_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Dzata ma; a li ama ogbe obinɛ teyi. Kini obinɛ kye obinɛ oka teyi yɔ, ama duu ka gbɛsɛ wokɛ ishɛ.>> ");
INSERT INTO utr_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","IPyita gbɛɛ, <<Nu eyi osa mi utsa nɛni.>> ");
INSERT INTO utr_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","IYesu byi ma gbɛɛ, <<Nghataa ba onɛnɛ kpaa ema difwi odzɛ nɛ wa lo? ");
INSERT INTO utr_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Ema di dafi alungwɔ nkaka ondu li nyɛ lu ifu a di li kye nyalu ngwuta mi inɛnɛ ma baa? ");
INSERT INTO utr_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Kpaa ungwɔ ama nli tɔ mi ondu ma li kyɛ mi itukwu, di li ungwɔ ntona li nu inggisɛ <tsiidza> aali. ");
INSERT INTO utr_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Bana li mi itukwu ngwi ewodzɛ ibwubwe, ongwɔ inggisɛ yi amah okyɔɔkyɔ yi inɛ okyeekye yi mmyi yi obwɛndɛ atsika bɛyi ito li tɔ aali. ");
INSERT INTO utr_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Li ungwɔ ntonɛ li nu inggisɛ <tsiidza> aali, kpaa osabɔ bata gye ungwogye, ka nu inggisɛ <tsiidza> ba dududu.>> ");
INSERT INTO utr_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Ngwi iYesu dzata imbe na nɛ, o lu ayɛsɛ mgbi iTiru yi iSidon. ");
INSERT INTO utr_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Ta ongyaa iKana ndzɛ ayɛsɛ na ba mbon wa makwɔ gbɛɛ, <<Otsɛ, Ongwɛ iDevedi, di ani elela! Esɛ dɔ ongwani ongwu ongyaa ikye she.>> ");
INSERT INTO utr_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","IYesu gbɔ elodzɛ onyi ba. Nɛ engwafɔɔn ba mbon wa tɛkyɛ yan gbɛɛ, <<Nu ongyaa nɛ ofɛ no lu, bana o le makwɔ kyɛ eyi iyikpa.>> ");
INSERT INTO utr_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","O gbɛɛ, <<A dɔ ani esɔ mbi mmala mgbi Israi nbyulu ma kyoon.>> ");
INSERT INTO utr_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ongyaa ma ba wa kwɛsɛ mi iyayi mbon, o gbɛɛ, <<Otsɛ, ya ani abɔ!>> ");
INSERT INTO utr_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","IYesu nu uka gbɛɛ, <<Li ayin okye ungwogye mgbi engwɛ ngwuta to obwe ba.>> ");
INSERT INTO utr_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Ongyaa na gbɛɛ, <<Ɛɛn, Otsɛ, obwe kpaa li gye ambulu ungwogye ama n yangwuta mi adinyatsɛ mgbi otsungwudɛ mani.>> ");
INSERT INTO utr_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Man iYesu nu uka gbɛɛ, <<Ongyaa, oyɛyɛ onuunu mgbi abu shewo! Ungwɔ ngwi abu mina ma a kyɔ abu ele wa.>> Ta ewo gbosa lo ongwan ongwu ongyaa na mi obyi na yɛyɛ. ");
INSERT INTO utr_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Nɛ iYesu dzata imbe na yɛ lu ekyoo mgbi iGalalia. Ta o tɔkɛ unggwɔ ka sisɛ mi ele. ");
INSERT INTO utr_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Man ibyi inggisɛ kpakpa ba mbon, yi inggisɛ ogbyikye tukwu esɛ yi obinɛ yi inggisɛ okwukwu yi ikplima bɛyi angbeka kwuba, gbe ma wa lakiyayi iYesu; man o ngyɛlu ma duu ootse. ");
INSERT INTO utr_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","I kwulu inggisɛ ntona ewo mi onɔ ngwi a di ikplima le gbɔdzɛ, inggisɛ okwukwu yɛɛ saan yi inggisɛ ogbyikye tukwu esɛ le kyikyɛ bɛyi obinɛ le dinɛ mani. A si tsɛ Imgbasho mgbi Israi. ");
INSERT INTO utr_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Nghanɛ iYesu kwu engwafɔɔn ela ba mbon di gbɛɛ, <<Elela kyɔ ani wo inggisɛ ntonɛni; bana a to yi ani mɛ egbe eta waani yi unkonyi ogyeegye ba. N mina owo ma ofɛ lu yi enbwa ifu ba, adzi nu ma ka kwu anadza mi ofɛ ba mani.>> ");
INSERT INTO utr_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Engwafɔ mgban nu uka gbɛɛ, <<Li mi ole eyi ka tu ibredi mi ifoshɛ nɛ mɛ obyi ibyi inggisɛ ntonɛ enbwa?>> ");
INSERT INTO utr_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","IYesu si byita gbɛɛ, <<Ema dzɛ yi ibredi eminɛ?>> A gbɛɛ, <<Li nghi egyafa bɛyi engwɛ abatsa bwee.>> ");
INSERT INTO utr_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","O nya ibyi inggisɛ nu ma sisɛ mi ombulu. ");
INSERT INTO utr_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Ta o kyi kyelu ibredi egyafa yi engwɛ abatsa ntona, ngwi o ta Imgbasho angba nɛ, o kye mwalu di kye nu engwafɔ mgban, man a yilen kye gha ibyi inggisɛ ntonani. ");
INSERT INTO utr_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Ama duu gye di tolo. Ngwi nyɛ nɛta, engwafɔɔn kyi gbelu ambulu ama nsisi ma mbwo uya egyafa. ");
INSERT INTO utr_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Mmbwo inggisɛ ama ngye ungwogye ma li idubu enɛ, engyaa yi ɛngbɛ wele ba. ");
INSERT INTO utr_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Ngwi iYesu wa nu ibyi inggisɛ ofɛ lu nɛta, o kaka uwaa lu ayɛsɛ iMagadan. ");
INSERT INTO utr_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Emi iFarasi yi emi iSadusi ba mbi iYesu wa mbadin, a byun gbɛɛ non tso ama ambɛ ongwi esho. ");
INSERT INTO utr_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Nghanɛ iYesu nu uka gbɛɛ, <<Ni onɔ le gbɛsɛ ta, ema li gbɛɛ, <Imbe ka kwulu, ikyekyɛ akpesho ma,> ");
INSERT INTO utr_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","mi egbegbe ema li gbɛɛ, <Inɛ mmbwo ka kya, ikyekyɛ akpesho ma i di yifu.> Ema li yagba ogbɔ ambɛ mgbi akpesho, kpaa ema ka yagba difwi ambɛ mgbi odzɛɛdzɛ ongwi onɛnɛ ba. ");
INSERT INTO utr_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Etɔ obube yi etɔ amah li le pita ambɛ okwulewo, nghaduu a ka nun onyi ba, se li ambɛ mgbi iJona na ta.>> IYesu si dzata ma lu. ");
INSERT INTO utr_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Ngwi engwafɔ iYesu foye utɔ nɛ, a gblimɔ okye ibredi byi. ");
INSERT INTO utr_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Nɛ iYesu nya ma gbɛɛ, <<Gbɛwɛbyi di ngyo ewoma mi okwuna mgbi emi iFarasi yi emi iSadusi na.>> ");
INSERT INTO utr_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","A le gbɔ yi ewoma gbɛɛ, <<Li ikyegbɛɛ eyi kye ibredi onyi kpaa byi ba mani.>> ");
INSERT INTO utr_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Ngwi iYesu ye ewodzɛ mgbi ama nɛ, o gbɛɛ, <<Ema ngwu oyɛyɛ onuunu shanyɛ mbi ema nɛ, kyɔnɛse ema le gbɔ yi ewema kyɛ gbɛɛ li ikyegbɛɛ ema dzɛ yi ibredi ba? ");
INSERT INTO utr_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Ema difwi walo? Ema wɛ ibredi eda mi ikye inggisɛ idubu eda, yi ongwi ema gbe mbwo uya kwuba na lo? ");
INSERT INTO utr_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Naadi ibredi nghi egyafa mi ikye inggisɛ idubu enɛ, yi ongwi ema gbe mbwo uya kwuba na lo? ");
INSERT INTO utr_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Ani le gbɔdzɛ yi ema mi ikye ibredi ba, i wita sinɛ ngwi ema difwi ba? Kpaa ngyo ewema mi okwuna mgbi emi iFarasi yi emi iSadusi.>> ");
INSERT INTO utr_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Ta a difwi gbɛɛ o le nya ama gbɛɛ ni ama ngyo ewoma mi ikye okwuna owo ibredi ba, nghaduu li ikye otsootso mgbi emi iFarasi yi emi iSadusi. ");
INSERT INTO utr_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Dafi iYesu ba ayɛsɛ mgbi iSisiria iFyilipi nɛ, o byi engwafɔɔn gbɛɛ, <<Inggisɛ li gbɛɛ Ongwɛ Inggisɛ li emɛ?>> ");
INSERT INTO utr_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","A gbɛɛ, <<Angbeka gbɛɛ o li iJɔn okyɔ iBatisima, angbeka yɔ gbɛɛ o li Elaija, angbeka di gbɛɛ o li iJeremia hona onyi mbi ama ogbɛɛsɛ.>> ");
INSERT INTO utr_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","IYesu byita gbɛɛ, <<Nghanɛ ema ma, ema gbɛɛ ani li emɛ?>> ");
INSERT INTO utr_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Nɛ iSaimɔn iPyita nu uka gbɛɛ, <<Abu li iMedzaya, Ongwɛ Imgbasho oshishe.>> ");
INSERT INTO utr_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","IYesu nyan gbɛɛ, <<Mse no bɛ abu ewo, iSaimɔn ongwɛ iJona, bana li inggisɛ nya abu ungwɔnɛ ba, kpaa kyɛ mbi Otsani ongwi esho. ");
INSERT INTO utr_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Nghanɛ n kwu abu gbɛɛ iPyita, ma li mi ikye ikwutsɛ nɛ n ka mbɛ okwakye mgbi emi iKrestu mgbi ani, ma onufozu udola ka yagba tukwu ofɛ ba. ");
INSERT INTO utr_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","N ka gbe ungwɔ okwulu ofɛ esutɔ ongwi esho duu nu abu; alungwɔ ngwi abu kyi bwalu mi esɛ nɛ duu, a ka kye bwalu mi esho, alungwɔ ngwi abu di kye shɛlu mi esɛ nɛ duu, a ka kye shɛlu mi esho.>> ");
INSERT INTO utr_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Ta o kwo engwafɔɔn adɔ gbɛɛ nu ma ka nya inggisɛ onyi gbɛɛ ongwu li iMedzaya ma ba. ");
INSERT INTO utr_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Mi onɔ na lu iyayi iYesu wita onya engwafɔɔn gbɛɛ li kyɛmɛ ngwi ongwu ka kɛ iJerosalin ka gbiisɔ mi ungwɔ kwuba mi abɔ engyukwo emi Israi yi engyukwo ama ofifɛ bɛyi etsetse mgbi ola, a dika ngwɔ ongwu kyɛmɛ, nghaduu mi egbe ongwu ta ma ongwu ka kyɛɛ mi ikwu. ");
INSERT INTO utr_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Nɛ iPyita kyon lu enggengga ka wita okyɔkyɔ yan gbɛɛ, <<Imgbasho no tukwu ofɛ nani, Otsɛ! Ungwɔnɛ ka yama kyɔ abu ba!>> ");
INSERT INTO utr_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","IYesu kyata yɛ nya iPyita gbɛɛ, <<Yɛ iyikpa mbi ani, iSatan! Abu li ungwɔ onu ani esɛ ogboogbo; bana abu kye ungwɔ ama nli mgbi Imgbasho ma wuuta ba, se li mgbi inggisɛ kyoon.>> ");
INSERT INTO utr_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Ta iYesu nya engwafɔɔn gbɛɛ, <<Kini inggisɛ mina okyɛdɔ ani yɔ, li kyɛmɛ ngwi o ka tangwɛ ewon yɛ kye ekwatsi mgban kyɛdɔ ani. ");
INSERT INTO utr_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Lubana ali inggisɛ nmina ona oshishe mgban tɔ yɔ, oshishe mgban ka byulu, kpaa inggisɛ nnu oshishe mgban byulu ikye ani duu ka tun. ");
INSERT INTO utr_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Ni inggisɛ tu alungwɔ mi ɛsɛ duu kpaa ni oshishe mgban nyanya lon ma, oyabɔ li ekyɛ? Naadi li ekyɛ ngwi inggisɛ ka kye nu gbikye oshishe mgban? ");
INSERT INTO utr_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Lubana Ongwɛ Inggisɛ ka wa ba mi okwɔkwɔ mgbi Otsɔn yi engyesɔ mgban, nɛ o ka nu ali inggisɛ umba mi okyɔɔkyɔ mgbi otsungwɔn. ");
INSERT INTO utr_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","N nya ema otsitsi, ema angbeka kwudzɛ mmɛnɛ ma, nka di ikwu inɛ ba nghataa wa di Ongwɛ Inggisɛ kyɛ le ba mi esutɔ mgban.>> ");
INSERT INTO utr_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Ngwi i wa nyɛ egbe egyin nɛ, iYesu kyelu iPyita yi iJɛnsi bɛyi ongwunɔn iJɔn, si teyi ma ofɛ lu ka dɔkɛ unggwɔ oshigbo to efu yuoma. ");
INSERT INTO utr_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Mi imbe na a kyatan mi inai ma. Inɛ mgban kwɔkwɔ dafi onɔ, angwuto mgban tundzɛ kpledede dafi osa mani. ");
INSERT INTO utr_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Labɔlabɔ nɛ iMose bɛyi Elaija mblegba tu ma, le gbɔdzɛ yi iYesu. ");
INSERT INTO utr_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Nɛ iPyita si nya iYesu gbɛɛ, <<Otsɛ, i tishi ni eyi dzɛ mmɛnɛni. Ni abu gbela yɔ, n ki klɛ afu nghi eta, onyi ikye abu, onyi ikye iMose oka ikye Elaija.>> ");
INSERT INTO utr_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Dafi o kale kiyayi yi odzɛ ogbɔɔgbɔ nɛta, akpa okwɔkwɔ gbiiwulu tukwu ma, ela si tɔ mi akpa na gbɛɛ, <<Nɛnɛ li Ongwani itukwu-tukwu; i kpa Ani yan saan. Fwon na!>> ");
INSERT INTO utr_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Ngwi engwafɔ mgbi iYesu fwo ungwɔnɛ nɛ, a si lakɛ esɛ kye inɛ tukwu esɛ, yi imio. ");
INSERT INTO utr_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Nɛta iYesu si ba wa kye abɔ gbo ma ewo. O nya ma gbɛɛ, <<Kyato, ka wimio ba na.>> ");
INSERT INTO utr_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Ngwi a kyile inɛ esho nɛ, a yama di inggisɛ onyi wuba se iYesu ta. ");
INSERT INTO utr_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Dafi a tashulu mi unggwɔ le luba esɛ nɛ, iYesu wo ma ola gbɛɛ, <<Ka yama gbɔ ungwɔ ngwi ema di nɛ nya inggisɛ onyi ba, nghataa se ni a wa kyile Ongwɛ Inggisɛ mi ikwu.>> ");
INSERT INTO utr_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Engwafɔ mgbi iYesu byun gbɛɛ, <<Kyɔsinɛse ngwi etsetse mgbi ola lile gbɔgbɛɛ Elaija ka wa ba ababɔ kyɛmɛ?>> ");
INSERT INTO utr_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Man iYesu nu uka gbɛɛ, <<Li otsitsi, Elaija ka ba wa yile alungwɔ mɛ dzɛkɛ yɛyɛ. ");
INSERT INTO utr_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Nghaduu n nya ema, Elaija ba wa, kpaa a yama difwin ba nɛ a kyɔn alungwɔ ngwi a mina duu. Mi itɔ ofɛ na kpɔɔ Ongwɛ Inggisɛ ka wa gyadzɛ mi abɔ ma.>> ");
INSERT INTO utr_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Ta engwafɔɔn si difwi gbɛɛ li iJɔn okyɔ iBatisima ngwi o le gbɔdzɛ mgban nya ama aali. ");
INSERT INTO utr_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Dafi a yidɔ wa tu ibyi inggisɛ nɛ, ongyulɔ oka ba wa kwokiyayi iYesu. ");
INSERT INTO utr_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","O nyan gbɛɛ, <<Otsɛ, di ongwani ongwu ongyulɔ nɛ elela. O li dzɛkwulu pyiipyii mi onɔ ngwi i wa dzɛsin, o li gye onikyɔ adzɛ oshewo saan. O li gbɛsɛ tsɛkɛ ola hona mi eni alonɔ ngwi i dzɛsun duu. ");
INSERT INTO utr_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","N kyon ba mbi engwafɔ mgbi abu, kpaa a yagba ongyɛlun ootse nɛ ba.>> ");
INSERT INTO utr_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Nɛ iYesu gbɛɛ, <<Kpei, etɔ ndzɛ yi oyɛyɛ onuunu ba di dzɛ kpɛnyɛ-kpɛnyɛ nɛ! Ka kye onɔ sinɛ ngwi ani ka dzɛ yi ema? Ka kye onɔ sinɛ ngwi ani ka kyungwɔ yi ema? Kye ongwongyulɔ ma ba mbi ani mmɛnɛni!>> ");
INSERT INTO utr_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Ta iYesu kyɔkyɔ yi onodzi obube nani, man onodzi ma tasɛ mbi ongwongyulɔ nani, mi onɔ na jo ootse mgban ngyɛ. ");
INSERT INTO utr_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Nɛ engwafɔ mgbi iYesu si ba mbon fyɛɛ wa byun gbɛɛ, <<Kyɔsinɛse ngwi eyi yagba lɔ onodzi obube nɛ onya tɔ gbɛ ba?>> ");
INSERT INTO utr_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Man iYesu nya ma gbɛɛ, <<Li ikyegbɛɛ ema dzɛ yi oyɛyɛ onuunu shanyɛ mani. N nya ema otsitsi, kini ema dzɛ yi oyɛyɛ onuunu ndzɛ tsiklimbyi dafi inɛnɛ unkwodzi hini yɔ, ema ka nya unggwɔ gbɛɛ, <Kyato mmɛnɛ lu mbo> ka yagba kyɔ ngha. Nkonyi ka ndɛ ema okyɔɔkyɔ ba.>> ");
INSERT INTO utr_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","(Kpaa itɔ nɛ li yama tɔ ngha ba, sede li mi ibɔ bɛyi ondu otukwu-tukwu kpɔklɔɔ!) ");
INSERT INTO utr_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Ngwi a wa kwakye yi ewoma mi iGalalia nɛ, iYesu nya ma gbɛɛ, <<A ka wa kye Ongwɛ Inggisɛ wo inggisɛ kɛ abɔ. ");
INSERT INTO utr_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","A ka ngwɔn, ta mi egbe ongwu ta ma Imgbasho ka kyilen mi ikwu.>> Nɛta engwafɔɔn si yɛɛ elela. ");
INSERT INTO utr_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Ngwi iYesu yi engwafɔɔn wa kaka iKapenahun nɛ, ama ogbɛ udza IDracama ba mbi iPyita wa byun gbɛɛ, <<Otsetse mgbi ema nɛ li kpa udza ifyɛɛ mgbi ozu okwukwo osunu Imgbasho mi iJerosalin lo?>> ");
INSERT INTO utr_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","O gbɛɛ, <<Ɛɛn, o li kpa.>> Ngwi iPyita wa kaka ozu nɛta, iYesu li inggisɛ ongwu ababɔ ogbɔdzɛ. O byita gbɛɛ, <<Abu tsɛwɛ sinɛ, iSaimɔn? Li mbi ele ngwi utɔ emi ɛsɛ li gbɛ udza ifyɛɛ, li mbi engwɛ ma engyulɔ naadi li mbi inggisɛ angbeka?>> ");
INSERT INTO utr_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Nɛ iPyita nu uka gbɛɛ, <<Li mbi inggisɛ angbeka.>> Ta iYesu gbɛɛ, <<Ngyɛse emi ongwɛ ma wele ba.>> ");
INSERT INTO utr_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","<<Nghaduu ni eyi ka foola mgbi ama bayɔ, lu utɔ ka ngwi alii. Kye mmbweni ongwi ababɔ ngwi abu kwu ma; kwulun ondu ta o ka tu iwai awuya. Kyelu kye wa nu ma mi ikye udza ifyɛɛ mgbi ani yi abu.>> ");
INSERT INTO utr_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Mi onɔ na engwafɔ iYesu ba mbon wa byun gbɛɛ, <<Li emɛni shewo ngha mi esutɔ ongwi esho?>> ");
INSERT INTO utr_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Nɛ iYesu kwu ongwɛ ogyɛngyɛ ela ba wa non dzɛkɛ mi idzidzɛ ma. ");
INSERT INTO utr_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","O gbɛɛ, <<N nya ema otsitsi, sede ni ema kyata di yɛɛ dafi ɛngbɛ ama oshilɛlɛ bayɔ, ema ka kaka esutɔ ongwi esho ba. ");
INSERT INTO utr_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Nghanɛ, ali inggisɛ n yile ewon esɛ dafi ongwɛ nɛ yɔ, ka shewo ngha mi esutɔ ongwi esho. ");
INSERT INTO utr_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","<<Ali inggisɛ ndi gbɛ ongwongbɛ dafi ongwu nɛ mi iyi mgbi ani yɔ, gbɛ ani. ");
INSERT INTO utr_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Kpaa ni inggisɛ onyi nu onyi mbi ama oshilɛlɛ ntonɛ ngwu noyɛyɛ mbi ani nɛ kyɔ alobube yɔ, ka tatase nu ma kye onikyikwɔɔ okpinangwɔ shaan onbukwɔ kyen ka ngwuta mi ole ozunubyi mi idzidzɛ ekyoo okwukwo. ");
INSERT INTO utr_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","<<Ahoo ikye ɛsɛ mi ikye ungwɔ nnu inggisɛ kyɔ alobube mani! Itɔ ungwɔ ntona ka wa dzɛ kyɛmɛ-kyɛmɛ, nghanɛ ikamba ka wa dzɛ mi ikye inggisɛ ngwu itɔ ungwɔ ntona ka kyɛ ikpewon ba mani! ");
INSERT INTO utr_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Ni abɔ naadi afɔ mgbi abu nu abu kyungwɔ obube yɔ, kye dzɛlu ngwuta. Ka tatase ni abu kaka oshishe yi mmya otaata hona ogbyikye-gbyikye ngha onu abu dzɛ yi abɔ efa bɛyi afɔ efa nu ma kye abu ngwuta wokɛ ola nka gye gyegwu nani. ");
INSERT INTO utr_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Kini inɛ mgbi abu nu abu kyungwɔ obube yɔ, kye todulu ngwuta. Ka tatase ni abu kaka oshishe yi inɛ onyi ngha odzɛ yi inɛ efa nu ma kye abu ngwuta wokɛ udola. ");
INSERT INTO utr_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","<<Ka di gbɛɛ ɛngbɛ ama oshilɛlɛ ntonɛ li unkaba ba na. Bana n nya ema gbɛɛ engyesɔ mgbi ama mi esho li di inɛ Otsani ongwi esho alonɔ duu. ");
INSERT INTO utr_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","(Bana Ongwɛ Inggisɛ ba owa nagbɛ inggisɛ ama nbyulu mani.) ");
INSERT INTO utr_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","<<Ema tsɛwɛ sinɛ? Kini inggisɛ dzɛ yi mmala ideli onyi, ma onyi mi efu byulu lu mbeka ma, o ka dzata ngwusenɛ dɔn iwyo diwyegyanɛ ntona mi unggwɔ lu oka pita onyi nbyulu wooshɛ na baa? ");
INSERT INTO utr_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Ki non ka kpakyon yɔ, n nya ema otsitsi, o ka tsatsa kpakpa ikye mmala onyi nbyulu na ngha ngwusenɛ dɔn iwyo diwyegyanɛ nbyulu wooshɛ ba ntonani. ");
INSERT INTO utr_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Mi itɔ ofɛ nɛ kpɔɔ Otsema ndzɛ esho dzɛ yi oweka gbɛɛ onyi mbi ɛngbɛ ama oshilɛlɛ ntonɛ nu ma byulu ba. ");
INSERT INTO utr_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","<<Kini ongwunabu kyɔ abu obube yɔ, kɛ ka non difwi obube mgban, mi idzidzɛ ema efa ta. Ki non gadɔ mi elodzɛ mgbi abu yɔ, abu yilen dzɛ ofɛ waali. ");
INSERT INTO utr_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Nghaduu non yama gbela fwo bayɔ, kye inggisɛ onyi naadi efa bɛkɛ yɔɔ wafɔ kɛ mbon, ikyegbɛɛ nu ma yile odzɛ mɛ mi obwɛndɛ mgbi inggisɛ efa hona eta mani. ");
INSERT INTO utr_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ki non fwa ofwo ma yɔ, nya okwakye mgbi emi iKrestu, non di fwa ofwo okwakye mgbi emi iKrestu kpaa yɔ, kyɔ yan dafi abu kika kyɔ yi inggisɛ ola angwula naadi inggisɛ ogbɛ udza ifyɛɛ mani. ");
INSERT INTO utr_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","<<N nya ema otsitsi, alungwɔ ngwi ema kye bwalu mi ɛsɛ nɛ duu a teyi kye bwalu mi esho wa, alungwɔ ngwi ema di kye shɛlu mi ɛsɛ nɛ duu a teyi kye shɛlu mi esho wa. ");
INSERT INTO utr_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","<<N di nya ema gbɛɛ ni ema efa mi ɛsɛ bwondu bɔ ungwɔ yɔ, Otsani ndzɛ esho na ka kyɔ ema ele. ");
INSERT INTO utr_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Bana imbe ngwi inggisɛ efa naadi eta kwakye mi iyi mgbi ani ma, Ani dzɛ ele yi ama.>> ");
INSERT INTO utr_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Ta iPyita wa byi iYesu gbɛɛ, <<Otsɛ, li akpe eminɛ ngwi ani ka dzata ongwunani ki non kyɔ ani obube? No li akpe egyafa hinii?>> ");
INSERT INTO utr_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","IYesu nyan gbɛɛ, <<N nya abu, akpe egyafa ta ba, kpaa li akpe ngwuseta dɔn iwyo diwyegyafa. ");
INSERT INTO utr_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","<<Nghanɛ, esutɔ ongwi esho dzɛ dafi utɔ oka nkwu engbidɔ mgban ama ngbɛ mkpa mbon ela ba gbɛɛ nu ma nya ongwu mmbwo mkpa ngwi a dzɛ yi ongwu efu mani. ");
INSERT INTO utr_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Dafi o wita okyungwɔnɛ nɛ, a kye ongyulɔ oka ba mbon ndzɛyan mkpa mɛ imiliɔn ibyibyi. ");
INSERT INTO utr_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ngwi o yagba okpa mkpa na gbɛ ba nɛ, ongyukwo na si noola gbɛɛ ongwu yi owan yi ɛngbɛ yi alungwɔ ngwi o dzɛyan tsatsadu ni a gbe ma gya kpa mkpa nani. ");
INSERT INTO utr_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","<<Ongbidɔ na si gbe akwafɔ kwɛsɛ tɛkyɛ nun gbɛɛ, <Shitukwu yi ani, n ka wa kpa abu alungwɔ duu.> ");
INSERT INTO utr_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Ongyukwo mgban si din elela. O dzanta yi mkpa nani di non lu. ");
INSERT INTO utr_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","<<Ta ongbidɔ na tasɛ lu esɛ, o ka kpatsɛ yi odon ongbidɔ oka ndzɛyan mkpa mɛ dafi idubu ngwusefa dɔn iwyo sini. O kpaklin kye abɔ fyin onbukwɔ gbɛɛ, <Kpa ani mkpa ngwi abu dzɛ yi ani efu mani!> ");
INSERT INTO utr_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","<<Ongbidɔ odon na si gbe akwafɔ kwɛsɛ di tɛkyɛ nun gbɛɛ, <Shitukwu yi ani, n ka wa yile udza mgbi abu kpa abu.> ");
INSERT INTO utr_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","<<Nghaduu o fwa. O kɛ ka nu ma bwa ongyulɔ na wokɛ obawi gbɛɛ sede no kpan mkpa. ");
INSERT INTO utr_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Ngwi engbidɔ angbeka di ungwɔ nkyɔ nɛ, i wulu ma ewo saan man a kɛ ka nya ongyukwo mgbi ama ungwɔ nkiyayi duu. ");
INSERT INTO utr_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","<<Ta ongyukwo ma kwu ongbidɔ na ela ba mbon nyan gbɛɛ, <Abu ongbidɔ ndzɛ yi imbali nɛ, n dzita abu yi udza ngwi abu dzɛ yi ani ele duu ikyegbɛɛ abu tɛkyɛ nu ani. ");
INSERT INTO utr_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Abu kpa ki di odo oka na elela dafi ani di abu na baa?> ");
INSERT INTO utr_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Ongyukwo na nyɛ yi itingga kyen wo ama odi mi obawi abɔ gbɛɛ nu ma nun adzɛ saan, nghataa se non yile mkpa ngwi o gye na kpa klɛklɛ. ");
INSERT INTO utr_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","<<Nɛ li ngha ngwi Otsani ongwi esho ka kyɔ yi ali inggisɛ mgbi ema, se ni ema dzita ongwunema yi obube itukwu onyi.>> ");
INSERT INTO utr_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Ngwi iYesu ngyɛlu odzɛ ntonɛ ogbɔɔgbɔ bɛyi ama nɛ, o lu dzata iGalalia di kaka mi ayɛsɛ mgbi iJudia lu oyombo iJodan. ");
INSERT INTO utr_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Ibyi inggisɛ tukwun iyikpa kyɛ, man o ngyɛlu ma ootse mi imbe nani. ");
INSERT INTO utr_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Emi iFarasi angbeka ba mbon ikye owa mbadin. A byin gbɛɛ, <<Li ola ni ongyulɔ gheeba yi owan mi ali itɔdzɛ duu?>> ");
INSERT INTO utr_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","IYesu nu uka gbɛɛ, <<Ema gbɔ ye walo? Gbɛɛ mi owita-wita ma Atta <ta ongyulɔ yi ongyaa,> ");
INSERT INTO utr_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","di gbɛɛ, <Mi itɔdzɛ nɛ, ongyulɔ ka dzita otsɔn bɛyi onɔn yɛ kwokyi yi owan, ta ama efa ka yɛɛ ikpewo onyi.> ");
INSERT INTO utr_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Nɛ a li efa wuba, kpaa a li onyi. Ikyenghanɛ ungwɔ ngwi Imgbasho kye kwokyi yi eka yɔ, ni inggisɛ onyi ka yama ghalu ma ba.>> ");
INSERT INTO utr_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","A byita gbɛɛ, <<Nghama kyɔsinɛ ngwi iMose woola gbɛɛ ongyulɔ no dzɛ afɛ ogheeba nu owan di lɔn onya lu?>> ");
INSERT INTO utr_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","IYesu gbɛɛ, <<iMose nose nu ema ofɛ ogheeba yi owema ikyegbɛɛ itukwu mgbi ema tiishu. Nghaduu li ngha ngwi i dzɛ mi owita-wita ma ba. ");
INSERT INTO utr_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","N nya ema gbɛɛ ali inggisɛ n gheeba yi owan, ni li ikye amah ba di kye ongyaa oka yɔ, kyɔ amah.>> ");
INSERT INTO utr_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Ta engwafɔɔn nyan gbɛɛ, <<Ni li ngha ungwɔ dzɛ yi ongyulɔ yi owan yɔ, i tatase okye ongyaa ba.>> ");
INSERT INTO utr_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Nghaduu iYesu gbɛɛ, <<Li ali inggisɛ duu ka gbela odzɛ nɛ ba, kpaa li ama ngwu a kye nu ma mata. ");
INSERT INTO utr_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Lubana angbeka li adumongyaa ikyesinɛ li ngha ngwi a mba ma aali; angbeka li inggisɛ kyɔ ma nu ma yɛɛ ngha aali; angbeka di fwa okye ongyaa ikye esutɔ ongwi esho. Inggisɛ nka gbela yi odzɛ nɛ yɔ no gbela.>> ");
INSERT INTO utr_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Nɛta a gbe ɛngbɛ ama oshilɛlɛ ba mbi iYesu gbɛɛ no kye abɔ gbo ma ewo di bibɔ wo ma. Kpaa engwafɔɔn kyɔkyɔ yi ama ngbe ma ba mani. ");
INSERT INTO utr_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","IYesu gbɛɛ, <<Nu ɛngbɛ ama oshilɛlɛ ofɛ nu ma ba mbi ani, ka yama kwɔ ma ba, bana esutɔ ongwi esho dzɛ ikye itɔ ntonɛni.>> ");
INSERT INTO utr_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Ngwi o kye abɔ gbo ma ewo nɛ, o lu dzata imbe nani. ");
INSERT INTO utr_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Nghanɛ ongyulɔ oka ka ba mbi iYesu wa byita gbɛɛ, <<Otsetse, li alungwɔ osuse ngwi ani ka kyɔ kyɛmɛ se tu oshishe ogyegwu?>> ");
INSERT INTO utr_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","IYesu nyan gbɛɛ, <<I kyɔsinɛ ngwi abu byi ani ita ungwɔ nli osuse? Inggisɛ li Onyi ta nli osuse. Ni abu mina otu oshishe yɔ, ngyo ola duu.>> ");
INSERT INTO utr_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Ongyulɔ na gbɛɛ, <<Li ole?>> IYesu gbɛɛ, << <Ka ngwɔ inggisɛ ba, ka kyɔ amah ba, ka yimi ba, ka kyɔ obwɛndɛ atsika ba, ");
INSERT INTO utr_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","sunu otsabu yi onabu, di di inggisɛ owatse dɔ abu kpa abu itukwu dafi ewabu mani.> >> ");
INSERT INTO utr_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Ongyulɔ mmafa na gbɛɛ, <<Ola ntonɛ duu n li ngyo ma. Li ekyɛ sisi ngwi ani ka kyɔ?>> ");
INSERT INTO utr_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","IYesu nyan gbɛɛ, <<Ni abu mina odzɛ nyaan yɔ, lu ka gbe alungwɔ ngwi abu dzɛyan duu gya kye udza ma nu emi adzɛ, ta o ka dzɛ yi aludu mi esho. Ta o si yɛ wa kyɛdɔ ani.>> ");
INSERT INTO utr_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Ngwi ongyulɔ mmafa na fwo ungwɔnɛ nɛ, o lu yi mtse obaaba, ikyena o dzɛ yi aludu shewo. ");
INSERT INTO utr_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Nghanɛ iYesu nya engwafɔɔn gbɛɛ, <<N nya ema otsitsi, ka fyumfye kpakpa ni inggisɛ udza kaka esutɔ ongwi esho. ");
INSERT INTO utr_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","N di nya ema, ka fyumfye ba onu ilakwumyi nyɛ tɔ ifeedi ngha onu inggisɛ udza kaka esutɔ mgbi Imgbasho.>> ");
INSERT INTO utr_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Ngwi engwafɔ ntonɛ fwo ungwɔnɛ nɛ, i kwulu ma ewo kwuba ta a byita gbɛɛ, <<Li emɛ tsatso ka watɔ?>> ");
INSERT INTO utr_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","IYesu di ma inɛ si gbɛɛ, <<Mbi inggisɛ owamyɛ yɔ itɔ ungwɔnɛ ka kyɔ gbɛ ba, kpaa yi Imgbasho yɔ, alungwɔ duu li kyɛmɛ.>> ");
INSERT INTO utr_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Nɛman iPyita gbɔ yan gbɛɛ, <<Eyi dzita alungwɔ duu kyɛdɔ abu! Nghanɛ li ekyɛ ka dzɛ ikye eyi?>> ");
INSERT INTO utr_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","IYesu nya ma gbɛɛ, <<N nya ema otsitsi, onɔ ngwi Ongwɛ Inggisɛ ka sɔkɛ itsuutɔ mgban okwɔkwɔ mi ɛsɛ ongwi iyayi ma, ema ama nkyɛdɔ ani duu ka sɔkɛ itsuutɔ iwyodefa, le gbɔ etɔ mgbi Israi iwyodefa ikwɔ. ");
INSERT INTO utr_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ali inggisɛ ndi dzata udɛ hona emi ongwunɔn engyulɔ yi engyaa naadi otsɔn yi onɔn hona ɛngbɛ bɛyi okwɔ mi ikye ani duu ka tun akpe ideli-ideli, a dika gyokwudɛ oshishe igyegwu. ");
INSERT INTO utr_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Nghaduu emi ababɔ kwuba ka yɛɛ emi olɛlɛ, emi olɛlɛ ma ka yɛɛ ababɔ. ");
INSERT INTO utr_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","<<Lubana esutɔ ongwi esho dzɛ dafi otsungwɔ okwɔ ntasɛ mi egbegbeegbe oka gbe inggisɛ nu ma wa kyɔn idɔ mi okwɔ awawekwɔ mgban mani. ");
INSERT INTO utr_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","O si gbela okpa ma awuya ngwi a li kpa emi idɔ mi egbe olɔlɔ man nu ma lu okwɔ mgban ka wita idɔ. ");
INSERT INTO utr_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","<<Mi obyi egyanɛ ongwi egbegbe o di tasɛ ka di angbeka gbeka to ifyidu le kyɔ unkonyi ba. ");
INSERT INTO utr_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","O nya ma gbɛɛ, <Ema kpaa lu ka kyɔ ani idɔ mi okwɔ na, ta n ka kpa ema awuya ngwi i wogyɔ okpa mani.> ");
INSERT INTO utr_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Nɛta a si lu. <<O di wa tasɛ mi obyi iwyodefa yi obyi ongwu ta dika kyɔ ngha. ");
INSERT INTO utr_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Ba obyi eda ongwi onɔdɛ, o tasɛ dika di angbeka kpɔɔ to imbe nani. O byi ma gbɛɛ, <Kyɔsinɛ ngwi ema to mmɛnɛ kyɛ egbegbe le kyɔ unkaba?> ");
INSERT INTO utr_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","A nu uka gbɛɛ, << <Ikyekyɛ inggisɛ onyi kpaa kye eyi idɔ ba.> <<O gbɔ yi ama gbɛɛ, <Ema kpaa lu ka kyɔ ani idɔ mi okwɔ na.> ");
INSERT INTO utr_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","<<Ngwi onɔ wa gbɛsɛ nɛ, otsungwɔ okwɔ ma nya inggisɛ nkye inɛ le byi emi idɔ mgbi ongwu ma gbɛɛ, <Kwu emi idɔ ela kpa ma awuya mgbi ama, wita mbi ama ani kye ma idɔ olɛlɛ lu mbi emi ababɔ.> ");
INSERT INTO utr_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","<<Ama ngwu a kye ma idɔ mi obyi eda ma, a kpa ma udza idɔ mgbi egbe olɔlɔ. ");
INSERT INTO utr_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Onɔ ngwi ama a kye ma idɔ ababɔ ba owa gbɛ awuya mgbi ama nɛ, a tsɛwɛ gbɛɛ ama ka nghao gbɛ. Nghaduu ama kpaa a kpa ma udza idɔ mgbi egbe olɔlɔ. ");
INSERT INTO utr_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Ngwi a kye gbɛlu nɛ, a wita okwu otsungwɔ okwɔ ondukwɔ. ");
INSERT INTO utr_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","A gbɛɛ, <Inggisɛ ama ngwu a kye ma idɔ olɛlɛ ntonɛ kyidɔ obyi onyi ta, ma abu kpa ma ungwonyi yi eyi ngwu tsigɛgɛ kyidɔ ni onɔ tsɛ eyi nghataa egbe olɔlɔ.> ");
INSERT INTO utr_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","<<Nghaduu o nu onyi mi ele uka gbɛɛ, <Anɔ, ani kyɔ ema ogye ba. Ema gbela okyidɔ egbe olɔlɔ mi udza ngwi a teyi li kpa ma baa? ");
INSERT INTO utr_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Kye awuya mgbi ema lu na. I mina ani okpa inggisɛ ngwu ani kyon idɔ olɛlɛ nɛ udza ungwonyi dafi ani kpa ema nɛni. ");
INSERT INTO utr_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Ani dzɛ yi ofɛ okyungwɔ ani mina yi awuya mgbi ani baa? Naadi le wulu ema ewo ikyegbɛɛ di ani kyɔ osuse yi angbeka?> ");
INSERT INTO utr_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","<<Nghanɛ emi olɛlɛ ka li ababɔ, emi ababɔ dika li olɛlɛ.>> ");
INSERT INTO utr_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Ngwi iYesu le kɛ iJerosalin nɛ, o gbe engwafɔ mgban iwyodefa ntona lu enggengga si nya ma gbɛɛ, ");
INSERT INTO utr_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","<<Eyi le lu iJerosalin, ma a ka kye Ongwɛ Inggisɛ wo engyukwo ama ofifɛ bɛyi etsetse mgbi ola abɔ. A ka ngwɔn ikwɔ ikwongye ");
INSERT INTO utr_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","dika yilon nu emi agwɛsɛ, a ka nyan agya di gbon onitse yɛ ngwɔn mi ekwatsi. Mi egbe ongwu ta ma a ka kyilen mi ikwu!>> ");
INSERT INTO utr_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Nɛ owa iDzebedi ba mbi iYesu yi emi ongwan engyulɔ, ngwi o gbe akwafɔ kwɛsɛ nɛ, o si mina abɔ oyaaya mbon. ");
INSERT INTO utr_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","IYesu byun gbɛɛ, <<Li ekyɛ ngwi abu mina?>> O gbɛɛ, <<Zondu yi ani gbɛɛ engwɛ ani efa ntonɛ, oka ka sɔ abu abugye oka dika sɔ abubɛ mi esutɔ mgbi abu.>> ");
INSERT INTO utr_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Nghaduu iYesu nya ma gbɛɛ, <<Ema ye ungwɔ ngwi ema le bɔ ma ba. Ema ka wa mi ibwɛ ngwi ani ka wa ma gbɛɛ?>> A nu uka gbɛɛ, <<Eyi ka wa.>> ");
INSERT INTO utr_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","IYesu nya ma gbɛɛ, <<Ema ka wa mi ibwɛ mgbi ani otsitsi. Nghaduu osɔ mi abugye hona abubɛ mgbi ani yɔ, li idɔ mgbi ani onu ofɛ ba. Imbe ntonɛ dzɛ ikye mgbi ama ngwu Otsani mɛ ikye ma mani.>> ");
INSERT INTO utr_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Onɔ ngwi iwyo ntona fwo ungwɔnɛ nɛ, a kyitingga yi engwuneka efa ntonani. ");
INSERT INTO utr_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Man iYesu si kwu ma ela kwakye gbɛɛ, <<Ema ye ama ngwu a di gbɛɛ a mɛ ogbe Udzengye teyi li kyɔ mfye mboma, engyukwo ama oshewo mi idzidzɛ ma li kyɔ mfye mi ikpewo ma. ");
INSERT INTO utr_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Dzɛ ngha yi ema ba. Tatase yɔ, ali inggisɛ nmina oyɛɛ angbodzi mi idzidzɛ ema yɔ, no li ongbidɔ mgbi ema kyɛmɛ-kyɛmɛ, ");
INSERT INTO utr_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","ali inggisɛ ndi mina oli ababɔ yɔ, no li ofyɛɛ mgbi ema kyɛmɛ-kyɛmɛ, ");
INSERT INTO utr_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","dafi Ongwɛ Inggisɛ kpaa ba gbɛɛ nu ma kyɔn idɔ ba, kpaa owa kyɔ-kyɔ inggisɛ idɔ, di kye oshishe mgban nu ikye odulu inggisɛ ibyibyi watɔ nɛni.>> ");
INSERT INTO utr_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Ngwi emi iYesu le dzata iJeriko nɛ, ijiji inggisɛ kyɛdɔn. ");
INSERT INTO utr_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Inggisɛ ama obinɛ efa sɔto ondoofɛ, ngwi a fwo gbɛɛ iYesu le nyɛ ofɛ na nɛ, a kweela gbɛɛ, <<Otsɛ, Ongwɛ iDevedi, di eyi elela!>> ");
INSERT INTO utr_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Ijiji inggisɛ ntona kyɔkyɔ yi ama di nya ma gbɛɛ nu ma dede, kpaa a nghao kweela duu gbɛɛ, <<Otsɛ, Ongwɛ iDevedi, di eyi elela!>> ");
INSERT INTO utr_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","IYesu kwulɛsɛ di kwu ma ela, si byi ma gbɛɛ, <<Li alungwɔ mina ema gbɛɛ ni ani kyɔ ema ele?>> ");
INSERT INTO utr_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","A nu uka gbɛɛ, <<Otsɛ, i mina eyi odinɛ.>> ");
INSERT INTO utr_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","IYesu si di ma elela man kye abɔ gbo ma inɛ. Labɔlabɔ mata inɛ kwulu loma man a kyɛdɔn. ");
INSERT INTO utr_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Ngwi iYesu yi engwafɔɔn dzɛ kwɛkwɛ yi iJerosalin wa kaka iBɛtifege mi Unggwɔ Olivi nɛ, iYesu si dɔ engwafɔɔn efa esɔ, ");
INSERT INTO utr_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","nya ma gbɛɛ, <<Kɛ ogalu ndzɛ ema iyayi nani, ni ema kaka jo ema ka di itaklimyi shadzɛ yi ongwan. Kyi shɛlu ma wa nin na. ");
INSERT INTO utr_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Kini inggisɛ byi ema ita yɔ, nyan gbɛɛ odzɛ wo Otsɛ yi ama ta inggisɛ ma ka byakpa nu ema ofɛ ni ema kye shɛlu luba.>> ");
INSERT INTO utr_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Ungwɔnɛ kiyayi ikye onu elodzɛ ngwi oyegbɔ gbɔ ma dondu yɛyɛ gbɛɛ: ");
INSERT INTO utr_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","<<Gbɔ nya ogalu mgbi iDzayɔn gbɛɛ, <Di utɔ mgbi abu, nkyɛ le ba mbi abu na, o le dumɔɔ di kyɛ le ba mi ikye itaklimyi, mi ikye ongwɛ itaklimyi.> >> ");
INSERT INTO utr_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Engwafɔ ntonɛ ka kyɔ yɛyɛ dafi iYesu dɔ ma esɔ mani. ");
INSERT INTO utr_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","A kye itaklimyi yi ongwɛ itaklimyi ongyulɔ na ba, gbe angwuto mgbi ama tukwu ma kɛ ekpo man iYesu dɔkɛ ele. ");
INSERT INTO utr_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Ibyi inggisɛ kwuba gbe angwuto mgbi ama takɛ ofɛ, angbeka dzɛ afutse gbe takɛ ofɛ. ");
INSERT INTO utr_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Ibyi inggisɛ ama nteyin bɛyi ama nkyan iyikpa gbakwɔ gbɛɛ, <<Osana, mbi Ongwɛ iDevedi! Mse dzɛ yi ongwu nba mi iyi mgbi Otsɛ mani!>> ");
INSERT INTO utr_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Ngwi iYesu kaka iJerosalin nɛ, ogalu tsatsa yɛɛ yayaaya, a sile byita gbɛɛ, <<Nɛnɛ li emɛ lo?>> ");
INSERT INTO utr_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Ibyi inggisɛ ntona nu uka gbɛɛ, <<Nɛnɛ li iYesu, oyegbɔ nkyɛ iNadzareti mi iGalalia mani.>> ");
INSERT INTO utr_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","IYesu kaka ozu okwukwo osunu Imgbasho mi iJerosalin man kye lɔlu ama okyummya mi imbe na tasɛ. O kyi kyata adinyatsɛ mgbi ama onyinɛ awuya tukwukɛ esɛ, bɛyi itse otunto mgbi ama okye anyama gya. ");
INSERT INTO utr_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","O nya ma gbɛɛ, <<Afɛ lɔ gbɛɛ, <Ozu mgbi ani ka li ozu ibɔ,> kpaa ema kye kyata yɛɛ imbe mgbi <ama ozoofɛ.> >> ");
INSERT INTO utr_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Emi obinɛ yi ama otummya ba mbon mi ozu okwukwo osunu Imgbasho mi iJerosalin, ta o ngyɛlu ma ootse. ");
INSERT INTO utr_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Kpaa itingga kyɔ engyukwo ama ofifɛ yi etsetse mgbi ola ngwi a di ungwɔ ama okwulewo ngwi iYesu kyɔ di fwo ɛngbɛ tole gbakwɔ mi ozu okwukwo osunu Imgbasho mi iJerosalin gbɛɛ, <<Osana mbi Ongwɛ iDevedi mani.>> ");
INSERT INTO utr_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","A byun gbɛɛ, <<Abu fwo odzɛ ngwi ɛngbɛ ntonɛ le gbɔ nɛ wɛ?>> IYesu gbɛɛ, <<Ɛɛn, abu teyi gbɔ imbe ngwi Afɛ gbɛɛ, << <Ɛngbɛ yi engweyeyi kale shashi otsɛɛtsɛ na lo?>> ");
INSERT INTO utr_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","O si dzata ma tasɛ mi ogalu na lu ka la iBetani. ");
INSERT INTO utr_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Mi egbegbeegbe ngwi iYesu yɛ le luba ogalu nɛta enbwa dɔn. ");
INSERT INTO utr_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","O dili andundu mi ondoofɛ, si kɛ kwɛkwɛ kpaa tu unka mi ele ba sede afɛ ta. O si gbɔ yan gbɛɛ, <<Abu ka wa owawa wuba!>> Labɔlabɔ mata ekwɔ na ngweeni. ");
INSERT INTO utr_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Ngwi engwafɔɔn dili ungwɔnɛ nɛ, ewo waa loma man a byita gbɛɛ, <<I kyɔsinɛse andundu nɛ ngweeni vla ngha?>> ");
INSERT INTO utr_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","IYesu nu uka gbɛɛ, <<N le nya ema otsitsi, ni ema noyɛyɛ di dzɛ yi itukwu efefa bayɔ, ema ka kyungwɔ ngwi a kyɔ yi ekwɔ andundu nɛ ta ba, kpaa ema ka yagba nya unggwɔ gbɛɛ, <kye ewabu lu ka ngwuta wokɛ ekyoo okwukwo> o dika kyɔ ngha yɛyɛ. ");
INSERT INTO utr_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Alungwɔ ngwi ema bɔ mi ibɔ di noyɛyɛ yɔ, a ka nu ema.>> ");
INSERT INTO utr_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","IYesu kaka akangga ozu okwukwo osunu Imgbasho mi iJerosalin, dafi o le tso nɛman engyukwo ama ofifɛ bɛyi engyukwo emi Israi ba mbon wa byun gbɛɛ, <<Li mi ali mfye ngwi abu le kyungwɔnɛ, li emɛ nu abu mfye nɛ?>> ");
INSERT INTO utr_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","IYesu gbɛɛ, <<Ani kpaa ka byi ema ita onyi. Ni ema nu ani uka yɔ, n ka nya ema mfye ngwi ani le kyungwɔ ntonɛ mani. ");
INSERT INTO utr_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","IBatisima mgbi iJɔn kyɛ mi ole? Li mi esho mbi Imgbasho naadi li mbi inggisɛ?>> A kponya yi ewoma mi odzɛ nɛ si gbɛɛ, <<Kini eyi gbɛɛ, <Li mi esho yɔ,> o ka byita gbɛɛ, <Nghanɛ kyɔsinɛ ngwi ema nun oyɛyɛ ba?> ");
INSERT INTO utr_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Kpaa ni eyi gbɛɛ, <Li mbi inggisɛ yɔ> eyi le pyio inggisɛ, lubana inggisɛ duu gbela gbɛɛ iJɔn li oyegbɔ.>> ");
INSERT INTO utr_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Nghanɛ a si nu iYesu uka gbɛɛ, <<Eyi ye ba.>> O gbɛɛ, <<Ngyɛse ani kpaa ka nya ema mfye ngwi ani le kyungwɔ ntonɛ ba.>> ");
INSERT INTO utr_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","<<Ema tsɛwɛ sinɛ? Ongyulɔ oka nose dzɛ, o dzɛ yi engwengyulɔ efa. O kɛ mbi ongwu ongyukwo ka nyan gbɛɛ, <Ongwani, lu ka kyidɔ inɛ mi okwɔ.> ");
INSERT INTO utr_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","<<O fwa gbɛɛ, <N ka kɛ ba,> nghaduu o wa kyatitukwu yɛ kɛ. ");
INSERT INTO utr_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","<<Nɛ otsɔma yɛ kɛ mbi ongwan oka na dika nyan ngha yɛyɛ. O nya otsɔn gbɛɛ, <N gbela, otsani,> kpaa o kɛ wuba. ");
INSERT INTO utr_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","<<Mi idzidzɛ ama efa ntonɛ ma, li ole kyɔ itukwu otsɔn?>> A gbɛɛ, <<Ongwu ongyukwo nani.>> IYesu nya ma gbɛɛ, <<N le nya ema otsitsi, ama ogbɛ udza ifyɛɛ yi owagbai engyaa ka kaka esutɔ mgbi Imgbasho kise ema. ");
INSERT INTO utr_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Lubana iJɔn ba mbi ema owa tso ema ofɛ mgbi osaan, kpaa ema nun oyɛyɛ ba, nghaduu ama ogbɛ udza ifyɛɛ yi owagbai engyaa ntona nun oyɛyɛ. Ngwi ema di ungwɔ ntonɛ nɛ kpaa ema yagba kyata noyɛyɛ ba. ");
INSERT INTO utr_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","<<Gadɔ mi utsa oka: Otsungwɔ ikpɛsɛ oka nose ye ekwɔ. O loka won, o tishɛ ogbe eni awawekwɔ, di ta otila ongyo okwɔ. O kye okwɔ ma wo emi okwɔ angbeka abɔ si lu agaba. ");
INSERT INTO utr_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Ngwi onɔ oshɛɛtɔ wa dzɛ kwɛkwɛ nɛ, o dɔ engbidɔ mgban esɔ mbi ama ngwu o kye okwɔ wo ma abɔ ntona gbɛɛ nu ma ka gbɛ owawekwɔ mgban wa nun. ");
INSERT INTO utr_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","<<Emi okwɔ ntona kye bwalu ɛngbɛ ntonɛ; a gbo oka ibe, ngwɔlu oka, di tsɛ ongwu ta ma ikwutsɛ. ");
INSERT INTO utr_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Nghanɛ o diyɛ dɔ engbidɔ esɔ nghaabɔ ogbugbe, emi okwɔ ntona di kyɔ yi ama ngha yɛyɛ. ");
INSERT INTO utr_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","O dɔ ongwan abuon esɔ olɛlɛ, o gbɛɛ, <a ka nu ongwani mmwɛ.> ");
INSERT INTO utr_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","<<Nghaduu ngwi emi okwɔ ntona dili ongwan nɛta, a gbɔ yi ewoma gbɛɛ, <Nɛnɛ li ongwu nka gyokwudɛ ma aani, ba ni i tawon azukwu ni okwudɛ yɛɛ mgbi eyi.> ");
INSERT INTO utr_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","A bwan kyon ngwi nyɛ ikyiishi mgbi okwɔ ekwɔ na lu esɛ di ngwɔn. ");
INSERT INTO utr_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","IYesu byi ma gbɛɛ, <<Itɔ ungwɔnɛ ma, ni otsungwɔ okwɔ na wa ba ma, o ka kyɔ yi emi okwɔ ntona sinɛ?>> ");
INSERT INTO utr_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","A nu uka gbɛɛ, <<O ka dzili emi imbali ntona mi ikwu elela, di yile okwɔ na wo emi okwɔ angbeka abɔ, ama nkale nun awawekwɔ mgban mi alonɔ oshɛɛtɔ duu mani.>> ");
INSERT INTO utr_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","IYesu gbɔ yi ama gbɛɛ, <<Ema gbɔ mi Afɛ ngbɛɛ, << <Ikwutsɛ ngwi ama ombɛ ozu fwan ma li ongwu yɛ kwulu ikye ozu mi esho na ye wa lo; Ungwɔnɛ li ungwɔ ngwi Otsɛ kyɔ, ma i kwulewo mi inɛ mgbi eyi badɛɛn>? ");
INSERT INTO utr_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","<<Nghanɛ n le nya ema gbɛɛ a ka kyi kyelu esutɔ mgbi Imgbasho mbi ema yilen kye nu inggisɛ ama nka ba yi owawan mani. ");
INSERT INTO utr_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","(Inggisɛ ngyɛkɛ ikwutsɛ nɛ ka fwa ambulu-ambulu, kpaa ongwu ikwutsɛ nɛ gyan yɔ o ka jiyɛ.>>) ");
INSERT INTO utr_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Onɔ ngwi engyukwo ama ofifɛ bɛyi emi iFarasi fwo utsa mgbi iYesu nɛ, a yeta gbɛɛ o le gbɔdzɛ nɛ ikye mgbi ama. ");
INSERT INTO utr_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","A pita ofɛ ni ama kpaklin, nghaduu a pyio ibyi inggisɛ ntonani, ikyekyɛ inggisɛ noyɛyɛ gbɛɛ o li oyegbɔ. ");
INSERT INTO utr_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","IYesu diyɛ gbɔdzɛ yi ama mi utsa kpɔɔ gbɛɛ: ");
INSERT INTO utr_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","<<Esutɔ mgbi Imgbasho dzɛ dafi utɔ nwewo oga eba okwokyiikwokyi ikye ongwan ongyulɔ mani. ");
INSERT INTO utr_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","O dɔ engbidɔ mgban esɔ mbi ama ngwu a bɔ ma oga ma gbɛɛ nu ma ba, nghaduu a fwa obaaba. ");
INSERT INTO utr_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","<<Nɛ o diyɛ dɔ engbidɔ angbeka esɔ kpɔɔ gbɛɛ, <Nya ama ngwu ani bɔ ma oga ma gbɛɛ ani ngyɛlu ungwogye okyɔɔkyɔ wa: Mnda mgbi ani ongyulɔ yi mnda olubu-lubu a ngwɔ di kye fwalu ma wa, nɛ alungwɔ duu dzɛ le fɛ-fɛ. Ba oga eba okwokyiikwokyi na.> ");
INSERT INTO utr_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","<<Kpaa a nu itukwu mi ele ba di lu ungwɔ ma, oka lu okwɔ mgban, oka lu mmya mgban. ");
INSERT INTO utr_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Angbeka ama nsisi ma kpali engbidɔ ntona nu ma isɔ di ngwɔlu ma. ");
INSERT INTO utr_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Utɔ na si nyɛ yi itingga. O dɔ ogbakwu mgban esɔ ka dzili ama ongwɔ inggisɛ ntona di kye ma ogalu toola. ");
INSERT INTO utr_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","<<Nɛman o nya engbidɔ mgban gbɛɛ, <Oga eba okwokyiikwokyi nɛ gyɔ wa, ama ngwu ani bɔ ma ma, a mɛ oba ba. ");
INSERT INTO utr_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Lu imbe ngwi ofɛ gha, ka bɔ ali inggisɛ ngwu ema tu duu oga nɛni.> ");
INSERT INTO utr_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Ta engbidɔ ntona tasɛ lu emi ingɔfɛ ka wulu inggisɛ ngwu ma tu duu, ama osuse yi obube wa yaokɛ, ozu oga byakpa flengba yi ingyoga. ");
INSERT INTO utr_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","<<Nghaduu ngwi utɔ ba owa kpadi ingyoga nɛta, o dili ongyulɔ oka n wo angwuto oga ba mi ele. ");
INSERT INTO utr_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","O byita gbɛɛ, <Uka, abu nyɛ ole kaka mmɛnɛ ngwi abu wo angwuto oga ba?> Ongyulɔ na byakpa ndɛ wifwɛ. ");
INSERT INTO utr_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","<<Nɛ utɔ nya ama ogbe inɛ byi oga gbɛɛ, <Bwalun abɔ yi afɔ, kyon ngwuta lu esɛ mi iifu, imbe ngwi ikwu otseetse bɛyi aba ogyeegye ka dzɛ mani.> ");
INSERT INTO utr_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","<<Lubana a bɔ inggisɛ kwuba, kpaa li gwee ta ngwi a sadu.>> ");
INSERT INTO utr_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Nghanɛ emi iFarasi tasɛ ka tsɛwɛ ofɛ ngwi ama ka non gbo mi elodzɛ ni ama bwan. ");
INSERT INTO utr_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","A dɔ engwafɔ mgbi ama bɛyi emidi iHerude esɔ mbon. A gbɛɛ, <<Otsetse, eyi ye abu li inggisɛ oyɛyɛ, abu di li tso ofɛ mgbi Imgbasho mi otsitsi. Inggisɛ li yagba tu abu wo ba ikyekyɛ i kwokyi abu yi odzɛɛdzɛ mgbi ama ba. ");
INSERT INTO utr_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Nya eyi ka, abu di sinɛ? Li ola ni eyi kpa iSidza udza ifyɛɛ naadi li ola ba?>> ");
INSERT INTO utr_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Nghanɛ iYesu difwi owitukwu mgbi ama obube, nɛ o gbɛɛ, <<Ema emi ikpala ntonɛ, kyɔsinɛ ngwi ema le mina okya ani ukya? ");
INSERT INTO utr_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Tso ani iwai awuya ngwi ema li kpa ifyɛɛ ele ma na.>> A kye ikobo mgbi ama ba wa tson, ");
INSERT INTO utr_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","O byi ma gbɛɛ, <<Li onodzi bɛyi olɔɔlɔ mgbi emɛ dɛn?>> ");
INSERT INTO utr_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","A nu uka gbɛɛ, <<Li mgbi iSidza.>> O si nya ma gbɛɛ, <<Kye ungwɔ nli mgbi iSidza nu iSidza, di kye ungwɔ mgbi Imgbasho nu Imgbasho.>> ");
INSERT INTO utr_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Ngwi a fwo odzɛ nɛ mata ewo fwɛ loma. Man a dzatan lu imbe oka. ");
INSERT INTO utr_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Mi egbe na kpɔɔ, emi iSadusi, ama nli gbɛɛ okyɛɛ mi ikwu dzɛma ba ma, ba mbon yi ita. ");
INSERT INTO utr_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","A gbɛɛ, <<Otsetse, iMose nya eyi gbɛɛ ni ongyulɔ tu ongwɛ ba ta kwulu yɔ, ni ongwunɔn yile owakwadɛ na kyɛmɛ-kyɛmɛ mban ɛngbɛ. ");
INSERT INTO utr_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Engwunɔ ewoma engyulɔ nghi egyafa to yi eyi. Ongwu ababɔ kye ongyaa kpaa kye okwudɛ dzɛ ba man kwulu dzata owan nu ongwu fan. ");
INSERT INTO utr_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Ongwu na bɛyi ongwu ta nghataa lu mbi ongwu gyafa duu a tu ongwɛ ba. ");
INSERT INTO utr_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Mi ongyɛɛngyɛ yɔ ongyaa na kpaa wa kwulu. ");
INSERT INTO utr_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Nghanɛ mi onɔ okyɛɛ mi ikwu ma, o ka li owa emɛ yɛyɛ mi idzidzɛ ama egyafa na, ngwi ama duu kyon?>> ");
INSERT INTO utr_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","IYesu nu uka gbɛɛ, <<Ema le wɛndɛ, ikyekyɛ ema ye odzɛ ngwi Afɛ gbɔ hona mfye mgbi Imgbasho ba. ");
INSERT INTO utr_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Mi onɔ okyɛɛ mi ikwu ma, inggisɛ ka kye ongyaa hona kye ongwɛ nu eba ba; a ka to dafi engyesɔ emi esho mani. ");
INSERT INTO utr_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Kpaa mi odzɛ okyɛɛ mi ikwu yɔ, ema gbɔ ungwɔ ngwi Imgbasho nya ema ngwi o gbɛɛ, ");
INSERT INTO utr_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","<Ani li Imgbasho ngwu Abrahan, Adziki, yi iJeko le sunun mani.> O li Imgbasho mgbi emi ikwukwɔ ba kpaa mgbi emi oshishe.>> ");
INSERT INTO utr_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Ngwi inggisɛ ntona fwo otsootso mgban nɛ, i kwulu ma ewo. ");
INSERT INTO utr_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Ngwi emi iFarasi fwo gbɛɛ iYesu gbɔdzɛ dzɛ emi iSadusi umyɛ nɛ, a wa kwakye yi ewoma. ");
INSERT INTO utr_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Onyi mboma, n ye Ola mgbi emi iJuda saan, mbadin yi ita nɛ gbɛɛ: ");
INSERT INTO utr_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","<<Otsetse, li Ola ole nghaangha mi Ola duu?>> ");
INSERT INTO utr_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","IYesu nu uka gbɛɛ, << <Otsɛ Imgbasho mgbi abu no kpa abu yi eka mgbi abu duu, yi oshishe mgbi abu duu, bɛyi itukwu mgbi abu duu.> ");
INSERT INTO utr_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Nɛnɛ li ola ongwi ababɔ di nghaangha joni. ");
INSERT INTO utr_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ongwu fan ndzɛ dafi ongwunɛ yɔ, inggisɛ nwatse dɔ abu no kpa abu itukwu dafi ewabu mani. ");
INSERT INTO utr_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Ola yi emi Oyegbɔ duu kye abɔ byi ola efa ntonɛni.>> ");
INSERT INTO utr_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Ngwi emi iFarasi kwakye to mbonyi nɛ, iYesu byi ma gbɛɛ, ");
INSERT INTO utr_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","<<Ema tsɛwɛ sinɛ mi odzɛ iMedzaya? O li ongwɛ emɛ?>> A gbɛɛ, <<O li Ongwɛ iDevedi.>> ");
INSERT INTO utr_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","O gbɔ nya ma gbɛɛ, <<I wo sinɛ ngwi iDevedi nose le gbɔdzɛ mi Onodzi se kwun gbɛɛ <Otsɛ>? Bana o gbɛɛ, ");
INSERT INTO utr_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","<< <Otsɛ Imgbasho gbɔ nya Otsɛ mgbi ani gbɛɛ: <<Sɔkɛ abugye mgbi ani nghataa nin wa nu engyikyili mgbi abu, yɛɛ itse mgbi abu ogbe afɔ to ele.>> > ");
INSERT INTO utr_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Ni iDevedi kwun di <Otsɛ iMedzaya> wali, kyɔsinɛ ngwi o dika li ongwan?>> ");
INSERT INTO utr_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Inggisɛ onyi yagba dulu elodzɛ nun uka gbɛ ba, wita mi egbe na lu iyayi inggisɛ onyi fya-fya byun ita wuba. ");
INSERT INTO utr_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Nɛta iYesu si nya ibyi inggisɛ ntona bɛyi engwafɔɔn gbɛɛ: ");
INSERT INTO utr_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","<<Etsetse mgbi ola ntonɛ bɛyi emi iFarasi li sisɛ mi itse mgbi iMose. ");
INSERT INTO utr_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Nghanɛ ema ka kyɛdɔ elodzɛ mgbi ama, di kyungwɔ ngwi a nya ema gbɛɛ ni ema kyɔ duu. Kpaa ka kyɛdɔ okyɔɔkyɔ mgbi ama ba na, ikyekyɛ a li kyungwɔ ngwi ama li gbɔn ma ba. ");
INSERT INTO utr_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","A li kwu okye kpakpa dɔ inggisɛ ikye, kpaa ama abuoma li wewo okye ongwufabɔ gbo ele ba. ");
INSERT INTO utr_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","<<Alungwɔ ngwi a kyɔ duu li ikyegbɛɛ ni inggisɛ di ama: A li lɔ ambulu ibyibyilo wokɛ ongwiimu kye bwakɛ ebeshu bɛyi alubɔ, a di li nu ondu angwuto mgbi ama tunto ikye ni inggisɛ di gbɛɛ di ama le sunu Imgbasho. ");
INSERT INTO utr_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Li kpa ma osɔ imbe mmwɛ mi oga, bɛyi itse onghaangha mi ozu okwakye mgbi emi iJuda; ");
INSERT INTO utr_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","A li mina gbɛɛ a kile ta ama angba kyɛ ifyidu ni a di kwu ama gbɛɛ <Etsetse okwukwo.> ");
INSERT INTO utr_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","<<Nghaduu tishi nu ma kwu ema di <Etsetse okwukwo> ba, lubana ema dzɛ yi ongyukwo onyi ta, ema duu li ongwunɔ ewema. ");
INSERT INTO utr_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Dika kwu inggisɛ onyonyi mi ɛsɛ nɛ di <Otsema> ba, bana ema sulu Otsema Onyi ta, o dzɛ esho. ");
INSERT INTO utr_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Li ayin ba nu ma kwu ema gbɛɛ <otsetse,> ikyena ema sulu Otsetse Onyi kyoon, o li iMedzaya. ");
INSERT INTO utr_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ongwu nshewo ngha mi idzidzɛ mgbi ema ma ka li ongbidɔ mgbi ema. ");
INSERT INTO utr_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Lubana ali inggisɛ nkyile ewon esho yɔ a ka yilen esɛ, kpaa inggisɛ n yile ewon esɛ yɔ a ka kyilen esho. ");
INSERT INTO utr_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","<<Ikamba ikye ema etsetse mgbi ola bɛyi emi iFarasi, ema emi ikpala ntonɛni! Ema tukwu inggisɛ ofɛ okaka esutɔ ongwi esho, ema abuema kpaa kaka ba, ama nle fya okaka ma kpaa ema le nu ma ofɛ okaka ba. ");
INSERT INTO utr_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","(<<Ahoo ikye ema, etsetse mgbi ola yi emi iFarasi, ema emi ikpala ntonɛni! Ema li kyɔ emi owakwadɛ ogye di tso osaan mi ibɔ obɔ tunto. Nghanɛ Imgbasho ka kwo ema adɔ kpakpa.>>) ");
INSERT INTO utr_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","<<Ahoo ikye ema, etsetse mgbi ola yi emi iFarasi, ema emi ikpala ntonɛni! Ema li ga kwo ekyoo okwukwo yi ɛsɛ tsatsa ikye otu inggisɛ onyi ongwu nka kyɛdɔ ema, ni ema wa tun yɔ, ema di li non yɛɛ ongbɛ mgbi udola dzɛ ema wo akpe efa.>> ");
INSERT INTO utr_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","<<Ikamba ikye ema, obinɛ ama ngbe inggisɛ teyi! Ema li gbɛɛ, <Ni inggisɛ fa yi ozu okwukwo osunu Imgbasho yɔ li itɔdzɛ ba; kpaa ni inggisɛ fa yi abashi mgbi ozu okwukwo osunu Imgbasho yɔ, o ka kyɔn kyɛmɛ-kyɛmɛ. ");
INSERT INTO utr_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Ema ikwangha obinɛ ntonɛ! Li ole ngha: abashi, naadi ozu okwukwo osunu Imgbasho ngwi nu abashi yɛɛ saan na? ");
INSERT INTO utr_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Ema di li gbɛɛ, <Kini inggisɛ fa mi iwashi yɔ li itɔdzɛ ba; kpaa ni inggisɛ fa yi umba ndɔdzɛ ele na yɔ, o ka kyɔn kyɛmɛ-kyɛmɛ.> ");
INSERT INTO utr_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Ema obinɛ ntonɛ! Li ole ngha: umba na, naadi iwashi ngwi nu umba na yɛɛ saan na? ");
INSERT INTO utr_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Nghanɛ, inggisɛ nfa yi iwashi yɔ, o fa yi iwashi bɛyi alungwɔ ndɔdzɛ ele duu. ");
INSERT INTO utr_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Inggisɛ ndi fa yi ozu okwukwo osunu Imgbasho yɔ, o fa mi ele bɛyi Imgbasho ndzɛ ele na kpaa. ");
INSERT INTO utr_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Inggisɛ nfa mi esho yɔ, o fa mi itsuutɔ mgbi Imgbasho bɛyi ongwu nsɔdzɛ ele nani. ");
INSERT INTO utr_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","<<Ahoo ikye ema, etsetse mgbi ola yi emi iFarasi, ema emi ikpala ntonɛni! Ema li nu onyi ikye iwyo mi alungwɔ ama nli nu ungwogye gbungbɛ duu. Nghaduu ema li kye ola nnghao wuuta ma wuuta ba, emyɛmyɛ yi elela odiidi oyɛyɛ okyɔɔkyɔ. Ema ki nghao le kyɔ ama nwuuta ntonɛ duuse angbeka ntonani. ");
INSERT INTO utr_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Ema obinɛ ama ogbe inggisɛ teyi ntonɛ! Ema li sɛlu imatsɔ mi eni mgbi ema owaawa yangwuta kpaa kye ilakwumyi mbe. ");
INSERT INTO utr_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","<<Ikamba mi ikye ema, etsetse mgbi ola yi emi iFarasi, ema emi ikpala ntonɛ! Ema li salu ewo inumbɛɛ yi inunggaa, kpaa mi ifun yɔ li mbwo yi nggwɔ yi ofu. ");
INSERT INTO utr_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Emi iFarasi ama obinɛ! Teyi kyi salu inumbɛɛ yi inunggaa mi ifun, ta esaan kpaa ka yɛɛ saan. ");
INSERT INTO utr_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","<<Ahoo ikye ema, etsetse mgbi ola yi emi iFarasi, ema emi ikpala ntonɛni! Ema dzɛ dafi endzi ngwi a gbon enotse onzundzɛ, ngwi i tishi odiidi mi esɛ kpaa mi ifun yɔ akpukpu mgbi emi ikwukwɔ li mbweele bɛyi alungwɔ ama okpɛkpɛ duu mani. ");
INSERT INTO utr_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Mi itɔ ofɛ nɛ kpɔɔ, ema li tso inggisɛ gbɛɛ ema le saan kpaa mi idzidzɛ yɔ, ema mbwo yi oshu yi imbali. ");
INSERT INTO utr_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","<<Ahoo ikye ema, etsetse mgbi ola yi emi iFarasi, ema emi ikpala ntonɛni! Ema li mbɛ endzi mgbi ama ogbɛɛsɛ diyɛ mɛ endzi mgbi inggisɛ ama osuse ingwinda. ");
INSERT INTO utr_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Ema di gbɛɛ, <Ni ema ki dzɛ mi onɔ mgbi otsikyema tugbe mayɔ, ema kika wo abɔ mi ikwu mgbi ama ogbɛɛsɛ ba.> ");
INSERT INTO utr_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Nghanɛ ema kyɔ ewema obwɛndɛ obube dafi ema gbɛɛ di ema li engwiba mgbi ama nngwɔ ama ogbɛɛsɛ mani. ");
INSERT INTO utr_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Kiyayi ngyɛlu ungwɔ ngwi emi otsikyema wita nani! ");
INSERT INTO utr_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","<<Ema ifa! Emi ongwɛ ogidzi ntonɛ! Ema ka kyɔsinɛse ngwi a ka ngwɔ ema ikwɔ ni ema lu udola ba? ");
INSERT INTO utr_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Nghanɛ ani le kye ama ogbɛɛsɛ yi ama oyodzɛ bɛyi etsetse dɛsɔ nu ema. Angbeka mboma ema ka ngwɔ di gbokwo ma; angbeka yɔ ema ka gbo ma onitse mi ozu okwakye mgbi emi iJuda dika lɔ ma tɔ mi igeli oka lu igeli oka. ");
INSERT INTO utr_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Ikyenghanɛ, a ka bwa ema mi ikye ikwu mgbi inggisɛ ama osaan ngwu a ngwɔ mi ɛsɛ nɛ duu, wita mi ikwu inggisɛ osaan Ebɛl lu mi ikwu iDzakaria ongwɛ iBɛlɛkia ngwu ema ngwɔ mi idzidzɛ ozu okwukwo osunu Imgbasho bɛyi iwashi ofifɛ nani. ");
INSERT INTO utr_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","N nya ema otsitsi, ungwɔnɛ duu ka dɔ etɔ nɛ ikye. ");
INSERT INTO utr_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","<<Ekyi! iJerosalin, iJerosalin, abu nngwɔ ama ogbɛɛsɛ di tsɛ ama ngwu a dɔ ma esɔ mbi abu akwutsɛ nɛ, onɔ kɛ ngwi ani gbili ogbe emi ongwabu kwakye mbonyi dafi onogbi li kwulu engwaan wo asha nɛni, nghaduu abu gbela ba. ");
INSERT INTO utr_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Dika, a dzata ozu okwukwo mgbi ema osunu Imgbasho yɛɛ okwudɛ waana. ");
INSERT INTO utr_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Lubana n nya ema, ema ka din wuba se ni ema wa gbɛɛ, <Mse dzɛ yi ongwu nba mi iyi mgbi Otsɛ na se.> >> ");
INSERT INTO utr_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","IYesu dzata ozu okwukwo osunu Imgbasho mi iJerosalin le lu imbe oka man engwafɔ mgban gble tun ikye onyan odzɛ idabɔ mgbi ozu nani. ");
INSERT INTO utr_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","O byi ma gbɛɛ, <<Ema di ozu ntonɛ duu wɛ? N nya ema otsitsi a ka wa dzata akwutsɛ onyi kpaa dɔ ikye oka ba; a ka bulu ma duu kwutokɛ esɛ.>> ");
INSERT INTO utr_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Dafi iYesu sɔdzɛ unggwɔ Olivi nɛ, engwafɔɔn ba mbon fyɛɛ, a gbɛɛ, <<Nya eyi, li alonɔ ngwi ungwɔnɛ ka kyɔ, ma li alungwɔ ka tso ambɛ mgbi obaaba mgbi abu yi mgbi ongyɛɛngyɛ ɛsɛ?>> ");
INSERT INTO utr_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","IYesu nu uka gbɛɛ, <<Gbɛwɛbyi saan na, ni inggisɛ wa kpagya ema wo ba. ");
INSERT INTO utr_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Lubana inggisɛ kwuba ka ba mi iyi mgbi ani, le gbɛɛ, <Ani li iMedzaya,> a dika kpagya inggisɛ kwuba wo. ");
INSERT INTO utr_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Ema ka fwo ika yi a gbɛɛ mgbi ika, kpaa ka tsaatsa ewo ba na. Itɔ ungwɔ ntonɛ ka kyɔ kyɛmɛ, nghaduu ongyɛɛngyɛ ka kyɛ iyayi. ");
INSERT INTO utr_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Ɛsɛ oka ka kyɛɛ ika yi ɛsɛ oka, esutɔ oka ka kyɛɛ ika yi esutɔ oka. Obyoyanu (enbwa) yi ɛsɛ osuusu ka dzɛ mi imbe idzidza-dzidza. ");
INSERT INTO utr_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Ungwɔ ntonɛ duu li owita-wita mgbi isɔ. ");
INSERT INTO utr_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","<<Nɛta a ka bwa ema lu ka nu ema isɔ di ngwɔ ema, ɛsɛ duu ka di ema lanyi mi ikye ani. ");
INSERT INTO utr_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Mi onɔ na inggisɛ kwuba ka yɛyikpa mi oyɛyɛ onuunu yɛ kye ewoma dakwɔ diyɛ di ewoma lanyi, ");
INSERT INTO utr_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","oyegbɔ atsika kwuba ka tɔ di kpagya inggisɛ kwuba wo. ");
INSERT INTO utr_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Ikyegbɛɛ ali ibwubwe ka wa gbɔfwɛ nɛ, okpitukwu mgbi inggisɛ kwuba ka yuyu, ");
INSERT INTO utr_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","nghaduu inggisɛ nkwulɛsɛ kpɔklɔɔ ba ongyɛɛngyɛ yɔ, o ka watɔ. ");
INSERT INTO utr_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Esɔ Osuse mgbi esutɔ nɛ a ka gbɔn mi ɛsɛ tsatsa dafi obwɛndɛ mbi ayɛsɛ duu mani, taman ongyɛɛngyɛ mgbi ɛsɛ sika ba. ");
INSERT INTO utr_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","<<Onɔ ngwi ema di <Ungwɔ Idza> yɛ wa dzɛ mi ozu okwukwo osunu Imgbasho mi iJerosalin dafi oyegbɔ iDaniɛ teyi gbɔ na yɔ, inggisɛ ogbɔ afɛ no difwi ");
INSERT INTO utr_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","nɛ ama nto mi iJudia duu nu ma tsinya lu unggwɔ. ");
INSERT INTO utr_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Ni inggisɛ onyi ndɔdzɛ endoozu mgban tashulu o wa kye unkonyi tasɛ mi ozu ba. ");
INSERT INTO utr_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ni inggisɛ onyi mi okwɔ ka yidɔ kɛ iyikpa oka gbe angwuto mgban ba. ");
INSERT INTO utr_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Egbe ntona ka li egbe obube kpakpa mbi engyaa emi ifu bɛyi enengwɛ ama nbyi engwɛ abɔ! ");
INSERT INTO utr_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Bibɔ na, ni onɔ otsinya mgbi ema na no wa li owa hona egbe otonyewo ba. ");
INSERT INTO utr_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Lubana onɔ na ka li onɔ adzɛ yi omani itɔ ngwi a ta ɛsɛ inose nghataa ba nɛnɛ lu iyayi kpaa a di ye waba mani. ");
INSERT INTO utr_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Ni Imgbasho ki kye mwalu egbe ntona bayɔ, inggisɛ onyi ki watɔ ba, kpaa mi ikye ama ngwu a plɛ sadulu ma ma yɔ, Imgbasho ka kyi mwalu egbe ntonani. ");
INSERT INTO utr_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Mi onɔ na ni inggisɛ nya abu gbɛɛ, <Dii, iMedzaya dzana!> Hona, <O dzali!> Ka noyɛyɛ mi ele ba. ");
INSERT INTO utr_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Lubana Imedzaya atsika yi oyegbɔ emi atsika ka wa gbɔfwɛ di tso ambɛ okwukwo yi ungwɔ ama okwulewo ikye okpagya ama ngwu a sadu ma kpaa wo, ni li kyɛmɛ-kyɛmɛ yɔ. ");
INSERT INTO utr_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Dika, n plɛ nya ema duuse ni onɔ ma wa gyɔ. ");
INSERT INTO utr_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","<<Nghanɛ ni inggisɛ nya ema gbɛɛ, < O tɔ dzɛ imbe okplagada aali,> ka tasɛ ba, hona, <O wodzɛ ifoozu ana,> ka noyɛyɛ mi ele ba. ");
INSERT INTO utr_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Lubana dafi mmbwo li naabɔ mi onosa ngwi a li di to onɔdɛ nɛ, li ngha ngwi obaaba mgbi Ongwɛ Inggisɛ ka dzɛ aali. ");
INSERT INTO utr_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Li imbe ngwi ikwɔ la ma ngwi mmpo li kwakye aali. ");
INSERT INTO utr_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","<<Ni egbe okakewo okwukwo wa nyɛ gwee taman, << <onɔ ka yifu, ofyia kpaa ka fya wuba, mcɛ ka yangwuta mi esho, a ka su mfye emi esho.> ");
INSERT INTO utr_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","<<Mi onɔ na ambɛ mgbi Ongwɛ Inggisɛ ka tɔ mi esho, man ali ayɛsɛ mi ɛsɛ nɛ duu ka nyɛ yi ikwu. A ka di Ongwɛ Inggisɛ kyɛ le ba mi akpa emi esho, yi mfye bɛyi okwɔkwɔ oshewo. ");
INSERT INTO utr_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","O dika dɔ engyesɔ mgban esɔ nu ma fo agba okwukwo kweela, a dika gbe emidan ama ngwu a teyi sa ma ma kwakye mi ayɛsɛ enɛ ntonɛ duu, mi owita-wita mgbi agya esho oka nghataa lu oka. ");
INSERT INTO utr_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","<<Onɛnɛ kpayi ozoyeye nɛ mbi andundu na: Labɔlabɔ ngwi abɔn kyinda ngwi afɛ tɔ mi ele mata, ema li ye gbɛɛ akyonova dzɛ kwɛkwɛ wa. ");
INSERT INTO utr_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Nghanɛ, ni ema di ungwɔ ntonɛ duu, ema li ye gbɛɛ dzɛ kwɛkwɛ yi onufozu wa. ");
INSERT INTO utr_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","N nya ema otsitsi, etɔ nɛ ka nyɛ waba sede ungwɔ ntonɛ ka kyɔ se. ");
INSERT INTO utr_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Esho yi esɛ ka nyɛ, kpaa elodzɛ mgbi ani ka yama nyɛ ba. ");
INSERT INTO utr_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","<<Inggisɛ onyi ye odzɛ egbe hona onɔ ma ba, engyesɔ emi esho hona Ongwɛ kpaa ye ba sede li Imgbasho yuon. ");
INSERT INTO utr_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Dafi ndzɛ nose mi egbe mgbi iNua mani, li ngha nka dzɛ mi obaaba mgbi Ongwɛ Inggisɛ kpaa aali. ");
INSERT INTO utr_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Lubana duuse ni onikyɔ eni-ayɔ wa ba yɔ inggisɛ tole gye yɛ wa, le kye engyaa dile kye engwɛ nu eba, nghataa ba egbe ngwi iNua kaka uwaa mani; ");
INSERT INTO utr_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","a yama ye ungwɔ onyi nka ba ma esɛ ba nghataa onikyɔ eni-ayɔ wa kyi gbelu ma lu. Li ngha nka wa dzɛ mi obaaba mgbi Ongwɛ Inggisɛ aali. ");
INSERT INTO utr_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Nɛ inggisɛ efa ka to okwɔ a ka kyi kyelu onyi lu dzata oka. ");
INSERT INTO utr_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Engyaa efa kale kpinangwɔ mi ikwɔɔ, a ka kyi kyelu onyi lu dzata oka. ");
INSERT INTO utr_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","<<Nghanɛ ngyo le fɛ na, lubana ema yama ye egbe ngwi Otsɛ mgbi ema ka yɛ ma ba. ");
INSERT INTO utr_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Ungwɔnɛ no gbosa lo ema; ni otsungwudɛ ki ye onɔ ngwi emumyi kyɛ le ba mi otu yɔ, o ki ngyo le fɛ, o kika gbela nu ma gbobun ozu kaka ba. ");
INSERT INTO utr_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Nghanɛ abu kpaa ka wewo dzɛɛdzɛ kyɛmɛ, lubana Ongwɛ Inggisɛ ka yɛ mi onɔ ngwi abu tsɛwɛ ba mani. ");
INSERT INTO utr_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","<<Li emɛ tsatso li ongbidɔ oyɛyɛ di kwiinɛ? Li ongwu ongyukwo gbe engbidɔ mi udɛ mgban won abɔ gbɛɛ no le nu ma ungwogye mi onɔ yɛyɛ mani. ");
INSERT INTO utr_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Ka tɔ tishi lo ongbidɔ na kini ongyukwo mgban yɛ wa tun le kyɔ ngha yɔ. ");
INSERT INTO utr_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","N nya ema otsitsi o ka gbe alungwɔ mgban duu dɔn ubɔ. ");
INSERT INTO utr_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Kpaa kini ongbidɔ na timbali di nya ewon gbɛɛ, <Ongyukwo mgbi ani ka dzɛ imbe na onɔ ka she,> ");
INSERT INTO utr_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","man wita ogbo engbidɔ emidan ibe, le gye diyɛ wa yi ama ofyɛbyɛ yɔ, ");
INSERT INTO utr_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Ongyukwo mgbi ongbidɔ na ka yidɔ mi egbe hona onɔ ngwi o ye ba mani. ");
INSERT INTO utr_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","O ka nun adzɛ di kyon wokɛ mbonyi yi emi ikpala, imbe ngwi ikwu otseetse yi aba ogyeegye ka dzɛ mani. ");
INSERT INTO utr_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Mi onɔ na esutɔ ongwi esho ka dzɛ dafi ibidrua engwengyaa iwyo ama nkye ipitila mgbi ama kɛ oka kpatsɛ obongyaa ofufɛ mani. ");
INSERT INTO utr_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Eda mboma li imbuu eda diyɛ kwiinɛ. ");
INSERT INTO utr_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Imbuu ntona gbe ipitila mgbi ama byi kpaa engyie yɔ a byi ba. ");
INSERT INTO utr_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Kpaa ama okwiinɛ ntona gbe ipitila bɛyi engyie mi ikpɔkpɔ byi. ");
INSERT INTO utr_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Obongyaa ofufɛ mbe onɔ obaaba kwuba, man a ndɛ sile mwuna. ");
INSERT INTO utr_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","<<Mi idzidzɛ otu nɛta a wita ogbaakwɔ gbɛɛ, obongyaa ofufɛ kaka wa! Tɔ wa kpatsan na!> ");
INSERT INTO utr_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Nɛman ibidrua ntona duu kyato una kyile ipitila mgbi ama esho. ");
INSERT INTO utr_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Emi ikwangha ntona nya ama oyodzɛ gbɛɛ, <Mwa engyie mgbi ema gwee nu eyi na; di ipitila mgbi eyi le myunu.> ");
INSERT INTO utr_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","A gbɛɛ, << <Ei, kaba ka mɛ eyi yi ema ba. Tatase kɛ mbi ama okye engyie gya ka gya mgbi ema na.> ");
INSERT INTO utr_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","<<Kpaa dafi a kale kɛɛkɛ ofɛ oka gya engyie nɛta, obongyaa ofufɛ si kaka. Ibidrua ama nwewo ntona si kaka ifun mi imbe oga eba okwokyiikwokyi ma yan. Man a si yile ofɛ tukwu. ");
INSERT INTO utr_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","<<Onɔ gwee ta angbeka ntona kpaa yidɔ. A gbɛɛ, <Ongyukwo! Ongyukwo!> Kwulu eyi ofɛ!> ");
INSERT INTO utr_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","<<Nghaduu o nu uka gbɛɛ, <N nya ema otsitsi, ani ye ema ba.> ");
INSERT INTO utr_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","<<Nghanɛ ngyo le fɛ na, ikyena ema ye egbe hona onɔ ba. ");
INSERT INTO utr_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","<<Dika dzɛ dafi inggisɛ nle kɛ agaba, kwu engbidɔ mgban ela gbe okye mgban wo ma abɔ. ");
INSERT INTO utr_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","O nu onyi ma igbe efa yi isule iwyo, oka igbe onyi, oka ma o nun isule iwyo, ali inggisɛ duu dafi mmyɛ mgban mɛ mani. Ta o si lu agaba mgban. ");
INSERT INTO utr_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Inggisɛ ngbɛ igbe efa yi isule iwyo ma lu akponyi ka kye mgban fashabɔ diyɛ tu igbe efa yi isule iwyo mbwokɛ ele. ");
INSERT INTO utr_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Li ngha yɛyɛ ngwi ongwu ndzɛ yi igbe onyi na kpaa diyɛ tu onyi mbwokɛ ele aali. ");
INSERT INTO utr_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Nghaduu ongwu ngbɛ isule iwyo na, ngwi o lu ma jo ka tishɛ mi esɛ kye udza mgbi ongyukwo mgban da mi ele. ");
INSERT INTO utr_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Onɔ wa kɛ gblɔgɔdɔ nɛ ongyukwo mgbi engbidɔ ntona yɛ wa kyɔ okwakye yi ama mi odzɛ mmya mani. ");
INSERT INTO utr_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Inggisɛ ngbɛ igbe efa yi isule iwyo na di kye igbe efa yi isule iwyo mbwokɛ ele wa gbɛɛ, <Ongyukwo, abu nu ani oyɛyɛ yi igbe efa yi isule iwyo. Dii, n tu igbe efa yi isule iwyo mbwo ikyen aana.> ");
INSERT INTO utr_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","<<Ongyukwo mgban gbɔ nyan gbɛɛ, <N nuu abɔ, ongbidɔ osuse oyɛyɛ! Ngwi abu tso oyɛyɛ mi ungwɔ ogwee nɛ, n ka nu abu gbinɛbyi ani ungwɔ kwuba. Ba wa tsatsa yi ongyukwo mgbi abu!> ");
INSERT INTO utr_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","<<Inggisɛ ngwu o nun igbe onyi na kpaa ba. O gbɛɛ, <Ongyukwo, Abu nu ani oyɛyɛ yi igbe onyi; dii, n tu onyi mbwokɛ ele aana.> ");
INSERT INTO utr_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","<<Ongyukwo mgban nyan gbɛɛ, <N nuu abɔ, ongbidɔ osuse oyɛyɛ! Ngwi abu tso oyɛyɛ mi ungwɔ ogwee nɛ; n ka nu abu gbinɛbyi ani ungwɔ kwuba. Ba wa tsatsa yi ongyukwo mgbi abu!> ");
INSERT INTO utr_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","<<Ta inggisɛ ongwu ngbɛ isule iwyo na ba. O gbɛɛ, <Ongyukwo, ani teyi ye dafi abu li inggisɛ ofyumfye ali mani, abu li shɛ mi imbe ngwi abu kya ba di li gbe ngwikwo mi imbe ngwi abu fwe etɔ ba mani. ");
INSERT INTO utr_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Nghanɛ ani mio tasɛ lu ka kye awuya mgbi abu da mi esɛ. Dii, ungwɔɔ dzani.> ");
INSERT INTO utr_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","<<Ongyukwo mgban nun uka gbɛɛ, <Abu ongbidɔ ntimbali di wo ewewa nɛ! Ngwi abu plɛ ye gbɛɛ ani li shɛ mi imbe ngwi ani kya ba, di li gbe ngwikwo mi imbe ngwi ani fwe etɔ ba nɛ, ");
INSERT INTO utr_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","i tishi se waali, abu ki kye ani udza da mi ozu awuya, ikyegbɛɛ nin wa yɛ yɔ, n ki dulu udza mgbɛn yi eni owaawa. ");
INSERT INTO utr_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","<< <Gbɛlu isule iwyo na mbon na di yilen nu ongwu ndzɛ yi igbe efa yi isule iwyo nani. ");
INSERT INTO utr_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Lubana ali inggisɛ nsulun yɔ a ka mbwon ele, o dika sulun dzii. Ali inggisɛ nsulun bayɔ, ungwɔ ngwi o sulun ma kpaa a ka kyi gbɛlun ele. ");
INSERT INTO utr_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Di kye ayayi ongbidɔ na ngwuta lu esɛ, mi iifu, imbe ngwi ikwu otseetse yi aba ogyeegye ka dzɛ mani.> ");
INSERT INTO utr_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Onɔ ngwi Ongwɛ Inggisɛ ka ba mi okwɔkwɔ mgban yi engyesɔ duu yan ma, o ka sɔ itsuutɔ mgban mi okwɔkwɔ ongwi esho. ");
INSERT INTO utr_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Ɛsɛ duu ka kwakye mi iyayi mbon, ta o ka kyi ghalu inggisɛ yi ewoma dafi inggisɛ ongyo ifyungwɔ li kyi ghalu mmala yi mndɔ nɛni. ");
INSERT INTO utr_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","O ka gbe mmala tokɛ abugye di gbe mndɔ tokɛ abubɛ. ");
INSERT INTO utr_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","<<Ta utɔ ka gbɔ yi ama nto mi abugye ma gbɛɛ, <Ba na, ema ngwu Otsani kye mse bɛ ema ewo ntonɛni; gyokwudɛ mgbi ema na, esutɔ ngwi a kyi mɛlu dzɛkɛ ikye ema wita mi onɔ ngwi a ta ɛsɛ mani. ");
INSERT INTO utr_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Lubana enbwa dɔ ani ema nin ungwɔ nin gye, ekweni kwin ema di nin ungwɔ nin wa, ani li ingyoga ema di gbɛ ani, ");
INSERT INTO utr_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","ibiba angwuto kwin ema ten angwuto, ootse dɛn ema gbeka byin, n wo obawi ema di wa kpadi ani.> ");
INSERT INTO utr_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Ta ama onyaan ka nun uka gbɛɛ, <Otsɛ li engga ngwi eyi di abu dzɛ enbwa se byi abu enbwa, hona kwu ekweni di kye ungwɔ nu abu wa? ");
INSERT INTO utr_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Li engga ngwi abu li ingyoga se eyi gbɛ abu, naadi dzɛ ibiba angwuto se to abu angwuto? ");
INSERT INTO utr_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Li alonɔ ngwi eyi di abu dotse hona wo obawi se ka kpadi abu? ");
INSERT INTO utr_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Utɔ na ka nu uka gbɛɛ, <N nya ema otsitsi, alungwɔ ngwi ema kyɔ yi inggisɛ onyi ama ngwu i nghama ewo mi idzidzɛ emi ongwunani ntonɛ yɔ, li ani ngwu ema kyɔ yi ani. ");
INSERT INTO utr_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Ta o sika nya ama nto mi abubɛ mgban ntona gbɛɛ, <Noofɛ mmɛnɛ na, ema ama a wo ema ikamba nɛ, lu ifu ola ngwi a mɛwo ikye olodu yi engyesɔ mgban nani. ");
INSERT INTO utr_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Lubana enbwa dɛn kpaa ema nin unkonyi nin gye ba, ekweni kwin kpaa ema nin unkonyi nin wa ba, ");
INSERT INTO utr_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","n li ingyoga kpaa ema gbɛn ba, ibiba angwuto kwin kpaa i ten angwuto ba, n dotse di wodzɛ obawi kpaa i gbeka byin ba.> ");
INSERT INTO utr_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","<<Ama kpaa ka byita gbɛɛ, <Otsɛ, li alonɔ ngwi eyi di enbwa naadi ekweni kwu abu, hona li ingyoga hona dzɛ ibiba angwuto naadi dotse hona wo obawi, se ya abu abɔ ba? ");
INSERT INTO utr_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","<<O ka nu uka gbɛɛ, <N nya ema otsitsi, ekyɛɛkyɛ ngwi ema kyɔ yi inggisɛ onyi mi idzidzɛ ama ngwu i ngha ma ewo ntonɛ ba duu, li ani ngwu ema kyɔ yi ani ba aali. ");
INSERT INTO utr_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","<<Ta a sika yɛ atata lu mi adɔ okwookwo ogyegwu, nghaduu ama onyaan ntona sika kaka oshishe ogyegwu.>> ");
INSERT INTO utr_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Ngwi iYesu gbɔdzɛ ntonɛ ngyɛ duu nɛ, o nya engwafɔɔn gbɛɛ, ");
INSERT INTO utr_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","<<Dafi ema ye gbɛɛ oga owɛ owatɔ-watɔ mgbi emi Israi sisi egbe efa nɛ, a ka kye Ongwɛ Inggisɛ wo engyikyili abɔ nu ma gbokwon ngwɔn.>> ");
INSERT INTO utr_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Nɛ engyukwo ama ofifɛ yi emi obɔtsɛ mgbi ama kwakye mi udɛ okwukwo inggisɛ ofifɛ, ngwu iyin di iKayafa mani, ");
INSERT INTO utr_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","a si tsɛwɛ obwa iYesu daada lu ka ngwɔn. ");
INSERT INTO utr_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","A gbɛɛ, <<nghaduu no ka li mi onɔ oga ba, kpakpana inggisɛ ntona ka kyɔ ablodzɛ.>> ");
INSERT INTO utr_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Ngwi iYesu ka dzɛ iBetani mi udɛ iSaimɔn inggisɛ otsoma nɛ, ");
INSERT INTO utr_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","ongyaa ba mbon yi ikpɔkpɔ alabasta ogbungbɛ nfyumfyummya kpakpa, wa kye yawon ikye ngwi o kwodzɛ ongongo mi ewo adinyatsɛ. ");
INSERT INTO utr_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Dafi engwafɔ iYesu di ungwɔnɛ nɛ, itingga kyɔ ma. A byita gbɛɛ, <<Li ali engyie ombeembe ngha?>> ");
INSERT INTO utr_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","<<A ki kye engyie nɛ gya mi mmya okwukwo kye awuya na nu emi adzɛ.>> ");
INSERT INTO utr_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Ngwi iYesu ye ungwɔnɛ nɛ, o gbɔ yi ama gbɛɛ, <<Kyɔnɛ ngwi ema le nu ongyaa nɛ okakewo? O kyungwɔ nsunse yi ani. ");
INSERT INTO utr_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Emi adzɛ ka dzɛ yi ema alonɔ duu, kpaa ani ka dzɛ yi ema alonɔ duu ba. ");
INSERT INTO utr_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Onɔ ngwi o kye engyie ogbungbɛ nɛ kyi ani ewo na, o kyɔn ikye omɛlu ani ni a wa kye ani ndzi. ");
INSERT INTO utr_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","N nya ema otsitsi, ali imbe ngwi a gbɔ Esɔ Osuse nɛ mi ɛsɛ olɔlɔ duu, ungwɔ ngwi o kyɔ nɛ kpaa a ka gbɔn, ikye owɛ odzɛ mgban.>> ");
INSERT INTO utr_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Nɛ onyi mbi emi iwyodefa ntona, ongwu a li kwun di iJuda Iskarɔti, kɛ mbi engyukwo ama ofifɛ ");
INSERT INTO utr_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","ka byita gbɛɛ, <<Ni ani kyon wo ema abɔ ma li ekyɛ ngwi ema weka onu ani?>> Nɛta a kyi gbɔlu isule osudiwyo kye nun. ");
INSERT INTO utr_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Wita mi onɔ na iJuda le pita ofɛ ni ongwu kyon wo ma abɔ. ");
INSERT INTO utr_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Mi egbe ongwi ababɔ mgbi oga ibredi ngwi a kye okwuna wele ba ma, emi ongwafɔ iYesu ba mbon wa byita gbɛɛ, <<Li mi ole ngwi abu mina gbɛɛ ni eyi mɛ abu imbe ni abu wa gye oga owɛ owatɔ-watɔ mgbi emi Israi?>> ");
INSERT INTO utr_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","O nya ma gbɛɛ, <<Kɛ mbi inggisɛ oka mi ifu ogalu ka nyan gbɛɛ, <Otsetse gbɛɛ: onɔ ngwi a kye dzɛ ani ma dzɛ kwɛkwɛ. N ka ka gye oga owɛ owatɔ-watɔ mgbi emi Israi mi udɛ abu yi engwafɔ mgbi ani.> >> ");
INSERT INTO utr_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Nghanɛ engwafɔ ntona si kyɔ dafi iYesu tso ma mani man a si wewo oga owɛ owatɔ-watɔ mgbi emi Israi. ");
INSERT INTO utr_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Ngwi onɔ gbɛsɛ nɛ, iYesu kwo ongongo le gye ungwogye mi adinyatsɛ yi emidan iwyodefa ntonani. ");
INSERT INTO utr_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Ngwi a le gye ungwogye nɛ, o gbɛɛ, <<N nya ema otsitsi, onyi mbi ema ka kye ani gya.>> ");
INSERT INTO utr_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Engwafɔɔn si yɛɛ elela wita ogbɔ yan onyonyi gbɛɛ, <<Otsɛ, mi otsitsi li ani ba lɔ?>> ");
INSERT INTO utr_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","IYesu nu uka gbɛɛ, <<Li onyi mi idzidzɛ ema nle gye ungwogye yi ani nɛ ka kye ani gya. ");
INSERT INTO utr_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Ongwɛ Inggisɛ ka lu dafi Afɛ lɔ ikyon ma yɛyɛ. Kpaa ahoo mi ikye inggisɛ nkye Ongwɛ Inggisɛ gya mani! Tatase a ki mban ba.>> ");
INSERT INTO utr_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Nɛ iJuda nka kyon gya ma gbɛɛ, <<Otsetse, mi otsitsi li ani ba lɔ?>> IYesu nu uka gbɛɛ, <<O gbɔ wali.>> ");
INSERT INTO utr_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Ngwi a le gye ungwogye nɛ, iYesu kyi kyelu ibredi, kye angba nu Imgbasho man kye mwalu, di kye nu engwafɔ mgban, gbɛɛ, <<Gbɛ gye na; nɛnɛ li ewo mgbi ani.>> ");
INSERT INTO utr_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Nɛ o kyi kyelu ibwɛ yi eneekwɔ mi ele, kye angba nu Imgbasho di kye nu ma, si gbɛɛ, <<Ema duu, wa na. ");
INSERT INTO utr_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Nɛnɛ li eyi mgbi ani mgbi ondu odzɛɛdzɛ, ngwi a kye kyi ikye okye ali ibwubwe ta ibyi inggisɛ mkpa. ");
INSERT INTO utr_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","N nya ema, wita onɛnɛ nghataa lu iyayi n ka weni awawa ekwɔ nɛ wuba nghataa ba egbe ngwi ani ka wa wan ofufɛ yi ema mi esutɔ mgbi Otsani mani.>> ");
INSERT INTO utr_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Onɔ ngwi a shashi onyi otsɛ Imgbasho ngyɛ nɛ, a tasɛ lu unggwɔ olivi. ");
INSERT INTO utr_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Ta iYesu nya ma gbɛɛ, <<Mi otu inɛ nɛni ema duu ka yɛyikpa mi ikye odzɛ ani, lubana Afɛ lɔ gbɛɛ: << <N ka kwudɔwo inggisɛ ongyo ifyungwɔ, man ifyungwɔ mmala ka ganya.> ");
INSERT INTO utr_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Nghaduu onɔ ani wa kyato yɔ, n ka teyi ema lu iGalalia.>> ");
INSERT INTO utr_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","IPyita nyan gbɛɛ, <<Ni inggisɛ duu yɛyikpa mi ikye odzɛ abu kpaa, ani ka yɛ ba.>> ");
INSERT INTO utr_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","IYesu gbɔ yi iPyita gbɛɛ, <<N nya abu otsitsi, mi otu inɛ nɛni, duuse ni ogbigbi teela, abu ka tangwɛ ani akpe eta.>> ");
INSERT INTO utr_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Nghaduu iPyita biibɛ gbɛɛ, <<Yeba ni ani ka kwulu yi abu kpaa, n ka tangwɛ abu ba.>> Man engwafɔ angbeka ntona kpaa gbɔ elodzɛ onyi. ");
INSERT INTO utr_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","IYesu kɛ imbe ngwi a li kwun di iGesemani yi engwafɔ mgban, o si nya ma gbɛɛ, <<Sɔ mmɛnɛ na, ni ani kɛ mmana ka bibɔ.>> ");
INSERT INTO utr_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","O kye iPyita yi emi ongwɛ iDzebedi nghi efa wafɔ yan, o kyelela saan di dzɛ mi okakewo. ");
INSERT INTO utr_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","O nya ma gbɛɛ, <<Ani kyelela she jo kɛ ikwongye kpaa. Dzɛ mmɛnɛ, di ngyo yi ani na.>> ");
INSERT INTO utr_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Ngwi o gblekɛ iyayi gwee nɛ, o lakɛ esɛ kye inɛ tukwu esɛ bibɔ gbɛɛ, <<Otsani, ni li kyɛmɛ yɔ, kyi kyelu ibwɛ adzɛ nɛ mbi ani. Nghaduu no ka li oweka mgbi ani ba, kpaa oweka mgbi abu no kyɔ.>> ");
INSERT INTO utr_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Nɛ o yidɔ luba mbi engwafɔɔn si wa di ma le nuna. O byi iPyita gbɛɛ, <<Ema ka yagba ngyo yi ani mi obyi onyi kpaa lo? ");
INSERT INTO utr_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","<<Ngyo di bibɔ ikye ni ema ka gbɛsɛ mi imbadi ba mani. Onodzi le mina, kpaa ewo yɔ dzatsi.>> ");
INSERT INTO utr_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","O diyɛ lu akpe ongwu fan ka bibɔ gbɛɛ, <<Otsani, ni li kyɛmɛ okyelu ibwɛ adzɛ nɛ ba, se ni ani wan yɔ, owitukwu mgbi abu no kyɔ.>> ");
INSERT INTO utr_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Ngwi o di yɛ nɛ, o di tu ma le nuna, ikyekyɛ akwukwinɛ mgbi ama sundo. ");
INSERT INTO utr_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Nghanɛ o diyɛ dzɛ ma ta kpɔɔ dika bibɔ akpe ongwu ta, le gbɔ elodzɛ na kpɔɔ. ");
INSERT INTO utr_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","O yɛ ba mbi engwafɔ mgban di gbɔ yi ama gbɛɛ, <<Ema kale nuna dile tonya maa? Dii, obyi ma dzɛ kwɛkwɛ, ngwi a ka kye Ongwɛ Inggisɛ wo emi ibwubwe abɔ wa. ");
INSERT INTO utr_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Kyato, i kɛ na! Inggisɛ nkye ani gya ma o dzɛ na!>> ");
INSERT INTO utr_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Ngwi o kale gbɔdzɛ nɛ, iJuda, onyi mbi emi iwyodefa ntona, wa to. Ibyi inggisɛ byi okwusunkli bɛyi okwuta ama osundo kyɛ yan kyɛ, ngwi li engyukwo ama ofifɛ bɛyi emi obɔtsɛ mgbi ama dɔ ma esɔ. ");
INSERT INTO utr_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","IJuda nkyon gya na teyi bwondu yi ama gbɛɛ: <<Ongwu ani kye ondu kwon ataka ma li ongyulɔ ma aali; bwan na.>> ");
INSERT INTO utr_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","IJuda kwɔkɛ mbi iYesu akponyi, si gbɛɛ, <<N tangba, Otsetse!>> Man kye ondu kwon ataka. ");
INSERT INTO utr_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","IYesu nyan gbɛɛ, <<Oya, kyungwɔ abu ba ikyon mani.>> Ta inggisɛ ntona gbleba, dzɛ iYesu wo bwan. ");
INSERT INTO utr_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Labɔlabɔ nɛta, emidi iYesu onyi kye ngwalu okwusunkli mgban kye kwɔdzɛ ongbidɔ mgbi okwukwo inggisɛ ofifɛ adɔ. ");
INSERT INTO utr_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","IYesu nyan gbɛɛ, <<Yile okwusunkli mgbi abu wokɛ mbi ikwukwun, ikyesinɛ ama nngwa okwusunkli duu ka kwulu mi okwusunkli. ");
INSERT INTO utr_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Ema tsɛwɛ gbɛɛ ani ka kwu Otsani ela, ta o ka byakpa gbe engyesɔ ngha obyi engyesɔ iwyodefa dɛsɔ nu ani lo? ");
INSERT INTO utr_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Nghama ka kyɔsinɛse ngwi Afɛ ngbɛɛ ungwɔnɛ ka kyɔ mi itɔ ofɛ nɛ kyɛmɛ na mbwumbwo?>> ");
INSERT INTO utr_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Mi onɔ na iYesu gbɔ yi ibyi inggisɛ ntona gbɛɛ, <<Ani gbe ama onghaadɔ teyi se, ngwi ema kyɛ yi okwusunkli bɛyi okwuta ama osundo owa bwa anii? Alegbe ani li sɔ akangga ozu okwukwo osunu Imgbasho mi iJerosalin le tsungwɔ kpaa ema bwa ani ba. ");
INSERT INTO utr_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Nghaduu ungwɔnɛ kyɔ ikye ni ungwɔ ngwi ama ogbɛɛsɛ lɔ ma mbwumbwo.>> Nɛta engwafɔ mgbi iYesu duu dzanta tsinya lu. ");
INSERT INTO utr_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Ama nbwa iYesu ma kyon kɛ mbi iKayafa, okwukwo inggisɛ ofifɛ, imbe ngwi etsetse mgbi ola bɛyi engyukwo kwakye mani. ");
INSERT INTO utr_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Nghaduu iPyita kyan iyikpa mbombo, nghataa kaka ifyudɛ okwukwo inggisɛ ofifɛ. O kaka ka sisɛ yi ama ongyoongyo ntona ikye odi ungwɔ nka kiyayi mani. ");
INSERT INTO utr_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Engyukwo ama ofifɛ bɛyi okwakye duu le pita itɔdzɛ atsika ni ama kye abɔ byi ele ngwɔ iYesu. ");
INSERT INTO utr_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Ama okyɔ obwɛndɛ atsika kwuba tɔ ba esɛ, nghaduu a tu itɔdzɛ onyi ba, owa ngyɛ-ngyɛ inggisɛ efa tɔ ba ");
INSERT INTO utr_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","wa gbɛɛ, <<Inggisɛ nɛ gbɛɛ, <Ani ka yagba kyi gbobu ozu okwukwo osunu Imgbasho mi iJerosalin di yilen mbɛ mi egbe eta.> >> ");
INSERT INTO utr_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Nɛ okwukwo inggisɛ ofifɛ kyato di byi iYesu gbɛɛ, <<Abu ka nu uka mi odzɛ ngwi a le gbɔ kwu iyi abu nɛ lo?>> ");
INSERT INTO utr_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Kpaa iYesu dzɛ shili. Okwukwo inggisɛ ofifɛ na nyan gbɛɛ, <<Ani gbabɔ nu abu mi iyi mgbi Imgbasho ndzɛ oshishe nani: Nya eyi ni abu li iMedzaya, Ongwɛ Imgbasho ma yɔ.>> ");
INSERT INTO utr_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","IYesu gbɛɛ, <<Ɛɛn, dafi abu gbɔ mani. Kpaa n nya ema duu gbɛɛ naa: Mi iyayi ema ka di Ongwɛ Inggisɛ sɔdzɛ abugye mgbi Ongwu nngha yi mfye kyɛ akpa mi esho.>> ");
INSERT INTO utr_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Nɛta okwukwo inggisɛ ofifɛ na si fawa ewon angwuto di gbɛɛ, <<O fya Imgbasho ito! Kyɔsinɛ ngwi eyi dika mina obwɛndɛ angbeka? Dika, onɛnɛ ema fwo ito nɛni. ");
INSERT INTO utr_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Ema tsɛwɛ sinɛ?>> A gbɛɛ, <<O mɛ ondu ikwongye. ");
INSERT INTO utr_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Nɛta a kyanggwɔ kyin inɛ di gbon. Angbeka tan afɛ ");
INSERT INTO utr_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","di gbɛɛ, <<Yegbɔ nya eyi ka, abu iKrestu. Li emɛ kwudɔwo abu okwuta?>> ");
INSERT INTO utr_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Mi onɔ na iPyita sɔdzɛ ifyudɛ utɔ, man ongwongyiidɔ ba mbon. O gbɛɛ, <<Abu kpaa li onyi mbi ama nkyɛ yi iYesu ongwi iGalalia.>> ");
INSERT INTO utr_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Kpaa iPyita tangwɛ mi inai ma duu. O gbɛɛ, <<Ani ye odzɛ ngwi abu le gbɔ na ba.>> ");
INSERT INTO utr_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Nɛ o tasɛ lu onufoka, imbe ngwi ongwongyaa oka din di nya inggisɛ ama nto mmana ma gbɛɛ, <<Inggisɛ nɛ dzɛ yi iYesu ongwi iNadzareti.>> ");
INSERT INTO utr_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","O di tangwɛ, yi ofaafa gbɛɛ: <<Ani ye inggisɛ na ba!>> ");
INSERT INTO utr_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","I kye onɔ bwee nɛ, ama nto mmana ma kɛ mbi iPyita ka gbɛɛ, <<Mi otsitsi abu li onyi mboma, ikyesinɛ ela mgbi abu mi ikye kye abu gya.>> ");
INSERT INTO utr_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Ta o si wita owo ewon ikamba di fa gbɛɛ, <<Ani ye inggisɛ na ba!>> Labɔlabɔ mata ogbigbi si teela. ");
INSERT INTO utr_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Man iPyita wɛ elodzɛ ngwi iYesu teyi gbɔ yan mani gbɛɛ: <<Duuse ni ogbigbi teela, abu ka tangwɛ ani akpe eta.>> Ta o tasɛ ka tsukwu kpakpa. ");
INSERT INTO utr_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Mi egbegbe byibyiibyi, engyukwo ama ofifɛ mgbi Imgbasho bɛyi engyukwo emi ɛsɛ na duu bwalu ondu okyi ngwɔlu iYesu. ");
INSERT INTO utr_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","A bwan adi, kyon lu ka nu mi abɔ mgbi iPlatu, iGɔna mani. ");
INSERT INTO utr_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Mi onɔ ngwi iJuda, ongwu nkyon gya na, di gbɛɛ iYesu le lu ondu ikwu nɛ, itukwu mgban kyata man o yile isule osudiwyo na lu ka nu engyukwo ama ofifɛ bɛyi engyukwo mgbi emi iJuda. ");
INSERT INTO utr_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","O gbɛɛ, <<Ani kyungwɔ obube, dafi ani kye inggisɛ nkyɔ obube ye ba gya mani.>> A nun uka gbɛɛ, <<Mgbi eyi dikyɛ? Nana li okakewo mgbi abu,>> ");
INSERT INTO utr_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Nghanɛ iJuda kye udza na fwe toma kɛ ozu okwukwo osunu Imgbasho mi iJerosalin man lu. Ta o si lu ka kye ewon widɔkwɔ. ");
INSERT INTO utr_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Engyukwo ama ofifɛ mgbi Imgbasho kye salu isule ntonani si gbɛɛ, <<Li ola ba okye udza nɛ wokɛ imu mgbi eyi, bana li udza eyi.>> ");
INSERT INTO utr_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Nghanɛ a gbela okye udza na gya ikpɛsɛ yi inggisɛ ombɛ ishe no li imbe ogbe ingyoga ndzi mi ele. ");
INSERT INTO utr_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Li ikyengha ngwi a li kwu imbe na gbɛɛ ikpɛsɛ mgbi eyi nghataa ba inɛ aani. ");
INSERT INTO utr_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Ta odzɛ ngwi Oyegbɔ iJeremia gbɔ ma mbwumbwo gbɛɛ: <<A kyi salu isule osudiwyo ntonani, mmya ngwi emi Israi gbela kpa mi ikye iYesu mani, ");
INSERT INTO utr_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","man a kye udza ma gya ikpɛsɛ yi inggisɛ ombɛ ishe, dafi Otsɛ Imgbasho teyi wo ani ola mani.>> ");
INSERT INTO utr_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Mi onɔ na iYesu kwudzɛ iyayi iGɔna, iGɔna si byun gbɛɛ, <<Abu li utɔ mgbi emi iJudaa?>> IYesu nyan gbɛɛ, <<Dafi abu gbɔ mani.>> ");
INSERT INTO utr_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Onɔ ngwi engyukwo ama ofifɛ mgbi Imgbasho bɛyi engyukwo mgbi emi iJuda maayi ban nɛ, o kwondu onyi ba. ");
INSERT INTO utr_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Nɛ iPlatu byun gbɛɛ, <<Abu fwo obwɛndɛ ngwi a gbe ba mi ikye abu nɛ lo?>> ");
INSERT INTO utr_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Kpaa iYesu kwondu ba, di nu uka mi itɔdzɛ onyi kpaa ba, i kwulu iGɔna ewo kpakpa. ");
INSERT INTO utr_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Onɔ nɛ i teyi li aletɔ mgbi iGɔna mi onɔ oga owɛ owatɔ-watɔ mgbi emi Israi, odulu inggisɛ onyi mi obawi ongwu emi Israi gbela won mani. ");
INSERT INTO utr_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Mi onɔ na a dzɛ yi ibwubwe inggisɛ oka mi obawi, iyin di iBaraba. ");
INSERT INTO utr_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Dafi emi Israi kwakye duu nɛta, iPlatu byi ma gbɛɛ, <<Li emɛ ngwu ema mina gbɛɛ ni ani dulu nu ema; li iBaraba naadi iYesu ngwu a li kwun di iMedzaya na?>> ");
INSERT INTO utr_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Lubana o ye dafi li mi ikyili ngwi a kye iYesu ba mbi ongwu mani. ");
INSERT INTO utr_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Dafi iPlatu ka sɔdzɛ itse ogbiikwɔ nɛ, owan dɛsɔ nɛ gbɛɛ, <<Ka dzɛ yi unkonyi okyɔ yi inggisɛ ndzɛ yi obube ba nɛ ba, lubana ani gyadzɛ kwuba inɛ mi elela mi ikye mgban.>> ");
INSERT INTO utr_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Nghaduu engyukwo ama ofifɛ bɛyi engyukwo mgbi emi iJuda tu ibyi inggisɛ ntona wo gbɛɛ nu ma bɔ iBaraba kpaa iYesu yɔ nu ma ka ngwɔn. ");
INSERT INTO utr_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","IGɔna byi ma gbɛɛ, <<Li emɛ mi idzidzɛ inggisɛ efa ntonɛ ngwi ema mina gbɛɛ ni ani dulu nu ema?>> A wulu gbɛɛ, <<IBaraba.>> ");
INSERT INTO utr_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","IPlatu byi ma gbɛɛ, <<Nghanɛ nin kyɔsinɛ yi iYesu ngwu a li kwun di iMedzaya nɛ?>> Ama duu wulu gbɛɛ, <<Gbokwon mi ekwatsi.>> ");
INSERT INTO utr_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","IPlatu byita gbɛɛ, <<dikyɛ? Li alungwɔ obube ngwi o kyɔ?>> Kpaa a nghao feela okwukwo gbɛɛ, <<Gbokwon mi ekwatsi.>> ");
INSERT INTO utr_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Ngwi iPlatu di gbɛɛ odzɛ mgbi ongwu le kaka ma adɔ ba, eye kpaa dile fya okyɛɛ nɛ, o mweni di sabɔ mi inai ma. O gbɛɛ, <<Ani dzɛ yi obube mi eyi mgbi inggisɛ nɛ ba, li idɔ mgbi ema!>> ");
INSERT INTO utr_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Inggisɛ ntona duu nu uka gbɛɛ, <<Ni eyi mgban dikye eyi yi engwɛ eyi duu!>> ");
INSERT INTO utr_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Ta o dulu iBaraba nu ma: Kpaa iYesu yɔ, o nu ma gbon onitse ngyɛ taman, kyon wo ma abɔ gbɛɛ nu ma ka gbokwon mi ekwatsi. ");
INSERT INTO utr_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Ta ama oblakwutsɛ mgbi iGɔna na kye iYesu lu agya oka mi ifyudɛ utɔ di gbe obyi oblakwutsɛ duu kpakɛkɛ won. ");
INSERT INTO utr_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","A dulun angwuto di gbe awulu omuma jaan won ewo, ");
INSERT INTO utr_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","diyɛ fulu akata mi ato tukwun ikye. A di kye okwuta won kɛ abugye, yɛ kwɛsɛ mi iyayi mgban nyan agya gbɛɛ, <<Eyi ta abu angba, utɔ mgbi emi iJuda!>> ");
INSERT INTO utr_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","A kyanggwɔ kyin, di kye gbɛlu okwuta na mi abɔ mgban yilen gbon mi ikye dudɔ-dudɔ. ");
INSERT INTO utr_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Ngwi a nyan addi ngyɛ nɛ, a kye dulun awulu na mi ewo yɛ gbe angwuto mgban won. Man a tawon lu oka gbokwon mi ekwatsi ngwɔn. ");
INSERT INTO utr_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Dafi a le tasɛ nɛ, a kpatsɛ ongyulɔ ongwi iSirini, iyin di iSaimɔn, nɛman a siin gbɛɛ non kye ekwatsi nani. ");
INSERT INTO utr_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","A wa kaka imbe ngwi a li kwun gbɛɛ iGogota (Ngwi itan di idingbo nani.) ");
INSERT INTO utr_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Mi imbe na a kye eneekwɔ ngwi a kye takye yi mcɛ nu iYesu gbɛɛ non wa, kpaa ngwi o mbadi nɛ, o fwa owan. ");
INSERT INTO utr_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Ngwi a gbokwon mi ekwatsi nyɛ nɛ, a kye ghalu angwuto mgban mi efa ogboogbo. ");
INSERT INTO utr_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Man a sɔkɛ, le ngyon mmanani. ");
INSERT INTO utr_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Mi onyɛ ikye mgban kɛ esho gwee, a kye itɔdzɛ ngwi a kye won ewo ma kyi lɔlu bɛkɛ ele gbɛɛ: NƐNƐ LI IYESU, UTƆ MGBI EMI IJUDA. ");
INSERT INTO utr_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Emumyi ama ofofɛ nghi efa kpaa a gbokwo ma yan, onyi mi abugye mgban yi oka mi abubɛ mgban. ");
INSERT INTO utr_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Ama nnyɛ kwɛkwɛ gbe ito tukwun ewo, dile ngwi ikye, ");
INSERT INTO utr_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","yɛ le gbɛɛ, <<Abu nka gbobu ozu okwukwo osunu Imgbasho mi iJerosalin di yilen mbɛ mi egbe eta ta nɛ, dulu ewabu tɔ! Tashulu mi ekwatsi, kini abu li Ongwɛ Imgbasho yɔ!>> ");
INSERT INTO utr_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Li itɔ ofɛ nɛ kpɔɔ ngwi engyukwo mgbi ama ofifɛ mgbi Imgbasho yi etsetse mgbi ola mgbi iMose bɛyi engyukwo mgbi emi iJuda mwibwa nyan aali. ");
INSERT INTO utr_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","A gbɛɛ, <<O dulu angbeka tɔ kpaa o yagba dulu ewon ba! Non li utɔ mgbi emi Israi yɔ! Non tashulu mi ekwatsi, ta eyi ka nun oyɛyɛ. ");
INSERT INTO utr_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","O nu Imgbasho oyɛyɛ. Ni Imgbasho dulun onɛnɛni ki non kpan itukwu yɔ, lubana o gbɛɛ <Ani li Ongwɛ Imgbasho.> >> ");
INSERT INTO utr_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Li itɔ ofɛ nɛ kpɔɔ ngwi emumyi ama ngwu a gbokwo ma yan mi ekwatsi ntona kpaa yawon ito aali. ");
INSERT INTO utr_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","I wita mi obyi iwyodefa nghataa ba obyi eta ongwi onɔdɛ imbe yifu kpatsɛ ɛsɛ duu. ");
INSERT INTO utr_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Dafi obyi eta hini iYesu makwɔ tasɛ mi ela okwukwo gbɛɛ, <<Elio, Elio, lama sabatani?>> -Itan gbɛɛ, <<Imgbasho mgbi ani, Imgbasho mgbi ani, kyɔnɛ ngwi abu dzani ta?>> ");
INSERT INTO utr_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Onɔ ngwi angbeka nkwudzɛ mmana fwo akwɔ nɛ ma a gbɛɛ, <<O le kwu Elaija ela.>> ");
INSERT INTO utr_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Labɔlabɔ mata onyi mi idzidzɛ mgbi ama tsinya ka kye isoso. O kye tswokɛ eneekwɔ onunɔ, kye bwakɛ anggekwu, di kye nu iYesu gbɛɛ non wa. ");
INSERT INTO utr_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Kpaa inggisɛ ama nsisi duu gbɛɛ, <<Kwulɛsɛ na, ni eyi di kana Elaija kyɛma ka wa dulun tɔ.>> ");
INSERT INTO utr_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Ngwi iYesu diyɛ makwɔ tɔ mi ela okwukwo nɛman, o si yulu. ");
INSERT INTO utr_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Mi onɔ na mata angwuto ntsɛdzɛ ozu okwukwo osunu Imgbasho mi iJerosalin na gbua efa wita kyɛ esho nghataa to esɛ. Ikpɛsɛ suusu man unggwɔ kadzɛ. ");
INSERT INTO utr_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Endzi gbeka kwulu lakɛ asisa man ikpewo mgbi inggisɛ ama osaan nteyi kwulu ma a kyile ma yɛɛ oshishe. ");
INSERT INTO utr_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","A tasɛ mi endzi, ngwi iYesu kyɛɛ mi ikwu nyɛ duu nɛ, a lu kaka ogalu osaan nani di tsetu inggisɛ ibyibyi. ");
INSERT INTO utr_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Dafi okwukwo ogbakwu bɛyi ama nto yan le ngyo iYesu di ɛsɛ osuusu bɛyi ungwɔ ama nkyɔ duu nɛ, i kwulu ma ewo, a diyɛ gbɔ tɔ gbɛɛ, <<Otsitsi o li Ongwɛ Imgbasho!>> ");
INSERT INTO utr_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Engyaa kwuba to imbe na, le di kɛ mbotunto. A kyɛdɔ iYesu kyɛ iGalalia ikye oyan abɔ mi imina mgban. ");
INSERT INTO utr_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Mi idzidzɛ mgbi ama li iMeri iMagidalin, iMeri onɔ iJɛnsi yi iJose, bɛyi owa iDzebedi. ");
INSERT INTO utr_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Dafi onɔ le gbɛsɛ nɛ, inggisɛ aludu oka mi Arimatia, iyin di iJose, o teyi kye ewon yɛɛ ongwafɔ mgbi iYesu. ");
INSERT INTO utr_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","O kɛ mbi iPlatu ka bɔn ikwɔ mgbi iYesu, man iPlatu nondu gbɛɛ nu ma kye nun. ");
INSERT INTO utr_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","IJose kyelu ikwɔ nani, kye angwuto ofufɛ ndiwon, ");
INSERT INTO utr_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","kye ka ndzi mi endzi mgbi ongwu ofufɛ ngwi o cɛfo mi unggwɔ. O mulu ikwutsɛ okwukwo kye tukwukɛ ondendzi si di ofan nyɛ. ");
INSERT INTO utr_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","IMeri iMagidalin yi iMeri oka na sɔto fashi inɛ tsɛ endzi nani. ");
INSERT INTO utr_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Tegblifan ma, li egbe otonyewo, engyukwo mgbi ama ofifɛ mgbi Imgbasho bɛyi emi iFarasi kɛ mbi iPlatu. ");
INSERT INTO utr_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","A gbɛɛ, <<Ongyukwo eyi wɛ gbɛɛ onɔ ngwi inggisɛ ogbatsika na ka dzɛ oshishe ma, o gbɛɛ, <Ni i wa nyɛ egbe eta ani ka kyɛɛ mi ikwu.> ");
INSERT INTO utr_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Nghanɛ noola ikye nu ma ngyo endzi na saan nghataa ba egbe eta nani. Bana, emi ongwafɔɔn ka wa kye yili ikwɔ na diyɛ nya ibyi inggisɛ gbɛɛ o kyɛɛ mi ikwu. Okpagyewo ongwi olɛlɛ nɛ ka wa timbi ngha ongwi ababɔ.>> ");
INSERT INTO utr_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","IPlatu nya ma gbɛɛ, <<Kye ama ongyoongyo na, lu, ka ngyo endzi na dafi ema yagba mani.>> ");
INSERT INTO utr_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Nghanɛ a lu ka kye kwobɛ ondendzi na mi ikwutsɛ nani di gbe ama ongyoongyo le ngyo. ");
INSERT INTO utr_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Ngwi egbe otonyidɔ wa nyɛ nɛ, mi egbegbe ototu mi egbe iladi, iMeri iMagidalin yi iMeri oka na kɛ oka di endzi. ");
INSERT INTO utr_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Vla nɛta ikpɛsɛ suusu kpakpa, ta Ongyesɔ mgbi Otsɛ tashulu kyɛ esho ba esɛ, wa munu ikwutsɛ na lu iyikpa di sɔkɛ ele. ");
INSERT INTO utr_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Odzɛɛdzɛ mgban dzɛ dafi mmbwo onaabɔ, angwuto mgban di gbosa dafi ofufu itu. ");
INSERT INTO utr_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Ama ongyoongyo ntona imio wo ma yan kpakpa man a shigakwu diyɛ gbɛsɛ lakɛ esɛ dafi a kwulu mani. ");
INSERT INTO utr_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Ongyesɔ na nya engyaa ntona gbɛɛ, <<Ka mio ba na, lubana ani ye li iYesu ngwu a gbokwon mi ekwatsi na ngwi ema le pitan. ");
INSERT INTO utr_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","O dzɛ mmɛnɛ ba; o kyɛɛ mi ikwu, dafi o teyi gbɔ mani. Ba wa di imbe ngwi a kyon la ma na. ");
INSERT INTO utr_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Nghanɛ yɛ lu plɛ-plɛ ka nya engwafɔɔn gbɛɛ: <O kyɛɛ mi ikwu di teyi ema le lu iGalalia ma. Li mi imbe na ema ka din.> Li ungwɔ ngwi ani ba owa nya ema aani.>> ");
INSERT INTO utr_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Ta imio wo engyaa ntonani, nghaduu a dzɛ yi atsa kpakpa, man a dzata endzi tsinya lu plɛ-plɛ ka nya engwafɔɔn. ");
INSERT INTO utr_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Vla nɛta iYesu kpatsɛ ma. O nya ma gbɛɛ, <<Iyu no dzɛ yi ema.>> A yɛ ba mbon, wa kpaklin afɔ di sunun. ");
INSERT INTO utr_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","IYesu si nya ma gbɛɛ, <<Ka mio ba na. Lu ka nya emidani nu ma lu iGalalia; a ka di ani mi imbe nani.>> ");
INSERT INTO utr_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Dafi engyaa ntona kpatsɛ ofɛ le lu nɛ, angbeka mi idzidzɛ mgbi ama ongyoongyo ntona kaka ifu ogalu ka gbɔ nya engyukwo ama ofifɛ mgbi Imgbasho alungwɔ nkyɔ duu. ");
INSERT INTO utr_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Onɔ ngwi engyukwo ama ofifɛ kwakye yi engyukwo mgbi emi iJuda ma a tsɛwodzɛ si kye awuya kpakpa nu ama oblakwutsɛ, ");
INSERT INTO utr_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","nya ma gbɛɛ, <<Ema ka gbɔgbɛɛ, <Engwafɔɔn ba mi otu wa kye yili ikwɔ mgban lu mi onɔ ngwi eyi le nuna mani.> ");
INSERT INTO utr_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Kini odzɛ nɛ to adɔ mgbi iGɔna yɔ, eyi ka nyan odzɛ nka man dika dulu ema tɔ mi okakewo mani.>> ");
INSERT INTO utr_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Nghanɛ ama oblakwutsɛ ntona gbɛlu udza na di kyɔ dafi a nya ma ma yɛyɛ. Ta utsa nɛ a gbɔn kpatsɛ mbi emi iJuda nghataa ba inɛ. ");
INSERT INTO utr_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Ta engwafɔ iwyodonyi ntona lu iGalalia, mi unggwɔ ngwi iYesu teyi nya ma gbɛɛ nu ma lu ele mani. ");
INSERT INTO utr_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Ngwi a din nɛ, a sunun, kpaa angbeka tangwɛ. ");
INSERT INTO utr_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Nɛ iYesu ba mboma wa gbɛɛ, <<Ali mfye mi esho yi esɛ duu a kye nu ani. ");
INSERT INTO utr_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Nghanɛ lu dika nu inggisɛ mi ɛsɛ duu yɛɛ engwafɔ mgbi ani, kyɔ ma iBatisima mi iyi mgbi Otsɛ yi Ongwɛ bɛyi Onodzi Osaan, ");
INSERT INTO utr_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","di tso ma ongyo alungwɔ ngwi ani wo ema ola mi ele duu. N dika dzɛ yi ema alonɔ duu, nghataa kɛ ongyɛɛngyɛ ɛsɛ.>>");
INSERT INTO utr_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Owita-wita mgbi Esɔ Osuse mi ikpewo iYesu iKrestu, Ongwɛ Imgbasho. ");
INSERT INTO utr_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","A tsekise lɔ mi afɛ mgbi oyegbɔ Adzaya gbɛɛ: <<N ka dɔ ongyesɔ mgbi ani no teyi abu, ka mɛ abu ofɛ>> ");
INSERT INTO utr_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","<<Ela inggisɛ le kwu mi okwɛsɛ gbɛɛ, <Mɛ Otsɛ ofɛ, man ofɛ no byi klididi.> >> ");
INSERT INTO utr_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Ta iJɔn okyɔ iBatisima ba, le kyɔ iBatisima mi okwɛsɛ dile gbeesɔ mgbi iBatisima okyatitukwu nu ma dzata inggisɛ yi ali ibwubwe. ");
INSERT INTO utr_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Ɛsɛ iJudia duu bɛyi inggisɛ emi iJerosalin tɔ kɛ mbon. Le fwi ali ibwubwe mgbi ama, iJɔn dile kyɔ ma iBatisima mi ekyoo mgbi iJodan. ");
INSERT INTO utr_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","IJɔn wo angwuto ngwi a mɛ mi andu ilakwumyi, yi okpa mmbwaba mi oshi mgban, ma o li gye okpa yi enewo. ");
INSERT INTO utr_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Nɛnɛ li esɔ mgban nose aani: <<Inggisɛ oka kyɛ ani iyikpa, O fyumfye ngha ani, odi okpafɔ mgban kpaa ani mɛ oshɛ ba. ");
INSERT INTO utr_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Ani le kyɔ ema iBatisima yi eni, nghaduu ongwu ka kyɔ ema iBatisima yi Onodzi Osaan.>> ");
INSERT INTO utr_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Egbe oka nɛ iYesu kyato mi igeli iNadzareti mi ayɛsɛ iGalalia wa to ta, iJɔn si kyɔn iBatisima mi ekyoo iJodan. ");
INSERT INTO utr_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Dafi iYesu le kyato mi eni nɛ, o di esho kwulu man Onodzi kyɛ esho ba mbon dafi anyama mani. ");
INSERT INTO utr_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ta ela kyɛ esho gbɛɛ: <<Abu li Ongwɛ Ani mgbi itukwu-itukwu; i kpa ani yi abu saan.>> ");
INSERT INTO utr_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Onodzi byakpa kyon dɛsɔ lu okwɛsɛ akponyi, ");
INSERT INTO utr_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","o dzɛ okwɛsɛ egbe ngwusefa, ngwi iSatan le gyilan. O dzɛ yi emi mmbwaboshɛ, engyesɔ dile tobyun. ");
INSERT INTO utr_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Ngwi a wa kye iJɔn wokɛ obawi nɛ, iYesu kaka ifu iGalalia, le gbɔ Esɔ Osuse mgbi Imgbasho. ");
INSERT INTO utr_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","O gbɛɛ, <<Onɔ ma gyɔ wa. Esutɔ mgbi Imgbasho dzɛ kwɛkwɛ. Kyatitukwu mi ali ibwubwe mgbi ema di noyɛyɛ mi Esɔ Osuse nɛ na!>> ");
INSERT INTO utr_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Dafi IYesu nose le kyikyɛ mi ewuutɔ mgbi iGalalia nɛ, o di iSaimɔn yi Andru ongwunɔn le ngwi ukɛ mi utɔ, ikyena a li ama otuntsɛ. ");
INSERT INTO utr_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","O nya ma gbɛɛ, <<Kyɛdɔ ani na, ta n ka nu ema yɛɛ ama okwu inggisɛ, ka li mmbweni wuba.>> ");
INSERT INTO utr_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Ntunto nɛta a dzata ukɛ mgbi ama kyɛdɔn. ");
INSERT INTO utr_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Ngwi o gblekɛ iyayi gwee nɛ, o di iJɛnsi ongwɛ iDzebedi bɛyi ongwunɔn iJɔn mi uwaa, tole mɛ ukɛ mgbi ama. ");
INSERT INTO utr_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","O mbe onɔ ba ta kwu ma ela, ta a dzata otsɔma mi uwaa yi ama ngwu a kye ma idɔ untsɛ si kyɛdɔ iYesu. ");
INSERT INTO utr_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","A lu iKapenahun, man ngwi egbe otonyidɔ wa ba nɛ, iYesu kaka ifoozu okwakye mgbi emi iJuda si wita otsungwɔ. ");
INSERT INTO utr_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","I kwulu inggisɛ ntona ewo mi ungwɔ otsootso mgban, ikyekyɛ o tso ma dafi inggisɛ ongwu ndzɛ yi mfye mani, dzɛ dafi mgbi etsetse mgbi ola ntona ba. ");
INSERT INTO utr_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Mi onɔ ma ta, inggisɛ oka mi ozu okwakye mgbi emi iJuda ngwu esɛ dɔn ikye teela gbɛɛ, ");
INSERT INTO utr_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","<<Li alungwɔ ngwi abu mina yi eyi, iYesu ongwi iNadzareti? Abu ba owa dzili eyii? Ani ye inggisɛ ngwu abu dzɛ mani, Ongwɛ Osaan mgbi Imgbasho!>> ");
INSERT INTO utr_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","IYesu kyɔkyɔ yan gbɛɛ, <<Yile ondu tukwu! Tasɛ mbon!>> ");
INSERT INTO utr_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Onodzi obube na siin mfyumfye yi ela otaata man si tɔ dzanta. ");
INSERT INTO utr_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","I kwulu inggisɛ ntona ewo kpakpa ta a byi ewoma gbɛɛ, <<Li ekyɛ dɛn? Otsootso ofufɛ nkyɛ yi mfye! O li wo onodzi ibwubwe kpaa ola ta a li fwon.>> ");
INSERT INTO utr_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Odzɛ mgban si gbɔfwɛ vla kpatsɛ ayɛsɛ iGalalia duu. ");
INSERT INTO utr_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Ngwi a dzata ozu okwakye mgbi emi iJuda mata, a lu yi iJɛnsi bɛyi iJɔn mi udɛ mgbi iSaimɔn yi Andru. ");
INSERT INTO utr_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Awo bwa Onowa iSaimɔn ladzɛ esɛ, man a nya iYesu odzɛ mgban. ");
INSERT INTO utr_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Nghanɛ o kɛ mbon, yan abɔ kyilen sɔkunto. Awo na dzanta man o si wita ogbe ungwogye nu ma. ");
INSERT INTO utr_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Mi onɔdɛ na ngwi onɔ kaka esɛ nɛta, inggisɛ ntona gbe emi ootse bɛyi ama esɛ dɔ ma ikye ba mbi iYesu. ");
INSERT INTO utr_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Emi igeli na duu kwakye mi onufɛ, ");
INSERT INTO utr_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","man iYesu ngyɛlu inggisɛ gwuba ootse idzidza-dzidza. O di lɔ onodzi emɛsɛ gwuba onya, kpaa o gbela ni onodzi emɛsɛ gbɔdzɛ ba ikyekyɛ a ye itɔ inggisɛ ngwu o dzɛ mani. ");
INSERT INTO utr_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Mi egbegbe ototu ngwi imbe ka yifu nɛ, iYesu kyato dzata udɛ lu imbe ngwi o ka dzɛ yuon, bibɔ mi ele. ");
INSERT INTO utr_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Nɛ iSaimɔn yi angbeka ntona lu le pitan, ");
INSERT INTO utr_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","ngwi a tun nɛ, a nyan gbɛɛ, <<Ali inggisɛ duu le pita abu!>> ");
INSERT INTO utr_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Nɛ iYesu nya ma gbɛɛ, <<I kɛ agwɔ angbeka ama nto kwɛkwɛ nɛni, zukwu nin ka gbeesɔ mi ele kpaa, lubana li ikye ungwɔ ngwi ani ba ma aali.>> ");
INSERT INTO utr_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Nghanɛ o dzagaba kpatsɛ iGalalia, le gbeesɔ mi ozu okwakye mgbi emi iJuda dile lɔ emi onodzi emɛsɛ tɔ. ");
INSERT INTO utr_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Inggisɛ ndotsoma ba mbi iYesu wa kwakwafɔ esɛ tɛkyɛ nun gbɛɛ, <<Ni abu mina yɔ, o ki nu ani yɛɛ saan.>> ");
INSERT INTO utr_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Ngwi iYesu li di elela kpakpa nɛman o na abɔ mgban gbo inggisɛ na ewo di nyan gbɛɛ, <<Ani mina; yɛɛ saan!>> ");
INSERT INTO utr_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Plɛ nɛta otsoma dzanta man ootse mgban ngyɛ. ");
INSERT INTO utr_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","IYesu si byakpa nun ofɛ no lu di kwon adɔ saan gbɛɛ: ");
INSERT INTO utr_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","<<Di gbɛɛ abu nya inggisɛ onyi odzɛ nɛ ba. Kpaa lu ka kye ewabu tso inggisɛ ofifɛ mgbi Imgbasho di fifɛ dafi iMose nose woola ikye oyɛɛ saan mani, no li obwɛndɛ mboma.>> ");
INSERT INTO utr_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Nghaduu o lu le ka gbɔdzɛ ele dzii, dile gbɔfwɛ utsa nani. Ikyenghanɛ, iYesu yagba kaka igeli na mi ododa wuba kpaa lu ka dzɛkɛ imbe oklii. Jokpaa inggisɛ ntona dile ba mbon mi ali agya duu. ");
INSERT INTO utr_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Ngwi egbe wa sisi gwee nɛ, iYesu si yidɔ lu iKapenahun, inggisɛ ntona si fwo gbɛɛ o yɛ kaka udɛ. ");
INSERT INTO utr_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Ta inggisɛ kwuba kwakye mbonyi, nghanɛ imbe dzɛma wuba, onufɛ mi esɛ kpaa imbe dzɛ ba. IYesu sile gbeesɔ nya ma. ");
INSERT INTO utr_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Ta inggisɛ angbeka nghi enɛ wa to, kye inggisɛ ngbikye tukwu esɛ le ba mbi iYesu. ");
INSERT INTO utr_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Dafi a yagba kyon kaka mbi iYesu ba ikye ibyi inggisɛ nɛ, a ka flɛ ikpendu mi ikye mgbi iYesu yɛyɛ man kyon tashulu yi amukwu wa lakiyayi iYesu. ");
INSERT INTO utr_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Ngwi iYesu di oyɛyɛ onuunu mgbi ama nɛ, o nya inggisɛ ngbikye tukwu esɛ na gbɛɛ, <<Ongwɛ, a dzita abu yi ali ibwubwe mgbi abu.>> ");
INSERT INTO utr_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Etsetse mgbi ola mgbi iMose angbeka sɔto mmanani, a le tsɛwɛ mi itukwu mgbi ama gbɛɛ, ");
INSERT INTO utr_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","<<Kyɔsinɛse inggisɛ nɛ gbɔdzɛ ngha? O le kwu Imgbasho shanyɛ! Li emɛ ka dzɛ inggisɛ ta yi obube se Imgbasho yuon ta baa?>> ");
INSERT INTO utr_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Plɛ nɛta, iYesu ka ye mi onodzi mgban gbɛɛ li ungwɔ ngwi a le tsɛwɛ mi itukwu mgbi ama joaali, man o nya ma gbɛɛ, <<I kyɔsinɛ ngwi ema le tsɛwɛ itɔ ungwɔ ntonɛ? ");
INSERT INTO utr_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Li ole nghao sunɔ ba: onya inggisɛ ngbikye tukwu esɛ na gbɛɛ, <A dzɛ abu ta yi ali ibwubwe,> naadi o gbɛɛ, <Kyato, kyelu obutu mgbi abu kyikyɛ>? ");
INSERT INTO utr_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Nghaduu li onu ema ye gbɛɛ Ongwɛ Inggisɛ dzɛ yi mfye mi ɛsɛ nɛ odzɛ inggisɛ ta yi ali ibwubwe…>> O nya inggisɛ ogbikye tukwu esɛ na gbɛɛ, ");
INSERT INTO utr_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","<<N nya abu, kyato, kyelu obutu mgbi abu lu udɛ.>> ");
INSERT INTO utr_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","O kyato, kyelu obutu mgban si kyikyɛ mi inai ma duu. Ungwɔnɛ kwulu ali inggisɛ duu ewo man a si tsɛ Imgbasho, le gbɛɛ, <<Eyi yama di itɔ ungwɔnɛ ye ba!>> ");
INSERT INTO utr_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Nɛ iYesu di yidɔ kɛ ondu utɔ mgbi iGalalia. Ibyi inggisɛ ba mbon, ta o si wita otso ma. ");
INSERT INTO utr_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Dafi o kyikyɛ le kɛ nɛ, o di inggisɛ ogbɛ udza ifyɛɛ, iLevi ongwɛ Alfeɔ sɔdzɛ opo ogbɛ udza ifyɛɛ. Man iYesu nyan gbɛɛ, <<Kyɛdɔ ani,>> ta iLevi kyato kyɛdɔn. ");
INSERT INTO utr_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Dafi iYesu le gye ungwogye ongwi onɔdɛ mi udɛ iLevi nɛ, ama ogbɛ udza ifyɛɛ kwuba yi <<emi ali ibwubwe angbeka>> tole gye ungwogye biyan bɛyi engwafɔɔn, lubana inggisɛ kwuba kyɛdɔn. ");
INSERT INTO utr_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Ngwi etsetse mgbi ola mgbi iMose ama nli emi iFarasi din le gye ungwogye yi <<emi ali ibwubwe>> yi ama ogbɛ udza ifyɛɛ nɛ, a byi engwafɔɔn gbɛɛ: <<Kyɔsinɛ ngwi ongyukwo mgbi ema le gye ungwogye yi ama ogbɛ udza ifyɛɛ yi <emi ali ibwubwe>? >> ");
INSERT INTO utr_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Ngwi IYesu fwo ungwɔnɛ nɛ, o nya ma gbɛɛ, <<Li ama nle saan ma li mina inggisɛ obwe ootse ba, kpaa li emi ootse. Ani ba owa kwu ama nle saan ela ba, kpaa li emi ali ibwubwe.>> ");
INSERT INTO utr_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Onɔ oka nɛ ama okyɛ yi iJɔn okyɔ iBatisima bɛyi emi iFarasi tole tukwondu. Inggisɛ angbeka si ba wa byi iYesu gbɛɛ, <<Kyɔsinɛse ngwi engwafɔ mgbi iJɔn okyɔ iBatisima bɛyi engwafɔ mgbi emi iFarasi tole tukwondu, kpaa engwafɔ mgbi abu le tukwondu ba?>> ");
INSERT INTO utr_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","IYesu nya ma gbɛɛ, <<Ingyoga emi oga mgbi eba ka tukwondu onɔ ngwi obongyaa dzɛ yi ama maa? Ungwɔ ka dzɛ ngha ba du. Ngwi a ka dzɛ yi obongyaa tayɔ, a ka yama tukwondu ba. ");
INSERT INTO utr_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Nghaduu onɔ kyɛma ngwi a ka kyi kyelu obongyaa mi idzidzɛ ma ta a ka tukwondu. ");
INSERT INTO utr_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","<<Inggisɛ onyi li kye ayɛ angwuto ofufɛ kye tukwu ogbugbe ba. Ki non kyɔ ngha, ayɛ ofufɛ na ka kyi kwolu di fawa angwuto ogbugbe nani, dika nu ifo na yɛɛ vɔn. ");
INSERT INTO utr_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Inggisɛ onyi dika kye eneekwɔ ofufɛ yaokɛ ikpɔkpɔ eneekwɔ ogbugbe ba, ikyekyɛ eneekwɔ na ka nu ikpɔkpɔ gbobu, man eneekwɔ bɛyi ikpɔkpɔ duu ka nyanya. Kyɛmɛ yɔ a ka kye eneekwɔ ofufɛ yaokɛ ikpɔkpɔ ofufɛ.>> ");
INSERT INTO utr_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Egbe otonyidɔ mgbi emi iJuda oka nɛ, iYesu le kyikyɛ nyɛ okwɔ ungwogyowe, dafi engwafɔɔn wafɔ yan le kɛ nɛ, a wita ole ngwunu ungwogyowe. ");
INSERT INTO utr_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Emi iFarasi gbɔ yan gbɛɛ, <<Dika, kyɔsinɛ ngwi a le kyungwɔ nli ola ba mi egbe otonyewo ngha?>> ");
INSERT INTO utr_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","IYesu si nya ma gbɛɛ, <<Ema gbɔ ungwɔ ngwi iDevedi yi emi ibugen nose kyɔ mi onɔ ngwi enbwa dɔ ma ngwi a di dzɛ mi imina na baa? ");
INSERT INTO utr_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Mi onɔ ngwi Abiata nose li okwukwo inggisɛ ofifɛ mgbi Imgbasho mani, iDevedi kaka ozu mgbi Imgbasho ka gye ibredi ngwi a kye mse bɛ ele kye dzɛkɛ kyoon, ngwi ola gbɛɛ li ama ofifɛ mgbi Imgbasho ta ka gye mani. O di kye nu emi ibugen kpaa.>> ");
INSERT INTO utr_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Nɛ iYesu nya ma gbɛɛ, <<A ta egbe otonyewo mi ikye inggisɛ, li inggisɛ ngwi a ta mi ikye egbe otonyewo ba. ");
INSERT INTO utr_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Nghanɛ Ongwɛ Inggisɛ li Otsɛ mgbi egbe otonyewo kpaa.>> ");
INSERT INTO utr_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Onoka nɛ iYesu kɛ ozu okwakye mgbi emi iJuda, man inggisɛ nkwulu abɔ dzɛ ele. ");
INSERT INTO utr_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Angbeka mi ele le pita itɔdzɛ ni ama kye abɔ byi efu nun obube, nghanɛ a gbe inɛ fyakwun ikye odi non ka ngyɛlu inggisɛ na ootse mi egbe otonyewo yɔ. ");
INSERT INTO utr_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Nɛ iYesu nya inggisɛ okwulu abɔ na gbɛɛ, <<Kyato dzɛkunto mi inai ali inggisɛ duu.>> ");
INSERT INTO utr_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Ta iYesu byi ma gbɛɛ, <<Li ole nghao li ola mi egbe otonyewo: okyɔ osuse naadi okyɔ obube, odulu oshishe watɔ naadi ongwɔɔngwɔ?>> Kpaa a gbɔdzɛ onyi ba. ");
INSERT INTO utr_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","O kyidi ma kpatsɛ yi itingga man i kakan ewo lu byulu mi itukwu otiishu mgbi ama nani, iYesu nya inggisɛ na gbɛɛ, <<Na abɔ mgbi abu.>> O nan tɔ, man abɔ mgban byakpa yɛɛ saan. ");
INSERT INTO utr_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Man emi iFarasi ntona tasɛ lu ka tsɛwɛ yi emidi iHerude dafi ama ka kyɔ duse ngwɔ iYesu mani. ");
INSERT INTO utr_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Man iYesu tasɛ yi engwafɔɔn lu utɔ iGalalia, nɛ ibyi inggisɛ mi iGalalia kyɛdɔn. ");
INSERT INTO utr_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Ngwi a fwo alungwɔ ngwi o le kyɔ nɛ, inggisɛ kwuba mi iJudia, iJerosalin, Idumia yi imbe angbeka mi oyombo ekyoo iJodan bɛyi imbe angbeka kwɛkwɛ yi ogalu iTire yi iSidon ba mbon. ");
INSERT INTO utr_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Ikyegbɛɛ inggisɛ mbwo lamyɛ nɛ, iYesu nya engwafɔɔn gbɛɛ nu ma pita ongwuwaa dzɛ fɛɛfɛ ongwu, di a wa dzi ongwu bɛkɛ esɛ. ");
INSERT INTO utr_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Lubana o ngyɛlu inggisɛ kwuba ootse, nghanɛ ama nto yi ootse idzidza-dzidza le na kiyayi ikye ni ama kye abɔ gbon. ");
INSERT INTO utr_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Alonɔ ngwi onodzi okpɛkpɛ din yɔ, a li gbɛsɛ lakiyayi mbon dile makwɔ gbɛɛ, <<Abu li Ongwɛ Imgbasho.>> ");
INSERT INTO utr_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Nghaduu o wo ma ola kpakpa gbɛɛ nu ma ka gbɔ nya inggisɛ onyi itɔ inggisɛ ngwi ongwu dzɛ ba. ");
INSERT INTO utr_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","IYesu tɔ lu esho mi ewunggwɔ si kwu ama ongwu mina ma ela, ta a ba mbon. ");
INSERT INTO utr_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Nɛ o sadu iwyodefa mboma gbɛɛ nu ma li ama ogbikye ongwu, ikyegbɛɛ nu ma dzɛ yi ongwu, ni ongwu di dɔ ma tasɛ ka gbeesɔ ");
INSERT INTO utr_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","odi dzɛ yi mfye ngyɛlu ootse di lɔ onodzi ibwubwe tɔ. ");
INSERT INTO utr_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Ntonɛ li iwyodefa ama o sadu ma aani: iSaimɔn (ongwu o nun iyi di iPyita) ");
INSERT INTO utr_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","iJɛnsi ongwɛ iDzebedi bɛyi ongwunɔn iJɔn (mboma o nu ma iyi di iBonɛgɛ, ngwi itan gbɛɛ emi ongwɛ akpala), ");
INSERT INTO utr_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andru, iFyilipi, iBatlomi, iMatiu, iTɔmɔsu, iJɛnsi ongwɛ Alfeɔ, iTedusu yi iSaimɔn Ogbodami ");
INSERT INTO utr_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","bɛyi iJuda Iskarɔti, ongwu nkye iYesu gya nani. ");
INSERT INTO utr_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Nɛ iYesu kaka udɛ, ta ibyi inggisɛ di kwakye kpɔɔ, man iYesu yi engwafɔɔn yagba ogye ungwogye kpaa gbɛ ba. ");
INSERT INTO utr_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Onɔ ngwi etɔ mgban fwo odzɛ nɛ nɛ, a lu ikye oka gbekabyin, ikyekyɛ a gbɛɛ, <<O dzɛ mi odzɛɛdzɛ mgban wuba.>> ");
INSERT INTO utr_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Man ama otso ola mgbi iMose nkyɛ mi iJerosalin gbɛɛ, <<Onodzi iBɛdzɛbu wodzɛ mbi inggisɛ nɛni! O dile lɔ onodzi emɛsɛ tɔ mi mfye nani.>> ");
INSERT INTO utr_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Nghanɛ iYesu kwu ma ela gbɔdzɛ yi ama mi utsa gbɛɛ: <<ISatan ka lɔ iSatan onya tɔ sinɛ? ");
INSERT INTO utr_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Ni esutɔ gha yi ewoma, esutɔ na ka yagba kwudzɛ gbɛ ba. ");
INSERT INTO utr_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Ni udɛ gha yi ewoma, udɛ na ka yagba kwudzɛ gbɛ ba. ");
INSERT INTO utr_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Ma ni iSatan kye afɔ twɛsɛ yi ewon di yɛ gha, o ka kwudzɛ gbɛ ba; ongyɛɛngyɛ mgban ba sewaali. ");
INSERT INTO utr_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Mi odzimɔ yɔ, inggisɛ onyi kpaa ka yagba kaka udɛ inggisɛ mfye gben okye ba, sede o ka tsekise bwa inggisɛ mfye na adi. Duuse o ka gben okye. ");
INSERT INTO utr_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","N nya ema otsitsi, ali ibwubwe yi ito ngwi inggisɛ le fya Imgbasho duu a ka kye toma mkpa. ");
INSERT INTO utr_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Nghaduu inggisɛ ta nkwu Onodzi Osaan fyito, a ka dzanta yi obube ba; ikyekyɛ o kyɔ alobube nli gyegwu.>> ");
INSERT INTO utr_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","IYesu gbɔdzɛ nɛ ikyekyɛ a le gbɛɛ, <<O dzɛ yi onodzi obube mbon.>> ");
INSERT INTO utr_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Nɛ onɔ iYesu yi emi ongwunɔn wa to. A kwulɛsɛ mi esɛ si dɔ inggisɛ oka kɛ ifun oka kwun ela. ");
INSERT INTO utr_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Ibyi inggisɛ sisɛ kpakɛkɛ won, a si nyan gbɛɛ, <<Onabu yi engwunabu to esɛ le pita abu.>> ");
INSERT INTO utr_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","IYesu si byita gbɛɛ, <<Li angbele li emi onani yi engwunani?>> ");
INSERT INTO utr_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Ta o ndinɛ mbi ama nsɔ kpakɛkɛ won ma si gbɛɛ, <<Dii, ntonɛ li emi onani yi engwunani aani! ");
INSERT INTO utr_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Ali inggisɛ nkyɔ owitukwu mgbi Imgbasho li ongwunani ongyulɔ yi ongyaa bɛyi onani.>> ");
INSERT INTO utr_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","IYesu di wita otso ma mi ondu utɔ. Ibyi ama nkpakɛkɛ won ma mbwo nyɛsɛ nɛta, o kaka sɔkɛ ifu uwaa nbɛdzɛ utɔ mani, inggisɛ ntona duu kwutokɛ agobo. ");
INSERT INTO utr_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","O tso ma ungwɔ kwuba mi utsa, mi otsootso mgban ma o gbɛɛ: ");
INSERT INTO utr_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","<<Gadɔ! Inggisɛ okwɔ tasɛ oka fwe etɔ. ");
INSERT INTO utr_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Dafi o le fwe nɛta, angbeka ngwuta mi ofɛ, ingwunɔ wa kye salu gye. ");
INSERT INTO utr_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Angbeka ngwuta mi akwutsɛ, imbe ngwi ekyɛ mɛ ma saan ba, a ndzili labɔ-labɔ, ikyekyɛ ekyɛ na le hilɛhilɛ. ");
INSERT INTO utr_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Ngwi onɔ wa tsɛ nɛ, a gbufyo, kwulu ikyekyɛ a sulu akpa ba. ");
INSERT INTO utr_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Etɔ angbeka yaokɛ ato, ato ntona she tukwu ma, man a yagba fwɛ ba. ");
INSERT INTO utr_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Nghaduu etɔ angbeka yangwuta mi ekyɛ osuse, lu tɔ, i she diyɛ wa kwuba, ngha ongwi ababɔ na akpe osudiwyo, ngwuseta, hona akpe ideli kpaa.>> ");
INSERT INTO utr_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Ta IYesu gbɛɛ, <<Inggisɛ nsulu adɔ ofwoofwo yɔ, no fwo.>> ");
INSERT INTO utr_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Ngwi o kwudzɛ yuon nɛ, emi iwyodefa bɛyi ama nkpakɛkɛ won ma byun ita mi utsa nani. ");
INSERT INTO utr_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","O nya ma gbɛɛ, <<A kye ungwɔ odaada mgbi esutɔ mgbi Imgbasho kye gbɔ nya ema. Kpaa ama nto esɛ yɔ, alungwɔ duu sede ka li mi utsa ngwi a ka gbɔn nya ma ");
INSERT INTO utr_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","ikye, << <Nu ma di kpaa, a ka sakwulun ba, nu ma fwo kpaa, ka gbosa loma ba; kana a ka wa kyata nu ma dzita ma yi ali ibwubwe!> >> ");
INSERT INTO utr_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Ta iYesu byi ma gbɛɛ, <<Utsa nɛ gbosa lo ema lo? Nghama ka kyɔsinɛ ngwi utsa oka ka gbosa lo ema? ");
INSERT INTO utr_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Inggisɛ okwɔ kye elodzɛ Imgbasho fwe. ");
INSERT INTO utr_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Inggisɛ angbeka to dafi etɔ n yangwuta mi ofɛ nani. Labɔlabɔ ngwi a fwo mata, iSatan wa kye gbɛlu elodzɛ ngwi a kye fwe mboma mani. ");
INSERT INTO utr_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Angbeka to dafi etɔ n yangwuta mi imbe akwutsɛ mani, a fwo elodzɛ na akponyi ta a kye gbɛlu yi atsa. ");
INSERT INTO utr_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Nghaduu ngwi a dzɛ yi akpa ba nɛ, a dzɛ onɔ gwee ta. Ngwi okakewo hona isɔ wa ba mi ikye elodzɛ na nɛta, a byakpa yɛ atata. ");
INSERT INTO utr_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Angbeka di to dafi etɔ ngwi a fwe yaokɛ ato mani, a fwo elodzɛ nɛni; ");
INSERT INTO utr_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","kpaa okakewo mgbi ɛsɛ nɛ, okpagyewo mgbi aludu, yi imina mgbi ungwɔ angbeka wa kaka, di dzɛ elodzɛ nɛ mmyɛ, no wa wuba. ");
INSERT INTO utr_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Angbeka to dafi etɔ ngwi a fwe mi ekyɛ osuse, a fwo elodzɛ na kye gbɛlu, i wa ngha ungwɔ ngwi a kye fwe na akpe osudiwyo, ngwuseta, ideli jokpaa.>> ");
INSERT INTO utr_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","O di byi ma gbɛɛ, <<Ema li kye ipitila kaka ikye okye mgboko tukwun, hona kye wokɛ ifagwudoo? Li mi ikye adinyatsɛ ngwi ema li kye dɔkɛ baa? ");
INSERT INTO utr_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Lubana ungwɔ ndzɛ mi odaada duu ka yɛɛ gedee, alungwɔ ngwi a di kye tukwulu kpaa ka dɔ esɛ mi ododa. ");
INSERT INTO utr_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Inggisɛ ndzɛ yi adɔ ofwoofwo yɔ, no fwo.>> ");
INSERT INTO utr_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","O kiyayi gbɛɛ, <<Kye eka byi saan mi ungwɔ ngwi abu fwo mani, li ombaamba ngwi abu mba ma ngwi a ka mba nu abu aali, jo nghaangha kpaa. ");
INSERT INTO utr_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Ali inggisɛ nsulun yɔ a ka yɛ mbwon, ongwu nsulun ba ma, ogwee ngwi o dzɛyan ma kpaa a ka kye gbɛlu mbon.>> ");
INSERT INTO utr_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","O diyɛ gbɛɛ, <<Esutɔ mgbi Imgbasho dzɛ sini: dzɛ dafi inggisɛ kye etɔ ungwɔ fwe mi ikpɛsɛ mani. ");
INSERT INTO utr_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Otu yi onɔ, ki non lasisa hona le nuna kpaa, o ye dafi i kyɔ se etɔ na le she ba. ");
INSERT INTO utr_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Li ikpɛsɛ li nu ungwogye lumbye, ababɔ itan li tɔ, man li wa ngwiidɛ, se wo inɛnɛ. ");
INSERT INTO utr_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Labɔ-labɔ ngwi etɔ na myɛ mata, o li kye agɛbɛ dɔkɛ ele, ikyekyɛ onɔ ongwa etɔ gyɔ.>> ");
INSERT INTO utr_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","IYesu diyɛ gbɛɛ, <<Li alungwɔ ngwi eyi ka gbɛɛ esutɔ mgbi Imgbasho lun, naadi li ali utsa ngwi eyi ka kye tso ambɛ mi ele? ");
INSERT INTO utr_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Dzɛ dafi inɛnɛ unkwodzi, nshanyɛ ngha inɛnɛ ali ekwɔ ngwi abu kye ye mi ikpɛsɛ mani. ");
INSERT INTO utr_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Nghaduu ni a kye ye, li she di yɛɛ gbagbadzidzi ngha ali ekwɔ mi okwɔ duu, li tsaabɔ okwukwo jo ingwunɔ emi esho kpaa li ba wa ludɛ mi abɔn.>> ");
INSERT INTO utr_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Yi utsa mbitɔ ntonɛ, iYesu gbɔ elodzɛ nɛ yi ama, o gbɔn kwuba gyɔ nu ma difwi mani. ");
INSERT INTO utr_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","O li dzɛdzɛ gbɔdzɛ yi ama ba sede mi utsa. Nghaduu non wa tɔ yuon yi engwafɔ mgban yɔ, o li nu ma osa mi alungwɔ duu. ");
INSERT INTO utr_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Onɔdɛ mi egbe nani, o nya engwafɔɔn gbɛɛ, <<I kɛ oyombo na.>> ");
INSERT INTO utr_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Ngwi a dzata ibyi inggisɛ mi iyikpa nɛ, a kye iYesu wafɔ yi ama, mi uwaa ngwi o tsekise sɔdzɛ efu mani. Uwaa angbeka kpaa kyɛdɔn. ");
INSERT INTO utr_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Onikyawo gbokyɛɛ, gbe akpeni le yaokɛ uwaa jo uwaa dzɛ kwɛkwɛ osulu. ");
INSERT INTO utr_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","IYesu ladzɛ ifu uwaa kye ikye dɔdzɛ ungwɔ okye ikye dɔ efu le nuna, engwafɔɔn kyilon, a byun gbɛɛ, <<Otsetse, ni eyi mbe eni kwulu kpaa li itɔdzɛ mbi abu ba lɔ?>> ");
INSERT INTO utr_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","O gbokyɛɛ, feela yi awo diyɛ nya akpeni gbɛɛ, <<Dede! Dzɛ shilididi!>> Man awo kwulu, imbe yɛɛ tsiin! ");
INSERT INTO utr_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","O nya engwafɔɔn gbɛɛ, <<Kyɔsinɛ ngwi ema tsimio ngha? Ema sulu oyɛyɛ onuunu walo?>> ");
INSERT INTO utr_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Idzidzi kwulu ma, a yɛ byi ewoma gbɛɛ, <<Nɛnɛ li emɛ? Ngwi awo bɛyi akpeni kpaa li fwon?>> ");
INSERT INTO utr_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","A foyombo utɔ lu ayɛsɛ iGeraseni nani. ");
INSERT INTO utr_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Ngwi iYesu tasɛ mi uwaa mata, ongyulɔ oka yi onodzi okpɛkpɛ tɔ mi imbe endzi wa tun. ");
INSERT INTO utr_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Inggisɛ nɛ li la imbe endzi, inggisɛ onyi dzɛma nka bwan adi gbɛ ba, kwoba yi ashi kpaa. ");
INSERT INTO utr_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Bana a li teyi bwan afɔ yi abɔ, kpaa o li byi ashi yi iyudza ntona kye gbɔdzɛ dulu afɔ tɔ. Inggisɛ onyi fyumfye mɛ osin bɛsɛ ba. ");
INSERT INTO utr_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Otu yi onɔ mi imbe endzi bɛyi undɔ ntona o li le teela diyɛ dzɛ ewon ifwa mi akwutsɛ. ");
INSERT INTO utr_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Ngwi o dili iYesu mbombo mata, o tsinya ka gbe akwafɔ kwokɛ esɛ mfyumfye mi iyayi iYesu. ");
INSERT INTO utr_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","O feela kpakpa, <<Li ekyɛ wo abu yi ani. IYesu, Ongwɛ Imgbasho ngwu ngha mi esho? Fa mbi Imgbasho gbɛɛ abu ka nu ani adzɛ ba!>> ");
INSERT INTO utr_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Ikyesinɛ iYesu teyi nyan gbɛɛ, <<Abu onodzi ibwubwe tasɛ mbi inggisɛ nɛni!>> ");
INSERT INTO utr_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Ta iYesu byun gbɛɛ, <<Iyi abu di emɛ?>> O nu uka gbɛɛ, <<Iyi ani gbɛɛ ibyibyi, ikyekyɛ eyi le kwuba.>> ");
INSERT INTO utr_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","O si tɛkyɛ diyɛ gbabɔ nu iYesu gbɛɛ, no ka lɔ ama onya dzata imbe nɛ ba. ");
INSERT INTO utr_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Obyia ibyibyi tole gye ungwogye kwɛkwɛ mi undɔ mi imbe nani. ");
INSERT INTO utr_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Onodzi ibwubwe ntona tɛkyɛ nu iYesu gbɛɛ, <<Lɔlu eyi kaka obyia ntonɛni; noofɛ ni eyi kaka mboma.>> ");
INSERT INTO utr_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","O nu ma ofɛ, man onodzi ibwubwe ntona tasɛ lu ka yaokɛ mbi obyia ntonani. Obyi obyia na mɛ dafi idubu efa sini, a tashulu mi agblo yaokɛ utɔ si dzili. ");
INSERT INTO utr_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Ama ongyo obyia ntona tsinya lu ka gbɔ mi igeli bɛyi ayɛsɛ nani. Inggisɛ gbe ewoma tasɛ le wa di ungwɔ nkiyayi mani. ");
INSERT INTO utr_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Ngwi a ba mbi iYesu nɛ, a si di inggisɛ ngwu esɛ gbeka dɔn ikye nani, sɔdzɛ mmana, wo angwuto, itukwu mgban yɛɛ saan, man a tsimio. ");
INSERT INTO utr_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Ama ndi mani a gbɔ nya inggisɛ ungwɔ nkyɔ ongyulɔ ngwu esɛ dɔn ikye nani, bɛyi odzɛ mgbi obyia ntona kpaa. ");
INSERT INTO utr_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Nghanɛ inggisɛ ntona wita otɛɛkyɛ nu iYesu gbɛɛ no dzata ayɛsɛ mgbi ama. ");
INSERT INTO utr_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Dafi iYesu le kaka ifu uwaa nɛ, inggisɛ ngwu esɛ dɔn ikye na tɛkyɛ gbɛɛ ongwu ki lu yan. ");
INSERT INTO utr_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","IYesu gbela ba, kpaa o gbɛɛ, <<Lu udɛ mbi etɔ mgbi abu dika nya ma ungwɔ okwukwo ngwi Otsɛ Imgbasho kyɔ yi abu, bɛyi itɔ elela ngwi o di abu nɛni.>> ");
INSERT INTO utr_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Inggisɛ na si lu ka wita le gbɔ mi iDekapoli (ogalu iwyo ntona) ungwɔ okwukwo ngwi iYesu kyɔ mi ikye mgbi ongwu nani. I si kwulu inggisɛ duu ewo. ");
INSERT INTO utr_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Onɔ ngwi iYesu diyɛ fa mi uwaa dɔkɛ oyombo utɔ nɛ, ibyi inggisɛ kwuba kpakɛkɛ won ngwi o kwudzɛ ondu utɔ mani. ");
INSERT INTO utr_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Man onyi mi idzidzɛ mgbi ama oteyi mi ozu okwakye mgbi emi iJuda, iyin di iJaru badzɛ imbe nani, ngwi o dili iYesu nɛta o si lankɛ esɛ mi iyayi, ");
INSERT INTO utr_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","diyɛ tɛkyɛ nun saan gbɛɛ, <<Ongwani ongyaa ongwu ongbungbɛ le kwulu, tsuutsu ba wa kye abɔ mgbi abu gbon ewo azukwu ni ewo mgban gbosa no dzɛ oshishe.>> ");
INSERT INTO utr_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Nghanɛ iYesu wafɔ yan. Ijiji inggisɛ kyan iyikpa kwuba, imbe flengba lon. ");
INSERT INTO utr_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Ongyaa oka kpaa dzɛ mmana ngwu teka ogyiiyɛ onova iwyodefa. ");
INSERT INTO utr_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","O gyisɔ kwuba mi abɔ mgbi ama obwe ootse, di kye mbelu ungwɔ ngwi o sulun duu, ngwi ewo kika gbosa nɛ ootse nghao kɛɛkiyayi. ");
INSERT INTO utr_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Ngwi o fwo odzɛ iYesu nɛ, o si gbuokɛ idzidzɛ inggisɛ wa kye abɔ gbon angwuto mi iyikpa, ");
INSERT INTO utr_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","ikyekyɛ o tsɛwɛ gbɛɛ, <<kini ani kye abɔ gbon angwuto kpaa ta, ootse mgbɛn ka ngyɛ.>> ");
INSERT INTO utr_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Labɔlabɔ nɛ eyi odɛɛdɛ mgban dzɛ man o si difwi mi idzidzɛ ewo mgban dafi isɔ na gbosa mani. ");
INSERT INTO utr_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","IYesu jakpa difwi akponyi dafi mfye tɔ lo ongwu mi ewo mani. O kyata inɛ byi ibyi inggisɛ ntona si byita gbɛɛ, <<li emɛ kye abɔ gbo ani angwuto?>> ");
INSERT INTO utr_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Emi ongwafɔ mgban nun uka gbɛɛ, <<Abu di inggisɛ tsiibyi wo abu, kpaa abu dile byita gbɛɛ, <Li emɛ kye abɔ gbo anii?> >> ");
INSERT INTO utr_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Nghaduu iYesu kiyayi ondinɛ inggisɛ nkyɔ ngha mani. ");
INSERT INTO utr_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Ngwi ongyaa na difwi ungwɔ nkyɔn nɛ, o si ba wa lakɛ esɛ mi iyayi iYesu, ewo le shiishi lon yi imio, o si nyan otsitsi ungwɔ ndzɛ duu. ");
INSERT INTO utr_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","O nyan gbɛɛ, <<Ongyaa, oyɛyɛ onuunu mgbi abu ngyɛlu abu ootse. Kɛ ise diyɛ tɔ mi isɔ mgbi abu nɛni.>> ");
INSERT INTO utr_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Ngwi iYesu kale gbɔdzɛ nɛta, engyulɔ angbeka tɔkyɛ udɛ iJaru, inggisɛ oteyi mi ozu okwakye mgbi emi iJuda. A gbɛɛ, <<Ongwabu kwulu ma li ekyɛ ngwi abu kale kaka otsetse ewo?>> ");
INSERT INTO utr_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","IYesu gbadikye mi odzɛ ngwi a gbɔ na man, O si nya ongye oteyi ozu okwakye mgbi emi iJuda na gbɛɛ, <<ka tsimio ba, noyɛyɛ ta i ngyɛ.>> ");
INSERT INTO utr_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","O nu inggisɛ onyi kyan iyikpa ba sede iPyita, iJɛnsi yi iJɔn ongwunɔ iJɛnsi ta. ");
INSERT INTO utr_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Ngwi a ba udɛ ongye oteyi ozu okwakye mgbi emi iJuda nɛ, iYesu di imbe yɛɛ yuu yi akwɔ bɛyi ikwu otseetse mi ela okwukwo. ");
INSERT INTO utr_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","O kaka ifun di nya ma gbɛɛ, <<I kyɔsinɛ ngwi ema nu imbe suusu yi ikwu otseetse ngha? Ongwɛ nɛ kwulu ba kpaa o nanuna ta.>> ");
INSERT INTO utr_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Nghaduu a shan isha. Onɔ ngwi o nu ma tasɛ nɛman, o kyi kyelu ama omban bɛyi engwafɔ mgban nghi eta ntona kaka ifoozu imbe ngwi ongwɛ se ladzɛ mani. ");
INSERT INTO utr_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","O kpalun abɔ nyan gbɛɛ, <<Italita kumi!>> (Itan gbɛɛ, <<Ongwongyaa ongbungbɛ, ani le nya abu gbɛɛ, kyato!>>). ");
INSERT INTO utr_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Labɔlabɔ nɛta ongwongyaa na kyɛɛ dzɛkunto le kyikyɛ yilili kpatsɛ (o li onova iwyodefa). Mi ungwɔnɛ i kwulu ma ewo saan. ");
INSERT INTO utr_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","O wo ma ola kpɔklɔɔ gbɛɛ nu ma ka nu inggisɛ onyi ye odzɛ ele ba, o diyɛ nya ma gbɛɛ nu ma nun ungwogye no gye. ");
INSERT INTO utr_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","IYesu dzata imbe na yɛ lu igeli mgban, emi ongwafɔɔn wafɔ yan. ");
INSERT INTO utr_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Ngwi egbe otonyidɔ mgbi emi iJuda wa gyɔ nɛ, o wita otso mi ozu okwakye mgbi emi iJuda, i kwulu ibyi inggisɛ ama nfwo ma ewo. A byita gbɛɛ, <<Li mi ole ngwi ongyulɔ nɛ tu ungwɔ ntonɛ? O tu itɔ ozoyeye nɛ mi ole jo le kyungwɔ ama okwulewo nɛ ngha lo! ");
INSERT INTO utr_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Nɛnɛ li inggisɛ ogbokwo ungwɔ nɛ baa? Ongwɛ iMeri ongwunɔ yi iJɛnsi, iJosisi, iJuda bɛyi iSaimɔn nɛ ba na? Emi ongwunɔn engyaa to yi eyi dɛn baa?>> Man itukwu wulu ma yan. ");
INSERT INTO utr_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","IYesu nya ma gbɛɛ, <<Oyegbɔ li dzɛ yi mmwɛ mi igeli, yi etɔ bɛyi udɛ mgban ba.>> ");
INSERT INTO utr_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","IYesu gbela kyungwɔ okwulewo mi imbe na wuba, sede li inggisɛ emi ootse gwee ta ngwi o kye abɔ gbo ma ewo nu ootse mgbi ama ngyɛ. ");
INSERT INTO utr_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","I kwulu iYesu ewo yi okwoba-kwoba oyɛyɛ onuunu mgbi ama nani. Ta iYesu kyikyɛ kpatsɛ le tso mi agwɔ agwɔ. ");
INSERT INTO utr_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Ngwi o kwu iwyodefa ntona ela ba mbon nɛ, o si kwu ma bɛ efa efa dɔ ma esɔ, diyɛ nu ma mfye ongha onodzi ibwubwe. ");
INSERT INTO utr_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Li ola ama ngwi o woma aani: <<Mi agaba nɛ, ka kye unkonyi byi ba na, ibredi ba, igbe ba, awuya mi ashiko ba sede okwuta ta. ");
INSERT INTO utr_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Gbe okpafɔ wo na, kpaa ka gbe abu nghi efa byi ba. ");
INSERT INTO utr_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ali udɛ ngwi ema ka kaka duu, dzɛ ele nghataa mbisɔ ngwi ema ka dzata igeli nani. ");
INSERT INTO utr_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Ali imbe ngwi a gbɛ ema hona fwo ema bayɔ, kye gbolu ombulu mi afɔ mi onɔ ngwi ema le lu mani, no yɛɛ obwɛndɛ obube mi ikye ma.>> ");
INSERT INTO utr_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","A tasɛ ka gbeesɔ gbɛɛ inggisɛ nu ma kyatitukwu. ");
INSERT INTO utr_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","A lɔ emɛsɛ onya tɔ mbi inggisɛ kwuba, di kye engyie kyi inggisɛ ama ndotse kwuba ikye di ngyɛlu ma ootse. ");
INSERT INTO utr_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Utɔ iHerude fwo odzɛ nɛni, dafi iyi mgbi iYesu gbɔfwɛ kpatsɛ mani. Angbeka tole gbɛɛ, <<IJɔn okyɔ iBatisima kyɛɛ mi ikwu, li ngha ngwi mfye ama okwulewo le kyidɔ nyɛ mbon aali.>> ");
INSERT INTO utr_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Angbeka gbɛɛ, <<O li Elaija.>> Angbeka kiyayi gbɛɛ, <<O li oyegbɔ, ndzɛ dafi onyi mi idzidzɛ oyegbɔ emi tugbe ntonani.>> ");
INSERT INTO utr_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Nghaduu ngwi iHerude fwo ungwɔnɛ nɛ, o gbɛɛ, <<IJɔn inggisɛ ngwu ani dzan ikye na, yɛ kyɛɛ mi ikwu!>> ");
INSERT INTO utr_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Bana iHerude abuon noola nu ma bwa iJɔn, nu ma bwan adi di kyon ka wokɛ obawi. O kyungwɔnɛ ngha mi ikye iHerodia, owa iFyilipi ongwunɔn ngwu o gbɛlun yɛɛ owan nani. ");
INSERT INTO utr_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Bana iJɔn teyi le nya iHerude gbɛɛ, <<Li ola ba ni abu gbɛlu ongwunabu ongyaa.>> ");
INSERT INTO utr_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Nɛman iHerodia sulu owitukwu obube yi iJɔn jo i minan ongwɔn kpaa o yagba ba, ");
INSERT INTO utr_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","ikyekyɛ iHerude le mio iJɔn dile ngyon, ikyesinɛ o yon dafi o li inggisɛ onyaan dile saan mani. Ngwi iHerude fwo iJɔn nɛta ewo fwɛ lon, jokpaa i kpan ole fwon. ");
INSERT INTO utr_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Mi onggyɛɛnggyɛ nɛ onɔ osuse wa ba. Mi egbe ombaamba mgban, iHerude kyɔ oga mi ikye mgbi emi idɔ mgban ama okwukwo yi oblakwutsɛ ama onoola bɛyi engyulɔ ama oteyi ɛsɛ iGalalia. ");
INSERT INTO utr_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Ngwi ongwɛ iHerodia ongwu ongyaa ba idzidzɛ wa shufwe nɛ, i nu iHerude bɛyi ingyoga oga mgban atsa. Utɔ nya ongwongyaa na gbɛɛ, <<Bɔ ani ungwɔ ngwi abu mina duu ani ka kye nu abu.>> ");
INSERT INTO utr_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Man o zondu yan mi ofaafa gbɛɛ, <<Alungwɔ ngwi abu bɔ duu n ka nu abu, ka mɛ anggai esutɔ mgbi ani.>> ");
INSERT INTO utr_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Ongwongyaa tasɛ ka byi onɔn gbɛɛ, <<Li ekyɛ ngwi ani ka bɔ nu ma kye nu ani?>> Onɔn gbɛɛ, <<Ikye mgbi iJɔn okyɔ iBatisima.>> ");
INSERT INTO utr_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Ongwongyaa byakpa yewo lu ifun mbi utɔ yi ibɔ nani: <<Ani mina ikye mgbi iJɔn okyɔ iBatisima mi akpɛtɛ onɛnɛni.>> ");
INSERT INTO utr_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Itukwu wulu utɔ kpakpa, nghaduu, ikyegbɛɛ o teyi fa mi inai ingyoga mgban nɛ, o yagba kwɔn gbɛ ba. ");
INSERT INTO utr_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","O byakpa wo ongye ongwɔ inggisɛ ola gbɛɛ no ba yi ikye mgbi iJɔn akponyi. Inggisɛ na ka kye dzɛlu iJɔn ikye mi obawi, ");
INSERT INTO utr_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","si yɛ yi ikye ma mi akpɛtɛ. Wa nu ongwongyaa se, ta o kye ka nu onɔn. ");
INSERT INTO utr_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Ngwi a fwo ungwɔnɛ nghanɛ, engwafɔ mgbi iJɔn wa kye ikwɔ mgban ka ndzi. ");
INSERT INTO utr_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Ama ogbikye iYesu yɛ wa kpakɛkɛ won le nyan ungwɔ ngwi ama kyɔ diyɛ tso tsatsa. ");
INSERT INTO utr_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Nɛ ikyegbɛɛ ibyi inggisɛ angbeka tole ba ba angbeka tole lu lu ngwi a tu onɔ ogye ungwɔ kpaa ba nɛ, o nya ma gbɛɛ, <<Bakɛ yi ani mi imbe ndede ni ema ka tonya na.>> ");
INSERT INTO utr_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Nghanɛ a wafɔ yi ewoma mi uwaa dzɛkyo lu mbi imbe dede mani. ");
INSERT INTO utr_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Nghaduu ibyi inggisɛ di dafi a le lu nɛ, a difwi ma di ye imbe ngwi a le kɛ mani ta a tsinya tɔ mi igeli duu kye mwaamwa teyi ma ka kaka. ");
INSERT INTO utr_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Ngwi iYesu tasɛ mi uwaa diyɛ dili ibyi inggisɛ nɛ, elela kyɔn wo ma, ikyekyɛ a yɛɛ dafi mmala ama ndzɛ yi inggisɛ ongyo ma ba mani. Ta o di tso ma ungwɔ kwuba. ");
INSERT INTO utr_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Mi onɔ na, dafi onɔ le gbɛsɛ wa, nɛ engwafɔ mgban ba mbon, wa nyan gbɛɛ, <<Imbe nɛ li ifoshɛ, onɔ di kɛ byulu. ");
INSERT INTO utr_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Nu inggisɛ ntonɛ ofɛ zukwu nu ma lu ogalu ama nto kwɛkwɛ ka gya ungwogye abuoma gye.>> ");
INSERT INTO utr_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Nghaduu o gbɛɛ, <<Ema kye ungwɔ nu ma gye na.>> A nyan gbɛɛ, <<Nana ka mɛ udza ofyia egyata mgbi inggisɛ idɔ onyi! Ni eyi ka mbe itɔ udza na kpakpa ogya ibredi nu ma gyee?>> ");
INSERT INTO utr_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","O byita gbɛɛ, <<Ema sulu ibredi olɔlɔ nghi eminɛ? Kɛ ka kyidi na.>> Ngwi a kɛ ka kye gbɔlu nɛ, a gbɛɛ, <<IBredi olɔlɔ nghi eda yi abatsa efa.>> ");
INSERT INTO utr_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Nghanɛ iYesu nu ma elodzɛ gbɛɛ, nu ma nu inggisɛ ntonɛ duu sisɛ ibwi-ibwi mi oshɛ indinda nɛni. ");
INSERT INTO utr_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Man a si sisɛ mi otsotsa, ideli ideli bɛyi ngwusefa dɔn iwyiwyo. ");
INSERT INTO utr_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Ngwi o kyi kyelu ibredi eda yi abatsa efa ntona, di kyile inɛ esho nɛ, o kye angba nu Imgbasho man kye mwalu ibredi ntonani. Kye nu engwafɔɔn gbɛɛ nu ma kye gha ibyi inggisɛ ntonani. O di kye ghalu abatsa efa ntona gyaakye ma duu. ");
INSERT INTO utr_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ama duu gye tolo. ");
INSERT INTO utr_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Engwafɔ mgban kye salu ambulu ibredi yi abatsa nsisi ma mbwo uya iwyodefa kyɛɛ-kyɛɛ. ");
INSERT INTO utr_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Mmbwo engyulɔ ama ngye ma li idubu eda. ");
INSERT INTO utr_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Ngwi iYesu le wo ibyi inggisɛ ntona ofɛ nɛ, o nu engwafɔɔn plɛ kaka uwaa teyun lu iBɛtsaida, ");
INSERT INTO utr_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Ngwi iYesu dzata ma nɛ, o tɔkɛ lu ewunggwɔ le ka bibɔ. ");
INSERT INTO utr_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Mi oba onɔdɛ nɛ, uwaa kye ama ntona ka to idzidzɛ utɔ, ongwu tila dzɛ esɛ yuon. ");
INSERT INTO utr_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","O di engwafɔ mgban tole gbili yi akpeni, ikyekyɛ awo le nu ma okakewo, mi obyi enɛ ongwi ikyegbe o tɔ ka tu ma, le kyikyɛ mi ikye eni. O ba dafi o ka wa nyɛ ma mani, ");
INSERT INTO utr_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","kpa ngwi a di dafi o le kyikyɛ mi ikye eni nɛ, a tsɛwɛ gbɛɛ o li onodzi inggisɛ ikwukwɔ. Man a gbobakwɔ, ");
INSERT INTO utr_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","ikyekyɛ ama duu din tsimio. Mi onɔ nata, o si nya ma gbɛɛ, <<Fyumfye itukwu na! Ka yama mio ba na, li ani.>> ");
INSERT INTO utr_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Nɛ o kaka uwaa yi ama man awo kwulɛsɛ akponyi. Ta ewo fwɛ loma tsatsa, ");
INSERT INTO utr_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","ikyesinɛ ungwɔ okwulewo mgbi ibredi na gbosa loma ba; lubana a kye itukwu tiishu. ");
INSERT INTO utr_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Ngwi a dzɛkyo nɛ, a ka bɛɛsɛ mi iGenesareti di kye uwaa shadi mi ele. ");
INSERT INTO utr_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Labɔlabɔ ngwi a tɔ mi uwaa nɛman inggisɛ byakpa dilifwi iYesu. ");
INSERT INTO utr_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","A wulu onya mi ayɛsɛ na duu gbe emi ootse mi obutu lukwun kɛ imbe ngwi a fwo gbɛɛ o dzɛ duu. ");
INSERT INTO utr_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Ali imbe mi agwɔ ngwi o kɛ duu, igeli hona agya ɛsɛ, a li gbe emi ootse wa lakɛ ifyidu. A gbabɔ nun gbɛɛ o ki nu ama kye abɔ gbo-gbo ondu angwuto mgban kpaa ta, ama nkye abɔ gbon duu ewo gbosa loma. ");
INSERT INTO utr_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Emi iFarasi bɛyi etsetse mgbi ola mgbi iMose angbeka ama nkyɛ mi iJerosalin kpakɛkɛ wo iYesu man ");
INSERT INTO utr_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","a di engwafɔ iYesu angbeka le gye una yi abɔ <<oshimbi-shimbi>> ali ma, a sabɔ ba. ");
INSERT INTO utr_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(Emi iFarasi yi emi iJuda duu a li dzɛ-dzɛ ta gye ungwogye ba, a li sabɔ mbisɔ ola mgbi ama ma se, okyɔ aletɔ mgbi ama. ");
INSERT INTO utr_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Kini a yɛ yi ungwogye mi idu, a li nyɛ-nyɛ gye ba sede a ka san. A di li kyɔ aletɔ mgbi ama angbeka kwuba, dafi osa ibwɛ yi okye ama okyɔ ungwogye bɛyi emi uga sini.) ");
INSERT INTO utr_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Nghanɛ emi iFarasi yi etsetse mgbi ola mgbi iMose byi iYesu ita gbɛɛ: <<Kyɔsinɛ ngwi engwafɔ mgbi abu li dzɛ mi aletɔ mgbi engyukwo ba, ngwi a li gye ungwɔ yi abɔ oshimbi-shimbi ngha?>> ");
INSERT INTO utr_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","O gbɛɛ: <<Adzaya gbɔ li ayin mi onɔ ngwi o gbɔ ela oyegbɔ mi odzɛ ɛwɛ mgbi ema; dafi a tsekise lɔ mani gbɛɛ: << <Inggisɛ ntonɛ li nu ani mmwɛ mi ikpɔkpondu ta, nghaduu itukwu mgbi ama dzɛ mbombo yi ani. ");
INSERT INTO utr_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","A li sunu ani li ayayi, Otsootso mgbi ama li ola mgbi inggisɛ owamyɛ.> ");
INSERT INTO utr_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Ema kye ola mgbi Imgbasho ngwuta yile abɔ byikɛ ola etɔ mgbi inggisɛ owamyɛ.>> ");
INSERT INTO utr_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Man iYesu nya ma gbɛɛ: <<Ema li dzɛ yi ofɛ nkpa ema okye abɔ byikɛ ele kye ola mgbi Imgbasho ngwuta yɛ kyɛdɔ otsootso mgbi ema! ");
INSERT INTO utr_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Lubana iMose gbɛɛ: <Nu otsabu yi onabu mmwɛ,> ma <Ali inggisɛ ndi fya otsɔn hona onɔn ito yɔ, nu ma ngwɔn kyɛmɛ.> ");
INSERT INTO utr_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Nghaduu ema li gbɛɛ li ayin ni inggisɛ nya ama omba ma gbɛɛ, <Gyen aba, n ka yagba tobyi ema ba. Ikyesinɛ n tsekise zondu okye ungwɔ ngwi ani kika kye nu ema ma, nu Imgbasho, ");
INSERT INTO utr_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","nghanɛ ema li non kyɔ unkonyi kpaa mi ikye otsɔn naadi onɔn wuba. ");
INSERT INTO utr_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Ikyenghanɛ ema kye ngwɔlu elodzɛ Imgbasho mi aletɔ mgbi ema ngwi ema gbeto emidema esɛ nani. Ema di li kyungwɔ kwuba itɔ nani.>> ");
INSERT INTO utr_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","IYesu diyɛ kwu ibyi inggisɛ ela ba mbon di gbɛɛ, <<Ema duu gadɔ mbi ani, di difwi ungwɔnɛ na. ");
INSERT INTO utr_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Nkonyi nka kaka mbi inggisɛ se ka non tsiidza dzɛma ba. Kpaa li ungwɔ ama ntɔ mbi inggisɛ ba esɛ mani. Li ama li non tsiidza aali.>> ");
INSERT INTO utr_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","(Inggisɛ ndzɛ yi adɔ yɔ non fwo.) ");
INSERT INTO utr_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Mi onɔ ngwi o dzita ibyi inggisɛ lu ka kaka ozu nɛ, engwafɔɔn byun ita odzɛ mi utsa nɛni. ");
INSERT INTO utr_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","IYesu byita gbɛɛ, <<Ema yama difwi odzɛ ani le gbɔ nɛ walo? Ema ye saan dafi ungwogye ngwi abu kyi gye lu ifu ka nu abu <tsiidza> ba lo? ");
INSERT INTO utr_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Lubana li lu itukwu mgban ba kpaa li lu ifu, di li yidɔ tɔ mi ewo mgban luba esɛ.>> (Mi odzɛ ngwi iYesu gbɔ nɛ, o tso gbɛɛ ali ungwogye duu <<Mɛ ngwi a ka gye.>>) ");
INSERT INTO utr_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","O kiyayi gbɛɛ: <<Li ungwɔ ntɔ mbi inggisɛ ma li non <tsiidza aali.> ");
INSERT INTO utr_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Lubana li mi itukwu mgbi inggisɛ mi idzidzɛ, li ba yi ɛwɛ otsɛɛtsɛ ibwubwe, amah-ibwubwe, mmyi, inggisɛ ongwɔɔngwɔ, amah, ");
INSERT INTO utr_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","nggwɔ, okye inggisɛ wo itukwu, okpagyewo, imina mgbi ali ibwubwe, odi tanyi, agya, ohaha bɛyi ikwangha. ");
INSERT INTO utr_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Ungwɔ ibwubwe ntonɛ duu li mi itukwu ngwi a li tɔ di li nu inggisɛ <yɛɛ kpɛkpɛ aali.> >> ");
INSERT INTO utr_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","IYesu lu dzata imbe nani yɛ lu ewo igeli iTiru. O kaka ozu kpaa i minan gbɛɛ inggisɛ onyi no ka ye ba; nghaduu kpaa o yagba kye ewon da ba. ");
INSERT INTO utr_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Dafi ongyaa ngwu ongwan dzɛ yi onodzi ibwubwe ka fwo odzɛ mgban nɛ, o ba wa gbɛsɛ lankɛ iyayi. ");
INSERT INTO utr_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Ongyaa na li iGriki, a mban mi ayɛsɛ iSiafonishia mi iSiria. O tɛkyɛ nu iYesu gbɛɛ non lɔlu emɛsɛ na tɔ mbi ongwan ongwu ongyaa. ");
INSERT INTO utr_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Nghaduu iYesu nyan gbɛɛ, <<Ababɔ ni ɛngbɛ nu ma gye ungwogye dafi a mina duuse, lubana li ayin ba okye ungwogye ndzɛ mi ikye ɛngbɛ ngwuta nu obwe.>> ");
INSERT INTO utr_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ongyaa na nun uka gbɛɛ, <<Ɛɛn, Otsɛ iYesu, obwe ama nlato ifo adinyatsɛ ogye ungwogye mgbi ɛngbɛ kpaa, li gye ambulu ama nngwuta mani.>> ");
INSERT INTO utr_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","IYesu si nyan gbɛɛ, <<Mi itɔ uka ngwi abu nu ani nɛ, yɛ lu udɛ abu; emɛsɛ na dzita ongwabu ongwi ongyaa na wa.>> ");
INSERT INTO utr_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","O lu udɛ ta o ka di ongwan ladzɛ akwulo, dafi emɛsɛ na teyi tɔ mbon lu wa. ");
INSERT INTO utr_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Ta iYesu dzata ewo igeli iTiru yɛ nyɛ iSidon, lu utɔ iGalalia tɔ lu ayɛsɛ mgbi iDekapoli, igeli iwyo ntonani. ");
INSERT INTO utr_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Inggisɛ angbeka kye inggisɛ nkyadɔ di li fyonmfye ogbɔdzɛ ba mbon, si tɛkyɛ nun gbɛɛ no kye abɔ gbon ewo. ");
INSERT INTO utr_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Nghanɛ o kyon lu enggengga, dzata ibyi inggisɛ ntonani, iYesu gbe ongwufabɔ wonkɛ adɔ. Man o kyanggwɔ tokɛ ongwufabɔ di kye bɛ inggisɛ na mi idɛ. ");
INSERT INTO utr_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Ta iYesu ndinɛ kɛ esho diyɛ sandu man o nyan gbɛɛ, <<Efata!>> (Itan gbɛɛ, <<kwulu!>>). ");
INSERT INTO utr_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Mi ungwɔ ngwi iYesu kyɔ nɛ, adɔ mgbi inggisɛ na kwulu, idɛ mgban di shɛta ta o wita ogbɔdzɛ tɔ saan. ");
INSERT INTO utr_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","IYesu kwo ma adɔ gbɛɛ nu ma ka nya inggisɛ onyi ba. Nghaduu ngwi o le kwunewo okwo ma adɔ nɛ, a nghao le kiyayi ogbɔdzɛ mi ele. ");
INSERT INTO utr_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Nɛ ama duu ungwɔ okwulewo na kyi gbɛlu ma sɔ. A gbɔgbɛɛ, <<O kyɔ alungwɔ duu saan, o nu ama okyadɔ fwo di nu emi ikplima gbɔdzɛ.>> ");
INSERT INTO utr_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Mi egbe ntona ibyi inggisɛ angbeka di kwakye. Dafi a dzɛ yi unkonyi kpaa ngwi a ka gye ba nɛ, IYesu kwu engwafɔɔn ela ba mbon si nya ma gbɛɛ, ");
INSERT INTO utr_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","<<Elela kyɔ ani wo inggisɛ ntonɛni; a to yi ani mmɛnɛ egbe eta waani, ma a dzɛ yi unkonyi ogyeegye ba. ");
INSERT INTO utr_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Kini ani nu ma ofɛ gbɛɛ nu ma lu udɛ yi enbwa ifu yɔ, a ka kwanadza mi ofɛ, ikyesinɛ angbeka kyɛ imbe otunto.>> ");
INSERT INTO utr_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Emi ongwafɔɔn byun gbɛɛ, <<Nghanɛ li mi ole mi ifoshɛ nɛ ngwi inggisɛ ka tu ibredi mɛ obyi ma enbwa?>> ");
INSERT INTO utr_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","IYesu byi ma gbɛɛ, <<Li ibredi eminɛ ngwi ema dzɛyan?>> A gbɛɛ, <<Egyafa.>> ");
INSERT INTO utr_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","O nya ibyi inggisɛ ntona gbɛɛ nu ma sisɛ mi ombulu. Ngwi o kye gbɛlu ibredi egyafa ntona di ta Imgbasho angba nɛ, o kye mwalu gbe nu engwafɔɔn gbɛɛ nu ma gha ibyi inggisɛ ntonani, a si kyɔ ngha. ");
INSERT INTO utr_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","A di dzɛ yi engwɛ abatsa kpaa gwee, iYesu di ta Imgbasho angba mi engwɛ abatsa ntonani di nya engwafɔɔn nu ma kye gha ma. ");
INSERT INTO utr_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Inggisɛ ntona gye di tolo. Ngwi a gye nyɛ nɛ, engwafɔɔn kye salu ambulu ama nsisi ma mbwo uya egyafa. ");
INSERT INTO utr_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Inggisɛ mɛ dafi idubu enɛ to mi onɔ nani. Ngwi iYesu nu ma ofɛ nu ma lu nɛta, ");
INSERT INTO utr_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","o kaka uwaa yi engwafɔɔn lu ayɛsɛ iDamanuta. ");
INSERT INTO utr_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Emi iFarasi ba mbi iYesu wa wita obyun ita. Ikye ombadin, a pita ambɛ ongwi esho mbon. ");
INSERT INTO utr_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","O sandu lu byulu si gbɛɛ, <<Kyɔsinɛ ngwi etɔ nɛ le mina ambɛ okwulewo? Otsitsi ani le nya ema, ambɛ onyi kpaa a ka kye nu ma ba.>> ");
INSERT INTO utr_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Ta iYesu lu dzamata, yidɔ lu ka kaka uwaa si foyombo utɔ na lu agya oka. ");
INSERT INTO utr_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Engwafɔ iYesu gblimɔ okye ibredi byi, sede li onyi ongwi a kyɛ yan mi uwaa mata. ");
INSERT INTO utr_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","IYesu kwo ma adɔ gbɛɛ, <<Gbɛwɛbyi ewema na. Gbinɛbyi okwuna mgbi emi iFarasi bɛyi mgbi iHerude nani.>> ");
INSERT INTO utr_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","A kponya odzɛ nɛ yi ewoma si gbɛɛ, <<Li ikyegbɛɛ eyi dzɛ yi ibredi ba mani.>> ");
INSERT INTO utr_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","IYesu difwi odzɛ ngwi a tole gbɔ yi ewoma nɛ, o byi ma gbɛɛ: <<Kyɔsinɛse ngwi ema le gbɔdzɛ gbɛɛ ema dzɛ yi ibredi ba? Ema kale dinɛ ba naa kale gbosa lo ema ba maa? Itukwu mgbi ema tiishuu? ");
INSERT INTO utr_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Ema dzɛ yi inɛ kpaa li yagba di lo, di dzɛ yi adɔ kpaa li yagba ofwo lo? Ema wɛ wulo? ");
INSERT INTO utr_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Mi onɔ ngwi ani gha ibredi nghi eda mi ikye inggisɛ idubu eda ma, ema gbe ambulu mbwo uya eminɛ?>> A nun uka gbɛɛ, <<Iwyodefa.>> ");
INSERT INTO utr_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","<<Ngwi ani di gha ibredi nghi egyafa mi ikye inggisɛ idubu enɛ ma, li uya eminɛ ngwi ema gbe ambulu mbweele?>> A gbɛɛ, <<Egyafa.>> ");
INSERT INTO utr_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","IYesu byi ma gbɛɛ, <<Kale gbosa lo ema ba maa?>> ");
INSERT INTO utr_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","A ba iBɛtsaida, man inggisɛ angbeka kye ongyulɔ obinɛ ba wa tɛkyɛ nu iYesu gbɛɛ no kye abɔ gbon. ");
INSERT INTO utr_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","O byi ongyulɔ obinɛ na abɔ di kyon tasɛ dzata ogalu. Ngwi o kyanggwɔ kyin inɛ di kye abɔ ban nɛ, iYesu byun gbɛɛ, <<Abu di ungwɔɔ?>> ");
INSERT INTO utr_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Obinɛ na ndinɛ kɛ esho si gbɛɛ, <<Ani di ibyi inggisɛ, a to dafi ekwɔ mani le kyikyɛ kpatsɛ.>> ");
INSERT INTO utr_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","IYesu diyɛ kye abɔ gbon inɛ. Ta inɛ mgban kwulu, inɛ mgban yɛ, man o di alungwɔ duu saan. ");
INSERT INTO utr_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Nɛ iYesu won ofɛ lu udɛ, di won ola gbɛɛ, <<Ka yɛ kɛ ogalu na wuba.>> ");
INSERT INTO utr_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","IYesu yi engwafɔɔn lu kaka agwɔ ama nto kwɛkwɛ yi iSisiria iFyilipi. Mi ofɛ ma o byi ma gbɛɛ, <<Inggisɛ li kwu ani di emɛ?>> ");
INSERT INTO utr_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","A nyan gbɛɛ, <<Angbeka li gbɛɛ iJɔn okyɔ iBatisima, angbeka gbɛɛ Elaija; angbeka yɔ li gbɛɛ, onyi mi idzidzɛ ama ogbɛɛsɛ.>> ");
INSERT INTO utr_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Nɛ o byita gbɛɛ, <<Nghanɛ ema ma! Ema li kwu ani di emɛ?>> IPyita nun uka gbɛɛ, <<Abu li iKrestu mani.>> ");
INSERT INTO utr_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","IYesu kwo ma adɔ gbɛɛ nu ma ka nya inggisɛ onyi odzɛ mgbi ongwu ba. ");
INSERT INTO utr_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Ta iYesu wita otso emi ongwafɔɔn gbɛɛ Ongwɛ Inggisɛ ka gyadzɛ ungwɔ kwuba kyɛmɛ, engyukwo dika fwan, engyukwo ama ofifɛ, bɛyi etsetse mgbi ola mgbi iMose. A ka ngwɔn mi egbe ongwu ta o dika kyɛɛ mi ikwu. ");
INSERT INTO utr_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","O gbɔdzɛ nɛ mi ododa yi engwafɔɔn, man iPyita kyen lu enggengga sika wita okyɔkyɔ yan. ");
INSERT INTO utr_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Kpaa ngwi iYesu kyata inɛ di engwafɔɔn nɛ, o fwa yi iPyita. O nyan gbɛɛ, <<Kwlekɛ mmɛnɛni iSatan! Abu dzɛ yi ungwɔ mi itukwu ama nli mgbi Imgbasho ba, kpaa li mi ɛwɛ otsɛɛtsɛ mgbi inggisɛ.>> ");
INSERT INTO utr_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Man o kwu ibyi inggisɛ ntona ela bɛyi emi ongwafɔɔn ba mbon si nya ma gbɛɛ: <<Ni i mina inggisɛ o kyɛdɔ ani yɔ, o ka tangwɛ ewon dika kye ekwatsi mgban kyɛdɔ ani. ");
INSERT INTO utr_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Lubana ali inggisɛ nmina odulu oshishe mgban tɔ yɔ, ka byulu lon, kpaa ali inggisɛ nnu oshishe mgban byulu mi ikye ani yi Esɔ Osuse yɔ, ka dulu oshishe mgban tɔ. ");
INSERT INTO utr_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Li ali oyabɔ inggisɛ ka tu kini a kye ɛsɛ duu nun, kpaa oshishe mgban nyanya? ");
INSERT INTO utr_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Naadi li alungwɔ ngwi inggisɛ ka kye nu ikye onyinɛ yi oshishe mgban? ");
INSERT INTO utr_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Kini inggisɛ kwayiwi ani yi esɔ mgbi ani mi ɛsɛ amah yi etɔ ali ibwubwe nɛ yɔ, Ongwɛ Inggisɛ kpaa ka kwayiwi otsungwɔn mi onɔ ngwi o ka ba mi okwɔkwɔ mgbi Otsɔn yi engyesɔ ama osaan mani.>> ");
INSERT INTO utr_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Ta iYesu nya ma gbɛɛ, <<Ani nya ema otsitsi, inggisɛ angbeka kwulɛsɛ to mmɛnɛni a ka kwulu ba nghataa a ka di obaaba mgbi esutɔ mgbi Imgbasho yi mfye.>> ");
INSERT INTO utr_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Ngwi i wa nyɛ egbe egyin nɛ, iYesu kyelu iPyita, iJɛnsi yi iJɔn wafɔ yan kye ma tɔkɛ lu unggwɔ mi esho, ka to ele yuoma. Mi imbe na odzɛɛdzɛ mgban kyata mi inai ma. ");
INSERT INTO utr_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Angwuto mgban kyata tundzɛ kpledede, i tundzɛ ngha ngwi inggisɛ ka kye enotse san no dzɛ ngha gbɛ. ");
INSERT INTO utr_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Ta Elaija yi iMose wa mblegba tu ma, sile kponya yi iYesu. ");
INSERT INTO utr_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","IPyita gbɔ yi iYesu gbɛɛ, <<Otsetse, i tishi ni eyi to mmɛnɛni. Ni eyi klɛ afu nghi eta, onyi ikye abu, onyi ikye iMose, oka ikye Elaija.>> ");
INSERT INTO utr_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","(O ye odzɛ ngwi o ka gbɔ ba, ikyena imio wo ma kpakpa.) ");
INSERT INTO utr_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Ta akpa tɔ mi esho wa gbiiwulu tukwu ma, ela si tɔ mi iwulu na gbɛɛ: <<Nɛnɛ li Ongwani itukwu-itukwu. Gadɔ mbon na!>> ");
INSERT INTO utr_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Labɔlabɔ mata a ndinɛ kpatsɛ, kpaa a di inggisɛ onyi yi ama wuba se li iYesu yuon. ");
INSERT INTO utr_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Dafi a le tashulu mi unggwɔ luba esɛ nɛ, iYesu wo ma ola gbɛɛ nu ma ka nya inggisɛ onyi ungwɔ ngwi a di nɛ ba nghataa se ni Ongwɛ Inggisɛ wa kyɛɛ mi ikwu. ");
INSERT INTO utr_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","A kye odzɛ nɛ da mi itukwu mgbi ama, a yɛ le kponya ungwɔ ngwi <<okyɛɛ mi ikwu>> tso mani. ");
INSERT INTO utr_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ta a byun gbɛɛ, <<Kyɔsinɛ ngwi etsetse mgbi ola mgbi iMose gbɔgbɛɛ Elaija ka teyi iKrestu ba?>> ");
INSERT INTO utr_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","IYesu nu ma uka gbɛɛ, <<Mi otsitsi, Elaija teyi ba, wa yile alungwɔ duu mɛ le fɛ-fɛ. Kpaa li Afɛ ma kpɔɔ di teyi lɔ gbɛɛ Ongwɛ Inggisɛ ka gyadzɛ kpakpa a dika fwan baa? ");
INSERT INTO utr_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Nghaduu ani le nya ema, Elaija teyi ba wa, kpaa a kyɔ yan dafi a mina, yɛyɛ dafi Afɛ lɔ ikyon mani.>> ");
INSERT INTO utr_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Ngwi iYesu yi engwafɔɔn eta ntona yɛ wa tu angbeka ntona nɛ, a di ibyi inggisɛ kpakɛkɛ wo ma bɛyi etsetse mgbi ola mgbi iMose tole tangwodzɛ yi ama. ");
INSERT INTO utr_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Ngwi inɛ mgbi inggisɛ ntona gbo yi iYesu nɛ, i kwulu ma ewo man a tsinya kɛ mbon ka tan angba. ");
INSERT INTO utr_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","IYesu byi emi ongwafɔɔn gbɛɛ, <<Li alungwɔ ngwi ema le tangwɛ yi ama mi ele?>> ");
INSERT INTO utr_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Ongyulɔ oka mi ibyi na nun uka gbɛɛ, <<Otsetse, ani kye ongwani ongyulɔ ba mbi abu, o dzɛ yi onodzi obube li non gbɔdzɛ gbɛ ba. ");
INSERT INTO utr_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Alonɔ ngwi i dzɛsin duu, li kyon ngwuta lakɛ esɛ. O li mbwuuvu ondu, le gyaaba, di li ngwafwa kpɔklɔɔ. Ani nya engwafɔ abu gbɛɛ nu ma lɔ onodzi na tɔ, kpaa a yagba ba.>> ");
INSERT INTO utr_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","IYesu gbɛɛ, <<Kpei, ema etɔ ama onoyɛyɛ ba ntonɛ, ani ka dzɛ yi ema onɔ ka tunto sinɛ? Ani ka shitukwu yi ema onɔ ka tunto sinɛ? Kye ongwɛ ma ba mbi ani.>> ");
INSERT INTO utr_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","A si kyon ba mbon. Ngwi onodzi na di iYesu labɔlabɔ mata, o kye ongwɛ na gyɛsɛ le kwɔɔkwɔ. O gbɛsɛ lakɛ esɛ dile myini kpatsɛ, le tsuuvu ondu. ");
INSERT INTO utr_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","IYesu byi otsɔngwɛ na gbɛɛ, <<I kye onɔ sinɛ ngwi o dzɛ ngha?>> O gbɛɛ, <<Kyɛ esɛ mgban. ");
INSERT INTO utr_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Li kyon ngwuta wokɛ ola naadi eni ikye ongwɔn. Nghanɛ ni abu ka yagba kyungwɔ mi ele yɔ, di eyi elela ya eyi abɔ.>> ");
INSERT INTO utr_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","IYesu gbɛɛ, <<Li ungwɔ ogbɛɛ kini abu yagbaa? Alungwɔ duu ka yagba kyɔ kyɛmɛ mbi inggisɛ nnoyɛyɛ.>> ");
INSERT INTO utr_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Labɔlabɔ nɛ otsɔngwɛ na kweela gbɛɛ, <<Ani noyɛyɛ; tobyi ani ni ani kɛkiyayi mi oyɛyɛ onuunu.>> ");
INSERT INTO utr_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Ngwi iYesu di gbɛɛ ibyi inggisɛ tsinya le wa di nɛ, o fwa yi onodzi obube na gbɛɛ, <<Abu onodzi okyadɔ bɛyi ikplima nɛ, ani wo abu ola, tasɛ mbon dika yɛ kaka mbon wuba.>> ");
INSERT INTO utr_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Onodzi na teela di nu ongwɛ na tsa si tɔ dzanta. Ongwɛ na lakɛ dafi inggisɛ ikwukwɔ man ali inggisɛ duu gbɛɛ, <<O kwulu.>> ");
INSERT INTO utr_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Nghaduu iYesu byin abɔ kyilen esho ta o si dzɛkunto. ");
INSERT INTO utr_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Onɔ ngwi iYesu wa kaka ifoozu nɛ, engwafɔɔn byin ita daada gbɛɛ, <<Kyɔsinɛse ngwi eyi yagba lɔn tɔ ba?>> ");
INSERT INTO utr_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","O nya ma gbɛɛ, <<Itɔ nɛ ka tɔ mi ibɔ kyoon ta!>> ");
INSERT INTO utr_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","A lu dzata imbe nani, nyɛ ifu iGalalia. IYesu mina gbɛɛ ni inggisɛ onyi kpaa ye imbe ngwi ama to ba, ");
INSERT INTO utr_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","ikyekyɛ o le tso engwafɔ mgban gbɛɛ, <<A ka wa kye Ongwɛ Inggisɛ gya mi abɔ inggisɛ. A ka ngwɔn, ni i wa nyɛ egbe eta ta o ka kyɛɛ mi ikwu.>> ");
INSERT INTO utr_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Nghaduu a difwi owitukwu mgban ba, i di wo ma imio obyun ita mi ele. ");
INSERT INTO utr_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","A ba iKapenahun. Onɔ ngwi o wodzɛ ozu nɛ, o byi ma gbɛɛ, <<Li alungwɔ ngwi ema le tangwɛ ikyen mi ofɛ?>> ");
INSERT INTO utr_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Kpaa a kwondu ba ikyekyɛ mi ofɛ ma a teyi tangwodzɛ gbɛɛ li emɛ shewo ngha. ");
INSERT INTO utr_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","IYesu si sɔkɛ esɛ, kwu iwyodefa ntona ela nya ma gbɛɛ, <<Kini inggisɛ mina oli ababɔ yɔ, li kyɛmɛ o ka li olɛlɛ dika li ongbidɔ mgbi angbeka duu.>> ");
INSERT INTO utr_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","O nu ongwɛ ongbungbɛ wa kwudzɛkɛ idzidzɛ mgbi ama. O kye abɔ dɔn alubɔ, si nya ma gbɛɛ, ");
INSERT INTO utr_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","<<Inggisɛ ta ngbɛ onyi mi idzidzɛ ɛngbɛ ntonɛ mi iyi mgbi ani yɔ, o gbɛ ani; ma inggisɛ ta ngbɛ ani yɔ, gbɛ ani ta ba kpaa li ongwu ndɔ ani esɔ mani.>> ");
INSERT INTO utr_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","IJɔn gbɛɛ, <<Otsetse, eyi di inggisɛ oka le lɔ onodzi emɛsɛ onya tɔ mi iyi mgbi abu kpaa eyi nyan gbɛɛ non nya, ikyekyɛ o li onyi mbi eyi ba.>> ");
INSERT INTO utr_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Nɛ iYesu gbɛɛ, <<Ka non nya ba, inggisɛ onyi nkyungwɔ okwulewo mi iyi mgbi ani se ka yɛ kyata gbɔdzɛ oka obube ikpewo ani dzɛma ba, ");
INSERT INTO utr_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","lubana ali inggisɛ nkye iga fyi yi eyi bayɔ dzɛ yi eyi. ");
INSERT INTO utr_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","N nya ema otsitsi, inggisɛ ta nnu abu eni mi ibwɛ mi iyi mgbi ani ikyegbɛɛ ema li emi iKrestu yɔ, li kyɛmɛ-kyɛmɛ umba mgban ka nyan ba. ");
INSERT INTO utr_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","<<Ma kini inggisɛ onyi nu onyi mi itɔ ɛngbɛ ama oshilɛlɛ ama nnoyɛyɛ mbi ani ntonɛ gbɛsɛ mi alobube yɔ, ka tatase lon nu ma kye onikwɔɔ shan onbukwɔ kyon ngwuta wokɛ ekyoo okwukwo. ");
INSERT INTO utr_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Kini abɔ mgbi abu onyi li nu abu le gbɛsɛ mi alobube yɔ, kye dzɛlu ngwuta. I tatase ni abu kaka oshishe yi mmya ngha onu abu kaka udola yi abɔ efa. ");
INSERT INTO utr_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","(Imbe ngwi awi mgbi ama li kwulu ba, ngwi ola na kpaa li gye myunu ba nani.) ");
INSERT INTO utr_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Ma kini afɔ mgbi abu onyi nu abu gbɛsɛ mi alobube yɔ, kye dzɛlu ngwuta. I tatase ni abu kaka oshishe yi afɔ onyi odzɛɛdzɛ ngha ngwi abu ka dzɛ yi afɔ efa nu ma di kye abu ngwuta wokɛ udola mani. ");
INSERT INTO utr_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","(Imbe ngwi awi mgbi ama li kwulu ba, ngwi ola na kpaa li gye myunu ba nani.) ");
INSERT INTO utr_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ma kini inɛ mgbi abu li nu abu le gbɛsɛ mi alobube yɔ, kye todulu ngwuta. I tatase ni abu kaka esutɔ mgbi Imgbasho yi inɛ onyi ngha odzɛ yi inɛ efa nu ma kye abu ngwuta wokɛ udola, ");
INSERT INTO utr_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","imbe ngwi << <awi mgbi ama li kwulu ba, ngwi ola na kpaa li gye myunu ba nani.> ");
INSERT INTO utr_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Ama nkyɛdɔ ani duu ka nyɛ mi isɔ dafi inggisɛ li kye mmwaa dzi ungwɔ ofifɛ mgbi ama se kye toola mani. ");
INSERT INTO utr_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","<<Mmwaa tishi, nghaduu ni mmwaa dzɛ yi mfya wuba, ema ka kyɔsinɛse non yɛ dzɛ yi mfya? Fyumfya dafi mmwaa yi ewema, di dzɛ mi iyu yi ewema na.>> ");
INSERT INTO utr_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Nɛta iYesu si lu dzata imbe na ka kaka ayɛsɛ iJudia di fa ekyoo iJodan. Ibyi inggisɛ di ba mbon, ta dafi o teyi li kyɔ mani, o tso ma. ");
INSERT INTO utr_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Emi iFarasi angbeka ba wa mbadin yi ita gbɛɛ, <<Li ola ni ongyulɔ gheeba yi owaan?>> ");
INSERT INTO utr_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","IYesu byi ma gbɛɛ, <<iMose wo ema ola sinɛ?>> ");
INSERT INTO utr_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","A gbɔgbɛɛ, <<iMose gbela gbɛɛ ni ongyulɔ dzɛ afɛ ogheeba duuse lɔ ongyaa onya lu.>> ");
INSERT INTO utr_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","IYesu si nya ma gbɛɛ, <<IMose wo ema ola nɛ ikyekyɛ ema fyumfye nu ma tso ema ungwɔ. ");
INSERT INTO utr_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Kpaa mi owita-wita mgbi ɛsɛ ma Imgbasho <Mɛ ongyulɔ yi ongyaa kyoon.> ");
INSERT INTO utr_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","<Ikyenghanɛ ongyulɔ ka dzata otsɔn yi onɔn yidɔ kwokyi yi owan, ");
INSERT INTO utr_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","ta ama efa ka yɛɛ ikpewo onyi.> Hininɛ a yama li ikpewo efa wuba, kpaa a yɛɛ ewo onyi. ");
INSERT INTO utr_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Nghanɛ ungwɔ ngwi Imgbasho kye kwokyi yi eka yɔ, ni inggisɛ ka gha ma ba.>> ");
INSERT INTO utr_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Ngwi a yidɔ lu ozu nɛ, emi ongwafɔ iYesu byun ita mi ikye ungwɔnɛni. ");
INSERT INTO utr_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","O nu uka gbɛɛ, <<Ali ongyulɔ ngheeba yi owan yɛ lu ka kye ongyaa oka yɔ, le kyɔ amah biyan. ");
INSERT INTO utr_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ma kini ongyaa tɔ mi udɛ oban yɛ lu ka bongyulɔ oka yɔ, o kyɔ amah.>> ");
INSERT INTO utr_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Ibyi inggisɛ gbe ɛngbɛ ama ogyɛngyɛ le ba mbi iYesu onon kye abɔ gbo ma ewo, nghaduu engwafɔɔn fwa yi ama. ");
INSERT INTO utr_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Ngwi iYesu di ungwɔnɛ nɛ, o kyitingga. O nya ma gbɛɛ, <<Dzata ɛngbɛ ama oshilɛlɛ nu ma ba mbi ani, ka yama kwɔ ma ba, bana esutɔ mgbi Imgbasho dzɛ mi ikye ama ntonɛ sini. ");
INSERT INTO utr_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","N nya ema otsitsi, ali inggisɛ nka gbɛ esutɔ mgbi Imgbasho dafi ongwɛ ogyɛngyɛ bayɔ, ka yagba kaka ele ba.>> ");
INSERT INTO utr_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Nɛ o si kyelu ɛngbɛ ama ogyɛngyɛ ntonɛ byikɛ abɔ mgban, kye abɔ dɔ ma kye mse bɛ ma ewo. ");
INSERT INTO utr_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Dafi iYesu kye ofɛ dikye le lu nɛ, ongyulɔ oka tsinya kɛ mbon ka kye akwafɔ kwokɛ esɛ mi iyayin. O byita gbɛɛ, <<Otsetse osuse, li ekyɛ ngwi ani ka kyɔ kyɛmɛ-kyɛmɛ otu oshishe igyegwu?>> ");
INSERT INTO utr_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","IYesu nyan gbɛɛ, <<Kyɔsinɛ ngwi abu kwu ani di osuse? Inggisɛ onyi yama li osuse ba sede li Imgbasho yuon ta. ");
INSERT INTO utr_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Abu ye ola: <Ka ngwɔ inggisɛ ba, gbaamah ba, ka yimi ba, ka yama kyɔ obwɛndɛ atsika ba, ka kyɔ inggisɛ ogye ba, sunu otsabu yi onabu.> >> ");
INSERT INTO utr_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","O nya iYesu gbɛɛ, <<Otsetse, ungwɔ ntonɛ duu ani kyɔ ma nyɛ ngwi ani ka li ongbɛ mani.>> ");
INSERT INTO utr_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Ta iYesu din inɛ si dzɛ yi okpitukwu mbon. O nyan gbɛɛ, <<Ungwɔ onyi sisi mbi abu, lu, ka kye alungwɔ ngwi abu dzɛyan duu gya kye awuya ma nu emi adzɛ, ta abu ka dzɛ yi aludu mi esho. Taman yɛ, ba wa kyɛdɔ ani.>> ");
INSERT INTO utr_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Mi elodzɛ nɛ inɛ mgbi inggisɛ na si kyata mi ikye yɛɛ tsikitsiki. O tasɛ yi mtse lu, ikyena o dzɛ yi aludu shewo kpakpa. ");
INSERT INTO utr_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Nɛ iYesu si kyata inɛ kyidi nya emi ongwafɔɔn gbɛɛ, <<Ka fyumfye kpakpa ni inggisɛ aludu kaka esutɔ mgbi Imgbasho!>> ");
INSERT INTO utr_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","I kwulu engwafɔɔn ewo mi elodzɛ mgban. Kpaa iYesu di yile odzɛ nɛ gbɔ gbɛɛ, <<Ɛngbɛ, dafi i sunɔ okaka esutɔ mgbi Imgbasho maa! ");
INSERT INTO utr_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Ka nghao sunɔ ba onu ilakwumyi kaka ifo edi fatɔ ngha onu inggisɛ udza kaka esutɔ mgbi Imgbasho.>> ");
INSERT INTO utr_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Nɛ i nghao kwulu emi ongwafɔɔn ewo, ta a gbɔ yi ewoma gbɛɛ, <<Nghama li emɛ tsatso ka watɔ?>> ");
INSERT INTO utr_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","IYesu di ma inɛ si gbɛɛ, <<Mbi inggisɛ yɔ ungwɔ ka yagba dzɛ ngha gbɛ ba, nghaduu mbi Imgbasho yɔ ka yagba dzɛ ngha; bana mbi Imgbasho yɔ alungwɔ duu dzɛ kyɛmɛ-kyɛmɛ.>> ");
INSERT INTO utr_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","IPyita si nyan gbɛɛ, <<Eyi dzata alungwɔ duu kyɛdɔ abu!>> ");
INSERT INTO utr_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","IYesu nu uka gbɛɛ, <<N nya ema otsitsi, inggisɛ onyi ngwu dzata udɛ naadi emi ongwunɔn engyulɔ yi engyaa naadi onɔn yi otsɔn hona ɛngbɛ naadi okwɔ mi ikye ani bɛyi Esɔ Osuse yɔ, ");
INSERT INTO utr_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","ka yama ndan owa yidɔ tuun mi onɔ ngwi eyi wodzɛ ele nɛ bɛyi onɔ ongwi iyayi ba. ");
INSERT INTO utr_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Nghaduu emi ababɔ gwuba ka wa yɛɛ emi olɛlɛ, emi olɛlɛ dika yɛɛ emi ababɔ.>> ");
INSERT INTO utr_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","A kye ofɛ dikye le lu iJerosalin, iYesu teyi ofɛ, man i kwulu emi ongwafɔɔn ewo, ama nkyɛ ma iyikpa kpaa imio wo ma. Ta o di gblekɛ enggengga yi emi iwyodefa ntona nya ma ungwɔ nka wa kyɔ ongwu mani. ");
INSERT INTO utr_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","O gbɔgbɛɛ, <<Eyi le lu iJerosalin, nɛ a ka kye Ongwɛ Inggisɛ wo engyukwo ama ofifɛ yi etsetse mgbi ola abɔ. A ka ngwɔn ikwɔ ikwongye di kyon wo Udzengye abɔ, ");
INSERT INTO utr_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","a ka nyan agya di kyanggwɔ kyin yɛ gbon ibe di ngwɔn. Ni i wa mɛ egbe eta, o ka kyato mi ikwu.>> ");
INSERT INTO utr_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Ta iJɛnsi yi iJɔn, emi ongwɛ iDzebedi, ka ba mbi iYesu. A nyan gbɛɛ, <<Otsetse, eyi mina gbɛɛ abu ki kyɔ eyi alungwɔ ngwi eyi mina duu.>> ");
INSERT INTO utr_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","IYesu byita gbɛɛ, <<Li ekyɛ ngwi ema mina gbɛɛ ni ani kyɔ ema ele?>> ");
INSERT INTO utr_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","A gbɛɛ, <<Ni onyi mbi eyi sɔ abugye mgbi abu oka mi abubɛ mi okwɔkwɔ mgbi abu.>> ");
INSERT INTO utr_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Nɛ iYesu gbɛɛ, <<Ema yama ye ungwɔ ngwi ema tole mina na ba. Ema ka yagba wa mi ibwɛ ngwi ani ka wa naadi kyɔ iBatisima ngwi a kyɔ ani ma gbɛɛ?>> ");
INSERT INTO utr_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","A nu uka gbɛɛ, <<Eyi ka yagba.>> Man iYesu si nya ma gbɛɛ, <<Ema ka wa mi ibwɛ ngwi ani wa di kyɔ iBatisima ngwi ani kyɔ mani, ");
INSERT INTO utr_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","nghaduu osɔ abugye hona abubɛ mgbi ani yama li ani ka nu ofɛ ba. Imbe ntonɛ dzɛ mi ikye mgbi ama a kye dzɛ ma mani.>> ");
INSERT INTO utr_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Ngwi iwyo ntona fwo ungwɔnɛ nɛ, itingga kyɔ ma kpakpa yi iJɛnsi bɛyi iJɔn. ");
INSERT INTO utr_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Man iYesu si kwu ma ela kwakye gbɔgbɛɛ, <<Ema ye ama ngwu a di gbɛɛ a mɛ ogbe Udzengye teyi li kyɔ mfye mboma, engyukwo ama oshewo mi idzidzɛ ma li kyɔ mfye ikpewo ma. ");
INSERT INTO utr_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Mbi ema yama li ngha ba. Kini inggisɛ onyi mbi ema mina oyɛɛ ongbodzi inggisɛ yɔ, li kyɛmɛ-kyɛmɛ no yɛɛ ongbidɔ mgbi angbeka, ");
INSERT INTO utr_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","ma ali inggisɛ nmina oli ongwi ababɔ yɔ, li kyɛmɛ-kyɛmɛ no yɛɛ ofyɛɛ mgbi ema duu. ");
INSERT INTO utr_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Bana Ongwɛ Inggisɛ abuon ba ikyegbɛɛ nu ma wa kyɔn idɔ ba, kpaa owa kyɔɔkyidɔ, odi kye oshishe mgban nu ikye onagbɛ ibyi inggisɛ.>> ");
INSERT INTO utr_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Nɛ a si luba iJeriko. Dafi iYesu yi engwafɔɔn yi ibyi inggisɛ wafɔ ungwonyi le tasɛ dzata igeli nɛ, inggisɛ obinɛ ngwu a li kwun di iBatimayɔ (itan di, Ongwɛ iTimayɔ), sɔdzɛ ewo ofɛ le bibɔ. ");
INSERT INTO utr_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Ngwi o fwo gbɛɛ li iYesu ongwi iNadzareti nɛ, o wita okweela gbɛɛ, <<iYesu, Ongwɛ iDevedi, di ani elela!>> ");
INSERT INTO utr_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Ibyi inggisɛ kwɔn di nyan gbɛɛ non yile ondu tukwu shili-shili, kpaa o kweela nghaabɔ ogbugbe gbɛɛ, <<Ongwɛ iDevedi, di ani elela!>> ");
INSERT INTO utr_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Ta iYesu si kwulɛsɛ gbɔgbɛɛ, <<Kwun ela na.>> A si kwu obinɛ na ela gbɛɛ, <<Dzɛ yi atsa! Kyato nto! O le kwu abu ela.>> ");
INSERT INTO utr_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","O si gbe angwuto mgban ngwuta mi agya oka, kyato vla kɛ mbi iYesu. ");
INSERT INTO utr_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Nɛ iYesu byun gbɛɛ, <<Li alungwɔ ngwi abu mina gbɛɛ ni ani kyɔ abu ele?>> Inggisɛ obinɛ na gbɛɛ, <<Otsetse, ani mina gbɛɛ n ki dinɛ.>> ");
INSERT INTO utr_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Ta iYesu gbɛɛ, <<Lu, oyɛyɛ onuunu mgbi abu ngyɛlu abu ootse.>> Vla-vla ma jo inɛ mgban kwulu o di diyɛ kyɛdɔ iYesu mi ofɛ le lu. ");
INSERT INTO utr_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Dafi a dzɛ kwɛkwɛ okaka iJerosalin di ba iBɛtifege bɛyi iBetani mi Unggwɔ Olivi nɛ, iYesu dɔ engwafɔɔn efa esɔ, ");
INSERT INTO utr_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","o gbɔ yi ama gbɛɛ, <<Kɛ agwɔ ndzɛ ema iyayi nani, ni ema kaka ele yɔ, ema ka di ongwɛ itaklimyi shadzɛ ele, ngwi inggisɛ onyi tɔɔn ye waba. Shan kye ba mmɛnɛni. ");
INSERT INTO utr_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Kini inggisɛ byi ema gbɛɛ, <Kyɔsinɛ ngwi ema le kyungwɔnɛ ngha yɔ?> Nyan gbɛɛ, <Odzɛ wo Otsɛ iYesu mi ele o ka wa yilen mi onɔ gwee.> >> ");
INSERT INTO utr_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Ta a si kɛ ka tu ongwɛ itaklimyi shadzɛ onufɛ kye inɛ byi ofɛ. Dafi a le shan nɛta, ");
INSERT INTO utr_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","inggisɛ angbeka nkwulɛsɛ to imbe na byi ma gbɛɛ, <<Li alungwɔ ngwi ema le kyɔ, ema le shɛ ongwɛ itaklimyi nɛɛ?>> ");
INSERT INTO utr_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Nɛ a nu uka dafi iYesu tsekise nya ma mani, man inggisɛ ntona si dzamata nu ma kye lu. ");
INSERT INTO utr_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Ngwi a kye ongwɛ itaklimyi ma ba mbi iYesu nɛ, a kye angwuto mgbi ama tukwun ekpo man iYesu tɔdɔkɛ ele. ");
INSERT INTO utr_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Ibyi inggisɛ gbe angwuto mgbi ama tasɛ mi ofɛ, angbeka dzɛ afɛ otse mi ondu okwɔ ngwuta tokɛ esɛ mi ofɛ. ");
INSERT INTO utr_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ama nteyi tole kiyayi yi ama nkyɛdɔ ma ma, kweela gbɛɛ, <<Osana! Mse no dzɛ yi ongwu nba mi iyi mgbi Otsɛ Imgbasho nɛni!>> ");
INSERT INTO utr_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","<<Mse no dzɛ yi esutɔ mgbi otseyi iDevedi nka ba nani! Osana mi onghaangha!>> ");
INSERT INTO utr_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Nɛ iYesu wa kaka iJerosalin si lu mi ozu okwukwo osunu Imgbasho mi iJerosalin nani. O kyidi alungwɔ tsatsadu, nghaduu ngwi onɔ gbɛsɛ wa nɛ, o tasɛ lu iBetani yi iwyodefa ntonani. ");
INSERT INTO utr_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Tegblifan dafi a le dzata ogalu mgbi iBetani nɛ, enbwa dɔ iYesu. ");
INSERT INTO utr_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","O di andundu kwo mbombo yi afɛ mi efu yugu-yugu, o si kɛ oka kyidi kaba awawa to ele. Ngwi o ka to itan nɛ, o yama tu unkonyi ba se afɛ ta, ikyena li onɔ mgban owa owawa ba. ");
INSERT INTO utr_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","O si nya ekwɔ na gbɛɛ, <<Inggisɛ onyi ka yama tu awawa mbi abu gye wuba.>> Emi ongwafɔɔn fwo dafi o gbɔ ngha mani. ");
INSERT INTO utr_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Ngwi a kaka iJerosalin nɛ, iYesu kaka ozu okwukwo osunu Imgbasho mi iJerosalin na man wita olɔ ama nle kyummya bɛyi ama nle gya mi imbe na onya tɔ. O tsamu adinyatsɛ mgbi ama nle nyinɛ udza bɛyi itse osɔ efu mgbi ama nle kye ingyakpa gya, ");
INSERT INTO utr_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","di nu inggisɛ onyi ofɛ gbɛɛ non kyummya mi idzidzɛ ozu okwukwo osunu Imgbasho na ba. ");
INSERT INTO utr_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Man o si le tso ma ungwɔ, o gbɔgbɛɛ, <<Afɛ lɔ gbɛɛ: << <A ka kwu ozu mgbi ani gbɛɛ ozu ibɔ mgbi ɛsɛ duu baa>? Nghaduu ema kyatan yɛɛ <imbe mgbi emumyi ama oblofɛ.> >> ");
INSERT INTO utr_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Ngwi engyukwo ama ofifɛ bɛyi etsetse mgbi ola fwo ungwɔnɛ nɛta a si wita opita ofɛ ngwi a ka ngwɔn, bana a mion, ikyekyɛ le kwulu inggisɛ duu ewo mi otsootso mgban. ");
INSERT INTO utr_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Ngwi onɔ gbɛsɛ nɛ, a tɔ dzata ogalu. ");
INSERT INTO utr_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Mi egbegbe, ngwi a le lu nɛ, a di andundu na ngwɔ wita kyɛ akpa lu ikyen. ");
INSERT INTO utr_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Ta iPyita wɛ di nya iYesu gbɛɛ, <<Otsetse, dii! Ekwɔ andundu ngwi abu won ikamba nɛ ngwɔ!>> ");
INSERT INTO utr_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","IYesu si nyan gbɛɛ, <<Dzɛ yi oyɛyɛ onuunu mbi Imgbasho. ");
INSERT INTO utr_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","N nya ema otsitsi, yeba ni inggisɛ nya unggwɔ nɛ gbɛɛ, <Lu, kye ewabu ka ngwuta mi ekyoo okwukwo,> di yama dzɛ yi angwɛ mi itukwu ba di noyɛyɛ gbɛɛ ungwɔ ngwi ongwu gbɔ na ka kyɔ ngha yɔ, a ka kyɔn ele. ");
INSERT INTO utr_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Nghanɛ n nya ema, alungwɔ ngwi ema bɔ mi ibɔ yɔ, noyɛyɛ gbɛɛ ema tun wa, ta dika li mgbi ema. ");
INSERT INTO utr_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Mi onɔ ngwi ema kwulɛsɛ le bibɔ yɔ, dzata angbeka ama nkyɔ ema obube. Ta Otsema ndzɛ esho na ka dzita ema yi ali ibwubwe mgbi ema.>>  ");
INSERT INTO utr_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","kpaa ni abu dzata inggisɛ yi obube bayɔ, Otsabu ndzɛ esho kpaa ka dzita abu yi obube mgbi abu ba. ");
INSERT INTO utr_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","A di ba wa kaka iJerosalin, ta ngwi iYesu le kyikyɛ kyɛ mi ayɛ ozu okwukwo osunu Imgbasho nɛ, engyukwo ama ofifɛ yi etsetse mgbi ola bɛyi engyukwo emi iJuda ba mbon. ");
INSERT INTO utr_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","A byita gbɛɛ, <<Li mi ali mfye ngwi abu le kyungwɔ ntonɛ? Di li emɛ nu abu mfye okyungwɔ ntonɛ?>> ");
INSERT INTO utr_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Nɛ iYesu si gbɛɛ, <<Ani kpaa ka byi ema ita onyi ta. Nu ani uka na, ta n ka nya ema imbe ngwi ani tu mfye le kyungwɔ ntonɛni. ");
INSERT INTO utr_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Nyɛn na, iBatisima mgbi iJɔn nɛ tɔkyɛ mi esho naadi mbi inggisɛ?>> ");
INSERT INTO utr_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","A si gbɔ yi ewoma gbɛɛ, <<Kini eyi gbɛɛ, <Kyɛ mi esho,> o ka byita gbɛɛ, <Ma kyɔsinɛ ngwi ema nun oyɛyɛ ba?> ");
INSERT INTO utr_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Kpaa ni eyi gbɛɛ, <Kyɛ mbi inggisɛ yɔ>....>> (A tsimio ibyi inggisɛ, bana ali inggisɛ ye jo gbɛɛ iJɔn li oyegbɔ.) ");
INSERT INTO utr_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Nɛ a nu iYesu uka gbɛɛ, <<Eyi ye imbe ngwi i tɔkyɛ ba.>> Man iYesu gbɔgbɛɛ, <<Ngyɛse ani kpaa ka nya ema itɔ mfye ngwi ani le kyungwɔ ntonɛ ba.>> ");
INSERT INTO utr_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","O si wita ogbɔdzɛ yi ama mi utsa gbɛɛ: <<Inggisɛ shi okwɔ awawekwɔ. O mbɛ ogalu kpakɛkɛ won, di tishɛ ogbe eni owawa ekwɔ di tuo otila ikye ongyo. Ta o kye okwɔ na wo emi okwɔ angbeka abɔ si lu agaba. ");
INSERT INTO utr_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Mi onɔ oshɛ etɔ mani, o dɔ ongbidɔ mgban esɔ mbi ama ngwu o kye okwɔ wo ma abɔ ma gbɛɛ non ka gbɛ owawa ekwɔ ongwi okwɔ na mboma. ");
INSERT INTO utr_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Kpaa a kpaklin, gbon lɔn onya lu abubɔ. ");
INSERT INTO utr_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Ta o di dɔ ongbidɔ oka esɔ mboma; a kye ungwɔ zudɔn ikye onun ayiwi. ");
INSERT INTO utr_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Otsungwɔ okwɔ na diyɛ dɔ oka, ongwu na a kyon kye ngwɔlu. O di dɔ angbeka kwuba, angbeka ma, a gbo ma, angbeka yɔ, a ngwɔ ma. ");
INSERT INTO utr_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","<<Otsungwɔ okwɔ sisi yi inggisɛ onyi ta odɛsɔ, ongwan ongwu ongyulɔ, ongwu nkpan itukwu saan. O dɔnsɔ olɛlɛ gbɛɛ, <A ka nu ongwani mmwɛ.> ");
INSERT INTO utr_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","<<Nghaduu ama odi mi okwɔ ntona gbɔ yi eka gbɛɛ, <Nɛnɛ li ongwɛ nka gyokwudɛ ma aani. Ba na, ni eyi ngwɔlun, ta okwudɛ ka yɛɛ mgbi eyi.> ");
INSERT INTO utr_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Nɛ a si kyon kye ngwɔlu, di kye ikwɔ mgban ngwi tasɛ mi okwɔ. ");
INSERT INTO utr_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","<<Li alungwɔ ngwi otsungwɔ okwɔ na ka kyɔ? O ka ba wa ngwɔlu ama ngwu o kye okwɔ wo ma abɔ ntona di yile okwɔ nu angbeka. ");
INSERT INTO utr_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Ema gbɔ Afɛ nɛ walo: << <Akwutsɛ ngwi ama ombɛ ozu fwan ma i yɛɛ okwulu ikye ozu; ");
INSERT INTO utr_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","li Otsɛ Imgbasho kyungwɔnɛni, nɛkpaa li ungwɔ okwulewo mbi eyii>?>> ");
INSERT INTO utr_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Ta a pita ofɛ obwan ikyekyɛ a ye dafi o gbɔ utsa na ikye mgbi ama. Nghaduu a le mio ibyi inggisɛ; nɛ a si dzanta lu. ");
INSERT INTO utr_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","A dɔ emi iFarasi angbeka esɔ mi iyikpa yi emi iHerude mbi iYesu ikye oka bwan mi elodzɛ mgban. ");
INSERT INTO utr_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","A ba mbon wa gbɛɛ, <<Otsetse, eyi ye abu li inggisɛ otsitsi. Abu li mio inggisɛ ba, ikyekyɛ abu li kye oshewo nu inggisɛ mi odzɛɛdzɛ mgbi ama ba; kpaa abu li tso ofɛ mgbi Imgbasho imbisɔn-mbisɔn yi otsitsi. Nɛ li ola ni eyi kpa udza ifyɛɛ nu iSidza naadi li ola ba? ");
INSERT INTO utr_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Ni eyi kpa naadi ni eyi ka kpa ba?>> Nghaduu iYesu ye ɛwɛ mgbi ama, o nu ma uka gbɛɛ, <<Kyɔnɛ ngwi ema le mina okya ani ukya? Kye isule ma wa nin di.>> ");
INSERT INTO utr_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","A kye isule ma ba, man o byi ma gbɛɛ, <<Nɛnɛ li onodzi mgbi emɛ dɔdzɛ ele? Di li olɔɔlɔ mgbi emɛ?>> A gbɛɛ, <<Li mgbi iSidza.>> ");
INSERT INTO utr_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","IYesu si nya ma gbɛɛ, <<Kye ungwɔ mgbi iSidza nu iSidza di kye mgbi Imgbasho nu Imgbasho.>> Man i kwulu ma ewo biyan. ");
INSERT INTO utr_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Nghanɛ emi iSadusi, ama ngbɛɛ okyɛɛ-kyɛɛ mi ikwu dzɛma ba ma, ba mbi iYesu yi ita. ");
INSERT INTO utr_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","A gbɛɛ, <<Otsetse, iMose lɔ gbɛɛ ni ongwunɔ inggisɛ kwulu dzata ongyaa kpaa mba ɛngbɛ bayɔ, inggisɛ na no yile owakwadɛ na kyɛmɛ-kyɛmɛ di mba ɛngbɛ mi ikye ongwunɔ ongwu nkwulu nani. ");
INSERT INTO utr_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Engwuneka nghi egyafa nose to. Ongwu ababɔ kye ongyaa kwulu dzata ongwɛ onyi ba. ");
INSERT INTO utr_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Ongwu fan yile owakwadɛ na, kpaa o di kwulu dzata ongwɛ onyi ba. Ongwu ta kpaa li ngha. ");
INSERT INTO utr_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Mi otsitsi, onyonyi mbi engyulɔ egyafa ntonɛ dzata etɔ onyi ba. Ongyɛɛngyɛ duu, ongyaa na kpaa wa kwulu. ");
INSERT INTO utr_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Mi egbe ngwi inggisɛ ka kyɛɛ mi ikwu ma li emɛ ngwu ongyaa nɛ ka li owan, ngwi ama egyafa duu kyon?>> ");
INSERT INTO utr_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","IYesu nu uka gbɛɛ, <<Ema boofɛ ikyegbɛɛ di ema ye ungwɔ ngwi Afɛ lɔ ba di ye mfye mgbi Imgbasho kpaa ba. ");
INSERT INTO utr_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Bana mi onɔ ngwi inggisɛ ka kyɛɛ mi ikwu mani, a ka kye ongyaa hona kye ongwɛ nu eba wuba; a ka to dafi engyesɔ emi esho mani. ");
INSERT INTO utr_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Mi ikye odzɛ okyɛɛ mi ikwu nɛ, ema gbɔ mi Afɛ mgbi iMose, mi odzɛ mgbi oshɛ na walo? Dafi Imgbasho nyan gbɛɛ, <Ani li Imgbasho mgbi Abrahan, Imgbasho mgbi Adziki di li Imgbasho mgbi iJeko ma baa>? ");
INSERT INTO utr_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","O li Imgbasho mgbi emi ikwukwɔ ba, kpaa Imgbasho mgbi emi oshishe. Ema le boofɛ timbi saan!>> ");
INSERT INTO utr_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Onyi mi etsetse mgbi ola mgbi iMose ba wa fwo ma le tangwodzɛ. Dafi o di gbɛɛ iYesu nu ma uka osuse nɛta, o si byun gbɛɛ, <<Mi ola duu ma, li ole nghao wuuta?>> ");
INSERT INTO utr_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","IYesu nu uka gbɛɛ, <<Ongwu nnghao wuuta ma, li ongwu aani: <Fwo na, ema emi Israi, Otsɛ Imgbasho mgbi eyi, Otsɛ na li onyi. ");
INSERT INTO utr_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Otsɛ Imgbasho mgbi abu no kpa abu itukwu yi itukwu mgbi abu duu yi oshishe mgbi abu duu bɛyi mfye mgbi abu duu.> ");
INSERT INTO utr_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ongwu fan yɔ: <Inggisɛ nwatse dɔ abu no kpa abu itukwu dafi ewabu mani.> Ola oka dzɛma nshewo ngha ola ntonɛ ba.>> ");
INSERT INTO utr_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Otsetse mgbi ola na nu iYesu uka gbɛɛ, <<Otsetse, abu gbɔ tishi. Abu li ayin ogbɔgbɛɛ Imgbasho li onyi oka dzɛma ba se ongwu ta mani. ");
INSERT INTO utr_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Onon kpa abu itukwu, yi itukwu mgbi abu duu yi oyeye mgbi abu duu bɛyi mfye mgbi abu duu, inggisɛ ongwu nwatse dɔ abu no di kpa abu itukwu dafi ewabu na, li ungwɔ nwuuta ngha umba ama otoola bɛyi ama ofifɛ duu.>> ");
INSERT INTO utr_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Ngwi iYesu di gbɛɛ o nu uka mi ozoyeye nɛ, o nyan gbɛɛ, <<Abu dzɛ mbombo yi esutɔ mgbi Imgbasho ba.>> Ta mi onɔ na lu iyayi inggisɛ onyi kpaa yagba byun ita angbeka wuba. ");
INSERT INTO utr_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Ngwi iYesu le tso mi ozu okwukwo osunu Imgbasho mi iJerosalin nɛ, o si byita gbɛɛ, <<Kyɔsinɛse ngwi etsetse mgbi ola mgbi iMose gbɔgbɛɛ Ongwu Imgbasho zondu gbɛɛ o ka wa dulu ɛsɛ watɔ (iKrestu) ma li Ongwɛ iDevedi? ");
INSERT INTO utr_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Onodzi Osaan kye iDevedi abuon kpaa teyi non gbɛɛ: << <Otsɛ Imgbasho nya Otsɛ mgbi ani gbɛɛ: <<Sɔkɛ mi abugye mgbi ani nghataa ni ani wa nu engyikyili mgbi abu yɛɛ itse mgbi abu ogbe afɔ dɔ efu.>> > ");
INSERT INTO utr_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","IDevedi abuon kwun di <Otsɛ.> Nghanɛ ka kyɔsinɛse ngwi o ka li ongwan?>> Ibyi inggisɛ ntona fwo otsootso mgbi iYesu yi atsa mi itukwu mgbi ama. ");
INSERT INTO utr_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Mi otsootso mgbi iYesu ma, o gbɛɛ, <<Kye inɛ byi etsetse mgbi ola na. A li mina okyikyɛ yi angwuto owulu-wulu nu ma dile ta ma angba mi ifyidu, ");
INSERT INTO utr_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","odi sɔ itse ngwi a nghao kye wuuta mi ozu okwakye mgbi emi iJuda yi imbe okpɔngɔ mi oga. ");
INSERT INTO utr_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","A li gye mmgbe mi udɛ mgbi emi owakwadɛ di li bibɔ tunto otso gbɛɛ ama tishi. Itɔ inggisɛ ntona Imgbasho ka kwo ma adɔ she kpakpa.>> ");
INSERT INTO utr_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Man iYesu sisɛ mi agya imbe ngwi a gbe umba le wokɛ, le di ibyi inggisɛ kye udza mgbi ama le wokɛ mi ashiko mgbi ozu okwukwo osunu Imgbasho mi iJerosalin. Ama odzɛ yi udza kwuba kpaa kye udza mgbi ama le wokɛ ele. ");
INSERT INTO utr_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Nghaduu ongyaa owakwadɛ adzɛ ba wa nu anini efa, ngwi mɛ ikobo onyi ta. ");
INSERT INTO utr_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Nɛ iYesu si kwu engwafɔɔn ela ba mbon nya ma gbɛɛ, <<N nya ema otsitsi, ongyaa owakwadɛ adzɛ nɛ nghao kye wokɛ mi ashiko ngha angbeka duu. ");
INSERT INTO utr_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Ama duu a nu mi odzɛɛdzɛ mgbi aludu mgbi ama; kpaa owakwadɛ nɛ yɔ, li mi adzɛ mgban ngwi o nu, li ungwɔ ngwi o dzɛ biyan duu onon dzɛ oshishe mani.>> ");
INSERT INTO utr_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Dafi iYesu le tasɛ mi ozu okwukwo osunu Imgbasho mi iJerosalin nɛta, onyi mbi engwafɔɔn nyan gbɛɛ, <<Dii, Otsetse! Li ali itɔ akwutsɛ osugbɔ-osugbɔ dɛn! Li ali itɔ ozu ogbosinɛ nghalo!>> ");
INSERT INTO utr_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","IYesu nyan gbɛɛ, <<Abu di ozu ama oshewo ntonɛ wɛ? Ikwutsɛ onyi mmɛnɛ kpaa ka sisi dɔ ikye oka ba; ali ikwutsɛ duu a ka wa kye gbobu tukwu esɛ.>> ");
INSERT INTO utr_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Ngwi iYesu sisɛ mi Unggwɔ Olivi mi agya ozu okwukwo osunu Imgbasho mi iJerosalin nɛ, iPyita yi iJɛnsi yi iJɔn bɛyi Andru byun daada gbɛɛ, ");
INSERT INTO utr_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","<<Nya eyi, li alonɔ ngwi ungwɔ ntonɛ ka wa kyɔ? Dika li ali ambɛ ka tso gbɛɛ ungwɔ ntonɛ le ka mbwumbwo?>> ");
INSERT INTO utr_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","IYesu nya ma gbɛɛ: <<Gbɛwɛbyi na, ka nu inggisɛ kpagya ema wo ba. ");
INSERT INTO utr_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Inggisɛ kwuba ka ba mi iyi mgbi ani, le gbatsika gbɛɛ, <Li ani li iKrestu mani,> dika kpagya inggisɛ wo kwuba. ");
INSERT INTO utr_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Mi onɔ ngwi ema fwo ika bɛyi odzɛ a gbɛɛ mgbi ika yɔ, ka teeyi ba na. Bana ungwɔ ntonɛ duu ka kyɔ kyɛmɛ-kyɛmɛ, kpaa li ongyɛɛngyɛ ɛsɛ wa daaba. ");
INSERT INTO utr_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Ɛsɛ ka kyɛɛ ika bɛyi ɛsɛ oka, esutɔ ka kyɛɛ ika bɛyi esutɔ oka. Ɛsɛ osuusu ka dzɛ mi imbe idzidza-dzidza, bɛyi enbwa. Ungwɔ ntonɛ li owita-wita mgbi isɔ. ");
INSERT INTO utr_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","<<Gbɛwɛbyi ewema kyɛmɛ-kyɛmɛ na. A ka kye ema nu mi abɔ okwakye mgbi ama ogbiikwɔ nu ma gbo ema ibe mi ozu okwakye mgbi emi iJuda. Mi ikye mgbi ani a ka kye ema ba inɛ emi iGɔna yi emi utɔ dafi obwɛndɛ mboma. ");
INSERT INTO utr_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Ma Esɔ Osuse nɛ a ka teyi gbɔn kyɛmɛ-kyɛmɛ mi ɛsɛ duu. ");
INSERT INTO utr_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Kini a bwa ema kye ba owa gbɔ ema ikwɔ yɔ, itukwu no ka teyi kaka ema ewo mi odzɛ ngwi ema ka gbɔ ba. Nghaduu gbɔ ali odzɛ ngwi a kye ba mbi ema mi onɔ na mani, bana li ema kale gbɔdzɛ ba, elodzɛ mgbi ema ka kyɛ mbi Onodzi Osaan. ");
INSERT INTO utr_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","<<Inggisɛ ka kye ongwunɔn nu ikwu, otsɔngwɛ kpaa ka kye ongwan nu. Ɛngbɛ ka ngha ama omba ma adɔ di nu ma kwikwu. ");
INSERT INTO utr_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Inggisɛ duu ka kyili ema mi ikye ani, nghaduu inggisɛ nkwulɛsɛ kpɔklɔɔ ba ongyɛɛngyɛ ka watɔ. ");
INSERT INTO utr_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","<<Mi onɔ ngwi ema di ungwɔ <idza nka nu odzili-dzili> kwulɛsɛ dzɛ imbe ngwi i wogyɔ gbɛɛ ki dzɛ bayɔ, inggisɛ nle gbɔ ungwɔ olɔɔlɔ ma no difwi, nɛ ama nto iJudia nu ma tsinya lu unggwɔ. ");
INSERT INTO utr_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Ni inggisɛ onyi ndɔdzɛ ikyendu mgban ka tashulu ba esɛ naadi kaka ozu oka kye ungwɔ onyi tasɛ ba. ");
INSERT INTO utr_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ni inggisɛ onyi nkɛdzɛ okwɔ kpaa yɛ ba udɛ owa gbe angwuto mgban ba. ");
INSERT INTO utr_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Nghaduu odzɛ ka tu engyaa ama nto yi ifewo yi ama nle nu ɛngbɛ abɛ mi egbe ntonani! ");
INSERT INTO utr_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Ema bibɔ gbɛɛ ungwɔnɛ no ka kyɔ mi owa ba, ");
INSERT INTO utr_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","ikyekyɛ egbe ntona ka li egbe adzɛ ngwi Imgbasho ta ɛsɛ jo itɔ adzɛ na yama dzɛ ngha ye ba, ma dika dzɛ ngha onɔ onyi kpaa wuba. ");
INSERT INTO utr_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Kini Otsɛ Imgbasho kye mwalu egbe ntona bayɔ, inggisɛ onyi kika watɔ ba. Kpaa mi ikye ama ngwu o sadu mayɔ, o kye mwalu egbe nani. ");
INSERT INTO utr_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Mi onɔ na kini inggisɛ nya ema gbɛɛ, <Dii, Ongwu Imgbasho zondu gbɛɛ o ka dulu ɛsɛ watɔ ma (iKrestu) dzana!> Hona, <Dii, o dzɛ aali!> Ka noyɛyɛ mi ele ba. ");
INSERT INTO utr_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Bana emi iKrestu atsika bɛyi oyegbɔ emi atsika ka tole kyɔ ambɛ bɛyi ungwɔ ama okwukwo ikye okpagya ama a sadu ma ma wo, ki no li kyɛmɛ-kyɛmɛ yɔ. ");
INSERT INTO utr_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Nghanɛ gbɛwɛbyi ewema na; ani teyi nya ema alungwɔ duuse ni onɔ na wa gyɔ. ");
INSERT INTO utr_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","<<Nghaduu ni adzɛ na wa nyɛ mata, << <onɔ ka yifu, ofyia dika tso osa mgban wuba; ");
INSERT INTO utr_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","mcɛ ka yangwuta mi esho, Imgbasho ka kyɔ mfye, alungwɔ mi esho duu ka suusu.> ");
INSERT INTO utr_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","<<Mi onɔ na inggisɛ ka di Ongwɛ Inggisɛ kyɛ akpa mi esho yi mfye okwulewo bɛyi okwɔkwɔ. ");
INSERT INTO utr_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ta o ka dɔ engyesɔ mgban esɔ mi ayɛsɛ enɛ wa gbe ama ngwu o sadu mi odondu mgbi ɛsɛ nghataa lu mi odondu mgbi esho ma duu kwakye mbonyi. ");
INSERT INTO utr_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","<<Ikyenghanɛ kpayi ozoyeye nɛ mbi ekwɔ andundu na: Ni abɔn kyinda di baafɛ mata, ema li ye dafi li akyonova mani. ");
INSERT INTO utr_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Nghaduukpaa, ni ema di ungwɔ ntonɛ le kyɔ yɔ, ye na gbɛɛ dzɛ kwɛkwɛ, jo okaka onufozu. ");
INSERT INTO utr_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","N le nya ema otsitsi, ungwɔ ntonɛ duu ka kyɔ se ɛsɛ nɛ ka ngyɛ. ");
INSERT INTO utr_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Esho yi esɛ ka nyɛ, kpaa elodzɛ mgbi ani ka yagba nyɛ ba. ");
INSERT INTO utr_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","<<Inggisɛ onyi ye egbe hona onɔ ma ba, engyesɔ emi esho kpaa ye ba, naadi Ongwɛ, kpaa li Otsɛ Imgbasho yuon ye. ");
INSERT INTO utr_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Kwasisa di ngyo na! Bana ema ye egbe ngwi onɔ na ka ba ba. ");
INSERT INTO utr_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Dzɛ dafi inggisɛ le lu agaba: O dzata udɛ di gbe engbidɔ mgban tokɛ mi ungwɔ mgban duu, ali inggisɛ mgbi ama yɔ o nun idɔ mgban, di nya ongwu ndzɛ onufozu ma gbɛɛ non ngyo. ");
INSERT INTO utr_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","<<Nghanɛ le ngyo na bana ema ye onɔ ngwi otsungwudɛ na ka yɛ ba, kyayina ka li mi onɔdɛ, naadi ka li mi idzidzɛ otu, hona mi onɔ ngwi ogbigbi ka teela, naadi ka li mi ikyegbe ho. ");
INSERT INTO utr_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Ki non yɛ bwabwa kpaa, no ka tu ema le nuna ba. ");
INSERT INTO utr_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Ungwɔ ngwi ani le nya ema nɛ, n le nya ali inggisɛ duu gbɛɛ: <Ngyo na!> >> ");
INSERT INTO utr_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","I sisi mɛ egbe efa ngwi oga owɛ owatɔ-watɔ mgbi emi Israi bɛyi ibredi ngwi a kye okwuna wo efu ba ka wa gyɔ nɛta, engyukwo ama ofifɛ bɛyi etsetse mgbi ola mgbi iMose tole pita ofɛ mi oshu ngwi ama ka bwa iYesu di ngwɔn mani. ");
INSERT INTO utr_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","A gbɔgbɛɛ, <<Kpaa no ka li mi egbe oga ba, bana inggisɛ ka ndeye.>> ");
INSERT INTO utr_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Mi onɔ ngwi iYesu dzɛ iBetani mani, o sisɛ ogye ungwogye mi udɛ inggisɛ ongwu a li kwun di iSaimɔn inggisɛ otsoma, ongyaa ba yi engyie ofyunfyummya mi ikpɔkpɔ alabasta, engyie mgbi ekwɔ iNadi yuon. O kye ikpɔkpɔ alabasta na ondun kye kwulu, kye engyie ma yawo iYesu ikye. ");
INSERT INTO utr_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Ama nto mi onɔ na ma, tole gbɔ mi itingga-itingga yi ewoma gbɛɛ, <<Nɛnɛ li engyie ombeembe dɛn lo? ");
INSERT INTO utr_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","A ki kye gya mɛ udza nngha udza idɔ onova onyi di kye udza ma gha emi adzɛ.>> A si kyɔkyɔ yi ongyaa na mi itingga-itingga. ");
INSERT INTO utr_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Nghaduu iYesu gbɛɛ, <<Ema dzanta na. Kyɔnɛ ngwi ema le kakan ewo ngha? O kyungwɔ nli osuse yi ani. ");
INSERT INTO utr_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Bana emi adzɛ to yi ema alonɔ duu, ema ka ya ma abɔ alonɔ ngwi ema mina duu. Kpaa ani yɔ, ema ka tu ani alonɔ ba. ");
INSERT INTO utr_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","O kyungwɔ ngwi o yagba okyɔ. O kyi ani engyie mi ewo duuse ni onɔ ondzi ani wa gyɔ. ");
INSERT INTO utr_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","N nya ema otsitsi, mi ali imbe ngwi a le gbɔ Esɔ Osuse kpatsɛ ɛsɛ duu, ungwɔ ngwi o kyɔ nɛ a ka gbɔn, ikye ole wan.>> ");
INSERT INTO utr_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Ta iJuda iSkarɔti, ongwu nli onyi mbi emi iwyodefa ntona, kɛ mbi engyukwo ama ofifɛ oka kye iYesu gya yi ama. ");
INSERT INTO utr_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","I kpa ma ofwo odzɛ nɛni a di zondu onun awuya. Nghanɛ o pita ofɛ okyon wo ma abɔ. ");
INSERT INTO utr_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Mi egbe ongwi ababɔ mgbi oga ibredi ngwi a kye okwuna wo efu ba, ngwi li ungwɔ etɔ mgbi ama ofifɛ yi mmala oga owɛ owatɔ-watɔ mgbi emi Israi nɛ, engwafɔ mgbi iYesu byun gbɛɛ, <<Li mi ole ngwi abu mina ni eyi kɛ ka mɛlu abu imbe ogye oga owɛ owatɔ-watɔ mgbi emi Israi nɛ?>> ");
INSERT INTO utr_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Nɛta o dɔ engwafɔɔn efa esɔ, nya ma gbɛɛ, <<Kaka ifu igeli na, ongyulɔ kye ishe eni dikye ka wa kpatsɛ ema. Kyɛdɔn na. ");
INSERT INTO utr_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Imbe ngwi o kaka ma, nya otsungwudɛ ma gbɛɛ, <Otsetse byita gbɛɛ: Ozu ingyoga mgbi ani, ngwi ani ka gye oga owɛ owatɔ-watɔ mgbi emi Israi yi emi ongwafɔ mgbi ani ma kɔ?> ");
INSERT INTO utr_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Ta o ka tso ema ozu okwukwo mi ozeesho, ngwi a gbe okye to ele le fɛɛfɛ. Kye mɛlu mi ikye eweyi na.>> ");
INSERT INTO utr_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Emi ongwafɔ ntona si lu ifu igeli ka di ungwɔ ntona yɛyɛ dafi iYesu nya ma mani. Nɛ a kye kyɔlu ungwogye oga owɛ owatɔ-watɔ mgbi emi Israi. ");
INSERT INTO utr_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Onɔ wa gbɛsɛ nɛta, iYesu wa kaka bɛyi emi iwyodefa ntonani. ");
INSERT INTO utr_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Ngwi a sisɛ kwongongo le gye ungwogye mi adinyatsɛ nɛta, o gbɔgbɛɛ, <<Ani le nya ema otsitsi, onyi mbi ema ka kye ani gya, o sɔ le gye ungwogye yi ani mmɛnɛ kpaa.>> ");
INSERT INTO utr_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","A si yɛɛ elela dile byun onyonyi gbɛɛ, <<Li ani ba lɔ?>> ");
INSERT INTO utr_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Nghaduu iYesu nya ma gbɛɛ, <<Li onyi mbi emi iwyodefa, ama nkye abɔ wo uga yi ani nɛni. ");
INSERT INTO utr_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Ongwɛ Inggisɛ ka lu yɛyɛ dafi Afɛ lɔ mi ikyen mani. Kpaa ahoo mi ikye inggisɛ ongwu nkye Ongwɛ Inggisɛ gya mani! Ka tatase gbɛɛ a ki mban ba.>> ");
INSERT INTO utr_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Ngwi a le gye ungwogye nɛ, iYesu kyelu ibredi, ta Imgbasho angba man kye mwalu, kye nu emi ongwafɔɔn gbɛɛ, <<Gbɛ na; nɛnɛ li ikpewo mgbi ani.>> ");
INSERT INTO utr_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","O di kyi kyelu ibwɛ, ta Imgbasho angba di kye nu ma, ama duu wa mi efu. ");
INSERT INTO utr_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","O nya ma gbɛɛ, <<Nɛnɛ li eyi mgbi ondu odzɛɛdzɛ mgbi ani, ongwi a kye yawo mi ikye ibyi inggisɛ. ");
INSERT INTO utr_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Ani le nya ema otsitsi, n ka weni awawa ekwɔ nɛ wuba nghataa mi egbe ngwi n ka wan ofufɛ mi esutɔ mgbi Imgbasho mani.>> ");
INSERT INTO utr_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Ngwi a shashi nɛta, a tasɛ lu Unggwɔ Olivi. ");
INSERT INTO utr_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Ta iYesu si nya ma gbɛɛ, <<Ema duu ka tangwɛ ani, bana Afɛ lɔ gbɛɛ: << <N ka gbo inggisɛ ongyo ifyungwɔ ta, mmala ka ganya.> ");
INSERT INTO utr_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Nghaduu ni ani wa kyato mi ikwu yɔ, n ka teyi ema kaka iGalalia.>> ");
INSERT INTO utr_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Kpaa iPyita gbɔ mi ododa gbɛɛ, <<Kini inggisɛ duu tangwɛ kpaa, ani ka tangwɛ ba.>> ");
INSERT INTO utr_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Man iYesu nyan gbɛɛ, <<N nya abu otsitsi, mi otu inɛ nɛni, duuse ni ogbigbi teela akpe efa yɔ, abu ka tangwɛ ani akpe eta.>> ");
INSERT INTO utr_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Nghaduu iPyita biibɛ mi ela mfye gbɛɛ, <<Kini li ikwu kpaa ani ka kwulu yi abu, n ka tangwɛ abu ba.>> Angbeka ntona duu kpaa gbɔ ngha. ");
INSERT INTO utr_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","A kɛ imbe ngwi ali kwun di iGesemani, ta iYesu gbɔ yi emi ongwafɔɔn gbɛɛ, <<Sisɛ mmɛnɛ na nin ka bibɔ.>> ");
INSERT INTO utr_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","O kyi kyelu iPyita yi iJɛnsi bɛyi iJɔn lu yan, man o wita ogyadzɛ mi itukwu kpakpa i di kakan ewo. ");
INSERT INTO utr_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Nɛ o nya ma gbɛɛ, <<Elela okyɔɔkyɔ gbɛlu oshishe mgbi ani duu sɔ nghataa kaka mi odzɛɛdzɛ mgbi ikwongye kpaa, nɛ dzɛ mmɛnɛ le ngyo na.>> ");
INSERT INTO utr_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","O si kiyayi gwee ta, kwokɛ esɛ bibɔ gbɛɛ no li kyɛmɛ-kyɛmɛ yɔ, ni obyi nɛ nyɛ ongwu. ");
INSERT INTO utr_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","O si gbɔgbɛɛ, <<Baba, Otsani, alungwɔ dzɛ kyɛmɛ-kyɛmɛ mbi abu. Kyi kyelu ibwɛ adzɛ nɛ mbi ani. Kpaa no ka li mi owitukwu mgbi ani ba, no li mi owitukwu mgbi abu.>> ");
INSERT INTO utr_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Ta o yidɔ wa tu engwafɔɔn tole nuna. O si nya iPyita gbɛɛ, <<iSaimɔn, abu le nunaa? Obyi onyi kpaa abu ka yagba ngyo lo? ");
INSERT INTO utr_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Ngyo di bibɔ ikyegbɛɛ ni ema ka gbɛsɛ mi imbadi ba. Onodzi yɔ le dzɛ yi oweka, kpaa ewo dzatsi.>> ");
INSERT INTO utr_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","O diyɛ lu ka bɔ itɔ ibɔ ngwi o teyi bɔ mani. ");
INSERT INTO utr_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Mi onɔ ngwi o yɛ mani, o diyɛ tu ma tole nuna, ikyekyɛ akwukwinɛ lo loma. A ye odzɛ ngwi a ka gbɔ nyan ba. ");
INSERT INTO utr_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Ngwi o yɛ akpe ongwu ta nɛ, o gbɔ yi ama gbɛɛ, <<Ema kale nuna dile tonya maa? I gyɔ ngha! Onɔ ma gyɔ wa! Dika, a kye Ongwɛ Inggisɛ wo emi ibwubwe abɔ wa. ");
INSERT INTO utr_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Kyato i kɛ na! Inggisɛ nkye ani gya ma ba wa!>> ");
INSERT INTO utr_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Ngwi o kale gbɔdzɛ nɛta, iJuda, onyi mbi iwyodefa ntona, ba wa to. Ibyi inggisɛ to yan, a sha okwusunkli yi itsitsi okwuta, ngwi li engyukwo ama ofifɛ bɛyi etsetse mgbi ola mgbi iMose yi emyinɛ dɔ ma esɔ. ");
INSERT INTO utr_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Mi itɔnɔ nɛ ongye okyon gya na wewo tso ma ambɛ duu gbɛɛ: <<Ongwu ani kye ondu kwon ataka ma li ongwu aali; bwan ngyon kyon lu na.>> ");
INSERT INTO utr_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Vla nɛta iJuda kɛ mbi iYesu, o gbɔgbɛɛ, <<Otsetse!>> Man kye ondu kwon ataka. ");
INSERT INTO utr_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Engyulɔ ntona si kpakli iYesu di bwan. ");
INSERT INTO utr_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Ta onyi mi idzidzɛ mgbi ama nkwulɛsɛ to kwɛkwɛ na kye ngwalu okwusunkli mgban kye kwodzɛ adɔ onyi mgbi ongbidɔ mgbi okwukwo inggisɛ ofifɛ. ");
INSERT INTO utr_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Nɛ iYesu gbɛɛ, <<Ani li inggisɛ ogbe ama oblofɛ teyi se ngwi ema ba mbi ani yi okwusunkli yi itsitsi okwuta owa bwa anii? ");
INSERT INTO utr_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Alegbe ani li dzɛ yi ema, le tso mi ozu okwukwo osunu Imgbasho mi iJerosalin, kpaa ema bwa ani ba. Nghaduu li kyɛmɛ ngwi Afɛ ka mbwumbwo.>> ");
INSERT INTO utr_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Ta ali inggisɛ duu tangwan tsinya dzanta. ");
INSERT INTO utr_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Ongwɛ mmafa oka, kye angwuto ondlɛndlɛ nghaama, le kyɛdɔ iYesu. Mi onɔ ngwi a bwan mani, ");
INSERT INTO utr_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","o tsinya dzata angwuto mgban mi iyikpa, lu ibiba. ");
INSERT INTO utr_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Nɛ a kye iYesu kɛ mbi okwukwo inggisɛ ofifɛ, bɛyi engyukwo ama ofifɛ duu, yi engyukwo emi iJuda yi etsetse mgbi ola kwakye mbonyi. ");
INSERT INTO utr_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","IPyita si kyan iyikpa mbombo, nghataa ka kaka imbe ogbiikwɔ mgbi okwukwo inggisɛ ofifɛ. Mmana o sisɛ yi ama ongyoongyo dile wola. ");
INSERT INTO utr_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Engyukwo ama ofifɛ bɛyi okwakye mgbi ama odi mi ola duu tole pita obwɛndɛ mi ikpewo iYesu ikyegbɛɛ nu ma ngwɔn, kpaa a tu onyi ba. ");
INSERT INTO utr_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Bana inggisɛ kwuba gbɔ obwɛndɛ atsika mi ikpewon, kpaa elodzɛ mgbi ama kwokyi yi eka ba. ");
INSERT INTO utr_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Nɛ inggisɛ angbeka di kyato nu obwɛndɛ atsika mi ikpewon gbɛɛ: ");
INSERT INTO utr_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","<<Eyi fwon le gbɔgbɛɛ, <N ka kye ozu okwukwo osunu Imgbasho mi iJerosalin ngwi inggisɛ mbɛ mi abɔ nɛ kye gbobu diyɛ mbɛ oka mi egbe eta, ongwi li abɔ mgbi inggisɛ mbɛ ba mani.> >> ");
INSERT INTO utr_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Nghaduukpaa obwɛndɛ mgbi ama na kwokyi ba. ");
INSERT INTO utr_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Ta okwukwo inggisɛ ofifɛ kyato mi inɛ mgbi ama si byi iYesu gbɛɛ, <<Abu ka nu uka lo? Li ali obwɛndɛ ngwi inggisɛ ntonɛ le kye ba ikpewo abu ngha?>> ");
INSERT INTO utr_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Kpaa iYesu kwulu ondu nu ma uka ba. Okwukwo inggisɛ ofifɛ na di byun gbɛɛ, <<Abu li iKrestu, Ongwɛ Imgbasho Ongha yi mse naa?>> ");
INSERT INTO utr_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","IYesu si gbɛɛ, <<Li ani ma aani. Ema dika wa di Ongwɛ Inggisɛ ka sɔ abugye mgbi Ongwu Nghaangha dika kyɛ akpa mi esho.>> ");
INSERT INTO utr_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Okwukwo inggisɛ ofifɛ na si kye nghalu angwuto mgban. O byita gbɛɛ, <<Kyɔnɛ ngwi eyi di mina obwɛndɛ angbeka?>> ");
INSERT INTO utr_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","<<Ema fwo ito ntonɛ ma, ema tsɛwɛ sinɛ?>> Ama duu nu iYesu obube gbɛɛ o gyɔ ondu ikwongye. ");
INSERT INTO utr_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Ta angbeka wita okyanggwɔ kyin ewo; a kye ungwɔ bwan inɛ, kwon asa, di nyan gbɛɛ, <<Di yegbɔ ka!>> Ta inggisɛ ama ongyoongyo na byin di gbon ibe. ");
INSERT INTO utr_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Mi onɔ ngwi iPyita ka dzɛ esɛ mi ifyudɛ nɛta, ongwongyaa onyi mi idzidzɛ engbidɔ mgbi okwukwo inggisɛ ofifɛ nani, ba wa kaka. ");
INSERT INTO utr_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Ngwi o di iPyita le wola nɛta, o din inɛ si gblekɛ kwɛkwɛ yan. O nyan gbɛɛ, <<Abu kpaa li kyɛ yi iYesu ongwi iNadzareti.>> ");
INSERT INTO utr_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Nghaduu iPyita tangwɛ gbɛɛ, <<Ani yon hona difwi odzɛ ngwi abu le gbɔ nɛ kpaa ba,>> man o tasɛ mi onufɛ okakaakaka. ");
INSERT INTO utr_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Ngwi ongwongyiidɔ na din mmana nɛ, o di nya ama nkwudzɛ to ma gbɛɛ, <<Inggisɛ nɛ kpaa li onyi mboma.>> ");
INSERT INTO utr_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","IPyita di tangwɛ. I wa dzɛ gwee nɛta, ama nkwudzɛ to kwɛkwɛ na nya iPyita gbɛɛ, <<Li otsitsi abu li onyi mi idzidzɛ ma, bana abu li emi iGalalia.>> ");
INSERT INTO utr_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Ta iPyita wita owo ewon ikamba di fa yi ama gbɛɛ, <<Ani ye inggisɛ ngwu ema le gbɔdzɛ kwu iyin nɛ ba.>> ");
INSERT INTO utr_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Mina nɛta ogbigbi teela akpe efa. Ta iPyita wɛ elodzɛ ongwi iYesu gbɔ yan gbɛɛ: <<Ogbigbi ka teela akpe efa waba ta, abu ka tangwɛ ani akpe eta mani.>> Man o si nyɛ yi ikwu otseetse. ");
INSERT INTO utr_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Mi egbegbe ototu nɛta, engyukwo ama ofifɛ yi engyukwo mgbi emi iJuda bɛyi etsetse mgbi ola yi okwakye mgbi ama ogbiikwɔ gbela yi ewoma. A si bwalu iYesu kyon wa nu iPlatu (ongwu nli iGɔna mgbi emi iRoma nani). ");
INSERT INTO utr_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","IPlatu si byi iYesu gbɛɛ, <<Abu li utɔ mgbi emi iJudaa?>> Nɛ iYesu nun uka gbɛɛ, <<Ɛɛn, dafi abu gbɔ mani.>> ");
INSERT INTO utr_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Engyukwo ama ofifɛ du ongwufabɔ mbon mi itɔdzɛ kwuba. ");
INSERT INTO utr_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Nɛ iPlatu diyɛ byun gbɛɛ, <<Abu ka nu ani uka lo? Di umbwo ungwɔ ngwi a le du ongwufabɔ mbi abu ikye ma nɛni.>> ");
INSERT INTO utr_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Nghaduu iYesu di nun uka ba kpɔɔ, ta i si kwulu iPlatu ewo. ");
INSERT INTO utr_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Alonɔ oga owɛ owatɔ-watɔ mgbi emi Israi yɔ, iPlatu li dulu inggisɛ onyi mi obawi, ongwu emi iJuda mina mani. ");
INSERT INTO utr_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Ongyulɔ oka ngwu a li kwun di iBaraba wodzɛ obawi. A bwalun yi inggisɛ angbeka ka wokɛ obawi ikyegbɛɛ a ngwɔ inggisɛ onɔ ngwi a le kyɔ ablodzɛ. ");
INSERT INTO utr_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Ibyi inggisɛ wulu ba mbi iPlatu wa nyan gbɛɛ no kyɔ yi ama ungwɔ ngwi o li tsekise kyɔ mani. ");
INSERT INTO utr_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Man iPlatu byita gbɛɛ, <<Ema mina gbɛɛ ni ani dzata utɔ mgbi emi iJuda nu emaa?>> ");
INSERT INTO utr_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Ikyesinɛ o ye dafi li uwaba ngwi engyukwo ama ofifɛ kye iYesu wa nun mani. ");
INSERT INTO utr_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Kpaa engyukwo ama ofifɛ si fyi ibyi inggisɛ ntona mfye itukwu gbɛɛ nu ma nu iPlatu dzita iBaraba no ka li iYesu ba. ");
INSERT INTO utr_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","IPlatu byi ma gbɛɛ, <<Li ekyɛ nin kyɔ yi ongwu ema kwun di utɔ mgbi emi iJuda nɛ?>> ");
INSERT INTO utr_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","A wulu gbɛɛ, <<Ngwɔn mi ekwatsi!>> ");
INSERT INTO utr_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","IPlatu byita gbɛɛ, <<Li alungwɔ obube ngwi o kyɔ?>> Kpaa a nghao gbɔ mi ela okwukwo gbɛɛ, <<Ngwɔn mi ekwatsi!>> ");
INSERT INTO utr_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Ngwi o mina okyɔ itukwu mgbi ibyi nɛ, iPlatu si dzata iBaraba nu ma. O nu ma gbo iYesu onitse ibyibyi si kyon nu ma oka ngwɔ mi ekwatsi. ");
INSERT INTO utr_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Ama oblakwutsɛ si kye iYesu lu udɛ iGɔna, mi imbe o li sɔ gbiikwɔ si kwu ewoma ela tsatsa kwakye. ");
INSERT INTO utr_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","A kye angwuto omuma shinishini won, di kyi shili akata ato kye tukwun ikye. ");
INSERT INTO utr_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Ta a wita onyan agya gbɛɛ, <<Eyi ta abu angba utɔ mgbi emi iJuda!>> ");
INSERT INTO utr_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","A diyɛ kye okwuta le gbon mi ikye di kyanggwɔ kyin. Man a gbe akwafɔ kwɛsɛ diyɛ sunun. ");
INSERT INTO utr_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Ngwi a nyan agya nɛ, a dulun angwuto omuma shinishini na kye mgban won. Ta a kyon tasɛ oka ngwɔ mi ekwatsi. ");
INSERT INTO utr_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Ongyulɔ oka mi igeli iSirini, ngwu a li kwun di iSaimɔn, otsɔ Alekidzanda bɛyi iRufu, yɛ kyɛ ɛsɛ mgban nyɛ le lu. A siin gbɛɛ non kye ekwatsi nani. ");
INSERT INTO utr_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Nɛ a kye iYesu ba imbe ngwi a li kwun di iGogota nani (ngwi itan di Imbe Ikpalikye). ");
INSERT INTO utr_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Ta a kye eneekwɔ takye yi otse oyulu ungwɔ owulewo nun gbɛɛ no wa, kpaa o fwa owaawa. ");
INSERT INTO utr_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Man a kyon gbokwo mi ekwatsi. A gbelun angwuto kye ghalu, a gbeefa ikye odi ungwɔ ngwi ali inggisɛ ka tu mani. ");
INSERT INTO utr_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Li obyi ongwu gyanɛ mi egbegbe ngwi a kyon gbokwo ekwatsi. ");
INSERT INTO utr_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","A lɔ ungwɔ ama ngwi a du ongwufabɔ mbon mi ele ma gbɛɛ: UTƆ MGBI EMI IJUDA. ");
INSERT INTO utr_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","A gbokwo ama ofoofɛ nghi efa biyan, onyi mi abugye mgban yi oka mi abubɛ. ");
INSERT INTO utr_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","(Nɛ Afɛ mbwumbwo odzɛ ngbɛɛ, <<A gbɔn wo umbwo yi ama ofoola.>>) ");
INSERT INTO utr_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Ama nle nyɛ ofɛ gbe ito tukwun kpakpa, le ngwi ikye dile gbɛɛ, <<Oho! Abu ngbɛɛ o ka gbobu ozu okwukwo osunu Imgbasho mi iJerosalin diyɛ kyi mbɛlu mi egbe eta nɛ, ");
INSERT INTO utr_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","tashulu mi ekwatsi ba esɛ di dulu ewabu tɔ ka!>> ");
INSERT INTO utr_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Li ngha ngwi engyukwo ama ofifɛ bɛyi etsetse mgbi ola kpaa le nyan agya yi ewoma gbɛɛ, <<O li dulu angbeka tɔ, kpaa o yagba dulu ewon tɔ wuba! ");
INSERT INTO utr_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Ni iKrestu, utɔ mgbi emi Israi nɛ, tashulu onɛnɛ mi ekwatsi ba esɛ, ni eyi di diyɛ noyɛyɛ.>> Ama ngwu a kye ma gbokwo ekwatsi biyan kpaa fan esɛ. ");
INSERT INTO utr_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Mi onɔ idzidzɛ udɛ yɛyɛ nɛta ɛsɛ duu yifu nghataa ba obyi eta mi onɔdɛ. ");
INSERT INTO utr_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Mi obyi ongwu ta mi onɔdɛ na, iYesu si makwɔ mi ela okwukwo gbɛɛ, <<Eli, Eli, lama sabatani?>> Ngwi itan gbɛɛ, <<Imgbasho mgbi ani, Imgbasho mgbi ani, li ekyɛ ngwi abu le dzanita?>> ");
INSERT INTO utr_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Ngwi ama nkwulɛsɛ to kwɛkwɛ fwo ungwɔnɛ nɛ, a gbɔgbɛɛ, <<Gadɔ na, o le kwu Elaija ela.>> ");
INSERT INTO utr_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Ongyulɔ onyi mboma tsinya kɛ, kye isoso wokɛ eneekwɔ onunɔ, kye fakɛ ekwɔ si kyilen kye nu iYesu gbɛɛ no wa. Man o gbɔgbɛɛ, <<Dzanta na. Ni eyi di kyayina Elaija ka wa tashulun ba esɛ.>> ");
INSERT INTO utr_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","IYesu gbobakwɔ mi ela okwukwo man o si yulu. ");
INSERT INTO utr_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Ta angwuto ngwi a kye tsɛ mi idzidzɛ ozu okwukwo osunu Imgbasho mi iJerosalin na gbua efa mi esho nghataa luba esɛ. ");
INSERT INTO utr_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Ngwi agyegika mgbi ama oblakwutsɛ, ongwu nkwulɛsɛ mmana mi inai iYesu, fwo akwɔ mgban yɛ di dafi o kwulu nɛ, o gbɔgbɛɛ, <<Otsitsi inggisɛ nɛ li Ongwɛ Imgbasho!>> ");
INSERT INTO utr_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Engyaa angbeka kwulɛsɛ mbombo le di ungwɔ nle kiyayi mani. Mi idzidzɛ ma li iMeri iMagidalin bɛyi iMeri onɔ iJɛnsi ongbungbɛ bɛyi iJosisi yi iSalomi. ");
INSERT INTO utr_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Mi iGalalia engyaa ntonɛ nose li kyɛ yi iYesu dile yan abɔ kpaa. Engyaa angbeka kwuba nba biyan mi iJerosalin kpaa to imbe nani. ");
INSERT INTO utr_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Li egbe owewo (obwi egbe otonyewo). Ngwi onɔ le gbɛsɛ nɛ, ");
INSERT INTO utr_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","iJose ongwi Arimatia, inggisɛ okpɔngɔ mi idzidzɛ okwakye mgbi ama ogbiikwɔ, ongwu abuon le fɛ obaaba mgbi esutɔ mgbi Imgbasho. O kɛ yi imio ba mbi iPlatu ka bɔn ikwɔ mgbi iYesu. ");
INSERT INTO utr_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Nɛ i kwulu iPlatu ewo ofwo gbɛɛ iYesu kwulu wa. O kwu ongyukwo mgbi ama oblakwutsɛ na ela, o byun ita ni iYesu kwulu wa yɔ. ");
INSERT INTO utr_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Ngwi o wa fwo mi ondu ongyukwo mgbi ama oblakwutsɛ gbɛɛ dzɛ ngha nɛ, o kye ikwɔ na nu iJose. ");
INSERT INTO utr_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Ta iJose gya angwuto ondlɛndlɛ, o kye sulu ikwɔ mgbi iYesu kye ndiwokɛ angwuto na man kyon ndzi mi endzi ngwi a cɛfo ikwutsɛ. Ta o tsamu ofishi tukwu ondendzi. ");
INSERT INTO utr_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Nɛ iMeri iMagidalin bɛyi iMeri onɔ iJosisi di imbe ngwi a kyon ndzi mani. ");
INSERT INTO utr_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Ngwi egbe otonyidɔ wa nyɛ nɛ, iMeri iMagidalin bɛyi iMeri onɔ iJɛnsi yi iSalomi gya engyie ogbungbɛ ikyegbɛɛ ni ama ka kye gyuwo ikwɔ mgbi iYesu. ");
INSERT INTO utr_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Mi egbegbe byibyiibyi mi egbe ongwi ababɔ mi ikyidu (egbe iladi) ngwi onɔ le tɔ nɛni. A si tɔ ofɛ le lu endzi, ");
INSERT INTO utr_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","a byi eka ita mi ofɛ gbɛɛ, <<Li emɛ ka mulu eyi ofishi mi ondendzi nɛ?>> ");
INSERT INTO utr_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Kpaa ngwi a kyile ikye esho nɛ, a di gbɛɛ ofishi ngwi a kye tukwu ondendzi ma mulu. ");
INSERT INTO utr_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Ngwi a kaka endzi nɛ, a di ongwongyulɔ mmafa wo angwuto onzundzɛ sɔdzɛ agya abugye mi endzi, ta i kwulu ma ewo. ");
INSERT INTO utr_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Ongyulɔ na nya ma gbɛɛ, <<Ka tsimio ba na. Ema le pita iYesu ongwi iNadzareti, ongwu a ngwɔn mi ekwatsi nani. O kyato mi ikwu! O dzɛ mmɛnɛ wuba. Di imbe ngwi a kyon la ma na. ");
INSERT INTO utr_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Nghanɛ ema yɛ lu na ka nya engwafɔ mgban yi iPyita gbɛɛ, <O teyi ema le lu iGalalia ma. Ema ka din mi imbe na, dafi o tsekise nya ema mani.> >> ");
INSERT INTO utr_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Engyaa ntona si tasɛ mi endzi tsinya. Ewo shi igakwu loma i di wo ma ɛndɛ. A gbɔdzɛ yi inggisɛ onyi kpaa wuba, ikyena imio wo ma. ");
INSERT INTO utr_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Ngwi iYesu kyato mi egbe iladi mi egbegbe nɛ, o kye ewon tso mbi iMeri iMagidalin ababɔ, ongwu o lɔ onodzi ibwubwe tɔ mbon nghi egyafa nani. ");
INSERT INTO utr_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","O si lu ka nya ama nkyɛ yan tole tsukwu dile makwɔ mani. ");
INSERT INTO utr_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Ngwi a fwo gbɛɛ iYesu dzɛ oshishe, ongyaa na din nɛ kpaa, a noyɛyɛ mi ele ba. ");
INSERT INTO utr_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Onɔ wa nyɛ nɛ, iYesu di kye ewon tso emi ongwafɔɔn angbeka nghi efa mi ofɛ oka idzidza onɔ ngwi a le kyikyɛ mi ɛsɛ na mani. ");
INSERT INTO utr_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","A si yɛ wa nya angbeka ntona; kpaa a nu ma oyɛyɛ ba. ");
INSERT INTO utr_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Onɔ gwee nɛ, iYesu di mblegba to iwyodonyi ntona ngwi a le gye ungwogye; o shɔdzɛ yi ama mi oyɛyɛ onuunu ba bɛyi ikyegbɛɛ a fwa kye itukwu tiishu onoyɛyɛ mbi ama ndin onɔ ngwi o kyato mi ikwongye mani. ");
INSERT INTO utr_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Man o nya ma gbɛɛ, <<Lu ɛsɛ ka gbɔ Esɔ Osuse nɛ nya ali inggisɛ duu. ");
INSERT INTO utr_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Ali inggisɛ nnoyɛyɛ ngwi a di kyɔn iBatisima yɔ, o ka watɔ, nghaduu inggisɛ nnoyɛyɛ bayɔ, o ka dzili. ");
INSERT INTO utr_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Ambɛ ntonɛ dika kyɛdɔ ama nnoyɛyɛ: Mi iyi mgbi ani a ka lɔ onodzi ibwubwe tasɛ; a dika gbɔ ondudzɛ ofufɛ; ");
INSERT INTO utr_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","a ka kye abɔ byi ifa; ni a wa otse ikwongye kpaa unkonyi ka kyɔ ma ba du; a dika kye abɔ gbo ama ndotse ta ootse ka ngyɛ loma.>> ");
INSERT INTO utr_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Ngwi Otsɛ iYesu gbɔdzɛ nɛ yi ama ngyɛ nɛta, Imgbasho kyon lu esho, o sika sɔkɛ abugye mgbi Imgbasho. ");
INSERT INTO utr_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Nɛ emi ongwafɔɔn si tasɛ ka gbeesɔ mi ali imbe duu, ta Otsɛ Imgbasho kyidɔ yi ama dile mbwumbwo mi elodzɛ mgban yi ambɛ nkyɛdɔ mani.");
INSERT INTO utr_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Dafi inggisɛ kwuba fya olɔ ungwɔ nkiyayi mi idzidzɛ mgbi eyi nɛ, ");
INSERT INTO utr_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","ungwɔ olɔɔlɔ nɛ ba mbi eyi mi abɔ mgbi ama ndi inɛ-inɛ di li engbidɔ, ama nkye ewoma fifɛ mi elodzɛ na mani. ");
INSERT INTO utr_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Nghanɛ, iTiofyilɔ otsungwudɛ, dafi ani abuani kya mi odzɛ nɛ saan mi owita-wita nɛ, n di gbɛɛ i tishi nin lɔn imbisɔn-mbisɔn mi ikye abu, ");
INSERT INTO utr_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","zukwu ni abu difwi otsitsi mgbi ungwɔ ngwi a tso abu nani. ");
INSERT INTO utr_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Mi onɔ ngwi iHerude li utɔ mgbi iJudia mani, inggisɛ ofifɛ mgbi Imgbasho oka iyin gbɛɛ iDzakaria, mi ayɛ inggisɛ ofifɛ mgbi Imgbasho mgbi Abyija nani; owan Elidzabeti kpaa li mi etɔ mgbi Eron (ongwu kpaa li etɔ mgbi inggisɛ ofifɛ mgbi Imgbasho). ");
INSERT INTO utr_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Ama efa duu le nyaan mi inɛ Imgbasho, a ngyo ola di gbela yi odzɛ owɛ-wɛ mgbi Otsɛ Imgbasho, a sulu idza ewo ba du. ");
INSERT INTO utr_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Nghaduu a dzɛ yi ongwɛ ba, ikyesinɛ Elidzabeti li ogyoma; ama duu egbe mgbi ama kɛ. ");
INSERT INTO utr_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Egbe oka nɛ, iDzakaria dzɛ ondidɔ mgban mgbi inggisɛ ofifɛ mgbi Imgbasho mi ozu okwukwo osunu Imgbasho mi iJerosalin mi onɔ ngwi idɔ dikyon. ");
INSERT INTO utr_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","A sadun mi efa ogboogbo, dafi nli ola mgbi ama ofifɛ mgbi Imgbasho mani, gbɛɛ no kaka ozu idzidzɛ mgbi Imgbasho mi imbe iwashi okye ungwɔ ogbungbɛ toola. ");
INSERT INTO utr_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Onɔ ngwi iDzakaria kye ungwɔ ogbungbɛ na le toola nɛ, ibyi inggisɛ ama osunu Imgbasho kwutokɛ esɛ le bibɔ. ");
INSERT INTO utr_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Man ongyesɔ mgbi Otsɛ Imgbasho mblegba tun, o kwudzɛkɛ abugye mgbi iwashi okye ungwɔ ogbungbɛ toola. ");
INSERT INTO utr_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Ngwi iDzakaria di ongyesɔ nɛ, i kakan ewo, imio di won. ");
INSERT INTO utr_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Ongyesɔ nyan gbɛɛ, <<Ka mio ba, iDzakaria; Imgbasho fwo ibɔ mgbi abu. Owaabu Elidzabeti ka mba abu ongwongyulɔ, o ka kwun iyi di iJɔn. ");
INSERT INTO utr_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Abu ka dzɛ yi atsa diyɛ shisha. Ibyi inggisɛ angbeka ka tsatsa mi ombaamba mgbi ongwɛ nani. ");
INSERT INTO utr_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Ongwɛ na ka li angbodzi inggisɛ mi inɛ mgbi Otsɛ Imgbasho, o ka wa ɛbyɛ hona ungwɔ ofyumfye ba, o ka mbwo yi Onodzi Osaan wita mi onɔ ngwi onɔn byifun mani. ");
INSERT INTO utr_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","O ka kyata emi Israi kwuba, yile ma luba mbi Otsɛ Imgbasho mgbi ama. ");
INSERT INTO utr_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Ongwɛ na ka dzɛ Otsɛ Imgbasho iyayi, o ka dzɛ dafi Elaija mi Onodzi bɛyi mfye, okyatitukwu mgbi etsɛngwɛ yɛ luba mbi engwɛ, ama onghaadɔ yɛ luba ozoyeye mgbi ama osaan, adzi ni ongwu kye mɛlu inggisɛ mgbi Otsɛ tokɛ le fan fɛɛfɛ.>> ");
INSERT INTO utr_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","IDzakaria byi ongyesɔ na gbɛɛ, <<Li mi ali ofɛ ngwi ani ka ye gbɛɛ ungwɔnɛ ka wa dzɛ ngha? Bana ani kyɛ, owaani kpaa kyɛ.>> ");
INSERT INTO utr_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Ongyesɔ nun uka gbɛɛ, <<Li ani iGebre, ani kwudzɛ mi inɛ Imgbasho, ongwu ndɔ ani esɔ gbɛɛ ni ani gbɔ nya abu di kye elodzɛ osuse nɛ ba mbi abu mani. ");
INSERT INTO utr_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Dafi abu noyɛyɛ mi ungwɔ nka wa kyɔ mi onɔ mgban ba nɛ, o ka yɛɛ ikplima di yagba ogbɔdzɛ wuba, nghataa egbe ngwi owa abu ka wa fwise mani.>> ");
INSERT INTO utr_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Nghanɛ, ama ntole fɛ iDzakaria mi esɛ ma i kwulu ma ewo dafi o mbe onɔ kwuba mi ifoozu okwukwo osunu Imgbasho mi iJerosalin ngha mani. ");
INSERT INTO utr_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Ngwi o wa tɔ luba esɛ ma, o yagba gbɔdzɛ yi ama wuba, man a difwi gbɛɛ o di ungwɔ mi ozu okwukwo osunu Imgbasho mi iJerosalin, o yɛ le gbɔdzɛ yi ama mi abɔ ta o si yɛɛ ikplima. ");
INSERT INTO utr_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Ngwi onɔ idɔ mgban mi ozu Imgbasho wa ngyɛ nɛman, o yɛ lu udan. ");
INSERT INTO utr_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Onɔ wa nyɛ gwee nɛta, owan Elidzabeti si tiludɛ, o kye ewon da ofyia eda. ");
INSERT INTO utr_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","O gbɛɛ, <<Li Otsɛ Imgbasho kyungwɔnɛ yi ani, mi olɛlɛ nɛ o nu ikyese dɔ ani di kyelu ayiwi mgbi ani mi inɛ inggisɛ.>> ");
INSERT INTO utr_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Ngwi ifu mgbi Elidzabeti wa li ofyia egyin mata, Imgbasho dɔ ongyesɔ iGebre kɛ ogalu iNadzareti, mi ayɛsɛ mgbi iGalalia, ");
INSERT INTO utr_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","mbi ibidrua ongyaa ngwu a li kwun gbɛɛ iMeri, ngwu inggisɛ oka mi etɔ mgbi iDevedi. Ongwu a li kwun di iJose, tsikwɔn dzɛ esɛ nani. ");
INSERT INTO utr_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Ongyesɔ na ba mbon, o tan angba di nyan gbɛɛ, <<Abu ngwu ikyese dɔ abu kpakpa nɛ! Otsɛ Imgbasho dzɛ yi abu.>> ");
INSERT INTO utr_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Itukwu gbo-gbo lo iMeri kwuba mi elodzɛ mgbi ongyesɔ nɛni, i di kwulun ewo mi itɔ angba na dafi ka dzɛ mani. ");
INSERT INTO utr_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Ongyesɔ iGebre nyan gbɛɛ, <<Ka mio ba, iMeri, bana ikyese dɔ abu mbi Otsɛ Imgbasho. ");
INSERT INTO utr_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Abu ka wa byifu di mba ongwongyulɔ, o ka kwun iyi gbɛɛ iYesu. ");
INSERT INTO utr_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","O ka li angbodzi inggisɛ a dika kwun gbɛɛ Ongwɛ mgbi Ongwu Nghaangha mi esho. Otsɛ Imgbasho dika kye itsuutɔ mgbi otsɔn iDevedi kye nun. ");
INSERT INTO utr_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","O ka li Utɔ mi etɔ mgbi iJeko gyegwu, esutɔ mgban ka dondu ba.>> ");
INSERT INTO utr_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","IMeri byi ongyesɔ na gbɛɛ, <<Ungwɔnɛ ka dzɛ ngha sinɛ? Ngwi ani ye ongyulɔ waba.>> ");
INSERT INTO utr_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Ongyesɔ nu uka gbɛɛ, <<Onodzi Osaan ka kyi gbɛlu abu sɔ, mfye mgbi Ongwu Nnghaangha mi esho dika gbiiwulu tukwu abu. Nɛ Ongwɛ Osaan ngwu abu ka wa mba na, a ka kwun gbɛɛ Ongwɛ Imgbasho. ");
INSERT INTO utr_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Elidzabeti, odo abu ngwu a tsɛwɛ gbɛɛ o li ogyoma nani, o dzɛ yi ewefa ofyia egyin waani. ");
INSERT INTO utr_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Lubana ungwɔ ngwi Imgbasho ka kyɔ gbɛ ba dzɛma ba.>> ");
INSERT INTO utr_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","IMeri gbɛɛ, <<Ani li ongwongyiidɔ mgbi Otsɛ Imgbasho, no kyɔ yi ani dafi abu gbɔ nɛni.>> Man ongyesɔ na lu dzatan. ");
INSERT INTO utr_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Mi onɔ na iMeri wewo di yewo lu ogalu mi ewunggwɔ mi ɛsɛ iJudia. ");
INSERT INTO utr_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","O ka kaka udɛ iDzakaria, man o ta Elidzabeti angba. ");
INSERT INTO utr_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Ngwi Elidzabeti fwo angba mgbi iMeri nɛ, ongwɛ gbokyɛɛ lon mi ifu. Ta Elidzabeti si mbwo yi Onodzi Osaan. ");
INSERT INTO utr_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","O gbɔ mi ela okwukwo gbɛɛ, <<Mse dzɛ yi abu mi idzidzɛ engyaa duu yi ongwɛ ngwu abu ka mba nani. ");
INSERT INTO utr_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Kyɔsinɛ ngwi ikyese dɛn ngha, ngwi onɔ Otsɛ mgbi ani ba mbi ani? ");
INSERT INTO utr_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Bana ngwi ani fwo angba mgbi abu mata, ongwɛ gbokyɛɛ len mi ifu yi atsa. ");
INSERT INTO utr_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Mse no dzɛ yi abu ngwu noyɛyɛ gbɛɛ, odzɛ ngwi Otsɛ Imgbasho gbɔ yi abu ka wa dondu yɛyɛ mani.>> ");
INSERT INTO utr_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","IMeri gbɛɛ, <<Itukwu mgbi ani tsɛ Otsɛ Imgbasho ");
INSERT INTO utr_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","oshishe mgbɛn dzɛ yi atsa mi ikye Imgbasho Onagbɛ ani, ");
INSERT INTO utr_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","lubana o wɛ ani nli unka ba, ongwongyiidɔ mgban. Wita mi onɛnɛ lu iyayi etɔ duu kale kwu ani gbɛɛ ogbumse, ");
INSERT INTO utr_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","bana Imgbasho odatu kyungwɔ okwukwo mi ikye ani, Osaan li iyi mgban. ");
INSERT INTO utr_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Elela odiidi mgban li na kɛ, mbi ama nli sunun, mi etɔ nghataa kɛ etɔ. ");
INSERT INTO utr_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","O kyungwɔ ama odatu mi abɔ mgban; o kye ganya ama okyile ewo esho, mi ɛwɛ otsɛɛtsɛ mgbi ama. ");
INSERT INTO utr_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","O tashulu ama nsɔ utɔ mi itse mgbi ama kpaa o kyile ama oyile ewo esɛ esho. ");
INSERT INTO utr_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Ama ngwu enbwa dɔ ma ma, o mbwo ma yi ungwɔ osuse, kpaa emi awuya yɔ, o wo ma ofɛ abubɔ. ");
INSERT INTO utr_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","O tobyi ongwongbɛ, mgban Israi, mi ondu odzɛɛdzɛ mgban yi emi otseyi ");
INSERT INTO utr_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","mbi Abrahan bɛyi engwiba mgban gyegwu.>> ");
INSERT INTO utr_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","IMeri la mbi Elidzabeti mɛ dafi ofyia eta man yɛ lu udɛ. ");
INSERT INTO utr_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Ngwi onɔ imba mgbi Elidzabeti wa gyɔ nɛta, o mba ongwongyulɔ. ");
INSERT INTO utr_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Emi ongwunɔn bɛyi ama owatse dɔn fwo gbɛɛ Otsɛ Imgbasho tso elela odiidi kpakpa mbon nɛ, a tsatsa yan. ");
INSERT INTO utr_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Ongwɛ wa mbwo egbe egyata nɛ, a ba owa kyan ikyɛ, ma dzɛ mbisɔ ngwi a ka yile iyi otsɔn kyɔn gbɛɛ, iDzakaria. ");
INSERT INTO utr_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Nghaduu onɔn nya ma gbɛɛ, <<Ei! Dzɛ mbisɔ ngwi a ka kwun di iJɔn.>> ");
INSERT INTO utr_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","A nyan gbɛɛ, <<Inggisɛ onyi mi etɔ mgbi abu dzɛ yi iyi na ba.>> ");
INSERT INTO utr_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","A gbɔdzɛ yi iDzakaria mi abɔ gbɛɛ nu ma ye iyi ngwi o mina okyɔ ongwɛ na mani. ");
INSERT INTO utr_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","O kyɔ ambɛ gbɛɛ nu ma nun ongwɛ akwukwɔ olɔ ungwɔ, o si lɔ iyin gbɛɛ, <<IJɔn.>> Ta i kwulu ali inggisɛ duu ewo. ");
INSERT INTO utr_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Labɔlabɔ nɛman ondu mgbi iDzakaria kwulu ta itiidɛ shɛ lon o di wita gbɔdzɛ, le tsɛ Imgbasho. ");
INSERT INTO utr_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Ama nwatse dɔn duu i kwulu ma ewo, inggisɛ ama nto ɛsɛ undɔ mgbi iJudia duu le gbɔdzɛ ungwɔ okwulewo ntonɛni. ");
INSERT INTO utr_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Ali inggisɛ nfwo odzɛ nɛ le tsɛwɛ mi ele, le byita gbɛɛ, <<Li ali itɔ inggisɛ ngwi ongwɛ nɛ ka wa dzɛ?>> Bana mfye mgbi Imgbasho dzɛyan. ");
INSERT INTO utr_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Ta otsɔn iDzakaria mbwo yi Onodzi Osaan man o wita ogbɔdzɛ mi ela oyegbɔ gbɛɛ: ");
INSERT INTO utr_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","<<Nu ma tsɛ Otsɛ, Imgbasho mgbi emi Israi, lubana o ba wa tobyi emidan di nagbɛ ma. ");
INSERT INTO utr_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","O kye otlɛsɛ mgbi owatɔ-watɔ tuo ikye eyi, mi etɔ mgbi ongwongbɛ mgban iDevedi. ");
INSERT INTO utr_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Dafi o gbɔ nyɛ mbi oyegbɔ osaan emi tugbe ");
INSERT INTO utr_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","gbɛɛ ongwu ka dulu eyi tɔ mi abɔ engyikyili mgbi eyi, bɛyi mi abɔ mgbi ama ngwu di eyi lanyi ");
INSERT INTO utr_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","ikye otso elela odiidi mbi emi otseyi diyɛ wɛ ondu odzɛɛdzɛ mgban osaan, ");
INSERT INTO utr_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","ofaafa ngwi o fa yi otseyi Abrahan: ");
INSERT INTO utr_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","odulu eyi tɔ mi abɔ engyikyili mgbi eyi, ikye onu eyi sunun yi imio ba ");
INSERT INTO utr_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","mi osaan bɛyi osaan mi iyayi mgban, mi egbe oshishe mgbi eyi duu. ");
INSERT INTO utr_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Abu ongwani, a ka kwu abu gbɛɛ, oyegbɔ mgbi Ongwu Nnghaangha mi esho; lubana abu ka teyi Otsɛ ikye omɛlun ofɛ. ");
INSERT INTO utr_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Onu emidan difwi odzɛ mgbi owatɔ-watɔ mi odzita ma yi ali ibwubwe. ");
INSERT INTO utr_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Mi ikye elela odiidi oleewo mgbi Imgbasho mgbi eyi, ikyegbɛɛ ni osa dafi onɔ mi esho, gbosa ba esɛ mbi eyi ");
INSERT INTO utr_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","azukwu no wa nu osa mbi ama nwoto iyifu bɛyi iwulu ikwongye duu, ongyo eyi afɔ byi ofɛ iyu.>> ");
INSERT INTO utr_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Nɛ ongwɛ na she di yɛɛ kpɔklɔɔ mi onodzi, o la okwɛsɛ nghataa se o wa kye ewon tso emi Israi mi ododa. ");
INSERT INTO utr_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Mi onɔ na iSidza (utɔ) Ogɔstu, utɔ mgbi emi iRoma noola gbɛɛ nu ma lɔ mmbwo inggisɛ mi ɛsɛ iRoma tsatsadu. ");
INSERT INTO utr_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Nɛnɛ li mmbwo olɔɔlɔ ongwi ababɔ mi onɔ ngwi iKwirinu li iGɔna odi mi ɛsɛ iSiria mani. ");
INSERT INTO utr_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Ali inggisɛ lu oka lɔ mmbwo mi ɛsɛ udan. ");
INSERT INTO utr_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","IJose kyato mi igeli iNadzareti mi ayɛsɛ iGalalia, lu iBɛtlɛhɛn ogalu mgbi iDevedi mi ayɛsɛ iJudia, ikyekyɛ o tɔ mi etɔ mgbi iDevedi. ");
INSERT INTO utr_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","O kɛ oka lɔ mmbwo na yi iMeri, ongwu o tsikwɔn dzɛ esɛ dzɛ yi ifewo nani. ");
INSERT INTO utr_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Ngwi a ka to iBɛtlɛhɛn nɛta imba kwun, ");
INSERT INTO utr_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","o si mbongwɛ mgban ovlɛ, ongwongyulɔ. O kye oshata ndiwon kyon lakɛ ikpɔkɔ, lubana a tu imbe mi ozu ingyoga ba. ");
INSERT INTO utr_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Ama ongyo ifyungwɔ angbeka to agya ɛsɛ nani, a lato oshɛ tole ngyo ifyungwɔ mgbi ama mi otu. ");
INSERT INTO utr_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Ongyesɔ mgbi Otsɛ Imgbasho wa mblegba tu ma, ta okwɔkwɔ mgbi Otsɛ gbosa kpakɛkɛ wo ma, nɛ imio wo ma kpakpa. ");
INSERT INTO utr_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Kpaa ongyesɔ nya ma gbɛɛ, <<Ka mio ba na, ikyena ani ba yi ema Esɔ Osuse mgbi atsa ngwi shewo nka dzɛ ikye ali inggisɛ duu. ");
INSERT INTO utr_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Inɛ nɛ mi ogalu mgbi iDevedi a mba ema ongye Onagbɛ, o li iKrestu Otsɛ. ");
INSERT INTO utr_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ungwɔ nka li ambɛ mbi ema yɔ, ema ka di ongwɛ eyeyi a kyon ndi wodzɛ oshata ladzɛ ikpɔkɔ.>> ");
INSERT INTO utr_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Plɛ nɛta ibyi engyesɔ emi esho ba wa tu ongyesɔ nani, le tsɛ Imgbasho dile gbɛɛ, ");
INSERT INTO utr_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","<<Okwɔkwɔ no dzɛ yi Imgbasho ngwu Ngha mi esho, mi ɛsɛ nɛ iyu no dzɛ yi ama ngwu ikyese mgban dɔ ma mani.>> ");
INSERT INTO utr_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Onɔ ngwi engyesɔ dzamata yɛ lu esho mata, ama ongyo ifyungwɔ gbɔ yi ewoma gbɛɛ, <<Ba i kɛ iBɛtlɛhɛn ni i ka di ungwɔ nkyɔ se ngwi Otsɛ Imgbasho nya eyi odzɛ ele nɛni.>> ");
INSERT INTO utr_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","A byakpa lu maama si ka dili iJose yi iMeri bɛyi ongwɛ eyeyi na ladzɛ ikpɔkɔ. ");
INSERT INTO utr_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Mi onɔ ngwi ama ongyo ifyungwɔ ntona di ongwɛ mata, a le gbɔdzɛ ngwi ongyesɔ nya ma mi ikpewo ongwɛ nɛni. ");
INSERT INTO utr_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Ama nfwo odzɛ nɛ duu i kwulu ma ewo mi odzɛ ngwi ama ongyo ifyungwɔ gbɔ mi ikpewo ongwɛ nɛni. ");
INSERT INTO utr_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Nghaduu iMeri kwulu ungwɔ ntonɛ duu wokɛ itukwu diyɛ le tsɛwɛ mi ele. ");
INSERT INTO utr_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Ama ongyo ifyungwɔ ntona yidɔ lu, le kyile iyi Imgbasho deesho dile tsan mi alungwɔ ngwi ama fwo diyɛ di, ngwi kyɔ yɛyɛ dafi a plɛ nya ama mani. ");
INSERT INTO utr_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","A mban nyɛ egbe egyata, ngwi li egbe a ka kyan ikyɛ nɛman, a si kwun iyi gbɛɛ, iYesu, iyi ngwi ongyesɔ teyi nu duuse a wa byifun mani. ");
INSERT INTO utr_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Ngwi egbe ogbiiyɛ mgbi ama wa gyɔ dafi ola mgbi iMose gbɔ ma nɛ, iJose yi iMeri kye iYesu kɛ iJerosalin oka kyon dubɔ Otsɛ Imgbasho. ");
INSERT INTO utr_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","(Dafi a lɔ mi ola mgbi Otsɛ gbɛɛ, <<Ali ongwongyulɔ ovlɛ ngwu a mba duu nu ma kye dubɔ Otsɛ Imgbasho>>), ");
INSERT INTO utr_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","odi fifɛ dafi ola mgbi Imgbasho gbɔ mani: <<Anyama nghi efa, hona ibidrua ingyakpa efa.>> ");
INSERT INTO utr_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Mi onɔ na inggisɛ oka dzɛ iJerosalin a kwun di iSimiɔn, o le saan di gbekabyi idɔ mgbi Imgbasho. Ongwu nose le fɛ owatɔ-watɔ mgbi emi Israi, Onodzi Osaan nose dzɛyan. ");
INSERT INTO utr_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Onodzi Osaan teyi kye tson gbɛɛ o ka di ikwongye inɛ waba, imbisɔ ngwi o ka di iKrestu Otsɛ. ");
INSERT INTO utr_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Onodzi kye iSimiɔn teyi ka kaka ozu okwukwo osunu Imgbasho mi iJerosalin. Mi onɔ na iJose yi iMeri kye ongwɛ iYesu ba owa kyɔ yan dafi aletɔ mgbi ola mgbi ama mina mani. ");
INSERT INTO utr_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","ISimiɔn si kye gbɛlu ongwɛ na byikɛ abɔ mgban le tsɛ Imgbasho gbɛɛ: ");
INSERT INTO utr_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","<<Otsɛ onghaangha, dafi abu mbwo ondu odzɛɛdzɛ mgbi abu nɛ, dzata ongbidɔ mgbi abu onɛnɛ no lu mi iyu. ");
INSERT INTO utr_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Lubana inɛ mgbɛn di owatɔ-watɔ mgbi abu, ");
INSERT INTO utr_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","ngwi abu kye mɛlu dzɛkɛ mi inɛ inggisɛ duu. ");
INSERT INTO utr_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Li osa nka dzɛ mbi emi agwɛsɛ odi kye okwɔkwɔ ba mbi emidabu Israi.>> ");
INSERT INTO utr_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","I kwulu iJose yi iMeri ewo mi elodzɛ ngwi iSimiɔn gbɔ mi ikpewo ongwɛ ma nɛni. ");
INSERT INTO utr_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","ISimiɔn kye mse bɛ ma ewo diyɛ nya iMeri gbɛɛ, <<Ongwɛ nɛ, Imgbasho kyon dzɛ ikye odzili-dzili bɛyi owatɔ-watɔ mgbi ibyi inggisɛ mi Israi. O dika li ambɛ ngwi inggisɛ kwuba ka fwan. ");
INSERT INTO utr_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Ikye ni ewodzɛ mgbi inggisɛ ibyibyi wa dɔ ododa. Ta okwusunkli ka suwo abu itukwu kpaa.>> ");
INSERT INTO utr_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Oyegbɔ oka kpaa nose dzɛ, ongyaa ngwu a li kwun di Anna, ongwɛ iFanue, mi agwɔ mgbi Ashɛ. O kyɛ kpakpa; o dzɛ yi oban mɛ onova egyafa ta oban si kwulu dzanta. ");
INSERT INTO utr_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","O yɛɛ owakwadɛ mɛ onova ngwusenɛ dɔn enɛ. O dzata ozu okwukwo osunu Imgbasho mi iJerosalin ba, kpaa o li sunu Imgbasho onɔ yi otu mi ondu otukwu-tukwu yi ibɔ. ");
INSERT INTO utr_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Mi obyi na yɛyɛ o kaka si ta Imgbasho angba dile gbɔdzɛ mgbi ongwɛ na nya ama ntole fɛ owatɔ-watɔ mgbi iJerosalin duu. ");
INSERT INTO utr_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Onɔ ngwi iJose yi iMeri ngyɛlu alungwɔ ngwi ola mgbi Otsɛ mina ma, a yɛ luba ogalu mgbi ama iNadzareti mi ayɛsɛ iGalalia. ");
INSERT INTO utr_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Ongwɛ na she diyɛ fyumfye; o mbwo yi ozoyeye, ikyese mgbi Imgbasho dzɛyan. ");
INSERT INTO utr_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Ali onova ama omba iYesu li kɛ iJerosalin ikye oka kyɔ oga owɛ owatɔ-watɔ mgbi emi Israi. ");
INSERT INTO utr_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Mi onɔ ngwi iYesu li onova iwyodefa ma, o si kɛ oga nɛ yi ama omban, dafi li aletɔ mgbi ama mani. ");
INSERT INTO utr_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Egbe ngwi oga wa ngyɛ nɛ a yɛ le lu udɛ, ta ongwɛ iYesu tila mi iyikpa mi iJerosalin, kpaa ama omban ye ba. ");
INSERT INTO utr_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","IJose yi iMeri tsɛwɛ gbɛɛ di iYesu kyɛ yi ama mi idzidzɛ ibyi inggisɛ, nghanɛ a kyikyɛ mi egbe olɔlɔ. Man a wita opitan mbi odo ma bɛyi oka ma. ");
INSERT INTO utr_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Dafi a din ba nɛ, a yidɔ lu iJerosalin le ka pitan. ");
INSERT INTO utr_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Mi egbe ongwu ta ma, a wa tun mi ozu okwukwo osunu Imgbasho mi iJerosalin sɔdzɛ mi idzidzɛ etsetse, le fwo ma dile byi ma ita. ");
INSERT INTO utr_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Ama nfwon duu, i kwulu ma ewo mi ozoyeye bɛyi uka mgban onuunu. ");
INSERT INTO utr_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Onɔ ngwi ama omban wa din nɛ, i kwulu ma ewo. Onɔn si byun gbɛɛ, <<Ongwani, kyɔsinɛ ngwi abu kyungwɔnɛ yi eyi ngha? Otsabu yi ani gbili abu ndɛngyɛ.>> ");
INSERT INTO utr_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","IYesu byi ma gbɛɛ, <<Kyɔsinɛ ngwi ema le pita ani? Ema ye dafi i wo gbɛɛ ani ka dzɛ mi ozu mgbi Otsani baa?>> ");
INSERT INTO utr_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Nghaduu elodzɛ ngwi o nya ma na gbosa loma ba. ");
INSERT INTO utr_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Ta iYesu wafɔ yi ama lu iNadzareti dile siikye nu ma. Onɔn kwulu elodzɛ ntonɛ duu wokɛ itukwu mbon. ");
INSERT INTO utr_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","IYesu she mi ikpewo bɛyi ozoyeye, ikyese mgbi Imgbasho dzɛyan, inggisɛ duu gbela yan. ");
INSERT INTO utr_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Mi onova ongwi iwyodeda ngwi iSidza (utɔ) iTiberu li utɔ mi iRoma mani, iPontu iPlatu li iGɔna mi ayɛsɛ iJudia, iHerude li atɔtsɛ mi ayɛsɛ iGalalia, ongwunɔn iFyilipi li atɔtsɛ mi Ituria bɛyi iTirakoni, iLisania di li atɔtsɛ mi Abilen. ");
INSERT INTO utr_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Mi onɔ ngwi Anna bɛyi iKayafa li okwukwo inggisɛ ofifɛ mgbi Imgbasho ma, elodzɛ mgbi Imgbasho ba mbi iJɔn ongwɛ iDzakaria mi okwɛsɛ. ");
INSERT INTO utr_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","O kaka ali imbe mi ewekyoo mgbi iJodan, le gbeesɔ gbɛɛ, <<Kyata mi ali ibwubwe mgbi ema nu ma kyɔ ema iBatisima ikye nu ma dzita ema yi ali ibwubwe.>> ");
INSERT INTO utr_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Dafi oyegbɔ Adzaya tsekise lɔ gbɛɛ: <<Ela mgbi inggisɛ le kwu mi okwɛsɛ gbɛɛ: <Mɛlu ofɛ ikye mgbi Otsɛ no byi yɛyɛ na, ");
INSERT INTO utr_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Ali ufɛ duu nu ma yilen tukwu, ali unggwɔ bɛyi undɔ duu nu ma kye gbobu. Ofɛ ama nkwenggengga ma nu ma kye nalu byi yɛyɛ, ofɛ ama nli ishishɛ duu ni a kye tukwulu. ");
INSERT INTO utr_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Ta inggisɛ owamyɛ duu ka di owatɔ-watɔ mgbi Imgbasho.> >> ");
INSERT INTO utr_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","IJɔn nya ibyi inggisɛ ama nba gbɛɛ no wa kyɔ ma iBatisima ma gbɛɛ, <<Ema engwɛ ogidzi ntonɛ! Li emɛ wɛ ema odzɛ gbɛɛ ni ema tsinya itingga mgbi Imgbasho, nkyɛ iyayi na? ");
INSERT INTO utr_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Nghanɛ ema kyɔ ali otso itukwu okyata-kyata mgbi ema, Ka nya ewema gbɛɛ, <Eyi li engwɛ mgbi Abrahan ta si ngyɛ ba.> Lubana n nya ema Imgbasho ka yagba kyata akwutsɛ ntonɛ yɛɛ engwɛ Abrahan gbɛ. ");
INSERT INTO utr_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Ika ladzɛ iteekwɔ le fɛɛfɛ, ali ekwɔ n wa owawa osuse ba duu, a ka kye dzɛlu ngwuta wokɛ ola.>> ");
INSERT INTO utr_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Inggisɛ ntona byun gbɛɛ, <<Ni eyi kyɔsinɛ?>> ");
INSERT INTO utr_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","IJɔn nya ma gbɛɛ, <<Inggisɛ ndzɛ yi abu nghi efa yɔ, no kye onyi nu odon, abu ndzɛ yi ungwogye yɔ gha yi inggisɛ oka.>> ");
INSERT INTO utr_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Ama ogbɛ udza ifyɛɛ kpaa ba owa kyɔ iBatisima, a byun gbɛɛ, <<Otsetse, eyi ma ni eyi kyɔsinɛ?>> ");
INSERT INTO utr_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","O nya ma gbɛɛ, <<Ka yama gbɛ awuya nyɛ obyi ba.>> ");
INSERT INTO utr_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Oblakwutsɛ angbeka kpaa byun gbɛɛ, <<Eyi ma ni eyi kyɔsinɛ?>> O nya ma gbɛɛ, <<Ka yama gbɛ inggisɛ awuya mi abumfye ba dika gbe odzɛ tukwu inggisɛ ewo mi atsika ba, udza ofya mgbi ema no gyɔlo ema.>> ");
INSERT INTO utr_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Inggisɛ ntona le fɛ yi ɛwɛ ogbebyi dile tsɛwɛ mi itukwu gbɛɛ naadi iJɔn li iKrestu, ngwu ama le fɛ ma hoo! ");
INSERT INTO utr_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","IJɔn nu ma uka gbɛɛ, <<Ani le kyɔ ema iBatisima yi eni. Nghaduu Ongwu nshewo ngha ani kyɛma, ngwu odi okpafɔ mgban kpaa ani mɛ oshɛ ba. O ka kyɔ ema iBatisima mi Onodzi Osaan mgbi Imgbasho bɛyi ola. ");
INSERT INTO utr_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Okwuga byidzɛ abɔ mgban, o ka folu ungwogyowe kye gbelu inɛnɛ osuse wokɛ oba, ashuwe yɔ o ka kye toola mi ola ngwi li gyegwu.>> ");
INSERT INTO utr_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","IJɔn kwu inggisɛ ntona ɛwɛ wo mi elodzɛ angbeka kwuba di gbɔ Esɔ Osuse nya ma. ");
INSERT INTO utr_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Dafi iJɔn fwa mi otsitsi tsɛ iHerude atɔtsɛ inɛ ikyegbɛɛ o kyelu iHerodia owa ongwunɔn iFyilipi bɛyi alungwɔ obube angbeka ngwi o tsekise kyɔ nɛ, ");
INSERT INTO utr_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","iHerude diyɛ kyɔ alobube ndatu ngha duu: O bwalu iJɔn wokɛ obawi. ");
INSERT INTO utr_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Ngwi iJɔn kyɔ ali inggisɛ duu iBatisima nɛ, o kyɔ iYesu kpaa iBatisima. Mi onɔ ngwi iYesu le bibɔ nɛta, esho kwulu, ");
INSERT INTO utr_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","man Onodzi Osaan tashulu ba mbon dafi anyama mani, ela di tɔ mi esho gbɛɛ, <<Abu li Ongwani nkpaani itukwu; i kpani yi abu saan.>> ");
INSERT INTO utr_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Onɔ ngwi iYesu li onova osudiwyo ma, o wita idɔ mgban. Ali inggisɛ tsɛwɛ gbɛɛ o li ongwɛ iJose, nli ongwɛ iHeli, ");
INSERT INTO utr_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","ongwɛ iMatati, ongwɛ iLevi, ongwɛ iMelki, ongwɛ iJenai, ongwɛ iJose, ");
INSERT INTO utr_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","ongwɛ iMatatia, ongwɛ Emosu, ongwɛ iNahun, ongwɛ Esili, ongwɛ iNaga, ");
INSERT INTO utr_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","ongwɛ iMaati, ongwɛ iMatatia, ongwɛ iSeme, ongwɛ iJoseki, ongwɛ iJoda, ");
INSERT INTO utr_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","ongwɛ iJonan, ongwɛ iResa, ongwɛ iDzerubabɛ, ongwɛ iShetiɛ, ongwɛ iNeri, ");
INSERT INTO utr_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","ongwɛ iMelki, ongwɛ Addi, ongwɛ iKosan, ongwɛ Elimanda, ongwɛ Eri, ");
INSERT INTO utr_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","ongwɛ iJoshua, ongwɛ Eliadza, ongwɛ iJorin, ongwɛ iMatati, ongwɛ iLevi, ");
INSERT INTO utr_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","ongwɛ iSimiɔn, ongwɛ iJuda, ongwɛ iJose, ongwɛ iJonan, ongwɛ Eliakin, ");
INSERT INTO utr_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","ongwɛ iMelia, ongwɛ iMena, ongwɛ iMatata, ongwɛ iNatan, ongwɛ iDevedi, ");
INSERT INTO utr_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","ongwɛ iJese, ongwɛ Obɛdi, ongwɛ iBoadzi, ongwɛ iSalmɔn, ongwɛ iNashɔn, ");
INSERT INTO utr_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","ongwɛ Aminada, ongwɛ iRan, ongwɛ iHerizɔn, ongwɛ iPeredzi, ongwɛ iJuda, ");
INSERT INTO utr_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","ongwɛ iJeko, ongwɛ Adziki, ongwɛ Abrahan, ongwɛ iTera, ongwɛ iNahɔ, ");
INSERT INTO utr_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","ongwɛ iSerɔgu, ongwɛ iReu, ongwɛ iPelegi, ongwɛ Ebɛl, ongwɛ iSala, ");
INSERT INTO utr_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","ongwɛ iKaina, ongwɛ Afadza, ongwɛ iShɛn, ongwɛ iNua, ongwɛ iLameki, ");
INSERT INTO utr_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","ongwɛ iMetusela, ongwɛ Enɔku, ongwɛ iJaredi, ongwɛ iMahalale, ongwɛ iKaina, ");
INSERT INTO utr_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","ongwɛ Enɔsh, ongwɛ iSeti, ongwɛ Adan, Ongwɛ Imgbasho. ");
INSERT INTO utr_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","IYesu mbwo yi Onodzi Osaan, o yɛ mi ekyoo mgbi iJodan, ta Onodzi kyon teyi lu okwɛsɛ, ");
INSERT INTO utr_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","mi imbe na iSatan gyilan mi egbe ngwusefa. Mi egbe ntona duu o gye unkonyi ba, ngwi egbe ntona wa nyɛ nɛ, enbwa si dɔn. ");
INSERT INTO utr_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Ta iSatan nyan gbɛɛ, <<Kini abu li Ongwɛ Imgbasho yɔ, nya ikwutsɛ nɛ no kyata yɛɛ ibredi.>> ");
INSERT INTO utr_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","IYesu nun uka gbɛɛ, <<Afɛ lɔ gbɛɛ: <Li mi ibredi ta ngwi inggisɛ ka dzɛ oshishe ba.> >> ");
INSERT INTO utr_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","ISatan di kyon lu ka dɔkɛ imbe oshigbo, o tson esutɔ mgbi ɛsɛ duu. ");
INSERT INTO utr_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Ta iSatan nyan gbɛɛ, <<N ka kye ali mfye duu nu abu bɛyi okwɔkwɔ mgbi ɛsɛ nɛni, lubana a kye mfye bɛyi okwɔkwɔ kye nu ani, ani ka yagba okye nu ali inggisɛ ngwu ani mina duu. ");
INSERT INTO utr_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Nghanɛ, kini abu sunu ani yɔ, ungwɔ ntonɛ duu ka yɛɛ mgbi abu.>> ");
INSERT INTO utr_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Kpaa iYesu nun uka gbɛɛ, <<Afɛ lɔ gbɛɛ: <Sunu Otsɛ Imgbasho mgbi abu di li ongwu ta kyɔn idɔ.> >> ");
INSERT INTO utr_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","ISatan di kye iYesu lu iJerosalin ka kyon dɔkɛ ikyikye ozu okwukwo osunu Imgbasho mi iJerosalin. O nyan gbɛɛ, <<Kini abu li Ongwɛ Imgbasho yɔ, bulu lu esɛ. ");
INSERT INTO utr_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Lubana Afɛ lɔ gbɛɛ: << <O ka wo engyesɔ mgban ola ikye abu gbɛɛ nu ma ngyo abu saan; ");
INSERT INTO utr_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","ni abu bulu le lu esɛ a ka kye gbɛlu abu mi abɔ mgbi ama ikyegbɛɛ ni abu ka kye afɔ tsɛ akwutsɛ ba.> >> ");
INSERT INTO utr_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Nghaduu iYesu nu uka gbɛɛ, <<Afɛ lɔ gbɛɛ <Ka mbadi Otsɛ Imgbasho mgbi abu ba.> >> ");
INSERT INTO utr_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Mi onɔ ngwi iSatan ngyɛlu ogyila iYesu nɛ, o lu dzanta, o nyan gbɛɛ, se egbe oka. ");
INSERT INTO utr_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","IYesu yɛ luba iGalalia mi mfye mgbi Onodzi, ta odzɛ mgban si gbɔfwɛ kpatsɛ ɛsɛ na duu. ");
INSERT INTO utr_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","O tso mi ozu okwakye mgbi emi iJuda, ali inggisɛ duu tsan. ");
INSERT INTO utr_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Ta iYesu kɛ iNadzareti imbe ngwi o she mani, o ka kaka ozu okwakye mgbi emi iJuda mi egbe otonyidɔ dafi o li tsekise kyɔ mani. O kyato dzɛkunto ogbɔ afɛ, ");
INSERT INTO utr_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","a kye afɛ ofulu-fulu mgbi oyegbɔ Adzaya kye nun. O kye nalu afɛ na, o tu imbe ngwi Afɛ lɔ gbɛɛ; ");
INSERT INTO utr_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","<<Onodzi mgbi Otsɛ dzɛ mbi ani, lubana o kye engyie Kyi ani, onu ani gbɔ Esɔ Osuse nya emi adzɛ. O dɔ ani esɔ ogbɔ otɔ-tɔ mi isɔ nya ama nwoto obawi, bɛyi onu ama nbinɛ dinɛ, onu ama ngwu a si ma, to myɛɛ-myɛɛ. ");
INSERT INTO utr_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Odi gbɔgbɛɛ onɔ gyɔ ngwi Otsɛ Imgbasho ka dulu emidan watɔ.>> ");
INSERT INTO utr_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","O si kye fulu afɛ na, yilen nu inggisɛ oyabɔ nkye nun mani, man sɔkɛ esɛ. Ta ali inggisɛ ama nwoto ozu okwakye mgbi emi iJuda na duu gbe inɛ fyakwun. ");
INSERT INTO utr_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Ta iYesu wita ogbɔdzɛ yi ama gbɛɛ, <<Inɛ nɛ, odzɛ ngwi Afɛ lɔ nɛ mbwumbwo mi adɔ mgbi ema.>> ");
INSERT INTO utr_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Ali inggisɛ duu gbɔdzɛ osuse ikpewon; i di kwulu ma ewo mi itɔ elodzɛ osuse nle tɔ mi ondu mbon nani. A si byi ewoma gbɛɛ <<Nɛnɛ li ongwɛ iJose nɛ baa?>> ");
INSERT INTO utr_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","IYesu nya ma gbɛɛ, <<Li otsitsi ema ka nya ani utsa ngha gbɛ, gbɛɛ: <Inggisɛ obwe ootse, bwe ewabu: di kyungwɔ ngwi abu le kyɔ mi iKapenahun ma mi ɛsɛ udɛ abu.> ");
INSERT INTO utr_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","<<Otsitsi ani le nya ema, oyegbɔ onyonyi kpaa a li gbela yan mi ɛsɛ udan ba. ");
INSERT INTO utr_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","I mina ani ni ema ye gbɛɛ engyaa owakwadɛ to ɛsɛ Israi kwuba mi onɔ mgbi Elaija, mi onɔ ngwi mmbwo kya ba mɛ onova eta yi ofyia egyin ngwi enbwa gbo kpatsɛ ɛsɛ duu mani. ");
INSERT INTO utr_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Nghaduukpaa Imgbasho dɔ Elaija esɔ kɛ mbi owakwadɛ onyi kpaa mi Israi ba, se li owakwadɛ mi iDzarefati mi ogalu iShidon ta. ");
INSERT INTO utr_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Emi Israi kwuba to yi otsoma mi onɔ mgbi Elaisha oyegbɔ nghaduu Imgbasho ngyɛlu inggisɛ onyi kpaa otsoma ba, se li iNama inggisɛ iSiria ta.>> ");
INSERT INTO utr_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Ngwi o gbɔdzɛ nɛ yi ama ngha nɛ, ali inggisɛ mi ozu okwakye mgbi emi iJuda na duu nyɛ yi itingga. ");
INSERT INTO utr_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Ta a kyato, a lɔn onya tasɛ mi ɛsɛ udɛ ama, a kyon tasɛ lu ikpozu udɛ le ka kyon dɔkɛ undɔ ongwi a mbɛ igeli mgbi ama mi ele mani, ikye oka tsamun ngwuta lu agblo. ");
INSERT INTO utr_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Nghaduu, o sɛ wo ma ewo lu ofɛ mgban. ");
INSERT INTO utr_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Nɛ iYesu si lu iKapenahun, igeli mi iGalalia, mi egbe otonyidɔ, ka wita otso ma. ");
INSERT INTO utr_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","I kwulu ma ewo mi otsootso mgban, ikyesinɛ esɔ mgban kyɛ yi mfye. ");
INSERT INTO utr_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Mi ozu okwakye mgbi emi iJuda na, inggisɛ oka dzɛ ele ngwu dzɛ yi esɛ ikye, onodzi obube. O teela mi ela okwukwo gbɛɛ, ");
INSERT INTO utr_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","<<Kpei! iYesu ongwi iNadzareti, li alungwɔ mina abu okyɔ yi eyi? Abu ba owa dzili eyii? Ani ye abu, abu li Ongwɛ Osaan mgbi Imgbasho.>> ");
INSERT INTO utr_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Nghaduu, iYesu kyɔkyɔ yan gbɛɛ, <<Dede, tasɛ mbon.>> Ta onodzi obube na kyon gyɛsɛ mi idzidzɛ ma, man tasɛ mbon, kpaa o yama kyɔn unkonyi ba. ");
INSERT INTO utr_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","I kwulu ma ewo, ta a sile gbɔ yi ewoma gbɛɛ, <<Nɛnɛ li ali odzɛ lo! Lubana o gbɔdzɛ mi ela mfye yi onodzi ibwubwe ta a fwon diyɛ tasɛ.>> ");
INSERT INTO utr_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Man odzɛ mgban si gbɔfwɛ kpatsɛ ɛsɛ na bɛyi ɛsɛ ama nto yi ama kwɛkwɛ duu. ");
INSERT INTO utr_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","O si kyato mi ozu okwakye mgbi emi iJuda, lu udɛ iSaimɔn, onɔ na awo bwa onowa iSaimɔn ladzɛ esɛ le tsaatsa, nɛ a nya iYesu gbɛɛ no yan abɔ. ");
INSERT INTO utr_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Ta iYesu si kɛ ka klɛsɛ mbon, o kyɔkyɔ yi awo na, man i tɔ dzanta. Onowa iSaimɔn si kyato wita gbe ungwogye le nu ma. ");
INSERT INTO utr_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Mi onɔnɔdɛ, a gbe emi ootse idzidza-dzidza ba mbi iYesu, ta o kye abɔ gbo ali inggisɛ ewo, man ootse ngyɛ loma. ");
INSERT INTO utr_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Enedzi ibwubwe kpaa tɔ mbi inggisɛ kwuba le kwu ela gbɛɛ, <<Abu li Ongwɛ Imgbasho.>> Nghaduu o kwo ma adɔ di nu ma ofɛ ogbɔdzɛ ba ikyesinɛ, a ye dafi o li iKrestu mani. ");
INSERT INTO utr_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Ngwi egbe fa nɛ, iYesu tasɛ lu imbe ngwi inggisɛ dzɛ ele ba; ibyi inggisɛ tɔ tole pitan, ngwi a wa to mbon nɛ, i mina ma omben onɔ, ikyegbɛɛ no ka lu dzata ma ba. ");
INSERT INTO utr_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Nghaduu iYesu nya ma gbɛɛ, <<Li kyɛmɛ ngwi ani ka gbɔ Esɔ Osuse mgbi esutɔ mgbi Imgbasho nɛ mi igeli angbeka kpaa, lubana li itɔdzɛ nɛ ngwi Imgbasho dɔ ani esɔ ba mmɛnɛ aani.>> ");
INSERT INTO utr_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","O sile gbɔ Esɔ mi emi ozu okwakye mgbi emi iJuda kpatsɛ iJudia. ");
INSERT INTO utr_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Egbe oka nɛ, iYesu kwulɛsɛ dzɛ ewuutɔ mgbi iGenesareti, ibyi inggisɛ kpakɛkɛ won tole fwo odzɛ Imgbasho. ");
INSERT INTO utr_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Nɛ o ndinɛ ka gbo yi uwaa nghi efa bɛto onduutɔ kpaa ama otuntsɛ woto ele ba, a tasɛ le sa ukɛ mgbi ama. ");
INSERT INTO utr_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","O kaka uwaa oka ongwi li mgbi iSaimɔn, man nyan gbɛɛ no tsamu uwaa kaka eni gwee, ta o sɔkɛ esɛ mi uwaa si tso ma ungwɔ. ");
INSERT INTO utr_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Onɔ ngwi o ngyɛlu ogbɔdzɛ yi ama nɛ, o nya iSaimɔn gbɛɛ, <<Gblekɛ ole, ka wo ukɛ ni ema kwu mmbwɛ.>> ");
INSERT INTO utr_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","ISaimɔn nun uka gbɛɛ, <<Ongyukwo, eyi kwo ukɛ mi otu nghataa ni egbe fa mi adzɛ kpakpa, kpaa eyi kwu oshagye ba; kpaa li abu gbɔ mayɔ n ka kye wo.>> ");
INSERT INTO utr_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Ngwi a kyɔ dafi iYesu nya ma nɛ, a kwu mmbwɛ kpakpa, man ukɛ mgbi ama wita ofawa. ");
INSERT INTO utr_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Nɛ a flɛ ama otuntsɛ angbeka ama nwoto uwaa oka ntona abɔ gbɛɛ nu ma wa ya ma abɔ, nɛ a si kwu mmbwɛ mbwo uwaa efa ntona kyɛɛ dile fya osulu-sulu. ");
INSERT INTO utr_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Ngwi iSaimɔn iPyita di ungwɔnɛ nghanɛ, o ka kye akwafɔ kwokɛ esɛ mi iyayi mgbi iYesu, o nyan gbɛɛ, <<Lu dzɛ ani ta, Otsɛ, lubana ani li inggisɛ alobube.>> ");
INSERT INTO utr_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Ikyekyɛ ongwu bɛyi ama nto yan duu i kwulu ma ewo mi itɔ mmbwɛ ngwi ama kwu kwuba nani. ");
INSERT INTO utr_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Li ngha ngwi iJɛnsi bɛyi iJɔn emi ongwɛ iDzebedi ama nle tuntsɛ yi iSaimɔn na kpaa i kwulu ma ewo aali. Nghaduu, iYesu nya iSaimɔn gbɛɛ, <<Ka mio ba, wita mi onɛnɛ lu iyayi ka li inggisɛ ngwi ema kale kwu.>> ");
INSERT INTO utr_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Ta a kye kwolu uwaa mgbi ama dɔkɛ esɛ, a dzata alungwɔ duu kyɛdɔn. ");
INSERT INTO utr_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Dafi iYesu dzɛ mi igeli oka nɛ, inggisɛ oka ba mbon ongwu otsoma gban ewo sɔ. Ngwi o di iYesu nɛ, o lakɛ esɛ kye inɛ tukwu esɛ, tɛkyɛ nun gbɛɛ, <<Otsɛ, ni abu ki gbela, o ka yagba nu ani yɛɛ saan.>> ");
INSERT INTO utr_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","IYesu na abɔ gbon ewo nyan gbɛɛ, <<Ani gbela, yɛɛ saan!>> Mi onɔ na ta otsoma ngyɛ lon. ");
INSERT INTO utr_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Nɛ iYesu kwon adɔ gbɛɛ, <<Ka ka gbɔ nya inggisɛ ba, kpaa kye ewabu lu ka tso inggisɛ ofifɛ mgbi Imgbasho di nu umba dafi iMose woola mani, mi oyɛɛ saan mgbi abu, zukwu no yɛɛ obwɛndɛ mbo ma.>> ");
INSERT INTO utr_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Nghaduu odzɛ mgban nghao le gbɔfwɛ-gbɔfwɛ, ta ibyi inggisɛ nghao le ba ikye ofwon di non ngyɛlu ma ootse. ");
INSERT INTO utr_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Kpaa iYesu li lu ka dzɛkɛ imbe ndede le bibɔ. ");
INSERT INTO utr_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Egbe oka nɛ, iYesu le tsungwɔ nɛta, emi iFarasi bɛyi etsetse mgbi ola mgbi iMose, ama nkyɛ mi ali udɛ mi iGalalia, mi iJudia bɛyi iJerosalin duu sɔto ele, mfye mgbi Otsɛ Imgbasho kpaa dzɛyan ikye onon ongyɛlu ma ootse. ");
INSERT INTO utr_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Inggisɛ angbeka si kye inggisɛ ngwu alewo mgban kwulu mi amuku, a fya okyon kaka ozu okyon lakiyayi iYesu. ");
INSERT INTO utr_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Kpaa dafi a tu ofɛ okyɔ ngha ba ikye ibyi inggisɛ nɛ, a lu ka tɔkɛ ikpendu, kyon nyɛ ikpendu mi amuku nyɛ idzidzɛ ibyi inggisɛ nghataa lu iyayi iYesu. ");
INSERT INTO utr_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Dafi iYesu di oyɛyɛ onuunu mgbi ama nghanɛ, o gbɛɛ, <<Uka, a kye ali ibwubwe mgbi abu ta abu mkpa.>> ");
INSERT INTO utr_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Ta emi iFarasi bɛyi etsetse mgbi ola, wita otsɛwodzɛ gbɛɛ, <<O tsɛwɛ gbɛɛ ongwu li ali inggisɛ? Odzɛ na li ito! Li Imgbasho yuon ka dzata inggisɛ yi obube!>> ");
INSERT INTO utr_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Nghaduu ngwi iYesu ye ewodzɛ mgbi ama nɛ, o byi ma gbɛɛ, <<Li ali ewodzɛ ngwi ema le tsɛ mi itukwu mgbi ema da? ");
INSERT INTO utr_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Li ekyɛ nghao li adzɛ ba: Li ogbɛɛ, a dzita abu yi ali ibwubwe mgbi abu naadi li ogbɛɛ: <Kyato kyikyɛ?> ");
INSERT INTO utr_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Kpaa li ikye onu ema ye gbɛɛ Ongwɛ Inggisɛ dzɛ yi mfye mi ɛsɛ nɛ odzɛ inggisɛ ta yi ali ibwubwe...>> O gbɔ yi inggisɛ ngwu alewo mgban kwulu na gbɛɛ, <<Ani le nya abu kyato, kyelu amuku mgbi abu lu udɛ.>> ");
INSERT INTO utr_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Labɔlabɔ mata, inggisɛ ngwu alewo mgban kwulu na kyato dzɛkunto mi inɛ mgbi ama, o kyi kyelu amuku mgban ongwi a kyon wele ba ma lu udɛ le tsɛ Imgbasho. ");
INSERT INTO utr_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Ali inggisɛ duu ewo waa loma, a si tsɛ Imgbasho. Imio wo ma nɛta a gbɛɛ <<Eyi di ungwɔ ama okwulewo inɛ.>> ");
INSERT INTO utr_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Ngwi iYesu ngyɛ nɛ, o tasɛ ta o di inggisɛ ogbɛ udza ifyɛɛ ngwu a li kwun di iLevi sɔdzɛ mi ozu ogbɛ udza ifyɛɛ. O si nyan gbɛɛ, <<Kyɛdɔ ani.>> ");
INSERT INTO utr_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Man iLevi kyato dzata alungwɔ duu kyɛdɔn. ");
INSERT INTO utr_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Nɛ iLevi kyɔn oga okwukwo mi udɛ mgban, ama ogbɛ udza ifyɛɛ kwuba bɛyi angbeka kpaa le gye ungwogye yi ama. ");
INSERT INTO utr_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Kpaa emi iFarasi bɛyi emidi ama, ama otso ola mgbi iMose le ndaandu, le byi engwafɔ mgbi iYesu gbɛɛ, <<Kyɔnɛ ngwi ema le gye ungwogye dile wa yi ama ogbɛ udza ifyɛɛ bɛyi emi ali ibwubwe?>> ");
INSERT INTO utr_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","IYesu nu ma uka gbɛɛ, <<Li inggisɛ ama ndzɛ saan li le pita inggisɛ obwotse ba, kpaa li inggisɛ ama ndotse. ");
INSERT INTO utr_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Ani ba ikye owa kwu ama osaan ela ba, kpaa li ama nle saan ba mani, ikye nu ma kyatitukwu.>> ");
INSERT INTO utr_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","A gbɔ yi iYesu gbɛɛ, <<Engwafɔ mgbi iJɔn li tukwondu dile bibɔ alonɔ duu, engwafɔ mgbi emi iFarasi kpaa, nghaduu emidabu le gye di wa alonɔ duu.>> ");
INSERT INTO utr_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","IYesu nya ma gbɛɛ, <<Ema ka yagba osi ama nbato oga ongyaa ofufɛ gbɛɛ nu ma tukwondu mi onɔ ngwi ongyaa ofufɛ ka dzɛ yi ama na gbɛɛ? ");
INSERT INTO utr_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Nghaduu egbe kyɛma ngwi a ka kyi kyelu obongyaa ofufɛ, ta mi egbe ntona, ama kpaa ka tukwondu.>> ");
INSERT INTO utr_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","O diyɛ nya ma utsa gbɛɛ, <<Inggisɛ onyi kpaa ka mwadzɛ angwuto ofufɛ kye tukwukɛ angwuto ogbugbe ba. Ki non kyɔ ngha, o ka fawa angwuto ofufɛ na ta ba, ayɛ angwuto ofufɛ na dika kwokyi yi ogbugbe na ba. ");
INSERT INTO utr_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Inggisɛ onyi kpaa ka kye eneekwɔ ofufɛ yaokɛ ikpɔkpɔ ogbugbe ba. Ki non kyɔ ngha yɔ, eneekwɔ ofufɛ na ka kye gbobu ikpɔkpɔ nani, eneekwɔ na kpaa ka yangwuta nyanya bɛyi ikpɔkpɔ na duu. ");
INSERT INTO utr_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Kpaa a li kye eneekwɔ ofufɛ yaokɛ ikpɔkpɔ ofufɛ. ");
INSERT INTO utr_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Inggisɛ onyi nle wa eneekwɔ ogbugbe se ngwi ofufɛ ka minan dzɛma ba, o ka gbɛɛ: <Ogbugbe nghao tishi.> >> ");
INSERT INTO utr_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Mi egbe otonyidɔ oka nɛ, emi iYesu le kyikyɛ nyɛ ifu okwɔ ekwu, ta engwafɔɔn le shɛ ekwu, ngwunu mi atabɔ le bukwu. ");
INSERT INTO utr_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Kpaa emi iFarasi angbeka byi ma gbɛɛ, <<Kyɔsinɛ ngwi ema le kyungwɔ nli ola ba mi egbe otonyidɔ ngha?>> ");
INSERT INTO utr_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","IYesu nu ma uka gbɛɛ, <<Ema gbɔ ungwɔ ngwi utɔ iDevedi kyɔ mi onɔ ngwi ongwu bɛyi emi ibuge mgban ngwi enbwa dɔ ma na ye wa lo? ");
INSERT INTO utr_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","O ka kaka ozu Imgbasho, kyi kyelu ibredi ongwi a kye dɔ Imgbasho ubɔ, kye gye di kye nu ama nkyɛ yan ma duu. Ongwi ola gbɛɛ se li inggisɛ ama ofifɛ mgbi Imgbasho ta ka gye mani.>> ");
INSERT INTO utr_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Nɛ iYesu nya ma gbɛɛ, <<Ongwɛ Inggisɛ li Otsɛ mgbi egbe otonyidɔ.>> ");
INSERT INTO utr_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Mi egbe otonyidɔ oka nɛ, iYesu kaka ozu okwakye mgbi emi iJuda le tso, nɛ inggisɛ oka wodzɛ ele ongwu abɔ abugye mgban waawaa. ");
INSERT INTO utr_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Emi iFarasi bɛyi etsetse mgbi ola gbe inɛ fyakwun ikye nu ma di ni o ka bwe inggisɛ na mi egbe otonyidɔ yɔ, ni ama tu itɔdzɛ okye abɔ byi ele kwun elikwɔ. ");
INSERT INTO utr_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Nghaduu iYesu ye ewodzɛ mgbi ama otsɛɛtsɛ man o si nya inggisɛ owaa abɔ na gbɛɛ, <<Kyato wa dzɛkɛ mi iyayi mgbi ali inggisɛ duu.>> Ta o kyato wa kwulɛsɛ dzɛkɛ. ");
INSERT INTO utr_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Nghanɛ iYesu nya ma gbɛɛ, <<Ani le byi ema ita, li ole li ola mgbi eyi ngwi li ayin okyɔɔkyɔ mi egbe otonyidɔ: li okyɔ osuse naadi li okyɔ obube, li odulu oshishe naadi li odzili oshishe?>> ");
INSERT INTO utr_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","IYesu ndinɛ di ma kpatsɛ si nya inggisɛ owaa abɔ na gbɛɛ, <<Na abɔ mgbi abu.>> O si kyɔ ngha, ta abɔ mgban yɛɛ saan. ");
INSERT INTO utr_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Nghaduu itukwu fu loma a si wita ogbɔ yi ewoma ungwɔ ngwi ama ka kyɔ yi iYesu mani. ");
INSERT INTO utr_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Egbe oka nose nɛ iYesu tasɛ lu unggwɔ le ka bibɔ, o kye otu na duu bibɔ mbi Imgbasho. ");
INSERT INTO utr_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Ngwi egbe wa fa nɛ, o kwu ama nkyɛdɔn duu ela takye man, o sadu engyulɔ iwyodefa, o kwu ma gbɛɛ, <<Ama ogbikye ani.>> ");
INSERT INTO utr_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","ISaimɔn ongwu o kyɔn iyi oka gbɛɛ iPyita, bɛyi ongwunɔn Andru, yi iJɛnsi, yi iJɔn, yi iFyilipi, yi iBatlomi, ");
INSERT INTO utr_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","yi iMatiu, yi iTɔmɔsu, yi iJɛnsi ongwɛ Alfeɔ, yi iSaimɔn ongwu a kwun gbɛɛ Ogbodami, ");
INSERT INTO utr_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","yi iJuda ongwɛ iJɛnsi bɛyi iJuda Iskarɔti ongwu n wa yɛɛ inggisɛ okyon gya nani. ");
INSERT INTO utr_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Nɛta emi iYesu tashulu mi unggwɔ wa kwulɛsɛ mi imbe ogblagadaa. Ama okyɛdɔn kwuto ele bɛyi ibyi inggisɛ mi ali ayɛ iJudia, iJerosalin yi ewekyoo mgbi iTiru bɛyi iSidon duu. ");
INSERT INTO utr_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","A ba ikye owa fwon, no di ngyɛlu ma ootse. Ama ngwu onodzi ibwubwe kaka ma ewo duu o ngyɛlu ma ele. ");
INSERT INTO utr_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Ta inggisɛ ibyibyi le nana okye abɔ gbon, lubana ama nkye abɔ gbon duu mfye tɔ mbon ngyɛlu ma ootse. ");
INSERT INTO utr_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","IYesu kye inɛ byi ama okyɛdɔn, o nya ma gbɛɛ: <<No kpa ema ewo ema emi adzɛ, lubana esutɔ mgbi Imgbasho dzɛ ikye ema. ");
INSERT INTO utr_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","No kpa ema ewo ema ngwu enbwa le dɔ ema onɛnɛni, lubana ema ka wa tolo. No kpa ema ewo ema ama nle tsukwu onɛnɛni, lubana ema ka wa shisha. ");
INSERT INTO utr_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","No kpa ema ewo mi onɔ ngwi inggisɛ di ema kyili, nu ma di kye ema wuuta ba di fya ema ito, di fwa ema gbɛɛ ema li emi ibwubwe mi ikye mgbi Ongwɛ Inggisɛ. ");
INSERT INTO utr_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","<<Dzɛ yi atsa mi egbe nani di shufwe yi atsa, ikyesinɛ umba mgbi ema shewo mi esho. Lubana li ngha ngwi emi otsikyɔ ma kyɔ yi ama ogbɛɛsɛ aali. ");
INSERT INTO utr_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","<<Kpaa ahoo mbi ema ama nli aludu, Lubana ema tu omyɛɛ-myɛɛ mgbi ema wa. ");
INSERT INTO utr_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Odzɛ ka tu ema, ema ama ntolo onɛnɛni, Lubana enbwa ka wa dɔ ema. Ahoo mi ikye ema ama nle shisha onɛnɛni, ema ka wa buntse diyɛ tsukwu. ");
INSERT INTO utr_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Odzɛ ka tu ema, ema ngwu ali inggisɛ li le gbɔdzɛ osuse ikpewo ema, lubana li ngha ngwi emi otsikyɔ ma kyɔ yi oyegbɔ emi atsika aali. ");
INSERT INTO utr_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","<<Nghaduu ani le nya ema ama ntole fwo ani nɛ gbɛɛ: Engyikyili mgbi ema nu ma kpa ema itukwu, kyɔ osuse yi ama ndi ema taanyi, ");
INSERT INTO utr_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","kyumse yi ama nfya ema ito di bibɔ ikye ama nkyɔ yi ema timbi-timbi. ");
INSERT INTO utr_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Kini inggisɛ ta abu afɛ mi atadɔ agya oka yɔ, kyata agya oka na kpaa nun. Kini inggisɛ kye gbɛlu abu angwuto owoowo ongwi ifun yɔ, ka kwɔ otsungwɔn okye gbɛlu abu angwuto ongwi esɛ ba. ");
INSERT INTO utr_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Ali inggisɛ nbɔ abu ungwɔ duu, ka kwɔ otsungwɔn ba, ni inggisɛ di gbɛ ungwɔ mbi abu ka kwun mkpa gbɛɛ no yilen wa nu abu ba. ");
INSERT INTO utr_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Kyɔ yi angbeka dafi i mina ema gbɛɛ ni a kyɔ yi ema mani. ");
INSERT INTO utr_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","<<Kini abu kyɔ okpitukwu yi ama nkpa abu itukwu ta ma, li ali oyabɔ ngwi abu ka tu? Lubana li ngha ngwi emi ali ibwubwe kpaa li di ama ngwu ama kpa ma itukwu ma, kpa ma itukwu aali. ");
INSERT INTO utr_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ni abu di kyɔ osuse yi ama nli kyɔ osuse yi abu ta ma, li ali oyabɔ ngwi abu ka tu? Lubana li ngha ngwi emi ali ibwubwe kpaa li kyɔ aali. ");
INSERT INTO utr_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Kini ema gha ama ngwu ema ye gbɛɛ a ka yilen kpa ema ta umba ma, li ali oyabɔ ngwi ema ka tu? Lubana li ngha ngwi emi ali ibwubwe kpaa li kye nu ama ngwu a ye gbɛɛ a ka yilen kpa ma kyɛɛ ma aali. ");
INSERT INTO utr_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Nghaduu, engyikyili mgbi ema nu ma kpa ema itukwu, kyɔ osuse yi ama, di kye nu ma gbɛɛ nu ma ka yilen kpa ema ba. Ta umba mgbi ema kale gbagbadzidzi, ema dika li engwɛ mgbi Ongwu Nghaangha mi Esho, lubana o li kyɔ osuse yi ama ungwɔ li mɛ ma inɛ ba yi emi imbali. ");
INSERT INTO utr_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Dzɛ yi elela odiidi dafi Otsema kpaa li di elela nɛni. ");
INSERT INTO utr_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","<<Ka gbiikwɔ ba, ta ema kpaa a ka gbɔ ema ikwɔ ba. Ka ngwɔ inggisɛ ikwɔ ba ta ema kpaa a ka ngwɔ ema ikwɔ ba. Dzita inggisɛ yi obube, ta ema kpaa a ka dzita ema yi obube mgbi ema. ");
INSERT INTO utr_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Nu, ta ema kpaa Imgbasho ka yilen nu ema. Ombaamba osuse, ongwi a siin, ngwi a kwonwo saan, ngwi di mbwo le yangwuta, Imgbasho ka kye nu ema; ikyesinɛ li ombaamba ngwi ema mba ma, ngwi Imgbasho ka yilen mba nu ema aali.>> ");
INSERT INTO utr_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","IYesu diyɛ nya ma utsa gbɛɛ, <<Inggisɛ obinɛ ka kye obinɛ oka teyi gbɛɛ? Ama efa duu a ka gbɛsɛ wokɛ ishɛ baa? ");
INSERT INTO utr_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Inggisɛ okpayi-kpayi ka ye ngha otsetse mgban ba, kpaa ali inggisɛ ngwu a tson saan ka dzɛ dafi otsetse mgban mani. ");
INSERT INTO utr_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","<<Kyɔsinɛ ngwi abu li di ɛfɛ nwodzɛ inɛ mbi ongwunabu kpaa li difwi otsokplekwɔ nwodzɛ inɛ mgbi abu na ba? ");
INSERT INTO utr_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Ka kyɔsinɛ abu ka nya ongwunabu gbɛɛ: <Ongwunani detse nin dulu abu ɛfɛ mi inɛ, ngwi otsokplekwɔ wodzɛ inɛ mbi abu?> Abu inggisɛ ikpala nɛ, tsekise dulu otsokplekwɔ nwodzɛ inɛ mbi abu na duuse o ka dinɛ saan odulu ɛfɛ nwodzɛ inɛ mbi ongwunabu nani. ");
INSERT INTO utr_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","<<Ekwɔ osuse li wa owawa obube ba, hona ekwɔ obube li wa owawa osuse ba. ");
INSERT INTO utr_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Ali ekwɔ duu a li difwin mi owawa mgban, inggisɛ li shɛ andundu mi ato ba, naadi a li shɛ owawa ekwɔ mi afwe ba. ");
INSERT INTO utr_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Inggisɛ osuse li dulu ungwɔ osuse ama ngwi o kye da mi itukwu mgban, inggisɛ ibwubwe li dulu ungwɔ ibwubwe ama ngwi o kye da mi itukwu mgban, lubana dafi i mbwon itukwu ma ngwi ondu li gbɔ tɔ aali. ");
INSERT INTO utr_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","<<Kyɔsinɛse ngwi ema li kwu ani gbɛɛ, <Otsɛ, Otsɛ> kpaa li kyungwɔ ngwi ani gbɔ ba? ");
INSERT INTO utr_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Ani ka tso ema dafi inggisɛ nba mbi ani wa fwo elodzɛ mgbi ani diyɛ kyɔ mi ele dzɛ mani. ");
INSERT INTO utr_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","O dzɛ dafi inggisɛ nle mbɛ ozu, o plɛ tishɛ kɛ di wo itozu mi akwutsɛ. Mi onɔ ngwi ekyoo taayɔ, akpeni wa tsɛkɛ ele kpaa i kyɔn unkaba, ikyesinɛ a mban saan. ");
INSERT INTO utr_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Nghaduu inggisɛ nfwo elodzɛ mgbi ani diyɛ kyɔ mi ele ba, o dzɛ dafi inggisɛ nmbɛ ozu mgban mi ikye mfyan wo itozu ba mani. Onɔ ngwi akpeni okwukwo wa tsɛkɛ ele nɛ, ozu na gbobu tukwu esɛ gbluu!>> ");
INSERT INTO utr_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Dafi iYesu ngyɛlu odzɛ ogbɔɔgbɔ yi ibyi inggisɛ tsatsadu nɛ, o si kaka iKapenahun. ");
INSERT INTO utr_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Mi igeli na, ongbidɔ mgbi ongyukwo oblakwutsɛ oka ngwu kpan itukwu saan dotse dzɛ kwɛkwɛ okwulu-kwulu. ");
INSERT INTO utr_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Ongyukwo oblakwutsɛ mgbi emi iRoma nɛ si fwo odzɛ mgbi iYesu, o dɔ engyukwo emi iJuda angbeka esɔ gbɛɛ nu ma ka nyan no ba wa ngyɛlu ongbidɔ mgbi ongwu ootse. ");
INSERT INTO utr_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Nɛ a ka tɛkyɛ nu iYesu gbɛɛ, <<Inggisɛ nɛ mina abɔ oyaaya mbi abu kyɛmɛ-kyɛmɛ. ");
INSERT INTO utr_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Ikyekyɛ ɛsɛ mgbi eyi kpan itukwu, o di mbɛ eyi ozu okwakye.>> ");
INSERT INTO utr_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Nɛ iYesu si wafɔ yi ama. Dafi iYesu dzɛ kwɛkwɛ okaka udɛ nɛ, ongyukwo oblakwutsɛ mgbi emi iRoma na dɔ emi okan angbeka esɔ nu ma ka nyan gbɛɛ, <<Otsɛ, ka nu ewabu okakewo wuba, ikyena ani mɛ ongwu abu ka ba onufozu mgbi ani ba. ");
INSERT INTO utr_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Ani mɛ okɛ mbi abu ba. Nghanɛ gbɔ elodzɛ ta ootse mgbi ongbidɔ mgbi ani ka ngyɛ. ");
INSERT INTO utr_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Ikyena ani abuen kpaa n li inggisɛ nbyidzɛ abɔ mfye, yi emi oblakwutsɛ mi abɔ ani, ni ani nya ongwunɛ gbɛɛ, <Lu,> o li lu. N di li gbɔ yi oka gbɛɛ, <Kwa> o di li ba. N di li nya ongbɛ mgbɛn gbɛɛ, <Kyungwɔnɛni,> o di li kyɔ ngha.>> ");
INSERT INTO utr_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Ngwi iYesu fwo odzɛ nɛ nghanɛ, i kwulun ewo yan, o kyata inɛ mbi ibyi ama nkyan iyikpa ma si gbɛɛ, <<N nya ema, n tu itɔ oyɛyɛ onuunu nshewo itɔ nɛ ye ba, kwo mbi emi Israi kpaa.>> ");
INSERT INTO utr_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Engyesɔ ntona yɛ lu udɛ ka tu ongbidɔ na yɛɛ saan. ");
INSERT INTO utr_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Ngwi i wa nyɛ nɛta iYesu wafɔ yi engwafɔɔn bɛyi ibyi inggisɛ le lu mi igeli ngwi a li kwun di iNai. ");
INSERT INTO utr_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Dafi a dzɛ kwɛkwɛ okaka onufɛ ogalu nɛ, a kye ikwɔ tɔ le kɛ ongwu nli ongwɛ onyi kpokpo mgbi owakwadɛ. Nghanɛ ibyi inggisɛ mi ogalu na wafɔ yan. ");
INSERT INTO utr_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Ngwi Otsɛ iYesu din nɛ, elela kyɔn won, o si gbɛɛ, <<Ka tsukwu ba.>> ");
INSERT INTO utr_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Nɛ iYesu kɛ kwɛkwɛ kye abɔ gbo ogba, ama nsisi ntona kwulɛsɛ. O gbɛɛ, <<Ongwongyulɔ, kyato.>> ");
INSERT INTO utr_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Nɛta inggisɛ ikwukwɔ ma si kyato sɔ nto wita ogbɔdzɛ, iYesu yilen nu onɔn. ");
INSERT INTO utr_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Ama duu imio wo ma man a le tsɛ Imgbasho. A gbɛɛ, <<Oyegbɔ okwukwo tɔ mi idzidzɛ mgbi eyi: Imgbasho ba owa ya emidan abɔ.>> ");
INSERT INTO utr_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Odzɛ mgbi iYesu si gbɔfwɛ kpatsɛ iJudia bɛyi ɛsɛ angbeka ama nwo otsee dɔ ma duu. ");
INSERT INTO utr_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Engwafɔ mgbi iJɔn nyan ungwɔ ama ngwi iYesu kyɔ duu, o kwu efa ela, ");
INSERT INTO utr_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","o dɔ ma esɔ gbɛɛ nu ma kɛ ka byi Otsɛ iYesu gbɛɛ, <<Li abu li ongwu iJɔn gbɔgbɛɛ o kyɛma le ba ma, naadi ni eyi gbe inɛ byi inggisɛ oka idzidza?>> ");
INSERT INTO utr_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Mi onɔ ngwi emi esɔ ntona ba mbi iYesu nɛ, a gbɛɛ, <<IJɔn okyɔ iBatisima dɔ eyi esɔ mbi abu gbɛɛ ni eyi wa byita gbɛɛ: <Abu li ongwu nkyɛ ka ba ma naadi ni eyi gbe inɛ byi inggisɛ oka?> >> ");
INSERT INTO utr_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Mi onɔ na iYesu ngyɛlu ibyi inggisɛ ootse idzidza-dzidza, bɛyi onodzi ibwubwe, di nu ama nbinɛ dinɛ. ");
INSERT INTO utr_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","O si nu emi esɔ ntona uka gbɛɛ, <<Yidɔ lu ka nya iJɔn ungwɔ ngwi ema di diyɛ fwo: Ama nbinɛ yɛ le di, ama ngwu afɔ waawaa le kyikyɛ, ama ndɔ otsoma, otsoma mgbi ama ngyɛ, ama nkyadɔ le fwo, ama nkwulu le kyato mi ikwu, a le gbɔ Esɔ Osuse nya emi adzɛ. ");
INSERT INTO utr_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Imgbasho ka kye mse dzɛ yi ali inggisɛ nfwa ani ba mi ungwɔ ama ani kyɔ mani.>> ");
INSERT INTO utr_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Onɔ ngwi emi esɔ mgbi iJɔn lu nɛ, iYesu wita ogbɔdzɛ yi ibyi inggisɛ mi odzɛ mgbi iJɔn gbɛɛ: <<Li alungwɔ ngwi ema kɛ okwɛsɛ le ka di? Li atakwu ngwi awo le fan ntonaa? ");
INSERT INTO utr_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Ki no li ngha ba ma, li alungwɔ ngwi ema kɛ le ka di? Li ongyulɔ nwo angwuto osusee? Ama nwo angwuto ofyunfyummya bɛyi ama ogye ɛsɛ a li to udɛ utɔ. ");
INSERT INTO utr_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Wanɛ li alungwɔ ngwi ema tasɛ le ka di? Li oyegbɔɔ? Ɛɛn, ani le nya ema, o ngha oyegbɔ. ");
INSERT INTO utr_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Nɛnɛ li ongwu a lɔ ungwɔ ikyen gbɛɛ: << <Dii, ani ka dɔ ongyesɔ mgbi ani no teyi abu, ongwu nka teyi ka mɛ abu ofɛ mani.> ");
INSERT INTO utr_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Ani le nya ema, inggisɛ ngwu ongyaa mba ma duu, onyi kpaa dzɛma nshewo ngha iJɔn ba; Nghaduu inggisɛ nli olɛlɛ mi esutɔ mgbi Imgbasho shewo nghan.>> ");
INSERT INTO utr_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","(Ali inggisɛ bɛyi ama ogbɛ udza ifyɛɛ ngwu fwon duu, gbela Imgbasho, lubana iJɔn tsekise kyɔ ma iBatisima. ");
INSERT INTO utr_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Kpaa emi iFarasi bɛyi ama oye ola fwa oweka mgbi Imgbasho mi ikye mgbi ama, ikyesinɛ a fwa onu iJɔn kyɔ ma iBatisima.) ");
INSERT INTO utr_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","<<Ma li alungwɔ ngwi ani ka kye inggisɛ emi etɔ nɛ mba yan? A to sinɛ? ");
INSERT INTO utr_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","A to dafi ɛngbɛ ama nto ifyidu le kwu ewoma ela gbɛɛ: <<Eyi gbla ema ozuna, kpaa ema shufwe ba, Eyi shashi ibɔ, kpaa ema tsukwu ba! ");
INSERT INTO utr_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Lubana iJɔn okyɔ iBatisima ba, o li gye ungwogye ba, di li wa eneekwɔ ba; ema gbɛɛ: <Esɛ dɔn ikye.> ");
INSERT INTO utr_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Ongwɛ Inggisɛ ba le gye diyɛ wa, kpaa ema li gbɛɛ: <Dii, o li inggisɛ okyɔ nggwɔ yi inggisɛ ofya ɛbyɛ di li oka ama ogbɛ udza ifyɛɛ bɛyi emi ali ibwubwe.> ");
INSERT INTO utr_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Nghaduu ozoyeye li tso otsitsi tɔ mbi ama nkyɛdɔn mani.>> ");
INSERT INTO utr_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Inggisɛ iFarasi oka bɔ iYesu ungwogye ongwi onɔdɛ mi udɛ mgban, o ka sɔkɛ imbe ogye ungwogye. ");
INSERT INTO utr_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Onɔ ngwi ongyaa owagbai ngwu dzɛ igeli na, ka fwo dafi iYesu le gye ungwogye mi ozu mgbi inggisɛ iFarasi nɛ, o kye ikpɔkpɔ alabasta mgbi engyie ogbungbɛ, ");
INSERT INTO utr_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","wa kwulɛsɛ mi iyikpa iYesu le tsukwu kye etse kyin afɔ. Di kyi fwɔlu yi otu mgban, o kye ondu le kwon afɔ diyɛ kye engyie ogbungbɛ yawon afɔ. ");
INSERT INTO utr_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Ngwi inggisɛ iFarasi ngwu bɔɔn ungwogye na di nghanɛ, o gbɔ yi ewon gbɛɛ: <<Inggisɛ nɛ ki li oyegbɔ yɔ, o ki ye itɔ ongyaa nkye abɔ le gbon ewo nɛ bɛyi iyi obube ngwi o dzɛyan nɛni.>> ");
INSERT INTO utr_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Ta iYesu nyan gbɛɛ, <<iSaimɔn, ani dzɛ yi odzɛ ngwi n ka gbɔ yi abu.>> O gbɛɛ, <<Gbɔka otsetse!>> ");
INSERT INTO utr_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","<<Inggisɛ onu mkpa oka dzɛ yi ama ngban mkpa nghi efa: Oka dzɛyan isule ideli eda, oka ma li isule ngwusefa dɔn iwyo. ");
INSERT INTO utr_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Ama efa duu yagba okpaakpa ba, ta o dzɛ ma ta. Li emɛ ngwu inggisɛ onu mkpa na ka nghao kpan itukwu?>> ");
INSERT INTO utr_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","ISaimɔn nun uka gbɛɛ, <<N tsɛwɛ gbɛɛ, li ongwu o dzanta yi mkpa kwuba nani.>> IYesu gbɛɛ, <<O gbɔ ayin.>> ");
INSERT INTO utr_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","O si kyata inɛ kɛ mbi ongyaa na nya iSaimɔn gbɛɛ, <<Abu di ongyaa nɛ wɛ? Ani ba udɛ abu kpaa abu nu ani eni osaafɔ ba, kpaa ongyaa nɛ nu ani afɔ yɛɛ eneni yi etse, di kye fwɔlu yi otu mgban. ");
INSERT INTO utr_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Abu ta ani angba yi ondu okwo ani ataka ba, kpaa ongyaa nɛ kyɛ onɔ ngwi ani ba mmɛnɛ ma jo, o tonya okye ondu kwo ani afɔ waba. ");
INSERT INTO utr_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Abu kye engyie kyi ani ikye ba, nghaduu ongwu yɔ kye engyie ogbungbɛ kyi ani afɔ. ");
INSERT INTO utr_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Hininɛ ani le nya abu gbɛɛ a dzanta yi ali ibwubwe kwuba, ikyesinɛ o tso okpitukwu kwuba. Kpaa inggisɛ ongwu a dzanta gwee, li tso okpitukwu gwee ta.>> ");
INSERT INTO utr_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Ta iYesu nya ongyaa na gbɛɛ, <<A dzita abu yi ali ibwubwe mgbi abu.>> ");
INSERT INTO utr_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ingyoga angbeka ama nle gye ungwogye yi ama wita ogbɔ yi ewoma gbɛɛ, <<Nɛnɛ li emɛ ngwu ali ibwubwe kpaa o li dzɛ inggisɛ ta yan?>> ");
INSERT INTO utr_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","IYesu nya ongyaa na gbɛɛ, <<Oyɛyɛ onuunu mgbi abu dulu abu watɔ, lu mi iyu.>> ");
INSERT INTO utr_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Dafi egbe wa nyɛ gwee nɛ, iYesu le kyikyɛ nyɛ ifu igeli yi agwɔ idzidza-dzidza le gbɔ Esɔ Osuse mgbi esutɔ mgbi Imgbasho. Ama ogbikyon kyɛ yan, ");
INSERT INTO utr_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","bɛyi engyaa angbeka ngwu a ngyɛlu ma ootse onodzi ibwubwe bɛyi ootse ita idzidza-dzidza: li iMeri ngwu a li kwun di iMagidalin, ongwu a lɔ onodzi emɛsɛ tɔ mbon egyafa nani; ");
INSERT INTO utr_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","bɛyi iJoana, owa iKudza, nli ikye mgbi emi idɔ mi opiikwɔ mgbi iHerude; bɛyi iSudzana, bɛyi engyaa angbeka kwuba ama nli kye ungwɔ mgbi ama abuoma kye ya emi iYesu abɔ mani. ");
INSERT INTO utr_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Ngwi ibyi inggisɛ tole kwakye, angbeka dile ba mbi iYesu mi igeli idzidza-dzidza nɛ, iYesu nya ma odzɛ mi utsa gbɛɛ: ");
INSERT INTO utr_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","<<Inggisɛ ofwe etɔ tasɛ o ka fwe etɔ. Dafi o fwe nɛta, angbeka yangwuta mi ofɛ a kye afɔ dzin, ingwunɔ emi esho ba wa kyi salu gye. ");
INSERT INTO utr_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Angbeka yangwuta mi akwutsɛ; dafi i lumbye nɛ, a ngwɔ dunto ikyekyɛ a tu eni ba. ");
INSERT INTO utr_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Etɔ angbeka yangwuta mi ifaato, ato she bɛyi ama nu ma gbufyo. ");
INSERT INTO utr_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Angbeka yangwuta mi ekyɛ osuse, a lumbye yɛ wa owawa akpe ngwuseda ngha ongwi a kye kya mani.>> IYesu si kwu ela gbɛɛ: <<Inggisɛ ndzɛ yi adɔ ofwoofwo yɔ, no fwo!>> ");
INSERT INTO utr_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Engwafɔ iYesu byun ita mi ungwɔ ngwi utsa nɛ tso mani. ");
INSERT INTO utr_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Nɛ o gbɛɛ, <<Ema yɔ, a nu ema ye ungwɔ ama odaada ongwi esutɔ mgbi Imgbasho, kpaa angbeka yɔ, li mi utsa ta ngwi ani li gbɔdzɛ yi ama, ikyegbɛɛ: << <Mi odiidi kpaa, a ka di ba, bɛyi ofwoofwo, ni a fwo kpaa ka gbosa loma ba.> ");
INSERT INTO utr_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","<<Li ngha ngwi utsa nɛ dzɛ aani: Etɔ, li elodzɛ Imgbasho. ");
INSERT INTO utr_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Etɔ ama n yangwuta mi ofɛ na, i tso gbɛɛ dzɛ mi ikye ama nfwo kpaa iSatan ba wa kye gbɛlu elodzɛ na mi itukwu mgbi ama, ikyegbɛɛ nu ma dzɛ yi oyɛyɛ onuunu ni a dulu ma watɔ ba. ");
INSERT INTO utr_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Etɔ ama n yangwuta mi akwutsɛ ma, a dzɛ mi ikye inggisɛ ama nfwo esɔ diyɛ kyi gbɛlu yi atsa, kpaa a yagba dzɛ yi akpa ba, a noyɛyɛ mi onɔ gwee ta, ngwi imbadi wa ba nɛ, a gbɛsɛ. ");
INSERT INTO utr_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Etɔ ama n yangwuta mi ifaato ma, a dzɛ mi ikye inggisɛ ama nfwo, kpaa okakewo bɛyi aludu yi oshishe ofyunfya ongwi ɛsɛ nɛ loka wo ma nɛta, a yɛ wa owawa wuba. ");
INSERT INTO utr_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Etɔ ama n yangwuta mi ekyɛ osuse ma, a dzɛ mi ikye inggisɛ ama nfwo elodzɛ mgbi Imgbasho, yilen sisɛ mi itukwu mgbi ama osuse yi osunu mani, a shitukwu nghataa yɛ wa owawa. ");
INSERT INTO utr_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","<<Inggisɛ onyi dzɛma nka kye ipitila dɔ duuse yile mgboko tukwu ele ba, naadi yilen dzɛkɛ ifagwudo ba, kpaa o ka kye dɔkɛ mi ododa, ikyegbɛɛ inggisɛ ama nle kaka nu ma di osa! ");
INSERT INTO utr_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Lubana alungwɔ ndzɛ mi odaada duu, a ka kye tɔ mi ododa, bɛyi ungwɔ ama ngwi a kye tukwu duu, a dika kye kwulu tɔ mi ododa. ");
INSERT INTO utr_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Nghanɛ gbɛwɛbyi, mi ofwoofwo ngwi ema fwo nɛni, ikyekyɛ inggisɛ ndzɛ yi ungwɔ ma, a ka mbwon mbwoombwo, kpaa inggisɛ ndzɛ yi ungwɔ ba, ogyɛngyɛ ngwi o tsɛwɛ gbɛɛ ongwu dzɛyan ma kpaa, a ka kye gbɛlu mbon.>> ");
INSERT INTO utr_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Onɔ iYesu bɛyi emi ongwunɔn ba mbon, kpaa a yagba to mbon gbɛ ba ikye ibyi inggisɛ. ");
INSERT INTO utr_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Inggisɛ oka nyan gbɛɛ, <<Onabu bɛyi emi ongwunabu kwulɛsɛ to esɛ, a mina odi abu.>> ");
INSERT INTO utr_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","IYesu nya ma duu gbɛɛ, <<Ama nle fwo elodzɛ Imgbasho diyɛ kyɔ mi ele ma, li ama nli emi onani bɛyi emi ongwunani aali.>> ");
INSERT INTO utr_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Egbe oka nɛta, iYesu si kaka uwaa yi engwafɔɔn, o nya ma gbɛɛ, <<Eyi ka foyombo utɔ.>> A si kyato olu. ");
INSERT INTO utr_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Ngwi a le lu nɛ, iYesu nauna. Nɛ onikyɔ awo ba wa fa mi utɔ, nghanɛ uwaa le mweeni, ta a dzɛ mi okakewo kpakpa. ");
INSERT INTO utr_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Man a ba mbon wa kyilen, a nyan gbɛɛ, <<Ongyukwo, Ongyukwo! Eyi le dzili!>> IYesu kyato fa awo yi akpeni ela: onikyɔ awo kwulu, man imbe yɛɛ tsiin. ");
INSERT INTO utr_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","O nya engwafɔɔn gbɛɛ, <<Oyɛyɛ onuunu mgbi ema kɔ?>> Kpaa dafi i kwulu ma ewo imio diyɛ wo ma nɛ, a gbɔ yi ewoma gbɛɛ, <<Nɛnɛ li ali inggisɛ dɛn? O fa awo yi akpeni ela ta a fwon!>> ");
INSERT INTO utr_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Emi iYesu si fooye ka kaka ogalu iGeraseni, nli oyombo utɔ iGalalia nani. ");
INSERT INTO utr_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Ngwi iYesu fa dɔkɛ esɛ nɛta, o tsa yi inggisɛ oka mi igeli nani, ngwu esɛ dɔn ikye. O nya yi angwuto owoowo onɔ kɛ, o di li la udɛ ba, li imbe endzi ta ngwi o li la. ");
INSERT INTO utr_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Ngwi o di iYesu nɛ, o makwɔ mi ela okwukwo, o lankɛ iyayi, yɛ kwu ela mfyumfye gbɛɛ, <<Li ekyɛ wo abu yi ani, iYesu, Ongwɛ Imgbasho nngha mi esho? N le tɛkyɛ nu abu, ka nu ani adzɛ ba!>> ");
INSERT INTO utr_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","IYesu plɛ woola gbɛɛ, ni onodzi ibwubwe na tasɛ mbon. Lubana a li bwan mi onɔ ibyibyi, kye ashi won tan itse, ikye ole ngyon, kpaa o li gbɔdzɛ adi nani, onodzi ibwubwe li lɔn lu okwɛsɛ. ");
INSERT INTO utr_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","IYesu byun gbɛɛ, <<Iyi abu di emɛ?>> O nyan gbɛɛ: <<Ibyibyi>> bana onodzi ibwubwe kaka mbon kwuba. ");
INSERT INTO utr_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Onodzi ibwubwe ntona tɛkyɛ nu iYesu gbɛɛ no ka lɔ ama onya ka yaokɛ ikplishɛ na ba. ");
INSERT INTO utr_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Obyia ibyibyi kwuto le gye ungwɔ mi ewunggwɔ. Onodzi ibwubwe ntona si le tɛkyɛ yi iYesu gbɛɛ no nu ama ofɛ ni ama lu ka kaka obyia, man o si nu ma ofɛ. ");
INSERT INTO utr_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Ta onodzi ibwubwe ntona tasɛ mbi inggisɛ na lu ka kaka mbi obyia ntonani. Obyi obyia ntona nyɛ yi onya kye ikye byi ufɛ lu ka yaokɛ utɔ si dzili mi eni. ");
INSERT INTO utr_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Ama ntole ngyo obyia ntona di ungwɔ nkyɔ mani ta a si tsinya lu ka kye odzɛ nɛ gbɔfwɛ nya ma mi igeli bɛyi ama nto okwɔ mi agya na duu. ");
INSERT INTO utr_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Nɛ inggisɛ tasɛ le ka di ungwɔ nkyɔ mani. A si ba mbi iYesu, wa tu inggisɛ ongwu onodzi ibwubwe tɔ mbon ma, sɔdzɛ iyayi mgbi iYesu, o wo angwuto ewo di dzɛ yi ozoyeye saan; ta i kwulu ma ewo. ");
INSERT INTO utr_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Ama nteyi di ma nya angbeka dafi i kyɔ se inggisɛ ngwu onodzi ibwubwe kaka mbon na yɛɛ saan mani. ");
INSERT INTO utr_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Ta inggisɛ ama nto ɛsɛ iGeraseni duu nya iYesu gbɛɛ no lu, ikyekyɛ imio wo ma. Man o si kaka uwaa lu. ");
INSERT INTO utr_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Inggisɛ ongwu onodzi ibwubwe tɔ mbon na tɛkyɛ yi iYesu gbɛɛ ni ongwu lu yan. Kpaa iYesu nyan gbɛɛ, ");
INSERT INTO utr_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","<<Yɛ lu udɛ abu, ka gbɔ ungwɔ ngwi Imgbasho kyɔ yi abu nɛni.>> Inggisɛ na yɛ lu le kyikyɛ kɛ igeli-igeli, le gbɔ ungwɔ ngwi iYesu kyɔ yan mani. ");
INSERT INTO utr_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Ngwi iYesu yɛ luba nɛ, ibyi inggisɛ gban yi atsa, ikyekyɛ a tole fan. ");
INSERT INTO utr_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Nɛ inggisɛ oka ba, a li kwun di iJaru, o li ongyukwo mi ozu okwakye mgbi emi iJuda, o kwɛsɛ mi iyayi iYesu, si tɛkyɛ yan gbɛɛ no kɛ udɛ ongwu. ");
INSERT INTO utr_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Ikyekyɛ ongwan ongwu ongyaa onyi kpokpo, ngwu mɛ onova iwyodefa, le fyikwu. Dafi iYesu le kɛ nɛ, ibyi inggisɛ tukwun kpakpa. ");
INSERT INTO utr_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Mi idzidzɛ inggisɛ ntona, ongyaa oka dzɛ le yeeyi mɛ onova iwyodefa. O kye mbelu aludu mgban duu mbi ama obwotse, kpaa onyonyi yan abɔ ba. ");
INSERT INTO utr_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","O kaka ifu ibyi inggisɛ ntona wa kye abɔ gbo iYesu ondu angwuto mi iyikpa, labɔlabɔ mata eyi dzɛ lon. ");
INSERT INTO utr_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","IYesu gbɛɛ, <<Li emɛ kye abɔ gbo ani?>> Ama duu le tangwɛ, iPyita gbɛɛ, <<Ongyukwo, ibyi inggisɛ ama nkpakɛkɛ wo abu yɛ mba yi abu nɛ abu le byita gbɛɛ: <Li emɛ kye abɔ gbo ani ewoo?> >> ");
INSERT INTO utr_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Nghaduu iYesu gbɛɛ, <<Inggisɛ kye ewo gbo ani, bana n kwu ambɛ dafi mfye tɔ mbi ani mani.>> ");
INSERT INTO utr_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Ongyaa na di dafi ongwu dzɛ mi odaada wuba nɛ, o ba yi ewo otsaatsa wa kwɛsɛ mi iyayi mbi iYesu. O gbɔ mi inɛ mgbi inggisɛ tsatsa dafi i kyɔ se ongwu kye abɔ gbon ondu angwuto, ngwi ewo mgbi ongwu kpa di gbosa mina mani. ");
INSERT INTO utr_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Nɛ iYesu nyan gbɛɛ, <<Ongwongyaa, oyɛyɛ mgbi abu onuunu dulu abu tɔ. Lu mi iyu.>> ");
INSERT INTO utr_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Onɔ ngwi iYesu le gbɔdzɛ nɛ mata, inggisɛ oka mi udɛ iJaru, ongyukwo mi ozu okwakye mgbi emi iJuda na ba, o gbɛɛ, <<Ongwabu ongwu ongyaa na kwulu wa: Ka kaka Otsetse ewo wuba.>> ");
INSERT INTO utr_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Ngwi iYesu fwo nghanɛ, o nya iJaru gbɛɛ, <<Ka teeyi ba, dzɛ yi oyɛyɛ onuunu, ta ootse mgban ka ngyɛ.>> ");
INSERT INTO utr_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Dafi iYesu ka kaka udɛ iJaru nɛ, o gbela onu inggisɛ onyi kpaa kaka ozu yan ba, se li iPyita yi iJɔn bɛyi iJɛnsi yi otsɔ ongwongyaa na bɛyi onɔn ta. ");
INSERT INTO utr_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Ali inggisɛ duu le tsukwu dile kyelela mi ikye ongwɛ nani. Nghaduu iYesu gbɛɛ, <<Ka tsukwu ba na, lubana ongwɛ nɛ kwulu ba, o nanuna ta.>> ");
INSERT INTO utr_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Ama duu shan isha ikwangha, ikyekyɛ a ye gbɛɛ di o kwulu. ");
INSERT INTO utr_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Kpaa ngwi iYesu byin abɔ nɛ, o gbɛɛ, <<Ongwani, kyato!>> ");
INSERT INTO utr_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Ta oshishe mgban yɛ, man o kyato plɛ. IYesu si nya ma gbɛɛ, nu ma kye ungwogye non gye. ");
INSERT INTO utr_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","I kwulu ama o mban ma ewo, nghaduu iYesu wo ma ola gbɛɛ nu ma ka nya inggisɛ onyi ungwɔ nkyɔ nɛ ba. ");
INSERT INTO utr_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Onɔ ngwi iYesu kwu iwyodefa ntona kwakye nɛ, o kye mfye nu ma ikye nu ma lɔ ali itɔ onodzi ibwubwe onya di ngyɛlu ootse, ");
INSERT INTO utr_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","o di dɔ ma esɔ gbɛɛ nu ma gbeesɔ mgbi esutɔ mgbi Imgbasho di ngyɛlu ama ndotse ootse. ");
INSERT INTO utr_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","O nya ma gbɛɛ: <<Ka kye unka byi mi okyɛɛ nɛ ba na, okwuta ba, igbe ba, ungwogye ba, awuya ba, angwuto kpaa ba. ");
INSERT INTO utr_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Ali udɛ ngwi ema kaka efu duu, dzɛ ele nghataa imbisɔ ngwi ema ka dzata igeli nani. ");
INSERT INTO utr_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Ni inggisɛ gbɛ ema bayɔ, dzata igeli na di kye gbolu ombulu mi afɔ mgbi ema otso ambɛ adɔ okwookwo mboma.>> ");
INSERT INTO utr_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Ama okyɛ yi iYesu si lu kaka mi agwɔ udɛ yi agwɔ udɛ le gbɔ Esɔ Osuse nɛni dile ngyɛlu ibyi inggisɛ ootse mi ali imbe duu. ");
INSERT INTO utr_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Ngwi iHerude atɔtsɛ fwo odzɛ nle kiyayi nɛ, i si kakan ewo. Inggisɛ angbeka tole gbɛɛ iJɔn okyɔ iBatisima yɛ kyɛɛ mi ikwu. ");
INSERT INTO utr_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Angbeka tole gbɛɛ oyegbɔ Elaija yidɔ wa, hona onyi mi oyegbɔ emi tugbe ntona diyɛ kyɛɛ mi ikwu. ");
INSERT INTO utr_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Nghaduu iHerude gbɛɛ, <<Ani nu ma dzɛ iJɔn ikye! Ma li emɛ ngwu ani le fwo odzan kpakpa ngha?>> I mina iHerude kpakpa otsa inɛ yi iYesu. ");
INSERT INTO utr_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Ama ogbikye iYesu si yidɔ wa nyan ungwɔ ngwi ama kyɔ duu. Man o kye ma daada lu yan mi igeli mgbi iBɛtsaida, ");
INSERT INTO utr_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","nghaduu ibyi inggisɛ ka difwi imbe ngwi a lu nɛman a si lukwun. O gbɛ ma di nya ma odzɛ mgbi esutɔ mgbi Imgbasho, di ngyɛlu ama i wo ma gbɛɛ ni a ngyɛlu ma ootse duu. ");
INSERT INTO utr_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Ngwi onɔ le ka gbɛsɛ nɛ, emi iwyodefa ntona ba mbi iYesu wa gbɛɛ, <<Nu ijiji inggisɛ ntonɛ ofɛ, nu ma lu igeli yi ayɛsɛ mi agya nɛni. A mina imbe ngwi a ka la di tu ungwogye, ikyekyɛ imbe ngwi eyi dzɛ nɛ li imbe okplagada!>> ");
INSERT INTO utr_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","IYesu nu ma uka gbɛɛ, <<Nu ma ungwɔ nu ma gye na.>> Kpaa a gbɛɛ, <<Eyi dzɛ yi ibredi nghi eda bɛyi mmbweni efa ta. Ni eyi ka byi inggisɛ ntonɛ duu enbwa yɔ, sede eyi ka lu ka gyaagya ungwogye.>> ");
INSERT INTO utr_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","(A mɛ engyulɔ idubu eda sini.) Nghaduu iYesu nya engwafɔɔn gbɛɛ, <<Nu ma sisɛ ibwi-ibwi mɛ mmbwo ngwusefa dɔn iwyo, ngwusefa dɔn iwyo hini.>> ");
INSERT INTO utr_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Engwafɔɔn kyɔ ngha yɛyɛ, ali inggisɛ duu sisɛ. ");
INSERT INTO utr_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","IYesu kyi kyelu ibredi bɛkɛ yi mmbweni ntona man kyile inɛ kɛ esho, o bibɔ di kye mwalu. Ta o kye nu ama okyɛ yan nu ma kye gha ma. ");
INSERT INTO utr_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Ama duu gye di tolo, ambulu nsisi ma a kye gbelu mbwo uya nghi iwyodefa. ");
INSERT INTO utr_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Egbe oka ngwi iYesu dzɛ yuon le bibɔ nɛ, ama okyɛ yan to biyan man o byi ma gbɛɛ, <<Inggisɛ li gbɛɛ ani li emɛ?>> ");
INSERT INTO utr_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","A nu uka gbɛɛ, <<Angbeka gbɛɛ abu li iJɔn okyɔ iBatisima; angbeka gbɛɛ oyegbɔ Elaija; angbeka li gbɛɛ oyegbɔ oka tugbe yidɔ ba.>> ");
INSERT INTO utr_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Nghanɛ iYesu byi ma gbɛɛ, <<Ema ma ema gbɛɛ ani li emɛ?>> IPyita nun uka gbɛɛ, <<Abu li iKrestu mgbi Imgbasho.>> ");
INSERT INTO utr_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","IYesu kwo ma adɔ kpakpa gbɛɛ nu ma ka nya inggisɛ onyi odzɛ nɛ ba. ");
INSERT INTO utr_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","IYesu si nya ama okyɛ yan gbɛɛ, <<Ongwɛ Inggisɛ ka gbiisɔ mi ungwɔ kwuba engyukwo yi ama ofifɛ mgbi Imgbasho bɛyi ama otso ola mgbi iMose, ka ngwɔn kyɛmɛ-kyɛmɛ. Nghaduu mi egbe ongwu ta ma Imgbasho ka kyilen luba oshishe.>> ");
INSERT INTO utr_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Nɛ o nya ma duu gbɛɛ: <<Ali inggisɛ nmina okyɛdɔ ani yɔ, li kyɛmɛ ngwi o ka tangwɛ ewon yɛ kyelu ekwatsi mgban kyɛdɔ ani alegbe-alegbe. ");
INSERT INTO utr_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Ikyena ali inggisɛ nmina odulu oshishe mgban tɔ yɔ ka byulu lon, kpaa inggisɛ ngwu oshishe mgban byulu mi ikye mgbi ani yɔ, ka dulun tɔ. ");
INSERT INTO utr_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Li ali oyabɔ ngwi inggisɛ ka tu, ni otsungwɔn tu ɛsɛ duu kpaa oshishe mgban dzili? ");
INSERT INTO utr_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Ni inggisɛ kwayiwi ani yi esɔ mgbi ani, Ongwɛ Inggisɛ ka kwayiwi inggisɛ nani mi onɔ ngwi o yɛ mi okwɔkwɔ mgban bɛyi okwɔkwɔ mgbi Otsɔn Imgbasho bɛyi engyesɔ mgban ama osaan mani. ");
INSERT INTO utr_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","N nya ema otsitsi, angbeka to mmɛnɛ nka di ikwongye inɛ ba nghataa ngwi a ka di esutɔ mgbi Imgbasho.>> ");
INSERT INTO utr_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Ngwi iYesu gbɔdzɛ ntonɛ nyɛ egbe egyata nɛta, o kyi kyelu iPyita bɛyi iJɔn yi iJɛnsi lu yan mi unggwɔ oka bibɔ. ");
INSERT INTO utr_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Ngwi o kale bibɔ nɛ, inɛ mgban si kyata, angwuto mgban tundzɛ yɛ kwɔ dafi mmbwo onaabɔ mani. ");
INSERT INTO utr_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Plɛ nɛta, engyulɔ efa: iMose yi Elaija, tɔ wita ogbɔdzɛ yi iYesu. ");
INSERT INTO utr_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","A tɔ mi okwɔkwɔ ongwi esho sile gbɔdzɛ mgbi ikwu mgbi iYesu ndzɛ kwɛkwɛ ombwumbwo mi iJerosalin mani. ");
INSERT INTO utr_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","IPyita yi angbeka si nuna lu byulu, onɔ ngwi a kyato nɛ, a di iYesu yi okwɔkwɔ mgban yi inggisɛ nghi efa toyan. ");
INSERT INTO utr_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Dafi iMose yi Elaija wita olu nɛ, iPyita nya iYesu gbɛɛ, <<Ongyukwo, i tishi ni eyi ki to mmɛnɛni! Ni eyi klɛ afu eta, onyi ikye abu, onyi ikye iMose, onyi ikye Elaija.>> (Nghaduu o ye odzɛ ngwi o le gbɔ ma ba.) ");
INSERT INTO utr_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Ngwi o kale gbɔdzɛ nɛ, akpa tɔ gbiiwulu tukwu ma; man ama okyɛ yi iYesu wimio dafi akpa wa tukwu ma mani. ");
INSERT INTO utr_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Ta ela tɔ mi akpa na gbɛɛ, <<Nɛnɛ li Ongwani, ongwu ani dulu-dulu; gadɔ mbon na.>> ");
INSERT INTO utr_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Ngwi ela na dede mata, iYesu si dzɛ mmana yuon. A kye ungwɔnɛ da, di nya inggisɛ onyi kpaa ungwɔ ngwi ama di mi onɔ na ba. ");
INSERT INTO utr_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Tegblifan, ngwi a tashulu mi unggwɔ nɛ ibyi inggisɛ wa tu iYesu. ");
INSERT INTO utr_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Inggisɛ mi ifu ibyi kwu ela gbɛɛ, <<Otsetse, ani gbabɔ nu abu kye inɛ byi ongwani, o li onyi kpokpo. ");
INSERT INTO utr_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Onodzi obube li dzɛsin non le teela; o li dzɛkwulu li tsuuvu ondu. Ni kyɔn li fyumfye odzanta dile dzilin kpaa. ");
INSERT INTO utr_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Ani gbabɔ nu engwafɔ mgbi abu gbɛɛ nu ma dulu onodzi na tɔ, kpaa a yagba ba.>> ");
INSERT INTO utr_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","IYesu si gbɛɛ, <<Ema etɔ ndzɛ yi oyɛyɛ onuunu ba dile kpɛkpɛ nɛ! Ka kye onɔ sinɛ ngwi ani ka dzɛ yi ema yi itukwu oshiishi?>> Man o nya inggisɛ na gbɛɛ, <<Kye ongwabu ma ba mmɛnɛni.>> ");
INSERT INTO utr_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Ngwi a kyon ba nɛ, onodzi obube na di kyon zudɔwɛsɛ o di dzɛkwulu fyumfye. IYesu fwa yi onodzi obube na, man o ngyɛlu ongwɛ na ootse di yilen nu otsɔn. ");
INSERT INTO utr_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","I kwulu ali inggisɛ ewo mi ogbagbadzidzi mfye ngwi Imgbasho kyɔ nani. Ngwi i kale kwulu ali inggisɛ ewo mi ungwɔ ngwi iYesu kyɔ duu nɛ, o nya ama okyɛ yan gbɛɛ, ");
INSERT INTO utr_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","<<Gadɔ mi odzɛ ngwi ani le gbɔ nya ema nɛni: A ka kye Ongwɛ Inggisɛ wo engyikyili mgban abɔ.>> ");
INSERT INTO utr_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Kpaa ama okyɛ yan kwu ambɛ odzɛ na ba. Itan da ma daada, nɛ a yagba difwi ba, imio kpaa di wo ma obyin ita. ");
INSERT INTO utr_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Angwodzɛ tɔ mi idzidzɛ mgbi ama okyɛ yi iYesu gbɛɛ li emɛ mboma shewo ngha. ");
INSERT INTO utr_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","IYesu ye ungwɔ ngwi a le tsɛwɛ nɛta, o si kye ongbɛ kwulɛsɛ dzɛkɛ agya mgban. ");
INSERT INTO utr_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","O nya ma gbɛɛ, <<Inggisɛ ngbɛ itɔ ongwɛ nɛ mi iyi mgbi ani gbɛ ani; o di gbɛ inggisɛ ngwu ndɔ ani esɔ mani. Ikyena ongwu nghao yɛyikpa mi idzidzɛ ema duu ma nghao shewo.>> ");
INSERT INTO utr_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","IJɔn gbɔ nya iYesu gbɛɛ, <<Ongyukwo, eyi di inggisɛ oka le dulu onodzi emɛsɛ mi iyi mgbi abu eyi fwa yan gbɛɛ non nya, ikyekyɛ o li onyi mbi eyi ba.>> ");
INSERT INTO utr_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","IYesu nyan gbɛɛ, <<Ka yama non nya ba, lubana inggisɛ nfwa ema bayɔ li mgbi ema.>> ");
INSERT INTO utr_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Dafi onɔ wa dzɛ kwɛkwɛ ngwi a ka kye iYesu lu esho nɛ, o ngyɛlu odzɛ mi itukwu mgban si byi ofɛ abɔ le lu iJerosalin. ");
INSERT INTO utr_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","O dɔ emi esɔ angbeka teyin, lu mi agwɔ oka mi iSamaria oka mɛlu alungwɔ duu le fan; ");
INSERT INTO utr_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","kpaa inggisɛ emi imbe na gban ba, ikyekyɛ o dzɛ yi oweka olu iJerosalin. ");
INSERT INTO utr_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Onɔ ngwi iJɛnsi yi iJɔn di ungwɔnɛ nɛ, a gbɛɛ, <<Otsɛ, i mina abu gbɛɛ ni eyi kwu ola ela mi esho ba esɛ wa kye ma gyee?>> ");
INSERT INTO utr_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Nghaduu iYesu kyata fwa yi ama, ");
INSERT INTO utr_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","ta a si lu agwɔ oka. ");
INSERT INTO utr_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Dafi emi iYesu le lu ofɛ mgbi ama nɛ, ongyulɔ oka nya iYesu gbɛɛ, <<N ka kyɛdɔ abu ali imbe ngwi abu le kɛ duu.>> ");
INSERT INTO utr_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","IYesu nyan gbɛɛ, <<Emi ogbalinya to yi ishɛ, ingwunɔ emi esho dzɛ yi udɛ, kpaa Ongwɛ Inggisɛ dzɛ yi imbe okye ikye da ba.>> ");
INSERT INTO utr_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","O di nya inggisɛ oka gbɛɛ, <<Kyɛdɔ ani.>> Kpaa ongyulɔ ma gbɛɛ, <<Otsɛ, ababɔ nu ani ofɛ nin ka gbinɛbyi otsani nghataa kyon ndzi se.>> ");
INSERT INTO utr_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","IYesu nyan gbɛɛ, <<Ni emi ikwukwɔ ndzi ewoma, kpaa abu lu ka gbeesɔ mgbi esutɔ mgbi Imgbasho.>> ");
INSERT INTO utr_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Inggisɛ oka di gbɛɛ, <<N ka kyɛdɔ abu, Otsɛ; kpaa nin ka nya emidani gbɛɛ se egbe oka se.>> ");
INSERT INTO utr_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","IYesu si nyan gbɛɛ, <<Inggisɛ nkye abɔ byi ikwukwɔ oshookwɔ, wita oshookwɔ diyɛ le ndinɛ kɛ iyikpa yɔ, o mɛ unkonyi mi esutɔ mgbi Imgbasho ba.>> ");
INSERT INTO utr_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Ta Otsɛ iYesu dulu inggisɛ ngwuseta dɔn iwyo diwyefa. Si dɔ ma esɔ efefa, nu ma teyi ongwu kɛ ali igeli bɛyi imbe ngwi ongwu ka wa kɛ duu. ");
INSERT INTO utr_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","O nya ma gbɛɛ, <<Etɔ oshɛ-shɛ le kwuba, kpaa emi idɔ le gwee ta. Ema bibɔ mbi Otsɛ Imgbasho mgbi etɔ oshɛ-shɛ, non dɔ emi idɔ mgban esɔ nu ma wa shɛ etɔ. ");
INSERT INTO utr_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Lu na! Lubana ani le dɔ ema esɔ dafi engwɛ mmala mi ifu emi idukwlɛbɛ mani. ");
INSERT INTO utr_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Ka kye ashiko naadi igbe okɛ agaba hona okpafɔ oka ba. Ka kwulɛsɛ mi ofɛ tangba yi inggisɛ ba na. ");
INSERT INTO utr_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","<<Onɔ ngwi ema kaka udɛ inggisɛ yɔ, tsekise gbɔgbɛɛ, iyu mgbi Imgbasho no dzɛ udɛ nɛni. ");
INSERT INTO utr_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Kini inggisɛ iyu dzɛ udɛ na yɔ, iyu mgbi Imgbasho ka kaka mbi otsungwɔn, kpaa ki no dzɛma ba, iyu mgbi Imgbasho ka yɛ luba mbi ema. ");
INSERT INTO utr_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Ka kyikyɛ mi udɛ-udɛ ba na. La mbonyi, le gye, diyɛ wa alungwɔ ngwi a kye nu ema duu, lubana inggisɛ idɔ gyɔ ni a kpan. ");
INSERT INTO utr_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","<<Ni ema kaka igeli, nu ma kyɔ ema onɔ yɔ, gye alungwɔ ngwi a kye nu ema duu. ");
INSERT INTO utr_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Bwe ama ndotse to ele ma na, diyɛ nya ma gbɛɛ: <Esutɔ mgbi Imgbasho dzɛ kwɛkwɛ yi ema.> ");
INSERT INTO utr_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Nghaduu, igeli nfwa ogbɛ ema yɔ, tasɛ lu ingɔfɛ ka gbɛɛ, ");
INSERT INTO utr_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","<Ombulu ongwi ogalu mgbi ema nto eyi ka afɔ nɛ, eyi ka kye gbolu dafi ambɛ adɔ okwookwo mbi ema. Di ye na gbɛɛ esutɔ mgbi Imgbasho dzɛ kwɛkwɛ.> ");
INSERT INTO utr_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","N nya ema gbɛɛ, mi egbe na ka tatase lo ogalu mgbi iSodon ngha ogalu nani. ");
INSERT INTO utr_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","<<Ahoo! Abu ogalu mgbi iKoradzin yi abu iBɛtsaida; ema ka gyadzɛ. Ikyekyɛ ungwɔ okwulewo ongwi a kyɔ mbi ema nɛ, ki li mi ogalu mgbi iTiru yi iSidon yɔ, a ki kyatitukwu mi ali ibwubwe mgbi ama gbegbe, a ki kye ishangli wo ewo yɛ myini mi utɔ. ");
INSERT INTO utr_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Nghaduu ka tatase mbi iTiru yi iSidon mi egbe ikwɔ ngha ema. ");
INSERT INTO utr_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Abu ogalu mgbi iKapenahun, a ka kyile abu esho wɛ? Ei, abu ka lu esɛ mi imbe mgbi emi ikwukwɔ.>> ");
INSERT INTO utr_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","IYesu si nya ama okyɛ yan gbɛɛ, <<Inggisɛ nfwo ema fwo ani. Ongwu nfwa ema fwa ani. Ongwu nfwa ani fwa Imgbasho ndɔ ani esɔ nani.>> ");
INSERT INTO utr_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Emi ngwuseta dɔn iwyo-diwyo-efa ntona yidɔ yi atsa wa gbɛɛ, <<Otsɛ iYesu, mi iyi mgbi abu emi onodzi emɛsɛ kpaa le sunu eyi.>> ");
INSERT INTO utr_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","IYesu nu ma uka gbɛɛ, <<N di iSatan gbɛsɛ kyɛ esho dafi mmbwo le naabɔ mani. ");
INSERT INTO utr_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Ani tsekise kye mfye nu ema okye afɔ dzi ifa bɛyi mnaa odi ngha mfye mgbi ongyikyili mgbi ema, unkonyi kpaa ka kyɔ ema ba. ");
INSERT INTO utr_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Nghaduu ka tsatsa na gbɛɛ di emi onodzi ibwubwe sunu ema ba. Kpaa, tsatsa ikyegbɛɛ a lɔ ema iyi mi esho.>> ");
INSERT INTO utr_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Mi onɔ na kpɔɔ iYesu mbwo yi atsa mi Onodzi Osaan, o gbɛɛ, <<Ani ta abu angba Otsani, Otsɛ mgbi esho yi esɛ, ikyekyɛ abu kye ungwɔ ntonɛ da ama ntsɛwɛ gbɛɛ di ama kwiinɛ diyɛ yodzɛ mani, kpaa abu kwulu iba nya ɛngbɛ. Ɛɛn, Otsani, li ngha ngwi i kpaa abu gbɛɛ no dzɛ aali. ");
INSERT INTO utr_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","<<Otsani kye alungwɔ duu wo ani abɔ. Inggisɛ onyi ye ongwu nli Ongwɛ ba li Otsɔn ta, inggisɛ onyi kpaa di ye Otsɔn ba li Ongwɛ ta bɛyi ama ngwu Ongwɛ sadu okye Otsɔn tso ma mani.>> ");
INSERT INTO utr_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Man iYesu kyata mbi engwafɔɔn ntona gbɔ yi ama daada gbɛɛ, <<Mse no bɛ ama ndi ungwɔ ema di nɛ ewo! ");
INSERT INTO utr_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","N nya ema gbɛɛ i mina ibyi oyegbɔ yi ibyi utɔ gbɛɛ ama ki di ungwɔ ngwi ema di nɛ, kpaa a di ba, odi fwo ungwɔ ngwi ema fwo nɛ, kpaa a yagba fwo ba.>> ");
INSERT INTO utr_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Onɔɔlɔlɔ ma inggisɛ oye ola mgbi iMose saan kyatunto ombadi iYesu, o gbɛɛ, <<Otsetse, li alungwɔ ngwi ani ka kyɔ se ngwi ani ka tu oshishe igyegwu?>> ");
INSERT INTO utr_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","IYesu nyan gbɛɛ <<Ola mgbi iMose gbɔsinɛ? Abu li gbɔn sinɛ?>> ");
INSERT INTO utr_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","O si nu uka gbɛɛ, <<Afɛ lɔ gbɛɛ: <Otsɛ Imgbasho no kpa abu itukwu yi itukwu mgbi abu duu yi oshishe mgbi abu duu yi mfye mgbi abu duu yi oyeeye mgbi abu duu>; di, <Inggisɛ nwatse dɔ abu kpa abu itukwu dafi ewabu mani.> >> ");
INSERT INTO utr_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","IYesu nyan gbɛɛ, <<O gbɔ ayin; lu ka kyɔ ngha ta o ka dzɛ oshishe.>> ");
INSERT INTO utr_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Kpaa dafi o mina otso oye-ye mgban nɛ, o byi iYesu gbɛɛ <<Li emɛ li inggisɛ owatse dɔ ani?>> ");
INSERT INTO utr_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","IYesu si nyan gbɛɛ: <<Inggisɛ iJuda oka kyɛ mi iJerosalin le kɛ iJeriko, o ka kaka abɔ emumyi ama ofofɛ. A gbon ibe di kyon angwuto mi ewo kye dulu dzanta lakɛ ofɛ le fyikwu. ");
INSERT INTO utr_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","I wa yɛɛ gbɛɛ inggisɛ ofifɛ mgbi Imgbasho oka wa le nyɛ ofɛ na kpɔɔ, o di inggisɛ na ta, o nyɛ enggengga lu. ");
INSERT INTO utr_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Inggisɛ iLevi nli kyidɔ mi ozu okwakye mgbi emi iJuda kpaa kyɔ ngha, ngwi o di inggisɛ na nɛ, ongwu kpaa nyɛ enggengga lu. ");
INSERT INTO utr_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Nghaduu inggisɛ iSamaria oka nli ingyoga le kɛ agaba, o wa to imbe ngwi inggisɛ na ladzɛ, ngwi o din nɛ, elela kyɔn won kpakpa. ");
INSERT INTO utr_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","O kɛ kwɛkwɛ yan, o san ifwa mi ewo kye otse yawon ele. O kyon dɔkɛ itaklimyi mgban kyon lu ozu ingyoga ka gbeka byun saan. ");
INSERT INTO utr_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Tegblifan nɛ, o dulu udza nmɛ okpa idɔ egbe efa sini kye nu inggisɛ odi mi imbe ingyoga nani, o nyan gbɛɛ: <Bwen saan, ni ani yɛ, ungwɔ ngwi abu mbe mi ikyon duu ni ngha ngha kpaa, n ka yilen kpaa abu.> >> ");
INSERT INTO utr_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","IYesu byita gbɛɛ, <<Mi idzidzɛ inggisɛ eta ntona li emɛ li inggisɛ owatse dɔ inggisɛ ongwu nkaka abɔ emumyi na?>> ");
INSERT INTO utr_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Inggisɛ oye ola na nun uka gbɛɛ, <<Li inggisɛ ongwu ndin elela nani.>> IYesu nyan gbɛɛ, <<Lu ka kyɔ ngha.>> ");
INSERT INTO utr_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Dafi iYesu yi engwafɔɔn kye ikye dɔ le lu iJerosalin nɛ, o wa kaka agwɔ oka, ongyaa oka ngwu a li kwun di iMata gban kaka udɛ mgban. ");
INSERT INTO utr_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","O dzɛ yi ongwunɔn ongwu ongyaa, iyin di iMeri, ngwu ka sɔkɛ iyayi Otsɛ iYesu le fwo elodzɛ mgban. ");
INSERT INTO utr_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Kpaa i kaka iMata ewo kpakpa yi ungwɔ okyɔɔkyɔ nshewo ngwi ongwu ka kyɔ mani. O ba wa byi iYesu gbɛɛ, <<Otsɛ, i kpa abu dafi ongwunani dzata idɔ duu tsaani abɔ nɛɛ? Ngyɛse nyan no wa tobyi ani.>> ");
INSERT INTO utr_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Otsɛ nun uka gbɛɛ, <<IMata, iMata, i kaka abu ewo, eka di kplɔkɔ lo abu mi ungwɔ kwuba; ");
INSERT INTO utr_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","ungwɔ li onyi ta ndzɛ kyɛmɛ-kyɛmɛ. IMeri kye ayɛ ngwi nghao tishi, ngwi a ka kye gbɛlu mbon ba mani.>> ");
INSERT INTO utr_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Egbe oka nɛ, iYesu le bibɔ mi imbe oka. Mi onɔ ngwi o ngyɛlu ibɔ obɔɔbɔ nɛ, ongwafɔ mgban onyi ba mbon wa nyan gbɛɛ, <<Otsɛ, tso eyi obibɔ dafi iJɔn tso engwafɔ mgban nani.>> ");
INSERT INTO utr_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","O nya ma gbɛɛ, <<Onɔ ngwi ema ka bibɔ yɔ, gbɛɛ: << <Otseyi, nu ma nu mmwɛ mi iyi mgbi abu. Ni esutɔ mgbi abu ba. ");
INSERT INTO utr_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Nu eyi ungwogye mgbi eyi ongwi alegbe-alegbe. ");
INSERT INTO utr_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Dzɛ eyi ta yi ali ibwubwe mgbi eyi, dafi eyi kpaa li dzata ama nkyɔ eyi obube mani. Dika kye eyi kaka igyila ba; kpaa dulu eyi tɔ mi obube.> >> ");
INSERT INTO utr_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","IYesu di nya ma gbɛɛ, <<Li emɛ mbi ema ndzɛ yi uka, ka kɛ mbon mi idzidzɛ otu ka nyan gbɛɛ, <Okani, tobyi ani yi ibredi nghi eta; ");
INSERT INTO utr_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","ikyesinɛ okani oka dzagaba wa kaka mbi ani, ma n dzɛ yi unkonyi ngwi n ka kye non gye ba.> ");
INSERT INTO utr_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","<<Ma o nu uka mi ozu dzidzɛ gbɛɛ, <Ka kaka ani ewo ba; onufozu tukwu, ɛngbɛ mgbi ani di lato yi ani mi akwulo. Nghanɛ n ka yagba kyato ba wa nu abu unkonyi ba.> ");
INSERT INTO utr_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","N nya ema, o ka kyato ba wa nun mi ikyegbɛɛ o li okan ba, kpaa mi ikyegbɛɛ o bɔ kyɔ ewewa ba, li ikyengha o ka kyato wa nun dafi o mina duu aali. ");
INSERT INTO utr_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","<<N di nya ema: Bɔ na ta a ka nu ema, di pita na, ta ema ka tu; tsaabɔ na, ta a ka kwulu ema onufozu. ");
INSERT INTO utr_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Lubana otsungwɔn nbɔ ka gbɛ. Ongwu npita ka tu. Ongwu ntsaabɔ, a ka kwulun ofɛ. ");
INSERT INTO utr_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","<<Li emɛ mbi ema etsɛngwɛ ngwu ongwan ka bɔn mmbweni, se o ka nun ifa gbikye mmbweni? ");
INSERT INTO utr_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Naadi o bɔn akyogbi, ngwi o ka kye mnaa nun? ");
INSERT INTO utr_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Ni ema emi ali ibwubwe ye onu ɛngbɛ mgbi ema umba osuse ma, ka kyɔnɛse Otsema ongwi esho ka nghao nu ama nbɔn Onodzi Osaan ba.>> ");
INSERT INTO utr_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Egbe oka nɛ, iYesu lɔ ikplima emɛsɛ onya. Onɔ ngwi emɛsɛ na tɔ nɛ, inggisɛ ngwu onodzi emɛsɛ na non yɛɛ ikplima ma gbɔdzɛ, ta i kwulu ibyi inggisɛ ntona ewo. ");
INSERT INTO utr_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Angbeka gbɛɛ, <<IYesu lɔ emɛsɛ onya yi mfye mgbi iBɛdzɛbu ongwu nli ikye mgbi emɛsɛ nani.>> ");
INSERT INTO utr_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Angbeka le mbadin, a mina ambɛ ongwi esho mbon. ");
INSERT INTO utr_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","IYesu ye ewodzɛ mgbi ama nɛ, o nya ma gbɛɛ: <<Ali esutɔ ngwi gbua mi ikyili yɔ, a ka bulu, udɛ ngwi di gha yi ewon ka bulu. ");
INSERT INTO utr_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Ni iSatan kpaa gha yi ewon ma, ka kyɔsinɛse esutɔ mgban ka kwudzɛ? Lubana ema gbɛɛ ani lɔ emɛsɛ onya yi mfye mgbi iBɛdzɛbu. ");
INSERT INTO utr_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Kini ani lɔ emɛsɛ onya yi mfye mgbi iBɛdzɛbu ma, li mfye mgbi emɛ ngwi ɛngbɛ mgbi ema li lɔ emɛsɛ onya? Ngyɛse ɛngbɛ mgbi ema ka gbɔ ema ikwɔ. ");
INSERT INTO utr_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Kpaa ni li mi mfye mgbi Imgbasho ngwi ani lɔ emɛsɛ onya yɔ, esutɔ mgbi Imgbasho ba mbi ema sewaani. ");
INSERT INTO utr_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","<<Ni inggisɛ ndzɛ yi mfye di dzɛ yi okyiika, ngyo udɛ mgban yɔ, alungwɔ ngwi o dzɛyan duu ka dzɛ kyoon. ");
INSERT INTO utr_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Nghaduu ni inggisɛ ndzɛ yi mfye nghan ba wa gblika yan yɔ, o ka nghan diyɛ gbɛlun okyiika ngwi o le tsaabɔ igɛgɛ yan mani, o dika kyi ghalu okwudɛ mgban yi inggisɛ angbeka. ");
INSERT INTO utr_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","<<Inggisɛ ndzɛ yi ani bayɔ, kye afɔ twɛsɛ yi ani. Ongwu ngbe ngwikwo yi ani bayɔ, le bulu-bulu. ");
INSERT INTO utr_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","<<Onɔ ngwi onodzi emɛsɛ tɔ mbi inggisɛ, o li lu ivu le ka pita imbe otonya. Ki non tu imbe bayɔ, o li gbɛɛ; <N ka yidɔ lu udɛ ani ogbugbe.> ");
INSERT INTO utr_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Non yɛ ba udan ogbugbe wa di a kyi mɛlu imbe ma dzɛkɛ saan yɔ. ");
INSERT INTO utr_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","O li yɛ lu ka kwu emɛsɛ angbeka egyafa ama ntimbali nghan mani, a ka ba wa kaka sisɛ mi ele. Taman odzɛɛdzɛ mgbi inggisɛ na ka timbi nghaabɔ ogbugbe.>> ");
INSERT INTO utr_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Dafi iYesu le gbɔdzɛ le kɛ nɛ, ongyaa oka mi idzidzɛ ibyi inggisɛ ntona si kyile ela esho gbɛɛ, <<Mse no dzɛ yi ifu ngwi mba abu, bɛyi abɛ ngwi abu ngha nani.>> ");
INSERT INTO utr_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","IYesu nu uka gbɛɛ, <<Nghaduukpaa li inggisɛ nfwo elodzɛ mgbi Imgbasho di kyɔ mi ele yɛyɛ mani ka gbumse.>> ");
INSERT INTO utr_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Dafi ibyi inggisɛ shili kye iYesu wo idzidzɛ nɛ, o gbɛɛ, <<Nɛnɛ li etɔ obube! O le mina ambɛ, kpaa o ka tu onyi ba sede ambɛ mgbi iJona ta. ");
INSERT INTO utr_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Dafi iJona li ambɛ mbi emi iNinive na, li ngha ngwi Ongwɛ Inggisɛ ka li ambɛ mbi etɔ nɛ aani. ");
INSERT INTO utr_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Apodza ongwi aca ka kye afɔ twɛsɛ yi inggisɛ emi etɔ nɛni mi egbe ikwɔ dika nu ma obube, lubana o kyɛ mbi ɛsɛ dondu owa fwo ozoyeye mgbi utɔ iSolomu, dinaa, ongwu nshewo ngha iSolomu dzɛ mmɛnɛni. ");
INSERT INTO utr_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Inggisɛ emi iNinive kpaa ka kye afɔ twɛsɛ yi emi etɔ nɛni mi egbe ikwɔ diyɛ nu ma obube; ikyena a kyatitukwu mi onɔ ngwi a fwo elodzɛ ogbɔɔgbɔ mgbi iJona nani, ma onɛnɛ ongwu nshewo ngha iJona dzɛ aani. ");
INSERT INTO utr_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","<<Inggisɛ onyi nka kye ola dɔ se ka kye da di kye mgboko tukwu ele dzɛma ba. O ka kye fakɛ imbe ododa ngwi ali inggisɛ nkaka duu ka di osa mani. ");
INSERT INTO utr_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Inɛ mgbi abu li ipitila mgbi ewo mgbi abu. Kini inɛ mgbi abu tishi yɔ, ewo mgbi abu duu ka mbwo yi osa. Kpaa kini inɛ mgbi abu tishi bayɔ, ewo mgbi abu kpaa dika mbwo yi iifu. ");
INSERT INTO utr_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Ikyenghanɛ, di gbɛɛ, osa ndzɛ mbi abu no ka li iifu ba. ");
INSERT INTO utr_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Nghanɛ, kini ewo mgbi abu duu mbwo yi osa yi alewo onyi kpaa yifu bayɔ, ka mbwo yi osa dafi osa mgbi ipitila li nu abu osa nɛni.>> ");
INSERT INTO utr_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Ngwi iYesu ngyɛlu odzɛ ogbɔɔgbɔ nɛ, inggisɛ iFarasi wa bɔɔn gbɛɛ no ba wa gye ungwogye mi udɛ mgban; ta o ka sɔkɛ ogye ungwogye. ");
INSERT INTO utr_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Nghaduu inggisɛ iFarasi na, difwi gbɛɛ iYesu sabɔ mi odzɛɛdzɛ aletɔ mgbi ama ba ta, wita ogye ungwogye, nɛ i kwulun ewo. ");
INSERT INTO utr_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Otsɛ iYesu si nyan gbɛɛ, <<Onɛnɛ, ema emi iFarasi li sa ewo alubata yi inunggaa, kpaa mi idzidzɛ mgbi ema yɔ li mbwo yi nggwɔ yi imbali. ");
INSERT INTO utr_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Ema ikwangha inggisɛ ntonɛ! Li ongwu nmɛ idzidzɛ ma, mɛ esɛ kpaa baa? ");
INSERT INTO utr_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Nɛ nu emi adzɛ umba yi itukwu osaan na, ta alungwɔ duu ka dzɛ ema saan. ");
INSERT INTO utr_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","<<Ahoo! Mi ikye ema emi iFarasi, ema li kye onyi mi ikye iwyo ongwi okwɔ mgbi ema duu mbwo yi ungwɔ dafi indzafɛ, atsubo, bɛyi ungwɔ angbeka kye nu Imgbasho. Kpaa ema li kyɔ inggisɛ ogye, Imgbasho di kpaa ema itukwu ba. Li ungwɔ ndzɛ imbisɔ ngwi ema ki tsekise kyɔ duuse angbeka ntona aali. ");
INSERT INTO utr_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","<<Ahoo! Mi ikye ema emi iFarasi, li kpa ema osɔ imbe mmwɛ mi ozu okwakye mgbi emi iJuda di nu ma le ta ema angba yi mmwɛ mi ifyidu. ");
INSERT INTO utr_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","<<Ahoo! Mi ikye ema ama olɔɔlɔ yi emi iFarasi, emi ikpala, ema dzɛ dafi endzi ngwi ambɛ mgban byulu, ngwi inggisɛ li kyikyɛ nyɛ ele kpaa a li difwi ba mani.>> ");
INSERT INTO utr_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Inggisɛ otso ola mgbi iMose oka nun uka gbɛɛ, <<Otsetse, dafi ngwi abu gbɔ ungwɔ ntonɛ nɛ, eyi kpaa abu fya eyi ito.>> ");
INSERT INTO utr_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","IYesu gbɛɛ, <<Ahoo! Mi ikye ema ama otso ola mgbi iMose, ikyekyɛ ema li gbe isɔ gwuba dɔ inggisɛ ikye kpaa ema li kye ongwufabɔ onyi gbo ele ikye oya ma abɔ ba. ");
INSERT INTO utr_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","<<Ahoo! Mi ikye ema, ema mbɛ endzi mgbi ama ogbɛɛsɛ ngwu li emi otsikyema ngwɔ tugbe mani. ");
INSERT INTO utr_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Nɛ ema tso gbɛɛ ungwɔ ngwi a kyɔ na li ayin; a ngwɔ ama ogbɛɛsɛ, ema di mbɛ ma endzi. ");
INSERT INTO utr_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Mi ikyenghanɛ, Imgbasho mi ozoyeye mgban gbɛɛ, <Ani ka dɔ ama ogbɛɛsɛ yi ama ogbikye ani esɔ mboma, angbeka a ka ngwɔ ma diyɛ nu angbeka adzɛ.> ");
INSERT INTO utr_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Nghanɛ, etɔ nɛni a ka kwo ma adɔ mi ikwu mgbi ama ogbɛɛsɛ ngwu a ngwɔ mi owita-wita mgbi ɛsɛ nani. ");
INSERT INTO utr_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Wita mi ikwu mgbi Ebɛl lu ka kaka ikwu iDzakaria, ongwu ma ngwɔn mi idzidzɛ ozu mgbi Imgbasho yi iwashi ofifɛ nani. N nya ema mi otsitsi, a ka kwo etɔ nɛ adɔ mi ungwɔ ntonɛ duu. ");
INSERT INTO utr_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","<<Ahoo! Mi ikye ema ama otso ola, lubana ema kyi kyelu ungwɔ okwulu ofɛ mgbi ozoyeye mgbi Imgbasho. Ema abuema kpaa kaka ba, diyɛ noofɛ gbɛɛ ama nle kaka nu ma kaka ba.>> ");
INSERT INTO utr_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Ngwi iYesu ngyɛlu odzɛ ntonɛ ogbɔɔgbɔ nɛ, o dzata imbe nani, nɛ emi iFarasi yi ama otso ola mgbi emi iJuda wita ole ban ibɛ di kyitingga gbɛɛ no gbɔdzɛ mi ungwɔ gwuba, ");
INSERT INTO utr_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","zukwu ni ama tu ofɛ di nun obube mi odzɛ ama ntɔ mi ondu mbon nli ayin ba mani. ");
INSERT INTO utr_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Ngwi inggisɛ idubu ibyibyi wa kwutokɛ mbonyi nɛ, a sile dzi ewoma afɔ, man iYesu wita ogbɔdzɛ ababɔ nya engwafɔɔn gbɛɛ: <<Kyɔ dumɔɔ yi otsootso mgbi emi iFarasi, ngwi li ɛwɛ nli gbɔfwɛ dafi okwuna mi ibredi nani. ");
INSERT INTO utr_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Onɔ kyɛma ngwi alungwɔ ndzɛ mi odaada duu ka dɔ ododa, ungwɔ ngwi a di kye da duu a ka kye dɛɛsɛ. ");
INSERT INTO utr_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Ungwɔ ngwi abu gbɔ mi iyifu a ka fwo mi osa, ungwɔ ngwi abu di gbɔn mi adɔ mi ifoozu idzidzɛ dika gbela tɔ mi ikyendu. ");
INSERT INTO utr_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","<<N nya ema, emi okani, ka mio ama nka ngwɔ ikpewo ta ka kyɔ unka gbɛ wuba na ba. ");
INSERT INTO utr_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Kpaa n ka tso ema ongwu ema ka mion mani: Mio ongwu, ki non kye ngwɔlu ikpewo, o di dzɛ yi mfye okye abu wokɛ imbe adzɛ nani. Ɛɛn, ani nya ema, mion na. ");
INSERT INTO utr_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","A li kye ifyilo nghi eda gya mi anini efa baa? Nghaduu ifyilo onyi kpaa Imgbasho gblimɔn ba. ");
INSERT INTO utr_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Nghanɛ, otu mi ikye mgbi ema duu Imgbasho ye mmbwon. Ka mio ba na; ema ngha ifyilo ibyibyi. ");
INSERT INTO utr_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","<<Ani nya ema, inggisɛ ta nkyɔ obwɛndɛ mgbi ani mi inɛ inggisɛ yɔ, Ongwɛ Inggisɛ kpaa ka kyɔ obwɛndɛ mgban mi inɛ engyesɔ mgbi Imgbasho. ");
INSERT INTO utr_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Nghaduu inggisɛ ntangwɛ ani mi inɛ inggisɛ yɔ, ongwu kpaa Ongwɛ Inggisɛ ka tangwan mi inɛ engyesɔ mgbi Imgbasho. ");
INSERT INTO utr_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Ali inggisɛ ngbɔdzɛ obube mi ikye Ongwɛ Inggisɛ, a ka dzanta yi obube, kpaa ongwu nfya Onodzi Osaan ito yɔ, a ka dzanta ba. ");
INSERT INTO utr_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","<<Onɔ ngwi a kye ema ba inɛ ikwɔ mi ozu okwakye mgbi emi iJuda bɛyi inɛ emi atɔtsɛ bɛyi inɛ mgbi emi ola ma, no ka kaka ema ewo dafi ema ka na ewema naadi odzɛ ngwi ema ka gbɔ ba. ");
INSERT INTO utr_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Ikyena Onodzi Osaan ka nya ema odzɛ ngwi ema ka gbɔ mi onɔ na mani.>> ");
INSERT INTO utr_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Inggisɛ oka mi ifu ibyi nya iYesu gbɛɛ, <<Otsetse, nya ongwunani no kye ghalu okwudɛ ngwi otseyi dzanta nu eyi nɛ yi ani.>> ");
INSERT INTO utr_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","IYesu si nun uka gbɛɛ, <<Okani, li emɛ nu ani mfye ogbiikwɔ naadi ogha ema okwudɛ?>> ");
INSERT INTO utr_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Ta o nya ma gbɛɛ, <<Gbɛwɛbyi! Ngyo ewema mi ali ofɛ mgbi nggwɔ duu; oshishe mgbi inggisɛ dzɛ mi aludu mgban ba.>> ");
INSERT INTO utr_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Man o nya ma utsa nɛ gbɛɛ: <<Ikpɛsɛ mgbi inggisɛ udza oka tishi ungwogye. ");
INSERT INTO utr_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","O tsɛwɛ mi itukwu mgban gbɛɛ, <Li ekyɛ ngwi ani ka kyɔ? Ani dzɛ yi imbe ngwi ani ka gbe ungwogye mgbi ani to ba.> ");
INSERT INTO utr_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","<<Nɛ o gbɔgbɛɛ, <Li ungwɔ ani ka kyɔ aani. N ka kye bulu emi oba mgbi ani yidɔ mbɛ ama okwukwo, man ani ka gbe ungwogyowe yi okye mgbi ani duu da mi efu. ");
INSERT INTO utr_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Ta n ka nya ewen gbɛɛ, <<Abu dzɛ yi ungwɔ osuse kwuba to nka kye onova ibyibyi. Yile itukwu bɛsɛ; gye, wa diyɛ dzɛ yi atsa.>> > ");
INSERT INTO utr_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","<<Kpaa Imgbasho nyan gbɛɛ, <Abu ikwangha nɛ! Mi otu inɛ nɛni n ka mina oshishe mgbi abu mbi abu. Nɛ li emɛ ka kye gbelu ungwɔ ngwi abu gbe to ikye ewabu nɛ?> ");
INSERT INTO utr_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","<<Li ngha nka dzɛ yi ali inggisɛ ngbe ungwɔ to ikye ewon kpaa li aludu mbi Imgbasho ba aali.>> ");
INSERT INTO utr_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Ta iYesu nya engwafɔɔn gbɛɛ: <<Nghanɛ ani nya ema, no ka kaka ema ewo mi oshishe mgbi ema ba, ungwɔ ngwi ema ka gye, naadi mi ikye ewo mgbi ema, ungwɔ ngwi ema ka wo. ");
INSERT INTO utr_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Oshishe ngha ungwogye, ewo di ngha angwuto. ");
INSERT INTO utr_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Di emi ajaglama: A li kya naadi shɛ ba, a dzɛ yi ozu hona oba okye ungwɔ da ba, nghaduu Imgbasho li byi ma enbwa. Ema dzɛ yi oyabɔ ngha ingwunɔ duu! ");
INSERT INTO utr_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Li emɛ mbi ema mi itukwu oshanyɛ mgban ka yagba ombwo obyi onyi mi oshishe mgban? ");
INSERT INTO utr_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Ma ni itukwu oshanyɛ ka yagba ngyɛlu ungwɔ ogyɛngyɛ ngha ba wali, oyabɔ li ekyɛ onu ewema itukwu shanyɛ mi ungwɔ angbeka? ");
INSERT INTO utr_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","<<Di dafi onggangga oshɛ li she mani. A li kyidɔ naadi gbo ewoma angwuto ba. Nghaduu iSolomu mi okwɔkwɔ mgban nose wewo tishi dafi onyi mbi onggangga ntonɛ ba. ");
INSERT INTO utr_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Ni li ngha ngwi Imgbasho li nu oshɛ mi okwɔ ngwi dzɛ inɛ, ekeka a ka kye toola sunse ma, ka kyɔsinɛse ngwi o ka nghao kye inɛ byi ema ba? Ema ngwu oyɛyɛ onuunu mgbi ema shanyɛ ntonɛni! ");
INSERT INTO utr_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Nghanɛ, no ka kaka ema ewo mi ungwɔ ngwi ema ka gye naadi wa ba; dika dzɛ yi angwodzɛ mi itukwu kpaa ba. ");
INSERT INTO utr_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Bana li ama n ye Imgbasho ba li kyɛdɔ ungwɔ ntonɛni, ma Otsema ye dafi ema mina ungwɔ ntonɛ mani. ");
INSERT INTO utr_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Nghaduu pita esutɔ mgbi Imgbasho ababɔ, ta a ka gbe ungwɔ ntonɛ duu mbwo ema kɛ ele. ");
INSERT INTO utr_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","<<Ka mio ba na, engwafɔ ama okpa ani itukwu, ikyena i mina Otsema okye esutɔ nu ema. ");
INSERT INTO utr_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Gbelu ungwɔ ngwi ema dzɛyan duu gya kye udza gha emi adzɛ. Ema ka tu ungwɔ ama osuse nka li gyegwu, aludu mi esho nka ngyɛ ba, imbe ngwi emumyi ka ba kwɛkwɛ naadi ikwukwu ka kye gye ba mani. ");
INSERT INTO utr_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Lubana imbe ngwi aludu mgbi ema dzɛma, li mmana ngwi itukwu mgbi ema kpaa li dzɛ aali. ");
INSERT INTO utr_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","<<Wewo okyidɔ di nu ipitila mgbi ema le gbɛ, ");
INSERT INTO utr_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","dafi engbidɔ tole fɛ oyɛɛyɛ mgbi ongyukwo mgbi ama mi eba okwokyiikwokyi, ikyegbɛɛ non yɛ wa tsaabɔ ta a ka kwulun ofɛ vla mani. ");
INSERT INTO utr_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Ka sunse mbi engbidɔ onɔ ngwi ongyukwo yɛ tu ma le ngyo mani. N nya ema otsitsi, ongwu abuon ka wewo gbe ma sisɛ kye oga nu ma gye. ");
INSERT INTO utr_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Ka sunse mbi engbidɔ ama ngwu ongyukwo mgbi ama wa tu ma wewo mani, yeba non ba mi idzidzɛ otu naadi mi ikyegbe kpaa. ");
INSERT INTO utr_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Kpaa difwi odzɛ nɛni: Ni otsungwɔ ozu ki ye onɔ ngwi emumyi ka ba yɔ, o kika non gbobun ozu kaka ba. ");
INSERT INTO utr_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Ema kpaa li kyɛmɛ ngwi ema ka wewo, ikyekyɛ Ongwɛ Inggisɛ ka ba mi obyi ngwi ema gbinɛbyi ma ba.>> ");
INSERT INTO utr_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","IPyita byita gbɛɛ, <<Otsɛ, abu le gbɔ utsa nɛ nya eyi yueyi naadi li ali inggisɛ duu?>> ");
INSERT INTO utr_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Otsɛ iYesu si gbɛɛ, <<Li emɛ li ongbidɔ oyɛyɛ di kwiinɛ? Li ongwu ngbeka byi ungwɔ, ngwi ongyukwo kyon dzɛkɛ ikye ogbinɛbyi engbidɔ mgban onu ma ungwogye mi onɔ nwogyɔ mani. ");
INSERT INTO utr_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Ka tishi mbi ongbidɔ ngwu ongyukwo mgban wa tun le kyɔ ngha mi onɔ ngwi o yɛ mani. ");
INSERT INTO utr_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","N nya ema otsitsi, o ka kyon dzɛkɛ ogbinɛbyi ungwɔ mgban duu. ");
INSERT INTO utr_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Nghaduu ni ongbidɔ na nya ewon gbɛɛ, <Ongyukwo mgbi ani le kye onɔ tunto oyɛɛyɛ,> man wita ogbo engyulɔ yi engyiidɔ ibe dile gye yɛ wa fya yɔ. ");
INSERT INTO utr_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Ongyukwo mgbi ongbidɔ na ka yidɔ mi egbe ngwi o kye inɛ byi ma ba bɛyi obyi ngwi o ye ba. O ka non gyisɔ kpakpa di kyon dzɛkɛ imbe mgbi ama onghaadɔ. ");
INSERT INTO utr_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","<<Ongbidɔ ongwu n ye ungwɔ ngwi ongyukwo mgban mina, kpaa wewo ba di kyungwɔ ma bayɔ, a ka gbon onitse kwuba. ");
INSERT INTO utr_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Nghaduu ongwu n ye ba di kyungwɔ ngwi li oyɛyɛ ba, a ka gbon onitse gwee. Mbi ali inggisɛ ngwu a nun kwuba a dika mina kwuba mbon; ongwu a di nun dzii a dika pita mbon dzii. ");
INSERT INTO utr_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","<<Ani ba ɛsɛ nɛ yi ola, ma dafi i dzɛ ani ma kile gbɛ kpaa wa! ");
INSERT INTO utr_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Kpaa ani dzɛ yi iBatisima mgbi isɔ ngwi ani ka wa kaka ele, ma n ka gyisɔ ongwi itukwu nghataa se ka wa ngyɛ. ");
INSERT INTO utr_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Ema tsɛwɛ gbɛɛ ani ba owa kye iyu ba ɛsɛɛ? Ei, n nya ema, li ogha inggisɛ yi ewoma. ");
INSERT INTO utr_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","I wita onɛnɛ nghataa lu iyayi inggisɛ ka li eda mi etɔ onyi a ka gbua yi ewema, eta ka kye afɔ twɛsɛ yi efa, efa dika kye afɔ twɛsɛ yi eta. ");
INSERT INTO utr_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","A ka wa gha yi ewoma, otsɔngwɛ yi ongwan ongyulɔ, ongwongyulɔ yi otsɔn, onɔngwɛ yi ongwan ongwu ongyaa, ongwongyaa yi onɔn, onobongyaa yi owongwaan, owongwɛ yi onoban.>> ");
INSERT INTO utr_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Nɛ iYesu nya ibyi inggisɛ gbɛɛ, <<Onɔ ngwi ema di akpa tseto mi onosa, mi onɔ nata ema li gbɛɛ, <Mmbwo ka wa kya,> man di li kya. ");
INSERT INTO utr_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Ma onɔ ngwi awo ongwi agwudu wa fa, ema li gbɛɛ, <Imbe ka wa dziwu,> man di li dzɛ ngha. ");
INSERT INTO utr_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Ema emi ikpala ntonɛ! Ema ye onu osa mi odzɛɛdzɛ mgbi ɛsɛ bɛyi akpa mi esho. Kyɔsinɛ ngwi ema ye onu osa mi odzɛɛdzɛ ongwi onɛnɛ wuba? ");
INSERT INTO utr_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","<<Kyɔnɛ ngwi ema fwikwɔ abuema mi ungwɔ nli ayin wuba? ");
INSERT INTO utr_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Ni abu le kɛ opiikwɔ yi ongyikyili mgbi abu yɔ, fya kpakpa ni abu yile ide gye yan mi ofɛ, ni abu kyɔ ngha ba, a ka kwo abu ba inɛ inggisɛ ogbiikwɔ, ongwu nka kye abu wo obaka abɔ, ta a sika kye abu wokɛ obawi. ");
INSERT INTO utr_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","N nya abu, o ka tasɛ ba nghataa imbisɔ ngwi abu ka kpa anini mgbi abu ongwi olɛlɛ ngwi a wo abu mani.>> ");
INSERT INTO utr_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Mi onɔ nani, inggisɛ angbeka to imbe na nnya iYesu gbɛɛ di iPlatu ngwɔ emi iGalalia angbeka ni eyi mgbi ama takye yi ifɛ ngwi a le fɛ mani. ");
INSERT INTO utr_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","IYesu si nu uka gbɛɛ, <<Ema tsɛwɛ gbɛɛ emi iGalalia ngwu a ngwɔ ma ngha na nghao li emi ali ibwubwe ngha emi iGalalia angbeka ntonaa? ");
INSERT INTO utr_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Ei, li ngha ba! Kpaa n nya ema, ni ema kyata mi ali ibwubwe mgbi ema bayɔ, ema ka kwulu dafi ama kpaa kwulu nani. ");
INSERT INTO utr_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Inggisɛ iwyodegyata ama nkwulu onɔ ngwi ozu oshigbo mi iSilon gbobu si ma na ma, ema tsɛwɛ gbɛɛ a kyɔ obube ngha angbeka ama nto iJerosalin naa? ");
INSERT INTO utr_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Ei, li ngha ba! Nghaduu n nya ema, ni ema kyata mi ali ibwubwe mgbi ema bayɔ, ema kpaa ka wa dzili duu.>> ");
INSERT INTO utr_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Ta iYesu nya ma utsa nɛ gbɛɛ: <<Inggisɛ oka nose kye ekwɔ ngwi a li kwun di andundu kye ye mi okwɔ mgban. O li ka kpadi gbɛɛ, ni i wa owawa yɔ, kpaa o li tu ba. ");
INSERT INTO utr_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Nɛ o nya inggisɛ nle ngyo okwɔ na gbɛɛ, <I mɛ onova eta ngwi ani le ba wa kpadi ekwɔ nɛ gbɛɛ ni ani tu awawa mi ele, kpaa n tu ba. Kye dzɛ ngwuta! Kyɔsinɛ ngwi o le tukwu imbe?> ");
INSERT INTO utr_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","<<Nghaduu inggisɛ ongyo okwɔ nu uka gbɛɛ, <Ongyukwo, di dzanta onova onyi; n ka tishɛ nyɛ ewon gbe ibwa yawon. ");
INSERT INTO utr_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Ki non wa owawa onova nkyɛ nɛ, tishi! Ni li ngha bayɔ, kye dzɛ ngwuta.> >> ");
INSERT INTO utr_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","IYesu le tsungwɔ mi egbe otonyidɔ mi ozu okwakye mgbi emi iJuda oka, ");
INSERT INTO utr_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","man ongyaa oka dzɛ imbe na ngwu onodzi obube non dotse fulu mɛ onova iwyodegyata, o kilɛ li yagba zunto kpaakpa gbɛ ba. ");
INSERT INTO utr_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Ngwi iYesu din nɛ, o kwun ela ba iyayi si nyan gbɛɛ, <<Ongyaa, a shɛ abu adita mi ootse mgbi abu!>> ");
INSERT INTO utr_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","O kye abɔ gbon, labɔlabɔ nɛta, o si kyato dzɛkunto kpaakpa man le tsɛ Imgbasho. ");
INSERT INTO utr_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Itingga kyɔ inggisɛ okye okwakye teyi gbɛɛ di iYesu ngyɛlu ootse mi egbe otonyidɔ, o si nya inggisɛ ntona gbɛɛ, <<Ali ikyidu dzɛ yi egbe egyin ngwi eyi ka kyidɔ, nghanɛ ba mi egbe ntonɛni, ni a ngyɛlu ema ootse, kpa no ka li egbe otonyidɔ ba.>> ");
INSERT INTO utr_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Otsɛ iYesu nun uka gbɛɛ, <<Ema emi ikpala ntonɛ! Ali inggisɛ mgbi ema li kyi shɛlu mnda naadi itaklimyi mgban mi ifatoba kyen ka weni mi egbe otonyidɔ baa? ");
INSERT INTO utr_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Nghanɛ ongyaa nɛ kyɛ mi etɔ mgbi Abrahan, kpaa iSatan bwan adi mɛ onova iwyodegyata. Wanɛ i tishi gbɛɛ nu ma shan adi mi egbe otonyidɔ ba naadi?>> ");
INSERT INTO utr_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Ngwi iYesu gbɔdzɛ nɛ nɛ, ayiwi kwu engyikyili mgban. Kpaa inggisɛ ntona duu i kpa ma mi ungwɔ okwulewo ngwi o le kyɔ nani. ");
INSERT INTO utr_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Nɛta iYesu byita gbɛɛ, <<Esutɔ mgbi Imgbasho nɛ dzɛ sinɛ? Li ekyɛ ngwi ani ka kye mba yan? ");
INSERT INTO utr_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Dzɛ dafi inɛnɛ nkwodzi, ngwi inggisɛ kye ka fwe mi okwɔ mgban. I she yɛɛ ekwɔ, ingwunɔ li ludɛ mi abɔn.>> ");
INSERT INTO utr_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","IYesu di byita gbɛɛ, <<Li alungwɔ ngwi ani ka kye esutɔ mgbi Imgbasho mba yan? ");
INSERT INTO utr_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Dzɛ dafi ongyaa kye okwuna tablikyi yi ofumbu nshe mi ikpɔkpɔ di bwuo ewon kpatsɛ mani.>> ");
INSERT INTO utr_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Ta iYesu nyɛ igeli-igeli bɛyi agwɔ emi oshɛ le tsungwɔ ngwi o le lu iJerosalin mani. ");
INSERT INTO utr_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Inggisɛ oka byun gbɛɛ, <<Otsɛ, li inggisɛ gwee ta ka watɔɔ?>> O nya ma gbɛɛ, ");
INSERT INTO utr_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","<<Fya mi ofyaafya mgbi ema ni ema kaka mi onufɛ okpenge nani, ikyena inggisɛ kwuba ka fya gbɛɛ nu ma kaka esutɔ mgbi Imgbasho nghaduu a ka yagba ba. ");
INSERT INTO utr_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Otsungwɔ ozu ka kyato yile onufɛ tukwu, ema ka tila to esɛ le tsaabɔ yɛ gbaabɔ gbɛɛ, <Kwulu eyi onufɛ, ongyukwo!> <<Nghaduu o ka nu uka gbɛɛ, <Ani ye ema hona ye imbe ngwi ema tɔkyɛ ba.> ");
INSERT INTO utr_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","<<Ta ema ka gbɛɛ, <Eyi gye diyɛ wa yi abu, abu di tso mi igeli mgbi eyi kpaa!> ");
INSERT INTO utr_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","<<Nghaduu o dika gbɛɛ, <Ani ye ema naadi imbe ngwi ema tɔkyɛ ba. Lu enggengga mbi ani na, ema emi ali ibwubwe ntonɛni!> ");
INSERT INTO utr_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","<<Akwɔ omaama bɛyi aba ogyeegye ka dzɛ imbe nani, onɔ ngwi ema di Abrahan yi Adziki yi iJeko bɛyi ama ogbɛɛsɛ duu mi esutɔ mgbi Imgbasho kpaa ema abuema a ka kye ema ngwuta lu esɛ mani! ");
INSERT INTO utr_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Ibyi inggisɛ ka kyɛ mi onosa yi onɔdɛ, bɛyi aca yi agwudu, dika wa sɔ oga mi esutɔ mgbi Imgbasho. ");
INSERT INTO utr_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Nghanɛ emi olɛlɛ ka yɛɛ emi ababɔ, emi ababɔ dika yɛɛ emi olɛlɛ.>> ");
INSERT INTO utr_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Mi onɔ na emi iFarasi angbeka ba mbi iYesu wa nyan gbɛɛ, <<Dzata imbe nɛ lu imbe oka. IHerude mina ongwɔ abu.>> ");
INSERT INTO utr_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","IYesu si nu ma uka gbɛɛ, <<Kɛ ka nya ogbalinya na gbɛɛ, <N ka dulu emɛsɛ di ngyɛlu ibyi inggisɛ ootse inɛ yi ekeka mi egbe ongwu ta ma, n ka ngyɛlu idɔ mgbi ani.> ");
INSERT INTO utr_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Nghaduu n ka byi ofɛ mgbi ani abɔ inɛ yi ekeka yi egbetanɛ, lubana i tishi gbɛɛ nu ma ngwɔ oyegbɔ mi imbe oka ba li mi iJerosalin ta. ");
INSERT INTO utr_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","<<Ekyi, iJerosalin, iJerosalin, abu nngwɔ ama ogbɛɛsɛ di tsɛ ama ngwu a dɔ ma esɔ mbi abu akwutsɛ, dafi ani gbili okye emi ongwabu kwakye yi eka, dafi onogbi li kwulu engwaan wokɛ asha, kpaa ema nu ani ofɛ ba! ");
INSERT INTO utr_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Dika, a dzita udɛ mgbi ema yɛɛ okwudɛ waana. N le nya ema, ema ka di ani wuba nghataa sede ni ema wa gbɛɛ, <Ogbumse li ongwu nba mi iyi mgbi Otsɛ Imgbasho se.> >> ");
INSERT INTO utr_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Egbe otonyidɔ oka nɛ, iYesu kɛ le ka gye oga mi udɛ mgbi inggisɛ iFarasi imɔ oka, a si kye inɛ fyakwun. ");
INSERT INTO utr_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Nɛta inggisɛ oka ngwu afɔ yi abɔ weeni ba mbi iYesu. ");
INSERT INTO utr_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Nɛ iYesu byi ama otso ola mgbi iMose bɛyi emi iFarasi ita gbɛɛ, <<Ola mgbi eyi noofɛ ongyɛlu ootse mi egbe otonyidɔ naadi i nu ba?>> ");
INSERT INTO utr_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Kpaa a dede shilididi. Ta iYesu byi inggisɛ na abɔ, man o ngyɛlun ootse di dzanta non lu. ");
INSERT INTO utr_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","IYesu si byi emi iFarasi ntona gbɛɛ, <<Ni onyi mbi ema dzɛ yi ongwɛ naadi mnda ngbɛsɛ wokɛ ibuga mi egbe otonyidɔ ma, o ka dulun tɔ plɛ lo?>> ");
INSERT INTO utr_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Nghaduu a yagba nu uka ba. ");
INSERT INTO utr_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Ngwi iYesu difwi dafi ama nba oga ntonɛ le sadu imbe mmwɛ abuoma nɛ, o nya ma utsa nɛ gbɛɛ: ");
INSERT INTO utr_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","<<Ni inggisɛ bɔ abu oga mgbi eba okwokyiikwokyi yɔ, ka sisɛ mi imbe mmwɛ ba. Ikyayina inggisɛ oka nshewo ngha abu kpaa a bɔɔn. ");
INSERT INTO utr_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Ni li ngha, inggisɛ nbɔ ema ma, ka ba wa nya abu gbɛɛ, <Ni abu kye itse mgbi abu nu inggisɛ nɛni.> Ta abu ka tu ayiwi yɛ ka sɔkɛ imbe okwushanyɛ. ");
INSERT INTO utr_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Nghaduu, nu ma bɔ abu oga yɔ, lu ka sɔkɛ imbe ngwi yɛ esɛ tsatsadu mani, ni inggisɛ nbɔ abu wa nya abu gbɛɛ, <Kyato, okani, lu itse ntatase nani.> Ta abu ka dzɛ yi mmwɛ mi inɛ mbi ama ngwu a bɔ ma ntonani. ");
INSERT INTO utr_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Lubana ali inggisɛ nkyile ewon esho duu a ka yilen esɛ. Kpaa ongwu n yile ewon esɛ, a ka kyilen esho.>> ");
INSERT INTO utr_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Ta iYesu si nya inggisɛ nbɔɔn oga na gbɛɛ, <<Ni abu kyɔ oga mi onɔ naadi onɔnɔdɛ, ka bɔ emi okaabu ba naadi emi ongwunabu naadi odo abu hona emi aludu ama nwatse dɔ abu ba; ikyena a ka yidɔ bɔ abu ikye oyilen kpaa abu mkpaa. ");
INSERT INTO utr_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Ni abu kyɔ oga yɔ, bɔ emi adzɛ, yi ama ngbikye tukwu esɛ, yi ama ntummya, yi ama nbinɛ, ");
INSERT INTO utr_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","ta Imgbasho ka kye mse bɛ abu ewo. Ikyekyɛ a ka yagba kpa abu mkpa gbɛ ba, Imgbasho ka yilen kpa abu mi egbe ngwi emi osaan ka kyato mi ikwu mani.>> ");
INSERT INTO utr_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Onɔ ngwi inggisɛ onyi mbi ama nsɔto oga biyan fwo odzɛ nɛ nɛ, o nya iYesu gbɛɛ, <<Inggisɛ nka sɔ oga mi esutɔ mgbi Imgbasho ka gbumse.>> ");
INSERT INTO utr_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","IYesu nyan gbɛɛ: <<Inggisɛ oka nose le kyɔ andɛfɛ oga si bɔ inggisɛ kwuba. ");
INSERT INTO utr_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Ngwi onɔ oga ma wa gyɔ nɛ, o dɔ ongye ogbɛsɔ mgban gbɛɛ no kɛ ka nya ama ngwu ongwu bɔ ma gbɛɛ, <Ba na, lubana alungwɔ duu ngyɛ le fɛ-fɛ wa.> ");
INSERT INTO utr_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","<<Kpaa ama duu wita o nu itɔdzɛ idzidza-dzidza. Ongwu ababɔ nya ongye ogbɛsɔ gbɛɛ, <Ani gya ikpɛsɛ, ma li kyɛmɛ ngwi ani ka ka kpadi. N tɛkyɛ nu abu, nu ani ofɛ.> ");
INSERT INTO utr_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","<<Oka gbɛɛ, <Ani gya mnda efefa imbe eda, n kwa le ka mbadi ma aani. Tsuutsu nu ani ofɛ.> ");
INSERT INTO utr_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","<<Oka di gbɛɛ, <Ani kwa kye ongyaa ofufɛ, nghanɛ n ka yagba kɛ ba.> ");
INSERT INTO utr_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","<<Ongye ogbɛsɔ nɛ yidɔ ka nya ongyukwo mgban odzɛ ntonɛ duu. Ta otsungwudɛ nyɛ yi itingga kpakpa man wo ongye ogbɛsɔ mgban ola gbɛɛ, <Lu emi ingɔfɛ plɛ bɛyi emi abɔfɛ mgbi igeli ka gbe emi adzɛ yi ama ntummya yi ama nbinɛ yi ama ngbikye tukwu esɛ duu ba.> ");
INSERT INTO utr_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","<<Ongye ogbɛsɔ na gbɛɛ, <Ongyukwo, ola ngwi abu wo na ani kyɔ mi ele wa, kpaa imbe ka dzɛ mi ikye inggisɛ angbeka.> ");
INSERT INTO utr_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","<<Nghanɛ ongyukwo nya ongye ogbɛsɔ gbɛɛ, <Tasɛ lu emi onɔɔfɛ bɛyi ayɛ ofɛ ka bɔ ali inggisɛ ngwu abu di duu nu ma ba, zukwu ni udɛ mgbi ani mbwo. ");
INSERT INTO utr_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","N nya ema, inggisɛ ama ngwu ani plɛ bɔ ma ntona onyi kpaa ka ta oga mgbi ani kpanɛ ba!> >> ");
INSERT INTO utr_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Ibyi inggisɛ wafɔ yi iYesu le kɛ, man o kyata nya ma gbɛɛ: ");
INSERT INTO utr_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","<<Inggisɛ ntangwɛ otsɔn yi onɔn, owan yi ɛngbɛ mgban, emi ongwunɔn engyulɔ yi engyaa naadi oshishe mgban bayɔ, o ka li ongwafɔ mgbi ani ba. ");
INSERT INTO utr_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Inggisɛ ndi kye ekwatsi mgban kyɛdɔ ani bayɔ, o ka li ongwafɔ mgbi ani ba. ");
INSERT INTO utr_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","<<Ni i dzɛ gbɛɛ onyi mbi ema mina o mbɛ ozu oshigbo yɔ, o ka plɛ sisɛ kyɔ mmbwo mi ungwɔ ngwi i ka kyen ombɛ ozu ma ngyɛ baa? ");
INSERT INTO utr_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Bana ki non wo itozu kpaa di yagba ngyɛlu bayɔ, ali inggisɛ ndi duu ka shan isha ");
INSERT INTO utr_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","gbɛɛ, <Amu nɛ kwaabɔ ombɛɛmbɛ kpaa yagba ngyɛlu ba.> ");
INSERT INTO utr_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","<<Naadi li ali utɔ nle ka gblika yi utɔ oka. Ka tsekise sisɛ tsɛwɛ ki non ka yagba yi engyilika nghi idubu iwyo oka gblika yi utɔ ndzɛ yi engyilika nghi idubu osu ba? ");
INSERT INTO utr_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Non ka yagba ba, o ka dɔ ama ogbɛsɔ mgban nu ma ka yile ide gye ngwu ma ka dzɛ mbombo yi ama mani. ");
INSERT INTO utr_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Nghanɛ, inggisɛ mgbi ema ta nkye alungwɔ mgban duu nu ba, o ka li ongwafɔ mgbi ani ba. ");
INSERT INTO utr_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","<<Mmwaa tishi, kpaa ni mmwaa fyumfya wuba ma, a ka kyɔsinɛse non di fyumfya dafi mmwaa? ");
INSERT INTO utr_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Dika tishi mi ikpɛsɛ naadi ogbagye ibwa wuba; a ka kye yangwuta. <<Inggisɛ ndzɛ yi adɔ yɔ, otsungwɔn no fwo.>> ");
INSERT INTO utr_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Egbe oka nɛ, ama ogbɛ udza ifyɛɛ bɛyi emi ali ibwubwe wa kwakye ikye ofwo iYesu. ");
INSERT INTO utr_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Nghaduu emi iFarasi bɛyi ama otso ola mgbi iMose wita okwondukwɔ gbɛɛ, <<Inggisɛ nɛ gbela yi emi ali ibwubwe diyɛ le gye ungwogye yi ama kpaa!>> ");
INSERT INTO utr_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Nɛ iYesu nya ma utsa sini: ");
INSERT INTO utr_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","<<Ni inggisɛ oka mbi ema dzɛ yi mmala nghi ideli onyi ma onyi byulu mi efu, li ekyɛ ngwi o ka kyɔ? O ka dzata ngwusenɛ dɔn iwyo diwyegyanɛ ntona mi imbe ododa lu ka pita onyi nbyulu na nghataa se non tuun baa? ");
INSERT INTO utr_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Onɔ ngwi o ka tuun ma, o ka tsatsa kye dɔkɛ olubɔ ");
INSERT INTO utr_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","le lu udɛ. Non wa to udɛ, o ka kwu emi okan bɛyi ama nwotsuudɛ dɔn ela gbɛɛ, <Tsatsa yi ani na; ikyekyɛ ani ka tu mmala nbyulu ma wa.> ");
INSERT INTO utr_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","N nya ema gbɛɛ mi itɔ ofɛ nɛ kpɔɔ atsa ka dzɛ esho kwuba mi ikye inggisɛ alobube onyi nkyata luba mbi Imgbasho ngha inggisɛ ama osaan ngwusenɛ dɔn iwyo diwyegyanɛ ngwu mina okyata ba ntonani. ");
INSERT INTO utr_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","<<Naadi ni ongyaa dzɛ yi anini nghi iwyo onyi byulu mi ele ma o ka kyɔsinɛ? O ka kye ipitila dɔ kyi waalu ozu di pita yi ɛwɛ ogbebyi nghataa se non di baa? ");
INSERT INTO utr_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Onɔ ngwi o ka tu ma, o ka kwu emi okan bɛyi ama nwotsuudɛ dɔn ela gbɛɛ, <Tsatsa yi ani na ikyekyɛ ani ka tu anini nbyulu ma wa.> ");
INSERT INTO utr_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Mi itɔ ofɛ nɛ kpɔɔ, n nya ema, atsa ka dzɛ mi inɛ engyesɔ mgbi Imgbasho mi ikye inggisɛ alobube onyi nkyatitukwu mani.>> ");
INSERT INTO utr_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","IYesu di kiyayi gbɛɛ: <<Inggisɛ oka nose dzɛ yi engwengyulɔ nghi efa. ");
INSERT INTO utr_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Ongwu ongbungbɛ nya otsɔn gbɛɛ, <Otsani, kye okwudɛ ndzɛ mi ikye mgbi ani ma nu ani.> Nɛ otsɔn si kye ghalu okwudɛ nu engwaan efa ntonani. ");
INSERT INTO utr_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","<<Egbe nyɛ gwee ta, ongwan ongwu ongbungbɛ si kye gbelu alungwɔ mgban. O kyato lu ɛsɛ mbombo mi imbe na ma, o kye mbelu awuya mgban duu mi oshishe ayayi. ");
INSERT INTO utr_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Onɔ ngwi o kye mbelu alungwɔ duu nɛ, okɔtɔndzi enbwa kaka ɛsɛ na duu, man o yɛɛ abubɔ yi unkonyi ogyeegye ba. ");
INSERT INTO utr_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Nɛ o kɛ oka kyɔ inggisɛ oka idɔ mi ɛsɛ nani, inggisɛ na kyon dɛsɔ lu okwɔ mgban oka kye inɛ byun obyia. ");
INSERT INTO utr_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","O mina gbɛɛ ongwu ki gye ungwogye ngwi obyia ntona le gye mani, kpaa inggisɛ nun unkonyi non gye ba. ");
INSERT INTO utr_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","<<Mi onɔ ngwi o wa yile itukwu bɛsɛ nɛ, o gbɔ yi ewon gbɛɛ, <Mi udɛ, ama okyɔ otsani idɔ kpaa a dzɛ yi ungwogye ogyeegye gyɔloma, ma mmɛnɛ ani le kwulu enbwa! ");
INSERT INTO utr_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","N ka yɛ lu udɛ mbi otsani ka nyan gbɛɛ: Otsɛn, ani kyɔ Imgbasho obube yi abu. ");
INSERT INTO utr_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Nghanɛ ani mɛ gyɔ ngwi a ka kwu ani gbɛɛ ongwabu wuba; nu ani yɛɛ dafi emi idɔ mgbi abu mani.> ");
INSERT INTO utr_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Man o kyato yɛ lu mbi otsɔn. <<Nghaduu ngwi o ka kyɛ mbombo mani, otsɔn din ta elela kyɔn won; o tsinya ka tsɛkwulu ongwan, si kwokyi ondu yan. ");
INSERT INTO utr_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","<<Ongwan si nyan gbɛɛ, <Otsɛn, ani kyɔ Imgbasho obube yi abu, nghanɛ ani mɛ ngwi a ka kwu ani di ongwabu wuba.> ");
INSERT INTO utr_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","<<Kpaa otsɔn kwu ongbidɔ mgban ela gbɛɛ, <Vla! Ka kye angwuto ntishi ngha mi ozu kye wa won. Kye ongwashi won ongwufabɔ yi okpafɔ won afɔ. ");
INSERT INTO utr_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Lu ka kye andɛfɛ mnda ongyulɔ wa ngwɔlu ni eyi gye di tsatsa. ");
INSERT INTO utr_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Ikyena ongwani nɛ kwulu kpaa onɛnɛ o dzɛ oshishe; o byulu kpaa onɛnɛ a din.> Ta a wita oga. ");
INSERT INTO utr_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","<<Mi onɔ na, ongwan ongwu ongyukwo nose dzɛ okwɔ. Ngwi o yɛ wa to ondu udɛ nɛ, o fwo ungwɔ ogboogbo yi ifwe. ");
INSERT INTO utr_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Nghanɛ o si kwu ongbidɔ oka ela byun gbɛɛ, <Li alungwɔ le kiyayi?> ");
INSERT INTO utr_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","O nun uka gbɛɛ, <Ongwunabu yidɔ luba udɛ, otsabu kye ngwɔlu andɛfɛ mnda ikyekyɛ o yɛ ise.> ");
INSERT INTO utr_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","<<Ongwunɔn ongwu ongyukwo si kyitingga kpakpa gbɛɛ ongwu ka kaka udɛ wuba. Otsɔn tasɛ wa tɛkyɛ nun gbɛɛ non kaka. ");
INSERT INTO utr_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Kpaa o nu otsɔn uka gbɛɛ, <Di! Onova ntonɛ duu ani kyɔ abu idɔ dafi ofyɛɛ mani, ma akponyi kpaa ani ngha abu adɔ ye ba. Nghaduu abu nu ani ongwɛ mndɔ kpaa gbɛɛ nin kyɔ oga yi emi okɛɛn ba! ");
INSERT INTO utr_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Kpaa onɔ ngwi ongwabu nɛ kye mbelu ungwɔ mgbi abu duu yi owagbai engyaa yɛ luba udɛ nɛ, abu ngwɔn andɛfɛ mnda!> ");
INSERT INTO utr_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","<<Otsɔn si nun uka gbɛɛ, <Ongwani, abu dzɛ yi ani alonɔ duu, ma alungwɔ ngwi ani dzɛyan duu li mgbi abu. ");
INSERT INTO utr_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Nghaduu dzɛ mbisɔ ngwi eyi ka gye oga di tsatsa, ikyekyɛ ongwunabu kwulu, kpaa onɛnɛ o dzɛ oshishe; o byulu kpaa onɛnɛ a din.> >> ");
INSERT INTO utr_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","IYesu nya engwafɔɔn gbɛɛ: <<Inggisɛ udza oka nose dzɛ o dzɛ yi ongyukwiidɔ ngwu kye inɛ le byun udza. Ta a kwu ongyukwiidɔ nɛ elikwɔ mbi otsungwudɛ mgban gbɛɛ o le gyon awuya. ");
INSERT INTO utr_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Nghanɛ, o kwun ela, nyan gbɛɛ, <Li ali odzɛ ngwi ani le fwo mi ikpewo abu ngha? Lɔlu ungwɔ mgbi ani ama nbyito abɔ abu tsatsadu wa nin, ikyekyɛ abu mɛ okye inɛ byi ani ungwɔ wuba.> ");
INSERT INTO utr_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","<<Ongyukwo idɔ na yɛ gbɔ yi ewon mi itukwu gbɛɛ, <Ani ka kyɔsinɛ onɛnɛ, ngwi otsungwudɛ mgbi ani le nya yi ani idɔ nɛ? Ani dzɛ yi mfye mɛ oshookwɔ ba, ayiwi li kwu ani obibɔ. ");
INSERT INTO utr_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Ani ye ungwɔ ngwi ani ka kyɔ wa, ikyegbɛɛ nu ma wa nya yi ani idɔ mmɛnɛ kpaa, inggisɛ ka gbɛ ani mi udɛ mgbi ama mani.> ");
INSERT INTO utr_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","<<Ta o kwu ama ngye mkpa mbi otsungwudɛ mgban ela onyonyi, o byi ongwu ababɔ gbɛɛ, <Abu gye mkpa mbi otsungwudɛ mgbi ani mɛ sinɛ?> ");
INSERT INTO utr_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","<<O nyan gbɛɛ, <Li ikpɔkpɔ engyie olivi ideli egyata.> <<Ongyukwo idɔ na nyan gbɛɛ, <Kye afɛ mkpa mgbi abu na sisɛ vla, lɔ ideli enɛ.> ");
INSERT INTO utr_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","<<O diyɛ byi ongwu fan gbɛɛ, <Abu ma, o gye mkpa sinɛ?> <<O gbɛɛ, <Li oba alakama (ndzɛ dafi itsikapa nani) idubu onyi.> <<Ongyukwo idɔ na nyan gbɛɛ, <Kye afɛ mkpa mgbi abu, lɔ ideli egyata.> ");
INSERT INTO utr_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","<<Otsungwudɛ na tsɛ ongyukwiidɔ ndzɛ yi otsitsi ewo ba na ikyekyɛ o kyungwɔ mi inɛ okwuukwu. Bana inggisɛ emi ɛsɛ ongwi onɛnɛ nghao ye ogbɛwɛbyi ungwɔ mgbi ama ngha inggisɛ emi osa.>> ");
INSERT INTO utr_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","IYesu kiyayi gbɛɛ, <<N le nya ema, kye aludu ngwi abu dzɛyan kwu uka yi inggisɛ mi ɛsɛ nɛni, ikyegbɛɛ ni i wa dzɛma wuba kpaa, a ka gbɛ ema mi udɛ ogyegwu. ");
INSERT INTO utr_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","<<Inggisɛ ongwu ndzɛ yi oyɛyɛ mi ungwɔ ogyɛngyɛ ma, o ka dzɛ yi oyɛyɛ mi ungwɔ okwukwo kpaa, inggisɛ n yagba kye inɛ byi ungwɔ ogyɛngyɛ saan ba, ungwɔ okwukwo kpaa o ka yagba kye inɛ byin saan ba. ");
INSERT INTO utr_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Nɛ kini ema di dzɛ yi oyɛyɛ mi aludu ongwi ɛsɛ nɛ ba, li emɛ ka kye awuya otsitsi ongwi nkyɛ mbi Imgbasho wo ema abɔ? ");
INSERT INTO utr_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ma ni ema di dzɛ yi oyɛyɛ mi ungwɔ mgbi inggisɛ oka ba ma, li emɛ ka kye ungwɔ mgban kye nu ema gbɛɛ no yɛɛ mgbi ema? ");
INSERT INTO utr_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","<<Ongbidɔ onyi ka yagba kyɔ engyukwo efa idɔ ba. Lubana o ka di onyi tanyi diyɛ di oka kpan itukwu, hona o ka gha yi onyi yɛ lu ka bɛkɛ yi oka. Ema ka yagba kyɔ Imgbasho idɔ bɛyi udza ononyi gbɛ ba.>> ");
INSERT INTO utr_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Mi onɔ ngwi emi iFarasi, ama ngwu udza kpa ma kpakpa fwo odzɛ nɛ duu mata, a wita onyan odzɛ agya. ");
INSERT INTO utr_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","IYesu nya ma gbɛɛ, <<Ema li ama nfwo ewema ikwɔ gbɛɛ di ema le saan mi inɛ inggisɛ, nghaduu Imgbasho ye itukwu mgbi ema. Bana ungwɔ ndzɛ yi mmwɛ mbi inggisɛ ma li ungwɔ idza mi inɛ Imgbasho. ");
INSERT INTO utr_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","<<Ola mgbi iMose bɛyi ungwɔ ama ngwi ama ogbɛɛsɛ lɔ ma a gbɔn nghataa ba onɔ mgbi iJɔn okyɔ iBatisima. Wita mi onɔ na, a le gbɔ Esɔ Osuse mgbi esutɔ mgbi Imgbasho, ali inggisɛ duu le kaka ele mi mfyumfye. ");
INSERT INTO utr_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Sunɔ ba onu esho yi esɛ byulu ngha onu ambɛ onyi byulu mi ola. ");
INSERT INTO utr_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","<<Ali inggisɛ ngwu gha yi owan yɛ lu ka kye ongyaa oka yɔ, li amah ngwi o le kyɔ, inggisɛ nkye ongyaa ngwu gheeba yi oban le kyɔ amah. ");
INSERT INTO utr_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","<<Inggisɛ udza oka nose dzɛ nli wo angwuto omuma shinishini di tishi ndlɛndlɛ, o di dzɛ mi oshishe omyɛɛ-myɛɛ alegbe-alegbe. ");
INSERT INTO utr_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Mi onufoka mgban a li kye inggisɛ obibɔ ba wa lakɛ, o saasu ewo a li kwun di iLadzaru, ");
INSERT INTO utr_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","o li mina ogye ambulu ungwogye ama nli ngwuta mi adinyatsɛ ogye ungwogye mgbi inggisɛ udza nani. Obwe li ba wa kpanan ifwa. ");
INSERT INTO utr_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","<<Ta inggisɛ obibɔ na wa kwulu, engyesɔ emi esho kyon lu mi iyayi Abrahan. Inggisɛ udza na kpaa wa kwulu, a kyon ndzi. ");
INSERT INTO utr_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","O lu udola (ihade) ka dzɛ mi isɔ kpakpa, o kyile inɛ esho si di Abrahan mbombo, iLadzaru sɔdzɛ yan. ");
INSERT INTO utr_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","O kwun ela kɛ gbɛɛ, <Abrahan Otsɛn, di ani elela dɔ iLadzaru esɔ no kye ongwufabɔ bakɛ eni wa yulu ani idɛ, bana n dzɛ mi isɔ okwulewo mi ola nɛni!> ");
INSERT INTO utr_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","<<Nghaduu Abrahan nyan gbɛɛ, <Ongwani, wɛ mi onɔ ngwi abu dzɛ oshishe, abu tu ungwɔ ama osuse-osuse, nghaduu iLadzaru tu ungwɔ ama obube, nghaduu onɛnɛ o sɔ kpan, kpaa abu yɔ dzɛ mi isɔ kpaakpaa. ");
INSERT INTO utr_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ongyɛɛngyɛ mgbi ungwɔnɛ duu, ikplishɛ ladzɛ mi idzidzɛ mgbi eyi, ongwi inggisɛ oka ka fa kɛ mbi oka gbɛ ba.> ");
INSERT INTO utr_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","<<Ta inggisɛ udza na nu uka gbɛɛ, <N tɛkyɛ nu abu, Abrahan otsɛn, dɔ iLadzaru esɔ kɛ udɛ otsani, ");
INSERT INTO utr_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","bana ani dzɛ yi engwunani mgbi ifu engyulɔ nghi eda toma. No kɛ ka kwo ma adɔ ikye onu ma ka ba imbe isɔ owulewo nɛ ba.> ");
INSERT INTO utr_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","<<Abrahan nu uka gbɛɛ, <Emi engwunabu dzɛ yi ola mgbi iMose bɛyi afɛ mgbi ama ogbɛɛsɛ okwo ma adɔ, nu ma fwo ma.> ");
INSERT INTO utr_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","<<Inggisɛ udza na gbɛɛ, <Ei, otsani Abrahan, nana ta ka mɛ ba. Kpaa ni inggisɛ oka kyato mbi emi ikwukwɔ yɛ kɛ mboma ta a ka kyatitukwu mi ali ibwubwe mgbi ama.> ");
INSERT INTO utr_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","<<Abrahan gbɔ yan gbɛɛ, <Kini a fwo ola mgbi iMose bɛyi afɛ mgbi ama ogbɛɛsɛ bayɔ, ni inggisɛ oka kyɛɛ mbi emi ikwukwɔ kpaa a ka nu itukwu mi ele ba.> >> ");
INSERT INTO utr_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","IYesu nya engwafɔɔn gbɛɛ: <<Ungwɔ ama nli nu inggisɛ kyɔ obube ma li kyɛmɛ a ka ba, nghaduu ahoo mi ikye inggisɛ ngwu ungwɔ obube ntonɛ nyɛ mbon ba mani. ");
INSERT INTO utr_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","I tatase nu ma kye ikwɔɔ shaan onbukwɔ kyon ngwuta mi ekyoo okwukwo ngha non nu onyi mi idzidzɛ ɛngbɛ ntonɛ kyungwɔ obube. ");
INSERT INTO utr_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Nghanɛ, gbɛwɛbyi ewema na. <<Ni ongwunabu kyungwɔ obube, fwa yan, ki non kyatitukwu yɔ, dzanta yi obube mgban. ");
INSERT INTO utr_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Ki non kyɔ abu ungwɔ obube akpe egyafa mi egbe onyi, diyɛ ba mbi abu akpe egyafa gbɛɛ, <Ani kyatitukwu yɔ,> dzanta yi obube mgban.>> ");
INSERT INTO utr_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Ama ogbikye iYesu nyan gbɛɛ, <<Mbwo eyi oyɛyɛ onuunu!>> ");
INSERT INTO utr_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Otsɛ iYesu si gbɛɛ, <<Ni oyɛyɛ mgbi ema le gyɛngyɛ dafi inɛnɛ nkwodzi yɔ, ema ka nya ita ulɔ nɛ gbɛɛ, <Kwɔlu ewabu yi akpa, kye ewabu ka kwokɛ mi ekyoo okwukwo,> ta o ka fwo ema. ");
INSERT INTO utr_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","<<Kyi kye gbɛɛ onyi mbi ema dzɛ yi ongbidɔ nle shin okwɔ naadi le kye inɛ byin ifyungwɔ. O ka nya ongbidɔ na mi onɔ ngwi o kyɛɛ okwɔ ma gbɛɛ, <Ba i kɛ ka sisɛ gye ungwogye onɛnɛɛ>? ");
INSERT INTO utr_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Ungwɔ ka dzɛ ngha ba, o ka gbɛɛ, <Kyɔ ungwogye ngwi ani ka gye mi otu nɛni, kye angwuto wo ewo, fɛ ni ani gye di wa ta, abu ka wa gye mgbi abu olɛlɛ baa>? ");
INSERT INTO utr_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Ongyukwo na ka ta ongbidɔ na angba mi ikyegbɛɛ di o kyungwɔ ngwi o nyan gbɛɛ non kyɔ maa? ");
INSERT INTO utr_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Mbi ema kpaa, li ngha ndzɛ aali, mi onɔ ngwi ema kyungwɔ ngwi a wo ema duu ma, gbɔ na gbɛɛ, <Eyi li ɛngbɛ ama okyidɔ, eyi mɛ ogbɛ umba ba, eyi kyidɔ ongwi i wo imbisɔ ngwi eyi ka kyɔ mata.> >> ");
INSERT INTO utr_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Ngwi iYesu tɔ ofɛ le kɛ iJerosalin nɛ, o nyɛ otsee mgbi iSamaria bɛyi iGalalia. ");
INSERT INTO utr_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Dafi o le kɛ oka kaka agwɔ oka nɛ, emi otsoma nghi iwyo si tun. A kwulɛsɛ mbombo ");
INSERT INTO utr_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","si kwun ela mi ela okwukwo gbɛɛ, <<iYesu, Ongyukwo, di eyi elela!>> ");
INSERT INTO utr_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Dafi iYesu di ma nɛta, o nya ma gbɛɛ, <<Lu na, ka kye ewema tso ama ofifɛ mgbi Imgbasho.>> Ngwi a tɔ ofɛ le kɛ nɛta, otsoma gbosa loma. ");
INSERT INTO utr_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Onyi mi idzidzɛ mgbi ama di dafi otsoma gbosa lon nɛta, o yidɔ ba le tsɛ Imgbasho mi ela okwukwo. ");
INSERT INTO utr_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","O ba wa lakɛ esɛ mi iyayi iYesu yɛ tan angba. O li inggisɛ iSamaria. ");
INSERT INTO utr_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","IYesu byita gbɛɛ, <<Li inggisɛ iwyo ngwu otsoma gbosa loma baa? Inggisɛ egyanɛ ntona kɔ? ");
INSERT INTO utr_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Inggisɛ onyi kpaa yidɔ o wa tsɛ Imgbasho ba se li ingyoga nɛ taa?>> ");
INSERT INTO utr_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Man o nyan gbɛɛ, <<Kyato lu, oyɛyɛ onuunu mgbi abu nu abu watɔ.>> ");
INSERT INTO utr_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Emi iFarasi angbeka byi iYesu ita onɔ ngwi esutɔ mgbi Imgbasho ka ba mani, o nu ma uka gbɛɛ, <<Esutɔ mgbi Imgbasho ka ba dafi ema gbe inɛ byi na ba, ");
INSERT INTO utr_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","naadi inggisɛ ka gbɛɛ, <O dzɛ na, hona o dzɛ aali ba,> bana esutɔ mgbi Imgbasho dzɛ mi idzidzɛ ema.>> ");
INSERT INTO utr_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Nghanɛ o nya engwafɔɔn gbɛɛ, <<Onɔ kyɛma ngwi ema ka mina odi egbe onyi mi egbe mgbi Ongwɛ Inggisɛ, kpaa ema ka di ba. ");
INSERT INTO utr_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Inggisɛ angbeka ka nya ema gbɛɛ, <O dzɛ aali!> Naadi <O dzɛ na!> Nghaduu ka yama kyɛdɔ ma ba. ");
INSERT INTO utr_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Dafi mmbwo li naabɔ ni esho agya onyi gbosa nghataa ka tɔ agya oka nɛ, li ngha ngwi egbe mgbi Ongwɛ Inggisɛ kpaa ka dzɛ aali. ");
INSERT INTO utr_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Kpaa ababɔ adzɛ ka kyɔn mi ungwɔ kwuba kyɛmɛ, etɔ emi onɛnɛ dika fwan. ");
INSERT INTO utr_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","<<Dafi i dzɛ mi egbe mgbi iNua nani, li ngha nka wa dzɛ mi egbe ngwi Ongwɛ Inggisɛ ka yɛ ma aali. ");
INSERT INTO utr_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Ali inggisɛ duu le gye yɛ wa, engyulɔ le kye engyaa, a kye engyaa le nu eba nghataa ba mi egbe ngwi iNua kaka uwaa okwukwo nani. Ta eni ayɔ ba wa dzili ma duu. ");
INSERT INTO utr_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","<<Di li ungwonyi dafi mi onɔ mgbi iLoti mani. Ali inggisɛ tole gye yɛ wa, a tole kyummya, le kya etɔ dile mbɛ ozu. ");
INSERT INTO utr_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Kpaa mi egbe ngwi iLoti tasɛ mi ogalu iSodon ma, ola bɛyi enotse nli nu ola gbɛ mfyumfye kya mi esho ba esɛ wa dzili ma duu. ");
INSERT INTO utr_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","<<Li ngha nka dzɛ mi egbe ngwi a ka kye Ongwɛ Inggisɛ tso ma aali. ");
INSERT INTO utr_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Mi egbe na, inggisɛ ndɔdzɛ ikyendu mgban no ka tashulu ba ikye owa gbelu okye mgban mi ozu ba. Ka li ungwonyi yi inggisɛ ndzɛ okwɔ, no ka yɛ ba udɛ owa kye unkonyi ba. ");
INSERT INTO utr_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Wɛ ungwɔ nkyɔ owa iLoti nani. ");
INSERT INTO utr_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Ali inggisɛ nmina odzɛ oshishe yɔ, oshishe mgban ka byulu, ongwu ndzata oshishe mgban gbɛɛ no byulu yɔ, ka yɛ tun. ");
INSERT INTO utr_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","N nya ema mi otu nani, inggisɛ efa ka lato akwulo onyi; a ka kyi kyelu onyi dzata oka. ");
INSERT INTO utr_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Engyaa efa ka tole kpinangwɔ yi ewoma mi ikwɔɔ; a ka kyelu onyi dzata oka.>> ");
INSERT INTO utr_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","(Inggisɛ efa ka to okwɔ; a ka kyi kyelu onyi dzata oka.) ");
INSERT INTO utr_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Engwafɔ mgbi iYesu si byun gbɛɛ, <<Li mi ole, Otsɛ?>> O nu ma uka gbɛɛ, <<Li imbe ngwi ungwɔ ikwukwɔ la ma ngwi mpo li kwakye aali.>> ");
INSERT INTO utr_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Nɛ iYesu nya engwafɔɔn utsa otso ma gbɛɛ nu ma le bibɔ alonɔ, nu ma ka ndɛ ba. ");
INSERT INTO utr_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","O gbɛɛ: <<Mi ogalu oka ma inggisɛ ogbiikwɔ oka dzɛ nli mio Imgbasho hona kye inggisɛ wuuta ba. ");
INSERT INTO utr_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Nɛ owakwadɛ oka dzɛ mi ogalu na nli ba mbon le tɛkyɛ mi ikye emyɛmyɛ mgban gbɛɛ, <Ya ani abɔ mi ikye inggisɛ ngwu kwokyi odzɛ yi ani nɛni.> ");
INSERT INTO utr_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","<<Onɔ she ngwi ongye ogbiikwɔ na fwa okyungwɔ mi ele. Nghaduu mi ongyɛɛngyɛ nɛ, o gbɔ yi ewon gbɛɛ, <Dafi ngwi ani li mio Imgbasho hona kye inggisɛ wuuta ba nɛ kpaa, ");
INSERT INTO utr_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","mi ikye okakewo ngwi owakwadɛ nɛ kale nu ani nɛ, n ka di mi ele azukwu no tu emyɛmyɛ mgban. Ni ani kyɔ ba, o ka nin ndɛngyɛ yi okakewo mgban oba alonɔ nɛni!> >> ");
INSERT INTO utr_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Man Otsɛ iYesu gbɛɛ, <<Gadɔ mi odzɛ ngwi ongye ogbiikwɔ ebɛbɛ na gbɔ mani. ");
INSERT INTO utr_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Nghanɛ Imgbasho ka yagba gbiikwɔ emyɛmyɛ wo emidan, ama nle makwɔ yan otu yi onɔ le mina abɔ oyaaya nɛ baa? O ka kiyayi ofwɔ ma ngwutaa? ");
INSERT INTO utr_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","N nya ema, o ka di gbɛɛ a tu emyɛmyɛ plɛ jo. Nghaduu, onɔ ngwi Ongwɛ Inggisɛ ka yɛ ma, o ka tu oyɛyɛ onuunu mi ɛsɛ nɛ joo?>> ");
INSERT INTO utr_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","IYesu diyɛ gbɔ utsa nɛ nya ama ndzɛ yi abɔ otsigɛgɛ gbɛɛ ama le saan yuoma, di kye angbeka wuuta ba ma gbɛɛ ");
INSERT INTO utr_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","<<Inggisɛ efa kɛ ozu okwukwo osunu Imgbasho mi iJerosalin oka bibɔ. Onyi li inggisɛ iFarasi, oka li inggisɛ ogbɛ udza ifyɛɛ. ");
INSERT INTO utr_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Inggisɛ iFarasi na kwuzunto le bibɔ mi ikye ewon gbɛɛ: <Imgbasho, ani ta abu angba ikyegbɛɛ ani dzɛ dafi inggisɛ angbeka ba; dafi ama ofofɛ yi emi ali ibwubwe yi emi amah hona dafi inggisɛ ogbɛ udza ifyɛɛ nɛ ba. ");
INSERT INTO utr_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Ani li tukwondu akpe efa mi ikyidu onyi, ani di li nu Imgbasho onyi mi ikye iwyo mi alungwɔ ngwi ani tu duu.> ");
INSERT INTO utr_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","<<Kpaa inggisɛ ogbɛ udza ifyɛɛ na dzɛkɛ fyata, o yagba kyile inɛ esho kpaa ba, o kye abɔ mgban bɛkɛ igɛgɛ si gbɛɛ, <Imgbasho, di ani elela, ani li inggisɛ alobube.> ");
INSERT INTO utr_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","<<N nya ema gbɛɛ inggisɛ nɛ lu udɛ mgban yi emyɛmyɛ mi inɛ Imgbasho ngha inggisɛ oka nani. Bana ali inggisɛ ta nkyile ewon esho a ka yilen esɛ, ongwu ndi yile ewon esɛ a ka kyilen esho.>> ");
INSERT INTO utr_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Inggisɛ gbe ɛngbɛ ama oshilɛlɛ ba mbi iYesu ikye no wa kye abɔ gbo ma. Ngwi engwafɔɔn di ngha nɛta, a kwɔ ma oba mbon. ");
INSERT INTO utr_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Kpaa iYesu kwu ɛngbɛ ntona ela ba mbon si gbɛɛ, <<Dzata ɛngbɛ ntonɛ nu ma ba mbi ani, ka kwɔ ma ba, lubana esutɔ mgbi Imgbasho dzɛ ikye itɔ ntonɛni. ");
INSERT INTO utr_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","N le nya ema otsitsi, ali inggisɛ ngbɛ esutɔ mgbi Imgbasho dafi ongwongbɛ ba ka kaka ele ba.>> ");
INSERT INTO utr_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Ongyukwo oka ogbe inggisɛ teyi byi iYesu ita gbɛɛ, <<Otsetse osuse, li alungwɔ ngwi ani ka kyɔ kyɛmɛ se n ka tu oshishe igyegwu?>> ");
INSERT INTO utr_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","IYesu byun gbɛɛ, <<I kyɔsinɛse ngwi abu le kwu ani di osuse? Inggisɛ onyi kpaa le saan ba se li Imgbasho yuon. ");
INSERT INTO utr_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Abu ye ola ntonɛni: <Ka ndaamah ba, ka ngwɔ inggisɛ ba, ka yimi ba, ka kyɔ obwɛndɛ atsika ba, sunu otsabu yi onabu.> >> ");
INSERT INTO utr_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","O gbɛɛ, <<Ani ngyo ola ntonɛ duu kyɛ onɔ ngwi ani li ongbɛ ma jo.>> ");
INSERT INTO utr_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Ngwi iYesu fwo ungwɔnɛ nɛ, o nyan gbɛɛ, <<Ungwɔ onyi kwoba mbi abu kpɔɔ. Gbelu alungwɔ ngwi abu dzɛyan duu gbe gya kye udza nu emi adzɛ, taman abu ka dzɛ yi aludu mi esho. Ta yɛ wa kyɛdɔ ani.>> ");
INSERT INTO utr_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Mi onɔ ngwi inggisɛ na fwo ungwɔnɛ nɛ, o buntse. Lubana o li inggisɛ ndzɛ yi aludu kpakpa. ");
INSERT INTO utr_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","IYesu di dafi o shɛ ewo ta ba nɛ, o gbɛɛ, <<Ka fyumfye kpakpa ni inggisɛ udza kaka esutɔ mgbi Imgbasho! ");
INSERT INTO utr_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Mi otsitsi yɔ, ka sunɔ ba ni ilakwumyi nyɛ ifo edi ngha onu inggisɛ udza kaka esutɔ mgbi Imgbasho.>> ");
INSERT INTO utr_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Ama nfwo odzɛ nɛ byita gbɛɛ, <<Li emɛ tsatso ka watɔ?>> ");
INSERT INTO utr_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","IYesu gbɛɛ, <<Ungwɔ nli kyɛmɛ-kyɛmɛ mbi inggisɛ ba li kyɛmɛ-kyɛmɛ mbi Imgbasho.>> ");
INSERT INTO utr_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","IPyita nyan gbɛɛ, <<Dii! Eyi dzata alungwɔ ngwi eyi dzɛyan duu kyɛdɔ abu.>> ");
INSERT INTO utr_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","IYesu nya ma gbɛɛ, <<N nya ema otsitsi, ali inggisɛ ngwu dzata udɛ naadi owan hona emi ongwunɔn naadi ama omban hona emi ongwan mi ikye esutɔ mgbi Imgbasho yɔ, ");
INSERT INTO utr_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","a ka yilen nu ma kwuba mi onɔ ngwi eyi wele nɛni. A dika tu oshishe igyegwu mi onɔ ongwi iyayi kpaa.>> ");
INSERT INTO utr_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","IYesu gbe ama ogbikyon iwyodefa ntona lu enggengga ka nya ma gbɛɛ, <<Eyi le lu iJerosalin, ta alungwɔ ngwi oyegbɔ lɔ mi ikye Ongwɛ Inggisɛ ma duu ka mbwumbwo. ");
INSERT INTO utr_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","A ka kyon wo Udzengye abɔ. A ka nyan odzɛ agya, fyan ito, kyanggwɔ kyin, gbon onitse diyɛ ngwɔn. ");
INSERT INTO utr_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Mi egbe ongwu ta ma o ka kyato mi ikwu.>> ");
INSERT INTO utr_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Nghaduu engwafɔ mgban yagba difwi ungwɔ ntonɛ onyi ba. Itan daada loma, a di yagba ye ungwɔ ngwi iYesu le gbɔdzan ma ba. ");
INSERT INTO utr_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Dafi iYesu le to kwɛkwɛ mi iJeriko nɛ, inggisɛ obinɛ oka sɔdzɛ mi ondoofɛ, le bibɔ. ");
INSERT INTO utr_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Mi onɔ ngwi o fwo ibyi inggisɛ le nyɛ nɛ, o byita ungwɔ nle kiyayi mani. ");
INSERT INTO utr_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","A nyan gbɛɛ, <<Li iYesu ongwi iNadzareti le nyɛ.>> ");
INSERT INTO utr_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","O kwu ela mi ela okwukwo gbɛɛ, <<IYesu, Ongwɛ iDevedi, di ani elela!>> ");
INSERT INTO utr_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Ama nto iyayi mbon fan ela nyan gbɛɛ no tukwondu, kpaa o di kwu ela okwukwo nghaangha, <<Ongwɛ iDevedi, di ani elela!>> ");
INSERT INTO utr_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Nɛ iYesu kwulɛsɛ woola gbɛɛ nu ma kye inggisɛ obinɛ na ba mbon. Ngwi o ba kwɛkwɛ nɛta, iYesu byun gbɛɛ, ");
INSERT INTO utr_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","<<Li alungwɔ ngwi abu mina gbɛɛ ni ani kyɔ abu ele?>> O gbɛɛ, <<Otsɛ, ani mina odinɛ.>> ");
INSERT INTO utr_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","IYesu si gbɔ yan gbɛɛ, <<Inɛ no kwulu lo abu; oyɛyɛ mgbi abu nu abu yɛɛ saan.>> ");
INSERT INTO utr_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Labɔlabɔ mata, o si dinɛ, kyɛdɔ iYesu, dile tsɛ Imgbasho. Ngwi inggisɛ duu di ungwɔnɛ nɛ, ama kpaa tsɛ Imgbasho. ");
INSERT INTO utr_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","IYesu kaka iJeriko nyɛ-nyɛ le lu. ");
INSERT INTO utr_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Ongyulɔ dzɛ imbe na ngwu a li kwun di iDzakyu; o li ongyukwo mgbi ama ogbɛ udza ifyɛɛ di dzɛ yi aludu. ");
INSERT INTO utr_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","O mina odi itɔ inggisɛ ngwu iYesu dzɛ mani, nghaduu ngwi o shigbo ba nɛ, o yagba odin ba ikye ibyi inggisɛ. ");
INSERT INTO utr_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Nɛ o tsinya lu iyayi ka tɔkɛ ekwɔ andundu ni ongwu din, ikyesinɛ iYesu kyɛ le nyɛ ofɛ nani. ");
INSERT INTO utr_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Ngwi iYesu to imbe na yɛyɛ nɛta, o ndinɛ kɛ esho si nyan gbɛɛ, <<IDzakyu, tashulu vla-vla. Li kyɛmɛ-kyɛmɛ n ka kaka udɛ abu inɛ.>> ");
INSERT INTO utr_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Nɛ o tashulu vla si gban yi atsa. ");
INSERT INTO utr_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Inggisɛ tsatsa di ungwɔnɛni man, a wita ondandu gbɛɛ, <<O le kɛ ingyoga mi udɛ inggisɛ ali ibwubwe.>> ");
INSERT INTO utr_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Nghaduu iDzakyu dzɛkunto gbɔ yi Otsɛ iYesu gbɛɛ, <<Dii, Otsɛ! Mmɛnɛ jo n ka kye ayɛ ungwɔ mgbi ani ngwi ani tulun kyi nu ema adzɛ, ki ani kyɔ inggisɛ ogye, ni li ekyɛkyɛ kpaa, n ka kpa otsungwɔn mkpa akpe enɛ.>> ");
INSERT INTO utr_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","IYesu gbɔ yan gbɛɛ, <<Inɛ nɛ abu yi emidabu duu tu owatɔ-watɔ, ikyesinɛ inggisɛ nɛ kpaa, li ongwɛ Abrahan. ");
INSERT INTO utr_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Bana Ongwɛ Inggisɛ ba ikye owa pita yɛ dulu ungwɔ nbyulu ma watɔ.>> ");
INSERT INTO utr_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Dafi a le gadɔ mi ungwɔnɛ nɛ, iYesu kiyayi onya ma utsa, ikyesinɛ o dzɛ kwɛkwɛ yi iJerosalin, man inggisɛ tsɛwɛ gbɛɛ esutɔ mgbi Imgbasho ka byakpa ba akponyi. ");
INSERT INTO utr_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","IYesu gbɔgbɛɛ: <<Ongwɛ utɔ oka wewo okɛ anengye adzi nu ma ka kye abɔ utɔ dɔn ikye di yidɔ. ");
INSERT INTO utr_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Nɛ o kwu engbidɔ mgban nghi iwyo ela si nu ali inggisɛ mgbi ama awuya ngwi mɛ dafi awuya okpa idɔ ofyia eta sini. O gbɛɛ, <Kyelu awuya nɛ fashi abɔ di tu ungwɔ ele na, duuse nin wa yidɔ.> ");
INSERT INTO utr_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","<<Nghaduu emi ɛsɛ udan dun tanyi man a dɔ inggisɛ angbeka esɔ mbon oka gbɔgbɛɛ, <Eyi mina gbɛɛ inggisɛ nɛ no ka li utɔ mgbi eyi ba.> ");
INSERT INTO utr_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","<<A gyon utɔ man o yɛ luba udɛ. Ta o dɛsɔ mbi engbidɔ ngwu ongwu nu ma awuya ma, ikye oye eni owaawa ngwi a tu mi ele mani. ");
INSERT INTO utr_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","<<Inggisɛ ongwu ababɔ ba wa gbɔgbɛɛ, <Ongyukwo, awuya ngwi abu kye nu ani ma yɛ mbwumbwo nghi iwyo.> ");
INSERT INTO utr_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","<<Ongyukwo nu uka gbɛɛ, <N nu abu abɔ ongbidɔ mgbi ani osuse. Ikyegbɛɛ abu dzɛ yi oyɛyɛ mi ungwɔ ogwee nɛ, kye inɛ byi igeli okwukwo nghi iwyo.> ");
INSERT INTO utr_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","<<Ongwu fan ba wa gbɔgbɛɛ, <Ongyukwo, awuya mgbi abu yɛ mbwumbwo nghi eda.> ");
INSERT INTO utr_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","<<Ongyukwo mgban si nu uka gbɛɛ, <Kye inɛ byi igeli okwukwo nghi eda.> ");
INSERT INTO utr_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","<<Nɛ ongbidɔ oka di ba wa gbɔgbɛɛ, <Ongyukwo, awuya mgbi abu dzɛ na; ani kye da mi ayangwuto. ");
INSERT INTO utr_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Ani tsimio abu, ikyesinɛ abu li inggisɛ ngwu fyumfye ali kpakpa. Abu li dulu mi imbe ngwi abu kye da ba, di li shɛ mi imbe ngwi abu kya ba.> ");
INSERT INTO utr_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","<<Ongyukwo mgban nun uka gbɛɛ, <N ka gbɔ abu ikwɔ mi elodzɛ mgbi abu, abu ongbidɔ imbali nɛni, abu ye gbɛɛ ani li inggisɛ ofyumfye ali, n li dulu mi imbe ngwi ani kye da ba, di li shɛ mi imbe ngwi ani kya ba. ");
INSERT INTO utr_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Kyɔsinɛse ngwi abu kye awuya mgbi ani ka wokɛ mi ozu awuya ba? Mi oyɛɛyɛ mgbi ani, n kika tu eni owaawa mi efu.> ");
INSERT INTO utr_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","<<Ta o nya ama nkwudzɛ to yan ma gbɛɛ, <Gbɛlu awuya na mi abɔ mgban kye nu inggisɛ ndzɛyan nghi iwyo nani.> ");
INSERT INTO utr_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","<<A gbɔgbɛɛ, ongyukwo, <Ongwu na tsekise dzɛ yi iwyo wa.> ");
INSERT INTO utr_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","<<O nu uka gbɛɛ, <N nya ema gbɛɛ mbi ali inggisɛ ntulun ma a dika mbwon ele kpɔɔ, kpaa ama ndzɛ yi unkonyi ba ma, ongwi o dzɛyan ma kpaa a ka kyi gbɛlu. ");
INSERT INTO utr_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Kpaa emi ikyili mgbi ani ngwu mina gbɛɛ nin ka dzɛ utɔ mi ikye ma ba nɛ, gbe ma ba wa ngwɔ ma mi iyayi ani mmɛnɛni.> >> ");
INSERT INTO utr_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Ngwi iYesu gbɔdzɛ nɛ ngyɛ nɛ, o kye ofɛ dikye olu iJerosalin. ");
INSERT INTO utr_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Dafi o wa to kwɛkwɛ mi ongwɛ igeli ngwi a li kwun di iBɛtifege yi iBetani mi undɔ ngwi a li kwun di unggwɔ mgbi Olivi nɛ, o dɔ engwafɔɔn efa esɔ nya ma gbɛɛ, ");
INSERT INTO utr_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","<<Lu mi ogalu ndzɛ ema iyayi nani, ni ema kaka ele yɔ, ema ka di ongwɛ itaklimyi shadi mmanani, ngwi inggisɛ onyi kpaa tɔɔn ye waba. Kyi shɛlu ba mmɛnɛni. ");
INSERT INTO utr_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Kini inggisɛ byi ema gbɛɛ, <Kyɔsinɛ ngwi ema le shan yɔ?> Nyan gbɛɛ, <Odzɛ wo Otsɛ yan.> >> ");
INSERT INTO utr_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Ama ngwu iYesu dɔ ma esɔ ma si kɛ ka di itaklimyi dafi o tsekise nya ma mani. ");
INSERT INTO utr_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Ngwi a le shan nɛta, emi otsungwɔn byi ma gbɛɛ, <<Kyɔsinɛ ngwi ema le shɛ itaklimyi nɛ?>> ");
INSERT INTO utr_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","A nu uka gbɛɛ, <<Odzɛ wo Otsɛ yan.>> ");
INSERT INTO utr_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","A kyen ba wa nu iYesu, man kye angwuto mgbi ama kye tukwu ongwɛ itaklimyi na ekpo di ya iYesu abɔ dɔkɛ ele. ");
INSERT INTO utr_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Dafi o tɔɔn le kɛ nɛ, ibyi inggisɛ gbe angwuto le tasɛ mi ofɛ. ");
INSERT INTO utr_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Ngwi o ba kwɛkwɛ mi imbe ngwi ofɛ nyɛ lu unggwɔ Olivi nɛ, engwafɔ duu wita le tsatsa dile tsɛ Imgbasho mi ela okwukwo mi alungwɔ okwulewo ngwi ama di nani. ");
INSERT INTO utr_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Le gbɛɛ, <<Mse no dzɛ yi utɔ ongwu nba mi iyi mgbi Otsɛ Imgbasho nɛni! Iyu mi esho bɛyi okwɔkwɔ mi imbe Onghaangha duu!>> ");
INSERT INTO utr_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Emi iFarasi angbeka mi idzidzɛ ibyi inggisɛ ntona gbɔ yi iYesu gbɛɛ, <<Otsetse, fwa yi engwafɔ ntonɛni.>> ");
INSERT INTO utr_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","IYesu nu ma uka gbɛɛ, <<N nya ema, kini a dede kpaa, akwutsɛ ka gbaakwɔ.>> ");
INSERT INTO utr_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Ngwi iYesu ba kwɛkwɛ wa di iJerosalin nɛ, o tsukwu mi ikye inggisɛ emi igeli nani. ");
INSERT INTO utr_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","O gbɔgbɛɛ, <<Ni abu, ki ye ungwɔ ama nka ba yi abu iyu inɛ kpaa ta. Nghaduu onɛnɛ i daada mi inɛ mgbi ema. ");
INSERT INTO utr_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Egbe ka wa kwulu abu abɔ ngwi emi ikyili mgbi abu ka loka kye abu wo idzidzɛ di fyi abu mi ali agya duu. ");
INSERT INTO utr_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","A ka fyi abu bɛkɛ esɛ, abu yi inggisɛ ama nto yi abu duu. A ka dzata ikwutsɛ onyi kpaa dɔ ikye oka ba, ikyesinɛ abu fwa o difwi onɔ ngwi Imgbasho ba owa dulu abu watɔ.>> ");
INSERT INTO utr_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Ta iYesu kaka ozu okwukwo osunu Imgbasho mi iJerosalin man wita olɔlu ama nle kyummya tasɛ. ");
INSERT INTO utr_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","O nya ma gbɛɛ, <<Afɛ lɔ gbɛɛ, <Ozu mgbi ani ka li ozu obibɔ; kpaa ema kye yɛɛ imbe odaada mgbi emumyi.> >> ");
INSERT INTO utr_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Alegbe o le tso mi ozu okwukwo osunu Imgbasho mi iJerosalin nani. Kpaa engyukwo ama ofifɛ mgbi Imgbasho, etsetse mgbi ola mgbi iMose bɛyi emi angbodzi inggisɛ le fya gbɛɛ ama ki ngwɔn. ");
INSERT INTO utr_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Nghaduu a tu ofɛ onyi ongwɔn ba, ikyesinɛ ali inggisɛ kye itukwu shakɛ mi elodzɛ mgban. ");
INSERT INTO utr_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Egbe oka mi idzidzɛ egbe ntonɛ nɛ, iYesu le tso ibyi inggisɛ mi ifoozu okwukwo osunu Imgbasho mi iJerosalin dile gbɔ Esɔ Osuse, ta engyukwo ama ofifɛ mgbi Imgbasho bɛyi ama otso ola mgbi iMose bɛkɛ yi ama okye ɛsɛ teyi, ba mbon. ");
INSERT INTO utr_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","A gbɔ yan gbɛɛ, <<Nya eyi, li mi ali mfye ngwi abu le kyungwɔ ntonɛ, li emɛ nu abu mfye nɛ?>> ");
INSERT INTO utr_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","IYesu nu ma uka gbɛɛ, <<Ani kpaa ka byi ema ita. Nya ani na, ");
INSERT INTO utr_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","iBatisima mgbi iJɔn nɛ, kyɛ mbi Imgbasho mi esho naadi kyɛ mbi inggisɛ?>> ");
INSERT INTO utr_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","A si tsɛwɛ yi ewoma gbɛɛ, <<Kini eyi gbɛɛ, <Kyɛ mbi Imgbasho mi esho yɔ,> o ka byita gbɛɛ, <Kyɔsinɛ ngwi ema nun oyɛyɛ ba?> ");
INSERT INTO utr_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Kpaa ni eyi gbɔgbɛɛ, <Kyɛ mbi inggisɛ yɔ,> ali inggisɛ duu ka tsɛ eyi akwutsɛ, ikyesinɛ a kye gbɛɛ iJɔn li oyegbɔ.>> ");
INSERT INTO utr_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Nɛ, a nu uka gbɛɛ, <<Eyi ye imbe ngwi i tɔkyɛ ba.>> ");
INSERT INTO utr_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","IYesu nu ma uka gbɛɛ, <<Ngyɛse ani kpaa ka nya ema itɔ mfye ngwi ani kye le kyungwɔ ntonɛ ba.>> ");
INSERT INTO utr_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","IYesu si kiyayi o nya inggisɛ utsa nɛni gbɛɛ: <<Inggisɛ oka nose ye ekwɔ ama onaana mi okwɔ mgban man kye nu emi okwɔ angbeka mi ondu odzɛɛdzɛ, si lu agaba onɔ kɛ. ");
INSERT INTO utr_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Ngwi onɔ oshɛ etɔ wa gyɔ nɛ, o si dɔ ongbidɔ mgban esɔ mbi ama ngwu o kye okwɔ dɔ ma ubɔ ntonani, ikyegbɛɛ nu ma nun awawekwɔ nli mgbi ongwu mi okwɔ nani. Nghaduu ama ngwu o kye okwɔ dɔ ma ubɔ ntona gbon ibe lɔn onya lu abubɔ. ");
INSERT INTO utr_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","O di dɔ ongbidɔ oka esɔ, ongwu na kpaa a di gbon nun ayiwi saan, lɔn onya lu abubɔ. ");
INSERT INTO utr_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","O di dɔ inggisɛ ongwu ta esɔ kpɔɔ, a gbon ibe tan mmya di lɔn onya tasɛ lu. ");
INSERT INTO utr_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","<<Ta otsungwɔ okwɔ na gbɔgbɛɛ, <N ka kyɔsinɛ dɛn? Ani ka dɔ ongwani esɔ, ongwu nkpɛn itukwu nɛni; i kyayina a ka nun mmwɛ.> ");
INSERT INTO utr_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","<<Nghaduu ngwi ama o kye okwɔ dɔ ma ubɔ ntona dun nɛ, a kye ondu wɛɛsɛ yi ewoma gbɛɛ, <Nɛnɛ li ongwɛ ogye okwudan aani. Detse ni i gbongwɔn, ni okwudɛ nɛ yɛɛ mgbi eyi.> ");
INSERT INTO utr_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","A si kwon tasɛ mi okwɔ man gbongwɔn. <<Nghama li alungwɔ ngwi otsungwɔ okwɔ na ka kyɔ yi ama? ");
INSERT INTO utr_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","O ka ba wa kye ama ngwu o kye okwɔ dɔ ma ubɔ ntona tsatsaduu kye ngwɔlu di yile okwɔ na nu inggisɛ angbeka.>> Mi onɔ ngwi inggisɛ ntona fwo ungwɔnɛ nɛ, a gbɔgbɛɛ, <<Ungwɔnɛ no ka dzɛ ngha ba!>> ");
INSERT INTO utr_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","IYesu kye inɛ byi ma yɛyɛ si byita gbɛɛ, <<Nghanɛ li alungwɔ ngwi olɔɔlɔ nɛ tso dɛn: << <Ikwutsɛ ngwi ama ombɛ ozu fwan mani li ongwu yɛ kwulu ikye ozu.> ");
INSERT INTO utr_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Ali inggisɛ ngbɛsɛ gyɛkɛ ikwutsɛ na ka gbobu ambulu-ambulu, kpaa inggisɛ ngwu i ka gyan ma o ka jiyɛ.>> ");
INSERT INTO utr_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Etsetse mgbi ola bɛyi engyukwo ama ofifɛ mgbi Imgbasho le pita ofɛ ngwi ama ka bwan tsoli, ikyesinɛ a ye ta gbɛɛ o gbɔ utsa nɛ li mi ikye mgbi ama. Nghaduu a le tsimio ibyi inggisɛ. ");
INSERT INTO utr_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Nɛ a gbinɛbyin saan. A dɔ ama owodi esɔ, ama nkyɔ ɛwɛ gbɛɛ ama li emi otsitsi mani. A weka obwa iYesu mi ungwɔ ngwi o gbɔ adzi nu ma kyon nu mi abɔ mfye mgbi iGɔna. ");
INSERT INTO utr_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Ama owodi ntona si byi iYesu gbɛɛ: <<Otsetse, eyi ye abu li gbɔdzɛ di tsungwɔ nle yɛyɛ, abu di li kye idzidza dzɛ ba, kpaa li tso ofɛ mgbi Imgbasho yɛyɛ yi otsitsi. ");
INSERT INTO utr_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Li ayin ni eyi kpa udza ifyɛɛ nu iSidza naadi li ayin ba?>> ");
INSERT INTO utr_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","O difwi ɛwɛ mgbi ama nɛta o gbɔ yi ama gbɛɛ, ");
INSERT INTO utr_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","<<Kye udza ma tsen n di, li onodzi bɛyi olɔɔlɔ mgbi emɛ dɔ efu dɛn?>> A gbɛɛ, <<Li mgbi iSidza.>> ");
INSERT INTO utr_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","O nya ma gbɛɛ, <<Kye ungwɔ mgbi iSidza nu iSidza, mgbi Imgbasho nu Imgbasho.>> ");
INSERT INTO utr_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","A yagba bwan yi elodzɛ ondu mi elodzɛ ngwi o gbɔ mmana mi ododa na ba. Man i kwulu ma ewo mi uka nani, a si yɛɛ shilididi. ");
INSERT INTO utr_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Emi iSadusi angbeka, ama ngbɛɛ okyɛɛ-kyɛɛ mi ikwu dzɛma ba ma, ba mbi iYesu yi ita. ");
INSERT INTO utr_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","A gbɛɛ, <<Otsetse, iMose lɔ afɛ nu eyi gbɛɛ kini ongwunɔ inggisɛ kwulu dzata ongyaa, kpaa o dzɛ yi ɛngbɛ bayɔ, ongyulɔ na ka yile owakwadɛ na kyɛmɛ-kyɛmɛ, ikye otu ɛngbɛ mi ikye ongwunɔn nani. ");
INSERT INTO utr_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Nose emi ongwunɔ ifu nghi egyafa to. Ongwu ababɔ kye ongyaa ta kwulu tu ongwɛ ba. ");
INSERT INTO utr_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Ongwu fan ");
INSERT INTO utr_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","bɛyi ongwu ta yilen owakwadɛ, li ungwonyi nghataa ongwu gyafa, kpaa a tu ongwɛ ba man a kwulu duu. ");
INSERT INTO utr_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Ongyɛɛngyɛ duu ongyaa na kpaa wa kwulu. ");
INSERT INTO utr_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Nghanɛma, mi egbe olɛlɛ ngwi emi ikwukwɔ ka kyato ma, o ka li owa emɛ, ngwi engyulɔ egyafa ntona duu kyon?>> ");
INSERT INTO utr_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","IYesu nu uka gbɛɛ, <<Inggisɛ emi egbe nɛ li le kye engyaa, a dile kye engyaa nu engyulɔ. ");
INSERT INTO utr_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Kpaa ama ngwu a kye ma wuuta gbɛɛ di a mɛ owo atɛ mi onɔ na bɛyi mi okyɛɛ-kyɛɛ mi ikwu a ka yama kye ongyaa hona bongyulɔ ba, ");
INSERT INTO utr_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","bana a ka kwulu wuba, a to dafi engyesɔ. A li emi ongwɛ Imgbasho, ikyekyɛ a li ama ngwu a kyile ma mi ikwongye. ");
INSERT INTO utr_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Nghaduu mi utsa mgbi oshɛ okwoola, iMose kpaa tso gbɛɛ emi ikwukwɔ kyato mi ikwu, bana o kwu Otsɛ Imgbasho gbɛɛ, Imgbasho mgbi Abrahan, yi Adziki bɛyi iJeko. ");
INSERT INTO utr_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Ongwu li Imgbasho mgbi emi ikwukwɔ ba, kpaa mgbi emi oshishe, bana mbon alungwɔ duu dzɛ oshishe.>> ");
INSERT INTO utr_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Etsetse mgbi ola angbeka si gbɔgbɛɛ, <<O nu uka saan, Otsetse!>> ");
INSERT INTO utr_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Man a byun ita onyi wuba. ");
INSERT INTO utr_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Ta iYesu nya ma gbɛɛ, <<Kyɔnɛse ngwi a gbɛɛ iKrestu li ongwɛ iDevedi? ");
INSERT INTO utr_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","IDevedi abɔn gbɔ mi afɛ mgbi iPaslami gbɛɛ: << <Otsɛ Imgbasho gbɔ yi Otsɛ mgbi ani gbɛɛ: <<Sɔkɛ abugye mgbi ani ");
INSERT INTO utr_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","nghataa nin nu engyikyili mgbi abu yɛɛ itse mgbi abu ogbe afɔ dɔ efu.>> > ");
INSERT INTO utr_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","IDevedi kwun gbɛɛ Otsɛ. Nghanɛ o dika li ongwan sinɛ?>> ");
INSERT INTO utr_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Ngwi inggisɛ duu le fwon nɛ, iYesu nya engwafɔɔn gbɛɛ, ");
INSERT INTO utr_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","<<Gbɛwɛbyi etsetse mgbi ola, ama nli kpa ma okyikyɛ kpatsɛ yi angwuto owulu-wulu di li kpa ma onu ma le ta ma angba mi ifyidu kyɛ, a di li kye itse imɔ mi ozu okwakye mgbi emi iJuda bɛyi imbe ama oshewo mi oga. ");
INSERT INTO utr_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","A di li kyɔ emi owakwadɛ ogye mi ungwɔ ngwi a ki kye kyɔ oyabɔ mi udɛ mgbi ama di li kyile ewoma esho mi ibɔ obɔ tunto. Itɔ inggisɛ ntona a ka nghao nu ma adzɛ timbi.>> ");
INSERT INTO utr_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Dafi iYesu kyile inɛ esho nɛ, o di emi awuya kye umba mgbi ama le wokɛ mi okye ogbɛ umba mi ozu okwukwo osunu Imgbasho mi iJerosalin. ");
INSERT INTO utr_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","O diyɛ di owakwadɛ ngwu dzɛ adzɛ kye anini nghi efa wa wokɛ okye ogbɛ umba. ");
INSERT INTO utr_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","IYesu gbɛɛ, <<N nya ema otsitsi, owakwadɛ ndzɛ adzɛ nɛ nu ngha angbeka ntona duu. ");
INSERT INTO utr_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Lubana emi awuya ntonɛ duu fwɛ-fwɛ mi aludu mgbi ama kye nu; kpaa ongwu mi abubɔ mgban kye ungwɔ ngwi o ka dzɛ oshishe mi ele duu kye nu.>> ");
INSERT INTO utr_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Engwafɔɔn angbeka le gbɔdzɛ mi mse bɛyi idabɔ ngwi a kyɔ mi akwutsɛ ongwi ozu okwukwo osunu Imgbasho mi iJerosalin bɛyi umba ngwi a kye nu Imgbasho. Nghaduu iYesu gbɛɛ, ");
INSERT INTO utr_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","<<Ungwɔ ngwi ema di mmɛnɛ nɛ, onɔ kyɛma ngwi a ka dzata ikwutsɛ onyi dɔ ikye oka ba; ama duu a ka kye bulu tukwu esɛ.>> ");
INSERT INTO utr_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Nɛ a byun gbɛɛ, <<Otsetse, li engga ngwi ungwɔ ntonɛ ka kyɔ? Naadi li ali ambɛ ka tso gbɛɛ ungwɔ ntonɛ dzɛ kwɛkwɛ okyɔɔkyɔ?>> ");
INSERT INTO utr_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","IYesu nu ma uka gbɛɛ: <<Gbɛwɛbyi adzi nu ma ka kpagyama wo ba. Ikyesinɛ inggisɛ kwuba ka ba mi iyi mgbi ani, le kye ewoma gbɛɛ, <Li ani ongwu ma aani,> dika gbɛɛ, <Onɔ ma gyɔ wa.> Nghaduu ka kyɛdɔ ma ba. ");
INSERT INTO utr_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Onɔ ngwi ema fwo odzɛ ika bɛyi ablodzɛ, ka mio ba. Ungwɔ ntonɛ ka kyɔ kyɛmɛ duuse, kpaa ongyɛɛngyɛ mgbi ɛsɛ ka ba labɔlabɔ ma ba.>> ");
INSERT INTO utr_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Ta iYesu nya ma gbɛɛ: <<Ɛsɛ oka ka kyɛɛ ika yi ɛsɛ oka, esutɔ oka dika kyɛɛ ika yi esutɔ oka. ");
INSERT INTO utr_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Ikpɛsɛ osuusu ka dzɛ kpakpa, onikyɔ enbwa omba enbwa bɛyi ootse ibwubwe ka gbɔfwɛ mi imbe idzidza-dzidza, yi ungwɔ ama okwulewo bɛyi ambɛ ama okwukwo mi esho. ");
INSERT INTO utr_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","<<Kpaa duuse ni ungwɔ ntonɛ kyɔ, a ka gbe abɔ dɔ ema ewo dika nu ema okɔtɔndzi adzɛ. A ka kye ema nu mi ozu okwakye mgbi emi iJuda bɛyi obawi, dika kye ema ba mi inɛ mgbi emi utɔ bɛyi emi iGɔna, tsatsadu mi ikye iyi mgbi ani. ");
INSERT INTO utr_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Ungwɔnɛ ka nu ema ofɛ okyɔ obwɛndɛ mgbi ani. ");
INSERT INTO utr_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Nghaduu bwa itukwu mgbi ema, no ka kaka ema ewo dafi ema ka na ewema duuse ni egbe wa gyɔ ba. ");
INSERT INTO utr_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Lubana ani ka nu ema elodzɛ bɛyi ozoyeye ngwi engyikyili mgbi ema ka yagba onatsondu yi ema ba. ");
INSERT INTO utr_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Ama omba ema, engwunema, emi odo ema bɛyi emi oka ema, ka wa kye ema gya, a dika ngwɔ ema angbeka. ");
INSERT INTO utr_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Inggisɛ duu ka di ema tanyi mi ikye iyi mgbi ani. ");
INSERT INTO utr_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Nghaduu alotu mgbi ema onyi ka kwɔ ba. ");
INSERT INTO utr_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Mi okwulɛsɛ mgbi ema kpɔklɔɔ ema ka tu oshishe. ");
INSERT INTO utr_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","<<Onɔ ngwi ema wa di emi oblakwutsɛ kpakɛkɛ wo iJerosalin ma, ye na gbɛɛ odzili-dzili mgban dzɛ kwɛkwɛ. ");
INSERT INTO utr_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Nghanɛ ama nto iJudia nu ma tsinya lu unggwɔ, ama nto ogalu nu ma tasɛ, ama ndi nto esisɛ nu ma ka yɛ kaka ogalu ba. ");
INSERT INTO utr_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Lubana nɛnɛ li onɔ ngwi Imgbasho ka nu emi ogalu nɛ adzɛ kpakpa ikye ombwumbwo ungwɔ ngwi a tsekise lɔ mani. ");
INSERT INTO utr_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Ka kwulewo kpakpa mbi engyaa ama nto yi ifewo mi egbe ntona bɛyi enengwɛ ama nto yi engwɛ abɔ! Okakewo ka dzɛ kpakpa mi ɛsɛ na bɛyi itingga mgbi Imgbasho mi ikye inggisɛ ntonɛni. ");
INSERT INTO utr_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","A ka ngwɔ angbeka yi okwusunkli dika kwu angbeka ofyɛɛ gbe ma lu kpatsɛ ɛsɛ duu. Udzengye ka kye afɔ tɔdɔ iJerosalin nghataa onɔ mgbi Udzengye ka wa ngyɛ. ");
INSERT INTO utr_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","<<Ambɛ ka wa tɔ mi onɔ yi ofyia bɛyi mcɛ. Mi ikpɛsɛ, ɛsɛ duu ka dzɛ mi isɔ bɛyi okakewo mi owulu-wulu yi okadu-kadu mgbi ekyoo okwukwo. ");
INSERT INTO utr_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Ibyi inggisɛ ka dzɛkwulu yi imio, mi odifwi-difwi mgbi ungwɔ ngwi kyɛ le ba ɛsɛ nɛ mani, lubana ali mfye ongwi esho duu ka suusu. ");
INSERT INTO utr_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Mi onɔ na a ka di Ongwɛ Inggisɛ kyɛ le ba mi akpa mi esho yi mfye bɛyi okwɔkwɔ oshewo. ");
INSERT INTO utr_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Onɔ ngwi ungwɔ ntonɛ wita okyɔɔkyɔ ma, kyato dzɛkunto kyile ikye mgbi ema esho, lubana owatɔ-watɔ mgbi ema dzɛ kwɛkwɛ.>> ");
INSERT INTO utr_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Ta iYesu nya ma utsa nɛ gbɛɛ: <<Kyidi andundu bɛyi ekwɔ angbeka duu na. ");
INSERT INTO utr_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Onɔ ngwi a wita okyinda ma, ema li di abuema di ye gbɛɛ akyonova dzɛ kwɛkwɛ wa. ");
INSERT INTO utr_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Ngwi i dzɛ nghanɛ, ni ema di ungwɔ ntonɛ le kyɔ yɔ, ye na ta gbɛɛ esutɔ mgbi Imgbasho dzɛ kwɛkwɛ. ");
INSERT INTO utr_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","<<N nya ema otsitsi, etɔ nɛ ka nyɛ ba nghataa se ungwɔ ntonɛ ka kyɔ. ");
INSERT INTO utr_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Esho yi esɛ ka wa nyɛ, kpaa elodzɛ mgbi ani ka yama nyɛ ba. ");
INSERT INTO utr_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","<<Gbɛwɛbyi na, ka kye itukwu mgbi ema dzɛ mi ungwɔ ogyeegye yi ungwɔ owa fya bɛyi itukwu oshanyɛ mi oshishe ongwi ɛsɛ nɛ ba, ikye ni egbe na ka fa tu ema bwabwa ");
INSERT INTO utr_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","dafi ukya ba mani. Lubana egbe na ka ba mbi ali inggisɛ ndzɛ ɛsɛ duu. ");
INSERT INTO utr_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Lasisa le ngyo alonɔ na, di bibɔ gbɛɛ ni ema yagba watɔ mi ungwɔ ama nka wa kyɔ duu, adzi ni ema wa yagba kwudzɛ mi inɛ Ongwɛ Inggisɛ mani.>> ");
INSERT INTO utr_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Alegbe mi onɔ, iYesu li le tsungwɔ mi ozu okwukwo osunu Imgbasho mi iJerosalin, kpaa mi otu yɔ o li lu ka la undɔ ngwi a li kwun di unggwɔ olivi nani. ");
INSERT INTO utr_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Ali ebgegbe inggisɛ kwuba li tɔ owa fwon mi ozu okwukwo osunu Imgbasho mi iJerosalin. ");
INSERT INTO utr_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Oga owɛ owatɔ-watɔ mgbi emi Israi mgbi ibredi ngwi a li kye okwuna wele ba ma le gyɔ, ");
INSERT INTO utr_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","nɛta engyukwo ama ofifɛ mgbi Imgbasho bɛyi etsetse mgbi ola le pita ofɛ ngwi ama ka ngwɔ iYesu daada, bana a le mio ibyi inggisɛ. ");
INSERT INTO utr_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Nghanɛ iSatan kaka mbi iJuda ongwu a li kwun di Iskarɔti, nli onyi mbi emi iwyodefa ntonani. ");
INSERT INTO utr_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","O kɛ mbi engyukwo ama ofifɛ mgbi Imgbasho bɛyi ama nle ngyo mi ozu okwukwo osunu Imgbasho mi iJerosalin nani, ka kye ondu wɛɛsɛ yi ama dafi ongwu ka kye iYesu gya mani. ");
INSERT INTO utr_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","I kpaa ma nɛta a gbela onun awuya. ");
INSERT INTO utr_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","O gbela, dile pita ofɛ ngwi ongwu ka kye iYesu gya yi ama onɔ ngwi ibyi inggisɛ ka dzɛyan ba mani. ");
INSERT INTO utr_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Egbe ibredi ngwi a kye okwuna wele ba ma gyɔ, ngwi a ka ngwɔ ongwummala mgbi oga owɛ owatɔ-watɔ mgbi emi Israi. ");
INSERT INTO utr_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","IYesu dɔ iPyita bɛyi iJɔn esɔ, gbɛɛ, <<Lu na ka wewo oga ongwi eyi ka gye yi eweyi mani.>> ");
INSERT INTO utr_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","A byita gbɛɛ, <<Li mi ole ngwi mina abu gbɛɛ ni eyi ka wewo oga?>> ");
INSERT INTO utr_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","IYesu nya ma gbɛɛ, <<Dafi ema kaka ogalu mata, inggisɛ nkye ishe eni ka kpatsɛ ema. Kyɛdɔn ka kaka udɛ ngwi o ka kaka mani, ");
INSERT INTO utr_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","di nya otsungwudɛ na gbɛɛ, <Otsetse byita gbɛɛ: Ozu ingyoga kɔ, ngwi ani ka wa gye oga owɛ owatɔ-watɔ mgbi emi Israi bɛyi engwafɛɛn?> ");
INSERT INTO utr_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Ta o ka tso ema ifoozu ogbada-gbada ongwi esho, bɛyi okye duu mi ele. Kye mɛlu imbe mani.>> ");
INSERT INTO utr_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","A si lu ka di alungwɔ duu yɛyɛ dafi iYesu teyi nya ma mani. Ta a wewo oga owɛ owatɔ-watɔ mgbi emi Israi mi ele. ");
INSERT INTO utr_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Ngwi obyi ma wa gyɔ nɛ, iYesu bɛyi ama ogbikyon sisɛ ogye oga. ");
INSERT INTO utr_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Man o nya ma gbɛɛ, <<N mina kpakpa ogye oga owɛ owatɔ-watɔ mgbi emi Israi nɛ yi ema duuse nin wa gyadzɛ. ");
INSERT INTO utr_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","N le nya ema, ani ka gye oga nɛ wuba, nghataa sede ongwi a ka wa gye mi esutɔ mgbi Imgbasho mani.>> ");
INSERT INTO utr_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Onɔ ngwi o kyi kyelu ibwɛ mgbi eneekwɔ nɛ, o ta Imgbasho angba si gbɛɛ, <<Gbɛ wa yi ewema na. ");
INSERT INTO utr_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Bana n nya ema, n ka yama wa eneekwɔ mgbi ekwɔ onaana nɛ wuba nghataa esutɔ mgbi Imgbasho ka wa ba.>> ");
INSERT INTO utr_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Ta o kyi kyelu ibredi di ta Imgbasho angba kye mwalu, yilen kye nu ma, gbɛɛ, <<Nɛnɛ li ikpewo mgbi ani ngwi a kye nu ikye ema; kyungwɔnɛ ikye ole wɛ ani na.>> ");
INSERT INTO utr_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Mi itɔ ofɛ na kpɔɔ, ngwi a gye ungwogye ngyɛ nɛ, o kyi kyelu ibwɛ, gbɛɛ, <<Nɛnɛ li ibwɛ mgbi ondu odzɛɛdzɛ ofufɛ yi eyi mgbi ani ngwi a kye kyi ikye ema. ");
INSERT INTO utr_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Nghaduu abɔ mgbi inggisɛ nle pita ani ikye ma, wo le gye ungwogye mmɛnɛ yi ani. ");
INSERT INTO utr_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Bana Ongwɛ Inggisɛ ka kwulu kyɛmɛ-kyɛmɛ dafi a lɔ ikyon mani, kpaa ahoo mi ikye inggisɛ nkye Ongwɛ Inggisɛ gya mani.>> ");
INSERT INTO utr_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","A wita obyi ewoma ita ongwu nka kyɔ itɔ ungwɔnɛ mi idzidzɛ mgbi ama mani. ");
INSERT INTO utr_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Angwodzɛ di tɔ mi idzidzɛ mgbi ama gbɛɛ li emɛ mbi ama shewo ngha. ");
INSERT INTO utr_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","IYesu si nya ma gbɛɛ, <<Utɔ mgbi Udzengye mi ɛsɛ nɛ li si emidama; man ama ogbe inggisɛ teyi ntona di li yɛ gbɛɛ ama li abuge mgbi ali inggisɛ duu. ");
INSERT INTO utr_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Kpaa mbi ema no ka dzɛ ngha ba. Nghaduu ongwu nshewo ngha mi idzidzɛ ema ma non yile ewon esɛ yɛɛ dafi ongbɛ ogyɛngyɛ mani, ongwu ngbe inggisɛ teyi ma no yɛɛ dafi ongbidɔ. ");
INSERT INTO utr_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Bana li emɛ le kpɔngɔ ngha? Inggisɛ ngwu sɔɔsɔ ma naadi, ongwu nle kyidɔ ma? Ongwu nsɔɔsɔ na ngha! Ani dzɛ mi idzidzɛ ema dafi ongbidɔ mani. ");
INSERT INTO utr_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Ema li ama nfyi ani anya mi onɔ imbadi mgbi ani. ");
INSERT INTO utr_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","N di kye esutɔ nu ema, dafi Otsani kye nu ani mani, ");
INSERT INTO utr_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","ikyegbɛɛ ni ema gye di wa mi imbe ungwogye mgbi ani mi esutɔ mgbi ani di sɔkɛ itsuutɔ, le gbɔ agwɔ mgbi Israi iwyodefa ikwɔ. ");
INSERT INTO utr_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","<<ISaimɔn, iSaimɔn, iSatan pita ofɛ owa kye kwɔɔlu ema dafi a li kwɔɔ ekwu mi okwuga nɛni. ");
INSERT INTO utr_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Kpaa ani bibɔ mi ikye abu, iSaimɔn, gbɛɛ ni oyɛyɛ onuunu mgbi abu ka yɛyikpa ba. Ma onɔ ngwi abu kyata yɛ luba yɔ, fyi emi engwunabu mfye itukwu.>> ");
INSERT INTO utr_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Nghaduu iPyita nun uka gbɛɛ, <<Otsɛ, ani wewo okaka obawi diyɛ kwulu yi abu.>> ");
INSERT INTO utr_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","IYesu nyan gbɛɛ, <<N nya abu, iPyita, inɛ nɛni ogbigbi ka teela waba ta abu ka tangwɛ ani akpe eta.>> ");
INSERT INTO utr_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","IYesu di byi ma gbɛɛ, <<Onɔ ngwi ani dɔ ema esɔ yi ashiko ba, igbe hona okpafɔ ba ma, ungwɔ kwo ema obaa?>> A gbɛɛ, <<Nkonyi kwo eyi oba ba.>> ");
INSERT INTO utr_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","O nya ma gbɛɛ, <<Nghaduu onɛnɛ ni ema dzɛ yi ashiko yɔ, kye, bɛyi igbe kpaa; ma kini ema dzɛ yi okwusunkli bayɔ, kye angwuto mgbi ema gya yɛ gya onyi na. ");
INSERT INTO utr_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Afɛ lɔ gbɛɛ: <A gbɔn mmbwo wokɛ yi ama ofoola>; n di nya ema gbɛɛ ungwɔnɛ ka mbwumbwo mbi ani kyɛmɛ. Ɛɛn, ungwɔ ngwi a lɔ mi ikpewo ani na le kɛ ombwumbwo wa.>> ");
INSERT INTO utr_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Engwafɔɔn si gbɛɛ, <<Di, Otsɛ, okwusunkli efa to mmɛnɛ na.>> IYesu gbɛɛ, <<I gyɔ ngha.>> ");
INSERT INTO utr_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","IYesu tasɛ dafi o li teyi kyɔ mani lu mi Unggwɔ Olivi, nɛ engwafɔɔn kyɛdɔn. ");
INSERT INTO utr_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Ngwi o ka kaka imbe na nɛ, o nya ma gbɛɛ, <<Bibɔ na adzi ni ema ka gbɛsɛ mi igyila ba.>> ");
INSERT INTO utr_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","O gblekɛ gwee dzata ma, o gbe akwafɔ kwɛsɛ si bibɔ gbɛɛ, ");
INSERT INTO utr_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","<<Otsɛn, ni li oweka mgbi abu yɔ, kyi kyelu ibwɛ adzɛ nɛ mbi ani; nghaduu ka kyɔ mi oweka mgbi ani ba, kpaa kyɔ mi oweka mgbi abu.>> ");
INSERT INTO utr_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Man ongyesɔ mi esho mblegba tun di fyonfye itukwu. ");
INSERT INTO utr_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Ngwi o kaka isɔ kpakpa nɛ, o bibɔ mi itukwu onyi, man andzɛ mgban kyata yɛɛ dafi eyi mani le wulɔ kyikɛ esɛ. ");
INSERT INTO utr_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Onɔ ngwi o kyato mi ibɔ nɛ, o wa tu engwafɔɔn tole nuna ikyekyɛ a kyelela ndɛngyɛ. ");
INSERT INTO utr_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","O byi ma gbɛɛ, <<Kyɔsinɛ ngwi ema le nuna? Kyato bibɔ na ikyegbɛɛ ni ema ka gbɛsɛ mi igyila ba mani.>> ");
INSERT INTO utr_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Ngwi iYesu kale gbɔdzɛ nɛ, ibyi inggisɛ wa kaka, ta inggisɛ ngwu a li kwun di iJuda, nli onyi mbi emi iwyodefa, teyi ma. O ba kwɛkwɛ wa kye ondu kwo iYesu ataka, ");
INSERT INTO utr_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","nghaduu iYesu byun gbɛɛ, <<IJuda, li mi ondu okwo ataka ngwi abu ka kye Ongwɛ Inggisɛ gyaa?>> ");
INSERT INTO utr_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Ngwi ama nkyɛdɔ iYesu di dafi ungwɔ ka wa kyɔ nɛ, a gbɛɛ, <<Otsɛ, ni eyi gblibe yi okwusunkli mgbi eyii?>> ");
INSERT INTO utr_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Onyi mi idzidzɛ mgbi ama kyi kwɔdzɛ adɔ abugye mgbi ongbidɔ mgbi okwukwo inggisɛ ofifɛ. ");
INSERT INTO utr_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Kpaa iYesu gbɛɛ, <<I gyɔ ngha!>> Man o si yile inggisɛ na adɔ bɛkɛ. ");
INSERT INTO utr_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Nɛta iYesu nya engyukwo ama ofifɛ mgbi Imgbasho bɛyi ama nle ngyo mi ozu okwukwo osunu Imgbasho mi iJerosalin bɛyi engyukwo emi iJuda, ama nba mbon na gbɛɛ, <<Kyɔsinɛse, ngwi ema ba mbi ani yi okwusunkli bɛyi okwuta dafi ani li inggisɛ ofofɛ nghaa? ");
INSERT INTO utr_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Alegbe ani li dzɛ yi ema mi ozu okwukwo osunu Imgbasho mi iJerosalin, kpaa ema bwa ani ba. Nghaduu nɛnɛ li onɔ mgbi ema ngwi iyifu sɔ utɔ aani.>> ");
INSERT INTO utr_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Nghanɛ a bwa iYesu, a kyon lu udɛ mgbi okwukwo inggisɛ ofifɛ mgbi Imgbasho. IPyita kyɛ ma iyikpa mbombo. ");
INSERT INTO utr_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","A kye ola wo ifyɛ le wɛ, iPyita kpaa sɔ le wɛ yi ama. ");
INSERT INTO utr_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Ongwongyiidɔ din dafi o sɔdzɛ le wola nɛ, o din inɛ si gbɛɛ, <<Inggisɛ nɛ kpaa dzɛ yi iYesu.>> ");
INSERT INTO utr_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Nghaduu o tangwɛ gbɛɛ, <<Ongyaa, ani yama yen ba.>> ");
INSERT INTO utr_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Ngwi onɔ kɛ gwee nɛ, inggisɛ oka di gbɛɛ, <<Abu kpaa li onyi mboma.>> IPyita gbɛɛ, <<Ongyulɔ, li ani ba.>> ");
INSERT INTO utr_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","I mɛ dafi obyi onyi sini ta inggisɛ oka biibɛ gbɛɛ, <<Otsitsi inggisɛ nɛ li kyɛ yan, bana o li inggisɛ iGalalia.>> ");
INSERT INTO utr_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Nɛ iPyita gbɛɛ, <<Inggisɛ nɛ, ani yama ye ungwɔ ngwi abu le gbɔ na ba!>> Labɔlabɔ ngwi o kale gbɔdzɛ nɛta, ogbigbi teela. ");
INSERT INTO utr_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Otsɛ iYesu si kyata inɛ byi iPyita yɛyɛ. Man iPyita wɛ odzɛ ngwi iYesu gbɔ yan mani gbɛɛ: <<Duuse ni ogbigbi wa teela mi otu inɛ nɛni, abu ka tangwɛ ani akpe eta.>> ");
INSERT INTO utr_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Man iPyita tasɛ lu esɛ ka tsukwu kpakpa. ");
INSERT INTO utr_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Ama nle ngyo iYesu ma wita onyan agya dile gbon ibe. ");
INSERT INTO utr_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","A kye ungwɔ bwan inɛ di byita gbɛɛ, <<Yegbɔ ka! Li emɛ kye ungwɔ gbo abu?>> ");
INSERT INTO utr_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","A di gbɔ agya angbeka kwuba nyan. ");
INSERT INTO utr_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Ngwi egbe wa fa nɛ, okwakye mgbi engyukwo emi iJuda, ngwi engyukwo ama ofifɛ mgbi Imgbasho yi etsetse mgbi ola ba wa kwakye nɛ, a kye iYesu kɛ mboma. ");
INSERT INTO utr_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","A gbɛɛ, <<Ni abu li iKrestu mayɔ, nya eyi.>> IYesu nu ma uka gbɛɛ, <<Ni ani nya ema kpaa ema ka nu ani oyɛyɛ ba, ");
INSERT INTO utr_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","ma ni ani byi ema ita kpaa ema ka yagba onu ani uka ba. ");
INSERT INTO utr_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Nghaduu i wita mi onɛnɛ lu iyayi, Ongwɛ Inggisɛ ka sɔ mi abugye mgbi Imgbasho Ongha yi mfye.>> ");
INSERT INTO utr_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Ama duu byun gbɛɛ, <<Li abu nɛ li Ongwɛ Imgbashoo?>> O nya ma gbɛɛ, <<Ema gbɛɛ ani li ongwu.>> ");
INSERT INTO utr_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Ta a di gbɛɛ, <<Kyɔnɛ ngwi eyi di mina obwɛndɛ angbeka? Bana eyi abueyi fwo mi ondun.>> ");
INSERT INTO utr_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Ta ibyi inggisɛ ama nkwakye duu kyato kye iYesu kɛ mbi iPlatu iGɔna mgbi emi iRoma. ");
INSERT INTO utr_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","A le mwonya odzɛ ban gbɛɛ, <<Eyi tu inggisɛ nɛ le nu emideyi boofɛ. O di fwa gbɛɛ nu ma ka kpa udza ifyɛɛ nu iSidza ba. O di gbɛɛ ongwu li iKrestu, Utɔ.>> ");
INSERT INTO utr_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Nɛ iPlatu byi iYesu gbɛɛ, <<Abu li utɔ mgbi emi iJudaa?>> IYesu nu uka gbɛɛ, <<Ɛɛn, li ngha dafi abu gbɔ mani.>> ");
INSERT INTO utr_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","IPlatu si diyɛ nya engyukwo ama ofifɛ mgbi Imgbasho bɛyi ibyi inggisɛ gbɛɛ, <<N di inggisɛ nɛ yi obube ba.>> ");
INSERT INTO utr_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Kpaa a nghao biibɛ gbɛɛ, <<O le tsungwɔ di ba yi okakewo mi ali imbe duu mi iJudia. O wita mi iGalalia ba wa kaka iJudia mmɛnɛni.>> ");
INSERT INTO utr_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Dafi iPlatu fwo odzɛ nɛ nɛ, o byita kini iYesu li inggisɛ iGalalia yɔ. ");
INSERT INTO utr_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Ngwi o ye gbɛɛ iYesu kyɛ mi iGalalia imbe ngwi iHerude li utɔ nɛ, o kyon dɛsɔ lu mbi iHerude, ongwu nose kpaa baaba dzɛ iJerosalin mi onɔ nani. ");
INSERT INTO utr_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Ngwi iHerude di iYesu nɛ, i kpan kpakpa, bana onɔ kɛ ngwi o le mina odin. Mi odzɛ mgban ngwi o fwo ma, i minan odin no kyungwɔ okwulewo ngwi o le kyɔ mani. ");
INSERT INTO utr_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Nɛ iHerude byi iYesu ita kwuba, nghaduu o nun uka ba. ");
INSERT INTO utr_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Nɛta engyukwo ama ofifɛ mgbi Imgbasho bɛyi ama otso ola mgbi iMose kyatunto si mwonya odzɛ ban mi ali itɔ ali ibwubwe duu. ");
INSERT INTO utr_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Ta iHerude bɛyi eblakwutsɛ mgban nya iYesu odzɛ agya diyɛ shan isha ikwangha. A kye angwuto utɔ okwɔkwɔ won ewo, yilen lu ka nu iPlatu. ");
INSERT INTO utr_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Egbe na iHerude yi iPlatu yɛɛ uka, bana a tsekise dzɛ mi ikyili yi ewoma. ");
INSERT INTO utr_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","IPlatu si kwu engyukwo ama ofifɛ mgbi Imgbasho yi ama ogbe inggisɛ teyi bɛyi ibyi inggisɛ kwakye, ");
INSERT INTO utr_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","si nya ma gbɛɛ, <<Ema kye inggisɛ nɛ ba mbi ani gbɛɛ li ongwu le wɛ ibyi inggisɛ odzɛ gbɛɛ nu ma kyɔ odzɛ oshiishi. Ani kya mi inɛ mgbi ema nghaduu, n din yi ungwɔ ngwi ema le dulu ongwufabɔ mbon na ba. ");
INSERT INTO utr_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","IHerude kpa tun yi obube ba, bana o yilen dɛsɔ ba wa nu eyi; dafi ema di nɛ, inggisɛ nɛ kyɔ unkonyi mɛ ngwi o ka kwulu ba. ");
INSERT INTO utr_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Nghanɛ, n ka nu ma gbon ibe ta dzanta.>> ");
INSERT INTO utr_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","(IPlatu gbɔ ngha ikyesinɛ mi onɔ oga owɛ owatɔ-watɔ mgbi emi Israi ma, li wogyɔ gbɛɛ o ka dulu onyi mbi ama nwoto obawi ikye emi iJuda.) ");
INSERT INTO utr_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","A si feela ondonyi gbɛɛ, <<Ngwɔlu inggisɛ nɛni! Dzata iBaraba nu eyi!>> ");
INSERT INTO utr_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(IBaraba wodzɛ obawi ikyegbɛɛ o kyɔ ablodzɛ mi igeli di ngwɔ inggisɛ.) ");
INSERT INTO utr_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Dafi iPlatu mina odzata iYesu nɛ, o di gbɔdzɛ yi ama. ");
INSERT INTO utr_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Nghaduu a kiyayi yi ela ofaafa gbɛɛ, <<Gbokwon! Ngwɔlun!>> ");
INSERT INTO utr_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","IPlatu gbɔ yi ama akpe ongwu ta ma gbɛɛ: <<Mi ekyɛ? Li ali alobube ngwi o kyɔ? Ani tun yi obube mɛ onon kwulu ba. Nghanɛ n ka nu ma gbon ibe ta dzanta.>> ");
INSERT INTO utr_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Kpaa a kiyayi ofeela gbɛɛ nu ma ngwɔn, man ela mgbi ama nghan. ");
INSERT INTO utr_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Nɛ iPlatu yɛ gbela yi owitukwu mgbi ama. ");
INSERT INTO utr_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","O dulu inggisɛ nwodzɛ obawi ikyegbɛɛ o kyɔ ablodzɛ di ngwɔ inggisɛ, ongwu ibyi inggisɛ ntona mina mani, di dzata iYesu nu ma dafi a mina mani. ");
INSERT INTO utr_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Dafi ama oblakwutsɛ kye iYesu le lu nɛ, a bwa iSaimɔn inggisɛ mi iSirini, ongwu tɔkyɛ mi okwɔ le kaka igeli nani, man a bwan kye ekwatsi mgbi iYesu nun gbɛɛ no kye kyɛdɔn. ");
INSERT INTO utr_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Ibyi inggisɛ kyɛ ma iyikpa, bɛyi engyaa ama nle kyelela dile tsukwu won. ");
INSERT INTO utr_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Kpaa iYesu kyata inɛ di ma si gbɛɛ, <<Engwengyaa emi iJerosalin, ka tsukwu ikye ani ba; tsukwu ikye ewema bɛyi ɛngbɛ mgbi ema na. ");
INSERT INTO utr_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Bana onɔ kyɛma ngwi ema ka gbɛɛ, <Mse dzɛ yi engyaa ama nli ogyoma, ifu nmbongwɛ ba yi abɛ ngwi a nghaan ye waba mani!> ");
INSERT INTO utr_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Ta << <A ka gbɔ yi unggwɔ ntonɛ gbɛɛ, <<Yulu tukwu eyi!>> Bɛyi undɔ ntonɛ gbɛɛ, <<Gbobu tukwu eyi!>> > ");
INSERT INTO utr_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Bana ni inggisɛ kyungwɔ ntonɛ mi onɔ ngwi ekwɔ li eyuyu waali, ni ekwɔ wa ngwɔ ma ka dzɛ sinɛ?>> ");
INSERT INTO utr_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Ama ofofɛ nghi efa angbeka kpaa a kye ma tɔ owa ngwɔ. ");
INSERT INTO utr_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Ngwi a ba imbe ngwi a li kwun di dingbo nɛ, a kyon gbokwo ekwatsi, ama ofofɛ ntona kpaa a kye ma gbokwo ekwatsi, onyi mi abugye yi oka mi abubɛ mgban. ");
INSERT INTO utr_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Nɛ iYesu gbɛɛ, <<Otsani, dzamata, bana a ye ungwɔ ngwi a le kyɔ ba.>> Man a kyen angwuto kye ghalu mi efa ogboogbo. ");
INSERT INTO utr_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Inggisɛ ibyibyi kwuto le di; nghaduu ama ogbe inggisɛ teyi tole nyan agya gbɛɛ, <<O li dulu angbeka watɔ; non dulu ewon tɔ ki non li iKrestu mgbi Imgbasho, ongwu Imgbasho dulu gbɛɛ o ka wa dulu ɛsɛ watɔ ma yɔ!>> ");
INSERT INTO utr_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Ama oblakwutsɛ kpaa ba wa fan ɛsɛ. A kye eneekwɔ omama kye nun ");
INSERT INTO utr_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","di gbɛɛ, <<Kini abu li utɔ mgbi emi iJuda yɔ, dulu ewabu tɔ.>> ");
INSERT INTO utr_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","A lɔ ambɛ bɛkɛ ekwatsi mi ikye mgban gbɛɛ: <<Nɛnɛ li Utɔ mgbi emi iJuda.>> ");
INSERT INTO utr_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Onyi mbi ama ofofɛ ngwu a gbokwo ma yan nyan agya gbɛɛ: <<Abu li iKrestu ma baa? Dulu ewabu tɔ bɛyi eyi lɔ!>> ");
INSERT INTO utr_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Nghaduu oka na kyɔkyɔ yan gbɛɛ, <<Abu li mio Imgbasho lo, bana abu kpaa dzɛ mi odzili-dzili nɛni? ");
INSERT INTO utr_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Eyi yɔ, eyi le gbiisɔ ayin, bana eyi tu ungwɔ nmɛ mi ali ibwubwe ngwi eyi kyɔ. Kpaa inggisɛ nɛ yama kyɔ unkonyi obube ba.>> ");
INSERT INTO utr_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Ta o gbɛɛ, <<IYesu, wɛ ani mi onɔ ngwi abu kaka esutɔ mgbi abu.>> ");
INSERT INTO utr_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","IYesu si nyan gbɛɛ, <<Otsitsi n nya abu, inɛ nɛ abu ka dzɛ yi ani mi esutɔ mgbi Imgbasho.>> ");
INSERT INTO utr_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Ta ngwi onɔ dɔ idzidzɛ udɛ nɛ, ɛsɛ duu yifu nghataa obyi eta ongwi onɔdɛ, ");
INSERT INTO utr_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","bana onɔ tsɛ wuba. Man angwuto ngwi a kye tsɛ onufɛ idzidzɛ ozu osaan mi ozu okwukwo osunu Imgbasho mi iJerosalin na si gbua efa. ");
INSERT INTO utr_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Ta iYesu makwɔ mi ela okwukwo gbɛɛ, <<Otsani, n kye onodzi mgbi ani wokɛ abɔ mgbi abu.>> Ngwi o gbɔdzɛ nɛ mata, o si yulu. ");
INSERT INTO utr_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Dafi ongyukwo mgbi ama oblakwutsɛ mgbi iRoma di ungwɔ nkyɔ nɛ, o tsɛ Imgbasho di gbɛɛ, <<Otsitsi inggisɛ nɛ le saan.>> ");
INSERT INTO utr_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Ngwi ibyi inggisɛ ama nkwakye odi ungwɔ nle kiyayi di ungwɔ nkyɔ nɛ, eka kwowina loma ta a lu. ");
INSERT INTO utr_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Nghaduu emi odon duu, bɛyi engyaa ama nkyɛdɔn mi iGalalia kwulɛsɛ fyata le di ungwɔ ntonɛni. ");
INSERT INTO utr_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Mi onɔ na inggisɛ oka dzɛ ngwu a li kwun di iJose, ongwu li onyi mbi ama odi mi ola mgbi emi iJuda, o li inggisɛ osuse dile saan kpaa, ");
INSERT INTO utr_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","ongwu gbela yi owitukwu bɛyi okyɔɔkyɔ mgbi emidan ama odi mi ola mi ikye iYesu na ba. O li inggisɛ mi ogalu Arimatia ayɛsɛ mgbi iJudia o dile fɛ obaaba mgbi esutɔ mgbi Imgbasho. ");
INSERT INTO utr_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Inggisɛ nɛ kɛ mbi iPlatu ka bɔn ikwɔ mgbi iYesu. ");
INSERT INTO utr_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Ta o kye sulu ikwɔ mgbi iYesu ba esɛ, o si kye angwuto onzundzɛ ndiwon kyon ka ndzi mi endzi ngwi a cɛfo mi ikwutsɛ, ongwi a teyi kye ikwɔ ndzi mi ele ye waba mani. ");
INSERT INTO utr_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Ungwɔnɛ kyɔ egbe idɔ eda mi onɔdɛ, ngwi a le wewo ikye egbe otonyewo. ");
INSERT INTO utr_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Engyaa ama nwafɔ yi iYesu mi iGalalia ntona kyɛdɔ iJose wa di endzi di di dafi a kyon ka ndzi mi ele mani. ");
INSERT INTO utr_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Nɛ a yɛ lu ka mɛ ungwɔ ogbungbɛ yi engyie ngwi a ka kye gyuon ewo. Nghaduu a tonya mi egbe otonyewo dafi ola mgbi ama gbɔ mani. ");
INSERT INTO utr_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Mi egbe ongwi ababɔ mi ikyidu, mi egbegbe byibyiibyi, engyaa ntona kye ungwɔ ogbungbɛ yi engyie ngwi a mɛ ma, kɛ endzi. ");
INSERT INTO utr_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","A kɛ ka di a kyi mulu ikwutsɛ ma mi ondendzi, ");
INSERT INTO utr_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Ngwi a kaka ele nɛ, a tu ikwɔ mgbi Otsɛ iYesu ba. ");
INSERT INTO utr_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Dafi a le tsɛwɛ mi ele nɛ, vla nɛta engyulɔ nghi efa kwulɛsɛ kwɛkwɛ yi ama, wo angwuto onzundzɛ dafi mmbwo onaabɔ mani. ");
INSERT INTO utr_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Imio wo engyaa ntona ta a si kye inɛ kwɛsɛ, engyulɔ ntona nya ma gbɛɛ, <<Kyɔnɛ ngwi ema le pita inggisɛ oshishe mi imbe emi ikwukwɔ? ");
INSERT INTO utr_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","O dzɛ mmɛnɛ ba; o kyɛɛ mi ikwu! Wɛ dafi o tsekise nya ema, ngwi o ka dzɛ yi ema mi iGalalia mani gbɛɛ: ");
INSERT INTO utr_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","<A ka kye Ongwɛ Inggisɛ wo emi ali ibwubwe abɔ kyɛmɛ, a ka gbokwon mi ekwatsi nghataa o ka kwulu, kpaa mi egbe ongwu ta ma o ka kyɛɛ mi ikwu.> >> ");
INSERT INTO utr_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Ta engyaa ntona wɛ elodzɛ mgban. ");
INSERT INTO utr_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Ngwi a yɛ mi endzi luba nɛ, a kye ungwɔ ntonɛ duu kye nya ama ogbikye iYesu iwyodonyi ntonani bɛyi angbeka duu. ");
INSERT INTO utr_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Li iMeri iMagidalin yi iJoana bɛyi iMeri onɔ iJɛnsi, bɛyi angbeka nto yi ama, nya ama ogbikye iYesu odzɛ nɛni. ");
INSERT INTO utr_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Nghaduu ama ogbikye iYesu nu engyaa ntona oyɛyɛ ba, ikyekyɛ elodzɛ mgbi ama dzɛ dafi li odzɛ ikwangha mani. ");
INSERT INTO utr_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Nɛ iPyita kyato tsinya lu mi endzi. O ka klɛsɛ di mi idzidzɛ endzi man di angwuto ngwi a kye ikwɔ mgbi iYesu ndiwo ma lato yuoma, ta o si yɛ lu, le tsɛwɛ yuon ungwɔ nkyɔ nani. ");
INSERT INTO utr_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Nɛ mi egbe nata ama okyɛdɔ iYesu efa le kɛ agwɔ oka ngwi a li kwun di Emau, ngwi mɛ dafi imai egyafa sini okyɛɛ kɛ iJerosalin. ");
INSERT INTO utr_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","A le kponya yi ewoma mi ungwɔ ama nkyɔ duu. ");
INSERT INTO utr_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Dafi a le gbɔdzɛ dile kponya mi ungwɔ ntonɛ yi ewoma nɛ, iYesu abuon ba wa wafɔ yi ama; ");
INSERT INTO utr_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","kpaa a tukwu ma inɛ odifwin. ");
INSERT INTO utr_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Nɛ iYesu byi ma gbɛɛ, <<Li ekyɛ ngwi ema le gbɔ le kɛ?>> A kwulɛsɛ, a shɛ inɛ ta ba. ");
INSERT INTO utr_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Onyi mbi ama efa na, ongwu a li kwun di iKlopa, byun gbɛɛ, <<Li abu ta li ingyoga mi iJerosalin ngwu ye ungwɔ ama nkyɔ mi egbe ntonɛ ba dɛɛn?>> ");
INSERT INTO utr_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Nghaduu iYesu byita gbɛɛ, <<Li alungwɔ?>> A gbɛɛ, <<Li odzɛ mgbi iYesu inggisɛ ongwi iNadzareti. O li oyegbɔ, elodzɛ mgban dzɛ yi mfye bɛyi okyɔɔkyɔ mi inai Imgbasho yi inggisɛ duu. ");
INSERT INTO utr_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Engyukwo ama ofifɛ mgbi Imgbasho bɛyi ama ogbe eyi teyi kyon nu ama ndzɛ yi mfye nu ma ngwɔn ikwɔ ikwongye, di kyon gbokwo mi ekwatsi; ");
INSERT INTO utr_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Ma eyi gbekabyi gbɛɛ o li ongwu nkyɛ owa dulu emi Israi watɔ mani. Ma li ekyɛ oka, nghaduu li egbe ongwu ta inɛ ngwi ungwɔ ntonɛ kyɔ waani. ");
INSERT INTO utr_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Nghanɛ, engyaa angbeka mi idzidzɛ mgbi eyi kyungwɔ okwulu eyi ewo. A kɛ endzi mi egbegbe ototu nɛni, ");
INSERT INTO utr_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","kpaa yama tu ikwɔ mgban ba. A yɛ ba wa nya eyi gbɛɛ di ama di inɛ odiidi mgbi engyesɔ, ngwu nya ma gbɛɛ o dzɛ oshishe. ");
INSERT INTO utr_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Nɛ emideyi angbeka kɛ endzi ka di dafi engyaa ntona tsekise gbɔ mani, nghaduu ongwu yɔ a din ba.>> ");
INSERT INTO utr_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Ta iYesu nya ma gbɛɛ, <<Kyɔnɛ ema li ikwangha ngha, di kyɔnɛ ngwi ema kyɔ itukwu lɔɔ onoyɛyɛ mi alungwɔ ngwi ama ogbɛɛsɛ gbɔ dzɛ esɛ ngha? ");
INSERT INTO utr_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Dzɛ mbisɔ ngwi iKrestu ma ka gbiisɔ mi ungwɔ ntonɛ diyɛ kaka udɛ mgban okwɔkwɔ mi esho baa?>> ");
INSERT INTO utr_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","O si nu ma osa mi ungwɔ ngwi Afɛ gbɔ mi ikye ongwu, wita mbi iMose bɛyi oyegbɔ angbeka duu. ");
INSERT INTO utr_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Dafi a dzɛ kwɛkwɛ okaka agwɔ ngwi a le kɛ ma nɛ, iYesu kyɔ dafi o ka nyɛ lu iyayi mani. ");
INSERT INTO utr_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Nghaduu a tɛkyɛ yan kpakpa gbɛɛ, <<dzɛ yi eyi, bana onɔ dzɛ kwɛkwɛ ogbɛsɛ egbe inɛ nɛ kpaa le ngyɛ wa.>> Man iYesu kaka ikye oka dzɛ yi ama. ");
INSERT INTO utr_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Ngwi o sɔkɛ ogye ungwogye yi ama nɛ, o kyi kyelu ibredi, kye mse bɛ ele, kye mwalu si kye nu ma. ");
INSERT INTO utr_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Ta inɛ mgbi ama kwulu a si difwin, man o byulu wo ma inɛ. ");
INSERT INTO utr_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Engwafɔ ntona byi ewoma gbɛɛ, <<Ngwi o le gbɔdzɛ yi eyi mi ofɛ le kɛ dile nu eyi osa mi ungwɔ ngwi Afɛ gbɔ ma, itukwu gbɛɛgbɛ lo eyi baa?>> ");
INSERT INTO utr_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","A si kyato akponyi yɛ luba iJerosalin. A wa tu iwyodonyi ntona bɛyi angbeka kwakye to imbe nani ");
INSERT INTO utr_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","di gbɛɛ, <<Li otsitsi! Otsɛ iYesu kyɛɛ mi ikwu, o di mblegba tu iSaimɔn.>> ");
INSERT INTO utr_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Ta ama okyɛdɔ iYesu efa ntona nya ma ungwɔ ngwi kyɔ mi ofɛ, dafi ama di difwi iYesu mi onɔ ngwi o kye mwalu ibredi mani. ");
INSERT INTO utr_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Mi onɔ ngwi a kale gbɔdzɛ mi ikye ungwɔnɛ nɛ, iYesu abuon kwudzɛ mi idzidzɛ mgbi ama di gbɔ yi ama gbɛɛ, <<Iyu no dzɛ yi ema.>> ");
INSERT INTO utr_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Nɛ i kwulu ma ewo imio di wo ma kpakpa, a le tsɛwɛ gbɛɛ ama di onodzi inggisɛ ikwukwɔ. ");
INSERT INTO utr_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Ta iYesu nya ma gbɛɛ, <<Kyɔsinɛ ngwi i le kaka ema ewo, ngwi itukwu di dzɛ ema efefa ngha? ");
INSERT INTO utr_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Di abɔ yi afɔ mgbi ani na. Li ani abuen! Ema kye abɔ gbo ani di; bana onodzi inggisɛ ikwukwɔ dzɛ yi ikpewo yi akpukpu dafi ema di ani dzɛyan nɛ ba.>> ");
INSERT INTO utr_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Ngwi o gbɔdzɛ nɛ mata, o kye abɔ yi afɔ mgban tso ma. ");
INSERT INTO utr_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Dafi a kale noyɛyɛ mi ele ba ikye gbɛɛ i kwulu ma ewo a di dzɛ yi atsa nɛ, o byi ma gbɛɛ, <<Ema dzɛ yi ungwɔ ogyeegye mmɛnɛ wɛ?>> ");
INSERT INTO utr_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","A si kye ambulu mmbweni oshaasha yi ikpɔkpewo nun, ");
INSERT INTO utr_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","man o kye gye mi inai ma. ");
INSERT INTO utr_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","O nya ma gbɛɛ, <<Nɛnɛ li ungwɔ ngwi ani nya ema onɔ ngwi ani ka dzɛ yi ema mani: Alungwɔ ngwi a lɔ mi ola mgbi iMose bɛyi olɔɔlɔ mgbi ama ogbɛɛsɛ yi iPaslami duu mbwumbwo kyɛmɛ mi ikpewo ani.>> ");
INSERT INTO utr_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Nɛ o kwulu ma itukwu onu ma difwi Afɛ mgbi Imgbasho, ");
INSERT INTO utr_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","o nya ma gbɛɛ, <<Nɛnɛ li ungwɔ ngwi a lɔ ma aani: iKrestu ma ka gyadzɛ di kwulu di kyɛɛ mi ikwu mi egbe ongwu ta, ");
INSERT INTO utr_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","nɛ a kale gbeesɔ mgbi itukwu okyata-kyata bɛyi odzata inggisɛ yi ali ibwubwe mi iyi mgban mi ɛsɛ duu, wita mi iJerosalin. ");
INSERT INTO utr_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Ema li obwɛndɛ mi ungwɔ ntonɛni. ");
INSERT INTO utr_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Ani ka kye ungwɔ ngwi Otsani Imgbasho zondu ma kye dɛsɔ nu ema; kpaa tila to ogalu iJerosalin na nghataa ni Imgbasho wa kye mfye mi esho nu ema se.>> ");
INSERT INTO utr_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Onɔ ngwi iYesu gbe engwafɔɔn tasɛ lu iBetani nɛ, o kyile abɔ esho di kye mse bɛ ma ewo. ");
INSERT INTO utr_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Ngwi o kye mse le bɛ ma ewo nɛ, o dzata ma ta a si kyon lu esho. ");
INSERT INTO utr_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Ta a sunun diyɛ luba iJerosalin yi atsa kpakpa. ");
INSERT INTO utr_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Nɛ a kiyayi otsɛ Imgbasho mi ozu okwukwo osunu Imgbasho mi iJerosalin, alegbe-alegbe.");
INSERT INTO utr_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Mi owita-wita mgbi ɛsɛ ma Elodzɛ dzɛ, Elodzɛ na dzɛ yi Imgbasho, Elodzɛ na di li Imgbasho. ");
INSERT INTO utr_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","O dzɛ yi Imgbasho mi owita-wita mani. ");
INSERT INTO utr_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Alungwɔ ngwi Imgbasho ta duu nyɛ mbon, ni li Ongwu bayɔ ungwɔ ngwi Imgbasho ta duu o ki ta ba. ");
INSERT INTO utr_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Li mbon ngwi oshishe dzɛ, ma oshishe na li osa mgbi inggisɛ. ");
INSERT INTO utr_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Osa na di gbosa mi iifu kpaa iifu difwin gbɛ ba. ");
INSERT INTO utr_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Imgbasho kye inggisɛ oka dɛsɔ ba, iyin di iJɔn. ");
INSERT INTO utr_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","O ba ikye owa nu obwɛndɛ mgbi osa na, adzi ni inggisɛ duu noyɛyɛ mi osa nani. ");
INSERT INTO utr_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Li ongwu abuon li osa ma ba, o ba ikye owa kyɔ osa na obwɛndɛ ta. ");
INSERT INTO utr_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Osa otsitsi nka nu ali inggisɛ odifwi-difwi ma ka kyɛma le ba ɛsɛ nɛni. ");
INSERT INTO utr_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","O teyi dzɛ ɛsɛ nɛni, dafi Imgbasho ta ɛsɛ nɛ mbon nɛ kpaa, emi ɛsɛ difwin ba. ");
INSERT INTO utr_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","O ba mbi ama nli mgban kpaa a gbela gban ba. ");
INSERT INTO utr_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Nghaduukpaa ama ngban mani, mbi ama nnoyɛyɛ mi iyi mgban ma, o nu ma ofɛ oyɛɛ emi ongwɛ Imgbasho, ");
INSERT INTO utr_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","engwɛ ngwu a mba ma mi mmbwɛ yi eyi ba, hona mi ɛwɛ otsɛɛtsɛ mgbi inggisɛ owamyɛ naadi mi owitukwu mgbi obongyaa ba, kpaa nli ombaamba mgbi Imgbasho mi onodzi mani. ");
INSERT INTO utr_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Ta Elodzɛ na yɛɛ inggisɛ wa dzɛ yi eyi. Eyi di okwɔkwɔ mgban, okwɔkwɔ mgbi Ongwɛ Imgbasho Onyi kpokpo, ntɔkyɛ mbi Otsɛ Imgbasho, ngwu elela mgban mbwo le fɛ-fɛ bɛyi otsitsi nani. ");
INSERT INTO utr_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","IJɔn kyɔ obwɛndɛ ikyon. O di gbɔ mi ela okwukwo gbɛɛ, <<Nɛnɛ li ongwu ani gbɛɛ, <Ongwu nkyɛ ani iyikpa ma o ngha ani, ikyekyɛ o teyi ani dzɛ.> >> ");
INSERT INTO utr_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Elela mgban nle dzii ikye eyi nɛ, nu eyi duu gbumse idzidza-dzidza. ");
INSERT INTO utr_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Bana a kye ola nu mi abɔ mgbi iMose; elela bɛyi otsitsi ba mi abɔ mgbi iYesu iKrestu. ");
INSERT INTO utr_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Inggisɛ onyi di Imgbasho ye ba, sede li Ongwɛ onyi kpokpo ndi li Imgbasho mi otsitsi di wodzɛ ifafɔ yi Otsɔn nani, li ongwu tso eyi dafi Imgbasho dzɛ aali. ");
INSERT INTO utr_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Onɔ oka nɛ, engyukwo emi iJuda ama nto iJerosalin dɔ ama ofifɛ mgbi Imgbasho bɛyi emi iLevi esɔ nu ma ka byi iJɔn ita gbɛɛ, o li emɛ. ");
INSERT INTO utr_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","O kye da ma ba, o gbɛɛ, <<Ani li iKrestu ma ba.>> ");
INSERT INTO utr_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","A byun gbɛɛ, <<Nghama abu li emɛ? Abu li Elaijaa?>> O gbɛɛ, <<Ei li ani ba.>> <<Abu li oyegbɔ maa?>> O gbɛɛ, <<Ei.>> ");
INSERT INTO utr_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Mi ongyɛɛngyɛ nɛ a si byun gbɛɛ, <<Abu li emɛ? Nu eyi elodzɛ ngwi eyi ka yilen ka nya ama ndɔ eyi esɔ ntonani. Abu gbɔsinɛ mi ikye ewabu?>> ");
INSERT INTO utr_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","IJɔn nu ma uka mi elodzɛ mgbi oyegbɔ Adzaya gbɛɛ, <<Ani li ela mgbi ongwu nle kwu mi okwɛsɛ gbɛɛ, <Mɛlu ofɛ mgbi Otsɛ no byi yɛyɛ.> >> ");
INSERT INTO utr_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Ama ngwu a dɔ ma esɔ ma li emi iFarasi. ");
INSERT INTO utr_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","A byun gbɛɛ, <<Ni abu li iKrestu, naadi Elaija, hona oyegbɔ kpaa ba ma, i kyɔsinɛ ngwi abu le kyɔ inggisɛ iBatisima?>> ");
INSERT INTO utr_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","IJɔn nu uka gbɛɛ, <<Ani le kyɔ inggisɛ iBatisima yi eni, kpaa inggisɛ oka kwudzɛ idzidzɛ mgbi ema, ongwu ema yon ba. ");
INSERT INTO utr_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","O kyɛ ani iyikpa, odi okpafɔ mgban kpaa ani mɛ oshɛ ba.>> ");
INSERT INTO utr_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Ungwɔ ntonɛ duu kiyayi mi iBetani, mi oyombo ekyoo iJodan, imbe ngwi iJɔn le kyɔ inggisɛ iBatisima mani. ");
INSERT INTO utr_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Tegblifan iJɔn di iYesu kyɛ le ba mbon nɛta o gbɛɛ, <<Dii ongwummala mgbi Imgbasho, ongwu nkyi kyelu alobube mgbi ɛsɛ mani! ");
INSERT INTO utr_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Li ongwu ani nya ema odzɛ mgban gbɛɛ, <Inggisɛ oka kyɛma ngwu ngha ani, ikyekyɛ o teyi ani dzɛ.> ");
INSERT INTO utr_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Ani abuani kpaa nose yon ba, kpaa itɔdzɛ ngwi ani ba le kyɔ inggisɛ iBatisima yi eni ma, li ikye okyon tso mbi emi Israi.>> ");
INSERT INTO utr_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Ta iJɔn si nu ma obwɛndɛ nɛni: <<Ani di Onodzi Osaan tashulu mi esho dafi anyama mani wa tila dɔnkɛ ewo. ");
INSERT INTO utr_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Ani kika yon ba, nghaduu Imgbasho ndɔ ani esɔ owa kyɔ inggisɛ iBatisima yi eni ma nya ani gbɛɛ, <Ongyulɔ ngwu abu di Onodzi mgbi ani tila dɔnkɛ ewo ma, li ongwu ka kyɔ inggisɛ iBatisima yi Onodzi Osaan aali.> ");
INSERT INTO utr_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Ani di kyɔ obwɛndɛ gbɛɛ nɛnɛ li Ongwɛ Imgbasho.>> ");
INSERT INTO utr_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Tegblifan nɛ iJɔn diyɛ kwudzɛ yi engwafɔɔn nghi efa. ");
INSERT INTO utr_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Ngwi o dili iYesu nyɛ le lu nɛta o gbɛɛ, <<Dii, li Ongwɛ Mmala mgbi Imgbasho ma aani!>> ");
INSERT INTO utr_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Ngwi engwafɔ mgban ntonɛ fwo odzɛ ngwi o gbɔ nɛta, a kyɛdɔ iYesu. ");
INSERT INTO utr_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Ngwi iYesu kyata di ma kyan iyikpa nɛ, o byita gbɛɛ, <<Li ekyɛ ngwi ema mina?>> A gbɛɛ, <<Otsetse, li mi ole ngwi abu dzɛ?>> ");
INSERT INTO utr_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","O gbɛɛ, <<Ba ta ema ka di.>> Man a kɛ ka di imbe ngwi o dzɛ mani, diyɛ dzɛyan mi egbe na olɔlɔ duu. Onɔ li obyi enɛ ongwi onɔdɛ sini. ");
INSERT INTO utr_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Andru, ongwunɔ iSaimɔn iPyita, li onyi mi idzidzɛ inggisɛ efa ama nfwo odzɛ ngwi iJɔn gbɔ di kyɛdɔ iYesu mani. ");
INSERT INTO utr_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Ungwɔ ababɔ ngwi Andru kyɔ yɔ, o pita iSaimɔn ongwunɔn nyan gbɛɛ, <<Eyi tu Onagbɛ ngwu Imgbasho zondu ma wa>> (ongwu nli iKrestu nani). ");
INSERT INTO utr_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Nɛ o si kyon luba mbi iYesu. IYesu din inɛ si gbɛɛ, <<Abu li iSaimɔn ongwɛ iJɔn. A ka kwu abu di iKefa>> (ngwi a li kwun di iPyita, ngwi itan li ikwutsɛ nani). ");
INSERT INTO utr_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Tegblifan iYesu wewo le lu iGalalia. O wa tu iFyilipi si nyan gbɛɛ, <<Kyɛdɔ ani.>> ");
INSERT INTO utr_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","IFyilipi li inggisɛ mi iBɛtsaida imbe onyi yi Andru bɛyi iPyita. ");
INSERT INTO utr_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","IFyilipi tu iNataniɛ si nyan gbɛɛ, <<Eyi tu ongwu iMose lɔ odzɛ mgban mi afɛ mgbi ola, ongwu ama ogbɛɛsɛ kpaa lɔ odzɛ mgban nani, iYesu ongwi iNadzareti, ongwɛ iJose.>> ");
INSERT INTO utr_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Ta iNataniɛ byita gbɛɛ, <<Ungwɔ osuse ka yagba tɔ mi iNadzaretii?>> IFyilipi gbɛɛ, <<Ba wa di.>> ");
INSERT INTO utr_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Ngwi iYesu di iNataniɛ kyɛ le to kwɛkwɛ nɛ, o gbɔdzɛ mi ikpewon gbɛɛ, <<Nɛnɛ li inggisɛ Israi otsitsi, ongwu atsika onyi dzɛ mbon ba.>> ");
INSERT INTO utr_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","INataniɛ byita gbɛɛ, <<Abu kyɔsinɛse ye ani?>> IYesu nu uka gbɛɛ, <<Ani di abu ngwi abu ka dzɛ ita andundu duuse ni iFyilipi wa kwu abu ela.>> ");
INSERT INTO utr_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Man iNataniɛ byakpa ghatɔ gbɛɛ, <<Otsetse, abu li Ongwɛ Imgbasho; abu li Utɔ mgbi Israi.>> ");
INSERT INTO utr_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","IYesu gbɛɛ, <<Abu noyɛyɛ ikyekyɛ ani nya abu gbɛɛ ani di abu mi ita andundu. O ka wa di ungwɔ ama nshewo ngha ntona kpaa.>> ");
INSERT INTO utr_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","O diyɛ kiyayi gbɛɛ, <<N nya ema otsitsi, ema ka di esho ka kwulu lakɛ asisa, engyesɔ mgbi Imgbasho kale kɛ esho yɛ ba esɛ mbi Ongwɛ Inggisɛ.>> ");
INSERT INTO utr_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Mi egbe ongwu ta ma eba okwokyiikwokyi dzɛ ogalu iKana mi ɛsɛ iGalalia. Onɔ iYesu dzɛ ele, ");
INSERT INTO utr_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","nɛ iYesu yi engwafɔ mgban kpaa a bɔ ma eba okwokyiikwokyi nani. ");
INSERT INTO utr_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Ngwi eneekwɔ wa ngyɛ nɛ, onɔ iYesu nyan gbɛɛ, <<A sulu eneekwɔ wuba.>> ");
INSERT INTO utr_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","IYesu nyan gbɛɛ, <<Onɛn, li ekyɛ ngwi abu kye ani le wokɛ ele? Onɔ mgbi ani gyɔ waba.>> ");
INSERT INTO utr_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Onɔn si nya engbidɔ ntona gbɛɛ, <<Kyɔ alungwɔ ngwi o nya ema duu.>> ");
INSERT INTO utr_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Atankpɛ akwutsɛ mgbi eni nghi egyin to kwɛkwɛ mi imbe nani, itɔ ngwi emi iJuda li sa ewoma mi odzɛɛdzɛ aletɔ mgbi ama mani, ali atankpɛ li kye ikpɔkpɔ eni mɛ osu lu osudiwyo. ");
INSERT INTO utr_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","IYesu nya engbidɔ ntona gbɛɛ, <<Kweni mbwo atankpɛ ntonɛ na.>> A si kweni mbwo ma kyɛɛ kyɛɛ. ");
INSERT INTO utr_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Ta o nya ma gbɛɛ, <<Onɛnɛ yɔ, mwa ka nu ongyukwo mgbi oga nɛ tsatso na.>> A si kyɔ dafi o gbɔ mani, ");
INSERT INTO utr_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","man ongyukwo mgbi oga nɛ mbadi eni ngwi o kyatan yɛɛ eneekwɔ nani. O ye imbe ngwi eneekwɔ nɛ tɔkyɛ ba, kpaa engbidɔ ama nkweni ma ye. O kwu obongyaa ofufɛ ela lu enggengga, ");
INSERT INTO utr_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","ka gbɛɛ, <<Ali inggisɛ li teyi kye eneekwɔ osuse tasɛ se wa kye obube ba olɛlɛ onɔ ngwi ingyoga wa ungwɔ kpakpa mani, nghaduu abu kye osuse da nghataa ba onɛnɛni.>> ");
INSERT INTO utr_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Nɛnɛ li ambɛ okwulewo ongwi ababɔ ngwi iYesu kyɔ mi iKana mi iGalalia. O kye okwɔkwɔ mgban tso, nɛta engwafɔ mgban si kye oyɛyɛ onuunu mgbi ama byikɛ mbon. ");
INSERT INTO utr_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Ungwɔnɛ wa ngyɛ man o lu iKapenahun yi onɔn yi emi ongwunɔn bɛyi engwafɔ mgban. A la imbe na egbe efa. ");
INSERT INTO utr_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Ngwi oga owɛ owatɔ-watɔ mgbi emi iJuda na wa dzɛ kwɛkwɛ nɛ, iYesu lu iJerosalin. ");
INSERT INTO utr_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","O ka to ifoozu okwukwo osunu Imgbasho mi iJerosalin nani, o di inggisɛ tole kye mnda, mmala yi anyama le gya, angbeka sɔto ewo adinyatsɛ tole nyinɛ awuya. ");
INSERT INTO utr_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Ta o shi onitse mi osha, si lɔ ma onya duu tasɛ mi ifoozu okwukwo osunu Imgbasho, bɛyi emi mmala yi mnda tsatsa; o kye ganya awuya mi adinyatsɛ mgbi ama onyinɛ awuya di kyi kyata adinyatsɛ ma tukwu esɛ. ");
INSERT INTO utr_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Ama nkye anyama le gya ma o nya ma gbɛɛ, <<Gbelu ungwɔ ntonɛ tasɛ mmɛnɛ na! Kyɔnɛ ngwi ema kyata ozu mgbi Otsani yɛɛ idu!>> ");
INSERT INTO utr_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Engwafɔ wɛ dafi a lɔ gbɛɛ, <<Okpitukwu mgbi ani mi ikye ozu mgbi abu le gbɛ mi itukwu mgbi ani dafi ola mani.>> ");
INSERT INTO utr_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Emi iJuda byita gbɛɛ, <<Li ali ambɛ okwulewo ngwi abu ka yagba tso eyi zukwu ni eyi difwi mfye ngwi abu sulun se kyɔ itɔ ungwɔ ntonɛnɛ?>> ");
INSERT INTO utr_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","IYesu nu ma uka gbɛɛ, <<Gbobu ozu okwukwo osunu Imgbasho nɛni, ta ani ka yilen mbɛ mi egbe eta.>> ");
INSERT INTO utr_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Emi iJuda byun gbɛɛ, <<I kye onova ngwusefa dɔn egyin ombɛ ozu nɛni, nghanɛ abu ka yilen mbɛ mi egbe eta taa?>> ");
INSERT INTO utr_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Nghaduu ozu okwukwo osunu Imgbasho ngwi o le gbɔdzan na li ewo mgban. ");
INSERT INTO utr_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Mi onɔ ngwi a wa kyilon mi ikwongye ma se engwafɔɔn wa ka wɛ odzɛ ngwi o teyi gbɔ nani. Man a si noyɛyɛ mi afɛ bɛyi elodzɛ ngwi iYesu teyi gbɔ. ");
INSERT INTO utr_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Dafi o ka dzɛ iJerosalin mi oga owɛ owatɔ-watɔ mgbi emi Israi nɛ, inggisɛ kwuba di ambɛ okwulewo ama ngwi o le kyɔ nɛta, a noyɛyɛ mi iyi mgban. ");
INSERT INTO utr_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Nghaduu iYesu gbela kye ewon nu ma ba, bana o ye ngyɛ ali inggisɛ duu. ");
INSERT INTO utr_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","O mina obwɛndɛ mgbi inggisɛ ikye inggisɛ ba, ikyekyɛ o teyi ye ungwɔ nwodzɛ mbi inggisɛ mani. ");
INSERT INTO utr_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Inggisɛ iFarasi oka nose dzɛ iyin di iNikodemu, o li onyi mi idzidzɛ mgbi ama o gbe emi iJuda teyi. ");
INSERT INTO utr_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","O ba mbi iYesu mi otu wa nyan gbɛɛ, <<Otsetse, eyi ye abu li otsetse nkyɛ mbi Imgbasho. Bana inggisɛ onyi ka yagba kyɔ ambɛ okwulewo ama ngwi abu le kyɔ nɛ ba ni Imgbasho dzɛyan bayɔ.>> ");
INSERT INTO utr_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","IYesu nu uka gbɛɛ, <<N le nya abu otsitsi, inggisɛ onyi ka yagba di esutɔ mgbi Imgbasho gbɛ ba se ni a yilen mba akpe efa.>> ");
INSERT INTO utr_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","INikodemu byita gbɛɛ, <<A ka kyɔsinɛse yile inggisɛ mba ngwi o yɛɛ omyinɛ nɛ? O ka yagba yɛ kaka ifu mbi onɔn akpe ongwu fan ni a yilon mba gbɛɛ?>> ");
INSERT INTO utr_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","IYesu gbɛɛ, <<N le nya abu otsitsi, inggisɛ onyi ka kaka esutɔ mgbi Imgbasho ba se a ka mban mi eni bɛyi Onodzi. ");
INSERT INTO utr_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Mmbwɛ yi eyi li mba mmbwɛ yi eyi, Onodzi li mba onodzi. ");
INSERT INTO utr_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","No ka kwulu abu ewo mi odzɛ ngwi ani gbɔgbɛɛ, <Se a ka yile abu mba na ba.> ");
INSERT INTO utr_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Awo li fa lu imbe ngwi i mina. Abu ka fwo owulu-wulu mgban kpaa abu ka ye imbe ngwi i tɔkyɛ hona imbe ngwi i le kɛ ba. Li ngha ndzɛ yi ali inggisɛ ngwu a mban mi Onodzi aali.>> ");
INSERT INTO utr_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nɛ iNikodemu byita gbɛɛ, <<Ka kyɔsinɛse ungwɔnɛ ka dzɛ ngha gbɛ?>> ");
INSERT INTO utr_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","IYesu gbɛɛ, <<Ngwi abu li otsetse mgbi emi Israi nɛ kpaa, abu yagba difwi ungwɔ ntonɛ lo?>> ");
INSERT INTO utr_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","N le nya abu otsitsi, eyi ye ungwɔ ngwi eyi le gbɔ, eyi dile nu obwɛndɛ mi ungwɔ ngwi eyi di, nghaduu ema gbela yi obwɛndɛ mgbi eyi ba. ");
INSERT INTO utr_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Ani gbɔdzɛ yi abu mi ungwɔ ongwi ɛsɛ nɛ kpaa abu noyɛyɛ ba; ma ka kyɔsinɛse ngwi abu ka noyɛyɛ kini Ani gbɔdzɛ yi abu mi ungwɔ ongwi esho? ");
INSERT INTO utr_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Inggisɛ onyi kpaa kɛ esho ye ba se li Ongwɛ Inggisɛ nkyɛ esho nɛni. ");
INSERT INTO utr_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Dafi iMose nose byi ifa kyilen esho mi okwɛsɛ na li ngha a ka wa kyile Ongwɛ Inggisɛ esho kyɛmɛ aali, ");
INSERT INTO utr_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","adzi inggisɛ ngwu noyɛyɛ mbon yɔ no ka dzili ba, kpaa no tu oshishe gyegwu. ");
INSERT INTO utr_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","<<Lubana Imgbasho di ɛsɛ nɛ kpan itukwu jo o kye Ongwan onyi kpokpo nu, gbɛɛ ali inggisɛ nnun oyɛyɛ ta no ka dzili ba, kpaa no tu oshishe igyegwu. ");
INSERT INTO utr_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Bana Imgbasho dɔ Ongwan esɔ ba ɛsɛ ikye owa fwo ɛsɛ ikwɔ nun obube ba, kpaa li ikye ni ɛsɛ watɔ ikpewon. ");
INSERT INTO utr_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Ali inggisɛ nnun oyɛyɛ yɔ o ka dzili ba, kpaa ali inggisɛ nnun oyɛyɛ bayɔ teyi dzili wa ikyekyɛ o noyɛyɛ mi iyi mgbi Ongwɛ Imgbasho onyi kpokpo na ba. ");
INSERT INTO utr_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Nɛnɛ li ikwɔ ma aani: Osa ba ɛsɛ nɛni, kpaa inggisɛ nghao mina iifu ngha osa ikyekyɛ okyɔɔkyɔ mgbi ama li ibwubwe. ");
INSERT INTO utr_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Ali inggisɛ nkyungwɔ ibwubwe yɔ, o di osa lanyi nghanɛ o ka gbela ba imbe ngwi osa dzɛ ba di ali ibwubwe mgban wa dɔ ododa. ");
INSERT INTO utr_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Nghaduu inggisɛ nkye otsitsi teyi yɔ, o ka ba imbe ngwi osa dzɛ zukwu nu ma difwi saan gbɛɛ ungwɔ ngwi ongwu kyɔ nɛ kyɛ mbi Imgbasho.>> ");
INSERT INTO utr_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Ngwi ungwɔnɛ wa nyɛ nɛta iYesu yi engwafɔɔn tasɛ lu ikpɛsɛ iJudia, ka kye egbe gwee yi ama le kyɔ ma iBatisima. ");
INSERT INTO utr_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Onɔ na iJɔn kpaa le kyɔ iBatisima mi Ayenɔ kwɛkwɛ yi iSalin, ikyekyɛ eni kwoba ba, inggisɛ dile ba tonya ba gbɛɛ ni iJɔn kyɔ ma iBatisima. ");
INSERT INTO utr_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","(Ungwɔnɛ li onɔ ngwi a kye iJɔn wo obawi waba mani.) ");
INSERT INTO utr_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Angwodzɛ tɔ mi idzidzɛ mgbi engwafɔ iJɔn angbeka bɛyi inggisɛ iJuda oka mi odzɛ ewo ofwɔɔfwɔ. ");
INSERT INTO utr_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","A ba mbi iJɔn wa gbɔ yan gbɛɛ, <<Otsetse, inggisɛ ndzɛ yi abu nose mi oyombo iJodan ongwu abu kyɔ obwɛndɛ saan mi ikyon na, o le kyɔ iBatisima, ma ali inggisɛ duu le lu mbon.>> ");
INSERT INTO utr_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","IJɔn nu uka mi odzɛ nɛ gbɛɛ, <<Inggisɛ ka yagba kyungwɔ ba sede ni Imgbasho ongwi esho kye nun yɔ. ");
INSERT INTO utr_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Ema abuema ka kyɔ obwɛndɛ gbɛɛ ani teyi nya ema gbɛɛ, <Ani li iKrestu ma ba a dɔɔdɔ ani esɔ teyun ta.> ");
INSERT INTO utr_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Ongyaa ofufɛ li mgbi obongyaa ofufɛ. Uka mgbi obongyaa li fwoofwo yi obongyaa, o di li mbwo yi atsa onɔ ngwi o fwo ela mgbi obongyaa mani. Atsa na li mgbi ani, di li ngha ngwi atsa mgbi ani li mbwumbwo aali. ");
INSERT INTO utr_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","IYesu ka sheeshe lu iyayi, ani ka yɛɛyɛ esɛ. ");
INSERT INTO utr_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","<<Ongwu nkyɛ esho ba ma ngha duu, ongwu ntɔkyɛ ɛsɛ ma li mgbi ɛsɛ, o li gbɔdzɛ dafi inggisɛ nkyɛ ɛsɛ. Ongwu nkyɛ esho ma ngha duu. ");
INSERT INTO utr_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","O kyɔ obwɛndɛ mi ungwɔ ama ngwi o fwo diyɛ di, kpaa inggisɛ onyi gbela yi obwɛndɛ mgban ba. ");
INSERT INTO utr_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Inggisɛ ngbela yan gbela gbɛɛ Imgbasho li otsitsi. ");
INSERT INTO utr_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Lubana ongwu Imgbasho dɔn esɔ ma gbɔ elodzɛ mgbi Imgbasho, Imgbasho nun mfye mgbi Onodzi odondu ba. ");
INSERT INTO utr_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","O kpa Otsɔn itukwu o di kye alungwɔ duu dɔn ubɔ. ");
INSERT INTO utr_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Ali inggisɛ ngwu nu Ongwɛ oyɛyɛ yɔ dzɛ yi oshishe ogyegwu, ali inggisɛ nfwa Ongwɛ yɔ ka di oshishe ba, lubana itingga mgbi Imgbasho ka dzɛyan gyegwu.>> ");
INSERT INTO utr_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Emi iFarasi fwo gbɛɛ iYesu nghao le tu ama okyɛdɔn dile kyɔ ma iBatisima ngha iJɔn, ");
INSERT INTO utr_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","yama li iYesu abɔn le kyɔ iBatisima ba, kpaa li engwafɔɔn le kyɔ. ");
INSERT INTO utr_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","IYesu wa ye nghanɛ man, o dzata ayɛsɛ mgbi iJudia yidɔ lu iGalalia. ");
INSERT INTO utr_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","I wogyɔ ngwi o ka nyɛ ongwi iSamaria. ");
INSERT INTO utr_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Nɛ o wa to igeli mgbi iSamaria oka ngwi a li kwun di iSika, kwɛkwɛ yi ongwɛ imbe ngwi iJeko kye nu iJose ongwan nani. ");
INSERT INTO utr_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Ibuga mgbi iJeko dzɛ imbe nani, dafi indɛ mgbi agaba kwu iYesu nɛ, o sisɛ mi ewo ibuga ngwi onɔ dɔ idzidzɛ udɛ sini. ");
INSERT INTO utr_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Onɔ ngwi ongyaa iSamaria ba owa kweni nɛ, iYesu byun gbɛɛ, <<O ka nu ani eni owawa wɛ?>> ");
INSERT INTO utr_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","(Engwafɔ mgban lu ifu igeli oka gya ungwogye.) ");
INSERT INTO utr_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Ongyaa iSamaria na nyan gbɛɛ, <<Abu li inggisɛ iJuda, ani li ongyaa iBatlomi. Kyɔsinɛse ngwi abu le bɔ ani eni owawa?>> (Bana emi iJuda li kwokyi yi emi iBatlomi ba.) ");
INSERT INTO utr_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","IYesu gbɛɛ, <<Ni abu ki ye umba mgbi Imgbasho ndzɛ mi ikye mgbi abu bɛyi inggisɛ nle bɔ abu eni owawa nɛ yɔ, abu kika bɔ ta, o kika nu abu eni mgbi oshishe.>> ");
INSERT INTO utr_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Ongyaa na gbɛɛ, <<Ongyukwo, abu dzɛ yi odi okweni ba, ibu nɛ kɛ ma abu ka tu eni mgbi oshishe nɛ mi ole? ");
INSERT INTO utr_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Abu shewo ngha otseyi iJeko nkye ibuga nɛ nu eyi di weni mi ele abuon, ngwi ɛngbɛ mgban kpaa wa bɛyi ifyungwɔ mgban naa?>> ");
INSERT INTO utr_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","IYesu nyan gbɛɛ, <<Ali inggisɛ nweni nɛ yɔ ekweni ka yɛ kwun, ");
INSERT INTO utr_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","kpaa ali inggisɛ nweni ngwi Ani kye nun yɔ ekweni ka kwun wuba. Mi otsitsi, eni ngwi Ani kye nun na ka yaan uteeni di kale fɛ nghataa kaka oshishe gyegwu.>> ");
INSERT INTO utr_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Ongyaa na nyan gbɛɛ, <<Ongyukwo, nu ani eni nani adzi ni ekweni ka kwin wuba, nin di nya yi eni owa kwɔɔkwɔ.>> ");
INSERT INTO utr_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","IYesu nyan gbɛɛ, <<Ka kwu obabu ela no ba.>> ");
INSERT INTO utr_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","O gbɛɛ, <<Ani dzɛ yi ongyulɔ ba.>> IYesu gbɛɛ, <<O gbɔ ayin dafi abu gbɛɛ abu dzɛ yi ongyulɔ ba nani. ");
INSERT INTO utr_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Otsitsi, abu teyi sulu engyulɔ nghi eda, ongwu abu dzɛyan onɛnɛ nɛ kpaa li obabu ba. Odzɛ ngwi abu kwa gbɔ nɛ li otsitsi.>> ");
INSERT INTO utr_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Ongyaa na gbɛɛ, <<Ongyukwo, dzɛ ani dafi abu li oyegbɔ mani. ");
INSERT INTO utr_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Emi otseyi teyi li sunu Imgbasho mi unggwɔ nɛni, nghaduu ema emi iJuda yɔ li gbɛɛ li mi iJerosalin kyɛmɛ ngwi eyi ka sunu Imgbasho.>> ");
INSERT INTO utr_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","IYesu ghatɔ gbɛɛ, <<Ongyaa, nu ani oyɛyɛ, onɔ kyɛma ngwi ema ka wa sunu Otsɛ Imgbasho mi unggwɔ nɛ hona mi iJerosalin kpaa wuba. ");
INSERT INTO utr_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Ema emi iBatlomi le sunu ungwɔ ngwi ema yon ba; eyi emi iJuda yɔ, eyi le sunu ungwɔ ngwi eyi yon, bana owatɔ-watɔ kyɛ mbi emi iJuda. ");
INSERT INTO utr_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Lubana onɔ kyɛma di li onɔ ma aani, ngwi ali inggisɛ osunu mi otsitsi ka sunu Otsɔn Imgbasho mi onodzi bɛyi otsitsi kyɛmɛ, lubana li itɔ ama osunu ngwu Otsɔ Imgbasho le pita ma aali. ");
INSERT INTO utr_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Imgbasho li Onodzi, ama osunun nu ma sunun mi onodzi bɛyi otsitsi kyɛmɛ.>> ");
INSERT INTO utr_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Ongyaa na gbɛɛ, <<Ani ye Onagbɛ (ongwu a kwun di iKrestu ma) kyɛma. Onɔ ngwi o wa ba yɔ, o ka nu eyi osa mi alungwɔ duu.>> ");
INSERT INTO utr_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Man iYesu ghatɔ gbɛɛ, <<Li ani ma jo le gbɔdzɛ yi abu aani.>> ");
INSERT INTO utr_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Mi onɔ na mata engwafɔ mgban yɛ man i kwulu ma ewo dafi iYesu le gbɔdzɛ yi ongyaa mani. Nghaduu inggisɛ onyi byita gbɛɛ, <<Li ekyɛ ngwi abu mina naadi kyɔnɛ ngwi abu le kponya yi ongyaa baa?>> ");
INSERT INTO utr_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Ta ongyaa na dzata ishe eni mgban, yɛ lu igeli ka nya ali inggisɛ duu gbɛɛ, ");
INSERT INTO utr_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","<<Ba na, wa di inggisɛ ngwu nya ani alungwɔ ngwi ani plɛ kyɔ tsatsa nɛni. Li iKrestu ma dɛn hoo?>> ");
INSERT INTO utr_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","A tasɛ mi ogalu kpatsɛ ofɛ le lu mbon. ");
INSERT INTO utr_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Duuse nu ma ba yɔ, engwafɔɔn tɛkyɛ yan gbɛɛ, <<Otsetse, gye ungwogye.>> ");
INSERT INTO utr_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Nghaduu iYesu nya ma gbɛɛ, <<Ani sulu ungwogye ongwi ema ye ba mani.>> ");
INSERT INTO utr_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Nɛman engwafɔɔn tole gbɔ yi ewoma gbɛɛ, <<Naadi inggisɛ oka kye ungwogye wa nun?>> ");
INSERT INTO utr_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","IYesu gbɛɛ, <<Ungwogye mgbi ani, li okyɔ itukwu mgbi Ongwu ndɔ ani esɔ di ngyɛlu idɔ mgban ngwi o wo ani mani. ");
INSERT INTO utr_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Ema li gbɛɛ, <I sisi ofyia enɛ duuse onɔ oshɛ etɔ ka gyɔ baa>? Nin nya ema, kwulu inɛ di okwɔ na! A myɛ gyɔ oshɛ-shɛ. ");
INSERT INTO utr_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Onɛnɛ kpaa a le kpa inggisɛ oshɛ etɔ mi idɔ mgban, o dile shɛ etɔ mgbi oshishe ogyegwu na onɛnɛni, ikye ni inggisɛ ofwe etɔ bɛyi inggisɛ oshɛ etɔ wa dzɛ yi atsa yi ewoma. ");
INSERT INTO utr_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Nghanɛ elodzɛ ngbɛɛ, <Inggisɛ oka fwe-fwe etɔ oka di shɛ-shɛ na li otsitsi.> ");
INSERT INTO utr_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","N dɔ ema esɔ le ka shɛ etɔ ngwi li ema kya ba. Angbeka teyi kyɔlu idɔ nsunɔ mani ta ema tu mgbede mi idɔ mgbi ama.>> ");
INSERT INTO utr_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Emi iSamaria kwuba mi igeli na nu iYesu oyɛyɛ mi ikye obwɛndɛ mgbi ongyaa nani, ngwi o gbɛɛ, <<O nya ani alungwɔ ngwi ani teyi kyɔ tsatsadu.>> ");
INSERT INTO utr_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Nghanɛ ngwi emi iSamaria ba mbon nɛ, a tɛkyɛ nun gbɛɛ no dzɛ yi ama, man o si lela yi ama egbe efa. ");
INSERT INTO utr_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Elodzɛ mgban ogbɔɔgbɔ nu inggisɛ kwuba yɛɛ ama onoyɛyɛ. ");
INSERT INTO utr_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","A nya ongyaa na gbɛɛ, <<Eyi noyɛyɛ mi elodzɛ ngwi abu nya eyi na ta ba, onɛnɛ eyi fwo mi adɔ ibeyi, eyi di ye gbɛɛ ongyulɔ nɛ otsitsi-otsitsi o li Onagbɛ mgbi ɛsɛ nɛni.>> ");
INSERT INTO utr_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Ngwi egbe efa na nyɛ nɛta iYesu lu iGalalia. ");
INSERT INTO utr_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","(Bana ongwu abuon teyi gbɛɛ oyegbɔ sulu mmwɛ mi ɛsɛ udan ba.) ");
INSERT INTO utr_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Ngwi o kaka iGalalia nɛman emi iGalalia kyɔn onɔ. A di ungwɔ ama ngwi o kyɔ mi iJerosalin tsatsa mi oga owɛ owatɔ-watɔ mgbi emi Israi nani, ikyekyɛ ama kpaa kɛ ele. ");
INSERT INTO utr_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","O diyɛ kɛ igeli iKana mi ayɛsɛ mgbi iGalalia imbe ngwi o kyata eni yɛɛ eneekwɔ nani. Ongbodzi inggisɛ idɔ mgbi utɔ oka ongwan la ootse mi ɛsɛ iKapenahun. ");
INSERT INTO utr_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Ngwi inggisɛ nɛ fwo gbɛɛ iYesu dzata iJudia luba iGalalia nɛ, o si kɛ mbon ka tɛkyɛ nun gbɛɛ no ba wa bwe ongwan ongwu ndotse kaka ikwongye nani. ");
INSERT INTO utr_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Nɛ iYesu nyan gbɛɛ, <<Se ni ema di ambɛ yi ungwɔ okwulewo bayɔ ema ka noyɛyɛ ba.>> ");
INSERT INTO utr_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Ongbodzi inggisɛ idɔ mgbi utɔ na gbɛɛ, <<Ongyukwo, ba vla duuse ni ongwani wa kwulu.>> ");
INSERT INTO utr_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","IYesu gbɛɛ, <<O ka yagba lu, unka ka kyɔ ongwabu ba.>> Inggisɛ na gbela yi odzɛ ngwi iYesu gbɔ nɛ taman o si lu. ");
INSERT INTO utr_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Ngwi o kale kɛ ofɛ mani engbidɔ mgban wa nyan gbɛɛ ewo gbosa lo ongwan. ");
INSERT INTO utr_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","O byi ma onɔ ngwi ewo gbosa lon mani, a gbɛɛ, <<Li obyi onyi mi onɔ ngwi awo dzanta.>> ");
INSERT INTO utr_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Man otsɔn difwi dafi li onɔ na yɛyɛ ngwi iYesu gbɛɛ, <<Ongwabu ka dzɛ oshishe.>> Nɛta ongwu yi etɔ mgban duu noyɛyɛ. ");
INSERT INTO utr_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Li ambɛ okwulewo ongwu fan ngwi iYesu kyɔ mi onɔ ngwi o dzata iJudia luba iGalalia aani. ");
INSERT INTO utr_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Onɔ oka nɛ, iYesu di yidɔ kɛ iJerosalin mi oga mgbi emi iJuda. ");
INSERT INTO utr_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Ibu mmala dzɛ ogalu iJerosalin ngwi a li kwun di Onufɛ Ogalu Mmala ngwi dzɛ yi iwulu opo nghi eda, iyin mi ondu iHibru li iBɛtesda. ");
INSERT INTO utr_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Ibyi inggisɛ ama ndotse lato opo ntonani, ama obinɛ, ama ogbikye tukwu esɛ, bɛyi ama ngwu alewo kwulu.  ");
INSERT INTO utr_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Ongyesɔ li kyɛ esho wa kaka eni nani, di kyɔ akpeni: inggisɛ ongwu ababɔ nkaka mi onɔ ngwi akpeni le gbo na yɔ, ali ootse mgban duu li ngyɛ. ");
INSERT INTO utr_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Inggisɛ oka nose ladzɛ mmanani ngwu dotse onova osudiwyo diwyegyata. ");
INSERT INTO utr_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Onɔ ngwi iYesu din ladzɛ mmana di difwi gbɛɛ o dzɛ mi ootse na onɔ kɛ nɛ, o byun gbɛɛ, <<I mina abu gbɛɛ ni ootse mgbi abu ngyɛɛ?>> ");
INSERT INTO utr_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Inggisɛ ootse na si nu uka gbɛɛ, <<Ongyukwo, ani dzɛ yi inggisɛ onyi nka ya ani abɔ kye ani kaka ibu onɔ ngwi a kyɔ akpeni ba. Ni ani le fya gbɛɛ nin kaka ta inggisɛ oka li teyi ani.>> ");
INSERT INTO utr_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Nɛ iYesu nyan gbɛɛ, <<Kyato! Kyi kyelu obutu mgbi abu, kyikyɛ.>> ");
INSERT INTO utr_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Labɔlabɔ mata ootse mgban ngyɛ; o kyi kyelu obutu mgban si kyikyɛ. Mi egbe ngwi ungwɔnɛ kyɔ ma li egbe otonyewo, ");
INSERT INTO utr_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","nɛta emi iJuda ntona nya inggisɛ ngwu a ngyɛlun ootse na gbɛɛ, <<Li egbe otonyewo; ola fwa gbɛɛ ni abu ka kye obutu mgbi abu ba.>> ");
INSERT INTO utr_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Nghaduu o nu uka gbɛɛ, <<Inggisɛ ongwu ngyɛlu ani ootse na nya ani gbɛɛ, <Kyi kyelu obutu mgbi abu kyikyɛ.> >> ");
INSERT INTO utr_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Nɛ a byun gbɛɛ, <<Li ali inggisɛ nya abu gbɛɛ ni abu kyelu obutu mgbi abu kyikyɛ?>> ");
INSERT INTO utr_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Inggisɛ ngwu a ngyɛlun ootse na ye inggisɛ ma ba, ikyekyɛ iYesu lu dzanta kaka ifu ibyi inggisɛ. ");
INSERT INTO utr_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Onɔ gwee nɛ iYesu wa din mi ozu okwukwo osunu Imgbasho mi iJerosalin si nyan gbɛɛ, <<Dika, abu yɛɛ saan onɛnɛni. Ka kyɔ alobube wuba di ungwɔ ntimbi nghaabɔ nɛ wa kyɔ abu.>> ");
INSERT INTO utr_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Inggisɛ na yɛ lu ka nya emi iJuda ntona gbɛɛ li iYesu dzikan ngyɛlu ongwu ootse. ");
INSERT INTO utr_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Nghanɛ emi iJuda ntona wita opita iYesu mgbɛkyɛ ngwi o ngyɛlu inggisɛ ootse mi egbe otonyewo. ");
INSERT INTO utr_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","IYesu si nya ma gbɛɛ, <<Otsani le kyidɔ mgban alonɔ duu, li ngha ngwi ani kpaa le kyɔ aani.>> ");
INSERT INTO utr_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Mi ikye odzɛ nɛ emi iJuda ntonɛ fya mi oglijo mgbi ama duu ongwɔn; ikyegbɛɛ o le mbe ola mgbi egbe otonyewo ta ba, kpaa o dile kwu Imgbasho gbɛɛ Otsongwu, okye ewon yɛɛ ungwonyi yi Imgbasho. ");
INSERT INTO utr_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","IYesu nu ma uka sini: <<N nya ema otsitsi, Ongwɛ ka yagba kyɔ unkonyi abuon ba; o ka kyungwɔ ngwi o di Otsɔn le kyɔ ma kyoon ta, bana alungwɔ ngwi Otsɔn kyɔ ma Ongwɛ kpaa li kyɔ ngha yɛyɛ. ");
INSERT INTO utr_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Ikyesinɛ Otsɔngwɛ di Ongwɛ kpan itukwu di tson alungwɔ ngwi Ongwu li kyɔ duu. Ɛɛn, ikyegbɛɛ no kwulu ema ewo yɔ, ungwɔ ama nngha ongyɛlu inggisɛ nɛ ootse kpaa, Otsɔn ka kye tson. ");
INSERT INTO utr_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Dafi Otsɔn li kyile inggisɛ ikwukwɔ di li kye oshishe nu ma nɛ, li ngha ngwi Ongwɛ kpaa li kye nu ama ngwu ongwu mina okye nu aali. ");
INSERT INTO utr_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Nghaduukpaa Otsani li gbɔ inggisɛ onyi ikwɔ ba, o yile ikwɔ ogbɔɔgbɔ duu wo Ongwɛ abɔ, ");
INSERT INTO utr_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","ikyegbɛɛ nu ma kye mmwɛ nu Ongwɛ dafi a li kye nu Otsɔn kpaa yɛyɛ mani. Inggisɛ nkye mmwɛ nu Ongwɛ ba Otsɔn ndɔn esɔ ma kpaa o nun mmwɛ ba. ");
INSERT INTO utr_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","<<N nya ema otsitsi, inggisɛ nfwo elodzɛ mgbi ani di nu ongwu ndɔ ani esɔ ma oyɛyɛ yɔ, o dzɛ yi oshishe ogyegwu. O dika dzili ba; o fa mi ikwongye luba oshishe. ");
INSERT INTO utr_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","N nya ema otsitsi, onɔ kyɛma, i di ba kpaa wa ngwi emi ikwukwɔ ka fwo ela mgbi Ongwɛ Imgbasho, ama nfwo ma ka dzɛ oshishe. ");
INSERT INTO utr_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Dafi Otsɔngwɛ dzɛ yi oshishe abuon nɛ, li ngha ngwi o nu Ongwɛ kpaa dzɛ yi oshishe abuon aali. ");
INSERT INTO utr_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Nghanɛ o di nun mfye ogbiikwɔ ikyekyɛ o li Ongwɛ Inggisɛ. ");
INSERT INTO utr_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","<<No ka kwulu ema ewo mi ungwɔnɛ ba, ikyena onɔ kyɛma ngwi ama nlato endzi duu ka fwo ela mgban ");
INSERT INTO utr_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","di tasɛ mi endzi. Ama nkyɔ osuse ka kyato dzɛ oshishe, ama nkyɔ obube ka kyato kaka odzili-dzili. ");
INSERT INTO utr_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Ani abuen ka yagba kyɔ unkonyi ba; ani li gbiikwɔ dafi ani fwo ma kyoon, ma ikwɔ mgbi ani li otsitsi, ikyesinɛ ani mina okyungwɔ ongwi itukwu ani ba, kpaa itukwu mgbi ongwu ndɔ ani esɔ mani. ");
INSERT INTO utr_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","<<Ni ani kyɔ obwɛndɛ mi odzɛ mgbi ani abuani yɔ, obwɛndɛ na wuuta ba. ");
INSERT INTO utr_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Inggisɛ oka dzɛma nli kyɔ obwɛndɛ mi odzɛ mgbi ani, ma ani ye obwɛndɛ mgban li otsitsi. ");
INSERT INTO utr_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","<<Abu dɛsɔ kɛ mbi iJɔn, o di kyɔ obwɛndɛ mi ikye otsitsi. ");
INSERT INTO utr_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Li ogbɛɛ Ani mina obwɛndɛ mgbi inggisɛ owamyɛ ba; kpaa Ani gbɔ ntonɛ ikyegbɛɛ ni ema watɔ. ");
INSERT INTO utr_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","IJɔn nose dzɛ dafi ipitila nle gbɛ dile gbosa mani, ema dzɛ yi atsa mi ongwonɔ gwee ikye ogbɛ osa mgban. ");
INSERT INTO utr_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","<<Ani dzɛ yi obwɛndɛ nsundo ngha mgbi iJɔn nani. Mi ikye idɔ ngwi Otsani kye nu ani gbɛɛ ni ani ngyɛlu nɛni, ngwi ani le kyɔ nɛ, i tso obwɛndɛ gbɛɛ Otsani dɔ ani esɔ. ");
INSERT INTO utr_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Otsani ndɔ ani esɔ abuon teyi kyɔ obwɛndɛ mi odzɛ mgbi ani. Ema fwo ela mgban hona di odzɛɛdzɛ mgban ye ba, ");
INSERT INTO utr_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","elodzɛ mgban kpaa wodzɛ mbi ema ba, ikyena ema nu ongwu o dɔn esɔ nɛ oyɛyɛ ba. ");
INSERT INTO utr_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Ema kpayi elodzɛ Imgbasho nɛ saan ikyekyɛ ema tsɛwɛ gbɛɛ li mi ele ngwi ema tu oshishe gyegwu. Ma li elodzɛ Imgbasho ntonɛ kyɔ obwɛndɛ mi ikye odzɛ mgbi ani, ");
INSERT INTO utr_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","nghaduu ema fwa oba mbi ani wa tu oshishe. ");
INSERT INTO utr_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","<<Ani mina mmwɛ mgbi inggisɛ owamyɛ ba, ");
INSERT INTO utr_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","kpaa ani ye ema. Ani ye dafi ema dzɛ yi okpitukwu mgbi Imgbasho mi itukwu mgbi ema ba mani. ");
INSERT INTO utr_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Ani ba mi iyi mgbi Otsani, nghaduu ema gbɛ ani ba; kpaa ni inggisɛ oka ba mi iyi mgbi ewon yɔ, ema ka gban. ");
INSERT INTO utr_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Ema ka noyɛyɛ sinɛ, ngwi ema le mina mmwɛ mbi ewema, kpaa le pita mmwɛ nkyɛ mbi Imgbasho yuon ta ba? ");
INSERT INTO utr_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","<<Nghaduu ka tsɛwɛ gbɛɛ li Ani ka gbe odzɛ wo ema ewo mbi Otsani ba. Li iMose ngwu ema kye itukwu mgbi ema byi mbon na ka gbe odzɛ wo ema ewo aali. ");
INSERT INTO utr_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Ni ema ki nu iMose oyɛyɛ yɔ, ema kika nu ani kpaa oyɛyɛ, ikyesinɛ o lɔ ungwɔ mi odzɛ mgbi ani. ");
INSERT INTO utr_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Kpaa ngwi ema noyɛyɛ mi ungwɔ ngwi o lɔ ba nɛ, ema ka noyɛyɛ mi odzɛ ngwi ani gbɔ sinɛ?>> ");
INSERT INTO utr_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Ngwi ungwɔnɛ wa nyɛ nɛ, iYesu fooye lu byulu mi agya Ekyoo Okwukwo mgbi iGalalia (ngwi a di li kwun di ekyoo iTiberia kpaa nani), ");
INSERT INTO utr_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","nɛ ibyi inggisɛ kpakpa kyɛdɔn ikyekyɛ a di ambɛ okwulewo ngwi o kyɔ mbi emi ootse mani. ");
INSERT INTO utr_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Man iYesu tɔ lu unggwɔ ka sisɛ yi emi ongwafɔɔn. ");
INSERT INTO utr_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Oga owɛ owatɔ-watɔ mgbi emi iJuda dzɛ kwɛkwɛ mi onɔ mani. ");
INSERT INTO utr_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Ngwi iYesu kyile inɛ esho di ibyi inggisɛ kpakpa kyɛ le ba mbi ongwu nɛ, o si byi iFyilipi gbɛɛ, <<Li mi ole ngwi eyi ka gya ibredi nu inggisɛ ntonɛ gye?>> ");
INSERT INTO utr_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","IYesu byita nɛ ikye ombadun ta, ikyesinɛ o teyi ye mi itukwu mgban ungwɔ ngwi ongwu ka kyɔ. ");
INSERT INTO utr_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","IFyilipi nun uka gbɛɛ, <<Udza okpa idɔ mgbi ofyia egyata kpaa ka mɛ ogya ibredi nu ma tsan aba kpatsɛ ba!>> ");
INSERT INTO utr_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Ongwafɔ mgbi iYesu oka, Andru, ongwunɔ iSaimɔn iPyita si gbɛɛ, ");
INSERT INTO utr_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","<<Ongwongyulɔ dzɛ mmɛnɛni ngwu dzɛ yi ibredi ngwi a kyɔ mi ibale nghi eda bɛyi ongwɛ abatsa efa, ntonɛ ka to ole mbi ibyi inggisɛ ntonɛ?>> ");
INSERT INTO utr_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","IYesu si gbɛɛ, <<Ni inggisɛ ntonɛ sisɛ.>> Oshɛ kyinda mi imbe na kpakpa man inggisɛ ntona sisɛ mi ele, engyulɔ mɛ dafi idubu eda sini. ");
INSERT INTO utr_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","IYesu si kyelu ibredi kye angba nu Imgbasho man kye nu engwafɔ mgban nu ma kye gha inggisɛ ntonani, o di kyɔ ngha yi mmbweni yɛyɛ, ama duu gye dafi a mina mani. ");
INSERT INTO utr_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Ngwi inggisɛ duu tu gye gyɔlo ma nɛ, o si nya engwafɔɔn gbɛɛ, <<Kyi salu ambulu nsisi ma kwakye mbonyi ni unkonyi ka nyanya ba na.>> ");
INSERT INTO utr_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","A si kye salu ambulu ibredi ibale nghi eda ngwi a gye sisi ma mbwo uya nghi iwyodefa. ");
INSERT INTO utr_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Dafi inggisɛ ntona di ambɛ okwulewo ngwi iYesu kyɔ nɛ, a gbɛɛ, <<Mi otsitsi yɔ, nɛnɛ li oyegbɔ nwogyɔ gbɛɛ o ka ba ɛsɛ mani.>> ");
INSERT INTO utr_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Ngwi iYesu di gbɛɛ, a wewo ogye ongwu utɔ mi abumfye nɛ, o wulɛ lu unggwɔ ka dzɛ yuon. ");
INSERT INTO utr_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Mi onɔdɛ nani, engwafɔɔn kɛ utɔ, ");
INSERT INTO utr_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","a kaka uwaa le fooye lu iKapenahun dafi imbe yifu wa, kpaa iYesu ba wa tu ma waba. ");
INSERT INTO utr_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Awo wa le fa fyumfye, dile gbe akpeni. ");
INSERT INTO utr_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Dafi a fa uwaa kɛ mɛ imai eta naadi eta dɔ itsitsi nɛ, a di iYesu kyikyɛ mi ikye eni le ba kwɛkwɛ yi ama, ta imio wo ma. ");
INSERT INTO utr_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Nghaduu o nya ma gbɛɛ, <<Li Ani, ka mio ba na.>> ");
INSERT INTO utr_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Nɛ a mina okyon kaka uwaa, ntunto nɛta uwaa to ondu esɛ mi imbe ngwi a le kɛ mani. ");
INSERT INTO utr_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Tegblifan ibyi inggisɛ ama nto oye utɔ agya oka nɛ difwi gbɛɛ li uwaa onyi ta bɛdzɛ mmana edɛdɛ ma iYesu edɛdɛ kaka yi engwafɔɔn ba, a lu yuoma. ");
INSERT INTO utr_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Nɛ uwaa angbeka kyɛ iTiberia wa bɛsɛ kwɛkwɛ yi imbe ngwi inggisɛ ntona gye ibredi mi onɔ ngwi Otsɛ iYesu nose kye angba nu Imgbasho nani. ");
INSERT INTO utr_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Ngwi ibyi inggisɛ ntona di gbɛɛ, iYesu naadi engwafɔ mgban to mmana wuba nɛ, a kaka uwaa ntona lu oyombo iKapenahun oka pitan. ");
INSERT INTO utr_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Ngwi a tun mi oyombo utɔ nɛ, a byun gbɛɛ, <<Otsetse, li alonɔ ngwi abu to mmɛnɛ?>> ");
INSERT INTO utr_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","IYesu nu ma uka gbɛɛ, <<N nya ema otsitsi, ema le pita ani ikyegbɛɛ di ema di ambɛ okwulewo ba, kpaa li ikyegbɛɛ ema gye ungwogye kpakpa tolo. ");
INSERT INTO utr_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Ka kyidɔ mi ikye ungwogye nli mbe ba, kpaa mi ikye ungwogye nka dzɛ ba oshishe igyegwu ngwi Ongwɛ Inggisɛ ka kye nu ema mani, ikyesinɛ Imgbasho Otsɔn teyi kye ambɛ mgbi ogbela ungwɔ nun.>> ");
INSERT INTO utr_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Nɛ a byi iYesu gbɛɛ, <<Li alungwɔ ngwi eyi ka kyɔ kyɛmɛ ikye okyidɔ ama ngwi Imgbasho mina?>> ");
INSERT INTO utr_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","IYesu si nu uka gbɛɛ, <<Idɔ mgbi Imgbasho ma li ongwu aani: li onoyɛyɛ mbi ongwu Imgbasho dɔn esɔ nɛni.>> ");
INSERT INTO utr_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Nghanɛ a byun gbɛɛ, <<Li ali ambɛ okwulewo ngwi abu ka kyɔ ikye ni eyi diyɛ nu abu oyɛyɛ? Li alungwɔ ngwi abu ka kyɔ? ");
INSERT INTO utr_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Emi otsikyeyi nose gye imana nkyɛ esho kyɛ, mi okwɛsɛ dafi ngwi a tsekise lɔ gbɛɛ: <O kye ungwogye kyɛ esho nu ma gye mani.> >> ");
INSERT INTO utr_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","IYesu nya ma gbɛɛ, <<N nya ema otsitsi, li iMose kye ungwogye nkyɛ esho na nu ema ba, kpaa li Otsani kye ungwogye otsitsi nkyɛ esho na nu ema. ");
INSERT INTO utr_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Ikyekyɛ ungwogye mgbi Imgbasho li ongwu nkyɛ esho ba esɛ wa kye oshishe nu ɛsɛ nɛni.>> ");
INSERT INTO utr_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","A gbɛɛ, <<Ongyukwo, le nu eyi ungwogye na alegbe-alegbe.>> ");
INSERT INTO utr_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Nɛ iYesu nya ma gbɛɛ, <<Li ani li ungwogye mgbi oshishe, inggisɛ nba mbi ani yɔ enbwa ka dɔn wuba, inggisɛ ndi nu ani oyɛyɛ yɔ ekweni ka kwun wuba. ");
INSERT INTO utr_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Kpaa dafi Ani nya ema ma, ema di ani wa, nghaduu ema noyɛyɛ ba. ");
INSERT INTO utr_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Ama ngwu Otsani kye ma nu ani duu a ka ba mbi ani, ali inggisɛ ndi ba mbi Ani duu n ka lɔn onya ba. ");
INSERT INTO utr_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Ikyena Ani kyɛ esho ba esɛ owa kyɔ owitukwu mgbi ani ba, kpaa okyɔ owitukwu mgbi ongwu ndɔ ani esɔ mani. ");
INSERT INTO utr_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Ma nɛnɛ li owitukwu mgbi ongwu ndɔ ani esɔ ma aani: gbɛɛ ama ngwu ongwu gbe nu ani duu onyi kpaa no ka byulu mi ele ba, kpaa ni Ani kyile ma esho mi egbe ongwi olɛlɛ. ");
INSERT INTO utr_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Lubana owitukwu mgbi Otsani li ogbɛɛ, ali inggisɛ ndi Ongwɛ di nun oyɛyɛ ka tu oshishe gyegwu, Ani dika kyilen mi ikwu mi egbe ongwi olɛlɛ mani.>> ");
INSERT INTO utr_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Mi ungwɔnɛ emi iJuda wita ondandu mi ikye odzɛ mgbi iYesu ikyekyɛ o gbɛɛ, <<Ani li ungwogye nkyɛ esho ba esɛ.>> ");
INSERT INTO utr_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","A gbɛɛ, <<Nɛnɛ li iYesu lo, ongwɛ iJose, ongwu eyi ye otsɔn yi onɔn nɛ baa? Kyɔsinɛ ngwi o ka gbɔ onɛnɛ gbɛɛ, Ani kyɛ esho ba esɛ?>> ");
INSERT INTO utr_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","IYesu nya ma gbɛɛ, <<Nya ondandu yi ewema na.>> ");
INSERT INTO utr_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","<<Inggisɛ onyi kpaa ka ba mbi ani ba se Otsani ndɔ ani esɔ ma kwon ba mbi ani, ani dika kyilen mi ikwu mi egbe ongwi olɛlɛ mani. ");
INSERT INTO utr_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","A teyi lɔ mi afɛ mgbi ama ogbɛɛsɛ gbɛɛ: <Imgbasho ka tso ma tsatsa.> Ali inggisɛ ngaadɔ mbi Otsani di kpayi mbon yɔ ka ba mbi ani. ");
INSERT INTO utr_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Inggisɛ onyi kpaa di Otsani ye ba, li ongwu nkyɛ mbi Imgbasho nɛ ta, li ongwu yuon di Otsɔn aali. ");
INSERT INTO utr_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","N nya ema otsitsi, inggisɛ nnoyɛyɛ dzɛ yi oshishe gyegwu. ");
INSERT INTO utr_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Ani li ungwogye mgbi oshishe. ");
INSERT INTO utr_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Emi otsikyema gye imana mi imbe okplagada ungwogye nkye esho ba esɛ nani, nghaduu kpaa a kwulu. ");
INSERT INTO utr_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Kpaa ungwogye nkyɛ esho ba esɛ dzɛ mmɛnɛni, ngwi inggisɛ ka gye di kwulu wuba. ");
INSERT INTO utr_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Ani li ungwogye mgbi oshishe nkyɛ esho ba esɛ. Inggisɛ ta ngye ungwogye nɛ o ka dzɛ oshishe gyegwu, ungwogye nɛ li ikpewo mgbi ani ongwu ani ka kye nu mi ikye oshishe mgbi ɛsɛ.>> ");
INSERT INTO utr_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Nɛ emi iJuda ntona wita otangwɛ yi ewoma mi itɔdzɛ ngwi iYesu gbɔ nani, gbɛɛ, <<Kyɔsinɛ ngwi inggisɛ nɛ ka kye ikpewo mgban nu eyi gye?>> ");
INSERT INTO utr_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","IYesu nya ma gbɛɛ, <<N nya ema otsitsi se ni ema gye ikpewo mgbi Ongwɛ Inggisɛ di wa eyi mgban bayɔ, ema dzɛ yi oshishe mbi ema ba. ");
INSERT INTO utr_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Ali inggisɛ ngye ikpewo mgbi ani diyɛ wa eyi mgbi ani dzɛ yi oshishe igyegwu, ani dika kyilen mi ikwu mi egbe ongwi olɛlɛ. ");
INSERT INTO utr_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Ikyesinɛ, ikpewo mgbi ani li ungwogye otsitsi, eyi mgbi ani di li ungwɔ owawa otsitsi. ");
INSERT INTO utr_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Inggisɛ ta ngye ikpewo mgbi ani di wa eyi mgbi ani wodzɛ mbi ani, ani kpaa wodzɛ mbon. ");
INSERT INTO utr_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Yɛyɛ dafi Otsani ndzɛ oshishe dɔ ani esɔ mani, ani di dzɛ oshishe li ikye Otsani nani, nghanɛ inggisɛ ngye di wa mbi ani yɔ, ka dzɛ oshishe ikye ani. ");
INSERT INTO utr_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Nɛnɛ li ungwogye nkyɛ esho ba esɛ mani, emi otsikyema gye imana nghaduu a kwulu, kpaa inggisɛ nbyi ewon enbwa yi ungwogye ngwi ani kye nu nɛ, ka dzɛ oshishe gyegwu.>> ");
INSERT INTO utr_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","IYesu gbɔdzɛ nɛ mi onɔ ngwi o le tsungwɔ mi ozu okwakye mgbi emi iJuda mi iKapenahun mani. ");
INSERT INTO utr_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Ngwi a fwo odzɛ nɛ nghanɛ, engwafɔ mgbi iYesu kwuba gbɛɛ, <<Otsootso nɛ fyumfye, li emɛ ka gbelan?>> ");
INSERT INTO utr_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","IYesu ye dafi engwafɔɔn tole ndandu mi odzɛ nɛni, o si byi ma gbɛɛ, <<Odzɛ nɛ nu ema ka dzani taa? ");
INSERT INTO utr_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Kini ema di Ongwɛ Inggisɛ yɛ lu esho mi imbe ngwi o teyi dzɛ ma ema ka gbɔsinɛ? ");
INSERT INTO utr_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Onodzi mgbi Imgbasho li nu oshishe; mfye mgbi inggisɛ owamyɛ dzɛ yi oyabɔ ba duudu. Elodzɛ ngwi ani gbɔ nya ema ntonɛ li onodzi, a di li oshishe kpaa. ");
INSERT INTO utr_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Nghaduu ema angbeka to ma ngwu noyɛyɛ ba.>> Ikyesinɛ iYesu teyi ye mi owita-wita ama ngwu noyɛyɛ ba mi idzidzɛ ema, yi ongwu nka wa kyen gya mani. ");
INSERT INTO utr_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","O kiyayi gbɛɛ, <<Li ungwɔ ngwi ani nya ema gbɛɛ inggisɛ onyi kpaa ka ba mbi ani ba se Otsani nun ofɛ ma aani.>> ");
INSERT INTO utr_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Wita mi onɔ na emi ongwafɔɔn kwuba kyata iyikpa di kyɛdɔn wuba. ");
INSERT INTO utr_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Nghanɛ iYesu byi engwafɔ mgban iwyodefa ntona gbɛɛ, <<Ema kpaa i mina ema odzata anii?>> ");
INSERT INTO utr_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","ISaimɔn iPyita nu uka gbɛɛ, <<Otsɛ li mbi emɛ eyi ka kɛ? Abu dzɛ yi elodzɛ mgbi oshishe ogyegwu. ");
INSERT INTO utr_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Eyi noyɛyɛ di ye gbɛɛ abu li iKrestu, ongwɛ Imgbasho oshishe.>> ");
INSERT INTO utr_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Nɛ iYesu gbɛɛ, <<Ani sadu ema nghi iwyodefa baa? Nghaduu onyi mbi ema li olodu!>> ");
INSERT INTO utr_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","(O gbɔdzɛ mgbi iJuda ongwɛ Iskarɔti, ikyesinɛ ngwi o li onyi mbi engwafɔɔn nɛ kpaa, o ka wa kye ongwu gya.) ");
INSERT INTO utr_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Ngwi ungwɔnɛ wa nyɛ nɛ, iYesu kaka iJudia ba kpaa lu le kyikyɛ mi iGalalia, ikyekyɛ ama ogbe emi iJuda teyi le pita ofɛ okyelun oshishe. ");
INSERT INTO utr_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Nghaduu ngwi oga iTabenako mgbi emi iJuda wa dzɛ kwɛkwɛ nɛ, ");
INSERT INTO utr_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","emi ongwunɔ iYesu nyan gbɛɛ, <<I wogyɔ ngwi abu ka dzata imbe nɛ lu iJudia adzi ni emi ongwafɔ abu nu ma di ungwɔ ama okwulewo ngwi abu li kyɔ ntonɛni. ");
INSERT INTO utr_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Inggisɛ nmina gbɛɛ ni inggisɛ yon, li kyungwɔ mi odaada ba. Ngwi abu le kyungwɔ ntonɛ wa nɛ, kye ewabu tso ni ɛsɛ di.>> ");
INSERT INTO utr_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Lubana emi ongwunɔn kpaa nun oyɛyɛ ba. ");
INSERT INTO utr_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Ikyenghanɛ iYesu nya ma gbɛɛ, <<Onɔ mgbi ani yɛyɛ ma gyɔ waba; mbi ema yɔ alonɔ duu le yɛyɛ. ");
INSERT INTO utr_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Ɛsɛ ka di ema tanyi ba, kpaa ani yɔ i din tanyi, ikyekyɛ ani kyɔ obwɛndɛ gbɛɛ ungwɔ ngwi o le kyɔ li ibwubwe. ");
INSERT INTO utr_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Ema kɛ oga na. Ani le kɛ oga nɛ waba ikyekyɛ onɔ mgbi ani yɛyɛ ma gyɔ waba.>> ");
INSERT INTO utr_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Ngwi iYesu gbɔdzɛ nɛ nɛ, o tila dzɛ iGalalia. ");
INSERT INTO utr_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Nghaduukpaa, ngwi emi ongwunɔn lu oga nɛman, ongwu kpaa wa kɛ. O kɛ mi ododa ba, kpaa mi odaada. ");
INSERT INTO utr_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Mi oga na ma, emi iJuda tole ndinan dile byita gbɛɛ, <<O kɔ?>> ");
INSERT INTO utr_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Ibyi inggisɛ ntona tole ndandu kpatsɛ mi ikye mgbi iYesu, angbeka gbɛɛ, <<O li inggisɛ osuse.>> Angbeka nu uka gbɛɛ, <<Ei o le kpagya inggisɛ wo.>> ");
INSERT INTO utr_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Nghaduu inggisɛ gbɔdzɛ mgban mi ododa ba ikyekyɛ a le mio emi iJuda. ");
INSERT INTO utr_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Onɔ ngwi oga to idzidzɛ ma se, iYesu wa kɛ ozu okwukwo osunu Imgbasho mi iJerosalin ka wita ungwɔ otsootso. ");
INSERT INTO utr_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","I kwulu emi iJuda ntona ewo man a byita gbɛɛ, <<Kyɔsinɛ ngwi inggisɛ nɛ ye ungwɔ kpakpa, ma ngwi inggisɛ onyi kpaa tson ba?>> ");
INSERT INTO utr_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","IYesu nu uka gbɛɛ, <<Otsootso nɛ li mgbi ani ba. Kyɛ mbi Ongwu ndɔ ani esɔ mani. ");
INSERT INTO utr_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Ali inggisɛ ngwu i minan okyɔ itukwu mgbi Imgbasho ka fya oye kana otsootso nɛ kyɛ mbi Imgbasho naadi li mgbi ikyibani. ");
INSERT INTO utr_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Inggisɛ nli gbɔdzɛ mgbi ibɔn li kyɔ ngha ikye otu mmwɛ mgbi ewon, kpaa inggisɛ nkyidɔ mi ikye mmwɛ mgbi ongwu ndɔn esɔ ma yɔ li inggisɛ oyɛyɛ; atsika onyi dzɛ mi odzɛ mgban ba. ");
INSERT INTO utr_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","IMose nose kye ola nu ema baa? Nghaduu inggisɛ mgbi ema onyonyi kpaa kyɔ mi ele ba. Kyɔnɛ ngwi ema le fya ongwɔ ani?>> ");
INSERT INTO utr_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Inggisɛ ntona gbɛɛ, <<Esɛ dɔ abu ikye. Li emɛ le fya ongwɔ abu?>> ");
INSERT INTO utr_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","IYesu nya ma gbɛɛ, <<Ani kyungwɔ okwulewo onyi kpata, man i kwulu ema duu ewo. ");
INSERT INTO utr_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Nghaduu, iMose nu ema ola okyiikyɛ (kpaa li mbi iMose ngwi ola na tɔ ba, li mbi emi otsikyema), ema li kyɛ ongwɛ ikyɛ mi egbe otonyewo. ");
INSERT INTO utr_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Kini a ka kyɛ ongwɛ ikyɛ mi egbe otonyewo ikye ofoola mgbi iMose ba waali, kyɔsinɛ ngwi ema le kyitingga yi ani gbɛɛ di ani ngyɛlu inggisɛ olɔlɔ ootse mi egbe otonyewo? ");
INSERT INTO utr_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Ka gbiikwɔ mi ungwɔ ngwi ema di ma kyoon ba, gbiikwɔ mi ungwɔ nli emyɛmyɛ mani.>> ");
INSERT INTO utr_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Mi onɔ na ma inggisɛ angbeka mi iJerosalin wita obyi ewoma gbɛɛ, <<Nɛnɛ li ongyulɔ ngwu a le fya ongwɔn ma lo? ");
INSERT INTO utr_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","O dzɛ mmɛnɛ, le gbɔdzɛ mi ododa ma a le kwondu won ba, ama ogbe eyi teyi difwi gbɛɛ o li iKrestu ma waa? ");
INSERT INTO utr_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Kpaa eyi ye imbe ngwi inggisɛ nɛ tɔkyɛ; onɔ ngwi iKrestu ma wa ba yɔ, inggisɛ onyi ka ye imbe ngwi o tɔkyɛ ba.>> ");
INSERT INTO utr_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Ta ngwi iYesu kale tso mi ozu okwukwo osunu Imgbasho nɛ, o gbɔ mi ela okwukwo gbɛɛ, <<Ɛɛn, ema ye ani, ema di ye imbe ngwi ani kyɛ mani. Ani dzɛ mmɛnɛ ikyibani ba, ongwu ndɔ ani esɔ ma li otsitsi. Ema yon ba, ");
INSERT INTO utr_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","nghaduu ani yon ikyekyɛ ani kyɛ mbon o di dɔ ani esɔ.>> ");
INSERT INTO utr_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Nɛ a fya obwan, kpaa inggisɛ onyi yagba okye abɔ gbon ba ikyekyɛ onɔ mgban gyɔ waba. ");
INSERT INTO utr_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Inggisɛ kwuba mi ifu ibyi kye oyɛyɛ onuunu mgbi ama byi mbon kpɔɔ. A gbɛɛ, <<Ni iKrestu ma wa ba yɔ, o ka kyɔ ambɛ ama nghao kwulewo ngha inggisɛ nɛɛ?>> ");
INSERT INTO utr_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Dafi emi iFarasi fwo ibyi inggisɛ tole ndandu mi ungwɔ ntonɛ mi ikpewo iYesu nɛ, engyukwo ama ofifɛ bɛyi emi iFarasi dɔ ama ongyo ozu okwukwo osunu Imgbasho mi iJerosalin gbɛɛ nu ma ka bwa iYesu. ");
INSERT INTO utr_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","IYesu gbɛɛ, <<Ani ka dzɛ yi ema ongwonɔ gwee ta, man N ka yɛ lu mbi Ongwu ndɔ ani esɔ mani. ");
INSERT INTO utr_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Ema ka pita ani, kpaa ema ka tu ani ba; imbe ngwi ani dzɛ kpaa ema ka kɛ gbɛ ba.>> ");
INSERT INTO utr_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Emi iJuda ntona gbɔ yi ewoma gbɛɛ, <<Li mi ole ngwi inggisɛ nɛ weka olu ngwi eyi ka din ba? O ka lu imbe ngwi emideyi ganya to mi idzidzɛ emi iGriki ma, dika tso emi iGrikii? ");
INSERT INTO utr_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Oweka mgban sinɛ ngwi o gbɛɛ, <Ema ka pita ani, kpaa ema ka tu ani ba, ma imbe ngwi ani dzɛ ema dika ba gbɛ ba>?>> ");
INSERT INTO utr_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Mi egbe ongwi olɛlɛ bɛyi egbe ingblimɔ mi oga na ma iYesu dzɛkunto, di gbɔ mi ela okwukwo gbɛɛ, <<Ni ekweni kwu inggisɛ yɔ, non ba wa wa mbi ani. ");
INSERT INTO utr_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Ali inggisɛ nnu ani oyɛyɛ dafi Afɛ gbɔ ma, ifogbe mgbi eni oshishe ka fɛ tɔ mbon.>> ");
INSERT INTO utr_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Mi odzɛ nɛ iYesu kye inɛ byi Onodzi Osaan ngwi ama nnu ongwu oyɛyɛ ka wa gbɛ mani. Nghataa ba onɔ na a kye Onodzi ma nu waba, ikyekyɛ iYesu kaka okwɔkwɔ oshewo mgban ma waba. ");
INSERT INTO utr_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Onɔ ngwi ibyi inggisɛ ntona fwo odzɛ ngwi o gbɔ nɛ angbeka gbɛɛ, <<Otsitsi-otsitsi, inggisɛ nɛ li Oyegbɔ mani.>> ");
INSERT INTO utr_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Angbeka gbɛɛ, <<O li iKrestu mani.>> Angbeka di byita gbɛɛ, <<IKrestu ka tɔ mi iGalalia sinɛ? ");
INSERT INTO utr_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Afɛ gbɛɛ iKrestu ka tɔ mi etɔ mgbi iDevedi mi iBɛtlɛhɛn, ogalu ngwi iDevedi dzɛ bawɛ?>> ");
INSERT INTO utr_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Itɔdzɛ nɛta inggisɛ ntonɛ si gha ikye iYesu. ");
INSERT INTO utr_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Angbeka mina obwan, nghaduu inggisɛ onyi kye abɔ gbon ewo ba. ");
INSERT INTO utr_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Ongyɛɛngyɛ yɔ ama ongyo ozu okwukwo osunu Imgbasho mi iJerosalin yidɔ kɛ mbi engyukwo ama ofifɛ yi emi iFarasi, a byi ama ongyoongyo ntona gbɛɛ, <<Kyɔnɛ ngwi ema kye iYesu ba mmɛnɛ ba?>> ");
INSERT INTO utr_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Ama ongyoongyo ntona nu uka gbɛɛ, <<Inggisɛ onyonyi yama gbɔdzɛ dafi ngwi inggisɛ nɛ gbɔ ye ba.>> ");
INSERT INTO utr_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Emi iFarasi byi ma gbɛɛ, <<Ema tso gbɛɛ, ema kpaa o kpagya ema woo?>> ");
INSERT INTO utr_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","<<Ama ogbe inggisɛ teyi hona emi iFarasi onyi nun oyɛyɛ yee? ");
INSERT INTO utr_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Ei! Kpaa ibyi inggisɛ ama n ye unkonyi mi ola mgbi iMose ba ntonɛ, ikamba dzɛ ikye ma.>> ");
INSERT INTO utr_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","INikodemu, nteyi kɛ mbi iYesu, di li onyi mboma ma byita gbɛɛ, ");
INSERT INTO utr_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","<<Ola mgbi eyi noofɛ gbɛɛ ni eyi fwo mbi inggisɛ ba ta ngwɔn ikwɔɔ?>> ");
INSERT INTO utr_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","A si nun uka gbɛɛ, <<Abu kpaa kyɛ iGalaliaa? Tsɛwɛ mi ele, ta abu ka difwi gbɛɛ oyegbɔ li tɔ mi iGalalia ba.>>  ");
INSERT INTO utr_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Ta ali inggisɛ duu lu udɛ mgban. ");
INSERT INTO utr_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Ta iYesu lu Unggwɔ Olivi. ");
INSERT INTO utr_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Tegblifan mi egbegbe ototu nɛ, o diyɛ lu ozu okwukwo osunu Imgbasho mi iJerosalin nani, inggisɛ duu kwakye kpaklili won, man o si sisɛ otso ma. ");
INSERT INTO utr_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Etsetse mgbi ola mgbi iMose bɛyi emi iFarasi kye ongyaa ngwu a bwan mi amah ba. A non dzɛkunto mi inɛ ibyi ntona ");
INSERT INTO utr_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","si nya iYesu gbɛɛ, <<Otsetse, a bwa ongyaa nɛ le kyɔ amah. ");
INSERT INTO utr_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Mi ola ma iMose nu eyi ofɛ otsɛngwɔ itɔ ongyaa nɛ mi akwutsɛ, ma abu gbɔ dikyɛ?>> ");
INSERT INTO utr_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","A tole byun ita nɛ ikye okyan ukya di tu itɔdzɛ okye abɔ byi ele. Kpaa iYesu klɛsɛ wita olɔ ungwɔ mi esɛ mi ongwufabɔ mgban. ");
INSERT INTO utr_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Dafi a kiyayi obyun ita nɛ, o kyile ikye esho si nya ma gbɛɛ, <<Ni inggisɛ onyi mi idzidzɛ ema kyungwɔ obube ye bayɔ, otsungwɔ no li ababɔ otsan ikwutsɛ.>> ");
INSERT INTO utr_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","O diyɛ klɛsɛ wita olɔ ungwɔ mi esɛ. ");
INSERT INTO utr_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Mi odzɛ nɛ, ama nfwo ma wita olu onyonyi, ama nli engyukwo ma teyi, nghataa wa sisi iYesu yi ongyaa na ka kwuzunto mi imbe nani. ");
INSERT INTO utr_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","IYesu kyile ikye esho byi ongyaa na gbɛɛ, <<Ongyaa, a kɔ? Inggisɛ onyi kpaa sisi onu abu obube wulo?>> ");
INSERT INTO utr_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","O gbɛɛ, <<Onyi kpaa ba, ongyukwo.>> IYesu si gbɛɛ, <<Ngyɛse, ani kpaa nu abu obube ba. Lu kpaa ka kyɔ alobube wuba.>> ");
INSERT INTO utr_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","IYesu di gbɔdzɛ yi inggisɛ ntonɛni, o gbɛɛ, <<Ani li osa mgbi ɛsɛ. Ali inggisɛ nkyɛdɔ ani yɔ o ka yama kyikyɛ mi iifu ba, kpaa o ka dzɛ yi osa mgbi oshishe.>> ");
INSERT INTO utr_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Emi iFarasi si kwun shanyɛ gbɛɛ, <<Abu kwudzɛ mmɛnɛ le kyɔ ewabu obwɛndɛ; obwɛndɛ mgbi abu wuuta ba.>> ");
INSERT INTO utr_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","IYesu si nya ma gbɛɛ, <<Ni Ani kyɔ ewani obwɛndɛ kpaa, obwɛndɛ mgbi Ani wuuta, ikyekyɛ Ani ye imbe ngwi Ani tɔkyɛ bɛyi imbe ngwi Ani le kɛ mani. Nghaduu ema dzɛ yi ozoyeye mi imbe ngwi Ani tɔkyɛ hona le kɛ ba. ");
INSERT INTO utr_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Ema li fwikwɔ mi odzɛɛdzɛ mgbi inggisɛ owamyɛ; kpaa Ani li fwo inggisɛ onyi ikwɔ ba. ");
INSERT INTO utr_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Ma ni ani gbiikwɔ yɔ, ikwɔ ogbɔɔgbɔ mgbi ani ka li ayin, ikyesinɛ ani dzɛ yuen ba. Ani dzɛ yi Otsani, ongwu ndɔ ani esɔ mani. ");
INSERT INTO utr_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Mi ola mgbi ema ma a lɔ gbɛɛ obwɛndɛ mgbi inggisɛ efa li wuuta. ");
INSERT INTO utr_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Ani li ongwu nkyɔ ewani obwɛndɛ; obwɛndɛ mgbi ani oka li Otsani, ongwu ndɔ ani esɔ mani.>> ");
INSERT INTO utr_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","A si byi iYesu gbɛɛ, <<Otsabu kɔ?>> IYesu nu ma uka gbɛɛ, <<Ema ye ani hona Otsani ba. Ema ki ye ani yɔ, i kika ye Otsani kpaa.>> ");
INSERT INTO utr_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","IYesu gbɔdzɛ ntonɛ mi onɔ ngwi o le tsungwɔ mi akangga ozu okwukwo osunu Imgbasho mi iJerosalin kwɛkwɛ yi imbe ngwi a li kye umba wokɛ nani. Nghaduu inggisɛ onyi bwan ba, ikyekyɛ onɔ mgban gyɔ waba. ");
INSERT INTO utr_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Akpe oka nɛ, iYesu di nya ma gbɛɛ, <<Ani le lu, ma ema ka pita ani, i dika kwulu mi alobube mgbi ema. Imbe ngwi ani le lu ma, ema ka yagba kɛ ba.>> ");
INSERT INTO utr_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Odzɛ nɛ nu emi iJuda ntona byita gbɛɛ, <<O ka ngwɔ ewoon? Li ungwɔ ma ngwi o gbɛɛ, <Imbe ngwi ani le lu ma ema ka ba gbɛ ba daa>?>> ");
INSERT INTO utr_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Nghaduu iYesu kiyayi gbɛɛ, <<Ema kyɛ mi esɛ; ani kyɛ mi esho. Ema li emi ɛsɛ nɛni; ani li emi ɛsɛ nɛ ba. ");
INSERT INTO utr_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Ani teyi nya ema gbɛɛ ema ka kwulu mi ali ibwubwe mgbi ema; kini ema noyɛyɛ gbɛɛ ani li ongwu ani gbɛɛ ani dzɛ ma bayɔ, ema ka kwulu otsitsi mi ali ibwubwe mgbi ema.>> ");
INSERT INTO utr_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","A byun gbɛɛ, <<Abu li emɛ?>> IYesu nu uka gbɛɛ, <<Ani li itɔ inggisɛ ngwu ani teyi nya ema gbɛɛ ani dzɛ mani. ");
INSERT INTO utr_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Ani dzɛ yi odzɛ kpakpa ofwo ema ikwɔ mi ele. Kpaa ongwu ndɔ ani esɔ ma li otsitsi, odzɛ ngwi ani fwo mbon ma n li kye nya ɛsɛ.>> ");
INSERT INTO utr_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","A yagba difwi gbɛɛ o le nya ma odzɛ mgbi Otsɔn ba. ");
INSERT INTO utr_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Nghanɛ iYesu nya ma gbɛɛ, <<Onɔ ngwi ema kyile Ongwɛ Inggisɛ desho mata, ema ka ye gbɛɛ Ani li inggisɛ ngwu ani tso gbɛɛ di Ani dzɛ mani. Ani dika kyɔ unkonyi mgbi ikyibani ba kpaa Ani li gbɔ ungwɔ ngwi Otsani tso Ani ma yɛyɛ. ");
INSERT INTO utr_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Ongwu ndɔ ani esɔ ma dzɛ yi ani; o dzata ani yuen ba, ikyesinɛ Ani li kyungwɔ nli kpan alonɔ duu.>> ");
INSERT INTO utr_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Ngwi o gbɔ elodzɛ ntonɛnɛ, inggisɛ kwuba nun oyɛyɛ. ");
INSERT INTO utr_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Mbi emi iJuda ama nnun oyɛyɛ ma, iYesu gbɛɛ, <<Ni ema kwudzɛ mi otsootso mgbi ani yɔ, ema li ama okyɛdɔ ani yɛyɛ. ");
INSERT INTO utr_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Ema ka ye otsitsi, ta otsitsi ka shɛ ema adi ta.>> ");
INSERT INTO utr_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","A nun uka gbɛɛ, <<Eyi li etɔ mgbi Abrahan, eyi li ofyɛɛ mgbi inggisɛ onyi ye ba. Kyɔsinɛ ngwi abu dika gbɛɛ a ka shɛ eyi adi ta?>> ");
INSERT INTO utr_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","IYesu gbɛɛ, <<N nya ema otsitsi, inggisɛ nle kyɔ alobube tayɔ li ofyɛɛ mgbi alobube. ");
INSERT INTO utr_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Ofyɛɛ dzɛ yi imbe igyegwu mi etɔ ba, kpaa ongwɛ li mgbi etɔ gyegwu. ");
INSERT INTO utr_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Nghanɛ ni ongwɛ shɛ ema adi ta yɔ, ema ka shɛta otsitsi. ");
INSERT INTO utr_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Ani ye ema li etɔ mgbi Abrahan. Nghaduu ema wewo ongwɔ ani, ikyekyɛ elodzɛ mgbi ani wodzɛ itukwu mbi ema ba. ");
INSERT INTO utr_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Ani le nya ema ungwɔ ngwi ani di mi inai Otsani, ema di li kyungwɔ ngwi ema fwo mbi otsema mani.>> ");
INSERT INTO utr_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","A nyan gbɛɛ, <<Abrahan li otseyi.>> IYesu gbɛɛ, <<Ni ema ki li emi ongwɛ Abrahan yɔ, ema kile kyungwɔ ngwi Abrahan kyɔ mani. ");
INSERT INTO utr_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Ngwi i dzɛ nɛ, ema weka ongwɔ ani, ikyegbɛɛ ani nya ema otsitsi ngwi ani fwo mbi Imgbasho mani. Abrahan kyɔ itɔ ungwɔ ntonɛ ba. ");
INSERT INTO utr_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Ema le kyungwɔ ama ngwi otsema teyi kyɔn mani.>> A gbɛɛ, <<Eyi li ofyɛɛ ba. Otsɔ ngwi eyi dzɛyan li Imgbasho abuon.>> ");
INSERT INTO utr_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","IYesu nya ma gbɛɛ, <<Ni Imgbasho ki li Otsema yɔ, ani kika kpema itukwu, ikyesinɛ ani kyɛ mbi Imgbasho badzɛ mmɛnɛ onɛnɛ aani. Ani ba mgbi ikyibani ba; kpaa li ongwu dɔ ani esɔ. ");
INSERT INTO utr_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Kyɔsinɛ ngwi ema le difwi odzɛ ngwi ani le gbɔ ba? Li ikyegbɛɛ ema le gbela odzɛ ngwi ani le gbɔ ba mani. ");
INSERT INTO utr_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Ema li mgbi otsema, Olodu, di mina ema okyɔ oweka mgbi otsema. O li inggisɛ ogbɔngwɔ inggisɛ mi owita-wita ma jo, o kwudzɛ mi otsitsi ba, bana otsitsi dzɛ mbon ma ba. Mi onɔ ngwi o mwonya ma, o li gbɔdzɛ mi odzɛɛdzɛ mgban, bana o li inggisɛ omwonya di li otsɛ mgbi onya omwaamwa. ");
INSERT INTO utr_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Nghaduu ikyegbɛɛ ani nya ema otsitsi nɛ, ema nu ani oyɛyɛ ba! ");
INSERT INTO utr_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Inggisɛ mgbi ema onyi ka yagba tso abɔ mi obube mgbi ani wɛ? Ni ani le nya ema otsitsi ma, i kyɔsinɛ ngwi ema nu ani oyɛyɛ ba? ");
INSERT INTO utr_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Ongwu nli mgbi Imgbasho li fwon. Itɔdzɛ ngwi ema li fwo ba ma li ikyegbɛɛ ema li mgbi Imgbasho ba.>> ");
INSERT INTO utr_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","A byi iYesu gbɛɛ, <<Eyi gbɔ ayin mi ogbɛɛ abu li inggisɛ iSamaria esɛ di dɔ abu ikye ba naadi?>> ");
INSERT INTO utr_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","IYesu gbɛɛ, <<Esɛ dɔ ani ikye ba, kpaa Ani nu Otsani mmwɛ nghaduu ema nu ani mmwɛ ba. ");
INSERT INTO utr_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Ani le pita okwɔkwɔ mi ikye ewen ba; kpaa inggisɛ dzɛma ngwu pitan, di li ongwu li ongye ogbiikwɔ aali. ");
INSERT INTO utr_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","N nya ema otsitsi, kini inggisɛ ngyo elodzɛ mgbi ani yɔ, o ka di ikwongye inɛ ba.>> ");
INSERT INTO utr_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Mi ikye odzɛ nɛ emi iJuda ntonɛ kwulu ela gbɛɛ, <<Onɛnɛ eyi ye gbɛɛ esɛ dɔ abu ikye otsitsi! Abrahan kwulu, li ngha ngwi ama ogbɛɛsɛ kpaa kwulu aali, nghaduu abu gbɛɛ ni inggisɛ ngyo elodzɛ mgbi abu yɔ, o ka di ikwongye inɛ ba. ");
INSERT INTO utr_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Abu shewo ngha otseyi Abrahan? O kwulu, li ngha ngwi ama ogbɛɛsɛ kpaa kwulu aali. Abu tsɛwɛ di abu li emɛ?>> ");
INSERT INTO utr_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","IYesu nu uka gbɛɛ, <<Ni Ani nu ewani okwɔkwɔ yɔ, okwɔkwɔ mgbi ani na wuuta ba. Otsani, ongwu ema li gbɛɛ o li Imgbasho mgbi ema na, li ongwu nu ani okwɔkwɔ aali. ");
INSERT INTO utr_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Ema yen ba, kpaa Ani yen. Kini Ani gbɛɛ di Ani yen bayɔ, n ka li inggisɛ omwonya dafi ema mani, nghaduu Ani yen di ngyo elodzɛ mgban. ");
INSERT INTO utr_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Otsema Abrahan dzɛ yi atsa mi ɛwɛ otsɛɛtsɛ odi egbe obaaba mgbi ani; o di egbe na diyɛ dzɛ yi atsa.>> ");
INSERT INTO utr_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Emi iJuda ntona nyan gbɛɛ, <<Abu mɛ onova ngwusefa dɔn iwyo kpaa waba, ta abu di Abrahan ye!>> ");
INSERT INTO utr_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","IYesu si gbɛɛ, <<Duuse nu ma mba Abrahan yɔ, ani plɛ dzɛ!>> ");
INSERT INTO utr_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Mi itɔdzɛ nɛ, a sa akwutsɛ gbɛɛ a ka tsan, kpaa iYesu kye ewon da, wulɛ tasɛ dzata ikpɛsɛ mgbi ozu okwukwo osunu Imgbasho mi iJerosalin nani. ");
INSERT INTO utr_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Dafi iYesu kyikyɛ le kɛ nɛta, o di ongyulɔ ongwu nbinɛ kyɛ ifu. ");
INSERT INTO utr_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Engwafɔɔn byun gbɛɛ, <<Otsetse, li emɛ kyɔ obube, inggisɛ nɛ naadi ama omban, ngwi a mban binɛ kyɛ ifu?>> ");
INSERT INTO utr_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Nɛ iYesu gbɛɛ, <<Li inggisɛ nɛ naadi ama omban kyɔ obube ba, kpaa ungwɔnɛ kyɔ ikyegbɛɛ idɔ mgbi Imgbasho no tso ambɛ mi oshishe mgban. ");
INSERT INTO utr_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Dafi onɔ ka desho nɛ, li kyɛmɛ ngwi eyi ka kyidɔ mgbi Ongwu ndɔ ani esɔ nani. Otu kyɛma, ngwi inggisɛ onyi ka kyidɔ wuba. ");
INSERT INTO utr_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Ngwi Ani ka dzɛ ɛsɛ nɛ nɛ, Ani li osa mgbi ɛsɛ.>> ");
INSERT INTO utr_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Ngwi o gbɔdzɛ nɛ ngha nɛ, o kyanggwɔ tokɛsɛ, o bwili ekyɛ mi anggwɔ si kye gyuwo ongyulɔ na inɛ. ");
INSERT INTO utr_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","O nyan gbɛɛ, <<Lu, ka ngwunɛ mi uta mgbi iSilon>> (ita iyi nɛ gbɛɛ deesɔ). Nɛta ongyulɔ na lu ka ngwunɛ, si yɛ luba udɛ le dinɛ. ");
INSERT INTO utr_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Ama nwatse udɛ dɔn bɛyi ama nteyi li din le bibɔ ma byita gbɛɛ, <<Nɛnɛ li ongyulɔ nli teyi sɔ le bibɔ nɛ lo?>> ");
INSERT INTO utr_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Angbeka gbɔgbɛɛ, li ongwu. Angbeka gbɛɛ, <<Ei, o lun luulu ta.>> Nghaduu ongwu abuon le kali-kali gbɛɛ, <<Li ani ma aani.>> ");
INSERT INTO utr_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Nɛ a byita gbɛɛ, <<Kyɔsinɛse inɛ mgbi abu kwulu?>> ");
INSERT INTO utr_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","O nya ma gbɛɛ, <<Ongyulɔ ngwu a kwun di iYesu na bwili ekyɛ kye gyuwo ani inɛ. O nya ani gbɛɛ ni ani lu iSilon ka ngwunɛ. Dafi ani lu ka ngwunɛ nɛtaman, ani si dinɛ.>> ");
INSERT INTO utr_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","A byun gbɛɛ, <<Inggisɛ ma kɔ?>> O gbɛɛ, <<Ani ye ba.>> ");
INSERT INTO utr_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","A kye ongyulɔ nbinɛ na ba mbi emi iFarasi. ");
INSERT INTO utr_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Egbe ngwi iYesu bwili ekyɛ kwulu ongyulɔ na inɛ ma, li egbe otonyewo. ");
INSERT INTO utr_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Nghanɛ emi iFarasi kpaa di byun ita dafi i kyɔ se ngwi inɛ mgban kwulu mani. Inggisɛ na nu uka gbɛɛ, <<O bwili ekyɛ kye gyuwo ani inɛ, ani ka ngwunɛ taman n sile di aani.>> ");
INSERT INTO utr_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Emi iFarasi angbeka gbɛɛ, <<Inggisɛ nɛ kyɛ mbi Imgbasho ba, bana o wɛ egbe otonyewo ba.>> Nghaduu angbeka byita gbɛɛ, <<Kyɔnɛse inggisɛ alobube ka kyɔ ambɛ okwulewo ngha?>> Ikyenghanɛ a si gheefa. ");
INSERT INTO utr_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Mi ongyɛɛngyɛ ma a diyɛ kyata byi inggisɛ obinɛ na gbɛɛ, <<Abu ma, o gbɔsinɛ ikpewon? Li inɛ mgbi abu ngwi o kwulu.>> Inggisɛ na nu uka gbɛɛ, <<O li oyegbɔ.>> ");
INSERT INTO utr_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Emi iJuda noyɛyɛ gbɛɛ di inggisɛ na teyi binɛ se inɛ wa kwulu lon ba, mbise ngwi a dɛsɔ mbi ama omban. ");
INSERT INTO utr_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","A byita gbɛɛ, <<Nɛnɛ li ongwɛ emaa? Li ongwu ema gbɛɛ di a mban binɛ kyɛ ifu ma dɛɛn? Kyɔnɛse ngwi o le di onɛnɛ?>> ");
INSERT INTO utr_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Ama omban nu uka gbɛɛ, <<Eyi ye o li ongwɛ eyi, eyi di ye o binɛ kyɛ ifu. ");
INSERT INTO utr_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Nghaduu eyi ye dafi i kyɔ se o le dinɛ onɛnɛ ba, naadi eyi ye inggisɛ nkwulun inɛ ba. Byun na. O li ongbɛ wuba; o ka gbɔdzɛ ikye ewon.>> ");
INSERT INTO utr_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Ama omban gbɔdzɛ nɛ ikyekyɛ a le mio emi iJuda, bana emi iJuda teyi bwalu ondu gbɛɛ inggisɛ ta nnoyɛyɛ gbɛɛ iYesu li iKrestu yɔ, a ka dulun tɔ mi ozu okwakye mgbi emi iJuda. ");
INSERT INTO utr_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Li ikyengha ngwi ama omban gbɔgbɛɛ, <<O li ongbɛ wuba; byun na aali.>> ");
INSERT INTO utr_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Akpe ongwu fan, a kwu inggisɛ nteyi binɛ kyɛ ifu na ela. A gbɛɛ, <<Kye oshewo nu Imgbasho, eyi ye inggisɛ nɛ li inggisɛ alobube.>> ");
INSERT INTO utr_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","O si nu uka gbɛɛ, <<Kini o li inggisɛ alobube hona o li inggisɛ alobube ba kpaa, ani ye ba. Ungwɔ onyi ngwi ani ye yɔ. Ani teyi binɛ, kpaa onɛnɛ ani le di!>> ");
INSERT INTO utr_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Nghanɛ a byun gbɛɛ, <<O kyɔsinɛ yi abu? O kwulu abu inɛ sinɛ?>> ");
INSERT INTO utr_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","O gbɛɛ, <<Ani teyi nya ema kpaa ema gadɔ ba. Li alungwɔ mina ema odi fwo? Ema mina oyɛɛ engwafɔɔn naadi?>> ");
INSERT INTO utr_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Ta a wulun ito di gbɛɛ, <<Abu li ongwafɔ mgbi inggisɛ nɛni! Eyi yɔ, eyi li engwafɔ mgbi iMose! ");
INSERT INTO utr_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Eyi ye gbɛɛ Imgbasho gbɔdzɛ yi iMose, kpaa inggisɛ nɛ yɔ, eyi yama ye imbe ngwi o tɔkyɛ kpaa ba.>> ");
INSERT INTO utr_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Ongyulɔ na nu uka gbɛɛ, <<Ungwɔnɛ li ungwɔ okwulewo! Dafi ema ye imbe ngwi o tɔkyɛ ba, kpaa o kwulu ani inɛ nɛni. ");
INSERT INTO utr_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Eyi ye dafi Imgbasho li fwo odzɛ mgbi emi ali ibwubwe ba mani. O li fwo odzɛ mgbi inggisɛ oyɛyɛ ongwu nle kyɔ oweka mgban. ");
INSERT INTO utr_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Kyɛ onɔ ngwi a ta ɛsɛ nghataa ba onɛnɛni, inggisɛ onyi kpaa fwo gbɛɛ a kwulu inggisɛ ongwu nbinɛ kyɛ ifu inɛ ye ba. ");
INSERT INTO utr_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Ongyulɔ nɛ ki kyɛ mbi Imgbasho bayɔ, o ki kyɔ unkonyi gbɛ ba.>> ");
INSERT INTO utr_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Mi elodzɛ nɛ a nu uka gbɛɛ, <<A mba abu yi alobube kyɛ ifu; kyɔnɛse ngwi abu le tso eyi!>> Man a tsamun tasɛ. ");
INSERT INTO utr_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","IYesu si fwo dafi a tsamun tasɛ mani, ngwi o wa tun nɛ, o gbɛɛ, <<Abu noyɛyɛ mbi Ongwɛ Inggisɛ joo?>> ");
INSERT INTO utr_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Ongyulɔ na byita gbɛɛ, <<O li emɛ, ongyukwo? Nya ani zukwu ni ani wa nun oyɛyɛ.>> ");
INSERT INTO utr_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","IYesu si gbɛɛ, <<Onɛnɛ abu din; mi otsitsi, li ongwu nle gbɔdzɛ yi abu nɛni.>> ");
INSERT INTO utr_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Ongyulɔ na gbɔgbɛɛ, <<Otsɛ, ani noyɛyɛ,>> man o sunun. ");
INSERT INTO utr_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","IYesu gbɛɛ, <<Ani ba ɛsɛ nɛ ikye ikwɔ ogbɔɔgbɔ, ikyegbɛɛ obinɛ non di, ama ntole di ma nu ma yɛɛ obinɛ.>> ");
INSERT INTO utr_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Emi iFarasi angbeka nto yan ma fwon le gbɔ ngha nɛta, a byun gbɛɛ, <<Ekyɛgbɔɔ? Eyi kpaa binɛɛ?>> ");
INSERT INTO utr_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Nɛ iYesu gbɛɛ, <<Kini ema li obinɛ yɔ, ema ki gye obube mi alobube ba; kpaa onɛnɛ ngwi ema le tso gbɛɛ ema le dinɛ nɛ, alobube mgbi ema ka dzɛ yi ema. ");
INSERT INTO utr_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","<<Mi otsitsi-otsitsi yɔ, n le nya ema, inggisɛ ongwu nkaka mi onufoka mgbi ifatoba mmala ba, kpaa ka tɔ kaka mi ofɛ angbeka yɔ, o li emumyi bɛyi inggisɛ ofofɛ. ");
INSERT INTO utr_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Nghaduu inggisɛ nkaka mi onufɛ li inggisɛ ongyo mmala. ");
INSERT INTO utr_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Inggisɛ ongyoongyo li kwulu onufoka, mmala li fwo ela mgban. O li kwu mmala mgban ela mi iyi, di li gbe ma tasɛ. ");
INSERT INTO utr_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Mi onɔ ngwi o gbe ama nli mgban tsatsa tasɛ ma, o li teyi ofɛ, man mmala mgban di li kyɛdɔn, ikyekyɛ a ye ela mgban. ");
INSERT INTO utr_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Kpaa a ka yama kyɛdɔ ingyoga ba; otsitsi, a ka tsinyan ikyesinɛ a yagba difwi ela mgbi ingyoga ba.>> ");
INSERT INTO utr_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","IYesu gbɔ itaodzɛ nɛni, kpaa ungwɔ ngwi o le nya ma gbosa lo ma ba. ");
INSERT INTO utr_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Nghanɛ iYesu diyɛ gbɔgbɛɛ, <<N le nya ema otsitsi, ani li onufoka mgbi mmala. ");
INSERT INTO utr_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Ama nteyi ani ba duu li emumyi bɛyi ama ofofɛ, nghaduu mmala fwo ma ba. ");
INSERT INTO utr_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Ani li onufɛ; ali inggisɛ nkaka nyɛ mbi ani yɔ, o ka watɔ. O ka kaka tasɛ, di tu ungwogye. ");
INSERT INTO utr_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Emumyi li ba ikye owa yi di ngwɔ diyɛ dzili; ani ba gbɛɛ nu ma tu oshishe, di tuun dzii. ");
INSERT INTO utr_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","<<Ani li inggisɛ ongyo mmala osuse mani. Inggisɛ ongyo mmala osuse li kye oshishe mgban lasɛ ikye mmala mgban. ");
INSERT INTO utr_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Inggisɛ ngwu a kyon idɔ ongyo mmala yɔ, mmala li mgban ba. Nghanɛ onɔ ngwi o di idukwlɛbɛ kyɛ le ba ma, o li dzata mmala ntona tsinya lu. Ta idukwlɛbɛ li ba wa kwu mmala di ganya ma. ");
INSERT INTO utr_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Inggisɛ na tsinya ikyekyɛ o li inggisɛ ngwu a kyen kyeekye idɔ ta unkonyi won yi mmala ntona ba. ");
INSERT INTO utr_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","<<Ani li inggisɛ ongyo ifyungwɔ osuse; ani ye mmala mgbi ani, mmala mgbi ani kpaa ye ani. ");
INSERT INTO utr_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Dafi Otsani ye Ani, Ani kpaa di ye Otsani mani, Ani di kye oshishe mgbi Ani nu mi ikye mmala. ");
INSERT INTO utr_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Ani dzɛ yi mmala angbeka ama nwoto ifatoba yi ama ntonɛ ba. Ama kpaa li kyɛmɛ ngwi ani ka gbe ma ba. Ama kpaa ka fwo ela mgbi ani dika yɛɛ obyi ifyungwɔ onyi yi inggisɛ ongyo ifyungwɔ onyi. ");
INSERT INTO utr_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Itɔdzɛ ngwi Ani kpa Otsani itukwu yɔ, li ikyegbɛɛ Ani kye oshishe mgbi Ani nu, ikye odi yidɔ kyi kyelu. ");
INSERT INTO utr_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Inggisɛ onyi kpaa ka yagba gbɛ Ani oshishe ba, Ani ka kye nu abuani. Ani dzɛ yi mfye okye nu di dzɛ yi mfye okyi kyelu. Ola nɛ Ani gbɛ mbi Otsani.>> ");
INSERT INTO utr_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Mi ikye elodzɛ ntonɛ, emi iJuda di dzɛ yi ogbua-gbua yi ewoma. ");
INSERT INTO utr_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Ama kwuba gbɛɛ, <<Esɛ dɔn ikye o dile wede. Kyɔnɛ ngwi eyi le gadɔ mbon?>> ");
INSERT INTO utr_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Nghaduu angbeka gbɛɛ, <<Elodzɛ ntonɛ li mgbi inggisɛ ngwu esɛ dɔn ikye ba. Emɛsɛ ka yagba kwulu obinɛ inɛ gbɛɛ?>> ");
INSERT INTO utr_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Li onɔ oga owɛ-wɛ mgbi okye ozu okwukwo osunu Imgbasho mi iJerosalin dubɔ Imgbasho. Li mi onɔ ofu, ");
INSERT INTO utr_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","nɛ iYesu le kyikyɛ mi akangga ozu okwukwo osunu Imgbasho mi iJerosalin, mi iwulu onufozu mgbi iSolomu nani. ");
INSERT INTO utr_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Emi iJuda kwakye kpakɛkɛ won, le gbɛɛ, <<Ka kye onɔ sinɛ ngwi abu kale tsili-tsili eyi ngha? Kini abu li iKrestu ma yɔ, nya eyi mi ododa.>> ");
INSERT INTO utr_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","IYesu gbɛɛ, <<Ani nya ema, kpaa ema noyɛyɛ ba. Ungwɔ ama okwulewo ngwi Ani kyɔ mi iyi mgbi Otsani nɛ, gbɔ odzɛɛdzɛ mgbi ani, ");
INSERT INTO utr_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","nghaduu ema noyɛyɛ ba ikyekyɛ ema li mmala mgbi ani ba. ");
INSERT INTO utr_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Mmala mgbi ani li fwo ela mgbi ani; ani ye ma, a di li kyɛdɔ ani. ");
INSERT INTO utr_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Ani nu ma oshishe gyegwu, a dika dzili wuba; inggisɛ onyi kpaa dika lafwa ma mi abɔ mgbi ani ba. ");
INSERT INTO utr_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Otsani, nkye ma dɔ ani ubɔ ma, shewo ngha ali inggisɛ duu; inggisɛ onyi kpaa ka lafwa ma mi abɔ mgbi Otsani ba. ");
INSERT INTO utr_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Ani yi Otsani eyi li onyi.>> ");
INSERT INTO utr_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Emi iJuda di kye akwutsɛ gbɛɛ a ka tsan, ");
INSERT INTO utr_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","nghaduu iYesu gbɛɛ, <<Ani tso ema ungwɔ okwulewo ama nshewo kwuba mbi Otsani. Li ikye ole mi efu ngwi ema ka tsɛ ani akwutsɛ?>> ");
INSERT INTO utr_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Emi iJuda gbɛɛ, <<Eyi le tsɛ abu akwutsɛ mi ikye ungwɔ ntonɛ onyi kpaa ba, li mi ikye ito ofya Imgbasho, ikyesinɛ abu nli inggisɛ owamyɛ nɛ, le tso gbɛɛ abu li Imgbasho.>> ");
INSERT INTO utr_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","IYesu si nya ma gbɛɛ, <<A lɔ mi ola mgbi ema gbɛɛ, <Ani gbɛɛ ema li emi imgbasho baa>? ");
INSERT INTO utr_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Ki non kwu ma di emi imgbasho ma, li mbi ele ngwi elodzɛ Imgbasho ba, ngwi Afɛ ka yagba nyinɛ ba. ");
INSERT INTO utr_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Ongwu Otsɔn dulu-dulu dafi li mgban abuon di kye dɛsɔ ba ɛsɛ nɛ mayɛ? Kyɔsinɛ ngwi ema dulu ongwufabɔ mbi Ani gbɛɛ Ani le fyito ikyekyɛ ani gbɛɛ, <Ani li Ongwɛ Imgbasho>? ");
INSERT INTO utr_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Ni Ani le kyidɔ mgbi Otsani bayɔ, ka nu ani oyɛyɛ ba na. ");
INSERT INTO utr_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Kpaa ni ani le kyɔ yɔ, ni ema nu ani oyɛyɛ ba kpaa, nu idɔ okwulewo ntona oyɛyɛ na, ikye ni ema ye diyɛ difwi dafi Otsani dzɛ mbi ani, ani kpaa di dzɛ mbi Otsani mani.>> ");
INSERT INTO utr_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","A di fya obwan, nghaduu o dzidzɛ tɔ mi abɔ ma lu. ");
INSERT INTO utr_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Ta iYesu yidɔ foyombo iJodan lu imbe ngwi iJɔn teyi le kyɔ iBatisima ababɔ mani. O ka dzɛkɛ ele. ");
INSERT INTO utr_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Inggisɛ di ba mbon kpakpa. A gbɛɛ, <<iJɔn kyɔ ambɛ okwulewo onyi ba, kpaa alungwɔ ngwi iJɔn gbɔ mi ikye ongyulɔ nɛ duu li otsitsi.>> ");
INSERT INTO utr_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Inggisɛ kwuba si nu iYesu oyɛyɛ mi imbe nani. ");
INSERT INTO utr_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Onɛnɛ inggisɛ ngwu a li kwun di iLadzaru dotse. O kyɛ mi iBetani, mi agwɔ mgbi iMeri bɛyi ongwunɔn iMata. ");
INSERT INTO utr_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","IMeri nɛ, li ongwu ongwunɔn iLadzaru onɛnɛ ladzɛ esɛ mi ootse aani, di li ongwu kpɔɔ ka wa kye engyie ogbungbɛ kyi iYesu afɔ di kye fɔlu mi otu mgban. ");
INSERT INTO utr_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Nghanɛ emi ongwunɔn engyaa deesɔ mbi iYesu gbɛɛ, <<Otsɛ, ongwu nkpaabu itukwu na dotse.>> ");
INSERT INTO utr_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Mi onɔ ngwi iYesu fwo ungwɔnɛ mata, o gbɔgbɛɛ, <<Ootse nɛ ka ngyɛ mi ikwongye ba. Ei, li mi ikye okwɔkwɔ mgbi Imgbasho adzi ni Ongwɛ Imgbasho tu okwɔkwɔ mi ele.>> ");
INSERT INTO utr_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","IYesu di iMata yi ongwunɔn ongwu ongyaa bɛyi iLadzaru kpan itukwu. ");
INSERT INTO utr_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Nghaduu, ngwi o fwo gbɛɛ iLadzaru dotse nɛ, o diyɛ dzɛ imbe ngwi o dzɛ na egbe efa kpɔɔ. ");
INSERT INTO utr_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Ta o nya engwafɔɔn gbɛɛ, <<Yidɔ kɛ iJudia na.>> ");
INSERT INTO utr_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","A gbɛɛ, <<Otsetse, li enggeengga ngwi emi iJuda fya otsɛ abu akwutsɛ, nghanɛ abu diyɛ le kɛ imbe naa?>> ");
INSERT INTO utr_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","IYesu gbɛɛ, <<Obyi li iwyodefa mi egbe baa? Inggisɛ nkyikyɛ mi onɔ ka tsiishi ba, ikyekyɛ o li di osa ongwi ɛsɛ nɛni. ");
INSERT INTO utr_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Li mi onɔ ngwi o kyikyɛ mi otu mata ngwi o li tsiishi, ikyekyɛ osa dzɛ ba.>> ");
INSERT INTO utr_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Ngwi o gbɔdzɛ nɛ nyɛ nɛ, o kiyayi onya ma gbɛɛ, <<Okeyi iLadzaru nuna, kpaa n le kɛ ele oka kyilen una.>> ");
INSERT INTO utr_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Engwafɔɔn nu uka gbɛɛ, <<Otsɛ, ki non nuna yɔ, o ka tu iyu.>> ");
INSERT INTO utr_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","IYesu le gbɔdzɛ ikwu mgbi iLadzaru, kpaa engwafɔɔn tsɛwɛ gbɛɛ o le gbɔdzɛ una onana mgbi atta nɛni. ");
INSERT INTO utr_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Nɛta o si nya ma mi ododa gbɛɛ, <<ILadzaru kwulu, ");
INSERT INTO utr_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","ma mi ikye mgbi ema yɔ, ani dzɛ yi atsa dafi ngwi ani dzɛ ele ba mani, ikyegbɛɛ ni ema noyɛyɛ. Nghaduu i kɛ ka din na.>> ");
INSERT INTO utr_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Nɛ iTɔmɔsu (ngwu a li kwun gbɛɛ ongwɛ efa na), nya engwafɔ mgbi iYesu angbeka ntona gbɛɛ, <<Ba ni eyi kpaa kɛ na, adzi ni eyi ka kwulu biyan.>> ");
INSERT INTO utr_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","IYesu ka kaka, dafi a kye iLadzaru ndzi mɛ egbe enɛ wa. ");
INSERT INTO utr_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Okyɛɛ mi iJerosalin ba iBetani sisi gwee omɛ imai efa, ");
INSERT INTO utr_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","emi iJuda kwuba di ba mbi iMata yi iMeri owa gyila ma mi ikwu ongwunɔ ma. ");
INSERT INTO utr_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Ngwi iMata fwo dafi iYesu kyɛ nɛta, o tasɛ oka kpatsan, nghaduu iMeri tila dzɛ udɛ. ");
INSERT INTO utr_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","IMata nya iYesu gbɛɛ, <<Otsɛ, ni abu ki dzɛ mmɛnɛ yɔ, ongwunani ki kwulu ba. ");
INSERT INTO utr_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Nghaduu ani ye gbɛɛ mi onɛnɛ kpaa Imgbasho ka kyɔ abu alungwɔ ngwi abu bɔ duu.>> ");
INSERT INTO utr_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","IYesu si nyan gbɛɛ, <<Ongwunabu ka yɛ kyɛɛ.>> ");
INSERT INTO utr_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","IMata gbɛɛ, <<Ani ye o ka yɛ kyɛɛ mi okyɛɛ-kyɛɛ mi ikwu mi egbe ongwi olɛlɛ mani.>> ");
INSERT INTO utr_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","IYesu gbɛɛ, <<Ani li okyɛɛ-kyɛɛ mi ikwu bɛyi oshishe. Inggisɛ nnu ani oyɛyɛ yɔ, o ka dzɛ oshishe, yeba non kwulu kpaa; ");
INSERT INTO utr_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","ma inggisɛ ta ndzɛ oshishe di nu ani oyɛyɛ ka kwulu ba. Abu noyɛyɛ mi odzɛ nɛ wɛ?>> ");
INSERT INTO utr_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","IMata nyan gbɛɛ, <<Ɛɛn, Otsɛ, ani noyɛyɛ gbɛɛ abu li iMedzaya, Ongwɛ Imgbasho, ongwu nka ba ɛsɛ nɛ mani.>> ");
INSERT INTO utr_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Ngwi o gbɔdzɛ nɛ nyɛ mata, o yidɔ kwu ongwunɔn iMeri ela kɛ enggengga gbɛɛ, <<Otsetse dzɛ mmɛnɛni, o le pita abu.>> ");
INSERT INTO utr_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Ngwi iMeri fwo ungwɔnɛ nɛ, o kyato vla kɛ mbi iYesu. ");
INSERT INTO utr_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Mi onɔ na iYesu kaka ogalu na waba, kpaa o ka dzɛ imbe ngwi iMata ka tun nani. ");
INSERT INTO utr_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Ngwi emi iJuda ama nbato yi iMeri mi udɛ, le gyilan na, di dafi o kyato vla tasɛ nɛta, a si kyɛdɔn, tsɛwɛ gbɛɛ o le lu endzi ka tsukwu mi ele. ");
INSERT INTO utr_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Ngwi iMeri ka to imbe ngwi iYesu dzɛ di din mata, o gbɛsɛ lankɛ iyayi di gbɛɛ, <<Otsɛ, ni abu ki dzɛ mmɛnɛ yɔ, ongwunani ki kwulu ba.>> ");
INSERT INTO utr_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Ngwi iYesu din le tsukwu, yi emi iJuda ama nbato yan ntona kpaa tole tsukwu nɛ, itukwu mu lon mi onodzi i di kakan ewo. ");
INSERT INTO utr_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","O byita gbɛɛ, <<Ema kyon da mi ole?>> A gbɛɛ, <<Ba wa di, Otsɛ.>> ");
INSERT INTO utr_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","IYesu tsukwu. ");
INSERT INTO utr_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Ta emi iJuda gbɔgbɛɛ, <<Di dafi o kpan itukwu maa!>> ");
INSERT INTO utr_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Nghaduu angbeka mi efu gbɛɛ, <<Ongwu nkwulu obinɛ inɛ nɛ kyɔnɛ ngwi o kyi ndɛlu ikwu inggisɛ nɛ wuba?>> ");
INSERT INTO utr_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Dafi itukwu nghao fu-fu lo iYesu nɛ, o kɛ endzi. Li endzi olo ngwi a di kye ikwutsɛ tukwu ondufan. ");
INSERT INTO utr_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","O gbɛɛ, <<Mulu ikwutsɛ nɛni.>> IMata, ongwu ongwunɔn kwulu na gbɛɛ, <<Kpaa, Otsɛ, mi onɛnɛ o ka li odikyi, lubana o la endzi egbe enɛ waani.>> ");
INSERT INTO utr_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Nɛta iYesu gbɛɛ, <<Ani teyi nya abu gbɛɛ kini abu noyɛyɛ yɔ, abu ka di okwɔkwɔ mgbi Imgbasho baa?>> ");
INSERT INTO utr_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Ta a kyi mulu ikwutsɛ nani. Nɛ iYesu kyile inɛ esho, si gbɛɛ, <<Otsani, Ani ta abu angba dafi abu fwo (ibɔ mgbi) ani wa mani. ");
INSERT INTO utr_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Ani ye dafi abu li fwo (ibɔ mgbi) Ani alonɔ mani, kpaa n le gbɔdzɛ nɛ mi ikye abɔ oyaaya mgbi inggisɛ ama nkwudzɛ to mmɛnɛ nɛni, ikye nu ma noyɛyɛ gbɛɛ di abu dɔ ani esɔ.>> ");
INSERT INTO utr_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Ngwi o gbɔdzɛ nɛ mata, iYesu kwu ela okwukwo gbɛɛ, <<ILadzaru, tasɛ!>> ");
INSERT INTO utr_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Inggisɛ ikwukwɔ na si tasɛ, yi ayangwuto ngwi a kye ndiwon afɔ yi abɔ, yi ongwi a kye bwan inɛ mani. Man iYesu nya ma gbɛɛ, <<Shɛlun angwuto ikwɔ na non lu.>> ");
INSERT INTO utr_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Nɛ emi iJuda ibyibyi ama nba angba ikwu mbi iMeri, di ungwɔ ngwi iYesu kyɔ nɛtaman, a nun oyɛyɛ. ");
INSERT INTO utr_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Nghaduu angbeka mi efu lu mbi emi iFarasi ka dakwɔ ungwɔ ngwi iYesu kyɔ mani. ");
INSERT INTO utr_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Nɛ okwukwo inggisɛ ama ofifɛ bɛyi emi iFarasi kwu ela okwakye mgbi osɔɔsɔ mgbi ama ogbiikwɔ. A byita gbɛɛ, <<Li alungwɔ ngwi eyi ka kyɔ? Inggisɛ nɛ le kyɔ ambɛ ama okwulewo kwuba. ");
INSERT INTO utr_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Kini eyi dzatan le kiyayi ngha yɔ, ali inggisɛ duu ka wa nun oyɛyɛ, nghanɛ emi iRoma ka ba wa kyi gbɛlu imbe mgbi eyi bɛyi ɛsɛ mgbi eyi kpaa.>> ");
INSERT INTO utr_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Ta onyi mi ifu ma, iyin di iKayafa, ongwu li okwukwo inggisɛ ofifɛ mi onova nani, nya ma gbɛɛ, <<Ema ye unkonyi ba duu! ");
INSERT INTO utr_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Ema yama difwi gbɛɛ i tatase ni inggisɛ onyi kwulu mi ikye ibyi inggisɛ ngha ogbɛɛ ni ɛsɛ mgbi eyi duu dzili ba.>> ");
INSERT INTO utr_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Li mi owitukwu mgban ngwi o gbɔdzɛ nɛ ba, kpaa li dafi o li okwukwo inggisɛ ofifɛ mi onova na mani, o gbɔ ela oyegbɔ gbɛɛ iYesu ka kwulu mi ikye ɛsɛ mgbi iJuda duu, ");
INSERT INTO utr_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","dika li ikye mgbi ɛsɛ na ta ba kpaa ka li mi ikye engwɛ mgbi Imgbasho ama nganya ntona mi oyile ma luba mbonyi di nu ma yɛɛ onyi. ");
INSERT INTO utr_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Nɛ i wita mi egbe na lu iyayi, a wibu ongwɔ iYesu. ");
INSERT INTO utr_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Nghanɛ iYesu di kyikyɛ mi ododa mi idzidzɛ emi iJuda wuba. Kpaa o lu ayɛsɛ ndzɛ kwɛkwɛ yi okwɛsɛ, mi agwɔ ngwi a li kwun di iFrɛn nani, ka dzɛ efu yi engwafɔɔn. ");
INSERT INTO utr_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Ngwi onɔ oga owɛ owatɔ-watɔ mgbi emi iJuda dzɛ kwɛkwɛ nɛ, inggisɛ kwuba le lu iJerosalin ikye oka fwɔ ewo duuse ni oga owɛ owatɔ-watɔ wa gyɔ. ");
INSERT INTO utr_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","A kale pita iYesu, dafi a kwudzɛ to mi akangga ozu okwukwo osunu Imgbasho mi iJerosalin nɛ, a le byi ewoma gbɛɛ, <<Ema le tsɛwɛ sinɛ? O ka ba Oga nɛ ba naadi?>> ");
INSERT INTO utr_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Nghaduu engyukwo ama ofifɛ bɛyi emi iFarasi teyi noola gbɛɛ kini inggisɛ ye imbe ngwi iYesu dzɛ yɔ, non gbɔ adzi nu ma ka bwan. ");
INSERT INTO utr_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Ngwi oga owɛ owatɔ-watɔ mgbi emi iJuda sisi egbe egyin nɛ, iYesu si kaka iBetani, imbe ngwi iLadzaru ongwu iYesu kyilon mi ikwu dzɛ nani. ");
INSERT INTO utr_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","A kyɔ oga ongwi onɔdɛ ikye mmwɛ mgbi iYesu mi imbe nani. IMata gbe oga nu, iLadzaru kpaa sɔdzɛ adinyatsɛ ogye ungwogye yi iYesu. ");
INSERT INTO utr_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Nɛ iMeri kyi kyelu ikpen engyie olɔlɔ ongwi fyunfyummya saan kye tulu kyi iYesu afɔ. Di kyi fɔlu yi otu mgban, man mmgbɛ mgbi engyie na kyi gbɛlu ozu sɔ. ");
INSERT INTO utr_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Kpaa engwafɔ mgbi iYesu onyi, iJuda Iskarɔti ongwu nka wa kyon gya ma byita gbɛɛ, ");
INSERT INTO utr_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","<<Kyɔsinɛ ngwi a kye engyie nɛ gya kye awuya na gha emi adzɛ ba? I mɛ udza okpa idɔ onova olɔlɔ.>> ");
INSERT INTO utr_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","O gbɔdzɛ nɛ ikyegbɛɛ di o kye emi adzɛ wuuta ba, kpaa li ikyegbɛɛ o li emumyi; ngwi o li inggisɛ okye ashiko da nɛ, o li ya ewon abɔ mi ungwɔ ngwi a kye wokɛ ele mani. ");
INSERT INTO utr_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","IYesu gbɛɛ, <<Dzanta kɛ. O kye engyie nɛ dzɛkɛ mi ikye egbe owa ndzi ani. ");
INSERT INTO utr_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Ema ka dzɛ yi emi adzɛ mi idzidzɛ ema alonɔ duu, kpaa ema ka dzɛ yi ani alonɔ ba.>> ");
INSERT INTO utr_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Ibyi inggisɛ emi iJuda difwi gbɛɛ iYesu dzɛ imbe nani man a ba, mi ikyon ta ba kpaa owa di iLadzaru, ongwu iYesu kyilon mi ikwongye nani. ");
INSERT INTO utr_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Nɛ engyukwo ama ofifɛ mgbi Imgbasho dzɛ yi oweka okyi ngwɔlu iLadzaru kpaa, ");
INSERT INTO utr_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","lubana mi ikye mgbi iLadzaru emi iJuda kwuba le dzata engyukwo mgbi ama yɛ nu iYesu oyɛyɛ. ");
INSERT INTO utr_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Tegblifan ibyi inggisɛ kpakpa ama nba oga owɛ owatɔ-watɔ mgbi emi iJuda fwo gbɛɛ iYesu kye ofɛ dikye le ba iJerosalin nɛ, ");
INSERT INTO utr_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","a gbe abaade tasɛ oka tun, le gbaakwɔ gbɛɛ, <<Osana! Mse no bɛ Inggisɛ ngwu ba mi iyi mgbi Otsɛ ewo! Mse no bɛ Utɔ mgbi emi Israi ewo!>> ");
INSERT INTO utr_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","IYesu tu ongwɛ itaklimyi dɔkɛ ele, dafi a teyi lɔ mi afɛ gbɛɛ, ");
INSERT INTO utr_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","<<Ka mio ba na, engwengwengyaa mgbi iDzayɔn; dii, utɔ mgbi abu kyɛ aali, o dɔdzɛ ongwɛ itaklimyi.>> ");
INSERT INTO utr_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Mi ababɔ ma engwafɔ mgban difwi ungwɔ ntonɛ ba. Li onɔ ngwi a nu iYesu okwɔkwɔ nyɛ ma se, a kuma difwi gbɛɛ ungwɔ ngwi a kyɔn ntonɛ, Afɛ plɛ lɔ dzɛ esɛ ikyon. ");
INSERT INTO utr_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Ikyenghanɛ ibyi inggisɛ ama nto yan mi onɔ ngwi o kwu iLadzaru ela tasɛ mi endzi di kyilon mi ikwu ma, kiyayi okye elodzɛ na gbɔfwɛ. ");
INSERT INTO utr_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Ikyegbɛɛ inggisɛ kwuba fwo ambɛ okwulewo ngwi o kyɔ nɛ, a tasɛ oka tun. ");
INSERT INTO utr_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Nɛ emi iFarasi gbɔ yi ewoma gbɛɛ, <<Dii, ungwɔnɛ le kye eyi kɛ mbeka ba. Di dafi ɛsɛ duu kyɛdɔn mani!>> ");
INSERT INTO utr_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Emi iGriki angbeka kɛ oka sunu mi oga owɛ owatɔ-watɔ mgbi emi iJuda nani. ");
INSERT INTO utr_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","A ba mbi iFyilipi, ongwu kyɛ mi iBɛtsaida mi iGalalia na, yi imina. A gbɛɛ, <<Ongyukwo, i mina eyi odi iYesu.>> ");
INSERT INTO utr_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","IFyilipi si kɛ ka nya Andru; Andru yi iFyilipi diyɛ lu ka nya iYesu. ");
INSERT INTO utr_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","IYesu nu uka gbɛɛ, <<Obyi ngwi Ongwɛ Inggisɛ ka gbɛ okwɔkwɔ ma gyɔ wa. ");
INSERT INTO utr_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","N nya ema otsitsi, ni inɛnekwu ngwuta lakɛ esɛ ma ni i bwa bayɔ, ka li inɛnɛ onyi kpɔɔ; kpaa non bwa yɔ, ka mba kwuba. ");
INSERT INTO utr_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Inggisɛ ndi oshishe mgban kpan itukwu yɔ, oshishe na ka nyanya lon, kpaa ongwu ndi oshishe mgban tan anyi mi ɛsɛ nɛ yɔ, ka kyon kaka oshishe ogyegwu. ");
INSERT INTO utr_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Ali inggisɛ nkyɔ ani idɔ ka kyɛdɔ ani kyɛmɛ; imbe ngwi ani dzɛ ma, ongbidɔ mgbi ani kpaa ka dzɛ ele. Otsani ka nu ongwu nli kyɔ ani idɔ ma mmwɛ. ");
INSERT INTO utr_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","<<Onɛnɛ itukwu mgbi Ani dzɛ mi okakewo, ma li alungwɔ ngwi ani ka gbɔ? Nin gbɛɛ, <Otsani, dulu Ani tɔ mi obyi nɛɛ>? Ei, li mi itɔdzɛ nɛ yɛyɛ ngwi Ani kaka obyi nɛ aani. ");
INSERT INTO utr_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Otsani, kye okwɔkwɔ nu iyi mgbi abu!>> Ta ela tɔ mi esho gbɛɛ, <<N kye okwɔkwɔ nu mi ele wa, ma n dika nun okwɔkwɔ kpɔɔ.>> ");
INSERT INTO utr_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Ibyi inggisɛ ama nto mmana ma fwo ungwɔ na di gbɛɛ akpala gbo; angbeka gbɛɛ ongyesɔ gbɔdzɛ yan. ");
INSERT INTO utr_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","IYesu gbɛɛ, <<Ela nɛ ba mi ikye mgbi ani ba, kpaa li mi ikye oyabɔ mgbi ema. ");
INSERT INTO utr_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Onɛnɛ li onɔ ngwi a ka gbɔ ɛsɛ nɛ ikwɔ, li onɛnɛ ngwi a ka lɔ ongwuutɔ ongwu ɛsɛ nɛ onya tɔ. ");
INSERT INTO utr_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Nghaduu Ani, onɔ ngwi a wa kyile Ani esho mi ɛsɛ nɛ yɔ, N ka kwo inggisɛ duu ba mbi ani.>> ");
INSERT INTO utr_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","O gbɔ ungwɔnɛ ikye otso itɔ ikwu ngwi ongwu ka wa kwu mani. ");
INSERT INTO utr_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Ibyi inggisɛ gbɛɛ, <<Eyi fwo mi Afɛ gbɛɛ iMedzaya ma ka dzɛ gyegwu, ma kyɔnɛ ngwi abu ka gbɛɛ, <A ka kye Ongwɛ Inggisɛ lu esho kyɛmɛ>? Li emɛ li Ongwɛ Inggisɛ nɛ?>> ");
INSERT INTO utr_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","IYesu si nya ma gbɛɛ, <<Ema ka wa tu osa mi ongwonɔ mi iyayi. Kyikyɛ mi onɔ ngwi ema ka dzɛ yi osa nɛni, duuse ni otu wa to tu ema. Inggisɛ nli kyikyɛ mi iyifu li ye imbe ngwi o le kɛ ba. ");
INSERT INTO utr_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Ema noyɛyɛ mi osa ngwi ema ka dzɛyan nɛni, ikye ni ema wa yɛɛ emi ongwɛ osa.>> Ngwi o ngyɛlu odzɛ ogbɔɔgbɔ mata, o si lu ka da. ");
INSERT INTO utr_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Ambɛ ama okwulewo ngwi iYesu kyɔ mi inai ma nɛ kpaa, a nun oyɛyɛ ba. ");
INSERT INTO utr_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Ungwɔnɛ kyɔ ikye ombwumbwo elodzɛ mgbi oyegbɔ Adzaya ngbɛɛ: <<Otsɛ, li emɛ noyɛyɛ mi esɔ mgbi eyi, di li emɛ ngwu mfye mgbi Otsɛ tso tɔ ododa mbon?>> ");
INSERT INTO utr_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Li mi itɔdzɛ nɛ ngwi a yagba noyɛyɛ ba aali, ikyena, dafi Adzaya kpaa gbɔ mbeka ma gbɛɛ: ");
INSERT INTO utr_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","<<O tukwu ma inɛ di nu itukwu mgbi ama tiishu, nghanɛ a ka di mi inɛ mgbi ama wuba, naadi difwi mi itukwu mgbi ama ba, hona kyatitukwu ni ani bwe ma ba.>> ");
INSERT INTO utr_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Adzaya gbɔdzɛ nɛ ikyekyɛ o di okwɔkwɔ mgbi iYesu di gbɔdzɛ mi efu. ");
INSERT INTO utr_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Nghaduu mi onɔ na kpɔɔ angbeka kwuba mi idzidzɛ ama ogbe inggisɛ teyi nun oyɛyɛ. Kpaa mi ikye mgbi emi iFarasi a yama gbɔ oyɛyɛ onuunu mgbi ama tasɛ esɛ ba, ikyesinɛ a le mio gbɛɛ a wa dulu ma tɔ mi ozu okwakye mgbi emi iJuda. ");
INSERT INTO utr_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Lubana a mina otsɛɛtsɛ mgbi inggisɛ ngha otsɛɛtsɛ mgbi Imgbasho. ");
INSERT INTO utr_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","IYesu gbɔ mi ela okwukwo gbɛɛ, <<Ni inggisɛ nu ani oyɛyɛ yɔ, li ani ta ngwi o noyɛyɛ ba, kpaa o nu ongwu ndɔ ani esɔ ma oyɛyɛ. ");
INSERT INTO utr_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Inggisɛ ndi ani yɔ, o di ongwu ndɔ ani esɔ mani. ");
INSERT INTO utr_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Ani ba ɛsɛ nɛ dafi osa, ikyegbɛɛ ali inggisɛ ongwu nu ani oyɛyɛ yɔ non ka dzɛ mi iifu ba. ");
INSERT INTO utr_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","<<Mbi inggisɛ ongwu nfwo elodzɛ mgbi ani kpaa ngyo ma bayɔ, ani gbɔn ikwɔ ba. Bana ani ba owa gbɔ ɛsɛ ikwɔ ba, kpaa owa dulun tɔ. ");
INSERT INTO utr_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Ikwɔ dzɛ mi ikye mgbi ongwu nfwa ani diyɛ gbɛ elodzɛ mgbi ani ba mani; elodzɛ ngwi ani gbɔ na kpɔɔ ka ngwɔn ikwɔ mi egbe ongwi olɛlɛ. ");
INSERT INTO utr_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Bana ani le gbɔdzɛ mgbi ikyibani ba, kpaa li Otsani ndɔ ani esɔ ma wo ani ola mi ungwɔ ngwi ani ka gbɔ yi itɔ ofɛ ngwi ani dika gbɔn mani. ");
INSERT INTO utr_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Ani ye gbɛɛ ola mgban li nu oshishe gyegwu. Nghanɛ alungwɔ ngwi ani gbɔ yɔ le yɛyɛ yi ungwɔ ngwi Otsani nya ani gbɛɛ ni ani gbɔ mani.>> ");
INSERT INTO utr_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Duuse nu ma wa gye oga owɛ owatɔ-watɔ mgbi emi iJuda. IYesu ye dafi onɔ mgban ngyɛ owa dzata ɛsɛ nɛ yɛ lu mbi Otsɔn. Ngwi ama nli mgban kpan itukwu ka to ɛsɛ nɛ nɛ, o si tso ma okpitukwu mgban ngyɛ klɛklɛ. ");
INSERT INTO utr_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Dafi a sɔ ungwogye ongwi onɔdɛ nɛman, Olodu tu iJuda Iskarɔti ongwɛ iSaimɔn wo, owa kye iYesu gya. ");
INSERT INTO utr_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","IYesu ye dafi Otsɔn nun mfye mi alungwɔ duu mani, di ye dafi ongwu kyɛ mbi Imgbasho dile yɛ lu mbi Imgbasho mani. ");
INSERT INTO utr_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Nɛ o kyato mi ita ungwogye fwadulu angwuto ongwi esɛ kye oshata to oshi. ");
INSERT INTO utr_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","O kyi mwalu eni wokɛ okye wita le sa emi ongwafɔɔn afɔ, yile oshata na fwɔ ma afɔ. ");
INSERT INTO utr_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","O wa to mbi iSaimɔn iPyita, ongwu nbyun gbɛɛ, <<Otsɛ, abu ka sa ani afɔɔ?>> ");
INSERT INTO utr_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","IYesu nu uka gbɛɛ, <<Onɛnɛ ema yama ye ungwɔ ngwi ani le kyɔ nɛ waba, kpaa ema ka wa ye mi iyayi.>> ");
INSERT INTO utr_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","IPyita gbɛɛ, <<Ei, o ka yama sa ani afɔ ba.>> IYesu gbɛɛ, <<Kini ani sa abu afɔ bayɔ, abu wo atɛ yi ani ba.>> ");
INSERT INTO utr_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","ISaimɔn iPyita si gbɛɛ, <<Ngyɛse, Otsɛ, no ka li afɔ ta ba, sa ani abɔ yi ikye kpaa!>> ");
INSERT INTO utr_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","IYesu nu uka gbɛɛ, <<Inggisɛ nteyi shuwo yɔ i wogyɔ ngwi o ka saafɔ ta; ikyekyɛ ewo mgban duu teyi le saan wa. Ema le saan, kpaa li ema duu ba.>> ");
INSERT INTO utr_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Bana iYesu ye otsungwɔn nka wa kye ongwu gya mani, li ngha ngwi o gbɛɛ li ema duu le saan ba aali. ");
INSERT INTO utr_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Dafi o sa ma afɔ ngyɛ nɛ, o yile angwuto wo yɛ luba imbe mgban. O si byi ma gbɛɛ, <<Ema difwi ungwɔ ngwi ani kyɔ yi ema nɛ wɛ?>> ");
INSERT INTO utr_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","<<Ema li kwu ani gbɛɛ, <Otsetse> yi <Otsɛ> li ayin yɛyɛ, li ungwɔ ngwi ani dzɛ aali. ");
INSERT INTO utr_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Onɛnɛ ngwi ani, Otsɛ yi Otsetse mgbi ema, sa ema afɔ nɛ, ema kpaa ka yɛ sa ewema afɔ ngha. ");
INSERT INTO utr_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","N tso ema ambɛ ngha ikye ni ema kyɔ dafi ani kyɔ yi ema nɛni. ");
INSERT INTO utr_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","N nya ema otsitsi ongbidɔ yama dzɛ yi oshewo ngha ongyukwo mgban ba, naadi ongyesɔ ngha ongwu ndɔn esɔ ma ba. ");
INSERT INTO utr_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Ngwi ema ye ungwɔ ntonɛ onɛnɛ nɛ, ema ka tu mse kini ema kyɔ ma yɔ. ");
INSERT INTO utr_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","<<N yama le gbɔ yi ema duu ba; n ye ama ani sadu mani. Nghaduu nɛnɛ li ikye ni ungwɔ ngwi a lɔ dzɛ Afɛ gbɛɛ: Ongwu nkye abɔ wo uga yi ani nɛ ka yile iga fyi yɛn na no mbwumbwo. ");
INSERT INTO utr_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","<<N le nya ema onɛnɛ duuse no wa kyɔ, ikyegbɛɛ no wa kyɔ yɔ ema ka noyɛyɛ mi itɔ inggisɛ ngwu Ani dzɛ mani. ");
INSERT INTO utr_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","N nya ema otsitsi, ali inggisɛ ngbɛ inggisɛ ngwu ani dɔn esɔ tayɔ gbɛ ani; ma inggisɛ ta ongwu gbɛ Ani yɔ gbɛ ongwu ndɔ ani esɔ mani.>> ");
INSERT INTO utr_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","IYesu gbɔdzɛ nɛ ngyɛ man i kakan ewo mi onodzi ta o kyɔ obwɛndɛ gbɛɛ, <<N nya ema otsitsi, onyi mbi ema ka wa kye ani gya.>> ");
INSERT INTO utr_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Engwafɔɔn ndinɛ di ewoma, ikye ni ama difwi inggisɛ ngwu o le gbɔdzɛ na ikyen mani. ");
INSERT INTO utr_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Oka mi idzidzɛ ma, ongwafɔ nkpa iYesu itukwu, sɔ dɔn. ");
INSERT INTO utr_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","ISaimɔn iPyita kyɔ ongwu nkpa iYesu itukwu na abɔ gbɛɛ, <<Byun li emɛ ngwi o le gbɔdzɛ na yan.>> ");
INSERT INTO utr_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","O kye ewo ge iYesu kɛ, si byun gbɛɛ, <<Otsɛ li emɛni lo?>> ");
INSERT INTO utr_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","IYesu nu uka gbɛɛ, <<Li ongwu ani ka kye anggayɛ ibredi nɛ ba kye nun mani.>> Nɛ, o kye anggayɛ ibredi na ba, kye nu iJuda Iskarɔti, ongwɛ iSaimɔn nani. ");
INSERT INTO utr_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Ntunto ngwi iJuda kye gbɛlu ibredi nɛman, iSatan si kaka mbon. IYesu nyan gbɛɛ, <<Ungwɔ nwo abu owa kyɔ ma, kyɔn plɛ-plɛ tsatso!>> ");
INSERT INTO utr_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Nghaduu inggisɛ onyi mi ita ungwogye difwi ungwɔ nkyɔ se ngwi iYesu gbɔdzɛ nɛ yan ma ba. ");
INSERT INTO utr_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Dafi iJuda li utɔ igbe nɛ, angbeka tsɛwɛ gbɛɛ iYesu le nyan gbɛɛ no ka gya ungwɔ ngwi ama ka wa kyɔ aboyaaya ele mi oga owɛ owatɔ-watɔ mgbi emi iJuda, hona kye ungwɔ nu emi adzɛ. ");
INSERT INTO utr_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Labɔlabɔ ngwi iJuda kyi gbɛlu ibredi nɛta, o tɔ lu esɛ. Ma li mi otu. ");
INSERT INTO utr_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Ngwi iJuda tɔ lu nɛ, iYesu gbɔgbɛɛ, <<Onɛnɛ Ongwɛ Inggisɛ tu okwɔkwɔ wa, Imgbasho kpaa tu okwɔkwɔ mbon. ");
INSERT INTO utr_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Kini Imgbasho tu okwɔkwɔ mbon yɔ, Imgbasho ka nu Ongwɛ okwɔkwɔ mbi ewon, dika nu okwɔkwɔ ma akponyi. ");
INSERT INTO utr_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","<<Ɛngbɛ mgbi ani, ani ka dzɛ yi ema onɔ gblɔgɔdɔ wuba. Ema ka pita ani, dafi n nya emi iJuda ma n dile nya ema onɛnɛ ngha yɛyɛ: Imbe ngwi ani le kɛ ma, ema ka ba gbɛ ba. ");
INSERT INTO utr_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","<<Ani le wo ema ola ofufɛ: Kpa ewema itukwu na. Dafi ema kpa ani itukwu nɛ, li ngha ema kpaa ka kpa ewema itukwu aali. ");
INSERT INTO utr_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Ni ema le kyɔ ngha yɔ inggisɛ duu ka ye gbɛɛ ema li engwafɔ mgbi ani.>> ");
INSERT INTO utr_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","ISaimɔn iPyita byun gbɛɛ, <<Otsɛ, li mi ole ngwi abu le kɛ?>> IYesu gbɛɛ, <<Imbe ngwi ani le kɛ ma, ema ka kyɛdɔ onɛnɛ gbɛ ba, nghaduu ema ka wa kyɛdɔ mi onɔ ongwi iyayi.>> ");
INSERT INTO utr_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","IPyita byita gbɛɛ, <<Otsɛ, kyɔsinɛ ngwi ani ka yagba kyɛdɔ abu onɛnɛ gbɛ ba? Ani ka kye oshishe mgbi ani nu mi ikye abu.>> ");
INSERT INTO utr_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","IYesu si gbɛɛ, <<Mi odzimɔ abu ka kye oshishe mgbi abu nu mi ikye anii? N nya abu otsitsi, ogbigbi ka teela waba ta, abu ka tangwɛ ani akpe eta! ");
INSERT INTO utr_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","<<Ka nu itukwu kaka ema ewo ba. Nu Imgbasho oyɛyɛ; di nu ani kpaa oyɛyɛ na; ");
INSERT INTO utr_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Mi udɛ Otsɛn ozu kwuto; ki li ngha bayɔ, n ki nya ema. Ani le lu ele oka yile imbe mɛ ikye ema. ");
INSERT INTO utr_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Ni Ani ka yile imbe mɛ ikye ema yɔ, n ka yɛ wa gbe ema ka dzɛ yi Ani adzi imbe ngwi Ani dzɛ ma ema kpaa ka dzɛ. ");
INSERT INTO utr_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Ema ye ofɛ okɛ imbe ngwi ani le lu mani.>> ");
INSERT INTO utr_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","ITɔmɔsu nyan gbɛɛ, <<Otsɛ, eyi ye imbe ngwi abu le kɛ ba, ma ka kyɔsinɛse eyi ka ye ofɛ?>> ");
INSERT INTO utr_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","IYesu nu uka gbɛɛ, <<Ani li ofɛ yi otsitsi bɛyi oshishe. Inggisɛ onyi ka yagba kɛ mbi Otsani ba se o ka nyɛ mbi ani. ");
INSERT INTO utr_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Ema ki ye ani saan yɔ, ema kika ye Otsani kpaa. Wita onɛnɛ lu iyayi, ema yon di din waani.>> ");
INSERT INTO utr_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","IFyilipi gbɛɛ, <<Otsɛ, tso eyi Otsabu mani ta sika gyɔlo eyi.>> ");
INSERT INTO utr_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","IYesu nyan gbɛɛ, <<iFyilipi, ngwi Ani dzɛ yi ema onɔ gblɔgɔdɔ nɛ kpaa abu ye ani lo? Ali inggisɛ ndi ani yɔ li Otsani ma ngwi o di. Kyɔsinɛ ngwi abu gbɛɛ, <Tso eyi Otsani ma> ");
INSERT INTO utr_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Abu noyɛyɛ dafi Ani dzɛ mbi Otsani, Otsani kpaa di dzɛ mbi ani baa? Elodzɛ ngwi Ani le nya ema nɛ li mgbi ani abuen ta ba. Kpaa li Otsani ndzɛ mbi ani ma, le kyidɔ mgban aani. ");
INSERT INTO utr_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Nu Ani oyɛyɛ dafi Ani gbɛɛ Ani dzɛ mbi Otsani, Otsani kpaa di dzɛ mbi ani nɛni; hona ni i ndɛ sinɛ-sinɛ kpaa ema noyɛyɛ mi ambɛ mgbi ungwɔ okwulewo ntonɛni. ");
INSERT INTO utr_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","N nya ema otsitsi, ali inggisɛ ndzɛ yi oyɛyɛ onuunu mbi ani ka kyungwɔ ama ngwi Ani teyi le kyɔ ntonɛni. O ka kyungwɔ ama nngha ntonɛ kpaa, ikyekyɛ n le lu mbi Otsani. ");
INSERT INTO utr_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","N ka kyɔ alungwɔ ngwi ema bɔ mi iyi mgbi ani duu, adzi ni Ongwɛ kye okwɔkwɔ nu Otsɔn. ");
INSERT INTO utr_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Ema ka yagba bɔ alungwɔ duu mi iyi mgbi ani, n dika kyɔ ema ele. ");
INSERT INTO utr_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","<<Kini ani kpa ema itukwu yɔ, ema ka ngyo ola ngwi Ani wo ema mani. ");
INSERT INTO utr_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","N dika bɔ Otsani, ta o ka nu ema Ongye okwu ema ɛwɛ wo oka, ongwu nka dzɛ yi ema gyegwu mani, ");
INSERT INTO utr_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Onodzi mgbi otsitsi nani. Ɛsɛ ka gban ba, ikyekyɛ o yon hona din kpaa ba. Nghaduu ema yon, lubana o dzɛ yi ema dika wo mbi ema kpaa. ");
INSERT INTO utr_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","N ka dzata ema dafi ongwokwu ba; n ka yɛ ba mbi ema. ");
INSERT INTO utr_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Mi ongwonɔ gwee ɛsɛ ka di ani wuba, kpaa ema yɔ ka di ani. Ikyesinɛ Ani dzɛ oshishe, ema kpaa ka dzɛ oshishe. ");
INSERT INTO utr_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Mi egbe na ema ka wa difwi dafi ani dzɛ mbi Otsani, ema wo mbi ani, ani di wo mbi ema mani. ");
INSERT INTO utr_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Ali inggisɛ ndzɛ yi ola mgbi ani di li ngyo ma yɔ, li ongwu ani kpan itukwu. Inggisɛ ani kpan itukwu yɔ o ka kpa Otsani itukwu, ani kpaa o dika kpa ani itukwu, n dika kye ewani tson.>> ");
INSERT INTO utr_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Ta iJuda (li mgbi Iskarɔti na ba) gbɛɛ, <<Otsɛ, kyɔsinɛse ngwi abu witukwu okye ewabu tso ɛsɛ ba ngwi li eyi ta?>> ");
INSERT INTO utr_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","IYesu nu uka gbɛɛ, <<Kini ani kpa inggisɛ itukwu yɔ, o ka kyɛdɔ otsootso mgbi ani. O dika kpa Otsani itukwu, eyi dika ba mbon wa dzɛyan. ");
INSERT INTO utr_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Inggisɛ ngwu ani kpan itukwu bayɔ, o ka kyɛdɔ otsootso mgbi ani ba. Elodzɛ ngwi ema li fwo ntonɛ li mgbi ani ba; a li mgbi Otsani ndɔ ani esɔ mani. ");
INSERT INTO utr_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","<<Ani le nya ema ungwɔ ntonɛ duu ngwi ani ka dzɛ yi ema nɛni. ");
INSERT INTO utr_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Kpaa Ongye okwɛwɛwo, Onodzi Osaan, ngwu Otsani ka kye dɛsɔ mi iyi mgbi ani na, ka tso ema ungwɔ duu diyɛ wɛ ema alungwɔ ama ngwi ani teyi gbɔ nya ema duu. ");
INSERT INTO utr_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","N dzata iyu yi ema; n kye iyu mgbi ani nu ema. N kye nu ema dafi ɛsɛ li nu ma ba. Ka nu itukwu sha ema anyɛ ba dika tsimio ba na. ");
INSERT INTO utr_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","<<Ema fwo dafi ani gbɛɛ, <N le lu mbeka n dika yɛ ba mbi ema mani.> Ni ani kpa ema itukwu yɔ, ema ka tsatsa gbɛɛ Ani le lu mbi Otsani, lubana Otsani shewo ngha Ani. ");
INSERT INTO utr_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","N nya ema onɛnɛ duuse no wa kyɔ, ikyegbɛɛ no wa kyɔ yɔ, ni ema noyɛyɛ mani. ");
INSERT INTO utr_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","N ka gbɔdzɛ yi ema gblɔgɔdɔ wuba, lubana ongwuutɔ ongwi ɛsɛ nɛ kyɛma. O dzɛ yi mfye mbi ani ba, ");
INSERT INTO utr_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","kpaa ɛsɛ no ye kyɛmɛ gbɛɛ Otsani kpa ani itukwu, ani di li kyungwɔ ngwi Otsani wo ani ola ma yɛyɛ. <<Kyato; ni eyi lu dzata imbe nɛ na. ");
INSERT INTO utr_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","<<IYesu nya engwafɔɔn gbɛɛ: Ani li ekwɔ eneekwɔ otsitsi, Otsɛn li inggisɛ ogbinɛbyi ekwɔ. ");
INSERT INTO utr_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","O li kyi dzɛlu ali abɔ ndzɛ mbi ani wa owawa ba ma ngwuta, kpaa o li kye gbɔmbɔ akyikyen mi abɔ ngwi wa owawa mani, ikye no kiyayi owa awawa kwuba. ");
INSERT INTO utr_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Ema teyi le saan mi ikye elodzɛ ngwi Ani plɛ gbɔ nya ema nani. ");
INSERT INTO utr_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Kwudzɛ mbi ani na, ta Ani kpaa ka kwudzɛ mbi ema. Abɔ ka yagba wa owawa ikyibɔn ba, sede o ka kwokyi mi iteekwɔ kyɛmɛ. Ema kpaa ka yagba wa owawa ba sede ni ema kwudzɛ mbi ani. ");
INSERT INTO utr_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Ani li ekwɔ eneekwɔ ema li abɔ. Kini inggisɛ kwudzɛ mbi ani yɔ, ani kpaa ka kwudzɛ mbon, o ka wa awawa nghaabɔ ogbugbe; ni li Ani bayɔ ema ka kyɔ unkonyi gbɛ ba. ");
INSERT INTO utr_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Ali inggisɛ nkwudzɛ mbi ani bayɔ, o dzɛ dafi abekwɔ ngwi a kyi fwɛlu ngwuta non ngwɔ mani; itɔ abekwɔ ntona a li sa ma wokɛ ola nu ma gyola. ");
INSERT INTO utr_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Kini ema kwudzɛ mbi ani elodzɛ mgbi ani kpaa di dzɛ mbi ema yɔ, ema ka bɔ alungwɔ ngwi ema mina duu a ka kye nu ema. ");
INSERT INTO utr_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Ungwɔnɛ li ikye onu Otsani okwɔkwɔ, ogbɛɛ ni ema wa awawa nghaabɔ ogbugbe, nu ma di difwi gbɛɛ ema li engwafɔ ani. ");
INSERT INTO utr_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Dafi Ani kpa Otsani itukwu nɛ, li ngha ngwi ema kpa ani itukwu aali, onɛnɛ kwudzɛ mi okpitukwu mgbi ani na. ");
INSERT INTO utr_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Kini ema ngyo ola mgbɛn yɔ, ema ka kwudzɛ mi okpitukwu mgbɛn, dafi ani kpaa ngyo ola mgbi Otsɛn di kwudzɛ mi okpitukwu mgban nɛni. ");
INSERT INTO utr_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Ani nya ema ungwɔnɛ ikye ni atsa mgbi ani dzɛ mbi ema, adzi ni atsa mgbi ema mbwumbwo. ");
INSERT INTO utr_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Ola mgbi Ani ma li ongwu aani: Di ewema kpa eka itukwu dafi ema kpa Ani itukwu nɛni. ");
INSERT INTO utr_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Inggisɛ onyi dzɛ yi okpitukwu ngwi she ngha ongwunɛ ba, ogbɛɛ inggisɛ kye oshishe mgban lasɛ mi ikye mgbi emi okaan. ");
INSERT INTO utr_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Ema li emi okani kini ema ngyo ola ngwi ani wo ema yɔ. ");
INSERT INTO utr_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Ani kwu ema gbɛɛ engbidɔ wuba, ikyesinɛ ongbidɔ ye ungwɔ ngwi ongyukwo mgban li kyɔ ba. Nghanɛ, n kwu ema gbɛɛ emi okani, bana alungwɔ ngwi ani kpayi mbi Otsani duu ani nu ema ye. ");
INSERT INTO utr_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Li ema dulu Ani ba, kpaa Ani dulu ema di wo ema idɔ gbɛɛ ni ema lu ka wa owawa nka li gyegwu. Ta Otsani ka nu ema alungwɔ ngwi ema pita mi iyi mgbi ani duu. ");
INSERT INTO utr_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Nɛnɛ li ola ngwi ani wo ema: Di eka kpa eka itukwu na. ");
INSERT INTO utr_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","<<Kini ɛsɛ di ema tanyi yɔ, wɛ gbɛɛ i tsekise di ani tanyi. ");
INSERT INTO utr_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Kini ema li mgbi ɛsɛ yɔ, ema kika kpan dafi ema li mgban mani. Dafi i dzɛ nghanɛ, ema li mgbi ɛsɛ nɛ ba, kpaa ani dulu ema tɔ mi ɛsɛ. Li ikyengha ngwi ɛsɛ di ema tanyi aali. ");
INSERT INTO utr_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Wɛ odzɛ ngwi ani tsekise gbɔ yi ema gbɛɛ: <Ongbidɔ onyi shewo ngha ongyukwo mgban ba nani.> Kini a gbɔ ani odzɛ ewo yɔ, a dika gbɔ ema kpaa ngha. Kini a sunu otsootso mgbi ani, a ka sunu otsootso mgbi ema kpaa. ");
INSERT INTO utr_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","A ka kyɔ yi ema mi itɔ ofɛ nɛ mi ikye iyi mgbi ani, ikyesinɛ a ye Ongwu ndɔ ani esɔ ma ba. ");
INSERT INTO utr_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Ni ani ki teyi ba wa gbɔdzɛ yi ama bayɔ, a kika dzɛ yi obube mi alobube mgbi ama ba. Nghaduu onɛnɛ nɛ ema ka yagba natsondu mi obube mgbi ema wuba. ");
INSERT INTO utr_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Inggisɛ ongwu ndi ani kyili di Otsani kpaa kyili. ");
INSERT INTO utr_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Ni ani ki kyɔ mi idzidzɛ mgbi ama ungwɔ ngwi inggisɛ oka teyi kyɔ mi idzidzɛ mgbi ama ye bayɔ, a kika dzɛ yi obube mi alobube mgbi ama ba. Kpaa onɛnɛ a di ungwɔ ama okwulewo ntonɛ duu, nghaduu kpaa a di ani kyili yi Otsani duu. ");
INSERT INTO utr_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Nghaduu nɛnɛ li ombwumbwo ungwɔ ngwi a lɔ mi Ola mgbi ama gbɛɛ: <A di ani kyili mi itɔdzɛ ba nani.> ");
INSERT INTO utr_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","<<Ni ongye Okwɛwɛwo, Onodzi mgbi otsitsi ntɔkyɛ mbi Otsani ongwu ani ka wa dɔn esɔ mbi ema ma, wa ba yɔ, o ka kyɔ obwɛndɛ mi ikye ani. ");
INSERT INTO utr_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Li kyɛmɛ ema kpaa ka kyɔ obwɛndɛ, ikyesinɛ ema dzɛ yi ani kyɛ mi owita-wita. ");
INSERT INTO utr_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","<<Ungwɔ ntonɛ duu Ani tsekise nya ema ikyegbɛɛ ni ema ka boofɛ ba. ");
INSERT INTO utr_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","A ka wa dulu ema tɔ mi ozu okwakye mgbi emi iJuda; mi otsitsi, onɔ kyɛma ngwi ali inggisɛ ngwu ngwɔ ema duu ka tsɛwɛ gbɛɛ ongwu le kyɔ Imgbasho idɔ. ");
INSERT INTO utr_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","A ka kyɔ itɔ ungwɔ ntonɛni ikyesinɛ, a ye Otsani hona ani ba. ");
INSERT INTO utr_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Ani tsekise nya ema ungwɔ ntonɛni, ikyegbɛɛ ni onɔ ma wa gyɔ ema ka wɛ gbɛɛ ani tsekise kwo ema adɔ. Ani nya ema ungwɔnɛ mi ababɔ ma ba, ikyekyɛ ani ka dzɛ yi ema. ");
INSERT INTO utr_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","<<Onɛnɛ Ani le lu mbi ongwu ndɔ ani esɔ mani, nghaduu onyi mbi ema kpaa byi ani ita gbɛɛ, <Li mi ole ngwi abu le lu baa?> ");
INSERT INTO utr_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Ikyegbɛɛ Ani nya ema ungwɔ ntonɛ nɛ, ema yɛɛ elela. ");
INSERT INTO utr_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Nghaduu Ani le nya ema otsitsi: Li mi abɔ oyaaya mgbi ema ngwi Ani le lu dzɛ ema ta aani. Sede Ani ka lu dzɛ ema ta bayɔ, Ongye okwɛwɛwo na ka ba mbi ema ba; Kpaa kini Ani lu, Ani ka dɔnsɔ mbi ema. ");
INSERT INTO utr_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Non wa ba yɔ, o ka fwo ɛsɛ ikwɔ mi ikye alobube yi osaan: ");
INSERT INTO utr_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","mi ayɛ mgbi obube yɔ, li ikyegbɛɛ a nu ani oyɛyɛ ba; ");
INSERT INTO utr_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","mi ayɛ mgbi osaan yɔ, li mi ikyegbɛɛ Ani le lu mbi Otsani, mi imbe ngwi ema ka di ani alonɔ-alonɔ wuba; ");
INSERT INTO utr_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","mi ayɛ mgbi ikwɔ ogbɔɔgbɔ yɔ, li ikyegbɛɛ ongwuutɔ mgbi ɛsɛ nɛ, a tsekise gbɔn ikwɔ. ");
INSERT INTO utr_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","<<Ani ka dzɛ yi odzɛ kpakpa ogbɔ yi ema, nghaduu i mbwo nyɛsɛ ngwi ema ka difwi ngyɛ onɛnɛni. ");
INSERT INTO utr_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Kpaa onɔ ngwi ongwu, Onodzi mgbi otsitsi, wa ba yɔ, o ka ngyo ema kaka ali otsitsi duu. O ka gbɔdzɛ mgbi ikyibɔn ba; o ka gbɔdzɛ ngwi o fwo ma kyoon ta, o dika nya ema ungwɔ nka kyɛ iyayi mani. ");
INSERT INTO utr_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","O ka kye okwɔkwɔ ba mbi ani ikyekyɛ o ka kye odzɛ ngwi Ani gbɔ yilen nya ema. ");
INSERT INTO utr_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Alungwɔ nli mgbi Otsani li mgbi ani. Li ikyengha ngwi ani gbɛɛ Onodzi ka todulu mi ungwɔ nli ngwi ani kye nu di nu ema yon aali. ");
INSERT INTO utr_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","<<Mi ongwonɔ gwee ema ka wa di ani wuba, dika tunto bata ema dika wa di ani.>> ");
INSERT INTO utr_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Engwafɔ mgbi iYesu angbeka gbɔ yi ewoma gbɛɛ, <<O kye inɛ byi sinɛ ngwi o gbɛɛ, <Mi ongwonɔ gwee ema ka di ani wuba, dika tunto bata ema dika wa di ani,> <Ikyekyɛ ani le lu mbi Otsani>? >> ");
INSERT INTO utr_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","A kiyayi obyita gbɛɛ, <<Ongwonɔ gwee nɛ ma, <tso sinɛ>? Eyi difwi odzɛ ngwi o le gbɔ nɛ ba.>> ");
INSERT INTO utr_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Ngwi iYesu di gbɛɛ i mina ma obyi ongwu ita mi odzɛ nɛ nɛ, o nya ma gbɛɛ, <<Ema le byi ewema ita mi odzɛ ngwi Ani gbɛɛ, <Mi ongwonɔ gwee ema ka wa di ani wuba, dika tunto bata ema dika wa di ani nɛɛ>? ");
INSERT INTO utr_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Ani nya ema otsitsi, ema ka wa tsukwu di kyelela nghaduu ɛsɛ ka dzɛ yi atsa kwuba. Ema ka wa dzɛ mi okakewo, kpaa okakewo mgbi ema ka wa yɛɛ atsa. ");
INSERT INTO utr_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Ongyaa nle gblimba li dzɛ yi owulu-wulu kpakpa ikyekyɛ onɔ imba mgban gyɔ; kpaa mi onɔ ngwi o mbongwɛ yɔ, o li gblimɔ yi owulu-wulu nani ikyesinɛ atsa mgban li ogbɛɛ ongwu mbimba mi ɛsɛ nɛni. ");
INSERT INTO utr_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Li ngha ndzɛ yi ema aani: Onɛnɛ li onɔ okakewo mgbi ema, kpaa Ani dika yɛ di ema ta ema ka dzɛ yi atsa, ma inggisɛ onyi kpaa ka gbɛlu ema atsa na ba. ");
INSERT INTO utr_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Mi egbe na ema ka byi ani ita ungwɔ onyi kpaa wuba. N nya ema otsitsi, Otsani ka kye alungwɔ ngwi ema bɔ mi iyi mgbi ani duu nu ema. ");
INSERT INTO utr_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Nghataa ba onɛnɛ kpaa ema bɔ unkonyi mi iyi mgbi ani waba. Bɔ na ta ema ka gbɛ, man ema ka dzɛ yi atsa kpakpa. ");
INSERT INTO utr_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","<<Nghaduu ani teyi le gbɔdzɛ yi ema mi itaodzɛ, onɔ kyɛma ngwi ani ka wa gbɔ itɔ ondudzɛ nɛ yi ema wuba, kpaa n ka wa nya ema odzɛ mgbi Otsani mi ododa. ");
INSERT INTO utr_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Mi egbe na ema ka bɔ mi iyi mgbi ani. Ani le gbɛɛ n ka bɔ Otsani mi ikye ema ba. ");
INSERT INTO utr_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Ei, Otsani abuon di ema kpan itukwu ikyesinɛ Ani kpa ema itukwu ema di noyɛyɛ gbɛɛ Ani kyɛ mbi Imgbasho. ");
INSERT INTO utr_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Ani kyɛ mbi Otsani di wa kaka ɛsɛ nɛni; onɛnɛ ani le dzata ɛsɛ nɛ diyɛ lu mbi Otsani.>> ");
INSERT INTO utr_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Ta engwafɔ iYesu gbɛɛ, <<Onɛnɛ abu le gbɔdzɛ yi eyi gbosa di li mi itaodzɛ wuba. ");
INSERT INTO utr_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Onɛnɛ eyi di gbɛɛ abu yengyɛ alungwɔ duu di mina gbɛɛ ni inggisɛ onyi kpaa no ka byi abu ita angbeka wuba. Ungwɔnɛ nu eyi noyɛyɛ gbɛɛ abu kyɛ mbi Imgbasho.>> ");
INSERT INTO utr_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","IYesu nu ma uka gbɛɛ, <<Ema noyɛyɛ onɛnɛɛ? ");
INSERT INTO utr_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Nghaduu onɔ kyɛma, di li onɔ ma joani, onɔ ngwi a ka ganya ema, ali inggisɛ ka lu udɛ mgban. Ema ka dzata ani yuen. Kpaa Ani dzɛ yuen ba, lubana Otsani dzɛ yi ani. ");
INSERT INTO utr_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","<<Ani teyi nya ema ungwɔ ntonɛ, ikyegbɛɛ ni ema tu iyu ikpewo ani. Mi ɛsɛ nɛ ema ka dzɛ yi okakewo. Nghaduu bwalu itukwu na! Ani ngha ɛsɛ wa.>> ");
INSERT INTO utr_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Dafi iYesu gbɔdzɛ nɛ ngyɛ nɛ, o kyile inɛ esho si bibɔ gbɛɛ: <<Otsani, onɔ ma gyɔ wa. Kye Okwɔkwɔ nu ongwabu, adzi ni Ongwabu kpaa kye okwɔkwɔ nu abu. ");
INSERT INTO utr_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Bana abu teyi kye mfye nun mi ikye mgbi ali inggisɛ duu gbɛɛ no kye oshishe gyegwu nu ama abu kye nun duu. ");
INSERT INTO utr_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Ma li oshishe gyegwu aani: li onu ma ye abu, Imgbasho otsitsi yuon, bɛyi iYesu iKrestu, ongwu abu dɔn esɔ nɛni. ");
INSERT INTO utr_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Ani kye okwɔkwɔ nu abu mi ɛsɛ mi ongyɛlu idɔ ngwi abu kye nu ani gbɛɛ ni ani kyɔ mani. ");
INSERT INTO utr_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Ikyenghanɛ, Otsani, nu ani okwɔkwɔ mi inai abu okwɔkwɔ ngwi ani teyi dzɛyan yi abu duuse ɛsɛ wa wita nani.>> ");
INSERT INTO utr_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","<<Ani kye abu tso mbi ama abu kye nu ani mi ɛsɛ nɛni. A teyi li mgbi abu; abu kye ma nu ani a di ngyo elodzɛ mgbi abu. ");
INSERT INTO utr_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Onɛnɛ a ye gbɛɛ ungwɔ ngwi Ani dzɛyan duu kyɛ mbi abu. ");
INSERT INTO utr_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Lubana ani kye elodzɛ ngwi abu kye nu ani ma nu ma a di kyi gbɛlu. A ye saan gbɛɛ ani kyɛ mbi abu, a di noyɛyɛ gbɛɛ abu dɔ ani esɔ. ");
INSERT INTO utr_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Ani bibɔ mi ikye ma. Ani le bibɔ mi ikye mgbi ɛsɛ ba, kpaa li mi ikye mgbi ama ngwu abu teyi gbe ma nu ani, ikyesinɛ a li mgbi abu. ");
INSERT INTO utr_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Alungwɔ ani dzɛyan duu li mgbi abu, alungwɔ abu di dzɛyan duu li mgbi ani. Ani di tu okwɔkwɔ ikpewo ma. ");
INSERT INTO utr_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Ani ka dzɛ ɛsɛ nɛ wuba, kpaa ama ka to ɛsɛ nɛni, ani kyɛma le lu mbi abu. Otsani Osaan, ngyo ma mi mfye mgbi iyi mgbi abu, iyi ngwi abu kye nu ani ikye nu ma yɛɛ onyi dafi eyi kpaa li onyi nɛni. ");
INSERT INTO utr_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Mi onɔ ngwi ani ka dzɛ yi ama ma, ani ngyo ma di kye ma dzɛ saan mi iyi ngwi abu kye nu ani. Onyi kpaa byulu ba sede li onyi ongwu dzɛ mi ikye odzili-dzili, ikyegbɛɛ ni elodzɛ mgbi Afɛ mbwumbwo nani.>> ");
INSERT INTO utr_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","<<Ani kyɛma le ba mbi abu onɛnɛni, nghaduu ani gbɔ ungwɔ ntonɛ ngwi ani ka dzɛ ɛsɛ nɛni, ikyegbɛɛ nu ma tu atsa kpakpa dafi ani kpaa tu nɛni. ");
INSERT INTO utr_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Ani teyi kye elodzɛ mgbi abu nu ma wa, kpaa ɛsɛ di ma kyili, ikyekyɛ a li mgbi ɛsɛ nɛ wuba dafi ani kpaa li mgbi ɛsɛ nɛ ba nɛni. ");
INSERT INTO utr_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Ibɔ mgbi ani li ikyegbɛɛ ni abu kye gbelu ma mi ɛsɛ nɛ ba, kpaa li ikyegbɛɛ ni abu ngyo ma mi abɔ emi obube. ");
INSERT INTO utr_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","A li mgbi ɛsɛ nɛ ba, dafi ani kpaa li mgbi ɛsɛ nɛ ba nɛni. ");
INSERT INTO utr_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Kye ma kyi salu mi otsitsi mgbi abu; elodzɛ mgbi abu li otsitsi. ");
INSERT INTO utr_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Dafi abu dɔ ani esɔ ba ɛsɛ nɛ nɛ, ani kpaa dɔ ma esɔ mi ɛsɛ. ");
INSERT INTO utr_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Mi ikye mgbi ama ani kye ewani kyi salu, adzi ni a kyi salu ma saan.>> ");
INSERT INTO utr_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","<<Ibɔ mgbi ani li ikye ma yuoma ba. Ani bibɔ ikye ama nka wa noyɛyɛ mbi ani mi esɔ mgbi ama ogbɔɔgbɔ kpaa, ");
INSERT INTO utr_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","gbɛɛ ama duu nu ma wa yɛɛ onyi, Otsani, dafi abu dzɛ mbi ani ngwi ani kpaa dzɛ mbi abu nɛni. Ni ama kpaa dzɛ mbi eyi ikye ni ɛsɛ noyɛyɛ gbɛɛ abu dɔ ani esɔ. ");
INSERT INTO utr_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Ani kye okwɔkwɔ ngwi abu kye nu ani ma nu ma wa, ikyegbɛɛ nu ma li onyi, dafi eyi kpaa li onyi nɛni: ");
INSERT INTO utr_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Ani wo mboma abu di wo mbi ani. Ni a gbe ma duu kwakye yɛɛ ondonyi onu ɛsɛ ye gbɛɛ abu dɔ ani esɔ, a di kpa abu itukwu yɛyɛ dafi ani kpa abu itukwu nɛni.>> ");
INSERT INTO utr_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","<<Otsani, ani mina gbɛɛ ama ngwu abu kye nu ani ma nu ma dzɛ yi ani mi imbe ngwi ani dzɛ mani, odi di okwɔkwɔ mgbi ani, okwɔkwɔ ngwi abu kye nu ani ikyesinɛ ani kpa abu itukwu duuse ni abu ta ɛsɛ nani.>> ");
INSERT INTO utr_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","<<Otsani Osaan, dafi ɛsɛ ye abu ba nɛ kpaa, ani ye abu, ma engwafɔ ntonɛ ye dafi abu dɔ ani esɔ. ");
INSERT INTO utr_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Ani teyi kye abu tso ma, dika kiyayi ole kye abu tso ikyegbɛɛ okpitukwu mgbi abu mbi ani no dzɛ mboma ani abuen kpaa dika dzɛ mboma.>> ");
INSERT INTO utr_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Onɔ ngwi iYesu bibɔ ngyɛ nɛ, ongwu yi engwafɔɔn fa ufɛ mgbi iKidrɔn. Mi oyombo na okwɔ ekwɔ dzɛ, a si kaka efu. ");
INSERT INTO utr_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","IJuda, nkyon gya na, ye imbe nani, ikyesinɛ iYesu li teyi kwakye mi imbe na alonɔ yi engwafɔɔn. ");
INSERT INTO utr_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","IJuda si ba okwɔ ekwɔ nani, o gbe obyi oblakwutsɛ mgbi emi iRoma bɛyi ama ongyo ozu okwukwo osunu Imgbasho angbeka nkyɛ mbi engyukwo ama ofifɛ bɛyi emi iFarasi teyi. A gbe ola byi yi okyiika. ");
INSERT INTO utr_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Ngwi iYesu teyi ye alungwɔ nka wa kyɔn nɛ, o tasɛ ka byi ma gbɛɛ, <<Li emɛ ngwi ema le pitan?>> ");
INSERT INTO utr_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","A nu uka gbɛɛ, <<IYesu ongwi iNadzareti.>> IYesu gbɛɛ, <<Li ani ma aani.>> (iJuda ongwu nkyon gya na, kwudzɛ mmana yi ama.) ");
INSERT INTO utr_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Onɔ ngwi iYesu gbɛɛ, <<Li ani ma aani,>> nɛta a yɛyikpa zudɔwokɛ esɛ. ");
INSERT INTO utr_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","O diyɛ byi ma gbɛɛ, <<Li emɛ ngwi ema le pitan?>> A di gbɛɛ, <<IYesu ongwi iNadzareti.>> ");
INSERT INTO utr_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","IYesu gbɛɛ, <<N teyi nya ema gbɛɛ li ani ma aani. Kini ema le pita ani yɔ, ni inggisɛ ntonɛ lu na.>> ");
INSERT INTO utr_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Ungwɔnɛ kyɔ ikyegbɛɛ elodzɛ ngwi o teyi gbɔ ma no mbwumbwo: <<Ani nu onyi kpaa byulu mi ama ngwu abu gbe nu ani ntonɛ ba.>> ");
INSERT INTO utr_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Nɛ iSaimɔn iPyita, ongwu ndzɛ yi okwusunkli na, kye ngwalu kye kwɔdzɛ adɔ abugye mgbi ongbidɔ mgbi okwukwo inggisɛ ofifɛ. (Ongbidɔ na iyin di iMalku.) ");
INSERT INTO utr_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Nghaduu iYesu wo iPyita ola gbɛɛ, <<Yile okwusunkli mgbi abu wokɛ ifwɛ. Nin ka wa ibwɛ ngwi Otsani kye nu ani nɛ baa?>> ");
INSERT INTO utr_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Obyi oblakwutsɛ yi ongyukwo mgbi ama bɛyi ama ongyo ozu okwukwo osunu Imgbasho bwalu iYesu. A bwan adi, ");
INSERT INTO utr_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","si kyon kɛ mbi Anna ababɔ, ongwu li otsowa iKayafa, nli okwukwo inggisɛ ofifɛ mi onova na mani. ");
INSERT INTO utr_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","IKayafa li ongwu teyi wɛ emi iJuda ɛwɛ gbɛɛ i tatase gbɛɛ ni inggisɛ onyi kwulu mi ikye ibyi inggisɛ mani. ");
INSERT INTO utr_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","ISaimɔn iPyita yi ongwafɔ oka kyɛdɔ iYesu. Ikyekyɛ ongwafɔ nɛ okwukwo inggisɛ ofifɛ na yon, nghanɛ o kaka yi iYesu mi idzidzɛ udɛ mgbi okwukwo inggisɛ ofifɛ nani, ");
INSERT INTO utr_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","kpaa iPyita yɔ kwudzɛ onufoka mi esɛ. Ta ongwafɔ oka, ngwu okwukwo inggisɛ ofifɛ yon na, yɛ wa gbɔdzɛ yi ongwongyaa ndzɛ ondu idɔ mi onufoka, man o kye iPyita kaka idzidzɛ. ");
INSERT INTO utr_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Ongwongyaa mi onufɛ na byi iPyita gbɛɛ, <<Abu kpaa li onyi mi engwafɔ mgban lɔ?>> O gbɛɛ, <<Li Ani ba.>> ");
INSERT INTO utr_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Onɔ ma ofu le yi, nɛ engbidɔ bɛyi ama ongyoongyo kwudzɛ kpakɛkɛ wo ola ngwi a kye wo le wɛ mani. IPyita kpaa kwudzɛ le wola yi ama. ");
INSERT INTO utr_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Nghanɛ, okwukwo inggisɛ ofifɛ na byi iYesu ita mi odzɛ mgbi engwafɔɔn bɛyi otsootso mgban. ");
INSERT INTO utr_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","IYesu nu uka gbɛɛ, <<Ani gbɔdzɛ nya ɛsɛ mi ododa, n li tso alonɔ mi ozu okwakye mgbi emi iJuda hona mi ozu okwukwo osunu Imgbasho mi iJerosalin, imbe ngwi emi iJuda duu li kwakye nani. N gbɔdzɛ onyi mi odaada ba. ");
INSERT INTO utr_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Kyɔsinɛse ngwi abu le byi ani ita? Byi ama nfwo ani mani. Otsitsi a ye ungwɔ ngwi ani gbɔ.>> ");
INSERT INTO utr_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Mi onɔ ngwi iYesu gbɔdzɛ nɛ ma, onyi mbi ama ongyoongyo ndzɛ kwɛkwɛ yan ma tan afɛ mi inɛ. O byita gbɛɛ, <<Li ngha ngwi a li nu okwukwo inggisɛ ofifɛ uka daa?>> ");
INSERT INTO utr_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","IYesu gbɛɛ, <<Kini ani gbɔ ungwɔ nli ayin bayɔ, tso ani obwɛndɛ mi ungwɔ nli obube mani. Kpaa kini ani gbɔ otsitsi ma, kyɔnɛ ngwi abu ta ani afɛ?>> ");
INSERT INTO utr_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Nɛta Anna si kyon dɛsɔ, yi adi mi abɔ, lu mbi iKayafa, okwukwo inggisɛ ofifɛ nani. ");
INSERT INTO utr_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Dafi iSaimɔn iPyita ka kwudzɛ le wola nɛ, a di byun gbɛɛ, <<Abu li onyi mi engwafɔɔn wɛ?>> O tangwɛ gbɛɛ, <<Li ani ba.>> ");
INSERT INTO utr_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Nghaduu onyi mbi ama ongyoongyo mgbi okwukwo inggisɛ ofifɛ na, ongwu nli odo yi ongyulɔ ngwu iPyita teyi dzan adɔ na, fwa ikwangha yi iPyita gbɛɛ, <<Ani di abu yi iYesu mi okwɔ baa?>> ");
INSERT INTO utr_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","IPyita di tangwɛ, labɔlabɔ nɛta ogbigbi wita oteela. ");
INSERT INTO utr_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Ta emi iJuda kyelu iYesu mbi iKayafa lu opiikwɔ mgbi iGɔna inggisɛ iRoma. Onɔ na li egbegbe ototu, mi ikye ofwa idza owa ndɛlu ma oga owɛ owatɔ-watɔ mgbi emi iJuda nɛ, emi iJuda fwa okaka udɛ iGɔna. ");
INSERT INTO utr_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","IPlatu tasɛ kɛ mboma ka byita gbɛɛ, <<Li ali itɔdzɛ ngwi ema kye le ba mi ikpewo ongyulɔ nɛ?>> ");
INSERT INTO utr_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","A nu uka gbɛɛ, <<Inggisɛ nɛ ki kyungwɔ obube bayɔ, eyi ki kyon ba mbi abu ba.>> ");
INSERT INTO utr_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","IPlatu gbɔgbɛɛ, <<Nghanɛ kyon abuema ka gbɔn ikwɔ mi ola mgbi ema na.>> Emi iJuda fwa gbɛɛ, <<Ola nu eyi ofɛ ongwɔ inggisɛ ba.>> ");
INSERT INTO utr_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Ungwɔnɛ kyɔ ikyegbɛɛ odzɛ ngwi iYesu teyi gbɔ mi itɔ ikwu ngwi ongwu ka wa kwu ma no mbwumbwo. ");
INSERT INTO utr_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","IPlatu si yɛ kaka ifoozu, kwu iYesu ela ba di byun gbɛɛ, <<Abu li utɔ mgbi emi iJudaa?>> ");
INSERT INTO utr_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","IYesu byun gbɛɛ, <<Li ɛwɛ otsɛɛtsɛ mgbi abu naadi inggisɛ angbeka nya abu odzɛ mi ikye ani?>> ");
INSERT INTO utr_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","IPlatu gbɛɛ, <<Ani li emi iJudaa? Li emidabu yi engyukwo ama ofifɛ mgbi abu kye abu ba mbi ani aani. Li alungwɔ abu kyɔ?>> ");
INSERT INTO utr_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","IYesu gbɛɛ, <<Esutɔ mgbi ani li ongwi ɛsɛ nɛ ba. Ki li ongwi ɛsɛ nɛ yɔ, engbidɔ mgbɛn kika gblika ikye otukwu ofɛ onu emi iJuda bwa ani. Nghaduu esutɔ mgbi ani dzɛ mbeka.>> ");
INSERT INTO utr_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","IPlatu gbɛɛ, <<Ngyɛse, abu li utɔ!>> IYesu nu uka gbɛɛ, <<O gbɔ ayin ogbɛɛ di ani li utɔ. Mi otsitsi yɔ, li itɔdzɛ nɛ ngwi a mba ani, di li itɔdzɛ nɛ ngwi ani ba ɛsɛ nɛni, ikye okyɔ obwɛndɛ mi otsitsi nani. Ali inggisɛ ndzɛ mi agya mgbi otsitsi yɔ li fwo ani.>> ");
INSERT INTO utr_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","IPlatu byita gbɛɛ, <<Li alungwɔ li otsitsi?>> Mi odzɛ nɛ o di tasɛ kɛ mbi emi iJuda ka gbɔgbɛɛ, <<N tun yi obube ba. ");
INSERT INTO utr_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Ema dzɛ yi aletɔ mgbi ema onu ani dulu inggisɛ onyi mi obawi mi onɔ oga owɛ owatɔ-watɔ mgbi emi iJuda nu ema. Ema mina gbɛɛ ni ani dulu utɔ mgbi emi iJudaa?>> ");
INSERT INTO utr_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Nghaduu a wulu ela gbɛɛ, <<Ei, no ka li ongwu ba! Kye iBaraba nu eyi!>> Onɔ na iBaraba wo abɔ mi ablodzɛ. ");
INSERT INTO utr_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Ta iPlatu woola nu ma gbo iYesu onitse. ");
INSERT INTO utr_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Ama oblakwutsɛ ndi akata ato kye tukwun ikye. A kye awulu omuma shinishini kye won ");
INSERT INTO utr_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","diyɛ kɛ mbon dudɔ-dudɔ, gbɛɛ, <<Eyi ta abu angba, utɔ mgbi emi iJuda!>> A dile tukwun afɛ mi inɛ. ");
INSERT INTO utr_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","IPlatu di tasɛ ba esɛ wa gbɔ yi emi iJuda gbɛɛ, <<Dii, ani kyon le ba esɛ mbi ema ni ema ye gbɛɛ ani tun yi obube mi elikwɔ ngwi ema kwun nɛ ba.>> ");
INSERT INTO utr_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Ngwi iYesu tasɛ ba esɛ yi akata ato mi ikye bɛyi awulu omuma shinishini mi ewo nɛ, iPlatu nya ma gbɛɛ, <<Ongyulɔ ma dzɛ na!>> ");
INSERT INTO utr_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Plɛ ngwi engyukwo ama ofifɛ bɛyi ama ongyoongyo mgbi ama din nɛ, a wulu gbɛɛ, <<Gbokwon mi ekwatsi! Gbokwon mi ekwatsi!>> Nghaduu iPlatu gbɛɛ, <<Ema kyon ka gbokwo mi ekwatsi abuema na. Mbi ani yɔ, ani tu itɔdzɛ mi elikwɔ mgban ba.>> ");
INSERT INTO utr_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Emi iJuda biibɛ gbɛɛ, <<Eyi dzɛ yi ola, ma mi ola mgbi eyi mayɔ, o ka kwulu kyɛmɛ, ikyena o kye ewon gbɛɛ ongwu li Ongwɛ Imgbasho.>> ");
INSERT INTO utr_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Ngwi iPlatu fwo ungwɔnɛ nɛ, i nghao kwulun ewo, ");
INSERT INTO utr_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","ta o diyɛ kaka ifyudɛ. O byi iYesu gbɛɛ, <<Abu kyɛ mi ole?>> Nghaduu iYesu kwondu won ba. ");
INSERT INTO utr_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","IPlatu gbɛɛ, <<Abu fwa ogbɔdzɛ yi anii? Abu difwi gbɛɛ ani dzɛ yi mfye odzata abu hona gbokwo abu mi ekwatsi baa?>> ");
INSERT INTO utr_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","IYesu gbɛɛ, <<Abu kika dzɛ yi mfye mi ikye ani ba, ni a ki kye nu abu kyɛ esho bayɔ. Nghaduukpaa ongwu nkye ani nu mi abɔ mgbi ema na, nghao kyɔ obube duu.>> ");
INSERT INTO utr_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Wita mi onɔ na lu iyayi, iPlatu fya odzata iYesu, kpaa emi iJuda kiyayi owulu gbɛɛ, <<Kini abu dzata ongyulɔ nɛ lu yɔ, abu li oka iSidza wuba. Ali inggisɛ nkye ewon gbɛɛ ongwu li utɔ duu kye iga le fyɛsɛ yi iSidza.>> ");
INSERT INTO utr_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Ngwi iPlatu fwo odzɛ nɛ nɛ, o ka kye iYesu luba esɛ man sɔkɛ itse ogbiikwɔ mi imbe ngwi a li kwun di Ikwutsɛ (ngwi a li kwun mi ondudzɛ Aramai gbɛɛ iGabata nani). ");
INSERT INTO utr_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Li mi egbe owewo mgbi oga owɛ owatɔ-watɔ mgbi emi iJuda, di li mi onɔ idzizudɛ. Nɛ iPlatu nya emi iJuda gbɛɛ, <<Utɔ mgbi ema dzana.>> ");
INSERT INTO utr_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Nghaduu a wulu gbɛɛ, <<Kyon lu mmɛnɛni! Kyon lu mmɛnɛni! Gbokwon ngwɔn!>> Ta iPlatu byita gbɛɛ, <<Nin gbokwo utɔ mgbi ema mi ekwatsii?>> Engyukwo ama ofifɛ gbɛɛ, <<Eyi dzɛ yi utɔ oka ba li iSidza yuon.>> ");
INSERT INTO utr_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Mi ongyɛɛngyɛ duu iPlatu kyon nu ma gbɛɛ nu ma ka gbokwon mi ekwatsi. Man ama oblakwutsɛ kye iYesu lu. ");
INSERT INTO utr_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Ngwi o kye ekwatsi mgban nɛ, o lu imbe idingbo (ngwi a li kwun mi ondudzɛ Aramai di iGogota nani). ");
INSERT INTO utr_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Mi imbe nɛ a gbokwon yi inggisɛ efa, oka mi abugye yi oka mi abubɛ, iYesu wo idzidzɛ. ");
INSERT INTO utr_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","IPlatu nu ma lɔ ungwɔ kye bɛkɛ mi ekwatsi. I gbɔgbɛɛ: IYESU ONGWI INADZARETI, UTƆ MGBI EMI IJUDA. ");
INSERT INTO utr_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Emi iJuda kwuba gbɔ ambɛ nɛni, bana imbe ngwi a gbokwo iYesu ma dzɛ kwɛkwɛ yi igeli okwukwo, ambɛ na a lɔn mi ondu Aramai, iLatin yi iGriki. ");
INSERT INTO utr_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Engyukwo ama ofifɛ mgbi emi iJuda fwa yi iPlatu gbɛɛ, <<Ka lɔ gbɛɛ, <Utɔ mgbi emi iJuda ba,> kpaa gbɛɛ ongyulɔ nɛ li kye ewon gbɛɛ ongwu li utɔ mgbi emi iJuda.>> ");
INSERT INTO utr_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","IPlatu gbɛɛ, <<Ungwɔ ngwi ani lɔ yɔ, ani lɔ setawaali.>> ");
INSERT INTO utr_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Onɔ ngwi ama oblakwutsɛ gbokwo iYesu mi ekwatsi ngyɛ nɛ, a kyi gbelu angwuto mgban, kyi ghalu imbe enɛ, onyi mi ikye mgbi ali inggisɛ mgbi ama, i sisi awulu mgban. Angwuto nɛ dzɛ yi okwokyiikwokyi ba, li ungwonyi kyɛ esho lu esɛ. ");
INSERT INTO utr_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Ama oblakwutsɛ ntona gbɔ yi ewoma gbɛɛ, <<Eyi ka fawa angwuto nɛ ba, eyi ka gbo efa mi ele ni eyi ye inggisɛ nka li mgban.>> Ungwɔnɛ kyɔ ikye ombwumbwo ungwɔ ntsekise dzɛ mi Afɛ gbɛɛ, <<A kye ghalu angwuto mgbi ani nu ewoma di gbo efa mi abu mgbi ani.>> Li ungwɔ ngwi ama oblakwutsɛ kyɔ aani. ");
INSERT INTO utr_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Onɔ iYesu kwudzɛ kwɛkwɛ yi ekwatsi mgbi iYesu yi oshanɔn, yi iMeri owa iKlopa, bɛyi iMeri iMagidalin. ");
INSERT INTO utr_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Dafi iYesu di onɔn mi imbe na, yi ongwafɔɔn ngwu kpan itukwu kwudzɛ yan nɛ, iYesu nya onɔn gbɛɛ, <<Ongyaa ongwabu dzana,>> ");
INSERT INTO utr_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","o diyɛ gbɔ yi ongwafɔɔn na gbɛɛ, <<Onabu dzana.>> Wita mi onɔ na nghataa lu iyayi, ongwafɔɔn na kye iMeri lu udɛ mgban. ");
INSERT INTO utr_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Onɔ gwee nɛ, iYesu ye dafi alungwɔ duu ngyɛ, ma ikyegbɛɛ ni ungwɔ ndzɛ mi Afɛ mbwumbwo yɔ, O gbɛɛ, <<ekweni kwin.>> ");
INSERT INTO utr_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Mi imbe na atankpɛ eneekwɔ ofyunfyummya ba dzɛ ele, nghanɛ a kye isoso tswokɛ ele, kye fakɛ anggekwɔ ihiso, kyilen bɛ iYesu kɛ ikpondu. ");
INSERT INTO utr_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Ngwi iYesu wa duu nɛ, o gbɛɛ, <<I ngyɛ wa.>> Ta, o kye onbukwɔ ngwuta si yulu. ");
INSERT INTO utr_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Ungwɔnɛ kyɔ mi obwi, tegblifan li egbe otonyewo mgbi emi iJuda. Ikyegbɛɛ emi iJuda mina gbɛɛ ni ikwɔ ntona fato ekwatsi mi egbe otonyewo ba nɛ, a ka bɔ iPlatu ofɛ gbɛɛ nu ma gbikye ma afɔ di tashulu ikwɔ ntonani. ");
INSERT INTO utr_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Ama oblakwutsɛ ba wa gbikye afɔ efa mgbi inggisɛ ongwu ababɔ ngwu a kyon gbokwo mi ekwatsi yi iYesu dika gbikye mgbi oka nani. ");
INSERT INTO utr_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Nghaduu ngwi a ba mbi iYesu ma, a difwi dafi o teyi kwulu wa nɛ, a gbikyen afɔ wuba. ");
INSERT INTO utr_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Nɛta, inggisɛ oblakwutsɛ oka kye okpa kwo iYesu mi esa, ta eyi yi eni fɛ lon mi esa. ");
INSERT INTO utr_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Inggisɛ ndi ma kyɔ obwɛndɛ, obwɛndɛ mgban li otsitsi. O ye gbɛɛ ongwu gbɔ otsitsi, di kyɔ obwɛndɛ ikyegbɛɛ ni ema kpaa ki noyɛyɛ. ");
INSERT INTO utr_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Ungwɔ ntonɛ kyɔ adzi ni ondu odzɛɛdzɛ ngwi Afɛ dzɛ gbɛɛ <<Akpukpu mgban onyi kpaa a ka gbikyen ba,>> na no mbwumbwo. ");
INSERT INTO utr_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Dafi Afɛ oka di gbɛɛ, <<A ka di ongwu a kwon okpa nani.>> ");
INSERT INTO utr_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Onɔ gwee nɛ, iJose ongwi Arimatia wa bɔ iPlatu ikwɔ mgbi iYesu. IJose kpaa li ongwafɔ mgbi iYesu, o wa bɔ mi odaada ikyekyɛ o le mio emi iJuda. Dafi iPlatu nun ofɛ nɛ, o wa kyi kyelu ikwɔ mgbi iYesu lu. ");
INSERT INTO utr_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","O kyɛ bɛyi iNikodemu, ongyulɔ nteyi kɛ mbi iYesu mi otu nani. INikodemu ba yi ungwɔ ama ogbungbɛ kwuba ngwi a kye bwuo yi ewoma mɛ mlo dafi ngwuseta dɔn iwyo diwyeda sini. ");
INSERT INTO utr_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Ngwi a kyi kyelu ikwɔ mgbi iYesu nɛ, ama efa kye ikwɔ na ndi wokɛ angwuto yi ungwɔ ama ogbungbɛ ntonani. A kyungwɔnɛ dafi emi iJuda li ndzi inggisɛ mi aletɔ mgbi ama mani. ");
INSERT INTO utr_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Imbe ngwi a gbokwo iYesu mi ekwatsi na, li mi okwɔ, di li mi okwɔ na ngwi endzi ofufɛ dzɛ ele, ongwi a ndzi inggisɛ mi ele ye waba. ");
INSERT INTO utr_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Ikyegbɛɛ li egbe owewo mgbi emi iJuda mi ikye egbe otonyewo, endzi di dzɛ kwɛkwɛ nɛ, a kye iYesu ndzi mi ele. ");
INSERT INTO utr_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Egbe Iladi mi egbegbe ototu nɛ, iMeri iMagidalin kɛ endzi ka di dafi ikwutsɛ ngwi a kye tukwu ondendzi na a kye mulu. ");
INSERT INTO utr_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Nɛ o nyɛ yi onya kɛ mbi iSaimɔn iPyita bɛyi ongwafɔ oka, ongwu nkpa iYesu itukwu nani, ka gbɛɛ, <<A kyi dulu Otsɛ iYesu mi endzi, ma eyi ye imbe ngwi a kyon ka lakɛ ba.>> ");
INSERT INTO utr_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Ta iPyita yi ongwafɔ na kyato olu imbe ngwi endzi dzɛ mani. ");
INSERT INTO utr_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Ama efa le lu onyonya, kpaa ongwafɔ oka na tsinya ngha iPyita teyi ka to itendzi ababɔ. ");
INSERT INTO utr_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","O klɛsɛ winɛ mi ifun kpaa li angwuto ngwi a kye ndi wo iYesu mata ladzɛ ele, nghaduu o kaka ifun ba. ");
INSERT INTO utr_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Nɛ iSaimɔn iPyita, ngwu kyan iyikpa ma, wa to si kaka lu ifendzi. O di angwuto ikwɔ ntona lato ifun, ");
INSERT INTO utr_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","bɛyi ayangwuto ngwi a kye bwa iYesu ikye nani. Angwuto na fulu ewon, i lakɛ idzidza yi ongwi a ndzin mi ele mani. ");
INSERT INTO utr_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Ongyɛɛngyɛ yɔ, ongwafɔ oka ongwu nteyi kaka itendzi ababɔ na kpaa, kaka ifun ka di si noyɛyɛ. ");
INSERT INTO utr_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","(Nghaduukpaa i gbosa lo ma mi odzɛ ngwi Afɛ gbɛɛ iYesu ka kyɛɛ mi ikwu na ba.) ");
INSERT INTO utr_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Ta engwafɔ ntona yidɔ lu udɛ mgbi ama, ");
INSERT INTO utr_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","kpaa iMeri yɔ tila dzɛ itendzi le tsukwu. Dafi o le tsukwu nɛ, o klɛsɛ le winɛ mi ifendzi ");
INSERT INTO utr_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","man di engyesɔ nghi efa wo angwuto onzundzɛ, a sɔto imbe ngwi a teyi kye ikwɔ mgbi iYesu la mani, onyi mi ikye oka mi atafɔ. ");
INSERT INTO utr_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","A byun gbɛɛ, <<Ongyaa, li ekyɛ ngwi abu le tsukwu?>> O gbɛɛ, <<A kyi kyelu ikwɔ mgbi Otsɛ iYesu mgbi ani lu, ma ani ye imbe ngwi a kyon ka lakɛ ba.>> ");
INSERT INTO utr_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Ngwi o gbɔdzɛ nɛ mata, o ndinɛ kpatsɛ man o di iYesu kwudzɛ imbe nani, nghaduu o difwi gbɛɛ li iYesu ba. ");
INSERT INTO utr_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","IYesu gbɛɛ, <<Ongyaa, li ekyɛ ngwi abu le tsukwu? Li emɛ ngwu abu le ndinan?>> Ongyaa na tsɛwɛ gbɛɛ o li otsungwɔ okwɔ, o gbɛɛ, <<Ongyukwo, kini abu kyon lu yɔ, nya ani imbe ngwi abu kyon lakɛ mani nin nka kyi kye.>> ");
INSERT INTO utr_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","IYesu gbɛɛ, <<IMeri!>> O kyata inɛ byun man kwu ela okwukwo mi ondu Aramai gbɛɛ, <<IRaboni!>> (Ngwi itan gbɛɛ otsetse). ");
INSERT INTO utr_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","IYesu gbɛɛ, <<Ka tsɛkwulin ba, ikyesinɛ N yidɔ lu mbi Otsɛn waba. Nghaduukpaa lu ka nya emi ongwunani gbɛɛ, <Ani le yidɔ lu mbi Otsani bɛyi Otsema, mbi Imgbasho mgbi Ani yi Imgbasho mgbi ema.> >> ");
INSERT INTO utr_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","IMeri iMagidalin kye esɔ nɛ lu mbi engwafɔɔn gbɛɛ, <<Ani di Otsɛ iYesu!>> O di nya ma gbɛɛ o nya ongwu ungwɔ ntonɛni. ");
INSERT INTO utr_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Mi onɔdɛ mi egbe iLadi na, ngwi engwafɔɔn kwakye yi eka nɛ, a kye ofɛ tukwu bana a le mio emi iJuda, iYesu ba wa kwudzɛkɛ idzidzɛ mgbi ama si gbɛɛ, <<Iyu no dzɛ yi ema!>> ");
INSERT INTO utr_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Ngwi o gbɔ ungwɔnɛ nyɛ nɛ, o gbe abɔ tso ma bɛyi esa. Engwafɔɔn tsatsa kwuba mi onɔ ngwi a di Otsɛ iYesu mani. ");
INSERT INTO utr_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","IYesu di gbɛɛ, <<Iyu non dzɛ yi ema! Dafi Otsani dɔ ani esɔ nɛ, ani kpaa le dɔ ema ngha.>> ");
INSERT INTO utr_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Yi odzɛ na ta, o tufu ma wo si gbɛɛ, <<Gbɛ Onodzi Osaan na. ");
INSERT INTO utr_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Kini ema dzata inggisɛ yi ali ibwubwe mgban yɔ, a dzanta yan, kini ema dzatan bayɔ, a dzanta ba sewaali.>> ");
INSERT INTO utr_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Nghaduu iTɔmɔsu (ongwu a li kwun di ongwefa nani), onyi mbi emi iwyodefa ntona dzɛ yi ama mi onɔ ngwi iYesu ba ma ba. ");
INSERT INTO utr_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Nghanɛ engwafɔ angbeka ntona nyan gbɛɛ, <<Eyi di Otsɛ iYesu!>> Kpaa o nya ma gbɛɛ, <<Li kyɛmɛ ngwi ani ka di emi ambɛ mgbi ikusa mi abɔ mgban di kye ongwufabɔ kɛ imbe a gbokwon ikusa ntona, di kye abɔ mgbi ani kaan esa bayɔ, n ka noyɛyɛ ba.>> ");
INSERT INTO utr_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Ngwi i wa nyɛ egbe egyata nɛ, engwafɔ mgban di woto yi eka, iTɔmɔsu kpaa wodzɛ yi ama. Dafi onufozu tukwu nɛ kpaa, iYesu wa kwudzɛkɛ idzidzɛ ma di gbɛɛ, <<Iyu no dzɛ yi ema!>> ");
INSERT INTO utr_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Ta o nya iTɔmɔsu gbɛɛ, <<Kye ongwufabɔ mgbi abu bɛkɛ mmɛnɛni, di atabɔ mgbi ani. Na abɔ mgbi abu ba esa mgbi ani, ka tangwɛ wuba kpaa noyɛyɛ.>> ");
INSERT INTO utr_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","ITɔmɔsu si kwun gbɛɛ, <<Otsɛ mgbi ani yi Imgbasho mgbi ani!>> ");
INSERT INTO utr_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","IYesu nyan gbɛɛ, <<Ikyegbɛɛ abu di ani nɛ, abu nu ani oyɛyɛ, mse no dzɛ yi inggisɛ ama ndi ani ba kpaa noyɛyɛ mani.>> ");
INSERT INTO utr_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","IYesu kyɔ ambɛ ungwɔ angbeka okwulewo gwuba mi inai engwafɔɔn, ngwi a lɔ ma wo afɛ nɛ ba. ");
INSERT INTO utr_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Kpaa ntonɛ a lɔ ma ikyegbɛɛ ni ema noyɛyɛ gbɛɛ iYesu li iMedzaya, Ongwɛ Imgbasho, di li ikyegbɛɛ ni ema noyɛyɛ mi iyi mgban ta ema ka tu oshishe. ");
INSERT INTO utr_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Ngwi ungwɔnɛ wa nyɛ nɛ, iYesu di tsetu emi ongwafɔɔn, mi ekyoo okwukwo mgbi iTiberia. Li itɔ ofɛ ngwi i kyɔ joani: ");
INSERT INTO utr_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","iSaimɔn iPyita, iTɔmɔsu (ngwi a li kwun di ongwefa nani) iNataniɛ ongwi iKana mi ɛsɛ iGalalia, emi ongwɛ iDzebedi, bɛyi engwafɔ mgbi iYesu angbeka efa kpaa to mbonyi. ");
INSERT INTO utr_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","ISaimɔn iPyita nya ma gbɛɛ, <<Ani le lu mtsɛ ota-ta,>> a gbɛɛ, <<Eyi kpaa ka kɛ yi abu.>> Ta a si tasɛ ka kaka uwaa, kpaa mi otu na duu a kwu unkonyi ba. ");
INSERT INTO utr_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Mi egbegbe ototu nɛ iYesu wa kwudzɛkɛ mi agobo, kpaa emi engwafɔɔn yagba difwi gbɛɛ li iYesu ba. ");
INSERT INTO utr_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","O kwu ma ela kɛ gbɛɛ, <<Emi okani, ema kwu nka wa lo?>> A nun uka gbɛɛ, <<Ei.>> ");
INSERT INTO utr_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","O nya ma gbɛɛ, <<Ngwi Ibriji mgbi ema mi abugye mgbi uwaa ta ema ka kwu ungwɔ.>> Ngwi a kyɔ ngha nɛta, a yagba okwo ukɛ kaka uwaa ba, ikye mmbweni kwuba ngwi a kwu mani. ");
INSERT INTO utr_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Ta ongwafɔ nkpa iYesu itukwu na nya iPyita gbɛɛ, <<Li Otsɛ iYesu!>> Ngwi iSaimɔn iPyita fwo gbɛɛ, <<Li Otsɛ nɛ,>> o kye angwuto mgban ongwi esɛ tukwu (lubana o teyi kye kwulu mi ewo) man ngwa gyɛkɛ eni. ");
INSERT INTO utr_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Engwafɔ angbeka ntona kyɛdɔ mi uwaa, a kwo ukɛ yi mmbwɛ ngwi mbweele ma luba agobo, ikyesinɛ i tunto yi agobo ba, i mɛ dafi akwubɔ ideli onyi hini. ");
INSERT INTO utr_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Ngwi a tɔ lu agobo nɛ, a di ibredi ladzɛ, angola le gbɛ mmbweni di dɔdzɛ ele. ");
INSERT INTO utr_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","IYesu nya ma gbɛɛ, <<Dulu mmbwɛ ngwi ema kwa kwu nɛ ba na.>> ");
INSERT INTO utr_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","ISaimɔn iPyita tɔdɔkɛ uwaa di kye kwolu ukɛ dɔkɛ esɛ. Mmbweni okwukwo mbweele, duu li ideli onyi yi ngwusefa dɔn iwyo diwyeta, ma dafi mmbwɛ ntona le kwuba nɛ kpaa ukɛ fawa ba. ");
INSERT INTO utr_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","IYesu nya ma gbɛɛ, <<Ba wa tiikyɛ na.>> Onyi mi ifu ma kpaa shitukwu byun ita gbɛɛ, <<Abu li emɛ ba>> A ye dafi li Otsɛ iYesu mani. ");
INSERT INTO utr_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","IYesu wa kyelu ibredi ma kye nu ma, di kyɔ ngha yɛyɛ yi mmbweni ma kpaa ");
INSERT INTO utr_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Nɛnɛ li akpe ongwu ta ngwi iYesu mblegba tu emi ongwafɔɔn mi onɔ ngwi o kyɛ mi ikwu aani. ");
INSERT INTO utr_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Onɔ ngwi a gye ungwogye ngyɛ nɛ, iYesu byi iSaimɔn iPyita ita gbɛɛ, <<iSaimɔn ongwɛ iJɔn, otsitsi-otsitsi ani kpa abu itukwu ngha ungwɔ ntonɛɛ?>> O gbɛɛ, <<Ɛɛn, Otsɛ, abu ye dafi abu kpa ani itukwu mani.>> IYesu nyan gbɛɛ, <<Byi mmala mgbi ani enbwa.>> ");
INSERT INTO utr_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","IYesu di byun gbɛɛ, <<ISaimɔn ongwɛ iJɔn, ani kpa abu itukwu otsitsii?>> O nu uka gbɛɛ, <<Ɛɛn, Otsɛ iYesu, abu ye dafi abu kpa ani itukwu mani.>> IYesu nyan gbɛɛ, <<Gbɛwɛbyi mmala mgbi ani.>> ");
INSERT INTO utr_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Akpe ongwu ta o byin gbɛɛ, <<iSaimɔn ongwɛ iJɔn, ani kpa abu itukwuu?>> IPyita wulu itukwu ikyesinɛ iYesu byun akpe ongwu ta gbɛɛ, <<Ani kpa abu itukwuu?>> O gbɛɛ, <<Otsɛ, abu ye alungwɔ duu; abu ye gbɛɛ abu kpa ani itukwu.>> IYesu nyan gbɛɛ, <<Byi mmala mgbi ani enbwa. ");
INSERT INTO utr_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","N nya abu otsitsi, onɔ ngwi abu li mmafa ma, o li gbe angwuto wo ewo di kɛ imbe ngwi abu mina duu, kpaa onɔ ngwi abu yɛɛ ishongye abu ka na abɔ mgbi abu efa, inggisɛ oka ka gbe angwuto wo abu di kye abu kɛ imbe nmina abu okɛɛkɛ ba mani.>> ");
INSERT INTO utr_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","IYesu gbɔ ungwɔnɛ ikye otso itɔ ikwu mgbi iPyita ngwi o ka wa kwu kye okwɔkwɔ nu Imgbasho mani. Ta o nyan gbɛɛ, <<Kyɛdɔ ani!>> ");
INSERT INTO utr_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","IPyita kyata inɛ man di ongwafɔ nkpa iYesu itukwu na kyɛ ma iyikpa. (Li ongwu nsɔ kye ewo ge iYesu mi onɔ ngwi a le gye ungwogye ongwi olɛlɛ di li ongwu teyi byi iYesu gbɛɛ, <<Otsɛ, li emɛ ka kye abu gya?>>) ");
INSERT INTO utr_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Onɔ ngwi iPyita din nɛ, o byi iYesu gbɛɛ, <<Otsɛ, li ekyɛ ngwi inggisɛ nɛ ka kyɔ?>> ");
INSERT INTO utr_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","IYesu nu uka gbɛɛ, <<kini ani mina gbɛɛ no dzɛ oshishe nghataa ni ani wa yɛ ba ma, li ekyɛ mgbi ema mi ele? Abu yɔ kyɛdɔ ani.>> ");
INSERT INTO utr_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Mi ikye odzɛ nɛ, ayayi odzɛ gbɔfwɛ mbi emi ongwunɔn gbɛɛ ongwafɔ nɛ ka kwulu ba. Nghaduu iYesu gbɛɛ o ka kwulu ba ba, o gbɔɔgbɔ ta gbɛɛ, <<Kini ani mina gbɛɛ non dzɛ oshishe nghataa ni ani wa yɛ ma, li ekyɛ mgbi ema mi ele?>> ");
INSERT INTO utr_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Nɛnɛ li ongwafɔ nkyɔ obwɛndɛ mi ungwɔ ntonɛ duu di lɔ ma tokɛ esɛ. Eyi ye dafi obwɛndɛ mgban li otsitsi mani. ");
INSERT INTO utr_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","IYesu kyungwɔ angbeka kpaa kwuba. Ni a ki lɔ alungwɔ duu tokɛ esɛ yɔ, n tsɛwɛ gbɛɛ ɛsɛ duu kpaa imbe kika dzɛ ogbe afɛ ntona tokɛ ba.");
INSERT INTO utr_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Otsungwudɛ iTiofyilɔ, mi olɔɔlɔ mgbi ani ongwi ababɔ ma, n lɔ alungwɔ ngwi iYesu wita okyɔɔkyɔ diyɛ tso ");
INSERT INTO utr_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","nghataa ba egbe ngwi a kyon lu esho, ngwi o wo ama ngwu o sadu ma li ama Ogbikyon ola mi mfye mgbi Onodzi Osaan ngyɛ mani. ");
INSERT INTO utr_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Ngwi o gbiisɔ nyɛ nɛ, o kye ewon tso mbi inggisɛ ntonɛ di nu ma obwɛndɛ kwuba saan gbɛɛ ongwu dzɛ oshishe. O kye ewon tso ma mɛ egbe ngwusefa di gbɔdzɛ esutɔ mgbi Imgbasho nya ma. ");
INSERT INTO utr_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Onoka ngwi o kwakye yi ama, le gye ungwogye yi ama nɛ, o nya ma gbɛɛ: <<Ka tasɛ dzata iJerosalin ba na, kpaa fɛ umba ngwi Otsani zondu, ngwi ema tsekise fwo ani gbɔdzɛ efu nani. ");
INSERT INTO utr_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Bana iJɔn okyɔ iBatisima kyɔ iBatisima yi eni ta, nghaduu egbe sisi gwee ta a ka kyɔ ema iBatisima yi Onodzi Osaan.>> ");
INSERT INTO utr_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Ngwi a ka to yi ewoma nɛ, a byun gbɛɛ, <<Otsɛ, li mi onɔnɛ ngwi abu ka yile esutɔ mgbi emi Israi nu maa?>> ");
INSERT INTO utr_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Nɛ iYesu nya ma gbɛɛ: <<I wogyɔ ngwi ema ka ye egbe yi onɔ ngwi Otsani kye dzɛ mi mfye mgban ba. ");
INSERT INTO utr_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Kpaa ema ka gbɛ mfye mi onɔ ngwi Onodzi Osaan ba mbi ema mani, ta ema ka yɛɛ emi obwɛndɛ mgbi ani mi iJerosalin yi iJudia yi iSamaria nghataa kpatsɛ ɛsɛ duu.>> ");
INSERT INTO utr_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Ngwi iYesu gbɔ ungwɔnɛ ngyɛ nɛta, a kyon mi inai ma lu esho, man akpa tukwu ma inɛ odin. ");
INSERT INTO utr_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","A si kye inɛ fyakwu esho dafi o le lu mani, vla nɛta engyulɔ nghi efa wo angwuto onzundzɛ kwudzɛkɛ kwɛkwɛ yi ama. ");
INSERT INTO utr_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Engyulɔ ntona gbɛɛ, <<Emi iGalalia, li ekyɛ ngwi ema to mmɛnɛ kye inɛ byi esho nghaa? iYesu ngwu a kyon inai ema lu esho nɛ, di li itɔ ofɛ nɛ kpɔɔ ngwi o dika yɛ ba ɛsɛ nɛni.>> ");
INSERT INTO utr_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Ta ama ogbikye iYesu si yidɔ mi iJerosalin mi Unggwɔ Olivi nani, ngwi mɛ dafi itsitsi imai okyɛɛ mi ele ba ogalu iJerosalin. ");
INSERT INTO utr_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Ngwi a wa kaka iJerosalin nɛ, a lu ozeesho mi imbe ngwi a lato mani. Ama nto ma li iPyita, iJɔn, iJɛnsi, Andru, iFyilipi, iTɔmɔsu, iBatlomi, iMatiu, iJɛnsi ongwɛ Alfeɔ yi iSaimɔn ogbodami na bɛyi iJuda ongwɛ iJɛnsi. ");
INSERT INTO utr_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Ama duu kwakye mbonyi le bibɔ alonɔ duu, angbeka nto bɛyi ama li engyaa yi iMeri onɔ iYesu bɛyi emi ongwunɔn. ");
INSERT INTO utr_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Mi egbe ntona iPyita kyato nto mi idzidzɛ mgbi ama onoyɛyɛ ntona (okwakye nmɛ mmbwo dafi ideli onyi dɔn osu sini) ");
INSERT INTO utr_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","si gbɛɛ, <<Emi ongwunani, i wogyɔ ngwi Afɛ ka mbwumbwo mi ungwɔ ngwi Onodzi Osaan tsekise gbɔ tɔ mi ondu iDevedi mi ikpewo iJuda, ongwu nmɛ ofɛ nu ma bwa iYesu nani. ");
INSERT INTO utr_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Ongwu nose li onyi mi atɛ mgbi eyi di kyidɔ nɛ yi eyi kpaa.>> ");
INSERT INTO utr_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(Udza ngwi iJuda tu mi alobube mgban ma, o kye gya ikpɛsɛ, ngwi non kye ewon widɔkwɔ. Ikwɔ mgban mwɛ gbobu ɛfwɛɛ yangwuta. ");
INSERT INTO utr_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Ali inggisɛ mi iJerosalin fwo ungwɔnɛni, nɛ a kwu imbe na mi ondudzɛ mgbi ama di Akedama, ngwi itan gbɛɛ, ikpɛsɛ eyi.) ");
INSERT INTO utr_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","IPyita kiyayi gbɛɛ, <<Bana, a lɔ mi Afɛ mgbi iPaslami gbɛɛ, << <Ni imbe mgban na la ayayi; ni inggisɛ onyi kpaa ka dzɛ ele ba,> << <Ni inggisɛ oka di kyi kyelu imbe idɔ mgban nani.> ");
INSERT INTO utr_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Nghanɛ li kyɛmɛ-kyɛmɛ ngwi eyi ka dulu inggisɛ onyi mbi engyulɔ ama ntonɛ, ongwu nteyi le kyɛ yi eyi alonɔ duu ngwi Otsɛ iYesu ka dzɛ yi eyi mani, ");
INSERT INTO utr_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","eyi mina inggisɛ onyi nka kyɔ obwɛndɛ mgbi iYesu nɛ yi eyi. Ma dika li inggisɛ ndzɛ yi eyi wita mi onɔ ngwi iJɔn kyɔ iYesu iBatisima nghataa ba onɔ ngwi a kyi kyelu iYesu mbi eyi lu esho nani.>> ");
INSERT INTO utr_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Nɛ a si dulu engyulɔ efa ba iyayi: Onyi ma a li kwun di iJɔstusu ngwu iyin oka li iBasaba (iyin oka di li iTɔmɔsu) iyi oka ma li iMataya. ");
INSERT INTO utr_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","A si bibɔ gbɛɛ, <<Otsɛ Imgbasho, abu ye itukwu ali inggisɛ duu. Tso eyi inggisɛ ongwu abu sadu mi idzidzɛ inggisɛ efa ntonɛ ");
INSERT INTO utr_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","ongwu nka kyelu imbe idɔ mgbi ama ogbikye iYesu nɛ, ngwi iJuda dzanta lu imbe ndzɛ mi ikyon mani.>> ");
INSERT INTO utr_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Ta a gbeefa, efa si kwu iMataya; man a kyon mbwokɛ yi iwyodonyi ntonani. ");
INSERT INTO utr_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Ngwi egbe iPɛntikɔsu wa gyɔ nɛ, ama duu kwakye mbonyi. ");
INSERT INTO utr_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Vla nɛta adu kyɛ esho dafi onikyawo wa yaokɛ ozu ngwi a sɔto mani. ");
INSERT INTO utr_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","A di ungwɔ ndzɛ dafi amoola ganya wa dɔkɛ ikye mgbi ama duu. ");
INSERT INTO utr_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Ama duu si mbwo yi Onodzi Osaan man wita le gbɔ ondudzɛ angbeka dafi Onodzi kye ma teyi mani. ");
INSERT INTO utr_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Mi onɔ na, emi iJuda ama ndzɛ yi imio mgbi Imgbasho kyɛ mi ayɛsɛ duu wa kwakye mi iJerosalin. ");
INSERT INTO utr_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Onɔ ngwi a fwo adu nɛ nɛ, ibyi inggisɛ kwakye. Nghaduu i kwulu ma ewo, ikyekyɛ ali inggisɛ fwo ma le gbɔ ondudzɛ mgbi ongwu. ");
INSERT INTO utr_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","I kwulu ma ewo kpakpa, a si byita gbɛɛ, <<Inggisɛ ama nle gbɔdzɛ ntonɛ duu li emi iGalalia baa? ");
INSERT INTO utr_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Ma i kyɔsinɛse ngwi eyi fwo ama duu le gbɔ ondudzɛ mgbi eyi? ");
INSERT INTO utr_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Emi iPatia, iMede yi Elami; iMesopotamia, iJudia bɛyi iKapadosia, iPontu yi Asia, ");
INSERT INTO utr_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","iFrijia yi iPamfyilia, Igyibiti bɛyi ayɛ mgbi iLibyia kwɛkwɛ yi iSereni, ingyoga mgbi iRoma ");
INSERT INTO utr_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","(yi emi iJuda bɛyi ama ngwu kyatitukwu yɛ le sunu Imgbasho mgbi emi iJuda duu), emi iKrete bɛyi emi Arabia, eyi fwo ma le gbɔ ungwɔ okwulewo mgbi Imgbasho mi ondudzɛ mgbi eyi!>> ");
INSERT INTO utr_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","I kwulu ma ewo a di wɛndɛ, a si byi ewoma gbɛɛ, <<Ungwɔnɛ tso sinɛ?>> ");
INSERT INTO utr_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Angbeka gbɔ ibwa nya ama onoyɛyɛ ntona gbɛɛ, <<A wa ɛbyɛ le fya.>> ");
INSERT INTO utr_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Nɛ iPyita kyato dzɛkunto yi iwyodonyi ntonani, kyile ela mgban gbɔdzɛ yi ibyi inggisɛ ntona gbɛɛ: <<Emidani emi iJuda bɛyi ema ama nto iJerosalin duu, detse nin gbɔfwɛ odzɛ nɛ nya ema; gadɔ saan mi odzɛ ngwi ani le nya ema nɛni. ");
INSERT INTO utr_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Inggisɛ ntonɛ le fya ɛbyɛ, dafi ema tsɛwɛ na ba. Kwa li obyi egyanɛ mi egbegbe ta aani! ");
INSERT INTO utr_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Ei, ungwɔnɛ li ungwɔ ngwi oyegbɔ iJowɛ tsekise gbɔn dzɛ esɛ gbɛɛ: ");
INSERT INTO utr_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","<< <Imgbasho gbɛɛ, mi egbe ongwi olɛlɛ, ani ka kye Onodzi mgbi ani yaokɛ mbi ali inggisɛ duu. Engwɛ ema engyulɔ yi engyaa kale yegbɔ, ɛngbɛ mmafa mgbi ema kale di inɛ odiidi, engyukwo mgbi ema kale woowo elela. ");
INSERT INTO utr_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Mbi engbidɔ mgbi ani kpaa, engyulɔ yi engyaa duu, n ka kye Onodzi mgbi ani yaokɛ mboma mi egbe ntonani, man a ka yegbɔ. ");
INSERT INTO utr_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","N ka kyɔ ambɛ okwulewo mi esho mbyoo bɛyi ungwɔ ama okwulewo mi iteesɛ, otso gbɛɛ di ani dzɛ yi mfye. N ka tiika mi ɛsɛ adzi ni inggisɛ ngwɔ ewoma, ola dika gbimbe sɔ yi iwu. ");
INSERT INTO utr_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","A ka kyata onɔ yɛɛ iyifu, di kyata ofyia yɛɛ eyi duuse ni egbe oshewo bɛyi okwɔkwɔ mgbi Otsɛ no ba. ");
INSERT INTO utr_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Nghanɛ ali inggisɛ nkwu mi iyi mgbi Otsɛ duu ka tu owatɔ.> ");
INSERT INTO utr_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","<<Emi Israi, gadɔ mi odzɛ nɛ na; iYesu ongwi iNadzareti nose li inggisɛ ngwu Imgbasho gbela yan di kyɔ ambɛ okwulewo mbi ema nyɛ mbon, dafi ema abuema ye mani. ");
INSERT INTO utr_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Inggisɛ nɛ a kyon wo ema abɔ mi owitukwu mgbi Imgbasho bɛyi oye-ye mgban; ma ema noofɛ ni emi imbali, gbokwon ngwɔn mi ekwatsi. ");
INSERT INTO utr_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Nghaduu Imgbasho kyilon mi ikwu, dulun tɔ mi owulewo mgbi ikwongye, lubana li kyɛmɛ-kyɛmɛ ni ikwongye bwan adi ba. ");
INSERT INTO utr_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","IDevedi gbɔdzɛ mgban gbɛɛ: << <Ani di Otsɛ dzɛ yi ani alonɔ duu. Ikyegbɛɛ o dzɛ abugye mgbi ani nɛ, ani ka teeyi ba. ");
INSERT INTO utr_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Nghanɛ itukwu mgbi ani shɛta idɛ mgbi ani di dzɛ yi atsa; ikpewo mgbi ani kpaa ka dzɛ mi ɛwɛ ogbebyi, ");
INSERT INTO utr_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","lubana abu ka dzita ani mi endzi ba, hona abu ka dzita Ongwabu Osaan no bwa ba. ");
INSERT INTO utr_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Abu nu ani ye ofɛ oshishe; abu ka mbwo ani yi atsa mi ifafɔ mgbi abu.> ");
INSERT INTO utr_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","<<Emi ongwunani, ani ka nya ema yi abɔ otsigɛgɛ gbɛɛ iDevedi nli ikye mgbi ema na kwulu a kyon ndzi, ma endzi mgban dzɛ mmɛnɛ nghataa ba inɛ. ");
INSERT INTO utr_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Kpaa ongwu nose li oyegbɔ di ye dafi Imgbasho zondu yan kpɔklɔɔ gbɛɛ ongwu ka wa kye ongwiba mgban oka sɔkɛ itsuutɔ mgban mani. ");
INSERT INTO utr_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Ngwi iDevedi di ungwɔ ndzɛ iyayi nɛ, o gbɔdzɛ okyɛɛ-kyɛɛ mi ikwu mgbi iMedzaya nani, gbɛɛ a dzanta mi endzi ba, naadi ikwɔ mgban bwa ba. ");
INSERT INTO utr_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Imgbasho teyi kyile iYesu nɛ luba oshishe, ma eyi duu li obwɛndɛ mgbi otsitsi nɛni. ");
INSERT INTO utr_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","A kyilon esho sɔkɛ abugye mgbi Imgbasho, o gbɛ Onodzi Osaan ngwi Otsɔn zondu mani di kye ungwɔ ngwi ema le di diyɛ fwo onɛnɛ nɛ yaokɛ. ");
INSERT INTO utr_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Lubana li iDevedi nose lu esho ba, nghaduu o gbɛɛ, << <Otsɛ Imgbasho gbɔ yi Otsɛ mgbi ani gbɛɛ: <<Sɔkɛ abugye mgbi ani ");
INSERT INTO utr_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","nghatakata ni Ani nu engyikyili mgbi abu yɛɛ itse mgbi abu ogbe afɔ dɔ ele.>> > ");
INSERT INTO utr_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","<<Ikyenghanɛ emi Israi duu nu ma ye ungwɔnɛni: Imgbasho nu iYesu, ngwu ema gbokwon mi ekwatsi nɛ, yɛɛ Otsɛ bɛyi iKrestu.>> ");
INSERT INTO utr_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Ngwi inggisɛ ntonɛ fwo odzɛ nɛ nɛ, eka dzɛ loma ta a byi iPyita bɛyi ama ogbikye iYesu angbeka ntona gbɛɛ, <<Emi ongwuneyi, eyi ka kyɔsinɛ?>> ");
INSERT INTO utr_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","IPyita nu uka gbɛɛ, <<Kyatitukwu nu ma kyɔ ema iBatisima, mi iyi mgbi iYesu iKrestu mi ikye odzita ema yi ali ibwubwe. Ta ema ka gbɛ umba mgbi Onodzi Osaan. ");
INSERT INTO utr_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Ondu odzɛɛdzɛ nɛ dzɛ ikye ema yi emi ongwɛ ema bɛyi ama nto mbombo ikye ama ngwu Otsɛ Imgbasho mgbi eyi ka kwu ma ela duu mani.>> ");
INSERT INTO utr_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","O di kwo ma adɔ yi elodzɛ angbeka kwuba; di tɛkyɛ nu ma gbɛɛ, <<Dulu ewema tasɛ mi ungwɔ nka wa kyɔ etɔ obube nɛni.>> ");
INSERT INTO utr_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Ama ngbɛ esɔ mgban ma a kyɔ ma iBatisima, i mɛ inggisɛ idubu eta mbwokɛ mbwo mgbi ama mi egbe nani. ");
INSERT INTO utr_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","A kye ewoma tswokɛ mi otsootso mgbi ama ogbikye iYesu bɛyi okwakye, ungwogye ogyeegye yi ewoma, ibredi oghaagha bɛyi ibɔ obɔɔbɔ. ");
INSERT INTO utr_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","I kwulu ali inggisɛ duu ewo, ama ogbikye iYesu ntona di kyɔ ambɛ ama okwulewo gwuba. ");
INSERT INTO utr_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Ama onoyɛyɛ duu to yi eka di li kyɔ alungwɔ duu ungwonyi. ");
INSERT INTO utr_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","A kye ungwɔ ngwi ama dzɛyan bɛyi okye duu gya, di gha nu ali inggisɛ duu dafi okakewo mgbi otsungwɔn dzɛ mani. ");
INSERT INTO utr_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Alegbe a li kiyayi okwakye yi ewoma mi ifyudɛ ozu okwukwo osunu Imgbasho mi iJerosalin. A li gha ibredi mi udɛ mgbi ama di li gye yi ewoma mi atsa yi itukwu onyi, ");
INSERT INTO utr_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","le tsɛ Imgbasho dile tu mgbede mbi inggisɛ duu. Nɛ Otsɛ Imgbasho sile mbwo ama ngwu o dulu ma watɔ ma mmbwo alegbe-alegbe. ");
INSERT INTO utr_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Egbe oka nɛ iPyita bɛyi iJɔn le kɛ ozu okwukwo osunu Imgbasho mi iJerosalin mi onɔ ibɔ mi obyi eta ngwi onɔ tashulu akpa. ");
INSERT INTO utr_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Onɔ na inggisɛ oka ngwu gbikye tukwu esɛ kyɛ ifu, a li kyon ka sɔkɛ onufozu ozu okwukwo osunu Imgbasho mi iJerosalin ngwi a li kwun di osunse nani, le bɔ inggisɛ ama nle kaka ozu ungwɔ alegbe-alegbe. ");
INSERT INTO utr_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Onɔ ngwi o di iPyita yi iJɔn le kaka nɛ, o bɔ ma awuya. ");
INSERT INTO utr_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","IPyita yi iJɔn kye inɛ byun yɛyɛ. IPyita si gbɛɛ <<Kye inɛ byi eyi!>> ");
INSERT INTO utr_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Inggisɛ na si kye itukwu byikɛ mboma, le tsɛwɛ gbɛɛ ongwu ka tu ungwɔ mboma. ");
INSERT INTO utr_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Man iPyita gbɛɛ, <<N dzɛ yi iyudza onzundzɛ yi Abashi ba, kpaa ungwɔ ngwi ani dzɛyan ma, n ka kye nu abu. Mi iyi mgbi iYesu iKrestu ongwi iNadzareti kyato kyikyɛ.>> ");
INSERT INTO utr_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Ngwi o byin mi abugye nɛ, o yan abɔ non kyato, labɔlabɔ nɛta afɔ mgbi inggisɛ na si fyumfye. ");
INSERT INTO utr_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","O ta yile afɔ dzɛkɛ esɛ man wita okyikyɛ. Nɛ o si lu yi ama mi ifyudɛ ozu okwukwo osunu Imgbasho mi iJerosalin, le kyikyɛ tablika dile tsɛ Imgbasho. ");
INSERT INTO utr_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Ngwi inggisɛ duu din le kyikyɛ dile tsɛ Imgbasho nɛ, ");
INSERT INTO utr_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","a difwin dafi ka li inggisɛ nli sɔ le bibɔ mi onufozu ozu okwukwo osunu Imgbasho mi iJerosalin ngwi a li kwun di osunse nani, ta i kwulu ma ewo kpakpa mi ungwɔ nkyɔ yan mani. ");
INSERT INTO utr_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Ngwi inggisɛ obɔ ungwɔ yɛ wa bɛkɛ yi iPyita yi iJɔn nɛ i kwulu inggisɛ ntona duu ewo ta a ba onyonya wa tu ma mi imbe ngwi a li kwun di iwulu onufɛ mgbi iSolomu nani. ");
INSERT INTO utr_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Ngwi iPyita di nghanɛ, o nya ma gbɛɛ: <<Emi Israi, kyɔsinɛ ngwi ungwɔnɛ le kwulu ema ewo? Kyɔsinɛ ngwi ema le di eyi inɛ dafi li mfye naadi osaan mgbi eyi ngwi eyi nu inggisɛ nɛ kyikyɛ? ");
INSERT INTO utr_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Imgbasho mgbi Abrahan, Adziki bɛyi iJeko; Imgbasho mgbi emi otseyi, kye okwɔkwɔ nu ongbidɔ mgban iYesu. Ema kyon nu gbɛɛ nu ma ngwɔn, di tangwan mi inai iPlatu, bana o mina odzanta non lu. ");
INSERT INTO utr_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Ema tangwɛ Ongwu nle Saan dile Nyaan nani, di mina gbɛɛ a ki dulu inggisɛ ongwɔ inggisɛ nu ema. ");
INSERT INTO utr_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Ema ngwɔ otsungwɔ oshishe, nghaduu Imgbasho kyilon mi ikwu. Eyi li obwɛndɛ mi ungwɔnɛni. ");
INSERT INTO utr_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Li oyɛyɛ onuunu mi iyi mgbi iYesu ngwi inggisɛ ema di, di yon nɛ yɛɛ saan aani. Li iyi mgbi iYesu bɛyi oyɛyɛ onuunu nkyɛ mbon ma nu ootse ngyɛ lo inggisɛ nɛ saan, ngwi ema di nɛni. ");
INSERT INTO utr_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","<<Onɛnɛ, emi ongwunani, ani ye ta gbɛɛ ema kyungwɔnɛ mi inɛ obuubu, dafi ama okye ema teyi kpaa tsekise kyɔ mani. ");
INSERT INTO utr_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Nghaduu li itɔ ofɛ ngwi Imgbasho mbwumbwo ungwɔ ngwi ongwu tsekise gbɔn nyɛ mbi ama ogbɛɛsɛ aali, gbɛɛ iMedzaya mgbi ongwu ka wa gyadzɛ. ");
INSERT INTO utr_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Kyatitukwu yidɔ luba mbi Imgbasho na, adzi ni Otsɛ dzɛ ema ta yi ali ibwubwe mgbi ema, onɔ onya otooto ka kyɛ mbi Otsɛ, ");
INSERT INTO utr_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","onɔ di kyɛma ngwi Otsɛ ka nu ema mfye ofufɛ. O ka kye iYesu dɛsɔ nu ema, iMedzaya mgban ngwu o dulu-dulu nani. ");
INSERT INTO utr_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Li kyɛmɛ ngwi o ka tila dzɛ esho nghataa ngwi onɔ ka gyɔ ngwi Imgbasho ka yile alungwɔ duu sisɛ, dafi o zondu gbegbe nyɛ mbi oyegbɔ mgban ama osaan mani. ");
INSERT INTO utr_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Ikyesinɛ iMose gbɛɛ, <Otsɛ Imgbasho mgbi ema ka dulu oyegbɔ dafi ani mi idzidzɛ ema nu ema; li kyɛmɛ ema ka gadɔ mi alungwɔ ngwi o nya ema duu. ");
INSERT INTO utr_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Ali inggisɛ ngwu gadɔ fwon ba duu a ka dulun mbi engwɛ Imgbasho dzɛkɛ enggengga.> ");
INSERT INTO utr_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","<<Mi otsitsi ama ogbɛɛsɛ wita mbi iSamue lu mbi angbeka duu, teyi gbɔdzɛ ungwɔ ama ntole kyɔ mi ɛsɛ ongwi onɛnɛ nɛni. ");
INSERT INTO utr_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Nghanɛ ema li ama gyokwudɛ mgbi ama ogbɛɛsɛ bɛyi ondu odzɛɛdzɛ ngwi Imgbasho dzɛ yi otsema mani. O nya Abrahan gbɛɛ, <Ikpewo etɔ mgbi abu inggisɛ mi ɛsɛ duu ka tu mse.> ");
INSERT INTO utr_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Onɔ ngwi Imgbasho dulu ongbidɔ mgban ma, o kyon dɛsɔ mbi ema ababɔ ikye okye mse bɛ ema ewo mi okyata ema mi imbali mgbi ema.>> ");
INSERT INTO utr_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Ama ofifɛ mgbi Imgbasho yi inggisɛ ogbe obaka ama ongyo ozu okwukwo osunu Imgbasho mi iJerosalin teyi bɛyi emi iSadusi ba mbi iPyita yi iJɔn mi onɔ ngwi a kale gbɔdzɛ yi inggisɛ ntona mani. ");
INSERT INTO utr_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","I kaka ma ewo kpakpa ikyekyɛ ama ogbikye iYesu le tso inggisɛ ntona dile gbɔ okyɛɛ-kyɛɛ mi ikwu mgbi iYesu kpaa. ");
INSERT INTO utr_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","A bwa iPyita yi iJɔn, ma ikyegbɛɛ onɔ gbɛsɛ nɛ, a kye ma wokɛ obawi nghataa egbe fa. ");
INSERT INTO utr_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Nghaduu ibyi inggisɛ ama nfwo esɔ na duu noyɛyɛ, nɛ mmbwo mgbi ama okyɛdɔ iYesu si she mɛ dafi idubu eda sini. ");
INSERT INTO utr_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Tegblifan nɛ, ama ogbe inggisɛ teyi, engyukwo bɛyi etsetse mgbi ola mgbi iMose kwakye mi iJerosalin. ");
INSERT INTO utr_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Anna okwukwo inggisɛ ofifɛ na dzɛ mmanani, yi iKayafa, iJɔn, Alekidzanda bɛyi inggisɛ angbeka mi etɔ mgbi okwukwo inggisɛ ofifɛ nani. ");
INSERT INTO utr_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","A nu ma kye iPyita bɛyi iJɔn ba inai ma, si wita obyi ma gbɛɛ: <<Li mi ali mfye naadi ali iyi ngwi ema le kyungwɔnɛ?>> ");
INSERT INTO utr_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Nɛ iPyita, ngwu Onodzi Osaan shewo mbon na, nya ma gbɛɛ: <<Ema ama oteyi bɛyi engyukwo mgbi inggisɛ ntonɛnɛ! ");
INSERT INTO utr_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Yeba ni a kwu eyi ela gbɛɛ ni eyi nu uka mi ikye ali osuse ngwi eyi kyɔ yi inggisɛ ngwu gbikye tukwu esɛ nɛ, di byita dafi a kyilon yɔ, ");
INSERT INTO utr_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","ngyɛse ye odzɛ nɛ na, ema yi emi Israi duu: Li mi iyi mgbi iYesu iKrestu ongwi iNadzareti, ongwu ema kyon gbokwo ekwatsi kpaa ngwu Imgbasho kyilon mi ikwu na, ngwi ootse mgbi inggisɛ nɛ ngyɛ ngwi o kwuzunto mi inai ema aani. ");
INSERT INTO utr_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","O li << <Ikwutsɛ ngwi ema ama ombɛ ozu fwan, ngwi i wa yɛɛ ikwutsɛ okwulu ikye ozu mani.> ");
INSERT INTO utr_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Owatɔ dzɛ mbi inggisɛ oka ba, ikyesinɛ iyi oka dzɛma mi ɛsɛ nɛ ngwi a kye nu gbɛɛ inggisɛ ka watɔ kyɛmɛ ba.>> ");
INSERT INTO utr_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Ngwi okwakye di abɔ otsigɛgɛ mgbi iPyita bɛyi iJɔn di difwi gbɛɛ a kpayi afɛ ba, a li inggisɛ ama n ye unka ba nɛ, i kwulu ma ewo man a kwambɛ gbɛɛ inggisɛ ntonɛ nose dzɛ yi iYesu. ");
INSERT INTO utr_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Nghaduu ngwi a di inggisɛ ongwu a ngyɛlun ootse na kwudzɛ yi ama nɛ, odzɛ onyi kpaa dzɛma ngwi a ka gbɔ ba. ");
INSERT INTO utr_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Nghanɛ a nya ma gbɛɛ nu ma dzata okwakye, ta a si wita okponya yi ewoma. ");
INSERT INTO utr_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","A byita gbɛɛ, <<Li alungwɔ ngwi eyi ka kyɔ yi engyulɔ ntonɛ?>> <<Bana ali inggisɛ ndzɛ iJerosalin duu ye gbɛɛ a kyungwɔ okwulewo okwukwo, ma eyi ka tangwan gbɛ ba. ");
INSERT INTO utr_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Kpaa onu ungwɔnɛ kwulɛsɛ mi ogbɔfwɛ kiyayi mi idzidzɛ inggisɛ yɔ, eyi ka wo inggisɛ ntonɛ ola kyɛmɛ gbɛɛ, nu ma ka gbɔdzɛ yi inggisɛ onyi kpaa mi iyi nɛ wuba.>> ");
INSERT INTO utr_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Nɛ a di kwu ma ela ba ifun si wo ma ola gbɛɛ, nu ma ka gbɔdzɛ hona tsungwɔ mi iyi mgbi iYesu wuba du. ");
INSERT INTO utr_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Nghaduu iPyita yi iJɔn nu uka gbɛɛ, <<Tsɛwɛ abuema na ni i tishi mi inɛ Imgbasho gbɛɛ ni eyi fwo ema dzata Imgbasho yɔ. ");
INSERT INTO utr_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Lubana eyi ka yagba sɔ shili mi ungwɔ ngwi eyi di diyɛ fwo gbɛ ba.>> ");
INSERT INTO utr_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Ngwi a di wo ma ola yɛɛyɛ nɛ, a nu ma lu. A yagba ye dafi ama ka kwo ma adɔ ba, ikyekyɛ ali inggisɛ duu le tsɛ Imgbasho mi ungwɔ nkyɔ nyɛ nani. ");
INSERT INTO utr_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Ikyesinɛ inggisɛ ngwu a ngyɛlun ootse kwulewo na, ngha onova ngwusefa wa. ");
INSERT INTO utr_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Ngwi a dzɛ ma ta ma; iPyita yi iJɔn yidɔ lu mbi emidama ka nya ma alungwɔ ngwi engyukwo ama ofifɛ yi emi obɔtsɛ gbɔ yi ama mani. ");
INSERT INTO utr_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Onɔ ngwi a fwo odzɛ nɛ nɛ, a kyile ela mgbi ama esho yi eka mi ibɔ mbi Imgbasho. A gbɛɛ <<Otsɛ Imgbasho onghaangha, abu ta esho yi esɛ yi ekyoo okwukwo, yi alungwɔ nto efu duu. ");
INSERT INTO utr_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Abu gbɔdzɛ mi Onodzi Osaan nyɛ ondu mgbi ongbidɔ mgbi abu, otseyi iDevedi gbɛɛ: << <Kyɔnɛ ngwi Udzengye le kyitingga ngwi inggisɛ dile tsɛwodzɛ ikwangha? ");
INSERT INTO utr_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Utɔ ongwi ɛsɛ nɛ li tsɛwɛ ika man ama ogbe inggisɛ teyi li kwakye yi eka kye afɔ twɛsɛ yi Otsɛ Imgbasho bɛyi iMedzaya mgban kpaa.> ");
INSERT INTO utr_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Mi otsitsi yɔ, iHerude yi iPontu iPlatu kye ewoma kwakye yi Udzengye bɛyi emi Israi mi ogalu nɛni ikye okye afɔ twɛsɛ yi ongbidɔ mgbi abu osaan iYesu, ongwu abu kye engyie kyun ikye nani. ");
INSERT INTO utr_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","A kyungwɔ ngwi mfye yi oweka mgbi abu teyi kye bwalu dzɛ esɛ gbɛɛ ka kyɔ mani. ");
INSERT INTO utr_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Ngwi i dzɛ nghanɛ Otsɛ Imgbasho, di mi ega odzɛɛdzɛ mgbi ama di tobyi engbidɔ mgbi abu nu ma gbeesɔ mgbi abu yi abɔ otsigɛgɛ. ");
INSERT INTO utr_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Na abɔ mgbi abu ikye ongyɛlu ootse di kyɔ ambɛ ama okwulewo yi ungwɔ okwulewo mi iyi mgbi ongbidɔ mgbi abu osaan iYesu.>> ");
INSERT INTO utr_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Ngwi a bibɔ ngyɛ nɛ, imbe ngwi a kwakye ma suusu. Ta ama duu a mbwo ma yi Onodzi Osaan man a si gbeesɔ Imgbasho yi abɔ otsigɛgɛ. ");
INSERT INTO utr_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Ama onoyɛyɛ ntona duu dzɛ yi itukwu onyi. Onyi mboma kpaa li tso gbɛɛ ungwɔ ngwi ongwu dzɛyan li mgbi ongwu ba, kpaa a li kye ghalu alungwɔ ngwi a dzɛyan duu. ");
INSERT INTO utr_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Yi mfye okwulewo ama ogbikye iYesu ntona kiyayi okyɔ obwɛndɛ mi okyɛɛ-kyɛɛ mgbi Otsɛ iYesu mi ikwu, elela mgbi Imgbasho di dzɛ yi ama kpakpa. ");
INSERT INTO utr_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Ungwɔ kwo inggisɛ onyi kpaa oba mi idzidzɛ ma ba. Ikyesinɛ alonɔ duu ama ndzɛ yi ikpɛsɛ naadi ozu li kye gya, kye awuya ngwi a kye gya ma ba ");
INSERT INTO utr_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","wa nu ama ogbikye iYesu, ta a li gha nu ali inggisɛ dafi imina mgbi otsungwɔn dzɛ mani. ");
INSERT INTO utr_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","IJose, inggisɛ iLevi kyɛ mi iSapru, ongwu ama ogbikye iYesu kwun di iBanabasi (ngwi itan gbɛɛ ongwɛ onu itukwu ofyumfye-fyumfye), ");
INSERT INTO utr_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","kye ikpɛsɛ mgban gya kyelu awuya ma ba wa lakiyayi ama ogbikye iYesu. ");
INSERT INTO utr_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Nɛ inggisɛ ngwu iyin di Anania, bɛyi owan iSafira, kpaa kye ikpɛsɛ gya. ");
INSERT INTO utr_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Yi oye-ye mgbi owan saan o kye mwalu awuya na da ikye ewon, man kye ongwi nsisi ma ba wa lakiyayi mgbi ama ogbikye iYesu. ");
INSERT INTO utr_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","IPyita si gbɛɛ, <<Anania, kyɔsinɛ ngwi iSatan gbɛ abu itukwu sɔ nghaa, ngwi abu mwonya nya Onodzi Osaan di kye mwalu awuya ngwi abu kye ikpɛsɛ gya kye dzɛ ewabu kɛ? ");
INSERT INTO utr_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","I plɛ li mgbi abu duuse abu kye gya lo? Ma ngwi abu kye gya ma, awuya ma li mgbi abu baa? Li alungwɔ nu abu tsɛwɛ okyɔ itɔ ungwɔnɛ? Li inggisɛ ngwu abu mwonya nya ba, kpaa li Imgbasho.>> ");
INSERT INTO utr_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Ngwi Anania fwo odzɛ nɛ mata, o si gbɛsɛ kwulu. Nɛ imio wo ali inggisɛ nfwo ungwɔ nkyɔ na duu. ");
INSERT INTO utr_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Nɛta ɛngbɛ mmafa tɔ ba wa kye ikwɔ mgban ndi wokɛ angwuto, kyon lu ka ndzi. ");
INSERT INTO utr_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","I nyɛ obyi eta man owan wa kaka, o ye ungwɔ nkyɔ waba. ");
INSERT INTO utr_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","IPyita byun gbɛɛ, <<Nya ani, li mmya ngwi abu yi Anania tu mi ikpɛsɛ na dɛɛn?>> O gbɛɛ, <<Ɛɛn, li mmya ma aani.>> ");
INSERT INTO utr_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","IPyita nyan gbɛɛ, <<Kyɔsinɛse ngwi ema bwondu ombadi Onodzi mgbi Otsɛ Imgbasho? Di! Atafɔ mgbi inggisɛ ama nkye obabu ndzi to onufɛ aali, ma a dika kye abu kpaa tasɛ.>> ");
INSERT INTO utr_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Mi onɔ na mata o gbɛsɛ lakiyayi mgbi iPyita si kwulu. Nɛ ɛngbɛ mmafa ntona kaka ifun, ngwi a di gbɛɛ o kwulu nɛ, a kyon tasɛ lu ka ndzi mi ewo endzi mgbi oban. ");
INSERT INTO utr_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Imio wo emi iKrestu kpakpa bɛyi ama nfwo ungwɔ nkyɔ na duu. ");
INSERT INTO utr_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Ama ogbikye iYesu kyɔ ambɛ ama okwulewo ibyibyi yi ungwɔ ama okwulewo mi idzidzɛ inggisɛ ntonani. Ma ama onoyɛyɛ ntona duu li kwakye yi ewoma mi iwulu onufɛ mgbi iSolomu. ");
INSERT INTO utr_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Dafi inggisɛ kye ma wuuta kpakpa nɛ kpaa, inggisɛ onyi li boofɛ ka kwakye yi ama ba. ");
INSERT INTO utr_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Nghaduu, engyulɔ yi engyaa kwuba noyɛyɛ mbi Otsɛ di mbwo ma mmbwo. ");
INSERT INTO utr_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Ikyenghanɛ, inggisɛ kye ama ndotse ba ondoofɛ wa lakɛ akwulo yi obutu gbɛɛ ni i ndɛndɛ kpaa onodzi mgbi iPyita no gbo tukwu angbeka mi ele mi onɔ ngwi o le nyɛ mani. ");
INSERT INTO utr_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","A gbe ibyi inggisɛ kyɛ igeli ama nto kwɛkwɛ wa kwakye mi iJerosalin, ama ndotse yi ama ngwu onodzi ibwubwe ngwunu ma, a si ngyɛlu ama duu ootse. ");
INSERT INTO utr_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Nɛ okwukwo inggisɛ ofifɛ bɛyi ama okyɛdɔn duu, ama nto mi ayɛ mgbi iSadusi ma, yɛɛ okyɔ ama ogbikye iYesu uwaba. ");
INSERT INTO utr_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","A bwa ama ogbikye iYesu ntona gbe ma wokɛ obawi ndzɛ ikye ali inggisɛ duu mani. ");
INSERT INTO utr_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Nghaduu, mi otu ma ongyesɔ mgbi Otsɛ kyi kwulu onufɛ obawi gbe ma tasɛ. ");
INSERT INTO utr_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","O gbɛɛ, <<Lu na, ka kwudzɛkɛ mi ifyudɛ ozu okwukwo osunu Imgbasho mi iJerosalin, di nya inggisɛ ntona esɔ mgbi oshishe ofufɛ nɛ yɛɛyɛ.>> ");
INSERT INTO utr_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Ngwi egbe fa nɛ, a kaka imbe okwakye mi ozu okwukwo osunu Imgbasho mi iJerosalin, dafi a plɛ nya ma mani, si wita otso inggisɛ ntonani. Onɔ ngwi okwukwo inggisɛ ofifɛ yi ama okyɛdɔn wa to nɛ, a kwu ewoma ela okwakye bɛyi engyukwo emi Israi duu. Ta a dɛsɔ kɛ obawi gbɛɛ nu ma kye ama ogbikye iYesu ntona wa nu ma. ");
INSERT INTO utr_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Nghaduu ngwi a ka to obawi nɛ, emi idɔ ntona di ma mmana ba. Nɛ a yidɔ ka nya ma gbɛɛ, ");
INSERT INTO utr_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","<<Eyi kɛ ka di obawi tukwu saan, yi ama ongyoongyo kwudzɛ to onufɛ; kpaa ngwi eyi kwulu onufɛ nɛ, eyi di inggisɛ onyi mi ifun ba.>> ");
INSERT INTO utr_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Ngwi ongyukwo obaka mi ozu okwukwo osunu Imgbasho mi iJerosalin bɛyi engyukwo ama ofifɛ fwo esɔ nɛ ma i wo ma ɛndɛ, a le tsɛwɛ ungwɔ nkiyayi mani. ");
INSERT INTO utr_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Nɛ inggisɛ oka si ba wa gbɛɛ, <<Dika! Engyulɔ ngwu ema gbe ma wo obawi ntona, to ifyudɛ ozu okwukwo osunu Imgbasho mi iJerosalin le tsungwɔ ma.>> ");
INSERT INTO utr_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Mi odzɛ na na, inggisɛ ogbe ama ongyo obawi teyi kɛ yi emi idɔ mgban ka kye ama ogbikye iYesu ntona luba. A kyɔ mi mfye ba, ikyekyɛ a mio gbɛɛ inggisɛ ntona wa tsɛ ama akwutsɛ. ");
INSERT INTO utr_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Ngwi a kye ama ogbikye iYesu ba nɛ, a nu ma ba inai okwakye adzi nii okwukwo inggisɛ ofifɛ byi ma ita. ");
INSERT INTO utr_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","O gbɛɛ, <<Eyi wo ema ola kpɔklɔɔ gbɛɛ ni ema ka tsungwɔ mi iyi nɛ ba. Nghaduu ema gbɔfwɛ otsootso mgbi ema mi iJerosalin wa, di mina onu eyi gye obube mi eyi mgbi inggisɛ nɛni.>> ");
INSERT INTO utr_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","IPyita yi ama ogbikye iYesu angbeka ntona nu uka gbɛɛ: <<Li Imgbasho ngwu eyi ka kyɔ ola mgban kyɛmɛ aali li inggisɛ ba! ");
INSERT INTO utr_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Imgbasho mgbi emi otseyi kyile iYesu mi ikwu, ongwu ema ngwɔn mi okyon gbokwo ekwatsi nani. ");
INSERT INTO utr_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Imgbasho kyilon esho kyon dzɛkɛ abugye mgbi ongwu dafi Ongwuutɔ yi Onagbɛ mani, adzi non nu okyatitukwu bɛyi odzita inggisɛ yi ali ibwubwe mbi emi Israi. ");
INSERT INTO utr_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Eyi li obwɛndɛ mgbi ungwɔ ntonɛni, bɛyi Onodzi Osaan ongwu Imgbasho kye nu ama osunun na kpaa.>> ");
INSERT INTO utr_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Onɔ ngwi emi okwakye ntonɛ fwo odzɛ nɛ ma, itukwu fu loma kpakpa a di mina okye ngwɔlu ma. ");
INSERT INTO utr_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Nghaduu inggisɛ iFarasi ngwu a li kwun gbɛɛ iGamalie, otsetse mgbi ola mgbi iMose, ongwu inggisɛ ntona tsatsadu nun mmwɛ, kyato mi okwakye noola gbɛɛ ni a kye ama ogbikye iYesu ntona tokɛ esɛ mi onɔ gwee se. ");
INSERT INTO utr_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Nɛ o si gbɔdzɛ yi ama gbɛɛ: <<Ema emi Israi, kyɔ dumɔɔ mi ungwɔ ngwi ema tsɛwɛ okyɔ yi engyulɔ ntonɛ nɛni. ");
INSERT INTO utr_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Ongwɛ onɔ ngwi nyɛ ma iTeuda tɔ, le tso gbɛɛ ongwu li ungwɔ, nɛ inggisɛ mɛ ideli enɛ kyɛdɔn. A ngwɔn, ama okyɛdɔn duu ganya, ta alungwɔ duu yɛɛ mnana. ");
INSERT INTO utr_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Ongwu nyɛ, iJuda ongwi iGalalia tɔ mi egbe olɔ umbwo man inggisɛ ibyibyi di kyɛdɔn. Ongwu kpaa a ngwɔn, ta ama okyɛdɔn duu ganya. ");
INSERT INTO utr_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Inghawanɛ, mi odzɛ nɛ, ani le wɛ ema odzɛ gbɛɛ: dzata engyulɔ ntonɛ nu ma lu! Ikyesinɛ ni itɔdzɛ hona okyɔɔkyɔ mgbi ama tiita mbi inggisɛ owamyɛ yɔ, ka dondu. ");
INSERT INTO utr_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Kpaa ni i kyɛ mbi Imgbasho yɔ, ema ka yagba ngha ma ba; ema ka di ewema kye afɔ twɛsɛ yi Imgbasho ta.>> ");
INSERT INTO utr_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","A si gbɛ elodzɛ mgban, ta a kwu ama ogbikye iYesu ela si gbo ma ibe. Man wo ma ola gbɛɛ, nu ma ka gbɔdzɛ mi iyi mgbi iYesu wuba, si nu ma lu. ");
INSERT INTO utr_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Ama ogbikye iYesu ntona dzita okwakye, le tsatsa ikyekyɛ Imgbasho kye ama wuuta dafi ama gyadzɛ tu ayiwi mi ikye iyi mgbi iYesu mani. ");
INSERT INTO utr_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Alegbe-alegbe, mi okwakye mi ozu okwukwo osunu Imgbasho mi iJerosalin bɛyi udɛ udɛ, a yama nya ole tso dile gbɔ Esɔ Osuse gbɛɛ iYesu li iMedzaya ba. ");
INSERT INTO utr_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Mi onɔ ngwi engwafɔ mgbi iYesu wale mbwo kpakpa nɛ, emi iJuda ama ogbɔ ondu iGriki le kwondukwɔ ikye ama ogbɔ ondu iHibru ikyekyɛ a kye owakwadɛ mgbi ama wuuta mi ungwogye ngwi a li gha alegbe-alegbe na ba. ");
INSERT INTO utr_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Nghanɛ ama ogbikye iYesu iwyodefa ntona kwu ama onoyɛyɛ ntona duu kwakye si gbɛɛ, <<Ka li ayin ba kini eyi dzita idɔ mgbi elodzɛ Imgbasho yɛ le gha ungwogye yɔ. ");
INSERT INTO utr_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Emi ongwunani, sadu engyulɔ egyafa mi idzidzɛ ema, ama ngwu ema ye gbɛɛ a dzɛ yi Onodzi saan yi ozoyeye mani. Eyi ka yile idɔ nɛ wo ma abɔ ");
INSERT INTO utr_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","ta eyi ka yile itukwu mgbi eyi nu mi ibɔ yi idɔ mgbi elodzɛ Imgbasho.>> ");
INSERT INTO utr_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Ewodzɛ nɛ kpa inggisɛ ntona duu. A sadu iStivin, inggisɛ ngwu mbwo yi oyɛyɛ onuunu bɛyi Onodzi Osaan; iFyilipi kpaa, iProkoru, iNikano, iTimɔn, iPamena, bɛyi iNikola ongwu nkyɛ mi Antiɔku, nkyata luba odzɛ Imgbasho mgbi emi iJuda nani. ");
INSERT INTO utr_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","A gbe inggisɛ ntona tso ama ogbikye iYesu, man a bibɔ woma di kye abɔ dɔ ma ikye. ");
INSERT INTO utr_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Nghanɛ elodzɛ Imgbasho gbɔfwɛ. Mmbwo mgbi engwafɔ iYesu mi iJerosalin she kpakpa, nɛ ama ofifɛ kwuba yɛɛ ama onoyɛyɛ. ");
INSERT INTO utr_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Nɛ iStivin, inggisɛ ngwu elela mgbi Imgbasho dzɛ mbon yi mfye kpakpa, kyungwɔ ama okwulewo yi ambɛ okwulewo mi idzidzɛ inggisɛ ntonani. ");
INSERT INTO utr_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Nɛ, inggisɛ angbeka mi ozu okwakye mgbi ofyɛɛ ama a shɛ ma adi ta wita otangwodzɛ yi iStivin. A li emi iJuda ama nkyɛ iSirini yi Alekdzandra bɛyi ayɛsɛ mgbi iSilisia yi Asia. ");
INSERT INTO utr_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Nghaduu a yagba kye afɔ twɛsɛ yi ozoyeye mgban hona Onodzi ndzɛ mbon ma ba. ");
INSERT INTO utr_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Nɛ a wɛ inggisɛ angbeka ɛwɛ daada ikye nu ma gbɛɛ, <<Eyi fwo iStivin gbɔ elodzɛ ofya iMose yi Imgbasho ito.>> ");
INSERT INTO utr_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Mi odzɛ nɛ, a kyile inggisɛ ntona angbi yi engyukwo bɛyi etsetse mgbi ola mgbi iMose. A bwa iStivin kyon ba okwakye. ");
INSERT INTO utr_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","A gbe ama omwonya angbeka ba, wa mwonya gbɛɛ, <<Inggisɛ nɛ nya ogbɔdzɛ obube ikpewo imbe osaan nɛ bɛyi ola waba. ");
INSERT INTO utr_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Ikyesinɛ eyi fwon le gbɔgbɛɛ iYesu ongwi iNadzareti nɛ ka bulu imbe nɛ di nyinɛ aletɔ ngwi iMose kye wo eyi abɔ nɛni.>> ");
INSERT INTO utr_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Ama nsɔto okwakye duu kye inɛ fyakwu iStivin, man a di inɛ mgban dzɛ dafi inɛ mgbi ongyesɔ mani. ");
INSERT INTO utr_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Nɛ okwukwo inggisɛ ofifɛ byun gbɛɛ, <<Odzɛ ntonɛ li otsitsii?>> ");
INSERT INTO utr_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","IStivin nu uka gbɛɛ: <<Emi ongwunani yi emi otsani, gadɔ mbi ani na! Imgbasho mgbi okwɔkwɔ tɔ tu otseyi Abrahan ngwi o ka dzɛ iMesopotamia mani, duuse o wa dzɛ iHaran. ");
INSERT INTO utr_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Imgbasho gbɛɛ, <Dzita ɛsɛ mgbi abu yi emidabu, lu ikpɛsɛ ngwi ani ka tso abu mani.> ");
INSERT INTO utr_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","<<Nghanɛ o dzita ikpɛsɛ mgbi emi iCadia lu ka sɔ iHaran. Ngwi otsɔn wa kwulu nyɛ nɛ, Imgbasho dɔn esɔ ba ikpɛsɛ ngwi ema todzɛ ele onɛnɛ nɛni. ");
INSERT INTO utr_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Imgbasho nun okwudɛ onyi mmɛnɛ ba, atafɔ ikpɛsɛ onyi kpaa ba. Nghaduu Imgbasho zondu yan gbɛɛ ongwu yi etɔ mgban ka yɛɛ otsungwɔ ikpɛsɛ nɛni, nghataa gyegwu. Mi onɔ na Abrahan dzɛ yi ongwɛ waba. ");
INSERT INTO utr_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Li odzɛ ngwi Imgbasho gbɔ yan aani: <Etɔ mgbi ema ka li ingyoga mi ɛsɛ ngwi li mgbi ama ba, a ka kwu ma ofyɛɛ di nu ma adzɛ mi onova ideli enɛ. ");
INSERT INTO utr_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Imgbasho gbɛɛ, nghaduu ani ka kwo ɛsɛ ngwi a to ele dafi ofyɛɛ ma adɔ, ngyɛduu a ka tasɛ mi ɛsɛ na wa sunu ani mi imbe nɛni.> ");
INSERT INTO utr_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Nɛ o nu Abrahan ondu odzɛɛdzɛ mgbi ikyɛ okyɛ-kyɛ. Man Abrahan yɛɛ otsɔ Adziki di kyan ikyɛ ngwi a mban nyɛ egbe egyata mani. Adziki wa yɛɛ otsɔ iJeko, iJeko di wa yɛɛ otsɔ iwyodefa emi otsikyeyi ntonani. ");
INSERT INTO utr_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","<<Ikyegbɛɛ emi otsikyeyi ntona di iJose tanyi nɛ, a kyon gya dafi ofyɛɛ lu Igyibiti. Nghaduu Imgbasho dzɛyan ");
INSERT INTO utr_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","di dulun tɔ mi okakewo mgban duu. Imgbasho nu iJose ozoyeye di yan abɔ nu untsɛ osuse dɔn mbi iFaro utɔ mgbi emi Igyibiti; nghanɛ o non yɛɛ inggisɛ ogbe emi Igyibiti teyi yi udɛ mgbi ongwu duu. ");
INSERT INTO utr_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","<<Nɛ omani wa dɔ mi Igyibiti yi iKana duu, kye adzɛ kpakpa ba, emi otseyi si tu ungwogye wuba. ");
INSERT INTO utr_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Onɔ ngwi iJeko fwo gbɛɛ ungwogyowe dzɛ Igyibiti nɛ, o dɔ emi otseyi esɔ kɛ ele ababɔ. ");
INSERT INTO utr_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Mi okɛɛkɛ mgbi ama ongwu fan ma, iJose nya emi ongwunɔn inggisɛ ngwu ongwu dzɛ mani, man iFaro si ye odzɛ etɔ mgbi iJose. ");
INSERT INTO utr_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Ngwi ungwɔnɛ nyɛ nɛ, iJose dɛsɔ mbi otsɔn iJeko yi etɔ mgban duu, a li ngwuseta dɔn iwyo diwyeda duudu. ");
INSERT INTO utr_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Nɛ iJeko si lu Igyibiti, li mi imbe na ngwi ama duu ka kwulu aali. ");
INSERT INTO utr_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","A yile ikwɔ mgbi ama luba iShekɛn wa ndzi mi endzi ngwi Abrahan gya nose mi abɔ mgbi emi ongwɛ iHamɔ mi awuya mani. ");
INSERT INTO utr_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","<<Ngwi onɔ wa mba ngwi Imgbasho ka mbwo ondu odzɛɛdzɛ yi Abrahan nɛ, mmbwo mgbi emideyi mi Igyibiti she kpakpa. ");
INSERT INTO utr_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Nɛ utɔ ofufɛ, ngwu ye unkonyi mi odzɛ mgbi iJose ba, yɛɛ utɔ mgbi Igyibiti. ");
INSERT INTO utr_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","O ngwunu emideyi di si emi otsikyeyi, gbɛɛ nu ma gbe engwengyulɔ eyeyi ngwuta adzi nu ma kwulu. ");
INSERT INTO utr_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","<<Mi onɔ na a mba iMose, ma o li nngwadza mi inɛ mgbi Imgbasho. A gbɛwɛ byun mi udɛ otsɔn ofyia eta. ");
INSERT INTO utr_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Ngwi a kyon tɔ dzata udɛ nɛ, ongwɛ iFaro ongwu ongyaa kyon si byun dafi ongwan mani. ");
INSERT INTO utr_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","A tso iMose ozoyeye mgbi emi Igyibiti tsatsa, o diyɛ datu mi elodzɛ yi okyɔɔkyɔ. ");
INSERT INTO utr_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","<<Onɔ ngwi iMose li onova ngwusefa ma, itukwu kyɛɛ lon oka kpadi emi Israi emidan. ");
INSERT INTO utr_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","O di onyi mi ele ngwu inggisɛ Igyibiti le nun adzɛ, nghanɛ o kɛ oka tobyun di kpumkpa ikyon mi okyi ngwɔlu inggisɛ Igyibiti nani. ");
INSERT INTO utr_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","IMose tsɛwɛ gbɛɛ, emidongwu ka difwi gbɛɛ Imgbasho kye ongwu le kyidɔ ikye odulu ma tɔ, nghaduu kpaa a difwi ba. ");
INSERT INTO utr_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Tegblifan iMose wa kpatsɛ yi emi Israi nghi efa tole gblibe. O fya oyile ma gyiide mi ogbɛɛ, <Engyulɔ, ema li engwunɔ ewe kyɔsinɛ ngwi ema mina ota ewema mmya?> ");
INSERT INTO utr_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","<<Nghaduu ongwu nle kyɔ yi oka timbi ma tsamu iMose lu enggengga si gbɛɛ, <Li emɛ nu abu mfye okye eyi teyi di gbɔ eyi ikwɔ? ");
INSERT INTO utr_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","I mina abu ongwɔ ani dafi abu ngwɔ inggisɛ Igyibiti edɛdɛ naa?> ");
INSERT INTO utr_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Ngwi iMose fwo odzɛ nɛ nɛ, o tsinya lu iMidian, imbe ngwi o ka dzɛ ingyoga di kye ongyaa mba ɛngbɛ efa. ");
INSERT INTO utr_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","<<Ngwi i wa nyɛ onova ngwusefa nɛ, ongyesɔ mblegba tu iMose mi ambɛ mgbi oshɛ ogyola mi imbe okplagada kwɛkwɛ yi Unggwɔ iSinai. ");
INSERT INTO utr_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Ngwi iMose di ungwɔnɛ nɛ, i kwulun ewo. Ngwi o gbo kɛ kwɛkwɛ oka di saan nɛ, o fwo ela mgbi Otsɛ Imgbasho gbɛɛ: ");
INSERT INTO utr_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","<Ani li Imgbasho mgbi emi otsabu, Imgbasho mgbi Abrahan, Adziki yi iJeko.> IMose tsaatsa yi imio di yagba kye inɛ byi ola na wuba. ");
INSERT INTO utr_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","<<Nɛ Otsɛ Imgbasho si nyan gbɛɛ, <Kyi dulu okpafɔ mgbi abu; ikyekyɛ imbe ngwi abu kwudzɛ nɛ li imbe osaan. ");
INSERT INTO utr_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Ani di adzɛ mgbi emidani mi Igyibiti wa. Ani fwo andu omama mgbi ama di ba esɛ owa shɛ ma adi ta. Ba onɛnɛni, n ka dɔ abu esɔ yɛ kɛ Igyibiti.> ");
INSERT INTO utr_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","<<Nɛnɛ li iMose ngwu a teyi fwan yi elodzɛ gbɛɛ, <Li emɛ nu abu li inggisɛ ogbe eyi teyi di gbɔ eyi ikwɔ?> Li iMose nɛ kpɔɔ ngwu Imgbasho nyɛ mbi ongyesɔ mblegba tun ngwi oshɛ le gyola mani. Dɔn esɔ no ka li inggisɛ ogbe ma teyi di dulu ma tɔ. ");
INSERT INTO utr_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","O gbe ma tasɛ mi Igyibiti di kyungwɔ ama okwulewo yi emi ambɛ okwulewo mi Igyibiti, mi ekyoo omuma okwukwo yi imbe okplagada mi onova ngwusefa. ");
INSERT INTO utr_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","<<Nɛnɛ li iMose ngwu nya emi Israi gbɛɛ, <Imgbasho ka kye oyegbɔ ndzɛ dafi ani mi idzidzɛ ema dɛsɔ nu ema mani.> ");
INSERT INTO utr_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","O wodzɛ okwakye mi imbe okplagada, yi ongyesɔ ngbɔdzɛ yan mi Unggwɔ ongwi iSinai, bɛyi emi otseyi; o di gbɛ elodzɛ oshishe okye wa gbɔ nya eyi. ");
INSERT INTO utr_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","<<Nghaduu emi otsikyeyi gbela yan ba. A fwan, di mina gbɛɛ ama ki yɛ lu Igyibiti. ");
INSERT INTO utr_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","A nya Eron gbɛɛ, <Mɛ eyi Imgbasho ama nka kye eyi teyi mani. Lubana iMose ngbe eyi tɔ mi Igyibiti nɛ, eyi ye ungwɔ nkyɔn ba!> ");
INSERT INTO utr_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Nana li onɔ nose ngwi a mɛ adagyɛ mi odzɛɛdzɛ mgbi ongwumnda mani. A gbe ifɛ ofɛ-fɛ ba ele di kyɔ oga osunu ungwɔ ngwi ama mɛ mi abɔ mgbi ama. ");
INSERT INTO utr_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Nghanɛ Imgbasho fashi iyikpa tsɛ ma yile osusunu mgbi ama nu mcɛ mi esho. Ungwɔnɛ kwokyi yi ungwɔ ngwi a lɔ mi Afɛ mgbi ama ogbɛɛsɛ gbɛɛ: << <Emi Israi! Li ani ngwu ema ngwɔ ifyungwɔ di fifɛ nu mi onova ngwusefa mi imbe okplagadaa? ");
INSERT INTO utr_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Emi adagyɛ ngwi ema mɛ osunu nani, ema kyile udɛ angwula ongwi iMoleki esho yi mcɛ mgbi Imgbasho mgbi ema iRefanu. Nghanɛ n ka lɔ ema onya lu anɔ oka> nyɛ-nyɛ iBabyilon kpaa. ");
INSERT INTO utr_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","<<Emi otsikyeyi dzɛ yi iTabenako obwɛndɛ yi ama mi oshɛ. A man dafi Imgbasho tso iMose mi odzɛɛdzɛ ngwi o di mani. ");
INSERT INTO utr_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Dafi a kyi gbɛlu iTabenako nɛ, emi otseyi kyi kyelu byi yi ama, mi onɔ ngwi iJoshua kye ma teyi kaka ɛsɛ ngwi Imgbasho kyi gbɛlu nu ma nani. I tila dzɛ ikpɛsɛ na nghataa ba onɔ mgbi iDevedi, ");
INSERT INTO utr_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","ngwu ikyese mgbi Imgbasho dɔn, o di bɔn ibɔ gbɛɛ ni ongwu mbɛ imbe ngwi Imgbasho mgbi iJeko ka dzɛ nani. ");
INSERT INTO utr_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Kpaa li iSolomu mbaan ozu nani. ");
INSERT INTO utr_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","<<Nghaduu, onghaangha na, li la ozu ngwi inggisɛ mbɛ ba. Dafi oyegbɔ gbɔgbɛɛ: ");
INSERT INTO utr_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","<< <Esho li esutɔ mgbi ani, ɛsɛ li imbe mgbi ani ogbe afɔ dɔ. Li ali itɔ ozu ngwi abu ka mbɛ ani ele? Li ngha Imgbasho gbɔ aali. Naadi li mi ole ngwi imbe mgbi ani otonya ka dzɛ? ");
INSERT INTO utr_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Li abɔ mgbi ani mɛ ungwɔ ntonɛ duu baa?> ");
INSERT INTO utr_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","<<Ema ama ndɔto ibiba dzɔgbɔ di kyiikyɛ mi itukwu yi adɔ ba nɛni! Ema to yɛyɛ dafi emi otsema mani: Ema li kye afɔ twɛsɛ yi Onodzi Osaan alonɔ duu! ");
INSERT INTO utr_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Oyegbɔ teyi dzɛma ngwu emi otsikyema nose nun isɔ baa? A kye ngwɔlu ama ngbɔ obaaba mgbi ongwu nle saan na kpaa. Ma onɛnɛ ema kyon gya di ngwɔn wa. ");
INSERT INTO utr_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Ema ama ngbɛ ola ngwi nyɛ abɔ ongyesɔ mgbi Imgbasho kpaa kyɔ mi ele ba nɛni.>> ");
INSERT INTO utr_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Ngwi emi okwakye fwo odzɛ nɛ mi ondu mgban nɛ, a nyɛ yi itingga di kwolu inɛ ikye yan. ");
INSERT INTO utr_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Kpaa iStivin, mbwo yi Onodzi Osaan, o ndinɛ kɛ esho si di okwɔkwɔ mgbi Imgbasho yi iYesu kwudzɛ abugye mgbi Imgbasho. ");
INSERT INTO utr_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","O gbɛɛ, <<Dika, ani di esho kwulu Ongwɛ Inggisɛ di kwudzɛ abugye mgbi Imgbasho.>> ");
INSERT INTO utr_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Mi odzɛ nɛ a kye abɔ tukwu adɔ mgbi ama, le kwu ela mi ela okwukwo, ama duu kyɛɛ tukwun, ");
INSERT INTO utr_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","kwon tasɛ mi ogalu si wita otsan akwutsɛ. Nghanɛ, emi obwɛndɛ gbe angwuto mgbi ama wa tokɛ iyayi mgbi ongwɛ mmafa ngwu a li kwun di iSol nani. ");
INSERT INTO utr_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Ngwi a le tsan akwutsɛ nɛ, iStivin bibɔ gbɛɛ, <<Otsɛ iYesu, kyi gbɛlu onodzi mgbi ani.>> ");
INSERT INTO utr_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Nɛ o gbe akwafɔ kwokɛ esɛ makwɔ tɔ esɛ gbɛɛ, <<Otsɛ, ka wɛ alobube nɛ ikye ma ba.>> Ngwi o gbɔdzɛ nɛ mata, o si yulu. ");
INSERT INTO utr_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","ISol dzɛ imbe nani di gbela ikwu iStivin. Mi egbe na isɔ gbobu tɔ ikye emi iKrestu mi iJerosalin, nɛ ama duu ganya kpatsɛ iJudia yi iSamaria, i sisi ama ogbikye iYesu yuoma. ");
INSERT INTO utr_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Emidi Imgbasho kye iStivin ndzi di tsukwu kpakpa ikyon. ");
INSERT INTO utr_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Nghaduu iSol wita odzili emi iKrestu. O le kaka udɛ udɛ, le kwo ama onoyɛyɛ engyulɔ yi engyaa gbe ma wokɛ obawi. ");
INSERT INTO utr_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Ama ngwu a ganya ma na, gbeesɔ nɛ mi ali imbe ngwi a kɛ duu. ");
INSERT INTO utr_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","IFyilipi kɛ ogalu oka mi iSamaria ka gbeesɔ mgbi iKrestu mi ele. ");
INSERT INTO utr_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Ngwi ibyi ntona fwo iFyilipi di di ambɛ okwulewo ngwi o kyɔ nɛ, a nghao gbekabyi mi odzɛ ngwi o gbɔ mani. ");
INSERT INTO utr_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Onodzi ama okpɛkpɛ tasɛ mbi inggisɛ ibyibyi yi ela ota-ta, ama ngwu alewo kwulu yi ama ngbikye tukwu esɛ kwuba a ngyɛlu ma ootse. ");
INSERT INTO utr_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Man atsa si dzɛ ogalu na kpakpa. ");
INSERT INTO utr_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Inggisɛ oka dzɛ ogalu na li kyɔ obudei onɔ kɛ, li kwulu emi iSamaria duu ewo kpakpa, a li kwun di iSaimɔn. O tsaabɔ igɛgɛ gbɛɛ ongwu li ongbodzi inggisɛ. ");
INSERT INTO utr_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Ta ali inggisɛ, ama nshewo yi ama n yɛ esɛ duu, kye eka mgbi ama nu mbon si li wulu gbɛɛ, <<Inggisɛ nɛ li mfye mgbi Imgbasho ngwi a ye gbɛɛ li mfye ogbagbadzidzi mani.>> ");
INSERT INTO utr_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","A kyɛdɔn ikyekyɛ onɔ kɛ ngwi o le kyungwɔ okwulu ma ewo yi obudei mgban. ");
INSERT INTO utr_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Kpaa ngwi a nu iFyilipi oyɛyɛ dafi o gbɔ Esɔ Osuse mgbi esutɔ mgbi Imgbasho bɛyi iyi mgbi iYesu iKrestu nɛ, a kyɔ ma iBatisima, engyulɔ yi engyaa duu. ");
INSERT INTO utr_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","ISaimɔn abuon noyɛyɛ ta a kyɔn iBatisima. O di kyɛdɔ iFyilipi mi ali imbe duu, i kwulun ewo mi ambɛ okwulewo kpakpa yi ungwɔ ama okwulewo ngwi o di ntonani. ");
INSERT INTO utr_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Onɔ ngwi ama ogbikye iYesu mi iJerosalin fwo gbɛɛ, emi iSamaria gbɛ Imgbasho nɛ, a dɔ iPyita yi iJɔn esɔ kɛ mboma. ");
INSERT INTO utr_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Ngwi a ka to nɛ, a bibɔ wo ma ikyegbɛɛ nu ma gbɛ Onodzi Osaan, ");
INSERT INTO utr_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","ikyena Onodzi Osaan ba mbi inggisɛ mgbi ama onyi waba; a kyɔ ma iBatisima mi iyi mgbi Otsɛ iYesu kyoon. ");
INSERT INTO utr_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Nɛ iPyita yi iJɔn kye abɔ dɔ ma ikye ta a si gbɛ Onodzi Osaan. ");
INSERT INTO utr_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Ngwi iSaimɔn di gbɛɛ li mi abɔ mgbi ama ogbikye iYesu okye dɔ ma ikye ta ngwi a kye Onodzi nu nɛ, o kye awuya ba mboma ");
INSERT INTO utr_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","si gbɛɛ, <<Nu ani kpaa mfye nɛni, adzi ni ali inggisɛ ngwu ani kye abɔ gbon duu no gbɛ Onodzi Osaan.>> ");
INSERT INTO utr_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","IPyita nu uka gbɛɛ: <<Ni awuya mgbi abu dzili bɛyi abu duu, ikyesinɛ abu tsɛwɛ gbɛɛ abu ka gya umba mgbi Imgbasho yi awuya! ");
INSERT INTO utr_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Abu dzɛ yi ayɛ hona umba mi idɔ nɛ ba, ikyekyɛ itukwu mgbi abu le saan mbi Imgbasho ba. ");
INSERT INTO utr_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Kyatitukwu mi imbali nɛni di bibɔ mbi Otsɛ. Kpakpana o ka dzita abu mi odzɛ yi itɔ ewodzɛ ngwi abu dzɛyan mi itukwu mbi abu nɛni. ");
INSERT INTO utr_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Ikyekyɛ ani di gbɛɛ abu mbwo yi unɔ bɛyi adi obwa-bwa mi alobube.>> ");
INSERT INTO utr_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Nɛ iSaimɔn nu uka gbɛɛ, <<Bɔ Otsɛ Imgbasho ibɔ ikye ani adzi ni ungwɔ ngwi abu gbɔ ntonɛ onyi kpaa no ka kyɔ ani ba mani.>> ");
INSERT INTO utr_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Onɔ ngwi a kyɔ obwɛndɛ di gbeesɔ mgbi Otsɛ ngyɛ nɛ, iPyita yi iJɔn yidɔ le lu iJerosalin, le gbɔ Esɔ Osuse mi agwɔ ibyibyi mi iSamaria. ");
INSERT INTO utr_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Nɛ ongyesɔ mgbi Otsɛ nya iFyilipi gbɛɛ, <<Lu ofɛ atɛsɛ, ofɛ okplagada nkyɛ mi iJerosalin lu iGadza nani.>> ");
INSERT INTO utr_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Nɛta o si tɔ ofɛ le lu, ngwi o le kɛ ofɛ nɛ, o kpatsɛ adumongyaa inggisɛ iTiopia, inggisɛ imɔ nle di mi awuya mgbi iKandase duu, Apodza mgbi emi iTiopia mani. Inggisɛ nɛ kɛ iJerosalin oka sunu Imgbasho, ");
INSERT INTO utr_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","ngwi o sɔdzɛ mmya yɛ le lu udɛ mgban nɛ, o le gbɔ afɛ mgbi oyegbɔ Adzaya. ");
INSERT INTO utr_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Onodzi nya iFyilipi gbɛɛ, <<Kɛ ka kwudzɛkɛ kwɛkwɛ yi mmya nani.>> ");
INSERT INTO utr_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","IFyilipi si tsinya kɛ kwɛkwɛ yi mmya na si fwo inggisɛ na le gbɔ afɛ mgbi oyegbɔ Adzaya. IFyilipi byita gbɛɛ, <<Ungwɔ ngwi abu gbɔ na gbosa lo abuu?>> ");
INSERT INTO utr_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","O gbɛɛ, <<Ka gbosa lo ani sinɛ, sede inggisɛ oka ka kye gbɔfwɛ nya ani se lo?>> Nghanɛ o bɔ iFyilipi gbɛɛ no wa sɔ yan. ");
INSERT INTO utr_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Inggisɛ na le gbɔ imbe ngbɛɛ, <<A kyon teyi dafi ongwummala ngwi a kye le ka ngwɔ mani. O di dzɛ shili dafi ongwummala ngwi a dzan andu, kpaa o kwondu ba mani. ");
INSERT INTO utr_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Mi ayiwi mgban yɔ, a non gye emyɛmyɛ ba. Li emɛ ka gbɔdzɛ etɔ mgban? Lubana a kyi kyelun oshishe mi ɛsɛ nɛni.>> ");
INSERT INTO utr_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Adumongyaa na byi iFyilipi gbɛɛ, <<Tsuutsu nya ani, li emɛ ngwu oyegbɔ le gbɔdzan, li mi ikye ongwu abuon naadi inggisɛ oka idzidza?>> ");
INSERT INTO utr_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Ta iFyilipi si wita yi imbe mgbi Afɛ na yɛyɛ nyan Esɔ Osuse mgbi iYesu. ");
INSERT INTO utr_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Ngwi a le kɛ ofɛ nɛ, a wa to imbe ngwi eni dzɛ, ta adumongyaa na gbɛɛ, <<Dii, eni dzɛ aani. Kyɔnɛ ngwi a ka kyɔ ani iBatisima ba?>>  ");
INSERT INTO utr_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","IFyilipi gbɛɛ, <<Kini abu noyɛyɛ yi itukwu mgbi abu duu yɔ, a ka yagba kyɔ abu.>> Adumongyaa na si gbɛɛ, <<N noyɛyɛ gbɛɛ iYesu iKrestu li Ongwɛ Imgbasho.>> ");
INSERT INTO utr_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","O byakpaa gbɛɛ nu ma kwulɛsɛ yi mmya. IFyilipi yi inggisɛ na tashulu kaka eni man iFyilipi kyɔn iBatisima. ");
INSERT INTO utr_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Mi onɔ ngwi a tasɛ mi eni ma, Onodzi mgbi Otsɛ wa kyi kyelu iFyilipi lu akponyi, man adumongyaa na din wuba, kpaa lu ungwɔn le tsatsa. ");
INSERT INTO utr_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","IFyilipi ka tɔ mi Azotu le kyikyɛ kyɛ, le gbɔ Esɔ Osuse mi ali igeli duu nghataa ka kaka iSisiria. ");
INSERT INTO utr_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Mi ongwonɔ na, iSol kale pita ofɛ obube ongwɔ engwafɔ mgbi Otsɛ. O kɛ mbi okwukwo inggisɛ ofifɛ ");
INSERT INTO utr_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","ka bɔn gbɛɛ non lɔ afɛ kwuba kɛ mi ozu okwakye mgbi emi iJuda nto iDamasiko, ikyegbɛɛ kini ongwu tu inggisɛ nka dzɛ itɔ Ofɛ na yɔ, ni li ongyulɔ naadi ongyaa kpaa ni ongwu kwun ofyɛɛ luba iJerosalin. ");
INSERT INTO utr_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Ngwi o dzɛ kwɛkwɛ okaka iDamasiko nɛta, osa tɔkyɛ esho wa dzanwo akponyi. ");
INSERT INTO utr_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","O gbɛsɛ lakɛ esɛ si fwo ela le nyan gbɛɛ, <<iSol, iSol, li ekyɛ ngwi abu le nu ani isɔ?>> ");
INSERT INTO utr_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","ISol byita gbɛɛ, <<Li abu emɛni Otsɛ?>> Ela na nu uka gbɛɛ, <<Li ani iYesu ngwu abu le nu ani isɔ mani. ");
INSERT INTO utr_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Kyato onɛnɛ kaka ifu ogalu, ta a ka nya abu ungwɔ ngwi abu ka kyɔ kyɛmɛ-kyɛmɛ mani.>> ");
INSERT INTO utr_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Inggisɛ ama nkyɛ yi iSol na mmyɛ dzɛma; ikyesinɛ a fwo ela na kpaa a di inggisɛ ba. ");
INSERT INTO utr_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","ISol kyato mi esɛ, ngwi o kwulu inɛ nɛ, o yagba odinɛ wuba. Nɛ a byin abɔ kaka iDamasiko. ");
INSERT INTO utr_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","O binɛ dzɛ imbe na egbe eta, o gye ungwɔ hona wa ungwɔ kpaa ba. ");
INSERT INTO utr_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Mi iDamasiko ma ongwafɔ oka dzɛ ele iyin di Anania. Otsɛ kwun ela mi inɛ odiidi gbɛɛ, <<Anania!>> O gbela gbɛɛ, <<Uwoo, Otsɛ.>> ");
INSERT INTO utr_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Otsɛ nyan gbɛɛ, <<Lu ofɛ ngwi iyin gbɛɛ Byi yɛyɛ nani kɛ udɛ iJuda ka byita inggisɛ ongwi iTasu ngwu iyin di iSol, o le bibɔ mi abɔ ma. ");
INSERT INTO utr_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","O di inggisɛ ngwu a li kwun di Anania ba mi inɛ odiidi wa kye abɔ le dɔn ikye, ikye okwulun inɛ.>> ");
INSERT INTO utr_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Kpaa Anania gbɛɛ, <<Otsɛ, ani fwo inggisɛ ibyibyi le gbɔdzɛ ungwɔ obube ama inggisɛ nɛ kyɔ yi emi osaan mi iJerosalin. ");
INSERT INTO utr_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Ma o di gbɛ mfye mbi engyukwo ama ofifɛ badzɛ owa bwa ali inggisɛ nle kwu mi iyi mgbi abu duu.>> ");
INSERT INTO utr_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Nghaduu Otsɛ nya Anania gbɛɛ, <<Kɛ! Inggisɛ nɛ li okyiidɔ ngwi ani dulun okye iyi ani kɛ mbi Udzengye yi utɔ mgbi ama bɛyi emi Israi duu. ");
INSERT INTO utr_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Ma n ka tson dafi o ka gbiisɔ mi ikye iyi mgbi ani kyɛmɛ-kyɛmɛ mani.>> ");
INSERT INTO utr_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Ta Anania si lu ka kaka ozu mani, ngwi o kye abɔ dɔ iSol ikye nɛ, o gbɛɛ, <<Ongwunɛn iSol, Otsɛ iYesu ngwu tsetu abu mi ofɛ mi onɔ ngwi abu le ba mmɛnɛ nani, dɔ ani esɔ ikyegbɛɛ ni abu yɛ dinɛ diyɛ mbwo yi Onodzi Osaan.>> ");
INSERT INTO utr_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Labɔlabɔ mata, ungwɔ dafi akwukwu mmbweni tɔ ngwuta mi inɛ mgbi iSol, ta o diyɛ le di. O kyato taman a kyɔn iBatisima, ");
INSERT INTO utr_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","ngwi o wa gye ungwogye nɛta o si yile ewo bɛsɛ. ISol kye egbe gwee yi engwafɔ mgbi iYesu mi iDamasiko. ");
INSERT INTO utr_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","O byakpa wita ogbeesɔ mi ozu okwakye mgbi emi iJuda gbɛɛ iYesu li Ongwɛ Imgbasho. ");
INSERT INTO utr_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Ama nfwon duu i kwulu ma ewo ta a byita gbɛɛ, <<Nɛnɛ li ongyulɔ nle nu ama nle kwu mi iyi nɛ isɔ mi iJerosalin ma baa? Ma o di ba mmɛnɛ owa bwa ma gbe ma lu ka nu engyukwo ama ofifɛ naadi?>> ");
INSERT INTO utr_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Nghaduu esɔ ogbɔɔgbɔ mgbi iSol nghao fyumfye di non kwulu emi iJuda ama nto iDamasiko ewo mi otso gbɛɛ iYesu li iMedzaya. ");
INSERT INTO utr_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Ngwi i wa kɛ gɔɔ nɛ, emi iJuda wibu ongwɔn, ");
INSERT INTO utr_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","kpaa iSol difwi oweka mgbi ama. Otu yi onɔ a gbinɛbyi onufɛ ogalu le ngyo ikye ongwɔn. ");
INSERT INTO utr_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Nghaduu ama okyɛdɔn kyen wokɛ uya mi otu kyon nyɛ ifo mi ewishi luba esɛ. ");
INSERT INTO utr_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Ngwi o wa kaka iJerosalin nɛ, o fya gbɛɛ ni ongwu kwakye yi engwafɔ mgbi iYesu, kpaa ama duu tsimion, a noyɛyɛ gbɛɛ o li ongwafɔ otsitsi ba. ");
INSERT INTO utr_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Kpaa iBanabasi kyon ba mbi ama ogbikye iYesu. O nya ma dafi mi onɔ ngwi iSol le kɛ okyɛɛ ma o di Otsɛ iYesu, Otsɛ di gbɔdzɛ yan, dafi o di gbeesɔ mi iyi mgbi iYesu mi iDamasiko yi imio ba mani. ");
INSERT INTO utr_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Nghanɛ iSol dzɛ yi ama mi iJerosalin shewota, le gbɔdzɛ yi abɔ otsigɛgɛ mi iyi mgbi Otsɛ. ");
INSERT INTO utr_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","O li gbɔdzɛ di tangwodzɛ yi emi iJuda ama ogbɔ ondu iGriki, kpaa a fya ongwɔn. ");
INSERT INTO utr_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Ngwi ama onoyɛyɛ wa difwi nghanɛ, a kyon lu iSisiria, di kyon dɛsɔ lu iTasu. ");
INSERT INTO utr_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Ta ali okwakye mgbi emi iKrestu mi iJudia, iGalalia bɛyi iSamaria duu dzɛ mi iyu onɔ nani. Onodzi Osaan si ya ma abɔ nu ma fyumfye di she mi mmbwo, di dzɛ yi imio mgbi Otsɛ. ");
INSERT INTO utr_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Dafi iPyita le dzagaba kpatsɛ ɛsɛ na duu nɛ, o kɛ oka kpadi emi osaan mi iLida. ");
INSERT INTO utr_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Mi imbe na o tu inggisɛ ngwu a li kwun di Aeni, kwulu afɔ yi abɔ ladzɛ akwulo onova egyata. ");
INSERT INTO utr_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","IPyita nyan gbɛɛ, <<Aeni iYesu iKrestu ngyɛlu abu ootse. Kyato kyi kyelu akwulo mgbi abu.>> Aeni byakpa kyato akponyi. ");
INSERT INTO utr_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Ama nto iLida bɛyi iSharon duu di Aeni man kyata yɛɛ ama okyɛdɔ Otsɛ. ");
INSERT INTO utr_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Ongwafɔ ongyaa oka dzɛ iJopa iyin di iTabyita (ngwi itan di iDokasi mi ondu iGriki), o li le kyungwɔ ama osuse di ya emi abubɔ abɔ alonɔ duu. ");
INSERT INTO utr_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Mi itɔnɔ na o dotse si kwulu, a sho ikwɔ mgban ewo kye ka dɔ mi ozeesho. ");
INSERT INTO utr_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","ILida tunto yi iJopa ba; ngwi engwafɔ wa fwo gbɛɛ iPyita dzɛ iLida nɛ, a dɔ inggisɛ efa esɔ kɛ mbon gbɛɛ, <<Wafɔ yi eyi plɛ-plɛ!>> ");
INSERT INTO utr_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","IPyita wafɔ yi ama, ngwi o ka to nɛ a kyon lu ozeesho. Engyaa owakwadɛ duu kyato tokɛ unto yan, le makwɔ di gbe abu yi angwuto angbeka ngwi iDokasi kwo nu ma mi onɔ ngwi o ka dzɛ oshishe ma tson. ");
INSERT INTO utr_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","IPyita lɔ ma onya duu tɔ mi ifoozu; si kwɛsɛ bibɔ. Ngwi o kyata inɛ kɛ mbi ongyaa ikwukwɔ nɛ, o gbɛɛ, <<iTabyita, kyato.>> O kwulu inɛ, ngwi o di iPyita nɛta, o sɔkɛ unto. ");
INSERT INTO utr_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","O kye abɔ byun yan abɔ non kye afɔ dzɛkɛ esɛ. Nɛ o si kwu ama onoyɛyɛ ela bɛyi ewakwadɛ kyon nu ma oshishe. ");
INSERT INTO utr_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Odzɛ nɛ gbɔfwɛ kpatsɛ iJopa duu, inggisɛ kwuba di noyɛyɛ mbi Otsɛ. ");
INSERT INTO utr_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","IPyita tila dzɛ iJopa kye onɔ kpakpa yi inggisɛ okyidɔ okpa okwookwo ngwu a li kwun di iSaimɔn. ");
INSERT INTO utr_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Ongyulɔ oka dzɛ iSisiria a li kwun di iKɔnɛlu, o li okwukwo ogbakwu nle di mi obyi oblakwutsɛ mi Italia. ");
INSERT INTO utr_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Ongwu yi etɔ mgban duu kye itukwu nu di li mio Imgbasho; o li gha emi abubɔ umba dzii di li bɔ Imgbasho ibɔ alonɔ duu. ");
INSERT INTO utr_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Egbe oka dafi obyi eta ngwi onɔ tashulu akpa nɛ, o di inɛ odiidi. O di ongyesɔ mgbi Imgbasho saan, ba mbon wa gbɛɛ, <<IKɔnɛlu!>> ");
INSERT INTO utr_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","IKɔnɛlu kye inɛ fyakwun yi imio. O byita gbɛɛ, <<Li ɛkyɛ, Otsɛ?>> Ongyesɔ na nu uka gbɛɛ, <<Ibɔ yi umba mgbi abu ogha emi abubɔ duu lu esho i yɛɛ ungwɔ Imgbasho kale wɛ abu. ");
INSERT INTO utr_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Dɔ inggisɛ esɔ nu ma kɛ iJopa ka yile inggisɛ ngwu iyin di iSaimɔn ngwu a li kwun di iPyita na onɛnɛni. ");
INSERT INTO utr_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","O dzɛ yi iSaimɔn inggisɛ okyidɔ okpa, ngwu udɛ mgban dzɛ ondekyoo okwukwo nani.>> ");
INSERT INTO utr_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Onɔ ngwi ongyesɔ ngwu gbɔdzɛ yan na lu nɛ, iKɔnɛlu kwu engbidɔ mgban efa ela bɛyi inggisɛ oblakwutsɛ nli mio Imgbasho, di li onyi mbi ama ogban esɔ. ");
INSERT INTO utr_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","O nya ma alungwɔ nkyɔ duu man dɔ ma esɔ lu iJopa. ");
INSERT INTO utr_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Tegblifan ngwi onɔ dɔ idzidzɛ udɛ ngwi a le lu agaba ungwɔ ma di dzɛ kwɛkwɛ yi iJopa nɛ, iPyita dɔkɛ ikpendu oka bibɔ. ");
INSERT INTO utr_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Onyagleu dɔn o di mina ogye ungwogye. Ngwi a kale kyɔ ungwogye nɛ, o di inɛ odiidi. ");
INSERT INTO utr_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","O di esho kwulu a kye ungwɔ dafi akwukwɔ ogbada kye odi tsan mi okoko enɛ naan luba esɛ. ");
INSERT INTO utr_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Mi ifun ali itɔ mmbwaba afɔ enɛ, yi ungwɔ ama okwo ifu esɛ bɛyi ali itɔ ingwunɔ emi esho duu woto ele. ");
INSERT INTO utr_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Nɛ ela si nyan gbɛɛ, <<Kyato, iPyita. Ngwɔlu ma gye.>> ");
INSERT INTO utr_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","IPyita nu uka gbɛɛ, <<Otsɛ mi otsitsi yɔ ungwɔ ka dzɛ ngha gbɛ ba. Lubana ani gye ungwɔ onyi ntsiidza naadi le kpɛkpɛ ye ba.>> ");
INSERT INTO utr_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Ela na diyɛ nyan gbɛɛ, <<Ka kwu ungwɔ onyonyi ngwi Imgbasho kye mɛlu saan gbɛɛ ungwɔ idza ba.>> ");
INSERT INTO utr_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Ungwɔnɛ kyɔ ngha akpe eta, man a byakpa kyi kyelu akwukwɔ na lu esho. ");
INSERT INTO utr_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Ngwi iPyita kale tsɛwɛ ungwɔ ngwi inɛ odiidi nɛ tso nɛ, inggisɛ ama ngwu iKɔnɛlu dɔ ma esɔ ntona ka ye imbe ngwi udɛ iSaimɔn dzɛ man kwulɛsɛ tokɛ onufoka. ");
INSERT INTO utr_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","A kwu ela, byita gbɛɛ ni ama ye ni iSaimɔn ngwu a li kwun di iPyita na ka dzɛ mmana mayɔ. ");
INSERT INTO utr_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Dafi iPyita kale tsɛwɛ mi inɛ odiidi nɛ, Onodzi nyan gbɛɛ, <<iSaimɔn, inggisɛ eta to esɛ le pita abu ma. ");
INSERT INTO utr_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Nghanɛ tashulu lu ozu esɛ. Ka fwa owafɔ yi ama lu ba, ikyesinɛ li ani dɔ ma esɔ.>> ");
INSERT INTO utr_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","IPyita tashulu ka nya ma gbɛɛ, <<Li ani li inggisɛ ngwu ema le pitan mani. Ema ba li ɛkyɛ?>> ");
INSERT INTO utr_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","A gbɛɛ, <<iKɔnɛlu okwukwo ogbakwu dɔ eyi esɔ. O li inggisɛ osaan di li mio Imgbasho, ngwu emi iJuda duu li fwon. Ongyesɔ osaan nyan gbɛɛ no nu abu ba udɛ mgban adzi non fwo odzɛ ngwi abu ka gbɔ nyan mani.>> ");
INSERT INTO utr_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Nɛ iPyita gbɛ ma kaka udɛ dafi ingyoga mgban mani. Tegblifan nɛ iPyita kyato okyɛɛ yi ama, ama onoyɛyɛ angbeka mi iJopa kpaa di wafɔ yi ama. ");
INSERT INTO utr_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Ngwi egbe di fa nɛ, o kaka iSisiria. IKɔnɛlu kye inɛ kwo ofɛ le fɛ ma di kwu etɔ bɛyi abuge mgban duu kwakye. ");
INSERT INTO utr_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Dafi iPyita wa to udɛ ma nɛ, iKɔnɛlu wa kwɛsɛ mi iyayi mbon di sunun. ");
INSERT INTO utr_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Kpaa iPyita kye abɔ byun nyan gbɛɛ, <<kyato, ani kpaa li inggisɛ owamyɛ dafi abu.>> ");
INSERT INTO utr_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Ngwi iPyita kale gbɔdzɛ yan nɛ, iPyita lu idzidzɛ ozu ka di ibyi inggisɛ kwakye to. ");
INSERT INTO utr_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","O nya ma gbɛɛ: <<Ema ye saan ta gbɛɛ ola mgbi eyi fwa gbɛɛ inggisɛ emi iJuda no ka kwakye yi Udzengye hona kɛ ingyoga mi udan ba. Nghaduu Imgbasho tso ani gbɛɛ ni ani ka kwu inggisɛ owamyɛ gbɛɛ o le kpɛkpɛ hona tsiidza ba. ");
INSERT INTO utr_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Nghanɛ ngwi ema dɛsɔ mbi ani ma, ani tsondu ba ani ba. Ema dɛsɔ mbi ani li ali itɔdzɛ?>> ");
INSERT INTO utr_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","IKɔnɛlu nu uka gbɛɛ, <<Egbe enɛ inɛ waani ani wodzɛ ozu mbi ani le bibɔ mi obyi eta itɔ onɔ nɛni. Nɛta inggisɛ wo angwuto onzundzɛ kwɔkwɔ wa mblegba tu ani ");
INSERT INTO utr_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","<<Si gbɛɛ, <IKɔnɛlu Imgbasho fwo ibɔ mgbi abu di wɛ umba ngwi abu le gha emi adzɛ mani. ");
INSERT INTO utr_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Nghanɛ dɛsɔ kɛ iJopa mbi iSaimɔn ngwu a li kwun di iPyita nani. O kɛdzɛ ingyoga mi udɛ iSaimɔn inggisɛ nli kyidɔ okpa, ndzɛ ondekyoo okwukwo nani.> ");
INSERT INTO utr_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Man ani byakpa dɛsɔ mbi abu, i tishi dafi abu di ba mani. Onɛnɛ eyi duu kwakye mmɛnɛni mi inai Imgbasho ikye ofwo alungwɔ ngwi Imgbasho wo abu ola gbɛɛ ni abu nya eyi mani.>> ");
INSERT INTO utr_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","IPyita si wita ogbɔdzɛ gbɛɛ: <<Onɛnɛ ani difwi otsitsi gbɛɛ Imgbasho li tso osadu-sadu ba ");
INSERT INTO utr_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","kpaa li gbela yi inggisɛ mi ali agwɔ nli mion di kyungwɔ nli ayin mani. ");
INSERT INTO utr_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Ema ye esɔ ngwi Imgbasho dɔ mbi emi Israi, onya ma Esɔ Osuse mgbi iyu ngwi nyɛ mbi iYesu iKrestu, ongwu nli Otsɛ mgbi alungwɔ duu nani. ");
INSERT INTO utr_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Ema ye ungwɔ nkyɔ mi ikpɛsɛ iJudia duu, wita mi iGalalia mi onɔ ngwi iJɔn gbeesɔ mgbi iBatisima nyɛ ");
INSERT INTO utr_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","dafi Imgbasho kye engyie kyi iYesu ongwi iNadzareti ikye yi Onodzi Osaan bɛyi mfye, dafi o dile kyikyɛ kpatsɛ le kyungwɔ osuse dile ngyɛlu ama ngbeka woto abumfye mgbi onodzi ibwubwe duu ootse, ikyesinɛ Imgbasho dzɛ biyan. ");
INSERT INTO utr_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","<<Eyi li obwɛndɛ mi alungwɔ ngwi o kyɔ mi ɛsɛ iJuda bɛyi iJerosalin duu. A ngwɔn mi okyon gbokwo ekwatsi, ");
INSERT INTO utr_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","nghaduu Imgbasho kyilon mi ikwu mi egbe ongwu ta mani di nu ma dun. ");
INSERT INTO utr_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Li ali inggisɛ duu din ba, kpaa li ama Imgbasho sadulu ma mbi eyi ama ngye di wa yan mi onɔ ngwi o kyato mi ikwu ma li obwɛndɛ aali. ");
INSERT INTO utr_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","O wo eyi ola gbɛɛ ni eyi gbeesɔ nya inggisɛ di kyɔ obwɛndɛ gbɛɛ li ongwu ngwu Imgbasho dulu gbɛɛ ni ongwu li inggisɛ ogbɔ emi oshishe bɛyi emi ikwukwɔ ikwɔ. ");
INSERT INTO utr_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Oyegbɔ duu kyɔ obwɛndɛ mi ikyon gbɛɛ ali inggisɛ nnun oyɛyɛ duu a zanta yi alobube mi iyi mgban.>> ");
INSERT INTO utr_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Ngwi iPyita kale gbɔ elodzɛ ntonɛ nɛ, Onodzi Osaan kaka mbi ali inggisɛ ama nfwo esɔ na duu. ");
INSERT INTO utr_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","I kwulu emi iJuda ama nkyiikyɛ di noyɛyɛ wafɔ yi iPyita ma ewo dafi umba mgbi Onodzi Osaan kpaa a kye nu Udzengye mani. ");
INSERT INTO utr_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Lubana a fwo ma le gbɔ ondudzɛ angbeka dile tsɛ Imgbasho. Nɛta iPyita gbɛɛ, ");
INSERT INTO utr_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","<<Inggisɛ oka dzɛma nka fwa gbɛɛ nu ma ka kyɔ inggisɛ ntonɛ iBatisima mi eni ba gbɛɛ? Lubana a gbɛ Onodzi Osaan dafi eyi kpaa gbɛ nɛni.>> ");
INSERT INTO utr_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","IPyita nu ondu gbɛɛ nu ma kyɔ ma iBatisima mi iyi mgbi iYesu iKrestu. Nɛ a si nya iPyita gbɛɛ no dzɛ yi ama mi egbe gwee. ");
INSERT INTO utr_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Ama ogbikye iYesu bɛyi ama onoyɛyɛ angbeka mi iJudia duu fwo dafi Udzengye kpaa gbɛ elodzɛ Imgbasho mani. ");
INSERT INTO utr_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Dafi iPyita wa kaka iJerosalin nɛta, ama nnoyɛyɛ kyiikyɛ kwun shanyɛ ");
INSERT INTO utr_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","gbɛɛ, <<Abu ka kaka udɛ ama okyiikyɛ ba gye ungwogye yi ama.>> ");
INSERT INTO utr_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","IPyita wita di gbɔ alungwɔ duu nya ma klɛklɛ dafi i kyɔ mani: ");
INSERT INTO utr_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","<<Ani dzɛ igeli iJopa le bibɔ, ani nuna lu kpini si di inɛ odiidi. Ani di ungwɔ dafi akwukwɔ ogbada a kye odi tsan mi okoko enɛ kyɛ esho luba esɛ, di li imbe ani dzɛ ma yɛyɛ ngwi i ba. ");
INSERT INTO utr_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Ani winɛ kɛ ifun man di mmbwaba ama owo afɔ enɛ, mmbwaba ama okwukwo, mmbwaba ama okwo ifu esɛ, bɛyi ingwunɔ emi esho. ");
INSERT INTO utr_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Ta ani fwo ela le nya ani gbɛɛ, <Kyato iPyita, ngwɔlu ma gye.> ");
INSERT INTO utr_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","<<Ani nu uka gbɛɛ, <Otsɛ mi otsitsi yɔ ungwɔ ka dzɛ ngha gbɛ ba. Lubana ani gye ungwɔ onyi ntsiidza naadi le kpɛkpɛ ye ba.> ");
INSERT INTO utr_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","<<Ela na diyɛ nya ani gbɛɛ, <Ka kwu ungwɔ onyonyi ngwi Imgbasho kye mɛlu saan gbɛɛ ungwɔ idza ba.> ");
INSERT INTO utr_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Ungwɔnɛ kyɔ ngha akpe eta, man a di kyi kwolu yɛ lu esho. ");
INSERT INTO utr_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","<<Mi onɔ nata engyulɔ nghi eta ngwu a dɔ ma esɔ kyɛ iSisiria ba mbi ani wa kwulɛsɛ to udɛ ngwi ani ladzɛ mani. ");
INSERT INTO utr_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Onodzi nya ani gbɛɛ ni ani ka kwagbini owafɔ lu yi ama ba. Ama onoyɛyɛ nghi egyin ntonɛ kpaa tawo ani, ka kaka udɛ inggisɛ nani. ");
INSERT INTO utr_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","O nya eyi dafi ongyesɔ mblegba tu ongwu mi ozu mgban di gbɛɛ, <Dɛsɔ kɛ mbi iSaimɔn mi iJopa ngwu a li kwun di iPyita nani. ");
INSERT INTO utr_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","O ka nya abu esɔ ngwi abu yi etɔ mgbi abu duu ka watɔ mi ele mani.> ");
INSERT INTO utr_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","<<Dafi ani wita ogbɔdzɛ nɛ, Onodzi Osaan ba mboma dafi i teyi ba mbi eyi mi owita-wita nani. ");
INSERT INTO utr_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Ta ani wɛ odzɛ ngwi Otsɛ nose gbɔ mani, gbɛɛ: <iJɔn kyɔ iBatisima mi eni, kpaa a ka kyɔ ema iBatisima mi Onodzi Osaan.> ");
INSERT INTO utr_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Nghanɛ kini Imgbasho nu ma umba ungwonyi dafi o nu eyi ama nnoyɛyɛ mbi Otsɛ iYesu iKrestu nɛ ma, ani li emɛ mi onɔ na okye afɔ twɛsɛ fwa yi Imgbasho?>> ");
INSERT INTO utr_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Ngwi a fwo ungwɔnɛ nɛ, a kiyayi otangwodzɛ wuba man tsɛ Imgbasho, le gbɛɛ, <<Alima, Imgbasho gbela yi Udzengye kpaa odzita ma yi obube nu ma tu oshishe.>> ");
INSERT INTO utr_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Ikyenghanɛ, ama onoyɛyɛ nganya ikye ikwu iStivin nɛ, tse lu iFonishia, iSapru, bɛyi Antiɔku, le gbeesɔ nya emi iJuda yuoma kyoon. ");
INSERT INTO utr_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Angbeka mboma, dafi i dzɛ duu kpaa, a li emi iSapru bɛyi iSirini, lu Antiɔku ka wita ogbɔdzɛ yi emi iGriki kpaa, le nya ma Esɔ Osuse mgbi Otsɛ iYesu. ");
INSERT INTO utr_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Abumfye mgbi Otsɛ dzɛ yi ama, nɛ inggisɛ kwuba noyɛyɛ di kyata luba mbi Otsɛ. ");
INSERT INTO utr_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Odzɛ nɛ kaka adɔ mgbi emi okwakye mgbi emi iKrestu mi iJerosalin, man a dɔ iBanabasi esɔ kɛ Antiɔku. ");
INSERT INTO utr_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Ngwi o ka kaka di di dafi Imgbasho kye mse bɛ inggisɛ ntona ewo nɛ, atsa tsan o di fyuma mfye itukwu duu gbɛɛ nu ma kwulɛsɛ mi otsitsi mbi Otsɛ yi itukwu mgbi ama duu. ");
INSERT INTO utr_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Lubana iBanabasi li inggisɛ osuse, di mbwo yi Onodzi Osaan bɛyi oyɛyɛ onuunu. Ikyenghanɛ inggisɛ kwuba luba mbi Otsɛ. ");
INSERT INTO utr_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Nɛ iBanabasi kɛ iTasu oka pita iSol, ");
INSERT INTO utr_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","ngwi o ka tun nɛ, o kyon luba Antiɔku. Mi onova na duu iBanabasi yi iSol li kwakye yi okwakye mgbi emi iKrestu di tso ibyi inggisɛ kpakpa ungwɔ. Li mi Antiɔku ababɔ ngwi a wita okwu ama okyɛdɔ iYesu di emi iKrestu. ");
INSERT INTO utr_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Mi onɔ nɛ oyegbɔ angbeka kyɛ iJerosalin bato Antiɔku. ");
INSERT INTO utr_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Onyi mboma, ngwu iyin di Agabu, kyato gbɛɛsɛ nyɛ mi Onodzi gbɛɛ onikyenbwa ka gbo kpatsɛ ɛsɛ iRoma. (Ungwɔnɛ kyɔ mi onɔ ngwi iKladiɔsu li utɔ.) ");
INSERT INTO utr_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Ama okyɛdɔ iYesu mi Antiɔku kye ali itɔ oyabɔ ngwi ama dzɛyan duu dɛsɔ nu emi ongwunɔ ma mi iJudia. ");
INSERT INTO utr_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Ungwɔ ngwi a li kyɔ yɔ, a li kye umba mgbi ama dɛsɔ nyɛ mbi iBanabasi yi iSol kɛ mbi engyukwo mgbi ama mi iJerosalin. ");
INSERT INTO utr_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Li mi itɔnɔ nɛ ngwi utɔ iHerude wita obwa emi iKrestu angbeka, yi oweka onu ma isɔ. ");
INSERT INTO utr_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","O teyi ngwɔ iJɛnsi ongwunɔ iJɔn mi okwusunkli. ");
INSERT INTO utr_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Ngwi o di gbɛɛ i kpa emi iJuda nɛ, o kiyayi di bwa iPyita kpaa. Ungwɔnɛ kyɔ mi onɔ mgbi ibredi ngwi a li kye okwuna wele ba nani. ");
INSERT INTO utr_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Dafi o bwan nɛ, o kyon wokɛ obawi di kyon dɔ ama ongyoongyo ubɔ, oblakwutsɛ eneenɛ mi otsa enɛ duu. IHerude dzɛ yi oweka owa dulun tɔ ba wa gbɔn ikwɔ mi ododa mi onɔ ngwi oga owɛ owatɔ-watɔ mgbi emi Israi ngyɛ mani. ");
INSERT INTO utr_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","IPyita tila wodzɛ obawi, kpaa okwakye mgbi emi iKrestu yɔ le bibɔ mi itukwu onyi mbi Imgbasho ikyon. ");
INSERT INTO utr_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Mi obwi egbe ngwi iHerude ka kyon tɔ wa gbɔn ikwɔ ma, iPyita la le nuna mi idzidzɛ oblakwutsɛ nghi efa, a bwan adi agya efa, ama ongyoongyo di to onufɛ okakaakaka. ");
INSERT INTO utr_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Plɛ nɛta ongyesɔ mgbi Otsɛ wa mblegba tu ma ta obawi si gbosa. O kye abɔ mu iPyita mi agya kyilen una, o nyan gbɛɛ, <<Kyato Plɛ!>> Man ashi ntona shɛ lon mi owashi abɔ yangwuta. ");
INSERT INTO utr_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Ongyesɔ na si nyan gbɛɛ, <<Gbe angwuto mgbi abu wo bɛyi okpafɔ.>> IPyita si kyɔ ngha. Ongyesɔ na di nyan gbɛɛ, kye angwuto ofu mgbi abu tukwu kyɛdɔ ani. ");
INSERT INTO utr_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","IPyita kyɛdɔn tasɛ mi obawi, kpaa i gbosa lon gbɛɛ ungwɔ ngwi ongyesɔ le kyɔ na li otsitsi ba, o tsɛwɛ gbɛɛ ongwu le woowo elela. ");
INSERT INTO utr_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","A nyɛ imbe ongyoongyo ongwi ababɔ bɛyi ongwu fan, di wa to onufɛ ashashi ntɔ lu ogalu nani. I kwulu ewon, man a nyɛ ele tasɛ. Ngwi a kyikyɛ lu byulu nɛ, ongyesɔ na byulu dzanta. ");
INSERT INTO utr_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Nɛta iPyita difwi di gbɛɛ, <<Onɛnɛ ani ye yɛyɛ gbɛɛ Otsɛ dɔ ongyesɔ mgban gbɛɛ no wa dulu ani tɔ mi abumfye mgbi iHerude bɛyi alungwɔ ngwi emi iJuda le tsɛwɛ ikye ani duu.>> ");
INSERT INTO utr_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Ngwi o wa difwi ungwɔnɛ nɛ, o lu udɛ iMeri onɔ iJɔn, ngwi a di li kwun gbɛɛ iMaki, imbe ngwi ibyi inggisɛ kwakye to dile bibɔ. ");
INSERT INTO utr_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","IPyita tsaabɔ mi onufɛ ongwi esɛ, man ongwongyiidɔ ngwu iyin di iRoda ba owa ye inggisɛ ndzɛ onufɛ mani. ");
INSERT INTO utr_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Ngwi o difwi ela mgbi iPyita nɛ, atsa atsan nyɛsɛ o kwulu ofɛ wuba kpaa yɛ tsinya lu dile kwu-ela gbɛɛ, <<iPyita dzɛ onufɛ ma!>> ");
INSERT INTO utr_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Kpaa a nyan gbɛɛ, <<O dzɛ yi ikye yɛyɛ ba.>> Dafi o kale kiyayi gbɛɛ di li otsitsi nɛ, a nyan gbɛɛ, <<Ka li ongyesɔ mgban kyɛmɛ.>> ");
INSERT INTO utr_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Nghaduu iPyita yɔ kale tsaabɔ kpɔɔ ma, ngwi a wa kye kwulu ofɛ nɛ, a din man i kwulu ma ewo. ");
INSERT INTO utr_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","IPyita kyɔ ma abɔ gbɛɛ nu ma dede si tsuutsa dafi Otsɛ dulu ongwu tɔ mi obawi mani. O di gbɛɛ, <<Nya iJɛnsi bɛyi ama onoyɛyɛ odzɛ mi ungwɔnɛni.>> Nɛman o si lu imbe oka. ");
INSERT INTO utr_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Ngwi egbe fa nɛ, ɛndɛ olɛlɛ efu ba dzɛ mi idzidzɛ ama oblakwutsɛ mi ungwɔ nkyɔ yi iPyita nani. ");
INSERT INTO utr_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Ngwi iHerude gbilin kpatsɛ din ba nɛ, o diyɛ kya mbi ama ongyoongyo ntonani si nu ondu gbɛɛ nu ma ngwɔ ma. Nɛ iHerude kyɛɛ mi iJudia lu iSisiria ka kye egbe gwee mi ele. ");
INSERT INTO utr_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","IHerude teyi dzɛ yi odzɛ oshiishi yi emi iTiru bɛyi iSidon; a yɛ kwakye yi ewoma di pita ofɛ ogbɔdzɛ yan. Ngwi a tu oyabɔ mgbi iBlastu, ongbidɔ mgbi utɔ yuon ngwu a nun oyɛyɛ nɛ, a kɛ mbi utɔ ka pita iyu, ikyekyɛ li ɛsɛ mgbi utɔ na li nu ma ungwogye. ");
INSERT INTO utr_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Mi egbe ngwi a kye dzɛ ma, iHerude gbe angwuto mgban mgbi utɔ wo ewo, sɔkɛ itsuutɔ mgban man gbɔdzɛ yi ama mi ododa. ");
INSERT INTO utr_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","A wulu gbɛɛ, <<Nɛnɛ li ela mgbi Imgbasho li mgbi inggisɛ ba.>> ");
INSERT INTO utr_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Ikyegbɛɛ iHerude tsɛ Imgbasho ba nɛ, Ongyesɔ mgbi Otsɛ tan afɛ, ta o gbaangbi byakpa kwulu. ");
INSERT INTO utr_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Nghaduukpaa elodzɛ mgbi Imgbasho kiyayi osheeshe di gbɔfwɛ. ");
INSERT INTO utr_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Ngwi iBanabasi bɛyi iSol ngyɛlu ungwɔ ngwi a kɛ ma nɛ, a yɛ mi iJerosalin, a kye iJɔn ngwu a li kwun di iMaki na wafɔ yi ama. ");
INSERT INTO utr_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Mi okwakye mgbi emi iKrestu mi Antiɔku ma, ama ogbɛɛsɛ yi etsetse to ele; li iBanabasi yi iSimiɔn ngwu a li kwun di iNaija bɛyi iLushɔ ongwi iSirini yi iMane (ongwu nshe bɛyi iHerude iGɔna nani) yi iSol. ");
INSERT INTO utr_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Ngwi a tole sunu Otsɛ dile tukwondu nɛ, Onodzi Osaan gbɔ yi ama gbɛɛ, <<Dulu iBanabasi yi iSol dzɛkɛ idzidza mi ikye idɔ ngwi ani kwu ma ela ikyon mani. ");
INSERT INTO utr_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Ngwi a tukwondu diyɛ bibɔ nɛta, a gbe abɔ dɔ ma ikye di wo ma ofɛ lu. ");
INSERT INTO utr_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Ngwi Onodzi Osaan dɔ ma esɔ nɛ, iBanabasi yi iSol byi ofɛ abɔ lu ka kaka iSelushia si kaka uwaa dzɛkyo lu ibu ongwi iSapru. ");
INSERT INTO utr_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Ngwi a wa to iSalami nɛ, a gbeesɔ mgbi Imgbasho mi ozu okwakye mgbi emi iJuda. IJɔn iMaki kyɛ yi ama le tobyi ma. ");
INSERT INTO utr_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","A kyikyɛ kpatsɛ ibu na nghataa wa kaka iPafosu. Mi imbe nɛ a kpatsɛ yi inggisɛ iJuda otseefa di li oyegbɔ atsika ngwu iyin di iBa-iYesu, ");
INSERT INTO utr_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","nli kyɛ yi iSejiɔ iPaɔlɔsu iGɔna ongwi ibu nani. IGɔna na, li inggisɛ ndzɛ yi ozoyeye saan, o dɛsɔ mbi iBanabasi yi iSol ikyekyɛ o mina ofwo elodzɛ Imgbasho. ");
INSERT INTO utr_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Kpaa Elimasi inggisɛ otseefa na (bana li ita iyi mgban aali) kaka ma idzidzɛ fwa yi iGɔna na gbɛɛ no ka noyɛyɛ mi odzɛ ngwi iBanabasi yi iSol le gbɔ na ba. ");
INSERT INTO utr_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Nɛ iSol, ngwu iyin oka di iPol, nmbwo yi Onodzi Osaan na tongwinɛ byi Elimasi nyan gbɛɛ, ");
INSERT INTO utr_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","<<Abu ongwɛ owapɛ olodu nli ongyikyili mgbi alungwɔ osuse duu nɛ! Abu mbwo yi ali ɛwɛ yi okpagyewo duu. Abu ka nya ombe ofɛ mgbi Otsɛ nli ayin nɛ lo? ");
INSERT INTO utr_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Nghanɛ abɔ mgbi Otsɛ kpakli abu wa. O ka binɛ, mi ongwonɔ gwee o ka di osa mgbi onɔ ba.>> Ntunto nɛta inɛ tuubu lon man o yɛɛ pwaapwa dile mina inggisɛ nka kwon abɔ tɔ mani. ");
INSERT INTO utr_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Ngwi iGɔna di ungwɔ nkyɔ nɛ, o noyɛyɛ, bana i kwulun ewo mi otsootso odzɛ mgbi Otsɛ. ");
INSERT INTO utr_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","IPol yi emi afokyɛɛ mgban kaka uwaa mi iPafosu luba iPega, igeli mi iPamfyilia, li imbe na ngwi iJɔn ngwu iyin oka di iMaki na dzita ma yɛ lu iJerosalin aali. ");
INSERT INTO utr_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Mi iPega ma, a kyato lu Antiɔku ongwi iPisidia. Mi egbe otonyewo nɛ, a kaka ozu okwakye mgbi emi iJuda di sisɛ. ");
INSERT INTO utr_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Onɔ ngwi a gbɔ mi afɛ mgbi Ola mgbi iMose bɛyi afɛ mgbi emi Oyegbɔ nyɛ nɛta, ama odi mi ozu okwakye mgbi emi iJuda na dɛsɔ mboma gbɛɛ, <<Emi ongwunani, ni ema dzɛ yi esɔ mgbi onu itukwu ofyumfye-fyumfye ikye inggisɛ ntonɛ yɔ, gbɔ na.>> ");
INSERT INTO utr_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","IPol dzɛkunto kyɔ ma abɔ si gbɛɛ: <<Emi Israi bɛyi Udzengye ama osunu Imgbasho, gadɔ mbi ani na! ");
INSERT INTO utr_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Imgbasho mgbi emi Israi dulu emi otseyi; o nu ma okiyayi mi onɔ ngwi a to Igyibiti mani, mi abumfye odatu o dulu ma tɔ mi ɛsɛ nani, ");
INSERT INTO utr_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","o shitukwu yi okyɔɔkyɔ mgbi ama mi afutse onova ngwusefa, ");
INSERT INTO utr_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","di dzili agwɛɛsɛ egyafa mi iKana kye ikpɛsɛ mgbi ama kye nu emidi ongwu no yɛɛ okwudɛ mgbi ama. ");
INSERT INTO utr_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Ungwɔ ntonɛ duu kye mɛ onova ideli enɛ ngwusefa dɔn iwyo. <<Ngwi ungwɔnɛ kyɔ nyɛ nɛ, Imgbasho gbe ama ogbiikwɔ nu ma nghataa ba onɔ mgbi oyegbɔ iSamue. ");
INSERT INTO utr_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Nɛ inggisɛ ntona si mina utɔ, man Imgbasho kye iSol ongwɛ iKish, mi udzɛ mgbi iBenjamin nu ma, o sɔ utɔ onova ngwusefa. ");
INSERT INTO utr_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Ngwi o wa dulu iSol utɔ nɛ, o nu iDevedi yɛɛ utɔ mgbi ama. O kyɔ obwɛndɛ ikyon gbɛɛ: <Ani tu iDevedi ongwɛ iJese inggisɛ ongwi itukwu mgbi ani, o ka kyɔ alungwɔ duu ngwi ani mina gbɛɛ no kyɔ mani.> ");
INSERT INTO utr_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","<<Mi etɔ mgbi inggisɛ nɛ, Imgbasho kye ongye Onagbɛ iYesu nu emi Israi, dafi o zondu mani. ");
INSERT INTO utr_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Duuse ni iYesu wita idɔ yɔ, iJɔn gbeesɔ okyatitukwu bɛyi iBatisima nya ali inggisɛ duu mi Israi. ");
INSERT INTO utr_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Ngwi iJɔn le ngyɛlu idɔ mgban nɛ, o byi ma gbɛɛ: <Ema tsɛwɛ gbɛɛ ani li emɛ? Ani li ongwu ma ba. Ei, o kyɛma mi iyikpa ani, odi okpafɔ mgban kpaa ani mɛ oshɛ ba.> ");
INSERT INTO utr_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","<<Emi ongwunani, engwɛ Abrahan, bɛyi Udzengye ama omio Imgbasho, li ikye mgbi eyi ngwi a kye esɔ mgbi owatɔ-watɔ nɛ ba aani. ");
INSERT INTO utr_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Inggisɛ emi iJerosalin bɛyi ama ogbe ma teyi difwi itɔ inggisɛ ngwu iYesu dzɛ ma ba, kpaa mi ongwɔn ikwɔ yɔ, a mbwumbwo ungwɔ ngwi ama ogbɛɛsɛ li tsekise gbɔ mi alegbe otonyewo mani. ");
INSERT INTO utr_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Dafi a tu itɔdzɛ nmɛ ongwɔn ba nɛ kpaa, a nya iPlatu gbɛɛ no nu ondu nu ma ka ngwɔn. ");
INSERT INTO utr_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Ngwi a kyi kyɔlu alungwɔ ngwi a lɔ ikpewon duu ma ngyɛ nɛ, a tashulun mi ekwatsi di kyon ndzi. ");
INSERT INTO utr_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Nghaduu Imgbasho kyilon mi ikwongye, ");
INSERT INTO utr_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","egbe ibyibyi ama nwafɔ yan mi iGalalia kɛ iJerosalin ma din. A li obwɛndɛ mgban mbi emideyi onɛnɛni. ");
INSERT INTO utr_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","<<Eyi le nya ema Esɔ Osuse nɛni: Li ungwɔ ngwi Imgbasho zondu yi emi otseyi ");
INSERT INTO utr_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","o mbwumbwo ikye eyi emi ongwama, mi okyile iYesu mi ikwongye. Dafi a tsekise lɔn mi afɛ mgbi ashi ongwu fan mani gbɛɛ: << <Abu li Ongwani; inɛ nɛ ani yɛɛ Otsabu.> ");
INSERT INTO utr_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Ikyegbɛɛ Imgbasho kyilen mi ikwu, dika non bwa ba nɛ kpaa, a lɔn mi elodzɛ ntonɛni gbɛɛ: << <N ka kye ondu odzɛɛdzɛ osaan bɛyi mse ingblimɔ ngwi ani teyi dzɛ yi iDevedi ma nu abu.> ");
INSERT INTO utr_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Li ngha ngwi a lɔ imbe oka gbɛɛ: << <Abu ka nu Ongwabu Osaan mbee ba aali.> ");
INSERT INTO utr_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","<<Lubana ngwi iDevedi kyɔ oweka mgbi Imgbasho ngyɛ duu nɛ, o kwulu; a kyon ndzi yi emi otsɔn ikpewo mgban bwa. ");
INSERT INTO utr_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Nghaduu ongwu Imgbasho kyilon mi ikwu na bwa ba. ");
INSERT INTO utr_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","<<Ikyenghanɛ, emi ongwunani, i mina ani gbɛɛ ni ema ye gbɛɛ li ikpewo iYesu ngwi a gbeesɔ odzita inggisɛ yi ali ibwubwe nya ema aani. ");
INSERT INTO utr_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Mi ikpewon ali inggisɛ ngwu noyɛyɛ duu gye emyɛmyɛ, ola mgbi iMose yagba kyungwɔnɛ ba. ");
INSERT INTO utr_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Gbɛwɛbyi ni ungwɔ ngwi ama ogbɛɛsɛ gbɔ ntona no ka kyɔ ema ba ungwɔ ama ngbɛɛ: ");
INSERT INTO utr_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","<< <Dii, ema ama ogbɔ agya, kwu Imgbasho shanyɛ ntonɛ, ka kwulu ema ewo, ema dika dzili. Ani ka kyungwɔ mi egbe mgbi ema ngwi ema ka noyɛyɛ ba yeba ni inggisɛ nyaanya ema kpaa.> >> ");
INSERT INTO utr_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Dafi iPol yi iBanabasi le dzita ozu okwakye mgbi emi iJuda nɛ, inggisɛ ntona bɔ ma gbɛɛ nu ma di wa gbɔdzɛ mi itɔdzɛ ntonɛ mi egbe otonyidɔ nkyɛ nɛni. ");
INSERT INTO utr_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Onɔ ngwi a ngyɛlu okwakye nɛ, emi iJuda ibyibyi bɛyi ama nkyata le sunu odzɛ Imgbasho mgbi emi iJuda ma, kyɛdɔ iPol yi iBanabasi, a gbɔdzɛ yi ama di nu ma itukwu ofyumfye-fyumfye gbɛɛ nu ma kiyayi odzɛ mi elela mgbi Imgbasho. ");
INSERT INTO utr_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Mi egbe otonyidɔ ngbɔdɔ ma, i dzɛ dafi inggisɛ mi ogalu duu kwakye ikye ofwo elodzɛ mgbi Otsɛ mani. ");
INSERT INTO utr_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Ngwi emi iJuda di ibyi inggisɛ ntona nɛ, a kaka uwaba dile fyito mi odzɛ ngwi iPol le gbɔ mani. ");
INSERT INTO utr_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Nɛ iPol yi iBanabasi nu ma uka yi abɔ otsigɛgɛ gbɛɛ: <<Dzɛ gyɔ ngwi eyi kika gbɔdzɛ Imgbasho nya ema ababɔ. Kpaa ngwi ema fwan di kye ewema wuuta otu oshishe igyegwu ba nɛ, eyi yile inɛ byi Udzengye onɛnɛni. ");
INSERT INTO utr_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Lubana nɛnɛ li ungwɔ ngwi Otsɛ wo eyi ola mi ele aani gbɛɛ: << <Ani nu abu li osa mbi Udzengye, ikyegbɛɛ ni abu kye esɔ mgbi owatɔ-watɔ kpatsɛ ɛsɛ.> >> ");
INSERT INTO utr_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Onɔ ngwi Udzengye fwo odzɛ nɛ nɛ, ewo shɛta lo ma a di kye mmwɛ nu elodzɛ mgbi Otsɛ; ama ngwu a di sadu ma ikye oshishe igyegwu duu noyɛyɛ. ");
INSERT INTO utr_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Elodzɛ mgbi Otsɛ si gbɔfwɛ kpatsɛ ayɛsɛ na duu. ");
INSERT INTO utr_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Nghaduu emi iJuda kaka mbi engyaa ama omio Imgbasho ama nle kpɔngɔ bɛyi inggisɛ ama ogbe inggisɛ teyi mi ogalu nani. A nu ma wita eye yi iPol bɛyi iBanabasi, di lɔ ma onya tɔ mi ayɛsɛ nani. ");
INSERT INTO utr_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Nghanɛ a kyi gbolu ombulu mi afɔ mgbi ama dafi a gbela yi ama ba mani, ta a si lu iKonu. ");
INSERT INTO utr_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Man engwafɔ si mbwo yi atsa bɛyi Onodzi Osaan. ");
INSERT INTO utr_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","IPol yi iBanabasi ka kaka ozu okwakye mgbi emi iJuda mi iKonu dafi a teyi li kyɔ mani. Mi ele ma a gbeesɔ saan ta mmbwo inggisɛ kwuba mi iJuda bɛyi Udzengye onoyɛyɛ. ");
INSERT INTO utr_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Kpaa emi iJuda ama nfwa onoyɛyɛ ntona kwo Udzengye ntona wo nu ma kyitingga yi iPol bɛyi iBanabasi. ");
INSERT INTO utr_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Nghanɛ iPol yi iBanabasi kye onɔ kpakpa mi ele, le gbɔdzɛ mgbi Otsɛ mi ododa. Otsɛ tso gbɛɛ esɔ mgbi elela mgban na li otsitsi mi onu ma mfye okyungwɔ bɛyi ambɛ ama okwulewo. ");
INSERT INTO utr_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Emi ogalu na gheefa, angbeka yɛ agya mgbi emi iJuda, angbeka yɛ agya mgbi ama ogbikye iYesu. ");
INSERT INTO utr_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Ta Udzengye yi emi iJuda bɛyi engyukwo mgbi ama duu, wibu onu iPol bɛyi iBanabasi adzɛ di tsɛ ma akwutsɛ. ");
INSERT INTO utr_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Nghaduu ngwi a wa ye odzɛ ele nɛ a tsinya lu iLikonia igeli mgbi iListra bɛyi iDebe bɛyi ɛsɛ ama nkpakɛkɛ won, ");
INSERT INTO utr_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","dika gbeesɔ osuse mi imbe ntonani. ");
INSERT INTO utr_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Inggisɛ oka dzɛ iListra waawaa afɔ, tummya kyɛ ifu di kyikyɛ ye ba. ");
INSERT INTO utr_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","O kye adɔ ge le fwo iPol dafi o le gbɔdzɛ mani. IPol kye inɛ byin yɛyɛ, difwi gbɛɛ o dzɛ yi oyɛyɛ onuunu ongyɛlun ootse, ");
INSERT INTO utr_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","si kwu ela tɔ gbɛɛ, <<Kyato dzɛkunto mi afɔ mgbi abu!>> Mi elodzɛ nɛ, inggisɛ na ta lu esho si wita okyikyɛ. ");
INSERT INTO utr_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Onɔ ngwi ibyi ntona di ungwɔ ngwi iPol kyɔ nɛ, a wulu mi ondu iLikonia gbɛɛ, <<Imgbasho gbeka ba mbi eyi mi odzɛɛdzɛ mgbi inggisɛ owamyɛ wa!>> ");
INSERT INTO utr_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","IBanabasi a kwun gbɛɛ iDzeu, a di kwu iPol gbɛɛ iHɛmɛ ikyesinɛ o li inggisɛ oteyi odzɛ ogbɔɔgbɔ. ");
INSERT INTO utr_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Ta inggisɛ ofifɛ mgbi imgbasho mgbi iDzeu, ngwu ozu ofifɛ mgban dzɛ kyila yi igeli okwukwo nani, ba yi engyulumnda bɛyi ofumbu wa to onufɛ ogalu igeli ikyesinɛ ongwu bɛyi ibyi inggisɛ ntona mina ofifɛ nu iPol bɛyi iBanabasi. ");
INSERT INTO utr_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Nghaduu ngwi iPol yi iBanabasi fwo ungwɔnɛ nɛ, a fawa angwuto mgbi ama tsinya kaka idzidzɛ ibyi inggisɛ, le weela gbɛɛ: ");
INSERT INTO utr_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","<<Engyulɔ, kyɔsinɛ ngwi ema le kyungwɔnɛ nghaa? Eyi kpaa li inggisɛ owamyɛ ta dafi ema mani. Eyi kye esɔ osuse nɛ le wa nu ema, le nya ema gbɛɛ ni ema kyata mi ayayi ungwɔ ntonɛni luba mbi Imgbasho oshishe, ongwu nta esho yi esɛ bɛyi ekyoo okwukwo bɛyi alungwɔ ama nto efu duu nani. ");
INSERT INTO utr_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Tugbe ma, Imgbasho li nu ali ɛsɛ duu kyɔ owitukwu mgbi ama. ");
INSERT INTO utr_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Nghaduu o li nya okye ewon tso ma ba. O tso ema mse mgban mi onu ema mmbwo di nu etɔ ungwogye she mi onɔ mgban; o nu ema ungwogye kpakpa di mbwo ema yi atsa mi itukwu.>> ");
INSERT INTO utr_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Yi elodzɛ ntonɛ duu kpaa, i fyi ma mfye okwɔ ibyi inggisɛ ntona ofifɛ nu ma. ");
INSERT INTO utr_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Ta emi iJuda angbeka kyɛ mi Antiɔku bɛyi iKonu wa kwolu ibyi inggisɛ luba agya mgbi ama. Nɛ a tsɛ iPol akwutsɛ di kwon tasɛ mi ogalu nani, le tsɛwɛ gbɛɛ o kwulu. ");
INSERT INTO utr_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Kpaa ngwi engwafɔ wa kpakɛkɛ won nɛ, o kyato diyɛ lu ogalu nani. Tegblifan ma ongwu bɛyi iBanabasi dzata imbe na lu iDebe. ");
INSERT INTO utr_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","A gbeesɔ osuse mi igeli okwukwo nani di tu inggisɛ ama onoyɛyɛ kwuba. Man a yɛ lu iListra, iKonu bɛyi Antiɔku, ");
INSERT INTO utr_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","a yile engwafɔ dzɛ ofɛ di kwu ma ɛwɛwo gbɛɛ nu ma noyɛyɛ mi otsitsi. A di nya ma gbɛɛ, <<Eyi ka nyɛ mi adzɛ kpakpa ikye okaka esutɔ mgbi Imgbasho.>> ");
INSERT INTO utr_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","IPol bɛyi iBanabasi dulu engyukwo nu ma mi ali okwakye mgbi emi iKrestu duu, yi ibɔ obɔɔbɔ bɛyi ondu otukwu-tukwu, a kye ma dubɔ Otsɛ, ongwu a kye oyɛyɛ onuunu mgbi ama byi mbon nani. ");
INSERT INTO utr_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","A nyɛ ongwi iPisidia, a wa kaka iPamfyilia, ");
INSERT INTO utr_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","ngwi a gbeesɔ mi iPega ngyɛ nɛ, a kye ikye dɔ lu Atalia. ");
INSERT INTO utr_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Mi Atalia ma a dzɛkyo mi uwaa yidɔ lu Antiɔku, imbe ngwi a kye ma dubɔ elela mgbi Imgbasho mi ikye idɔ ngwi a kyɔ ngyɛ nani. ");
INSERT INTO utr_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Ngwi a kaka imbe na ma, a gbe emi iKrestu kwakye mbonyi di nya ma alungwɔ ngwi Imgbasho kyɔ nyɛ mbi ama, dafi o di kwulu ofɛ mgbi oyɛyɛ onuunu mbi Udzengye kpaa mani. ");
INSERT INTO utr_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","A si dzɛ yi engwafɔ mi imbe na onɔ tunto. ");
INSERT INTO utr_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Inggisɛ angbeka kyɛ mi iJudia wa kaka Antiɔku man le tso ama onoyɛyɛ ntona gbɛɛ: <<Sede a ka kyɛ ema ikyɛ mi otsootso mgbi iMose bayɔ, ema ka yagba otu owatɔ-watɔ ba.>> ");
INSERT INTO utr_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Mi odzɛ nɛ iPol bɛyi iBanabasi si kaka angwodzɛ ota-ta yi ama kpakpa. Ta a si dulu iPol yi iBanabasi, bɛyi ama onoyɛyɛ angbeka, gbɛɛ nu ma lu iJerosalin ka di ama ogbikye iYesu bɛyi engyukwo mi odzɛ nɛni. ");
INSERT INTO utr_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Opokwakye mgbi emi iKrestu dɔ ma esɔ nu ma byi ofɛ abɔ, dafi a kyikyɛ nyɛ iFonishia bɛyi iSamaria nɛ, a gbɔ dafi Udzengye kpaa kyata yɛ luba mbi Imgbasho mani. Elodzɛ nɛ nu ama onoyɛyɛ duu ewo oshɛta kpaakpaa. ");
INSERT INTO utr_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Ngwi a wa kaka iJerosalin nɛ, okwakye mgbi emi iKrestu yi ama ogbikye iYesu bɛyi engyukwo duu gbɛ ma, nɛta a nya ma alungwɔ ngwi Imgbasho kyɔ nyɛ mbi ama duu. ");
INSERT INTO utr_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Ta ama onoyɛyɛ angbeka ama ndzɛ agya mgbi emi iFarasi ma kyɛɛ tokɛ unto si gbɔgbɛɛ, <<Li kyɛmɛ-kyɛmɛ ngwi a ka nu Udzengye kyiikyɛ, di ngyo ola mgbi iMose.>> ");
INSERT INTO utr_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Nghanɛ ama ogbikye iYesu bɛyi engyukwo kyi ikye kwokyi yi ewoma ikye odi mi odzɛ nɛni. ");
INSERT INTO utr_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Ngwi a gbɔdzɛ kpakpa nɛ, iPyita kyɛɛ unto si gbɔdzɛ yi ama gbɛɛ, <<Emi ongwunani, ema ye dafi mi onɔ ama nyɛ ma Imgbasho dulu ani mi idzidzɛ ema ogbɔ Esɔ Osuse mi ondu mgbi ani ni Udzengye fwo di noyɛyɛ mani. ");
INSERT INTO utr_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Imgbasho n ye itukwu mgbi inggisɛ duu ma, tso gbɛɛ di ongwu gbɛ Udzengye mi okye Onodzi Osaan nu ma, yɛyɛ dafi o kyɔ yi eyi nɛni. ");
INSERT INTO utr_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","O tso idzidza mgbi eyi yi ama ba, lubana o salu ma itukwu yɛɛ saan ikyekyɛ a noyɛyɛ. ");
INSERT INTO utr_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Nghama, kyɔsinɛ ngwi ema le fya ombadi Imgbasho mi okye okye egyeegyɛ ngwi eyi naadi emi otseyi yagba okye ye ba kye dɔ engwafɔ ikye? ");
INSERT INTO utr_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Ei! Eyi noyɛyɛ gbɛɛ li mi elela mgbi Otsɛ mgbi eyi iYesu ngwi a dulu eyi tɔ, dafi ama kpaa a dulu ma tɔ nani.>> ");
INSERT INTO utr_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Okwakye na duu zumyɛ le gadɔ mbi iPol bɛyi iBanabasi dafi a le nya ma odzɛ ungwɔ ama okwulewo bɛyi ambɛ ama ngwi Imgbasho kyɔ yi Udzengye nyɛ mbi ama mani. ");
INSERT INTO utr_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Onɔ ngwi a ngyɛ nɛ, iJɛnsi gbɔdzɛ tɔ gbɛɛ: <<Engwunani, gadɔ mbi ani na. ");
INSERT INTO utr_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","ISaimɔn tsuutsa nya eyi dafi mi ababɔ ma Imgbasho tso oweka mgban mi odulu Udzengye angbeka nu ma yɛɛ emidan mani. ");
INSERT INTO utr_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Elodzɛ mgbi ama ogbɛɛsɛ kpaa kwokyi yi ungwɔnɛ, dafi a lɔ mi Afɛ mani gbɛɛ: ");
INSERT INTO utr_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","<< <Ni ungwɔnɛ nyɛ ani ka yidɔ di yile esutɔ mgbi iDevedi sisɛ. Ikpishi mgban ani ka yilen mbɛ, dika non dzɛ mi odzɛɛdzɛ mgban, ");
INSERT INTO utr_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","adzi ni inggisɛ owamyɛ ama nsisi duu pita Otsɛ, bɛyi Udzengye ama ndzɛ yi iyi mgbi ani duu, li ngha ngwi Otsɛ nkyungwɔ ntonɛnɛ gbɔ aali> ");
INSERT INTO utr_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","ungwɔna a teyi yen mi owita-wita mgbi ɛsɛ majo. ");
INSERT INTO utr_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","<<Nghanɛ, ani le ngyɛlu gbɛɛ, ni eyi ka non yɛɛ okye mbi Udzengye ama nle kyata luba mbi Imgbasho ba. ");
INSERT INTO utr_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Tatase ni eyi lɔ ma afɛ, nya ma nu ma dulu abɔ mi ungwogye ngwi a kye fifɛ nu angwula, mi amah idza, mi mmbwɛ mmbwaba ngwi a tsili-tsili ma onbukwɔ bɛyi mi ali eyi duu. ");
INSERT INTO utr_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Lubana a gbɔ ola mgbi iMose mi ali ogalu onɔ kɛ di gbɔn mi imbe okwakye mgbi emi iJuda ali egbe otonyewo duu.>> ");
INSERT INTO utr_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Ta ama ogbikye iYesu yi engyukwo, bɛyi okwakye mgbi emi iKrestu olɔlɔ duu, bwondu dulu emidama angbeka di dɔ ma esɔ lu Antiɔku yi iPol bɛyi iBanabasi. A dulu iJuda (ngwi a li kwun gbɛɛ iBasaba) bɛyi iSaila, inggisɛ efa ntonɛ a nu ma mmwɛ kpaakpaa mi idzidzɛ mgbi ama onoyɛyɛ. ");
INSERT INTO utr_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","A kye afɛ ntonɛ dɔ ma esɔ a lɔ mi ele gbɛɛ: Ama ogbikye iYesu yi engyukwo, bɛyi emi engwunema, dɛsɔ angba mbi ema Udzengye emi engwuneeyi mi Antiɔku, iSiria, bɛyi iSilisia. ");
INSERT INTO utr_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Eyi fwo gbɛɛ angbeka mbi eyi tɔ mi oye-ye mgbi eyi ba di nu ema okakewo, nu ema isɔ mi itukwu mi odzɛ ngwi a gbɔ mani. ");
INSERT INTO utr_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Nghanɛ eyi duu gbela odulu inggisɛ angbeka yi emi okeyi ingblimɔ iBanabasi yi iPol di dɔ ma esɔ mbi ema. ");
INSERT INTO utr_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Inggisɛ ntonɛ kye oshishe mgbi ama lasɛ mi ikye iyi mgbi Otsɛ mgbi eyi iYesu iKrestu. ");
INSERT INTO utr_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Nghawanɛ eyi le dɔ iJuda yi iSaila esɔ nu ma ka kyɔ obwɛndɛ ongwi ondu mi ungwɔ ngwi eyi le lɔ ntonɛni. ");
INSERT INTO utr_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","I kpa Onodzi Osaan bɛyi eyi ombwo ema okye ngha ungwɔ ntonɛ ba, sede li ama ndzɛ kyɛmɛ-kyɛmɛ nɛni. ");
INSERT INTO utr_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Ema ka gye ungwogye ngwi a kye fifɛ nu angwula ba, ungwɔ eyeeyi ba, ema dika gye mmbwɛ mmbwaba ngwi a tsili-tsili ma onbukwɔ ba, di dulu abɔ mi amah idza. Kini ema kyungwɔ ntonɛ bayɔ, li ayin seali. Kɛ saan na. ");
INSERT INTO utr_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Inggisɛ ntona kyɛɛ okyɛɛ lu Antiɔku, ka kwu emi iKrestu kwakye mbonyi kye afɛ ma nu ma. ");
INSERT INTO utr_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Inggisɛ ntona gbɔ afɛ nani ewo di shɛta loma ikyesinɛ li esɔ okwu ma ɛwɛwo. ");
INSERT INTO utr_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","IJuda yi iSaila, ama abuoma li oyegbɔ, a gbɔdzɛ kpakpa okwu ama onoyɛyɛ ntona ɛwɛwo di yile ma dzɛ ofɛ. ");
INSERT INTO utr_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Ngwi a kye egbe gwee mi ele nɛ, ama onoyɛyɛ ntona wo ma ofɛ mi iyu nu ma yidɔ lu ka tu ama ndɔ ma esɔ mani. ");
INSERT INTO utr_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","(Nghaduukpaa iSaila yɔ i kpan odzɛ imbe nani.) ");
INSERT INTO utr_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Kpaa iPol bɛyi iBanabasi tila dzɛ Antiɔku, nɛ ama bɛyi inggisɛ angbeka kwuba tso diyɛ gbeesɔ mgbi Otsɛ mi ele. ");
INSERT INTO utr_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","I wa la gwee nɛ iPol gbɔ yi iBanabasi gbɛɛ, <<Ba ni eyi yɛ ka kpadi emi ongwuneyi mi ali igeli ngwi eyi gbeesɔ mgbi Otsɛ mi ele duu, di di dafi a le kyɔ mani.>> ");
INSERT INTO utr_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","I mina iBanabasi okye iJɔn, ngwu a di li kwun gbɛɛ iMaki na, wafɔ yi ama, ");
INSERT INTO utr_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","kpaa iPol tsɛwɛ gbɛɛ li ayin ba okyon wafɔ yi ama, ikyesinɛ o tse dzamata mi iPamfyilia di nya okyidɔ yi ama. ");
INSERT INTO utr_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","A dzɛ yi angwodzɛ fyumfye kpakpa yi ewoma nɛman a gha okyɛɛ. IBanabasi kyelu iMaki fooye lu iSapru, ");
INSERT INTO utr_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","nghaduu iPol dulu iSaila lu yan, ngwi a le lu nɛ, ama onoyɛyɛ kye ma wokɛ iwulu abɔ mgbi Otsɛ. ");
INSERT INTO utr_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","O kyikyɛ kpatsɛ iSiria bɛyi iSilisia, le fyi okwakye mgbi emi iKrestu mfye itukwu. ");
INSERT INTO utr_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","IPol bɛyi iSaila kɛ iDebe, a di nyɛ kɛ iListra, imbe ngwi inggisɛ onoyɛyɛ ngwu a li kwun di iTimoti dzɛ, Onɔn li emi iJuda di noyɛyɛ. Nghaduu otsɔn li emi iGriki. ");
INSERT INTO utr_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Ama onoyɛyɛ mi iListra bɛyi iKonu duu gbɔdzɛ osuse ikpewo iTimoti. ");
INSERT INTO utr_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Nghanɛ i mina iPol okyon wafɔ kɛ agaba yan, ikyenghanɛ o kyan ikyɛ ikye mgbi emi iJuda ama nto imbe na mani, ikyena ama duu ye gbɛɛ otsɔn li emi iGriki. ");
INSERT INTO utr_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Ngwi a le dzagaba mi igeli igeli kyɛ nɛ, a kye ewodzɛ ngwi ama ogbikye iYesu bɛyi engyukwo emi iJerosalin kye bwalu ma, gbɔ nya inggisɛ ntona ikyegbɛɛ nu ma sunu mi ele. ");
INSERT INTO utr_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Nghanɛ ozu okwakye mgbi emi iKrestu duu fyumfye kpakpa mi oyɛyɛ onuunu dile mbwoombwo mi mmbwo mgbi ama alegbe-alegbe. ");
INSERT INTO utr_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Akpe oka nɛ iPol bɛyi emidan dzagaba nyɛ iFrijia bɛyi iGalatia, ikyena Onodzi Osaan nya ma gbɛɛ nu ma ka yama gbeesɔ mi ayɛsɛ mgbi Asia ba. ");
INSERT INTO utr_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Ngwi a wa to otsee iMisia nɛ, i mina ma okaka iBitinia, nghaduu Onodzi mgbi iYesu nu ma ofɛ nu ma kaka ba. ");
INSERT INTO utr_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Nghanɛ ta a si wikye nyɛ ongwi iMisia lu iTroa. ");
INSERT INTO utr_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Mi otu na iPol si di inɛ odiidi. O di ongyulɔ mi iMasidonia, le tɛkyɛ yan gbɛɛ, <<Ba iMasidonia wa ya eyi abɔ.>> ");
INSERT INTO utr_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Ngwi iPol di inɛ odiidi nyɛ nɛ, eyi si wewo akponyi lu iMasidonia. ikyekyɛ eyi kyi kye gbɛɛ, Imgbasho kwu eyi ela gbɛɛ ni eyi ka gbɔ Esɔ Osuse nya ma mi imbe nani. ");
INSERT INTO utr_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Eyi kaka uwaa mi iTroa dzɛkyo dɔkɛ ibu iSamotre, tegblifan nɛ eyi bɛsɛ mi iNiapoli. ");
INSERT INTO utr_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Mi imbe na eyi lu iFyilipi, ogalu ongwi ababɔ mi agwɔ iMasidonia nbyidzɛ abumfye mgbi iRoma nani; eyi la imbe na egbe ibyibyi. ");
INSERT INTO utr_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Mi egbe otonyewo nɛ, eyi tasɛ dzita onufɛ ogalu lu ondekyoo, imbe ngwi eyi tsɛwɛ gbɛɛ emi iJuda ka kwakye le bibɔ mani. Eyi sisɛ di wita ogbɔdzɛ yi engyaa angbeka ama nkwakye mi imbe na mani. ");
INSERT INTO utr_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Onyi mi idzidzɛ ma nle fwo eyi ma li iLedia mi iTyatira, o li gbe angwuto ondlɛndlɛ gya. O li sunu Imgbasho, nɛ Otsɛ Imgbasho kwulun itukwu non gbela odzɛ ngwi iPol le gbɔ mani. ");
INSERT INTO utr_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Ngwi a kyɔn iBatisima bɛyi emidan duu nɛ, o bɔ eyi gbɛɛ ni eyi ba udan. O gbɛɛ, <<Ni ema kye ani gbɛɛ ani noyɛyɛ mbi Otsɛ yɔ, ba wa la udɛ ani na.>> O biibɛ yi eyi, ta eyi si kɛ. ");
INSERT INTO utr_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Egbe oka ngwi eyi le kɛ imbe obibɔ nɛ, eyi kpatsɛ yi ongwongyaa ofyɛɛ ngwu esɛ dɔn ikye di li ongye ogbɛɛsɛ. O li tseefa kwo awuya kpakpa nu emi otsidɔn. ");
INSERT INTO utr_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Ongwongyaa nɛ kyɛdɔ iPol yi eyi le kwu-ela gbɛɛ, <<Inggisɛ ntonɛ li engbidɔ mgbi Imgbasho onghaangha, a le nya ema ofɛ ngwi ema ka watɔ mani.>> ");
INSERT INTO utr_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","O kiyayi ogbɔdzɛ nɛ alegbe-alegbe, nghataa itukwu wa wulu iPol man o kyata nya onodzi obube nwodzɛ mbon na gbɛɛ, <<N wo abu ola mi iyi mgbi iYesu iKrestu tasɛ mbon!>> Onodzi na si tɔ dzanta mi onɔ nani. ");
INSERT INTO utr_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Ngwi emi otsidɔ ofyɛɛ na difwi gbɛɛ ofɛ otu awuya mgbi ama tukwu nɛ, a si kpakli iPol yi iSaila kwo ma kpɛɛkpɛɛ lu ifyidu ka wo emi mfye abɔ. ");
INSERT INTO utr_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","A gbe ma ba mbi ama ogbiikwɔ wa gbɛɛ, <<Engyulɔ ntonɛ li emi iJuda, a le ba yi okakewo mi igeli mgbi eyi kpakpa. ");
INSERT INTO utr_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","A tole tso aletɔ nli ayin ba mbi eyi emi iRoma.>> ");
INSERT INTO utr_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Ibyi si yaokɛ okyɔ eye yi iPol bɛyi iSaila, ama ogbiikwɔ kyi nghalu ma angwuto di noola gbɛɛ nu ma gbo ma ibe. ");
INSERT INTO utr_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Ngwi a gbo ma ibe saan nɛ, a gbe ma wokɛ obawi. A si wo ongye ongyoongyo na ola gbɛɛ no ngyo ma saan. ");
INSERT INTO utr_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Ngwi a woola nghanɛ, inggisɛ ongyo obawi na si gbe ma wokɛ mi idzidzɛ obawi di ta ma itse mi afɔ. ");
INSERT INTO utr_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Mi idzidzɛ otu nɛ, iPol bɛyi iSaila tole bibɔ dile shashi mbi Imgbasho. Inggisɛ angbeka mi ifu obawi tole fwo ma dafi a le shashi mani. ");
INSERT INTO utr_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Ntunto nɛ, ikpɛsɛ suusu kpakpa man itozu mgbi obawi suusu. Onufɛ obawi duu kwulu akponyi, ta itse ngwi a ta ama nwoto obawi duu shɛ. ");
INSERT INTO utr_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Ngwi inggisɛ ongyo obawi wa gbokyato nɛta, o dili onufɛ obawi tsatsa lato asisa, o si kye ngwalu okwusunkli mgban ikye ongwɔ ewon, ikyekyɛ o tsɛwɛ gbɛɛ emi obawi duu tse lu. ");
INSERT INTO utr_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Hininɛ iPol fan ela gbɛɛ, <<Ka yama ngwɔ ewoo ba! Eyi duu ka todzɛ aana!>> ");
INSERT INTO utr_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Ongye ongyo obawi kwu ela ola si maama lu ifun ka gbɛsɛ lakiyayi iPol bɛyi iSaila le shi adagba gbagbaagba. ");
INSERT INTO utr_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","O gbe ma tasɛ wa byi ma gbɛɛ, <<Engyukwo, li ekyɛ n ka kyɔ kyɛmɛ-kyɛmɛ se n ka watɔ?>> ");
INSERT INTO utr_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","A nyan gbɛɛ, <<Nu oyɛyɛ mbi Otsɛ iYesu ta abu ka tu owatɔ-watɔ bɛyi udɛ mgbi abu duu.>> ");
INSERT INTO utr_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Nɛta a si gbɔ elodzɛ mgbi Otsɛ iYesu nyan bɛyi ama nto udan duu. ");
INSERT INTO utr_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Ngwi ka li otu mani, inggisɛ ongyo obawi na gbe ma ka sa ma ifwa mi ewo tsatsadu; ntunto mata a si kyɔn iBatisima bɛyi emidan duu. ");
INSERT INTO utr_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Inggisɛ ongyo obawi na gbe ma tɔ luba udɛ mgban wa nu ma ungwogye, o mbwo yi atsa, ikyekyɛ o yɛɛ owa noyɛyɛ mbi Imgbasho, ongwu yi etɔ mgban duu. ");
INSERT INTO utr_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Ngwi egbe wa fa nɛ, ama ogbiikwɔ dɔ obaka mgbi ama esɔ mbi inggisɛ ongyo obawi na gbɛɛ: <<Nu inggisɛ ntona ofɛ nu ma lu.>> ");
INSERT INTO utr_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Inggisɛ ngyo obawi nɛ si nya iPol gbɛɛ, <<Ama ogbiikwɔ ntona dɛsɔ gbɛɛ ni a dzita abu bɛyi iSaila. Onɛnɛ ema ka lu. Lu mi iyu na.>> ");
INSERT INTO utr_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Nghaduu iPol nya obaka ntona gbɛɛ: <<A gbo eyi ibe mi ododa ikwɔ kpaa a yama fwo eyi ba, dafi eyi li emi iRoma nɛ kpaa a di gbe eyi wo obawi. Nghama onɛnɛ a mina odzita eyi ni eyi lu ngha mgbanta imimaa? N fwa! Nya nu ma ba abuoma wa dulu eyi tasɛ.>> ");
INSERT INTO utr_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Obaka ntonɛ si yɛ lu ka nya ama ogbiikwɔ ntona ngha, dafi a ka fwo gbɛɛ iPol yi iSaila li emi iRoma nɛ, imio wo ma. ");
INSERT INTO utr_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","A lukwu ma kɛ obawi ka nu ma aba ogyeegye. A gbe ma tasɛ wa tɛkyɛ nu ma gbɛɛ nu ma lu dzita ogalu mgbi ama. ");
INSERT INTO utr_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Nghaduu iPol bɛyi iSaila yidɔ luba udɛ iLedia, mmana a wa tu ama onoyɛyɛ angbeka, a di kwu ma ɛwɛ wo duuse a kwa lu dzita igeli nani. ");
INSERT INTO utr_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Ngwi iPol bɛyi emi okan dzagaba ka nyɛ ongwi Amfipoli yi Apolonia nɛ, a wa to iTesalonika, imbe na ozu okwakye mgbi emi iJuda dzɛ efu. ");
INSERT INTO utr_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Dafi iPol teyi li kyɔ mani, o ka kaka ozu okwakye mgbi emi iJuda, man si kponya yi ama mi Afɛ mi egbe otonyewo nghi eta, ");
INSERT INTO utr_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","le nu ma osa diyɛ le tso ma ambɛ gbɛɛ iMedzaya ma ka gyadzɛ kyɛmɛ di kyɛɛ mi ikwongye. O gbɛɛ, <<IYesu ngwu ani le gbɔdzan nya ema nɛ li iMedzaya mani.>> ");
INSERT INTO utr_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Emi iJuda angbeka noyɛyɛ di yɛɛ ama okyɛdɔ iPol bɛyi iSaila, dafi emi iGriki ibyibyi ama omio Imgbasho bɛyi engyaa imɔ angbeka kwuba kpaa kyɔ mani. ");
INSERT INTO utr_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Nghaduu emi iJuda angbeka kyoofu, nghanɛ a kwu ama ondeye angbeka kwakye mi ifyidu, a yɛɛ ondu onyi man si wita eye mi ogalu nani. A tsinya ka kaka udɛ iJasɔn le pita iPol bɛyi iSaila ikye okye ma luba esɛ wa nu ibyi inggisɛ. ");
INSERT INTO utr_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Dafi a yama tu ma mi imbe na ba nɛ, a si kwo iJasɔn yi ama onoyɛyɛ angbeka gbe ma kɛ mbi engyukwo emi igeli, le kwu-ela gbɛɛ: <<Inggisɛ ama nle nu okakewo kpatsɛ ɛsɛ duu nɛ, bato mmɛnɛ onɛnɛni, ");
INSERT INTO utr_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","ma iJasɔn gbɛ ma kaka udɛ mgban. Ama duu tole foola ngwi iSidza wo, a tole gbɛɛ utɔ oka dzɛ ngwu a li kwun di iYesu.>> ");
INSERT INTO utr_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Ngwi a fwo odzɛ nɛ ngha nɛ, igeli duu yɛɛ yaaya. ");
INSERT INTO utr_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Ta a nu iJasɔn bɛyi angbeka ntona kpaa udza ogbɛ-abɔ se nu ma lu. ");
INSERT INTO utr_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Mi otu na ama onoyɛyɛ kye iPol bɛyi iSaila dɛsɔ lu iBɛria. Ngwi a ka to imbe na nɛ, a kaka ozu okwakye mgbi emi iJuda. ");
INSERT INTO utr_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Emi iBɛria dzɛ yi ali osuse ngha emi iTesalonika, lubana a gbɛ esɔ na yi atsa kpakpa dile kya mi Afɛ alegbe-alegbe ikye odi ni odzɛ ngwi iPol gbɔ na li otsitsi yɔ. ");
INSERT INTO utr_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Emi iJuda ibyibyi noyɛyɛ, dafi ibyi engyaa imɔ emi iGriki bɛyi engyulɔ kpaa kyɔ nani. ");
INSERT INTO utr_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Nghaduu ngwi emi iJuda angbeka mi iTesalonika kwambɛ gbɛɛ iPol le gbɔ elodzɛ Imgbasho mi iBɛria nɛ, a lɔ kɛ imbe na ka teeye. ");
INSERT INTO utr_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Nɛ ama onoyɛyɛ byakpa kye iPol dɛsɔ lu ondiiga, kpaa iSaila bɛyi iTimoti tila mi iBɛria. ");
INSERT INTO utr_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Ama nwafɔ bɛyi iPol ntona tawon nghataa kɛ Atɛn, nɛ a si yidɔ lu iBɛria yi esɔ mbi iSaila bɛyi iTimoti gbɛɛ nu ma vla-vla ka tun. ");
INSERT INTO utr_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Ngwi iPol kale dzɛgiyi ma mi Atɛn nɛ, eka kwowina lon kpakpa mi ikye angwula ama ngbiimbe mi ifu ogalu nani. ");
INSERT INTO utr_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Nghanɛ o li kponya yi emi iJuda bɛyi emi iGriki ama omio Imgbasho mi ozu okwakye mgbi emi iJuda, bɛyi inggisɛ ama ngwu o tu ma mi ifyidu kpaa alegbe-alegbe. ");
INSERT INTO utr_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","IPol kaka angwɛ ota-ta yi obyi etsetse angbeka ngwu a li kwu ma gbɛɛ Epikuria yi iStɔki a li inggisɛ ama otsɛwodzɛ kpakpa. Angbeka mi ele byita gbɛɛ, <<Li ali odzɛ ngwi inggisɛ ntso gbɛɛ ongwu ye ngha duu nɛ le mina ogbɔ?>> Angbeka gbɛɛ, <<Dzɛ dafi o le gbɔdzɛ Imgbasho ongwi anengye mani.>> A gbɔdzɛ nɛ ngha ikyekyɛ iPol le gbɔ Esɔ Osuse mi odzɛ mgbi iYesu bɛyi okyɛɛ-kyɛɛ mgban mi ikwu. ");
INSERT INTO utr_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Nɛ a kyon kɛ okwakye mgbi Ariopagu, mmana ma a byun gbɛɛ, <<Ni eyi ye li ali otsootso ofufɛ ngwi abu le tso kyɛ dɛn? ");
INSERT INTO utr_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Abu le kye odzɛ angbeka ama nfyi eyi mfye ofwoofwo kpakpa ba, nghanɛ eyi mina oye itan.>> ");
INSERT INTO utr_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","(Emi Atɛn yi ingyoga mgbi ama ngwu lato yi ama duu, li kye onɔ okyɔ nkonyonyi wuba, kpaa a li le gbɔdzɛ di gadɔ mi odzɛ ama ofufɛ.) ");
INSERT INTO utr_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Nɛta iPol kyato dzɛkiyayi okwakye mgbi emi Ariopago si gbɛɛ: <<Ema emi Atɛn! N difwi gbɛɛ ema li sunu Imgbasho angbeka saan mi ali itɔ ofɛ duu. ");
INSERT INTO utr_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Ikyena n kyikyɛ wodi agwɔ mgbi ema, n di ungwɔ ama ngwi ema le sunu ma mani, n di iwashi oka a lɔ ungwɔ mi efu gbɛɛ; Ikyenghanɛ ungwɔ ngwi ema tole sunun dafi Imgbasho ngwu a yen ba na, n ka gbɔdzan nya ema. ");
INSERT INTO utr_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","<<Imgbasho nɛ li ongwu ta ɛsɛ bɛyi alungwɔ ama nto efu duu na, li Otsɛ mgbi esho yi esɛ, o li yama la ozu ngwi a mbɛ mi abɔ ba. ");
INSERT INTO utr_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","O mina unkonyi mi abɔ mgbi inggisɛ owamyɛ ba, ikyekyɛ i won yi unka ba, lubana li ongwu abuon li nu ali inggisɛ oshishe yi mmyɛ bɛyi ungwɔ angbeka duu aali. ");
INSERT INTO utr_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Ikpewo inggisɛ onyi Imgbasho ta inggisɛ ama nto ɛsɛ tsatsadu, ikyegbɛɛ ɛsɛ duu no li mgbi ama; li ongwu di kye onɔ dzɛ ali inggisɛ duu bɛyi imbe ngwi a ka dzɛ yɛyɛ mani. ");
INSERT INTO utr_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Imgbasho kyungwɔnɛ ngha ikye ni inggisɛ ye ongwu, pita ongwu di tu ongwu, nghaduu o dzɛ mbotunto yi eyi ba. ");
INSERT INTO utr_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","<Lubana li mbon ngwi eyi dzɛ oshishe di li kyikyɛ kyɛ di dzɛ mi odzɛɛdzɛ mgbi eyi.> Dafi ama olɔ ungwɔ mgbi abu angbeka gbɔ mani gbɛɛ, <Eyi li etɔ mgban.> ");
INSERT INTO utr_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","<<Nghanɛ dafi eyi li etɔ mgbi Imgbasho nɛ, ni eyi ka tsɛwɛ gbɛɛ odzɛɛdzɛ mgban dzɛ dafi abashi naadi iyudza onzundzɛ okwɔkwɔ hona ikwutsɛ naadi ungwɔ okpaakpa ngwi inggisɛ kpa mi ozoyeye mgban ba. ");
INSERT INTO utr_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Tugbe ma Imgbasho kye adɔ onghaangha itɔ nɛ wuuta ba, kpaa onɛnɛ yɔ o woola gbɛɛ ni ali inggisɛ mi ali imbe duu kyatitukwu mi ofɛ obube mgbi ama. ");
INSERT INTO utr_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Lubana o kye egbe dzɛ ngwi o ka wa fwo ɛsɛ duu ikwɔ mi otsitsi mi abɔ mgbi iYesu ngwu o tsekise dulu nani. Imgbasho tsekise tso obwɛndɛ nɛ mbi ali inggisɛ duu mi okyile iYesu mi ikwu.>> ");
INSERT INTO utr_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Onɔ ngwi a fwo iPol gbɔdzɛ mgbi okyɛɛ-kyɛɛ mi ikwu nɛ, angbeka shan isha, kpaa angbeka gbɛɛ, <<I mina eyi odi fwo abu mi itɔdzɛ nɛ onoka.>> ");
INSERT INTO utr_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Ngwi a gbɔdzɛ nɛ mata, iPol si lu dzata okwakye. ");
INSERT INTO utr_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Nghaduu inggisɛ angbeka gbela kyɛdɔ iPol di yɛɛ ama onoyɛyɛ. Onyi mi idzidzɛ mgbi ama li iDiɔnasu, inggisɛ mi okwakye mgbi Ariopago, bɛyi iwata ngwu iyin di iDamari bɛyi angbeka kwuba. ");
INSERT INTO utr_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Ngwi ungwɔnɛ nyɛ nɛ, iPol dzita Atɛn lu iKorinti. ");
INSERT INTO utr_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Li mmana ngwi o tu inggisɛ iJuda ngwu a li kwu iyin di Akwila, o li inggisɛ mi iPontu, o kwa kyɛ mi Itali yi owan iPrisila onɔ kɛ waba, ikyekyɛ utɔ iKladiɔsu woola gbɛɛ emi iJuda duu nu ma dzita iRoma. Nɛ iPol si kɛ oka di ma, ");
INSERT INTO utr_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","ma ikyegbɛɛ ongwu kpaa li inggisɛ otuo opo dafi ama kpaa li tuo nɛ, o tila dzɛ le kyidɔ yi ama. ");
INSERT INTO utr_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Alegbe otonyewo duu o li ka kaka ozu okwakye mgbi emi iJuda, le fya ikye ni ongwu kyata emi iJuda bɛyi emi iGriki itukwu. ");
INSERT INTO utr_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Onɔ ngwi iSaila bɛyi iTimoti yidɔ mi iMasidonia nɛ, iPol kyelu onɔ mgban duu nu mi esɔ ogbɔɔgbɔ di kyɔ obwɛndɛ mbi emi iJuda gbɛɛ, <<IYesu li iMedzaya mani. ");
INSERT INTO utr_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Kpaa ngwi emi iJuda gbela yi iPol wuba yidɔ le fyan ito nɛ, o gbo angwuto mgban otso ma gbɛɛ di a le tangwɛ Imgbasho di nya ma gbɛɛ, <<Eyi mgbi ema no dikye ema! Ani yɔ, ani kyidɔ mgbi ani saan. Wita onɛnɛ lu iyayi n le lu ka gbeesɔ nya Udzengye.>> ");
INSERT INTO utr_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Nɛ iPol si dzita ozu okwakye mgbi emi iJuda lu udɛ nwatse dɔn mani, udɛ iTaitusu iJɔstusu ongwu nli Udzengye li sunu Imgbasho nani. ");
INSERT INTO utr_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","IKrispu, ongyukwo mi ozu okwakye mgbi emi iJuda, bɛyi etɔ mgban olɔlɔ duu noyɛyɛ mbi Otsɛ iYesu; bɛyi emi iKorinti gwuba ama nfwo iPol noyɛyɛ a di kyɔ ma iBatisima. ");
INSERT INTO utr_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Otu oka ma, Otsɛ iYesu gbɔdzɛ yi iPol mi inɛ odiidi gbɛɛ, <<Ka yama wo imio ba; kiyayi ogbɔɔgbɔ, dika tukwondu ba. ");
INSERT INTO utr_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Ikyesinɛ n dzɛ bɛyi abu, ma inggisɛ onyonyi ka yama dzɛ abu wo di kyɔ abu ibli ba, ikyekyɛ ani to yi inggisɛ kwuba mi ogalu nɛni.>> ");
INSERT INTO utr_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Nghanɛ iPol la imbe na onova onyi yi ofyia egyin le tso ma elodzɛ Imgbasho. ");
INSERT INTO utr_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Nghaduu onɔ ngwi iGalio gye iGɔna mgbi Akaya ma, emi iJuda dzɛ iPol wo bwan kyon lu opiikwɔ. ");
INSERT INTO utr_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","A gbɛɛ, <<Ongyulɔ nɛ, le fya okyata inggisɛ nu ma sunu Imgbasho mi ofɛ ngwi ola mgbi eyi gbela ba.>> ");
INSERT INTO utr_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Ngwi iPol kwa wewo ogbɔdzɛ nɛ, iGalio nya emi iJuda gbɛɛ, <<Ni ema emi iJuda kile kwondukwɔ mi ungwɔ obube hona alobube ntimbi kpakpa yɔ, n kika yagba kyungwɔ mi efu. ");
INSERT INTO utr_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Kpaa ngwi i yɛɛ angwodzɛ mi ikye odzɛ ogbɔɔgbɔ yi iyi, bɛyi ola mgbi ema nɛ, yile odzɛ mgbi ema mɛ abuema na. N ka yama wo abɔ mi itɔ ntona ba.>> ");
INSERT INTO utr_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Nɛman o lɔ ma onya tasɛ mi ozu ikwɔ. ");
INSERT INTO utr_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Ta ama duu kpakli iSɔstɛnɛ nkye ozu okwakye mgbi emi iJuda teyi mani di gbon mi iyayi opiikwɔ. Nghaduu iGalio gbinɛ ngwuta i kakan ewo ba. ");
INSERT INTO utr_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","IPol la iKorinti egbe ibyibyi. Ta o dzita ama onoyɛyɛ, kye ikye dɔ onyɛ ongwi eni lu iSiria. O wafɔ yi iPrisila yi oban Akwila. Duuse non lu yɔ, o nyɛ wulɔ otu mi iSɛnkria, ikye ombwo ondu odzɛɛdzɛ ngwi o dzɛ mani. ");
INSERT INTO utr_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","A ka kaka Efesu, man iPol dzita iPrisila bɛyi Akwila. Ongwu abɔn kaka ozu okwakye mgbi emi iJuda ka kponya yi ama. ");
INSERT INTO utr_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Ngwi a nyan gbɛɛ no la yi ama kpakpa nɛ, o fwa. ");
INSERT INTO utr_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Ngwi o ka lu nɛ, o zondu gbɛɛ, <<N ka yidɔ ba mbi ema, ni li oweka mgbi Imgbasho yɔ.>> Nɛta o si kaka uwaa lu dzata Efesu. ");
INSERT INTO utr_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Ngwi o kaka iSisiria nɛ, o ka ta emi iKrestu angba di nyɛ lu Antiɔku. ");
INSERT INTO utr_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Dafi o la Antiɔku kye egbe gwee nɛ, iPol kyato mi imbe na dzagaba kɛ imbe idzidza-dzidza kpatsɛ ayɛsɛ iGalatia bɛyi iFrijia, le kwu ama onoyɛyɛ ɛwɛ wo. ");
INSERT INTO utr_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Nghanɛ inggisɛ iJuda ngwu iyin di Apolo, ngwu a mban mi ogalu Alekdzandra ba Efesu. O li ongyulɔ ngwu kpayi afɛ, di dzɛ yi ozoyeye mgbi Ibyibyilo saan. ");
INSERT INTO utr_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","A tson Ofɛ mgbi Otsɛ, ngwi o le fu mi onodzi nɛ, o gbɔdzɛ di tso odzɛ mgbi iYesu mi itukwu onyi, nghaduu o ye odzɛ iBatisima mgbi iJɔn kyoon ta. ");
INSERT INTO utr_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","O si wita odzɛ ogbɔɔgbɔ yi abɔ otsigɛgɛ mi ozu okwakye mgbi emi iJuda. Ngwi iPrisila bɛyi Akwila fwon nɛ, a kyon lu udɛ ama ka nun osa mi Ofɛ mgbi Otsɛ saan. ");
INSERT INTO utr_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Onɔ ngwi i wa wo Apolo okɛ Akaya nɛ, ama onoyɛyɛ fyonmfye itukwu, di lɔ afɛ mbi ama okyɛdɔ mi imbe na gbɛɛ nu ma gban abɔ efa. Okakaakaka mgban ma, o dzɛ yi abɔ oyaaya mbi ama Imgbasho nu ma noyɛyɛ mi elela mgban mani. ");
INSERT INTO utr_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Ikyena o tangwodzɛ yi emi iJuda kpɔklɔɔ di ngha ma mi ododa, tso ma ambɛ mi Afɛ saan gbɛɛ iYesu li iMedzaya. ");
INSERT INTO utr_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Ngwi Apolo ka dzɛ iKorinti nɛ, iPol nyɛ ongwi afɛɛsɛ wa kaka Efesu. Mmanana o tu ama onoyɛyɛ angbeka ");
INSERT INTO utr_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","di byi ma gbɛɛ, <<Ema gbɛ Onodzi Osaan onɔ ngwi ema noyɛyɛ ma wɛ?>> A gbɛɛ, <<Ei, eyi fwo kpaa gbɛɛ Onodzi Osaan dzɛ ma ba.>> ");
INSERT INTO utr_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Nɛ iPol byi ma gbɛɛ, <<Nghama li ali itɔ iBatisima ngwi a kyɔ ema?>> A nu uka gbɛɛ, <<IBatisima mgbi iJɔn.>> ");
INSERT INTO utr_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","IPol si gbɔgbɛɛ, <<IBatisima mgbi iJɔn li iBatisima itukwu okyata-kyata. IJɔn nya inggisɛ ntona gbɛɛ nu ma noyɛyɛ mbi ongwu nka wa ba mi iyikpa ongwu mani, li iYesu waali.>> ");
INSERT INTO utr_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Ngwi a fwo odzɛ nɛ nɛ, a kyɔ ma iBatisima mi iyi mgbi Otsɛ iYesu. ");
INSERT INTO utr_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Dafi iPol kye abɔ dɔ ma ikye nɛ, Onodzi Osaan kaka mboma, a si gbɔ ondudzɛ angbeka di yegbɔ. ");
INSERT INTO utr_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Mmbwo mgbi ama duu mɛ iwyodefa. ");
INSERT INTO utr_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","IPol kaka ozu okwakye mgbi emi iJuda di gbɔdzɛ yi ama mi ododa nghataa ofyia eta, le tangwodzɛ di biibɛ yi ama mi ikye odzɛ esutɔ mgbi Imgbasho. ");
INSERT INTO utr_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Nghaduu angbeka mi ifu ma fyumfye ikye di fwa onoyɛyɛ, di kwu Ofɛ mgbi Otsɛ fyito mi ododa. Nɛ iPol dzita ma di kyi gbelu ama onoyɛyɛ ntona wafɔ biyan lu kale tso ma alegbe mi ozu otsuungwɔ mgbi iTiranu. ");
INSERT INTO utr_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Ungwɔnɛ kiyayi mɛ onova efa, nghataa emi iJuda bɛyi emi iGriki ama nto ayɛsɛ mgbi Asia duu fwo elodzɛ mgbi Otsɛ. ");
INSERT INTO utr_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Imgbasho nyɛ ikpewo iPol kyungwɔ ama okwulewo, ");
INSERT INTO utr_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Nghanɛ gbaka ayangwuto ofwɔ inɛ bɛyi ishisha angwuto ngwi a kye gbo iPol ewo kpaa, ni a kye kɛ ni emi ootse kye abɔ gbo efu ootse mgbi ama li ngyɛ onodzi ibwubwe kpaa li tɔ dzamata. ");
INSERT INTO utr_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Emi iJuda angbeka ama ntole gaaga tsili kyɛ le lɔ onodzi ibwubwe onya, a fya okwu mi iyi mgbi Otsɛ iYesu mi ikye ama ngwu esɛ dɔ ma ikye gbɛɛ ni esɛ tɔ lu. A le gbɔgbɛɛ, <<Mi iyi iYesu, ongwu iPol li le gbeesɔ mgban na, tasɛ lu na.>> ");
INSERT INTO utr_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Emi ongwɛ iSkeva, ongyukwo inggisɛ ofifɛ mgbi emi iJuda, nghi egyafa, tole kyungwɔnɛni. ");
INSERT INTO utr_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Egbe oka nɛ onodzi ibwubwe nu ma uka gbɛɛ, <<iYesu ani yen, iPol kpaa ani ye odzan, nghama ema li ele?>> ");
INSERT INTO utr_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Nghanɛ inggisɛ ndzɛ yi onodzi obube bulu gyɛ ma di ngha ma yi mfye. O sulu ma onikyibe, a si tsinya dzata udɛ mgban ibiba yi eyi mi ewo. ");
INSERT INTO utr_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Onɔ ngwi emi iJuda bɛyi emi iGriki nto Efesu wa ye ungwɔnɛ nɛ, imio wo ma, ta iyi mgbi Otsɛ iYesu si gye mmwɛ kpakpa. ");
INSERT INTO utr_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Ibyi inggisɛ ama nnoyɛyɛ tɔ ba mi ododa wa fwi ali ibwubwe ngwi ama kyɔ mani. ");
INSERT INTO utr_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Inggisɛ ibyibyi ama okyɔ obudei, gbe afɛ ofulu-fulu mgbi ama kwakye gbe toola mi inɛ ibyi inggisɛ. Ngwi a kyi gbɔlu mmya mgbi umbwo afɛ ntona nɛ, i mɛ iDracama idubu ngwusefa dɔn iwyo. ");
INSERT INTO utr_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Mi itɔ ofɛ nɛ elodzɛ mgbi Otsɛ gbɔfwɛ di nghao fyumfye. ");
INSERT INTO utr_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Ngwi ungwɔ ntonɛ duu kyɔ nyɛ nɛ, iPol wewo olu iJerosalin, o nyɛ ongwi iMasidonia bɛyi Acaya. O gbɛɛ, <<Ni ani ka kaka iJerosalin yɔ, n ka kɛ iRoma kpaa kyɛmɛ-kyɛmɛ.>> ");
INSERT INTO utr_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","O dɔ ama okyidɔ biyan nghi efa, iTimoti bɛyi Erastu, kɛ iMasidonia, ongwu yɔ tila dzɛ mi ayɛsɛ mgbi Asia ongwonɔ gwee se. ");
INSERT INTO utr_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Mi itɔnɔ na onikyeeye gbokyɛɛ mi ikye Ofɛ mgbi Otsɛ iYesu. ");
INSERT INTO utr_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Inggisɛ onda iyudza onzundzɛ okwɔkwɔ, iyin gbɛɛ iDemetriɔ, li ongwu mɛ ozoka Atemi, ungwɔnɛ li nu ma awuya ongyɛɛngyɛ ba, li mmya ongbungbɛ ba mbi ama onduufa. ");
INSERT INTO utr_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","O kwu ama onduufa kwakye, bɛyi ama ndzɛ mi itɔ ofɛ idɔ pita li ungwonyi mani, si gbɛɛ: <<Engyulɔ, ema ye li mi idabɔ nɛ ngwi eyi li tu aludu mgbi eyi. ");
INSERT INTO utr_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Ema di diyɛ fwo, dafi iPol biibɛ yi ibyi inggisɛ mi Efesu mmɛnɛni wo ma ɛndɛ, sisi gwee ki li ayɛsɛ mgbi Asia duu. O gbɛɛ Imgbasho ama ngwu inggisɛ mɛ ma mɛɛmɛ mi abɔ ntonɛ duu, a yama li Imgbasho ba dududu. ");
INSERT INTO utr_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Odzɛ obube dzɛ ana, yama li idabɔ mgbi eyi nɛta ngwi iyi mgban osuse ka byulu ba, kpaa ozoka mgbi imgbasho ongyaa oshewo Atemi kpaa ka yɛɛ ungwɔ onyadi, ongwu imgbasho ongyaa abɔn ngwu a li sunun kpatsɛ ayɛsɛ Asia yi ɛsɛ olɔlɔ duu na, a ka kye bulu ugabaidu mgban oshewo nani.>> ");
INSERT INTO utr_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Ngwi a fwo ungwɔnɛ nɛ, itukwu gyaabyi loma man a wita owulu gbɛɛ: <<Oshewo li Atemi mgbi emi Efesu!>> ");
INSERT INTO utr_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Labɔlabɔ nɛta igeli yɛɛ onɔgbɛ-onɔgbɛ. Inggisɛ ntona kye bwalu iGayɔsu bɛyi Aristakɔ, ongwu li ongwɛ afokyɛɛ mgbi iPol kyɛ mi iMasidonia, a si wafɔ ondonyi dafi a li inggisɛ onyi mani kaka imbe okwakye okwukwo. ");
INSERT INTO utr_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","IPol mina okye ewon tɔ iyayi ibyi inggisɛ, kpaa ama okyɛdɔ gbelon ba. ");
INSERT INTO utr_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Engyukwo emi idɔ angbeka mi ayɛsɛ na, ama nli oka iPol dɛsɔ tɛkyɛ nun gbɛɛ non ka yama lɛlɛ kye ewon kɛ imbe okwakye okwukwo na ba. ");
INSERT INTO utr_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Okwakye wɛndɛ. Angbeka tole wulu mi itɔdzɛ oka angbeka mi itɔdzɛ idzidza. Angbeka ye itɔdzɛ nkye ma kɛdzɛ imbe na ba. ");
INSERT INTO utr_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Emi iJuda tsamu Alekidzanda dzɛkiyayi ibyi inggisɛ man angbeka mi ibyi inggisɛ tole nyan odzɛ ngwi o ka gbɔ mani. O si kyɔ ma abɔ gbɛɛ nu ma dzɛ shilididi ikye ni ongwu natsondu onagbɛ ewon, mi inai ma. ");
INSERT INTO utr_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Ngwi a wa difwi gbɛɛ o li emi iJuda nɛ, ama duu wulu ondonyi mɛ dafi obyi efa hini gbɛɛ: <<Oshewo li Atemi mgbi emi Efesu!>> ");
INSERT INTO utr_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Ongye olɔɔlɔ mgbi ogalu okwukwo tukwu ma ondu, o nya ibyi inggisɛ gbɛɛ: <<Ema emi Efesu, li emɛ mi ɛsɛ ye gbɛɛ igeli mgbi Efesu li ogalu osunu angbodzi Imgbasho ongyaa Atemi ba di ye dafi onodzi mgban, nngwuta kyɛ esho ma dzɛ imbe nɛ ba? ");
INSERT INTO utr_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Nghanɛ, dafi a ka tangwɛ otsitsi nɛ gbɛ ba nɛ, li ayin ni ema yile itukwu bɛsɛ di kyɔ unkonyi mi ikwangha ba. ");
INSERT INTO utr_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Ema gbe engyulɔ ntonɛ ba mmɛnɛ, nghaduu a yama yi ozoka unkonyi hona kwu ashu mgbi eyi shanyɛ ba. ");
INSERT INTO utr_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Nghanɛ, kini iDemetriɔ bɛyi ama okyidabɔ yan dzɛ yi okakewo yi inggisɛ yɔ, opiikwɔ lasisa, emi ola kpaa to. Nu ma ka kwelikwɔ mmanani. ");
INSERT INTO utr_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Nghaduu ni odzɛ ka dzɛma ngwi ema mina okye ba yɔ, li kyɛmɛ ni a kye mɛlu mi okwakye ndzɛ mi ola mani. ");
INSERT INTO utr_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Dafi i dzɛ nghanɛ, ungwɔ nkyɔ inɛ nɛ a ka yagba maayi bɛ eyi gbɛɛ di li eyi teeye. Eyi ka yagba tangwɛ mi ikye onɔgbɛ nɛ naadi nu itɔdzɛ nka mɛ ba.>> ");
INSERT INTO utr_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Ngwi o gbɔdzɛ nɛ ngyɛ mata, o si nu okwakye ganya. ");
INSERT INTO utr_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Onɔ ngwi eye wa ngyɛ nɛ, iPol dɛsɔ mbi ama onoyɛyɛ, ngwi o fyuma mfye itukwu nɛ, o nya ma gbɛɛ se egbe oka man kye ofɛ dikye lu iMasidonia. ");
INSERT INTO utr_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","O si dzagaba nyɛ imbe nani, o nya ma elodzɛ kpakpa ofyuma mfye itukwu, mi olɛlɛ nɛ o ka kaka iGriki, ");
INSERT INTO utr_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","o la imbe na ofyia eta. Ikyekyɛ emi iJuda wibu okyɔn ungwɔ obube dafi o wewo okaka uwaa lu iSiria mani, nɛ o kyatitukwu yidɔ wikye ka nyɛ ongwi iMasidonia. ");
INSERT INTO utr_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Ama ntawon li iSopata ongwɛ iPerusu ngwu kyɛ mi iBɛria, Aristakɔ bɛyi iSekundu yi iGayɔsu emi iTesalonika, mi iDebe, iTimoti kpaa, yi iTacikɔ bɛyi iTrofimu mi ayɛsɛ mgbi Asia. ");
INSERT INTO utr_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Inggisɛ ntonɛ wikye lu ka dzɛ giyi eyi mi iTroa. ");
INSERT INTO utr_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Nghaduu ngwi oga ibredi ongwi a kye okwuna wo efu ba wa nyɛ nɛ, eyi kaka uwaa mi iFyilipi kye egbe eda duuse kwa lu ka tu angbeka ntona mi iTroa, eyi la ele ikyidu olɔlɔ. ");
INSERT INTO utr_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Egbe ongwi ababɔ mi ikyidu ma eyi kwakye ikye ogye oga. IPol gbɔdzɛ yi ama, ma ikyegbɛɛ o weka olu tegblifan nɛ, o kiyayi yi onya okpaaakpaa yi ama nghataa otu gheefa. ");
INSERT INTO utr_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","A gbe ola ipitila dɔto mi ifoozu ongwi esho imbe ngwi eyi kwakye mani. ");
INSERT INTO utr_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Ongwongyulɔ mmafa ngwu a li kwun di iYutuku sɔdzɛ ofɛ awo le mwuna. Dafi iPol kale kiyayi yi odzɛ ogbɔɔgbɔ nɛ, una wa ngwɔn lu kpini, o si gbɛsɛ kyɛ esho wa zudɔwokɛ esɛ man a ka kyon ikwukwɔ tatso. ");
INSERT INTO utr_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Nghaduu iPol tashulu luba esɛ, o tukwukɛ ikwɔ nani tsɛkwulun. O si nya ma gbɛɛ, <<Ka yama teeyi ba na, o dzɛ oshishe!>> ");
INSERT INTO utr_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Ta o diyɛ tɔkɛ lu esho kye ghalu ibredi gye yi ama. Ngwi o gbɔdzɛ yi ama nghataa ni egbe fa nɛman, o si lu. ");
INSERT INTO utr_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Inggisɛ ntona si kyi kyelu ongwongyulɔ mmafa nɛ lu udɛ oshishe itukwu di fyuma mfye kpakpa. ");
INSERT INTO utr_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","IPol nya eyi gbɛɛ ni eyi nyɛ ongwi uwaa teyi ongwu lu Aso, ka kye ongwu mi imbe nani, ikyesinɛ o le lu imbe na mi afɛɛsɛ. ");
INSERT INTO utr_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Ngwi o tu eyi mi Aso ma, eyi kyon wo uwaa lu iMitilene. ");
INSERT INTO utr_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Tegblifan ma, eyi dzata imbe na dzɛkyo wa to kwɛkwɛ yi ibu iKio. Egbe oka nɛ eyi dzɛkyo dɔkɛ ibu iSamosi, di kaka iMiletu tegblifan. ");
INSERT INTO utr_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","IPol di wewo nu ma fan nyɛ ongwi eni lu dzata Efesu, ikye ombe onɔ mi ayɛsɛ mgbi Asia wuba, lubana i won okaka iJerosalin plɛ, duuse ni oga iPɛntikɔsu wa gyɔ. ");
INSERT INTO utr_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Mi iMiletu ma, iPol dɛsɔ kɛ Efesu ikye engyukwo emi iKrestu gbɛɛ nu ma ba wa tu ongwu. ");
INSERT INTO utr_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Ngwi a wa kaka nɛ, o gbɔ yi ama gbɛɛ: <<Ema ye odzɛɛdzɛ ngwi ani dzɛ mi onɔ ngwi ani dzɛ yi ema ma duu, wita mi egbe ongwi ababɔ ngwi ani ba ɛsɛ Asia mani. ");
INSERT INTO utr_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","N kyɔ Otsɛ idɔ mi ewo oyile esɛ bɛyi etse inɛ. N di shitukwu mi ali imbadi yi isɔ ngwi emi iJuda wibu ani mi ele duu. ");
INSERT INTO utr_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Ema ye n yama yɛyikpa ogbɔ ungwɔ ndzɛ yi oyabɔ nya ema mi ododa ba, mi udɛ ema hona mbi ibyi inggisɛ kpaa. ");
INSERT INTO utr_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Ani gbɔ nya emi iJuda bɛyi emi iGriki gbɛɛ li kyɛmɛ nu ma kyatitukwu luba mbi Imgbasho di dzɛ yi oyɛyɛ onuunu mbi Otsɛ mgbi eyi iYesu. ");
INSERT INTO utr_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","<<Nghanɛ onɛnɛ, Onodzi Osaan si ani le lu iJerosalin, nghaduu n yama ye ungwɔ nka kiyayi yɛn mi imbe na ba. ");
INSERT INTO utr_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Kpaa ungwɔ ngwi ani ye li onyi ta, ali ogalu ngwi ani kaka efu duu, Onodzi Osaan li le kwen adɔ gbɛɛ obawi bɛyi adzɛ ogyeegye dzɛ ani esɛ ma. ");
INSERT INTO utr_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Nghaduukpaa n kye oshishe mgbɛn gbɛɛ li unkonyi ba, ni ani ki yagba ngyɛlu onya otse-tse bɛyi idɔ ngwi Otsɛ iYesu kye wo ani abɔ nɛ kpata idɔ okyɔ obwɛndɛ mi Esɔ Osuse mgbi elela mgbi Imgbasho nɛni. ");
INSERT INTO utr_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","<<Onɛnɛ, n ye ta gbɛɛ inggisɛ onyonyi mi idzidzɛ ema ngwu ani gbeesɔ esutɔ mgbi Imgbasho nyan, ka yama di ani wuba. ");
INSERT INTO utr_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Nghanɛ, n le nya ema mi ododa onɔngwunɛ gbɛɛ, n yama dzɛ yi obube mi odzili-dzili mgbi inggisɛ onyonyi ba. ");
INSERT INTO utr_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Lubana ani fwijiwo onya ema oweka mgbi Imgbasho duu ba. ");
INSERT INTO utr_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Gbɛwɛdzɛ ewema bɛyi ifyungwɔ ama Onodzi Osaan gbe wo ema abɔ gbɛɛ ni ema le di mboma mani. Li inggisɛ ama ongyo emi iKrestu mgbi Otsɛ, ngwu ongwu gyaagya yi eyi mgban ntonɛni. ");
INSERT INTO utr_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Ani ye ta gbɛɛ ni ani wa dzita imbe nɛ yɔ, emi idukwlɛbɛ ibwubwe, ka ba idzidzɛ ema a ka yama dzita ifyungwɔ ba. ");
INSERT INTO utr_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Mi idzidzɛ ema kpaa, angbeka ka tɔ nka kyata otsitsi, ikye otu ama okyɛdɔ ma. ");
INSERT INTO utr_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Nghanɛ gbɛwɛbyi na! Wɛ na gbɛɛ mi onova eta n yama kwulɛsɛ okwo ali inggisɛ mgbi ema adɔ mi otu yi onɔ yi etse inɛ ba. ");
INSERT INTO utr_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","Onɛnɛ n kye ema dɔ Imgbasho ubɔ yi esɔ mgbi elelan, nka nu ema she di nu ema okwudɛ mi idzidzɛ ama ngwu a kye ma kyi salu duu. ");
INSERT INTO utr_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","N yama mina iyudza onzundzɛ hona abashi naadi angwuto mgbi inggisɛ onyi ba. ");
INSERT INTO utr_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Ema abuema duu ye gbɛɛ abɔ mgbi ani ntonɛ nu ani ungwɔ ngwi ani mina tsatsadu bɛyi imina mgbi ama okyɛ yi ani kpaa. ");
INSERT INTO utr_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Alungwɔ ani kyɔ duu, ani tso ema dafi mi itɔ idɔ okwunewo nɛ eyi ka ya emi abubɔ yi emi ootse abɔ kyɛmɛ-kyɛmɛ, ole wɛ elodzɛ ama ngwi Otsɛ iYesu abuon gbɔ mani gbɛɛ: <Mse dzɛ mi onuunu ngha ogbɛ-gbɛ.> >> ");
INSERT INTO utr_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Ngwi iPol gbɔdzɛ nɛ ngyɛ nɛ, o si gbe akwafɔ kwɛsɛ yi ama duu bibɔ. ");
INSERT INTO utr_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Nɛta ama duu si nyɛ yi ikwu otseetse, a tsɛkwulun di nyan gbɛɛ se egbe oka yi okpitukwu. ");
INSERT INTO utr_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Ungwɔ nnghao nu eka kplɔkɔ lo ma yɔ, li elodzɛ ngwi o gbɛɛ a ka yama di ongwu wuba nani. Taman a si tawon ka kaka uwaa. ");
INSERT INTO utr_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Ngwi o nya ma gbɛɛ se egbe oka duu nɛ, eyi si nyɛ ongwi eni byakpa lu iKosu yɛyɛ. Tegblifan ma eyi kɛ iRode di nyɛ lu iPatara. ");
INSERT INTO utr_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Ngwi eyi tu uwaa ongwi nle lu iFonishia nɛ, eyi kaka si kyɛɛ okyɛɛ. ");
INSERT INTO utr_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Dafi eyi di iSapru kɛ nɛ, eyi nyɛ ongwi atiisɛ mgban mi uwaa lu iSiria. Eyi ka bɛsɛ mi iTai, imbe ngwi iwudza mgbi eyi ka dulu okye mani. ");
INSERT INTO utr_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Ka kpatsɛ yi ama onoyɛyɛ angbeka emi imbe nani, nɛ eyi la yi ama ikyidu onyi. Ama okyɛdɔ ntonɛ, mi ikpewo Onodzi Osaan yegbɔ gbɛɛ iPol no ka kɛ iJerosalin ba. ");
INSERT INTO utr_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Nghaduu ngwi onɔ mgbi eyi wa ngyɛ nɛ, Eyi dzata imbe na wikye lu iyayi. Ama okyɛdɔ yi owama bɛyi ɛngbɛ duu tawo eyi tasɛ mi ifyigeli, nɛman eyi kwɛsɛ bibɔ mi ondiiga. ");
INSERT INTO utr_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Ngwi eyi kyɔ eka se egbe oka ngyɛ nɛ, eyi kaka iwudza, man ama si yidɔ lu udɛ. ");
INSERT INTO utr_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Eyi kiyayi yi agaba mgbi eyi mi iTai ka bɛsɛ mi iPitolemai, imbe na eyi tangba yi ama onoyɛyɛ di dzɛ yi ama egbe onyi. ");
INSERT INTO utr_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Tegblifan nɛ, eyi dzita ma wa kaka iSisiria di dzɛ udɛ iFyilipi inggisɛ ogbeesɔ, o li onyi mbi inggisɛ egyafa ngwu a dulu ma gbɛɛ nu ma gha ungwogye mi iJerosalin mani. ");
INSERT INTO utr_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","O dzɛ yi engwengyaa nghi enɛ ama nbongyulɔ waba li yegbɔ. ");
INSERT INTO utr_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Ngwi eyi la imbe na egbe ibyibyi nɛ, oyegbɔ oka ngwu a li kwun di Agabu kyɛ iJudia ba. ");
INSERT INTO utr_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Ngwi o nyɛ ba mbi eyi nɛ, o kyi kyelu okpa obwa oshi mgbi iPol, kye bwa ewon afɔ bɛyi abɔ duu si gbɛɛ, <<Onodzi Osaan gbɔgbɛɛ, <Li itɔ ofɛ nɛ emi iJuda ama nto iJerosalin ka bwa otsungwɔ okpa nɛ adi kyon wo Udzengye abɔ aali.> >> ");
INSERT INTO utr_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Ngwi eyi fwo ungwɔnɛ nɛ, eyi bɛyi inggisɛ ama nto mmanana tɛkyɛ yi iPol gbɛɛ no ka kɛ iJerosalin ba. ");
INSERT INTO utr_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Nghaduu iPol gbɛɛ, <<Kyɔnɛ ngwi ema le tsukwu dile gbua ani eka? Ani wewo ikye adi obwa-bwa ta ba, kpaa odi kwulu mi iJerosalin ikye iyi mgbi Otsɛ iYesu.>> ");
INSERT INTO utr_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Dafi i yɛɛ gbɛɛ eyi ka kyɔkyɔ yan gbɛ ba nɛ, eyi si dzɛ abɔ ta nyan gbɛɛ, <<Ni oweka mgbi Imgbasho kyɔ.>> ");
INSERT INTO utr_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Ngwi egbe ntonɛ wa nyɛ nɛ, eyi kyi gbelu okye mgbi eyi si lu iJerosalin. ");
INSERT INTO utr_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Ama okyɛdɔ angbeka mi iSisiria wafɔ yi eyi di kye eyi ba udɛ Mnasɔn, imbe ngwi i wo gbɛɛ eyi ka dzɛ mani. Ongwu nose li ongyulɔ nkyɛ mi iSapru di li onyi mbi ama okyɛdɔ emi ababɔ ntonani. ");
INSERT INTO utr_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Ngwi eyi kaka iJerosalin nɛ, ama onoyɛyɛ gbɛ eyi abɔ efa. ");
INSERT INTO utr_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Tegblifan nɛ iPol bɛyi eyi angbeka duu kɛ oka di iJɛnsi, engyukwo emi iKrestu mi iJerosalin duu kpaa todzɛ ele. ");
INSERT INTO utr_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","IPol kye angba kwulu ma di kyatse odzɛ nya ma klɛklɛ ungwɔ ngwi Imgbasho kyɔ yi Udzengye mi ikpewo idɔ ngwi ongwu kyɔ mani. ");
INSERT INTO utr_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Ngwi a fwo ungwɔnɛ mata, a si tsɛ Imgbasho. Ta a nya iPol gbɛɛ: <<Anɔ, o di dafi umbwo inggisɛ idubu ibyibyi mi iJuda kyatitukwu, di dzɛ yi itukwu olola ongyo Ola mgbi iMose mani. ");
INSERT INTO utr_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","A nya ma gbɛɛ abu le tso emi iJuda ama nto idzidzɛ Udzengye gbɛɛ nu ma kyata dzita Ola iMose, le nya ma gbɛɛ nu ma ka kyɛ engwɛ ma ikyɛ ba hona kyɔ aletɔ mgbi eyi ba. ");
INSERT INTO utr_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Li kyɛmɛ ngwi a ka fwo gbɛɛ abu badzɛ, nghanɛ li ekyɛ i ka kyɔ? ");
INSERT INTO utr_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Ngyɛse kyungwɔ ngwi eyi nya abu mani. Engyulɔ enɛ to mmɛnɛ yi eyi ama nzondu yi Imgbasho. ");
INSERT INTO utr_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Wafɔ yi ama, ni ema wewo lu mi ewo ofwɔ-fwɔ mgbi ama mani di kpa mi ungwɔ ngwi a kyɔ duu, adzi ni a kpalu ma otu. Ta ali inggisɛ ka ye gbɛɛ otsitsi dzɛ mi odzɛ ngwi a le gbɔ ikpewo abu nɛ ba, kpa i tso gbɛɛ abu abuabu gbela yi ola mgbi iMose. ");
INSERT INTO utr_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Nghaduu mbi Udzengye ama onoyɛyɛ yɔ, eyi teyi lɔ oweka mgbi eyi kɛ mboma gbɛɛ nu ma dzɛ enggengga mi ungwogye ngwi a kye fifɛ nu angwula, yi eyi, yi mmbwɛ ngwi a ngwɔ mfyumfye bɛyi amah idza.>> ");
INSERT INTO utr_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Tegblifan nɛ, iPol kye Engyulɔ ntonɛ ka fwɔ ewo yi ama. Nɛ o si kɛ ozu okwukwo osunu Imgbasho mi iJerosalin oka nu ma ye egbe ngwi ewo ofwɔ-fwɔ nɛ ka dondu ngwi a dika nu umba ikye ali inggisɛ mgbi ama mani. ");
INSERT INTO utr_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Ngwi egbe egyafa ntona wa dzɛ kwɛkwɛ ongyɛɛngyɛ nɛ, emi iJuda angbeka mi ayɛsɛ mgbi Asia di iPol mi ozu okwukwo osunu Imgbasho mi iJerosalin. A si kyile etasɛ angbi man a bwan, ");
INSERT INTO utr_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","le teela gbɛɛ, <<Emi Israi, ya eyi abɔ na! Nɛnɛ li ongyulɔ nle tsungwɔ nli ayin ba kpatsɛ mi ikpewo eyi yi ola mgbi eyi bɛyi imbe nɛ mani. Ungwɔ oka nbɛ efu yɔ, o gbe emi iGriki kaka ifyudɛ ozu okwukwo osunu Imgbasho mi iJerosalin di kwo idza kaka imbe Osaan nɛni.>> ");
INSERT INTO utr_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","(Lubana a tsekise di iTrofimu inggisɛ emi Efesu yi iPol mi ogalu, a si kyi kyelu mi itukwu mgbi ama gbɛɛ iPol kyon kaka ifyudɛ ozu okwukwo osunu Imgbasho mi iJerosalin.) ");
INSERT INTO utr_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Ogalu na duu gbokyɛɛ, inggisɛ kyɛ onyonya mi ali agya duu. Ngwi a kpakli iPol nɛ, a kwon tɔ mi ozu okwukwo osunu Imgbasho mi iJerosalin, labɔlabɔ nɛta a gbe onufɛ gyɛtukwu. ");
INSERT INTO utr_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Ngwi a le fya ongwɔn nɛ, akwɔ mgbi odzɛ nɛ kaka mbi agyegika mgbi oblakwutsɛ mgbi emi iRoma gbɛɛ ogalu iJerosalin duu yɛɛ kwutukwutu. ");
INSERT INTO utr_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Akponyi man agyegika na gbe engyukwo oblakwutsɛ angbeka bɛyi ɛngbɛ oblakwutsɛ si tsinya lukwu ibyi inggisɛ. Onɔ ngwi emi ablodzɛ ntona dili agyegika bɛyi eblakwutsɛ mgban nɛ, a nya ogbo iPol ibe. ");
INSERT INTO utr_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Ta agyegika na ba wa bwa iPol di woola gbɛɛ nu ma bwan adi yi ashi efa. Nɛ o si byun itɔ inggisɛ ngwu o dzɛ bɛyi ungwɔ ngwi o kyɔ mani. ");
INSERT INTO utr_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Mi idzidzɛ ibyi inggisɛ ntona angbeka tole gbɔ itɔdzɛ idzidza mi ela okwukwo, angbeka di li itɔdzɛ idzidza, ngwi i fyumfye gbɛɛ agyegika na no difwi otsitsi odzɛ mi ikye onɔgbɛ nɛ, o si woola nu ma kye iPol lu ogalu oblakwutsɛ. ");
INSERT INTO utr_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Dafi iPol wa to afɔ otɔkɛ ozu nɛ, ablodzɛ mgbi ibyi inggisɛ ntona she nyɛsɛ i yɛɛ gbɛɛ oblakwutsɛ ntona ka kyon kye-kye. ");
INSERT INTO utr_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Ibyi inggisɛ ama nkyɛ ma iyikpa ma tole wulu gbɛɛ, <<Ngyɛlu yan na!>> ");
INSERT INTO utr_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Dafi ama oblakwutsɛ wewo okye iPol lu ogalu mgbi ama nɛ, o si byi agyegika gbɛɛ, <<Nin gbɔdzɛ yɔɔ lɔ?>> Agyegika na byun gbɛɛ, <<O li gbɔ iGriki wɛ? ");
INSERT INTO utr_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Abu li inggisɛ Igyibiti ngwu wita eye di gbe ama ongwɔ inggisɛ idubu enɛ lu imbe okplagada onoka nose ma wɛ?>> ");
INSERT INTO utr_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","IPol si nu uka gbɛɛ, <<Ani li emi iJuda, n kyɛ mi iTasu mi ogalu iSilisia, ogalu ingblimɔ. Tsuutsu nin gbɔdzɛ yi inggisɛ ntonɛni.>> ");
INSERT INTO utr_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Ngwi o gbɛ ofɛ mbi agyegika nɛ, iPol kwudzɛkɛ afɔ otɔkɛ ozu di kyɔ ibyi inggisɛ ntona abɔ. Ngwi a dede nɛ, o gbɔ yi ama mi ondu Aramai gbɛɛ: ");
INSERT INTO utr_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","<<Emi ongwunani bɛyi emi otsani, gadɔ dafi ani ka natsondu ewen onɛnɛ nɛni.>> ");
INSERT INTO utr_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Onɔ ngwi a fwon le gbɔdzɛ yi ama mi ondu Aramai nɛ, a si zumyɛ. Nɛta iPol gbɛɛ: ");
INSERT INTO utr_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","<<Ani li inggisɛ iJuda, a mba ani mi iTasu mi iSilisia, kpaa ani she mi igeli nɛni. Mi abɔ mgbi iGamalie a nyɛ ani klɛklɛ mi ola mgbi emi otseyi, n di fyumfye itukwu mbi Imgbasho yɛyɛ dafi ema kpaa dzɛ inɛ nɛni. ");
INSERT INTO utr_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Ani nu ama okyɛdɔ Ofɛ nɛ isɔ nghataa kaka ikwongye mgbi ama, di bwa engyaa yi engyulɔ gbe ma wo obawi. ");
INSERT INTO utr_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Okwukwo inggisɛ ofifɛ bɛyi engyukwo okwakye duu kpaa ka kyɔ obwɛndɛ. A di nu ani afɛ kɛ mbi emi ongwunɔma ama nto iDamasiko, ikye oka bwa ma dafi emi obawi mani, gbe ma ba iJerosalin wa kwo ma adɔ. ");
INSERT INTO utr_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","<<Mi onɔ idzidzɛ udɛ ngwi ani dzɛ kwɛkwɛ okaka iDamasiko nɛta, osa tɔkyɛ esho wa dzaniwo akponyi. ");
INSERT INTO utr_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Man ani gyɛkɛ esɛ si fwo ela le gbɔ yi ani gbɛɛ, <ISol! iSol! Kyɔsinɛ ngwi abu le nu ani isɔ?> ");
INSERT INTO utr_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Ani byun gbɛɛ, << <Li abu emɛ Otsɛ? O nya ani gbɛɛ, << <Ani li iYesu ongwi iNadzareti, ngwu abu le nun isɔ mani. ");
INSERT INTO utr_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Ama nkyɛ yi ani di osa nani, kpaa a fwo ela mgbi ongwu nle gbɔdzɛ yi ani ma ba. ");
INSERT INTO utr_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Ani byun gbɛɛ, << <Li alungwɔ ngwi ani ka kyɔ?> Otsɛ nya ani gbɛɛ, << <Kyato; lu iDamasiko. Mi imbe na a ka nya abu alungwɔ ngwi a kye dzɛ gbɛɛ abu ka kyɔ duu.> ");
INSERT INTO utr_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Ama nkyɛ yi ani ma byi ani abɔ kaka iDamasiko, ikyesinɛ osa na bulu ani inɛ. ");
INSERT INTO utr_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","<<Ongyulɔ iyin gbɛɛ Anania ba owa di ani. O li ngyo ola saan di dzɛ yi mmwɛ mbi emi iJuda ama nto imbe na duu. ");
INSERT INTO utr_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","O kwulɛsɛ dzɛ ani kɛ agya si nya ani gbɛɛ, <<Ongwunani iSol, inɛ mgbi abu no kwulu!>> Mi onɔ na yɛyɛ ta ani yagba dun. ");
INSERT INTO utr_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","<<O si nya ani gbɛɛ, <Imgbasho mgbi emi otseyi dulu abu gbɛɛ ni abu ye oweka mgban di di Ongwu Nle Nyaan na diyɛ fwo odzɛ mi ondun. ");
INSERT INTO utr_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Abu ka li obwɛndɛ mgban mbi inggisɛ duu mi ungwɔ ngwi abu di diyɛ fwo nɛni. ");
INSERT INTO utr_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Ma li ekyɛ ngwi abu le fɛ onɛnɛ? Kyato, kwu mi iyi mgban nu ma kyɔ abu iBatisima di salu ali ibwubwe mgbi abu ngwuta.> ");
INSERT INTO utr_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","<<Ngwi ani yɛ luba iJerosalin dile bibɔ mi ozu okwukwo osunu Imgbasho nɛ, ani di inɛ odiidi ");
INSERT INTO utr_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","di di Otsɛ iYesu le gbɔdzɛ yi ani gbɛɛ, <Lu dzata iJerosalin Plɛ, ikyesinɛ a ka gbela obwɛndɛ mgbi abu onuunu ikye ani ba.> ");
INSERT INTO utr_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Nghaduu ani gbɛɛ, << <Otsɛ, inggisɛ ntonɛ ye ani dafi ani kyikyɛ mi ozu okwakye mgbi emi iJuda kpatsɛ, ikye ogbe ama nnoyɛyɛ mi iyi mgbi abu wo obawi di gbo ma ibe mani. ");
INSERT INTO utr_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Onɔ ngwi a tsɛngwɔ iStivin ikyegbɛɛ o le kyɔ obwɛndɛ mi iyi mgbi abu ma, ani kwudzɛ ele di gbela yi ongwɔɔngwɔ mgban di ngyo angwuto mgbi ama nle ngwɔn mani.> ");
INSERT INTO utr_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","<<Ta Otsɛ iYesu si nya ani gbɛɛ, <Lu, ani ka dɔ abu esɔ lu kpini mbi Udzengye.> >> ");
INSERT INTO utr_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Ibyi inggisɛ gadɔ mbi iPol nghataa o gbɔdzɛ nɛ ngyɛ. Man a kyile ela ondonyi gbɛɛ, <<Ngwɔn na, o mɛ odzɛ oshishe ba!>> ");
INSERT INTO utr_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Dafi a le wulu di fwadulu angwuto mgbi ama ngwuta dile tombulu kɛ esho nɛ, ");
INSERT INTO utr_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","agyegika nu ondu nu ma kye iPol kaka ogalu oblakwutsɛ. O nu ondu gbɛɛ nu ma gbon di byun ita, nu ma ye ungwɔ nkyɔ duuse ibyi inggisɛ tole fan ela ngha mani. ");
INSERT INTO utr_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Dafi a nan lasɛ ogbon nɛ, iPol byi ongyukwo oblakwutsɛ nkwudzɛ mmana ma gbɛɛ, <<Li ola ni abu gbo inggisɛ iRoma ngwu a gbɔn ikwɔ di tun yi obube ba kpaa ibee?>> ");
INSERT INTO utr_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Ngwi ongyukwo na fwo ngha nɛ, o kɛ mbi okwukwo ogbakwu na ka kye tson gbɛɛ, <<Li ekyɛ abu le kyɔ? Inggisɛ nɛ li inggisɛ iRoma.>> ");
INSERT INTO utr_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Okwukwo ogbakwu na kɛ mbi iPol ka byun gbɛɛ, <<Nya ani n di abu li inggisɛ iRomaa?>> O gbɛɛ, <<Ɛɛn, ani li inggisɛ iRoma. ");
INSERT INTO utr_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Nɛ okwukwo ogbakwu na gbɛɛ, <<Ani kpa udza she ikye oyɛɛ inggisɛ iRoma.>> IPol nyan gbɛɛ, <<Nghaduu ani yɔ ani li imba mgbi iRoma.>> ");
INSERT INTO utr_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Ama nwewo obyin ita ma byakpa yɛyikpa. Okwukwo ogbakwu na abuon ewo waa lon onɔ ngwi o difwi gbɛɛ iPol li inggisɛ iRoma kpaa ongwu tan itse mani. ");
INSERT INTO utr_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Tegblifan, ngwi i mina agyegika na oye itɔdzɛ yɛyɛ ngwi emi iJuda gbe odzɛ tukwu iPol ewo nɛ, o shan adi ta di nu ondu ni engyukwo ama ofifɛ bɛyi okwakye mgbi engyukwo duu kwakye. Ta o si kye iPol ba non dzɛkunto mi iyayi ma. ");
INSERT INTO utr_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","IPol kye inɛ byi okwakye mgbi engyukwo emi iJuda yɛyɛ si gbɛɛ, <<Emi engwunani, ani kyidɔ mgbi ani mbi Imgbasho mi itukwu asisa nghataa ba inɛ.>> ");
INSERT INTO utr_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Mi odzɛ nɛ okwukwo inggisɛ ofifɛ Anania nu ama nkwulɛsɛ to kwɛkwɛ yi iPol ondu gbɛɛ nu ma gbobun ondu. ");
INSERT INTO utr_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Nɛ iPol nya Anania gbɛɛ, <<Imgbasho ka ta abu afɛ, abu inggisɛ ikpala nɛni! Abu sɔ mmana le gbɔ ani ikwɔ mi odzɛɛdzɛ mgbi Ola, nghaduu abu abuabu foola mi onu ondu gbɛɛ nu ma ta ani afɛ!>> ");
INSERT INTO utr_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Ama nkwudzɛ yi iPol ntona byun gbɛɛ, <<Abu shitukwu le fya okwukwo inggisɛ ofifɛ mgbi Imgbasho itoo?>> ");
INSERT INTO utr_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","IPol gbɛɛ, <<Engwunani, ani yama ye gbɛɛ o li okwukwo inggisɛ ofifɛ ba, lubana a lɔ gbɛɛ, <Ka gbɔdzɛ obube ikpewo inggisɛ ogbe emidabu teyi ba.> >> ");
INSERT INTO utr_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Ngwi iPol ye gbɛɛ angbeka li emi iSadusi angbeka di li emi iFarasi nɛ, o makwɔ yi okwakye mgbi engyukwo ntona gbɛɛ, <<Emi ongwunani, ani li inggisɛ iFarasi, di li ongwɛ inggisɛ iFarasi. A le gbɔ ani ikwɔ ikyegbɛɛ ani kye eka byi okyɛɛ-kyɛɛ mi ikwongye.>> ");
INSERT INTO utr_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Onɔ ngwi o gbɔdzɛ nɛ ngha nɛ, odzɛ oshiishi tɔ mi idzidzɛ mgbi emi iFarasi bɛyi emi iSadusi, man okwakye na gheefa. ");
INSERT INTO utr_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","(Emi iSadusi noyɛyɛ gbɛɛ okyɛɛ-kyɛɛ mi ikwu, bɛyi engyesɔ naadi emi onodzi dzɛma ba, kpaa emi iFarasi noyɛyɛ mi ungwɔ ntonɛ duu.) ");
INSERT INTO utr_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Odzɛ oshiishi yɛɛ okwukwo nɛman etsetse mgbi ola angbeka ama nli emi iFarasi tokɛ unto di tangwɛ kpɔklɔɔ gbɛɛ, <<Eyi tu unkonyi obube mbi inggisɛ nɛ ba,>> A byi ma gbɛɛ, <<Ni li onodzi hona ongyesɔ gbɔdzɛ yan ma yɛ?>> ");
INSERT INTO utr_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Odzɛ oshiishi na yɛɛ eye man okwukwo ogbakwu na mio gbɛɛ a ka kyi fwalu iPol ambulu-ambulu. O woola gbɛɛ oblakwutsɛ nu ma ka kyen kyi gbɛlu mi abɔ mfye yilen luba ogalu oblakwutsɛ. ");
INSERT INTO utr_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Mi otu ongwi egbe na Otsɛ wa dzɛkɛ yi iPol nyan gbɛɛ, <<Fyumfye itukwu! Dafi abu gbɔdzɛ mgbi ani mi iJerosalin na, li ngha ngwi abu dika gbɔ kyɛmɛ mi igeli iRoma aali.>> ");
INSERT INTO utr_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Mi egbegbe nɛ emi iJuda kwakye di bwalu ondu mi ofaafa gbɛɛ ama ka gye hona wa ungwɔ ba sede ama ngwɔlu iPol. ");
INSERT INTO utr_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Inggisɛ ngha ngwusefa ama nwodzɛ mi ondu obwa-bwa nɛni. ");
INSERT INTO utr_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","A kɛ mbi engyukwo ama ofifɛ bɛyi engyukwo emi iJuda ka nya ma gbɛɛ, <<Eyi bwa mi ofaafa kpɔklɔɔ gbɛɛ eyi ka gye unkonyi ba sede eyi ngwɔlu iPol. ");
INSERT INTO utr_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Nghawanɛ, ema yi okwakye mgbi engyukwo emi iJuda dɛsɔ mbi okwukwo ogbakwu mi ikpala no kyen ba mbi ema gbɛɛ, i mina ema ofwo itɔdzɛ saan mi odzɛ mgban. Eyi wewo ogbongwɔn duuse no wa to mmɛnɛni.>> ");
INSERT INTO utr_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Kpaa ngwi ongwɛ ongwunɔ iPol fwo ngha nɛ, o lu ogalu oblakwutsɛ ka nya iPol. ");
INSERT INTO utr_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Ta iPol kwu ongyukwo oblakwutsɛ ntona onyi ela nyan gbɛɛ, <<Kye ongwummafa nɛ kɛ mbi okwukwo ogbakwu, o dzɛ yi odzimɔ onyan.>> ");
INSERT INTO utr_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Nghanɛ o kyon kɛ mbi okwukwo ogbakwu nani. O nyan gbɛɛ, <<IPol inggisɛ mi obawi na dɛsɔ mbi ani nya ani gbɛɛ ni ani kye mmafa nɛ ba mbi abu ikyekyɛ o dzɛ yi odzimɔ onya abu.>> ");
INSERT INTO utr_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Okwukwo ogbakwu na byi ongwongyulɔ mmafa na abɔ, kwon lu enggengga si byun gbɛɛ, <<Li ali odzɛ ngwi abu dzɛyan onya ani?>> ");
INSERT INTO utr_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","O nyan gbɛɛ, <<Emi iJuda bwondu onya abu ni abu kye iPol ba okwakye mgbi engyukwo emi iJuda ekeka mi ɛwɛ gbɛɛ ama mina oye itɔdzɛ yɛyɛ mi odzɛ mgban. ");
INSERT INTO utr_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Ka gbela yi ma ba, ikyesinɛ inggisɛ ngha ngwusefa da to oshɛ le fan. A fa gbɛɛ ama ka gye hona wa ungwɔ ba sede ama ngwɔ iPol. A wewo ngyɛ onɛnɛ le fɛ ogbela-gbela mgbi abu mi oweka mgbi ama.>> ");
INSERT INTO utr_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Okwukwo ogbakwu na wo ongyulɔ mmafa na ofɛ di kwon adɔ gbɛɛ, <<Ka nya inggisɛ onyi kpaa gbɛɛ di abu nya ani odzɛ nɛ loo.>> ");
INSERT INTO utr_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Ta o kwu engyukwo mgbi ama oblakwutsɛ efa ela si nu ma ondu gbɛɛ, <<Gbe oblakwutsɛ ideli efa yi ama otɔ mmya ngwuseta dɔn iwyo bɛyi emi ashɔ ideli efa nu ma wewo okɛ iSisiria mi obyi egyanɛ mi otu inɛ. ");
INSERT INTO utr_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Di wewo yi mmya angbeka nka kye iPol kɛ mbi iGɔna iFelisi saan mani.>> ");
INSERT INTO utr_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","O lɔ afɛ sini: ");
INSERT INTO utr_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","IKladiɔsu iLisia, Ugabaidu, iGɔna iFelisi: N ta abu angba. ");
INSERT INTO utr_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Inggisɛ nɛ emi iJuda bwan di wewo ongwɔn, kpaa ani ba yi ibyi oblakwutsɛ wa nagban, ikyekyɛ ani fwo gbɛɛ o li imba mgbi iRoma. ");
INSERT INTO utr_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Ani mina oye ungwɔ ngwi a le gbe odzɛ tukwun ewo mani, nghanɛ ani kyon ba mbi okwakye mgbi engyukwo emi iJuda. ");
INSERT INTO utr_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Man ani wa difwi gbɛɛ a le gbe odzɛ tukwun ewo mi ikye ola mgbi ama, nghaduu itɔdzɛ onyi ngwi a nu ngwi mɛ ongwɔn hona kyen wo obawi dzɛma ba. ");
INSERT INTO utr_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Onɔ ngwi a nya ani ungwɔ ngwi a kye weka okyɔ yi inggisɛ nɛ mata, ani kyon dɛsɔ lu mbi abu akponyi. Ani di nu ondu gbɛɛ ama ngbe odzɛ tukwun ewo ntona nu ma gbɔ itɔdzɛ mgbi ama ma nya abu. ");
INSERT INTO utr_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Nghanɛ oblakwutsɛ ntona kyidɔ ngwi a nu ma ondu mani, a kye iPol wafɔ yi ama kyon lu byulu kaka Antipatri mi otu nani. ");
INSERT INTO utr_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Tegblifan ma emi mmya tawon lu kpaa emi afɛɛsɛ yɔ yidɔ luba ogalu mgbi oblakwutsɛ. ");
INSERT INTO utr_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Ngwi emi mmya ntona ka kaka iSisiria nɛ, a kye afɛ ma nu iGɔna di kye iPol kpaa won abɔ. ");
INSERT INTO utr_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","IGɔna gbɔ afɛ na si byita ayɛsɛ ngwi o kyɛ ele mani. Ngwi o difwi gbɛɛ o kyɛ mi iSilisia nɛ, ");
INSERT INTO utr_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","o gbɛɛ, <<Ani ka fwo odzɛ mgbi abu mi onɔ ngwi ama ngbe odzɛ tukwu abu ewo kaka mmɛnɛ mani.>> Ta o wo ma ola gbɛɛ nu ma kye iPol lu udɛ utɔ iHerude ka ngyon. ");
INSERT INTO utr_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Ngwi i kye egbe eda nɛ okwukwo inggisɛ ofifɛ Anania ba wa kaka iSidzaria yi engyukwo angbeka bɛyi inggisɛ oye ola iyin di iTetulɔ, a si gbe itɔdzɛ ngwi a le gbe odzɛ tukwu iPol ewo mi ele ma to iGɔna esɛ. ");
INSERT INTO utr_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Ngwi a kwu iPol ela kaka ifun nɛ, iTetulɔ kye itɔdzɛ mgbi elikwɔ mgban tso iFelisi gbɛɛ, <<Eyi to mi iyu mi abɔ abu onɔ she, inɛ mgbi abu odiidi na di ba yi okiyayi mi ɛsɛ nɛni. ");
INSERT INTO utr_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Ugabaidu iFelisi, mi ali imbe yi ali ofɛ duu, eyi gbela ungwɔnɛ di gbede nu abu kwuba. ");
INSERT INTO utr_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Nghaduu ombe abu onɔ bayɔ, n le bɔ gbɛɛ o ki shitukwu diyɛ fwo eyi gwee. ");
INSERT INTO utr_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","<<Eyi difwi gbɛɛ inggisɛ nɛ li inggisɛ oteeye, o li tu ola eye wo mi idzidzɛ mgbi emi iJuda mi ɛsɛ duu. O li inggisɛ ogbe emi iNadzareti teyi mi eye ");
INSERT INTO utr_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","o di fya okye ayiwi kaka ozu okwukwo osunu Imgbasho mi iJerosalin; nghanɛ eyi kpaklin. Di mina ogbɔn ikwɔ mi ola mgbi eyi. ");
INSERT INTO utr_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","Kpaa agyegika iLisia ba mfyumfye wa kyon kyi lafwa mbi eyi, ");
INSERT INTO utr_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","kwu ama nkwun elikwɔ ntonɛ ela nu ma ba, ni abu byi ma ita abuabu ta abu ka yagba otu otsitsi mi odzɛ ngwi eyi gbe le tukwun ewo ntonɛni.>> ");
INSERT INTO utr_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Emi iJuda ntona gbela wo odzɛ ngwi a gbe tukwun ewo ntonani, dile tso gbɛɛ odzɛ ntonɛ li otsitsi. ");
INSERT INTO utr_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Ngwi iGɔna kyɔ iPol abɔ gbɛɛ no gbɔdzɛ nɛ, o si wita ogbɔdzɛ gbɛɛ: <<Ani ye i kye onova ibyibyi ngwi abu li inggisɛ ogbiikwɔ mi ɛsɛ nɛni; nghanɛ n dzɛ yi atsa onatsondu ewen. ");
INSERT INTO utr_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","O ka yagba byi inggisɛ angbeka fwo i ngha egbe iwyodefa waba ngwi ani kɛ iJerosalin oka sunu. ");
INSERT INTO utr_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Ama ogbe odzɛ tukwu ani ewo ntonɛ yama din le tangwodzɛ yi inggisɛ onyi mi ozu okwukwo osunu Imgbasho hona tu inggisɛ wo mi ozu okwakye mgbi emi iJuda naadi mbeka onyonyi mi ogalu ba. ");
INSERT INTO utr_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","A dika yagba nu osa mi odzɛ onyi ngwi a gbe le tukwu ani ewo nɛ ba. ");
INSERT INTO utr_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Nghaduu, ani gbela dafi engyukwo mgbi ama tsɛwɛ gbɛɛ ofɛ mgbi Otsɛ ngwi ani le kyɛdɔ na li ayin ba mani. Kpaa ani kale sunu Imgbasho ngwi emi otsikyani sunu mani. Ani di noyɛyɛ mi alungwɔ ngwi a lɔ mi ola mgbi iMose bɛyi afɛ mgbi ama ogbɛɛsɛ duu ");
INSERT INTO utr_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","ani di dzɛ yi ɛwɛ ogbe byiibyi mbi Imgbasho ungwonyi dafi inggisɛ ntonɛni, gbɛɛ emi osaan bɛyi emi imbali duu ka kyɛɛ mi ikwu. ");
INSERT INTO utr_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Nghanɛ ani li fya alonɔ ni itukwu mgbi ani dzɛ saan mi inɛ Imgbasho bɛyi inggisɛ. ");
INSERT INTO utr_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","<<Ngwi ani wa dzɛma ba onova ibyibyi nɛ, n ba iJerosalin ikye okye umba wa nu emidɛn emi adzɛ di fifɛ nu Imgbasho. ");
INSERT INTO utr_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Ani fwɔlu ewani yɛɛ saan mi onɔ ngwi a tu ani mi ifyudɛ ozu okwukwo osunu Imgbasho le kyungwɔnɛ mani. Ibyi inggisɛ to yi ani hona ani ndeye yi inggisɛ oka ba. ");
INSERT INTO utr_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Nghaduu emi iJuda angbeka to ayɛsɛ mgbi Asia, ngwi i gbuo a ki to mmɛnɛ mi inai abu nu ma sulu obwɛndɛ obube ikpewo ani yɔ a ki kyɔ. ");
INSERT INTO utr_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Hona ama nto mmɛnɛnɛ nu ma gbɔ ungwɔ obube ngwu ma tu mbi ani mi onɔ ngwi ani kwudzɛ mi inai okwakye mgbi engyukwo emi iJuda mani. ");
INSERT INTO utr_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Li mi ikye ungwɔ onyi ngwi ani kyile ela esho onɔ ngwi ani kwudzɛ inai ma na ta: <Li itɔdzɛ mgbi okyɛɛ mi ikwu ngwi abu le gbɔ ani ikwɔ inɛ aani.> >> ");
INSERT INTO utr_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Nghanɛ iFelisi n ye odzɛ Ofɛ mgbi Otsɛ saan nɛ, tsamu egbe ikwɔ lu iyayi. O gbɛɛ, <<Ni iLisia okwukwo ogbakwu wa ba ta n ka ngyɛlu ikwɔ mgbi abu nɛni.>> ");
INSERT INTO utr_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","O wo ongyukwo oblakwutsɛ ola gbɛɛ no nu ma ngyo iPol kpaa nu ma ka kyon tukwu ba di nu emi okan ofɛ nu ma tobyun mi imina mgban. ");
INSERT INTO utr_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Ngwi egbe nyɛ gwee nɛ, iFelisi yi owan iDrusila, nli ongyaa emi iJuda na waba. O dɛsɔ nu ma kye iPol ba wa fwon dafi o le gbɔdzɛ oyɛyɛ onuunu mbi iYesu iKrestu mani. ");
INSERT INTO utr_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Dafi iPol le tsuutsa mgbi odzɛ saan, yi obwa ewo fyii bɛyi ikwɔ ogbɔɔgbɔ nkyɛ iyayi nɛ, imio wo iFelisi man o gbɛɛ, <<I gyɔ ngha tsatso! O ka yagba lu. Nin wa tu onɔ ta, n ka dɛsɔ mbi abu.>> ");
INSERT INTO utr_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Mi itɔnɔ na, iFelisi tsɛwɛ gbɛɛ iPol ka kye akwatsa wo ongwu ondu, nghanɛ o tonya odɛsɔ mbon ba. ");
INSERT INTO utr_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Ngwi i nyɛ onova efa nɛ, iPoshiɔ iFɛstusu dɔkɛ utɔ gbikye iFelisi, kpaa ikyegbɛɛ i mina iFelisi okyumse yi emi iJuda nɛ, o dzata iPol mi obawi. ");
INSERT INTO utr_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Ngwi iFɛstusu gyuutɔ kye egbe eta nɛ, o dzata iSisiria lu iJerosalin, ");
INSERT INTO utr_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","imbe na engyukwo ama ofifɛ bɛyi engyukwo emi iJuda ba mbon wa gbe itɔdzɛ obube mgbi iPol tonkɛ esɛ. ");
INSERT INTO utr_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","A si byakpa mina abɔ oyaaya mbi iFɛstusu gbɛɛ, no tobyi ama kye nyinɛ iPol luba iJerosalin maama, ali ma a le wewo owa kwo ofɛ ngwɔn. ");
INSERT INTO utr_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","IFɛstusu nu uka gbɛɛ, <<A kye iPol dzɛkɛ iSisiria, ma ani abuen kpaa n le kɛ ele dzikan-dzikan. ");
INSERT INTO utr_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Yeba non kyɔ obube yɔ, ni ama ogbe ema teyi angbeka wafɔ yi ani ka gbɔ obube ngwi o kyɔ ma, mi imbe nani. ");
INSERT INTO utr_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Ngwi iFɛstusu kye egbe egyata naadi iwyo yi ama nɛ, o si lu iSisiria, tegblifan nɛ o kwu ela gbɛɛ nu ma kwakye mi opiikwɔ di noola gbɛɛ nu ma kye iPol ba mbi ongwu. ");
INSERT INTO utr_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Ngwi iPol wa to nɛ, emi iJuda ama nkyɛ mi iJerosalin ba ma loka won, gbe odzɛ okwulewo ama nli otsitsi ba le tukwun ewo. ");
INSERT INTO utr_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Ta iPol si natsondu gbɛɛ: <<N kyungwɔ obube onyi mi ikpewo ola mgbi emi iJuda naadi ozu okwukwo osunu Imgbasho mi iJerosalin hona iSidza ba.>> ");
INSERT INTO utr_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Ngwi i mina iFɛstusu okyungwɔ gbɛɛ no kpa emi iJuda nɛ, o nya iPol gbɛɛ, <<O ka gbela okɛ iJerosalin azukwu ni ani ka fwo abu ikwɔ mi itɔdzɛ obube ntonɛ wɛ?>> ");
INSERT INTO utr_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","IPol gbɛɛ: <<Ani kwudzɛ mi opiikwɔ mgbi iSidza onɛnɛni, li imbe ngbuo gbɛɛ a ka gbɔ ani ikwɔ aani. Abu abuabu ye saan n kyɔ emi iJuda obube onyi ba. ");
INSERT INTO utr_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Kini ani kyɔ obube yɔ, n fwa okwulu ba. Kpaa ni odzɛ obube ngwi emi iJuda gbe tukwu ani ewo nɛ li otsitsi bayɔ, inggisɛ onyi sulu ofɛ okye ani wo ma abɔ ba. N tɛkyɛ ni iSidza abuon fwo ani ikwɔ!>> ");
INSERT INTO utr_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Ngwi iFɛstusu kye bwalu ondu yi ama osɔ ikwɔ yan nɛ, o nya iPol gbɛɛ: <<O tɛkyɛ nu iSidza nɛ li mbi iSidza o ka kɛ!>> ");
INSERT INTO utr_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","I kye ongwɛ egbe gwee nɛ Utɔ Agripa yi iBɛnisi kaka iSisiria oka kye mmwɛ nu iFɛstusu. ");
INSERT INTO utr_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Ngwi i yɛɛ gbɛɛ a ka la egbe ibyibyi mi imbe na nɛ, iFɛstusu kponya odzɛ mgbi iPol na yi utɔ. O gbɛɛ: <<Inggisɛ oka dzɛ mmɛnɛ ma ngwu iFelisi dzanta wo obawi. ");
INSERT INTO utr_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Onɔ ngwi ani kɛ iJerosalin ma, engyukwo ama ofifɛ yi engyukwo mgbi emi iJuda gbe odzɛ obube tukwun ewo di gbɛɛ nu ma ngwɔn ikwɔ. ");
INSERT INTO utr_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","N nya ma gbɛɛ yama li aletɔ mgbi emi iRoma okye inggisɛ nu ama ngbe odzɛ obube le tukwun ewo ba, sede a ka nun ofɛ no natsondu ewon mi odzɛ obube ngwi a gbe tukwun ewo mani. ");
INSERT INTO utr_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Onɔ ngwi a ba mmɛnɛ yi ani ma, ani mbe onɔ yi ikwɔ na wuba, kpaa n byakpa kwu ela ni a kwakye mi ozu ikwɔ tegblifan si nu ma kyon ba. ");
INSERT INTO utr_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Ngwi ama ogbe odzɛ tukwun ewo kyato ogbɔdzɛ nɛ, a yama kwu iyi ungwɔ obube ama ani tsɛwɛ ma ba. ");
INSERT INTO utr_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Ungwɔ ngwi a yɛ kyɔ yɔ, a yɛ le gbɔ onɔgbɛ biyan mi ikye odzɛ Imgbasho mgbi ama bɛyi odzɛ mgbi inggisɛ ikwukwɔ ngwu a kwun di iYesu ngwu iPol le tso gbɛɛ o dzɛ oshishe nani. ");
INSERT INTO utr_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","I wo ani ɛndɛ dafi n ka kya mi itɔ ikwɔ nɛ mani; nghanɛ n yɛ byun ita ni o ka gbela kɛ iJerosalin nu ma ka kya mi itɔdzɛ ntonɛ yɔ. ");
INSERT INTO utr_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Ngwi iPol tɛkyɛ gbɛɛ nu ma kye ongwu nu dafi oweka mgbi ongyufa dzɛ ma nɛ, n woola gbɛɛ nu ma kwunewo ongyon saan nghataa ba onɔ ngwi ani ka kyon kɛ mbi iSidza mani.>> ");
INSERT INTO utr_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Ta Agripa nya iFɛstusu gbɛɛ, <<I mina ani ofwo ongyulɔ nɛ abuen.>> O gbɛɛ, <<Ekeka ta o ka fwon.>> ");
INSERT INTO utr_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Tegblifan nɛ, Agripa yi iBɛnisi wewo datu kaka ozu okwakye yi engyukwo oblakwutsɛ ama olɔngbɔ-lɔngbɔ bɛyi ama ogbe inggisɛ teyi mi ogalu nani. IFɛstusu si woola nu ma kye iPol kaka ifun. ");
INSERT INTO utr_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","IFɛstusu gbɛɛ: <<Utɔ Agripa yi ema ama nto mmɛnɛ yi eyi duu, ema di ongyulɔ nɛ lɔɔ! Emi iJuda duu biibɛ yi ani mi iJerosalin bɛyi iSidzaria mmɛnɛni, le feela gbɛɛ o mɛ ngwi o ki dzɛ oshishe wuba. ");
INSERT INTO utr_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","N difwi gbɛɛ o kyungwɔ mɛ ondu ikwu ba, kpaa ikyegbɛɛ o kye akwɔ mgban kɛ mbi ongyufa nɛ, n kye weka okyon dɛsɔ lu iRoma. ");
INSERT INTO utr_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Nghaduu n sulu itɔdzɛ onyonyi ngwi n ka lɔ nu Ugabaidu ikye inggisɛ nɛ ba. Nɛ n kyon ba inai ema duu, onghaangha duu yɔ mbi abu utɔ Agripa, azukwu ni ema kyan di kana n ka tu itɔdzɛ ngwi n ka lɔ. ");
INSERT INTO utr_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Lubana i tso ozoyeye ba, olɔ itɔdzɛ obube ikye inggisɛ obawi ba ta kyon dɛsɔ lu mbi Ugabaidu.>> ");
INSERT INTO utr_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Nɛ Agripa nya iPol gbɛɛ, <<N nu abu ofɛ gbɔdzɛ mgbi abu mani.>> Nɛta iPol kyɔ abɔ si wita ogbondu ewon gbɛɛ: ");
INSERT INTO utr_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","Utɔ Agripa ikyese dɛn okwudzɛ inai abu inɛ ogbondu ewani mi ungwɔ obube ngwi emi iJuda gbe tukwu ani ewo duu nɛni, ");
INSERT INTO utr_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","onghaangha duu ngwi abu ye aletɔ bɛyi angwodzɛ mgbi emi iJuda saan nɛni. Nghanɛ n tɛkyɛ nu abu shitukwu gen adɔ saan. ");
INSERT INTO utr_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","<<Emi iJuda duu ye odzɛɛdzɛ mgbi ani kyɛ ongbɛ, mi okyɛɛ esɛ mgbi ani mi ɛsɛ mgbi ani, bɛyi iJerosalin kpaa. ");
INSERT INTO utr_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","A teyi ye ani onɔ kɛ onɛnɛni dika kyɔ obwɛndɛ, ni imina ma yɔ, ani li emi iFarasi ama ngwu nghao fyumfye mi odzɛ Imgbasho mgbi eyi nɛni. ");
INSERT INTO utr_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Ikyenghanɛ li mi ikye ɛwɛ ogbe byiibyi mi ondu odzɛɛdzɛ ngwi Imgbasho dzɛ yi emi otseyi ma ngwi a le fwo ani ikwɔ inɛ aani. ");
INSERT INTO utr_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Li ondu odzɛɛdzɛ ngwi agwɔ mgbi eyi iwyodefa le sunu Imgbasho onɔ yi otu gbɛɛ ni ama wa di dafi i ka ba mani. Utɔ dee, li ikye ɛwɛ ogbe byiibyi nɛ ngwi emi iJuda le dulu ongwufabɔ mbi ani aani. ");
INSERT INTO utr_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Kyɔnɛse i fyi ema mfye onoyɛyɛ gbɛɛ Imgbasho li kyile inggisɛ mi ikwu? ");
INSERT INTO utr_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","<<Ani abuani kpaa teyi gbela gbɛɛ i gbuo nin kyɔ alungwɔ ama ndzɛ kyɛmɛ duu ikye okye afɔ twɛsɛ yi iyi mgbi iYesu ongwi iNadzareti nɛni. ");
INSERT INTO utr_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Di li ungwɔ ngwi ani kyɔ mi iJerosalin yɛyɛ kpaa aali. Mi ogbela-gbela mgbi engyukwo ama ofifɛ n gbe emi osaan kwuba wokɛ obawi, ani di li onyi mbi ama nwo abɔ ogbela gbɛɛ ni a gbɔ ma ikwɔ ngwɔ ma. ");
INSERT INTO utr_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Onɔ ibyibyi n kyikyɛ mi ozu okwakye mgbi emi iJuda idzidza-dzidza ikye okwo ma adɔ, di li fya osi ma nu ma fya Imgbasho ito. Dafi itingga kyɔ ani yi ama ma, n lu anengye kpaa oka nu ma isɔ. ");
INSERT INTO utr_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","N kyɛɛ okɛ itɔ agaba nɛ mi iDamasiko mi ondu onuunu yi ogbela-gbela mgbi engyukwo ama ofifɛ. ");
INSERT INTO utr_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Utɔ dee, ngwi onɔ dɔ idzidzɛ udɛ ngwi ani kye ofɛ dikye le kɛ nɛ, ani di osa kyɛ esho, gbosa ngha onɔ, naabɔ yawo ani yi ama nwafɔ yi ani mani. ");
INSERT INTO utr_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Eyi duu zudɔ wokɛ esɛ, man ani fwo ela le gbɔ yi ani mi ondu Aramiki gbɛɛ, <iSol, iSol, kyɔnɛ abu le nu ani isɔ ngha? Mnda ka yagba kye afɔ twɛsɛ yi okwuta ogbon ba.> ");
INSERT INTO utr_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","<<Ta ani byita gbɛɛ, <Li abu emɛ, Otsɛ?> Otsɛ nu uka gbɛɛ, << <Li ani iYesu ngwu abu le nu ani isɔ mani. ");
INSERT INTO utr_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Onɛnɛ kyato dzɛkunto. Ani mblegba tu abu ikye okye abu yɛɛ ongbidɔ bɛyi obwɛndɛ mi ungwɔ ngwi abu di mbi ani bɛyi ungwɔ ani ka tso abu mani. ");
INSERT INTO utr_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","N ka nagbɛ abu mi abɔ emidabu yi abɔ Udzengye. N le dɔ abu esɔ mboma ");
INSERT INTO utr_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","ikye okwulu ma inɛ di kyata ma mi iyifu luba osa, bɛyi mfye mgbi iSatan luba abɔ mgbi Imgbasho, azukwu ni a dzita ma yi ali ibwubwe di gbe ma tokɛ mbonyi yi ama ngwu a salu ma yɛɛ saan mi oyɛyɛ onuunu mbi ani mani.> ");
INSERT INTO utr_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","<<Nghanɛ, utɔ Agripa, n yama nghaadɔ mi inɛ odiidi nkyɛ esho na ba. ");
INSERT INTO utr_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","N wita mi iDamasiko, luba iJerosalin yi iJudia duu, bɛyi Anengye kpaa. N gbeesɔ gbɛɛ nu ma kyata luba mbi Imgbasho nu ma di tso okyata-kyata mgbi ama mi okyɔɔkyɔ. ");
INSERT INTO utr_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Li itɔdzɛ ngwi emi iJuda kpakli ani mi ifyudɛ ozu okwukwo osunu Imgbasho di fya ongwɔ ani ma aali. ");
INSERT INTO utr_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Nghaduu n tu otobyi-tobyi mgbi Imgbasho nghataa ba inɛ, n di kwudzɛ mmɛnɛ ikye okyɔ obwɛndɛ nya ama nshewo bɛyi ama n yɛyikpa kpaa. Ani le gbɔdzɛ onyonyi ngha ungwɔ ngwi ama ogbɛɛsɛ bɛyi iMose gbɛɛ ka wa kyɔ ma ba ");
INSERT INTO utr_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","gbɛɛ iMedzaya ka gyadzɛ, ngwi o di li inggisɛ ongwu ababɔ owa kyɛɛ mi ikwu nɛ, o ka gbɔ osa nya emidan bɛyi Udzengye.>> ");
INSERT INTO utr_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Duuse ni iPol ngyɛlu ogbondu ewon yɔ, iFɛstusu dzan elodzɛ ondu, o gbɔ mi ela esho gbɛɛ, <<Eka kwagbɔdɔ loo iPol! Afɛ mgbɔɔ okpayi kwuba nɛ nu ikye kyata loo.>> ");
INSERT INTO utr_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","IPol gbɛɛ, <<Ikye kyata lo ani ba, ugabaidu iFɛstusu,>> <<Odzɛ ngwi ani le gbɔ li otsitsi di li ingblimɔ. ");
INSERT INTO utr_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Utɔ bɛ yi ungwɔ ntonɛni, n ka yagba gbɔdzɛ biyan itukwu asisa. N noyɛyɛ gbɛɛ ungwɔ ntonɛ onyi kpaa byulu lon mi ikye waba, ikyekyɛ a kyɔn mi odaada ba. ");
INSERT INTO utr_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Utɔ Agripa, abu nu ama ogbɛɛsɛ oyɛyɛɛ? N ye o nu.>> ");
INSERT INTO utr_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Ta Agripa nya iPol gbɛɛ, <<Abu tsɛwɛ gbɛɛ mi ongwonɔ gwee nɛta elodzɛ mgbi abu ka yagba kyata ani yɛɛ inggisɛ iKrestuu?>> ");
INSERT INTO utr_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","IPol nu uka gbɛɛ, ni li onɔ bwee hona onɔ gblɔgɔdɔ kpaa, N le bɔ Imgbasho ibɔ gbɛɛ, no wa li abu yuwoo ta ba kpaa ama nle fwo ani inɛ nɛ duu ki kyata dzɛ dafi ani sini, kpaa itse yɔ nu ma ka ta ema ba.>> ");
INSERT INTO utr_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Utɔ yi iGɔna yi iBɛnisi bɛyi ama nsɔto yi ama duu kyato. ");
INSERT INTO utr_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","A dzata ifoozu, ngwi a kyi ge ewoma nɛ a gbɛɛ, <<Inggisɛ nɛ le kyungwɔ onyonyi ngwi mɛ ondu ikwongye hona kaka obawi ba.>> ");
INSERT INTO utr_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Agripa nya iFɛstusu gbɛɛ, <<IPol ki teyi tɛkyɛ gbɛɛ ni iSidza gbɔn ikwɔ bayɔ, o mɛ odzanta. ");
INSERT INTO utr_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Ngwi ondu wa bwa gbɛɛ uwaa ka gbe eyi lu iTali nɛ, a kye iPol yi emi obawi angbeka wo ongyukwo oblakwutsɛ ongwu nli ikye odi mi obyi oblakwutsɛ mgbi ugabaidu ngwu a li kwun di iJuliyɔsu na abɔ. ");
INSERT INTO utr_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Eyi kyɛɛ yi uwaa mi Adramatun eyi wewo obɛsɛ mi iga ama nto ondekyoo mi ayɛsɛ mgbi Asia di nyɛ kaka onekyoo. Aristaku, inggisɛ iMasidonia ngwu nkyɛ mi iTesalonika na, kyɛ yi eyi. ");
INSERT INTO utr_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Tegblifan nɛ, eyi bɛsɛ mi iSidon; nɛ iJuliyɔsu di iPol elela, nun ofɛ no kɛ mbi emi okan adzi nu ma nun ungwɔ ama nminan. ");
INSERT INTO utr_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Mmana eyi diyɛ lu onekyoo di nyɛ kwɛkwɛ yi ibu ongwi iSapru ikyekyɛ awo gbeleyi wuba. ");
INSERT INTO utr_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Ngwi eyi fa uwaa dzɛkyo onekyoo mi iga mgbi iSilisia yi iPamfyilia nɛ, eyi ka bɛsɛ mi iMira ongwi iLisia nani. ");
INSERT INTO utr_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Mi imbe na ongyukwo oblakwutsɛ di iwudza ongwi Alekdzandra le lu Itali man gbe eyi wokɛ ele. ");
INSERT INTO utr_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Eyi lu dumɔ-dumɔ mi egbe ibyibyi yi adzɛ kpakpa ka nyɛ kwɛkwɛ yi iSinidɔ. Ngwi awo gbela ni eyi kye inɛ byi imbe ngwi eyi le kɛ ma ba nɛ, eyi yɛ kye inɛ byi oyombo iSamɔ ikye ni ibu ongwi iKrete na tukwu eyi awo mani. ");
INSERT INTO utr_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Eyi nyɛ ondiiga nɛ mi isɔ wa to imbe ngwi a kwun di iFɛ Hɛvun, kwɛkwɛ yi ogalu iLasia. ");
INSERT INTO utr_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Eyi mbe onɔ kpakpa nyɛ wa, ma okyɛɛ ongwi iwudza nɛ yɛɛ okakewo ikyesinɛ onɔ Oga otukwondu ngwi a li dzata inggisɛ yi alobube kpaa nyɛ wa. Nghanɛ iPol wɛ ma ewodzɛ gbɛɛ, ");
INSERT INTO utr_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","<<Engyulɔ, n le di gbɛɛ agaba nɛ ka ba yi eyi odzili-dzili dika nu iwudza yi okye bɛyi oshishe mgbi eyi kpaa nyanya.>> ");
INSERT INTO utr_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Nghaduu ongyukwo oblakwutsɛ na gbela odzɛ owɛɛwɛ mgbi iPol ba kpaa kyɛdɔ elodzɛ mgbi inggisɛ ofa iwudza bɛyi otsungwɔ iwudza. ");
INSERT INTO utr_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Dafi iga iFɛ Hɛvun na tishi ola ele nghataa ni ogba ngyɛ ba nɛ, inggisɛ kwuba gbela gbɛɛ ni eyi kiyayi yi okyɛɛ, ka la iFɔni nghataa ni ogba ngyɛ. Nɛnɛ li iga mi iKrete nkye inɛ byi okwokyiikwokyi mgbi aca yi onɔdɛ bɛyi agwudu yi onɔdɛ nani. ");
INSERT INTO utr_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Ngwi awo aca wita ofa fee nɛman, a tsɛwɛ gbɛɛ di ama tu ungwɔ ngwi ama mina ma wa; nɛ a takye ashi obwa iwudza kwulɛsɛ ngwuta wokɛ iwudza, si kye ondu agobo iKrete dikye. ");
INSERT INTO utr_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Onɔ gwee nɛta awo okwokyiikwokyi mgbi agwudu yi onosa gbokyɛɛ mfyumfye kyɛ ibu wa fa eyi lu onekyoo. ");
INSERT INTO utr_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Awo na wa tsɛkɛ iwudza ta eyi yagba fa iwudza kye inɛ byi awo wuba; nɛta eyi nya yi iwudza ofaafa nɛ awo kyi gbelu iwudza le lu. ");
INSERT INTO utr_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Ngwi eyi nyɛ lu ongwɛ ibu ngwi a li kwun di iKauda nɛ, eyi fya kpakpa se wa yagba onu uwaa ongbungbɛ na gbobu ba. ");
INSERT INTO utr_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Ngwi a kyi kyelu uwaa ongbungbɛ wokɛ ifun nɛ, a kye odi bwalu iwudza bɛkɛ. Ngwi a mio gbɛɛ di iwudza ka ka kwo esɛ mi mfyan mgbi iSati nɛ, a takye ashi obyi iwudza kwulɛsɛ ngwuta wokɛ eni ni iwudza le kwo lu dumɔ-dumɔ. ");
INSERT INTO utr_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Tegblifan, dafi awo na kale fa nghaabɔ le gbobulu iwudza nɛ a wita omwa okye yangwuta mi eni. ");
INSERT INTO utr_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Mi egbe ongwu ta nɛ, a kye abɔ mgbi ama abuoma shɛ okye iwudza angbeka yangwuta. ");
INSERT INTO utr_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Ngwi onɔ hona ofyia kpaa eyi di ma wuba egbe ibyibyi, onikyawo kpaa kale fa nɛ, eyi gbɛwɛ ngwuta gbɛɛ eyi ka watɔ wuba. ");
INSERT INTO utr_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Dafi inggisɛ ntonɛ kyikyɛ onɔ tunto tu ungwogye gye ba nɛ, iPol kyato nya ma gbɛɛ: <<Engyulɔ, ema ki gbela odzɛ mgbi ani owɛ-wɛ mi iKrete gbɛɛ ni ema ka fa ba na yɔ; ungwɔ ama nnyanya di byulu lo ema ntonɛ kika kyɔ ba. ");
INSERT INTO utr_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Nghaduu onɛnɛ, ani kwu ema ɛwɛ wo gbɛɛ ni ema kiyayi mi itukwu mgbi ema fyumfye-fyumfye, ikyekyɛ inggisɛ mgbi ema onyi kpaa ka byulu ba, sede li iwudza ta ka nyanya. ");
INSERT INTO utr_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Mi otu ongwu dɛdɛ na, ongyesɔ mgbi Imgbasho mgbi ani ngwu ani li sunun na wa kwudzɛ kwɛkwɛ yi ani ");
INSERT INTO utr_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","si nya ani gbɛɛ, <Ka wimio ba iPol, iSidza ka fwo abu ikwɔ kyɛmɛ; ma di li ikye mgbi abu Imgbasho ka dzata ama nwoto iwudza yi abu ntonɛ duu oshishe. ");
INSERT INTO utr_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Nghanɛ fyumfye itukwu kpɔɔ na engyulɔ, lubana ani noyɛyɛ gbɛɛ ungwɔ ngwi Imgbasho gbɔ nɛ ka kyɔ ngha yɛyɛ. ");
INSERT INTO utr_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Nghaduukpaa, iwudza mgbi eyi ka ka fatila dɔkɛ ibu mbeka.>> ");
INSERT INTO utr_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Mi otu ongwi iwyodenɛ ma kpaa awo na ka kye eyi le ga kyɛ Onekyoo Adratiki, ngwi otu wa gheefa nɛ, ama ofa iwudza difwi gbɛɛ ama le dzɛ kwɛkwɛ yi ondikyi. ");
INSERT INTO utr_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","A mba okɛɛkɛ mgbi eni si di gbɛɛ li atafɔ ideli onyi dɔn osu. I kye onɔ gwee nɛ, a di mba tu atafɔ ngwusenɛ dɔn iwyo. ");
INSERT INTO utr_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Ngwi eyi le mio gbɛɛ eyi ka wa gyɛkɛ akwutsɛ nɛ, a kyi takye iyudza obwa iwudza kwulɛsɛ nghi enɛ yaokɛ eni mi iyikpa di bibɔ gbɛɛ ni egbe fa. ");
INSERT INTO utr_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Ngwi i mina ama ofa iwudza otse dzamata nɛ, a kyi shɛlu uwaa ongbungbɛ na wokɛ eni tole kyɔ ɛwɛ dafi ama takye iyudza okwu iwudza kwulɛsɛ le ngwuta wokɛ eni mi iyayi mani. ");
INSERT INTO utr_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Ta iPol nya okwukwo ogbakwu bɛyi oblakwutsɛ ntona gbɛɛ, <<Ni inggisɛ ntonɛ tɔ dzata iwudza yɔ ema ka watɔ ba.>> ");
INSERT INTO utr_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Nghanɛ oblakwutsɛ ntona kye dzɛlu odi ngwi a kye ongwuwaa na sha ele ma non fɛ lu. ");
INSERT INTO utr_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Duuse ni egbe fa nɛ, iPol tɛkyɛ yi ama duu gbɛɛ ni a gye ungwogye. O gbɛɛ, <<Egbe iwyodenɛ inɛ waani, itukwu kaka ema ewo jo ema gye unkonyi ba. ");
INSERT INTO utr_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Kpaa onɛnɛ n tɛkyɛ nu ema gbɛɛ ni ema gye ungwogye adzi ni ema dzɛ oshishe. Lubana alotu onyi kpaa ka kwɔ mi ikye mgbi inggisɛ onyi ba. ");
INSERT INTO utr_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Ngwi iPol gbɔdzɛ nɛ ngyɛ nɛ, o kyi gbelu ibredi angbeka si ta Imgbasho angba mi inai ma duu. Kyi mwalu wita ogyeegye. ");
INSERT INTO utr_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Ama duu fyumfye itukwu di gye ungwogye abuoma. ");
INSERT INTO utr_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Eyi ama nwoto iwudza duu li inggisɛ ideli efa ngwuseta dɔn iwyo diwyegyin. ");
INSERT INTO utr_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Ngwi a gye ungwogye dafi a mina ma nɛ, a kyi gbelu ungwogyowe nsisi duu yangwuta mi onekyoo ikye okyi mwalu mlo mi iwudza. ");
INSERT INTO utr_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Ngwi egbe wa fa nɛ, ama ofa iwudza difwi agobo ma wuba, kpaa a di iga mfyan. Nghanɛ a tsɛwodzɛ gbɛɛ ni ama yagba yɔ, ama ka fa iwudza na nyɛ mfyan ka bɛkɛ esɛ. ");
INSERT INTO utr_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Dafi a kye dzɛlu iyudza okwu iwudza kwulɛsɛ nɛ, a dzitama mi eni di kye shɛlu odi ama ntsɛ anghi ntona mi onɔ na kpɔɔ. Ta a kyile angwuto ogbaawo iwudza ikyegbɛɛ ni awo fa iwudza bɛkɛ iga. ");
INSERT INTO utr_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Nghaduu iwudza kwo esɛ kye ikye shawokɛ mfyan kye inɛnɛ byi esho fatila yagba okiyayi wuba man akpeni gbobu iwudza mi iyikpa. ");
INSERT INTO utr_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Ama oblakwutsɛ tsɛwɛ okyi ngwɔlu emi obawi ntonani di a wa tsɛ eni lu agobo ka tsebyulu. ");
INSERT INTO utr_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Nghaduu i mina okwukwo ogbakwu na odulu oshishe mgbi iPol watɔ, nɛ o kwɔ ma oweka mgbi ama ikyenghanɛ o wo ama n ye eni otsɛɛtsɛ ola gbɛɛ nu ma tsɛ eni lu agobo. ");
INSERT INTO utr_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","Ama nsisi ka gbe igɛgɛ tukwu otsokplekwɔ bɛyi ombwumbwu uwaa lu agobo. Li ngha ngwi eyi duu bɛsɛ saan aali. ");
INSERT INTO utr_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Ngwi eyi wa bɛsɛ saan nɛ eyi difwi gbɛɛ li mi ibu ongwi iMɔta. ");
INSERT INTO utr_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Emi ibu ntona tso eyi okpitukwu ngwi eyi din ye ba. A gbɛ eyi di mɛ ola wo eyi ikyekyɛ mmbwo le kya ofu dile yi. ");
INSERT INTO utr_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","IPol waa akyikye ekwɔ kwutokɛ, ngwi o le sa wokɛ ola nɛ, ogidzi ngwi olola non tasɛ ton tandri won abɔ. ");
INSERT INTO utr_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Ngwi emi ibu di ifa na fatila kwodzɛ abɔ nɛ, a gbɔ yi ewoma gbɛɛ, <<Inggisɛ nɛ ka li inggisɛ ongwɔ inggisɛ kyɛmɛ-kyɛmɛ; lubana dafi o watɔ mi ekyoo okwukwo nɛ kpaa, obube mgban ka non dzɛ oshishe ba.>> ");
INSERT INTO utr_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Kpaa iPol ngwi ifa na wokɛ ola unka di kyɔn ba. ");
INSERT INTO utr_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Inggisɛ ntona kye ɛwɛ byi gbɛɛ o ka mwɛ ewo naadi tsɛɛsɛ kwulu ntunto. Nghaduu ngwi a fɛ onɔ kɛ di di unkonyi okakewo kyɔn ba nɛ, a kyatitukwu mgbi ama di gbɛɛ o li Imgbasho. ");
INSERT INTO utr_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Ogalu dzɛ kwɛkwɛ mi imbe na ngwi li mgbi iPobilu, utɔ mgbi ibu nani. O gbɛ eyi mi udan abɔ efa di kyɔ yi eyi saan egbe eta. ");
INSERT INTO utr_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Otsɔn dotse ladzɛ esɛ, awo bwan o dile nya adama. IPol kaka ka din, ngwi o bibɔ won ngyɛ nɛ, o gbe abɔ dɔn ikye di ngyɛlun ootse. ");
INSERT INTO utr_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Ngwi ungwɔnɛ kyɔ nyɛ nɛ, emi ootse angbeka mi ibu na duu ba, a di ngyɛlu ma ootse. ");
INSERT INTO utr_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","A nu eyi mmwɛ mi ofɛ idzidza-dzidza, ngwi eyi di wa wewo onyɛ ongwi eni lu nɛ, a nu eyi alungwɔ ngwi eyi mina mi ikye okyɛɛ nani. ");
INSERT INTO utr_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Ngwi i wa nyɛ ofyia eta nɛ, eyi kaka iwudza oka ngwi a dzanta mi ibu na owa olɔlɔ olu. Li iwudza ongwi Alekdzandra ngwi a kye ambɛ dzɛ ikyen gbɛɛ Imgbasho ongwefa. ");
INSERT INTO utr_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Eyi wa bɛsɛ mi iSiraku, di la ele egbe eta. ");
INSERT INTO utr_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Mi imbe na eyi di nyɛ ongwi eni ka kaka iRejun. Tegblifan man awo iwu gbokyɛɛ, ngwi i di fa egbe oka nɛ eyi to iPuteli. ");
INSERT INTO utr_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Mi imbe na eyi tu ama okyɛdɔ iYesu angbeka, a bɔ eyi wa la yi ama ikyidu olɔlɔ. Man eyi si kyɛɛ wa kaka iRoma. ");
INSERT INTO utr_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Ama okyɛdɔ iYesu emi imbe na teyi fwo gbɛɛ eyi kyɛma, man a lukwu eyi nghataa luba idu Apiɔ bɛyi imbe ngwi a kwun gbɛɛ Ozu eta mgbi ingyoga owa kpatsɛ eyi. Ngwi iPol dili ma nɛ, o ta Imgbasho angba itukwu di fyonmfye. ");
INSERT INTO utr_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Ngwi eyi ka kaka iRoma ma, a nu iPol ofɛ gbɛɛ no la ozu yuon kpaa oblakwutsɛ nu ma ngyon. ");
INSERT INTO utr_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Ngwi i kye egbe eta nɛ, iPol kwu engyukwo emi iJuda kwakye, dafi a wa kwakye nɛ, iPol nya ma gbɛɛ: <<Emi ongwunani, ani kyɔ nkonyonyi ongha emideyi adɔ naadi aletɔ mgbi emi otsikyeyi ba, kpaa a bwa ani mi iJerosalin di kye ani wo emi iRoma abɔ. ");
INSERT INTO utr_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","A kya mi odzɛ mgbi ani di mina ma odzita ani ikyesinɛ ani kyungwɔ obube nmɛ ondu ikwongye ba. ");
INSERT INTO utr_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Kpaa emi iJuda fwa, nghanɛ i yɛɛ kyɛmɛ ngwi ani ka tɛkyɛ nu ma yile ani luba mbi iSidza. Nghaduu ani dzɛ yi odzɛ onyi ogbe tukwu emidani ewo ba. ");
INSERT INTO utr_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Li itɔdzɛ nɛ ngwi ani gbɛɛ ni ani di ema di gbɔdzɛ yi ema. Li mi ikye ɛwɛ ogbe byiibyi mgbi emi Israi ma ngwi a bwa ani adi mi ashi nɛ aani.>> ");
INSERT INTO utr_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","A nun uka gbɛɛ, <<Eyi tu afɛ onyi nkyɛ mi iJudia mi ikye odzɛ mgbi abu ba, emi ongwuneyi onyi nkyɛ mi imbe na nya eyi hona gbɔdzɛ obube onyi mi ikpewo abu ba. ");
INSERT INTO utr_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Nghaduu i mina eyi ofwo ɛwɛ otsɛɛtsɛ mgbi abu, lubana eyi ye dafi inggisɛ mi ali imbe duu le gbɔdzɛ osuse ba ikpewo ayɛ inggisɛ ntona mani.>> ");
INSERT INTO utr_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","A kye egbe dzɛ owa kwakye yi iPol, di ba mi mmbwo kpakpa nghaabɔ ogbugbe mi imbe ngwi o dzɛ mani. O li gbɔdzɛ esutɔ mgbi Imgbasho nya ma mi egbegbe nghataa onɔ li gbɛsɛ dile biibɛ yi ama mi ola mgbi iMose bɛyi oyegbɔ gbɛɛ nu ma noyɛyɛ mbi iYesu. ");
INSERT INTO utr_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Engyukwo angbeka mboma noyɛyɛ mi odzɛ ngwi o gbɔ mani, kpaa angbeka yɔ gbela ba. ");
INSERT INTO utr_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Dafi angwodzɛ tɔ mi idzidzɛ mgbi ama nɛ, a wita oganya mi onɔ ngwi iPol ngyɛlu odzɛ nɛ ogbɔɔgbɔ mani gbɛɛ: <<Onodzi Osaan na gbɔdzɛ otsitsi mi ikye mgbi emi otsikyema mi onɔ ngwi o gbɔdzɛ nyɛ mbi oyegbɔ Adzaya mani gbɛɛ: ");
INSERT INTO utr_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","<< <Kɛ mbi inggisɛ ntonɛ dika nya ma gbɛɛ, <<Ema kale fwo alonɔ kpaa ka yama gbosa lo ema ba; ema kale di alonɔ kpaa ema ka yama difwi ba.>> ");
INSERT INTO utr_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Itukwu mgbi inggisɛ ntonɛ tiishu; a li fwo kpaa gbadikye, a di kye inɛ mgbi ama tukwu. Lubana a kika di yi inɛ mgbi ama, fwo mi adɔ mgbi ama, difwi mi itukwu mgbi ama di kyata ba mbi ani Imgbasho ta ani kika ngyɛlu ma ootse.> ");
INSERT INTO utr_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","<< <Ikyenghanɛ ani mina ni ema ye gbɛɛ owatɔ-watɔ mgbi Imgbasho nɛ a kye dɛsɔ nu Udzengye, ama yɔ a ka kyi gbɛlu!>> ");
INSERT INTO utr_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","Ngwi iPol gbɔ elodzɛ ntonɛ ngyɛ nɛ, emi iJuda si lu kale tangwodzɛ yi ewoma kpakpa. ");
INSERT INTO utr_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","IPol kwu ozu onova efa le gbɛ inggisɛ ama nba owa din duu. ");
INSERT INTO utr_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","Ngwi imbe fyin ba nɛ, o gbeesɔ mgbi esutɔ mgbi Imgbasho yi abɔ otsigɛgɛ di tsungwɔ mgbi Otsɛ iYesu iKrestu.");
INSERT INTO utr_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Afɛ nɛ kyɛ mbi iPol, ongbidɔ mgbi iKrestu iYesu, ongwu a kwun ela non gbikye iYesu, ngwu a di dulun dzɛkɛ ikye ogbɔ Esɔ Osuse mgbi Imgbasho nani. ");
INSERT INTO utr_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","Esɔ Osuse nɛ Imgbasho plɛ zondu nyɛ mbi ama ogbɛɛsɛ mi Afɛ Osaan. ");
INSERT INTO utr_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","Esɔ Osuse nɛ li odzɛ mgbi Ongwan, mi odzɛɛdzɛ mgbi inggisɛ owamyɛ yɔ, o li ongwiba mgbi iDevedi. ");
INSERT INTO utr_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","A kyon tso gbɛɛ o li ongwɛ Imgbasho mi onɔ ngwi a kyilon mi ikwu mi mfye mgbi Onodzi Osaan nani: O li iYesu iKrestu Otsɛ mgbi eyi. ");
INSERT INTO utr_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","Li mi ikpewon bɛyi ikye iyi mgban ngwi eyi yɛɛ ama ogbikye iYesu ngwi mtsɛ di dɔ eyi otso Udzɛ duu ofɛ gbɛɛ nu ma siikye nu di dzɛ yi oyɛyɛ onuunu aani. ");
INSERT INTO utr_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","Ema kpaa wodzɛ idzidzɛ ama ngwu a kwu ma ela gbɛɛ nu ma yɛɛ emidi iYesu iKrestu nɛni. ");
INSERT INTO utr_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","Ani le lɔ afɛ nɛ kɛ mbi ema emi iRoma, nkpa Imgbasho itukwu ngwu O di kwu ema ela gbɛɛ, ni ema li emi osaan nani: Elela yi iyu nkyɛ mbi Imgbasho Otseyi yi Otsɛ iYesu iKrestu na no dzɛ yi ema duu. ");
INSERT INTO utr_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","Ababɔ yɔ, angba mgbi ani le kɛ mbi Imgbasho mgbɛn ikpewo iYesu iKrestu ikye ema duu, ikyena a gbɔdzɛ oyɛyɛ onuunu mgbi ema kpatsɛ ɛsɛ duu. ");
INSERT INTO utr_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","Imgbasho, Ongwu ani li kyɔn idɔ itukwu onyi mi ogbeesɔ osuse mgbi ongwan na li obwɛndɛ mgbɛn dafi n li wɛ ema alonɔ ");
INSERT INTO utr_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","mi ibɔ mgbɛn obɔɔbɔ mani. N di bɔ gbɛɛ kpakpana Imgbasho ka nu ani ofɛ nin ba mbi ema. ");
INSERT INTO utr_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","I mina ani odi ema adzi nin kye umba mgbi onodzi nu ema onu ema fyumfye mi oyɛyɛ mgbi ema onuunu, ");
INSERT INTO utr_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","ikyegbɛɛ, ni eyi fyi eka mfye itukwu mi oyɛyɛ onuunu mgbi ewe. ");
INSERT INTO utr_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","I mina ani gbɛɛ ema ki ye emi ongwunani, dafi onɔ ibyibyi ani weka okɛ mbi ema mani, kpaa ofɛ nin ba nghataa ba onɛnɛni. I mimɛn gbɛɛ nin ka tu ama okyatitukwu mi idzidzɛ ema, yɛyɛ dafi ani tu mi idzidzɛ udzɛ angbeka kpaa nani. ");
INSERT INTO utr_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","N dzɛ yi idɔ okyɔ yi emi iGriki bɛyi emi iGriki ba kpaa, ikye ama okwiinɛ bɛyi ogbadrɔ duu. ");
INSERT INTO utr_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","Li ngha ngwi i tsɛ ani olo kpakpa ogbɔ Esɔ Osuse nya ema ama nto iRoma aali. ");
INSERT INTO utr_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","Bana ayiwi kwu ani ogbɔ Esɔ Osuse nɛ ba, ikyekyɛ li mfye mgbi Imgbasho ikye owatɔ-watɔ mgbi ali inggisɛ nnoyɛyɛ duu: ababɔ ikye emi iJuda duuse Udzengye. ");
INSERT INTO utr_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","Lubana Esɔ Osuse nɛ Imgbasho kye tso ofɛ ngwi inggisɛ ka dzɛ nyaan yi Ongwu mani: ngwi li mi oyɛyɛ onuunu mi owita-wita nghataa ka dondu. Yɛyɛ dafi Afɛ lɔ mani gbɛɛ: <<Ama osaan ka dzɛ oshishe mi oyɛyɛ onuunu.>> ");
INSERT INTO utr_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","Itingga mgbi Imgbasho nɛ tsotɔ mi esho ikye ama ngbela yan ba duu yi emi imbaali ama nli si otsitsi bɛsɛ yi imbaali mgbi ama mani. ");
INSERT INTO utr_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","Lubana ungwɔ ndzɛ gyɔ ngwi a ka ye Imgbasho daada ba, ikyekyɛ Imgbasho kye tso ma gedee. ");
INSERT INTO utr_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","Inggisɛ sulu itɔdzɛ ogbɛɛ n ki ye wuba, lubana wita mi onɔ ɛsɛ ota-ta majo, odzɛɛdzɛ mgbi Imgbasho ngwi a li din ba, mfye mgban ogyegwu, mbisɔ onghaangha mgban duu, O nu ma di saan adzi ni inggisɛ ka yagba tangwan ba du. ");
INSERT INTO utr_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","Lubana ngwi a ye Imgbasho nɛ kpaa, a li nun mmwɛ gyɔ yan hona tan angba ba, kpaa ɛwɛ otsɛɛtsɛ mgbi ama yɛɛ ayayi, ikwangha itukwu mgbi ama yifu. ");
INSERT INTO utr_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","Ama yɔ tsɛwɛ gbɛɛ ama kwiinɛ, nghaduu a yɛɛ emi ikwangha ");
INSERT INTO utr_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","ngwi a kile sunu Imgbasho nli kwulu ba na ma, a yɛ le sunu adagyɛ ngwi a kpaakpa dzɛ dafi inggisɛ naadi ingwunɔ naadi mmbwaba hona ungwɔ ama okwo ifu esɛ (nli kwulu ntonani). ");
INSERT INTO utr_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","Nghanɛ Imgbasho dzata ma nu ma kyɔ alungwɔ ayiwi ngwi itukwu mgbi ama mina mani. Ewodzɛ idza mgbi ama nu ma kyungwɔ ayiwi ola yi ewoma di nu ikpewo mgbi ama mmwɛ wuba. ");
INSERT INTO utr_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","A kyi nyinɛ otsitsi mgbi Imgbasho yi atsika, yɛ le sunu ungwɔ ama Imgbasho taata ngha Imgbasho ntaata ungwɔ, nmɛ ngwi a ka tsan gyegwu nani. No dzɛ ngha. ");
INSERT INTO utr_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","Mi itɔdzɛ nɛ Imgbasho dzata ma nu ma le mina ungwɔ ayiwi. Engyaa mgbi ama kpaa le la yi engyulɔ dafi atta ta ma wuba, yɛ le la yi ewoma. ");
INSERT INTO utr_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","Mi itɔ ofɛ nɛ kpɔɔ engyulɔ kpaa dzata abɔ ola yi engyaa yɛ le la yi ewoma. Engyulɔ le kyungwɔ ayiwi yi ewoma, di tu umba mgbi adɔ okwookwo ngwi gyɔ yi ikwangha ali mgbi ama nani. ");
INSERT INTO utr_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","Okiyayi yɔ, ngwi a fwa ogbela Imgbasho nɛ, O dzata ma ni ewodzɛ ikwangha mgbi ama kye ma teyi. Li ikyengha ngwi a le kyɔ idza nwogyɔ a ki le kyɔ ba aali. ");
INSERT INTO utr_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","Imbali gbɛ ma sɔ, ungwɔ ibwubwe yi nggwɔ yi mmgbe. Anyi mbwo ma itukwu yi inggisɛ ongwɔɔngwɔ yi ibe ogboogbo yi okpagyewo bɛyi inggisɛ okye wo itukwu. A li ama odziidzɛ, ");
INSERT INTO utr_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","ama ogbaagya yi ama Imgbasho ta ma anyi, ama ofyito yi emi imoga bɛyi abɔ otsigɛgɛ; a li ba yi ofɛ ofufɛ okyungwɔ obube; di li ngha ama omba ma adɔ; ");
INSERT INTO utr_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","a dzɛ yi ozoyeye ba, oyɛyɛ onuunu ba, a tishi itukwu ba, a li di elela ba. ");
INSERT INTO utr_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","Ngwi a ye dafi ola mgbi Imgbasho gbɛɛ, inggisɛ nkyɔ itɔ ali ntonɛ gyɔ ondu ikwongye nɛ kpaa, a kɛɛkiyayi okyungwɔ ntonɛnɛ ta ba kpaa, a li tu ama nle kyɔ itɔ ali nɛ wo nu ma kiyayi. ");
INSERT INTO utr_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","Nghanɛ, ema ama nli fwo inggisɛ angbeka ikwɔ nɛ, dzɛ yi ɛkyɛ oto-to wuba, lubana mi ali itɔ ofɛ ngwi ema le fwo angbeka ikwɔ duu, ema le ngyɛlu yi ewema, ikyekyɛ ungwɔ ngwi ema le fwo angbeka ikwɔ mi ele nɛ, ema le kyɔ ma tsatsa. ");
INSERT INTO utr_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","Ikyenghanɛ eyi ye ta gbɛɛ ikwɔ ofwoofwo mgbi Imgbasho mbi ama nle kyɔ itɔ ungwɔ ntonɛ li mi otsitsi. ");
INSERT INTO utr_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","Nghawanɛ ni abu inggisɛ ɛwɛwɛ le fwo ma ikwɔ dile kyɔ ungwonyi yi ama ma, o tsɛwɛ gbɛɛ o ka watɔ mi ikwɔ ofwoofwo mgbi Imgbashoo? ");
INSERT INTO utr_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","Naadi ema kwu itukwu oleewo mgbi Imgbasho okwulewo yi onyɔtsɛ bɛyi itukwu mgban oshiishi nɛ shanyɛ? Mi otsitsi yɔ ema ye dafi Imgbasho di eyi elela mani, ikyesinɛ o le tobyi eyi ni eyi kyata mi ali ibwubwe mgbi eyi. ");
INSERT INTO utr_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","Kpaa mi ikye adɔ onghaangha bɛyi itukwu otiishu mgbi ema yɔ, ema le gbe adɔ okwookwo ngwikwo le fɛ egbe itingga mgbi Imgbasho, onɔ ngwi ikwɔ mgban ofwoofwo mgbi otsitsi na kawa tsotɔ mani. ");
INSERT INTO utr_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","Imgbasho <<Ka wa nu ali inggisɛ yɛyɛ dafi otsungwɔn kyɔ mani.>> ");
INSERT INTO utr_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","Ama nkwunewo kyɔ osuse kyɛdɔ okwɔkwɔ, yi mmwɛ bɛyi oshishe nka dondu ba na, o ka nu ma oshishe ogyegwu. ");
INSERT INTO utr_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","Nghaduu ama nli tsuntsli di fwa otsitsi dile kyɛdɔ ofɛ ibwubwe yɔ, itingga yi itukwu owulu-wulu ka dzɛ ikye ma. ");
INSERT INTO utr_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","Okakewo yi isɔ okwulewo ka dzɛ ikye ali inggisɛ owamyɛ nkyungwɔ ibwubwe yɔ: ababɔ mbi emi iJuda, man mbi ama nli emi iJuda ba; ");
INSERT INTO utr_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","nghaduu Imgbasho ka kye okwɔkwɔ, mmwɛ yi iyu nu ali inggisɛ nkyɔ osuse duu: ababɔ mbi emi iJuda, bɛyi mbi ama nli emi iJuda ba. ");
INSERT INTO utr_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","Lubana Imgbasho li tso osadu-sadu ba. ");
INSERT INTO utr_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","Ama nkyɔ obube ngwi ola dzɛ waba ma kpaa, a ka ngwɔ ma ikwɔ imbisɔ ngwi a dzɛ yi ola ba mani, ama nkyɔ obube ngwi ola dzɛ yɔ, a dika ngwɔ ma ikwɔ mi ola mani. ");
INSERT INTO utr_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","Lubana li ama nfwoofwo ola mata le saan mi inɛ Imgbasho ba, kpaa li ama nngyo ola ma ngwi a ka kwu ma di ama osaan aali. ");
INSERT INTO utr_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","(Udzengye dzɛ yi ola ba, kpaa nu ma le kyɔ dafi ola mina ma yɔ, i yɛɛ ola mboma, dafi a dzɛ yi ola ba nɛ kpaa. ");
INSERT INTO utr_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","A tso ambɛ gbɛɛ ungwɔ ngwi ola mina ma, a lɔ ma mi itukwu mgbi ama, dafi ewodzɛ mgbi ama kpaa dile kyɔ obwɛndɛ mani. Ɛwɛ otsɛɛtsɛ mgbi ama kpaa le nu ma obube hona nagbɛ ma.) ");
INSERT INTO utr_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","Ungwɔnɛ ka wa kyɔ mi egbe ngwi Imgbasho ka nu iYesu iKrestu gbɔ inggisɛ ikwɔ mi ungwɔ ama a le kyɔ daada, dafi Esɔ Osuse mgbɛn gbɔ mani. ");
INSERT INTO utr_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","Ikyenghanɛ, ni abu kwu ewabu di emi iJuda; di kye abɔ byikɛ ola, di kye odzɛɛdzɛ mgbi abu yi Imgbasho le kwaayi; ");
INSERT INTO utr_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","di ye owitukwu mgban yɛ gbela yi ungwɔ nnghaangha ikyekyɛ ola tso abu; ");
INSERT INTO utr_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","di gbela otsitsi gbɛɛ abu li inggisɛ otso obinɛ ofɛ, di li osa mgbi ama nwoto iyifu, ");
INSERT INTO utr_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","abu li inggisɛ owɛ emi ikwangha odzɛ, abu li otsetse mgbi ɛngbɛ ama oshilɛlɛ, ikyekyɛ abu ye odzɛɛdzɛ mgbi ola bɛyi otsitsi mgban, ");
INSERT INTO utr_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","nghama abu, o li tso angbeka, kyɔnɛ ngwi o tso ewoo wuba? Abu nle gbeesɔ gbɛɛ ni inggisɛ ka yimi ba nɛ, o kale yimii? ");
INSERT INTO utr_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","Abu nli gbɛɛ ni inggisɛ ka kyɔ amah ba nɛ, o li kyɔ amaah? Abu ngwu angwula ta abu anyi nɛ, o li yimi mi ozu angwulaa? ");
INSERT INTO utr_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","Abu nli kyile ewo esho yi ola nɛ, o li kwu Imgbasho shanyɛ mi ola ofaafaa? ");
INSERT INTO utr_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","Dafi a lɔ mi afɛ gbɛɛ: <<A fya iyi Imgbasho ito mi Anengye ikye abu.>> ");
INSERT INTO utr_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","Kini abu ngyo ola yɔ, ikyɛ sulu oyabɔ, kpaa ni abu foola yɔ, abu yɛɛ dafi o kyiikyɛ ye kpaa ba. ");
INSERT INTO utr_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","Ki ama nkyiikyɛ ba le kyungwɔ ama ola mina ma, Imgbasho ka di ma dafi ama nkyiikyɛ ntona baa? ");
INSERT INTO utr_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","Mi otsitsi yɔ, Ama nli emi iJuda ba ngwu a kyan ikyɛ ba kpaa ngyo ola yɔ, ka yagba nu abu ngwu dzɛ yi ola di kyiikyɛ kpaa foola ma gye obube. ");
INSERT INTO utr_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","Inggisɛ nkyiikyɛ mi mmbwɛ yi eyi taman ka yɛɛ emi iJuda otsitsi ba. ");
INSERT INTO utr_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","Ei, inggisɛ emi iJuda otsitsi yɔ, li inggisɛ ngwu itukwu mgban le saan yi Imgbasho mani. Ikyɛ okyɛɛkyɛ otsitsi nɛ, di li osunu ola ngwi a lɔ mi afɛ ta ba; kpaa li itukwu okyata-kyata nkyɛ mi Onodzi mgbi Imgbasho nani. Inggisɛ nkyatitukwu na li mina gbɛɛ, ni inggisɛ tsɛ ongwu ba, kpaa ni Imgbasho tsɛ ongwu. ");
INSERT INTO utr_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","Ni inggisɛ li emi iJuda, o ngha angbeka mi ekyɛ? Naadi oyabɔ mgbi ikyɛ okyɛ-kyɛ li ɛkyɛ? ");
INSERT INTO utr_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","Dzɛ yi oyabɔ mi ali itɔ ofɛ duu! Ababɔ yɔ, li ama Imgbasho kye elodzɛ mgban wo ma abɔ. ");
INSERT INTO utr_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","Ni emi iJuda angbeka dzɛ yi oyɛyɛ onuunu ba ma? Oyɛyɛ mgbi ama onuunu ba na ka yagba ndɛ Imgbasho ombwo ondu odzɛɛdzɛ mgbaan? ");
INSERT INTO utr_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","Onoka ba du! Ki ali inggisɛ duu li gbatsika kpaa, Imgbasho li gbɔ otsitsi. Dafi Afɛ lɔ mani gbɛɛ: <<Ikye ni Abu gbɔdzɛ yɔ, ni a di gbɛɛ Abu gbɔ ayin, ni Abu di gbiikwɔ yɔ, ni Abu di ngha.>> ");
INSERT INTO utr_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","Nghaduu kini okpɛkpɛ mgbi eyi nu osaan mgbi Imgbasho nghao tsotɔ saan ma, eyi ka gbɔsinɛ? Eyi ka gbɛɛ Imgbasho kyɔ ayin ba okyitingga yi eyii? (N byita odzɛ ma dafi ikwangha inggisɛ mani.) ");
INSERT INTO utr_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","Li ngha ba du! Ki Imgbasho li gbiikwɔ mi otsitsi ba ma, O gbɔ ɛsɛ ikwɔ sinɛ? ");
INSERT INTO utr_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","Inggisɛ oka ka tangwɛ gbɛɛ, <<Kini atsika ngbɛn ogboogbo nu otsitsi mgbi Imgbasho bɛyi okwɔkwɔ mgban sheeshe waali, kyɔnɛ ngwi Imgbasho dika kwo ani adɔ?>> ");
INSERT INTO utr_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","Inggisɛ angbeka kye ondu le wo eyi ewo mi atsika di eyi gbɛɛ, <<Tatase okyɔ obube kpakpa!>> Ama nle gbɔ itɔ odzɛ ntonɛnɛ mɛ ngwi Imgbasho ka ngwɔ ma ikwɔ. ");
INSERT INTO utr_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","Nghanɛma eyi duu ka ngyɛlu sinɛ? Eyi emi iJuda tatase ngha ama nli emi iJuda ba ntonaa? Ba dududu! Eyi teyi kyi gbɔlu ngyɛ wa, gbɛɛ, emi iJuda yi ama nli emi iJuda ba kpaa li ofyɛɛ mgbi alobube ungwonyi. ");
INSERT INTO utr_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","Dafi a lɔ mi Afɛ mani gbɛɛ: <<Inggisɛ onyi osaan dzɛma ba, ei onyi kpaa ba; ");
INSERT INTO utr_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","inggisɛ onyi odzɛ yi ozoyeye kpaa dzɛma ba, inggisɛ onyi kpaa pita oye Imgbasho ba. ");
INSERT INTO utr_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","Ama duu kyata iyikpa, a yɛɛ ayayi duu; inggisɛ onyi kpaa kyɔ osuse ba, onyi kpaa ba. ");
INSERT INTO utr_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","Elodzɛ mgbi ama dzɛ dafi endzi ngbofo le nukwɔ mani; ikyidɛ mgbi ama li gbatsika. Unka mgbi ogidzi dɔdzɛ ikpondu mgbi ama. ");
INSERT INTO utr_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","Ikamba yi elodzɛ ama onunɔ mbwo ma ondu. ");
INSERT INTO utr_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","Afɔ mgbi ama dzɛ vla-vla o ka dzɛ eyi kyi esɛ; ");
INSERT INTO utr_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","idɔ mgbi ama li onu inggisɛ kaka isɔ ali imbe ngwi a kɛ duu, ");
INSERT INTO utr_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","a ye ofɛ odzɛ mi iyu ba. ");
INSERT INTO utr_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","A dzɛ yi imio mgbi Imgbasho ba du.>> ");
INSERT INTO utr_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","Onɛnɛ eyi ye gbɛɛ alungwɔ ngwi ola gbɔ yɔ, i gbɔ yi ama nwoto abɔ ola mani, ikye ni ali inggisɛ ka natsondu yi Imgbasho wuba. ");
INSERT INTO utr_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","Nghanɛ Imgbasho ka yama gbela yi inggisɛ gbɛɛ o le saan mi ikye ola ongyoongyo ba, lubana li ola li nu eyi difwi gbɛɛ eyi kyɔ obube. ");
INSERT INTO utr_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","Nghaduu dulu ola dzɛkɛ esɛ onɛnɛ kpaa, osaan nkyɛ mbi Imgbasho ma a nu eyi yen wa, ngwi ola bɛyi ama ogbɛɛsɛ mgbi Imgbasho kyɔ obwɛndɛ. ");
INSERT INTO utr_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","Osaan nkyɛ mbi Imgbasho nɛ ba ikpewo oyɛyɛ onuunu mbi iYesu iKrestu ikye ama nnoyɛyɛ duu. Idzidza dzɛma ba, ");
INSERT INTO utr_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","lubana inggisɛ duu kyɔ obube di dzitsi mi okwɔkwɔ mgbi Imgbasho, ");
INSERT INTO utr_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","kpaa Imgbasho nu eyi gye emyɛmyɛ ayayi mi elela mgban mi owatɔ-watɔ nba ikpewo iKrestu iYesu nani. ");
INSERT INTO utr_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","Imgbasho kyon nu dafi ifɛ ofɛɛfɛ, mi onoyɛyɛ mi eyi mgban. O kyungwɔnɛ ikye okye emyɛmyɛ mgban tso, ifɛ nɛ tso gbɛɛ, Imgbasho kyɔ osuse dafi o kwo ama nkyɔ obube mi onɔ ngwi nyɛ na adɔ ba mani, ");
INSERT INTO utr_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","o kyungwɔnɛ ikye otso gbɛɛ ongwu li inggisɛ ogbiikwɔ osuse mi onɔ ongwi onɛnɛ nɛni, ikye ni ongwu gye emyɛmyɛ di nu ama nnoyɛyɛ mbi iYesu gye emyɛmyɛ. ");
INSERT INTO utr_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","Nghanɛ abɔ otsigɛgɛ kɔ? A kye dzɛkɛ enggengga. Mi ali itɔ ofɛ? Li mi ola ongyoongyoo? Ei, kpaa li mi oyɛyɛ onuunu ngwi eyi ka gye emyɛmyɛ. ");
INSERT INTO utr_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","Lubana eyi kye abɔ byi gbɛɛ inggisɛ li gye emyɛmyɛ li mi ola ongyoongyo ba, kpaa li mi oyɛyɛ onuunu. ");
INSERT INTO utr_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","Imgbasho nɛ li Imgbasho mgbi emi iJuda yuomaa? O li Imgbasho mgbi Udzengye kpaa baa? Ɛɛn, li mgbi Udzengye kpaa, ");
INSERT INTO utr_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","Ngwi Imgbasho li onyi ta nɛ, li ongwu ka nu ama okyiikyɛ bɛyi ama okyiikyɛ ba duu emyɛmyɛ. ");
INSERT INTO utr_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","Nghanɛma, eyi ka kyi ngwɔlu ola dɔ ikye oyɛyɛ onuunu nɛɛ? Onoka ba du! I ka kɛkiyayi onu ola mmwɛ. ");
INSERT INTO utr_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","Ikyenghanɛ li ekyɛ ngwi eyi ka gbɛɛ otsikyeyi Abrahan difwi mi itɔdzɛ nɛ? ");
INSERT INTO utr_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","Ni Abrahan gye emyɛmyɛ ikye idɔ yɔ, o dzɛ yi ungwɔ otsabɔ igɛgɛ ele, kpaa li mbi Imgbasho ba. ");
INSERT INTO utr_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","Afɛ gbɔ dikyɛ? <<Abrahan nu Imgbasho oyɛyɛ, Imgbasho kyon gbɛɛ o li inggisɛ osaan.>> ");
INSERT INTO utr_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","Kini inggisɛ kyidɔ yɔ, awuya ngwi a li kpan na a li di gbɛɛ li umba ba, kpaa li ungwɔ nwogyɔ a ka kyɔ. ");
INSERT INTO utr_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","Nghaduukpaa, inggisɛ ama nli kyidɔ ba kpaa li nu Imgbasho ongwu nli nu emi imbaali kpaa gye emyɛmyɛ na oyɛyɛ yɔ, a li kye oyɛyɛ onuunu mgbi ama gbɛɛ di li osaan. ");
INSERT INTO utr_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","IDevedi kpaa gbɔ ngha onɔ ngwi o gbɔdzɛ inggisɛ nkyidɔ ba kpaa Imgbasho non gye emyɛmyɛ ma gbɛɛ mse dzɛ yan: ");
INSERT INTO utr_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","<<Mse dzɛ yi ama ngwu a dzamata yi obube, di tukwulu ma alobube mani. ");
INSERT INTO utr_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","Mse dzɛ yi inggisɛ ngwu Otsɛ ka kye alobube mgban wuuta ba mani.>> ");
INSERT INTO utr_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","Mse nɛ dzɛ ikye ama okyiikyɛ kyoon ta naa dzɛ ikye ama nkyiikyɛ ba kpaa? Eyi teyi li gbɛɛ oyɛyɛ onuunu mgbi Abrahan nu ma kwun di inggisɛ osaan. ");
INSERT INTO utr_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","Otsɛ-tsɛ na ba mi ali itɔ ofɛ? A tsan duuse non kyiikyɛ naadi o kyiikyɛ se? A tsan duuse o wa kyiikyɛ! ");
INSERT INTO utr_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","O di gbɛ ambɛ ikyɛ, ambɛ mgbi osaan ngwi o tu mi oyɛyɛ onuunu mi onɔ ngwi o kyiikyɛ waba mani. Ikyenghanɛ, o li otsɔ ama nkyiikyɛ waba kpaa noyɛyɛ duu, adzi ni a kwu ma di ama osaan. ");
INSERT INTO utr_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","O di li otsɔ ama nkyɛkyikyɛ ta ba kpaa le kyikyɛ mi oyɛyɛ onuunu ngwi Abrahan tun duuse wa kyiikyɛ nani. ");
INSERT INTO utr_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","Li mi abɔ ola ngwi Abrahan yi etɔ mgban tu ondu odzɛɛdzɛ gbɛɛ, o ka gyokwudɛ ɛsɛ ba, kpaa li mi osaan nkyɛ mi oyɛyɛ onuunu nani. ");
INSERT INTO utr_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","Lubana ni ama nle kyɛdɔ ola ntona yɛɛ ama gyokwudɛ yɔ, oyɛyɛ onuunu dzɛ yi oyabɔ wuba ondu odzɛɛdzɛ mgban kpaa yɛɛ ayayi. ");
INSERT INTO utr_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","Ikyekyɛ ola li ba yi itingga. Imbe ngwi ola dzɛ bayɔ ola ofaafa kpaa dzɛ ba. ");
INSERT INTO utr_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","Nghanɛ, ondu odzɛɛdzɛ li ba mi oyɛyɛ onuunu, adzi ni elela di dzɛ ikye etɔ mgbi Abrahan duu. Ondu odzɛɛdzɛ otsitsi nɛ dzɛ ikye ama nli mgbi ola kyoon ba, kpaa li mbi ama nsulu oyɛyɛ onuunu mgbi Abrahan nani. O li otseyi duu. ");
INSERT INTO utr_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","Dafi Afɛ tsekise lɔ ma gbɛɛ: <<Ani nu abu li otsɔ ɛsɛ ibyibyi.>> O li otseyi mi inɛ Imgbasho, ongwu o nun oyɛyɛ nani, Imgbasho nli kyile emi ikwukwɔ, di li kwu ungwɔ ama ndzɛma ba dafi a tsekise dzɛ nani. ");
INSERT INTO utr_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","Ngwi dzɛ dafi ɛwɛ ogbe byiibyi dzɛma ba nɛ kpaa, Abrahan gbɛwɛbyi noyɛyɛ. Nghanɛ o yɛɛ otsɔ ɛsɛ ibyibyi, yɛyɛ dafi Imgbasho teyi nyan mani gbɛɛ, <<Li ngha ngwi engwiba mgbi abu ka mbwo aali.>> ");
INSERT INTO utr_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","Ngwi Abrahan mɛ onova ideli onyi nɛ kpaa, oyɛyɛ onuunu mgban shanyɛ ba. O ye dafi ongwu dzɛ kwɛkwɛ okwulu, owan iSara kpaa kyɛ ka mbongwɛ wuba mani. ");
INSERT INTO utr_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","Nghaduu Abrahan tangwɛ ondu odzɛɛdzɛ mgbi Imgbasho ba, kpaa kɛɛkiyayi mi oyɛyɛ mgban onuunu di kye okwɔkwɔ nu Imgbasho, ");
INSERT INTO utr_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","ikyesinɛ o ye saan ta gbɛɛ Imgbasho dzɛ yi mfye okyungwɔ ngwi o zondu nani. ");
INSERT INTO utr_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","Li ikyengha <<ngwi a gbela yan gbɛɛ o le saan aali.>> ");
INSERT INTO utr_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","Elodzɛ ngwi a lɔ gbɛɛ <<a gbela yan na>> a lɔn li ikye mgban yuon ba, ");
INSERT INTO utr_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","kpaa li ikye eyi ama Imgbasho ka gbela gbɛɛ eyi le saan ikye gbɛɛ eyi noyɛyɛ mbi ongwu Imgbasho nkyile iYesu Otsɛ mgbi eyi mi ikwongye mani. ");
INSERT INTO utr_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","A kyon nu mi abɔ ikwongye mi ikye ali ibwubwe mgbi eyi di kyilon mi ikwongye ikye ni eyi gye emyɛmyɛ mi inɛ Imgbasho. ");
INSERT INTO utr_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","Nghawanɛ, dafi eyi gye emyɛmyɛ mi oyɛyɛ onuunu nɛ, eyi sulu iyu yi Imgbasho mgbi eyi ikpewo Otsɛ mgbi eyi iYesu iKrestu, ");
INSERT INTO utr_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","ongwu eyi tu ofɛ kaka elela ongwi eyi kwudzɛ ele onɛnɛ nɛ mi oyɛyɛ onuunu nɛni. Eyi di dzɛ yi atsa yi ɛwɛ ogbe byiibyi otu okwɔkwɔ mgbi Imgbasho nani. ");
INSERT INTO utr_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","Li ngha ta ba, kpaa eyi di tsatsa mi isɔ mgbi eyi, ikyekyɛ eyi ye ta gbɛɛ isɔ li ba yi itukwu oshiishi; ");
INSERT INTO utr_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","itukwu oshiishi li ba yi itukwu ofyumfye, itukwu ofyumfye li ba yi ɛwɛ ogbebyi. ");
INSERT INTO utr_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","Ɛwɛ ogbe byiibyi di li nu eyi ayiwi ba, ikyekyɛ Imgbasho kye okpitukwu mgban yawo eyi kɛ itukwu nyɛ mi Onodzi Osaan ngwi O kye nu eyi nani. ");
INSERT INTO utr_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","Ngwi onɔ wa gyɔ yɛyɛ nɛ, iKrestu kwulu ikye eyi mi onɔ ngwi eyi dzɛ yi mfye ba kale ngha Imgbasho adɔ mani. ");
INSERT INTO utr_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","I fyumfye ni inggisɛ kwulu ikye inggisɛ osaan, kpaa mi ikye inggisɛ osuse saan yɔ, kaba inggisɛ ka yagba kwulu. ");
INSERT INTO utr_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","Nghaduu Imgbasho kye okpitukwu mgban tso eyi mi itɔ ofɛ nɛni: Ngwi eyi ka li emi ali ibwubwe majo iKrestu kwulu ikye eyi. ");
INSERT INTO utr_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","Ngwi eyi gye emyɛmyɛ mi eyi mgban wa nɛ, a ka dulu eyi mi itingga mgbi Imgbasho ikpewon sinɛ ngha lo? ");
INSERT INTO utr_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","Lubana onɔ ngwi eyi ka li engyikyili mgbi Imgbasho ma, a yile eyi gyiide yan mi ikwu ongwan, ikyegbɛɛ a yile eyi gyiide nɛ, eyi ka wa watɔ ikpewo okyɛɛ-kyɛɛ mgban mi ikwu sinɛ ngha lo? ");
INSERT INTO utr_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","Ungwɔnɛ li ngha ta ba, kpaa eyi di tsatsa mbi Imgbasho ikpewo Otsɛ mgbi eyi iYesu iKrestu, mi oyile eyi gyiide yi Imgbasho. ");
INSERT INTO utr_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","Nghanɛ, dafi alobube kaka ɛsɛ ikpewo inggisɛ onyi, ikwongye di kaka ɛsɛ ikpewo alobube nɛ, inggisɛ duu tu ikwongye, ikyekyɛ ali inggisɛ duu kyɔ obube. ");
INSERT INTO utr_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","Lubana duuse ni a kye ola nu yɔ, alobube teyi dzɛ ɛsɛ nɛni. Kpaa a kye alobube wuuta ba ikyesinɛ ola dzɛma waba. ");
INSERT INTO utr_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","Ndzɛ nghanɛ kpaa, ikwongye wita kyɛ onɔ mgbi Adan nghataa ba onɔ mgbi iMose jo kaka mbi ama nfoola dafi Adan ndzɛ dafi iKrestu nka wa ba na ba mani. ");
INSERT INTO utr_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","Nghaduu umba ungwɔ ngwi iYesu kyɔ na dzɛ dafi adɔ onghaangha na ba. Lubana ki ibyi inggisɛ kwulu ikye adɔ onghaangha mgbi inggisɛ onyi yɔ, mbi inggisɛ onyi iYesu iKrestu na umba itukwu oleewo mgbi Imgbasho nkyɛ mbon ka gbɔfwɛ mbi ibyi inggisɛ! ");
INSERT INTO utr_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","Odi kiyayi yɔ, umba mgbi Imgbasho dzɛ dafi alobube ngwi Adan kyɔ na ba. Ikwɔ kyɛdɔ alobube onyi na di ba yi odzili-dzili, kpaa umba na yɔ kyɛdɔ adɔ onghaangha mgbi inggisɛ ibyibyi di nu ma gye emyɛmyɛ. ");
INSERT INTO utr_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","Lubana ki adɔ onghaangha mgbi inggisɛ onyi, nu ikwongye gyutɔ ikpewo inggisɛ onyi na waali, ka dzɛ sinɛ mbi ama ngbɛ elela mgbi Imgbasho dzii bɛyi umba mgbi osaan ngyutɔ mboma ikpewo inggisɛ onyi iYesu iKrestu na! ");
INSERT INTO utr_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","Nghawanɛ, dafi adɔ onghaangha onyi ba yi odzili-dzili mbi inggisɛ duu nɛ, li ngha ngwi ali osaan onyi ba yi emyɛmyɛ nka nu inggisɛ duu tu oshishe yɛyɛ aali. ");
INSERT INTO utr_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","Lubana dafi adɔ onghaangha mgbi inggisɛ onyi nu inggisɛ duu yɛɛ emi alobube nɛ, li ngha ngwi osiikyenu mgbi inggisɛ onyi ka nu inggisɛ ibyibyi yɛɛ saan kpaa aali. ");
INSERT INTO utr_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","A kye ola na ba ikye ni obube tsotɔ; kpaa ni obube tsotɔ yɔ, elela Imgbasho nghao tsotɔ duu. ");
INSERT INTO utr_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","Ikyenghanɛ, dafi alobube gbe inggisɛ duu teyi kaka ikwongye nɛ, li ngha ngwi elela mgbi Imgbasho nnu eyi osaan na gbe eyi teyi onɛnɛ, nu eyi tu oshishe gyegwu ikpewo iYesu iKrestu Otsɛ mgbi eyi aali. ");
INSERT INTO utr_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","I ka gbɔn sinɛ wadɛn? Ni eyi kɛɛkiyayi okyɔ alobube zukwu ni elela sheeshee? ");
INSERT INTO utr_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","Onoka lo! Ni eyi kwulu mi alobube waali; kyɔsinɛ se eyi di kale kyɔn kpɔɔ? ");
INSERT INTO utr_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","Naadi ema ye dafi eyi ama ngwu a kyɔ eyi iBatisima mbi iYesu iKrestu nɛ, a kyɔ eyi iBatisima kaka ikwongye mgban ma wɛ? ");
INSERT INTO utr_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","Nghanɛ a gbe eyi ndzi yan nyɛ mi iBatisima kaka ikwongye ikyegbɛɛ, dafi a kyile iKrestu mi ikwongye mi okwɔkwɔ mgbi Otsɔn nɛ, eyi kpaa kawa dzɛ mi oshishe ofufɛ. ");
INSERT INTO utr_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","Dafi a gbe eyi kwokyi yan mi ikwongye nghanɛ, li kyɛmɛ a dika gbe eyi kwokyi yan mi okyɛɛ-kyɛɛ mi ikwu. ");
INSERT INTO utr_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","Lubana eyi ye odzɛɛdzɛ mgbi eyi ogbugbe na a kye gbokwo yan ikye ongyɛlu yi ikpewo mgbi alobube nani, zukwu ni eyi ka li ofyɛɛ mgbi alobube wuba. ");
INSERT INTO utr_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","Inggisɛ nkwulu yi iKrestu ta wa yɔ, o watɔ mi alobube. ");
INSERT INTO utr_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","Onɛnɛ kini eyi kwulu yi iKrestu yɔ, eyi noyɛyɛ ta gbɛɛ i dika wa dzɛ oshishe yan. ");
INSERT INTO utr_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","Lubana eyi ye ta gbɛɛ ngwi a kyile iKrestu mi ikwu nɛ, o ka yama kwulu wuba; ikwongye sulu mfye onghan wuba. ");
INSERT INTO utr_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","Ikwu ngwi iYesu kwu na, o kwikwu akponyi ikye odzili alobube; kpaa oshishe ngwi o dzɛ na, o dzɛ ikye Imgbasho kyoon. ");
INSERT INTO utr_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","Mi itɔ ofɛ na kpɔɔ, kye ewema gbɛɛ ema kwulu ikye odzɛ mi alobube wuba, kpaa wɛ gbɛɛ iKrestu iYesu nu ema oshishe mbi Imgbasho. ");
INSERT INTO utr_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","Ikyenghanɛ ka nu alobube gyutɔ mi ikpewo mgbi abu nli kwulu nɛ ba, di abu wa sunu imina mgban ibwubwe. ");
INSERT INTO utr_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","Ka yama kye alewo mgbi ema nu ali ibwubwe no yɛɛ okye mgbi imbaali ba. Kye ewema nu Imgbasho, dafi ama ngwu a dulu ma tɔ mi ikwongye luba oshishe mani; di kye alewo mgbi ema nun dafi okyiidɔ mgbi osaan mani. ");
INSERT INTO utr_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","Nghawanɛ, ka nu alobube kye ema teyi ba, ikyekyɛ ema byidzɛ abɔ ola ba, kpaa abɔ elela. ");
INSERT INTO utr_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","Ungwɔ ntonɛ duu ma itan sinɛ? Eyi ka kiyayi okyɔ obube ikyegbɛɛ eyi woto abɔ ola ba kpaa woto abɔ elela nghaoo? Onoka ba du! ");
INSERT INTO utr_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","Ema ye dafi ema li ofyɛɛ mgbi inggisɛ ngwu ema le siikyenun ma wɛ? Ema ka yagba li ofyɛɛ mgbi alobube di kwulu, hona ofyɛɛ ama osiikyenu Imgbasho, nka nu ema dzɛ mi ofɛ mgbi osaan. ");
INSERT INTO utr_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","Nghaduu eyi ta Imgbasho angba gbɛɛ, nose ma ema li ofyɛɛ mgbi alobube kpaa onɛnɛ yɔ, ema yɛ kyɛdɔ itɔ otsootso ngwi a tso ema nɛ itukwu onyi. ");
INSERT INTO utr_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","A shɛ ema adi mi ifu alobube, ema yɛɛ ofyɛɛ mgbi osaan. ");
INSERT INTO utr_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","N le gbɔdzɛ nɛ mi odzɛɛdzɛ mgbi inggisɛ owamyɛ ikyekyɛ ema ndɛ mi odzɛɛdzɛ mgbi atta mgbi ema. Dafi ema li kye alewo mgbi ema yɛɛ ofyɛɛ nu idza ni ali ibwubwe mgbi ema le sheeshe wele ma, onɛnɛ kye alewo mgbi ema yɛɛ ofyɛɛ nu osaan nka kye ema kaka osaan kpaa mani. ");
INSERT INTO utr_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","Onɔ ngwi ema li ofyɛɛ mgbi alobube ma, ungwɔ kwu osaan akye yi ema ba. ");
INSERT INTO utr_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","Li ali oyabɔ ngwi ema tu mi onɔ na mi ungwɔ ama n yɛɛ ema ungwɔ ayiwi onɛnɛ nɛ? Bana ungwɔ ntona li ba yi ikwongye mi ongyɛɛngyɛ! ");
INSERT INTO utr_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","Nghaduu onɛnɛ ngwi a dulu ema tɔ mi abɔ alobube di yɛɛ ofyɛɛ mgbi Imgbasho nɛ, oyabɔ ngwi ema tu ma kye ema kaka osaan. Ongyɛɛngyɛ mgban di li oshishe ogyegwu. ");
INSERT INTO utr_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","Lubana mkpa alobube li ikwongye, kpaa umba mgbi Imgbasho li oshishe ogyegwu mbi iKrestu iYesu Otsɛ mgbi eyi. ");
INSERT INTO utr_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","Emi ongwunani, ema ama nbɛ mi ola ntonɛnɛ, ema ye dafi ola li kyidɔ mi ikpewo inggisɛ onɔ ngwi otsungwɔn dzɛ oshishe ma ta baa? ");
INSERT INTO utr_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","Dzɛ sini, ola tso gbɛɛ ongyaa dzɛ ikye oban onɔ ngwi o ka dzɛ oshishe mani. Nghaduu ni oban kwulu yɔ, o tɔ mi abɔ ola nani. ");
INSERT INTO utr_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","Nghawanɛ, ki non kyuka yi ongyulɔ oka ngwi oban ka dzɛ oshishe yɔ, o kyɔ amah. Kpaa ni oban wa kwulu yɔ, o tɔ mi abɔ ola nani. Non yɛ bongyulɔ oka jokpa, o yama li ongyaa amah wuba. ");
INSERT INTO utr_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","Nɛ, emi ongwunani, ema kpaa ola nwodzɛ mbi ema na kwulu ikpewo ikwu iKrestu, ikye ni ema li mgbi iKrestu ongwu a kyilon mi ikwu ikye ni eyi wa owaawa mbi Imgbasho nani. ");
INSERT INTO utr_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","Lubana ngwi odzɛɛdzɛ ibwubwe mgbi atta kye eyi teyi ma, imina obube ngwi ola kye ba ma le kyidɔ mbi eyi, man alungwɔ ngwi eyi kyɔ duu ngyɛ mi ikwongye. ");
INSERT INTO utr_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","Nghaduu onɛnɛ ngwi eyi kwulu mi ungwɔ nplɛ kwu eyi ofyɛɛ nɛ, eyi tɔ mi abɔ ola ikye ni eyi ki kyungwɔ mi odzɛɛdzɛ ofufɛ mgbi Onodzi, no ka li imbisɔ mgbi ola ogbugbe ngwi a lɔɔlɔ na ba. ");
INSERT INTO utr_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","I ka gbɔn sinɛ wa dɛn? Ola nɛ li ungwɔ obubee? Onɔ oka ba du! Mi otsitsi ki li ola bayɔ, n kika ye ungwɔ nli alobube ba du. N kika ye ungwɔ nli odi mbe angwɔ ba du, ni ola ki gbɛɛ, <<Ka yama di ungwɔ mbe angwɔ bayɔ.>> ");
INSERT INTO utr_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","Li ofɛ ngwi ola kye ba nani, ngwi alobube tu ofɛ okwokyile ali imina obube duu mbi ani aani. Kini ola dzɛma bayɔ, alobube dzɛ yi mfye wuba. ");
INSERT INTO utr_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","9","Duuse ni ani ye ola yɔ, ani dzɛ oshishe; kpaa ngwi ola wa ba nɛ, alobube fwi tɔ dzɛ oshishe man ani kwulu. ");
INSERT INTO utr_vpl VALUES ("RM7_10","075_7_10","ROM","7","10","10","N difwi gbɛɛ ola se ndzɛ yi oweka okye oshishe ba ma, yɛ kye-kye ikwongye ba. ");
INSERT INTO utr_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","Lubana alobube tu ofɛ ikpewo ola kpagya ani wo, di ngwɔ ani. ");
INSERT INTO utr_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","Nghawanɛ, ola le saan, ali ola le ayin di tishi. ");
INSERT INTO utr_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","Ungwɔ ntishi nɛ di yɛɛ ikwongye mbi anii? Onoka ba du! Ikyegbɛɛ nu ma difwi alobube gbɛɛ di li alobube yɔ, i kye ikwongye ba mbi ani ikpewo ungwɔ osuse, adzi ni alobube yɛɛ alobube yɛyɛ ikpewo ola mani. ");
INSERT INTO utr_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","Eyi ye ta gbɛɛ ola li ungwɔ ongwi onodzi, nghaduu ani dzɛ mi odzɛɛdzɛ mgbi ali ibwubwe mgbi atta, a kyen gya yi alobube dafi ofyɛɛ mani. ");
INSERT INTO utr_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","Ani yama ye ungwɔ ani le kyɔ ba. Lubana ungwɔ ngwi ani mina okyɔ ma n li kyɔn ba, kpaa ungwɔ nta ani anyi ma n li kyɔn. ");
INSERT INTO utr_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","Ni ani di kyungwɔ ngwi ani mina okyɔ ba ma kpaa, n di li gbela gbɛɛ ola tishi. ");
INSERT INTO utr_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","Ngwi i dzɛ nghanɛ yama li ani yuen le kyɔ ba kpaa, li alobube nwodzɛ mben mani. ");
INSERT INTO utr_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","18","N ye ta gbɛɛ mi atta mgbi ani ibwubwe nani, unkonyi osuse wodzɛ mbi ani ba. Bana n sulu imina okyungwɔ osuse kpaa, n li yagba kyɔn ba. ");
INSERT INTO utr_vpl VALUES ("RM7_19","075_7_19","ROM","7","19","19","Lubana ungwɔ osuse ngwi ani mina okyɔ ma n li kyɔ ba, li obube ngwi ani mina okyɔ ba ma, n li kiyayi okyɔ aali. ");
INSERT INTO utr_vpl VALUES ("RM7_20","075_7_20","ROM","7","20","20","Kini ani le kyungwɔ ngwi ani mina okyɔn bayɔ, yama li ani yuen le kyɔ wuba, kpaa li alobube nwodzɛ mbi ani ma le kyɔ aali. ");
INSERT INTO utr_vpl VALUES ("RM7_21","075_7_21","ROM","7","21","21","Nɛ n difwi gbɛɛ mfye oka le tsamu ani, onɔ ngwi i mina ani okyungwɔ osuse ma, ungwɔ obube li kye ani teyi. ");
INSERT INTO utr_vpl VALUES ("RM7_22","075_7_22","ROM","7","22","22","Lubana n gbela yi ola mgbi Imgbasho itukwu onyi; ");
INSERT INTO utr_vpl VALUES ("RM7_23","075_7_23","ROM","7","23","23","nghaduu n difwi mfye oka idzidza nle gblika yi itukwu mgbi ani, i di nu ani yɛɛ ofyɛɛ alobube nkye ani le teyi mi alungwɔ ngwi ani le kyɔ duu. ");
INSERT INTO utr_vpl VALUES ("RM7_24","075_7_24","ROM","7","24","24","Li ali itɔ ishisha inggisɛ ngwi ani dzɛ dɛn! Li emɛ ka nagbɛ ani mi abɔ atta mgbi ani nkye ani le lu ikwongye nɛ? ");
INSERT INTO utr_vpl VALUES ("RM7_25","075_7_25","ROM","7","25","25","N ta Imgbasho angba ikpewo iYesu iKrestu Otsɛ mgbi eyi! Nghawanɛ, ani abuen mi itukwu mgbɛn yɔ, n li ofyɛɛ mi ola mgbi Imgbasho, kpaa mi odzɛɛdzɛ mgbi mmbwɛ yi eyi yɔ, mfye oka le tsamu ani ni ani kyɔ alobube. ");
INSERT INTO utr_vpl VALUES ("RM8_1","075_8_1","ROM","8","1","1","Nghanɛ, onɛnɛ odzili-dzili yama dzɛ ikye ama ndzɛ mi ifu iKrestu iYesu ba, ");
INSERT INTO utr_vpl VALUES ("RM8_2","075_8_2","ROM","8","2","2","ikyekyɛ ikpewo iKrestu iYesu mfye mgbi Onodzi nu oshishe shɛn adi ta mi mfye mgbi alobube yi ikwongye. ");
INSERT INTO utr_vpl VALUES ("RM8_3","075_8_3","ROM","8","3","3","Lubana ungwɔ ngwi ola yagba kyɔ ba, ikyegbɛɛ odzɛɛdzɛ mgbi inggisɛ owamyɛ sulu mfye mmɛ ba ma, Imgbasho kyɔn. O kye ongwan dɛsɔ ba mi odzɛɛdzɛ mgbi inggisɛ owamyɛ, ikye owa kyi kyelu adɔ okwookwo mgbi alobube mi ikpewo mgban, ");
INSERT INTO utr_vpl VALUES ("RM8_4","075_8_4","ROM","8","4","4","adzi ni a di osaan ngwi a gbɛɛ ni eyi dzɛ mi ola ma mbi eyi ama nle kyɛdɔ odzɛɛdzɛ mgbi mmbwɛ yi eyi ba kpaa le kyɛdɔ odzɛɛdzɛ mgbi Onodzi nɛni. ");
INSERT INTO utr_vpl VALUES ("RM8_5","075_8_5","ROM","8","5","5","Ama ngwu mmbwɛ yi eyi kye ma le teyi yɔ, li gbe itukwu mgbi ama byi ungwɔ ngwi mmbwɛ yi eyi mina mani; kpaa ama Onodzi kye ma le teyi, li gbe itukwu ma byi ungwɔ ama Onodzi mina. ");
INSERT INTO utr_vpl VALUES ("RM8_6","075_8_6","ROM","8","6","6","Itukwu mgbi inggisɛ ngwi alobube kye le teyi yɔ li ikwongye, nghaduu itukwu ngwi Onodzi kye le teyi yɔ, li oshishe yi iyu. ");
INSERT INTO utr_vpl VALUES ("RM8_7","075_8_7","ROM","8","7","7","Kpaa itukwu alobube, li dzɛ mi ogblɔgblɔ yi Imgbasho. Li yama sunu ola mgbi Imgbasho ba, hona dika yagba kpaa ba. ");
INSERT INTO utr_vpl VALUES ("RM8_8","075_8_8","ROM","8","8","8","Ama ngwu mmbwɛ yi eyi kye ma le teyi yɔ, ka yagba kyungwɔ okpa Imgbasho ba. ");
INSERT INTO utr_vpl VALUES ("RM8_9","075_8_9","ROM","8","9","9","Ema ta yɔ, mmbwɛ yi eyi kye ema le teyi ba kpaa li Onodzi, kini Onodzi mgbi Imgbasho wodzɛ mbi ema yɔ. Ma ali inggisɛ ndzɛ yi Onodzi mgbi iKrestu ba wa, o li mgbi iKrestu luba. ");
INSERT INTO utr_vpl VALUES ("RM8_10","075_8_10","ROM","8","10","10","Nghaduu ni iKrestu dzɛ mbi abu yɔ, ewo mgbi abu kwulu ikye alobube, kpaa onodzi mgbi abu dzɛ oshishe ikye osaan. ");
INSERT INTO utr_vpl VALUES ("RM8_11","075_8_11","ROM","8","11","11","Ma ni Onodzi mgbi Ongwu nkyile iYesu mi ikwu na wodzɛ mbi abu yɔ, Ongwu nkyile iKrestu mi ikwu na dika nyɛ mi Onodzi mgban nwodzɛ mbi abu nɛ, dulu abu mi ikwongye luba oshishe. ");
INSERT INTO utr_vpl VALUES ("RM8_12","075_8_12","ROM","8","12","12","Nghanɛ, emi ongwunani, eyi li ofyɛɛ mgbi imina ongwi ɛsɛ nɛ ba, nɛ eyi sulu itɔdzɛ okyɛdɔ imina ongwi ɛsɛ wuba. ");
INSERT INTO utr_vpl VALUES ("RM8_13","075_8_13","ROM","8","13","13","Lubana ni abu dzɛ mgbi mmbwɛ yi eyi yɔ, o ka kwulu; kpaa ni abu dzɛ mi Onodzi, kyi kyelu imina obube mgbi ewo ngwuta yɔ, o ka dzɛ oshishe. ");
INSERT INTO utr_vpl VALUES ("RM8_14","075_8_14","ROM","8","14","14","Ama ngwu Onodzi mgbi Imgbasho kye ma le teyi yɔ, a li emi ongwɛ Imgbasho. ");
INSERT INTO utr_vpl VALUES ("RM8_15","075_8_15","ROM","8","15","15","Ikyesinɛ ema gbɛ onodzi nnu ema yɛɛ ofyɛɛ nka mio wuba, kpaa ema gbɛ Onodzi nnu ema yɛɛ engwɛ Imgbasho mani. Ma mi ikpewo Onodzi nɛ eyi kwun gbɛɛ, <<Baba, Otseyi.>> ");
INSERT INTO utr_vpl VALUES ("RM8_16","075_8_16","ROM","8","16","16","Onodzi na abɔn kyɔ obwɛndɛ yi onodzi mgbi eyi gbɛɛ eyi li emi ongwɛ Imgbasho. ");
INSERT INTO utr_vpl VALUES ("RM8_17","075_8_17","ROM","8","17","17","Ma ngwi eyi li engwɛ nɛ, eyi li ama gyokwudɛ mgban. Eyi li ama gyokwudɛ Imgbasho ungwonyi yi iKrestu. Eyi ka gyadzɛ yi iKrestu, ma ni eyi gyadzɛ yi iKrestu yɔ, eyi dika kaka okwɔkwɔ mgban yan. ");
INSERT INTO utr_vpl VALUES ("RM8_18","075_8_18","ROM","8","18","18","Ani noyɛyɛ gbɛɛ adzɛ ngwi eyi le gye onɛnɛ nɛ yama mɛ mi okwɔkwɔ ngwi a kawa kye tso eyi ma ba. ");
INSERT INTO utr_vpl VALUES ("RM8_19","075_8_19","ROM","8","19","19","Ɛsɛ duu le tsoolo ni ama wa di dafi Imgbasho ka kye emi ongwan tso mani. ");
INSERT INTO utr_vpl VALUES ("RM8_20","075_8_20","ROM","8","20","20","Lubana a nu ɛsɛ duu ndɛngyɛ, yama li itukwu ɛsɛ ba, kpaa li itukwu Imgbasho non dzɛkɛ ngha, yi ɛwɛ ogbe byi ");
INSERT INTO utr_vpl VALUES ("RM8_21","075_8_21","ROM","8","21","21","gbɛɛ ɛsɛ abuon ka watɔ mi adi mgbi ungwɔ ombeembe ngwi a bwan na luba ewo oshɛta okwɔkwɔ mgbi emi ongwɛ Imgbasho. ");
INSERT INTO utr_vpl VALUES ("RM8_22","075_8_22","ROM","8","22","22","Lubana eyi ye dafi ɛsɛ duu le maandu dafi imba ongwɛ mani, nghataa ba onɔ dzikan nɛni. ");
INSERT INTO utr_vpl VALUES ("RM8_23","075_8_23","ROM","8","23","23","Yama li ɛsɛ yuon ta ba, eyi abueyi ama nka wa tu owawa ongwi ababɔ mgbi Onodzi ma jokpaa, le maandu mi itukwu le fɛ onɔ ngwi a ka gbɛ eyi dafi engwɛ, bɛkɛ yi ikpewo ofufɛ ngwi a zondu okye nu eyi mani. ");
INSERT INTO utr_vpl VALUES ("RM8_24","075_8_24","ROM","8","24","24","Ikyesinɛ li mi ɛwɛ ogbe byiibyi nɛ ngwi eyi watɔ aani. Kpaa ɛwɛ ogbe byiibyi ongwi a di yɔ, yama li ɛwɛ ogbe byiibyi luba du. Li emɛ li kye ɛwɛ byi ungwɔ ngwi ongwu teyi dzɛyan? ");
INSERT INTO utr_vpl VALUES ("RM8_25","075_8_25","ROM","8","25","25","Kpaa ni eyi gbɛwɛbyi ungwɔ ngwi eyi plɛ dzɛyan wa bayɔ, i ka shitukwu fɛ. ");
INSERT INTO utr_vpl VALUES ("RM8_26","075_8_26","ROM","8","26","26","Mi itɔ ofɛ na kpɔɔ, Onodzi li tobyi eyi onɔ ngwi eyi dzɛ ewo atsi mani. Eyi ye ungwɔ ngbuo ngwi eyi ka bibɔ ikyen ba, kpaa Onodzi li bɔ ikye eyi yi andu omaama ngwi a ka gbɔn gbɛ ba mani. ");
INSERT INTO utr_vpl VALUES ("RM8_27","075_8_27","ROM","8","27","27","Imgbasho nli kyidi itukwu mgbi eyi ma ye oweka mgbi Onodzi, ikyekyɛ Onodzi li bɔ ikye emi osaan dafi owitukwu mgbi Imgbasho dzɛ mani. ");
INSERT INTO utr_vpl VALUES ("RM8_28","075_8_28","ROM","8","28","28","Eyi di ye gbɛɛ alungwɔ nba mbi eyi duu li Imgbasho nu ofɛ gbɛɛ no tɔ lo ama ongwu kpa ma itukwu ma tishi, ama ngwu a kwu ma ela mi itɔdzɛ mgbi ongwu mani. ");
INSERT INTO utr_vpl VALUES ("RM8_29","075_8_29","ROM","8","29","29","Lubana ama Imgbasho teyi ye ma ma, o kye ma dzɛkɛ dafi emi Ongwan, adzi nu ma yɛɛ yɛyɛ dafi Ongwɛ nli Ongwovlɛ mgbi emi ongwunɔn duu. ");
INSERT INTO utr_vpl VALUES ("RM8_30","075_8_30","ROM","8","30","30","Ama ngwu o di plɛ kye ma dzɛ ma, o kwu ma ela; ama ngwu o kwu ma ela ma, o di nu ma gye emyɛmyɛ; ama ngwu o di nu ma gye emyɛmyɛ ma, o di kye okwɔkwɔ mgban nu ma. ");
INSERT INTO utr_vpl VALUES ("RM8_31","075_8_31","ROM","8","31","31","Li ali uka tsatso ngwi eyi ka nu ikye ungwɔ ntonɛ? Ni Imgbasho dzɛ yi eyi ma li emɛni ka fyinyɛnɛ yi eyi? ");
INSERT INTO utr_vpl VALUES ("RM8_32","075_8_32","ROM","8","32","32","Ongwu nkye abɔ tukwu ongwan ba, kpaa kyon nu mi ikye eyi duu na, ka kyɔsinɛse o ka di eyi elela kye alungwɔ duu nu eyi ba. ");
INSERT INTO utr_vpl VALUES ("RM8_33","075_8_33","ROM","8","33","33","Li emɛ ka gbe odzɛ tukwu ama Imgbasho sadu ma nɛ ewo? Li Imgbasho li nu inggisɛ gye emyɛmyɛ. ");
INSERT INTO utr_vpl VALUES ("RM8_34","075_8_34","ROM","8","34","34","Li ongwu emɛ ka ngwɔ eyi ikwɔ dɔ? Inggisɛ dzɛma ba, lubana iKrestu iYesu kwulu mi ikye eyi a di kyilon luba oshishe ikye eyi, o di sɔdzɛ imbe mmwɛ mi abugye mgbi Imgbasho le tɛkyɛ ikye eyi. ");
INSERT INTO utr_vpl VALUES ("RM8_35","075_8_35","ROM","8","35","35","Li emɛ ka gha eyi yi okpitukwu mgbi iKrestu? Li okakewo naadi adzɛ naadi isɔ hona enbwa hona ibiba naadi inoola naadi okwusunkli? ");
INSERT INTO utr_vpl VALUES ("RM8_36","075_8_36","ROM","8","36","36","Dafi Afɛ lɔ ma gbɛɛ, <<Mi ikye abu Imgbasho, eyi li tsigɛgɛ yi ikwongye alonɔ duu; A di eyi dafi mmala ngwi a le ka kye eba gbon onbukwɔ mani.>> ");
INSERT INTO utr_vpl VALUES ("RM8_37","075_8_37","ROM","8","37","37","Mi ungwɔnɛ duu kpaa eyi shewo ngha ama onghaangha ikpewo iKrestu ndi eyi kpan itukwu nani. ");
INSERT INTO utr_vpl VALUES ("RM8_38","075_8_38","ROM","8","38","38","Lubana n ye saan gbɛɛ ikwongye hona oshishe, naadi engyesɔ hona onodzi ibwubwe, hona onɔ ongwi onɛnɛ naadi onɔ ongwi iyayi, hona ali itɔ mfye duu, ");
INSERT INTO utr_vpl VALUES ("RM8_39","075_8_39","ROM","8","39","39","naadi mfye ongwi esho hona mfye ongwi ikpɛsɛ, hona ungwɔ ngwi a ta duu, ka yagba ghalu eyi yi okpitukwu mgbi Imgbasho ndzɛ mi idzidzɛ eyi yi iKrestu iYesu Otsɛ mgbi eyi nɛ ba. ");
INSERT INTO utr_vpl VALUES ("RM9_1","075_9_1","ROM","9","1","1","N le gbɔ otsitsi mbi iKrestu, n le mwonya ba, itukwu mgbɛn kpaa nin obube ba, Onodzi Osaan li obwɛndɛ mgbɛn, ");
INSERT INTO utr_vpl VALUES ("RM9_2","075_9_2","ROM","9","2","2","Eka kwowina len kpakpa itukwu di wulin jo dondu ba. ");
INSERT INTO utr_vpl VALUES ("RM9_3","075_9_3","ROM","9","3","3","Bana n mina gbɛɛ ani abuen a ki wo ani ikamba di dzabɔ yi iKrestu mi ikye emi ongwunani, emi Israi ama nli etɔ yi ani nɛni. ");
INSERT INTO utr_vpl VALUES ("RM9_4","075_9_4","ROM","9","4","4","A li emidi Imgbasho ngwu Imgbasho kyelu ma nu ma yɛɛ etɔ mgban. Imgbasho tso ma okwɔkwɔ mgban. O bwondu yi ama di kye ola mgban nu ma. Ozu osunu Imgbasho mi iJerosalin na bɛyi ondu Imgbasho dzɛ duu li mgbi ama. ");
INSERT INTO utr_vpl VALUES ("RM9_5","075_9_5","ROM","9","5","5","Li ama li inyabyi, di li mboma ngwi iKrestu tɔ etɔ mi ɛsɛ nɛni, ongwu nli Imgbasho onghaangha nɛni. Nu ma tsan gyegwu! No dzɛ ngha. ");
INSERT INTO utr_vpl VALUES ("RM9_6","075_9_6","ROM","9","6","6","No ka dzɛ dafi elodzimgbasho wɛɛsɛ ba. Lubana li ama ntɔ etɔ mi Israi duu li emi Israi yɛyɛ ba. ");
INSERT INTO utr_vpl VALUES ("RM9_7","075_9_7","ROM","9","7","7","Dafi etɔ mgbi Abrahan tsatsa li emi ongwiba mgbi Abrahan ba nɛni. Imgbasho nya Abrahan gbɛɛ, <<Li ikpewo Adziki ngwi abu ka tu etɔ ngwi Ani zondu yi abu nani.>> ");
INSERT INTO utr_vpl VALUES ("RM9_8","075_9_8","ROM","9","8","8","Ungwɔnɛ tso gbɛɛ, li engwɛ ama Abrahan mba abɔn li emi ongwɛ Imgbasho kyɛmɛ-kyɛmɛ ba, kpaa li engwɛ ama Abrahan mba mi ondu odzɛɛdzɛ ma ngwu a kye ma wuuta gbɛɛ engwiba mgbi Abrahan aali. ");
INSERT INTO utr_vpl VALUES ("RM9_9","075_9_9","ROM","9","9","9","Lubana li ela mgbi ondu odzɛɛdzɛ ma aani: <<Onova nkyɛ nɛ mi itɔ onɔ nɛ yɛyɛ n ka yidɔ, iSara ka byi ongwɛ abɔ.>> ");
INSERT INTO utr_vpl VALUES ("RM9_10","075_9_10","ROM","9","10","10","Li nana ta ba, ongwefa mgbi iRebeka ntona a sulu otsɔma onyi, otsikyeyi Adziki. ");
INSERT INTO utr_vpl VALUES ("RM9_11","075_9_11","ROM","9","11","11","Nghaduu, duuse ni a mba engwefa ntona, naadi nu ma wa kyɔ obube hona osuse yɔ, Imgbasho nya iRebeka gbɛɛ ongwan ongwu okwukwo na kale kyɔ ongwu ongbungbɛ idɔ. Imgbasho gbɔdzɛ nɛ ikye otso gbɛɛ ongwu dulu ongwi itukwu ongwu wa, ma yama li ikye unkoka ngwi a kyɔ ba, ");
INSERT INTO utr_vpl VALUES ("RM9_12","075_9_12","ROM","9","12","12","li mi idɔ okyɔɔkyɔ ba, kpaa li mbi Imgbasho ongwu nkwu ela mani, a nyan gbɛɛ, <<Okwukwo na kale kyɔ ongwu ongbungbɛ idɔ.>> ");
INSERT INTO utr_vpl VALUES ("RM9_13","075_9_13","ROM","9","13","13","Yɛyɛ dafi Afɛ lɔ mani gbɛɛ, <<iJeko kpɛn itukwu, kpaa Isol tɛn anyi.>> ");
INSERT INTO utr_vpl VALUES ("RM9_14","075_9_14","ROM","9","14","14","Nghanɛ i ka gbɔn sinɛ tso? Imgbasho kyɔ ebɛbɛ? Ngha ba dududu! ");
INSERT INTO utr_vpl VALUES ("RM9_15","075_9_15","ROM","9","15","15","Lubana o gbɔ nya iMose gbɛɛ, <<Inggisɛ ngwu ani mina n ka dun elela, inggisɛ ngwu ani di mina n ka kyɔ elela won.>> ");
INSERT INTO utr_vpl VALUES ("RM9_16","075_9_16","ROM","9","16","16","Nghanɛ, ungwɔ ndzɛ mbisɔ gbɛɛ ka dzɛ yɔ, li imina hona ofyaafya mgbi inggisɛ ba, kpaa li elela odiidi mgbi Imgbasho. ");
INSERT INTO utr_vpl VALUES ("RM9_17","075_9_17","ROM","9","17","17","Li ngha ma ngwi Imgbasho gbɔ nya iFaro mi Afɛ gbɛɛ, <<Li mi itɔdzɛ nɛ yɛyɛ ngwi ani kyile abu desho, gbɛɛ nin tso mfye mgbɛn mboo, adzi ni a gbɔdzɛn kpatsɛ ɛsɛ duu.>> ");
INSERT INTO utr_vpl VALUES ("RM9_18","075_9_18","ROM","9","18","18","Nghanɛ Imgbasho sulu elela odiidi mbi inggisɛ ngwu i kpan odin elela mani, o di li kye ali inggisɛ ngwu i kpan duu itukwu tiishu. ");
INSERT INTO utr_vpl VALUES ("RM9_19","075_9_19","ROM","9","19","19","Inggisɛ oka mbi ema ka byi ani gbɛɛ: <<Nɛ kyɔnɛ ngwi Imgbasho di li nu eyi obube? Lubana li emɛ ka kyi ndɛlu owitukwu mgbi Imgbasho?>> ");
INSERT INTO utr_vpl VALUES ("RM9_20","075_9_20","ROM","9","20","20","Ei, ka gbɔ ngha ba. Abu li emɛ, inggisɛ owamyɛ hini, ka tangwɛ yi Imgbasho? Ungwɔ ngwi a ta-ta ka yagba nya Ongwu ntan ma gbɛɛ, <<Kyɔnɛ abu ta ani dzɛ ngha gbɛɛ?>> ");
INSERT INTO utr_vpl VALUES ("RM9_21","075_9_21","ROM","9","21","21","Ongye ombɛ ishe sulu ofɛ okye akwiibɛ onyi ma mbɛ ishe ama a ka kyungwɔ ingblimɔ di mbɛ angbeka ngwi a ka kyungwɔ imɔ mi ele ba gbɛ lo? ");
INSERT INTO utr_vpl VALUES ("RM9_22","075_9_22","ROM","9","22","22","Kabana Imgbasho mina otso itingga yi mfye mgban mbi ali inggisɛ ngwu o mina odzilin duu, nghaduu o shitukwu yi ama. ");
INSERT INTO utr_vpl VALUES ("RM9_23","075_9_23","ROM","9","23","23","Kaba o kyungwɔnɛ ikye otso okwɔkwɔ mgbi ongwu mi onɔ ngwi ongwu dzɛ yi elela odiidi mbi ama ongwu kyi mɛlu ma tokɛ gbɛɛ ni a tu okwɔkwɔ mgbi ongwu mani. ");
INSERT INTO utr_vpl VALUES ("RM9_24","075_9_24","ROM","9","24","24","Eyi kpaa wodzɛ mbi ama ngwu o sadu mani, li emi iJuda ta ba, Udzengye kpaa. ");
INSERT INTO utr_vpl VALUES ("RM9_25","075_9_25","ROM","9","25","25","Dafi Otsɛ gbɔ yɛyɛ mi afɛ mgbi iHosia mani gbɛɛ: <<A yama li <inggisɛ mgbɛn> ba kpaa n ka kwu ma gbɛɛ, <Emidɛn>; n ka tso okpitukwu mbi inggisɛ ama ngwu a tso okpitukwu yi ama ye ba mani. ");
INSERT INTO utr_vpl VALUES ("RM9_26","075_9_26","ROM","9","26","26","O diyɛ gbɛɛ, <<Imbe ngwi a plɛ nya ma gbɛɛ, <Ema li emidani ba na,> li mi ele yɛyɛ ngwi a dika kwu ma gbɛɛ, <Emi ongwɛ Imgbasho oshishe.> >> ");
INSERT INTO utr_vpl VALUES ("RM9_27","075_9_27","ROM","9","27","27","Ongye ogbɛɛsɛ Adzaya gbobakwɔ ikye emi Israi gbɛɛ: <<Dafi mmbwo mgbi emi Israi dzɛ dafi mfyan mi onekyoo nɛ kpaa, li gwee ni ta ka watɔ. ");
INSERT INTO utr_vpl VALUES ("RM9_28","075_9_28","ROM","9","28","28","Lubana Otsɛ ka kwo ɛsɛ adɔ plɛ, ma dika li dafi o gbɔgbɛɛ ongwu ka kyɔ ma yɛyɛ.>> ");
INSERT INTO utr_vpl VALUES ("RM9_29","075_9_29","ROM","9","29","29","Dzɛ yɛyɛ dafi Adzaya tsekise gbɔ mani gbɛɛ: <<Ni Otsɛ Ongha yi mfye ki dzata etɔ mgbi eyi angbeka oshishe bayɔ, eyi kika dzili dafi iSodon yi iGomora mani.>> ");
INSERT INTO utr_vpl VALUES ("RM9_30","075_9_30","ROM","9","30","30","Ni i gbɔn sinɛ tsatso? Udzengye ama ngbli mi odzɛ osaan ba kpaa, tun mi oyɛyɛ onuunu. ");
INSERT INTO utr_vpl VALUES ("RM9_31","075_9_31","ROM","9","31","31","Kpaa emi Israi ama ngbli gbɛɛ ama ki dzɛ osaan yi Imgbasho ma kpaa tun ba. ");
INSERT INTO utr_vpl VALUES ("RM9_32","075_9_32","ROM","9","32","32","Kyɔnɛ ngwi a tu ba? Ikyekyɛ a pita li mi oyɛyɛ onuunu ba, kpaa a pita dafi li mi idɔ mgbi ama okyɔɔkyɔ mani. Ali nɛ yɛɛ iKrestu ngwi inggisɛ le tsiishi mi ele. ");
INSERT INTO utr_vpl VALUES ("RM9_33","075_9_33","ROM","9","33","33","Dafi a lɔ mani gbɛɛ, <<Dika, n kye iKrestu la emi iDzayɔn nu ma le tsiishi bɛyi ikwutsɛ nnu ma le gbɛsɛ mani, nghaduu inggisɛ nnun oyɛyɛ yɔ, ka gyayiwi ba.>> ");
INSERT INTO utr_vpl VALUES ("RM10_1","075_10_1","ROM","10","1","1","Emi ongwunani, oweka yi ibɔ mgbi ani mbi Imgbasho ikye emi Israi yɔ, li ogbɛɛ a ki watɔ. ");
INSERT INTO utr_vpl VALUES ("RM10_2","075_10_2","ROM","10","2","2","Lubana n ka kyɔ obwɛndɛ ikye ma gbɛɛ Imgbasho gbɛ ma itukwu sɔ, kpaa a difwi ofɛ ngwi a ka kyɛdɔ Imgbasho ba. ");
INSERT INTO utr_vpl VALUES ("RM10_3","075_10_3","ROM","10","3","3","Dafi a yama ye osaan nkyɛ mbi Imgbasho na ba le di gbɛɛ ama ki kyɔ osaan mgbi ikyibɔ ma nɛ, a gbela nu osaan mgbi Imgbasho kye ma teyi ba. ");
INSERT INTO utr_vpl VALUES ("RM10_4","075_10_4","ROM","10","4","4","Lubana iKrestu ngyɛlu yi ola, ikye ni ama nnun oyɛyɛ duu, yɛɛ saan yi Imgbasho. ");
INSERT INTO utr_vpl VALUES ("RM10_5","075_10_5","ROM","10","5","5","IMose nu osa mi osaan ngwi a li tu mi ola mani o gbɛɛ, <<Inggisɛ nkyungwɔ ama ola gbɔ yɔ, ka dzɛ oshishe.>> ");
INSERT INTO utr_vpl VALUES ("RM10_6","075_10_6","ROM","10","6","6","Nghaduu osaan ndzɛ mi oyɛyɛ onuunu ma gbɛɛ, <<Ka yama gbɔ mi itukwu mgbi abu gbɛɛ, <Li emɛ ka kɛ esho?> >> (ka kye iKrestu ba esɛ) ");
INSERT INTO utr_vpl VALUES ("RM10_7","075_10_7","ROM","10","7","7","<<naadi, <Li emɛ ka lu esɛ kpini?> >> (gbɛɛ no kyile iKrestu mbi emi ikwukwɔ). ");
INSERT INTO utr_vpl VALUES ("RM10_8","075_10_8","ROM","10","8","8","Imbe odzɛ nɛ kyinɛbyi ma li ongwu aani: <<Esɔ mgbi Imgbasho dzɛ kwɛkwɛ yi abu, dzɛ ikpondu mgbi abu bɛyi itukwu mgbɔɔ,>> ali ma, li esɔ mgbi oyɛyɛ onuunu ngwi eyi le gbɔ nɛni. ");
INSERT INTO utr_vpl VALUES ("RM10_9","075_10_9","ROM","10","9","9","Kini abu gbɔ mi ondu mgbi abu gbɛɛ, <<IYesu li Otsɛ,>> di noyɛyɛ mi itukwu mgbi abu gbɛɛ Imgbasho kyilen mbi emi ikwukwɔ yɔ, o ka watɔ. ");
INSERT INTO utr_vpl VALUES ("RM10_10","075_10_10","ROM","10","10","10","Lubana li mi oyɛyɛ onuunu mgbi ema mi itukwu ngwi ema gye emyɛmyɛ, di li obwɛndɛ ngwi ema kyɔ mi ondu mgbi ema ma, ngwi a dulu ema watɔ aali. ");
INSERT INTO utr_vpl VALUES ("RM10_11","075_10_11","ROM","10","11","11","Dafi Afɛ gbɔ mani gbɛɛ, <<Ali inggisɛ nnun oyɛyɛ duu, ka gyayiwi ba.>> ");
INSERT INTO utr_vpl VALUES ("RM10_12","075_10_12","ROM","10","12","12","Lubana idzidza dzɛ mbi emi iJuda yi Udzengye ba, Otsɛ onyi ma li mgbi ama duu di li kye mse bɛ ama nkwu mi iyi mgban duu ewo kpakpa, ");
INSERT INTO utr_vpl VALUES ("RM10_13","075_10_13","ROM","10","13","13","ikyesinɛ, <<Ali inggisɛ nkwu mi iyi mgbi Otsɛ duu ka watɔ.>> ");
INSERT INTO utr_vpl VALUES ("RM10_14","075_10_14","ROM","10","14","14","Nghanɛ, ka kyɔnɛ, ngwi a ka kwu mi iyi mgbi ongwu a nun oyɛyɛ ba? Dika kyɔnɛ ngwi a ka noyɛyɛ mbi ongwu a fwo odzan ba? A dika kyɔsinɛse fwo ni inggisɛ gbɔ nya ma ba? ");
INSERT INTO utr_vpl VALUES ("RM10_15","075_10_15","ROM","10","15","15","Ni a dɔ ma esɔ ba ma a ka kyɔnɛse gbɔ? Dafi Afɛ gbɔ mani gbɛɛ, <<Ama nle wa gbɔ Esɔ Osuse ma obaaba mgbi ama sunse saan!>> ");
INSERT INTO utr_vpl VALUES ("RM10_16","075_10_16","ROM","10","16","16","Kpaa li emi Israi duu gbela Esɔ Osuse nɛ ba. Lubana Adzaya gbɛɛ, <<Otsɛ, li emɛ nu esɔ mgbi eyi oyɛyɛ?>> ");
INSERT INTO utr_vpl VALUES ("RM10_17","075_10_17","ROM","10","17","17","Ongwikpa yɔ, oyɛyɛ onuunu kyɛ mi ofwoofwo, ofwo esɔ ogbɔɔgbɔ mgbi elodzɛ iKrestu. ");
INSERT INTO utr_vpl VALUES ("RM10_18","075_10_18","ROM","10","18","18","Nghaduu n le byita gbɛɛ, a yama fwo ba naadi? Mi otsitsi yɔ a fwo, <<Ela mgbi ama gbɔfwɛ kaka ɛsɛ duu, elodzɛ mgbi ama kpatsɛ imbe ɛsɛ dondu duu.>> ");
INSERT INTO utr_vpl VALUES ("RM10_19","075_10_19","ROM","10","19","19","N dile byita gbɛɛ, Israi yama tu osa ba naadi? Ababɔ yɔ, iMose gbɛɛ, <<N ka nu ema di ɛsɛ nli unkonyi ba ma kyofu; n ka nu ɛsɛ ndifwi unkonyi ba ma kyɔ ema itingga.>> ");
INSERT INTO utr_vpl VALUES ("RM10_20","075_10_20","ROM","10","20","20","Adzaya di gbɔ yi imio ba gbɛɛ, <<Inggisɛ ama npita ani ba ma li ama di di ani aali; N kye ewen tso mbi ama nle byita ani kpaa ba mani.>> ");
INSERT INTO utr_vpl VALUES ("RM10_21","075_10_21","ROM","10","21","21","Nghaduu mi odzɛ mgbi Israi yɔ Imgbasho gbɛɛ, <<I kye egbe olɔlɔ ngwi ani na abɔ kɛ mbi ama onghaadɔ bɛyi ama nfwa onoyɛyɛ ntonani.>> ");
INSERT INTO utr_vpl VALUES ("RM11_1","075_11_1","ROM","11","1","1","Nghanɛ n le byita gbɛɛ, Imgbasho fwa emidan naadi? Onoka ba du! Ani li inggisɛ Israi abuen, ongwiba mgbi Abrahan, mi agwɔ mgbi iBenjamin nani. ");
INSERT INTO utr_vpl VALUES ("RM11_2","075_11_2","ROM","11","2","2","Imgbasho yama fwa emidan ama o teyi ye ma na ba. Ema ye odzɛ ngwi Afɛ gbɔ ikye Elaija dafi o fyewo yi Imgbasho ikye emi Israi ma lo: ");
INSERT INTO utr_vpl VALUES ("RM11_3","075_11_3","ROM","11","3","3","<<Otsɛ, a kyi ngwɔlu ama ogbɛɛsɛ mgbi abu di kyi gbobulu abu iwashi ntonani; li ani onyi ta sisi, a dile fya ongwɔ ani>>? ");
INSERT INTO utr_vpl VALUES ("RM11_4","075_11_4","ROM","11","4","4","Ma Imgbasho nose nun uka sinɛ? <<Ani nu inggisɛ idubu egyafa sisi ama nfwa okwakwafɔ nu iBaa.>> ");
INSERT INTO utr_vpl VALUES ("RM11_5","075_11_5","ROM","11","5","5","Onɛnɛ kpaa inggisɛ sisi to ma ama Imgbasho sadu ma mi elela. ");
INSERT INTO utr_vpl VALUES ("RM11_6","075_11_6","ROM","11","6","6","Ki li mi elela yɔ, yama li idɔ okyɔɔkyɔ wuba. Ni li otsitsi yɔ, elela ka li elela wuba. ");
INSERT INTO utr_vpl VALUES ("RM11_7","075_11_7","ROM","11","7","7","Ungwɔnɛ tso gbɛɛ osaan ngwi emi Israi le gbili mi itukwu mgbi ama onyi ma kpaa a tu ba, li ama a sadu ma gwee ma ta tu. Kpaa ama nsisi duu gbadikye, ");
INSERT INTO utr_vpl VALUES ("RM11_8","075_11_8","ROM","11","8","8","dafi Afɛ lɔ mani gbɛɛ, <<Imgbasho nu ma itukwu yɛɛ mbuumbu, a sulu inɛ kpaa a li di ba, a sulu adɔ kpaa a li fwo ba, nghataa ba inɛ.>> ");
INSERT INTO utr_vpl VALUES ("RM11_9","075_11_9","ROM","11","9","9","IDevedi di gbɛɛ, <<Ni oga mgbi ama yɛɛ mmbwalii yi ukya, nka nu ma esɛ ogboogbo ngwi li adɔ okwookwo ngyɔ yi ama mani. ");
INSERT INTO utr_vpl VALUES ("RM11_10","075_11_10","ROM","11","10","10","Inɛ no bulu lo ma mi ikye zukwu nu ma ka yagba di ba, ni ekpo fulu loma mi isɔ gyegwu.>> ");
INSERT INTO utr_vpl VALUES ("RM11_11","075_11_11","ROM","11","11","11","N diyɛ byita gbɛɛ, emi Israi tsiishi gbɛsɛ lamyɛ okyɛɛ-kyɛɛ? Onoka ba dududu! Ola ofaafa mgbi ama nu owatɔ-watɔ ba mbi Udzengye adzi ni Israi di kyofu. ");
INSERT INTO utr_vpl VALUES ("RM11_12","075_11_12","ROM","11","12","12","Kpaa kini adɔ onghaangha mgbi ama yɛɛ mse mbi ɛsɛ, esɛ ogboogbo mgbi ama di yɛɛ mse mbi Udzengye, emi iJuda duu wa gbelan ma, itɔ aludu ngwi inggisɛ mi ɛsɛ duu ka tu ma ka shewo sinɛ! ");
INSERT INTO utr_vpl VALUES ("RM11_13","075_11_13","ROM","11","13","13","N le gbɔdzɛ yi ema Udzengye. Dafi ani li ongye ogbikye iYesu mbi ema Udzengye nɛ, n ka dzɛ yi abɔ otsigɛgɛ mi idɔ mgbɛn ");
INSERT INTO utr_vpl VALUES ("RM11_14","075_11_14","ROM","11","14","14","yi ɛwɛ ogbebyi gbɛɛ kaba n ka kyile emidɛn itukwu esho nu ma kyofu, emi iJuda nu ma watɔ. ");
INSERT INTO utr_vpl VALUES ("RM11_15","075_11_15","ROM","11","15","15","Lubana kini ofwaafwa ngwi emi Israi fwa Imgbasho nɛ yile ɛsɛ duu gyiide yi Imgbasho ma, ogbela-gbela mgbi ama ka li ɛkyɛ tsatso? Ka dzɛ dafi okyile emi ikwukwɔ luba oshishe. ");
INSERT INTO utr_vpl VALUES ("RM11_16","075_11_16","ROM","11","16","16","Kini a kye anggayi ibredi nu Imgbasho yɔ, ibredi olɔlɔ duu kpaa li mgban, ni a di gbe akpekwɔ nu Imgbasho yɔ, abekwɔ kpaa li mgban. ");
INSERT INTO utr_vpl VALUES ("RM11_17","075_11_17","ROM","11","17","17","Ema Udzengye dzɛ dafi abekwɔ olivi ntaagbo ngwi a kye kwokyi yi ekwɔ olivi ongwi inggisɛ okwɔ yeeye mani. Ema gbikye abɔ angbeka ngwi a fwɛlu ma ngwuta nani. Ma mi itɔdzɛ nɛ, ema kpaa li tu mse ndzɛ mbi ekwɔ olivi ngwi a kwokyi-kwokyi nani. ");
INSERT INTO utr_vpl VALUES ("RM11_18","075_11_18","ROM","11","18","18","Nghaduu ka yama tsɛwɛ gbɛɛ abu tatase ngha abɔ ngwi a fwɛlu ma yangwuta na ba. Wɛ ta gbɛɛ, li abu le fyi akpekwɔ anya ba kpaa li akpa le fyi abu anya aali. ");
INSERT INTO utr_vpl VALUES ("RM11_19","075_11_19","ROM","11","19","19","Kaba abu ka gbɔgbɛɛ, <<A kyi fwɛlu abɔ ntonɛ yangwuta ikye okye ani kwokyi mi ele.>> ");
INSERT INTO utr_vpl VALUES ("RM11_20","075_11_20","ROM","11","20","20","Li otsitsi waali. A kyi fwɛlu ma ikyekyɛ a noyɛyɛ ba, kpaa abu kwudzɛ mi oyɛyɛ onuunu. Ka li inggisɛ ohaha ba, kpaa dzɛ yi imio ewo. ");
INSERT INTO utr_vpl VALUES ("RM11_21","075_11_21","ROM","11","21","21","Dafi Imgbasho di emi iJuda ama nli abɔ mgbi atta elela ba nɛ, ema kpaa o ka di ema elela ba ngha aali. ");
INSERT INTO utr_vpl VALUES ("RM11_22","075_11_22","ROM","11","22","22","Onɛnɛ ema di dafi Imgbasho nunɔ di leewo ma lɔ, o nunɔ yi ama ngbɛsɛ mani, kpaa o leewo yi ema, o dika kiyayi oleewo yi ema kini ema kiyayi yi oleewo mgban nɛ yɔ, ni li ngha bayɔ, ema kpaa a ka kyi fwɛlu ema ngwuta. ");
INSERT INTO utr_vpl VALUES ("RM11_23","075_11_23","ROM","11","23","23","Ni a fyumfyikye wuba yɛ noyɛyɛ yɔ, a ka yile ma kwokyi, ikyesinɛ Imgbasho ka yagba yile ma kwokyi. ");
INSERT INTO utr_vpl VALUES ("RM11_24","075_11_24","ROM","11","24","24","Ngwi i dzɛ ngha duu kpaa, yama li ayin ba odulu abɔ olivi ongwi ntaagbo kye wa kwokyi mi ekwɔ olivi osuse. Nghanɛ yama li adzɛ ba ni Imgbasho yile abɔ olivi osuse ongwi a kyi fwɛ ngwuta yilen kwokyi mi ita ma! ");
INSERT INTO utr_vpl VALUES ("RM11_25","075_11_25","ROM","11","25","25","Emi ongwunani, i minɛn gbɛɛ ni ema difwi ungwɔ odaada nɛni, adzi ni ema ka kyile ewo esho ba: Emi Israi angbeka kye itukwu tiishu, a dika kɛɛkiyayi mbinose ngwi mmbwo mgbi Udzengye ka ba ngyɛ mbi Imgbasho. ");
INSERT INTO utr_vpl VALUES ("RM11_26","075_11_26","ROM","11","26","26","Taman emi Israi duu ka watɔ, dafi a lɔ mi Afɛ mani gbɛɛ: <<Ongye odulu inggisɛ watɔ ma ka kyɛ iDzayɔn; o ka kyata emi Israi nu ma nya okwu Imgbasho shanyɛ. ");
INSERT INTO utr_vpl VALUES ("RM11_27","075_11_27","ROM","11","27","27","Dika li ondu obwaabwa mgbi ani yi ama onɔ ngwi n ka kyi kyelu alobube mgbi ama mani.>> ");
INSERT INTO utr_vpl VALUES ("RM11_28","075_11_28","ROM","11","28","28","A kye emi Israi gbɛɛ a li engyikyili mgbi Imgbasho, ikye ni Esɔ Osuse kaka mbi ema Udzengye. Nghaduu a ka li ama ngwu a sadu ma, a di kpa Imgbasho itukwu ikye emi otsikyɔma. ");
INSERT INTO utr_vpl VALUES ("RM11_29","075_11_29","ROM","11","29","29","Lubana ni Imgbasho kye umba nu inggisɛ yɔ, o li yɛ kyi gbɛlu wuba, ama ngwu o kwu ma ela kpaa, o li yɛ fwa ma wuba. ");
INSERT INTO utr_vpl VALUES ("RM11_30","075_11_30","ROM","11","30","30","Yɛyɛ dafi ema onoka nose ngha Imgbasho adɔ kpaa a di ema elela ikye adɔ onghaangha mgbi emi Israi nani, ");
INSERT INTO utr_vpl VALUES ("RM11_31","075_11_31","ROM","11","31","31","nghanɛ ama kpaa yɛ nghaadɔ ikyegbɛɛ ni Imgbasho di ama elela mi elela odiidi ngwi o di ema nani. ");
INSERT INTO utr_vpl VALUES ("RM11_32","075_11_32","ROM","11","32","32","Imgbasho gbe ali inggisɛ duu wokɛ obawi mi adɔ onghaangha mgbi ama, adzi ni ongwu wa di ma duu elela. ");
INSERT INTO utr_vpl VALUES ("RM11_33","075_11_33","ROM","11","33","33","Ɛhɛɛn, inggisɛ oyagba kyi mbalu aludu yi ozoyeye mgbi Imgbasho dzɛma ba! Inggisɛ ka yagba difwi owitukwu mgban hona nu osa mi ungwɔ ama o li kyɔ gbɛ ba! ");
INSERT INTO utr_vpl VALUES ("RM11_34","075_11_34","ROM","11","34","34","Li emɛni ye itukwu Otsɛ? Hona li emɛni wan odzɛ ye? ");
INSERT INTO utr_vpl VALUES ("RM11_35","075_11_35","ROM","11","35","35","Li emɛ nu Imgbasho ungwɔ gbɛɛ no wa yilen kpan ye? ");
INSERT INTO utr_vpl VALUES ("RM11_36","075_11_36","ROM","11","36","36","Lubana alungwɔ duu tɔkyɛ mbon, alungwɔ duu nyɛ mbon dika yɛ lu mbon duu. Okwɔkwɔ duu li mgban gyegwu! No dzɛ ngha. ");
INSERT INTO utr_vpl VALUES ("RM12_1","075_12_1","ROM","12","1","1","Ikyenghanɛ, emi ongwunani, n tɛkyɛ nu ema, mi elela odiidi mgbi Imgbasho, gbɛɛ ni ema kye ewo mgbi ema fifɛ mgbi oshishe osaan nu Imgbasho adzi ni Imgbasho dzɛ yi atsa. Ikyesinɛ li ofɛ ntishi ni ema sunu Imgbasho mi onodzi aani. ");
INSERT INTO utr_vpl VALUES ("RM12_2","075_12_2","ROM","12","2","2","Ka kye ali mgbi ɛsɛ nɛ yi ungwɔ etɔ mgbi ama ba na, kpaa ni Imgbasho kyata ema yɛɛ inggisɛ ofufɛ mi ewodzɛ mgbi ema otsɛɛtsɛ. Ta ema ka yagba ye owitukwu mgbi Imgbasho ikye ema, ntishi di kpaan mani. ");
INSERT INTO utr_vpl VALUES ("RM12_3","075_12_3","ROM","12","3","3","Lubana mi elela ngwi Imgbasho dzɛyan ikye ani kye idɔ nɛ wo ani abɔ nɛ, n le nya ema duu gbɛɛ, ka di ewema miinɛ nyɛ obyi ba, tatase yɔ yile ewema esɛ mi ɛwɛ otsɛɛtsɛ mgbi ema, mi odzɛɛdzɛ mgbi oyɛyɛ onuunu ngwi Imgbasho mba kye nu ema mani. ");
INSERT INTO utr_vpl VALUES ("RM12_4","075_12_4","ROM","12","4","4","Yɛyɛ dafi ali ogyɛngyɛ mbi eyi sulu ikpewo onyi yi alewo ibyibyi nɛni, alewo ntonɛ di sulu idɔ mgbi ama idzidza-dzidza, ");
INSERT INTO utr_vpl VALUES ("RM12_5","075_12_5","ROM","12","5","5","nghanɛ mbi iKrestu yɔ ngwi eyi li ibyibyi nɛ eyi yɛɛ ikpewo onyi, ma ali alewo duu li mgbi ewoma. ");
INSERT INTO utr_vpl VALUES ("RM12_6","075_12_6","ROM","12","6","6","Eyi to yi umba idzidza-dzidza, mi odzɛɛdzɛ mgbi elela ngwi Imgbasho dzɛyan ikye eyi mani. Kini umba mgbi inggisɛ li idɔ oyegbɔ yɔ, no kyɔ gyɔ-gyɔ dafi oyɛyɛ onuunu mgban tso mani. ");
INSERT INTO utr_vpl VALUES ("RM12_7","075_12_7","ROM","12","7","7","Ni li okyɔ angbeka idɔ yɔ, no kyɔ ma idɔ, ni li otsootso yɔ, no tso, ");
INSERT INTO utr_vpl VALUES ("RM12_8","075_12_8","ROM","12","8","8","ni li ofyi inggisɛ mfye itukwu yɔ, no fyi ma mfye itukwu, ni li odi mi imina mgbi angbeka yɔ, no nu dzii, ni li ogbe inggisɛ teyi yɔ, no gbe ma teyi saan, ni li odi elela yɔ, no kyɔ yi ewo oshɛta. ");
INSERT INTO utr_vpl VALUES ("RM12_9","075_12_9","ROM","12","9","9","Okpitukwu no li mi otsitsi. Ungwɔ obube no ta abu anyi; dzlɛ bɛkɛ yi ungwɔ osuse. ");
INSERT INTO utr_vpl VALUES ("RM12_10","075_12_10","ROM","12","10","10","Di ewema kpitukwu dafi engwunewe mani. Nu angbeka mmwɛ ngha ewabu. ");
INSERT INTO utr_vpl VALUES ("RM12_11","075_12_11","ROM","12","11","11","Ka yama kyɔ ewewa mi idɔ mgbi Otsɛ ononyi ba, kpaa zola mi Onodzi di kiyayi okyɔn idɔ. ");
INSERT INTO utr_vpl VALUES ("RM12_12","075_12_12","ROM","12","12","12","Dzɛ yi atsa mi ɛwɛ ogbe byiibyi na, shitukwu mi adzɛ dika ndɛ yi ibɔ obɔɔbɔ ba. ");
INSERT INTO utr_vpl VALUES ("RM12_13","075_12_13","ROM","12","13","13","Ghalu ungwɔ ngwi abu sulun yi emidi Imgbasho ama ungwɔ kwoma oba. Kiyayi oshabɔta. ");
INSERT INTO utr_vpl VALUES ("RM12_14","075_12_14","ROM","12","14","14","Bɔ Imgbasho ibɔ no kye mse bɛ ama nle nu abu isɔ ma ewo; no ka li ikamba ba. ");
INSERT INTO utr_vpl VALUES ("RM12_15","075_12_15","ROM","12","15","15","Tsatsa yi ama nle tsatsa; kye abɔ tiko yi ama nkye abɔ tiko mani. ");
INSERT INTO utr_vpl VALUES ("RM12_16","075_12_16","ROM","12","16","16","Dzɛ ondonyi yi ewema na. Ka yama kyile ewo esho ba, kpaa gye tsa yi inggisɛ ama n yɛyikpa kpaa mani. Ka di ewema miinɛ ba. ");
INSERT INTO utr_vpl VALUES ("RM12_17","075_12_17","ROM","12","17","17","Ka yama yile mkpa ungwɔ obube kpa inggisɛ mi obube ba. Gbeka dzɛ no kyungwɔ nli ayin mi inɛ ali inggisɛ duu. ");
INSERT INTO utr_vpl VALUES ("RM12_18","075_12_18","ROM","12","18","18","Fya mi ofyaafya mgbi abu no dzɛ mi iyu yi ali inggisɛ duu. ");
INSERT INTO utr_vpl VALUES ("RM12_19","075_12_19","ROM","12","19","19","Emi okani ka yama kpa mkpa ba na, dzata abɔ ni Imgbasho kpumkpa na abɔn, lubana a lɔ mi Afɛ gbɛɛ, <<Mkpa okpaakpa li idɔ mgbi ani; n ka yilen kpa,>> Li ngha Otsɛ gbɔ aali. ");
INSERT INTO utr_vpl VALUES ("RM12_20","075_12_20","ROM","12","20","20","Tatase yɔ, <<Ka nu enbwa dɔ ongyikyili mgbɔɔ hona nu ekweni kwun ba, kpaa nun ungwogye no gye di nun ungwɔ owawa no wa. Kini abu kyɔ ngha yɔ, o gbe angola oyɔɔ tukwun ikye.>> ");
INSERT INTO utr_vpl VALUES ("RM12_21","075_12_21","ROM","12","21","21","Ka yama nu ungwɔ obube ngha abu ba, kpaa ngha ungwɔ obube yi osuse okyɔɔkyɔ. ");
INSERT INTO utr_vpl VALUES ("RM13_1","075_13_1","ROM","13","1","1","Ali inggisɛ duu no sunu ama ogbe ɛsɛ teyi kyɛmɛ, lubana mfye oka dzɛma ba sede li ongwi Imgbasho kye dzɛ mani. Mfye ama nto ɛsɛ nɛ duu li Imgbasho ta ma. ");
INSERT INTO utr_vpl VALUES ("RM13_2","075_13_2","ROM","13","2","2","Ikyenghanɛ ama ntuo afɔ esɛ yi mfye nɛ duu le tuo afɔ esɛ yi ungwɔ ngwi Imgbasho kye dzɛ, ama ndi kyɔ ngha duu a ka gbɔ ma ikwɔ. ");
INSERT INTO utr_vpl VALUES ("RM13_3","075_13_3","ROM","13","3","3","Lubana ama ogbe ɛsɛ teyi yama li sulu owitukwu obube mbi ama nle kyɔ ali osuse ba, sede mbi ama okyɔ ali ibwubwe mata. I mina abu odzɛ yi ewo oshɛta mbi inggisɛ mfye baa? Ngyɛse kyungwɔ osuse ta o ka tsɛ abu. ");
INSERT INTO utr_vpl VALUES ("RM13_4","075_13_4","ROM","13","4","4","Bana o li ongbidɔ mgbi Imgbasho ikye okyɔ yi abu saan. Kpaa kini abu le kyɔ obube yɔ, mio, lubana okwusunkli ngwi o kye byabɔ na li ayayi ba. O li ongbidɔ mgbi Imgbasho, o li inggisɛ nka ba yi adɔ okwookwo mbi ama okyɔ obube. ");
INSERT INTO utr_vpl VALUES ("RM13_5","075_13_5","ROM","13","5","5","Ikyenghanɛ, li kyɛmɛ-kyɛmɛ ni abu sunu mfye, li ikye adɔ okwookwo kyɛmɛ ba kpaa dafi itukwu mgbi abu tso abu mani. ");
INSERT INTO utr_vpl VALUES ("RM13_6","075_13_6","ROM","13","6","6","Di li itɔdzɛ ngwi ema li kpa udza ifyɛɛ kpaa ma aani, bana emi mfye ntonɛ a li engbidɔ mgbi Imgbasho, a kyi kyelu onɔ mgbi ama duu ogbinɛbyi ɛsɛ. ");
INSERT INTO utr_vpl VALUES ("RM13_7","075_13_7","ROM","13","7","7","Alungwɔ ngwi abu sulu inggisɛ ele duu kye nun: kini abu kpa udza ifyɛɛ wa bayɔ, fya no kpa; ni li udza idu oka-ka yɔ, nu ma ka; ni li mmwɛ yɔ, nu mmwɛ; ni li oshewo yɔ, nu oshewo. ");
INSERT INTO utr_vpl VALUES ("RM13_8","075_13_8","ROM","13","8","8","Ka nu mkpa dɔ abu ikye ba, sede mkpa onu ema kpa ewe itukwu ta, lubana inggisɛ ndi odon kpan itukwu yɔ, o nu ola mbwumbwo. ");
INSERT INTO utr_vpl VALUES ("RM13_9","075_13_9","ROM","13","9","9","Ola ma gbɛɛ, <<Ka gbo amah ba,>> <<Ka ngwɔ inggisɛ ba,>> <<Ka yimi ba,>> <<Ka di ungwɔ engye mbe anggwɔ ba,>> ola angbeka nsisi duu a kwulu wokɛ mbonyi gbɛɛ: <<Di inggisɛ ama nwatse dɔ abu kpa abu itukwu dafi ewabu mani.>> ");
INSERT INTO utr_vpl VALUES ("RM13_10","075_13_10","ROM","13","10","10","Okpitukwu dzɛ yi ungwɔ obube ikye odon ba. Nghanɛ ni abu dzɛ yi okpitukwu yɔ, abu ngyɛlu ola duu. ");
INSERT INTO utr_vpl VALUES ("RM13_11","075_13_11","ROM","13","11","11","Le kyungwɔnɛni, difwi onɔ ongwi onɛnɛni. Onɔ gyɔ ngwi ema ka kyato mi una onaana, ikyekyɛ owatɔ-watɔ mgbi eyi nghao dzɛ kwɛkwɛ onɛnɛ ngha ababɔ nose ngwi eyi noyɛyɛ mani. ");
INSERT INTO utr_vpl VALUES ("RM13_12","075_13_12","ROM","13","12","12","Otu nɛ kɛ kpini wa; egbe dzɛ kwɛkwɛ ofaafa. Nghanɛ ni eyi dzata ali ama ngwi eyi li kyɔ ma mi iyifu ntonani di gbe okyiika mgbi osa wo ewo. ");
INSERT INTO utr_vpl VALUES ("RM13_13","075_13_13","ROM","13","13","13","Ni i le kyungwɔ mi oloola, dafi ngbuo okyɔ mi onɔ mani, no ka li mi oga ibwubwe yi ɛbyɛ ofyaafya ba, no ka li mi amah ba, kale gbɔnɔgbɛ hona kyofu yi ewema ba na. ");
INSERT INTO utr_vpl VALUES ("RM13_14","075_13_14","ROM","13","14","14","Nghaduu, gbɛ Otsɛ iYesu iKrestu wo ewo, dika tsɛwɛ ofɛ ngwi abu ka kyɔ imina mgbi ali ibwubwe ba. ");
INSERT INTO utr_vpl VALUES ("RM14_1","075_14_1","ROM","14","1","1","Gbela yi inggisɛ ngwu oyɛyɛ onuunu mgban fyumfye ba kpaa, kale natsondu mi ewodzɛ mgbi ama otsɛɛtsɛ ba. ");
INSERT INTO utr_vpl VALUES ("RM14_2","075_14_2","ROM","14","2","2","Oyɛyɛ onuunu mgbi inggisɛ oka li non gye alungwɔ duu, kpaa inggisɛ oka ngwu oyɛyɛ mgban fyumfye bayɔ, li gye afɔdɔɔ kyoon. ");
INSERT INTO utr_vpl VALUES ("RM14_3","075_14_3","ROM","14","3","3","Inggisɛ nli gye alungwɔ duu na no ka di ongwu nli gye afodɔɔ ta na gbɛɛ di o li unka ba ba. Inggisɛ ndi li sadu-sadu ungwogye na, no ka di ongwu nli gye duu na gbɛɛ o dzɛ mi itɔdzɛ ba ba, lubana Imgbasho gbela yi ama duu. ");
INSERT INTO utr_vpl VALUES ("RM14_4","075_14_4","ROM","14","4","4","Abu li ɛmɛ ogbɔ ongbidɔ mgbi inggisɛ oka ikwɔ? Non wɛndɛ hona le kyɔ ayin kpaa li ongyukwo mgban ka ye. Li Otsɛ ka non kyungwɔ nli ayin gbɛ, di li ongyukwo mgban ka nun emyɛmyɛ aali. ");
INSERT INTO utr_vpl VALUES ("RM14_5","075_14_5","ROM","14","5","5","Inggisɛ oka li di gbɛɛ egbe oka le saan ngha oka; inggisɛ oka li di gbɛɛ egbe duu li ungwonyi. Ali inggisɛ no di dafi itukwu mgban nyan mani. ");
INSERT INTO utr_vpl VALUES ("RM14_6","075_14_6","ROM","14","6","6","Inggisɛ nli di egbe oka gbɛɛ i nghao le saan na, le kyɔ ngha okye mmwɛ nu Otsɛ. Inggisɛ nli gye mmbwɛ na, le gye ikye okye mmwɛ nu Otsɛ, lubana o li ta Imgbasho angba; inggisɛ nfwa mmbwɛ na kpaa, fwa ikye okye mmwɛ nu Otsɛ di li ta Imgbasho angba. ");
INSERT INTO utr_vpl VALUES ("RM14_7","075_14_7","ROM","14","7","7","Lubana eyi dzɛ oshishe ikye eweyi hona kwulu ikye eweyi ba. ");
INSERT INTO utr_vpl VALUES ("RM14_8","075_14_8","ROM","14","8","8","Kini eyi dzɛ oshishe yɔ, i dzɛ ikye Otsɛ; kini eyi di kwulu kpaa, i kwulu ikye Otsɛ. Nghanɛ, ni eyi dzɛ oshishe hona kwulu kpaa, eyi li mgbi Otsɛ. ");
INSERT INTO utr_vpl VALUES ("RM14_9","075_14_9","ROM","14","9","9","Li itɔdzɛ nɛ yɛyɛ ngwi iKrestu kwulu diyɛ kyɛɛ ikyegbɛɛ ni ongwu li Otsɛ mgbi emi ikwukwɔ yi emi oshishe duu aali. ");
INSERT INTO utr_vpl VALUES ("RM14_10","075_14_10","ROM","14","10","10","Ema ma, li ikye ekyɛ ngwi ema le ngwɔ emi ongwunema ikwɔ? Hona kyɔnɛ ngwi ema le di ongwunema gbɛɛ a li unka ba? Lubana egbe kyɛma ngwi Imgbasho ka gbɔ eyi duu ikwɔ. ");
INSERT INTO utr_vpl VALUES ("RM14_11","075_14_11","ROM","14","11","11","Ikyesinɛ Otsɛ gbɔ mi Afɛ gbɛɛ, <<Ani fa mi oshishe mgbi ani gbɛɛ ali akwafɔ duu ka kwɛsɛ nu ani, ali idɛ dika kyɔ obwɛndɛ kye otsɛɛtsɛ nu Imgbasho!>> ");
INSERT INTO utr_vpl VALUES ("RM14_12","075_14_12","ROM","14","12","12","Inghawanɛ, ali inggisɛ duu ka wa gbɔ ungwɔ ngwi otsungwɔn kyɔ nya Imgbasho. ");
INSERT INTO utr_vpl VALUES ("RM14_13","075_14_13","ROM","14","13","13","Nghanɛ ni eyi nya ogbɔ eweyi ikwɔ. Tatase, fya kyɔ ali nka wo ongwunabu ekle ba mani. ");
INSERT INTO utr_vpl VALUES ("RM14_14","075_14_14","ROM","14","14","14","Ngwi ani dzɛ mi ifu Otsɛ iYesu nɛ, n difwi saan gbɛɛ ungwogye onyi ka nu ani tsiidza ba. Nghaduu ni inggisɛ di gbɛɛ ungwɔ tsiidza yɔ, i tsiidza mbon sewaali. ");
INSERT INTO utr_vpl VALUES ("RM14_15","075_14_15","ROM","14","15","15","Kini ongwunabu le tu esɛ ogboogbo mi ungwɔ ngwi abu le gye yɔ, okyɔɔkyɔ mgbi abu tso okpitukwu wuba. Ka yama nu ongwunabu ongwu iKrestu kwulu ikyon dzili ikye ungwɔ ogyeegye mgbi abu ba. ");
INSERT INTO utr_vpl VALUES ("RM14_16","075_14_16","ROM","14","16","16","Ka noofɛ ni inggisɛ gbɔdzɛ obube kwu iyi ungwɔ ngwi abu di gbɛɛ li osuse na ba. ");
INSERT INTO utr_vpl VALUES ("RM14_17","075_14_17","ROM","14","17","17","Bana esutɔ mgbi Imgbasho li ungwɔ ogyeegye hona ungwɔ owaawa ba, kpaa li osaan, li iyu bɛyi atsa mi Onodzi Osaan. ");
INSERT INTO utr_vpl VALUES ("RM14_18","075_14_18","ROM","14","18","18","Ni inggisɛ kyɔ iKrestu idɔ mi itɔ ofɛ nɛ yɔ li kpa Imgbasho, di li kpa inggisɛ kpaa. ");
INSERT INTO utr_vpl VALUES ("RM14_19","075_14_19","ROM","14","19","19","Ni eyi fya mi ofyaafya mgbi eyi duu okyungwɔ nka ba yi iyu, di tobyi eweyi ikye ni eyi fyumfye mi oyɛyɛ onuunu mgbi eyi mani. ");
INSERT INTO utr_vpl VALUES ("RM14_20","075_14_20","ROM","14","20","20","Ka yama kyi mbelu idɔ mgbi Imgbasho ikye ungwogye ba. Ali ungwogye duu li osuse, kpaa li ayin ba ni abu gye ungwɔ nka nu inggisɛ oka esɛ ogboogbo yɔ. ");
INSERT INTO utr_vpl VALUES ("RM14_21","075_14_21","ROM","14","21","21","Tatase ogye mmbwɛ, naadi wa eneekwɔ hona kyɔ unkoka nka nu ongwunabu esɛ ogboogbo ba mani. ");
INSERT INTO utr_vpl VALUES ("RM14_22","075_14_22","ROM","14","22","22","Oyɛyɛ onuunu ngwi abu tulun mi ungwɔ ntonɛ ma no li abu yi Imgbasho efa ta. Mse dzɛ yi inggisɛ ndzɛ yi itukwu efefa ba mi ungwɔ ngwi o gbela okyɔ mani. ");
INSERT INTO utr_vpl VALUES ("RM14_23","075_14_23","ROM","14","23","23","Nghaduu inggisɛ ngwu itukwu dzan efefa mi ungwɔ ngwi o le gye yɔ a ngwɔn ikwɔ, ikyekyɛ o gye yi oyɛyɛ onuunu ba. Alungwɔ ngwi inggisɛ kyɔ mi oyɛyɛ onuunu ba duu li alobube. ");
INSERT INTO utr_vpl VALUES ("RM15_1","075_15_1","ROM","15","1","1","Eyi ama oyɛyɛ onuunu mgbi eyi fyumfye nɛ, ni eyi tobyi ama nfyumfye ba ntonani. Ni eyi kale kyungwɔ okpa eweyi kyoon ba. ");
INSERT INTO utr_vpl VALUES ("RM15_2","075_15_2","ROM","15","2","2","Ni eyi duu kyungwɔ nka kpa ama nwatse dɔ eyi ikye oyabɔ mgbi ama di fyu ma mfye itukwu mi oyɛyɛ onuunu mgbi ama. ");
INSERT INTO utr_vpl VALUES ("RM15_3","075_15_3","ROM","15","3","3","Lubana iKrestu abuon kpaa kyungwɔ gbɛɛ no kpa ewon ba, dafi Afɛ gbɔ mani gbɛɛ, <<Ito ngwi a le fya abu Imgbasho ma li ani ngwu a le fya.>> ");
INSERT INTO utr_vpl VALUES ("RM15_4","075_15_4","ROM","15","4","4","Bana alungwɔ ngwi a lɔ mi Afɛ tugbe duu li ikye otso di nu eyi itukwu ofyumfye adzi ni eyi gbekabyi. ");
INSERT INTO utr_vpl VALUES ("RM15_5","075_15_5","ROM","15","5","5","Ni Imgbasho nli nu itukwu oshiishi di kwu inggisɛ ɛwɛ wo na nu ema onodzi odzɛ ondonyi ngwi ema le kyɛdɔ iKrestu iYesu nɛni, ");
INSERT INTO utr_vpl VALUES ("RM15_6","075_15_6","ROM","15","6","6","adzi ni ema tsɛ Imgbasho Otsɔ iYesu iKrestu Otsɛ mgbi eyi mi ondonyi yi itukwu onyi mani. ");
INSERT INTO utr_vpl VALUES ("RM15_7","075_15_7","ROM","15","7","7","Gbela yi ewema na, yɛyɛ dafi iKrestu gbela yi ema nɛni, ikye ni iyi Imgbasho gye oshewo. ");
INSERT INTO utr_vpl VALUES ("RM15_8","075_15_8","ROM","15","8","8","Bana n nya ema gbɛɛ iKrestu ba dafi ongbidɔ mbi emi iJuda ikye otso gbɛɛ Imgbasho kyɔ ondu ngwi o dzɛ yi emi otsikyɔma mani ");
INSERT INTO utr_vpl VALUES ("RM15_9","075_15_9","ROM","15","9","9","adzi ni Udzengye kye iyi Imgbasho desho mi elela ngwi o di ma nani, bana Afɛ lɔ gbɛɛ, <<Ikyenghanɛ n ka tsɛ iyi abu mi idzidzɛ Udzengye; N ka shashi mi iyi mgbi abu.>> ");
INSERT INTO utr_vpl VALUES ("RM15_10","075_15_10","ROM","15","10","10","Afɛ di lɔ gbɛɛ, <<Ema Udzengye tsatsa yi emidi Imgbasho na.>> ");
INSERT INTO utr_vpl VALUES ("RM15_11","075_15_11","ROM","15","11","11","A di lɔ gbɛɛ, <<Inggisɛ mi ɛsɛ duu nu ma kyile iyi Otsɛ desho di shin ashi mmwɛ.>> ");
INSERT INTO utr_vpl VALUES ("RM15_12","075_15_12","ROM","15","12","12","Adzaya di lɔ gbɛɛ, <<Mi inyabyi mgbi iJese, inggisɛ ka wa tɔ mi ele nka li utɔ mi ɛsɛ duu; Udzengye duu ka gbɛwɛbyi mbon.>> ");
INSERT INTO utr_vpl VALUES ("RM15_13","075_15_13","ROM","15","13","13","Ni Imgbasho nli nu ɛwɛ ogbe byiibyi na mbwo ema yi atsa bɛyi iyu dafi ema nun oyɛyɛ nɛni, ikye ni ɛwɛ ogbe byiibyi mgbi ema mbwo mi mfye mgbi Onodzi Osaan. ");
INSERT INTO utr_vpl VALUES ("RM15_14","075_15_14","ROM","15","14","14","Emi ongwunani, ani abuen kpaa n gbela gbɛɛ ema li kyɔ osuse kpakpa di sulu oyeye di mɛ otso ewema. ");
INSERT INTO utr_vpl VALUES ("RM15_15","075_15_15","ROM","15","15","15","Ani lɔ afɛ nya ema mi itɔdzɛ angbeka saan, n diyɛ le wɛ ema, ikye elela ngwi Imgbasho di ani nɛni. ");
INSERT INTO utr_vpl VALUES ("RM15_16","075_15_16","ROM","15","16","16","O dulu ani oli inggisɛ ogbeesɔ mgbi iKrestu iYesu nya Udzengye di kyidɔ mgbi inggisɛ ofifɛ ogbɔ Esɔ Osuse mgbi Imgbasho, ikye ni Udzengye yɛɛ umba osuse ngwi Imgbasho gbela yan, ngwi Onodzi Osaan kyi salu ma mani. ");
INSERT INTO utr_vpl VALUES ("RM15_17","075_15_17","ROM","15","17","17","Ikyenghanɛ n dzɛ yi abɔ otsigɛgɛ mbi iKrestu iYesu mi idɔ ngwi ani le kyɔ Imgbasho ele nɛni. ");
INSERT INTO utr_vpl VALUES ("RM15_18","075_15_18","ROM","15","18","18","N ka yama kyɔ odzasha ogbɔdzɛ oka idzidza ba sede ungwɔ ngwi iKrestu kyɔ nyɛ ikpewo ani ogbe Udzengye teyi nu ma sunu Imgbasho mi ungwɔ ngwi ani gbɔ diyɛ kyɔ mani, ");
INSERT INTO utr_vpl VALUES ("RM15_19","075_15_19","ROM","15","19","19","mi mfye mgbi ambɛ yi ungwɔ ama okwulewo, mi mfye mgbi Onodzi Osaan. Nghanɛ wita mi iJerosalin nghataa lu Ililikun n gbɔ Esɔ Osuse mgbi iKrestu nɛ saan. ");
INSERT INTO utr_vpl VALUES ("RM15_20","075_15_20","ROM","15","20","20","Teyi li imina mgbi ani ogbɔ Esɔ Osuse mi imbe ngwi a ye iKrestu waba, adzi nin wa le mbɛ dɔkɛ itozu mgbi inggisɛ oka ba mani. ");
INSERT INTO utr_vpl VALUES ("RM15_21","075_15_21","ROM","15","21","21","Nghaduu dafi a lɔ mi Afɛ mani gbɛɛ, <<Ama ngwu a teyi nya ma odzɛ mgban waba ka wa din, bɛyi ama nteyi fwo waba kpaa ka tu osa.>> ");
INSERT INTO utr_vpl VALUES ("RM15_22","075_15_22","ROM","15","22","22","Li itɔdzɛ nɛ ngwi ani li tu onɔ oka kpadi ema ba aali. ");
INSERT INTO utr_vpl VALUES ("RM15_23","075_15_23","ROM","15","23","23","Nghaduu onɛnɛ ngwi ani sulu imbe okyidɔ mi ayɛsɛ ntonɛ wuba, ngwi i di dzɛ ani itukwu onova ibyibyi odi ema nɛ, ");
INSERT INTO utr_vpl VALUES ("RM15_24","075_15_24","ROM","15","24","24","n weka onyɛ kpadi ema onɔ ngwi n kale kɛ iSpɛn mani. Tonya di kyɔ atsa yi ema ongwonɔ gwee adzi ni ema yɛn abɔ mi okyɛɛ mgbɛn. ");
INSERT INTO utr_vpl VALUES ("RM15_25","075_15_25","ROM","15","25","25","Ngwi i dzɛ ngha duu nɛ kpaa, n dzɛ ofɛ le lu iJerosalin oka tobyi emi osaan. ");
INSERT INTO utr_vpl VALUES ("RM15_26","075_15_26","ROM","15","26","26","Lubana i kpa emi iMasidonia yi emi Acaya onu umba ikye emi osaan ndzɛ abubɔ mi iJerosalin. ");
INSERT INTO utr_vpl VALUES ("RM15_27","075_15_27","ROM","15","27","27","A kyɔ yi atsa, mi otsitsi yɔ i gbuo ngwi a ki kyɔ ngha yi ama. Lubana ni Udzengye tu mse ongwi onodzi mbi emi iJuda yɔ, ama kpaa i gbuo nu ma kyi ghalu ungwɔ ama ngwi a sulun ma yi emi iJuda. ");
INSERT INTO utr_vpl VALUES ("RM15_28","075_15_28","ROM","15","28","28","Nin kye awuya nɛ nu ma ngyɛ yɔ, n ka nyɛ kpadi ema se wa lu iSpɛn. ");
INSERT INTO utr_vpl VALUES ("RM15_29","075_15_29","ROM","15","29","29","N ye onɔ ngwi ani ka ba mbi ema ma, n ka kyɛ yi mse mgbi iKrestu kyɛɛ. ");
INSERT INTO utr_vpl VALUES ("RM15_30","075_15_30","ROM","15","30","30","Emi ongwunani, n tɛkyɛ nu ema mbi Otsɛ iYesu iKrestu bɛyi mi okpitukwu mgbi Onodzi gbɛɛ, bɔ Imgbasho ibɔ kpɔklɔɔ mi ikye ogbili-gbili mgbɛn nɛni. ");
INSERT INTO utr_vpl VALUES ("RM15_31","075_15_31","ROM","15","31","31","Bibɔ ikye nin watɔ mi abɔ emi iJudia ama nnoyɛyɛ ba, ni emi osaan mi iJerosalin di gbela yi idɔ ngwi ani le kyɔ, ");
INSERT INTO utr_vpl VALUES ("RM15_32","075_15_32","ROM","15","32","32","adzi ni Imgbasho nin ofɛ nin ba mbi ema yi atsa, adzi ni eyi kwu eweyi ɛwɛ wo. ");
INSERT INTO utr_vpl VALUES ("RM15_33","075_15_33","ROM","15","33","33","Ni Imgbasho onu iyu na dzɛ yi ema duu. No dzɛ ngha. ");
INSERT INTO utr_vpl VALUES ("RM16_1","075_16_1","ROM","16","1","1","N tsɛ ongwuneyi ongwu ongyaa iFoebe, nli ongyiidɔ mi okwakye mgbi emi iKrestu mi iSɛnkria nani. ");
INSERT INTO utr_vpl VALUES ("RM16_2","075_16_2","ROM","16","2","2","N le gbɛɛ ni ema gban dafi i gbuo ogbɛ inggisɛ nnoyɛyɛ mbi Otsɛ di yan abɔ mi onɔ ngwi o mina oyabɔ mbi ema mani, lubana o tobyi inggisɛ kwuba, ani abuen kpaa. ");
INSERT INTO utr_vpl VALUES ("RM16_3","075_16_3","ROM","16","3","3","Ta iPrisila yi Akwila angba, ama nle kyidɔ iKrestu iYesu yi ani ungwonyi ntonani. ");
INSERT INTO utr_vpl VALUES ("RM16_4","075_16_4","ROM","16","4","4","A kye oshishe mgbi ama lasɛ ikye ani kpaa. Okwakye mgbi emi iKrestu mi Udzengye duu gbede nu ma li ani yuwen ba. ");
INSERT INTO utr_vpl VALUES ("RM16_5","075_16_5","ROM","16","5","5","Ta emi iKrestu ama nli kwakye mi udɛ ma na kpaa angba. Ta Epenetu okani itukwu-tukwu nli inggisɛ ababɔ okyatitukwu mi ayɛsɛ mgbi Asia luba iKrestu na kpaa angba. ");
INSERT INTO utr_vpl VALUES ("RM16_6","075_16_6","ROM","16","6","6","Ta iMeri nli kwunewo idɔ ikye ema na angba. ");
INSERT INTO utr_vpl VALUES ("RM16_7","075_16_7","ROM","16","7","7","Ta Andronikɔ yi iJunaya emi oden, ama nkaka obawi yɛn na angba. Ama ogbikye iYesu li nu ma mmwɛ nngwashaba, a di teyi ani dzɛ mi ifu iKrestu kpaa. ");
INSERT INTO utr_vpl VALUES ("RM16_8","075_16_8","ROM","16","8","8","Ta Ampliyatu nkpa ani itukwu mbi Otsɛ na angba. ");
INSERT INTO utr_vpl VALUES ("RM16_9","075_16_9","ROM","16","9","9","Ta Ubanu ngwu nkwokyi abɔ yi eyi mi idɔ iKrestu na angba, di ta okani imɔ iStaci angba. ");
INSERT INTO utr_vpl VALUES ("RM16_10","075_16_10","ROM","16","10","10","Ta Apele ongwu a mbadin di gbela yan mi ifu iKrestu na angba. Ta emidi Aristobulu angba. ");
INSERT INTO utr_vpl VALUES ("RM16_11","075_16_11","ROM","16","11","11","Ta oden iHerodiɔn angba. Ta emidi iNasisɔ ama nto mi ifu Otsɛ ma angba. ");
INSERT INTO utr_vpl VALUES ("RM16_12","075_16_12","ROM","16","12","12","Ta iTrafena yi iTrafosa engyaa ama nkyɔ Otsɛ idɔ kpɔklɔɔ na angba. Ta okani imɔ iPesi, ongyaa oka ndi kwunewo idɔ mi ifu Otsɛ na angba. ");
INSERT INTO utr_vpl VALUES ("RM16_13","075_16_13","ROM","16","13","13","Ta iRufu ngwu Otsɛ dulun na, bɛyi onɔn n yɛɛ dafi onani kpaa na angba. ");
INSERT INTO utr_vpl VALUES ("RM16_14","075_16_14","ROM","16","14","14","Ta Asinkritɔ, iFlegɔn, iHɛmɛ, iPatroba, iHɛma bɛyi emi iKrestu ama nto yi ama ma angba. ");
INSERT INTO utr_vpl VALUES ("RM16_15","075_16_15","ROM","16","15","15","Ta iFyilologɔ yi iJulia yi iNeliɔ bɛyi ongwunɔn ongwi ongyaa, di ta Olimpa bɛyi emi osaan ama nto yi ama duu angba. ");
INSERT INTO utr_vpl VALUES ("RM16_16","075_16_16","ROM","16","16","16","Ta ewema angba tsɛkwulu ewema na. Okwakye emi iKrestu duu le ta ema angba. ");
INSERT INTO utr_vpl VALUES ("RM16_17","075_16_17","ROM","16","17","17","N le tɛkyɛ nu ema emi ongwunani gbɛɛ, ni ema gbɛwɛbyi ama nli ba yi ogbua-gbua di li wo ema ekle yi otsootso nnyɛ idzidza yi otsootso ngwi ema teyi kpayi nani. Fyata yi ama. ");
INSERT INTO utr_vpl VALUES ("RM16_18","075_16_18","ROM","16","18","18","Lubana itɔ inggisɛ ntona yama le sunu Otsɛ iKrestu mgbi eyi ba, kpaa a le kyɔ ikye ifu mgbi ama. A li kpagya ogbadrɔ wo yi ondu ofyumfya mgbi ama. ");
INSERT INTO utr_vpl VALUES ("RM16_19","075_16_19","ROM","16","19","19","Ali inggisɛ duu fwo dafi ema li siikyenu mani, nghanɛ n dzɛ yi atsa kpakpa ikye ema; nghaduu i minɛn gbɛɛ ni ema difwi ungwɔ nli osuse, dulu abɔ mi ungwɔ obube. ");
INSERT INTO utr_vpl VALUES ("RM16_20","075_16_20","ROM","16","20","20","Imgbasho iyu na ka dziyɛ iSatan dzikan-dzikan ni ema kye afɔ dzin. Ni elela mgbi Otsɛ iYesu mgbi eyi dzɛ yi ema. ");
INSERT INTO utr_vpl VALUES ("RM16_21","075_16_21","ROM","16","21","21","ITimoti ngwu eyi le kyidɔ yi eka, dɛsɔ angba mbi ema, li ngha ngwi iLusiɔ yi iJasɔn bɛyi iSosipata emi odo ani ntonɛ kpaa dɛsɔ angba aali. ");
INSERT INTO utr_vpl VALUES ("RM16_22","075_16_22","ROM","16","22","22","Ani iTediɔ, nlɔ afɛ nɛ, le ta ema angba mbi Otsɛ. ");
INSERT INTO utr_vpl VALUES ("RM16_23","075_16_23","ROM","16","23","23","IGayɔsu, inggisɛ oshabɔta ngwu ani yi emi iKrestu duu tu mgbede mbon na, le ta ema angba. Erastɔ, nli di mi ali idɔ mi ogalu na yi ongwuneyi iKwatu tole ta ema angba. ");
INSERT INTO utr_vpl VALUES ("RM16_24","075_16_24","ROM","16","24","24","Ni elela mgbi Otsɛ iYesu iKrestu mgbi eyi dzɛ yi ema duu. No dzɛ ngha. ");
INSERT INTO utr_vpl VALUES ("RM16_25","075_16_25","ROM","16","25","25","Ba ni eyi kye oshewo nu Imgbasho Ongwu n yagba nu ema kwudzɛ kpɔklɔɔ mi oyɛyɛ onuunu mgbi ema, dafi Esɔ Osuse mgbi iYesu iKrestu lɔ ngwi ani gbɔ kwulu iba ungwɔ odaada ngwi a kye da onɔ tunto nya ema nɛni. ");
INSERT INTO utr_vpl VALUES ("RM16_26","075_16_26","ROM","16","26","26","Nghaduu onɛnɛ i fwi tɔ a di yen mi ungwɔ olɔɔlɔ mgbi ama ogbɛɛsɛ mi ola ngwi Imgbasho ogyegwu na wo mani, adzi ni ɛsɛ duu noyɛyɛ di siikye nun. ");
INSERT INTO utr_vpl VALUES ("RM16_27","075_16_27","ROM","16","27","27","Ni okwɔkwɔ dzɛ mbi Imgbasho nkwiinɛ yuon na mi ikpewo iYesu iKrestu gyegwu-gyegwu! No dzɛ ngha.");
INSERT INTO utr_vpl VALUES ("C11_1","076_1_1","1CO","1","1","1","Afɛ nɛ kyɛ mbi ani iPol ngwu Imgbasho kwu ani ela mi oweka mgban gbɛɛ ni ani li inggisɛ ogbikye iKrestu iYesu bɛyi iSɔstɛnɛ ongwuneyi nɛni. ");
INSERT INTO utr_vpl VALUES ("C11_2","076_1_2","1CO","1","2","2","Ani le lɔ kɛ mbi emi odzimgbasho mi iKorinti, mbi ama ngwu a salu ma mbi iKrestu iYesu diyɛ kwu ma ela owa yɛɛ saan, bɛyi ama nli kwu mi iyi mgbi iYesu iKrestu mgbi eyi mi ali imbe duu gbɛɛ, Otsɛ mgbi ama bɛyi mgbi eyi nani. ");
INSERT INTO utr_vpl VALUES ("C11_3","076_1_3","1CO","1","3","3","Elela bɛyi iyu nkyɛ mbi Otseyi Imgbasho bɛyi Otsɛ iYesu iKrestu na no dzɛ yi ema. ");
INSERT INTO utr_vpl VALUES ("C11_4","076_1_4","1CO","1","4","4","Ani li ta Imgbasho angba alonɔ duu ikye ema mi ikye elela ngwi o kye nu ema mi ikpewo iYesu iKrestu nani. ");
INSERT INTO utr_vpl VALUES ("C11_5","076_1_5","1CO","1","5","5","Lubana li mbon ngwi ema yɛɛ aludu mi ali itɔ ofɛ duu, mi odzɛ ogbɔɔgbɔ bɛyi ozoyeye mgbi ema aani, ");
INSERT INTO utr_vpl VALUES ("C11_6","076_1_6","1CO","1","6","6","Ikyena obwɛndɛ mgbi eyi ikye iKrestu tɔ gedee mbi ema. ");
INSERT INTO utr_vpl VALUES ("C11_7","076_1_7","1CO","1","7","7","Nghanɛ ema kwoba yi umba mgbi onodzi ba dafi i dzɛ ema kwɔkwɔ mi oyɛɛyɛ mgbi iYesu iKrestu nani. ");
INSERT INTO utr_vpl VALUES ("C11_8","076_1_8","1CO","1","8","8","O ka nu ema mfye nghataa kɛ ongyɛɛngyɛ, zukwu ni a wa di ema yi obube mi egbe ngwi Otsɛ mgbi eyi iYesu iKrestu ka yɛ na ba mani. ");
INSERT INTO utr_vpl VALUES ("C11_9","076_1_9","1CO","1","9","9","Imgbasho nkwu abu ela kaka okwakye-kwakye yi ongwan iYesu iKrestu Otsɛ mgbi eyi na li otsitsi. ");
INSERT INTO utr_vpl VALUES ("C11_10","076_1_10","1CO","1","10","10","Emi ongwunani mi ifu iKrestu, n le tɛkyɛ nu ema mi iyi mgbi Otsɛ iYesu iKrestu gbɛɛ ni ema gbela yi ewema. Ka gha yi ewema ba. Ɛwɛ otsɛɛtsɛ yi ungwɔ okyɔɔkyɔ mgbi ema no tso gbɛɛ ema dzɛ ondonyi. ");
INSERT INTO utr_vpl VALUES ("C11_11","076_1_11","1CO","1","11","11","Emi ongwunani mi ifu iKrestu, n fwo mbi inggisɛ angbeka mi udɛ iKlio gbɛɛ ema le kyɔ odzɛ oshiishi yi ewema. ");
INSERT INTO utr_vpl VALUES ("C11_12","076_1_12","1CO","1","12","12","N fwo di ema angbeka le gbɛɛ, <<Ani le kyɛdɔ iPol>> oka gbɛɛ, <<Ani le kyɛdɔ Apolo>> oka gbɛɛ, <<Ani le kyɛdɔ iKefa>> oka di gbɛɛ, <<Ani le kyɛdɔ iKrestu.>> ");
INSERT INTO utr_vpl VALUES ("C11_13","076_1_13","1CO","1","13","13","IKrestu ghaa? Li iPol ngwu a gbokwo mi ekwatsi gbɛɛ no kwikwu ikye ali ibwubwe mgbi emaa? Naadi li iyi mgbi iPol ngwi a kyɔ ema iBatisima? ");
INSERT INTO utr_vpl VALUES ("C11_14","076_1_14","1CO","1","14","14","N ta Imgbasho angba ikyekyɛ ani kyɔ inggisɛ onyi kpaa iBatisima ba, li iKrispu bɛyi iGayɔsu kyoon, ");
INSERT INTO utr_vpl VALUES ("C11_15","076_1_15","1CO","1","15","15","nghanɛ inggisɛ onyi ka yagba gbɛɛ di a kyɔ ema iBatisima mi iyi mgbi ani ba. ");
INSERT INTO utr_vpl VALUES ("C11_16","076_1_16","1CO","1","16","16","(N wɛ dafi li etɔ mgbi iStefana kyoon ta ngwi ani kyɔ ma iBatisima mani, n yagba wɛ ni ani kyɔ etɔ oka ba.) ");
INSERT INTO utr_vpl VALUES ("C11_17","076_1_17","1CO","1","17","17","Lubana iKrestu yama dɔ ani esɔ owa kyɔ iBatisima ba, kpaa li ogbɔ Esɔ Osuse yi ozoyeye mgbi inggisɛ owamyɛ ba. Ikye ni mfye mgbi iKrestu mi ekwatsi na no ka yɛɛ ayayi ba mani. ");
INSERT INTO utr_vpl VALUES ("C11_18","076_1_18","1CO","1","18","18","Lubana esɔ ogbɔɔgbɔ mgbi ekwatsi li dzɛ too mi adɔ mgbi ama nle dzili mani, nghaduu mbi eyi ama nwatɔ yɔ, esɔ na li mfye mgbi Imgbasho. ");
INSERT INTO utr_vpl VALUES ("C11_19","076_1_19","1CO","1","19","19","Afɛ gbɛɛ, <<N ka kyi mbelu ozoyeye mgbi inggisɛ ama okwiinɛ mani. Ama ntsɛwɛ gbɛɛ ama ye nyɛsɛ na n ka wo ma ɛndɛ.>> ");
INSERT INTO utr_vpl VALUES ("C11_20","076_1_20","1CO","1","20","20","Inggisɛ okwiinɛ ma kɔ? Inggisɛ okpayi ungwɔ ma kɔ? Ama okya mi odzɛ ongwi egbe nɛ ma kɔ? Imgbasho tso gbɛɛ ozoyeye mgbi ɛsɛ nɛ li ikwangha daabaa? ");
INSERT INTO utr_vpl VALUES ("C11_21","076_1_21","1CO","1","21","21","Lubana Imgbasho mi ozoyeye mgban nu inggisɛ difwi ongwu mi ozoyeye mgbi inggisɛ owamyɛ ba. Tatase ma yɔ, li mi esɔ ngwi eyi le gbɔ ngwi a le kwun di ikwangha ungwɔ nɛ ngwi Imgbasho nu ama nnoyɛyɛ mi ele watɔ aani. ");
INSERT INTO utr_vpl VALUES ("C11_22","076_1_22","1CO","1","22","22","Emi iJuda mina ambɛ okwulewo, kpaa emi iGriki mina ozoyeye. ");
INSERT INTO utr_vpl VALUES ("C11_23","076_1_23","1CO","1","23","23","Nghaduu eyi le gbeesɔ mgbi iKrestu ngwu a gbokwon nani: O li ikwutsɛ otsiishi mgbi emi iJuda di li ikwangha ungwɔ mbi Udzengye, ");
INSERT INTO utr_vpl VALUES ("C11_24","076_1_24","1CO","1","24","24","nghaduu mbi ama ngwu Imgbasho kwu ma ela mi idzidzɛ emi iJuda bɛyi iGriki yɔ, iKrestu li mfye bɛyi ozoyeye mgbi Imgbasho. ");
INSERT INTO utr_vpl VALUES ("C11_25","076_1_25","1CO","1","25","25","Lubana ikwangha mgbi Imgbasho ngha ozoyeye mgbi inggisɛ, ewo odzaatsi mgbi Imgbasho fyumfye ngha ɛnɛpɛ