﻿USE sofia;
DROP TABLE IF EXISTS sofia.uth_vpl;
CREATE TABLE uth_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES uth_vpl WRITE;
INSERT INTO uth_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Taku̱rda-o̱ u̱n baag-o Ye̱so Kiristi. Wu̱ u̱n rwu̱u̱n u̱n baag-o ko-Gwo̱mo Dawuda u̱n Ibrahi ne̱. ");
INSERT INTO uth_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Ibrahi matu̱ru̱ Ishaku, Ishaku matu̱ru̱ Yakubu, Yakubu matu̱ru̱ Yahuda u̱n se̱k-ye̱ ye̱ u̱n wu̱ ne̱. ");
INSERT INTO uth_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yahuda ne̱ wu̱ matu̱ru̱ Perez u̱n Zera (inu u̱n ye̱ Tamar). Perez matu̱ru̱ He̱zu̱ron, He̱zu̱ron matu̱ru̱ Aram, ");
INSERT INTO uth_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aram matu̱ru̱ Aminadab, Aminadab matu̱ru̱ Nashon, Nashon matu̱ru̱ Sarmon. ");
INSERT INTO uth_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Sarmon matu̱ru̱ Bo'az (inu u̱n wu̱ Rahab), Bo'az matu̱ru̱ Obe̱d (inu u̱n wu̱ Rutu), Obe̱d matu̱ru̱ Je̱sse̱. ");
INSERT INTO uth_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Je̱sse̱ matu̱ru̱ ko-Gwo̱mo Dawuda. Dawuda matu̱ru̱ Suremanu (inu u̱n wu̱ ne'a Uriya ro gage̱ wu̱). ");
INSERT INTO uth_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Suremanu matu̱ru̱ Re̱hebowam, Re̱hebowam matu̱ru̱ Abija, Abija matu̱ru̱ Asa, ");
INSERT INTO uth_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa matu̱ru̱ Je̱hoshapat, Je̱hoshapat matu̱ru̱ Je̱horam, Je̱horam matu̱ru̱ Uzziya. ");
INSERT INTO uth_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzziya matu̱ru̱ Jo̱tam, Jo̱tam matu̱ru̱ Ahaz, Ahaz matu̱ru̱ He̱ze̱kiya, ");
INSERT INTO uth_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","He̱ze̱kiya matu̱ru̱ Manase, Manase matu̱ru̱ Amon, Amon matu̱ru̱ Jo̱saya. ");
INSERT INTO uth_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Jo̱saya matu̱ru̱ Je̱ko̱niya u̱n hen-ne̱ ye̱ u̱n wu̱ ne̱, cin ba a u̱n ku̱u̱s ye̱ m-gu̱w so̱ u̱n dak-o̱ o-Babira. ");
INSERT INTO uth_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Bo̱ a wo̱tte̱ ye̱ o-Babira à, Je̱ko̱niya matu̱ru̱ Shetiyer, Shetiyer matu̱ru̱ Ze̱rubabe̱r, ");
INSERT INTO uth_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Ze̱rubabe̱r matu̱ru̱ Abihudu, Abihudu matu̱ru̱ E̱riyakim, E̱riyakim matu̱ru̱ Azo̱r. ");
INSERT INTO uth_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azo̱r matu̱ru̱ Zado̱k, Zado̱k matu̱ru̱ Akim, Akim matu̱ru̱ Eriwuda, ");
INSERT INTO uth_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eriwuda matu̱ru̱ E̱re̱yazar, E̱re̱yazar matu̱ru̱ Matana. Matana ne̱ wu̱ matu̱ru̱ Yakubu. ");
INSERT INTO uth_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Yakubu matu̱ru̱ Yusuhu campo̱ Meri, Meri inu Ye̱so wu̱ a m-ze̱e̱ Kiristi à. ");
INSERT INTO uth_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Cir-mo̱ u̱n zaman-o Ibrahi ha-mo̱ u̱n yo ma ko-Gwo̱mo Dawuda, zaman-u̱s o̱p-u̱s nass-se 14. Ze̱e̱n-mo̱ u̱n ko-Gwo̱mo Dawuda ha-mo̱ u̱n da-o̱ a ku̱u̱se̱ Isra-ne̱ m-gu̱w o-Babira à, zaman-u̱s o̱p-u̱s nass-se 14. Komo da-o̱ a ku̱u̱se̱ ye̱ à, ha-mo̱ u̱n da-o̱ a mate̱ Kiristi à, zaman-u̱s o̱p-u̱s nass-se 14 komo. ");
INSERT INTO uth_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Mat-o Ye̱so Kiristi o̱ ka. Da-o̱ Yusuhu ro u̱n hoob-o Meri inu Ye̱so ne̱ u̱t-ge à, cin ba a u̱n gegu̱ ye̱ u̱t-ge, a 'wo̱ssu̱ru̱ wu̱ ro̱ u̱r-uub ne̱ de u̱n Ku̱kt-o̱ Shir. ");
INSERT INTO uth_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Wan-ryap-de u̱n wu̱ Yusuhu kashi u̱n ne̱t-wu̱, wu̱ ro̱ u̱n nome̱ u̱n karamsa-o̱ u̱n Yahuda-ne̱ o-do̱ro̱tte̱. Komo wu̱ co̱n wu̱ 'ye Meri m-'e̱ n-me̱ u̱n hun-ne̱ á, wu̱ no̱mu̱ru̱ u̱s-barag wu̱ ho'ostu̱ wu̱ wukusse̱ ba u̱n nap-o̱ u̱n ne̱t. ");
INSERT INTO uth_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Amba wu̱ ro̱ u̱n ká barag-se, wan-to̱m-wu̱ Wan-Ko̱yan rwu̱u̱nu̱ru̱ wu̱ ru̱ru̱ wu̱ n-te̱ o-bo, wu̱ ze̱e̱ru̱ wu̱, “Yusuhu baag-o ko-Gwo̱mo Dawuda, taase o ho̱ge̱ gye̱r-o̱ u̱n de̱k u̱n Meri ne'a ru, remen ká uub-de, de u̱n Ku̱kt-o̱ Shir de. ");
INSERT INTO uth_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Wu̱a met wà, wo̱a e̱gu̱ wu̱ u̱r-jin Ye̱so. Wata wan-Gwu̱ remen wu̱ wu̱ he m-gu u̱n hun-ne̱ be-de u̱n ba'as-to̱ u̱n ye̱.” ");
INSERT INTO uth_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Ka rii-yo u̱n ko̱r kap remen a shooste̱ rii-yo Wan-Ko̱yan rwo̱re̱ à, cin n-ga ne̱ u̱n nu-o̱ u̱n wan-Rwo̱r u̱n Ma-to̱ ShirIshaya u̱nze, ");
INSERT INTO uth_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Wan-ne'a-wu̱ nape̱ campo̱ á wu̱a nom u̱r-uub, wu̱a met wà, wan-campo̱. Komo a e̱gu̱ wu̱ u̱r-jin Imanuwe̱r.” Ka jin-de Imanuwe̱r de ro̱, Shir ro̱ be-u̱r gaan u̱n na ne̱. ");
INSERT INTO uth_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Bo̱ Yusuhu zu̱tu̱te̱ ka rew-mo̱ à, wu̱ no̱mu̱ru̱ yo wan-to̱m-wu̱ Wan-Ko̱yan zee wu̱ à. Wu̱ gaaru̱ ne'a u̱n wu̱ Meri. ");
INSERT INTO uth_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Amba wu̱ nap wu̱ ne'a á, se̱ da-o̱ wu̱ messe̱ wà u̱n wu̱ à wan-campo̱. Yusuhu egu̱ wu̱ komo u̱r-jin Ye̱so. ");
INSERT INTO uth_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Da-o̱ ko-Gwo̱mo Here̱ ro u̱t-gwo̱mo à, a mate̱ Ye̱so u̱n bo̱-o̱ o-Be̱tarami, o̱ ro̱ n-me̱ u̱n dak-o̱ o-Judiya à. Bo̱ u̱n mat u̱n wu̱, hun-ne̱ ya-u̱s-nap rwu̱u̱nu̱ru̱ so̱ u̱r-ho̱ran ye̱ haanu̱ru̱ o-Urusharima. ");
INSERT INTO uth_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Ye̱ citu̱ru̱ hun-ne̱ o-cot, “¿Kene̱ ka wà-wu̱ a mate̱ à ro̱, wu̱ he m-warag ko-Gwo̱mo no̱ Yahuda-ne̱ à? Te̱ nak a makt wu̱ remen te̱ hyanag re̱ge̱n-yo u̱n wu̱ indu̱nte̱ u̱r-ho̱ran, komo te̱ u̱n haan, te̱ kwu̱kte̱ be-de u̱n wu̱, te̱ ye'et wu̱ m-se̱k.” ");
INSERT INTO uth_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Bo̱ ko-Gwo̱mo Here̱ ho̱gu̱te̱ a makt wà-wu̱ he m-re̱ u̱t-gwo̱mo à, hur-de u̱n wu̱ naasu̱ru̱ de̱e̱n, u̱nze wu̱ ken ko-Gwo̱mo wu̱a dek kwu̱u̱r-o̱ u̱n wu̱. Kaane̱ komo hur-de u̱n ko̱o̱b-ne̱ ye̱ u̱n wu̱ kap naase̱ de̱e̱n. ");
INSERT INTO uth_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Wu̱ karaksu̱ru̱ kap o̱ u̱n Gwo̱mo-ne̱ ye̱ u̱n ko̱n-se Shir u̱n yan-Yoos-de o-karamsa ne̱. Ka da-de wu̱ citu̱ru̱ ye̱ be-de yan-Rwo̱r u̱n Ma-to̱ Shir zee a met Kiristi à. ");
INSERT INTO uth_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ye̱ shasu̱ru̱ wu̱, “U̱n bo̱-o̱ o-Be̱tarami, n-me̱ u̱n dak-o̱ o-Judiya. Te̱ nak remen kaane̱ wan-Rwo̱r u̱n Ma-to̱ Shir ge̱ne̱ u̱s-hak de̱e̱n se arge̱ à, wan-Rwo̱r u̱n Ma-to̱ Shir ze̱e̱g: ");
INSERT INTO uth_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","“ ‘No̱ hun-ne̱ ye̱ o-Be̱tarami u̱n dak-o̱ o-Judiya, wan-gaan be-u̱r no̱ a warag caari-wu̱ u̱n ko-Gwo̱mo, Komo wu̱a do̱ru̱tte̱ hun-ne̱ re Isra-ne̱ bo̱ wa-u̱t-gu̱t ro̱ m-do̱ru̱tte̱ u̱n gu̱t-to̱ u̱n wu̱ à. Remen kaane̱ bo̱-o no̱ a warag caari-o̱ o-bo̱ u̱n dak-o̱ o-Judiya.’ ” ");
INSERT INTO uth_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Bo̱ Here̱ ho̱ge̱ kaane̱ à, wu̱ agnu̱ru̱ ká ya-u̱s-nap-ye̱, ye̱ rwu̱u̱ne̱ so̱ u̱r-ho̱ran à. Wu̱ citu̱ru̱ ye̱ wukusse̱, remen wu̱ nept hond hond da-o̱ ye̱ hyane̱ ká re̱ge̱n-yo à. ");
INSERT INTO uth_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Bo̱ ye̱ ru̱ru̱te̱ wu̱ à, wu̱ to̱mu̱ru̱ ye̱ ha-mo̱ o-Be̱tarami, wu̱ zee, “Ha no̱ cekrendu̱ me̱ ma-to̱ u̱n ká wà-wu̱ ce̱e̱n. U̱n ra-o̱ no̱ hyente̱ wu̱ à, no̱ mu̱u̱n, no̱ ru̱ru̱ me̱, remen me̱ u̱n ce re u̱m heet m-kwu̱ktu̱ wu̱.” ");
INSERT INTO uth_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Komo bo̱ ye̱ komte̱ ho̱ge̱ u̱n ma-to̱ u̱n ko-Gwo̱mo à, ye̱ argu̱ arag-mo̱ u̱n ye̱. U̱n co̱w-yo u̱n ye̱, ye̱ hyanu̱ru̱ ká re̱ge̱n-yo, yo ye̱ hyane̱ u̱r-ho̱ran à. Zak-o ho̱o̱ru̱ ye̱ de̱e̱n bo̱ ye̱ hyane̱ yo komo à. Ká re̱ge̱n-yo ro̱ u̱n co-o̱ u̱n ye̱, ye̱ ro̱ yo m-do̱re̱ har yo haaru̱ yo e̱su̱ru̱ o-Be̱tarami be-de wà ro à. ");
INSERT INTO uth_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Bo̱ ye̱ hyente̱ o-re̱ge̱n à, me̱n-to̱ u̱n ye̱ shiiru̱ o-zak de̱e̱n. ");
INSERT INTO uth_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Ka ya-u̱s-nap-ye̱ co̱wu̱ru̱ o-hur. Ye̱ hyanu̱ru̱ wà u̱n inu u̱n wu̱ ne̱ Meri, ye̱ kwu̱ktu̱ru̱ u̱n co-o̱ u̱n wu̱, ye̱ nomu̱ru̱ wu̱ u̱r-bo̱ngo̱n. Ka da-de, ye̱ rwu̱ntu̱ru̱ ba-to̱ u̱n ye̱, to̱ u̱n hwo̱r. Ye̱ ya'u̱ru̱ wu̱ o-zinariya, u̱n to̱ ken saw-to̱ m-shi'igin to̱ ne̱ to̱, a m-aag “u̱t-parakanse à” u̱n m-no̱w ne̱ mo̱ a m-aag “o-mur” ne̱ à. ");
INSERT INTO uth_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Ye̱ wargu̱ru̱ u̱n dak-o̱ u̱n ye̱ u̱n co̱w-o ho̱r-yo, remen Shir ka'aksu̱tu̱ ye̱ m-bo ye̱ jar ye̱ warag be-u̱r Here̱ á. ");
INSERT INTO uth_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Bo̱ ka ya-u̱s-nap-ye̱ aragsu̱te̱ à, wan-to̱m-wu̱ Wan-Ko̱yan ru̱ru̱ Yusuhu n-te̱ m-bo, wan-to̱m-wu̱ Shir ze̱e̱ru̱, “Ine̱, o dek ka wà-wu̱ u̱n inu u̱n wu̱ ne̱, no̱ som ha-mo̱ u̱n dak-o̱ o-Masar. No̱ she'et re̱e̱no̱, se̱ u̱m ze̱e̱g no̱ jo'on, remen karma-ne̱ Here̱ a hoob ka wà-wu̱, remen ye̱ hoot wu̱.” ");
INSERT INTO uth_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Yusuhu inu̱ru̱ wu̱ de̱ku̱ru̱ ká wà-wu̱ u̱n inu u̱n wu̱ ne̱ ká te̱t-mo̱, wu̱ neku̱ru̱ dak-o̱ o-Masar. ");
INSERT INTO uth_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Wu̱ she'etu̱ru̱ re̱e̱no̱ o-Masar se̱ da-o̱ Here̱ mare̱ à. To̱ ka u̱n kor remen a shoote̱ rii-yo Wan-Ko̱yan rwo̱re̱ à u̱n nu-o̱ u̱n wan-Rwo̱r u̱n Ma-to̱ Shir u̱nze, “E̱s-mo̱ o-Masar u̱m agne̱ wà re.” ");
INSERT INTO uth_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Bo̱ Yusuhu u̱n ya-den-o̱ u̱n wu̱ ne̱ aragsu̱te̱ so u̱n dak-o̱ o-Masar à, ko-Gwo̱mo Here̱ napu̱ru̱ u̱nze we̱e̱r-se ká ya-u̱s-nap-ye̱ nomo wu̱. Remen kaane̱ wu̱ swo̱o̱ru̱ u̱s-ryaab de̱e̱n. Wu̱ baksu̱ru̱ da-o̱ ká ya-u̱s-nap-ye̱ ru̱re̱ wu̱ ye̱ hyanag ka re̱ge̱n-yo à. Wu̱ to̱mu̱ru̱ karma-ne̱ ye̱ hoom yakar yan-campo̱-ne̱ kap ye̱ ro̱ o-Be̱tarami à u̱n riib-se u̱n o̱ ne̱, cir-mo̱ u̱n yan-hak-u̱s yoor ha-mo̱ n-dak, hond hond-mo̱ u̱n ká da-o̱ ya-u̱s-nap-ye̱ ru̱ru̱ wu̱ ma-to̱ u̱n ká wà-wu̱ à. ");
INSERT INTO uth_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","U̱n kaane̱ a shoose̱ rii-yo a rwo̱re̱ u̱n nu-o̱ u̱n ko-yan-Rwo̱r u̱n Ma-to̱ Shir Irmiya, u̱nze, ");
INSERT INTO uth_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“A ho̱gu̱te̱ u̱s-'wo̱n u̱n bo̱-o̱ o-Rama, 'wo̱n-se u̱n tu̱k-mo̱ u̱t-me̱n de̱e̱n. Rahira ro̱ u̱s-'wo̱n remen yakar-ye̱ u̱n wu̱, Wu̱ kwangu̱te̱ u̱t-kwe̱e̱mse̱ remen yakar-ye̱ u̱n wu̱ mereste̱.” ");
INSERT INTO uth_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Bo̱ Here̱ mereste̱ à, wan-to̱m-wu̱ Wan-Ko̱yan ru̱ru̱ Yusuhu n-te̱ m-bo o-Masar, ");
INSERT INTO uth_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","wan-to̱m-wu̱ Shir ze̱e̱ru̱ Yusuhu: “Ine̱, o dek ka wà-wu̱ u̱n inu u̱n wu̱ ne̱, o warag dak-o̱ o-Isra, remen n-ga ye̱ ro u̱n hoob-o̱ u̱n wà ye̱ hoot wu̱ à, ye̱ mereste̱.” ");
INSERT INTO uth_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Yusuhu inu̱ru̱, wu̱ deku̱ru̱ wà u̱n inu u̱n wu̱ ne̱, wu̱ wargu̱ru̱ dak-o̱ o-Isra. ");
INSERT INTO uth_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Amba bo̱ Yusuhu ho̱gu̱te̱ wà Here̱, wata, Arkirayo̱s wu̱ ro̱ u̱n gwo̱mo-to̱ o-Judiya dekste̱ kwu̱u̱r-o Tato u̱n wu̱ à, wu̱ ho̱gu̱ru̱ o-gye̱r wu̱ waragte̱ re̱e̱no̱. Amba bo̱ Shir ka'aktu̱ wu̱ u̱n m-bo à, u̱nze wu̱ jar wu̱ he o-Judiya á wu̱ hessu̱ru̱ ha-mo̱ o-Gariri. ");
INSERT INTO uth_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Wu̱ she'etu̱ru̱ u̱n bo̱-o̱ o-Nazaret, remen a shoosté̱ rii-yo a rwo̱re̱ u̱n nu-o̱ u̱n yan-Rwo̱r u̱n Ma-to̱ Shir à u̱nze, “A eeg wu̱ ko-ya-o-Nazaret.” ");
INSERT INTO uth_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","U̱n ká da-o̱ o̱, Yohana Wa-m-Yo'os u̱n hun-ne̱ m-ho̱, takne̱ se̱nge̱-mo̱ u̱n wu̱. Wu̱ ko̱'o̱te̱ Ma-to̱ Shir o-dákár o̱ u̱n dak-o̱ o-Judiya. ");
INSERT INTO uth_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Wu̱ ro̱ m-ze̱e̱, “Yagu̱ no̱ no̱m u̱r-ba'as, no̱ mu̱u̱n be-de Shir, remen Gwo̱mo-to̱ Shir nomsu̱nte̱ yow yow.” ");
INSERT INTO uth_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Yohana wu̱ Ishayawan-Rwo̱r u̱n Ma-to̱ Shir no̱me̱ ma-to̱ u̱n wu̱, u̱n hak-se n-jim. Ishaya ze̱e̱g, “Wu̱ ken wu̱ ro̱ u̱n eeg-se u̱n hun-ne̱ o-dákár ye̱ haan ye̱ ho̱ge̱ wu̱. Wu̱ ro̱ m-ze̱e̱, ‘Ja'asu̱ no̱ Yawe o-co̱w wu̱ haante̱. Ja'asu̱ no̱ wu̱ o-co̱w te̱te̱.’ ” ");
INSERT INTO uth_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Matuku-de Yohana co̱pe̱ à, u̱n can-se o-dorom a ce̱e̱ o̱. Wu̱ gak hap-yo o-ka u̱n byon-o u̱n wu̱. Rii-yo m-re̱ yo u̱n wu̱ ye̱ge̱-'e ye̱ u̱n wu̱u̱g-mo̱ u̱n so̱ ne̱. ");
INSERT INTO uth_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Hun-ne̱ haanu̱ru̱ rwu̱u̱n-mo̱ u̱n bo̱-o̱ o-Urusharima u̱n ye̱ o-Judiya ne̱ kap, komo u̱n kap riib-se u̱n Ro̱o̱g-o̱ o-Joda ne̱. Ye̱ u̱n haan ye̱ ho̱gu̱té̱ Yohana o-dákár. ");
INSERT INTO uth_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Ye̱ ro̱ m-rwo̱r u̱n ba'as-to̱ u̱n ye̱, komo Yohana ro̱ ye̱ m-yo'os m-ho̱ u̱n Ro̱o̱g-o̱ o-Joda. ");
INSERT INTO uth_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Amba bo̱ Yohana hyente̱ Parisa-ne̱ u̱n Saduki-ne̱ de̱e̱n ye̱ ro̱ m-haan remen wu̱ yo'ostú̱ ye̱ m-ho̱ à, wu̱ ze̱e̱ru̱ ye̱, “No̱ m-raab ne̱ u̱ntu̱n yakar-ye̱ u̱n herhyat! ¿Wa ru̱re̱ no̱ ne̱ no̱ som swo̱ u̱r-ko̱o̱b o̱ Shir ro̱a 'ye no̱ à? ");
INSERT INTO uth_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","No̱m no̱ rem-se a hette̱ m-nap u̱nze no̱ yagu̱te̱ no̱m u̱r-ba'as à. Ka da-de, no̱ haan remen u̱m yo'ostú̱ no̱ m-ho̱. ");
INSERT INTO uth_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Taase no̱ nom u̱s-se̱s u̱n ho̱o̱g-m no̱ u̱nze Ibrahi wu̱ ro̱ Tato no̱. To̱ka to̱a ruut no̱ á. Me̱ no̱ m-ru̱re̱, Shir a hoks nome̱ u̱n Ibrahi yakar u̱n ka ta'ar-to̱. (U̱rege̱ wu̱ co̱no̱g). ");
INSERT INTO uth_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Shir ru̱'u̱ste̱ nu-o̱ u̱r-yar o̱ u̱n piish u̱t-ma u̱n 'wu̱n-de o-'yo. 'Yo-yo mate̱ yakar-ye̱ u̱r-bon á, a kups yo a jorbe̱ o-ra. Kaane̱ Shir he 'ya u̱n hun-ne̱ u̱r-ko̱o̱b ye̱ yage̱ no̱m u̱n rii-yo depe̱ à.” ");
INSERT INTO uth_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Ka da-de Yohana ze̱e̱ru̱ hun-ne̱, “Me̱ de̱ m-ho̱ me̱ no̱ m-yo'os, remen a nept no̱ yagu̱te̱ no̱m u̱r-ba'as. Amba wu̱ argu̱ me̱ u̱t-go̱s à wu̱ ro̱o̱n u̱n jim u̱n de, ko̱ ka'ante̱-to̱ u̱n wu̱ me̱ bo'os u̱m us to̱ á. Wu̱ he no̱ m-yo'os u̱n Ku̱kt-o̱ Shir, o-ra ne̱ komo. ");
INSERT INTO uth_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Wu̱ ro̱ u̱n ko̱k-de u̱n wu̱ ne̱ de m-jer, wu̱a jer hyo-ye̱ u̱n wu̱. Komo wu̱ karakse̱ hyo-ye̱ u̱r-bon, wu̱ ru̱ n-me̱ u̱n byo-de u̱n wu̱, amba wu̱a tu̱ks ka nu-to̱ o-ra o̱ a hoks m-ryomos á.” ");
INSERT INTO uth_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","U̱n ka da-o̱ Ye̱so rwu̱u̱ne̱ e̱s-mo̱ o-Gariri, wu̱ haaru̱ u̱n Ro̱o̱g-o̱ o-Joda. Wu̱ u̱n ha remen Yohana yo'ostú̱ wu̱ m-ho̱. ");
INSERT INTO uth_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Yohana co̱nu̱ru̱ wu̱ m-we̱n. Wu̱ ze̱e̱ru̱ Ye̱so, “Me̱, wu̱ ro̱ o-hoob o yo'ostú̱ me̱ m-ho̱ à, ¿ya rwo̱'e̱ o hette̱ m-haan be u̱n de u̱m yo'ostu̱ wo̱? O jiishtu̱ me̱. Wo̱ depe̱ o yo'os me̱ m-ho̱.” ");
INSERT INTO uth_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Amba Ye̱so shasu̱ru̱ wu̱, “U̱n ka da-o̱ wo̱ depe̱ o yo'os me̱ m-ho̱. Kaane̱ ro̱ u̱r-bon ne̱ remen a shooste̱ myet o̱ u̱n rii-yo Shir co̱ne̱ à.” Bo̱ Yohana ho̱gu̱te̱ kaane̱ à wu̱ yo'osu̱ru̱ Ye̱so m-ho̱. ");
INSERT INTO uth_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Remen kaane̱ Yohana yo'osu̱ru̱ Ye̱so m-ho̱. Bo̱ Ye̱so rwu̱nte̱ m-ho̱ à, da-o gaan, To̱n-o tikshiru̱. Ye̱so hyanu̱ru̱ Ku̱kt-o̱ Shir ro̱ m-kergu̱ne̱ u̱n sha-mo̱ o-gorop, har o̱ ciru̱ru̱ n-to̱n u̱n wu̱. ");
INSERT INTO uth_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ka da-de Shir te̱pru̱nu̱ru̱ zee-mo̱ n-To̱n o-shir, “Wu̱ ka wu̱ ro̱ Wà re, wu̱ me̱ m-co̱n à. Wu̱ me̱ m-ho̱ge̱ re̱re̱m-mo̱ u̱n wu̱ de̱e̱n à.” ");
INSERT INTO uth_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Ka da-de, Ku̱kt-o̱ Shir wootu̱ru̱ Ye̱so n-me̱ o-dákár remen ko-Gwo̱mo-wu̱ u̱n ya-u̱t-ko̱t megertú̱ wu̱. ");
INSERT INTO uth_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Ye̱so no̱mo̱g o-swo̱o̱t u̱t-ho̱ kwo̱o̱z-u̱t yoor 40 m-te̱t m-ho̱w ne̱. Remen kaane̱, me̱r bo̱pu̱ru̱ wu̱ de̱e̱n. ");
INSERT INTO uth_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Ko-Gwo̱mo-wu̱ u̱n ya-u̱t-ko̱t haanu̱ru̱, wu̱ megru̱ru̱ Ye̱so. Wu̱ ze̱e̱ru̱ Ye̱so, “U̱rege̱ wo̱ Wà-wu̱ Shir wu̱, rwo̱ ka ta'ar-to̱ barme̱ rii-yo m-re̱!” ");
INSERT INTO uth_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Ye̱so shasu̱ru̱, “Gense̱ to̱ ro̱ u̱n taku̱rda-o̱ Shir u̱nze, “ ‘U̱n rii-yo m-re̱ o̱ cot hun-ne̱ hette̱ kum m-ho̱o̱g á, se̱ de̱ gom-to̱ rwu̱u̱ne̱ u̱n nu-o Shir à kap.’ ” ");
INSERT INTO uth_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Ko-Gwo̱mo-wu̱ u̱n ya-u̱t-ko̱t heete̱ Ye̱so o-Urusharima bo̱-o̱ so̱-o̱. Wu̱ detu̱ru̱ Ye̱so re̱e̱no̱ n-to̱n u̱n Pyo-o̱ Shir be-de jiishe̱ m-pipir à. ");
INSERT INTO uth_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Ka da-de ko-Gwo̱mo-wu̱ u̱n ya-u̱t-ko̱t ze̱e̱ru̱ Ye̱so, “U̱rege̱ wo̱ Wà-wu̱ Shir wu̱, hukse̱, o he̱be̱ n-dak. Gense̱ to̱ ro̱ u̱n taku̱rda-o̱ Shir, u̱nze, “ ‘Shir a ru̱ yan-to̱m-ye̱ u̱n wu̱ ye̱ 'er wo̱. Ye̱a go̱ks wo̱ u̱n kom-to̱ u̱n ye̱, taase o he̱be̱ u̱t-ta'ar o ho̱ge̱ m-hoog.’ ” ");
INSERT INTO uth_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Ye̱so ze̱e̱ru̱ wu̱, “Gense̱ to̱ ro̱ u̱n taku̱rda-o̱ Shir, u̱nze, ‘Wo̱ meger Yawe Shir ru á!’ ” ");
INSERT INTO uth_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Ko-Gwo̱mo-wu̱ u̱n ya-u̱t-ko̱t dooru̱ Ye̱so m-heet n-to̱n u̱n o̱ ken haag-o̱, o̱ m-pipir de̱e̱n. Wu̱ kutu̱ru̱ Ye̱so dak-to̱ u̱n ho̱no o-dak pitip u̱n gwo̱mo-to̱ u̱n to̱ ne̱, u̱n se̱ps-mo̱ u̱n to̱ ne̱. ");
INSERT INTO uth_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Wu̱ dooru̱ Ye̱so m-ze̱e̱, “Kap o̱ u̱n to̱ ka man hoks wo̱ to̱ m-ya'as, o nom gwo̱mo-to̱ u̱n to̱, u̱rege̱ wo̱a kwu̱ktu̱tu̱ me̱ o 'ye me̱, m-se̱k.” ");
INSERT INTO uth_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Ye̱so ze̱e̱ru̱ wu̱, “Arag kàne̱ ko-Gwo̱mo-wu̱ u̱n ya-u̱t-ko̱t o̱! Remen gense̱ to̱ ro̱ u̱n taku̱rda-o̱ Shir u̱nze, “ ‘Nome̱ Yawe Shir ru m-gu̱w, wu̱ wu̱ cot o he m-kwu̱kte̱.’ ” ");
INSERT INTO uth_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Ka da-de, ko-Gwo̱mo-wu̱ u̱n ya-u̱t-ko̱t argu̱ru̱, wu̱ yage̱ Ye̱so. Yan-to̱m-ye̱ Shir haanu̱ru̱ ye̱ nomoru̱ Ye̱so m-se̱nge̱. ");
INSERT INTO uth_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Da-o̱ Ye̱so ho̱ge̱ karma-ne̱ ka'ag Yohana Wa-m-Yo'os u̱n hun-ne̱ m-ho̱ à, Ye̱so inu̱ru̱ wu̱ wargu̱ru̱ dak-o̱ o-Gariri. ");
INSERT INTO uth_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Se̱ da-o̱ wu̱ ha bo̱-o̱ o-Nazaret à, ka da-de ne̱, wu̱ yagu̱ru̱ o-Nazaret wu̱ haaru̱ bo̱-o̱ o-Kapanahum o̱ ro̱ re̱e̱no̱ n-riib o̱ u̱n mar-o̱ Gariri ma-de u̱n dak-o̱ o-Zeburun, o-Napari ne̱. ");
INSERT INTO uth_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Ye̱so u̱n no̱m kaane̱ remen a shoosté̱ rii-yo Ishayawan-Rwo̱r rwo̱re̱ à, o-da de̱e̱n o̱ arge̱ à u̱nze, ");
INSERT INTO uth_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Me̱n to̱m ne̱ u̱m ru̱ru̱ no̱ hun-ne̱ ye̱ u̱n dak-o̱ o-Zeburun u̱n dak-o̱ o-Napari ne̱. No̱ ye̱ ro̱ yow yow u̱n mar-o̱ Gariri ne̱ à, u̱n pes-to̱ u̱n Ro̱o̱g-o̱ o-Joda ne̱, komo u̱n hun-ne̱ ne̱ ye̱ ro̱ u̱n dak-o̱ o-Gariri à, be-de ye̱ ro̱ Yahuda-ne̱ á ro̱ u̱r-she'et à. ");
INSERT INTO uth_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Ka hun-ne̱ ye̱ ro̱ u̱r-she'et n-me̱ o-comb à, ye̱ hyen caari-mo̱ m-cecar. Cecar-mo̱ Shir, u̱ntu̱n bo̱ ho̱-u̱r ro̱ m-rwu̱u̱n n-sot à, Mo̱a rwu̱u̱n be-de u̱n ka ye̱ ku̱kt-to̱ u̱n ye̱ merse̱ à.” ");
INSERT INTO uth_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Cin ka da-o̱ Ye̱so cire̱ ko̱'o̱t-o̱ Ma-to̱ Shir, wu̱ ro̱ m-ze̱e̱, “Yagu̱ no̱ no̱m u̱r-ba'as, no̱ mu̱u̱n be-de Shir, remen da-o̱ Shir he u̱t-gwo̱mo à nomsu̱nte̱ yow yow.” ");
INSERT INTO uth_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Ye̱so ro̱ m-arag n-riib o̱ u̱n Mar-o̱ o-Gariri. Wu̱ hyanu̱ru̱ ye̱ ken hen-ne̱ ye̱ ne̱n yoor, Simo̱n wu̱ a m-ze̱e̱ Bitrus à, u̱n hen u̱n wu̱ ne̱ wu̱ a m-ze̱e̱ Andarawus à. Ye̱ ro̱ m-jorbe̱ o-yo n-me̱ o-mar, remen ye̱ ya-m-ship u̱n jan-ye̱, u̱n baab-to̱ u̱n jan ne̱. ");
INSERT INTO uth_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Ye̱so ze̱e̱ru̱ ye̱, “Do̱nd no̱ me̱, man muut no̱ yan-neke̱-m re. Man yoosu̱ no̱ bo̱ no̱ he haante̱ u̱n hun-ne̱ be u̱n de à.” ");
INSERT INTO uth_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Ba u̱n naas o-da, ye̱ yagu̱ru̱ saw-to̱ u̱n ye̱ to̱ ye̱ rotte̱ u̱n ship u̱n jan à, ye̱ do̱ru̱ru̱ Ye̱so. ");
INSERT INTO uth_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Bo̱ Ye̱so aragte̱ u̱n co à, wu̱ hyanu̱ru̱ ye̱ ken hen-ne̱ ye̱ ne̱n yoor komo. Ye̱ ro̱ Yakubu u̱n hen u̱n wu̱ ne̱ Yohana yakar Ze̱be̱di. Ye̱ ro̱ u̱n ja'as u̱n yo-o̱ u̱n ship u̱n jan o-hat u̱n tato-o̱ u̱n ye̱ ne̱, ye̱ shipt jan. Ye̱so aagu̱ru̱ ye̱. ");
INSERT INTO uth_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Da-o gaan, ye̱ yage̱ o-hat kap u̱n tato u̱n ye̱ ne̱, ye̱ do̱ru̱ru̱ Ye̱so. ");
INSERT INTO uth_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Ye̱so bo̱pu̱ m-pa'ag myet dak-o̱ o-Gariri, wu̱ ro̱ u̱r-yoos u̱n kuke̱-to̱ u̱n yoos u̱n Ma-to̱ Shir. Wu̱ ro̱ m-ko̱'o̱t Ma-to̱ m-Re̱re̱m to̱ u̱n gwo̱mo-to̱ Shir. Komo wu̱ taaste̱ go̱m-se u̱n hun-ne̱ u̱n ya-ba-m-gu̱gaaz mo̱ o-wu̱r ne̱. ");
INSERT INTO uth_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Remen kaane̱, ma-to̱ u̱n wu̱ wo̱o̱ru̱ ko̱ o̱ ke dak-o̱ o-Siriya da-o gaan. Ye̱ ma'asu̱ru̱ wu̱ m-hante̱ u̱n ya-u̱s-go̱m go̱-u̱s-go̱, u̱n yan-swo̱ u̱r-ko̱o̱b ne̱, u̱n ye̱ ya-u̱t-ko̱t da'e̱ u̱t-hi ne̱ à u̱n ya-o-tattara ne̱, u̱n ryam-ne̱ komo. Wu̱ taasu̱ go̱m-se u̱n ye̱ myet. ");
INSERT INTO uth_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Hun-ne̱ u̱t-mo̱o̱r ne̱ do̱ru̱ru̱ wu̱ e̱s-mo̱ o-Gariri. Ye̱ ken ye̱ rwu̱u̱n-mo̱ o-Urusharima u̱n dak-o̱ o-Judiya ne̱. Ye̱ ken ye̱ rwu̱u̱n-mo̱ u̱n be-de ye̱ m-aag, Bo̱-u̱t o̱p à, har u̱n e̱s-mo̱ u̱n pesto-de u̱n so̱ u̱n ho̱ran-de u̱n Ro̱o̱g-o̱ o-Joda. ");
INSERT INTO uth_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Bo̱ Ye̱so hyente̱ hun-ne̱ mo̱ro̱gsu̱te̱ de̱e̱n à, wu̱ daaru̱ n-to̱n u̱r-haag, wu̱ she'etu̱ru̱. Bo̱ wu̱ she'ette̱ à, yan-neke̱-mo̱ u̱n wu̱ haaru̱ be-de u̱n wu̱. ");
INSERT INTO uth_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Wu̱ ciru̱ ye̱ m-yoose̱ u̱n yo ka: ");
INSERT INTO uth_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Ya-o-zak-ye̱, ka ye̱ nape̱ u̱nze ko̱o̱b-ne̱ ye̱ ro̱, ye̱ ro̱tte̱ Shir á, remen go̱n ye̱ ro̱ be-de u̱n gwo̱mo-to̱ u̱n wu̱. ");
INSERT INTO uth_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Ya-o-zak-ye̱, ka ye̱ ro̱ u̱n tu̱k-mo̱ u̱t-me̱n m-mo̱ka à, remen Shir a gwu̱'u̱rsu̱ ye̱ u̱t-me̱n. ");
INSERT INTO uth_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Ya-o-zak-ye̱, ka ye̱ ru̱sse̱ u̱r-hi gwe̱rgwe̱r à, remen Shir a bo̱psu̱ ye̱ rii-yo u̱n ho̱no o-dak kap. ");
INSERT INTO uth_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Ya-o-zak-ye̱, ka ye̱ co̱ne̱ m-nom rii-yo Shir co̱ne̱ à, remen Shir a coks ye̱. ");
INSERT INTO uth_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Ya-o-zak-ye̱, ka ye̱ m-ho̱ge̱ 'wo̱n-u̱r o̱r u̱n ye̱ ne̱ à, remen Shir a ho̱ge̱ 'wo̱n-de u̱n ye̱ u̱n cen ye̱. ");
INSERT INTO uth_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Ya-o-zak-ye̱, ka ye̱ ro̱ u̱n me̱n-u̱t pus-to̱ ne̱ à, remen ye̱a hyen Shir. ");
INSERT INTO uth_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Ya-o-zak-ye̱, ka ye̱ ro̱ m-co̱n hun-ne̱ she'et ba u̱t-ween à, remen Shir a dek ye̱ yakar-ye̱ u̱n wu̱.” ");
INSERT INTO uth_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Ya-o-zak-ye̱, ka ye̱ hun-ne̱ re̱e̱se̱ u̱r-ko̱o̱b à, remen ye̱ ro̱ m-no̱m u̱n yo depe̱ à, Shir a ru̱ ye̱ o-zak, remen go̱n ye̱ Shir co̱ne̱ u̱n gwo̱mo-to̱ u̱n wu̱. ");
INSERT INTO uth_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Ya-o-zak-ye̱ no̱, da-o̱ hun-ne̱ pyapu̱ no̱ à, ye̱ re̱e̱su̱ no̱ u̱r-ko̱o̱b, komo ye̱ nomo no̱ me̱n-u̱t jaas-to̱ go̱-u̱s-go̱ rem re. ");
INSERT INTO uth_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Nom no̱ o-zak remen kaane̱, remen 'yons-u̱r go̱s-de ro̱ no̱ u̱r-'er n-To̱n shir. Kaane̱ hun-ne̱ ye̱ u̱n ye̱ ya-n-ga-ye̱ nome̱ yan-Rwo̱r u̱n Ma-to̱ Shir n-ga, ye̱ ba'u̱ no̱ à. ");
INSERT INTO uth_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Komo Ye̱so ze̱e̱ru̱, “Ya no̱ ro̱ u̱ntu̱ m-po̱r be-de u̱n hun-ne̱ ye̱ u̱n ho̱no o-dak. Amba u̱rege̱ re̱re̱m-mo̱ m-po̱r taag, ¿re a he m-nom a muute̱ mo̱ m-re̱re̱m ne̱? Mo̱ waragte̱ hwaa, se̱ a ukse̱ mo̱, a yawag u̱s-na.” ");
INSERT INTO uth_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Ye̱so ze̱e̱ru̱, “Ya no̱ ro̱ u̱ntu̱ m-cecar be-de u̱n hun-ne̱ ye̱ u̱n ho̱no o-dak. Ai, bo̱-o̱ a ma'e̱ n-to̱n u̱r-haag à a hoks o̱ m-wuke̱ á. ");
INSERT INTO uth_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Kaane̱ o̱ komo a m-do̱ u̱r-pitirra a ho̱k de o-shaar á, se̱ de̱ a sek de n-to̱n u̱r-de̱e̱g remen de ye'et hun-ne̱ ye̱ o-hur m-cecar. ");
INSERT INTO uth_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Kaane̱ komo, she'et no̱ cas remen hun-ne̱ hyenet rii-yo no̱ m-no̱m à, ye̱a bu̱m Tato no̱ wu̱ n-To̱n shir.” ");
INSERT INTO uth_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Ye̱so ze̱e̱ru̱, “Taase no̱ hyen no̱ zee me̱n haan u̱m soksté̱ karamsa-o Mosa u̱n yoos-de u̱n yan-Rwo̱r u̱n Ma-to̱ Shir ne̱. Me̱ haan remen u̱m soksté̱ to̱ á, se̱ de̱ remen u̱m shoosté̱ to̱. ");
INSERT INTO uth_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Nip-o̱ me̱ no̱ m-ru̱re̱, u̱rege̱ de̱ o-To̱n o-dak ne̱ ro̱ ko̱n, yatt ko̱ o-ke̱e̱r ko̱ ya-o-dakka yo he m-sokse̱ n-me̱ u̱n yoos-de o-karamsa á. Se̱ a shooste̱ ko̱yan kap. ");
INSERT INTO uth_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Remen kaane̱ bo̱ u̱n wu̱ jesse̱ ko̱ o-gaan be-de u̱n ka karamsa-u̱t re̱k-to̱ to̱ à, wu̱ yoose̱ komo hun-ne̱ ye̱ jetem to̱. Shir a zee hwaa ka ne̱t-wu̱ ro̱ be-de u̱n gwo̱mo-to̱ Shir. Amba kap wu̱ do̱re̱ to̱ à har wu̱ yoose̱ ye̱ ken ye̱, a deet wu̱ u̱r-bektu̱be̱n n-me̱ u̱n gwo̱mo-to̱ Shir. ");
INSERT INTO uth_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","“Me̱ no̱ m-ru̱re̱, u̱rege̱ kashi u̱n she'et-u̱r no̱ de jiish de u̱n yan-Yoos-de o-karamsa u̱n Parisa-ne̱ á, no̱a cu̱w n-me̱ u̱n gwo̱mo-to̱ Shir á ko̱ hiin. ");
INSERT INTO uth_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“No̱ ho̱gu̱ssu̱te̱ a ru̱ssu̱te̱ hun-ne̱ na ye̱ n-ga, u̱nze, ‘Wo̱ jar o ho ne̱t á,’ gaan-o zee ‘bo̱ u̱n wu̱ ho̱ ne̱t à, a he'et wu̱ be-de u̱n piishi wu̱ u̱t-ma.’ ");
INSERT INTO uth_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Amba me̱ no̱ m-ru̱re̱, wu̱ ro̱ u̱s-ryaab u̱n o̱r u̱n wu̱ ne̱ à, Shir a nom u̱s-ryaab u̱n wu̱ ne̱ komo a piishe̱ wu̱ u̱t-ma. Komo bo̱ u̱n wu̱ no̱me̱ u̱s-ryaab u̱n o̱r u̱n wu̱ ne̱ à, har wu̱ ce'e̱ wu̱ jin-u̱r yo̱-de a he'et wu̱ be-de m-piish u̱t-ma to̱ se̱k-ye̱ u̱n Shir. Komo wo̱ kute̱ o̱r ru u̱t-yage̱ har o zee wu̱ ko-raag! To̱, o bu̱pse̱ o̱ ka co̱w-yo u̱n den-o̱ o-ra!” ");
INSERT INTO uth_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Ye̱so haaru̱ co m-ze̱e̱, “U̱rege̱ wo̱ u̱n ma-to̱ m-hwo̱bbe̱ m-yar n-te̱ u̱n hana-o̱ u̱r-seke̱ o̱ Shir, o baksu̱ru̱ u̱nze wu̱ ken wu̱ ze̱e̱g o nomote̱ wu̱ u̱r-yo̱-de, ");
INSERT INTO uth_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","Wo̱ hwo̱be̱ yar-m ru o-hana á. U̱r-takan neke̱ be-de u̱n o̱r ru no̱ hongse̱ u̱n wu̱ ne̱. Ka da-de o haan o he̱'e̱dbe̱ yar-m ru be-de Shir.” ");
INSERT INTO uth_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Ye̱so ze̱e̱ru̱ komo, “U̱rege̱ wu̱ ken wu̱ ze̱e̱g o nomote̱ wu̱ u̱r-yo̱-de har wu̱ ro̱ wo̱ u̱n ma-to̱ m-heet be-de u̱n m-piish u̱t-ma, no̱m ho̱r-m-ho̱r o hongse̱ u̱n wu̱ ne̱. No̱m bo̱ o he m-no̱m à no̱ e̱ss u̱t-ma u̱n wu̱ ne̱ cin ba no̱ u̱n wo̱o̱ be-de u̱n m-piish u̱t-ma. U̱nya kaane̱ á, wu̱a mo̱ssu̱ wo̱ u̱n wan-piish u̱t-ma ne̱. Komo ko-ya-m-piish u̱t-ma wu̱a mo̱ssu̱ wo̱ u̱n yan-to̱m-ye̱ u̱n wu̱ ne̱ ye̱ ke wo̱. ");
INSERT INTO uth_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Nip-o̱ me̱ wo̱ m-ru̱re̱, u̱rege̱ wu̱ no̱mo̱g kaane̱, rii-yo a rwu̱ntu̱tu̱ wo̱ kane̱, se̱ o to̱pk kap bo̱ u̱n rii-yo a wo̱ m-do̱re̱ à.” ");
INSERT INTO uth_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Ka da-de Ye̱so ze̱e̱ru̱, “No̱ ho̱gu̱ssu̱te̱ ka karamsa-o̱, ‘Taase o hoob ne'a-wu̱ u̱n ne̱t á.’ ");
INSERT INTO uth_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Amba me̱ no̱ m-ru̱re̱, taase ma ne̱t gu̱t ne'a-wu̱ ro̱ ne'a u̱n wu̱ á komo wu̱ cu̱n m-rewe̱ u̱n wu̱ ne̱ n-me̱ u̱n hur-de u̱n wu̱. U̱rege̱ ne̱t no̱mo̱g káane̱, wu̱ no̱mo̱g o-ás o̱ ka u̱n wu̱ ne̱ n-me̱ u̱n hur-de u̱n wu̱. ");
INSERT INTO uth_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","U̱rege̱ yish u̱n du ro̱ wo̱ m-rwo̱ u̱r-ba'as, hu̱s de o jore̱. A jiish wo̱ o taage̱ yish-u̱r gaan be-de u̱n do̱k-to̱ u̱n wu̱r-o ru o̱tte̱ a jorbe̱ wu̱r-o ru u̱r-bir n-me̱ den-o̱ o-ra à. ");
INSERT INTO uth_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Komo ka ro̱, u̱rege̱ kom-o ru o-gaan ro̱ wo̱ m-rwo̱ u̱r-ba'as, kups o̱ o jore̱. A nom u̱r-bon wo̱ hokse̱ jore̱ u̱n yo ken rii-yo u̱n ho̱o̱g-m ru o gwu̱'u̱rsu̱te̱ Shir u̱r-hur, o̱tte̱ a jorbe̱ wu̱r-o ru u̱r-bir n-me̱ u̱n den-o̱ o-ra à.” ");
INSERT INTO uth_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Ye̱so ze̱e̱ru̱ komo, “Wu̱ ken wu̱ ze̱e̱g yo ka u̱nze ‘U̱rege̱ wu̱ ken ne̱t-wu̱ ho'oste̱ ne'a u̱n wu̱, se̱ wu̱ ya'astu̱ wu̱ taku̱rda-o̱ u̱n caas u̱t-ge.’ ");
INSERT INTO uth_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Amba me̱ no̱ m-ru̱re̱, ne̱t a hoks ho'os u̱n ne'a u̱n wu̱ u̱rege̱ ka ne'a-wu̱ rewete̱ u̱n wu̱ ken campo̱ wu̱ ne̱. Taase ne̱t ho'os ne'a u̱n wu̱ remen yo ken rii-yo u̱n ho̱n. U̱rege̱ wu̱ ho'oste̱ ne'a u̱n wu̱ remen yo ken rii-yo u̱n ho̱n, wu̱ rwo̱'o̱g wu̱ o̱ ka no̱m o-ás u̱rege̱ ka ne'a-wu̱ gaag wu̱ ken campo̱ wu̱. Komo u̱rege̱ campo̱ gaag ne'a-wu̱ campo̱ u̱n wu̱ ho'ose̱ à, Shir de̱k o̱ ka ka ne̱t-wu̱ no̱mo̱g o-ás.” ");
INSERT INTO uth_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Ye̱so haaru̱ co m-ze̱e̱, “No̱ ho̱gu̱ssu̱te̱ o̱ ken karamsa-o̱, o̱ ya-n-ga-ye̱ na go̱kse̱ à u̱s-hak de̱e̱n se arge̱ à. O̱ ze̱e̱g, ‘Taase no̱ taage̱ m-shoos u̱n rii-yo no̱ su̱rte̱ nu à. Yo depe̱ à shoos rii-yo o zee wo̱a nome̱ Yawe à.’ ");
INSERT INTO uth_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Amba rii-yo me̱ no̱ m-ru̱re̱ à yo ro̱, taase no̱ to̱nd á po̱r po̱r. Taase no̱ to̱nd u̱n jin-de u̱n To̱n-o̱ shir á, remen káne̱ Shir ro̱ u̱n gwo̱mo-to̱ u̱n wu̱. ");
INSERT INTO uth_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Taase komo no̱ to̱nd o-dak, remen o̱ ro̱ u̱n ku̱s-o̱ u̱n na-se u̱n wu̱. Taase komo no̱ to̱nd u̱n jin-de o-Urusharima, remen o-Urusharima bo̱-o caari-o̱ o̱ u̱n ko-Gwo̱mo Shir. ");
INSERT INTO uth_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Taase komo o to̱nd u̱n hi u̱n du á, remen wo̱a hoks m-muut u̱n ko̱ can-o o-gaan yo wakte̱ o-pus yo ko̱ o-rim yo á. ");
INSERT INTO uth_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","U̱rege̱ o co̱no̱g m-ze̱e̱ ‘E̱e̱’ zee ‘E̱e̱,’ u̱rege̱ ‘Ay’ o̱, zee ‘Ay.’ Rii-yo pase̱ kaane̱ à, yo̱-yo yo. Yo rwu̱u̱ne̱ u̱n ko-Gwo̱mo-wu̱ u̱n ya-u̱t-ko̱t à.” ");
INSERT INTO uth_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Ka da-de Ye̱so ze̱e̱ru̱, “No̱ ho̱gu̱ssu̱te̱ de̱ ka karamsa-o̱, ‘U̱rege̱ ne̱t ho̱gu̱ssu̱te̱ wu̱ ken wu̱ m-hoog u̱r-yish ko̱ o-yin, se̱ a nome̱ wu̱ m-hoog u̱n yish-de u̱n wu̱ ko̱ u̱n yin-yo u̱n wu̱.’ ");
INSERT INTO uth_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Amba me̱ no̱ m-ru̱re̱, taase o muute̱ wu̱ ken wu̱ o-yo̱ yo bo̱ wu̱ nomo wo̱ à. M-sha u̱rege̱ wu̱ ken wu̱ hu̱tu̱ wo̱ o-raag, u̱r-geeg de u̱r-re̱, wo̱ mu̱se̱ á wakse̱ wu̱ o̱ kuse̱ à wu̱ bu̱se̱. ");
INSERT INTO uth_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","A nom wu̱ ken wu̱ ze̱e̱g o nomote̱ wu̱ u̱r-yo̱-de. Wu̱ ze̱e̱ru̱ ko-yan-m-piish u̱t-ma wu̱ rumse̱ wu̱ matuku u̱n du, u̱rege̱ ka ne̱t-wu̱ no̱mo̱g kaane̱, ya'as wu̱ myet u̱n co̱p-o ru ne̱. ");
INSERT INTO uth_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","U̱rege̱ wu̱ ken ko-karma-wu̱ rwo̱'o̱g wo̱ u̱r-hew me̱r-u̱r gaan, u̱t-saw ne̱ neke̱ o dek to̱ har me̱r-u̱t yoor. ");
INSERT INTO uth_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Wu̱ ko̱nu̱ wo̱ gwu̱ à, gu wu̱. Wu̱ haane̱ komo hoob-o̱ u̱n mo̱o̱g be u̱n du à, wo̱ we̱n wu̱ á.” ");
INSERT INTO uth_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Ye̱so haaru̱ co m-ze̱e̱, “No̱ ho̱gu̱ssu̱te̱ o-karamsa u̱nze, ‘Co̱n ne̱t-wu̱ co̱nu̱ wo̱ à,’ o yage̱ wu̱ yagu̱ wo̱ à. ");
INSERT INTO uth_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Amba me̱ no̱ m-ru̱re̱, co̱n no̱ yan-yage̱-u̱t no̱! Ye̱ ro̱ no̱ u̱n re̱e̱se̱ u̱r-ko̱o̱b à, no̱ ko̱n Shir 'ye ye̱ o-kwu̱m! ");
INSERT INTO uth_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","No̱m-mo̱ u̱n kaane̱, a hante̱ no̱ waktu̱te̱ yakar-ye̱ u̱n Tato no̱ wu̱ n-To̱n shir. Wu̱ ro̱ m-rwo̱ ho̱-de rwu̱u̱n m-cecas ne̱ n-te̱ u̱n ye̱ ro̱ kashi u̱n hun-ne̱ u̱n ye̱ ro̱ rii-ye̱ o-saa ne̱ à. Komo wu̱ to̱mo̱n kem n-te̱ u̱n ye̱ ro̱ kashi u̱n hun-ne̱ à, u̱n ye̱ ro̱ rii-ye̱ o-saa ne̱ à. ");
INSERT INTO uth_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","U̱rege̱ ye̱ co̱nu̱ no̱ à, ye̱ no̱ m-co̱n cot, no̱a kum u̱r-'yons o̱ ka á. Ko̱ yan-go̱ks u̱n tar, u̱n yan-me̱n-u̱t jaas-to̱ ne̱, ye̱ ro̱ m-co̱n u̱n ye̱ co̱ne̱ ye̱ à. ");
INSERT INTO uth_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","U̱rege̱ nay-ne̱ no̱ cot no̱ m-gas, ¿ya no̱ no̱me̱ o̱ ka yo no̱ jiishte̱ ye̱ ken ye̱? Ay, ko̱ ye̱ ro̱ Yahuda-ne̱ á, ye̱ ro̱ m-co̱n u̱n nay-ne̱ ye̱ u̱n ye̱. ");
INSERT INTO uth_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Remen kaane̱ se̱ no̱ ma'as ba u̱n be-de u̱t-re̱e̱b bo̱ Tato no̱ wu̱ n-To̱n shir ro̱ ba u̱n be-de u̱t-re̱e̱b à.” ");
INSERT INTO uth_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Ye̱so haaru̱ co u̱n yoose̱ u̱n yan-neke̱-mo̱ u̱n wu̱. Wu̱ ze̱e̱ru̱, “Da-o̱ no̱ nome̱ rii-yo u̱r-bon taase no̱ nom u̱n yish-ye̱ u̱n hun-ne̱ remen ye̱ bu̱mu̱t no̱. U̱rege̱ no̱ no̱mo̱g rii-yo u̱r-bon remen hun-ne̱ bu̱mu̱t no̱, no̱a kum u̱r-'yons be-u̱r Tato no̱ wu̱ ro̱ n-To̱n shir á. ");
INSERT INTO uth_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Remen kaane̱ da-o̱ wo̱ 'ye m-yar, o guut ko̱o̱b-ne̱, taase o ru̱re̱ hun-ne̱ bo̱ o he yo m-no̱m à. U̱rege̱ no̱ m-no̱m u̱n kaane̱, no̱ waragte̱ u̱ntu̱n ya-o-she̱pe̱, ye̱ ro̱ m-no̱m u̱n kaane̱ u̱n kuke̱-to̱ u̱n yoos u̱n Ma-to̱ Shir, komo u̱s-co̱w ne̱ remen hun-ne̱ bu̱mu̱t ye̱. Nip-o̱ me̱ no̱ m-ru̱re̱, ye̱ kumuste̱ 'yons-de u̱n ye̱ be-de u̱n hun-ne̱. ");
INSERT INTO uth_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Amba u̱rege̱ wo̱a gu ko-ko̱o̱b, wo̱ yage̱ ko̱ wan-yen-du wu̱ nep rii-yo wo̱ m-no̱m á. ");
INSERT INTO uth_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Remen kaane̱, 'ya m-yar wukusse̱. Ka da-de, Tato na wu̱ ro̱ m-hyan rii-yo wo̱ m-no̱m wukusse̱ à, wu̱a to̱p wo̱.” ");
INSERT INTO uth_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Ye̱so ze̱e̱ru̱, “Komo u̱rege̱ no̱ u̱t-ma u̱n Shir ne̱, no̱ no̱m bo̱ ya-o-she̱pe̱ ro̱ m-no̱m á. Ye̱ ro̱ m-co̱n ye̱ ine̱ eso n-me̱ u̱n kuke̱-to̱ u̱n yoos u̱n Ma-to̱ Shir ye̱ konot, komo u̱t-bakse̱ ne̱ be-de hun-ne̱ ro̱ m-go'one̱ à remen hun-ne̱ hyenet ye̱. Nip-o̱ me̱ no̱ m-ru̱re̱, ye̱ kumuste̱ o̱ ka ko̱m-de u̱n 'yons-de u̱n ye̱. ");
INSERT INTO uth_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Amba da-o̱ o he m-ko̱n u̱n Shir rii à, co̱w o-kuke̱, o tige̱ ish. O ko̱n Shir Tato na wu̱ a m-hyan á, komo Tato na wu̱ ro̱ m-hyan u̱n rii-yo a no̱me̱ wukusse̱ ba hun-ne̱ u̱n hyan wu̱ á, wu̱a to̱p wo̱.” ");
INSERT INTO uth_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Ye̱so ze̱e̱ru̱, “U̱rege̱ no̱ u̱n ko̱n u̱n Shir rii, taase no̱ ma'as m-bim ba m-nap u̱n rii-yo no̱ m-rwo̱r á. Ye̱ nape̱ Shir á, ye̱ ro̱ m-ko̱n kaane̱ remen ye̱ ro̱ u̱s-barag shir-ye̱ u̱n ye̱ co̱no̱g m-ho̱ge̱ u̱n go̱n ka ko̱n-se. Ye̱ ro̱ m-hyan ye̱a kum rii-yo ye̱ ro̱ u̱s-ko̱n à, remen ye̱ cepk u̱t-ma de̱e̱n da-o̱ u̱s-ko̱n. ");
INSERT INTO uth_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Taase no̱ ko̱n u̱ntu̱n ye̱ da-o̱ no̱ u̱s-ko̱n á, remen Shir Tato na nepste̱ rii-yo no̱ o-hoob à, cin ba no̱ u̱n ko̱n wu̱.” ");
INSERT INTO uth_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Ye̱so ze̱e̱ru̱, “Kaane̱ no̱ he m-ko̱n: “ ‘Tato na wu̱ ro̱ n-To̱n à, A se̱ke̱mse̱ jin u̱n du. ");
INSERT INTO uth_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Gwo̱mo-u̱t ru haan, A nom rii-yo o co̱ne̱ à ho̱no o-dak, Bo̱ a m-no̱m n-To̱n à. ");
INSERT INTO uth_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Ya te̱ caane̱ rii-yo m-re̱ yo u̱n ka ho̱-de. ");
INSERT INTO uth_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","O soksu̱ te̱ ba'as-u̱t te̱, bo̱ te̱ m-sokse̱ u̱n ye̱ ro̱ te̱ m-no̱me̱ u̱t-ba'as à. ");
INSERT INTO uth_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Taase o heet te̱ n-me̱ u̱t-meger á, Amba gu te̱ be-de o-yo̱ yo.’ ");
INSERT INTO uth_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“U̱rege̱ no̱ soksote̱ o̱r no̱ ne̱ u̱r-ba'as to̱ ye̱ no̱mu̱ no̱ u̱r-ba'as à, Tato no̱ wu̱ n-To̱n shir ma káane̱ wu̱ he no̱ m-sokse̱. ");
INSERT INTO uth_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Amba u̱rege̱ no̱ sokse̱ hun-ne̱ u̱r-ba'as á, kaane̱ Tato no̱ wu̱a sokse̱ no̱ to̱ ma no̱ ba'as-to̱ á.” ");
INSERT INTO uth_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Ye̱so ze̱e̱ru̱, “Da-o̱ no̱ o-swo̱o̱t à, no̱ naas o-co bo̱ ya-o-she̱pe̱ ro̱ m-naas u̱n co-se u̱n ye̱ á. Ye̱ ro̱ m-naas u̱n co-se u̱n ye̱ remen ye̱ kututé̱ hun-ne̱, ye̱ ro̱ o-swo̱o̱t. Nip-o̱ me̱ no̱ m-ru̱re̱, ye̱ kumuste̱ o̱ ka ko̱m-de u̱n 'yons-de u̱n ye̱. ");
INSERT INTO uth_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Amba da-o̱ wo̱ ro̱ o-swo̱o̱t, sapt co-o ru, o taam m-no̱w u̱r-hi, bo̱ o we̱te̱ m-no̱m à. ");
INSERT INTO uth_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Taase hun-ne̱ nep wo̱ o-swo̱o̱t. No̱m bo̱ Tato na wu̱ ro̱ n-To̱n à, wu̱ a m-hyan á, wu̱ wu̱ cot nape̱. Wu̱ hyeneste̱ yo wo̱ m-no̱m à ba hun-ne̱ u̱n nap. Komo wu̱a topo wo̱.” ");
INSERT INTO uth_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Ye̱so ze̱e̱ru̱ komo, “Taase no̱ karakse̱ hi u̱n no̱ o-kwu̱m u̱n ho̱no o-dak á. Be-de ye̱ge̱-re̱n m-shebe̱ ne̱ he o̱ m-naas à kàne̱ n-dak. Be-de komo hyow-ne̱ he m-co̱w ye̱ hiw yo no̱ e̱sse̱ à. ");
INSERT INTO uth_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Se̱ de̱ no̱ karakse̱ hi u̱n no̱ o-kwu̱m n-To̱n shir, rii-yo ro̱ kashi be-de Shir à. Be-de re̱n m-shebe̱ ne̱ a hoks o̱ m-naas á, komo hyow-ne̱ a hoks m-co̱w ye̱ hiwit u̱r-hyow á. ");
INSERT INTO uth_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Nom kaane̱ remen be-de kwu̱m-o ru ro̱ à, káne̱ hur-u̱r du ro̱.” ");
INSERT INTO uth_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Ye̱so ze̱e̱ru̱, “Yish-ye̱ ro̱ u̱r-pitirra de o-wu̱r, u̱rege̱ yish ru ro̱ ke̱rke̱r, kap u̱n wu̱r-o ru o̱a shi m-cecar ne̱. ");
INSERT INTO uth_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Amba u̱rege̱ yish ru ro̱ ke̱rke̱r á, wo̱a hyen u̱r-bon ne̱ á. Ya ro̱ u̱ntu̱n wu̱ ro̱ n-me̱ o-comb à. U̱rege̱ cecar-mo̱ depe̱ o nom à mo̱ ro̱ ko̱n á, ashi n-me̱ o-comb o̱ ka o ro̱.” ");
INSERT INTO uth_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Ye̱so ze̱e̱ru̱, “Yatt ko-gu̱w-wu̱ he m-hoks u̱n nome̱ u̱n hun-ne̱ yoor m-gu̱w da-o gaan á, ko̱ wu̱ cu̱n wan-gaan wu̱ yage̱ wan-gaan, ko̱ wu̱ es u̱n wan-gaan wu̱ yo'og wan-gaan, kaane̱ o̱ komo yatt bo̱ no̱ he m-no̱m no̱ cu̱nu̱t Shir u̱n hwo̱r ne̱ á.” ");
INSERT INTO uth_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Ka da-de Ye̱so ze̱e̱ru̱, “Remen kaane̱ me̱ no̱ m-ru̱re̱, taase no̱ ryegen bo̱ no̱ he nekette̱ m-ho̱o̱g à, u̱ntu̱n rii-yo no̱ he m-re̱, ko̱ yo no̱ he m-swo̱ à, ko̱ komo bo̱ no̱ he m-no̱m no̱ kumut rii-yo m-co̱p u̱n wu̱r-u̱t no̱ á. ¿Ho̱o̱g-m mo̱ arag rii-yo m-re̱ á? ¿Komo wu̱r-o̱ jiish saw-to̱ no̱ he m-co̱p á?” ");
INSERT INTO uth_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Ye̱so ze̱e̱ru̱, “Gwo̱t no̱ de̱ ye̱ge̱-no. Ye̱ u̱r-go á, ye̱ ro̱ ne̱ m-ce á, ye̱ m-kamas u̱r-byo á. Kap u̱n kaane̱ ne̱ Tato na wu̱ n-To̱n wu̱ ro̱ ye̱ m-re̱e̱gte̱. ¿Shir wu̱ jiish no̱ m-co̱n de̱e̱n arge̱ bo̱ wu̱ co̱ne̱ ye̱ á? Remen kaane̱ Shir a 'ye no̱ rii-yo m-re̱ yo no̱ co̱ne̱ à. ");
INSERT INTO uth_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","¿Wan wu̱ ne̱ be u̱n no̱ regen-o̱ u̱n wu̱ he hoks m-gu ho̱-to̱ u̱n mar-mo̱ u̱n wu̱ woosu̱ne̱?” ");
INSERT INTO uth_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Ye̱so haaru̱ co m-ze̱e̱, “No̱ ryegen u̱n saw-to̱ no̱ he m-co̱p á. Gwo̱t no̱ mo̱k-to̱ o-ko̱t bo̱ to̱ ro̱ m-bo̱'o̱se̱ à, to̱ ro̱ m-se̱nge̱ ko̱ m-ce u̱t-gund á. ");
INSERT INTO uth_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Amba kap u̱n kaane̱ ne̱, me̱ no̱ m-ru̱re̱ ko̱ ko-Gwo̱mo Suremanu myet u̱n gwo̱mo-to̱ u̱n wu̱ ne̱, wu̱ no̱m geger-to̱ wo̱o̱'e̱ u̱ntu̱n ko̱ o-gaan be-de u̱n to̱ á. ");
INSERT INTO uth_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","¿U̱rege̱ har Shir ro̱ m-nome̱ u̱n gwo̱-se o-ko̱t u̱t-geger to̱ ro̱ kane̱ caane̱, m-buk a tu̱ks to̱ à, yagu̱nte̱ no̱? No̱ m-she̱r be-de u̱n wu̱ de̱e̱n á! ");
INSERT INTO uth_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“Remen kaane̱ taase no̱ ryegen no̱ zee, ‘¿Ya ne̱ te̱ he m-re̱? ¿Ko̱ ya te̱ he m-swo̱?’ Ko̱ komo, ‘¿Ya te̱ he m-co̱p?’ ");
INSERT INTO uth_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Taase no̱ warag u̱ntu̱n ye̱ nape̱ Shir á. Ye̱ ro̱ u̱n hoob-o̱ u̱n se ka rem-se. Tato no̱ wu̱ n-To̱n wu̱ nepste̱ no̱ u̱n hoob-o̱ u̱n ka rem-se kap. ");
INSERT INTO uth_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Amba rii-yo jiishe̱ à u̱r-takan yo ka, hoob no̱ gwo̱mo-to̱ u̱n wu̱, komo no̱ she'et kashi u̱r-she'et de u̱n wu̱ bo̱ wu̱ co̱ne̱ à. Ka da-de, wu̱a 'ye no̱ ka rem-se kap. ");
INSERT INTO uth_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","“Remen u̱n kaane̱, taase no̱ ryegen remen m-buk. Remen ho̱-de u̱n buk-de ro̱o̱n u̱n go̱n co̱n-mo̱ u̱n de ne̱. Regen-o̱ u̱n caane̱ bo̱'o̱ssu̱tu̱ no̱ remen caane̱.” ");
INSERT INTO uth_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“No̱ piishe̱ hun-ne̱ u̱t-ma á, taase a piishi no̱. ");
INSERT INTO uth_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","No̱ nak bo̱ no̱ piishe̱ hun-ne̱ à, kaane̱ Shir he no̱ m-piishe̱. U̱rege̱ no̱ me'esu̱te̱ hun-ne̱ u̱r-bon ne̱, Shir a me'esu̱ no̱ u̱r-bon ne̱. Amba no̱ me'ese̱ hun-ne̱ ba u̱r-bon kaane̱ Shir he no̱ me'ese̱ ba u̱r-bon. ");
INSERT INTO uth_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","“¿Ya o ro̱tte̱ gwo̱t u̱n ya o-gwo̱ yo ro̱ n-me̱ u̱n yish-u̱r o̱r ru à, amba wo̱ hyan cik-o̱ ro̱ u̱n de ma ru yish-de? ");
INSERT INTO uth_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","¿Ko̱ komo re ne̱ o he m-no̱m o zeet o̱r ru, ‘Yage̱ u̱m hu̱ssu̱tu̱ wo̱ ya gwo̱-yo ro̱ n-me̱ u̱n yish u̱n du à,’ wo̱ kaane̱ o-cik ne̱ u̱n de ma ru yish-de? ");
INSERT INTO uth_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Wo̱ ko-ya-o-she̱pe̱! Hu̱ssu̱sse̱ cik-o̱ ro̱ n-me̱ u̱n yish ru à, remen o hyenet cas bo̱ o he m-hu̱sse̱ u̱n o̱r ru ya o-gwo̱ yo ro̱ n-me̱ u̱n yish-de u̱n wu̱ à.” ");
INSERT INTO uth_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Ye̱so ze̱e̱ru̱, “No̱ ya'as ye̱ge̱-wo̱ rem-se Shir se ba m-ku̱ko̱p á. U̱rege̱ no̱ nomog kaane̱, ye̱a waktu̱ne̱ ye̱ ho̱gu̱ssu̱ no̱ m-hoog. No̱ jorbe̱ ye̱ge̱-are̱de saw-to̱ u̱n hwo̱r á! Ye̱a yawag ka saw-to̱ u̱s-na se u̱n ye̱.” ");
INSERT INTO uth_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Ye̱so ze̱e̱ru̱, “Se̱ngu̱ no̱ ko̱n-se Shir rii-yo no̱ co̱ne̱ à, wu̱a 'ye no̱. Se̱ngu̱ no̱ hoob-o rii-yo no̱ co̱ne̱ à, Shir a 'ye no̱. Se̱ngu̱ no̱ ko̱'o̱t u̱n ish, Shir a tikshi no̱. ");
INSERT INTO uth_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Remen kap wu̱ ko̱ne̱ à, wu̱a kum be-de Shir. Myet wu̱ ho̱be̱ be-de Shir à, wu̱a kum. Komo kap wu̱ ko̱'o̱te̱ ish à, Shir a tiksu̱ wu̱. ");
INSERT INTO uth_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“¿Ko̱, wu̱ ken wu̱ ro̱ ko̱n be-u̱r no̱ tat-ne̱, wu̱ he u̱rege̱ wà u̱n wu̱ ko̱no̱g wu̱ rii-yo m-re̱, wu̱a ya'as wu̱ u̱r-ta'ar? ");
INSERT INTO uth_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","¿Ko̱ wan-gaan be-u̱r no̱ tat-ne̱ u̱rege̱ wà u̱n wu̱ ko̱no̱g wu̱ o-jan, wu̱a ya'as wu̱ o-hwo̱? ");
INSERT INTO uth_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","No̱mo̱g no̱ ye̱ge̱-yo̱-ye̱ no̱ nak bo̱ no̱ he m-'ya u̱n yakar no̱ rem-u̱s so̱-se à. Yagu̱nte̱ Tato no̱ wu̱ n-To̱n shir, ai wu̱a 'ye yan-ko̱n-se u̱n wu̱ rem-u̱s so̱-se!” ");
INSERT INTO uth_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Ye̱so ze̱e̱ru̱, “Myet bo̱ no̱ co̱ne̱ hun-ne̱ nomo no̱ à, se̱ no̱ nomotu̱ ye̱ kaane̱, remen o̱ ka o̱ ro̱ karamsa-o Mosa u̱n yoos-de u̱n yan-Rwo̱r u̱n Ma-to̱ Shir ne̱ n-ga.” ");
INSERT INTO uth_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Ye̱so ze̱e̱ru̱, “Co̱w no̱ u̱n gwo̱mo-to̱ Shir u̱n ish-o re̱k-o̱. Remen co̱w-yo ro̱ m-ha be-de m-mar à u̱n ka ish-o̱ ne̱ ro̱ m-ho̱o̱b ne̱. Komo ya-m-do̱re̱ u̱n ka co̱w-yo ro̱ de̱e̱n. ");
INSERT INTO uth_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Amba ish-o̱ ro̱ m-ha be-de u̱n ho̱o̱g à, re̱k-o̱ o̱. Co̱w-yo u̱n o̱ komo ro̱ m-'ya u̱r-ko̱o̱b de m-do̱re̱. Yan-do̱re̱-mo̱ u̱n yo komo ye̱ ro̱ de̱e̱n á.” ");
INSERT INTO uth_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Ye̱so ze̱e̱ru̱, “No̱m no̱ ja be-de u̱n yan-Rwo̱r u̱n Ma-to̱ Shir ye̱ u̱t-bo̱. Ye̱ ro̱ m-haan be u̱n no̱ u̱n sha-mo̱ u̱n ye̱ge̱-ca ye̱ ro̱ m-naas á. Amba u̱n hur-de u̱n ye̱, ya ye̱ ro̱ u̱ntu̱n ye̱ge̱-dur, ye̱ ro̱ u̱n ho̱ge̱ u̱n me̱r de̱e̱n à. ");
INSERT INTO uth_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","A m-kum u̱n yakar-ye̱ m-rum u̱n 'yo-yo o-yokor á, ko ne̱ u̱t-heye̱ u̱n 'yo-yo go̱g á. Kaane̱ komo ro̱ be-de u̱n hun-ne̱, u̱n go̱n she'et-de u̱n ye̱, de ye̱ ro̱ u̱r-she'et à, no̱ he ye̱ m-nap. ");
INSERT INTO uth_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Kaane̱ komo ko̱ yo ke kashi-o 'yo-yo yoa met yakar-ye̱ u̱r-bon, 'yo-yo u̱n ba u̱r-bon komo yo met yakar-ye̱ ba u̱r-bon. ");
INSERT INTO uth_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Bo̱ 'yo-yo u̱r-bon yoa hoks m-mat u̱n yakar-ye̱ ba u̱r-bon á, kaane̱ komo 'yo-yo ba u̱r-bon yoa hoks m-mat u̱n yakar-ye̱ u̱r-bon á. ");
INSERT INTO uth_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Kap 'yo-yo yage̱ mat u̱n yakar-ye̱ u̱r-bon à, hun-ne̱ a saag yo a jorbe̱ o-ra. ");
INSERT INTO uth_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Remen kaane̱ no̱ hette̱ m-nap u̱n yan-Rwo̱r u̱n Ma-to̱ Shir ye̱ u̱t-bo̱ u̱n bu̱-yo rem-se ye̱ m-no̱m à.” ");
INSERT INTO uth_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Ye̱so ze̱e̱ru̱, “Ba myet-o̱ u̱n hun-ne̱ ye̱ ro̱ me̱ m-ze̱e̱ ‘Go̱s-wu̱, Go̱s-wu̱ à,’ ye̱ he m-co̱w u̱n den-o̱ u̱n Gwo̱mo-to̱ o-Shir á. Se̱ de̱ ye̱ no̱me̱ rii-yo Tato re wu̱ n-To̱n shir co̱ne̱ à. ");
INSERT INTO uth_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","U̱n ho̱-de piish u̱t-ma, hun-ne̱ de̱e̱n ye̱a zee me̱, ‘Go̱s-wu̱! Go̱s-wu̱! Te̱ rwo̱ro̱g Ma-to̱ Shir u̱n jin u̱n du! Te̱ ruut ya-u̱t-ko̱t u̱n jin u̱n du! Komo, te̱ no̱m rem-se u̱t-hyat u̱n jin u̱n du.’ ");
INSERT INTO uth_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Ka da-de man zee ye̱, ‘Me̱ we̱t no̱ m-nap á. Ine̱ no̱ be u̱n de, no̱ yan-me̱n-u̱t jaas-to̱.’ ” ");
INSERT INTO uth_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Ye̱so ze̱e̱ru̱, “Remen kaane̱, wu̱ ho̱ge̱ ka ma-u̱t re to̱ à, wu̱ nom komo bo̱ u̱m zee à, wu̱a warag u̱ntu̱n ko-ya-u̱s-we̱e̱r wu̱ ma'e̱ hur-o̱ u̱n wu̱ n-te̱ o-ta'ar à. ");
INSERT INTO uth_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Bo̱ kem caari hyeete̱ à, mar-u̱t shiiru̱ m-ho̱. Yo-m indu̱ndu̱ru̱ mo̱ tamu̱ru̱ ká hur-o̱. Amba ká hur-o̱ he̱ á, remen ká ne̱t-wu̱ maag o̱ n-to̱n o-ta'ar. ");
INSERT INTO uth_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Myet bo̱ u̱n wu̱ ho̱ge̱ ma-u̱t re à, komo wu̱ yage̱ m-no̱m bo̱ u̱m zee à. Ya wu̱ ro̱ u̱ntu̱n wu̱ ken ko-raag-wu̱, wu̱ ma'e̱ hur-o̱ u̱n wu̱ n-te̱ m-hyereg à. ");
INSERT INTO uth_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Bo̱ kem caari hyeete̱ à, mar-u̱t shiiru̱ m-ho̱, yo-m indu̱ndu̱ru̱ mo̱ tamu̱ru̱ ká hur-o̱. Komo kap mo̱ u̱n ká hur-o̱ he̱e̱ru̱, he̱-de u̱n diniyo̱ komo!” ");
INSERT INTO uth_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Bo̱ Ye̱so komte̱ rwo̱r u̱n ka rem-se à, mo̱ro̱g-de u̱n hun-ne̱ ye̱ ho̱ge̱ wu̱ à, ye̱ bo̱pu̱ru̱ o-nu u̱n co̱w-yo wu̱ yoosu̱tu̱ ye̱ à u̱n rem-se wu̱ yoose̱ ye̱ ne̱ à. ");
INSERT INTO uth_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Ye̱ u̱n ze̱e̱ kaane̱, remen Ye̱so yoosu̱ ye̱ bo̱ yan-Yoos-de u̱n karamsa-o Mosa ro̱ m-yoos á. Wu̱ yoosu̱tu̱ ye̱ u̱ntu̱n ne̱t-wu̱ kumne̱ u̱t-gwo̱mo be-de Shir à. ");
INSERT INTO uth_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Bo̱ Ye̱so kyergu̱nte̱ n-to̱n u̱r-haag à, hun-ne̱ de̱e̱n do̱ru̱ru̱ wu̱. ");
INSERT INTO uth_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Wu̱ ken ko-cim-wu̱, haaru̱ be-de u̱n wu̱, wu̱ kwu̱ktu̱ru̱ u̱n co-o̱ u̱n wu̱. Wu̱ ze̱e̱ru̱, “Go̱s-wu̱, u̱rege̱ o co̱no̱g, wo̱a hoks me̱ m-taase̱ u̱n go̱m re.” ");
INSERT INTO uth_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Ye̱so tabbu̱ru̱ kom-o̱ u̱n wu̱, wu̱ ci'u̱ru̱ ká ne̱t-wu̱. Komo Ye̱so ze̱e̱ru̱, “U̱m co̱no̱g, go̱m ru te.” Ba u̱n rem káne̱, cim-to̱ u̱n wu̱ ta'e̱. ");
INSERT INTO uth_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Ka da-de Ye̱so ze̱e̱ru̱ wu̱, “Wo̱ jar o ru̱re̱ ne̱t bo̱ no̱me̱ á. Amba neke̱, o kute̱ wan-Co̱w u̱n ko̱n-se Shir, wu̱r-o ru taag. Komo o seke̱ u̱r-seke̱ bo̱ karamsa-o Mosa zee à. No̱m kaane̱ remen o kututé̱ hun-ne̱ u̱nze cim-u̱t ru taag.” ");
INSERT INTO uth_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Bo̱ Ye̱so cu̱wte̱ u̱n bo̱-o̱ o-Kapanahum à, wu̱ ken caari-wu̱ u̱n ko-karma-wu̱ u̱n Roma-ne̱, wu̱ haanu̱ru̱ be-de u̱n Ye̱so. Wu̱ ko̱nu̱ru̱ wu̱, wu̱ zee, ");
INSERT INTO uth_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Go̱s-wu̱, me̱ u̱n ko-ya-m-gu̱w ne̱ wan-campo̱ wu̱ piishe̱ á. Wu̱ ro̱ o-hur do̱mb, wu̱ ro̱ m-hoks m-nukte̱ á, wu̱ ro̱ m-swo̱ u̱r-ko̱o̱b de̱e̱n.” ");
INSERT INTO uth_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Ye̱so ze̱e̱ru̱ wu̱, “Man habe̱, u̱m taasu̱té̱ wu̱ go̱m-o̱ u̱n wu̱.” ");
INSERT INTO uth_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Ko-caari-wu̱ u̱n ko-karma-wu̱ u̱n Roma-ne̱ shasu̱ru̱ Ye̱so, “Go̱s-wu̱, me̱ bo'os o habe̱ u̱n hur-o re á, amba no̱m u̱t-ma temb, go̱m-o̱ u̱n wan-gu̱w-m re a te. ");
INSERT INTO uth_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Remen me̱ u̱n ce re u̱n ku̱s-o̱ u̱n gwo̱mo-to̱ u̱n ye̱ ken ye̱ u̱m ro̱, komo me̱ u̱n karma-ne̱ u̱n ku̱s-o re. Me̱ m-ze̱e̱ u̱n wan-gaan, ‘Neke̱, o nom kàane̱,’ wu̱ neke̱. Wu̱ ken komo me̱ m-ze̱e̱, ‘Haan,’ wu̱ argu̱ m-haan. U̱m zee ko-gu̱w re, ‘No̱m yo ká káane̱,’ wu̱ no̱mu̱ru̱.” ");
INSERT INTO uth_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Bo̱ Ye̱so ho̱gu̱te̱ kaane̱ à, wu̱ bo̱pu̱ru̱ o-nu. Wu̱ ze̱e̱ru̱ yan-neke̱-mo̱ u̱n wu̱, “Nip-o̱ me̱ no̱ m-ru̱re̱, ko̱ n-me̱ u̱n dak-o̱ o-Isra me̱ tak m-kum wa-m-she̱r m-'wo̱ns ne̱ u̱ntu̱n wu̱ ka á. ");
INSERT INTO uth_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Me̱ no̱ m-ru̱re̱ hun-ne̱ de̱e̱n ye̱ ro̱ Yahuda-ne̱ á ye̱a haan so̱ u̱r-ho̱ran, u̱r-ho̱rim ne̱ rwu̱u̱n-mo̱ u̱n to̱ ken dak-to̱. Ye̱ she'ette̱ ye̱ reet o-biki be-u̱r gaan u̱n Ibrahi ne̱ u̱n Ishaku ne̱ u̱n Yakubu ne̱ u̱n Gwo̱mo-to̱ Shir. ");
INSERT INTO uth_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Amba Shir a jorbu̱ no̱ n-me̱ o-comb no̱ ye̱ depete̱ no̱ wakte̱ hun-ne̱ ye̱ u̱n wu̱ à, amba no̱ yage̱. Kane̱ no̱ he u̱s-kan u̱n haw-se u̱n yin-ne̱.” ");
INSERT INTO uth_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Ka da-de Ye̱so ze̱e̱ru̱ ka caari-wu̱ u̱n ko-karma-wu̱ u̱n Roma-ne̱ wu̱, “Neke̱ jo o-hur, go̱m-o̱ u̱n ko-gu̱w ru a te bo̱ o she̱re̱ à.” Ba u̱n rem, wu̱r-o̱ u̱n ko-yan-gu̱w-mo̱ u̱n wu̱ taaru̱. ");
INSERT INTO uth_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Bo̱ Ye̱so cu̱wte̱ u̱n hur-o Bitrus à, wu̱ 'wo̱su̱ru̱ ko-mo̱o̱n Bitrus ne'a wu̱ ro̱ do̱mb, wu̱r-o̱ dengu̱te̱ wu̱ o-ra. ");
INSERT INTO uth_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Ye̱so ci'u̱ru̱ kom-o̱ u̱n wu̱, ká go̱m-o̱ dossu̱ru̱. Wu̱ inu̱ru̱ wu̱ nomoru̱ ye̱ rii-yo m-re̱. ");
INSERT INTO uth_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Bo̱ rim-m nomte̱ à, hun-ne̱ hantu̱ru̱ Ye̱so ye̱ ya-u̱t-ko̱t da'e̱ u̱t-hi à de̱e̱n. Wu̱ ruutu̱ru̱ ya-u̱t-ko̱t u̱n rwo̱r u̱t-ma temb. Wu̱ taasu̱ru̱ komo ya-u̱s-go̱m go̱m-se u̱n ye̱ kap. ");
INSERT INTO uth_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Ye̱so u̱n nom to̱ ká káane̱ remen a shoosté̱ rwo̱r-m Ishayawan-Rwo̱r u̱n Ma-to̱ Shir u̱nze, “Wu̱ de̱k swo̱ u̱r-ko̱o̱b u̱n na, wu̱ taaste̱ go̱m-u̱s na.” ");
INSERT INTO uth_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Bo̱ Ye̱so hyente̱ caari-de u̱n bu̱u̱g-de u̱n hun-ne̱ keste̱ wu̱ ge̱w à, wu̱ ze̱e̱ru̱ yan-neke̱-mo̱ u̱n wu̱, “A pes no̱ de ká jit-de o-mar de re̱e̱no̱.” ");
INSERT INTO uth_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Ka da-de wu̱ ken wan-Yoos-de o-karamsa haanu̱ru̱. Wu̱ ze̱e̱ru̱ Ye̱so, “Wan-yoos, man do̱ru̱ wo̱ myet ko̱ ke so̱ o ha'e̱.” ");
INSERT INTO uth_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Ye̱so ze̱e̱ru̱ wu̱, “E̱ge̱-ru̱u̱g ro̱ u̱n wu-to̱ u̱n ye̱ ne̱, ye̱ge̱-no komo u̱n be-to̱ u̱n rew-mo̱ u̱n ye̱ ne̱. Amba me̱ Wà-wu̱ u̱n ne̱t me̱tt be-de m-rew á.” ");
INSERT INTO uth_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Wu̱ ken wu̱ n-me̱ u̱n yan-neke̱-mo̱ u̱n wu̱ ze̱e̱ru̱ wu̱, “Go̱s-wu̱, yage̱ u̱m he u̱m ju̱kt tato re to̱ ko̱n da-o̱ wu̱ mere̱. Ka da-de u̱m haanu̱ru̱, u̱m do̱ru̱ru̱ wo̱.” ");
INSERT INTO uth_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Amba Ye̱so ze̱e̱ru̱ wu̱, “Do̱nd me̱, o yage̱ margan-ne̱ ye̱ o-ku̱kt, ye̱ ju̱kt o̱r u̱n ye̱ u̱n margan-ne̱.” ");
INSERT INTO uth_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Ka da-de Ye̱so co̱wu̱ru̱ hat-o̱ m-ho̱, yan-neke̱-mo̱ u̱n wu̱ do̱ru̱ru̱ wu̱. ");
INSERT INTO uth_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Ka da-de yo-mo̱ m-'wo̱ns indu̱ndu̱ru̱ o-mar har ho̱-m ro m-daan mo̱ ro̱ m-co̱w n-me̱ o-hat, amba Ye̱so ro káne̱, wu̱ ro m-rew. ");
INSERT INTO uth_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Yan-neke̱-mo̱ u̱n wu̱ haaru̱, ye̱ 'yonsu̱ru̱ wu̱. Ye̱ zee, “Go̱s-wu̱, gu te̱, ho̱-m a re te̱!” ");
INSERT INTO uth_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Ye̱so ze̱e̱ru̱ ye̱, “¿Remen yan no̱ ho̱gu̱te̱ o-gye̱r kaane̱? No̱tt m-she̱r be u̱n de de̱e̱n á.” Ka da-de wu̱ inu̱ru̱, wu̱ te̱pru̱ru̱ ká yo-mo̱ u̱n ká sa-mo̱ ne̱, kap o̱ u̱n ká be-de re̱su̱ru̱ ceen. ");
INSERT INTO uth_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Ká hun-ne̱ bo̱pu̱ru̱ o-nu, ye̱ ze̱e̱ru̱ hi u̱n de u̱n ye̱, “¿Yan go̱n ne̱t-wu̱ ne̱ wu̱ ka, wu̱ ro̱ har m-sa m-yo ne̱ mo̱ ro̱ wu̱ m-nome̱ o-do̱ro̱tte̱?” ");
INSERT INTO uth_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Ye̱so u̱n yan-neke̱-mo̱ u̱n wu̱ ne̱, wo̱o̱ru̱ u̱n de ká jit-de o-mar o̱ o-Gariri de. Ha-mo̱ u̱n dak-o̱ o-Gadare̱ne̱s. Ka da-de hun-ne̱ yoor-ye̱ ya-u̱t-ko̱t ro̱ m-rangse̱ à rwu̱u̱nu̱ru̱ n-me̱ u̱s-saag, ye̱ kawnu̱ru̱ Ye̱so ne̱. Ye̱ waktu̱ssu̱te̱ rii-ye̱ o-gye̱r ba m-so̱k har ma yatt-wu̱ ro̱ m-do̱re̱ u̱n ka co̱w-yo á. ");
INSERT INTO uth_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Ye̱ kangsu̱ru̱ Ye̱so, “Wà-wu̱ Shir, ¿ya o co̱ne̱ u̱n te̱ ne̱ ya-u̱t-ko̱t? ¿Ko̱ wo̱ u̱n haan o ye'et te̱ u̱r-ko̱o̱b cin ba da-o̱ u̱n wo̱o̱n o̱ Shir e̱sse̱ à?” ");
INSERT INTO uth_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","U̱n co-o̱ u̱n ye̱ hiin, de ken caari-de u̱n kur-de u̱n ye̱ge̱-are̱de ro ko̱n, ye̱ ro u̱t-re̱. ");
INSERT INTO uth_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Ká ya-u̱t-ko̱t ye̱ ko̱nu̱ru̱ Ye̱so, ye̱ zee, “Wo̱ ruutu̱ te̱ be-de u̱n ka hun-ne̱ yoor-ye̱, o yage̱ te̱ cu̱wu̱t u̱n ká kur-de u̱n are̱de de.” ");
INSERT INTO uth_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Ye̱so ze̱e̱ru̱ ká ya-u̱t-ko̱t ye̱, “To̱, neke̱ no̱.” Ye̱ ruuru̱ be-de u̱n ká hun-ne̱ yoor-ye̱, ye̱ co̱wu̱ru̱ n-me̱ u̱n ye̱ge̱-are̱de. U̱n gyept-o̱ u̱n yish, kur-de u̱n are̱de nupu̱ru̱ u̱s-rek ye̱ yiru̱gbu̱ru̱, ye̱ he̱bu̱ru̱ n-me̱ o-mar. Ho̱-m re̱e̱ru̱ ye̱. ");
INSERT INTO uth_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Bo̱ yan-gu̱t-de u̱n are̱de hyente̱ kaane̱ à, ye̱ so̱mu̱ru̱ co̱w-mo̱ o-bo̱ be-de den-to̱ u̱n ye̱ ro̱ à. Ye̱ ru̱ru̱ru̱ hun-ne̱ rii-yo ko̱re̱ à. Komo ye̱ ru̱ru̱ru̱ hun-ne̱ yo ko̱re̱ u̱n ká hun-ne̱ yoor-ye̱ ne̱ à, ye̱ ro u̱n ya-u̱t-ko̱t ne̱ à. ");
INSERT INTO uth_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Myet-mo̱ u̱n hun-ne̱ ye̱ o-bo̱ rwu̱u̱nu̱ru̱ hyan-o Ye̱so. Bo̱ ye̱ hyente̱ wu̱ à, ye̱ ko̱nu̱ru̱ wu̱, wu̱ ru u̱n dak-o̱ u̱n ye̱. ");
INSERT INTO uth_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Ye̱so co̱wu̱ru̱ hat-o̱ m-ho̱, u̱n yan-neke̱-mo̱ u̱n wu̱ ne̱. Ye̱ pasu̱ru̱ Mar-o̱ o-Gariri, ye̱ co̱wu̱ru̱ o-Kapanahum bo̱-o̱ u̱n wu̱. ");
INSERT INTO uth_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Ye̱ ken hun-ne̱ ye̱ hantu̱ru̱ Ye̱so ko-ryam. Wu̱ ro do̱mb o-karanga, wu̱ ro m-hoks u̱n nukt u̱n wu̱r-o̱ u̱n wu̱ á. Ye̱so napu̱ru̱ ká hun-ne̱ ye̱ she̱re̱ste̱ u̱nze Ye̱so a hoks taase u̱n wu̱ ká go̱m-o̱. Ye̱so ze̱e̱ru̱ ká ko-ryam-wu̱, “Wan-yen de, wo̱ jar o-regen á, a sokste̱ ba'as-u̱t ru!” ");
INSERT INTO uth_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Bo̱ ye̱ ken yan-Yoos-de o-karamsa ye̱ ho̱ge̱ káane̱ à, ye̱ ze̱e̱ru̱ o̱r u̱n ye̱ ne̱, “Ka ne̱t-wu̱ ro̱ u̱t-ma sa o zee wu̱ ro̱ Shir.” ");
INSERT INTO uth_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Amba Ye̱so nepste̱ barag-se ro̱ u̱n hur-de u̱n ye̱ à. Wu̱ ze̱e̱ru̱ ye̱, “¿Remen yan o̱ no̱tte̱ u̱n barag-u̱s yo̱-se u̱n hur-u̱t no̱ káane̱? ");
INSERT INTO uth_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","¿Ya jiishe̱ kupse̱, u̱m zee, ‘U̱m sokste̱ ba'as-u̱t ru,’ ko̱ a zee, ‘Ine̱ o hewwe̱ u̱r-hew?’ ");
INSERT INTO uth_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Man kutu no̱ u̱nze, me̱ Wà-wu̱ u̱n ne̱t ro̱ u̱t-gwo̱mo ne̱ to̱ u̱n soks u̱t-ba'as u̱n ho̱no o-dak.” Ka da-de, Ye̱so ze̱e̱ru̱ ko-ryam, “Ine̱ eso, o mos karanga-o ru, o ji o-hur.” ");
INSERT INTO uth_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Ká ne̱t-wu̱ inu̱ru̱ pee, komo wu̱ ji'u̱ru̱ u̱n hur-o̱ u̱n wu̱. ");
INSERT INTO uth_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Bo̱ mo̱ro̱g-de u̱n hun-ne̱ hyente̱ kaane̱ à, ye̱ ho̱gu̱ru̱ o-gye̱r. Ye̱ bo̱mu̱ru̱ Shir, wu̱ ya'e̱ ne̱t go̱n ka gwo̱mo-to̱ à. ");
INSERT INTO uth_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Bo̱ Ye̱so reete̱ co u̱r-hew à, wu̱ hyanu̱ wu̱ ken ko-yan-go̱ks u̱n tar wu̱. Jin-de u̱n wu̱ Matiyos. Wu̱ ro tara be-de u̱n go̱ks u̱n tar. Ye̱so ze̱e̱ru̱ wu̱, “Do̱nd me̱, o warag wan-neke̱-m re.” Matiyos inu̱ru̱, wu̱ do̱ru̱ru̱ Ye̱so. ");
INSERT INTO uth_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Bo̱ ho̱-u̱r warge̱ so m-rim à, Ye̱so re̱e̱ru̱ rii-yo m-re̱ u̱n hur-o Matiyos. Yan-go̱ks u̱n tar u̱n ya-u̱r-ba'as ne̱ de̱e̱n, ye̱ she'etu̱ru̱ be-u̱r gaan u̱n Ye̱so ne̱ u̱n yan-neke̱-mo̱ u̱n wu̱ ne̱. Ye̱ re̱e̱ru̱ be-u̱r gaan u̱n Ye̱so ne̱. ");
INSERT INTO uth_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Bo̱ Parisa-ne̱ hyente̱ káane̱ à, ye̱ ze̱e̱ru̱ yan-neke̱-m Ye̱so. “U̱depe̱ ko-yan-yoos-u̱r no̱ re rii-yo m-re̱ u̱n yan-go̱ks u̱n tar ne̱, u̱n ya-u̱r-ba'as ne̱ á.” ");
INSERT INTO uth_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Bo̱ Ye̱so ho̱gu̱te̱ to̱ ka à, wu̱ ze̱e̱ru̱, “Yan-ba-u̱s-go̱m ro̱ u̱n hoob-o̱ ko-ya-u̱s-baat á, se̱ de̱ ya-u̱s-go̱m ye̱ ro̱ m-hoob u̱n ko-ya-u̱s-baat. ");
INSERT INTO uth_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Neke̱ no̱ ceker rii-yo Shir co̱ne̱ à, da-o̱ wu̱ zee, ‘U̱m co̱no̱g hun-ne̱ ho̱ge̱ 'wo̱n-u̱r o̱r re u̱n ye̱ ne̱, ba ye̱ seke̱ me̱ u̱t-gu̱t á.’ ” Ye̱so ze̱e̱ru̱, “Me̱ u̱n haan remen kashi u̱n hun-ne̱ á, amba remen ya-u̱t-ba'as o̱ u̱m haante̱.” ");
INSERT INTO uth_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","A káne̱ yan-neke̱-m Yohana Wa-m-Yo'os u̱n hun-ne̱ m-ho̱ haanu̱ru̱ be-u̱r Ye̱so. Ye̱ ze̱e̱ru̱ wu̱ “Te̱ u̱n Parisa-ne̱ ne̱ ro̱ u̱n no̱m o-swo̱o̱t, ¿ya rwo̱'e̱ yan-neke̱-m ru ro̱tte̱ m-no̱m o-swo̱o̱t á?” ");
INSERT INTO uth_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Ye̱so shasu̱ru̱ ye̱, “Nay-ne̱ ye̱ u̱n ko-ya-u̱t-ge ro̱ o-zak ne̱ da-o̱ ko-ya-u̱t-ge ro̱ be-u̱r gaan u̱n ye̱ ne̱ à. Amba u̱jime̱ hun-ne̱ a dek ko-ya-u̱t-ge a yagu̱ ye̱ m-zar. U̱ kore̱ kaane̱ ká da-o̱ ye̱ he tu̱k-mo̱ u̱t-me̱n ye̱ nom o-swo̱o̱t.” ");
INSERT INTO uth_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Komo Ye̱so ze̱e̱ru̱, “Hun-ne̱ ro̱ m-no̱m u̱n dap-de u̱n u̱r-matuku u̱r-ut u̱n gund-u̱r pu̱-de á. U̱rege̱ ye̱ no̱mo̱g, gund-u̱r pu̱-de a swu̱tme̱ de yiish u̱r-ut arge̱-mo̱ n-ga. ");
INSERT INTO uth_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","“Komo, yatt ne̱t-wu̱ ro̱ m-duus ke̱-m pu̱-mo̱ n-me̱ u̱n tur-o̱ o-ka o-ut á. Remen ka tur-o o-ka o-ut o̱a bu̱u̱ge̱ remen 'wo̱ns-mo̱ u̱n ka ke̱-mo̱, ká ke̱-mo̱ mo̱a ukse̱ komo tur-o o-ka bu̱u̱gse̱. Ke̱-m pu̱-mo̱, hun-ne̱ ro̱ mo̱ duus n-me̱ u̱n tur-o o-ka o-pu̱ o̱ u̱n kaane̱, hun-ne̱ ye̱a taage̱ ko̱ gaan n-me̱ o-tur o-ka ko̱ m-ke̱ á.” ");
INSERT INTO uth_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Ye̱so ro̱ ye̱ m-ru̱re̱ u̱t-ma kane̱, se̱ wu̱ ken u̱n kuke̱-o̱ u̱n yoos u̱n Ma-to̱ Shir haaru̱ be-u̱r Ye̱so wu̱ kwu̱ktu̱ru̱ u̱n co-o̱ u̱n wu̱. Wu̱ ze̱e̱ru̱, “Wà re wan-ne'a marag m-mo̱ka m-mo̱ka, amba wo̱ haabe̱ hur-o re, wo̱ ci wu̱ u̱n kom-u̱t ru, wo̱a hoks wu̱ m-'yons, wu̱a ine̱ ba u̱n go̱m.” ");
INSERT INTO uth_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Ye̱so inu̱ru̱ u̱n yan-neke̱-mo̱ u̱n wu̱ ne̱, ye̱ do̱ru̱ru̱ tato-o̱ u̱n ka wà-wu̱. ");
INSERT INTO uth_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Ye̱ ro̱ m-neke̱ wu̱ ken ne'a wu̱, ko-yan-go̱m do̱ndu̱ru̱ Ye̱so n-jim. Wu̱ no̱mo̱g hak-u̱s o̱p u̱s-yoor hyó-m ro̱ m-du. Wu̱ wo̱o̱nu̱ru̱ u̱n jim-de u̱n wu̱, wu̱ ci'u̱ru̱ riib-yo u̱n matuku-u̱r Ye̱so. ");
INSERT INTO uth_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Wu̱ u̱n nom kaane̱ remen wu̱ ze̱e̱g n-me̱ u̱n hur-de u̱n wu̱, “U̱rege̱ u̱m ci'ig matuku-de u̱n wu̱ cot go̱m re a te.” ");
INSERT INTO uth_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Bo̱ Ye̱so byandu̱te̱ à, wu̱ hyanu̱ ká ne̱t-wu̱. Wu̱ ze̱e̱ru̱, “Wo̱ ryegen á wà re o̱, Shir taaste̱ go̱m ru remen o she̱re̱g wu̱a taas o̱.” Go̱m-o̱ u̱n wu̱ taaru̱ kane̱. ");
INSERT INTO uth_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Bo̱ Ye̱so tu̱wte̱ hur-o̱ u̱n ka wan-co-wu̱ u̱n Yahuda-ne̱ wu̱ à, wu̱ hyanu̱ru̱ ya-m-huru u̱r-ku u̱n mo̱ro̱g-de u̱n hun-ne̱ ne̱ ye̱ ro̱ u̱n dum-to̱ m-mar. Bu̱u̱g-de hun-ne̱ ro̱ o-zaaz. ");
INSERT INTO uth_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Ka da-de wu̱ ze̱e̱ru̱ ye̱, “Ine̱ no̱ kane̱! Ka wan-ne'a-wu̱, wu̱ mar á, rew-mo̱ wu̱ ro̱tte̱.” Amba ka hun-ne̱ ye̱ nemsu̱ru̱ wu̱ nemes-to̱ o-yo'og. Ye̱ she̱r be-de u̱n wu̱ á, remen ye̱ nepse̱ ka wà-wu̱ mereste̱. ");
INSERT INTO uth_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Yan-den-o̱ u̱n ka wà-wu̱ ruutu̱ru̱ ye̱ n-do̱. Ye̱so co̱wu̱ru̱ u̱n kuke̱-o̱ u̱n ka wà-wu̱. Ye̱so shipu̱ru̱ kom-o̱ u̱n ka wan-ne'a-wu̱, wan-ne'a inu̱ru̱! ");
INSERT INTO uth_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ka hun-ne̱ ye̱ taknu̱ru̱ rwo̱r u̱n ma-to̱ ka wan-ne'a-wu̱, wu̱ Ye̱so 'yonse̱ m-mar à, har ka ma-to̱ semu̱ru̱ kap n-me̱ u̱n ka dak-o̱. ");
INSERT INTO uth_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Bo̱ Ye̱so peste̱ u̱n co hiin à, po̱-ne̱ yoor do̱ru̱ru̱ wu̱ u̱s-eeg, “Wà ko-Gwo̱mo Dawuda ho̱ge̱ 'wo̱n-u̱r te̱!” ");
INSERT INTO uth_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Bo̱ Ye̱so cu̱wte̱ u̱n o̱ ken hur-o̱ à ka po̱-ne̱ ye̱ yoor haaru̱ be-de u̱n wu̱. Wu̱ ze̱e̱ru̱ ye̱, “¿No̱ she̱re̱g m-'wo̱ns ne̱ man hoks taas u̱n go̱m no̱?” Ye̱ ze̱e̱ru̱ wu̱, “Eba, Go̱s-wu̱ o̱.” ");
INSERT INTO uth_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Ka da-o̱, Ye̱so ci'u̱ru̱ yish-ye̱ u̱n ye̱. Wu̱ zee, “Remen she̱r-m no̱, man taas go̱m no̱.” ");
INSERT INTO uth_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Yish-ye̱ u̱n ye̱ upsu̱ru̱. Ka da-o̱ Ye̱so ka'agu̱ ye̱ m-so̱k ne̱ wu̱ zee, “No̱ ru̱re̱ ne̱t yo no̱me̱ á.” ");
INSERT INTO uth_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Amba ye̱ ruuru̱, ye̱ ze̱e̱ru̱ m-rwo̱r u̱n ma-to̱ u̱n wu̱ ko̱ kene̱ u̱n ká dak-o̱. ");
INSERT INTO uth_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Bo̱ ye̱ zette̱ ru-mo̱ ka à, hun-ne̱ hantu̱ru̱ Ye̱so wu̱ ken campo̱-wu̱. Ko-ya-u̱t-ko̱t we̱ne̱g wu̱ te̱p. ");
INSERT INTO uth_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Ye̱so ruutu̱ru̱ ko-ya-u̱t-ko̱t, ka wu̱ ro u̱n hoks m-te̱pe̱r á, ka da-o̱ wu̱ ciru̱ru̱ te̱p. Mo̱ro̱g-de u̱n hun-ne̱ bo̱pu̱ru̱ nu-se u̱n ye̱. Ye̱ ze̱e̱ru̱, “Te̱ we̱t m-hyan u̱n yo ken rii-yo u̱ntu̱n kaane̱ n-me̱ u̱n dak-o̱ Isra-ne̱ á.” ");
INSERT INTO uth_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Amba Parisa-ne̱ ze̱e̱ru̱, “U̱n be̱e̱b-de u̱n ko-Gwo̱mo-wu̱ u̱n ya-u̱t-ko̱t wu̱ ro̱ m-ruute̱ u̱n hun-ne̱ ya-u̱t-ko̱t.” ");
INSERT INTO uth_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Bo̱n kane̱, Ye̱so do̱ru̱ru̱ myet o̱ u̱t-bo̱ u̱n ye̱ ro n-me̱ o-ko̱t ne̱ à. Wu̱ ro u̱r-yoos u̱n kuke̱-to̱ u̱n yoos u̱n Ma-to̱ Shir. Wu̱ ro u̱n ko̱'o̱te̱ u̱n hun-ne̱ Ma-to̱ m-Re̱re̱m to̱ u̱n gwo̱mo-to̱ Shir. Wu̱ ro̱ komo m-taase̱ u̱n hun-ne̱ u̱s-go̱m u̱n ko̱ o̱ ke go̱n go̱m-o̱ u̱n ko̱o̱b-de u̱n gu̱gaaz-mo̱ o-wu̱r mo̱ ne̱. ");
INSERT INTO uth_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Bo̱ wu̱ hyente̱ hun-ne̱ mo̱ro̱gsu̱te̱ de̱e̱n à, wu̱ ho̱gu̱ru̱ 'wo̱n-de u̱n ye̱, remen ye̱ u̱n swo̱ u̱r-ko̱o̱b. Komo wan-gwu̱ ro̱ ko̱n á, u̱ntu̱n ye̱ge̱-ca ye̱ ro̱ ba u̱n ko-ya-u̱r-gu̱t à. ");
INSERT INTO uth_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Ka da-de Ye̱so ze̱e̱ru̱ yan-neke̱-mo̱ u̱n wu̱, “Hun-ne̱ de̱e̱n co̱no̱g ye̱ haan be u̱n de, amba ya-u̱r-ben ro̱ ko̱n de̱e̱n á. Ya ye̱ ro̱ u̱ntu̱n kat-o caari-o̱ wo̱o̱se̱ m-ce à, amba ya-m-ce ro̱ ko̱n de̱e̱n á. Ye̱ he m-ce ye̱ jonte̱ o-hur á. ");
INSERT INTO uth_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Remen kaane̱, ko̱n no̱ ko-ya-o-kat-wu̱ to̱mo̱n ya-m-ce ye̱ ceete̱ wu̱ m-ce.” ");
INSERT INTO uth_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Ye̱so daagu̱ru̱ yan-neke̱-mo̱ u̱n wu̱ o̱p u̱n yoor 12. Wu̱ ya'u̱ru̱ ye̱ be̱e̱b-de u̱n ruut u̱n ya-u̱t-ko̱t be-de u̱n hun-ne̱. Komo ye̱ taase̱ hun-ne̱ ko̱ o̱ ke go̱n go̱m-o̱. ");
INSERT INTO uth_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Jin-to̱ u̱n ká yan-To̱m-ye̱ to̱ ka o̱p yoor 12. Ye̱ Ye̱so aage̱ yan-neke̱-mo̱ u̱n wu̱ à. U̱r-takan Simo̱n (wu̱ a m-ze̱e̱ Bitrus à), u̱n heno u̱n wu̱ ne̱ Andarawus. Yakubu (wà Ze̱be̱di), u̱n hen u̱n wu̱ ne̱ Yohana, ");
INSERT INTO uth_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Pirip, u̱n Bataromi ne̱. Tomas, u̱n Matiyos (wan-go̱ks u̱n tar), Yakubu (wà Aru̱payes), u̱n Taddiyus ne̱, ");
INSERT INTO uth_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simo̱n (ko-ya-o-Kan'ana), Komo u̱n Yahudas Iskariyoti ne̱ (wu̱ ya'ase̱ Ye̱so u̱n kom-to̱ u̱n yan-yage̱-to̱ u̱n wu̱ à). ");
INSERT INTO uth_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Da-o̱ Ye̱so to̱me̱ ká hun-ne̱ o̱p u̱n yoor-ye̱ à 12, wu̱ ru̱ru̱ ye̱ yo ka, wu̱ ze̱e̱ru̱ ye̱, “No̱ jar no̱ he be-de u̱n hun-ne̱ ye̱ ro̱ Yahuda-ne̱ á, komo no̱ jar no̱ cu̱w to̱ ken bo̱-to̱ o-Samariya to̱ á. ");
INSERT INTO uth_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Se̱ de̱ no̱ he be-de u̱n hun-ne̱ ye̱ o-Isra ye̱ ro̱ u̱ntu̱n ca-ye̱ e̱ge̱ à. ");
INSERT INTO uth_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Ha no̱ ru̱ru̱ ye̱ ka ma-to̱ u̱nze, ‘Da-o ro̱ yow yow, da-o̱ Shir he no̱m u̱t-gwo̱mo à.’ ");
INSERT INTO uth_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","No̱ taas ya-u̱s-go̱m go̱m-se u̱n ye̱. No̱ 'yons ye̱ mare̱ à. No̱ taas cim-ne̱ cim-to̱ u̱n ye̱. No̱ ruute̱ hun-ne̱ ya-u̱t-ko̱t. Yar-mo̱ no̱ kume̱, komo yar-mo̱ no̱ he m-'ya. ");
INSERT INTO uth_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","“No̱ jar no̱ dek hwo̱r hap-o no̱ ");
INSERT INTO uth_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","ko̱ ba-o̱ u̱r-hew á. No̱ jar no̱ de̱k matuku-u̱t yoor á, ko̱ u̱t-ka'ante̱. No̱ de̱k ko̱-yo u̱r-hew á. Remen no̱ he de m-taage̱ u̱n ko̱ rii gaan be-de u̱n ka rem-se à. No̱ yan-se̱nge̱-m re ye̱. Ka hun-ne̱ ye̱ no̱ gu'e̱ à ye̱ he no̱ m-'ya u̱n yo no̱ o-hoob à.” ");
INSERT INTO uth_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Ye̱so ze̱e̱ru̱, “Ko̱ o̱ ke bo̱-o̱, ko̱ o-den o̱ no̱ co̱we̱ à, hoob no̱ kashi u̱n ne̱t-wu̱ he no̱ m-barke̱ u̱n hur-o̱ u̱n wu̱ à. She'et no̱ u̱n hur-o̱ u̱n wu̱ har se̱ da-o̱ no̱ he m-arag à. ");
INSERT INTO uth_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","No̱ cu̱we̱ o-hur, kono no̱ ye̱ gwu̱gwu̱-mo̱ u̱r-hur. ");
INSERT INTO uth_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","U̱rege̱ ká den-o̱ shaks no̱, kono no̱ ye̱ Shir 'ye ye̱ she'et-de m-gwu̱gwu̱. Amba u̱rege̱ ye̱ shas no̱ á, Shir a 'ye ká den-o̱ gwu̱gwu̱-mo̱ u̱r-hur á. ");
INSERT INTO uth_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Myet bo̱-o̱ yagu̱ no̱ m-barke̱ à, ko̱ komo wu̱ yage̱ ho̱ge̱ u̱n ma-u̱t no̱ à, kukt no̱ ká hu-mo̱ dape̱ u̱n na-u̱s no̱ à, u̱n co-o̱ u̱n ye̱, no̱ ru u̱n ká hur-o̱ ko̱ ká bo̱-o̱. ");
INSERT INTO uth_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Nip-o̱ me̱ no̱ m-ru̱re̱, da-o̱ Shir he piishe̱ u̱n hun-ne̱ kap u̱t-ma à, Shir a jiish m-ho̱ge̱ u̱n 'wo̱n-de u̱n hun-ne̱ ye̱ o-So̱do̱m u̱n ye̱ o-Gomora ne̱ arge̱ hun-ne̱ ye̱ u̱n ká bo̱-o̱.” ");
INSERT INTO uth_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Ye̱so haaru̱ co u̱n nome̱ u̱n yan-To̱m-ye̱ u̱n wu̱ u̱t-ma. Wu̱ zee, “Me̱ no̱ m-to̱m be-de u̱n yan-me̱n-u̱t jaas-to̱ u̱ntu̱n ye̱ge̱-ca n-me̱ ye̱ge̱-dur. Remen kaane̱ no̱m no̱ u̱s-we̱e̱r u̱ntu̱n ye̱ge̱-hwo̱, komo no̱ nom yan-ba-u̱t-naas u̱ntu̱n ye̱ge̱-gorop. ");
INSERT INTO uth_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","No̱m no̱ ja u̱n hun-ne̱ ne̱, remen ye̱a heet no̱ be-de u̱n gwo̱mo-ne̱, komo ye̱ nomo no̱ u̱s-so̱ro̱g u̱n kuke̱-to̱ u̱n yoos u̱n Ma-to̱ Shir u̱n pyo-se u̱n ye̱ ne̱ se piish u̱t-ma. ");
INSERT INTO uth_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Rem re komo, ye̱a heet no̱ be-de u̱n Gwamna-ne̱ u̱n gwo̱mo-ne̱ ne̱, komo no̱ ko̱'o̱tu̱ ye̱ ma-u̱t re. No̱ ru̱re̱ Yahuda-ne̱ u̱n ye̱ ro̱ Yahuda-ne̱ á. ");
INSERT INTO uth_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Da-o̱ ye̱ heetu̱ no̱, be-de u̱t-gwo̱mo no̱ jar no̱ ryegen n-te̱ u̱n gom-de no̱ he m-ce̱p á, ko̱ bo̱ no̱ he m-ce̱p á. Remen Shir a 'ye no̱ gom-to̱ no̱ he m-ce̱p à, u̱n ká da-o̱. ");
INSERT INTO uth_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Remen no̱ ye̱ ro̱ u̱t-ma á, Ku̱kt-o Tato no̱ Shir o̱ he u̱t-ma be-u̱r no̱. O̱ he no̱ m-ru̱re̱ u̱n yo wu̱ co̱ne̱ no̱ zee à.” ");
INSERT INTO uth_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Ye̱so haaru̱ co m-ze̱e̱, “Ne̱t-wu̱ she̱re̱ be u̱n de á wu̱a ya'as heno u̱n wu̱, wu̱ she̱re̱ be u̱n de à, yan-yage̱-to̱ u̱n wu̱ ho wu̱. Tat-ne̱ a ya'as yakar-ye̱ u̱n ye̱, ye̱ she̱re̱ be u̱n de à. Yakar komo ye̱a ya'as tat-ne̱ u̱n ye̱ ne̱, ye̱ she̱re̱ be u̱n de à har ye̱ ru̱ a hoom tat-ne̱ u̱n ye̱. ");
INSERT INTO uth_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Hun-ne̱ ko̱ kene̱ a yagu̱ no̱ remen no̱ yan-neke̱-m re ye̱. Amba bo̱ u̱n ye̱ jo̱o̱se̱ har ha-mo̱ u̱r-ko̱m à Shir a gu ye̱. ");
INSERT INTO uth_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","U̱rege̱ ye̱ ro̱ no̱ m-'ya u̱r-ko̱o̱b u̱n o̱ ken bo̱-o̱, so̱m no̱ ha-mo̱ u̱n bo̱-o̱ co. Remen nip-o̱ me̱ no̱ m-ru̱re̱, rii-yo no̱ komot m-do̱re̱ u̱n bo̱-to̱ o-Isra war war, me̱ Wà-wu̱ u̱n ne̱t he mu̱u̱n.” ");
INSERT INTO uth_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Ye̱so ze̱e̱ru̱, “Yatt wa-m-yoos wu̱ jiishe̱ wan-yoose̱ u̱n wu̱ á, ko̱ komo ko-gu̱w-wu̱ jiishe̱ wan-hur-o̱ u̱n wu̱ á. ");
INSERT INTO uth_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Depete̱ wu̱ a m-yoose̱ à, wu̱ warag u̱ntu̱n wu̱ ro̱ wu̱ u̱r-yoos à, komo ko-gu̱w u̱ntu̱n wu̱ wu̱ ro̱ m-no̱me̱ m-gu̱w à. U̱rege̱ ye̱ ak me̱ ko-Gwo̱mo-wu̱ u̱n ya-u̱t-ko̱t, arge̱ kaane̱ ma ye̱a eeg no̱ jin-to̱ arge̱ to̱ ka à. Rwo̱ no̱ o-sakto̱ hun-ne̱ a nomo no̱ bo̱ ye̱ nomo me̱ à. Me̱ ro̱ go̱s-wu̱ no̱.” ");
INSERT INTO uth_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Ka da-de Ye̱so ze̱e̱ru̱, “No̱ ho̱ge̱ gye̱r-o̱ u̱n ka hun-ne̱ ye̱ á, remen kap rii-yo ro̱ ho̱kku̱sse̱ m-mo̱ka à, hun-ne̱ a neps yo. ");
INSERT INTO uth_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Komo rii-yo u̱m ru̱ru̱ no̱ ba hun-ne̱ u̱n ho̱ge̱ á, u̱m co̱no̱g no̱ ru̱re̱ ko̱wan ka rii-yo ko̱ kene̱. ");
INSERT INTO uth_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","“No̱ ho̱ge̱ gye̱r-o̱ u̱n hun-ne̱ á. Ye̱a hoks ho u̱n wu̱r-o no̱, amba ye̱a hoks ho u̱n ho̱o̱g-m no̱ á. Se̱ de̱ no̱ ho̱ge̱ gye̱r-o̱ Shir remen wu̱ he m-hoks m-ho o-wu̱r kap m-ho̱o̱g ne̱ wu̱ jorbe̱ u̱n den-o̱ o-ra. ");
INSERT INTO uth_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","No̱a hoks m-o̱ u̱n cokro yoor ne̱ra o-gaan. Yatt ko̱ o-gaan yo he m-mar ba u̱n nap-o̱ u̱n Tato no̱ n-To̱n shir á. ");
INSERT INTO uth_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Ay, can-se u̱n hi-u̱t no̱ ma ogse̱ se ro̱ be-de Shir. ");
INSERT INTO uth_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Remen kaane̱, no̱ ho̱ge̱ o-gye̱r á. Ai, be-de Shir ko wu̱ ke be-u̱r no̱ jiishte̱ kur-de u̱n cokro.” ");
INSERT INTO uth_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Ye̱so ze̱e̱ru̱, “Myet bo̱ u̱n wu̱ ru̱re̱ ye̱ ken hun-ne̱ ye̱ u̱nze wu̱ she̱re̱g be u̱n de à, me̱ u̱n cere man ru̱re̱ Shir Tato re wu̱ ro̱ n-To̱n à, u̱nze ka ne̱t-wu̱, wu̱ ma re wu̱. ");
INSERT INTO uth_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Amba bo̱ u̱n wu̱ no̱me̱ she-mo̱ u̱n nap-u̱s re be-de u̱n hun-ne̱ à, me̱ u̱n cere, man nom she-mo̱ u̱n nap-se u̱n wu̱ be-u̱r Tato re wu̱ ro̱ n-To̱n à.” ");
INSERT INTO uth_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Ye̱so haaru̱ co m-ze̱e̱, “No̱ ma'as m-gwo̱t no̱ zee me̱ u̱n haan u̱m hantu̱té̱ hun-ne̱ she'et-de m-gwu̱gwu̱ u̱n ho̱no o-dak á. Me̱ u̱n haan remen u̱m hantu̱té̱ she'et-de m-gwu̱gwu̱ á, se̱ de̱ u̱t-jongse̱. ");
INSERT INTO uth_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","“Me̱ u̱n haan remen hun-ne̱ ye̱ she̱re̱ be u̱n de á. “ ‘Ye̱a warag yan-yage̱-to̱ u̱n yan-den-to̱ ye̱ she̱re̱ be u̱n de à. U̱ntu̱n kaane̱: o-Tato m-dum u̱n wà u̱n wu̱ ne̱, wan-ne'a komo u̱n inu u̱n wu̱ ne̱, Inu o-den komo u̱n 'ew-wu̱ u̱n wu̱ ne̱. ");
INSERT INTO uth_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Ne̱t a hyen u̱nze yan-yage̱-to̱ u̱n wu̱, ye̱a rwu̱u̱n u̱n den-o̱ u̱n wu̱.’ ” ");
INSERT INTO uth_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Ye̱so ze̱e̱ru̱, “Myet wu̱ jiishe̱ m-co̱n u̱n tato u̱n wu̱ ko̱ inu u̱n wu̱ arge̱ me̱ à, wu̱ bo'os wu̱ warag wan-neke̱-m re á. Komo wu̱ jiishe̱ m-co̱n u̱n wà u̱n wu̱ wan-campo̱ ko̱ wan-ne'a arge̱ me̱ à, wu̱ bo'os m-warag wan-neke̱-m re á. ");
INSERT INTO uth_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Myet komo bo̱ u̱n wu̱ a hoks de̱k u̱n ko̱o̱b-de he m-ko̱r remen dor re á, wu̱ bo̱o̱s wu̱ warag wan-neke̱-m re á. ");
INSERT INTO uth_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Bo̱n wu̱ co̱ne̱ rur u̱n ho̱o̱g-mo̱ u̱n wu̱ à, be-de m-ze̱e̱ wu̱ ba ko-yan-dor re wu̱ á, wu̱a taage̱ u̱n mo̱. Amba bo̱ u̱n wu̱ jore̱ ho̱o̱g-mo̱ u̱n wu̱ rem re à, wu̱a kum ho̱o̱g-o ba m-ta.” ");
INSERT INTO uth_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Ye̱so haaru̱ co m-ze̱e̱, “Myet bo̱ u̱n wu̱ go̱kse̱ no̱ à, wu̱ go̱kstu̱ me̱, komo myet bo̱ u̱n wu̱ go̱ksu̱ me̱ à, wu̱ go̱kste̱ Shir wu̱ to̱mnu̱ me̱ à. ");
INSERT INTO uth_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Myet bo̱ u̱n wu̱ go̱kse̱ wan-Rwo̱r u̱n Ma-to̱ Shir remen wu̱ wan-Rwo̱r u̱n Ma-to̱ Shir wu̱ à, wu̱a kum 'yons-de u̱n wan-Rwo̱r u̱n Ma-to̱ Shir. Komo myet bo̱ u̱n wu̱ go̱kse̱ kashi u̱n ne̱t remen wu̱ ro̱ kashi u̱n ne̱t à, wu̱a kum 'yons-de u̱n kashi u̱n ne̱t. ");
INSERT INTO uth_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Komo myet bo̱ u̱n wu̱ ya'e̱ wan-gaan be-de u̱n ká hun-ne̱ ye̱ à, ko̱ ibitte̱-u̱r gaan-de u̱n ho̱-mo̱ m-gwu̱gwu̱ remen wan-neke̱-m re wu̱, nip-o̱ me̱ no̱ m-ru̱re̱, wu̱a kum 'yons-de u̱n wu̱ be-de Shir.” ");
INSERT INTO uth_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Bo̱ Ye̱so komte̱ ru̱re̱ u̱n yan-neke̱-mo̱ u̱n wu̱ o̱p u̱n yoor 12 ká ma-to̱ à, ka da-de, wu̱ inu̱ru̱ káne̱ wu̱ haaru̱ to̱ ken bo̱-to̱ u̱n dak-o̱ o-Gariri. Wu̱ yoosu̱te̱ hun-ne̱ komo wu̱ ko̱'o̱tu̱ru̱ ye̱ Ma-to̱ Shir. ");
INSERT INTO uth_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Ka da-o̱ Yohana Wa-m-Yo'os u̱n hun-ne̱ m-ho̱ ro ke'o, wu̱ ho̱gu̱ru̱ rem-se Kiristi ro m-no̱m à. Wu̱ to̱mu̱ru̱ yan-neke̱-mo̱ u̱n wu̱ be-u̱r Ye̱so ye̱ citu̱ru̱ wu̱. ");
INSERT INTO uth_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","“¿Wo̱ wu̱ ka wu̱ a zee wu̱ ro̱o̱ne̱, ko̱ te̱ she̱r yish u̱n ho̱r wu̱?” ");
INSERT INTO uth_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Ye̱so shasu̱ru̱ ye̱, “Warag no̱ ru̱re̱ Yohana rii-yo me̱ m-no̱m à, yo no̱ hyane̱ komo u̱n yo no̱ ho̱ge̱ ne̱ à: ");
INSERT INTO uth_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Po̱-ne̱ ro̱ m-kum o-hyan m-mo̱ka. Ryam-ne̱ ro̱ u̱r-hew, cim-ne̱ ro̱ u̱n kum m-po̱rge̱, 'kato̱-ne̱ ro̱ m-ho̱ge̱ u̱t-ma, a m-'yons u̱n ye̱ mare̱ à, komo a m-ko̱'o̱te̱ u̱n ko̱o̱b ne̱ Ma-to̱ m-Re̱re̱m. ");
INSERT INTO uth_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Shir a 'ye bo̱ u̱n ye̱ yage̱ m-warag u̱s-ajima ne̱ à rem re o-kwu̱m.” ");
INSERT INTO uth_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Da-o̱ yan-to̱m Yohana ro̱ m-warag à, Ye̱so ciru̱ru̱ nome̱ u̱n mo̱ro̱g-de u̱n hun-ne̱ ma-u̱t Yohana, wu̱ zee, “¿Ya no̱ ha m-gwo̱t o-ko̱t? ¿Yan go̱n ne̱t-wu̱ no̱ hwo̱ o-sakto̱ no̱ hyen? ¿No̱ u̱n ha gwo̱t u̱n ne̱t-wu̱ ro̱tte̱ jaab-o̱ u̱t-me̱n á, u̱ntu̱n gwo̱-se m-se̱e̱b se yo-m mo̱ m-nakt? ");
INSERT INTO uth_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Ai, u̱rege̱ no̱ ha m-gwo̱t u̱n ne̱t-wu̱ ro̱tte̱ jaab-o̱ u̱t-me̱n á, ¿to̱ yan go̱n ne̱t-wu̱ no̱ ha m-gwo̱t? ¿No̱ u̱n zee no̱a hyen ne̱t-wu̱ co̱pe̱ matuku-to̱ u̱r-bon? Ay, hun-ne̱ ye̱ u̱n hur-o̱ u̱n ko-Gwo̱mo, ye̱ ro̱ m-co̱p u̱n matuku-to̱ u̱r-bon ba ye̱ ro̱ o-ko̱t á. ");
INSERT INTO uth_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","¿Remen yan o̱ no̱ heete̱ no̱ hyenet Yohana o-ko̱t? ¿No̱ u̱n hwo̱ o-sakto̱ no̱ hyen wan-rwo̱r u̱n Ma-to̱ Shir? E̱e̱, kaane̱ o̱ me̱ no̱ m-ru̱re̱ har wu̱ jiishte̱ wan-rwo̱r u̱n Ma-to̱ Shir à. ");
INSERT INTO uth_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Yohana wu̱ Ma-to̱ Shir ce̱pe̱ ma-to̱ u̱n wu̱, be-de Shir zee Wà u̱n wu̱, “ ‘Man tom wan-to̱m re wu̱ be wo̱ co. Wu̱ he wo̱ ja'ase̱ o-co̱w rii-yo o woot.’ ” ");
INSERT INTO uth_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Ye̱so ze̱e̱ru̱, “Nip-o̱ me̱ no̱ m-ru̱re̱, Yohana Wa-m-Yo'os u̱n hun-ne̱ m-ho̱ jiishte̱ bo̱n ne̱t-wu̱ take̱ m-she'et u̱n ho̱no o-dak à u̱t-go̱s. Amba myet u̱n kaane̱ ne̱, wu̱ ro̱ re̱k-wu̱ war war u̱n gwo̱mo-to̱ Shir à, wu̱ jiishte̱ wu̱. ");
INSERT INTO uth_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Cin u̱n da-o̱ Yohana Wa-m-Yo'os u̱n hun-ne̱ m-ho̱ takne̱ se̱nge̱-mo̱ u̱n wu̱ à har caane̱, Gwo̱mo-to̱ Shir ro̱ m-bo̱se̱ n-me̱ m-'wo̱ns. Amba hun-ne̱ ye̱ ro̱ zang à, ye̱ co̱no̱g to̱ m-rumus u̱r-be̱e̱b. ");
INSERT INTO uth_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Yan-rwo̱r u̱n Ma-to̱ Shir kap o-karamsa ne̱ rwo̱ro̱g cin ba da-o̱ u̱n wo̱o̱n mo̱sse̱ u̱n gwo̱mo-to̱ Shir ne̱, har da-o Yohana Wa-m-Yo'os u̱n hun-ne̱ m-ho̱. ");
INSERT INTO uth_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Komo u̱rege̱ ma-to̱ u̱n ye̱ no̱ he m-de̱k, Yohana wu̱ a no̱me̱ ma-to̱ u̱n wu̱ u̱n zee E̱reja he m-mu̱u̱n. ");
INSERT INTO uth_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Yage̱ wan-tó̱-tò̱ m-ho̱ge̱, wu̱ ho̱gu̱te̱ yo me̱ m-rwo̱r à.” ");
INSERT INTO uth_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Komo Ye̱so ze̱e̱ru̱, “Man ru̱ru̱ no̱ rii-yo no̱ ro̱ à, hun-ne̱ ye̱ m-mo̱ka. Ya no̱ ro̱ u̱ntu̱n yakar-ye̱ ro̱ tara tara be-de u̱t-baab à, ye̱ ro̱ u̱n eeg-se u̱n yan-se̱'e̱r-mo̱ u̱n ye̱, ");
INSERT INTO uth_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","ye̱ ro̱ m-ze̱e̱: “ ‘Te̱ bu'utu no̱ dum-to̱ u̱t-ge, no̱ yage̱ m-he̱w u̱s-he̱w! Te̱ huug se̱p-o̱ m-mar, no̱ yage̱ m-'wo̱n u̱s-'wo̱n!’ ");
INSERT INTO uth_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Me̱ u̱n zee kaane̱ remen bo̱ Yohana haane̱ à, wu̱ ro̱ u̱n no̱m o-swo̱o̱t de̱e̱n, wu̱ ro̱ m-swo̱ u̱n ho̱-mo̱ o-anab á. Remen kaane̱ no̱ ze̱e̱ru̱, ‘Wu̱ ro̱ u̱n ko-ya-u̱t-ko̱t ne̱!’ ");
INSERT INTO uth_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Amba da-o̱ me̱, Wà-wu̱ u̱n ne̱t, me̱ m-re̱ m-swo̱ ne̱. Ye̱ ze̱e̱ru̱ me̱, ‘Gwo̱t no̱ wu̱, ko-yan-mo̱o̱r-to̱ m-re̱ m-swo̱ ne̱. Ko-nay-wu̱ u̱n yan-go̱ks u̱n tar u̱n ya-u̱r-ba'as ne̱!’ Da-o̱ hun-ne̱ ye̱ no̱me̱ u̱s-barag u̱n ka rem-se te̱ m-no̱m à, ye̱a nep we̱e̱r-u̱s te̱.” ");
INSERT INTO uth_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Ka da-de Ye̱so ciru̱ru̱ hurgun hun-ne̱ ye̱ u̱n ká bo̱-to̱ to̱ wu̱ nomte̱ mo̱o̱r-to̱ u̱t-hyat à, u̱t-gaag ba m-so̱k. Ye̱so u̱n nom kaane̱ remen ká hun-ne̱ ye̱ yage̱ no̱m u̱r-ba'as á. ");
INSERT INTO uth_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Shir a 'ye no̱ u̱r-ko̱o̱b hun-ne̱ ye̱ o-Korazin! Kaane̱ komo Shir a 'ye no̱ u̱r-ko̱o̱b hun-ne̱ ye̱ u̱n bo̱-o̱ o-Besayada! Remen kà rii-yo u̱t-hyat yo a no̱me̱ be u̱n no̱ à. A ro nomge̱ yo u̱n bo̱-to̱ o-Taya o-Sidon ne̱, ye̱ roa waktu̱ne̱ be-de Shir. Komo ye̱ cu̱p gund-to̱ u̱n naasu̱-mo̱ u̱t-me̱n, ye̱ aas m-co̱w u̱n wu̱r-to̱ u̱n ye̱ cin o-da ne̱. ");
INSERT INTO uth_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Amba me̱ no̱ m-ru̱re̱, u̱n ho̱-de u̱n piish u̱t-ma a jiish m-ho̱ge̱ u̱n 'wo̱n-de u̱n hun-ne̱ ye̱ o-Taya u̱n ye̱ o-Sidon ne̱ arge̱ no̱. ");
INSERT INTO uth_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","“No̱ komo hun-ne̱ ye̱ u̱n bo̱-o̱ o-Kapanahum, taase no̱ hyen no̱ zee Shir a se̱ke̱msu̱ no̱ wu̱ deet no̱ n-To̱n shir. Ayye, su̱ge̱-de u̱n kaane̱ Shir a jorbu̱ no̱ u̱n kuub-o̱ o-ra! Rem-se u̱t-hyat se u̱m no̱me̱ be u̱n no̱ à, me̱ ro nomge̱ se o-So̱do̱m, atte̱ ze̱e̱g o̱ ro̱ ko̱n kane̱ har caane̱. ");
INSERT INTO uth_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Amba me̱ no̱ m-ru̱re̱ u̱n ho̱-de u̱n piishe̱ u̱n hun-ne̱ u̱t-ma, a jiish m-ho̱ge̱ u̱n 'wo̱n-de u̱n hun-ne̱ ye̱ o-So̱do̱m arge̱ no̱. Remen no̱ hyenestu̱ me̱ m-no̱m u̱n rem-se u̱t-hyat, amba no̱ waktu̱ne̱ be-de Shir á.” ");
INSERT INTO uth_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","U̱n ka da-o̱ Ye̱so zee Shir, “U̱m bo̱mo̱g wo̱, o-Tato, Wan-Ko̱yan wu̱ n-To̱n shir o-dak ne̱. U̱m bo̱mo̱g wo̱ remen o wukute̱ ya-u̱s-we̱e̱r u̱n ya-u̱s-nap ne̱. Nap u̱n ka hyat-to̱ komo o argu̱ m-ru̱re̱ u̱n ka ye̱ she̱re̱ be u̱n du à u̱ntu̱n yan-yakar. ");
INSERT INTO uth_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Kaane̱ nomo wo̱ Tato re o̱, remen kaane̱ no̱mu̱ wo̱ m-so̱k.” ");
INSERT INTO uth_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Bo̱ Ye̱so komte̱ u̱s-ko̱n be-de Shir à, ka da-de wu̱ nomu̱ru̱ hun-ne̱ u̱t-ma. “Tato re, Shir ya'ag me̱ nap-se u̱n ko̱yan. Komo yatt-wu̱ nape̱ Wà á se̱ o-Tato o̱ nape̱ wu̱. Komo yatt-wu̱ nape̱ Shir o-Tato á se̱ Wà, komo bo̱ u̱n ka hun-ne̱ ye̱, ye̱ me̱ Wà-wu̱ Shir co̱ne̱ wu̱ kute̱ ye̱ o-Tato à, komo ye̱ nept bo̱ Shir ro̱ à. ");
INSERT INTO uth_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Haan no̱ be u̱n de, myet no̱ ye̱ ro̱ m-swo̱ u̱r-ko̱o̱b à, komo no̱ m-se̱nge̱ u̱n saw-to̱ u̱s-nu̱ ne̱ u̱n hi-u̱t no̱, man 'ye no̱ u̱r-wu̱we̱. ");
INSERT INTO uth_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Go̱ks no̱ ma-u̱t re, komo no̱ yoos be u̱n de, remen me̱ ko-yan-gwu̱gwe̱r-mo̱ u̱r-hi wu̱, wu̱ ro̱tte̱ m-nu̱ á komo no̱a kum u̱r-wu̱we̱ u̱n hur-u̱r no̱. ");
INSERT INTO uth_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Remen ma-u̱t re ro̱tt rem á, komo saw-u̱t re to̱ ro̱tt u̱s-nu̱ á.” ");
INSERT INTO uth_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","U̱n ka da-o̱, Ye̱so u̱n yan-neke̱-mo̱ u̱n wu̱ ne̱ ro u̱n pa u̱n kat-to̱ u̱n hyo, u̱n Ho̱-de u̱r-Wu̱we̱ de u̱n Yahuda-ne̱. Yan-neke̱-mo̱ u̱n wu̱ ro u̱n ho̱ge̱ u̱n me̱r, ye̱ ze̱e̱ru̱ horom u̱n hyo, ye̱ ro m-ti. ");
INSERT INTO uth_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Bo̱ Parisa-ne̱ hyente̱ ye̱ m-no̱m kaane̱ à, ye̱ ze̱e̱ru̱ Ye̱so, “Gwo̱t, yan-neke̱-m ru ye̱ ro̱ m-no̱m u̱n rii-yo karamsa-o we̱ne̱ a no̱m u̱n Ho̱-de u̱r-Wu̱we̱ à!” ");
INSERT INTO uth_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Ye̱so ze̱e̱ru̱ ye̱, “Baks no̱ yo no̱ karante̱ à, rii-yo Dawuda no̱me̱ da-o̱ wu̱ u̱n o̱r u̱n wu̱ ne̱ ro u̱n ho̱ge̱ u̱n me̱r á. ");
INSERT INTO uth_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Wu̱ co̱wo̱g u̱n De̱pi-o̱ u̱n Shir wu̱ re̱e̱ru̱ ga-de a m-pa à, de depe̱ wu̱, ko̱ o̱r u̱n wu̱ ne̱ ye̱ re de á, se̱ de̱ yan-Co̱w u̱n ko̱n-se Shir cot. ");
INSERT INTO uth_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Komo baks no̱ yo no̱ karante̱ n-me̱ u̱n karamsa-o Mosa à, yo yan-Co̱w u̱n ko̱n-se Shir ro̱ m-no̱m u̱n Ho̱-de u̱r-Wu̱we̱ u̱n Pyo-o̱ Shir à. Be-de u̱n seke̱ u̱t-seke̱ u̱n De̱pi-o̱ u̱n Shir, ye̱ ro̱ m-jet o-karamsa o̱ u̱n Ho̱-de u̱r-Wu̱we̱, o̱ we̱ne̱ hun-ne̱ m-se̱nge̱ u̱n Ho̱-de u̱r-Wu̱we̱ à. Amba Shir zee ye̱ no̱mo̱g u̱r-ba'as á. ");
INSERT INTO uth_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Me̱ no̱ m-ru̱re̱, wu̱ arge̱ Pyo-o̱ Shir à, ro̱ kane̱. ");
INSERT INTO uth_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Amba no̱ nap rii-yo ka Ma-to̱ Shir to̱ ro̱ m-rwo̱r á, u̱nze, ‘U̱m jiishte̱ co̱n u̱n hun-ne̱ ho̱ge̱ 'wo̱n-u̱r o̱r ru ye̱ ne̱, o̱tte̱ ye̱ seke̱ me̱ u̱r-seke̱ à.’ No̱ ro nakke̱ yo ka, no̱ roa zee yan-neke̱-m re no̱mo̱g u̱r-ba'as á. ");
INSERT INTO uth_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Yan-neke̱-m re no̱m u̱r-ba'as á. Remen me̱ Wà-wu̱ u̱n ne̱t, komo Shir ya'ag me̱ u̱r-be̱e̱b u̱m deeg yo u̱r-bon u̱n yo ba u̱r-bon ne̱ u̱n Ho̱-de u̱r-Wu̱we̱.” ");
INSERT INTO uth_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Ye̱so u̱n yan-neke̱-mo̱ u̱n wu̱ ne̱ yagu̱ru̱ ká riib-o kat-o̱. Ye̱ co̱wu̱ru̱ u̱n kuke̱-o̱ u̱n yoos u̱n Ma-to̱ Shir u̱n ká be-de. ");
INSERT INTO uth_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Wu̱ ken ne̱t-wu̱ ro kon kane̱ ko-yan-kom-o margan. Wu̱ ro̱ m-hoks m-nukt u̱n ka kom-o̱ á. Parisa-ne̱ ro u̱n hoob-o̱ u̱n bo̱ ye̱ he Ye̱so m-ce̱e̱b à. Ye̱ citu̱ru̱ wu̱ ka cot-o̱, “¿Karamsa-o̱ u̱n Yahuda-ne̱ ya'ag a taase ne̱t go̱m u̱n Ho̱-de u̱r-Wu̱we̱?” Ye̱ u̱n cit ká cot-o̱ remen ye̱ bu̱pt wu̱ u̱r-ba'as. ");
INSERT INTO uth_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Ka da-de Ye̱so citu̱ru̱ ye̱. Wu̱ zee, “A zee wu̱ ken wu̱ be-u̱r no̱ ro̱ o-ca ne̱ o-gaan cot. Yo porumbu̱ru̱ n-me̱ o-kuub u̱n Ho̱-de u̱r-Wu̱we̱. ¿Ya wan ká ca-yo he m-no̱m? ");
INSERT INTO uth_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Wu̱a hu̱s yo! Ai, ne̱t jiishte̱ o-ca de̱e̱n! Remen kaane̱, karamsa-o o̱ we̱n no̱m u̱n rii so̱-yo u̱n Ho̱-de u̱r-Wu̱we̱ á.” ");
INSERT INTO uth_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Ka da-de Ye̱so ze̱e̱ru̱ ká ne̱t-wu̱, “Tapan kom-o ru o-margan.” Wu̱ tapnu̱ru̱ kom-o̱ u̱n wu̱. U̱n gyept-o̱ u̱n yish, o̱ wargu̱ru̱ u̱ntu̱n o̱r u̱n o̱ kom-o̱. ");
INSERT INTO uth_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Amba Parisa-ne̱ ruuru̱, ye̱ to̱o̱ru̱ u̱t-hun, bo̱ ye̱ he m-no̱m ye̱ hoot Ye̱so à. ");
INSERT INTO uth_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Bo̱ Ye̱so nepte̱ yo Parisa-ne̱ ro̱ o-hoob à kaane̱ o̱ à, wu̱ argu̱ m-yage̱ u̱n ká be-de. Hun-ne̱ u̱t-mo̱o̱r ne̱ do̱ru̱ru̱ wu̱, wu̱ taasu̱ ye̱ go̱m-se u̱n ye̱ kap. ");
INSERT INTO uth_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Komo wu̱ ka'agu̱ ye̱ taase ye̱ ru̱re̱ ye̱ ken hun-ne̱ ye̱ ma-to̱ u̱n wu̱ á. ");
INSERT INTO uth_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","A u̱n no̱m to̱ ka remen a shoosté̱ rii-yo a rwo̱re̱ u̱n nu-o̱ u̱n wan-Rwo̱r u̱n Ma-to̱ ShirIshaya à u̱nze, ");
INSERT INTO uth_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Shir ze̱e̱g ko-yan-gu̱w-m re wu̱ ka, wu̱ u̱m daage̱ à, wu̱ me̱ m-co̱n à. Komo hur u̱n de ro̱ gwu̱gwu̱ u̱n wu̱ ne̱. Man shoos wu̱ u̱n Ku̱kt-o re, komo wu̱a ko̱'o̱t u̱nze Shir a piishe̱ myet hun-ne̱ ye̱ u̱n ho̱no o-dak u̱t-ma bo̱ depe̱ à. ");
INSERT INTO uth_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ma-u̱t a su̱nu̱ wu̱ u̱n ne̱t ne̱ á, ko̱ ce̱p u̱n ma-to̱ u̱r-be̱e̱b á. A ho̱ge̱ cor-o̱ u̱n wu̱ o-zang á. ");
INSERT INTO uth_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Ko-gu̱w re wan-gwu̱, wu̱a ho̱ge̱ u̱r-'wo̱n. Wu̱a bu̱se̱ kang-o̱ ro̱ u̱n he de m-jesse̱ á, Wu̱a gu hun-ne̱ ye̱ ro̱ u̱n hoks u̱n gu u̱n hi u̱n de u̱n ye̱ á. Wu̱a he co u̱n ho̱ge̱ u̱r-'wo̱n har da-o̱ rii-yo u̱r-bon re̱ co-o̱ u̱n yo ba u̱r-bon à, se̱ de̱ wu̱ ru̱ nip-o̱ reet u̱r-ho̱. ");
INSERT INTO uth_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Hun-ne̱ ye̱ u̱n ho̱no o-dak u̱n ye̱ ro̱ Yahuda-ne̱ á, ye̱a ru̱ u̱r-hur u̱n jin-de u̱n wu̱.” ");
INSERT INTO uth_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Ye̱ ken hun-ne̱ ye̱ hantu̱ru̱ Ye̱so wu̱ ken ko-'kato̱ wu̱ ko-po̱, wu̱ ro u̱n ya-u̱t-ko̱t ne̱. Komo Ye̱so taasu̱ go̱m-se u̱n wu̱ kap, u̱n ruut u̱n ya-u̱t-ko̱t har ká ne̱t-wu̱ te̱pru̱ru̱, komo wu̱ hyanu̱ru̱. ");
INSERT INTO uth_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Hun-ne̱ kap ye̱ bo̱pu̱ru̱ nu-se u̱n ye̱, remen rii-yo Ye̱so no̱me̱ à. Ye̱ ze̱e̱ru̱ hi u̱n de u̱n ye̱, “¿Ashi, wu̱ ka wu̱ ka ro̱ wà Dawuda à?” ");
INSERT INTO uth_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Amba bo̱ Parisa-ne̱ ho̱gu̱te̱ rii-yo no̱me̱ à u̱n rii-yo hun-ne̱ ro̱ m-ze̱e̱ ne̱ kane̱ à, ye̱ ze̱e̱ru̱ hi u̱n de u̱n ye̱, “Ay, yo rwo̱'e̱ ka ne̱t-wu̱ ro̱tte̱ u̱n ruut u̱n ya-u̱t-ko̱t à, ko-Gwo̱mo-wu̱ u̱n ya-u̱t-ko̱tBeru̱zabur, wu̱ ya'e̱ wu̱ be̱e̱b-de m-no̱m káane̱.” ");
INSERT INTO uth_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Bo̱ Ye̱so nepste̱ rii-yo ye̱ ro̱ u̱s-barag à, wu̱ ze̱e̱ru̱ ye̱, “Myet bo̱-o̱ hun-ne̱ ye̱ u̱n o̱ pu̱rge̱ be-u̱t yoor à, ye̱ ro̱ m-dum u̱n hi u̱n de u̱n ye̱ à, ká bo̱-o̱, o̱a sabu̱rse̱ hi u̱n de u̱n o̱. Komo hur-o̱ hun-ne̱ ye̱ u̱n o̱ ro̱ u̱t-ween à, ká hur-o̱, o̱a gos á. ");
INSERT INTO uth_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Komo co̱w-o gaan-yo, u̱rege̱ ko-Gwo̱mo-wu̱ u̱n ya-u̱t-ko̱t wu̱ ro̱ m-ruute̱ u̱n hun-ne̱ ya-u̱t-ko̱t, a nom o̱ ka ko-Gwo̱mo-wu̱ u̱n ya-u̱t-ko̱t ro̱ hi u̱n du u̱n wu̱ m-dum. ¿To̱ re ne̱ gwo̱mo-to̱ u̱n wu̱ he m-no̱m to̱ gost? ");
INSERT INTO uth_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","¿U̱rege̱ u̱n be̱e̱b-u̱r Beru̱zabur me̱ m-ruut u̱n ya-u̱t-ko̱t, to̱, yan-neke̱-m no̱ ne̱ u̱n be̱e̱b-u̱r wan ye̱ ro̱ ye̱ m-ruute̱? ¿U̱n be̱e̱b-de u̱n ko-Gwo̱mo-wu̱ u̱n ya-u̱t-ko̱t? Ay! Remen kaane̱, yan-neke̱-m no̱ ye̱ he no̱ piishe̱ u̱n to̱ ka ma-to̱. ");
INSERT INTO uth_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Amba Ku̱kt-o̱ Shir o̱ ya'u̱ me̱ be̱e̱b-de u̱n ruut u̱n ya-u̱t-ko̱t, ashi, yo ka kututu̱ no̱ u̱nze be̱e̱b-de Shir de u̱t-gwo̱mo haante̱ be u̱n no̱. ");
INSERT INTO uth_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Ko̱ a zee komo co̱w-o gaan-yo m-co̱w u̱n hur-o̱ u̱n ne̱t-wu̱ u̱r-be̱e̱b a rumusté̱ saw-to̱ u̱n wu̱. Se̱ a ke'este̱ ká ko-be̱e̱b-wu̱ tokon, ka da-o̱ a hoks m-rumus u̱n saw-to̱ u̱n ká ko-be̱e̱b-wu̱. U̱m jiishte̱ ko-Gwo̱mo-wu̱ u̱n ya-u̱t-ko̱t u̱r-be̱e̱b, o̱ rwo̱'e̱ me̱tte̱ u̱n ruute̱ u̱n hun-ne̱ ya-u̱t-ko̱t. ");
INSERT INTO uth_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Bo̱n ne̱t-wu̱ ro̱ be u̱n de á, ko-Gwo̱mo-wu̱ u̱n ya-u̱t-ko̱t wu̱ ro̱ m-do̱re̱. Bo̱n wu̱ yagu̱ me̱ gu u̱n hante̱ u̱n hun-ne̱ be-de Shir à, yan-se u̱n ye̱ wu̱ ro̱tte̱. ");
INSERT INTO uth_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","“Remen kaane̱ me̱ no̱ m-ru̱re̱, Shir a hoks sokse̱ u̱n hun-ne̱ ko-yan-go̱n ba'as-de ye̱ nome̱ hun-ne̱ à, u̱n ma-to̱ u̱n yo'og-o̱ Shir ne̱. Amba Shir a sokse̱ hun-ne̱ ye̱ no̱me̱ ma-to̱ o-yo'og mo̱sse̱ u̱n Ku̱kt-o̱ Shir ne̱ á. ");
INSERT INTO uth_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Bo̱n wu̱ pyapu̱ me̱ à, me̱ Wà-wu̱ u̱n ne̱t Shir a soks ba'as-de u̱n wu̱. Amba myet wu̱ pyape̱ Ku̱kt-o̱ Shir à, Shir a soksu̱ wu̱ ba'as-to̱ u̱n wu̱ á, m-mo̱ka har ko̱ ya nomot.” ");
INSERT INTO uth_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Ye̱so haaru̱ co m-ze̱e̱, “'Yo-yo u̱r-bon yo ro̱ u̱n mat u̱n yakar-ye̱ u̱r-bon. Amba 'Yo-yo ba u̱r-bon komo yo matu̱ru̱ yakar-ye̱ ba u̱r-bon. O-'yo de̱, u̱n go̱n yakar-ye̱ u̱n yo atte̱ yo m-nap. ");
INSERT INTO uth_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","No̱ ye̱ge̱-hwo̱ yo̱-ye̱, remen no̱ ro̱ yo̱-ye̱, no̱ hoks ce̱p u̱n ma-u̱t so̱-to̱ á. Ai, rii-yo ro̱ n-me̱ u̱r-hur à yo ro̱ m-rwu̱u̱n o-nu. ");
INSERT INTO uth_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Kashi u̱n ne̱t ro̱ m-rwu̱nte̱ u̱n rii-yo u̱r-bon. Ne̱t yo̱-wu̱ komo wu̱ ro̱ m-rwu̱nte̱ rii yo̱-yo. ");
INSERT INTO uth_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Me̱ no̱ m-ru̱re̱, kap ho̱n u̱n ma-to̱ o-hwaa to̱ hun-ne̱ ro̱ m-no̱m à, se̱ Shir rwo̱'o̱g ye̱ ogom-de u̱n to̱ u̱n ho̱-de u̱n piish u̱t-ma. ");
INSERT INTO uth_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","U̱n go̱n ma-u̱t ru Shir hette̱ wo̱ piishe̱ u̱t-ma, u̱rege̱ o rwo̱ro̱g rii-yo u̱r-bon, Shir a zee wo̱ kashi u̱n ne̱t. Amba u̱rege̱ o rwo̱ro̱g ma-u̱t yo̱-to̱, Shir a zee wo̱ ko-ya-u̱r-ba'as.” ");
INSERT INTO uth_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Ye̱ ken ye̱ n-me̱ u̱n yan-Yoos-de o-karamsa u̱n Parisa-ne̱ ze̱e̱ru̱ Ye̱so, “Wa-u̱r-Yoos, te̱ co̱no̱g o nom yo ken rii-yo o-made̱ yo, yo kutu te̱ u̱nze Shir to̱mnu̱ wo̱.” ");
INSERT INTO uth_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Ye̱so shasu̱ru̱ ye̱, “Yan-me̱n-u̱t jaas-to̱ u̱n yan-ba-m-she̱r ne̱, ye̱ ro̱ m-co̱n a nomo ye̱ o-made̱ remen ye̱ nept be-de Shir u̱m rwu̱u̱ne̱. Amba man nomo no̱ o̱ ken made̱-o̱ á, se̱ de̱ o̱ ma Yunanawan-Rwo̱r u̱n Ma-to̱ Shir. ");
INSERT INTO uth_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Yunana no̱mo̱g ho̱-u̱t tet, te̱t-m tet, n-me̱ u̱n ku̱t-o̱ u̱n caari-o̱ o-jan. Káane̱ me̱ Wà-wu̱ u̱n ne̱t a he me̱ m-jo̱k ho̱-u̱t tet, m-te̱t, m-ho̱w ne̱ n-dak. ");
INSERT INTO uth_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","“U̱n ho̱-de u̱n piish u̱t-ma, hun-ne̱ ye̱ o-Neneba ye̱a ine̱ be-u̱r gaan u̱n hun-ne̱ ye̱ u̱n kà zaman-yo ne̱. Hun-ne̱ ye̱ o-Neneba ye̱a zee hun-ne̱ ye̱ u̱n ka zaman-yo, ye̱ no̱m rii-yo u̱r-bon á. Remen hun-ne̱ ye̱ o-Neneba waktu̱nte̱ be-de Shir ye̱ yage̱ u̱r-ba'as da-o̱ Yunana ru̱ru̱ ye̱ Ma-to̱ Shir à. Wu̱ jiishe̱ Yunana à wu̱ ka kàne̱, amba da-o̱ no̱ ho̱ge̱ ma-u̱t re à, no̱ yage̱ no̱m u̱r-ba'as á. ");
INSERT INTO uth_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","U̱n ho̱-de u̱n piish u̱t-ma, ko-Gwo̱mo-wu̱ o-Sheba ne'a, wu̱a ine̱ be-u̱r gaan u̱n hun-ne̱ ye̱ u̱n ka zaman-yo ne̱, wu̱ kutute̱ ye̱, u̱nze ye̱ no̱mo̱g rii-yo ba m-so̱k. Remen wu̱ indu̱nte̱ u̱r-hew ne̱, remen wu̱ ho̱gu̱te̱ wu̱ do̱re̱ yoos-de u̱s-we̱e̱r de ma ko-Gwo̱mo Suremanu. Wu̱ jiishe̱ ne̱ Suremanu à wu̱ ka kàne̱ m-mo̱ka, amba no̱ ho̱ge̱ wu̱ á.” ");
INSERT INTO uth_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Ye̱so haaru̱ co m-ze̱e̱, “A ruute̱ ko-ya-u̱t-ko̱t u̱n wu̱r-o̱ u̱n ne̱t. Yo ro̱ m-ma'as u̱t-tu̱w u̱n be-to̱ ba m-ho̱. Yo ro̱ u̱n hoob-o̱ u̱n be-de u̱r-wu̱we̱. Amba u̱rege̱ yo kum á, ");
INSERT INTO uth_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","ka ko-ya-u̱t-ko̱t yo ro̱ m-ze̱e̱, ‘Man warag u̱n hur-o re o̱ n-ga be-de u̱m rwu̱u̱ne̱ à, u̱m she'et kane̱.’ Da-o̱ yo mu̱u̱ne̱ yo 'wo̱s rii ro̱ ko̱n á, komo yo hyanu̱ru̱ a wishishsu̱te̱, a jamasse̱ o-hur cas, amba ne̱t ro̱ n-me̱ á. ");
INSERT INTO uth_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Ka da-o̱ yo haaru̱ yo bandu̱ru̱ ya-u̱t-ko̱t ne̱n ta'yoor, ye̱ jiishe̱ yo m-zwo̱m à. Kap kà ya-u̱t-ko̱t ye̱, ye̱a cu̱w, ye̱ she'et káne̱ be-de u̱n ká ne̱t-wu̱. U̱r-ko̱m, she'et-de u̱n ká ne̱t-wu̱ dea jiish de n-ga m-yo̱. Káane̱ ma he m-wakte̱ u̱n hun-ne̱ ye̱ u̱n ka zaman-yo ne̱ yan-me̱n-u̱t jaas-to̱.” ");
INSERT INTO uth_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Ye̱so ro̱ u̱t-ma u̱n hun-ne̱ ne̱ ye̱ ro̱ be-de u̱n wu̱ à, inu-o Ye̱so u̱n hen-ne̱ ye̱ u̱n wu̱ ne̱ wo̱o̱nu̱ru̱. Ye̱ ro eso n-do̱. Ye̱ co̱no̱g u̱t-ma u̱n wu̱ ne̱. ");
INSERT INTO uth_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Wu̱ ken wu̱ ze̱e̱ru̱ Ye̱so, “Inu ru u̱n hen-ne̱ ru ne̱ ro̱ eso n-do̱, ye̱ co̱no̱g u̱t-ma u̱n wo̱ ne̱.” ");
INSERT INTO uth_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Ye̱so ze̱e̱ru̱ ká wu̱ ru̱ru̱ wu̱ à, “¿Wan wu̱ ne̱ ro̱ u̱ntu̱n inu re? ¿Komo wan-ne̱ ye̱, ro̱ u̱ntu̱n hen-ne̱ re?” ");
INSERT INTO uth_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Wu̱ kutu̱ru̱ ye̱ yan-neke̱-mo̱ u̱n wu̱ u̱n kom-o̱ u̱n wu̱. Wu̱ ze̱e̱ru̱, “Ye̱ ka ye̱ ro̱ u̱ntu̱n inu re u̱n hen-ne̱ re ne̱. ");
INSERT INTO uth_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Remen kap o̱ u̱n wu̱ no̱me̱ rii-yo Tato re wu̱ ro̱ n-To̱n shir co̱ne̱ à, wu̱ ro̱ heno re, wan-campo̱ ko̱ wan-ne'a ko̱ komo inu re.” ");
INSERT INTO uth_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","U̱n ká ho̱-de, Ye̱so ruuru̱ cin o-hur, wu̱ haaru̱, wu̱ she'etu̱ru̱ u̱n riib-o̱ o-mar. ");
INSERT INTO uth_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Bu̱u̱g-de u̱n hun-ne̱ de̱e̱n kargu̱ru̱, ye̱ katu̱ wu̱ ge̱w, har wu̱ kum be-de m-she'et wu̱ yoosu̱tú̱ ye̱ á. Remen kaane̱ wu̱ co̱wu̱ru̱ hat-o̱ m-ho̱ wu̱ she'etu̱ru̱, bu̱u̱g-de u̱n hun-ne̱ u̱t-mo̱o̱r ne̱ komo ye̱ e̱su̱ru̱ n-riib o̱ o-mar. ");
INSERT INTO uth_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Ka da-de wu̱ yoosu̱ru̱ ye̱ u̱s-rem de̱e̱n u̱n sha-mo̱ u̱t-ma, u̱ntu̱n kàane̱, “Wu̱ ken ko-ya-o-to̱m wu̱ haag o-kat remen wu̱ goot u̱r-go. ");
INSERT INTO uth_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Bo̱ wu̱ rotte̱ u̱r-go à, ye̱ ken go̱'-ye̱ 'he̱nu̱ru̱ n-riib u̱n co̱w. Ye̱ge̱-no haaru̱, ye̱ co̱rgu̱ru̱ ye̱. ");
INSERT INTO uth_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Ye̱ ken ye̱ komo ye̱ he̱nu̱ru̱ u̱n be-de m-ta'ar be-de ba m-hu de̱e̱n. Ye̱ argu̱ m-po̱t ho̱r-m-ho̱r remen hu-mo̱ u̱n ká be-de ro̱ de̱e̱n á. ");
INSERT INTO uth_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Bo̱ ho̱-u̱r dakante̱ no̱o̱nho̱ à, ye̱ argu̱ m-rya har ye̱ hwo̱'u̱ru̱, remen ye̱ ro̱tt u̱s-geer de̱e̱n á. ");
INSERT INTO uth_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Ye̱ ken ye̱ komo ye̱ 'he̱nu̱ru̱ n-me̱ u̱n yokor. Ye̱ge̱-yokor indu̱ndu̱ru̱, ye̱ we̱nu̱ru̱ ye̱ m-bo̱'o̱se̱. ");
INSERT INTO uth_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Ye̱ ken ye̱ komo ye̱ 'he̱nu̱ru̱ u̱n be-de u̱r-bon. Ye̱ bo̱su̱ru̱, ye̱ rwo̱'u̱ru̱ yish o-zungu 100, ye̱ ken ye̱ kwo̱o̱z-u̱t tet 60, ye̱ ken ye̱ u̱r-kwo̱o̱z u̱n o̱p 30. ");
INSERT INTO uth_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Kap wu̱ ro̱ u̱t-to̱ ne̱ to̱ m-ho̱ge̱ à, wu̱ ho̱ge̱.” ");
INSERT INTO uth_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Yan-neke̱-m Ye̱so haanu̱ru̱, ye̱ ze̱e̱ru̱ wu̱, “¿Remen yan o̱ wo̱tte̱ ye̱ m-no̱me̱ u̱t-ma u̱n sha-mo̱ u̱t-ma?” ");
INSERT INTO uth_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Ye̱so shasu̱ru̱ ye̱, “Shir dak no̱, no̱ ye̱ she̱re̱ be-de u̱n wu̱ à, remen no̱ hoksté̱ m-nap u̱n yo ka. Ye̱ she̱re̱ be-de u̱n wu̱ á, ye̱a hoks m-nap mo̱sse̱ u̱n gwo̱mo-to̱ Shir ne̱ á. ");
INSERT INTO uth_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Amba kap bo̱n ye̱ ro̱ m-raag u̱t-to̱ u̱n yoos u̱n de à, Shir a do̱ ye̱ u̱s-nap, komo ye̱a kum u̱s-nap de̱e̱n. Amba ka ye̱ yage̱ m-raag u̱t-to̱ u̱n yoos u̱n de á, ko̱ ka ya-o-nap yo ye̱tte̱ ne̱ à, Shir a rumus yo be-de u̱n ye̱. ");
INSERT INTO uth_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Rii-yo rwo̱'e̱ me̱ttu̱ ye̱ m-no̱me̱ u̱t-ma u̱n sha-mo̱ u̱t-ma à yo ro̱, “ ‘Remen ko̱ ye̱ hyen rii-yo me̱ m-no̱m à, ye̱a hoks m-nap bo̱ yo ro̱ á. Ko̱ ye̱ ho̱ge̱ ma-u̱t re, ye̱a hoks m-nap u̱n yo me̱ m-co̱n á.’ ” ");
INSERT INTO uth_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Ma-to̱ Ishayawan-Rwo̱r u̱n Ma-to̱ Shir ge̱ne̱ yoa kor ye̱ à, yo ko̱ro̱g ye̱. Yo ka yo Shir ru̱re̱ Ishaya wu̱ ru̱re̱ Yahuda-ne̱! “ ‘No̱a se̱nge̱ m-ho̱ge̱ u̱n yo me̱ m-ze̱e̱ ko̱yanda à, amba no̱ hoks m-nap á. No̱a ma'as m-hyan u̱n yo me̱ m-no̱m à, amba no̱ hoks m-nap u̱n yo u̱m co̱ne̱ á.’ ” ");
INSERT INTO uth_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Ka da-o̱ Shir ze̱e̱ru̱ Ishaya mo̱sse̱ u̱n hun-ne̱ ye̱ o-Isra-ne̱, “ ‘Me̱ u̱n zee káane̱, remen hur-de u̱n ká hun-ne̱ ye̱ de ro̱ m-hwo̱go̱n ne̱, Ye̱ ro̱ u̱t-to̱ ne̱, amba ye̱ ro̱ m-nap u̱n yo ye̱ ho̱ge̱ á. Komo ye̱ bitishshu̱te̱ yish-ye̱ u̱n ye̱, remen ye̱ co̱n ye̱ nep yo ro̱ o-nip á. A ro ze̱e̱ge̱ ye̱ yagu̱te̱ m-co̱n m-nap u̱n yo ro̱ o-nip á, ye̱ roa nep yo me̱ m-no̱m à. Ye̱ ho̱gu̱ssu̱te̱ cas yo me̱ m-rwo̱r à, ye̱ neps yo u̱m co̱ne̱ à. Amba ye̱ co̱n ye̱ nom káane̱ á. Har ye̱ waktu̱nte̱ be u̱n de u̱m sokste̱ ye̱ ba'as-de u̱n ye̱ á.’ ” ");
INSERT INTO uth_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Ka da-de Ye̱so ze̱e̱ru̱ yan-neke̱-mo̱ u̱n wu̱, Yo yo Shir zee Ishaya, “Shir ya'ag no̱ o-kwu̱m, yish no̱ hyanag rem-se u̱t-hyat se me̱ m-no̱m à. Shir ya'ag no̱ o-kwu̱m komo cin da no̱ m-ho̱ge̱ u̱n yo me̱ m-rwo̱r à. ");
INSERT INTO uth_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Nip-o̱ me̱ no̱ m-ru̱re̱, yan-Rwo̱r u̱n Ma-to̱ Shir n-ga u̱n kashi u̱n hun-ne̱ ne̱ de̱e̱n, ye̱ mare̱ cin n-ga à ro co̱no̱g ye̱ hyen rii-yo no̱ hyane̱ me̱ m-no̱m à, amba ye̱ hyan á. Komo ye̱ ho̱ge̱ rii-yo no̱ ho̱ge̱ à, amba ye̱ ho̱ge̱ á.” ");
INSERT INTO uth_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Ye̱so haaru̱ co u̱t-ma wu̱ zee, “To̱, ká sha-mo̱ u̱t-ma mo̱ u̱n ko-ya-u̱r-go wu̱ mo̱ ka. ");
INSERT INTO uth_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Ka go̱'-ye̱ he̱'e̱ne̱ n-riib u̱n co̱w à, ye̱ ro̱ ka ye̱ ho̱ge̱ ma-to̱ u̱n Gwo̱mo-to̱ Shir à amba ye̱ nap to̱ atte̱ ma-to̱ u̱n to̱ á. Ko-Gwo̱mo-wu̱ u̱n ya-u̱t-ko̱t haanu̱ru̱, wu̱ rwo̱o̱'ru̱ to̱-to̱ ke ye̱ u̱n rii-yo ye̱ ho̱ge̱ à. ");
INSERT INTO uth_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Ye̱ he̱'e̱ne̱ u̱n be-de m-ta'aru̱ ne̱ à, ye̱ ro̱ ye̱ ho̱ge̱ Ma-to̱ Shir à ye̱ argu̱ m-go̱ks o-zak o-zak. ");
INSERT INTO uth_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Amba ye̱ e̱ssu̱ to̱ ya o-da hiin remen ye̱ go̱ks ka ma-to̱ u̱r-be̱e̱b ne̱ á. Da-o̱ swo̱ u̱r-ko̱o̱b ko̱ u̱s-cenene wo̱o̱ne̱ remen ká Ma-to̱ Shir to̱, to̱ ye̱ go̱kse̱ à ye̱ argu̱ m-warag jim. ");
INSERT INTO uth_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Ye̱ he̱'e̱ne̱ u̱n be-de u̱n yokor komo à, ye̱ a hongse̱ u̱n hun-ne̱ ne̱ ye̱ ho̱ge̱ Ma-to̱ Shir à, amba barag-se u̱n ho̱no o-dak u̱n co̱n-to̱ o-kwu̱m ne̱ we̱nu̱ru̱ ká ma-to̱ m-bo̱'o̱se̱, har to̱ waktu̱ru̱ hwaa remen co̱n-to̱ o-kwu̱m. Remen kaane̱ ye̱a hoks m-she̱r be-de u̱n Ma-to̱ Shir á. Ma-to̱ Shir to̱ rwu̱nte̱ o̱ ka rii kashi be-de u̱n ká ye̱ ka ye̱ á. ");
INSERT INTO uth_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Ye̱ he̱'e̱ne̱ u̱n be-de u̱r-bon komo à, ye̱ a hongse̱ u̱n hun-ne̱ ye̱ ho̱ge̱ Ma-to̱ Shir à komo ye̱ bu̱p to̱. Ya ye̱ ro̱ u̱ntu̱n ka po̱t-yo rwu̱u̱te̱ yish o-zungu 100 à. Yo ken komo kwo̱o̱z-u̱t tet 60 Yo ken komo u̱r-kwo̱o̱z u̱n o̱p 30.” ");
INSERT INTO uth_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Ka da-de Ye̱so dooru̱ m-ru̱re̱ u̱n ka hun-ne̱ ye̱ mo̱ ken sha-mo̱ u̱t-ma mo̱. Wu̱ ze̱e̱ru̱, “A hoks m-hongse̱ u̱n gwo̱mo-to̱ Shir u̱n ne̱t ne̱ wu̱ go̱'e̱ go̱'-ye̱ u̱r-bon u̱n kat-o̱ u̱n wu̱ à. ");
INSERT INTO uth_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Amba da-o̱ hun-ne̱ rewesse̱ kap à, ko-wan-yage̱-to̱ u̱n wu̱ haaru̱, wu̱ go̱o̱ru̱ ye̱ge̱-kwa u̱n ká kat-o̱ u̱n hyo o̱, wu̱ argu̱ u̱t-ma u̱n wu̱. ");
INSERT INTO uth_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Bo̱ go̱'-u̱r po̱to̱nte̱ à, ye̱ bo̱su̱ru̱ ye̱ rwu̱ntu̱ru̱ yish, ka da-de ye̱ge̱-kwa po̱tnu̱ru̱ u̱n ce ye̱. ");
INSERT INTO uth_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","“Gu̱w-ne̱ ye̱ u̱n ko-ya-o-kat haanu̱ru̱. Ye̱ ze̱e̱ru̱ ko-ya-o-kat, ‘Ai, go̱'-ye̱ u̱r-bon te̱ go̱'e̱ u̱n kat-o ru bo̱ o zee à. To̱, ¿re no̱me̱ ye̱ge̱-kwa rwu̱u̱nte̱ u̱n ká be-de?’ ");
INSERT INTO uth_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","“Ko-ya-o-kat ze̱e̱ru̱ ye̱, ‘Wan-yage̱-u̱t re wu̱ no̱me̱ to̱ ka.’ “Gu̱w-ne̱ citu̱ru̱ wu̱, ‘¿O co̱no̱g te̱ mu̱'u̱g ka kwa-ye̱?’ ");
INSERT INTO uth_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","“Amba ko-ya-o-kat ze̱e̱ru̱, ‘Ay, taase be-de m-mu̱'u̱g u̱n kwa no̱ he no̱ mu̱'u̱g u̱n hyo-ne̱. ");
INSERT INTO uth_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Yage̱ myet-mo̱ u̱n ye̱ bo̱'o̱su̱te̱ be-u̱r gaan har da-o̱ m-ce. Ka da-de man ru̱re̱ ya-m-ce, ye̱ be m-mu̱'u̱g u̱n ká kwa-ye̱, ye̱ karakse̱, ye̱ geger, a tu̱kste̱, amba a kamas ye̱ge̱-hyo a ru̱ u̱n byo u̱n de.’ ” ");
INSERT INTO uth_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","32","Ye̱so dooru̱ ye̱ m-ru̱re̱ u̱n mo̱ ken sha-mo̱ u̱t-ma mo̱. Wu̱ zee, “Gwo̱mo-to̱ Shir u̱ntu̱n ya'ane-yo mosta to̱ ro̱ yo jiishe̱ u̱s-re̱k n-me̱ u̱n go kap à yo wu̱ ken ne̱t-wu̱ de̱ke̱, wu̱ go̱o̱ru̱ u̱n kat-o̱ u̱n wu̱ à. Yo jiishe̱ u̱s-re̱k be-de u̱n o̱r u̱n yo ne̱. Amba da-o̱ yo bo̱'o̱se̱ à, yo jiishu̱ru̱ kap o̱ u̱n gu̱go̱o̱g o-kat, yo waktu̱ru̱ caari-yo o-'yo, har ma ye̱ge̱-no ce̱e̱ru̱ u̱t-kur u̱n jet-se u̱n yo.” ");
INSERT INTO uth_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Ye̱so dooru̱ ye̱ m-ru̱re̱ u̱n mo̱ ken sha-mo̱ u̱t-ma mo̱. Wu̱ zee, “Gwo̱mo-to̱ Shir ya to̱ ro̱ u̱ntu̱n m-yist. Wu̱ ken ne'a-wu̱ de̱k m-yist, wu̱ wu̱u̱gse̱ u̱n hyò-mo̱ u̱n hyo-ne̱ me'es u̱t-tet, amba kap ka hyò-mo̱ ku̱tu̱ksu̱ru̱ m-yist ne̱.” ");
INSERT INTO uth_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Ye̱so yoosu̱te̱ bu̱u̱g-de u̱n hun-ne̱ kap ká rem-se u̱n sha-mo̱ u̱t-ma. Wu̱a yoosu̱ ye̱ rii á se̱ mo̱sse̱ u̱n sha-mo̱ u̱t-ma ne̱. ");
INSERT INTO uth_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Ka to̱ ro̱ remen Shir shoosté̱ rii-yo Ishayawan-Rwo̱r u̱n Ma-to̱ Shir rwo̱re̱ à u̱nze, “Man nome̱ hun-ne̱ u̱t-ma u̱n sha-mo̱ u̱t-ma, rii-yo hun-ne̱ ro nakke̱ n-ga á, cin u̱n takan-de u̱n ho̱no o-dak man ru̱ ye̱ nep yo.” ");
INSERT INTO uth_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Ka da-de Ye̱so yagu̱ru̱ bu̱u̱g-de u̱n hun-ne̱, wu̱ co̱wu̱ru̱ o-hur, be-de wu̱ ro̱ u̱r-she'et à. Yan-neke̱-mo̱ u̱n wu̱, komo ye̱ haanu̱ru̱ be-de u̱n wu̱, ye̱ ze̱e̱ru̱ wu̱, “Ru̱ru̱ te̱ rii-yo ká sha-mo̱ u̱t-ma mo̱ u̱n ká kwa-ye̱ o-kat co̱ne̱ te̱ nep à.” ");
INSERT INTO uth_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Ye̱so ze̱e̱ru̱, “Wu̱ go̱'e̱ go̱'-ye̱ u̱r-bon à me̱ Wà-wu̱ u̱n ne̱t. ");
INSERT INTO uth_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Ká kat-o̱ komo o̱ ro̱ ho̱no o-dak be-de hun-ne̱ ro̱ m-she'et m-mo̱ka à. Go̱'-ye̱ u̱r-bon komo ye̱ ro̱ yakar-ye̱ u̱t-gwo̱mo to̱ Shir, ká kwa-ye̱ komo yakar-ye̱ u̱n ko-Gwo̱mo-wu̱ u̱n ya-u̱t-ko̱t ye̱. ");
INSERT INTO uth_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Komo wa-u̱t-yage̱-wu̱ go̱'e̱ ká kwa-ye̱ à, ko-Gwo̱mo-wu̱ u̱n ya-u̱t-ko̱t wu̱. Da-o̱ m-ce ne̱, ta-de u̱n ho̱no o-dak de. Ká ya-m-ce ye̱ komo ye̱ ro̱ yan-to̱m-ye̱ Shir. ");
INSERT INTO uth_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","“Ká gu̱w-ne̱ ye̱ a mu̱'u̱g ka kwa-ye̱ a do ye̱ o-ra. Káane̱ he m-no̱m u̱n ho̱-de u̱n ta-de u̱n ho̱no o-dak. ");
INSERT INTO uth_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Me̱, Wà-wu̱ u̱n ne̱t, man to̱mo̱n yan-to̱m-ye̱ Shir u̱n ho̱no o-dak. Komo ye̱a hu̱ru̱m be-de u̱n Gwo̱mo-to̱ Shir, ko̱ yo ke rii-yo ro̱ m-hante̱ m-'e̱ u̱r-ba'as ne̱ à, u̱n ko̱ wu̱ ke kowa m-no̱m u̱n rii yo̱-yo wu̱ ne̱. ");
INSERT INTO uth_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Yan-to̱m-ye̱ Shir a jorbe̱ yan-me̱n-u̱t jaas-to̱ u̱n kuub-o o-ra. Káne̱ ye̱ he u̱s-kan, ye̱ ro̱ u̱n haw-se u̱n yin-ye̱ u̱n ye̱. ");
INSERT INTO uth_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Ka da-o̱ o̱ ka kashi u̱n hun-ne̱ ye̱ Shir go̱kse̱ à he u̱s-myakt u̱ntu̱n u̱r-ho̱, n-me̱ u̱n u̱t-gwo̱mo to̱ u̱n Tato. Yage̱ ko-yan-tó̱-tò̱ m-ho̱ge̱, wu̱ ho̱gu̱te̱.” ");
INSERT INTO uth_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Ye̱so haaru̱ co u̱r-yoos wu̱ zee, “Gwo̱mo-to̱ Shir ya to̱ ro̱ u̱ntu̱n o-kwu̱m o̱ a wuke̱ n-me̱ o-kat à, bo̱ wu̱ ken wu̱ hyente̱ o̱ à, wu̱ jamsu̱ m-wuke̱, remen caari-o̱ o-zak. Wu̱ haaru̱ wu̱ babu̱ru̱ kap o̱ u̱n rii-yo wu̱ ro̱tte̱ à, wu̱ o̱o̱ru̱ ká kat-o̱.” ");
INSERT INTO uth_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Har m-mo̱ka, gwo̱mo-to̱ Shir ya to̱ ro̱ u̱ntu̱n wa-u̱t-baab m-o̱ ne̱ wu̱ ro̱ u̱n hoob-o̱ u̱n ta'ar-to̱ u̱n hwo̱r wu̱ o à. ");
INSERT INTO uth_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Bo̱ wu̱ hyente̱ ta'ar-de u̱n hwo̱r de̱e̱n à, wu̱ argu̱ m-ha wu̱ babu̱ru̱ kap rii-yo wu̱ ro̱tte̱ à. Wu̱ mo̱ro̱gsu̱ hwo̱r, wu̱ o̱o̱ru̱ de.” ");
INSERT INTO uth_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Ye̱so haaru̱ co u̱r-yoos wu̱ ze̱e̱ru̱, “Har m-mo̱ka, gwo̱mo-to̱ Shir ya to̱ ro̱ u̱ntu̱n yo-o̱ u̱n ship u̱n jan. Bo̱ hun-ne̱ jorbe̱ o̱ n-me̱ m-sa à, o̱ shipnu̱ru̱ ye̱ge̱-jan go̱-u̱s-go̱. ");
INSERT INTO uth_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Bo̱ o̱ shiiste̱ u̱n jan à, yan-ce̱e̱b naknu̱ru̱ o̱ n-riib m-sa u̱n jan ne̱. Ka da-de ye̱ she'etu̱ru̱, ye̱ degru̱ru̱ jan-ye̱ u̱r-bon, ye̱ duusu̱ru̱ o-ko̱o̱r, ye̱ uksu̱ru̱ ye̱ ro̱tte̱ u̱r-bon á. ");
INSERT INTO uth_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Káane̱ he m-no̱m u̱n ta-de u̱n ho̱no o-dak. Yan-to̱m-ye̱ Shir a haan ye̱ deger, ye̱ hu̱ru̱m hun-ne̱ yo̱-ye̱ n-me̱ u̱n so̱-ye̱. ");
INSERT INTO uth_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Komo yan-to̱m-ye̱ Shir ye̱a jorbe̱ ka hun-ne̱ yo̱'e̱ ye̱ n-me̱ u̱n ra-o̱ m-reeten, káne̱ ka hun-ne̱ ye̱ he u̱s-kan u̱n haw-se u̱n yin-ne̱.” ");
INSERT INTO uth_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Ye̱so citu̱ru̱ yan-neke̱-mo̱ u̱n wu̱, “¿No̱ nepste̱ to̱ ka kap?” Ye̱ shasu̱ru̱, ye̱ ze̱e̱ru̱, “E̱e̱, te̱ nepste̱.” ");
INSERT INTO uth_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Wu̱ ze̱e̱ru̱ ye̱, “Ko̱ wu̱ ke wan-Yoos-de o-karamsa wu̱, wu̱ a yoose̱ ma-to̱ gwo̱mo-to̱ Shir à. Ya wu̱ ro̱ u̱ntu̱n ne̱t-wu̱ ro̱ u̱n byo-de u̱r-e̱ss ne̱ à o-hur. Wu̱a gassan rii-yo u̱r-bon ut ko̱ pu̱-yo.” ");
INSERT INTO uth_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Bo̱ Ye̱so komte̱ rwo̱r u̱n ká sha-mo̱ u̱t-ma mo̱ à, wu̱ argu̱ yage̱ u̱n ka be-de. ");
INSERT INTO uth_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Bo̱ jime̱ à, Ye̱so u̱n yan-neke̱-mo̱ u̱n wu̱ ne̱ wo̱o̱ru̱ o-Nazaret bo̱-o̱ u̱n wu̱. Wu̱ ciru̱ yoose̱ u̱n hun-ne̱ ye̱ u̱n Yahuda-ne̱ u̱n kuke̱-o̱ u̱n yoos u̱n Ma-to̱ Shir. Ye̱ bo̱pu̱ru̱ u̱s-nu u̱n bo̱ wu̱ yoose̱ ye̱ à u̱n rii-yo wu̱ no̱me̱ ne̱ à. Ye̱ citu̱ru̱ hi u̱n de u̱n ye̱, “¿Ke ne̱ ka ne̱t-wu̱ kume̱ ka we̱e̱r-se kaane̱, komo kene̱ wu̱ kume̱ gwo̱mo-to̱ u̱n no̱m o-made̱? ");
INSERT INTO uth_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","¿Wu̱ wu̱ ka ro̱ wà-wu̱ u̱n ká ko-wan-shaab-wu̱? ¿Inu u̱n wu̱ wu̱ ka a m-ze̱e̱ Meri? ¿Hen-ne̱ u̱n wu̱ komo Yakubu, Yusuhu, Simo̱n ne̱, Yahudas ne̱? ");
INSERT INTO uth_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","¿Komo hen-ne̱ ye̱ u̱n wu̱ yan-ne'a-ne̱ kap be-u̱r gaan-o̱ ka a ro̱ u̱n ye̱ ne̱ á? Remen kaane̱ a nepse̱ wu̱ ne̱t caari-wu̱ á. ¿Amba re ne̱ ka ne̱t-wu̱ hokste̱ m-no̱m u̱n ka rem-se u̱t-hyat se ne̱?” ");
INSERT INTO uth_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ye̱ ho̱gu̱ru̱ ryaab-se u̱n wu̱, ye̱ yanu̱ru̱ wu̱. Amba Ye̱so ze̱e̱ru̱ ye̱, “Ai, ko̱ wu̱ ke wu̱ ro̱ m-'ya u̱n ko-wan-rwo̱r u̱n Ma-to̱ Shir u̱t-go̱s amba hu̱sse̱ hun-ne̱ ye̱ u̱n bo̱-o̱ u̱n wu̱, u̱n ye̱ u̱n hur-o̱ u̱n wu̱ ne̱.” ");
INSERT INTO uth_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Komo Ye̱so no̱m rii-yo u̱t-hyat de̱e̱n re̱e̱no̱ á, remen ko̱o̱b-de m-she̱r mo̱ u̱n ye̱ be-de u̱n wu̱. ");
INSERT INTO uth_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","U̱n ka da-o̱, ko-Gwo̱mo Here̱ Atipas ho̱ge̱ rii-yo u̱t-hyat to̱ Ye̱so ro m-no̱m à. ");
INSERT INTO uth_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Wu̱ ze̱e̱ru̱ yan nome̱ u̱n wu̱ m-se̱nge̱, “Ai, ka ne̱t-wu̱ a nom Yohana Wa-m-Yo'os u̱n hun-ne̱ m-ho̱. Ko̱ de nomte̱ wu̱ mereste̱ à, wu̱ mu̱u̱nte̱ u̱n ho̱o̱g ne̱! O̱ hante̱ wu̱ ro̱tte̱ u̱n ka gwo̱mo-to̱ ne̱ to̱ u̱n no̱m u̱n rem-se u̱t-hyat.” ");
INSERT INTO uth_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Remen Here̱ n-ga rwo̱o̱g a bu̱p komo a ke'e Yohana, wu̱ rwo̱o̱g a ke'e wu̱ o-kuke̱ o̱ m-ke'et remen Here̱ gaag Herodiya, ne'a wu̱ u̱n o̱r re u̱n wu̱, Pirip. ");
INSERT INTO uth_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Komo n-ga ma Yohana ru̱ssu̱te̱ Here̱ u̱nze u̱depe̱ wu̱ she'et u̱n Herodiya ne̱ á, remen jet u̱n karamsa-o̱ Shir o̱. Here̱ swo̱o̱ru̱ u̱s-ryaab u̱n Yohana ne̱. Wu̱ rwo̱'u̱ru̱ karma-ne̱ ye̱ u̱n wu̱, ye̱ ship Yohana, ye̱ ke wu̱. ");
INSERT INTO uth_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Here̱ ro co̱no̱g ma wu̱ ho Yohana, amba wu̱ ro̱ m-ho̱ge̱ gye̱r-o̱ u̱n hun-ne̱, remen ye̱ dekse̱ Yohana ko-yan-Rwo̱r u̱n Ma-to̱ Shir wu̱. ");
INSERT INTO uth_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","To̱, bo̱ ho̱-de a mette̱ Here̱ riginte̱ à, Here̱ banu̱ru̱ biki-o̱ m-re̱. Wan-ne'a Herodiya he̱wu̱ru̱ wu̱ u̱s-he̱w u̱n he̱r-o̱ u̱n ye̱ haane̱ o-biki à. Here̱ no̱mu̱ru̱ o-zak de̱e̱n. ");
INSERT INTO uth_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Remen kaane̱ wu̱ swo̱ru̱ru̱ o-nu mo̱sse̱ u̱n to̱nd ne̱ u̱nze, wu̱a 'ye ka wan-ne'a-wu̱ kap o̱ u̱n rii-yo wu̱ ko̱ne̱ à. ");
INSERT INTO uth_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Inu u̱n wu̱ kwemsu̱ru̱ wu̱ mo̱sse̱ u̱n yo wu̱ he m-ko̱n ne̱ à. Ká wan-ne'a-wu̱ ze̱e̱ru̱, “Ya'as me̱ hi-u̱r Yohana Wa-m-Yo'os u̱n hun-ne̱ m-ho̱ m-mo̱ka n-me̱ o-ko̱k.” ");
INSERT INTO uth_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Ko-Gwo̱mo ryegnu̱ru̱, bo̱ wu̱ ko̱ne̱ wu̱ yo ka à. Amba remen wu̱ zeste̱ wu̱, komo wu̱ su̱ru̱ste̱ o-nu, u̱n co-o̱ u̱n hamat-ne̱ ye̱ u̱n wu̱ u̱nze wu̱a 'ye wu̱ kap yo wu̱ ko̱ne̱ à. Wu̱ rwo̱'u̱ru̱ karma-ne̱ ya'as wu̱ yo wu̱ ko̱ne̱ à. ");
INSERT INTO uth_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Ye̱ haaru̱ ha-mo̱ u̱n kur-o̱ m-ke'et, ye̱ kupsu̱ru̱ Yohana u̱r-hi. ");
INSERT INTO uth_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Ye̱ hwo̱o̱ru̱ ká hi-de n-me̱ o-ko̱k. Ye̱ ya'su̱ru̱ ká wan-ne'a-wu̱, wu̱ heetu̱ru̱ inu u̱n wu̱. ");
INSERT INTO uth_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Yan-neke̱-m Yohana ho̱gu̱ru̱, ye̱ haaru̱ u̱n kur-o̱ m-ke'et, ye̱ de̱ku̱ru̱ u-de u̱n wu̱, ye̱ jo̱ku̱ru̱. Ye̱ haaru̱ be-u̱r Ye̱so, ye̱ ru̱ru̱ wu̱ yo ko̱re̱ Yohana à. ");
INSERT INTO uth_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Bo̱ Ye̱so ho̱gu̱te̱ Yohana mereste̱ à, wu̱ inu̱ru̱ wu̱ co̱wu̱ru̱ hat-o̱ m-ho̱. Wu̱ pasu̱ru̱ de ken be-de de ro̱tte̱ ne̱t á, remen wu̱ she'etté̱ u̱n ho̱n-de u̱n wu̱. Amba bo̱ bu̱u̱g-de u̱n hun-ne̱ ho̱gu̱te̱ kaane̱ à, ye̱ argu̱ m-rwu̱u̱n u̱n bo̱-to̱ u̱n ye̱. Ye̱ do̱ru̱ru̱ wu̱ u̱s-na u̱s-na. ");
INSERT INTO uth_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Bo̱ Ye̱so rwu̱u̱nte̱ n-me̱ o-hat à, wu̱ hyanu̱ru̱ hun-ne̱ do̱nte̱ wu̱ de̱e̱n. Wu̱ ho̱gu̱ru̱ 'wo̱n-de u̱n ye̱, komo wu̱ taasu̱ru̱ ya-u̱s-go̱m go̱m-se u̱n ye̱. ");
INSERT INTO uth_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Bo̱ rim-m no̱mte̱ à, yan-neke̱-mo̱ u̱n wu̱ haanu̱ru̱ be-de u̱n wu̱. Ye̱ ze̱e̱ru̱ wu̱, “Kà be-de ha de ro̱tt ne̱t á, komo rim-m nomoste̱. Zee kà hun-ne̱ ye̱ warag n-me̱ o-bo̱ remen ye̱ ooté̱ hi u̱n de u̱n ye̱ rii-yo m-re̱.” ");
INSERT INTO uth_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Ye̱so ze̱e̱ru̱ ye̱, “Ay, se̱ ye̱ aragte̱ á, 'ya no̱ ye̱ rii-yo m-re̱.” ");
INSERT INTO uth_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Ye̱ shasu̱ru̱, ye̱ ze̱e̱ru̱, “Te̱a hoks ye̱ m-coks á, te̱tt rii kane̱ á se̱ u̱t-buro̱di u̱t-taan u̱n jan ne̱ yoor.” ");
INSERT INTO uth_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Ka da-de, Ye̱so ze̱e̱ru̱ ye̱, “Hante̱ me̱ no̱ to̱.” ");
INSERT INTO uth_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Wu̱ ze̱e̱ru̱ hun-ne̱ she'et n-te̱ u̱t-po̱. Ka da-de Ye̱so de̱ku̱ru̱ ká buro̱di-u̱t taan-to̱ u̱n ká jan yoor-ye̱ ne̱. Wu̱ dassu̱ru̱ hi-de u̱n wu̱ n-To̱n shir. Wu̱ no̱mu̱ru̱ Shir u̱r-bo̱ngo̱n. Wu̱ bosru̱ru̱ u̱t-buro̱di u̱n ká jan-ye̱ ne̱. Wu̱ ya'asu̱ru̱ yan-neke̱-mo̱ u̱n wu̱, yan-neke̱-mo̱ u̱n wu̱ komo ye̱ ya'asu̱ru̱ bu̱u̱g-de u̱n hun-ne̱. ");
INSERT INTO uth_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Ká buro̱di-to̱ hundu̱ndu̱ru̱, ko̱ wu̱ ke ne̱t-wu̱ re̱e̱g wu̱ ciig. Yan-neke̱-mo̱ u̱n wu̱ karaksu̱ru̱ to̱ kuse̱ à kap, har to̱ shiiru̱ ko̱o̱r-u̱t o̱p u̱t-yoor 12. ");
INSERT INTO uth_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Hun-ne̱ ye̱ re̱ to̱ à ye̱ wooste̱ campo̱-ne̱ dugu-u̱s taan 5,000 hu̱sse̱ ne'a-ne̱ u̱n yakar-ne̱ ye̱ re to̱ à. ");
INSERT INTO uth_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Ye̱ m-ko̱m u̱n re̱ u̱n rii-yo m-re̱, Ye̱so rwo̱'u̱ru̱ yan-neke̱-mo̱ u̱n wu̱, ye̱ cu̱w hat-o̱ m-ho̱ ye̱ waragte̱ re̱e̱no̱ u̱r-jit. Remen ye̱ be'et wu̱ m-wo̱ Mar-o̱ Gariri. Wu̱ ne̱ wu̱ e̱su̱ru̱ u̱n ká be-de remen wu̱ 'yonsté̱ hun-ne̱. ");
INSERT INTO uth_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Bo̱ hun-ne̱ aragsu̱te̱ à, wu̱ daaru̱ n-to̱n o-haag u̱n ho̱n-de u̱n wu̱ remen wu̱ konot Shir. Har rim-m no̱mu̱ru̱ m-so̱k ne̱ wu̱ ro̱ re̱e̱no̱ u̱n ho̱n-de u̱n wu̱ cot. ");
INSERT INTO uth_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","U̱n hohond-mo̱ u̱n ká da-o̱ hat-o̱ yan-neke̱-mo̱ u̱n wu̱ tu̱wte̱ à ro̱ n-te̱te̱ o̱ o-mar, jo̱k-ye̱ m-ho̱ ro̱ o̱ u̱s-tam, komo yo-m ro̱ o̱ m-tute̱. ");
INSERT INTO uth_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Kwo̱m-u̱s tet-se m-te̱t, ye̱ hyanu̱ru̱ Ye̱so wu̱ ka wu̱ ro̱ m-neke̱ n-to̱n o-mar wu̱ ro̱ m-kawbe̱ u̱n yan-neke̱-mo̱ u̱n wu̱. ");
INSERT INTO uth_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Amba bo̱ yan-neke̱-mo̱ u̱n wu̱ hyente̱ wu̱ ro̱ u̱r-hew n-to̱n m-sa à, ye̱ ho̱gu̱ru̱ o-gye̱r. Ye̱ ze̱e̱ru̱, “Ko-marimar-wu̱!” Ye̱ 'yonsu̱ru̱ u̱s-co̱r rem o-gye̱r! ");
INSERT INTO uth_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","U̱n gyept-o̱ u̱n yish, Ye̱so te̱psu̱ru̱ ye̱, wu̱ ze̱e̱ru̱, “No̱ zo̱'o̱ge̱ á! Me̱ wu̱, no̱ ho̱ge̱ o-gye̱r á!” ");
INSERT INTO uth_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Bitrus shasu̱ru̱ wu̱, wu̱ zee, “Go̱s-wu̱, u̱rege̱ wo̱ wu̱, zee me̱ u̱m habe̱ be u̱n du u̱n yawag m-ho̱.” ");
INSERT INTO uth_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Ye̱so ze̱e̱ru̱, “Haan ge̱.” Ka da-de Bitrus ruuru̱ o-hat, wu̱ ciriru̱ u̱r-hew m-yawag m-ho̱, wu̱ ro̱ m-neke̱ be-u̱r Ye̱so. ");
INSERT INTO uth_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Amba bo̱ Bitrus hyente̱ m-yo m-'wo̱ns ne̱ à, wu̱ ho̱gu̱ru̱ o-gye̱r. Wu̱ ciriru̱ m-yi. Wu̱ argu̱ m-kan, wu̱ zee, “Go̱s-wu̱, gu me̱!” ");
INSERT INTO uth_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","U̱n gyept-o̱ u̱n yish, Ye̱so tabbu̱ru̱ kom-o̱ u̱n wu̱, wu̱ shipu̱ru̱ Bitrus. Ye̱so ze̱e̱ru̱ Bitrus, “Wo̱tt m-she̱r de̱e̱n á, ¿remen yan o̱ o ryegente̱?” ");
INSERT INTO uth_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Ka da-de bo̱ Ye̱so u̱n Bitrus ne̱ cu̱wte̱ o-hat à, yo-m re̱su̱ru̱ ceen. ");
INSERT INTO uth_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Ka da-de ye̱ ka yan-neke̱-m Ye̱so ye̱ ro̱ n-me̱ o-hat à, ye̱ nomoru̱ Ye̱so u̱r-bo̱ngo̱n. Kap mo̱ u̱n ye̱ ze̱e̱ru̱ Ye̱so, “Nip-o̱, wo̱ Wà-wu̱ Shir wu̱.” ");
INSERT INTO uth_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Ka da-de ye̱ pasu̱ru̱ de ka jit-de m-sa de, ye̱ kergu̱ndu̱ru̱ u̱n dak-o̱ o-Genesaret. ");
INSERT INTO uth_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Bo̱ hun-ne̱ ye̱ u̱n ká bo̱-o̱ nepte̱ Ye̱so haante̱ à, ye̱ to̱mu̱ru̱ a ru̱re̱ ko̱ wu̱ ke ne̱t-wu̱, wu̱ ro̱ u̱n ká dak-o̱ à, u̱nze Ye̱so haante̱. Ye̱ hante̱ wu̱ ya-u̱s-go̱m kap. ");
INSERT INTO uth_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Ye̱ ko̱nu̱ru̱ Ye̱so ye̱ ci ko̱ riib-yo u̱n matuku-de u̱n wu̱. Wu̱ ya'u̱ru̱ ye̱ o-co̱w, ye̱ nom káane̱. Myet-mo̱ u̱n ye̱ ci'e̱ à go̱m-se u̱n ye̱ taaru̱. ");
INSERT INTO uth_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","A kane̱ Parisa-ne̱ u̱n yan-Yoos-de o-karamsa ne̱ haanu̱ru̱ be-u̱r Ye̱so zee-mo̱ o-Urusharima. Ye̱ ze̱e̱ru̱, ");
INSERT INTO uth_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“¿Remen yan o̱ ne̱ yan-neke̱-m ru ro̱tte̱ m-jetem u̱n jor-se u̱n mo̱ng-ne̱? Te̱ u̱n ze̱e̱ kaane̱ remen ye̱ ro̱ m-sapt u̱t-kom ye̱ reet rii-yo m-re̱ bo̱ a o̱o̱s á.” ");
INSERT INTO uth_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Ye̱so shasu̱ru̱ ye̱, “No̱ ne̱, ¿remen yan o̱ no̱ ro̱tte̱ m-jet u̱n karamsa-o̱ Shir remen jor-u̱s no̱? ");
INSERT INTO uth_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Ai, Shir zeste̱, ‘Hyan tato ru u̱t-go̱s ne̱ u̱n inu ru ne̱,’ komo, ‘Myet wu̱ pyape̱ tato u̱n wu̱ ko̱ inu u̱n wu̱ à, o-nip a ho wu̱.’ ");
INSERT INTO uth_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Amba no̱ u̱r-yoos u̱nze u̱rege̱ ne̱t ro̱ u̱n yo ken rii-yo ne̱ yo wu̱ heete̱ m-gu u̱n tato u̱n wu̱ ko̱ inu u̱n ne̱ u̱n yo ne̱ à, amba wu̱a zee, ‘Kap rii-yo no̱ roa kum be u̱n de n-ga à, yar-mo̱ mo̱ u̱m seke̱ Shir à,’ waragte̱ o̱ ka, ba se̱ o ya'aste̱ tat-ne̱ ru ne̱ u̱t-go̱s á. ");
INSERT INTO uth_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Remen jor-u̱s no̱, no̱ muste̱ Ma-to̱ Shir hwaa. ");
INSERT INTO uth_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","No̱ ya-o-she̱pe̱! Hond hond o̱ Ishaya no̱me̱ ma-u̱t no̱ bo̱ wu̱ zee à, ");
INSERT INTO uth_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","“ ‘Ká hun-ne̱ ye̱ ro̱ me̱ m-'ya m-se̱k u̱n nu-se u̱n ye̱ cot, Amba hur-de u̱n ye̱ nomoste̱ u̱r-hew u̱n me̱ ne̱. ");
INSERT INTO uth_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Gu̱w-mo̱ u̱n ye̱ mo̱ ye̱ ro̱ me̱ m-nome̱ à, mo̱ o-hwaa mo̱, ye̱ su̱gu̱te̱ karamsa-o̱ Shir u̱n yoos-de u̱n ye̱.’ ” ");
INSERT INTO uth_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Ye̱so aagu̱ru̱ bu̱u̱g-de u̱n hun-ne̱, wu̱ ze̱e̱ru̱ ye̱, “Raks no̱, no̱ ho̱ge̱ m-so̱k ne̱. ");
INSERT INTO uth_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Ba rii-yo ro̱ m-co̱w u̱n nu-o̱ u̱n ne̱t à, yo ro̱ wu̱ m-rwo̱ wu̱ waktu̱te̱ ko-ya-u̱r-ba'as be-de Shir á, se̱ rii-yo ro̱ m-rwu̱u̱n u̱n nu-o̱ u̱n wu̱ à, u̱n yo wu̱ ro̱ m-no̱m ne̱ à.” ");
INSERT INTO uth_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Yan-neke̱-mo̱ u̱n wu̱ haanu̱ru̱ be-de u̱n wu̱, ye̱ citu̱ru̱, “¿Ko̱ o nepste̱ u̱nze Parisa-ne̱ ho̱gu̱te̱ ryaab-u̱s ru remen kà ma-to̱ o zee?” ");
INSERT INTO uth_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Ye̱so shasu̱ru̱, “Myet go-de ro̱ ba Tato re wu̱ n-To̱n shir wu̱ go de á, a mu̱'u̱g de. ");
INSERT INTO uth_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Yagu̱ ye̱ temb. Po̱-ne̱ yan-nak u̱n o̱r u̱n ye̱ po̱-ne̱. U̱rege̱ ko-po̱ ro̱ m-nak u̱n o̱r u̱n wu̱ ko-po̱, ai, kap mo̱ u̱n ye̱ ye̱a he̱'e̱be̱ n-me̱ o-kuub.” ");
INSERT INTO uth_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Ka da-de, Bitrus ze̱e̱ru̱, “Ye̱so, rwu̱ntu̱ te̱ cas yo ká sha-mo̱ u̱t-ma mo̱ co̱ne̱ te̱ nep à.” ");
INSERT INTO uth_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Ye̱so ze̱e̱ru̱ wu̱, “¿Ashi, har m-mo̱ka no̱ nap á? ");
INSERT INTO uth_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Me̱ m-ze̱e̱ kap o̱ u̱n rii-yo ne̱t re̱ à, u̱r-takan yoa cu̱w u̱n nu-o̱ u̱n wu̱, ká da-de ne̱ yoa cu̱w u̱n me̱n-to̱ u̱n wu̱, komo u̱r-ko̱m yoa ru u̱n wu̱r-o̱ u̱n wu̱. ");
INSERT INTO uth_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Amba rii yo̱-yo ro̱ m-rwu̱u̱n o-nu à be-de u̱r-hur yo ro̱ m-rwu̱u̱n. Komo yo ro̱ m-naas u̱n ne̱t-wu̱ rwu̱nte̱ yo à. ");
INSERT INTO uth_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Me̱ u̱n ze̱e̱ kaane̱ remen cin u̱r-hur barag-u̱s yo̱-se ro̱ m-rwu̱u̱n. Se ro̱, ho-m u̱n hun-ne̱, o-ás ne̱, m-naase̱ ne̱, u̱r-hyow ne̱, u̱n shese̱ u̱t-bo̱ ne̱, u̱n naas u̱n jin-u̱t o̱r ru ne̱. ");
INSERT INTO uth_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Se kà rem-se ro̱ ne̱t m-rwo̱ m-wakte̱ ko-ya-u̱r-ba'as be-de Shir. Re̱ u̱n rii ba u̱n sapt u̱t-kom a ru̱ ne̱t m-wakte̱ ko-ya-u̱r-ba'as be-de Shir á.” ");
INSERT INTO uth_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Ye̱so ruuru̱ o-Gariri wu̱ neku̱ru̱ raag-o̱ u̱n dak-to̱ o-Taya o-Sidon ne̱, ");
INSERT INTO uth_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Wu̱ ken ne'a wu̱ ko-ya-o-Kan'ana, wu̱ ro̱ u̱r-she'et káne̱ à haanu̱ be-u̱r Ye̱so. Wu̱ 'yonsu̱ u̱s-co̱r wu̱ ro̱ u̱s-kan, wu̱ ze̱e̱ru̱, “Go̱s-wu̱, wà Dawuda, ho̱ge̱ 'wo̱n u̱n de! Remen wà re wan-ne'a ro̱ u̱n ko-ya-u̱t-ko̱t ne̱, wu̱ ro̱ wu̱ u̱n ya-u̱r-ko̱o̱b.” ");
INSERT INTO uth_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Amba Ye̱so shas wu̱ ko̱ u̱r-gom á. Ka da-de yan-neke̱-mo̱ u̱n wu̱ ko̱nu̱ru̱ wu̱, ye̱ ze̱e̱ru̱, “Yan wu̱! Zee wu̱ arag. Remen wu̱ ro̱ na m-do̱re̱ u̱n kaas u̱t-tó̱ o-zaaz!” ");
INSERT INTO uth_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Ka da-de Ye̱so ze̱e̱ru̱ ká ne'a-wu̱, “Shir u̱n to̱mo̱n me̱ remen hun-ne̱ ye̱ o-Isra ca-ye̱ Shir ye̱ e̱ge̱ à cot.” ");
INSERT INTO uth_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Amba ká ne'a-wu̱ haaru̱ wu̱ kwu̱ktu̱ru̱ u̱n co-o̱ u̱n wu̱. Wu̱ ko̱nu̱ru̱ komo, “Go̱s-wu̱, gu me̱!” ");
INSERT INTO uth_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Ye̱so ze̱e̱ru̱ ká ne'a-wu̱, “A nom u̱r-bon a de̱k rii-yo m-re̱ yo u̱n yakar a ya'as ye̱ge̱-wo̱ á.” ");
INSERT INTO uth_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Ká ne'a-wu̱ shasu̱ru̱, “Eba, Go̱s-wu̱ o, amba ye̱ge̱-wo̱ ro̱ m-rekem u̱n yo ken rii-yo m-re̱ yo ro̱ m-he̱'e̱n u̱n ko̱k-to̱ ya-o-hur ro̱tte̱ m-re̱ à.” ");
INSERT INTO uth_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Ye̱so ze̱e̱ru̱, “Ne'a she̱r-m ru ro̱ de̱e̱n! A nomotu̱ yo wo̱ o-dish à.” U̱n gyept-o̱ u̱n yish, ko-ya-u̱t-ko̱t ruuru̱ u̱n wà u̱n wu̱. ");
INSERT INTO uth_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Bo̱n káne̱, Ye̱so do̱ru̱ru̱ so̱ n-riib Mar-o̱ o-Gariri. Ka da-de wu̱ daaru̱ u̱r-dor, wu̱ she'etu̱ru̱. ");
INSERT INTO uth_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Hun-ne̱ haanu̱ru̱ be-de u̱n wu̱ de̱e̱n. Ye̱ neknu̱te̱ u̱n ryam-ne̱ ne̱, u̱n po̱-ne̱ ne̱, u̱n cim-ne̱ ne̱, u̱n 'kato̱-ne̱ ne̱, u̱n ye̱ ken ya-u̱s-go̱m ye̱ ne̱ de̱e̱n, ye̱ e̱ssu̱ru̱ ye̱ u̱n co Ye̱so. Wu̱ taasu̱ru̱ ye̱ go̱m-se u̱n ye̱ kap. ");
INSERT INTO uth_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Har hun-ne̱ hyen o-made̱ bo̱ ye̱ hyane̱ 'kato̱-ne̱ te̱pe̱rte̱ à, ya-u̱t-cim komo ye̱ m-se̱nge̱, ryam-ne̱ u̱r-hew, po̱-ne̱ komo ye̱ ro̱ o-hyan. Kap mo̱ u̱n ye̱, ye̱ nomu̱ru̱ Shir o̱ o-Isra u̱r-bo̱ngo̱n. ");
INSERT INTO uth_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","A kane̱ Ye̱so aagu̱ru̱ yan-neke̱-mo̱ u̱n wu̱, wu̱ ze̱e̱ru̱, “Me̱ m-ho̱ge̱ 'wo̱n-de u̱n kà hun-ne̱ ye̱. Caane̱ ho̱-u̱t tet-to̱ ka ye̱ be-u̱r gaan u̱n me̱ ne̱, komo ye̱ ro̱tt rii-yo m-re̱ á. Man 'yons ye̱ m-me̱r á, taase ye̱ bonse̱ u̱n co̱w.” ");
INSERT INTO uth_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Yan-neke̱-mo̱ u̱n wu̱ ze̱e̱ru̱ wu̱, “De kà be-de ro̱tte̱ ne̱t á, ¿ke a he kum u̱n ga-to̱ a hette̱ re̱e̱gte̱ u̱n de kà caari-de u̱n bu̱u̱g-de u̱n hun-ne̱ de?” ");
INSERT INTO uth_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Ye̱so citu̱ru̱, “¿Buro̱di-u̱t re no̱ ro̱tte̱?” Ye̱ ze̱e̱ru̱, “Ta'yoor-to̱ u̱n yan jan re̱k-ye̱ ne̱ hiin.” ");
INSERT INTO uth_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Ye̱so ze̱e̱ru̱ bu̱u̱g-de u̱n hun-ne̱ ye̱ she'ete̱ n-dak. ");
INSERT INTO uth_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Wu̱ de̱ku̱ru̱ ká buro̱di-to̱ ta'yoor-to̱ u̱n ká jan-ye̱ ne̱. Wu̱ bo̱mu̱ru̱ Shir, wu̱ wo̱ngu̱ru̱ to̱. Wu̱ ya'asu̱ru̱ yan-neke̱-mo̱ u̱n wu̱. Komo yan-neke̱-mo̱ u̱n wu̱ wo̱ngu̱ru̱ bu̱u̱g-de u̱n hun-ne̱. ");
INSERT INTO uth_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Ko̱ wu̱ ke wu̱ re̱e̱g wu̱ ciig. Yan-neke̱-mo̱ u̱n wu̱ karaksu̱ru̱ to̱ kwange̱ à, ko̱o̱r-u̱t ta'yoor u̱t-caari. ");
INSERT INTO uth_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Ye̱ re̱ to̱ komo à, dugu-u̱s nass 4,000 ye̱ ro̱, hu̱sse̱ ne'a-ne̱ u̱n yakar-ne̱. ");
INSERT INTO uth_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Ka da-de Ye̱so 'yonsu̱ru̱ bu̱u̱g-de u̱n hun-ne̱ ye̱ ji o-hur. Wu̱ co̱wu̱ru̱ hat-o̱ m-ho̱ wu̱ argu̱ru̱ dak-o̱ o-Magadan. ");
INSERT INTO uth_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Parisa-ne̱ u̱n Saduki-ne̱ haaru̱ be-u̱r Ye̱so remen ye̱ megerté̱ wu̱, ye̱ ko̱nu̱ru̱ wu̱ kutu̱ ye̱ yo ken rii-yo u̱t-hyat yo n-To̱n shir, yo he m-wakte̱ o-napa à u̱nze Shir wu̱ to̱mne̱ wu̱. ");
INSERT INTO uth_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Wu̱ shasu̱ru̱ ye̱, wu̱ zee, “U̱rege̱ rim-m no̱mo̱g, no̱ hyene̱ To̱n-o shir no̱mo̱g zá, no̱ m-ze̱e̱, ‘E̱e̱, ho̱-de u̱n buk dea rwu̱u̱n kar kar.’ ");
INSERT INTO uth_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","N-sot komo, no̱ hyene̱ To̱n-o no̱mo̱g zá, no̱ m-ze̱e̱, ‘Caane̱ a hye kem.’ No̱ m-hoks m-nap bo̱ To̱n-o ro̱ u̱r-hew à, amba no̱ hoks o-napa yo Shir ro̱ m-no̱m u̱n ka da-o á. ");
INSERT INTO uth_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Hun-ne̱ ye̱ u̱n ka da-o yo̱-o̱ o̱ ro̱ u̱n gye̱r-o̱ Shir á. Ye̱ co̱no̱g ye̱ hyen o-napa amba yatt napa-o̱ a he ye̱ m-kute̱ á, se̱ o̱ ma Yunanawan-Rwo̱r u̱n Ma-to̱ Shir.” Ka da-de Ye̱so argu̱ru̱, wu̱ yage̱ ye̱ káne̱. ");
INSERT INTO uth_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Bo̱ yan-neke̱-mo̱ u̱n wu̱ woote̱ yo ka riib-yo re̱e̱no̱ à, ye̱ baksu̱ru̱ u̱nze ye̱ bo̱pru̱nte̱ u̱t-buro̱di. ");
INSERT INTO uth_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Ye̱so ze̱e̱ru̱ ye̱, “Tu no̱ yish no̱ nep ha, komo no̱ nom ja u̱n ká yist-mo̱ u̱n Parisa-ne̱ mo̱ ne̱ u̱n mo̱ u̱n Saduki-ne̱.” ");
INSERT INTO uth_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Ye̱ ciri u̱t-ma u̱n hi u̱n de u̱n ye̱ u̱n hi u̱n de u̱n ye̱. Ye̱ ro̱ m-ze̱e̱, “¿Ko̱ remen ka buro̱di-to̱ a bo̱pru̱nde̱ à o̱ wu̱ zette̱ káane̱?” ");
INSERT INTO uth_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Ye̱so nepse̱ yo ye̱ ro̱ u̱s-barag à, wu̱ ze̱e̱ru̱, “No̱ yan-she̱r-m re̱k-mo̱! ¿Remen yan o̱ no̱tte̱ m-ze̱e̱ no̱tt u̱t-buro̱di á? ");
INSERT INTO uth_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Har m-mo̱ka no̱n go̱ nap? ¿To̱-u̱t ke'essu̱te̱ no̱ bo̱ u̱m re̱e̱gte̱ hun-ne̱ dugu-u̱s taan 5,000 u̱n buro̱di-u̱t taan ne̱? ¿Komo ko̱o̱r-u̱t re no̱ karakse̱ to̱ kuse̱? ");
INSERT INTO uth_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","¿No̱ baks hun-ne̱ dugu-u̱s nass 4,000 ye̱ u̱m re̱e̱gte̱ u̱n buro̱di-u̱t ta'yoor? ¿Ko̱o̱r-u̱t re no̱ karakse̱ to̱ kuse̱? ");
INSERT INTO uth_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿Re no̱me̱ no̱ yagu̱te̱ m-nap u̱nze me̱ u̱n ma-to̱ u̱t-buro̱di á? U̱m ze̱e̱g no̱ komo, ‘No̱m no̱ ja u̱n yist-mo̱ u̱n Parisa-ne̱ u̱n Saduki-ne̱ ne̱.’ ” ");
INSERT INTO uth_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Ka da-o̱ yan-neke̱-mo̱ u̱n wu̱ nape̱ u̱nze yist-mo̱ a m-rwo̱ u̱t-buro̱di à mo̱ mo̱ á, amba wu̱ u̱n co̱n ye̱ no̱m ja u̱n yoos-de u̱n Parisa-ne̱ u̱n Saduki-ne̱ de o-she̱pe̱. ");
INSERT INTO uth_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","To̱, bo̱ Ye̱so haante̱ dak-o̱ o-Kaseriya o̱ o-Pirip à, wu̱ citu̱ru̱ yan-neke̱-mo̱ u̱n wu̱. Wu̱ ze̱e̱ru̱, “¿Wan wu̱ hun-ne̱ ro̱ m-ze̱e̱ Wà-wu̱ u̱n ne̱t ro̱?” ");
INSERT INTO uth_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Ye̱ ze̱e̱ru̱, “Ye̱ ken ye̱ ro̱ m-ze̱e̱ Yohana Wa-m-Yo'os u̱n hun-ne̱ m-ho̱, ye̱ ken ye̱ komo E̱reja, ye̱ ken komo Irmiya, ko̱ komo wan-gaan n-me̱ u̱n yan-Rwo̱r u̱n Ma-to̱ Shir n-ga.” ");
INSERT INTO uth_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Ka da-de wu̱ citu̱ru̱ ye̱, “¿Amba no̱ u̱n ya, wan wu̱ ne̱ u̱m ro̱ u̱n hyan-o no̱?” ");
INSERT INTO uth_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simo̱n Bitrus shasu̱ru̱, “Wo̱ wu̱, Kiristi,Wà-wu̱ Shir wan-ho̱o̱g.” ");
INSERT INTO uth_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Ye̱so shasu̱ru̱, wu̱ zee, “Simo̱n wà Yohana, wo̱ ko-ya-o-kwu̱m-wu̱! Remen Tato re wu̱ ro̱ n-To̱n shir à, wu̱ kutu̱ wo̱ to̱ ka, ba ne̱t á. ");
INSERT INTO uth_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","M-mo̱ka u̱m ze̱e̱g wo̱ u̱nze wo̱ ro̱ Bitrus, komo n-to̱n u̱n ka ta'ar-o̱ u̱m he man yan-dor re, komo mo̱ ken mar-mo̱ ro̱tt u̱t-gwo̱mo be-de u̱n ye̱ á. ");
INSERT INTO uth_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Man ya'as wo̱ rii-se u̱n tiks u̱n gwo̱mo-to̱ Shir. Ko̱yan o caase̱ kane̱ u̱n ho̱no o-dak, Shir a caas yo n-To̱n shir. Komo ko̱yan o gage̱ kane̱ u̱n ho̱no o-dak, Shir a geeg yo n-To̱n shir.” ");
INSERT INTO uth_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Wu̱ naku̱ru̱ yan-neke̱-mo̱ u̱n wu̱ u̱t-to̱ m-so̱k ne̱, ye̱ ru̱re̱ ne̱t u̱nze wu̱ ro̱ Kiristi á. ");
INSERT INTO uth_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Cin u̱n ká da-o̱, Ye̱so cire̱ m-kute̱ u̱n yan-neke̱-mo̱ u̱n wu̱ u̱nze, se̱ wu̱ haag bo̱-o̱ o-Urusharima. Komo wu̱ ru̱ru̱ ye̱ yo he wu̱ m-ko̱r re̱e̱no̱ à. Wu̱ su̱u̱t u̱r-ko̱o̱b go̱-u̱s-go̱ be-de u̱n ye̱ ro̱ se̱k-ye̱, u̱n Gwo̱mo-ne̱ ye̱ u̱n ko̱n-se Shir, u̱n ya-u̱r-yoos-de karamsa-o̱ Mosa ne̱. Komo a ho wu̱, u̱n ho̱-u̱r atette̱-de komo a 'yons wu̱. ");
INSERT INTO uth_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Bitrus naku̱ru̱ wu̱ n-riib, wu̱ ciru̱ru̱ wu̱ u̱t-kangse̱. Wu̱ ro̱ m-ze̱e̱, “Go̱s-wu̱, Shir ye̱ peste̱! To̱ ka a nome̱ be u̱n du á.” ");
INSERT INTO uth_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Amba Ye̱so waktu̱ru̱ be-u̱r Bitrus. Wu̱ ze̱e̱ru̱, “Wo̱nge̱ u̱n me̱ ne̱, wo̱ ko-Gwo̱mo-wu̱ u̱n ya-u̱t-ko̱t! Wo̱ ko-yan-rwo̱ u̱r-pu̱kse̱ wu̱ be u̱n de. Remen wo̱ u̱s-barag u̱ntu̱n ne̱t, yanze u̱ntu̱n Shir bo̱ Shir ro̱ u̱s-barag á.” ");
INSERT INTO uth_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Ka da-de Ye̱so ze̱e̱ru̱ yan-neke̱-mo̱ u̱n wu̱, “Myet wu̱ co̱ne̱ wu̱ do̱ru̱ me̱ à, be-u̱r no̱, se̱ wu̱ she̱'e̱g hi u̱n de u̱n wu̱, wu̱ sew kan-o̱ u̱n wu̱, wu̱ do̱ru̱ me̱. ");
INSERT INTO uth_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Remen wu̱ co̱ne̱ wuke̱ u̱n ho̱o̱g-mo̱ u̱n wu̱ à, wu̱a taage̱ u̱n mo̱. Amba kap bo̱n wu̱ taage̱ u̱n ho̱o̱g-mo̱ u̱n wu̱ rem re à, wu̱a kum mo̱. ");
INSERT INTO uth_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","¿Yan yo ne̱ ne̱t he m-kum u̱rege̱ wu̱ kumug kwu̱m-o̱ u̱n ho̱no o-dak kap, amba wu̱ taagu̱ru̱ u̱n ho̱o̱g-mo̱ u̱n wu̱? Ko̱ ne̱, ¿ya ne̱t he m-ya'as be-de u̱n shas-o̱ u̱n ho̱o̱g-mo̱ u̱n wu̱? ");
INSERT INTO uth_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Remen me̱ Wà-wu̱ u̱n ne̱t, man haan u̱n se̱ps-m Tato re ne̱ u̱n yan-to̱m-ye̱ u̱n wu̱ ne̱, man piishe̱ ko̱ wu̱ ke ne̱t-wu̱ u̱t-ma mo̱sse̱ u̱n rii-yo wu̱ no̱me̱ ne̱ à. ");
INSERT INTO uth_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Nip-o̱ me̱ no̱ m-ru̱re̱, ye̱ ken ye̱ ro̱ ko̱n eso eso kane̱ ye̱a mer á, har se̱ ye̱ hyanag haan-mo̱ u̱n Wà-wu̱ u̱n ne̱t n-me̱ u̱n gwo̱mo-u̱t Tato u̱n wu̱.” ");
INSERT INTO uth_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Bo̱ a rewete̱ ho̱-u̱t cind à, Ye̱so de̱ku̱ru̱ Bitrus ne̱, u̱n Yakubu, u̱n Yohana (heno Yakubu) ne̱, wu̱ daaru̱ o-haag u̱n ye̱ ne̱ u̱n ho̱n-de u̱n ye̱. ");
INSERT INTO uth_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Ye̱ ro̱ o-gwo̱t wu̱r-o Ye̱so barmu̱ru̱, co-o̱ u̱n wu̱ no̱mu̱ru̱ m-cu̱cas u̱ntu̱n u̱r-ho̱, matuku-to̱ wu̱ co̱pe̱ à to̱ wargu̱ru̱ u̱t-pus to̱ pyar. ");
INSERT INTO uth_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","U̱n gyept-o̱ u̱n yish, yan-Rwo̱r u̱n Ma-to̱ Shir ye̱ n-ga, Mosa ne̱ u̱n E̱reja rwu̱u̱nu̱ru̱, ye̱ ro̱ u̱t-orom u̱n Ye̱so ne̱. ");
INSERT INTO uth_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Bitrus ze̱e̱ru̱ Ye̱so, “Go̱s-wu̱, nomog u̱r-bon o̱ te̱tte̱ kane̱ à! U̱rege̱ o co̱no̱g, man to̱nd de̱pi-u̱t tet kane̱, u̱r-gaan rem ru, u̱r-gaan rem Mosawan-Rwo̱r u̱n Ma-to̱ Shir, u̱r-gaan komo rem E̱rejawan-Rwo̱r u̱n Ma-to̱ Shir.” ");
INSERT INTO uth_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Wu̱ ro̱ m-rwo̱r u̱t-ma káane̱ ke'ente̱-o̱ m-cu̱cas ho̱kku̱ru̱ ye̱. Ye̱ ho̱gu̱ru̱ co̱r n-me̱ u̱n ká ke'ente̱-o̱ o̱ m-ze̱e̱, “Wu̱ ka wu̱ ro̱ Wà re, wu̱ me̱ m-co̱n à, me̱ m-ho̱ge̱ re̱re̱m-mo̱ u̱n wu̱ de̱e̱n. Raks no̱ ma-to̱ u̱n wu̱!” ");
INSERT INTO uth_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Bo̱ yan-neke̱-mo̱ u̱n wu̱ ho̱gu̱te̱ káane̱ à, gye̱r-o̱ ho̱o̱ru̱ ye̱ de̱e̱n, har ye̱ he̱e̱ru̱ n-dak. ");
INSERT INTO uth_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Ye̱so wo̱o̱nu̱ru̱, wu̱ ci'u̱ru̱ ye̱. Wu̱ zee, “Ine̱ no̱, no̱ ho̱ge̱ o-gye̱r á.” ");
INSERT INTO uth_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Bo̱ ye̱ daste̱ u̱t-hi à, ye̱ hyan ne̱t á se̱ Ye̱so u̱n ho̱n-de u̱n wu̱ cot. ");
INSERT INTO uth_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Bo̱ ye̱ ro̱ m-kergu̱nde̱ u̱n ká haag-o̱ à, Ye̱so naku̱ ye̱ u̱t-to̱. Wu̱ zee, “No̱ ru̱re̱ ne̱t rii-yo no̱ hyane̱ á, se̱ Wà-wu̱ u̱n ne̱t inu̱te̱ u̱t-marimar.” ");
INSERT INTO uth_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Yan-neke̱-mo̱ u̱n wu̱ citu̱ru̱ wu̱. Ye̱ zee, “To̱, ¿remen yan o̱ yan-Yoos-de o-karamsa zette̱ u̱nze, se̱ E̱rejawan-Rwo̱r u̱n Ma-to̱ Shir he'esente̱ ka da-de Kiristi haante̱?” ");
INSERT INTO uth_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Ye̱so shasu̱ru̱, wu̱ zee, “Nip-o̱, E̱reja ro̱o̱n, komo wu̱a ja'as ko̱yan. ");
INSERT INTO uth_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Amba me̱ no̱ m-ru̱re̱, E̱reja be'este̱ wu̱ he'esente̱, ye̱ nap u̱n wu̱ ne̱ á, har ma ye̱ nomotu̱ wu̱ rii-yo ye̱ hyane̱ m-so̱k à. Káane̱ komo Wà-wu̱ u̱n ne̱t he swo̱ u̱r-ko̱o̱b u̱n kom-to̱ u̱n ye̱.” ");
INSERT INTO uth_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Bo̱ Ye̱so zette̱ kaane̱ à, yan-neke̱-mo̱ u̱n wu̱ napu̱ru̱ u̱nze wu̱ ro̱ ye̱ u̱n nome̱ u̱n ma-u̱t Yohana Wa-m-Yo'os u̱n hun-ne̱ m-ho̱. ");
INSERT INTO uth_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Bo̱ ye̱ woote̱ u̱n 'wu̱n-de o-haag à, hun-ne̱ de̱e̱n ro̱ ye̱ u̱r-'er. Wu̱ ken ne̱t-wu̱ haanu̱ru̱ be-u̱r Ye̱so, wu̱ kwu̱ktu̱ru̱ u̱n co-o̱ u̱n wu̱. ");
INSERT INTO uth_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Wu̱ ze̱e̱ru̱, “Go̱s-wu̱, ho̱ge̱ 'wo̱n-u̱r wà re wan-campo̱, wu̱ ro̱ o-tattu̱ra ne̱. Komo wu̱ ro̱ u̱n swo̱ u̱r-ko̱o̱b de̱e̱n. Wu̱ m-bo̱r m-he̱be̱ o-ra, m-ho̱ ne̱. ");
INSERT INTO uth_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","U̱m heete̱ wu̱ be-de yan-neke̱-m ru, amba ye̱ hoks wu̱ m-taase̱ u̱n go̱m á.” ");
INSERT INTO uth_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Ye̱so shasu̱ru̱, “No̱ hun-ne̱ ye̱ m-mo̱ka, yan-ko̱o̱b-de m-she̱r o-nip, ya-u̱r-cikt, ¿har ha-mo̱ u̱n ho̱-u̱t re o̱ u̱m he m-she'et u̱n no̱ ne̱? ¿Har ha-mo̱ u̱n ho̱-u̱t re o̱ u̱m he m-jo̱o̱se̱ u̱n no̱ ne̱? Hantu̱ me̱ no̱ ka wà-wu̱.” ");
INSERT INTO uth_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Ye̱so hurgu̱ru̱ ko-ya-u̱t-ko̱t u̱t-gaag. Ká ko-ya-u̱t-ko̱t-wu̱ ruuru̱, wu̱ yage̱ wà cas. A kane̱ go̱m-o̱ u̱n wà taaru̱. ");
INSERT INTO uth_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Da-o̱ ne̱t ro̱kne̱ be-u̱r Ye̱so á, yan-neke̱-mo̱ u̱n wu̱ haanu̱ru̱ be-de u̱n wu̱. Ye̱ citu̱ru̱ wu̱, “¿Remen yan o̱ te̱ hokste̱ ruut u̱n ká ko-ya-u̱t-ko̱t-wu̱ á?” ");
INSERT INTO uth_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Ye̱so ze̱e̱ru̱ ye̱, “Remen she̱r-m no̱ ro̱ de̱e̱n á. Nip-o̱ me̱ no̱ m-ru̱re̱, u̱rege̱ she̱r-m no̱ wo̱o̱g go̱s-to̱ u̱n go'-yo o-mosta yo jiishe̱ u̱s-re̱k be-de u̱n go̱ kap à, no̱a rees m-ze̱e̱ ka haag-o̱ ine̱ zee-mo̱ u̱n kane̱ ha-mo̱ u̱n re̱e̱no̱, komo o̱a ine̱. Yatt rii-yo he no̱ m-kwange̱ á.” ");
INSERT INTO uth_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","De ken ho̱-de bo̱ ye̱ waragte̱ u̱n dak-o̱ o-Gariri à, Ye̱so ze̱e̱ru̱ ye̱, “A ya'as Wà-wu̱ u̱n ne̱t u̱n kom-to̱ u̱n hun-ne̱. ");
INSERT INTO uth_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Komo ye̱a ho wu̱, u̱n ho̱-u̱r atette̱-de komo a 'yons wu̱.” Yan-neke̱-mo̱ u̱n wu̱ bo̱pu̱ o-regen de̱e̱n. ");
INSERT INTO uth_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Ye̱so u̱n yan-neke̱-mo̱ u̱n wu̱ ne̱ wo̱o̱ru̱ bo̱-o̱ o-Kapanahum. Yan-go̱ks u̱n tar remen Pyo-o̱ Shir haaru̱ be-u̱r Bitrus, ye̱ ze̱e̱ru̱ wu̱, “¿Wan-yoos-u̱r no̱ ro̱ u̱n to̱p u̱n tar-o̱ u̱n Pyo-o̱ Shir?” ");
INSERT INTO uth_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Bitrus shasu̱ru̱, “Wu̱ ro̱ m-to̱p ge̱.” Bitrus co̱wu̱ru̱ o-hur remen wu̱ ru̱ru̱té̱ Ye̱so ka ma-to̱. Cin ba wu̱ u̱n ru̱re̱ Ye̱so, Ye̱so citu̱ru̱ wu̱, “Bitrus ¿Ya o hyane̱ mo̱sse̱ u̱n ká cot-o̱ ne̱? ¿Be-u̱r wan-ne̱ o̱ gwo̱mo-ne̱ ro̱ m-go̱ks u̱n hwo̱r-ye̱ u̱n tar o̱, be-de u̱n yakar-ye̱ u̱n ye̱ o̱, ko̱ be-de u̱n hamat-ne̱ ye̱ ye̱ shipe̱ à?” ");
INSERT INTO uth_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Bitrus shasu̱ru̱, “Be-de u̱n hamat-ne̱.” Ye̱so ze̱e̱ru̱, “Ya-o-dak ro̱ m-to̱p o̱ ka á! ");
INSERT INTO uth_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Kap u̱n kaane̱ ne̱, taase ká hun-ne̱ ho̱ge̱ shoob-u̱r na, he̱be̱ o-mar o jorbe̱ o-kwe̱mbe̱, o hek nu-o̱ u̱n jan-yo o shipe̱ u̱r-takan à. Wo̱a 'wo̱s o-azorpa yo he m-bo'os à, o dek yo o to̱p tar ru u̱n o̱ ma re ne̱.” ");
INSERT INTO uth_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","U̱n ká da-o̱ yan-neke̱-m Ye̱so haaru̱ be-u̱r Ye̱so, ye̱ citu̱ru̱ wu̱, “¿Be u̱n te̱, wa jiishe̱ u̱t-go̱s kap n-me̱ u̱n gwo̱mo-to̱ Shir?” ");
INSERT INTO uth_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Ye̱so agnu̱ru̱ wu̱ ken wà re̱k-wu̱ wu̱, wu̱ e̱ssu̱ wu̱ n-te̱te̱ de u̱n ye̱. ");
INSERT INTO uth_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Ka da-de wu̱ ze̱e̱ru̱, “Nip-o̱ me̱ no̱ m-ru̱re̱, se̱ no̱ ja'aste̱ barag-u̱s no̱ komo no̱ warag u̱ntu̱n yakar re̱k-ye̱, no̱a kum m-co̱w u̱n gwo̱mo-to̱ Shir á, ");
INSERT INTO uth_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Remen kaane̱ myet bo̱n wu̱ muute̱ hi u̱n de u̱n wu̱ ba nu̱-mo̱ u̱r-hi u̱ntu̱n ka wà re̱k-wu̱ wu̱ à, wu̱ jiishe̱ u̱t-go̱s u̱n gwo̱mo-to̱ Shir. ");
INSERT INTO uth_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","“Komo myet bo̱n wu̱ go̱kse̱ wà re̱k-wu̱ u̱ntu̱n wu̱ ka rem re à, me̱ wu̱ go̱kse̱. ");
INSERT INTO uth_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Komo bo̱n wu̱ rwo̱'e̱ wan-gaan n-me̱ u̱n ka yakar-ye̱ she̱re̱ o-nip be u̱n de à, no̱m u̱r-ba'as à, a jiish wu̱ m-re̱re̱m a gege̱ wu̱ ta'ar-de u̱r-na u̱r-ge̱ks, komo a jorbe̱ wu̱ n-me̱ m-sa mo̱ u̱r-du̱w. ");
INSERT INTO uth_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","“Rii-yo u̱r-'wo̱n yo ka wu̱ rwo̱'e̱ ye̱ ken ye̱ no̱m u̱r-ba'as à. Rii-yo u̱n rwo̱ u̱r-ba'as ro̱ ko̱n, amba rii-yo u̱r-'wo̱n yo be-de u̱n ká wu̱ rwo̱'e̱ ka ba'as-de à. ");
INSERT INTO uth_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","U̱rege̱ kom-o ru, ko̱ na-o ru ro̱ wo̱ u̱n rwo̱ u̱r-ba'as, kups o jore̱. A jiish wo̱ o cu̱w ho̱o̱g-o̱ ba m-ta u̱n na-o gaan ko̱ kom-o gaan, o̱tte̱ a jorbe̱ wo̱ n-me̱ o-ra o̱ ro̱ m-ryomse̱ á, u̱n kom-u̱t ru ne̱ u̱t-yoor ko̱ na-u̱s ru u̱s-yoor. ");
INSERT INTO uth_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","U̱rege̱ komo yish u̱n du ro̱ wo̱ m-rwo̱ m-no̱m u̱r-ba'as, hu̱s de o jore̱. A jiish wo̱ o cu̱w ho̱o̱g-o̱ ba m-ta u̱n yish-u̱r gaan ne̱, o̱tte̱ a jorbe̱ wo̱ n-me̱ den-o̱ o-ra u̱n yish ru ne̱ yoor. ");
INSERT INTO uth_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Nap no̱ ha, taase no̱ yo'og ko̱ wan-gaan n-me̱ u̱n ká yakar-ye̱, remen me̱ no̱ m-ru̱re̱, yan-to̱m-ye̱ Shir ye̱ u̱n ye̱ ro̱ be-de Shir Tato re wu̱ ro̱ n-To̱n à. ");
INSERT INTO uth_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“¿Re ne̱ no̱ m-hyan o̱, u̱rege̱ wa-u̱t-gu̱t ro̱ u̱n ca-ne̱ o-zungu 100, gaan-o e̱gu̱ru̱ be-de u̱n ye̱, ya wu̱ he m-no̱m? Wu̱a rees m-yage̱ u̱n ye̱ ká kwo̱o̱z-u̱t nass u̱n o̱p u̱n jero̱ 99 n-to̱n o-haag ye̱ ro̱ u̱t-re̱. Wu̱ heeste̱ hoob-o̱ u̱n ká gaan-yo e̱ge̱ à. ");
INSERT INTO uth_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Komo wu̱ hyande̱ yo, nip-o̱ me̱ no̱ m-ru̱re̱, zak-o̱ wu̱ ro̱ m-nom à, o̱ aragte̱ o̱ u̱n ká kwo̱o̱z-u̱t nass to̱ u̱n o̱p u̱n jero̱ 99. ");
INSERT INTO uth_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Káane̱ o̱, Tato re wu̱ ro̱ n-To̱n shir à, wu̱ co̱n ko̱ wan-gaan be-de u̱n ká yakar-ye̱ e̱ge̱ á.” ");
INSERT INTO uth_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“U̱rege̱ o̱r ru ko-yan-dor nomote̱ wo̱ u̱r-ba'as, neke̱ o ru̱ru̱ wu̱ u̱n ho̱n no̱. U̱rege̱ wu̱ ho̱gu̱te̱ ma-u̱t ru, komo wu̱ ko̱no̱g wo̱ o doog wu̱ o̱ ka m-mu̱u̱nte̱ u̱n co̱w. ");
INSERT INTO uth_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Amba u̱rege̱ wu̱ ho̱gu̱ wo̱ á, o do m-ha be-de u̱n wu̱ u̱n ne̱t ne̱ wan-gaan ko̱ ne̱n yoor, remen kap yo o ze̱e̱ à, a 'wo̱s to̱ o-nip u̱n nu-se u̱n ya-u̱s-to̱r ne̱n yoor ko̱ tet. ");
INSERT INTO uth_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","U̱rege̱ wu̱ yagu̱tu̱ ye̱ m-ho̱ge̱ har m-mo̱ka, o ru̱re̱ hun-ne̱ yan-dor Ye̱so. U̱rege̱ komo har wu̱ yagu̱te̱ m-ho̱ge̱ u̱n hun-ne̱ yan-dor Ye̱so, muut wu̱ u̱ntu̱n wu̱ nape̱ Shir á, ko̱ ko-yan-go̱ks u̱n tar wu̱ nape̱ Shir á. ");
INSERT INTO uth_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Nip-o̱ me̱ no̱ m-ru̱re̱, komo ko̱ yo ke rii-yo o caase̱ kane̱ u̱n ho̱no o-dak, Shir a caas yo n-To̱n shir. Komo ko̱ yo ke rii-yo o gage̱ kane̱ u̱n ho̱no o-dak, Shir a geeg yo n-To̱n shir. ");
INSERT INTO uth_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Man do no̱ m-ru̱re̱ u̱n yo ka, u̱rege̱ hun-ne̱ ne̱n yoor be u̱n no̱ u̱n ho̱no o-dak ye̱ mossu̱te̱ u̱t-hi ye̱ ko̱n yo ken rii-yo, Tato re wu̱ n-To̱n wu̱a nomo ye̱ yo. ");
INSERT INTO uth_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Remen kap be-de hun-ne̱ yoor ko̱ tet karge̱ n-me̱ u̱n jin u̱n de à, me̱ be-u̱r gaan u̱n ye̱ ne̱.” ");
INSERT INTO uth_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","A kane̱ Bitrus wo̱o̱nu̱ru̱, wu̱ ze̱e̱ru̱ Ye̱so, “¿Go̱s-wu̱, re ho̱n o̱ o̱r re he me̱ no̱m u̱r-ba'as u̱m ho'os ká ma-to̱? ¿So̱ ta'yoor o̱?” ");
INSERT INTO uth_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Ye̱so ze̱e̱ru̱ wu̱, “Me̱ zee wo̱ o-ta'yoor á, amba o-ta'yoor har so̱ kwo̱o̱z-u̱t tet u̱n o̱p 490. ");
INSERT INTO uth_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“Remen kaane̱, a hongse̱ gwo̱mo-to̱ Shir u̱n wu̱ ken ko-Gwo̱mo-wu̱ ne̱. Wu̱ co̱ne̱ o̱o̱g u̱n kwu̱m-o̱ u̱n wu̱, o̱ ro̱ u̱n kom-to̱ u̱n gu̱w-ne̱ ye̱ u̱n wu̱ à. ");
INSERT INTO uth_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Bo̱ ká ko-Gwo̱mo-wu̱ cirte̱ u̱r-o̱o̱g à, a hantu̱ru̱ wu̱ ken ne̱t-wu̱, wu̱, wu̱ ro̱ m-do̱re̱ u̱r-mo̱o̱g à de ka ne̱t-wu̱ a hoks m-to̱p á har ta-de u̱n ho̱o̱g-mo̱ u̱n wu̱. ");
INSERT INTO uth_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Bo̱ kwangu̱te̱ wu̱ m-to̱p à, ko-Gwo̱mo rwo̱'u̱ru̱ a beeb wu̱ u̱n ne'a u̱n wu̱ ne̱ u̱n yakar-ne̱ kap u̱n rii-yo wu̱ ro̱tte̱ ne̱ à, remen a topt ká hwo̱r-ye̱. ");
INSERT INTO uth_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","“Ká ko-gu̱w-wu̱ kwu̱ktu̱ru̱ u̱n co-o̱ u̱n wu̱, wu̱ ma'asu̱ u̱s-ko̱n wu̱ ro̱ m-ze̱e̱, ‘Nomo me̱, man tops wo̱ kap.’ ");
INSERT INTO uth_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Ko-Gwo̱mo ho̱gu̱ru̱ 'wo̱n-de u̱n ká ko-gu̱w-wu̱, wu̱ ho'osu̱ru̱ wu̱. Ko-Gwo̱mo yaksu̱ru̱ wu̱, wu̱ yagu̱ru̱ ma-to̱ u̱n ká mo̱o̱g-de. ");
INSERT INTO uth_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Amba ká ko-gu̱w-wu̱ bo̱ u̱n ru-mo̱ u̱n wu̱, wu̱ o̱o̱su̱ru̱ o̱r ru u̱n wu̱ ko-gu̱w, wu̱ wu̱ ro̱ m-do̱re̱ u̱r-mo̱o̱g hiin à, wu̱ re̱e̱ru̱ wu̱ u̱s-co̱r. Wu̱ zee, ‘To̱p me̱ rii-yo me̱ wo̱ m-do̱re̱ à!’ ");
INSERT INTO uth_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","“O̱r ru u̱n wu̱ u̱n ko-gu̱w kwu̱ktu̱ru̱, wu̱ ko̱nu̱ru̱ wu̱. Wu̱ zee, ‘Nomo me̱, man tops wo̱.’ ");
INSERT INTO uth_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Amba ká ko-gu̱w-wu̱ yage̱, har wu̱ haaru̱, komo wu̱ cu̱wtu̱ru̱ wu̱ u̱n kur-o̱ m-ke'et, se̱ da-o̱ wu̱ to̱pe̱ ká mo̱o̱g-de à. ");
INSERT INTO uth_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","“Bo̱ o̱r re u̱n wu̱ u̱n gu̱w-ne̱ ho̱ge̱ rii-yo no̱me̱ à, ye̱ ho̱ge̱ m-re̱re̱m á. Ye̱ ru̱ru̱ ko-Gwo̱mo myet bo̱ no̱me̱ à. ");
INSERT INTO uth_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Ko-Gwo̱mo agbu̱ru̱ ká ko-gu̱w-wu̱. Wu̱ ze̱e̱ru̱ wu̱, ‘Wo̱ ko-gu̱w, wan-me̱n-u̱t jaas-to̱, u̱m yaksu̱tu̱ wo̱ kap mo̱o̱g-de o de̱ku̱ me̱ à. Me̱ u̱n yaksu̱ wo̱ de remen o ko̱no̱g me̱. ");
INSERT INTO uth_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Ashi, ¿no̱m u̱r-bon o ho̱ge̱ 'wo̱n-u̱r o̱r ru bo̱ u̱m ho̱ge̱ 'wo̱n u̱n du á?’ ");
INSERT INTO uth_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Ko-Gwo̱mo swo̱o̱ru̱ u̱s-ryaab de̱e̱n. Wu̱ rwo̱'u̱ru̱ a 'ye wu̱ u̱r-ko̱o̱b har se̱ wu̱ to̱k kap o̱ u̱n ká mo̱o̱g-de. ");
INSERT INTO uth_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","“Káane̱ komo Tato re wu̱ n-To̱n shir he m-no̱me̱ u̱n ko̱ wu̱ ke be u̱n no̱ wu̱ yage̱ ho'os u̱n ba'as-u̱r o̱r re u̱n wu̱ hur-u̱r gaan à.” ");
INSERT INTO uth_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Bo̱ Ye̱so komte̱ rwo̱r u̱n se̱ ká rem-se à, wu̱ yagu̱ dak-o̱ o-Gariri. Wu̱ co̱wu̱ru̱ so̱ u̱n dak-o̱ o-Judiya, komo wu̱ pasu̱ru̱ so̱ u̱n ho̱ran-de u̱n Ro̱o̱g-o̱ o-Joda à. ");
INSERT INTO uth_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Hun-ne̱ u̱t-mo̱o̱r ne̱ do̱ru̱ru̱ wu̱, wu̱ taasu̱ru̱ hun-ne̱ ya-u̱s-go̱m re̱e̱no̱. ");
INSERT INTO uth_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Káne̱, ye̱ ken Parisa-ne̱ ye̱ haane̱ be-de u̱n wu̱ remen ye̱ cept wu̱, u̱n kà cot-o̱, “¿N-me̱ u̱n karamsa-o na, o̱ ya'ag ne̱t co̱w wu̱ ho'oste̱ ne'a u̱n wu̱ remen ko̱ yo ke rii-yo?” ");
INSERT INTO uth_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Ye̱so shasu̱ru̱ ye̱, “¿Ashi, no̱ karante̱ Ma-to̱ Shir á? Ka wu̱ no̱mu̱ ye̱ cin u̱r-takan à, ‘Wu̱ u̱n no̱m ye̱ campo̱ u̱n ne'a ne̱.’ ");
INSERT INTO uth_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Wu̱ ze̱e̱ru̱ komo, ‘Remen kaane̱, ne̱t a yage̱ tato u̱n wu̱ u̱n inu u̱n wu̱ ne̱, wu̱ mo̱mse̱ ne'a u̱n wu̱ o-wu̱r. Ye̱ komo yoor, ye̱a warag gaan.’ ");
INSERT INTO uth_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Har kane̱ co ye̱a warag hun-ne̱ yoor á, se̱ de̱ wan-gaan. Remen kaane̱, rii-yo Shir gage̱ à, taase ne̱t us yo á.” ");
INSERT INTO uth_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Ye̱ ze̱e̱ru̱ wu̱, “To̱, ¿remen yan o̱ Mosawan-Rwo̱r u̱n Ma-to̱ Shir nomte̱ o-karamsa a ya'as taku̱rda-o̱ u̱n caas u̱t-ge, komo a ho'os ne'a?” ");
INSERT INTO uth_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Ye̱so ze̱e̱ru̱ ye̱, “Remen cikt-u̱r no̱, o̱ rwo̱'e̱ Mosa yagu̱te̱ no̱ ho'os ne'a no̱ ne̱, amba cin u̱r-takan káane̱ o̱ Shir co̱ne̱ á. ");
INSERT INTO uth_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Me̱ no̱ komo m-ru̱re̱, myet bo̱ u̱n campo̱ wu̱ ho'ose̱ ne'a u̱n wu̱ à, u̱n yatte̱ be-de o-ás a bo̱pe̱ ká ne'a-wu̱ á, komo wu̱ ge ho̱r-wu̱, wu̱ no̱mo̱g o-ás o̱ ka.” ");
INSERT INTO uth_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Yan-neke̱-m Ye̱so ze̱e̱ru̱ wu̱, “U̱rege̱ kaane̱ o̱ to̱ ro̱, ne̱t u̱n ne'a u̱n wu̱ ne̱, ashi ma jiishte̱ o̱ ka ne̱t she'et ba u̱t-ge.” ");
INSERT INTO uth_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Amba wu̱ ze̱e̱ru̱ ye̱, “Ba ho̱n u̱n ne̱t o̱ he m-hoks m-de̱k u̱n ka ma-to̱ á se̱ de̱ ye̱ Shir ya'e̱ u̱r-be̱e̱b à. ");
INSERT INTO uth_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Ye̱ ken ye̱ ro̱ ko̱n ye̱ a mate̱ ye̱ she'et ba u̱t-ge à, remen ye̱tt m-campo̱ á. Ye̱ ken ye̱ ro̱ ko̱n ye̱ hun-ne̱ musse̱ kaane̱ à, ba m-campo̱. Ye̱ ken ye̱ ro̱ ko̱n komo ye̱ e̱sse̱ ye̱a ge u̱t-ge á, remen co̱n-to̱ u̱n Gwo̱mo-to̱ Shir. Myet wu̱ he m-hoks m-de̱k u̱n ka ma-to̱ à wu̱ dek.” ");
INSERT INTO uth_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Ka da-o̱ hun-ne̱ hantu̱ru̱ Ye̱so yakar re̱k-ye̱ remen wu̱ cit ye̱ u̱n kom-to̱ u̱n wu̱ komo wu̱ konoté̱ ye̱ u̱s-ko̱n. Amba yan-neke̱-mo̱ u̱n wu̱ huru̱ru̱ ká ye̱ hante̱ ká yakar-ye̱ à u̱t-gaag. ");
INSERT INTO uth_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Amba Ye̱so ze̱e̱ru̱ ye̱, “Yagu̱ no̱ yakar re̱k-ye̱ haante̱ be u̱n de. No̱ we̱n ye̱ á. Remen gwo̱mo-to̱ Shir to̱ ma u̱n ye̱ to̱.” ");
INSERT INTO uth_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Wu̱ seke̱ ye̱ kom-to̱ u̱n wu̱ u̱r-hi, wu̱ hu̱u̱te̱ ye̱ nu-o̱ u̱r-bon. Ká da-o̱ wu̱ argu̱ru̱. ");
INSERT INTO uth_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","A kane̱ wu̱ ken wu̱ haaru̱ be-u̱r Ye̱so u̱n kà cot-o̱ ne̱, “Wa-u̱r-Yoos, ¿yan rii-yo ne̱ u̱m he m-no̱m so̱-yo u̱m kumut ho̱o̱g-mo̱ ba m-ta à?” ");
INSERT INTO uth_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Ye̱so ze̱e̱ru̱ wu̱, “¿Remen yan o̱ wo̱ttu̱ me̱ u̱n cot-se u̱n rii-yo ro̱ so̱-yo à? Ai, so̱-wu̱ ro̱ ko̱n á se̱ Shir cot. Amba remen u̱m shest wo̱ cot-o ru, u̱rege̱ o co̱no̱g o kum ho̱o̱g-o̱ ba m-ta, se̱ o gye̱re̱g rii-yo ká karamsa-o̱ zee à.” ");
INSERT INTO uth_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Ká ne̱t-wu̱ ze̱e̱ru̱ Ye̱so, “¿To̱ ke karamsa-to̱?” Ye̱so shasu̱ru̱, “Wo̱ ho̱ ne̱t á, wo̱ hoob ne'a-wu̱ u̱n ne̱t á, Wo̱ hiw u̱r-hyow á. Wo̱ no̱m to̱r-se u̱t-bo̱ á. ");
INSERT INTO uth_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Hyan tato ru u̱n inu ru ne̱ u̱t-go̱s ne̱. Komo o cu̱n wan-bo̱r-u̱s ru bo̱ o co̱ne̱ hi u̱n du à.” ");
INSERT INTO uth_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Ká ne̱t-wu̱ ze̱e̱ru̱ Ye̱so, “Ai, u̱m do̱ru̱ssu̱te̱ to̱ ká myet, ¿ya kusu me̱?” ");
INSERT INTO uth_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Ye̱so ze̱e̱ru̱ wu̱, “U̱rege̱ o co̱no̱g o warag kashi u̱n ne̱t hond hond, neke̱ o beeb ho̱no u̱n rii-yo wo̱tte̱ à kap, o ya'as ko̱o̱b-ne̱ hwo̱r, wo̱a kum u̱r-'yons n-To̱n shir. Ka da-o̱ o haan, o do̱ru̱ me̱.” ");
INSERT INTO uth_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Bo̱ ká ne̱t-wu̱ ho̱gu̱te̱ kaane̱ à, wu̱ argu̱ m-arag u̱n tu̱k-mo̱ u̱t-me̱n, remen wu̱ ro̱ o-kwu̱m ne̱ de̱e̱n. ");
INSERT INTO uth_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Ka da-de, Ye̱so ze̱e̱ru̱ yan-neke̱-mo̱ u̱n wu̱, “Nip-o̱ me̱ no̱ m-ru̱re̱, ba u̱n ka yish-ye̱ hun-ne̱ he kum u̱n ko-ya-o-kwu̱m-wu̱ he m-co̱w u̱n gwo̱mo-to̱ Shir n-To̱n à. ");
INSERT INTO uth_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Man do no̱ m-ru̱re̱. A jiish m-so̱k dorom-yo cu̱w u̱n ish-o̱ o-be̱r, o̱tte̱ ko-ya-o-kwu̱m cu̱w u̱n gwo̱mo-to̱ Shir à.” ");
INSERT INTO uth_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Bo̱ yan-neke̱-mo̱ u̱n wu̱ ho̱gu̱te̱ káane̱ à, ye̱ bo̱pu̱ru̱ o-nu. Ye̱ ze̱e̱ru̱, “U̱rege̱ káá o̱, ¿wan wu̱ u̱n ya he kum u̱n gwu̱?” ");
INSERT INTO uth_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Amba Ye̱so gwo̱tu̱ru̱ ye̱, wu̱ ze̱e̱ru̱, “Be-de u̱n hun-ne̱, to̱a nome̱ á. Amba be-de Shir ko̱ yo ke rii-yo yo m-nome̱ yo.” ");
INSERT INTO uth_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Ka da-de Bitrus ze̱e̱ru̱ wu̱, “Te̱ yagu̱te̱ ko̱yan remen te̱ do̱ru̱tú̱ wo̱. To̱, ¿ya te̱ he m-kum?” ");
INSERT INTO uth_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Ye̱so shasu̱ru̱, “Nip-o̱ me̱ no̱ m-ru̱re̱, u̱n ka da-o ro̱o̱ne̱ à, da-o̱ Wà-wu̱ u̱n ne̱t he m-she'et u̱n gwo̱mo-to̱ u̱n wu̱ to̱ u̱t-go̱s à, no̱ ye̱ do̱ru̱ me̱ à, no̱ ye̱ komo he m-she'et u̱n de̱e̱g-to̱ u̱n gwo̱mo-u̱t o̱p u̱t-yoor 12. No̱ ye̱ he piishe̱ u̱n baag-u̱t o̱p u̱t-yoor 12 to̱ u̱n Isra-ne̱ u̱t-ma. ");
INSERT INTO uth_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Komo kap o̱ u̱n wu̱ yagne̱ u̱t-hur ko̱ hen-ne̱ ye̱ u̱n wu̱, ko̱ se̱k-ye̱ u̱n wu̱, ko̱ o-tato, ko̱ o-inu, ko̱ yakar, ko̱ u̱t-kat, remen jin u̱n de, wu̱a kum rii-yo arge̱ kaane̱ à u̱t-be o-zungu 100, komo wu̱ kum ho̱o̱g-mo̱ ba m-ta. ");
INSERT INTO uth_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Amba de̱e̱n be-de u̱n ye̱ a m-hyan go̱s-ye̱ m-mo̱ka à ye̱a warag re̱k-ye̱. Ka ye̱ a m-hyan re̱k-ye̱ m-mo̱ka à, ye̱a warag go̱s-ye̱. ");
INSERT INTO uth_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Gwo̱mo-to̱ Shir u̱ntu̱n wu̱ ken ko-ya-o-kat-wu̱ to̱ ro̱ wu̱ ru'e̱ n-sot n-sot à, remen wu̱ ho̱bo̱nté̱ ya-u̱r-gu̱wu̱s u̱n kat-o̱ u̱n wu̱. ");
INSERT INTO uth_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Bo̱ ye̱ hongsu̱te̱ hwo̱r-ye̱ a m-to̱p u̱n ya-u̱r-gu̱wu̱s u̱n taas u̱r-ho̱ à, wu̱ heetu̱ru̱ ye̱ u̱n kat-o̱ u̱n wu̱. ");
INSERT INTO uth_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","“Hohond-mo̱ u̱n kwo̱m-u̱s jero̱ se n-sot, wu̱ ro̱ m-arag be-de u̱n ya-u̱t-baab, wu̱ hyanu̱ru̱ ye̱ ken ye̱ ro̱ u̱n she'et-de o-hwaa temb n-riib be-de u̱t-baab. ");
INSERT INTO uth_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Wu̱ ze̱e̱ru̱ ye̱, ‘No̱, neke̱ no̱ u̱n kat-o re, man top no̱ rii-yo depe̱ à.’ Ye̱ neku̱ru̱ u̱n kat-o̱ u̱n wu̱. ");
INSERT INTO uth_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Bo̱ wu̱ dotte̱ m-ru ho̱-u̱r ro̱ u̱r-hi à, komo u̱n hohond-mo̱ u̱n kwo̱m-u̱s tet, wu̱ de̱ku̱ru̱ ye̱ ken ya-u̱r-gu̱wu̱s ye̱. ");
INSERT INTO uth_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","“Har m-mo̱ka hohond-mo̱ u̱n kwo̱m-u̱s taan se m-rim, wu̱ dooru̱ m-ru wu̱ hyanu̱ ye̱ ken ye̱ ro̱ eso eso ye̱ ro̱tt yo m-no̱m á. Wu̱ citu̱ru̱ ye̱, ‘¿Remen yan o̱ no̱tte̱ u̱n she'et-de o-hwaa taas u̱r-ho̱?’ ");
INSERT INTO uth_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","“Ye̱ shasu̱ru̱ wu̱, ‘Remen yatt-wu̱ ya'asu̱ te̱ rii-yo m-no̱m á.’ “Ká ko-ya-o-kat-wu̱ ze̱e̱ru̱ ye̱, ‘Neke̱ no̱ u̱n kat-o re, no̱a 'wo̱s ye̱ ken ye̱ no̱ mo̱sse̱ m-se̱nge̱ u̱n ye̱ ne̱.’ ");
INSERT INTO uth_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Bo̱ rim-m nomte̱ à, ko-ya-o-kat ze̱e̱ru̱ wan-co be-de u̱n gu̱w-ne̱ ye̱ u̱n wu̱, ‘Ha o gwo̱to̱n ya-m-se̱nge̱ o-kat. Agbe̱ ye̱ o to̱p ye̱, shi'in u̱n ya-u̱r-bu̱ste̱ ha-mo̱ u̱n ya-u̱r-takan.’ ");
INSERT INTO uth_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","“Da-o̱ a to̱pe̱ ka ye̱ haane̱ hohond-mo̱ u̱n kwo̱m-u̱s taan à, ko̱ wu̱ ke go̱ksu̱ru̱ rii-yo depe̱ a top wu̱ u̱n taas u̱r-ho̱ à. ");
INSERT INTO uth_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","To̱, da-o̱ ka ye̱ ba'e̱ m-neke̱ o-kat à, sho̱gbe̱ ye̱ go̱kste̱ top-o̱ u̱n ye̱ à, ye̱ ro̱ o-gwo̱t ye̱ zee a top ye̱ arge̱ o̱r u̱n ye̱ ne̱. Amba ko̱ wu̱ ke go̱ksu̱ru̱ rii-yo depe̱ a to̱p wu̱ u̱n taas u̱r-ho̱ à. ");
INSERT INTO uth_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Bo̱ ye̱ go̱kste̱ top-o̱ u̱n ye̱ à, ye̱ ma'asu̱ru̱ ko-ya-o-kat u̱s-hwu̱hwu̱mu̱g. ");
INSERT INTO uth_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Ye̱ ze̱e̱ru̱, ‘Ye̱ wo̱o̱ne̱ u̱r-bu̱ste̱ à se̱nge̱-mo̱ u̱n kwo̱m-o gaan ye̱ no̱me̱, amba o to̱k ye̱ hond hond u̱n te̱ ne̱, te̱ ye̱ taase̱ u̱r-ho̱ m-se̱nge̱ m-swo̱ n-no̱o̱nho̱ à.’ ");
INSERT INTO uth_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Wu̱ shasu̱ru̱ wan-gaan be-de u̱n ye̱, wu̱ ze̱e̱ru̱, ‘Wan-yen de, ai, me̱ re̱ ra-o ru á. ¿A hongse̱, u̱m zee man top wo̱ rii-yo a m-to̱p u̱n taas u̱r-ho̱ á? ");
INSERT INTO uth_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Go̱ks rii-yo ro̱ yo ma ru à o arag. U̱n no̱m me̱ m-so̱k u̱m to̱p ye̱ bu̱ste̱ m-wo̱o̱n à hond hond u̱n rii-yo u̱m to̱pu̱ wo̱ ne̱ à. ");
INSERT INTO uth_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","¿Me̱tt o̱ u̱r-be̱e̱b u̱m nomot yo u̱m co̱ne̱ u̱n hwo̱r re á? ¿Ko̱ wo̱ m-ho̱ge̱ u̱r-shoob o̱ remen me̱ kashi u̱n ne̱t-wu̱?’ ");
INSERT INTO uth_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","“Káane̱ o̱ heye̱ be-de u̱n ye̱ a m-hyan ye̱ ro̱ go̱s-ye̱ m-mo̱ka à, ye̱a warag re̱k-ye̱. Kane̱ komo ye̱ a m-hyan re̱k-ye̱ m-mo̱ka à, ye̱a warag go̱s-ye̱.” ");
INSERT INTO uth_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Bo̱ Ye̱so u̱n yan-neke̱-mo̱ u̱n wu̱ ne̱ ro m-neke̱ o-Urusharima à, Ye̱so hessu̱ru̱ n-riib n-co̱w u̱n ye̱ ne̱ u̱n ho̱n-de u̱n ye̱, wu̱ ru̱ru̱ ye̱ yo he m-ko̱r u̱n wu̱ ne̱ à wukusse̱. ");
INSERT INTO uth_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“A wo no̱ o-Urusharima. A ya'as Wà-wu̱ u̱n ne̱t u̱n kom-to̱ u̱n Gwo̱mo-ne̱ ye̱ u̱n ko̱n-se Shir u̱n yan-Yoos-de o-karamsa ne̱. Ye̱a piish wu̱ u̱t-ma, remen a hoot wu̱. ");
INSERT INTO uth_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Ka da-o̱ ye̱a ya'as wu̱ u̱n kom-to̱ u̱n Roma-ne̱. Ye̱ nomo wu̱ u̱r-ar, ye̱ nomo wu̱ u̱s-so̱ro̱g, komo ye̱ kem wu̱. Amba u̱n ho̱-u̱r atette̱-de a 'yons wu̱.” ");
INSERT INTO uth_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Ka da-o̱, inu yakar Ze̱be̱di haanu̱ru̱ be-u̱r Ye̱so u̱n yakar-ye̱ u̱n wu̱ ne̱, Yakubu u̱n Yohana ne̱. Wu̱ kwu̱ktu̱ru̱ u̱n co-o̱ u̱n wu̱, wu̱ ko̱nu̱ru̱ Ye̱so yo ken rii-yo. ");
INSERT INTO uth_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Ye̱so ze̱e̱ru̱ wu̱, “¿Ya o co̱ne̱?” Wu̱ ze̱e̱ru̱ wu̱, “Rwo̱ kà yakar re yoor-ye̱ m-she'et, wan-gaan u̱n re̱ u̱n du, wan-gaan u̱n kwanta u̱n du, n-me̱ u̱n gwo̱mo-u̱t ru.” ");
INSERT INTO uth_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Amba Ye̱so ze̱e̱ru̱ ye̱, “No̱ nap rii-yo no̱ u̱s-ko̱n á! ¿No̱a hoksu̱sse̱ m-swo̱ ibitte̱-de u̱r-ko̱o̱b de u̱m he m-swo̱?” Ye̱ ze̱e̱ru̱ wu̱, “Te̱a hoks.” ");
INSERT INTO uth_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Wu̱ ze̱e̱ru̱ ye̱, “M-so̱k ne̱, no̱a su̱ ibitte̱ u̱n de. Amba she'et-de u̱n re̱ u̱n de ko̱ kwanta u̱n de me̱ wu̱ ro̱ wan-gwo̱mo-to̱ m-'ya á. Tato re wu̱ n-To̱n shir, wu̱ zo̱ngse̱ ka be-to̱, remen ká ye̱ wu̱ daage̱ à.” ");
INSERT INTO uth_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Bo̱ yan-neke̱-m Ye̱so ye̱ kuse̱ ne̱n o̱p à ho̱gu̱te̱ yo Yakubu u̱n Yohana ko̱n ne̱ à, ryaab-u̱s re̱e̱ru̱ ye̱ remen ká ne̱n yoor-ye̱. ");
INSERT INTO uth_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Amba Ye̱so agnu̱ru̱ ye̱ be-u̱r gaan myet. Wu̱ ze̱e̱ru̱, “No̱ nak u̱nze ka ye̱ u̱t-gwo̱mo to̱ u̱n ye̱ ro Yahuda ne̱ á, ye̱ ro̱ u̱n ho̱ge̱ m-re̱re̱m mo̱ u̱n kute̱ u̱n hun-ne̱ ye̱ u̱n ye̱ u̱r-be̱e̱b. Komo ye̱ ro̱ go̱s-ye̱ go̱s-ye̱ u̱n ye̱ à, ye̱ ro̱ u̱n ho̱ge̱ m-re̱re̱m ye̱ kutute̱ ye̱ ro̱ u̱n ku̱s-o̱ u̱n ye̱ à u̱t-gwo̱mo. ");
INSERT INTO uth_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","U̱ depe̱ kaane̱ be u̱n no̱ á. Bo̱n wu̱ co̱ne̱ wu̱ warag go̱s-wu̱ be u̱n no̱ à se̱ wu̱ nomote̱ o̱r u̱n wu̱ ne̱ m-gu̱w. ");
INSERT INTO uth_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Komo bo̱ u̱n wu̱ co̱ne̱ wu̱ warag co be u̱n no̱ à, se̱ wu̱ waragte̱ ko-gu̱w no̱. ");
INSERT INTO uth_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Ko̱ me̱ ma, Wà-wu̱ u̱n ne̱t me̱ haan remen a nomotú̱ me̱ m-gu̱w á, se̱ de̱ remen u̱m nomoté̱ ye̱ ken ye̱ m-gu̱w. Komo u̱m ya'asté̱ ho̱o̱g-m re remen u̱m rurut hun-ne̱ de̱e̱n.” ");
INSERT INTO uth_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Bo̱ Ye̱so u̱n yan-neke̱-mo̱ u̱n wu̱ ne̱ inu̱te̱ ye̱ yage̱ bo̱-o̱ o-Jeriko à, hun-ne̱ de̱e̱n do̱ru̱ru̱ wu̱ n-jim. ");
INSERT INTO uth_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Ye̱ 'wo̱ssu̱ru̱ ye̱ ken po̱-ne̱ ye̱ yoor, ye̱ ro tara tara n-riib n-co̱w. Bo̱ ye̱ ho̱gu̱te̱ Ye̱so ro m-arag u̱n ká co̱w-yo à, ye̱ damu̱ u̱s-co̱r. Ye̱ ze̱e̱ru̱, “Go̱s-wu̱, Wà Dawuda! Ho̱ge̱ 'wo̱n u̱n te̱!” ");
INSERT INTO uth_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Hun-ne̱ kangsu̱ru̱ ye̱, ye̱ re̱s temb. Ye̱ dooru̱ m-dak u̱s-co̱r. Ye̱ zee, “Go̱s-wu̱, Wà Dawuda! Ho̱ge̱ 'wo̱n u̱n te̱!” ");
INSERT INTO uth_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Ye̱so argu̱ m-e̱s u̱n co̱w, wu̱ ze̱e̱ru̱, “¿Ya no̱ co̱ne̱ u̱m nomo no̱?” ");
INSERT INTO uth_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Ye̱ ze̱e̱ru̱ wu̱, “Go̱s-wu̱, te̱ co̱no̱g te̱ kum hyan-o̱ o-bo̱.” ");
INSERT INTO uth_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Ye̱so ho̱gu̱ru̱ 'wo̱n-de u̱n ye̱. Wu̱ ci'u̱ru̱ yish-ye̱ u̱n ye̱. Ba u̱n rem, ye̱ ciru̱ m-hyan! Ye̱ do̱ru̱ru̱ wu̱. ");
INSERT INTO uth_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Bo̱ Ye̱so u̱n yan-neke̱-mo̱ u̱n wu̱ ne̱ woote̱ bo̱-o̱ o-Bapaji à, o̱ ro̱ yow yow o-Urusharima ne̱ à, be-de u̱n Haag-o̱ u̱n 'yo-se o-Ze̱tun, Ye̱so to̱mu̱ru̱ yan-neke̱-mo̱ u̱n wu̱ ne̱n yoor. ");
INSERT INTO uth_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Wu̱ ze̱e̱ru̱ ye̱, “Co̱w no̱ kà bo̱-o̱ ro̱ u̱n co no̱ à. U̱n ra-o̱ no̱ tu̱wte̱ à, no̱a hyen yo ken janka-yo ke'o, u̱n wà u̱n yo ne̱ n-riib. No̱ ussu̱ndu̱ ye̱, no̱ hantu̱ me̱. ");
INSERT INTO uth_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Wu̱ ken wu̱ citu̱ no̱ yo no̱ m-no̱m à, zee no̱ wu̱, ‘Go̱s-wu̱ wu̱ co̱nu̱ ye̱.’ Wu̱a ya'asu̱ndu̱ no̱ ye̱ ba u̱n naas o-da.” ");
INSERT INTO uth_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","To̱ ka a u̱n no̱m to̱ remen a shoosté̱ rii-yo wan-Rwo̱r u̱n Ma-to̱ Shir rwo̱re̱ à u̱nze, ");
INSERT INTO uth_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Ze̱e̱ no̱ hun-ne̱ ye̱ o-Urusharima, Ko-Gwo̱mo no̱ wu̱ ka ro̱o̱ne̱ be u̱n no̱, Ko-yan-gwu̱gwe̱r-mo̱ u̱r-hi wu̱, Wu̱ ro̱ n-to̱n o-janka, wu̱ ro̱ n-to̱n wà-yo o-janka.” ");
INSERT INTO uth_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Ká yan-neke̱-mo̱ u̱n wu̱ ye̱ yoor haaru̱, ye̱ no̱mu̱ru̱ bo̱ Ye̱so zee ye̱ nom à. ");
INSERT INTO uth_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Ye̱ hantu̱ru̱ o-janka u̱n wà u̱n yo ne̱. Ye̱ neksu̱ru̱ matuku-to̱ u̱n ye̱ n-to̱n u̱n wà-yo o-janka. Wu̱ daaru̱ yo, wu̱ she'etu̱ru̱. ");
INSERT INTO uth_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Hun-ne̱ u̱t-mo̱o̱r ne̱ neksu̱ru̱ matuku-to̱ u̱n ye̱ n-dak n-co̱w. Ye̱ ken ye̱ komo ye̱ jetmu̱nu̱ru̱ wa-to̱ u̱s-'yo ye̱ neksu̱ru̱ n-co̱w. ");
INSERT INTO uth_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Hun-ne̱ ye̱ ro̱ u̱n co-o̱ u̱n wu̱ à u̱n ye̱ ro̱ m-do̱re̱ u̱n jim-de u̱n wu̱ ne̱ à. Ye̱ damu̱ u̱s-co̱r, ye̱ zee, “Bo̱ngo̱n-u̱r kumute̱ be-u̱r Wà Dawuda! Ko-ya-o-kwu̱m-wu̱, wu̱ ro̱ m-haan u̱n be̱e̱b-de u̱n Yawe à! Bo̱ngo̱n-u̱r kumute̱ be-de Shir n-To̱n!” ");
INSERT INTO uth_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Bo̱ Ye̱so cu̱wte̱ o-Urusharima à, hun-ne̱ ma'asu̱ru̱ u̱s-cot, ye̱ ro̱ m-ze̱e̱, “¿Wan wu̱ ne̱ wu̱ kà?” ");
INSERT INTO uth_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Se̱ hun-ne̱ ye̱ ro̱ m-do̱re̱ u̱n Ye̱so à, ye̱ ze̱e̱ru̱, “Ai, wu̱ ka wu̱ ro̱ wan-rwo̱r u̱n Ma-to̱ Shir, Ye̱so wu̱ o-Nazaret o̱ u̱n dak-o̱ o-Gariri.” ");
INSERT INTO uth_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Ye̱so co̱wu̱ru̱ u̱n Pyo-o̱ Shir, wu̱ hyanu̱ru̱ myet ya-m-o̱ u̱n ya-u̱t-baab ne̱ n-me̱. Wu̱ wagarsu̱ru̱ de̱e̱g-to̱ u̱n yan-shas-o̱ u̱n hwo̱r, u̱n de̱e̱g-to̱ u̱n yan-baab-to̱ u̱n tantabara-ne̱. ");
INSERT INTO uth_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Wu̱ ze̱e̱ru̱ ye̱, “Gense̱ to̱ ro̱, ‘A eeg hur-o re hur-o̱ u̱s-ko̱n,’ amba no̱ muute̱ o̱ be-de u̱n wuke̱-de u̱n hyow-ne̱.” ");
INSERT INTO uth_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Po̱-ne̱ u̱n ryam-ne̱ ne̱ haanu̱ru̱ be-de u̱n wu̱ u̱n Pyo-o̱ Shir, wu̱ taasu̱ru̱ go̱m-se u̱n ye̱. ");
INSERT INTO uth_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Amba bo̱ Gwo̱mo-ne̱ ye̱ u̱n ko̱n-se Shir u̱n yan-Yoos-de o-karamsa ne̱ hyente̱ rem-se o-made̱ se wu̱ no̱me̱ à, har yakar ro̱ u̱n dak u̱s-co̱r n-me̱ u̱n Pyo-o̱ Shir ye̱ ro̱ m-ze̱e̱, “Bo̱ngo̱n-u̱r depete̱ be-u̱r Wà Dawuda,” yan-co swo̱o̱ru̱ u̱s-ryaab. ");
INSERT INTO uth_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Ye̱ ze̱e̱ru̱ Ye̱so, “¿Wo̱ m-ho̱ge̱ u̱n rii-yo ká yakar-ye̱ ro̱ m-ze̱e̱?” Ye̱so shasu̱ru̱, wu̱ zee, “Eba, ashi, ¿no̱ we̱t m-karante̱ n-me̱ u̱n Ma-to̱ Shir á? To̱ zee, “ ‘Wo̱ wu̱ yoose̱ yakar u̱n yan-yaar-ne̱ ye̱ nomo wo̱ u̱r-bo̱ngo̱n.’ ” ");
INSERT INTO uth_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Bo̱n káne̱, wu̱ yagu̱ru̱ ye̱, wu̱ ruuru̱ u̱n ká bo̱-o̱, wu̱ argu̱ru̱ o-Betanya, wu̱ rewu̱ru̱ re̱e̱no̱. ");
INSERT INTO uth_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Bo̱ ish geste̱ à, n-sot Ye̱so ro̱ m-warag o-Urusharima me̱r re̱e̱ru̱ wu̱. ");
INSERT INTO uth_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Bo̱ wu̱ hyente̱ yo ken 'yo-yo o-rum yo n-riib n-co̱w à, wu̱ haaru̱ u̱n ká 'yo-yo. Amba wu̱ kum rii á se̱ u̱t-wa. Wu̱ ze̱e̱ru̱ ká 'yo-yo, “Wo̱a do mat u̱n yakar á har o nomot re!” A kane̱ ká rum-yo hwo̱'u̱ru̱ kaw. ");
INSERT INTO uth_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Bo̱ yan-neke̱-mo̱ u̱n wu̱ hyente̱ káane̱ à, ye̱ bo̱pu̱ o-nu. Ye̱ ze̱e̱ru̱, “¿Re no̱me̱ ká rum-yo hu̱'u̱te̱ káane̱ ba u̱n rem?” ");
INSERT INTO uth_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Ye̱so shasu̱ru̱, wu̱ zee, “Nip-o̱ me̱ no̱ m-ru̱re̱, u̱rege̱ no̱ m-she̱r ne̱, komo no̱ zap á, ko̱ hiin, no̱a hoks m-no̱m arge̱ rii-yo u̱m no̱me̱ ká rum-yo à. No̱a zee ka haag-o̱ ‘Wuksu̱nde o he̱'e̱be̱ n-me̱ m-sa.’ O̱a nomo no̱ o-do̱ro̱tte̱. ");
INSERT INTO uth_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","U̱rege̱ no̱ she̱re̱g o-nip ko̱ ya no̱ ko̱ne̱ Shir, no̱a kum yo.” ");
INSERT INTO uth_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Bo̱ Ye̱so cu̱wte̱ u̱n Pyo-o̱ Shir à, wu̱ ro̱ u̱r-yoos, Gwo̱mo-ne̱ ye̱ u̱n ko̱n-se Shir u̱n se̱k-ye̱ ne̱ be-de u̱n hun-ne̱ ye̱ haanu̱ru̱ be-de u̱n wu̱. Ye̱ ze̱e̱ru̱, “¿U̱n to̱ ke gwo̱mo-to̱ o̱ wo̱tte̱ u̱n no̱m u̱n ká rem-se? ¿Komo wa ya'u̱ wo̱ kà gwo̱mo-to̱?” ");
INSERT INTO uth_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Ye̱so shasu̱ru̱, wu̱ zee, “Me̱ u̱n cere, man cit no̱ o̱ ken cot-o̱. U̱rege̱ no̱ shaks me̱, man ru̱ru̱ no̱ gwo̱mo-to̱ me̱tte̱ u̱n no̱m u̱n ká rem-se à. ");
INSERT INTO uth_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","¿Kene̱ Yohana kume̱ gwo̱mo-to̱ u̱n yo'os-de u̱n hun-ne̱ m-ho̱ de wu̱ no̱me̱ à? ¿Shir o̱ ya'e̱ wu̱ ko̱ ne̱t?” Ma-u̱t su̱nu̱ru̱ ye̱, ye̱ ro̱ m-ze̱e̱, “A zee no̱ be-de Shir o̱, wu̱a zee na, ‘To̱, ¿remen yan o̱ a she̱rte̱ u̱n wu̱ á?’ ");
INSERT INTO uth_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Amba a zee no̱, ‘Be-de u̱n ne̱t o̱,’ A o-gye̱r u̱n ka bu̱u̱g-de u̱n hun-ne̱ de, remen ko̱wan dekse̱ Yohana ko-yan-Rwo̱r u̱n Ma-to̱ Shir wu̱.” ");
INSERT INTO uth_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Ye̱ shasu̱ru̱ Ye̱so, ye̱ ze̱e̱ru̱, “Te̱ nap á.” Ye̱so ze̱e̱ru̱ ye̱, “Me̱ u̱n cere man ru̱ru̱ no̱ ko̱ u̱n to̱ ke gwo̱mo-to̱ me̱tte̱ m-no̱m u̱n ká rem-se á. ");
INSERT INTO uth_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“To̱, ru̱ru̱ me̱ no̱ yo no̱ hyane̱ u̱n to̱ ka ma-to̱ ne̱ à. Wu̱ ken ne̱t-wu̱ ro u̱n yakar-ne̱ yoor yan-campo̱-ne̱. Wu̱ haaru̱ be-de u̱n wu̱ ro̱ se̱k-wu̱ à, wu̱ ze̱e̱ru̱, ‘Wà re, caane̱ neke̱, o nom m-se̱nge̱ o-kat o̱ u̱s-anab.’ ");
INSERT INTO uth_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","“Ká wà-wu̱ shasu̱ru̱, ‘Ay, man he á.’ Amba da-o ho̱r-o̱, wu̱ ja'asu̱ru̱ u̱s-barag, wu̱ haaru̱. ");
INSERT INTO uth_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","“Tato-o haaru̱ be-de u̱n ayoore̱-ye̱ wu̱, wu̱ ru̱ru̱ wu̱ rii-yo wu̱ ru̱re̱ wu̱ u̱r-takan à. Wà shasu̱ru̱, wu̱ zee, ‘To̱, man hees, Tato re o̱.’ Amba wu̱ ha á. ");
INSERT INTO uth_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","“Kap yoor-mo̱ u̱n ye̱, ¿wan wu̱ ne̱ nome̱ tato u̱n wu̱ o-do̱ro̱tte̱?” Ye̱ ze̱e̱ru̱, “Wà u̱r-takan.” Ye̱so ze̱e̱ru̱ ye̱, “Nip-o̱ me̱ no̱ m-ru̱re̱, yan-go̱ks u̱n tar u̱n ya-o-ás ne̱, ye̱a be'es no̱ co̱w u̱n gwo̱mo-to̱ Shir. ");
INSERT INTO uth_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Me̱ u̱n ze̱e̱ kaane̱ remen Yohana Wa-m-Yo'os u̱n hun-ne̱ m-ho̱ haante̱ wu̱ kutute̱ no̱ co̱w-yo u̱n ho̱o̱g, amba no̱ bo̱p ma-to̱ u̱n wu̱ á. Amba yan-go̱ks u̱n tar u̱n ya-o-ás, ye̱ bo̱k ma-to̱ u̱n wu̱ o-nip. Komo da-o̱ no̱ hyane̱ ka rii-yo ro̱ m-ko̱r à no̱ waktu̱ne̱ no̱ ho'os ba'as-u̱t no̱, no̱ bu̱p wu̱ o-nip á. ");
INSERT INTO uth_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“Ho̱gu̱ no̱, mo̱ ken sha-mo̱ u̱t-ma mo̱ komo. Wu̱ ken ne̱t-wu̱ ro kon wu̱ go̱'e̱ kat-o̱ u̱s-anab à. Wu̱ rigimshiru̱ o̱ u̱r-san, wu̱ bo̱o̱ru̱ kuub-o̱ m-po̱t u̱n ho̱-mo̱ u̱n yakar-ye̱ u̱n anab n-me̱. Komo wu̱ maaru̱ kuke̱-o m-pipir remen ya-u̱r-'er. Wu̱ ya'asu̱ru̱ ye̱ ken yan-to̱m-ye̱ mo̱o̱g-o̱ u̱n ká kàt-o̱, ka da-de, wu̱ haaru̱ o̱ ken dak-o̱. ");
INSERT INTO uth_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Bo̱ da-o̱ m-ce wo̱o̱nte̱ à, wu̱ to̱mnu̱ru̱ gu̱w-ne̱ ye̱ u̱n wu̱. Ye̱ he be-de u̱n ye̱ wu̱ mu̱u̱ge̱ o-kat à, remen ye̱ go̱ksu̱ntú̱ wu̱ o̱ ma u̱n wu̱ nu-o̱, o̱ u̱n kwu̱m-o̱ o-kat. ");
INSERT INTO uth_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","“Amba ye̱ mo̱ge̱ o-kat à shipi gu̱w-ne̱, ye̱ kaktu̱ wan-gaan u̱r-bu̱'u̱g, ye̱ ho̱o̱ru̱ wan-gaan, ye̱ kaktu̱ wan-gaan u̱s-jor. ");
INSERT INTO uth_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Wu̱ dooru̱ m-to̱m u̱n gu̱w-ne̱ ho̱r-ye̱ arge̱ ye̱ u̱r-takan. Yan-mo̱o̱g-o̱ o-kat nomu̱ru̱ ye̱ bo̱ ye̱ nome̱ ye̱ u̱r-takan à. ");
INSERT INTO uth_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Har u̱r-ko̱m, ko-ya-o-kat to̱mu̱ru̱ wà u̱n wu̱ ha-mo̱ u̱n be-de u̱n ye̱. Wu̱ zee, ‘Ye̱a 'ye wà re m-se̱k.’ ");
INSERT INTO uth_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","“Amba bo̱ yan-mo̱o̱g o-kat hyanbu̱te̱ wà-wu̱ u̱n ko-ya-o-kat à, ye̱ ze̱e̱ru̱ hi u̱n de u̱n ye̱, ‘Ehee! Ai, ko-yan-go̱ks u̱n cim-yo o-kat wu̱ ka. A ho no̱ wu̱, kat-o warag o̱ ma na!’ ");
INSERT INTO uth_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Ye̱ argu̱ wu̱ m-ship, ye̱ jorbu̱ wu̱ u̱n jit-de san-de o-kat. Ye̱ ho̱o̱ru̱ wu̱.” ");
INSERT INTO uth_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Ye̱so citu̱ru̱ ye̱, “To̱, ka ko-ya-o-kat-wu̱ mu̱u̱ne̱, ¿ya wu̱ he m-no̱m u̱n ká yan-mo̱o̱g-ye̱ ne̱?” ");
INSERT INTO uth_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Ye̱ ze̱e̱ru̱ wu̱, “Ai, cip wu̱a hoom ye̱, wu̱ ya'as ho̱r-ye̱ mo̱o̱g-o̱ u̱n ká kat-o̱, ye̱ he wu̱ se̱nge̱ m-ya'as u̱n o̱ ma u̱n wu̱ nu-o̱, o̱ u̱n kwu̱m-o̱ o-kat ko̱ o̱ ke hak-o̱.” ");
INSERT INTO uth_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Ye̱so citu̱ru̱ ye̱, “Ashi, ¿no̱ we̱t m-karante̱ u̱n ge̱n-mo̱ u̱n Ma-to̱ Shir á? “ ‘Ta'ar-de ya-u̱t-ma ginme̱ à, de waragte̱ ta'ar-de jiishe̱ u̱r-bon myet be-de u̱t-ma à. Mo̱ ka no̱m-m Yawe mo̱, rii-yo u̱t-hyat yo ne̱ u̱n yish na.’ ");
INSERT INTO uth_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Rii-yo me̱ no̱ m-ru̱re̱ à yo ro̱ a rumus gwo̱mo-to̱ Shir u̱n kom-u̱t no̱, a ya'as ye̱ a hette̱ kum u̱n rii-yo u̱r-bon à. ");
INSERT INTO uth_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Bo̱n ne̱t-wu̱ pu̱kse̱ u̱n ká ta'ar-de à, dea jetem wu̱. Komo ká ta'ar-de a rugum re̱e̱w wu̱ de he̱'e̱be̱ be-de u̱n wu̱ à.” ");
INSERT INTO uth_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Bo̱ Gwo̱mo-ne̱ ye̱ u̱n ko̱n-se Shir u̱n Parisa-ne̱ ho̱gu̱te̱ ká sha-mo̱ u̱t-ma mo̱ Ye̱so rwo̱re̱ à, ye̱ napu̱ru̱ u̱nze ye̱ wu̱ ro̱tte̱ u̱t-ma. Ye̱ ro̱ ká yan-mo̱o̱g-o̱ o-kat ye̱. ");
INSERT INTO uth_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Ye̱ co̱nu̱ru̱ wu̱ m-ship, amba ye̱ ro̱ u̱n gye̱r-o̱ u̱n hun-ne̱ remen hun-ne̱ dekstu̱ Ye̱so ko-yan-Rwo̱r u̱n Ma-to̱ Shir wu̱. ");
INSERT INTO uth_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Ye̱so dooru̱ ye̱ m-nome̱ u̱t-ma u̱n sha-mo̱ u̱t-ma. Wu̱ ze̱e̱ru̱, ");
INSERT INTO uth_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“A hoks m-hongse̱ u̱n gwo̱mo-to̱ Shir u̱n wu̱ ken Ko-Gwo̱mo-wu̱ ne̱, wu̱ nome̱ wà u̱n wu̱ biki-o̱ u̱t-ge à. ");
INSERT INTO uth_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Hun-ne̱ de̱e̱n a bande̱ o-biki. Da-o̱ a ko̱me̱ zo̱nge̱-to̱ o-biki à, wu̱ to̱mu̱ru̱ gu̱w-ne̱ ye̱ u̱n wu̱ ye̱ ru̱re̱ ko̱ wu̱ ke da-o nomoste̱. Amba hun-ne̱ ye̱ a bande̱ à ye̱ haan á. ");
INSERT INTO uth_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","“Wu̱ dooru̱ m-to̱m u̱n gu̱w-ne̱ ho̱r-ye̱. Wu̱ zee, ‘Ru̱ru̱ no̱ hun-ne̱ ye̱ a bane̱ à u̱nze, “Me̱ ka u̱m zo̱ngsu̱te̱ rii-yo m-re̱, a peneste̱ na-ye̱ m-se̱m ye̱ a ya'e̱ u̱t-zan à. Myet a komoste̱ zo̱nge̱ u̱n ko̱yan. Haan no̱ biki-o̱ u̱r-ge ma na!” ’ ");
INSERT INTO uth_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","“Amba ye̱ wu̱ bane̱ o-biki à ye̱ was á. Ye̱ argu̱ru̱ to̱ ma u̱n ye̱. Wu̱ ken wu̱ neku̱ so̱ u̱n kat-o̱ u̱n wu̱. Wu̱ ken wu̱ neku̱ baab-to̱ u̱n wu̱. ");
INSERT INTO uth_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Ye̱ ken ye̱ komo ye̱ shipi ká gu̱w-ne̱ ye̱, ye̱ yo'ogu̱ ye̱, ye̱ kaktu̱ ye̱ u̱r-bu̱'u̱g, har ye̱ ho̱o̱ru̱ ye̱. ");
INSERT INTO uth_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","“Ko-Gwo̱mo swo̱o̱ru̱ u̱s-ryaab de̱e̱n. Wu̱ to̱mu̱ru̱ karma-ne̱ ye̱ u̱n wu̱. Ye̱ hoomu̱ wu̱ ká ye̱ ho gu̱w-ne̱ ye̱ u̱n wu̱ à, har ye̱ tu̱ks bo̱-o̱ u̱n ye̱ kap. ");
INSERT INTO uth_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","“Ka da-de, wu̱ ze̱e̱ru̱ gu̱w-ne̱ ye̱ u̱n wu̱ ho̱r-ye̱, ‘A komoste̱ zo̱nge̱-to̱ o-biki, amba hamat-ne̱ ye̱ u̱m bane̱ à ye̱ depe̱ á. ");
INSERT INTO uth_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Remen kaane̱, do̱ru̱ no̱ co̱w u̱s-co̱w, no̱ band kap ye̱ no̱ hyane̱ à ye̱ haan o-biki.’ ");
INSERT INTO uth_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Ká gu̱w-ne̱ ye̱ do̱ru̱ru̱ co̱w u̱s-co̱w. Ye̱ kamsu̱ndu̱ru̱ kap o̱ u̱n ye̱, ye̱ kume̱ à, kashi u̱n hun-ne̱ u̱n rii-ye̱ o-saa ne̱, har be-de o-biki shiiru̱ u̱n hamat-ne̱. ");
INSERT INTO uth_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Amba bo̱ Ko-Gwo̱mo co̱wo̱nte̱, remen wu̱ hyenet hamat-ne̱ à, wu̱ hyanu̱ru̱ wu̱ ken ne̱t-wu̱, wu̱ co̱p matuku-de gu̱w-ne̱ ye̱ u̱n wu̱ yase̱ hamat-ne̱ ye̱ cu̱p be-de u̱n ka biki-o̱ u̱t-ge o̱ á. ");
INSERT INTO uth_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Wu̱ ze̱e̱ru̱ ká ne̱t-wu̱, ‘Wan-yen de, ¿re no̱me̱ o co̱wo̱nte̱ kane̱ ba wo̱ u̱n co̱po̱n matuku-de o-biki?’ Amba ká ne̱t-wu̱ taage̱ u̱n ma-to̱ m-ce̱p. ");
INSERT INTO uth_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Ko-Gwo̱mo ze̱e̱ru̱ yan-gu̱w-mo̱ u̱n wu̱, ‘Gaag no̱ kom-to̱ u̱n wu̱ u̱n na-se u̱n wu̱ ne̱. No̱ jorbe̱ wu̱ n-do̱ n-me̱ o-comb, remen káne̱ hun-ne̱ he u̱s-kan u̱n haw-se u̱n yin-ne̱.’ ");
INSERT INTO uth_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","“Ai, a bante̱ hun-ne̱ de̱e̱n, amba ye̱ a daage̱ à hiin ye̱ ro̱.” ");
INSERT INTO uth_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","A kane̱ Parisa-ne̱ haaru̱, ye̱ to̱o̱ru̱ u̱t-hun bo̱ ye̱ he Ye̱so m-ce̱e̱b u̱n ma-to̱ wu̱ he m-rwo̱r à. ");
INSERT INTO uth_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Ye̱ to̱mu̱ru̱ yan-neke̱-mo̱ u̱n ye̱, mo̱sse̱ u̱n ye̱ ken hun-ne̱ Ko-Gwo̱mo Here̱ ye̱ ne̱. Ye̱ cit wu̱ kà cot-o̱, “Wa-u̱r-Yoos, te̱ nepste̱ wo̱ ko-ya-o-nip-wu̱. Wo̱ komo m-yoos u̱n Ma-to̱ Shir o-nip ne̱ ko̱ ya he m-ko̱r. Wo̱ m-ginim u̱n ko̱ wu̱ ke á, remen hun-ne̱ kap gaan-ye̱ be u̱n du. ");
INSERT INTO uth_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","To̱, ru̱ru̱ te̱ rii-yo depe̱ à kane̱: ¿Hond hond o̱ te̱ to̱p Sisar caari-wu̱ u̱n ko-Gwo̱mo-wu̱ u̱n Roma-ne̱ hwo̱r-ye̱ u̱n tar? ¿Ko̱ te̱ to̱p á?” ");
INSERT INTO uth_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Amba remen Ye̱so nepste̱ rew-u̱r yo̱-de de u̱n ye̱, wu̱ ze̱e̱ru̱, “No̱ ya-o-she̱pe̱! ¿Wan wu̱ no̱ m-ce̱e̱b u̱n cot-u̱s no̱? ");
INSERT INTO uth_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Kutu no̱ me̱ hwo̱r-ye̱ atte̱ à.” Ye̱ hantu̱ru̱ wu̱ hwo̱r-yo o-kwo̱m. ");
INSERT INTO uth_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Wu̱ ze̱e̱ru̱ ye̱, “¿Kà hwo̱to̱-o̱ u̱n kà jin-de ne̱ to̱ ma wan to̱?” ");
INSERT INTO uth_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Ye̱ shasu̱ru̱ ye̱ zee, “To̱ ma ko-Gwo̱mo Sisar to̱.” Ye̱so ze̱e̱ru̱ ye̱, “To̱, se̱ no̱ ya'as ko-Gwo̱mo Sisar rii-yo ro̱ yo ma Sisar à, komo no̱ ya'as Shir rii-yo ro̱ yo Shir à.” ");
INSERT INTO uth_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Bo̱ ye̱ ho̱gu̱te̱ shas-o̱ u̱n wu̱ à, ye̱ bo̱pu̱ru̱ o-nu. Ye̱ yagu̱ru̱ wu̱, ye̱ argu̱ru̱. ");
INSERT INTO uth_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","U̱n ká ho̱-de, ye̱ ken Saduki-ne̱ ye̱ haanu̱ru̱ be-u̱r Ye̱so. (Saduki-ne̱ ye̱ ro̱ m-ze̱e̱ a m-ine̱ a mere̱ á). Ye̱ citu̱ru̱ wu̱ kà cot-o̱. ");
INSERT INTO uth_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Ye̱ ze̱e̱ru̱, “Wa-u̱r-Yoos, Mosa ze̱e̱g, ‘U̱rege̱ ne̱t marag ba wu̱ u̱n mat yakar, heno u̱n wu̱ ge ká ko-gwo̱r-wu̱, remen wu̱ metu̱té̱ ká wu̱ mare̱ à wà, wu̱ he de̱k u̱n cim-yo u̱n wu̱ à.’ ");
INSERT INTO uth_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","To̱, be u̱n te̱ wu̱ ken ne̱t-wu̱ makt yan-campo̱-ne̱ ne̱n ta'yoor. Wu̱ ro̱ se̱k-wu̱ a gaaru̱ u̱t-ge, wu̱ maru̱ru̱ ba wu̱ u̱n mat. Ayoore̱-wu̱ gaaru̱ ká ko-gwo̱r-wu̱. ");
INSERT INTO uth_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Káane̱ dooru̱ m-ko̱r be-de u̱n ayoore̱-wu̱ ba wu̱ u̱n mat yakar. Atette̱-wu̱ gaaru̱ ká ne'a-wu̱, har wo̱o̱ru̱ u̱n ata'yoore̱-wu̱. ");
INSERT INTO uth_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","U̱r-ko̱m, ká ne'a-wu̱ maru̱ru̱. ");
INSERT INTO uth_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","To̱, ru̱ru̱ te̱ u̱n ine̱-mo̱ u̱n margan-ne̱, ¿ne'a wan wu̱ ne̱ wu̱ he m-warag be-de u̱n ye̱? Remen myet-mo̱ u̱n ye̱, ta'yoor-ye̱ geestu̱ wu̱!” ");
INSERT INTO uth_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Ye̱so shasu̱ru̱ ye̱, wu̱ zee, “Yo suu no̱ à yo ro no̱ nap Ma-to̱ Shir á. Komo no̱ nap be̱e̱b-de Shir á. ");
INSERT INTO uth_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Da-o̱ margan-ne̱ he m-ine̱ à, ye̱a ge u̱t-ge á. Se̱ de̱ ye̱a wakte̱ u̱ntu̱n yan-to̱m-ye̱ Shir n-To̱n. ");
INSERT INTO uth_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","“Komo mo̱sse̱ u̱n ine̱-mo̱ u̱n margan-ne̱, ¿no̱ karante̱ rii-yo Shir ru̱ru̱ no̱ á? Cin da-o̱ Ibrahi, Ishaku, u̱n Yakubu ne̱ mare̱ à Shir ze̱e̱g, ");
INSERT INTO uth_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Me̱ ro̱ Shir Ibrahi, Shir Ishaku, komo Shir Yakubu.’ Remen kaane̱, wu̱ wu̱ ro̱ Shir o̱ u̱n ya-m-ho̱o̱g, ba o̱ u̱n margan-ne̱ á.” ");
INSERT INTO uth_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Bo̱ hun-ne̱ ho̱gu̱te̱ káane̱ à, ye̱ hyanu̱ru̱ hyat-to̱ u̱n yoos-de u̱n wu̱. ");
INSERT INTO uth_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Bo̱ Parisa-ne̱ ho̱gu̱te̱ Saduki-ne̱ kum to̱ m-ce̱p be-de u̱n shas-o̱ u̱n wu̱ á, ye̱ mo̱rgu̱ru̱. Ye̱ cit wu̱ o̱ ma u̱n ye̱ cot-o̱. ");
INSERT INTO uth_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Wu̱ ken wan-napse̱ o-karamsa wu̱ be-de u̱n ye̱ citu̱ru̱ Ye̱so o-cot remen wu̱ cept Ye̱so. Wu̱ ze̱e̱ru̱, ");
INSERT INTO uth_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Wa-u̱r-Yoos, ¿o̱ ke karamsa-o̱ jiishe̱ m-'wo̱ns be-de u̱n karamsa-u̱t Mosa?” ");
INSERT INTO uth_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Ye̱so shasu̱ru̱, wu̱ zee, “Co̱n Yawe Shir ru u̱n kap o̱ u̱n hur u̱n du, u̱n kap o̱ u̱n ho̱o̱g ru ne̱, u̱n kap o̱ u̱n nap-u̱s ru ne̱. ");
INSERT INTO uth_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","O̱ ka o̱ ro̱ karamsa-o̱ u̱r-takan, komo o̱ ro̱ o-go̱s o̱ be-de u̱n to̱ ká. ");
INSERT INTO uth_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ayoore̱-o̱ u̱ntu̱n o̱ u̱r-takan o̱ ro̱, ‘Co̱n yan-bo̱r-u̱s ru bo̱ o co̱ne̱ hi u̱n du à.’ ");
INSERT INTO uth_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Myet yoos-u̱r Mosa u̱n to̱ u̱n yan-Rwo̱r u̱n Ma-to̱ Shir ne̱, n-me̱ u̱n to̱ ká karamsa-u̱t yoor-to̱ rwu̱u̱ne̱.” ");
INSERT INTO uth_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Bo̱ Parisa-ne̱ kargu̱te̱ be-u̱r Ye̱so à, Ye̱so citu̱ru̱ ye̱ o-cot. ");
INSERT INTO uth_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","Wu̱ ze̱e̱ru̱, “¿Yan yo ne̱ ro̱ barag-u̱s no̱ mo̱sse̱ u̱n Kiristi ne̱? ¿Wà wan wu̱ ne̱?” Ye̱ ze̱e̱ru̱ wu̱, “Wà Dawuda.” ");
INSERT INTO uth_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Ye̱so ze̱e̱ru̱ ye̱, “To̱, ¿re no̱me̱ Dawuda u̱n be̱e̱b-de o-Ku̱kt, wu̱ ro̱tte̱ wu̱ m-ze̱e̱ ‘Go̱s-wu̱’? Remen Dawuda ze̱e̱g, ");
INSERT INTO uth_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","“ ‘Yawe ze̱e̱g Go̱s-wu̱ wu̱ ma re, “She'et u̱n ka be-de u̱t-gwo̱mo de, har u̱m ru̱'u̱t yan-yage̱-u̱t ru waragte̱ rii-yo o he m-yawag u̱n na-u̱s ru à.” ’ ");
INSERT INTO uth_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","¿U̱rege̱ Dawuda ro̱ m-ze̱e̱ u̱n Kiristi, ‘Go̱s-wu̱ re,’ to̱, re no̱me̱ Kiristi waragte̱ wà u̱n wu̱?” ");
INSERT INTO uth_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Yatt-wu̱ hoksu̱ wu̱ m-shas á. Bo̱ u̱n ká ho̱-de yatt-wu̱ kume̱ jaab remen wu̱ cit wu̱ o̱ ken cot-o̱ á. ");
INSERT INTO uth_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Bo̱ hun-ne̱ mo̱rgu̱te̱ de̱e̱n mo̱sse̱ u̱n yan-neke̱-mo̱ u̱n wu̱ ne̱ à, Ye̱so ze̱e̱ru̱ ye̱, ");
INSERT INTO uth_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Yan-Yoos-de o-karamsa u̱n Parisa-ne̱, ye̱ a ya'ase̱ be̱e̱b-de u̱n yoos-de u̱n karamsa-o Mosa. ");
INSERT INTO uth_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Remen kaane̱ no̱m no̱ kap o̱ u̱n rii-yo ye̱ ro̱ m-yoos à, amba no̱ no̱m bo̱ ye̱ ro̱ m-no̱m á. Remen ye̱ ro̱ m-no̱m u̱n rii-yo ye̱ ro̱ yoos á. ");
INSERT INTO uth_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Ye̱ ro̱ m-ze̱e̱ u̱n hun-ne̱ ye̱ no̱m rem-se arge̱ be̱e̱b-de u̱n ye̱ à, remen Shir wu̱ ho̱gu̱té̱ re̱re̱m-mo̱ ye̱. Amba ye̱ ne̱, ye̱ m-no̱m ko̱ hiin rem-se ro̱ u̱n hante̱ hun-ne̱ ye̱ waragté̱ kashi be-de Shir á. ");
INSERT INTO uth_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","“Ye̱ m-no̱m u̱n se̱nge̱-mo̱ u̱n ye̱ remen hun-ne̱ hyenet. Ye̱ m-gaag caari caari-to̱ u̱n ci-se u̱n Ma-to̱ Shir sa o zee u̱t-du̱po u̱n zwo̱n-to̱ u̱n ye̱, riib-se u̱n matuku-to̱ u̱n ye̱ ro̱ u̱s-geeza ne̱ har se ro̱ u̱n huk o-dak. Ye̱ ro̱ m-kute̱ u̱n hun-ne̱ a zeet ye̱ ro̱ yow yow u̱n Shir ne̱. ");
INSERT INTO uth_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Ye̱ jiishte̱ m-co̱n a ya'as ye̱ be-de u̱r-she'et de u̱n go̱s-ye̱ be-de o-biki, komo u̱n be-to̱ u̱r-she'et ne̱ u̱t-so̱to̱ u̱n kuke̱-to̱ u̱n yoos u̱n Ma-to̱ Shir. ");
INSERT INTO uth_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Komo ye̱ co̱no̱g hun-ne̱ se̱ngu̱ ye̱ m-gas be-de u̱t-baab komo hun-ne̱ se̱ngu̱ ye̱ m-ze̱e̱, ‘Ya-u̱s-Nap.’ ");
INSERT INTO uth_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Amba no̱, taase a zee no̱ ‘Wa-u̱s-Nap,’ remen wan-yoos-u̱r no̱ wan-gaan wu̱. No̱ was ma-to̱ u̱t-comos á, remen myet no̱ hen-ne̱ ye̱ u̱n wu̱ ne̱ ye̱, campo̱-ne̱ u̱n ne'a-ne̱ ne̱. ");
INSERT INTO uth_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Taase no̱ zee ne̱t ‘o-Tato’ u̱n ho̱no o-dak remen Tato o-gaan o̱ ro̱ be u̱n no̱ wu̱ ro̱ n-me̱ n-To̱n shir. ");
INSERT INTO uth_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Taase komo a eeg wo̱ ‘Wa-u̱r-Yoos,’ remen wan-gaan wu̱ ro̱ Wa-u̱r-Yoos, wu̱ ro̱, Kiristi. ");
INSERT INTO uth_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Wu̱ ro̱ caari be u̱n no̱ à, se̱ wu̱ nomotu̱ no̱ m-gu̱w. ");
INSERT INTO uth_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Kap wu̱ hwo̱ hi u̱n de u̱n wu̱ be-u̱r kashi à, Shir a mus wu̱ hwaa. Amba kap wu̱ musse̱ hi u̱n de u̱n wu̱ hwaa à, Shir a 'ye wu̱ m-se̱k.” ");
INSERT INTO uth_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Amba no̱ rii-yo u̱r-'wo̱n yo, no̱ yan-Yoos-de o-karamsa u̱n Parisa-ne̱. Ya-o-she̱pe̱! No̱ sanag hun-ne̱ ish-o̱ m-co̱w u̱n gwo̱mo-to̱ Shir. No̱ u̱n hi u̱n no̱ komo no̱ co̱w á. ");
INSERT INTO uth_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Rii-yo u̱r-'wo̱n yo no̱ yan-Yoos-de o-karamsa u̱n Parisa-ne̱. Ya-o-she̱pe̱! Remen no̱ m-pas m-sa, no̱ m-wo̱ dak-to̱ u̱r-hew remen hoob-o̱ u̱n ne̱t wan-gaan remen no̱ muut wu̱ do̱ru̱te̱ jor no̱ Yahuda-ne̱. U̱rege̱ no̱ kumunte̱, no̱ haaru̱ no̱ muutu̱ wu̱ har wu̱ jiish no̱ m-yo̱. ");
INSERT INTO uth_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Rii-yo u̱r-'wo̱n yo no̱, no̱ ye̱ ro̱ u̱n take̱ u̱n hun-ne̱ co à, no̱kka ne̱ po̱-ne̱! No̱ m-ze̱e̱, ‘Myet bo̱ u̱n wu̱ to̱nde̱ u̱n Pyo-o̱ Shir à, rem ro̱ ko̱n á, amba kap bo̱ u̱n wu̱ to̱nde̱ o-zinariya yo u̱n Pyo-o̱ Shir à, se̱ wu̱ no̱mo̱g ká rii-yo wu̱ to̱nte̱ à.’ ");
INSERT INTO uth_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Ya no̱ ro̱ u̱ntu̱n po̱-ne̱ u̱n raag-ne̱ ne̱ u̱n hyan-o Shir. ¿Yo ke yo jiishe̱ u̱t-go̱s: zinariya yo, ko̱ Pyo-o̱ Shir o̱ ro̱ m-herekse̱ o-zinariya à? ");
INSERT INTO uth_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","No̱ komo m-ze̱e̱, ‘Kap bo̱ u̱n wu̱ to̱nde̱ o-hana à, regen-o ro̱ ko̱n á, amba kap bo̱ u̱n wu̱ to̱nde̱ u̱n yar-mo̱ a sake̱ n-te̱ o-hana à, se̱ wu̱ no̱mo̱g ká rii-yo wu̱ to̱nte̱ à.’ ");
INSERT INTO uth_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","No̱ po̱-ne̱! ¿Yo ke yo jiishe̱ u̱t-go̱s? ¿Sake̱-de, ko̱ hana-o̱ u̱r-sake̱ o̱ ro̱ m-herekse̱ u̱r-sake̱ à? ");
INSERT INTO uth_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Remen kaane̱ kap bo̱ u̱n wu̱ to̱nde̱ u̱n hana-o̱ u̱r-seke̱ à, wu̱ to̱nte̱ u̱n ka rii-yo ro̱ u̱n o̱ à. ");
INSERT INTO uth_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Kap komo bo̱ u̱n wu̱ to̱nde̱ u̱n Pyo-o̱ Shir à, wu̱ to̱nte̱ u̱n o̱, komo u̱n Shir ne̱ wu̱ ro̱ tara n-me̱ u̱n o̱ à. ");
INSERT INTO uth_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Kap komo bo̱ u̱n wu̱ to̱nde̱ n-To̱n shir à, wu̱ to̱nte̱ u̱n kwu̱u̱r-o̱ Shir, komo u̱n Shir ne̱ wu̱ ro̱ tara u̱n ká kwu̱u̱r-o̱ à. ");
INSERT INTO uth_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Rii-yo u̱r-'wo̱n yo no̱, yan-Yoos-de o-karamsa u̱n Parisa-ne̱. Ya-o-she̱pe̱! No̱ m-hu̱s o-gaan be-de u̱n o̱p be-de u̱n saw-to̱ u̱n ceta u̱s-wa ne̱. Amba no̱ yagu̱te̱ rem-se jiishe̱ u̱r-bon n-me̱ o-karamsa à, se ro̱: u̱r-'wo̱n, m-she̱r, u̱n me̱n-u̱t pus-to̱ ne̱. Hu̱s no̱ kap, ka yo depe̱ no̱ nom à, ba no̱ u̱n yage̱ o-ges. ");
INSERT INTO uth_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","No̱ po̱-ne̱ yan-taku̱ u̱n co! No̱ m-hu̱s u̱n rii-yo u̱n ho̱o̱g-o re̱k-yo n-me̱ m-ho̱, amba no̱ co̱re̱ o-dorom!” ");
INSERT INTO uth_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Rii-yo u̱r-'wo̱n yo no̱, yan-Yoos-de o-karamsa u̱n Parisa-ne̱. Ya-o-she̱pe̱! No̱ m-so'os jim-de u̱r-ibitte̱ u̱n de u̱r-ko̱k ne̱, amba me̱-u̱r ro̱ u̱n hu ne̱, o-su̱u̱b ne̱ de̱e̱n u̱n ko̱o̱b-de u̱n garamse̱ u̱n hi u̱n no̱ ne̱. ");
INSERT INTO uth_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","No̱ Parisa-ne̱ po̱-ne̱! Takan no̱ so'os n-me̱ de u̱r-ibitte̱ u̱r-ko̱k ne̱, remen jim-de u̱n to̱ nomot m-cecas. ");
INSERT INTO uth_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Rii-yo u̱r-'wo̱n yo no̱, yan-Yoos-de o-karamsa u̱n Parisa-ne̱. Ya-o-she̱pe̱! Ya no̱ ro̱ u̱ntu̱n saag-se hun-ne̱ suke̱ o-jo̱jo̱ à, se u̱n bon-de m-hyan n-do̱, amba n-me̱ se̱ caar-to̱ u̱n margan-ne̱, m-ku̱ko̱p ne̱ go̱-u̱s-go̱. ");
INSERT INTO uth_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","No̱ m-se̱nge̱ a zeet no̱ ro̱ kashi u̱n hun-ne̱ u̱n hyan-o̱ u̱n yish, amba me̱n-u̱t no̱, ya to̱ ro̱ shiishe̱ o-she̱pe̱ u̱n se̱nge̱-m yo̱-mo̱ ne̱.” ");
INSERT INTO uth_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Rii-yo u̱r-'wo̱n yo no̱ yan-Yoos-de o-karamsa u̱n Parisa-ne̱. Ya-o-she̱pe̱! Me̱n ze̱e̱ kaane̱ remen no̱ nak m-hin u̱n saag-se u̱r-bon se u̱n yan-Rwo̱r u̱n Ma-to̱ Shir, komo no̱ nome̱ saag-se u̱n kashi u̱n hun-ne̱ u̱t-duk ka ye̱ ya-n-ga-ye̱ no̱ ho à. ");
INSERT INTO uth_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","No̱ m-ze̱e̱, ‘Te̱ ro ko̱nte̱ u̱n da-o mo̱ng-ne̱ te̱, te̱ roa gu ye̱ hoom u̱n yan-Rwo̱r u̱n Ma-to̱ Shir á.’ ");
INSERT INTO uth_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","U̱n rwo̱r-mo̱ u̱n káane̱, no̱ ze̱e̱g o̱ ka no̱ ro̱ yakar u̱n ye̱ hoome̱ yan-Rwo̱r u̱n Ma-to̱ Shir à. ");
INSERT INTO uth_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","To̱, ha no̱ co no̱ shoos me̱n-u̱t jaas-to̱ to̱ tat no̱ ne̱ shi'ne̱ à! ");
INSERT INTO uth_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","No̱ ye̱ge̱-hwo̱! No̱ yakar-ye̱ u̱n herhyat! ¿Re no̱ he m-no̱m no̱ po̱ssu̱te̱ piish u̱t-ma to̱ u̱n den-o̱ o-ra? ");
INSERT INTO uth_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","“Remen kaane̱, me̱ no̱ m-to̱mne̱ u̱n yan-Rwo̱r u̱n Ma-to̱ Shir, u̱n ya-u̱s-we̱e̱r ne̱, u̱n yan-Yoos-de u̱n Ma-to̱ Shir ne̱. No̱a ho ye̱ ken ye̱, no̱ kem ye̱ ken ye̱, komo no̱ nome̱ ye̱ ken ye̱ u̱s-so̱ro̱g u̱n kuke̱-u̱t no̱ to̱ u̱n yoos u̱n Ma-to̱ Shir. No̱ ye̱ m-do̱re̱ bo̱-u̱t-bo̱ komo no̱ ye̱ u̱n ya-u̱r-ko̱o̱b. ");
INSERT INTO uth_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Remen kaane̱, no̱a su̱ u̱r-ko̱o̱b remen no̱ ho̱o̱g kap kashi u̱n hun-ne̱. Cin u̱n hyó-m E̱ber ne̱t so̱-wu̱. Har ha-mo̱ u̱n mo̱ ma Zakaraya wà Barakiya, wu̱ no̱ ho'e̱ u̱n te̱te̱-o̱ u̱n Pyo-o̱ Shir u̱n hana-o̱ u̱r-seke̱ à. ");
INSERT INTO uth_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Nip-o̱ me̱ no̱ m-ru̱re̱, myet piish u̱t-ma to̱ a mo̱ro̱gse̱ à, u̱s-hak de̱e̱n se arge̱ à, a sek to̱ u̱n hi-de u̱n yan ka da-o. ");
INSERT INTO uth_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Ayya ya-o-Urusharima, ya-o-Urusharima! Bo̱-o̱ hoome̱ yan-Rwo̱r u̱n Ma-to̱ Shir, no̱ jir ye̱ Shir to̱mnu̱ no̱ à u̱t-ta'ar! U̱m ro co̱no̱g de̱e̱n u̱m kamas no̱ bo̱ kiit-o ro̱ m-kamas u̱n yakar-ye̱ u̱n yo n-me̱ u̱n ku̱ku̱n-to̱ u̱n yo à, amba no̱ yagu̱te̱. ");
INSERT INTO uth_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","No̱ ka m-mo̱ka a yaksu̱tu̱ no̱ hur-o no̱ ba u̱n ne̱t! ");
INSERT INTO uth_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Remen me̱ no̱ m-ru̱re̱, no̱a do me̱ m-hyan komo á, se̱ ho̱-de no̱ he m-ze̱e̱, ‘Ko-ya-o-kwu̱m-wu̱, wu̱ ro̱o̱ne̱ u̱n be̱e̱b-u̱r Yawe à!’ ” ");
INSERT INTO uth_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Bo̱ Ye̱so ruute̱ u̱n Pyo-o̱ Shir à, wu̱ ro̱ u̱r-hew. Yan-neke̱-mo̱ u̱n wu̱ kutu̱ru̱ wu̱ mu̱mag-o̱ u̱s-pyo. ");
INSERT INTO uth_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Wu̱ ru̱ru̱ ye̱, wu̱ zee, “Gwo̱t no̱ kà mu̱mag-to̱. Nip-o̱ me̱ no̱ m-ru̱re̱, ta'ar-u̱r ro̱ ko̱n ko̱ u̱r-gaan de a he m-yage̱ n-to̱n u̱n o̱r u̱n de á. Myet a wurumsu̱ to̱.” ");
INSERT INTO uth_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Ye̱so ro̱ tara n-te̱ u̱n Haag-o̱ u̱n 'yo-se o-Ze̱tun, yan-neke̱-mo̱ u̱n wu̱ haanu̱ru̱ be-de u̱n wu̱, u̱n ho̱n-de u̱n ye̱. Ye̱ citu̱ru̱, “¿Ru̱ru̱ te̱, ho̱-de kà rii-yo he m-ko̱r à, Komo o̱ ken napa-o̱ ro̱ ko̱n o̱ he te̱ m-kute̱ mu̱u̱n-m ru komo u̱n ta-de u̱n ho̱no o-dak ne̱?” ");
INSERT INTO uth_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Ye̱so shasu̱ru̱ ye̱, “War no̱ ha, taase wu̱ ken wu̱ raks no̱. ");
INSERT INTO uth_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Me̱n ze̱e̱ kaane̱ remen hun-ne̱ de̱e̱n ye̱a haan u̱n jin u̱n de. Ye̱a zee, ‘Me̱ wu̱ ro̱ Kiristi.’ Har ye̱a raks hun-ne̱ u̱t-mo̱o̱r ne̱. ");
INSERT INTO uth_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","No̱a ho̱ge̱ ma-to̱ u̱r-gu̱n, u̱n ho̱ge̱ ho̱ge̱ to̱ u̱n to̱ ne̱. No̱ ho̱ge̱ o-gye̱r á, remen se̱ kaane̱ no̱mo̱g, amba ko̱m-u̱r ro̱ wo̱o̱n to̱ ko̱n á. ");
INSERT INTO uth_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","U̱t-dak u̱r-gu̱n u̱t-dak ne̱, u̱t-gwo̱mo u̱t-gwo̱mo ne̱ to̱a nom te̱pe̱r-se u̱r-gu̱n u̱n hi u̱n de u̱n to̱. A nom komo me̱r u̱n nukte̱-mo̱ o-dak ne̱ u̱t-be n-ho̱n n-ho̱n. ");
INSERT INTO uth_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Amba to̱ ka kap takan-de u̱n re̱ u̱r-ko̱o̱b de temb de he m-ko̱r à. ");
INSERT INTO uth_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Ka da-de ye̱a ship no̱, a 'ye no̱ u̱r-ko̱o̱b, ye̱ ho no̱. Komo, ho̱no o-dak kap a yagu̱ no̱ remen no̱ me̱ m-do̱re̱. ");
INSERT INTO uth_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Ka da-o̱ hun-ne̱ de̱e̱n a tuku me̱ jim, komo ye̱ raks o̱r u̱n ye̱ ne̱, ye̱ yage̱ o̱r u̱n ye̱ ne̱. ");
INSERT INTO uth_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Yan-rwo̱r u̱n Ma-to̱ Shir ye̱ u̱t-bo̱ komo ye̱a indu̱ne̱ de̱e̱n, ye̱a e̱gu̱sse̱ hun-ne̱ de̱e̱n. ");
INSERT INTO uth_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Remen mo̱o̱r-to̱ u̱n me̱n-u̱t jaas-to̱, was-mo̱ ye̱ ken ye̱ ro̱ m-was u̱n o̱r u̱n ye̱ ne̱ à mo̱a heeb. ");
INSERT INTO uth_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Amba bo̱ u̱n wu̱ jo̱o̱se̱ har ha-mo̱ u̱r-ko̱m à, wu̱a po̱sse̱. ");
INSERT INTO uth_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Komo hun-ne̱ ye̱ Shir a ko̱'o̱t kà Ma-to̱ m-Re̱re̱m to̱ u̱n gwo̱mo-to̱ Shir to̱ a ru̱r to̱ ho̱no o-dak, remen a ho̱gu̱té̱ to̱ dak-u̱t-dak, ka da-o̱ ko̱m-de wo̱o̱nte̱.” ");
INSERT INTO uth_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Da-o ro̱o̱n da-o̱ no̱ he m-hyan u̱n rii-yo m-rwu̱k yo ko-yan-Rwo̱r u̱n Ma-to̱ Shir Daneya rwo̱re̱ à, yo ro̱ eso u̱n be-de Pyo-o̱ Shir (Yage̱ ko-ya-m-karante̱ nept.) ");
INSERT INTO uth_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","To̱, ye̱ ro̱ n-me̱ o-Judiya à, ye̱a som ha-mo̱ u̱t-haag. ");
INSERT INTO uth_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Ne̱t-wu̱ ro̱ n-do̱ o-hur à taase wu̱ warag o-hur wu̱ de̱ke̱nte̱ rii-yo ro̱ wu̱ n-me̱ o-hur à. ");
INSERT INTO uth_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Wu̱ ro̱ o-kat à taase wu̱ jo'on dek u̱n co̱p-o̱ u̱n wu̱. ");
INSERT INTO uth_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Ka da-o̱ rii-yo u̱r-'wo̱n yo ne'a-ne̱ ya-u̱t-uub, u̱n ye̱ ro̱ u̱n yakar re̱k-ye̱ ne̱ à! ");
INSERT INTO uth_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","No̱m no̱ u̱s-ko̱n taase rek-u̱s no̱ kor no̱ da-o̱ o-go̱s ko̱ u̱n Ho̱-de u̱r-Wu̱we̱ de u̱n Yahuda-ne̱ ho̱-de o-Sati. ");
INSERT INTO uth_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Ko̱n no̱ remen u̱n ka da-o̱, a nom swo̱ u̱r-ko̱o̱b de a we̱te̱ m-no̱m á cin u̱n takan-de u̱n ho̱no o-dak har haan-mo̱ m-mo̱ka, a do ne̱ m-no̱m go̱n-de á. ");
INSERT INTO uth_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","O-nip, se̱ de̱ a hebe̱ ká ho̱-to̱ m-swo̱ u̱r-ko̱o̱b to̱ u̱n ba kaane̱ à, yatt ko-yan-ho̱o̱g wu̱ he m-ru á, amba remen ka ye̱ a daage̱ à, a heeb ka ho̱-to̱. ");
INSERT INTO uth_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“U̱n ka da-o̱, ko̱ wu̱ ken wu̱ zee no̱, ‘Gwo̱t, Kiristi wu̱ ka káne̱!’ Ko̱, ‘Wu̱ ka re̱e̱no̱!’ Taase no̱ dek to̱. ");
INSERT INTO uth_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Me̱n ze̱e̱ kaane̱ remen yan Kiristi ye̱ u̱t-bo̱, u̱n yan-Rwo̱r u̱n Ma-to̱ Shir ne̱ ye̱ u̱t-bo̱ ye̱a rusune̱. Ye̱ nom caari-o̱ o-napa u̱n rem-se u̱n hyan u̱t-hyat ne̱, remen ye̱ rukt hun-ne̱, har u̱n ye̱ Shir daage̱ ne̱ à u̱rege̱ a nome̱. ");
INSERT INTO uth_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Baks no̱ u̱nze u̱m nekste̱ to̱-u̱t no̱ cin u̱n ga'ane̱. ");
INSERT INTO uth_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Remen kaane̱, wu̱ ken wu̱ zee no̱, ‘Gwo̱t Kiristi Wu̱ ka re̱e̱no̱ o-ko̱t!’ Taase no̱ rwu̱u̱n no̱ hyenet. Ko̱ ne̱, ‘Gwo̱t wu̱ ro̱ re̱e̱no̱ n-me̱ o-kuke̱ wukusse̱,’ taase no̱ go̱ks to̱! ");
INSERT INTO uth_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Me̱n ze̱e̱ kaane̱ remen bo̱ myakt-o ro̱ m-myaktu̱ne̱ zee-mo̱ u̱r-ho̱ran ha-mo̱ u̱r-ho̱rim à, káane̱ mu̱u̱n-mo̱ u̱n Wà-wu̱ u̱n ne̱t he m-no̱m. ");
INSERT INTO uth_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Be-de u-u̱r ro̱ à, ay, káne̱ sakra ro̱ m-mo̱rge̱.” ");
INSERT INTO uth_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Da-o̱ ka ho̱-to̱ u̱n re̱ u̱r-ko̱o̱b to̱ he m-ta à, “ ‘Da-o gaan ho̱-u̱r a nom o-comb, o-re̱ng komo yoa nom o-mo̱k á. Ye̱ge̱-re̱ge̱n a hyemene̱ zee-mo̱ n-To̱n shir, komo Shir a nukt rem-u̱s be̱e̱b se ro̱ u̱n n-To̱n Shir à.’ ");
INSERT INTO uth_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","U̱r-ko̱m ka da-o̱, napa-o̱ m-mu̱u̱n mo̱ u̱n Wà-wu̱ u̱n ne̱t he m-rwu̱u̱n cas u̱n ku̱s-o̱ n-To̱n shir. Myet hun-ne̱ ye̱ u̱n ho̱no o-dak à komo ye̱a nom tu̱k-mo̱ u̱t-me̱n rem o-gye̱r. Ye̱a hyen Wà-wu̱ u̱n ne̱t ro̱o̱n n-to̱n u̱t-ke'ente̱ u̱t-gwo̱mo ne̱ m-se̱ps ne̱ de̱e̱n. ");
INSERT INTO uth_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Wu̱a to̱m yan-to̱m-ye̱ u̱n wu̱, ye̱ hur o-kar o̱ o-zaaz de̱e̱n, komo ye̱ karagse̱ ye̱ a daage̱ à ze̱e̱n-mo̱ u̱r-ho̱ran, u̱r-ho̱rim ne̱, o-baar ne̱, o-ye'er ne̱, zee-mo̱ u̱n o̱ ka wur-o̱ u̱n ho̱no o-dak o̱ ha-mo̱ u̱n o̱ ka re̱e̱no̱.” ");
INSERT INTO uth_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Yoos no̱ yo ken rii-yo n-te̱ u̱n 'yo-yo o-rum. U̱rege̱ jet-se u̱n yo cirig m-zoose̱, se̱ ro̱ m-tu̱pne̱ u̱n wá-u̱t pu̱-to̱, no̱ nak go̱s-o no̱mo̱g yow yow o̱ ka. ");
INSERT INTO uth_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Káane̱ komo, u̱rege̱ no̱ hyanag kap ká rem-se u̱m ru̱ru̱ no̱ à, ro̱ m-ko̱r, no̱a nep u̱nze da-o no̱mo̱g yow yow, wu̱ ro̱ n-riib u̱n ish. ");
INSERT INTO uth_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Nip-o̱ me̱ no̱ m-ru̱re̱, hun-ne̱ ye̱ u̱n ka zaman-yo ye̱a mer á, se̱ kap o̱ u̱n ká rem-se no̱mo̱g. ");
INSERT INTO uth_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","O-to̱n o-dak ne̱ to̱a tees, amba ma-u̱t re to̱a te á ko̱ hiin. ");
INSERT INTO uth_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Amba yatt-wu̱ nape̱ u̱r-ho̱, ko̱ u̱n kwo̱m-u̱s re ká rii-yo he m-ko̱r á, ko̱ yan-to̱m-ye̱ Shir ye̱ ro̱ n-To̱n à, ko̱ Wà, se̱ de̱ o-Tato cot. ");
INSERT INTO uth_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","“Bo̱ a no̱me̱ u̱n da-o Nuhu à, káane̱ mu̱u̱n-m re, me̱ Wà-wu̱ u̱n ne̱t he m-no̱m. ");
INSERT INTO uth_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","U̱ntu̱n ka da-o̱ rii-yo ho̱-mo̱ reet ho̱no o-dak, hun-ne̱ ro u̱n ho̱ge̱ u̱n re̱re̱m-mo̱ u̱t-biki u̱t-ge ne̱, m-re̱, m-swo̱ ne̱, campo̱-ne̱ ro̱ u̱t-ge, a m-'ya u̱n yan-ne'a-ne̱ u̱t-ge, har ha-mo̱ u̱n ho̱-de Nuhu co̱we̱ o-hat à! ");
INSERT INTO uth_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Hun-ne̱ nap rii-yo he m-ko̱r á, har ho̱-m haante̱ mo̱ reet ye̱. Kaane̱ o̱ mu̱u̱n-m re Wà-wu̱ u̱n ne̱t he m-no̱m. ");
INSERT INTO uth_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","U̱n ka da-o̱, hun-ne̱ yoor ye̱a ma'as o-kat, Shir a dek wan-gaan, wu̱a yage̱ wan-gaan. ");
INSERT INTO uth_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Ne'a-ne̱ yoor a ma'as u̱r-na be-u̱r gaan, Shir a dek wan-gaan, wu̱a yage̱ wan-gaan. ");
INSERT INTO uth_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Remen kaane̱ she'et no̱ zo̱ngse̱, remen no̱ nap ho̱-de Go̱s-wu̱ wu̱ ma no̱ he m-mu̱u̱n á. ");
INSERT INTO uth_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Amba nap no̱ yo ka, u̱rege̱ ko-ya-o-hur-wu̱ nepse̱ da-o̱ ko-hyow he m-haan m-te̱t à, wu̱a rewe̱ á. Komo wu̱ roa yage̱ a cu̱wu̱t wu̱ o-hur á. ");
INSERT INTO uth_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Remen kaane̱ no̱ ma se̱ no̱ she'et zo̱ngse̱, ko̱ o̱ ke da-o̱. Remen da-o̱ no̱ e̱sse̱ o-sakto̱ á, ka da-o̱ Wà-wu̱ u̱n ne̱t he m-haan.” ");
INSERT INTO uth_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“¿Wan wu̱ ne̱ ro̱ ko-gu̱w kashi, wa-u̱s-we̱e̱r? Wu̱ ro̱ ká gu̱w-wu̱ wu̱ ko-yan u̱n hur-o̱ u̱n wu̱ rwo̱'e̱ wu̱ gu̱tu̱ wu̱ hur-o̱ u̱n wu̱ à, komo wu̱ 'ye o̱r re u̱n wu̱ gu̱w-ne̱ rii-yo m-re̱ yo u̱n ye̱ u̱n da-o̱ depe̱ à. ");
INSERT INTO uth_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Ko-ya-o-hur mu̱u̱ne̱ wu̱ 'wo̱s ká ko-gu̱w-wu̱ no̱mo̱g rii-yo depe̱ à, ko-ya-o-hur a ho̱ge̱ re̱re̱m-mo̱ u̱n wu̱. ");
INSERT INTO uth_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Nip-o̱ me̱ no̱ m-ru̱re̱, ká ko-ya-o-hur-wu̱ a ru̱ ká ko-gu̱w-wu̱, wu̱ gu̱tu̱ wu̱ saw-to̱ u̱n wu̱ kap. ");
INSERT INTO uth_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Amba u̱rege̱ ká ko-gu̱w-wu̱ ko-yan-me̱n-u̱t jaas-to̱ wu̱, komo wu̱a zee hi u̱n de u̱n wu̱, ‘Ko-yan-hur-o re a jo'on u̱n ga'ane̱ á.’ ");
INSERT INTO uth_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Ka da-o̱, wu̱ ciru̱ bu u̱n ye̱ ká gu̱w-ne̱ ye̱. Komo wu̱ ro̱ u̱t-biki, wu̱ ro̱ m-re̱, wu̱ ro̱ m-swo̱, u̱n yan-su̱su̱u̱r-ne̱. ");
INSERT INTO uth_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Wu̱ nome̱ kàane̱, ko-yan-hur-o̱ u̱n wu̱ a jo'on u̱n ho̱-de wu̱ hu̱u̱te̱ o-sakto̱ á, komo da-o̱ wu̱ nape̱ á. ");
INSERT INTO uth_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Ko-ya-o-hur a bu wu̱ dum-mo̱ pase̱ u̱r-be à, komo wu̱ re̱e̱su̱ wu̱ u̱r-ko̱o̱b be-u̱r gaan u̱n ya-o-she̱pe̱ ne̱. Káne̱ ye̱ he u̱s-kan u̱n haw-se u̱n yin-ne̱. ");
INSERT INTO uth_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“A hongse̱ Gwo̱mo-to̱ Shir u̱ntu̱n yan-ne'a-ne̱ o̱p, ye̱ de̱ke̱ pitirra-to̱ u̱n ye̱. Ye̱ neku̱ru̱, ye̱ gontu̱té̱ ko-ya-u̱r-ge à. ");
INSERT INTO uth_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Ne̱n taan be-de u̱n ye̱ raag-ne̱ ye̱, ne̱n taan komo ya-u̱s-we̱e̱r ye̱. ");
INSERT INTO uth_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Ká raag-ne̱ ye̱ de̱ku̱ru̱ pitirra-to̱ u̱n ye̱ à, amba ye̱ de̱k m-no̱w remen m-do̱ á. ");
INSERT INTO uth_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Ya-u̱s-we̱e̱ru̱ ne̱, ye̱ dekste̱ m-no̱w remen m-do̱. ");
INSERT INTO uth_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Bo̱ ko-ya-u̱r-ge no̱me̱ it-mo̱ u̱n wo̱o̱n à, myet-mo̱ u̱n ye̱ he̱bu̱ m-rew. ");
INSERT INTO uth_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Da-o te̱t-m pu̱rge̱ m-so̱k ne̱ à, ye̱ ho̱gu̱ru̱ eeg a m-ze̱e̱, ‘Ho̱gu̱ no̱, ko-ya-u̱t-ge wu̱ ká! Rwu̱u̱n no̱, no̱ gontu̱ wu̱!’ ");
INSERT INTO uth_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","“Ká yan-ne'a-ne̱ ye̱ kap inu̱ru̱, ye̱ ja'asu̱ru̱ pitirra-to̱ u̱n ye̱. ");
INSERT INTO uth_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Ká raag-ne̱ ye̱ ko̱nu̱ru̱ ya-u̱s-we̱e̱r, ‘Hakku̱r no̱ ya te̱ no̱ no̱w-m no̱ hiin, remen pitirra-u̱t te̱ ro̱ m-mar.’ ");
INSERT INTO uth_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","“Amba ká ya-u̱s-we̱e̱r ye̱ ze̱e̱ru̱ ye̱, ‘Ay, mo̱a bo'os te̱ u̱n no̱ ne̱ á. Jiishte̱ no̱ he be-de u̱n ya-m-baab, no̱ o̱o̱n mo̱ ma no̱.’ ");
INSERT INTO uth_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","“Amba bo̱ ye̱ neke̱te̱, ye̱ o̱o̱nté̱ m-no̱w à, rii-yo ye̱ mu̱u̱nte̱ ko-ya-u̱r-ge wosonte̱. Ye̱ ro̱ zo̱ngse̱ à, ye̱ co̱wu̱ru̱ be-de u̱r-ge u̱n wu̱ ne̱, komo a tigu̱ru̱ ish. ");
INSERT INTO uth_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Da-o ho̱r-o̱, ye̱ ká yan-ne'a-ne̱ ye̱ mu̱u̱nu̱ru̱, ye̱ e̱ssu̱ru̱ n-do̱. Ye̱ ze̱e̱ru̱, ‘Go̱s-wu̱! Go̱s-wu̱! Tikshi te̱ ish!’ ");
INSERT INTO uth_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","“Amba wu̱ shasu̱ru̱ ye̱, ‘Nip-o̱ me̱ no̱ m-ru̱re̱, me̱ nap no̱ á!’ ");
INSERT INTO uth_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","“Remen kaane̱, se̱ no̱ she'et zo̱ngse̱, remen no̱ nap u̱r-ho̱ ko̱ o-da á, o̱ u̱m he m-mu̱u̱n á. ");
INSERT INTO uth_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Komo a hongse̱ Gwo̱mo-to̱ Shir u̱ntu̱n ne̱t-wu̱ he m-neke̱ u̱r-hew à. Wu̱ agnu̱ru̱ yan-gu̱w-mo̱ u̱n wu̱. Wu̱ wongu̱ru̱ ye̱ hwo̱r, ye̱ se̱nge̱té̱ m-o̱ m-baab ne̱, har wu̱ mu̱u̱nte̱. ");
INSERT INTO uth_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Wu̱ ya'asu̱ru̱ wan-gaan ba-u̱t taan-to̱ u̱n azurpa, wan-gaan komo ba-u̱t yoor, wu̱ ken wu̱ ba-o gaan, ko̱ wu̱ ke ho̱n u̱n 'wo̱ns-mo̱ u̱n wu̱. Ka da-o̱, wu̱ neku̱ru̱ hew-de u̱n wu̱. ");
INSERT INTO uth_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","“Ká wu̱ go̱kse̱ ba-u̱t taan à, wu̱ e̱s m-se̱'e̱r á. Wu̱ haaru̱, wu̱ se̱ngu̱ru̱ m-o̱ m-baab ne̱ u̱n ká hwo̱r-ye̱, har wu̱ swo̱o̱ru̱ ho̱-mo̱ u̱n ba-u̱t taan. ");
INSERT INTO uth_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Káane̱ komo, wu̱ go̱kse̱ ba-u̱t yoor à, wu̱ swo̱o̱ru̱ ho̱-mo̱ u̱n ba-u̱t yoor. ");
INSERT INTO uth_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Amba ká wu̱ go̱kse̱ ba-o gaan à, wu̱ haaru̱, wu̱ hinnu̱ru̱ u̱r-kuub n-dak. Wu̱ wuku̱ru̱ hwo̱r-ye̱ u̱n ko-yan-hur-o̱ u̱n wu̱, taase a ci. ");
INSERT INTO uth_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“O-da de̱e̱n, ko-yan-hur-o u̱n ká gu̱w-ne̱ ye̱ jo'onu̱ru̱ hew-de u̱n wu̱. Wu̱ agnu̱ru̱ ká gu̱w-ne̱ ye̱ u̱n wu̱ ye̱, remen ye̱ ogmu̱té̱ wu̱ rii-yo ye̱ no̱me̱ u̱n hwo̱r-ye̱ u̱n wu̱ à. ");
INSERT INTO uth_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Ká ko-gu̱w-wu̱ go̱kse̱ ba-u̱t taan à, ze̱e̱ru̱ ko-yan-o-hur, ‘O ya'astu̱ me̱ ba-u̱t taan. Me̱ ka komo u̱m swo̱o̱g ho̱-mo̱ u̱n ba-u̱t taan.’ ");
INSERT INTO uth_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","“Ko-yan-o-hur ho̱gu̱ru̱ o-zak, wu̱ ze̱e̱ru̱, ‘No̱mo̱g u̱r-bon, ko-yan-kashi m-gu̱w o̱, ne̱t so̱-wu̱! O no̱mo̱g o-shir u̱n rii re̱k-yo. Man ya'as wo̱ gwo̱mo-to̱ arge̱ to̱ ká à. Haan, o nom o-zak be-u̱r gaan u̱n me̱ ne̱.’ ");
INSERT INTO uth_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Ká wu̱ go̱kse̱ ba-u̱t yoor à, wu̱ haanu̱ru̱ komo wu̱ taknu̱ru̱ co. Wu̱ ze̱e̱ru̱, ‘Ko-yan-o-hur, o ya'astu̱ me̱ ba-u̱t yoor. Me̱ ka komo u̱m swo̱o̱g ho̱-mo̱ u̱n ba-u̱t yoor.’ ");
INSERT INTO uth_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","“Ko-yan-hur-o̱ u̱n wu̱ ze̱e̱ru̱ wu̱, ‘No̱mo̱g u̱r-bon, inin ko-gu̱w, kashi u̱n ne̱t! O no̱mo̱g o-shir u̱n rii re̱k-yo, man ya'as wo̱ gwo̱mo-to̱ arge̱ to̱ ká à. Haan, o nom o-zak be-u̱r gaan u̱n me̱ ne̱.’ ");
INSERT INTO uth_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Ka da-de ká ko-gu̱w-wu̱ go̱kse̱ ba-o gaan à wu̱ ma wu̱ wo̱o̱nu̱ru̱. Wu̱ ze̱e̱ru̱, ‘Ko-ya-o-hur, u̱m nepste̱ wo̱ ko-ya-u̱s-hwu̱mu̱g wu̱, wo̱ m-ce̱ u̱n be-de wo̱ go̱'e̱ á. Wo̱ komo ko-yan-co̱n-mo̱ u̱n re̱-mo̱ o-tara wu̱. ");
INSERT INTO uth_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","O̱ rwo̱'e̱, u̱m ho̱gu̱te̱ o-gye̱r, taase u̱m e̱ggu̱sse̱ hwo̱r ru. U̱m argu̱ m-neke̱, u̱m hin u̱r-kuub, u̱m wuku̱ru̱ hwo̱r ru. Go̱ks rii-ye̱ ru. ");
INSERT INTO uth_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Ko-ya-o-hur u̱n wu̱ shasu̱ru̱, ‘Wo̱ ko-yan-me̱n-u̱t jaas-to̱ komo ko-gu̱w-wu̱ m-zar! ¿Ashi, o nepste̱ me̱ ko-ya-u̱s-hwu̱mu̱g wu̱, me̱ m-ce̱ be-de me̱ go̱'e̱ á, komo ko-yan-co̱n-mo̱ u̱n re̱-mo̱ o-tara wu̱? ");
INSERT INTO uth_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Ay, ro jiishte̱ o e̱ssu̱ me̱ hwo̱r re o-benki be-de u̱m roa jo'on u̱m go̱ks rii-ye̱ re har u̱m su̱ m-ho̱ à! ");
INSERT INTO uth_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","“ ‘Rumus no̱ ká hwo̱r-ye̱ be-de u̱n wu̱, no̱ ya'as wan-ba-u̱t o̱p. ");
INSERT INTO uth_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Ká ye̱ no̱me̱ se̱nge̱-mo̱ u̱r-bon u̱n rii-yo a yase̱ ye̱ à, ye̱ a he m-do'e̱, har ye̱ kum de̱e̱n. Amba ká ye̱ ro̱ m-nom o-shir á, ko̱ ka ya-o-hiin-yo ye̱ ro̱tte̱ à se̱ a bu̱su̱te̱ yo m-rumus. ");
INSERT INTO uth_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Jorbu̱ no̱ ka ko-gu̱w-wu̱ o-hwaa wu̱ u̱n comb-o rim-o̱. Káne̱ wu̱ he u̱s-kan u̱n haw-se u̱n yin-ne̱.’ ");
INSERT INTO uth_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Da-o̱ Wà-wu̱ u̱n ne̱t he m-haan n-me̱ u̱n se̱ps-mo̱ u̱n wu̱ à u̱n yan-to̱m-ye̱ Shir ne̱ kap, ka da-o̱ wu̱ he m-she'et u̱n kwu̱u̱r-o̱ u̱n se̱ps-mo̱ u̱t-gwo̱mo. ");
INSERT INTO uth_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Shir a karakse̱ kap hun-ne̱ ye̱ u̱n ho̱no o-dak u̱n he̱r-o̱ u̱n wu̱. Wu̱a koos ye̱ n-ho̱n n-ho̱n, bo̱ yan-gwo̱t u̱t-gu̱t ro̱ u̱n koos u̱n ca u̱n gwo̱o̱r ne̱ à. ");
INSERT INTO uth_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Wu̱a ru̱ ye̱ge̱-ca so̱ u̱n re̱-de u̱n wu̱, ye̱ge̱-gwo̱o̱r ne̱ u̱n kwanta-de u̱n wu̱. ");
INSERT INTO uth_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","“Ka da-o̱ ko-Gwo̱mo he m-ze̱e̱ ye̱ ro̱ u̱n re̱-de u̱n wu̱ à, ‘Haan no̱, no̱ ye̱ kume̱ o-kwu̱m be-u̱r Tato re à! Go̱ks no̱ cim-yo u̱t-gwo̱mo yo Shir e̱ssu̱ no̱ cin u̱n takan-de u̱n ho̱no o-dak à. ");
INSERT INTO uth_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Me̱n ze̱e̱ kaane̱ remen bo̱ u̱m ho̱ge̱ me̱r à, no̱ ya'ag me̱ rii-yo m-re̱. U̱m ho̱gu̱te̱ swo̱o̱t-o̱ m-ho̱, no̱ ya'ag me̱ m-ho̱ u̱m su̱. Me̱ ko-hamat, no̱ go̱ks me̱ u̱n hur-u̱t no̱. ");
INSERT INTO uth_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Me̱tt u̱r-matuku á, no̱ ya'ag me̱ u̱r-matuku. Me̱ u̱n go̱m, no̱ waste̱ u̱n me̱ ne̱. Me̱ ke'o, no̱ habu̱ me̱ u̱r-gas.’ ");
INSERT INTO uth_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Ka da-de ká ye̱ no̱me̱ rii-yo Shir co̱ne̱ à he wu̱ m-shas, ye̱ zee, ‘Go̱s-wu̱, ¿ho̱-de u̱n ya te̱ hyanu̱ wo̱ u̱n ho̱ge̱ u̱n me̱r te̱ ye'et wo̱ rii-yo m-re̱? ¿Ko̱ da-o̱ o ho̱ge̱ swo̱o̱t-o̱ m-ho̱, te̱ ye'et wo̱ m-ho̱ o su̱u̱te̱? ");
INSERT INTO uth_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿Komo ho̱-de u̱n yan o̱ te̱ hyanu̱ wo̱ ko-hamat, te̱ go̱ks wo̱? Ko̱ ¿ho̱-de o ro u̱r-kor, te̱ ye'et wo̱ u̱r-matuku? ");
INSERT INTO uth_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","¿Komo ho̱-de u̱n yan o̱ te̱ hyanu̱ wo̱ u̱n go̱m ko̱ ke'o te̱ waste̱ u̱n wo̱ ne̱?’ ");
INSERT INTO uth_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“Ko-Gwo̱mo a shes ye̱, wu̱ zee, ‘Nip-o̱ me̱ no̱ m-ru̱re̱, bo̱ no̱ nome̱ wan-gaan n-me̱ u̱n ye̱ kà hen-ne̱ re ne̱, ye̱ jiishe̱ u̱s-re̱k à, me̱ no̱ nome̱.’ ");
INSERT INTO uth_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Ka da-o̱ ko-Gwo̱mo he m-ze̱e̱ u̱n yan-kwanta-de u̱n wu̱, ‘Wongu̱ no̱ u̱n me̱ ne̱, no̱ ye̱ Shir hu̱'e̱ o-nu à. Co̱w no̱ ra-o̱ a m-ryomse̱ á har ya nomot re ne̱, o̱ Shir e̱sse̱ ko-Gwo̱mo-wu̱ u̱n ya-u̱t-ko̱t u̱n yan-to̱m-ye̱ u̱n wu̱ ne̱ à. ");
INSERT INTO uth_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Remen bo̱ u̱m ho̱ge̱ me̱r à, no̱ 'ya me̱ rii-yo m-re̱ á. U̱m ho̱ge̱ swo̱o̱t-o̱ m-ho̱, no̱ 'ya me̱ m-ho̱ u̱m su̱ á. ");
INSERT INTO uth_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","U̱m haan u̱r-hamat, no̱ go̱ks me̱ á. Me̱ u̱r-kor, no̱ 'ya me̱ u̱r-matuku á. U̱m go̱mo̱g go̱m, komo me̱ ke'o no̱ was u̱n me̱ ne̱ á.’ ");
INSERT INTO uth_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Ka da-o̱ ye̱ ma ye̱a shes, ye̱ zee, ‘Go̱s-wu̱, ¿ho̱-de u̱n yan o̱ te̱ hyanu̱ wo̱ u̱n ho̱ge̱ u̱n me̱r, ko̱ u̱n swo̱o̱t-o̱ m-ho̱, ko̱ wo̱ u̱r-hamat, ko̱ wo̱ u̱r-kor, ko̱ wo̱ u̱n go̱m, ko̱ wo̱ ke'o, te̱ yage̱ m-was u̱n wo̱ ne̱?’ ");
INSERT INTO uth_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“Ka da-o̱ wu̱a shes ye̱, ‘Nip-o̱ me̱ no̱ m-ru̱re̱, bo̱ no̱ yage̱ nome̱ wan-gaan be-de u̱n ye̱ ká ye̱ ro̱ me̱ re̱k-ye̱ à, ay, me̱ no̱ yage̱ m-nome̱.’ ");
INSERT INTO uth_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","“Ye̱ ká ye̱a cu̱w re̱ u̱r-ko̱o̱b de u̱n ba m-ta. Amba kashi u̱n hun-ne̱ ne̱ ye̱a cu̱w ho̱o̱g-o̱ ba m-ta.” ");
INSERT INTO uth_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Da-o̱ Ye̱so ko̱me̱ rwo̱r u̱n kà rem-se kap à, wu̱ ze̱e̱ru̱ yan-neke̱-mo̱ u̱n wu̱, ");
INSERT INTO uth_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“No̱ nepse̱ Biki-o̱ m-Pas kuks ho̱-u̱t yoor a cirit, komo me̱ Wà-wu̱ u̱n ne̱t ye̱a ya'as me̱ ye̱a kem me̱ o-kan.” ");
INSERT INTO uth_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","U̱n ká da-o̱, Gwo̱mo-ne̱ ye̱ u̱n ko̱n-se Shir u̱n se̱k-ye̱ ne̱ ro̱ u̱r-mo̱ro̱g u̱n hur-o̱ u̱n ko-Gwo̱mo-wu̱ u̱n ko̱n-se Shir, jin-de u̱n wu̱ Ke̱pas. ");
INSERT INTO uth_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Ye̱ to̱o̱ru̱ u̱t-hun, ye̱ shipt Ye̱so wukusse̱, ye̱ hoot wu̱. ");
INSERT INTO uth_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Amba ye̱ ze̱e̱ru̱, “Ba da-o̱ u̱n Biki-o̱ m-Pas á, taase hun-ne̱ ine̱ yo̱ko̱ko̱.” ");
INSERT INTO uth_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Ka da-o̱ Ye̱so ro u̱n bo̱-o̱ o-Betanya u̱n hur-o Simo̱n, wu̱ ro ko-cim n-ga à. ");
INSERT INTO uth_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Da-o̱ u̱n re̱ u̱n ga-to̱ m-rim, wu̱ ken ne'a-wu̱ haanu̱ru̱ be-u̱r Ye̱so u̱r-batta ne̱ de u̱n no̱w-mo̱ m-shi'igin mo̱ u̱n hwo̱r de̱e̱n. Da-o̱ wu̱ ro u̱n re̱ u̱n rii-yo m-re̱ à, wu̱ duusu̱ru̱ Ye̱so ká no̱w-mo̱ u̱r-hi. ");
INSERT INTO uth_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Amba bo̱ yan-neke̱-mo̱ u̱n wu̱ hyente̱ káane̱ à, ryaab-u̱s re̱e̱ru̱ ye̱. Ye̱ ze̱e̱ru̱ o̱r u̱n ye̱ ne̱, “Ay, to̱ kà naas-mo̱ u̱n hwo̱r mo̱. ");
INSERT INTO uth_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Wu̱ ro bakke̱ kà no̱w-mo̱ a roa kumus hwo̱r de̱e̱n, a wongu̱te̱ ko̱o̱b-ne̱.” ");
INSERT INTO uth_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Amba remen Ye̱so nepste̱ yo ye̱ ro̱ m-rwo̱r à, wu̱ ze̱e̱ru̱ ye̱, “¿Remen yan o̱ no̱ suute̱ kà ne'a-wu̱, remen wu̱ nomotu̱ me̱ rii-yo depe̱? ");
INSERT INTO uth_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Ko̱o̱b-ne̱ ro̱ be u̱n no̱ u̱r-ho̱ bi, amba me̱, man do m-she'et be-u̱r no̱ de̱e̱n á. ");
INSERT INTO uth_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Ká ne'a-wu̱ duusu̱tu̱ me̱ ká no̱w-mo̱ wu̱ jamaste̱ wu̱r-o re remen du̱k. ");
INSERT INTO uth_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Nip-o̱ me̱ no̱ m-ru̱re̱, myet be-de a he ka ko̱'o̱t-o̱ u̱n Ma-to̱ m-Re̱re̱m à, ho̱no o-dak kap, a bu̱p m-rwo̱r rii-yo kà ne'a-wu̱ no̱me̱ à remen a baksté̱ u̱n wu̱ ne̱.” ");
INSERT INTO uth_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Wan-gaan be-de u̱n o̱p u̱n yoor 12, jin-de u̱n wu̱ Yahudas Iskariyoti, wu̱ haaru̱ be-de u̱n Gwo̱mo-ne̱ ye̱ u̱n ko̱n-se Shir. ");
INSERT INTO uth_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Wu̱ citu̱ru̱ ye̱, “¿Ya no̱ he me̱ m-ya'as, me̱ bo̱bsu̱ no̱ Ye̱so?” Ye̱ ya'su̱ru̱ wu̱ hwo̱r-ye̱ o-azorpa u̱r-kwo̱o̱z u̱n o̱p 30. ");
INSERT INTO uth_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Cin u̱n ka da-o̱, wu̱ cire̱ hoob-o̱ u̱n co̱w-yo wu̱ hette̱ ya'as u̱n Ye̱so à. ");
INSERT INTO uth_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","U̱n ho̱-de u̱n shi-mo̱ Biki-o̱ u̱t-Buro̱di to̱ ba m-Yist, yan-neke̱-mo̱ u̱n Ye̱so haanu̱ be-de u̱n wu̱. Ye̱ citu̱ru̱ wu̱, “¿Kene̱ o co̱ne̱ te̱ ja'asu̱ wo̱ o reet Biki-o̱ m-Pas?” ");
INSERT INTO uth_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Wu̱ ze̱e̱ru̱, “Neke̱ no̱ n-me̱ o-bo̱ no̱a hyen wu̱ ken ne̱t-wu̱. No̱ ru̱re̱ wu̱, ‘Wa-u̱r-Yoos ze̱e̱g, “Da-o̱ u̱n re nomoste̱ yow yow, komo man re Biki-o̱ m-Pas u̱n hur-o ru u̱n yan-neke̱-m re ne̱.” ’ ” ");
INSERT INTO uth_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Yan-neke̱-mo̱ u̱n wu̱ no̱mu̱ru̱ bo̱ Ye̱so zee ye̱ à. Ye̱ argu̱ komo m-no̱m rii-yo m-re̱ yo u̱n Biki-o̱ m-Pas káne̱. ");
INSERT INTO uth_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Bo̱ rim-m nomte̱ à, Ye̱so she'etu̱ru̱ remen wu̱ reet rii-yo m-re̱ u̱n yan-neke̱-mo̱ u̱n wu̱ ne̱ o̱p u̱n yoor 12. ");
INSERT INTO uth_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Ye̱ ro̱ be-de m-re̱ Ye̱so ze̱e̱ru̱ ye̱, “Nip-o̱ me̱ no̱ m-ru̱re̱, wan-gaan be u̱n no̱ wu̱a ya'as me̱ u̱n kom-to̱ u̱n yan-yage̱-u̱t re.” ");
INSERT INTO uth_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","U̱n naasu̱-mo̱ u̱r-hur de̱e̱n, ye̱ ciru̱ cot-se u̱n wu̱ n-gaan n-gaan. Ye̱ ma'asu̱ru̱ m-ze̱e̱, “Go̱s-wu̱, ¿Ba u̱n me̱ ne̱ o ro̱tte̱ á, me̱ wu̱?” ");
INSERT INTO uth_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Wu̱ shasu̱ru̱, “Wan-gaan be-u̱r no̱, wu̱ ro̱ m-re̱ u̱n rii-yo m-re̱ ko̱k-u̱r gaan u̱n me̱ ne̱ à m-mo̱ka, wu̱ he me̱ m-ya'as. ");
INSERT INTO uth_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Me̱ u̱n ze̱e̱ kaane̱, remen me̱ Wà-wu̱ u̱n ne̱t se̱ u̱m marag bo̱ Ma-to̱ Shir zee cin n-ga à. Amba rii-yo u̱r-'wo̱n yo ká wu̱ he ya'as u̱n ‘Wà-wu̱ u̱n ne̱t à’! Roa jiish ká ne̱t-wu̱ ma a ro yagu̱tu̱ wu̱ m-mat.” ");
INSERT INTO uth_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Yahudas ká wu̱ he wu̱ m-baab à, wu̱ ma wu̱ citu̱ru̱, “¿Wa-u̱s-Nap, ba u̱n me̱ ne̱ o ro̱tte̱ á, me̱ wu̱?” Ye̱so ze̱e̱ru̱ wu̱, “Wo̱ ma o rwo̱ro̱g u̱n nu-o ru.” ");
INSERT INTO uth_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Ye̱ ro u̱n re̱ u̱n rii-yo m-re̱, Ye̱so mossu̱ru̱ u̱r-buro̱di, wu̱ no̱mu̱ru̱ u̱r-bo̱ngo̱n be-de Shir. Wu̱ yotru̱ru̱ ká buro̱di-de, wu̱ ya'su̱ru̱ yan-neke̱-mo̱ u̱n wu̱. Wu̱ ro m-ze̱e̱, “Go̱ks no̱, no̱ re, o̱ ka wu̱r-o re o̱.” ");
INSERT INTO uth_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Wu̱ mossu̱ru̱ ibitte̱-de u̱n ho̱-mo̱ u̱n mat-de u̱s-'yo. Wu̱ no̱mu̱ru̱ Shir u̱r-bo̱ngo̱n, wu̱ argu̱ ye̱ m-ya'as. Wu̱ ro m-ze̱e̱, “Swo̱ no̱ myet-m no̱. ");
INSERT INTO uth_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Mo̱ ka hyó-m re mo̱, mo̱ he shoos u̱n swo̱r o-nu o̱ Shir u̱n hun-ne̱ ye̱ u̱n wu̱ ne̱ à. A wu̱u̱s-mo̱ remen u̱r-seke̱ de u̱n soks u̱n ba'as-to̱ u̱n hun-ne̱ de̱e̱n. ");
INSERT INTO uth_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","We̱r no̱ ma-u̱t re, man do swo̱ u̱n kà ho̱-mo̱ u̱n mat-de u̱s-'yo mo̱ komo á, se̱ de̱ kà ho̱-de u̱m he swo̱ u̱n mo̱ ken pu̱-mo̱ mo̱ be-u̱r gaan u̱n no̱ ne̱ u̱n gwo̱mo-u̱t Tato re à.” ");
INSERT INTO uth_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Ka da-de ye̱ huru̱ Se̱p-o̱ u̱r-Bo̱ngo̱n de Shir, ye̱ ruuru̱. Ye̱ neku̱ru̱ Haag-o̱ u̱n 'yo-se o-Ze̱tun. ");
INSERT INTO uth_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Ye̱so ze̱e̱ru̱ ye̱, “Myet no̱a somos no̱ yagu̱ me̱ u̱n kà te̱t-mo̱, remen Ma-to̱ Shir ze̱e̱g, “ ‘Man wos Wa-u̱r-gu̱t, kur-de u̱n ca komo ye̱a cakre̱.’ ");
INSERT INTO uth_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Amba ne̱ me̱ ine̱ u̱t-marimar, man be'es no̱ m-wo̱ o-Gariri, man 'gone̱ u̱n no̱ ne̱ káne̱.” ");
INSERT INTO uth_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Bitrus ze̱e̱ru̱, “Ko̱ ye̱ som kap remen rii-yo he wo̱ m-ko̱r à, me̱ man som á ko̱ hiin.” ");
INSERT INTO uth_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Ye̱so ze̱e̱ru̱ wu̱, “Nip-o̱ me̱ wo̱ m-ru̱re̱ u̱n kà te̱t-mo̱, rii-yo ke̱e̱g-yo o-kiit kenet, wo̱a nomos she-mo̱ u̱n nap-u̱s re har o-tet.” ");
INSERT INTO uth_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Bitrus ze̱e̱ru̱ wu̱, “Ko̱ a ho me̱, man nom she-mo̱ u̱n nap-u̱s ru á.” Káane̱ ma kap o̱ u̱n yan-neke̱-mo̱ u̱n wu̱ ze̱e̱. ");
INSERT INTO uth_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Ka da-o̱ Ye̱so u̱n yan-neke̱-mo̱ u̱n wu̱ ne̱ haaru̱ de ken be-de a m-ze̱e̱ o-Gese̱mani à. Wu̱ ze̱e̱ru̱ yan-neke̱-mo̱ u̱n wu̱, “She'et no̱ kàne̱, man neke̱ re̱e̱no̱, u̱m nomot u̱s-ko̱n.” ");
INSERT INTO uth_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Wu̱ de̱ku̱ru̱ Bitrus ne̱ u̱n yakar Ze̱be̱di ne̱ yoor, ye̱ ro̱ Yakubu u̱n Yohana. Wu̱ ciru̱ru̱ tu̱k-mo̱ u̱t-me̱n o-regen ne̱ de̱e̱n. ");
INSERT INTO uth_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Wu̱ ru̱ru̱ ye̱ komo, “Tu̱k-mo̱ u̱t-me̱n mo̱ ro̱ u̱n hur u̱n de à, mo̱ wooste̱ mo̱ ho me̱. She'et no̱ kàne̱, zo̱ngse̱ be-u̱r gaan u̱n me̱ ne̱.” ");
INSERT INTO uth_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Wu̱ neku̱ru̱ co hiin, wu̱ argu̱ m-kwu̱mu̱s u̱n hi-de u̱n wu̱ n-dak. Wu̱ no̱mu̱ru̱ u̱s-ko̱n, wu̱ zee, “Tato re! U̱rege̱ a nome̱, dossu̱ me̱ kà ibitte̱-de u̱n swo̱ u̱r-ko̱o̱b de. Myet u̱n kaane̱ ne̱, ba yo u̱m co̱ne̱ u̱n hur u̱n de à, yo yo a he m-no̱m á, se̱ de̱ yo o co̱ne̱ à.” ");
INSERT INTO uth_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Wu̱ mu̱u̱nu̱ru̱ be-de u̱n yan-neke̱-mo̱ u̱n wu̱, wu̱ 'wo̱s ye̱ m-rew. Wu̱ ze̱e̱ru̱ Bitrus, “Ashi! ¿No̱a hoks u̱r-'er ko̱ ya o-da hiin u̱n me̱ ne̱ á? ");
INSERT INTO uth_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","She'et no̱ zo̱ngse̱ komo no̱ nom u̱s-ko̱n u̱n ba káane̱ á no̱a he̱'e̱be̱ n-te̱ u̱t-meger. Ku̱kt-o dekste̱ m-so̱k ne̱, amba wu̱r-o ro̱tt m-'wo̱ns á.” ");
INSERT INTO uth_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Wu̱ dooru̱ m-warag o-ayoore̱-o̱. Wu̱ ko̱nu̱ru̱, “Tato re! U̱rege̱ kà swo̱ u̱r-ko̱o̱b de a dosse̱ á se̱ u̱m swo̱o̱g de, nom yo o co̱ne̱ à.” ");
INSERT INTO uth_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Wu̱ dooru̱ m-mu̱u̱n be-de u̱n ye̱. Wu̱ 'wo̱s ye̱ m-rew, remen yish-ye̱ u̱n ye̱ shiiste̱ m-rew. ");
INSERT INTO uth_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Wu̱ dooru̱ ye̱ m-yage̱, wu̱ haaru̱. Wu̱ no̱mu̱ru̱ u̱s-ko̱n o-atette̱-o̱. Wu̱ ro̱ m-rwo̱r u̱n ma-to̱ wu̱ rwo̱re̱ n-ga à. ");
INSERT INTO uth_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Ka da-de, wu̱ mu̱u̱nu̱ru̱ be-de u̱n yan-neke̱-mo̱ u̱n wu̱. Wu̱ ze̱e̱ru̱ ye̱, “¿Har m-mo̱ka rew-mo̱ no̱tte̱ no̱ u̱r-wu̱we̱? To̱, da-o no̱mo̱g, o̱ a hette̱ ya'as u̱n Wà-wu̱ u̱n ne̱t u̱n kom-to̱ u̱n ya-u̱t-ba'as à. ");
INSERT INTO uth_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Ine̱ no̱, a neke̱ no̱. Wan-ya'as u̱n me̱ woosu̱nte̱.” ");
INSERT INTO uth_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Rii-yo wu̱ tigite̱ o-nu, Yahudas, wan-gaan n-me̱ u̱n ká o̱p u̱n yoor-ye̱ 12, wo̱o̱nu̱ru̱ mo̱sse̱ u̱n mo̱ro̱g-de u̱n hun-ne̱ ne̱ de̱e̱n. Ye̱ ro̱ u̱t-magay ne̱ u̱t-kom, u̱t-ko̱ ne̱. Gwo̱mo-ne̱ ye̱ u̱n ko̱n-se Shir u̱n ye̱ ro̱ se̱k-ye̱ ne̱ à, ye̱ tomontu̱ ye̱. ");
INSERT INTO uth_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Wan-baab-to̱ u̱n wu̱, Yahudas regu̱ssu̱te̱ wu̱ kussu̱te̱ ye̱ o-napa. Wu̱ zee, “Wu̱ u̱m he m-hamat à, wu̱ wu̱ ship no̱ wu̱.” ");
INSERT INTO uth_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Yahudas haaru̱ be-u̱r Ye̱so, wu̱ ze̱e̱ru̱ wu̱, “U̱r-gas, wa-u̱s-Nap o̱!” Yahudas hamtu̱ru̱ wu̱. ");
INSERT INTO uth_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Ye̱so ze̱e̱ru̱ wu̱, “Wan-yen de, no̱m rii-yo hantu̱ wo̱ à.” Ye̱ ká hun-ne̱ ye̱ wo̱o̱nu̱ru̱, ye̱ shipu̱ru̱ Ye̱so, ye̱ bo̱pu̱ru̱ wu̱. ");
INSERT INTO uth_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","U̱n hyan-o̱ u̱n káane̱, wan-gaan be-de u̱n ye̱ ro̱ be-u̱r gaan u̱n Ye̱so ne̱ à, wu̱ mu'usu̱ru̱ magay-o̱ u̱n wu̱, wu̱ kupsu̱ru̱ ko-gu̱w-wu̱ u̱n ko-Gwo̱mo-wu̱ u̱n ko̱n-se Shir o-to̱. ");
INSERT INTO uth_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Ye̱so ze̱e̱ru̱, “Muut magay-o ru, o nak kap wu̱ de̱ke̱ o-magay à, magay-o̱ he wu̱ m-ho. ");
INSERT INTO uth_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿No̱ m-hyan sa o zee me̱tt u̱r-be̱e̱b u̱m hopt gwu̱ be-u̱r Tato re, komo da-o gaan wu̱ to̱mnu̱ me̱ yan-to̱m-ye̱ Shir, ye̱ arge̱ bu̱u̱g-de u̱n karma-ne̱ dugu-u̱s o̱p u̱n dugu-u̱s yoor 12,000 á? ");
INSERT INTO uth_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","To̱, ¿re o̱ ka a he a shoos rii-yo Ge̱n-mo̱ u̱n Ma-to̱ Shir rwo̱re̱ à, u̱nze nip-o̱ se̱ ká rii-yo no̱mo̱g?” ");
INSERT INTO uth_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Ka da-o̱ Ye̱so ze̱e̱ru̱ ka hun-ne̱ ye̱, “No̱ u̱n rwu̱u̱n u̱t-magay ne̱, u̱t-ko̱ ne̱ no̱ shipt me̱ sa o zee me̱ ko-ya-u̱r-kwu̱p wu̱. Ko̱yanda me̱ u̱r-yoos u̱n Pyo-o̱ Shir, ¿ya hante̱ ne̱ no̱ shipte̱ me̱ á? ");
INSERT INTO uth_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Amba myet a u̱n no̱m to̱ ka remen a shoosté̱ rii-yo ro̱ u̱n n-me̱ u̱n taku̱rda-o̱ u̱n yan-Rwo̱r u̱n Ma-to̱ Shir n-ga à.” Bo̱ m-ho̱ge̱ káane̱ kap o̱ u̱n yan-neke̱-mo̱ u̱n wu̱ ye̱ yagu̱ wu̱, ye̱ so̱mu̱ru̱. ");
INSERT INTO uth_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Ye̱ shipe̱ Ye̱so à, ye̱ heetu̱ru̱ wu̱ be-u̱r Ke̱pas, ko-Gwo̱mo-wu̱ u̱n ko̱n-se Shir, be-de yan-Yoos-de o-karamsa u̱n se̱k-ye̱ ne̱, ye̱ rege̱ ye̱ mo̱ro̱gsu̱te̱ à. ");
INSERT INTO uth_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Amba Bitrus do̱ru̱ru̱ ye̱ jim-m-jim u̱r-hew ne̱, har u̱n 'wo̱o̱g-o̱ u̱n hur-o̱ u̱n ko-Gwo̱mo-wu̱ u̱n ko̱n-se Shir. Wu̱ co̱wu̱ru̱, wu̱ she'etu̱ru̱ u̱n gu̱w-ne̱ ne̱, remen wu̱ hyenet bo̱ a he m-bu̱se̱ u̱n Ye̱so ne̱ à. ");
INSERT INTO uth_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","To̱, n-me̱ u̱n Gwo̱mo-ne̱ ye̱ u̱n ko̱n-se Shir u̱n Mo̱ro̱g-de u̱n Se̱k-ye̱ de ne̱, kap ye̱ ho̱o̱bu̱ru̱ taab-de u̱t-bo̱ to̱ ye̱ he nome̱ u̱n Ye̱so remen ye̱ kumut co̱w-yo u̱n ho̱-de u̱n wu̱ à. ");
INSERT INTO uth_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Ko̱ de̱ nomte̱ ye̱ kum hun-ne̱ de̱e̱n ye̱ e̱sse̱ ye̱a ce u̱t-bo̱ à, amba ye̱ kum rii-yo m-rwo̱r á. U̱r-ko̱m ye̱ ken hun-ne̱ yoor-ye̱ rwu̱u̱nu̱ru̱. ");
INSERT INTO uth_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Ye̱ ze̱e̱ru̱, “Wu̱ ka ne̱t-wu̱ ze̱e̱g u̱nze wu̱a hoks m-kaps u̱n Pyo-o̱ Shir, komo wu̱ jaas-o̱ m-ma n-me̱ u̱n ho̱-u̱t tet.” ");
INSERT INTO uth_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Ka da-de, ko-Gwo̱mo-wu̱ u̱n ko̱n-se Shir inu̱ru̱, wu̱ ze̱e̱ru̱, “¿Wo̱tt o̱ ken shas-o̱ u̱n rii-yo ye̱ zee mo̱sse̱ u̱n wo̱ ne̱ á? ¿Ya o he m-ze̱e̱ u̱n hi u̱n du?” ");
INSERT INTO uth_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Amba Ye̱so shas á. Ko-Gwo̱mo-wu̱ u̱n ko̱n-se Shir ze̱e̱ru̱ wu̱, “To̱nd u̱n jin-de Shir wan-ho̱o̱g, u̱rege̱ wo̱ ro̱ Kiristi, Wà-wu̱ Shir.” ");
INSERT INTO uth_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Ye̱so ze̱e̱ru̱ wu̱, “E̱e̱, káane̱ o̱ hond hond bo̱ o rwo̱re̱ à. Komo kane̱ co no̱a hyen me̱ Wà-wu̱ u̱n ne̱t ro̱ u̱r-she'et tara u̱n kom-o̱ u̱r-re̱ de u̱n Shir be-de u̱t-gwo̱mo, wu̱ ro̱o̱n komo n-me̱ u̱t-ke'ente̱ to̱ u̱n ku̱s-o̱ n-To̱n shir.” ");
INSERT INTO uth_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Ko-Gwo̱mo-wu̱ u̱n ko̱n-se Shir yoogu̱ru̱ matuku-to̱ u̱n wu̱ remen tu̱k-mo̱ u̱t-me̱n. Wu̱ ze̱e̱ru̱, “¿De ke taab-de de u̱n ya a o-hoob? No̱ ho̱gu̱te̱ wu̱ nomote̱ Shir o-yo'og. ");
INSERT INTO uth_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿Re no̱ hyane̱?” Ye̱ shasu̱ru̱, ye̱ zee, “Wu̱ wooste̱ a ho wu̱!” ");
INSERT INTO uth_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Ye̱ copsu̱ wu̱ m-ta o-co, ye̱ wosru̱ru̱ wu̱. Ye̱ ken ye̱ komo ye̱ hwo̱o̱gu̱ wu̱ u̱t-raag. ");
INSERT INTO uth_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Ye̱ ro̱ m-ze̱e̱, “Nomo te̱ u̱t-hyat, u̱rege̱ wo̱ Kiristi wu̱! Rwo̱r wu̱ hu̱u̱ wo̱ o-raag à!” ");
INSERT INTO uth_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Ka da-o̱, Bitrus ro̱ tara n-me̱ u̱n 'wo̱o̱g-o̱ o-hur, wu̱ ken wan-ne'a-wu̱ wu̱ ro̱ m-se̱nge̱ u̱n ká hur-o̱ à, wu̱ haaru̱ be-de u̱n wu̱, wu̱ ze̱e̱ru̱ wu̱, “Wo̱ ma, ay, wo̱ m-do̱re̱ u̱n Ye̱so kà ne̱t-wu̱ o-Gariri wu̱.” ");
INSERT INTO uth_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Amba Bitrus no̱mu̱ru̱ m-she be-de u̱n ye̱ kap. Wu̱ ro̱ m-ze̱e̱, “Me̱, me̱ nap ma-to̱ wo̱tte̱ á!” ");
INSERT INTO uth_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","U̱jime̱ bo̱ wu̱ rwu̱u̱nte̱ ish-o m-pyo à, wu̱ ken wan-ne'a-wu̱ ro m-se̱nge̱ u̱n ká hur-o̱ komo à hyanu̱ru̱ wu̱. Wu̱ ze̱e̱ru̱ ka ye̱ ro eso eso u̱n ká be-de à, “Kà ne̱t-wu̱ ro̱ u̱n do̱re̱ u̱n Ye̱so ko-ya-o-Nazaret!” ");
INSERT INTO uth_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Komo Bitrus dooru̱ no̱m m-she, har u̱s-to̱nd. Wu̱ ro̱ m-ze̱e̱, “Me̱ nap ma ká ne̱t-wu̱ á.” ");
INSERT INTO uth_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Jimu̱ru̱ hiin, ka ye̱ ro eso eso u̱n ká be-de à, ye̱ haaru̱ be-u̱r Bitrus. Ye̱ ze̱e̱ru̱, “Ma-to̱ m-she ro̱ ko̱n á. Wo̱ ma wan-gaan wu̱ be-de u̱n ye̱. Bo̱ wo̱ u̱t-ma à, ma-u̱t ru pyaag wo̱ bo̱ ya-o-Gariri ro̱ m-ce̱p à.” ");
INSERT INTO uth_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Bitrus to̱ndu̱ru̱ be-de u̱n ye̱, “Me̱ nap ká ne̱t-wu̱ á!” Ba m-naas o-da, ke̱e̱g-yo kiit-o kanu̱ru̱. ");
INSERT INTO uth_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Bitrus baksu̱ru̱ ma-to̱ Ye̱so ru̱ru̱ wu̱ à u̱nze, “Rii-yo ke̱e̱g-yo kiit-yo kyenet, wo̱a nomos she-mo̱ u̱n nap-u̱s re o-tet.” Bitrus ruuru̱ n-do̱ wu̱ 'wo̱nu̱ru̱ u̱s-'wo̱n de̱e̱n. ");
INSERT INTO uth_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Cin n-sot n-sot, myet o̱ u̱n Gwo̱mo-ne̱ ye̱ u̱n ko̱n-se Shir u̱n se̱k-ye̱ ne̱ mo̱rgu̱ru̱ komo ye̱ to̱o̱ru̱ u̱t-hun ye̱ hoot Ye̱so. ");
INSERT INTO uth_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Ye̱ ka'u̱ru̱ wu̱, ye̱ argu̱ru̱ u̱n wu̱ ne̱, ye̱ heetu̱ru̱ wu̱ be-u̱r Biratus, ko-Gwamna-wu̱ u̱n ka dak-o. ");
INSERT INTO uth_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Da-o̱ Yahudas wu̱ babe̱ wu̱ à hyente̱ a jetu̱te̱ Ye̱so mar-m hwo̱o̱g-mo̱ à, me̱n-to̱ u̱n wu̱ naasu̱ru̱. Wu̱ mu̱u̱nu̱ru̱ be-de u̱n Gwo̱mo-ne̱ ye̱ u̱n ko̱n-se Shir, u̱n se̱k-ye̱ ne̱, wu̱ muutu̱ ye̱ hwo̱r-ye̱ o-azorpa u̱r-kwo̱o̱z u̱n o̱p 30. ");
INSERT INTO uth_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Wu̱ ze̱e̱ru̱, “U̱m no̱mo̱g u̱r-ba'as, remen u̱m ya'aste̱ ko-yan-ba-u̱r-ba'as a ho.” Amba ye̱ ze̱e̱ru̱, “¿Ya daa te̱? U̱t-ma ru to̱ ká.” ");
INSERT INTO uth_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Wu̱ jorbu̱ru̱ ká hwo̱r-ye̱ o-azorpa ye̱ n-me̱ Pyo-o̱ Shir. Wu̱ ruuru̱, wu̱ haaru̱ wu̱ soru̱ru̱ cor-o̱ u̱n wu̱ o-hu̱ n-to̱n o-ce. ");
INSERT INTO uth_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Gwo̱mo-ne̱ ye̱ u̱n ko̱n-se Shir ye̱ ku̱u̱su̱ ká hwo̱r-ye̱, ye̱ ze̱e̱ru̱, “U̱depe̱ a ru̱ kà hwo̱r-ye̱ u̱n be-de u̱r-e̱ss de u̱n Pyo-o̱ Shir á, remen kà hwo̱r-ye̱ ye̱ u̱n ho̱-de u̱n ne̱t ye̱.” ");
INSERT INTO uth_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Ye̱ to̱o̱ru̱ u̱t-hun ye̱ o̱o̱ru̱ de ken be-de u̱n ká hwo̱r-ye̱. A de m-ze̱e̱ Be-de u̱n ko-yan-mà-to̱ u̱t-tur. Ye̱ muutu̱ ká be-de, be-de u̱n jo̱k u̱n hamat-ne̱ ye̱ mere̱. ");
INSERT INTO uth_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Har ca, o̱ rwo̱'e̱ atte̱ m-aag u̱n ká be-de, Pu̱p-o̱ m-Hyó. ");
INSERT INTO uth_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","U̱n kaane̱ a shooste̱ rii-yo wan-Rwo̱r u̱n Ma-to̱ Shir Irmiya rwo̱re̱ à u̱nze, “Ye̱ dek ká hwo̱r-ye̱ o-azorpa ye̱ u̱r-kwo̱o̱z u̱n o̱p 30, hwo̱r-ye̱ a oote̱ wu̱ u̱n co̱n-mo̱ u̱n hun-ne̱ ye̱ o-Isra à. ");
INSERT INTO uth_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Ye̱ o̱o̱ru̱ be-de u̱n ko-yan-mà-to̱ u̱t-tur u̱n ká hwo̱r-ye̱, bo̱ Yawe zee à.” ");
INSERT INTO uth_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Ka da-de, Ye̱so ro̱ eso u̱n he̱r-o Biratus ko-Gwamna-wu̱ u̱n Roma-ne̱. Ko-Gwamna citu̱ru̱ wu̱, wu̱ zee, “¿Wo̱ wu̱ ro̱ ko-Gwo̱mo-wu̱ u̱n Yahuda-ne̱?” Ye̱so ze̱e̱ru̱ wu̱, “O rwo̱ro̱g hond hond.” ");
INSERT INTO uth_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Amba bo̱ Gwo̱mo-ne̱ ye̱ u̱n ko̱n-se Shir u̱n ye̱ ro̱ se̱k-ye̱ ne̱ pyapu̱ wu̱ à, wu̱ zee ye̱ rii á. ");
INSERT INTO uth_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Biratus ze̱e̱ru̱ wu̱, “¿Wo̱ ho̱ge̱ mo̱o̱r-to̱ u̱t-ma to̱ ye̱ ro̱ wo̱ m-sakke̱ á?” ");
INSERT INTO uth_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Amba Ye̱so shas wu̱ ko̱ gom-u̱r gaan á, har ko-Gwamna bu̱p o-nu. ");
INSERT INTO uth_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","To̱, u̱n da-o̱ u̱n Biki-o̱ m-Pas, ko-Gwamna weste̱ u̱n hosu̱ne̱ u̱n ne̱t ko-ya-u̱r-ba'as-wu̱ a ka'e̱ wan-gaan wu̱ ye̱ co̱ne̱ à. ");
INSERT INTO uth_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Kà hak-o̱, wu̱ ken ne̱t-wu̱ ro ko̱n wu̱ ye̱ nape̱ ko-yan-ko̱o̱b-de u̱n ho̱ge̱ u̱t-ma ke'o, jin-de u̱n wu̱ Barabas. ");
INSERT INTO uth_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Da-o̱ Yahuda-ne̱ mo̱rge̱ ká sot-de u̱n co-o̱ hur-o Biratus à, Biratus citu̱ru̱ ye̱, “¿Wan wu̱ no̱ co̱ne̱ u̱m hosu̱ no̱? ¿Barabas wu̱ ko̱ Ye̱so wu̱ a zee Kiristi à?” ");
INSERT INTO uth_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","(Biratus nepste̱ remen u̱r-shoob o̱ se̱k-ye̱ ye̱ u̱n Yahuda-ne̱ shipte̱ Ye̱so.) ");
INSERT INTO uth_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Ka da-de, Biratus ro tara be-de wu̱ ro piish u̱t-ma à, ne'a u̱n wu̱ to̱mnu̱ru̱ a zee wu̱, “Yage̱ ma-to̱ u̱n kà ko-yan-ba-u̱r-ba'as-wu̱ temb, remen kà te̱t-mo̱ u̱m swo̱o̱g u̱r-ko̱o̱b de̱e̱n, bo-o̱ u̱n wu̱ re̱e̱g me̱.” ");
INSERT INTO uth_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Amba Gwo̱mo-ne̱ ye̱ u̱n ko̱n-se Shir u̱n se̱k-ye̱ ne̱ swo̱wu̱ru̱ hun-ne̱ ye̱ zee a ho'os Barabas, a ho Ye̱so. ");
INSERT INTO uth_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Ko-Gwamna dooru̱ ye̱ m-cit, “¿Wan wu̱ ne̱ be-de u̱n kà yoor-ye̱ no̱ co̱ne̱ u̱m hoosu̱ no̱?” Ye̱ ze̱e̱ru̱, “Barabas!” ");
INSERT INTO uth_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Biratus citu̱ru̱ ye̱, “¿To̱, re u̱m he m-no̱m u̱n Ye̱so ne̱ wu̱ a zee Kiristi à?” Kap ye̱ ze̱e̱ru̱, “A kem wu̱!” ");
INSERT INTO uth_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Biratus ze̱e̱ru̱, “¿Remen yane̱? ¿Yan rii-yo wu̱ no̱me̱?” Amba hun-ne̱ dooru̱ 'yons u̱s-co̱r, ye̱ m-ze̱e̱, “A kem wu̱!” ");
INSERT INTO uth_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Biratus hyanu̱ru̱ yatt-yo wu̱ he hoks m-no̱m á, komo hun-ne̱ ro u̱n ma-to̱ ye̱ 'yonste̱ hun-ne̱ u̱r-hur. Wu̱ to̱mu̱ru̱ a ibinu̱ wu̱ m-ho̱. Wu̱ saptu̱ru̱ kom-to̱ u̱n wu̱ u̱n he̱r-o̱ u̱n hun-ne̱. Wu̱ ro̱ m-ze̱e̱, “Me̱ de, ho̱-m re ro̱ n-me̱ u̱n re̱ u̱n ra-o̱ u̱n hyó-mo̱ u̱n kà ko-yan-ba-u̱r-ba'as-wu̱ á. To̱ kà ma-u̱t no̱ to̱.” ");
INSERT INTO uth_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Hun-ne̱ kap ye̱ shasu̱ru̱ ye̱ zee, “Ra-o̱ u̱n hyó-mo̱ u̱n wu̱ o̱ she'et u̱n ge̱ks-u̱t te̱, u̱n yakar te̱ ne̱!” ");
INSERT INTO uth_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Ka da-o̱ Biratus ho'osu̱ru̱ ye̱ Barabas. Wu̱ rwo̱'u̱ru̱ karma-ne̱ ye̱ nomse̱ Ye̱so u̱s-so̱ro̱g, wu̱ ya'asu̱ ye̱ Ye̱so, ye̱ kemet wu̱. ");
INSERT INTO uth_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Karma-ne̱ ye̱ u̱n ko-Gwamna heetu̱ru̱ Ye̱so n-me̱ u̱n hur-o̱ u̱n ko-Gwamna. Ye̱ karaksu̱ru̱ karma-ne̱ ye̱ kusse̱ à be-de u̱n wu̱, ");
INSERT INTO uth_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Ye̱ pormu̱ru̱ wu̱ saw-to̱ u̱n wu̱. Ye̱ cu̱pu̱ru̱ wu̱ o̱ ken co̱p-o jaas-o̱ o̱ u̱n go̱nd-to̱ u̱n gwo̱mo-ne̱. ");
INSERT INTO uth_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Ye̱ no̱mu̱ru̱ go̱nd-o̱ u̱n yokor-ye̱ m-se̱e̱b, ye̱ sawsu̱ wu̱ u̱r-hi. Ye̱ bo̱bsu̱ru̱ wu̱ o-ko̱ u̱n kom-o̱ u̱r-re̱. Ká da-de ye̱ kwu̱ktu̱ru̱ u̱n he̱r-o̱ u̱n wu̱, ye̱ ro̱ wu̱ u̱n nome̱ u̱r-ar. Ye̱ m-ze̱e̱, “Caari caari-ne̱, ko-Gwo̱mo-wu̱ u̱n Yahuda-ne̱!” ");
INSERT INTO uth_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ye̱ copsu̱ru̱ wu̱ m-ta. Ye̱ go̱ksu̱ru̱ ká ko̱-yo, ye̱ wo̱su̱ru̱ wu̱ u̱n yo u̱r-hi. ");
INSERT INTO uth_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Bo̱ ye̱ komoste̱ wu̱ nome̱ u̱r-ar à, ye̱ possu̱ru̱ wu̱ ka co̱p-o jaas-o̱ o̱, ye̱ cu̱pu̱ru̱ wu̱ matuku-to̱ u̱n wu̱. Komo ka da-de ye̱ ruuru̱ u̱n wu̱ ne̱ remen ye̱ kemet wu̱. ");
INSERT INTO uth_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Ye̱ ro m-neke̱ n-co̱w, karma-ne̱ gontu̱ru̱ wu̱ ken ne̱t-wu̱ bo̱-o̱ o-Kire̱ni wu̱, jin-de u̱n wu̱ Simo̱n. Ye̱ gaktu̱ wu̱ saw u̱n ká kan-o Ye̱so o̱. ");
INSERT INTO uth_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Ye̱ ruuru̱ de ken be-de a m-ze̱e̱ o-Gorogota à, (de ro̱, Be-de u̱n caar-o̱ u̱r-hi). ");
INSERT INTO uth_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Ka da-de, karma-ne̱ ya'asu̱ru̱ Ye̱so m-mo̱di mo̱sse̱ u̱n yo ken rii-yo u̱r-gaag yo ne̱ remen wu̱ su̱u̱t, amba bo̱ wu̱ rekte̱ à wu̱ yagu̱ m-swo̱. ");
INSERT INTO uth_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Bo̱ ye̱ kemtu̱ wu̱ à, karma-ne̱ no̱mu̱ru̱ o-gwambe̱ remen gund-to̱ u̱n wu̱. Ye̱ wongu̱ru̱ matuku-to̱ u̱n wu̱. ");
INSERT INTO uth_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Ka da-de, ye̱ she'etu̱ru̱ 'er-de u̱n wu̱. ");
INSERT INTO uth_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Hohond-mo̱ u̱n hi-de u̱n wu̱, a kamu̱ru̱ ko̱'o̱t-o̱ u̱n ma-to̱ u̱n ba'as-de u̱n wu̱. U̱nze, “Wu̱ kà wu̱ ro̱ Ye̱so ko-Gwo̱mo-wu̱ u̱n Yahuda-ne̱.” ");
INSERT INTO uth_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Komo ye̱ kamu̱ru̱ ye̱ ken ya-u̱r-kwu̱p ye̱ ne̱n yoor be-u̱r gaan u̱n wu̱ ne̱. Wan-gaan u̱n re̱-de u̱n wu̱, wan-gaan u̱r-kwanta. ");
INSERT INTO uth_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Hun-ne̱ ye̱ ro̱ m-arag à, ye̱ bo̱pu̱ re̱e̱b-to̱ u̱n wu̱. Ye̱ ro̱ u̱n re̱kt u̱t-hi u̱r-ar. ");
INSERT INTO uth_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Ye̱ ro̱ m-ze̱e̱, “Wo̱ wu̱ he m-wurum u̱n Pyo-o̱ Shir, komo o me o̱ u̱n ho̱-u̱t tet. ¿Wo̱a hoks? Gu hi u̱n du, o kergu̱ne̱ a gu̱t! U̱rege̱ wo̱ Wà-wu̱ Shir wu̱, kergu̱ne̱ u̱n ká kan-o̱ a gu̱t!” ");
INSERT INTO uth_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Káane̱ komo Gwo̱mo-ne̱ ye̱ u̱n ko̱n-se Shir, u̱n yan-Yoos-de o-karamsa ne̱ u̱n ye̱ ken se̱k-ye̱ ne̱ ye̱ se̱ngu̱ wu̱ nome̱ u̱r-ar. Ye̱ m-ze̱e̱, ");
INSERT INTO uth_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Wu̱ guug ye̱ ken ye̱, amba wu̱ hoks hi u̱n de u̱n wu̱ m-gu á! ¿Wu̱ ro̱ ko-Gwo̱mo-wu̱ u̱n Isra-ne̱, wu̱ wu̱? Yage̱ wu̱ kergu̱nte̱ n-to̱n u̱n ká kan-o̱, ká da-o̱ te̱ he m-she̱r u̱n ma-to̱ u̱n wu̱ o-nip. ");
INSERT INTO uth_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Wu̱ she̱re̱g be-de Shir, komo wu̱ ze̱e̱g, ‘Me̱ wà-wu̱ Shir wu̱.’ ” Yage̱ Shir wu̱ guut wu̱ m-mo̱ka! U̱rege̱ Shir ro̱ m-ho̱ge̱ re̱re̱m-mo̱ u̱n wu̱. ");
INSERT INTO uth_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Káane̱ ma ká ya-u̱r-kwu̱p ye̱ a kemtu̱ ye̱ be-u̱r gaan à, ye̱ nomu̱ru̱ wu̱ hun-u̱t jaas-to̱. ");
INSERT INTO uth_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Cin ho̱-u̱r ro̱ u̱r-hi, comb-o ho̱kku̱ru̱ o-dak myet, har ha-mo̱ u̱n so̱ u̱n kwo̱m-u̱s tet-se m-rim. ");
INSERT INTO uth_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","So u̱n kwo̱m-u̱s tet, Ye̱so daku̱ru̱ co̱r de̱e̱n. Wu̱ zee, “E̱roi, E̱roi, ¿rama sabaktani?” Wata “Kwo̱ Shir re, kwo̱ Shir re, ¿remen yan o̱ o joru̱tu̱ me̱?” ");
INSERT INTO uth_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Ye̱ ken ye̱ be-de u̱n ye̱ ro káne̱ eso eso à, bo̱ ye̱ ho̱gu̱te̱ káane̱ à, ye̱ ze̱e̱ru̱, “Kà ne̱t-wu̱ ro̱ u̱n eeg-u̱s E̱rejawan-Rwo̱r u̱n Ma-to̱ Shir.” ");
INSERT INTO uth_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Ba m-rem wan-gaan wu̱ u̱n ye̱ argu̱ o-rek, wu̱ haaru̱ wu̱ de̱knu̱ u̱r-po̱o̱g. Wu̱ mu̱su̱ru̱ de n-me̱ u̱n ho̱-mo̱ o-zambo, wu̱ tuuru̱ o-ko̱. Wu̱ tebbu̱ru̱ Ye̱so wu̱ su̱u̱t. ");
INSERT INTO uth_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Amba ye̱ ken ye̱ ze̱e̱ru̱, “Yagu̱ no̱ wu̱ a gu̱t, u̱rege̱ E̱reja a haan wu̱ guut wu̱ à.” ");
INSERT INTO uth_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Ye̱so dooru̱ dak u̱s-co̱r de̱e̱n, ka da-o̱ wu̱ ho'osu̱ ho̱o̱g-o̱ u̱n wu̱. ");
INSERT INTO uth_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","U̱n ká da-o̱, ká gund-o̱ ro n-me̱ u̱n Pyo-o̱ Shir à yishu̱ru̱ be-u̱t yoor, cin n-to̱n haan-mo̱ n-dak. Dak-o nuktu̱ru̱, ta'ar-u̱t bu̱'u̱gu̱ru̱. ");
INSERT INTO uth_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Saag-u̱s teksu̱ru̱, hun-ne̱ so̱-ye̱ de̱e̱n ye̱ mare̱ à ye̱ inu̱ru̱ u̱n ho̱o̱g ne̱. Ye̱ zu̱rmu̱ndu̱ru̱ u̱n saag-se u̱n ye̱. ");
INSERT INTO uth_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Rii Ye̱so inete̱ u̱t-marimar, ye̱ yagu̱ru̱ u̱s-saag, ye̱ co̱wu̱ru̱ o-Urusharima, hun-ne̱ de̱e̱n hyanu̱ru̱ ye̱. ");
INSERT INTO uth_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","U̱n ká da-o̱, caari-wu̱ u̱n ko-karma-wu̱ u̱n Roma-ne̱, wu̱ u̱n ye̱ ken karma-ne̱ ye̱ ro u̱n 'er-u̱r Ye̱so à. Bo̱ ye̱ hyente̱ nukte̱-mo̱ o-dak komo u̱n rii-yo ko̱re̱ ne̱ à, ye̱ ho̱gu̱ru̱ o-gye̱r de̱e̱n. Ye̱ ze̱e̱ru̱, “O-nip, wu̱ ka Wà-wu̱ Shir wu̱!” ");
INSERT INTO uth_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Ye̱ ken ne'a-ne̱ ye̱ ro ko̱n komo de̱e̱n ye̱ do̱nde̱ Ye̱so cin o-Gariri, ye̱ nomote̱ wu̱ m-se̱nge̱. Ye̱ e̱snu̱ru̱ u̱r-hew ne̱ u̱n gwo̱t-o̱ u̱n rii-yo ro̱ m-ko̱r à. ");
INSERT INTO uth_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","N-me̱ u̱n ye̱, Meri ro ko̱n wu̱ a m-aag Magu̱darin à, u̱n Meri ne̱ (inu Yakubu ne̱ u̱n Yusuhu), komo u̱n ne'a Ze̱be̱di (inu Yakubu u̱n Yohana). ");
INSERT INTO uth_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Da-o̱ rim-m nome̱ à, wu̱ ken ko-ya-o-kwu̱m-wu̱, ne̱t-wu̱ bo̱-o̱ o-Aramatiya, jin-de u̱n wu̱ Yusuhu, wu̱ haanu̱ru̱. Wu̱ ma ko-yan-dor Ye̱so wu̱. ");
INSERT INTO uth_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Wu̱ haaru̱ be-u̱r Biratus. Wu̱ ko̱nu̱ru̱ a ya'as wu̱ u-u̱r Ye̱so. Biratus ze̱e̱ru̱ a ya'as wu̱. ");
INSERT INTO uth_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Yusuhu de̱ku̱ru̱ u-u̱r Ye̱so, wu̱ yereru̱ u̱n gund-o u̱r-bon. ");
INSERT INTO uth_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Wu̱ he̱'e̱dbu̱ru̱ de n-me̱ u̱n saag pu̱-o̱ o̱ ma u̱n wu̱, o̱ hun-ne̱ ro hinge̱ wu̱ u̱n wur-o̱ u̱t-ta'ar à. Wu̱ biriktu̱ru̱ caari-o̱ o-ta'ar. Wu̱ ho̱kku̱ru̱ ish-o̱ u̱n saag, wu̱ argu̱ru̱. ");
INSERT INTO uth_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Meri Magu̱darin, u̱n Meri wan-gaan ne̱ ye̱ ro káne̱ tara u̱n he̱r-o̱ u̱n saag. ");
INSERT INTO uth_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Gas-o̱ u̱n ish, ho̱-de u̱n zo̱nge̱-to̱ u̱n Biki-o̱ m-Pas, Gwo̱mo-ne̱ ye̱ u̱n ko̱n-se Shir u̱n Parisa-ne̱ haaru̱, ye̱ hyenet Biratus. ");
INSERT INTO uth_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Ye̱ ze̱e̱ru̱ wu̱, “Ho̱o̱g ru go̱s de̱e̱n! Te̱ bakste̱ rii-yo ká wan-raks u̱n hun-ne̱ wu̱ zee cin da-o̱ wu̱ ro u̱n ho̱o̱g ne̱ à, u̱nze so̱ u̱n ta-de u̱n ho̱-u̱r atette̱-de, wu̱a ine̱ u̱t-marimar. ");
INSERT INTO uth_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Remen káane̱, rwo̱ a 'er ká saag-o̱ m-so̱k ne̱. No̱m no̱ kaane̱ har ha-mo̱ u̱n ho̱-u̱t tet, taase yan-neke̱-mo̱ u̱n wu̱ neke̱ ye̱ shes u-de u̱n wu̱, ká da-de ye̱ zeet hun-ne̱ wu̱ u̱n ine̱ u̱t-marimar. Káane̱ kore̱ rwu̱k-mo̱ u̱r-ko̱m mo̱a jiish mo̱ u̱r-takan m-yo̱.” ");
INSERT INTO uth_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Biratus ze̱e̱ru̱ ye̱, “Daag no̱ karma-ne̱, no̱ neke̱ no̱ 'er wu̱ bo̱ no̱ he m-hoks à.” ");
INSERT INTO uth_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Ye̱ haaru̱, ye̱ dapu̱ru̱ ge̱n-mo̱ u̱t-gwo̱mo u̱n ta'ar-de u̱n saag. Ye̱ rwo̱'u̱ru̱ komo karma-ne̱ ye̱ 'er ká saag-o̱. ");
INSERT INTO uth_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Ho̱-de u̱r-Wu̱we̱ de u̱n Yahuda-ne̱ aragte̱ o̱ ka, u̱n ho̱-de o-Rahadi n-sot n-sot, Meri wu̱ o-Magu̱darin u̱n Meri wan-gaan ne̱, ye̱ haaru̱, ye̱ gu̱t o-saag. ");
INSERT INTO uth_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Ba u̱n naas o-da, dak-o nuktu̱ru̱, remen wu̱ ken wan-to̱m-wu̱ Wan-Ko̱yan wu̱ kergu̱nte̱ ze̱e̱n-mo̱ n-To̱n shir. Wu̱ biriktu̱ru̱ ta'ar-o̱ a tigu̱te̱ o-saag à, wu̱ she'etu̱ru̱ u̱n o̱. ");
INSERT INTO uth_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Co-o̱ u̱n wu̱ ro̱ u̱s-myakt, matuku-to̱ u̱n wu̱ komo u̱t-pus to̱ puu u̱ntu̱n u̱t-gwe̱re̱. ");
INSERT INTO uth_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Ya-u̱r-'er de u̱n saag ho̱gu̱ru̱ o-gye̱r de̱e̱n. Wu̱r-to̱ u̱n ye̱ ro̱ u̱s-zap. Bo̱ ye̱ hyane̱ wu̱ à, ye̱ he̱e̱ru̱ n-dak u̱ntu̱n margan-ne̱. ");
INSERT INTO uth_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Ka da-o̱ wan-to̱m-wu̱ Shir ze̱e̱ru̱ ne'a-ne̱, “No̱ ho̱ge̱ o-gye̱r á, u̱m nepste̱ Ye̱so no̱ o-hoob wu̱ a kame̱ à. ");
INSERT INTO uth_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Wu̱ ro̱ ko̱n kàne̱ á! Wu̱ inite̱ be-de u̱n margan-ne̱ bo̱ wu̱ rwo̱re̱ a kor à. Haan no̱ gu̱t be-de wu̱r-o̱ u̱n wu̱ ro'e̱ à. ");
INSERT INTO uth_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","M-mo̱ka neke̱ no̱ ho̱r-m-ho̱r, no̱ ru̱re̱ yan-neke̱-mo̱ u̱n wu̱ u̱nze, wu̱ inu̱te̱ u̱t-marimar. Wu̱ ro̱ co no̱ ha-mo̱ o-Gariri, re̱e̱no̱ no̱ he wu̱ m-hyan. Rii-yo u̱m haanu̱ no̱ m-ru̱re̱ à, yo ka.” ");
INSERT INTO uth_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Kà ne'a-ne̱ ye̱ yagu̱ru̱ ká saag-o̱ ho̱r-m-ho̱r. Ye̱ ro̱ gye̱r-o o-gye̱r, mo̱sse̱ o-zak ne̱ de̱e̱n. Ye̱ ro̱ u̱s-rek remen ye̱ heet ye̱ ru̱ru̱té̱ yan-neke̱-m Ye̱so yo wan-to̱m-wu̱ Shir zee à. ");
INSERT INTO uth_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Komo bo̱ ye̱ ro̱ m-neke̱ à, Ye̱so u̱n hi u̱n de u̱n wu̱ go'onu̱ru̱ u̱n ye̱ ne̱. Wu̱ ze̱e̱ru̱ ye̱, “Gwu̱gwu̱-mo̱ u̱r-hur be u̱n no̱!” Ye̱ hyoknu̱ru̱ yow yow u̱n wu̱ ne̱. Ye̱ hamtu̱ru̱ na-se u̱n wu̱. Ye̱ kwu̱ktu̱ru̱ u̱n co-o̱ u̱n wu̱, ye̱ ya'aru̱ wu̱ m-se̱k. ");
INSERT INTO uth_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Ka da-de, Ye̱so ze̱e̱ru̱ ye̱, “No̱ ho̱ge̱ o-gye̱r á! Ha no̱ ru̱re̱ o̱r re ne̱. Ye̱ neke̱ dak-o̱ o-Gariri, re̱e̱no̱ ye̱ he me̱ m-hyan.” ");
INSERT INTO uth_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Bo̱ ká ne'a-ne̱ ye̱ ro̱ u̱r-hew co̱w-mo̱ o-bo̱ à, ye̱ ken ye̱ be-de u̱n ká yan-'er-de u̱n saag, ye̱ co̱wu̱ru̱ o-bo̱ be-de u̱n Gwo̱mo-ne̱ ye̱ u̱n ko̱n-se Shir. Ye̱ ru̱ru̱ ye̱ kap o̱ u̱n rii-yo no̱me̱ à. ");
INSERT INTO uth_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Da-o̱ Gwo̱mo-ne̱ ye̱ u̱n ko̱n-se Shir u̱n se̱k-ye̱ mo̱rge̱ à, ye̱ to̱o̱ru̱ u̱t-hun. Ye̱ ya'asu̱ru̱ karma-ne̱ hwo̱r de̱e̱n. ");
INSERT INTO uth_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Ye̱ ze̱e̱ru̱ karma-ne̱, “Zee no̱, ‘Yan-neke̱-m Ye̱so, ye̱ ha'e̱ m-te̱t, ye̱ hiwe̱ wu̱r-o̱ u̱n wu̱ da-o̱ te̱ ro m-rew à.’ ");
INSERT INTO uth_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","U̱rege̱ kà ma-to̱ wo̱o̱g u̱n to̱-to̱ u̱n ko-Gwamna, te̱a nomo wu̱ u̱t-ma. No̱a cu̱w swo̱ u̱r-ko̱o̱b á.” ");
INSERT INTO uth_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Karma-ne̱ argu̱ go̱ks u̱n hwo̱r. Ye̱ rwo̱ru̱ru̱ bo̱ a zee ye̱ ru̱r à. Kà ma-to̱ u̱n karma-ne̱ to̱ wo̱o̱ru̱ bo̱-to̱ u̱n Yahuda-ne̱ kap. Har caane̱, Yahuda-ne̱ ro̱ to̱ m-rwo̱r. ");
INSERT INTO uth_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Ká yan-neke̱-m Ye̱so ye̱ o̱p o-gaan ye̱ argu̱ ha-mo̱ o-Gariri. Ye̱ haaru̱ u̱n haag-o̱ Ye̱so zee ye̱ he à. ");
INSERT INTO uth_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Da-o̱ ye̱ hyane̱ Ye̱so à, ye̱ kwu̱ktu̱ru̱ u̱n rwu̱n-se u̱n ye̱, ye̱ ya'aru̱ wu̱ m-se̱k, amba ye̱ ken ye̱, ye̱ de̱k u̱nze Ye̱so wu̱ á. ");
INSERT INTO uth_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Ye̱so haaru̱ yow yow. Wu̱ ru̱ru̱ yan-neke̱-mo̱ u̱n wu̱, “o-Tato ya'astu̱ me̱ kap o̱ u̱n gwo̱mo-to̱ o-To̱n shir, o-dak ne̱. ");
INSERT INTO uth_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Remen kaane̱, neke̱ no̱, no̱ muut hun-ne̱ ye̱ u̱n ho̱no o-dak kap yan-neke̱-m re. No̱ yo'os ye̱ m-ho̱ u̱n jin-de o-Tato, u̱n de u̱n Wà ne̱, u̱n de u̱n Ku̱kt-o̱ Shir ne̱. ");
INSERT INTO uth_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","No̱ yoose̱ yan-dor pu̱'e̱, ye̱ nom o-do̱ro̱tte̱ o̱ u̱n ma-u̱t re u̱n kap o̱ u̱n rii-yo u̱m rwo̱'u̱ no̱ à. Nap no̱ yo ka. Me̱ be-u̱r gaan u̱n no̱ ne̱ u̱r-ho̱ bi har u̱n ta-de ho̱no o-dak.”");
INSERT INTO uth_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Ma-to̱ m-Re̱re̱m to̱ ka, to̱ ma Ye̱so Kiristi,Wà-wu̱ Shir. Ho̱gu̱ no̱ bo̱ ka Ma-to̱ m-Re̱re̱m to̱ Shir to̱ takne̱ à. ");
INSERT INTO uth_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Cin n-ga ne̱ wu̱ ken ne̱t-wu̱, wan-Rwo̱r u̱n Ma-to̱ Shir, jin-de u̱n wu̱ Ishaya. Wu̱ ge̱ne̱ rii-yo Shir ze̱e̱ yo he m-ko̱r u̱n co à. Wu̱ ze̱e̱g, “Gwo̱t Shir a to̱mo̱n wan-to̱m o̱ u̱n wu̱ be-de u̱n hun-ne̱. Wu̱a to̱msu̱ne̱ wan-to̱m, wu̱ zo̱ngsu̱té̱ hun-ne̱ remen haan-mo̱ u̱n Wà-wu̱ Shir.” ");
INSERT INTO uth_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","“Hun-ne̱ a ho̱ge̱ co̱r-o̱ u̱n ka wan-to̱m-wu̱ o-ko̱t. Wu̱ ro̱ ye̱ m-ze̱e̱, ‘Yawe no̱ ro̱o̱n. Ja'asu̱ no̱ wu̱ hur-u̱r no̱. No̱ zo̱nge̱ remen haan-mo̱ u̱n wu̱.’ ” ");
INSERT INTO uth_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Ka bo̱-o̱ takne̱ hond hond bo̱ Ishaya ge̱ne̱ à. Ka ne̱t-wu̱ a m-ze̱e̱ Yohana Wa-m-Yo'os u̱n hun-ne̱ m-ho̱, hun-ne̱ ho̱gu̱ru̱ co̱r-o̱ u̱n wu̱ o-ko̱t. Wu̱ ro̱ ye̱ m-ze̱e̱, “E̱s no̱ a yo'os no̱ n-me̱ m-ho̱. Ye̱ e̱sse̱ a yo'oste̱ ye̱ n-me̱ m-ho̱ à, ye̱ kutute̱ ye̱ ho'oste̱ ba'as-to̱ u̱n ye̱ o̱ ka to̱ ye̱ nome̱ Shir à. Ye̱ mu̱u̱nte̱ be-de u̱n wu̱. Wu̱a soks ba'as-to̱ u̱n ye̱.” ");
INSERT INTO uth_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Yan-dak-o̱ o-Judiya ye̱ ma'asu̱ru̱ m-rwu̱u̱n de̱e̱n be-de u̱n wu̱, kap u̱n yan-dak-o̱ o-Urusharima ne̱. Ye̱ ro̱ m-rwo̱r u̱n ba'as-to̱ u̱n ye̱. Wu̱ ro̱ ye̱ m-yo'os n-me̱ u̱n Ro̱o̱g-o̱ o-Joda. ");
INSERT INTO uth_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Yohana ro̱ u̱n co̱p-o̱ o-gund ne̱, o̱ u̱n can-se o-dorom. Wu̱ ro̱ u̱n hap-yo o-ka ne̱ u̱n byon gego. Rii-yo m-re̱ yo u̱n wu̱, ye̱ge̱-'e ye̱ u̱n so̱ ne̱ ye̱ o-ko̱t. ");
INSERT INTO uth_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Wu̱ ro ye̱ m-ru̱re̱ u̱n Ma-to̱ Shir. Wu̱ ro̱ m-ze̱e̱, “Wu̱ ken wu̱ ro̱o̱n u̱n jim u̱n de wu̱ jiishe̱ me̱ à. Me̱ bo'os us u̱n ka'ante̱-to̱ u̱n wu̱ á. ");
INSERT INTO uth_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Me̱ u̱n hi u̱n de, m-ho̱ mo̱ me̱ no̱ m-yo'os, amba wu̱ ne̱, u̱n Ku̱kt-o̱ Shir wu̱ he no̱ m-yo'os.” ");
INSERT INTO uth_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Yohana ro̱ u̱n yo'os u̱n hun-ne̱. Ye̱so rwu̱u̱nu̱ru̱ bo̱-o̱ o-Nazaret u̱n dak-o̱ o-Gariri. Yohana yo'osu̱ru̱ wu̱ u̱n Ro̱o̱g-o̱ o-Joda. ");
INSERT INTO uth_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Ye̱so ro̱ m-rwu̱u̱n n-me̱ m-ho̱, ba u̱n naas o-da, wu̱ hyanu̱ru̱ a m-tiks u̱t-ke'ente̱ n-To̱n o̱ shir. Ku̱kt-o̱ Shir ro̱ m-kergene̱ u̱ntu̱n sha-mo̱ o-gorop, o̱ ciru̱ru̱ be-de u̱n wu̱. ");
INSERT INTO uth_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","A ho̱gu̱ru̱ co̱r n-To̱n o̱ Shir. O̱ ro̱ m-ze̱e̱, “Wo̱ ro̱ Wà re, wu̱ me̱ m-co̱n à. Me̱ o-zak u̱n wo̱ ne̱ de̱e̱n.” ");
INSERT INTO uth_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","U̱n ra-o̱ Ku̱kt-o̱ Shir ciru̱te̱ be-u̱r Ye̱so à. Ku̱kt-o̱ Shir kutu̱ru̱ wu̱, wu̱ ru o-ko̱t. ");
INSERT INTO uth_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Wu̱ ma'asu̱ru̱ kane̱ u̱t-ho̱ kwo̱o̱z-u̱t yoor 40. Ko-Gwo̱mo-wu̱ u̱n ya-u̱t-ko̱t ro̱ wu̱ u̱t-meger ko̱ wu̱a nom u̱r-ba'as be-de Shir à. Ye̱so ro be-de nem ro̱ à, yan-to̱m-ye̱ Shir ye̱ ro wu̱ m-gu. ");
INSERT INTO uth_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","De ken ho̱-de, a tu̱wtu̱ru̱ Yohana u̱n kur-o̱ m-ke'et. Bo̱ a tu̱wte̱ wu̱ u̱n kur-o̱ m-ke'et à, a rewu̱ru̱ u̱t-ho̱ hiin ká da-de, Ye̱so co̱wu̱ru̱ n-me̱ u̱n dak-o̱ o-Gariri. Wu̱ do̱ru̱ru̱ ka dak-o̱, wu̱ ro u̱n ru̱re̱ u̱n hun-ne̱ Ma-to̱ m-Re̱re̱m to̱ Shir. ");
INSERT INTO uth_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Wu̱ ro̱ m-ze̱e̱, “Ho̱-de u̱n ko-Gwo̱mo Shir wosonte̱, de wu̱ hette̱ m-rwu̱u̱n u̱n gwo̱mo-to̱ u̱n wu̱ ne̱ à. Ho'os no̱ ba'as-u̱t no̱, no̱ mu̱u̱n, no̱ kon wu̱. No̱ de̱k Ma-to̱ m-Re̱re̱m to̱ Shir to̱ a no̱ m-ru̱re̱ à.” ");
INSERT INTO uth_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","De ken ho̱-de, wu̱ ro̱ u̱n do̱re̱ u̱n riib-o̱ u̱n Mar-o̱ o-Gariri. Wu̱ hyanu̱ru̱ ye̱ ken yan-ship u̱n jan-ye̱ ne̱n yoor. Jin-to̱ u̱n ye̱ Simo̱n u̱n Andarawus heno u̱n wu̱. Ye̱ ro̱ u̱n neks u̱t-yo n-me̱ o-mar. ");
INSERT INTO uth_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Ye̱so ze̱e̱ru̱ ye̱, “Do̱nd no̱ me̱, man muut no̱ yan-neke̱-m re remen no̱ hantu̱té̱ hun-ne̱ ye̱ do̱ru̱te̱ co̱w-yo Shir.” ");
INSERT INTO uth_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Bo̱ Simo̱n ne̱ ho̱gu̱te̱ ma-to̱ u̱n wu̱ à, ye̱ ho'osu̱ru̱ yo-to̱ u̱n ye̱ ho̱r-m-ho̱r. Ye̱ argu̱ru̱ wu̱ m-do̱re̱. ");
INSERT INTO uth_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Bo̱ ye̱ do̱ru̱te̱ wu̱ à, ye̱ argu̱ru̱ u̱n co hiin. Wu̱ dooru̱ m-hyan u̱n ye̱ ken yan-ship u̱n jan-ye̱. Jin-to̱ u̱n ye̱ Yakubu u̱n Yohana, yakar Ze̱be̱di. Ye̱ ro̱ n-me̱ o-hat. Ye̱ ro̱ u̱n ja'as-de u̱t-yo. ");
INSERT INTO uth_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Bo̱ Ye̱so hyente̱ ye̱ à, wu̱ ze̱e̱ru̱ ye̱ haan ye̱ do̱re̱ wu̱. Ba u̱n naas o-da, ye̱ yagu̱ru̱ tat u̱n ye̱ (Ze̱be̱di) n-me̱ o-hat mo̱sse̱ u̱n ya-u̱r-gu̱wu̱s ne̱. Ye̱ argu̱ru̱ wu̱ m-do̱re̱. ");
INSERT INTO uth_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Ye̱so u̱n yan-neke̱-mo̱ u̱n wu̱ ne̱ co̱wu̱ru̱ bo̱-o̱ o-Kapanahum. Bo̱ Ho̱-de u̱r-Wu̱we̱ wo̱o̱nte̱ à, Ye̱so co̱wu̱ru̱ u̱n kuke̱-o̱ u̱n yoos u̱n Ma-to̱ Shir. Wu̱ yoosu̱ru̱ ye̱ kane̱. ");
INSERT INTO uth_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Ye̱ bo̱pu̱ru̱ o-nu u̱n yoos-de u̱n wu̱, remen wu̱ yoosu̱te̱ ye̱ u̱ntu̱n ko-gwo̱mo. De no̱m u̱ntu̱n de u̱n yan-Yoos-de u̱n karamsa-o Mosa á. De ma u̱n ye̱, yoos-de ro̱tt m-'wo̱ns á. ");
INSERT INTO uth_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Ye̱ kane̱ u̱n kuke̱-o̱ u̱n yoos u̱n Ma-to̱ Shir, wu̱ ken ne̱t-wu̱ ro kon wu̱ ko-ya-u̱t-ko̱t da'e̱ u̱r-hi à. Ba u̱n naas o-da wu̱ she̱rgu̱ru̱ u̱s-kan. ");
INSERT INTO uth_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Wu̱ ze̱e̱ru̱, “¿Ya mo̱sse̱ te̱ u̱n wo̱ ne̱, wo̱ Ye̱so ko-ya-o-Nazaret? ¿Wo̱ u̱n haan te̱ o̱ m-sabarse̱? Te̱ nepste̱ wo̱, Wo̱ ro̱ ko-wan-ba-m-ku̱ko̱p wu̱ Shir!” ");
INSERT INTO uth_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Bo̱ ka ne̱t-wu̱ zette̱ kaane̱ à, Ye̱so hurgu̱ru̱ ko-ya-u̱t-ko̱t u̱t-gaag. Wu̱ ze̱e̱ru̱ wu̱, “Re̱s no̱, no̱ ru u̱n hi-de u̱n wu̱!” ");
INSERT INTO uth_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Bo̱ ka ko-ya-u̱t-ko̱t-wu̱ ho̱gu̱te̱ ma-u̱t Ye̱so à, wu̱ so̱ru̱ ka ne̱t-wu̱ n-dak. Ka ne̱t-wu̱ taknu̱ru̱ u̱s-zap. Ka da-de ne̱, wu̱ she̱rgu̱ru̱ u̱s-kan, ko-ya-u̱t-ko̱t ruuru̱ u̱n hi-de u̱n wu̱. ");
INSERT INTO uth_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Kap o̱ u̱n hun-ne̱ ye̱ ro kane̱ à, ye̱ hyanu̱ru̱ hyat-to̱ takne̱ à. Ye̱ ma'asu̱ru̱ u̱n cot-se u̱n hi u̱n de u̱n ye̱. Ye̱ zee, “¿A'a, yan yo ne̱ kaane̱? Yoos-de u̱n wu̱ ro̱ u̱n ho̱n. Ma-to̱ u̱n wu̱ ro̱ m-'wo̱ns ne̱, har ya-u̱t-ko̱t ro̱ u̱n m-no̱m o-do̱ro̱tte̱ u̱n ma-to̱ u̱n wu̱ ne̱.” ");
INSERT INTO uth_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Bo̱ u̱n kaane̱, Ye̱so ruuru̱ u̱r-jin ho̱r-m-ho̱r u̱n kap ho̱n u̱n dak-o̱ o-Gariri. ");
INSERT INTO uth_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Ye̱so u̱n yan-neke̱-mo̱ u̱n wu̱ ne̱, mo̱sse̱ u̱n Yakubu u̱n Yohana ne̱ rwu̱u̱nu̱ru̱ u̱n kuke̱-o̱ u̱n yoos u̱n Ma-to̱ Shir. Bo̱ wu̱ rwu̱nte̱ à, wu̱ co̱wu̱ru̱ u̱n den-o Simo̱n ne̱ u̱n Andarawus. ");
INSERT INTO uth_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Ko-mo̱o̱n Simo̱n ro̱ do̱mb. Wu̱r-o dengu̱te̱ wu̱ o-ra. Bo̱ Ye̱so tu̱wte̱ ká hur-o̱ à, ba m-naas o-da, ye̱ ru̱ru̱ wu̱ ma-to̱ u̱n wu̱r-o u̱n wu̱. ");
INSERT INTO uth_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Bo̱ Ye̱so ho̱gu̱te̱ à, Ye̱so hyogbu̱ru̱ be-de u̱n wu̱. Ye̱so bo̱pu̱ru̱ wu̱ o-kom. Ye̱so 'yonsu̱ru̱ wu̱. Go̱m argu̱ru̱ m-ta, har wu̱ re̱gtu̱ru̱ Ye̱so ne̱ u̱n o̱r u̱n wu̱ ne̱ ne̱. ");
INSERT INTO uth_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Bo̱ ho̱-u̱r he̱bu̱te̱ à, hun-ne̱ ma'asu̱ru̱ Ye̱so u̱n dekne̱ u̱n ya-u̱s-go̱m, kap u̱n ye̱ ya-u̱t-ko̱t da'e̱ u̱r-hi ne̱ à. ");
INSERT INTO uth_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Ya-o-bo̱ mo̱rgu̱ru̱ u̱n ish ye̱ hyenet. ");
INSERT INTO uth_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Wu̱ taasu̱ru̱ ya-u̱s-go̱m de̱e̱n ko̱ wu̱ ke u̱n go̱n go̱m-o̱ u̱n wu̱ ne̱. Wu̱ ruutu̱ru̱ ya-u̱t-ko̱t de̱e̱n. Wu̱ yage̱ ya-u̱t-ko̱t ye̱ te̱pe̱rte̱ á, remen ye̱ nepste̱ wu̱ ro̱ Wà-wu̱ Shir. ");
INSERT INTO uth_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","U̱n kan-o̱ o-kiit, cin ba ish-o̱ u̱n gas. Ye̱so inu̱ru̱. Wu̱ co̱wu̱ru̱ o-ko̱t be-de ba u̱n ne̱t. Kane̱ Ye̱so ko̱ne̱ Shir. ");
INSERT INTO uth_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Bo̱ wu̱ ruute̱ kane̱ à, Simo̱n ne̱ u̱n o̱r u̱n wu̱ ne̱ ye̱ rwu̱u̱nu̱ru̱ Ye̱so o-hoob. ");
INSERT INTO uth_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Bo̱ ye̱ hyente̱ wu̱ à, ye̱ ze̱e̱ru̱ wu̱, “Ko̱wan wu̱ ro̱ wo̱ o-hoob.” ");
INSERT INTO uth_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Wu̱ ze̱e̱ru̱ ye̱, “A cu̱w no̱ u̱n bo̱-to̱ ro̱ o-co à, u̱m ru̱ru̱t Ma-to̱ Shir kane̱ tomso. O̱ rwo̱'e̱ u̱m haante̱.” ");
INSERT INTO uth_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Ye̱so ko̱mu̱ru̱ do̱re̱ u̱n ho̱n u̱n dak-o̱ o-Gariri kap, wu̱ ro̱ u̱n ko̱'o̱t u̱n Ma-to̱ Shir u̱n kuke̱-to̱ u̱n yoos u̱n Ma-to̱ Shir. Wu̱ ruutu̱ru̱ ya-u̱t-ko̱t u̱n hi-to̱ u̱n hun-ne̱. ");
INSERT INTO uth_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","De ken ho̱-de, wu̱ ken ko-cim-wu̱ haanu̱ru̱ u̱s-ko̱n be-u̱r Ye̱so. Wu̱ kwu̱ktu̱ru̱ u̱n he̱r-o Ye̱so. Wu̱ ze̱e̱ru̱ Ye̱so, “U̱rege̱ o co̱no̱g, wo̱a hoks me̱ m-taase̱ u̱n go̱m re.” ");
INSERT INTO uth_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Ye̱so ho̱gu̱ru̱ 'wo̱n-de u̱n wu̱, Ye̱so tabbu̱ru̱ o-kom, wu̱ ci'u̱ru̱ ká ko-cim-wu̱, Ye̱so ze̱e̱ru̱ wu̱, “U̱m co̱no̱g, ka cim-to̱ te.” ");
INSERT INTO uth_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Ye̱so ro̱ u̱t-ma, cim-u̱t taaru̱ ka ne̱t-wu̱ ba u̱n naas o-da. Wu̱r-o̱ u̱n wu̱ wargu̱ru̱ po̱r po̱r. ");
INSERT INTO uth_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Ye̱so naku̱ru̱ wu̱ u̱t-to̱, ka da-de Ye̱so yagu̱ wu̱ aragte̱. ");
INSERT INTO uth_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Ye̱so ze̱e̱ru̱ wu̱, “Wo̱ jar o ru̱r rii-yo ko̱re̱ á. Amba neke̱ o kute̱ wan-Co̱w u̱n ko̱n-se Shir hi u̱n du bo̱ a taasu̱ wo̱ u̱t-cim à. O seke̱seke̱-to̱ Mosa ze̱e̱ à. Ka bo̱-o̱ hun-ne̱ he m-nap u̱nze a taasu̱tu̱ wo̱ u̱t-cim.” ");
INSERT INTO uth_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Amba ka ne̱t-wu̱ ruuru̱, wu̱ taknu̱ rwo̱r u̱n ka ma-to̱ ko̱ kene̱. Wu̱ ma'asu̱ru̱ m-ru̱re̱ u̱n hun-ne̱ rii-yo no̱me̱ à. Bo̱ a taase wu̱ cim-to̱ u̱n wu̱ à, har Ye̱so wu̱ do hoks m-co̱w o-bo̱ a hyenet wu̱ á. Amba wu̱ she'etu̱nu̱ru̱ re̱e̱no̱ o-ko̱t. Hun-ne̱ ye̱ u̱n ko̱ kene̱ ye̱ ma'asu̱ru̱ m-ha be-de u̱n wu̱. ");
INSERT INTO uth_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Bo̱ ho̱-u̱t doote̱ à, Ye̱so mu̱u̱nu̱ru̱ komo bo̱-o̱ o-Kapanahum. Hun-ne̱ ho̱gu̱ru̱ wu̱ mu̱u̱nte̱ o-hur. ");
INSERT INTO uth_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Bo̱ ye̱ ho̱gu̱te̱ à, ye̱ mo̱rgu̱ru̱ de̱e̱n be-de wu̱ comse̱ à. A u̱n kum be-de u̱n hwo̱ o-na á, remen mo̱o̱r-to̱ u̱n hun-ne̱. N-me̱ n-do̱ ne̱ hun-ne̱ shiiste̱. Wu̱ ro ye̱ m-ru̱re̱ u̱n Ma-to̱ Shir. ");
INSERT INTO uth_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Ye̱ ken ye̱ dooru̱ m-nekne̱ u̱n ko-ryam ne̱. Ne̱n nass-ye̱ de̱kne̱ wu̱ n-te̱ o-ke̱re̱m. ");
INSERT INTO uth_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Amba remen mo̱o̱r-to̱ u̱n hun-ne̱, ye̱ kum be-de m-co̱w ye̱ woot be-u̱r Ye̱so á. Bo̱ ye̱ hyente̱ kaane̱ à, ye̱ daaru̱ n-to̱n u̱r-do̱o̱b, ye̱ pyaaru̱ u̱r-hek n-to̱n be-de Ye̱so ro̱ à. Bo̱ ye̱ pyeete̱ u̱r-hek à, ye̱ tu̱wtu̱ru̱ ko-ryam n-me̱ o-ke̱re̱m ne̱ o̱ wu̱ ro̱tte̱ do̱mb à. ");
INSERT INTO uth_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Bo̱ Ye̱so hyente̱ rii-yo ye̱ no̱me̱ à, wu̱ napu̱ru̱ u̱nze ye̱ she̱re̱g u̱n wu̱. Wu̱ ze̱e̱ru̱ ko-ryam, “Nay re, u̱m sokste̱ ba'as-u̱t ru.” ");
INSERT INTO uth_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","To̱, ye̱ ken yan-Yoos-de u̱n karamsa-o Mosa ye̱ ro kane̱ tara. Bo̱ ye̱ ho̱gu̱te̱ ma-to̱ Ye̱so ze̱e̱ ko-ryam à, ye̱ ze̱e̱ru̱ u̱n hur-de u̱n ye̱, ");
INSERT INTO uth_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“¿Ya hante̱ ka ne̱t-wu̱ zeet kaane̱? Wu̱ yo'ogte̱ Shir. Wan wu̱ bo̱'o̱se̱ sokse̱ u̱n hun-ne̱ ba'as-to̱ u̱n ye̱ se̱ Shir u̱n ho̱n-de u̱n wu̱.” ");
INSERT INTO uth_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Ba u̱n naas o-da, Ye̱so napu̱ru̱ barag-se u̱n ye̱ kap u̱n ku̱t-o̱ u̱n wu̱. Wu̱ ze̱e̱ru̱ ye̱, “¿Remen yan o̱ no̱tte̱ u̱s-barag kaane̱ u̱n hur u̱n no̱? ");
INSERT INTO uth_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","¿Ya jiishe̱, a zee ko-ryam ‘A soksu̱tu̱ wo̱ ba'as-u̱t ru,’ ko̱ a zee wu̱, ‘Ine̱ ge̱, o mos ke̱re̱m-o ru, o arag jo’?” ");
INSERT INTO uth_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Ye̱so dooru̱ ye̱ m-ze̱e̱, “To̱, yage̱ u̱m kutu no̱, no̱ nept u̱nze me̱ Wà-wu̱ u̱n ne̱t ro̱ m-'wo̱ns ne̱, me̱ bo̱'o̱se̱ sokse̱ u̱n hun-ne̱ ba'as-to̱ u̱n ye̱.” ");
INSERT INTO uth_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Bo̱ wu̱ zette̱ kaane̱ à, wu̱ ze̱e̱ru̱ ko-ryam, “Ine̱ ge̱, o mos ke̱re̱m-o ru, o arag jo.” ");
INSERT INTO uth_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Ka ne̱t-wu̱ inu̱ru̱ ge̱, wu̱ mossu̱ru̱ ke̱re̱m-o̱ u̱n wu̱. Wu̱ ruuru̱ u̱n yish-ye̱ u̱n hun-ne̱ har ye̱ bo̱pu̱ru̱ nu. Ye̱ se̱ke̱msu̱ru̱ Shir u̱r-bo̱ngo̱n u̱r-bo̱ngo̱n. Ye̱ ze̱e̱ru̱, “Wuuu, te̱ we̱t m-hyan kaane̱ á.” ");
INSERT INTO uth_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","De ken ho̱-de, Ye̱so dooru̱ m-ru n-riib o̱ o-mar. Hun-ne̱ ma'asu̱ru̱ m-mo̱rge̱ be-de u̱n wu̱. Wu̱ ze̱e̱ru̱ ye̱ m-yoose̱. ");
INSERT INTO uth_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Bo̱ wu̱ komte̱ ye̱ m-yoose̱ à, wu̱ inu̱ru̱ wu̱ argu̱ru̱ u̱n co. Wu̱ hyanu̱ru̱ wu̱ ken ne̱t-wu̱ jin-de u̱n wu̱ Rewi (wà Aru̱payes). Wu̱ ro̱ tara m-se̱nge̱ u̱n kuke̱-o̱ atte̱ u̱n go̱ks u̱n hwo̱r-ye̱ u̱n tar à. Ye̱so ze̱e̱ru̱ wu̱, “Do̱nd me̱.” Wu̱ inu̱ru̱, wu̱ do̱ru̱ru̱ Ye̱so. ");
INSERT INTO uth_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Ka da-de, komo Ye̱so haanu̱ru̱ u̱n hur-o Rewi u̱n yan-neke̱-mo̱ u̱n wu̱ ne̱. Ye̱ ro̱ u̱n re̱ u̱n rii-yo m-re̱ u̱n yan-go̱ks u̱n hwo̱r-ye̱ u̱n tar ne̱ u̱n ya-u̱t-ba'as ne̱. Go̱n ka hun-ne̱ ye̱, ye̱ ro̱ u̱n do̱re̱ u̱n Ye̱so u̱t-mo̱o̱r ne̱. ");
INSERT INTO uth_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Yan-Yoos-de u̱n karamsa-o MosaParisa-ne̱, ye̱ hyanu̱ru̱ wu̱ ro̱ m-re̱ u̱n rii-yo m-re̱ be-u̱r gaan u̱n ya-u̱t-ba'as ne̱ u̱n yan-go̱ks u̱n hwo̱r-ye̱ u̱n tar ne̱. Ye̱ citu̱ru̱ yan-neke̱-mo̱ u̱n wu̱. Ye̱ ze̱e̱ru̱, “¿Remen yan o̱ ne̱ wu̱ ro̱tte̱ u̱n re̱ u̱n rii-yo m-re̱ mo̱sse̱ u̱n yan-go̱ks u̱n hwo̱r-ye̱ u̱n tar ne̱ u̱n ya-u̱t-ba'as ne̱?” ");
INSERT INTO uth_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Bo̱ Ye̱so ho̱gu̱te̱ kaane̱ à, wu̱ ze̱e̱ru̱ ye̱, “Ye̱ ro̱ ba u̱n go̱m à ye̱ u̱n hoob-o̱ u̱n ko-ya-u̱s-baat á, amba ya-u̱s-go̱m. Me̱ u̱n haan remen kashi u̱n hun-ne̱ á. Me̱ u̱n haan remen ya-u̱t-ba'as.” ");
INSERT INTO uth_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","De ken ho̱-de, yan-neke̱-m Yohana Wa-m-Yo'os u̱n hun-ne̱ m-ho̱ ye̱ ro̱ o-swo̱o̱t. Parisa-ne̱ ye̱ ro̱ m-no̱m kaane̱ tomso. Ye̱ ken hun-ne̱ ye̱ haanu̱ru̱ be-u̱r Ye̱so, ye̱ citu̱ru̱ wu̱, “¿Re no̱me̱ yan-neke̱-m Yohana u̱n yan-neke̱-mo̱ u̱n Parisa-ne̱ ro̱tte̱ m-no̱m o-swo̱o̱t remen Shir, amba ye̱ ma ru ro̱ m-no̱m á?” ");
INSERT INTO uth_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Ye̱so shasu̱ru̱ ye̱ u̱n sha-mo̱ u̱t-ma, wu̱ ze̱e̱ru̱, “To̱, ¿a nome̱ kaane̱? ¿Wa-u̱r-ge u̱n nay-ne̱ ye̱ u̱n wu̱ ne̱ ye̱ yage̱ re̱ u̱n rii-yo m-re̱ mo̱sse̱ u̱n wu̱ ne̱? Ay, a nome̱ kaane̱ á. ");
INSERT INTO uth_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Se̱ de̱ ho̱-de a he m-de̱k u̱n ka wa-u̱r-ge-wu̱ à, ka ho̱-de o̱ ye̱ he m-yage̱ u̱n re̱ u̱n rii-yo m-re̱.” ");
INSERT INTO uth_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Ye̱so ze̱e̱ru̱, “Magund-u̱r ut a de m-dap be-de u̱n gund-o pu̱-o̱ á. ¿A mo̱sse̱ u̱r-ut u̱r-pu̱-de ne̱? Pu̱-de-u̱r a yiish u̱r-ut kyaar, har arag-mo̱ n-ga. ");
INSERT INTO uth_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Komo yatt-wu̱ he wu̱u̱s m-ke̱ m-pu̱ mo̱ u̱n tur-o̱ o-ka o-ut á, remen mo̱ pu'e̱ mo̱a caat tur-o̱ o-ka. Ka ke̱-mo̱ ukse̱, komo ka tur-o̱ o-ka o̱ naase̱. Remen kaane̱, a duus ke̱-m pu̱-mo̱ u̱n tur-o̱ o-ka o-pu̱ o̱.” ");
INSERT INTO uth_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","De ken ho̱-de ne̱, Ho̱-de u̱r-Wu̱we̱, Ye̱so ro m-arag u̱n co̱w n-te̱te̱ o̱ u̱n kat-o̱ u̱n hyo. Ye̱ ro̱ u̱r-hew, yan-neke̱-mo̱ u̱n wu̱ ye̱ taknu̱ m-jet u̱n ro̱p-to̱ u̱n hyo. ");
INSERT INTO uth_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Parisa-ne̱ hyanu̱ru̱. Bo̱ ye̱ hyente̱ à, ye̱ ze̱e̱ru̱ Ye̱so, “A'a, ¿re no̱me̱ no̱tte̱ m-jet u̱n ro̱p-to̱ u̱n hyo Ho̱-de u̱r-Wu̱we̱? ¿Ho̱-de Mosa zette̱ a nom m-se̱nge̱ u̱n de á?” ");
INSERT INTO uth_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Ye̱so ze̱e̱ru̱ ye̱, “¿No̱ we̱t m-karante̱ rii-yo Dawuda nome̱ á? ¿Da-o̱ wu̱ ho̱ge̱ me̱r à, wu̱ u̱n o̱r u̱n wu̱ ne̱ à? Baks no̱. ");
INSERT INTO uth_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Da-o̱ Abiyata ro'e̱ ko-Gwo̱mo-wu̱ u̱n ko̱n-se Shir à, Dawuda ro m-neke̱ u̱n o̱r u̱n wu̱ ne̱ ne̱. Wu̱ co̱wu̱ru̱ De̱pi-o̱ Shir. Wu̱ 'wo̱ssu̱ru̱ ga-to̱ a e̱sse̱ remen Shir à, to̱ u̱depe̱ ne̱t re á se̱ yan-Co̱w u̱n ko̱n-se Shir, Dawuda re̱e̱ru̱ to̱ har wu̱ ya'u̱ru̱ o̱r u̱n wu̱ ne̱.” ");
INSERT INTO uth_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Ka da-de, Ye̱so ze̱e̱ru̱ ye̱, “Shir no̱mo̱g Ho̱-de u̱r-Wu̱we̱, wu̱ no̱m de remen a waragte̱ gu̱w-ne̱ ye̱ u̱n de á. Wu̱ no̱mo̱g ka ho̱-de, remen wu̱ guut na. ");
INSERT INTO uth_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Tomso ne̱, Wà-wu̱ u̱n ne̱t, wu̱ ro̱ ko-gwo̱mo-wu̱ bo̱'o̱se̱ daag u̱n rii-yo a he m-no̱m u̱n ka Ho̱-de u̱r-Wu̱we̱ de à.” ");
INSERT INTO uth_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","De ken ho̱-de, Ho̱-de u̱r-Wu̱we̱, Ye̱so dooru̱ m-co̱w u̱n kuke̱-o̱ u̱n yoos u̱n Ma-to̱ Shir. Wu̱ hyanu̱ru̱ wu̱ ken ne̱t-wu̱ kane̱ wan-kom-o margan. ");
INSERT INTO uth_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","To̱, ye̱ ken hun-ne̱ ye̱ ro kane̱ ye̱ co̱no̱g ye̱ shipk Ye̱so u̱r-ba'as. Ye̱ ma'asu̱ru̱ Ye̱so u̱n tuwe̱ u̱n yish ko̱ wu̱a taasu̱ wu̱ ka go̱m-o̱ o-kom à. Ye̱ de̱k u̱nze Ye̱so dosse̱ wu̱ ka go̱m-o̱ Ho̱-de u̱r-Wu̱we̱, ye̱ ship Ye̱so o̱ ká be-de u̱r-ba'as. Ye̱ kumug o̱ ka co̱w-yo ye̱ hette̱ wu̱ m-heet be-de u̱n piish u̱t-ma à. ");
INSERT INTO uth_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Ye̱so ze̱e̱ru̱ wan-kom-o margan, “Hyokne̱ o ine̱ ge̱ u̱n co-o̱ u̱n ko̱wan.” ");
INSERT INTO uth_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Ka da-de ne̱, wu̱ citu̱ru̱ hun-ne̱, “¿Ya karamsa-o Mosa ze̱e̱ a he m-no̱m Ho̱-de u̱r-Wu̱we̱? ¿A nom rii yo̱-yo, ko̱ o-so̱-yo? ¿A gu ne̱t a doote̱ wu̱ u̱t-ho̱, ko̱ de̱ a ho wu̱?” Ye̱ re̱su̱ru̱ te̱k. ");
INSERT INTO uth_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Wu̱ gwo̱tu̱ru̱ ye̱ gwo̱t-o̱ u̱s-ryaab. Me̱n-u̱t naasu̱te̱ wu̱ remen cikt-de u̱n ye̱. Ka da-de, wu̱ ze̱e̱ru̱ ka ne̱t-wu̱, “Neks kom-o ru.” Wu̱ neksu̱ru̱ kom-o̱ u̱n wu̱. Go̱m taaru̱. ");
INSERT INTO uth_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Ba u̱n naas o-da Parisa-ne̱ ruuru̱, ye̱ gamu̱ru̱ u̱t-hi u̱n hun-ne̱ ko-Gwo̱mo Here̱ ne̱ ye̱ wu̱ ro̱tte̱ u̱t-tu̱w à. Ye̱ ho̱o̱bu̱ru̱ o-co̱w ye̱ hoot Ye̱so. ");
INSERT INTO uth_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","8","Ye̱so inu̱ru̱ mo̱sse̱ u̱n yan-neke̱-mo̱ u̱n wu̱ ne̱. Ye̱ haaru̱ n-riib o̱ o-mar. Mo̱o̱r-to̱ u̱n hun-ne̱ de̱e̱n u̱n dak-o̱ o-Gariri ye̱ do̱ru̱ru̱ wu̱, har yan-dak-o̱ o-Judiya, u̱n yan-bo̱-o̱ o-Urusharima ne̱, dak-o̱ o-Idumiya, u̱n hun-ne̱ ne̱ ye̱ u̱n jit-de u̱n Ro̱o̱g-o̱ o-Joda, raag-o̱ o-Taya o-Sidon ne̱. Ho̱no o-dak ye̱ haanu̱ru̱ be-de u̱n wu̱. Ye̱ ho̱gu̱su̱te̱ kap rem-se wu̱ ro̱ m-no̱m à. ");
INSERT INTO uth_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Bo̱ ye̱ mo̱rgu̱te̱ à, Ye̱so ze̱e̱ru̱ yan-neke̱-mo̱ u̱n wu̱ ye̱ e̱ssu̱ wu̱ hat-o re̱k-o̱, taase mo̱o̱r-to̱ u̱n hun-ne̱ me̱gu̱mse̱ wu̱. ");
INSERT INTO uth_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Wu̱ be'esu̱te̱ wu̱ taasu̱te̱ ya-u̱s-go̱m de̱e̱n go̱m-se u̱n ye̱, har kap ya-u̱s-go̱m ye̱ ro m-mo̱nd be-de u̱n wu̱ ye̱ ci'it wu̱. ");
INSERT INTO uth_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Da-o̱ ye̱ ya-u̱t-ko̱t da'e̱ u̱r-hi à, hyane̱ Ye̱so à, ye̱ kwu̱ktu̱ru̱ u̱n co-o̱ u̱n wu̱. Ye̱ ze̱e̱ru̱ u̱s-kan, “Wo̱ wu̱ Wà-wu̱ Shir.” ");
INSERT INTO uth_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Wu̱ kangsu̱ru̱ ye̱, ye̱ yage̱ wu̱ m-rwu̱u̱nte̱ kaane̱. ");
INSERT INTO uth_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Ye̱so daagu̱ru̱ ye̱ ken yan-neke̱-mo̱ u̱n wu̱ ye̱, ye̱ neke̱, ye̱ deet o-haag u̱n wu̱ ne̱, yan-neke̱-mo̱ u̱n wu̱ argu̱ m-ha. ");
INSERT INTO uth_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","15","Wu̱ daagu̱ru̱ ne̱n o̱p u̱n yoor, wu̱ egu̱ru̱ ye̱ u̱r-jin yan-To̱m ye̱ u̱n wu̱. Ye̱ ma'aste̱ m-neke̱ u̱n wu̱ ne̱, ye̱ ko̱tu̱té̱ hun-ne̱ Ma-to̱ Shir, ye̱ kumut 'wo̱ns-mo̱ u̱n ruut u̱n ya-u̱t-ko̱t u̱n hi-to̱ u̱n hun-ne̱. ");
INSERT INTO uth_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","19","Jin-to̱ u̱n ye̱ to̱ ka, ne̱n o̱p u̱n yoor-ye̱ wu̱ daage̱ à: Simo̱n (wu̱ Ye̱so ru̱'e̱ u̱r-jin Bitrus à), Yakubu (wà Ze̱be̱di), u̱n heno u̱n wu̱ Yohana (ye̱ wu̱ ru̱'e̱ u̱r-jin yakar Buwanajis à, yakar-ye̱ u̱t-dàkàr), tomso Andarawus, u̱n Pirip, Bataromi, u̱n Matiyos, Tomas, Yakubu (wà Aru̱payes), u̱n Taddiyus, u̱n Simo̱n (ya o-Kan'ana), tomso Yahudas Iskariyoti wu̱ (wu̱ ya'ase̱ Ye̱so u̱n kom-to̱ u̱n ya-u̱t-yage̱ à). ");
INSERT INTO uth_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Ka da-de, Ye̱so co̱wu̱ru̱ o̱ ken hur-o̱, komo mo̱o̱r-to̱ u̱n hun-ne̱ dooru̱ m-go'one̱ be-de u̱n wu̱, har wu̱ kum da-o̱ u̱n re̱ u̱n rii-yo m-re̱ u̱n yan-neke̱-mo̱ u̱n wu̱ ne̱ á. ");
INSERT INTO uth_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Da-o̱ o̱r u̱n wu̱ ne̱ ho̱ge̱ kaane̱ à, ye̱ ruuru̱ ye̱ bu̱pt wu̱. Ye̱ u̱n no̱m kaane̱ remen ye̱ ken hun-ne̱ ye̱ ro̱ m-ze̱e̱, “Wu̱ ro̱ ku̱s ku̱s.” ");
INSERT INTO uth_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Yan-Yoos-de u̱n karamsa-o Mosa ye̱ kergene̱ bo̱-o̱ o-Urusharima à, ye̱ ze̱e̱ru̱, “Ko-Gwo̱mo-wu̱ u̱n ya-u̱t-ko̱t daag wu̱ u̱r-hi. U̱n be̱e̱b-de u̱n ko-Gwo̱mo-wu̱ u̱n ya-u̱t-ko̱t o̱ wu̱ ro̱tte̱ u̱n ruut u̱n ya-u̱t-ko̱t.” ");
INSERT INTO uth_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Bo̱ Ye̱so ho̱gu̱te̱ ma-to̱ u̱n ye̱ à, wu̱ agnu̱ru̱ ye̱ be-de u̱n wu̱. Ka da-de ne̱, wu̱ citu̱ru̱ ye̱. Wu̱ ze̱e̱ru̱, “¿Re o̱ ne̱ ko-Gwo̱mo-wu̱ u̱n ya-u̱t-ko̱t he ruut u̱n hi u̱n de u̱n wu̱?” Bo̱ wu̱ citte̱ ye̱ kaane̱ à, wu̱ taknu̱ ye̱ m-yoose̱ u̱n sha-mo̱ u̱t-ma. ");
INSERT INTO uth_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Wu̱ ze̱e̱ru̱, “U̱rege̱ hun-ne̱ ye̱ u̱n o̱ ken dak-o̱ wongu̱te̱ ye̱ ro̱ u̱r-gu̱n kur-u̱t u̱t-kur u̱n hi u̱n de u̱n ye̱, cakru̱-mo̱ ka dak-o̱ hette̱. ");
INSERT INTO uth_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Kaane̱ o̱, hun-ne̱ ye̱ u̱n o̱ ken hur-o̱, ye̱ wonge̱ kur-u̱t u̱t-kur. Ye̱ ma'asu̱ru̱ m-dum u̱n hi u̱n de u̱n ye̱, caage̱-mo̱ ka, ka hur-o̱ hette̱. ");
INSERT INTO uth_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Gwo̱mo-to̱ u̱n ko-Gwo̱mo-wu̱ u̱n ya-u̱t-ko̱t komo, to̱ wonge̱ kur-u̱t u̱t-kur, to̱ ro̱ m-dum, jesse̱-mo̱, to̱ he'e̱. ");
INSERT INTO uth_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Yatt-wu̱ he m-co̱w u̱n hur-o̱ u̱n ko-be̱e̱b-wu̱ ku̱u̱ste̱ saw-to̱ u̱n wu̱ á, se̱ wu̱ shipste̱ wu̱ u̱r-takan. Wu̱ geks ka da-de ne̱, wu̱ cakarsu̱te̱ hur-o̱ u̱n wu̱. ");
INSERT INTO uth_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Nip-o̱ me̱ no̱ m-ru̱re̱, Shir a sokse̱ hun-ne̱ kap ba'as-to̱ ye̱ nome̱ wu̱ à, o-yo'og ne̱ o̱ ye̱ nome̱ wu̱ à, ");
INSERT INTO uth_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","amba wu̱ yo'oge̱ Ku̱kt-o̱ Shir à, a sokse̱ ka ne̱t-wu̱ ba'as-de u̱n wu̱ á. Ka ba'as-de dea she'et be-de u̱n wu̱ ko̱ o̱ ke da-o̱.” ");
INSERT INTO uth_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Ye̱so u̱n rwo̱r kaane̱, remen ye̱ ze̱e̱g, “Ko-Gwo̱mo-wu̱ u̱n ya-u̱t-ko̱t daag wu̱ u̱r-hi.” ");
INSERT INTO uth_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","32","Hun-ne̱ u̱t-mo̱o̱r ne̱ ro tara tara. Ye̱so ro n-te̱te̱ o̱ u̱n ye̱. Wu̱ ro ye̱ u̱t-ma, inu u̱n wu̱ wo̱o̱nu̱ru̱ u̱n hen-ne̱ ye̱ u̱n wu̱ ne̱. Ye̱ e̱su̱ru̱ n-do̱. Ye̱ to̱mu̱ru̱ wu̱ rwu̱u̱n wu̱ nom u̱t-ma u̱n ye̱ ne̱. Wu̱ ken wu̱ ze̱e̱ru̱ wu̱, “Inu ru wu̱ ka u̱n hen-ne̱ ru ne̱ n-do̱. Ye̱ ro̱ u̱n hoob-o ru.” ");
INSERT INTO uth_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Wu̱ shasu̱ru̱ ye̱, wu̱ ze̱e̱ru̱, “¿Wan wu̱ ne̱ ro̱ inu re u̱n hen-ne̱ re ne̱?” ");
INSERT INTO uth_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Wu̱ gu̱tru̱ru̱ hun-ne̱ ye̱ hwo̱ wu̱ n-te̱te̱ o̱ u̱n ye̱ à. Wu̱ ze̱e̱ru̱, “Inu re wu̱ ka u̱n hen-ne̱ re ne̱. ");
INSERT INTO uth_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Wu̱ no̱me̱ rii-yo Shir co̱ne̱ à, campo̱, ko̱ ne'a, wu̱ ro̱ heno re, wu̱ ro̱ komo inu re.” ");
INSERT INTO uth_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Ye̱so inu̱ru̱ eso, wu̱ ruuru̱ n-riib o̱ o-mar, komo wu̱ taknu̱ yoose̱ u̱n hun-ne̱. Ye̱ mo̱rgu̱ru̱ de̱e̱n be-de u̱n wu̱. Bo̱ ye̱ mo̱rge̱ de̱e̱n à, wu̱ co̱wu̱ru̱ o-hat wu̱ she'etu̱ru̱ n-me̱ u̱n o̱ n-te̱ o-mar. Hun-ne̱ ro̱ o-zang n-riib o̱ o-mar. ");
INSERT INTO uth_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Wu̱ yoosu̱ru̱ ye̱ u̱s-rem u̱t-mo̱o̱r ne̱ u̱n sha-mo̱ u̱t-ma. ");
INSERT INTO uth_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","Wu̱ ze̱e̱ru̱, “Raks no̱, no̱ ho̱gu̱te̱ ma-to̱ u̱m he no̱ m-ru̱re̱ à. Wu̱ ken ne̱t-wu̱ ruug o-pu̱p kap u̱n go̱. ");
INSERT INTO uth_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Wu̱ ro̱ u̱n kap u̱n go̱, ye̱ ken go̱-ye̱ he̱'e̱nu̱ru̱ n-riib n-co̱w. Ye̱ge̱-no haanu̱ru̱, ye̱ co̱ro̱gsu̱ru̱ ye̱. ");
INSERT INTO uth_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Ye̱ ken go̱-ye̱ he̱'e̱nu̱ru̱ be-de u̱t-ta'ar be-de u̱n ba m-hu de̱e̱n. Ba u̱n naas o-da, ye̱ po̱tu̱ru̱ remen dak-o ro̱tt u̱r-du̱w kane̱ á. ");
INSERT INTO uth_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Da-o̱ ho̱-u̱r dakne̱ à, ye̱ kaku̱ru̱, remen geer-se u̱n ye̱ co̱w n-dak á. ");
INSERT INTO uth_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Ye̱ ken go̱-ye̱ he̱'e̱nu̱ru̱ be-de yokor-u̱s ro̱ à. Ye̱ po̱tu̱ru̱, ye̱ bo̱'o̱su̱ru̱. Yokor-u̱s tu̱pnu̱ru̱, se me̱gu̱msu̱ru̱ ye̱, ye̱ ho̱ge̱ m-so̱k har ye̱ du̱kt u̱r-bon ne̱ á. ");
INSERT INTO uth_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Ye̱ ken go̱-ye̱ he̱'e̱nu̱ru̱ be-de u̱t-wu̱u̱r. Ye̱ po̱tu̱ru̱. Ye̱ bo̱'o̱su̱ru̱ u̱r-bon ne̱. Ye̱ duku̱ru̱. Ye̱ no̱mu̱ru̱ ya'ane. Ye̱ ken ye̱ u̱r-kwo̱o̱z u̱n o̱p 30. Ye̱ ken ye̱ kwo̱o̱z-u̱t tet 60 ko̱ kwo̱o̱z-u̱t taan 100.” ");
INSERT INTO uth_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Ka da-de, Ye̱so ze̱e̱ru̱ ye̱, “Kap wu̱ ro̱ u̱t-to̱ ne̱ to̱ m-ho̱ge̱ à, wu̱ ho̱ge̱.” ");
INSERT INTO uth_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Da-o ho̱r-o̱, Ye̱so ro u̱n ho̱n-de u̱n wu̱. Ka o̱p u̱n yoor-ye̱, yan-neke̱-mo̱ u̱n wu̱, u̱n ye̱ ken ye̱ ne̱, ye̱ haaru̱ be-de u̱n wu̱ ye̱ hwo̱o̱ru̱ wu̱ n-te̱te̱. Ye̱ citu̱ru̱ wu̱ yo ka sha-mo̱ u̱t-ma to̱ ro̱ à. ");
INSERT INTO uth_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Wu̱ ze̱e̱ru̱ ye̱, “No̱ ye̱ ya'ase̱ Shir hur-u̱r no̱ à, no̱ ye̱ Shir ya'e̱ no̱ nept ma-to̱ u̱n gwo̱mo-to̱ u̱n wu̱. Ye̱ ya'ase̱ Shir hur-de u̱n ye̱ á, ye̱ a m-yoose̱ u̱n sha-mo̱ u̱t-ma. ");
INSERT INTO uth_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Remen a shoosté̱ Ma-to̱ Shir: “ ‘Ye̱a hyen yo me̱ m-no̱m à amba ye̱a hoks m-nap u̱n yo̱ me̱ m-no̱m á. Ye̱a ho̱ge̱ yo me̱ m-ze̱e̱ à, amba ye̱a nep á; taasu̱ ye̱ waktu̱ne̱ be-de Shir a soksu̱te̱ ye̱ u̱t-ba'as.’ ” ");
INSERT INTO uth_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Ka da-de, Ye̱so ze̱e̱ru̱ ye̱, “U̱rege̱ no̱ nap ka sha-mo̱ u̱t-ma to̱ á, no̱a nep o̱ ka sha-mo̱ u̱t-ma to̱ kusse̱ á. ");
INSERT INTO uth_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Ka wan-kap u̱n go̱ wu̱, Ma-to̱ Shir to̱ wu̱ ro̱ m-kap. ");
INSERT INTO uth_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Ye̱ ka go̱-ye̱ ye̱ he̱'e̱ne̱ n-riib u̱n co̱w à, no co̱ro̱gsu̱ru̱ ye̱, sha-mo̱ u̱n ka hun-ne̱ ye̱ mo̱ ka, ye̱ a ru̱re̱ Ma-to̱ Shir à. Ye̱ ho̱gu̱sse̱, ba u̱n naas o-da, ko-Gwo̱mo-wu̱ u̱n ya-u̱t-ko̱t wo̱o̱nu̱ru̱, wu̱ deksu̱ru̱ to̱. ");
INSERT INTO uth_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Kaane̱ o̱ tomso, ka go̱-ye̱, ye̱ a kape̱ n-te̱ u̱t-ta'ar à, sha-mo̱ u̱n ka hun-ne̱ ye̱ mo̱ ka, ye̱ ho̱ge̱ Ma-to̱ Shir à. Ba u̱n naas o-da, ye̱ go̱ksu̱ru̱ to̱ o-zak o-zak. ");
INSERT INTO uth_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Amba ye̱ e̱ss to̱ u̱r-hur á. Bo̱ ye̱ she'ette̱ hiin à, ye̱ ho'osu̱ru̱ to̱. Yo ka u̱n ko̱r remen ko̱o̱b-u̱r bo̱k ye̱, komo hun-ne̱ suutu̱ ye̱ u̱s-cenene u̱nze ye̱ go̱kste̱ Ma-to̱ Shir, ye̱ hoks gaag u̱t-me̱n á. ");
INSERT INTO uth_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Ka go̱-ye̱, he̱'e̱ne̱ n-te̱ u̱n yokor à, ye̱ ro̱ ka ye̱ ho̱ge̱ Ma-to̱ Shir à. ");
INSERT INTO uth_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Amba hoob-o̱ u̱n rii-yo u̱n ho̱no o-dak yo rwo̱'u̱ru̱ ye̱ u̱n co. A ro̱ ye̱ m-raks u̱n go̱p-de u̱n hoob-o̱ o-kwu̱m. Komo u̱n go̱p-de u̱n se ken rem-se, se naasu̱ru̱ Ma-to̱ Shir u̱n hur-de u̱n ye̱. Remen kaane̱, se we̱nu̱ru̱ m-duk. ");
INSERT INTO uth_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ka go̱-ye̱, ye̱ a go̱'e̱ be-de u̱t-wu̱u̱r à, ye̱ ro̱ ka ye̱ ho̱ge̱ Ma-to̱ Shir à, har to̱ she'etu̱ru̱ u̱n hur-de u̱n ye̱, to̱ no̱mu̱ru̱ u̱r-bon be-de u̱n ye̱. U̱n hur-de u̱n wu̱ ken wu̱, ya wu̱ ro̱ u̱ntu̱n ka go̱-yo yo ro̱ m-kum u̱n ya'ane u̱r-kwo̱o̱z u̱n o̱p 30 à. U̱n hur-de u̱n wu̱ ken wu̱ komo yo ro̱ m-kum kwo̱o̱z-u̱t tet 60. U̱n hur-de u̱n wu̱ ken wu̱, yo ro̱ m-kum kwo̱o̱z-u̱t taan 100.” ");
INSERT INTO uth_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Ka da-de, Ye̱so citu̱ru̱ ye̱, “¿A u̱n daps u̱r-pitirra remen a ho̱kte̱ de o-shaar? ¿Ko̱ u̱n ku̱s-o̱ o-kwu̱u̱r? Ay, amba remen a sekt de n-to̱n be-de a he m-hyan à. ");
INSERT INTO uth_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Bo̱ u̱n rii-yo ro̱ wukusse̱ à, rwu̱u̱n-mo̱ yo he'e̱ cas cas. ");
INSERT INTO uth_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Kap wu̱ ro̱ u̱t-to̱ ne̱ to̱ m-ho̱ge̱ à, wu̱ ho̱ge̱.” ");
INSERT INTO uth_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Ye̱so dooru̱ ye̱ m-ru̱re̱ u̱t-ma. Wu̱ ze̱e̱ru̱, “Baks no̱ yo no̱ ho̱ge̱ à u̱r-bon ne̱. Ko̱k-de o mesu̱te̱ wu̱ ken wu̱ à de a hette̱ wo̱ m-me'esse̱, har a doo wo̱. ");
INSERT INTO uth_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Ko-wan-rii, wu̱ a m-do'e̱. Wu̱ ro̱tte̱ ne̱ á, ko̱ ya o-rii-yo yo wu̱ ro̱tte̱ hiin à, a rumus yo, a yage̱ wu̱ u̱t-kom m-zar.” ");
INSERT INTO uth_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Ye̱so dooru̱ ye̱ u̱n ru̱re̱ u̱t-ma. Wu̱ ze̱e̱ru̱, “Gwo̱mo-to̱ Shir ya to̱ ro̱ u̱ntu̱n ko-ya-to̱m wu̱ kape̱ go̱ u̱n kat-o̱ u̱n wu̱ à. ");
INSERT INTO uth_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","A rewu̱ru̱ u̱t-ho̱, go̱ po̱tu̱ru̱, ye̱ bo̱'o̱su̱ru̱, wu̱ nap bo̱ takne̱ á. ");
INSERT INTO uth_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","O-dak u̱n hi u̱n de u̱n o̱, o̱ ro̱ m-'ya rii-yo m-re̱. Po̱to̱n-mo̱ ro̱ u̱r-takan. Ye̱ po̱te̱, ye̱ duku̱ru̱. U̱jime̱ ye̱ no̱mu̱ru̱ ya'ane. ");
INSERT INTO uth_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Da-o̱ kat-o̱ nense̱, wu̱ to̱mu̱ru̱ ya-m-ce u̱n kunt-de m-ce ne̱ remen kat-o wooste̱ m-ce.” ");
INSERT INTO uth_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Ye̱so ze̱e̱ru̱ ye̱, “¿U̱n yaane̱ u̱m hette̱ m-hongse̱ Gwo̱mo-to̱ Shir? ¿Ya u̱n ma-to̱ ne̱ u̱m hette̱ m-rwu̱nte̱ u̱n sha-mo̱ u̱n to̱? ");
INSERT INTO uth_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Gwo̱mo-to̱ u̱n wu̱ to̱ ro̱ u̱ntu̱n ya'ane-yo o-mosta yo a go̱'e̱ n-dak à. Ko̱ de nomte̱ yo jiishte̱ ya'ane kap u̱s-re̱k à. ");
INSERT INTO uth_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Yo jiishu̱ru̱ kap o̱ u̱n gu̱go̱o̱g-o̱, a go̱'e̱ n-me̱ o-wak à. Yo no̱mu̱ru̱ caari-se u̱s-jet, har no ro̱ m-cire̱ u̱n se ye̱ ce u̱t-kur.” ");
INSERT INTO uth_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","U̱n sha-mo̱ u̱t-ma de̱e̱n go̱n to̱ ka, Ye̱so ru̱re̱ ye̱ Ma-to̱ Shir hond hond bo̱ ye̱ he hoks m-nap à. ");
INSERT INTO uth_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Wu̱ ru̱ru̱ ye̱ rii á, se̱ de̱ u̱n sha-mo̱ u̱t-ma ne̱. Amba pakse̱ o̱, wu̱ ro u̱n rwu̱nte̱ u̱n yan-neke̱-mo̱ u̱n wu̱ ko̱yan. ");
INSERT INTO uth_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Ka da-de ne̱ m-rim, Ye̱so ze̱e̱ru̱ yan-neke̱-mo̱ u̱n wu̱, “Haan a pes no̱ jit-de o-mar.” ");
INSERT INTO uth_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Yan-neke̱-mo̱ u̱n wu̱ ye̱ yagnu̱ru̱ hun-ne̱, u̱t-mo̱o̱r ne̱ ye̱ co̱wu̱ru̱ o-hat be-de Ye̱so ro à. Ye̱ neku̱ru̱. To̱ ken hat-to̱ ro kon tomso ne̱ u̱t-re̱k-to̱. ");
INSERT INTO uth_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Ye̱ ro m-neke̱, caari-mo̱ m-yo taknu̱ru̱. Ho̱-m ro m-tam o-hat. Mo̱ ro m-he̱'e̱be̱ n-me̱ har mo̱ u̱n he de m-shoos o-hat. ");
INSERT INTO uth_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Ye̱so ro m-rew n-me̱ o-hat so u̱r-tu̱r u̱n jim. Hi-de u̱n wu̱ ro ru̱sse̱ u̱n rii-o̱ atte̱ u̱n ru̱s u̱r-hi à. Ye̱ 'yonsu̱ru̱ wu̱. Ye̱ ze̱e̱ru̱ wu̱, “Wa-u̱r-Yoos, ashi! ¿Wo̱ was á? Te̱ ka he m-sabarse̱!” ");
INSERT INTO uth_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Ka da-de, wu̱ inu̱ru̱ m-rew, wu̱ huru̱ru̱ m-yo u̱t-gaag. Wu̱ ze̱e̱ru̱ o-mar, “Re̱s temb.” Yo-m re̱su̱ru̱ te̱k. Mar-o re̱su̱ru̱ temb. ");
INSERT INTO uth_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Wu̱ ze̱e̱ru̱ ye̱, “¿Yan yo hante̱ no̱tte̱ u̱n ho̱ge̱ o-gye̱r? ¿Har m-mo̱ka no̱ she̱r be-de Shir á?” ");
INSERT INTO uth_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ye̱ ho̱gu̱ru̱ o-gye̱r de̱e̱n. Ye̱ ze̱e̱ru̱ hi u̱n de u̱n ye̱, “Wuuu, ¿Ya u̱n go̱n ne̱t-wu̱ kaane̱ wu̱ yo-m ro̱ wu̱ o-do̱ro̱tte̱ m-ho̱ ne̱?” ");
INSERT INTO uth_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Ye̱so u̱n yan-neke̱-mo̱ u̱n wu̱ ne̱ pasu̱ru̱ de ka jit-de o-mar de, u̱n dak-o̱ o-Garasa. ");
INSERT INTO uth_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Da-o̱ Ye̱so ru'e̱ o-hat à, ba u̱n naas o-da, wu̱ ken ne̱t-wu̱ ro kon wu̱ ko-ya-u̱t-ko̱t da'e̱ u̱r-hi à. Wu̱ rwu̱u̱nu̱ru̱ be-de u̱s-saag, wu̱ go'onu̱te̱ u̱n Ye̱so ne̱. ");
INSERT INTO uth_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Wu̱ ro m-ma'as m-she'et u̱n pak-to̱ u̱t-ta'ar be-de a m-jo̱k u̱t-u à. Wu̱ ro m-gege̱ á ko̱ u̱t-kwo̱m. ");
INSERT INTO uth_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Ko̱ a gegu̱rse̱ na-se u̱n wu̱ u̱t-kom ne̱ u̱t-kwo̱m u̱t-kwo̱m, wu̱ jetemse̱ to̱ war war. Yatt-wu̱ ro wu̱ m-hoks m-gaag á. ");
INSERT INTO uth_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Ko̱ de ke da-de, m-te̱t m-ho̱w ne̱, wu̱ ro n-te̱ u̱n saag-se u̱n pak-to̱ u̱t-ta'ar, n-to̱n u̱t-haag. Wu̱ ma'asu̱ru̱ u̱s-kan kane̱. Wu̱ ro m-monomse̱ u̱n hi u̱n de u̱n wu̱ u̱t-ta'ar u̱t-ta'ar. ");
INSERT INTO uth_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Da-o̱ wu̱ hyambe̱ Ye̱so à, wu̱ kawu̱ru̱ Ye̱so o-rek. Wu̱ wo̱bu̱ru̱. Wu̱ kwu̱ktu̱ru̱ u̱n co Ye̱so. ");
INSERT INTO uth_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Wu̱ she̱rgu̱ru̱ u̱s-kan. Wu̱ ze̱e̱ru̱, “Ye̱so, Wà-wu̱ Shir, n-to̱n, ¿ya da wo̱ u̱n me̱ ne̱? Hakku̱re̱, u̱m mo̱ssu̱te̱ wo̱ u̱n Shir ne̱, wo̱ 'ya me̱ u̱r-ko̱o̱b á!” ");
INSERT INTO uth_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Wu̱ u̱n ze̱e̱ yo ka remen Ye̱so zeste̱ ko-ya-u̱t-ko̱t, “Ru no̱ u̱n hi-de u̱n ka ne̱t-wu̱.” ");
INSERT INTO uth_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Bo̱ ka ne̱t-wu̱ ko̱nte̱ Ye̱so à, Ye̱so citu̱ru̱ wu̱. Ye̱so ze̱e̱ru̱ wu̱, “¿Jin u̱n du ro̱ waane̱?” Wu̱ shasu̱ru̱ Ye̱so, “ ‘Timb,’ me̱ wu̱ u̱n ho̱n-de á, te̱ de̱e̱n.” ");
INSERT INTO uth_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Wu̱ ko̱nu̱ru̱ Ye̱so komo wu̱ ze̱e̱ru̱, “Ye̱so hakku̱re̱, taasu̱ o yen te̱ u̱n ka be-de.” ");
INSERT INTO uth_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","U̱n ka be-de ne̱, caari-o̱ u̱n kur-o̱ u̱n are̱de ro u̱t-re̱ n-to̱n u̱r-haag. ");
INSERT INTO uth_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Ya-u̱t-ko̱t ko̱nu̱ru̱ Ye̱so. Ye̱ ze̱e̱ru̱, “Ye̱so tu̱wu̱t te̱ be-de u̱n are̱de yage̱ te̱ cu̱wu̱t ye̱.” ");
INSERT INTO uth_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Ye̱so ya'u̱ru̱ ye̱ o-co̱w. Ya-u̱t-ko̱t ruuru̱ be-de u̱n ka ne̱t-wu̱, ye̱ co̱wu̱ru̱ u̱n hi-to̱ u̱n are̱de. Kur-o̱ u̱n are̱de dugu-u̱s yoor 2,000. Are̱de yirigbu̱ru̱ o-mar. Bo̱ ye̱ yirigbu̱te̱ à, ye̱ duuzbu̱ru̱ n-me̱ o-mar. Ho̱-m re̱e̱ru̱ ye̱ kap. ");
INSERT INTO uth_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Bo̱ yan-gu̱t-de u̱n are̱de hyente̱ rii-yo no̱me̱ à, ye̱ so̱mu̱ru̱ u̱s-rek, ha-mo̱ u̱n bo̱-o̱ ro̱ yow yow à. Ye̱ ru̱ndu̱ru̱ ya-o-bo̱ u̱n riib-se u̱n o̱ ne̱ ka ma-to̱. Hun-ne̱ rwu̱u̱nu̱ru̱, ye̱ hyenet rii-yo ko̱re̱ à. ");
INSERT INTO uth_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Ye̱ haanu̱ru̱ be-u̱r Ye̱so, ye̱ hyanu̱ru̱ wu̱ ya-u̱t-ko̱t ro daage̱ u̱r-hi à. Wu̱ ro tara u̱n gund-o̱ u̱n wu̱ ne̱ ho̱kke̱ u̱n we̱e̱r-se u̱n wu̱ ne̱. Ye̱ ho̱gu̱ru̱ o-gye̱r. Ye̱ hyanag u̱t-hyat. ");
INSERT INTO uth_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Komo ye̱ hyane̱ rii-yo ko̱re̱ ka ne̱t-wu̱ ya-u̱t-ko̱t da'e̱ u̱r-hi à, u̱n ka are̱de̱-ye̱ ne̱ u̱n yish-ye̱ u̱n ye̱ à, ye̱ ru̱ru̱ hun-ne̱ ye̱ rwu̱u̱ne̱ so̱ o-bo̱ à rii-yo ko̱re̱ à. ");
INSERT INTO uth_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Ye̱ taknu̱ ko̱n-u̱s Ye̱so wu̱ yaksu̱ ye̱ dak-o̱ u̱n ye̱. ");
INSERT INTO uth_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Ye̱so ro m-co̱w o-hat wu̱ yagu̱te̱ ka dak-o̱ o̱ ka. Ka ne̱t-wu̱ ne̱ wu̱ ya-u̱t-ko̱t ro daage̱ u̱r-hi à ko̱nu̱ru̱ Ye̱so 'ye wu̱ o-co̱w wu̱ do̱ru̱té̱ wu̱. ");
INSERT INTO uth_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Amba Ye̱so de̱k ma-to̱ u̱n wu̱ á. Ye̱so ze̱e̱ru̱, “Ji o-hur be-u̱r yan-yen-du du. O ru̱re̱ ye̱ rem-se Wan-Ko̱yan nomu̱ wo̱ à, u̱n bo̱ wu̱ hyane̱ 'wo̱n u̱n du à.” ");
INSERT INTO uth_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Ká ne̱t-wu̱ argu̱ru̱ m-neke̱. Wu̱ taknu̱ rwo̱r u̱n ka ma-to̱ u̱n ka dak-o̱ o̱ a m-ze̱e̱ Bo̱-u̱t O̱p à. Wu̱ ro m-rwo̱r u̱n ka rem-se u̱t-mo̱o̱r ne̱ se Ye̱so nomu̱ wu̱ à. Hun-ne̱ kap ye̱ bo̱pu̱ru̱ u̱s-nu remen ye̱ ho̱gu̱te̱ rii-yo u̱t-hyat. ");
INSERT INTO uth_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Komo Ye̱so co̱wu̱ru̱ o-hat wu̱ dooru̱ m-pas u̱n jit-de o-mar. Bo̱ wu̱ wo̱o̱bu̱te̱ à, hun-ne̱ de̱e̱n mo̱rgu̱ru̱ be-de u̱n wu̱ n-riib o-mar. ");
INSERT INTO uth_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Wu̱ ken ne̱t-wu̱ haanu̱ru̱, jin-de u̱n wu̱ Jaros. Wan-gaan be-de u̱n yan-co ye̱ u̱n kuke̱-o̱ atte̱ u̱n yoos u̱n Ma-to̱ Shir à. Bo̱ wu̱ hyente̱ Ye̱so à, wu̱ kwu̱ktu̱ru̱ u̱n co-o̱ u̱n wu̱. ");
INSERT INTO uth_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Wu̱ gapu̱rsu̱ru̱ Ye̱so, wu̱ ze̱e̱ru̱, “Ye̱so, me̱ ka haane̱ be u̱n du. Wà re wan-ne'a-wu̱ ro̱ u̱n kom-to̱ Shir. U̱m co̱no̱g o he, o ci wu̱ u̱n kom-u̱t ru ko̱ ka go̱m-o̱ ro̱ m-ta à, wu̱ nom ho̱o̱g.” ");
INSERT INTO uth_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Ye̱so argu̱ru̱ wu̱ m-do̱re̱. Ye̱ argu̱ru̱ m-neke̱. Hun-ne̱ de̱e̱n do̱ru̱ru̱ Ye̱so. Ye̱ ro wu̱ m-me̱gemse̱. ");
INSERT INTO uth_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Wu̱ ken ne'a-wu̱ ro kon wu̱ go̱m bo̱pe̱ à, hak-u̱s o̱p u̱s-yoor 12 hyó-m ro m-du u̱n wu̱r-o̱ u̱n wu̱. ");
INSERT INTO uth_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Wu̱ swo̱o̱g u̱r-ko̱o̱b de̱e̱n u̱n kom-to̱ u̱n ya-u̱s-ba'at u̱t-mo̱o̱r ne̱. Bo̱ u̱n rem-se wu̱ rotte̱ u̱n kom-to̱ u̱n wu̱ à, kap o̱ u̱n se se teeste̱ u̱n hoob-o̱ u̱s-baat remen go̱m-o̱ u̱n wu̱ teet. Go̱m ro wu̱ m-mu̱u̱n n-hwu̱k n-hwu̱k. ");
INSERT INTO uth_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Wu̱ ho̱gu̱su̱te̱ Ye̱so ro u̱n taas u̱s-go̱m. Wu̱ pa'anu̱ru̱ so̱ u̱n jim-de u̱n wu̱ n-me̱ u̱n mo̱o̱r-to̱ u̱n hun-ne̱ wu̱ ci'it gund-o Ye̱so. ");
INSERT INTO uth_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Wu̱ ze̱e̱ru̱ u̱n hur-de u̱n wu̱, “Ko̱ bo̱ u̱n gund-o Ye̱so o̱ de̱ u̱m ci'e̱, o̱ bo̱'o̱su̱te̱ go̱m re teet.” ");
INSERT INTO uth_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Bo̱ wu̱ ci'ite̱ gund-o Ye̱so à, hyó-mo̱ u̱n wu̱ argu̱ru̱ m-ka ba u̱n rem. Wu̱ ho̱gu̱ru̱ u̱n wu̱r-o̱ u̱n wu̱ go̱m taag. ");
INSERT INTO uth_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Ba u̱n naas o-da, Ye̱so napu̱ru̱ Shir ruutte̱ se ken myot-se u̱n wu̱r-o̱ u̱n wu̱, wu̱ napu̱ru̱ u̱nze wu̱ ken ci'ig wu̱. Wu̱ byandu̱ru̱ n-me̱ u̱n mo̱o̱r-to̱ u̱n hun-ne̱ wu̱ nept wu̱ ci'e̱ wu̱ à. Wu̱ ze̱e̱ru̱, “¿Wan wu̱ ne̱ ci'e̱ me̱ o-gund?” ");
INSERT INTO uth_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Yan-neke̱-mo̱ u̱n wu̱ ze̱e̱ru̱ wu̱, “Gwo̱t ka mo̱o̱r-to̱ u̱n hun-ne̱ to̱. ¿Wa nep ne̱t-wu̱ ci'e̱ gund-o ru?” ");
INSERT INTO uth_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Ka da-de, wu̱ gu̱tru̱ru̱ remen wu̱ hyenet wu̱ no̱me̱ kaane̱ à. ");
INSERT INTO uth_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Ne'a tomso, bo̱ wu̱ nepte̱ rii-yo takne̱ u̱n wu̱ ne̱ à, wu̱ haanu̱ru̱ gye̱r-o-gye̱r. Wu̱ ro u̱s-zap. Wu̱ kwu̱ktu̱ru̱ u̱n co Ye̱so, wu̱ ru̱ru̱ wu̱ bo̱ u̱n rii-yo takne̱ à. ");
INSERT INTO uth_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Ye̱so ze̱e̱ru̱ wu̱, “Wà re, wan-ne'a bo̱ o she̱rte̱ u̱n me̱ ne̱ à, go̱m ru taag. Ji o-hur, hur-u̱r gaan. O̱a do m-mu̱u̱n á.” ");
INSERT INTO uth_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Wu̱ ro u̱t-ma, ye̱ ken ye̱ rwu̱u̱nu̱ru̱ u̱n hur-o̱ u̱n wan-co-wu̱ u̱n kuke̱-o̱ atte̱ u̱n yoos u̱n Ma-to̱ Shir à. Ye̱ ze̱e̱ru̱ ka wan-co-wu̱, “¿Yan yo wo̱tte̱ u̱n rangse̱ u̱n Wa-u̱r-Yoos? Wà ru wan-ne'a mereste̱.” ");
INSERT INTO uth_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Ko̱ de̱ ye̱ zette̱ kaane̱, u̱nze wà wan-ne'a mereste̱ à, Ye̱so was u̱n to̱ ne̱ á. Wu̱ ze̱e̱ru̱ wan-co, “Yage̱ o-gye̱r. She̱r hur-u̱r gaan cot.” ");
INSERT INTO uth_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Bo̱ Ye̱so ru̱ru̱tu̱ wu̱ kaane̱ à, ye̱ argu̱ru̱ m-neke̱ u̱n ka ne̱t-wu̱ ne̱, amba Ye̱so de̱k hun-ne̱ á, se̱ Bitrus, u̱n Yakubu, u̱n Yohana (heno Yakubu) ne̱. ");
INSERT INTO uth_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Bo̱ ye̱ woote̱ u̱n hur-o Jaros à (wan-co u̱n kuke̱-o̱ u̱n yoos u̱n Ma-to̱ Shir à), Ye̱so 'wo̱ssu̱ru̱ hun-ne̱ kane̱ de̱e̱n. Ye̱ ro u̱s-'wo̱n. ");
INSERT INTO uth_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Bo̱ wu̱ tu̱wte̱ à, wu̱ ze̱e̱ru̱ ye̱, “¿Remen yan o̱ no̱tte̱ u̱s-'wo̱n? Ay, wan-ne'a-wu̱ mar á. Rew-mo̱ wu̱ ro̱tte̱.” ");
INSERT INTO uth_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Ye̱ nemsu̱ru̱ wu̱ nemes-to̱ o-yo'og. Wu̱ ruutu̱ru̱ bo̱ u̱n ye̱ ro kane̱ kap à n-do̱. Wu̱ de̱ku̱ru̱ bo̱ u̱n tato-o̱ u̱n wan-ne'a u̱n inu u̱n wan-ne'a ne̱ u̱n ye̱ ka ne̱n tet ye̱ ne̱ ye̱ wu̱ rotte̱ m-neke̱ u̱n ye̱ ne̱ à. Ye̱ co̱wu̱ru̱ be-de u̱r-u. ");
INSERT INTO uth_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Ye̱so bo̱pu̱ru̱ kom-o̱ u̱n ka wan-ne'a-wu̱. Wu̱ ze̱e̱ru̱ wan-ne'a, “Tarita kumi!” (Wata, “Wan-ne'a, u̱m ze̱e̱g, ine̱ ge̱!”) ");
INSERT INTO uth_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Ba u̱n naas o-da, wan-ne'a inu̱ru̱ ge̱. Wu̱ yawgu̱ru̱ u̱n na-se u̱n wu̱. Hak-se u̱n ka wan-ne'a-wu̱ o̱p u̱s-yoor 12. Ko̱wan bo̱pu̱ o-nu. Rem-se u̱t-hyat se ka ye̱ hyane̱. ");
INSERT INTO uth_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Ye̱so kangsu̱ru̱ ye̱. Wu̱ ze̱e̱ru̱, “No̱ jar no̱ ru̱re̱ ne̱t á, amba 'ya no̱ wan-ne'a rii-yo m-re̱.” ");
INSERT INTO uth_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Ye̱so inu̱ru̱ u̱n ka bo̱-o̱, wu̱ wargu̱ru̱ u̱n bo̱-o̱ u̱n wu̱ o-Nazaret. Yan-neke̱-mo̱ u̱n wu̱ neku̱ru̱ u̱n wu̱ ne̱. ");
INSERT INTO uth_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Bo̱ Ho̱-de u̱r-Wu̱we̱ wo̱o̱nte̱ à, wu̱ taknu̱ yoose̱ u̱n hun-ne̱ u̱n kuke̱-o̱ u̱n yoos u̱n Ma-to̱ Shir. Hun-ne̱ mo̱rgu̱ru̱ de̱e̱n. Bo̱ ye̱ ho̱gu̱te̱ wu̱ à, ye̱ bo̱pu̱ru̱ u̱s-nu. Ye̱ ze̱e̱ru̱, “Ka ne̱t-wu̱ ne̱, ¿ke ne̱ o̱ wu̱ kume̱ ka nap-se kaane̱? Gwo̱t go̱n caari-to̱ u̱t-hyat to̱ wu̱ ro̱ m-no̱m à! ");
INSERT INTO uth_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Ashi, ¿wu̱ wu̱ ka wan-shaab? ¿Wà Meri, se̱k-wu̱ Yakubu ne̱ u̱n Yosi ne̱, Yahudas ne̱, Simo̱n ne̱? Hen-ne̱ ye̱ u̱n wu̱ ne̱, yan-ne'a-ne̱ ye̱ ro̱ ko̱n kane̱ be u̱n na.” Ka da-de ne̱, ye̱ kutu̱ru̱ Ye̱so u̱t-yage̱. ");
INSERT INTO uth_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Ka da-de, Ye̱so ze̱e̱ru̱ ye̱, “Ko̱ kene̱ a m-bo̱m u̱n wan-rwo̱r u̱n Ma-to̱ Shir, amba yan-bo̱-o̱ u̱n wu̱, be-de a mate̱ wu̱ à, ko̱ wu̱ ro̱ u̱n rwo̱r u̱n Ma-to̱ Shir, ye̱ ro̱ m-was u̱n to̱ ne̱ har ye̱ bu̱pt to̱ á.” ");
INSERT INTO uth_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Ye̱so wu̱ hoks no̱m u̱t-hyat kane̱ á, se̱ de̱ ya-u̱s-go̱m hiin ye̱ wu̱ ci'e̱ u̱n kom-to̱ u̱n wu̱ à, go̱m-u̱s taaru̱ ye̱. ");
INSERT INTO uth_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Wu̱ bo̱pu̱ru̱ nu. Wu̱ hyanag hyat-to̱ u̱n yan-bo̱-o̱ u̱n wu̱ remen ko̱o̱b-de u̱n m-she̱r be-de u̱n wu̱. Wu̱ do̱rgu̱ru̱ u̱t-bo̱ to̱ ro̱ o-zang à. Wu̱ masu̱ru̱ u̱n yoose̱ u̱n hun-ne̱ Ma-to̱ Shir. ");
INSERT INTO uth_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Wu̱ agnu̱ru̱ yan-neke̱-mo̱ u̱n wu̱ ne̱n o̱p u̱n yoor 12 be-u̱r gaan. Wu̱ taknu̱ to̱m-se u̱n ye̱ yoor yoor, ye̱ yoose̱ hun-ne̱ Ma-to̱ Shir. Wu̱ ya'u̱ru̱ ye̱ 'wo̱ns-mo̱ u̱n ruut u̱n ya-u̱t-ko̱t ye̱ da'e̱ u̱n hi-to̱ u̱n hun-ne̱ à. ");
INSERT INTO uth_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Wu̱ naku̱ru̱ ye̱ u̱t-to̱, wu̱ ze̱e̱ru̱ ye̱, “No̱ ine̱ m-neke̱, no̱ jar no̱ dek rii á, se̱ ko̱-yo m-neke̱, no̱ he m-de̱k. No̱ de̱k rii-yo m-re̱ á. No̱ de̱k ba-o̱ u̱r-e̱ss á. No̱ de̱k hwo̱r á. ");
INSERT INTO uth_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","No̱ ine̱ m-neke̱, no̱ tu̱p u̱t-ka'ante̱. No̱ de̱k co̱p-u̱t yoor á se̱ to̱ ro̱ u̱n wu̱r-u̱t no̱ à cot.” ");
INSERT INTO uth_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Wu̱ dooru̱ ye̱ m-ru̱re̱ u̱t-ma. Wu̱ ze̱e̱ru̱, “No̱ kume̱ hur-o̱ no̱ comsu̱te̱ à, she'et no̱ kane̱ har no̱ ruut u̱n ka bo̱-o̱. ");
INSERT INTO uth_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","No̱ wo'e̱ be-de a yage̱ no̱ m-go̱ks à, ko̱ m-raag u̱n ma-u̱t no̱ ne̱ à. Da-o̱ no̱ ine̱ m-arag u̱n ka be-de, kukt no̱ hu-mo̱ u̱n na-u̱s no̱. No̱ hu̱ste̱ kom-u̱t no̱ o̱ ka ho̱-de Shir he ye̱ piishe̱ u̱t-ma à.” ");
INSERT INTO uth_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Bo̱ wu̱ komte̱ ye̱ m-ru̱re̱ u̱n ka ma-to̱ à, ye̱ ruuru̱, ye̱ ru̱ru̱ hun-ne̱. Ye̱ ro m-ze̱e̱, “Ho'os no̱ ba'as-u̱t no̱, no̱ mu̱u̱n, no̱ kon Shir. Wu̱a soks ba'as-u̱t no̱.” ");
INSERT INTO uth_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Ye̱ ruutu̱ru̱ ya-u̱t-ko̱t de̱e̱n ye̱ da'e̱ hi-to̱ u̱n hun-ne̱ à. Bo̱ ye̱ 'wo̱ste̱ ya-u̱s-go̱m de̱e̱n à, ye̱ duusu̱ru̱ ye̱ m-no̱w. Ye̱ ko̱nu̱ru̱ Shir. Go̱m-u̱s taaru̱ ye̱. ");
INSERT INTO uth_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Ye̱so ruug u̱r-jin ko̱ kene̱ har ko-Gwo̱mo Here̱ Atipas ho̱gu̱ru̱ ma-to̱ u̱n wu̱. Hun-ne̱ kap ye̱ ma'asu̱ru̱ u̱s-barag. Ye̱ ro m-ze̱e̱, “¿Wan wu̱ ne̱ ro̱ u̱n no̱m u̱n ka hyat-to̱ kaane̱?” Ye̱ ken ye̱ ze̱e̱ru̱ “Yohana wu̱. Wu̱ ro'e̱ u̱n m-yo'os u̱n hun-ne̱ n-te̱ m-ho̱ à. Wu̱ wu̱ Shir 'yonse̱ be-de m-margan ne̱. Wu̱ wu̱ a ya'ase̱ ka be̱e̱b-de.” ");
INSERT INTO uth_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Ye̱ ken ye̱ ze̱e̱ru̱, “Ay, E̱reja wu̱.” Ye̱ ken ye̱ ze̱e̱ru̱, “Ay, wan-rwo̱r u̱n Ma-to̱ Shir wu̱ u̱ntu̱n ka ye̱ haane̱ n-ga à.” ");
INSERT INTO uth_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Bo̱ Here̱ ho̱gu̱te̱ ma-u̱t Ye̱so à, wu̱ ze̱e̱ru̱, “Yohana wu̱ u̱m rwo̱'e̱ a kups hi-de u̱n wu̱ à, wu̱ ine̱ u̱n ho̱o̱g ne̱!” ");
INSERT INTO uth_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Here̱ u̱n ze̱e̱ kááne̱ remen se ken hak-se n-ga ne̱, wu̱ u̱n hi u̱n de u̱n wu̱, wu̱ rwo̱'o̱g a ship Yohana. A rwo̱'u̱ru̱ wu̱ u̱n kuke̱-o̱ m-ke'et. Wu̱ u̱n no̱m kaane̱ remen wu̱ gaag ne'a hen u̱n wu̱, Herodiya cin ba campo̱ u̱n wu̱ u̱n mar. Jin-u̱r campo̱ u̱n wu̱ ro Pirip. ");
INSERT INTO uth_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Here̱ u̱n no̱m kaane̱ remen Yohana ma'aste̱ wu̱ m-ru̱re̱ u̱nze, u̱depe̱ wu̱ ge ne'a hen u̱n wu̱ á. ");
INSERT INTO uth_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Ne'a su̱u̱ru̱ Yohana u̱s-ryaab har wu̱ co̱no̱g wu̱ ho wu̱. Amba Herodiya kum u̱r-be á. ");
INSERT INTO uth_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Ko-Gwo̱mo Here̱ ro̱ u̱n gye̱r-o Yohana. Wu̱ nak wu̱ kashi u̱n ne̱t-wu̱, wan-ba-m-ku̱ko̱p. Remen kaane̱, wu̱ e̱ssu̱ru̱ wu̱ be-de rii a ci wu̱ á. Wu̱ ro m-zo̱'o̱re̱ de̱e̱n da-o̱ Yohana ro u̱t-ma u̱n wu̱ ne̱. Amba kap u̱n kaane̱ ne̱, wu̱ ro̱ u̱n ho̱ge̱ u̱n re̱re̱m-mo̱ u̱n ma-to̱ u̱n wu̱. ");
INSERT INTO uth_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Amba de ken ho̱-de, Herodiya kumu̱ru̱ caari-de u̱r-ho̱. Ka ho̱-de, ko-Gwo̱mo Here̱ ro u̱n baks u̱n ho̱-de a mate̱ wu̱ à. Wu̱ no̱mu̱ru̱ o-biki. Wu̱ banu̱ru̱ gwo̱mo-ne̱ ye̱ u̱n wu̱, u̱n se̱k-ye̱ ne̱ ye̱ u̱n karma-ne̱ u̱n se̱k-ye̱ ne̱ ye̱ u̱n dak-o̱ o-Gariri. ");
INSERT INTO uth_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Bo̱ ye̱ mo̱rgu̱te̱ u̱n biki-o̱ u̱n wu̱ à, wà Herodiya wan-ne'a, wu̱ co̱wu̱ru̱ be-de u̱n ye̱. Wu̱ he̱wu̱ru̱ u̱s-he̱w. Zak-o re̱e̱ru̱ ka ya-o-biki ye̱ de̱e̱n, kap u̱n ko-Gwo̱mo Here̱ ne̱. Ko-Gwo̱mo haku̱ru̱ o-nu, wu̱ ze̱e̱ru̱ ká wan-ne'a-wu̱ “Kay, ko̱n me̱ rii-yo o co̱ne̱ à, kap man ya'as wo̱ yo.” ");
INSERT INTO uth_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Wu̱ to̱ndu̱ru̱ ka wan-ne'a-wu̱. Wu̱ ze̱e̱ru̱, “Ko̱yan yo o ko̱ne̱ be u̱n de, har pu̱ru̱g-de u̱n gwo̱mo-u̱t re, man hoks wo̱ m-ya'as.” ");
INSERT INTO uth_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Bo̱ wan-ne'a ho̱gu̱te̱ kaane̱ à, wu̱ ruuru̱, wu̱ haaru̱ be-u̱r inu u̱n wu̱. Wu̱ ze̱e̱ru̱ wu̱, “Ho̱ge̱ ma-to̱ ko-Gwo̱mo zee à, wu̱ zee ko̱yan yo u̱m ko̱ne̱ wu̱, wu̱a ya'as me̱. ¿Yan yo ne̱ u̱m he wu̱ m-ko̱n?” Inu u̱n wu̱ ze̱e̱ru̱ wu̱, “Ha o kon wu̱ hi-u̱r Yohana Wa-m-Yo'os u̱n hun-ne̱ m-ho̱.” ");
INSERT INTO uth_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","To̱, wu̱ mu̱u̱nu̱ru̱, ho̱r-m-ho̱r be-de u̱n ko-Gwo̱mo. Wu̱ ko̱nu̱ru̱ wu̱, wu̱ ze̱e̱ru̱, “Hi-u̱r Yohana Wa-m-Yo'os de u̱m co̱ne̱ o hu̱u̱ me̱ m-mo̱ka n-me̱ o-ko̱k.” ");
INSERT INTO uth_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Bo̱ ko-Gwo̱mo ho̱gu̱te̱ kaane̱ à, me̱n-u̱t naasu̱ru̱ wu̱ de̱e̱n remen wu̱ regu̱su̱te̱ wu̱ to̱ndsu̱te̱ be-de u̱n ya-o-biki. Wu̱ co̱n wu̱ yage̱ shoos u̱n ma-to̱ u̱n wu̱ á. ");
INSERT INTO uth_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Remen kaane̱, ba u̱n naas o-da, wu̱ to̱mu̱ru̱ ko-karma. Wu̱ ze̱e̱ru̱, “Ha o kupsu̱nu̱ me̱ hi-u̱r Yohana.” Wu̱ argu̱ru̱ m-neke̱ be-de Yohana ro ke'o à, wu̱ kupsu̱ru̱ hi-de u̱n wu̱. ");
INSERT INTO uth_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Wu̱ neknu̱ru̱ u̱n de ne̱ n-me̱ o-ko̱k. Wu̱ ya'asu̱ru̱ ka wan-ne'a-wu̱. Wan-ne'a ya'asu̱ru̱ inu u̱n wu̱. ");
INSERT INTO uth_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Da-o̱ yan-neke̱-m Yohana ho̱ge̱ bo̱ a no̱me̱ à, ye̱ haaru̱, ye̱ de̱ku̱ru̱ u-de u̱n wu̱, ye̱ jo̱ku̱ru̱. ");
INSERT INTO uth_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Yan-To̱m Ye̱so, ye̱ wu̱ to̱me̱ ye̱ ru̱r Ma-to̱ Shir à, ye̱ mu̱u̱nu̱ru̱, ye̱ mo̱rgu̱ru̱ be-u̱r Ye̱so. Ye̱ ru̱ru̱ wu̱ kap rii-yo ye̱ no̱me̱ à u̱n rii-yo ye̱ yoos ne̱ à. ");
INSERT INTO uth_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","To̱, ye̱ ro wu̱ m-ru̱re̱, hun-ne̱ doro ye̱, ye̱ ma'asu̱ru̱ m-haan be-de u̱n wu̱ ye̱ ho̱gu̱té̱ ma-u̱t Ye̱so. Ye̱ ka ro̱ m-nekne̱, ye̱ ka ro m-arag, har Ye̱so kum da-o̱ u̱n re̱ u̱n rii-yo m-re̱ á. Wu̱ ze̱e̱ru̱ yan-neke̱-mo̱ u̱n wu̱, “Haan no̱, a paks no̱, a wu̱we̱ no̱ hiin.” ");
INSERT INTO uth_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Ye̱ co̱wu̱ru̱ o-hat, ye̱ ro m-neke̱ be-de u̱n ba u̱n ne̱t u̱n ho̱n-de u̱n ye̱. ");
INSERT INTO uth_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Ashi, hun-ne̱ de̱e̱n hyanag neke̱-mo̱ u̱n ye̱. Ye̱ nepste̱ u̱n ye̱ ne̱. Ye̱ rwu̱u̱nu̱ru̱ u̱n ko̱ o̱ ke bo̱-o̱. Ye̱ argu̱ru̱ teeru̱ u̱s-rek. Ye̱ ro̱ u̱n do̱re̱ n-riib o̱ o-mar. Ye̱ ba'u̱ru̱ Ye̱so ne̱ m-wo̱ re̱e̱no̱ be-de ye̱ he'e̱ à. ");
INSERT INTO uth_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Ye̱so wo̱bu̱ru̱. Bo̱ wu̱ rwu̱u̱nte̱ o-hat à, wu̱ 'wo̱ssu̱ru̱ hun-ne̱ u̱t-mo̱o̱r ne̱ de̱e̱n ye̱ be'este̱ wu̱ m-wo̱. To̱, wu̱ hyanu̱ru̱ ye̱. Ye̱ ka u̱ntu̱n ye̱ge̱-ca. Ye̱ rotte̱ ko-ya-u̱r-gu̱t á. Wu̱ ho̱gu̱ru̱ 'wo̱n-de u̱n ye̱. Wu̱ taknu̱ yoose̱ u̱n ye̱ se ken rem-se de̱e̱n. ");
INSERT INTO uth_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","To̱, da-o̱ wu̱ ro ye̱ m-yoose̱ à, yan-neke̱-mo̱ u̱n wu̱ hyanu̱ru̱ ho̱-u̱r teeste̱. Ye̱ haaru̱ be-u̱r Ye̱so. Ye̱ ze̱e̱ru̱, “Ho̱-u̱r teeste̱. Hur-u̱t ro̱ ko̱n kane̱ yow yow á. ");
INSERT INTO uth_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Se̱ o 'yons ye̱ kaane̱ ye̱ tu̱wu̱t yan-bo̱-u̱t kat-ne̱ to̱ ro̱ kane̱ à, ye̱ oonu̱té̱ hi u̱n de u̱n ye̱ rii-yo m-re̱.” ");
INSERT INTO uth_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Amba Ye̱so haku̱ru̱ o-nu, wu̱ ze̱e̱ru̱ ye̱, “Ya no̱ ye̱ rii-yo m-re̱ u̱n hi u̱n no̱.” Ye̱ ze̱e̱ru̱ Ye̱so, “Ho̱n u̱n ka mo̱o̱r-to̱ u̱n hun-ne̱ to̱, ¿ke ne̱ o̱ te̱ he kum u̱n hwo̱r-ye̱ te̱ hette̱ ye̱ m-coks à? ¿Wa ya'e̱ te̱ ka rii-yo kaane̱? Se̱ de̱ te̱ nome̱ gu̱wu̱s-de u̱t-ho̱ zungu-u̱s yoor te̱ hokstu̱ ye̱ m-re̱e̱gte̱.” ");
INSERT INTO uth_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Ye̱so citu̱ru̱ ye̱, “¿Buro̱di-u̱t re to̱ ro̱ no̱? Ha no̱ no̱ gwo̱to̱n.” Bo̱ ye̱ heete̱ m-gwo̱t à ye̱ mu̱u̱nu̱ru̱. Ye̱ ze̱e̱ru̱ wu̱, “Buro̱di-u̱t taan u̱n jan ne̱ yoor te̱ hyane̱.” ");
INSERT INTO uth_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Bo̱ wu̱ ho̱gu̱te̱ shas-o̱ u̱n ye̱ à, wu̱ ze̱e̱ru̱ hun-ne̱ kap, “She'et no̱ be-de u̱n gwo̱-u̱t yar-to̱ kur-u̱t u̱t-kur.” ");
INSERT INTO uth_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Ye̱ ne̱ ye̱ she'etu̱ru̱ kur-u̱t u̱t-kur. To̱ ken kur-to̱ ne̱ zungu-o gaan 100, to̱ ken kur-to̱ kwo̱o̱z-u̱t yoor u̱n o̱p 50. ");
INSERT INTO uth_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Bo̱ ye̱ she'ette̱ à, Ye̱so jaksu̱ru̱ yish-ye̱ u̱n wu̱ n-To̱n o̱ shir, wu̱ nomu̱ru̱ Shir u̱r-bo̱ngo̱n. Bo̱ wu̱ komte̱ Shir nome̱ u̱r-bo̱ngo̱n à, ka da-de ne̱, wu̱ bosru̱ru̱ ka buro̱di-to̱ bos-u̱t u̱t-bos. Ka bos-to̱ wu̱ bosre̱ à, wu̱ wongu̱ru̱ yan-neke̱-mo̱ u̱n wu̱ u̱n ka jan-ye̱ ne̱ yoor. Ye̱ heetu̱ru̱ ka hun-ne̱ ye̱ kap. ");
INSERT INTO uth_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ho̱n u̱n mo̱o̱r-to̱ u̱n ye̱ kap ye̱ re̱e̱ru̱ to̱, ye̱ ciig har to̱ kus, ");
INSERT INTO uth_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","har ye̱ kamsu̱ru̱ to̱ kusse̱ à ko̱o̱r-u̱t o̱p u̱t-yoor 12. ");
INSERT INTO uth_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Be-de u̱n ka ye̱ re̱ à campo̱-ne̱ dugu-u̱s taan 5,000. ");
INSERT INTO uth_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Bo̱ Ye̱so komte̱ re̱e̱gte̱ u̱n hun-ne̱ à, ba u̱n naas o-da, wu̱ ze̱e̱ru̱ yan-neke̱-mo̱ u̱n wu̱ ye̱ tu̱w o-hat ye̱ neke̱, ye̱ pes o-mar, ye̱ wo u̱n o̱ ken bo̱-o̱ o̱ a m-ze̱e̱ o-Besayada. Wu̱ komo wu̱ 'yonsu̱te̱ ka hun-ne̱ ye̱. ");
INSERT INTO uth_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Bo̱ wu̱ 'yonste̱ hun-ne̱ à, wu̱ daaru̱ u̱r-haag remen wu̱ konot Shir. ");
INSERT INTO uth_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Bo̱ te̱t-m wo̱o̱nte̱ à, yan-neke̱-mo̱ u̱n wu̱ ro o-hat n-te̱te̱ o̱ o-mar. Ye̱so ne̱ wu̱ ro kane̱ o-zang u̱n ho̱n-de u̱n wu̱. ");
INSERT INTO uth_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Wu̱ hyambu̱ru̱ yan-neke̱-mo̱ u̱n wu̱ ro dum-o m-nak o-hat. Hat-o yagu̱te̱ m-neke̱ remen yo-m ro o̱ m-mu̱u̱nte̱ u̱s-ajima ne̱. Ka da-de ne̱, cin ba ho̱-u̱r ro̱ u̱n rwu̱u̱n, wu̱ kawu̱ru̱ ye̱. Wu̱ ro m-yawag n-to̱n m-ho̱ u̱s-na u̱s-na. Wu̱ woot be-de u̱n ye̱. ");
INSERT INTO uth_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Amba bo̱ ye̱ hyambu̱te̱ wu̱ ro̱o̱n à, wu̱ ro m-yawgu̱ne̱ n-to̱n m-ho̱ mo̱ o-mar, ye̱ no̱mu̱ru̱ u̱s-barag. Ye̱ ze̱e̱ru̱, “¿Ko̱ ko-marimar-wu̱?” Ye̱ taknu̱ru̱ u̱s-kan se o-gye̱r. ");
INSERT INTO uth_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Ko̱ wu̱ ke, bo̱ wu̱ hyambu̱te̱ Ye̱so à, wu̱ zapu̱ru̱ u̱s-zap. Ye̱so te̱psbu̱ru̱ ye̱ ho̱r-m-ho̱r. Wu̱ ze̱e̱ru̱ ye̱, “Ho'os no̱ hur u̱n no̱. Yage̱ no̱ o-gye̱r. Me̱ wu̱.” ");
INSERT INTO uth_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Ka da-de, wu̱ wo̱bu̱ru̱ be-de u̱n ye̱. Wu̱ co̱wu̱ru̱ o-hat. Yo-m re̱su̱ru̱ tomso ne̱. Ye̱ ne̱ ye̱ bo̱pu̱ru̱ u̱s-nu de̱e̱n. ");
INSERT INTO uth_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Ko̱ de̱ wu̱ re̱e̱gtu̱te̱ hun-ne̱ u̱n yish-ye̱ u̱n ye̱ à, ye̱ u̱ngo̱ nap be̱e̱b-u̱r Ye̱so á. Hur-de u̱n ye̱ hoks m-nap á. ");
INSERT INTO uth_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Ye̱ pasu̱ru̱ u̱r-jit, ye̱ wo̱o̱ru̱ u̱n dak-o̱ o-Genesaret. Ye̱ gagu̱ru̱ o-hat u̱n riib-o̱ o-mar. ");
INSERT INTO uth_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Bo̱ ye̱ rwu̱u̱nte̱ à, ba u̱n naas o-da, hun-ne̱ napu̱ru̱ u̱nze Ye̱so wu̱. ");
INSERT INTO uth_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Ye̱ do̱ru̱ru̱ u̱t-bo̱, hun-ne̱ masu̱ru̱ wu̱ m-hante̱ ya-u̱s-go̱m u̱s-rek u̱s-rek n-te̱ u̱n ke̱re̱m-to̱ u̱n ye̱. Ko̱ o̱ ke dak-o̱ ye̱ ho̱ge̱ Ye̱so ro, ye̱ heetu̱ru̱ ye̱. ");
INSERT INTO uth_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Kap be-de wu̱ co̱we̱ à, u̱n bo̱-u̱t re̱k-to̱ ko̱ bo̱-u̱t caari, u̱n riib ne̱, ye̱ ru̱ssu̱ru̱ ya-u̱s-go̱m be-de u̱t-baab. Ye̱ ko̱nu̱ru̱ Ye̱so wu̱ yage̱ ye̱ ci ko̱ riib-o̱ u̱n co̱p-o̱ u̱n wu̱. Bo̱ u̱n ya-u̱s-go̱m ye̱ ci'e̱ o̱ à, go̱m-u̱s taaru̱ ye̱. ");
INSERT INTO uth_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","De ken ho̱-de, Parisa-ne̱ mo̱rgu̱ru̱ be-u̱r Ye̱so mo̱sse̱ u̱n ye̱ ken ye̱ ne̱ yan-Yoos-de u̱n karamsa-o Mosa. Ye̱ wo̱o̱nu̱ru̱ rwu̱u̱n-mo̱ o-Urusharima remen ye̱ hyenet Ye̱so. ");
INSERT INTO uth_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Ye̱ hyanu̱ru̱ ye̱ ken yan-neke̱-m Ye̱so ye̱. Ye̱ ro u̱n re̱ u̱n rii u̱t-ri'in ne̱ u̱n kom-to̱ u̱n ye̱, ba ye̱ u̱n sapt, bo̱ Parisa-ne̱ ze̱e̱ ye̱ ye̱ sapt à. ");
INSERT INTO uth_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Yahuda-ne̱, yagu̱nte̱ de̱ Parisa-ne̱, ye̱ ro u̱n do̱re̱ u̱n rem-se ya-n-ga-ye̱ yoose̱ ye̱ à. Ye̱ ro m-re̱ u̱n rii á, se̱ ye̱ saptu̱ssu̱te̱ u̱t-kom u̱r-bon ne̱ bo̱ ye̱ 'wo̱sse̱ tat u̱n ye̱ ne̱ ro m-no̱m n-ga à. ");
INSERT INTO uth_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Tomso ne̱ ye̱ ro u̱n re̱ u̱n rii-yo m-re̱ be-de u̱t-baab á, se̱ ye̱ saptu̱ssu̱te̱. Ka da-de ne̱ ye̱tte̱ u̱n re̱ u̱n rii-yo m-re̱ yo u̱n be-de u̱t-baab. Se ken jor-se ro kon de̱e̱n se tat u̱n ye̱ ne̱ ze̱e̱ ye̱ do̱re̱ à. Se ye̱tte̱ m-so'os u̱t-ko̱k, u̱t-tur ne̱, rii-yo ye̱ duuste̱ rii u̱n to̱. ");
INSERT INTO uth_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Remen kaane̱, Parisa-ne̱ u̱n yan-Yoos-de u̱n karamsa-o Mosa ne̱ ye̱ citu̱ru̱ Ye̱so. Ye̱ ze̱e̱ru̱, “¿Ya hante̱ yan-neke̱-m ru ye̱ ro̱tte̱ u̱n do̱re̱ u̱n jor-se ya-n-ga-ye̱ á? Ye̱ ro̱tte̱ u̱n re̱ u̱n rii u̱t-ri'in ne̱ u̱n kom-to̱ u̱n ye̱.” ");
INSERT INTO uth_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Ye̱so shasu̱ru̱ ye̱, “E̱e̱, Ishayawan-Rwo̱r u̱n Ma-to̱ Shir wu̱ rwo̱ro̱g ma-u̱t no̱ hond hond, no̱ ya-o-she̱pe̱! Ho̱ge̱ no̱ rii-yo wu̱ ge̱ne̱ à. Wu̱ ge̱ne̱g u̱nze, Shir ze̱e̱g, “ ‘Ka hun-ne̱ ye̱ ro̱ me̱ u̱r-bo̱ngo̱n bo̱ o-nu, amba ye̱ ya'as me̱ hur-de u̱n ye̱ á. ");
INSERT INTO uth_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Bo̱ngo̱n-de ye̱ ro̱ me̱ m-nome̱ à, hwaa o̱. Remen, ye̱ ro̱ u̱n yoos u̱n karamsa-o̱ u̱n hun-ne̱ sa o zee karamsa-to̱ Shir.’ ” ");
INSERT INTO uth_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Ye̱so dooru̱ ye̱ m-ze̱e̱, “Kaane̱ o̱ no̱ m-no̱m. No̱ m-yage̱ u̱n karamsa-o̱ Shir, no̱tte̱ u̱n do̱re̱ u̱n jor-u̱s tat no̱ ne̱.” ");
INSERT INTO uth_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Ye̱so dooru̱ m-do̱, wu̱ ze̱e̱ru̱ ye̱, “¿We̱e̱r-u̱s no̱ se ka? No̱ m-muut u̱n karamsa-o̱ Shir hwaa remen no̱ do̱ru̱te̱ jor-u̱s tat no̱ ne̱! ");
INSERT INTO uth_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Bu̱-o gaan, Mosa zeste̱, ‘Ya tato ru u̱n inu ru ne̱ u̱t-go̱s. Wu̱ pyape̱ tat u̱n wu̱ à, ko̱ inu u̱n wu̱, a ho wu̱.’ ");
INSERT INTO uth_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Amba no̱ u̱r-yoos u̱nze u̱rege̱ ne̱t ro̱ u̱n yo ken rii-yo ne̱ yo wu̱ heete̱ m-gu u̱n tato u̱n wu̱ ko̱ inu u̱n wu̱ u̱n yo à, amba wu̱a zee, ‘Kap rii-yo no̱ roa kum be u̱n de n-ga à, yar-mo̱ mo̱ u̱m seke̱ Shir à.’ ");
INSERT INTO uth_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","U̱n yoos-de u̱n kaane̱, no̱tte̱ u̱n hante̱ u̱n co̱w-se u̱n yage̱ u̱n gu u̱n tat no̱ ne̱ ye̱ ro̱ u̱r-ko̱o̱b à. ");
INSERT INTO uth_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Ka bo̱ no̱ m-muut u̱n Ma-to̱ Shir hwaa. No̱tte̱ u̱n do̱re̱ u̱n jor-se u̱n ya-n-ga-ye̱. No̱tte̱ u̱n yoose̱ u̱n yakar no̱. Sha-mo̱ u̱n ma-u̱t gaan-mo̱ ka u̱m nomu̱ no̱. Se ken rem-se ro̱ ko̱n u̱t-mo̱o̱r ne̱ se no̱ m-no̱m à.” ");
INSERT INTO uth_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Bo̱ Ye̱so komte̱ ru̱re̱ u̱n Parisa-ne̱ kaane̱ à, komo wu̱ agnu̱ru̱ mo̱o̱r-to̱ u̱n hun-ne̱ ye̱ ro kane̱ u̱s-riib à. Wu̱ ze̱e̱ru̱ ye̱, “Raks no̱ u̱t-to̱, kap-m no̱, no̱ nep ma-to̱ u̱m he no̱ m-ru̱re̱ à. ");
INSERT INTO uth_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Rii-yo ne̱t ro̱ m-re̱ u̱n nu-o̱ u̱n wu̱ à, yo ro̱ wu̱ m-naas á, se̱ de̱ yo ro̱ m-rwu̱u̱n u̱n hur-de u̱n ne̱t à, yo ro̱ wu̱ m-naas.” ");
INSERT INTO uth_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Bo̱ Ye̱so nomte̱ u̱t-ma kaane̱ à, wu̱ yagu̱ru̱ mo̱o̱r-to̱ u̱n hun-ne̱, wu̱ co̱wu̱ru̱ o-hur. Ka da-de ne̱, yan-neke̱-mo̱ u̱n wu̱ citu̱ru̱ wu̱, “¿Re o̱, ka sha-mo̱ u̱t-ma to̱ ro̱?” ");
INSERT INTO uth_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Ye̱so ze̱e̱ru̱ ye̱, “¿Har u̱n no̱ ne̱, no̱ nap á? Rii-yo ne̱t ro̱ m-re̱ à, yo ro̱ wu̱ m-naas á. ");
INSERT INTO uth_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Me̱ u̱n ze̱e̱ kaane̱ remen u̱r-hur o̱, yo co̱we̱ á, u̱t-me̱n o̱, yo co̱we̱. Rii-yo co̱we̱ u̱t-me̱n à, a ruut yo o-ko̱t.” (Ye̱so u̱n ru̱ru̱ ye̱ ka ma-to̱ wu̱ kututu̱ ye̱ u̱nze ko̱ yo ke rii-yo yo ro̱ u̱n bon-de m-re̱ ne̱.) ");
INSERT INTO uth_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Wu̱ dooru̱ m-ze̱e̱, “Rii-yo ro̱ m-rwu̱u̱n u̱n hur-de u̱n ne̱t à, yo ro̱ wu̱ m-naas. ");
INSERT INTO uth_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Me̱ u̱n ze̱e̱ yo ka remen u̱n hur-de u̱n ne̱t o̱, barag-u̱s yo̱-se ro̱ m-rwu̱u̱n: rii-yo m-'e̱, u̱r-hyow ne̱, u̱n ho̱-de u̱n ne̱t ne̱, ");
INSERT INTO uth_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","o-ás, u̱r-go̱p ne̱, u̱n me̱n-u̱t jaas-to̱ ne̱, u̱t-raks ne̱, u̱r-she'et ne̱ u̱ntu̱n gu̱u̱b-o̱ o-gwo̱o̱r, u̱r-shoob ne̱, u̱n re̱e̱b-to̱ u̱n hun-ne̱ ne̱, u̱n nu̱-mo̱ u̱r-hi ne̱, u̱n m-raag ne̱. ");
INSERT INTO uth_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Ka rem-u̱s yo̱-se se kap, u̱n hur-de u̱n ne̱t o̱, se ro̱ m-rwu̱u̱n. Se se ro̱ ne̱t m-naas.” ");
INSERT INTO uth_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Ye̱so yagu̱ru̱ o-Gariri, wu̱ co̱wu̱ru̱ u̱n o̱ ken dak-o̱ u̱r-hew ne̱, dak-o̱ u̱n o̱ ken bo̱-o̱ o̱ a m-ze̱e̱ o-Taya à. Wu̱ comsu̱ru̱ u̱n o̱ ken hur-o̱. Wu̱ co̱nu̱ ne̱ hun-ne̱ nep á. Amba hun-ne̱ ro̱ u̱n 'er-de u̱n wu̱ ko̱ ye̱a hyen wu̱ à. ");
INSERT INTO uth_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Wu̱ ken ne'a-wu̱ ho̱gu̱ru̱ Ye̱so haante̱. Ka ne'a-wu̱ wu̱ ro u̱n wan-ne'a ne̱ re̱k-wu̱, ya-u̱t-ko̱t daag wu̱ u̱r-hi. Wu̱ haanu̱ru̱ be-u̱r Ye̱so ho̱r-m-ho̱r. Wu̱ kwu̱ktu̱ru̱ u̱n co-o̱ u̱n wu̱. ");
INSERT INTO uth_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Ka ne'a-wu̱ tomso, ko-ya-o-Yahuda wu̱ á, ko-ya u̱n dak-o̱ o-Siriya wu̱. Wu̱ ko̱nu̱ru̱ Ye̱so ruute̱ wà u̱n wu̱ ko-ya-u̱t-ko̱t ye̱ da'e̱ wu̱ u̱r-hi à. ");
INSERT INTO uth_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Ye̱so ze̱e̱ru̱ ká ne'a-wu̱, “A yage̱ yakar cikste̱ tokon. Rii-yo m-re̱ yo u̱n yakar, yo depe̱ a ya'as ye̱ge̱-wo̱ á.” ");
INSERT INTO uth_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ne'a shasu̱ru̱ Ye̱so, wu̱ ze̱e̱ru̱, “Go̱s-wu̱, ka bo̱ o̱, amba ko̱ ye̱ge̱-wo̱, ye̱ ro̱ u̱n re̱ u̱n rii-yo m-re̱ yo he̱'e̱ne̱ yakar à.” ");
INSERT INTO uth_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Bo̱ ne'a zette̱ Ye̱so kaane̱ à, Ye̱so shasu̱ru̱ wu̱. Ye̱so ze̱e̱ru̱, “Bo̱ o shestu̱ me̱ kaane̱ à, ji o-hur, ko-ya-u̱t-ko̱t ruug u̱n hi-u̱r wà ru wan-ne'a.” ");
INSERT INTO uth_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Ne'a argu̱ru̱ jo. Wu̱ wo̱be̱, wu̱ 'wo̱s wà ro do̱mb n-to̱n u̱n rii-o̱ u̱r-ru̱t. Ko-ya-u̱t-ko̱t ruuste̱ u̱n hi-de u̱n wà. ");
INSERT INTO uth_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Ye̱so ro m-ru u̱n dak-o̱ u̱n riib-o u̱n bo̱-o̱ o-Taya, wu̱ do̱ru̱ru̱ so̱ o-Sidon wu̱ heet Mar-o̱ o-Gariri. Ka da-de ne̱, wu̱ hessu̱nu̱ru̱ u̱n dak-o̱ a m-ze̱e̱ dak-o̱ u̱n Bo̱-u̱t O̱p. ");
INSERT INTO uth_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Bo̱ wu̱ wo̱o̱nte̱ kane̱ à, ye̱ ken ye̱ hantu̱ru̱ Ye̱so wu̱ ken ko-ka'ato̱-wu̱. Wu̱ ro̱ tomso u̱t-re'em ne̱. Ye̱ ko̱nu̱ru̱ Ye̱so seke̱ wu̱ o-kom, ko̱ ka go̱m-o̱ m-ta à. ");
INSERT INTO uth_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Ye̱so yagnu̱ru̱ mo̱ro̱g-de u̱n hun-ne̱. Wu̱ paksu̱ru̱ u̱n ka ne̱t-wu̱ ne̱. Wu̱ zu̱pu̱ru̱ wu̱ u̱t-to̱ u̱n jow-ye̱ u̱n wu̱. Wu̱ copsu̱ru̱ o-jow m-ta. Wu̱ ci'u̱ru̱ rem-de u̱n wu̱ u̱n ka jow-yo. ");
INSERT INTO uth_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Wu̱ dassu̱ru̱ u̱r-hi n-To̱n o̱ shir. Wu̱ shiku̱ru̱ de̱e̱n. Wu̱ ze̱e̱ru̱ wu̱, “E̱phaphatha” u̱nze, “To̱-u̱t ru tikse̱.” ");
INSERT INTO uth_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Bo̱ m-ze̱e̱ u̱n kaane̱ to̱-u̱t tiksu̱ru̱. Rem-u̱r ho'osu̱ru̱. Wu̱ te̱pru̱ru̱ u̱r-bon ne̱. ");
INSERT INTO uth_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Ka da-de ne̱, Ye̱so ka'agu̱ru̱ ye̱ u̱nze ye̱ jar ye̱ ru̱re̱ ne̱t á. Amba bo̱ Ye̱so ka'agte̱ ye̱ à, ye̱ ne̱ komo ye̱ dooru̱ m-rwo̱r. ");
INSERT INTO uth_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Ye̱ ho̱ge̱ ka ma-to̱ u̱n to̱-to̱ u̱n ye̱ à, ye̱ bo̱pu̱ru̱ u̱s-nu remen ye̱ hyanag rii-yo u̱t-hyat. Ye̱ ze̱e̱ru̱, “Wu̱ nak no̱m u̱n ko̱ yo ke rii-yo u̱r-bon ne̱ har wu̱ rwo̱'o̱g ka'ato̱-ne̱ u̱n be̱be̱-ne̱ m-ho̱ge̱, ye̱ te̱pe̱r.” ");
INSERT INTO uth_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","U̱n ka ho̱-to̱ ne̱, hun-ne̱ dooru̱ m-mo̱rge̱ de̱e̱n be-u̱r Ye̱so. Ye̱ kus u̱n rii-yo m-re̱ ne̱ komo á. Ye̱so agnu̱ru̱ yan-neke̱-mo̱ u̱n wu̱. Wu̱ ze̱e̱ru̱ ye̱, ");
INSERT INTO uth_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Kay, u̱m ho̱gu̱te̱ 'wo̱n-de u̱n ka hun-ne̱ ye̱, ye̱ rewe̱ be u̱n na ho̱-u̱t tet à, rii-yo m-re̱ yo kus á. ");
INSERT INTO uth_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Me̱ 'yonse̱ ye̱ ne̱, ye̱ ji m-mo̱ka m-me̱r m-me̱r, me̱r a bu ye̱ u̱n co̱w. Ye̱a wo o-hur á, remen ye̱ ken ye̱ rwu̱u̱nte̱ u̱r-hew ne̱.” ");
INSERT INTO uth_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Yan-neke̱-m Ye̱so shasu̱ru̱ wu̱, ye̱ ze̱e̱ru̱, “¿Ke ne̱ o̱ ne̱ a he hoks m-kum u̱t-buro̱di kane̱ o-ko̱t to̱ he coks u̱n ka hun-ne̱ ye̱ à?” ");
INSERT INTO uth_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Ye̱so citu̱ru̱ ye̱, wu̱ ze̱e̱ru̱, “¿Buro̱di-u̱t re to̱ no̱ ro̱tte̱?” Ye̱ ze̱e̱ru̱ wu̱, “Buro̱di-u̱t ta'yoor-to̱ te̱ ro̱tte̱.” ");
INSERT INTO uth_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Ka da-de ne̱, Ye̱so ze̱e̱ru̱ hun-ne̱, she'et n-dak. Bo̱ ye̱ she'ete̱ à, wu̱ de̱ku̱ru̱ ka buro̱di-u̱t ta'yoor-to̱, wu̱ nomu̱ru̱ Shir u̱r-bo̱ngo̱n. Wu̱ bosru̱ru̱ to̱, wu̱ ya'asu̱ru̱ yan-neke̱-mo̱ u̱n wu̱ ye̱ heete̱ mo̱o̱r-to̱ u̱n hun-ne̱. Ye̱ heetu̱ru̱ ye̱. ");
INSERT INTO uth_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Ye̱ ro u̱n jan re̱k-ye̱ ne̱ hiin. Da-o̱ wu̱ nomse̱ Shir u̱r-bo̱ngo̱n remen ye̱ à, wu̱ ze̱e̱ru̱ yan-neke̱-mo̱ u̱n wu̱ ye̱ wo̱nge̱ hun-ne̱ ka jan-ye̱ tomso. Ye̱ heetu̱ru̱ ye̱. ");
INSERT INTO uth_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Ko̱wan wu̱ re̱e̱ru̱, wu̱ ciig. Bo̱ ye̱ cikste̱ à, yan-neke̱-mo̱ u̱n wu̱ kamsu̱ru̱ bos-to̱ kuse̱ à. To̱ shoosu̱ru̱ ko̱o̱r-u̱t ta'yoor. ");
INSERT INTO uth_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Hun-ne̱ ne̱ ye̱ wooste̱ dugu-u̱s nass 4,000. Bo̱ ye̱ komte̱ m-re̱ à, Ye̱so 'yonsu̱ru̱ ye̱. ");
INSERT INTO uth_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Ba u̱n naas o-da, ka da-de ne̱, wu̱ co̱wu̱ru̱ o-hat u̱n yan-neke̱-mo̱ u̱n wu̱ ne̱, ye̱ haaru̱ u̱n dak-o̱ o-Darmanuta. ");
INSERT INTO uth_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Bo̱ Parisa-ne̱ ho̱gu̱te̱ Ye̱so wo̱o̱nte̱ à, ye̱ haaru̱ be-de u̱n wu̱. Ye̱ taknu̱ wu̱ u̱s-cot. Ye̱ ro u̱n hoob-o̱ wu̱ nom to̱ ken hyat-to̱, to̱ ye̱ hette̱ m-ze̱e̱ wu̱ rwu̱u̱nte̱ n-To̱n shir à. Ye̱ ro wu̱ m-taks. ");
INSERT INTO uth_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Bo̱ wu̱ ho̱gu̱te̱ ma-to̱ u̱n ye̱ à, wu̱ shiku̱ru̱ u̱n hur-de u̱n wu̱ de̱e̱n. Wu̱ ze̱e̱ru̱, “¿Ya-m-mo̱ka ye̱, ya u̱n yo no̱tte̱ o-hoob o̱ u̱n hyan u̱n hyat-to̱ Shir? Nip-o̱ me̱ no̱ m-ru̱re̱, mo̱ ken se̱nge̱-mo̱ u̱t-hyat mo̱ ro̱ ko̱n mo̱ a he m-kute̱ ya-m-mo̱ka ye̱ á.” ");
INSERT INTO uth_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Bo̱ wu̱ ru̱ru̱tu̱ ye̱ kaane̱ à, wu̱ inu̱ru̱. Wu̱ co̱wu̱ru̱ o-hat u̱n yan-neke̱-mo̱ u̱n wu̱ ne̱. Ye̱ pasu̱ru̱ u̱n de ka jit-de. ");
INSERT INTO uth_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","To̱-u̱t ka'ag yan-neke̱-m Ye̱so m-neke̱ u̱t-buro̱di ne̱. Se̱ u̱r-gaan u̱n ho̱n-de u̱n de de ye̱ ro̱tte̱ n-me̱ o-hat. ");
INSERT INTO uth_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Ye̱ ro̱ u̱n pas o-mar, Ye̱so naku̱ru̱ ye̱ u̱t-to̱, wu̱ ze̱e̱ru̱, “Baks no̱, no̱ nom cen u̱n yist-mo̱ u̱n Parisa-ne̱ u̱n yist-m ko-Gwo̱mo Here̱ ne̱.” ");
INSERT INTO uth_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Ye̱ no̱mu̱ru̱ u̱t-ma u̱n hi u̱n de u̱n ye̱, ye̱ ze̱e̱ru̱, “Wu̱ u̱n rwo̱r kaane̱ remen att u̱t-buro̱di á.” ");
INSERT INTO uth_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Ye̱so napu̱ru̱ bo̱ u̱n rii-yo ye̱ no̱me̱ u̱t-ma à. Wu̱ ze̱e̱ru̱, “¿Remen ya no̱tte̱ u̱n ma-to̱ u̱n ko̱o̱b-de u̱t-buro̱di? ¿No̱ nap ma-to̱ u̱m ro̱ttu̱ no̱ á? A'a, ¿har m-mo̱ka no̱ u̱n ko̱o̱b-de m-nap ne̱? ");
INSERT INTO uth_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","‘No̱ u̱n yish ne̱ ye̱ o-hyan, ¿Amba no̱ m-hyan á? No̱ u̱t-to̱ ne̱ to̱ m-ho̱ge̱, ¿Amba no̱ m-ho̱ge̱ á?’ ");
INSERT INTO uth_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","No̱ baks á! Da-o̱ u̱m bosre̱ hun-ne̱ dugu-u̱s taan 5,000 buro̱di-u̱t taan à, ka bos-to̱ kuse̱ no̱ à, ¿ko̱o̱r-u̱t re to̱ no̱ shoose̱ u̱n to̱?” Ye̱ ze̱e̱ru̱, “Ko̱o̱r-u̱t o̱p-u̱t yoor-to̱.” ");
INSERT INTO uth_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Wu̱ ze̱e̱ru̱, “Buro̱di-u̱t ta'yoor ne̱ to̱ u̱m bosre̱ hun-ne̱ dugu-u̱s nass 4,000, ka bos-to̱ kuse̱ no̱ à, ¿ko̱o̱r-u̱t re to̱ no̱ shoose̱ u̱n to̱?” Ye̱ shasu̱ru̱, ye̱ ze̱e̱ru̱, “Ko̱o̱r-u̱t ta'yoor-to̱.” ");
INSERT INTO uth_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Wu̱ ze̱e̱ru̱ ye̱, “¿Har m-mo̱ka, no̱ nap á?” ");
INSERT INTO uth_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Ye̱so u̱n yan-neke̱-mo̱ u̱n wu̱ ne̱ ye̱ haaru̱ u̱n de ken bo̱-de de a m-ze̱e̱ o-Besayada à. Bo̱ ye̱ woote̱ à, hun-ne̱ hantu̱ru̱ Ye̱so, wu̱ ken ko-po̱-wu̱. Ye̱ ko̱nu̱ru̱ wu̱ u̱nze wu̱ ci yish-ye̱ u̱n wu̱ ko̱ ye̱a upse̱ à. ");
INSERT INTO uth_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Wu̱ bo̱pu̱ru̱ wu̱ o-kom, wu̱ ruutu̱ru̱ wu̱ n-riib o-bo̱. Bo̱ wu̱ ruute̱ wu̱ à, wu̱ copsu̱ru̱ yish-ye̱ u̱n wu̱ m-ta. Wu̱ ci'u̱ru̱ ye̱ u̱n kom-to̱ u̱n wu̱. Ka da-de ne̱, wu̱ citu̱ru̱ ko-po̱. Wu̱ ze̱e̱ru̱ wu̱, “¿O hokste̱ hyan u̱n yo ken rii-yo?” ");
INSERT INTO uth_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ko-po̱ dassu̱ru̱ u̱r-hi remen wu̱ hyenet. Wu̱ ze̱e̱ru̱, “Me̱ de̱ m-hyan u̱n hun-ne̱ buu, u̱ntu̱n u̱s-'yo o̱ me̱ ye̱ m-hyan. Ye̱ ro̱ m-neke̱.” ");
INSERT INTO uth_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Komo Ye̱so dooru̱ ci u̱n yish-ye̱ u̱n wu̱. Ká da-de, yish-ye̱ u̱n wu̱ upsu̱ru̱. Wu̱ hyanu̱ru̱ ko̱yan cas cas. ");
INSERT INTO uth_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Ka da-de ne̱, Ye̱so ze̱e̱ru̱ wu̱, “Neke̱ jo u̱n hur-o ru. Wo̱ warag o-Besayada á.” ");
INSERT INTO uth_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Ye̱so inu̱ru̱ kane̱ u̱n yan-neke̱-mo̱ u̱n wu̱ ne̱. Wu̱ co̱wu̱ru̱ u̱n bo̱-to̱ u̱n dak-o̱ u̱n riib-o̱ u̱n bo̱-o̱ o-Kaseriya o-Pirip. Ye̱ ro m-neke̱ u̱n co̱w, Ye̱so citu̱ru̱ ye̱. Wu̱ ze̱e̱ru̱, “¿Wan wu̱ ne̱ hun-ne̱ ro̱ m-ze̱e̱ u̱m ro̱?” ");
INSERT INTO uth_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Ye̱ shasu̱ru̱ wu̱, “Ye̱ ken ye̱, ye̱ ro̱ m-ze̱e̱ Yohana wu̱ Wa-m-Yo'os u̱n hun-ne̱ m-ho̱. Wu̱ a 'yonse̱ be-de m-mar. Ye̱ ken ye̱ ne̱, ye̱ ze̱e̱ru̱ E̱reja wu̱. Ye̱ ken ye̱ ze̱e̱ru̱ wan-gaan be-de u̱n ya-n-ga-ye̱, yan-Rwo̱r u̱n Ma-to̱ Shir.” ");
INSERT INTO uth_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Ye̱so citu̱ru̱ ye̱, “No̱ ne̱, ¿Wan wu̱ ne̱ eb no̱ ro̱ m-ze̱e̱ u̱m ro̱?” Bitrus shasu̱ru̱ Ye̱so, wu̱ ze̱e̱ru̱, “Wo̱ wu̱ ro̱ Kiristi, Wan-Gwu̱ wu̱ Shir to̱mne̱ à.” ");
INSERT INTO uth_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Ka da-de ne̱, Ye̱so ka'agu̱ru̱ ye̱, wu̱ ze̱e̱ru̱, “No̱ jar no̱ ru̱r á.” ");
INSERT INTO uth_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Bo̱ wu̱ ka'agte̱ ye̱ u̱nze ye̱ rwo̱r u̱nze wu̱ ro̱ Wà-wu̱ u̱n ne̱t á, ka da-de ne̱, wu̱ taknu̱ ye̱ m-yoose̱ de ken yoos-de. Wu̱ ze̱e̱ru̱, “Gakte̱-mo̱ me̱ Wà-wu̱ u̱n ne̱t u̱m su̱ u̱r-ko̱o̱b. Se̱k-ye̱ ye̱ u̱n Yahuda-ne̱ u̱n Gwo̱mo-ne̱ ye̱ u̱n ko̱n-se Shir, u̱n yan-Yoos-de u̱n karamsa-o Mosa ne̱, ye̱a 'yarag me̱ har ye̱a ho me̱. Ye̱ ho me̱, ho̱-u̱t tet to̱ u̱m he m-no̱m u̱n saag u̱m inu̱te̱ u̱n ho̱o̱g ne̱.” ");
INSERT INTO uth_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Ye̱so rwo̱ru̱ru̱ ka ma-to̱ cas cas. Wu̱ wuke̱ to̱ ken to̱ á. Se̱ Bitrus naku̱ru̱ wu̱ pakse̱, wu̱ taknu̱ Ye̱so m-kangse̱. ");
INSERT INTO uth_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Bo̱ Bitrus kangse̱ wu̱ à, Ye̱so byandu̱ru̱ u̱s-ajima ne̱. Wu̱ gwo̱tu̱ru̱ ye̱ ka yan-neke̱-mo̱ u̱n wu̱ ye̱, ka da-de ne̱, wu̱ kangsu̱ru̱ Bitrus. Wu̱ ze̱e̱ru̱, “No̱m ja u̱n me̱ ne̱, ko-Gwo̱mo-wu̱ u̱n ya-u̱t-ko̱t. Barag-u̱s ru se Shir se á, se ma-hun se.” ");
INSERT INTO uth_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Ka da-de, Ye̱so agnu̱ru̱ bu̱u̱g-de u̱n hun-ne̱ ye̱ wo̱o̱n yow yow be-de u̱n yan-neke̱-mo̱ u̱n wu̱. Komo wu̱ ze̱e̱ru̱ ye̱, “U̱rege̱ wu̱ ken wu̱ co̱no̱g wu̱ warag wan-neke̱-m re, se̱ wu̱ she̱'e̱g hi u̱n de u̱n wu̱ komo se̱ wu̱ zo̱ngu̱te̱ wu̱ sew kan-o̱ u̱n wu̱, wu̱ do̱ru̱ me̱. ");
INSERT INTO uth_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Remen bo̱ u̱n wu̱ co̱ne̱ gu u̱n ho̱o̱g-o̱ u̱n wu̱ à wu̱a taage̱ u̱n o̱, amba no̱ ye̱ ya'ase̱ ho̱o̱g no̱ rem re à, komo remen Ma-to̱ m-Re̱re̱m no̱a kum ho̱o̱g-mo̱ ba m-ta. ");
INSERT INTO uth_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","¿Ya ne̱t kume̱ ne̱, wu̱ kume̱ ho̱no o-dak amba wu̱ taage̱ u̱n ho̱o̱g-mo̱ u̱n wu̱? ");
INSERT INTO uth_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","¿Ya ne̱t he ya'as u̱n Shir remen wu̱ oot ho̱o̱g-o̱ u̱n wu̱? ");
INSERT INTO uth_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","U̱rege̱ wu̱ ken wu̱ ro̱ m-ho̱ge̱ u̱n 'e̱-m re u̱n yo me̱ m-yoos ne̱ à, u̱n ka da-o̱, o̱ hun-ne̱ ro̱ m-she̱r be-de Shir á, amba se̱ me̱n-u̱t jaas-to̱, ka da-de, me̱ Wà-wu̱ u̱n ne̱t a ho̱ge̱ 'e̱-mo̱ u̱n wu̱, me̱ mu̱u̱ne̱ u̱n dak. Man mu̱u̱n u̱n se̱ps-mo̱ o-Tato ne̱ mo̱sse̱ u̱n mo̱ u̱n yan-to̱m-ye̱ Shir ne̱ ye̱ ba m-ku̱ko̱p.” ");
INSERT INTO uth_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Ye̱so dooru̱ ye̱ u̱t-ma, wu̱ ze̱e̱ru̱, “Ho̱ge̱ no̱! Nip-o̱ me̱ no̱ m-ru̱re̱, ye̱ ken ye̱ be u̱n no̱ ye̱ mo̱rge̱ kane̱ à, rii-yo ye̱ meret ye̱a hyen gwo̱mo-to̱ Shir rwu̱u̱nte̱ u̱n be̱e̱b-de u̱n to̱ ne̱.” ");
INSERT INTO uth_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Bo̱ rewu̱te̱ ho̱-u̱t cind à, Ye̱so de̱ku̱ru̱ Bitrus, Yakubu, u̱n Yohana ne̱. Ye̱ do̱ru̱ru̱ wu̱ har n-to̱n o-haag. Kane̱ u̱n ho̱n-de u̱n ye̱. Kaane̱ wu̱ barme̱ u̱n yish-ye̱ u̱n ye̱. ");
INSERT INTO uth_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Co̱p-to̱ u̱n wu̱ wargu̱ru̱ u̱t-pus to̱ puu. To̱ ma'asu̱ru̱ kyarkyar. Yatt wan hoks u̱n so'os u̱t-gund to̱ u̱n wu̱ kane̱ bo̱ co̱p-to̱ u̱n wu̱ no̱me̱ o-mo̱k á. ");
INSERT INTO uth_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Ye̱ hyanu̱ru̱ E̱reja u̱n Mosa ye̱ merse̱ à, ye̱ rwu̱u̱nte̱ be-u̱r Ye̱so. Ye̱ ro̱ u̱n te̱p u̱n Ye̱so ne̱. ");
INSERT INTO uth_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Bitrus ze̱e̱ru̱ Ye̱so, “Wa-u̱s-Nap, bo̱ a kane̱ à, no̱ng u̱r-bon te̱ nomu̱ no̱ de̱pi-u̱t tet: wo̱ u̱r-gaan, Mosa u̱r-gaan, E̱reja u̱r-gaan.” ");
INSERT INTO uth_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Bitrus u̱n ze̱e̱ kaane̱ remen wu̱ u̱n ye̱ ka yoor-ye̱ ne̱ yan-neke̱-m Ye̱so, gye̱r-o re̱e̱g ye̱ de̱e̱n har ye̱ hoks m-nap u̱n yo m-ze̱e̱ á. ");
INSERT INTO uth_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Ye̱ ro kane̱, o̱ ken ke'ente̱-o̱ kawnu̱ru̱, o̱ ho̱kku̱ru̱ u̱r-ho̱. Ye̱ ho̱gu̱ru̱ co̱r n-To̱n shir. O̱ zee, “Wà re wu̱ ka wu̱ u̱m co̱ne̱ à. Raks no̱ u̱t-to̱, no̱ ho̱ge̱ wu̱.” ");
INSERT INTO uth_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Bo̱ u̱n gye̱p-o̱ u̱n yish, ye̱ gwo̱tu̱ru̱, ye̱ 'wo̱s Ye̱so u̱n ho̱n-de u̱n wu̱ mo̱sse̱ u̱n ye̱ ne̱. Ye̱ hyan ye̱ ka á. ");
INSERT INTO uth_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Ye̱ ro̱ m-kergene̱ n-to̱n o-haag, wu̱ ka'agu̱ru̱ ye̱. Wu̱ ze̱e̱ru̱ ye̱, “No̱ jar no̱ ru̱re̱ ne̱t rii-yo no̱ hyane̱ á. Se̱ me̱ Wà-wu̱ u̱n ne̱t, da-o̱ me̱ ine̱ be-de u̱n margan-ne̱, ka da-de ne̱, no̱ he rwo̱r u̱n rii-yo no̱ hyane̱ à.” ");
INSERT INTO uth_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Ye̱ do̱ru̱ru̱ ma-to̱ u̱n wu̱, amba ye̱ ma'asu̱ru̱ u̱s-acitne̱ u̱n hi u̱n de u̱n ye̱, ye̱ ze̱e̱ru̱, “Se̱ da-o̱ wu̱ ‘ine̱ be-de u̱n margan-ne̱’ ¿Re o̱ no̱ hyane̱ ka ma-to̱?” ");
INSERT INTO uth_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ka da-de ne̱, ye̱ citu̱ru̱ Ye̱so. Ye̱ ze̱e̱ru̱, “¿Remen yan o̱ yan-Yoos-de u̱n karamsa-o Mosa zette̱ se E̱reja wu̱ merse̱ à, se̱ wu̱ musunte̱, ka da-de ne̱, Shir to̱mo̱nte̱ KiristiWan-Gwu̱?” ");
INSERT INTO uth_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","13","Ye̱so shasu̱ru̱ ye̱, wu̱ ze̱e̱ru̱, “Nip-o̱, a ge̱ne̱g be-de u̱n Ma-to̱ Shir u̱nze se̱ E̱reja heesu̱nte̱ wu̱ ja'asse̱ ko̱yan, ka da-de ne̱, Kiristi haanu̱ru̱. Ro̱ gense̱ tomso u̱nze hun-ne̱ a nomu̱ wu̱ kap rii-yo ye̱ co̱ne̱ à. Ka ne̱t-wu̱ a tane̱ u̱n jin-u̱r E̱reja à, wu̱ be'este̱ ne̱ wu̱ heesu̱nte̱. Bo̱ u̱n rii-yo a ge̱ne̱ u̱nze a nomu̱ wu̱ yo à, to̱, bo̱ u̱n haan-mo̱ u̱n wu̱ a nomu̱ru̱ wu̱ yo. Wà-wu̱ u̱n ne̱t, wu̱ Shir he m-to̱mo̱n u̱n jim-u̱r E̱reja à, a geneste̱ u̱nze wu̱a su̱ u̱r-ko̱o̱b de̱e̱n be-de u̱n hun-ne̱, ye̱a yo'og wu̱.” ");
INSERT INTO uth_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Ye̱so u̱n yan-neke̱-mo̱ u̱n wu̱ ne̱ ne̱n tet, bo̱ ye̱ kergente̱ o-haag à, ye̱ mu̱u̱nu̱ru̱. Ye̱ 'wo̱ssu̱ru̱ hun-ne̱ de̱e̱n hwo̱o̱g ká ye̱ ye̱ yage̱ à n-te̱te̱. Ma-u̱t su̱nu̱ru̱ yan-Yoos-de u̱n karamsa-o Mosa u̱n ye̱ ne̱. ");
INSERT INTO uth_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Bo̱ mo̱o̱r-to̱ u̱n ka hun-ne̱ ye̱ hyambu̱te̱ Ye̱so à, ye̱ bo̱pu̱ru̱ u̱s-nu. Ye̱ so̱mnu̱ru̱ u̱s-rek u̱s-rek. Ye̱ gassu̱ru̱ wu̱. ");
INSERT INTO uth_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Wu̱ citu̱ru̱ yan-neke̱-mo̱ u̱n wu̱, wu̱ ze̱e̱ru̱, “¿Yan go̱n ma-to̱ su̱nu̱ no̱ u̱n ka hun-ne̱ ye̱ ne̱?” ");
INSERT INTO uth_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","18","Se̱ wu̱ ken ne̱t-wu̱ n-me̱ u̱n ka mo̱o̱r-to̱ u̱n hun-ne̱ ye̱ wu̱ shasu̱ru̱. Wu̱ ze̱e̱ru̱, “Wa-u̱r-Yoos, me̱ ka hante̱ wà re wan-campo̱ wu̱ ko-ya-u̱t-ko̱t da'e̱ u̱r-hi à. Ye̱ we̱ne̱g wu̱ te̱p. Myet da-o̱ ye̱ daanu̱ wu̱, wu̱ ma'asu̱ru̱ m-hye̱ n-dak, nu-o̱ u̱n wu̱ ma'asu̱ru̱ u̱n ru u̱t-ko̱p. Wu̱ ma'asu̱ru̱ u̱n ti u̱n yin, wu̱ hu̱'u̱su̱ru̱ gaw. U̱m heette̱ wu̱ be-de u̱n yan-neke̱-m ru ye̱ ruut ka ko-ya-u̱t-ko̱t-wu̱. Ye̱ hoks á.” ");
INSERT INTO uth_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Ye̱so ze̱e̱ru̱ ka hun-ne̱ ye̱ kap. “No̱ ya-m-mo̱ka, yan-ko̱o̱b-de m-she̱r be u̱n de! ¿Se̱ da u̱n ke o̱ u̱m he m-ma'as u̱n no̱ ne̱? ¿U̱m du̱ngu̱nte̱ u̱n no̱ ne̱, har no̱ bu̱pt ma-u̱t re? No̱ de̱, hantu̱ me̱ no̱ wà.” ");
INSERT INTO uth_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Ka da-de, ye̱ hantu̱ru̱ wu̱ wà, wan-campo̱. Bo̱ ko-ya-u̱t-ko̱t hyente̱ Ye̱so à, wu̱ 'yonsu̱ru̱ o-zu̱ngo̱ u̱n hi-de u̱n wà. Wu̱r-o̱ u̱n wà argu̱ru̱ u̱s-zap. Wu̱ hye̱e̱ru̱ n-dak. Wu̱ ma'asu̱ru̱ u̱t-byorke̱. Nu-o̱ u̱n wu̱ ro u̱n ru u̱t-ko̱p. ");
INSERT INTO uth_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Ye̱so citu̱ru̱ tato-o̱ u̱n wu̱, Ye̱so ze̱e̱ru̱, “¿Da u̱n ke o̱ ne̱ ka rem-se kumu wu̱?” Tato-o shasu̱ru̱, “Cin wu̱ ro re̱k-wu̱. ");
INSERT INTO uth_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Ko̱yanda se̱ wu̱ ma'aste̱ wu̱ m-jorbe̱ n-me̱ o-ra, m-ho̱ ne̱ remen wu̱ hoot wu̱. U̱rege̱ wo̱a hoks, o ho̱ge̱ 'wo̱n u̱n te̱, o gu te̱.” ");
INSERT INTO uth_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Ye̱so ze̱e̱ru̱, “¿‘U̱rege̱ wo̱a hoks’? Ko̱ yo ke rii-yo yo m-no̱me̱ yo be-de wu̱ she̱re̱ be u̱n de à.” ");
INSERT INTO uth_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","U̱n ra o̱, wu̱ ho̱gu̱te̱ kaane̱ à, wu̱ 'yonsu̱ru̱ co̱r-o̱ u̱n wu̱. Wu̱ ze̱e̱ru̱, “U̱m de̱k Ma-to̱ Shir. Amba me̱ bo'os á. Gu me̱ bo̱ hur-u̱r u̱n de a wonge̱ be-u̱t yoor á.” ");
INSERT INTO uth_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Ye̱so hyanu̱ru̱ hun-ne̱ de̱e̱n ye̱ ro̱ m-mo̱nd be-de u̱n wu̱. Wu̱ huru̱ru̱ ka ko-ya-u̱t-ko̱t-wu̱ u̱t-gaag. Ye̱so ze̱e̱ru̱, “Ka ko-ya-u̱t-ko̱t-wu̱, wu̱ we̱ne̱ wà wan-campo̱ te̱p m-ho̱ge̱ ne̱ à, ru be-de u̱n kà wà-wu̱. Wo̱ jar do wu̱ m-da á.” ");
INSERT INTO uth_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Bo̱ wu̱ ho̱gu̱te̱ kaane̱ à, wu̱ dooru̱ wu̱ m-da u̱s-kan u̱s-kan. Wu̱r-o̱ u̱n wà argu̱ru̱ u̱s-zap de̱e̱n. Ka da-de, ko-ya-u̱t-ko̱t ruuru̱. Wà wargu̱ru̱ u̱ntu̱n ko-margan. Ye̱ ka ye̱ ro kane̱ à, ye̱ ze̱e̱ru̱, “Ay, wà mereste̱. Wu̱ kus u̱n ho̱o̱g ne̱ á.” ");
INSERT INTO uth_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Ye̱so tabbu̱ru̱ o-kom. Wu̱ bo̱pu̱ru̱ wà. Ye̱so 'yonsu̱ru̱ wu̱. Wà e̱su̱ru̱ ge̱. ");
INSERT INTO uth_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Bo̱ Ye̱so tu̱wte̱ o-hur à, yan-neke̱-mo̱ u̱n wu̱ citu̱ru̱ wu̱ pakse̱. Ye̱ ze̱e̱ru̱, “To̱, ¿re o̱ no̱me̱ te̱ hokste̱ ruut u̱n ka ko-ya-u̱t-ko̱t-wu̱ á, o ruutte̱ wu̱?” ");
INSERT INTO uth_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Wu̱ shasu̱ru̱ ye̱, “Go̱n ka rem-se se ro̱ m-ru á, se̱ mo̱sse̱ u̱n ko̱n-se u̱n Shir ne̱.” ");
INSERT INTO uth_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Ye̱so u̱n yan-neke̱-mo̱ u̱n wu̱ ne̱ ye̱ ruuru̱ kane̱. Ye̱ argu̱ndu̱ru̱ dak-o̱ o-Gariri. Ye̱so ne̱ wu̱ co̱n ne̱t nep á. ");
INSERT INTO uth_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Wu̱ ro u̱n yoose̱ u̱n yan-neke̱-mo̱ u̱n wu̱. Wu̱ ze̱e̱ru̱ ye̱, “Wà-wu̱ u̱n ne̱t, a ya'as wu̱ u̱n kom-to̱ u̱n yan-yage̱-to̱ u̱n wu̱. Ye̱a ho wu̱. Ye̱ ho wu̱, wu̱ taase ho̱-u̱t tet, wu̱ inu̱ru̱ u̱n ho̱o̱g ne̱.” ");
INSERT INTO uth_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Yan-neke̱-m Ye̱so ye̱ nap ka ma-to̱ á. Ye̱ cit wu̱ ne̱ á. Ye̱ ro o-gye̱r ye̱ cit wu̱. ");
INSERT INTO uth_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Ye̱ wo̱o̱nu̱ru̱ u̱n bo̱-o̱ o-Kapanahum. Ye̱ co̱wu̱ru̱ o-hur. Bo̱ ye̱ tu̱wte̱ o-hur à, Ye̱so citu̱ru̱ ye̱ ka ye̱ ro be-de u̱n wu̱ à. Wu̱ ze̱e̱ru̱, “¿Ya no̱me̱ ma-u̱t su̱nu̱tu̱ no̱ u̱n co̱w?” ");
INSERT INTO uth_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Ye̱ re̱su̱ru̱ te̱k remen ka ma-to̱ ye̱ rotte̱ u̱n co̱w à, u̱nze ko̱ wan wu̱ ro̱ se̱k-wu̱ be-de u̱n ye̱. ");
INSERT INTO uth_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Wu̱ she'etu̱ru̱. Wu̱ agnu̱ru̱ yan-neke̱-mo̱ u̱n wu̱ ne̱n o̱p u̱n yoor. Ye̱ hyoknu̱ru̱. Wu̱ ze̱e̱ru̱ ye̱, “Ko̱wan wu̱ co̱ne̱ wu̱ warag se̱k-wu̱, se̱ wu̱ muutte̱ hi u̱n de u̱n wu̱ u̱ntu̱n re̱k-wu̱, wu̱ nome̱ ko̱ wu̱ ke ne̱t-wu̱ m-gu̱w.” ");
INSERT INTO uth_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Ka da-de ne̱, Ye̱so de̱knu̱ru̱ wà re̱k-wu̱, wu̱ e̱ssu̱ru̱ wu̱ n-te̱te̱ o̱ u̱n ye̱. Wu̱ gamtu̱ru̱ wu̱. Ye̱so ze̱e̱ru̱ ye̱, ");
INSERT INTO uth_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Kap wu̱ go̱kse̱ wà re̱k-wu̱ u̱ntu̱n wu̱ ka rem re à, me̱ wu̱ go̱kse̱. Wu̱ go̱kse̱ me̱ à, me̱ wu̱ go̱kse̱ u̱n ho̱n-de á. Wu̱ to̱mne̱ me̱ à, wu̱ wu̱ go̱kse̱.” ");
INSERT INTO uth_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Yohana ze̱e̱ru̱ wu̱, “Wa-u̱r-Yoos, te̱ hyanag wu̱ ken wu̱ ro̱ u̱n ruute̱ u̱n hun-ne̱ ko-ya-u̱t-ko̱t, wu̱ ro̱ u̱n tan u̱n jin u̱n du. Te̱ we̱nu̱ru̱ wu̱ remen wu̱ ro̱ mo̱sse̱ u̱n na ne̱ á.” ");
INSERT INTO uth_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Ye̱so ze̱e̱ru̱, “No̱ we̱n wu̱ á. Yatt-wu̱ he no̱m u̱t-hyat u̱n be̱e̱b u̱n de, ka da-de ne̱, wu̱ tenet me̱ komo u̱n jin-u̱r yo̱-de á. ");
INSERT INTO uth_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Ay, kap wu̱ yage̱ na á, wu̱ ma na wu̱. ");
INSERT INTO uth_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Nip-o̱ me̱ no̱ m-ru̱re̱, wu̱ ya'e̱ no̱ ho̱-mo̱ m-swo̱ à, remen no̱ ye̱ ma Kiristi ye̱ à, wu̱a sabre̱ be-de Shir á.” ");
INSERT INTO uth_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Ye̱so dooru̱ ye̱ u̱t-ma. Wu̱ ze̱e̱ru̱, “Ka yakar-ye̱, ya-m-she̱r u̱n me̱, wu̱ rwo̱'e̱ wan-gaan be-de u̱n ye̱, m-ba'ase̱ u̱n co̱w-yo Shir à, jiishte̱ a gegu̱ wu̱ ta'ar-o̱ u̱r-na u̱n ge̱ks-de u̱n wu̱, a jorbe̱ wu̱ n-me̱ m-sa. ");
INSERT INTO uth_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","U̱rege̱ kom-o ru ro̱ wo̱ m-hante̱ u̱r-ba'as, kups o̱ o jore̱. Jiishte̱ o kum ho̱o̱g-o̱ u̱n ba m-ta kom-o gaan, o̱tte̱ a jorbe̱ wo̱ n-me̱ den-o̱ o-ra kom-u̱t yoor à, ra-o̱ ba m-ryomse̱. ");
INSERT INTO uth_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","U̱rege̱ ne̱ na-o ru ro̱ wo̱ m-hante̱ u̱r-ba'as, kups o̱. O mu̱u̱n be-de u̱n kum u̱n ho̱o̱g-o̱ ba m-ta na-o gaan, o̱tte̱ a jorbe̱ wo̱ den-o̱ o-ra na-u̱s yoor à, be-de ra-o̱ ba m-ryomse̱. ");
INSERT INTO uth_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Tomso u̱rege̱ yish u̱n du ro̱ wo̱ m-hante̱ u̱r-ba'as, hu̱s de. Jiishte̱ o tu̱w be-de u̱n gwo̱mo-to̱ Shir yish-u̱r gaan, o̱tte̱ a jorbe̱ wo̱ den-o̱ o-ra yish yoor à, ra-o̱ ba m-ryomse̱. ");
INSERT INTO uth_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Be-de, ‘Zwo̱ ro̱ m-mar à, komo ra-o ro̱ m-ryomse̱ á.’ ");
INSERT INTO uth_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","O-ra o̱, a he so'os u̱n hur-de u̱n ko̱wan bo̱ a m-ja'as u̱n rii n-te̱ m-po̱r à. ");
INSERT INTO uth_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“Po̱r-m ro̱ u̱r-bon ne̱, amba mo̱ taage̱ m-re̱re̱m, ¿u̱n yan a hette̱ mo̱ m-ja'as mo̱ nomot m-re̱re̱m? Warag no̱ u̱ntu̱n m-po̱r, no̱ she'et ba u̱t-ween u̱n o̱r no̱ ne̱.” ");
INSERT INTO uth_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Ye̱so inu̱ru̱ u̱n ká dak-o̱, wu̱ co̱wu̱ru̱ u̱n dak-o̱ o-Judiya, ka da-de wu̱ passu̱ru̱ Ro̱o̱g-o̱ o-Joda. Komo mo̱o̱r-to̱ u̱n hun-ne̱ dooru̱ m-go'one̱ be-de u̱n wu̱. Wu̱ dooru̱ ye̱ m-yoose̱ bo̱ wu̱ we̱te̱ m-no̱m à. ");
INSERT INTO uth_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Ye̱ ken Parisa-ne̱ ye̱ haanu̱ru̱ be-de u̱n wu̱ remen ye̱ taksté̱ wu̱, ko̱ wu̱a ba'ase̱ be-de Shir à. Ye̱ citu̱ru̱ wu̱, “¿Depete̱ campo̱ wu̱ ho'os ne'a u̱n wu̱?” ");
INSERT INTO uth_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Ye̱so shasu̱ru̱ ye̱, “¿Ya Mosa ze̱e̱ no̱?” ");
INSERT INTO uth_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Ye̱ ze̱e̱ru̱, “Mosa ya'ag te̱ o-co̱w a gen taku̱rda-o̱ u̱n caas u̱t-ge, a ho'os ne'a.” ");
INSERT INTO uth_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Ye̱so ze̱e̱ru̱ ye̱, “Cikt u̱n no̱ de rwo̱'e̱ wu̱ genetu̱ no̱ kà karamsa-o̱. ");
INSERT INTO uth_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Cin da-o̱ Shir no̱me̱ ko̱yan à, ‘Wu̱ no̱mo̱g hun-ne̱ campo̱ u̱n ne'a ne̱.’ ");
INSERT INTO uth_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Cin da wu̱ nomte̱ na kaane̱ à, ‘Campo̱ a yage̱ tato u̱n wu̱ u̱n inu u̱n wu̱ ne̱ remen wu̱ she'etté̱ u̱n ne'a u̱n wu̱ ne̱. ");
INSERT INTO uth_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Ye̱, yoor-ye̱ waragte̱ u̱ntu̱n wan-gaan’ campo̱ u̱n ne'a u̱n wu̱ ne̱, yanze u̱n ho̱n u̱n ho̱n á. Ye̱a ma'as hun-ne̱ gaan. ");
INSERT INTO uth_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Ge-to̱ Shir gekse̱ à, taasu̱ ne̱t, wu̱ caas to̱ á.” ");
INSERT INTO uth_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Bo̱ Ye̱so komte̱ u̱t-ma u̱n Parisa-ne̱ ne̱ à, wu̱ ji'iru̱ o-hur u̱n yan-neke̱-mo̱ u̱n wu̱ ne̱. Bo̱ ye̱ woote̱ o-hur à, komo ye̱ dooru̱ wu̱ m-cit u̱n ka ma-to̱. ");
INSERT INTO uth_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Wu̱ ze̱e̱ru̱ ye̱, “Ko̱wan wu̱ ho'ose̱ ne'a u̱n wu̱, wu̱ gaaru̱ ne'a ho̱r-wu̱, ás-o̱ wu̱ ro̱tte̱ u̱n ka ne'a-wu̱ ne̱, remen ne'a u̱n wu̱ wu̱ á. ");
INSERT INTO uth_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Tomso ne̱ ne'a-wu̱ ho'ose̱ campo̱ u̱n wu̱ à, wu̱ gaaru̱ campo̱ ho̱r-wu̱, ás-o̱ wu̱ ro̱tte̱ u̱n ka campo̱-wu̱ ne̱, remen campo̱ u̱n wu̱ wu̱ á.” ");
INSERT INTO uth_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Ye̱ ken ye̱ hantu̱ru̱ Ye̱so yakar re̱k-ye̱ remen wu̱ ci'it ye̱. Yan-neke̱-mo̱ u̱n wu̱ kangsu̱ru̱ ye̱. ");
INSERT INTO uth_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Bo̱ Ye̱so hyente̱ à, ryaab-u̱s re̱e̱ru̱ wu̱. Wu̱ ze̱e̱ru̱ yan-neke̱-mo̱ u̱n wu̱, “Yage̱ no̱ yakar re̱k-ye̱ ye̱ haante̱ be u̱n de. No̱ we̱n ye̱ á. Me̱ u̱n ze̱e̱ kaane̱ remen Gwo̱mo-to̱ Shir to̱ ro̱ be-de u̱n ka ye̱ ro̱ u̱ntu̱n yakar re̱k-ye̱ à. ");
INSERT INTO uth_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Nip-o̱ me̱ no̱ m-ru̱re̱, wu̱ yage̱ ya'as u̱n gwo̱mo-to̱ Shir hur-de u̱n wu̱ bo̱ wà re̱k-wu̱ ro̱ m-ya'as à, wu̱ á tu̱w u̱n to̱ á.” ");
INSERT INTO uth_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Bo̱ Ye̱so komte̱ ye̱ m-ru̱re̱ kaane̱ à, wu̱ gamtu̱ru̱ ka yakar-ye̱. Wu̱ hu̱u̱ru̱ ye̱ nu-o̱ u̱r-bon. ");
INSERT INTO uth_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Bo̱ Ye̱so hu̱u̱te̱ yakar nu-o̱ u̱r-bon à, wu̱ inu̱ru̱, wu̱ rwu̱u̱nu̱ru̱ u̱n co̱w. Wu̱ ken ne̱t-wu̱ hyambu̱ru̱ wu̱. Wu̱ teeru̱ru̱ o-rek. Wu̱ kwu̱ktu̱ru̱ u̱n co Ye̱so, wu̱ citu̱ru̱ Ye̱so. Wu̱ ze̱e̱ru̱, “Wa-u̱r-Yoos, wan-me̱n-u̱t pus-to̱, ¿re u̱m he m-no̱m u̱m kumut ho̱o̱g-o̱ ba m-ta?” ");
INSERT INTO uth_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Ye̱so citu̱ru̱ wu̱ eb u̱n wu̱, wu̱ ze̱e̱ru̱, “¿Remen ya u̱n o̱ o zettu̱ me̱ wan-me̱n-u̱t pus-to̱? Wan-me̱n-u̱t pus-to̱ ro̱ ko̱n á, se̱ Shir u̱n ho̱n-de u̱n wu̱. ");
INSERT INTO uth_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","O nepse̱ rii-yo Shir zee à: ‘Wo̱ ho̱ ne̱t á. Wo̱ ho̱o̱b ne'a-wu̱ u̱n ne̱t á, ne'a ne̱ wu̱ ho̱o̱b campo̱ wu̱ u̱n ne̱t á. Wo̱ hiw u̱r-hyow á. Wo̱ no̱m swo̱-se u̱t-bo̱ á. Wo̱ re̱ ra-o o̱r ru á, 'ya tato ru u̱t-go̱s u̱n inu ru ne̱.’ ” ");
INSERT INTO uth_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Ka ne̱t-wu̱ ze̱e̱ru̱, “Wa-u̱r-Yoos, u̱m do̱ru̱te̱ to̱ ka kap cin da-o̱ u̱m ro'e̱ wà à.” ");
INSERT INTO uth_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Ye̱so gwo̱tu̱ru̱ ka ne̱t-wu̱, ka ne̱t-wu̱ napu̱ru̱ u̱nze Ye̱so waste̱ u̱n wu̱ ne̱. Ye̱so ze̱e̱ru̱ wu̱, “Amba rii gaan yo o taage̱. Neke̱ o beeb rii-yo o ro̱tte̱ à, o ya'as ko̱o̱b-ne̱ ye̱ ro̱tte̱ rii á ka hwo̱r-ye̱. Wo̱a kum u̱r-'yons n-To̱n shir. Ka da-de ne̱, o mu̱u̱n, o do̱ru̱ me̱.” ");
INSERT INTO uth_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Bo̱ wu̱ ho̱gu̱te̱ kaane̱ à, wu̱ ho̱ge̱ m-re̱re̱m á ko̱ hiin. Wu̱ neku̱ru̱ me̱n-u̱t ro̱ m-tu̱k remen wu̱ wa-o-kwu̱m-wu̱ de̱e̱n. ");
INSERT INTO uth_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Ye̱so gu̱tru̱ru̱ yan-neke̱-mo̱ u̱n wu̱. Wu̱ ze̱e̱ru̱ ye̱, “Rem ro̱ ko̱n ko-ya-o-kwu̱m-wu̱ tu̱wu̱t be-de u̱n gwo̱mo-to̱ Shir.” ");
INSERT INTO uth_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Yan-neke̱-mo̱ u̱n wu̱ hyanu̱ru̱ hyat-to̱ u̱n ka ma-to̱. Komo Ye̱so dooru̱ ye̱ m-ze̱e̱, “U̱m hyanag co̱w u̱n gwo̱mo-to̱ Shir ro̱ u̱n rem ne̱. ");
INSERT INTO uth_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Jiishte̱ a zee dorom-yo cu̱w u̱n ish-o̱ o-be̱r, o̱tte̱ a zee wa-o-kwu̱m-wu̱ cu̱w be-de u̱n gwo̱mo-to̱ Shir à.” ");
INSERT INTO uth_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Ye̱ bo̱pu̱ru̱ u̱s-nu de̱e̱n. Ye̱ ze̱e̱ru̱ wu̱, “U̱rege̱ ka o̱, ¿wa he kum u̱n gwu̱?” ");
INSERT INTO uth_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Ye̱so gwo̱tu̱ru̱ ye̱. Wu̱ ze̱e̱ru̱, “Be-de u̱n hun-ne̱ a nome̱ á. Amba be-de Shir, yatt-yo kwange̱ Shir á.” ");
INSERT INTO uth_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Bitrus taknu̱ wu̱ m-ze̱e̱, “Gwo̱t, te̱ ka jore̱ ko̱ yo ke rii-yo, te̱ do̱ru̱te̱ wo̱.” ");
INSERT INTO uth_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","30","Ye̱so ze̱e̱ru̱, “Nip-o̱ me̱ no̱ m-ru̱re̱, ne̱t-wu̱ yage̱ hur-o̱ u̱n wu̱ à, ko̱ o̱r u̱n wu̱ ne̱, ko̱ inu u̱n wu̱, ko̱ tato u̱n wu̱, ko̱ yakar, ko̱ u̱t-kat, rem re, tomso remen Ma-to̱ m-Re̱re̱m to̱ Shir, wu̱a kum go̱n ka rem-se har o-zungu u̱n ka da-o̱ m-mo̱ka. Ka o̱ ne̱ tomso o-nip wu̱a kum u̱t-hur u̱n o̱r u̱n wu̱ ne̱ ne̱ u̱n inu u̱n wu̱ ne̱ ne̱ u̱n yakar ne̱ u̱t-kat ne̱. Amba wu̱a kum se mo̱sse̱ o-range̱ ne̱. Da-o̱ ro̱o̱ne̱ ne̱ à, wu̱a kum ho̱o̱g-o̱ ba m-ta. ");
INSERT INTO uth_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Hun-ne̱ de̱e̱n ye̱ ro̱ caari-ne̱ à, ye̱a waragse̱ re̱k-ye̱. Re̱k-ye̱ komo warag caari-ne̱.” ");
INSERT INTO uth_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Ye̱so u̱n yan-neke̱-mo̱ u̱n wu̱ ne̱ ye̱ ro m-ha u̱n bo̱-o̱ o-Urusharima. Ye̱so ro o-co, u̱n co̱w ye̱ ro wu̱ m-do̱re̱ bi. Ye̱ hyanag hyat-to̱ u̱n neke̱-mo̱ u̱n wu̱ o-Urusharima. Ye̱ ken ye̱ ne̱ ye̱ ro̱o̱ne̱ u̱n jim à, gye̱r-o re̱e̱ru̱ ye̱. Wu̱ dooru̱ koos u̱n ka o̱p u̱n yoor-ye̱ komo. Wu̱ taknu̱ ye̱ m-ru̱re̱ u̱n rii-yo he wu̱ m-kum à. ");
INSERT INTO uth_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Wu̱ ze̱e̱ru̱ ho̱gu̱ no̱, “A ka m-ha o-Urusharima. Me̱ Wà-wu̱ u̱n ne̱t, wu̱ ken ne̱t-wu̱ a ya'as me̱ u̱n kom-to̱ u̱n Gwo̱mo-ne̱ ye̱ u̱n ko̱n-se Shir u̱n yan-Yoos-de u̱n karamsa-o Mosa ne̱. Ye̱ ya'aste̱ me̱ u̱n kom-to̱ u̱n hamat-ne̱ ye̱ rumse̱ u̱t-gwo̱mo à, ye̱a piishe̱ me̱ ma-to̱ wo̱o̱ m-mar à, ye̱ ho me̱. ");
INSERT INTO uth_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Ye̱a nomo me̱ u̱r-ar, ye̱ copsu̱ me̱ m-ta, ye̱ bu me̱ u̱s-so̱ro̱g, ye̱ ho me̱. A nome̱ ho̱-u̱t tet, man ine̱ u̱n ho̱o̱g ne̱.” ");
INSERT INTO uth_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Yakar Ze̱be̱di, Yakubu ne̱, u̱n Yohana, ye̱ hyoknu̱ru̱ be-u̱r Ye̱so. Ye̱ ze̱e̱ru̱ wu̱, “Wa-u̱r-Yoos, te̱ co̱no̱g o nomu̱ te̱ u̱r-ho̱.” ");
INSERT INTO uth_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Wu̱ ze̱e̱ru̱ ye̱, “¿Ya no̱ co̱ne̱ u̱m nomu̱ no̱?” ");
INSERT INTO uth_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Ye̱ shasu̱ru̱, “Te̱ co̱no̱g, a sagbe̱ wo̱ u̱t-gwo̱mo, u̱n ho̱-de u̱n se̱ps-m ru, o dek te̱, wan-gaan she'et u̱n kom-o ru o̱ u̱r-re̱, wan-gaan she'et u̱n kom-o̱ u̱r-kwanta.” ");
INSERT INTO uth_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Ka da-de ne̱, Ye̱so ze̱e̱ru̱ ye̱, “No̱ nap rii-yo no̱ ko̱ne̱ á. ¿No̱a hoks swo̱ u̱r-ko̱o̱b bo̱ u̱m he de m-swo̱?” ");
INSERT INTO uth_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Ye̱ ze̱e̱ru̱ ye̱a hoks. Ye̱so ze̱e̱ru̱, “No̱a su̱ u̱r-ko̱o̱b, bo̱ me̱ de m-swo̱ à. A yo'os no̱ bo̱ a he me̱ m-yo'os à. ");
INSERT INTO uth_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Amba she'et-de u̱n re̱ u̱n de ko̱ kwanta u̱n de me̱ wu̱ ro̱ wan-gwo̱mo-to̱ m-'ya á. Shir wu̱ zo̱nge̱ ka be-to̱, remen ká ye̱ wu̱ daage̱ à.” ");
INSERT INTO uth_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Bo̱ ye̱ ka ne̱n o̱p-ye̱ ho̱gu̱te̱ yo Yakubu ne̱ u̱n Yohana ko̱ne̱ à, ryaab-u̱s re̱e̱ru̱ ye̱. ");
INSERT INTO uth_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Ye̱so agnu̱ru̱ yan-neke̱-mo̱ u̱n wu̱. Wu̱ ze̱e̱ru̱ ye̱, “No̱ nak ye̱ a nepse̱ u̱n gwo̱mo-to̱ u̱n to̱ ken dak-to̱ ne̱ à, ye̱ ro̱ u̱n kute̱ u̱n hun-ne̱ u̱r-be̱e̱b. ");
INSERT INTO uth_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Amba no̱, a nom kaane̱ u̱n no̱ ne̱ á. Kap wu̱ co̱ne̱ wu̱ nom u̱t-go̱s be u̱n no̱ à, se̱ wu̱ waragte̱ ko-gu̱w no̱. ");
INSERT INTO uth_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Ne̱t-wu̱ co̱ne̱ tomso wu̱ nom ko-Gwo̱mo no̱ à, wu̱a nome̱ ko̱ wu̱ ke ne̱t-wu̱ m-gu̱w. ");
INSERT INTO uth_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Me̱ u̱n ze̱e̱ yo ka remen, me̱ Wà-wu̱ u̱n ne̱t, me̱ u̱n haan remen a nomu̱tú̱ me̱ m-gu̱w á. Me̱ u̱n haan u̱m nomu̱té̱ hun-ne̱ m-gu̱w, tomso u̱m ya'as ho̱o̱g re remen u̱m rurut hun-ne̱ de̱e̱n.” ");
INSERT INTO uth_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Ye̱so u̱n yan-neke̱-mo̱ u̱n wu̱ ne̱ ye̱ co̱wu̱ru̱ u̱n bo̱-o̱ o-Jeriko. Ye̱ ro m-ru o-Jeriko u̱n yan-neke̱-mo̱ u̱n wu̱ ne̱ mo̱sse̱ u̱n mo̱o̱r-to̱ u̱n hun-ne̱ ne̱. Wu̱ ken ko-po̱-wu̱, wa u̱s-ko̱n, a wu̱ m-ze̱e̱ Bartimawus (wà Timawus) wu̱ ro tara n-riib u̱n co̱w. ");
INSERT INTO uth_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Bo̱ wu̱ ho̱gu̱te̱ Ye̱so ko-ya-o-Nazaret-wu̱ à, wu̱ taknu̱ 'yons u̱s-co̱r. Wu̱ ze̱e̱ru̱, “Ye̱so, wà Dawuda, hyan 'wo̱n u̱n de, o gu me̱!” ");
INSERT INTO uth_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Ye̱ ken ye̱ de̱e̱n ye̱ kangsu̱ru̱ wu̱, ye̱ ze̱e̱ru̱ wu̱, “Re̱s temb!” Amba wu̱ dooru̱ 'yons u̱s-co̱r de̱e̱n. Wu̱ ze̱e̱ru̱, “Ye̱so, wà Dawuda, hyan 'wo̱n u̱n de, o gu me̱!” ");
INSERT INTO uth_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Bo̱ Ye̱so ho̱ge̱ wu̱ à, wu̱ e̱su̱ru̱. Wu̱ ze̱e̱ru̱ hun-ne̱, “Agan no̱ wu̱.” Ye̱ agnu̱ru̱ ko-po̱. Ye̱ ze̱e̱ru̱ wu̱, “Ho'os hur u̱n du sak. Wu̱ ro̱ wo̱ u̱s-eeg.” ");
INSERT INTO uth_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Bo̱ wu̱ ho̱gu̱te̱ Ye̱so agbu̱te̱ wu̱ à, wu̱ joru̱ru̱ gund-o̱ u̱n wu̱, wu̱ inu̱ru̱ kagat, wu̱ neku̱ru̱ be-u̱r Ye̱so. ");
INSERT INTO uth_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Ye̱so ze̱e̱ru̱ wu̱, “¿Ya o co̱ne̱ u̱m nomu̱ wo̱?” Ka ko-po̱-wu̱ ze̱e̱ru̱, “Wan-yoos u̱n de, u̱m co̱no̱g o-hyan.” ");
INSERT INTO uth_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Ye̱so ze̱e̱ru̱ wu̱, “Ka o̱. Ine̱ o neke̱ neke̱-m ru. She̱r-m ru upsu̱tu̱ wo̱ yish ru.” Ba u̱n naas o-da, wu̱ hyanu̱ru̱ cas cas. Wu̱ do̱ru̱ru̱ Ye̱so u̱n co̱w. Ye̱ argu̱ru̱ m-neke̱. ");
INSERT INTO uth_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Ye̱so u̱n yan-neke̱-mo̱ u̱n wu̱ ne̱, ye̱ hyoknu̱ru̱ yow yow o-Urusharima ne̱ be-de u̱n Haag-o̱ u̱n 'yo-se o-Ze̱tun. U̱n co hiin to̱ ken bo̱-to̱ u̱t-re̱k-to̱ ro káne̱: o-gaan o-Bapaji, o-gaan o-Betanya. Ka da-de ne̱, Ye̱so to̱mu̱ru̱ yan-neke̱-mo̱ u̱n wu̱ ne̱n yoor. ");
INSERT INTO uth_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Wu̱ ze̱e̱ru̱ ye̱, “Wo̱be̱ no̱ u̱n ka bo̱-de ro̱ o-co à, no̱ tu̱w be-de u̱n ye̱. Da-o̱ no̱ tu̱we̱, no̱ 'wo̱s wà-yo o-janka yo a ce̱te̱ m-da á. Yo ro̱ gego. No̱ ussu̱ndu̱ me̱ yo, no̱ hantu̱ me̱. ");
INSERT INTO uth_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Kowa citu̱ no̱, ‘¿Ya no̱tte̱ m-us u̱n ka janka-yo?’ No̱ zee, ‘Go̱s-wu̱ te̱, wu̱ zee wu̱ co̱no̱g yo. Wu̱a mu̱u̱ntu̱sse̱ yo m-mo̱ka m-mo̱ka.’ ” ");
INSERT INTO uth_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Ka da-de ne̱, ye̱ argu̱ru̱ m-neke̱. Bo̱ ye̱ 'wo̱ste̱ yo à, ye̱ ussu̱nu̱ru̱ yo. ");
INSERT INTO uth_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Da-o̱ ye̱ ro yo m-us à, ka hun-ne̱ ye̱ ro kane̱ ge̱ à, ye̱ citu̱ru̱, “¿Remen ya no̱ usste̱ ka wà-yo o-janka yo?” ");
INSERT INTO uth_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Yan-neke̱-m Ye̱so ru̱ru̱ ye̱ bo̱ Ye̱so zee ye̱ à. Hun-ne̱ ze̱e̱ru̱ ye̱, “To̱, aragbu̱ no̱.” Ye̱ argu̱ru̱. ");
INSERT INTO uth_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Ye̱ hantu̱ru̱ Ye̱so ka janka-yo. Ye̱ ussu̱ru̱ gund-to̱ u̱n ye̱. Ye̱ neksu̱ru̱ n-to̱n o-janka. Ka da-de ne̱, Ye̱so daaru̱. ");
INSERT INTO uth_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Hun-ne̱ de̱e̱n ye̱ neksu̱ru̱ gund-to̱ u̱n ye̱ u̱n co̱w. Ye̱ ken ye̱ ne̱ ye̱ kaaru̱ u̱t-wa n-riib o-co̱w. Ye̱ ze̱e̱ru̱ m-neks u̱n co̱w. ");
INSERT INTO uth_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","U̱n ye̱ ro̱ o-co à, u̱n ye̱ ro̱ u̱n jim ne̱ à, kap ye̱ ma'asu̱ru̱ u̱s-guuda zak-o-zak. Ye̱ m-ze̱e̱, “A bo̱mo̱g Shir!” “A bu̱m no̱ ka wu̱ haane̱ u̱n be̱e̱b-u̱r Yawe à. A bu̱m no̱ wu̱!” ");
INSERT INTO uth_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","“Shir 'ye o-kwu̱m be-de u̱n haan-mo̱ u̱n gwo̱mo-u̱t Dawuda tat na.” “A bu̱m no̱ Shir n-To̱n!” ");
INSERT INTO uth_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Ye̱so co̱wu̱ru̱ o-Urusharima. Bo̱ wu̱ wo̱o̱nte̱ à, wu̱ co̱wu̱ru̱ u̱n Pyo-o̱ Shir o̱ ro̱ u̱n ka bo̱-o̱ à. Ka da-de ne̱, wu̱ gu̱tru̱ru̱ ko̱ yo ke rii-yo. Wu̱ hyanu̱ru̱ ho̱-u̱r teeste̱, wu̱ ruuru̱ o-Urusharima, wu̱ neku̱ru̱ o-Betanya mo̱sse̱ u̱n yan-neke̱-mo̱ u̱n wu̱ ne̱ o̱p u̱n ne̱n yoor. ");
INSERT INTO uth_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Ish gasu̱ru̱, ye̱ ruuru̱ o-Betanya. Ye̱ ro m-mu̱u̱n o-Urusharima, Ye̱so ho̱gu̱ru̱ me̱r. ");
INSERT INTO uth_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Wu̱ gu̱t, wu̱ 'wo̱s rum-yo ka u̱t-wa ne̱. Wu̱ hessu̱ru̱, wu̱ haaru̱ yo m-gwo̱t ko̱ yo makt à. Bo̱ wu̱ wo̱o̱bu̱te̱ be-de u̱n yo à, wu̱ 'wo̱s rii á, se̱ u̱t-wa remen da-o̱ u̱n mat-de u̱t-rum o̱ u̱n go no̱m á. ");
INSERT INTO uth_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Ye̱so ze̱e̱ru̱ ka rum-yo, “Wo̱a do m-mat u̱t-rum har hun-ne̱ reet to̱ á.” Yan-neke̱-mo̱ u̱n wu̱ ye̱ ho̱gu̱ru̱ bo̱ wu̱ ze̱e̱ yo à. ");
INSERT INTO uth_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Ye̱so wo̱o̱nu̱ru̱ o-Urusharima. Wu̱ wo̱o̱n, wu̱ dooru̱ m-co̱w u̱n Pyo-o̱ Shir. Bo̱ wu̱ tu̱wte̱ u̱n Pyo-o̱ Shir à, wu̱ 'wo̱ssu̱ru̱ ya-u̱t-baab ye̱ ka u̱n ya-m-o̱ ne̱. Wu̱ taknu̱ yanse̱ u̱n ye̱ u̱s-so̱ro̱g u̱s-so̱ro̱g. Wu̱ wagarsu̱ru̱ saw-to̱ u̱t-sak u̱n yan-shas-o̱ u̱n hwo̱r ne̱ u̱n de̱e̱g-to̱ u̱n ya-u̱t-baab to̱ u̱n tantabara ne̱. ");
INSERT INTO uth_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Hun-ne̱ ye̱ ro m-ma'as m-caatu̱ne̱ u̱n Pyo-o̱ Shir u̱s-saw ne̱ à, wu̱ ze̱e̱ru̱ ye̱, “No̱ do m-caatu̱ne̱ á.” ");
INSERT INTO uth_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Ka da-de ne̱, wu̱ yoosu̱ru̱ hun-ne̱, wu̱ ze̱e̱ru̱ ye̱, “A ge̱ne̱g to̱ ka ma-to̱ be-de u̱n Ma-to̱ Shir. Shir ze̱e̱g, “ ‘Hur-o re o̱ warag hur-o̱ u̱s-ko̱n be-de u̱n baag-o̱ u̱n hun-ne̱ kap ye̱ he me̱ u̱s-ko̱n à.’ No̱ muutte̱ o̱ ne̱ hur-o̱ u̱n hyow-ne̱.” ");
INSERT INTO uth_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Gwo̱mo-ne̱ ye̱ u̱n ko̱n-se Shir u̱n yan-Yoos-de u̱n karamsa-o Mosa ne̱, da-o̱ ye̱ ho̱ge̱ kaane̱ à, ye̱ ho̱o̱bu̱ru̱ o-co̱w yo ye̱ hette̱ ho̱ u̱n Ye̱so à. Ye̱ ro hyan u̱n gye̱r-o̱ u̱n wu̱, remen hun-ne̱ hyanag u̱t-hyat u̱n yoos-de u̱n wu̱. ");
INSERT INTO uth_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Bo̱ ho̱-u̱r he̱bu̱te̱ à, Ye̱so ruuru̱ o-Urusharima mo̱sse̱ u̱n yan-neke̱-mo̱ u̱n wu̱ ne̱. ");
INSERT INTO uth_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Ish gasu̱ru̱, ye̱ ro m-argu̱ne̱. Ye̱ hyambu̱ru̱ ka rum-yo. Yo hu̱'u̱ste̱ gaw u̱n geer-se u̱n yo ne̱. ");
INSERT INTO uth_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Ka da-de ne̱, Bitrus baksu̱ru̱ bo̱ Ye̱so ze̱e̱ ka rum-yo à. Wu̱ ze̱e̱ru̱ Ye̱so, “Wa-u̱s-Nap, gwo̱t! Ka rum-yo o hu̱u̱ nu à, ai, yo hu̱'u̱ste̱ gaw, kap u̱s-geer ne̱.” ");
INSERT INTO uth_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Ye̱so shasu̱ru̱ yan-neke̱-mo̱ u̱n wu̱, wu̱ ze̱e̱ru̱, “She̱r no̱ be-de Shir. ");
INSERT INTO uth_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Nip-o̱ me̱ no̱ m-ru̱re̱, ne̱t-wu̱ de̱ke̱ Ma-to̱ Shir hur-u̱r gaan à wu̱a zee ka haag-o̱ ‘Wuksu̱nde o he̱'e̱be̱ n-me̱ m-sa.’ No̱a hyenes ma-to̱ u̱n wu̱ to̱a bu̱p o-nip to̱ wu̱ ze̱e̱ à. Amba wu̱ she̱re̱ u̱r-hur á, yatt-yo he m-nome̱ á. ");
INSERT INTO uth_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Remen kaane̱, me̱ no̱ m-ru̱re̱, ko̱yan no̱ ko̱ne̱ be-de Shir, de̱k no̱ u̱nze no̱ regu̱su̱te̱ no̱ go̱ksu̱ssu̱te̱ yo. Ka da-de ne̱, no̱a hyen a ya'aste̱ no̱ ka rii-yo no̱ ko̱ne̱ à. ");
INSERT INTO uth_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Da-o̱ no̱ ro u̱n ko̱n-se Shir, u̱rege̱ wu̱ ken ro̱ ko̱n wu̱ no̱ m-hyan ryaab-se u̱n wu̱ à, no̱ soksu̱ wu̱ ba'as-to̱ u̱n wu̱, remen Tato no̱ wu̱ ro̱ n-To̱n shir à, wu̱ soksu̱tú̱ no̱ ba'as-u̱t no̱.” ");
INSERT INTO uth_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Ye̱ mu̱u̱nu̱ru̱ o-Urusharima komo, Ye̱so ma'asu̱ru̱ u̱t-tu̱w n-me̱ u̱n Pyo-o̱ Shir. Ye̱ ken ye̱ haanu̱ru̱ be-de u̱n wu̱. Gwo̱mo-ne̱ ye̱ u̱n ko̱n-se Shir ye̱ ro̱ ko̱n be-de u̱n ye̱ u̱n yan-Yoos-de u̱n karamsa-o Mosa ne̱ u̱n se̱k-ye̱ ye̱ u̱n Yahuda-ne̱. ");
INSERT INTO uth_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Ye̱ citu̱ru̱ wu̱, ye̱ ze̱e̱ru̱, “¿Wan wu̱ ne̱ ya'e̱ wo̱ 'wo̱ns-mo̱ wo̱tte̱ u̱n no̱m u̱n go̱n ka rem-se?” ");
INSERT INTO uth_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Ye̱so waksu̱ru̱ ye̱, wu̱ ze̱e̱ru̱, “Me̱ eb re, yage̱ u̱m m-cit no̱ o-cot. Shas no̱ me̱. No̱ shesu̱ me̱, man ru̱ru̱ no̱ wu̱ ya'e̱ me̱ 'wo̱ns-mo̱ u̱n no̱m u̱n ka rem-se à. ");
INSERT INTO uth_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","¿Wan wu̱ ne̱ ya'e̱ Yohana u̱t-gwo̱mo to̱ u̱n yo'os u̱n hun-ne̱ m-ho̱: Shir ko̱ hun-ne̱?” ");
INSERT INTO uth_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Bo̱ ye̱ ho̱gu̱te̱ cot-o̱ u̱n wu̱ à, ma-u̱t su̱nu̱ru̱ ye̱ u̱n hi u̱n de u̱n ye̱. Ye̱ ze̱e̱ru̱, “A zee ‘Shir, wu̱ u̱n n-To̱n shir to̱mne̱ Yohana,’ wu̱a zee na, ‘¿Ya hante̱ no̱ de̱kte̱ ma-u̱t Yohana á?’ ");
INSERT INTO uth_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","¿Amba a hoks m-ze̱e̱, ‘Hun-ne̱ ye̱ to̱mne̱ Yohana’? A hoks m-ze̱e̱ kaane̱ á.” Ye̱ u̱n ho̱ge̱ u̱n gye̱r-o̱ u̱n hun-ne̱, remen ye̱ nepste̱ Yohanawan-Rwo̱r u̱n Ma-to̱ Shir wu̱. ");
INSERT INTO uth_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Remen kaane̱, ye̱ waksu̱ru̱ Ye̱so, ye̱ ze̱e̱ru̱, “Te̱ nap á.” Ye̱so ne̱ wu̱ ze̱e̱ru̱ ye̱, “To̱, cin da no̱ nepte̱ wu̱ to̱mne̱ Yohana á, me̱ eb re, man ru̱ru̱ no̱ wu̱ ya'e̱ me̱ 'wo̱ns-mo̱ u̱m nomte̱ ka rem-se á.” ");
INSERT INTO uth_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Ka da-de ne̱, Ye̱so taknu̱ ye̱ m-yoose̱ u̱n sha-mo̱ u̱t-ma. Wu̱ ze̱e̱ru̱ ye̱, “Wu̱ ken ne̱t-wu̱ go̱'e̱ kat-o̱ u̱n anab. Wu̱ rigimsu̱ru̱ o̱ u̱n gagan. Wu̱ hinu̱ru̱ o-kuub remen wu̱ pot ho̱-mo̱ u̱n anab. Wu̱ no̱mu̱ru̱ sak-o̱ m-pipir remen u̱r-'er. Bo̱ wu̱ komse̱ à, wu̱ ya'asu̱ru̱ ya-to̱m ka kat-o̱. Ka da-de ne̱, wu̱ argu̱ru̱ m-neke̱ o̱ ken dak-o̱. ");
INSERT INTO uth_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Da-o̱ anab nense̱ à, wa-o-kat to̱mu̱ru̱ ko-gu̱w-wu̱ u̱n wu̱ be-de u̱n ka ya-to̱m-ye̱, wu̱ deknu̱ wu̱ kwu̱kwu̱r-de u̱n wu̱. ");
INSERT INTO uth_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Bo̱ ka ko-gu̱w-wu̱ wo̱o̱ne̱ be-de u̱n ya-to̱m à, ye̱ shipu̱ru̱ wu̱. Ye̱ bu'u̱ru̱ wu̱, ye̱ yanu̱ru̱ wu̱. Wu̱ argu̱ru̱ m-ji u̱t-kom m-zar. ");
INSERT INTO uth_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Ka da-de, wa-o-kat dooru̱ m-to̱m u̱n wu̱ ken ko-gu̱w-wu̱ u̱n ho̱n. Ka ko-gu̱w-wu̱ a do m-to̱m à, ye̱ ce̱ru̱ru̱ wu̱ u̱r-hi. Ye̱ reesu̱ru̱ wu̱ u̱r-ko̱o̱b. ");
INSERT INTO uth_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Wa-o-kat dooru̱ m-to̱m u̱n wu̱ ken wu̱. Amba ka wu̱ a do m-to̱m à, ye̱ ho̱o̱ru̱ wu̱. Kaane̱ o̱, ye̱ nome̱ ye̱ ken ye̱ de̱e̱n. Ye̱ bu'u̱ru̱ ye̱ ken ye̱, ye̱ homu̱ru̱ ye̱ ken ye̱. ");
INSERT INTO uth_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","“M-mo̱ka ne̱ wa-o-kat taagu̱te̱ wan-to̱m, se̱ wà u̱n wu̱ u̱n ho̱n-de u̱n wu̱, wu̱ wu̱ co̱ne̱ à. Wu̱ ze̱e̱ru̱ u̱n hur-de u̱n wu̱, ‘Kay, ka ya-to̱m-ye̱ ye̱a hyen 'e̱-m wà re.’ Ka da-de ne̱, wu̱ to̱mu̱ru̱ wà u̱n wu̱. ");
INSERT INTO uth_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","“Amba ka ya-to̱m-ye̱ ze̱e̱ru̱ u̱n hi u̱n de u̱n ye̱, ‘Wà-wu̱ u̱n wa-o-kat-wu̱ ka. Haan no̱ a ho no̱ wu̱ remen cim-yo u̱n wu̱ waragté̱ yo ma na.’ ");
INSERT INTO uth_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Ye̱ shipu̱ wu̱. Ye̱ ho̱o̱ru̱ wu̱. Ye̱ jorbu̱ru̱ u-de u̱n wu̱ pesto-de o-gagan.” ");
INSERT INTO uth_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Bo̱ Ye̱so komte̱ ye̱ m-ru̱re̱ u̱n ka ma-to̱ à, wu̱ citu̱ru̱ ye̱. Wu̱ ze̱e̱ru̱, “To̱, ¿ya ne̱ wa-o-kat he m-no̱m? Se̱ wu̱ haante̱ wu̱ ho-m ka ya-to̱m-ye̱, wu̱ ya'as ye̱ ken ye̱ ka kat-o̱.” Ye̱so dooru̱ ye̱ m-ru̱re̱ u̱t-ma. Wu̱ ze̱e̱ru̱, ");
INSERT INTO uth_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","“No̱ karantu̱te̱ be-de u̱n Ma-to̱ Shir u̱nze, “ ‘Ta'ar-de ya-u̱t-ma jore̱ à, a muste̱ de kashi u̱r-ta'ar de u̱t-ma. ");
INSERT INTO uth_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Mo̱ ka se̱nge̱-mo̱ u̱n Yawe mo̱. Be u̱n na ne̱ rii-yo u̱t-hyat yo.’ ” ");
INSERT INTO uth_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Bo̱ Ye̱so ru̱ru̱te̱ ye̱ kaane̱ à, se̱k-ye̱ be-de u̱n Yahuda-ne̱ ye̱ napu̱ru̱ u̱nze ye̱ wu̱ tane̱ be-de u̱n ka sha-mo̱ u̱t-ma to̱. Remen kaane̱, ye̱ hoborte̱ o-co̱w ye̱ shipt wu̱. Amba bo̱ ye̱ hyente̱ hun-ne̱ u̱t-mo̱o̱r ne̱ à, gye̱r-o re̱e̱ru̱ ye̱. Ye̱ e̱s wu̱ m-ship á. Ye̱ yagu̱ru̱ wu̱. Ye̱ argu̱ru̱ arag-mo̱ u̱n ye̱. ");
INSERT INTO uth_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Ka da-de ne̱, ye̱ to̱mu̱ru̱ wu̱ ye̱ ken hun-ne̱ ye̱. Ye̱ ro u̱n hoob-o̱ u̱r-taab remen ye̱ shipt wu̱, be-de u̱n ma-to̱ u̱n wu̱. Parisa-ne̱ ro kon u̱n hun-ne̱ ko-Gwo̱mo Here̱ ne̱. ");
INSERT INTO uth_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Bo̱ ye̱ wo̱o̱bu̱te̱ à, ye̱ ze̱e̱ru̱ wu̱, “Wa-u̱r-Yoos, te̱ nepste̱ wo̱ wa-o-nip-wu̱ o ro̱. Wo̱ u̱n koos u̱n ne̱t á. Be u̱n du ne̱ yatt-wu̱ jiishe̱ wu̱ ken á. Wo̱ u̱n yoose̱ u̱n hun-ne̱ co̱w-yo Shir o-nip ne̱.” Bo̱ ye̱ nomte̱ u̱t-ma kaane̱ à, ye̱ citu̱ru̱ wu̱. Ye̱ ze̱e̱ru̱, “¿Hond hond o̱ te̱ to̱p ko-Gwo̱mo Sisar hwo̱r-ye̱ u̱n tar? ¿Te̱ to̱p, ko̱ te̱ to̱p á?” ");
INSERT INTO uth_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Ye̱so ne̱, bo̱ wu̱ nepte̱ she̱pe̱-o̱ u̱n ye̱ à, wu̱ citu̱ru̱ ye̱. Wu̱ ze̱e̱ru̱, “¿Ya u̱n yo ne̱ no̱tte̱ me̱ m-ce̱e̱b? Hantu̱ no̱ me̱ hwo̱r u̱m gu̱t.” ");
INSERT INTO uth_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Ye̱ hantu̱ru̱ wu̱ hwo̱r. Wu̱ ze̱e̱ru̱ ye̱, “¿Ho̱to̱-o wan o̱ ne̱ u̱n jin-u̱r wan ne̱ no̱ hyane̱ káne̱?” Ye̱ waksu̱ru̱ wu̱. Ye̱ ze̱e̱ru̱, “Ai, ho̱to̱-o ko-Gwo̱mo Sisar o̱. Jin-de u̱n wu̱ de te̱ hyane̱ káne̱.” ");
INSERT INTO uth_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Bo̱ ye̱ waksu̱te̱ wu̱ kaane̱ à, Ye̱so ze̱e̱ru̱ ye̱, “Ya'as no̱ ko-Gwo̱mo Sisar rii-yo ro̱ yo ma Sisar à. Komo no̱ ya'as Shir rii-yo ro̱ yo Shir à.” Bo̱ ka hun-ne̱ ye̱ ho̱gu̱te̱ káane̱ à, ye̱ hyanu̱ru̱ hyat-to̱ u̱n wu̱ de̱e̱n. ");
INSERT INTO uth_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Ye̱ ken hun-ne̱ ye̱ ro kon tomso. A ye̱ m-ze̱e̱ Saduki-ne̱. (Ye̱ ro̱ m-ze̱e̱ margan-ne̱ ye̱a ine̱ be-de m-mar á.) Ye̱ haanu̱ru̱ be-u̱r Ye̱so. Ye̱ citu̱ru̱ wu̱. ");
INSERT INTO uth_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Ye̱ ze̱e̱ru̱ wu̱, “Wa-u̱r-Yoos o̱, te̱ o-cot ne̱ te̱ cit wo̱. Mosa genu̱tu̱ te̱ ka karamsa-o̱ u̱nze se̱k-wu̱ mere̱, ba ye̱ u̱n mat u̱n ne'a u̱n wu̱, depete̱ heno u̱n wu̱ ge ka ne'a-wu̱, wu̱ metu̱té̱ se̱k-wu̱ yakar. ");
INSERT INTO uth_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","O̱ ken den-o̱, a makt yan-campo̱-ne̱ ne̱n ta'yoor. Mat-de co gaaru̱ ne'a. Ye̱ ro wo̱o̱g kum u̱n yakar á, campo̱ maru̱ru̱. ");
INSERT INTO uth_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Heno u̱n wu̱ su̱gu̱ru̱ ka ne'a-wu̱. Tomso ne̱, ye̱ kum yakar á, ka heno-o̱ dooru̱ m-mar. Wu̱ do̱nde̱ wu̱ à, ká bo̱-se ne̱ tomso ne̱, ka heno-o̱ dooru̱ m-mar ba u̱n yakar. ");
INSERT INTO uth_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Har ka ne̱n ta'yoor-ye̱, kap mo̱ u̱n ye̱, ye̱ ga'e̱ ka ne'a-wu̱ à, ye̱ meru̱msu̱ru̱. Be-de u̱n ye̱ yatt-wu̱ kume̱ yakar á. Komo ká ne'a-wu̱ ye̱ ga'e̱ à, wu̱ dooru̱ m-mar. ");
INSERT INTO uth_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","To̱, ho̱-de m-ine̱ mo̱ u̱n margan-ne̱, be-de u̱n ka ne̱n ta'yoor-ye̱, ¿wan wu̱ ne̱ wan ka ne'a gaan wu̱ remen kap mo̱ u̱n ye̱, ye̱ geeste̱ wu̱?” ");
INSERT INTO uth_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Ye̱so waksu̱ru̱ ye̱, wu̱ ze̱e̱ru̱, “No̱ nap Ma-to̱ Shir á. No̱ napu̱ ne̱ be̱e̱b-de Shir á. ");
INSERT INTO uth_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Ho̱-de m-ine̱ mo̱ u̱n margan-ne̱ a u̱n ga u̱t-ge á. Hun-ne̱ a warag u̱ntu̱n yan-to̱m-ye̱ Shir n-To̱n shir. ");
INSERT INTO uth_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","U̱rege̱ ne̱ no̱a cit me̱ ma-to̱ u̱n ine̱-mo̱ u̱n margan-ne̱, ¿No̱ we̱t m-karante̱ taku̱rda-o̱ Mosa ge̱ne̱ á? Wu̱ ru̱ru̱ na u̱nze wu̱ ho̱gu̱te̱ co̱r-o̱ Shir n-te̱ yokor-o yar-yo. Shir ze̱e̱g wu̱, ‘Me̱ Shir Ibrahi wu̱ u̱m ro̱. Komo wu̱ ma Ishaku wu̱ u̱m ro̱, kap u̱n Yakubu ne̱.’ ");
INSERT INTO uth_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Wu̱ ba Shir o̱ u̱n hun-ne̱ margan-ne̱ á, amba Shir o̱ u̱n yan-ho̱o̱g. No̱ ba'asu̱te̱ de̱e̱n.” ");
INSERT INTO uth_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Wu̱ ken wan-Yoos-de u̱n karamsa-o Mosa wu̱ hyoknu̱ru̱ be-de u̱n ye̱. Wu̱ ho̱gu̱ru̱ ma-u̱t su̱nu̱te̱ Saduki-ne̱. Bo̱ wu̱ ho̱gu̱te̱ Ye̱so shaks ye̱ u̱r-bon ne̱ à, wu̱ citu̱ru̱ Ye̱so. Wu̱ ze̱e̱ru̱, “¿O̱ ke karamsa-o̱ jiishe̱ m-'wo̱ns?” ");
INSERT INTO uth_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Ye̱so ze̱e̱ru̱ wu̱, “Karamsa-o̱ jiishe̱ m-'wo̱ns à, o̱ ka: ‘Ho̱ge̱ no̱ hun-ne̱ ye̱ u̱n dak-o̱ o-Isra! Yawe Shir na. Gwo̱mo-u̱t ro̱ ko̱n á, se̱ Yawe u̱n ho̱n-de u̱n Wu̱. ");
INSERT INTO uth_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Was Yawe Shir ru. Was u̱n wu̱ ne̱ u̱n hur-u̱r u̱n du ne̱ kap, u̱n kap o̱ u̱n ho̱o̱g ru ne̱, u̱n kap nap-u̱s ru ne̱, komo u̱n 'wo̱ns-m ru ne̱.’ ");
INSERT INTO uth_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ho̱ge̱ no̱ karamsa-o ayoore̱-o̱ tomso ne̱, ‘Se̱ no̱ was o̱r no̱ ne̱ m-so̱k ne̱ bo̱ no̱ wasse̱ hi u̱n no̱ à.’ Yatt karamsa-to̱ jiishe̱ to̱ ka yoor-to̱ m-'wo̱ns á.” ");
INSERT INTO uth_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Bo̱ ka wan-Yoos-de u̱n karamsa-o Mosa wu̱, ho̱gu̱te̱ shas-o Ye̱so à, wu̱ ze̱e̱ru̱, “Ka o̱, Wa-u̱r-Yoos, o rwo̱ro̱g o-nip. Shir o̱ ro̱ ko-Gwo̱mo na. Gwo̱mo-u̱t ro̱ ko̱n á, se̱ Shir u̱n ho̱n-de u̱n o̱. ");
INSERT INTO uth_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Depete̱ ne̱t was wu̱ kap u̱n hur-u̱r gaan, u̱n nap-se u̱n wu̱ ne̱ kap komo u̱n 'wo̱ns-mo̱ u̱n wu̱ ne̱ kap, komo wu̱ was u̱n yan-bo̱r-se u̱n wu̱ ne̱ bo̱ wu̱ ro̱ m-was u̱n hi u̱n de u̱n wu̱ à. O̱ aragte̱ kap yar-mo̱ wu̱ ya'ase̱ Shir à u̱n rem-se a tu̱kse̱ ne̱ be-de u̱r-seke̱ à.” ");
INSERT INTO uth_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Ye̱so napu̱ru̱ ka ne̱t-wu̱ shaks wu̱ u̱s-nap ne̱. Wu̱ ze̱e̱ru̱ wu̱, “Kuks wo̱ hiin o tu̱wu̱t be-de u̱n gwo̱mo-to̱ Shir.” Bo̱ Ye̱so ru̱ru̱tu̱ wu̱ kaane̱ à, yatt-wu̱ kume̱ jaab-o̱ u̱t-me̱n wu̱ cit wu̱ yo ken rii-yo á. ");
INSERT INTO uth_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Bo̱ Ye̱so ro u̱r-yoos u̱n Pyo-o̱ Shir à, wu̱ citu̱ru̱ o-cot, “¿Re o̱ yan-Yoos-de o-karamsa zette̱ u̱nze Kiristi, wà Dawuda wu̱? ");
INSERT INTO uth_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Ku̱kt-o̱ Shir rwo̱'o̱g Dawuda m-ze̱e̱: “ ‘Yawe ze̱e̱g Wan-Ko̱yan re: “She'et kàne̱ so̱ u̱n kom-o̱ u̱n re̱ u̱n de se̱ u̱m rwo̱'o̱g yan-yage̱-u̱t ru u̱n ku̱s-o̱ u̱n na-o ru.” ’ ");
INSERT INTO uth_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Dawuda u̱n hi u̱n de u̱n wu̱ ak wu̱, ‘Wan-Ko̱yan,’ u̱rege̱ ka o̱, ¿Re o̱ Wan-Gwu̱ he m-warag wà Dawuda?” Hun-ne̱ de̱e̱n ho̱gu̱te̱ wu̱ zak-o-zak. ");
INSERT INTO uth_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Bo̱ wu̱ yoose̱ ye̱ à, wu̱ ze̱e̱ru̱, “No̱m no̱ ja u̱n yan-Yoos-de u̱n karamsa-o Mosa ne̱, yan-co̱n-to̱ u̱t-tu̱w u̱n carri-to̱ u̱t-co̱p ne̱, u̱n co̱n-to̱ u̱n gas-de m-se̱e̱b ne̱ be-de u̱t-baab. ");
INSERT INTO uth_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Ye̱ he u̱n kuke̱-to̱ u̱n yoos u̱n Ma-to̱ Shir, ko̱ o-biki, ye̱ ro̱ u̱n ma'as u̱n hoob-o̱ u̱n de̱e̱g-to̱ u̱r-bon remen ye̱ she'etté̱ she'et-de m-nu̱. ");
INSERT INTO uth_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Myet u̱n kaane̱ ye̱ ro̱ u̱n ku̱u̱s u̱n saw-to̱ u̱n gwo̱r-ne̱. Ye̱ ro̱ m-she'et de̱e̱n u̱n ko̱n-se Shir remen a zeet ye̱ yan-do̱re̱ u̱n Shir ye̱ hur-u̱r gaan. Ye̱, a he ya-u̱r-ko̱o̱b de jiishe̱ à.” ");
INSERT INTO uth_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Bo̱ Ye̱so she'ete̱ yow yow be-de a u̱n he̱'e̱dbe̱ m-yar à, wu̱ ma'asu̱ m-gwo̱t u̱n hun-ne̱ de̱e̱n bo̱ ye̱ m-he̱'e̱dbe̱ u̱n hwo̱r à. Ya-o-kwu̱m he̱'e̱dbu̱ru̱ hwo̱r de̱e̱n. ");
INSERT INTO uth_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Ka da-de, wu̱ ken ko-ko̱o̱b-wu̱ ko-gwo̱r haanu̱ru̱ wu̱ he̱'e̱dbu̱ru̱ ne̱ra u̱t-yoor. ");
INSERT INTO uth_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Ye̱so agnu̱ru̱ yan-neke̱-mo̱ u̱n wu̱ be-u̱r gaan. Wu̱ ze̱e̱ru̱ ye̱, “Me̱ no̱ m-ru̱re̱ o-nip, ka ko-gwo̱r-wu̱ ko-ko̱o̱b he̱'e̱dbu̱te̱ yo jiishe̱ à n-me̱ u̱n be-de a he̱'e̱dbe̱ m-yar, arge̱ ko̱wan. ");
INSERT INTO uth_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","U̱m ze̱e̱g yo kà remen ye̱ ken ye̱ he̱'e̱dbu̱te̱ hiin be-de u̱n yo ro̱ ye̱ de̱e̱n à be-de u̱n kwu̱m-o̱ u̱n ye̱. Amba wu̱, myet u̱n ko̱o̱b-de u̱n wu̱ ne̱ wu̱ he̱'e̱dbu̱te̱ myet yo ro̱ wu̱ à. Wu̱ ya'aste̱ kap yo wu̱ ro̱tte̱ à.” ");
INSERT INTO uth_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Ye̱so ro m-rwu̱u̱n u̱n Pyo-o̱ Shir, be-de u̱n yan-neke̱-mo̱ u̱n wu̱, wan-gaan citu̱ru̱ wu̱. Wu̱ ze̱e̱ru̱, “Wa-u̱r-Yoos, gwo̱t go̱n ka ta'ar-to̱, u̱n ka caari-to̱ u̱t-ma to̱ ne̱.” ");
INSERT INTO uth_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Ye̱so ze̱e̱ru̱, “¿No̱ hyanag ka caari-to̱ u̱t-ma to̱? Kap ka ta'ar-to̱ ro̱ kane̱ à, a wugurse̱ to̱. Yatt ta'ar-de a he m-yage̱ n-to̱n u̱n o̱r u̱n de á.” ");
INSERT INTO uth_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Bo̱ jimite̱ à, Ye̱so ro tara u̱n Haag-o̱ u̱n 'yo-se o-Ze̱tun, ka haag-o̱ ro̱ u̱n gwo̱tbe̱ u̱n Pyo-o̱ Shir à. Se̱ ye̱ ken ye̱ be-de u̱n yan-neke̱-mo̱ u̱n wu̱, (Bitrus wu̱, Yakubu wu̱, u̱n Yohana ne̱, u̱n Andarawus ne̱), ye̱ citu̱ru̱ wu̱ pakse̱. ");
INSERT INTO uth_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","Ye̱ ze̱e̱ru̱, “Te̱ co̱no̱g o ru̱ru̱ te̱ ¿o̱ ke da-o̱ ne̱ a he m-no̱m u̱n se ka rem-se? ¿Yo ke rii-yo ne̱ he te̱ m-kute̱ da-o̱ ka rem-se he m-ko̱r à?” ");
INSERT INTO uth_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Ka da-de ne̱, Ye̱so taknu̱ ye̱ m-yoose̱. Wu̱ ze̱e̱ru̱, “Muut no̱ u̱t-hi, taasu̱ ne̱t e̱e̱s no̱ á. ");
INSERT INTO uth_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Hun-ne̱ de̱e̱n ye̱a haan be u̱n no̱, ye̱ dek jin u̱n de. Ko̱ wu̱ ke wu̱ ro̱ m-ze̱e̱ wu̱ ro̱ Kiristi. Ye̱a e̱e̱s hun-ne̱ de̱e̱n. ");
INSERT INTO uth_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Tomso, no̱ ho̱ge̱ a u̱n ma-to̱ u̱r-gu̱n, to̱ ken to̱ yow yow, to̱ ken to̱ u̱r-hyew ne̱, no̱ jar no̱ ho̱ge̱ o-gye̱r á. Se̱ ka rem-se takante̱, amba a u̱n go hyan ta-de u̱n ho̱no o-dak á. ");
INSERT INTO uth_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Ka da-de ne̱, hun-ne̱ a heete̱ hun-ne̱ u̱r-gu̱n. Gwo̱mo-u̱t a heete̱ u̱t-gwo̱mo u̱r-gu̱n. Dak-o a nukte̱ to̱ ken be-to̱ u̱n ho̱n u̱n ho̱n. Me̱r a reese̱ hun-ne̱ u̱r-ko̱o̱b. Ka rem-se kap, takan-de u̱n re̱ u̱r-ko̱o̱b de ka, bo̱ hoog-mo̱ o-mat ro̱ m-takan à har argu̱ru̱ kaane̱. ");
INSERT INTO uth_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Remen no̱ yan-neke̱-m re ye̱, ‘She'et no̱ zo̱ngse̱!’ Hun-ne̱ a eeg no̱ be-de u̱n yan-piish u̱t-ma. Ye̱a bu no̱ m-dum n-me̱ u̱n kuke̱-to̱ u̱n yoos u̱n Ma-to̱ Shir. Hun-ne̱ a eeg no̱ be-de u̱n gwamna-ne̱ u̱n gwo̱mo-ne̱ ne̱. Ye̱a nom yo kà remen no̱ yan-neke̱-m re ye̱. Amba kap u̱n kaane̱ ne̱, no̱a kum o-co̱w remen no̱ ru̱ru̱tú̱ ye̱ Ma-to̱ m-Re̱re̱m to̱ Shir. ");
INSERT INTO uth_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Rii-yo ka rem-se takante̱, a ru̱re̱ baag-to̱ u̱n hun-ne̱ kap Ma-to̱ m-Re̱re̱m to̱ Shir. ");
INSERT INTO uth_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Da-o̱ a he no̱ m-ship à, a heete̱ no̱ be-de u̱n yan-piish u̱t-ma. Rii-yo no̱ neku̱te̱ no̱ jar no̱ ryegen u̱n rii-yo no̱ he m-rwo̱r á. U̱n ka da-o̱, kap rii-yo Shir ya'e̱ no̱ à, yo no̱ he m-rwo̱r remen no̱ ye̱ ro̱ te̱p u̱n hi u̱n no̱ á. Ku̱kt-o̱ Shir o̱ ro̱ te̱p be u̱n no̱. ");
INSERT INTO uth_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","“U̱n ka da-o̱ ne̱, se̱k-wu̱ wu̱a ya'as heno u̱n wu̱ a hoot wu̱. O-tato tomso ne̱ o̱a ya'as wà u̱n o̱. Yakar ye̱a ine̱ eso ye̱ ru̱r rii-yo tat-ne̱ ye̱ u̱n ye̱ u̱n in-ne̱ ye̱ u̱n ye̱ ne̱ no̱me̱ à yo u̱n ba u̱r-bon har ye̱a ru̱ a ho ye̱. ");
INSERT INTO uth_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Ko̱ wu̱ ke ne̱t-wu̱ wu̱a yage̱ no̱ remen no̱ yan-neke̱-m re ye̱. Amba kap wu̱ hokse̱ m-gaag u̱n me̱n-to̱ u̱n wu̱ har ta-de u̱n ho̱o̱g-o̱ u̱n wu̱ à, wu̱a po̱sse̱ ra-o̱ Shir. ");
INSERT INTO uth_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Wu̱ karu̱nte̱ ka ma-to̱ à, yage̱ wu̱ nep to̱. ‘No̱a hyen a she̱re̱g yo ken rii-yo Shir yage̱ à, be-de u̱depe̱ a sher yo á.’ Yoa naas Pyo-o̱ Shir. No̱ hun-ne̱ ye̱ ro̱ u̱n dak-o̱ o-Judiya à, no̱ hyene̱ ka rii-yo, no̱ som be-de u̱t-haag. ");
INSERT INTO uth_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Wu̱ ro̱ tara n-to̱n u̱r-do̱o̱b de o-kuke̱ o̱ u̱n wu̱ à, wu̱ kergene̱ á taase wu̱ cu̱w n-me̱ o-kuke̱, remen wu̱ de̱ke̱nté̱ to̱ ken saw-to̱ to̱ ro̱ n-me̱ á. ");
INSERT INTO uth_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Wu̱ ro̱ o-kat à, wu̱ jar wu̱ warag de̱k u̱r-matuku o-hur á. ");
INSERT INTO uth_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","U̱n ká ho̱-to̱, ne'a-ne̱ yan-yakar-ye̱ ro̱ u̱n su u̱r-de̱ à, u̱n ya-u̱t-uub ne̱ ye̱a su̱ u̱r-ko̱o̱b. ");
INSERT INTO uth_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","No̱ ko̱n Shir taase ka rem-se wo̱o̱n no̱ da-o̱ o-go̱s. ");
INSERT INTO uth_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Remen go̱n ka su̱ u̱r-ko̱o̱b de, u̱n ká ho̱-to̱ a jiish cin da-o̱ Shir no̱me̱ ho̱no o-dak à. Komo a do de m-no̱m n-co á har da-o̱ ba m-ta. ");
INSERT INTO uth_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Amba Wan-Ko̱yan hak ka ho̱-to̱ u̱n su̱ u̱r-ko̱o̱b to̱. A ro ze̱e̱ge̱ remen kaane̱ á, yatt ne̱t-wu̱ ro̱a kus á. Remen co̱n-to̱ u̱n ká ye̱ Shir daage̱ à, o̱ rwo̱'e̱ wu̱ hept ka su̱ u̱r-ko̱o̱b o̱. ");
INSERT INTO uth_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","U̱n ka da-o̱, ne̱t zee no̱, ‘Kiristi, wu̱ ka kane̱,’ ko̱ wu̱ ken ne̱t-wu̱ zee no̱, ‘Wu̱ ka re̱e̱no̱,’ no̱ jar no̱ dek ma-to̱ u̱n wu̱ á. ");
INSERT INTO uth_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Yan-rwo̱r u̱n ma-to̱ Shir ye̱ u̱t-bo̱ ye̱a ine̱, wu̱ ken a zee, ‘Me̱ ro̱ Kiristi,’ har ye̱a kute̱ no̱ caari-to̱ u̱t-hyat u̱n se ken rem-se u̱s-myot se ne̱ se no̱ ce̱te̱ m-hyan á. Ye̱ ro̱ m-no̱m u̱n ka rem-se remen ye̱ e̱e̱ste̱ ye̱ Shir daage̱ à, o̱ rwo'e̱ ye̱ hokste̱. ");
INSERT INTO uth_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Amba ma'as no̱ zo̱ngse̱. U̱m ru̱ssu̱te̱ no̱ ma-to̱ u̱n ka rem-se ba se̱ u̱n takan.” ");
INSERT INTO uth_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Da-o̱ a komse̱ swo̱ u̱r-ko̱o̱b, u̱n ká ho̱-to̱, “ ‘ho̱-u̱r a nom o-comb. O-re̱ng komo yoa do no̱m o-mo̱k á. ");
INSERT INTO uth_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Re̱ge̱n a ma'as m-he'emende̱ n-dak. Bo̱n rem-se Shir hwo̱o̱ne̱ n-ku̱s o̱ Shir à, se à nuktusse̱.’ ");
INSERT INTO uth_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","“Ka da-de ne̱, hun-ne̱ de̱e̱n ye̱a hyen me̱ Wà-wu̱ u̱n ne̱t, me̱ m-neke̱ ne̱ n-me̱ u̱t-ke'ente̱ u̱t-go̱s ne̱ u̱n caari-mo̱ m-cecas ne̱ mo̱ u̱r-bon. ");
INSERT INTO uth_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ka da-de ne̱, man to̱mo̱n yan-to̱m-ye̱ Shir, ye̱ kargu̱nse̱ ka ye̱ wu̱ daage̱ à, ya-u̱r-ho̱rim u̱n ya-u̱r-ho̱ran ne̱ u̱n yan-so̱-o-baar ne̱ o-ye'er ne̱, yan ko̱ kene̱ ye̱ Shir daage̱ à, yan-to̱m-ye̱ Shir a kargu̱nse̱ ye̱. ");
INSERT INTO uth_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“M-mo̱ka, yoos no̱ yo ken yo be-de o-rum. Da-o̱ no̱ hyene̱ jet-se u̱n yo cirig m-tu̱pne̱, nap no̱ u̱nze go̱s-o nomoste̱ yow yow. ");
INSERT INTO uth_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Remen kaane̱ da-o̱ no̱ hyene̱ kà rem-se ro̱ m-takan, no̱ nak o̱ ka u̱nze da-o woosu̱nte̱ yow yow. ");
INSERT INTO uth_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Nip-o̱ me̱ no̱ m-ru̱re̱, kà zaman-yo yoa te á se̱ ka rem-se kap se nomoste̱. ");
INSERT INTO uth_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","To̱n-o̱ shir, o-dak ne̱ to̱a tees, amba ma-u̱t re to̱a te á. ");
INSERT INTO uth_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Amba da-o̱ ka rem-se he m-takan à, ká ho̱-de yatt-wu̱ he m-nap á. Ko̱ yan-to̱m-ye̱ Shir n-To̱n shir, ye̱ nep da-o̱ ka rem-se he m-takan á. Ko̱ Wà u̱n hi u̱n de u̱n wu̱, wu̱ nap á. Se̱ o-Tato u̱n wu̱ u̱n ho̱n-de u̱n wu̱. Wu̱ nape̱ da-o̱ se he m-takan à. ");
INSERT INTO uth_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Cin da no̱ nepte̱ da-o̱ ka rem-se he m-takan á, ma'as no̱ zo̱ngse̱, yish ho̱o̱ge̱! ");
INSERT INTO uth_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Sha-mo̱ u̱t-ma mo̱ ka. Haan-mo̱ u̱n Wà-wu̱ u̱n ne̱t, a nom u̱ntu̱n wa-o-hur wu̱ ine̱ rur u̱r-hyew à. Wu̱ wongsu̱ru̱ ya-m-se̱nge̱, ko wu̱ ke u̱n se̱nge̱-mo̱ u̱n wu̱ ne̱. Wu̱ de̱ku̱ru̱ wu̱ ken wan-gaan wu̱, wu̱ ze̱e̱ru̱ wu̱ ere̱ wu̱ o-hur, wu̱ ma'as yish ho̱o̱ge̱. ");
INSERT INTO uth_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","“Ma'as no̱ yish ho̱o̱ge̱ remen no̱ nap da-o̱ wa-o-hur he m-jo'on á. ¿Ko̱ m-rim mo̱ wu̱ he m-jo'on, ko̱ da-o pu̱rge̱, ko̱ kiit ro̱ u̱s-kan, ko̱ n-sot? ");
INSERT INTO uth_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Taase wu̱ wo̱o̱n no̱ ba o-sakto̱, no̱ m-rew. ");
INSERT INTO uth_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Ma-to̱ me̱ no̱ m-ru̱re̱ à, me̱ u̱n ru̱re̱ ko̱ wu̱ ke, wu̱ ma'as zo̱ngse̱.” ");
INSERT INTO uth_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Kuks ho̱-u̱t yoor Yahuda-ne̱ nomot biki-to̱ ye̱ ro̱ m-no̱m à Biki-o̱ m-Pas u̱n Biki-o̱ u̱t-Buro̱di to̱ ba m-Yist ne̱. Gwo̱mo-ne̱ ye̱ u̱n ko̱n-se Shir u̱n yan-Yoos-de u̱n karamsa-o Mosa ne̱ ye̱ ho̱o̱bu̱ru̱ co̱w-yo u̱n ship u̱n Ye̱so u̱r-hyow ba hun-ne̱ ye̱ u̱n nap, ye̱ hoot wu̱. ");
INSERT INTO uth_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Amba ye̱ ze̱e̱ru̱, “A ship wu̱ ho̱-de o-biki á, taase hun-ne̱ 'yons o-zaaz.” ");
INSERT INTO uth_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Ye̱so ro bo̱-o̱ o-Betanya u̱n hur-o Simo̱n ko-cim. Wu̱ ro u̱n re̱ u̱n rii-yo m-re̱, wu̱ ken ne'a-wu̱ co̱wnu̱ru̱ u̱n u̱r-batta ne̱ de u̱n no̱w-mo̱ m-shi'igin mo̱ u̱n hwo̱r de̱e̱n. Wu̱ bu̱'u̱gu̱ru̱ nu-de u̱n ka tur-de. Wu̱ duusu̱ru̱ Ye̱so mo̱ u̱r-hi. ");
INSERT INTO uth_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Bo̱ wu̱ duusu̱te̱ wu̱ mo̱ à, ye̱ ken ye̱, ye̱ ro kane̱ à, ye̱ swooru̱ u̱s-ryaab. Ye̱ ze̱e̱ru̱ o̱r u̱n ye̱ ne̱, “¿Ya hante̱ atte̱ m-naas m-no̱w kaane̱? ");
INSERT INTO uth_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","No̱w-mo̱ woose̱ ne̱t nom se̱nge̱-mo̱ u̱t-ho̱ zungu-u̱s tet 300 wu̱ kumut ka hwo̱r-ye̱. Depete̱ a beeb mo̱ a yaas ko̱o̱b-ne̱ ka hwo̱r-ye̱.” Ye̱ kangsu̱ru̱ wu̱. ");
INSERT INTO uth_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Bo̱ Ye̱so ho̱gu̱te̱ ma-to̱ u̱n ye̱ à, wu̱ ze̱e̱ru̱ ye̱, “Yage̱ no̱ wu̱. ¿Remen yan o̱ no̱tte̱ wu̱ m-rangse̱? Wu̱ nomu̱tu̱ me̱ rii-yo u̱r-bon. ");
INSERT INTO uth_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Ko̱ o̱ ke da-o̱ no̱ mo̱sse̱ u̱n ko̱o̱b-ne̱ ne̱. Da-o̱ no̱ co̱ne̱ à, ka da-o̱, no̱ he ye̱ m-'ya m-yar. Amba me̱, no̱ mo̱sse̱ u̱n me̱ ne̱ ho̱-u̱r bi á. ");
INSERT INTO uth_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Wu̱ no̱mo̱g rii-yo wu̱ hokse̱ m-no̱m à. Wu̱ duusu̱te̱ wu̱r-o re no̱w-mo̱ m-shi'igin remen zo̱nge̱-to̱ u̱n du̱k re. ");
INSERT INTO uth_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Nip-o̱ me̱ no̱ m-ru̱re̱, kap be-de a he rwo̱r u̱n Ma-to̱ m-Re̱re̱m à, ho̱no o-dak kap rii-yo ka ne'a-wu̱ no̱me̱ à, a ma'as yo m-rwo̱r remen a bakste̱ u̱n wu̱ ne̱.” ");
INSERT INTO uth_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Da-o̱ Ye̱so u̱n yan-neke̱-mo̱ u̱n wu̱ ne̱ ro̱ m-no̱m Biki-o̱ m-Pas à, Yahudas Iskariyoti, wan-gaan be-de u̱n ka o̱p u̱n yoor-ye̱, haaru̱ be-de u̱n Gwo̱mo-ne̱ ye̱ u̱n ko̱n-se Shir remen ye̱ hongsu̱té̱ bo̱ wu̱ he ye̱ bo̱bse̱ u̱n Ye̱so à. ");
INSERT INTO uth_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Bo̱ ye̱ ho̱gu̱te̱ kaane̱ à, ye̱ no̱mu̱ru̱ o-zak. Ye̱ e̱ssu̱ru̱ u̱t-ma u̱n wu̱ ne̱ ye̱a ya'as wu̱ hwo̱r. Wu̱ ne̱ wu̱ ze̱e̱ru̱ hoob-o̱ o-co̱w wu̱ ya'aste̱ Ye̱so u̱n kom-to̱ u̱n ye̱. ");
INSERT INTO uth_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","A wo̱o̱n da-o̱ u̱n ho̱-de u̱r-takan de Biki-o̱ u̱t-Buro̱di to̱ ba m-Yist, ho̱-de u̱n m-penem u̱n ca remen baks u̱n ho̱-de ye̱ rwu̱u̱nte̱ o-Masar à. Yan-neke̱-mo̱ u̱n wu̱ ye̱ ze̱e̱ru̱ wu̱. “¿Ke ne̱ o̱ o co̱ne̱ te̱ he te̱ nomo wo̱ rii-yo m-re̱ yo Biki-o̱ m-Pas?” ");
INSERT INTO uth_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Wu̱ to̱mu̱ru̱ ne̱n yoor be-de u̱n yan-neke̱-mo̱ u̱n wu̱. Wu̱ ze̱e̱ru̱ ye̱, “Co̱w no̱ o-bo̱. Da-o̱ no̱ co̱we̱, no̱ go'one̱ u̱n wu̱ ken campo̱-wu̱ ne̱. Wu̱ ro̱ u̱n tur-de m-ho̱ ne̱ u̱r-hi. No̱ do̱re̱ wu̱. ");
INSERT INTO uth_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Hur-o̱ wu̱ cu̱we̱, no̱ cu̱w no̱ zee wa-o-hur, ‘Wa-u̱r-yoos-wu̱ zee, “¿ke ne̱ o̱ wu̱ he m-comse̱ ne̱ wu̱ reet Biki-o̱ m-Pas u̱n yan-neke̱-mo̱ u̱n wu̱ ne̱?” ’ ");
INSERT INTO uth_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Wu̱a kute̱ no̱ caari-o̱ o-kuke̱ o̱ a ma'e̱ n-to̱n u̱n o̱r u̱n o̱ o-kuke̱ à. O̱ ro̱ zo̱ngse̱ u̱s-saw ne̱ n-me̱. Káane̱ o̱, no̱ he na m-nome̱ rii-yo o-biki.” ");
INSERT INTO uth_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Yan-neke̱-m Ye̱so ruuru̱. Ye̱ co̱wu̱ru̱ o-bo̱. Ye̱ 'wo̱ssu̱ru̱ bo̱ Ye̱so ru̱ru̱ ye̱ à. Ye̱ nomu̱ru̱ wu̱ rii-yo m-re̱ yo Biki-o̱ m-Pas káne̱. ");
INSERT INTO uth_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Bo̱ ho̱-u̱r he̱bu̱te̱ à, Ye̱so wo̱o̱ru̱ mo̱sse̱ u̱n ka o̱p u̱n ne̱n yoor-ye̱ ne̱. ");
INSERT INTO uth_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Ye̱ ro m-re̱ u̱n rii-yo m-re̱, Ye̱so ze̱e̱ru̱ ye̱, “Nip-o̱ me̱ no̱ m-ru̱re̱. Wu̱ ken wan-gaan-wu̱ be u̱n no̱, wu̱a ya'as me̱ u̱n kom-to̱ u̱n yan-yage̱-u̱t re, wu̱ te̱ m-re̱ te̱ u̱n wu̱ ne̱ à.” ");
INSERT INTO uth_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Me̱n-u̱t naasu̱ru̱ ye̱, ye̱ taknu̱ru̱ u̱s-cot u̱n gaan u̱n gaan. Ko̱ wu̱ ke wu̱ ze̱e̱ru̱, “¿Me̱ wu̱ o̱?” ");
INSERT INTO uth_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Wu̱ ze̱e̱ru̱ ye̱, “Wan-gaan be u̱n no̱, no̱ ne̱n o̱p u̱n yoor, wu̱ te̱tte̱ m-re̱ ko̱k-u̱r gaan à. ");
INSERT INTO uth_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Wu̱ dooru̱ ye̱ m-ze̱e̱, remen me̱ Wà-wu̱ u̱n ne̱t, man meres bo̱ a ge̱ne̱ be-de u̱n Ma-to̱ Shir à. Amba ka ne̱t-wu̱ he me̱ m-ya'as à, wu̱a su̱ u̱r-ko̱o̱b, o̱tte̱ a ro makt wu̱ u̱n ho̱no o-dak á, roa jiish wu̱.” ");
INSERT INTO uth_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Ye̱ ro u̱n re̱ u̱n rii-yo m-re̱, Ye̱so de̱ku̱ru̱ u̱r-buro̱di, wu̱ bo̱mu̱ru̱ Shir. Ka da-de ne̱, wu̱ bosru̱ru̱, wu̱ wongu̱ru̱ ye̱. Wu̱ ze̱e̱ru̱ ye̱, “Hombe̱ no̱, wu̱r-o re o̱.” ");
INSERT INTO uth_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Wu̱ de̱knu̱ru̱ ya o-ko̱k u̱n ho̱-mo̱ u̱n yakar-ye̱ u̱n 'yo-yo o-anab ne̱. Bo̱ wu̱ nomte̱ u̱r-bo̱ngo̱n be-de Shir à, wu̱ ya'asu̱ru̱ kap mo̱ u̱n ye̱. Ye̱ swo̱o̱ru̱. ");
INSERT INTO uth_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Wu̱ ze̱e̱ru̱, “Hyo-m re mo̱ mo̱ u̱n shoos u̱n swo̱r o-nu o̱ Shir su̱ru̱ no̱ à, mo̱ a he m-dusune̱ remen hun-ne̱ de̱e̱n à. ");
INSERT INTO uth_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Nip-o̱ me̱ no̱ m-ru̱re̱ man do swo̱ u̱n ho̱-mo̱ o-anab á, se̱ ka ho̱-de u̱m he m-swo̱ m-pu̱ mo̱ à, be-de u̱n Gwo̱mo-to̱ Shir à.” ");
INSERT INTO uth_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Bo̱ wu̱ komte̱ ye̱ m-ru̱re̱ kaane̱ à, ye̱ huru̱ Se̱p-o̱ u̱r-Bo̱ngo̱n de Shir. Ye̱ ruuru̱, ye̱ haaru̱ u̱n Haag-o̱ u̱n 'yo-se o-Ze̱tun. ");
INSERT INTO uth_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Ye̱so ze̱e̱ru̱ ye̱, “Kap-m no̱ no̱a som me̱. Me̱ u̱n ze̱e̱ yo ka remen a geneste̱ be-de u̱n Ma-to̱ Shir u̱nze: “ ‘A ho wa-u̱r-gu̱t de u̱n ca, u̱s-rek ca he m-caage̱.’ ");
INSERT INTO uth_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Amba da-o̱ a 'yonsu̱ me̱ u̱n ho̱o̱g ne̱, man be no̱ m-wo̱ u̱n dak-o̱ o-Gariri.” ");
INSERT INTO uth_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Bitrus ze̱e̱ru̱, “Ko̱ ye̱ som wo̱ kap, me̱ kam man som wo̱ á.” ");
INSERT INTO uth_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Ye̱so ze̱e̱ru̱ wu̱, “Nip-o̱ me̱ wo̱ m-ru̱re̱, Bitrus, ko̱ u̱n ka te̱t-mo̱ mo̱ ro̱o̱ne̱ à, rii-o̱ ke̱e̱g-yo o-kiit kenet so̱-o yoor, wo̱a nom she-mo̱ u̱n nap-u̱s re so̱ o-tet.” ");
INSERT INTO uth_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Bitrus shasu̱ru̱ m-'wo̱ns ne̱. Wu̱ ze̱e̱ru̱, “Ko̱ a roa ho me̱ mo̱sse̱ u̱n wo̱ ne̱, man no̱m she-mo̱ u̱n nap-m ru á.” Kap mo̱ u̱n ye̱ ka ye̱ ze̱e̱. ");
INSERT INTO uth_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Ye̱so ne̱ u̱n yan-neke̱-mo̱ u̱n wu̱ ne̱, bo̱ ye̱ heete̱ u̱n Haag-o̱ u̱n 'yo-se o-Ze̱tun à, ye̱ wo̱o̱ru̱ de ken tuk-de de a m-ze̱e̱ o-Gese̱mani à. Ye̱so ze̱e̱ru̱ ye̱, “She'et no̱ kàne̱, u̱m konoste̱ Shir.” ");
INSERT INTO uth_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Wu̱ de̱ku̱ru̱ Bitrus u̱n Yakubu u̱n Yohana ne̱, wu̱ taknu̱ swo̱r u̱r-ko̱o̱b de̱e̱n. Wu̱ ro u̱s-barag, me̱n-u̱t naasu̱te̱ wu̱ de̱e̱n. ");
INSERT INTO uth_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Wu̱ ze̱e̱ru̱ ye̱, “Me̱n-u̱t naasu̱te̱ me̱ de̱e̱n. Wo̱ hyene̱, o zee me̱tt ho̱o̱g á. Wasu̱ no̱ me̱ kàne̱, no̱ she'et zo̱ngse̱.” ");
INSERT INTO uth_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Wu̱ argu̱ru̱ co hiin. Bo̱ wu̱ arge̱ o-co à, wu̱ kwu̱ktu̱ru̱ n-dak, wu̱ ko̱nu̱ru̱ Shir. Wu̱ ze̱e̱ru̱, “¿Ko̱ nomu̱tu̱ wo̱ o dossu̱ me̱ ka swo̱ u̱r-ko̱o̱b de?” ");
INSERT INTO uth_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Wu̱ dooru̱ m-ze̱e̱, “Abba, Tato re, ko̱ yo ke rii-yo yo ro̱ m-nome̱ be u̱n du. U̱m co̱no̱g o dossu̱ me̱ ka swo̱ u̱r-ko̱o̱b de. Amba yanze barag-u̱s re se o he m-do̱re̱ á, se̱ barag-u̱s ru.” ");
INSERT INTO uth_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Bo̱ wu̱ mu̱u̱nte̱ be-de ye̱ ro à, wu̱ 'wo̱ssu̱ru̱ ye̱ ro̱ m-rew. Wu̱ ze̱e̱ru̱ Bitrus, “¿Simo̱n, rew-mo̱ no̱ ro̱tte̱? Ashi, ¿no̱a hoks m-she'et zo̱ngse̱ ko̱ hiin á? ");
INSERT INTO uth_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","She'et no̱ zo̱ngse̱, yish ho̱o̱ge̱, no̱ ma'as u̱n ko̱n-se Shir, taase no̱ he̱'e̱be̱ u̱r-ba'as da-de a megre̱ no̱. Me̱ u̱n ze̱e̱ yo ka remen ku̱kt-o tu̱nu̱ste̱ o̱ no̱m rii-yo depe̱ à, amba wu̱r-o ro̱tt m-'wo̱ns á.” ");
INSERT INTO uth_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Ka da-de, Ye̱so dooru̱ m-warag komo wu̱ yage̱ ye̱. Wu̱ ko̱nu̱ru̱ Shir. Wu̱ dooru̱ m-rwo̱r bo̱ wu̱ ro rwo̱rge̱ à. ");
INSERT INTO uth_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Har m-mo̱ka komo, wu̱ dooru̱ m-mu̱u̱n. Wu̱ 'wo̱ssu̱ru̱ ye̱ ro m-rew. Rew-m bu̱pste̱ ye̱ de̱e̱n. Bo̱ ye̱ zu̱tu̱te̱ à, ye̱ taagu̱ru̱ ma-to̱ ye̱ he wu̱ m-shas à. ");
INSERT INTO uth_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Wu̱ dooru̱ m-warag remen wu̱ konot Shir. Bo̱ wu̱ do m-mu̱u̱n, o̱ atette̱-o̱ à, wu̱ ze̱e̱ru̱, “¿Har m-mo̱ka wu̱we̱-de no̱ ro̱tte̱ m-rew ne̱? Bo̱'o̱su̱te̱ kaane̱, da-o wooste̱. Gwo̱t me̱ Wà-wu̱ u̱n ne̱t, a ya'astu̱ me̱ u̱n kom-to̱ u̱n ya-u̱t-ba'as. ");
INSERT INTO uth_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Ine̱ no̱, a kew no̱ wu̱! Gwo̱t! Ká ne̱t-wu̱ ya'asu̱ me̱ à, wu̱ ka yow yow.” ");
INSERT INTO uth_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","A kane̱, rii-yo wu̱ bitu̱te̱ nu, Yahudas, wan-gaan be-de u̱n ka o̱p u̱n yoor-ye̱, wu̱ woosu̱nte̱ u̱n mo̱o̱r-to̱ u̱n hun-ne̱ ne̱ de̱e̱n. Ye̱ ro u̱t-magay ne̱ u̱t-ko̱ ne̱. Gwo̱mo-ne̱ ye̱ u̱n ko̱n-se Shir, u̱n yan-Yoos-de u̱n karamsa-o Mosa ne̱, u̱n se̱k-ye̱ ye̱ u̱n Yahuda-ne̱, ye̱ to̱mnu̱ ye̱. ");
INSERT INTO uth_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Wu̱ he wu̱ m-ya'as à, wu̱ be'este̱ wu̱ gemeste̱ u̱r-hi u̱n ye̱ ne̱ u̱nze, “Wu̱ u̱m he m-hamat à wu̱ wu̱ ship no̱ wu̱, no̱ neke̱ u̱n wu̱ ne̱, no̱ 'er wu̱ u̱r-bon ne̱.” ");
INSERT INTO uth_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Bo̱ u̱n wo̱o̱n-m Yahudas wu̱ haaru̱ be-u̱r Ye̱so, wu̱ ze̱e̱ru̱, “Wa-u̱s-Nap.” Yahudas hamtu̱ru̱ wu̱. ");
INSERT INTO uth_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Ye̱ hwo̱o̱ru̱ u̱t-kom, ye̱ shipu̱ru̱ wu̱. ");
INSERT INTO uth_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Se̱ wan-gaan be-de u̱n yan-neke̱-m Ye̱so ye̱ wu̱ ro eso kane̱ à, wu̱ muusu̱ru̱ magay-o̱ u̱n wu̱. Wu̱ ce̱tu̱ru̱ ko-gu̱w-wu̱ u̱n ko-Gwo̱mo-wu̱ u̱n ko̱n-se Shir. Wu̱ kupsu̱ru̱ wu̱ o-to̱. ");
INSERT INTO uth_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Ye̱so ze̱e̱ru̱ ye̱, “¿No̱ u̱n rwu̱u̱n u̱t-magay ne̱ u̱t-ko̱ ne̱, no̱ shipt me̱ u̱ntu̱n ko-hyow? ");
INSERT INTO uth_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Ko̱ de ke ho̱-de me̱ mo̱sse̱ u̱n no̱ ne̱ u̱n Pyo-o̱ Shir, me̱ no̱ m-yoose̱. No̱ ship me̱ á. Amba se̱ a nomu̱tu̱ me̱ bo̱ a ge̱ne̱ be-de u̱n Ma-to̱ Shir à.” ");
INSERT INTO uth_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Ka da-de ne̱, yan-neke̱-mo̱ u̱n wu̱ kap ye̱ yagu̱ru̱ wu̱. Ye̱ argu̱ru̱ m-so̱m. ");
INSERT INTO uth_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Se̱ wu̱ ken wan-campo̱ wu̱, wu̱ co̱p rii á se̱ o-gund u̱n ho̱n-de u̱n o̱, wu̱ do̱ru̱ru̱ Ye̱so. Bo̱ wu̱ do̱ru̱te̱ Ye̱so à, ye̱ shipu̱ru̱ wu̱. ");
INSERT INTO uth_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Ye̱ rumsu̱ru̱ gund-o̱ u̱n wu̱. Wu̱ so̱mu̱ru̱ bo̱ Shir mate̱ wu̱ à. ");
INSERT INTO uth_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Ye̱ neku̱ru̱ u̱n Ye̱so ne̱ be-de u̱n ko-Gwo̱mo-wu̱ u̱n ko̱n-se Shir. Kap Gwo̱mo-ne̱ ye̱ u̱n ko̱n-se Shir u̱n se̱k-ye̱ ye̱ u̱n Yahuda-ne̱, u̱n yan-Yoos-de u̱n karamsa-o Mosa ne̱ ye̱ mo̱rgu̱ru̱ be-u̱r Ye̱so. ");
INSERT INTO uth_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Bitrus ne̱ wu̱ do̱ndu̱ru̱ wu̱ m-pu̱pa ne̱ har u̱n 'wo̱o̱g-o̱ u̱n hur-o ko-Gwo̱mo-wu̱ u̱n ko̱n-se Shir. Wu̱ she'etu̱ru̱ be-de u̱n gu̱w-ne̱ ye̱ u̱n ko-Gwo̱mo-wu̱ u̱n ko̱n-se Shir. Wu̱ ro u̱n hwo̱'o̱t o-ra mo̱sse̱ u̱n ye̱ ne̱. ");
INSERT INTO uth_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","A kane̱ Gwo̱mo-ne̱ ye̱ u̱n ko̱n-se Shir u̱n Mo̱ro̱g-de u̱n Se̱k-ye̱ ne̱, yan-ya-u̱t-ma, kap ye̱ ho̱o̱bu̱ru̱ rii-yo a hette̱ m-ze̱e̱ Ye̱so no̱mo̱g u̱r-ba'as à remen ye̱ hoot wu̱, amba ye̱ kum á. ");
INSERT INTO uth_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Ye̱ ken ye̱ de̱e̱n ye̱ sakku̱ru̱ wu̱ u̱t-ma u̱t-bo̱ amba ma-to̱ u̱n ye̱ to̱ haan u̱t-gaan á. ");
INSERT INTO uth_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","A kane̱ komo ye̱ ken campo̱-ne̱ ye̱ inu̱ru̱ eso, ye̱ dooru̱ wu̱ ce'e̱ u̱t-bo̱: ");
INSERT INTO uth_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","Ye̱ ze̱e̱ru̱. “Te̱ ho̱gu̱te̱ wu̱ ze̱e̱g wu̱a he̱e̱s Pyo-o̱ Shir o̱ hun-ne̱ ma'e̱ à, rii-yo ho̱-u̱t tet nomot wu̱ me'es o ho̱r-o̱, yanze ne̱ ma-to̱ u̱n ko-hun á.” ");
INSERT INTO uth_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Kap u̱n kaane̱ ne̱, ma-to̱ u̱n ye̱ to̱ haan u̱t-gaan á. ");
INSERT INTO uth_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Ko-Gwo̱mo-wu̱ u̱n ko̱n-se Shir wu̱ inu̱ru̱ n-te̱te̱ o̱ u̱n ye̱. Wu̱ citu̱ru̱ Ye̱so. Wu̱ ze̱e̱ru̱, “¿Wo̱ u̱n to̱ ken ma-to̱ ne̱ to̱ o he m-shas, be-de u̱n ma-to̱ ka hun-ne̱ ye̱ ro̱ m-rwo̱r mo̱sse̱ u̱n wo̱ ne̱?” ");
INSERT INTO uth_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Amba Ye̱so ro temb o̱ u̱n wu̱. Wu̱ shas u̱t-ma á. Ko-Gwo̱mo-wu̱ u̱n ko̱n-se Shir wu̱ dooru̱ wu̱ m-cit komo. Wu̱ ze̱e̱ru̱, “Ashi, ¿wo̱ wu̱, Kiristi, Wà-wu̱ u̱n wa-o-kwu̱m-wu̱ Shir to̱mnu̱ te̱?” ");
INSERT INTO uth_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Ye̱so ze̱e̱ru̱, “Me̱ wu̱. No̱a hyen me̱ komo, me̱ Wà-wu̱ u̱n ne̱t, me̱ tara u̱n kom-o̱ u̱r-re̱ o̱ Shir Wa-u̱r-Be̱e̱b. No̱a hyen komo me̱ m-rwu̱u̱n n-me̱ u̱t-ke'ente̱ n-To̱n shir.” ");
INSERT INTO uth_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Ko-Gwo̱mo-wu̱ u̱n ko̱n-se Shir swo̱o̱ru̱ u̱s-ryaab de̱e̱n. Wu̱ yishu̱ru̱ gund-o̱ u̱n wu̱. Wu̱ ze̱e̱ru̱, “¿To̱ ke ma-to̱ a co̱ne̱ m-ho̱ge̱ komo? ");
INSERT INTO uth_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","No̱ ho̱gu̱te̱ de̱ yo'og-o̱ wu̱ yo'oge̱ Shir à! ¿Re no̱ hyan?” Ye̱ ze̱e̱ru̱, “Wu̱ wooste̱ m-ho̱!” ");
INSERT INTO uth_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Ye̱ ken ye̱ taknu̱ wu̱ m-copse̱ m-ta. Ye̱ ho̱kku̱ru̱ wu̱ yish, ye̱ wo̱su̱ru̱ wu̱ u̱r-de̱mbe̱. Ye̱ ze̱e̱ru̱, “Ru̱ru̱ te̱ wu̱ wo̱su̱ wo̱ m-mo̱ka à!” Gu̱w-ne̱ komo ye̱ ma'asu̱ru̱ wu̱ u̱n hwo̱o̱ge̱ u̱t-raag. ");
INSERT INTO uth_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Ye̱ ka ro u̱n kuke̱-o̱ a ma'e̱ n-to̱n u̱n o̱r u̱n o̱ o-kuke̱ à. Ye̱ ro u̱n piishe̱ u̱n Ye̱so u̱t-ma. Bitrus ro o-'wo̱o̱g n-dak. Wu̱ ken wan-ne'a-wu̱ ne̱, ko-gu̱w-wu̱ u̱n ko-Gwo̱mo-wu̱ u̱n ko̱n-se Shir, ");
INSERT INTO uth_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","wu̱ hyanu̱ru̱ Bitrus ro u̱n hwo̱'o̱t o-ra. Wan-ne'a gwo̱tu̱ru̱ Bitrus, wan-ne'a ze̱e̱ru̱, “Wo̱ mo̱sse̱ u̱n Ye̱so ne̱ ka wa-o-Nazaret-wu̱.” ");
INSERT INTO uth_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Amba Bitrus no̱mu̱ru̱ m-she. Wu̱ ze̱e̱ru̱, “Me̱ nap yo wo̱ rwo̱r á.” Wu̱ argu̱ru̱ m-rwu̱u̱n u̱n 'wo̱o̱g-o̱ u̱n pyo. Ke̱e̱g-o̱ o-kiit kanu̱ru̱. ");
INSERT INTO uth_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Ka wan-ne'a-wu̱ komo dooru̱ gwo̱t u̱n Bitrus. Wu̱ taknu̱ ru̱re̱ u̱n ye̱ ro eso eso kane̱ à, “Wu̱ ka, wan-neke̱-m Ye̱so wu̱.” ");
INSERT INTO uth_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Amba Bitrus dooru̱ m-no̱m m-she komo. Bo̱ doote̱ hiin à, ye̱ ro kane̱ eso eso à, ye̱ ze̱e̱ru̱ Bitrus, “Nip-o̱, wo̱ wan-neke̱-m Ye̱so wu̱ remen wa-o-Gariri o ro̱.” ");
INSERT INTO uth_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Wu̱ taknu̱ u̱s-to̱nd. Wu̱ ze̱e̱ru̱, “Me̱ nap ka ne̱t-wu̱ wu̱ no̱tte̱ u̱n ma-to̱ u̱n wu̱ á.” ");
INSERT INTO uth_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","U̱n ra-o̱ wu̱ komte̱ m-rwo̱r à, u̱n gyept-o̱ u̱n yish, ke̱e̱g-o o-kiit kanu̱ru̱ ayoore̱-o̱. Bitrus baksu̱ru̱ ma-to̱ Ye̱so ru̱ru̱ wu̱ à. U̱nze “rii-o̱ ke̱e̱g-o o-kiit kenet so̱-o yoor, wo̱a nom she-mo̱ u̱n nap-u̱s re so̱ o-tet.” Bo̱ wu̱ bakste̱ ká ma-to̱ à, wu̱ he̱bu̱ru̱ u̱s-'wo̱n. ");
INSERT INTO uth_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Bo̱ ish geste̱ à, Gwo̱mo-ne̱ ye̱ u̱n ko̱n-se Shir, u̱n se̱k-ye̱ ye̱ u̱n Yahuda-ne̱, u̱n yan-Yoos-de u̱n karamsa-o Mosa ne̱, bo̱ u̱n yan-ya-u̱t-ma, ye̱ gamu̱ru̱ u̱r-hi, ye̱ neku̱ru̱ u̱n Ye̱so ne̱, ye̱ ya'asu̱ru̱ Biratus wu̱. Roma-ne̱ sagbu̱te̱ Biratus Ko-Gwamna-wu̱ u̱n ka dak-o̱. ");
INSERT INTO uth_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Biratus citu̱ru̱ Ye̱so, “¿Wo̱ wu̱ ro̱ ko-Gwo̱mo-wu̱ u̱n Yahuda-ne̱?” Ye̱so ze̱e̱ru̱ wu̱, “E̱e̱, o rwo̱ro̱g hond hond.” ");
INSERT INTO uth_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Gwo̱mo-ne̱ ye̱ u̱n ko̱n-se Shir ye̱ ma'asu̱ru̱ wu̱ u̱n sakke̱ u̱t-ba'as de̱e̱n. ");
INSERT INTO uth_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Biratus dooru̱ wu̱ m-cit komo. Wu̱ ze̱e̱ru̱, “¿Wo̱tt o̱ ken shas-o̱ o he m-shas á? ¿Ho̱ge̱ mo̱o̱r-to̱ u̱t-ba'as to̱ ye̱ seku̱ wo̱ à?” ");
INSERT INTO uth_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Ye̱so do m-shas á, har Biratus bo̱pu̱ru̱ o-nu. ");
INSERT INTO uth_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","To̱, da-de u̱n ka biki-o̱, Biratus weste̱ m-ho'su̱nde̱ u̱n wa-u̱r-ba'as-wu̱ a ka'e̱ à, wan-gaan wu̱ hun-ne̱ ko̱ne̱ à. ");
INSERT INTO uth_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Wu̱ ken wu̱ ro kon wu̱ a m-ze̱e̱ Barabas à. Wu̱ ro ke'o à, mo̱sse̱ u̱n ye̱ ken yan-ko̱o̱b-de o-do̱ro̱tte̱ ye̱ ne̱ à, ye̱ ho̱'e̱ ne̱t be-de m-dum à. ");
INSERT INTO uth_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Hun-ne̱ u̱t-mo̱o̱r ne̱ hyoknu̱ru̱, ye̱ taknu̱ru̱ u̱s-ko̱n be-u̱r Biratus, ye̱ ro m-ze̱e̱ wu̱ nomu̱ ye̱ rii-yo wu̱ we̱te̱ m-no̱m à. ");
INSERT INTO uth_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Biratus citu̱ru̱, “Wata, ¿no̱ u̱n co̱n o̱ u̱m hosu̱ no̱ ko-Gwo̱mo-wu̱ u̱n Yahuda-ne̱?” ");
INSERT INTO uth_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Wu̱ u̱n cit ye̱ kaane̱ remen wu̱ nepste̱ u̱nze shoob-de rwo̱'e̱ Gwo̱mo-ne̱ ye̱ u̱n ko̱n-se Shir ye̱ ya'aste̱ wu̱. ");
INSERT INTO uth_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Amba Gwo̱mo-ne̱ ye̱ u̱n ko̱n-se Shir sho'ogsu̱ru̱ hun-ne̱ u̱t-mo̱o̱r ne̱ remen Biratus ho'osu̱ntú̱ ye̱ Barabas. ");
INSERT INTO uth_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Biratus dooru̱ ye̱ m-ze̱e̱ komo, “¿Ya u̱m he m-no̱mu̱ ne̱ u̱n ka wu̱ no̱ ze̱e̱ wu̱ ro̱ ko-Gwo̱mo-wu̱ u̱n Yahuda-ne̱?” ");
INSERT INTO uth_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ye̱ 'yonsu̱ru̱ u̱s-co̱r komo, ye̱ ze̱e̱ru̱, “Kam wu̱ n-te̱ o-kan.” ");
INSERT INTO uth_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Biratus ze̱e̱ru̱, “¿Remen yan o̱ ne̱? ¿Yan rii-yo ne̱ wu̱ no̱me̱?” Ye̱ dooru̱ 'yonsu̱ u̱s-co̱r, ye̱ ze̱e̱ru̱, “Kam wu̱ de̱ n-te̱ o-kan.” ");
INSERT INTO uth_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Biratus ne̱, bo̱ wu̱ co̱ne̱ nome̱ u̱n mo̱o̱r-to̱ u̱n hun-ne̱ bo̱ ye̱ co̱ne̱ à, wu̱ ho'osu̱ru̱ ye̱ Barabas. Wu̱ rwo̱'u̱ru̱ a bu Ye̱so u̱s-bukkun. Da-o̱ a komse̱ wu̱ m-dum u̱s-bukkun à, wu̱ ya'asu̱ru̱ karma-ne̱, ye̱ kemet wu̱ n-te̱ o-kan. ");
INSERT INTO uth_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Karma-ne̱ heetu̱ru̱ Ye̱so u̱n 'wo̱o̱g-o̱ u̱n pyo-o Biratus. Ye̱ mo̱ro̱gsu̱ru̱ kap ye̱ kuse̱ u̱n kur-de u̱n ye̱ à. ");
INSERT INTO uth_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Ye̱ cu̱pu̱ru̱ wu̱ co̱p-o̱ u̱n ho̱-m jaas-mo̱ o̱ u̱t-gwo̱mo. Ye̱ ce̱e̱ru̱ o-go̱nd o̱ u̱n yokor, ye̱ cu̱pu̱ru̱ Ye̱so u̱r-hi. ");
INSERT INTO uth_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Ka da-de ne̱, ye̱ taknu̱ wu̱ u̱r-gas de u̱r-ar. Ye̱ ze̱e̱ru̱, “Ko-Gwo̱mo, ho̱o̱g ru she'et, ko-Gwo̱mo-wu̱ u̱n Yahuda-ne̱.” ");
INSERT INTO uth_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Ye̱ ko̱'o̱tu̱ru̱ wu̱ u̱r-hi o-ko̱ o-ko̱, ye̱ copsu̱ru̱ wu̱ m-ta. Ka da-de, ye̱ kwu̱ktu̱ru̱ n-co o̱ u̱n wu̱ u̱nze do̱ro̱tte̱-o̱ ka ye̱ wu̱ m-nome̱. ");
INSERT INTO uth_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Da-o̱ ye̱ komse̱ wu̱ m-nome̱ u̱r-ar à, ye̱ possu̱ru̱ wu̱ ka co̱p-o̱ u̱n ho̱-m jaas-mo̱ o̱, ye̱ muutu̱ru̱ wu̱ o̱ ma u̱n wu̱ co̱p-o̱, ye̱ ruutu̱ru̱ wu̱ n-do̱ remen ye̱ kemet wu̱ n-te̱ o-kan. ");
INSERT INTO uth_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Bo̱ ye̱ ro wu̱ m-ruut à, ye̱ go'onu̱ru̱ u̱n wu̱ ken wu̱ ne̱. A ro wu̱ m-ze̱e̱ Simo̱n wa-o-Kire̱ni, tato Arekanda ne̱ u̱n Rupus. Wu̱ ro m-jo'on so̱ o-kat. Ye̱ gaktu̱ru̱ wu̱, wu̱ dek ka kan-o̱ ye̱ hette̱ kam u̱n Ye̱so à. ");
INSERT INTO uth_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Ye̱ ruutu̱ru̱ Ye̱so de ken be-de, a de m-ze̱e̱ o-Gorogota, (wata, be-de u̱n caar-o̱ u̱r-hi). ");
INSERT INTO uth_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Bo̱ ye̱ woote̱ wu̱ kane̱ à, ye̱ tebbu̱ru̱ wu̱ m-mo̱di mo̱sse̱ u̱s-baat ne̱ se a m-ze̱e̱ o-mur à. Ka baat-se ro̱ m-haab m-hoog, amba wu̱ swo̱ á ");
INSERT INTO uth_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Ka da-de ne̱, ye̱ kamu̱ru̱ wu̱ o-kan. Bo̱ ye̱ kemte̱ wu̱ à, ye̱ wongu̱ru̱ hi u̱n de u̱n ye̱ co̱p-to̱ u̱n wu̱. Ye̱ ro u̱n no̱m o-gwambe̱ remen ye̱ hyenet rii-yo ko̱wan he m-kum à. ");
INSERT INTO uth_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Kwo̱m-u̱s jero̱ se̱ n-sot, ye̱ kame̱ wu̱ n-te̱ o-kan. ");
INSERT INTO uth_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Wu̱ a kame̱ o-kan à, ye̱ ro u̱n ge̱n u̱n ba'as-de u̱n wu̱ a saku̱ru̱ n-to̱n u̱n hi-de u̱n wu̱. Ba'as-u̱r Ye̱so de ka, “Ko-Gwo̱mo-wu̱ u̱n Yahuda-ne̱.” ");
INSERT INTO uth_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Ye̱ kamu̱ru̱ wu̱ u̱n yan-kwu̱p-de u̱n hun-ne̱ ne̱ ne̱n yoor n-te̱ u̱t-kan, wan-gaan u̱n kom-o Ye̱so o̱ u̱r-re̱, wan-gaan u̱n kom-o̱ u̱r-kwanta. ");
INSERT INTO uth_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Ya-m-arag u̱n co̱w ye̱ ze̱e̱ru̱ wu̱ m-ru̱re̱ u̱n ma-u̱t jaas-to̱. Ye̱ ma'asu̱ru̱ wu̱ m-pakte̱ u̱r-hi, ye̱ u̱n ze̱e̱be̱, “Huun! Wo̱ wu̱ ze̱e̱ wo̱a he̱e̱s Pyo-o̱ Shir, o warag o̱ do m-ma ho̱-u̱t tet à, ");
INSERT INTO uth_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","kergene̱ o-kan, o gu hi u̱n du!” ");
INSERT INTO uth_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Kaane̱ tomso Gwo̱mo-ne̱ ye̱ u̱n ko̱n-se Shir u̱n yan-Yoos-de u̱n karamsa-o Mosa ne̱ ye̱ ma'asu̱ru̱ wu̱ u̱n nome̱ u̱r-ar u̱n hi u̱n de u̱n ye̱. Ye̱ ze̱e̱ru̱, “Wu̱ guug ye̱ ken ye̱, wu̱ hoks gun hi u̱n de u̱n wu̱ á. ");
INSERT INTO uth_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","U̱rege̱ wu̱ ro̱ Kiristi, ko-Gwo̱mo-wu̱ u̱n Isra-ne̱ wu̱, kergene̱ o-kan m-mo̱ka a hyenet a dekt!” Ka ye̱ a kame̱ ne̱ mo̱sse̱ u̱n wu̱ ne̱ à, ye̱ ma'asu̱ru̱ wu̱ u̱t-re̱e̱b. ");
INSERT INTO uth_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Ho̱-u̱r ro̱ u̱r-hi hond hond, comb-o swo̱o̱nu̱ru̱ ho̱no o-dak kap har kwo̱m-u̱s tet-se m-rim. ");
INSERT INTO uth_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Kwo̱m-u̱s tettu̱ ne̱ Ye̱so 'yonsu̱ru̱ u̱s-co̱r 'wo̱ns-m-'wo̱ns, wu̱ ze̱e̱ru̱ u̱n rem-de u̱n wu̱, “E̱roi, E̱roi, ¿rama sabaktani?” U̱nze, “Shir re, Shir re, ¿remen yan o̱ ne̱ o joru̱tu̱ me̱?” ");
INSERT INTO uth_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Ye̱ ken ye̱ ro kane̱ eso eso. Bo̱ ye̱ ho̱gu̱te̱ kan-u̱s Ye̱so à, ye̱ nap yo wu̱ ro̱ m-ze̱e̱ á, ye̱ ze̱e̱ru̱, “Ho̱gu̱ no̱, wu̱ ro̱ u̱n eeg-u̱s E̱reja.” ");
INSERT INTO uth_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Wan-gaan be-de u̱n ye̱ wu̱ so̱mnu̱ru̱ o-rek, wu̱ shoosu̱ru̱ o-po̱o̱g u̱n ho̱-mo̱ o-anab-mo̱ o-zambo. Wu̱ saku̱ru̱ n-te̱ o-ko̱, wu̱ tebbu̱ru̱ Ye̱so wu̱ su̱. Wu̱ ze̱e̱ru̱, “Yage̱ a hyenet ko̱ E̱reja a haan wu̱ kergu̱ntu̱te̱ wu̱ à.” ");
INSERT INTO uth_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Ka da-de ne̱, Ye̱so 'yonsu̱ru̱ u̱s-co̱r 'wo̱ns-m-'wo̱ns. Ho̱o̱g-o̱ u̱n wu̱ argu̱ru̱ m-neke̱. ");
INSERT INTO uth_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Bo̱ Ye̱so merte̱ à, gund-o̱ a sente̱ ish-o̱ u̱n “Be-de u̱n Shir de jiishe̱ ba m-ku̱ko̱p à” u̱n Pyo-o̱ Shir u̱n bo̱-o̱ o-Urusharima, o̱ yishu̱ru̱ ze̱e̱-mo̱ n-to̱n har n-dak. ");
INSERT INTO uth_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Wan-co-wu̱ u̱n karma-ne̱ o-zungu wu̱ ro káne̱ eso, wu̱ hyanu̱ru̱ mar-m Ye̱so. Wu̱ ze̱e̱ru̱, “Nip-o̱, ka ne̱t-wu̱ Wà-wu̱ Shir wu̱.” ");
INSERT INTO uth_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Ye̱ ken ne'a-ne̱ ye̱ ro kon tomso, ye̱ ro m-se̱gbe̱ rii-yo no̱me̱ à. Be-de u̱n ye̱ Meri ro kon wa-o-Magu̱darin, Sarome̱ wu̱, Meri inu Yakubu re̱k-wu̱ u̱n Yosi. ");
INSERT INTO uth_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Da-o̱ Ye̱so ro u̱n dak-o̱ o-Gariri à, Kà ne'a-ne̱ ye̱, ye̱ ro wu̱ m-do̱re̱. Ye̱ ro wu̱ m-re̱e̱gte̱. Ye̱ ken ne'a-ne̱ ye̱ ro kon tomso ne̱ de̱e̱n ye̱ shie̱ wu̱ o-Urusharima à. ");
INSERT INTO uth_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Kap yo ka yo u̱n ko̱r ho̱-de u̱r-Jaw. Ho̱-de u̱n zo̱nge̱-to̱ u̱n Ho̱-de u̱r-Wu̱we̱ de u̱n Yahuda-ne̱. ");
INSERT INTO uth_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Yusuhu ko-ya-o-Aramatiya haante̱ ho̱-de Ye̱so mare̱ à m-rim. Kashi u̱n ne̱t-wu̱ be-de u̱n se̱k-ye̱ yan-ya-u̱t-ma. Wu̱ ro̱ u̱r-'er Shir rwu̱u̱nte̱ u̱n gwo̱mo-to̱ u̱n wu̱ ne̱. Yusuhu no̱mu̱ru̱ jaab-o̱ u̱t-me̱n, wu̱ co̱wu̱ru̱ be-u̱r Biratus. Wu̱ ko̱nu̱ru̱ Biratus ya'as wu̱ u-u̱r Ye̱so. ");
INSERT INTO uth_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Biratus wu̱ de̱k u̱nze Ye̱so mereste̱ á. Wu̱ agnu̱ru̱ wan-co-wu̱ u̱n karma-ne̱ o-zungu, wu̱ citu̱ru̱ wu̱ ko̱ Ye̱so mereste̱ à. ");
INSERT INTO uth_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Da-o̱ wan-co-wu̱ u̱n karma-ne̱ o-zungu ru̱re̱ Biratus u̱nze Ye̱so she'esu̱te̱ m-mar ne̱ à, wu̱ ya'asu̱ru̱ Yusuhu u̱r-u. ");
INSERT INTO uth_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Ka da-de ne̱, Yusuhu haaru̱, wu̱ o̱o̱nu̱ru̱ gund-o pus-o̱ o̱ u̱r-bon. Wu̱ kergu̱ntu̱ru̱ Ye̱so. Wu̱ ho̱kku̱ru̱ wu̱ u̱n o̱. Wu̱ de̱ku̱ru̱ wu̱, wu̱ ru̱ssu̱ru̱ wu̱ u̱n o̱ ken saag-o̱ o̱ a ro hinge̱ n-te̱ o-ta'ar à. Wu̱ yirigtu̱ru̱ caari-o̱ o-ta'ar, wu̱ zwo̱pu̱ru̱ ish-o̱ u̱n saag u̱n o̱. ");
INSERT INTO uth_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Meri wa-o-Magu̱darin u̱n Meri inu Yosi ye̱ gwo̱tu̱ru̱ be-de Yusuhu ru̱ssu̱ wu̱ à. ");
INSERT INTO uth_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Bo̱ ho̱-u̱r he̱bu̱te̱ à, Ho̱-de u̱r-Wu̱we̱, Meri Magu̱darin, u̱n Sarome̱ ne̱, u̱n Meri (inu Yakubu) ne̱, ye̱ haaru̱, ye̱ o̱o̱nu̱ru̱ no̱w-mo̱ m-shi'igin ye̱ duusu̱te̱ u-u̱r Ye̱so. ");
INSERT INTO uth_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Ish gasu̱ru̱ n-sot n-sot, ho̱-de o-Rahadi, ho̱-u̱r ro̱ m-dakan ye̱ haanu̱ru̱ u̱n saag. ");
INSERT INTO uth_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Ye̱ ro m-neke̱ u̱t-orom u̱t-orom. Ye̱ citu̱ru̱ hi u̱n de u̱n ye̱, “¿Wa he na m-yirikte̱ u̱n ka ta'ar-o̱ u̱n ish-o̱ u̱n saag?” ");
INSERT INTO uth_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Bo̱ ye̱ woote̱ à, ye̱ gwo̱dbu̱ru̱, ye̱ 'wo̱ssu̱ru̱ a yirigsu̱te̱ o-ta'ar. ");
INSERT INTO uth_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Ye̱ co̱wu̱ru̱ u̱n saag. Bo̱ ye̱ tu̱wte̱ u̱n saag à, ye̱ 'wo̱ssu̱ru̱ ko-be̱e̱b tara so̱ u̱n kom-o a re̱ u̱n co̱p-o̱ o-gund ne̱ o pus-o̱, o̱ m-se̱e̱b. Ye̱ zapu̱ru̱ u̱s-zap. ");
INSERT INTO uth_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Amba wan-to̱m-wu̱ Shir ze̱e̱ru̱ ye̱, “No̱ ho̱ge̱ o-gye̱r á. No̱ u̱n hoob-o Ye̱so wa-o-Nazaret-wu̱ a kame̱ o-kan à. Ai, wu̱ ro̱ ko̱n á. Wu̱ inu̱te̱ be-de m-margan ne̱ u̱n ho̱o̱g ne̱. Gwo̱t no̱, be-de ka de a ru̱stu̱ wu̱ à. ");
INSERT INTO uth_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Neke̱ no̱, no̱ ru̱re̱ yan-neke̱-mo̱ u̱n wu̱ kap u̱n Bitrus ne̱. No̱ zee, ‘Ye̱so a be no̱ m-wo̱ u̱n dak-o̱ o-Gariri. Re̱e̱no̱ o̱ no̱ he wu̱ m-hyan bo̱ wu̱ ru̱re̱ no̱ à.’ ” ");
INSERT INTO uth_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Ka ne'a-ne̱ ye̱ ruuru̱ u̱s-rek u̱s-rek be-de u̱n saag gye̱r-o-gye̱r. Ye̱ ma'asu̱ru̱ u̱s-zap. Ye̱ te̱pse̱ ne̱t u̱n co̱w á. ");
INSERT INTO uth_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Da-o̱ Ye̱so ine̱ u̱n ho̱o̱g ne̱ à, ho̱-de o-Rahadi, u̱n co u̱n co wu̱ rwu̱ntu̱ru̱ hi u̱n de u̱n wu̱ be-u̱r Meri wa-o-Magu̱darin. Wu̱ wu̱ Ye̱so ruute̱ ya-u̱t-ko̱t ne̱n ta'yoor u̱n hi-de u̱n wu̱. ");
INSERT INTO uth_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Ka ne'a-wu̱ haaru̱ be-de u̱n yan-neke̱-m Ye̱so. Wu̱ 'wo̱ssu̱ru̱ hur-de u̱n ye̱ naasu̱te̱. Ye̱ ro u̱s-'wo̱n. Wu̱ ru̱ru̱ ye̱ rii-yo takne̱ à. ");
INSERT INTO uth_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Da-o̱ ye̱ ho̱ge̱ Ye̱so inu̱te̱ u̱n ho̱o̱g ne̱ à, har Meri hyeneste̱ wu̱, ye̱ de̱k ma-to̱ u̱n wu̱ u̱nze wu̱ hyanag wu̱ á. ");
INSERT INTO uth_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Bo̱ a jimite̱ à, Ye̱so rwu̱ntu̱ru̱ hi u̱n de u̱n wu̱ be-de u̱n yan-neke̱-mo̱ u̱n wu̱ ne̱n yoor da-o̱ ye̱ ro m-ha o-ko̱t à. Amba wu̱ baramsu̱te̱, sa o zee wu̱ ken ne̱t-wu̱. ");
INSERT INTO uth_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Ye̱ wargu̱ru̱, ye̱ ru̱ru̱ ye̱ kuse̱ be-de u̱n yan-neke̱-mo̱ u̱n wu̱ à, amba ka ye̱ kuse̱ à ye̱ de̱k ma-to̱ u̱n ye̱ u̱nze ye̱ hyanag Ye̱so á. ");
INSERT INTO uth_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Da-o ho̱r-o̱, yan-neke̱-mo̱ u̱n wu̱ ro u̱n re̱ u̱n rii-yo m-re̱, ne̱n o̱p o-gaan. Ye̱so rwu̱ntu̱ru̱ hi u̱n de u̱n wu̱ be-de u̱n ye̱. Wu̱ naku̱ru̱ ye̱ u̱t-to̱ remen ko̱o̱b-de u̱n she̱r-mo̱ u̱n ye̱ u̱n cikt-de u̱n ye̱ ne̱. Ye̱ bo̱p ma-to̱ u̱n ye̱ hyane̱ wu̱ inu̱te̱ u̱n ho̱o̱g ne̱ á. ");
INSERT INTO uth_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Ye̱so ze̱e̱ru̱ ye̱, “Neke̱ no̱ ho̱no o-dak kap, no̱ ko̱'o̱t Ma-to̱ m-Re̱re̱m to̱ Shir be-de u̱n ko̱ wu̱ ke ne̱t-wu̱. ");
INSERT INTO uth_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Bo̱ u̱n wu̱ she̱re̱ u̱n ka Ma-to̱ m-Re̱re̱m to̱ à, komo a yo'os wu̱ m-ho̱, Shir a sokse̱ wu̱ ba'as-to̱ u̱n wu̱. Amba wu̱ she̱re̱ u̱n ka Ma-to̱ m-Re̱re̱m to̱ á a piishe̱ wu̱ u̱t-ma u̱ntu̱n wa-u̱r-ba'as a 'ye wu̱ u̱r-ko̱o̱b. ");
INSERT INTO uth_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Ka ye̱ she̱re̱ u̱n Ma-u̱t re to̱ m-Re̱re̱m à, ye̱a nom rem-se u̱t-hyat. Har u̱n be̱e̱b u̱n de, ye̱a ruut ya-u̱t-ko̱t. Ye̱a te̱pe̱r u̱n rem-to̱ ye̱ yoose̱ á. ");
INSERT INTO uth_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Ko̱ ye̱ ship hwo̱ u̱n kom-to̱ u̱n ye̱, ko̱ ye̱ su̱ pe̱re̱ ba m-nap, ye̱a mer á. Ye̱ seke̱ ya-u̱s-go̱m kom-to̱ u̱n ye̱, ka go̱m-se a te.” ");
INSERT INTO uth_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Da-o̱ Ye̱so Wan-Ko̱yan na komse̱ ru̱re̱ u̱n yan-neke̱-mo̱ u̱n wu̱ ka ma-to̱ à, Shir de̱ku̱ru̱ wu̱ n-To̱n shir. Wu̱ she'etu̱ru̱ u̱n kom-o a re̱-o̱ Shir. ");
INSERT INTO uth_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Ye̱ ne̱ yan-neke̱-mo̱ u̱n wu̱, ye̱ ruuru̱ ko̱ kene̱ ye̱ ro m-ko̱'o̱t u̱n Ma-to̱ m-Re̱re̱m to̱ Shir. Ye̱so Wan-Ko̱yan na wu̱ ro ye̱ m-gu. Wu̱ ro m-do'e̱ u̱n ma-to̱ u̱n ye̱ m-'wo̱ns u̱t-hyat ne̱ to̱ ye̱ ro m-no̱m à.");
INSERT INTO uth_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","4","Wu̱ ma re, ko-Gwo̱mo Tiyaporus, o nepste̱ u̱n zee re̱e̱no̱ n-ga, Shir ze̱e̱g wu̱a to̱mo̱n Wa-m-Rur. Hun-ne̱ de̱e̱n no̱mo̱g m-se̱nge̱ ye̱ ge̱ne̱g rii-yo Shir ze̱e̱ à, yo shiig o-nip. Ye̱ ge̱ne̱g yo a ru̱ru̱ na à u̱n nu-o̱ u̱n ye̱ hyane̱ ka rii-yo à, u̱r-takan u̱n komo ka ye̱ rwo̱re̱ ka ma-to̱ à. Remen kaane̱ u̱m byaragte̱ u̱r-bon ne̱, ka ma-to̱ ne̱ u̱r-takan u̱m cekerte̱ a nom u̱r-bon a ge̱n m-do̱nd m-do̱nd rem ru. Me̱n no̱m kaane̱, remen o nept nip-o̱ u̱n ko̱ yo ke rii-yo a yoosu̱ wo̱ à. ");
INSERT INTO uth_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Da-o̱ Here̱ ro u̱t-gwo̱mo to̱ u̱n dak-o̱ o-Judiya à, wan-Co̱w u̱n ko̱n-se Shir ro kon, jin-de u̱n wu̱ Zakaraya, wu̱ baag-o̱ u̱n wu̱ mo̱sse̱ u̱n wan-Co̱w u̱n ko̱n-se Shir ne̱ à wu̱ a m-ze̱e̱, Abija. Jin-u̱r ne'a u̱n wu̱ Erisabatu, wu̱ ma baag-o̱ u̱n wu̱ mo̱ssu̱te̱ u̱n yan-Co̱w u̱n ko̱n-se Shir ne̱. ");
INSERT INTO uth_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Shir hyanag she'et-de u̱n ye̱ ro̱ u̱r-bon ne̱, ye̱ ro komo m-no̱m u̱n rii-yo Wan-Ko̱yan ze̱e̱ à, ba u̱t-re̱e̱b. ");
INSERT INTO uth_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Ye̱ kum yakar á, remen Erisabatu mat wà á, ko̱ wan-gaan, wu̱ komo u̱n campo̱ u̱n wu̱ ne̱ Zakaraya ye̱ mo̱ngsu̱te̱. ");
INSERT INTO uth_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","De ken ho̱-de Zakaraya ro̱ u̱n se̱nge̱-mo̱ u̱n wu̱ mo̱ u̱n yan-Co̱w u̱n ko̱n-se Shir n-me̱ u̱n Pyo-o̱ Shir, wu̱ ro̱ m-de̱k u̱n da-o̱ u̱n wu̱ o̱ u̱n gu̱w-mo̱ Shir. ");
INSERT INTO uth_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","An dagan wu̱ u̱r-barag bo̱ yan-Co̱w u̱n ko̱n-se Shir we̱te̱ m-no̱m à, remen wu̱ su'ut rii-yo m-shi'igin be-de u̱n Pyo-o̱ u̱n Wan-Ko̱yan. Wu̱ co̱wu̱ru̱ u̱n Pyo-o̱ Shir, ");
INSERT INTO uth_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","hun-ne̱ ye̱ mo̱rge̱ n-do̱ à, ye̱ ko̱nu̱ru̱ Shir da-o̱ rii-yo m-shi'igin ro m-tu̱k à. ");
INSERT INTO uth_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Wan-to̱m-wu̱ Wan-Ko̱yan rwu̱u̱nu̱ru̱ be-de u̱n wu̱, eso u̱n Pyo-o̱ Shir, so̱ u̱n kom-o̱ u̱r-re̱ be-de rii-yo m-shi'igin ro m-tu̱k à. ");
INSERT INTO uth_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Da-o̱ Zakaraya hyane̱ wu̱ à, hur-u̱r do̱'u̱ru̱ wu̱, ");
INSERT INTO uth_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","amba wan-to̱m-wu̱ Shir ze̱e̱ru̱ wu̱, “Zakaraya, wo̱ ho̱ge̱ o-gye̱r á! Remen Shir ho̱gu̱te̱ ko̱n-u̱s ru, komo ne'a ru Erisabatu wu̱a metu̱ wo̱ wà. Wo̱a ege̱ wu̱ u̱r-jin ‘Yohana.’ ");
INSERT INTO uth_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Wo̱a nom o-zak, o nemes, ye̱ ken ye̱ komo de̱e̱n a nom o-zak, remen ka wà-wu̱! ");
INSERT INTO uth_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Wu̱a warag caari-wu̱ u̱n ne̱t be-de Wan-Ko̱yan. Wu̱ jar wu̱ su̱ m-ke̱ á, ko̱ yo ken yo u̱ntu̱n mo̱ á. Ku̱kt-o̱ Shir a garamse̱ wu̱, cin ba inu u̱n wu̱ mat wu̱, ");
INSERT INTO uth_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","komo wu̱a mu̱nte̱ hun-ne̱ ye̱ o-Isra de̱e̱n be-de u̱n ko-Gwo̱mo Shir wu̱ u̱n ye̱. ");
INSERT INTO uth_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Wu̱a tek co-o̱ u̱n Wan-Ko̱yan, o-ku̱kt, m-'wo̱ns ne̱ u̱ntu̱n wan-Rwo̱r u̱n Ma-to̱ ShirE̱reja. Tat-ne̱ a ho̱ge̱ 'wo̱n-de u̱n yakar, ye̱ she'et be-u̱r gaan, komo wu̱a mu̱nte̱ yan-ko̱o̱b-de o-do̱ro̱tte̱, u̱n ye̱ e̱ge̱ ne̱ à o-co̱w, wu̱a zo̱ngse̱ hun-ne̱ remen Go̱s-wu̱ ro̱o̱n.” ");
INSERT INTO uth_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Zakaraya ze̱e̱ru̱ wan-to̱m-wu̱ Shir, “¿Re ne̱ u̱m he m-no̱m u̱m nept nip-o̱? U̱m mo̱ngsu̱te̱, ne'a re komo ko-mo̱ng-wu̱.” ");
INSERT INTO uth_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Ko wan-to̱m-wu̱ Shir shasu̱ru̱, “Me̱ Gebu̱re̱ wu̱, wu̱ ro̱ m-e̱s u̱n be-de Shir à. Shir to̱mne̱ me̱, u̱m ru̱ru̱ wo̱ Ma-to̱ m-Re̱re̱m. ");
INSERT INTO uth_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Amba wo̱ go̱ks to̱m re o̱ he m-warag o-nip á, u̱n kashi o-da á. Remen wo̱ go̱ks á, wo̱a hoks m-te̱pe̱r á, wo̱a she'et ba m-te̱pe̱r har ho̱-de ma-u̱t re rwu̱u̱nte̱ o-nip à.” ");
INSERT INTO uth_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Ka da-o̱, hun-ne̱ ro̱ Zakaraya u̱r-'er. Ye̱ ro̱ u̱s-barag yo rwo̱'e̱ wu̱ she'etu̱nte̱ n-me̱ u̱n Pyo-o̱ Shir à. ");
INSERT INTO uth_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Da-o̱ wu̱ rwu̱u̱ne̱ n-do̱ à, wu̱ hoks ye̱ m-te̱pse̱ á, ye̱ napu̱ru̱ u̱nze wu̱ hyante̱ u̱t-hyangan u̱n Pyo-o̱ Shir. Wu̱ hoks m-te̱pe̱r á, amba wu̱ kutu̱ru̱ ye̱ u̱t-kom u̱t-kom. ");
INSERT INTO uth_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Bo̱ da-o̱ u̱n wu̱ o̱ u̱n gu̱w-mo̱ Shir u̱n Pyo-o̱ Shir teeste̱ à, Zakaraya ji'u̱ru̱ o-hur. ");
INSERT INTO uth_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Bo̱ a nomte̱ ya o-da hiin à, ne'a u̱n wu̱ Erisabatu kumu̱ru̱ u̱r-uub wu̱ wuku̱ru̱ o-hur, har re̱ng-u̱s taan. ");
INSERT INTO uth_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Wu̱ ze̱e̱ru̱, “M-mo̱ka de ka u̱r-ho̱, Wan-Ko̱yan guug me̱. Wu̱ dossu̱te̱ me̱ m-'e̱ be-de u̱n hun-ne̱!” ");
INSERT INTO uth_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Da-o̱ Erisabatu ro u̱r-uub ne̱ re̱ng-u̱s cind à, Shir to̱mnu̱ru̱ wan-to̱m-wu̱ u̱n wu̱ jin-de u̱n wu̱ Gebu̱re̱ u̱n o̱ ken bo̱-o̱ n-me̱ o-Gariri jin-de u̱n o̱, o-Nazaret. ");
INSERT INTO uth_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","A to̱mu̱nte̱ wu̱ be-de u̱n wu̱ ken wan-ne'a-wu̱, wu̱ nape̱ campo̱ á, wu̱ Yusuhu ro u̱r-ryap à. Yusuhu co̱ u̱n jit-u̱r ko-Gwo̱mo Dawuda wu̱ rwu̱u̱ne̱. Jin-de u̱n ka wan-ne'a-wu̱ Meri. ");
INSERT INTO uth_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Ko wan-to̱m-wu̱ Shir haante̱ be-de u̱n wu̱. Wu̱ gassu̱ru̱ Meri, “Wan-Ko̱yan ro̱ u̱n wo̱ ne̱, komo wu̱ ya'ag wo̱ u̱r-ho̱!” ");
INSERT INTO uth_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Hur-u̱r Meri do̱'u̱ru̱ wu̱ bo̱ wu̱ ho̱ge̱ ma-to̱ u̱n ko-wan-to̱m-wu̱ Shir à, wu̱ ze̱e̱ru̱, u̱n hur-de u̱n wu̱, “¿Ya u̱n go̱n gas-de ne̱ de ka?” ");
INSERT INTO uth_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Ko wan-to̱m-wu̱ Shir ze̱e̱ru̱ wu̱, “Meri, wo̱ ho̱ge̱ o-gye̱r á! Shir ya'ag wo̱ u̱r-ho̱! ");
INSERT INTO uth_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Gwo̱tbe̱ wo̱a nom u̱r-uub, o met wà, komo wo̱a ege̱ wu̱ u̱r-jin Ye̱so. ");
INSERT INTO uth_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Wu̱a nom u̱t-go̱s, a eeg wu̱, wà-wu̱ u̱n Shir n-To̱n. Wan-Ko̱yan Shir a sagbe̱ wu̱ u̱t-gwo̱mo, bo̱ Dawuda ro à, ");
INSERT INTO uth_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","wu̱a nom gwo̱mo-to̱ u̱n jit-o Yakubu ba m-ta, gwo̱mo-to̱ u̱n wu̱ to̱a te á!” ");
INSERT INTO uth_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Meri ze̱e̱ru̱ ko-wan-to̱m-wu̱ Shir, “Me̱ wan-ne'a-wu̱, me̱ nap campo̱ á. ¿Re ne̱ o̱ ka rii-yo he m-nome̱?” ");
INSERT INTO uth_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Wan-to̱m-wu̱ Shir shasu̱ru̱ wu̱, “Ku̱kt-o̱ Shir a haan be u̱n du, u̱n 'wo̱ns-mo̱ Shir ne̱ n-To̱n, remen kaane̱ wo̱a nom u̱r-uub. Ka wà-wu̱, wu̱ o he m-mat à, wu̱t u̱r-ba'as á, remen kaane̱ a eeg wu̱ wà-wu̱ u̱n Shir. ");
INSERT INTO uth_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Baks ko-yan-baag-o ru Erisabatu. A ro ze̱e̱g wu̱a met yakar á, amba wu̱ ka m-mo̱ka u̱r-uub ne̱ re̱ng-u̱s cind, ko-mo̱ng-wu̱ komo. ");
INSERT INTO uth_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Yatt rii-yo Shir a hoks m-no̱m á.” ");
INSERT INTO uth_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Meri ze̱e̱ru̱, “Me̱ ko-gu̱w-wu̱ Wan-Ko̱yan wu̱ u̱m ro̱, Shir zee kaane̱ bo̱ o ze̱e̱ à.” Ka da-de wan-to̱m-wu̱ Shir argu̱ru̱. ");
INSERT INTO uth_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Bo̱ rewete̱ u̱t-ho̱ hiin à, Meri zo̱ngu̱ru̱ ho̱r-m-ho̱r wu̱ heet o̱ ken bo̱-o̱ u̱n dor-to̱ u̱n dak-o̱ o-Judiya. ");
INSERT INTO uth_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Wu̱ co̱wu̱ru̱ hur-o Zakaraya, wu̱ gassu̱ru̱ Erisabatu. ");
INSERT INTO uth_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Bo̱ Erisabatu ho̱gu̱te̱ gas-u̱r Meri à, wan-yaar-wu̱ ro̱ u̱n me̱n-to̱ u̱n wu̱ à nuktu̱ru̱. Ku̱kt-o̱ Shir garamsu̱ru̱ Erisabatu. ");
INSERT INTO uth_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Wu̱ 'yonsu̱ru̱ u̱s-co̱r wu̱ ze̱e̱ru̱, “O jiishte̱ ne'a-ne̱ kap o-kwu̱m, komo ko-ya-o-kwu̱m-wu̱ ka wà-wu̱ o he m-mat à! ");
INSERT INTO uth_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","¿Remen yan o̱ u̱m hette̱ kum u̱n ka rii caari-yo, inu u̱n Go̱s-wu̱ heenu̱te̱ me̱ u̱t-tu̱w? ");
INSERT INTO uth_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Da-o̱ u̱m ho̱ge̱ gas u̱n du à, wan-yaar-wu̱ ro̱ n-me̱ u̱n me̱n-u̱t re à nuktu̱ru̱ o-zak. ");
INSERT INTO uth_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Ko-ya-o-kwu̱m-wu̱, wu̱ go̱kse̱ rii-yo Wan-Ko̱yan ze̱e̱ wu̱a nom à!” ");
INSERT INTO uth_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Meri ze̱e̱ru̱, “Hur u̱n de ro̱ m-bo̱m u̱n Wan-Ko̱yan. ");
INSERT INTO uth_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Ho̱o̱g-m re no̱mo̱g o-zak remen Shir Wan-Gwu̱ re, ");
INSERT INTO uth_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Remen wu̱ bakste̱ u̱n me̱ ne̱ re̱k-wu̱, be-de u̱n yan-gu̱w-mo̱ u̱n wu̱! M-mo̱ka hun-ne̱ kap ye̱a eeg me̱ ko-ya-o-kwu̱m, ");
INSERT INTO uth_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","remen rii-yo u̱r-bon yo wu̱ jiishe̱ m-'wo̱ns nomo me̱ à. Jin-de u̱n wu̱ ro̱ ba m-ku̱ko̱p. ");
INSERT INTO uth_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","O-caara ha-mo̱ o-caara, Shir kutute̱ ye̱ u̱r-'wo̱n, u̱n ye̱ ya'e̱ wu̱ m-se̱k ne̱ à. ");
INSERT INTO uth_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Wu̱ nekste̱ kom-o̱ u̱n wu̱, o̱ u̱r-be̱e̱b, wu̱ cakar-se ya-u̱r-hwu̱ myet u̱n nap-se u̱n ye̱ ne̱. ");
INSERT INTO uth_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Wu̱ doste̱ caari-ye̱ u̱n gwo̱mo-ne̱ u̱n comos-to̱ u̱n ye̱, wu̱ jaksu̱ru̱ ye̱ ro̱ re̱k-ye̱ à. ");
INSERT INTO uth_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Wu̱ cokste̱ yan-me̱r u̱n rii-yo u̱r-bon, wu̱ yanu̱ru̱ yan-rii kom-u̱t-kom. ");
INSERT INTO uth_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Wu̱ e̱ste̱ ma-to̱ u̱n wu̱ to̱ wu̱ no̱me̱ u̱n ya-n-ga-ye̱ ne̱ à, wu̱ haante̱ wu̱ guut hun-ne̱ yan-gu̱w-mo̱ u̱n wu̱ ya-o-Isra. ");
INSERT INTO uth_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Wu̱ kutute̱ Ibrahi u̱r-'wo̱n u̱n yan-jit-o̱ u̱n wu̱ ne̱ ba m-ta!” ");
INSERT INTO uth_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Meri she'ete̱ u̱ntu̱n re̱ng-u̱s tet u̱n Erisabatu ne̱, ka da-de wu̱ ji'u̱ru̱ o-hur. ");
INSERT INTO uth_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Bo̱ da-o wo̱o̱ne̱ o̱ Erisabatu hette̱ mat u̱n wà u̱n wu̱ à, wu̱ matu̱ru̱ wan-campo̱. ");
INSERT INTO uth_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Yan-bo̱r-se u̱n wu̱, u̱n o̱r ru u̱n wu̱ ne̱ ho̱gu̱ru̱ rii-yo u̱r-bon, yo Wan-Ko̱yan nome̱ wu̱ à, ye̱ guuru̱ wu̱ o-zak. ");
INSERT INTO uth_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Bo̱ ka wà-wu̱ wo̱o̱ste̱ ho̱-u̱t eer à, ye̱ heetu̱ru̱ wu̱ a koot wu̱, komo ye̱ egetu̱ wu̱ u̱r-jin Zakaraya, de ma tato u̱n wu̱. ");
INSERT INTO uth_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Amba inu u̱n wu̱ ze̱e̱ru̱, “Ay! Jin-de a he wu̱ m-aag à Yohana wu̱.” ");
INSERT INTO uth_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ye̱ ze̱e̱ru̱ wu̱, “No̱tt ka jin-de u̱n baag-o no̱ á!” ");
INSERT INTO uth_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Ka da-o̱ ye̱ te̱psu̱ru̱ tato u̱n wu̱ u̱t-kom, ye̱ citu̱ru̱ wu̱ ko̱ de ke jin-de wu̱ co̱ne̱ a ege̱ ka wà-wu̱. ");
INSERT INTO uth_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Zakaraya nomu̱ru̱ u̱t-ma u̱n ye̱ ne̱ u̱t-kom ye̱ hante̱ wu̱ rii-yo m-ge̱n, wu̱ ge̱nu̱ru̱, “Jin-de u̱n wu̱ Yohana.” Ye̱ bo̱pu̱ru̱ o-nu! ");
INSERT INTO uth_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","U̱n ka da-o̱ Zakaraya hoksu̱ru̱ m-te̱pe̱r, wu̱ ciru̱ru̱ bo̱ngo̱n-de Shir. ");
INSERT INTO uth_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Yan-bo̱r-se u̱n wu̱ kap ho̱gu̱ru̱ o-gye̱r, komo ka ma-to̱ pa'u̱ru̱ kap dor-to̱ u̱n dak-o̱ o-Judiya. ");
INSERT INTO uth_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Ko̱ wu̱ ke wu̱ ho̱ge̱ to̱ à, wu̱ cekru̱ru̱ wu̱ citu̱ru̱, “¿Ya ne̱ ka wà-wu̱ he m-warag? Remen te̱ hyanag cas be̱e̱b-de u̱n Wan-Ko̱yan ro̱ u̱n wu̱ ne̱.” ");
INSERT INTO uth_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Ku̱kt-o̱ Shir garamsu̱te̱ Zakaraya tato Yohana wu̱ rwo̱ro̱g to̱m-o̱ Shir. ");
INSERT INTO uth_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“A bu̱m no̱ Go̱s-wu̱, Shir wu̱ u̱n ya-o-Isra! Wu̱ haante̱ wu̱ rurut hun-ne̱ ye̱ u̱n wu̱, ");
INSERT INTO uth_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Wu̱ kumutu̱ na caari-wu̱ u̱n ko-yan-Gwu̱, ko-yan-jit-o̱ u̱n wan-gu̱w-mo̱ u̱n wu̱ Dawuda. ");
INSERT INTO uth_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Wu̱ e̱ssu̱tu̱ na u̱t-ma be-de u̱n yan-rwo̱r u̱n ma-to̱ u̱n wu̱ yan-ba-m-ku̱ko̱p-mo̱ u̱r-hur n-ga n-ga, ");
INSERT INTO uth_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","remen wu̱ guut na u̱n kom-to̱ u̱n yan-yage̱-u̱t na, be-de u̱n 'wo̱ns-mo̱ u̱n kap ye̱ co̱nu̱ na á. ");
INSERT INTO uth_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Wu̱ ho̱gu̱te̱ 'wo̱n-de u̱n ya-n-ga-ye̱ na komo wu̱ bakste̱ swo̱r o-nu o̱ ba m-ku̱ko̱p o̱ u̱n wu̱. ");
INSERT INTO uth_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","74","Wu̱ to̱nte̱ wu̱a gu tato na Ibrahi. Wu̱a gu na u̱n kom-to̱ u̱n yan-yage̱-u̱t na, remen a nomoté̱ wu̱ m-gu̱w ba o-gye̱r, ");
INSERT INTO uth_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","remen kashi u̱r-she'et ba m-ku̱ko̱p, komo ba u̱r-ba'as be-de u̱n wu̱, komo kashi u̱r-she'et u̱n be-de Shir har ta-de u̱n ho̱o̱g-m na.” ");
INSERT INTO uth_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","“Wo̱, wà re a eeg wo̱ wan-Rwo̱r u̱n Ma-to̱ Shir n-To̱n. Wo̱a tek co, o ja'asu̱té̱ Go̱s-wu̱ co̱w-yo u̱n wu̱, ");
INSERT INTO uth_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","o ru̱ru̱te̱ hun-ne̱ ye̱ u̱n wu̱, wu̱a gu ye̱ be-de u̱n soks u̱n ba'as-de u̱n ye̱. ");
INSERT INTO uth_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Shir na ro̱ u̱r-'wo̱n ne̱. Wu̱a ru̱ ho̱-de rwu̱u̱n na u̱r-bon ne̱ ");
INSERT INTO uth_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","dea rwu̱u̱n karara n-to̱n u̱n ye̱ she'ete̱ u̱n comb-o̱ m-mar à, wu̱a 'er na-u̱s na u̱n bu̱-yo u̱n gwu̱gwu̱-mo̱ u̱r-hur.” ");
INSERT INTO uth_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Ka wà-wu̱ bo̱'o̱su̱te̱, komo u̱r-be̱e̱b de u̱n Ku̱kt-o Shir ne̱. Wu̱ she'ete̱ u̱n dak-o̱ o-dákár, har se̱ da-o̱ wu̱ rwu̱u̱ne̱ cas be-de u̱n hun-ne̱ ye̱ o-Isra. ");
INSERT INTO uth_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Da-o̱ ko-Gwo̱mo Sisar Agusu̱tu ko-wan-gwo̱mo-to̱ o-dak kap ze̱e̱, a oog hun-ne̱ ye̱ ro u̱n dak-to̱ Roma à. ");
INSERT INTO uth_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Da-o̱ u̱n ka o̱o̱g-de u̱r-takan de, Kwirinu ro ko-Gwamna u̱n dak-o̱ o-Siriya. ");
INSERT INTO uth_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Ko̱ wu̱ ke ka da-de haaru̱ a o̱o̱g wu̱ u̱n bo̱-o̱ u̱n wu̱. ");
INSERT INTO uth_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Yusuhu ma wu̱ ruuru̱ u̱n bo̱-o̱ o-Nazaret n-me̱ u̱n dak-o̱ o-Gariri, ha-mo̱ o-Be̱tarami n-me̱ u̱n dak-o̱ o-Judiya, be-de a mate̱ ko-Gwo̱mo Dawuda à. Yusuhu haaru̱ kane̱, remen so̱ u̱n baag-o Dawuda wu̱ rwu̱u̱ne̱. ");
INSERT INTO uth_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Wu̱ haag a ogt wu̱ u̱n Meri ne̱, ryap-de u̱n wu̱. Meri ro̱ u̱r-uub ne̱. ");
INSERT INTO uth_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Bo̱ ye̱ ro'e̱ o-Be̱tarami à, da-o̱ o-mat wo̱o̱nu̱ru̱ wu̱. ");
INSERT INTO uth_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Wu̱ matu̱ru̱ wà-wu̱ co-o̱ u̱n wu̱, wan-campo̱. Wu̱ ho̱kku̱ru̱ wu̱ u̱t-magund, wu̱ ru̱ssu̱ru̱ wu̱ u̱n rii-o̱ atte̱ u̱n ya-u̱t-gu̱t u̱t-zan à, remen ye̱ kum kuke̱-o̱ m-she'et á. ");
INSERT INTO uth_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Ya-u̱t-gu̱t ro kon so̱ u̱n ka dak-o̱, ye̱ ro̱ u̱n 'er-de u̱n kur-to̱ u̱n ye̱ m-te̱t. ");
INSERT INTO uth_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Ko-wan-to̱m-wu̱ Wan-Ko̱yan rwu̱u̱nu̱ru̱ be-de u̱n ye̱, se̱ps-mo̱ Shir daknu̱ru̱ u̱n ye̱. Ye̱ ho̱gu̱ru̱ o-gye̱r de̱e̱n. ");
INSERT INTO uth_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Amba ko-wan-to̱m-wu̱ Shir ze̱e̱ru̱ ye̱, “No̱ ho̱ge̱ o-gye̱r á! U̱m hantu̱te̱ no̱ Ma-to̱ m-Re̱re̱m, to̱ he m-hante̱ caari-o̱ o-zak o̱ u̱r-hur be-de u̱n hun-ne̱ kap à. ");
INSERT INTO uth_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","De ka ho̱-de n-me̱ u̱n bo̱-o Dawuda, a makt Wan-Gwu̱ no̱, Kiristi, Go̱s-wu̱. ");
INSERT INTO uth_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Komo napa-o̱ ka no̱, no̱ hyen wan-yaar ho̱kku̱sse̱ u̱t-magund do̱mb u̱n rii-o̱ atte̱ u̱n ya-u̱t-gu̱t u̱t-zan à.” ");
INSERT INTO uth_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","U̱n gyept-o̱ u̱n yish, bu̱u̱g-de u̱n yan-to̱m-ye̱ u̱n Shir n-To̱n rwu̱u̱nu̱ru̱, u̱n ko-wan-to̱m-wu̱ Shir ne̱, ye̱ ro u̱n hu'e̱ u̱n Shir se̱p-to̱ u̱r-bo̱ngo̱n: ");
INSERT INTO uth_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Se̱ke̱mse̱-mo̱ Shir n-To̱n, m-gwu̱gwu̱ mo̱ u̱r-hur u̱n ko̱ wu̱ ke be-de u̱n ka ye̱ Shir ro̱ o-zak u̱n ye̱ ne̱ à!” ");
INSERT INTO uth_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Da-o̱ yan-to̱m-ye̱ Shir arge̱, ye̱ ro̱ m-warag n-to̱n be-de Shir à, ya-u̱t-gu̱t ze̱e̱ru̱ hi u̱n de u̱n ye̱, “A neke̱ no̱ o-Be̱tarami a hyenet ka rii-yo no̱me̱ à, yo Wan-Ko̱yan ru̱ru̱ na à.” ");
INSERT INTO uth_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Ye̱ ruuru̱ ho̱r-m-ho̱r, ye̱ 'wo̱ssu̱ru̱ Meri u̱n Yusuhu, ye̱ hyanu̱ru̱ wan-yaar do̱mb u̱n rii-o̱ atte̱ u̱n ya-u̱t-gu̱t u̱t-zan à. ");
INSERT INTO uth_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Bo̱ ya-u̱t-gu̱t hyente̱ wu̱ à, ka ya-u̱t-gu̱t ye̱ ru̱ru̱ Meri ne̱ u̱n Yusuhu, yo ko-yan-to̱m-ye̱ Shir ru̱ru̱ ye̱, mo̱sse̱ u̱n ka wà-wu̱ ne̱ à. ");
INSERT INTO uth_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Kap ye̱ ho̱ge̱ ka ma-to̱ ya-u̱t-gu̱t rwo̱re̱ à, ye̱ bo̱pu̱ru̱ o-nu. ");
INSERT INTO uth_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Meri baksu̱ru̱ kap, wu̱ se̱ngu̱ru̱ u̱s-barag remen to̱. ");
INSERT INTO uth_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Ya-u̱t-gu̱t wargu̱ru̱ be-de u̱n gu̱t-to̱ u̱n ye̱, ye̱ ro̱ Shir u̱r-bo̱ngo̱n m-se̱k ne̱ remen kap yo ye̱ ho̱ge̱, ye̱ hyen komo à, yo no̱mo̱g hond hond bo̱ ko-wan-to̱m-wu̱ Shir ru̱ru̱ ye̱ à. ");
INSERT INTO uth_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Bo̱ ho̱-u̱t eer arge̱ à, da-o̱ a he wu̱ m-ko̱ à, a egu̱ru̱ wu̱ u̱r-jin Ye̱so ka jin-de ko-wan-to̱m-wu̱ Shir ege̱ wu̱ ba a u̱n nom uub-de u̱n wu̱ á. ");
INSERT INTO uth_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Bo̱ da-o wo̱o̱nte̱ o̱ Yusuhu ne̱ u̱n Meri hette̱ m-no̱m u̱n rii-yo Shir ze̱e̱ a nom da-o u̱n karamsa-o Mosa à. Remen kaane̱, ye̱ haaru̱ o-Urusharima ye̱ tebbu̱te̱ wu̱ be-de u̱n Wan-Ko̱yan. ");
INSERT INTO uth_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Bo̱ a ge̱ne̱ u̱n karamsa-o̱ u̱n Wan-Ko̱yan à, “Ko̱ wu̱ ke wà-wu̱ co wu̱, wan-campo̱ wu̱ Shir wu̱, a koos wu̱ a heet wu̱ be-u̱r Yawe.” ");
INSERT INTO uth_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Ye̱ haag komo ye̱ seketé̱ Shir, gorop yoor, ko̱ yan-tantabara yoor, bo̱ karamsa-o̱ u̱n Wan-Ko̱yan ze̱e̱ a nom à. ");
INSERT INTO uth_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","U̱n ka da-o̱ wu̱ ken ne̱t-wu̱ ro kon jin-de u̱n wu̱ Simo̱n wu̱ ro u̱r-she'et o-Urusharima. Ko-wan-gye̱r-o̱ Shir wu̱ kashi u̱n ne̱t komo, wu̱ ro u̱n 'er-de u̱n wan-m-gwu̱'u̱rse̱ u̱r-hur de ya-o-Isra. Wu̱ ro u̱n Ku̱kt-o̱ Shir ne̱. ");
INSERT INTO uth_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Komo Ku̱kt-o̱ Shir ru̱ru̱te̱ wu̱, wu̱a mer á, se̱ wu̱ hyanag Go̱s-wu̱ ka Kiristi, wu̱ Shir ze̱e̱ à. ");
INSERT INTO uth_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Bo̱ Ku̱kt-o̱ Shir kute̱ wu̱ à, Simo̱n co̱wu̱ru̱ u̱n Pyo-o̱ Shir. Da-o̱ ya-o-mat hante̱ Ye̱so n-me̱ u̱n Pyo-o̱ Shir ye̱ no̱mo̱te̱ wu̱ bo̱ karamsa-o̱ Shir ze̱e̱ à. ");
INSERT INTO uth_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simo̱n deku̱ru̱ ka wà-wu̱ u̱n kom-to̱ u̱n wu̱, wu̱ bo̱mu̱ru̱ Shir: ");
INSERT INTO uth_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“M-mo̱ka, ko-Gwo̱mo Wan-Ko̱yan, o shooste̱ ma-u̱t ru, wo̱a hoks m-yage̱ u̱n ko-gu̱w ru meret gwu̱gwu̱. ");
INSERT INTO uth_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Remen yish re hyanag gwu̱ ru. ");
INSERT INTO uth_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Wu̱ o to̱mne̱ hun-ne̱ kap ye̱ gu̱t à. ");
INSERT INTO uth_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Ya wu̱ ro̱ u̱ntu̱n cecas-mo̱ o-ra, mo̱ he rwo̱ u̱n ko̱ wu̱ ke m-haan be-de Shir à, komo wu̱ hantu̱te̱ m-se̱ps be-de u̱n hun-ne̱ ru ya-o-Isra.” ");
INSERT INTO uth_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","O-tato, o-inu ne̱, ye̱ u̱n ka wà-wu̱ bo̱pu̱ru̱ o-nu u̱n rii-yo Simo̱n ze̱e̱ remen ka wà-wu̱ à. ");
INSERT INTO uth_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simo̱n konu̱ru̱ ye̱ o-kwu̱m. Komo wu̱ ze̱e̱ru̱ Meri, inu-o̱ u̱n ka wà-wu̱, “Ka wà-wu̱ Shir daagne̱ wu̱ remen wu̱ ye̱ ken ye̱a hye, komo ye̱ ken ye̱a ine̱ n-me̱ o-Isra. Wu̱a es o-napa be-de Shir, wu̱ hun-ne̱ de̱e̱n he m-no̱m ma-to̱ u̱t-yage̱ à. ");
INSERT INTO uth_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Remen kaane̱ wu̱a rwu̱nte̱ cas barag-se ye̱ wuke̱ à. Me̱n-u̱t rim-to̱, u̱ntu̱n magay-o̱ m-rye, to̱a caat hur u̱n du.” ");
INSERT INTO uth_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","37","Wu̱ ken ko-mo̱ng-wu̱, wan-Rwo̱r u̱n Ma-to̱ Shir, ko-gwo̱r-wu̱ u̱n ne'a jin-de u̱n wu̱ Ana, wà Panure̱ u̱n so̱ u̱n baag-o Asher. Hak-u̱s ta'yoor bo̱ u̱n ge-to̱ u̱n wu̱, campo̱ u̱n wu̱ maru̱ru̱, m-mo̱ka wu̱ ro̱ ko-gwo̱r u̱s-hak kwo̱o̱z-u̱t nass u̱s-nass 84. Wu̱ ru wu̱ yage̱ Pyo-o̱ Shir á, m-ho̱w m-te̱t ne̱ wu̱ ro u̱n gu̱w-mo̱ Shir, o-swo̱o̱t u̱n ko̱n-se Shir ne̱. ");
INSERT INTO uth_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","U̱n ka da-o̱, wu̱ wo̱o̱nu̱ru̱, wu̱ nomu̱ru̱ Shir u̱r-bo̱ngo̱n, wu̱ no̱mu̱ru̱ ma-to̱ u̱n ka wà-wu̱ be-de u̱n kap ye̱ ro u̱r-'er de Shir rur o-Urusharima à. ");
INSERT INTO uth_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Bo̱ Meri ne̱ u̱n Yusuhu, komoste̱ m-no̱m kap bo̱ u̱n rii-yo karamsa-o̱ u̱n Wan-Ko̱yan ze̱e̱ à, ye̱ mu̱u̱nu̱ru̱ bo̱-o̱ u̱n ye̱ o-Nazaret n-me̱ o-Gariri. ");
INSERT INTO uth_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Ka wà-wu̱ bo̱su̱ru̱ wu̱ no̱mu̱ru̱ m-'wo̱ns, wu̱ dooru̱ u̱s-nap, komo kwu̱m-o̱ Shir ro̱ u̱n hi-de u̱n wu̱. ");
INSERT INTO uth_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Ko̱ o̱ ke hak-o̱, ye̱ mate̱ Ye̱so à ro̱ m-ha o-Urusharima remen Biki-o̱ m-Pas. ");
INSERT INTO uth_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Bo̱ Ye̱so wo̱o̱ste̱ hak-u̱s o̱p u̱n hak-u̱s yoor à 12, ye̱ dooru̱ m-ha u̱n ka biki-o̱ bo̱ ye̱ we̱te̱ à. ");
INSERT INTO uth_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Da-o̱ a komse̱ o-biki à, ye̱ bo̱pnu̱ru̱ co̱w-yo m-jo'on o-hur, amba ka wà-wu̱ Ye̱so e̱snu̱ru̱ o-Urusharima. Ye̱ mate̱ wu̱ à, ye̱ nap á. ");
INSERT INTO uth_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Ye̱ ro̱ m-ze̱e̱ ko̱ wu̱ ro̱ n-me̱ u̱n hun-ne̱, ye̱ hewte̱ taas u̱r-ho̱, ka da-de ye̱ taknu̱ru̱ hoob-o̱ u̱n wu̱ be-de u̱n yan-baag-o̱ u̱n ye̱ u̱n nay u̱n ye̱ ne̱ ne̱. ");
INSERT INTO uth_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Ye̱ hyan wu̱ á, ka da-o̱ ye̱ mu̱u̱nu̱ru̱ o-Urusharima hoob-o̱ u̱n wu̱. ");
INSERT INTO uth_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Ho̱-u̱r atette̱-de ye̱ 'wo̱ssu̱ wu̱ n-me̱ u̱n Pyo-o̱ Shir, wu̱ ro̱ tara be-de u̱n yan-yoose̱ u̱n Yahuda-ne̱, wu̱ ro̱ m-ho̱ge̱ u̱n yo ye̱ ro̱ m-rwo̱r à, wu̱ ro̱ ye̱ m-cit komo. ");
INSERT INTO uth_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Kap ye̱ ho̱ge̱ wu̱ à, ye̱ bo̱pu̱ru̱ o-nu, remen go̱n shas-o̱ wu̱ ro̱ ye̱ m-shas à, o̱ u̱s-nap. ");
INSERT INTO uth_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Ye̱ mate̱ wu̱ à, ye̱ hyanu̱ to̱ u̱t-hyangan da-o̱ ye̱ hyane̱ wu̱ à, inu u̱n wu̱ ze̱e̱ru̱ wu̱, “Wà re, ¿remen yan o̱ o nomtu̱ te̱ kaane̱? Me̱n-u̱t nassu̱te̱ tato ru u̱n me̱ ne̱, te̱ pu̱'u̱g u̱n hoob-o ru.” ");
INSERT INTO uth_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Wu̱ shasu̱ru̱ ye̱, “¿Remen yan o̱ no̱ ro̱tte̱ me̱ o-hoob? ¿No̱ nap u̱nze depete̱ u̱m ma'as n-me̱ u̱n hur-o Tato re á?” ");
INSERT INTO uth_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Amba ye̱ nap go̱n ka shas-o̱ á. ");
INSERT INTO uth_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Wu̱ nomu̱ru̱ ye̱ o-do̱ro̱tte̱, wu̱ wargu̱ru̱ u̱n ye̱ ne̱ o-Nazaret. Inu u̱n wu̱ e̱ssu̱ru̱ kap ka rii-yo u̱n hur-de u̱n wu̱. ");
INSERT INTO uth_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Ye̱so bo̱'o̱ssu̱ru̱ o-wu̱r u̱s-we̱e̱r ne̱, wu̱ re̱e̱g u̱r-ho̱ be-de Shir u̱n hun-ne̱ ne̱. ");
INSERT INTO uth_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Hak-u̱s o̱p u̱s-taan 15 u̱n gwo̱mo-u̱t ko-Gwo̱mo Sisar Tiberiyos, Panti Biratus ro ko-Gwamna to̱ u̱n dak-o̱ o-Judiya, Here̱ Atipas ro ko-Gwamna to̱ o-Gariri, komo heno u̱n wu̱ Pirip ro ko-Gwamna dak-to̱ o-Ituriya u̱n o-Tu̱rakonitis ne̱, Bisaniyas ro ko-Gwamna to̱ Abirene̱. ");
INSERT INTO uth_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Komo Annas, u̱n Ke̱pas ne̱, ye̱ ro Gwo̱mo-ne̱ ye̱ u̱n ko̱n-se Shir. U̱n ka da-o̱, Yohana wà Zakaraya ho̱gu̱te̱ Ma-to̱ Shir be-de wu̱ ro'e̱ o-dákár à. ");
INSERT INTO uth_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Ka da-de Yohana pa'u̱ru̱ riib-o̱ o-ro̱o̱g o-Joda kap, wu̱ ro m-ru̱re̱ u̱n hun-ne̱ Ma-to̱ Shir, “Yagu̱ no̱ u̱r-ba'as, no̱ waktu̱ne̱ be-de Shir, no̱ haan, a yo'os no̱ m-ho̱, Shir a soks ba'as-u̱r no̱.” ");
INSERT INTO uth_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Gense̱ to̱ ro̱ u̱n taku̱rda-o Ishayawan-Rwo̱r u̱n Ma-to̱ Shir: “Wu̱ ken wu̱ ro̱ u̱s-eeg o-dákár. ‘Ja'ase̱ Yawe o-co̱w, ke'egse̱ yo u̱r-bon ne̱ hond hond bo̱ wu̱ he m-do̱re̱ à! ");
INSERT INTO uth_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Bish ko̱ o̱ ke bu̱ng-o̱, o ke'egse̱ ko̱ de ke dor-de o-haag ne̱. Co̱w-se nange̱ à, o ke'egse̱ se, se ro̱ hak hak à, o ja'as se po̱r po̱r. ");
INSERT INTO uth_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Bo̱ u̱n mat-o̱ u̱n hun-ne̱ kap ye̱a hyen gwu̱-o Shir!’ ” ");
INSERT INTO uth_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Bu̱u̱g-de u̱n hun-ne̱ rwu̱u̱nu̱ru̱ be-u̱r Yohana wu̱ yo'os ye̱ m-ho̱. Bo̱ wu̱ ze̱e̱ ye̱ à, “No̱ ye̱ge̱-herhyat! ¿Wa ru̱ru̱ no̱, no̱ som swo̱ u̱r-ko̱o̱b de Shir ro̱ no̱ u̱n ma-to̱ m-hante̱ à? ");
INSERT INTO uth_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","No̱m no̱ rii-yo u̱r-bon, yo a hette̱ m-hyan no̱ yagu̱te̱ ka ba'as-de no̱ ro̱ m-no̱m à, no̱ waktu̱ne̱ be-de u̱n Shir u̱ntu̱n 'yo-yo mate̱ yakar-ye̱ u̱r-bon à. No̱ ze̱e̱ hi u̱n no̱ Ibrahi wu̱ ro̱ ko-yan-ga-ye̱ no̱. Me̱ no̱ m-ru̱re̱, Shir a hoks ka ta'ar-to̱ m-muut u̱n hun-ne̱ ye̱ rwu̱u̱ne̱ so̱ u̱n baag-o̱ Ibrahi à! ");
INSERT INTO uth_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Yar-u̱r ro̱ u̱t-kom a kupste̱ ka 'yo-se n-dak, kap 'yo-yo mate̱ yakar-ye̱ u̱r-bon á, a kups yo n-dak a jorbe̱ yo o-ra.” ");
INSERT INTO uth_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Ka hun-ne̱ ye̱ citu̱ru̱ wu̱, “¿Ya ne̱ te̱ he o̱ ka m-no̱m?” ");
INSERT INTO uth_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Wu̱ shasu̱ru̱ ye̱, “Wu̱ ro̱ u̱t-matuku ne̱ u̱t-yoor à, wu̱ 'ye wu̱ ro̱tte̱ á u̱r-gaan, wu̱ ro̱ u̱n rii-yo m-re̱ ne̱ à, wu̱ wong yo.” ");
INSERT INTO uth_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Yan-go̱ks u̱n tar haanu̱ru̱ a yo'oste̱ ye̱ m-ho̱, ye̱ citu̱ru̱ wu̱, “Wa-u̱r-Yoos, ¿ya ne̱ te̱ he m-no̱m?” ");
INSERT INTO uth_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Wu̱ ze̱e̱ru̱ ye̱, “Bo̱ a ze̱e̱ no̱ go̱ks à, kaane̱ no̱ he m-go̱ks no̱ do̱ rii á.” ");
INSERT INTO uth_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Karma-ne̱ citu̱ru̱ wu̱, “Te̱ ne̱ komo, ¿ya ne̱ te̱ he m-no̱m?” Wu̱ ze̱e̱ru̱ ye̱, “No̱ rumus hun-ne̱ hwo̱r m-'wo̱ns á, no̱ ce'e̱ ne̱t u̱t-ma á. E̱s no̱ be-de u̱n hwo̱r-ye̱ o-re̱ng ye̱ a no̱ m-to̱p à.” ");
INSERT INTO uth_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Hun-ne̱ no̱mu̱ru̱ o-dish, ye̱ taknu̱ru̱ u̱s-barag ko̱ Yohana wu̱ ro̱ Kiristi. ");
INSERT INTO uth_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Yohana ze̱e̱ru̱ ye̱ kap, “U̱m yo'ostu̱ no̱ m-ho̱, amba wu̱ ken wu̱ ro̱o̱n wu̱ jiishe̱ me̱ à. Me̱ bo'os ma u̱m usse̱ wu̱ u̱t-ka'ante̱ á. Wu̱a yo'os no̱ u̱n Ku̱kt-o̱ Shir o-ra ne̱. ");
INSERT INTO uth_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Wu̱ ro̱ u̱n ko̱k-de u̱n wu̱ ne̱ de m-jer, wu̱ bu'ut hyo-ye̱ u̱n wu̱ kap, wu̱ ru̱'u̱t ye̱ u̱n byo-de u̱n wu̱, amba wu̱a tu̱ks ka gwo̱p-mo̱ u̱t-nu ne̱ o-ra, o̱ ba m-ryomse̱.” ");
INSERT INTO uth_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","U̱s-co̱w de̱e̱n, se Yohana ru̱rte̱ ka Ma-to̱ m-Re̱re̱m to̱ be-de u̱n hun-ne̱ à, wu̱ ro̱ ye̱ m-ze̱e̱ ye̱ yage̱ co̱w-se u̱n ba u̱r-bon. ");
INSERT INTO uth_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Amba Yohana ru̱ru̱te̱ Here̱ Atipas ko-Gwamna u̱t-ma m-'wo̱ns ne̱ remen wu̱ gaag Herodiya, ne'a heno u̱n wu̱, komo wu̱ no̱mo̱g rii-yo ba u̱r-bon de̱e̱n. ");
INSERT INTO uth_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Ka da-o̱ komo Here̱ dooru̱ m-no̱m u̱n rii-yo ba u̱r-bon yo jiishe̱ à, remen wu̱ ka'ag Yohana. ");
INSERT INTO uth_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Bo̱ a komte̱ yo'os u̱n hun-ne̱ m-ho̱ à, wu̱ ma Ye̱so a yo'osu̱ru̱ wu̱. Da-o̱ wu̱ ro u̱n ko̱n-se Shir à, To̱n-o shir upsu̱ru̱. ");
INSERT INTO uth_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Ku̱kt-o̱ Shir haanu̱ru̱ be-u̱r Ye̱so u̱ntu̱n o-tantabara. A ho̱gu̱ru̱ o-co̱r n-To̱n shir, “Wo̱ ro̱ wà re. Me̱ gwu̱gwu̱ u̱n wo̱ ne̱ u̱m co̱no̱g wo̱.” ");
INSERT INTO uth_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Da-o̱ Ye̱so takne̱ se̱nge̱-mo̱ u̱n wu̱ à, wu̱ ro̱ u̱ntu̱n hak-u̱r kwo̱o̱z u̱s-o̱p 30. Wu̱ wà-wu̱, remen kaane̱ hun-ne̱ cekru̱ru̱ ye̱ ze̱e̱ru̱ wà Yusuhu, wà Heri. ");
INSERT INTO uth_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Wà Matta wu̱ ma Rewi, wà Meru̱ci, wu̱ ma Jannay, wà Yusuhu. ");
INSERT INTO uth_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Wà Mattayas, wu̱ ma E̱mos, wà Nahum, wu̱ ma Esu̱ri, wà Naggay. ");
INSERT INTO uth_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Wà Maat, wu̱ ma Mattayas, wà Semen, wu̱ ma Jose̱ci, wà Joda. ");
INSERT INTO uth_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Wà Jo'anan, wu̱ ma Resa, wà Ze̱rubabe̱r, wu̱ ma Shetiyer, wà Neri. ");
INSERT INTO uth_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Wà Meru̱ci, wu̱ ma Addi, wà Kosam, wu̱ ma Ermadam, wà Er. ");
INSERT INTO uth_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Wà Josuwa, wu̱ ma Eriyazer, wà Jorim, wu̱ ma Matta, wà Rewi. ");
INSERT INTO uth_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Wà Simo̱n, wu̱ ma Yahuda, wà Yusuhu, wu̱ ma Jonan, wà E̱riyakim. ");
INSERT INTO uth_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Wà Mereya, wu̱ ma Menna, wà Mattaha, wu̱ ma Natan, wà Dawuda. ");
INSERT INTO uth_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Wà Je̱sse̱, wu̱ ma Obe̱d, wà Bo'az, wu̱ ma Saru̱mon, wà Nashon. ");
INSERT INTO uth_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Wà Aminadab, wu̱ ma Adu̱min, wà Aru̱ni, wu̱ ma He̱zu̱ron, wà Perez, wu̱ ma Yahuda. ");
INSERT INTO uth_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Wà Yakubu, wu̱ ma Ishaku, wà Ibrahi, wu̱ ma Tera, wà Naho̱r. ");
INSERT INTO uth_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Wà Se̱rug, wu̱ ma Riw, wà Pu̱re̱, wu̱ ma E̱ber, wà Shera. ");
INSERT INTO uth_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Wà Kayinan, wu̱ ma Aru̱pazad, wà Shem, wu̱ ma Nuhu, wà Ramek. ");
INSERT INTO uth_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Wà Me̱tuse̱ra, wu̱ ma Enok, wà Jaret, wu̱ ma Mahararer, wà Kenan. ");
INSERT INTO uth_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Wà E̱no̱sh, wu̱ ma Shitu, wà Adamu, Adamu wà-wu̱ Shir. ");
INSERT INTO uth_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Ye̱so waktu̱nte̱ so̱ o-ro̱o̱g o-Joda shiishe̱ ce̱ngce̱ng u̱n Ku̱kt-o Shir, o̱ tekeru̱ wu̱ co o̱ heetu̱ru̱ wu̱ o-dákár. ");
INSERT INTO uth_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Kane̱ ko-Gwo̱mo-wu̱ u̱n ya-u̱t-ko̱t megre̱ Ye̱so ho̱-u̱t kwo̱o̱z-u̱t yoor 40. Kap ka ho̱-to̱ Ye̱so wu̱ re̱ rii á, remen kaane̱ wu̱ ro̱ u̱n ho̱ge̱ u̱n me̱r da-o̱ wu̱ taase o-swo̱o̱t à. ");
INSERT INTO uth_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Ko-Gwo̱mo-wu̱ u̱n ya-u̱t-ko̱t ze̱e̱ru̱ Ye̱so, “U̱rege̱ wo̱ wà-wu̱ Shir wu̱, rwo̱ ka ta'ar-de barme̱ rii-yo m-re̱.” ");
INSERT INTO uth_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Amba Ye̱so shasu̱ru̱, “Ma-to̱ Shir ze̱e̱g, ‘Ne̱t a no̱m ho̱o̱g remen u̱t-ga u̱n ho̱n-de u̱n to̱ á.’ ” ");
INSERT INTO uth_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Ka da-de ko-Gwo̱mo-wu̱ u̱n ya-u̱t-ko̱t detu̱ru̱ wu̱ n-to̱n. U̱n gyept-o̱ u̱n yish, wu̱ kutu̱ru̱ Ye̱so gwo̱mo-to̱ o-dak pitip. ");
INSERT INTO uth_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Ko-Gwo̱mo-wu̱ u̱n ya-u̱t-ko̱t ze̱e̱ru̱ Ye̱so, “Man ya'as wo̱ ka gwo̱mo-to̱ kap u̱n se̱ps-mo̱ u̱n to̱ ne̱, remen a ya'astu̱ me̱ to̱ kap, komo man hoks m-ya'as u̱n wu̱ u̱m co̱ne̱ m-ya'as à. ");
INSERT INTO uth_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Kap to̱a warag-u̱t ma ru, u̱rege̱ wo̱a kwu̱ktu̱ me̱, o 'ye me̱ m-se̱k.” ");
INSERT INTO uth_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Ye̱so shasu̱ru̱, “Ma-to̱ Shir ze̱e̱g, ‘Kwu̱kte̱ Yawe Shir ru, wu̱ wu̱ cot o he m-nome̱ m-gu̱w!’ ” ");
INSERT INTO uth_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Ka da-de, ko-Gwo̱mo-wu̱ u̱n ya-u̱t-ko̱t deku̱ru̱ Ye̱so, wu̱ heteru̱ wu̱ o-Urusharima. Wu̱ detu̱ru̱ Ye̱so u̱n be-de jiishe̱ m-pipir à, n-to̱n u̱n Pyo-o̱ Shir, wu̱ ze̱e̱ru̱ Ye̱so, “U̱rege̱ wo̱ wà-wu̱ Shir wu̱ hukse̱ n-dak, ");
INSERT INTO uth_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","remen Ma-to̱ Shir ze̱e̱g, ‘Shir a ru̱ yan-to̱m-ye̱ u̱n wu̱ ye̱ 'er wo̱.’ ");
INSERT INTO uth_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","To̱ ze̱e̱g komo, ‘Ye̱a go̱ks wo̱ u̱n kom-to̱ u̱n ye̱ bo̱ ko̱ na-o ru o̱a ho̱ge̱ m-hoog be-de u̱t-ta'ar à.’ ” ");
INSERT INTO uth_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Amba Ye̱so shaks, wu̱ zee, “Ma-to̱ Shir ze̱e̱g, ‘Wo̱ meger Yawe Shir ru á.’ ” ");
INSERT INTO uth_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Bo̱ ko-Gwo̱mo-wu̱ u̱n ya-u̱t-ko̱t komte̱ meger-u̱t Ye̱so u̱n ko̱ yo ke co̱w-yo à, wu̱ yagu̱ru̱ wu̱ se̱ o̱ ken da-o̱. ");
INSERT INTO uth_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Ka da-de Ye̱so wargu̱ru̱ o-Gariri, komo 'wo̱ns-mo̱ u̱n Ku̱kt-o Shir ro̱ be-de u̱n wu̱. Ma-to̱ u̱n wu̱ wo̱o̱ru̱ ko kene̱ so̱ u̱n ka dak-o̱. ");
INSERT INTO uth_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Wu̱ yooste̱ n-me̱ u̱n kuke̱-to̱ u̱n yoos u̱n Ma-to̱ Shir, komo ko̱ wu̱ ke bo̱mo̱g wu̱. ");
INSERT INTO uth_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Ka da-de Ye̱so haaru̱ o-Nazaret, be-de a 'yonse̱ wu̱ à, bo̱ Ho̱-de u̱r-Wu̱we̱ wo̱o̱ne̱ à, wu̱ haaru̱ bo̱ wu̱ we̱te̱ m-ha u̱n kuke̱-o̱ u̱n yoos u̱n Ma-to̱ Shir à. Wu̱ inu̱ru̱ eso wu̱ karantu̱te̱ Ma-to̱ Shir. ");
INSERT INTO uth_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Komo a tebbu̱ru̱ wu̱ taku̱rda-o̱ Ishayawan-Rwo̱r u̱n Ma-to̱ Shir. Wu̱ upsu̱ru̱, wu̱ hyanu̱ru̱ be-de a ge̱ne̱: ");
INSERT INTO uth_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Ku̱kt-o̱ u̱n Yawe ro̱ u̱n hi u̱n de, remen wu̱ dagante̱ me̱ u̱m hantu̱te̱ ko̱o̱b-ne̱ ka Ma-to̱ m-Re̱re̱m to̱. Wu̱ to̱mu̱nte̱ me̱ u̱m ko̱'o̱t a us ka ye̱ a gage̱ à, komo u̱n ups u̱n yish-ye̱ u̱n po̱-ne̱ ne̱. U̱m guut ye̱ a mo̱'e̱ à, ");
INSERT INTO uth_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","a ko̱'o̱t da-o wo̱o̱nte̱, o̱ Yawe hette̱ m-gu u̱n hun-ne̱ ye̱ u̱n wu̱ à.” ");
INSERT INTO uth_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Ye̱so tigu̱ru̱ ka taku̱rda-o̱, wu̱ tebbu̱ru̱ wu̱ ro̱ kane̱ à, wu̱ she'etu̱ru̱ tara. Kap ka hun-ne̱ ye̱, ro n-me̱ kuke̱-o̱ u̱n yoos u̱n Ma-to̱ Shir à tuuru̱ wu̱ yish, ");
INSERT INTO uth_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","ka da-de wu̱ ze̱e̱ ye̱, “Ka be-de u̱n Ma-to̱ Shir to̱ shiig caane̱, bo̱ no̱ ho̱ge̱ a karantu̱te̱ à.” ");
INSERT INTO uth_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Kap ye̱ ho̱gu̱te̱ re̱re̱m-mo̱ u̱n wu̱, ye̱ bo̱pu̱ru̱ o-nu u̱n go̱n ka gom-to̱ wu̱ rwo̱re̱ à. Ye̱ ze̱e̱ru̱, “¿Wà Yusuhu wu̱ kaa?” ");
INSERT INTO uth_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Wu̱ ze̱e̱ru̱ ye̱, “U̱m nak no̱a ru̱ru̱ me̱ ka swo̱o̱g-o̱ u̱t-ma o̱, ‘Wa-u̱s-baat 'yons hi u̱n du,’ komo no̱ ru̱ru̱ me̱ u̱m nom kaane̱ u̱n bo̱-o re ka rii-to̱ no̱ ho̱ge̱ u̱m no̱mo̱g o-Kapanahum à.” ");
INSERT INTO uth_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Ye̱so dooru̱ m-ze̱e̱, “Me̱ no̱ m-ru̱re̱ o-nip, a ce̱t m-go̱ks u̱n ko-yan-rwo̱r u̱n Ma-to̱ Shir u̱n bo̱-o̱ u̱n wu̱ á. ");
INSERT INTO uth_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","“Nip-o̱ gwo̱r-ne̱ no̱mo̱g de̱e̱n u̱n dak-o o-Isra u̱n da-o E̱reja, da-o̱ a no̱me̱ hak-u̱s tet u̱r-pu̱ru̱g ba u̱n kem à, komo a no̱mo̱g me̱r u̱n ka dak-o̱ kap. ");
INSERT INTO uth_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Shir to̱m E̱reja ko̱ kene̱ u̱n dak-o̱ o-Isra á, amba se̱ be-de u̱n wu̱ ken ko-gwo̱r-wu̱ u̱n ne'a wu̱, ba ko-Isra á, wu̱ ro̱ o-Zaraha u̱n so̱ u̱n dak-o̱ o-Sidon. ");
INSERT INTO uth_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Hun-ne̱ de̱e̱n ro̱ u̱n swo̱ u̱r-ko̱o̱b u̱n gom-o̱ u̱t-cim n-dak o-Isra da-o E̱reshawan-Rwo̱r u̱n Ma-to̱ Shir, Yatt-wu̱ ka go̱m-o̱ ta'e̱ u̱n wu̱r-o̱ u̱n wu̱ á, se̱ Na'aman ko-ya-o-Siriya.” ");
INSERT INTO uth_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Da-o̱ hun-ne̱ ye̱ ro̱ u̱n kuke̱-o̱ u̱n yoos u̱n Ma-to̱ Shir ho̱ge̱ kaane̱ à, ryaab-u̱s ho̱o̱ru̱ ye̱. ");
INSERT INTO uth_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Ye̱ inu̱ru̱ eso, ye̱ naku̱ru̱ Ye̱so ye̱ ruutu̱ru̱ wu̱ jim-de o-bo̱, ye̱ detu̱ru̱ wu̱ n-to̱n u̱r-dor de a meete̱ bo̱-o̱ u̱n ye̱ à. Ye̱ ro̱ u̱n ma-to̱ ye̱ jorbu̱te̱ wu̱ o-bu̱ng. ");
INSERT INTO uth_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Amba wu̱ co̱wu̱ru̱ u̱n te̱te̱-o̱ u̱n hun-ne̱ wu̱ argu̱ru̱ arag-mo̱ u̱n wu̱. ");
INSERT INTO uth_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Ka da-de ne̱ Ye̱so haaru̱ o-Kapanahum, o̱ ken bo̱-o̱ u̱n dak-o̱ o-Gariri, kane̱ wu̱ ro̱ m-yoose̱ u̱n hun-ne̱ u̱n kuke̱-o̱ u̱n yoos u̱n Ma-to̱ Shir, ko̱ de ke Ho̱-de u̱r-Wu̱we̱ de. ");
INSERT INTO uth_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Ye̱ bo̱pu̱ru̱ nu-se u̱n ye̱ remen bo̱ wu̱ yoose̱ ye̱ à, wu̱ rwo̱ro̱g u̱t-ma gwo̱mo-u̱t gwo̱mo. ");
INSERT INTO uth_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","N-me̱ u̱n kuke̱-o̱ u̱n yoos u̱n Ma-to̱ Shir, wu̱ ken ne̱t-wu̱ ro̱ kane̱ wu̱ ro̱ u̱n wa-u̱t-ko̱t ne̱ u̱n hi-de u̱n wu̱ à, wu̱ 'yonsu̱ru̱ u̱s-co̱r wu̱ kanu̱ru̱, ");
INSERT INTO uth_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“A'a! Ye̱so wu̱ o-Nazaret, ¿ya ne̱ o co̱ne̱ u̱n te̱ ne̱? ¿Wo̱ u̱n haan o sabu̱rse̱ te̱? U̱m nepse̱ wo̱, ko wan wu̱: Wo̱ wu̱ ba m-ku̱ko̱p, wu̱ Shir to̱mne̱ à!” ");
INSERT INTO uth_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Ye̱so huru̱ru̱ ka wa-u̱t-ko̱t wu̱ u̱t-gaag, “Re̱s temb, komo ru be-de u̱n ka ne̱t-wu̱!” Ka wa-u̱t-ko̱t wu̱ so̱ru̱ ka ne̱t-wu̱ n-dak, hun-ne̱ ro̱ gu̱t, wu̱ ruuru̱ be-de u̱n wu̱, wu̱ ho̱gu̱sse̱ wu̱ m-ho̱o̱g á. ");
INSERT INTO uth_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Ka hun-ne̱ ye̱ bo̱pu̱ru̱ o-nu, ye̱ ze̱e̱ru̱ hi u̱n de u̱n ye̱, “¿Yan go̱n ma-to̱ ne̱ to̱ ka? U̱t-gwo̱mo u̱r-be̱e̱b ne̱ ka ne̱t-wu̱ ze̱e̱ ka ya-u̱t-ko̱t ye̱ ru, komo ye̱ ruuru̱!” ");
INSERT INTO uth_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Komo ma-u̱t Ye̱so wo̱o̱ru̱ ko̱ kene̱ u̱n ka raag-o̱. ");
INSERT INTO uth_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Ye̱so ruuru̱ be-de u̱n kuke̱-o̱ u̱n yoos u̱n Ma-to̱ Shir, wu̱ haaru̱ hur-o Simo̱n. Wu̱r-o mo̱'o̱n Simo̱n ne̱ ne'a dengu̱te̱ o-ra de̱e̱n ye̱ te̱psu̱ru̱ Ye̱so ye̱ ko̱nu̱ru̱ wu̱ taas go̱m-o̱ u̱n wu̱. ");
INSERT INTO uth_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Ye̱so haaru̱ wu̱ e̱su̱ru̱ u̱n riib-o̱ kwu̱u̱r-o̱ u̱n ka ne'a-wu̱, wu̱ rwo̱'u̱ru̱ ka go̱m-o̱ m-ru u̱n wu̱r-o̱ u̱n ka ne'a-wu̱. Ka go̱m-o̱ ruuru̱, ka ne'a-wu̱ inu̱ru̱ kagat. Wu̱ jegu̱ru̱ ye̱ rii-yo m-re̱. ");
INSERT INTO uth_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Da-o̱ rim-m no̱me̱ à, kap ye̱ ro̱ u̱n hun-ne̱ ne̱ u̱s-go̱m ne̱ à, hantu̱ru̱ ye̱ be-u̱r Ye̱so, wu̱ saku̱ru̱ kom-to̱ u̱n wu̱ n-to̱n u̱n ko̱ wu̱ ke, ka go̱m-se taaru̱. ");
INSERT INTO uth_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Ya-u̱t-ko̱t ruuru̱ be-de u̱n hun-ne̱ de̱e̱n ye̱ ro̱ u̱n ye̱ ne̱ à, ye̱ ro̱ u̱n 'yons u̱s-co̱r, “Wo̱ Wà-wu̱ Shir wu̱!” Ye̱so huru̱ ye̱ u̱t-gaag, ye̱ te̱pe̱r á, remen ye̱ nepse̱ Shir daagne̱ wu̱. ");
INSERT INTO uth_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Bo̱ ish geste̱ à, Ye̱so yagu̱ru̱ o-bo̱ wu̱ haaru̱ de ken be-de ba u̱n hun-ne̱ de, u̱n ho̱n-de u̱n wu̱. Hun-ne̱ taknu̱ru̱ hoob-o̱ u̱n wu̱, bo̱ ye̱ hyente̱ wu̱ à, ye̱ co̱n wu̱ arag, wu̱ yage̱ ye̱ á. ");
INSERT INTO uth_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Amba wu̱ ze̱e̱ru̱ ye̱, “Se̱ u̱m rwo̱ro̱g Ma-to̱ m-Re̱re̱m to̱ u̱n gwo̱mo-to̱ Shir u̱n to̱ ken bo̱-to̱ komo, remen yo Shir to̱mnu̱ me̱ u̱m no̱m yo ka.” ");
INSERT INTO uth_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ka da-de wu̱ rwo̱ru̱ru̱ Ma-to̱ Shir n-me̱ u̱n kuke̱-to̱ u̱n yoos u̱n Ma-to̱ Shir ho̱no dak-o̱ o-Judiya. ");
INSERT INTO uth_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","De ken ho̱-de Ye̱so ro̱ eso jit-de Mar-o̱ o-Gariri ka da-o̱ hun-ne̱ mo̱ru̱ru̱ wu̱, remen ye̱ ho̱gu̱té̱ Ma-to̱ Shir. ");
INSERT INTO uth_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Wu̱ hyanu̱ru̱ hat u̱t-yoor, to̱ a ruute̱ o-dor à, yan-ship u̱n jan yagu̱te̱ to̱ ye̱ ro̱ m-so'os u̱t-yo. ");
INSERT INTO uth_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Ye̱so daaru̱ hat-o̱ gaan, o̱ ma Simo̱n wu̱ ze̱e̱ru̱ wu̱ tudbe̱ o̱ hiin n-me̱ m-sa. Ye̱so she'etu̱ru̱ n-me̱ o-hat wu̱ yoosu̱ru̱ ka bu̱u̱g-de u̱n hun-ne̱ de. ");
INSERT INTO uth_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Bo̱ wu̱ komte̱ u̱t-ma à, wu̱ ze̱e̱ru̱ Simo̱n, “Tudbe̱ ka hat-o̱ so̱ u̱r-du̱w, wo̱ u̱n hun-ne̱ ru ne̱, no̱ he̱'e̱dbe̱ o-yo, no̱ shipt jan.” ");
INSERT INTO uth_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simo̱n shasu̱ru̱, “Go̱s-wu̱, te̱ se̱ngu̱te̱ m-te̱t kap, te̱ ship rii á. Amba bo̱ o zette̱ kaane̱, man he̱'e̱dbe̱ o-yo.” ");
INSERT INTO uth_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Ye̱ he̱'e̱dbu̱ru̱ o-yo ye̱ shipu̱ru̱ jan de̱e̱n har yo-o̱ ro̱ ma-to̱ m-yishe̱. ");
INSERT INTO uth_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Ye̱ agnu̱ru̱ o̱r u̱n ye̱ ya-u̱t-yo, ye̱ ro̱ u̱n o̱ ken hat-o̱ à, ye̱ haan ye̱ gu ye̱. Ye̱ shoosu̱ru̱ ka hat-to̱ u̱t-yoor u̱n jan, har to̱ ro̱ ma-to̱ m-yi. ");
INSERT INTO uth_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Da-o̱ Simo̱n Bitrus hyane̱ kaane̱ à, wu̱ kwu̱ktu̱ru̱ u̱n rwu̱n-se u̱n wu̱ be-u̱r Ye̱so, wu̱ ze̱e̱ru̱, “Go̱s-wu̱, arag be u̱n de! Me̱ ko-ya-u̱r-ba'as-wu̱!” ");
INSERT INTO uth_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Wu̱ u̱n o̱r u̱n wu̱ ne̱, ye̱ bo̱pu̱ru̱ o-nu remen ye̱ shipk jan de̱e̱n. ");
INSERT INTO uth_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Kaane̱ no̱me̱ Bitrus u̱n o̱r u̱n wu̱ ne̱ ne̱ ya-u̱t-yo, Yakubu u̱n Yohana (yakar Ze̱be̱di). Ye̱so ze̱e̱ru̱ Simo̱n, “Wo̱ ho̱ge̱ o-gye̱r á, m-mo̱ka wo̱a warag wan-hante̱ u̱n hun-ne̱ be-de Shir, bo̱ wo̱ u̱n ship u̱n jan à.” ");
INSERT INTO uth_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Ye̱ ruutu̱ru̱ ka hat-to̱ u̱r-dor, ye̱ yagu̱ru̱ ko yo ke rii-yo, ye̱ do̱ru̱ru̱ Ye̱so. ");
INSERT INTO uth_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Bo̱ Ye̱so ro u̱n o̱ ken bo̱-o̱ à, wu̱ ken ne̱t-wu̱ ro u̱n swo̱ u̱r-ko̱o̱b u̱n go̱m-o̱ u̱t-cim. Bo̱ wu̱ hyente̱ Ye̱so à, wu̱ so̱ru̱ hi u̱n de u̱n wu̱ n-dak wu̱ ko̱nu̱ru̱ Ye̱so, wu̱ ze̱e̱ru̱, “Go̱s-wu̱, wo̱ cu̱ne̱, wo̱a taas go̱m re.” ");
INSERT INTO uth_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Ye̱so tapu̱ru̱ kom-o̱ u̱n wu̱, wu̱ ci'u̱ru̱ wu̱. “U̱m co̱no̱g. Warag po̱r po̱r!” Da-o̱ gaan, ka go̱m-o̱ ta wu̱. ");
INSERT INTO uth_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Ye̱so naku̱ru̱ wu̱ u̱t-to̱, “Wo̱ ru̱re̱ ko-wan-gaan á, amba neke̱ be-de u̱n wan-Co̱w u̱n ko̱n-se Shir, wu̱ byarag wo̱, remen ko̱ wu̱ ke nept go̱m-o ru taag, o seke̱ yar-mo̱ Mosa ze̱e̱ a seke̱ à.” ");
INSERT INTO uth_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Amba myet u̱n kaane̱, ma-u̱t Ye̱so wo̱o̱ru̱ ko̱ de ke ko'so-de, hun-ne̱ haante̱ de̱e̱n ye̱ ho̱gu̱te̱ wu̱, komo wu̱ taaste̱ go̱m-se u̱n ye̱. ");
INSERT INTO uth_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Amba Ye̱so ro̱ m-ha de ken be-de ba hun-ne̱ de, u̱n ho̱n-de u̱n wu̱, wu̱ konot Shir kane̱. ");
INSERT INTO uth_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","De ken ho̱-de Ye̱so ro̱ u̱r-yoos, Parisa-ne̱ u̱n yan-Yoos-de o-karamsa ne̱ ro̱ tara tara ye̱ rwu̱u̱ne̱ kap bo̱-to̱ n-dak o-Gariri, n-dak o-Judiya ne̱, o-Urusharima ne̱ à. 'Wo̱ns-mo̱ Wan-Ko̱yan ro̱ mo̱sse̱ u̱n wu̱ ne̱ remen Ye̱so taasté̱ ya-u̱s-go̱m, go̱m-se u̱n ye̱. ");
INSERT INTO uth_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Ye̱ ken hun-ne̱ ye̱ sawnu̱ru̱ wu̱ ken ko-ryam-wu̱, o-karanga, ye̱ se̱ngu̱ru̱ ye̱ tu̱wu̱tte̱ wu̱ u̱n hur-o̱ Ye̱so ro̱ à, ye̱ e̱ste̱ wu̱ u̱n co-o̱ u̱n wu̱. ");
INSERT INTO uth_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Amba ye̱ kum hek-de ye̱ hette̱ wu̱ m-tu̱wu̱t be-u̱r Ye̱so á, remen hun-ne̱ no̱mo̱g u̱t-mo̱o̱r de̱e̱n. Remen kaane̱, ye̱ detu̱ru̱ wu̱ n-to̱n o-kuke̱, ye̱ bo̱o̱ru̱ o-wu n-to̱n o-kuke̱. Ye̱ rwo̱nu̱ru̱ wu̱ u̱n karanga-o̱ u̱n wu̱ har n-dak, u̱n te̱te̱-o̱ u̱n hun-ne̱ u̱n co Ye̱so. ");
INSERT INTO uth_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Bo̱ Ye̱so hyente̱ ye̱ bo̱k ma-to̱ u̱n wu̱ o-nip à, wu̱ ze̱e̱ru̱ ka ko-ryam-wu̱, “Wan-yen de, a sokste̱ ba'as u̱n du.” ");
INSERT INTO uth_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Yan-Yoos-de o-karamsa u̱n Parisa-ne̱, ye̱ ze̱e̱ru̱ hi u̱n de u̱n ye̱, “Wan wu̱ ne̱ ka ne̱t-wu̱, wu̱ yo'ogte̱ Shir! Shir ye̱ cot he soks ba'as-to̱ u̱n hun-ne̱!” ");
INSERT INTO uth_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Ye̱so napu̱ru̱ me̱n-to̱ ye̱, wu̱ ze̱e̱ru̱ ye̱, “¿Remen yan o̱ no̱ cekerte̱ kaane̱? ");
INSERT INTO uth_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","¿Jiishte̱ a zee ba u̱r-ko̱o̱b, ‘Shir sokste̱ ba'as u̱n du,’ ko u̱m zee, ‘Ine̱ o neke̱ u̱r-hew’? ");
INSERT INTO uth_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Man kutu no̱ u̱nze, Wà-wu̱ u̱n ne̱t ro̱ u̱t-gwo̱mo ne̱ n-dak wu̱ sokste̱ u̱r-ba'as.” Wu̱ ze̱e̱ru̱ ko-ryam, “Me̱ wo̱ m-ze̱e̱, ine̱ eso, mos karanga-o ru, o neke̱ jo!” ");
INSERT INTO uth_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","U̱n gyept-o̱ u̱n yish, wu̱ inu̱ru̱ u̱n co-o̱ u̱n ye̱ kap, wu̱ mo̱tu̱ru̱ karanga-o̱ u̱n wu̱ o̱ wu̱ rotte̱ do̱mb à, wu̱ ji'u̱ru̱ o-hur wu̱ ro̱ u̱n bo̱ngo̱n-de Shir. ");
INSERT INTO uth_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Ye̱ hyanu̱ru̱ u̱t-hyat! Gye̱r-o shiishe̱ ye̱, ye̱ bo̱mu̱ru̱ Shir, ye̱ ro̱ m-ze̱e̱, “Yan go̱n hyat-to̱ a hyane̱ caane̱!” ");
INSERT INTO uth_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Bo̱ u̱n de ka, Ye̱so ruuru̱ n-do̱, wu̱ hyanu̱ru̱ ko-yan-go̱ks u̱n tar jin-de u̱n wu̱ Rewi, wu̱ ro̱ tara be-de u̱n kuke̱-o̱ u̱n se̱nge̱-mo̱ u̱n wu̱, Ye̱so ze̱e̱ru̱ wu̱, “Do̱nd me̱.” ");
INSERT INTO uth_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Rewi inu̱ru̱ eso, wu̱ dek rii á, wu̱ do̱ru̱ru̱ Ye̱so. ");
INSERT INTO uth_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Ka da-de Rewi no̱mu̱ru̱ caari-o̱ o-biki u̱n hur-o̱ u̱n wu̱ rem Ye̱so, yan-go̱ks u̱n tar ro̱ de̱e̱n ye̱ haane̱ à, u̱n ye̱ ken hun-ne̱ ye̱ ne̱ komo. ");
INSERT INTO uth_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Parisa-ne̱ u̱n yan-Yoos-de o-karamsa ne̱ ye̱ rwu̱u̱ne̱ kang-o gaan à, ye̱ nomu̱ru̱ yan-neke̱-m Ye̱so u̱s-cenene. Ye̱ citu̱ru̱, “¿Remen yan o̱ no̱tte̱ m-re̱ m-swo̱ ne̱ mo̱sse̱ u̱n yan-go̱ks u̱n tar ne̱, komo u̱n ya-u̱r-ba'as ne̱?” ");
INSERT INTO uth_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Ye̱so shasu̱ru̱ ye̱, “Hun-ne̱ ye̱ ro̱ ba u̱s-go̱m á, ye̱ ro̱ u̱n hoob-o̱ u̱n ko-ya-u̱s-baat á, amba ya-u̱s-go̱m. ");
INSERT INTO uth_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Me̱ haan remen kashi u̱n hun-ne̱ á, amba remen ya-u̱r-ba'as-ye̱ waktu̱nte̱ be-de Shir.” ");
INSERT INTO uth_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Ye̱ ken hun-ne̱ ye̱ ze̱e̱ru̱ Ye̱so, “Yan-neke̱-m Yohana ro̱ m-no̱m o-swo̱o̱t ko̱ o̱ ke da-o̱ ye̱ ro̱ u̱n ko̱n-se Shir komo. Ya-m-neke̱ u̱n Parisa-ne̱ ro̱ m-nom kaane̱ komo, amba yan-neke̱-m ru ye̱ ro̱ m-re̱ m-swo̱ ne̱.” ");
INSERT INTO uth_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Ye̱so shasu̱ru̱, “¿No̱a hoksu̱sse̱ m-we̱n u̱n ya-o-biki o̱ u̱t-ge m-re̱ m-swo̱ ne̱, da-o̱ wa-u̱t-ge ro̱ u̱n ye̱ ne̱? No̱a hoks á! ");
INSERT INTO uth_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Amba ho̱-u̱r ro̱o̱n de a hette̱ m-de̱k u̱n wa-u̱t-ge à be-de u̱n ye̱, ka da-o̱ ye̱ he m-no̱m o-swo̱o̱t.” ");
INSERT INTO uth_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Ye̱so dooru̱ ye̱ m-ru̱re̱ ka ma-to̱ u̱s-we̱e̱r to̱: “Yatt-wu̱ he m-yiish matuku-u̱r pu̱-de remen wu̱ dept matuku u̱r-ut á. Wu̱ no̱me̱ kaane̱ wu̱ yiishte̱ o̱ ka matuku-u̱r pu̱-de, komo ka dap-de a nom u̱r-bon be-de u̱n matuku u̱r-ut á. ");
INSERT INTO uth_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Komo yatt-wu̱ he wu̱u̱s m-ke̱ m-pu̱ mo̱ u̱n tur-o̱ o-ka o-ut á, remen mo̱ pu'e̱ mo̱a caat tur o-ut o̱ o-ka, ka ke̱-mo̱ ukse̱, komo ka tur-o̱ o-ka o̱ naase̱. ");
INSERT INTO uth_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Remen kaane̱, a wu̱u̱s ke̱-m pu̱-mo̱ u̱n tur-o̱ o-ka o-pu̱ o̱! ");
INSERT INTO uth_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Wu̱ su̱u̱se̱ ke̱-m ut à, wu̱a cu̱n wu̱ su̱ m-pu̱ mo̱ komo á, wu̱a zee, ‘Ka ut-mo̱ jiishe̱.’ ” ");
INSERT INTO uth_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Ye̱so ro̱ m-neke̱ u̱n n-me̱ u̱n kat-to̱ u̱n hyo Ho̱-de u̱r-Wu̱we̱ de u̱n Yahuda-ne̱. Yan-neke̱-mo̱ u̱n wu̱ taknu̱ru̱ m-horom u̱n hyo, ye̱ pirmu̱ru̱ u̱t-kom to̱ u̱n ye̱, ye̱ ro̱ m-ti. ");
INSERT INTO uth_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Ye̱ ken Parisa-ne̱ citu̱ru̱, “¿Remen yan no̱ ro̱tte̱ m-no̱m yo karamsa-o ze̱e̱ no̱ no̱m Ho̱-de u̱r-Wu̱we̱ á?” ");
INSERT INTO uth_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Ye̱so shasu̱ru̱ ye̱, “No̱ karante̱ yo Dawuda no̱me̱ da-o̱ wu̱, u̱n hun-ne̱ ye̱ u̱n wu̱ ne̱ ho̱ge̱ me̱r à. ");
INSERT INTO uth_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Wu̱ co̱wo̱g n-me̱ u̱n de̱pi-o̱ u̱n ko̱n-se Shir, wu̱ deku̱ru̱ ga-de wan-Co̱w u̱n ko̱n-se Shirseke̱ Shir à, wu̱ re̱e̱ru̱ de, komo wu̱ ya'asu̱ru̱ hun-ne̱ ye̱ u̱n wu̱. Komo pas-mo̱ o-karamsa mo̱ wu̱ ken ne̱t-wu̱ re ka ga-de, se̱ de̱ wan-Co̱w u̱n ko̱n-se Shir wu̱ he m-re̱ u̱n ka ga-de.” ");
INSERT INTO uth_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Komo Ye̱so bu̱su̱ru̱ m-ze̱e̱, “Me̱ Wà-wu̱ u̱n ne̱t ro̱ Go̱s-wu̱ wu̱ u̱n Ho̱-de u̱r-Wu̱we̱.” ");
INSERT INTO uth_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","U̱n de ken Ho̱-de u̱r-Wu̱we̱ de komo, Ye̱so co̱wu̱ru̱ kuke̱-o̱ u̱n yoos u̱n Ma-to̱ Shir, wu̱ yoosu̱ru̱. Wu̱ ken ne̱t-wu̱ ro̱ kane̱ wu̱ kom-o̱ u̱r-re̱ mare̱ à. ");
INSERT INTO uth_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Yan-Yoos-de o-karamsa u̱n Parisa-ne̱ ne̱ co̱nu̱ru̱ o-teber a zeet Ye̱so no̱mo̱g u̱r-ba'as, ye̱ tuuru̱ yish, remen ye̱ hyenet u̱rege̱ wu̱a taas go̱m Ho̱-de u̱r-Wu̱we̱. ");
INSERT INTO uth_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Amba Ye̱so napu̱ru̱ barag-se u̱n ye̱, wu̱ ze̱e̱ru̱ ka ne̱t-wu̱, “Ine̱ eso o haan kane̱ co.” Ka ne̱t-wu̱ indu̱ndu̱ru̱ kane̱. ");
INSERT INTO uth_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Ka da-de Ye̱so ze̱e̱ru̱ ye̱, “U̱m cit no̱: ¿Ya ne̱ karamsa-o na ze̱e̱, a hoks m-nom Ho̱-de u̱r-Wu̱we̱? ¿A gu ko a naase̱? ¿A gu ho̱o̱g-mo̱ u̱n ne̱t ko a ho?” ");
INSERT INTO uth_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Wu̱ gwo̱tu̱ru̱ ye̱ kap, ka da-de wu̱ ze̱e̱ru̱ ka ne̱t-wu̱, “Neks kom-o ru.” Wu̱ no̱mu̱ru̱ bo̱ Ye̱so ze̱e̱ wu̱ à, go̱m-o̱ u̱n kom-o̱ u̱n wu̱ taaru̱. ");
INSERT INTO uth_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Ryaab-u̱s ho̱o̱ru̱ ye̱, ye̱ taknu̱ barag-se u̱n rii-yo ye̱ he Ye̱so m-no̱m à. ");
INSERT INTO uth_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Ka da-o̱ Ye̱so daaru̱ u̱r-dor wu̱ konot, wu̱ ko̱nu̱ru̱ Shir m-te̱t u̱r-bir. ");
INSERT INTO uth_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Da-o̱ ho̱-u̱r rwu̱u̱ne̱ à, wu̱ agnu̱ru̱ yan-neke̱-mo̱ u̱n wu̱ be-de u̱n wu̱, wu̱ daagu̱ru̱ o̱p u̱n yoor 12 be-de u̱n ye̱, wu̱ egu̱ru̱ ye̱ u̱r-jin, Yan-to̱m. ");
INSERT INTO uth_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Simo̱n (wu̱ Ye̱so ege̱ Bitrus à), u̱n hen-ne̱ u̱n wu̱ ne̱ Andarawus, Yakubu, u̱n Yohana, Pirip u̱n Bataromi, ");
INSERT INTO uth_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matiyos, u̱n Tomas, Yakubu (wà Aru̱payes), u̱n Simo̱n (wu̱ a ro̱ m-aag Wan-ya'as u̱r-hi), ");
INSERT INTO uth_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Yahudas (wà Yakubu), u̱n Yahudas Iskariyoti (wu̱ babe̱ Ye̱so u̱n kom-to̱ u̱n yan-yage̱-to̱ u̱n wu̱ à). ");
INSERT INTO uth_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Da-o̱ Ye̱so kergene̱ n-to̱n u̱r-dor u̱n yan-to̱m-ye̱ u̱n wu̱ ne̱ à, wu̱ e̱su̱ru̱ eso u̱n be-de ro̱ cangam à, u̱n yan-neke̱-mo̱ u̱n wu̱ ne̱ de̱e̱n. Hun-ne̱ de̱e̱n ye̱ rwu̱u̱ne̱ ho̱no dak-o̱ o-Judiya à, o-Urusharima ne̱, u̱n he̱be̱-mo̱ o-Taya, o-Sidon ne̱ bo̱-to̱ u̱n riib-o̱ m-sa. ");
INSERT INTO uth_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Ye̱ haante̱ ye̱ ho̱gu̱té̱ wu̱, komo remen wu̱ taasté̱ go̱m-se u̱n ye̱ komo, ka ye̱ ya-u̱t-ko̱t suwe̱ à, ye̱ ma ye̱ haante̱ Ye̱so taasté̱ go̱m-se u̱n ye̱. ");
INSERT INTO uth_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Hun-ne̱ kap se̱ngu̱ru̱ ye̱ ci'it wu̱, remen 'wo̱ns-mo̱ u̱n taas u̱n go̱m ro̱ be-de u̱n wu̱. Komo go̱m-se u̱n ye̱ taag kap. ");
INSERT INTO uth_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Ye̱so gwo̱tu̱ru̱ yan-neke̱-mo̱ u̱n wu̱, wu̱ ze̱e̱ru̱, “Shir ya'ag no̱ o-kwu̱m no̱ ye̱ ro̱ ko̱o̱b-ne̱ m-mo̱ka à, remen gwo̱mo-to̱ Shir to̱ ma no̱ to̱! ");
INSERT INTO uth_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Shir ya'ag no̱ o-kwu̱m no̱ ye̱ ro̱ m-ho̱ge̱ m-me̱r m-mo̱ka à, remen Shir a coks no̱! Shir ya'ag no̱ o-kwu̱m, no̱ ro̱ u̱s-'wo̱n m-mo̱ka à, remen no̱a nemes! ");
INSERT INTO uth_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Shir ya'ag no̱ o-kwu̱m da-o̱ hun-ne̱ yage̱ no̱ à, ye̱ co̱n no̱ á, ye̱a pyapar no̱, ye̱ zee no̱ u̱n me̱n-u̱t jaas-to̱ ne̱, kap rem re Wà-wu̱ u̱n ne̱t! ");
INSERT INTO uth_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","“No̱m no̱ me̱n-u̱t pus-to̱ da-o̱ no̱ hyene̱ kaane̱, no̱ he̱w he̱w-se o-zak, remen Shir e̱ssu̱tu̱ no̱ caari-de u̱r-'yons n-to̱n. No̱m no̱ o-dish ye̱a nomo no̱ kaane̱, remen kaane̱ ya-n-ga-ye̱ no̱me̱ yan-rwo̱r u̱n Ma-to̱ Shir. ");
INSERT INTO uth_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“No̱ ya-o-kwu̱m m-mo̱ka no̱a warag rii-yo u̱r-'wo̱n, remen no̱ kumuste̱ m-mo̱ka, yo ho̱o̱g-m no̱ co̱ne̱ à! ");
INSERT INTO uth_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Rii-yo u̱r-'wo̱n yo, no̱ ye̱ cigse̱ m-mo̱ka à, remen no̱a ho̱ge̱ me̱r! No̱a warag rii-yo u̱r-'wo̱n, no̱ ya-u̱t-nemes m-mo̱ka, no̱a no̱m tu̱k-mo̱ u̱t-me̱n har no̱ 'u̱n. ");
INSERT INTO uth_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","No̱a warag rii-yo u̱r-'wo̱n da-o̱ hun-ne̱ kap bo̱m no̱ à, ya-n-ga-ye̱, ye̱ u̱n ye̱ bo̱mo̱g yan-rwo̱r u̱n Ma-to̱ Shir ka bo̱ngo̱n-de co̱w ye̱ u̱t-me̱n á. ");
INSERT INTO uth_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Amba me̱ no̱ m-ru̱re̱, no̱ ye̱ ho̱ge̱ me̱ à, co̱n no̱ yan-yage̱-u̱t no̱, no̱ nome̱ ye̱ rii-yo u̱r-bon. ");
INSERT INTO uth_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Ye̱ pyapu̱ no̱ à, no̱ ko̱ne̱ ye̱ Shir 'ye ye̱ o-kwu̱m, komo no̱ ko̱ne̱ ye̱ nomo no̱ me̱n-u̱t jaas-to̱ à rii-yo u̱r-bon. ");
INSERT INTO uth_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Wu̱ ken wu̱ kene̱ wo̱ o-raag, wakse̱ wu̱ o̱ kuse̱ à wu̱ bu̱se̱, u̱rege̱ wu̱ ken wu̱ de̱k wo̱ u̱r-matuku, ya'as wu̱ co̱p-o ru. ");
INSERT INTO uth_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Wu̱ ko̱nu̱ wo̱ rii à, 'ya wu̱, komo wu̱ rumsu̱ wo̱ rii à, wo̱ ze̱e̱ wu̱ mu̱u̱ntu̱ wo̱ á. ");
INSERT INTO uth_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Bo̱ o co̱ne̱ hun-ne̱ nomo wo̱ à, nomo ye̱ kaane̱. ");
INSERT INTO uth_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“U̱rege̱ ye̱ co̱nu̱ wo̱ à, ye̱ wo̱ m-co̱n, wo̱a kum o̱ ka u̱r-'yons be-de Shir á. Ko̱ ya-u̱r-ba'as-ye̱ ro̱ m-co̱n u̱n ye̱ co̱nu̱ ye̱ à! ");
INSERT INTO uth_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","U̱rege̱ ye̱ nomo wo̱ rii-yo u̱r-bon à, ye̱ o he m-nome̱ rii-yo u̱r-bon, wo̱a kum o̱ ka u̱r-'yons á be-de Shir, ¿remen yan o̱ o hette̱ m-go̱ks u̱r-'yons? Ko̱ ya-u̱r-ba'as-ye̱ ro̱ m-no̱m kaane̱! ");
INSERT INTO uth_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","U̱rege̱ komo o mu̱u̱gu̱te̱ ye̱ o hyane̱ ye̱ he wo̱ m-hoks m-tope̱ à, ¿wo̱a kum u̱r-'yons be-de Shir? Ko̱ ya-u̱r-ba'as-ye̱ ro̱ m-mu̱ge̱ ya-u̱r-ba'as, remen a mu̱u̱ntu̱te̱ ye̱! ");
INSERT INTO uth_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Amba co̱n no̱ ye̱ yagu̱ no̱ à, no̱ nome̱ ye̱ rii-yo u̱r-bon, ya'as no̱ mo̱o̱g, no̱ dish a topo no̱ á. U̱rege̱ no̱ no̱mo̱g kaane̱ no̱a kum 'yons-u̱r caari, be-de Shir komo no̱a warag yakar-ye̱ u̱n Shir wu̱ jiishe̱ à. No̱m no̱ kaane̱ remen Shir ro̱ m-'ya u̱n yan-nu-o̱ o-kiit u̱n yan-me̱n-u̱t jaas-to̱ ne̱. ");
INSERT INTO uth_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Ho̱gu̱ no̱ u̱r-'wo̱n bo̱ tato no̱ ro̱ u̱r-'wo̱n ne̱ à. ");
INSERT INTO uth_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“No̱ piishe̱ hun-ne̱ u̱t-ma á, komo Shir a piishu̱ no̱ u̱t-ma á. No̱ naas hun-ne̱ á, komo Shir a naas no̱ á. Soks no̱ ba'as-de u̱n hun-ne̱, komo Shir a soks ba'as-u̱r no̱. ");
INSERT INTO uth_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Ya no̱ hun-ne̱, komo Shir a 'ye no̱. Remen kaane̱ no̱a go̱ks, me'es u̱t-shishe̱, Shir a dusu̱ no̱ gwu̱ caari hyo'ogse̱ u̱n kom-u̱t no̱ bo̱ no̱a hoks m-go̱ks á. Bo̱ o me'esse̱ hun-ne̱ à, kaane̱ Shir he wo̱ m-me'esse̱.” ");
INSERT INTO uth_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Ye̱so ru̱ru̱ ye̱ ka ma-to̱ u̱s-we̱e̱r to̱: “Ko-po̱ ro̱ m-neke̱ u̱n ko-po̱ o-ko̱ á, ye̱ nome̱ kaane̱ ye̱a he̱be̱ n-me̱ o-kuub kap. ");
INSERT INTO uth_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Wu̱ a m-yoose̱ à, wu̱ jiish wu̱ ro̱ wu̱ m-yoose̱ á, amba a komse̱ wu̱ m-yoose̱ wu̱a warag u̱ntu̱n wu̱ yoose̱ wu̱ à. ");
INSERT INTO uth_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“¿Remen yan o̱ wo̱tte̱ m-gwo̱t u̱n ya o-gwo̱ yo ro̱ u̱n yish-u̱r o̱r ru à, amba wo̱ gwo̱t cik-o̱ o-ce o̱ ro̱ n-me̱ u̱n yish u̱n du á? ");
INSERT INTO uth_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","¿Ya o hette̱ m-ze̱e̱ u̱n o̱r ru, ‘Hakku̱re̱, heno re, yage̱ u̱m hu̱ssu̱tu̱ wo̱ ya o-gwo̱ yo ro̱ wo̱ u̱r-yish à,’ wo̱ hoks m-hyan u̱n cik-o̱ ro̱ u̱n yish ru á? No̱ ya-o-she̱pe̱! Takan no̱ m-hu̱s u̱n cik-o̱ ro̱ u̱n yish no̱ à, ka da-de no̱ he m-hyan u̱r-bon ne̱ ya o-gwo̱ yo ro̱ u̱n yish o̱r ru à o hu̱ssu̱ru̱ wu̱. ");
INSERT INTO uth_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“'Yo, yo u̱r-bon ro̱ m-mat u̱n yakar-ye̱ u̱r-bon, kaane̱ komo 'yo-yo ba u̱r-bon yo a met yakar-ye̱ ba u̱r-bon. ");
INSERT INTO uth_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Ko̱ wu̱ ke ne̱t-wu̱ nak ko̱ yo ke 'yo-yo remen go̱n yakar-ye̱ u̱n yo. Wo̱a ke u̱t-rum be-de o-yokor á, komo wo̱a ke m-bugur be-de o-tuntun á. ");
INSERT INTO uth_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Kashi u̱n ne̱t ro̱ m-rwu̱nte̱ kashi u̱n rii u̱n hur-de u̱n wu̱, ne̱t yo̱-wu̱, komo ro̱ m-rwu̱nte̱ rii 'yo̱-yo u̱n hur-de u̱n wu̱, remen nu-o̱ ro̱ m-rwo̱r u̱n rii-yo ro̱ u̱r-hur à. ");
INSERT INTO uth_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“¿Remen yan o̱ no̱ ro̱tte̱ me̱ m-aag, ‘Go̱s-wu̱, Go̱s-wu̱,’ amba no̱ m-no̱m yo u̱m ze̱e̱ no̱ á? ");
INSERT INTO uth_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Ko̱ wu̱ ke wu̱ haane̱ be u̱n de à, komo wu̱ ho̱ge̱ ma-u̱t re wu̱ do̱re̱ to̱, man kutu̱ no̱ bo̱ wu̱ ro̱ à. ");
INSERT INTO uth_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Ya wu̱ ro̱ u̱ntu̱n wu̱ ken ne̱t-wu̱, wu̱ ine̱ u̱t-ma to̱ o-hur à, wu̱ kumu u̱r-dor, wu̱ maaru̱ ma-to̱ u̱n wu̱ kane̱. Ro̱o̱g-o̱ hantu̱ru̱ m-ho̱, mo̱ tamu̱ru̱ ka hur-o̱ amba o̱ nukte̱ á, remen wu̱ maag o̱ n-to̱n u̱r-dor. ");
INSERT INTO uth_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Amba wu̱ ho̱ge̱ ma-u̱t re à, wu̱ joru̱ru̱ to̱, ya wu̱ ro̱ u̱ntu̱n ne̱t-wu̱ ma'e̱ hur-o̱ u̱n wu̱ o-wak à, da-o̱ ho̱-m taame̱ ka hur-o̱ à, o̱ he̱e̱g u̱n gyept-o̱ u̱n yish, komo o̱ rugumsu̱te̱ kap.” ");
INSERT INTO uth_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Bo̱ Ye̱so komoste̱ m-ru̱re̱ u̱n ka hun-ne̱ ye̱ ka rii-yo à, wu̱ haaru̱ o-Kapanahum. ");
INSERT INTO uth_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Ko-caari-wu̱ u̱n ne̱t ko-Roma, ro̱ u̱n ko-gu̱w ne̱ kane̱, wu̱ hur-de u̱n wu̱ ro̱ be-de u̱n wu̱ à, ka ko-gu̱w-wu̱, wu̱ ke̱e̱se̱ á, wu̱ ro̱ ma-to̱ m-mar. ");
INSERT INTO uth_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Bo̱ ka caari-wu̱ u̱n ne̱t-wu̱ ho̱ge̱ ma-u̱t Ye̱so à, wu̱ to̱mu̱ru̱ ye̱ ken se̱k-ye̱ ye̱ u̱n Yahuda-ne̱, ye̱ kon Ye̱so wu̱ haan wu̱ taas go̱m-o̱ u̱n ko-yan-gu̱w-mo̱ u̱n wu̱. ");
INSERT INTO uth_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Ye̱ haaru̱ be-u̱r Ye̱so ye̱ suru̱ wu̱ u̱s-ko̱n, “Ka ne̱t-wu̱ wo̱o̱g, o gu wu̱, ");
INSERT INTO uth_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","remen wu̱ co̱no̱g hun-ne̱ na komo wu̱ u̱n hi u̱n de u̱n wu̱, wu̱ meete̱ na kuke̱-o̱ u̱n yoos u̱n Ma-to̱ Shir.” ");
INSERT INTO uth_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Ka da-de Ye̱so haaru̱ u̱n ye̱ ne̱. Hew-u̱r ro̱ kus a woot u̱n hur-o̱ u̱n ka caari-wu̱ u̱n ne̱t-wu̱ á, wu̱ to̱mu̱ru̱ a ru̱re̱ Ye̱so, “Go̱s-wu̱, wo̱ rangse̱ hi u̱n du á, remen me̱ bo'os o haan u̱n hur-o re á. ");
INSERT INTO uth_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Komo me̱ de̱k u̱m bo̱'o̱ste̱ u̱m habe̱ be u̱n du u̱n hi u̱n de á. Wo̱ de̱ no̱m u̱t-ma temb, komo go̱m-o̱ u̱n ko-gu̱w re o̱a te. ");
INSERT INTO uth_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Me̱ ma, ne̱t-wu̱, wu̱ a sagbe̱ u̱t-gwo̱mo n-to̱n u̱n caari-ye̱ u̱n hun-ne̱ à, u̱ntu̱n wo̱, komo me̱ u̱n karma-ne̱ be u̱n de. Me̱ m-ze̱e̱ wan-gaan, ‘Neke̱!’ Komo wu̱ neke̱. Me̱ ze̱e̱ wan-gaan ‘Haan!’ Wu̱ haan komo, me̱ m-ze̱e̱ u̱n ko-gu̱w re, ‘No̱m yo ka!’ Komo wu̱ no̱m yo.” ");
INSERT INTO uth_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Ye̱so bo̱pu̱ru̱ o-nu bo̱ wu̱ ho̱ge̱ kaane̱ à, wu̱ waktu̱ru̱ u̱s-ajima ne̱ wu̱ ze̱e̱ru̱ ka bu̱u̱g-de u̱n hun-ne̱ ye̱ ro̱ wu̱ m-do̱re̱ à. “Me̱ no̱ m-ru̱re̱, me̱ ro kumug wu̱ de̱ke̱ ma-u̱t re kaane̱ u̱ntu̱n ka ne̱t-wu̱ á, ko̱ u̱n dak-o o-Isra.” ");
INSERT INTO uth_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Yan-to̱m wargu̱ru̱ u̱n hur-o̱ u̱n ka caari-wu̱ u̱n ne̱t-wu̱, ye̱ 'wo̱ssu̱ru̱ ka ko-gu̱w-wu̱ ba u̱n go̱m. ");
INSERT INTO uth_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Bo̱ doote̱ à, Ye̱so haaru̱ o̱ ken bo̱-o̱, a o̱ m-ze̱e̱ o-Neen, yan-neke̱-mo̱ u̱n wu̱ shite̱ wu̱ u̱n hun-ne̱ ne̱ u̱t-mo̱o̱r ne̱. ");
INSERT INTO uth_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Bo̱ u̱n wo̱o̱n-mo̱ u̱n wu̱ u̱n ish o-bo̱, yan-du̱k ro̱ m-rwu̱u̱n u̱r-u ne̱. Ka wu̱ mare̱ à, wà-wu̱ u̱n wu̱ ken ko-gwo̱r-wu̱ ne'a, wu̱ ro̱ wu̱ cot wan-gaan, komo hun-ne̱ de̱e̱n ro̱ u̱n wu̱ ne̱. ");
INSERT INTO uth_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Da-o̱ Go̱s-wu̱ hyane̱ wu̱ à, wu̱ ho̱gu̱ru̱ 'wo̱n-de u̱n wu̱, Ye̱so ze̱e̱ru̱ wu̱, “Wo̱ 'wo̱n á!” ");
INSERT INTO uth_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Wu̱ neku̱ru̱ wu̱ ci'u̱ru̱ ka rii-o̱ ye̱ sawante̱ u̱r-u à, ye̱ e̱ssu̱ru̱. Ye̱so ze̱e̱ru̱, “Wan-campo̱, u̱m ze̱e̱g wo̱ ine̱!” ");
INSERT INTO uth_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Ka wu̱ mare̱ à, inu̱ru̱ tara, wu̱ te̱pru̱ru̱, Ye̱so muutu̱ru̱ wu̱ be-u̱r inu u̱n wu̱. ");
INSERT INTO uth_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Kap mo̱ u̱n ye̱ ho̱gu̱ru̱ o-gye̱r, ye̱ bo̱mu̱ru̱ Shir. Ye̱ ze̱e̱ru̱, “Ko-caari-wu̱ u̱n wan-Rwo̱r u̱n Ma-to̱ Shir haante̱ be-u̱r na! Shir haante̱ wu̱ guut hun-ne̱ ye̱ u̱n wu̱.” ");
INSERT INTO uth_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ma-u̱t Ye̱so ruuru̱ ho̱no dak-o̱ o-Judiya u̱s-riib ne̱. ");
INSERT INTO uth_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Da-o̱ yan-neke̱-m Yohana Wa-m-Yo'os u̱n hun-ne̱ m-ho̱ ru̱re̱ wu̱ kap rii-yo ye̱ hyane̱ à, wu̱ aagu̱ru̱ ne̱n yoor be-de u̱n ye̱. ");
INSERT INTO uth_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Wu̱ to̱mu̱ru̱ ye̱ be-u̱r Ye̱so remen ye̱ cit wu̱: “¿Wo̱ wu̱ Yohana ze̱e̱ wu̱ ro̱o̱ne̱, ko̱ te̱ waase̱ wu̱ ken wu̱?” ");
INSERT INTO uth_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Bo̱ ye̱ wo̱o̱nte̱ be-u̱r Ye̱so à, ye̱ ze̱e̱ru̱, “Yohana Wa-m-Yo'os u̱n hun-ne̱ m-ho̱ tomontu̱ te̱, te̱ cit u̱rege̱ ¿wo̱ wu̱, wu̱ zee wu̱ ro̱o̱n, ko̱ ne̱ te̱ waase̱ wu̱ ken wu̱?” ");
INSERT INTO uth_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","U̱n ka da-o̱, Ye̱so taaste̱ go̱m-se u̱n hun-ne̱ de̱e̱n, u̱n ye̱ ro̱ u̱n go̱m-se u̱n ya-u̱t-ko̱t ne̱ à, komo po̱-ne̱ kumug o-hyan. ");
INSERT INTO uth_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Wu̱ shasu̱ru̱ yan-to̱m Yohana, “Warag no̱, no̱ ru̱re̱ Yohana yo no̱ hyane̱, u̱n yo no̱ ho̱ge̱ ne̱ à: Po̱-ne̱ hyanag, ryam-ne̱ kumug u̱s-na, cim-ne̱ waragte̱ po̱r po̱r, 'kato̱-ne̱ ro̱ m-ho̱ge̱, margan-ne̱ inu̱te̱, komo ko̱o̱b-ne̱ ho̱gu̱te̱ ka Ma-to̱ m-Re̱re̱m to̱. ");
INSERT INTO uth_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Ya-o-kwu̱m-ye̱, ye̱ e̱sse̱ u̱r-hur be u̱n de à.” ");
INSERT INTO uth_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Bo̱ yan-to̱m Yohana aragsu̱te̱ à, Ye̱so taknu̱ru̱ ma-to̱ u̱n wu̱ be-de u̱n ka bu̱u̱g-de u̱n hun-ne̱ de. “Bo̱ no̱ ruwe̱ be-u̱r Yohana be-de o-dákár à, ¿ya no̱ ro ze̱e̱ge̱ no̱ hyen? ¿M-yó, m-nakt u̱t-po̱ ye̱? ");
INSERT INTO uth_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","¿Ya no̱ ruwe̱ m-hyane̱? No̱ u̱n ru kane̱ remen no̱ hyenet ne̱t-wu̱ co̱pe̱ saw-to̱ u̱r-bon à. Ye̱ co̱pe̱ saw-to̱ u̱r-bon à ye̱ ro̱ u̱n pyo-o̱ u̱t-gwo̱mo! ");
INSERT INTO uth_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","No̱ ruug remen no̱ hyenet wan-rwo̱r u̱n Ma-to̱ Shir. E̱e̱, kaane̱ o̱, Yohanawan-Rwo̱r u̱n Ma-to̱ Shir wu̱ amba no̱ hyanag yo arge̱ wan-Rwo̱r u̱n Ma-to̱ Shir à. ");
INSERT INTO uth_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Yohana wu̱ Ma-to̱ Shir ze̱e̱, ‘Shir ze̱e̱g, gwo̱tbe̱ man to̱m wan-to̱m re u̱n co ru wu̱ tikshi wo̱ o-co̱w.’ ");
INSERT INTO uth_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Me̱ no̱ m-ru̱re̱, Yohana jiishte̱ ko̱ wu̱ ke ne̱t-wu̱ ho̱no o-dak pitip. Amba wu̱ ro̱ re̱k-wu̱ be-de u̱n gwo̱mo-to̱ Shir à, wu̱ aragte̱ Yohana.” ");
INSERT INTO uth_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Hun-ne̱ kap ho̱gu̱te̱ wu̱, u̱n yan-go̱ks u̱n tar-ne̱. Ye̱ do̱ru̱te̱ yo Shir ze̱e̱ à, komo Yohana yo'oste̱ ye̱ m-ho̱. ");
INSERT INTO uth_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Amba Parisa-ne̱, u̱n yan-Napse̱ o-karamsa ne̱, ye̱ yagu̱te̱ yo Shir hyenu̱ ye̱ à, remen ye̱ co̱n Yohana yo'os ye̱ m-ho̱ á. ");
INSERT INTO uth_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Ye̱so se̱ngu̱ru̱ m-ze̱e̱, “M-mo̱ka u̱n ¿yan o̱ u̱m he m-hongse̱ u̱n hun-ne̱ ye̱ u̱n caane̱? ¿U̱ntu̱n yan ye̱ ro̱? ");
INSERT INTO uth_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Ya ye̱ ro̱ u̱ntu̱n yakar-ye̱ she'ete̱ n-me̱ u̱n be-de u̱t-baab à. Bu̱u̱g-u̱r gaan kangsu̱ru̱ de ken. “ ‘Te̱ bu'utu no̱ dum-to̱ u̱r-ge, amba no̱ he̱w á! Te̱ hutu̱ no̱ se̱p-to̱ m-mar, amba no̱ 'wo̱n á!’ ");
INSERT INTO uth_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Yohana Wa-m-Yo'os u̱n hun-ne̱ m-ho̱ haante̱, wu̱ no̱mo̱g o-swo̱o̱t, komo wu̱ swo̱ m-ke̱ á, remen kaane̱ no̱ ze̱e̱g, ‘Ya-u̱t-ko̱t daag wu̱ u̱r-hi.’ ");
INSERT INTO uth_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Wà-wu̱ u̱n ne̱t haante̱, wu̱ re̱e̱g, wu̱ su̱, no̱ ze̱e̱g, ‘Gwo̱t no̱ ka ne̱t-wu̱! Ko wa-o-hambo wu̱ m-re̱, m-swo̱ ne̱, ko-nay-wu̱ u̱n yan-go̱ks u̱n tar, u̱n ya-u̱r-ba'as ne̱.’ ");
INSERT INTO uth_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Da-o̱ hun-ne̱ go̱kse̱ Shir à, a hyen we̱e̱r-se u̱n Shir, nip-o̱.” ");
INSERT INTO uth_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Ko-Parisa banag Ye̱so re̱ u̱n ga-to̱ m-rim, Ye̱so haaru̱ u̱n hur-o̱ u̱n wu̱, wu̱ she'etu̱ru̱ wu̱ reet u̱t-ga. ");
INSERT INTO uth_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Kane̱ u̱n ka bo̱-o̱ wu̱ ken ne'a-wu̱ ro̱ ko̱n wu̱ ro u̱n she'et-de u̱r-ba'as à. Wu̱ ho̱gu̱te̱ Ye̱so ro̱ m-re̱ u̱n rii-yo m-re̱ u̱n hur-o̱ u̱n ko-Parisa, wu̱ hantu̱ru̱ u̱r-batta de u̱n no̱w-mo̱ m-shi'igin mo̱ u̱n hwo̱r de̱e̱n. ");
INSERT INTO uth_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Wu̱ e̱su̱ru̱ u̱n jim-u̱r Ye̱so, u̱n na-se u̱n wu̱, u̱s-'wo̱n wu̱ ro̱ m-mu̱se̱ u̱n na-u̱s Ye̱so u̱n yish-mo̱ u̱n wu̱. Ka da-de wu̱ pe̱gu̱ru̱ na-u̱s Ye̱so u̱n hi-se u̱n wu̱, wu̱ hamtu̱ru̱ na-u̱s Ye̱so, wu̱ hokmo̱ru̱ ka no̱w-mo̱ u̱n na-u̱s Ye̱so. ");
INSERT INTO uth_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Bo̱ ka ko-Parisa-wu̱ hyente̱ kaane̱ à, wu̱ ze̱e̱ru̱ hi u̱n de u̱n wu̱, “U̱rege̱ de ka ne̱t-wu̱ wan-rwo̱r u̱n Ma-to̱ Shir wu̱, wu̱a nep ko-yan-go̱n ne'a-wu̱ ro̱ wu̱ m-ci, wu̱a nep go̱n she'et-de u̱n ka ne'a-wu̱ de u̱r-ba'as!” ");
INSERT INTO uth_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Ye̱so rwu̱ntu̱ru̱ u̱t-ma wu̱ ze̱e̱ru̱ wu̱, “Simo̱n, me̱ u̱n rii ne̱ u̱m ru̱ru̱ wo̱.” Wu̱ ze̱e̱ru̱, “E̱e̱, Wa-u̱r-Yoos, ru̱ru̱ me̱.” ");
INSERT INTO uth_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Ye̱so ze̱e̱ru̱, “Ne̱n yoor mo̱k hwo̱r be-de u̱n wu̱ ken wu̱. Wan-gaan mo̱k zungu-u̱s taan 500 se u̱n hwo̱r, wan-gaan kwo̱o̱z-u̱t yoor u̱n o̱p 50. ");
INSERT INTO uth_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Kap mo̱ u̱n ye̱ yatt-wu̱ hokse̱ m-to̱p á, remen kaane̱ wu̱ yaksu̱ru̱ ye̱ kap, ne̱n yoor mo̱ u̱n ye̱, ¿wan wu̱ ne̱ he m-jiish m-co̱n u̱n ka wu̱ mu̱u̱ge̱ ye̱ hwo̱r?” ");
INSERT INTO uth_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simo̱n shasu̱ru̱, “Man zee ka wu̱ jiishe̱ m-mo̱o̱g à.” Ye̱so ze̱e̱ru̱, “O shaks hond hond.” ");
INSERT INTO uth_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Wu̱ waktu̱ru̱ be-de u̱n ka ne'a-wu̱, wu̱ ze̱e̱ru̱ Simo̱n, “¿O hyanag ka ne'a-wu̱? U̱m haante̱ n-me̱ u̱n hur-o ru, wo̱ 'ya me̱ m-ho̱ remen u̱m so'osté̱ na-u̱s re á, amba ka ne'a-wu̱ so'oste̱ na-u̱s re u̱n yish-mo̱ u̱n wu̱, wu̱ pe̱gu̱ru̱ se u̱n hi-se u̱n wu̱. ");
INSERT INTO uth_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Wo̱ hamat me̱ da-o̱ o barku̱ me̱ á, amba ka ne'a-wu̱, wu̱ yage̱ hamat u̱n na-u̱s re á, da-o̱ u̱m co̱wne̱ har m-mo̱ka. ");
INSERT INTO uth_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Wo̱ e̱s m-no̱w remen hi u̱n de á, amba wu̱ duusu̱te̱ na-u̱s re m-no̱w mo̱ m-shi'igin. ");
INSERT INTO uth_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Me̱ wo̱ m-ru̱re̱ u̱nze, ka co̱n-mo̱, mo̱ wu̱ kutu̱ me̱ à, kutute̱ u̱nze Shir sokste̱ ba'as-de u̱n wu̱ kap. Amba wu̱ co̱ne̱ hiin à, Shir a soks ba'as-de u̱n wu̱ hiin.” ");
INSERT INTO uth_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Ka da-de Ye̱so ze̱e̱ru̱ ka ne'a-wu̱, “A sokste̱ ba'as-u̱t ru.” ");
INSERT INTO uth_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ka ye̱ ro tara kane̱ à, taknu̱ru̱ m-ze̱e̱, “¿Wan wu̱ ne̱ wu̱ ro̱, wu̱ sokste̱ u̱r-ba'as?” ");
INSERT INTO uth_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Amba Ye̱so ze̱e̱ru̱ ka ne'a-wu̱, “Shir guug wo̱ remen o she̱re̱g be u̱n de, arag u̱n gwu̱gwu̱-mo̱ u̱r-hur.” ");
INSERT INTO uth_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Bo̱ da-o̱ doote̱ à, Ye̱so do̱ru̱ru̱ to̱ ken bo̱-u̱t caari-to̱, u̱t-re̱k-to̱ ne̱, wu̱ ro̱ m-rwo̱r u̱n Ma-to̱ m-Re̱re̱m to̱ u̱n gwo̱mo-to̱ Shir. Yan-neke̱-mo̱ u̱n wu̱ o̱p u̱n yoor 12 ro̱ u̱n wu̱ ne̱. ");
INSERT INTO uth_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Ye̱ ken ne'a-ne̱ ye̱, ye̱ Ye̱so ruute̱ ya-u̱t-ko̱t à, u̱n se̱ ken go̱m-se ne̱ à, do̱ru̱ru̱ wu̱. Meri (wu̱ a m-aag Magu̱darin), wu̱ a ruute̱ ya-u̱t-ko̱t ta'yoor à. ");
INSERT INTO uth_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Jonana wu̱ campo̱ u̱n wu̱ Cuza caari-wu̱ u̱n ne̱t be-de u̱n piish u̱t-ma be-u̱r Here̱, komo Susana, u̱n ye̱ ken ne'a-ne̱ ye̱ ne̱ de̱e̱n. Ye̱ yasu̱ru̱ rii-yo ye̱ ro̱tte̱ à, remen a guut Ye̱so u̱n yan-neke̱-mo̱ u̱n wu̱ ne̱. ");
INSERT INTO uth_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Hun-ne̱ masu̱ru̱ m-haan be-u̱r Ye̱so bo̱-u̱t-bo̱, komo bo̱ hun-ne̱ mo̱rge̱ de̱e̱n à, Ye̱so rwo̱ru̱ru̱ ka sha-mo̱ u̱t-ma mo̱: ");
INSERT INTO uth_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“O̱ ken da-o̱ wu̱ ken ne̱t-wu̱ ruug kapu̱ u̱n po̱t. Bo̱ wu̱ kepte̱ go̱ u̱n po̱t o-kat à, ye̱ ken ye̱ he̱nu̱ru̱ u̱n co̱w, a yawgu̱ru̱ ye̱ kane̱, ye̱ge̱-no re̱e̱ru̱ ye̱ kap. ");
INSERT INTO uth_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Ye̱ ken ye̱ he̱nu̱ru̱ u̱t-ta'ar, bo̱ ye̱ po̱te̱ à, ye̱ hwo̱'u̱ru̱ remen ka be-de ro̱tt o-wu̱s á. ");
INSERT INTO uth_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Ye̱ ken go̱-ye̱ he̱nu̱ru̱ be-de u̱n yokor, ye̱ bo̱su̱ru̱ amba u̱t-po̱ u̱n ka yokor-ye̱ ne̱ ho̱o̱ru̱ ye̱. ");
INSERT INTO uth_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ye̱ ken go̱-ye̱ he̱nu̱ru̱ u̱n dak-o̱ u̱r-bon. Ye̱ bo̱su̱ru̱ ye̱ rwu̱ntu̱ru̱ po̱t, ko̱ yo ke yish o-zungu 100.” Ye̱so ko̱mu̱ru̱ m-ze̱e̱, “Ho̱gu̱ no̱, u̱rege̱ no̱ ro̱ u̱t-to̱ ne̱!” ");
INSERT INTO uth_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Yan-neke̱-mo̱ u̱n wu̱ citu̱ru̱ wu̱, “¿Ya o co̱nu̱ te̱ m-ru̱re̱ ne̱ u̱n ka sha-mo̱ u̱t-ma mo̱?” ");
INSERT INTO uth_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Wu̱ shasu̱ru̱, “Rii-yo a wuke̱ be-de u̱n gwo̱mo-to̱ Shir à, yo ro̱ u̱n kom-u̱t no̱, amba be-de u̱n ye̱ ken ye̱ se̱ a mo̱ssu̱te̱ u̱n sha-mo̱ u̱t-ma ne̱ remen ye̱a gu̱t, amba ye̱a hyen á, komo ye̱a ho̱ge̱ amba ye̱a nep á. ");
INSERT INTO uth_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Ka sha-mo̱ u̱t-ma to̱ mo̱ ka: Ka go̱-ye̱ Ma-to̱ Shir to̱. ");
INSERT INTO uth_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Ka go̱-ye̱ he̱ne̱ u̱n co̱w à, ye̱ ro̱ ye̱ ho̱ge̱ à, amba ko-Gwo̱mo-wu̱ u̱n ya-u̱t-ko̱t haag wu̱ deks yo ye̱ ho̱ge̱ à u̱n hur-de u̱n ye̱, remen wu̱ wenet ye̱ be-de m-go̱ks u̱n ma-to̱ u̱n gwu̱. ");
INSERT INTO uth_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Ka go̱-ye̱ he̱ne̱ u̱t-ta'ar à, ye̱ ro̱ ye̱ ho̱ge̱ u̱t-ma à, ye̱ go̱ksu̱ru̱ gwe̱rgwe̱r. Amba to̱ co̱w ye̱ u̱t-me̱n á, ya o-da hiin ye̱ go̱kse̱, amba da-o̱ meger-u̱t wo̱o̱ne̱ à, ye̱ hosu̱ru̱. ");
INSERT INTO uth_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Ka ye̱ he̱ne̱ be-de u̱n yokor à, ye̱ ro̱ ye̱ ho̱ge̱ à, komo ye̱ go̱ks, amba yaane̱ ye̱ u̱n ye̱ ne̱n á, remen co̱n-to̱ u̱n rii u̱n tu̱k-mo̱ u̱t-me̱n ne̱, co̱n-to̱ u̱n hwo̱r, u̱n co̱n-to̱ u̱n ho̱ge̱ m-re̱re̱m ne̱. ");
INSERT INTO uth_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Ka ye̱ he̱ne̱ u̱n dak-o̱ u̱r-bon à, ye̱ ro̱ ye̱ ho̱ge̱ u̱t-ma à, komo ye̱ e̱ssu̱ru̱ to̱ u̱n hur-de o-do̱ro̱tte̱ komo ye̱ se̱ngu̱ru̱ m-no̱m u̱n rii-yo Shir co̱n ne̱ à. ");
INSERT INTO uth_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Hun-ne̱ ro̱ m-do̱ u̱r-pitirra ye̱ ho̱kku̱ru̱ de o-ko̱k á. Ko̱ u̱n ku̱s-o̱ o-kwu̱u̱r á. Ye̱ de m-dor n-to̱n remen ya-m-co̱wo̱n ye̱ hyenet. ");
INSERT INTO uth_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","“Bo̱ u̱n yo no̱ wuke̱ à, Shir a rwu̱nte̱ yo cas, komo bo̱ u̱n yo no̱ ho̱kke̱ à, Shir a hyen yo wu̱ rwu̱nte̱ yo cas. ");
INSERT INTO uth_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","“No̱m no̱ ce̱e̱n, bo̱ no̱ ro̱ m-ho̱ge̱ à, remen ye̱ ro̱ u̱n rii ne̱ à, ye̱ a he m-do'e̱, amba ye̱ ro̱tte̱ rii á, Shir a rumus ka yo ye̱ hyane̱ ye̱ ro̱ u̱n yo ne̱ à.” ");
INSERT INTO uth_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Inu Ye̱so u̱n hen-ne̱ ye̱ u̱n wu̱ ne̱ haante̱ be-de u̱n wu̱, amba ye̱ hoks wu̱ m-do̱re̱ á remen hun-ne̱ no̱mo̱g de̱e̱n. ");
INSERT INTO uth_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Wu̱ ken wu̱ ze̱e̱ru̱ Ye̱so, “Inu ru u̱n hen-ne̱ ru ne̱ ro̱ eso n-do̱ komo ye̱ co̱no̱g wo̱ m-hyan.” ");
INSERT INTO uth_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Ye̱so ze̱e̱ru̱ ye̱ kap, “Inu re u̱n hen-ne̱ re ne̱ ye̱ ro̱, ka ye̱ ho̱ge̱ Ma-to̱ Shir à, ye̱ nom bo̱ ka ma-to̱ zee à.” ");
INSERT INTO uth_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","De ken ho̱-de Ye̱so daaru̱ o-hat, u̱n yan-neke̱-mo̱ u̱n wu̱ ne̱. Komo wu̱ ze̱e̱ru̱ ye̱, “A pes no̱ de ka jit-de u̱n caari-o̱ o-mar de.” Ye̱ taknu̱ru̱ m-ru. ");
INSERT INTO uth_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Bo̱ ye̱ ro̱ m-neke̱ à, Ye̱so 'he̱bu̱ m-rew. Ye̱ ro̱ kane̱ caari-mo̱ m-yo hundu̱ru̱ n-to̱n o-mar, komo ho̱-m taknu̱ru̱ m-shi o-hat, ye̱ hyanu̱ru̱ m-mar u̱n yish. ");
INSERT INTO uth_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Yan-neke̱-m Ye̱so haaru̱ be-de u̱n wu̱, ye̱ 'yonsu̱ru̱ wu̱, ye̱ ro̱ m-ze̱e̱, “Go̱s-wu̱, Go̱s-wu̱! A ma-to̱ m-mar!” Ye̱so inu̱ru̱, wu̱ huru̱ m-yo u̱t-gaag, m-ho̱ ne̱ mo̱ re̱su̱ru̱ temb. ");
INSERT INTO uth_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Ka da-de wu̱ ze̱e̱ru̱ yan-neke̱-mo̱ u̱n wu̱, “¿Remen yan o̱ no̱ she̱rté̱ u̱n me̱ á?” Amba ye̱ ho̱gu̱te̱ o-gye̱r komo ye̱ ze̱e̱ru̱ hi u̱n de u̱n ye̱, “¿Yan go̱n ne̱t-wu̱ ne̱ wu̱ ka? M-yo, m-ho̱ ne̱ mo̱ ro̱ wu̱ o-do̱ro̱tte̱.” ");
INSERT INTO uth_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Ye̱so u̱n yan-neke̱-mo̱ u̱n wu̱ ne̱ pasu̱ru̱ riib-o dak-o̱ o-Garasa, o̱ ro̱ pesto-de Mar-o̱ o-Gariri à. ");
INSERT INTO uth_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Bo̱ Ye̱so yawagte̱ o-riib à, wu̱ gontu̱ru̱ wu̱ ken ne̱t-wu̱, ko-ya-o-Gedara, wu̱ ro̱ u̱n ya-u̱t-ko̱t ne̱ à. Ka ne̱t-wu̱ no̱mo̱g u̱s-hak de̱e̱n wu̱ ro̱ m-neke̱ u̱r-kor komo wu̱ ro̱ m-she'et o-hur á, se̱ be-de u̱n saag-se u̱n margan-ne̱ wu̱ ro̱ m-she'et. ");
INSERT INTO uth_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Bo̱ wu̱ hyente̱ Ye̱so à, wu̱ 'yonsu̱ru̱ u̱s-co̱r wu̱ kanu̱ru̱, wu̱ so̱ru̱ hi u̱n de u̱n wu̱ n-dak u̱n na-u̱s Ye̱so komo wu̱ no̱mu̱ru̱ o-zaaz, “Ye̱so, Wà-wu̱ u̱n Shir n-To̱n! ¿Ya o co̱ne̱ u̱n me̱ ne̱? U̱m ko̱no̱g wo̱, wo̱ 'ya me̱ u̱r-ko̱o̱b á!” ");
INSERT INTO uth_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Wu̱ ze̱e̱g kaane̱ remen Ye̱so ze̱e̱g ya-u̱t-ko̱t ye̱ ru u̱n hi-de u̱n wu̱. Ye̱ swo̱o̱g wu̱ m-so̱ n-dak, komo hun-ne̱ u̱n wu̱ ka'ag wu̱ ba m-ru, ye̱ ka'ag wu̱ u̱t-kom u̱s-na ne̱, wu̱ kesemse̱. Ka ya-u̱t-ko̱t ye̱ ro wu̱ m-ruut o-ko̱t remen ye̱ zu̱ngsu̱te̱ wu̱. ");
INSERT INTO uth_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Ye̱so citu̱ru̱ wu̱, “¿Waane̱ jin u̱n du?” “Jin u̱n de ‘Timb.’ ” Wu̱ u̱n shas kaane̱ remen ya-u̱t-ko̱t ro̱ de̱e̱n u̱n hi-de u̱n wu̱. ");
INSERT INTO uth_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Ka ya-u̱t-ko̱t ye̱ ko̱nu̱ru̱ Ye̱so, “Wo̱ 'ya te̱ u̱r-ko̱o̱b u̱n kuub-o̱ u̱r-du̱w á.” ");
INSERT INTO uth_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Caari-o̱ u̱n kur-o u̱n are̱de ro̱ kane̱ yow yow, ye̱ ro̱ u̱t-re̱ n-riib u̱r-dor. Ka ya-u̱t-ko̱t ye̱ ko̱nu̱ru̱ Ye̱so yage̱ ye̱ tu̱wu̱t be-de u̱n are̱de, komo wu̱ yagu̱ru̱ ye̱. ");
INSERT INTO uth_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Ye̱ ruuru̱ be-de u̱n ka ne̱t-wu̱, ye̱ wargu̱ru̱ be-de u̱n are̱de. Ka kur-o̱ u̱n are̱de o̱ yiru̱gbu̱ru̱ o-bu̱ng se̱ n-me̱ u̱n caari-o̱ o-mar ho̱-m re̱e̱ru̱ ye̱ kap. ");
INSERT INTO uth_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Bo̱ yan are̱de hyane̱ yo no̱me̱ à, ye̱ so̱mu̱ru̱ o-rek. Ye̱ ko̱'o̱tu̱ru̱ ho̱no o-bo̱ u̱t-kat ne̱. ");
INSERT INTO uth_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Hun-ne̱ ruuru̱ ye̱ hyenet yo no̱me̱ à, komo bo̱ ye̱ wo̱'o̱nte̱ be-u̱r Ye̱so à, ye̱ hyanu̱ ka ne̱t-wu̱, wu̱ ya-u̱t-ko̱t ru'e̱ be-de u̱n wu̱ à, wu̱ ro̱ tara u̱n na-u̱s Ye̱so, u̱t-gund ne̱ to̱ u̱r-bon tu̱pse̱ komo wu̱ ro̱ ba u̱n go̱m, ye̱ ho̱gu̱ru̱ o-gye̱r kap mo̱ u̱n ye̱. ");
INSERT INTO uth_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Ye̱ hyane̱ yo nome̱ à, ye̱ ru̱ru̱ hun-ne̱ bo̱ Ye̱so taase go̱m u̱n wu̱ à. ");
INSERT INTO uth_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Ka da-de hun-ne̱ kap u̱n ka raag-o̱ ko̱nu̱ru̱ Ye̱so wu̱ arag so̱ wu̱ he'e̱ à, remen ye̱ ho̱gu̱te̱ o-gye̱r. Ye̱so daaru̱ o-hat wu̱ ro̱ ma-to̱ m-arag. ");
INSERT INTO uth_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Ka ne̱t-wu̱ a ruute̱ ya-u̱t-ko̱t be-de u̱n wu̱ à, ko̱nu̱ru̱ Ye̱so, “Yage̱ u̱m do̱ru̱te̱ wo̱.” Amba Ye̱so ze̱e̱ru̱, ");
INSERT INTO uth_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Ay, warag o-hur, o ru̱re̱ ye̱ yo Shir nomo wo̱ à.” Ka ne̱t-wu̱ do̱ru̱ru̱ ho̱no o-bo̱, wu̱ ro̱ ye̱ m-ru̱re̱ yo Ye̱so nome̱ wu̱ à. ");
INSERT INTO uth_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Da-o̱ Ye̱so mu̱u̱ne̱ de ka jit-de o-mar de à, hun-ne̱ barku̱te̱ wu̱, remen ye̱ ro̱ wu̱ u̱r-'er. ");
INSERT INTO uth_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Wu̱ ken ne̱t-wu̱ wo̱o̱nu̱ru̱, jin-de u̱n wu̱ Jaros, ne̱t wan-co u̱n kuke̱-o̱ u̱n yoos u̱n Ma-to̱ Shir, o̱ ro̱ kane̱ à. Wu̱ so̱ru̱ hi u̱n de u̱n wu̱ n-dak u̱n na-u̱s Ye̱so wu̱ ko̱nu̱ru̱ Ye̱so remen wu̱ heet u̱n hur-o̱ u̱n wu̱. ");
INSERT INTO uth_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Remen wà u̱n wu̱ wan-ne'a, wu̱ ro̱ wu̱ wan-gaan à, hak-se u̱n wu̱ u̱ntu̱n o̱p u̱s-yoor 12 wu̱ ro̱ ma-to̱ m-mar. Ye̱so ro̱ m-neke̱, hun-ne̱ ro̱ wu̱ m-mo̱o̱r de̱e̱n ko̱ o̱ ke raag-o̱. ");
INSERT INTO uth_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","N-me̱ u̱n ye̱ wu̱ ken ne'a-wu̱ ro kon wu̱ swo̱ u̱r-ko̱o̱b hyó-mo̱ wu̱ m-ru à har hak-u̱s o̱p u̱s-yoor 12, wu̱ ho̱o̱g kap yo wu̱ rotte̱ à u̱n hoob-o̱ ko-ya-u̱s-baat, amba yatt-wu̱ hokse̱ taas u̱n go̱m-o̱ u̱n wu̱ á. ");
INSERT INTO uth_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Wu̱ co̱wu̱ru̱ u̱n bu̱u̱g-de u̱n hun-ne̱ n-jim Ye̱so, komo wu̱ ci'u̱ru̱ riib-o̱ u̱n gund-o Ye̱so, ka hyó-mo̱ ro wu̱ m-ru à mo̱ ka'u̱ru̱. ");
INSERT INTO uth_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Ye̱so citu̱ru̱, “¿Wan wu̱ ne̱ ci me̱?” Ko̱ wu̱ ke she'u̱ru̱, Bitrus ze̱e̱ru̱, “Go̱s-wu̱, hun-ne̱ ro̱ u̱n riib-u̱s ru kap ye̱ ro̱ wo̱ m-me̱gemse̱.” ");
INSERT INTO uth_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Amba Ye̱so ze̱e̱ru̱, “Wu̱ ken wu̱ ci'ig me̱, u̱m nak remen 'wo̱ns-m ruug be u̱n de.” ");
INSERT INTO uth_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Ka ne'a-wu̱ napu̱ru̱ Ye̱so nepste̱, wu̱ rwu̱u̱nu̱ru̱ u̱s-zap, wu̱ he̱e̱ru̱ u̱n na-u̱s Ye̱so. U̱n hyan-o̱ u̱n ko̱ wu̱ ke, wu̱ ru̱ru̱ Ye̱so yo rwo̱'e̱ wu̱ ci'it Ye̱so à, komo wu̱ ru̱ru̱ Ye̱so bo̱ go̱m-o̱ u̱n wu̱ ta hwe̱w à. ");
INSERT INTO uth_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Ye̱so ze̱e̱ru̱ wu̱, “Wà re, Shir taaste̱ go̱m ru, remen o she̱re̱g be u̱n de. Arag gwu̱gwu̱.” ");
INSERT INTO uth_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Ye̱so ro̱ m-ze̱e̱ u̱n kaane̱, ko-yan-to̱m ro̱ m-wo̱o̱n so̱ u̱n hur-o̱ u̱n wan-co u̱n kuke̱-o̱ u̱n yoos u̱n Ma-to̱ Shir. Wu̱ ru̱ru̱ Jaros, “Wà ru wan-ne'a mereste̱, wo̱ su'e̱ Wa-u̱r-Yoos á.” ");
INSERT INTO uth_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Amba Ye̱so ho̱gu̱ru̱ wu̱ ze̱e̱ru̱ Jaros, “Wo̱ ho̱ge̱ o-gye̱r á, wo̱ de she̱r be u̱n de, komo wà ru wu̱a warag ba u̱n go̱m.” ");
INSERT INTO uth_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Bo̱ Ye̱so wo̱o̱ne̱ u̱n ka hur-o̱ à, wu̱ ze̱e̱ru̱ ko̱ wu̱ ke wu̱ e̱s n-do̱, se̱ Bitrus, Yohana u̱n Yakubu, se̱ komo tato u̱n wà, o-inu ne̱. ");
INSERT INTO uth_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Ko̱ wu̱ ke ro̱ u̱s-'wo̱n remen ka wà-wu̱. Ye̱so ze̱e̱ru̱, “No̱ 'wo̱n á, ka wà-wu̱, wu̱ mar á, rew-mo̱ wu̱ ro̱tte̱!” ");
INSERT INTO uth_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Ye̱ nemsu̱ru̱ wu̱ kap, remen ye̱ nepse̱ wu̱ mereste̱. ");
INSERT INTO uth_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Amba Ye̱so bo̱pu̱ru̱ kom-o̱ u̱n ka wà-wu̱, wu̱ ze̱e̱ru̱, “Ine̱, wà re!” ");
INSERT INTO uth_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Ho̱o̱g-mo̱ u̱n ka wà-wu̱ mu̱u̱nu̱ru̱, wu̱ inu̱ru̱ kagat. Ye̱so ze̱e̱ru̱ ye̱, “Ya no̱ wu̱ rii-yo m-re̱.” ");
INSERT INTO uth_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","In-ne̱ ye̱ u̱n wu̱ bo̱pu̱ru̱ o-nu, amba Ye̱so ze̱e̱ru̱ ye̱, “No̱ ru̱re̱ ne̱t yo no̱me̱ á.” ");
INSERT INTO uth_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Ye̱so agnu̱ru̱ yan-neke̱-mo̱ u̱n wu̱ o̱p u̱n yoor 12 be-u̱r gaan, wu̱ ya'u̱ru̱ ye̱ u̱r-be̱e̱b, u̱t-gwo̱mo ne̱, to̱ u̱n ruut u̱n ya-u̱t-ko̱t, komo u̱n taas u̱s-go̱m ne̱. ");
INSERT INTO uth_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Ka da-de wu̱ to̱mu̱ru̱ ye̱, ye̱ ru̱r ma-to̱ u̱n gwo̱mo-to̱ Shir komo ye̱ taas u̱s-go̱m. ");
INSERT INTO uth_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Wu̱ ze̱e̱ru̱ ye̱, “No̱ de̱k rii remen ka hew-de á, o-ko̱, ko̱ o-ba, rii-yo m-re̱, ko̱ hwo̱r, ko̱ matuku-de arge̱ u̱r-gaan á. ");
INSERT INTO uth_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","She'et no̱ be-de a barku̱ no̱ à, har no̱ ruut u̱n ka bo̱-o̱. ");
INSERT INTO uth_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Be-de hun-ne̱ barku̱ no̱ á, ru no̱ u̱n ka bo̱-o̱, komo no̱ soks hu-mo̱ u̱n na-u̱s no̱, ye̱ nept no̱ hu̱ste̱ hi u̱n no̱.” ");
INSERT INTO uth_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Yan-neke̱-mo̱ u̱n wu̱ ruuru̱ ye̱ do̱ru̱ru̱ u̱t-bo̱, ye̱ ro̱ m-rwo̱r u̱n ka Ma-to̱ m-Re̱re̱m to̱ komo u̱n taas u̱n go̱m-se u̱n hun-ne̱ ko̱ kene̱. ");
INSERT INTO uth_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Da-o̱ Here̱ Atipas, ko-gwamna-wu̱ o-Gariri, ho̱ge̱ kap rii-yo takan à, wu̱ zo̱'o̱ru̱ru̱, remen ye̱ ken hun-ne̱ ye̱ ro̱ m-ze̱e̱ Yohana Wa-m-Yo'os u̱n hun-ne̱ n-me̱ m-ho̱ inu̱te̱ u̱t-marimar. ");
INSERT INTO uth_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Ye̱ ken ye̱ ro̱ m-ze̱e̱, E̱reja mu̱u̱ne̱, komo ye̱ ken ye̱ zee wan-Rwo̱r u̱n Ma-to̱ Shir n-ga mu̱u̱te̱ u̱n ho̱o̱g ne̱. ");
INSERT INTO uth_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Here̱ ze̱e̱ru̱, “U̱m kupste̱ hi-u̱r Yohana, amba ¿wan wu̱ ne̱ wu̱ ka ne̱t-wu̱, wu̱ ro̱ m-no̱m u̱n go̱n se ka rem-se?” Komo wu̱ ro̱ m-se̱nge̱ wu̱ hyenet Ye̱so. ");
INSERT INTO uth_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Yan-To̱m Ye̱so mu̱u̱nu̱ru̱ komo ye̱ ru̱ru̱ Ye̱so kap rii-yo ye̱ no̱me̱ à. Wu̱ de̱ku̱ru̱ ye̱, komo ye̱ ruuru̱ u̱n hi u̱n de u̱n ye̱, ye̱ co̱wu̱ru̱ o̱ ken bo̱-o̱ jin-de u̱n o̱ o-Besayada. ");
INSERT INTO uth_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Da-o̱ bu̱u̱g-de u̱n hun-ne̱ ho̱ge̱ kaane̱ à, ye̱ do̱ru̱ru̱ wu̱. Wu̱ barku̱ru̱ ye̱, wu̱ ru̱ru̱ ye̱ ma-to̱ u̱n gwo̱mo-to̱ Shir, wu̱ taasu̱ru̱ go̱m-se u̱n ye̱ co̱ne̱ go̱m-se u̱n ye̱ te à. ");
INSERT INTO uth_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Da-de ho̱-u̱r ro̱ ma-to̱ m-'he̱be̱ à, yan-neke̱-mo̱ u̱n wu̱ ne̱n o̱p u̱n yoor 12 haaru̱ be-de u̱n wu̱ ye̱ ze̱e̱ru̱, “Zee ka hun-ne̱ ye̱ warag remen ye̱ tu̱wu̱t u̱t-hur, u̱t-kat ne̱ u̱n riib kane̱ remen ye̱ kumut rii-yo m-re̱ u̱n be-de m-rew ne̱, remen kane̱ rii-yo m-re̱ u̱n be-de m-rew ne̱ ro̱ ko̱n á.” ");
INSERT INTO uth_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Amba Ye̱so ze̱e̱ru̱ ye̱, “Ya no̱ ye̱ rii-yo ye̱ he m-re̱ à.” Ye̱ shasu̱ru̱, “Kap yo te̱ ro̱tte̱ à sho̱n-to̱ u̱t-ga u̱t-taan to̱ u̱n jan ne̱ yoor, ¿wo̱ u̱n co̱n o̱ te̱ he te̱ o̱ne̱ ho̱n u̱n ka bu̱u̱g-de u̱n hun-ne̱ de rii-yo m-re̱?” ");
INSERT INTO uth_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","(Campo̱-ne̱ wooste̱ dugu-u̱s taan 5,000 kane̱.) Ye̱so ze̱e̱ru̱ yan-neke̱-mo̱ u̱n wu̱, “Zee no̱ ye̱ she'et bu̱u̱g-u̱t-bu̱u̱g, hun-ne̱ kwo̱o̱z-u̱t yoor u̱n o̱p 50 ko̱ de ke bu̱u̱g-de.” ");
INSERT INTO uth_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Bo̱ yan-neke̱-mo̱ u̱n wu̱ komte̱ m-no̱m kaane̱ à, ");
INSERT INTO uth_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Ye̱so de̱ku̱ru̱ ka buro̱di-u̱t taan-to̱ u̱n ka jan-ye̱ ne̱ yoor, wu̱ gwo̱tu̱ru̱ n-To̱n u̱n shir, wu̱ bo̱mu̱ru̱ Shir, wu̱ yeksu̱ru̱ ka ga-to̱ bo̱s-u̱t-bo̱s u̱n jan ne̱. Wu̱ yasu̱ru̱ yan-neke̱-mo̱ u̱n wu̱, ye̱ wonge̱ hun-ne̱. ");
INSERT INTO uth_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Kap mo̱ u̱n ye̱, ye̱ re̱e̱ru̱, ye̱ ciig, komo yan-neke̱-mo̱ u̱n wu̱ mo̱ro̱gsu̱ru̱ to̱ kwange̱ à ko̱o̱r-u̱t o̱p u̱t-yoor 12. ");
INSERT INTO uth_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","De ken ho̱-de Ye̱so ro̱ u̱n ko̱n-se Shir u̱n ho̱n-de u̱n wu̱, yan-neke̱-mo̱ u̱n wu̱ haaru̱ be-de u̱n wu̱. Ye̱so citu̱ru̱ ye̱. “¿Wan wu̱ ne̱ ka bu̱u̱g-de u̱n hun-ne̱ de zee u̱m ro̱?” ");
INSERT INTO uth_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Ye̱ shasu̱ru̱, “Ye̱ ken ne̱ zee Yohana Wa-m-Yo'os u̱n hun-ne̱ m-ho̱. Amba ye̱ ken ye̱ zee E̱reja wu̱, komo ye̱ ken ye̱ zee wan-gaan be-de u̱n yan-rwo̱r u̱n Ma-to̱ Shir n-ga wu̱ mu̱u̱ne̱ u̱n ho̱o̱g.” ");
INSERT INTO uth_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Wu̱ citu̱ru̱ ye̱, “No̱ ne̱ ¿wa u̱n wu̱ no̱ zee u̱m ro̱?” Bitrus shasu̱ru̱, “Wo̱ wu̱, Kiristi.” ");
INSERT INTO uth_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Ka da-de Ye̱so naku̱ru̱ ye̱ u̱t-to̱, “No̱ ru̱re̱ ko-wan-gaan ka rii-yo á.” ");
INSERT INTO uth_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Wu̱ ze̱e̱ru̱ ye̱ komo, “Me̱ Wà-wu̱ u̱n ne̱t a su̱ u̱r-ko̱o̱b de̱e̱n, komo se̱k-ye̱, u̱n Gwo̱mo-ne̱ ye̱ u̱n ko̱n-se Shir, komo u̱n yan-Yoos-de o-karamsa ne̱, ye̱a kutu me̱ u̱t-yage̱. Ye̱a ho me̱, amba me̱ no̱me̱ ho̱-u̱t tet, man ine̱ u̱n ho̱o̱g ne̱ komo.” ");
INSERT INTO uth_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Wu̱ ze̱e̱ru̱ ye̱ kap, “Bo̱ u̱n wu̱ co̱ne̱ m-neke̱ u̱n me̱ ne̱ à, se̱ wu̱, she̱'e̱g hi u̱n de u̱n wu̱, wu̱ dek kan-o̱ u̱n wu̱ ko̱ de ke ho̱-de, wu̱ do̱ru̱ me̱. ");
INSERT INTO uth_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Bo̱ u̱n wu̱ co̱ne̱ wuke̱ u̱n ho̱o̱g-mo̱ u̱n wu̱ à, mo̱a e̱ge̱ wu̱, amba bo̱ u̱n wu̱ ho̱o̱g-mo̱ u̱n wu̱ e̱ge̱ rem re à, wu̱a kum mo̱. ");
INSERT INTO uth_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","¿Yaane̱ ne̱t kume̱, u̱rege̱ wu̱ kumug saw-to̱ u̱n ho̱no o-dak kap, amba wu̱ kum ho̱o̱g-mo̱ u̱n wu̱ á? Wu̱ kum rii á. ");
INSERT INTO uth_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","U̱rege̱ hun-ne̱ ro̱ m-ho̱ge̱ 'e̱-m re u̱n yoos u̱n de ne̱, kaane̱ Wà-wu̱ u̱n ne̱t he m-ho̱ge̱ 'e̱-mo̱ u̱n ye̱ da-o̱ wu̱ he m-mu̱u̱n u̱n se̱ke̱mse̱-mo̱ u̱n wu̱ ne̱, u̱n mo̱ u̱n tato u̱n wu̱ ne̱, u̱n mo̱ u̱n yan-to̱m-se Shir ne̱ à. ");
INSERT INTO uth_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Nip-o̱, ye̱ ken ye̱ be-u̱r no̱ kane̱, ye̱a mer á, se ye̱ hyanag gwo̱mo-to̱ Shir.” ");
INSERT INTO uth_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","U̱ntu̱n ho̱-u̱t ta'yoor bo̱ m-ze̱e̱ kaane̱, Ye̱so de̱ku̱ru̱ Bitrus, Yohana u̱n Yakubu ne̱ ye̱ neke̱ru̱ u̱n wu̱ ne̱ n-to̱n u̱r-dor ye̱ konot Shir. ");
INSERT INTO uth_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Bo̱ wu̱ ro̱ u̱s-ko̱n à, co-o̱ u̱n wu̱ barmu̱ru̱ u̱n ho̱n, komo saw-to̱ u̱n wu̱ wargu̱ru̱ u̱t-pus to̱ pyar. ");
INSERT INTO uth_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","U̱n gyept-o̱ u̱n yish, hun-ne̱ yoor rwu̱u̱nu̱ru̱, ye̱ ro̱ u̱t-ma u̱n wu̱ ne̱. Ka hun-ne̱ ye̱ Mosa wu̱ u̱n E̱reja. ");
INSERT INTO uth_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Ye̱ rwu̱u̱ne̱ u̱n se̱ke̱mse̱-mo̱ n-to̱n ne̱, komo ye̱ no̱mu̱ru̱ u̱t-ma u̱n Ye̱so ne̱. Hi-de u̱n ma-to̱ u̱n ye̱ de ka, bo̱ Ye̱so he m-shoos u̱n Ma-to̱ Shir wu̱ meret o-Urusharima à. ");
INSERT INTO uth_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Bitrus u̱n o̱r u̱n wu̱ ne̱, ye̱ ro̱ u̱n mar-mo̱ m-rew, amba bo̱ ye̱ zu̱te̱ à, ye̱ hyanu̱ru̱ mo̱k-o Ye̱so u̱n ka hun-ne̱ ye̱ ne̱ ne̱n yoor. Ye̱ ro̱ eso u̱n Ye̱so ne̱. ");
INSERT INTO uth_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Bo̱ ka hun-ne̱ ye̱ aragte̱ ye̱ yage̱ Ye̱so à, Bitrus ze̱e̱ru̱ wu̱, “Go̱s-wu̱, no̱mo̱g u̱r-bon bo̱ te̱ ro̱ kane̱ à! Te̱a no̱m de̱pi-u̱t tet, u̱r-gaan rem ru, u̱r-gaan de ma Mosa, u̱r-gaan komo, de ma E̱reja.” (Wu̱ nap yo wu̱ ro̱ m-ze̱e̱ á.) ");
INSERT INTO uth_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Bo̱ wu̱ ro̱ m-se̱nge̱ mo̱ te̱p à, ke'ente̱-u̱r rwu̱u̱nu̱ru̱ de ho̱kku̱ru̱ ye̱ de nomu̱ru̱ ye̱ m-wu̱wu̱r, yan-neke̱-m Ye̱so ho̱gu̱ru̱ o-gye̱r bo̱ ka ke'ente̱-de ho̱kke̱ ye̱ à. ");
INSERT INTO uth_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Co̱r-o rwu̱u̱nu̱ru̱ u̱n ka ke'ente̱-de o̱ ro̱ m-ze̱e̱, “Wu̱ ka, wu̱ ro̱ wà re, wu̱ u̱m daage̱ à, ho̱gu̱ no̱ ma-to̱ u̱n wu̱!” ");
INSERT INTO uth_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Bo̱ ka co̱r-o re̱ste̱ à, ye̱ hyanu̱ru̱ Ye̱so u̱n ho̱n-de u̱n wu̱. Yan-neke̱-mo̱ u̱n wu̱ kamu̱ru̱ o-nu, ye̱ ru̱re̱ ko-wan-gaan yo ye̱ hyane̱ ka da-o̱ á. ");
INSERT INTO uth_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Bo̱ ish geste̱ à, Ye̱so u̱n yan-neke̱-mo̱ u̱n wu̱ ne̱ ne̱n tet kergu̱nu̱ru̱ n-to̱n u̱n ka dor-de, caari-de u̱n bu̱u̱g-de u̱n hun-ne̱ wo̱o̱ru̱ be-u̱r Ye̱so. ");
INSERT INTO uth_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","U̱n ka bu̱u̱g-de, wu̱ ken ne̱t-wu̱ 'yonsu̱ru̱ u̱s-co̱r, “Wa-u̱r-Yoos! U̱m ko̱no̱g wo̱, gu wà re, wu̱ ro̱ me̱ wan-campo̱ u̱n ho̱n-de u̱n wu̱! ");
INSERT INTO uth_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Ko-ya-u̱t-ko̱t bo̱k wu̱, wu̱ 'yonste̱ u̱s-co̱r wu̱ so̱ru̱ wu̱ pak, ko̱p-u̱t ro̱ m-rwu̱u̱n o-nu, ye̱ ro̱ wu̱ m-rangse̱ kaane̱, ye̱ wu̱ m-yage̱ wu̱ aragte̱ á! ");
INSERT INTO uth_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","U̱m ko̱no̱g yan-neke̱-m ru remen ye̱ ruuté̱ ka wa-u̱t-ko̱t wu̱, amba ye̱ hoks á.” ");
INSERT INTO uth_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Ye̱so shasu̱ru̱, “Re no̱me̱ ne̱ no̱ go̱kste̱ o-nip á, no̱ ya-u̱r-ba'as! ¿Har yan da-o̱ u̱m he m-hakku̱re̱ u̱n no̱ ne̱?” Ka da-de wu̱ ze̱e̱ru̱ ka ne̱t-wu̱, “Hante̱ wà ru kane̱.” ");
INSERT INTO uth_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Bo̱ ka wà-wu̱ ro m-nekne̱ à, ka wa-u̱t-ko̱t wu̱ kapsu̱ru̱ wu̱ n-dak kak. Ye̱so huru̱ wa-u̱t-ko̱t u̱t-gaag. Wu̱ taasu̱ru̱ go̱m-o̱ u̱n ka wà-wu̱, wu̱ tebbu̱ru̱ ka tato-o̱. ");
INSERT INTO uth_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Ka hun-ne̱ ye̱ kap hyanu̱ru̱ o-made̱, u̱t-go̱s, u̱n 'wo̱ns-mo̱ Shir ne̱. Da-o hun-ne̱ ro̱ u̱n barag-se u̱n kap rii-yo Ye̱so ro̱ m-no̱m à, wu̱ zee yan-neke̱-mo̱ u̱n wu̱, ");
INSERT INTO uth_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“To̱-u̱t to̱ ka no̱ rii-yo u̱m he no̱ m-ru̱re̱ á! A ya'as Wà-wu̱ u̱n ne̱t be-de u̱n gwo̱mo-to̱ u̱n hun-ne̱.” ");
INSERT INTO uth_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Amba yan-neke̱-mo̱ u̱n wu̱ ye̱ nap yo wu̱ ro̱ ye̱ m-ru̱re̱ á. A rwu̱nte̱ to̱ cas bo̱ ye̱ he m-nap á, komo ye̱ cit wu̱ ko̱ yan yo á, remen ye̱ ro̱ m-ho̱ge̱ o-gye̱r. ");
INSERT INTO uth_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Ma-u̱t su̱nu̱te̱ yan-neke̱-m Ye̱so ye̱ co̱no̱g ye̱ nep wu̱ jiishe̱ u̱t-go̱s à, be-de u̱n ye̱. ");
INSERT INTO uth_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Ye̱so napu̱ru̱ yo ye̱ ro̱ m-ceker à, wu̱ de̱knu̱ru̱ wà re̱k-wu̱, wu̱ e̱ssu̱ru̱ wu̱ n-riib o̱ u̱n wu̱. ");
INSERT INTO uth_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Wu̱ ze̱e̱ru̱ ye̱, “Ko̱ wu̱ ke barke̱ ka wà-wu̱ u̱n jin u̱n de, wu̱ barku̱tu̱ me̱, komo wu̱ barku̱ me̱ à, wu̱ barku̱te̱ wu̱ to̱mne̱ me̱ à. Remen kaane̱ wu̱ ro̱ re̱k-wu̱ be-u̱r no̱ à, wu̱ ro̱ go̱s-wu̱ kap.” ");
INSERT INTO uth_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Yohana ce̱pu̱ru̱ u̱t-ma, “Go̱s-wu̱, te̱ hyanag wu̱ ken ne̱t-wu̱, wu̱ ro̱ m-ruut u̱n ya-u̱t-ko̱t u̱n jin u̱n du, te̱ ze̱e̱ru̱ wu̱ yage̱, remen be-u̱r na wu̱ ro̱ á.” ");
INSERT INTO uth_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Ye̱so ze̱e̱ru̱ wu̱ u̱n o̱r u̱n wu̱ ne̱, “No̱ do wu̱ m-we̱n á, remen ko̱ wu̱ ke wu̱ yagu̱ no̱ á wu̱ ma no̱ wu̱.” ");
INSERT INTO uth_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Bo̱ da-o wo̱o̱te̱ yow yow o̱ Shir hette̱ Ye̱so m-de̱k n-to̱n à, wu̱ zo̱ngsu̱ru̱ hur-de u̱n wu̱, wu̱ bo̱pu̱ru̱ co̱w-yo o-Urusharima. ");
INSERT INTO uth_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Wu̱ to̱mu̱ru̱ yan-to̱m-ye̱ u̱n wu̱ u̱n co, n-me̱ bo̱-o o-Samariya remen ye̱ e̱sté̱ ko̱ yo ke rii-yo hond hond rem Ye̱so. ");
INSERT INTO uth_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Amba ka hun-ne̱ ye̱ re̱e̱no̱ ye̱ go̱ks wu̱ á, remen ye̱ nepse̱ wu̱ bu̱pse̱ co̱w-yo o-Urusharima. ");
INSERT INTO uth_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Da-o̱ yan-neke̱-mo̱ u̱n wu̱ Yakubu u̱n Yohana hyane̱ kaane̱ à, ye̱ ze̱e̱ru̱, “Go̱s-wu̱, ¿o co̱no̱g te̱ agan o-ra n-to̱n o̱ sabu̱rse̱ ye̱?” ");
INSERT INTO uth_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Ye̱so waktu̱ru̱ wu̱ kangsu̱ru̱ ye̱. ");
INSERT INTO uth_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Ye̱so u̱n yan-neke̱-mo̱ u̱n wu̱ ne̱ haaru̱ de ken bo̱-de. ");
INSERT INTO uth_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Bo̱ ye̱ aragte̱ arag-mo̱ u̱n ye̱ à, wu̱ ken ne̱t-wu̱ ze̱e̱ru̱ Ye̱so, “Man do̱re̱ wo̱ ko̱ ke so̱ o ha'e̱.” ");
INSERT INTO uth_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Ye̱so ze̱e̱ru̱ wu̱, “Kondo ro̱ u̱t-wu ne̱, ye̱ge̱-no ro̱ u̱t-kur ne̱, amba Wà-wu̱ u̱n ne̱t ro̱tt be-de wu̱ he m-ru̱s u̱n hi-de u̱n wu̱ á.” ");
INSERT INTO uth_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Wu̱ ze̱e̱ru̱ wu̱ ken ne̱t-wu̱, “Do̱nd me̱.” Amba ka ne̱t-wu̱ ze̱e̱ru̱, “Go̱s-wu̱, yage̱ u̱m ji'iste̱ u̱r-takan remen u̱m ju̱kt tato re, da-o̱ wu̱ mere̱.” ");
INSERT INTO uth_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Ye̱so shasu̱ru̱ wu̱, “Yage̱ margan-ne̱ ju̱kt u-de u̱n ye̱. Wo̱ ha, o ko̱'o̱t gwo̱mo-to̱ Shir.” ");
INSERT INTO uth_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Wu̱ ken wu̱ ze̱e̱ru̱, “Go̱s-wu̱, man do̱re̱ wo̱, amba se u̱m kamasu̱te̱ hur-o re.” ");
INSERT INTO uth_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Ye̱so ze̱e̱ru̱ wu̱, “Ko̱ wu̱ ke wu̱ bo̱pe̱ kerem-de u̱n na à, ka da-de wu̱ masu̱ru̱ m-wakte̱ u̱s-ajima ne̱, hwaa-o wu̱ ro̱ be-de u̱n gwo̱mo-to̱ Shir.” ");
INSERT INTO uth_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Bo̱ u̱n kaane̱, Ye̱so daagu̱ru̱ komo ye̱ ken hun-ne̱ ye̱ kwo̱o̱z-u̱t tet u̱n o̱p u̱n yoor 72. Wu̱ to̱mu̱ru̱ ye̱ yoor yoor, ye̱ tek co-o u̱n wu̱ ye̱ tu̱w ko̱ o̱ ke bo̱-o̱, u̱n kap be-de wu̱ ro̱ ma-to̱ m-ha ne̱ u̱n hi u̱n de u̱n wu̱ à. ");
INSERT INTO uth_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Wu̱ ze̱e̱ru̱ ye̱, “Ce-m ro̱ de̱e̱n, amba ya-m-ce hiin. Ko̱n no̱ wa-o-kat-wu̱ do̱o̱n ya-m-ce, remen ye̱ komot ka ce-mo̱ u̱n wu̱ mo̱. ");
INSERT INTO uth_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Neke̱ no̱! Me̱ no̱ m-to̱m u̱ntu̱n ca be-de u̱n ye̱ge̱-dur. ");
INSERT INTO uth_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","No̱ de̱k hwo̱r á, ko̱ o-ba, ko̱ no̱ dek ka'ante̱-to̱ arge̱ na-o o-gaan á. No̱ e̱s no̱ gaste̱ ne̱t u̱n co̱w á. ");
INSERT INTO uth_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","“Da-o̱ no̱ ine̱ m-co̱w u̱n o̱ ken hur-o̱, takan no̱ m-ze̱e̱, ‘Shir 'ye ka hur-o̱ m-gwu̱gwu̱.’ ");
INSERT INTO uth_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","U̱rege̱ ye̱ barku̱tu̱ no̱, Shir a 'ye ye̱ gwu̱gwu̱-mo̱ u̱r-hur de̱e̱n. Amba u̱rege̱ ye̱ barku̱ no̱ á, Shir a 'ye ye̱ gwu̱gwu̱-mo̱ u̱r-hur á. ");
INSERT INTO uth_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","She'et no̱ u̱n hur-o̱ u̱n ye̱ barku̱ no̱ à, no̱ re̱ no̱ su̱ yo ye̱ ya'u̱ no̱ à, remen ya-m-se̱nge̱ a topo ye̱ se̱nge̱-mo̱ u̱n ye̱. No̱ pa u̱t-hur á. ");
INSERT INTO uth_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","“Da-o̱ no̱ tu̱we̱ n-me̱ o-bo̱, komo a barku̱ no̱, re̱ no̱ yo a hantu̱ no̱ à. ");
INSERT INTO uth_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Taas no̱ ye̱, go̱m-se u̱n ye̱ se̱ ye̱ ro̱tte̱ à u̱n ka bo̱-o̱. No̱ zee ka hun-ne̱ ye̱, ‘Gwo̱mo-to̱ Shir haante̱ yow yow be-u̱r no̱.’ ");
INSERT INTO uth_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Amba da-o̱ no̱ tu̱we̱ n-me̱ o-bo̱ komo a barku̱ no̱ á, ru no̱ u̱n riib u̱s-co̱w no̱ zee, ");
INSERT INTO uth_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Ko̱ hu-mo̱ u̱n bo̱-o no̱ mo̱ dapu̱te̱ u̱s-na à, te̱ sokste̱ mo̱ u̱n hi u̱n no̱. Amba no̱a baks gwo̱mo-to̱ Shir haante̱ yow yow u̱n no̱ ne̱!’ ");
INSERT INTO uth_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Me̱ no̱ m-ru̱re̱, ho̱-de u̱n piish u̱t-ma, Shir a ho̱ge̱ 'wo̱n-de bo̱-o̱ o-So̱do̱m wu̱ yage̱ ka bo̱-o̱ 'yaru̱ no̱ à! ");
INSERT INTO uth_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Rii-yo u̱r-'wo̱n yo no̱ ya-o-Korazin! Rii-yo u̱r-'wo̱n yo no̱ komo ya-o-Besayada! U̱rege̱ hyat-to̱ a no̱me̱ be-u̱r no̱ à, a no̱mo̱g to̱ o-Taya o-Sidon ne̱, hun-ne̱ ye̱ u̱n kane̱ o̱tte̱ she'ete̱, n-dak ye̱ tu̱p gund-to̱ u̱n naasu̱-mo̱ u̱t-me̱n, ye̱ aase̱ hi u̱n de u̱n ye̱ m-co̱w, a nept ye̱ yagu̱te̱ ba'as-de u̱n ye̱. ");
INSERT INTO uth_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","No̱a su̱ u̱r-ko̱o̱b arge̱ o-Taya o-Sidon ne̱, ho̱-de u̱n piish u̱t-ma. ");
INSERT INTO uth_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Komo rem ru, o-Kapanahum! ¿Wo̱ u̱n co̱n jaks u̱n hi u̱n du n-To̱n u̱n shir? Shir a jorbu̱ wo̱ u̱n kuub-o̱ o-ra!” ");
INSERT INTO uth_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Ye̱so ze̱e̱ru̱ yan-neke̱-mo̱ u̱n wu̱, “Kap wu̱ ho̱gu̱ no̱ à, wu̱ ho̱gu̱te̱ me̱, komo wu̱ 'yare̱ no̱ à, wu̱ 'yarag me̱, kaane̱ komo wu̱ 'yare̱ me̱ à, wu̱ 'yarag wu̱ to̱mne̱ me̱ à.” ");
INSERT INTO uth_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Ka hun-ne̱ ye̱ kwo̱o̱z-u̱t tet u̱n o̱p u̱n yoor 72 campo̱-ne̱ mu̱u̱nte̱ o-zak ne̱ de̱e̱n. Ye̱ ze̱e̱ru̱, “Go̱s-wu̱, ko̱ ya-u̱t-ko̱t ye̱ nomu̱tu̱te̱ o-do̱ro̱tte̱ u̱n jin u̱n du!” ");
INSERT INTO uth_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Ye̱so shasu̱ru̱ ye̱, “U̱m hyanag ko-Gwo̱mo-wu̱ u̱n ya-u̱t-ko̱t he̱'e̱nte̱ n-dak u̱ntu̱n u̱s-myakt. ");
INSERT INTO uth_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Ho̱gu̱ no̱! U̱m ya'ag no̱ u̱t-gwo̱mo, no̱ yawag hwo̱, u̱n tot-ne̱, no̱ sabu̱rse̱ 'wo̱ns-mo̱ u̱n wa-u̱t-yage̱, komo ye̱a ci no̱ á. ");
INSERT INTO uth_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Amba no̱ no̱m o-zak remen ya-u̱t-ko̱t nomotu̱ no̱ o-do̱ro̱tte̱ á, no̱m no̱ o-zak remen Shir ge̱ne̱g jin-u̱t no̱ be-de wu̱ n-to̱n.” ");
INSERT INTO uth_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","U̱n ka da-o̱ Ku̱kt-o Shir sho̱'o̱ste̱ Ye̱so o-zak, wu̱ ze̱e̱ru̱, “Tato re, Wan-Ko̱yan n-To̱n u̱n dak ne̱, u̱m bo̱mo̱g wo̱ remen o kutute̱ ye̱ rotte̱ u̱s-nap á, rii-yo o wuke̱ ya-u̱s-we̱e̱r u̱n ya-u̱s-nap ne̱ à. E̱e̱, tato re, kaane̱ o co̱ne̱ o nom. ");
INSERT INTO uth_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","“Tato re, ya'ag me̱ rii kap. Yatt-wu̱ nape̱ yo ka wà-wu̱ ro̱ á, se̱ tato u̱n wu̱, komo yatt-wu̱ nape̱ yo ka tato-o̱ ro̱ á, se̱ ka wà-wu̱, se̱ komo ye̱ ka wà-wu̱ daage̱ wu̱ ru̱ru̱te̱ ye̱ à.” ");
INSERT INTO uth_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Ka da-de Ye̱so waktu̱ru̱ be-de u̱n yan-neke̱-mo̱ u̱n wu̱ u̱n riib u̱n ho̱n-de u̱n ye̱ wu̱ ze̱e̱ru̱ ye̱, “No̱ re̱e̱g u̱r-ho̱ no̱ hyenet rii-yo no̱ hyane̱ à! ");
INSERT INTO uth_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Me̱ no̱ m-ru̱re̱, yan-rwo̱r u̱n Ma-to̱ Shir de̱e̱n u̱n gwo̱mo-ne̱ ro co̱no̱g ye̱ hyen yo no̱ hyane̱ à, amba ye̱ hoks á, komo ye̱ ro co̱no̱g ye̱ ho̱ge̱ yo no̱ ho̱ge̱ à, amba ye̱ ho̱ge̱ á.” ");
INSERT INTO uth_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Wan-napse̱ o-karamsa haante̱ remen wu̱ ce'ept Ye̱so. Wu̱ zee, “Wa-u̱r-Yoos, ¿re ne̱ u̱m he m-no̱m u̱m kumut ho̱o̱g-o̱ ba m-ta?” ");
INSERT INTO uth_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Ye̱so shasu̱ru̱ wu̱, “¿Ya ne̱ karamsa-o Shir zee? ¿Re ne̱ o wakse̱ o̱?” ");
INSERT INTO uth_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Ka ne̱t-wu̱ shasu̱ru̱, “Co̱n Yawe Shir ru u̱n hur u̱n du myet, u̱n ho̱o̱g-m ru ne̱ kap, u̱n 'wo̱ns-m ru ne̱ kap, u̱n we̱e̱r-u̱s ru ne̱ kap, o cu̱n wan-bo̱r-o ru bo̱ o co̱ne̱ hi u̱n du à.” ");
INSERT INTO uth_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Ye̱so shasu̱ wu̱, “O shaks hond hond, no̱m kaane̱, wo̱a kum ho̱o̱g-o̱ ba m-ta.” ");
INSERT INTO uth_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Amba ka wan-Yoos-de o-karamsa wu̱ co̱no̱g wu̱ muut hi u̱n de u̱n wu̱ ba u̱r-ba'as, remen kaane̱ wu̱ citu̱ru̱ Ye̱so, “¿Wa ne̱ ro̱ ko-wan-bo̱r-o re?” ");
INSERT INTO uth_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Ye̱so shasu̱ru̱ wu̱, “Wu̱ ken ne̱t-wu̱ ro̱ m-neke̱ rwu̱u̱n-mo̱ o-Urusharima wu̱ ro̱ m-ha o-Jeriko, ya-u̱r-kwu̱p kupu̱ru̱ wu̱, ye̱ deku̱ru̱ kap yo wu̱ rotte̱ à, ye̱ bu̱u̱gu̱ru̱ wu̱, ye̱ yagu̱ wu̱ ma-to̱ m-mar. ");
INSERT INTO uth_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Haanu̱ru̱ wu̱ ken wan-Co̱w u̱n ko̱n-se Shir, wu̱ ro̱ m-do̱re̱ u̱n ka co̱w-yo, amba bo̱ wu̱ hyente̱ ka ne̱t-wu̱ à, wu̱ pa'u̱ru̱ u̱n riib. ");
INSERT INTO uth_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","U̱n ka co̱w-yo komo wu̱ ken wu̱ ko-Rewi do̱nte̱ yo wu̱ argu̱ru̱, wu̱ gwo̱tu̱ru̱ ka ne̱t-wu̱, ka da-de wu̱ argu̱ru̱ arag-mo̱ u̱n wu̱ o̱ ka riib-o̱. ");
INSERT INTO uth_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Amba ko-Samariya-wu̱ ro̱ u̱r-hew u̱n ka co̱w-yo à, wo̱o̱nu̱ru̱ be-de u̱n ka ne̱t-wu̱, bo̱ wu̱ hyente̱ wu̱ à, hur-de u̱n wu̱ ho̱gu̱ru̱ 'wo̱n-de u̱n ka ne̱t-wu̱. ");
INSERT INTO uth_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Wu̱ haaru̱ be-de u̱n wu̱, wu̱ sosu̱ru̱ wu̱ ka nát-to̱, wu̱ rwo̱'u̱ru̱ no̱w-mo̱ u̱s-baat, wu̱ yereru̱ u̱t-magund, ka da-de wu̱ detu̱ru̱ ka ne̱t-wu̱ n-to̱n o-janka yo u̱n wu̱, komo wu̱ heetu̱ru̱ wu̱ be-de u̱n o̱ ken hur-o̱, kane̱ a gwo̱te̱ wu̱. ");
INSERT INTO uth_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Bo̱ ish geste̱ à, wu̱ rwu̱ntu̱ru̱ hwo̱r-ye̱ jir-u̱t yoor-to̱ u̱r-gu̱wu̱s, wu̱ yasu̱ru̱ wa-u̱r-gu̱t. Wu̱ ru̱ru̱ wa-u̱r-gu̱t, ‘Gwo̱t wu̱ u̱r-bon ne̱, da-o̱ me̱ mu̱u̱ne̱ u̱n ka co̱w-yo, man top wo̱ yo o ho̱'e̱ be-de u̱n wu̱ à.’ ” ");
INSERT INTO uth_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Ye̱so citu̱ru̱, “U̱n hyan-o ru, be-de u̱n ka hun-ne̱ tet ye̱, ¿wa no̱me̱ u̱ntu̱n ko-yan-bo̱r o-hur be-de u̱n ka ne̱t-wu̱ ya-u̱r-kwu̱p bu̱u̱ge̱ à?” ");
INSERT INTO uth_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Ko yan-Yoos-de o-karamsa shasu̱ru̱, “Ka wu̱ no̱me̱ yo kute̱ hun-ne̱ wu̱ ho̱gu̱te̱ 'wo̱n-de u̱n wu̱ à.” Ye̱so ze̱e̱ru̱, “Wo̱ neke̱, o no̱m kaane̱.” ");
INSERT INTO uth_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Bo̱ Ye̱so u̱n yan-neke̱-mo̱ u̱n wu̱ ne̱ aragte̱ arag-mo̱ u̱n ye̱ à, wu̱ haaru̱ de ken bo̱-de wu̱ ken ne'a-wu̱ jin-de u̱n wu̱ Marta, barku̱ru̱ Ye̱so u̱n hur-o̱ u̱n wu̱. ");
INSERT INTO uth_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Wu̱ ro̱ o-heno ne̱, jin-de u̱n wu̱ Meri, wu̱ she'ete̱ u̱n na-u̱s Ye̱so wu̱ ro̱ m-ho̱ge̱ yo Ye̱so ro̱ u̱r-yoos à. ");
INSERT INTO uth_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Marta ho̱ge̱ re̱re̱m-mo̱ u̱n kaane̱ á, remen se̱nge̱-mo̱ ro̱ u̱n co-o̱ u̱n wu̱ à, wu̱ haanu̱ru̱ wu̱ ze̱e̱ru̱, “Go̱s-wu̱, ¿wo̱ hyan heno re yaksu̱tu̱ me̱ m-se̱nge̱ u̱n ho̱n-de à? Zee wu̱ haan wu̱ gu me̱!” ");
INSERT INTO uth_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Go̱s-wu̱ shasu̱ru̱ wu̱, “Marta, Marta! Hur u̱n du ru̱t á, o zo̱ru̱te̱ remen rii de̱e̱n, ");
INSERT INTO uth_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","amba gaan-yo cot, jiishe̱ u̱r-bon. Meri dak kashi u̱n rii. Komo a rumus wu̱ yo á.” ");
INSERT INTO uth_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","De ken ho̱-de Ye̱so ro̱ u̱n ko̱n-se u̱n Shir u̱n de ken be-de. Bo̱ wu̱ komte̱ à, wan-gaan be-de u̱n yan-neke̱-mo̱ u̱n wu̱ ze̱e̱ru̱ wu̱, “Go̱s-wu̱, yoosu̱ te̱ bo̱ te̱ he ko̱n u̱n Shir à, bo̱ Yohana yoose̱ yan-neke̱-mo̱ u̱n wu̱ à.” ");
INSERT INTO uth_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Ye̱so ze̱e̱ru̱ ye̱, “Da-o̱ no̱ ro̱ u̱n ko̱n-se u̱n Shir à, ze̱e̱ no̱ kaane̱: “ ‘Tato te̱, te̱ ko̱no̱g hun-ne̱ se̱ke̱mse̱ jin u̱n du. O yage̱ gwo̱mo-u̱t ru haante̱ be u̱n te̱. ");
INSERT INTO uth_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Ya te̱ rii-yo m-re̱ yo u̱n ko̱ de ke ho̱-de, yo te̱ o-hoob à. ");
INSERT INTO uth_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Soksu̱ te̱ ba'as u̱n te̱, remen te̱ sokstè̱ ba'as-de u̱n ko̱ wu̱ ke wu̱ nomu̱ te̱ u̱r-ba'as à. Komo wo̱ yage̱ te̱ te̱ heet be-de u̱t-meger á.’ ” ");
INSERT INTO uth_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Komo Ye̱so ze̱e̱ru̱ yan-neke̱-mo̱ u̱n wu̱, “A zee wan-gaan be-u̱r no̱ haag hur-o nay u̱n wu̱ m-te̱t da-o pu̱rge̱, wu̱ zee, ‘Nay, mu̱u̱gu̱ me̱ sho̱n-u̱t tet-to̱ u̱t-ga. ");
INSERT INTO uth_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Wu̱ ken nay re wu̱, wu̱ rwu̱u̱ne̱ u̱r-hew à, wu̱ wo̱o̱nte̱ u̱n hur-o re, amba me̱tt rii-yo m-re̱ yo u̱m he wu̱ m-'ya á!’ ");
INSERT INTO uth_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","A zee komo nay ru shasu̱nte̱ n-me̱ o-hur, ‘Wo̱ su me̱ á! U̱m tegu̱ssu̱te̱ ish, komo me̱ do̱mb u̱n yakar re ne̱. Man hoks m-ine̱ u̱m ye'et wo̱ rii á.’ ");
INSERT INTO uth_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Me̱ no̱ m-ru̱re̱, u̱rege̱ ma wu̱ ine̱ remen wu̱ ya'aste̱ wo̱ ka sho̱n-to̱ u̱t-ga to̱ remen wo̱ nay u̱n wu̱ á, wu̱a ine̱ wu̱ ya'aste̱ wo̱ kap rii-yo o co̱ne̱ à, remen wo̱ ho̱ge̱ 'e̱-mo̱ u̱n 'yons u̱n wu̱ o se̱ngu̱te̱ wu̱ m-cit á. ");
INSERT INTO uth_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Remen kaane̱ u̱m ze̱e̱g no̱: Ko̱n no̱, Shir a 'ye no̱, hoob no̱, no̱a kum, ko̱'o̱t no̱ ish, Shir a tikshe̱ no̱. ");
INSERT INTO uth_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Remen kap ye̱ ko̱ne̱ à, Shir a 'ye ye̱, komo ye̱ ho̱o̱be̱ à, ye̱a kum, komo wu̱ ko̱'o̱te̱ ish à, Shir a tikshe̱ wu̱. ");
INSERT INTO uth_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Ho̱gu̱ no̱, no̱ tat-ne̱, da-o̱ wà ru ko̱ne̱ o-jan, ¿wo̱a 'ye wu̱ o-hwo̱? ");
INSERT INTO uth_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Komo da-o̱ wà ru ko̱ne̱ u̱r-ge̱, ¿wo̱a 'ye wu̱ o-tot? Ay! ");
INSERT INTO uth_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","No̱ yan-me̱n-u̱t jaas-to̱, no̱ nak 'ya u̱n yakar no̱ rii-yo u̱r-bon. ¿Re he m-no̱m u̱n ne̱, tato no̱ n-to̱n ro̱tte̱ a 'ye ye̱ ko̱ne̱ wu̱ Ku̱kt-o u̱n wu̱ á? Eba, wu̱a 'ye ye̱!” ");
INSERT INTO uth_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Wu̱ ken ne̱t-wu̱ ro m-hoks m-te̱pe̱r á, remen ya-u̱t-ko̱t daag wu̱ u̱r-hi. Ye̱so ruutu̱ru̱ ka ya-u̱t-ko̱t ye̱, ka da-o̱ ka ne̱t-wu̱ hoksu̱ru̱ m-te̱pe̱r. ");
INSERT INTO uth_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Amba ye̱ ken hun-ne̱ ye̱ ze̱e̱ru̱, “Beru̱zabur wu̱, ko-Gwo̱mo-wu̱ u̱n ya-u̱t-ko̱t, wu̱ ya'e̱ wu̱ u̱r-be̱e̱b de u̱n ruut u̱n ye̱.” ");
INSERT INTO uth_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Komo ye̱ ken ye̱ co̱no̱g ye̱ ceeb Ye̱so. Remen kaane̱ ye̱ citu̱ru̱, wu̱ kute̱ ye̱ u̱t-hyat ye̱ nept Shir ya'e̱ wu̱. ");
INSERT INTO uth_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Amba Ye̱so napu̱ru̱ yo ye̱ ro̱ u̱s-barag à, wu̱ ze̱e̱ru̱ ye̱, “Ko̱ o̱ ke dak-o̱ wo̱nge̱ hi u̱n de u̱n o̱ kwu̱ku̱r u̱r-kwu̱ku̱r ye̱ ma'aste̱ m-dum u̱n hi u̱n de u̱n ye̱ ka dak-o̱ a she'et de̱e̱n á. Hur-o̱ wo̱nge̱ hi u̱n de u̱n o̱ à, o̱ he de m-e̱s á. ");
INSERT INTO uth_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","U̱rege̱ gwo̱mo-to̱ u̱n ko-Gwo̱mo-wu̱ u̱n ya-u̱t-ko̱t wo̱ngu̱te̱, to̱ ro̱ m-dum u̱n hi u̱n de u̱n to̱, ¿re he m-no̱m to̱ she'ette̱? No̱ ze̱e̱g u̱m ruute̱ ya-u̱t-ko̱t remen Beru̱zabur ya'ag me̱ u̱r-be̱e̱b de m-no̱m kaane̱. ");
INSERT INTO uth_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","U̱rege̱ kaane̱ o̱ me̱ ye̱ m-ruut, re ne̱ ¿yan-do̱re̱-m no̱ ro̱ ye̱ m-ruute̱ ne̱? Yan-do̱re̱-m no̱ ye̱a hyen no̱ ba'asu̱te̱ no̱ hond hond á! ");
INSERT INTO uth_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Ai ka rii-yo u̱m nome̱ u̱n be̱e̱b-de Shir o̱ rwo̱'e̱ u̱m ruute̱ ya-u̱t-ko̱t, kaane̱, komo a kutute̱ no̱ o̱ ka gwo̱mo-to̱ Shir ro̱ be-u̱r no̱. ");
INSERT INTO uth_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Da-o̱ ko-be̱e̱b ro u̱n 'er-de u̱n hur-o̱ u̱n wu̱ u̱n po̱r-to̱ u̱n wu̱ ne̱, wu̱a gu hur-o̱ u̱n wu̱ u̱n saw-to̱ u̱n wu̱ ne̱. ");
INSERT INTO uth_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Amba da-o̱ wu̱ jiishe̱ wu̱ m-'wo̱ns he̱be̱ wu̱ à, wu̱a hoks wu̱, wu̱a rumus wu̱ saw-to̱ u̱n wu̱ to̱ u̱r-gu̱n kap to̱ wu̱ sekte̱ hur-de u̱n wu̱ à. Wu̱ wo̱nge̱ ye̱ ken ye̱ saw-to̱ u̱n wu̱. ");
INSERT INTO uth_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Ko̱ wu̱ ke wu̱ ro̱ u̱n ho̱n u̱n me̱ ne̱ à, ko-yan-yage̱-u̱t re wu̱, ko̱ wu̱ ke wu̱ yage̱ me̱ m-gu m-mo̱ro̱gse̱ à, cakarse̱-mo̱ wu̱ ro̱tte̱. ");
INSERT INTO uth_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Da-o̱ wa-u̱t-ko̱t ru be-de u̱n ne̱t, wu̱ ro̱ m-do̱re̱ u̱n dak-u̱t 'hwo̱'o̱g-to̱ u̱n hoob-o̱ u̱n be-de m-co̱w wu̱ wu̱wu̱te̱. U̱rege̱ wu̱ kum á, wu̱ ro̱ m-ze̱e̱ u̱n hi u̱n de u̱n wu̱, ‘Man warag u̱n hur-o re.’ ");
INSERT INTO uth_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Wu̱ warge̱ wu̱ 'wosse̱ ka hur-o̱ cas cas u̱r-bon ne̱. ");
INSERT INTO uth_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Ka da-de wu̱ haaru̱ wu̱ bandu̱ru̱ ye̱ ken ye̱ ne̱n ta'yoor-ye̱ jiishe̱ wu̱ m-zo̱m à, ye̱ haaru̱ ye̱ she'etu̱ru̱ kane̱. Da-o̱ ye̱ komse̱ kap à, go̱m-o̱ u̱n ka ne̱t-wu̱ m-mo̱ka o̱a jiish o̱ n-ga.” ");
INSERT INTO uth_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Bo̱ Ye̱so komte̱ m-ze̱e̱ kaane̱ à, wu̱ ken ne'a-wu̱ te̱pru̱nu̱ru̱ n-me̱ u̱n bu̱u̱g-de u̱n hun-ne̱, wu̱ ze̱e̱ru̱ Ye̱so, “Ko-wa-o-kwu̱m-wu̱, ka ne'a-wu̱ mate̱ wu̱ gu̱t wo̱ à.” ");
INSERT INTO uth_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Amba Ye̱so shasu̱ru̱, “Ye̱ ma ya-o-zak-ye̱, ye̱ ho̱ge̱ Ma-to̱ Shir ye̱ do̱re̱ to̱ à!” ");
INSERT INTO uth_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Bo̱ hun-ne̱ mo̱rge̱ be-u̱r Ye̱so à, wu̱ se̱ngu̱ru̱ m-ze̱e̱, “Hun-ne̱ ye̱ m-mo̱ka ro̱ u̱n me̱n-u̱t jaas-to̱ ne̱! Ye̱ ro̱ m-cit a kute̱ ye̱ u̱t-hyat, amba ko̱ o-gaan man kute̱ ye̱ á se hyat-u̱t Yunana. ");
INSERT INTO uth_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Yunana napa-o̱ be-de u̱n hun-ne̱ ye̱ o-Neneba, kaane̱ komo Wà-wu̱ u̱n ne̱t napa-o̱ be-de u̱n hun-ne̱ ye̱ m-mo̱ka. ");
INSERT INTO uth_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Ho̱-de m-piish u̱t-ma, gwo̱mo-de o-Sheba ne'a wu̱a ine̱ eso wu̱ kute̱ ye̱ ba'as-de u̱n ye̱, remen wu̱ neknu̱te̱ rwu̱u̱n-mo̱ u̱n dak-o̱ u̱n wu̱, wu̱ ho̱gu̱te̱ yoos-de u̱s-we̱e̱r de ma ko-Gwo̱mo Suremanu. Me̱ no̱ m-ru̱re̱, wu̱ ken wu̱ ro̱ ko̱n wu̱ jiishe̱ Suremanu à. ");
INSERT INTO uth_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Ho̱-de u̱n piish u̱t-ma hun-ne̱ ye̱ o-Neneba ye̱a ine̱ ye̱ cit no̱, remen ye̱ yagu̱te̱ no̱m u̱r-ba'as da-o̱ ye̱ ho̱ge̱ Yunana ro̱ m-rwo̱r u̱n Ma-to̱ Shir à, me̱ no̱ m-ru̱re̱ komo, wu̱ ken wu̱ ro̱ ko̱n kane̱ wu̱ jiishe̱ Yunana à! ");
INSERT INTO uth_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Yatt-wu̱ he do̱ u̱r-pitirra wu̱ wuku̱ru̱ de á, ko̱ wu̱ ho̱kku̱ru̱ de o-shaar á, amba wu̱a sek de n-to̱n remen hun-ne̱ hyenet m-cecas bo̱ ye̱ ro̱ m-co̱wo̱n n-me̱ à. ");
INSERT INTO uth_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Ya yish no̱ ro̱ u̱ntu̱n u̱r-pitirra, u̱n wu̱r-o no̱. U̱rege̱ yish no̱ ro̱ ke̱rke̱r, wu̱r-o no̱ kap o̱a no̱m kyarkyar, amba yish no̱ ro u̱r-bon ne̱ á, wu̱r-o no̱ kap o̱a ma'as n-me̱ o-comb. ");
INSERT INTO uth_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Ceker no̱ u̱r-bon ne̱, yo no̱ deke̱ nip-o̱ à, nip-o jip bo̱-to̱ á. ");
INSERT INTO uth_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Kang-o̱ o-gaan, u̱rege̱ no̱ co̱no̱g no̱ nep Shir, wu̱a ru̱ru̱ no̱ kap yo ro̱ o-nip à. U̱rege̱ ko̱ raag-o gaan no̱ 'yar yo ro̱ o-nip á, o̱a no̱m sa o zee no̱ ro̱ u̱r-she'et be-de u̱r-pitirra.” ");
INSERT INTO uth_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Bo̱ Ye̱so komte̱ u̱t-ma à, ko-Parisa banu̱ru̱ wu̱ re̱ u̱n rii-yo m-re̱. Wu̱ co̱wu̱ru̱ n-me̱ wu̱ she'etu̱ru̱ tara wu̱ reet. ");
INSERT INTO uth_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Ka ko-Parisa-wu̱ bo̱pu̱ru̱ o-nu da-o̱ wu̱ hyane̱ Ye̱so wu̱ sapt u̱t-kom á. ");
INSERT INTO uth_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Kaane̱ Go̱s-wu̱ ze̱e̱ wu̱, “M-mo̱ka no̱ Parisa-ne̱ no̱ ro̱ m-so'os jim-de u̱r-ibitte̱ u̱t-ko̱k ne̱, amba me̱-u̱r no̱ ro̱ cip u̱n hu ne̱. ");
INSERT INTO uth_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Raag-ne̱! Shir, wu̱ no̱me̱ u̱r-do̱ à, wu̱ no̱me̱ u̱r-me̱! ");
INSERT INTO uth_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Amba ya'as no̱ ko̱o̱b-ne̱ yo ro̱ n-me̱ u̱r-ibitte̱ u̱t-ko̱k ne̱ à, Shir a so'osu̱ no̱ ko̱ yo ke rii-yo. ");
INSERT INTO uth_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Tu no̱ yish Parisa-ne̱, remen rii-yo o-gye̱r yo be-u̱r no̱, no̱ m-ya'as u̱n Shir o-gaan be-de u̱n o̱p u̱n ko̱ yo ke rii-yo no̱ m-kum da-o̱ m-ce ko̱ yo ro̱ de̱e̱n á. U̱n hwo̱r ne̱, u̱n to̱ ken saw-to̱ ne̱, amba no̱ m-no̱m o-nip á, komo no̱ co̱n Shir á. Yoos no̱ kap, no̱ jore̱ ko̱ o-gaan á. ");
INSERT INTO uth_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Tu no̱ yish Parisa-ne̱, remen rii-yo gye̱r-yo no̱, no̱ co̱no̱g be-to̱ u̱r-she'et to̱ a e̱sse̱ u̱n ho̱n à, n-me̱ u̱n kuke̱-to̱ u̱n yoos u̱n Ma-to̱ Shir, no̱ cu̱n hun-ne̱ ye̱ kwu̱kt n-dak ye̱ gas no̱ be-de u̱t-baab m-o̱ ne̱. ");
INSERT INTO uth_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Tu no̱ yish remen rii-yo gye̱r-yo be-u̱r no̱! Ya no̱ ro̱ u̱ntu̱n saag-se ba o-napa, se hun-ne̱ ro̱ m-yawag ba ye̱ u̱n nap á.” ");
INSERT INTO uth_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Wan-gaan be-de u̱n yan-Napse̱ o-karamsa ze̱e̱ru̱ wu̱, “Wa-u̱r-Yoos, da-o̱ o ze̱e̱ kaane̱ à, o ci'ig te̱ u̱r-hur!” ");
INSERT INTO uth_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Ye̱so shasu̱ru̱, “No̱ ma tu no̱ yish remen rii-yo gye̱r-yo yan-Napse̱ o-karamsa! No̱ sawsu̱te̱ hun-ne̱ u̱t-saw u̱n hi-to̱ u̱n ye̱, to̱ ro̱ ba m-re̱re̱m mo̱ m-saw á, amba no̱ u̱n hi u̱n no̱, no̱ hoks m-neks o-jow no̱ guut ye̱ m-saw u̱n ka saw-to̱ á. ");
INSERT INTO uth_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Tu no̱ yish remen rii-yo gye̱r-yo be-u̱r no̱, no̱ ja'aste̱ saag-se u̱n yan-rwo̱r u̱n Ma-to̱ Shir, ka yan-rwo̱r u̱n Ma-to̱ Shir ye̱ ya-n-ga-ye̱ no̱ ho̱ à. ");
INSERT INTO uth_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","No̱ ma u̱n hi u̱n no̱, no̱ go̱kste̱ yo ya-n-ga-ye̱ no̱ ne̱ no̱me̱ à, ye̱ ho̱o̱g yan-rwo̱r u̱n Ma-to̱ Shir, no̱ komo no̱ maag saag-se u̱n ye̱ u̱t-raks. ");
INSERT INTO uth_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Remen kaane̱, we̱e̱r-se Shir ze̱e̱g, ‘Man tomo̱ ye̱ yan-rwo̱r u̱n Ma-to̱ Shir u̱n yan-to̱m ne̱, ye̱a ho ye̱ ken ye̱, komo ye̱ ke ye̱ ken ye̱.’ ");
INSERT INTO uth_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Shir a 'ye hun-ne̱ ye̱ u̱n ka da-o̱ u̱r-ko̱o̱b remen ye̱ ho̱o̱g yan-rwo̱r u̱n Ma-to̱ Shir kap, cin da-o̱ a no̱me̱ ho̱no o-dak à. ");
INSERT INTO uth_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Da-o̱ Keen ho̱'e̱ E̱ber à ha-mo̱ u̱n, da-o̱ hun-ne̱ ho'e̱ Zakaraya, (wu̱ a ho̱'e̱ u̱n te̱te̱-o̱ o-hana u̱n be-de ba m-ku̱ko̱p ne̱ n-me̱ u̱n Pyo-o̱ Shir). E̱e̱, me̱ no̱ m-ru̱re̱, hun-ne̱ ye̱ m-mo̱ka a su̱ u̱r-ko̱o̱b remen ye̱ kap! ");
INSERT INTO uth_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Tu no̱ yish remen rii-yo gye̱r-yo be-u̱r no̱ yan-Napse̱ o-karamsa! No̱ wukute̱ rii-yo m-tiksh u̱n ish-o̱ u̱n hur-o̱ u̱s-nap. No̱ co̱w á, no̱ we̱ne̱g komo ye̱ co̱ne̱ m-co̱w à.” ");
INSERT INTO uth_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Da-o̱ Ye̱so yage̱ ka be-de à, yan-Yoos-de o-karamsa u̱n Parisa-ne̱ taknu̱ru̱ ya'as u̱n Ye̱so u̱r-ba'as ba m-re̱re̱m. Ye̱ citu̱ru̱ wu̱ u̱s-cot de̱e̱n remen ");
INSERT INTO uth_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","ye̱ cept wu̱, ye̱ bu̱pt wu̱ m-ze̱e̱ u̱n rii-yo u̱r-ba'as. ");
INSERT INTO uth_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Bo̱ hun-ne̱ de̱e̱n mo̱rgu̱te̱ à, har ye̱ ken ye̱ ro̱ m-yawag u̱n ye̱ ken, u̱r-takan Ye̱so ze̱e̱ru̱ yan-neke̱-mo̱ u̱n wu̱, “Tu no̱ Parisa-ne̱ yish remen no̱ hyenet she̱pe̱-o̱ u̱n ye̱. Ye̱ we̱kt m-ze̱e̱ u̱n rii komo ye̱ no̱mu̱ru̱ yo ken yo u̱n ho̱n. ");
INSERT INTO uth_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Bo̱ u̱n yo a ho̱kke̱ à, Shir a upsu̱sse̱ yo, komo kap yo a wuke̱ à, Shir a rwu̱u̱nte̱ yo. ");
INSERT INTO uth_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Remen kaane̱, bo̱ u̱n yo no̱ rwo̱re̱ o-comb à, a ho̱ge̱ yo u̱n no̱n-ho̱ cangam, komo bo̱ u̱n yo no̱ no̱me̱ pegesse̱ u̱s-har n-me̱ o-kuke̱ tigu̱she̱, a ko̱'o̱t yo n-to̱n u̱r-do̱o̱b de o-kuke̱. ");
INSERT INTO uth_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Me̱ no̱ m-ru̱re̱, nay re ne̱, no̱ ho̱ge̱ gye̱r-o u̱n ye̱ he m-ho̱ o-wu̱r á, amba ye̱a hoks m-no̱m yo arge̱ kaane̱ á. ");
INSERT INTO uth_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Man kutu no̱ wu̱ no̱ he m-gye̱r à: Gye̱r no̱ Shir, wu̱ he m-ho̱ à, wu̱ ho̱'e̱ komo wu̱ ro̱ u̱t-gwo̱mo ne̱ wu̱ jorbu̱te̱ u̱n den-o̱ o-ra. De̱k no̱ ma-u̱t re, wu̱ wu̱ no̱ he m-gye̱r! ");
INSERT INTO uth_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Gorop taan ye̱a rwu̱u̱nte̱ hwo̱r de̱e̱n á. Kap u̱n kaane̱ ne̱, ko o-gaan yo ka Shir u̱t-to̱ á. ");
INSERT INTO uth_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Ko̱ hi-se u̱n hi-u̱t no̱ ogse̱ se̱ ro̱ kap. Remen kaane̱ no̱ ho̱ge̱ o-gye̱r á, no̱ jiishte̱ gorop de̱e̱n u̱n hyan-o̱ Shir. ");
INSERT INTO uth_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Me̱ no̱ m-ru̱re̱, bo̱ u̱n ye̱ rwu̱u̱ne̱ cas ye̱ zee ye̱ ma re ye̱ ro̱ à, Wà-wu̱ u̱n ne̱t wu̱a no̱me̱ ye̱ kaane̱ u̱n co-o̱ u̱n Shir u̱n yan-to̱m-ye̱ u̱n wu̱ ne̱. ");
INSERT INTO uth_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Amba ka ye̱ rwu̱u̱ne̱ cas ye̱ zee ye̱ 'yarag me̱ à, Wà-wu̱ u̱n ne̱t wu̱a 'yer ye̱ u̱n co-o̱ u̱n Shir u̱n yan-to̱m-ye̱ u̱n wu̱ ne̱. ");
INSERT INTO uth_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“Bo̱ u̱n wu̱ zee gom-de u̱t-yage̱ to̱ u̱n Wà-wu̱ u̱n ne̱t, Shir a hoks m-soks ba'as-de u̱n wu̱. Amba ka ye̱ zee ma-to̱ o-yo'og u̱n Ku̱kt-o̱ Shir à, Shir a soks ba'as-de u̱n ye̱ á. ");
INSERT INTO uth_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Da-o̱ ye̱ heetu̱ no̱ u̱n kuke̱-to̱ u̱n yoos u̱n Ma-to̱ Shir remen ye̱ megertu̱ no̱ ko be-de u̱n ya-o-dak u̱n gwo̱mo-ne̱, hur-u̱r no̱ wu̱rge̱ á, u̱n yo no̱ he m-shas á, ko m-ze̱e̱ á. ");
INSERT INTO uth_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Hur u̱n no̱ wu̱rge̱ á, remen Ku̱kt-o Shir u̱n ka da-o̱ o̱a yoosu̱ no̱ go̱ u̱n yo no̱ he m-ze̱e̱ à.” ");
INSERT INTO uth_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Wu̱ ken ne̱t-wu̱ u̱n bu̱u̱g-de u̱n hun-ne̱ ze̱e̱ru̱ Ye̱so, “Wa-u̱r-Yoos, ru̱re̱ se̱k-wu̱ re te̱ wong saw-to̱ tato te̱ yaksu̱ te̱ à.” ");
INSERT INTO uth_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Ye̱so shasu̱ru̱ wu̱, “Wan-yen de, ¿wo̱a ya'u̱ me̱ m-piish u̱t-ma ko u̱m wong no̱ u̱t-saw ne̱n yoor?” ");
INSERT INTO uth_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Wu̱ dooru̱ ye̱ m-ze̱e̱ kap mo̱ u̱n ye̱, “Gwo̱t no̱, no̱ 'er hi u̱n no̱, u̱n ko̱ yo ke co̱w-yo o-su̱u̱b yo. Shir no̱m ho̱o̱g-mo̱ u̱n ne̱t, remen wu̱ mo̱ro̱gsu̱te̱ u̱t-saw á, ko-yan-kwu̱m-o̱ u̱n wu̱.” ");
INSERT INTO uth_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Ka da-de Ye̱so ru̱ru̱ ye̱ ka sha-mo̱ u̱t-ma mo̱: “A no̱mo̱g wu̱ ken ne̱t-wu̱ ko-ya-o-kwu̱m-wu̱ ro̱ o-kat ne̱ à, o̱ no̱mo̱g u̱r-bon. ");
INSERT INTO uth_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Wu̱ taknu̱ru̱ u̱s-ceker u̱n hi u̱n de u̱n wu̱, ‘Me̱tt be-de u̱n e̱s u̱n hyo re á. ¿Re ne̱ o̱ ka u̱m he m-no̱m? ");
INSERT INTO uth_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Yo u̱m he m-no̱m à yo ka: Man bu̱'u̱g byo-u̱t re u̱m meet u̱t-caari, be-de u̱m he rwo̱ u̱n hyo re u̱n to̱ ken saw-to̱ o-kat to̱ ne̱ à. ");
INSERT INTO uth_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Ka da-de man zee hi u̱n de, o re̱e̱g u̱r-ho̱! O kumug kap rii-yo u̱r-bon yo o co̱ne̱ à, har hak-se no̱mo̱t de̱e̱n. Dek m-ho̱o̱g ce̱e̱n, re̱ o su̱, o ho̱ge̱ re̱re̱m-m ru.’ ");
INSERT INTO uth_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","“Amba Shir ze̱e̱ru̱ wu̱, ‘Wo̱ ko-raag! U̱n ka te̱t-mo̱ u̱m co̱no̱g ho̱o̱g-m ru, ¿wa u̱n wu̱ ne̱ he m-de̱k kap ka saw-to̱ o mo̱ro̱gse̱ hi u̱n du à?’ ” ");
INSERT INTO uth_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Ye̱so bu̱su̱ru̱ m-ze̱e̱, “Kaane̱ to̱ ro̱ u̱n ye̱ mo̱ro̱gse̱ u̱t-saw remen hi u̱n de u̱n ye̱ à, amba yan-rii ye̱ á be-de Shir remen ye̱ no̱m rii-yo Shir co̱ne̱ á.” ");
INSERT INTO uth_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Ka da-de Ye̱so ze̱e̱ru̱ yan-neke̱-mo̱ u̱n wu̱, “U̱n kaane̱, me̱ no̱ m-ru̱re̱, no̱ naas u̱t-me̱n remen rii-yo m-re̱ yo no̱ co̱ne̱ no̱ kumut ho̱o̱g, ko gund-to̱ m-co̱p o-wu̱r á. ");
INSERT INTO uth_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Ho̱o̱g-m jiishte̱ rii-yo m-re̱, komo wu̱r-o aragte̱ u̱r-matuku. ");
INSERT INTO uth_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Gwo̱t no̱ ye̱ge̱-kanwo, ye̱ m-go̱ á, ye̱ ne̱ m-ce á, ye̱ ro̱tt u̱t-byo á. Shir ro̱ ye̱ m-re̱e̱gte̱! No̱ aragte̱ kawon de̱e̱n! ");
INSERT INTO uth_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Yatt-wu̱ he hoks u̱n dowe̱ hi u̱n de u̱n wu̱ o-da hiin remen rii-yo suwe̱ wu̱ à. ");
INSERT INTO uth_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Ko no̱ suwe̱ hi u̱n no̱ mo̱a gu no̱ rii ko̱ hiin be-de u̱n rii-yo jiishe̱ yo no̱ co̱ne̱ á u̱ntu̱n u̱t-ga u̱n saw-to̱ m-co̱p ne̱. ");
INSERT INTO uth_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Gwo̱t no̱ bo̱ u̱t-darag u̱t-mo̱k ne̱ ro̱ u̱n m-bo̱'o̱se̱ o-ko̱t à. To̱ ro̱ m-gwo̱w á, ko to̱ ce'e̱ hi u̱n de u̱n to̱ u̱t-matuku. Amba me̱ no̱ m-ru̱re̱, ko ko-Gwo̱mo Suremanu kap u̱n kwu̱m-o̱ u̱n wu̱ ne̱, wu̱ co̱p saw-to̱ u̱r-bon u̱ntu̱n o-gaan yo u̱n ka mo̱k-to̱ u̱t-darag to̱ á. ");
INSERT INTO uth_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","U̱rege̱ Shir ro̱ m-tu̱pe̱ u̱n gwo̱-se o-ko̱t u̱t-matuku gwo̱-se ro̱ caane̱ à, m-buk se̱ ro̱ ko̱n á, se̱ tu̱kse̱. No̱ aragte̱ se̱, ¿remen yan o̱ wu̱ hette̱ no̱ m-we̱n u̱n rii-yo m-co̱pe? No̱ she̱r be-de Shir de̱e̱n á! ");
INSERT INTO uth_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","“No̱ zo̱'o̱re̱ u̱n rii-yo no̱ he m-re̱ m-swo̱ ne̱ á. ");
INSERT INTO uth_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","(Ye̱ ye̱ nape̱ Shir á, ho̱no o-dak ro̱ m-rangse̱ u̱n hi u̱n de u̱n ye̱ remen ka saw-to̱.) Tato no̱ nepse̱ no̱ co̱no̱g ka saw-to̱ remen no̱ kumut ho̱o̱g. ");
INSERT INTO uth_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Hoob no̱ gwo̱mo-to̱ u̱n Shir, komo wu̱a kumu no̱ ka saw-to̱. ");
INSERT INTO uth_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“No̱ ho̱ge̱ o-gye̱r á, no̱ kur-de u̱n ca re, amba myet u̱n kaane̱ ne̱ no̱ ho̱ge̱ o-gye̱r á. Tato no̱ ro̱ o-zak, wu̱ ye'et no̱ gwo̱mo-to̱ u̱n wu̱. ");
INSERT INTO uth_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Baab no̱ kap yo no̱ ro̱tte̱ à, no̱ ya'as ko̱o̱b-ne̱ hwo̱r u̱n ka co̱w-yo no̱a kum o-kwu̱m n-To̱n be-de Shir. Nomo no̱ hi u̱n no̱ be-de u̱r-e̱ss de ba m-ta, komo no̱ e̱s kwu̱m-o̱ no̱ n-to̱n, be-de o̱a heeb á, remen yatt ko-hyow-wu̱ he m-ci á, komo re̱n a hoks o̱ m-naas á. ");
INSERT INTO uth_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Remen be-de kwu̱m-o ru ro̱ à, káne̱ hur u̱n du ro̱. ");
INSERT INTO uth_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“She'et no̱ zo̱ngse̱ remen rii-yo he m-haan à zo̱ngse̱ remen no̱ nomot, ");
INSERT INTO uth_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","u̱ntu̱n gu̱w-ne̱ ye̱ ro̱ 'er-de u̱n wan-hur-o̱ u̱n ye̱ wu̱ mu̱u̱nte̱ be-de u̱n biki-o̱ u̱t-ge à. Da-o̱ wu̱ mu̱u̱ne̱ wu̱ ko̱'o̱te̱ ish, ye̱a tikshe̱ wu̱ ish ho̱r-m-ho̱r. ");
INSERT INTO uth_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Ya-o-zak-ye̱ ka gu̱w-ne̱ ye̱ wan-hur-o̱ u̱n ye̱ 'wo̱sse̱ ye̱ ro̱ u̱r-'er ba m-rew, ye̱ ro̱ zo̱ngse̱ da-o̱ wu̱ mu̱u̱ne̱ à! Nip-o̱ me̱ no̱ m-ru̱re̱, wu̱a pos matuku-de u̱t-ge, wu̱a zee ye̱ she'et tara, wu̱ hantu̱ ye̱ u̱t-ga. ");
INSERT INTO uth_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Ya-o-zak-ye̱ u̱rege̱ wu̱ 'wo̱ste̱ ye̱ zo̱ngse̱, komo da-o pu̱rge̱ wu̱ he m-mu̱u̱n ko̱ arge̱ káne̱! ");
INSERT INTO uth_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Komo no̱ nep u̱rege̱ wa-o-hur nepse̱ da-o̱ ko-hyow he m-haan à wu̱a yage̱ ko-hyow-wu̱ co̱wo̱nte̱ n-me̱ o-hur á. ");
INSERT INTO uth_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Komo no̱ ma'as zo̱ngse̱, remen Wà-wu̱ u̱n ne̱t a haan da-o̱ no̱ hwo̱ wu̱a haan á.” ");
INSERT INTO uth_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Bitrus ze̱e̱ru̱, “Go̱s-wu̱, ¿ka sha-mo̱ u̱t-ma mo̱ rem te̱ o̱, ko de remen ko̱ wu̱ ke?” ");
INSERT INTO uth_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Go̱s-wu̱ shasu̱ru̱, “¿Wa ne̱ ro̱, ko-gu̱w wa-m-go̱ks kom-u̱t yoor u̱s-we̱e̱r ne̱? Wu̱ ro̱ wu̱ wan-hur-o̱ u̱n wu̱ rwo̱'e̱ gu̱t-de o-hur à, komo wu̱ ya'ag ye̱ ka gu̱w-ne̱ ye̱ rii-yo m-re̱ yo u̱n ye̱ da-o̱ depe̱ à. ");
INSERT INTO uth_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Da-o̱ wa-o-hur mu̱u̱ne̱, wu̱ 'o̱sse̱ ka ko-gu̱w-wu̱ ro̱ m-no̱m kaane̱, zak-o a ho̱ ka ko-gu̱w-wu̱! ");
INSERT INTO uth_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Kááne̱ me̱ no̱ m-ru̱re̱, wan-hur-o̱ u̱n wu̱ a ru̱ wu̱ gwo̱t u̱n saw-to̱ u̱n wu̱ kap. ");
INSERT INTO uth_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Amba u̱rege̱ ka ko-gu̱w-wu̱ ze̱e̱g hi u̱n de u̱n wu̱, wan-hur-o̱ u̱n wu̱a she'et u̱n de de̱e̱n. Komo u̱rege̱ wu̱ takante̱ bu u̱n o̱r u̱n wu̱ gu̱w-ne̱, kap campo̱-ne̱ u̱n ne'a-ne̱ ne̱, komo wu̱ rees, wu̱ su̱u̱s har mo̱ ho wu̱, ");
INSERT INTO uth_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","da-o̱ wan-hur-o̱ u̱n wu̱ mu̱u̱ne̱ de ken ho̱-de da-o̱ ka ko-gu̱w-wu̱ rwo̱ ye̱ o-da á, komo ba wu̱ u̱n nap. Wan-hur-o̱ u̱n wu̱ a re̱e̱se̱ wu̱ u̱r-ko̱o̱b de̱e̱n, mo̱sse̱ u̱n ka ye̱ yage̱ dor Ye̱so à. ");
INSERT INTO uth_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Ko-gu̱w-wu̱ nepse̱ rii-yo wan-hur-o̱ u̱n wu̱ co̱ne̱ wu̱ no̱m à, amba wu̱ zo̱nge̱ wu̱ nomot yo á, wu̱a su̱ u̱r-ko̱o̱b u̱n caari-se u̱s-so̱ro̱g ne̱. ");
INSERT INTO uth_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Amba ko-gu̱w-wu̱ nape̱ rii-yo wan-hur-o̱ u̱n wu̱ co̱ne̱ á, kap u̱n kaane̱ ne̱ wu̱ no̱mo̱g rii-yo wo̱, a bu'ut wu̱ à, a bu wu̱ amba de̱e̱n á. Shir co̱no̱g de̱e̱n be-de u̱n wu̱ Shir ya'ase̱ de̱e̱n à. Shir co̱no̱g timb komo be-de u̱n wu̱ Shir ya'ase̱ timb à. ");
INSERT INTO uth_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Me̱ u̱n haan remen u̱m ja'asu̱té̱ Shir o-co̱w, yo wu̱ hette̱ m-re̱e̱se̱ u̱n ya-u̱r-ba'as u̱r-ko̱o̱b à. Komo u̱m co̱no̱g ma a zee, wu̱ ciriste̱ piish u̱n ma-to̱ u̱n ye̱ u̱n re̱e̱se̱ u̱n ye̱ u̱r-ko̱o̱b ne̱. ");
INSERT INTO uth_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Amba u̱r-takan, se̱ u̱m swo̱o̱g u̱r-ko̱o̱b har m-mar. U̱m ru̱'u̱sse̱ u̱r-hi se u̱m ko̱mo̱g. ");
INSERT INTO uth_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","¿Ze̱e̱-m no̱ me̱ u̱n haan o̱ remen dak-o̱ nomot gwu̱gwu̱? Ay, ba gwu̱gwu̱ á, amba m-wonge̱. ");
INSERT INTO uth_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Takan-mo̱ m-mo̱ka hur-o̱ u̱n hun-ne̱ ne̱n taan o̱a wonge̱, tet u̱s-ryaab, u̱n yoor ne̱ komo yoor u̱s-ryaab, u̱n tet ne̱. ");
INSERT INTO uth_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Tat-ne̱ u̱s-ryaab u̱n yakar-ne̱, komo yakar u̱s-ryaab u̱n tato u̱n ye̱ ne̱. In-ne̱ u̱s-ryaab u̱n yakar-ye̱ u̱n ye̱ ne̱ yan-ne'a-ne̱, komo yakar yan-ne'a-ne̱ u̱s-ryaab u̱n in-ne̱ u̱n ye̱ ne̱. Inu u̱n wà u̱s-ryaab u̱n ne'a-wu̱ u̱n wà ne̱, ne'a-wu̱ u̱n wà u̱s-ryaab u̱n inu u̱n campo̱ u̱n wu̱ ne̱.” ");
INSERT INTO uth_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Ye̱so ze̱e̱ru̱ hun-ne̱, “Da-o̱ no̱ hyene̱ ke'ente̱-o ro̱ m-rwu̱u̱n so̱ u̱r-ho̱ran, no̱ m-ze̱e̱ kem a he, komo o̱ ro̱ m-he̱. ");
INSERT INTO uth_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Komo da-o̱ no̱ hyene̱ yo-mo̱ m-rwu̱u̱n so̱ u̱r-ho̱rim, no̱ m-ze̱e̱ hund a no̱m, komo o̱ ro̱ m-no̱m. ");
INSERT INTO uth_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Ya-o-she̱pe̱! No̱ m-hoks u̱n gwo̱t o-dak u̱n to̱n-o shir ne̱, komo no̱ ru̱r rii-yo he m-no̱m à. Amba no̱ hoks m-nap u̱n rii-yo me̱ m-no̱m á, remen no̱ ze̱e̱g no̱ nak Shir amba o-nip no̱ nap wu̱ á. ");
INSERT INTO uth_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“¿Remen yan o̱ no̱ ro̱tte̱ a piishe̱ hi u̱n no̱ rii-yo u̱r-bon yo no̱ he m-no̱m á? ");
INSERT INTO uth_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","U̱rege̱ ye̱ ken ye̱ he'ette̱ wo̱ be-de u̱n ko-Gwo̱mo, se̱nge̱ no̱ hongse̱ ka ma-to̱ u̱n ye̱ ne̱ ba no̱ u̱n wo̱ be-de u̱n ko-Gwo̱mo. U̱rege̱ no̱ no̱m káane̱ á, ye̱a nek wo̱ har be-de u̱n ko-Gwo̱mo, wu̱a bo̱pse̱ yan-saw-to̱ u̱t-gwo̱mo wo̱, komo ye̱a ke wo̱. ");
INSERT INTO uth_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Wo̱a she'et káne̱, me̱ no̱ m-ru̱re̱ se̱ o ko̱mo̱g m-to̱p u̱n rii-yo ye̱ re̱ wo̱ à.” ");
INSERT INTO uth_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","U̱n ka da-o̱ ye̱ ken hun-ne̱ ye̱ ro̱ káne̱, ye̱ ru̱ru̱ Ye̱so ma-to̱ ya-o-Gariri-ye̱ Panti Biratus ho'e̱ da-o̱ ye̱ haante̱ Shir u̱t-seke̱ à. ");
INSERT INTO uth_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Ye̱so shasu̱ru̱ ye̱, “¿Remen Panti Biratus ho̱o̱g ka ya-o-Gariri-ye̱ kaane̱, no̱ u̱n ze̱e̱ o̱ ye̱ jiishte̱ ye̱ ken ya-o-Gariri-ye̱ no̱m u̱r-ba'as se? ");
INSERT INTO uth_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Ayyo̱, ko̱ hiin! Komo me̱ no̱ m-ru̱re̱, 'yar no̱ u̱r-ba'as, no̱ mu̱u̱n be-de Shir m-ba kaane̱ á no̱a mer bo̱ ye̱ mare̱ à. ");
INSERT INTO uth_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Baks no̱ ya-o-Sirom o̱p u̱n eer 18 ye̱ kuke̱-o m-pipir ho̱me̱ à. ¿No̱ u̱n ze̱e̱ ba'as-de u̱n ye̱ jiishte̱ de u̱n ye̱ ken u̱n hun-ne̱ ye̱ o-Urusharima à? ");
INSERT INTO uth_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Ayyo̱, ko̱ hiin! Komo me̱ no̱ m-ru̱re̱, 'yar no̱ u̱r-ba'as, no̱ mu̱u̱n be-de Shir u̱n ba kaane̱ á no̱a mer bo̱ ye̱ mare̱ à.” ");
INSERT INTO uth_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Ye̱so ru̱ru̱ ye̱ ka sha-mo̱ u̱t-ma mo̱: “Wu̱ ken ne̱t-wu̱ ro o-rum ne̱ u̱n kat-o̱ u̱n wu̱. Wu̱ haaru̱ hoob-o̱ u̱t-rum be-de u̱n yo, amba wu̱ kum ko̱ u̱r-gaan á. ");
INSERT INTO uth_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Wu̱ ze̱e̱ru̱ wan-gu̱t-de o-kat, ‘Gwo̱t, hak-u̱s tet me̱ m-haan kane̱ hoob-o̱ u̱t-rum be-de u̱n ka rum-yo, komo me̱ kum ko u̱r-gaan á. Kups yo u̱r-'wu̱n! ¿Remen yan o̱ yo hette̱ m-ho̱ge̱ re̱re̱m-mo̱ o-dak?’ ");
INSERT INTO uth_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Amba wan-gu̱t-de o-kat shasu̱ru̱, ‘Go̱s-wu̱, yage̱ yo temb, hak-o gaan a gu̱t, man hiin riib-se u̱n yo, u̱m ru̱'e̱ yo u̱t-wu̱u̱r. ");
INSERT INTO uth_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","U̱rege̱ yo makt hak-ye̱ ro̱o̱ne̱ à, no̱mo̱g u̱r-bon de̱e̱n, u̱rege̱ ne̱ yo mat á, ka da-o̱ wo̱a hoks yo m-kups.’ ” ");
INSERT INTO uth_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Ho̱-de u̱r-Wu̱we̱, Ye̱so ro u̱r-yoos u̱n kuke̱-o̱ u̱n yoos u̱n Ma-to̱ Shir. ");
INSERT INTO uth_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Wu̱ ken ne'a-wu̱ ro kane̱ u̱n wa-u̱t-ko̱t ne̱, wu̱ re̱e̱se̱ wu̱ u̱r-ko̱o̱b à. Har hak-u̱s o̱p u̱s-eer 18 wu̱ ro̱ haw-se, wu̱ m-hoks m-ine̱ te̱te̱ á. ");
INSERT INTO uth_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Bo̱ Ye̱so hyente̱ wu̱ à, wu̱ agnu̱ru̱ wu̱, “Ne'a, go̱m ru ho'oste̱ wo̱!” ");
INSERT INTO uth_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Ye̱so saku̱ru̱ kom-to̱ u̱n wu̱ n-to̱n u̱n ka ne'a-wu̱, wu̱ inu̱ru̱ te̱te̱, wu̱ bo̱mu̱ru̱ Shir. ");
INSERT INTO uth_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Wu̱ ken wan-co-wu̱ u̱n kuke̱-o̱ u̱n yoos u̱n Ma-to̱ Shir, no̱mu̱ru̱ u̱s-ryaab u̱nze Ye̱so taaste̱ go̱m Ho̱-de u̱r-Wu̱we̱. Wu̱ no̱mu̱ru̱ u̱t-ma wu̱ ze̱e̱ru̱ hun-ne̱, “Ho̱-u̱t cind-to̱ ro̱ to̱ m-se̱nge̱, haan no̱ u̱n ka ho̱-u̱t cind-to̱ a taaste̱ go̱m-u̱s no̱, ba Ho̱-de u̱r-Wu̱we̱ á!” ");
INSERT INTO uth_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Go̱s-wu̱ shasu̱ru̱ wu̱, “No̱ ya-o-she̱pe̱! Ko̱ wu̱ ke a mo̱ro̱gse̱ na-ye̱ u̱n wu̱, ko̱ janka-ye̱ u̱n wu̱, komo wu̱ ruut ye̱ n-do̱ wu̱ ye'et ye̱ m-ho̱ Ho̱-de u̱r-Wu̱we̱. ");
INSERT INTO uth_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","M-mo̱ka kane̱ ba'as-de á, a taase go̱m-o̱ u̱n ka ne'a-wu̱ Ho̱-de u̱r-Wu̱we̱. Ko-yan-baag-o Ibrahi wu̱, komo ko-Gwo̱mo-wu̱ u̱n ya-u̱t-ko̱t ru̱'u̱te̱ wu̱ go̱m har hak-u̱s o̱p u̱s-eer 18. Komo wu̱ jiishte̱ u̱t-gu̱t be-de Shir.” ");
INSERT INTO uth_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Shas-o̱ u̱n wu̱ ya'ag yan-yage̱-to̱ u̱n wu̱ m-'e̱, amba hun-ne̱ ye̱ ro káne̱ à no̱mu̱ru̱ o-zak remen ka hyat-to̱ wu̱ no̱me̱ à. ");
INSERT INTO uth_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Ye̱so citu̱ru̱, “¿Re ne̱ gwo̱mo-to̱ Shir ro̱? ¿U̱n ya ne̱ u̱m he to̱ m-hongse̱? ");
INSERT INTO uth_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Kaane̱ to̱ ro̱. Wu̱ ken ne̱t-wu̱ de̱k go̱-yo mosta wu̱ go̱o̱ru̱ u̱n kat-o̱ u̱n wu̱. Yo po̱tu̱ru̱ yo wargu̱ru̱ o-'yo, komo ye̱ge̱-no ce̱e̱ru̱ u̱t-kur u̱n jet-se u̱n yo.” ");
INSERT INTO uth_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Ye̱so citu̱ru̱ komo, “¿U̱n ya ne̱ u̱m he m-hongse̱ u̱n gwo̱mo-to̱ Shir? ");
INSERT INTO uth_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Kaane̱ to̱ ro̱. Ne'a de̱k m-yist wu̱ wu̱gsu̱ru̱ mo̱ be-de u̱n me'es kwo̱o̱z-u̱t yoor 40 to̱ m-hyò se̱ da-o̱ mo̱ ku̱tu̱kse̱ kap à.” ");
INSERT INTO uth_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Ye̱so do̱ru̱ru̱ u̱t-bo̱ u̱n riib-o̱ u̱t-bo̱ ne̱, wu̱ ro̱ m-yoose̱ u̱n hun-ne̱, wu̱ ro̱ m-sho̱gbe̱ de o-Urusharima. ");
INSERT INTO uth_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Wu̱ ken wu̱ citu̱ru̱ wu̱, “Go̱s-wu̱, ¿hun-ne̱ hiin o̱ Shir he m-gu?” Ye̱so shasu̱ru̱ ye̱, ");
INSERT INTO uth_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“No̱m no̱ m-se̱nge̱ no̱ cu̱w ya o-ish o-re̱k yo, remen hun-ne̱ de̱e̱n a se̱nge̱ ye̱ cu̱wu̱t amba ye̱a hoks á. ");
INSERT INTO uth_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Wa-o-hur a ine̱ wu̱ tigu̱te̱ ish, ka da-de no̱ es n-do̱ u̱n ko̱'o̱t u̱n ish no̱ m-ze̱e̱, ‘teksu̱ te̱ ish.’ Wu̱a shes no̱, ‘Me̱ nap no̱ á!’ ");
INSERT INTO uth_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Ka da-de no̱ shes, ‘Te̱ re̱e̱g, te̱ su̱ u̱n wo̱ ne̱, o yooste̱ u̱n bo̱-o te̱!’ ");
INSERT INTO uth_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Amba wu̱a zee komo, ‘Me̱ nap no̱ á. Ine̱ no̱ be u̱n de. Kap no̱ yan-me̱n-u̱t jaas-to̱!’ ");
INSERT INTO uth_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Kane̱ no̱ he u̱s-kan no̱ ti-m yin da-o̱ no̱ he Ibrahi m-hyan à u̱n Ishaku, Yakubu u̱n kap yan-Rwo̱r u̱n Ma-to̱ Shir ne̱ n-me̱ u̱n gwo̱mo-to̱ Shir, amba Shir a 'ye no̱ ish-o m-co̱w á! ");
INSERT INTO uth_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Hun-ne̱ a haan rwu̱u̱n-mo̱ u̱r-ho̱ran u̱r-ho̱rim ne̱, so̱ o-ye'er u̱n so̱ o-baar ne̱, ye̱a she'et be-de u̱n biki-o̱ u̱n gwo̱mo-to̱ Shir. ");
INSERT INTO uth_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","No̱a hyen, ka ye̱ hun-ne̱ 'yare̱ à, Shir a go̱ks ye̱, komo ka ye̱ hun-ne̱ go̱kse̱ à, Shir a 'yarag ye̱.” ");
INSERT INTO uth_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","U̱n ka da-o̱ hond hond ye̱ ken Parisa-ne̱ ye̱ haanu̱ru̱ be-u̱r Ye̱so, ye̱ ze̱e̱ru̱ wu̱, “O cu̱ne̱, o yage̱, wo̱a ru m-mo̱ka kane̱ o warag de ken be-de, remen Here̱ Atipas co̱no̱g wo̱ m-ho̱.” ");
INSERT INTO uth_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Ye̱so shasu̱ru̱ ye̱, “Ha no̱ ru̱re̱ Here̱ ká wo̱-yo o-tuk-yo, ‘Me̱ u̱n yan-se u̱n ya-u̱t-ko̱t komo me̱ u̱n ta'as u̱s-go̱m caane̱ u̱n buk ne̱, ho̱-u̱r atette̱-de man kom se̱nge̱-m re.’ ");
INSERT INTO uth_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Kap u̱n kaane̱ ne̱, man bu̱p o-co̱w caane̱, m-buk, n-yisho̱ ne̱, u̱n no̱m u̱r-bon hun-ne̱ ho wan-rwo̱r u̱n Ma-to̱ Shir de ken be-de á se̱ o-Urusharima. ");
INSERT INTO uth_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“Ya-o-Urusharima, ya-o-Urusharima! O ho̱o̱g yan-Rwo̱r u̱n Ma-to̱ Shir, o ho̱o̱g ye̱ Shir to̱mnu̱ wo̱ à! So̱o̱ re o̱ u̱m ro co̱nge̱ sak u̱n kom-u̱t re n-to̱n u̱n hun-ne̱ ru, bo̱ kiit-o ro̱ m-ho̱k u̱n yakar-ye̱ u̱n yo u̱n ku̱ku̱n-to̱ u̱n yo à, amba no̱ yagu̱ me̱ m-nomot á. ");
INSERT INTO uth_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Remen kaane̱ Shir a 'yer pyo-o u̱n ko̱n-se u̱n Shir ru. Me̱ no̱ m-ru̱re̱, no̱a hyen me̱ á, se̱ da-o wo̱o̱nte̱ o̱ no̱ hette̱ m-ze̱e̱, ‘Shir hu̱u̱ wu̱ u̱t-kom, wu̱ haane̱ u̱n be̱e̱b-u̱r Yawe à.’ ” ");
INSERT INTO uth_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","De ken Ho̱-de u̱r-Wu̱we̱ de, Ye̱so haag wu̱ reet rii-yo m-re̱ u̱n hur-o u̱n wu̱ ken caari-wu̱ wu̱ u̱n Parisa-ne̱, hun-ne̱ ro̱ Ye̱so m-gwo̱t me̱kse̱. ");
INSERT INTO uth_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Wu̱ ken ne̱t-wu̱, wu̱ na-se u̱n wu̱, u̱t-kom ne̱ ro huse̱ à, haanu̱ru̱ be-u̱r Ye̱so. ");
INSERT INTO uth_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Ye̱so citu̱ru̱ yan-Napse̱ o-karamsa u̱n Parisa-ne̱ ne̱, “¿Karamsa-o na ze̱e̱g a taas go̱m Ho̱-de u̱r-Wu̱we̱ ko̱ o̱ ze̱e̱ á?” ");
INSERT INTO uth_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Amba ye̱ ze̱e̱ rii á. Ye̱so deku̱ru̱ ka ne̱t-wu̱, wu̱ taasu̱ru̱ go̱m-o u̱n wu̱, komo Ye̱so ze̱e̱ru̱ wu̱ arag. ");
INSERT INTO uth_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Ka da-de wu̱ ze̱e̱ru̱ ye̱, “U̱rege̱ u̱n be-u̱r no̱, wà, ko̱ o-na yo u̱n wan-gaan he̱bu̱te̱ u̱r-dù Ho̱-de u̱r-Wu̱we̱, ¿no̱a hu̱ssu̱ne̱ yo u̱n Ho̱-de u̱r-Wu̱we̱ ba u̱n naas o-da á?” ");
INSERT INTO uth_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Amba ye̱ hoks wu̱ m-shas u̱n ka cot-o̱ á. ");
INSERT INTO uth_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Ye̱so we̱re̱g bo̱ ye̱ ken hamat-ne̱ ye̱ ro̱ m-daag u̱n be-to̱ jiishe̱ u̱r-bon à, wu̱ ru̱ru̱ ye̱ ka sha-mo̱ u̱t-ma mo̱: ");
INSERT INTO uth_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Wu̱ ken wu̱ bene̱ no̱ gwo̱nge̱-o̱ u̱t-ge, no̱ she'et u̱n be-to̱ jiishe̱ u̱r-bon á. A nom a banag wu̱ jiishe̱ no̱ u̱t-go̱s à. ");
INSERT INTO uth_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Komo wa-u̱r-ben, wu̱ banu̱ no̱ à, wu̱a haan wu̱ zee wo̱, ‘Ine̱, o 'ye wu̱ ka ká be-de.’ Ka da-de wo̱a ho̱ge̱ m-'e̱ komo o warag m-she'et u̱n de ken be-de n-dak. ");
INSERT INTO uth_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Amba a bene̱ no̱, ha no̱, no̱ she'et pakse̱, remen wu̱ banu̱ no̱ à wu̱a haan be u̱n du wu̱ zee, ‘Daan n-to̱n nay yo, u̱n be-de jiishe̱ à.’ Wo̱a re̱ u̱r-ho̱ u̱n hyan-o̱ ye̱ a bane̱ à. ");
INSERT INTO uth_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Remen kaane̱, co̱w-o o-gaan yo u̱n wu̱ deete̱ hi u̱n de u̱n wu̱ n-to̱n ne̱ à, Shir a kergu̱nte̱ wu̱ n-dak. Komo wu̱ e̱sse̱ hi u̱n de u̱n wu̱ n-dak à, Shir a deet wu̱ n-to̱n.” ");
INSERT INTO uth_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Ka da-de, Ye̱so ze̱e̱ru̱ wa-o-biki, “Wo̱ band nay ru á, komo wo̱ band hen-ne̱ ru á ko̱ baag-o ru á, komo wo̱ band ya-o-kwu̱m ko̱ yan-bo̱r-se u̱n hur-o ru á, remen ye̱a topo wo̱ yo o nome̱ ye̱ à. ");
INSERT INTO uth_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Amba da-o̱ wo̱ ine̱ o-biki, ban ko̱o̱b-ne̱, u̱n ryam-ne̱ ne̱ u̱n po̱-ne̱ ne̱. ");
INSERT INTO uth_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Komo Shir a hu̱u̱ wo̱ u̱t-kom, remen ye̱a hoks wo̱ m-tope̱ á. Shir a hu̱u̱ wo̱ be-de u̱n hun-ne̱ kashi-ye̱ mare̱ à, ho̱-de ye̱ he m-ine̱ à.” ");
INSERT INTO uth_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Bo̱ wan-gaan be-de u̱n ka hun-ne̱ ye̱ ro̱ tara, remen ye̱ reet rii-yo m-re̱ ho̱gu̱te̱ kaane̱ à, wu̱ ze̱e̱ru̱ Ye̱so, “Ya-o-zak-ye̱ ka ye̱ he m-she'et tara be-de u̱n biki-o̱ u̱n gwo̱mo-to̱ Shir à!” ");
INSERT INTO uth_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Ye̱so ze̱e̱ru̱ wu̱, “A no̱mo̱g wu̱ ken ne̱t-wu̱, wu̱ no̱me̱ caari-o̱ o-biki à, o̱ wu̱ bente̱ hun-ne̱ de̱e̱n à. ");
INSERT INTO uth_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Bo̱ da-o̱ o-biki wo̱o̱nte̱ à, wu̱ to̱mu̱ru̱ gu̱w-ne̱ ye̱ u̱n wu̱, ye̱ ru̱re̱ hamat-ne̱ ye̱ u̱n wu̱, ‘Rwu̱u̱n no̱, ko̱ wu̱ ke zo̱ngsu̱te̱!’ ");
INSERT INTO uth_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Amba ye̱ taknu̱ru̱ hoob-o u̱s-cow kap, gaan u̱n gaan. Wu̱ takne̱ à ze̱e̱ru̱ ko-gu̱w, ‘U̱m o̱o̱g o-kat, komo u̱m co̱no̱g m-ha u̱m gwo̱to̱n o̱, hakku̱re̱ ze̱e̱ wu̱ ho̱ge̱ ko̱n-u̱s re!’ ");
INSERT INTO uth_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Wu̱ ken wu̱ ze̱e̱ru̱, ‘U̱m o̱o̱g na o̱p ye̱ u̱t-kerem, u̱m co̱no̱g m-ha u̱m megerte̱ ye̱, hakku̱re̱ ze̱e̱ wu̱ ho̱ge̱ ko̱n-u̱s re.’ ");
INSERT INTO uth_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Wu̱ ken wu̱ ze̱e̱ru̱, ‘U̱m ko̱mo̱g o̱ ka biki-o̱ u̱t-ge, remen kaane̱ man hoks m-habe̱ á.’ ");
INSERT INTO uth_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Ka ko-gu̱w-wu̱ wargu̱ru̱ wu̱ ru̱ru̱ wan-hur-o̱ u̱n wu̱. Wan-hur-o̱ u̱n wu̱ swo̱o̱ru̱ u̱s-ryaab. Wu̱ ze̱e̱ru̱ ko-gu̱w, ‘M-mo̱ka ru, o do̱re̱ u̱s-co̱w u̱s-bu̱ ne̱ se o-bo̱, o band ko̱o̱b-ne̱, ryam-ne̱, u̱n po̱-ne̱ ne̱.’ ");
INSERT INTO uth_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Bo̱ jimu̱te̱ à, ko-gu̱w ze̱e̱ru̱, ‘Go̱s-wu̱, u̱m ho̱gu̱te̱ ma-u̱t ru, u̱m no̱mo̱g komo bo̱ o zee à, amba be-u̱r kusse̱ remen ye̱ ken ye̱.’ ");
INSERT INTO uth_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Wa-o-hur ze̱e̱ru̱ ko-gu̱w, ‘Ru u̱n co̱w-se o-bo̱, u̱s-bu̱ ne̱, o ze̱e̱ hun-ne̱ co̱wo̱n n-me̱ remen hur-o re shiit.’ ");
INSERT INTO uth_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Me̱ no̱ m-ru̱re̱ ko-wan-gaan be-de u̱n ye̱ u̱m ro bange̱ à, wu̱a rek rii-yo m-re̱ yo m-no̱me̱ á.” ");
INSERT INTO uth_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","De ken ho̱-de bo̱ bu̱u̱g-de u̱n hun-ne̱ de̱e̱n ro u̱n do̱re̱ u̱n Ye̱so à, wu̱ waktu̱ru̱ wu̱ ze̱e̱ru̱ ye̱, ");
INSERT INTO uth_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Yatt-wu̱ he warag wan-neke̱-m re ye̱ á, se wu̱ co̱no̱g me̱ arge̱ tato u̱n wu̱, u̱n inu u̱n wu̱ ne̱, ne'a u̱n wu̱, u̱n yakar ne̱, hen-ne̱ u̱n se̱k-ye̱ ne̱, u̱n ho̱o̱g-mo̱ u̱n wu̱ ne̱ komo. ");
INSERT INTO uth_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Ka ye̱ 'yare̱ de̱k u̱n kan-o̱ u̱n ye̱, ye̱ do̱nd me̱ á, yan-neke̱-m re ye̱ á. ");
INSERT INTO uth_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“U̱rege̱ wu̱ ken wu̱ be-u̱r no̱ co̱no̱g u̱t-mà, wu̱ she'et tara wu̱ neps yo wu̱ he m-ho̱ be-de u̱n ka mà-to̱ à, wu̱ gu̱t u̱rege̱ wu̱ ro̱ u̱n hwo̱r ne̱ ye̱ wu̱ hette̱ kom u̱n ka mà-to̱ à. ");
INSERT INTO uth_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","U̱rege̱ wu̱ ro̱tt á, wu̱a hoks ko̱m u̱n ka mà-to̱, to̱ wu̱ takne̱ á, komo kap bo̱n ye̱ hyane̱ bo̱ wu̱ takne̱ à ye̱a nemes wu̱. ");
INSERT INTO uth_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Ye̱a zee, ‘Wu̱ ka ne̱t-wu̱ takante̱ u̱t-mà amba wu̱ hoks m-ko̱m á!’ ");
INSERT INTO uth_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“U̱rege̱ ko-gwo̱mo ruug u̱n hun-ne̱ ne̱ dugu-u̱s o̱p 10,000, ye̱ dumut u̱n wu̱ ken ko-gwo̱mo-wu̱ ne̱, wu̱ heene̱ wu̱ m-dum à u̱n hun-ne̱ ne̱ dugu u̱r-kwo̱o̱z, 20,000 wu̱a she'et u̱r-takan wu̱ ceker, u̱rege̱ wu̱ ro̱ m-'wo̱ns ne̱ wu̱ dumut u̱n wu̱ ka ko-gwo̱mo-wu̱ ne̱. ");
INSERT INTO uth_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","U̱rege̱ wu̱ ro̱tt á, wu̱a tom yan-to̱m-ye̱ u̱n wu̱ be-de u̱n wu̱ ka ko-gwo̱mo-wu̱, wu̱ ko̱n wu̱ ye̱ she'et ba u̱t-ween cin ba ye̱ u̱n 'gone̱. ");
INSERT INTO uth_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","U̱n ka bu̱-yo o-gaan, ko̱ wan-gaan be-u̱r no̱ wu̱a hoks me̱ m-do̱re̱ á, se̱ wu̱ ya'aste̱ kap bo̱ u̱n rii-yo wu̱ ro̱tte̱ à.” ");
INSERT INTO uth_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Po̱r-mo̱ u̱r-bon ne̱, amba u̱rege̱ re̱re̱m-mo̱ u̱n mo̱ teeste̱, co̱w ro̱ ko̱n, yo a hette̱ mo̱ m-muut m-po̱r komo á. ");
INSERT INTO uth_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Mo̱ kus u̱r-bon ne̱ o-dak á, ko̱ be-de u̱t-wu̱u̱r, a mo̱ m-uks. Ho̱gu̱ no̱, u̱rege̱ no̱ ro̱ u̱t-to̱ ne̱.” ");
INSERT INTO uth_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","De ken ho̱-de yan-go̱ks u̱n tar, u̱n ye̱ ken ya-u̱r-ba'as ne̱, ye̱ haante̱, ye̱ ho̱gu̱té̱ ma-u̱t Ye̱so. ");
INSERT INTO uth_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Parisa-ne̱ u̱n yan-Yoos-de o-karamsa ne̱ taknu̱ru̱ u̱s-cenene, “Ka ne̱t-wu̱ go̱kste̱ ya-u̱r-ba'as, komo wu̱ re u̱n ye̱ ne̱!” ");
INSERT INTO uth_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Kane̱ Ye̱so ru̱ru̱ ye̱ ka sha-mo̱ u̱t-ma mo̱: ");
INSERT INTO uth_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Wu̱ ken wu̱ ro u̱n ca-ne̱ zungu-o gaan, 100 komo gaan-o egu̱ru̱ wu̱. ¿Ya ne̱ wu̱ he m-no̱m? Wu̱a yage̱ ye̱ ka o-zungu ba o-gaan 99 u̱t-re̱, wu̱ heet hoob-o u̱n ka gaan-yo se̱ wu̱ hyante̱ yo. ");
INSERT INTO uth_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Da-o̱ wu̱ hyande̱ yo, wu̱a no̱m o-zak har wu̱ sagbu̱ne̱ yo u̱t-gar, wu̱ jonte̱ yo o-hur. ");
INSERT INTO uth_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Wu̱a de̱ke̱n yo o-hur. Ka da-de wu̱ agan nay-ne̱ u̱n yan-bo̱r-se u̱n hur-o̱ u̱n wu̱ ne̱, wu̱ zee ye̱, ‘Me̱ o-zak ne̱, u̱m hyante̱ ca-yo e̱ge̱ me̱ à. Gu no̱ me̱ o-zak!’ ");
INSERT INTO uth_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Me̱ no̱ m-ru̱re̱, go̱n kaane̱, Shir a no̱m o-zak o̱ jiishe̱ o̱ kàà n-to̱n, remen wan-gaan wa-u̱r-ba'as-wu̱ waktu̱ne̱ be-de Shir à, har zak-o̱ jiishe̱ o̱ u̱n hun-ne̱ o-zungu ba o-gaan à 99, ye̱ ro̱ be-de Shir à. ");
INSERT INTO uth_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Ko̱ komo, ne'a-wu̱ ro u̱n hwo̱r ne̱, ye̱ a no̱me̱ o-kwo̱m à o̱p, gaan-o e̱gu̱ru̱ wu̱. ¿Ya ne̱ wu̱ he m-no̱m? Wu̱a su u̱r-pitirra, wu̱ wishe̱ hur-o̱ u̱n wu̱ kap, wu̱ gu̱t ko̱ de ke ko'so-de se̱ wu̱ hyanag yo. ");
INSERT INTO uth_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Da-o̱ wu̱ hyene̱ yo, wu̱a agan nay u̱n wu̱ ne̱, u̱n yan-bo̱r-se u̱n hur-o̱ u̱n wu̱ ne̱ be-u̱r gaan, wu̱a zee ye̱, ‘Me̱ o-zak ne̱ de̱e̱n, u̱m hyanag ka hwo̱r-yo, yo e̱ge̱ me̱ à. Gu no̱ me̱ o-zak!’ ");
INSERT INTO uth_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Kang-o gaan kane̱, me̱ no̱ m-ru̱re̱, yan-to̱m-ye̱ Shir ro̱ m-no̱m o-zak remen wan-gaan-wu̱ waktu̱ne̱ wu̱ do̱re̱ Shir à.” ");
INSERT INTO uth_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Ye̱so dooru̱ m-ze̱e̱, “Wu̱ ken ne̱t-wu̱ ro̱ u̱n yakar ne̱ yoor, yan-campo̱-ne̱. ");
INSERT INTO uth_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Ka wu̱ ro̱ re̱k-wu̱ à ze̱e̱ru̱ tato u̱n wu̱, ‘Ya'as me̱ yo ro̱ yo ma re à, be-de u̱n saw-u̱t ru m-mo̱ka.’ Ka tato-o wongu̱ru̱ ye̱ saw-to̱ u̱n wu̱ be-u̱t yoor. ");
INSERT INTO uth_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","U̱t-ho̱ hiin, ka wu̱ ro̱ re̱k-wu̱ à babu̱ru̱ saw-to̱ u̱n wu̱ to̱ a wonge̱ ye̱ à. Wu̱ ruuru̱ u̱n hwo̱r ne̱ wu̱ yage̱ o-hur. Wu̱ haaru̱ o̱ ken dak-o̱ u̱r-hew ne̱, kane̱ wu̱ sabu̱rse̱ hwo̱r-ye̱ u̱n wu̱, u̱n she'et-de ba u̱r-bon. ");
INSERT INTO uth_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Wu̱ ho̱o̱ru̱ kap yo wu̱ ro̱tte̱ à. Ka da-o̱ me̱r 'henu̱ru̱ u̱n ka dak-o̱, komo wu̱ ro̱tt rii á. ");
INSERT INTO uth_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Wu̱ haaru̱ u̱r-gu̱wu̱s be-de u̱n wu̱ ken ne̱t-wu̱ u̱n ka dak-o̱. Ka ne̱t-wu̱ heetu̱ru̱ ka wà-wu̱ be-de u̱n ye̱ge̱-are̱de wu̱ ye'et ye̱ rii-yo m-re̱. ");
INSERT INTO uth_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Ka wà-wu̱ co̱nu̱ru̱ wu̱ re wu̱ ciig u̱n ku̱k-to̱ u̱n yoor-to̱ u̱n are̱de, amba yatt-wu̱ ya'e̱ wu̱ rii-yo m-re̱ á. ");
INSERT INTO uth_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","U̱r-ko̱m, wu̱ mu̱u̱nu̱ru̱ u̱n we̱e̱r-se u̱n wu̱ cas cas. Wu̱ ze̱e̱ru̱, ‘Yan-no̱me̱ u̱n tato re m-se̱nge̱, ye̱ ro̱ u̱n rii-yo m-re̱ ne̱ kap, yo ye̱a hoks m-ko̱m á, amba me̱ ka kane̱ u̱n mar-mo̱ u̱n me̱r! ");
INSERT INTO uth_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Man ine̱ m-warag be-u̱r tato re, u̱m zee, “Tato re, u̱m nomote̱ Shir u̱r-ba'as, u̱m nomo wo̱ u̱r-ba'as. ");
INSERT INTO uth_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Me̱ bo'os o do me̱ m-aag wà ru á, de̱k me̱ u̱ntu̱n wan-gaan be-de u̱n gu̱w-ne̱ ru.” ’ ");
INSERT INTO uth_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Wu̱ inu̱ru̱ kane̱ wu̱ bo̱pu̱ru̱ o-co̱w wu̱ ro̱ m-warag be-u̱r tato u̱n wu̱. “Cin wu̱ ro̱ u̱r-hew ne̱ o-hur ne̱, da-o̱ tato u̱n wu̱ hyambe̱ wu̱ à, wu̱ ho̱gu̱ru̱ u̱r-'wo̱n u̱n hur-de u̱n wu̱, komo wu̱ ruuru̱ o-rek, wu̱ hamtu̱ru̱ wà u̱n wu̱, wu̱ patu̱ru̱ wu̱. ");
INSERT INTO uth_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Ka wà-wu̱ ze̱e̱ru̱, ‘Tato re, u̱m nomote̱ Shir u̱r-ba'as, u̱n wo̱ ne̱. Me̱ bo'os o do me̱ m-aag wà ru á!’ ");
INSERT INTO uth_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Amba ka tato-o̱ agnu̱ru̱ gu̱w-ne̱ ye̱ u̱n wu̱. Wu̱ ze̱e̱ru̱, ‘Ho̱r-m-ho̱r! Hantu̱ no̱ gund-to̱ jiishe̱ u̱r-bon à no̱ tu̱pe̱ wu̱. Tu̱pu̱ no̱ wu̱ o-kwo̱t u̱n jow-yo u̱n wu̱, komo no̱ tu̱pe̱ wu̱ u̱t-ka'ante̱ u̱n na-se u̱n wu̱. ");
INSERT INTO uth_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Ka da-de no̱ gu̱t marikki-yo m-se̱m, no̱ pen yo, a nom no̱ biki-o̱ o-zak! ");
INSERT INTO uth_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Remen ka wà re wu̱ ro marag, amba m-mo̱ka wu̱ ro̱ u̱n ho̱o̱g ne̱. Wu̱ ro e̱gu̱te̱, amba m-mo̱ka wu̱ mu̱u̱nte̱.’ Remen kaane̱ komo ye̱ taknu̱ru̱ o-biki. ");
INSERT INTO uth_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“U̱n ka da-o̱ Wà-wu̱ ro se̱k-wu̱ à ro o-kat. Wu̱ ro̱ m-jo'on o-hur, bo̱ wu̱ wo̱o̱nte̱ yow yow o-hur ne̱ à, wu̱ ho̱gu̱ru̱ u̱t-dum u̱s-se̱p ne̱. ");
INSERT INTO uth_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Wu̱ agnu̱ru̱ ko-gu̱w wan-gaan wu̱ citu̱ru̱ wu̱, ‘¿Ya a m-no̱m?’ ");
INSERT INTO uth_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Ka ko-gu̱w-wu̱ shasu̱ru̱ wu̱, ‘Heno ru wu̱ jo'one̱, komo tato ru panag marikki-yo m-se̱m, remen wu̱ mu̱u̱nte̱ o-hur ke̱rke̱r.’ ");
INSERT INTO uth_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","“Ka se̱k-wu̱ wu̱ swo̱o̱ru̱ u̱s-ryaab, wu̱a tu̱w ka hur-o̱ á. Tato u̱n wu̱ rwu̱u̱nu̱ru̱ wu̱ ko̱nu̱ru̱ wu̱, wu̱ co̱wo̱n n-me̱ o-hur. ");
INSERT INTO uth_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Amba wu̱ shasu̱ru̱ tato u̱n wu̱, ‘Gwo̱t, ka hak-se kap, me̱ m-se̱nge̱ u̱ntu̱n ko-gu̱w, komo me̱ nomo wo̱ ko̱o̱b-de o-do̱ro̱tte̱ á. Wo̱ 'ya me̱ ko ya o-gwo̱o̱r u̱m nomot o-biki u̱n nay re ne̱ á. ");
INSERT INTO uth_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Amba ka wà ru wu̱ sabu̱rsu̱te̱ saw-u̱t ru kap be-de u̱n ne'a-ne̱ ye̱ hwaa, komo da-o̱ wu̱ jo'one̱ o-hur à, o panag marikki-yo m-se̱m remen wu̱!’ ");
INSERT INTO uth_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Ka tato-o̱ shasu̱ru̱ wu̱, ‘Wà re, wo̱ kane̱ ko̱ o̱ ke da-o̱ u̱n me̱ ne̱, komo kap yo ma re yo ma ru yo. ");
INSERT INTO uth_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Amba depete̱ a no̱m o-zak o-biki ne̱, remen heno ru ro marag, amba m-mo̱ka wu̱ ro̱ u̱n ho̱o̱g ne̱, wu̱ ro e̱gu̱te̱, amba m-mo̱ka wu̱ mu̱u̱nte̱.’ ” ");
INSERT INTO uth_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Ye̱so ze̱e̱ru̱ yan-neke̱-mo̱ u̱n wu̱, “A no̱mo̱g wu̱ ken ne̱t-wu̱ ko-ya-o-kwu̱m, wu̱ ro̱ u̱n ko-gu̱w ne̱ wan-bebe̱ u̱n wu̱ u̱t-saw. Wu̱ ken wu̱ ru̱ru̱te̱ ka ko-ya-o-kwu̱m-wu̱ u̱nze wan-bebe̱ u̱n wu̱ u̱t-saw ro̱ wu̱ u̱n sabu̱rse̱ u̱n hwo̱r. ");
INSERT INTO uth_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Remen kaane̱ wu̱ agnu̱ru̱ wan-bebe̱ u̱n wu̱ u̱t-saw. Wu̱ ze̱e̱ru̱ wu̱, ‘U̱m ho̱gu̱te̱ wo̱ me̱ m-sabu̱rse̱ u̱n hwo̱r. Remen kaane̱ kamsu̱ndu̱ me̱ saw-u̱t re, u̱m wongsu̱te̱ wo̱ u̱n baab-to̱ u̱n saw-u̱t re ne̱.’ ");
INSERT INTO uth_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Ka ko-gu̱w-wu̱ ze̱e̱ru̱ hi u̱n de u̱n wu̱, ‘A wongse̱ me̱ u̱n se̱nge̱-m re ne̱. ¿Ya ne̱ u̱m he no̱m? Me̱tt m-'wo̱ns mo̱ to̱m á, komo me̱ m-ho̱ge̱ m-'e̱ mo̱ u̱s-ko̱n. ");
INSERT INTO uth_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","M-mo̱ka u̱m nak yo u̱m he no̱m à! Remen da-o̱ se̱nge̱-m re te'e̱, man kum nay-ne̱, ye̱ he me̱ m-barke̱ ye̱ gu me̱ u̱n hur-to̱ u̱n ye̱ à.’ ");
INSERT INTO uth_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Wu̱ agnu̱ru̱ hun-ne̱ kap ye̱ ka wan-hur-o̱ u̱n wu̱ ro̱ m-do̱re̱ u̱t-mo̱o̱g à. Wu̱ citu̱ru̱ wu̱ u̱r-takan. ‘¿Re ho̱ o̱ a wo̱ m-do̱re̱ u̱r-mo̱o̱g?’ ");
INSERT INTO uth_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Wu̱ shasu̱ru̱, ‘Tur-to̱ m-no̱w o-zungu 100.’ Wan-baab-to̱ u̱t-saw ze̱e̱ru̱ wu̱, ‘Taku̱rda-o̱ u̱t-mo̱o̱g o̱ ka, she'et, o ge̱n kwo̱o̱z-u̱t yoor u̱n o̱p 50 ho̱r-m-ho̱r.’ ");
INSERT INTO uth_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Wu̱ dooru̱ m-cit u̱n wu̱ ken wu̱, ‘Wo̱ komo ¿re ho̱ o̱ a wo̱ m-do̱re̱?’ Wu̱ shasu̱ru̱, ‘U̱t-buhu to̱ u̱n hyo dugu-o gaan 1,000.’ Wan-baab-to̱ u̱t-saw ze̱e̱ru̱ wu̱, ‘Taku̱rda-o̱ u̱t-mo̱o̱g o̱ ka, ge̱n zungu-u̱s eer 800.’ ");
INSERT INTO uth_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Remen kaane̱ bo̱ ka ma-to̱ rwu̱u̱ne̱ à, ka wa-o-kwu̱m, wu̱ bo̱mo̱g wan-bebe̱ u̱n wu̱ u̱t-saw u̱s-we̱e̱r bo̱ wu̱ no̱me̱ ka we̱e̱r-se ba u̱r-bon se̱ à. Kang-o gaan, hun-ne̱ ye̱ do̱re̱ Shir á, ye̱ ro̱ u̱s-we̱e̱r ne̱ be-de u̱n mo̱ro̱gse̱ u̱t-saw to̱ ye̱ hette̱ ho̱ge̱ m-re̱re̱m à, ka hun-ne̱ ye̱ jiishte̱ ka ye̱ do̱re̱ Shir à, gun hi u̱n de u̱n ye̱, u̱n no̱m u̱n rii-yo Shir hette̱ m-no̱m o-zak u̱n ye̱ ne̱ à.” ");
INSERT INTO uth_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Ye̱so dooru̱ m-ze̱e̱ komo, “Remen kaane̱ me̱ no̱ m-ru̱re̱, gu no̱ o̱r u̱n no̱ u̱n rii-yo no̱ ro̱tte̱ u̱n ka dak-o̱ à, remen Shir barku̱tu̱ no̱ n-me̱ u̱n hur-o̱ u̱n wu̱, da-o̱ yo teese̱ à. ");
INSERT INTO uth_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Bo̱ u̱n wu̱ no̱me̱ o-nip u̱n rii hiin à, wu̱a no̱m o-nip u̱n rii caari, komo bo̱ u̱n wu̱ wuke̱ o-nip u̱n rii re̱k-yo à, wu̱a wuke̱ o-nip u̱n rii caari. ");
INSERT INTO uth_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","U̱rege̱, no̱ hoks m-no̱m o-nip u̱n rii-yo no̱ kume̱ u̱n ka dak-o̱ á, Shir a bo̱psu̱ no̱ kashi u̱n rii n-To̱n á. ");
INSERT INTO uth_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Komo u̱rege̱ no̱ hoks m-no̱m o-nip u̱n rii-yo Shir bo̱psu̱ no̱ u̱n ka dak-o̱ á, wu̱a bo̱psu̱ no̱ rii n-To̱n á. ");
INSERT INTO uth_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Ko-gu̱w wan-gaan wu̱a hoks nome̱ u̱n ne̱n yoor m-gu̱w á. Go̱ u̱n ka ko-gu̱w wu̱a yage̱ wan-gaan, wu̱ cu̱n wan-gaan, ko wu̱ nome̱ wan-gaan o-do̱ro̱tte̱ wu̱ yage̱ wan-gaan. Remen kaane̱ no̱a hoks m-nome̱ u̱n Shir m-gu̱w no̱ nome̱ hwo̱r komo á.” ");
INSERT INTO uth_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Bo̱ Parisa-ne̱ ho̱gu̱te̱ kaane̱ à, ye̱ hagu̱ru̱ Ye̱so remen ye̱ ro̱ u̱n co̱n-to̱ u̱n hwo̱r ne̱. ");
INSERT INTO uth_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Ye̱so ze̱e̱ru̱ ye̱, “No̱ co̱no̱g hun-ne̱ zee no̱ u̱n me̱n-u̱t pus-to̱ ne̱, amba Shir nepse̱ no̱ yan-me̱n-u̱t jaas-to̱ ye̱. Remen rii-yo hun-ne̱ bo̱pe̱ kom-u̱t yoor à, be-de u̱n Shir rii-yo á. ");
INSERT INTO uth_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Karamsa-o Mosa u̱n yan-Rwo̱r u̱n Ma-to̱ Shir ne̱ ro gwo̱mo-to̱ u̱n kumu u̱n ho̱o̱g rem na u̱n Yahuda-ne̱ har da-o Yohana Wa-m-Yo'os u̱n hun-ne̱ m-ho̱. Bo̱ u̱n da-o Yohana, me̱ u̱n yan-neke̱-m re ne̱ rwo̱ro̱g, Ma-to̱ m-Re̱re̱m to̱ u̱n gwo̱mo-to̱ Shir. Komo hun-ne̱ de̱e̱n se̱ngu̱te̱ ye̱ go̱kste̱ to̱. ");
INSERT INTO uth_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Amba jiishte̱ busbus a po̱ro̱gse̱ o-dak o-To̱n ne̱, da a zee a jorote̱ gom-de jiishe̱ u̱s-re̱k à, de u̱n karamsa-o̱ Shir. ");
INSERT INTO uth_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Ko̱ wu̱ ke campo̱ wu̱, ho'ose̱ ne'a u̱n wu̱, wu̱ gaaru̱ wu̱ ken ne'a-wu̱, wu̱ no̱mo̱g ba'as-de u̱n m-bu̱kku̱n, komo ko̱ wu̱ ke campo̱-wu̱ ga'e̱ ka ne'a-wu̱ a ho'ose̱ à, wu̱ ma wu̱ no̱mo̱g ba'as-de u̱n m-bu̱kku̱n. ");
INSERT INTO uth_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“A no̱mo̱g wu̱ ken ne̱t-wu̱ ko-ya-o-kwu̱m, wu̱ co̱pe̱ u̱t-gund to̱ ro̱ pukpuk à to̱ u̱n hwo̱r de̱e̱n, wu̱ ro̱ m-ho̱ge̱ re̱re̱m-mo̱ ho̱o̱g-mo̱ u̱n wu̱ ko̱ de ke ho̱-de. ");
INSERT INTO uth_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Wu̱ ken ko-ko̱o̱b-wu̱ ro komo káne̱, a wu̱ m-ze̱e̱ Razarus. Wu̱r-o̱ u̱n wu̱ kap nat-to̱, a wu̱ m-hante̱ u̱n ish-o̱ hur-o̱ u̱n ka wa-o-kwu̱m-wu̱, ");
INSERT INTO uth_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","remen wu̱ reet ga-to̱ ro̱ m-he̱'e̱n u̱n ka ko-ya-o-kwu̱m-wu̱ n-dak à, da-o wu̱ ro̱ m-re̱ à. Ye̱ge̱-wo̱ masu̱ru̱ m-haan ye̱ ro̱ m-rekem u̱n nat-to̱ u̱n wu̱. ");
INSERT INTO uth_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Ka ko-ko̱o̱b-wu̱ maru̱ru̱, yan-to̱m-ye̱ Shir de̱ku̱ru̱ wu̱ ye̱ heetu̱ru̱ wu̱ n-riib Ibrahi, be-de o-biki n-To̱n u̱n Shir. Komo ka ko-ya-o-kwu̱m-wu̱ maru̱ru̱, hun-ne̱ jo̱ku̱ru̱ wu̱. ");
INSERT INTO uth_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Komo n-me̱ o-kuub o-ra, wu̱ ro̱ u̱n swo̱ u̱r-ko̱o̱b, wu̱ dassu̱ru̱ u̱r-hi wu̱ hyambu̱ru̱ Ibrahi u̱r-hew ne̱, u̱n Razarus ne̱ u̱n riib-o̱ u̱n wu̱. ");
INSERT INTO uth_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Wu̱ aagu̱ru̱, ‘Tato re Ibrahi, ho̱ge̱ 'wo̱n u̱n de, o to̱mo̱n Razarus wu̱ ru̱ jow-yo u̱n wu̱ m-ho̱, wu̱ haan, wu̱ gwu̱'u̱rse̱ rem u̱n de, remen me̱ m-swo̱ u̱r-ko̱o̱b n-me̱ o-ra!’ ");
INSERT INTO uth_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Amba Ibrahi ze̱e̱ru̱, ‘Baks, wà re o, da-o̱ u̱n ho̱o̱g-m ru o ho̱gu̱te̱ m-re̱re̱m, Razarus komo swo̱o̱g u̱r-ko̱o̱b. Amba m-mo̱ka wu̱ ro̱ m-ho̱ge̱ re̱re̱m-mo̱ u̱n wu̱ káne̱, wo̱ ne̱, wo̱ u̱n swo̱ u̱r-ko̱o̱b. ");
INSERT INTO uth_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Kane̱ komo, caari-o̱ o-kuub ro̱ ko̱n u̱n te̱te̱ na, remen ye̱ co̱ne̱ m-pas be be-u̱r no̱ ye̱a hoks á, káne̱ komo, yatt-wu̱ he hoks m-passan be-de no̱ ro̱ wu̱ haante̱ be-de te̱ ro̱ á.’ ");
INSERT INTO uth_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Ka ko-ya-o-kwu̱m-wu̱ ze̱e̱ru̱, ‘U̱m ko̱no̱g wo̱, tato re Ibrahi, to̱m Razarus u̱n hur-o tato re. ");
INSERT INTO uth_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Me̱ u̱n hen-ne̱ ne̱ taan campo̱-ne̱. Wu̱ he wu̱ nek ye̱ u̱t-to̱ remen me̱ co̱n ye̱ ma ye̱ haan u̱n ka be-de u̱n swo̱ u̱r-ko̱o̱b de á.’ ");
INSERT INTO uth_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“Amba Ibrahi shasu̱ru̱, ‘Mosa u̱n yan-Rwo̱r u̱n Ma-to̱ Shir ne̱ ro̱ ko̱n ye̱ he nak u̱n hen-ne̱ ru u̱t-to̱ à. Depete̱ hen-ne̱ ru ho̱ge̱ ma-to̱ u̱n ye̱.’ ");
INSERT INTO uth_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Ka ko-ya-o-kwu̱m-wu̱ shasu̱ru̱, ‘To̱ ka bo'os á, tato re Ibrahi! Amba u̱rege̱ wu̱ ken wu̱ inite̱ be-de u̱n margan-ne̱ wu̱ he be-de u̱n ye̱, ka da-de ye̱a yage̱ no̱m u̱r-ba'as.’ ");
INSERT INTO uth_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Amba Ibrahi ze̱e̱ru̱ wu̱, ‘U̱rege̱ ye̱ ho̱ge̱ Mosa u̱n yan-Rwo̱r u̱n Ma-to̱ Shir ne̱ á, ye̱a ho̱ge̱ á ko̱ wu̱ ken wu̱ ine̱ be-de u̱n margan-ne̱.’ ” ");
INSERT INTO uth_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Ye̱so ze̱e̱ru̱ yan-neke̱-mo̱ u̱n wu̱, “Meger-u̱t ro̱ ko̱n to̱ he hante̱ u̱r-ba'as à, amba Shir a tu̱ks ka wu̱ hante̱ ka meger-to̱ à! ");
INSERT INTO uth_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","A jiish wu̱ u̱r-bon a gege̱ wu̱ ta'ar-de u̱r-na u̱n ge̱ks-de u̱n wu̱ a jorbe̱ wu̱ n-me̱ m-sa, da a zee wu̱ rwo̱'e̱ wan-gaan be-de u̱n ka yakar-ye̱ no̱m u̱r-ba'as. ");
INSERT INTO uth_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Remen kaane̱ gwo̱t no̱ yo no̱ m-no̱m à! “U̱rege̱ o̱r ru wan-dor nomote̱ wo̱ u̱r-ba'as, ru̱ru̱ wu̱, u̱rege̱ wu̱ yagu̱te̱ do̱ u̱n no̱m u̱r-ba'as o no̱me̱ wu̱ u̱r-ho̱. ");
INSERT INTO uth_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","U̱rege̱ wu̱ nomote̱ wo̱ u̱r-ba'as ho̱-u̱r gaan o-ta'yoor, komo ko̱ o̱ ke da-o̱ wu̱ haan wu̱ zee wo̱, ‘Man do̱ á,’ no̱me̱ wu̱ u̱r-ho̱.” ");
INSERT INTO uth_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Yan-To̱m Ye̱so ze̱e̱ru̱ Go̱s-wu̱, “Do te̱ m-'wo̱ns remen te̱ e̱ste̱ ma-u̱t ru.” ");
INSERT INTO uth_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Ye̱so shasu̱ru̱, “U̱rege̱ no̱ ro̱ u̱n e̱ss u̱t-ma ne̱ u̱ntu̱n go̱-yo jiishe̱ u̱s-re̱k à u̱ntu̱n go̱-yo mosta, no̱a hoks m-ze̱e̱ u̱n ka 'yo-yo, ‘Muuse̱ u̱s-geer ne̱ o she̱r hi u̱n du n-me̱ m-sa!’ Komo yo a no̱mo̱ no̱ o-do̱ro̱tte̱. ");
INSERT INTO uth_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“A zee wu̱ ken wu̱ be-u̱r no̱ ro̱ u̱n ko-gu̱w ne̱, wu̱ ro̱ wu̱ u̱t-kerem à, ko gwo̱t u̱n ca. Da-o̱ wu̱ mu̱u̱ne̱ so̱ o-kat, wo̱a zee wu̱ re̱ ga-to̱ u̱n wu̱ ho̱r-m-ho̱r á. ");
INSERT INTO uth_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Ko̱ hiin! Wo̱a zee wu̱ ma, ‘Rishnu̱ me̱ ga u̱n de, o wasu̱ me̱, u̱m reet, u̱m su̱u̱s, me̱ komse̱ wo̱a hoks m-re̱ u̱n yo ma ru rii-yo m-re̱ yo!’ ");
INSERT INTO uth_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","¿U̱depe̱ a bu̱m ko-gu̱w remen wu̱ no̱mo̱g o-do̱ro̱tte̱ á, depete̱ a bu̱m wu̱? ");
INSERT INTO uth_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Kang-o gaan u̱n no̱ ne̱, da-o̱ no̱ no̱me̱ yo Shir ze̱e̱ no̱, no̱ no̱m à, ze̱e̱ no̱, ‘Te̱ gu̱w-ne̱ ye̱ temb, te̱ u̱n no̱m se̱nge̱-m te̱.’ ” ");
INSERT INTO uth_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Bo̱ Ye̱so bu̱pte̱ co̱w-yo o-Urusharima à, wu̱ do̱ru̱ru̱ u̱n te̱ riib-se u̱n dak-o̱ o-Samariya u̱n dak-o̱ o-Gariri ne̱. ");
INSERT INTO uth_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Wu̱ ro̱ m-co̱w u̱n yo ken ya-o-bo̱ yo, wu̱ gontu̱ru̱ hun-ne̱ o̱p ye̱ ro̱ u̱n swo̱ u̱r-ko̱o̱b u̱n go̱m-o̱ u̱t-cim. Ye̱ e̱su̱ru̱ u̱r-hew ne̱. ");
INSERT INTO uth_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Ye̱ 'yonsu̱ru̱ u̱s-co̱r, “Ye̱so! Go̱s-wu̱! Ho̱ge̱ 'wo̱n u̱n te̱!” ");
INSERT INTO uth_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Ye̱so hyanu̱ru̱ ye̱, wu̱ ze̱e̱ru̱ ye̱, “Ha no̱ be-u̱r ko-wan-Co̱w u̱n ko̱n-se Shir wu̱ byarag no̱.” Ye̱ ro̱ m-neke̱ u̱n co̱w go̱m-se u̱n ye̱ taaru̱. ");
INSERT INTO uth_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Bo̱ wan-gaan hyente̱ go̱m-o̱ u̱n wu̱ taag à, wu̱ mu̱u̱nu̱ru̱ u̱n bo̱ngo̱n-de Shir u̱n co̱r caari. ");
INSERT INTO uth_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Wu̱ so̱ru̱ hi u̱n de u̱n wu̱ n-dak be-de u̱n na-u̱s Ye̱so, wu̱ bo̱mu̱ru̱ wu̱. Ka ne̱t-wu̱ ko-Samariya-wu̱. ");
INSERT INTO uth_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Ye̱so ze̱e̱ru̱, “Ne̱n o̱p ye̱ ka u̱m taase go̱m-se u̱n ye̱ à, ¿kene̱ ka jero̱-ye̱ ro̱? ");
INSERT INTO uth_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","¿Remen yan o̱ bo̱ u̱n ka ko-hamat-wu̱ u̱n ho̱n-de u̱n wu̱ mu̱u̱ne̱ wu̱ bu̱mu̱t Shir?” ");
INSERT INTO uth_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Ye̱so ze̱e̱ru̱ wu̱, “Ine̱ eso, o arag remen o she̱re̱g hur u̱n du be-de Shir, Shir taaste̱ go̱m-o ru.” ");
INSERT INTO uth_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Ye̱ ken Parisa-ne̱ ye̱ citu̱ru̱ Ye̱so da-o̱ gwo̱mo-to̱ Shir he m-haan à. Ye̱so shasu̱ru̱: “Gwo̱mo-to̱ Shir a haan bo̱ a he to̱ m-hyan á. ");
INSERT INTO uth_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Yatt-wu̱ he m-ze̱e̱, ‘Gwo̱t, to̱ ka kane̱!’ Ko̱, ‘To̱ ka re̱e̱no̱!’ Remen gwo̱mo-to̱ Shir ro̱ be-de no̱ ro̱ à.” ");
INSERT INTO uth_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Ka da-de wu̱ ze̱e̱ru̱ yan-neke̱-mo̱ u̱n wu̱, “Da-o ro̱o̱n da-o̱ no̱ he m-co̱n no̱ hyen ho̱-u̱r gaan be-de u̱n ho̱-to̱ u̱n Wà-wu̱ u̱n ne̱t à, amba no̱a hyen de á. ");
INSERT INTO uth_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Ye̱ ken hun-ne̱ ye̱ he no̱ m-ze̱e̱, ‘Wà-wu̱ u̱n ne̱t, Wu̱ ká re̱e̱no̱!’ Ko̱, ‘Wu̱ kà kane̱!’ Amba no̱ ru m-gwo̱t á. ");
INSERT INTO uth_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Me̱ no̱ m-ru̱re̱ u̱ntu̱n u̱s-myakt n-to̱n komo m-cecar ne̱, kaane̱ mu̱u̱n-mo̱ u̱n Wà-wu̱ u̱n ne̱t, he m-no̱m u̱n ho̱-de u̱n wu̱. ");
INSERT INTO uth_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Amba u̱r-takan Wà-wu̱ u̱n ne̱t wu̱a su̱ u̱r-ko̱o̱b de̱e̱n hun-ne̱ ye̱ u̱n ka da-o̱, ye̱a 'yarag wu̱. ");
INSERT INTO uth_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Bo̱ hun-ne̱ no̱me̱ da-o Nuhu à kaane̱ ye̱ he m-no̱m da-o̱ re Wà-wu̱ u̱n ne̱t he m-mu̱u̱n à. ");
INSERT INTO uth_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Ko̱ wu̱ ke m-re̱ m-swo̱ ne̱, campo̱-ne̱ u̱n ne'a-ne̱ ne̱ u̱n se̱nge̱-mo̱ u̱t-ge, har u̱n ka ho̱-de Nuhu tu̱wte̱ o-hat à, komo ho̱-m haanu̱ru̱ mo̱ re̱e̱ru̱ ye̱ kap. ");
INSERT INTO uth_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","O̱a no̱m u̱ntu̱n da-o̱ wu̱ ken ne̱t-wu̱ jin-de u̱n wu̱ Ro̱t. Ko̱ wu̱ ke u̱n se̱nge̱-mo̱ m-re̱ m-swo̱ ne̱, u̱t-baab, m-o̱ ne̱, u̱r-go, u̱t-ma ne̱. ");
INSERT INTO uth_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Ho̱-de Ro̱t rwu̱u̱ne̱ bo̱-o̱ o-So̱do̱m à, Shir hentu̱te̱ o-ra u̱n kak-to̱ o-ra ne̱ u̱ntu̱n kem n-To̱n u̱n shir o̱ ho̱o̱ru̱ ye̱ kap. ");
INSERT INTO uth_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Kaane̱ he m-no̱m ho̱-de u̱n mu̱u̱n-mo̱ u̱n Wà-wu̱ u̱n ne̱t wu̱a 'wo̱s hun-ne̱ ba m-zo̱nge̱. ");
INSERT INTO uth_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“U̱n ka ho̱-de wu̱ ro̱ n-to̱n u̱r-do̱o̱b de u̱n kuke̱-o̱ u̱n wu̱ à, wu̱ kergu̱ne̱ á, wu̱ cu̱w hur-o̱ u̱n wu̱ á, wu̱ dekente̱ yo ken rii-yo á, remen Shir a sabu̱rse̱ ka ye̱ co̱ne̱ ruut u̱n saw-to̱ u̱n ye̱ à, kaane̱ komo bo̱ u̱n wu̱ ro̱ o-kat à, wu̱a warag o-hur á. ");
INSERT INTO uth_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Baks no̱ ne'a Ro̱t wu̱ naaste̱ o-da komo wu̱ wakte̱ u̱s-ajima ne̱ remen saw-to̱ u̱n wu̱, Shir sabu̱rsu̱te̱ wu̱. ");
INSERT INTO uth_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Bo̱ u̱n wu̱ co̱ne̱ wuke̱ u̱n ho̱o̱g-mo̱ u̱n wu̱ à, wu̱ yage̱ me̱ m-do̱re̱ mo̱a e̱ge̱ wu̱, komo bo̱ u̱n wu̱ ho̱o̱g-mo̱ u̱n wu̱ e̱ge̱ rem re à, wu̱a kum mo̱. ");
INSERT INTO uth_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","U̱n ka te̱t-mo̱, me̱ no̱ m-ru̱re̱, hun-ne̱ yoor m-rew be-u̱r gaan: Shir a dek wan-gaan, wu̱ yage̱ wan-gaan n-jim. ");
INSERT INTO uth_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Ne'a-ne̱ yoor u̱r-na be-u̱r gaan, Shir a dek wan-gaan, wu̱ yage̱ wan-gaan n-jim.” ");
INSERT INTO uth_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Yan-neke̱-mo̱ u̱n wu̱ citu̱ru̱ wu̱, “Go̱s-wu̱, ¿kene̱ ka rii-yo he m-ko̱r?” Ye̱so shasu̱ru̱, “Be-de u-u̱r ro̱ à, kane̱ sakra he m-mo̱rge̱.” ");
INSERT INTO uth_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Ye̱so ru̱ru̱ yan-neke̱-mo̱ u̱n wu̱ sha-mo̱ u̱t-ma wu̱ yoosu̱tu̱ ye̱ bo̱ ye̱ he m-se̱nge̱ u̱n ko̱n-se Shir ba m-kar á. ");
INSERT INTO uth_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","“U̱n o̱ ken bo̱-o̱ a no̱mo̱g wu̱ ken wan-piish u̱t-ma wu̱, wu̱ ro̱ u̱n ho̱ge̱ gye̱r-o Shir á, wu̱ komo m-hyan hi-de u̱n ne̱t u̱s-shi ne̱ á. ");
INSERT INTO uth_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Wu̱ ken ko-gwo̱r-wu̱ ne'a, ro kane̱ u̱n ka bo̱-o̱ wu̱ ma'ase̱ m-ha be-de u̱n wu̱ à u̱n hoob-o̱ u̱n a ya'as wu̱ yo ro̱ yo ma u̱n wu̱ à, wu̱ ro̱ m-ze̱e̱, ‘Gu me̱ be-de u̱n wan-ryaab-u̱s re.’ ");
INSERT INTO uth_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","O-da de̱e̱n, wan-piish u̱t-ma yage̱ u̱n was, amba u̱r-ko̱m wu̱ ze̱e̱ru̱ hi u̱n de u̱n wu̱, ‘Me̱tt gye̱r-o Shir á, me̱ komo m-hyan hi-de u̱n ne̱t u̱s-shi ne̱ á, ");
INSERT INTO uth_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","amba remen ka ko-gwo̱r-wu̱ su̱tu̱ me̱, man gu̱t remen wu̱ kumut yo ro̱ yo ma u̱n wu̱ à. U̱rege̱ me̱ no̱m kaane̱ á, wu̱a ma'as m-haan har wu̱ bo̱ me̱.’ ” ");
INSERT INTO uth_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Ye̱so ze̱e̱ru̱, “Ho̱gu̱ no̱ yo ka wan-piish u̱t-ma wu̱ ze̱e̱ à, wu̱ ro̱tte̱ gye̱r-o Shir á. ");
INSERT INTO uth_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Wu̱ hokste̱ nome̱ u̱n ká ko-gwo̱r-wu̱ kaane̱, remen wu̱ suute̱ wu̱, kaane̱ Shir a hoks nome̱ u̱n hun-ne̱ ye̱ wu̱ daage̱ à rii-yo u̱r-bon, u̱rege̱ ye̱ ko̱no̱g wu̱, wu̱a gu ye̱ ho̱r-m-ho̱r. ");
INSERT INTO uth_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Me̱ no̱ m-ru̱re̱, Shir a piish ma-to̱ u̱n ye̱ ho̱r-m-ho̱r bo̱ ye̱ he ho̱ge̱ m-re̱re̱m à. Amba Wà-wu̱ u̱n ne̱t ¿wu̱a 'wo̱s hun-ne̱ go̱kste̱ Ma-to̱ Shir da-o̱ wu̱ he m-mu̱u̱n ne̱?” ");
INSERT INTO uth_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Ye̱so doog hun-ne̱ m-ru̱re̱ ka sha-mo̱ u̱t-ma mo̱, ye̱ nepse̱ she'et-de u̱n ye̱, kashi de á, komo ye̱ ro̱ u̱n muut u̱n ye̱ ken ye̱ n-dak. ");
INSERT INTO uth_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Da-o̱ gaan hun-ne̱ yoor haag u̱n Pyo-o̱ Shir ye̱ konot Shir: Wan-gaan ko-Parisa-wu̱, wu̱ ka komo wan-go̱ks u̱n tar. ");
INSERT INTO uth_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Ko-Parisa e̱su̱ru̱ u̱n ho̱n wu̱ ko̱nu̱ru̱, ‘Shir, u̱m bo̱mo̱g wo̱ remen me̱ ko-hyow á, me̱ ko-wan-me̱n-u̱t jaas-to̱ wu̱ á, me̱ u̱n rwo̱r u̱t-bo̱ á, me̱ u̱n hoob-o̱ u̱n ne'a-ne̱ u̱ntu̱n ye̱ ken ye̱ á. U̱m bo̱mo̱g wo̱ remen me̱ u̱ntu̱n ka ko-wan-go̱ks u̱n tar wu̱ re̱e̱no̱ á. ");
INSERT INTO uth_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","U̱n ho̱-u̱t ta'yoor me̱ u̱n no̱m o-swo̱o̱t ho̱-u̱t yoor, me̱ kume̱ rii-yo wo̱o̱ o̱p à, me̱ wo̱ m-ya'as o-gaan.’ ");
INSERT INTO uth_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Amba ko-yan-go̱ks u̱n tar e̱su̱ru̱ u̱r-hew ne̱ komo wu̱ jaks co-o̱ u̱n wu̱ n-To̱n á, amba wu̱ wo̱su̱ru̱ be-de u̱n wu̱. Wu̱ ze̱e̱ru̱, ‘Shir, ho̱ge̱ 'wo̱n u̱n de, me̱ ko-wa-u̱r-ba'as!’ ” ");
INSERT INTO uth_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Ye̱so ze̱e̱ru̱ ye̱, “Me̱ no̱ m-ru̱re̱, ko-yan-go̱ks u̱n tar, waragte̱ o-hur hond hond be-de Shir, amba ko-Parisa-wu̱ warag o-hur hond hond á. Remen kap ye̱ jakse̱ hi u̱n de u̱n ye̱ n-to̱n à, Shir à he̱nte̱ ye̱ n-dak, komo kap bo̱ u̱n ye̱ he̱nte̱ hi u̱n de u̱n ye̱ dak dak à, Shir a jaks ye̱ n-to̱n.” ");
INSERT INTO uth_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Ye̱ ken hun-ne̱ ye̱ hantu̱ru̱ yakar-ye̱ u̱n ye̱ be-u̱r Ye̱so remen wu̱ hu̱u̱té̱ ye̱ nu-o̱ u̱r-bon. Yan-neke̱-m Ye̱so te̱pru̱ru̱ ye̱ bo̱ ye̱ no̱me̱ kaane̱ à, ");
INSERT INTO uth_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Amba Ye̱so agnu̱ru̱ ka yakar-ye̱ be-de u̱n wu̱ komo wu̱ ze̱e̱ru̱, “Yagu̱ no̱ yakar re̱k-ye̱ haante̱ be u̱n de, no̱ we̱n ye̱ á, remen gwo̱mo-to̱ Shir ro̱ be-de go̱n ye̱. ");
INSERT INTO uth_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Baks no̱ de ka! Kap bo̱ u̱n wu̱ go̱ksé̱ gwo̱mo-to̱ Shir u̱ntu̱n wà á, wu̱a tu̱w u̱n den-o Shir á.” ");
INSERT INTO uth_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Ne̱t caari-wu̱ u̱n Yahuda-ne̱ citu̱ru̱ Ye̱so, “Wa-u̱r-Yoos, wo̱ kashi-wu̱, ¿ya ne̱ u̱m he m-no̱m u̱m kumut ho̱o̱g-o̱ ba m-ta?” ");
INSERT INTO uth_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Ye̱so citu̱ru̱ wu̱, “¿Remen yan o̱ o zeete̱ me̱ ‘kashi’? Yatt-wu̱ ro̱ kashi á se Shir cot. ");
INSERT INTO uth_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","O nepse̱ ka karamsa-o̱: ‘Wo̱ co̱n ne'a-wu̱ u̱n ne̱t á, wo̱ ho̱ ne̱t á, wo̱ hiw rii á, wo̱ ce'e̱ ne̱t u̱t-ma á, hyan tato ru u̱n inu ru ne̱ u̱t-go̱s ne̱.’ ” ");
INSERT INTO uth_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Ka ne̱t-wu̱ shasu̱ru̱, “Cin me̱ re̱k-wu̱ u̱m no̱mo̱sse̱ do̱ro̱tte̱-o̱ u̱n o̱ kap.” ");
INSERT INTO uth_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Bo̱ Ye̱so ho̱ge̱ kaane̱ à, wu̱ ze̱e̱ru̱ wu̱, “Yo ken yo ro̱ ko̱n yo kuse̱ o no̱m à: Baab rii-yo o ro̱tte̱ à kap, o ya'as ko̱o̱b-ne̱ ka hwo̱r-ye̱, komo wo̱a kum rii-yo u̱r-bon n-To̱n, ka da-o̱, o haan, o do̱re̱ me̱.” ");
INSERT INTO uth_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Amba da-o̱ ka ne̱t-wu̱ ho̱ge̱ kaane̱ à, wu̱ ho̱ge̱ m-re̱re̱m ko̱ hiin á, remen ko-ya-o-kwu̱m-wu̱ de̱e̱n. ");
INSERT INTO uth_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Ye̱so hyanu̱ru̱ wu̱ ho̱ge̱ m-re̱re̱m á, wu̱ ze̱e̱ru̱, “Ko-ya-o-kwu̱m a tu̱w den-o̱ u̱n gwo̱mo-to̱ Shir u̱n yish pus-ye̱ á! ");
INSERT INTO uth_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","O̱tte̱ ko-ya-o-kwu̱m-wu̱ tu̱w den-o̱ u̱n gwo̱mo-to̱ Shir à, jiishte̱ ba u̱n rem dorom-yo tu̱w u̱n ish-o̱ o-be̱r.” ");
INSERT INTO uth_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Hun-ne̱ ye̱ ho̱ge̱ wu̱ à citu̱ru̱, “¿Wan wu̱ u̱n ya Shir he m-gu?” ");
INSERT INTO uth_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Ye̱so shasu̱ru̱, “Rii-yo hun-ne̱ a hoks m-no̱m á, Shir a hoks yo m-no̱m.” ");
INSERT INTO uth_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Ka da-de Bitrus ze̱e̱ru̱, “Gwo̱t! Te̱ yagnu̱te̱ den-u̱t te̱, te̱ do̱ru̱tu̱ wo̱.” ");
INSERT INTO uth_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Ye̱so ze̱e̱ru̱ ye̱, “E̱e̱, komo u̱m esu̱tu̱ no̱, ko̱ wu̱ ke wu̱ yage̱ hur-o̱ u̱n wu̱, ko ne'a, ko hen-ne̱, ko ye̱ mate̱ wu̱ à, ko yakar remen co̱n-to̱ u̱n den-o̱ u̱t-gwo̱mo to̱ Shir, ");
INSERT INTO uth_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","wu̱a kum de̱e̱n u̱n ka hak-se, komo wu̱a kum ho̱o̱g-o̱ ba m-ta u̱n hak-se ro̱o̱ne̱ à.” ");
INSERT INTO uth_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Ye̱so deku̱ru̱ yan-neke̱-mo̱ u̱n wu̱ o̱p u̱n yoor n-riib, wu̱ ze̱e̱ru̱ ye̱, “Ho̱gu̱ no̱! A he no̱ o-Urusharima, be-de kap rii-yo yan-Rwo̱ru̱ u̱n Ma-to̱ Shir ge̱ne̱ u̱n Wà-wu̱ u̱n ne̱t he m-shi à. ");
INSERT INTO uth_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Wu̱ a he̱'e̱be̱ u̱n kom-to̱ u̱n ye̱ ro̱ Isra-ne̱ á, ye̱a pyapar wu̱, ye̱ co̱pse̱ wu̱ m-ta komo. ");
INSERT INTO uth_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Ye̱a no̱me̱ wu̱ u̱s-so̱ro̱g, ye̱ ho̱ wu̱ amba ho̱-u̱r atette̱-de, wu̱a ine̱ u̱n ho̱o̱g ne̱.” ");
INSERT INTO uth_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Amba yan-neke̱-mo̱ u̱n wu̱ ye̱ nap ko o-gaan yo wu̱ ro̱ m-ze̱e̱ á, remen a wukute̱ ye̱ ma-to̱ wu̱ ro̱ m-rwo̱r à, komo ye̱ nap rii-yo Ye̱so ro̱ m-rwo̱r á. ");
INSERT INTO uth_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Ye̱so ro̱ yow yow o-Jeriko ne̱, wu̱ ken ko-po̱-wu̱ ro̱ tara n-riib u̱n co̱w, wu̱ ro̱ u̱s-ko̱n. ");
INSERT INTO uth_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Da-o̱ wu̱ ho̱ge̱ hun-ne̱ ro̱ m-arag à, wu̱ citu̱ru̱, “¿Yan yo ne̱?” ");
INSERT INTO uth_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Ye̱ ru̱ru̱ wu̱, “Ye̱so ko-ya-o-Nazaret ro̱ m-arag.” ");
INSERT INTO uth_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Wu̱ 'yonsu̱ru̱ u̱s-co̱r, “Ye̱so! Baag-o Dawuda! Ho̱ge̱ 'wo̱n u̱n de!” ");
INSERT INTO uth_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Hun-ne̱ ye̱ ro co à, kangsu̱ru̱ wu̱ ye̱ ze̱e̱ru̱ wu̱ re̱s temb. Amba wu̱ 'yonsu̱ru̱ u̱s-co̱r de̱e̱n, “Baag-o Dawuda ho̱ge̱ 'wo̱n u̱n de.” ");
INSERT INTO uth_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Ka da-o̱ Ye̱so e̱su̱ru̱ wu̱ ze̱e̱ru̱, “Hantu̱ no̱ ka ko-po̱-wu̱ be u̱n de.” Bo̱ wu̱ wo̱'o̱nte̱ yow yow à, Ye̱so citu̱ru̱ wu̱, ");
INSERT INTO uth_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“¿Ya ne̱ o co̱ne̱ u̱m no̱mo̱ wo̱?” Wu̱ shasu̱ru̱, “Go̱s-wu̱, u̱m co̱no̱g m-hyen.” ");
INSERT INTO uth_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Ye̱so ze̱e̱ru̱ wu̱, “Hyan! Remen she̱r-m ru be-de Shir rwo̱'o̱g wo̱ m-hyan.” ");
INSERT INTO uth_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","U̱n gyept-o̱ u̱n yish, wu̱ hyanu̱ru̱ cas kane̱, wu̱ do̱ru̱ru̱ Ye̱so, wu̱ ro̱ u̱n nome̱ u̱n Shir u̱r-bo̱ngo̱n. Da-o̱ bu̱u̱g-de u̱n hun-ne̱ hyane̱ kaane̱ à, ye̱ bo̱mu̱ru̱ Shir kap mo̱ u̱n ye̱. ");
INSERT INTO uth_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Ye̱so co̱wu̱ru̱ o-Jeriko wu̱ ro̱ m-arag. ");
INSERT INTO uth_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Ko-Gwo̱mo-wu̱ u̱n yan-go̱ks u̱n tar jin-de u̱n wu̱ Zakka, ko-ya-o-kwu̱m-wu̱. ");
INSERT INTO uth_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Wu̱ co̱no̱g wu̱ hyen ko̱ wan wu̱ ne̱ Ye̱so. Amba wu̱ hoks hyan u̱n Ye̱so á, remen hun-ne̱ no̱mo̱g de̱e̱n, komo wu̱tt m-se̱e̱b á ko̱ hiin. ");
INSERT INTO uth_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Wu̱ argu̱ru̱ o-rek u̱n co-o̱ u̱n hun-ne̱ wu̱ daaru̱ o-dirimi wu̱ hyenet Ye̱so, wu̱ ro̱ m-arag ka so̱ à. ");
INSERT INTO uth_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Bo̱ Ye̱so woote̱ u̱n ka be-de à, wu̱ dassu̱ru̱ u̱r-hi n-to̱n wu̱ ze̱e̱ru̱ Zakka, “Kergu̱ne̱ ho̱r-m-ho̱r, remen u̱n hur-o ru u̱m he m-she'et caane̱.” ");
INSERT INTO uth_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Zakka kergu̱nu̱ru̱ ho̱r-m-ho̱r wu̱ barku̱ru̱ Ye̱so zak-o-zak. ");
INSERT INTO uth_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Kap hun-ne̱ ye̱ hyane̱ kaane̱ à, taknu̱ru̱ u̱s-cenene, “Ka ne̱t-wu̱ haag u̱r-hamat u̱n hur-o̱ u̱n ko-ya-u̱r-ba'as!” ");
INSERT INTO uth_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Zakka inu̱ru̱ eso wu̱ ze̱e̱ru̱ Ye̱so, “Ho̱ge̱, man ya'as ko̱o̱b-ne̱ u̱r-pu̱ru̱g de u̱n rii re, u̱rege̱ komo u̱m rumuste̱ rii-yo u̱n wu̱ ken wu̱, man to̱pe̱ wu̱ ka rii-yo so̱ o-nass.” ");
INSERT INTO uth_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Ye̱so ze̱e̱ru̱ wu̱, “Ka hur-o̱ kumug gwu̱ caane̱, remen ka ne̱t-wu̱ go̱kste̱ Ma-to̱ Shir u̱ntu̱n Ibrahi. ");
INSERT INTO uth_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Wà-wu̱ u̱n ne̱t haante̱ wu̱ hobt, komo wu̱ guut ye̱ e̱ge̱ à.” ");
INSERT INTO uth_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Bo̱ hun-ne̱ ro̱ m-ho̱ge̱ u̱n to̱ ka à, Ye̱so dooru̱ ye̱ m-ru̱re̱ sha-mo̱ u̱t-ma. U̱n ka da-de, wu̱ ro yow yow o-Urusharima ne̱, komo ye̱ ro̱ m-ze̱e̱ u̱nze gwo̱mo-to̱ Shir ro̱ ma-to̱ m-rwu̱u̱n. ");
INSERT INTO uth_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Wu̱ ze̱e̱ru̱, “Wu̱ ken ne̱t caari-wu̱, ro̱ m-ha u̱n o̱ ken bo̱-o̱ u̱r-hew ne̱, a sagbu̱te̱ wu̱ u̱t-gwo̱mo, a komse̱ wu̱ mu̱u̱nu̱ru̱ o-hur. ");
INSERT INTO uth_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Bo̱ wu̱ ine̱ m-neke̱ à, wu̱ agnu̱ru̱ gu̱w-ne̱ ye̱ u̱n wu̱ ne̱n o̱p komo wu̱ yasu̱ru̱ ko̱ wu̱ ke hwo̱r. Wu̱ ru̱ru̱ ye̱, ‘Se̱ngu̱ no̱, no̱ gu̱t yo no̱ he m-hoks m-kum da-o̱ me̱ neke̱.’ ");
INSERT INTO uth_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Amba hun-ne̱ ye̱ u̱n wu̱ yagu̱te̱ wu̱, ye̱ to̱mu̱ru̱ n-jim de u̱n wu̱ u̱nze, ‘Te̱ co̱n ka ne̱t-wu̱ reete̱ u̱t-gwo̱mo á.’ ");
INSERT INTO uth_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Komo haanu̱ru̱ a sagbu̱ru̱ ka ne̱t-wu̱ u̱t-gwo̱mo wu̱ mu̱u̱nu̱ru̱. Bo̱ m-jo'on, wu̱ ze̱e̱ru̱ gu̱w-ne̱ ye̱ u̱n wu̱ ye̱ rwu̱u̱n, remen wu̱ nept yo ye̱ kume̱ à. ");
INSERT INTO uth_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Wu̱ u̱r-takan haanu̱ru̱ wu̱ ze̱e̱ru̱, ‘Go̱s-wu̱, u̱m kumug so̱ o-o̱p n-to̱n u̱n ka ye̱ o yasu̱ me̱ à.’ ");
INSERT INTO uth_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Wu̱ ze̱e̱ru̱, ‘Ke̱rege̱n, wo̱ ko-gu̱w kashi-wu̱! O no̱mo̱g m-se̱nge̱ u̱n rii hiin, man sagbe̱ wo̱ u̱t-gwo̱mo to̱ u̱n bo̱-u̱t o̱p.’ ");
INSERT INTO uth_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Ko-gu̱w ayoore̱-wu̱, haanu̱ru̱ wu̱ ze̱e̱ru̱, ‘Go̱s-wu̱, u̱m kumug so̱ o-taan n-to̱n u̱n ka ye̱ o yasu̱ me̱ à.’ ");
INSERT INTO uth_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Wu̱ ze̱e̱ru̱ wu̱, ‘Komo wo̱a no̱m gwo̱mo-to̱ u̱n bo̱-u̱t taan.’ ");
INSERT INTO uth_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Komo wu̱ ken ko-gu̱w-wu̱ haanu̱ru̱ wu̱ ze̱e̱ru̱, ‘Go̱s-wu̱, hwo̱r ru ye̱ ka, me̱ u̱n wuke̱ ye̱ u̱r-magund. ");
INSERT INTO uth_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Me̱ wo̱ o-gye̱r, remen wo̱ rii-yo o-gye̱r yo. Wo̱ m-de̱k be-de wo̱ e̱sse̱ á, komo wo̱ m-ce be-de wo̱ go̱ ye̱ á.’ ");
INSERT INTO uth_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Wu̱ ze̱e̱ru̱ wu̱, ‘Wo̱ ko-gu̱w-wu̱ o-hwaa! Man de̱k gom-u̱t ru, m-sabu̱rsu̱te̱ wo̱! O nepste̱ me̱ rii-yo o-gye̱r yo, me̱ m-de̱k be-de me̱ e̱sse̱ á, komo me̱ m-ce be-de me̱ go̱ á. ");
INSERT INTO uth_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","¿Remen yan o̱ wo̱ heete̱ hwo̱r re o-benki á, be-de u̱m ro̱a go̱ksu̱ne̱ m-sakne̱ da-o̱ u̱m mu̱u̱ne̱ á?’ ");
INSERT INTO uth_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“Ka da-de wu̱ ze̱e̱ru̱ ka ye̱ ro eso kane̱ à, ‘Rumus no̱ ka hwo̱r-ye̱ be-de u̱n wu̱, no̱ ya'as ka ko-gu̱w-wu̱ ro̱ u̱n o̱p ne̱ à.’ ");
INSERT INTO uth_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Amba ye̱ ze̱e̱ru̱ wu̱, ‘Go̱s-wu̱, ay, wu̱ ro̱ u̱n o̱p ne̱!’ ");
INSERT INTO uth_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Wu̱ shasu̱ru̱, ‘Me̱ no̱ m-ru̱re̱, kap ka ye̱ ro̱ u̱n rii ne̱ à, Shir a do ye̱, amba ka ye̱ rotte̱ rii á, ka yo ye̱ ro̱tte̱ hiin à, Shir a rumus ye̱ yo. ");
INSERT INTO uth_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","M-mo̱ka, ka yan-yage̱-u̱t re ye̱, ka ye̱ co̱ne̱ a sagbe̱ me̱ u̱t-gwo̱mo á, hantu̱ no̱ ye̱ kane̱, ho̱ no̱ ye̱ u̱n hyan-o re!’ ” ");
INSERT INTO uth_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Bo̱ Ye̱so komte̱ ka ma-to̱ à, wu̱ taku̱ru̱ co wu̱ ro̱ m-ha o-Urusharima yan-neke̱-mo̱ u̱n wu̱ ro̱ wu̱ m-do̱rbe̱ n-jim. ");
INSERT INTO uth_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Bo̱ wu̱ wo̱o̱nte̱ yow yow o-Bapaji ne̱ o-Betanya ne̱ à, u̱n 'wu̱n-de o-haag o̱ hun-ne̱ m-ze̱e̱, Haag-o̱ u̱n 'yo-se o-Ze̱tun à, wu̱ to̱mu̱ru̱ yan-neke̱-mo̱ u̱n wu̱ ne̱n yoor ");
INSERT INTO uth_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","u̱n kà ma-to̱ ne̱: “Ha no̱ u̱n ka bo̱-de ro̱ u̱n co no̱ à. Da-o̱ no̱ m-co̱w à, no̱a hyen wà-yo o-janka yo a ce̱te̱ m-da á gego. Ussu̱ndu̱ no̱ yo, no̱ hante̱ kane̱. ");
INSERT INTO uth_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","U̱rege̱ wu̱ ken wu̱ cikt no̱, ‘¿Remen yan o̱ no̱ ro̱tte̱ yo m-us?’ Zee no̱ wu̱, ‘Go̱s-wu̱ co̱no̱g yo.’ ” ");
INSERT INTO uth_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Ye̱ do̱ru̱ru̱ o-co̱w, ye̱ 'wo̱ssu̱ru̱ hond hond, bo̱ Ye̱so ru̱ru̱ ye̱ à. ");
INSERT INTO uth_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Bo̱ ye̱ ro̱ m-us u̱n ka wà-yo o-janka yo à, wan-yo ze̱e̱ru̱ ye̱, “¿Remen yan o̱ no̱ ro̱tte̱ yo m-us?” ");
INSERT INTO uth_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Ye̱ shasu̱ru̱, “Go̱s-wu̱ co̱no̱g yo̱.” ");
INSERT INTO uth_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Ye̱ de̱ku̱ru̱ ka wà-yo o-janka yo ye̱ heetu̱ru̱ Ye̱so. Ka da-de, ye̱ saku̱ru̱ gund-to̱ u̱n ye̱ u̱n cin-o̱ u̱n ka janka-yo, ye̱ detu̱ru̱ Ye̱so n-to̱n. ");
INSERT INTO uth_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Bo̱ wu̱ da n-to̱n à, hun-ne̱ neksu̱ru̱ gund-to̱ u̱n ye̱ u̱n co̱w. ");
INSERT INTO uth_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Bo̱ wu̱ wo̱o̱nte̱ yow yow o-Urusharima ne̱ à, be-de ka co̱w-yo do̱re̱ u̱n 'wu̱n-de u̱n Haag-o̱ u̱n 'yo-se o-Ze̱tun à, bu̱u̱g-de u̱n hun-ne̱ yan-neke̱-mo̱ u̱n wu̱ taknu̱ru̱ bo̱ngo̱n-de Shir u̱n 'yons u̱s-co̱r remen rii-yo o-made̱ yo ye̱ hyane̱ kap à. ");
INSERT INTO uth_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Ye̱ 'yonsu̱ru̱ u̱s-co̱r, ye̱ ze̱e̱ru̱, “Shir ru̱'e̱ ko-Gwo̱mo o-kom wu̱ haane̱ u̱n be̱e̱b-de u̱n Yawe à, m-gwu̱gwu̱ n-to̱n kane̱ m-se̱ke̱mse̱ be-de Shir!” ");
INSERT INTO uth_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Ka da-de ye̱ ken Parisa-ne̱ ye̱ kane̱ te̱psu̱ru̱ Ye̱so. “Wa-u̱r-Yoos, ze̱e̱ yan-neke̱-m ru ye̱ re̱s temb!” ");
INSERT INTO uth_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Ye̱so shasu̱ru̱, “Me̱ no̱ m-ru̱re̱, u̱rege̱ ye̱ reks temb, ta'ar-u̱t to̱a takan te̱p.” ");
INSERT INTO uth_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Bo̱ Ye̱so wo̱o̱nte̱ yow yow o-Urusharima ne̱ à, komo bo̱ wu̱ hyente̱ o̱ à, wu̱ 'wo̱nu̱ru̱ u̱n tu̱k-mo̱ u̱t-me̱n remen o̱, u̱n hun-ne̱ ne̱ ye̱ ro̱ n-me̱ à. ");
INSERT INTO uth_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Wu̱ ro̱ m-ze̱e̱, “U̱rege̱ no̱ nak caane̱ rii-yo he no̱ m-hante̱ she'et-de u̱n gwu̱gwu̱-mo̱ u̱r-hur à! Amba m-mo̱ka Shir wukute̱ no̱ yo, remen no̱ go̱ks me̱ á! ");
INSERT INTO uth_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Da-o̱ ro̱o̱n da-o̱ yan-yage̱-u̱t no̱ he no̱ m-rigu̱mse̱ à, ye̱ wo̱o̱ngsu̱ no̱ komo ye̱ hebu̱tu̱ no̱ ko̱ o̱ ke raag-o̱ komo no̱a ru á. ");
INSERT INTO uth_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Ye̱a ho no̱ u̱n yakar no̱ ne̱, komo ye̱ sabu̱rse̱ bo̱-o no̱, ko̱ o-pam a yage̱ yo n-to̱n u̱n yo ken yo á, remen no̱ baks da-o̱ Shir haane̱ wu̱ guut no̱ á!” ");
INSERT INTO uth_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Ka da-de Ye̱so haaru̱ n-me̱ u̱n Pyo-o̱ Shir. Wu̱ taknu̱ru̱ yan-se u̱n ya-m-o̱ u̱n ya-u̱t-baab ne̱. ");
INSERT INTO uth_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Wu̱ ro̱ ye̱ m-ze̱e̱, “A ge̱ne̱g u̱n Ma-to̱ Shir, ‘Hur-o re be-de u̱s-ko̱n de’ amba no̱ muute̱ o̱ be-de u̱n hyow-ne̱!” ");
INSERT INTO uth_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Ko̱ de ke ho̱-de Ye̱so yooste̱ u̱n Pyo-o̱ Shir. Gwo̱mo-ne̱ ye̱ u̱n ko̱n-se Shir, yan-Yoos-de o-karamsa, u̱n se̱k-ye̱ ne̱ co̱nu̱ru̱ ye̱ ho wu̱. ");
INSERT INTO uth_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Amba ye̱ hoks m-kum o-co̱w á, remen hun-ne̱ kap ro̱ wu̱ m-ho̱ge̱, ye̱ co̱n ye̱ ba'as u̱r-gom á. ");
INSERT INTO uth_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","De ken ho̱-de, Ye̱so ro̱ u̱n Pyo-o̱ Shir, wu̱ ro̱ m-yoose̱ u̱n hun-ne̱, komo wu̱ ro̱ u̱n rwo̱r u̱n ka Ma-to̱ Shir to̱, Ma-to̱ m-Re̱re̱m, Gwo̱mo-ne̱ ye̱ u̱n ko̱n-se Shir u̱n yan-Yoos-de o-karamsa ne̱, mo̱sse̱ u̱n se̱k-ye̱ ne̱, haanu̱ru̱. Ye̱ ze̱e̱ru̱ wu̱, ");
INSERT INTO uth_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","“Ru̱ru̱ te̱, ¿kene̱ o̱ o kume̱ gwo̱mo-to̱ u̱n no̱m u̱n ka rii-yo wo̱ m-no̱m à? ¿Wa ya'e̱ wo̱ ka 'wo̱ns-mo̱?” ");
INSERT INTO uth_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Ye̱so shasu̱ru̱ ye̱, “M-mo̱ka yage̱ u̱m cit no̱ o̱ ken cot-o̱: ");
INSERT INTO uth_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Ru̱ru̱ no̱ me̱, ¿wa u̱n wu̱ ne̱ to̱mne̱ Yohana Wan-Yo'os u̱n hun-ne̱ n-me̱ m-ho̱, ‘hun-ne̱’ ye̱, ko, ‘Shir’?” ");
INSERT INTO uth_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Ma-u̱t su̱nu̱ru̱ ye̱, “¿Ya ne̱ a he m-ze̱e̱? A ze'e̱, ‘Shir,’ wu̱a zee, ‘¿Remen yan o̱ u̱n ya no̱ go̱kste̱ Yohana?’ ");
INSERT INTO uth_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Komo a ze'e̱, ‘Hun-ne̱’ ye̱, kap ka bu̱u̱g-de u̱n hun-ne̱ dea ho na, remen ye̱ dekse̱ Yohanawan-Rwo̱r u̱n Ma-to̱ Shir wu̱.” ");
INSERT INTO uth_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Ka da-de ye̱ shasu̱ru̱, “Te̱ nap be-de o̱ rwu̱u̱ne̱ á.” ");
INSERT INTO uth_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Komo Ye̱so ze̱e̱ru̱ ye̱, “Me̱ ma man ru̱ru̱ no̱ ko kene̱ u̱m kume̱ 'wo̱ns-mo̱ u̱m ro̱tte̱ u̱n no̱m kaane̱ á.” ");
INSERT INTO uth_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Ye̱so ru̱ru̱ ka hun-ne̱ ye̱ ka sha-mo̱ u̱t-ma mo̱: “Wu̱ ken ne̱t-wu̱ go̱o̱g o-kat, wu̱ de̱ku̱ru̱ ya-to̱m, wu̱ wargu̱ru̱ o-hur wu̱ she'etu̱ndu̱ru̱ de̱e̱n. ");
INSERT INTO uth_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Bo̱ da-o̱ m-ce wo̱o̱nte̱ à, wu̱ to̱mu̱ru̱ ko-gu̱w-wu̱ u̱n wu̱ be-de u̱n ka ya-to̱m-ye̱, a ya'su̱nde̱ wu̱ yo ro̱ yo ma u̱n wu̱ à. Amba ka ya-to̱m-ye̱ bunu̱ru̱ ka ko-gu̱w-wu̱, komo wu̱ mu̱u̱nu̱ru̱ ba u̱n rii. ");
INSERT INTO uth_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Ka wa-o-kat-wu̱ dooru̱ m-to̱m u̱n wu̱ ken ko-gu̱w-wu̱, amba ka ya-to̱m-ye̱ bunu̱ru̱ wu̱ komo, ye̱ ya'u̱ wu̱ m-'e̱, wu̱ mu̱u̱nu̱ru̱ ba u̱n rii. ");
INSERT INTO uth_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Ka da-de, wu̱ to̱mu̱ru̱ atette̱-wu̱, ka ya-to̱m-ye̱ ho̱gu̱ssu̱ru̱ wu̱ m-hoog, ye̱ yandu̱ru̱ wu̱. ");
INSERT INTO uth_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Ka da-de, ko-ya-o-kat ze̱e̱ru̱, ‘¿Ya ne̱ u̱m he m-no̱m? Yage̱ u̱m tomot wà re wu̱ me̱ m-co̱n à u̱n hi u̱n de u̱n wu̱, u̱m nak ye̱a nomo wu̱ o-do̱ro̱tte̱!’ ");
INSERT INTO uth_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Amba bo̱ ka ya-to̱m-ye̱ hyambu̱te̱ wu̱ à, ye̱ ze̱e̱ru̱ hi u̱n de u̱n ye̱, ‘Wà-wu̱ u̱n ko-ya-o-kat-wu̱ ka. A ho no̱ wu̱, komo saw-to̱ u̱n ko-ya-o-kat myet a warag-u̱t ma na!’ ");
INSERT INTO uth_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Ye̱ ruutu̱ru̱ wu̱ n-riib o-kat, ye̱ ho̱o̱ru̱ wu̱.” Ye̱so citu̱ru̱ ye̱, “¿Ya ne̱ ka ko-ya-o-kat-wu̱ he ka yan-to̱m-ye̱ m-no̱m? ");
INSERT INTO uth_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Wu̱a haan wu̱ ho ka yan-to̱m-ye̱, wu̱ ya'as ye̱ ken ya-to̱m-ye̱ ka kat-o̱.” Bo̱ hun-ne̱ ho̱ge̱ kaane̱ à, ye̱ ze̱e̱ru̱, “Shir we̱n go̱n ka rii-yo!” ");
INSERT INTO uth_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Ye̱so gwo̱tu̱ru̱ ye̱, wu̱ citu̱ru̱, “¿Ya ne̱ ka Ma-to̱ Shir to̱ ro̱ m-ze̱e̱? ‘Ka pam-yo ya-u̱t-mà yage̱ à, yo jiishte̱ ye̱ ka m-'wo̱ns kap.’ ");
INSERT INTO uth_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Kap bo̱n wu̱ 'he̱be̱ u̱n ka pam-yo à wu̱a cagme̱, u̱rege̱ komo ka pam-yo he̱'e̱nte̱ n-to̱n u̱n ne̱t, yo à rugumse̱ wu̱.” ");
INSERT INTO uth_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Yan-Yoos-de o-karamsa u̱n Gwo̱mo-ne̱ ye̱ u̱n ko̱n-se Shir ne̱ co̱nu̱ru̱ ye̱ ship Ye̱so kane̱ remen ye̱ nepse̱ wu̱ rwo̱ro̱g ka sha-mo̱ u̱t-ma mo̱ remen ye̱, amba ye̱ ro̱ o-gye̱r o̱ u̱n hun-ne̱. ");
INSERT INTO uth_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Ye̱ ro̱ u̱n hoob-o̱ o-co̱w remen ye̱ zeet Ye̱so rwo̱ro̱g gom-de u̱r-ba'as. Ye̱ zwo̱pu̱ru̱ ye̱ ken ye̱ o-nu, ye̱ barag m-ze̱e̱ kashi u̱n hun-ne̱ ye̱ ro̱. Komo ye̱ to̱mu̱ru̱ ka hun-ne̱-ye̱ ceeb Ye̱so u̱s-cot, remen ye̱ bo̱bsu̱te̱ wu̱, be-u̱r Biratus, ko-Gwamna-wu̱ o-dak. ");
INSERT INTO uth_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Ya-m-se̱ge̱r u̱n Ye̱so ze̱e̱ru̱ wu̱, “Wa-u̱r-Yoos, te̱ nepse̱ kap yo o ze̱e̱, u̱n yo o yoose̱ ne̱ à, hond hond o̱. Te̱ nepse̱ wo̱ u̱n gwo̱t u̱n co á, amba rwo̱r o-nip o̱ u̱n yo Shir co̱ne̱ u̱n hun-ne̱ ne̱ à. ");
INSERT INTO uth_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Ru̱ru̱ te̱, ¿depete̱ te̱ top tar-o̱ u̱n ko-Gwo̱mo Sisar, gwo̱mo-to̱ o-dak o-Roma, ko te̱ to̱p á?” ");
INSERT INTO uth_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Amba Ye̱so hyanu̱ru̱ we̱e̱r-se u̱n ye̱, wu̱ ze̱e̱ru̱ ye̱, ");
INSERT INTO uth_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Kutu no̱ me̱ ka hwo̱r-yo a no̱me̱ o-kwo̱m à. ¿Co-o wan o̱, u̱n jin-u̱r wan ne̱ ro̱ kane̱?” Ye̱ shasu̱ru̱, “O̱ ma Sisar, ko-Gwo̱mo-wu̱ o-Roma.” ");
INSERT INTO uth_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Ye̱so ze̱e̱ru̱, “Remen kaane̱, ya'as no̱ ko-Gwo̱mo Sisar yo ro̱ yo ma u̱n wu̱ à, no̱ ya'as Shir yo ro̱ yo u̱n Shir à.” ");
INSERT INTO uth_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Ka hun-ne̱ ye̱ hoks Ye̱so m-ship u̱n ka ceeb-o̱ á, ye̱ re̱su̱ru̱ temb, ye̱ ro̱ u̱n barag-se u̱n shas-o̱ u̱n wu̱. ");
INSERT INTO uth_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Ye̱ ken Saduki-ne̱ ye̱, (ye̱ zee a ine̱ u̱t-marimar á), ye̱ haanu̱ru̱ be-u̱r Ye̱so. Ye̱ cit wu̱, ");
INSERT INTO uth_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Wa-u̱r-Yoos, Mosa ge̱ne̱g ka karamsa-o̱ rem te̱. ‘U̱rege̱ ne̱t marag wu̱ yage̱ ne'a ba u̱n yakar, hen-ne̱ u̱n ka ne̱t-wu̱ a ge ka ne'a-wu̱, remen ye̱ kumut yakar-ye̱ a he m-ze̱e̱ yakar-ye̱ u̱n ka wu̱ mare̱ à.’ ");
INSERT INTO uth_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","A zee ye̱ ken campo̱-ne̱ ye̱ ta'yoor, tato̱ u̱n ye̱ gaan, wu̱ ro̱ se̱k-wu̱ à gaag u̱t-ge wu̱ maru̱ru̱ ba wu̱ u̱n mat yakar. ");
INSERT INTO uth_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Wu̱ do̱nde̱ wu̱ à gaaru̱ ka ne'a-wu̱, ");
INSERT INTO uth_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Atette̱-wu̱ kaane̱, ka rii gaan-yo kumu̱ru̱ ye̱ kap ta'yoor, ye̱ marag ba u̱n wu̱ kume̱ wà á. ");
INSERT INTO uth_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","U̱r-ko̱m kap, ka ne'a-wu̱ maru̱ru̱. ");
INSERT INTO uth_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","M-mo̱ka, ¿ho̱-de margan-ne̱ he m-ine̱ à, ne'a-wu̱ waane̱ ka ne'a-wu̱ ro̱? Kap ta'yoor mo̱ u̱n ye̱, ye̱ gaag wu̱.” ");
INSERT INTO uth_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Ye̱so shasu̱ru̱ ye̱, “Hond hond o̱ hun-ne̱ ye̱ m-mo̱ka ge u̱t-ge. ");
INSERT INTO uth_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Amba campo̱-ne̱ u̱n ne'a-ne̱ ne̱ ye̱ Shir he m-'yons u̱t-marimar à, remen ye̱ she̱re̱g u̱n wu̱, ye̱ he de m-ga u̱t-ge, u̱n ká da-o̱ á. ");
INSERT INTO uth_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Ye̱a warag u̱ntu̱n yan-to̱m-ye̱ Shir, ye̱a mer á. Ye̱ ro̱ yakar-ye̱ Shir, remen ye̱ inu̱te̱ u̱t-marimar. ");
INSERT INTO uth_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Komo Mosa rwo̱ro̱g cas cas, margan-ne̱ a ine̱ u̱n ho̱o̱g ne̱. U̱n ka ma-to̱ wu̱ ge̱ne̱ bo̱ Shir no̱me̱ u̱t-ma u̱n wu̱ ne̱ à, u̱n ka be-de u̱n tu̱k-mo̱ u̱r-ran-de. Wu̱ ge̱ne̱g u̱nze Wan-Ko̱yan, ak hi u̱n de u̱n wu̱, wu̱ ro̱ ‘Shir Ibrahi, Shir Ishaku, komo Shir Yakubu.’ ");
INSERT INTO uth_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Wu̱ ro̱ Shir o̱ u̱n margan-ne̱ á, amba Shir o̱ u̱n yan-ho̱o̱g, remen be-de u̱n wu̱ kap yan-ho̱o̱g ye̱.” ");
INSERT INTO uth_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Ye̱ ken yan-Yoos-de o-karamsa ye̱ ze̱e̱ru̱, “Wa-u̱r-Yoos o̱, ka shas-o̱ ro̱ u̱r-bon ne̱!” ");
INSERT INTO uth_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Bo̱ u̱n kaane̱, yatt-wu̱ hokse̱ Ye̱so m-cit komo á. ");
INSERT INTO uth_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Ye̱so ze̱e̱ru̱ ye̱, “¿Re ne̱ ne̱ ye̱ zette̱ Kiristi raag-o Dawuda o̱? ");
INSERT INTO uth_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Dawuda u̱n hi u̱n de u̱n wu̱ ze̱e̱g u̱n taku̱rda-o̱ u̱n Se̱p-to̱ u̱r-Bo̱ngo̱n, “ ‘Yawe ze̱e̱g Go̱s-wu̱ re: “She'et u̱n ka be-de u̱t-gwo̱mo de, ");
INSERT INTO uth_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Har u̱m ru̱'u̱t yan-yage̱-u̱t ru waragte̱ rii-yo o he m-yawag u̱n na-u̱s ru à!” ’ ");
INSERT INTO uth_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Dawuda ak wu̱ ‘Go̱s-wu̱,’ komo ¿re o̱, wu̱ hette̱ m-warag ‘wà u̱n wu̱’?” ");
INSERT INTO uth_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Bo̱ hun-ne̱ kap ho̱gu̱te̱ wu̱ à, Ye̱so ze̱e̱ru̱ yan-neke̱-mo̱ u̱n wu̱, ");
INSERT INTO uth_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“No̱m no̱ ja u̱n yan-Yoos-de o-karamsa ne̱, ye̱ ro̱ m-co̱n ye̱ ma'as m-neke̱ u̱n co̱p-to̱ u̱r-bon ne̱, komo ye̱ co̱no̱g a gas ye̱, a hyen ye̱ u̱t-go̱s ne̱ be-de m-o̱ m-baab ne̱. Ye̱ ro̱ m-daag be-de u̱r-she'et de u̱r-bon u̱n kuke̱-to̱ u̱n yoos u̱n Ma-to̱ Shir, u̱n be-de jiishe̱ u̱r-bon ne̱ à da-o̱ u̱t-biki. ");
INSERT INTO uth_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Ye̱ ro̱ m-co̱w u̱n hur-to̱ u̱n gwo̱r-ne̱ ye̱ rumus ye̱ saw-to̱ u̱n ye̱, ka da-de komo ye̱ bargu̱ru̱ naas o-da de̱e̱n u̱n ko̱n-se Shir! Ko̱o̱b-de Shir he ye̱ m-'ya à dea jiish de u̱n ko̱ wu̱ ke!” ");
INSERT INTO uth_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Ye̱so rigu̱ru̱ wu̱ hyanu̱ru̱ hun-ne̱ yan-rii ro̱ u̱n hwo̱be̱ u̱n yar-mo̱ u̱n ye̱ u̱n be-de u̱r-e̱ss n-me̱ u̱n Pyo-o̱ Shir. ");
INSERT INTO uth_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Komo wu̱ hyanu̱ru̱ wu̱ ken ko-ko̱o̱b-wu̱ u̱n ko-gwo̱r-wu̱ ne'a jorbu̱te̱ ne̱ra yoor. ");
INSERT INTO uth_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Wu̱ ze̱e̱ru̱, “Me̱ no̱ m-ru̱re̱, kà ko-gwo̱r-wu̱ jiishte̱ ko̱ wu̱ ke m-yar, ");
INSERT INTO uth_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","remen ye̱ ka gasu̱nte̱ ye̱ yagne̱ yo kuse̱ à, amba wu̱, ko-ko̱o̱b u̱ntu̱n wu̱, ya'aste̱ kap yo ro̱ wu̱ à.” ");
INSERT INTO uth_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Ye̱ ken ye̱ yan-neke̱-m Ye̱so ro̱ u̱n ma-to̱ u̱n Pyo-o̱ Shir, o̱ ro̱ u̱r-bon de o-gwo̱t ne̱ u̱n ka ta'ar-to̱ a meete̱ o̱ à u̱n yar-mo̱ a ya'e̱ Shir ne̱ à. Ye̱so ze̱e̱ru̱, ");
INSERT INTO uth_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Kap ka yo no̱ hyane̱ à, da-o ro̱o̱n a yage̱ u̱r-ta'ar n-to̱n u̱n de ken de á, a wuksusse̱ ko de ke.” ");
INSERT INTO uth_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Ye̱ citu̱ru̱ wu̱, “Wa-u̱r-Yoos, ¿ya u̱n da-o̱ a he m-no̱m kaane̱? Komo ¿ya u̱n go̱n napa-o̱ te̱ he m-hyan, te̱ nept ka da-o̱ wo̱o̱nte̱?” ");
INSERT INTO uth_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Ye̱so ze̱e̱ru̱, “She'et no̱ zo̱ngse̱, no̱ yage̱ ko̱ wu̱ ke raks no̱ á. Hun-ne̱ de̱e̱n a haan u̱n jin u̱n de. Ye̱a haan, ye̱ zee, ‘Me̱ ro̱ wu̱, wu̱ Shir daagne̱ à!’ Komo, ‘Ka da-o̱ ro̱ yow yow!’ Amba no̱ do̱re̱ ye̱ á. ");
INSERT INTO uth_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","No̱ ho̱ge̱ o-gye̱r á, da-o̱ no̱ ho̱ge̱ ma-to̱ u̱r-gu̱n, m-barme̱ ne̱, se̱ a no̱mo̱g go̱n to̱ u̱r-takan, amba yan zee ko̱m-u̱r ro̱ yow yow á.” ");
INSERT INTO uth_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Wu̱ dooru̱ ye̱ m-ze̱e̱, “O-dak, o-dak ne̱ a dum, u̱t-gwo̱mo u̱t-gwo̱mo ne̱ komo kaane̱. ");
INSERT INTO uth_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Dak-o a nukte̱ o̱ ho hun-ne̱, me̱r, u̱s-go̱m ne̱ ko̱ kene̱, rii-yo o-gye̱r yo a take̱ m-hyan á, a hyen yo rwu̱nte̱ n-To̱n u̱n shir. ");
INSERT INTO uth_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Rii-yo ka rem-se nomot kaane̱, a ship no̱ a re̱e̱su̱ no̱ u̱r-ko̱o̱b, a heet no̱ u̱n kuke̱-to̱ u̱n yoos u̱n Ma-to̱ Shir be-de u̱n piish u̱t-ma, a ke no̱. A heet no̱ be-de u̱n gwo̱mo-ne̱ u̱n ya-o-dak-ne̱ remen no̱ me̱ m-do̱re̱. ");
INSERT INTO uth_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Kane̱ no̱ he m-kum o-da no̱ ru̱ru̱tu̱ ye̱ ma-u̱t re to̱ u̱r-bon. ");
INSERT INTO uth_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Zo̱ngu̱ no̱ ba da-o̱ u̱n wo̱o̱n, no̱ was bo̱ no̱ he hi u̱n no̱ m-ruut á, u̱rege̱ ye̱ ce'u̱tu̱ no̱ u̱t-ma. ");
INSERT INTO uth_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Remen man 'ye no̱ u̱t-gom, u̱s-we̱e̱r ne̱, bo̱ yan-yage̱-u̱t no̱ a hoks no̱ u̱n wakse̱ u̱n yo no̱ zee á. ");
INSERT INTO uth_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","A heet ce̱te̱nte̱-u̱s no̱ be-de u̱n ye̱ mate̱ no̱ à, hen-ne̱ no̱ u̱n baag-o no̱ ne̱, u̱n nay no̱ ne̱ ne̱, komo ye̱a ho ye̱ ken ye̱ be-u̱r no̱. ");
INSERT INTO uth_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Ko̱ wu̱ ke wu̱a yagu̱ no̱ rem re. ");
INSERT INTO uth_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Amba ko̱ o-hi o-gaan u̱n hi u̱n no̱ yoa he̱'e̱n á. ");
INSERT INTO uth_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","No̱ she̱re̱ be-de Shir no̱a kum ho̱o̱g-o̱ ba m-ta. ");
INSERT INTO uth_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Da-o no̱ hyene̱ ya-u̱r-gu̱n rigimsu̱te̱ o-Urusharima, ka da-de no̱a nep da-o ro̱ yow yow a sabu̱rsu̱te̱ o̱. ");
INSERT INTO uth_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Ka da-de ka ye̱ ro̱ u̱n dak-o̱ o-Judiya ye̱ som u̱t-haag, ka ye̱ ro̱ n-me̱ o-bo̱ à, ye̱ som, komo ye̱ rege̱ ye̱ ruuste̱ n-do̱ à, ye̱ warag n-me̱ o-bo̱ á. ");
INSERT INTO uth_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Remen ka ho̱-to̱, ‘Ho̱-to̱ u̱n swo̱ u̱r-ko̱o̱b to̱,’ remen a sho'oste̱ o-nip yo Ma-to̱ Shir zee à. ");
INSERT INTO uth_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Rii-yo u̱r-'wo̱n yo ne'a-ne̱ ya-u̱t-uub u̱n ka da-o, u̱n ye̱ ro̱ u̱n yakar re̱k-ye̱ ne̱ à! Rii-yo o-gye̱r a haan u̱n ka dak-o̱, komo Shir a hante̱ ryaab-se u̱n wu̱ u̱n ka hun-ne̱ ye̱ remen ba'as-de u̱n ye̱. ");
INSERT INTO uth_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","A ho ye̱ ken ye̱ be-de u̱r-gu̱n, komo a dek ye̱ ken ye̱ m-gu̱w ho̱no o-dak kap, komo ka ye̱ nape̱ Shir á ye̱a yawag o-Urusharima har da-o Shir he m-ze̱e̱ ye̱ yage̱ kaane̱ à.” ");
INSERT INTO uth_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Ye̱so aragtu̱ru̱ m-ze̱e̱, “A hyen saw-to̱ u̱t-hyat n-to̱n u̱r-ho̱, o-re̱ng u̱n re̱ge̱n-ne̱. U̱t-bo̱ ho̱no o-dak a no̱m o-zak á, hun-ne̱ a ho̱ge̱ gye̱r-o̱ u̱n nukte̱-mo̱ m-sa u̱n ryaab-se u̱n a hu̱-se m-ho̱ ne̱. ");
INSERT INTO uth_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Hun-ne̱ a bonse̱ remen gye̱r-o̱ u̱n yo he m-haan ho̱no o-dak à, Shir a nukt myet bo̱ u̱n rii-yo ro̱ u̱t-gwo̱mo ne̱ n-To̱n u̱n shir à. ");
INSERT INTO uth_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Ka da-de Wà-wu̱ u̱n ne̱t a mu̱u̱n, u̱ntu̱n o-ke'ente̱ m-'wo̱ns ne̱ de̱e̱n, komo o-mo̱k ne̱. ");
INSERT INTO uth_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Da-o̱ no̱ hyene̱ ka rii-yo cirig m-no̱m, ine̱ no̱ eso no̱ she̱r u̱r-be̱e̱b ne̱ no̱ jaks hi-u̱t no̱ n-To̱n, no̱ gu̱t Shir remen wu̱ ro̱ ma-to̱ u̱n gu u̱n no̱.” ");
INSERT INTO uth_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Ka da-de Ye̱so ru̱ru̱ ye̱ sha-mo̱ u̱t-ma: “Ceker no̱ 'yo-yo o-rum u̱n se̱ ken 'yo-se ne̱. ");
INSERT INTO uth_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Da-o̱ no̱ hyene̱ se̱ cirig m-tu̱pe̱, no̱ nak sho-o no̱mo̱g yow yow. ");
INSERT INTO uth_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Kang-o gaan, da-o̱ no̱ hyene̱ ka rii-yo ro̱ m-no̱m, no̱ nep u̱nze gwo̱mo-to̱ Shir ro̱ ma-to̱ m-wo̱o̱n. ");
INSERT INTO uth_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Me̱ no̱ m-ru̱re̱ o-nip, hun-ne̱ ye̱ ro̱ u̱n ho̱o̱g ne̱ m-mo̱ka à ye̱a wo m-mar kap á, se̱ ka yo u̱m zee mo̱sse̱ o-bo̱ o̱ o-Urusharima ne̱ à shiig. ");
INSERT INTO uth_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","O-To̱n o-dak ne̱ a tees, amba ma-u̱t re a te á. ");
INSERT INTO uth_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“We̱r no̱! No̱ shoos hi u̱n no̱ u̱t-biki á, m-swo̱ ne̱ komo u̱n ceker-se u̱n ho̱o̱g ne̱ á. Me̱ u̱n zee kaane̱ remen ka ho̱-de a 'wo̱s no̱ ba no̱ u̱n nap ");
INSERT INTO uth_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","u̱ntu̱n ce̱e̱b. Remen de a haan ho̱no o-dak kap de 'wo̱s ko̱ wu̱ ke wu̱ ro̱ u̱n ho̱o̱g ne̱ n-dak à. ");
INSERT INTO uth_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Zo̱ngu̱ no̱, komo no̱ ko̱n ko̱ de ke ho̱-de, remen no̱ kumut be̱e̱b-de m-ru u̱n kap yo he m-haan à, komo no̱ est u̱n co-o u̱n Wà-wu̱ u̱n ne̱t.” ");
INSERT INTO uth_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Ko̱ de ke ho̱-de Ye̱so ro̱ m-yoos u̱n Pyo-o̱ Shir, ko̱ mo̱ ke rim-mo̱ wu̱ ro m-ha Haag-o̱ u̱n 'yo-se o-Ze̱tun taasu̱ m-te̱t wu̱ ro u̱n ko̱n-se Shir. ");
INSERT INTO uth_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Ko̱ de ke ho̱-de n-sot hun-ne̱ kap ro̱ m-ha u̱n Pyo-o̱ Shir, remen ye̱ ho̱gu̱té̱ wu̱. ");
INSERT INTO uth_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Da-o ro̱ yow yow o̱ u̱n Biki-o̱ u̱t-Buro̱di to̱ ba m-Yist o̱ hun-ne̱ m-aag Biki-o̱ m-Pas à. ");
INSERT INTO uth_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Gwo̱mo-ne̱ ye̱ u̱n ko̱n-se Shir u̱n yan-Yoos-de o-karamsa ne̱ ro̱ u̱n gye̱r-o̱ u̱n hun-ne̱, remen kaane̱ ye̱ co̱wu̱ru̱ hoob-o̱ u̱n bu̱-se ye̱ hette̱ ho̱ u̱n Ye̱so ba hun-ne̱ u̱n nap à. ");
INSERT INTO uth_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Ko-Gwo̱mo-wu̱ u̱n ya-u̱t-ko̱t co̱wu̱ru̱ u̱n hur-u̱r Yahudas, wu̱ a m-ze̱e̱ Iskariyoti à, wan-gaan be-de yan-neke̱-m Ye̱so o̱p u̱n yoor 12. ");
INSERT INTO uth_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Yahudas haaru̱, wu̱ no̱mu̱ru̱ u̱t-ma u̱n Gwo̱mo-ne̱ ye̱ u̱n ko̱n-se Shir u̱n caari-ne̱ ne̱ yan-'er-de u̱n Pyo-o̱ Shir bo̱ wu̱ he ye̱ m-bo̱pse̱ u̱n Ye̱so à. ");
INSERT INTO uth_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Zak-o ho̱o̱ru̱ ye̱, ye̱ ze̱e̱ru̱ ye̱a top wu̱ hwo̱r. ");
INSERT INTO uth_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Yahudas e̱su̱ru̱ kaane̱, komo wu̱ taknu̱ru̱ hoob-o̱ u̱n da-o̱ jiishe̱ u̱r-bon à, o̱ wu̱ hette̱ ye̱ m-bo̱pse̱ u̱n Ye̱so à, ba hun-ne̱ u̱n nap. ");
INSERT INTO uth_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Da-o̱ u̱n Biki-o̱ u̱t-Buro̱di to̱ ba m-Yist wo̱o̱nu̱ru̱ da-o̱ a he pan u̱n ca-yo u̱r-seke̱ yo u̱n rii-yo m-re̱ yo Biki-o̱ m-Pas à. ");
INSERT INTO uth_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Ye̱so to̱mu̱ru̱ Bitrus u̱n Yohana, wu̱ ze̱e̱ru̱, “Ha no̱ zo̱nge̱ no̱ nom rii-yo m-re̱ yo u̱n Biki-o̱ m-Pas a reet no̱!” ");
INSERT INTO uth_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Ye̱ citu̱ru̱ wu̱, “¿Ke ne̱ o̱, o co̱ne̱ te̱ nom ka rii-yo m-re̱ yo?” ");
INSERT INTO uth_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Wu̱ shasu̱ru̱, “Bo̱ no̱ m-co̱w o-bo̱ à, no̱a gonte̱ wu̱ ken ne̱t-wu̱ de̱kne̱ de̱de̱-o̱ m-ho̱ à. Do̱ru̱ no̱ wu̱ u̱n hur-o̱ wu̱ cu̱wte̱ à. ");
INSERT INTO uth_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","No̱ zee ka wa-o-hur wu̱: ‘Wa-u̱r-Yoos ze̱e̱g te̱ cit wo̱, ¿o̱ ke kuke̱-o̱ yan-neke̱-m re u̱n me̱ ne̱ hette̱ m-re̱ rii-yo m-re̱ yo u̱n Biki-o̱ m-Pas?’ ");
INSERT INTO uth_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Wu̱a kutu no̱ caari-o̱ o-kuke̱ o̱ a ma'e̱ n-to̱n u̱n o̱r u̱n o̱ à, kane̱ no̱ he na no̱me̱ u̱n rii-yo m-re̱.” ");
INSERT INTO uth_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Ye̱ ruuru̱ komo ye̱ 'wo̱ssu̱ru̱ rii hond hond bo̱ Ye̱so ru̱ru̱ ye̱ à. Komo ye̱ no̱mu̱ru̱ rii-yo m-re̱ yo Biki-o̱ m-Pas. ");
INSERT INTO uth_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Bo̱ da-o wo̱o̱nte̱ à, Ye̱so she'etu̱ru̱ be-de u̱n re̱ rii-yo m-re̱ u̱n yan-to̱m-ye̱ u̱n wu̱ ne̱. ");
INSERT INTO uth_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Wu̱ ze̱e̱ru̱ ye̱, “U̱m co̱no̱g de̱e̱n, u̱m re ka rii-yo m-re̱ yo u̱n Biki-o̱ m-Pas o̱ u̱n no̱ ne̱, ka da-de u̱m swo̱o̱ru̱ u̱r-ko̱o̱b! ");
INSERT INTO uth_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Me̱ no̱ m-ru̱re̱, man re yo komo á, se̱ da-o Shir ko̱me̱ gwu̱-o̱ u̱n hun-ne̱ ye̱ u̱n wu̱ à.” ");
INSERT INTO uth_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Ka da-de Ye̱so de̱ku̱ru̱ u̱r-ibitte̱ de m-mo̱di, wu̱ bo̱mu̱ru̱ Shir. Wu̱ ze̱e̱ru̱, “De̱k no̱, no̱ wong. ");
INSERT INTO uth_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Me̱ no̱ m-ru̱re̱ m-mo̱ka har ma co, man su̱ ka 'wu̱u̱r-o̱ á, se̱ gwo̱mo-to̱ Shir wo̱o̱nte̱.” ");
INSERT INTO uth_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Ka da-de wu̱ de̱ku̱ru̱ u̱r-buro̱di wu̱ bo̱mu̱ru̱ Shir, wu̱ catu̱ru̱ de. Wu̱ ya'su̱ru̱ ye̱, wu̱ ro̱ m-ze̱e̱, “Wu̱r-o re o̱ ka o̱ u̱m seke̱, rem no̱ à. Se̱ngu̱ no̱ m-no̱m kaane̱ no̱ ma'aste̱ me̱ m-baks.” ");
INSERT INTO uth_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Kang-o gaan, wu̱ yasu̱ ye̱ ka ibitte̱-de da-o̱ ye̱ reese̱ rii-yo m-re̱ à. Wu̱ ro̱ m-ze̱e̱, “Ka ibitte̱-de swo̱r o-nu o̱ o-pu̱ o̱ dea e̱s u̱n hyó-m re, mo̱ a wu̱u̱se̱ rem no̱ à. ");
INSERT INTO uth_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","“Gwo̱t no̱! Ka wu̱ he me̱ m-bo̱pse̱ be-de ya-u̱t-yage̱ à, wu̱ ro̱ kane̱ u̱n me̱ ne̱ be-de u̱n rii-yo m-re̱! ");
INSERT INTO uth_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Wà-wu̱ u̱n ne̱t wu̱a mer bo̱ Shir e̱sse̱ à. Amba ka wu̱ yase̱ Wà-wu̱ u̱n ne̱t, wu̱a warag rii-yo u̱r-'wo̱n!” ");
INSERT INTO uth_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Ye̱ taknu̱ru̱ citu̱n hi u̱n de u̱n ye̱, “¿Wan wu̱ ne̱ be-u̱r na, wu̱ he no̱m u̱n ka rii-yo à?” ");
INSERT INTO uth_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Ma-u̱t su̱nu̱te̱ be-de u̱n yan-neke̱-m Ye̱so, to̱ u̱n wu̱ he go̱s-wu̱ à, be-de u̱n ye̱. ");
INSERT INTO uth_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Ye̱so ze̱e̱ru̱ ye̱, “Gwo̱mo-ne̱ ye̱ u̱n ya-o-dak, ye̱ ro̱ ye̱ m-kute̱ m-'wo̱ns. Komo ka gwo̱mo-ne̱ ye̱ ro̱ m-ze̱e̱ u̱n hi u̱n de u̱n ye̱, ‘Nay-ne̱ ye̱ u̱n ka hun-ne̱ ye̱.’ ");
INSERT INTO uth_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Kaane̱ no̱ he m-nom, go̱s-wu̱ be-u̱r no̱, se̱ wu̱ waragte̱ re̱k-wu̱, komo wa u̱n co, se̱ wu̱ muute̱ hi u̱n de u̱n wu̱ u̱ntu̱n ko-gu̱w. ");
INSERT INTO uth_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","¿Wa ro̱ go̱s-wu̱ ne̱, ka wu̱ she'ete̱ wu̱ reete̱, ko wu̱ no̱me̱ wu̱ hante̱ à? Wu̱ she'ette̱ wu̱ reet à. Amba u̱m ro̱ be-u̱r no̱ u̱ntu̱n wu̱ no̱me̱ wu̱ hante̱ à. ");
INSERT INTO uth_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“No̱ ro̱ u̱n me̱ ne̱ kap bo̱ u̱n meger-u̱t re. ");
INSERT INTO uth_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Komo bo̱ Tato re sagbu̱ me̱ u̱t-gwo̱mo à, kaane̱ u̱m sagbu̱ no̱. ");
INSERT INTO uth_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","No̱a re̱ no̱a su̱ da-o̱ u̱n gwo̱mo-u̱t re, komo no̱a she'et u̱t-comos remen no̱a piish ma-to̱ u̱n ka baag-u̱t o̱p u̱t-yoor 12 to̱, to̱ o-Isra. ");
INSERT INTO uth_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","“Bitrus, Bitrus! Ho̱ge̱! Ko-Gwo̱mo-wu̱ u̱n ya-u̱t-ko̱t ko̱no̱g a 'ye wu̱ o-da wu̱ megertu̱ no̱ kap, a wongte̱ yo u̱r-bon, u̱n yo ba u̱r-bon ne̱, bo̱ ya-to̱m ro̱ u̱n wong u̱n hyo u̱n kwa ne̱ à. ");
INSERT INTO uth_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Amba u̱m ko̱no̱g rem ru, bo̱ wo̱a tuku me̱ o-cin á. Komo o she̱r be u̱n de, o ru̱ o̱r ru ne̱ jaab-o̱ u̱t-me̱n.” ");
INSERT INTO uth_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Bitrus shasu̱ru̱, “Go̱s-wu̱, u̱m ro̱ zo̱ngse̱ a ke'et me̱ u̱n wo̱ ne̱, u̱m meret komo u̱n wo̱ ne̱!” ");
INSERT INTO uth_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Ye̱so ze̱e̱ru̱, “Bitrus, me̱ wo̱ m-ru̱re̱, wo̱a no̱m she'-m re o-tet rii-o̱ ke̱e̱g-yo o-kiit kenet.” ");
INSERT INTO uth_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Ka da-de Ye̱so citu̱ru̱ yan-neke̱-mo̱ u̱n wu̱. “Bo̱ u̱m tomu̱ no̱ ka da-de ba u̱n ba-de u̱n hwo̱r, ba o-ba, ba u̱t-ka'ante̱, ¿ya u̱n yo no̱ taage̱?” Ye̱ shasu̱ru̱, “Ko rii.” ");
INSERT INTO uth_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Ye̱so ze̱e̱ru̱, “Amba m-mo̱ka, bo̱ u̱n wu̱ ro̱ u̱n ba-de u̱n hwo̱r ne̱ à, ko o-ba, wu̱ dek, komo bo̱ u̱n wu̱ ro̱ ba o-magay à wu̱ beeb matuku-de u̱n wu̱, wu̱ o o-gaan. ");
INSERT INTO uth_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","No̱m no̱ yo, remen Ma-to̱ Shir to̱ ze̱e̱g, ‘A muut wu̱ ko-ya-u̱r-ba'as,’ se̱ to̱ waragte̱ o-nip, remen to̱ a ge̱ne̱ u̱t-ma re à to̱a mit o-nip.” ");
INSERT INTO uth_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Yan-neke̱-mo̱ u̱n wu̱ ze̱e̱ru̱, “Gwo̱t! Go̱s-wu̱, magay-u̱t yoor-to̱ ka!” Wu̱ shasu̱ru̱, “To̱ bo̱'o̱su̱te̱!” ");
INSERT INTO uth_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Ye̱so yagu̱ru̱ o-bo̱ wu̱ ruuru̱, bo̱ wu̱ we̱te̱ m-nom à, n-to̱n Haag-o̱ u̱n 'yo-se o-Ze̱tun, yan-neke̱-mo̱ u̱n wu̱ neku̱ru̱ u̱n wu̱ ne̱. ");
INSERT INTO uth_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Bo̱ wu̱ wo̱ ka be-de à, wu̱ ze̱e̱ru̱ ye̱, “Ko̱n no̱ bo̱ a meger no̱ á.” ");
INSERT INTO uth_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Ka da-de wu̱ argu̱ru̱ wu̱ yage̱ ye̱ u̱ntu̱n hew-de u̱n jor-o̱ u̱r-ta'ar, komo wu̱ kwu̱ktu̱ru̱ n-dak, wu̱ ko̱nu̱ru̱ Shir. ");
INSERT INTO uth_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Wu̱ ze̱e̱ru̱, “Tato re, u̱rege̱ o co̱no̱g, wo̱ yage̱ me̱ m-su̱u̱t ka ko̱o̱b-de á. Anze u̱n co̱n-m re á, amba no̱m bo̱ o co̱ne̱ à.” ");
INSERT INTO uth_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Ko wan-to̱m-wu̱ Shir haanu̱ru̱ be-de u̱n wu̱, wu̱ dooru̱ wu̱ m-'wo̱ns. ");
INSERT INTO uth_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","U̱n tu̱k-mo̱ u̱t-me̱n, wu̱ ko̱ne̱ Shir arge̱ n-ga, su̱samb-mo̱ u̱n wu̱ ro̱ m-he̱'e̱n n-dak u̱ntu̱n m-hyó. ");
INSERT INTO uth_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Bo̱ wu̱ ine̱ be-de u̱s-ko̱n à, wu̱ wargu̱ru̱ be-de u̱n yan-neke̱-mo̱ u̱n wu̱. Wu̱ 'wo̱s ye̱ ro̱ m-rew, ye̱ karag remen hur-de u̱n ye̱ naasu̱te̱. ");
INSERT INTO uth_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Wu̱ ze̱e̱ru̱ ye̱, “¿Remen yan o̱ no̱ ro̱tte̱ m-rew? Ine̱ no̱, no̱ ko̱n Shir bo̱ a meger no̱ á.” ");
INSERT INTO uth_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Ye̱so ro̱ u̱t-ma, bu̱u̱g-de u̱n hun-ne̱ wo̱o̱nu̱ru̱. Wan-gaan be-de u̱n ka o̱p u̱n yoor 12 ye̱, jin-de u̱n wu̱ Yahudas tekne̱te̱ ye̱ co. Wu̱ haanu̱ru̱ be-u̱r Ye̱so wu̱ hamtu̱ru̱ wu̱. ");
INSERT INTO uth_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Amba Ye̱so ze̱e̱ru̱, “Yahudas, ¿u̱r-hamat o̱, o he bo̱pse̱ u̱n ya-u̱t-yage̱ Wà-wu̱ u̱n ne̱t?” ");
INSERT INTO uth_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Bo̱ yan-neke̱-m Ye̱so ye̱ ro kane̱ à, hyane̱ yo he m-no̱m à, ye̱ citu̱ru̱ Ye̱so, “Go̱s-wu̱, ¿te̱ dum u̱n ye̱ ne̱ u̱n magay-u̱t te̱?” ");
INSERT INTO uth_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Wan-gaan be-de u̱n ye̱, kupsu̱ru̱ to̱-o̱ u̱n so̱ u̱n kom-o̱ u̱r-re̱ o̱ u̱n ko-gu̱w-wu̱ u̱n ko-Gwo̱mo-wu̱ u̱n ko̱n-se Shir. ");
INSERT INTO uth_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Amba Ye̱so ze̱e̱ru̱, “Yagu̱ no̱ kaane̱!” Wu̱ ci'u̱ru̱ to̱-o̱ u̱n ka ne̱t-wu̱, wu̱ dapu̱ru̱ o̱. ");
INSERT INTO uth_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Ka da-de Ye̱so ze̱e̱ru̱ ko-Gwo̱mo-wu̱ u̱n ko̱n-se Shir, u̱n caari-wu̱ u̱n yan-'er-de u̱n Pyo-o̱ Shir ne̱ u̱n se̱k-ye̱ ne̱, ye̱ haane̱ kane̱ ye̱ shipt wu̱ à. “¿Remen yan o̱ no̱ haante̱ u̱t-magay ne̱, u̱t-ko̱ ne̱, sa o zee me̱ ko-hyow-wu̱? ");
INSERT INTO uth_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","U̱m ro u̱n no̱ ne̱, ko̱ o̱ ke da-o̱ u̱n Pyo-o̱ Shir, komo no̱ meger no̱ shipt me̱ á. Amba da-o̱ no̱ o̱ ka da-o yan-me̱n-u̱t jaas-to̱ ro̱ u̱t-gwo̱mo à.” ");
INSERT INTO uth_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Ye̱ shipu̱ru̱ Ye̱so, ye̱ neku̱ru̱ u̱n wu̱ ne̱, u̱n hur-o̱ u̱n ko-Gwo̱mo-wu̱ u̱n ko̱n-se Shir, Bitrus ro̱ ye̱ m-do̱re̱ n-jim u̱r-hew ne̱. ");
INSERT INTO uth_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Yan-hwo̱'o̱t o-ra do̱'o̱g o-ra u̱n te̱te̱-o̱ u̱n hur-o̱ u̱n ko-Gwo̱mo-wu̱ u̱n ko̱n-se Shir, komo Bitrus ro̱ kane̱. ");
INSERT INTO uth_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Da-o wan-gaan ne'a be-de u̱n gu̱w-ne̱, hyane̱ wu̱ tara kane̱ be-de o-ra à. Ka ne'a-wu̱ tuuru̱ wu̱ yish. Wu̱ ze̱e̱ru̱, “Ka ne̱t-wu̱ ma wan-neke̱-m Ye̱so wu̱!” ");
INSERT INTO uth_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Amba Bitrus she'u̱ru̱, “Ne'a, me̱ nap ka ne̱t-wu̱ á!” ");
INSERT INTO uth_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","O-da hiin, wu̱ ken ne̱t-wu̱ ze̱e̱ru̱ Bitrus, “Wo̱ ma wan-gaan-wu̱ be-de u̱n ye̱!” Amba Bitrus shasu̱ru̱, “Ka ne̱t-wu̱, me̱ wu̱ á!” ");
INSERT INTO uth_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Bo̱ da-o jimite̱ komo à. Wu̱ ken ne̱t-wu̱ she̱ru̱ru̱ gu̱ng, wu̱ ze̱e̱ru̱. “She-m mo̱ ko̱n á, ka ne̱t-wu̱ ro̱ u̱n do̱re̱ u̱n Ye̱so, remen wu̱ ma ko-ya-o-Gariri-wu̱!” ");
INSERT INTO uth_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Amba Bitrus shasu̱ru̱, “Ka ne̱t-wu̱, me̱ nap yo wo̱ m-rwo̱r á!” Da-o gaan, wu̱ ro̱ u̱t-ma, kiit-o kanu̱ru̱. ");
INSERT INTO uth_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Ye̱so waktu̱ru̱ u̱s-ajima ne̱ wu̱ gwo̱tu̱ru̱ Bitrus, komo Bitrus baksu̱ru̱ Ye̱so ze̱e̱g wu̱, “Wo̱a nom she'e-m re o-tet rii-yo o-kiit yo kenet.” ");
INSERT INTO uth_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Bitrus jogu̱ru̱ u̱s-kan. ");
INSERT INTO uth_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Ka hun-ne̱ ye̱, ye̱ ro̱ u̱n er-u̱r Ye̱so à, ye̱ no̱mu̱ru̱ wu̱ u̱r-ar, u̱s-so̱ro̱g ne̱, ye̱ co̱psu̱ru̱ wu̱ m-ta. ");
INSERT INTO uth_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Ye̱ ho̱kku̱ru̱ wu̱ u̱r-magund u̱n yish. Ye̱ citu̱ru̱ wu̱, “¿Wa wo̱su̱ wo̱? Rwo̱r!” ");
INSERT INTO uth_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Komo ye̱ nomu̱ru̱ wu̱ ma-to̱ u̱n naas u̱t-me̱n. ");
INSERT INTO uth_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Bo̱ ish geste̱ à, se̱k-ye̱, u̱n Gwo̱mo-ne̱ ye̱ u̱n ko̱n-se Shir ne̱, u̱n yan-Yoos-de o-karamsa ne̱ mo̱rgu̱ru̱ be-u̱r gaan, komo a hantu̱ru̱ Ye̱so be-de u̱n ka Mo̱ro̱g-de u̱n Se̱k-ye̱ de. ");
INSERT INTO uth_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Ye̱ zee, “Ru̱ru̱te̱, ¿wo̱ ‘Kiristi’?” Wu̱ shasu̱ru̱, “Me̱ ru̱ru̱ no̱, no̱a dek á. ");
INSERT INTO uth_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","U̱rege̱ komo u̱m cikt no̱, no̱ hede me̱ m-shas á. ");
INSERT INTO uth_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Amba m-mo̱ka, har u̱n co, Wà-wu̱ u̱n ne̱t a she'et u̱r-re̱ de u̱n Shir be-de u̱t-gwo̱mo.” ");
INSERT INTO uth_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Ye̱ ze̱e̱ru̱ kap, “¿Wo̱ wu̱ ro̱, Wà-wu̱ Shir?” Wu̱ shasu̱ru̱ ye̱, “No̱ ze̱e̱g hond hond.” ");
INSERT INTO uth_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Ye̱ ze̱e̱ru̱ komo, “Te̱ co̱n ye̱ he te̱ m-su̱'e̱ á! Te̱ u̱n hi u̱n te̱, te̱ ho̱gu̱te̱ yo wu̱ ze̱e̱ à!” ");
INSERT INTO uth_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Ka bu̱u̱g-de u̱n hun-ne̱ de inu̱ru̱ kap ye̱ heetu̱ru̱ Ye̱so be-u̱r Biratus ko-Gwamna. ");
INSERT INTO uth_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Kane̱ ye̱ takne̱ wu̱ sakke̱ u̱t-ba'as. “Te̱ shipk ka ne̱t-wu̱, wu̱ ro̱ u̱n e̱gu̱sse̱ u̱n hun-ne̱ na, wu̱ ro̱ ye̱ m-ze̱e̱, ye̱ to̱p ko-Gwo̱mo Sisar tar-o̱ u̱n ho̱no o-dak á, komo wu̱ ro̱ m-ze̱e̱, wu̱ ro̱ ko-Gwo̱mo te̱, Kiristi.” ");
INSERT INTO uth_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Biratus citu̱ru̱ wu̱, “¿Wo̱ ro̱ ko-Gwo̱mo-wu̱ u̱n Yahuda-ne̱?” Ye̱so shasu̱ru̱, “O ze̱e̱g kaane̱.” ");
INSERT INTO uth_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Ka da-de Biratus ze̱e̱ru̱ Gwo̱mo-ne̱ ye̱ u̱n ko̱n-se Shir u̱n bu̱u̱g-de u̱n hun-ne̱, “Me̱ hyan ba'as-de u̱n ka ne̱t-wu̱ á.” ");
INSERT INTO uth_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Amba ye̱ e̱ks m-'wo̱ns ne̱, “Yoos-de u̱n wu̱ ro̱ m-hante̱ 'yons u̱r-hi be-de u̱n hun-ne̱ ye̱ o-Judiya. Wu̱ takante̱ o-Gariri wu̱ ka wo̱o̱ne̱ komo kane̱.” ");
INSERT INTO uth_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Da-o̱ ko-Gwamna Biratus ho̱ge̱ de ka à, wu̱ citu̱ru̱, “¿Ko-ya-o-Gariri-wu̱, ka ne̱t-wu̱?” Ye̱ shasu̱ru̱, “E̱e̱.” ");
INSERT INTO uth_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Bo̱ wu̱ nepte̱ Ye̱so rwu̱u̱nte̱ so̱ u̱n dak-o̱ u̱n gwo̱mo-u̱t Here̱ Atipas à, wu̱ ze̱e̱ru̱ ye̱ heet Ye̱so be-u̱r Here̱, wu̱ ro o-Urusharima ka da-de à. ");
INSERT INTO uth_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Bo̱ Here̱ hyente̱ Ye̱so à, wu̱ no̱mu̱ru̱ o-zak remen wu̱ ho̱gu̱te̱ ma-to̱ u̱n wu̱, komo wu̱ ro u̱r-'er de̱e̱n wu̱ hyenet wu̱. Wu̱ ho̱k wu̱ hyenet Ye̱so ro̱ u̱n no̱m u̱t-hyat. ");
INSERT INTO uth_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Here̱ citu̱ru̱ Ye̱so u̱s-cot de̱e̱n, amba wu̱ shas á. ");
INSERT INTO uth_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Gwo̱mo-ne̱ ye̱ u̱n ko̱n-se Shir u̱n yan-Yoos-de o-karamsa ne̱ ro̱ co, ye̱ hururu̱ u̱t-gaag, ye̱ ze̱e̱ru̱ Ye̱so no̱mo̱g rii-yo depe̱ á. ");
INSERT INTO uth_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Here̱ u̱n karma-ne̱ u̱n wu̱ ne̱ no̱mu̱ru̱ Ye̱so u̱r-ar. Ka da-de ye̱ tu̱pu̱ru̱ Ye̱so co̱p-o̱ u̱t-gwo̱mo ye̱ muutu̱ru̱ wu̱ be-u̱r Biratus. ");
INSERT INTO uth_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Ka ho̱-de Here̱ ne̱ u̱n Biratus no̱mu̱ru̱ u̱r-nay, n-ga ye̱ ro m-she'et be-u̱r gaan á. ");
INSERT INTO uth_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Biratus mo̱ro̱gsu̱ru̱ Gwo̱mo-ne̱ ye̱ u̱n ko̱n-se Shir u̱n caari-ye̱ ne̱ u̱n hun-ne̱ ne̱. ");
INSERT INTO uth_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Wu̱ ze̱e̱ru̱ ye̱, “No̱ hantu̱te̱ ka ne̱t-wu̱ be u̱n de. No̱ zee wu̱ ro̱ u̱n e̱gu̱sse̱ u̱n hun-ne̱. M-mo̱ka u̱m me'este̱ wu̱ u̱n co no̱. Komo me̱ hyan wu̱ u̱r-ba'as ne̱ de no̱ ze̱e̱ á. ");
INSERT INTO uth_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Komo Here̱ wu̱ hyan ba'as-de u̱n wu̱ á, wu̱ hantu̱te̱ wu̱ be u̱n na. Ka ne̱t-wu̱ no̱m rii-yo wo̱o̱ m-mar á. ");
INSERT INTO uth_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","17","Remen kaane̱ man ru̱ a nomu̱ wu̱ u̱s-so̱ro̱g, u̱m ho'os wu̱.” ");
INSERT INTO uth_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Bu̱u̱g-de u̱n hun-ne̱ 'yonsu̱ru̱ u̱s-co̱r kang-o gaan, “Ho̱ wu̱! Hosu̱ndu̱ te̱ Barabas!” ");
INSERT INTO uth_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(A u̱n ka Barabas remen wu̱ hantu̱te̱ u̱r-gu̱n n-me̱ o-bo̱, wu̱ hoom komo hun-ne̱.) ");
INSERT INTO uth_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Biratus ro co̱no̱g wu̱ ho'os Ye̱so, wu̱ ru̱ru̱ hun-ne̱ komo. ");
INSERT INTO uth_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Amba ye̱ 'yonsu̱ru̱ u̱s-co̱r, “A kem wu̱! A kem wu̱!” ");
INSERT INTO uth_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Biratus ze̱e̱ru̱ ye̱ atette̱-o̱, “Amba, ¿ya u̱n ba'as-de wu̱ no̱m? Me̱ hyan rii-yo wu̱ no̱me̱ yo wo̱o̱ m-mar á! Man ru̱ a no̱mu̱ wu̱ u̱s-so̱ro̱g a ho'os wu̱.” ");
INSERT INTO uth_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Amba ye̱ dooru̱ 'yons u̱s-co̱r n-to̱n a kem Ye̱so, komo ka yan-'yons u̱s-co̱r ye̱ re̱e̱ru̱ u̱r-ho̱. ");
INSERT INTO uth_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Remen kaane̱ Biratus ze̱e̱ru̱, a no̱me̱ Ye̱so, yo ye̱ co̱ne̱ à. ");
INSERT INTO uth_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Wu̱ hosu̱ndu̱ru̱ ye̱ wu̱ ye̱ co̱ne̱ à, wu̱ a ka'e̱ remen gu̱n-de wu̱ hante̱ o-bo̱ à u̱n hoom u̱n hun-ne̱ ne̱, komo wu̱ yasu̱ru̱ ye̱ Ye̱so, ye̱ no̱m yo ye̱ co̱ne̱ à u̱n wu̱ ne̱. ");
INSERT INTO uth_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Karma-ne̱ deku̱ru̱ Ye̱so ye̱ ruuru̱ u̱n wu̱ ne̱. Bo̱ ye̱ ro m-neke̱ à, ye̱ go̱ntu̱ru̱ wu̱ ken ne̱t-wu̱ rwu̱nte̱ o-Kire̱ni jin-de u̱n wu̱ Simo̱n, wu̱ ro̱ m-co̱wo̱n o-bo̱ u̱n ka dak-o̱. Ye̱ bo̱pu̱ru̱ wu̱, ye̱ rwo̱'u̱ru̱ wu̱ de̱k u̱n ka kan-o̱, u̱n jim-u̱r Ye̱so. ");
INSERT INTO uth_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Bu̱u̱g-de u̱n hun-ne̱ de̱e̱n do̱ru̱ru̱ wu̱, ye̱ ken ne'a-ne̱ ye̱ ro n-me̱ ye̱ ro̱ u̱s-kan. Ye̱ ro̱ m-ho̱ge̱ 'wo̱n-u̱r Ye̱so. ");
INSERT INTO uth_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Ye̱so waktu̱ru̱, wu̱ gwo̱tu̱ru̱ ye̱. Wu̱ ze̱e̱ru̱ ye̱, “Ne'a-ne̱ ye̱ o-Urusharima! No̱ 'wo̱n rem re á, amba 'wo̱n no̱ rem no̱, u̱n yakar no̱ ne̱. ");
INSERT INTO uth_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Me̱ no̱ m-ru̱re̱ ho̱-u̱r ro̱o̱n, da-o̱ hun-ne̱ he m-ze̱e̱, ‘Ne'a-ne̱ ye̱ kume̱ yakar á, ye̱ bu̱m Shir remen ye̱ mat wan-yaar á.’ ");
INSERT INTO uth_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","O̱a no̱m da-o̱ hun-ne̱ he m-ze̱e̱ u̱t-haag à ‘He̱'e̱n no̱ te̱ n-to̱n!’ Ye̱a zee u̱t-dor, ‘Wuke̱ te̱ no̱!’ ");
INSERT INTO uth_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Go̱n ka rii-yo a nom, u̱rege̱ hun-ne̱ no̱mo̱te̱ me̱ kaane̱, me̱ wu̱ ro̱ ba u̱r-ba'as à, ¿ya ne̱ Shir he nome̱ u̱n ya-u̱r-ba'as?” ");
INSERT INTO uth_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Ye̱ ken hun-ne̱ ye̱ yoor, kap mo̱ u̱n ye̱ hyow-ne̱, a ruute̱ ye̱ remen karma-ne̱ hoot ye̱ u̱n Ye̱so ne̱. ");
INSERT INTO uth_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Bo̱ ye̱ wo̱o̱ne̱ de ken be-de a m-ze̱e̱, Caar-o̱ u̱r-hi, ye̱ kamu̱ru̱ Ye̱so kane̱ o-kan u̱n ka hyow-ne̱ ye̱ ne̱ yoor, wan-gaan so̱ u̱r-re̱, wan-gaan so̱ u̱r-kwanta. ");
INSERT INTO uth_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Ye̱so ze̱e̱ru̱, “Tato re, soks ba'as-de u̱n ye̱! Ye̱ nap yo ye̱ ro̱ m-no̱m á.” Ka da-de karma-ne̱ wo̱ngu̱ru̱ gund-to̱ u̱n wu̱ o-gwambe̱. ");
INSERT INTO uth_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Hun-ne̱ ro̱ eso ye̱ gu̱t, da-o̱ caari-ye̱ ye̱ u̱n Yahuda-ne̱ nome̱ wu̱ u̱r-ar à. Ye̱ ze̱e̱ru̱, “Wu̱ guug ye̱ ken ye̱, u̱rege̱ wu̱ ro̱ Kiristi wu̱ Shir to̱mne̱ à, wu̱ gu hi u̱n de u̱n wu̱.” ");
INSERT INTO uth_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Karma-ne̱ abu̱n ye̱, nomu̱ru̱ wu̱ u̱r-ar, ye̱ haaru̱ be-de u̱n wu̱. Ye̱ tepbu̱ru̱ wu̱ ke̱-mo̱ o-zambo. Ye̱ ze̱e̱ru̱, ");
INSERT INTO uth_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","“Gu hi u̱n du u̱rege̱ wo̱ ko-Gwo̱mo-wu̱ u̱n Yahuda-ne̱ wu̱!” ");
INSERT INTO uth_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Ye̱ ge̱nu̱ru̱ ka gom-to̱ ye̱ kemu̱ru̱ wu̱ to̱ yow yow u̱r-hi ne̱: “Ko-Gwo̱mo-wu̱ u̱n Yahuda-ne̱ wu̱ ka.” ");
INSERT INTO uth_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Wan-gaan be-de u̱n ka hyow-ne̱ ye̱, ye̱ a kame̱ kane̱ à, ru̱ru̱ Ye̱so ma-to̱ ba u̱r-bon: “¿Wo̱ wu̱ ka ro̱ Kiristi á? Gu hi u̱n du u̱n te̱ ne̱!” ");
INSERT INTO uth_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Ka wan-gaan-wu̱, huru̱ru̱ wu̱ u̱t-gaag, wu̱ ro̱ m-ze̱e̱, “¿Wo̱ u̱n gye̱r u̱n Shir á? A m-swo̱ u̱r-ko̱o̱b hond hond u̱n wu̱ ne̱. ");
INSERT INTO uth_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","De ma na ko̱o̱b-de hond hond o̱ be-u̱r na, remen a go̱kste̱ yo depe̱ na à, amba wu̱, wu̱ no̱m u̱r-ba'as á.” ");
INSERT INTO uth_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Komo wu̱ ze̱e̱ru̱ Ye̱so, “Ye̱so, baks u̱n me̱ ne̱, da-o̱ o he m-mu̱u̱n u̱t-gwo̱mo ne̱ à!” ");
INSERT INTO uth_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Ye̱so shasu̱ru̱ wu̱, “U̱m esu̱te̱ wo̱ caane̱, wo̱a tu̱w be-de o-zak u̱n me̱ ne̱.” ");
INSERT INTO uth_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","45","Ho̱-u̱r ro̱ u̱r-hi, comb-o swo̱o̱nu̱ru̱ ho̱no o-dak har da-o de shate̱ à. Komo gund-o̱ m-nu̱ o̱ wo̱ngse̱ Pyo-o̱ Shir à catu̱ru̱ be-u̱t yoor u̱n hi u̱n de u̱n o̱. ");
INSERT INTO uth_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Ye̱so 'yonsu̱ru̱ u̱s-co̱r, “Tato re! U̱m ru̱ste̱ ku̱kt-to̱ re u̱n kom-u̱t ru!” Bo̱ wu̱ zette̱ kaane̱ à, wu̱ maru̱ru̱. ");
INSERT INTO uth_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Se̱k-wu̱ wu̱ u̱n karma-ne̱ hyanu̱ru̱ yo no̱me̱ à, wu̱ bo̱mu̱ru̱ Shir, wu̱ ro̱ m-ze̱e̱, “Nip-o̱ ka ne̱t-wu̱ ne̱t kashi-wu̱!” ");
INSERT INTO uth_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Da-o̱ hun-ne̱ ye̱ mo̱rge̱ kane̱ à, hyane̱ yo no̱me̱ à, ye̱ ji'u̱ru̱ o-hur kap. Ye̱ ro̱ u̱n wo̱s u̱n be-de u̱n ye̱ u̱n tu̱k-mo̱ u̱t-me̱n. ");
INSERT INTO uth_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Amba kap ye̱ nape̱ Ye̱so u̱n hi u̱n de u̱n ye̱ à, ye̱ e̱ssu̱ru̱ u̱r-hew ne̱ ye̱ gu̱t, mo̱sse̱ u̱n ne'a-ne̱ ne̱ ye̱ do̱nde̱ wu̱ so̱ o-Gariri à. ");
INSERT INTO uth_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Wu̱ ken ne̱t-wu̱, wu̱ a m-ze̱e̱ Yusuhu ko-ya-o-Aramatiya, u̱n dak-o̱ o-Judiya. Kashi u̱n ne̱t-wu̱ a m-ho̱ge̱ à, wu̱ ro̱ u̱n 'er-de u̱n haan-mo̱ u̱n gwo̱mo-to̱ Shir. Wu̱ ma ko-caari-wu̱ be-de u̱n se̱k-ye̱ u̱n den-o Shir, myet u̱n kaane̱ wu̱ de̱k ma-to̱ u̱n ye̱, u̱n yo ye̱ no̱me̱ ne̱ á. ");
INSERT INTO uth_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Wu̱ haaru̱ be-u̱r Biratus wu̱ ko̱nu̱ru̱ a ya'as wu̱ u-u̱r Ye̱so. ");
INSERT INTO uth_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Wu̱ de̱ku̱ru̱ ka u-de, wu̱ yereru̱ u̱n o̱ ken gund-o̱, wu̱ ru̱ssu̱ru̱ u̱n saag-o̱ a bo̱'e̱ be-de o-ta'ar à, o̱ a ro jo̱kke̱ ne̱t á. ");
INSERT INTO uth_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Ho̱-de u̱r-Jaw de, Ho̱-de u̱r-Wu̱we̱ ro̱ ma-to̱ u̱n wo̱o̱n. ");
INSERT INTO uth_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Ka ne'a-ne̱ ye̱, ye̱ do̱nde̱ Ye̱so so̱ o-Gariri à, neku̱ru̱ u̱n Yusuhu ne̱. Komo ye̱ hyanu̱ru̱ ka saag-o̱, be-de a ru̱sse̱ u-u̱r Ye̱so n-me̱ à. ");
INSERT INTO uth_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Ka da-de ye̱ wargu̱ru̱ o-hur, ye̱ zo̱ngu̱ru̱ u̱n saw-to̱ m-no̱w mo̱ m-shi'igin ne̱, remen wu̱r-o Ye̱so. Ye̱ wu̱wu̱ru̱ Ho̱-de u̱r-Wu̱we̱, bo̱ karamsa-o ze̱e̱ à. ");
INSERT INTO uth_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","N-sot, n-sot, ho̱-de o-Rahadi, ka ne'a-ne̱ ye̱ haaru̱ be-de o-saag, ye̱ ro u̱n ka saw-to̱ m-no̱w to̱ ne̱. ");
INSERT INTO uth_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Ye̱ 'wo̱s a doste̱ ka ta'ar-o̱, o̱ a ho̱kte̱ ish-o̱ u̱n saag à, ");
INSERT INTO uth_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Ye̱ co̱wu̱ru̱ n-me̱, amba ye̱ hyan u-u̱r Ye̱so Go̱s-wu̱ á. ");
INSERT INTO uth_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Ye̱ e̱su̱ru̱ kane̱ ba u̱n nap u̱n yo ye̱ he m-no̱m á, u̱n gyept-o̱ u̱n yish campo̱-ne̱ ne̱n yoor u̱n gund-to̱ m-ku̱kar ne̱ wo̱o̱nu̱ru̱ yow yow u̱n ye̱ ne̱. ");
INSERT INTO uth_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Gye̱r-o ho̱o̱ru̱ ye̱, ka ne'a-ne̱ ye̱ kwu̱ktu̱ru̱ n-dak. Ka campo̱-ne̱ ye̱ ze̱e̱ru̱, “¿Yan yo no̱ ro̱tte̱ u̱n hoob-o̱ u̱n wan-ho̱o̱g be-de u̱n margan-ne̱? ");
INSERT INTO uth_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Wu̱ ro̱ ko̱n kane̱ á, Shir 'yonsu̱te̱ wu̱. Baks no̱ yo wu̱ zee no̱ da-o̱ wu̱ ro'e̱ o-Gariri à. ");
INSERT INTO uth_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","A bo̱pse̱ ya-u̱r-ba'as ‘Wà-wu̱ u̱n ne̱t a kem wu̱ o-kan komo ho̱-u̱t tet wu̱a ine̱ u̱n ho̱o̱g ne̱.’ ” ");
INSERT INTO uth_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Ka da-de ka ne'a-ne̱ ye̱ baksu̱ru̱ ma-to̱ u̱n wu̱. ");
INSERT INTO uth_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Ye̱ yagu̱ru̱ be-de o-saag, ye̱ haaru̱, ye̱ ru̱ru̱ yan-neke̱-m Ye̱so o̱p o-gaan, u̱n ye̱ ken ye̱ ne̱ kap ka rii-yo. ");
INSERT INTO uth_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Ka ne'a-ne̱ ye̱ ka, Meri Magu̱darin, Jonana, u̱n komo Meri ne̱ (inu Yakubu), u̱n ye̱ ken ne'a-ne̱ ye̱ ne̱, ru̱ru̱ yan-To̱m Ye̱so. ");
INSERT INTO uth_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Amba yan-To̱m Ye̱so ro̱ m-ze̱e̱ ka yo ka ne'a-ne̱ ye̱ rwo̱re̱ à ye̱ nap rii-yo ye̱ ro̱ m-no̱m á, komo ye̱ go̱ks ma-to̱ u̱n ye̱ á. ");
INSERT INTO uth_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Amba Bitrus inu̱ru̱ wu̱ ruuru̱ o-rek wu̱ haaru̱ be-de o-saag. Wu̱ kaktu̱ru̱, wu̱ hyanu̱ru̱ ka gund-o̱ a yere̱ Ye̱so à, amba u-u̱r Ye̱so ro̱ ko̱n komo á. Ka da-de wu̱ wargu̱ru̱ o-hur, wu̱ ro̱ u̱s-barag-se u̱n yo no̱me̱ à. ");
INSERT INTO uth_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Ka ho̱-u̱r gaan-de yan-neke̱-m Ye̱so ne̱n yoor ro m-ha de ken bo̱-de a m-ze̱e̱ o-Emmas à, u̱ntu̱n me̱r-u̱t ta'yoor kiromita 11 rwu̱u̱n-mo̱ o-Urusharima. ");
INSERT INTO uth_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Ye̱ ro̱ u̱t-orom to̱ u̱n rii-yo no̱me̱ à. ");
INSERT INTO uth_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Bo̱ ye̱ ro̱ te̱p u̱t-orom à, Ye̱so wo̱o̱nu̱ru̱ yow yow wu̱ ro̱ m-neke̱ u̱n ye̱ ne̱. ");
INSERT INTO uth_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Ye̱ hyanu̱ru̱ wu̱, amba ye̱ hoks wu̱ m-nap á. ");
INSERT INTO uth_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Ye̱so ze̱e̱ru̱ ye̱, “¿Yan yo no̱ m-orome̱, bo̱ no̱ m-neke̱ à?” Ye̱ e̱su̱ru̱, co-u̱s ro̱ naase̱. ");
INSERT INTO uth_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Wan-gaan-wu̱ a m-ze̱e̱ Ku̱repas, citu̱ru̱ wu̱, “Wo̱ wu̱ cot ko-hamat kane̱ o-Urusharima, wu̱ nape̱ rii-yo no̱me̱ kane̱ u̱n ka ho̱-to̱ á.” ");
INSERT INTO uth_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Ye̱so citu̱ru̱, “¿Yo ke rii-yo?” Ye̱ shasu̱ru̱, “Rii-yo no̱me̱ Ye̱so ko-ya-o-Nazaret à. Ko-yan-Rwo̱ru̱ u̱n Ma-to̱ Shir wu̱ ka ne̱t-wu̱, komo Shir ya'ag wu̱ u̱r-be̱e̱b be-de u̱n hun-ne̱, kap yo wu̱ zee, u̱n yo wu̱ no̱me̱ ne̱ à. ");
INSERT INTO uth_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Gwo̱mo-ne̱ ye̱ u̱n ko̱n-se Shir be u̱n te̱, u̱n ya-o-dak-ne̱ heete̱ wu̱ be-u̱r Biratus a ho, a kamag wu̱ o-kan. ");
INSERT INTO uth_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Komo kane̱ te̱ hwo̱ u̱r-hur, wu̱ he rwo̱ u̱n ya-o-Isra m-posse̱. A hu̱sse̱ to̱ ka ma, caane̱ ro̱ ho̱-u̱r atette̱-de bo̱ u̱n no̱m u̱n kaane̱. ");
INSERT INTO uth_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Ye̱ ken ne'a-ne̱ ye̱, u̱n bu̱u̱g u̱n te̱ rwo̱'o̱g te̱ u̱s-barag, ye̱ haag u̱n gas-o ish be-de u̱n saag. ");
INSERT INTO uth_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Amba ye̱ hyan u-de u̱n wu̱ á. Ye̱ mu̱u̱nte̱, ye̱ ro̱ m-ze̱e̱ ye̱ hyanag u̱t-hyangan yan-to̱m-ye̱ Shir ru̱ru̱te̱ ka ne'a-ne̱ ye̱ u̱nze wu̱ ro̱ u̱n ho̱o̱g ne̱. ");
INSERT INTO uth_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Ye̱ ken ye̱ u̱n bu̱u̱g u̱n te̱ haag u̱n ka saag-o̱ komo ye̱ 'wo̱ste̱ bo̱ ka ne'a-ne̱ ye̱ ze̱e̱ à, amba ye̱ hyan wu̱ á.” ");
INSERT INTO uth_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Ka da-de Ye̱so ze̱e̱ru̱ ye̱, “No̱ m-raag ne̱, komo u̱n ho'os o-wu̱r ne̱ be-de u̱n go̱ks u̱n ko̱ yo ke yo yan-Rwo̱ru̱ u̱n Ma-to̱ Shir zee à! ");
INSERT INTO uth_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Amba Shir ze̱e̱g Kiristi wu̱ su̱ u̱r-ko̱o̱b de u̱n ka rii-yo, ka da-de wu̱ co̱wu̱ru̱ u̱n se̱ke̱mse̱-mo̱ u̱n wu̱.” ");
INSERT INTO uth_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Ye̱so ru̱ru̱ ye̱ yo Ma-to̱ Shir zee mo̱sse̱ u̱n wu̱ ne̱ à, wu̱ taknu̱ru̱ u̱n yo taku̱rda-o Mosa u̱n kap yo yan-Rwo̱ru̱ u̱n Ma-to̱ Shir ne̱ ge̱ne̱ à. ");
INSERT INTO uth_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Bo̱ ye̱ wo̱o̱nte̱ yow yow u̱n ka bo̱-de ye̱ ro̱ m-ha ne̱ à, Ye̱so no̱mu̱ru̱ sa o zee o-co wu̱ arge̱. ");
INSERT INTO uth_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Amba ye̱ mu̱u̱ntu̱ wu̱ jim ye̱ ro̱ m-ze̱e̱, “She'et be u̱n te̱, ho̱-u̱r teeste̱ te̱t-m mo̱ m-no̱m.” Wu̱ haaru̱ wu̱ she'ete̱ u̱n ye̱ ne̱. ");
INSERT INTO uth_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Wu̱ she'etu̱ru̱ wu̱ reet rii-yo m-re̱ u̱n ye̱ ne̱, wu̱ deku̱ru̱ u̱r-buro̱di, wu̱ hu̱u̱ru̱ de nu-o̱ u̱r-bon, ka da-de wu̱ catu̱ru̱ de wu̱ yasu̱ru̱ ye̱. ");
INSERT INTO uth_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Ka da-de yish-ye̱ u̱n ye̱ upsu̱ru̱, ye̱ napu̱ru̱, u̱nze Ye̱so wu̱, amba ye̱ do wu̱ m-hyan á. ");
INSERT INTO uth_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Ye̱ ze̱e̱ru̱ hi u̱n de u̱n ye̱, “A no̱mo̱g o-zak de̱e̱n da-o̱ wu̱ te̱psu̱ na u̱n co̱w à, komo wu̱ ru̱ru̱ na yo Ma-to̱ Shir zee à.” ");
INSERT INTO uth_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Ye̱ inu̱ru̱ da-o gaan, ye̱ wargu̱ru̱ o-Urusharima. Kane̱ ye̱ 'wo̱sse̱ yan-neke̱-m Ye̱so ne̱n o̱p o-gaan kargu̱te̱ be-u̱r gaan u̱n ye̱ ken ye̱ ne̱ ");
INSERT INTO uth_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","ye̱ ro̱ m-ze̱e̱, “Nip-o̱ Go̱s-wu̱ inu̱te̱! Simo̱n hyanag wu̱!” ");
INSERT INTO uth_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Ka ne̱n yoor-ye̱, dooru̱ ye̱ m-ru̱re̱ u̱n yo no̱me̱ u̱n co̱w à, komo bo̱ ye̱ nape̱ wu̱ da-o wu̱ caate̱ u̱r-buro̱di à. ");
INSERT INTO uth_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Bo̱ ka ne̱n yoor-ye̱ ro ye̱ m-ru̱re̱ kaane̱ à, kane̱ Go̱s-wu̱ u̱n hi u̱n de u̱n wu̱ e̱su̱ru̱ eso be-de u̱n ye̱. Wu̱ gassu̱ru̱ ye̱. ");
INSERT INTO uth_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Ye̱ ho̱gu̱ru̱ o-gye̱r, ye̱ zee ko̱ ku̱kt-o̱ u̱n ko-marimar o̱. ");
INSERT INTO uth_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Amba wu̱ ze̱e̱ru̱ ye̱, “¿Remen yan o̱ no̱ ro̱tte̱ o-gye̱r? ¿Remen yan o̱ no̱ ro̱tte̱ das das? ");
INSERT INTO uth_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Gwo̱t no̱ kom-u̱t re u̱n na-u̱s re ne̱, no̱a hyen me̱ wu̱ u̱n hi u̱n de. Ci no̱ me̱, no̱ nept, remen ku̱kt-o̱ u̱n ko-marimar ro̱tt to̱ wu̱r-o̱ m-ap u̱t-caar ne̱ á, bo̱ no̱ hyane̱ u̱m ro̱ à.” ");
INSERT INTO uth_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Bo̱ wu̱ zette̱ kaane̱, komo wu̱ kutu̱ru̱ ye̱ kom-to̱ u̱n wu̱ u̱s-na ne̱. ");
INSERT INTO uth_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Kap u̱n kaane̱ ne̱ ye̱ go̱ks á, zak-o ho̱o̱g ye̱, u̱t-hyat ne̱. Wu̱ citu̱ru̱ ye̱, “¿No̱ u̱n rii-yo m-re̱ ne̱ kane̱?” ");
INSERT INTO uth_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Ye̱ yasu̱ru̱ wu̱ bek-o̱ o-jan hense̱. ");
INSERT INTO uth_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Wu̱ de̱ku̱ru̱ yo wu̱ ti'u̱ru̱ u̱n hyan-o u̱n ye̱. ");
INSERT INTO uth_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Ka da-de wu̱ ze̱e̱ru̱ ye̱, “Ka rii-yo u̱m ru̱ru̱ no̱ à, yo ro kon da-o̱ u̱m ro̱'e̱ u̱n no̱ ne̱ à: Kap yo a ge̱ne̱ mo̱sse̱ u̱n me̱ ne̱ à, be-de u̱n karamsa-o Mosa, ge̱n-mo̱ u̱n yan-Rwo̱ru̱ u̱n Ma-to̱ Shir, u̱n taku̱rda-o̱ u̱n Se̱p-to̱ u̱r-Bo̱ngo̱n ne̱ komo, a shi o-nip.” ");
INSERT INTO uth_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Ka da-de wu̱ upsu̱ru̱ ye̱ u̱r-hur, ye̱ nept ka ge̱n-mo̱ Shir mo̱. Komo wu̱ ze̱e̱ru̱ ye̱, ");
INSERT INTO uth_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","“Yo a ge̱ne̱ à yo ka: Kiristi a su̱ u̱r-ko̱o̱b, komo wu̱a ine̱ be-de u̱n margan-ne̱ u̱n ho̱-u̱r atette̱-de. ");
INSERT INTO uth_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Komo u̱n jin-de u̱n wu̱, ka to̱m-mo̱ u̱n yage̱ u̱n no̱m u̱r-ba'as o̱ m-waktu̱ne̱ be-de Shir ne̱, u̱n soks u̱r-ba'as ne̱, a ru̱r o̱ ho̱no o-dak kap, u̱r-takan o-Urusharima. ");
INSERT INTO uth_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","No̱ ro̱ ya-m-su̱'e̱ u̱n ka rii-yo u̱n hi u̱n no̱. ");
INSERT INTO uth_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Me̱ komo u̱n hi u̱n de man tomtu̱ndu̱ no̱ ku̱kt-o Shir, o̱ Tato re e̱sse̱ u̱t-ma à. Amba wasu̱ no̱ n-me̱ o-bo̱ har da-o̱ ka ku̱kt-o Shir o̱ shoosu̱ no̱ u̱n be̱e̱b-de rwu̱u̱ne̱ n-To̱n u̱n shir à.” ");
INSERT INTO uth_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Ka da-de wu̱ de̱ku̱ru̱ ye̱, ye̱ ruuru̱ o-bo̱ u̱r-hew ne̱ ha-mo̱ o-Betanya. Kane̱ wu̱ jakse̱ kom-to̱ u̱n wu̱, wu̱ hu̱u̱ru̱ ye̱ nu-o̱ u̱r-bon. ");
INSERT INTO uth_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Da-o̱ wu̱ ro̱ ye̱ u̱n ru̱'e̱ u̱n nu-o̱ u̱r-bon à, wu̱ yagu̱ru̱ ye̱. Shir de̱ku̱ru̱ wu̱ n-To̱n u̱n shir. ");
INSERT INTO uth_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Ye̱ kwu̱ktu̱ru̱, ye̱ ya'u̱ru̱ wu̱ m-se̱k, ye̱ wargu̱ru̱ o-Urusharima. Zak-o ho̱o̱ru̱ ye̱ de̱e̱n. ");
INSERT INTO uth_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Komo ye̱ ho̱o̱ru̱ da-o̱ u̱n ye̱, n-me̱ u̱n Pyo-o̱ Shir, ye̱ ro̱ u̱n bo̱ngo̱n-de Shir.");
INSERT INTO uth_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Cin da-de u̱r-takan Gom-u̱r ro kon. Ka Gom-de ne̱ de ro mo̱sse̱ u̱n Shir ne̱. Ka Gom-de komo de ro̱ Shir. ");
INSERT INTO uth_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Wu̱ ro̱ mo̱sse̱ u̱n Shir ne̱ cin u̱r-takan. ");
INSERT INTO uth_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","U̱n ka Gom-de, Shir nomte̱ ko̱yan. Shir ro̱ u̱n no̱m yo ken rii-yo ba u̱n wu̱ á. ");
INSERT INTO uth_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Wu̱ wu̱ ro̱ wan-ho̱o̱g, wu̱ ya'e̱ ko̱ yo ke rii-yo ho̱o̱g à. Ka ho̱o̱g-o̱ ne̱, cecas-mo̱ u̱n hun-ne̱ mo̱. ");
INSERT INTO uth_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Mo̱ ro̱ ye̱ m-dosse̱ o-comb. Mo̱ ro̱ cecas-mo̱ u̱n hun-ne̱. Ká comb-o̱ hoks mo̱ u̱n ká cecas-mo̱ á. ");
INSERT INTO uth_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Wu̱ ken ne̱t-wu̱ ro kon wu̱ Shir to̱mne̱ à, wu̱ a m-aag Yohana Wa-m-Yo'os u̱n hun-ne̱ m-ho̱ à. ");
INSERT INTO uth_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Wu̱ u̱n haan wu̱ ru̱ru̱té̱ hun-ne̱ u̱n su̱'e̱ u̱n ká wa-m-cecas-wu̱, remen ko̱ wu̱ ke ne̱t-wu̱, wu̱ sheret be-de u̱n ka wa-m-cecas-wu̱. ");
INSERT INTO uth_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Yanze Yohana wu̱ ro̱ ka wa-m-cecas-wu̱ á. Wu̱ u̱n haan remen wu̱ su̱u̱te̱ ma-to̱ u̱n ka wa-m-cecas-wu̱. ");
INSERT INTO uth_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Ka cecas-mo̱ mo̱ o-nip, mo̱ carakse̱ ko̱ wu̱ ke ne̱t-wu̱ à, mo̱ mo̱ ro̱ m-nekne̱ n-me̱ u̱n ho̱no o-dak. ");
INSERT INTO uth_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Wu̱ co̱wo̱nte̱ n-me̱ u̱n ho̱no o-dak o̱ wu̱ no̱me̱ à, amba ho̱n dak u̱n nap u̱n wu̱ ne̱ á. ");
INSERT INTO uth_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Wu̱ u̱n haan be-de u̱n hun-ne̱ ye̱ u̱n wu̱, amba ka hun-ne̱ ye̱ 'yaru̱ wu̱. ");
INSERT INTO uth_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Amba ye̱ ken ye̱ go̱kste̱ wu̱. Ye̱ she̱re̱g hi u̱n de u̱n ye̱ be-de u̱n wu̱. Bo̱n ye̱ go̱kse̱ wu̱ à, wu̱ ya'ag ye̱ o-co̱w, ye̱ waragté̱ yakar-ye̱ Shir. ");
INSERT INTO uth_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","A ja'aste̱ ye̱ m-mat. Yanze mat-o̱ u̱n campo̱ u̱n ne'a-ne̱, ko̱ mat-o̱ u̱n co̱n-mo̱ u̱n campo̱ á. Ay, mat-o̱ u̱n Shir o̱, wu̱ muute̱ ye̱ yakar-ye̱ u̱n wu̱ à. ");
INSERT INTO uth_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Ka Gom-de waragte̱ ne̱t har wu̱ she'etu̱ru̱ be u̱n na. A hyanag se̱ps-mo̱ u̱n wu̱, se̱ps-mo̱ u̱n wu̱ komo u̱n ho̱n mo̱ wan-gaan mo̱ cot, wu̱ rwu̱u̱ne̱ be-de o-Tato shiishe̱ m-yar o-nip ne̱ à. ");
INSERT INTO uth_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Wu̱ wu̱ Yohana rwo̱re̱ ma-to̱ u̱n wu̱. Wu̱ 'yonsu̱ru̱ u̱s-co̱r. Wu̱ zee, “Wu̱ wu̱ u̱m ru̱ru̱ no̱ ma-to̱ u̱n wu̱, wu̱ u̱m ze̱e̱, ‘Wu̱ ro̱o̱n n-jim u̱n de à, amba wu̱ aragte̱ me̱. Cin n-ga ne̱ ma wu̱ ro kon, cin ba a u̱n makt me̱.’ ” ");
INSERT INTO uth_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Be-de u̱n mo̱o̱r-to̱ u̱n yar-mo̱ u̱n wu̱ o̱ wu̱ hu̱u̱ na nu-o so̱-o̱ bim-o-bim. ");
INSERT INTO uth_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","U̱n kom-u̱t Mosa a ya'asu̱nde̱ o-karamsa, amba m-yar o-nip ne̱, be-u̱r Ye̱so Kiristi a ya'asu̱nde̱ na mo̱. ");
INSERT INTO uth_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Yatt ne̱t-wu̱ take̱ hyan u̱n Shir cas á, se̱ Wà u̱n wu̱ u̱r-mat u̱n ho̱n-de u̱n wu̱. Wu̱ ro̱ ragaan u̱n Shir ne̱. Wu̱ ro̱ tara u̱n kom-o̱ u̱r-re̱ de Shir à, wu̱ ru̱ru̱ na bo̱ Shir ro̱ à. ");
INSERT INTO uth_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Swo̱-u̱s Yohana se ka, da-o̱ se̱k-ye̱ be-de u̱n Yahuda-ne̱, ye̱ o-Urusharima to̱me̱ yan-Co̱w u̱n ko̱n-se Shir u̱n Rewi-ne̱ ne̱ à. Ye̱ he ye̱ cit u̱n Yohana, “¿Wo̱ ro̱ wan?” ");
INSERT INTO uth_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Yohana yage̱ ye̱ m-ru̱ru̱ á. Wu̱ rwu̱u̱ne̱ ye̱ cas, wu̱ zee, “Me̱ wu̱ ro̱ Kiristi á.” ");
INSERT INTO uth_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","To̱, ye̱ citu̱ru̱ wu̱, “¿Wo̱ ro̱ wa? ¿Wo̱ E̱reja wu̱?” Wu̱ ze̱e̱ru̱, “Ay.” Ye̱ ze̱e̱ru̱ wu̱, “¿Wo̱ wu̱ ro̱ ka wan-rwo̱r u̱n Ma-to̱ Shir wu̱, wu̱ Shir ze̱e̱ wu̱a 'yonsu̱ndu̱ te̱ u̱ntu̱n Mosa?” Wu̱ dooru̱ m-ze̱e̱, “Ay.” ");
INSERT INTO uth_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Ye̱ ze̱e̱ru̱ wu̱, “To̱, ¿ru̱ru̱ te̱ wo̱ ro̱ wa ne̱? Ru̱ru̱ te̱ remen te̱ ru̱ru̱té̱ hun-ne̱ ye̱ to̱mne̱ te̱ à, ¿ya wo̱ m-ze̱e̱ u̱n hi u̱n du?” ");
INSERT INTO uth_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Yohana ze̱e̱ru̱ ye̱, “Me̱ wu̱ ro̱ ko-wan-eeg o̱ u̱n hun-ne̱ o-dákár, wu̱ Ishayawan-Rwo̱r u̱n Ma-to̱ Shir rwo̱re̱ ma-to̱ u̱n wu̱ à. Ishaya ro̱ m-ze̱e̱, ‘Zo̱ngu̱ no̱ remen haan-m Yawe.’ ” ");
INSERT INTO uth_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Ka ye̱ a to̱me̱ ye̱ he, ye̱ cit u̱n Yohana à, ye̱ ro̱ mo̱sse̱ u̱n Parisa-ne̱ ne̱. ");
INSERT INTO uth_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Ye̱ ze̱e̱ru̱ wu̱, “¿Yan yo wo̱tte̱ u̱n yo'os u̱n hun-ne̱ n-te̱ m-ho̱, wo̱ E̱reja á, wo̱ ro̱ ne̱ Kiristi á, ¿wo̱ ne̱ ko-wan-rwo̱r u̱n Ma-to̱ Shir á?” ");
INSERT INTO uth_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Yohana ze̱e̱ru̱ ye̱, “Me̱ no̱ de̱ m-yo'os m-ho̱ m-ho̱. Wu̱ ken ro̱ ge̱ be u̱n no̱, wu̱ no̱ nape̱ u̱n wu̱ ne̱ á. ");
INSERT INTO uth_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Me̱ u̱n ba wu̱ m-wo̱o̱n be u̱n no̱. Me̱ bo'os u̱m us ka'ante̱-to̱ u̱n wu̱ á.” ");
INSERT INTO uth_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","To̱ ka to̱ u̱n ko̱r u̱n be-de hun-ne̱ ro̱ m-aag o-Betanya, o̱ ro̱ pesto-de so̱ u̱n ho̱ran-de u̱n Ro̱o̱g-o̱ o-Joda à, be-de Yohana ro u̱n yo'os u̱n hun-ne̱ n-te̱ m-ho̱ à. ");
INSERT INTO uth_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Bo̱ ish geste̱ à, Yohana hyanbu̱ru̱ Ye̱so ro̱ m-nekne̱ be-de u̱n wu̱. Wu̱ ze̱e̱ru̱, “Gwo̱t no̱ Ca-yo Shir yo de̱ke̱ ba'as-to̱ u̱n ho̱no o-dak à! ");
INSERT INTO uth_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Wu̱ wu̱ u̱m ze̱e̱ no̱ wu̱ ken wu̱ ro̱o̱n n-jim u̱n de. Wu̱ u̱m ze̱e̱ no̱ wu̱ ro̱ Wan-co re à, remen wu̱ ro kon ho̱no o-dak cin ba a ro makt me̱. ");
INSERT INTO uth_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Me̱ u̱n hi u̱n de, m-beerte̱ wu̱, amba rii-yo rwo̱'e̱ u̱m haante̱ yo'os u̱n hun-ne̱ m-ho̱ à yo ro̱ remen a rwu̱ntu̱té̱ wu̱ cas be-de u̱n Isra-ne̱.” ");
INSERT INTO uth_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Ka da-o̱ Yohana no̱mu̱ se ka swo̱-se, wu̱ zee: “U̱m hyanag o-Ku̱kt m-kergu̱nde̱ rwu̱u̱n-mo̱ n-to̱n u̱ntu̱n o-gorop o̱ ciru̱ru̱ u̱n wu̱. ");
INSERT INTO uth_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Me̱ roa nep wu̱ á, se̱ de̱ u̱ntu̱ ka wu̱ to̱mnu̱ me̱ u̱m yo'os hun-ne̱ m-ho̱ ru̱ru̱ me̱ à, ‘Ka wu̱ o hyane̱ Ku̱kt-o kergu̱nte̱ o̱ ciru̱ru̱ u̱n wu̱ à, wu̱ he yo'os u̱n hun-ne̱ u̱n Ku̱kt-o̱ Shir.’ ");
INSERT INTO uth_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","U̱m hyanag komo u̱m nomoste̱ su̱u̱te̱, wu̱ ka wu̱ ro̱ Wà-wu̱ Shir.” ");
INSERT INTO uth_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Bo̱ ish geste̱ à, Yohana ro̱ ge̱ u̱n yan-neke̱-mo̱ u̱n wu̱ ne̱ ne̱n yoor. ");
INSERT INTO uth_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Bo̱ Ye̱so ro m-arag à, Yohana ma'asu̱ru̱ wu̱ m-gwo̱tbe̱. Wu̱ ze̱e̱ru̱ ye̱, “Gwo̱tbe̱ no̱ Ca-yo Shir!” ");
INSERT INTO uth_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Bo̱ ka yan-neke̱-mo̱ u̱n wu̱ ne̱ ne̱n yoor, ho̱gu̱te̱ ma-to̱ u̱n wu̱ à, ye̱ do̱ru̱ru̱ Ye̱so n-jim n-jim. ");
INSERT INTO uth_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Ye̱so byandu̱ru̱ u̱s-ajima ne̱, wu̱ hyanu̱ru̱ ka yan-neke̱-m Yohana ye̱ ne̱n yoor-ye̱ ro̱ wu̱ m-do̱nd. Wu̱ citu̱ru̱ ye̱, wu̱ zee, “¿Ya no̱ co̱ne̱ o̱?” Ye̱ ze̱e̱ru̱ wu̱, “Wa-u̱s-Nap, ¿kene̱ o̱ o ro̱ u̱r-she'et?” ");
INSERT INTO uth_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Wu̱ ze̱e̱ru̱ ye̱, “Do̱nd no̱ me̱. Man kute̱ no̱ be-de u̱m ro̱ à.” U̱n ká da-o̱ ne̱ kwo̱m-u̱s nass-se se m-rim, ye̱ argu̱ wu̱ m-do̱re̱, ye̱ wo̱o̱ru̱ be-de wu̱ ro u̱r-she'et à. Ye̱ bu̱su̱ru̱ taas u̱r-ho̱ u̱n wu̱ ne̱. ");
INSERT INTO uth_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Andarawus, heno Simo̱n Bitrus ne̱, wan-gaan-wu̱ be-de u̱n ká campo̱-ne̱ ye̱ ho̱ge̱ rii-yo Yohana ro m-rwo̱r ye̱, do̱ru̱te̱ Ye̱so à. ");
INSERT INTO uth_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Andarawus neku̱ru̱, wu̱ ru̱ru̱ se̱k-wu̱ u̱n wu̱ Simo̱n Bitrus. Wu̱ zee, “Caane̱, te̱ hyanag Mesaya,” (Ka gom-de, de a m-ze̱e̱ Kiristi). ");
INSERT INTO uth_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Andarawus wootu̱ru̱ Bitrus be-u̱r Ye̱so. Ye̱so gwo̱tu̱ru̱ Bitrus, wu̱ ze̱e̱ru̱ wu̱, “Wo̱ wu̱ ro̱ Simo̱n wà Yohana, amba a eeg wo̱ Ke̱pas.” (Gaan-to̱ u̱n jin-u̱r Bitrus ne̱ u̱r-Ta'ar.) ");
INSERT INTO uth_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Bo̱ ish geste̱ à, Ye̱so ro u̱n ma-to̱ m-ha raag-o̱ o-Gariri. Wu̱ hyanu̱ru̱ Pirip, wu̱ ze̱e̱ru̱ Pirip, “Haan, o do̱ru̱ me̱.” ");
INSERT INTO uth_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Pirip ko-wan-bo̱-o̱ o-Besayada wu̱. Ye̱ ro bo̱-o gaan Andarawus ne̱, Bitrus ne̱. ");
INSERT INTO uth_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Pirip haaru̱ ru̱re̱ u̱n Nataniyar. Wu̱ ze̱e̱ru̱, “Te̱ hyanag wu̱, wu̱ Mosa u̱n yan-Rwo̱r u̱n Ma-to̱ Shir ne̱ ge̱ne̱ ma-to̱ u̱n wu̱ à. Wu̱ ro̱ Ye̱so wà Yusuhu, ko-ya-o-Nazaret.” ");
INSERT INTO uth_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Nataniyar ze̱e̱ru̱ Pirip, “¿Kashi u̱n rii a rwu̱u̱n u̱n bo̱-o̱ o-Nazaret?” Pirip ze̱e̱ru̱ “Haan, o gu̱t u̱n hi u̱n du.” ");
INSERT INTO uth_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Ye̱ neknu̱ru̱. Ye̱ wo̱o̱nu̱ru̱ be-u̱r Ye̱so. Da-o̱ Ye̱so hyane̱ Nataniyar ro̱ m-wo̱o̱n be-de u̱n wu̱ à, wu̱ ze̱e̱ru̱, “Nataniyar, ko-Isra-wu̱ o-nip wu̱ ka, wú̱ take̱ raks u̱n ne̱t á.” ");
INSERT INTO uth_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Nataniyar ze̱e̱ru̱ wu̱, “Wuuu, ¿kene̱ o nape̱ me̱?” Ye̱so ze̱e̱ru̱ wu̱, “Rii-yo Pirip agante̱ wo̱, u̱m hyeneste̱ wo̱, da-o̱ o ro u̱n 'wu̱n-de o-rum à.” ");
INSERT INTO uth_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Nataniyar ze̱e̱ru̱ wu̱, “Wa-u̱s-Nap, wo̱ wu̱ ro̱ Wà-wu̱ Shir, ko-Gwo̱mo-wu̱ u̱n dak-o̱ o-Isra.” ");
INSERT INTO uth_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Ye̱so ze̱e̱ru̱ wu̱, “¿Remen u̱m ze̱e̱g u̱m hyanag wo̱ u̱n 'wu̱n-de o-rum, o̱ o she̱rte̱ ka bo̱-se ne̱? U̱m ru̱ru̱te̱ wo̱ wo̱a hyen hyat-to̱ jiishe̱ to̱ ka u̱t-mo̱o̱r à.” ");
INSERT INTO uth_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Komo wu̱ ze̱e̱ru̱ ye̱, “Me̱ no̱ m-ru̱re̱ o-nip, no̱a hyen a tikste̱ To̱n-o̱ Shir, yan-to̱m-ye̱ Shir ye̱ ro̱ m-kergende̱, ye̱ ro̱ m-da n-to̱n u̱n Wà-wu̱ u̱n ne̱t.” ");
INSERT INTO uth_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Bo̱ a rewu̱te̱ ho̱-u̱t yoor à, ho̱-u̱r atette̱-de, a gak u̱r-ge o-Kana u̱n dak-o̱ o-Gariri. Reksu̱te̱ inu-o Ye̱so ro káne̱. ");
INSERT INTO uth_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","A bandte̱ Ye̱so u̱n yan-neke̱-mo̱ u̱n wu̱ ne̱ u̱n ká ge-de. ");
INSERT INTO uth_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Bo̱ ye̱ wo̱o̱bu̱te̱ à, mo̱di-mo̱, ye̱ ro m-swo̱ à, ye̱ swo̱o̱ru̱ mo̱, mo̱ kendu̱ru̱. Bo̱ mo̱ kendu̱te̱ à, inu-o Ye̱so haaru̱ be-de u̱n wu̱, wu̱ ze̱e̱ru̱, “Ka mo̱di-mo̱ o-biki mo̱ teeste̱. Ye̱tt m-mo̱di komo ne̱ á.” ");
INSERT INTO uth_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Ye̱so ze̱e̱ru̱ wu̱, “Inu, ¿ya nu̱'u̱su̱ wo̱ u̱n me̱ ne̱? Da-o re, o̱ u̱ngo̱ wo̱ á.” ");
INSERT INTO uth_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Inu Ye̱so haaru̱ be-de u̱n ya-m-se̱nge̱-mo̱ u̱r-ge, wu̱ ru̱ru̱ ye̱, “Ko̱ yo ke rii-yo Ye̱so ze̱e̱ no̱, no̱ nom, no̱m no̱ yo.” ");
INSERT INTO uth_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Káne̱ ne̱, Yahuda-ne̱ e̱sste̱ tur-u̱t cind-to̱ a shabe̱ u̱t-ta'ar à. To̱ ye̱ ro̱tte̱ u̱t-sapt bo̱ karamsa-o ze̱e̱ à. Ka tur-to̱ ko̱ o̱ ke ro̱ m-re̱ u̱t-de̱de̱ u̱r-kwo̱o̱z 20 ha-mo̱ u̱r-kwo̱o̱z u̱t-o̱p 30. ");
INSERT INTO uth_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Ye̱so ze̱e̱ru̱ ya-m-se̱nge̱, “Dooru̱nde̱ no̱ m-ho̱, no̱ shoos ka tur-to̱.” Ye̱ dooru̱ndu̱ru̱ m-ho̱. Ye̱ shoosu̱ru̱ to̱ u̱n ish u̱n ish. ");
INSERT INTO uth_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Ká da-de ne̱ Ye̱so ze̱e̱ru̱ ye̱, “Iib no̱ ka ho̱-mo̱, no̱ heete̱ go̱s-wu̱, wu̱ u̱r-ge.” Ye̱ ibu̱ru̱ m-ho̱, ye̱ heetu̱ru̱ go̱s-wu̱ wu̱ u̱r-ge. ");
INSERT INTO uth_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Ká go̱s-wu̱, wu̱ u̱r-ge wu̱ swo̱o̱ru̱ ka ho̱-mo̱, mo̱ warge̱ m-mo̱di à. Wu̱ hyanu̱ru̱ ka mo̱di-mo̱ jiishte̱ mo̱ u̱r-takan m-rwu̱u̱n. Wu̱ napu̱ ne̱ be-de ka ho̱-mo̱ rwu̱u̱ne̱ á. Amba ka ya-m-gu̱w-ye̱, ye̱ ibne̱ ka ho̱-mo̱ à ye̱ nepse̱. Wu̱ agnu̱ru̱ wu̱ a gege̱ u̱r-ge à. ");
INSERT INTO uth_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Wu̱ ze̱e̱ru̱ wu̱, “Ko̱ wu̱ ke ne̱t-wu̱ de̱ wu̱ ro̱ u̱n rwu̱nte̱ u̱n mo̱di-mo̱ m-re̱re̱m u̱r-takan. Da-o̱ hamat-ne̱ su̱u̱se̱ ye̱ ciks, wu̱ bu̱stu̱ru̱ u̱n mo̱ ba m-rwu̱u̱n kyak, amba wo̱ ne̱, o e̱ssu̱ndu̱ru̱ ká mo̱ jiishe̱ à se̱ m-mo̱ka o hante̱ mo̱.” ");
INSERT INTO uth_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","To̱ kà to̱ ro hyat-to̱ u̱r-takan, to̱ Ye̱so no̱me̱ o-Kana o̱ u̱n dak-o̱ o-Gariri à. O̱ wu̱ rwu̱ntu̱te̱ se̱ps-mo̱ u̱n wu̱, yan-neke̱-mo̱ u̱n wu̱ sheret u̱n wu̱. ");
INSERT INTO uth_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Bo̱ ye̱ caagu̱te̱ be-de u̱r-ge à, wu̱ argu̱ru̱ m-neke̱ bo̱-o̱ o-Kapanahum u̱n inu u̱n wu̱ ne̱, u̱n hen-ne̱ ye̱ u̱n wu̱ ne̱, u̱n yan-neke̱-mo̱ u̱n wu̱ ne̱. Ye̱ rewu̱ru̱ u̱t-ho̱ ka co̱-se ne̱ hiin. ");
INSERT INTO uth_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Biki-o̱ m-Pas o̱ u̱n Yahuda-ne̱ o̱ ro̱ yow yow, Ye̱so neku̱ru̱ o-Urusharima. ");
INSERT INTO uth_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Bo̱ wu̱ wo̱o̱bu̱te̱ o-Urusharima à, wu̱ co̱wu̱ru̱ u̱n Pyo-o̱ Shir. Wu̱ o̱ss yan-baab-to̱ u̱n na, u̱n ca-ne̱, u̱n tantabara-ne̱. Komo wu̱ hyanu̱ru̱ yan-shas-o̱ u̱n hwo̱r u̱r-she'et tara tara. ");
INSERT INTO uth_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Ye̱so gaaru̱ rak-yo o-hu̱, wu̱ yanu̱ru̱ kap mo̱ u̱n ye̱ u̱n Pyo-o̱ Shir u̱n ca-ye̱ u̱n ye̱ ne̱, u̱n na-ye̱ u̱n ye̱ ne̱. Wu̱ cakarsu̱ru̱ hwo̱r-ye̱ u̱n ya-o-shas. Wu̱ tutu̱ru̱ te̱bu̱r-to̱ u̱n ye̱. ");
INSERT INTO uth_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Wu̱ ze̱e̱ru̱ yan-baab-to̱ u̱n tantabara, “Dos no̱ saw-u̱t no̱, no̱ ruut to̱ m-mo̱ka m-mo̱ka. No̱ muut hur-o Tato re be-de u̱t-baab á!” ");
INSERT INTO uth_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Yan-neke̱-m Ye̱so baksu̱ru̱ u̱nze ge̱nse̱ to̱ ro̱ rem Kiristi be-de u̱n Ma-to̱ Shir u̱nze, “Shir, me̱ m-ho̱ge̱ u̱n re̱e̱b-o̱ u̱n hur-o ru de̱e̱n.” ");
INSERT INTO uth_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Se̱k-ye̱ be-de u̱n Yahuda-ne̱ shasu̱ru̱ wu̱, ye̱ zee, “To̱, ¿to̱ ke hyat-to̱ to̱ o he te̱ m-kute̱, te̱ nept u̱nze Shir-ye̱ ze̱e̱ wo̱ o nom ka rem-se?” ");
INSERT INTO uth_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Ye̱so shasu̱ru̱, wu̱ ze̱e̱ru̱ ye̱, “He̱e̱s no̱ ka Pyo-o̱ Shir o̱, ho̱-u̱t tet man 'yons o̱.” ");
INSERT INTO uth_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Se̱k-ye̱ be-de u̱n Yahuda-ne̱ ze̱e̱ru̱, “Se̱ da-o̱ a no̱me̱ u̱s-hak kwo̱o̱z-u̱t yoor u̱s-cind 46 à, a u̱n ma-to̱ u̱n o̱, ¿o̱ o he m-ze̱e̱ u̱n ya ne̱ wo̱a 'yons o̱ u̱n ho̱-u̱t tet?” ");
INSERT INTO uth_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Ye̱ napu̱ ne̱ ma-to̱ Ye̱so ro̱tte̱ á. Amba da-o̱ Ye̱so tane̱ Pyo-o̱ Shir à, wu̱r-o̱ u̱n wu̱ wu̱ rotte̱ u̱t-ma. ");
INSERT INTO uth_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Remen kaane̱ da-de a 'yonse̱ wu̱ u̱t-marimar à, yan-neke̱-mo̱ u̱n wu̱ baksu̱ru̱ u̱nze wu̱ ze̱e̱g kaane̱. Ye̱ she̱ru̱ru̱ u̱n Ma-to̱ Shir ne̱ to̱ a ge̱ne̱ à u̱n ma-u̱t Ye̱so ne̱ to̱ wu̱ ru̱re̱ ye̱ à. ");
INSERT INTO uth_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","To̱, da-o̱ wu̱ ro'e̱ o-Urusharima à, da-o̱ u̱n Biki-o̱ m-Pas, hun-ne̱ de̱e̱n she̱ru̱ru̱ u̱n jin-de u̱n wu̱ remen ye̱ hyanag rem-se u̱t-hyat se wu̱ ro m-no̱m à. ");
INSERT INTO uth_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Wu̱ ne̱ u̱n hi u̱n de u̱n wu̱, Ye̱so, wu̱ ho'os o-wu̱r u̱n ye̱ ne̱ á, remen wu̱ nepste̱ hur-de u̱n ko̱ wu̱ ke ne̱t-wu̱. ");
INSERT INTO uth_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Yanze se a ru̱ru̱te̱ wu̱ bo̱ hur-de u̱n ne̱t ro̱ á. Wu̱ nepste̱ bo̱ hur-de u̱n hun-ne̱ ro̱ à. ");
INSERT INTO uth_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Wu̱ ken ko-caari-wu̱ ro kon be-de u̱n Yahuda-ne̱, wu̱ ro̱ u̱n kur-de u̱n Parisa-ne̱ à, a wu̱ m-ze̱e̱ Neko̱dimu. ");
INSERT INTO uth_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Wu̱ wu̱ ha'e̱ be-u̱r Ye̱so m-te̱t. Wu̱ ze̱e̱ru̱ Ye̱so, “Wa-u̱s-Nap, te̱ nepste̱, wo̱ u̱n rwu̱u̱n be-de Shir, o yoosu̱te̱ hun-ne̱ Ma-to̱ Shir, remen yatt-wu̱ he hoks-m nom u̱n rem-se u̱t-hyat bo̱ o ro̱ se m-nom á, se̱ de̱ wu̱ ro̱ mo̱sse̱ u̱n Shir ne̱ à.” ");
INSERT INTO uth_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Ye̱so shasu̱ru̱ wu̱, “Me̱ wo̱ m-ru̱re̱ o-nip, o ho̱gu̱te̱. U̱n ya a ja'aste̱ mat u̱n ne̱t á, wu̱a hyen gwo̱mo-to̱ Shir á.” ");
INSERT INTO uth_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Neko̱dimu ze̱e̱ru̱, “¿Re ka ma-to̱ he m-nome̱, a ja'aste̱ ne̱t m-mat wu̱ mo̱ngse̱ à? ¿Wu̱a hoks m-warag u̱n me̱n-u̱t inu u̱n wu̱, wu̱ ja'aste̱ wu̱ m-mat?” ");
INSERT INTO uth_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Ye̱so ze̱e̱ru̱ wu̱, “Me̱ wo̱ m-ru̱re̱ o-nip. U̱n ba a makt ne̱t mat-o̱ m-ho̱ o-Ku̱kt ne̱ á, wu̱ ro̱tt co̱w-yo wu̱ hette̱ m-co̱w u̱n gwo̱mo-to̱ Shir á. ");
INSERT INTO uth_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Ne̱t-wu̱ a mate̱ u̱n wu̱r-o̱ u̱n ne'a u̱n campo̱ ne̱ à, ne̱t-wu̱ temb. Amba Ku̱kt-o ro̱ m-mat o-ku̱kt. ");
INSERT INTO uth_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Remen kaane̱ taase o hyen hyat-to̱ u̱m zette̱ wo̱ kaane̱ á, ‘Se̱ a ja'aste̱ mat-o ru.’ ");
INSERT INTO uth_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Yo-m ro̱ m-hur be-de mo̱ co̱ne̱ à. Wo̱ m-ho̱ge̱ ras-o̱ u̱n mo̱ temb, amba wo̱ nap be-de mo̱ rwu̱u̱ne̱ á, yagu̱nte̱ o nept be-de mo̱ ro̱ m-ha à. Kaane̱ o̱ komo be-de u̱n kap ne̱t-wu̱ Ku̱kt-o̱ Shir ja'ase̱ mat-o̱ u̱n wu̱ à.” ");
INSERT INTO uth_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Neko̱dimu shasu̱ru̱, wu̱ ze̱e̱ru̱, “To̱ ka ma-to̱, ¿re o̱ to̱ he m-nome̱?” ");
INSERT INTO uth_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Ye̱so shasu̱ru̱ wu̱, “Wo̱ wu̱ ro̱ m-yoose̱ u̱n Isra-ne̱ à, to̱ ka ma-to̱ komo, ¿wo̱ nap u̱n to̱ ne̱ á? ");
INSERT INTO uth_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Me̱ wo̱ m-ru̱re̱ o-nip. Se̱ rii-yo te̱ nape̱ à, u̱n yo te̱ hyane̱ ne̱ à, yo yo te̱ no̱ m-ru̱re̱ u̱n ma-to̱ u̱n yo. No̱ ne̱, no̱ m-go̱ks u̱n rii-yo te̱ no̱ m-ru̱re̱ á. ");
INSERT INTO uth_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","¿Re o̱ u̱n ya? Me̱ no̱ m-ru̱re̱ rem-se ro̱ n-dak à, no̱ go̱ks ma-to̱ u̱n se á. Yagu̱nte̱ rem-se ro̱ u̱n To̱n-o̱ shir à, se se u̱m he no̱ m-ru̱re̱ ma-to̱ u̱n se, no̱ go̱kste̱? ");
INSERT INTO uth_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Yatt-wu̱ take̱ m-da n-To̱n u̱n shir á, wu̱ hyenet bo̱ ka rem-se n-To̱n se ro̱ á, se̱ me̱ Wà-wu̱ u̱n ne̱t, wu̱ Shir to̱mne̱ à. ");
INSERT INTO uth_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Bo̱ Mosa jakse̱ hwo̱-yo o-kwo̱m n-to̱n o-ce n-te̱ o-dákár à, se̱ a jakste̱ me̱ Wà-wu̱ u̱n ne̱t kaane̱ n-to̱n. ");
INSERT INTO uth_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Ye̱a jaks me̱ n-to̱n o-kan, remen kap wu̱ she̱re̱ hur-de u̱n wu̱ be u̱n de à, wu̱ kumut ho̱o̱g-mo̱ ba m-ta. ");
INSERT INTO uth_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","“Remen was-mo̱ Shir wasse̱ u̱n ho̱no o-dak ne̱ à, o̱ hante̱ wu̱ to̱mo̱nte̱ mat-de u̱n Wà u̱n wu̱ wan-gaan cot. Wu̱ u̱n no̱m kaane̱, remen bo̱ u̱n ne̱t-wu̱ she̱re̱ hur-de u̱n wu̱ be-de u̱n wu̱ à, taase wu̱ sabre̱, amba wu̱ kumut ho̱o̱g-mo̱ ba m-ta. ");
INSERT INTO uth_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Shir u̱n to̱mo̱n Wà u̱n wu̱ ho̱no o-dak, remen wu̱ piishité̱ hun-ne̱ u̱t-ma á, amba remen hun-ne̱ possu̱té̱ ho̱-de u̱n piish u̱t-ma u̱n bu̱-yo u̱n wu̱. ");
INSERT INTO uth_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Kap bo̱ u̱n ne̱t-wu̱ she̱re̱ hur-de u̱n wu̱ u̱n Wà-wu̱ Shir à, a piishi wu̱ u̱t-ma á. Amba wu̱ she̱re̱ hur-de u̱n wu̱ u̱n Wà-wu̱ Shir á, a regu̱su̱te̱ a komsu̱te̱ wu̱ piishe̱ u̱t-ma o̱ ka, remen wu̱ she̱r hur-de u̱n wu̱ u̱n Wà-wu̱ Shir wan-gaan cot á. ");
INSERT INTO uth_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Ká piish-de u̱t-ma de de kà: Cecas-mo̱ Shir co̱wo̱nte̱ u̱n ho̱no o-dak, amba hun-ne̱ yagu̱ru̱ m-was u̱n ka cecas-mo̱ ne̱. Ye̱ jiishte̱ m-co̱n o-comb, remen rem-se ye̱ ro̱ m-no̱m à, rem-u̱s yo̱-se se. ");
INSERT INTO uth_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Kap wu̱ ro̱ m-no̱m u̱n rem-u̱s yo̱-se à, wan-yage̱ to̱ m-cecas wu̱. Wan-yage̱ to̱ m-cecas ne̱, wu̱ ro̱ m-e̱s m-ha be-de m-cecas á, u̱n taase ba'as-to̱ u̱n wu̱ rwu̱u̱n cas, hun-ne̱ hyen to̱. ");
INSERT INTO uth_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Wu̱ ro̱ m-no̱m u̱n rii-yo Shir co̱ne̱ à, wu̱ ro̱ m-ma'as m-ha be-de m-cecas, remen a rwu̱ntu̱te̱ rem-se u̱n wu̱ u̱s-so̱-se cas. Da-o̱ wu̱ ro be-de m-cecas, hun-ne̱ a nep u̱nze u̱n gwu̱-o̱ Shir o̱ wu̱ nomte̱ se.” ");
INSERT INTO uth_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Bo̱ Ye̱so komte̱ u̱t-ma u̱n Neko̱dimu ne̱ à, wu̱ argu̱ru̱ m-ha u̱n dak-o̱ o-Judiya u̱n yan-neke̱-mo̱ u̱n wu̱ ne̱. Wu̱ she'etu̱ndu̱ru̱ ka co̱ se ne̱ yan-ho̱ hiin, wu̱ ro̱ m-yo'os u̱n hun-ne̱ n-me̱ m-ho̱. ");
INSERT INTO uth_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","U̱n ka da-o̱ Yohana ro m-yo'os u̱n hun-ne̱ m-ho̱ u̱n de ken be-de de hun-ne̱ ro̱ m-aag o-Eno̱n à yow yow u̱n bo̱-o̱ o-Sarim ne̱. Wu̱ ro̱ u̱n yo'os u̱n hun-ne̱ u̱n Ro̱o̱g-o̱ o-Joda remen ho̱-m ro̱ ko̱n ka co̱-se ne̱ de̱e̱n mo̱ bo̱'o̱se̱ yo'os u̱n hun-ne̱ à. Hun-ne̱ ma'asu̱ru̱ m-ha káne̱, a ro ye̱ m-yo'os. ");
INSERT INTO uth_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","(Yo ka u̱n ko̱r rii-yo a ke'et Yohana o-kur o̱ m-ke'et.) ");
INSERT INTO uth_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","To̱, ma-u̱t su̱nu̱ru̱ yan-neke̱-m Yohana u̱n wu̱ ken ko-Yahuda-wu̱ ne̱, ma-to̱ u̱n so'os u̱s-rem bo̱ karamsa-o ze̱e̱ à. ");
INSERT INTO uth_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Yan-neke̱-m Yohana haaru̱ be-u̱r Yohana. Ye̱ ze̱e̱ru̱ wu̱, “Wa-u̱s-Nap, te̱ u̱n haan, te̱ ru̱ru̱tu̱ wo̱ ka ne̱t-wu̱, wu̱ no̱ rotte̱ pesto-de o-Joda à, wu̱ o ru̱ru̱ te̱ ma-to̱ u̱n wu̱ à, wu̱ ka u̱n yo'os u̱n hun-ne̱ n-te̱ m-ho̱. Hun-ne̱ de̱e̱n ye̱ ro̱ m-ha be-de u̱n wu̱.” ");
INSERT INTO uth_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Yohana shasu̱ru̱, “Yatt ne̱t-wu̱ he kum u̱n rii á, se̱ yo Shir ya'anu̱ wu̱ rwu̱u̱n-mo̱ n-To̱n à. ");
INSERT INTO uth_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","No̱ u̱n hi u̱n no̱ yan-swo̱-u̱s re ye̱, remen u̱m ze̱e̱g, ‘Me̱ wu̱ ro̱ Kiristi á, amba a u̱n to̱mo̱n me̱ u̱m ja'asu̱té̱ wu̱ o-co̱w.’ ");
INSERT INTO uth_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Be-de u̱n biki-o̱ u̱r-ge, wa-u̱r-ge-wu̱ ro̱ wan-ne'a u̱n wu̱. Ko-nay-wu̱ u̱n wa-u̱r-ge-wu̱ haane̱ biki-o̱ u̱r-ge à wu̱ ro̱ m-wase̱ temb wu̱ ho̱gu̱te̱ co̱r-o̱ u̱n wa-u̱r-ge. Komo me̱n-to̱ u̱n wu̱ ro̱ yaw yaw wu̱ ho̱ge̱ wa-u̱r-ge te̱pe̱rte̱. Kaane̱ o̱ ka me̱n-u̱t re shie̱ m-yeyaw. ");
INSERT INTO uth_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Wu̱ ne̱, gakte̱-mo̱ wu̱ waragte̱ go̱s-wu̱, me̱ ne̱ gakte̱-mo̱ u̱m waragte̱ re̱k-wu̱.” ");
INSERT INTO uth_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","“Wu̱ rwu̱u̱ne̱ n-To̱n à, wu̱ jiishe̱ u̱t-go̱s kap. Bo̱ u̱n wu̱ rwu̱u̱ne̱ n-dak à ko-ya-n-dak-wu̱, rem-se ro̱ n-dak à, se se wu̱ ro̱ m-rwo̱r. Amba wu̱ rwu̱u̱ne̱ n-To̱n à, ");
INSERT INTO uth_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","wu̱ ro̱ m-rwo̱r u̱n ma-to̱ u̱n ka rem-se wu̱ hyande̱ n-To̱n à, u̱n yo wu̱ ho̱gne̱ ne̱ à. Yatt-wu̱ go̱kse̱ ne̱ ka ma-to̱ á. ");
INSERT INTO uth_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Wu̱ go̱kse̱ ne̱ ma-to̱ u̱n wu̱ à, wu̱ ka e̱ste̱ Shir nip-o̱. ");
INSERT INTO uth_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Wu̱ Shir to̱mne̱ à, Ma-to̱ Shir to̱ wu̱ ro̱ m-rwo̱r, remen Shir ro̱ wu̱ m-'ya u̱n Ku̱kt-o̱ u̱n wu̱ ba u̱r-me'et. ");
INSERT INTO uth_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Tato-o waste̱ u̱n Wà u̱n wu̱ ne̱. Wu̱ bo̱psu̱te̱ wu̱ ko̱ yo ke rii-yo u̱n kom-to̱ u̱n wu̱. ");
INSERT INTO uth_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Wu̱ she̱re̱ hur-de u̱n wu̱ u̱n Wà-wu̱ Shir à, wu̱a kum ho̱o̱g-o̱ Shir o̱ ba m-ta. Ye̱ no̱me̱ ne̱ o-do̱ro̱tte̱ u̱n ka Wà-wu̱ ne̱ á, ye̱a hyen ho̱o̱g á, ryaab-se Shir ro̱ be-de u̱n ye̱.” ");
INSERT INTO uth_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","3","Parisa-ne̱ ho̱gu̱te̱ wu̱ ro̱ m-kum u̱n hun-ne̱ yan-dor komo wu̱ ro̱ m-yo'os u̱n hun-ne̱ n-te̱ m-ho̱, arge̱ Yohana. (Myet u̱n kaane̱ ne̱, Ye̱so wu̱ yo'os ye̱ m-ho̱ u̱n hi u̱n de u̱n wu̱ á, yan-neke̱-mo̱ u̱n wu̱ ne̱ ye̱). Bo̱ Ye̱so ho̱gu̱te̱ yo hun-ne̱ ro̱ m-rwo̱r à, wu̱ yagu̱ru̱ dak-o̱ o-Judiya, wu̱ wargu̱ru̱ dak-o̱ o-Gariri u̱n yan-neke̱-mo̱ u̱n wu̱ ne̱. ");
INSERT INTO uth_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Se̱ wu̱ do̱ru̱te̱ co̱w-yo caate̱ dak-o̱ o-Samariya à. ");
INSERT INTO uth_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Bo̱ wu̱ woote̱ u̱n o̱ ken bo̱-o̱ o̱ a m-ze̱e̱ o-Se̱kar u̱n dak-o̱ o-Samariya à, yow yow u̱n ma-de u̱n dak-o Yakubu ne̱, o̱ wu̱ ya'ase̱ wà u̱n wu̱ Yusuhu à, ");
INSERT INTO uth_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","8","káne̱ du-u̱r rowe̱ de ma Yakubu. Yan-neke̱-mo̱ u̱n wu̱ ne̱ haaru̱ o̱ u̱n rii-yo m-re̱ o-bo̱. Bo̱ hew-u̱r bo'oste̱ Ye̱so à, wu̱ she'etu̱ru̱ n-riib u̱r-du, n-no̱o̱nho̱, ho̱-u̱r ro u̱r-hi ge̱. Da-de wu̱ ro kane̱ tara à, se̱ wu̱ ken ne'a-wu̱ ko-Samariya, wu̱ wo̱o̱nu̱ru̱ o-tur ne̱. Wu̱ haante̱ iib m-ho̱. Ye̱so ze̱e̱ru̱ ka ne'a-wu̱, “Ya me̱ m-ho̱ u̱m su̱.” ");
INSERT INTO uth_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Ká ne'a-wu̱ ze̱e̱ru̱, “¿Ya mo̱ssu̱ na cen na, wo̱tte̱ me̱ u̱n ko̱n-se u̱n ho̱-mo̱ m-swo̱? Wo̱ ko-Yahuda-wu̱, me̱ ne̱ ko-Samariya-wu̱.” (Ka ne'a-wu̱ ze̱e̱g Ye̱so kaane̱ remen Samariya-ne̱ ye̱ ro̱ m-mo̱sse̱ u̱t-kom u̱n Yahuda-ne̱ á.) ");
INSERT INTO uth_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Ye̱so ze̱e̱ru̱ ka ne'a-wu̱, “Wo̱ ro nakke̱ yar-mo̱ Shir, u̱n wu̱ wu̱ to̱mne̱ ne̱ à, o roa cit ka wu̱ ro̱ wo̱ u̱s-ko̱n o 'ye wu̱ m-ho̱ wu̱ su̱ à, wu̱ roa 'ye wo̱ ne̱ ho̱-mo̱ u̱n ho̱o̱g o su̱.” ");
INSERT INTO uth_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Ka ne'a-wu̱ ze̱e̱ru̱ wu̱, “Go̱s-wu̱, wo̱tt rii-o̱ m-iib m-ho̱ á, du-de ka ne̱ u̱r-du̱w ne̱. ¿Ke ne̱ o̱ o he kum u̱n ká ho̱-mo̱ mo̱ ro̱ u̱n ya'u̱ u̱n ho̱o̱g à, mo̱ o he me̱ m-'ya u̱m su̱u̱t? ");
INSERT INTO uth_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","¿Wo̱ u̱n jiish o̱ tato na Yakubu, wu̱ u̱bu̱ na ka du-de, yakar-ye̱ u̱n wu̱ su̱, komo u̱n gu̱t-to̱ u̱n wu̱ ne̱ kap to̱ su̱?” ");
INSERT INTO uth_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Ye̱so ze̱e̱ru̱ ka ne'a-wu̱, “Bo̱n ne̱t-wu̱ ro̱ m-swo̱ u̱n ka du-de à, wu̱a do m-ho̱ge̱ o-swo̱o̱t komo. ");
INSERT INTO uth_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Amba ne̱t-wu̱ he m-swo̱ ho̱-mo̱ u̱m he wu̱ m-'ya à, wu̱a do m-ho̱ge̱ o-swo̱o̱t á, har da-o̱ ba m-ta. Remen ho̱-mo̱ u̱m he wu̱ m-'ya à, mo̱a warag u̱ntu̱n yish-to̱ m-ho̱ u̱n me̱n-to̱ u̱n wu̱. Mo̱a 'ye wu̱ ho̱o̱g-mo̱ ba m-ta.” ");
INSERT INTO uth_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Ka ne'a-wu̱ ze̱e̱ru̱, “Go̱s-wu̱, 'ya me̱ ka ho̱-mo̱ u̱m su̱ u̱n taase u̱m ma'as m-ho̱ge̱ o-swo̱o̱t, u̱m ma'as m-haan iib m-ho̱.” ");
INSERT INTO uth_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Ye̱so ze̱e̱ru̱ wu̱, “Ha o agan campo̱ ru, no̱ haan.” ");
INSERT INTO uth_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Ká ne'a-wu̱ ze̱e̱ru̱ Ye̱so, “Me̱tt campo̱ á.” Ye̱so ze̱e̱ru̱ wu̱, “O rwo̱ro̱g o̱ Shir, ");
INSERT INTO uth_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","remen campo̱-ne̱ taan gaag wo̱, ka wu̱ o ro̱tte̱ ne̱ m-mo̱ka o-hur à campo̱ ru wu̱ o-jip wu̱ á.” ");
INSERT INTO uth_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Ka ne'a-wu̱ ze̱e̱ru̱ Ye̱so, “Go̱s-wu̱, u̱m nak m-mo̱ka wo̱ ko-wan-rwo̱r u̱n Ma-to̱ Shir o ro̱. ");
INSERT INTO uth_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","U̱n ka haag-o̱, tat-ne̱ te̱ ne̱ ro m-nome̱ Shir m-gu̱w. Amba no̱ ne̱, Yahuda-ne̱ no̱ zee, u̱depe̱ a nome̱ Shir m-gu̱w kàne̱ á, se̱ o-Urusharima.” ");
INSERT INTO uth_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Ye̱so ze̱e̱ru̱ wu̱, “Ne'a, go̱ks ma-u̱t re, da-o ro̱o̱n, o̱ atte̱ a do nome̱ u̱n Shir m-gu̱w u̱n ka haag-o̱ á, ko̱ ne̱ o-Urusharima á. ");
INSERT INTO uth_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","No̱ Samariya-ne̱, no̱ nap Shir ye̱ no̱ m-nome̱ m-gu̱w á. Te̱ ne̱, Yahuda-ne̱ te̱ nepste̱ Shir ye̱ te̱ m-nome̱ m-gu̱w à, remen co̱w-yo u̱n gwu̱ be-de u̱n Yahuda-ne̱ o̱ yo rwu̱u̱ne̱. ");
INSERT INTO uth_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Amba da-o ro̱o̱n, ko̱ m-mo̱ka ma o̱ nomoste̱, da-o̱ a hette̱ nome̱ u̱n Shir m-gu̱w bo̱ Ku̱kt-o̱ Shir do̱ru̱tte̱ à, komo u̱n bu̱-yo u̱n nip-o̱ Shir. Remen go̱n ka hun-ne̱ ye̱, ye̱ he nome̱ u̱n Shir m-gu̱w o-nip ne̱ n-me̱ o-Ku̱kt à, go̱n u̱n ye̱ Shir o-Tato co̱ne̱ ye̱ nome̱ wu̱ m-gu̱w. ");
INSERT INTO uth_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Shir Ku̱kt-o̱. Kap bo̱ u̱n wu̱ ro̱ wu̱ m-nome̱ m-gu̱w à, se̱ wu̱ nomo wu̱ m-gu̱w u̱n ku̱kt-o̱ o-nip ne̱.” ");
INSERT INTO uth_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Ka ne'a-wu̱ ze̱e̱ru̱ Ye̱so, “U̱m nepste̱ Mesaya ro̱o̱n, da-o̱ wu̱ wo̱o̱ne̱, wu̱a ru̱ru̱ na ko̱ yo ke rii-yo kap.” ");
INSERT INTO uth_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Ye̱so ze̱e̱ru̱ wu̱, “Me̱ ro̱ wu̱, me̱ wu̱ ro̱ u̱t-ma u̱n wo̱ ne̱ à.” ");
INSERT INTO uth_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","A káne̱, ka yan-neke̱-m Ye̱so ye̱ mu̱u̱nu̱ru̱. Ye̱ wo̱o̱n, ye̱ 'wo̱s ka ne'a-wu̱ ro̱ u̱t-orom u̱n Ye̱so ne̱. Ye̱ hyanu̱ru̱ hyat-to̱ u̱n káane̱. Amba, yatt-wu̱ hokse̱ hak o-nu, wu̱ cit wu̱, wu̱ zet wu̱, “¿Ya wo̱ o-hoob?” Ko̱, “¿Ya o co̱ne̱ be-de u̱n wu̱?” ");
INSERT INTO uth_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Ka ne'a-wu̱ ho'osu̱ru̱ o-tur n-riib u̱r-du. Wu̱ argu̱ru̱ m-warag o-hur u̱n ka bo̱-o̱ o-rek o-rek. Wu̱ wo̱be̱, wu̱ ze̱e̱ru̱ hun-ne̱, ");
INSERT INTO uth_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Rwu̱u̱n no̱, haan no̱ gu̱t ne̱t-wu̱ ru̱ru̱ me̱ kap bo̱ u̱n rem-se u̱m we̱te̱ m-no̱m à! ¿Ko̱ wu̱ ro̱ Kiristi?” ");
INSERT INTO uth_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Hun-ne̱ rwu̱u̱nu̱ru̱, ye̱ ro̱ wu̱ u̱n ha m-gwo̱t. ");
INSERT INTO uth_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Bo̱ ka ne'a-wu̱ heeste̱ aag u̱n hun-ne̱ o-bo̱ à, ka da-o̱ yan-neke̱-m Ye̱so ye̱ ze̱e̱ru̱ wu̱, “Wa-u̱s-Nap, re̱ rii-yo m-re̱.” ");
INSERT INTO uth_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Amba Ye̱so ze̱e̱ru̱ ye̱, “U̱m ro̱ u̱n rii-yo m-re̱ ne̱, go̱ u̱n yo no̱ nape̱ á.” ");
INSERT INTO uth_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Amba yan-neke̱-m Ye̱so ye̱ ma'asu̱ru̱ u̱t-ma u̱n hi u̱n de u̱n ye̱. Ye̱ ro̱ m-ze̱e̱, “¿Ko̱ wu̱ ken ne̱t-wu̱ u̱n hante̱ wu̱ rii-yo m-re̱ o̱?” ");
INSERT INTO uth_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Ye̱so ze̱e̱ru̱ ye̱, “Rii-yo m-re̱ re yo ka, u̱m nom o-do̱ro̱tte̱ u̱n ma-to̱ u̱n wu̱ to̱mnu̱ me̱ à, u̱m komot se̱nge̱-mo̱ wu̱ yasu̱ me̱ à. ");
INSERT INTO uth_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","¿No̱ ka m-ma'as m-ze̱e̱ ‘Kuks re̱ng-u̱s nass a ceet m-ce’? U̱m ze̱e̱g no̱, das no̱ u̱t-hi, no̱ gu̱t u̱t-kat, no̱a hyen to̱ neneste̱. To̱ co̱no̱g m-ce. ");
INSERT INTO uth_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Bo̱ ko-wa-m-ce ro̱ m-karagse̱ u̱n hyo à, káane̱ o̱ komo wu̱ he woot u̱n hun-ne̱ be-de Shir ye̱ kumut ho̱o̱g-o̱ ba m-ta. Wa-u̱r-go u̱n wa-m-ce ne̱ ye̱a nom o-zak be-u̱r gaan. ");
INSERT INTO uth_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Ka ma-to̱ ro̱ o-nip ne̱, wu̱ ken ro̱ u̱r-go, wu̱ ken ro̱ m-ce. ");
INSERT INTO uth_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","U̱m to̱mo̱g no̱ be-de u̱n kat-o̱ no̱ go̱ u̱r-go u̱n o̱ á, no̱ ce. Ye̱ ken ye̱ gwo̱wo̱g, no̱ ce̱e̱ru̱ ka go-de u̱n ye̱ de.” ");
INSERT INTO uth_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","To̱, Samariya-ne̱ de̱e̱n u̱n ka bo̱-o̱ ye̱ she̱ru̱ru̱ hur-de u̱n ye̱ be-de u̱n wu̱ remen ma-to̱ ka ne'a-wu̱ rwo̱re̱ à. Wu̱ zee, “Ka ne̱t-wu̱ ru̱ru̱tu̱ me̱ kap rii-yo u̱m nome̱ à.” ");
INSERT INTO uth_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Remen kááne̱ bo̱ Samariya-ne̱ wo̱o̱nte̱ be-u̱r Ye̱so à, ye̱ ko̱nu̱ru̱ wu̱, wu̱ he wu̱ rewe̱ be-de u̱n ye̱. Ye̱so rewu̱ru̱ káne̱ ho̱-u̱t yoor. ");
INSERT INTO uth_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Ye̱ ken ye̱ dooru̱ she̱r u̱n hur-de u̱n ye̱ be-de u̱n wu̱ de̱e̱n remen ma-to̱ wu̱ rwo̱re̱ à. ");
INSERT INTO uth_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Ka da-de ye̱ ze̱e̱ru̱ ka ne'a-wu̱, “M-mo̱ka te̱ hyanag wu̱ u̱n hi u̱n te̱, te̱ ho̱gu̱te̱ ma-to̱ u̱n wu̱. Te̱ ro̱ m-she̱r hur u̱n te̱ be-de u̱n wu̱, yanze remen rwo̱r-m ru á. Nip-o̱, wu̱ ka Wan-Gwu̱-o̱ u̱n ho̱no o-dak wu̱!” ");
INSERT INTO uth_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","To̱, ka rew-mo̱ u̱n ho̱-u̱t yoor mo̱, mo̱ wu̱ rewe̱ káne̱ à, wu̱ inu̱ru̱. Wu̱ ro̱ m-ha dak-o̱ o-Gariri. ");
INSERT INTO uth_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","(Remen Ye̱so rwo̱ro̱g u̱n hi u̱n de u̱n wu̱, wu̱ zee, “Wan-rwo̱r u̱n Ma-to̱ Shir, ro̱tt m-se̱k u̱n bo̱-o̱ u̱n wu̱ á.”) ");
INSERT INTO uth_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Bo̱ wu̱ woote̱ o-Gariri à, hun-ne̱ go̱ksu̱ru̱ wu̱ u̱r-bon ne̱. Ye̱ no̱mo̱g kaane̱ remen ye̱ heeste̱ ka Biki-o̱ m-Pas o̱ o-Urusharima, komo ye̱ hyanag kap rem-se u̱t-hyat se Ye̱so no̱me̱ à. ");
INSERT INTO uth_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Wu̱ dooru̱ m-ha o-Kana u̱n dak-o̱ o-Gariri be-de wu̱ muute̱ m-ho̱, m-mo̱di à. Wu̱ ken ko-Gajem wu̱ ro kon káne̱ wu̱ wà u̱n wu̱ ro u̱n go̱m à u̱n bo̱-o̱ o-Kapanahum. ");
INSERT INTO uth_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Bo̱ wu̱ ho̱gu̱te̱ Ye̱so rwu̱u̱nte̱ dak-o̱ o-Judiya à, Ye̱so mu̱u̱nte̱ dak-o̱ o-Gariri, wu̱ haaru̱ be-u̱r Ye̱so. Wu̱ ro wu̱ u̱s-ko̱n u̱nze wu̱ haan wu̱ dosse̱ wà u̱n wu̱ go̱m, wu̱ ro u̱n ma-to̱ m-mar à. ");
INSERT INTO uth_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Ye̱so ze̱e̱ru̱ wu̱, “No̱tt m-she̱r u̱n hur-u̱r no̱ á ko̱ wan-gaan, se̱ no̱ hyanag rem-se u̱t-hyat.” ");
INSERT INTO uth_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Ka Gajem-wu̱ ze̱e̱ru̱, “Go̱s-wu̱, hakku̱re̱ haan rii-yo wà re meret.” ");
INSERT INTO uth_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Ye̱so ze̱e̱ru̱ wu̱, “Jo'obe̱, go̱m wà ru teeste̱.” Ka ne̱t-wu̱ she̱ru̱ru̱ u̱n ma-u̱t Ye̱so ne̱ to̱ wu̱ rwo̱re̱ à, wu̱ argu̱ru̱ jo. ");
INSERT INTO uth_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Bo̱ wu̱ rotte̱ u̱n jo à, ba wu̱ u̱n goshi wo̱ o-hur, gu̱w-ne̱ ye̱ u̱n wu̱ gontu̱ru̱ wu̱. Ye̱ ru̱ru̱ wu̱, ye̱ zee, “Wà ro̱ u̱n ho̱o̱g ne̱. Go̱m teeste̱.” ");
INSERT INTO uth_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Wu̱ citu̱ru̱ ye̱ da-o̱ ka go̱m-o ho'ose̱ wà hond hond à. Ye̱ ze̱e̱ru̱ wu̱, “M-ryo hond hond kwo̱m-o gaan yo n-no̱o̱nho̱ go̱m ho'ose̱ wu̱.” ");
INSERT INTO uth_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Ka tato-o̱ napu̱ru̱ u̱nze u̱n ka da-o̱ Ye̱so ze̱e̱ wu̱, “Wà ru ro̱ u̱n ho̱o̱g ne̱. Go̱m teeste̱ wu̱.” Remen kááne̱, wu̱ u̱n yan-hur-o̱ u̱n wu̱ ne̱ ke̱'ke̱ she̱ru̱ru̱ u̱nze Ye̱so wu̱ ro̱ Kiristi. ");
INSERT INTO uth_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Hyat-u̱t ayoore̱-to̱ ka to̱ Ye̱so no̱me̱ u̱n dak-o̱ o-Gariri, da-de wu̱ rwu̱u̱ne̱ dak-o̱ o-Judiya. ");
INSERT INTO uth_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Bo̱ u̱n káne̱, Ye̱so haaru̱ o̱ ken biki-o̱ u̱n Yahuda-ne̱ o̱ o-Urusharima. Ye̱so haaru̱ o̱. ");
INSERT INTO uth_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","O̱ ken ish-o̱ ro kon o̱ a m-ze̱e̱ Ish-o̱ u̱n Ca à. O̱ ken kaw-o̱ ro̱ ko̱n kane̱ yow yow u̱n o̱ ne̱ a o̱ m-ze̱e̱ o-Basayada à, u̱n rem-de u̱n u̱t-Ibra. A rigimshite̱ o̱ u̱n sak-u̱t taan. ");
INSERT INTO uth_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Ya-u̱s-go̱m ro kon káne̱ po̱-ne̱, u̱n ryam-ne̱ ne̱, u̱n yan go̱m-o̱ u̱s-hwo̱ ne̱. Ye̱ ro̱ do̱mb do̱mb. ");
INSERT INTO uth_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Wu̱ ken ne̱t-wu̱ be-de u̱n ye̱ wu̱ no̱mo̱g hak-u̱r kwo̱o̱z u̱n o̱p u̱s-eer 38 wu̱ ro̱ u̱n ka go̱m-o̱. ");
INSERT INTO uth_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Bo̱ Ye̱so hyente̱ wu̱ à, wu̱ nepste̱ wu̱ she'ete̱ u̱n ka go̱m-o̱ ne̱. Ye̱so citu̱ru̱ wu̱, “¿Ko̱ o co̱no̱g a dossu̱ wo̱ ka go̱m-o̱?” ");
INSERT INTO uth_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Ka wan-go̱m wu̱ shasu̱ru̱, “Go̱s-wu̱, ai, me̱tt ne̱t-wu̱ he me̱ m-he̱'e̱dbe̱ m-ho̱, da-o̱ wan-to̱m-wu̱ Shir bu̱re̱ mo̱ á. Da-o̱ kap wan-to̱m-wu̱ Shir he̱'e̱be̱, wu̱ bu̱re̱ m-ho̱, da-o̱ me̱ ine̱ m-he̱'e̱be̱, wu̱ ken ba'u̱ru̱ me̱ m-he̱'e̱be̱.” ");
INSERT INTO uth_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Ye̱so ze̱e̱ru̱ wu̱, “Ine̱ ge̱! Mos rii-o̱ u̱r-ru̱t o̱ ru, o neke̱.” ");
INSERT INTO uth_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","U̱n gyept-o̱ u̱n yish, ka go̱m-o̱ argu̱ru̱ wu̱ m-ho'os. Wu̱ mossu̱ru̱ rii-o̱ ru̱t-o̱ u̱n wu̱. Wu̱ argu̱ru̱ jo. To̱, u̱n ka Ho̱-de ne̱ Ho̱-de u̱r-Wu̱we̱ de. ");
INSERT INTO uth_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Remen kááne̱, se̱k-ye̱ ye̱ u̱n Yahuda-ne̱ ze̱e̱ru̱ wu̱ a taase̱ go̱m à, “Ho̱-de u̱r-Wu̱we̱ de. U̱depe̱ o mos rii-o̱ u̱r-ru̱t o̱ ru á.” ");
INSERT INTO uth_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Wu̱ shasu̱ru̱ ye̱, “Wu̱ taasu̱ me̱ go̱m à, wu̱ wu̱ ze̱e̱ u̱m mos rii-o̱ u̱r-ru̱t o̱ re, u̱m arag jo.” ");
INSERT INTO uth_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Ye̱ citu̱ru̱ wu̱, “¿Wan wu̱ ne̱ ze̱e̱ wo̱ o mos rii-o̱ u̱r-ru̱t o ru, o neke̱?” ");
INSERT INTO uth_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Amba wu̱ a taase̱ ka go̱m-o̱ à, wu̱ nap wu̱ á, remen Ye̱so be'essu̱te̱ wu̱ yagu̱su̱te̱ ka be-de remen mo̱o̱r-to̱ u̱n hun-ne̱. ");
INSERT INTO uth_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Bo̱ jimite̱ à, Ye̱so hyanu̱ru̱ wu̱ u̱n Pyo-o̱ Shir. Ye̱so ze̱e̱ru̱, “A taasu̱tu̱ wo̱ ka go̱m-o̱, o kumuste̱ m-keke̱r. Taase o do no̱m u̱r-ba'as á, u̱ntaase yo ken rii-yo yo jiishe̱ yo ka à yo do wo̱ m-ko̱r.” ");
INSERT INTO uth_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Ka wu̱ a taase̱ go̱m à, wu̱ haaru̱, wu̱ ru̱ru̱ Yahuda-ne̱. Wu̱ zee Ye̱so wu̱ taasu̱ wu̱ ka go̱m-o̱. ");
INSERT INTO uth_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Bo̱ wu̱ ru̱ru̱te̱ ye̱ kááne̱ à, Yahuda-ne̱ inu̱ru̱ Ye̱so te̱p, ye̱ zee, “¿Ya hante̱ o taasu̱te̱ wu̱ ka go̱m-o̱ u̱n Ho̱-de u̱r-Wu̱we̱?” ");
INSERT INTO uth_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Ye̱so shasu̱ru̱ ye̱, “Tato re ro̱ m-se̱nge̱ ko̱ da u̱n ke. Me̱ u̱n ce re me̱ m-se̱nge̱ ko̱ da u̱n ke.” ");
INSERT INTO uth_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Ka da-de ne̱, Yahuda-ne̱ inu̱ru̱ hoob-o̱ u̱n co̱w-yo ye̱ bu̱pt Ye̱so, ye̱ hoot wu̱, remen ye̱ ho̱gu̱te̱ wu̱ rwo̱ro̱g kááne̱, ye̱ hyanag wu̱ yo'ogte̱ Ho̱-de u̱r-Wu̱we̱. Komo wu̱ ze̱e̱g Shir Tato u̱n wu̱. Wu̱ muutte̱ hi u̱n de u̱n wu̱ hond hond u̱n Shir ne̱. ");
INSERT INTO uth_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Ye̱so ze̱e̱ru̱ ye̱, “Me̱ no̱ m-ru̱re̱ o-nip, me̱ wu̱ ro̱ Wà be-de Shir o-Tato à, man hoks no̱m u̱n rii á, se̱ rii-yo u̱m hyane̱ Tato-o ro̱ m-no̱m à. Remen kap mo̱ u̱n rii-yo Shir o-Tato ro̱ m-no̱m à, ka bo̱-se ne̱ Wà ro̱ m-no̱m u̱n ce u̱n wu̱. ");
INSERT INTO uth_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Tato-o ro̱ m-was u̱n Wà ne̱. Kap mo̱ u̱n rii-yo Tato-o ro̱ m-nom à, wu̱a kute̱ yo Wà har rem-se jiishe̱ se ka rem-se u̱t-hyat à se no̱ hyan à, remen no̱ hun-ne̱ no̱ hyenet u̱t-hyat. ");
INSERT INTO uth_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Remen bo̱ Tato-o ro̱ m-'yons u̱n margan-ne̱ u̱n ho̱o̱g ne̱ à, ka bo̱-se ne̱ o̱ komo Wà ro̱ m-'yons be-de u̱n ye̱ wu̱ daage̱ à. ");
INSERT INTO uth_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Tato-o ro̱ u̱n piishe̱ u̱n ne̱t u̱t-ma u̱n hi u̱n de u̱n wu̱ á. Amba wu̱ bo̱bsu̱te̱ Wà u̱n wu̱ be̱e̱b-de u̱n piish u̱t-ma, ");
INSERT INTO uth_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","remen kap o̱ u̱n hun-ne̱ ye'et Wà m-se̱k bo̱ a u̱n 'ya o-Tato à. Amba bo̱ u̱n wu̱ yage̱ 'ya u̱n Wà m-se̱k à wu̱ 'ya o̱ ka o-Tato m-se̱k wu̱ to̱mne̱ Wà á. ");
INSERT INTO uth_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Me̱ no̱ m-ru̱re̱ o-nip, kap ne̱t-wu̱ ro̱ m-ho̱ge̱ ma-u̱t re à, wu̱ ro̱ m-she̱r u̱n hur-de u̱n wu̱, u̱n wu̱ to̱mne̱ me̱ komo ne̱ à, wu̱ ro̱ u̱n ho̱o̱g-o̱ u̱n ba m-ta ne̱. A piishe̱ wu̱ u̱t-ma á, remen wu̱ be'essu̱te̱, wu̱ possu̱ssu̱te̱ m-mar, wu̱ wo̱o̱g be-de u̱n kum u̱n ho̱o̱g. ");
INSERT INTO uth_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","“Me̱ no̱ m-ru̱re̱ o-nip, da-o ro̱o̱n, m-mo̱ka ne̱ ma o̱ nomoste̱, o̱ margan-ne̱ hette̱ ho̱ge̱ u̱n co̱r-o̱ u̱n Wà-wu̱ Shir à. Ya-m-ho̱ge̱ ne̱ ye̱a nom ho̱o̱g. ");
INSERT INTO uth_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Remen bo̱ Tato-o ro̱ wan-ho̱o̱g à, wan-'ya u̱n hun-ne̱ ho̱o̱g, ka bo̱-se ne̱ o̱ ne̱ Tato-o ze̱e̱ Wà u̱n wu̱ he m-warag wan-ho̱o̱g wu̱ ro̱ u̱n 'ya u̱n hun-ne̱ ho̱o̱g komo à. ");
INSERT INTO uth_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Wu̱ ya'ag wu̱ komo ne̱ u̱r-be̱e̱b de u̱n piish u̱t-ma, remen wu̱ ro̱ Wà-wu̱ u̱n ne̱t. ");
INSERT INTO uth_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","“Taase no̱ hyen hyat-to̱ u̱n ka ma-to̱ á, remen da-o ro̱o̱n da-o̱ margan-ne̱ ye̱ ro̱ n-me̱ u̱s-saag he ho̱ge̱ u̱n co̱r-o̱ u̱n Wà-wu̱ Shir à. ");
INSERT INTO uth_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Ye̱ ho̱ge̱ komo, ye̱a rwu̱u̱n. Ye̱ no̱me̱ yo u̱r-bon à, ye̱a ine̱ ha-mo̱ u̱n ho̱o̱g. Ye̱ no̱me̱ ne̱ yo̱-o à, ye̱a ine̱ ha-mo̱ u̱n piish u̱t-ma. ");
INSERT INTO uth_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Yatt-yo u̱m he hoks m-no̱m u̱n be̱e̱b u̱n de á. Me̱ de̱ m-piish u̱t-ma temb bo̱ Shir ze̱e̱ me̱ à. No̱ nak piish u̱n ma-u̱t re hond hond o̱, yanze se̱nge̱-m re mo̱ u̱m nomot yo u̱m co̱ne̱ á, amba u̱m nomot o̱ rii-yo wu̱ to̱mne̱ co̱ne̱ à. ");
INSERT INTO uth_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“U̱rege̱ me̱ su̱'e̱ hi u̱n de, to̱ swo̱-u̱s se se o-nip se á. ");
INSERT INTO uth_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Amba wu̱ ken wu̱ ro̱ me̱ m-su̱'e̱. Bo̱ wu̱ ro̱ me̱ m-su̱'e̱ à, u̱m nepste̱ u̱n ka to̱r-se ne̱, se o-nip se. ");
INSERT INTO uth_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","No̱ to̱mo̱g hun-ne̱ be-u̱r Yohana Wa-m-Yo'os u̱n hun-ne̱ m-ho̱, Yohana ne̱, wu̱ wuku̱nte̱ no̱ á. Wu̱ ru̱ndu̱ru̱ no̱ o-nip mo̱sse̱ u̱n ma-u̱t re ne̱. ");
INSERT INTO uth_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Amba kap u̱n kááne̱ ne̱, swo̱-se u̱m ro̱tte̱ m-ya'as m-'wo̱ns u̱n se ne̱ à, swo̱-se u̱n ne̱t se á. Me̱n rwo̱r kááne̱ remen no̱ bakste̱ u̱n ma-u̱t Yohana ne̱ to̱ wu̱ rwo̱re̱ à, no̱ kumut gwu̱ be u̱n de. ");
INSERT INTO uth_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Yohana ne̱ sha-mo̱ u̱r-pitirra mo̱, de u̱n 'ya u̱n no̱ m-cecas u̱r-bon ne̱ à. No̱ u̱n re̱e̱b-o̱ u̱n ma-to̱ u̱n wu̱ u̱n ya o-da hiin. ");
INSERT INTO uth_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","“Amba swo̱-se u̱m ro̱tte̱ à, se aragte̱ se ma Yohana m-'wo̱ns remen se̱nge̱-mo̱ Tato-o ya'su̱nde̱ me̱ u̱m nom à, mo̱ mo̱ me̱ m-nom. Ká se̱nge̱-mo̱ ne̱ mo̱ me̱ m-no̱m à, mo̱ mo̱ su̱u̱ me̱ a hette̱ m-nap u̱nze Shir o-Tato wu̱ to̱mne̱ me̱. ");
INSERT INTO uth_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","O-Tato komo o̱ to̱mne̱ me̱ à, wu̱ su̱'e̱ me̱ u̱n hi u̱n de u̱n wu̱. No̱ ne̱, no̱ tak m-ho̱ge̱ u̱n co̱r-o̱ u̱n wu̱ á har no̱ hyenet sha-mo̱ u̱n wu̱ á. ");
INSERT INTO uth_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Ma-to̱ u̱n wu̱ komo, to̱ ro̱ ko̱n u̱n hur-u̱r no̱ á, remen no̱ she̱r hur-u̱r no̱ u̱n me̱ wu̱ Shir to̱mne̱ be u̱n no̱ á. ");
INSERT INTO uth_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","No̱ ne̱ komo u̱n m-byarag u̱n Ma-to̱ Shir to̱ a ge̱ne̱ à. No̱ m-hyan sa o zee no̱a kum ho̱o̱g-o̱ ba m-ta kane̱ n-me̱. Ka taku̱rda-to̱ ne̱ to̱ ro̱ me̱ m-su̱'e̱. ");
INSERT INTO uth_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Amba kap u̱n kaane̱ ne̱, no̱ haan be u̱n de, no̱ kumut ho̱o̱g á. ");
INSERT INTO uth_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Me̱ was u̱n bo̱ngo̱n-de u̱n ko-hun-ne̱ á. ");
INSERT INTO uth_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","No̱ ne̱, u̱m nepste̱ no̱ was u̱n Shir ne̱ u̱n hur-u̱r no̱ á. ");
INSERT INTO uth_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Rii-yo hante̱ u̱m zet kááne̱ à, u̱n be̱e̱b-de u̱n wu̱ de u̱m haante̱, no̱ go̱ks me̱ á. Wu̱ ken wu̱ haane̱ u̱n be̱e̱b-de u̱n hi u̱n de u̱n wu̱, no̱a go̱ks wu̱ o-zak o-zak. ");
INSERT INTO uth_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","¿No̱a she̱r hur-u̱t no̱ u̱n me̱ ne̱? No̱ m-ho̱ge̱ zak-o̱ u̱n bo̱ngo̱n-de o̱r no̱ ne̱ ro̱ no̱ m-nome̱ à. Amba no̱ was u̱n bo̱ngo̱n-de rwu̱u̱ne̱ be-de Shir ne̱ u̱n ho̱n-de u̱n wu̱ á. ");
INSERT INTO uth_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","“No̱ hyan no̱ zee me̱ wu̱ he m-heet u̱n gyekt-u̱s no̱ be-de Shir á. Wu̱ he gyekt-u̱s no̱ à wu̱ ro̱ ko̱n, wu̱ ro̱ Mosa, wu̱ no̱ ro o-sakto̱ no̱ zee wu̱ he no̱ m-be̱e̱s à. ");
INSERT INTO uth_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","No̱ ro bo̱kke̱ ma-u̱t Mosa, no̱ ro̱a she̱r hur-u̱r no̱ be u̱n de, remen ma-u̱t re to̱ Mosa ge̱ne̱. ");
INSERT INTO uth_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","No̱ she̱r hur-u̱r no̱ u̱n ma-u̱t Mosa ne̱ á, ¿ke o̱ no̱ he hoks m-she̱r u̱n hur-u̱r no̱ u̱n ma-u̱t re ne̱?” ");
INSERT INTO uth_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Bo̱ Ye̱so komte̱ u̱t-ma u̱n Yahuda-ne̱ ne̱ à, wu̱ inu̱ru̱, wu̱ haaru̱ pesto-de u̱n Mar-o̱ o-Gariri, (mo̱ a m-aag Mar-o̱ o-Tiberiyos à). ");
INSERT INTO uth_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Hun-ne̱ u̱t-mo̱o̱r ne̱ argu̱ru̱ wu̱ m-do̱re̱ remen ye̱ hyanag rem-se u̱t-hyat se wu̱ no̱me̱ be-de u̱n ya-u̱s-go̱m à. ");
INSERT INTO uth_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Ye̱so ne̱, wu̱ daaru̱ n-to̱n o-haag u̱n yan-neke̱-mo̱ u̱n wu̱ ne̱. Wu̱ she'etu̱ru̱ n-to̱n u̱n ye̱ ne̱. ");
INSERT INTO uth_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Ye̱ ro̱ káne̱, da-o̱ u̱n Biki-o̱ m-Pas o̱ u̱n Yahuda-ne̱ wosonte̱ yow yow. ");
INSERT INTO uth_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Ye̱so dassu̱ru̱ u̱r-hi, wu̱ hyanbu̱ru̱ hun-ne̱ u̱t-mo̱o̱r ne̱ ye̱ ro̱ wu̱ m-kawan. Wu̱ ze̱e̱ru̱ Pirip, “¿Ke ne̱ o̱ a he o̱o̱n u̱n rii-yo m-re̱ yo a he m-ya'as u̱n ka hun-ne̱ ye̱, ye̱ reet?” ");
INSERT INTO uth_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Wu̱ u̱n ze̱e̱ kááne̱ remen wu̱ megerté̱ Pirip. Wu̱ u̱n hi u̱n de u̱n wu̱, wu̱ nepste̱ rii-yo wu̱ he m-nom à. ");
INSERT INTO uth_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Pirip shasu̱ru̱ wu̱, “Ko̱ a o̱o̱n rii-yo m-re̱ yo u̱n gu̱wu̱s-de u̱n re̱ng-u̱s eer, yoa bo'os ko̱ wu̱ ke ne̱t-wu̱ kumut, wu̱ re̱ á.” ");
INSERT INTO uth_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Wu̱ ken wu̱ ro kon be-de u̱n yan-neke̱-m Ye̱so, jin-de u̱n wu̱ Andarawus (heno Simo̱n Bitrus ne̱). Wu̱ ru̱ru̱ ye̱, ");
INSERT INTO uth_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Wu̱ ken wan-campo̱ wu̱ ro kon kàne̱ u̱n bos-to̱ u̱t-buro̱di ne̱ u̱t-taan u̱n jan ne̱ yoor. ¿Amba yan ye̱ a bo'os hun-ne̱ o-hakt bo̱ ye̱ ro̱ u̱t-mo̱o̱r ne̱?” ");
INSERT INTO uth_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Ye̱so ze̱e̱ru̱ yan-neke̱-mo̱ u̱n wu̱, ye̱ ru̱re̱ hun-ne̱ ko̱ wu̱ ke ne̱t-wu̱, wu̱ she'et. Ká be-de ne̱ de ro̱ u̱n gwo̱-u̱t yar-to̱ ne̱ de̱e̱n. Hun-ne̱ she'etu̱ru̱. Campo̱-ne̱ wooste̱ be-de u̱n dugu-u̱s taan 5,000. ");
INSERT INTO uth_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Bo̱ ye̱ she'ette̱ à, Ye̱so de̱ku̱ru̱ ka bos-to̱ u̱t-buro̱di to̱. Wu̱ no̱mu̱ru̱ u̱r-bo̱ngo̱n be-de Shir. Bo̱ wu̱ nomte̱ u̱r-bo̱ngo̱n à, wu̱ wongu̱ru̱ ka hun-ne̱ ye̱ kap. Wu̱ wongu̱ru̱ ye̱ ka jan-ye̱ komo. Ye̱ re̱e̱ru̱, ko̱wan wu̱ ciig. ");
INSERT INTO uth_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Bo̱ ye̱ cikste̱ à, Ye̱so ze̱e̱ru̱ yan-neke̱-mo̱ u̱n wu̱, ye̱ karagse̱ ka to̱ kwange̱ ye̱ à, taase to̱ naase̱. ");
INSERT INTO uth_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Ye̱ karagsu̱ru̱ to̱ ko̱o̱r-u̱t o̱p u̱t-yoor 12 be-de u̱n ka bos-to̱ u̱t-buro̱di u̱t-taan to̱ ye̱ re̱, to̱ kwange̱ à. ");
INSERT INTO uth_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Bo̱ hun-ne̱ hyente̱ ka rem-se u̱t-hyat se se Ye̱so no̱me̱ à, ye̱ ze̱e̱ru̱, “Nip-o̱, wu̱ ka wu̱ ro̱ ka wan-rwo̱r u̱n Ma-to̱ Shir wu̱, wu̱ he m-haan ho̱no o-dak à!” ");
INSERT INTO uth_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Ye̱so ne̱, bo̱ wu̱ nepste̱ ye̱ ro̱ u̱t-zo̱nge̱ ye̱ de̱ke̱ntu̱ wu̱ u̱r-be̱e̱b, ye̱ sagbu̱té̱ wu̱ u̱t-gwo̱mo à, wu̱ inu̱ru̱ káne̱. Wu̱ argu̱ru̱ ja'as m-da o-haag u̱n hi u̱n de u̱n wu̱. ");
INSERT INTO uth_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Bo̱ rim-m wo̱o̱nte̱ à, yan-neke̱-m Ye̱so argu̱ru̱ m-neke̱, ye̱ ro̱ m-he̱'e̱be̱ o-mar. ");
INSERT INTO uth_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Bo̱ comb-o nomoste̱ à, Ye̱so mu̱u̱n á. Ye̱ co̱wu̱ru̱ o-hat. Ye̱ co̱no̱g m-pas de o-Kapanahum. Ye̱so ne̱ wu̱ co̱w o-hat u̱n ye̱ ne̱ á. ");
INSERT INTO uth_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Mar-o taknu̱ru̱ o-zu̱ngo̱ remen mo̱ ken caari-mo̱ m-yo mo̱ ro m-dussunde̱ à. ");
INSERT INTO uth_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Ye̱ nak hat-o̱ m-ho̱ be-de u̱n hew-de u̱n me̱r-u̱t tet ko̱ u̱t-nass kiromita 5 ko̱ 6. Ye̱ hyanu̱ru̱ Ye̱so wu̱ ro̱ u̱r-hew n-te̱ m-ho̱. Wu̱ ro̱ m-nekne̱ yow yow o-hat ne̱. Hur-u̱r huksu̱ru̱ yan-neke̱-mo̱ u̱n wu̱. ");
INSERT INTO uth_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Ka da-de ne̱, Ye̱so ze̱e̱ru̱ ye̱, “No̱ ho̱ge̱ o-gye̱r á, me̱ wu̱.” ");
INSERT INTO uth_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Bo̱ Ye̱so zette̱ ye̱ yage̱ o-gye̱r, wu̱ wu̱ à, ka da-de ne̱ ye̱ e̱su̱ru̱, ye̱ de̱ku̱ru̱ wu̱ o-hat. Bo̱ wu̱ cu̱wte̱ o-hat à, ye̱ gu̱t, ye̱ 'wo̱s ye̱ wooste̱ n-riib n-dak o̱ ye̱ ro̱ m-ha à. ");
INSERT INTO uth_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Bo̱ ish geste̱ à, ka mo̱o̱r-to̱ u̱n hun-ne̱ ye̱ ye̱ Ye̱so re̱e̱gte̱ à, ye̱ rewe̱ káne̱ à, ye̱ ma'assu̱ru̱ u̱n hoob-o Ye̱so. Ye̱ hyan wu̱ ne̱ á. Ye̱ nepste̱ hat-o gaan-o̱ ro'e̱ káne̱. Yan-neke̱-m Ye̱so ne̱, ye̱ co̱we̱ u̱n ka hat-o̱ u̱n ho̱n-de u̱n ye̱. Ye̱so co̱w be-de u̱n ka hat-o̱ á. ");
INSERT INTO uth_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Bo̱ ye̱ rotte̱ u̱n hoob-o Ye̱so à, to̱ ken hat-to̱ wo̱o̱nu̱ru̱ to̱ rwu̱u̱ne̱ o-Tiberiyos à. To̱ wo̱o̱nu̱ru̱ yow yow u̱n be-de Ye̱so nome̱ Wan-Ko̱yan u̱r-bo̱ngo̱n u̱n re̱e̱gte̱ hun-ne̱ dugu-u̱s taan 5,000 à. ");
INSERT INTO uth_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Bo̱ ka mo̱o̱r-to̱ u̱n hun-ne̱ to̱ hyente̱ Ye̱so á, ye̱ hyanu̱ ne̱ yan-neke̱-m Ye̱so á, ye̱ co̱wu̱ru̱ ka hat-to̱ ye̱ argu̱ m-neke̱ o-Kapanahum. Ye̱ ro u̱n hoob-o Ye̱so. ");
INSERT INTO uth_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Da-o̱ ye̱ pasne̱ pesto-de o-mar à, ye̱ wo̱o̱nu̱ru̱, ye̱ 'wo̱ssu̱ru̱ Ye̱so re̱e̱no̱. Ye̱ ze̱e̱ru̱ wu̱, “Wa-u̱s-Nap, ¿da u̱n ke o̱ o wo̱o̱ne̱ kàne̱?” ");
INSERT INTO uth_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Ye̱so shasu̱ru̱ ye̱, “Me̱ no̱ m-ru̱re̱ o-nip, u̱m nak rii-yo hante̱ no̱ rotte̱ me̱ m-hoob à, remen no̱ re̱e̱g u̱t-buro̱di, no̱ ciig. Yanze remen no̱ nak yo rem-se u̱t-hyat se m-no̱me̱ à ro̱ no̱ m-kute̱ wu̱ u̱m ro̱ á. ");
INSERT INTO uth_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Yagu̱ no̱ hoob-o̱ u̱n rii-yo m-re̱ yo o-wu̱r u̱n ho̱n-de u̱n yo. Yo ro̱ m-tees à. Se̱ de̱ no̱ hoob rii-yo m-re̱ yo ba m-ta, yo he 'ya u̱n hun-ne̱ ho̱o̱g à, yo Wà-wu̱ u̱n ne̱t he no̱ m-'ya à. Remen kááne̱ o̱ Shir o-Tato to̱mo̱nte̱ me̱.” ");
INSERT INTO uth_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Ka da-o̱ ye̱ citu̱ru̱ Ye̱so, “¿Re o̱ u̱n ya te̱ he m-no̱m, te̱ nomot se̱nge̱-mo̱ Shir co̱ne̱ à?” ");
INSERT INTO uth_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Ye̱so shasu̱ru̱ ye̱, “Se̱nge̱-mo̱ Shir mo̱ ka: no̱ she̱r be-de u̱n wu̱ Shir to̱mne̱ à.” ");
INSERT INTO uth_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Ka da-de ye̱ citu̱ru̱ wu̱, “¿Yan go̱n rem-se u̱t-hyat se o he te̱ m-nome̱, te̱ hyenet se, te̱ she̱re̱t be u̱n du? ¿Ya o he m-no̱m? ");
INSERT INTO uth_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","N-ga n-ga, da-o̱ tat te̱ ne̱ ro u̱r-hew o-ko̱t à, ye̱ re̱e̱ru̱ buro̱di-to̱ rwu̱u̱ne̱ n-To̱n u̱n shir à, to̱ ye̱ aage̱ o-Mana à. A ge̱ne̱g ka ma-to̱ be-de u̱n Ma-to̱ Shir, a zee, ‘Wu̱ ya'aste̱ u̱t-buro̱di to̱ rwu̱u̱ne̱ n-To̱n u̱n shir à, ye̱ re.’ ” ");
INSERT INTO uth_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Ye̱so ze̱e̱ru̱ ye̱, “Me̱ no̱ m-ru̱re̱ o-nip, buro̱di-to̱ Mosa ya'e̱ tat no̱ ne̱ à, ba Mosa wu̱ ya'e̱ tat-ne̱ no̱ ne̱ ka buro̱di-to̱ á. To̱ u̱n rwu̱u̱n n-To̱n be-u̱r Tato re, wu̱ ro̱ u̱n 'ya u̱n hun-ne̱ buro̱di-to̱ o-nip to̱ rwu̱u̱ne̱ n-To̱n o-shir à. ");
INSERT INTO uth_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Remen buro̱di-de Shir, de ro̱ wu̱ rwu̱u̱ne̱ n-To̱n shir wu̱ ye'et ho̱no o-dak ho̱o̱g à.” ");
INSERT INTO uth_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Ye̱ ze̱e̱ru̱ wu̱, “Go̱s-wu̱, se̱nge̱ te̱ m-'ya u̱n ka buro̱di-to̱ ko̱ da u̱n ke, te̱ re.” ");
INSERT INTO uth_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Ye̱so ze̱e̱ru̱ ye̱, “Me̱ ro̱ buro̱di-to̱ u̱n ho̱o̱g. Ko̱wan wu̱ haane̱ be u̱n de, wu̱a arag u̱n me̱r á. Wu̱ she̱re̱ u̱n me̱ à, wu̱a do ho̱ge̱ o-swo̱o̱t á. ");
INSERT INTO uth_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","No̱ hyeneste̱ me̱ de̱, u̱m ru̱ru̱te̱ no̱ ne̱, amba kap u̱n kááne̱ ne̱, no̱ she̱r u̱n me̱ á. ");
INSERT INTO uth_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Kap ye̱ Tato-o ya'e̱ me̱ à ye̱a haan be u̱n de. Komo bo̱ u̱n wu̱ haane̱ be u̱n de à, man yen wu̱ á. ");
INSERT INTO uth_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Me̱ u̱n kergene̱ n-To̱n u̱n shir, ba remen u̱m do̱ru̱te̱ barag-se u̱n hi u̱n de á, se̱ de̱ barag-se u̱n wu̱ to̱mne̱ me̱ à. ");
INSERT INTO uth_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Barag-se u̱n wu̱ to̱mne̱ me̱ ne̱ à, se ka, taase ko̱ wan-gaan be-de u̱n ka hun-ne̱ ye̱ wu̱ ya'asu̱ me̱ à e̱ge̱ á. Se̱ de̱ u̱m 'yons ye̱ ho̱-de u̱r-ko̱m u̱n ho̱o̱g ne̱. ");
INSERT INTO uth_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Remen barag-u̱s Tato re se ro̱, kap bo̱ u̱n ne̱t-wu̱ gwo̱te̱ Wà komo wu̱ she̱r u̱n wu̱ à, wu̱a kum ho̱o̱g-o̱ ba m-ta. Komo man 'yons wu̱ ho̱-de u̱r-ko̱m u̱n ho̱o̱g ne̱.” ");
INSERT INTO uth_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Se̱k-ye̱ ye̱ u̱n Yahuda-ne̱ no̱mu̱ru̱ wu̱ u̱s-hwu̱mu̱g remen wu̱ ze̱e̱g, “Me̱ ro̱ buro̱di-to̱ u̱n ho̱o̱g to̱ kergene̱ n-To̱n shir à.” ");
INSERT INTO uth_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Ye̱ ze̱e̱ru̱, “Ye̱so wu̱ ka, ¿wà Yusuhu á? ¿Ko̱ wu̱ wu̱ á? ¿A nepse̱ ne̱ tato u̱n wu̱ u̱n inu u̱n wu̱ ne̱ á? ¿Re o̱ hante̱ wu̱ ro̱tte̱ m-ze̱e̱ m-mo̱ka, ‘Me̱ u̱n kergene̱ n-To̱n u̱n shir’?” ");
INSERT INTO uth_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Ye̱so ze̱e̱ru̱ ye̱, “Yagu̱ no̱ u̱s-hwu̱mu̱g u̱n hi u̱n no̱ u̱n rii-yo u̱m ze̱e̱ á. ");
INSERT INTO uth_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Remen yatt-wu̱ he hoks m-haan be u̱n de á, se̱ de̱ Tato-o̱ to̱mne̱ me̱ à wu̱ nakne̱ wu̱ be u̱n de. Me̱ ne̱ komo, man 'yons wu̱ ho̱-de u̱r-ko̱m. ");
INSERT INTO uth_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","N-me̱ Ma-to̱ Shir, wan-Rwo̱r u̱n Ma-to̱ Shir ze̱e̱g, ‘Kap mo̱ u̱n ye̱ Shir he ye̱ m-yoose̱.’ Bo̱n ne̱t-wu̱ ho̱ge̱ Shir o-Tato u̱n yoos-de u̱n wu̱ ne̱ à, wu̱a haan be u̱n de. ");
INSERT INTO uth_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Yanze ne̱t ro̱ ko̱n wu̱ hyane̱ Shir o-Tato á, se̱ wu̱ wu̱ rwu̱u̱ne̱ be-de Shir o-Tato à. Wu̱ wu̱ cot, hyane̱ o-Tato. ");
INSERT INTO uth_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Me̱ no̱ m-ru̱re̱ o-nip, ko̱ wu̱ ke ne̱t-wu̱, wu̱ she̱re̱ hur-de u̱n wu̱ be u̱n de à, wu̱ ro̱ u̱n ho̱o̱g ne̱ o̱ u̱n ba m-ta. ");
INSERT INTO uth_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Me̱ wu̱ ro̱ buro̱di-to̱ u̱n ho̱o̱g. ");
INSERT INTO uth_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Tato no̱ ne̱ re̱e̱g buro̱di-to̱ o-Mana o-ko̱t, amba ye̱ marag. ");
INSERT INTO uth_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Buro̱di-to̱ ka to̱ rwu̱u̱ne̱ n-To̱n u̱n shir à, remen kap mo̱ u̱n hun-ne̱ ye̱ reet to̱ u̱n taase ye̱ mer. ");
INSERT INTO uth_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Me̱ wu̱ ro̱ ka buro̱di-to̱ u̱n ho̱o̱g-to̱ to̱ rwu̱u̱ne̱ n-To̱n u̱n shir à. Bo̱n ne̱t-wu̱ re̱ ka buro̱di-to̱ à, wu̱a nom ho̱o̱g-mo̱ ba m-ta. Ka buro̱di-to̱ komo wu̱r-o re o̱, o̱ u̱m he m-ya'as à, remen ho̱no o-dak o̱ nomot ho̱o̱g.” ");
INSERT INTO uth_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Ma-u̱t su̱nu̱ru̱ n-ho̱n n-ho̱n be-de u̱n Yahuda-ne̱ u̱n hi u̱n de u̱n ye̱. Ye̱ zee, “¿Re o̱ ka ne̱t-wu̱ hette̱ na hoks m-ya'as u̱n ap-mo̱ u̱n wu̱r-o̱ u̱n wu̱ a ti?” ");
INSERT INTO uth_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Ye̱so ze̱e̱ru̱, “Me̱ no̱ m-ru̱re̱ o-nip, u̱n ba no̱ ti'ig ap-m re, no̱ su̱ hyó-mo̱ u̱n wu̱r-o re á, me̱ Wà-wu̱ u̱n ne̱t, no̱a kum ho̱o̱g á. ");
INSERT INTO uth_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Kap bo̱ u̱n wu̱ ti'e̱ ap-mo̱ u̱n wu̱r-o re à, wu̱ su̱ hyó-mo̱ u̱n wu̱r-o re, wu̱ ro̱ u̱n ho̱o̱g ne̱ o̱ u̱n ba m-ta. Me̱ komo, man 'yons wu̱ u̱n ho̱-de u̱r-ko̱m u̱n ho̱o̱g ne̱. ");
INSERT INTO uth_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Me̱ u̱n ze̱e̱ kaane̱, remen ap-m re u̱n hyó-m re ne̱, mo̱ ro̱ m-'ya u̱n ku̱kt-o no̱ rii-yo m-re̱ u̱n ho̱o̱g-o̱ ba m-ta ne̱. Nip-o o̱ ka. ");
INSERT INTO uth_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Kap bo̱ u̱n ne̱t-wu̱ ti'e̱ ap-mo̱ u̱n wu̱r-o re wu̱ su̱ hyó-m re komo ne̱ à, man nom mo̱sse̱ u̱n wu̱ ne̱, wu̱ komo mo̱sse̱ u̱n me̱ ne̱. ");
INSERT INTO uth_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Wo̱ hyange̱ bo̱ Shir o-Tato wan-ho̱o̱g to̱mne̱ me̱ à, u̱m ro̱tte̱ u̱n ho̱o̱g ne̱ remen wu̱ à. Ka bo̱-o̱ komo, wu̱ ti'e̱ ap-mo̱ u̱n wu̱r-o re à, wu̱a kum ho̱o̱g rem re. ");
INSERT INTO uth_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Buro̱di-to̱ rwu̱u̱ne̱ n-To̱n à to̱ ka. Yanze go̱n buro̱di-to̱ tat no̱ ne̱ re̱ á. Remen bo̱ ye̱ reete̱ to̱ à, ye̱ maru̱ru̱. Amba wu̱ re̱ ga-u̱t re à, wu̱a nom ho̱o̱g-o̱ u̱n ba m-ta.” ");
INSERT INTO uth_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","To̱ ka ma-to̱ ne̱ kap, wu̱ u̱n rwo̱r to̱ n-me̱ u̱n kuke̱-o̱ u̱n yoos u̱n Ma-to̱ Shir, n-me̱ u̱n bo̱-o̱ o-Kapanahum. ");
INSERT INTO uth_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Bo̱ m-ho̱ge̱ kááne̱, de̱e̱n be-de u̱n yan-neke̱-mo̱ u̱n wu̱ ze̱e̱ru̱, “Ka yoos-de ro̱ u̱n rem ne̱. ¿Wa he de hoks m-go̱ks?” ");
INSERT INTO uth_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Ye̱so nepste̱ yan-neke̱-mo̱ u̱n wu̱ ro̱ u̱s-hwu̱mu̱g remen yoos-de u̱n wu̱. Wu̱ ze̱e̱ru̱ ye̱, “Ka ma-to̱, ¿to̱ u̱n naas no̱ o̱ u̱t-me̱n? ");
INSERT INTO uth_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","¿Ka da-de ne̱, ya no̱ he u̱s-barag u̱rege̱ no̱ hyanag me̱ Wà-wu̱ u̱n ne̱t, m-warag n-To̱n u̱n shir komo? ");
INSERT INTO uth_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Ai, Ku̱kt-o̱ Shir o̱ ro̱ u̱n 'ya u̱n ho̱o̱g. Be̱e̱b-de ma-hun yo ken rii-yo yo á. Ma-to̱ u̱m ru̱ru̱ no̱ à to̱a hoks m-'ya u̱n ku̱kt-o no̱ ho̱o̱g-o̱ ba m-ta. ");
INSERT INTO uth_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Amba ye̱ ken ye̱ ro̱ ko̱n be u̱n no̱, ye̱ she̱re̱ hur-de u̱n ye̱ u̱n ma-u̱t re á.” (Amba cin n-ga ne̱, Ye̱so nepste̱ ka ye̱ she̱re̱ u̱n Ma-to̱ u̱n wu̱ á. Komo wu̱ neps ka wu̱ he wu̱ m-ya'as u̱n kom-to̱ u̱n ya-u̱t-yage̱ à.) ");
INSERT INTO uth_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Wu̱ dooru̱ m-ze̱e̱, “O̱ u̱m zette̱ no̱, yatt-wu̱ he hoks m-haan be u̱n de à, se̱ de̱ wu̱ Shir o-Tato ya'e̱ co̱w-yo wu̱ haante̱ be u̱n de à.” ");
INSERT INTO uth_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Remen kááne̱, yan-neke̱-m Ye̱so u̱t-mo̱o̱r ne̱, ye̱ yagu̱ru̱ wu̱. Ye̱ do m-neke̱ u̱n Ye̱so ne̱ komo á. ");
INSERT INTO uth_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Ye̱so ze̱e̱ru̱ ka ne̱n o̱p yoor-ye̱ 12, “¿No̱ ma no̱ u̱n co̱n no̱ yagu̱ me̱ m-do̱re̱?” ");
INSERT INTO uth_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simo̱n Bitrus shasu̱ru̱ wu̱, “Go̱s-wu̱, ¿be-u̱r wan o̱ te̱ he m-warag? Ma-u̱t ru to̱ ro̱ u̱n 'ya u̱n ho̱o̱g-o̱ ba m-ta! ");
INSERT INTO uth_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Te̱ she̱re̱g hur u̱n te̱ be u̱n du. Wo̱ wu̱ cot wu̱ Shir, wu̱ ba m-ku̱ko̱p.” ");
INSERT INTO uth_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Ye̱so ze̱e̱ru̱ ye̱, “¿Me̱ daage̱ no̱ ka ne̱n o̱p u̱n yoor 12 á? To̱, wan-gaan be u̱n no̱ ko-Gwo̱mo-wu̱ u̱n ya-u̱t-ko̱t wu̱!” ");
INSERT INTO uth_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","U̱n Yahudas (wà Simo̱n Iskariyoti), Ye̱so ro u̱t-ma remen wu̱ nepste̱ wu̱ wu̱ he wu̱ m-ya'as ko̱ de̱ wu̱ rotte̱ be-de u̱n ka ne̱n o̱p u̱n yoor-ye̱ à 12. ");
INSERT INTO uth_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Bo̱ Ye̱so komte̱ u̱t-ma o-Kapanahum à, wu̱ ma'asu̱ru̱ u̱r-hew u̱n dak-o̱ o-Gariri. Wu̱ do m-pa so̱ u̱n dak-o̱ o-Judiya á remen Yahuda-ne̱ ye̱ ro u̱n hoob-o̱ ye̱ hoot wu̱. ");
INSERT INTO uth_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Biki-o̱ u̱n Yahuda-ne̱ Biki-o̱ u̱t-De̱pi o̱ ye̱ ro̱ m-no̱m à, o̱ wosonte̱ yow yow. ");
INSERT INTO uth_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Hen-ne̱ ye̱ u̱n wu̱ ne̱ ze̱e̱ru̱ wu̱, “Ine̱ me, o neke̱ dak-o̱ o-Judiya be-de u̱n Biki-o̱ u̱t-De̱pi remen ka rem-se u̱t-hyat se se wo̱ m-no̱m à, ka ye̱ ro̱ wo̱ m-do̱re̱ ka co̱-se à, ye̱ hyenet se! ");
INSERT INTO uth_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Ai, yatt-wu̱ ro̱ u̱n no̱m u̱n rem-se u̱r-bon wukusse̱ á, u̱rege̱ u̱nze o co̱no̱g jin u̱n du ru be-de u̱n hun-ne̱ kap. To̱, depete̱, bo̱ wo̱ m-no̱m u̱n ka rem-se u̱t-hyat se à, o rwu̱nte̱ hi u̱n du be-de u̱n hun-ne̱.” ");
INSERT INTO uth_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Hen-ne̱ ye̱ u̱n wu̱, ye̱ u̱n ze̱e̱ kááne̱ remen u̱n ka da-o̱, ye̱ ro she̱re̱g hur-de u̱n ye̱ be-de wu̱ á. ");
INSERT INTO uth_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Ye̱so shasu̱ru̱ ye̱, “Da-o re, o̱ u̱n goshi no̱m to̱ ko̱n á. No̱ ne̱, ko̱ o̱ ke da-o̱ hond hond o̱ be-u̱r no̱. ");
INSERT INTO uth_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Co̱w-o ro̱ ko̱n ho̱no o-dak u̱ yagu̱te̱ no̱ á. Me̱ wu̱ de̱ ho̱no o-dak ro̱ u̱t-yage̱ remen me̱ m-rwo̱r u̱n rem-se o̱ ro̱ m-no̱m à, se u̱n ba u̱r-bon. ");
INSERT INTO uth_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","No̱ de̱, neke̱ no̱ be-de u̱n biki-o no̱. Me̱ ne̱, man he m-mo̱ka á, remen da-o re, o̱ u̱n goshi nom á tokon.” ");
INSERT INTO uth_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Bo̱ wu̱ ru̱ru̱te̱ ye̱ kaane̱ à, ka da-de wu̱ she'essu̱ru̱ u̱n dak-o̱ o-Gariri tokon. ");
INSERT INTO uth_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Bo̱ hen u̱n wu̱ ne̱ neke̱sse̱ be-de u̱n ka Biki-o̱ u̱t-De̱pi o̱ à, ka da-o̱ wu̱ argu̱ru̱ ye̱ m-do̱re̱ u̱s-ajima ne̱. Amba, wukusse̱. ");
INSERT INTO uth_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Ye̱ ken se̱k-ye̱ u̱n Yahuda-ne̱ ye̱ ma'asu̱ru̱ u̱n se̱nge̱-mo̱ u̱n hoob-o̱ u̱n wu̱. Ye̱ ro̱ m-ze̱e̱, “¿Ke ne̱ o̱ wu̱ ro̱?” ");
INSERT INTO uth_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Ka da-o̱ mo̱o̱r-to̱ u̱n hun-ne̱ ma'asu̱ru̱ u̱s-har u̱n ma-to̱ u̱n wu̱. Ye̱ ken ye̱ ro̱ m-ze̱e̱, “Ka ne̱t-wu̱ kashi u̱n ne̱t-wu̱.” Ye̱ ken ye̱ zee, “Ai, ka ne̱t-wu̱, wu̱ ro̱ m-e̱gu̱sse̱ u̱n hun-ne̱.” ");
INSERT INTO uth_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Amba yatt ne̱t-wu̱ hokse̱ rwu̱nte̱ u̱n ma-to̱ u̱n wu̱ to̱ u̱r-bon cas á, remen gye̱r-o̱ u̱n se̱k-ye̱ ye̱ u̱n Yahuda-ne̱. ");
INSERT INTO uth_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","To̱, se̱ da-de a re̱wu̱sse̱ u̱t-ho̱ à, n-te̱te̱ o̱ o-biki, ka da-de Ye̱so co̱wu̱ru̱ u̱n Pyo-o̱ Shir. Wu̱ yoosu̱ru̱ hun-ne̱ Ma-to̱ Shir. ");
INSERT INTO uth_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Yahuda-ne̱ hyanu̱ru̱ hyat-to̱ u̱n ka yoos-de. Ye̱ ze̱e̱ru̱, “¿Ya hante̱ ka ne̱t-wu̱ nept u̱s-nap ka bo̱-se ne̱, ba a u̱n we̱t wu̱ m-yoose̱ ne̱?” ");
INSERT INTO uth_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Ka da-de Ye̱so ze̱e̱ru̱ ye̱, “Ka yoos-de de no̱ ho̱ge̱ me̱ m-yoose̱ u̱n hun-ne̱ à, de ma re de á. Amba de u̱n wu̱ to̱mne̱ me̱ à de de. ");
INSERT INTO uth_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Kap wu̱ daage̱ wu̱ nomot rii-yo Shir co̱ne̱ à, wu̱a nep u̱rege̱ be-de Shir yoos u̱n de rwu̱u̱ne̱. U̱rege̱ ne̱ de u̱n hi u̱n de de, komo wu̱a nep. ");
INSERT INTO uth_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Ai, ne̱t-wu̱ ro̱ u̱n no̱m u̱t-ma remen hi u̱n de u̱n wu̱ à, ai, go̱s-to̱ u̱n hi u̱n de u̱n wu̱ to̱ wu̱ ro̱ o-hoob. Amba kap ne̱t-wu̱ ro̱ u̱n rwu̱nte̱ u̱n jin-de u̱n wu̱ to̱mne̱ wu̱ à, go̱s-to̱ u̱n wu̱ to̱mne̱ wu̱ à, to̱ wu̱ ro̱ o-hoob komo. Ko-wan-to̱m-wu̱ o-nip wu̱ ka, komo kashi u̱n ne̱t-wu̱. ");
INSERT INTO uth_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","¿Mosa wu̱ ka ya'asu̱ no̱ o-karamsa á? Amba myet u̱n kááne̱ ne̱ yatt-wu̱ ro̱ u̱n no̱m u̱n do̱ro̱tte̱-o̱ u̱n ka karamsa-o̱ be-u̱r no̱ á. ¿Ya hante̱ no̱tte̱ me̱ o-hoob no̱ hoot?” ");
INSERT INTO uth_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Ka da-o̱ ka mo̱o̱r-to̱ u̱n hun-ne̱ to̱ shasu̱ru̱ wu̱. Ye̱ ze̱e̱ru̱, “Zu̱ngo̱-o bo̱k wo̱! ¿Wan wu̱ o ho̱ge̱ wu̱ ro̱ wo̱ u̱n hoob-o m-ho̱ ne̱?” ");
INSERT INTO uth_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Ye̱so ze̱e̱ru̱ ye̱, “U̱m no̱mo̱g saw-to̱ u̱t-hyat o-gaan, no̱ kap, no̱ hyanag u̱t-hyat. ");
INSERT INTO uth_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","To̱, Mosa rwo̱'o̱g no̱ de̱ no̱ koot yan-campo̱ no̱ ne̱. Wu̱ zee, ‘A meete̱ wan-campo̱, ho̱-u̱r aeere̱-de a ko wu̱.’ (Mosa wu̱ ne̱, takne̱ no̱ kute̱ u̱n ka co̱w-yo á, amba Ibrahi, Ishaku, u̱n Yakubu ne̱.) ");
INSERT INTO uth_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","To̱, u̱rege̱ ho̱-de m-ko̱ u̱n yakar no̱ regete̱ u̱n Ho̱-de u̱r-Wu̱we̱ de, no̱ m-ko̱ u̱n yakar no̱ remen u̱ntaase no̱ jet karamsa-o Mosa o̱ u̱r-ko̱ de u̱n yan-campo̱-ne̱ ho̱-u̱r aeere̱-de. ¿Remen yan no̱tte̱ u̱s-ryaab u̱n me̱ ne̱ remen u̱m dossu̱te̱ ne̱t go̱m Ho̱-de u̱r-Wu̱we̱? ");
INSERT INTO uth_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","No̱ piish u̱t-ma bo̱ u̱n hyan-o̱ u̱n yish á, amba piish no̱ u̱t-ma u̱n rii-yo ro̱ hond hond à.” ");
INSERT INTO uth_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Ye̱ ken hun-ne̱ ye̱ ya-o-Urusharima, ye̱ ze̱e̱ru̱, “¿Ka ne̱t-wu̱ wu̱ ka, gwo̱mo-ne̱ ro̱ o-hoob ye̱ hoot á? ");
INSERT INTO uth_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Wu̱ ka ne̱ kàne̱ cas be-de u̱n hun-ne̱, wu̱ ro̱ u̱n te̱p ba ye̱ u̱n ze̱e̱ wu̱ rii! ¿Ko̱ se̱k-ye̱ be-de u̱n Yahuda-ne̱ u̱n de̱k wu̱ ro̱ Kiristi? ");
INSERT INTO uth_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Wu̱ ka de̱ jip te̱ nepste̱ be-de wu̱ rwu̱u̱ne̱ à, amba da-o̱ Kiristi he m-haan à, yatt-wu̱ he m-nap be-de wu̱ he m-rwu̱u̱n á.” ");
INSERT INTO uth_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","To̱, Ye̱so 'yonsu̱ru̱ u̱s-co̱r de̱e̱n be-de wu̱ ro u̱n yoose̱ u̱n hun-ne̱ u̱n Pyo-o̱ Shir à, wu̱ ze̱e̱ru̱, “No̱ m-hyan sa o zee no̱ nepste̱ me̱, no̱ neps komo be-de u̱m rwu̱u̱ne̱ à. Amba, me̱ haanu̱ ne̱ remen hi u̱n de á. Se̱ de̱ u̱m haante̱ rem wu̱ to̱mne̱ me̱ à, wu̱ ne̱ ko-ya-o-nip-wu̱. Amba, no̱ nap wu̱ á. ");
INSERT INTO uth_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Me̱ ne̱, u̱m nepste̱ wu̱ remen be-de u̱n wu̱ o̱ u̱m rwu̱u̱ne̱. Wu̱ wu̱ to̱mne̱ me̱.” ");
INSERT INTO uth_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Bo̱ Ye̱so ru̱rte̱ ka ma-to̱ à, ye̱ ho̱o̱bu̱ru̱, ye̱ bu̱pt wu̱. Amba, yatt-wu̱ hokse̱ wu̱ m-ci á, remen da-o̱ u̱n wu̱ o̱ u̱n go̱ shi á. ");
INSERT INTO uth_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Ye̱ ken ye̱ ne̱ de̱e̱n be-de u̱n mo̱o̱r-to̱ u̱n hun-ne̱ ye̱ she̱re̱ste̱ u̱n wu̱. Ye̱ ze̱e̱ru̱, “Da-de Kiristi haane̱, wu̱a nom rem-se u̱t-hyat se arge̱ se ka ne̱t-wu̱ nom á!” ");
INSERT INTO uth_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Bo̱ Parisa-ne̱ ho̱gu̱te̱ mo̱o̱r-to̱ u̱n hun-ne̱ ro̱ u̱s-har remen ka hyat-to̱ to̱ Ye̱so no̱me̱ à. Gwo̱mo-ne̱ ye̱ u̱n ko̱n-se Shir u̱n Parisa-ne̱ ye̱ to̱mu̱ru̱ yan-'er-de u̱n Pyo-o̱ Shir ye̱ ship u̱n wu̱. ");
INSERT INTO uth_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Ye̱so ze̱e̱ru̱ ye̱, “Ya o-da yo kusu me̱ hiin u̱n no̱ ne̱, rii-yo u̱m waragte̱ be-de u̱n wu̱ to̱mne̱ me̱ à. ");
INSERT INTO uth_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","No̱a hoob me̱, no̱ taage̱ u̱n hyan-o re. Remen be-de u̱m he m-ha à, no̱a hoks m-ha káne̱ á.” ");
INSERT INTO uth_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Yahuda-ne̱ ze̱e̱ru̱ hi u̱n de u̱n ye̱, “¿Ke co̱-o̱ ne̱ wu̱ he'e̱, har atte̱ à hoks wu̱ m-hyan á? ¿Wu̱ ro̱ m-ha be-de u̱n Yahuda-ne̱ ye̱ ro̱ cakarse̱ u̱n bo̱-u̱t ho̱r-to̱, wu̱ yoosu̱te̱ ya-o-Girik ká co̱-se?” ");
INSERT INTO uth_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Ye̱ ze̱e̱ru̱, “¿Sa-de u̱n wu̱ ya ne̱ da-o̱ wu̱ ze̱e̱, a hoob wu̱ a taage̱ u̱n hyan-o̱ u̱n wu̱, komo a hoks m-ha be-de wu̱ he'e̱ á?” ");
INSERT INTO uth_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Ho̱-de u̱r-ko̱m de o-biki, ho̱-u̱r go̱s-de, Ye̱so rwu̱u̱nu̱ru̱, wu̱ e̱su̱ru̱, wu̱ 'yonsu̱ru̱ u̱s-co̱r. Wu̱ ze̱e̱ru̱, “Kap bo̱ u̱n wu̱ ro̱ u̱n ho̱ge̱ u̱n swo̱o̱t-o̱ m-ho̱ à, wu̱ haan be u̱n de wu̱ su̱. ");
INSERT INTO uth_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Kap wu̱ she̱re̱ u̱n me̱ à, bo̱ Ma-to̱ Shir rwo̱re̱ à, ‘Be-de u̱n wu̱ o̱ ho̱-mo̱ u̱n ho̱o̱g he m-rwu̱u̱n bo̱ ro̱o̱g-o ro̱ m-ja à.’ ” ");
INSERT INTO uth_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Ku̱kt-o̱ Shir o̱, wu̱ ro̱ u̱n ma-to̱ u̱n o̱, o̱ yan-she̱r u̱n hur-de u̱n ye̱ be-de u̱n wu̱ he m-go̱ks be-de u̱n wu̱ à. Amba u̱n ka da-o̱, a ro ya'aste̱ o̱ á, remen Shir o̱ u̱n goshi se̱ps Ye̱so á. ");
INSERT INTO uth_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Bo̱ u̱n ho̱ge̱ u̱n ka ma-to̱ ye̱ ken ye̱ be-de u̱n mo̱o̱r-to̱ u̱n ye̱ ze̱e̱ru̱, “Nip-o̱, wu̱ ka wan-rwo̱r u̱n Ma-to̱ Shir wu̱!” ");
INSERT INTO uth_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Ye̱ ken ye̱ ze̱e̱ru̱, “Kiristi wu̱.” Ye̱ ken ye̱ ze̱e̱ru̱, “¿Re ne̱ Kiristi he m-no̱m wu̱ rwu̱u̱nte̱ dak-o̱ o-Gariri? ");
INSERT INTO uth_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","¿Ma-to̱ Shir u̱n zee ka u̱nze Kiristi, u̱n baag-o Dawuda wu̱ he m-rwu̱u̱n à? ¿Cir-mo̱ u̱n bo̱-o̱ o-Be̱tarami a he wu̱ m-mat u̱n bo̱-o̱ ko-Gwo̱mo Dawuda rotte̱ u̱r-she'et à?” ");
INSERT INTO uth_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Hun-ne̱ wongu̱ru̱ be-u̱t yoor rem Ye̱so. ");
INSERT INTO uth_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Ye̱ ken ye̱ co̱nu̱ru̱ wu̱ m-ship amba, yatt ne̱t-wu̱ ci'e̱ wu̱ á. ");
INSERT INTO uth_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","A káne̱ yan-'er-de u̱n Pyo-o̱ Shir mu̱u̱nu̱ru̱ be-de u̱n Gwo̱mo-ne̱ ye̱ u̱n ko̱n-se Shir u̱n Parisa-ne̱ ne̱. Gwo̱mo-ne̱ ye̱ u̱n ko̱n-se Shir u̱n Parisa-ne̱ ze̱e̱ru̱ ka yan-'er ye̱, “¿Remen yan o̱, no̱ bo̱po̱nte̱ wu̱ á?” ");
INSERT INTO uth_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Yan-'er-de u̱n Pyo-o̱ Shir shasu̱ru̱. Ye̱ zee, “Ai, yatt-wu̱ take̱ u̱n rwo̱r u̱t-ma u̱ntu̱n ka ne̱t-wu̱ á.” ");
INSERT INTO uth_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Parisa-ne̱ shasu̱ru̱, “Ap, ¿har u̱n no̱ ne̱, wu̱ e̱gu̱sse̱? ");
INSERT INTO uth_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","¿No̱ tak u̱n nap u̱n wan-gaan be-de u̱n Mo̱ro̱g-de Se̱k-ye̱ ko̱ ko-Parisa-wu̱ she̱re̱ u̱n wu̱? ");
INSERT INTO uth_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Amba to̱ ka mo̱o̱r-to̱ u̱n hun-ne̱ to̱, ye̱ nap karamsa-o̱ u̱n ma-u̱t Mosa á. Remen kááne̱ ai ryaab-se Shir ro̱ ye̱ u̱n dor!” ");
INSERT INTO uth_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Neko̱dimu, wu̱ ha'e̱ be-u̱r Ye̱so n-ga à, wu̱ ro̱ wan-gaan be-de u̱n Mo̱ro̱g-de Se̱k-ye̱, wu̱ ze̱e̱ru̱ ye̱, ");
INSERT INTO uth_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Ai, karamsa-o na o̱ ro̱ m-bo̱p u̱n ne̱t cin ba a u̱n ho̱ge̱ nu-o̱ u̱n wu̱, a nep yo wu̱ ro̱ m-no̱m á.” ");
INSERT INTO uth_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Ye̱ shasu̱ru̱ Neko̱dimu, “¿Wo̱ ma, ko-ya-o-Gariri-wu̱? Ceker Ma-to̱ Shir u̱r-bon ne̱. Ay, wan-rwo̱r u̱n Ma-to̱ Shir ro̱ ko̱n wu̱ he m-rwu̱u̱n u̱n dak-o̱ o-Gariri á.” ");
INSERT INTO uth_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Ko̱ wu̱ ke ji'u̱ru̱ u̱n hur-o̱ u̱n wu̱. ");
INSERT INTO uth_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Ye̱so daaru̱ u̱n Haag-o̱ u̱n 'yo-se o-Ze̱tun. ");
INSERT INTO uth_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","N-sot n-sot wu̱ dooru̱ m-co̱w u̱n Pyo-o̱ Shir. Kap mo̱o̱r-to̱ u̱n hun-ne̱ haanu̱ru̱ be-de u̱n wu̱. Wu̱ she'etu̱ru̱, wu̱ ciru̱ ye̱ m-yoose̱. ");
INSERT INTO uth_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Ye̱ ken yan-Yoos-de u̱n karamsa-o Mosa u̱n Parisa-ne̱ ne̱ ye̱ hantu̱ru̱ wu̱, wu̱ ken ne'a-wu̱, wu̱ a bo̱pe̱ m-bu̱kku̱n u̱n wu̱ ken campo̱-wu̱ ne̱ à. Ye̱ e̱ssu̱ru̱ ka ne'a-wu̱ n-te̱te̱. ");
INSERT INTO uth_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Ye̱ ze̱e̱ru̱ Ye̱so, “Wa-u̱r-Yoos, ka ne'a-wu̱, te̱ u̱n bo̱po̱n wu̱ m-bu̱kku̱n u̱n wu̱ ken campo̱-wu̱ ne̱. ");
INSERT INTO uth_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","To̱, be-de u̱n karamsa-o Mosa a ze̱e̱g te̱, te̱ ho go̱n ka ne̱t-wu̱ u̱s-jor u̱s-jor. Wo̱ ne̱ u̱n ce ru, ¿ya o ze̱e̱?” ");
INSERT INTO uth_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Ye̱ u̱n rwo̱r kaane̱, remen ye̱ cept wu̱ remen ye̱ kumut o-co̱w yo ye̱ hette̱ wu̱ m-bo̱p à. Amba Ye̱so kaktu̱ru̱, wu̱ ge̱nu̱ru̱ m-ge̱n u̱n jow-yo u̱n wu̱ n-dak. ");
INSERT INTO uth_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Bo̱ ye̱ se̱ngu̱te̱ cot-se u̱n wu̱ à, wu̱ indu̱nu̱ru̱ eso. Wu̱ ze̱e̱ru̱ ye̱, “Bo̱n ne̱t-wu̱ ro̱tte̱ u̱r-ba'as be u̱n no̱ á, wu̱ takan ka ne'a-wu̱ m-jir u̱r-ta'ar.” ");
INSERT INTO uth_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Ye̱so dooru̱ m-kakt n-dak. Wu̱ ge̱nu̱ru̱ m-ge̱n n-dak. ");
INSERT INTO uth_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Ye̱ ne̱, bo̱ ye̱ ho̱gu̱te̱ ma-u̱t Ye̱so à, ye̱ argu̱ru̱ m-arag n-gaan n-gaan. Shi'in-mo̱ u̱n se̱k-ye̱ ha-mo̱ u̱n yakar, har ye̱ yagu̱ru̱ Ye̱so u̱n ka ne'a-wu̱ ne̱ eso. ");
INSERT INTO uth_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Ye̱so indu̱nu̱ru̱ eso. Wu̱ citu̱ru̱ ka ne'a-wu̱, “Ne'a, ¿ke co̱ ye̱ ro̱? ¿Yatt-wu̱ piishe̱ wo̱ ma-to̱ m-mar á?” ");
INSERT INTO uth_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Wu̱ shasu̱ru̱, “Go̱s-wu̱, ko̱ wan-gaan.” Ye̱so ze̱e̱ru̱ wu̱, “Me̱ u̱n ce re, man piishe̱ wo̱ ma-to̱ m-mar á. Neke̱ neke̱-m ru. Amba taase o do no̱m u̱r-ba'as á.” ");
INSERT INTO uth_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Ye̱so dooru̱ ye̱ m-ze̱e̱, “Me̱ wu̱ ro̱ cecas-mo̱ u̱n ho̱no o-dak. Bo̱n ne̱t-wu̱ ro̱ me̱ m-do̱re̱ à, wu̱a do m-hewe̱ u̱r-hew n-me̱ o-comb á, amba wu̱a kum cecas-mo̱ u̱n ho̱o̱g.” ");
INSERT INTO uth_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Bo̱ Ye̱so ru̱ru̱tu̱ ye̱ kááne̱ à, Parisa-ne̱ ze̱e̱ru̱ wu̱, “Hi u̱n du de̱ wo̱ m-su̱'e̱. Swo̱-u̱s ru ne̱ se o-nip se á.” ");
INSERT INTO uth_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Ye̱so shasu̱ru̱ ye̱, “Ai, ko̱ u̱m su̱'e̱ hi u̱n de, swo̱-u̱s re se o-nip se̱ u̱m nepste̱ be-de u̱m rwu̱u̱ne̱ à u̱n be-de u̱m he'e̱ ne̱ à. Amba no̱, no̱ nap be-de u̱m rwu̱u̱ne̱ á, ko̱ be-de u̱m he'e̱ á. ");
INSERT INTO uth_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Piish u̱n ma-u̱t no̱, to̱ ma-hun to̱. Me̱ ne̱, me̱ u̱n piishe̱ ko̱ wan-gaan u̱t-ma á. ");
INSERT INTO uth_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Amba ko̱ man piishe̱ ne̱t u̱t-ma, piish u̱n ma-u̱t re to̱ u̱r-bon to̱. Yanze me̱ wu̱ ro̱ m-no̱m u̱n ho̱n-de á. Te̱ ye̱, te̱ Tato re wu̱ to̱mne̱ me̱ à. ");
INSERT INTO uth_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Be-de u̱n karamsa-o no̱ gense̱ to̱ ro̱ u̱nze swo̱-se u̱n ne̱n yoor nip-o̱. ");
INSERT INTO uth_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Me̱ wu̱ ro̱ u̱n su̱'e̱ u̱n hi u̱n de. Tato re komo ne̱ wu̱ to̱mne̱ me̱ à, wu̱ ro̱ me̱ m-su̱'e̱.” ");
INSERT INTO uth_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Ye̱ ze̱e̱ru̱, “¿Ke ne̱ o̱ tato ru ro̱?” Ye̱so shasu̱ru̱, “Ko̱ me̱ ko̱ Tato re, yatt-wu̱ no̱ nape̱ á. No̱ ro nepse̱ me̱, no̱ roa nep Tato re komo.” ");
INSERT INTO uth_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Ye̱so u̱n rwo̱r ka ma-to̱ da-o̱ wu̱ ro u̱r-yoos u̱n Pyo-o̱ Shir yow yow u̱n be-de hun-ne̱ rotte̱ m-'ya m-yar remen Pyo-o̱ Shir à. Kap u̱n kááne̱ ne̱, yatt-wu̱ hokse̱ wu̱ m-bo̱p á, remen da-o̱ u̱n wu̱ o̱ u̱n goshi wo̱ á. ");
INSERT INTO uth_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Ye̱so dooru̱ ye̱ m-ze̱e̱, “Me̱n neke̱ u̱r-hew, amba no̱a hoob me̱ no̱ taage̱ u̱n hyan-o re. Amba no̱a mer u̱n ba'as-u̱t no̱ ne̱. Be-de u̱m he'e̱ ne̱ à, no̱a hoks m-ha á.” ");
INSERT INTO uth_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Remen ka ma-to̱ wu̱ rwo̱re̱ kááne̱ à, se̱k-ye̱ be-de u̱n Yahuda-ne̱ ze̱e̱ru̱, “¿Wu̱a ho̱ o̱ hi u̱n de u̱n wu̱? ¿O̱ wu̱ zette̱ ‘Be-de u̱m he'e̱ à, yatt-wu̱ de hoks m-ha á’?” ");
INSERT INTO uth_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Wu̱ ze̱e̱ru̱ ye̱, “No̱, u̱n dak-o̱ no̱ ro̱'e̱. Me̱ ne̱, n-To̱n o̱ u̱m rwu̱u̱ne̱. No̱ yan-ho̱no-o-dak ye̱, me̱ ne̱ wan-ho̱no-o-dak wu̱ á. ");
INSERT INTO uth_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","O̱ hante̱ u̱m zet no̱a merme̱ u̱n ba'as-u̱t no̱ ne̱. U̱n ba de̱ no̱ she̱re̱g hur-u̱r no̱ u̱nze me̱ wu̱ ro̱, wu̱ u̱m ro̱ à, no̱a merme̱ u̱n ba'as-u̱t no̱ ne̱.” ");
INSERT INTO uth_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Ye̱ ze̱e̱ru̱ wu̱, “¿Wo̱ ro̱ wan?” Ye̱so ze̱e̱ru̱ ye̱, “Bo̱ u̱m ru̱ru̱ no̱ à, hond hond o̱ bo̱ u̱m ru̱ru̱ no̱ à. ");
INSERT INTO uth_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Rem-u̱s ro̱ ko̱n u̱t-mo̱o̱r ne̱, se u̱m he m-rwo̱r rem no̱ komo se depe̱ u̱m piishi no̱ u̱t-ma à. Amba man no̱m á. Remen wu̱ to̱mne̱ me̱ à, wa-o-nip-wu̱. Rii-yo u̱m ho̱gne̱ be-de u̱n wu̱ à, yo me̱ u̱n ru̱re̱ u̱n ho̱no o-dak.” ");
INSERT INTO uth_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Ye̱ nap u̱nze ma-u̱t Tato u̱n wu̱, to̱ wu̱ ro ye̱ m-ru̱re̱ á. ");
INSERT INTO uth_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Ye̱so ze̱e̱ru̱ ye̱, “Da-de no̱ jakse̱ Wà-wu̱ u̱n ne̱t, ka da-de ne̱, no̱a nep me̱ ro̱ wu̱ u̱m ze̱e̱ u̱m ro̱ à. Komo no̱a nep me̱n no̱m u̱n rii u̱n ho̱n-de à, amba me̱ m-rwo̱r u̱n yo Tato re yoosu̱ me̱ à. ");
INSERT INTO uth_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Tato re wu̱ to̱mne̱ me̱ ne̱ à, wu̱ ro̱ mo̱sse̱ u̱n me̱ ne̱. Wu̱ yage̱ me̱ u̱n ho̱n-de á, remen ko̱ de ke da-de me̱ u̱n no̱m u̱n rii-yo wu̱ co̱ne̱ à.” ");
INSERT INTO uth_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Da-de Ye̱so rwo̱re̱ ka ma-to̱ à, hun-ne̱ u̱t-mo̱o̱r ne̱ ye̱ she̱ru̱ru̱ hur-de u̱n ye̱ be-de u̱n wu̱. ");
INSERT INTO uth_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Ye̱so ze̱e̱ru̱ Yahuda-ne̱ ye̱ she̱re̱ be-de u̱n wu̱ à, “U̱rege̱ no̱ se̱ngu̱te̱ bo̱p u̱n ma-u̱t re, o-nip, no̱a she'et yan-neke̱-m re. ");
INSERT INTO uth_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","No̱a nep o-nip, komo u̱n ka nip-o̱ no̱ he m-posse̱.” ");
INSERT INTO uth_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Ye̱ shasu̱ru̱ wu̱, “Ai, baag-o Ibrahi o̱ te̱ ro̱. Te̱ tak no̱me̱ u̱n ne̱t m-gu̱w á. ¿Re o̱ u̱n ya o zette̱ te̱, ‘No̱a po̱sse̱ m-gu̱w’?” ");
INSERT INTO uth_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Ye̱so shasu̱ru̱ ye̱, “Me̱ no̱ m-ru̱re̱ o-nip, bo̱ u̱n ne̱t-wu̱ ro̱ u̱n no̱m u̱r-ba'as à, ko-gu̱w-wu̱ u̱r-ba'as wu̱. ");
INSERT INTO uth_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Ko-gu̱w ba wan-gaan wu̱ ro̱ be-de u̱n ya-o-hur á, amba wà-wu̱ hur, ko-ya-o-hur-wu̱ ko̱yanda. ");
INSERT INTO uth_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Wà-wu̱ Shir, u̱ ruutu̱ no̱, no̱ po̱ssu̱te̱ o̱ ka. ");
INSERT INTO uth_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","U̱m nepste̱ no̱ de̱ baag-o Ibrahi o̱, amba no̱ u̱n hoob-o̱ no̱ hoot me̱ remen ma-u̱t re, to̱ co̱w no̱ á. ");
INSERT INTO uth_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Me̱ ne̱ m-rwo̱r u̱n rii-yo u̱m hyande̱ be-u̱r Tato re à. No̱ ne̱ u̱n cin no̱, no̱ u̱n nom u̱n rii-yo no̱ ho̱ge̱ be-u̱r tato no̱ à.” ");
INSERT INTO uth_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Ye̱ shasu̱ru̱ wu̱, “Ai, Ibrahi wu̱ ro̱ tato te̱.” Ye̱so shasu̱ru̱ ye̱, “No̱ rotte̱ yakar Ibrahi, no̱ roa nom rem-se Ibrahi no̱me̱ à. ");
INSERT INTO uth_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","U̱n hek-o̱ u̱n kááne̱, no̱ wargu̱ru̱ hoob-o̱ no̱ hoot me̱ remen u̱m ru̱ru̱tu̱ no̱ o-nip, o̱ u̱m ho̱gne̱ be-de Shir à. Ba kaane̱ Ibrahi no̱me̱ rem-se u̱n wu̱ á. ");
INSERT INTO uth_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","No̱, no̱ u̱n no̱m u̱n se̱nge̱-mo̱ tato no̱ ro̱ m-no̱m à.” Ye̱ shasu̱ru̱ wu̱, “Te̱ mat-ye̱ u̱t-ran ye̱ á. Tato-o te̱ gaan-o̱, Shir.” ");
INSERT INTO uth_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Ye̱so ze̱e̱ru̱ ye̱, “U̱ rotte̱ Shir tato no̱ wu̱, no̱ roa was u̱n me̱ ne̱ remen be-de o-Tato o̱ u̱m rwu̱u̱ne̱. Me̱ ka ne̱, me̱n haan remen hi u̱n de á. Wu̱ wu̱ to̱mne̱ me̱. ");
INSERT INTO uth_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","¿Remen yan o̱ no̱ nepte̱ yo me̱ m-rwo̱r á? No̱ nap á, remen no̱ co̱n no̱ dek ma-u̱t re á. ");
INSERT INTO uth_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","No̱, tato no̱ ko-Gwo̱mo-wu̱ u̱n ya-u̱t-ko̱t wu̱. Co̱n-m no̱ ne̱ komo no̱ nom rii-yo tato no̱ co̱ne̱ à. Wu̱, cin u̱r-takan wan-ho̱ de u̱n ne̱t-wu̱. Wu̱ ro̱ m-e̱s u̱n o-nip á, remen ho̱-mo̱ u̱n wu̱ ro̱ ko̱n be-de u̱n o̱ shir á. Bo̱-to̱ wu̱ ro̱tte̱ m-'wo̱ns, remen wu̱ wa-u̱t-bo̱-wu̱, tato-o̱ u̱n ya-u̱t-bo̱. ");
INSERT INTO uth_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Remen me̱ no̱ m-ru̱re̱ o-nip, o̱ hante̱, no̱ go̱kste̱ á. ");
INSERT INTO uth_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","U̱n be u̱n no̱ ¿wan wu̱ ne̱ he me̱ m-ru̱re̱ ba'as u̱n de? Bo̱ no̱ nepse̱ nip-o̱ me̱ no̱ m-ru̱re̱ à, ¿remen yan o̱ ne̱, no̱ she̱rte̱ u̱n me̱ á? ");
INSERT INTO uth_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Wu̱ rwu̱u̱ne̱ be-de Shir à wu̱ ro̱ m-raks u̱n Ma-to̱ Shir. Rii-yo hante̱ no̱tte̱ u̱n raks u̱t-to̱ u̱n Ma-to̱ Shir ne̱ á, remen no̱ ye̱ Shir ye̱ á.” ");
INSERT INTO uth_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Ye̱ ken se̱k-ye̱ ye̱ be-de u̱n Yahuda-ne̱ ye̱ shasu̱ru̱ wu̱, “Ashi, nip-o̱ ka te̱ ze̱e̱ wo̱ ko-Samariya, komo ne̱ ya-u̱t-ko̱t daag wo̱ u̱r-hi.” ");
INSERT INTO uth_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Ye̱so shasu̱ru̱ ye̱, “Ya-u̱t-ko̱t ye̱ da me̱ u̱r-hi á. Tato re wu̱ me̱ m-se̱ps. No̱ ne̱, no̱ yagu̱ me̱ m-se̱ps. ");
INSERT INTO uth_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Me̱ wu̱ ro̱ u̱n se̱pse̱ u̱n hi u̱n de á. Wu̱ he me̱ m-se̱ps à wu̱ ro̱ ko̱n. Wu̱ ro̱ tomso ne̱ wan-piish u̱t-ma. ");
INSERT INTO uth_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Me̱ no̱ m-ru̱re̱ o-nip, ko̱wan wu̱ ro̱ m-no̱m o-do̱ro̱tte̱ u̱n ma-u̱t re ne̱, wu̱a mer á har da-o̱ ba m-ta.” ");
INSERT INTO uth_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Se̱k-ye̱ be-de u̱n Yahuda-ne̱ ze̱e̱ru̱, “O̱'o̱, te̱ nak m-mo̱ka u̱nze ya-u̱t-ko̱t daag wo̱ u̱r-hi. Ai, Ibrahi u̱n yan-Rwo̱r u̱n Ma-to̱ Shir ne̱ mereste̱. Wo̱ ne̱ komo, o zee bo̱ u̱n wu̱ no̱me̱ o-do̱ro̱tte̱ u̱n ma-u̱t ru ne̱ à, wu̱a mer á har da-o̱ ba m-ta. ");
INSERT INTO uth_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","¿Wo̱ u̱n jiish tato na Ibrahi o̱? Wu̱ u̱n yan-Rwo̱r u̱n ma-to̱ Shir ne̱, ye̱ marag, yagu̱nte̱ wo̱. ¿Wan wu̱ ne̱ o musse̱ hi u̱n du?” ");
INSERT INTO uth_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Ye̱so shasu̱ru̱ ye̱, “Me̱ co̱n se̱ps u̱n hi u̱n de á. Se̱ps-mo̱ u̱n hi u̱n de, a gu ko̱yan á. Tato re, wu̱ ro̱ wan-se̱ps-m re, wu̱ no̱ m-ze̱e̱ u̱nze Shir no̱ à. ");
INSERT INTO uth_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","No̱ nap wu̱ á. Me̱ ne̱, u̱m nepse̱ wu̱. Me̱ ro ze̱e̱ge̱ u̱nze me̱ nap wu̱ á, u̱m roa warag wa-u̱t-bo̱ u̱ntu̱n no̱. Amba u̱m nepste̱ wu̱. Me̱ ne̱ tomso u̱n no̱m o-do̱ro̱tte̱ u̱n ma-to̱ u̱n wu̱ ne̱. ");
INSERT INTO uth_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Ko-ya-n-ga no̱ Ibrahi wu̱ no̱mo̱g o-zak de̱e̱n da-o̱ Shir ru̱re̱ wu̱ rii-yo u̱m he m-no̱m à da-o̱ me̱ haane̱. No̱mo̱g sa o zee wu̱ hyanag yo ne̱ komo, wu̱ no̱mu̱ru̱ o-zak.” ");
INSERT INTO uth_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Se̱k-ye̱ be-de u̱n Yahuda-ne̱ shasu̱ru̱ wu̱, “Har m-mo̱ka, wo̱ u̱n goshi wo̱o̱ u̱s-hak kwo̱o̱z-u̱t yoor u̱s-o̱p 50 á, ¿wo̱a zee o hyanag Ibrahi?” ");
INSERT INTO uth_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Ye̱so ze̱e̱ru̱ ye̱, “Me̱ no̱ m-ru̱re̱ o-nip, cin ba a u̱n makt Ibrahi, ‘U̱m ro̱ ko̱n.’ ” ");
INSERT INTO uth_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Bo̱ Ye̱so zette̱ kááne̱ à, ye̱ ruuru̱, ye̱ mo̱tru̱nté̱ u̱t-ta'ar, ye̱ jirit wu̱. Ye̱so wuku̱ru̱, wu̱ argu̱ru̱ m-ru u̱n Pyo-o̱ Shir. ");
INSERT INTO uth_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Ye̱so ro m-arag, wu̱ hyanu̱ru̱ ne̱t-wu̱ a mate̱ ko-po̱ à. ");
INSERT INTO uth_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Yan-neke̱-mo̱ u̱n wu̱ citu̱ru̱ wu̱, “Wa-u̱s-Nap, ¿wan wu̱ ne̱ no̱me̱ u̱r-ba'as a met ka ne̱t-wu̱ ko-po̱? ¿Wu̱ wu̱ o̱? ¿Ko̱ yan-mat-o̱ u̱n wu̱?” ");
INSERT INTO uth_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Ye̱so shasu̱ru̱, “Remen ka ne̱t-wu̱, ko̱ tato u̱n wu̱ ye̱ no̱m u̱r-ba'as á, se̱ de̱ remen a kututé̱ hun-ne̱ nom-mo̱ Shir be-de u̱n wu̱. ");
INSERT INTO uth_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Se̱ u̱m no̱mo̱g yo Tato re to̱mne̱ me̱ m-no̱m à, cin u̱r-ho̱ ne̱. Te̱t-m ro̱o̱n, da-o̱ ne̱t a hoks no̱m u̱n rii á. ");
INSERT INTO uth_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Bo̱ u̱m ro̱ u̱n ho̱no o-dak à, me̱ wu̱ ro̱ cecas-mo̱ u̱n ho̱no o-dak.” ");
INSERT INTO uth_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Bo̱ wu̱ ru̱rte̱ kááne̱ à, wu̱ copsu̱ru̱ m-ta n-dak. Wu̱ wu̱rgu̱ru̱ m-hu, wu̱ suku̱ru̱ mo̱ ko-po̱ u̱n yish. ");
INSERT INTO uth_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Wu̱ ze̱e̱ru̱ wu̱, “Neke̱, o sapt u̱n kaw-o̱ o-Sirom.” (Ka jin-de, de ro̱ a u̱n “tomonte̱.”) Ko̱m-de ka, wu̱ neku̱ru̱, wu̱ saptu̱ru̱, wu̱ mu̱u̱nu̱ru̱, wu̱ ro̱ u̱n hyan-o̱ u̱n wu̱ cas cas. ");
INSERT INTO uth_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Yan-bo̱r-se u̱n wu̱, u̱n ye̱ nape̱ wu̱ ne̱ n-ga, wu̱ ze̱e̱ u̱s-ko̱n à, ye̱ ze̱e̱ru̱, “¿Ka ne̱t-wu̱ wu̱ ka ro'e̱ m-she'et u̱n co̱w, wu̱ ro u̱s-ko̱n á?” ");
INSERT INTO uth_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Ye̱ ken ye̱ ze̱e̱ru̱, “Wu̱ wu̱.” Ye̱ ken ye̱ zee, “Ay, se̱ de̱ wu̱ sha'ag wu̱.” Wu̱ ne̱, wu̱ se̱ngu̱ru̱ m-ze̱e̱, “Me̱ wu̱.” ");
INSERT INTO uth_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Ye̱ ze̱e̱ru̱, “¿Re o̱ no̱me̱ yish ru upsu̱te̱?” ");
INSERT INTO uth_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Wu̱ shasu̱ru̱, “Ka ne̱t-wu̱, wu̱ a m-ze̱e̱ Ye̱so à, wu̱ wu̱ wu̱rge̱ hu-mo̱ n-dak, wu̱ suku̱ru̱ me̱ u̱n yish. Wu̱ zee u̱m neke̱ re̱e̱no̱ kaw-o̱ o-Sirom u̱m sapt. U̱m neku̱ru̱, u̱m saptu̱ru̱, u̱m kumu̱ru̱ o-hyan.” ");
INSERT INTO uth_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Ye̱ ze̱e̱ru̱ wu̱, “¿Ke ne̱ o̱ wu̱ ro̱?” Wu̱ ze̱e̱ru̱ ye̱, “Me̱ nap á.” ");
INSERT INTO uth_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Ye̱ heetu̱ru̱ Parisa-ne̱ ne̱t-wu̱ a upse̱ yish à. ");
INSERT INTO uth_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","U̱n Ho̱-de u̱r-Wu̱we̱ de komo Ye̱so wu̱rge̱ m-hu, wu̱ upsu̱te̱ wu̱ yish. ");
INSERT INTO uth_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Parisa-ne̱ citu̱ru̱ wu̱ bo̱ a no̱me̱ wu̱ kumut o-hyan à. Wu̱ ze̱e̱ru̱ ye̱, “Hu-mo̱ n-dak mo̱ wu̱ wu̱rge̱ à, mo̱ mo̱ wu̱ suke̱ me̱ u̱n yish. U̱m saptu̱ru̱, u̱m hyanu̱ru̱ cas.” ");
INSERT INTO uth_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Remen kááne̱, ye̱ ken Parisa-ne̱ ye̱ ze̱e̱ru̱, “Ka ne̱t-wu̱, be-de Shir o̱ wu̱ ro̱ á, remen wu̱ ku ho̱-de Shir zette̱ a wu̱we̱ u̱n de á.” Ye̱ ken ye̱ ze̱e̱ru̱, “¿Re ne̱ o̱ ko-wa-u̱r-ba'as he nap u̱n no̱m u̱n rem-se u̱t-hyat kááne̱?” Ma-u̱t su̱nu̱tu̱ ye̱ o̱ ka. ");
INSERT INTO uth_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Ye̱ ja'asu̱ru̱ m-cit u̱n ko-po̱, “Wo̱ ne̱, ¿ya o hyane̱ mo̱sse̱ u̱n wu̱ ne̱ wo̱ wu̱ a upse̱ yish à?” Wu̱ ze̱e̱ru̱, “Wan-rwo̱r u̱n Ma-to̱ Shir wu̱.” ");
INSERT INTO uth_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Se̱k-ye̱ be-de u̱n Yahuda-ne̱, ye̱ she̱r hur-de u̱n ye̱ u̱nze ko-po̱-wu̱ ro'e̱ n-ga á, komo ne̱ wu̱ kumu̱ru̱ o-hyan m-mo̱ka á, har ye̱ agbu̱ru̱ tat-ne̱ ye̱ u̱n wu̱. ");
INSERT INTO uth_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Ye̱ citu̱ru̱ ye̱ mate̱ wu̱ à, “¿Wu̱ ka wà no̱ wu̱, wu̱ a zee u̱nze a u̱n mat wu̱ ko-po̱? ¿To̱, re o̱ ka u̱n ya wu̱ hyente̱ m-mo̱ka?” ");
INSERT INTO uth_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Tat-ne̱ ye̱ u̱n wu̱ shasu̱ru̱, “Te̱ nak wu̱ ka wà te̱ wu̱ komo ko-po̱-wu̱ a mate̱ wu̱. ");
INSERT INTO uth_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Amba bo̱ a no̱me̱ wu̱ kumut o-hyan à, te̱ nap á. Te̱ nap ma wu̱ upse̱ yish-ye̱ u̱n wu̱ á. Cit no̱ wu̱. Ai, wu̱ bo̱'o̱ssu̱te̱ m-rwo̱r u̱n hi u̱n de u̱n wu̱.” ");
INSERT INTO uth_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Tat-ne̱ u̱n wu̱ u̱n rwo̱r kaane̱ remen gye̱r-o̱ u̱n Se̱k-ye̱ be-de u̱n Yahuda-ne̱. Remen n-ga ne̱, Se̱k-ye̱ be-de u̱n Yahuda-ne̱ ye̱ gekse̱ u̱nze kap bo̱n ne̱t-wu̱ ze̱e̱, “Ye̱so ro̱ Kiristi wu̱ Shir to̱mne̱ à,” a ruut wu̱ u̱n kuke̱-o̱ u̱n yoos u̱n Ma-to̱ Shir, wu̱a do m-mu̱u̱n á. ");
INSERT INTO uth_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","O̱ hante̱ tato u̱n wu̱ ne̱ zet, “Wu̱ bo̱'o̱ssu̱te̱. Cit no̱ wu̱.” ");
INSERT INTO uth_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Se̱k-ye̱ u̱n Parisa-ne̱ ja'asu̱ru̱ agbe̱ u̱n ka ne̱t-wu̱ wu̱ ro u̱t-po̱ n-ga à. Ye̱ ze̱e̱ru̱ wu̱, “'Ya Shir m-se̱ps, o ru̱r o-nip. Te̱ de̱ te̱ nepste̱ ka ne̱t-wu̱ ko-ya-u̱r-ba'as-wu̱.” ");
INSERT INTO uth_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Wu̱ ze̱e̱ru̱ ye̱, “Ko̱ ko-ya-u̱r-ba'as-wu̱, me̱ de̱ me̱ nap á. Rii gaan-yo u̱m nape̱ à, n-ga me̱ ko-po̱-wu̱, m-mo̱ka komo me̱ m-hyan.” ");
INSERT INTO uth_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Ye̱ ze̱e̱ru̱ wu̱, “¿Ya wu̱ no̱mu̱ wo̱ ne̱? ¿Re o̱ wu̱ no̱me̱ wu̱ upsu̱tu̱ wo̱ yish?” ");
INSERT INTO uth_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Ko-po̱ shasu̱ru̱ ye̱, “U̱m ru̱ssu̱te̱ no̱. No̱ ho̱ge̱ á. ¿Remen yan o̱ no̱ cu̱nte̱ m-ho̱ge̱ tomso? ¿Ko̱ no̱ u̱n cen no̱, no̱ u̱n co̱n o̱ no̱ warag yan-neke̱-mo̱ u̱n wu̱?” ");
INSERT INTO uth_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Ye̱ he̱'e̱nu̱ru̱ wu̱ u̱t-re̱e̱b. Ye̱ ro̱ wu̱ m-ze̱e̱, “Wo̱ wu̱ de̱ ro̱ wan-dor-o̱ u̱n ka ne̱t-wu̱, te̱ yan-dor Mosa ye̱. ");
INSERT INTO uth_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Te̱ nepse̱ Shir no̱mo̱g u̱t-ma u̱n Mosa ne̱, amba wu̱ ka, te̱ nap be-de wu̱ rwu̱u̱ne̱ á.” ");
INSERT INTO uth_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Ka ne̱t-wu̱ shasu̱ru̱ ye̱, “Caane̱ hyat-to̱ ka! No̱ nap be-de wu̱ rwu̱u̱ne̱ á, amba ne̱ wu̱ upsu̱ssu̱te̱ me̱ yish! ");
INSERT INTO uth_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","A nepste̱, Shir ro̱ u̱n rege̱ u̱n ya-u̱t-ba'as u̱t-to̱ á. Amba kap wu̱ ho̱ge̱ gye̱r-o̱ Shir à, wu̱ ro̱ u̱n no̱m u̱n rii-yo Shir ze̱e̱ à, Shir ro̱ wu̱ m-ho̱ge̱. ");
INSERT INTO uth_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Cin da-o̱ Shir takne̱ no̱m u̱n ho̱no o-dak à, a tak m-ho̱ge̱ ne̱t-wu̱ upse̱ yish-ye̱ u̱n ne̱t-wu̱ a mate̱ ko-po̱ á. ");
INSERT INTO uth_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","A rotte̱ u̱nze ka ne̱t-wu̱, be-de Shir o̱ wu̱ rwu̱u̱ne̱ á, yatt-yo wu̱ roa hoks m-no̱m á.” ");
INSERT INTO uth_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Ye̱ shasu̱ru̱ wu̱, “Wo̱ wu̱ a mate̱ n-me̱ u̱n comb-o̱ u̱t-ba'as à, ¿yan yo ne̱ o he na m-ru̱re̱?” Ye̱ yanu̱ru̱ wu̱ be-de u̱n ye̱. ");
INSERT INTO uth_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Bo̱ Ye̱so ho̱gu̱te̱ u̱nze ye̱ yanag ka wu̱ a upse̱ yish à, wu̱ hyanu̱ru̱ wu̱. Wu̱ ze̱e̱ru̱, “¿O she̱re̱g hur u̱n du u̱n Wà-wu̱ u̱n ne̱t ko̱?” ");
INSERT INTO uth_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Wu̱ shasu̱ru̱ wu̱, “Go̱s-wu̱, ru̱ru̱ me̱ wu̱, wu̱ ro̱ à, u̱m she̱re̱t hur u̱n de be-de u̱n wu̱.” ");
INSERT INTO uth_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Ye̱so ze̱e̱ru̱ wu̱, “Ai, o hyanag wu̱. Wu̱ wu̱ ro̱ u̱t-ma u̱n wo̱ ne̱.” ");
INSERT INTO uth_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Wu̱ ze̱e̱ru̱, “Wan-Ko̱yan, u̱m she̱re̱g hur u̱n de be-de u̱n du.” Wu̱ kwu̱ktu̱ru̱ u̱n co-o̱ u̱n wu̱. ");
INSERT INTO uth_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Ye̱so ze̱e̱ru̱, “Me̱ u̱n co̱wo̱n u̱n ho̱no o-dak, remen u̱m piishté̱ hun-ne̱ ye̱ u̱n ho̱no o-dak u̱t-ma. U̱m haante̱ remen ye̱ ro̱ m-hyan á, ye̱ hyenet, komo ye̱ ro̱ m-hyanu̱ ne̱ à, ye̱ waragté̱ po̱-ne̱.” ");
INSERT INTO uth_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Ye̱ ken Parisa-ne̱ ye̱ ro mo̱sse̱ u̱n wu̱ ne̱. Bo̱ ye̱ ho̱gu̱te̱ kááne̱ à, ye̱ ze̱e̱ru̱, “¿Wata po̱-ne̱ ye̱ te̱ ro̱'e̱?” ");
INSERT INTO uth_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Ye̱so ze̱e̱ru̱ ye̱, “Ai, u̱ rotte̱ u̱nze po̱-ne̱ ye̱ no̱ ro̱, ba'as-u̱t no̱ roa ma'as be-u̱r no̱ á. Amba bo̱ no̱ ze̱e̱ no̱ m-hyan à to̱, ba'as-u̱t no̱ ro̱ kane̱ timb.” ");
INSERT INTO uth_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","“Me̱ no̱ m-ru̱re̱ o-nip, ne̱t-wu̱ cu̱we̱ so̱ u̱n ish-o̱ u̱n kuke̱-o̱ u̱n ca á, wu̱ daanu̱ru̱ raag-o̱ u̱r-hek, ka ne̱t-wu̱ ko-hyow-wu̱, ko-wa-u̱r-kwu̱p. ");
INSERT INTO uth_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Ne̱t-wu̱ co̱wne̱ ne̱ so̱ u̱n ish à, wan-gu̱t-de u̱n ca wu̱. ");
INSERT INTO uth_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Wan-'er-de u̱n ish wu̱ ro̱ wu̱ m-tikse̱. Ye̱ge̱-ca komo ne̱ ye̱ ro̱ u̱n raag u̱t-to̱ u̱n co̱r-o̱ u̱n wu̱. Wu̱ ro̱ u̱n aag u̱n jin-to̱ u̱n ca-ye̱ u̱n wu̱, wu̱ ruut ye̱ n-do̱. ");
INSERT INTO uth_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Wu̱ ruuse̱ kap ye̱ ma u̱n wu̱ n-do̱, wu̱ gaaru̱ co-o̱ u̱n ye̱. Komo ca ro̱ u̱n do̱nd u̱n jim-de u̱n wu̱ remen ye̱ nepste̱ co̱r-o̱ u̱n wu̱. ");
INSERT INTO uth_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Ye̱a do̱re̱ wu̱ ro̱ ko-hamat á. Se̱ songon-mo̱ u̱n wu̱ ye̱ hette̱, remen, ye̱ nap co̱r-o̱ u̱n wu̱ á.” ");
INSERT INTO uth_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Ye̱so nomu̱te̱ ye̱ sha-mo̱ u̱t-ma, amba ye̱ nap ka ma-to̱ á. ");
INSERT INTO uth_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Remen kááne̱ Ye̱so ze̱e̱ru̱ ye̱, “Me̱ no̱ m-ru̱re̱ o-nip me̱ wu̱ ro̱ ish-o̱ u̱n kur-o̱ u̱n ca. ");
INSERT INTO uth_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Kap wu̱ ba'e̱ me̱ m-wo̱o̱n be-de u̱n ca à, ko-hyow-wu̱, wan-kwu̱p-de u̱n hun-ne̱. Amba, ca ro̱ m-was u̱n wu̱ ne̱ á. ");
INSERT INTO uth_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Me̱ wu̱ ro̱ ish. Ko̱wan ne̱t-wu̱ co̱wne̱ be u̱n de, man gu wu̱. Wu̱a she'et sasa, wu̱ kum u̱t-re̱. ");
INSERT INTO uth_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Ko-hyow ro̱ m-haan temb rem u̱r-hyow, u̱r-ho̱ ne̱ m-naas ne̱. Me̱ u̱n haan, remen hun-ne̱ kumut ho̱o̱g-m shiishe̱. ");
INSERT INTO uth_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Me̱ wu̱ ro̱ wa-u̱r-gu̱t-wu̱ o-nip. Wa-u̱r-gu̱t-wu̱ o-nip komo wu̱ ro̱ u̱n ya'as u̱n ho̱o̱g-o̱ u̱n wu̱ remen ca-ye̱ u̱n wu̱. ");
INSERT INTO uth_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Wa-u̱r-gu̱wu̱s wan-gu̱t-de u̱r-bon wu̱ á. Ca tomso, ye̱ ma u̱n wu̱ ye̱ á. Da-o̱ wu̱ hyene̱ o-dur, wu̱ ho'osu̱ru̱ ca. Wu̱ argu̱ru̱ m-so̱m, wu̱ guut ho̱o̱g-o̱ u̱n wu̱. Dur-o shipu̱ru̱ ye̱ ken be-de u̱n ye̱. Ye̱ kuse̱ à, ye̱ cakku̱ru̱ u̱n ho̱n u̱n ho̱n. ");
INSERT INTO uth_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Wu̱ wa-u̱r-gu̱wu̱s, wu̱ ro̱ m-was u̱n ca ne̱ á. ");
INSERT INTO uth_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","“Me̱ wu̱ ro̱ wa-u̱r-gu̱t-wu̱ u̱r-bon. U̱m nak ye̱ ma re. Ye̱ ma re komo ne̱, ye̱ nepse̱ me̱. ");
INSERT INTO uth_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Bo̱ Tato-o nape̱ me̱ à, ka bo̱-se ne̱ o̱ u̱m nape̱ wu̱. Me̱n ya'as u̱n ho̱o̱g re remen ca re. ");
INSERT INTO uth_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Me̱ u̱n ye̱ ken ca-ye̱ ne̱ ye̱ ro̱ u̱n o̱ ka kur-o̱ á. Se̱ u̱m hantu̱te̱ ye̱. Ye̱a ho̱ge̱ co̱r re. Ka da-de, ye̱a she'et kur-o gaan, wa-u̱r-gu̱t wan-gaan. ");
INSERT INTO uth_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Remen kááne̱ o̱, Tato re waste̱ u̱n me̱ ne̱ remen mar-mo̱ u̱m he'e̱, remen u̱m ineté̱ komo à. ");
INSERT INTO uth_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Yatt-wu̱ he rumus u̱n ho̱o̱g re á, amba u̱n co̱n-m re o̱ u̱m hette̱ mo̱ m-ya'as. Me̱ o-co̱w ne̱, u̱m ya'aste̱ mo̱. Me̱ o-co̱w ne̱ komo yo u̱m hette̱ mo̱ m-de̱ke̱n à. Tato re ze̱e̱ u̱m nom kááne̱.” ");
INSERT INTO uth_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Komo ma-u̱t su̱nu̱ru̱ be-de u̱n se̱k-ye̱ u̱n Yahuda-ne̱ remen ma-u̱t Ye̱so. ");
INSERT INTO uth_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Hun-ne̱ u̱t-mo̱o̱r ne̱ be-de u̱n ye̱ ze̱e̱ru̱, “Ai, wu̱ ro̱ u̱n ya-u̱t-ko̱t ne̱. Ko-wa-o-zu̱ngo̱ wu̱. ¿Remen yan o̱ no̱tte̱ wu̱ m-ke'e̱ u̱t-to̱?” ");
INSERT INTO uth_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Ye̱ ken ye̱ ze̱e̱ru̱, “Ka ma-to̱ hwaa, ma-to̱ u̱n ya-u̱t-ko̱t to̱ á. ¿Ya-u̱t-ko̱t ro̱ u̱r-be̱e̱b ne̱, ye̱ upste̱ yish-ye̱ u̱n ko-po̱?” ");
INSERT INTO uth_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Da-o̱ o-hu̱w o̱, Yahuda-ne̱ ro̱ u̱n Biki-o̱ m-Baks u̱n da-o̱ a dotte̱ tiks u̱n Pyo-o̱ Shir o-Urusharima à. ");
INSERT INTO uth_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Ye̱so ro m-arag u̱n sak-o Suremanu u̱n Pyo-o̱ Shir. ");
INSERT INTO uth_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Se̱k-ye̱ be-de u̱n Yahuda-ne̱ rigu̱msu̱ru̱ wu̱. Ye̱ ze̱e̱ru̱ wu̱, “¿Har de ke ho̱-de o̱ te̱ he yage̱ o ryegen? U̱rege̱ wo̱ wu̱ Kiristi, o ru̱ru̱ te̱ o-nip cas.” ");
INSERT INTO uth_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Ye̱so shasu̱ru̱ ye̱, “U̱m ru̱ssu̱tu̱ no̱, amba no̱ she̱r á. Rem-se u̱t-hyat se me̱ m-no̱m à, me̱ m-no̱m u̱n be̱e̱b-u̱r Tato re. Se ro̱ me̱ m-su̱'e̱. ");
INSERT INTO uth_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Amba no̱, no̱ de̱k ma-u̱t re á, remen no̱ n-me̱ u̱n ca re á. ");
INSERT INTO uth_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Ca re ye̱ ro̱ u̱n raks u̱n co̱r re. U̱m nepste̱ ye̱. Ye̱ ro̱ me̱ tomso ne̱ m-do̱re̱. ");
INSERT INTO uth_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Me̱ ye̱ m-'ya u̱n ho̱o̱g-o̱ ba m-ta. Ye̱a sabre̱ á, har da-o̱ ba m-ta. Wan-rumus-mo̱ u̱n ye̱ ro̱ ko̱n u̱n kom-u̱t re á. ");
INSERT INTO uth_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Tato re wu̱ ya'ase̱ me̱ ka ca-ye̱ à, wu̱ jiishte̱ ko̱wan kap u̱t-go̱s. Yatt-wu̱ he hoks m-rumus u̱n ye̱ u̱n kom-u̱t Tato re á. ");
INSERT INTO uth_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","U̱n me̱ u̱n Tato re, gaan te̱ ro̱.” ");
INSERT INTO uth_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Se̱k-ye̱ be-de u̱n Yahuda-ne̱ dooru̱ mo̱t u̱t-ta'ar, ye̱ jirit wu̱. ");
INSERT INTO uth_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Ye̱so ze̱e̱ru̱, “U̱m kutute̱ no̱ rem-se u̱r-bon de̱e̱n se u̱n Tato re. ¿Be-de u̱n se ke rem-se, se ne̱ no̱ hette̱ me̱ m-jir?” ");
INSERT INTO uth_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Ye̱ ze̱e̱ru̱, “Yanze remen rem-u̱s ru se u̱r-bon se te̱ hette̱ wo̱ m-jir á, se̱ de̱ remen o yo'ogte̱ Shir. Wo̱ ka ne̱ ne̱t-wu̱, amba wo̱ m-mus u̱n hi u̱n du Shir.” ");
INSERT INTO uth_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Ye̱so ze̱e̱ru̱ ye̱, “Gense̱ to̱ ro̱ n-me̱ u̱n karamsa-o no̱. A zee Shir no̱mo̱g u̱t-ma u̱n ye̱ ken se̱k-ye̱ ye̱ u̱n hun-ne̱ ye̱ ne̱, wu̱ aagu̱ru̱ ye̱ ‘ye̱ge̱-shir.’ ");
INSERT INTO uth_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","To̱, a nepste̱ Ma-to̱ Shir to̱ ro̱ o-nip ba m-ta. Komo Shir ak ka hun-ne̱ ye̱ ‘ye̱ge̱-shir,’ ka hun-ne̱ ye̱ wu̱ ya'ase̱ Ma-to̱ u̱n wu̱ à. ");
INSERT INTO uth_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Me̱ wu̱ Shir daage̱ à, wu̱ to̱mo̱n u̱n ho̱no o-dak à, ¿Ya no̱ hette̱ m-ze̱e̱ u̱m yo'ogte̱ Shir remen u̱m ak hi u̱n de ‘Wà-wu̱ Shir’? ");
INSERT INTO uth_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","U̱rege̱ me̱ m-no̱m bo̱ Tato re ro̱ m-no̱m á, to̱, no̱ jar no̱ she̱r hur-u̱t no̱ u̱n me̱ á. ");
INSERT INTO uth_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Amba u̱rege̱ ne̱ no̱ hyanag me̱ m-no̱m bo̱ Tato re ro̱ m-no̱m à, ¿remen yan o̱ no̱ she̱rte̱ hur-u̱t no̱ u̱n me̱ ne̱ á? Ko̱ go̱n se̱nge̱-mo̱ me̱ m-no̱m à, mo̱ bo̱'o̱ssu̱te̱ no̱ nept m-so̱k ne̱, u̱nze Tato re ro̱ be u̱n de, me̱ komo ne̱ be-de o-Tato.” ");
INSERT INTO uth_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Ye̱ ja'asu̱ru̱ m-se̱nge̱, ye̱ shipt wu̱. Wu̱ possu̱ru̱ u̱n kom-to̱ u̱n ye̱. Ye̱ hoks wu̱ m-bo̱p á. ");
INSERT INTO uth_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Ka da-de ne̱, wu̱ dooru̱ m-warag u̱n pesto-de u̱n Ro̱o̱g-o̱ o-Joda be-de Yohana takne̱ yo'os u̱n hun-ne̱ n-me̱ m-ho̱ à. Wu̱ she'etu̱ru̱ kane̱. ");
INSERT INTO uth_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Hun-ne̱ haanu̱ru̱ be-de u̱n wu̱ u̱t-mo̱o̱r ne̱. Ye̱ de̱ku̱ru̱ m-ze̱e̱, “Nip-o̱, Yohana, wu̱ no̱m se ken rem-se u̱t-hyat se har wu̱ kututu̱ na Shir ye̱ to̱mne̱ wu̱ á, amba ma-to̱ wu̱ ro m-rwo̱r mo̱sse̱ u̱n ka ne̱t-wu̱ ne̱ à, nip-o̱.” ");
INSERT INTO uth_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Káne̱ o̱ hun-ne̱ u̱t-mo̱o̱r ne̱ she̱re̱ hur-de u̱n ye̱ be-de u̱n wu̱. ");
INSERT INTO uth_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Wu̱ ken ne̱t-wu̱ jin-de u̱n wu̱ Razarus ru̱kt go̱m. Wu̱ she'ette̱ u̱n bo̱-o̱ o-Betanya, mo̱sse̱ u̱n Meri ne̱ u̱n hen u̱n wu̱ Marta. ");
INSERT INTO uth_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Ka Meri-wu̱, wu̱ wu̱ hokme̱ Go̱s-wu̱ m-no̱w mo̱ m-shi'igin u̱s-na. Wu̱ sokmu̱ru̱ mo̱ u̱n hi-se u̱n hi-de u̱n wu̱. To̱, de ken ho̱-de Razarus ru̱tu̱ru̱ go̱m. ");
INSERT INTO uth_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Ka ne'a-ne̱ ye̱, se̱k-ye̱ ne̱ u̱n wu̱ ne̱ to̱mu̱ru̱ be-u̱r Ye̱so, ye̱ ze̱e̱ru̱, “Go̱s-wu̱, ka ne̱t-wu̱, wu̱ o ro̱ m-was u̱n wu̱ ne̱ à, wu̱ ho̱ge̱ m-re̱re̱m á.” ");
INSERT INTO uth_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Bo̱ Ye̱so ho̱gu̱te̱ kááne̱ à, wu̱ ze̱e̱ru̱, “Ka go̱m-o̱, go̱m-o̱ m-mar o̱ á, remen a se̱ke̱msu̱té̱ Shir o̱, a se̱ke̱mse̱ tomso ne̱ Wà-wu̱ Shir.” ");
INSERT INTO uth_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Ye̱so ro u̱n was u̱n Marta ne̱ u̱n Meri ne̱, Razarus wu̱. ");
INSERT INTO uth_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","To̱, bo̱ wu̱ ho̱gu̱te̱ Razarus u̱ ho̱ge̱ m-re̱re̱m á, wu̱ rewu̱ru̱ ho̱-u̱t yoor. ");
INSERT INTO uth_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Ka da-de, wu̱ ze̱e̱ru̱ yan-neke̱-mo̱ u̱n wu̱, “A warag no̱ dak-o̱ o-Judiya.” ");
INSERT INTO uth_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Yan-neke̱-mo̱ u̱n wu̱ ye̱ ze̱e̱ru̱, “Wa-u̱s-Nap, u̱n ka ho̱-to̱ se̱k-ye̱ ro̱ u̱n hoob-o̱ ye̱ jirit wo̱, ¿o dooru̱ m-warag re̱e̱no̱ komo?” ");
INSERT INTO uth_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Ye̱so shasu̱ru̱, “¿Rwu̱u̱n-mo̱ u̱r-ho̱ u̱n 'he̱be̱-mo̱ u̱n de ne̱ taase u̱r-ho̱ o̱ ka ka? Bo̱n wu̱ ro̱ u̱r-hew m-ho̱w à wu̱ ro̱ m-ma'as u̱t-pu̱kse̱ á, remen wu̱ ro̱ m-hyan cas. ");
INSERT INTO uth_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Amba bo̱n wu̱ ro̱ u̱r-hew m-te̱t à wu̱a ma'as u̱t-pu̱kse̱ remen cecas-m ro̱ ko̱n á.” ");
INSERT INTO uth_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Bo̱ wu̱ ru̱rte̱ kááne̱ à, wu̱ dooru̱ m-ze̱e̱, “Wan-yen na Razarus ro̱ m-rew, amba me̱ m-ha m-'yons wu̱.” ");
INSERT INTO uth_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Yan-neke̱-mo̱ u̱n wu̱ ze̱e̱ru̱ wu̱, “Go̱s-wu̱ te̱, u̱rege̱ de̱ u̱nze rew-mo̱ kwo̱su̱ wu̱, ai, mo̱a pyesse̱.” ");
INSERT INTO uth_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Ye̱ napu̱ ne̱ u̱nze, ma-to̱ u̱n mar-m Razarus Ye̱so ro̱tte̱ á. Ye̱ de̱ku̱ru̱ u̱nze rew-mo̱ wu̱ ro̱tte̱. ");
INSERT INTO uth_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Remen kaane̱ Ye̱so ru̱ru̱ ye̱ cas, “Razarus mereste̱. ");
INSERT INTO uth_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Me̱ o-zak bo̱ me̱ rokne̱ káne̱ be-de u̱n wu̱ á, remen no̱ she̱re̱t. Amba a neke̱ no̱ be-de u̱n wu̱.” ");
INSERT INTO uth_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Se̱ Toma, wu̱ a m-ze̱e̱ ko-Pe̱se̱ à, wu̱ ze̱e̱ru̱ o̱r u̱n wu̱ ne̱, “A neke̱ no̱ u̱n cen na no̱ a meret no̱ mo̱sse̱ u̱n wu̱ ne̱.” ");
INSERT INTO uth_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Bo̱ Ye̱so woote̱ à, wu̱ 'wo̱ss Razarus nomoste̱ ho̱-u̱t nass u̱n saag. ");
INSERT INTO uth_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","O-Betanya yow yow o-Urusharima ne̱ o̱, o̱ ro̱ u̱ntu̱n me̱r-u̱t yoor kiromita 3. ");
INSERT INTO uth_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Yahuda-ne̱ haanu̱ru̱ u̱t-mo̱o̱r ne̱. Ye̱ haante̱ remen ye̱ gasté̱ Marta ne̱ u̱n Meri gas-de u̱n mar-m hen u̱n ye̱. ");
INSERT INTO uth_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Bo̱ Marta ho̱gu̱te̱ u̱nze Ye̱so ro̱o̱n à, wu̱ haaru̱ wu̱ m-gonte̱. Meri daagu̱ru̱ wu̱ she'et o-hur. ");
INSERT INTO uth_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Bo̱ wu̱ go'one̱ u̱n Ye̱so ne̱ à, Marta ze̱e̱ru̱ Ye̱so, “Go̱s-wu̱, wo̱ rokonte̱, heno te̱ Razarus wu̱ roa mer á. ");
INSERT INTO uth_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Amba ko̱ m-mo̱ka u̱m nepste̱ ko̱yan o ko̱ne̱ be-de Shir, wu̱a nomo wo̱.” ");
INSERT INTO uth_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Ye̱so ze̱e̱ru̱ wu̱, “Heno ru a inu̱sse̱ komo.” ");
INSERT INTO uth_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Marta ze̱e̱ru̱ wu̱, “U̱m nepste̱ wu̱a inu̱sse̱ ine̱-mo̱ m-margan ne̱ ho̱-de u̱r-ko̱m.” ");
INSERT INTO uth_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Ye̱so ze̱e̱ru̱ wu̱, “Ai, me̱ wu̱ ro̱ ine̱-mo̱ u̱n margan-ne̱. Me̱ wu̱ ro̱ ho̱o̱g. Ne̱t-wu̱ she̱re̱ hur-de u̱n wu̱ u̱n me̱ à, ko̱ wu̱ mer, wu̱a inu̱sse̱. ");
INSERT INTO uth_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Ne̱t-wu̱ ro̱ ne̱ u̱n ho̱o̱g ne̱ à, wu̱ she̱re̱ hur-de u̱n wu̱ be u̱n de à, wu̱ he de m-mar á har da-o̱ ba m-ta. ¿Wo̱ Marta wo̱ m-she̱r u̱n ma-u̱t re?” ");
INSERT INTO uth_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Marta ze̱e̱ru̱ wu̱, “O̱ho̱, Go̱s-wu̱, u̱m sheru̱ste̱ hur u̱n de, wo̱ ro̱ Kiristi, Wà-wu̱ Shir wu̱ a to̱mne̱ u̱n ho̱no o-dak à.” ");
INSERT INTO uth_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Bo̱ Marta ru̱rte̱ kaane̱ à, wu̱ haaru̱, wu̱ agnu̱ru̱ se̱k-wu̱ u̱n wu̱ Meri. Wu̱ ru̱ru̱ wu̱ u̱s-har, wu̱ ze̱e̱ru̱, “Wa-u̱r-Yoos na haante̱. Wu̱ ro̱ u̱n eeg-u̱s ru.” ");
INSERT INTO uth_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Meri ne̱ komo, bo̱ wu̱ ho̱gu̱te̱ kááne̱ à, wu̱ inu̱ru̱ ho̱r-m-ho̱r, wu̱ kawu̱ru̱ be-de Ye̱so ro à. ");
INSERT INTO uth_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Ye̱so u̱n go̱ wo̱o̱n o-bo̱ tokon á. Har m-mo̱ka wu̱ ro̱ be-de Marta gonte̱ wu̱ à. ");
INSERT INTO uth_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Hun-ne̱ ro be-u̱r Meri, o-hur ye̱ ro wu̱ u̱r-gas à, ye̱ hyanu̱ru̱ wu̱ inu̱te̱ ho̱r-m-ho̱r, wu̱ ruuru̱. Ye̱ do̱ru̱ru̱ wu̱, ye̱ ro̱ o-gwo̱t ye̱ zee u̱n saag o̱ wu̱ heye̱ wu̱ u̱nu̱t. ");
INSERT INTO uth_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Meri wo̱o̱ru̱ be-de Ye̱so ro à. Bo̱ wu̱ hyente̱ Ye̱so à, wu̱ he̱e̱ru̱ u̱n na-se u̱n wu̱. Wu̱ ze̱e̱ru̱ Ye̱so, “Go̱s-wu̱, u̱ rotte̱ u̱nze o rokon kàne̱ hen te̱ roa mer á.” ");
INSERT INTO uth_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Bo̱ Ye̱so hyente̱ wu̱ ro u̱s-'wo̱n à, Yahuda-ne̱ tomso ne̱ ye̱ haane̱ mo̱sse̱ u̱n wu̱ ne̱ à, ye̱ ro u̱s-'wo̱n. Me̱n-u̱t naasu̱ru̱ wu̱. ");
INSERT INTO uth_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Ye̱so ze̱e̱ru̱ ye̱, “¿Ke ne̱ o̱ no̱ jo̱ku̱ wu̱?” Ye̱ ze̱e̱ru̱ Ye̱so, “Go̱s-wu̱, haan o gu̱t.” ");
INSERT INTO uth_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Ye̱so 'wo̱nu̱ru̱. ");
INSERT INTO uth_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Remen kááne̱ hun-ne̱ ze̱e̱ru̱, “Gwo̱t bo̱ wu̱ wasse̱ u̱n wu̱ ne̱ à!” ");
INSERT INTO uth_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Ye̱ ken ye̱ be-de u̱n ka hun-ne̱ ye̱ ze̱e̱ru̱, “¿U̱ no̱m te̱ ka, ka ne̱t-wu̱, wu̱ ka upse̱ yish-ye̱ u̱n ko-po̱ á? ¿Wu̱ roa hoks we̱n u̱n Razarus m-mar á?” ");
INSERT INTO uth_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Ye̱so dooru̱ hyan u̱r-'wo̱n u̱n me̱n-to̱ u̱n wu̱. Wu̱ wo̱o̱nu̱ru̱ u̱n saag. Ka saag-o̱ ne̱ pak-o̱ u̱t-ta'ar o̱ u̱n o̱ ken ta'ar-o̱ a tige̱ u̱n ish-o̱ u̱n o̱. ");
INSERT INTO uth_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Ye̱so ze̱e̱ru̱, “Dos no̱ ka ta'ar-o̱.” Marta, wu̱ se̱k-wu̱ u̱n wu̱ mare̱ à, wu̱ ze̱e̱ru̱, “Go̱s-wu̱ re, wu̱a nomos wu̱s m-mo̱ka, remen ho̱-u̱t nass to̱ ka wu̱ caane̱ bo̱ m-mar.” ");
INSERT INTO uth_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Ye̱so ze̱e̱ru̱, “¿Me̱ ru̱ru̱ wo̱ o̱ á, u̱m zee wo̱ she̱r hur u̱n du u̱n me̱ ne̱, wo̱a hyen se̱ps-mo̱ Shir à?” ");
INSERT INTO uth_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Ye̱ dossu̱ru̱ o-ta'ar. Ye̱so dassu̱ru̱ u̱r-hi n-to̱n. Wu̱ ze̱e̱ru̱, “Tato re, u̱m bo̱mo̱g wo̱ remen o regu̱te̱ me̱ u̱t-to̱. ");
INSERT INTO uth_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","U̱m nepste̱ ko̱ da u̱n ke o ro̱ me̱ u̱n ke'e̱ u̱t-to̱. Amba me̱ u̱n rwo̱r remen hun-ne̱ ye̱ ro̱ kàne̱ eso eso à, remen ye̱ she̱re̱t hur-de u̱n ye̱ u̱nze wo̱ wu̱ to̱mnu̱ me̱.” ");
INSERT INTO uth_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Bo̱ wu̱ ru̱rte̱ kááne̱ à, wu̱ 'yonsu̱ru̱ u̱s-co̱r de̱e̱n, wu̱ ze̱e̱ru̱, “Razarus, rwu̱u̱n!” ");
INSERT INTO uth_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Wu̱ mare̱ à wu̱ argu̱ m-rwu̱u̱n, na-se u̱n wu̱ u̱t-kom ne̱ gegu̱rse̱ u̱n wa-de o-gund, co-o̱ u̱n wu̱ yeresse̱ u̱n gund-de u̱n du̱k. Ye̱so ze̱e̱ru̱, “Us no̱ wu̱, wu̱ arag!” ");
INSERT INTO uth_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Ka Yahuda-ne̱ ye̱ do̱re̱ Meri be-de u̱n saag à, ye̱ hyang rii-yo Ye̱so no̱me̱ à, mo̱o̱r-to̱ u̱n ye̱ she̱ru̱ hur-de u̱n ye̱ u̱n wu̱. ");
INSERT INTO uth_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Amba ye̱ ken ye̱ be-de u̱n ye̱ argu̱ru̱ m-ha be-de u̱n Parisa-ne̱, ye̱ ru̱ru̱ ye̱ rii-yo Ye̱so no̱me̱ à. ");
INSERT INTO uth_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Remen kááne̱ Gwo̱mo-ne̱ ye̱ u̱n ko̱n-se Shir u̱n Parisa-ne̱ ne̱ ye̱ aagu̱ru̱ Mo̱ro̱g-de u̱n Se̱k-ye̱ remen ye̱ piishté̱ u̱t-ma. Ye̱ ze̱e̱ru̱, “¿Ya u̱n yo ne̱ a no̱ m-no̱m? Gwo̱t no̱ saw-to̱ u̱t-hyat to̱ wu̱ ro̱ m-nom à! ");
INSERT INTO uth_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","A yage̱ wu̱ kááne̱, ko̱wan wu̱a sher u̱r-hur u̱n wu̱. Roma-ne̱ a haan, ye̱ sabarse̱ hun-ne̱ na u̱n Pyo-o̱ Shir ne̱ u̱n dak-o na ne̱.” ");
INSERT INTO uth_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Amba wan-gaan be-de u̱n ye̱, wu̱ a m-ze̱e̱ Ke̱pas à, wu̱ wu̱ ro ko-Gwo̱mo-wu̱ u̱n ko̱n-se Shir u̱n ka hak-o̱, wu̱ ze̱e̱ru̱, “No̱ de̱ no̱ nap to̱ no̱ m-rwo̱r á ");
INSERT INTO uth_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","¿No̱ m-gwo̱t á? Ai, jiishtu̱ no̱ wan-gaan mer o̱tte̱ kap mo̱ u̱n hun-ne̱ merme̱ à.” ");
INSERT INTO uth_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Yanze remen co̱n-mo̱ u̱n wu̱ o̱ wu̱ ru̱rte̱ kááne̱ á, se̱ de̱ u̱ntu̱n wu̱ ro ko-Gwo̱mo-wu̱ u̱n ko̱n-se Shir à, Shir u̱n kute̱ wu̱, wu̱ ru̱r ka ma-to̱ wu̱ zee Ye̱so a mer remen Yahuda-ne̱. ");
INSERT INTO uth_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Yanze ne̱ remen Yahuda-ne̱ u̱n ho̱n-de u̱n ye̱ á, amba remen wu̱ mo̱rgu̱nsu̱té̱ yakar-ye̱ Shir ye̱ ro̱ cakarse̱ ko̱ kene̱ à, ye̱ she'ete̱ kang-o gaan. ");
INSERT INTO uth_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Bo̱ u̱n ka ma-to̱ u̱n ka ho̱-de, ye̱ to̱o̱ru̱ u̱t-hun remen ye̱ hoot Ye̱so. ");
INSERT INTO uth_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Remen kááne̱, Ye̱so do m-rwu̱u̱n u̱r-buk cas be-de u̱n Yahuda-ne̱ á. Amba wu̱ inu̱ru̱ káne̱, wu̱ neku̱ru̱ u̱n dak-o̱ ro̱ o-zang à. Wu̱ co̱wu̱ru̱ u̱n o̱ ken bo̱-o̱ o̱ a m-ze̱e̱ o-E̱param à. Wu̱ she'etu̱ru̱ káne̱ u̱n yan-neke̱-mo̱ u̱n wu̱ ne̱. ");
INSERT INTO uth_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","A kane̱, Biki-o̱ m-Pas o̱ u̱n he de m-wo̱o̱n. Hun-ne̱ u̱t-mo̱o̱r ne̱ ye̱ haaru̱ o-Urusharima remen ye̱ koosté̱ hi u̱n de u̱n ye̱ ye̱ she'eté̱ ba m-ku̱ko̱p rii-yo Biki-o̱ m-Pas wo̱o̱nte̱. ");
INSERT INTO uth_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Ye̱ ze̱e̱ru̱ hoob-o Ye̱so, ye̱ ro̱ eso eso u̱n Pyo-o̱ Shir. Ye̱ m-ze̱e̱, “¿Ya u̱n yo ne̱ no̱ hyane̱? ¿Wu̱ ro̱o̱n o-biki?” ");
INSERT INTO uth_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Hun-ne̱ ma'asu̱ hoob-o Ye̱so, remen Gwo̱mo-ne̱ ye̱ u̱n ko̱n-se Shir u̱n Parisa-ne̱ ne̱ ye̱ rwo̱'o̱g u̱nze bo̱ u̱n wu̱ hyane̱ be-de Ye̱so ro à, wu̱ haan, wu̱ ru̱r, ye̱ shipt wu̱. ");
INSERT INTO uth_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Biki-o̱ m-Pas kuks ho̱-u̱t cind, Ye̱so haanu̱ru̱ bo̱-o̱ o-Betanya be-de Razarus ro'e̱ à, wu̱ Ye̱so 'yonse̱ u̱t-marimar à. ");
INSERT INTO uth_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Ye̱ no̱mu̱ru̱ rii-yo m-re̱ yo m-te̱t remen ye̱ hwo̱o̱g Ye̱so u̱r-ke̱e̱r. Marta wu̱ no̱me̱ rii-yo m-re̱. Razarus ne̱ ye̱ ro m-re̱ be-u̱r gaan u̱n Ye̱so ne̱. ");
INSERT INTO uth_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Ka da-de ne̱, Meri de̱ku̱ru̱ batta-de u̱n no̱w-mo̱ m-shi'igin. Ka no̱w-mo̱ wo̱o̱g pu̱ru̱g-de o-rita, mo̱ o-nardi, komo a mo̱sse̱ mo̱ u̱n rii ne̱ á, mo̱ u̱n hwo̱r mo̱ de̱e̱n. Wu̱ hokmu̱ru̱ mo̱ Ye̱so u̱s-na, wu̱ pe̱'e̱gu̱ru̱ ka no̱w-mo̱ u̱n hi-se u̱n hi-de u̱n wu̱. Kur-o kutuksu̱ru̱ u̱n m-shi'igin. ");
INSERT INTO uth_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Amba Yahudas Iskariyoti, wu̱ ro wan-gaan be-de u̱n yan-neke̱-m Ye̱so wu̱ he m-ya'as u̱n Ye̱so a ho à. Wu̱ ze̱e̱ru̱, ");
INSERT INTO uth_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“¿Ya u̱n yo ne̱ we̱ne̱ Meri beeb ka no̱w-mo̱, a wo̱nge̱ ko̱o̱b-ne̱ ka hwo̱r-ye̱? Ai, ká hwo̱r-ye̱ ro wooste̱ gu̱wu̱s-de u̱n hak.” ");
INSERT INTO uth_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Yahudas Iskaryoti u̱n rwo̱r kááne̱ yanze remen wu̱ ro m-was u̱n ko̱o̱b-ne̱ ne̱ o̱ á, se̱ de̱ wu̱ ko-hyow-wu̱. Komo ne̱ wu̱ ro wan-bo̱p-to̱ u̱n ba-de u̱n hwo̱r, wu̱ ro ye̱ m-ma'as m-hiw. ");
INSERT INTO uth_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Ye̱so ze̱e̱ru̱, “A yage̱ Meri, wu̱ u̱n hokmo me̱ m-no̱w remen ho̱-de a he me̱ jo̱k à. ");
INSERT INTO uth_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Ai, ko̱ de ke da-de no̱ mo̱sse̱ u̱n ko̱o̱b-ne̱ ne̱, amba ba ko̱ da u̱n ke o̱ no̱ he m-ma'as u̱n me̱ ne̱ á.” ");
INSERT INTO uth_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Da-o̱ hun-ne̱ ho̱gu̱te̱ u̱nze Ye̱so ro u̱n bo̱-o̱ o-Betanya, Yahuda-ne̱ u̱t-mo̱o̱r ne̱ ye̱ haanu̱ru̱ be-de u̱n wu̱. Yanze rem Ye̱so u̱n ho̱n-de u̱n wu̱ á, har remen ye̱ hyenet u̱n Razarus ne̱ wu̱ Ye̱so 'yonse̱ be-de m-mar à. ");
INSERT INTO uth_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Gwo̱mo-ne̱ ye̱ u̱n ko̱n-se Shir ye̱ gamu̱ru̱ u̱t-hi ye̱ hoot Razarus u̱n ce u̱n wu̱, ");
INSERT INTO uth_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","remen u̱n wu̱ o̱ Yahuda-ne̱ u̱t-mo̱o̱r ne̱ yagu̱te̱ do̱re̱ u̱n gwo̱mo-ne̱ ye̱ u̱n ko̱n-se Shir. Ye̱ she̱re̱ hur-de u̱n ye̱ be-u̱r Ye̱so. ");
INSERT INTO uth_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Bo̱ ish geste̱ à, caari-de u̱r-mo̱ro̱g de u̱n ye̱ ha ka Biki-o̱ m-Pas à, ho̱gu̱ru̱ u̱nze Ye̱so ro̱o̱n o-Urusharima. ");
INSERT INTO uth_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Ye̱ de̱knu̱ru̱ jet-se o-ke̱re̱m. Ye̱ ze̱e̱ru̱ m-ru ye̱ gontu̱te̱ wu̱, ye̱ ro u̱n 'yons u̱s-co̱r, ye̱ ro m-ze̱e̱, “U̱r-bo̱ngo̱n be-de Shir! Shir hu̱u̱te̱ wu̱ nu-o so̱-o̱ wu̱, wu̱ haane̱ u̱n be̱e̱b-u̱r Yawe à. Shir hu̱u̱te̱ wu̱ nu-o so̱-o̱ wu̱ ro̱ ko-Gwo̱mo-wu̱ u̱n Isra-ne̱ à!” ");
INSERT INTO uth_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Ye̱so ro m-nekne̱ n-to̱n u̱n ya o-janka bo̱ ro̱ gense̱ be-de u̱n Ma-to̱ Shir à u̱nze, ");
INSERT INTO uth_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“No̱ ya-o-Urusharima taase no̱ ho̱ge̱ o-gye̱r á, Ko-Gwo̱mo no̱ wu̱ ka ro̱o̱ne̱ n-to̱n u̱n ya o-janka.” ");
INSERT INTO uth_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","U̱r-takan, yan-neke̱-mo̱ u̱n wu̱ ro nak u̱n kà rem-se ne̱ á, se̱ da-o̱ a se̱pse̱ Ye̱so à. Ká da-o̱, ye̱ bakse̱ u̱nze gense̱ ma-to̱ u̱n wu̱ ro̱, komo to̱ ko̱ru̱ru̱ kááne̱ hond hond bo̱ a ge̱ne̱ to̱ à. ");
INSERT INTO uth_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Da-de wu̱ aage̱ Razarus wu̱ rwu̱u̱n u̱n saag à, komo wu̱ 'yonstu̱ wu̱ u̱n ho̱o̱g ne̱ à, bu̱u̱g-de u̱n hun-ne̱ de ro mo̱sse̱ u̱n wu̱ ne̱ à, ye̱ ye̱ ru̱re̱ hun-ne̱ ka ma-to̱. ");
INSERT INTO uth_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Rii-yo hante̱ mo̱ro̱g-u̱r heet gonte̱ de u̱n wu̱ à yo ro̱, remen ye̱ ho̱gu̱te̱ wu̱ no̱mo̱g ká rii-yo u̱t-hyat yo. ");
INSERT INTO uth_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Bo̱ Parisa-ne̱ ho̱gu̱te̱ ya-o-Urusharima haag ye̱ gontu̱te̱ Ye̱so à, ye̱ ze̱e̱ru̱ hi u̱n de u̱n ye̱, “Yatt-yo a hokse̱ m-no̱m á! Ai, ho̱no o-dak do̱ru̱ssu̱te̱ wu̱!” ");
INSERT INTO uth_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Káne̱, be-de u̱n ye̱ haane̱ ká biki-o̱ à Girik-ne̱ ro kon. Ye̱ u̱n haan remen ye̱ nomoté̱ Shir u̱r-bo̱ngo̱n. ");
INSERT INTO uth_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Ye̱ haanu̱ru̱ be-u̱r Pirip (wu̱ ko-wa-o-Besayada u̱n dak-o̱ o-Gariri). Ye̱ ko̱nu̱ru̱ wu̱, ye̱ ze̱e̱ru̱, “Go̱s-wu̱, te̱ co̱no̱g hyan-o Ye̱so.” ");
INSERT INTO uth_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Pirip haaru̱, wu̱ ru̱ru̱ Andarawus. Andarawus u̱n Pirip ne̱ haanu̱ru̱, ye̱ ru̱ru̱ Ye̱so. ");
INSERT INTO uth_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Ye̱so ze̱e̱ru̱ ye̱, “Da-o nomoste̱ o̱ a hette̱ me̱ m-se̱ps à, me̱ Wà-wu̱ u̱n ne̱t. ");
INSERT INTO uth_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Me̱ no̱ m-ru̱re̱ o-nip, go̱-yo o-hyo he̱ne̱ n-dak se̱ yo mereste̱, go̱-o gaan-yo ro̱ m-ma'as. Amba da-o̱ yo po̱tne̱, yo matu̱ru̱ de̱e̱n. ");
INSERT INTO uth_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Wan-co̱n-to̱ u̱n ho̱o̱g-o̱ u̱n kàne̱ u̱n ho̱no o-dak, wu̱a taage̱ u̱n ho̱o̱g-o̱ ro̱ be-de Shir à. Ne̱t-wu̱ yage̱ ne̱ ho̱o̱g-o̱ u̱n kàne̱ u̱n ho̱no o-dak à, wu̱a kum ho̱o̱g-o̱ Shir o̱ ba m-ta. ");
INSERT INTO uth_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Kap wu̱ he me̱ nome̱ m-gu̱w à, wu̱ do̱ru̱ me̱ be-de u̱m ro̱ à, káne̱ o̱ wu̱ he m-she'et u̱n cen wu̱. Ko̱wan wu̱ nomo me̱ m-gu̱w, Tato re a se̱ps wu̱.” ");
INSERT INTO uth_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“M-mo̱ka me̱ u̱n ho̱ge̱ u̱n nu̱-se u̱n ho̱o̱g re. ¿Ya u̱m he m-ze̱e̱? ¿U̱m zee ‘Tato re dossu̱ me̱ ka swo̱ u̱r-ko̱o̱b de’? Ay, ko̱ n-ga, me̱ u̱n haan remen ka da-o̱. ");
INSERT INTO uth_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","O-Tato, yage̱ a hyenet se̱ke̱mse̱-m ru.” Bo̱ Ye̱so ru̱rte̱ kaane̱ à, a ho̱gu̱ru̱ o̱ ken co̱r-o̱ n-To̱n shir, o̱ ro̱ m-ze̱e̱, “U̱m be'essu̱te̱, u̱m se̱ke̱msu̱ssu̱te̱ hi u̱n de. Man do hi u̱n de m-se̱ke̱mse̱ komo ne̱.” ");
INSERT INTO uth_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Mo̱o̱r-to̱ u̱n hun-ne̱ ye̱ ro kane̱ eso eso à, ye̱ ho̱gu̱ru̱ ka co̱r-o̱. Ye̱ ze̱e̱ru̱, “Ai, dàkàr-o̱.” Ye̱ ken ye̱ ze̱e̱ru̱, “Wu̱ ken ko-wan-to̱m-wu̱ Shir wu̱ wu̱ te̱psu̱ wu̱.” ");
INSERT INTO uth_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Ye̱so ze̱e̱ru̱, “Rem re o̱ no̱ ho̱gu̱te̱ ka co̱r-o̱ á, se̱ de̱ rem no̱. ");
INSERT INTO uth_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","M-mo̱ka o̱ Shir he piishe̱ u̱n ho̱no o-dak u̱t-ma. M-mo̱ka o̱ Shir he m-ruut u̱n be̱e̱b-de u̱n gwo̱mo-to̱ ko-Gwo̱mo-wu̱ u̱n ya-u̱t-ko̱t wu̱ ro̱ gwo̱mo-to̱ u̱n ka ho̱no o-dak à. ");
INSERT INTO uth_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Amba me̱, da-o̱ a kame̱ me̱ n-to̱n o-kan à, remen kááne̱ man ru̱ hun-ne̱ m-haan be u̱n de.” ");
INSERT INTO uth_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Rwo̱r-mo̱ u̱n wu̱ kááne̱ mo̱ mo̱ kute̱ go̱n mar-mo̱ wu̱ hette̱ à. ");
INSERT INTO uth_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Mo̱o̱r-to̱ u̱n hun-ne̱ shasu̱ru̱ wu̱, “Ro̱ gense̱ be-de u̱n Taku̱rda-o̱ u̱n Ma-to̱ Shir, a zee Kiristi a she'et ko̱ da u̱n ke. To̱, ¿re o̱ u̱n ya o zet ‘A kem Wà-wu̱ u̱n ne̱t o-kan?’ ¿Wan wu̱ ne̱ ka Wà-wu̱ u̱n ne̱t wu̱?” ");
INSERT INTO uth_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Ye̱so ze̱e̱ru̱ ye̱, “M-mo̱ka ya o-da hiin kane̱ u̱n co, cecas-m ro̱ mo̱sse̱ u̱n no̱ ne̱. Nom no̱ u̱r-hew cin cecas-m ro̱ mo̱sse̱ u̱n no̱ ne̱, taasu̱ te̱t-mo̱ rew no̱ n-co̱w. Wu̱ te̱t-m rewe̱ à, wu̱a hyen co̱w-yo m-do̱re̱ á. ");
INSERT INTO uth_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","She̱r no̱ m-cecas ne̱ da-de no̱ ro̱ u̱n mo̱ ne̱ à, remen no̱ waragté̱ hun-ne̱ ye̱ m-cecas.” Bo̱ Ye̱so ru̱rte̱ kááne̱ à, wu̱ argu̱ru̱ m-neke̱, wu̱ wuku̱ru̱ ye̱. ");
INSERT INTO uth_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Ko̱ de ro̱tte̱ wu̱ swo̱o̱g ye̱ kute̱ u̱n rem-se u̱t-hyat u̱t-mo̱o̱r ne̱ u̱n yish-ye̱ u̱n ye̱ à, kap u̱n kaane̱ ne̱, ye̱ she̱r u̱nze wu̱ wu̱ ro̱ Kiristi á. ");
INSERT INTO uth_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Káne̱ o̱, a shoose̱ rwo̱r-m Ishayawan-Rwo̱r u̱n Ma-to̱ Shir. Wu̱ zee, “Yawe, ¿wan wu̱ ne̱ she̱re̱ u̱n ma-u̱t te̱ ne̱? ¿Be-u̱r wan o̱ ne̱ Yawe rwu̱nte̱ be̱e̱b-de u̱n wu̱?” ");
INSERT INTO uth_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","O̱ hante̱, ye̱ hokste̱ m-she̱r á remen Ishaya doog m-ze̱e̱, u̱n de ken be-de. ");
INSERT INTO uth_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Shir po̱o̱ste̱ yish-ye̱ u̱n ye̱, komo wu̱ ho̱o̱g hur-de u̱n ye̱, taasu̱ ye̱ hyen u̱n yish-de u̱n ye̱, ye̱ nept komo u̱n hur-de u̱n ye̱, har ye̱ mu̱u̱nté̱ be u̱n de, u̱m dossu̱tu̱ ye̱ po̱-to̱ u̱r-hur.” ");
INSERT INTO uth_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Ishaya u̱n rwo̱r kááne̱ remen wu̱ hyanag se̱ke̱mse̱-m Ye̱so, wu̱ ro̱ro̱g ma-to̱ u̱n wu̱. ");
INSERT INTO uth_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Kap u̱n ko̱o̱b-de u̱n she̱r u̱n hur-de u̱n ye̱ u̱n wu̱ ne̱, u̱t-mo̱o̱r ne̱ be-de go̱s-ye̱ ye̱ u̱n Yahuda-ne̱, ye̱ she̱re̱g u̱n wu̱. Amba ye̱ e̱s m-rwu̱nte̱ á, u̱n gye̱r-o̱ u̱n taase Parisa-ne̱ ruut ye̱ u̱n kuke̱-o̱ u̱n yoos u̱n Ma-to̱ Shir. ");
INSERT INTO uth_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Ye̱ jiishte̱ m-co̱n hun-ne̱ bu̱m ye̱ o̱tte̱ Shir bu̱m ye̱ à. ");
INSERT INTO uth_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Ye̱so 'yonsu̱ru̱ u̱s-co̱r de̱e̱n, wu̱ ze̱e̱ru̱, “Wu̱ she̱re̱ be u̱n de à, me̱ wu̱ u̱n ho̱n-de wu̱ she̱rte̱ á. Amba wu̱ ro̱ m-she̱r u̱n wu̱ to̱mnu̱ me̱ ne̱ à. ");
INSERT INTO uth_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Ne̱t-wu̱ ro̱ me̱ m-hyan à, wu̱ ro̱ m-hyan u̱n Tato re wu̱ to̱mne̱ me̱ u̱n ho̱no o-dak à. ");
INSERT INTO uth_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Me̱ u̱n haan ho̱no o-dak remen u̱m ye'et hun-ne̱ m-cecas. Wu̱ she̱re̱ u̱n me̱ ne̱ à, taase wu̱ she'et o-comb á. ");
INSERT INTO uth_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","“Bo̱n wu̱ ho̱ge̱ ma-u̱t re, wu̱ do̱re̱ to̱ á, man piishe̱ wu̱ u̱t-ma á. Yanze remen u̱m piishite̱ ho̱no o-dak u̱t-ma o̱ u̱m haante̱ á, se̱ de̱ remen u̱m guut ho̱no o-dak. ");
INSERT INTO uth_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Ne̱t-wu̱ yage̱ me̱ à, wu̱ go̱ks komo ne̱ ma-u̱t re á, wan-piish u̱n wu̱ u̱t-ma ro̱ ko̱n. Ma-u̱t re to̱ u̱m rwo̱re̱ à, to̱ a hette̱ ne̱t piishe̱ u̱t-ma u̱n ho̱-de u̱r-ko̱m. ");
INSERT INTO uth_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Yanze ka ma-to̱, ma-to̱ u̱n hi u̱n de to̱ á. Tato re wu̱ to̱mne̱ me̱ à, u̱n hi u̱n de u̱n wu̱, wu̱ ya'e̱ me̱ co̱w-yo u̱n to̱, u̱n bo̱ u̱m he to̱ m-rwo̱r ne̱ à. ");
INSERT INTO uth_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","U̱m nepste̱ ka karamsa-o̱ ro̱ na m-woot u̱n ho̱o̱g-o̱ ba m-ta. Remen kááne̱, kap bo̱ u̱n rii-yo u̱m rwo̱re̱ à, Tato re ze̱e̱ me̱ u̱m ru̱r yo.” ");
INSERT INTO uth_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","A káne̱, da-o̱ Biki-o̱ m-Pas ro u̱n he de m-wo̱o̱n à, Ye̱so nepste̱ ne̱ da-o wooste̱ o̱ wu̱ hette̱ m-ine̱ u̱n ka ho̱no o-dak o̱ wu̱ waragte̱ be-u̱r Tato u̱n wu̱, wu̱ n-To̱n à. Wu̱ waste̱ ye̱, ye̱ ro̱ ye̱ ma u̱n wu̱ n-me̱ u̱n ho̱no o-dak à, m-mo̱ka wu̱ kutute̱ ye̱ bo̱ wu̱ wasse̱ u̱n ye̱ ne̱ à har da-o̱ u̱r-ko̱m. ");
INSERT INTO uth_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Bo̱ ho̱-u̱r he̱'e̱bu̱te̱ à, Ye̱so ne̱ u̱n yan-neke̱-mo̱ u̱n wu̱ ne̱ ye̱ mo̱rgu̱ru̱ remen ye̱ reet rii-yo m-re̱. Ko-Gwo̱mo-wu̱ u̱n ya-u̱t-ko̱t be'essu̱te̱ wu̱ cu̱wu̱ste̱ u̱n hur-u̱r Yahudas Iskariyoti wà Simo̱n, wu̱ ya'aste̱ Ye̱so u̱n kom-to̱ u̱n yan-yage̱-to̱ u̱n wu̱. ");
INSERT INTO uth_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Ye̱so nepste̱ Tato u̱n wu̱ be'essu̱te̱ wu̱ ya'assu̱te̱ wu̱ gwo̱mo-to̱ u̱n ko̱ yo ke rii-yo. Wu̱ nepste̱ ne̱ be-de Shir o̱ wu̱ rwu̱u̱ne̱, be-de Shir o̱ tomso ne̱ wu̱ he m-warag. ");
INSERT INTO uth_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Wu̱ inu̱ru̱ be-de wu̱ ro tara à, wu̱ possu̱ru̱ co̱p-o̱ u̱n wu̱. Wu̱ de̱knu̱ru̱ u̱r-bo̱jo̱, wu̱ yapu̱ru̱ de u̱n byon. ");
INSERT INTO uth_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Ka da-de ne̱, wu̱ duusu̱ru̱ m-ho̱ o-jaw. Wu̱ ma'asu̱ru̱ u̱n sapte̱ u̱n yan-neke̱-mo̱ u̱n wu̱ u̱s-na. Bo̱ wu̱ saptu̱te̱ ye̱ u̱s-na à, wu̱ ussu̱ru̱ bo̱jo̱-de ro yepo u̱n byon-o̱ u̱n wu̱ à, wu̱ sokmu̱ru̱ ye̱ u̱s-na u̱n de. ");
INSERT INTO uth_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Bo̱ wu̱ woote̱ be-u̱r Simo̱n Bitrus à, Simo̱n Bitrus ze̱e̱ru̱ wu̱, “Wo̱, Go̱s-wu̱, ashi, ¿wo̱ wu̱ he me̱ sapte̱ u̱s-na?” ");
INSERT INTO uth_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Ye̱so ze̱e̱ru̱ wu̱, “M-mo̱ka wo̱ nap rii-yo me̱ m-nom á, amba u̱jime̱ wo̱a neps.” ");
INSERT INTO uth_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Simo̱n Bitrus ze̱e̱ru̱, “Ay, wo̱a ce̱t me̱ u̱n sapte̱ u̱s-na á.” Ye̱so ze̱e̱ru̱ wu̱, “Me̱ sapte̱ wo̱ ne̱ u̱s-na á, yatt-yo nu̱'u̱se̱ me̱ u̱n wo̱ ne̱ á.” ");
INSERT INTO uth_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Ka da-de ne̱, Simo̱n Bitrus ze̱e̱ru̱ wu̱, “Go̱s-wu̱, u̱rege̱ kaane̱ o̱, na-se u̱n ho̱n-de u̱n se o he me̱ m-sapte̱ á, sapte̱ me̱ u̱t-kom u̱r-hi ne̱.” ");
INSERT INTO uth_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Ye̱so ze̱e̱ru̱ wu̱, “Zorse̱-o ro̱ u̱n hoob-o̱ m-zo̱r komo ne̱ á, se̱ de̱ sapt u̱s-na temb, remen wu̱ be'essu̱te̱ wu̱ ja'assu̱te̱ cas cas. No̱ ne̱ ja'asse̱ ne̱ ye̱, amba kap-m no̱ o̱ á.” ");
INSERT INTO uth_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Ye̱so nepste̱ wu̱ he wu̱ m-ya'as à, de de wu̱ zette̱ kap-m no̱ o̱ no̱ ro̱ ja'asse̱ á. ");
INSERT INTO uth_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Bo̱ wu̱ komte̱ sapt u̱n na-se u̱n ye̱ à, wu̱ co̱pu̱ru̱ co̱p-o̱ u̱n wu̱. Wu̱ wargu̱ru̱ be-de wu̱ ro'e̱ tara à, wu̱ ze̱e̱ru̱, “¿No̱ nepste̱ rii-yo u̱m nomu̱ no̱? ");
INSERT INTO uth_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","No̱ me̱ m-aag ‘Wa-u̱r-Yoos,’ komo ‘Go̱s-wu̱’ no̱. Hond hond o̱ ne̱ komo. Ka bo̱-se o̱ u̱m ro̱. ");
INSERT INTO uth_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Bo̱ me̱ Go̱s-wu̱, u̱n Wa-u̱r-Yoos ne̱ à, har u̱m saptu̱te̱ no̱ u̱s-na à, depete̱ u̱n cen no̱ ne̱ no̱ sapt na-u̱s o̱r no̱ ne̱. ");
INSERT INTO uth_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","No̱m no̱ kaane̱ remen u̱m nomu̱tu̱ no̱ o-bu̱ remen no̱ nomot bo̱ u̱m nomu̱ no̱ à. ");
INSERT INTO uth_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Me̱ no̱ m-ru̱re̱ o-nip, gu̱w-ne̱ ro̱ m-jiish u̱n go̱s-ye̱ ye̱ u̱n ye̱ ne̱ á. Wan-to̱m komo wu̱ ro̱ m-jiish u̱n ne̱t-wu̱ to̱mnu̱ wu̱ á. ");
INSERT INTO uth_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","U̱rege̱ no̱ nepste̱ u̱n kaane̱ ne̱, no̱ tomso ne̱ m-no̱m o-do̱ro̱tte̱, Shir a hu̱u̱ no̱ nu so̱-o̱. ");
INSERT INTO uth_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Kap-m no̱ o̱ me̱tte̱ á. U̱m nepste̱ ye̱ u̱m degre̱ à. Kap remen a shoosté̱ ma-to̱ ro̱ gense̱ n-me̱ u̱n Ma-to̱ Shir à, ‘Ne̱t-wu̱ ro̱ m-re̱ mo̱sse̱ u̱n me̱ ne̱ à, wu̱ ro̱ me̱ u̱t-yage̱.’ ");
INSERT INTO uth_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","“Me̱ no̱ m-ru̱re̱ m-mo̱ka cin ba ka rii-yo u̱n no̱m, remen da-o̱ yo nome̱, no̱ she̱re̱t me̱ wu̱ ro̱ Kiristi, Wan-Gwu̱ wu̱ Shir to̱mne̱ ho̱no o-dak à. ");
INSERT INTO uth_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Me̱ no̱ m-ru̱re̱ o-nip, bo̱ u̱n ne̱t-wu̱ go̱kse̱ wu̱ u̱m to̱mbe̱ à, wu̱ go̱kste̱ me̱ o̱ ka. Wu̱ go̱kse̱ me̱ ne̱ à, wu̱ go̱kste̱ Shir o̱ ka wu̱ to̱mne̱ me̱ à.” ");
INSERT INTO uth_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Bo̱ Ye̱so ru̱rte̱ kááne̱ à, wu̱ ho̱gu̱ru̱ u̱s-nu̱ u̱n hur-de u̱n wu̱. Wu̱ ru̱ru̱ yan-neke̱-mo̱ u̱n wu̱ cas, wu̱ ze̱e̱ru̱, “Me̱ no̱ m-ru̱re̱ o-nip, wan-gaan be u̱n no̱, wu̱a ya'as me̱ u̱n kom-to̱ u̱n yan-yage̱-u̱t re.” ");
INSERT INTO uth_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Yan-neke̱-mo̱ u̱n wu̱ gu̱tru̱ru̱ hi u̱n de u̱n ye̱, ye̱ nap wu̱ Ye̱so ro̱tte̱ á. ");
INSERT INTO uth_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Wu̱ ken be-de u̱n yan-neke̱-mo̱ u̱n wu̱, wu̱ Ye̱so wasse̱ u̱n wu̱ ne̱ de̱e̱n à, wu̱ ro u̱n he̱r-o Ye̱so. ");
INSERT INTO uth_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Simo̱n Bitrus ze̱e̱ru̱ wu̱ u̱s-har, “Citu̱ na Ye̱so u̱nze, ¿Wan wu̱ ne̱ wu̱ ro̱tte̱?” ");
INSERT INTO uth_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Ka wu̱ ro u̱n he̱r-o Ye̱so à, wu̱ kaksu̱nu̱ru̱, wu̱ ze̱e̱ru̱, “Go̱s-wu̱, ¿wan wu̱ ne̱?” ");
INSERT INTO uth_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Ye̱so shasu̱ru̱, “Wu̱ ka, wu̱ u̱m he m-huwe̱ u̱r-buro̱di u̱m ya'as wu̱ à.” Bo̱ wu̱ huute̱ ne̱ hwu̱-de u̱r-buro̱di à, wu̱ ya'asu̱ru̱ Yahudas Iskariyoti wà Simo̱n. ");
INSERT INTO uth_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Bo̱ wu̱ go̱kste̱ ka hwu̱-de à, ko-Gwo̱mo-wu̱ u̱n ya-u̱t-ko̱t co̱wu̱ru̱ u̱n hur-de u̱n wu̱. Ye̱so ze̱e̱ru̱ wu̱, “No̱m yo o co̱ne̱ à kyak.” ");
INSERT INTO uth_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Amba ye̱ ka ye̱ ro̱ u̱n re̱ u̱n rii-yo m-re̱ à yatt-wu̱ nape̱ rii-yo hante̱ Ye̱so zeet wu̱ kááne̱ á. ");
INSERT INTO uth_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Ye̱ e̱ssu̱ru̱ u̱nze Ye̱so u̱n to̱m Yahudas o̱n rem-se o-biki, ko̱ ne̱ wu̱ ya'as ko̱o̱b-ne̱ yo ken rii-yo, remen Yahudas wu̱ ro u̱n ba-de u̱n hwo̱r-ye̱ u̱n ye̱ ne̱. ");
INSERT INTO uth_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Te̱t-mo̱ ne̱ komo, bo̱ wu̱ go̱kste̱ hwu̱-de u̱r-buro̱di à, wu̱ argu̱ru̱ m-ru but. ");
INSERT INTO uth_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Bo̱ Yahudas ruute̱ à, Ye̱so ze̱e̱ru̱, “Da-o wooste̱ o̱ Wà-wu̱ u̱n ne̱t hette̱ co̱w u̱n se̱ps-mo̱ u̱n wu̱ à. Komo a se̱ps Shir remen wu̱. ");
INSERT INTO uth_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","U̱rege̱ a se̱ke̱mse̱te̱ Shir u̱n me̱, Shir a se̱ke̱mse̱ me̱ tomso ne̱ ha-mo̱ u̱n be-de u̱n wu̱. Ho̱r-m-ho̱r o̱ ne̱ wu̱ he me̱ m-se̱ke̱mse̱. ");
INSERT INTO uth_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","“No̱ yakar re re̱k-ye̱ re̱k-ye̱, o-da hiin o̱ u̱m ro̱ mo̱sse̱ u̱n no̱ ne̱. No̱a hoob me̱, amba bo̱ u̱m ru̱re̱ Se̱k-ye̱ be-de u̱n Yahuda-ne̱ u̱nze be-de u̱m he'e̱ à no̱a hoks m-ha káne̱ á, ka o̱ me̱ no̱ m-ru̱re̱ m-mo̱ka. ");
INSERT INTO uth_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","“Karamsa-o pu̱-o̱ o̱ me̱ no̱ m-ru̱re̱. Was no̱ u̱n o̱r no̱ ne̱. Bo̱ u̱m wasse̱ u̱n no̱ ne̱ à, ka bo̱-se ne̱ o̱ u̱n cen no̱ ne̱ no̱ was u̱n o̱r no̱ ne̱. ");
INSERT INTO uth_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Kááne̱ o̱ ko̱wan he m-nap u̱nze yan-neke̱-m re ye̱ no̱ ro̱, u̱rege̱ de̱ u̱nze no̱ m-was u̱n o̱r no̱ ne̱ ne̱.” ");
INSERT INTO uth_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simo̱n Bitrus ze̱e̱ru̱ wu̱, “Go̱s-wu̱ te̱, ¿ke co̱-o̱ o he?” Ye̱so shasu̱ru̱ wu̱, “Be-de u̱m he'e̱ à, wo̱a hoks me̱ m-do̱re̱ m-mo̱ka á. Amba u̱jime̱ kane̱ u̱n co hiin, wo̱a do̱ru̱ me̱.” ");
INSERT INTO uth_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Bitrus ze̱e̱ru̱ wu̱, “Go̱s-wu̱, ¿remen yan o̱ me̱tte̱ à hoks wo̱ m-do̱re̱ m-mo̱ka á? Ai, man ya'as ho̱o̱g re rem ru.” ");
INSERT INTO uth_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Ye̱so ze̱e̱ru̱, “¿Har wo̱a ya'as ho̱o̱g ru rem re? Me̱ no̱ m-ru̱re̱ o-nip, rii-yo ke̱e̱g-o kiit-yo kenet, wo̱a nom she-mo̱ u̱n nap-o re har so̱ o-tet.” ");
INSERT INTO uth_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Ye̱so ze̱e̱ru̱ ye̱. “Taase hur-u̱r no̱ naase̱ á. She̱r no̱ be-de Shir. No̱ she̱r be u̱n de tomso ne̱. ");
INSERT INTO uth_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","U̱n hur-o Tato re kuke̱-u̱t ro̱ ko̱n de̱e̱n. U̱ rotte̱ kááne̱ o̱ á, u̱m roa ru̱ru̱ no̱ á. Komo neke̱-mo̱ u̱m he'e̱ re̱e̱no̱ u̱m ja'asu̱té̱ no̱ u̱r-be. ");
INSERT INTO uth_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Me̱n neke̱, me̱ ja'asu̱nse̱ no̱ u̱r-be tomso ne̱, u̱m dooru̱ m-mu̱u̱n u̱m de̱gbu̱té̱ no̱ u̱n be-de u̱n hi u̱n de remen no̱ she'etté̱ be-de u̱m ro̱ à. ");
INSERT INTO uth_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Be-de u̱m he'e̱ à, tomso ne̱ no̱ nepste̱ o-co̱w.” ");
INSERT INTO uth_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tomas ze̱e̱ru̱ wu̱, “Go̱s-wu̱, te̱ nap be-de o he'e̱ á. ¿Re o̱ te̱ he m-no̱m te̱ nept o-co̱w?” ");
INSERT INTO uth_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Ye̱so ze̱e̱ru̱ wu̱, “Me̱ wu̱ ro̱ o-co̱w, me̱ wu̱ ro̱ o-nip, me̱ wu̱ ro̱ ho̱o̱g. Wa m-ha be-u̱r Tato re ro̱ ko̱n á, se̱ wu̱ do̱nte̱ be u̱n de remen me̱ wu̱ ro̱ o-co̱w yo m-ha be-u̱r Tato re. ");
INSERT INTO uth_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","No̱ ro nepstu̱ me̱, no̱ roa nep Tato re tomso ne̱. Amba kane̱ u̱n co, no̱a neps wu̱ har no̱ hyen wu̱ tomso.” ");
INSERT INTO uth_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Pirip ze̱e̱ru̱ wu̱, “Go̱s-wu̱, kutu̱ te̱ o-Tato. Bo̱'o̱ssu̱tu̱ te̱.” ");
INSERT INTO uth_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Ye̱so ze̱e̱ru̱ wu̱, “Pirip, ho̱nu̱ a she'ete̱ no̱ cen no̱ ne̱ à, ¿o ze̱e̱ru̱ har m-mo̱ka wo̱ nap me̱ á? Ai, kap ne̱t-wu̱ hyane̱ me̱ à, ai wu̱ hyanag o-Tato. ¿Re o̱ u̱n ya o zette̱, ‘Kute̱ te̱ o-Tato’? ");
INSERT INTO uth_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","¿Wo̱ she̱r u̱nze me̱ n-me̱ o-Tato, o-Tato tomso ne̱ n-me̱ u̱n me̱ á? Ma-to̱ u̱m ru̱ru̱ no̱ à, be u̱n de o̱ to̱ rwu̱u̱ne̱ á, se̱ de̱ be-de o-Tato o̱ to̱ rwu̱u̱ne̱, o̱ ro̱ mo̱sse̱ n-me̱ ne̱ à, o̱ ro̱ m-no̱m m-se̱nge̱ be u̱n de à. ");
INSERT INTO uth_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","She̱r u̱nze u̱n me̱ u̱n Tato re, gaan-to̱ te̱ ro̱. U̱rege̱ ne̱ no̱ hoks m-she̱r, remen ma-u̱t re á, she̱r no̱ remen se̱nge̱-mo̱ u̱t-hyat mo̱ u̱m no̱me̱ à. ");
INSERT INTO uth_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Me̱ no̱ m-ru̱re̱ o-nip, kap wu̱ she̱re̱ u̱n me̱ à, se̱nge̱-mo̱ me̱ m-no̱m à, mo̱ mo̱ wu̱ he m-no̱m. Har ma wu̱ arag me̱, remen ha-mo̱ u̱m hette̱ be-u̱r Tato re. ");
INSERT INTO uth_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Tomso ne̱ kap bo̱n yo no̱ ko̱ne̱ u̱n jin u̱n de à, man nomo no̱ yo remen a se̱ke̱msu̱té̱ Tato re be u̱n de. ");
INSERT INTO uth_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Ko̱yan yo no̱ ko̱ne̱ u̱n jin u̱n de, man nomo no̱ yo.” ");
INSERT INTO uth_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“U̱rege̱ de̱ no̱ waste̱ u̱n me̱ ne̱, no̱a do̱re̱ karamsa-u̱t re. ");
INSERT INTO uth_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Me̱ ne̱, man kon o-Tato, wu̱ 'ye no̱ wu̱ ken Wa-u̱t-Orom wu̱ wu̱ he m-she'et be u̱n no̱ har da-o̱ ba m-ta à. ");
INSERT INTO uth_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Wu̱ wu̱ ro̱ Ku̱kt-o̱ Shir wu̱ he no̱ m-kute̱ nip-o̱ Shir. Hun-ne̱ ye̱ u̱n ho̱no o-dak, ye̱ hoks wu̱ m-go̱ks á, remen ye̱ hoks wu̱ m-hyan, har ye̱ nept wu̱ á. No̱ ne̱, no̱ nepste̱ wu̱ remen no̱ be-u̱r gaan u̱n wu̱ ne̱. Wu̱a she'et tomso ne̱ n-me̱ u̱n no̱. ");
INSERT INTO uth_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Remen kááne̱, no̱ nep u̱nze me̱ hede no̱ m-yage̱ u̱ntu̱n ko̱o̱bi-ne̱ á. Man heesu̱ne̱ be u̱n no̱. ");
INSERT INTO uth_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Ya o-da yo kuse̱ hiin, ho̱no o-dak o̱ wongu̱te̱ u̱n hyan-o re ne̱. Amba no̱ ne̱, no̱a hyen me̱, remen me̱ u̱n ho̱o̱g ne̱, no̱ komo, no̱a nom ho̱o̱g. ");
INSERT INTO uth_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Ho̱-de, no̱ he kum u̱n Ku̱kt-o̱ Shir à, ka ho̱-de o̱ no̱ he m-nap u̱nze me̱ u̱n Tato re ne̱ gaan-to̱ te̱ ro̱. Ka ho̱-de a warag no̱ gaan. ");
INSERT INTO uth_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Kap bo̱n ne̱t-wu̱ ho̱ge̱ karamsa-u̱t re, wu̱ do̱ru̱ to̱ à, wu̱ ro̱ wan-m-was u̱n me̱ ne̱. Wan-m-was u̱n me̱ ne̱ ne̱, Shir a was u̱n wu̱ ne̱. Me̱ tomso ne̱, man was u̱n wu̱ ne̱. Wu̱a hyen me̱ cas, te̱ she'ette̱ u̱n wu̱ ne̱.” ");
INSERT INTO uth_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Ka da-de Yahudas (amba yanze Yahudas Iskariyoti á) wu̱ shasu̱ru̱ wu̱. Wu̱ ze̱e̱ru̱, “Go̱s-wu̱, ¿ya hante̱ ne̱ o hette̱ rwu̱nte̱ u̱n hi u̱n du cas be u̱n te̱ cot, amba wo̱ kute̱ ho̱no o-dak á?” ");
INSERT INTO uth_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Ye̱so ze̱e̱ru̱ wu̱, “Bo̱n wu̱ wasse̱ u̱n me̱ ne̱ à, wu̱a do̱re̱ ma-u̱t re. Tato re a was u̱n wu̱ ne̱. Te̱a haan, te̱ Tato re be-de u̱n wu̱ te̱ she'et mo̱sse̱ u̱n wu̱ ne̱. ");
INSERT INTO uth_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Ne̱t-wu̱ ro̱ u̱n bo̱p u̱n ma-u̱t re á, wu̱ ro̱ m-was u̱n me̱ ne̱ o̱ ka á. Ma-to̱ no̱ ho̱ge̱ u̱n nu-o re à, ma-u̱t re to̱ á. Ma-u̱t Tato re to̱, wu̱ to̱mnu̱ me̱ à. ");
INSERT INTO uth_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Me̱ no̱ m-ru̱re̱ u̱n to̱ ka myet, u̱n ka da-o̱ me̱ be-u̱r gaan u̱n no̱ ne̱. ");
INSERT INTO uth_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Amba Wa-u̱t-Orom, Ku̱kt-o̱ Shir wu̱ Tato re he m-to̱mo̱n u̱n jin u̱n de à, wu̱ he no̱ yoose̱ u̱n ko̱yan, wu̱ baksu̱ no̱ rii-yo u̱m ru̱ru̱ no̱ à. ");
INSERT INTO uth_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","U̱m yaksu̱tu̱ no̱ gwu̱gwu̱-mo̱ u̱r-hur. Gwu̱gwu̱-mo̱ u̱r-hur mo̱ u̱m yaksu̱ no̱ à, yar-m re mo̱ u̱ntu̱n yar-mo̱ u̱n ho̱no o-dak á. Taasu̱ me̱n-u̱t no̱ naase̱ á, taasu̱ tomso ne̱ no̱ ho̱ge̱ o-gye̱r á. ");
INSERT INTO uth_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","“No̱ ho̱gu̱ssu̱te̱ de̱ u̱m ze̱e̱g me̱n neke̱ u̱m dott m-mu̱u̱n be u̱n no̱. No̱ wasse̱ u̱n me̱ ne̱, no̱a nom o-zak remen me̱ m-ha be-u̱r Tato re wu̱ jiishe̱ me̱ à. ");
INSERT INTO uth_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","To̱, m-mo̱ka u̱m ru̱ru̱tu̱ no̱ cin ba da-o u̱n wo̱o̱n remen da-o wo̱o̱ne̱ no̱ she̱re̱t. ");
INSERT INTO uth_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Me̱ hede no̱ m-ru̱re̱ u̱t-ma de̱e̱n á, remen wan-gwo̱mo-to̱ u̱n ho̱no o-dak ro̱o̱n, ko-Gwo̱mo-wu̱ u̱n ya-u̱t-ko̱t. Yatt-yo wu̱ he ne̱ hoks m-dos be u̱n de á. ");
INSERT INTO uth_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Amba remen ho̱no o-dak nept u̱nze u̱m waste̱ o-Tato ne̱, me̱ u̱n no̱m u̱n kap rii-yo Tato re ze̱e̱ à. “A ine̱ no̱ kane̱, da-o wooste̱ o̱ a hette̱ no̱ m-neke̱ à.” ");
INSERT INTO uth_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Ye̱so dooru̱ m-ze̱e̱ yan-neke̱-mo̱ u̱n wu̱, “Me̱ ro̱ 'wu̱n-de o-'yo yo o-nip. Tato re wu̱ ro̱ yo m-ma'as m-ja'as. ");
INSERT INTO uth_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Ko̱ yo ke jet-yo be-de u̱n yo, yo mate̱ á, Tato re a kups yo. Ko̱ yo ke yo ro̱ u̱r-mat à, a ro̱ yo m-ja'as remen yo ja'asté̱ u̱r-mat de̱e̱n. ");
INSERT INTO uth_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","No̱ ne̱, bo̱ an ja'as u̱n ka 'yo-yo à, ka bo̱-se ne̱ o̱ ma-u̱t re ja'ase̱ hur-u̱t no̱. ");
INSERT INTO uth_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","She'et no̱ kang-o gaan u̱n me̱ ne̱, me̱ ne̱ man she'et be u̱n no̱. Bo̱ o-jet ro̱ m-mat u̱n yakar u̱n ho̱n-de u̱n yo á, se̱ de̱ yo ro mo̱sse̱ o-'yo ne̱. Kááne̱ o̱ u̱n cen no̱, no̱a hoks no̱m u̱n rii á, se̱ no̱ she'ette̱ mo̱sse̱ u̱n me̱ ne̱. ");
INSERT INTO uth_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Me̱ ro̱ 'wu̱n-de o-'yo. No̱ ro̱ u̱s-jet. Bo̱ u̱n ne̱t-wu̱ she'ete̱ be u̱n de à, man she'et be-de u̱n wu̱, wu̱a met yakar de̱e̱n. U̱n ya mo̱sse̱ u̱n me̱ ne̱ á, no̱a hoks no̱m u̱n ko̱yan á. ");
INSERT INTO uth_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Kap ne̱t-wu̱ she'ete̱ be u̱n de á, a ruut wu̱ u̱ntu̱n bo̱ a m-kups u̱n jet-yo ba u̱r-mat á. A jore̱, a kamas go̱n ka jet-se be-u̱r gaan. Se hu̱'u̱se̱, a su se o-ra. ");
INSERT INTO uth_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Amba u̱rege̱ u̱nze no̱ she'ete̱ be u̱n de, ma-u̱t re komo, no̱ go̱kste̱ to̱, to̱, ko̱n no̱ ko̱yan, a nomu̱ no̱ yo. ");
INSERT INTO uth_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Ka bo̱-se ne̱ o̱ ka an se̱ke̱mse̱ u̱n Tato re u̱rege̱ no̱ u̱r-mat de̱e̱n. Ka bo̱-o̱ tomso no̱ he m-kute̱ u̱nze yan-neke̱-m re no̱ ro̱. ");
INSERT INTO uth_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","“Bo̱ Tato re wasse̱ u̱n me̱ ne̱ à, ka bo̱-se ne̱ o̱ u̱m wasse̱ u̱n no̱ ne̱. To̱, she'et no̱ be-de u̱n was-m re. ");
INSERT INTO uth_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","U̱rege̱ de u̱nze no̱ o-do̱ro̱tte̱ u̱n karamsa-u̱s re ne̱, man kutu̱ no̱ was-m re, bo̱ u̱m do̱re̱ ma-u̱t Tato re à, komo u̱m she'ete̱ n-me̱ u̱n was-mo̱ u̱n wu̱. ");
INSERT INTO uth_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Me̱ u̱n ru̱re̱ no̱ ká rem-se remen zak-o re she'eté̱ u̱n no̱ ne̱, komo zak-o no̱ waragté̱ shiishe̱. ");
INSERT INTO uth_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Karamsa-o re o̱ u̱nze no̱ was u̱n o̱r no̱ ne̱, bo̱ u̱m wasse̱ u̱n no̱ ne̱ à. ");
INSERT INTO uth_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Was-mo̱ jiishe̱ be-de u̱n hun-ne̱ à, mo̱ ro̱: ne̱t ya'as ho̱o̱g-o̱ u̱n wu̱ remen nay-ne̱ ye̱ u̱n wu̱. ");
INSERT INTO uth_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","No̱ nay re ne̱ ye̱ no̱ ro̱ u̱rege̱ no̱ no̱mo̱g o-do̱ro̱tte̱ u̱n ma-u̱t re ne̱ to̱ u̱m ru̱ru̱ no̱ à. ");
INSERT INTO uth_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Man do no̱ m-aag gu̱w-ne̱ á, remen ko-gu̱w-wu̱ nap me̱n-to̱ u̱n wan-hur-o̱ wu̱ á. Amba me̱ no̱ m-aag nay-ne̱ re, remen u̱m ru̱ru̱tu̱ no̱ kap rii-yo u̱m ho̱gne̱ be-u̱r Tato re à. ");
INSERT INTO uth_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","No̱ ye̱ daage̱ me̱ á, me̱ daage̱ no̱. U̱m rwo̱'o̱g no̱ he no̱ met yakar rem re, yakar-ye̱ he komo m-she'et har da-o̱ ba m-ta à. Ka da-o̱ a 'ye no̱ kap o̱ u̱n rii-yo no̱ ko̱ne̱ n-me̱ u̱n jin u̱n de à. ");
INSERT INTO uth_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Remen kááne̱, u̱m ze̱e̱g: Was no̱ u̱n o̱r no̱ ne̱!” ");
INSERT INTO uth_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“U̱rege̱ ho̱no o-dak yagu̱tu̱ no̱, no̱ baks u̱nze me̱ wu̱ o̱ ba'e̱ m-yage̱ rii-yo o̱ yagu̱tu̱ no̱. ");
INSERT INTO uth_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","No̱ rotte̱ yan-ho̱no-o-dak, ye̱ roa cu̱n no̱. Amba remen no̱ yan-ho̱no-o-dak ye̱ á, tomso ne̱ me̱ daage̱ no̱ u̱n ho̱no o-dak, o̱ hante̱ yan-ho̱no-o-dak yagu̱tu̱ no̱. ");
INSERT INTO uth_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Baks no̱ ma-to̱ u̱m ru̱re̱ no̱ à, u̱nze ko-gu̱w ro̱ m-jiish u̱n wan-hur-o̱ u̱n wu̱ á. Ye̱ rangsu̱te̱ me̱, ka bo̱-se ne̱ o̱ ye̱ he no̱ m-rangse̱ u̱n cen no̱ ne̱. Ye̱ ro do̱ru̱te̱ ma-u̱t re, ye̱ roa do̱re̱ u̱t-ma no̱. ");
INSERT INTO uth_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Ye̱a rangsu̱ no̱ kááne̱ remen jin u̱n de, remen ye̱ nap ne̱t-wu̱ to̱mne̱ me̱ á. ");
INSERT INTO uth_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Me̱ ro haante̱, u̱m nome̱ ye̱ u̱t-ma á, ye̱ roa nep ba'as-to̱ u̱n ye̱ á. Amba u̱n haan-m re ye̱tt be-de m-posse̱ be-de u̱n ba'as-to̱ u̱n ye̱ á. ");
INSERT INTO uth_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Wu̱ yage̱ me̱ à, wu̱ yagu̱te̱ Tato re ma. ");
INSERT INTO uth_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","A ro ze̱e̱ge̱ me̱ nom ka rem-se u̱t-hyat se, se ne̱t take̱ m-hyan á, ba'as-u̱r ro̱ roa bu̱p ye̱ á. Amba m-mo̱ka ye̱ hyeneste̱ rem-se u̱m nome̱ à, amba myet u̱n kááne̱ ne̱, ye̱ yagu̱tu̱ me̱ ye̱ yage̱ komo Tato re. ");
INSERT INTO uth_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","To̱, to̱ u̱n no̱m kááne̱ remen a shoosté̱ ma-to̱ ro̱ gense̱ n-me̱ u̱n Ma-to̱ Shir à u̱nze, ‘Ye̱ u̱n yage̱ me̱ ba u̱t-ma.’ ");
INSERT INTO uth_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Baks no̱ u̱nze Wa-u̱t-Orom a haan, wu̱ u̱m he no̱ m-to̱mne̱, rwu̱u̱n-mo̱ u̱n be-de o-Tato à. Ku̱kt-o̱ Shir wu̱ he m-rwu̱u̱n be-de o-Tato à, wu̱ he no̱ m-kute̱ o-nip à, wu̱ he no̱ wan-swo̱-u̱s. ");
INSERT INTO uth_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","No̱ u̱n cen no̱ ne̱, ya yan-swo̱-u̱s re ye̱, remen cin u̱r-takan u̱n se̱nge̱-m re kàne̱, no̱ mo̱sse̱ u̱n me̱ ne̱. ");
INSERT INTO uth_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Me̱n ru̱ru̱ no̱ ka ma-to̱ remen taase no̱ no̱ e̱gé̱ á. ");
INSERT INTO uth_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Ye̱a ruut no̱ u̱n kuke̱-to̱ u̱n yoos u̱n Ma-to̱ Shir. Nip-o̱ da-o ro̱o̱n o̱ ye̱ hette̱ no̱ m-ho̱ à, ye̱ hyene̱ ye̱ zee Shir-o̱ ye̱ ro̱ m-no̱me̱ u̱r-seke̱. ");
INSERT INTO uth_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Ye̱a nom kááne̱ komo remen ye̱ nap o-Tato ko̱ me̱ á. ");
INSERT INTO uth_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Me̱n ru̱ru̱ no̱ kááne̱ remen da-o̱ ka rem-se kore̱, no̱ baksté̱ u̱nze u̱m be'este̱ u̱m nekste̱ no̱ u̱t-to̱. “Me̱ ru̱ru̱ no̱ ka rem-se cin n-ga ne̱ á, remen me̱ mo̱sse̱ u̱n no̱ ne̱. ");
INSERT INTO uth_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","M-mo̱ka ne̱, me̱n warag be-de u̱n wu̱ to̱mne̱ me̱ à. Kap u̱n kááne̱ ne̱, n-me̱ u̱n no̱ yatt ne̱t-wu̱ citu̱ me̱ be-de u̱m he'e̱ á. ");
INSERT INTO uth_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Amba me̱n-u̱t naasu̱tu̱ no̱ de̱e̱n remen u̱m ru̱ru̱te̱ no̱ ka rem-se. ");
INSERT INTO uth_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Kap u̱n kááne̱ ne̱, me̱ no̱ m-ru̱re̱, nip-o̱: jiishte̱ no̱ ne̱ komo u̱m neke̱. Me̱ neke̱ á, ka Wa-u̱t-Orom wu̱ a haan be-u̱r no̱ á. Me̱ neke̱ ne̱, man to̱mo̱n wu̱ be u̱n no̱. ");
INSERT INTO uth_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Da-o̱ ka Wa-u̱t-Orom wu̱ haane̱, wu̱a kute̱ hun-ne̱ ye̱ ho̱no o-dak u̱nze barag-se u̱n ye̱ mo̱sse̱ u̱r-ba'as ne̱ hond hond se ro̱ á. Komo Shir wu̱ ro̱ kashi. Wu̱a baksu̱ ye̱ ma-to̱ u̱n piish u̱t-ma to̱ Shir tomso ne̱. ");
INSERT INTO uth_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Wu̱a kutu̱ ye̱ u̱nze ye̱ no̱mo̱g u̱r-ba'as remen ye̱ yagu̱te̱ m-she̱r be u̱n de. ");
INSERT INTO uth_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Barag-se u̱n ye̱ hond hond o̱ se ro̱ mo̱sse̱ u̱n kashi u̱r-she'et ne̱ á, remen me̱ m-warag be-u̱r Tato re. No̱a hyen me̱ komo á. ");
INSERT INTO uth_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Wu̱a kute̱ ye̱ u̱nze barag-se u̱n ye̱ hond hond o̱ be-de u̱n ma-to̱ u̱n piish u̱t-ma á, remen a komoste̱ piishe̱ u̱n ko-Gwo̱mo-wu̱ u̱n ya-u̱t-ko̱t u̱t-ma. Ka ko-Gwo̱mo-wu̱ wu̱ ro̱ wan-gwo̱mo to̱ u̱n ka ho̱no o-dak o̱. ");
INSERT INTO uth_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“U̱m ro̱'su̱ru̱ u̱t-ma ne̱ de̱e̱n to̱ u̱m he no̱ m-ru̱re̱ à tokon, amba no̱a hoks to̱ m-de̱k m-mo̱ka á. ");
INSERT INTO uth_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Da-de Ku̱kt-o̱ Shir haane̱, Wa-u̱r-Yoos de o-nip, wu̱a do̱ru̱ttu̱ no̱ be-de o-nip. Wu̱ ro̱ u̱n he de no̱ ru̱re̱ u̱t-ma be-de u̱t-gwo̱mo á. Wu̱ ro̱ u̱n he-de m-ze̱e̱ ko̱ rii, se̱ de̱ kap to̱ wu̱ ho̱ge̱ be-de Shir à, to̱ to̱ wu̱ he m-rwo̱r. Wu̱a ru̱ru̱ no̱ rem-se he m-takan à. ");
INSERT INTO uth_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Wu̱a se̱ke̱mse̱ me̱, remen ma-u̱t re to̱ wu̱ he no̱ m-hi'e̱ à. ");
INSERT INTO uth_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Kap yo ro̱ be-de o-Tato à, yo ma re yo. O̱ hante̱ u̱m zeet Ku̱kt-o̱ Shir wu̱a go̱ksu̱ne̱ yo u̱m ru̱ru̱ wu̱ à, wu̱ ru̱ru̱ no̱ u̱n ce no̱.” ");
INSERT INTO uth_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Man neku̱sse̱ tokon, amba u̱jime̱ kane̱ u̱n co hiin no̱a hyenes me̱.” ");
INSERT INTO uth_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Ye̱ ken yan-neke̱-mo̱ u̱n wu̱ ne̱ ye̱ citu̱ru̱ hi u̱n de u̱n ye̱, ye̱ zee, “¿Yan yo ne̱ ro̱ barag-se u̱n wu̱, wu̱ zeet, ‘Man neku̱sse̱ tokon, amba u̱jime̱ no̱a hyenes me̱’? ¿Ya hante̱ komo wu̱ zeet u̱m ro̱ m-ha be-de o-Tato?” ");
INSERT INTO uth_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Ye̱ ma'asu̱ru̱ m-ze̱e̱, “¿Yan yo ne̱ wu̱ barage̱ wu̱ zeet kane̱ u̱n co hiin? Ay, a nap ma-to̱ wu̱ ro̱ m-rwo̱r á.” ");
INSERT INTO uth_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Ye̱so nepste̱ ye̱ co̱no̱g wu̱ m-cit, wu̱ ze̱e̱ru̱ ye̱, “¿No̱ o̱ hoob-o̱ m-nap u̱n ma-u̱t re be-u̱r o̱r no̱ ne̱ remen u̱m ze̱e̱g u̱nze, ‘Man neku̱sse̱ tokon amba u̱jime̱ kane̱ u̱n co hiin no̱a hyenes me̱’? ");
INSERT INTO uth_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Me̱ no̱ m-ru̱re̱ o-nip, no̱a u̱nu̱s, amba ho̱no o-dak a nom o-zak. No̱ ne̱, no̱a nom naase̱-mo̱ u̱t-me̱n, se̱ de̱ naase̱-mo̱ u̱n me̱n-u̱t no̱ mo̱a warag o-zak. ");
INSERT INTO uth_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Da-de ne'a ro u̱n 'yong-se o-mat, wu̱ ro̱ u̱n hyan u̱r-ko̱o̱b de̱e̱n remen da-o̱ o-mat woosu̱nte̱ wu̱. Amba da-de wu̱ messe̱ wan-yaar-wu̱ u̱n wu̱ à, wu̱a do m-baks u̱nze wu̱ swo̱o̱g u̱r-ko̱o̱b á, remen o-zak o̱ wu̱ mette̱ wan-yaar u̱n ho̱no o-dak à. ");
INSERT INTO uth_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Ka bo̱-se o̱, no̱ u̱n cen no̱ ne̱, m-mo̱ka no̱ u̱n naase̱-mo̱ u̱t-me̱n ne̱. Amba a dos no̱ m-hyende̱. Ka da-de ne̱ o̱ me̱n-u̱t no̱ he no̱m o-mo̱k puu u̱ntu̱n u̱t-gwe̱re̱ o-zak. Yattu̱ ne̱ wu̱ he rumus u̱n zak-o no̱ á. ");
INSERT INTO uth_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Ho̱-de no̱ he kum u̱n Ku̱kt-o̱ Shir à, ka ho̱-de ne̱ no̱ he m-wu̱we̱ u̱n cot-u̱s re ne̱ remen ko̱yan a kutu̱ no̱ yo cas u̱n co-o no̱. Me̱ no̱ m-ru̱re̱ o-nip, ko̱yan yo no̱ ko̱ne̱ o-Tato u̱n be̱e̱b-de u̱n jin u̱n de, wu̱a 'ye no̱ yo. ");
INSERT INTO uth_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Har m-mo̱ka no̱ u̱n goshi ko̱n rii u̱n be̱e̱b u̱n de á. Ko̱n no̱, no̱a kum remen zak-o no̱ shiit ce̱ngce̱ng.” ");
INSERT INTO uth_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Ye̱so dooru̱ u̱t-ma u̱n yan-neke̱-mo̱ u̱n wu̱ ne̱ ne̱. Wu̱ ze̱e̱ru̱ ye̱, “Kap ka ma-to̱ me̱n ru̱ru̱ no̱ to̱ riig-m-riig u̱n sha-mo̱ u̱t-ma ne̱. Da-o ro̱o̱n o̱ me̱tté̱ a ru̱ru̱ no̱ u̱t-ma riig-m-riig á, se̱ de̱ u̱m ru̱ru̱ no̱ ma-to̱ o-Tato cas cas. ");
INSERT INTO uth_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Ho̱-de me̱ neke̱, ka ho̱-de ne̱ o̱ no̱ he m-ko̱n o-Tato u̱n jin u̱n de. Se̱ u̱m konu̱tu̱ no̱ u̱n nu-o re tomso ne̱ á, ");
INSERT INTO uth_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","remen Tato-o ro̱ u̱n was u̱n no̱ ne̱ remen no̱ waste̱ u̱n me̱ ne̱, no̱ she̱re̱g u̱nze be-de o-Tato o̱ u̱m rwu̱u̱ne̱. ");
INSERT INTO uth_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Ka o̱ ne̱ komo, be-de o-Tato u̱m rwu̱u̱ne̱, u̱m co̱wo̱nte̱ ho̱no o-dak. M-mo̱ka ne̱ komo me̱ u̱n hede o̱ m-yage̱ u̱m waragté̱ re̱e̱no̱ be-de o-Tato.” ");
INSERT INTO uth_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Yan-neke̱-mo̱ u̱n wu̱ ze̱e̱ru̱, “M-mo̱ka wo̱ u̱n rwo̱r u̱t-ma cas cas, yanze m-riig ne̱ á. ");
INSERT INTO uth_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","M-mo̱ka o̱ te̱ nape̱ u̱nze o nak ko̱yan, ko̱ te̱ citu̱ wo̱ á, o ru̱ru̱tu̱ te̱ cas cas. De de te̱ she̱rte̱ u̱nze be-de Shir-o̱ o rwu̱u̱ne̱.” ");
INSERT INTO uth_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Ye̱so ze̱e̱ru̱ ye̱, “Ashi, no̱ ro she̱re̱g á, se̱ m-mo̱ka! ");
INSERT INTO uth_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","To̱, ai, da-o ro̱o̱n, ko̱ m-mo̱ka ma o̱ nomoste̱, o̱ a hette̱ no̱ m-cakarse̱ à. Ko̱ wu̱ ke wu̱a warag u̱n hur-o̱ u̱n wu̱, no̱ yage̱ me̱ u̱n ho̱n-de. Me̱ hede m-she'etu̱ ne̱ u̱n ho̱n-de á, remen Tato re ro̱ mo̱sse̱ u̱n me̱ ne̱. ");
INSERT INTO uth_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Me̱ u̱n ru̱ru̱ no̱ ka ma-to̱ remen hur u̱n no̱ gwu̱'u̱ru̱té̱ bo̱ no̱ dape̱ me̱ à. No̱a su̱ u̱r-ko̱o̱b be-de u̱n hun-ne̱ ye̱ u̱n ho̱no o-dak amba 'mo̱ no̱ u̱r-hur! U̱m re̱e̱g u̱r-ho̱ u̱n ho̱no o-dak ne̱!” ");
INSERT INTO uth_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Bo̱ Ye̱so ru̱rte̱ kááne̱ à, wu̱ dassu̱ru̱ u̱r-hi n-To̱n shir. Wu̱ ze̱e̱ru̱, “Tato re, da-o wooste̱ o̱ o hette̱ me̱ m-se̱ke̱mse̱ à, remen me̱ u̱n cere u̱m se̱ke̱msu̱té̱ wo̱. ");
INSERT INTO uth_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","O ya'ag me̱ u̱t-gwo̱mo u̱n hi-de u̱n ko̱wan, remen u̱m ye'et ho̱o̱g-o̱ ba m-ta be-de u̱n yan-dor-ye̱ o ya'asu̱ me̱ à. ");
INSERT INTO uth_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Co̱w-yo hun-ne̱ hette̱ m-kum ho̱o̱g-o̱ ba m-ta à, yo ro̱, ye̱ nep u̱nze wo̱ wu̱ ro̱ Shir gaan, o-nip, komo ye̱ nep u̱nze me̱, Ye̱so, me̱ ro̱ Kiristi, wu̱ o to̱mne̱ à. ");
INSERT INTO uth_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","U̱m kussu̱te̱ hun-ne̱ go̱s-u̱t ru kàne̱ u̱n ho̱no o-dak remen u̱m shooste̱ se̱nge̱-mo̱ o ze̱e̱ me̱ u̱m no̱m à. ");
INSERT INTO uth_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","M-mo̱ka komo ne̱, Tato re, do me̱ m-se̱ke̱mse̱, u̱n ka se̱ke̱mse̱-mo̱ ne̱ mo̱ u̱m rotte̱ mo̱sse̱ u̱n wo̱ ne̱ à, rii-yo a nomot ho̱no o-dak. ");
INSERT INTO uth_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“U̱m rwu̱ntu̱te̱ jin u̱n du be-de u̱n hun-ne̱ ye̱ o ya'asu̱ me̱ u̱n ka ho̱no o-dak o̱ à. Ye̱ ma ru ye̱. O ya'ag me̱ ye̱ ne̱, ye̱ do̱ru̱te̱ ne̱ ma-u̱t ru. ");
INSERT INTO uth_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","M-mo̱ka ye̱ nepste̱ kap bo̱ u̱n yo o ya'asu̱ me̱ à, be u̱n du o̱ yo ro̱. ");
INSERT INTO uth_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Ma-to̱ o ru̱ru̱ me̱ ne̱ à, u̱m ru̱ru̱te̱ ye̱ to̱. Ye̱ go̱ksu̱sse̱, ye̱ nepse̱ ne̱ u̱nze be u̱n du o̱ u̱m rwu̱u̱ne̱, ye̱ she̱re̱g u̱nze wo̱ to̱mnu̱ me̱.” ");
INSERT INTO uth_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“Me̱ ne̱ ko̱n-se me̱tte̱ remen ye̱, yanze hun-ne̱ ye̱ u̱n ho̱no o-dak o̱ me̱ m-kone̱ á, se̱ de̱ remen ye̱ o ya'asu̱ me̱ à, remen ye̱ ma ru ye̱. ");
INSERT INTO uth_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Kap ye̱ ma re, ye̱ ma ru ye̱. Ye̱ ma ru komo ne̱ ye̱ ma re ye̱. A me̱ m-se̱ke̱mse̱ komo ne̱ remen ye̱. ");
INSERT INTO uth_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","M-mo̱ka tomso ne̱ u̱m ro̱be̱ be u̱n du, me̱ kus u̱r-she'et ne̱ kane̱ ho̱no o-dak á. Amba ye̱ ka, ho̱no o-dak o̱ ye̱ ro̱. Tato-o̱ ba m-Ku̱ko̱p, o 'er ye̱ u̱n be̱e̱b-de u̱n jin u̱n du, be̱e̱b-de u̱n jin-de o ya'asu̱ me̱ à, remen ye̱ she'etté̱ kang-o gaan bo̱ a gaan à. ");
INSERT INTO uth_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Kap da-de te̱ ro mo̱sse̱ be-u̱r gaan à, u̱m e̱re̱g ye̱ u̱n bu̱-yo u̱n be̱e̱b-de u̱n jin u̱n du de o ya'as me̱ à. U̱m e̱re̱g ye̱. Yatt ne̱t-wu̱ nebe̱ be-de u̱n ye̱ á, se̱ de̱ ka ko-nebesse̱ wu̱, remen a shoosté̱ Ma-to̱ Shir to̱ ro̱ gense̱ à. ");
INSERT INTO uth_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","“M-mo̱ka, u̱m ro̱be̱ be u̱n du. Me̱n rwo̱r u̱n ka ma-to̱ cin u̱m ro̱ u̱n ho̱no o-dak remen zak-o re nomot de̱e̱n bo̱ o̱ he shoos u̱n hur-de u̱n ye̱ à. ");
INSERT INTO uth_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","U̱m ru̱ru̱te̱ ye̱ ma-u̱t ru. Hun-ne̱ ye̱ u̱n ho̱no o-dak yagu̱ru̱ ye̱, remen ye̱ ba ye̱ ma ho̱no o-dak ye̱ á, u̱ntu̱n bo̱ u̱m ro̱ wu̱ ma ho̱no o-dak á. ");
INSERT INTO uth_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Me̱ u̱n ko̱n-u̱s ru, o dos ye̱ n-me̱ u̱n ho̱no o-dak á, se̱ de̱ o 'er ye̱ be-de u̱n ka wan-me̱n-u̱t jaas-to̱ wu̱. ");
INSERT INTO uth_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Ye̱, yan u̱n ho̱no o-dak ye̱ á, bo̱ u̱m ro̱ wu̱ u̱n ho̱no o-dak wu̱ á. ");
INSERT INTO uth_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Yoos ye̱ ma-u̱t ru, ro̱ to̱ nip-o̱. Muut ye̱ hun-ne̱ ye̱ ba m-ku̱ko̱p u̱n bu̱-yo u̱n nip-o ru. ");
INSERT INTO uth_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Bo̱ o to̱mnu̱ me̱ ho̱no o-dak à, ka bo̱-se ne̱ o̱, u̱n ce re, u̱m to̱me̱ ye̱ be-de u̱n hun-ne̱ ye̱ ru̱ru̱te̱ ye̱ ma-u̱t ru. ");
INSERT INTO uth_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","U̱m ya'aste̱ hi u̱n de u̱ntu̱n kashi u̱r-seke̱ de ba m-ku̱ko̱p remen ye̱. U̱m no̱mo̱g kaane̱ remen ye̱ waragté̱ ba m-ku̱ko̱p remen nip-o ru. ");
INSERT INTO uth_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Yanze remen ye̱ ka u̱n ho̱n-de u̱n ye̱ me̱tte̱ u̱n ko̱n-u̱s ru á. Me̱ wo̱ u̱s-ko̱n remen myet u̱n ye̱ ka ne̱, ye̱ she̱re̱ me̱ ne̱ à. Ka ye̱, she̱re̱ remen ye̱ ho̱gu̱te̱ ma-u̱t re be-de u̱n yan-neke̱-m re à. ");
INSERT INTO uth_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Tato re, u̱m co̱no̱g kap mo̱ u̱n ye̱, ye̱ warag gaan, bo̱ a gaan à. U̱m co̱no̱g ye̱ warag gaan u̱n na ne̱, bo̱ wo̱ n-me̱ re, komo me̱ n-me̱ ru à. Ka da-de o̱ ho̱no o-dak he m-go̱ks ma-u̱t re u̱nze wo̱ to̱mnu̱ me̱. ");
INSERT INTO uth_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Bo̱ o se̱ke̱mse̱ me̱ à, ka bo̱-se ne̱ o̱, u̱m se̱ke̱mse̱ yan-dor re, remen ye̱ she'etté̱ gaan bo̱ a gaan à. ");
INSERT INTO uth_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Me̱ be-de u̱n ye̱, wo̱ tomso ne̱ be u̱n de, remen a she'etté̱ kang-o gaan. No̱m kaane̱ remen hun-ne̱ ye̱ u̱n ho̱no o-dak nepsté̱ u̱nze wo̱ to̱mnu̱ me̱ u̱n ho̱no o-dak, komo u̱nze o wastu̱ ye̱ bo̱ o wasse̱ u̱n me̱ ne̱ à. ");
INSERT INTO uth_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Tato re, u̱m co̱no̱g ka hun-ne̱ ye̱ o ya'asu̱ me̱ à, ye̱ u̱n cen ye̱, ye̱ she'et mo̱sse̱ u̱n me̱ ne̱ ko̱ de ke be-de u̱m ro̱. Ka da-de ye̱ hyenet se̱ke̱mse̱-m re mo̱ o se̱ke̱mse̱ me̱ à, remen o co̱no̱g me̱ cin ba a u̱n no̱m ho̱no o-dak. ");
INSERT INTO uth_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","“Kashi o-Tato, hun-ne̱ ye̱ u̱n ho̱no o-dak, ye̱ nap wo̱ á, amba u̱m nepste̱ wo̱. Yan-dor re komo, ye̱ nepste̱ u̱nze wo̱ to̱mnu̱ me̱. ");
INSERT INTO uth_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","U̱m rwu̱ntu̱te̱ jin u̱n du be-de u̱n ye̱, komo man re co m-no̱m kááne̱. Me̱n no̱m kááne̱ remen bo̱ o wasse̱ u̱n me̱ ne̱ à, ye̱ ma'asté̱, u̱n cen ye̱ ne̱, m-was ne̱, komo remen u̱m she'etté̱ be-de u̱n ye̱.” ");
INSERT INTO uth_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Bo̱ Ye̱so komte̱ ko̱n-se Shir à, wu̱ argu̱ru̱ m-neke̱ u̱n yan-neke̱-mo̱ u̱n wu̱ ne̱ ha-mo̱ u̱n pesto-de u̱n bu̱r-yo o-Kidurun be-de ye̱ ro̱ m-rwu̱u̱n ye̱tte̱ m-hur m-yo à. U̱n o̱ ka riib-o̱ tuk-o̱ u̱n 'yo-se o-ze̱tun ro̱ ko̱n. Wu̱ co̱wu̱ru̱ kane̱ u̱n yan-neke̱-mo̱ u̱n wu̱ ne̱. ");
INSERT INTO uth_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Yahudas ne̱, wu̱ he wu̱ m-ya'as à, wu̱ nepste̱ ka be-de, remen Ye̱so weste̱ m-go'one̱ u̱n yan-neke̱-mo̱ u̱n wu̱ ne̱ kane̱. ");
INSERT INTO uth_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Yahudas haaru̱ be-de u̱n Gwo̱mo-ne̱ ye̱ u̱n ko̱n-se Shir u̱n Parisa-ne̱ ne̱. Wu̱ de̱knu̱ru̱ kur-de u̱n karma-ne̱ u̱n ye̱ ken yan-'er-de u̱n Pyo-o̱ Shir ye̱ ne̱. Wu̱ haanu̱ru̱ u̱n ye̱ ne̱, be-de Ye̱so ro u̱n yan-neke̱-mo̱ u̱n wu̱ ne̱ à. Ye̱ wo̱o̱nu̱ru̱ u̱n ka be-de u̱t-pitirra ne̱, u̱n gwo̱-to̱ o-ra ne̱, u̱t-magay ne̱ u̱t-kom. ");
INSERT INTO uth_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Ye̱so ne̱, wu̱ nepste̱ kap bo̱ u̱n rii-yo he wu̱ m-kum à. Wu̱ gaanu̱ru̱ co, wu̱ ze̱e̱ru̱ ye̱, “¿Wan wu̱ ne̱ no̱ o-hoob?” ");
INSERT INTO uth_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Ye̱ ze̱e̱ru̱, “Ye̱so ko-ya-o-Nazaret-wu̱.” Ye̱so ze̱e̱ru̱ ye̱, “Me̱ ka.” Yahudas ne̱, wu̱ ya'asu̱ wu̱ à, wu̱ ro eso mo̱sse̱ u̱n ye̱ ne̱. ");
INSERT INTO uth_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Bo̱ Ye̱so zette̱ ye̱, “Me̱ ka” à, ye̱ wargu̱ru̱ jim jim, ye̱ he̱e̱ru̱ n-dak. ");
INSERT INTO uth_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Ye̱so ja'asu̱ru̱ ye̱ m-cit, “¿Wan wu̱ ne̱ no̱ o-hoob?” Ye̱ ze̱e̱ru̱, “Ye̱so ko-ya-o-Nazaret-wu̱.” ");
INSERT INTO uth_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Ye̱so ze̱e̱ru̱, “U̱m ru̱ssu̱tu̱ no̱, u̱m zee, ‘Me̱ ka.’ U̱rege̱ me̱ wu̱ no̱ o-hoob, no̱ yage̱ ye̱ ka aragte̱.” ");
INSERT INTO uth_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Ye̱so u̱n rwo̱r kááne̱ remen ma-to̱ wu̱ rwo̱r à to̱ shiit u̱nze, “Shir be-de u̱n ye̱ o ya'asu̱ me̱ à, me̱ ho'os ko̱ wan-gaan á.” ");
INSERT INTO uth_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Simo̱n Bitrus ro o-magay ne̱. Wu̱ mu'usu̱ru̱ o̱, wu̱ ce̱tu̱ru̱ ko-gu̱w-wu̱ u̱n ko-Gwo̱mo-wu̱ u̱n ko̱n-se Shir. Wu̱ kupsu̱ru̱ wu̱ to̱-o̱ u̱n so̱ u̱r-re̱. Jin-de u̱n ka ko-gu̱w-wu̱ Maru̱kus. ");
INSERT INTO uth_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Bo̱ Bitrus ce̱te̱ to̱-o Maru̱kus à, Ye̱so ze̱e̱ru̱ Bitrus, “Muut ka magay-o̱ o-rwo̱po̱nte̱. ¿Wo̱ m-hyan man su̱ u̱r-ko̱o̱b de Tato re ze̱e̱ me̱ u̱m su̱ á?” ");
INSERT INTO uth_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","To̱, ka bu̱u̱g-de u̱n karma-ne̱ de u̱n wan-co o̱ u̱n ye̱ ne̱ u̱n yan-'er-de u̱n Yahuda-ne̱, ye̱ shipiru̱ Ye̱so. Ye̱ gagu̱ru̱ wu̱. ");
INSERT INTO uth_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Ye̱ neku̱ru̱ u̱n wu̱ ne̱ be-u̱r Annas u̱r-takan. Wu̱ ne̱ ko-mo̱o̱n Ke̱pas wu̱. Ke̱pas ne̱ wu̱ ro ko-Gwo̱mo-wu̱ u̱n ko̱n-se Shir be-de u̱n ko̱n-se Shir u̱n ka hak-o̱. ");
INSERT INTO uth_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Wu̱ Ke̱pas komo ne̱, wu̱ wu̱ nome̱ Yahuda-ne̱ u̱t-ma u̱nze, “Jiishtu̱ no̱ wan-gaan mer remen hun-ne̱ kap.” ");
INSERT INTO uth_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Bo̱ ye̱ neke̱te̱ u̱n Ye̱so ne̱ be-u̱r Annas à, Simo̱n Bitrus u̱n wu̱ ken ne̱ wan-neke̱-m Ye̱so do̱ru̱ru̱ jim-u̱r Ye̱so. Bo̱ ye̱ woote̱ u̱n hur-o̱ u̱n ko-Gwo̱mo-wu̱ u̱n ko̱n-se Shir à, wu̱ Bitrus ro mo̱sse̱ u̱n wu̱ ne̱ à, wu̱ co̱wu̱ru̱ har o-'wo̱o̱g mo̱sse̱ u̱n Ye̱so ne̱ remen ko-Gwo̱mo-wu̱ u̱n ko̱n-se Shir nepste̱ u̱n wu̱ ne̱. ");
INSERT INTO uth_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Bitrus e̱su̱ru̱ u̱n ish o-hur n-do̱. Se̱ wu̱ ka wan-neke̱-m Ye̱so wu̱, u̱ntu̱n nepse̱ yo wu̱ ro'e̱ be-de u̱n ko-Gwo̱mo-wu̱ u̱n ko̱n-se Shir à, wu̱ ruuru̱ n-do̱, wu̱ no̱mu̱ru̱ u̱t-ma u̱n wan-ne'a ne̱ wu̱ ro u̱n 'er-de u̱n ish à. Ka da-de ne̱, wu̱ co̱wo̱nu̱ru̱ u̱n Bitrus ne̱. ");
INSERT INTO uth_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Ká wan-ne'a-wu̱ ro u̱n 'er-de u̱n ish à, wu̱ ze̱e̱ru̱ Bitrus, “Ashi, ¿u̱n ce ru, be-de u̱n yan-neke̱-mo̱ u̱n ka ne̱t-wu̱ o ro̱ á?” Bitrus ze̱e̱ru̱ wu̱, “Ay, me̱ be-de u̱n ye̱ á.” ");
INSERT INTO uth_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Gu̱w-ne̱ ye̱ u̱n ko-Gwo̱mo-wu̱ u̱n ko̱n-se Shir u̱n yan-'er-de u̱n Pyo-o̱ Shir ne̱, ye̱ dapsu̱ru̱ o-ra remen da-de o-hu̱w o̱. Ye̱ ro eso eso, ye̱ ro m-hwo̱'o̱t o-ra mo̱sse̱ u̱n Bitrus ne̱. ");
INSERT INTO uth_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Ko-Gwo̱mo-wu̱ u̱n ko̱n-se Shir citu̱ru̱ Ye̱so ma-to̱ u̱n yan-neke̱-mo̱ u̱n wu̱ u̱n yo yoos-de u̱n wu̱ ro ye̱ ne̱ m-nome̱ à. ");
INSERT INTO uth_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Ye̱so shasu̱ru̱ Annas, “Ai, u̱m ru̱ru̱te̱ hun-ne̱ ye̱ u̱n ho̱no o-dak u̱t-ma cas. U̱m yooste̱ komo ne̱ u̱n kuke̱-to̱ atte̱ m-yoos u̱n Ma-to̱ Shir à u̱n Pyo-o̱ Shir ne̱, be-de Yahuda-ne̱ ro̱ m-mo̱rge̱ kap à. Yatt-yo u̱m rwo̱re̱ wukusse̱ á. ");
INSERT INTO uth_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","¿Remen yan o̱ wo̱tte̱ me̱ u̱s-cot? Cit ye̱ ho̱ge̱ ma-to̱ u̱m ru̱ru̱ ye̱ à cit yo u̱m ru̱ru̱ ye̱ à. Ye̱ nape̱ ma-to̱ u̱m ru̱re̱ ye̱ à.” ");
INSERT INTO uth_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Bo̱ Ye̱so ru̱rte̱ kááne̱ à, se̱ wu̱ ken ko-wa-'er-de u̱n Pyo-o̱ Shir wu̱, wu̱ ro káne̱ eso u̱n Ye̱so ne̱ à, wu̱ kanu̱ru̱ Ye̱so o-raag. Wu̱ ze̱e̱ru̱, “¿Ka bo̱-se ne̱ o̱ ka o he m-shasu̱ u̱n ko-Gwo̱mo-wu̱ u̱n ko̱n-se Shir?” ");
INSERT INTO uth_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Ye̱so ze̱e̱ru̱ wu̱, “U̱rege̱ u̱m ru̱ru̱tu̱ no̱ ma-u̱t yo̱-to̱, o cit ye̱ be-de m-ba'ase̱ à. U̱rege̱ ne̱ u̱nze hond hond o̱, me̱ ba'as á. ¿Ya hante̱ u̱n ya o kenet me̱ o-raag?” ");
INSERT INTO uth_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Annas ze̱e̱ru̱, “A neke̱ u̱n wu̱ ne̱ ka bo̱-se ne̱ gekse̱ be-u̱r Ke̱pas ko-Gwo̱mo-wu̱ u̱n ko̱n-se Shir.” ");
INSERT INTO uth_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Simo̱n Bitrus ro eso, u̱n hwo̱'o̱t o-ra. Ye̱ ze̱e̱ru̱ wu̱, “¿Wo̱ u̱n ce ru, ba be-de u̱n yan-dor ye̱ u̱n wu̱ o̱ ka o ro̱ á?” Wu̱ ze̱e̱ru̱, “Ay, me̱ be-de u̱n ye̱ á.” ");
INSERT INTO uth_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Se̱ wu̱ ken be-de u̱n gu̱w-ne̱ ye̱ u̱n ko-Gwo̱mo-wu̱ u̱n ko̱n-se Shir, baag-o̱ u̱n wu̱ Bitrus kupse̱ o-to̱ à. Wu̱ ze̱e̱ru̱, “Ashi ka, ¿me̱ hyan wo̱ mo̱sse̱ u̱n wu̱ ne̱ re̱e̱no̱ be-de u̱n Haag-o̱ u̱n 'yo-se o-Ze̱tun á?” ");
INSERT INTO uth_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Bitrus dooru̱ no̱m m-she, wu̱ ze̱e̱ru̱, “Me̱ wu̱ á.” Bo̱ wu̱ zette̱ kááne̱ à, ke̱e̱g-o̱ o-kiit kanu̱ru̱. ");
INSERT INTO uth_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Ye̱ inu̱ru̱ n-sot n-sot, ye̱ ruutu̱ru̱ Ye̱so u̱n hur-o Ke̱pas komo ye̱ heetu̱ru̱ Ye̱so u̱n ish u̱n hur-o Biratus ko-Gwamna-wu̱ o-Roma wu̱ a ya'ase̱ gwo̱mo-to̱ u̱n Yahuda-ne̱ à. Ye̱ Yahuda-ne̱ u̱n hi u̱n de u̱n ye̱, ye̱ co̱w á, remen ye̱ o-gye̱r taase ye̱ ko̱kku̱sse̱ hi u̱n de u̱n ye̱, taase rii-yo m-re̱ yo u̱n Biki-o̱ m-Pas, yo kwangu̱ ye̱ m-re̱. ");
INSERT INTO uth_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Remen kááne̱, Biratus u̱n rwu̱u̱n u̱n co-o̱ u̱n ye̱, wu̱ ze̱e̱ru̱, “¿Ya u̱n ba'as-de no̱ bu̱pte̱ ka ne̱t-wu̱?” ");
INSERT INTO uth_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Ye̱ ze̱e̱ru̱, “U̱ rotte̱ u̱nze ma-to̱ u̱r-ba'as to̱ á, te̱ roa hante̱ wu̱ be u̱n du á.” ");
INSERT INTO uth_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Biratus ze̱e̱ru̱ ye̱, “Neke̱ no̱ u̱n wu̱ ne̱ u̱n hi u̱n no̱, no̱ he no̱ piishe̱ wu̱ u̱t-ma u̱n hi u̱n no̱ bo̱ karamsa-o ze̱e̱ à.” Yahuda-ne̱ ze̱e̱ru̱ wu̱, “Ay, te̱tt gwo̱mo-to̱ u̱n piishe̱ u̱n ne̱t u̱t-ma a hoot wu̱ á.” ");
INSERT INTO uth_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Ka ma-to̱ ne̱ remen a shoosté̱ o̱ Ma-to̱ Ye̱so rwo̱re̱ à, to̱ kute̱ go̱n mar-mo̱ wu̱ he m-mar à. ");
INSERT INTO uth_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Biratus wargu̱ru̱ n-me̱ o-hur. Wu̱ agbu̱ru̱ Ye̱so, wu̱ ze̱e̱ru̱, “¿Wo̱ ro̱ ko-Gwo̱mo-wu̱ u̱n Yahuda-ne̱?” ");
INSERT INTO uth_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Ye̱so shasu̱ru̱ wu̱, “¿Ka cot-o̱ o̱ u̱n hi u̱n du o̱? ¿Ko̱ ye̱ ken ye̱ ru̱ru̱ wo̱ ma-u̱t re?” ");
INSERT INTO uth_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Biratus shasu̱ru̱ wu̱, “¿Ap, me̱ ko-Yahuda-wu̱ o̱? Ai, hun-ne̱ ru u̱n Gwo̱mo-ne̱ ye̱ u̱n ko̱n-se Shir ne̱ ye̱ hante̱ wo̱ be u̱n de. ¿Ya o no̱m?” ");
INSERT INTO uth_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Ye̱so ze̱e̱ru̱, “Gwo̱mo-u̱t re to̱ u̱n ho̱n dak-o̱ to̱ á. U̱ rotte̱ u̱nze to̱ u̱n ho̱no o-dak to̱, yan-neke̱-m re roa nom u̱r-gu̱n taase a ya'as me̱ be-de u̱n Yahuda-ne̱, yan-yage̱-u̱t re. Amba gwo̱mo-u̱t re kàne̱ o̱ to̱ ro̱ á.” ");
INSERT INTO uth_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Biratus ze̱e̱ru̱ wu̱, “¿Ko-Gwo̱mo-wu̱ o ro̱?” Ye̱so ze̱e̱ru̱ wu̱, “Bo̱ o ze̱e̱ à, me̱ ko-Gwo̱mo-wu̱. Remen kááne̱ o̱ a mette̱ me̱. Remen kááne̱ o̱ komo ne̱, u̱m co̱wo̱nte̱ ho̱no o-dak remen u̱m ru̱ru̱t o-nip. Ko̱yan co̱n-to̱ o-nip ne̱, wu̱ ro̱ u̱n raag u̱n co̱r re.” ");
INSERT INTO uth_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Biratus ze̱e̱ru̱ wu̱, “¿Ya u̱n yo ne̱ a m-ze̱e̱ o-nip?” Bo̱ wu̱ zette̱ kááne̱ à, wu̱ ja'asu̱ru̱ m-rwu̱u̱n be-de u̱n Yahuda-ne̱, wu̱ ze̱e̱ru̱ ye̱, “Me̱ de̱, me̱ hyan ba'as-de wu̱ no̱me̱ á. ");
INSERT INTO uth_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Amba no̱ u̱n o̱ ken jor-o̱ ne̱, a nome̱ Biki-o̱ m-Pas, me̱ no̱ m-ho'osbe̱ u̱n ne̱t wan-gaan wu̱ ro̱ gego à. ¿Ko̱ no̱ co̱no̱g u̱m ho'osbu̱ no̱ ko-Gwo̱mo-wu̱ u̱n Yahuda-ne̱?” ");
INSERT INTO uth_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Ye̱ 'yonsu̱ru̱ u̱s-co̱r yo̱ko̱ko̱, ye̱ zee, “Ay, wu̱ ka wu̱ á! Se̱ de̱ Barabas!” (Barabas ne̱ wan-kwu̱p-de u̱n hun-ne̱ wu̱ rowe̱.) ");
INSERT INTO uth_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Ka da-de ne̱, Biratus ze̱e̱ru̱, “A neke̱ u̱n Ye̱so ne̱. A bu'u̱ru̱ wu̱ u̱s-so̱ro̱g de̱e̱n.” ");
INSERT INTO uth_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Karma-ne̱ yeru̱ru̱ wu̱ go̱nd-o̱ u̱n yokor u̱r-hi. Ye̱ cu̱pu̱ru̱ wu̱ co̱p-o jaas-o̱ o̱ u̱t-gwo̱mo. ");
INSERT INTO uth_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Ye̱ ze̱e̱ru̱ m-ha be-de u̱n wu̱, ye̱ ro̱ m-ze̱e̱, “Ho̱o̱g ru she'et, ko-Gwo̱mo-wu̱ u̱n Yahuda-ne̱!” Ye̱ ro wu̱ u̱n hwo̱o̱ge̱ u̱t-raag. ");
INSERT INTO uth_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Biratus dooru̱ m-rwu̱u̱n, wu̱ ze̱e̱ru̱ ye̱, “Gwo̱t no̱, wu̱ ka u̱m he no̱ m-rwu̱nte̱ remen no̱ nept u̱nze me̱ kum wu̱ u̱n de ken ba'as-de ne̱ á.” ");
INSERT INTO uth_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Ka da-de ne̱ Ye̱so rwu̱u̱nu̱ru̱ eso u̱n go̱nd-o̱ u̱n yokor ne̱ u̱n co̱p-o jaas-o̱ ne̱. Biratus ze̱e̱ru̱ ye̱, “To̱, wu̱ ka.” ");
INSERT INTO uth_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Bo̱ Gwo̱mo-ne̱ ye̱ u̱n ko̱n-se Shir u̱n do̱ro̱g-ne̱ ne̱ yan-'er-de u̱n Pyo-o̱ Shir hyente̱ wu̱ à, ye̱ 'yonsu̱ru̱ u̱s-co̱r yo̱ko̱ko̱. Ye̱ ro̱ m-ze̱e̱, “A kem wu̱ o-kan! A kem wu̱ o-kan!” Biratus ze̱e̱ru̱ ye̱, “Neke̱ no̱ u̱n hi u̱n no̱, no̱ he no̱ kem wu̱. Amba me̱ hyan wu̱ u̱n de ken ba'as-de ne̱ á!” ");
INSERT INTO uth_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Yahuda-ne̱ shasu̱ru̱, “Ai, te̱ ro̱ o-karamsa ne̱. Ka karamsa-o̱ ne̱ depete̱ a ho wu̱ remen wu̱ muute̱ hi u̱n de u̱n wu̱ Wà-wu̱ Shir.” ");
INSERT INTO uth_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Bo̱ Biratus ho̱gu̱te̱ ka ma-to̱ à, wu̱ ja'asu̱ru̱ ho̱ge̱ o-gye̱r. ");
INSERT INTO uth_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Wu̱ wargu̱ru̱ m-co̱w u̱n pyo u̱n Ye̱so ne̱. Wu̱ ze̱e̱ru̱ Ye̱so, “¿Ke ne̱ o̱ ne̱ o rwu̱u̱n?” Amba Ye̱so shas wu̱ á. ");
INSERT INTO uth_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Remen Ye̱so yagu̱te̱ wu̱ m-shas, Biratus ze̱e̱ru̱ Ye̱so, “¿Wo̱a shes me̱ u̱t-ma á? ¿Wo̱ nap u̱nze me̱ u̱r-be̱e̱b ne̱ de u̱n ho'os-m ru á, me̱ tomso ne̱ u̱r-be̱e̱b ne̱ de u̱n kam-m ru o-kan á?” ");
INSERT INTO uth_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Ye̱so ze̱e̱ru̱ wu̱, “Wo̱tt de ken be̱e̱b-de be u̱n de á, yade̱ u̱rege̱ u̱nze Shir-ye̱ ya'anu̱ wo̱ de rwu̱u̱n-mo̱ n-to̱n á. Remen kááne̱ ne̱t-wu̱ hante̱ me̱ be u̱n du à, ba'as-de u̱n wu̱ jiishte̱ ba'as u̱n du.” ");
INSERT INTO uth_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Bo̱ Biratus, ho̱ge̱ kááne̱ à, wu̱ ho̱o̱bu̱ru̱ co̱w-yo wu̱ ho'osté̱ wu̱. Yahuda-ne̱ ja'asu̱ru̱ 'yons u̱s-co̱r yo̱ko̱ko̱. Ye̱ ro̱ m-ze̱e̱, “U̱rege̱ de̱ o ho'oste̱ wu̱ ka, wo̱ co̱n ko-Gwo̱mo Sisar o̱ ka á. Ai, bo̱ u̱n wu̱ musse̱ hi u̱n de u̱n wu̱ ko-Gwo̱mo à, wu̱ yagu̱te̱ Sisar u̱t-yage̱ o̱ ka.” ");
INSERT INTO uth_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Bo̱ Biratus ho̱gu̱te̱ ka ma-to̱ à, wu̱ rwu̱u̱nu̱ru̱ u̱n Ye̱so ne̱. Wu̱ she'etu̱ru̱ u̱n kwu̱u̱r-o̱ u̱n piish u̱t-ma. Ka kwu̱u̱r-o̱ ro̱ n-to̱n u̱n “Gon o̱ a go̱ne̱ u̱t-ta'ar à,” o̱ ye̱ ro̱ m-ze̱e̱ o-Gabbata à, u̱n rem-de u̱t-Ibra à. ");
INSERT INTO uth_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Ka ho̱-de ne̱, ho̱-de m-zo̱nge̱ de remen Biki-o̱ m-Pas. Ho̱-u̱r ro̱ u̱r-hi, wu̱ ze̱e̱ru̱ Yahuda-ne̱, “Ko-Gwo̱mo no̱ wu̱ ka!” ");
INSERT INTO uth_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Ye̱ ja'asu̱ru̱ 'yons u̱s-kan yo̱ko̱ko̱. Ye̱ ro̱ m-ze̱e̱, “A nom u̱n wu̱ ne̱! A nom u̱n wu̱ ne̱! A kem wu̱ o-kan!” Biratus ze̱e̱ru̱, “¿A kem ko-Gwo̱mo no̱ o-kan?” Gwo̱mo-ne̱ ye̱ u̱n ko̱n-se Shir ye̱ ze̱e̱ru̱ wu̱, “Ai, te̱tt ko-Gwo̱mo á, se̱ Sisar.” ");
INSERT INTO uth_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Ka da-de ne̱, wu̱ ya'asu̱ru̱ Ye̱so be-de u̱n ye̱, ye̱ kemet wu̱ o-kan. ");
INSERT INTO uth_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Ye̱ neku̱ru̱ u̱n Ye̱so ne̱. Ye̱so de̱ku̱ru̱ kan-o̱ a hette̱ wu̱ m-kam à, ha-mo̱ u̱n be-de a m-ze̱e̱ Caar-o̱ u̱t-hi à (u̱t-Ibra ne̱ ye̱ ro̱ o̱ m-ze̱e̱, o-Gorogota). ");
INSERT INTO uth_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Kane̱ o̱, ye̱ kame̱ wu̱ o-kan. A kamag ne̱n yoor tomso ne̱, Ye̱so dooru̱ ye̱ tet, wan-gaan u̱n kom-o̱ u̱r-kwanta, wan-gaan u̱n kom-o̱ u̱r-re̱. Ye̱so ro̱ u̱n te̱te̱-o̱ u̱n ye̱. ");
INSERT INTO uth_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Biratus ge̱nu̱ru̱ m-ge̱n, wu̱ kamu̱ru̱ n-te̱ o-kan o̱ a kemte̱ Ye̱so à. Rii-yo wu̱ ge̱ne̱ à, yo ka u̱nze, “Ye̱so wu̱ o-Nazaret, ko-Gwo̱mo-wu̱ u̱n Yahuda-ne̱.” ");
INSERT INTO uth_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Ka ge̱n-mo̱ a kemte̱ Ye̱so à, Yahuda-ne̱ karantu̱te̱ mo̱ de̱e̱n remen be-de a kame̱ Ye̱so à, yow yow o-bo̱ ne̱ o̱. A ge̱ne̱g to̱ u̱t-Ibra, u̱t-Roma ne̱, u̱t-Girik ne̱. ");
INSERT INTO uth_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Gwo̱mo-ne̱ ye̱ u̱n ko̱n-se Shir haaru̱ be-u̱r Biratus. Ye̱ ze̱e̱ru̱ Biratus, “Tasse o gen ‘Ko-Gwo̱mo-wu̱ u̱n Yahuda-ne̱’ á, se̱ de̱ o gen ‘Kà ne̱t-wu̱ ze̱e̱g hi u̱n de u̱n wu̱ ko-Gwo̱mo-wu̱ u̱n Yahuda-ne̱.’ ” ");
INSERT INTO uth_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Biratus shasu̱ru̱, “Ai, rii-yo u̱m ge̱ne̱ à, u̱m ge̱ne̱g o̱ ká.” ");
INSERT INTO uth_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Bo̱ karma-ne̱ komte̱ kam u̱n Ye̱so o-kan à, ye̱ wongu̱ru̱ co̱p-to̱ u̱n wu̱r-o̱ u̱n wu̱. Ye̱ coogu̱ru̱ to̱ kwu̱ku̱r-u̱t nass. Ko̱ wu̱ ke ko-karma-wu̱, wu̱ de̱ku̱ru̱ kwu̱ku̱r-u̱r gaan. Ye̱ de̱ku̱ru̱ matuku-de u̱n wu̱. Ka matuku-de ne̱ komo, de u̱n wa-u̱r-gaan de u̱n ho̱n-de u̱n de. ");
INSERT INTO uth_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Ye̱ ze̱e̱ru̱ hi u̱n de u̱n ye̱, “Taase a yoog-de, se̱ de̱ a nom no̱ o-gwambe̱, a gu̱t ne̱t-wu̱ he de m-re̱ à. Wu̱ re̱ ne̱ à, wu̱ wu̱ ro̱ wa-u̱r-matuku.” An no̱m kááne̱ remen a shoosté̱ rii-yo a ge̱ne̱ n-me̱ Ma-to̱ Shir à, u̱nze, “Ye̱ wongu̱te̱ hi u̱n de u̱n ye̱ co̱p-u̱t re. Matuku u̱n de ne̱, ye̱ no̱mu̱ru̱ o-gwambe̱ u̱n de.” Ka bo̱-se ne̱ ka karma-ne̱ ye̱ no̱me̱. ");
INSERT INTO uth_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","To̱, yow yow u̱n be-de a kame̱ Ye̱so o-kan à, inu Ye̱so u̱n hen-ne̱ inu u̱n wu̱ ne̱, Meri ne̱ ne'a Kiro̱go̱s, Meri Magu̱darin wu̱, ye̱ ro eso eso. ");
INSERT INTO uth_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Bo̱ Ye̱so hyente̱ inu u̱n wu̱ káne̱ à, u̱n wan-gaan ne̱ be-de yan-neke̱-mo̱ u̱n wu̱, u̱n wu̱ wu̱ ro m-co̱n ne̱ à, yow yow u̱n wu̱ ne̱. Wu̱ ze̱e̱ru̱ inu-o u̱n wu̱, “Inu, wu̱ ka waragte̱ caane̱ wà ru.” ");
INSERT INTO uth_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Ka da-de ne̱, wu̱ ze̱e̱ru̱ wan-neke̱-mo̱ u̱n wu̱, “Wu̱ ro̱ inu ru.” Cin bo̱ u̱n ka da-de ne̱, ka wan-neke̱-mo̱ u̱n wu̱ wu̱ de̱ku̱ru̱ wu̱, wu̱ jitu̱ru̱ wu̱ u̱n hur-o̱ u̱n wu̱. ");
INSERT INTO uth_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Bo̱ u̱n rwo̱r u̱n ka ma-to̱ Ye̱so nepse̱ a komoste̱ ko̱yan, se̱ de̱ remen a shoosté̱ ma-to̱ a ge̱ne̱ be-de u̱n Ma-to̱ Shir à, ka da-de ne̱, wu̱ ze̱e̱ru̱, “Me̱ u̱n ho̱ge̱ o-swo̱o̱t o̱ m-ho̱.” ");
INSERT INTO uth_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","De ken gora-de ro kon shoosse̱ u̱n ho̱-mo̱ o-zambo ne̱ káne̱. Ye̱ mu̱su̱ru̱ o-po̱o̱g u̱n ho̱-mo̱ o-zambo, ye̱ co̱pu̱ru̱ ka po̱o̱g-o̱ n-te̱ o-kang, ye̱ tabbu̱ru̱ u̱n nu-o̱ u̱n wu̱. ");
INSERT INTO uth_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Bo̱ Ye̱so su̱u̱te̱ ka ho̱-mo̱ o-zambo mo̱ à, wu̱ ze̱e̱ru̱, “A komoste̱ ko̱yan.” Ka da-de ne̱, wu̱ kwu̱msu̱ru̱ u̱r-hi n-dak, wu̱ argu̱ m-mar. ");
INSERT INTO uth_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","U̱ntu̱ ro ka ho̱-de, ho̱-de m-zo̱nge̱ remen Biki-o̱ m-Pas de komo ne̱ taase a yage̱ u-to̱ u̱n ye̱ n-te̱ o-kan kemo Ho̱-de u̱r-Wu̱we̱ à, remen ka Ho̱-de u̱r-Wu̱we̱ de ho̱-u̱r go̱s-de de. Yahuda-ne̱ ko̱nu̱ru̱ Biratus a jetem na-se u̱n ye̱, ye̱ meret ho̱r-m-ho̱r a ju̱kt ye̱. ");
INSERT INTO uth_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Karma-ne̱ haanu̱ru̱, ye̱ jetemsu̱ru̱ na-se u̱n ka ne̱n yoor-ye̱ ye̱ a kame̱ u̱n Ye̱so ne̱ à. ");
INSERT INTO uth_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Bo̱ ye̱ wo̱o̱nte̱ be-u̱r Ye̱so à, ye̱ 'wo̱ss wu̱ be'essu̱te̱ wu̱ mereste̱. Ye̱ jet na-se u̱n wu̱ á. ");
INSERT INTO uth_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Se̱ de̱ wan-gaan be-de u̱n ka karma-ne̱ ye̱, wu̱ duuru̱ wu̱ o-tak n-te̱ n-ge̱n. Hyó-m rwu̱u̱nu̱ru̱ m-ho̱ ne̱. ");
INSERT INTO uth_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","(Ne̱t-wu̱ hyane̱ à, wu̱ no̱mu̱ru̱ swo̱-se u̱n ka ma-to̱ remen no̱ sheret u̱n ce u̱n no̱ ne̱. Ka swo̱-se ne̱ nip-o̱. Wu̱ nepste̱ komo ne̱ nip-o̱ wu̱ ro̱ m-rwo̱r.) ");
INSERT INTO uth_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","An no̱m kááne̱, remen a shoosté̱ Ma-to̱ Shir u̱nze, “Ko̱ caar-yo u̱n wu̱ o-gaan a he de yo m-jet á.” ");
INSERT INTO uth_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","N-me̱ u̱n de ken be-de u̱n Ma-to̱ Shir to̱ ze̱e̱g, “Ka ne̱t-wu̱ wu̱ ye̱ duu à, ye̱a gwo̱t wu̱.” ");
INSERT INTO uth_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Ka da-de ne̱, Yusuhu wu̱ o-Aramatiya wu̱ ro wan-neke̱-m Ye̱so wukusse̱ remen gye̱r-o̱ u̱n Yahuda-ne̱ à, wu̱ ko̱nu̱ru̱ Biratus co̱w-yo wu̱ dekt u-u̱r Ye̱so. Biratus ya'u̱ru̱ wu̱ o-co̱w. Wu̱ de̱ku̱ru̱ u-u̱r Ye̱so. ");
INSERT INTO uth_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Neko̱dimu komo ne̱, ne̱t-wu̱ haane̱ haan-mo̱ u̱r-takan m-te̱t be-u̱r Ye̱so à. Wu̱ haanu̱ru̱ u̱t-po̱'o̱g ne̱ to̱ u̱n 'yo-se m-shi'igin se a m-aag u̱s-mur à, u̱n to̱ ken to̱ ne̱ to̱ a m-aag arro à, ku̱tu̱kse̱ u̱n rigiza-o gaan. ");
INSERT INTO uth_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Ye̱ de̱ku̱ru̱ u-u̱r Ye̱so, ye̱ yeru̱ru̱ de u̱n gund-u̱r pus-de mo̱sse̱ u̱n ka rii-yo m-shi'igin to̱ ne̱ bo̱ Yahuda-ne̱ ro̱ m-no̱m da-o̱ u̱n du̱k à. ");
INSERT INTO uth_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Be-de a kame̱ Ye̱so o-kan à, de ken wak-de u̱s-'yo de ro kon, yo hun-ne̱ ro̱tte̱ m-hur m-yo à. Ka wak-de ne̱ saag ro kon kane̱ o-pu̱ o̱, o̱ a take̱ he̱'e̱dbe̱ u̱n ne̱t u̱n o̱ á. Pak-o̱ o-ta'ar o̱. O̱ wooste̱ kuke̱-u̱r re̱k-de de o-kur. ");
INSERT INTO uth_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","U̱ntu̱ ro ho̱-de u̱t-zo̱nge̱ de remen Biki-o̱ m-Pas o̱ u̱n Yahuda-ne̱ de à, komo ne̱ saag ro yow yow u̱n káne̱ ne̱ u̱n ka be-de a kemte̱ Ye̱so ne̱ o-kan à, ye̱ neksu̱ru̱ Ye̱so káne̱. ");
INSERT INTO uth_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Ho̱-de o-Rahadi, Meri Magu̱darin haaru̱ u̱n saag te̱t-m-te̱t. Wu̱ hyanu̱ru̱ a dosste̱ o-ta'ar u̱n ish u̱n saag. ");
INSERT INTO uth_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Wu̱ so̱mnu̱ru̱ o-rek be-u̱r Simo̱n Bitrus u̱n ka wan-neke̱-m Ye̱so wu̱ ne̱, wu̱ Ye̱so ro m-was u̱n wu̱ ne̱ à. Wu̱ ze̱e̱ru̱, “A dekste̱ u-u̱r Go̱s-wu̱ u̱n saag. Te̱ napu̱ ne̱ be-de a heete̱ de á.” ");
INSERT INTO uth_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Se̱ Bitrus u̱n ka wan-neke̱-m Ye̱so wu̱ ne̱, wu̱ Ye̱so ro m-was u̱n wu̱ ne̱ à, ye̱ ruuru̱, ye̱ ro̱ u̱n kaw u̱n saag. ");
INSERT INTO uth_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Kap mo̱ u̱n ye̱ yoor-ye̱ ruuru̱ u̱s-rek. Ka wan-gaan-wu̱, wu̱ Ye̱so ro m-was u̱n wu̱ ne̱ à, wu̱ taku̱ru̱ Bitrus co. Wu̱ ba'u̱ru̱ wu̱ m-wo̱ be-de u̱n saag. ");
INSERT INTO uth_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Wu̱ kaktu̱ru̱, wu̱ ro̱ m-se̱gbe̱ n-me̱. Wu̱ hyanu̱ru̱ ka gund-o pus-o̱ o̱, o̱ a ho̱kke̱ u-u̱r Ye̱so à, o̱ ro̱ e̱sse̱. Wu̱ ne̱ wu̱ co̱w á. ");
INSERT INTO uth_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Ka da-de ne̱, Simo̱n Bitrus wo̱o̱nu̱ru̱ u̱n n-jim de u̱n wu̱, wu̱ co̱wu̱ru̱ u̱n saag. Wu̱ hyanu̱ru̱ ka gund-o pus-o̱ o̱ e̱sse̱. ");
INSERT INTO uth_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","O̱ ro̱ mo̱sse̱ u̱n ka gund-u̱r pus-de de ne̱ de a ro yeru̱te̱ Ye̱so u̱r-hi à. Ka gund-de pussu̱ru̱ u̱n hi u̱n de u̱n de, de yage̱ ká gund-o̱ u̱n ju̱k-o̱ u̱n ho̱n. ");
INSERT INTO uth_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Se̱ ka wu̱ Ye̱so ro u̱n was à, wu̱ ba'e̱ m-wo̱ u̱n saag à, wu̱ co̱wu̱ru̱ u̱n ce u̱n wu̱ ne̱. Wu̱ hyanu̱ru̱, wu̱ she̱ru̱ru̱ u̱nze Ye̱so inu̱te̱ u̱n ho̱o̱g ne̱. ");
INSERT INTO uth_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Ye̱ ro nak u̱nze Ma-to̱ Shir ro̱ gense̱ u̱nze wu̱a ine̱ u̱n ho̱o̱g ne̱ á. ");
INSERT INTO uth_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Ká yan-neke̱-m Ye̱so ye̱ ne̱n yoor-ye̱ argu̱ jo o-hur. ");
INSERT INTO uth_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Meri ro eso u̱n ish u̱n saag u̱s-'wo̱n. Wu̱ ro̱ u̱n ka 'wo̱n-se, wu̱ kaktu̱ru̱, wu̱ se̱gbu̱ru̱ ish u̱n saag. ");
INSERT INTO uth_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Wu̱ 'wo̱ssu̱ru̱ yan-to̱m-ye̱ Shir ne̱n yoor u̱n cu̱p-to̱ u̱n gund-u̱t pus-to̱ ne̱ tara be-de u-u̱r Ye̱so ro'e̱ ru̱sse̱ à, wan-gaan so̱ u̱r-hi, wan-gaanu̱ ne̱ so̱ u̱s-na. ");
INSERT INTO uth_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Ka yan-to̱m-ye̱ Shir ye̱, ye̱ citu̱ru̱ Meri, “¿Remen yan o̱ wo̱tte̱ u̱s-'wo̱n?” Wu̱ ze̱e̱ru̱ ye̱, “Ai, a dekste̱ Go̱s-wu̱ re, me̱ napu̱ ne̱ be-de a heete̱ wu̱ á.” ");
INSERT INTO uth_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Bo̱ wu̱ ru̱rte̱ kááne̱ à, wu̱ byandu̱ru̱, wu̱ 'wo̱s Ye̱so wu̱ ka eso. Amba wu̱ nap u̱nze Ye̱so wu̱ á. ");
INSERT INTO uth_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Ye̱so citu̱ru̱ wu̱, “¿Ne'a, remen yan o̱ wo̱tte̱ u̱s-'wo̱n? ¿Wan wu̱ ne̱ wo̱ o-hoob?” Meri ro̱ o-gwo̱t wu̱ hyene̱ wu̱ zee wa-o-kat-wu̱ cite̱ wu̱, wu̱ ze̱e̱ru̱ wu̱. “Gye̱r Shir, u̱rege̱ wo̱ de̱ke̱ wu̱, o ru̱ru̱ me̱ be-de o e̱sse̱ wu̱ à, u̱m dekt wu̱.” ");
INSERT INTO uth_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Ye̱so ze̱e̱ru̱ wu̱, “Meri.” Wu̱ ze̱e̱ru̱ u̱t-Ibra, “Rabbo̱ni!” (U̱nze Wa-u̱r-Yoos). ");
INSERT INTO uth_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Ye̱so ze̱e̱ru̱ wu̱, “Wo̱ bo̱p me̱ á, har m-mo̱ka me̱ u̱n go̱ da be-u̱r Tato re á tokon. Se̱ de̱ o neke̱ be-u̱r o̱r re ne̱, o ru̱ru̱ ye̱ u̱nze man de be-u̱r Tato re, komo ne̱ Tat no̱, Shir re wu̱ ro̱, komo ne̱ Shir no̱.” ");
INSERT INTO uth_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Se̱ Meri Magu̱darin wu̱ haaru̱, wu̱ ze̱e̱ru̱ yan-neke̱-m Ye̱so, “U̱m hyanag Go̱s-wu̱!” Komo wu̱ ru̱ru̱ ye̱ ma-to̱ Ye̱so ru̱ru̱ wu̱ à. ");
INSERT INTO uth_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Ka de u̱r-ryot, ká ho̱-de o-Rahadi de, ish-se u̱t-kuke̱ se u̱n yan-neke̱-m Ye̱so, ro tigu̱sse̱, remen u̱n gye̱r-o̱ u̱n yan-co o̱ u̱n Yahuda-ne̱. Se̱ Ye̱so wu̱ wo̱o̱nu̱ru̱, wu̱ e̱su̱ru̱ n-te̱te̱ o̱ u̱n ye̱, wu̱ ze̱e̱ru̱, “M-gwu̱gwu̱ be u̱n no̱!” ");
INSERT INTO uth_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Bo̱ wu̱ zette̱ kááne̱ à, wu̱ kutu̱ru̱ ye̱ u̱t-kom u̱n ge̱n-yo u̱n wu̱ ne̱. Yan-neke̱-mo̱ u̱n wu̱ no̱mu̱ru̱ zak-o̱ u̱n hyan-mo̱ u̱n wu̱. ");
INSERT INTO uth_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Ye̱so dooru̱ m-ze̱e̱, “M-gwu̱gwu̱ be u̱n no̱! Bo̱ Tato re to̱mne̱ me̱ à, ka bo̱-se ne̱, o̱ u̱m to̱me̱ no̱.” ");
INSERT INTO uth_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Bo̱ wu̱ ru̱rte̱ kááne̱ à, wu̱ huru̱ru̱ ye̱ Ku̱kt-o̱ Shir. Wu̱ ze̱e̱ru̱ ye̱, “Go̱ks no̱ Yo-mo̱ u̱n Ku̱kt-o̱ Shir. ");
INSERT INTO uth_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Kap bo̱ u̱n ye̱ no̱ sokse̱ ba'as-to̱ u̱n ye̱ à, Shir soksu̱te̱ ye̱ to̱. Ye̱ no̱ sokse̱ ne̱ ba'as-to̱ u̱n ye̱ á, Shir sokse̱ ye̱ to̱ á.” ");
INSERT INTO uth_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Da-de Ye̱so haane̱ be-de yan-neke̱-mo̱ u̱n wu̱ à, Tomas ro mo̱sse̱ u̱n ye̱ ne̱ á. Tomas ro̱ wan-gaan be-de u̱n ka ne̱n o̱p u̱n yoor-ye̱, (wu̱ a m-aag ko-Pe̱se̱ à). ");
INSERT INTO uth_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Ye̱ ken yan-neke̱-m Ye̱so ye̱, ye̱ ze̱e̱ru̱ wu̱. “Te̱ hyanag Go̱s-wu̱ na!” Amba wu̱ ze̱e̱ru̱, “U̱n ya u̱m hyanag wu-yo o-kusa u̱n kom-to̱ u̱n wu̱, u̱m ru̱ o-jow u̱n yo á, u̱m ru̱ tomso ne̱ kom-o re u̱n riib-o̱ u̱n ge̱n-ye̱ u̱n wu̱ á, man she̱r á.” ");
INSERT INTO uth_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Bo̱ a rewu̱te̱ ho̱-u̱t eer à, yan-neke̱-mo̱ u̱n wu̱ ro o-hur mo̱sse̱ u̱n Tomas ne̱. Ye̱ tigu̱sse̱ u̱s-ish. Ye̱so haanu̱ru̱, wu̱ e̱su̱ru̱ n-te̱te̱ o̱ u̱n ye̱. Wu̱ ze̱e̱ru̱, “Sarru̱ma-o no̱!” ");
INSERT INTO uth_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Wu̱ ze̱e̱ru̱ Tomas, “Rwo̱ jow-o ru kàne̱, o gu̱t kom-o re. Tapan kom-o ru kàne̱ komo ne̱ o ci ge̱n-o re. Taase o she'et wan-ko̱o̱b-de m-she̱r á, amba she̱r u̱nze me̱ m-ho̱o̱g ne̱ komo.” ");
INSERT INTO uth_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tomas shasu̱ru̱, wu̱ ze̱e̱ru̱, “Go̱s-wu̱ re! Shir re!” ");
INSERT INTO uth_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Ka da-de ne̱, Ye̱so ze̱e̱ru̱ wu̱, “¿Remen o hyanag me̱ o̱ hante̱ o she̱rte̱? Ya-o-kwu̱m-ye̱, ye̱ hyane̱ me̱ á, amba ye̱ she̱re̱g.” ");
INSERT INTO uth_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Ye̱so no̱mo̱g rem-se u̱t-hyat de̱e̱n u̱n ho̱n-n-ho̱n u̱n yish-ye̱ u̱n yan-neke̱-mo̱ u̱n wu̱ se a ge̱ne̱ u̱n ka taku̱rda-o̱ á. ");
INSERT INTO uth_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Amba me̱n ge̱n to̱ ka remen no̱ she̱re̱t Ye̱so wu̱ ro̱ Kiristi, Wà-wu̱ Shir, no̱ kumut ho̱o̱g no̱ she̱re̱ u̱n jin-de u̱n wu̱. ");
INSERT INTO uth_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Ka da-de ne̱, Ye̱so rwu̱u̱nu̱ru̱ be-de yan-neke̱-mo̱ u̱n wu̱ komo, n-riib u̱n Mar-o̱ o-Gariri. Ka bo̱-se ne̱, o̱ wu̱ rwu̱nte̱ hi u̱n de u̱n wu̱. ");
INSERT INTO uth_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Simo̱n Bitrus ne̱ u̱n Tomas (wu̱ a m-ze̱e̱ ko-Pe̱se̱ à), u̱n Nataniyar ne̱ (ko-wa-o-Kana dak-o̱ o-Gariri), u̱n yakar ne̱ ye̱ ma Ze̱be̱di, u̱n ye̱ ken yan-neke̱-mo̱ u̱n wu̱ ye̱ ne̱ ne̱n yoor, kap mo̱ u̱n ye̱ ye̱ ro mo̱sse̱. ");
INSERT INTO uth_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simo̱n Bitrus ze̱e̱ru̱ ye̱, “Me̱n ha ship u̱n jan.” Ye̱ ze̱e̱ru̱ wu̱, “Ko̱ te̱ te̱a do̱ru̱ wo̱.” Ye̱ ruuru̱. Ye̱ he̱bu̱ru̱ m-ho̱ o-hat ne̱. Amba ye̱ hoks ship u̱n rii u̱n ka te̱t-mo̱ á. ");
INSERT INTO uth_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","So̱ u̱n gas-o̱ u̱n ish, ye̱ ro̱ n-me̱ o-mar, ye̱ hyanbu̱ru̱ ne̱t-wu̱ ka eso n-riib, amba ye̱ nap u̱nze Ye̱so wu̱ á. ");
INSERT INTO uth_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Ye̱so ze̱e̱ru̱ ye̱, “Yan-yen-de ne̱, ¿ko̱ no̱ ho̱o̱g jan?” Ye̱ shasu̱ru̱ wu̱, “Ay.” ");
INSERT INTO uth_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Wu̱ ze̱e̱ru̱ ye̱, “Jorbu̱ no̱ o-yo u̱n kom-o̱ u̱r-re̱ de o-hat. No̱a kum jan.” Ye̱ jorbu̱ru̱ o-yo n-te̱ m-ho̱ har ye̱ hoks m-nakan á, remen mo̱o̱r-to̱ u̱n jan. ");
INSERT INTO uth_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Se̱ ka wan-neke̱-mo̱ u̱n wu̱ mo̱ wu̱, wu̱ Ye̱so ro m-was u̱n wu̱ ne̱ à, wu̱ ze̱e̱ru̱ Bitrus, “Go̱s-wu̱ na wu̱ hwaa!” Bo̱ Simo̱n Bitrus ho̱gu̱te̱ u̱nze Go̱s-wu̱ wu̱ u̱n ye̱ wu̱ à, wu̱ co̱pu̱ru̱ co̱p-o̱ u̱n wu̱ remen wu̱ ro possu̱ssu̱te̱ co̱p-o̱ u̱n wu̱ da-de wu̱ ro'e̱ m-se̱nge̱, wu̱ 'he̱bu̱te̱ o-mar à. ");
INSERT INTO uth_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Ye̱ ka yan-neke̱-mo̱ u̱n wu̱ ye̱, ye̱ kuse̱ n-me̱ o-hat à, ye̱ ro n-me̱ u̱n jan ne̱ doro doro remen ye̱tt u̱r-hew o-riib ne̱ á. Hew-de u̱n ye̱ n-riib m-ho̱ ne̱ u̱s-na zungu-u̱s tet-se. ");
INSERT INTO uth_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Bo̱ u̱n rwu̱u̱n-mo̱ u̱n ye̱ o-zang, ye̱ 'wo̱ssu̱ru̱ eng-to̱ o-ra o-jan ne̱ n-to̱n kane̱, komo buro̱di-u̱r ro kon kane̱. ");
INSERT INTO uth_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Ye̱so ze̱e̱ru̱ ye̱, “Hante̱ no̱ ye̱ ken jan-ye̱ be-de u̱n ye̱ no̱ bo̱pne̱ m-mo̱ka à.” ");
INSERT INTO uth_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Simo̱n Bitrus co̱wu̱ru̱ o-hat, wu̱ naknu̱ru̱ o-yo shoosse̱ u̱n jan-ne̱ nu̱-ye̱ nu̱-ye̱ zungu-o gaan u̱n kwo̱o̱z-u̱t yoor u̱n o̱p u̱n tet 153. Amba kap u̱n nu̱-se u̱n ka jan-ye̱ ne̱ ka yo-o̱ o̱ yooge̱ á. ");
INSERT INTO uth_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Ye̱so ze̱e̱ru̱ ye̱, “Haan no̱, no̱ beks.” Be-de yan-neke̱-mo̱ u̱n wu̱ ne̱ komo ba u̱n wu̱ no̱me̱ jaab-o̱ u̱t-me̱n, wu̱ cit wu̱ ko̱wan wu̱ wu̱ ro̱ à remen ye̱ nepste̱ Go̱s-wu̱ u̱n ye̱ wu̱. ");
INSERT INTO uth_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Ye̱so haaru̱, wu̱ de̱knu̱ru̱ ka buro̱di-o̱, wu̱ ya'asu̱ru̱ ye̱ o̱ o-jan ne̱. ");
INSERT INTO uth_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Haan-m atette̱-mo̱ ka Ye̱so rwu̱ntu̱te̱ hi u̱n de u̱n wu̱ be-de u̱n yan-neke̱-mo̱ u̱n wu̱ cin da-de a 'yonse̱ wu̱ u̱t-marimar à. ");
INSERT INTO uth_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Bo̱ ye̱ komte̱ u̱r-beks à, Ye̱so ze̱e̱ru̱ Simo̱n Bitrus, “Simo̱n, wà Yohana, ¿wo̱ jiishe̱ o̱r ru ne̱ u̱n co̱n-u̱t re?” Simo̱n Bitrus ze̱e̱ru̱ wu̱, “O̱ho̱, Go̱s-wu̱ re o̱ho̱, ko̱ wo̱ de, o nepste̱ u̱m co̱no̱g wo̱.” Ye̱so ze̱e̱ru̱ wu̱, “No̱m gu̱t-de u̱n yan-dor re bo̱ a u̱n gu̱t-de u̱n ca à.” ");
INSERT INTO uth_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Wu̱ dooru̱ wu̱ m-ze̱e̱ ayoore̱-o̱, “Simo̱n, wà Yohana, ¿o co̱no̱g me̱, ko̱?” Wu̱ zee, “O̱ho̱, Go̱s-wu̱ re o̱ho̱, ko̱ wo̱, o nepste̱ u̱m co̱no̱g wo̱.” Ye̱so ze̱e̱ru̱ wu̱, “To̱, no̱m gu̱t-de u̱n yan-dor re.” ");
INSERT INTO uth_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Ye̱so dooru̱ wu̱ m-cit kááne̱ har atette̱-o̱, “Simo̱n, wà Yohana, ¿wo̱ me̱ m-co̱n?” Bitrus naasu̱ru̱ u̱t-me̱n remen ka rwo̱r-m atette̱-mo̱ mo̱ Ye̱so ze̱e̱, “¿Wo̱ me̱ co̱n?” Wu̱ ne̱, wu̱ ze̱e̱ru̱, “Go̱s-wu̱ re, ai, o nepste̱ ko̱yan kap. O nepste̱ ne̱ u̱nze me̱ wo̱ m-co̱n.” Ye̱so ze̱e̱ru̱ wu̱, “To̱, no̱m gu̱t-de u̱n yan-dor re. ");
INSERT INTO uth_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Me̱ no̱ m-ru̱re̱ o-nip, da-de u̱n yakar-u̱t ru o ro u̱n cu̱pe̱ u̱n hi u̱n du u̱t-matuku, o argu̱ru̱ co̱-o o co̱ne̱ à. Amba wo̱ mo̱ngse̱, se̱ wo̱ tabbe̱ u̱t-kom wu̱ ken wu̱ cu̱pu̱ wo̱, wu̱ nek wo̱ be-de wo̱ co̱ne̱ á.” ");
INSERT INTO uth_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","(Wu̱ u̱n rwo̱r kááne̱ remen wu̱ ro m-me'es u̱n go̱n mar-mo̱ Bitrus hette̱ wu̱ se̱ke̱mste̱ Shir à). Bo̱ Ye̱so komte̱ m-rwo̱r kááne̱ à, wu̱ ze̱e̱ru̱ Bitrus, “Do̱nd me̱.” ");
INSERT INTO uth_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Bitrus byandu̱ru̱, wu̱ 'wo̱ss ka wan-neke̱-m Ye̱so wu̱, wu̱ Ye̱so ro m-was à. (Ka ne̱t-wu̱ ro to̱sse̱ u̱n he̱r-o Ye̱so u̱n ka biki-o̱ à. Komo ka ne̱t-wu̱ citu̱ru̱ Ye̱so, “Go̱s-wu̱, ¿wan-wu̱ ne̱ he wu̱ m-ya'as?”) ");
INSERT INTO uth_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Bo̱ Bitrus hyente̱ wu̱ à, wu̱ ze̱e̱ru̱ Ye̱so, “Go̱s-wu̱ re, ¿wu̱ ka ne̱t-wu̱ ne̱? ¿Ya he wu̱ m-ko̱r?” ");
INSERT INTO uth_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Ye̱so ze̱e̱ru̱ wu̱, “Ko̱ me̱ zee wu̱a nom ho̱o̱g har u̱m mu̱u̱nté̱, ¿ya daaru̱ wo̱? Wo̱ de̱, do̱nd me̱.” ");
INSERT INTO uth_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Remen káane̱ ka ma-to̱ yasu̱ru̱ be-de u̱n o̱r u̱n ye̱ ne̱ u̱nze ka wan-neke̱-m Ye̱so wu̱, wu̱ he de m-mar á. Amba Ye̱so zee káane̱ wu̱ he de m-mar á. Wu̱ u̱n ze̱e̱, “Ko̱ me̱n ze̱e̱ wu̱a nom ho̱o̱g har u̱m mu̱u̱nté̱, ¿ya daaru̱ wo̱?” ");
INSERT INTO uth_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Wu̱, ka wan-neke̱-m Ye̱so wu̱, wu̱ ro̱ Ye̱so m-su̱ ye̱ u̱n ka ma-to̱. Wu̱ ge̱ne̱ to̱ tomso ne̱. Te̱ nepste̱ ne̱ u̱nze su̱'e̱-mo̱ u̱n wu̱ hond hond o̱. ");
INSERT INTO uth_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Se ken rem-se ro kon u̱t-mo̱o̱r ne̱ se̱ Ye̱so no̱me̱ à. U̱ rotte̱ u̱nze a ge̱ne̱g ma-to̱ u̱n se u̱n gaan u̱n gaan, me̱ u̱m hyan ko̱ ho̱no o-dak u̱n hi u̱n de u̱n o̱, o̱ roa hoks de̱k u̱n ka taku̱rda-to̱ a he m-ge̱n á.");
INSERT INTO uth_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Tiyaporus, u̱n taku̱rda-o re o̱ u̱r-takan, u̱m genu̱tu̱ wo̱ ma-to̱ u̱n kap o̱ u̱n bo̱ u̱n rem-se Ye̱so ba'e̱ m-no̱m à, komo u̱n se wu̱ ba'e̱ m-yoos ne̱ à, ");
INSERT INTO uth_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","har ha-mo̱ u̱n ho̱-de a de̱ke̱ wu̱ ha-mo̱ n-To̱n shir à. Rii-yo a dekt wu̱ n-To̱n, wu̱ nomsu̱te̱ yan-To̱m-ye̱ u̱n wu̱ u̱t-ma, ye̱ wu̱ daage̱ à. Be̱e̱b-de u̱n Ku̱kt-o̱ Shir guuru̱ ye̱ m-she̱r u̱n nap u̱n ká rem-se Ye̱so ru̱ru̱ ye̱ à. ");
INSERT INTO uth_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Bo̱ wu̱ su̱u̱te̱ u̱r-ko̱o̱b, wu̱ meret n-to̱n o-kan à, wu̱ rwu̱u̱nu̱ru̱ u̱n ho̱o̱g ne̱ be-de u̱n ye̱. Wu̱ no̱mo̱g u̱t-ho̱ kwo̱o̱z-u̱t yoor 40, wu̱ kutu̱ ye̱ u̱s-rem go̱-u̱s-go̱ u̱nze ma-to̱ u̱n ine̱-mo̱ u̱n wu̱ nip-o̱. Wu̱ ro m-rwo̱r u̱n ma-to̱ u̱n Gwo̱mo-to̱ Shir. ");
INSERT INTO uth_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Da-o̱ wu̱ ro be-u̱r gaan u̱n ye̱ ne̱ à, wu̱ nomo ye̱ u̱t-ma. Wu̱ zee, “No̱ jar no̱ yage̱ o-Urusharima á. Wasu̱ no̱ se̱ nu-o̱ Tato re swo̱re̱ à shiig o-nip, ká o̱ u̱m ru̱ru̱ no̱ u̱n nu-o re à, u̱nze, ");
INSERT INTO uth_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Yohana yo'oste̱ hun-ne̱ m-ho̱, amba kane̱ u̱t-ho̱ ha-mo̱ co, a yo'os no̱ u̱n Ku̱kt-o̱ Shir.” ");
INSERT INTO uth_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Bo̱ yan-To̱m Ye̱so mo̱rgu̱te̱ à, ye̱ citu̱ Ye̱so. Ye̱ zee, “Wan-Ko̱yan, ¿m-mo̱ka o̱ o he muute̱ u̱n Isra-ne̱ u̱t-gwo̱mo?” ");
INSERT INTO uth_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Ye̱so ze̱e̱ru̱ ye̱, “Tato-o̱ cot wu̱ ro̱ wan-gwo̱mo to̱ u̱n hongse̱ o-da, amba no̱ a 'ya no̱ be̱e̱b-de u̱n nap u̱n to̱ ka á. ");
INSERT INTO uth_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Amba no̱a kumus u̱r-be̱e̱b da-o̱ Ku̱kt-o̱ Shir o̱ kyergu̱ndu̱ no̱. No̱a warag yan-swo̱-se u̱n ma-u̱t re o-Urusharima, u̱n kap o̱ n-me̱ u̱n dak-o̱ o-Judiya ne̱, o-Samariya ne̱, har ha-mo̱ u̱n ma-de u̱n ho̱no o-dak.” ");
INSERT INTO uth_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Bo̱ wu̱ ru̱rte̱ kaane̱ à, ye̱ o-gwo̱t, a argu̱ wu̱ m-de̱k n-To̱n shir. O̱ ken ke'ente̱-o̱ ho̱kku̱ru̱ wu̱. Ye̱ do wu̱ m-hyan á. ");
INSERT INTO uth_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Bo̱ ye̱ rotte̱ u̱n ho̱r u̱n yish n-to̱n à, wu̱ komo wu̱ ro m-arag, u̱n gyept-o̱ yish. Ye̱ gwo̱tu̱ru̱ ye̱ 'wo̱s yan-to̱m-ye̱ Shir yoor eso u̱n he̱r-o̱ u̱n ye̱, ye̱ cu̱pste̱ matuku-u̱t pus-to̱. ");
INSERT INTO uth_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Ye̱ ze̱e̱ru̱, “No̱ hun-ne̱ ye̱ o-Gariri, ¿remen yan o̱ no̱tte̱ eso eso u̱n gwo̱t-o̱ n-To̱n shir? Ká Ye̱so wu̱ a de̱ke̱ be u̱n no̱ ha-mo̱ n-To̱n à, wu̱a do m-mu̱u̱n bo̱ no̱ hyane̱ arag-mo̱ u̱n wu̱ à.” ");
INSERT INTO uth_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Yan-To̱m Ye̱so yagu̱te̱ “Haag-o̱ u̱n 'yo-se o-Ze̱tun,” ye̱ argu̱ m-warag o-Urusharima, u̱n hew-de u̱n hohond-mo̱ u̱n pu̱ru̱g-de u̱r-me̱r kiromita 1. ");
INSERT INTO uth_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Bo̱ ye̱ cu̱wte̱ o-bo̱ à, ye̱ daaru̱ kuke̱-o̱ a ma'e̱ n-to̱n u̱n o̱r u̱n o̱ be-de ye̱ u̱r-she'et à. Ye̱ ro'e̱ kane̱ à, ye̱ ro̱, Bitrus ne̱, Yohana ne̱, Yakubu ne̱, Andarawus ne̱, Pirip ne̱, Tomas ne̱, Bataromi ne̱, Matiyos ne̱, Yakubu ne̱ (wà Aru̱payes), Simo̱n ne̱ (wu̱ a m-aag ya'as u̱r-hi à), komo u̱n Yahudas ne̱ (wà Yakubu). ");
INSERT INTO uth_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Kap ye̱ ka ye̱ hwo̱o̱g u̱r-hi u̱n no̱m u̱s-ko̱n, barag-se u̱n ye̱ u̱s-gaan mo̱sse̱ u̱n ye̱ ken ne'a-ne̱ ye̱ ne̱, u̱n Meri ne̱ inu Ye̱so, komo u̱n hen-ne̱ Ye̱so ne̱. ");
INSERT INTO uth_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","U̱n ka da-o̱, yan-dor Ye̱so mo̱rgu̱te̱ (be-de u̱n hun-ne̱ zungu-o gaan u̱r-kwo̱o̱z ne̱ 120). Bitrus inu̱ru̱ eso, wu̱ zee, ");
INSERT INTO uth_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“O̱r re ne̱, se̱ Ma-to̱ Shir shiig o-nip to̱ Ku̱kt-o̱ Shir rwo̱re̱ n-ga u̱n nu-o ko-Gwo̱mo Dawuda mo̱sse̱ u̱n Yahudas ne̱ à, wu̱ hante̱ bu̱-se a shipte̱ Ye̱so à. ");
INSERT INTO uth_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Remen Yahudas n-ga wan-gaan wu̱ be-u̱r na yan-ko̱'o̱t u̱n Ma-to̱ Shir, a ya'assu̱tu̱ wu̱ komo gwu̱u̱g-de u̱n wu̱ n-me̱ u̱n ka se̱nge̱-mo̱.” ");
INSERT INTO uth_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(U̱n 'yons-de u̱n se̱nge̱-mo̱ u̱n wu̱ ne̱ m-yo̱ mo̱, Yahudas o̱o̱ru̱ o̱ ken pu̱p-o̱. Wu̱ he̱e̱ru̱ u̱r-bo̱o̱g, me̱n-o̱ u̱n wu̱ nupsu̱ru̱, saw-to̱ u̱t-me̱n to̱ u̱n wu̱ kap to̱ rwu̱u̱nu̱ n-do̱. ");
INSERT INTO uth_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Kap ya-u̱r-she'et o-Urusharima ko wu̱ ke nepste̱ rii-yo ko̱re̱ à, har atte̱ m-aag u̱n ka pu̱p-o̱ “Akardama” u̱n rem-de u̱n ye̱, o̱ ro̱ Pu̱p-o̱ m-Hyó.) ");
INSERT INTO uth_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Bitrus ze̱e̱ru̱, “Remen gense̱ to̱ ro̱ n-me̱ u̱n taku̱rda-o̱ u̱n Se̱p-to̱ u̱r-Bo̱ngo̱n u̱nze, “ ‘A ginim hur-o̱ u̱n wu̱, taase ne̱tu̱ she'et n-me̱ á.’ A zeste̱ komo, ‘Con-de u̱n wu̱, wu̱ ken ne̱t-wu̱ dek.’ ");
INSERT INTO uth_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Remen kaane̱, se̱ a deeg wu̱ ken wu̱ be-de u̱n ka hun-ne̱ ye̱, wu̱ ro̱ be-u̱r gaan u̱n na ne̱ à, kap u̱n ho̱-to̱ Wan-Ko̱yan Ye̱so ro m-ma'as u̱r-hew u̱n na ne̱ à. ");
INSERT INTO uth_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Depete̱ wu̱ ka ne̱t-wu̱ warag wa-u̱s-swo̱ be-u̱r gaan u̱n na ne̱ cin da-o̱ Yohana ro m-yo'os u̱n Ye̱so m-ho̱ à har ha-mo̱ u̱n ho̱-de a de̱ke̱ Ye̱so be-u̱r na ha-mo̱ n-To̱n shir à. Do̱re̱-o̱ wan-gaan n-me̱ u̱n ka hun-ne̱ ye̱ est be-de u̱n rwo̱r u̱n ma-to̱ u̱n ine̱-mo̱ u̱n wu̱ u̱t-marimar be-u̱r gaan u̱n na ne̱.” ");
INSERT INTO uth_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Ye̱ hantu̱ru̱ hun-ne̱ yoor: Yusuhu wu̱ a m-aag Baru̱sabas à (wu̱ a komo m-aag Justus à), komo u̱n Matiyas ne̱. ");
INSERT INTO uth_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Ye̱ no̱mu̱ u̱s-ko̱n: Ye̱ zee, “Wan-Ko̱yan, o nepste̱ hur-de u̱n ko wu̱ ke. Kutu te̱ wu̱ o daage̱ be-de u̱n ka hun-ne̱ yoor-ye̱ à, ");
INSERT INTO uth_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","remen wu̱ waragté̱ ko-yan-To̱m Ye̱so, u̱n ka se̱nge̱-mo̱ Yahudas yage̱ wu̱ neku̱te̱ ká be-de Shir daage̱ remen wu̱ à.” ");
INSERT INTO uth_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Ye̱ nom u̱r-barag. Barag-u̱r he̱'e̱nu̱ru̱ Matiyas. A rwo̱'u̱ wu̱ komo wu̱ wargu̱ ko-yan-To̱m Ye̱so mo̱sse̱ u̱n ka ne̱n o̱p o-gaan ye̱ ne̱. ");
INSERT INTO uth_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Bo̱ ho̱-de u̱n Biki-o̱ o-Pe̱nte̱ko̱s wo̱o̱nte̱ à, myet yan-dor Ye̱so ro be-u̱r gaan. ");
INSERT INTO uth_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Da-o gaan, a ho̱gu̱ru̱ o̱ ken zaaz-o̱ n-to̱n u̱ntu̱n o̱ u̱n caari-mo̱ m-yo, o̱ shoosu̱ru̱ kap o̱ u̱n ka hur-o̱ ye̱ rotte̱ u̱r-mo̱ro̱g n-me̱ à. ");
INSERT INTO uth_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Ye̱ hyanu̱ru̱ to̱ ken rii-to̱ sa o zee rem-to̱ o-ra. To̱ comsu̱ru̱ be-de u̱n ye̱, to̱ ro m-cire̱ u̱n hi-de u̱n ko̱ wu̱ ke. ");
INSERT INTO uth_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","A shoosu̱ ye̱ kap u̱n Ku̱kt-o̱ Shir. Ye̱ ciru̱ m-te̱pe̱r u̱n rem-u̱t ho̱r-to̱ bo̱ Ku̱kt-o ya'u̱ ye̱ co̱w-yo m-te̱pe̱r à. ");
INSERT INTO uth_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","To̱, u̱n ka ho̱-to̱, Yahuda-ne̱ de̱e̱n ro u̱r-she'et o-Urusharima. Ye̱ ro̱ u̱n dor-o̱ o-karamsa m-so̱k ne̱ ne̱. Ye̱ u̱n haan rwu̱u̱n-mo̱ u̱n ko̱ kene̱ u̱n ho̱no o-dak remen ye̱ nomot Biki-o̱ o-Pe̱nte̱ko̱s. ");
INSERT INTO uth_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Bo̱ ye̱ ho̱gu̱te̱ zaaz-o̱ u̱n ka yo-mo̱ à, hun-ne̱ mo̱rgu̱ru̱ de̱e̱n. Kap mo̱ u̱n ye̱ ye̱ bo̱pu̱ru̱ o-nu, remen kap mo̱ u̱n ye̱ ho̱gu̱te̱ mo̱ro̱g-de yan-dor Ye̱so ro m-te̱pe̱r u̱n rem-de u̱n dak-o̱ u̱n ye̱. ");
INSERT INTO uth_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Ye̱ bo̱pu̱ o-nu m-so̱k ne̱, ye̱ ze̱e̱ru̱, “Ashi, ¿myet-o̱ u̱n ka ye̱ ro̱ te̱p à, ya-o-Gariri-ye̱ ka á? ");
INSERT INTO uth_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","¿No̱mu̱ u̱n ya re ne̱ ko wu̱ ke be-u̱r na ro̱tte̱ m-ho̱ge̱ ye̱ ro̱ m-te̱pe̱r u̱n rem-u̱t na? ");
INSERT INTO uth_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Myet-m na ro̱ m-ho̱ge̱. Ye̱ ken ye̱ be-u̱r na: Ya-o-Patiya-ye̱, u̱n Ya-o-Madi-ne̱, u̱n Ya-o-Eram-ne̱, u̱n Ya-o-Me̱so̱po̱tami-ne̱, u̱n Ya-o-Judiya-ne̱, u̱n Ya-o-Kapado̱ki-ne̱, u̱n Ya-o-Pantus-ne̱, u̱n Ya-o-Asiya-ne̱, u̱n ");
INSERT INTO uth_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Ya-o-Pirijiya-ne̱, u̱n Ya-o-Bampiriya-ne̱, u̱n Ya-o-Masar-ne̱, u̱n Ya-o-Kire̱ni-ne̱ so̱ u̱n dak-o̱ o-Ribiya, u̱n Ya-o-Roma-ne̱, ye̱ ro haante̱ u̱r-hamat o-Urusharima ");
INSERT INTO uth_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","(Ka ye̱ ro̱ m-ho̱ge̱ u̱n rem-de u̱t-Ibra u̱n u̱t-Girik ne̱ à, ye̱ a mate̱ n-me̱ u̱n jor-se Yahuda-ne̱ u̱n ye̱ waktu̱ne̱ ye̱ cu̱w go̱n jor-u̱s na ne̱ à). U̱n ya-o-Kirit-ne̱, u̱n Ya-o-Raraba-ne̱. Kap a m-ho̱ge̱ ye̱ ro̱ m-te̱pe̱r u̱n rem-u̱t na caari-se u̱s-rem se̱ Shir no̱me̱ à!” ");
INSERT INTO uth_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Myet ye̱ bo̱pu̱ nu-se u̱n ye̱, ye̱ nap yo m-no̱m á, ye̱ ze̱e̱ru̱ hi-de u̱n ye̱, “¿Ya u̱n yo ne̱ yo ka?” ");
INSERT INTO uth_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Amba ye̱ ken ye̱ nomo ye̱ u̱r-ar ye̱ zee, “Ke̱-mo̱ ye̱ swo̱'e̱ mo̱ bo̱pu̱ ye̱.” ");
INSERT INTO uth_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Bitrus inu̱ eso u̱n ka o̱p u̱n wan-gaan ye̱ ne̱, wu̱ 'yonsu̱ u̱s-co̱r. Wu̱ ze̱e̱ru̱ ka bu̱u̱g-de u̱n hun-ne̱ de, “No̱ o̱r re ne̱, Yahuda-ne̱ u̱n kap o̱ u̱n ya-u̱r-she'et o-Urusharima ne̱, ho̱gu̱ no̱ m-so̱k ne̱. Komo no̱ was u̱n rii-yo u̱m he no̱ m-ru̱re̱ ne̱ à. ");
INSERT INTO uth_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Ka hun-ne̱ ye̱ ye̱ swo̱ m-ke̱ bo̱ no̱ u̱s-barag á. No̱ nak m-mo̱ka kwo̱m-u̱s jero̱ se cot se n-sot. Komo kane̱ a m-swo̱ n-sot á. ");
INSERT INTO uth_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","To̱ ka, ai, to̱ to̱ Jower wan-Rwo̱r u̱n Ma-to̱ Shir rwo̱re̱ u̱nze, ");
INSERT INTO uth_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","“ ‘Shir ze̱e̱g: U̱n ho̱-to̱ u̱r-ko̱m, man duusu̱ne̱ myet o̱ u̱n hun-ne̱ Ku̱kt-o re. Yakar no̱ yan-campo̱-ne̱ u̱n yan-ne'a-ne̱ ne̱ ye̱a ko̱'o̱t ma-u̱t re, hyangan-u̱t a haan yan-campo̱ no̱ ne̱, mo̱ng-ne̱ ye̱ u̱n campo̱-ne̱ no̱ bo-u̱s a re ye̱. ");
INSERT INTO uth_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","O-nip, har ma u̱n ka ho̱-to̱ man duusu̱ne̱ Ku̱kt-o re be-de u̱n gu̱w-ne̱ re campo̱-ne̱ u̱n ne'a-ne̱ ne̱, ye̱a ko̱'o̱t ma-u̱t re. ");
INSERT INTO uth_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Man rwu̱nte̱ saw-to̱ u̱t-hyat u̱n ku̱s-o̱ n-to̱n, u̱n saw-to̱ o-made̱ ne̱ kane̱ n-dak, to̱ ro̱ m-hyó, o-ra ne̱, u̱n hye-u̱r rim-de ne̱. ");
INSERT INTO uth_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","A mus u̱r-ho̱ o-comb, o-re̱ng komo yoa wakte̱ o-jaas yo u̱ntu̱n m-hyó, rii-yo ho̱-de u̱n mu̱u̱n-m Yawe de wo̱o̱nte̱, ka caari-de u̱r-ho̱ de, de m-se̱ke̱mse̱. ");
INSERT INTO uth_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Komo ko̱wan wu̱ aage̱ u̱n jin-u̱r Yawe, wu̱a kum gwu̱.’ ");
INSERT INTO uth_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“No̱ o̱r re ne̱ Isra-ne̱, ho̱gu̱ no̱ to̱ ka ma-to̱. Ye̱so ko-ya-o-Nazaret ne̱t-wu̱, wu̱ Shir ru̱ru̱ no̱ o-nip u̱nze wu̱ go̱kste̱ wu̱ à. Shir rwu̱ntu̱te̱ to̱ ka be-de u̱n rem-se o-made̱, u̱n rem-se u̱t-hyat ne̱, u̱s-napa ne̱ se wu̱ kutu̱ na be-u̱r Ye̱so à, u̱ntu̱n bo̱, kap no̱ nepste̱ u̱n to̱ ka ne̱. ");
INSERT INTO uth_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Ka ne̱t-wu̱, a u̱n ya'as no̱ wu̱ u̱n bo̱ Shir ro e̱ste̱ à. Komo u̱n nap-o̱ u̱n wu̱ ne̱, no̱ kamu̱ wu̱, no̱ hoot wu̱ u̱n kom-to̱ ya-u̱r-ba'as n-to̱n o-kan. ");
INSERT INTO uth_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Amba Shir rurug wu̱ be-de u̱n gwo̱mo-to̱ m-mar. Wu̱ 'yonstu̱ wu̱ u̱t-marimar remen yatt-yo he m-nome̱ komo mar-mo̱ bu̱pt wu̱ á. ");
INSERT INTO uth_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Remen ko-Gwo̱mo Dawuda no̱mo̱g ma-to̱ u̱n wu̱, wu̱ zee, “ ‘U̱r-ho̱ bi me̱ m-hyan u̱n Yawe wu̱ ro̱ be-u̱r gaan u̱n me̱ ne̱. Remen wu̱ ro̱ u̱n kom-o̱ u̱n re̱ u̱n de, yatt rii-yo he me̱ 'ya o-gye̱r á. ");
INSERT INTO uth_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Remen kaane̱ hur u̱n de ro̱ o-zak, me̱ u̱n me̱n-u̱t pus-to̱ puu, myet u̱n kaane̱ ne̱ me̱ ne̱t-wu̱ ko-ya-m-mar, man she'et o-sakto̱ ne̱. ");
INSERT INTO uth_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Remen wo̱a yage̱ ho̱o̱g-m re u̱n saag á, wo̱a yage̱ ne̱ wu̱ ro̱ Wu̱ ba m-Ku̱ko̱p à, wu̱ meret wu̱ wu̱mu̱t á. ");
INSERT INTO uth_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","O yoosu̱tu̱ me̱ co̱w-yo u̱n ho̱o̱g. Wo̱a shoos me̱ o-zak be-de m-she'et be-u̱r gaan u̱n me̱ ne̱.’ ");
INSERT INTO uth_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“O̱r re ne̱ Isra-ne̱, man hoks no̱ nome̱ u̱n ma-u̱t tato na ko-yan-ga'e̱ Dawuda. Dawuda mereste̱, a ju̱ks wu̱, saag-o̱ u̱n wu̱ komo o̱ ro̱ ko̱n be-u̱r na har caane̱. ");
INSERT INTO uth_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Dawudawan-Rwo̱r u̱n Ma-to̱ Shir wu̱, komo wu̱ nepste̱ Shir e̱ssu̱ssu̱te̱ u̱t-ma u̱n wu̱ ne̱ mo̱sse̱ u̱s-to̱nd ne̱, u̱nze wu̱a sagbe̱ wu̱ ken wu̱ u̱t-gwo̱mo n-te̱ baag-o u̱n wu̱, bo̱ wu̱ sagbu̱ to̱ Dawuda à. ");
INSERT INTO uth_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Bo̱ Dawuda hyente̱ yo ro̱ co à, wu̱ no̱mu̱ u̱t-ma to̱ u̱n ine̱-m Kiristi u̱t-marimar, u̱nze a yagu̱ wu̱ u̱n saag á, wu̱r-o̱ u̱n wu̱ komo o̱ a wu̱m á. ");
INSERT INTO uth_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Shir 'yonste̱ ka Ye̱so wu̱ u̱t-marimar, na komo ya-u̱s-to̱r-ye̱ kap u̱n to̱ ka. ");
INSERT INTO uth_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","A ya'ag Ye̱so m-se̱k wu̱ she'et u̱n kom-o̱ u̱r-re̱ o̱ Shir. Komo wu̱ go̱kste̱ Ku̱kt-o̱ Shir be-de o-Tato, bo̱ a swo̱re̱ o-nu à. Wu̱ duusu na Ku̱kt-o̱ u̱n wu̱, o̱ hante̱ rii-yo no̱ m-hyan à, u̱n yo no̱ m-ho̱ge̱ ne̱ à. ");
INSERT INTO uth_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Ba Dawuda wu̱ da'e̱ n-To̱n á, amba wu̱ u̱n hi u̱n de u̱n wu̱, wu̱ ze̱e̱g, “ ‘Yawe ze̱e̱g Wan-Ko̱yan re, “She'et so̱ u̱n kom-o re o̱ u̱r-re̱, ");
INSERT INTO uth_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","har u̱m ru̱'u̱t yan-yage̱-u̱t ru waragte̱ rii-yo o he m-yawag u̱n na-u̱s ru à.” ’ ");
INSERT INTO uth_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Remen kaane̱, kap o̱ u̱n hun-ne̱ ye̱ o-Isra ye̱ nep u̱nze ka Ye̱so-wu̱ a kame̱ o-kan à, Shir muutu̱ wu̱ Wan-Ko̱yan, komo u̱n Kiristi.” ");
INSERT INTO uth_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Bo̱ hun-ne̱ ho̱gu̱te̱ kaane̱ à, ka ma-to̱ do̱'u̱ru̱ ye̱ u̱t-me̱n, ye̱ ze̱e̱ru̱ Bitrus u̱n ye̱ ka yan-To̱m-ye̱ Ye̱so ye̱ ne̱, “O̱r re ne̱ Isra-ne̱, ¿ya a he no̱ m-no̱m?” ");
INSERT INTO uth_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Bitrus ze̱e̱ru̱ ye̱, “Waktu̱n no̱ be-de Shir, a yo'os no̱ m-ho̱ n-me̱ u̱n jin-u̱r Ye̱so Kiristi remen a soksu̱tú̱ no̱ ba'as-u̱t no̱. No̱a kum yar-mo̱ u̱n Ku̱kt-o̱ Shir. ");
INSERT INTO uth_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Remen Shir u̱n e̱ss ka swo̱r o-nu o̱ rem no̱ u̱n yakar no̱ ne̱, komo u̱n ye̱ ro̱ Yahuda-ne̱ á, kap o̱ u̱n ye̱ Wan-Ko̱yan Shir na he m-aag be-de u̱n wu̱ à.” ");
INSERT INTO uth_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Wu̱ ma'asu̱ru̱ ye̱ u̱n ru̱re̱ u̱t-ma de̱e̱n to̱ ye̱ hette̱ bo̱p o-nip à, wu̱ naku̱ru̱ ye̱ u̱t-to̱ wu̱ ro̱ m-ze̱e̱, “Ruut no̱ hi u̱n no̱ be-de u̱n swo̱ u̱r-ko̱o̱b o̱ ro̱ u̱n hi-de u̱n kà yan-me̱n-u̱t jaas-to̱ ye̱, kà ye̱ 'yare̱ Ye̱so à.” ");
INSERT INTO uth_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Ye̱ de̱ke̱ ma-u̱t Bitrus à, a yo'osu̱ru̱ ye̱ m-ho̱. U̱n ka ho̱-de komo ye̱ do̱o̱ru̱ u̱t-mo̱o̱r be-de u̱n hun-ne̱ dugu-u̱s tet 3,000. ");
INSERT INTO uth_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Ye̱ e̱ssu̱ u̱r-hi kap o̱ u̱n ye̱ be-de u̱n yoos-de yan-To̱m-ye̱ Ye̱so ro̱ m-yoos à. Ye̱ ro̱ m-re̱ Rii-yo m-Re̱ yo m-Pas yo u̱n Wan-Ko̱yan, u̱n ko̱n-se Shir ne̱. ");
INSERT INTO uth_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Ko̱ wu̱ ke bo̱pu̱ru̱ o-nu, remen Shir ro̱ u̱n no̱m u̱n rem-se o-made̱ u̱s-napa ne̱ de̱e̱n be-de u̱n yan-To̱m Ye̱so. ");
INSERT INTO uth_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Myet o̱ yan-dor Ye̱so she'etu̱ru̱ be-u̱r gaan ba m-koos, ko̱yan yo ye̱ ro̱tte̱ à ye̱ wongu̱ru̱. ");
INSERT INTO uth_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Ye̱ babu̱ru̱ rii-yo ye̱ ro̱tte̱ à, ye̱ wongu̱ ka ye̱ rotte̱ á. ");
INSERT INTO uth_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Ko̱ de ke ho̱-de komo ye̱ ro̱ mo̱rge̱ u̱n Pyo-o̱ Shir. Ye̱ ro m-re̱ Rii-yo m-Re̱ yo m-Pas yo u̱n Wan-Ko̱yan u̱n hur-to̱ u̱n ye̱, ye̱ ro m-re̱ m-swo̱ ne̱ u̱n me̱n-u̱t pus-to̱, u̱n hur-u̱r gaan ne̱. ");
INSERT INTO uth_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Ye̱ ro u̱n bo̱ngo̱n-de Shir. Ye̱ ro̱ komo u̱n jin-u̱r so̱-de ne̱ be-de u̱n hun-ne̱ kap. Ko̱ de ke ho̱-de komo Wan-Ko̱yan ro ye̱ m-do'e̱ u̱n ye̱ ro̱ u̱n kum u̱n gwu̱ à. ");
INSERT INTO uth_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","De ken ho̱-de Bitrus ne̱ u̱n Yohana ye̱ ro m-neke̱ u̱n Pyo-o̱ Shir u̱n da-o̱ u̱n ko̱n-se Shir, so̱ u̱n kwo̱m-u̱s tet-se m-rim. ");
INSERT INTO uth_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","U̱n ish-o̱ a m-ze̱e̱ Ish-o̱ u̱t-Ayowe̱ à, wu̱ ken ne̱t-wu̱ ro kon wu̱ cin bo̱ u̱n mat-o̱ u̱n wu̱ ryam-to̱ wu̱ rotte̱. Ko̱ de ke ho̱-de a wu̱ m-hante̱ u̱n ish-o̱ u̱n Pyo-o̱ Shir, remen wu̱ konot hwo̱r be-de u̱n ya-m-co̱w. ");
INSERT INTO uth_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Bo̱ wu̱ hyente̱ Bitrus ne̱ u̱n Yohana ro m-co̱w u̱n Pyo-o̱ Shir à, wu̱ argu̱ ye̱ m-ko̱n u̱n hwo̱r. ");
INSERT INTO uth_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Bitrus ne̱ u̱n Yohana tuuru̱ wu̱ yish, Bitrus ze̱e̱ru̱ wu̱, “Gwo̱t te̱.” ");
INSERT INTO uth_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Hur-de u̱n ko-ryam argu̱ m-warag be-de u̱n ye̱, wu̱ ro o-dish ye̱a ya'as wu̱ hwo̱r. ");
INSERT INTO uth_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Amba Bitrus ze̱e̱ru̱, “Me̱ ro̱tt hwo̱r á. Amba rii-yo u̱m ro̱tte̱ à, yo u̱m he wo̱ m-'ya. N-me̱ jin-u̱r Ye̱so Kiristi wu̱ o-Nazaret, ine̱ eso, o hewe̱ u̱r-hew!” ");
INSERT INTO uth_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Bitrus shipu̱ru̱ kom-o̱ u̱n wu̱ o̱ u̱r-re̱, wu̱ jaksu̱ wu̱. Ba u̱n rem, da-to̱ u̱s-na se u̱n wu̱ u̱n yish-to̱ u̱n na-se u̱n wu̱ ne̱ no̱mu̱ m-'wo̱ns. ");
INSERT INTO uth_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Wu̱ gurgu̱ kagat! Wu̱ inu̱ru̱ eso, wu̱ ciru̱ u̱r-hew, u̱n co̱wu̱ u̱n Pyo-o̱ Shir da-o gaan u̱n ye̱ ne̱. Wu̱ ro u̱r-hew, wu̱ ro̱ u̱t-no̱sse̱, wu̱ ro̱ komo u̱n bo̱ngo̱n-de Shir. ");
INSERT INTO uth_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Bo̱ hun-ne̱ myet hyane̱ wu̱ ro̱ u̱r-hew u̱n bo̱ngo̱n-de Shir ne̱ à, ");
INSERT INTO uth_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","ye̱ nape̱ komo u̱nze wu̱ wu̱ ro u̱r-she'et n-riib u̱n Ish-o̱ u̱t-Ayowe̱ u̱n Pyo-o̱ Shir u̱s-ko̱n à. Ye̱ bo̱pu̱ o-nu m-so̱k ne̱ remen rii-yo u̱t-hyat yo ye̱ hyane̱ yo no̱mo̱g mo̱sse̱ u̱n wu̱ ne̱ à. ");
INSERT INTO uth_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Bo̱ ka wa-u̱t-ryam-wu̱ gamte̱ Bitrus ne̱ u̱n Yohana à, kap o̱ u̱n hun-ne̱ haanu̱ru̱ be-de u̱n ye̱ u̱s-rek n-me̱ u̱n sak-o̱ Suremanu à, ye̱ ro̱ u̱n bo̱pu̱ u̱n nu-se u̱n ye̱. ");
INSERT INTO uth_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Bo̱ Bitrus hyente̱ kaane̱ à, wu̱ nomu̱ hun-ne̱ o-ko̱'o̱t. Wu̱ ze̱e̱ru̱, “No̱ hun-ne̱ ye̱ o-Isra, ¿remen ya u̱n o̱ no̱ bu̱pte̱ u̱s-nu u̱n to̱ ka? Komo ¿remen ya u̱n no̱tte̱ te̱ o-gwo̱t, sa o zee u̱n be̱e̱b-de u̱n hi u̱n te̱ o̱, ko̱ remen se̱nge̱-m te̱ be-de u̱n dor-o̱ Shir o̱ te̱ ru̱'u̱te̱ ka ne̱t-wu̱ hewu̱te̱ u̱r-hew? ");
INSERT INTO uth_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Shir Ibrahi, u̱n Ishaku, u̱n Yakubu ne̱, Shir tat-ne̱ te̱, wu̱ se̱pse̱ ko-gu̱w-wu̱ u̱n wu̱ Ye̱so. Biratus ko-Gwamna no̱mu̱ sakto̱-o̱ wu̱ ho'ostu̱ wu̱. Amba u̱n hek-o̱ u̱n kaane̱, no̱ yo'ogte̱ Ye̱so, no̱ yagu̱ wu̱ komo u̱t-yage̱ u̱n co Biratus. ");
INSERT INTO uth_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Amba no̱ yagu̱ ka wan-ba-m-ku̱ko̱p wu̱ u̱t-yage̱, Kashi u̱n Ne̱t, no̱ kon a ho'osu̱ndu̱ no̱ ka wan-ho̱ u̱n hun-ne̱ wu̱. ");
INSERT INTO uth_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","No̱ ho̱o̱ru̱ wu̱ ro̱ shi'it-de u̱n ho̱o̱g-o̱ u̱n ba m-ta à. Amba Shir 'yonstu̱ wu̱ u̱t-marimar, te̱ komo te̱ u̱n swo̱-se u̱n wu̱ u̱n to̱ ka. ");
INSERT INTO uth_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","To̱, u̱n be̱e̱b-de u̱n jin-u̱r Ye̱so o̱, be-de m-she̱r u̱n wu̱, o̱ ya'e̱ ka ne̱t-wu̱ m-'wo̱ns. Ne̱t-wu̱ ka, no̱ nepstu̱ wu̱. Be-de u̱n m-she̱r be-u̱r Ye̱so, ka ne̱t-wu̱ waragte̱ ke̱rke̱r. Myet-m no̱, no̱ hyeneste̱. ");
INSERT INTO uth_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“O̱r re ne̱, u̱m nepste̱ u̱n ko̱o̱b-de u̱s-nap no̱ no̱me̱ to̱ ka, kaane̱ se̱k-ye̱ no̱ no̱me̱. ");
INSERT INTO uth_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Amba u̱n kaane̱ Shir shooste̱ rii-yo wu̱ rwo̱re̱ u̱n nu-o̱ u̱n yan-rwo̱r u̱n ma-to̱ u̱n wu̱ à kap u̱nze, Kiristi, wu̱a su̱ u̱r-ko̱o̱b. ");
INSERT INTO uth_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","U̱n remen kaane̱ se̱, no̱ yage̱ u̱r-ba'as, no̱ waktu̱ne̱ be-de Shir remen a so'osté̱ ba'as-u̱t no̱, ");
INSERT INTO uth_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","komo remen Wan-Ko̱yan wu̱ he no̱ do ye̱ u̱n jaab-o̱ u̱t-me̱n. Wu̱a tomon no̱ Kiristi dagan-mo̱ u̱n cin n-ga, wu̱ ro̱ Ye̱so. ");
INSERT INTO uth_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Depete̱ se̱ Ye̱so she'essu̱te̱ n-To̱n shir, har da-o̱ a he muut u̱s-rem u̱s-pu̱ se kap à, bo̱ Shir rwo̱re̱ cin u̱n n-ga à, u̱n nu-o̱ u̱n yan-rwo̱r u̱n Ma-to̱ Shir ye̱ u̱n ba m-ku̱ko̱p. ");
INSERT INTO uth_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Remen Mosa ze̱e̱g, ‘Yawe Shir no̱ wu̱a tomon no̱ wu̱ ken wan-rwo̱r u̱n Ma-to̱ Shir wu̱ kane̱ be-u̱r o̱r no̱, u̱ntu̱n me̱. Raks no̱ kap o̱ u̱n rii-yo wu̱ he no̱ m-ru̱re̱ à. ");
INSERT INTO uth_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Komo bo̱n wu̱ yage̱ raks u̱n ka wan-rwo̱r u̱n Ma-to̱ Shir wu̱ à, a ruut wu̱ n-me̱ u̱n bu̱u̱g-de u̱n hun-ne̱ ye̱ Shir.’ ");
INSERT INTO uth_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","“O-nip, bo̱ u̱n yan-rwo̱r u̱n Ma-to̱ Shir ye̱ no̱me̱ u̱t-hyangan à, cin u̱n Sama'era, u̱n ye̱ do̱nde̱ ne̱ n-jim à, myet ye̱ nomoste̱ ma-to̱ u̱n kà ho̱-to̱. ");
INSERT INTO uth_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Hyangan-to̱ a no̱me̱ be-de u̱n yan-rwo̱r u̱n Ma-to̱ Shir à, rem no̱ o̱, no̱ ye̱ komo he re̱ u̱n cim-yo tat-ne̱ no̱, yo Shir swo̱re̱ o-nu u̱n ye̱ ne̱ à. Ká to̱ wu̱ zette̱ Ibrahi, ‘U̱n baag-o ru a hette̱ 'ya u̱n baag-to̱ u̱n hun-ne̱ ye̱ u̱n ho̱no o-dak o-kwu̱m.’ ");
INSERT INTO uth_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Bo̱ Shir daage̱ ko-gu̱w-wu̱ u̱n wu̱ à, wu̱ ciru̱ wu̱ m-to̱mo̱n be-u̱r no̱ remen wu̱ ye'et no̱ o-kwu̱m, wu̱ rwu̱ntu̱te̱ ko̱ wu̱ ke be-de u̱n co̱w-se u̱n me̱n-u̱t jaas-to̱.” ");
INSERT INTO uth_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Da-o̱ Bitrus ne̱ u̱n Yohana ro u̱t-ma u̱n hun-ne̱ ne̱ à, yan-Co̱w u̱n ko̱n-se Shir u̱n ko-caari-wu̱ u̱n yan-'er-de u̱n Pyo-o̱ Shir ne̱, u̱n Saduki-ne̱ ne̱ haanu̱ru̱ be-de u̱n ye̱. ");
INSERT INTO uth_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Ye̱ ho̱gu̱te̱ u̱s-ryaab remen yan-neke̱-m Ye̱so ro u̱n yoose̱ u̱n bu̱u̱g-de u̱n hun-ne̱ u̱nze marimar-ne̱ a ine̱ u̱n ho̱o̱g ne̱ bo̱ Ye̱so ine̱ à. ");
INSERT INTO uth_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Ye̱ argu̱ m-ship u̱n Bitrus u̱n Yohana. Ye̱ tigi ye̱ se̱ gas-o̱ ish, bo̱ rim-m ro nomoste̱ à. ");
INSERT INTO uth_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Amba hun-ne̱ de̱e̱n be-de u̱n ye̱ ho̱ge̱ ma-u̱t Ye̱so à ye̱ she̱ru̱ o-nip. Kap mo̱o̱r-to̱ yan-dor Ye̱so wo̱o̱ru̱ u̱ntu̱n campo̱-ne̱ dugu-u̱s taan 5,000. ");
INSERT INTO uth_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Gas-o̱ ish, gwo̱mo-ne̱ u̱n se̱k-ye̱ ne̱ u̱n ye̱ ne̱, u̱n yan-yoos-de u̱n karamsa-to̱ u̱n ye̱ ne̱, ye̱ mo̱rgu̱ru̱ o-Urusharima. ");
INSERT INTO uth_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Annas, ko-Gwo̱mo-wu̱ u̱n ko̱n-se Shir, wu̱ ro kane̱ be-u̱r gaan u̱n Ke̱pas, Yohana ne̱, u̱n Arekanda, komo u̱n ye̱ ro ne̱ baag-o̱ u̱n Gwo̱mo-ne̱ ye̱ u̱n ko̱n-se Shir à. ");
INSERT INTO uth_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Ye̱ rwo̱'u̱ Bitrus ne̱ u̱n Yohana m-e̱s u̱n te̱te̱-de u̱n ye̱. Ye̱ citu̱ru̱ ye̱, ye̱ zee, “¿U̱n to̱ ke gwo̱mo-to̱ o̱, ko̱ ne̱ u̱n de ke jin-de no̱ nomte̱ ka se̱nge̱-mo̱?” ");
INSERT INTO uth_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Bitrus shiishe̱ u̱n Ku̱kt-o̱ Shir ne̱, wu̱ citu̱ ye̱. Wu̱ zee, “No̱ gwo̱mo-ne̱ u̱n se̱k-ye̱ ne̱ ye̱ u̱n hun-ne̱! ");
INSERT INTO uth_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Caane̱ so̱k-mo̱ a nome̱ ka ko-ryam-wu̱ à, ¿mo̱ mo̱ no̱ te̱ u̱s-cot o̱? ¿Komo no̱ u̱n co̱n no̱ nep wu̱ dosse̱ wu̱ ka go̱m-o̱? ");
INSERT INTO uth_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Te̱ co̱no̱g no̱ nep u̱n kap o̱ u̱n hun-ne̱ ye̱ o-Isra-ne̱ o-nip. Yo hante̱ kà ne̱t-wu̱ ro̱tte̱ eso ke̱rke̱r u̱n co-o no̱ à, n-me̱ u̱n jin-u̱r Ye̱so Kiristi ko-Nazaret o̱, wu̱ no̱ kame̱ à, wu̱ Shir 'yonse̱ u̱t-marimar à. ");
INSERT INTO uth_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Ka Ye̱so-wu̱, wu̱ ro̱: “ ‘Ka pam-yo, yo ya-u̱t-mà yage̱ à, amba m-mo̱ka yo yo komo arge̱ u̱r-bon be-de u̱n pam-ye̱ u̱t-mà.’ ");
INSERT INTO uth_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Yatt komo be-de a he kum u̱n gwu̱ á, be-de u̱n jin-to̱ a ya'e̱ hun-ne̱ ye̱ u̱n ho̱no o-dak kap à. Yatt jin-de a ya'ase̱ de a ze̱e̱ se̱ be-de u̱n de a he kum u̱n gwu̱ á, se̱ be-u̱r Ye̱so.” ");
INSERT INTO uth_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","To̱, bo̱ se̱k-ye̱ hyente̱ jaab-o̱ u̱n me̱n-u̱t Bitrus u̱n Yohana ne̱ à, komo ye̱ napu̱ru̱ u̱nze ye̱ ya-u̱s-nap-ye̱ de̱e̱n á, ko̱o̱b-ne̱ ye̱ komo, ye̱ bo̱pu̱ o-nu, ye̱ napu̱ru̱ ye̱ she'ete̱ u̱n Ye̱so ne̱. ");
INSERT INTO uth_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Amba bo̱ se̱k-ye̱ hyente̱ ka ne̱t-wu̱ a taase̱ u̱t-ryam à, wu̱ ro̱ eso be-u̱r gaan u̱n yan-To̱m Ye̱so ne̱, ye̱ taagu̱ gom-de m-ce̱p. ");
INSERT INTO uth_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Ye̱ ze̱e̱ru̱ yan-To̱m Ye̱so ye̱ ru u̱n ka be-de u̱n Mo̱ro̱g-de u̱n Se̱k-ye̱ de, ye̱ no̱mu̱ru̱ u̱t-orom u̱n o̱r u̱n ye̱ ne̱ ne̱. ");
INSERT INTO uth_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Ye̱ ze̱e̱ru̱, “¿Re o̱ a he no̱ m-no̱m u̱n ka hun-ne̱ ye̱ ne̱? Remen u̱n cen o̱ bo̱ u̱n kap o̱ u̱n ya-u̱r-she'et o-Urusharima nepste̱ u̱nze a no̱mo̱g yo ken rii-yo o-made̱ yo be-de u̱n ka hun-ne̱ ye̱. Yatt komo bo̱ a he m-ze̱e̱ ‘Ba kaane̱ o̱ á.’ ");
INSERT INTO uth_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Amba u̱n cen o̱ taase ka rii-yo se̱nge̱-m wo̱ n-me̱ u̱n hun-ne̱, se̱ a nek ye̱ u̱t-to̱, taase ba'asu̱ ye̱, ye̱ do nome̱ u̱n ne̱t u̱t-ma n-me̱ u̱n ka jin-de.” ");
INSERT INTO uth_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Ye̱ dooru̱ agbe̱ u̱n yan-To̱m Ye̱so, ye̱ naku̱ ye̱ u̱t-to̱, taase ba'asu̱ ye̱, ye̱ nome̱ ne̱t u̱t-ma, ko̱ ye̱ do u̱r-yoos n-me̱ u̱n jin-u̱r Ye̱so. ");
INSERT INTO uth_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Amba Bitrus ne̱ u̱n Yohana shasu̱ru̱, ye̱ zee, “To̱, ¿ko̱ hond hond o̱ be-de Shir te̱ jiish m-ho̱ge̱ u̱n ma-u̱t no̱ arge̱ Ma-to̱ Shir? Ceker no̱ u̱r-bon ne̱. ");
INSERT INTO uth_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Te̱a hoks m-she'et temb u̱n rii-yo te̱ ho̱gu̱sse̱, komo te̱ hyenes á.” ");
INSERT INTO uth_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Bo̱ ye̱ dotte̱ ye̱ nak u̱t-to̱ à, ye̱ argu̱ ye̱ m-ho'os. Ye̱ taagu̱ru̱ bo̱ ye̱ he m-no̱m ye̱ ye'et ye̱ u̱r-ko̱o̱b à, remen kap o̱ u̱n hun-ne̱ ro u̱n se̱ke̱mse̱ u̱n jin-de Shir remen rii-yo ko̱re̱ à. ");
INSERT INTO uth_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Ye̱ bo̱mo̱g Shir remen ka ne̱t-wu̱ a taase̱ go̱m, o-made̱ à, wu̱ aragte̱ u̱s-hak kwo̱o̱z-u̱t yoor 40 bo̱ o-mat. ");
INSERT INTO uth_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Bo̱ a ho'oste̱ Bitrus ne̱ u̱n Yohana à, ye̱ argu̱ m-neke̱ be-de u̱n hun-ne̱ ye̱ u̱n ye̱. Ye̱ argu̱ ye̱ m-ru̱re̱ kap o̱ u̱n bo̱ u̱n rii-yo Gwo̱mo-ne̱ ye̱ u̱n ko̱n-se Shir, u̱n ye̱ ro se̱k-ye̱ ne̱ ru̱ru̱ ye̱ à. ");
INSERT INTO uth_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Bo̱ ye̱ ho̱ge̱ kaane̱ à, ye̱ daku̱ co̱r-se u̱n ye̱ n-to̱n Shir. Ye̱ ze̱e̱ru̱, “Wan-Ko̱yan, Wa-u̱t-Gwo̱mo kap, wo̱ wu̱ no̱me̱ o-To̱n o-dak ne̱, m-sa ne̱, komo u̱n kap o̱ u̱n rem-se ro̱ n-me̱ u̱n to̱ à. ");
INSERT INTO uth_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","U̱n Ku̱kt-o̱ Shir o no̱me̱ u̱t-ma u̱n ko-gu̱w ru ne̱ wu̱ ro̱, tato te̱ Dawuda à, o zee, “ ‘¿Remen ya u̱n o̱ ye̱ ro̱ Yahuda-ne̱ á ye̱ nomte̱ u̱s-ryaab? ¿Hun-ne̱ komo ye̱ nom barag-se u̱n co̱w-se o-hwaa? ");
INSERT INTO uth_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Gwo̱mo-ne̱ ye̱ u̱n ho̱no o-dak dek zo̱nge̱-to̱ m-dum, se̱k-ye̱ ye̱ u̱n ye̱ komo ye̱ mo̱ssu̱ u̱t-hi, u̱s-ryaab u̱n Yawe ne̱, komo u̱n Kiristi.’ ");
INSERT INTO uth_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Nip-o̱, u̱n bo̱-o̱ Urusharima ko-Gwo̱mo Here̱ Atipas u̱n Panti Biratus ne̱ ye̱ mo̱ssu̱te̱ u̱t-hi u̱n ye̱ ro̱ Yahuda-ne̱ á, u̱n hun-ne̱ ye̱ o-Isra-ne̱, ye̱ ro̱ u̱s-ryaab u̱n ko-gu̱w ru ne̱ Ye̱so, wu̱ ba m-ku̱ko̱p, wu̱ o daagne̱ à. ");
INSERT INTO uth_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Ye̱ u̱n no̱m u̱n yo be̱e̱b u̱n du u̱n hur u̱n du ne̱ e̱sse̱ m-no̱m à cin n-ga ne̱ ne̱. ");
INSERT INTO uth_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","M-mo̱ka komo, Wan-Ko̱yan, gwo̱t bo̱ ye̱ ro̱ u̱n se̱nge̱-mo̱ ye̱ ye'et te̱ u̱r-ko̱o̱b à, 'ya gu̱w-ne̱ ru be̱e̱b-de u̱s-rwu̱n de u̱n rwo̱r u̱n ma-u̱t ru ba o-gye̱r. ");
INSERT INTO uth_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Se̱nge̱ tapan u̱n kom-o ru o̱ u̱n taas u̱s-go̱m, no̱m komo rem-se o-made̱, u̱n rem-se u̱t-hyat ne̱ u̱n jin-u̱r ko-gu̱w ru Ye̱so wu̱ ro̱ ba m-ku̱ko̱p à.” ");
INSERT INTO uth_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Bo̱ ye̱ nomte̱ ko̱n-se Shir à, ka be-de ye̱ rotte̱ u̱r-mo̱ro̱g à, de nuktu̱ru̱. Kap mo̱ u̱n ye̱ argu̱ m-shi u̱n Ku̱kt-o̱ Shir, ye̱ se̱ngu̱ rwo̱r u̱n ma-to̱ Shir ba o-gye̱r. ");
INSERT INTO uth_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Myet yan-dor Ye̱so hur-to̱ u̱n ye̱ ro kang-o gaan u̱n barag-se u̱n ye̱ ne̱. Yatt-wu̱ ze̱e̱ rii-yo wu̱ ro̱tte̱ à, yo ma u̱n wu̱ yo u̱n ho̱n du u̱n wu̱ á, amba ye̱ ro̱ m-wong u̱n o̱r u̱n ye̱ ne̱ myet yo ye̱ ro̱tte̱ à. ");
INSERT INTO uth_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","U̱n be̱e̱b-de u̱n Ku̱kt-o̱ Shiryan-To̱m Ye̱so se̱ngu̱ru̱ rwo̱r u̱n ma-to̱ u̱n ine̱-m Wan-Ko̱yan Ye̱so u̱t-marimar. Yar-mo̱ Shir ho̱ku̱ru̱ yan-dor Ye̱so myet-mo̱ u̱n ye̱. ");
INSERT INTO uth_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Har yatt-wu̱ taage̱ u̱n yo ken rii-yo be-de u̱n ye̱ á. Remen kap ya-u̱t-kat ko̱ ya-u̱t-hur ye̱ se̱ngu̱tu̱ to̱ m-baab, ye̱ u̱n hante̱ hwo̱r. ");
INSERT INTO uth_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Ye̱ ro m-e̱ss be-de u̱n yan-To̱m Ye̱so, komo a ma'asu̱ m-wong a ya'as ko̱wan wu̱ taage̱ u̱n yo ken rii-yo u̱r-she'et yo à. ");
INSERT INTO uth_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Kaane̱ wu̱ ken wu̱ no̱me̱ jin-de u̱n wu̱ Yusuhu. Wu̱ ko-Rewi-wu̱, takan-de u̱n wu̱ ko-ya-o-Sayipurus-wu̱, wu̱ yan-To̱m Ye̱so ro m-aag Barnabas à, (U̱nze, Wan-do'e̱ u̱r-hur jaab-o̱ u̱t-me̱n.) ");
INSERT INTO uth_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Wu̱ komo wu̱ bak o̱ ken kat-o̱ u̱n wu̱ o̱, wu̱ hantu̱ru̱ hwo̱r, wu̱ e̱ssu̱ru̱ be-de yan-To̱m Ye̱so. ");
INSERT INTO uth_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Amba wu̱ ken ne̱t-wu̱ jin-de u̱n wu̱ Hananiya u̱n ne'a u̱n wu̱ ne̱ Sapiratu, bak rii-yo ye̱ ro̱tte̱ à. ");
INSERT INTO uth_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Wu̱ wuku̱ru̱ ye̱ ken hwo̱r-ye̱ be-de u̱n ka hwo̱r-ye̱ u̱n nap-o ne'a u̱n wu̱ ne̱. Wu̱ hantu̱ru̱ o-gyes cot, wu̱ ya'asu̱ru̱ yan-To̱m Ye̱so. ");
INSERT INTO uth_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Bitrus ze̱e̱ru̱, “Wo̱ Hananiya, ¿re nome̱ o yagu̱te̱ ko-Gwo̱mo-wu̱ u̱n ya-u̱t-ko̱t cu̱wu̱t u̱n hur u̱n du, har o nomote̱ Ku̱kt-o̱ Shir u̱t-bo̱, komo o wukute̱ ye̱ ken ye̱ be-de u̱n ka hwo̱r-ye̱ o-kat ye̱? ");
INSERT INTO uth_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Rii-yo o bept o̱, ¿o̱ ma ru o̱ ka? Bo̱ o bepse̱ à, ¿a u̱n mo̱ wo̱ u̱s-co̱r o hante̱ hwo̱r? ¿Re o no̱me̱ o nomot se̱ ka barag-se u̱n hur u̱n du ne̱? Ay, ne̱t-wu̱ o nome̱ u̱t-bo̱ á, Shir-o̱ o nome̱.” ");
INSERT INTO uth_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Bo̱ u̱n ho̱ge̱ u̱n ka ma-to̱, Hananiya he̱e̱ru̱ n-dak, wu̱ maru̱ru̱. Hun-ne̱ ye̱ ho̱ge̱ ka ma-to̱ à, gye̱r-o ho̱o̱ru̱ ye̱ de̱e̱n. ");
INSERT INTO uth_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Be̱e̱b-ye̱ inu̱ru̱ ye̱ yeru̱ u-de u̱n wu̱ o-gund. Ye̱ ruutu̱ wu̱ n-do̱, ye̱ jo̱ku̱ru̱. ");
INSERT INTO uth_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Hohond-mo̱ u̱n awa-u̱s tet se arge̱ à, ne'a Hananiya co̱wnu̱ru̱. Wu̱ nap yo ko̱re̱ á. ");
INSERT INTO uth_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Bitrus ze̱e̱ru̱ wu̱, “¿Ru̱ru̱ me̱ ko̱m-de ka rii-yo a to̱pu̱ no̱ u̱n ká kat-o̱?” Wu̱ ze̱e̱ru̱, “E̱e̱, ta-de u̱n ye̱ de ka.” ");
INSERT INTO uth_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Amba Bitrus ze̱e̱ru̱ wu̱, “¿Re no̱me̱ no̱ mo̱ssu̱te̱ o-nu no̱ megerté̱ Ku̱kt-o̱ Wan-Ko̱yan? Ka hun-ne̱ ye̱ jo̱ke̱ campo̱ ru à, ye̱ u̱n he̱r-o̱ u̱n ish, de̱k-mo̱ ye̱ he wo̱ komo ye̱ ruut wo̱.” ");
INSERT INTO uth_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Ba u̱n naas o-da, wu̱ he̱e̱ru̱ u̱n na-se u̱n wu̱, wu̱ maru̱ru̱. Bo̱ be̱e̱b-ye̱ co̱wo̱nte̱ à, ye̱ 'wo̱s wu̱ mereste̱. Ye̱ argu̱ wu̱ m-keps, ye̱ ruutu̱ru̱ wu̱, ye̱ jo̱ku̱ wu̱ n-riib campo̱ u̱n wu̱. ");
INSERT INTO uth_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Gye̱r-o ho̱o̱ru̱ kap o̱ u̱n hun-ne̱ yan-dor Ye̱so u̱n bo̱ u̱n ye̱ ho̱ge̱ ka ma-to̱ u̱n ka rem-se ne̱ à. ");
INSERT INTO uth_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Yan-To̱m Ye̱so no̱mo̱g u̱s-napa u̱n rem-se o-made̱ ne̱ u̱t-mo̱o̱r ne̱ be-de u̱n hun-ne̱. Myet-mo̱ yan-dor Ye̱so ro we̱tse̱ m-mo̱rge̱ u̱n sak-o Suremanu u̱n be-de u̱n Pyo-o̱ Shir. ");
INSERT INTO uth_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Amba n-me̱ gyes-o̱ u̱n hun-ne̱, yatt-wu̱ no̱me̱ jaab-o̱ u̱t-me̱n o̱ wu̱ mossu̱te̱ u̱r-hi u̱n yan-dor Ye̱so ne̱ á. Myet u̱n kaane̱ ne̱, komo hun-ne̱ ro ye̱ u̱n 'ya m-se̱k. ");
INSERT INTO uth_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Myet u̱n kaane̱ ne̱, ya-m-she̱r o-nip be-de u̱n Wan-Ko̱yan ye̱ se̱ngu̱ m-do̱ u̱t-mo̱o̱r, campo̱-ne̱ u̱n ne'a-ne̱ ne̱. ");
INSERT INTO uth_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Har wo̱o̱ru̱ hun-ne̱ ro m-rwu̱u̱n u̱n ya-u̱s-go̱m ne̱ u̱s-co̱w, ye̱ ro ye̱ m-neks n-te̱ u̱t-pu̱t, u̱t-karanga ne̱. Ye̱ o-sakto̱ ye̱ zee Bitrus wu̱ arge̱, horomte̱-o̱ u̱n wu̱ a ci ye̱ ken ye̱. ");
INSERT INTO uth_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Hun-ne̱ u̱t-mo̱o̱r ne̱ ma'asu̱ru̱ m-mo̱rge̱ u̱n ka bo̱-to̱ ro u̱n he̱r-o̱ o-Urusharima à. Ye̱ ro u̱n hante̱ u̱n ya-u̱s-go̱m u̱n ye̱ ya-u̱t-ko̱t ro ne̱ u̱n ya-u̱r-ko̱o̱b à, myet-mo̱ u̱n ye̱, a taasu̱ ye̱ go̱m-se u̱n ye̱. ");
INSERT INTO uth_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Ko-Gwo̱mo-wu̱ u̱n ko̱n-se Shir u̱n ka ye̱ wu̱ ro̱tte̱ ne̱ be-u̱r gaan à, (a ye̱ m-ze̱e̱, bu̱u̱g-de u̱n Saduki-ne̱), ye̱ shiiru̱ u̱n shoob-de u̱n yan-To̱m Ye̱so de̱e̱n. ");
INSERT INTO uth_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Remen kaane̱, ye̱ shipu̱ru̱ yan-To̱m Ye̱so, ye̱ rwo̱'u̱ru̱ ye̱ n-me̱ u̱n kur-o m-ke'et. ");
INSERT INTO uth_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Amba bo̱ te̱t-m wo̱o̱nte̱ à, wu̱ ken wan-to̱m-wu̱ Wan-Ko̱yan wu̱ tikshiru̱ ish-o u̱n kur-o̱ a ke'ete̱ ye̱ à. Wu̱ rwu̱ntu̱ ye̱, wu̱ ze̱e̱ru̱, ");
INSERT INTO uth_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Neke̱ no̱, no̱ es n-me̱ u̱n Pyo-o̱ Shir no̱ ru̱re̱ hun-ne̱ ma-to̱ u̱n kà ho̱o̱g-m pu̱-mo̱ mo̱.” ");
INSERT INTO uth_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Bo̱ ye̱ ho̱gu̱te̱ kaane̱ à, ye̱ co̱wu̱ru̱ Pyo-o̱ Shir n-sot, ye̱ ro̱ m-yoose̱ u̱n hun-ne̱. Bo̱ ko-Gwo̱mo-wu̱ u̱n ko̱n-se Shir u̱n ye̱ ro̱ be-u̱r gaan u̱n wu̱ ne̱ mo̱rgu̱te̱ à, ye̱ agnu̱ru̱ Mo̱ro̱g-de u̱n Se̱k-ye̱, u̱n kap o̱ u̱n se̱k-ye̱ ye̱ o-Isra-ne̱, ye̱ to̱mu̱ru̱ u̱n kur-o̱ m-ke'et a haante̱ yan-To̱m Ye̱so. ");
INSERT INTO uth_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Amba bo̱ yan-'er-de u̱n Pyo-o̱ Shir heete̱ à, ye̱ 'wo̱s ye̱ u̱n kur-o̱ m-ke'et á. Ye̱ mu̱u̱nu̱ru̱. Ye̱ rwo̱ru̱ru̱, ye̱ ze̱e̱ru̱, ");
INSERT INTO uth_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Te̱ u̱n 'wo̱s a tigu̱su̱te̱ ish de̱e̱n de̱e̱n, yan-'er-de o-kur komo ye̱ ro u̱n 'er-de u̱s-ish. Amba bo̱ te̱ tikshe̱ à, te̱ 'wo̱s ko̱ ne̱t n-me̱ á.” ");
INSERT INTO uth_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Bo̱ caari-wu̱ u̱n yan-'er-de u̱n Pyo-o̱ Shir u̱n Gwo̱mo-ne̱ ye̱ u̱n ko̱n-se Shir ne̱ ho̱gu̱te̱ kaane̱ à, hur-u̱r do̱'u̱ru̱ ye̱ de̱e̱n. Ye̱ ro u̱n barag-se u̱n rii-yo to̱ ka he m-hante̱ à. ");
INSERT INTO uth_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Wu̱ ken wu̱ haanu̱ru̱, wu̱ ze̱e̱ru̱ ye̱, “Ai, ka hun-ne̱ ye̱ ka re̱e̱no̱ ka ye̱ no̱ tige̱ u̱n kur-o̱ m-ke'et à, ye̱ eso eso n-me̱ u̱n Pyo-o̱ Shir, ye̱ ro̱ m-yoose̱ u̱n hun-ne̱.” ");
INSERT INTO uth_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Caari-wu̱ u̱n yan-'er-de u̱n Pyo-o̱ Shir u̱n ya-u̱r-'er ne̱, ye̱ haaru̱ ye̱ de̱knu̱ yan-To̱m Ye̱so, amba yanze u̱r-be̱e̱b á, u̱n remen ye̱ ro o-gye̱r taase hun-ne̱ jir ye̱ u̱t-ta'ar. ");
INSERT INTO uth_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Bo̱ ye̱ de̱ke̱nte̱ yan-To̱m Ye̱so à, ye̱ rwo̱'u̱ ye̱ m-e̱s u̱n co-o̱ u̱n Mo̱ro̱g-de u̱n Se̱k-ye̱. Ko-Gwo̱mo-wu̱ u̱n ko̱n-se Shir citu̱ru̱ ye̱. ");
INSERT INTO uth_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","Wu̱ ze̱e̱ru̱, “Te̱ nak no̱ u̱t-to̱ de̱e̱n de̱e̱n taase no̱ do u̱r-yoos u̱n ka jin-u̱r Ye̱so de. Amba ko̱wan o-Urusharima nepste̱ rii-yo no̱ u̱r-yoos à, har ma hoob-o̱ no̱tte̱ no̱ duusu̱tu̱ te̱ ra-o̱ u̱n hyó-mo̱ u̱n ka ne̱t-wu̱.” ");
INSERT INTO uth_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Amba Bitrus u̱n yan-To̱m Ye̱so ne̱ shasu̱ru̱, ye̱ zee, “Jip o̱ te̱ nomote̱ Shir o-do̱ro̱tte̱ arge̱ bo̱ te̱ he nome̱ u̱n ne̱t à! ");
INSERT INTO uth_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Shir tat-ne̱ na 'yonste̱ Ye̱so u̱t-marimar, ka wu̱ no̱ ho̱'e̱ ku̱nkam u̱n o̱go̱-kan o-ce à. ");
INSERT INTO uth_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Shir deete̱ wu̱ u̱n re̱-de u̱n wu̱, Ye̱so waragte̱ Se̱k-wu̱ komo ko-Wan-Gwu̱, remen wu̱ tiksu̱té̱ Isra-ne̱ co̱w-yo m-waktu̱ne̱ be-de Shir, komo ye̱ kumut a soksu̱ ye̱ ba'as-to̱ u̱n ye̱. ");
INSERT INTO uth_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Te̱ komo te̱ ro̱ yan-swo̱-se u̱n to̱ ka, Ku̱kt-o̱ Shir komo kaane̱, o̱ Shir ya'ase̱ yan-do̱ro̱tte̱-o̱ u̱n wu̱ à.” ");
INSERT INTO uth_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Bo̱ se̱k-ye̱ ho̱gu̱te̱ kaane̱ à, ye̱ ho̱gu̱ u̱s-ryaab de̱e̱n, har ye̱ cu̱n ye̱ ho yan-To̱m Ye̱so. ");
INSERT INTO uth_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Amba wu̱ ken ko-Parisa-wu̱ ro kon. Jin-de u̱n wu̱ Gamariyer. Wan-Yoos-de o-karamsa, ho̱n u̱n hun-ne̱ ye̱ ro wu̱ u̱n ya'as m-se̱k. Wu̱ inu̱ eso n-me̱ u̱n ka Mo̱ro̱g-de u̱n Se̱k-ye̱ de, wu̱ ze̱e̱ru̱ a ruut ka hun-ne̱ ye̱ n-do̱ u̱n ya o-da hiin. ");
INSERT INTO uth_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Ka da-o̱ wu̱ ze̱e̱ru̱ ka Mo̱ro̱g-de u̱n Se̱k-ye̱ de, “No̱ o̱r re Isra-ne̱, no̱m no̱ ja u̱n rii-yo no̱ co̱ne̱ nome̱ u̱n ka hun-ne̱ ye̱ à. ");
INSERT INTO uth_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Hak-se n-jim se arge̱ à, wu̱ ken ne̱t-wu̱ ru u̱r-jin à, jin-de u̱n wu̱ Tudas. Wu̱ hwo̱o̱g hi u̱n de u̱n wu̱ u̱r-ke̱e̱r. Be-de u̱n hun-ne̱ zungu-u̱s nass 400 ye̱ doru̱ru̱ wu̱, amba a ho̱o̱ru̱ wu̱. Komo a caas yan-dor-o̱ u̱n wu̱, to̱ ka komo to̱ no̱me̱ ko̱m-de u̱n ye̱. ");
INSERT INTO uth_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Bo̱ u̱n nom u̱n to̱ ka komo, wu̱ ken wu̱ ru u̱r-jin, jin-de u̱n wu̱ Yahudas, ko-ya-o-Gariri. Da-o̱ a ro u̱n o̱o̱g-de u̱n hun-ne̱ à, wu̱ rwo̱'u̱ru̱ hun-ne̱ ye̱ do̱ru̱ wu̱. Wu̱ ma a ho̱o̱ru̱ wu̱, yan-dor-o̱ u̱n wu̱ komo a caastu̱ ye̱ kap. ");
INSERT INTO uth_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","To̱, ko̱ m-mo̱ka me̱ no̱ m-ru̱re̱, yagu̱ no̱ ma-to̱ u̱n ka hun-ne̱ ye̱, yagu̱ no̱ ye̱. U̱rege̱ de̱ sakto̱-o̱ u̱n ye̱, ko̱ se̱nge̱-mo̱ u̱n ye̱ mo̱ u̱n ne̱t o̱, ai, mo̱a sabu̱rse̱. ");
INSERT INTO uth_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Amba u̱rege̱ ka se̱nge̱-mo̱ mo̱ Shir mo̱, no̱a hoks mo̱, ka hun-ne̱ ye̱ m-we̱n á. A 'wo̱s na hi u̱n na u̱t-ween u̱n Shir ne̱ á!” Ye̱ argu̱ de̱k u̱n ma-to̱ u̱n wu̱. ");
INSERT INTO uth_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Ye̱ agbu̱ yan-To̱m Ye̱so ye̱ nomu̱ ye̱ u̱s-so̱ro̱g. Ye̱ naku̱ru̱ ye̱ u̱t-to̱ taase ye̱ do no̱m u̱t-ma n-me̱ u̱n jin-u̱r Ye̱so á. Ka da-o̱ ye̱ argu̱ ye̱ m-ho'os. ");
INSERT INTO uth_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Yan-To̱m Ye̱so inu̱ru̱ u̱n ka Mo̱ro̱g-de u̱n Se̱k-ye̱ de, ye̱ ro̱ o-zak remen a hyanag ye̱, ye̱ bo̱'o̱se̱ ye̱ dek o-yo'og u̱n remen u̱n jin-u̱r Ye̱so. ");
INSERT INTO uth_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Ko̱ de ke ho̱-de, ko̱ u̱n Pyo-o̱ Shir, ko̱ o-hur, ye̱ yage̱ u̱r-yoos u̱n ko̱'o̱t u̱n Ma-to̱ m-Re̱re̱m ne̱ á. Ye̱ se̱nge̱ m-ze̱e̱ Ye̱so wu̱ ro̱ Kiristi. ");
INSERT INTO uth_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","To̱, u̱n ka ho̱-to̱, hun-ne̱ u̱t-mo̱o̱r ne̱ wargu̱ru̱ yan-dor Ye̱so. Yahuda-ne̱ yan-ho̱ge̱ u̱t-Girik nomu̱ru̱ Yahuda-ne̱ u̱s-hwu̱mu̱g ye̱ ro̱ u̱n ho̱ge̱ u̱n rem-de u̱t-Ibra à. Ye̱ u̱n no̱m kaane̱ remen a m-was u̱n ye̱ man ye̱ gwo̱r-ne̱ ye̱ u̱n ne'a-ne̱ da-o̱ u̱n wong u̱n rii-yo m-re̱ yo u̱n ko̱ de ke ho̱-de á. ");
INSERT INTO uth_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Ka o̱p u̱n ne̱n yoor-ye̱ agbu̱ru̱ hun-ne̱ kap yan-neke̱-m Ye̱so. Ye̱ ze̱e̱ru̱, “Ai, u̱ no̱m u̱r-bon a yage̱ ko̱'o̱t-m u̱n Ma-to̱ Shir a ma'aste̱ ma-to̱ u̱n rii-yo m-re̱ á. ");
INSERT INTO uth_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Remen kaane̱, o̱r re ne̱ daag no̱ hun-ne̱ ne̱n ta'yoor be u̱n no̱, ye̱ ro̱ u̱n kashi u̱r-hur ne̱ de u̱r-bon à, ye̱ shiishe̱ u̱n Ku̱kt-o̱ Shir komo u̱s-we̱e̱r ne̱ à, ye̱ a he m-ya'as u̱n ka se̱nge̱-mo̱ à. ");
INSERT INTO uth_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Te̱ komo te̱a muut u̱r-hi u̱n no̱m u̱n ko̱n-se Shir u̱n yoos u̱n Ma-to̱ Shir ne̱.” ");
INSERT INTO uth_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Hun-ne̱ kap ho̱gu̱ru̱ re̱re̱m-mo̱ u̱n ma-to̱ ye̱ rwo̱re̱ à. Ye̱ daagu̱ Istipanus (wu̱ ken ne̱t-wu̱ wu̱ she̱re̱g u̱n Ye̱so u̱r-be̱e̱b ne̱, komo Ku̱kt-o̱ Shir garamsu̱te̱ wu̱), u̱n Pirip ne̱, u̱n Buro̱ko̱ras ne̱, Nikano̱ ne̱, u̱n Timo̱n ne̱, Barminas ne̱, Niko̱ras (ko-ya-o-Antakiya, n-ga wu̱ ba ko-Yahuda-wu̱ á amba wu̱ waragte̱ ko-Yahuda). ");
INSERT INTO uth_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Ye̱ ka ye̱ a daage̱ u̱n co-o̱ yan-To̱m Ye̱so. Bo̱ ye̱ nomoste̱ ko̱n-se Shir à, ye̱ seku̱ru̱ ye̱ u̱t-kom. ");
INSERT INTO uth_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Ma-to̱ Shir komo to̱ se̱ngu̱ru̱ m-bo̱'o̱se̱. Mo̱o̱r-to̱ yan-dor Ye̱so komo n-me̱ o-Urusharima se̱ngu̱ m-do̱ ho̱r-m-ho̱r, yan-Co̱w u̱n ko̱n-se Shir u̱t-mo̱o̱r ne̱ komo ye̱ go̱ksu̱ru̱ ka she̱r-mo̱ u̱n ma-to̱ o-nip mo̱. ");
INSERT INTO uth_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","To̱, Istipanus, wu̱ ne̱t-wu̱ shiishe̱ u̱n yar-mo̱ Shir ne̱ u̱r-be̱e̱b ne̱. Wu̱ ro m-no̱m u̱n rem-se o-made̱ u̱t-hyat ne̱ n-me̱ u̱n hun-ne̱. ");
INSERT INTO uth_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Ye̱ ken ye̱ be-de u̱n kuke̱-o̱ u̱r-mo̱ro̱g o̱ a m-ze̱e̱ Kuke̱-o̱ u̱n ye̱ Possu̱sse̱ à, ye̱ he̱'e̱bu̱ru̱ Istipanus u̱t-ween. Ye̱ ka komo Yahuda-ne̱ ye̱ ye̱ o-Kire̱ni u̱n ye̱ o-Arekzandiriya ne̱, komo u̱n ye̱ u̱n dak-o̱ o-Kirikiya ne̱, u̱n ye̱ o-Asiya ne̱. ");
INSERT INTO uth_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Amba, ye̱ bo'os u̱t-ween u̱n wu̱ ne̱ á, remen ma-to̱ u̱n wu̱ to̱ u̱s-nap to̱, Ku̱kt-o̱ Shir ciriru̱ u̱n hi-de u̱n wu̱. ");
INSERT INTO uth_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Ye̱ swo̱wu̱ru̱ ye̱ ken hun-ne̱ ye̱ wukusse̱ u̱n remen ye̱ zeet, “Te̱ ho̱gu̱te̱ wu̱ u̱n re̱e̱b-u̱t Mosa, komo wu̱ ro̱ Shir u̱n nome̱ u̱n ma-to̱ o-yo'og.” ");
INSERT INTO uth_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","U̱n kaane̱, ye̱ 'yonsu̱ hur-de u̱n hun-ne̱, u̱n se̱k-ye̱ ne̱, u̱n yan-Yoos-de o-karamsa ne̱. Ye̱ komo ye̱ daaru̱ wu̱, ye̱ shipu̱ wu̱. Ye̱ heetu̱ru̱ wu̱ be-de u̱n Mo̱ro̱g-de u̱n Se̱k-ye̱. ");
INSERT INTO uth_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Ye̱ ken se̱k-ye̱ be-de u̱n hun-ne̱ haaru̱ ye̱ deknu̱ru̱ yan-swo̱-se u̱t-bo̱, ye̱ ken ye̱ ze̱e̱ru̱, “Ka ne̱t-wu̱ ko̱ de ke ho̱-de wu̱ ro̱ u̱n hun-to̱ o-saa n-te̱ u̱n ka be-de ba m-ku̱ko̱p de komo u̱n karamsa-o Mosa ne̱. ");
INSERT INTO uth_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Te̱ ho̱gu̱te̱ wu̱ m-ze̱e̱ u̱nze ka Ye̱so-wu̱ o-Nazaret-wu̱ wu̱a wurumse̱ ka be-de, komo wu̱ wakse̱ kap o̱ u̱n jor-se Mosa, wan-Rwo̱r u̱n Ma-to̱ Shir, yaksu̱ na à.” ");
INSERT INTO uth_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Myet bo̱ u̱n ye̱ ro tara tara be-de u̱n Mo̱ro̱g-de u̱n Se̱k-ye̱ à, ye̱ ro wu̱ u̱n tu u̱n yish-ye̱ hyanu̱ co-o̱ u̱n wu̱ waksu̱te̱ u̱ntu̱n wan-to̱m-wu̱ Shir. ");
INSERT INTO uth_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Ko-Gwo̱mo-wu̱ u̱n ko̱n-se Shir citu̱ru̱ Istipanus wu̱ zee, “¿Ka rem-se, nip-o̱?” ");
INSERT INTO uth_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Istipanus ze̱e̱ru̱, “No̱ o̱r re ne̱ u̱n tat-ne̱ ne̱, raks me̱ no̱. Shir wan-se̱ps-mo̱ u̱t-gwo̱mo wu̱ rwu̱u̱nte̱ be-u̱r tato na Ibrahi da-o̱ wu̱ ro'e̱ u̱n dak-o̱ o-Me̱so̱po̱tami à, cin ba wu̱ ro she'ette̱ bo̱-o̱ o-Haran. ");
INSERT INTO uth_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Shir ze̱e̱ru̱ wu̱, ‘Ine̱ u̱n dak-o ru, o yage̱ hen-ne̱ ru ne̱, o neke̱ dak-o̱ u̱m he wo̱ m-ya'as à.’ ");
INSERT INTO uth_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","“Tato na Ibrahi argu̱ m-ine̱ u̱n dak-o̱ o-Kardiya, wu̱ argu̱ m-she'et u̱n bo̱-o̱ o-Haran. Bo̱n kane̱ komo, bo̱ tato̱ u̱n wu̱ mereste̱ à, Shir hantu̱ru̱ wu̱ u̱n ka dak-o̱ no̱tte̱ u̱r-she'et m-mo̱ka à. ");
INSERT INTO uth_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Amba ne̱ Shir 'ya Ibrahi ko̱ rii gaan-yo u̱n ka dak-o̱ á, ko̱ o-gaan. Amba wu̱ swo̱ro̱g o-nu u̱n Ibrahi wu̱a 'ye wu̱ ka dak-o̱ wu̱ u̱n baag-o̱ he m-do̱nd u̱n jim-de u̱n wu̱ ne̱ à. Shir swo̱ro̱g o-nu ko̱ de nomte̱ à Ibrahi rott wà u̱n ka da-o̱ á. ");
INSERT INTO uth_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Shir komo wu̱ rwo̱re̱ u̱nze baag-o Ibrahi a nom u̱r-hamat u̱n o̱ ken dak-o̱, hun-ne̱ ye̱ u̱n ka dak-o̱ komo ye̱a mus ye̱ gu̱w-ne̱, ye̱a 'ye ye̱ u̱r-ko̱o̱b har u̱s-hak zungu-u̱s nass 400. ");
INSERT INTO uth_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Shir ze̱e̱ru̱ wu̱a 'ye ka dak-o̱ ye̱ hette̱ m-gu̱w à u̱r-ko̱o̱b, kaane̱ nomse̱ komo baag-o Ibrahi a rwu̱u̱n ye̱ nome̱ Shir m-gu̱w u̱n kà be-de. ");
INSERT INTO uth_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Shir komo wu̱ e̱sste̱ u̱t-ma u̱n Ibrahi ne̱, ma-to̱ u̱r-ko̱. O̱ rwo̱'e̱ bo̱ Ibrahi mate̱ Ishaku à, wu̱ koot wu̱ u̱r-ko̱ u̱n ho̱-u̱r aeere̱-de. Ishaku matu̱ Yakubu, komo wu̱ matu̱ tat-ne̱ na ka o̱p u̱n ne̱n yoor-ye̱. ");
INSERT INTO uth_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Remen ka ya-n-ga-ye̱ ro u̱n shoob-u̱r heno u̱n ye̱ Yusuhu, ye̱ babu̱ wu̱. A heetu̱ wu̱ dak-o̱ o-Masar. Amba Shir ro mo̱sse̱ u̱n wu̱ ne̱. ");
INSERT INTO uth_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Komo wu̱ ruutu̱ wu̱ be-de u̱n kap o̱ u̱n swo̱ u̱r-ko̱o̱b o̱ u̱n wu̱. Shir rwo̱'u̱ru̱ komo wu̱ waktu̱ru̱ ko-ya-u̱s-nap. Wu̱ re̱e̱g u̱r-ho̱ be-u̱r ko-Gwo̱mo-wu̱ o-Masar. Ko-Gwo̱mo-wu̱ o-Masar ya'asu̱ wu̱ gwo̱mo-to̱ o-Masar. Komo wu̱ rwo̱'u̱ru̱ kap o̱ u̱n hun-ne̱ ye̱ u̱n hur-o̱ u̱n wu̱ u̱n kom-u̱t Yusuhu. ");
INSERT INTO uth_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","“A kane̱ me̱r he̱'e̱nu̱ru̱ u̱n myet o̱ u̱n dak-o̱ o-Masar u̱n o-Kan'ana-ne̱, mo̱sse̱ u̱n swo̱ u̱r-ko̱o̱b ne̱ de m-yo̱, har tat-ne̱ na taage̱ u̱n rii-yo m-re̱. ");
INSERT INTO uth_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Amba bo̱ Yakubu ho̱gu̱te̱ ye̱ge̱-hyo ro̱ ko̱n o-Masar à, wu̱ to̱mu̱ru̱ yakar-ye̱ u̱n wu̱, tat-ne̱ na ha-mo̱ o-Masar. De ka de ro hew-de u̱n ye̱ de u̱r-takan. ");
INSERT INTO uth_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","U̱n hew-de u̱n ye̱ de o ayoore̱-de, Yusuhu rwu̱ntu̱ hi u̱n de u̱n wu̱ cas be-u̱r se̱k-ye̱ ne̱ ye̱ u̱n wu̱ ne̱, ka da-o̱ ko-Gwo̱mo-wu̱ o-Masar napu̱ru̱ baag-o Yusuhu. ");
INSERT INTO uth_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Yusuhu to̱mu̱ru̱ tato u̱n wu̱ Yakubu wu̱ haan, komo u̱n kap o̱ u̱n se̱kke̱-ne̱ ye̱ u̱n wu̱ ne̱. War war-mo̱ u̱n ye̱ komo hun-ne̱ kwo̱o̱z-u̱t tet u̱n o̱p u̱n taan ye̱ 75. ");
INSERT INTO uth_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Yakubu argu̱ m-neke̱ o-Masar, re̱e̱no̱ wu̱ mare̱ u̱n tat na ne̱. ");
INSERT INTO uth_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","A kamsu̱nu̱ ye̱ a muutu̱ ye̱ o-She̱ke̱m, a rwo̱'u̱ru̱ ye̱ u̱n saag-o̱ Ibrahi o̱'e̱ u̱n hwo̱r-ye̱ o-azorpa à, be-u̱r yakar Hamor kane̱ o-She̱ke̱m. ");
INSERT INTO uth_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Amba bo̱ da-o nomte̱ yow yow o̱ Shir hette̱ shoos u̱n ka ma-to̱ wu̱ e̱sse̱ u̱n Ibrahi ne̱ à, hun-ne̱ na do̱o̱ru̱. Ye̱ no̱mu̱ u̱t-mo̱o̱r de̱e̱n u̱n dak-o̱ o-Masar. ");
INSERT INTO uth_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Ka da-de a no̱mu̱ wu̱ ken ko-Gwo̱mo-wu̱ o-Masar, wu̱ nape̱ ne̱t-wu̱ a m-ze̱e̱ Yusuhu á. ");
INSERT INTO uth_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Ka ko-Gwo̱mo-wu̱ re̱e̱g ra-o̱ u̱n hun-ne̱ na. Wu̱ rangsu̱te̱ tat-ne̱ na. Wu̱ ro m-rwo̱ a jorog yan-yakar-ye̱ u̱n ye̱ u̱n remen ye̱ meret. ");
INSERT INTO uth_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","“U̱n ka da-o̱ o̱ ka, a mate̱ Mosa, wà-wu̱ u̱t-campo̱. A no̱mu̱ gu̱t-de u̱n wu̱ re̱ng-u̱s tet u̱n hur-o tato u̱n wu̱. ");
INSERT INTO uth_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Bo̱ a ruutu̱ wu̱ n-do̱ à, wà wan-ne'a ko-Gwo̱mo-wu̱ o-Masar deku̱ wu̱, wu̱ gwo̱tu̱ wu̱ u̱ntu̱n wà u̱n wu̱. ");
INSERT INTO uth_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","A yoosu̱ru̱ Mosa kap o̱ u̱n nap-se u̱n ya-o-Masar. Wu̱ komo ne̱t-wu̱ u̱r-be̱e̱b ne̱ be-de rwo̱r u̱t-ma, u̱n rii-yo wu̱ ro m-no̱m ne̱ à. ");
INSERT INTO uth_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Bo̱ wu̱ woose̱ hak-u̱s kwo̱o̱z-u̱t yoor 40 à, wu̱ no̱mu̱ u̱s-barag wu̱ he wu̱ gas o̱r u̱n wu̱ u̱n Isra-ne̱. ");
INSERT INTO uth_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Bo̱ wu̱ hyente̱ wu̱ ken ko-ya-o-Masar-wu̱, wu̱ ro u̱n dum-mo̱ u̱n ko-Isra à, wu̱ haaru̱, wu̱ guut ko-Isra, wu̱ topotu̱ wu̱, wu̱ wo̱su̱ ko-ya-o-Masar. Wu̱ ho̱o̱ru̱ wu̱. ");
INSERT INTO uth_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Wu̱ hwo̱o̱ru̱ o-sakto̱ wu̱ zee o̱r u̱n wu̱ ne̱ a neps u̱nze Shir daage̱ wu̱ remen wu̱ guut ye̱. Amba hun-ne̱ ye̱ nap á. ");
INSERT INTO uth_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Bo̱ ish geste̱ komo à, wu̱ hyanu̱ru̱ ye̱ ken Isra-ne̱ ye̱ m-dum, wu̱ co̱nu̱ ye̱ m-hongse̱. Wu̱ ze̱e̱ru̱, ‘Campo̱-ne̱, no̱ hun-ne̱ gaan-ye̱ no̱ ro̱, ¿yan yo no̱tte̱ hi u̱n no̱ m-dum?’ ");
INSERT INTO uth_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","“Amba ka wu̱ ro o̱r u̱n wu̱ m-dum à, wu̱ tudbu̱ Mosa n-riib, wu̱ ze̱e̱ru̱, ‘¿Wa sagbu̱ wo̱ u̱t-gwo̱mo be u̱n te̱ o piishitu̱ te̱ u̱t-ma? ");
INSERT INTO uth_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Ashi, ¿wo̱ u̱n co̱n o hoot me̱ bo̱ o ho̱'e̱ ka ne̱t-wu̱ wu̱ m-ryo?’ ");
INSERT INTO uth_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Bo̱ Mosa ho̱gu̱te̱ kaane̱ à, wu̱ so̱mu̱ru̱ wu̱ she'etu̱ru̱ she'et-de u̱r-hamat u̱n dak-o o-Midiyan. Re̱e̱no̱ wu̱ mate̱ yakar yoor yan-campo̱-ne̱. ");
INSERT INTO uth_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“To̱, bo̱ a nomte̱ u̱s-hak kwo̱o̱z-u̱t yoor 40 à, wu̱ ken wan-to̱m-wu̱ Shir wu̱ haanu̱ru̱ be-u̱r Mosa u̱n rem-de o-ra, u̱n ya-o yo ken 'yo-yo u̱n o̱ ken ko̱t-o̱ yow yow u̱n Haag-o̱ o-Sinay ne̱. ");
INSERT INTO uth_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Bo̱ Mosa hyente̱ kaane̱ à, wu̱ bo̱pu̱ o-nu u̱n rii-yo wu̱ hyane̱ à. Bo̱ wu̱ hyoknu̱te̱ yow yow wu̱ gu̱t à, wu̱ ho̱gu̱ru̱ co̱r. Yawe ze̱e̱g, ");
INSERT INTO uth_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Me̱ wu̱ ro̱ Shir tat-ne̱ ru ne̱, Shir Ibrahi u̱n Ishaku, u̱n Yakubu ne̱.’ Wu̱r-o Mosa ciru̱ u̱s-zap, ko̱ m-gwo̱t ken wu̱ hoks á. ");
INSERT INTO uth_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","“Yawe ze̱e̱ru̱ wu̱, ‘Pos ka'ante̱-u̱t ru, u̱n remen ka be-de wo̱tte̱ eso à, be-de ba m-ku̱ko̱p de. ");
INSERT INTO uth_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","O-nip, u̱m hyanag ko̱o̱b-de a u̱n 'ya u̱n hun-ne̱ re ye̱ ro̱ o-Masar à. U̱m ho̱gu̱te̱ 'wo̱n-se u̱n ye̱, komo me̱ u̱n kergu̱ne̱ u̱m guut ye̱. To̱, m-mo̱ka se̱ o zo̱nge̱ u̱m tomot wo̱ ha-mo̱ o-Masar.’ ");
INSERT INTO uth_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“To̱, ka Mosa-wu̱, wu̱ ye̱ yage̱, ye̱ zee, ‘¿Wa sagbu̱ wo̱ u̱t-gwo̱mo be-u̱r na o piishitu̱ na u̱t-ma?’ Wu̱ Shir to̱mne̱ wu̱ re co, wan-ruut-wu̱, u̱n bu̱-yo u̱n wan-to̱m-wu̱ Shir wu̱ rwu̱u̱ne̱ be-de u̱n wu̱ u̱n ka ya o-'yo yo à. ");
INSERT INTO uth_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Da-o̱ wu̱ komse̱ no̱m u̱n rem-se o-made̱ u̱n dak-o̱ o-Masar à, wu̱ rwu̱ntu̱ ye̱. Komo u̱n saw-to̱ u̱t-hyat ne̱ u̱n dak-o̱ o-Masar, u̱n Ro̱o̱g-o Jaas-o̱ ne̱ komo n-me̱ o-ko̱t ne̱ har u̱s-hak kwo̱o̱z-u̱t yoor 40. ");
INSERT INTO uth_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","“Ka Mosa-wu̱, wu̱ ze̱e̱ Isra-ne̱, ‘Shir a deeg wu̱ ken wan-rwo̱r u̱n Ma-to̱ Shir wu̱ be-de u̱n hun-ne̱ no̱, u̱ntu̱n me̱.’ ");
INSERT INTO uth_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Mosa wu̱, wu̱ karakse̱ hun-ne̱ ye̱ o-Isra o-ko̱t. Wu̱ ro káne̱ u̱n tat-ne̱ na ne̱ komo u̱n ka wan-to̱m-wu̱ Shir wu̱ ne̱ wu̱ no̱me̱ u̱t-ma u̱n wu̱ ne̱ u̱n Haag-o o-Sinay à. Wu̱ wu̱ komo go̱ksu̱ne̱ ma-to̱ yan-ho̱o̱g be-de Shir wu̱ hantu̱ na. ");
INSERT INTO uth_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Amba tat-ne̱ na yagu̱ wu̱ nome̱ o-do̱ro̱tte̱, ye̱ 'yarag wu̱. Ye̱ ho̱gu̱ go̱p-de m-warag u̱n dak-o̱ o-Masar. ");
INSERT INTO uth_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Ye̱ ze̱e̱ru̱ Haruna, ‘Nomo na shir-ye̱ he na teke̱ co à. O nak ka Mosa-wu̱, wu̱ rwu̱ntu̱ na e̱s-mo̱ u̱n dak-o̱ o-Masar à, a nap rii-yo ko̱ru̱ wu̱ á.’ ");
INSERT INTO uth_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","U̱n ka da-o̱, ye̱ zwo̱ru̱ ye̱ ken shir-ye̱ u̱ntu̱n wu̱r-o̱ o-na. Ye̱ seku̱ ka gir-mo̱ u̱r-seke̱, ye̱ bo̱pu̱ o-zak u̱n se̱nge̱-mo̱ ye̱ no̱me̱ u̱n kom-to̱ u̱n ye̱ à. ");
INSERT INTO uth_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Remen kaane̱ Shir tuku ye̱ u̱r-jim, wu̱ mussu̱ ye̱ yan-gu̱w-mo̱ u̱n ye̱ge̱-re̱ge̱n. To̱ ka no̱mo̱g hond hond u̱n rii-yo ro̱ gense̱ ne̱ u̱n taku̱rda-o̱ u̱n yan-Rwo̱r u̱n Ma-to̱ Shir à u̱nze, “ ‘No̱ hun-ne̱ ye̱ o-Isra, ¿me̱ wu̱ no̱ pene̱ u̱t-gu̱t no̱ seke̱ u̱r-sake̱, har u̱s-hak kwo̱o̱z-u̱t yoor 40 n-me̱ o-ko̱t? ");
INSERT INTO uth_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Ay, ko̱ kene̱ no̱ ha no̱ u̱t-tu̱w u̱n de̱pi-o̱ u̱n to̱o̱g-o Morek, u̱n re̱ge̱n-yo to̱o̱g-o Ripan, ka to̱o̱g-se no̱ no̱me̱ à remen no̱ kwu̱ktu̱té̱ se. Remen kaane̱, man ru̱ a de̱k no̱ m-gu̱w u̱r-hew ne̱ co-o̱ o-Babira.’ ");
INSERT INTO uth_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“N-ga, tat-ne̱ na ro u̱r-de̱pi de ro u̱n kute̱ u̱n hun-ne̱ u̱nze Shir ro̱ mo̱sse̱ u̱n ye̱ ne̱ o-dákár à. A u̱n no̱m de bo̱ Shir ru̱re̱ Mosa wu̱ no̱m de à, hond hond bo̱ Shir kute̱ Mosa à. ");
INSERT INTO uth_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Da-o̱ Josuwa rumse̱ o-dak u̱n kom-to̱ ka hun-ne̱ ro u̱r-she'et u̱n ka dak-o̱ à, Shir yane̱ ye̱ u̱n yish-ye̱ u̱n Yahuda-ne̱. Ka de̱pi-de tat-ne̱ na 'wo̱o̱se̱ be-de u̱n ya-n-ga-ye̱ na à, ye̱ hantu̱ru̱ de u̱n ka dak-o̱. Ka de̱pi-de komo de ro ko̱n har haan-mo̱ u̱n da-o ko-Gwo̱mo Dawuda. ");
INSERT INTO uth_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Dawuda komo wu̱ kumug u̱r-ho̱ be-de Shir, har wu̱ no̱mo̱g u̱s-ko̱n be-de Shir remen wu̱ meet Pyo-o̱ Shir rem Shir Yakubu. ");
INSERT INTO uth_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Amba Suremanu wu̱ me'e̱ Shir u̱t-ma. ");
INSERT INTO uth_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“Myet u̱n kaane̱ ne̱, Wa-u̱t-Gwo̱mo kap wu̱ ro̱ m-she'et u̱n hur-to̱ hun-ne̱ ma'e̱ á. Bo̱ wan-Rwo̱r u̱n Ma-to̱ Shir ze̱e̱ à, ");
INSERT INTO uth_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","“ ‘Yawe ze̱e̱g, “O-To̱n o̱ ro̱ de̱e̱g-o̱ u̱n gwo̱mo-u̱t re, o-dak ne̱ o̱ ro̱ rii-o̱ u̱n e̱s u̱n na-u̱s re. ¿Yan go̱n hur-o̱ no̱ he me̱ m-me'e̱? Ko̱ komo ¿yan go̱n be-de ne̱ ro̱ be-de u̱n wu̱we̱ u̱n de? ");
INSERT INTO uth_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","¿Me̱ wu̱ ka no̱me̱ kap se ká rem-se á?” ’ ");
INSERT INTO uth_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","“No̱ ya-o-cimi, yan-hur-u̱r hwo̱'o̱g-de, yan-to̱-to̱ u̱n caar. U̱r-ho̱ bi, no̱ u̱n yage̱ o-do̱ro̱tte̱ u̱n Ku̱kt-o̱ Shir, bo̱ tato no̱ ne̱ no̱me̱ à, ka no̱ m-no̱m u̱n ce no̱. ");
INSERT INTO uth_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","¿N-me̱ u̱n yan-rwo̱r u̱n Ma-to̱ Shir, wu̱ tato no̱ ne̱ yage̱ m-rangse̱ à, wu̱ ro̱ ko̱n? Ye̱ ho̱o̱g ka ye̱ no̱me̱ u̱t-ma u̱n haan-mo̱ u̱n ka wan-Kashi u̱r-she'et wu̱ ne̱ à. No̱ komo, no̱ ya'aste̱ wu̱ u̱n kom-to̱ u̱n ya-o-Roma, bo̱ no̱ ho̱ wu̱ à. ");
INSERT INTO uth_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","No̱ ye̱ ne̱ go̱kse̱ o-karamsa be-de u̱n yan-to̱m-ye̱ Shir, amba no̱ do̱ru̱ o̱ á.” ");
INSERT INTO uth_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Bo̱ ye̱ ho̱gu̱te̱ kaane̱ à, ye̱ no̱mu̱ u̱s-ryaab de̱e̱n har ye̱ hew u̱s-jow remen u̱s-ryaab. ");
INSERT INTO uth_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Amba Istipanus ro shiishe̱ ce̱ng u̱n Ku̱kt-o̱ Shir. Wu̱ tuuru̱ yish, wu̱ ro u̱n gwo̱t o-To̱n shir, wu̱ hyanu̱ru̱ se̱ps-mo̱ Shir, komo u̱n Ye̱so ne̱ eso u̱n kom-o̱ u̱r-re̱ o̱ Shir. ");
INSERT INTO uth_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Istipanus ze̱e̱ru̱, “Gwo̱t no̱, me̱ u̱n hyan o-To̱n tikshishe̱, komo u̱n Wà-wu̱ u̱n ne̱t ne̱ eso u̱n kom-o̱ u̱r-re̱ o̱ Shir.” ");
INSERT INTO uth_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Amba ye̱ ciru̱ kan-se o-zaaz de̱e̱n de̱e̱n, ye̱ zwo̱pu̱ to̱-to̱ u̱n ye̱, ye̱ mo̱ru̱ wu̱ da-o gaan. ");
INSERT INTO uth_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Ye̱ ruutu̱ wu̱ so̱ n-jim de o-bo̱. Ye̱ se̱ngu̱ wu̱ u̱s-jor u̱t-ta'ar. Ya-u̱s-to̱r komo ye̱ e̱ssu̱ matuku-to̱ u̱n ye̱ be-de u̱n wu̱ ken ko-be̱e̱b-wu̱, jin-de u̱n wu̱ Shawuru. ");
INSERT INTO uth_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Ye̱ ro u̱n jor-u̱s Istipanus, wu̱ ne̱, wu̱ no̱mu̱ u̱s-ko̱n wu̱ zee, “Ye̱so Wan-Ko̱yan, de̱k ku̱kt-o re.” ");
INSERT INTO uth_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Wu̱ kwu̱ktu̱ru̱, wu̱ damu̱ co̱r m-'wo̱ns ne̱ wu̱ zee, “Wan-Ko̱yan, taase o piishe̱ ye̱ u̱t-ma u̱n de ka ba'as-de á.” Bo̱ wu̱ ru̱rte̱ kaane̱ à, wu̱ argu̱ m-mar. ");
INSERT INTO uth_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Shawuru komo wu̱ shesu̱ ka ye̱ ho̱'e̱ Istipanus à. U̱n ka ho̱-to̱, a ro u̱n rangse̱ u̱n yan-dor Ye̱so ye̱ ro o-Urusharima à u̱r-ko̱o̱b. Ye̱ argu̱ m-caage̱ so̱ u̱n dak-to̱ o-Judiya u̱n o̱ o-Samariya ne̱, yan-To̱m Ye̱so kuse̱ cot. ");
INSERT INTO uth_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Ye̱ ken yan-gu̱w-mo̱ Shir ye̱, ye̱ jo̱ke̱ Istipanus. Ye̱ 'wo̱n u̱s-'wo̱n de̱e̱n remen mar-mo̱ u̱n wu̱. ");
INSERT INTO uth_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Amba Shawuru se̱ngu̱ rangse̱ u̱n hun-ne̱ yan-dor Ye̱so ba m-so̱k. Wu̱ ro m-co̱w u̱t-hur, wu̱ ro̱ u̱n ship u̱n campo̱-ne̱ u̱n ne'a-ne̱ ne̱, wu̱ ro ye̱ m-ka u̱n kur-to̱ m-ke'et. ");
INSERT INTO uth_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Ka yan-dor Ye̱so ye̱ a cakarse̱ à, se̱ngu̱ru̱ m-pa, ye̱ ro u̱n se̱nge̱-mo̱ u̱n ko̱'o̱t u̱n Ma-to̱ m-Re̱re̱m ko̱ kene̱ ye̱ ha'e̱. ");
INSERT INTO uth_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Pirip neku̱ru̱ bo̱-o̱ o-Samariya, wu̱ ro ye̱ u̱n ko̱'o̱te̱ ma-u̱t Kiristi. ");
INSERT INTO uth_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Bo̱ hun-ne̱ de̱e̱n ho̱gu̱te̱ ma-u̱t Pirip à, ye̱ hyanu̱ru̱ komo rem-se o-made̱ se wu̱ ro̱ m-no̱m à, u̱n go̱p-de ye̱ muute̱ u̱r-hi n-te̱ u̱n rii-yo wu̱ ru̱ru̱ ye̱ à. ");
INSERT INTO uth_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Ya-u̱t-ko̱t komo u̱t-mo̱o̱r ne̱ ye̱ se̱ngu̱ m-rwu̱u̱n u̱n wu̱r-to̱ u̱n hun-ne̱ u̱n jo̱o̱g u̱s-kan. Ye̱ ro̱ u̱n hoks u̱r-hew u̱n na-se ye̱ á u̱n ryam-ne̱ ne̱, a taasu̱ ye̱ go̱m-se u̱n ye̱ myet. ");
INSERT INTO uth_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Remen kaane̱, hun-ne̱ ye̱ u̱n ka bo̱-o̱ no̱mu̱ o-zak de̱e̱n. ");
INSERT INTO uth_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Wu̱ ken ne̱t-wu̱ ro kon jin-de u̱n wu̱ Sima. N-ga wu̱ ro ye̱ u̱n nome̱ u̱n rem-se u̱t-hyat u̱n ka bo̱-o̱, har wu̱ ru̱ Samariya-ne̱ bo̱p u̱s-nu. Wu̱ ma'asu̱ru̱ m-ze̱e̱ wu̱ caari-wu̱ u̱n ne̱t-wu̱. ");
INSERT INTO uth_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Hun-ne̱ kap komo ye̱ muutu̱ru̱ u̱r-hi be-de u̱n wu̱, yakar ha-mo̱ u̱n mo̱ng-ne̱, ye̱ ro̱ m-ze̱e̱, “Ka ne̱t-wu̱, ai, be̱e̱b-de Shir de, wu̱ a m-ze̱e̱ ‘Wa-u̱t-go̱s’ à.” ");
INSERT INTO uth_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Ye̱ muutu̱ u̱r-hi be-de u̱n wu̱ m-so̱k ne̱, u̱n remen wu̱ rewesu̱te̱ wu̱ ro ye̱ u̱n no̱me̱ o-made̱ o̱ ro m-rwo̱ ye̱ bo̱p o-nu à. ");
INSERT INTO uth_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Amba bo̱ ye̱ dekte̱ ka Ma-to̱ m-Re̱re̱m to̱ Pirip no̱me̱ to̱ u̱n gwo̱mo-to̱ Shir à, komo u̱n jin-u̱r Ye̱so Kiristi ne̱, kap mo̱ u̱n ye̱ a yo'osu̱ru̱ ye̱ m-ho̱, ne'a-ne̱ u̱n campo̱-ne̱ ne̱. ");
INSERT INTO uth_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Har Sima u̱n hi u̱n de u̱n wu̱, wu̱ she̱re̱g be-de Shir. Bo̱ a yo'osu̱ wu̱ m-ho̱ à komo wu̱ mo̱msu̱ Pirip o-wu̱r. Bo̱ wu̱ hyente̱ Pirip ro̱ u̱n no̱m u̱t-hyat u̱n caari-to̱ u̱s-saw to̱ o-made̱ ne̱ à, wu̱ bo̱pu̱ o-nu. ");
INSERT INTO uth_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Bo̱ yan-To̱m Ye̱so ye̱ ro o-Urusharima ho̱gu̱te̱ Samariya-ne̱ go̱kste̱ Ma-to̱ Shir à, ye̱ to̱mu̱ru̱ Bitrus ne̱ u̱n Yohana be-de u̱n ye̱. ");
INSERT INTO uth_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Bo̱ Bitrus ne̱ woote̱ o-Samariya à, ye̱ nomu̱ru̱ hun-ne̱ u̱s-ko̱n ye̱ go̱kste̱ Ku̱kt-o̱ Shir. ");
INSERT INTO uth_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Remen Ku̱kt-o̱ Shir u̱n ro cirite̱ be-de u̱n ye̱ ko̱ wan-gaan á, a yo'oste̱ ye̱ m-ho̱ cot u̱n jin-u̱r Ye̱so Wan-Ko̱yan. ");
INSERT INTO uth_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Bitrus ne̱ u̱n Yohana, seke̱ ye̱ kom-to̱ o-kwu̱m, ye̱ go̱kste̱ Ku̱kt-o̱ Shir. ");
INSERT INTO uth_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Bo̱ Sima hyente̱, ashi u̱n rwo̱ u̱n kom-to̱ u̱n yan-To̱m Ye̱so atte̱ u̱n kum o-Ku̱kt à, wu̱ zo̱ngu̱ru̱ wu̱ ya'astu̱ ye̱ hwo̱r. ");
INSERT INTO uth_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","Wu̱ ze̱e̱ru̱, “Me̱ u̱n cere, 'ya me̱ no̱ ka be̱e̱b-de, remen bo̱ u̱n ne̱t-wu̱ me̱ seke̱ kom-u̱t re, wu̱ kumut Ku̱kt-o̱ Shir.” ");
INSERT INTO uth_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Amba Bitrus ze̱e̱ru̱ wu̱, “Wo̱ u̱n hwo̱r ru ne̱ no̱a sabre̱! ¿Wo̱ m-hyan o̱ o zee u̱n hwo̱r-o̱ o he kum u̱n yar-mo̱ Shir? ");
INSERT INTO uth_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Ho̱-m ru ro̱ ko̱n u̱n to̱ ka ma-to̱ á ko̱ hiin, u̱n remen hur u̱n du ro̱ hond hond be-de Shir á. ");
INSERT INTO uth_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Se̱ o wonge̱ u̱n ka sakto̱-o yo̱-o̱ o̱ ne̱ o̱ wo̱tte̱ à, ko̱n Wan-Ko̱yan ko̱ wu̱a soksu̱ wo̱ ba'as-de u̱n ka rii-yo o no̱me̱ barag-se m-no̱m u̱n hur u̱n du à. ");
INSERT INTO uth_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Remen u̱m hyanag wo̱ u̱n shoob-u̱r yo̱-de ne̱, wo̱ gekse̱ n-me̱ u̱r-ba'as.” ");
INSERT INTO uth_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Sima shasu̱ru̱ wu̱ zee, “Kono no me̱ no̱ Wan-Ko̱yan taase ko̱ o-gaan be-de u̱n ka saw-to̱ no̱ ogme̱ à yo kum me̱.” ");
INSERT INTO uth_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Bo̱ Bitrus ne̱ u̱n Yohana no̱me̱ u̱s-swo̱ rem Ye̱so u̱n ko̱'o̱t u̱n ma-u̱t Wan-Ko̱yan à, ye̱ argu̱ m-warag o-Urusharima. Bo̱ ye̱ waragte̱ o-Urusharima à, ye̱ se̱ngu̱ m-ko̱'o̱t Ma-to̱ m-Re̱re̱m u̱n ko̱t-to̱ o-Samariya u̱t-mo̱o̱r ne̱. ");
INSERT INTO uth_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","A kane̱, wu̱ ken wan-to̱m Wan-Ko̱yan, wu̱ ze̱e̱ru̱ Pirip, “Ine̱, o do̱re̱ so̱ o-baar, ka co̱w-yo rwu̱u̱ne̱ o-Urusharima à, ha-mo̱ o-Gaza, co̱w-yo o-dákár.” ");
INSERT INTO uth_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Wu̱ argu̱ m-ine̱ wu̱ neku̱ru̱. Wu̱ hyanu̱ru̱ wu̱ ken ne̱t-wu̱ o-Itiyopiya wu̱. Wu̱ ro u̱n caari-de u̱r-con ne̱ u̱n gwo̱mo-to̱ o-Kandis, wu̱ u̱n dak-o̱ o-Itiyopiya. Wu̱ ro komo wa-u̱r-e̱s u̱n ka Gwo̱mo-to̱. Wu̱ u̱n haan o-Urusharima remen wu̱ se̱ke̱msu̱té̱ Shir. ");
INSERT INTO uth_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Bo̱ wu̱ rotte̱ u̱n jo o-hur à, tara n-te̱ u̱n ke̱ke̱-de u̱n jo̱k-yo u̱n wu̱, wu̱ upsu̱ru̱ taku̱rda-o Ishayawan-Rwo̱r u̱n Ma-to̱ Shir wu̱ ma'asu̱ru̱ m-karante̱. ");
INSERT INTO uth_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Ku̱kt-o ze̱e̱ru̱ Pirip, “Hyogbe̱ o wo yow yow u̱n ka ke̱ke̱-de o-jo̱k de ne̱.” ");
INSERT INTO uth_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Pirip bu̱'u̱gu̱ o-rek, wu̱ wo̱o̱ru̱ u̱n he̱r-o̱ u̱n wu̱, wu̱ ho̱gu̱ru̱ wu̱ m-karante̱ u̱n taku̱rda-o Ishayawan-Rwo̱r u̱n Ma-to̱ Shir. Pirip citu̱ru̱ wu̱, “¿O nepste̱ rii-yo wo̱ m-karante̱?” ");
INSERT INTO uth_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Wu̱ shasu̱ru̱, “Ay, me̱ hoks m-nap á, se̱ me̱ kume̱ wu̱ ru̱ru̱ me̱ à.” Wu̱ ze̱e̱ru̱ Pirip wu̱ de ke̱ke̱-de u̱n jo̱k wu̱ she'et u̱n he̱r-o̱ u̱n wu̱. ");
INSERT INTO uth_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Ka Ma-to̱ Shir to̱ komo to̱ wu̱ ro m-karante̱ à to̱ ro: “A naku̱ wu̱ u̱ntu̱n o-ca a neke̱te̱ be-de m-pan. Bo̱ ya o-rwu̱u̱g o-ca ro̱ m-ma'as temb u̱n kom-to̱ u̱n wan-o̱r-o̱ u̱n can-se u̱n wu̱r-o̱ u̱n yo à, kaane̱ ko̱ nu-o̱ u̱n wu̱, wu̱ hak á. ");
INSERT INTO uth_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","A nomotu̱ wu̱ rem-se ba u̱r-bon har a we̱n wu̱ yo ro̱ yo ma u̱n wu̱ à. ¿Wan wu̱ ne̱ he hoks u̱n ce̱p u̱n ma-to̱ u̱n baag-o̱ u̱n wu̱? Remen a dossu̱ssu̱te̱ ho̱o̱g-mo̱ u̱n wu̱ u̱n ka dak-o̱.” ");
INSERT INTO uth_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Ka ko-ya-o-Itiyopiya-wu̱ ze̱e̱ru̱ Pirip, “¿Wan wu̱ ne̱ ka wan-Rwo̱r u̱n Ma-to̱ Shir wu̱ ro̱tte̱ u̱t-ma? ¿Wu̱ u̱n hi-de u̱n wu̱, ko̱ ne̱t ho̱r-wu̱?” ");
INSERT INTO uth_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Pirip haku̱ nu-o̱ u̱n wu̱, wu̱ shi'nu̱ru̱ raag-o̱ u̱n ka ge̱n-mo̱ u̱n Ma-to̱ Shir, wu̱ ro wu̱ u̱n ru̱re̱ Ma-to̱ m-Re̱re̱m to̱ ma Ye̱so. ");
INSERT INTO uth_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Bo̱ ye̱ rotte̱ u̱r-hew à, ye̱ wo̱o̱ru̱ be-de m-ho̱, ka ko-ya-o-Itiyopiya-wu̱ ze̱e̱ru̱, “Gwo̱t, m-ho̱! ¿Yan yo ne̱ he m-we̱n a yo'os me̱ n-me̱ m-ho̱?” ");
INSERT INTO uth_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Wu̱ ze̱e̱ru̱ a e̱ss ka ke̱ke̱-de u̱n jo̱k de. Kap mo̱ u̱n ye̱ yoor-ye̱ kergu̱ndu̱ru̱ ye̱ he̱'e̱bu̱ m-ho̱, Pirip yo'osu̱ru̱ ka ne̱t-wu̱ m-ho̱. ");
INSERT INTO uth_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Bo̱ ye̱ rwu̱u̱nte̱ m-ho̱ à, Ku̱kt-o Wan-Ko̱yan deku̱ Pirip. Ka ko-ya-o-Itiyopiya-wu̱ do Pirip m-hyan á. Wu̱ argu̱ arag-mo̱ u̱n wu̱ o-zak. ");
INSERT INTO uth_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Amba Pirip hyanu̱ hi u̱n de u̱n wu̱ u̱n bo̱-o̱ o-Azotus. Wu̱ rigu̱ kap o̱ u̱t-bo̱, wu̱ ro̱ m-rwo̱r u̱n Ma-to̱ m-Re̱re̱m, har wu̱ wo̱o̱ru̱ o-Kaseriya. ");
INSERT INTO uth_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Shawuru se̱ngu̱te̱ re̱ co u̱n rangse̱ u̱n yan-neke̱-m Wan-Ko̱yan de̱e̱n, har m-ze̱e̱ wu̱a ho ye̱. Wu̱ argu̱ m-ha be-de u̱n ko-Gwo̱mo-wu̱ u̱n ko̱n-se Shir. ");
INSERT INTO uth_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Wu̱ ko̱nu̱ wu̱ genu̱ wu̱ u̱t-taku̱rda wu̱ heet u̱n kuke̱-to̱ u̱n yoos u̱n Ma-to̱ Shir to̱ ya-o-Damaskus, remen u̱rege̱ wu̱ kumug yan-dor Ye̱so u̱n Ka Co̱w-yo, campo̱-ne̱ ko̱ ne'a-ne̱, wu̱ hantu̱ ye̱ u̱n bo̱-o̱ o-Urusharima a ke'et ye̱. ");
INSERT INTO uth_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Wu̱ ro̱ u̱r-hew, wu̱ wo̱o̱ru̱ yow yow o-Damaskus ne̱. Da-o gaan, wu̱ hyanu̱ru̱ m-cecar n-to̱n mo̱ caragsu̱ru̱ u̱n wu̱. ");
INSERT INTO uth_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Wu̱ argu̱ m-he̱ n-dak, komo wu̱ ho̱gu̱ru̱ o̱ ken co̱r-o̱ ro̱ wu̱ m-ze̱e̱, “Shawuru, Shawuru ¿ya wo̱tte̱ me̱ m-rangse̱?” ");
INSERT INTO uth_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Shawuru ze̱e̱ru̱, “¿Wan wu̱ ne̱ o ro̱ Wa-u̱t-Go̱s?” Co̱r-o shasu̱ru̱ o̱ zee, “Me̱ ro̱ Ye̱so ka wu̱ wo̱ m-rangse̱ à. ");
INSERT INTO uth_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Ine̱ m-mo̱ka, o cu̱w n-me̱ o-bo̱, re̱e̱no̱ a he wo̱ m-ru̱re̱ rii-yo o he m-no̱m à.” ");
INSERT INTO uth_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Yan-u̱r-hew de u̱n wu̱ komo ye̱ hoks te̱p á, co̱r-o̱ ka ye̱ ho̱gu̱sse̱ amba ye̱ hyan ne̱t á. ");
INSERT INTO uth_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Shawuru argu̱ m-ine̱ n-dak, amba bo̱ wu̱ upste̱ yish à, wu̱ do m-hyan á. Ye̱ shipu̱ wu̱ o-kom, ye̱ hantu̱ wu̱ o-Damaskus. ");
INSERT INTO uth_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Wu̱ no̱mu̱ ho̱-u̱t tet, ba m-hyan, ba m-re̱, ba m-swo̱, komo. ");
INSERT INTO uth_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Wu̱ ken wan-neke̱-m Ye̱so wu̱ ro kon o-Damaskus, jin-de u̱n wu̱ Hananiya. Wan-Ko̱yan nomo wu̱ u̱t-ma n-te̱ u̱t-hyangan, wu̱ zee, “Hananiya!” Wu̱ komo wu̱ shasu̱ru̱, “Me̱ ka, Wan-Ko̱yan o̱.” ");
INSERT INTO uth_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Wan-Ko̱yan ze̱e̱ru̱ wu̱, “Ine̱, o do̱re̱ ka co̱w-yo a m-ze̱e̱ Co̱w-o Te̱'te̱ à. O neke̱ u̱n hur-o Yahudas, o cit wu̱ ken ne̱t-wu̱ u̱n bo̱-o̱ o-Tarsus wu̱, wu̱ ro̱ káne̱ à, jin-de u̱n wu̱ Shawuru. Wu̱ ro̱ kane̱ u̱s-ko̱n u̱n ká be-de. ");
INSERT INTO uth_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Har n-me̱ u̱t-hyangan wu̱ hyanu̱ wu̱ ken ne̱t-wu̱ jin-de u̱n wu̱ Hananiya co̱wo̱nte̱, wu̱ seku̱ru̱ wu̱ kom-to̱ o-kwu̱m remen wu̱ doot kumun hyan-o̱ o-bo̱.” ");
INSERT INTO uth_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Amba Hananiya shasu̱ru̱, “Wan-Ko̱yan, u̱m su̱u̱ste̱ ho̱ge̱ u̱n ma-to̱ u̱n ka ne̱t-wu̱ be-de u̱n hun-ne̱ de̱e̱n, n-te̱ u̱n mo̱o̱r-to̱ u̱n me̱n-u̱t jaas-to̱ to̱ wu̱ nome̱ yan-dor ru o-Urusharima à. ");
INSERT INTO uth_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Wu̱ ka komo Gwo̱mo-ne̱ ye̱ u̱n ko̱n-se Shir ya'ag wu̱ u̱r-be̱e̱b wu̱ ship u̱n bo̱ u̱n wu̱ ro̱ u̱n no̱m u̱s-ko̱n u̱n jin u̱n du à.” ");
INSERT INTO uth_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Amba Wan-Ko̱yan ze̱e̱ru̱ Hananiya, “Neke̱ remen wu̱ ne̱t-wu̱, wu̱ u̱m daagne̱ wu̱ nomot se̱nge̱-m re remen wu̱ ko̱'o̱tté̱ jin u̱n de be-de u̱n ye̱ ro̱ Yahuda-ne̱ á, u̱n gwo̱mo-ne̱ u̱n ye̱ ne̱, komo u̱n Isra-ne̱ ne̱. ");
INSERT INTO uth_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Me̱ u̱n hi u̱n de, man kussu̱ wu̱ ko̱o̱b-de wu̱ he m-swo̱ ba wu̱ u̱n co̱n u̱n remen jin u̱n de à.” ");
INSERT INTO uth_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Hananiya haaru̱, wu̱ co̱wu̱ o-hur. Wu̱ tabbu̱ o-kom wu̱ ci'u̱ru̱ Shawuru. Wu̱ ze̱e̱ru̱, “Wan-yen de Shawuru, Wan-Ko̱yan wu̱ to̱mnu̱ me̱. Ye̱so ka wu̱ rwu̱u̱ne̱ be u̱n du u̱n ka co̱w-yo o do̱nde̱ à. Wu̱ co̱no̱g o do m-hyan, remen komo Ku̱kt-o̱ Shir garamsu̱té̱ wo̱.” ");
INSERT INTO uth_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Ba u̱n naas o-da, yo ken rii-yo u̱ntu̱n ku̱k-o̱ o-jan he̱'e̱nu̱ru̱ Shawuru u̱n yish, wu̱ jamsu̱ m-hyan. Ka da-o̱ wu̱ inu̱ru̱ a yo'osu̱ru̱ wu̱ m-ho̱. ");
INSERT INTO uth_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Wu̱ re̱e̱ru̱ rii-yo m-re̱ wu̱ jamsu̱ kum m-'wo̱ns. Shawuru no̱mu̱ru̱ u̱t-ho̱ hiin u̱n yan-neke̱-m Ye̱so ne̱ o-Damaskus. ");
INSERT INTO uth_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Ba m-jime̱, Shawuru ciru̱ ko̱'o̱t u̱n ma-u̱t Ye̱so u̱n kuke̱-to̱ u̱n yoos u̱n Ma-to̱ Shir. Wu̱ ro m-ze̱e̱ Ye̱so wu̱ ro̱ Wà-wu̱ Shir. ");
INSERT INTO uth_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Myet bo̱n ye̱ ho̱gu̱ wu̱ à, ye̱ bo̱pu̱ nu-se u̱n ye̱. Ye̱ ze̱e̱ru̱, “Ashi, ¿wu̱ wu̱ ka hoome̱ hun-ne̱ komo wu̱ caas yan-no̱m u̱s-ko̱n u̱n ka jin-de o-Urusharima á? ¿Wu̱ u̱n nekne̱ kane̱ ka u̱n sakto̱-o̱ u̱n heet-mo̱ u̱n ye̱ be-de u̱n Gwo̱mo-ne̱ ye̱ u̱n ko̱n-se Shir a ke'et ye̱ á?” ");
INSERT INTO uth_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Amba Shawuru do̱o̱ru̱ ko̱'o̱t u̱n Ma-to̱ Shir u̱r-be̱e̱b ne̱. Wu̱ se̱ngu̱ru̱ 'yons u̱n hur-de u̱n Yahuda-ne̱ ye̱ ro u̱r-she'et o-Damaskus à, wu̱ ro ye̱ m-ru̱re̱ o-nip u̱nze Ye̱so wu̱ ro̱ Kiristi. ");
INSERT INTO uth_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Bo̱ a nomte̱ u̱t-ho̱ hiin à, Yahuda-ne̱ zo̱ngu̱ru̱ ye̱ hoot Shawuru. ");
INSERT INTO uth_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Amba wu̱ ho̱gu̱ru̱ ma-to̱ u̱n yo ye̱ co̱ne̱ m-no̱m à. M-te̱t, m-ho̱w ne̱ ye̱ ro u̱n tu u̱n yish u̱n ish-se o-bo̱ remen ye̱ hoot wu̱. ");
INSERT INTO uth_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Amba m-te̱t yan-neke̱-mo̱ u̱n wu̱ deku̱ wu̱, ye̱ kergu̱ntu̱ wu̱ u̱n o̱ ken ish-o̱ u̱n wur-o̱ u̱n o-bo̱ n-me̱ u̱n caari-o̱ o-ko̱o̱r. ");
INSERT INTO uth_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Bo̱ Shawuru wo̱o̱nte̱ o-Urusharima à, wu̱ ma'asu̱ru̱ m-se̱nge̱ wu̱ cu̱wu̱t n-me̱ u̱n mo̱rge̱-de u̱n yan-dor Ye̱so, amba kap mo̱ u̱n ye̱ ho̱gu̱ o-gye̱r u̱n remen ye̱ de̱k wu̱ u̱ntu̱n ko-yan-neke̱-m Ye̱so á. ");
INSERT INTO uth_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Amba Barnabas deku̱ Shawuru wu̱ heet be-de u̱n yan-To̱m Ye̱so. Wu̱ ru̱ru̱ ye̱ bo̱ Shawuru hyane̱ Wan-Ko̱yan u̱n co̱w à, u̱n bo̱ Wan-Ko̱yan nomo wu̱ u̱t-ma ne̱ à, komo u̱n bo̱ Shawuru ko̱'o̱te̱ jin-u̱r Ye̱so o-Damaskus à, ba o-gye̱r. ");
INSERT INTO uth_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Bo̱ u̱n kane̱, Shawuru se̱ngu̱ neke̱-mo̱ u̱n wu̱ sak u̱n yan-dor Ye̱so ne̱ o-Urusharima. Wu̱ ro m-ko̱'o̱t u̱n jin-u̱r Wan-Ko̱yan ba o-gye̱r. ");
INSERT INTO uth_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Komo ma-u̱t se̱ngu̱ wu̱ m-su̱u̱ne̱ u̱n Yahuda-ne̱ yan-ho̱ge̱ u̱t-Girik, wu̱ ma'asu̱ru̱ u̱t-ma u̱n ye̱ ne̱, amba ye̱ se̱ngu̱ hoob-o̱ u̱r-taab ye̱ hoot wu̱. ");
INSERT INTO uth_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Bo̱ o̱r u̱n wu̱ ne̱ nepte̱ kaane̱ à, ye̱ argu̱ wu̱ m-heet o-Kaseriya. Ka da-de, ye̱ to̱mu̱ wu̱ ha-mo̱ u̱n bo̱-o̱ o-Tarsus. ");
INSERT INTO uth_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Bo̱ u̱n ka da-o̱ hun-ne̱ kap yan-dor Ye̱so ye̱ ro̱ u̱n dak-to̱ o-Judiya à, o-Gariri ne̱, o-Samariya ne̱, ye̱ kumu she'et-de u̱n gwu̱gwu̱-mo̱ u̱r-hur. Hun-ne̱ yan-dor Ye̱so kumu u̱r-be̱e̱b, u̱n jaab-o̱ u̱t-me̱n ne̱, ye̱ do̱o̱ru̱ u̱t-mo̱o̱r u̱n bu̱-yo u̱n Ku̱kt-o̱ Shir, da-o̱ ye̱ se̱nge̱ u̱r-she'et n-me̱ u̱n gye̱r-o Wan-Ko̱yan à. ");
INSERT INTO uth_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Bo̱ Bitrus do̱ro̱kte̱ u̱t-dak kap à, komo wu̱ haaru̱ be-de u̱n ka yan-dor Ye̱so ye̱, ye̱ ro u̱r-she'et u̱n bo̱-o̱ o-Ridda à. ");
INSERT INTO uth_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","U̱n ka be-de, wu̱ go̱'o̱nu̱ru̱ u̱n wu̱ ken ne̱t-wu̱ ne̱ jin-de u̱n wu̱ Iniyas, wu̱ ro do̱mb hak-u̱s eer u̱n go̱m-o̱ u̱s-ryam. ");
INSERT INTO uth_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Bitrus ze̱e̱ru̱ wu̱, “Iniyas, Ye̱so Kiristi taaste̱ go̱m ru. Ine̱, o pus rii-o̱ u̱r-ru̱t o ru.” Ba u̱n rem, Iniyas argu̱ m-ine̱. ");
INSERT INTO uth_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Kap hun-ne̱ ye̱ ro u̱r-she'et n-me̱ u̱n bo̱-to̱ o-Ridda u̱n Sharo̱n ne̱ hyanu̱ ka wu̱ a taase̱ go̱m à. Ka da-o̱ ye̱ waktu̱nu̱ be-u̱r Wan-Ko̱yan. ");
INSERT INTO uth_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","U̱n bo̱-o̱ o-Jopa, wu̱ ken ne'a-wu̱ ro kon wan-neke̱-m Ye̱so jin-de u̱n wu̱ Tabita, wu̱ a m-ze̱e̱ Dorkas à. Ka Dorkas wu̱ ya'aste̱ hi u̱n de u̱n wu̱ sak n-me̱ u̱n no̱m u̱n rii-yo u̱r-bon, komo wu̱ ro u̱n gu u̱n ko̱o̱b-ne̱. ");
INSERT INTO uth_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","U̱n ká da-o̱, wu̱ ru̱kt o-wu̱r, wu̱ maru̱ru̱. Bo̱ ye̱ zorte̱ wu̱ à, ye̱ ne̱ksu̱ u-de u̱n wu̱ u̱n kuke̱-o̱ n-to̱n. ");
INSERT INTO uth_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Komo bo̱-o̱ o-Ridda ro̱ yow yow u̱n bo̱-o̱ o-Jopa ne̱. Bo̱ yan-dor Ye̱so ho̱gu̱te̱ Bitrus ro kon o-Ridda à, ye̱ to̱mu̱ru̱ hun-ne̱ yoor be-de u̱n wu̱, ye̱ kon wu̱ wu̱ haan be-de u̱n ye̱ ho̱r-m-ho̱r. ");
INSERT INTO uth_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Bitrus argu̱ m-ine̱ wu̱ neku̱ru̱ u̱n ye̱ ne̱. Bo̱ wu̱ wo̱o̱nte̱ à, ye̱ heetu̱ wu̱ u̱n kuke̱-o̱ n-to̱n. Myet-mo̱ u̱n ne'a-ne̱ ye̱ campo̱ u̱n ye̱ ne̱ merme̱ à, ye̱ e̱su̱ru̱ yow yow u̱n wu̱ ne̱, ye̱ ro u̱s-'wo̱n, ye̱ ro Bitrus m-kute̱ u̱t-matuku, u̱t-gund ne̱ to̱ Dorkas cee ye̱ cin da-o̱ wu̱ rokne̱ u̱n ho̱o̱g à. ");
INSERT INTO uth_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Bitrus ruutu̱ ye̱ n-do̱ kap u̱n ka kuke̱-o̱, wu̱ kwu̱ktu̱ru̱ wu̱ ko̱n u̱s-ko̱n. Wu̱ byandu̱ru̱ be-de u̱r-u, wu̱ ze̱e̱ru̱, “Tabita, ine̱.” Wu̱ argu̱ ups u̱n yish. Bo̱ wu̱ hyente̱ Bitrus à, wu̱ argu̱ m-ine̱ wu̱ she'etu̱ru̱. ");
INSERT INTO uth_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Bitrus tebbu̱ wu̱ o-kom wu̱ guuru̱ wu̱, wu̱ inu̱te̱. Wu̱ agbu̱ yan-dor Ye̱so, u̱n ne'a-ne̱ ye̱ campo̱ u̱n ye̱ ne̱ merme̱ ne̱ à, wu̱ tebbu̱ ye̱ Tabita u̱n ho̱o̱g ne̱. ");
INSERT INTO uth_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Ka ma-to̱ semu̱ru̱ kap o̱ o-Jopa, hun-ne̱ komo de̱e̱n ye̱ argu̱ m-she̱r be-u̱r Wan-Ko̱yan. ");
INSERT INTO uth_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Bitrus rewu̱ u̱t-ho̱ de̱e̱n o-Jopa, u̱n hur-o̱ u̱n wu̱ ken ko-yan-swo̱m-to̱ u̱t-ka to̱ u̱t-gu̱t wu̱, wu̱ a m-ze̱e̱ Simo̱n à. ");
INSERT INTO uth_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Wu̱ ken ne̱t-wu̱ ro kon u̱n bo̱-o̱ o-Kaseriya jin-de u̱n wu̱ Ko̱neriyus. Wu̱ ro ko-caari-wu̱ u̱n karma-ne̱ wu̱ u̱n Roma-ne̱ wu̱ u̱n bu̱u̱g-de u̱n karma-ne̱ de a m-aag Bu̱u̱g-de o-Itariya à. ");
INSERT INTO uth_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Wu̱ co̱no̱g Shir u̱n hur-u̱r gaan, komo wu̱ ro “Wan-se̱ps u̱n Shir,” kap u̱n yakar-ye̱ u̱n wu̱ ne̱. Wu̱ ro m-se̱nge̱ de̱e̱n be-de u̱n gwu̱-o̱ u̱n Yahuda-ne̱ ye̱ ro̱ ko̱o̱b-ne̱ à, komo ko̱ de ke ho̱-de wu̱ ro u̱s-ko̱n be-de Shir. ");
INSERT INTO uth_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","De ken ho̱-de, hohond-mo̱ u̱n kwo̱m-u̱s tet-se m-rim, wu̱ hyanu̱ru̱ wan-to̱m-wu̱ Shir cas n-te̱ u̱t-hyangan. Wan-to̱m-wu̱ Shir haante̱ be-de u̱n wu̱, wu̱ ze̱e̱ru̱, “Ko̱neriyus!” ");
INSERT INTO uth_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Ko̱neriyus tuuru̱ wu̱ yish gye̱r-o-gye̱r, wu̱ ze̱e̱ru̱, “Wa-u̱t-Go̱s, ¿yan yo ne̱?” Wan-to̱m-wu̱ Shir ze̱e̱ru̱ wu̱, “Ko̱n-u̱s ru se u̱n gwu̱-o̱ u̱n ko̱o̱b-ne̱ ne̱ se wo̱ m-no̱m à, se wo̱o̱g be-de Shir, rem-se m-baks se komo be-de u̱n Shir. ");
INSERT INTO uth_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","To̱m hun-ne̱ m-mo̱ka ha-mo̱ o-Jopa ye̱ agante̱ Simo̱n, wu̱ a m-aag Bitrus à. ");
INSERT INTO uth_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Bitrus she'ete̱ u̱n hur-o̱ u̱n wu̱ ken ne̱t-wu̱ jin-de u̱n wu̱ komo Simo̱n, wan-swo̱m-to̱ u̱t-ka. Hur-o̱ u̱n wu̱ ro̱ n-riib m-sa à.” ");
INSERT INTO uth_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Bo̱ wan-to̱m-wu̱ Shir ka wu̱ nomo wu̱ u̱t-ma aragte̱ à, Ko̱neriyus agnu̱ gu̱w-ne̱ ye̱ u̱n wu̱ ne̱n yoor, u̱n wu̱ ken ko-karma-wu̱ ne̱ wu̱ she̱re̱ u̱n Shir n-me̱ u̱n ka ye̱ ro̱ wu̱ u̱n nome̱ m-se̱nge̱ u̱r-ho̱ bi à. ");
INSERT INTO uth_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Bo̱ wu̱ komoste̱ ye̱ m-ru̱re̱ u̱n ko̱yan kap à, wu̱ to̱mu̱ru̱ ye̱ ha-mo̱ o-Jopa. ");
INSERT INTO uth_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Bo̱ ish geste̱ à, ho̱-u̱r ro yow yow u̱r-hi ne̱, gu̱w-ne̱ Ko̱neriyus ro̱ u̱r-hew. Da-o̱ ye̱ wo̱o̱ne̱ yow yow u̱n bo̱-o̱ o-Jopa ne̱ à, Bitrus daaru̱ n-to̱n o-kuke̱, wu̱ nomot u̱s-ko̱n. ");
INSERT INTO uth_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Me̱r shipi wu̱, har wu̱ cu̱n wu̱ re̱ yo ken rii-yo. Amba bo̱ a ro u̱n ma-to̱ u̱n no̱m u̱n rii-yo m-re̱ à, wu̱ hyanu̱ u̱t-hyangan. ");
INSERT INTO uth_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Wu̱ hyanu̱ To̱n-o shir tiksu̱te̱, o̱ ken rii-o̱ o̱ ro m-kergu̱ne̱ u̱ntu̱n u̱n caari-o̱ o-gwo̱do̱. A o̱ m-kyergu̱nte̱ n-dak u̱n pa'aso-to̱ u̱n o̱ ne̱ u̱t-nass. ");
INSERT INTO uth_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","N-me̱ u̱n o̱, ko̱yan go̱n gu̱t-de, de ro kon. Ye̱ u̱n na-u̱s nass ro̱ ko̱n, u̱n ye̱ ro̱ m-nak o-uub ne̱ à, u̱n ye̱ge̱-no ye̱ u̱t-ko̱t ne̱. ");
INSERT INTO uth_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Wu̱ ho̱gu̱ru̱ o̱ ken co̱r-o̱ ze̱e̱g wu̱, “Bitrus, ine̱, o pen, o ti.” ");
INSERT INTO uth_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Amba Bitrus ze̱e̱ru̱, “Ay! Wan-Ko̱yan o̱, me̱ we̱t m-ti m-ap mo̱ karamsa-o Mosa ze̱e̱ a ti á.” ");
INSERT INTO uth_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Wu̱ dooru̱ ho̱ge̱ u̱n co̱r-o ayoore̱-o̱, o̱ ze̱e̱g, “Rii-yo Shir no̱me̱ ba m-ku̱ko̱p à, taase o eeg yo rii-yo m-ku̱ko̱p.” ");
INSERT INTO uth_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Bo̱ korte̱ kaane̱ so̱-o o-tet à, da-o gaan ka saw-to̱ argu̱ m-da n-To̱n shir ba m-rem. ");
INSERT INTO uth_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Bitrus ro o-ryegen de̱e̱n, wu̱ ro m-ze̱e̱ ko̱yan yo ka hyangan-to̱ kute̱ wu̱. Ka hun-ne̱ ye̱ Ko̱neriyus to̱mne̱ à wo̱o̱nu̱ru̱. Ye̱ citu̱ru̱ hun-ne̱ be-de hur-o Simo̱n ro̱ à. Ye̱ hyanu̱ru̱ o-hur, ye̱ ro eso eso u̱n ish. ");
INSERT INTO uth_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Ye̱ ro m-ko̱'o̱t o-ish, ye̱ ro o-cot, “¿Ko̱ Simo̱n wu̱ a m-aag Bitrus à comsu̱te̱ kane̱?” ");
INSERT INTO uth_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Cin Bitrus ro u̱n barag-se u̱n ka hyangan-to̱, Ku̱kt-o̱ Shir ze̱e̱ru̱ wu̱, “Hun-ne̱ ne̱n tet ye̱ ka kane̱ u̱n hoob-o ru. ");
INSERT INTO uth_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Ine̱, o kerge̱ ho̱r-m-ho̱r, o do̱ru̱ ye̱. Taase o ho̱ge̱ o-gye̱r á, remen me̱ to̱mbu̱ ye̱.” ");
INSERT INTO uth_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Bitrus kyergu̱ru̱, wu̱ neku̱ru̱ be-de u̱n ka hun-ne̱ ye̱. Wu̱ ze̱e̱ru̱ ye̱, “Me̱ wu̱ no̱ o-hoob. ¿Yan yo hantu̱ no̱?” ");
INSERT INTO uth_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Ye̱ ze̱e̱ru̱, “Wu̱ ken ko-caari-wu̱ u̱n ko-karma-wu̱ u̱n Roma-ne̱ wu̱, jin-de u̱n wu̱ Ko̱neriyus, wu̱ to̱mnu̱ te̱. Wu̱ kashi u̱n ne̱t-wu̱, ‘Wan-se̱ps u̱n Shir.’ Ka wu̱ kap o̱ u̱n hun-ne̱ ye̱ o-Yahuda ro̱ m-rwo̱r u̱n ma-to̱ u̱n wu̱ u̱t-kashi à. Wu̱ wu̱, wu̱ ken wan-to̱m-wu̱ Shir wu̱ ba m-ku̱ko̱p wu̱ rwo̱'e̱ wu̱ to̱mo̱nte̱ o habe̱ u̱n hur-o̱ u̱n wu̱, wu̱ ho̱gu̱té̱ to̱ o he m-ce̱p à.” ");
INSERT INTO uth_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Bitrus agnu̱ru̱ ye̱, wu̱ ya'aru̱ ye̱ be-de m-rew. Bo̱ ish geste̱ à, Bitrus inu̱ru̱, wu̱ neku̱ru̱ u̱n ye̱ ne̱. Ye̱ ken yan-dor Ye̱so ye̱ komo yan-bo̱-o̱ o-Jopa ye̱ shiiru̱ wu̱. ");
INSERT INTO uth_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Gas-o̱ ish komo ye̱ co̱wu̱ru̱ o-Kaseriya. Ko̱ n-ga ma Ko̱neriyus hwo̱o̱g ye̱a heesu̱ne̱, har wu̱ agbu̱ru̱ o̱r u̱n wu̱ ne̱ kap u̱n nay-ne̱ ye̱ u̱n wu̱ ne̱. ");
INSERT INTO uth_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Bitrus ro m-co̱w o-hur, Ko̱neriyus 'wo̱ssu̱ru̱ wu̱. Wu̱ he̱e̱ru̱ u̱n na-se u̱n Bitrus, wu̱ kwu̱ktu̱ wu̱. ");
INSERT INTO uth_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Amba Bitrus ze̱e̱ru̱ wu̱ ine̱, wu̱ ze̱e̱ru̱, “Ine̱! Ai, me̱ ma ne̱t-wu̱.” ");
INSERT INTO uth_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Bitrus ro u̱t-ma u̱n wu̱ ne̱, wu̱ co̱wu̱ru̱ wu̱ 'wo̱ssu̱ru̱ hun-ne̱ de̱e̱n mo̱rgu̱te̱. ");
INSERT INTO uth_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Wu̱ ze̱e̱ru̱ ye̱, “No̱ u̱n hi u̱n no̱, no̱ nepste̱ u̱nze u̱depe̱ ko-Yahuda mo̱sse̱ u̱r-hi ko̱ ne̱ wu̱ gas, ko̱ ha u̱r-hamat be-de u̱n ne̱t-wu̱ ro̱ ko-Yahuda á. Amba Shir ze̱e̱g taase u̱m zee ne̱t, ‘Shir a go̱ks wo̱ á.’ ");
INSERT INTO uth_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Remen kaane̱, bo̱ a to̱mbe̱ u̱m haan à, me̱ zee ay á. To̱, m-mo̱ka u̱m co̱no̱g u̱m nep rii-yo rwo̱'e̱ no̱ agantu̱ me̱ à.” ");
INSERT INTO uth_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Ko̱neriyus ze̱e̱ru̱, “Ho̱-u̱t nass-to̱ arge̱ à, go̱n ka da-o̱, kwo̱m-u̱s tet-se m-rim me̱ u̱n ko̱n-se Shir u̱n hur-o re. Wu̱ ken ne̱t-wu̱ wo̱o̱nu̱ru̱ wu̱ e̱su̱ u̱n co re. Saw-to̱ wu̱ co̱pe̱ à, to̱ m-cu̱cas to̱ m-so̱k ne̱. ");
INSERT INTO uth_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Ka ne̱t-wu̱ ze̱e̱ru̱, ‘Ko̱neriyus, a go̱kste̱ ko̱n-u̱s ru, ka ko̱o̱b-ne̱ ye̱ wo̱ m-gu komo à, ka ma-to̱ a wakte̱ rii-yo m-baks be-de Shir. ");
INSERT INTO uth_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Remen kaane̱, to̱m ha-mo̱ o-Jopa a agan Simo̱n, wu̱ a m-aag Bitrus à, wu̱ comse̱ u̱n hur-o Simo̱n wan-swo̱m-to̱ u̱t-ka, wu̱ hur-o̱ u̱n wu̱ ro̱ n-riib m-sa à.’ ");
INSERT INTO uth_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","O̱ rwo̱'e̱, u̱m to̱mbu̱te̱ a agan wo̱, komo no̱mo̱g u̱r-bon bo̱ o haane̱ à. To̱, te̱ myet te̱ mo̱rgu̱te̱ u̱n co-o̱ Shir, remen te̱ raksté̱ kap o̱ u̱n yo Shir Wan-Ko̱yan ze̱e̱ wo̱ à.” ");
INSERT INTO uth_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Bitrus ciru̱ ye̱ nome̱ u̱t-ma, wu̱ zee, “O-nip, m-mo̱ka u̱m cire̱ m-nap Shir ro̱ u̱n kute̱ u̱n hun-ne̱ m-koos á. ");
INSERT INTO uth_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Amba wu̱ ro̱ m-go̱ks u̱n hun-ne̱ ye̱ u̱n ko̱ o̱ ke dak-o̱ bo̱ u̱n wu̱ ro̱ u̱n ho̱ge̱ u̱n gye̱r-o̱ u̱n wu̱ à, komo u̱n ko̱wan wu̱ no̱me̱ kashi rii ne̱ à. ");
INSERT INTO uth_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","No̱ nepste̱ to̱m-o̱ wu̱ to̱mnu̱nte̱ hun-ne̱ ye̱ o-Isra à. Shir ya'ag te̱ Ma-to̱ m-Re̱re̱m to̱ rwo'e̱ na she'et-de ba u̱t-ween u̱n Shir ne̱ à. Wu̱ u̱n no̱m kaane̱ u̱n bu̱-o Ye̱so Kiristi, komo wu̱ ro̱ Wan-Ko̱yan be-de u̱n ko̱ wu̱ ke ne̱t-wu̱. ");
INSERT INTO uth_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","No̱ nepste̱ bo̱ ka ma-to̱ seme̱ kap o̱ n-me̱ de u̱n dak-o̱ o-Judiya à, cir-mo̱ n-me̱ o-Gariri wu̱ shi'ine̱, da-o̱ Yohana ko̱'o̱te̱ ma-to̱ u̱n yo'os-de hun-ne̱ m-ho̱ à. ");
INSERT INTO uth_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","No̱ nepste̱ Shir daage̱ Ye̱so wu̱ o-Nazaret, bo̱ Shir ya'ase̱ wu̱ Ku̱kt-o̱ Shir à, komo u̱r-be̱e̱b ne̱. Remen Shir ro mo̱sse̱ u̱n wu̱ ne̱, wu̱ se̱ngu̱ m-pa wu̱ ro u̱n no̱m u̱n se̱nge̱-mo̱ m-so̱k, wu̱ ro u̱n taase̱ u̱n kap ye̱ ko-Gwo̱mo-wu̱ u̱n ya-u̱t-ko̱t shipe̱ à, go̱m-se u̱n ye̱. ");
INSERT INTO uth_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","“Te̱ ro̱ yan-swo̱-se u̱n wu̱ komo te̱ hyanag u̱n yish te̱ kap o̱ u̱n rii-yo Ye̱so no̱me̱ n-dak o̱ o-Judiya à, komo o-Urusharima ne̱. O̱ ye̱ hootu̱ wu̱ n-te̱ u̱n to̱n-o̱ cik-o̱ o-kan. ");
INSERT INTO uth_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Amba Shir 'yonsu̱ wu̱ u̱n ho̱-u̱r atette̱-de, komo wu̱ rwo'u̱ru̱ ye̱ ken hun-ne̱ ye̱ hyenet wu̱. ");
INSERT INTO uth_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Wu̱ rwu̱u̱n be-de u̱n myet o̱ u̱n hun-ne̱ á, se̱ be u̱n te̱ ye̱ Shir daage̱ cin n-ga remen te̱ waktu̱té̱ ya-o-so̱ro̱g à. Te̱ re̱e̱g, te̱ su̱ be-u̱r gaan u̱n wu̱ ne̱, da-o̱ wu̱ ine̱ u̱t-marimar à. ");
INSERT INTO uth_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Shir rwo̱'o̱g te̱ komo te̱ ko̱'o̱té̱ hun-ne̱ Ma-to̱ m-Re̱re̱m, komo te̱ ru̱r u̱nze Ye̱so wu̱ Shir rwo̱'e̱ wu̱ wakte̱ wan-piishe̱ u̱n yan-ho̱o̱g u̱n margan-ne̱ ne̱ u̱t-ma. ");
INSERT INTO uth_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Kap o̱ u̱n yan-Rwo̱r u̱n Ma-to̱ Shir ye̱ nomoste̱ u̱t-ma u̱n wu̱ u̱nze u̱n jin-de u̱n wu̱ o̱ kap o̱ u̱n wu̱ she̱re̱ be-de u̱n wu̱ à, he kum u̱n soks u̱t-ba'as.” ");
INSERT INTO uth_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Bitrus ro u̱n rwo̱r u̱t-ma, Ku̱kt-o̱ Shir argu̱ m-cire̱ u̱n hi-de u̱n kap o̱ u̱n bo̱ u̱n ye̱ ro m-ho̱ge̱ u̱n ma-to̱ u̱n wu̱ à. ");
INSERT INTO uth_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Yahuda-ne̱ ye̱ a ko̱e̱ à, yan-dor Ye̱so, ye̱ nekne̱ u̱n Bitrus ne̱ à, ye̱ bo̱pu̱ nu-se u̱n ye̱ u̱n hyan-o̱ u̱n ye̱ ro̱ Yahuda-ne̱ á, ye̱ ma ye̱ kumug yar-mo̱ u̱n Ku̱kt-o̱ Shir. ");
INSERT INTO uth_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Remen ye̱ ho̱gu̱te̱ ye̱ m-te̱pe̱r u̱n rem-u̱t ho̱r-to̱, komo ye̱ ro u̱n se̱ke̱mse̱ u̱n Shir. Ka da-de Bitrus ze̱e̱ru̱, ");
INSERT INTO uth_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“¿Wu̱ ken wu̱ ro̱ ko̱n wu̱ he m-we̱n a yo'os ka hun-ne̱ ye̱ m-ho̱? Ai, ye̱ ma ye̱ kumuste̱ Ku̱kt-o̱ Shir bo̱ te̱ kume̱ à.” ");
INSERT INTO uth_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Bitrus rwo̱'u̱ru̱ a yo'os ye̱ m-ho̱ n-me̱ u̱n jin-u̱r Ye̱so Kiristi. Ka da-de ne̱, ye̱ ko̱nu̱ wu̱ wu̱ do̱o̱be̱ ya u̱n ho̱ hiin be-de u̱n ye̱. ");
INSERT INTO uth_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","O-da hiin ka ma-to̱ wo̱o̱ru̱ yan-To̱m Ye̱so u̱n ye̱ ken yan-dor Ye̱so ye̱ ne̱ u̱n dak-o̱ o-Judiya u̱nze ye̱ ro̱ Yahuda-ne̱ á go̱kste̱ Ma-to̱ Shir. ");
INSERT INTO uth_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Bo̱ Bitrus heete̱ o-Urusharima à, ye̱ ken se̱k-ye̱ ye̱ u̱n Yahuda-ne̱ ye̱ yan-dor Ye̱so, ye̱ e̱se̱ be-de u̱n jor-se u̱r-ko̱ à, ye̱ te̱pru̱ru̱ wu̱. ");
INSERT INTO uth_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Ye̱ ze̱e̱ru̱, “¿Remen yan o̱ o wo̱tte̱ be-de yan-ba-u̱t-ko̱, har o reet rii-yo m-re̱ be-u̱r gaan u̱n ye̱ ne̱?” ");
INSERT INTO uth_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Bitrus ciru̱ ye̱ nome̱ u̱t-ma cas cas, wu̱ zee: ");
INSERT INTO uth_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Me̱ u̱n bo̱-o̱ o-Jopa me̱ u̱s-ko̱n, u̱m hyanu̱ u̱t-hyangan. U̱m hyanu̱ o̱ ken rii-o̱ m-kyergu̱ne̱ u̱ntu̱n caari-o̱ o-gwo̱do̱. A kyergu̱ntu̱te̱ o̱ n-To̱n shir, pa'aso-to̱ u̱n o̱ u̱t-nass, o̱ wo̱o̱nu̱ yow yow u̱n me̱ ne̱. ");
INSERT INTO uth_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Bo̱ u̱m gu̱ttu̱ o̱ m-so̱k ne̱ à, u̱m hyanu̱ gu̱t-to̱ u̱n na-u̱s nass, u̱n rii-ye̱ u̱t-ko̱t ne̱, u̱n ye̱ ro̱ m-ja ne̱ à, komo u̱n ye̱ge̱-no ye̱ u̱t-ko̱t ne̱ n-me̱. ");
INSERT INTO uth_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","U̱m ho̱gu̱ru̱ o̱ ken co̱r-o̱ ze̱e̱g me̱, ‘Bitrus, ine̱, o pen, o ti.’ ");
INSERT INTO uth_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","“Amba u̱m ze̱e̱ru̱, ‘Ay! Wan-Ko̱yan o̱, yo karamsa-o Mosa ze̱e̱ a ti á, me̱ we̱t yo m-he̱'e̱dbe̱ u̱n nu re á!’ ");
INSERT INTO uth_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","“Ka co̱r-o̱ shasu̱ru̱ n-To̱n shir o̱ no̱mu̱ u̱t-ma ayoore̱-o̱, o̱ zee, ‘Rii-yo Shir no̱me̱ a reet à, taase o zee yo rii-yo m-ku̱ko̱p.’ ");
INSERT INTO uth_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Bo̱ korte̱ kaane̱ so̱-o̱ tet à, ka da-de, a deku̱ ka rii-o̱ n-To̱n shir. ");
INSERT INTO uth_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","“U̱n hohond-mo̱ u̱n ka da-o̱, hun-ne̱ tet e̱su̱ru̱ u̱n ish-o̱ u̱n hur-o̱ u̱m rotte̱ à, a u̱n to̱mo̱n ye̱ be u̱n de rwu̱u̱n-mo̱ o-Kaseriya. ");
INSERT INTO uth_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Ku̱kt-o̱ Shir ze̱e̱ru̱ me̱ u̱m dooru̱ ye̱, taase u̱m kutu ye̱ m-koos á. Kà o̱r re ne̱ ye̱ ne̱n cind ye̱, komo ye̱ shinu̱ me̱, har te̱ co̱wu̱ u̱n hur-o̱ u̱n ka ne̱t-wu̱. ");
INSERT INTO uth_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Wu̱ argu̱ te̱ m-ru̱re̱ bo̱ wu̱ hyane̱ wan-to̱m-wu̱ Shir e̱ks u̱n hur-o̱ u̱n wu̱ à. Wu̱ ze̱e̱ru̱, ‘To̱m ha-mo̱ o-Jopa a agan Simo̱n, wu̱ a m-aag Bitrus à. ");
INSERT INTO uth_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Wu̱ he wo̱ hante̱ u̱n to̱m-o̱ o hette̱ kum u̱n gwu̱ à, wo̱ u̱n hun-ne̱ ye̱ u̱n hur-o ru ne̱ kap.’ ");
INSERT INTO uth_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","“Cir-mo̱ ka u̱m cire̱ ye̱ nome̱ u̱t-ma. Ku̱kt-o̱ Shir argu̱ ye̱ m-he̱'e̱n, hond hond bo̱ o̱ he̱'e̱nu̱ na u̱r-takan à. ");
INSERT INTO uth_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","U̱m baksu̱ ma-u̱t Wan-Ko̱yan, bo̱ wu̱ ze̱e̱, ‘Yohana yo'oste̱ hun-ne̱ m-ho̱, amba no̱ u̱n Ku̱kt-o̱ Shir a he no̱ m-yo'os.’ ");
INSERT INTO uth_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","To̱, u̱rege̱ Shir ya'ag ye̱ m-yar hond hond u̱n mo̱ ma na ne̱, da-de a she̱re̱ u̱n Wan-Ko̱yan Ye̱so Kiristi, me̱ bo'os u̱m we̱n Shir á!” ");
INSERT INTO uth_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Bo̱ Yahuda-ne̱ yan-dor Ye̱so ho̱gu̱te̱ kaane̱ à, ye̱ taagu̱ bo̱ ye̱ he m-ze̱e̱ à, ye̱ bo̱mu̱ Shir. Ye̱ ma'asu̱ru̱ m-ze̱e̱, “Ashi, har u̱n ye̱ ro̱ Yahuda-ne̱ á, Shir nomsu̱te̱ ye̱ co̱w-yo m-waktu̱ne̱ be-de u̱n wu̱ u̱n yo u̱n kum m-ho̱o̱g ne̱.” ");
INSERT INTO uth_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Da-o̱ mar-m Istipanus kore̱ à, ye̱ ken yan-dor Ye̱so ye̱ de̱e̱n ye̱ argu̱ru̱ m-caage̱ remen ka range̱-o̱ ine̱ à. Ye̱ ken ye̱ neku̱ru̱ har ha-mo̱ u̱n dak-to̱ o-Pinikiya o-Sayipurus ne̱, u̱n bo̱-o̱ o-Antakiya ne̱. Ye̱ ro̱ u̱n yoos-de u̱n Ma-to̱ m-Re̱re̱m, amba be-de u̱n Yahuda-ne̱ cot. ");
INSERT INTO uth_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Amba ye̱ ken yan-dor Ye̱so ye̱ ro kon so̱ o-Sayipurus, o-Kire̱ni ne̱, ye̱ neke̱ bo̱-o̱ o-Antakiya ye̱ nomote̱ ye̱ ro̱ Yahuda-ne̱ á u̱t-ma, ye̱ ro ye̱ u̱n nome̱ u̱n Ma-to̱ m-Re̱re̱m to̱ ma Ye̱so Wan-Ko̱yan. ");
INSERT INTO uth_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Be̱e̱b-de Shir ro mo̱sse̱ u̱n ye̱ ne̱, har hun-ne̱ de̱e̱n she̱re̱g be-de Shir. Ye̱ argu̱ m-warag ye̱ ma Wan-Ko̱yan. ");
INSERT INTO uth_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Ma-to̱ u̱n rii-yo ko̱re̱ o-Antakiya à, to̱ wo̱o̱ru̱ u̱n to̱-to̱ u̱n hun-ne̱ yan-dor Ye̱so ye̱ ro o-Urusharima à. Hun-ne̱ yan-dor Ye̱so komo ye̱ to̱mu̱ru̱ Barnabas ha-mo̱ u̱n re̱e̱no̱ o-Antakiya. ");
INSERT INTO uth_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Bo̱ wu̱ wo̱o̱nte̱ à, wu̱ hyanu̱ru̱ komo so̱k-mo̱ Shir nomo ye̱ à. Wu̱ no̱mu̱ru̱ o-zak. Wu̱ doo ye̱ kap jaab-o̱ u̱t-me̱n u̱nze ye̱ ma'as m-she̱r ne̱ n-me̱ u̱n Wan-Ko̱yan u̱n hur-u̱r gaan. ");
INSERT INTO uth_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Barnabas komo kashi u̱n ne̱t-wu̱, shiishe̱ u̱n Ku̱kt-o̱ Shir m-she̱r ne̱. Hun-ne̱ u̱t-mo̱o̱r ne̱ argu̱ m-waktu̱ne̱ be-u̱r Wan-Ko̱yan. ");
INSERT INTO uth_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Bo̱ u̱n kane̱ Barnabas argu̱ m-neke̱ o-Tarsus remen wu̱ ho̱bo̱nté̱ Shawuru. ");
INSERT INTO uth_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Bo̱ wu̱ hyantu̱ wu̱ à, wu̱ hantu̱ru̱ wu̱ o-Antakiya. Hak u̱r-bir, ye̱ m-mo̱rge̱ u̱n hun-ne̱ ne̱ yan-dor Ye̱so, ye̱ ro u̱n yoose̱ u̱n hun-ne̱ u̱t-mo̱o̱r ne̱. Kaane̱ u̱n bo̱-o o-Antakiya o̱ a ce̱te̱ m-aag u̱n yan-neke̱-m Ye̱so u̱n ka jin-de “Kiristi-ne̱.” ");
INSERT INTO uth_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","To̱, u̱n ka da-o̱ ye̱ ken yan-rwo̱r u̱n Ma-to̱ Shir ye̱ haante̱ o-Antakiya rwu̱u̱n-mo̱ o-Urusharima. ");
INSERT INTO uth_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Wan-gaan be-de u̱n ye̱, jin-de u̱n wu̱ Agabus, wu̱ inu̱ru̱ eso. Wu̱ no̱mu̱ru̱ u̱t-ma u̱n be̱e̱b-de o-Ku̱kt u̱nze a nom o̱ ken caari-o̱ u̱n me̱r-o̱ u̱n ho̱no o-dak kap (To̱ ka komo to̱ no̱mo̱g u̱n da-o̱ ko-Gwo̱mo Sisar Karadiyos no̱me̱ gwo̱mo-to̱ u̱n dak-to̱ o-Roma kap à). ");
INSERT INTO uth_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Yan-neke̱-m Ye̱so kupsu̱ u̱t-ma u̱nze ye̱ tomte̱ o̱r re u̱n ye̱ ne̱ gwu̱ ye̱ ro̱ n-me̱ dak-o̱ o-Judiya à, ko̱ wu̱ ke ho̱n u̱n 'wo̱ns-mo̱ u̱n wu̱. ");
INSERT INTO uth_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Ye̱ no̱mu̱ kaane̱, ye̱ to̱mu̱ru̱ yar-mo̱ m-gu u̱n hun-ne̱ yan-dor Ye̱so o-Judiya u̱n bu̱-yo u̱n kom-u̱t se̱k-ye̱ Barnabas ne̱ u̱n Shawuru. ");
INSERT INTO uth_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","U̱n ka da-o̱ ko-Gwo̱mo Here̱ Agirippa wu̱ ciru̱ rangse̱ u̱n ye̱ ken ye̱ be-de u̱n hun-ne̱ yan-dor Ye̱so. ");
INSERT INTO uth_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Here̱ rwo̱'o̱g a ho Yakubu, (heno Yohana), o-magay. ");
INSERT INTO uth_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Bo̱ wu̱ hyente̱ Yahuda-ne̱ ho̱gu̱te̱ re̱re̱m-mo̱ u̱n rii-yo wu̱ no̱me̱ à, wu̱ shipi Bitrus u̱n cen wu̱. A u̱n no̱m to̱ ka u̱n da-o̱ u̱n Biki-o̱ u̱t-Buro̱di to̱ ba m-Yist. ");
INSERT INTO uth_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Bo̱ Here̱ shipte̱ Bitrus à, wu̱ cu̱wtu̱ wu̱ u̱n kur-o̱ m-ke'et u̱n kom-to̱ u̱n karma-ne̱ o̱p u̱n cind 16 ye̱ eret wu̱. Wu̱ ro o-sakto̱ wu̱ hantu̱tu̱ wu̱ n-me̱ u̱n hun-ne̱ wu̱ piishitu̱ Bitrus u̱t-ma a komse̱ Biki-o̱ m-Pas. ");
INSERT INTO uth_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Bo̱ Bitrus rotte̱ n-me̱ u̱n kur-o̱ m-ke'et à, yan-dor Ye̱so se̱ngu̱ u̱s-ko̱n be-de Shir remen wu̱. ");
INSERT INTO uth_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","U̱n ka te̱t-mo̱ rii-yo Here̱ piishite̱ Bitrus u̱t-ma, Bitrus komo wu̱ ro gego n-te̱ kwo̱m-u̱t yoor. Wu̱ ro m-rew n-te̱te̱ o̱ u̱n karma-ne̱ ne̱n yoor. Yan-'er-de u̱n kur-o̱ m-ke'et komo ye̱ zu̱pste̱ ish ye̱ ro u̱r-'er. ");
INSERT INTO uth_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Da-o gaan, wu̱ ken wan-to̱m-wu̱ Wan-Ko̱yan wu̱ rwu̱u̱nu̱ru̱, mo̱ ken cecar-mo̱ caraksu̱ ka kuke̱-o̱. Ka da-de ka wan-to̱m-wu̱ Shir wu̱ ci'u̱ru̱ Bitrus n-riib wu̱ 'yonsu̱ru̱ wu̱. Wu̱ ze̱e̱ru̱, “Ine̱ ku̱sse̱.” Komo ka kwo̱m-to̱ argu̱ m-porme̱ u̱n kom-u̱t Bitrus. ");
INSERT INTO uth_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Wan-to̱m-wu̱ Shir ze̱e̱ru̱ Bitrus, “Co̱p matuku u̱n du, komo o cu̱p ka'ante̱-u̱t ru.” Wu̱ nomu̱ru̱ kaane̱. Wan-to̱m-wu̱ Shir ze̱e̱ru̱ wu̱, “Yap gwo̱do̱-o ru, o do̱nd me̱.” ");
INSERT INTO uth_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Bitrus argu̱ m-rwu̱u̱n wu̱ do̱ru̱ wu̱. Wu̱ nap u̱nze ka rii-yo wan-to̱m-wu̱ Shir ro m-no̱m à, nip-o̱ á, wu̱ hyene̱ wu̱ zee bo-o̱ re̱ wu̱. ");
INSERT INTO uth_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Bo̱ ye̱ arge̱ yan-'er-de ye̱ u̱r-takan u̱n ye̱ u̱r-bu̱ste̱ ne̱ à, ye̱ wo̱o̱ru̱ ish-o̱ o-kwo̱m o̱ u̱n co̱w-mo̱ o-bo̱. Ka ish-o̱ komo o̱ tikshiru̱ u̱n hi u̱n de u̱n o̱. Ye̱ argu̱ m-ru. Wo̱o̱n-mo̱ ka ye̱ wo̱o̱ne̱ u̱n yo ken co̱w-yo bo̱ ye̱ ro m-neke̱ à, da-o gaan wan-to̱m-wu̱ Shir argu̱ m-e̱ge̱. ");
INSERT INTO uth_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Ka da-de Bitrus mu̱u̱nu̱ru̱ u̱n we̱e̱r-se u̱n wu̱. Wu̱ ze̱e̱ru̱, “O-nip, m-mo̱ka u̱m nak u̱nze Wan-Ko̱yan-wu̱ to̱mne̱ wan-to̱m-wu̱ gu me̱ u̱n kom-u̱t Here̱, komo u̱n kap o̱ u̱n me̱n-u̱t jaas-to̱ ne̱, to̱ Yahuda-ne̱ ro̱ o-sakto̱ ye̱ nomotu̱ me̱ à.” ");
INSERT INTO uth_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Bo̱ Bitrus nepte̱ u̱n kaane̱ ne̱ à, wu̱ haaru̱ u̱n hur-o Meri, inu Yohana Markus, be-de hun-ne̱ mo̱rge̱ de̱e̱n ye̱ ro u̱s-ko̱n à. ");
INSERT INTO uth_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Bo̱ Bitrus raste̱ ish-o̱ u̱n pyo à, wu̱ ken wan-ne'a-wu̱, wu̱ ro m-se̱nge̱ u̱n ka hur-o̱ à, jin-de u̱n wu̱ Roda wu̱ haanu̱ru̱ wu̱ hyenet ko̱ wan wu̱ à. ");
INSERT INTO uth_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Bo̱ wu̱ ho̱gu̱te̱ co̱r Bitrus à, wu̱ wargu̱ru̱ n-me̱ o-rek remen wu̱ ru̱ru̱te̱ ye̱. Amba wu̱ baks m-tiks u̱n ish á remen o-zak. Wu̱ ru̱ru̱ ye̱ u̱nze Bitrus wu̱ ka u̱n ish-o̱ u̱n pyo eso. ");
INSERT INTO uth_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Ye̱ ze̱e̱ru̱ wu̱, “Zu̱ngo̱-o̱ wo̱tte̱!” Wu̱ ne̱ wu̱ se̱ngu̱ m-ze̱e̱, “Bitrus wu̱ ge̱.” Ye̱ ne̱ ye̱ ze̱e̱ru̱, “Wan-to̱m-wu̱ Shir-wu̱ u̱n wu̱ wu̱ o̱!” ");
INSERT INTO uth_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Bitrus se̱ngu̱ m-ko̱'o̱t u̱n ish. Bo̱ ye̱ tikshte̱ à, ye̱ hyanu̱ru̱ wu̱, ye̱ bo̱pu̱ nu-se u̱n ye̱. ");
INSERT INTO uth_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Wu̱ nomu̱ ye̱ o-napa o-kom ye̱ rest temb. Ka da-de wu̱ ru̱ru̱ ye̱ bo̱ Wan-Ko̱yan rwu̱ntu̱ wu̱ n-me̱ u̱n kur-o̱ m-ke'et à. Komo wu̱ ze̱e̱ru̱, “Ru̱ru̱ no̱ Yakubu u̱n hen-ne̱ ne̱ ye̱ kuse̱ à ka ma-to̱.” Ka da-de wu̱ inu̱ru̱ wu̱ neku̱ru̱ de ken be-de. ");
INSERT INTO uth_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Bo̱ ish geste̱ à, rwu̱k-mo̱ u̱r-hur mo̱ ine̱ be-de u̱n karma-ne̱ à, ba hiin o̱ á, u̱n remen rii-yo kume̱ Bitrus à. ");
INSERT INTO uth_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Bo̱ Here̱ ho̱btu̱ wu̱ à, wu̱ kum wu̱ á. Wu̱ se̱ngu̱ru̱ ye̱ m-cit u̱s-cot remen wu̱ hyenet o-nip, wu̱ ze̱e̱ru̱ a hoom ye̱. Bo̱ u̱n to̱ Here̱ inu̱ru̱ dak-o̱ o-Judiya, wu̱ neku̱ru̱ o-Kaseriya, wu̱ no̱mu̱ru̱ yan-ho̱ re̱e̱no̱. ");
INSERT INTO uth_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","U̱n ka da-o̱, Here̱ ro u̱n ryaab-se u̱n hun-ne̱ ye̱ o-Taya u̱n ye̱ o-Sidon ne̱ de̱e̱n. Ye̱ haanu̱ru̱ be-u̱r Here̱ u̱n hur-de u̱n ye̱ u̱r-gaan, komo ye̱ ho̱o̱bu̱ru̱ o-so̱ro̱g be-u̱r Birastus wan-co-o̱ pyo-o ko-Gwo̱mo, wu̱ ne̱ wu̱ deku̱ ma-to̱ u̱n ye̱ wu̱a gu ye̱. Ka da-de ye̱ haaru̱ be-u̱r Here̱, ye̱ ho̱o̱bu̱ wu̱ she'et-de ba u̱t-ween, remen dak-o̱ u̱n ka ko-Gwo̱mo-wu̱ ye̱ rotte̱ u̱r-be̱e̱b, remen o̱ ye̱tte̱ u̱n kum u̱n rii-yo m-re̱. ");
INSERT INTO uth_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Ho̱-de a hongse̱ à, Here̱ co̱pu̱ saw-to̱ u̱n wu̱ to̱ u̱t-gwo̱mo, wu̱ she'etu̱ru̱ u̱n de̱e̱g-o̱ u̱t-gwo̱mo, wu̱ nomu̱ ye̱ u̱t-ma. ");
INSERT INTO uth_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Bo̱ bu̱u̱g-de hun-ne̱ ho̱gu̱te̱ wu̱ à, ye̱ 'yonsu̱ u̱s-co̱r. Ye̱ ma'asu̱ru̱ m-ze̱e̱, “Ho̱gu̱ no̱ wu̱ ka ha! Co̱r-o̱ u̱n o̱ ken shir-o̱ o̱, o̱ u̱n ne̱t o̱ á!” ");
INSERT INTO uth_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Da-o gaan, wu̱ ken wan-to̱m-wu̱ Wan-Ko̱yan wu̱ wo̱su̱ Here̱, remen wu̱ yagu̱te̱ se̱ke̱mse̱ u̱n Shir. Ye̱ge̱-zwo̱ se̱ngu̱ wu̱ m-re̱ har wu̱ maru̱ru̱. ");
INSERT INTO uth_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Ma-to̱ Shir se̱ngu̱ re̱ co komo, to̱ se̱ngu̱ m-no̱m de̱e̱n. ");
INSERT INTO uth_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Da-o̱ Barnabas ne̱ u̱n Shawuru komse̱ se̱nge̱-mo̱ a rwo̱'u̱ ye̱ m-no̱m à, ye̱ jo'onu̱ru̱ so̱ o-Urusharima. Bo̱ ye̱ jo'onte̱ à, ye̱ neknu̱ru̱ u̱n Yohana Markus. ");
INSERT INTO uth_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","To̱, be-de u̱n hun-ne̱ yan-dor Ye̱so ye̱ ro o-Antakiya à, ye̱ ken yan-Rwo̱r u̱n Ma-to̱ Shir ye̱ ro kon u̱n yan-Yoos-de u̱n Ma-to̱ Shir ne̱. Ye̱ ro: Barnabas, u̱n Simo̱n ne̱ (wu̱ a m-aag Rim-wu̱ à), u̱n Rushiyos ne̱ (ko-ya-o-Kire̱ni), u̱n Manayen ne̱ (wu̱ bo̱'o̱se̱ be-u̱r gaan u̱n Here̱ Atipas ne̱ à), komo u̱n Shawuru ne̱. ");
INSERT INTO uth_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Da-de ye̱ ro Wan-Ko̱yan u̱n nome̱ u̱r-bo̱ngo̱n à, komo ye̱ ro u̱n nom o-swo̱o̱t. Ku̱kt-o̱ Shir ze̱e̱ru̱, “Hu̱ssu̱ me̱ no̱ Barnabas ne̱, u̱n Shawuru remen se̱nge̱-mo̱ u̱m agu̱ ye̱ ye̱ nom à.” ");
INSERT INTO uth_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Bo̱ ye̱ nomoste̱ o-swo̱o̱t u̱s-ko̱n ne̱ à, ye̱ ru̱'u̱ru̱ Barnabas ne̱, u̱n Shawuru kom-to̱ o-kwu̱m, ye̱ sarru̱msu̱ ye̱. ");
INSERT INTO uth_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Barnabas ne̱, u̱n Shawuru komo, Ku̱kt-o̱ Shir to̱mu̱ru̱ ye̱. Ye̱ neku̱ru̱ o-Sarukiya, komo re̱e̱no̱ ye̱ co̱we̱ hat-o̱ m-ho̱ ha-mo̱ o-Sayipurus. ");
INSERT INTO uth_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Bo̱ ye̱ wo̱o̱te̱ o-Saramis à, ye̱ ko̱'o̱te̱ Ma-to̱ Shir u̱n kuke̱-to̱ Yahuda-ne̱ to̱ u̱n yoos u̱n Ma-to̱ Shir. Yohana komo wu̱ ro mo̱sse̱ u̱n ye̱ ne̱, wu̱ ro ye̱ m-gu. ");
INSERT INTO uth_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Bo̱ ye̱ tu̱wu̱su̱te̱ u̱t-bo̱ u̱n ka dak-o̱ ho̱-m rigimse̱ kap à, ye̱ wo̱o̱ru̱ bo̱-o̱ o-Bapo̱s. Ye̱ go'onu̱ru̱ u̱n wu̱ ken ko-Yahuda-wu̱ ne̱ ko-ya-o-gwo̱t, wan-rwo̱r u̱n ma-to̱ shir ye̱ u̱t-bo̱, jin-de u̱n wu̱ Bar-Ye̱so. ");
INSERT INTO uth_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Wu̱ ro ko-nay ko-Gwamna Sarjiyus Burus. Gwamna Sarjiyus Burus komo ne̱t-wu̱ ko-ya-u̱s-we̱e̱r. Ko-Gwamna agbu̱ru̱ Barnabas ne̱, u̱n Shawuru remen wu̱ co̱no̱g wu̱ ho̱ge̱ Ma-to̱ Shir. ");
INSERT INTO uth_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Amba ka ko-ya-o-gwo̱t-wu̱ Arimos (jin-de u̱n wu̱ de ka u̱n rem-de u̱t-Girik), wu̱ shesu̱ ye̱ á, wu̱ ro u̱n o-hoob wu̱ miktu̱té̱ hi-de u̱n ka ko-Gwamna-wu̱ taase wu̱ dek ká ma-to̱ o-nip. ");
INSERT INTO uth_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Amba Shawuru, ka wu̱ a m-ze̱e̱ Burus à, wu̱ shiiste̱ u̱n Ku̱kt-o̱ Shir, wu̱ tuuru̱ Arimos yish. ");
INSERT INTO uth_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","Wu̱ ze̱e̱ru̱, “Wo̱ wà-wu̱ u̱n ko-Gwo̱mo-wu̱ u̱n ya-u̱t-ko̱t! Ko̱ de ke ho̱-de wo̱ hun-ne̱ u̱n nome̱ u̱t-bo̱, u̱n rem-u̱s yo̱-se ne̱. Yage̱ m-muut nip-o̱ Wan-Ko̱yan u̱t-bo̱. ");
INSERT INTO uth_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","M-mo̱ka ha, ryaab-se u̱n Wan-Ko̱yan ro̱ u̱n hi u̱n du, wo̱a warag ko-po̱. A dek ya o-da, ba wo̱ u̱n hyan cu̱cas-mo̱ u̱r-ho̱.” Da-o gaan, o̱ ken rar-o̱ o-comb ne̱ biti yish-ye̱ u̱n wu̱. Wu̱ se̱ngu̱ u̱t-tagab wu̱ u̱n hoob-o̱ u̱n wu̱ he wu̱ m-nak à. ");
INSERT INTO uth_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Bo̱ ko-Gwamna hyente̱ rii-yo no̱me̱ à, wu̱ argu̱ m-she̱r o-nip. Wu̱ hyanag made̱-o̱ u̱n yoos-u̱r Wan-Ko̱yan. ");
INSERT INTO uth_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Burus u̱n ya-u̱r-hew de u̱n wu̱ ne̱ ye̱ inu̱ru̱ o-Bapo̱s n-me̱ u̱n hat-o̱ m-ho̱. Ye̱ neku̱ru̱ o-Perga so̱ u̱n dak-o̱ o-Bampiriya. Yohana yagu̱ru̱ ye̱, wu̱ wargu̱ru̱ o-Urusharima. ");
INSERT INTO uth_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Ye̱ ne̱ ye̱ inu̱ru̱ cir-mo̱ o-Perga o-Antakiya ne̱ so̱ u̱n dak-o̱ o-Bisidiya. Ho̱-de u̱r-Wu̱we̱ de, ye̱ co̱wu̱ru̱ u̱n kuke̱-o̱ u̱n yoos u̱n Ma-to̱ Shir, ye̱ she'etu̱ru̱. ");
INSERT INTO uth_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Bo̱ a karante̱ taku̱rda-to̱ u̱n Ma-to̱ Shir à, se̱k-ye̱ ye̱ u̱n ká kuke̱-o̱ u̱n yoos u̱n Ma-to̱ Shir o̱ wootu̱ru̱ ye̱ to̱m u̱nze, “No̱ o̱r te̱ ne̱, u̱rege̱ no̱ u̱t-ma ne̱ to̱ no̱ hette̱ te̱ do ye̱ u̱n jaab-o̱ u̱t-me̱n à, no̱ nom.” ");
INSERT INTO uth_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Burus inu̱ eso, wu̱ jaksu̱ o-kom a re̱su̱ru̱ ce̱e̱n. Wu̱ ze̱e̱ru̱, “No̱ o̱r re u̱n Isra-ne̱, komo no̱ ye̱ ro̱ u̱n ‘Wan-se̱ps u̱n Shir,’ raks no̱! ");
INSERT INTO uth_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Shir ye̱ u̱n hun-ne̱ o-Isra dagante̱ tat-ne̱ te̱, wu̱ muute̱ ka hun-ne̱ ye̱ caari-o̱ o-dak u̱n da-o̱ ye̱ ro'e̱ u̱n dak-o̱ o-Masar à. Komo wu̱ rwu̱ntu̱ ye̱ u̱n ka dak-o̱ u̱r-be̱e̱b u̱t-gwo̱mo ne̱. ");
INSERT INTO uth_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Wu̱ mo̱'o̱g u̱r-hur u̱n ye̱ ne̱ be-de u̱s-hak kwo̱o̱z-u̱t yoor 40 n-me̱ o-ko̱t. ");
INSERT INTO uth_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Da-o̱ wu̱ sabarse̱ dak-u̱t ta'yoor u̱n dak-o̱ o-Kan'ana à, wu̱ ya'asu̱ru̱ hun-ne̱ ye̱ o-Isra saw-to̱ o-dak. ");
INSERT INTO uth_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","To̱ ka dek be-de u̱s-hak zungu-u̱s nass u̱n kwo̱o̱z-u̱t yoor u̱s-o̱p 450. “Bo̱ u̱n kaane̱ komo Shir sagbu̱ ye̱ con-ne̱ yan-piish u̱t-ma har ha-mo̱ u̱n da-o Sama'era wan-Rwo̱r u̱n Ma-to̱ Shir. ");
INSERT INTO uth_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Ka da-de, ye̱ ko̱nu̱ru̱ a sagbu̱ ye̱ ko-Gwo̱mo, Shir argu̱ ye̱ m-ya'as u̱n Shawuru wà Kish, ne̱t-wu̱ u̱n baag-o Banyamin, wu̱ no̱me̱ ye̱ u̱t-gwo̱mo har u̱s-hak kwo̱o̱z-u̱t yoor 40. ");
INSERT INTO uth_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Bo̱ Shir ruute̱ Shawuru à, wu̱ rwo̱'u̱ Dawuda wu̱ warag ko-Gwo̱mo-wu̱ u̱n ye̱. U̱n to̱r-se Shir no̱me̱ Dawuda ne̱ à, wu̱ ze̱e̱ru̱, ‘U̱m kumug Dawuda wà Je̱sse̱, ne̱t-wu̱, wu̱ u̱m co̱ne̱ m-so̱k ne̱ à. Wu̱ he m-no̱m kap o̱ u̱n bo̱ u̱n yo u̱m co̱ne̱ à.’ ");
INSERT INTO uth_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","“Raag-o̱ u̱n baag-o̱ u̱n ka ne̱t-wu̱ Shir hantu̱te̱ Isra-ne̱ Wan-Gwu̱, Ye̱so, bo̱ wu̱ e̱sse̱ u̱t-ma à. ");
INSERT INTO uth_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Rii-yo Ye̱so haante̱, Yohana Wa-m-Yo'os u̱n hun-ne̱ m-ho̱ ko̱'o̱tu̱te̱ hun-ne̱ ye̱ o-Isra Ma-to̱ Shir, kap ye̱ waktu̱ne̱ be-de Shir komo a yo'os ye̱ m-ho̱. ");
INSERT INTO uth_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Bo̱ Yohana nomte̱ ma-to̱ m-ko̱m u̱n se̱nge̱-mo̱ u̱n wu̱ à, wu̱ ze̱e̱ru̱, ‘¿Wan wu̱ ne̱ no̱ e̱sse̱ u̱m ro̱? Me̱ wu̱ ha ro̱ ka wu̱ ka wu̱ á. Amba wu̱ ken wu̱ ro̱ ko̱n wu̱ he m-haan u̱n jim u̱n de à, wu̱ ro̱ ko̱ rii-se m-gaag u̱n ka'ante̱-to̱ u̱n wu̱ me̱ bo'os m-us á.’ ");
INSERT INTO uth_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“No̱ o̱r re ne̱, baag-o Ibrahi, komo u̱n ye̱ ro̱ Yahuda-ne̱ á ‘Wan-se̱ps u̱n Shir’ be u̱n no̱, na ye̱ ha a to̱mne̱ ma-to̱ u̱n ka gwu̱-o̱. ");
INSERT INTO uth_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Remen ya-u̱r-she'et o-Urusharima u̱n se̱k-ye̱ ye̱ u̱n ye̱ ne̱, ye̱ nap u̱nze wu̱ ro̱ Wan-Gwu̱ á. Komo ye̱ nap ma-to̱ u̱n yan-Rwo̱r u̱n Ma-to̱ Shir to̱ a m-karante̱ u̱n ko̱ de ke Ho̱-de u̱r-Wu̱we̱ de á. Amba ye̱ shooste̱ ka ma-to̱ yan-Rwo̱r u̱n Ma-to̱ Shir to̱ be-de u̱n 'ya u̱n Ye̱so u̱r-ko̱o̱b. ");
INSERT INTO uth_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Ko̱ de̱ nomte̱ ye̱ ship wu̱ u̱n ba'as-de wo̱o̱'e̱ a hoot wu̱ á, myet u̱n kaane̱ ne̱ ye̱ ko̱nu̱ Biratus a ho wu̱. ");
INSERT INTO uth_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Bo̱ ye̱ shoossu̱te̱ kap o̱ u̱n bo̱ u̱n rii-yo a ge̱ne̱ mo̱sse̱ u̱n wu̱ ne̱ à, ye̱ kergu̱ntu̱ru̱ wu̱ n-dak u̱n cik-o o-ce, ye̱ rwo̱'u̱ wu̱ n-me̱ u̱n saag. ");
INSERT INTO uth_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Amba Shir 'yonstu̱ wu̱ u̱t-marimar. ");
INSERT INTO uth_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","U̱t-ho̱ komo de̱e̱n wu̱ ro m-rwu̱u̱n cas be-de u̱n ka ye̱ do̱ru̱ wu̱ ha-mo̱ o-Urusharima à, so̱ o-Gariri. Ye̱ ro̱ m-mo̱ka yan-swo̱-se u̱n ma-to̱ u̱n wu̱ be-de u̱n hun-ne̱ na. ");
INSERT INTO uth_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","“Te̱ ma te̱ hantu̱tu̱ no̱ Ma-to̱ m-Re̱re̱m, u̱nze ka Ma-to̱ Shir swo̱re̱ o-nu u̱n tat-ne̱ na ne̱ à. ");
INSERT INTO uth_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Da-de wu̱ 'yonse̱ Ye̱so u̱t-marimar à, wu̱ shoosu̱tu̱ na ká swo̱r o-nu o̱, na ye̱ ro̱ yakar-ye̱ u̱n ye̱ à. U̱ntu̱n bo̱ to̱ ro̱ gense̱ be-de u̱n se̱p-o ayoore̱-o̱ n-me̱ Se̱p-to̱ u̱r-Bo̱ngo̱n à u̱nze, “ ‘Wo̱ Wà re wu̱, Caane̱ u̱m waragte̱ Tato ru.’ ");
INSERT INTO uth_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Shir 'yonste̱ Ye̱so u̱t-marimar, Shir e̱ssu̱ssu̱te̱ Ye̱so a mer har wu̱ wu̱mu̱t á. O-nip ge̱, Shir shooste̱ to̱ ka ma-to̱ mo̱sse̱ u̱n ine̱-mo̱ u̱n wu̱ ne̱ u̱nze, ‘Man ya'as wo̱ ka kwu̱m-o̱, o̱ ba m-ku̱ko̱p o̱ u̱m nome̱ Dawuda ma-to̱ u̱n o̱ à.’ ");
INSERT INTO uth_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Remen n-me̱ u̱n o̱ ken Se̱p-to̱ u̱r-Bo̱ngo̱n to̱ wu̱ ze̱e̱g, ‘Wo̱ yage̱ Wan-ba-m-ku̱ko̱p ru wu̱mu̱t á.’ ");
INSERT INTO uth_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","“Bo̱ u̱n da-o̱ Dawuda komse̱ m-shoos u̱n se̱nge̱-mo̱ Shir ya'asu̱ wu̱ u̱n da-o̱ u̱n wu̱ à, wu̱ argu̱ m-mar. A jo̱ku̱ wu̱ u̱n tat-ne̱ ye̱ u̱n wu̱ ne̱, wu̱r-o̱ u̱n wu̱ wu̱mu̱ru̱ komo. ");
INSERT INTO uth_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Amba Ye̱so wu̱ Shir 'yonse̱ u̱t-marimar à wu̱ wu̱m u̱n saag á. ");
INSERT INTO uth_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","“Remen kaane̱, o̱r re ne̱, u̱m co̱no̱g no̱ nep u̱nze n-me̱ Ye̱so o̱ a m-soks u̱r-ba'as bo̱ me̱ no̱ m-ru̱re̱ à. ");
INSERT INTO uth_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Komo be-de u̱n wu̱ o̱ kap bo̱ u̱n wu̱ she̱re̱ o-nip à, wu̱ waragte̱ kashi u̱n ne̱t u̱n hyan-mo̱ Shir, rii-yo karamsa-o Mosa kuse̱ ba o̱ u̱n pya ke̱e̱r-de u̱n to̱ à. ");
INSERT INTO uth_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Remen kaane̱ muut no̱ u̱r-hi, taase ka rii-yo Shir rwo̱re̱ nu à, n-me̱ u̱n taku̱rda-to̱ u̱n yan-Rwo̱r u̱n Ma-to̱ Shir à, yo nom u̱n no̱ ne̱: ");
INSERT INTO uth_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","“ ‘Raks no̱, no̱ yan-no̱m u̱r-ar, made̱-o a ruk no̱, no̱ mer! Remen man nom mo̱ ken se̱nge̱-mo̱, u̱n ho̱-u̱t no̱, se̱nge̱-m no̱ a she̱r u̱n mo̱ ne̱ á, ko̱ wu̱ ken wu̱ ru̱ru̱ no̱!’ ” ");
INSERT INTO uth_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Bo̱ Burus ne̱, u̱n Barnabas ro m-rwu̱u̱n u̱n kuke̱-o̱ u̱n yoos u̱n Ma-to̱ Shir à, hun-ne̱ ko̱nu̱ru̱, ye̱ do ye̱ nome̱ u̱t-ma n-te̱ u̱n ka rem-se komo u̱n Ho̱-de u̱r-Wu̱we̱ de ro̱o̱ne̱ à. ");
INSERT INTO uth_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Bo̱ hun-ne̱ caagu̱te̱ à, Yahuda-ne̱ u̱t-mo̱o̱r ne̱, komo u̱n Girik-ne̱ ye̱ muute̱ hi u̱n de u̱n ye̱ Yahuda-ne̱ à, u̱n ye̱ do̱ru̱ Burus ne̱, u̱n Barnabas. Ye̱ komo ye̱ nome̱ ye̱ u̱t-ma ye̱ do̱o̱ru̱ m-'wo̱ns remen ye̱ reet co u̱r-she'et n-me̱ u̱n yar-mo̱ Shir. ");
INSERT INTO uth_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Bo̱ Ho̱-de u̱r-Wu̱we̱ riginte̱ à, sa o zee ho̱no o-bo̱ kargu̱ru̱ be-u̱r gaan remen ye̱ ho̱gu̱té̱ Ma-u̱t Wan-Ko̱yan. ");
INSERT INTO uth_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Amba bo̱ Yahuda-ne̱ hyente̱ mo̱ro̱g-de u̱n hun-ne̱ de̱e̱n à, shoob-u̱r ho̱o̱ru̱ ye̱. Ye̱ de̱k ma-to̱ Burus rwo̱re̱ á, ye̱ ro u̱n re̱e̱b-to̱ u̱n wu̱. ");
INSERT INTO uth_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Amba Burus ne̱, u̱n Barnabas ye̱ no̱mu̱ u̱t-ma ba o-gye̱r. Ye̱ ze̱e̱ru̱. “No̱ Yahuda-ne̱ no̱ depe̱ a cire̱ no̱me̱ u̱n Ma-to̱ Shir. Amba bo̱ no̱ yagu̱ to̱ à, no̱ rwu̱ntu̱te̱ o̱ ka no̱ depe̱ no̱ kum ho̱o̱g-mo̱ ba m-ta á. To̱, te̱ u̱n neke̱ be-de u̱n ye̱ ro̱ Yahuda-ne̱ á. ");
INSERT INTO uth_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Remen Wan-Ko̱yan be'esu̱te̱ wu̱ ru̱'u̱ste̱ te̱ bo̱ wu̱ ze̱e̱ à, “ ‘U̱m rwo̱'o̱g wo̱ o wakte̱ m-cecas be-de u̱n ye̱ ro̱ Yahuda-ne̱ á. Remen o hantu̱te̱ gwu̱ o̱ u̱n ho̱no o-dak.’ ” ");
INSERT INTO uth_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Bo̱ ye̱ ro̱ Yahuda-ne̱ á ho̱gu̱te̱ kaane̱ à, ye̱ ho̱gu̱ m-re̱re̱m de̱e̱n. Ye̱ bo̱mu̱ ma-u̱t Wan-Ko̱yan. Kap ye̱ Shir daage̱ remen ye̱ kumut ho̱o̱g-mo̱ ba m-ta komo ye̱ she̱ru̱ o-nip. ");
INSERT INTO uth_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Ma-u̱t Wan-Ko̱yan komo to̱ semu̱ru̱ u̱n ka dak-o̱ kap. ");
INSERT INTO uth_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Amba Yahuda-ne̱ swo̱wu̱ru̱ ye̱ ken ne'a-ne̱ ye̱ “Yan-se̱ps u̱n Shir,” ye̱ a m-'ya u̱t-go̱s à, komo u̱n ye̱ ken campo̱-ne̱ ye̱ ne̱ u̱n caari-ye̱ u̱n hun-ne̱ ne̱ ye̱ u̱n bo̱-o̱ u̱n ye̱ ne̱. Ye̱ 'yonsu̱ u̱t-ween u̱n Burus ne̱, u̱n Barnabas, ye̱ yanu̱ ye̱ u̱n bo̱-o̱ u̱n ye̱. ");
INSERT INTO uth_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Ye̱ kuktu̱ru̱ hu-mo̱ u̱n na-se u̱n ye̱ u̱n rem o-napa be-de u̱n hun-ne̱ ye̱ o-bo̱, ye̱ neku̱ru̱ bo̱-o̱ o-Iko̱niya. ");
INSERT INTO uth_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Yan-neke̱-m Ye̱so ye̱ o-zak de̱e̱n, komo ye̱ ro shiishe̱ ce̱ng u̱n Ku̱kt-o̱ Shir. ");
INSERT INTO uth_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Komo, u̱n bo̱-o̱ o-Iko̱niya, Burus ne̱, u̱n Barnabas ye̱ co̱wu̱ru̱ kuke̱-o̱ Yahuda-ne̱ o̱ u̱n yoos u̱n Ma-to̱ Shir bo̱ ye̱ we̱te̱ à. Ye̱ ko̱'o̱tu̱ru̱ Ma-to̱ Shir u̱n be̱e̱b-de Ku̱kt-o̱ Shir, har hun-ne̱ de̱e̱n Yahuda-ne̱ u̱n ye̱ ro̱ Yahuda-ne̱ á, ye̱ she̱re̱g be-de Shir. ");
INSERT INTO uth_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Amba Yahuda-ne̱ ye̱ yage̱ m-she̱r be-de Shir à, ye̱ argu̱ m-swo̱wo̱g u̱n ye̱ ro̱ Yahuda-ne̱ á, ye̱ naasu̱ she'et-de u̱n ye̱ u̱n yan-dor Ye̱so ne̱. ");
INSERT INTO uth_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Myet u̱n kaane̱ ne̱, Burus u̱n Barnabas ye̱ she'etu̱ kane̱ de̱e̱n, ye̱ ro u̱n ko̱'o̱t u̱n Ma-to̱ Shir ba o-gye̱r bo̱ Wan-Ko̱yan ze̱e̱ ye̱ à. Wan-Ko̱yan komo wu̱ su̱u̱te̱ ma-to̱ u̱n wu̱ m-yar, a nomot u̱s-napa u̱n saw-to̱ o-made̱ ne̱ u̱n kom-to̱ u̱n ye̱. ");
INSERT INTO uth_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Amba hun-ne̱ ye̱ u̱n bo̱-o̱ o-Iko̱niya wongu̱ be-u̱t yoor, ye̱ ken ye̱ ro u̱n shas-o̱ Yahuda-ne̱, ye̱ ken ye̱ komo u̱n shas-o̱ u̱n yan-To̱m Ye̱so. ");
INSERT INTO uth_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Ye̱ ro Yahuda-ne̱ á u̱n Yahuda-ne̱ ne̱ mo̱sse̱ u̱n se̱k-ye̱ ye̱ u̱n ye̱ ne̱, ye̱ argu̱ m-zo̱nge̱ ye̱ yo'ogté̱ yan-To̱m Ye̱so, ye̱ jirit ye̱ u̱t-ta'ar. ");
INSERT INTO uth_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Bo̱ yan-To̱m Ye̱so ho̱gu̱te̱ kaane̱ à, ye̱ so̱mu̱ru̱ ha-mo̱ u̱n bo̱-to̱ o-Risiya o-Darbe̱ ne̱, u̱n bo̱-to̱ ro̱ o-he̱r à. Ka to̱ ro̱ u̱n dak-o̱ o-Riko̱niya. ");
INSERT INTO uth_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","U̱n ka be-to̱ ye̱ ro ko̱'o̱tte̱ Ma-to̱ m-Re̱re̱m. ");
INSERT INTO uth_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","U̱n bo̱-o̱ o-Risiya, komo wu̱ ken ne̱t-wu̱ ro kon ko-ryam, wu̱ we̱t u̱r-hew á cin bo̱ a matu̱ wu̱ à. Wu̱ ro tara, ");
INSERT INTO uth_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","wu̱ ro̱ u̱n raks u̱n ko̱'o̱t-o Burus. Burus tuuru̱ wu̱ yish. Bo̱ Burus hyente̱ wu̱ ro m-she̱r ne̱ mo̱ wo̱o̱'e̱ a taaste̱ go̱m-o̱ u̱n wu̱ à, ");
INSERT INTO uth_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","wu̱ 'yonsu̱ co̱r m-'wo̱ns ne̱. Wu̱ zee, “Ine̱, o es u̱n na-u̱s ru!” Ka ne̱t-wu̱ argu̱ m-ine̱ u̱t-no̱sse̱ komo wu̱ taknu̱ u̱r-hew. ");
INSERT INTO uth_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Bo̱ bu̱u̱g-de u̱n hun-ne̱ hyente̱ rii-yo Burus no̱me̱ à, ye̱ 'yonsu̱ u̱s-co̱r. Da-o gaan ye̱ ma'asu̱ m-ze̱e̱ u̱n rem-de u̱t-Riko̱niya, “O-nip, ye̱ge̱-shir haantu̱ na u̱n sha-mo̱ u̱n hun-ne̱!” ");
INSERT INTO uth_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Ye̱ e̱gu̱ Barnabas u̱r-jin Ze̱yus, Burus ne̱, ye̱ e̱gu̱ wu̱ He̱rme̱s, remen wu̱ ro co-o̱ u̱t-ma. ");
INSERT INTO uth_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Wan-Co̱w u̱n ko̱n-se shir Ze̱yus, wu̱ pyo-o̱ u̱n wu̱ ro u̱n jim-de o-bo̱ à. Wan-co̱w-wu̱ u̱n ko̱n-se shir Ze̱yus, wu̱ hantu̱ru̱ ye̱ge̱-na, u̱t-mo̱k ne̱ u̱n ish-o̱ o-bo̱. Ká wan-co̱w-wu̱ u̱n ko̱n-se shir Ze̱yus wu̱ mo̱sse̱ u̱n hun-ne̱ ne̱, ye̱ co̱no̱g ye̱ nome̱ yan-To̱m Ye̱so u̱t-seke̱. ");
INSERT INTO uth_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Amba bo̱ ka yan-To̱m Ye̱so ye̱, Barnabas ne̱ u̱n Burus, ho̱gu̱te̱ kaane̱ à, ye̱ yoogu̱ matuku-to̱ u̱n ye̱. Ye̱ haaru̱ u̱n bu̱u̱g-de u̱n hun-ne̱ u̱s-rek, ye̱ u̱n 'yons u̱s-co̱r m-'wo̱ns ne̱ ye̱ ro m-ze̱e̱, ");
INSERT INTO uth_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“¿Remen ya no̱tte̱ m-no̱m kàane̱? Ai, te̱ ma hun-ne̱ ye̱ u̱ntu̱n no̱, Ma-to̱ m-Re̱re̱m te̱ hantu̱ no̱, remen no̱ tukuté̱ ka rem-se o-hwaa se o-cin, komo no̱ waktu̱nte̱ be-de Shir wan-ho̱o̱g, wu̱ no̱me̱ o-To̱n, o-dak ne̱ à, m-sa ne̱, komo u̱n kap o̱ u̱n rii-yo ro̱ ne̱ n-me̱ u̱n to̱ à. ");
INSERT INTO uth_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","U̱n da-o̱ n-ga, wu̱ yagu̱te̱ kap o̱ u̱n hun-ne̱ ye̱ nom bo̱ ye̱ hyane̱ m-so̱k à. ");
INSERT INTO uth_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Kap u̱n kaane̱ ne̱ komo, wu̱ we̱t u̱n yage̱ u̱n hi u̱n de u̱n wu̱ ba o-napa á. Wu̱ wu̱ ro̱ no̱ u̱n 'ya u̱n kem, o-go̱s u̱n rem-se o-kat ne̱. Wu̱ ro̱ no̱ m-coks u̱n rii-yo m-re̱, wu̱ ro̱ no̱ komo u̱n rwo̱ u̱n zak-o̱ u̱t-me̱n.” ");
INSERT INTO uth_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Myet u̱n to̱ ka ma-to̱ ne̱, ba u̱n yish pus-se ye̱ hokse̱ ka hun-ne̱ ye̱ m-we̱n u̱n no̱m u̱t-seke̱ remen ye̱ á. ");
INSERT INTO uth_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Amba ye̱ ken Yahuda-ne̱ ye̱ haanu̱ru̱ rwu̱u̱n-mo̱ o-Antakiya o-Iko̱niya ne̱, ye̱ hoksu̱ru̱ hun-ne̱ ye̱ jiru̱ru̱ Burus u̱t-ta'ar ye̱ naku̱ wu̱ ha-mo̱ u̱n jim-de o-bo̱, ye̱ hyene̱ ye̱ zee wu̱ mereste̱. ");
INSERT INTO uth_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Amba bo̱ yan-neke̱-m Ye̱so mo̱rge̱ ye̱ riktu̱ wu̱ à, wu̱ inu̱ru̱ wu̱ wargu̱ru̱ n-me̱ o-bo̱. Gas-o ish komo wu̱ neku̱ bo̱-o̱ o-Darbe̱ u̱n Barnabas ne̱. ");
INSERT INTO uth_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Bo̱ Burus ne̱ u̱n Barnabas ko̱'o̱tte̱ Ma-to̱ m-Re̱re̱m o-Darbe̱ à, komo ye̱ kumu̱ru̱ yan-neke̱-m Ye̱so u̱t-mo̱o̱r ne̱, ye̱ wargu̱ru̱ o-Risiya, o-Iko̱niya ne̱, komo o-Antakiya ne̱, ");
INSERT INTO uth_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","ye̱ ro m-do'e̱ u̱n yan-neke̱-m Ye̱so u̱r-be̱e̱b, ye̱ ro ye̱ m-'ya m-'wo̱ns be-de m-she̱r be-de Shir. Ye̱ ro̱ m-ze̱e̱, “Se̱ mo̱sse̱ u̱n swo̱ u̱r-ko̱o̱b ne̱ de̱e̱n a hette̱ co̱w u̱n gwo̱mo-to̱ Shir.” ");
INSERT INTO uth_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Komo bo̱ ye̱ degu̱rsu̱te̱ ye̱ se̱k-ye̱ u̱n ko̱ de ke bu̱u̱g-de u̱n yan-dor Ye̱so de à, mo̱sse̱ u̱s-ko̱n ne̱ o-swo̱o̱t ne̱ à, ye̱ tabbu̱ ye̱ be-u̱r Wan-Ko̱yan, wu̱ ye̱ she̱re̱ be-de u̱n wu̱ à. ");
INSERT INTO uth_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Ye̱ do̱ru̱ru̱ so̱ u̱n dak-o̱ o-Bisidiya ha-mo̱ o-Bampiriya. ");
INSERT INTO uth_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Komo bo̱ ye̱ ru̱rte̱ Ma-to̱ Shir u̱n bo̱-o̱ o-Perga à, ye̱ argu̱ m-neke̱ bo̱-o̱ o-Attariya. ");
INSERT INTO uth_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Bo̱ u̱n kane̱ komo ye̱ daaru̱ hat-o̱ m-ho̱ ye̱ wargu̱ o-Antakiya. Yan-dor Ye̱so seku̱ru̱ ye̱ u̱t-kom remen ka se̱nge̱-mo̱ Shir ya'u̱ ye̱ à. U̱n bu̱-yo u̱n yar-mo̱ Shir, ye̱ komoste̱ ka se̱nge̱-mo̱. ");
INSERT INTO uth_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Bo̱ ye̱ wo̱o̱nte̱ à, ye̱ mo̱ro̱gsu̱ hun-ne̱ yan-dor Ye̱so ye̱ rwo̱ru̱ kap rii-yo Shir no̱me̱ be-de u̱n ye̱ à, komo u̱n bo̱ wu̱ tikshe̱ ye̱ ro̱ Yahuda-ne̱ á ish-o̱ m-she̱r o-nip à. ");
INSERT INTO uth_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Ye̱ she'etu̱ndu̱ru̱ re̱e̱no̱ o-da ne̱ de̱e̱n mo̱sse̱ u̱n yan-neke̱-m Ye̱so ne̱. ");
INSERT INTO uth_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Ye̱ ken hun-ne̱ ye̱ haanu̱ru̱ komo o-Antakiya rwu̱u̱n-mo̱ dak-o̱ o-Judiya. Ye̱ ro m-yoose̱ u̱n yan-dor Ye̱so, ye̱ m-ze̱e̱, “U̱rege̱ a ko̱ no̱ u̱r-ko̱ bo̱ jind-o Mosa ze̱e̱ á, no̱a hoks kum u̱n gwu̱ á.” ");
INSERT INTO uth_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Ma-u̱t su̱nu̱ru̱ Burus u̱n Barnabas ne̱ u̱n ka hun-ne̱ ye̱ ne̱ remen u̱n ka ma-to̱. Amba a rwo̱'u̱ Burus ne̱ u̱n Barnabas komo u̱n ye̱ ken ye̱ ne̱, ye̱ neke̱ o-Urusharima be-de u̱n yan-To̱m Ye̱so u̱n se̱k-ye̱ ye̱ u̱n hun-ne̱ ne̱ yan-dor Ye̱so remen ye̱ oromté̱ u̱n ka ma-to̱. ");
INSERT INTO uth_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Hun-ne̱ yan-dor Ye̱so o-Antakiya shiiru̱ ye̱, ye̱ neku̱ru̱ ye̱ do̱ru̱ru̱ so̱ u̱n dak-o̱ o-Pinikiya o-Samariya ne̱, ye̱ ro m-rwo̱r bo̱ ye̱ ro̱ Yahuda-ne̱ á she̱re̱ o-nip à. To̱ ka rwo̱'u̱ kap yan-dor Ye̱so no̱m u̱n zak-o̱ u̱t-me̱n de̱e̱n. ");
INSERT INTO uth_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Bo̱ ye̱ woote̱ o-Urusharima à, kap o̱ u̱n hun-ne̱ yan-dor Ye̱so, u̱n yan-To̱m Ye̱so ne̱, u̱n se̱k-ye̱ ye̱ u̱n hun-ne̱ yan-dor Ye̱so ne̱, ye̱ barku̱ ye̱. Burus ne̱ u̱n Barnabas ru̱ru̱ ye̱ kap rii-yo Shir no̱me̱ be-de u̱n ye̱ à. ");
INSERT INTO uth_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Amba ye̱ ken Parisa-ne̱ ye̱ waragte̱ yan-dor Ye̱so, ye̱ inu̱ eso, ye̱ ze̱e̱ru̱, “Depete̱ ye̱ ro̱ yan-Yahuda-ne̱ á m-do̱re̱ karamsa-o Mosa komo se a ko̱o̱g ye̱.” ");
INSERT INTO uth_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Yan-To̱m Ye̱so u̱n se̱k-ye̱ ne̱ be-de u̱n hun-ne̱ yan-dor Ye̱so ye̱ mo̱rgu̱ru̱ remen ye̱ pu̱'u̱sté̱ u̱t-orom n-te̱ u̱n ka ma-to̱. ");
INSERT INTO uth_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Bo̱ ma-u̱t su̱nu̱te̱ ye̱ m-so̱k ne̱ o-da ne̱ de̱e̱n à, Bitrus inu̱ eso. Wu̱ ze̱e̱ru̱ ye̱, “O̱r re ne̱, no̱ nepste̱ cin o-da ne̱ Shir daagu̱ me̱ be u̱n no̱, u̱nze ye̱ ro̱ Yahuda-ne̱ á he ho̱ge̱ u̱n Ma-to̱ m-Re̱re̱m, komo ye̱ she̱r o-nip. ");
INSERT INTO uth_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Shir komo wu̱ nape̱ hur-de u̱n ko̱wan à, wu̱ rwu̱ntu̱te̱ u̱nze wu̱ go̱kstu̱ ye̱ bo̱ wu̱ ya'u̱ ye̱ Ku̱kt-o̱ Shir à, bo̱ wu̱ ya'u̱ na à. ");
INSERT INTO uth_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Komo wu̱ kutu̱ na m-koos u̱n ye̱ ne̱ á, u̱n remen wu̱ muute̱ hur-to̱ u̱n ye̱ cas cas be-de m-she̱r o̱ u̱n ye̱. ");
INSERT INTO uth_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","¿Yan yo ne̱ no̱tte̱ u̱n meger-to̱ Shir? A m-meger u̱n Shir u̱rege̱ a gaktu̱te̱ ye̱ ken ye̱ do̱ro̱tte̱-o̱ o-karamsa. Ko̱ na u̱n tat na ne̱, a jesu̱su̱te̱ ka karamsa-o̱ ko̱yanda! ");
INSERT INTO uth_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Amba a she̱re̱g u̱nze be-de u̱n yar-m Wan-Ko̱yan Ye̱so a kum gwu̱, u̱ntu̱n ye̱ ma bo̱ ye̱ kume̱ à.” ");
INSERT INTO uth_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Myet o̱ u̱n mo̱ro̱g-de u̱n hun-ne̱ re̱e̱su̱ ceen, ye̱ raksu̱ru̱ Barnabas ne̱ u̱n Burus. Ka da-de, Barnabas ne̱ u̱n Burus rwo̱re̱ ma-to̱ u̱s-napa, u̱n rem-se o-made̱ ne̱ se Shir nome̱ be-de u̱n ye̱ à, n-me̱ u̱n ye̱ ro̱ Yahuda-ne̱ á. ");
INSERT INTO uth_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Bo̱ ye̱ komoste̱ u̱t-ma à, Yakubu shasu̱ru̱. Wu̱ zee, “O̱r re ne̱, raag no̱ me̱. ");
INSERT INTO uth_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simo̱n rwo̱ro̱g bo̱ Shir cire̱ co̱n-to̱ u̱n ye̱ ro̱ Yahuda-ne̱ á, be-de u̱n de̱k u̱n ye̱ ken hun-ne̱ ye̱ be-de u̱n ye̱, ye̱ waragté̱ ye̱ ma u̱n wu̱. ");
INSERT INTO uth_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","To̱ ka komo to̱ no̱mo̱g u̱r-hond u̱n ma-to̱ yan-Rwo̱r u̱n Ma-to̱ Shir ne̱. Bo̱ to̱ ro gense̱ à u̱nze, ");
INSERT INTO uth_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","“ ‘A nomse̱ kaane̱ man mu̱u̱n u̱m ja'as ma u̱n hur-o Dawuda o̱ bu̱'u̱ge̱ à, Ko̱ de̱ nomte̱ o̱ bu̱'u̱gsu̱te̱ à, man ja'assu̱ o̱ m-ma, komo u̱m 'yons o̱. ");
INSERT INTO uth_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Kaane̱ ges-o̱ u̱n hun-ne̱ hette̱ me̱ m-ho̱o̱b me̱ Yawe, ye̱ ro̱ Yahuda-ne̱ á ye̱ u̱m daage̱ ye̱ waragté̱ ye̱ ma re à. Kaane̱ Yawe rwo̱re̱, wu̱ rwo̱re̱ bo̱ u̱n se, ");
INSERT INTO uth_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","u̱m rwo̱'o̱g hun-ne̱ re ye̱ nep ka rem-se cin n-ga.’ ");
INSERT INTO uth_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","“Remen kaane̱ u̱m hyanag u̱depe̱ a su'e̱ ye̱ ro̱ Yahuda-ne̱ á ye̱ ro̱ u̱n waktu̱ne̱ be-de Shir à. ");
INSERT INTO uth_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","U̱n su̱ge̱-de u̱n kaane̱ ma a genu̱ ye̱ o-taku̱rda a ru̱ru̱ ye̱ taase ye̱ re̱ rii-yo m-re̱ yo a tebbe̱ pyo-o̱ m-gir á, taase ye̱ nom o-ás, ko̱ ye̱ ti ap-mo̱ u̱n gu̱t-de a pane̱ á, komo m-hyó ne̱. ");
INSERT INTO uth_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Remen hun-ne̱ ko̱'o̱te̱ karamsa-o Mosa u̱n ko̱ o̱ ke bo̱-o̱. Cin u̱n zaman-yo n-ga, ye̱ no̱mo̱ste̱ kaane̱ u̱n kuke̱-to̱ u̱n yoos u̱n Ma-to̱ Shir u̱n ko̱ de ke Ho̱-de u̱r-Wu̱we̱ de.” ");
INSERT INTO uth_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Yan-To̱m Ye̱so u̱n se̱k-ye̱ ne̱, mo̱sse̱ u̱n kap o̱ u̱n hun-ne̱ ne̱ yan-dor, ye̱ hyanu̱ru̱ depete̱ ye̱ deeg ye̱ ken ye̱ be-de u̱n ye̱, ye̱ tomot ye̱ ha-mo̱ o-Antakiya mo̱sse̱ u̱n Burus ne̱ u̱n Barnabas. Ye̱ dagnu̱ Yahudas (wu̱ a m-ze̱e̱ Baru̱sabas à), komo u̱n Siras ne̱, ye̱ ro̱ go̱s-ye̱ be-de yan-dor à. ");
INSERT INTO uth_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Ye̱ ya'asu̱ru̱ taku̱rda-o̱ ro̱ m-ze̱e̱ à: “Be-de u̱n o̱r no̱ ne̱, yan-To̱m Ye̱so u̱n se̱k-ye̱ ne̱ ye̱ u̱n hun-ne̱ yan-dor, ha-mo̱ u̱n yan-dor ye̱ ro̱ baag-o̱ u̱n ye̱, Yahuda-ne̱ ye̱ á, u̱n bo̱-o̱ o-Antakiya, komo u̱n dak-to̱ o-Siriya ne̱ u̱n o̱ o-Kirikiya ne̱, te̱ u̱r-gas. ");
INSERT INTO uth_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","A kumug m-ho̱ge̱ u̱nze ye̱ ken be u̱n na ye̱ ya'ag no̱ u̱r-ko̱o̱b u̱n ma-to̱ u̱n ye̱. Ye̱ zo̱'o̱gsu̱tu̱ no̱, ko̱ de nomte̱ à a rwo̱ ye̱ m-no̱m kaane̱ á. ");
INSERT INTO uth_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Remen kaane̱, bo̱ te̱ pu̱'u̱ste̱ u̱t-orom à, te̱ hyanu̱ru̱ no̱mo̱g u̱r-bon te̱ deger ye̱ ken ye̱ te̱ to̱mbu̱ no̱ ye̱, u̱n o̱r na ne̱, ye̱ ro̱, Barnabas ne̱ u̱n Burus. ");
INSERT INTO uth_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Ye̱ ya'ase̱ ho̱o̱g-mo̱ u̱n ye̱ remen jin-u̱r Wan-Ko̱yan na Ye̱so Kiristi. ");
INSERT INTO uth_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Remen kaane̱, te̱ to̱mbu̱te̱ Yahudas u̱n Siras. Ye̱ u̱n hi u̱n de u̱n ye̱ ye̱a rwu̱ntu̱ no̱ nip-o̱ u̱n ka rem-se u̱n nu-o̱ u̱n ye̱. ");
INSERT INTO uth_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Ku̱kt-o̱ Shir hyanag no̱mo̱g u̱r-bon, kaane̱ komo te̱ hyane̱ no̱mo̱g u̱r-bon, taase a ru̱'u̱ no̱ se ken nu̱-se arge̱ se̱ ka rem-se se a ya'asu̱ no̱ à. ");
INSERT INTO uth_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Taase no̱ re rii-yo a tebbe̱ pyo-o̱ m-gir á, m-ap mo̱ a seke̱ à, mo̱sse̱ m-hyó ne̱, u̱n ti-m ap-mo̱ u̱r-gu̱t ne̱ de a miggre̱ u̱r-ge̱ks à, komo o-ás ne̱. U̱rege̱ no̱ e̱re̱g hi u̱n no̱ be-de u̱n se ka rem-se, no̱ no̱mo̱g o̱ ka rii-yo u̱r-bon. She'et no̱ gwu̱gwu̱.” ");
INSERT INTO uth_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","A to̱mu̱ru̱ ye̱, ye̱ neku̱ru̱ o-Antakiya. Bo̱ ye̱ karaksu̱te̱ hun-ne̱ yan-dor Ye̱so à, ye̱ ya'asu̱ru̱ o-taku̱rda. ");
INSERT INTO uth_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Bo̱ hun-ne̱ karantu̱te̱ o-taku̱rda komo à, ye̱ no̱mu̱ru̱ zak-o̱ u̱t-me̱n u̱n remen so̱ro̱g-yo ye̱ kume̱ à. ");
INSERT INTO uth_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Yahudas u̱n Siras komo, remen ye̱ hi u̱n de u̱n ye̱ yan-Rwo̱r u̱n Ma-to̱ Shir ye̱, ye̱ naku̱ru̱ o̱r u̱n ye̱ ne̱ u̱t-to̱ u̱t-ma ne̱ de̱e̱n, ye̱ dooru̱ ye̱ m-'wo̱ns. ");
INSERT INTO uth_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Bo̱ ye̱ nomoste̱ u̱t-ho̱ hiin u̱n ka be-de à, a argu̱ ye̱ m-'yons gwu̱gwu̱, ye̱ wargu̱ru̱ be-de u̱n ye̱ to̱mnu̱ ye̱ à. ");
INSERT INTO uth_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Burus ne̱ u̱n Barnabas rewu̱ru̱ u̱t-ho̱ hiin o-Antakiya. Ye̱ ro u̱n ye̱ ken hun-ne̱ ye̱ ne̱ de̱e̱n, ye̱ ro u̱r-yoos, ye̱ ro komo u̱n rwo̱r u̱n Ma-to̱ m-Re̱re̱m to̱ ma Wan-Ko̱yan. ");
INSERT INTO uth_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Bo̱ a nomte̱ u̱t-ho̱ hiin à, Burus ze̱e̱ru̱ Barnabas, “Haan a do̱re̱ kap bo̱-to̱ a ru̱rte̱ Ma-to̱ m-Re̱re̱m to̱ ma Wan-Ko̱yan n-ga à, a gasté̱ o̱r na ne̱, a hyenet bo̱ ye̱ ro̱ à.” ");
INSERT INTO uth_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Barnabas co̱nu̱ru̱ ye̱ dek Yohana Markus ye̱ neku̱té̱ u̱n wu̱ ne̱. ");
INSERT INTO uth_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Amba Burus hyanu̱ru̱ u̱ no̱m u̱r-bon ye̱ neke̱ u̱n Markus ne̱ á remen n-ga wu̱ ro yagu̱su̱tu̱ ye̱ u̱n dak-o̱ o-Bampiriya, komo wu̱ yagu̱te̱ re̱ co m-se̱nge̱ be-u̱r gaan u̱n ye̱ ne̱. ");
INSERT INTO uth_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Ko̱o̱b-de o-acu̱nde̱ no̱mo̱g ye̱ de̱e̱n har wo̱o̱ru̱ ye̱ m-wonge̱. Barnabas de̱ku̱ru̱ Markus, ye̱ co̱wu̱ru̱ hat-o̱ m-ho̱ ha-mo̱ o-Sayipurus. ");
INSERT INTO uth_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Amba Burus daagu̱ Siras. Da-o̱ yan-dor ru̱'u̱su̱ ye̱ n-me̱ u̱n yar-m Wan-Ko̱yan mo̱ eret ye̱ à, ye̱ inu̱ru̱. ");
INSERT INTO uth_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Ye̱ do̱ru̱ru̱ so̱ u̱n dak-to̱ o-Siriya o-Kirikiya ne̱, ye̱ ro hun-ne̱ yan-dor Ye̱so u̱n do ye̱ u̱r-be̱e̱b. ");
INSERT INTO uth_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Burus haaru̱ o-Darbe̱, o-Ristira ne̱. Wu̱ ken ko-ya-neke̱-m Ye̱so wu̱ ro n-me̱ o-Risiya à, jin-de u̱n wu̱ Timoti, wà-wu̱ u̱n wu̱ ken ne'a-wu̱ ko-Yahuda ko-yan-dor. Tato u̱n wu̱ komo ko-Girik-wu̱. ");
INSERT INTO uth_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Yan-dor ye̱ ro u̱n bo̱-to̱ o-Risiya o-Iko̱niya ne̱ à, komo ye̱ u̱n bo̱ngo̱n-u̱r Timoti. ");
INSERT INTO uth_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Burus co̱nu̱ru̱ Timoti shii wu̱. Remen kaane̱, wu̱ deku̱ wu̱, wu̱ ko̱ru̱ wu̱ u̱r-ko̱. Wu̱ u̱n no̱m kaane̱ remen ka Yahuda-ne̱ ye̱ ro u̱n to̱ ka be-to̱ à, kap ye̱ nepste̱ tato u̱n wu̱ ko-Girik-wu̱. ");
INSERT INTO uth_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Da-o̱ Burus ne̱ u̱n Siras ro u̱r-hew à, ye̱ ro m-do̱ro̱g bo̱-u̱t-bo̱, ye̱ se̱ngu̱ m-ru̱re̱ u̱n hun-ne̱ ko̱'o̱t-o̱ yan-To̱m Ye̱so u̱n se̱k-ye̱ ne̱ be-de u̱n hun-ne̱ yan-dor co̱ne̱ o-Urusharima à, ye̱ ru̱ru̱ yan-dor-ye̱ do̱re̱ ka ko̱'o̱t-o̱. ");
INSERT INTO uth_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","U̱n kaane̱ hun-ne̱ yan-dor doote̱ m-'wo̱ns be-de m-she̱r o-nip, ye̱ ro̱ m-do̱ u̱t-mo̱o̱r ko̱ de ke ho̱-de. ");
INSERT INTO uth_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Ye̱ pa'u̱ru̱ dak-to̱ o-Pirijiya o-Garatiya ne̱, remen Ku̱kt-o̱ Shir we̱ne̱g ye̱ no̱m u̱n ma-u̱t Wan-Ko̱yan dak-o̱ o-Asiya. ");
INSERT INTO uth_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Bo̱ ye̱ woote̱ dak-o̱ o-Misiya à, ye̱ no̱mu̱ m-se̱nge̱ ye̱ heet dak-o̱ o-Bitaniya, amba Ku̱kt-o Ye̱so o̱ 'ya ye̱ á. ");
INSERT INTO uth_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Ye̱ do̱ru̱ru̱ riib-se u̱n dak-o̱ o-Misiya ye̱ yirgu̱ru̱ ha-mo̱ o-To̱ruwas. ");
INSERT INTO uth_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","M-Te̱t, Burus hyanu̱ u̱t-hyangan. Be-de u̱n ka hyangan-to̱ komo wu̱ hyanu̱ru̱ wu̱ ken ne̱t-wu̱ u̱n dak-o̱ o-Makidoniya wu̱ ro eso, wu̱ ro wu̱ u̱s-ko̱n wu̱ ro̱ m-ze̱e̱, “Haan o-Makidoniya, o gu te̱.” ");
INSERT INTO uth_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Bo̱ Burus hyente̱ ka hyangan-to̱ à, da-o gaan, te̱ no̱mu̱ m-se̱nge̱ te̱ pest ha-mo̱ o-Makidoniya. Te̱ u̱n no̱m kaane̱, remen te̱ nepste̱ u̱nze Shir agu̱ te̱, remen te̱ ko̱'o̱tté̱ Ma-to̱ m-Re̱re̱m. ");
INSERT INTO uth_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Te̱ argu̱ m-ine̱ n-me̱ u̱n hat-o̱ m-ho̱ o-To̱ruwas te̱ inu̱ru̱ se̱ o-Samutarkiya. Gas o-ish, komo se̱ o-Niyapo̱ris. ");
INSERT INTO uth_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Bo̱ u̱n kane̱ komo te̱ argu̱ m-arag ha-mo̱ o-Piripi o̱ ro̱ u̱n ku̱s-o̱ u̱n gwo̱mo-to̱ o-Roma à, komo o̱ ro̱ caari-o̱ o-bo̱ u̱n raag-o̱ o-Makidoniya. Te̱ no̱mu̱ kane̱ u̱t-ho̱. ");
INSERT INTO uth_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Ho̱-de u̱r-Wu̱we̱, te̱ ruuru̱ u̱n ish-o o-bo̱, te̱ neku̱ru̱ n-riib o-ro̱o̱g be-de te̱ ro hwo̱o̱ge̱ te̱ zee be-de u̱n no̱m u̱s-ko̱n ro̱ ko̱n remen Yahuda-ne̱ à. Te̱ she'etu̱ru̱ te̱ nomu̱ru̱ ne'a-ne̱ u̱t-ma ye̱ mo̱rge̱ u̱n ka be-de à. ");
INSERT INTO uth_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Wu̱ ken ne'a-wu̱ ro kon jin-de u̱n wu̱ Ridiya, “Wan-se̱ps u̱n Shir,” wu̱ ro te̱ m-ho̱ge̱. Wu̱ ko-yan-bo̱-o̱ o-Tiyatira wu̱, wu̱ ro m-baab u̱n gund-u̱t jaas-to̱ to̱ u̱n hwo̱r. Wan-Ko̱yan tikshte̱ hur-de u̱n wu̱, har wu̱ e̱ste̱ u̱r-hi wu̱ raks rii-yo Burus rwo̱re̱ à. ");
INSERT INTO uth_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Bo̱ a yo'ostu̱ wu̱ m-ho̱ u̱n hun-ne̱ ye̱ u̱n hur-o̱ u̱n wu̱ ne̱ à, wu̱ ko̱nu̱ru̱ te̱. Wu̱ ze̱e̱ru̱, “U̱rege̱ no̱ de̱k me̱ wan-she̱r o-nip be-u̱r Wan-Ko̱yan to̱, haan no̱ u̱n hur-o re, no̱ she'et.” Wu̱ kokorsu̱ru̱ te̱, te̱ argu̱ m-de̱k u̱n ma-to̱ u̱n wu̱. ");
INSERT INTO uth_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","De ken ho̱-de, te̱ m-neke̱ be-de u̱n no̱m u̱s-ko̱n, te̱ go'onu̱ru̱ u̱n wu̱ ken wan-ne'a-wu̱ ne̱ ko-gu̱w, ko-ya-o-gwo̱t-wu̱ ro u̱n wa-u̱t-ko̱t ne̱. Yan ka ko-gu̱w-wu̱ komo ye̱ ro u̱n kum u̱n hwo̱r de̱e̱n be-de u̱n ka gwo̱t-o̱ wu̱ ro̱tte̱ à. ");
INSERT INTO uth_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Wu̱ se̱ngu̱ te̱ m-do̱re̱, te̱ Burus ne̱, wu̱ ro o-zaaz. Wu̱ ma'asu̱ru̱ m-ze̱e̱, “Ka hun-ne̱ ye̱ gu̱w-ne̱ Shir ye̱ wu̱ ro̱ Wa-u̱r-Be̱e̱b Kap à, ye̱ ro̱ no̱ u̱n kute̱ u̱n co̱w-yo u̱n gwu̱!” ");
INSERT INTO uth_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Wu̱ se̱ngu̱ru̱ m-no̱m kaane̱ u̱t-ho̱ de̱e̱n. Me̱n-u̱t naasu̱ru̱ Burus de̱e̱n, wu̱ waktu̱ru̱. Wu̱ ze̱e̱ru̱ wa-u̱t-ko̱t, “U̱m ze̱e̱g wo̱ n-me̱ u̱n jin-u̱r Ye̱so Kiristi, wonge̱ u̱n wu̱ ne̱.” U̱n gyept-o̱ u̱n yish, wa-u̱t-ko̱t wonge̱ u̱n wu̱ ne̱. ");
INSERT INTO uth_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Bo̱ yan-wan-ne'a hyente̱ co̱w-yo ye̱ rotte̱ u̱n kum u̱n hwo̱r kessu̱te̱ ye̱ à, ye̱ shipu̱ru̱ Burus ne̱ u̱n Siras. Ye̱ naku̱ ye̱ har n-me̱ u̱n be-de u̱t-baab u̱n co-o̱ u̱n yan-piish u̱t-ma. ");
INSERT INTO uth_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Bo̱ ye̱ woote̱ ye̱ u̱n co-o̱ u̱n yan-piish u̱t-ma à, ye̱ ze̱e̱ru̱, “Ka Yahuda-ne̱ ye̱ suute̱ bo̱-o na. ");
INSERT INTO uth_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Ye̱ m-yoos u̱n jind-se depe̱ a go̱ks ko̱ a do̱re̱ á, remen te̱ Roma-ne̱ ye̱.” ");
INSERT INTO uth_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Hun-ne̱ kargu̱ru̱ be-de u̱n ye̱ da-o gaan. Yan-piish u̱t-ma yoogu̱ru̱ matuku-u̱t Burus ne̱ komo ye̱ rwo̱'u̱ru̱ a bu ye̱ u̱s-rak. ");
INSERT INTO uth_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Bo̱ a bu'ute̱ ye̱ de̱e̱n à, a ka'u̱ru̱ ye̱ be-de u̱n kur-o̱ m-ke'et. A ze̱e̱ru̱ wa-u̱r-'er de u̱n ka kur-o̱ wu̱ 'er ye̱ m-so̱k ne̱. ");
INSERT INTO uth_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Wu̱ komo bo̱ wu̱ go̱kste̱ to̱ ka ma-to̱ à, wu̱ rwo̱'u̱ ye̱ re̱e̱no̱ n-me̱ n-me̱ de o-kur, wu̱ kamtu̱ru̱ na-se u̱n ye̱ u̱n caari-to̱ u̱t-ce. ");
INSERT INTO uth_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Da-o pu̱rge̱, Burus ne̱ u̱n Siras ro u̱s-ko̱n ye̱ ro u̱s-se̱p to̱ u̱n bo̱ngo̱n-de Shir. Ye̱ ken yan-m-ke'et ye̱ komo ye̱ ro ye̱ m-ho̱ge̱. ");
INSERT INTO uth_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Da-o gaan, dak-o nuktu̱ru̱ de̱e̱n, har hwu̱k-o̱ u̱n ka kuke̱-o̱ nukte̱. Da-o gaan ish-se u̱n o̱ kap argu̱ m-tikshe̱, bo̱ u̱n ye̱ a ka'e̱ à, ka rii-se a ke'etu̱ ye̱ à ussu̱ru̱. ");
INSERT INTO uth_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Bo̱ wan-'er-de u̱n ka kur-o̱ zu̱tu̱te̱ be-de m-rew à, wu̱ hyanu̱ru̱ ish-se o-kuke̱ tikshishe̱, wu̱ mu'usu̱nu̱ magay-o̱ u̱n wu̱, wu̱ ro u̱n zo̱nge̱-to̱ wu̱ hoot hi u̱n de u̱n wu̱, u̱n remen wu̱ hyanag sa o zee ye̱ a ka'e̱ à ye̱ u̱n so̱m. ");
INSERT INTO uth_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Amba Burus 'yonsu̱ co̱r m-'wo̱ns ne̱. Wu̱ ze̱e̱ru̱, “Taase o ho̱gu̱sse̱ hi u̱n du m-hoog á. Ai, myet-m te̱ te̱ ro̱ ko̱n!” ");
INSERT INTO uth_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Wan-'er-de u̱n ye̱ a ka'e̱ à ze̱e̱ru̱ u̱nze a hante̱ u̱t-pitirra. Wu̱ co̱wu̱ru̱ n-me̱, wu̱ he̱e̱ru̱ u̱n co Burus ne̱ u̱n Siras. Wu̱r-o̱ u̱n wu̱ ro̱ u̱s-zap se o-gye̱r. ");
INSERT INTO uth_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Ka da-o̱, wu̱ rwu̱ntu̱ru̱ ye̱ n-do̱. Wu̱ ze̱e̱ru̱, “Se̱k-ye̱, ¿re u̱m he m-no̱m u̱m kumut gwu̱ ne̱?” ");
INSERT INTO uth_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Ye̱ komo ye̱ ze̱e̱ru̱, “She̱r u̱n Wan-Ko̱yan Ye̱so, wo̱ u̱n yakar ru ne̱, no̱a kum gwu̱.” ");
INSERT INTO uth_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Ka da-de, ye̱ ru̱ru̱ wu̱ ma-u̱t Wan-Ko̱yan, wu̱, u̱n hun-ne̱ ye̱ ro u̱n hur-o̱ u̱n wu̱ ne̱ kap à. ");
INSERT INTO uth_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","N-me̱ u̱n ka te̱t-mo̱, wu̱ deku̱ ye̱, wu̱ sosu̱ru̱ ye̱ nat-to̱ u̱n ye̱. Ba m-jime̱, a yo'osu̱ru̱ wu̱ m-ho̱ u̱n yan-hur-o̱ u̱n wu̱ ne̱ kap. ");
INSERT INTO uth_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Ka da-de, wu̱ tu̱wtu̱ru̱ ye̱ u̱n hur-o̱ u̱n wu̱, wu̱ hantu̱ ye̱ rii-yo m-re̱. Wu̱ u̱n yan-hur-o̱ u̱n wu̱ ne̱ kap zak-o ho̱o̱ru̱ ye̱ remen kap mo̱ u̱n ye̱ ye̱ she̱re̱g be-de Shir. ");
INSERT INTO uth_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Bo̱ ish geste̱ à, yan-piish u̱t-ma to̱mnu̱ru̱ yan-to̱m-ye̱ u̱n ye̱. Ye̱ ru̱ru̱ru̱ ko-wan-u̱r-'er, “A ho'os ka hun-ne̱ ye̱.” ");
INSERT INTO uth_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Wan-'er-de u̱n ye̱ a ka'e̱ à wo̱ntu̱ Burus ka to̱m-o̱, wu̱ zee, “Yan-piish u̱t-ma to̱mo̱nte̱ a ho'os no̱. Remen kaane̱ m-mo̱ka, rwu̱u̱n no̱, no̱ arag ke̱e̱z ke̱e̱z.” ");
INSERT INTO uth_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Amba Burus ze̱e̱ru̱ ye̱, “Ai, be-de u̱n hun-ne̱ ye̱ nomo te̱ u̱s-so̱ro̱g, ba a m-piishi te̱ u̱t-ma, ko̱ de̱ nomte̱ te̱ Roma-ne̱ ye̱ à. Ye̱ jorbu̱ te̱ komo n-me̱ u̱n kur-o̱ m-ke'et, m-mo̱ka komo ¿ye̱a ruut te̱ wukusse̱? Ay! Se̱ de̱ ye̱ haan u̱n hi u̱n de u̱n ye̱, ye̱ ruut te̱.” ");
INSERT INTO uth_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Yan-to̱o̱b-u̱t rim-to̱ neku̱ru̱. Ye̱ ru̱ru̱ yan-piish u̱t-ma to̱ ka ma-to̱. Yan-piish u̱t-ma komo ho̱gu̱ru̱ o-gye̱r bo̱ ye̱ ho̱ge̱ u̱nze Burus ne̱ u̱n Siras Roma-ne̱ ye̱ à. ");
INSERT INTO uth_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Ka da-de, ye̱ haanu̱ru̱ ye̱ ko̱nu̱ru̱ Burus ne̱ u̱n Siras ye̱ soks ba'as-de u̱n ye̱. Bo̱ u̱n kaane̱, ye̱ ruutu̱ ye̱ ye̱ ko̱nu̱ru̱ ye̱ yage̱ ka bo̱-o̱. ");
INSERT INTO uth_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Bo̱ Burus ne̱ u̱n Siras ruusu̱nte̱ u̱n kur-o̱ m-ke'et à, ye̱ argu̱ m-neke̱ hur-o Ridiya. Bo̱ ye̱ hyenu̱ste̱ yan-dor à, komo ye̱ dooru̱ hur-de u̱n ye̱ jaab-o̱ u̱t-me̱n, ye̱ argu̱ru̱. ");
INSERT INTO uth_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Burus ne̱ u̱n Siras ye̱ do̱ru̱ru̱ so̱ u̱n bo̱-to̱ o-Ampibo̱ris o-Apo̱ro̱niya ne̱. Ye̱ wo̱o̱ru̱ bo̱-o̱ o-Tasaronika, be-de ro u̱n kuke̱-o̱ u̱n yoos u̱n Ma-to̱ Shir ne̱ à o̱ u̱n Yahuda-ne̱. ");
INSERT INTO uth_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Bo̱ wu̱ we̱te̱ à, Burus co̱wu̱ kuke̱-o̱ u̱n yoos u̱n Ma-to̱ Shir. Ho̱-to̱ u̱r-Wu̱we̱ u̱t-tet, wu̱ ro u̱t-ma n-me̱ u̱n ge̱n-mo̱ u̱n Ma-to̱ Shir. ");
INSERT INTO uth_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Wu̱ ro ye̱ m-kute̱ cas, wu̱ ro ye̱ komo u̱n ru̱re̱ o-nip be-de Ma-to̱ Shir ze̱e̱ Kiristi a su̱ u̱r-ko̱o̱b, komo wu̱a ine̱ u̱t-marimar. Komo Burus ze̱e̱ru̱, “Ka Ye̱so-wu̱ u̱m ru̱ru̱ no̱ à, wu̱ ro̱ ka Kiristi-wu̱.” ");
INSERT INTO uth_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Ye̱ ken hun-ne̱ ye̱ u̱n Yahuda-ne̱ komo u̱n Girik-ne̱ ne̱ “Yan-se̱ps u̱n Shir” mo̱sse̱ u̱n caari-ye̱ u̱n ne'a-ne̱ ne̱ u̱t-mo̱o̱r ne̱ de̱e̱n, kap ye̱ deku̱ ma-u̱t Burus ne̱ u̱n Siras, komo ye̱ mo̱ssu̱ru̱ u̱t-hi u̱n ye̱ ne̱. ");
INSERT INTO uth_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Amba Yahuda-ne̱ no̱mu̱ u̱r-shoob, ye̱ karagsu̱ru̱ ye̱ ken hun-ne̱ ye̱ o-saa ye̱ be-de a u̱t-baab à m-o̱ ne̱. Bo̱ ye̱ kargu̱te̱ kap o̱ u̱n ye̱ à, ye̱ 'yonsu̱ru̱ hur-de u̱n hun-ne̱ ye̱ o-bo̱. Ye̱ ruuru̱ u̱s-rek n-me̱ u̱n hur-o Jaso̱n. Ye̱ ro u̱n hoob-o Burus ne̱ u̱n Siras remen ye̱ hantu̱tú̱ ye̱ be-de u̱n hun-ne̱. ");
INSERT INTO uth_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Bo̱ ye̱ hyente̱ ye̱ 'wo̱s ye̱ á, ye̱ naknu̱ru̱ Jaso̱n u̱n ye̱ ken yan-dor-ye̱ ne̱, ye̱ wootu̱ru̱ ye̱ har u̱n he̱r-o̱ u̱n yan-piish u̱t-ma. Ye̱ o-zaaz, ye̱ m-ze̱e̱, “Ka hun-ne̱ ye̱, ye̱ ro̱ m-'yons u̱n hur-de u̱n hun-ne̱ ko̱ kene̱ ho̱no o-dak à, ye̱ ka haane̱ har kane̱. ");
INSERT INTO uth_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Har ma Jaso̱n 'ye ye̱ be-de u̱r-she'et. Myet-mo̱ u̱n ye̱ ne̱ komo ye̱ ro̱ m-jetem u̱n karamsa-o ko-Gwo̱mo Sisar. Ye̱ ro̱ m-ze̱e̱ wu̱ ken ko-Gwo̱mo-wu̱ ro̱ ko̱n, u̱nze jin-de u̱n wu̱ Ye̱so.” ");
INSERT INTO uth_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Bo̱ hun-ne̱ ya-o-bo̱ u̱n yan-piish u̱t-ma ne̱ ho̱gu̱te̱ to̱ ka à, hur-de u̱n ye̱ inu̱ru̱. ");
INSERT INTO uth_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Ye̱ ho'os Jaso̱n u̱n ye̱ ka ne̱ á, se̱ da-o̱ ye̱ go̱kse̱ hwo̱r-ye̱ o-be̱ri u̱n kom-to̱ u̱n ye̱ à. ");
INSERT INTO uth_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Bo̱ te̱t-m rewte̱ à, yan-dor shiiru̱ Burus ne̱ u̱n Siras ye̱ neke̱ bo̱-o̱ o-Biriya. Bo̱ ye̱ woote̱ re̱e̱no̱ à, ye̱ co̱wu̱ru̱ kuke̱-o̱ u̱n Yahuda-ne̱ o̱ u̱n yoos u̱n Ma-to̱ Shir. ");
INSERT INTO uth_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","To̱ ye̱ ka Yahuda-ne̱ ye̱, ye̱ aragte̱ ye̱ o-Tasaronika u̱s-we̱e̱r, u̱n remen ye̱ go̱kste̱ u̱t-ma kom-u̱t yoor-u̱t-yoor. Ye̱ ro̱ u̱n ceker-se u̱n ge̱n-mo̱ u̱n Ma-to̱ Shir ko̱ de ke ho̱-de, ye̱ hyenet ko̱ rii-yo Burus rwo̱re̱, ko̱ nip-o̱ à. ");
INSERT INTO uth_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Remen kaane̱ hun-ne̱ de̱e̱n be-de u̱n Yahuda-ne̱ bo̱pu̱ru̱ o-nip, har u̱n ye̱ ken ne'a-ne̱ ye̱ ne̱ ye̱ u̱n Girik-ne̱ go̱s-ye̱, go̱s-ye̱ komo u̱n campo̱-ne̱ ne̱ ye̱ u̱n Girik-ne̱ de̱e̱n. ");
INSERT INTO uth_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Amba bo̱ Yahuda-ne̱ ye̱ ro o-Tasaronika ho̱gu̱te̱ u̱nze Burus ro u̱n rwo̱r u̱n Ma-to̱ o-Shir o-Biriya à, ye̱ haaru̱ ma ye̱ swo̱wu̱ hun-ne̱ u̱n ye̱ re̱e̱no̱, ye̱ ro u̱n 'yons u̱n hur-de u̱n ye̱. ");
INSERT INTO uth_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Da-o gaan, komo yan-dor rwo̱'u̱ru̱ Burus wu̱ neke̱ n-riib m-sa. Amba Siras ne̱ u̱n Timoti ye̱ e̱su̱ru̱ kane̱ to kon. ");
INSERT INTO uth_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Ká yan-dor-ye̱ shie̱ Burus à, ye̱ wootu̱ wu̱ har o-Atina. Bo̱ ye̱ inite̱ m-mu̱u̱n à, Burus to̱mnu̱ ye̱ be-u̱r Siras ne̱ u̱n Timoti u̱nze ye̱ haan ye̱ hyen wu̱ ho̱r-m-ho̱r, ye̱ argu̱ m-neke̱. ");
INSERT INTO uth_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Bo̱ Burus rotte̱ u̱n 'er-u̱r Siras ne̱ u̱n Timoti u̱n bo̱-o̱ o-Atina à, me̱n-to̱ u̱n wu̱ tu̱ku̱ru̱ de̱e̱n bo̱ wu̱ hyane̱ bo̱-o shiig u̱n pyo-se m-gir à. ");
INSERT INTO uth_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Remen kaane̱ wu̱ ro u̱t-ma n-me̱ u̱n kuke̱-o̱ u̱n yoos u̱n Ma-to̱ Shir u̱n Yahuda-ne̱, u̱n ye̱ ken ye̱ ne̱ “Yan-se̱ps u̱n Shir.” Ko̱ de ke ho̱-de wu̱ ro u̱t-ma u̱n ye̱ wu̱ ro m-kum ne̱ be-de u̱t-baab à. ");
INSERT INTO uth_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Kaane̱ komo ye̱ ken Abikuri-ne̱ ye̱ u̱n Sitokiya-ne̱ ya-u̱s-nap no̱mo̱g u̱t-ma u̱n wu̱ ne̱. Ye̱ ken ye̱ ze̱e̱ru̱, “¿Yan yo ne̱ ka wa-o-zaaz-wu̱ co̱ne̱ m-ze̱e̱?” Ye̱ ken ye̱ ze̱e̱ru̱, “Yo ro̱ sa o zee u̱nze ka ne̱t-wu̱ ro̱ u̱n ko̱'o̱t shir-ye̱ u̱n u̱n be-u̱t ho̱r-to̱.” Ye̱ u̱n rwo̱r kaane̱ remen Burus ro u̱n rwo̱r u̱n Ma-u̱t Ye̱so to̱ m-Re̱re̱m, komo m-ine̱ ne̱ be-de u̱t-marimar. ");
INSERT INTO uth_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Remen kaane̱, ye̱ heetu̱ru̱ wu̱ u̱n dor-de o-Arepagus. Bu̱u̱g-de yan-co u̱n ka bo̱-o̱ ze̱e̱ru̱ wu̱, “¿Ko̱ wo̱a ru̱ru̱ te̱ ka yoos-u̱r pu̱-de de o wo̱tte̱? ");
INSERT INTO uth_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Remen te̱ we̱t m-ho̱ge̱ u̱n go̱n to̱ ka ma-to̱ á. Te̱ co̱no̱g te̱ nep bo̱ to̱ ro̱ à.” ");
INSERT INTO uth_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","(Myet Atina-ne̱ u̱n hamat-ne̱ ne̱ ye̱ ro̱ u̱r-she'et o-Atina à, ye̱ jiishte̱ m-co̱n ye̱ ho̱ge̱ rii pu̱-yo komo ye̱ cep ma-to̱ u̱n yo, arge̱ ko̱yan.) ");
INSERT INTO uth_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Burus inu̱ eso u̱n he̱r-o̱ u̱n mo̱ro̱g-de u̱n ya-u̱s-nap, wu̱ ze̱e̱ru̱, “No̱ hun-ne̱ ye̱ o-Atina, u̱m nak u̱nze no̱ yan-co̱n-to̱ u̱n dor-o̱ shir-ye̱ m-so̱k ne̱ u̱n ko̱ yo ke riib-yo. ");
INSERT INTO uth_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Remen da-o̱ u̱m m-pa'e̱ n-me̱ o-bo̱ à, u̱m gwo̱t rem-se no̱ u̱n nome̱ m-gu̱w à, har ma u̱m hyanag u̱n o̱ ken hana-o̱ o̱ u̱r-seke̱ m-ge̱n ne̱ n-to̱n u̱n o̱ a ge̱ne̱g u̱nze, ‘Remen Shir ye̱ a nape̱ á.’ To̱, ka wu̱ no̱ m-kwu̱kte̱ ba no̱ u̱n nap wu̱ à, ma-to̱ u̱n wu̱ me̱ no̱ m-rwu̱u̱nte̱ cas. ");
INSERT INTO uth_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","“Shir ye̱ no̱me̱ ho̱no o-dak u̱n kap o̱ u̱n rii-yo ro̱ ne̱ n-me̱ u̱n o̱ à, wu̱ wu̱ ro̱ Wan-Ko̱yan wu̱ o-To̱n o-dak ne̱. Wu̱ ro̱ m-she'et u̱n pyo-o̱ ne̱t ma'e̱ á. ");
INSERT INTO uth_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Kaane̱ komo wu̱ ro̱ u̱n hoob-o̱ u̱n gwu̱ be-de u̱n ne̱t á. Wu̱ ro̱ u̱n hoob-o̱ u̱n yo ken rii-yo á, remen wu̱ ro̱ u̱n 'ya u̱n kap o̱ u̱n hun-ne̱ ho̱o̱g, m-shik ne̱ u̱n kap o̱ u̱n rii-yo ye̱ ro̱ ne̱ o-hoob à. ");
INSERT INTO uth_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Wu̱ wu̱ komo nome̱ kap o̱ u̱t-dak be-de u̱n ne̱t wan-gaan, remen ye̱ she'etté̱ u̱n kap o̱ u̱n hek-o̱ u̱n ho̱no o-dak. Cin u̱n n-ga ne̱ wu̱ e̱ssu̱su̱te̱ o-da, u̱n da-o̱ ye̱ he m-no̱m m-ho̱o̱g m-mar ne̱ à, u̱n bo̱ u̱n be-to̱ hun-ne̱ ye̱ u̱n ko̱ o̱ ke dak-o̱ hette̱ m-she'et ne̱ à. ");
INSERT INTO uth_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Shir u̱n no̱m kaane̱ remen ye̱ hobt wu̱, ko̱ a nap á. O-da ye̱ kum wu̱, ko̱ de̱ nomte̱ wu̱ no̱m u̱r-hew u̱n ko̱ wu̱ ke ne̱ be u̱n na á. ");
INSERT INTO uth_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Ai, ‘Be-de u̱n wu̱ a ro̱ no̱ u̱n no̱m m-ho̱o̱g, atte̱ m-nukte̱, atte̱ komo u̱n m-neke̱ u̱n no̱m u̱n rii-yo a m-no̱m ne̱,’ bo̱ ye̱ ken yan-se̱p-u̱t no̱ ye̱ rwo̱re̱ à u̱nze, ‘O-nip, na ma yakar-ye̱ u̱n wu̱ ye̱.’ ");
INSERT INTO uth_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","“To̱, bo̱ a ro̱ no̱ baag-o̱ Shir o̱ à, ai, u̱depe̱ a no̱m u̱s-barag a zee Shir ro̱ m-sha ne̱ u̱ntu̱n mo̱ o-zinariya, ko̱ mo̱ o-azorpa, ko̱ mo̱ u̱r-ta'ar á, de ne̱t zwo̱'e̱ u̱n we̱e̱r-se u̱n hi u̱n de u̱n wu̱ á. ");
INSERT INTO uth_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","N-ga Shir ro m-was u̱n ba'as-to̱ u̱n hun-ne̱ ne̱ á, remen ko̱o̱b-de u̱n nap-o̱ u̱n ye̱. Amba m-mo̱ka, wu̱ ze̱e̱g kap o̱ u̱n hun-ne̱ ye̱ u̱n ko̱ kene̱ ye̱ yage̱ ba'as-to̱ u̱n ye̱, ye̱ waktu̱ne̱ be-de Shir. ");
INSERT INTO uth_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Remen wu̱ e̱ssu̱ssu̱te̱ u̱r-ho̱ de wu̱ he m-haan wu̱ piishité̱ hun-ne̱ ho̱no o-dak u̱t-ma to̱ o-nip be-de u̱n wu̱ ken wu̱, wu̱ wu̱ daage̱ à. Shir rwu̱ntu̱te̱ nip-o̱ u̱n no̱m-mo̱ u̱n to̱ ka cas be-de u̱n 'yons u̱n ka ne̱t-wu̱ u̱t-marimar.” ");
INSERT INTO uth_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Bo̱ ye̱ ho̱gu̱te̱ ma-to̱ m-ine̱ u̱t-marimar à, ye̱ ken ye̱ argu̱ wu̱ nome̱ u̱r-ar. Amba ye̱ ken ye̱ ze̱e̱ru̱, “Te̱ co̱no̱g te̱ do m-ho̱ge̱ rii-yo o he m-rwo̱r mo̱sse̱ u̱n ka ma-to̱ ne̱ à.” ");
INSERT INTO uth_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Kane̱ o̱ ka Burus wonge̱ u̱n ye̱ ne̱. ");
INSERT INTO uth_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Amba ye̱ ken ye̱ wargu̱ru̱ be-u̱r Burus ye̱ she̱ru̱ u̱n ma-to̱ u̱n wu̱, n-me̱ u̱n ye̱ har u̱n Diyonisiyus ne̱, wan-gaan be-de u̱n ka mo̱ro̱g-de u̱n ya-u̱s-nap de, u̱n wu̱ ken ne'a-wu̱ ne̱ jin-de u̱n wu̱ Damaris, u̱n ye̱ ken ye̱ ne̱ komo. ");
INSERT INTO uth_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Bo̱ u̱n to̱ ka, Burus yagu̱ bo̱-o̱ o-Atina wu̱ neku̱ bo̱-o̱ o-Korinti. ");
INSERT INTO uth_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Re̱e̱no̱ wu̱ 'wo̱sse̱ wu̱ ken ko-Yahuda-wu̱ jin-de u̱n wu̱ Akira, ko-yan-bo̱-o̱ o-Pantus. Akira u̱n ne'a u̱n wu̱ ne̱ Biskira, ye̱ she'et m-haan ne̱ u̱n bo̱-o̱ o-Korinti á, ye̱ u̱n rwu̱u̱n dak-o̱ o-Itariya. Ye̱ u̱n yage̱ o-Itariya remen ko-Gwo̱mo Sisar Karadiyos no̱ng o-karamsa, wu̱ zee kap o̱ u̱n Yahuda-ne̱ ye̱ ru n-me̱ bo̱-o̱ o-Roma. Burus argu̱ m-ha be-de u̱n ye̱ o-Korinti. ");
INSERT INTO uth_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Hongsu̱ru̱ se̱nge̱-mo̱ u̱n ye̱ ragaan mo̱ u̱n mo̱ ma Burus ne̱, ye̱ ro̱ u̱n jor-o̱ u̱t-de̱pi, wu̱ she'etu̱ be-u̱r gaan u̱n ye̱ ne̱. Ye̱ se̱ngu̱ru̱ se̱nge̱-mo̱ u̱n ye̱ be-u̱r gaan. ");
INSERT INTO uth_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Ko̱ de ke Ho̱-de u̱r-Wu̱we̱ de komo, Burus ma'asu̱ru̱ u̱t-ma u̱n kuke̱-o̱ u̱n yoos u̱n Ma-to̱ Shir wu̱ ro m-se̱nge̱ wu̱ nakanté̱ Yahuda-ne̱ u̱n ye̱ ro̱ Yahuda-ne̱ á. ");
INSERT INTO uth_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Da-o̱ Siras ne̱ u̱n Timoti wo̱o̱ne̱ rwu̱u̱n-mo̱ o-Makidoniya à, Burus ya'u̱ kap o̱ u̱n da-o̱ u̱n wu̱ u̱n ko̱'o̱t u̱n Ma-to̱ Shir. Wu̱ ro Yahuda-ne̱ m-ru̱re̱ o-nip u̱nze, Ye̱so wu̱ ro̱ Kiristi. ");
INSERT INTO uth_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Amba ye̱ e̱su̱ru̱ wu̱ u̱n su̱ne̱-mo̱ u̱t-ma ye̱ ma'asu̱ wu̱ u̱t-re̱e̱b. Remen kaane̱, wu̱ kuktu̱ru̱ matuku-to̱ u̱n wu̱, wu̱ ze̱e̱ru̱ ye̱, “Ra-o no̱ ro̱ u̱n hi-u̱t no̱! Me̱ me̱tt u̱r-ba'as á. Shi-mo̱ u̱n caane̱ be-de u̱n ye̱ ro̱ Yahuda-ne̱ á u̱m he'e̱.” ");
INSERT INTO uth_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Wu̱ argu̱ m-ine̱ u̱n ka be-de, wu̱ neku̱ru̱ u̱n hur-o̱ u̱n wu̱ ken ne̱t-wu̱ jin-de u̱n wu̱ Titus Justus, wu̱ ro “Wan-se̱ps u̱n Shir.” Hur-o̱ u̱n wu̱ komo o̱ ro m-yow yow ne̱ de̱e̱n u̱n kuke̱-o̱ u̱n yoos u̱n Ma-to̱ Shir ne̱. ");
INSERT INTO uth_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Kiribus, wu̱ ro wan-co-o̱ u̱n ka mo̱ro̱g-de à, she̱ru̱ru̱ be-u̱r Wan-Ko̱yan, wu̱ u̱n hun-ne̱ ye̱ u̱n hur-o̱ u̱n wu̱ ne̱ kap. Ye̱ ken Korinti-ne̱ ye̱ komo de̱e̱n ye̱ ho̱ge̱ ma-u̱t Burus à, ye̱ she̱ru̱ru̱ u̱n to̱, a yo'osu̱ ye̱ m-ho̱. ");
INSERT INTO uth_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","De ken ho̱-de m-te̱t, Wan-Ko̱yan kutu̱ Burus u̱t-hyangan. Wu̱ ze̱e̱ru̱ wu̱, “Wo̱ ho̱ge̱ o-gye̱r á, se̱nge̱ m-ru̱re̱ u̱n hun-ne̱ ma-u̱t re. Wo̱ she'et temb á, ");
INSERT INTO uth_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","remen me̱ be-u̱r gaan u̱n wo̱ ne̱. Yatt-wu̱ he wo̱ m-ru̱'e̱ u̱t-kom wu̱ nomotu̱ wo̱ yo ken rii-yo á, remen me̱ u̱n hun-ne̱ ne̱ de̱e̱n u̱n ka bo̱-o̱.” ");
INSERT INTO uth_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Burus she'etu̱ru̱ u̱n ka be-de har hak-o gaan u̱n re̱ng-u̱s cind. Wu̱ ro ye̱ m-yoose̱ u̱n Ma-to̱ Shir. ");
INSERT INTO uth_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Amba da-o̱ Gariyo ro̱ ko-Gwamna u̱n dak-o̱ o-Akaya à, Yahuda-ne̱ gamu̱ u̱t-hi ye̱ katu̱ Burus, ye̱ heetu̱ wu̱ be-de yan-piish u̱t-ma. ");
INSERT INTO uth_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Ye̱ ze̱e̱ru̱, “Wu̱ ka ne̱t-wu̱ wu̱ ro̱ m-se̱nge̱ wu̱ ru̱'u̱t hun-ne̱ gu̱w-mo̱ Shir u̱nte̱ u̱n co̱w-yo karamsa-o te̱ we̱ne̱ à.” ");
INSERT INTO uth_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Bo̱ Burus rotte̱ u̱n ma-to̱ u̱n ce̱pt u̱t-ma à, Gariyo ze̱e̱ru̱ Yahuda-ne̱, “A ro ze̱e̱ge̱ ma de ken ba'as-de wu̱ no̱me̱, ko̱ caari-de u̱r-ba'as, u̱m roa ho̱ge̱ ma-u̱t no̱. ");
INSERT INTO uth_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Amba no̱mo̱g u̱n ya u̱nze ma-to̱ su̱nu̱ no̱ u̱n ho̱n-de u̱n to̱ be-de u̱t-gom, u̱t-jin ne̱, komo u̱n karamsa-o no̱ ne̱, ai se̱ no̱ hongse̱ hi u̱n no̱. Me̱ kam, me̱ no̱m sakto̱-o̱ u̱m piishité̱ wu̱ u̱t-ma u̱n go̱n se ka rem-se á.” ");
INSERT INTO uth_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Wu̱ yanu̱ ye̱ n-me̱ u̱n kuke̱-o̱ m-piish u̱t-ma. ");
INSERT INTO uth_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Kap o̱ u̱n ye̱, ye̱ shipu̱ru̱ So̱stanus wu̱ ro co be-de u̱n kuke̱-o̱ u̱n yoos u̱n Ma-to̱ Shir à. Ye̱ nomu̱ wu̱ u̱s-so̱ro̱g u̱n he̱r-o̱ u̱n kuke̱-o m-piish u̱t-ma. Amba Gariyo ko̱ m-was wu̱ was á. ");
INSERT INTO uth_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Burus do̱o̱bu̱ru̱ u̱t-ho̱ hiin u̱n bo̱-o̱ o-Korinti. Ka da-o̱, wu̱ ze̱e̱ru̱ yan-dor se̱ de̱ ken ho̱-de. Biskira ne̱, u̱n Akira shiiru̱ Burus. Ye̱ co̱no̱g m-de̱k hat-o̱ m-ho̱ ha-mo̱ u̱n dak-o̱ o-Siriya. Remen kaane̱, ye̱ neku̱ru̱ bo̱-o̱ o-Kakiriya remen ye̱ co̱wu̱t o-hat. Amba rii-yo ye̱ inu̱te̱ o-Kakiriya, Burus oroste̱ hi-de u̱n wu̱ remen wu̱ swo̱ro̱g o-nu. Ye̱ daaru̱ hat-o̱ m-ho̱. ");
INSERT INTO uth_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Bo̱ ye̱ woote̱ o-Apisu à, re̱e̱no̱ Burus ho'ose̱ Biskira ne̱ u̱n Akira. Wu̱ ne̱, wu̱ co̱wu̱ru̱ u̱n kuke̱-o̱ u̱n yoos u̱n Ma-to̱ Shir, wu̱ nomot u̱t-ma u̱n Yahuda-ne̱. ");
INSERT INTO uth_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Ye̱ ko̱nu̱ru̱ wu̱, wu̱ do m-do̱o̱be̱ u̱t-ho̱ be-de u̱n ye̱, amba wu̱ de̱k ma-to̱ u̱n ye̱ á. ");
INSERT INTO uth_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Amba bo̱ wu̱ inu̱ ye̱ m-yage̱ à, wu̱ ze̱e̱ru̱, “Man muusune̱ be u̱n no̱ u̱rege̱ Shir ze̱e̱g.” Ka da-de, wu̱ inu̱ru̱ o-Apisu u̱n hat-o̱ m-ho̱. ");
INSERT INTO uth_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Bo̱ wu̱ kergu̱nte̱ bo̱-o̱ o-Kaseriya à, wu̱ neku̱ru̱ wu̱ gassu̱ru̱ hun-ne̱ yan-dor. Ka da-o̱ wu̱ argu̱ru̱ so̱ o-Antakiya. ");
INSERT INTO uth_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Bo̱ wu̱ she'ete̱ hiin o-Antakiya à, wu̱ inu̱ru̱ wu̱ pa'u̱ru̱ dak-o̱ o-Garatiya u̱n dak-o̱ o-Pirijiya ne̱. Wu̱ ro m-do̱re̱ bo̱-u̱t u̱t-bo̱, wu̱ ro m-do'e̱ u̱n kap o̱ u̱n yan-neke̱-m Ye̱so m-'wo̱ns. ");
INSERT INTO uth_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","A kane̱ wu̱ ken ko-Yahuda-wu̱ haanu̱ru̱ o-Apisu, jin-de u̱n wu̱ Apo̱ro̱s. Wu̱ ko-yan-bo̱-o̱ o-Arekzandiriya. Wu̱ wan-nap u̱t-ma, wu̱ nepste̱ ge̱n-mo̱ u̱n Ma-to̱ Shir m-so̱k ne̱. ");
INSERT INTO uth_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","A yoosu̱te̱ wu̱ n-me̱ u̱n co̱w-yo u̱n Wan-Ko̱yan. Wu̱ re̱e̱g u̱r-ho̱ be-de u̱n nome̱ u̱n ye̱ ken ye̱ u̱t-ma, komo wu̱ ro̱ m-yoos o-nip be-de u̱n ma-u̱t Ye̱so. Amba myet u̱n kaane̱ ne̱, wu̱ nap war war ma-u̱t Ye̱so á, remen myet wu̱ nepste̱ ma-to̱ yo'os u̱n hun-ne̱ m-ho̱, wu̱ nape̱ be-de u̱n nu-o Yohana Wa-m-Yo'os cot. ");
INSERT INTO uth_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Wu̱ taknu̱ m-ko̱'o̱t ba o-gye̱r, u̱n kuke̱-o̱ u̱n yoos u̱n Ma-to̱ Shir. Bo̱ Biskira ne̱ u̱n Akira ho̱gu̱te̱ wu̱ à, ye̱ naku̱ wu̱ n-riib. Ye̱ jamsu̱ wu̱ m-ru̱re̱ Co̱w-yo Shir m-so̱k ne̱, m-so̱k ne̱. ");
INSERT INTO uth_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Bo̱ Apo̱ro̱s cu̱nte̱ wu̱ pes ha-mo̱ u̱n dak-o̱ o-Akaya à, yan-dor Ye̱so dooru̱ wu̱ jaab-o̱ u̱t-me̱n. Ye̱ genu̱ru̱ yan-neke̱-m Ye̱so o-Akaya o-taku̱rda remen ye̱ go̱kstú̱ wu̱ kom-u̱t yoor-u̱t-yoor. Bo̱ wu̱ woote̱ re̱e̱no̱ à, wu̱ ro u̱n do ye̱ u̱n yan-m-she̱r jaab-o̱ u̱t-me̱n. Ye̱ ma'asu̱ru̱ m-nap yar-mo̱ Shir remen wu̱ ro kon káne̱. ");
INSERT INTO uth_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Apo̱ro̱s ro ye̱ m-ru̱re̱ o-nip n-me̱ u̱n Ma-to̱ Shir u̱nze Ye̱so ro̱ Kiristi. Wu̱ ru̱ru̱te̱ ye̱ u̱t-ma m-'wo̱ns ne̱ komo wu̱ kapste̱ Yahuda-ne̱ de̱e̱n u̱n yish-de u̱n hun-ne̱. ");
INSERT INTO uth_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Da-o̱ Apo̱ro̱s ro'e̱ o-Korinti à, Burus pa'u̱ru̱ n-me̱ u̱n ka dak-o̱. U̱r-ko̱m wu̱ wo̱o̱ru̱ bo̱-o̱ o-Apisu, be-de wu̱ 'wo̱sse̱ yan-neke̱-m Ye̱so de̱e̱n à. ");
INSERT INTO uth_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Wu̱ ze̱e̱ru̱ ye̱, “¿No̱ go̱ksu̱su̱te̱ Ku̱kt-o̱ Shir da-o̱ no̱ she̱re̱ u̱n ma-to̱ o-nip?” Ye̱ ze̱e̱ru̱ wu̱, “Ay, yatt-wu̱ ru̱ru̱te̱ ma-to̱ u̱n Ku̱kt-o̱ Shir á.” ");
INSERT INTO uth_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Wu̱ ze̱e̱ru̱, “¿Yan go̱n yo'os-de m-ho̱ de ne̱ a yo'osu̱ no̱?” Ye̱ shasu̱ru̱ “Go̱n de ma Yohana.” ");
INSERT INTO uth_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Burus ze̱e̱ru̱, “Yohana u̱n yo'os hun-ne̱ m-ho̱ remen ye̱ yagu̱té̱ no̱m u̱r-ba'as ye̱ waktu̱ne̱ be-de Shir. Yohana u̱n hi u̱n de u̱n wu̱ ru̱ru̱te̱ hun-ne̱ ye̱ she̱r u̱n Ye̱so, wu̱ Yohana zee ‘Wu̱ ro̱o̱n’ à.” ");
INSERT INTO uth_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Bo̱ m-ho̱ge̱ kaane̱, a argu̱ ye̱ m-yo'os m-ho̱ n-me̱ u̱n jin-u̱r Wan-Ko̱yan Ye̱so. ");
INSERT INTO uth_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Ka da-de, Burus sake̱ kom-to̱ u̱n wu̱ u̱n ye̱, Ku̱kt-o̱ Shir ciriru̱ u̱n ye̱. Ye̱ te̱pru̱ru̱ u̱n rem-u̱t ho̱r-to̱, ye̱ ro m-rwo̱r komo ma-to̱ Ku̱kt-o̱ Shir kutu ye̱, ye̱ ru̱r à. ");
INSERT INTO uth_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Kap mo̱ u̱n ye̱ u̱ntu̱n ne̱n o̱p u̱n yoor-ye̱ 12. ");
INSERT INTO uth_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Burus co̱wu̱ru̱ u̱n kuke̱-o̱ u̱n yoos u̱n Ma-to̱ Shir. Wu̱ ro m-ko̱'o̱te̱ u̱n Ma-to̱ Shir u̱n be̱e̱b-de u̱r-hur har re̱ng-u̱s tet. Komo wu̱ ro ye̱ m-nakan u̱s-we̱e̱r be-de u̱n ma-to̱ u̱n Gwo̱mo-to̱ Shir. ");
INSERT INTO uth_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Amba ye̱ ken ye̱ e̱ssu̱ cikt-de u̱r-hur, ye̱ yage̱ m-she̱r o-nip. Har ye̱ nomu̱ru̱ yan-do̱re̱ u̱n ka Co̱w-yo Shir yo hun-to̱ o-saa n-me̱ u̱n hun-ne̱. Remen kaane̱ Burus wongu̱ u̱n ye̱ ne̱. Wu̱ argu̱ru̱ u̱n yan-neke̱-m Ye̱so ne̱, wu̱ ro u̱r-yoos ko̱ de ke ho̱-de u̱n be-de u̱r-yoos de o-Tiranus. ");
INSERT INTO uth_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Kaane̱ wu̱ se̱nge̱ m-no̱m har hak-u̱s yoor, har kap o̱ u̱n ya-u̱r-she'et u̱n dak-o̱ o-Asiya ho̱gu̱ru̱ ma-u̱t Wan-Ko̱yan, Yahuda-ne̱ u̱n kap ye̱ ro̱ Yahuda-ne̱ ne̱ á. ");
INSERT INTO uth_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","U̱n kom-u̱t Burus komo Shir no̱mu̱ru̱ se ken rem-se u̱t-hyat se, u̱s-caari se a we̱te̱ m-hyan á. ");
INSERT INTO uth_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Har ma ko̱ magund-de u̱n soks u̱n su̱samb-mo̱ u̱n wu̱, ko̱ matuku-de u̱n wu̱r-o̱ u̱n wu̱ ci'e̱ wu̱r-o̱ u̱n ya-u̱s-go̱m ka go̱m-o̱ taaru̱, komo a wongsu̱ ye̱ u̱n ya-u̱t-ko̱t ne̱. ");
INSERT INTO uth_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Ye̱ ken Yahuda-ne̱ ye̱ ya-m-pa'ag u̱t-tu̱w bo̱-u̱t-bo̱ m-ruut u̱n ya-u̱t-ko̱t ye̱ no̱mu̱ m-se̱nge̱ u̱n jin-u̱r Wan-Ko̱yan Ye̱so be-de u̱n ye̱ ro u̱n ya-u̱t-ko̱t ne̱ à. Ye̱ ro m-ze̱e̱, “U̱m ruutu̱ no̱ u̱n jin-u̱r Ye̱so wu̱ Burus ro̱ m-ko̱'o̱t u̱n wu̱ à.” ");
INSERT INTO uth_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Yakar Siba ko-Gwo̱mo-wu̱ u̱n ko̱n-se Shir wu̱ u̱n Yahuda-ne̱ ne̱n ta'yoor, kap mo̱ u̱n ye̱, ye̱ ro m-no̱m kaane̱. ");
INSERT INTO uth_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","De ken ho̱-de, wa-u̱t-ko̱t shasu̱ ye̱, wu̱ zee, “Ye̱so de u̱m nepstu̱ wu̱, komo u̱m neps Burus, to̱, no̱ komo ¿wan ne̱ ye̱ ne̱?” ");
INSERT INTO uth_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Ka wan-ya-u̱t-ko̱t-wu̱ nossu̱ru̱, wu̱ mo̱'u̱ru̱ ye̱. Wu̱ re̱e̱ru̱ 'wo̱ns-mo̱ u̱n ye̱ kap, har ye̱ ruuru̱ ka hur-o̱ u̱s-rek u̱t-kor, kap o̱ u̱n wu̱r-to̱ u̱n ye̱ hoog-mo̱. ");
INSERT INTO uth_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Bo̱ kap o̱ u̱n ye̱ ro u̱r-she'et o-Apisu à, Yahuda-ne̱ u̱n ye̱ ro̱ Yahuda-ne̱ á, ho̱gu̱te̱ ma-to̱ u̱n ka rii-yo ko̱re̱ à. Gye̱r-o ho̱o̱ru̱ ye̱, ye̱ se̱ke̱msu̱ru̱ jin-u̱r Wan-Ko̱yan Ye̱so. ");
INSERT INTO uth_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","U̱t-mo̱o̱r ne̱ be-de u̱n ka ye̱ she̱re̱ o-nip à, ye̱ haanu̱ru̱ ye̱ ro m-rwo̱r u̱n se̱nge̱-mo̱ u̱n ye̱ mo̱ u̱n me̱n-u̱t jaas-to̱ cas. ");
INSERT INTO uth_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Hun-ne̱ de̱e̱n komo, yan-gu̱te̱ u̱n hun-ne̱ o-gwo̱t, ye̱ mo̱ro̱gsu̱ru̱ taku̱rda-to̱ u̱n ye̱ to̱ mo̱r, ye̱ tu̱ksu̱ru̱ to̱ hun-ne̱ gu̱t ye̱ kap. Bo̱ ye̱ nomte̱ ceker-se u̱n ka hwo̱r-ye̱ u̱n ka taku̱rda-to̱ à, ye̱ wooste̱ hwo̱r-ye̱ ko-ya-u̱r-gu̱wu̱s he m-kum u̱n se̱nge̱-mo̱ u̱t-ho̱ dugu-u̱s kwo̱o̱z-u̱t yoor u̱n o̱p à 50,000. ");
INSERT INTO uth_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","U̱n kaane̱ ma-u̱t Wan-Ko̱yan rige̱ ho̱no o-dak kap komo to̱ ci'u̱ru̱ hun-ne̱ m-so̱k ne̱. ");
INSERT INTO uth_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Bo̱ u̱n no̱m-mo̱ u̱n se ka rem-se, Burus zo̱ngsu̱ru̱ hur-de u̱n wu̱ u̱nze wu̱a he o-Urusharima, amba se̱ wu̱ do̱ru̱te̱ so̱ u̱n dak-to̱ o-Makidoniya o-Akaya ne̱. Wu̱ ze̱e̱ru̱, “Komo me̱ heese̱ re̱e̱no̱, man gagte̱ hi u̱n de m-ha u̱m hyante̱ bo̱-o̱ o-Roma.” ");
INSERT INTO uth_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Wu̱ to̱mu̱ru̱ yan-gwu̱-o̱ u̱n wu̱ ne̱n yoor, ye̱ ro, Timoti ne̱ u̱n Erastus, ha-mo̱ o-Makidoniya, wu̱ ne̱ wu̱ do̱o̱bu̱ru̱ ya o-da u̱n dak-o̱ o-Asiya. ");
INSERT INTO uth_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","U̱n ka da-o̱, a no̱mo̱g rii-yo 'yonse̱ hun-ne̱ u̱r-hur de̱e̱n à, remen u̱n Co̱w-o u̱n Wan-Ko̱yan. ");
INSERT INTO uth_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Ka ma-to̱ u̱n cir be-de u̱n wu̱ ken ko-ya-o-pyap-wu̱ jin-de u̱n wu̱ Du̱mitu̱riyas. Wu̱ ro u̱n zwo̱ u̱n azorpa à, wu̱ ro m-zwo̱ u̱n sha-mo̱ u̱n pyo-o̱ u̱n to̱o̱g-o Arte̱mis. Wu̱ u̱n yan-se̱nge̱-mo̱ o-pyap ne̱ ro u̱n kum u̱n hwo̱r de̱e̱n. ");
INSERT INTO uth_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Wu̱ karagsu̱ru̱ ye̱ kap yan-no̱m u̱n gon ka se̱nge̱-mo̱. Wu̱ ze̱e̱ru̱, “No̱ hun-ne̱, no̱ nepste̱ u̱n ka se̱nge̱-mo̱ ne̱ atte̱ no̱ m-kum u̱n hwo̱r. ");
INSERT INTO uth_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Komo no̱ hyanag no̱ ho̱gu̱sse̱, ba kane̱ o-Apisu cot á, se̱ u̱m zee kap dak-o̱ o-Asiya ma. Ka Burus-wu̱ ro̱ hun-ne̱ m-nakbe̱ u̱t-mo̱o̱r ne̱ de̱e̱n. Wu̱ waksu̱te̱ hur-de u̱n ye̱, wu̱ ro̱ m-ze̱e̱ ka shir-o̱ a no̱me̱ u̱t-kom à, ba shir o̱ á. ");
INSERT INTO uth_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Ma-u̱t a no̱m m-yo̱. A naas jin-de u̱n se̱nge̱-m na, komo har u̱n pyo-o̱ u̱n caari-wu̱ u̱n shir Arte̱mis. A mus o̱ hwaa, har komo a wongse̱ ka shir-o̱ u̱n con-de u̱n o̱ ne̱. Wu̱ myet dak-o̱ o-Asiya har u̱n ho̱no o-dak ne̱ ro̱ wu̱ m-kwu̱kte̱ à.” ");
INSERT INTO uth_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Bo̱ ye̱ ho̱gu̱te̱ kaane̱ à, ye̱ swo̱o̱ru̱ u̱s-ryaab de̱e̱n, ye̱ 'yonsu̱ u̱s-co̱r da-o gaan ye̱ ro m-ze̱e̱, “Arte̱mis ko-caari-wu̱, shir-wu̱ u̱n Apisu-ne̱!” ");
INSERT INTO uth_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Ba u̱n naas o-da, bo̱-o argu̱ m-rukre̱. Hun-ne̱ nupu̱ru̱ u̱s-rek ha-mo̱ u̱n ka be-de atte̱ m-mo̱rge̱ à. Ye̱ ro m-huk u̱n Gayas ne̱ u̱n Aristarkus, hun-ne̱ ye̱ o-Makidoniya, ye̱ ro nay-ne̱ u̱n yan-hew-u̱r Burus ne̱ à. ");
INSERT INTO uth_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Burus conu̱ m-co̱w u̱n ka mo̱ro̱g-de, amba yan-dor Ye̱so we̱nu̱ wu̱. ");
INSERT INTO uth_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Ye̱ ken caari-ne̱ ye̱ u̱n se̱k-ye̱ u̱n gwo̱mo-ne̱ ye̱ u̱n dak-o̱ o-Asiya, ye̱ ro u̱r-nay u̱n wu̱ ne̱ à. Ye̱ ma ye̱ tomtu̱ru̱ wu̱ u̱t-ma, ye̱ ko̱nu̱ru̱ wu̱ taase wu̱ cu̱w be-de u̱n ka mo̱ro̱g-de á. ");
INSERT INTO uth_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Ka mo̱ro̱g-de u̱n hun-ne̱ de ro zo̱'o̱gse̱, remen ye̱ nap ma rii-yo rwo̱'e̱ ye̱ mo̱rgu̱te̱ á. Ye̱ ken ye̱ ro u̱n 'yons u̱s-co̱r ye̱ ro m-rwo̱r u̱n yo ken rii-yo, ye̱ ken komo ye̱ ro m-rwo̱r u̱n yo ken rii-yo u̱n ho̱n. ");
INSERT INTO uth_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Ye̱ ken Yahuda-ne̱ ye̱ tudbu̱ru̱ wu̱ ken wu̱ u̱n co, jin-de u̱n wu̱ Arekanda. Wu̱ se̱ngu̱ru̱ u̱t-ma u̱n jaksu̱ u̱n kom-o̱ wu̱, remen hun-ne̱ rest temb, wu̱ nomu̱té̱ ye̱ u̱t-ma. Wu̱ co̱no̱g wu̱ ru̱ru̱tu̱ ye̱ u̱nze Yahuda-ne̱ ye̱ hante̱ 'yons u̱r-hi á. ");
INSERT INTO uth_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Amba bo̱ ye̱ nepte̱ u̱nze ko-Yahuda-wu̱ à, ye̱ 'yonsu̱ u̱s-co̱r. Da-o gaan ye̱ ro m-ze̱e̱, “Go̱s-u̱t kumute̱ be-u̱r Arte̱mis u̱n Apisu-ne̱!” Ye̱ no̱mo̱g kaane̱ har awa u̱s-yoor. ");
INSERT INTO uth_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Amba ko-ya-m-ge̱n-wu̱ u̱n ka bo̱-o̱ rwo̱'u̱ ye̱ m-re̱s ceen. Wu̱ ze̱e̱ru̱, “No̱ hun-ne̱ ye̱ o-Apisu! Ai, ko̱ wu̱ ke nepste̱ u̱nze bo̱-o̱ o-Apisu o̱ ro̱ m-was u̱n pyo-o Arte̱mis ne̱ wa-u̱t-go̱s, komo u̱n ka ta'ar-de ne̱ de he'ene̱ e̱s-mo̱ n-To̱n à. ");
INSERT INTO uth_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","M-mo̱ka yatt-wu̱ he m-she u̱n to̱ ka á, remen kaane̱ e̱ss no̱ u̱r-hi be-u̱r gaan, no̱ no̱m rem-se o-saa á. ");
INSERT INTO uth_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","No̱ hantu̱te̱ kà hun-ne̱ ye̱ kaane̱. Ye̱ hiw u̱r-hyow u̱n kuke̱-o̱ u̱n shir na á, komo ye̱ yo'og Arte̱mis á. ");
INSERT INTO uth_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Amba, u̱rege̱ Du̱mitu̱riyas u̱n yan-se̱nge̱-mo̱ u̱n wu̱ ne̱ ye̱ ro̱ u̱n o̱ ken ryegen-o̱ ne̱ mo̱sse̱ u̱n wu̱ ken wu̱ ne̱, ai, kuke̱-to̱ u̱n piish u̱t-ma to̱ ka, ye̱ hoks heet u̱r-gyekt. ");
INSERT INTO uth_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Amba u̱rege̱ yo ken rii-yo ro̱ ko̱n u̱n ho̱n, yo no̱ co̱ne̱ m-hante̱ à, ai a argu̱ m-hongse̱ u̱n yo be-de u̱n piish u̱t-ma. ");
INSERT INTO uth_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Remen ka mo̱ro̱g-de ro depete̱ á. Ye̱ ken gwo̱mo-ne̱ piishité̱ na u̱t-ma remen ka gu̱n-de. Komo a hoks m-shas yan-piishe̱ u̱t-ma á.” ");
INSERT INTO uth_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Bo̱ wu̱ ru̱rte̱ kaane̱ à, wu̱ yagu̱ru̱ ko̱wan wu̱ neke̱ hur-o̱ u̱n wu̱. ");
INSERT INTO uth_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Bo̱ ka ween-to̱ hebu̱ssu̱te̱ à, Burus agnu̱ yan-dor Ye̱so, wu̱ dooru̱ ye̱ jaab-o̱ u̱t-me̱n. Wu̱ ze̱e̱ru̱ ye̱ se̱ ho̱-u̱r ho̱r-de, wu̱ argu̱ru̱ dak-o̱ o-Makidoniya. ");
INSERT INTO uth_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Bo̱ wu̱ pa'agsu̱te̱ ka raag-o̱ à, wu̱ se̱ngu̱ do ye̱ u̱n yan-dor jaab-o̱ u̱t-me̱n u̱n bo̱-to̱ wu̱ do̱re̱ à. Ka da-de, wu̱ argu̱ m-wo̱ dak-o̱ o-Girik. ");
INSERT INTO uth_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Wu̱ no̱mu̱ re̱ng-u̱s tet kane̱. Wu̱ ro u̱t-zo̱nge̱ wu̱ deet hat-o̱ m-ho̱ wu̱ waragte̱ dak-o̱ o-Siriya. Ka da-de, wu̱ nape̱ u̱nze Yahuda-ne̱ rewesu̱te̱ wu̱ rew-u̱r yo̱-de. Remen kaane̱, wu̱ gwo̱tu̱ru̱ wu̱ zee warag-mo̱ u̱n bu̱-yo o-Makidoniya a jiish wu̱. ");
INSERT INTO uth_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Hun-ne̱ de̱e̱n ro m-neke̱ u̱n wu̱ ne̱. Ye̱ ro Supata (wà Pirus ko-ya-o-Biriya), mo̱sse̱ u̱n Aristarkus ne̱ u̱n Secundus ne̱ (hun-ne̱ ye̱ o-Tasaronika), u̱n Gayas ne̱ (ko-ya-o-Darbe̱), u̱n Timoti ne̱, har ma u̱n Tiko̱ko̱s ne̱ u̱n Taro̱pimus ne̱ (hun-ne̱ ye̱ o-Asiya), ye̱ shiiru̱ wu̱. ");
INSERT INTO uth_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Ye̱ be'estu̱ te̱ m-arag. Ye̱ waasu̱ru̱ te̱ o-To̱ruwas. ");
INSERT INTO uth_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Bo̱ u̱n ko̱m-mo̱ u̱n Biki-o̱ u̱t-Buro̱di to̱ ba m-Yist, te̱ komo te̱ inu̱ru̱ o-Piripi u̱n hat-o̱ m-ho̱. Bo̱ u̱n rew-mo̱ u̱n ho̱-u̱t taan, te̱ 'wo̱ssu̱ ye̱ o-To̱ruwas. O-To̱ruwas te̱ no̱mu̱ ho̱-u̱t ta'yoor. ");
INSERT INTO uth_vpl VALUES ("AC20_7","074_20_7","