﻿USE sofia;
DROP TABLE IF EXISTS sofia.uspNT_vpl;
CREATE TABLE uspNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES uspNT_vpl WRITE;
INSERT INTO uspNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Ri' ri jb'ijak yak jmam Kakaj Jesucristo ri rijajl David y Abraham. ");
INSERT INTO uspNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham ri' ri jkaj Isaac, Isaac ri' ri jkaj Jacob y Jacob ri' ri jkaj Judá pach yak jk'un y ratz. ");
INSERT INTO uspNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Judá ri' ri jkajak Fares pach Zara y jchuchak ri' Tamar. Fares ri' ri jkaj Esrom y Esrom ri' ri jkaj Aram. ");
INSERT INTO uspNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aram ri' ri jkaj Aminadab, Aminadab ri' ri jkaj Naasón y Naasón ri' ri jkaj Salmón. ");
INSERT INTO uspNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmón ri' ri jkaj Booz y jchuch ri' Rahab, Booz ri' ri jkaj Obed y jchuch ri' Rut y Obed ri' ri jkaj Isaí. ");
INSERT INTO uspNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Isaí ri' ri jkaj rey David, David ri' ri jkaj Salomón y jchuch Salomón ri' ri anm ri xwa'x pire rixokl Urías. ");
INSERT INTO uspNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomón ri' ri jkaj Roboam, Roboam ri' ri jkaj Abías y Abías ri' ri jkaj Asa. ");
INSERT INTO uspNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa ri' ri jkaj Josafat, Josafat ri' ri jkaj Joram y Joram ri' ri jkaj Uzías. ");
INSERT INTO uspNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzías ri' ri jkaj Jotam, Jotam ri' ri jkaj Acaz y Acaz ri' ri jkaj Ezequías. ");
INSERT INTO uspNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezequías ri' ri jkaj Manasés, Manasés ri' ri jkaj Amón y Amón ri' ri jkaj Josías. ");
INSERT INTO uspNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josías ri' ri jkaj Jeconías pach yak jk'un y ratz la' mak junab' cuando yak rijajl Israel xc'amsajtakb'i prexil Babilonia. ");
INSERT INTO uspNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Cuando xk'ajtakch prexil yak rijajl Israel Babilonia, xwa'x jun jc'ajol Jeconías y xcoj jb'ij pi Salatiel. Salatiel ri' ri jkaj Zorobabel. ");
INSERT INTO uspNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zorobabel ri' ri jkaj Abiud, Abiud ri' ri jkaj Eliaquim y Eliaquim ri' ri jkaj Azor. ");
INSERT INTO uspNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azor ri' ri jkaj Sadoc, Sadoc ri' ri jkaj Aquim y Aquim ri' ri jkaj Eliud. ");
INSERT INTO uspNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliud ri' ri jkaj Eleazar, Eleazar ri' ri jkaj Matán y Matán ri' ri jkaj Jacob. ");
INSERT INTO uspNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jacob ri' ri jkaj José ri richjil María, María ri' ri jchuch Kakaj Jesús y Kakaj Jesús ri' ri tib'ijsaj re chi ri' ri b'il jwi'l Kakaj Dios chi tina jtaknach wich ulew. ");
INSERT INTO uspNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Y jilonli xwa'xi' cajlajuj (14) k'at ijajl ri xcholmajch chirij Abraham asta chirij David. Y xwa'xi' cajlajuj (14) k'at ijajl chic ri xcholmajch chirij David asta cuando yak rijajl Israel xc'amsajtakb'i prexil Babilonia. Y xwa'xi' cajlajuj (14) k'at ijajl chic ri xcholmajch cuando xk'ajtakch prexil yak rijajl Israel Babilonia asta chirij Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Jilonri xq'uisi'y Kakaj Jesucristo, María ri jchuch Kakaj Jesucristo tz'onalchak jwi'l José pire tic'uli'y riq'uil, pero ajqui' chi jc'am rib'ak riq'uil cuando xan yaj anm jwi'lke jcwinel Lok'laj Jsantil Kakaj Dios. ");
INSERT INTO uspNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","José ri tz'onawinak re María, juntir ri tran pi jcholajli'n, re ri' raj ta' tresaj jq'uixb' María ri nen jcholajl. Xchomorsaj roj xcan jye' chi mukukil. ");
INSERT INTO uspNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Re jilonli tijin tijchomorsaj, cuando xrichc'aj xpe jun anjl ri takalch jwi'l Kakaj Dios ri Kajawl, xij re: At José ri at rijajl David, mi tzaak ach'ol chi jc'amic María pi awixokl jwi'l man ra ric'lal ri tiq'uisi'y rechi' Lok'laj Jsantil Kakaj Dios. ");
INSERT INTO uspNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","María tiq'uisi'y jun ra ric'lal winak y tacoj jb'ij pi Jesús. Jilonli jb'ij jwi'l ri' re ticolow rechak juntir yak jwinak laj jk'ab' jmacak, xche'. ");
INSERT INTO uspNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Juntir li ri xaan pirechi' xtaw chiwch juntir Jyolj Kakaj Dios ri Kajawl ri xij jun ajk'asal Jyolj Kakaj Dios cuando xij jilonri: ");
INSERT INTO uspNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Jun k'apoj anm ri ta' echb'el jwi'l ni jono winak tican yaj anm, tiq'uisi'y jun ra ric'lal winak y tijcojtak jb'ij pi Emanuel, xche'. Ri jcholajl tielwi' man yoloj Emanuel, Kakaj Dios wi'chak kiq'uil. ");
INSERT INTO uspNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Cuando xc'astaj jwich José, xan chapca' xijsaj re jwi'l anjl ri takalch jwi'l Kakaj Dios ri Kajawl. Jilonli xc'am María pire rixokl. ");
INSERT INTO uspNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Pero ta' xrechb'ej rib'ak asta xq'uisi'y ra ric'lal winak ri xcojsaj jb'ij pi Jesús jwi'l José, ajruc're' xrechb'ej rib'ak. ");
INSERT INTO uspNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Kakaj Jesús xq'uisi'y Belén ri jun tilmit re Judea la' mak junab' cuando Nab'e Herodes wi' pire rey. La' mak k'ij li xpetak nic'j winak laj jsuc'lal lamas tielwi'ch k'ij, rechak tijojemi' rib'ak chirij ch'umil. Xtawtak Jerusalén chi rilic Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Xtz'onajtak jtaquil cla', xijtak: ¿Lamas wi' jreyak yak rijajl Israel ri xq'uisi'yc? Oj xkila'ch jch'umil cuando wojch laj jsuc'lal lamas tielwi'ch k'ij y xojpe chi jnimirsaj jk'ij, xche'tak. ");
INSERT INTO uspNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Cuando man rey Herodes xta jtaquil chi jilonli tijb'ijtak, sub'laj xoc il chi jtaic y jilon juntir cristian ri wi'tak Jerusalén. ");
INSERT INTO uspNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Xpe Herodes, xtak jsiq'uijcak mak jb'ab'alak yak ajc'amaltak jb'eak cristian riq'ui Kakaj Dios pach yak ajtijoltak cristian re Jpixb' Kakaj Dios y xtz'onaj rechak lamas tiq'uisi'ywi' jun ri b'il jwi'l Kakaj Dios chi tina jtaknach wich ulew. ");
INSERT INTO uspNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Rechak xijtak re man rey: Ji' tiq'uisi'y Belén ri jun tilmit re Judea jilon xcan jtz'ib'aj jun ajk'asal Jyolj Kakaj Dios ojr cuando xij chirij jilonri: ");
INSERT INTO uspNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","At tilmit Belén ri jun tilmit re Judea, ma' at ta' jun tilmit ri ta' cojol jk'ij chijxo'lak mak tilmit re Judea, jwi'l cla' tiq'uisi'ywi' jun rey ri tic'amow jb'eak yak rijajl Israel ri inwinak, xche', xche'tak re. ");
INSERT INTO uspNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Xpe Herodes, xtak jsiq'uijcak chi mukukil mak winak ri tijojem rib'ak chirij ch'umil pire xijsaj re nen or xriltak man ch'umil. ");
INSERT INTO uspNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Ajruc're' xtaktakb'i Belén, xij rechak: Jattak, toctatak lamas wi' man ra ne' li y cuando tata'tak, tik'ax ab'ijtak chic chwe lamas wi' pire tib'e innimirsaj jk'ij, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Mak winak ri tijojem rib'ak chirij ch'umil cuando xtatak ri xijsaj rechak jwi'l man rey, xe'tak. Y man ch'umil ri xriltakch laj jsuc'lal lamas tielwi'ch k'ij nab'eyi' chiwchak ajri' xe' wa'rok la' man luwar lamas wi' ra ne'. ");
INSERT INTO uspNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Mak winak li ri tijojem rib'ak chirij ch'umil cuando xriltak xwa'r man ch'umil sub'laj xqui'cottak. ");
INSERT INTO uspNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Cuando xoctak la ja, xriltak man ra ne' pach María ri jchuch, rechak laj or xxucb'a' rib'ak chiwch man ra ne' chi jnimirsaj jk'ij y xteb'a' jcaxak y xsipajtak oro, pom y mirra re ra ne'. ");
INSERT INTO uspNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Y mak winak li ri tijojem rib'ak chirij ch'umil xijsaj rechak laj richc'ak chi ta' chiqui' tik'axtak riq'ui man rey. Jwi'li'li ji'chak xk'axtakb'i li jun jalan b'e cuando xk'ajtakb'i laj richochak. ");
INSERT INTO uspNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Cuando jorok b'i'taka' mak winak ri tijojem rib'ak chirij ch'umil, xrichc'aj José chi xwab'a' rib' jun ranjl Kakaj Dios ri Kajawl chiwch y xij re: B'iiten, c'amb'i man ra ne' pach jchuch, jattak Egipto. Wa'xentak cla' asta tina imb'ijna chawechak cuando ateltakch cla' jwi'l man rey Nab'e Herodes tijtoca' man ra ne' pire tijcamsaj, xche' anjl re José. ");
INSERT INTO uspNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Y lak'ab' li cuando xc'astaj jwich José, xb'iitb'ic, xc'amb'i ra ne' pach jchuch xe'tak Egipto. ");
INSERT INTO uspNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Cla' xwa'xtak asta xtaw k'ij xcam Herodes. Jilonli xantak pire xtaw chiwch Jyolj Kakaj Dios ri Kajawl ri xij jun ajk'asal Jyolj Kakaj Dios cuando xij jilonri: Egipto xinsiq'uij Inc'ajol, xche' Kakaj Dios. ");
INSERT INTO uspNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Nab'e Herodes cuando xretemaj chi xsub'saji' jwi'lak mak winak ri tijojem rib'ak chirij ch'umil sub'laj xpe retzal, xtak jcamsajcak tra winak ri ajri' jq'uisi'ycak asta mak tra ri wi' cacab' junb'ak ri wi'tak Belén pach mak tra ri wi'tak chijc'ulel man tilmit li, jwi'l wi'chak quib' junab' jb'ij jwi'lak mak winak ri tijojem rib'ak chirijak mak ch'umil. ");
INSERT INTO uspNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Jilonli xtaw chiwch Jyolj Kakaj Dios ri xcan jtz'ib'aj Jeremías ri ajk'asal Jyolj Kakaj Dios ri xij jilonri: ");
INSERT INTO uspNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Li tilmit Ramá xtasaj sub'laj ok'ej y sub'laj ch'ejejem jwi'l b'is. Y ri' Raquel ri tiok' chirijak yak ric'lal. Ta' raj tiye'saj jcowil ranm jwi'l xcami' yak ric'lal, xche' Kakaj Dios. ");
INSERT INTO uspNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Pero cuando jorok cami' man Nab'e Herodes, José wi' Egipto cuando xrichc'aj chi xwab'a' chic rib' jun ranjl Kakaj Dios ri Kajawl chiwch y xij re jilonri: ");
INSERT INTO uspNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","B'iiten, c'amb'i man ra ne' pach jchuch, k'ajentak laj jluwrak yak rijajl Israel jwi'l lajori xcamtaka' mak ri rajak roj xcamsajtak ra ne', xche' re. ");
INSERT INTO uspNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","José xb'iitc, xc'amb'i ra ne' pach jchuch xe'tak laj jluwrak yak rijajl Israel. ");
INSERT INTO uspNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Pero cuando xta chi Herodes Arquelao xcan pire rey re Judea pi jq'uexwach Nab'e Herodes ri jkaj, José xtzaak jch'ol chi b'enam cla' y xijsaj re jwi'l Kakaj Dios laj richc' chi ta' tib'e cla'. Jwi'li'li ji' xe' Galilea. ");
INSERT INTO uspNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Xe' wa'x Nazaret ri jun tilmit re Galilea. Jilonli xtaw chiwch ri xijtak yak ajk'asaltak Jyolj Kakaj Dios ojrtaktzij jilonri: Re tina b'ijsajna chirij chi aj Nazareti'n, xche'tak. ");
INSERT INTO uspNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Y la' mak k'ij li xticar Juan Ajb'anal Ja'tiox chi jtijoj cristian re Jyolj Kakaj Dios ri titawtak riq'uil li jun luwar re Judea lamas ta' cristian. ");
INSERT INTO uspNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Re xij: Q'uex ano'jak chiwch Kakaj Dios jwi'l raquitzchak raj tijchol takon Kakaj Dios chib'ak cristian, xche'. ");
INSERT INTO uspNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Chiriji' Juan Ajb'anal Ja'tiox ri xcan tz'ib'aj jwi'l Isaías ri ajk'asal Jyolj Kakaj Dios ri tijb'ij chi tina tasajna jun ri cow tich'ejej li jun luwar lamas ta' cristian, tijb'ij jilonri: B'antak jwa'x jb'e Kakaj Jesús ri Kajawl, teb'a'tak jb'e suc'ul laj awanmak, tiche'. ");
INSERT INTO uspNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Ritz'ik Juan Ajb'anal Ja'tiox ri tijcoj b'anal la' rusumal camello y jpas b'anal la' tz'um y sac' pach cab' re lak che' tijtij pire jwa. ");
INSERT INTO uspNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Wi' cristian xpetak Jerusalén, wi' xpetak lak juntir luwar re Judea y wi' xpetak lak luwar re chi' nimi ja' Jordán xtawtak chi jtaic jyolj Juan Ajb'anal Ja'tiox. ");
INSERT INTO uspNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Y yak ri xc'am jk'ab'al jmacak chiwch Kakaj Dios, xpe Juan Ajb'anal Ja'tiox xan ja'tiox rechak li nimi ja' Jordán. ");
INSERT INTO uspNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Pero Juan Ajb'anal Ja'tiox, cuando xril chi sub'laj q'ui mak fariseo pach mak saduceo xtawtak riq'uil, ri' rajak tib'an ja'tiox rechak, xij rechak: Pur atak cumatz ri ticamsanc. Ta' nen xin chawechak chi atcolmajtaka' chiwch jk'atb'itzij Kakaj Dios ri tina ranna jwi'l retzal. ");
INSERT INTO uspNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","B'antak tzitaklaj no'j laj ac'aslemalak pire tic'utun chi kes tz'et xaq'uexa' ano'jak y xac'ama' jk'ab'al amacak chiwch Kakaj Dios. ");
INSERT INTO uspNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Ma chomorsaj laj awanmak chi atcolmajtaka' jwi'l ataka' rijajl Abraham. Jwi'l in tamb'ij chawechak chi Kakaj Dios ticwini' chi tiwux mak ab'aj ri pi rijajl Abraham. ");
INSERT INTO uspNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Man iquej wi'chak laj ra' mak che' pire tic'ursajtakb'ic. Juntir mak che' ri ta' tzi tiwichintak, tic'ursajtaka'n y tit'ojsajtaka' li k'ak'. ");
INSERT INTO uspNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","In kes tz'et la' ja' tamb'an ja'tiox chawechak chi jc'utic chi xaq'uexa' ano'jak, pero petzal chiqui' jun chwij mas jcwinel chinwch in, ni ta' tic'ular pi we tanc'amb'i jxajb'. Re tina ranna ja'tiox chawechak la' Lok'laj Jsantil Kakaj Dios y la' k'ak'. ");
INSERT INTO uspNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Re c'amali'ch jun kelen jwi'l laj jk'ab' ri quiek la' tijpu'w jwich trig y tijtos mak rakan ri tiel chijxo'l. Tijc'ol man trig li c'uja, pero mak rakan ri tiel chijxo'l tijc'at li jun k'ak' ri ta' jchupic, xche' Juan Ajb'anal Ja'tiox. ");
INSERT INTO uspNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Kakaj Jesús xelb'i Galilea xe' chi' nimi ja' Jordán riq'ui Juan Ajb'anal Ja'tiox pire tib'ansaj ja'tiox re. ");
INSERT INTO uspNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Juan Ajb'anal Ja'tiox ta' raj roj xan ja'tiox re, xij re: Ri' at rajwax atb'anow ja'tiox chwe chiwch in imb'anow ja'tiox chawe. ¿Nen chac atpe wiq'uil? xche' re. ");
INSERT INTO uspNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Kakaj Jesús xij re: Canok pi jilonli, b'an ja'tiox chwe pire tikab'an juntir lawi' raj Kakaj Dios tikab'an, xche' re. Ji'kelonli xansaj ja'tiox re jwi'l Juan Ajb'anal Ja'tiox. ");
INSERT INTO uspNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Cuando xantaj ja'tiox re Kakaj Jesús, xelch ralaj ja', xtormaj caj y xril kesalch Lok'laj Jsantil Kakaj Dios chib' chapca' rilic jun ra ut. ");
INSERT INTO uspNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Y xtasaj jun ch'a'wem xaanch lecj, xijch: Ri' ri lok'laj Inc'ajol ri sub'laj inqui'cot chirij, xche'ch. ");
INSERT INTO uspNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Xpe Lok'laj Jsantil Kakaj Dios, xc'amb'i Kakaj Jesús li jun luwar lamas ta' cristian pire titakchi'j chi macun jwi'l man jb'ab'al etzl. ");
INSERT INTO uspNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Ca'winak (40) k'ij, ca'winak (40) ak'ab' xwa'x Kakaj Jesús cla', ta' nen xtij. Cuando xtz'akat ca'winak (40) k'ij y ca'winak (40) ak'ab', ajruc're' xric'aj wi'jal. ");
INSERT INTO uspNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Xpe man jb'ab'al etzl, xtaw riq'ui Kakaj Jesús chi jtakchi'j chi macunc, xij re: Wi kes tz'et ati' Jc'ajol Kakaj Dios, b'ij re mak ab'aj ri chi tiwuxtak pi cuxlanwa, xche' re Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Pero Kakaj Jesús xij re: Li wuj re Lok'laj Jyolj Kakaj Dios tz'ib'ali' jilonri: Ma' jwi'l ta'ke cuxlanwa tiyo'rwi' jun cristian, jwi'li' juntir Jyolj Kakaj Dios, tiche', xche' re. ");
INSERT INTO uspNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Ajruc're' man jb'ab'al etzl laj or xc'am chicb'i Kakaj Jesús li tilmit Jerusalén ri tosol pire Kakaj Dios, xe' jwab'a' li man luwar mas naj rak'aneb' re nimi richoch Kakaj Dios ");
INSERT INTO uspNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","y xij re: Wi kes tz'et ati' Jc'ajol Kakaj Dios, t'ojb'i ayb' neri atb'e kej lak ulew, jwi'l li wuj re Lok'laj Jyolj Kakaj Dios tz'ib'ali' jilonri: Kakaj Dios tijtaka'ch yak anjl chi achajajc y rechak atjc'ula'taka' la' jk'ab'ak pire ma' tib'e ach'i'ye' awakan la' jun ab'aj, tiche', xche' man jb'ab'al etzl re Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Kakaj Jesús xij chic re: Pero li wuj re Lok'laj Jyolj Kakaj Dios tz'ib'ali' jilonri: Ma tz'onaj re Akaj Dios ri Awajawl chi tran jun kelen pireke tawil wi kes tz'eti' tran ri tijb'ij, tiche', xche' re. ");
INSERT INTO uspNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Xpe chic man jb'ab'al etzl, xc'am chicb'i Kakaj Jesús b'a jun witz sub'laj naj rak'aneb' y xc'utb'i chiwch juntir mak tilmit ri wi' wich ulew y juntir mak kustaklaj kelen ri wi' chiwch y xij re: ");
INSERT INTO uspNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","In tanjacha' juntir li laj ak'b' wi atxucar chinwch y tacoj ink'ij, xche' re Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Kakaj Jesús xij chic re man jb'ab'al etzl: Jat jb'ab'al etzl, elamb'i neri, jwi'l li wuj re Lok'laj Jyolj Kakaj Dios tz'ib'ali' jilonri: Nimirsaj jk'ij Akaj Dios ri Awajawl y xike rajwax tab'an lawi' raj re tab'an, tiche', xche' Kakaj Jesús re man jb'ab'al etzl. ");
INSERT INTO uspNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Y man jb'ab'al etzl xelb'ic, xcan jye' Kakaj Jesús y xtawtak nic'j anjl chi jt'o'ic Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Kakaj Jesús cuando xta jtaquil chi Juan Ajb'anal Ja'tiox xcojsaji' li cars, xk'aj Galilea. ");
INSERT INTO uspNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Cuando xtaw cla', ta' xwa'x Nazaret, re ji' xe' wa'xok Capernaúm, jun tilmit ri wi' chi' nimlaj alagun, chijc'ulel jluwrak yak rijajl Zabulón pach yak rijajl Neftalí. ");
INSERT INTO uspNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Jilonli xtaw chiwch ri xcan jtz'ib'aj Isaías ri ajk'asal Jyolj Kakaj Dios ojr cuando xij jilonri: ");
INSERT INTO uspNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Man jluwrak yak rijajl Zabulón pach man jluwrak yak rijajl Neftalí ri wi'tak ch'akap re nimi ja' Jordán chi' nimlaj alagun re Galilea ri lamas wi'tak yak ma' rijajl ta' Israel. ");
INSERT INTO uspNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Mak cristian li ri wi'tak li uku'mal, xc'ula'taka' Jyolj Kakaj Dios chapca' xkopaj rib' jun nimlaj k'ak' chib'ak. Jilonli jun k'ak' xkopaj rib' chib'ak mak ri wi'tak chapca' li uku'mal jwi'l jmacak, xche' Isaías. ");
INSERT INTO uspNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Cuando xtaw Kakaj Jesús Capernaúm, xoc chi jtijoj cristian re Jyolj Kakaj Dios, xij rechak: Q'uex ano'jak chiwch Kakaj Dios jwi'l raquitzchak raj tijchol takon Kakaj Dios chib'ak cristian, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Kakaj Jesús cuando tijin tiwo'cot chi' nimlaj alagun re Galilea, xril jwich Simón ri tib'ijsaj Pedro re pach Andrés ri jk'un. Rechak ajchapaltak cartaka'n, tijin tijt'oj jc'aatak re chapb'i car li ja'. ");
INSERT INTO uspNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Kakaj Jesús xij rechak: Jo'tak chwij y in atincoja'taka' chi jtoquic cristian pire tioctak laj jk'ab' Kakaj Dios chapca' jchapic car tab'antak, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Rechak laj or xcan jye' jc'aatak re chapb'i car y xe'tak chirij Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Kakaj Jesús xb'en chicb'i junquitz y xril chicb'i jwichak quib' winak ri jk'un ratz rib'ak, ri'taka' Santiago pach Juan yak jc'ajol Zebedeo. Rechak wi'tak li jun barc pach jkajak tijin tijc'ojaj jc'aatak re chapb'i car. Xpe Kakaj Jesús, xij rechak chi tib'etak chirij. ");
INSERT INTO uspNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Y laj or xcan jye'tak man barc pach jkajak y xe'tak chirij Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Kakaj Jesús xwo'cot lak juntir luwar re Galilea. Xtijoj cristian lak sinagog. Re xij tzilaj jtaquil rechak cristian chirij jtakon Kakaj Dios chib'ak cristian y xtzib'saj juntir jwich yajel ri wi' rechak. ");
INSERT INTO uspNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Jtaquil chirij Kakaj Jesucristo xtawi' lak juntir luwar re Siria. Xpetak cristian xc'amtakch juntir ri yajtak re jaljojtak yajel, yak ri wi' c'axlaj yajel rechak, yak ri wi' etzl laj ranmak, yak ri wi' quiek'ek' rechak y yak ri siquirnak jtio'jlak. Juntir li xtzib'sajtaka' jwi'l Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Y sub'laj cristian ri xpetak Galilea, Decápolis, Jerusalén, Judea y ri xpetak lak luwar ri wi'tak ch'akap re nimi ja' Jordán xamb'ertak chirij Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Xril Kakaj Jesús chi sub'laj cristian xmulb'a' rib'ak chirij, xjaw wich witz, cla' xcub'ar y yak ajtijol rib'ak chirij xjutuntak chijc'ulel. ");
INSERT INTO uspNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Y re xoc chi jtijojcak, xij rechak: ");
INSERT INTO uspNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Tzi rechak yak cristian ri tijchomorsajtak chi tichoconi' Kakaj Dios jwi'lak, jwi'lke li rechak tina octakna laj jk'ab' Kakaj Dios pire titakon chib'ak. ");
INSERT INTO uspNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Tzi rechak yak cristian ri tib'isontak jwi'l jmacak, jwi'l Kakaj Dios tina jye'na jcowil ranmak. ");
INSERT INTO uspNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Tzi rechak yak cristian ri ta' tijchomorsaj laj ranmak chi nimi' jk'ijak, jwi'l tina ye'sajna man ulew rechak jwi'l Kakaj Dios ri b'il jwi'l. ");
INSERT INTO uspNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Tzi rechak yak cristian ri xike b'esal ranmak chi jb'anic lawi' raj Kakaj Dios trantak chapca' jun cristian ri wi' wi'jal re y chekej chi' re, jwi'l tina tawna chiwch juntir ri b'esal ranmak chirij. ");
INSERT INTO uspNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Tzi rechak yak cristian ri tiiliwtak c'ur jwichak cristian, jwi'l rechak tina ilsajna c'ur jwichak jwi'l Kakaj Dios. ");
INSERT INTO uspNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Tzi rechak yak cristian ri suc'ul ranmak chiwch Kakaj Dios, jwi'l rechak tina riltakna jwich Kakaj Dios. ");
INSERT INTO uspNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Tzi rechak yak cristian ri tijtoctak nen trantak pire tiwa'x utzil chijxo'lak riq'uilak cristian, jwi'l Kakaj Dios tina jb'ijna chirijak chi ralc'waltaka'n. ");
INSERT INTO uspNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Tzi rechak yak ri tib'ansaj c'ax rechak jwi'l jb'anic lawi' raj Kakaj Dios trantak, jwi'l tina octakna laj jk'ab' Kakaj Dios pire titakon chib'ak. ");
INSERT INTO uspNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Tzi awechak atak ri atyok'sajtak, tib'ansaj c'ax chawechak y tik'ab'aj tzij chawijak jwi'lak cristian inwi'lke in. ");
INSERT INTO uspNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Wa'xok jun nimlaj qui'cotemal laj awanmak, jwi'l nimi' atojb'lak tac'ultak riq'ui Kakaj Dios lecj. Jilonli c'ax xansaj rechak yak ajk'asaltak Jyolj Kakaj Dios ri xyuktak nab'e chawchak, xche' Kakaj Jesús rechak. ");
INSERT INTO uspNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Kakaj Jesús xij chic rechak: Atak, ataka' atz'am pi rechak juntir cristian wich ulew. Pero wi man atz'am tiel jqui'l, ta' chiqui' tijna' tran qui', ta' chiqui' nen tichacuj, tichak t'ojsajb'i lak b'e y tiyak'saj jwi'lak cristian. ");
INSERT INTO uspNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Atak, ataka' k'ak' pi rechak juntir cristian wich ulew. Jun tilmit ri wi' b'a jun witz ri naj rak'aneb' ta' tijna' tijmuk rib'. ");
INSERT INTO uspNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Ta' ni jono cristian tijtzij jun candil pire tijye' ralaj jun cax. Jun cristian tijtzij jun candil ji' tijcocb'a' lecj pire tijsakab'saj juntir la ja. ");
INSERT INTO uspNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Y ji'c'ulon atak b'antak chapca' tikopopon ak'ak'alak chiwchak cristian pire cuando yak cristian triltak utzil ri tab'antak, tijb'ixajtaka' jnimirsaj jk'ij Akajak Dios ri wi' lecj, xche' Kakaj Jesús rechak. ");
INSERT INTO uspNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Kakaj Jesús xij chic rechak cristian: Ma chomorsajtak chi in ximpet pirechi' tansach jwich Jpixb' Kakaj Dios y ri xcan jtz'ib'ajtak yak ajk'asaltak Jyolj Kakaj Dios. In ta' ximpet chi jsachic jwichak, in ximpet pirechi' tiyuk imb'ane' juntir ri tijb'ij. ");
INSERT INTO uspNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Kes tz'etel tz'et tamb'ij chawechak, cuando ajwi'na caj pach ulew, ni junquitz tisaach re Jpixb' Kakaj Dios asta tina tawna chiwch juntir ri tijb'ij. ");
INSERT INTO uspNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Jwi'li'li nen ta' tijcoj jono Jpixb' Kakaj Dios ri ta' mas nim jk'ij y tijtijoj nic'j cristian chic pire ma' tijcojtak man pixab' li, ta' mas ticojsaj jk'ij lamas titakon Kakaj Dios. Pero nen tijcoj mak pixab' li y tijtijoj nic'j cristian chic pire tijcojtak mak pixab' li, re ticojsaji' mas jk'ij lamas titakon Kakaj Dios. ");
INSERT INTO uspNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","In tamb'ij chawechak wi mita' tacojtak Jpixb' Kakaj Dios mas chiwch ri tijcojtak yak ajtijoltak cristian re Jpixb' Kakaj Dios pach mak fariseo, ta' atwa'xtak lamas titakon Kakaj Dios, xche' Kakaj Jesús rechak cristian. ");
INSERT INTO uspNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Kakaj Jesús xij chic rechak cristian: Atak tali' awi'lak ri xijsaj rechak amam atit'ak jilonri: Mat camsantak jwi'l nen ticamsan tib'ani' k'atb'itzij chib', tiche'. ");
INSERT INTO uspNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Pero in tamb'ij chawechak chi nen jonok tipe retzal chirij jun cristian chic ri ta' jcholajl, tib'ani' k'atb'itzij chib'. Y nen jonok tiyok'ow re jun cristian chic, tib'ansaji' k'atb'itzij chib' jwi'lak mak comontak jb'ab'alak yak rijajl Israel. Y nen jono ri tijb'ij re jun cristian chic chi ta' nen tichacuj, tit'ojsaji' li jk'ak'al man luwar re tijb'i c'ax. ");
INSERT INTO uspNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Jwi'li'li cuando tijin taye' asipan b'a altar pire tasuj re Kakaj Dios y ticuxtaj awi'l chi wi' jun c'ax laj ranm jun cristian jwi'l ri xab'an re, ");
INSERT INTO uspNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","can ye' asipan chiwch man altar y jat nab'e riq'uil. Y b'ijta re chi tijcuy amac pire atcantak pi utzil riq'uil, ajruc're' atk'aj chic chi jsujic asipan re Kakaj Dios. ");
INSERT INTO uspNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Wi wi' nen atsiq'uin li k'atb'itzij, chomorsaj ayb'ak laj or pi utzil riq'uil cuando b'esalcatak li b'e pire ta' chiqui' atb'e jache' laj jk'ab' man k'atb'itzij, jwi'l wi atjjach laj jk'ab' man k'atb'itzij, tipe man k'atb'itzij atjjach laj jk'ab' man mayor y man mayor atjcoj li cars. ");
INSERT INTO uspNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Kes tz'etel tz'et tamb'ij chawe chi wi xatkej li cars, ta' atel wi mita' tatoj man q'uisb'i centaw pire atesajb'ic, xche' Kakaj Jesús rechak cristian. ");
INSERT INTO uspNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Kakaj Jesús xij chic rechak cristian: Atak tali' awi'lak ri b'ilch ojr jilonri: Ma wechb'ej jun cristian chic wi ma' ac'ulajl ta'n, tiche'. ");
INSERT INTO uspNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Pero in tamb'ij chawechak, nen jonok tril jwich jun anm y tijrayaj rechb'ej, chiwch Kakaj Dios niq'ui' riq'uil xrechb'eji' jwi'l jilon xrayaj laj ranm. ");
INSERT INTO uspNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Jwi'li'li in tamb'ij chawe chi wi ri' jpaach b'ak' awch tib'anow chawe atkej li mac, ri' mas tzi tawesajb'ic, tat'ojb'i chinaj chawe. Ri' mas tzi tisaach junquitzke re atio'jl chiwch juntir atio'jl tit'ojsajb'i li man luwar re tijb'i c'ax. ");
INSERT INTO uspNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Y wi ri' jpaach ak'b' tib'anow chawe atkej li mac, c'urb'ic, t'ojb'i chinaj chawe, ri' mas tzi tisaach jwich junquitzke re atio'jl chiwch juntir atio'jl tit'ojsajb'i li man luwar re tijb'i c'ax, xche' Kakaj Jesús rechak. ");
INSERT INTO uspNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Kakaj Jesús xij chic rechak cristian: B'ili'ch ojr jilonri: Nen jonok tican jache' rixokl, rajwaxi' tran jun jwuj rixokl ri tijb'ij chi xjacha' rib'ak, tiche'. ");
INSERT INTO uspNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Pero in tamb'ij chawechak chi nen jonok tijjach rixokl wi ma' jwi'l ta' xechb'ej jwi'l jun jalan winak chic, ri' re tib'anow re rixokl chi nic' riq'uil xechb'ej jwi'l jun winak chic ri ma' jc'ulajl ta' wi tic'uli'y riq'ui jono winak chic. Y nen jonok tic'uli'y chic riq'ui man anm li, ri jachal, nic' riq'uil tike rechb'ej y ma' jc'ulajl ta'n, xche' Kakaj Jesús rechak cristian. ");
INSERT INTO uspNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Kakaj Jesús xij chic rechak cristian: Y tali' awi'lak chi xijsaji' rechak amam atit'ak jilonri: Ma k'el ayb'ak chi jb'anic ri tab'ijtak re Kakaj Dios ri Kajawl chi tab'ana'taka'n, xche'. ");
INSERT INTO uspNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Pero in tamb'ij chawechak chi ta' tijna' tacojtak jun jalan b'ij chic laj ayoljak chi jb'ij chi tz'etel tz'eti' ri tab'ijtak. Ma cojtak jb'ij caj laj ayoljak chi jb'ij chi tz'etel tz'eti' ri tab'ijtak, jwi'l caj jcub'arb'i' Kakaj Dios. ");
INSERT INTO uspNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Ma cojtak jb'ij ulew laj ayoljak chi jb'ij chi tz'etel tz'eti' ri tab'ijtak, jwi'l ulew jluwri' rakan Kakaj Dios. Ma cojtak jb'ij tilmit Jerusalén laj ayoljak chi jb'ij chi tz'etel tz'eti' ri tab'ijtak, jwi'l tilmit Jerusalén ri' jtilmit nimlaj rey. ");
INSERT INTO uspNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Ma cojtak áb'ak laj ayoljak chi jb'ij chi tz'etel tz'eti' ri tab'ijtak, jwi'l ta' atcwintak chi jb'anic sak ni k'ek re jono rusumal áb'ak. ");
INSERT INTO uspNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Atak cuando atyolowtak y tab'ijtak jun yoloj tz'et, b'ijtak kes tz'et. Y cuando tab'ijtak jun yoloj ri ta' tz'et, b'ijtak chi ta' tz'et. Jwi'l jun cristian tijb'ij jb'ij jun kelen chi jb'ij chi tz'eti'n o ta' tz'et ri tijb'ij, man jb'ab'al etzl tib'anow re tijb'ij jilonli, xche' Kakaj Jesús rechak. ");
INSERT INTO uspNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Kakaj Jesús xij chic rechak cristian: Atak tali' awi'lak ri xijsaj ojr jilonri: Nen jun cristian tran c'ax re b'ak' jwich jun cristian, tina b'ansajna c'ax re b'ak' jwich re. Nen tran c'ax re ree jun cristian, tina b'ansajna c'ax re ree re, xche'. ");
INSERT INTO uspNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Pero in tamb'ij chawechak chi ma niq'uib'saj ayb'ak riq'uil nen ri tib'anow c'ax chawechak. Wi wi' nen atsec'ow la' jpaach acayb'al, ye' chic man jun lad acayb'al re chi seq'uem. ");
INSERT INTO uspNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Y wi wi' nen atsiq'uin li k'atb'itzij pire raj tijmajb'i atúnica, ye' luwar re tijc'am chicb'i awitz'ik ri tak'u'j. ");
INSERT INTO uspNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Y wi wi' jono cristian atjtakb'i chi rikaj rika'n jun kilómetro, c'amb'i quib' kilómetro chiwch. ");
INSERT INTO uspNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Wi wi' nen titz'onaj chawe jwi'l jono cristian, ye' re y wi wi' nen titz'onin kejom chawe, ye' re, ma q'uec'aj jye'ic, xche' rechak cristian. ");
INSERT INTO uspNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Kakaj Jesús xij chic rechak cristian: Y atak tali' awi'lak ri xijsaj ojr jilonri: Lok'aj awichc'ulchi' y etzelb'ej jwich acontre, xche'. ");
INSERT INTO uspNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Pero in tamb'ij chawechak lok'ajtak mak acontrak. Ch'a'wentak riq'ui Kakaj Dios pire tran utzil rechak mak ri tib'anowtak c'ax chawechak. ");
INSERT INTO uspNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Y wi jilon tab'antak li, ataka' ralc'wal Kakaj Dios lecj. Re trana' chi tielch k'ij chib'ak juntir cristian wich ulew chi tzi jno'jak, chi ta' tzi jno'jak y tijtaka'ch jab' chib'ak mak cristian ri suc'ul ranmak y chib'ak yak ri ta' suc'ul ranmak chiwch. ");
INSERT INTO uspNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Pero atak wi xike talok'ajtak yak ri atlok'intak, ta' nen tach'ectak jwi'l jiloni' trantak mak ajtz'onaltak alcabar chirib'il rib'ak. ");
INSERT INTO uspNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Y wi xike yak awichc'ulchi'ak tac'amtak rutzil jwichak, ta' jaljoj rilic ri tijin tab'antak, ji'ne'lon trantak chirib'il rib'ak mak ri ta' tijcojtak Jyolj Kakaj Dios. ");
INSERT INTO uspNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Atak rajwaxi' suc'ul awanmak chapca' Akajak Dios ri wi' lecj re suc'uli' ranm, xche' Kakaj Jesús rechak. ");
INSERT INTO uspNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Kakaj Jesús xij chic rechak cristian: Atak cwentijke ayb'ak, cuando tab'antak lawi' raj Kakaj Dios tab'antak, ma b'antak chiwchak cristian pireke atilsajtak. Wi tab'antak lawi' raj Kakaj Dios tab'antak pireke atilsajtak jwi'lak cristian, Akajak Dios ri wi' lecj ta' tijye' atojb'lak. ");
INSERT INTO uspNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Jwi'li'li at, cuando tasipaj jono kelen rechak yak ri wi' rajwax rechak, ma yol rechak juntir cristian chapca' trantak mak ajsolcopil jcayb'alak lak sinagog y lak b'e, ri'ke rajak tzi jyolicak tib'ansaj jwi'lak cristian. Pero kes tz'etel tz'et tamb'ij chawechak chi rechak xc'ula'taka' jtojb'lak y ri jtojb'lak ri' jcojic jk'ijak jwi'lak cristian. ");
INSERT INTO uspNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Pero at cuando tasipaj jono kelen rechak yak ri wi' rajwax rechak, ma yol re jono cristian ri pur awichc'ulchi' ri nen xab'an. ");
INSERT INTO uspNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Jwi'li'li at, cuando tasipaj jono kelen re jun cristian ri wi' rajwax re, sipaj re chi mukukil y Kakaj Dios lecj ri tiiliw juntir chi mukukil, tijya' atojb'l, xche' Kakaj Jesús rechak. ");
INSERT INTO uspNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Kakaj Jesús xij chic rechak cristian: Atak cuando atch'a'wtak riq'ui Kakaj Dios ma b'antak chapca' trantak mak ajsolcopil jcayb'alak, rechak ri' mas tzi triltak tiwa'rtak chi ch'a'wem riq'ui Kakaj Dios lak sinagog y lak jxiquinltak c'ayb'l ri'ke rajak tiilsajtak jwi'lak cristian. Pero kes tz'etel tz'et tamb'ij chawechak chi xc'ula'taka' jtojb'lak. ");
INSERT INTO uspNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Pero at ma b'an jilonli. Cuando atch'a'w riq'ui Akaj Dios oquen laj awichoch, tz'apij apwert y ch'a'wen riq'ui Akaj Dios chi mukukil pi awic'an. Y Akaj Dios ri tiiliw ri tab'an chi mukukil, tijya' atojb'l. ");
INSERT INTO uspNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Y cuando atch'a'w riq'ui Kakaj Dios ta' tzi atke tijin chi jca'mulaj jb'ij mak yoloj ri ta' nen tichacuj chapca' trantak mak ri ta' tijcojtak Jyolj Kakaj Dios. Rechak cuando tich'a'wtak tike tijintak chi jca'mulaj jb'ij mak yoloj ri ta' nen tichacuj, ri' chijch'ol rechak cuando mas tich'a'wtak, masna tita'saj jyoljak. ");
INSERT INTO uspNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Atak ma b'an awechak chapca' trantak rechak jwi'l Akajak Dios cuando ajqui' chatz'onajtak re nen chawajak, re retamchak nen rajwax chawechak. ");
INSERT INTO uspNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Pero atak cuando chawajak atch'a'wtak riq'ui Kakaj Dios, ri' b'ijtak jilonri: At Kakaj Dios ri wat lecj, chi nimirsajti jcojic jk'ij ab'j. ");
INSERT INTO uspNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Petok atakon chib'ak juntir cristian. Y lawi' ri chawaj tab'an wich ulew, b'an jilon chapca' ri tab'an lecj. ");
INSERT INTO uspNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Ye' kaw nojel k'ij. ");
INSERT INTO uspNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Cuy kamac riq'ui mak etzltak no'j ri tikab'an chawch chapca' oj xkacuya' jmacak yak cristian ri xanowtak c'ax chike. ");
INSERT INTO uspNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Ma ye' luwar re man jb'ab'al etzl ojjtakchi'j chi jb'anic etzltak no'j. Cojacole' laj jk'ab', jwi'l xike at Kakaj Dios ri wi' nimlaj k'atb'itzij laj ak'b' chi takon chib'ak juntir ri wi'tak wich ulew pach lecj y xike at tinimirsaj mas ak'ij lajori y ni jun b'welt tican ye'saj jnimirsaj ak'ij. Jiloni'n, atche'tak. ");
INSERT INTO uspNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Y atak wi tacuytak jmac jun cristian ri tib'anow c'ax chawechak, Kakaj Dios lecj tijcuya' amacak. ");
INSERT INTO uspNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Pero atak wi ta' tacuytak jmac jun cristian ri tib'anow c'ax chawechak, Kakaj Dios ta' tijcuy amacak, xche' Kakaj Jesús rechak cristian. ");
INSERT INTO uspNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Kakaj Jesús xij chic rechak cristian: Atak cuando tab'antak ayun, ma b'antak chapca' b'is awchak chapca' trantak mak ajsolcopil jcayb'alak, rechak trantak chapca' b'is jwichak, ri'ke rajak tiilsajtak jwi'lak cristian chi tijini' trantak ayun. Pero kes tz'etel tz'et tamb'ij chawechak chi mak cristian li ta' jtojb'lak tijc'ultak riq'ui Kakaj Dios, ri jtojb'lak ri' tiilsajtak jwi'lak cristian. ");
INSERT INTO uspNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Pero at cuando tab'an ayun, ch'aj acayb'al y xa' ab' ");
INSERT INTO uspNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","pire ma' atilsaj jwi'lak cristian chi tijini' tab'an ayun, xike Kakaj Dios tieteman re chi tijini' tab'an ayun chi mukukil y re tijya' atojb'l, xche' Kakaj Jesús rechak. ");
INSERT INTO uspNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Kakaj Jesús xij chic rechak cristian: Ma mulb'a' ab'iomilak neri wich ulew jwi'l tike ran poc', tike ran pus y tioc mak alk'om chi ralk'ajc. ");
INSERT INTO uspNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Ri' mas tzi mulb'a' ab'iomilak riq'ui Kakaj Dios lecj, cla' ta' tran poc', ta' tran pus y ta' alk'om tioctak chi ralk'ajc. ");
INSERT INTO uspNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Lamas wi' ab'iomil, cla' tiwa'x awanm jwi'l ri' b'esal awanm chirij ab'iomil, xche' Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Kakaj Jesús xij chic rechak cristian: B'ak' awch ri' jun candil pire atio'jl, wi tzi b'ak' awch, juntir atio'jl wi' chi sak. ");
INSERT INTO uspNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Pero wi ta' tzi b'ak' awch juntir atio'jl wi' li uku'mal y wi acandil ri wi' re atio'jl chupul jk'ak'al, juntir atio'jl wi' li uku'mal, xche' Kakaj Jesús rechak. ");
INSERT INTO uspNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Kakaj Jesús xij chic rechak cristian: Ta' ni jonok ticwin chi chac riq'ui quib' patron li jun k'ij, jwi'l tina jxutna jun y tijlok'aj jun chic. Ticojon chiwch jun y ta' ticojon chiwch jun chic. Jun cristian ta' tijna' tran lawi' raj Kakaj Dios wi tib'e ranm chirij jb'iomil ri reke wich ulew, xche' Kakaj Jesús rechak. ");
INSERT INTO uspNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Kakaj Jesús xij chic rechak cristian: In tamb'ij chawechak chi mat octak il chirij nen tatijtak, nen tawuc'a'jajtak laj ac'aslemalak y mat octak il chirij awitz'ikak re tacojtak, jwi'l ac'aslemalak masna nim jk'ij chiwch ri tatijtak y atio'jlak masna nim jk'ij chiwch man itz'ik. ");
INSERT INTO uspNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Iltak nen mo yo'ltak mak tz'iquin ri tirupuptak lecj. Rechak ta' titiconantak y ta' tioch'ontak ni ta' tijc'oltak jwich jtico'nak laj jc'ujaak, ri' Kakaj Dios ri wi' lecj titzukuw rechak. Y atak masna nim ak'ijak chiwchak mak tz'iquin li. ");
INSERT INTO uspNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Y ta' ni jun chawechak ticwin chi jyo'rsaj rib' quib' uxib' or mas re jc'aslemal ri ye'l jwi'l Kakaj Dios jwi'lke tioc il chirij jc'aslemal. ");
INSERT INTO uspNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Mat octak il chirij awitz'ikak. Iltak nen mo jq'uiyic mak cutz'i'j re lak tza'l, rechak ta' tichacuntak y ta' tiquemowtak itz'ik. ");
INSERT INTO uspNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Pero in tamb'ij chawechak chi Salomón sub'laj kustaklaj itz'ik xcoj, pero ta' ni jono ritz'ik xcoj jilon chapca' mak kustaklaj cutz'i'j li. ");
INSERT INTO uspNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Wi jilon jwikic mak woron li tran Kakaj Dios, ri lajori wi'tak lak tza'l y chwek' tic'atsajtak li jorn, kes tz'etel tz'et atjwika'taka' atak ri ta' mas cub'ul ach'olak chirij Kakaj Dios. ");
INSERT INTO uspNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Jwi'li'li atak mat octak il, ma b'ijtak: ¿Nen tikatij re kaw? ¿Nen tikatij re kuc'a'? ¿Nen tikacoj pire kitz'ik? mat che'tak. ");
INSERT INTO uspNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Ri' juntir mak kelen li ri tioctak il mak cristian chirij ri ta' tijcojtak Jyolj Kakaj Dios, pero Kakaj Dios ri wi' lecj retami' chi juntir mak kelen li tichoconi' awi'lak. ");
INSERT INTO uspNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Pi jq'uexwach atoctak il chirij mak kelen li, ri' oquentak il chi jtoquic Kakaj Dios pire titakon chab'ak y b'antak lawi' raj Kakaj Dios tab'antak y juntir mak kelen li tiye'saji' chawechak. ");
INSERT INTO uspNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Mat octak il chi jchomorsaj nen tab'antak chwek', jwi'l man k'ij re chwek' wi' chiqui' jono c'ax. Nojel k'ij tita'saji' c'ax, xche' Kakaj Jesús rechak. ");
INSERT INTO uspNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Kakaj Jesús xij chic rechak cristian: Ma coj ayb'ak pi k'atb'itzij chirijak cristian chi jb'ij chi ta' tzi tijin trantak pire ta' tib'ansaj k'atb'itzij chawijak. ");
INSERT INTO uspNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Jwi'l Kakaj Dios trana' jk'atb'itzij chawijak chapca' jb'anic k'atb'itzij ri tab'antak chirijak cristian y la' man pajb'l ri tacojtak re cristian, ri' ticojsaj chawechak jwi'l Kakaj Dios. ");
INSERT INTO uspNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","At tawila' jun ra jxerc' che' laj jwich jun awech'elxic chic y at ta' awetam chi wi' jun jtemal ja laj awch. ");
INSERT INTO uspNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","At tab'ij re: Nampuchna, wesajna jun ra jxerc' che' ri wi' laj awch, atche' re. Y at wi' jun jtemal ja laj awch. ");
INSERT INTO uspNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","At ajsolcopil acayb'al. Esajna nab'e man jtemal ja ri wi' laj awch, ajruc're' tijna' tawil man ra jxerc' che' ri wi' laj jwich jun awech'elxic chic. ");
INSERT INTO uspNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Lawi' ri tosol pire Kakaj Dios ma ye'tak re mak cristian ri ta' tzi jno'jak ri trantak chapca' trantak mak tz'i', jwi'l mak tz'i' tipe chawijak y atjti'tak, trantak c'ax chawechak. Y ma ye'tak mak kustaklaj ab'aj ri jb'ij perla re mak cristian ri trantak chapca' trantak mak aak, jwi'l tike jyak'tak la' rakanak, xche' Kakaj Jesús rechak. ");
INSERT INTO uspNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Kakaj Jesús xij chic rechak cristian: Tz'onajtak re Kakaj Dios nen chawajak y re tijya' chawechak. Toctak y tata'taka'n. Ch'a'wentak chi' pwert y titeb'aji' ja chawchak. ");
INSERT INTO uspNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Jwi'l nen titz'onin re Kakaj Dios nen raj, tiye'saji' re y nen titocow, tijta'n y nen tich'a'w chi' pwert, titeb'aji' ja chiwch. ");
INSERT INTO uspNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Ta' ni jono chawechak cuando tijtz'onaj cuxlanwa jc'ajol, tijye' ab'aj re chi tijem. ");
INSERT INTO uspNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Ni ta' tijye' jun cumatz re chi tijem cuando tijtz'onaj car. ");
INSERT INTO uspNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Atak, onque ta' tzi ano'jak, awetamaki' taye'tak tzitaklaj kelen re awalc'walak chi tijem. Y ri'tic'u chic Kakaj Dios lecj, ma' tijye' kustaklaj sipan rechak yak ri titz'onintak re. ");
INSERT INTO uspNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","B'antak rechak cristian chapca' chawajak trantak chawechak jwi'l jilon tijb'ij Jpixb' Kakaj Dios y jilon xcan jtz'ib'ajtak yak ajk'asaltak Jyolj Kakaj Dios, xche' Kakaj Jesús rechak. ");
INSERT INTO uspNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Kakaj Jesús xij chic rechak cristian: Oquentak la' man nuch' jwich pwert jwi'l man nim jwich pwert y man b'e nim jwich ji' tib'e li man luwar re tijb'i c'ax y sub'laj cristian tib'etak cla'. ");
INSERT INTO uspNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Pero man nuch' jwich pwert y man b'e ri tib'e li tzilaj c'aslemal riq'ui Kakaj Dios lecj ri ta' jq'uisic masna nuch' jwich y ta' mas cristian tita'wtak re, xche' Kakaj Jesús rechak. ");
INSERT INTO uspNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Kakaj Jesús xij chic rechak cristian: Tike acwentij ayb'ak chiwchak mak jo'staklaj cristian, rechak tijcoj rib'ak pi ajk'asaltak Jyolj Kakaj Dios, pero ta' tz'et, trantak chapca' carner rilicak pero ranmak jilon chapca' mak c'a'ntaklaj utiw. ");
INSERT INTO uspNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Atak chirijke ri nen trantak laj jc'aslemalak tach'ob'tak, jwi'l ta' q'uix tijye' uva pire jwich, ni ta' q'uixwok' tijye' higo pire jwich. ");
INSERT INTO uspNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Juntir tzitaklaj che', tziyi' jwich tijye'tak y juntir mak che' ri ta' tzi, ta' tzi jwich tijye'tak. ");
INSERT INTO uspNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Ta' ni jono tzilaj che' tijye' jwich ri ta' tzi y ta' ni jono che' ri ta' tzi tijye' jwich ri tzi. ");
INSERT INTO uspNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Juntir mak che' ri ta' tzi tiwichintak, tic'ursajtaka'n y tit'ojsajtaka' li k'ak'. ");
INSERT INTO uspNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Jwi'li'li atak chirijke ri nen trantak mak cristian li tach'ob'tak nen jb'anicak, xche' Kakaj Jesús rechak. ");
INSERT INTO uspNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Kakaj Jesús xij chic rechak cristian: Ma' juntir ta' yak ri tib'intak Wajawl chwe, tioctak laj jk'ab' Inkaj Dios pire titakon chib'ak, xike tioctak laj jk'ab' Inkaj Dios yak ri tib'anowtak lawi' raj Inkaj ri wi' lecj. ");
INSERT INTO uspNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Cuando titaw q'uisb'itak k'ij re jwich k'ijsak sub'laj cristian tib'intak chwe, Wajawl oj xkak'asaji' Jyolj Kakaj Dios laj ab'j y laj ab'j xkesajb'i mak etzl y xkab'ana' sub'laj c'utb'i jcwinel Kakaj Dios laj ab'j, tiche'tak chwe. ");
INSERT INTO uspNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Pero in tamb'ij rechak: Ta' ch'ob'ol awchak inwi'l. ¡Elantakb'i chinwch ajb'analtak etzltak no'j! inche' rechak, xche' Kakaj Jesús rechak cristian. ");
INSERT INTO uspNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Kakaj Jesús xij chic rechak cristian: Jun cristian ri tijta inyolj y tran lawi' tamb'ij, niq'ui' riq'ui jun cristian tzi jchomorsa'n ri xan richoch chib' man ab'aj. ");
INSERT INTO uspNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Cuando xpe nimlaj k'alaj, xq'uiych sub'laj ja', xpe sub'laj tew y xk'osaj rib' wich jxe' man ja li, pero ta' xtzaak jwi'l cowi' wa'l chib' man ab'aj. ");
INSERT INTO uspNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Pero jun cristian ri tijta inyolj y ta' tran lawi' ri tamb'ij, niq'ui' riq'uil jun sons ri b'a saneb'ke xan richoch. ");
INSERT INTO uspNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Cuando xan jun nimlaj k'alaj, xq'uiych sub'laj ja', xpe sub'laj tew y xk'osaj rib' wich jxe' man ja li y man ja li xtzaak y xyojmajc, xche' Kakaj Jesús rechak cristian. ");
INSERT INTO uspNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Cuando xmay jb'ij Kakaj Jesús jilonli, juntir cristian sub'laj xsaach jch'olak chi jtaic jtijonc, ");
INSERT INTO uspNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","jwi'l wi' jtakon chi tijonc. Ma' ji'ta'lon chapca' titijontak yak ajtijoltak cristian re Jpixb' Kakaj Dios. ");
INSERT INTO uspNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Cuando xkejch Kakaj Jesús b'a witz, sub'laj cristian tixamtak chirij. ");
INSERT INTO uspNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Xpe jun sic' winak ri wi' yajel chirij ri jb'ij lepra, xjutun chiwch Kakaj Jesús y xxucar chiwch, xij: Kaj, wi jilon chawaj, atcwini' chi intzib'saj, xche' re. ");
INSERT INTO uspNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Xpe Kakaj Jesús, xye' jk'ab' chib', xij re: Chwaji'n, cattzib'ok, xche' re. Y laj or xel man yajel chirij sic' winak y xtzib'c. ");
INSERT INTO uspNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Kakaj Jesús xij chic re: Ta impuch, ma yolow re jono cristian nen xattzib'sanc. Jat c'utta chiwch man ajc'amal jb'eak cristian riq'ui Kakaj Dios y c'amb'i man sipan pire tib'e asuje' re Kakaj Dios chapca' tijb'ij Jpixb' Kakaj Dios, ri' li c'utb'ire chiwchak juntir cristian chi xattzib'i'n, xche' Kakaj Jesús re. ");
INSERT INTO uspNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Cuando xoc Kakaj Jesús Capernaúm, xpe jun jb'ab'alak mak soldad xjutun chijc'ulel Kakaj Jesús y xtz'onaj tok'ob' re: ");
INSERT INTO uspNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Kaj, jun wajchac wi' laj wichoch kesal laj jsoc siquirnak juntir jtio'jl y sub'laj c'ax tijin tijtij, xche' re. ");
INSERT INTO uspNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Kakaj Jesús xij re: Imb'i' chi jtzib'sajc, xche' re. ");
INSERT INTO uspNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Xpe man jb'ab'alak mak soldad, xij re: Kaj, in ta' tic'ular pi we atb'e oc laj wichoch, xike tab'ijb'i chi titzib' wajchac, titzib'i'n. ");
INSERT INTO uspNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Jwi'l in wi' chiqui' nen titakon chimb' y wi' laj ink'b' intakon chib'ak mak soldad. Cuando tamb'ij re jonok chi tib'ec, tib'i'n y cuando tamb'ij chic re jonok chi tipetc, tipeti'n y cuando tamb'ij re jun wajchac nen chwaj tran, trana'n, xche' re Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Cuando xta Kakaj Jesús xijsaj re jilonli, xsaach jch'ol chi jtaic y xij rechak yak ri tixamtak chirij: Kes tz'etel tz'et tamb'ij chawechak chi ta' ni jono cristian ta'l inwi'l xo'lak yak rijajl Israel jilon jcub'ar jch'ol chwij chapca' winak ri. ");
INSERT INTO uspNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Tamb'ij chawechak chi sub'laj cristian tipetak laj jsuc'lal lamas tielch k'ij y wi' mas tipetak laj jsuc'lal lamas tikej k'ij, tib'e wa'xtak pi jpach Abraham, Isaac y Jacob li man luwar lamas titakon Kakaj Dios lecj nic' riq'uil ticub'artak chi wic'. ");
INSERT INTO uspNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Pero mak ri roj tioctak lamas titakon Kakaj Dios lecj tina t'ojsajtaknab'i li uku'mal chinajb'i re Kakaj Dios, cla' tib'e rok'b'ej rib'ak y tijkuch'uch'uj reeak, xche' Kakaj Jesús rechak cristian. ");
INSERT INTO uspNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Y xij chic re man jb'ab'alak mak soldad: Jat laj awichoch y jilon tib'an chapca' chawaj jwi'l xacoja' chi incwini' chi jtzib'saj, xche' re. Y laj or xtzib' man ajchac. ");
INSERT INTO uspNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Kakaj Jesús xe' laj richoch Pedro y xe' jte' sic' anm ri jji' Pedro kesal laj jsoc jwi'l k'ak'. ");
INSERT INTO uspNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Xpe Kakaj Jesús, xchap chi jk'ab' sic' anm y laj or xel man k'ak' chirij, xb'iitc y xoc chi jtzukic Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Cuando xoc may, xpetak cristian xc'amtakb'i sub'laj cristian riq'ui Kakaj Jesús ri wi' etzl laj ranmak. Y re la'ke jun chi yoloj xij, xresaj juntir mak etzl ri wi' laj ranmak y xtzib'saj juntir yak cristian ri yajtak. ");
INSERT INTO uspNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Jilonli xan pire xtaw chiwch ri xij Isaías ri ajk'asal Jyolj Kakaj Dios, cuando xij jilonri: Re xc'ama'b'i kayaj, xche'. ");
INSERT INTO uspNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Kakaj Jesús cuando xril chi sub'laj cristian tijin tijmulb'a' rib'ak chirij, xij rechak yak ajtijol rib'ak chirij chi tik'axtak ch'akap re nimlaj alagun. ");
INSERT INTO uspNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Xpe jun ajtijol cristian re Jpixb' Kakaj Dios, xjutun chijc'ulel Kakaj Jesús y xij re: Ajtijonl, in chwaj imb'e chawij lamas atb'e'w, xche' re. ");
INSERT INTO uspNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Kakaj Jesús xij re: Mak utiw wi' jjulak y mak tz'iquin wi' jsocak, pero Jc'ajol Kakaj Dios ri xwux pi cristianil ta' lamas tijtz'eb'a'wi' jb'a, xche' re. ");
INSERT INTO uspNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Xpe jun chic rechak yak ri xamtak, xij re: Wajawl, ye' luwar chwe tib'e immuke'na inkaj nab'e, xche' re. ");
INSERT INTO uspNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Xpe Kakaj Jesús, xij re: Jo' chwij, can ye'tak mak camnak jmuke'na jcamnakak, xche' re. ");
INSERT INTO uspNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Kakaj Jesús xjaw li barc y xpe yak ajtijol rib'ak chirij xamb'ertakb'i chirij. ");
INSERT INTO uspNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Cuando b'esaltak b'a nimlaj alagun etke xpe jun quiek'ek' tew b'a ja', xritz'b'ej man ja', xoc mak retumb re ja' li man barc y Kakaj Jesús tijin chi waraj. ");
INSERT INTO uspNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Xpetak yak ajtijol rib'ak chirij, xe' jb'ite'tak y xijtak re: ¡Kajawl, cojacole', ojjik'i' jwi'l tijin tikej man barc ralaj ja'! xche'tak re. ");
INSERT INTO uspNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Kakaj Jesús xij rechak: Nen chac mas titzaak ach'olak, atak ta' kes cub'ul ach'olak chwij, xche' rechak. Cuando xijmaj jilonli jwi'l, xb'iitc y xk'el man quiek'ek' tew y mak retumb re man nimlaj alagun y laj or xmay juntir. ");
INSERT INTO uspNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Rechak sub'laj xsaach jch'olak chi rilic, xoctak chi jtz'onaj chirib'il rib'ak: ¿Nen chiqui' jcholajl winak ri, chi ji' quiek'ek' tew pach mak retumb re nimlaj alagun ticojontak chiwch? xche'tak. ");
INSERT INTO uspNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Cuando xtaw Kakaj Jesús ch'akap re nimlaj alagun li man luwar ri jb'ij Gadara, xpetak quib' winak ri wi' etzl laj ranmak. Xeltakch li camposant y xjutuntak chijc'ulel Kakaj Jesús. Rechak sub'laj c'a'ntak, jwi'li'li ta' ni jono cristian tik'ax la' man b'e li. ");
INSERT INTO uspNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Xpe mak etzl, sub'laj xch'ejejtak, xtz'onajtak re Kakaj Jesús: ¿Nen chawaj chike at Jc'ajol Kakaj Dios? At xatpet chi kach'u'jursaj y ajqui' chi taw k'ij, xche'tak re Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Nakaj re man luwar li lamas wi'tak, wi' sub'laj aak tijin jyuk'icak. ");
INSERT INTO uspNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Xpetak mak etzl, xtz'onajtak sub'laj tok'ob' re Kakaj Jesús: Wi ojawesajb'i neri, cojatake'b'i riq'uilak mak aak, xche'tak re. ");
INSERT INTO uspNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Kakaj Jesús xij rechak: Jattak, xche' rechak. Mak etzl xeltakb'i laj ranmak mak winak y xe' octak laj jtio'jlak mak aak y mak aak li xmajtak jol wich witz y xkejtakb'i pi xulan asta xe' tzaaktak li nimlaj alagun, cla' xjik'tak. ");
INSERT INTO uspNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Mak ajyuk'ultak aak xelmajtak, xe'tak li tilmit chi jyolic ri xaanc y nen xansaj rechak mak winak ri wi' etzl laj ranmak. ");
INSERT INTO uspNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Juntir mak cristian ri wi'tak li tilmit xe'tak lamas wi' Kakaj Jesús. Cuando xriltak, xtz'onajtak sub'laj tok'ob' re Kakaj Jesús chi tielb'i laj jtilmitak. ");
INSERT INTO uspNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Kakaj Jesús xjaw chicb'i li barc, xk'ax ch'akap re nimlaj alagun y xtaw laj jtilmit. ");
INSERT INTO uspNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Y cla' xpetak nic'j cristian xc'amtakch jun winak riq'ui Kakaj Jesús b'a jun ch'atum che', sic' winak li, siquirnak juntir jtio'jl. Cuando Kakaj Jesús xril chi cub'uli' jch'olak chirij, xij re sic' winak ri yaj: Walc'wal, coj jcowil awanm, amac xcuymaji'n, xche' re. ");
INSERT INTO uspNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Xpetak jujun ajtijoltak cristian re Jpixb' Kakaj Dios, xoctak chi yoloj chirijil Kakaj Jesús, xijtak: Man winak ri, tijin tijcoj rib' pi Kakaj Dios, xche'tak. ");
INSERT INTO uspNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Pero Kakaj Jesús retami' nen tijin tijb'ijtak chirijil, xtz'onaj rechak: ¿Nen chac atak tijin tab'antak etzltak chomorsa'n? ");
INSERT INTO uspNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","¿Lac'umas wi' ri mas c'ax jb'ij, amac xcuymaji'n o ri' mas c'ax jb'ij, b'iiten y wo'coten? ");
INSERT INTO uspNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Pero in tanc'ut chawchak chi Jc'ajol Kakaj Dios ri xwux pi cristianil wi' k'atb'itzij laj jk'ab' chi jcuyic mac neri wich ulew, xche' rechak. Ajruc're' xij chic re sic' winak ri siquirnak jtio'jl: B'iiten, c'amb'i ach'atum che' y jat laj awichoch, xche' re. ");
INSERT INTO uspNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Sic' winak ri yaj xb'iitc y xe' laj richoch. ");
INSERT INTO uspNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Cuando xriltak mak cristian chi jilonli xaanc, sub'laj xsaach jch'olak y xnimirsajtak jk'ij Kakaj Dios jwi'l xye' jcwinel Kakaj Jesús chi jb'anic jilonli. ");
INSERT INTO uspNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Kakaj Jesús xelb'i cla', cuando b'esalc, xrilb'i jun winak ri jb'ij Mateo, cub'ul chi' mex lamas titojsaj alcabar y Kakaj Jesús xij re: Jo' chwij, xche' re. Mateo xwa'rc y xe' chirij Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Cuando Kakaj Jesús tijin chi wic' laj richoch Mateo, sub'laj q'ui ajtz'onaltak alcabar y sub'laj q'ui ajmacb' xtawtak chi wic' riq'ui Kakaj Jesús pach yak ajtijol rib'ak chirij. ");
INSERT INTO uspNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Mak fariseo, cuando xriltak jilonli, xtz'onajtak rechak yak ajtijol rib'ak chirij Kakaj Jesucristo: ¿Nen chac ajtijol awechak tijin tiwi'n chijxo'lak mak ajtz'onaltak alcabar pach mak ajmacb'? xche'tak rechak. ");
INSERT INTO uspNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Cuando xta Kakaj Jesús chi jilonli xijsaj rechak yak ajtijol rib'ak chirij, xij rechak mak fariseo: Ta' rajwax ajcun rechak yak cristian ri ta' yajtak, ri' rajwax ajcun pi rechak yak ri yajtak. ");
INSERT INTO uspNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Jattak y chomorsajtak nen tielwi' Jyolj Kakaj Dios ri tijb'ij jilonri: In ri' chwaj tawiltak c'ur jwich jun cristian chiwch tasujtak sipan chwe, tiche'. Jwi'l in ta' ximpe chi jtoquic yak cristian ri suc'ul ranmak chiwch Kakaj Dios, in ri' ximpe chi jtoquic yak ajmacb', xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Xpetak yak ajtijol rib'ak chirij Juan Ajb'anal Ja'tiox, xtawtak riq'ui Kakaj Jesús xtz'onajtak re: ¿Nen chac yak ajtijol rib'ak chawij ta' trantak ayun chapca' tikab'an oj pach mak fariseo? xche'tak re. ");
INSERT INTO uspNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Kakaj Jesús xij rechak: Yak cristian ri b'il rechak chi tib'etak li jun tz'am, ta' tijna' tib'isontak cuando ajwi' man c'ojol winak chijxo'lak ri tic'uli'yc. Pero cuando titaw k'ij tic'amsajb'i man c'ojol winak chiwchak, ajruc're' trantak ayun. ");
INSERT INTO uspNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Ta' ni jono cristian tijc'ojaj jun tzay itz'ik la' jun q'uer aac' c'ojb'l jwi'l man aac' c'ojb'l tijc'ola' rib' y tike niman mas man rech'e'l re man tzay itz'ik. ");
INSERT INTO uspNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Ni ta' tijna' tiye'saj aac' vin lak tzaytak nejb' ri b'anal la' tz'um, jwi'l man aac' vin tijrech'a' mak tzaytak nejb' ri b'anal la' tz'um, jilonli titixi' man aac' vin y trana' c'ax mak nejb'. Jwi'li'li man aac' vin rajwaxi' lak aac'tak nejb' ri b'anal la' tz'um tiye'sajwi', jilonli ta' ni jono rechak tran c'ax, xche' Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Aj tijini' Kakaj Jesús chi yoloj riq'uilak yak ajtijol rib'ak chirij Juan Ajb'anal Ja'tiox cuando xtaw jun jb'ab'alak yak rijajl Israel y xxucb'a' rib' chiwch y xij re: In rab'in ajri' xcamc, pero wi atb'e chi rilic y taye' ak'b' chib', tiyo'r chiqui'n, xche' re. ");
INSERT INTO uspNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Kakaj Jesús xwa'rc, xe'tak laj richoch winak li pach yak ajtijol rib'ak chirij. ");
INSERT INTO uspNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","B'esaltak riq'ui man winak li xpe jun anm yaj ri wi'chak cab'lajuj (12) junab' chi ticar chi coc'xo'lke tikej man ch'ojnic chirij, xjutun chirij Kakaj Jesús y xchap raquitz chak'chi' ritz'ik ");
INSERT INTO uspNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","jwi'l xchomorsaj laj ranm: Riq'uilke wi xincwin chi jchapic raquitz ritz'ik intzib'i'n, xche'. ");
INSERT INTO uspNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Pero Kakaj Jesús xsolcopij rib' xril sic' anm li, xij re: At inrab'in, coj jcowil awanm, xattzib'i' jwi'l xcub'ar ach'ol chwij, xche' re. Y laj or xtzib' sic' anm. ");
INSERT INTO uspNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Cuando xtaw Kakaj Jesús laj richoch man jb'ab'alak yak rijajl Israel xril chi wi'takchak mak ajok'saltak su' y cristian tijin tijcamsaj rib'ak chi ok'ej. ");
INSERT INTO uspNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Xpe Kakaj Jesús, xij rechak: Elantakb'i neri, man ra anm ta' camnak, warajke tran, xche' rechak. Mak cristian xtze'jtak jwich Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Pero re xresajtakb'i mak cristian chuchja, ajruc're' xoc lamas wi' man ra anm, xchap chi jk'ab' y man ra anm xwa'rc. ");
INSERT INTO uspNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Lak juntir luwar ri wi' chirij man luwar li xelwi' jtaquil nen xan Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Cuando xelb'i Kakaj Jesús cla' xamb'ertakb'i quib' moy chirij, cow tich'ejejtak, tijb'ijtak: ¡Il c'ur kawch at Jc'ajol David! xche'tak re. ");
INSERT INTO uspNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Cuando xoc Kakaj Jesús la ja xpetak yak moy xjutuntak chijc'ulel, xpe Kakaj Jesús xtz'onaj rechak: ¿Ton acoja'taka' chi incwini' chi atzib'sajcak? xche' rechak. Rechak xijtak: Ticub'ari' kach'ol, Kajawl, xche'tak re. ");
INSERT INTO uspNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Xpe Kakaj Jesús, xchap b'ak' jwichak y xij rechak: Jilon tib'ansaj chapca' jcub'arb' ach'olak chwij, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Jilonli xna'tuntak yak moy. Xpe Kakaj Jesús, sub'laj cow jch'ab'ejcak xan, xij rechak: Ma yolowtak pire ma'qui' nen jonok tieteman re, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Ajri'ke xeltakb'i riq'ui Kakaj Jesús laj or xoctak chi jyolic rechak cristian lak juntir mak luwar li, ri xan Kakaj Jesús rechak. ");
INSERT INTO uspNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Cuando xeltakb'i yak moy ri xtzib'saj b'ak' jwichak, xpetak nic'j cristian chic xc'amtakb'i jun mem riq'ui Kakaj Jesús. Y sic' mem li wi' etzl laj ranm. ");
INSERT INTO uspNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Cuando Kakaj Jesús xresaj man etzl laj ranm sic' mem, ajruc're' xoc chi yoloj. Mak cristian sub'laj xsaach jch'olak, xijtak chirib'il rib'ak: Ni jun b'welt ilan kawi'l neri Israel jilonli, xche'tak. ");
INSERT INTO uspNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Pero mak fariseo xijtak: Man winak li tresaji' mak etzl ri wi' laj ranmak cristian la'ke jcwinel man jb'ab'al etzl, xche'tak. ");
INSERT INTO uspNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Kakaj Jesús xwo'cot lak juntir tilmit y lak tra luwar. Xoc lak jsinagogak yak rijajl Israel y xij tzilaj jtaquil rechak cristian chirij jtakon Kakaj Dios chib'ak cristian y xtzib'saj juntir cristian ri yajtak. ");
INSERT INTO uspNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Cuando Kakaj Jesús xril jwichak sub'laj q'ui cristian ri wi'tak cla', xril c'ur jwichak jwi'l tijin tijtijtak c'ax y ta' nen tiilb'en rechak chapca' jun k'at carner cuando ta' ajyuk' rechak. ");
INSERT INTO uspNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Xij rechak yak ajtijol rib'ak chirij: Sub'laj nim man tico'n toquem raj jwich, pero quib' uxib'ke mocom. ");
INSERT INTO uspNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Atak tz'onajtak tok'ob' re Rajw tico'n chi tijtakch mocom chi jtoquic jwichak mak tico'n, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Kakaj Jesús xmulb'a' yak cab'lajuj (12) ajtijol rib'ak chirij. Xye' cwinel rechak chi resaj mak etzl ri wi' laj ranmak cristian y chi jtzib'saj cristian re juntir jaljojtak yajel. ");
INSERT INTO uspNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Ri' ri jb'ijak yak cab'lajuj (12) tako'n, nab'e rechak ri' Simón ri tib'ijsaj Pedro re pach jk'un ri jb'ij Andrés, Santiago pach jk'un ri jb'ij Juan ri yak jc'ajol Zebedeo, ");
INSERT INTO uspNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Felipe, Bartolomé, Tomás, Mateo ri ajtz'onal alcabar, Santiago ri jc'ajol Alfeo, Tadeo, ");
INSERT INTO uspNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simón ri tib'ijsaj Zelote re y Judas Iscariote ri xjachow re Kakaj Jesús pi camic. ");
INSERT INTO uspNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Kakaj Jesús xtakb'i yak cab'lajuj (12) ajtijol rib'ak chirij ri xcha'w y xij rechak nen rajwax trantak: Mat b'etak riq'uilak yak ma' rijajl ta' Israel y mat octak laj jtilmitak yak aj Samaria. ");
INSERT INTO uspNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Ri' mas tzi, atb'etak riq'uilak yak rijajl Israel ri chapca' mak carner ri sache'ltak. ");
INSERT INTO uspNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Juntir luwar lamas attawtak, b'ijtak rechak: Raquitzchak raj tijchol takon Kakaj Dios chib'ak cristian, atche'tak rechak. ");
INSERT INTO uspNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Tzib'sajtak yak cristian ri yajtak, c'astasajtak jwichak yak camnakib' laj jcamnaklak, tzib'sajtak yak ri wi' yajel chirijak ri jb'ij lepra y esajtak mak etzl ri wi' laj ranmak cristian. Atak xacochajtake acwinelak chi jb'anic juntir li, ta' luwar tatz'onaj atojb'lak cuando tatzib'sajtak cristian. ");
INSERT INTO uspNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Ta' tac'amtakb'i oro, ni plata, ni pwak b'anal la' cobre, ");
INSERT INTO uspNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","ni chim pire tichocon awi'lak laj ab'eak, ni ta' c'amtakb'i jun túnica chic, ni carot y ta' xajab' tac'amtakb'ic, jwi'l jun mocom pi jcholajli' tiye'saj kelen re. ");
INSERT INTO uspNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Cuando attawtak li jono tilmit o li jono luwar, toctak jono cristian ri tic'ular pire attawtak riq'uil. Wa'xentak laj richoch ajri' ateltakb'i cla' cuando ateltakb'i li man tilmit o li man luwar li. ");
INSERT INTO uspNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Cuando atoctak la ja c'amtak rutzil jwichak yak ri wi'tak la ja y b'ijtak rechak: Atak juntir ri watak la ja neri, wa'xok utzil laj awanmak, atche'tak rechak. ");
INSERT INTO uspNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Wi yak rajw ja lamas attawtakwi' tic'ulari' pi rechak atwa'xtak riq'uilak, ticani' utzil riq'uilak ri chawajak tiye'saj rechak y wi mita' tic'ular pi rechak atwa'xtak riq'uilak ta' tican utzil riq'uilak ri chawajak tiye'saj rechak, tik'aj chiqui'ch aac'lak. ");
INSERT INTO uspNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Y wi wi' jonok ta' atjc'ultak y wi ta' rajak tijtatak ayoljak, elantakb'i li man ja li o li man tilmit li, can totojtak man pok ri wi' la' awakanak. ");
INSERT INTO uspNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Kes tz'etel tz'et tamb'ij chawechak cuando titaw k'ij tran jk'atb'itzij Kakaj Dios chib'ak juntir cristian wich ulew, mak cristian li masna c'ax k'atb'itzij tib'ansaj chib'ak chiwch ri xaan chib'ak mak cristian aj Sodoma y aj Gomorra, xche' Kakaj Jesús rechak. ");
INSERT INTO uspNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Kakaj Jesús xij chic rechak: In atintaktakb'i lak jaljojtak luwar, tamb'an chawechak chapca' jtakic carner chijxo'lak mak utiw. Jwi'li'li coj ano'jak chi jchajaj ayb'ak chapca' trantak mak cumatz y b'antak chapca' trantak mak tra ut ri ta' trantak c'ax. ");
INSERT INTO uspNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Tike acwentij ayb'ak chiwchak mak cristian jwi'l atna jachsajtakna laj jk'ab'ak mak comontak jb'ab'alak yak rijajl Israel y atna sec'sajtakna lak sinagog. ");
INSERT INTO uspNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Y inwi'lke in atna jachsajtakna laj jk'ab'ak mak jb'ab'altak k'atb'itzij y mak rey jilonli tijna' tab'ijtak rechak y rechak yak ma' rijajl ta' Israel chi tz'eti' ri ilan y tal awi'lak chwij. ");
INSERT INTO uspNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Pero cuando atjachsajtak laj jk'ab'ak mak jb'ab'altak k'atb'itzij li, mat octak il chi jchomorsaj nen tab'ijtak o nen tab'antak chi yoloj jwi'l cuando titaw or atch'a'wtak, Kakaj Diosi' tiye'w yoloj chawechak nen tab'ijtak. ");
INSERT INTO uspNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Ma' atak ta' ri atch'a'wtak, ri' Lok'laj Jsantil Akajak Dios ri wi' laj awanmak tich'a'wc. ");
INSERT INTO uspNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Jun cristian tina jachna jk'un ratzak pi camic y jun chuchkajw tina jachna ralc'walak pi camic y yak alc'walixelb' tina jb'itna rib'ak chirij jkaj jchuchak y tina jachtakna pi camic. ");
INSERT INTO uspNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Juntir cristian ri b'esal ranmak chirijak mak etzltak no'j atna retzelb'ejtakna y atna jcontrijtakna inwi'lke in, pero nen ta' tijquib'aj ranm chwij asta ticamc, ticolmaji' laj jk'ab' jmac. ");
INSERT INTO uspNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Cuando tib'ansaj c'ax chawechak li jun tilmit elmajentak, jattak chic li jun jalan tilmit chic. Kes tz'etel tz'et tamb'ij chawechak chi atak ajqui' chatcwintak chi jb'ij Jyolj Kakaj Dios rechak cristian lak juntir jtilmitak yak rijajl Israel cuando tipe chic Jc'ajol Kakaj Dios ri xwux pi cristianil. ");
INSERT INTO uspNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Ni jono ajtijol rib' mas jno'j chiwch ajtijol re y ta' ni jono mocom mas jno'j chiwch jpatron. ");
INSERT INTO uspNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Jun ajtijol rib' trana' pi re xike tran lawi' ri tran ajtijol re y man mocom trana' pi re xike tran lawi' tran jpatron. Wi man rajw ja tib'ijsaji' chi jb'ab'al etzli'n, ¿nen chiqui' tib'ijsaj rechak yak ralc'wal? xche' Kakaj Jesús rechak. ");
INSERT INTO uspNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Kakaj Jesús xij chic rechak: Atak mi tzaak ach'olak chiwchak yak ri tib'anowtak c'ax chawechak, jwi'l ta' ni jono kelen ri tib'ansaj chi mukukil miti tina elna chi sakil. ");
INSERT INTO uspNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Lawi' ri tamb'ij chawechak chi mukukil, b'ijtak chi sakil y lawi' ri tamb'ij chawechak pi jasjail, ch'ejejentak chi jb'ij b'ak ja. ");
INSERT INTO uspNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Mi tzaak ach'olak chiwchak mak cristian ri ticamsan atio'jlak, jwi'l rechak ta' ticwintak chi jcamsaj awanmak. Ri' tzaak ach'olak chiwch jun ri ticwin tijt'oj atio'jlak pach awanmak li man luwar re tijb'i c'ax. ");
INSERT INTO uspNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Quib' chi nuch' tz'iquin tic'ayaji' chi quib' centaw, pero ta' ni jono rechak titzaak lak ulew wi ta' tijye' luwar Kakaj Dios ");
INSERT INTO uspNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","y jilon rusumal áb'ak ajlali' jwi'l. ");
INSERT INTO uspNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Jwi'li'li mi tzaak ach'olak, atak masna atlok'ajtak chiwchak sub'laj q'ui tz'iquin, xche' Kakaj Jesús rechak. ");
INSERT INTO uspNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Kakaj Jesús xij chic rechak: Nen jonok tib'in chiwchak cristian chi tijch'ob'a' inwch, in tamb'iji' re Inkaj ri wi' lecj chi tz'eti' tanch'ob'a' jwich. ");
INSERT INTO uspNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Pero nen jonok ta' raj tijb'ij chiwchak cristian chi tijch'ob'a' inwch, in ta' tamb'ij re Inkaj ri wi' lecj chi tanch'ob'a' jwich, xche' Kakaj Jesús rechak. ");
INSERT INTO uspNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Kakaj Jesús xij chic rechak: Ma b'ij atak chi inwi'lke in tiwa'x utzil chijxo'lak cristian. Jwi'l inwi'lke in tipe ch'o'j chijxo'lak cristian. ");
INSERT INTO uspNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Y inwi'lke in jun winak tijcontrij jkaj y jun anm tijcontrij jchuch y jun alib'xel tijcontrij ralb'. ");
INSERT INTO uspNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Jilonli yak ri ticontrin rechak cristian, ri' yak rech'elxicak. ");
INSERT INTO uspNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Nen mas tijlok'aj jkaj o jchuch chinwch in, ta' tic'ular tioc pi we. Nen mas tijlok'aj jc'ajol o jrab'in chinwch in, ta' tic'ular tioc pi we. ");
INSERT INTO uspNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Nen jono cristian ta' raj tijtij c'ax laj jc'aslemal y tixamb'er chwij, ta' tic'ular tioc pi we. ");
INSERT INTO uspNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Nen jono cristian ta' raj tijye' rib' pi camic jwi'lke tran lawi' raj Kakaj Dios tran, tisaachi' jwich, pero nen tijye' rib' pi camic inwi'l in, ticolmaji'n. ");
INSERT INTO uspNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Nen atc'uluwtak, ini' injc'ultak y nen inc'uluw in, ri' tijc'ul ri intakowinakch. ");
INSERT INTO uspNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Y nen tic'uluw re jun ajk'asal Jyolj Kakaj Dios tijc'ula' re chapca' jq'uixel ri tiye'saj re jun ajk'asal Jyolj Kakaj Dios chirij ri b'anal jwi'l y nen tic'uluw re jun cristian ri suc'ul ranm chiwch Kakaj Dios, tijc'ula' re chapca' jq'uixel ri tiye'saj re jun cristian ri suc'ul ranm chiwch Kakaj Dios chirij ri b'anal jwi'l. ");
INSERT INTO uspNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Nen jonok tijye' jun vas joron re jun cristian jwi'lke ajtijol rib'i' chwij onque ta' nim jk'ij, kes tz'et tamb'ij chawechak chi tijc'ula' jq'uixel, xche' Kakaj Jesús rechak. ");
INSERT INTO uspNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Cuando Kakaj Jesús xq'uis jye'ic jno'jak yak cab'lajuj (12) ajtijol rib'ak chirij, xelb'i cla' y xe' chi jtijojcak cristian re Jyolj Kakaj Dios li mak tilmit re Galilea. ");
INSERT INTO uspNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Juan Ajb'anal Ja'tiox wi' li cars, cuando xta jtaquil juntir ri tijin tran Kakaj Jesús, xtakb'i yak ajtijol rib'ak chirij chi jtz'onaj re Kakaj Jesús jilonri: ");
INSERT INTO uspNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","¿Atni' ri b'il jwi'l Kakaj Dios chi tina jtaknach wich ulew o tina kulb'ejna jun chic? xche'tak re Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Kakaj Jesús xij rechak: Jattak, b'ijtatak re Juan Ajb'anal Ja'tiox juntir ri tijin tawiltak y ri tijin tatatak. ");
INSERT INTO uspNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","B'ijtatak re chi yak moy tichak na'tuntak, yak co'x tichak wo'cottak, yak ri wi' yajel chirijak ri jb'ij lepra xtzib'taka'n, yak tac tichak tontak, yak camnak xc'astasaji' jwichak laj jcamnaklak y yak powrtak xijsaji' tzilaj jtaquil rechak nen mo ticolmajtak laj jk'ab' jmacak. ");
INSERT INTO uspNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Y tzi re jun cristian ri ta' tijquib'aj ranm chwij, xche' Kakaj Jesús rechak. ");
INSERT INTO uspNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Cuando xk'ajtakb'i yak ajtijol rib'ak chirij Juan Ajb'anal Ja'tiox, Kakaj Jesús xoc chi yoloj riq'uilak cristian chirij Juan Ajb'anal Ja'tiox y xtz'onaj rechak: ¿Nen xe' awile'tak li man luwar lamas ta' cristian? ¿Roni' xe' awile'tak jun aaj ri tiitz'b'ej jwi'l tew? ");
INSERT INTO uspNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Wi ma' ji'ta'lonli, ¿nenc'u xe' awile'tak? ¿Roni' xe' awile'tak jun winak ri cojol kustaklaj itz'ik jwi'l? Ma' ji'ta'lonli. Atak awetamaki' chi yak cristian ri ticojowtak kustaklaj itz'ik, ji' wi'tak laj richochak mak rey. ");
INSERT INTO uspNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","¿Nenc'u xe' awile'tak? ¿Roni' xe' awile'tak jun ajk'asal Jyolj Kakaj Dios? Jiloni'n. Y in tamb'ij chawechak chi re masna nim jk'ij chiwch jun ajk'asal Jyolj Kakaj Dios. ");
INSERT INTO uspNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Jwi'l ri' re quiek chirij ri tz'ib'al li wuj re Lok'laj Jyolj Kakaj Dios ri tijb'ij jilonri: Tina intaknab'i intako'n nab'e chawch pire tib'e jb'ij rechak cristian chi rajwaxi' tijq'uex jno'jak y tijc'am jk'ab'al jmacak chinwch nic' riq'uil tran jwa'x jun ab'e chawch, tiche' Kakaj Dios. ");
INSERT INTO uspNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Kes tz'etel tz'et tamb'ij chawechak chi ta' ni jono cristian wa'sal xo'lak juntir cristian ri mas nim jk'ij chiwch Juan Ajb'anal Ja'tiox. Pero chiwch Kakaj Dios ri' mas nim jk'ij chiwch Juan jun cristian ri ta' mas nim jk'ij chijxo'lak yak ri titakon Kakaj Dios laj ranm. ");
INSERT INTO uspNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","La' mak k'ij cuando Juan Ajb'anal Ja'tiox xtijoj cristian re Jyolj Kakaj Dios asta lajori, sub'laj cristian tijin tioctak laj jk'ab' Kakaj Dios pire titakon chib'ak, pero xike yak ri wi' jcowil ranmak tioctak laj jk'ab' Kakaj Dios pire titakon chib'ak. ");
INSERT INTO uspNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Juntir yak ajk'asaltak Jyolj Kakaj Dios ojr pach Jpixb' Kakaj Dios xijtaka' chirij jtakon Kakaj Dios chib'ak cristian asta xyuk Juan Ajb'anal Ja'tiox. ");
INSERT INTO uspNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Wi tacojtak o ta'n, Elías ri b'ilch ojr chi tina pena wich ulew, ri' Juan Ajb'anal Ja'tiox ri xyuk. ");
INSERT INTO uspNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Nen titonc, jte' jcholajl ri tamb'ij, xche' Kakaj Jesús rechak cristian. ");
INSERT INTO uspNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Kakaj Jesús xtz'onaj rechak: ¿Nen quiek la' tanniq'uib'saj yak cristian ri wi'tak re mak junab' lajori? Jilon jb'anicak chapca' mak tral ac'l ri ticub'artak chi itz' lak c'ayb'l y tich'ejejtak chi jch'ab'ej yak jpachak y tijb'ijtak: ");
INSERT INTO uspNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","Xkok'saji' su' chi axicnak, pero ta' xatxojowtak y xkab'ixaji' b'ix ri kes b'is jtaic, pero ta' xatok'tak, tiche'tak. ");
INSERT INTO uspNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Jwi'l cuando xyuk Juan Ajb'anal Ja'tiox ta' tijtij wa ni ta' tijtij vin, atak tab'ijtak chi re wi' jun etzl laj ranm. ");
INSERT INTO uspNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Y cuando xyuk Jc'ajol Kakaj Dios ri xwux pi cristianil, re tijtija' wa y tijtija' vin, atak tab'ijtak: Man winak li sub'laj tiwi'nc, sub'laj tik'ab'arc, richc'ulchi'yi' mak ajtz'onaltak alcabar pach mak ajmacb', atche'tak. Pero in tamb'ij chawechak chi jno'j Kakaj Dios tic'utuni' chirij tzitaklaj no'j ri tib'anc, xche' Kakaj Jesús rechak cristian. ");
INSERT INTO uspNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Ajruc're' Kakaj Jesús xoc chi jyajicak mak cristian ri wi'tak li mak tilmit lamas xan mas c'utb'i jcwinel Kakaj Dios, jwi'l ta' xq'uex jno'jak. ");
INSERT INTO uspNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Y xij rechak: ¡C'ur awchak atak aj Corazín! ¡C'ur awchak atak aj Betsaida! Jwi'l witi ji' xansaj mak c'utb'i jcwinel Kakaj Dios riq'uilak yak cristian aj Tiro pach Sidón ri xansaj aac'lak, ojrtene're' xq'uex jno'jak y xcoja'taktene're' k'ektaklaj itz'ik y roj xtila'taktene're' chaaj laj jb'aak pire c'utb'ire chi tib'isontaka' jwi'l jmacak. ");
INSERT INTO uspNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Pero in tamb'ij chawechak cuando tran jk'atb'itzij Kakaj Dios chib'ak juntir cristian wich ulew, atak masna c'ax k'atb'itzij tib'an chab'ak chiwchak mak cristian aj Tiro pach Sidón. ");
INSERT INTO uspNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Y atak aj Capernaúm, ri' chach'olak chi atc'amsajtaka'b'i riq'ui Kakaj Dios lecj, pero ji'c'une' atb'etak li man luwar lamas tic'olsaj jsantilak camnakib'. Witi mak c'utb'i jcwinel Kakaj Dios ri xansaj aac'lak ji'tene' xansaj riq'uilak yak cristian aj Sodoma, roj xq'uexa'tene' jno'jakre' y ajwi'tene' man tilmit li lajori. ");
INSERT INTO uspNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Pero in tamb'ij chawechak cuando titaw k'ij tran jk'atb'itzij Kakaj Dios chib'ak juntir cristian wich ulew, atak masna c'ax k'atb'itzij tib'an chab'ak chiwch ri xaan chib'ak yak cristian aj Sodoma, xche' Kakaj Jesús rechak. ");
INSERT INTO uspNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","La' mak k'ij li Kakaj Jesús xij jilonri: Tannimirsaj ak'ij at Inkaj, ri Rajawl caj pach ulew jwi'l at ta' xaye' luwar rechak yak ri wi' jno'jak chi tretemajtak jcholajl nen xab'ij. Pero xaya' luwar xretemajtak yak cristian ri jilon jno'jak chapca' mak tral ac'l. ");
INSERT INTO uspNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Jiloni' Kaj, jwi'l jilon chawaj, xche' Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Y xij chic rechak cristian: Inkaj xjacha' juntir laj ink'b'. Ta' ni jonok retam nen tran Jc'ajol Kakaj Dios, xike Kakaj Dios y ta' ni jonok retam nen tran Kakaj Dios, xike Jc'ajol Kakaj Dios pach yak cristian ri lawi' raj Jc'ajol Kakaj Dios tijye' retemaj rechak. ");
INSERT INTO uspNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Tzajtak wiq'uil atak ri cosolcatak li chac y ralaj awika'nak y in atinya'taka' chi uxlan. ");
INSERT INTO uspNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Cojtak inc'utu'n chapca' jun yug tacoj rij akulak y tijoj ayb'ak chwij, in tamb'ana' nim re wanm chi awilicak, ta' tancoj ink'ij y wi jilon tab'antak li, tiuxlani' awanmak. ");
INSERT INTO uspNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Jwi'l inc'utu'n jilon chapca' jun yug ta' c'ax jc'amic, ta' nic' chapca' jun ika'n al, xche' Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Jorok k'axi' quib' uxib' k'ij jb'ij jwi'l Kakaj Jesús jilonli cuando xk'axtak lak tico'n pach yak ajtijol rib'ak chirij li jun k'ij re uxlan y yak ajtijol rib'ak chirij sub'laj xc'oktak wi'jal. Xtoctak jujun jwich trig y xtijtak. ");
INSERT INTO uspNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Mak fariseo cuando xriltak chi jilonli xantak yak ajtijol rib'ak chirij Kakaj Jesucristo, xijtak re: Il impuch, yak ajtijol rib'ak chawij tijin trantak ri ta' ye'l luwar tib'ansaj lak k'ij re uxlan, xche'tak re. ");
INSERT INTO uspNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Kakaj Jesús xtz'onaj rechak: ¿Ta'c'u ilan awi'lak li wuj re Lok'laj Jyolj Kakaj Dios ri xan David ojr pach yak jpach cuando xc'oktak wi'jal? ");
INSERT INTO uspNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Re xoc li nimlaj chinam ri richoch Kakaj Dios pach yak jpach xtijtak mak cuxlanwa ri sujul re Kakaj Dios y ta' ye'l luwar jwi'l Jpixb' Kakaj Dios chi titijsaj, xike rechak yak ajc'amaltak jb'eak cristian riq'ui Kakaj Dios ye'l luwar rechak tijtijtak. ");
INSERT INTO uspNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Y, ¿ta'c'u ilan awi'lak ri tijb'ij Jpixb' Kakaj Dios chi yak ajc'amaltak jb'eak cristian riq'ui Kakaj Dios ta' timacuntak chiwch Kakaj Dios cuando tichacuntak li nimi richoch Kakaj Dios la' mak k'ij re uxlan? ");
INSERT INTO uspNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Pero in tamb'ij chawechak chi neri wi' jun masna nim jk'ij chiwch nimi richoch Kakaj Dios. ");
INSERT INTO uspNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Atak ta' awetamak nen jcholajl tielwi' Jyolj Kakaj Dios ri tijb'ij jilonri: In ri' chwaj tawiltak c'ur jwich jun cristian chiwch tasujtak sipan chwe, tiche'. Witi awetamak jcholajl ta' roj tacoj ayb'ak pi k'atb'itzij chirijak yak ri ta' jmacak, ");
INSERT INTO uspNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","jwi'l Jc'ajol Kakaj Dios ri xwux pi cristianil wi' laj jk'ab' nen raj tran la' man k'ij re uxlan, xche' Kakaj Jesús rechak mak fariseo. ");
INSERT INTO uspNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Cuando Kakaj Jesús xmay yoloj riq'uilak mak fariseo, xe' octak li sinagog. ");
INSERT INTO uspNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Y cla' wi' jun winak ri siquirnak jun jk'ab', pero jwi'l rechak tijin tijtoctak nen jono kelen ri ta' tzi tran Kakaj Jesús pire tijcojtak tzij chirij y xtz'onajtak re: ¿Tijb'ijni' laj Jpixb' Kakaj Dios titzib'saj jun cristian la' k'ij re uxlan? xche'tak re. ");
INSERT INTO uspNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Y Kakaj Jesús xij rechak: Wi wi' jono chawechak wi' jun jcarner y wi xtzaak li jun jul la' k'ij re uxlan, ¿ta'c'u tresaj li jul la' k'ij li? ");
INSERT INTO uspNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Jun cristian masna lok' jc'aslemal chiwch jun carner, jwi'li'li Jpixb' Kakaj Dios tijya' luwar tib'an utzil la' k'ij re uxlan ri rajwax tib'anc, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Y xij re sic' winak ri siquirnak jk'ab': Yuk ak'b', xche' re. Y sic' winak xyuk jk'ab' y xtzib'c, xcan chapca' man jun jk'ab' chic. ");
INSERT INTO uspNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Pero xeltakb'i mak fariseo y xoctak chi jchomorsaj nen trantak chi jcamsaj Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Kakaj Jesús cuando xretemaj nen xchomorsajtak chirij, xelb'i cla' y sub'laj cristian xe'tak chirij y xtzib'saj juntir cristian ri yajtak ");
INSERT INTO uspNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","y xij rechak chi mi jb'ijtak chi re Jc'ajoli' Kakaj Dios. ");
INSERT INTO uspNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Jilonli xan pire xtaw chiwch ri xij Isaías ri ajk'asal Jyolj Kakaj Dios cuando Kakaj Dios xij jilonri: ");
INSERT INTO uspNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Co' ri, wajchac ri cha'l inwi'l, ri sub'laj tanlok'aj y sub'laj inqui'cot chirij. Tanya' Lok'laj Insantil laj ranm pire tijb'ij rechak yak ma' rijajl ta' Israel nen rajwax trantak pire tran suc'ul ranmak chinwch. ");
INSERT INTO uspNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ta' tich'o'jin y ta' tich'ejejc. Ta' ni jonok tita'w re chi cow tich'a'w xo'lak b'e. ");
INSERT INTO uspNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Ta' tran rechak cristian chapca' jq'uisic jk'ipic jun aaj ri cojol jyaj, ni ta' tran rechak cristian chapca' jq'uisic jchupic jun mech re candil ri raquitzchak sib' tiel la', ta' ni jun cristian tijsach jwich asta tina ranna re cristian chi tran suc'ul ranmak chinwch pire tich'econ chib'ak mak etzltak no'j. ");
INSERT INTO uspNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Y juntir cristian ri ma' rijajl ta' Israel ticub'ari' jch'olak chi rulb'ej titaw man k'ij li, xche'. ");
INSERT INTO uspNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Xc'amtakch jun winak moy y mem riq'ui Kakaj Jesús jwi'l wi' etzl laj ranm y Kakaj Jesús xtzib'saj sic' winak, jilonli ta' chiqui' etzl laj ranm, tichak ch'a'w y tichak na'tunc. ");
INSERT INTO uspNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Juntir cristian sub'laj xsaach jch'olak xtz'onajtak chirib'il rib'ak: ¿Ma' ronta' ri Jc'ajol David? xche'tak. ");
INSERT INTO uspNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Mak fariseo cuando xtatak chi jilonli tijb'ijtak yak cristian chirij Kakaj Jesús, xijtak: Man winak li tresaji' mak etzl laj ranmak cristian la' jcwinel Beelzebú ri man jb'ab'al etzl, xche'tak. ");
INSERT INTO uspNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Y Kakaj Jesús retami' nen tijin tijchomorsajtak, xij rechak: Juntir k'atb'itzij, wi tijtos rib'ak y tioctak chi ch'o'j chirib'il rib'ak, tisaachi' jwichak. Y jun tilmit o yak ech'elxic li jun ja, wi tijtos rib'ak y tioctak chi ch'o'j chirib'il rib'ak, ta' naj tijcuytak jilonli. ");
INSERT INTO uspNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Y ji'c'ulonli witi man jb'ab'al etzl tijin chi resaj man jb'ab'al etzl, tijini' tran c'ax rib' ric'an. Wi jilonli tran man jb'ab'al etzl tisaachi' jwich jk'atb'itzij. ");
INSERT INTO uspNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Wi in la'yi' jcwinel Beelzebú twesaj mak etzl laj ranmak cristian, ¿nenc'u ye'winak jcwinelak yak ajtijol rib'ak chawijak pire tresajtak mak etzl laj ranmak cristian? Ri' rechak li tib'intak chawechak chi atak sachalcataka'n. ");
INSERT INTO uspNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Pero wi in twesaj mak etzl laj ranmak cristian la' jcwinel Lok'laj Jsantil Kakaj Dios, ri' li tic'utuw chi jtakon Kakaj Dios chab'ak xyuki' aac'lak. ");
INSERT INTO uspNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Jun cristian ri wi' mas jchok'b' ta' ni jonok ticwin tioc laj richoch chi resaj kelen re. Nab'e tina jximna, ajruc're' tijna' tresaj kelen re, xche' Kakaj Jesús rechak. ");
INSERT INTO uspNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Y xij chic rechak: Nen ta' tzi tril ri tamb'an, ri' li incontrinc. Nen ta' injt'o' chi jmulb'aj jwichak cristian, ri' re tiuktamb'i rechak. ");
INSERT INTO uspNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Jwi'li'li in tamb'ij chawechak chi Kakaj Dios tijcuya' juntir jmacak cristian ri b'anal jwi'lak y juntir mak yok'on ri tijb'ijtak chirij Kakaj Dios. Pero nen jono cristian tiyok'on chirij Lok'laj Jsantil Kakaj Dios, ta' ni jun b'welt ticuysaj jmac jwi'l Kakaj Dios. ");
INSERT INTO uspNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Kakaj Dios tijcuya' jmacak yak ri tiyok'ontak chirij Jc'ajol ri xwux pi cristianil, pero nen jonok tiyok'on chirij Lok'laj Jsantil, ta' ticuysaj jmac lajori y nen or riq'ui Kakaj Dios, xche' Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Kakaj Jesús xij chic rechak mak fariseo: Wi tzilaj che' titicsaj, tziyi' jwich tijye'w, pero wi ma' tzilaj che' ta' titicsaj, ta' tzi jwich tijye'w. Jun che' chirijke jwich tich'ob'saj nen chi che' lal. ");
INSERT INTO uspNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Y atak pur atak cumatz ri ticamsanc. Atak ta' tab'ijtak tzitaklaj yoloj jwi'l ataka' etzltak cristian. Jwi'l laj ranmi' jun cristian tipe'w ri tijb'ij la' jchi'. ");
INSERT INTO uspNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Jun tzilaj cristian tijb'iji' tzitaklaj yoloj jwi'l wi' tzitaklaj no'j laj ranm y jun etzl cristian tijb'iji' etzltak tzij jwi'l wi' etzltak no'j laj ranm. ");
INSERT INTO uspNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","In tamb'ij chawechak cuando titaw k'ij tran jk'atb'itzij Kakaj Dios chib'ak juntir cristian, juntir cristian tina jb'ijtakna re Kakaj Dios nen chac xijtak mak yoloj ri ta' nen tichacuj. ");
INSERT INTO uspNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Jwi'l chiriji' ayolj tic'utun wi ta' amac y chiriji' ayolj tic'utun wi wi' amac, xche' Kakaj Jesús rechak mak fariseo. ");
INSERT INTO uspNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Xpetak nic'j fariseo pachak nic'j ajtijoltak cristian re Jpixb' Kakaj Dios, xijtak re Kakaj Jesús: Ajtijonl, chikaj tikil tab'an jono c'utb'i jcwinel Kakaj Dios chikawch, xche'tak re. ");
INSERT INTO uspNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Kakaj Jesús xij rechak: Yak cristian ri wi'tak wich ulew la' mak junab' lajori mas etzl jno'jak y ta' suc'ul ranmak chiwch Kakaj Dios tijtz'onajtak tib'an jono c'utb'i jcwinel Kakaj Dios chiwchak, pero chiwchak mak cristian li ta' chiqui' tib'ansaj jono c'utb'i jcwinel Kakaj Dios, xike ri xansaj chirij Jonás ri ajk'asal Jyolj Kakaj Dios. ");
INSERT INTO uspNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Chapca' Jonás xwa'xi' uxib' k'ij pach uxib' ak'ab' laj jch'ol jun nimlaj car, jilon Jc'ajol Kakaj Dios ri xwux pi cristianil tina wa'xna uxib' k'ij pach uxib' ak'ab' ralaj ulew. ");
INSERT INTO uspNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Cuando titaw k'ij tran jk'atb'itzij Kakaj Dios chib'ak juntir cristian ri wi'tak lajori, tina jb'itna rib'ak yak cristian aj Nínive pire tijtz'onajtak k'atb'itzij chib'ak mak cristian ri wi'tak lajori, jwi'l rechak xq'uexa' jno'jak cuando xijsaj Jyolj Kakaj Dios rechak jwi'l Jonás y lajori neri chaxo'lak wi' jun ri masna nim jk'ij chiwch Jonás. ");
INSERT INTO uspNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Y man anm ri xwa'x pire reina re man luwar ri wi' li sur, re tipeti' cuando tran jk'atb'itzij Kakaj Dios chib'ak juntir cristian ri wi'tak lajori. Re tina yuk jtz'onajna k'atb'itzij chib'ak juntir mak cristian li, jwi'l sub'laj naji' xpe'w pire xyuk chi jtaic jno'j Salomón. Lajori neri chaxo'lak wi' jun masna jno'j chiwch Salomón, xche' Kakaj Jesús rechak mak fariseo y rechak yak ajtijoltak cristian re Jpixb' Kakaj Dios. ");
INSERT INTO uspNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Kakaj Jesús xij chic rechak jilonri: Cuando jun etzl tiel laj ranm jun cristian, tib'e lak chekej luwar, tijtoc lamas tiuxlanwi', pero cuando ta' tijta' jono luwar lamas tiuxlanwi', tijb'ij: ");
INSERT INTO uspNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Ink'aj chic laj wichoch lamas xinelwi'ch, tiche'. Y cuando tik'aj chic man etzl li, tiyuk jte' man cristian ri lamas xelb'i chapca' rilic jun ja jamal jpam, tzi jmesic jpam y tzi jb'anic jwa'xc. ");
INSERT INTO uspNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Tipe man etzl li, tib'e jcame'ch wukub' (7) jpach chic ri masna etzl jno'jak chiwch re y juntir rib'ilak tioctak laj ranm man cristian li. Y man cristian li tran chic mas etzl jno'j chiwch ojr. Jilon tib'ansaj rechak mak etzltak cristian ri wi'tak lajori, xche' Kakaj Jesús rechak mak fariseo y yak ajtijoltak cristian re Jpixb' Kakaj Dios. ");
INSERT INTO uspNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Aj tijini' Kakaj Jesús chi yoloj riq'uilak cristian cuando xtawtak jchuch pach yak jk'un, rechak ri' raj roj xch'ab'ejtak Kakaj Jesús, pero ji'ke xcantak chuchja. ");
INSERT INTO uspNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Xpe jun rechak yak ri wi'tak cla', xij re: Achuch pach yak ak'un wi'tak chuchja y rajak atjch'ab'ejtak, xche' re. ");
INSERT INTO uspNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Pero Kakaj Jesús xij re man ri xin re jilonli: ¿Nenc'u inchuch y nenc'u ink'un? xche' re. ");
INSERT INTO uspNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Ajruc're' xc'ut yak ajtijol rib'ak chirij y xij: Ri'taka' rechak ri inchuch pach ink'un. ");
INSERT INTO uspNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Juntir yak ri tib'anowtak lawi' raj Inkaj Dios ri wi' lecj, ri'taka' li ink'un, wanab' y inchuch, xche' Kakaj Jesús re. ");
INSERT INTO uspNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","La' man k'ij li xelb'i Kakaj Jesús la ja, xe' cub'arok chi' nimlaj alagun. ");
INSERT INTO uspNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Y jwi'l sub'laj cristian xmulb'a' rib'ak riq'uil, xjaw li jun barc, xcub'arch cla' y juntir cristian xcantak chi' nimlaj alagun. ");
INSERT INTO uspNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Kakaj Jesús xoc chi jtijojcak re sub'laj kelen la' esb'itak no'j. Xij jun esb'i no'j rechak jilonri: Wi' jun ajticonl xe' ticonanok. ");
INSERT INTO uspNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Cuando tijin chi ticonanc, nic'j íjaj xkejtak li b'e y xpetak mak tz'iquin xtijtak. ");
INSERT INTO uspNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Nic'j íjaj chic xkejtak xo'lak ab'aj lamas ta' pim ulew. Mak íjaj li, laj or xeltakch jwi'l ta' mas naj jpam man ulew lamas xkejtakwi'. ");
INSERT INTO uspNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Pero jwi'l ta' lamas xe' ra'ak cuando xel sak'j, xchekejtak y xcamtak. ");
INSERT INTO uspNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Y nic'j íjaj chic xkejtak lak q'uix, xeltaka'ch, pero mak q'uix xq'uiytak laj or chiwchak, xcamtak mak tico'n ralaj mak q'uix. ");
INSERT INTO uspNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Nic'j íjaj chic xkejtak li tzilaj ulew. Mak íjaj li jor kus xwichintak. Jujun íjaj xya'taka' jujun cient (100) jwichak y nic'j chic xya'taka' oxc'al (60) jwichak y nic'j chic xya'taka' junwinak lajuj (30) jwichak. ");
INSERT INTO uspNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Nen titonc, jte' jcholajl ri tamb'ij, xche' Kakaj Jesús rechak cristian. ");
INSERT INTO uspNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Xpetak yak ajtijol rib'ak chirij Kakaj Jesucristo, xjutuntak riq'ui Kakaj Jesús y xtz'onajtak re: ¿Nen chac la' esb'itak no'j tach'ab'ej mak cristian? xche'tak re. ");
INSERT INTO uspNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Kakaj Jesús xij rechak: Atak, Kakaj Dios xya' retemaj chawechak jcholajl jtakon ri ta' etemal, pero rechak ta' xye' luwar rechak tretemajtak. ");
INSERT INTO uspNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Nen wi' mas riq'uil, tiye'saj chiqui' mas re pire tiniman re, pero nen ta' re, asta raquitz ri wi' riq'uil, timajsaji' re. ");
INSERT INTO uspNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Jwi'li'li la' esb'itak no'j tanch'ab'ejtak jwi'l rechak onque tina'tuntaka'n, pero ta' tijmajtak jcholajl nen tijin triltak. Tijta'taka' nen tib'ijsaj rechak, pero ta' tijtatak jcholajl nen tijin tijtatak. ");
INSERT INTO uspNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Chirijak mak cristian li titaw chiwch Jyolj Kakaj Dios ri xcan jb'ij Isaías ri ajk'asal Jyolj Kakaj Dios ojr cuando xij jilonri: Tijta'taka' ri tib'ijsaj rechak, pero ta' tijtatak jcholajl y tina'tuntaka'n, pero ta' tijmajtak jcholajl ri nen tijin triltak. ");
INSERT INTO uspNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Jwi'l mak cristian li pur ab'aj ranmak, nic riq'uil tz'apili' jxicnak y nic' riquil tz'apili' b'ak' jwichak, ta' tina'tuntak y ta' tijtatak jcholajl ri ximb'ij pire ta' tijq'uex jno'jak y ta' tik'ajtak wiq'uil pire tancunajtak, xche'. ");
INSERT INTO uspNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Pero atak tzi awechak jwi'l atna'tuntaka'n y attontaka'n. ");
INSERT INTO uspNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Kes tz'etel tz'et tamb'ij chawechak chi sub'laj ajk'asaltak Jyolj Kakaj Dios y sub'laj cristian ri suc'ul ranmak chiwch Kakaj Dios rajak roj xrile'tak ri tijin tawiltak lajori, pero ta' xriltak. Rajak roj xtatak lawi' ri tijin tatatak lajori, pero ta' xtatak, xche' Kakaj Jesús rechak. ");
INSERT INTO uspNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Kakaj Jesús xij rechak: Tatak jcholajl ri tielwi' man esb'i no'j ri ximb'ij chirij man ajticonl. ");
INSERT INTO uspNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Jun cristian ri tijta jtaquil chirij jtakon Kakaj Dios y ta' tijta jcholajl, jilon chapca' man b'e ri lamas xkejwi' mak íjaj, tijc'ula' Jyolj Kakaj Dios laj ranm, pero laj or tipe man jb'ab'al etzl tresaj chic laj ranm. ");
INSERT INTO uspNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Y jun cristian chic jilon chapca' man ulew lak ab'aj lamas xkejtakwi' mak íjaj, re tijta' Jyolj Kakaj Dios y laj or tijc'ul pi qui'cotemal laj ranm, ");
INSERT INTO uspNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","pero ta' tib'e ra' laj ranm jwi'l ta' tijcub'a' mas jch'ol chirij. Quib' uxib' k'ijke tijcoj, pero cuando titakchi'j chi macunc y cuando tib'ansaj c'ax re jwi'l tijcoj Jyolj Kakaj Dios, laj or tijquib'aj ranm. ");
INSERT INTO uspNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Y man luwar lak q'uix ri lamas xkejtakwi' mak íjaj, ri' jun cristian ri tijcoj Jyolj Kakaj Dios laj ranm quib' uxib' k'ij, pero ri' tib'e mas ranm chirijak mak kelen re wich ulew y tisub'saj jwi'l jb'iomil, ri' li tik'atow jwich Jyolj Kakaj Dios pire ta' tiwichin laj ranm. ");
INSERT INTO uspNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Y man tzilaj ulew lamas xkejtakwi' mak íjaj, ri' jun cristian ri tijc'ul Jyolj Kakaj Dios laj ranm y tijta' jcholajl, nic' riq'uil tiwichini' Jyolj Kakaj Dios laj ranm. Re jilon chapca' mak íjaj ri tijye'tak jujun cient (100) jwichak, chapca' mak íjaj ri tijye'tak oxc'al (60) jwichak y chapca' mak íjaj ri tijye'tak junwinak lajuj (30) jwichak, xche' Kakaj Jesús rechak yak ajtijol rib'ak chirij. ");
INSERT INTO uspNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Kakaj Jesús xij chic jun esb'i no'j rechak cristian jilonri: Jtakon Kakaj Dios chib'ak cristian jilon chapca' xan jun winak ri xtic tzilaj íjaj laj rulew. ");
INSERT INTO uspNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Pero lak'ab' cuando tiwartak juntir, xtaw jun jcontre winak li, xe' jtique' etzl woron chijxo'lak mak trig y xec'. ");
INSERT INTO uspNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Pero cuando xq'uiytak mak trig, xcholtak wichinc, jilon mak etzl woron tijin tiq'uiytak chijxo'lak mak trig. ");
INSERT INTO uspNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Xpetak mak mocom, xe' jb'ijtak re man rajw tico'n: Kaj, awíjaj ri xatic tzilaj íjaji'n y, ¿lac'umas xpe'tak mak etzl woron? xche'tak re man rajw tico'n. ");
INSERT INTO uspNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Man rajw tico'n xij rechak: Jono incontre xe' tiquiw mak etzl woron chijxo'l intico'n, xche'. Y mak mocom xtz'onajtak re: ¿Chawajni' tib'e kab'uke' mak etzl woron? xche'tak re. ");
INSERT INTO uspNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Y man rajw tico'n xij chic re mak mocom: Ma b'uk'tak jwi'l pent jb'uk'ic mak etzl woron tab'antak tib'uk'majb'i jujun trig chijxo'l. ");
INSERT INTO uspNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Ri' mas tzi q'uiyna xo'lak trig asta titaw k'ij tikamol mak trig ajruc're' nab'e tantak immocom, chi jmolic juntir mak etzl woron y tijximtak pi k'alu'n y tijtostak pire tic'atsaj y juntir mak trig ri tijmoltak, tijc'oltak laj inc'újaj, xche' re mak mocom, xche' Kakaj Jesús rechak cristian. ");
INSERT INTO uspNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Kakaj Jesús xij chic jun esb'i no'j rechak cristian jilonri: Jtakon Kakaj Dios chib'ak cristian jilon chapca' jun ra íjaj re mostas ri xtic jun winak laj rulew. ");
INSERT INTO uspNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Man ra íjaj re mostas masna nuch' chiwch juntir íjaj, pero cuando tiq'uiy ri' mas nim titaw chiwch juntir ichj, trana' chapca' jun nuch' che' y mak tz'iquin tipetak tran jsocak lak jk'ab', xche' Kakaj Jesús rechak cristian. ");
INSERT INTO uspNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Kakaj Jesús xij chic jun esb'i no'j rechak cristian jilonri: Jtakon Kakaj Dios chib'ak cristian jilon chapca' ch'amk'or ri tijc'am jun anm, tijyuj pach uxib' pajb'l c'aj pire tijch'amab'saj juntir man k'or, xche' Kakaj Jesús rechak cristian. ");
INSERT INTO uspNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","La' esb'itak no'j xtijojwi' cristian Kakaj Jesús re Jyolj Kakaj Dios pire tijtatak jcholajl. ");
INSERT INTO uspNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Jilonli xan pire xtaw chiwch ri xij jun ajk'asal Jyolj Kakaj Dios ojr cuando Kakaj Dios xij jilonri: Inna yolowna la' esb'itak no'j, tina imb'ijna kelen ri ta' etemalch asta cuando ajqui' caj pach ulew, xche'. ");
INSERT INTO uspNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Kakaj Jesús xmay yoloj riq'uilak cristian y xoc la ja. Xpetak yak ajtijol rib'ak chirij, xijtak re Kakaj Jesús: B'ij chike nen jcholajl tielwi' man esb'i no'j ri xab'ij chirijak mak etzl woron ri xeltakch lak trig, xche'tak re Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Kakaj Jesús xij rechak: Ri xtiquiw tzilaj íjaj ri' Jc'ajol Kakaj Dios ri xwux pi cristianil. ");
INSERT INTO uspNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Y ri ulew lamas xticonan ri' juntir wich ulew y ri tzitaklaj íjaj ri'taka' yak cristian ri tioctak laj jk'ab' Kakaj Dios pire titakon laj ranmak. Y mak etzl woron ri'taka' yak cristian ri wi'tak laj jk'ab' man jb'ab'al etzl. ");
INSERT INTO uspNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Y man contre ri xtiquiw mak etzl woron ri' man jb'ab'al etzl y k'ij re cuando timolsajtak mak trig ri' man k'ij re q'uisb'i jwich k'ijsak y yak ri xmolowtak re mak trig ri'taka' yak anjl. ");
INSERT INTO uspNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Chapca' jmolic mak etzl woron tib'ansaj pire tit'ojsaj li k'ak' pire tic'atc, jilonli tib'an la' q'uisb'itak k'ij re jwich k'ijsak. ");
INSERT INTO uspNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Jc'ajol Kakaj Dios ri xwux pi cristianil tina jtaknach yak anjl chi jcha'ic chijxo'lak yak cristian ri titakon Kakaj Dios laj ranmak, juntir yak cristian ri tib'anow rechak cristian chi timacuntak pach yak ri tib'anowtak mak etzltak no'j, ");
INSERT INTO uspNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","tit'ojsajtak li jun jorn ri wi' sub'laj jk'ak'al. Cla' tib'e rok'b'ej rib'ak y tijkuch'uch'uj reeak. ");
INSERT INTO uspNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Y yak ri suc'ul ranmak chiwch Kakaj Dios, tina jululuntaknach chapca' rilic k'ij, tiwa'xtakch lamas titakonwi' Kakaj Dios. Nen titonc, jte' jcholajl ri tamb'ij, xche' Kakaj Jesús rechak yak ajtijol rib'ak chirij. ");
INSERT INTO uspNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Kakaj Jesús xij chic rechak yak ajtijol rib'ak chirij: Jtakon Kakaj Dios chib'ak cristian jilon chapca' jun kelen ri pakal rijil ri mukul li jun luwar. Y jun winak tijta'w y xike tril tican jmuke' chic cla', sub'laj tichak qui'cotc, tib'e jc'ayaj juntir kelen re y tijlok' man ulew li, xche' Kakaj Jesús rechak. ");
INSERT INTO uspNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Kakaj Jesús xij chic rechak: Jtakon Kakaj Dios chib'ak cristian jilon chapca' tran jun ajyecomanl ri tijin tijtoc mak kustaklaj perla ri pakal rijil. ");
INSERT INTO uspNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Cuando tib'e jte' jun ri sub'laj pakal rijil, laj or tib'e jc'ayaj juntir kelen re y tijlok' man kuslaj perla li ri sub'laj pakal rijil, xche' Kakaj Jesús rechak. ");
INSERT INTO uspNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Kakaj Jesús xij chic rechak: Jtakon Kakaj Dios chib'ak cristian jilon chapca' jun c'aat re chapb'i car. Man c'aat re chapb'i car cuando tit'ojsaj li mar tijmola' juntir jwich car. ");
INSERT INTO uspNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Cuando tinoj man c'aat chi car tipetak mak ajchapaltak car tresajtakb'i chi' ja', tib'e cub'artak chi jcha'ic. Mak tzitaklaj car tijc'oltak lak chicach y mak car ri ta' tzi tijt'ojtakb'ic. ");
INSERT INTO uspNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Y jilonli tib'an la' q'uisb'itak k'ij re jwich k'ijsak. Tipetak yak anjl, tijcha'tak mak cristian ri pur etzl jno'jak chijxo'lak yak ri suc'ul ranmak chiwch Kakaj Dios. ");
INSERT INTO uspNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Y mak cristian li ri pur etzl jno'jak tit'ojsajtak li jun jorn ri wi' sub'laj jk'ak'al. Cla' tib'e rok'b'ej rib'ak y tijkuch'uch'uj reeak, xche' Kakaj Jesús rechak yak ajtijol rib'ak chirij. ");
INSERT INTO uspNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Kakaj Jesús xtz'onaj rechak: ¿Xata'takni' jcholajl nen mo tielwi' juntir ri ximb'ij? xche' rechak yak ajtijol rib'ak chirij. Rechak xijtak re Kakaj Jesús: Xkata'n, Kajawl, xche'tak. ");
INSERT INTO uspNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Kakaj Jesús xij chic rechak: Jun ajtijol cristian re Jpixb' Kakaj Dios cuando tijtijoj rib' re nen mo jtakon Kakaj Dios chib'ak cristian jilon chapca' jun rajw ja ri wi' kelen re c'olan jwi'l y cuando raj tresajch aac' kelen, tresaji'n y cuando raj tresajch tzay kelen, tresaji'n, xche' Kakaj Jesús rechak yak ajtijol rib'ak chirij. ");
INSERT INTO uspNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Kakaj Jesús cuando xmay jb'ij juntir mak esb'itak no'j li, xelb'i cla'. ");
INSERT INTO uspNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Xtaw laj jtilmit xchol jtijoj cristian li sinagog. Mak cristian sub'laj xsaach jch'olak chi jtaic y xtz'onajtak chirib'il rib'ak: ¿La'cumas xpe jno'j jilon tran li, ri tijin tijb'ij? Y, ¿nen chiqui' mo ticwin chi jb'anic mak c'utb'i jcwinel Kakaj Dios? ");
INSERT INTO uspNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Re ri' jc'ajol man ajc'ox y jchuch ri' María. Ri' ratzak Santiago, José, Simón pach Judas. ");
INSERT INTO uspNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Y wi'taka' yak ranab' neri chikaxo'l. Y, ¿lac'umas xpe jno'j jilon tran li? xche'tak mak cristian chirij. ");
INSERT INTO uspNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Jwi'li'li ta' rajak tijcojtak lawi' ri tijb'ij Kakaj Jesús. Xpe re, xij rechak: Lak juntir luwar ticojsaji' jk'ij jun ajk'asal Jyolj Kakaj Dios, pero laj jtilmit ta' ticojsaj jk'ij, ni laj richoch, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Y ta' xan q'uilaj c'utb'i jcwinel Kakaj Dios cla' jwi'l mak cristian ri wi'tak cla' ta' ticub'ar jch'olak chirij. ");
INSERT INTO uspNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","La' mak k'ij li man rey Herodes Antipas xta jtaquil juntir ri tran Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Xij rechak mak ri wi' rekle'nak pi jpach: Winak li ri' Juan Ajb'anal Ja'tiox xc'astasaj jwich laj jcamnakl xo'lak camnakib', jwi'li'li ticwini' chi jb'anic c'utb'i jcwinel Kakaj Dios, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Herodes xij jilonli jwi'l ri' re xtakow jchapic Juan Ajb'anal Ja'tiox y xtakow jximic la' caden y xtak jcojic li cars jwi'l Herodías ri xwa'x pi rixokl Herodes Felipe ri jk'un ");
INSERT INTO uspNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","y Juan Ajb'anal Ja'tiox xij re Herodes: Ta' tzi xab'an xatc'uli'y riq'ui rixokl ak'un, xche' re. ");
INSERT INTO uspNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Herodes rajti ranm tijcamsaj Juan Ajb'anal Ja'tiox, pero tike tzaak jch'ol chiwchak juntir cristian jwi'l retamaki' chi Juan Ajb'anal Ja'tiox, ajk'asal Jyolji' Kakaj Dios. ");
INSERT INTO uspNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Pero cuando xan jnimak'j Herodes re xc'ul jk'ij, xpe jun k'apoj anm ric'lal Herodías xyuk xojow chiwchak juntir mak ri wi'tak la ja ri xsiq'uijtak li man nimak'ij li y Herodes sub'laj kus xril. ");
INSERT INTO uspNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Xij re chiwchak juntir cristian chi tz'etel tz'et tijya' re nen chi kelen raj tijtz'onaj. ");
INSERT INTO uspNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Y man k'apoj anm li xtakchi'j jwi'l jchuch chi tijtz'onaj jb'a Juan Ajb'anal Ja'tiox re Herodes, xij re: Chwaj chi taye' chwe li jun nimlaj plat jb'a Juan Ajb'anal Ja'tiox, xche' re. ");
INSERT INTO uspNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Man rey li sub'laj xb'ison cuando xta chi jilonli xijsaj re, pero jwi'l chiwchi' juntir mak ri wi'tak li man nimak'ij li xij chi tijya' re nen raj tijtz'onaj, jwi'li'li xtak jye'ic re man k'apoj anm lawi' raj. ");
INSERT INTO uspNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Jilonli xtak resaj jb'a Juan Ajb'anal Ja'tiox li cars. ");
INSERT INTO uspNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Xye'sajch li jun nimlaj plat y xye'saj re man k'apoj anm y man k'apoj anm xe' jye' re jchuch. ");
INSERT INTO uspNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Xpetak yak ajtijol rib'ak chirij Juan Ajb'anal Ja'tiox, xe' jc'ame'takch jcamnakl Juan Ajb'anal Ja'tiox. Xmuktak, ajruc're' xe' jb'ijtak re Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Kakaj Jesús, cuando xta jtaquil chi xcamsaji' Juan Ajb'anal Ja'tiox, xelb'i cla', xjawb'i li jun barc y xe' li jun luwar lamas ta' cristian ch'akap re nimlaj alagun. Y cuando sub'laj q'ui cristian re mak tilmit xtatak jtaquil lamas xe' Kakaj Jesús, xe'tak chi rakanak asta xtawtak lamas wi' Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Cuando xelch Kakaj Jesús li barc xril sub'laj q'ui cristian mulantak cla', xril c'ur jwichak y xtzib'saj yak cristian ri yajtak ri c'amalb'i jwi'lak. ");
INSERT INTO uspNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Cuando xe' k'ij xpe yak ajtijol rib'ak chirij, xjutuntak chijc'ulel y xijtak re: Lajori xi' k'ij y la' man luwar ri ta' cristian, q'uis ayolj riq'uilak cristian y b'ij rechak chi tib'etak lak tilmit pire tib'e jlok'e' jwaak re tijtijtak, xche'tak re Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Kakaj Jesús xij rechak: Ta' rajwax tina b'etakna chi jlok'ic jwaak. Ye'tak jwaak, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Rechak xijtak re Kakaj Jesús: Pero ta' q'ui cuxlanwa wi' kiq'uil, xike job' chi cuxlanwa wi' kiq'uil pach quib' chi car, xche'tak re. ");
INSERT INTO uspNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Kakaj Jesús xij chic rechak: C'amtakch mak cuxlanwa pach mak car neri, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Y xij rechak juntir cristian chi ticub'artak b'ak q'uim. Y xpe Kakaj Jesús xc'am mak job' cuxlanwa laj jk'ab' pach mak quib' car, xna'tun lecj, xc'omowaj re Kakaj Dios, xq'uer y xye' mak cuxlanwa rechak yak ajtijol rib'ak chirij y rechak xjachtak chiwchak juntir cristian. ");
INSERT INTO uspNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Juntir cristian xwi'ntak asta xnojtak y cuando xcolajtak, xnojsajtakna cab'lajuj (12) chicach chi q'uertak cuxlanwa y car ri ta' xq'uisc. ");
INSERT INTO uspNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Yak ri xwi'ntak raj wi' job' mil (5,000) xike winak, ta' xajlaj anm ni mak tral ac'l. ");
INSERT INTO uspNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Cuando xantaj li jwi'l Kakaj Jesús, xij rechak yak ajtijol rib'ak chirij chi tijawtakb'i li barc y tinab'ertakb'i pire tik'axtakb'i nab'e ch'akap re nimlaj alagun. Re xcanna jch'ab'ej juntir cristian. ");
INSERT INTO uspNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Ajruc're' xjaw b'a jun witz ric'an chi ch'a'wem riq'ui Kakaj Dios. Cuando xoc ak'ab', re ajwi' b'a witz. ");
INSERT INTO uspNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Y man barc lamas xe'tak yak ajtijol rib'ak chirij Kakaj Jesucristo xjutuni'b'i naj b'a nimlaj alagun y mak retumb re man nimlaj alagun sub'laj tijk'osaj rib'ak chiwch man barc, jwi'l man tew ji' tijin jpetic laj jsuc'lal lamas b'esal man barc. ");
INSERT INTO uspNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Cuando sakarem re, Kakaj Jesús xe' chi rilicak, b'e tran b'a nimlaj alagun xjutumb'i riq'uilak. ");
INSERT INTO uspNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Cuando yak ajtijol rib'ak chirij xriltak chi b'e tran Kakaj Jesús b'esal b'a nimlaj alagun, rechak sub'laj xtzaak jch'olak y sub'laj cow xch'ejejtak y xijtak: ¡Jun ajtzakal ch'oli'n! xche'tak. ");
INSERT INTO uspNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Xpe Kakaj Jesús, laj or xch'ab'ejtakb'ic, xijb'i rechak: Cowirsaj awanmak, ini'n, mi tzaak ach'olak, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Xpe Pedro, xij re Kakaj Jesús: Wajawl, wi kes tz'et ati'n, b'ij chwe chi imb'emb'i b'a ja' intaw aac'l, xche' re. ");
INSERT INTO uspNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Kakaj Jesús xij: Tzaj, xche' re. Ajruc're' xpe Pedro, xkejb'i li barc xe' chi rakan b'a ja' laj jsuc'lal lamas petzalwi' Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Pero xril chi wi' mas jchok'b' tew b'a ja', sub'laj xtzaak jch'ol y cuando tijinchak jkejic ralaj ja' xch'ejejc, xij: ¡Wajawl, quinacole'! xche'. ");
INSERT INTO uspNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Xpe Kakaj Jesús, laj or xchap chi jk'ab' y xij re: ¡At ta' mas cub'ul ach'ol chwij! ¿Nen chac xaquib'aj awanm? xche' re. ");
INSERT INTO uspNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Cuando xjawtakch li barc, xtanar man quiek'ek' tew. ");
INSERT INTO uspNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Y juntir yak ri wi'tak li man barc xxucartak chiwch Kakaj Jesús y xijtak re: Tz'etel tz'et ati'ca' Jc'ajol Kakaj Dios, xche'tak re. ");
INSERT INTO uspNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Cuando rechak xk'axtakb'i ch'akap re nimlaj alagun, xtawtak li jun luwar ri jb'ij Genesaret. ");
INSERT INTO uspNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Y yak cristian cla' xch'ob'tak jwich Kakaj Jesús, xe' jye'tak jtaquil li juntir man luwar li y juntir cristian ri wi' jyowb'ak xc'amtakb'i riq'ui Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Y xtz'onajtak tok'ob' re chi tijye' luwar rechak tijchaptak raquitz chak'chi' ritz'ik. Juntir yak ri xchapowtak re xcani' tzib'tak re jyajak. ");
INSERT INTO uspNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Xpetak nic'j fariseo pach nic'j ajtijoltak cristian re Jpixb' Kakaj Dios ri tipetak Jerusalén xtawtak riq'ui Kakaj Jesús xijtak re: ");
INSERT INTO uspNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","Yak ajtijol rib'ak chawij ta' tijcojtak jc'utu'nak kamam katit'. Rechak ta' tijch'aj jk'ab'ak nab'e, ajruc're' tijtij kelen rechak, xche'tak re Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Kakaj Jesús xij rechak: Atak jwi'lke tatakejtak mak jc'utu'n amam atit'ak, ta' tacojtak Jpixb' Kakaj Dios, ");
INSERT INTO uspNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","jwi'l Kakaj Dios xiji' jilonri: Coj jk'ij akaj achuch, xche'. Y xij chic: Nen tijyok' jkaj jchuch, tina camsajna, xche' Kakaj Dios. ");
INSERT INTO uspNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Pero atak tab'ijtak: Jun cristian tijna' tijb'ij re jkaj o jchuch, ta' tijna' atint'o'w riq'ui nen rajwax chawe jwi'l juntir kelen we ri wi' b'ili' inwi'l chi pirechi' tansuj re Kakaj Dios, atche'tak. ");
INSERT INTO uspNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Y atak tab'ijtak chi jilonli ta' rajwax tijcoj jk'ij jkaj o jchuch jun cristian. Jilonli tasachtak jwich Jpixb' Kakaj Dios jwi'l ri' chiqui' tatakejtak ac'utu'nak. ");
INSERT INTO uspNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Atak ajsolcopil acayb'alak, tz'eti'ca' xcan jtz'ib'aj Isaías ri ajk'asal Jyolj Kakaj Dios chawijak ojr cuando Kakaj Dios xij jilonri: ");
INSERT INTO uspNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Yak cristian ri, jchi'ake tib'in chi tijnimirsajtaka' ink'ij, pero laj ranmak ta' tz'et trantak jilonli. ");
INSERT INTO uspNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Ta' nen tichacuj tijnimirsajtak ink'ij. Rechak tijtijojtak cristian re mak c'utu'n ri queneysalke jwi'lak, trantak chapca' ri' Impixb' tijb'ijtak, xche' Kakaj Dios, xche' Kakaj Jesús rechak nic'j fariseo pach nic'j ajtijoltak cristian re Jpixb' Kakaj Dios. ");
INSERT INTO uspNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Y Kakaj Jesús xsiq'uij cristian, xij rechak: Tatak ri tamb'ij y tatak jcholajl. ");
INSERT INTO uspNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Ma' ri' ta' ri tioc laj jchi' jun cristian ri tib'anow re timacunc. Ri' ri tielch laj jchi' jun cristian ri tib'anow re timacunc, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Xpetak yak ajtijol rib'ak chirij Kakaj Jesucristo, xjutuntak chijc'ulel y xijtak re: Mak fariseo ta' tzi xtatak ri xab'ij, xche'tak re Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Y Kakaj Jesús xij rechak: Juntir tico'n ri ma' jticonoj ta' Inkaj Dios ri wi' lecj, tina b'uk'sajnab'ic. ");
INSERT INTO uspNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Rechak wa'xtakna cla' nic' riq'uil moytaka' tijin tijc'amtak jb'eak nic'j moy chic. Wi wi' jun moy tijc'am jb'e jun moy chic, chi quib' rib'ilak tib'e tzaaktaka' li jono jul, xche' Kakaj Jesús rechak. ");
INSERT INTO uspNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Xpe Pedro, xij re Kakaj Jesús: B'ij chike nen jcholajl tielwi' man esb'i no'j ri xab'ij, xche' re. ");
INSERT INTO uspNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Kakaj Jesús xij: Y jilon atak ajqui' chatatak jcholajl. ");
INSERT INTO uspNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Juntir kelen ri tioc laj jchi' jun cristian, ji' tib'e laj jch'ol, ajruc're' tresajb'ic. ");
INSERT INTO uspNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Pero ri tijb'ij jun cristian, laj ranmi' tipe'w y ri' li ri tib'anow re jun cristian timacunc. ");
INSERT INTO uspNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Jwi'l laj ranmi' jun cristian tipe'w mak etzltak chomorsa'n, ticamsanc, tran tz'i'al, trechb'ej jun jalan cristian chic ri ma' jc'ulajl ta'n, tialk'anc, tijmol tzij y tiyok'onc. ");
INSERT INTO uspNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Ri' juntir mak no'j li ri titz'ilib'san re ranm jun cristian chiwch Kakaj Dios. Pero jun cristian ri tijtij kelen y ta' tijch'aj jk'ab', ma' ri' ta' li titz'ilib'san re ranm chiwch Kakaj Dios, xche' Kakaj Jesús rechak yak ajtijol rib'ak chirij. ");
INSERT INTO uspNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Kakaj Jesús xelb'i cla', xe' lak luwar chijc'ulel Tiro pach Sidón. ");
INSERT INTO uspNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Y cla' wi' jun anm aj Canaán. Xpe man anm li, xjutun chijc'ulel Kakaj Jesús xch'ejej, xij: ¡Wajawl, Jc'ajol David, il c'ur inwch, wic'lal sub'laj c'ax tijin tijtij jwi'l wi' jun etzl laj ranm! xche' re. ");
INSERT INTO uspNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Kakaj Jesús ta' xch'ab'ej man anm li. Xpetak yak ajtijol rib'ak chirij, xjutuntak chijc'ulel Kakaj Jesús xtz'onajtak tok'ob' re y xijtak: B'ij re man anm li tib'ec, jwi'l mas tich'ejej petzal chikij, xche'tak re Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Xpe Kakaj Jesús, xij: In xintaksajch jwi'l Kakaj Dios pirechi' tiyuk intoque' jujun rechak yak rijajl Israel ri chapca' mak carner ri sache'ltak, xche'. ");
INSERT INTO uspNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Pero xpe man anm xxucar chiwch Kakaj Jesús y xij re: Wajawl, quinat'owe', xche' re. ");
INSERT INTO uspNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Kakaj Jesús xij chic re man anm: Ta' tzi timajsaj jwaak yak alc'walixelb' y tiye'saj rechak mak tz'i', xche' re. ");
INSERT INTO uspNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Man anm xij chic re Kakaj Jesús: Tz'eti' tab'ij Wajawl. Pero mak tz'i' tijtija'taka' mak tra jxerc' wa ri titzaakch b'a mex riq'ui rajwak, xche' re Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Kakaj Jesús xij chic re man anm li: At anm, sub'laj cub'ul ach'ol chwij. B'anok chapca' chawaj at tib'ansaj chawe, xche' re. Y laj or xtzib' ric'lal sic' anm. ");
INSERT INTO uspNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Kakaj Jesús xel chicb'i cla' xe' chic chi' nimlaj alagun ri jb'ij Galilea. Cuando xtaw cla' xjaw wich jun witz y xcub'ar cla'. ");
INSERT INTO uspNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Sub'laj cristian xmulb'a' rib'ak lamas wi' Kakaj Jesús y c'amalch cristian jwi'lak ri co'xtak, ri moytak, ri ta' tz'akatnak rakan jk'ab'ak, ri memtak y nic'j cristian chic ri wi' jaljojtak yajel rechak. Juntir li xe' jye'tak chiwch Kakaj Jesús y re juntir xtzib'sajtak. ");
INSERT INTO uspNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Juntir cristian sub'laj xsaach jch'olak cuando xriltak chi yak mem tichak ch'a'wtak, yak ri ta' tz'akatnak rakan jk'ab'ak xtz'akati' rakan jk'ab'ak, yak co'xtak tichak wo'cottak y yak moytak tichak na'tuntak. Y xoctak chi jnimirsaj jk'ij Kakaj Dios ri jDiosak yak rijajl Israel. ");
INSERT INTO uspNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Kakaj Jesús xsiq'uij yak ajtijol rib'ak chirij y xij rechak: Mas twil c'ur jwichak yak cristian jwi'l xana' uxib' k'ij wi'tak wiq'uil y ta' nen tijtijtak, in ta' chwaj tantakb'i laj richochak chi mita' tiwi'ntakb'ic, jwi'l ta' c'axre' wi tib'e tukartak lak b'e jwi'l wi'jal, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Y yak ajtijol rib'ak chirij Kakaj Jesucristo xijtak re: Ta' lamas tikata'wi' kelen pi rechak la' man luwar ri, ri ta' cristian, xche'tak re. ");
INSERT INTO uspNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Kakaj Jesús xtz'onaj rechak: ¿Jurub' chi cuxlanwa wi' aac'lak? xche' rechak. Y rechak xijtak: Wi' wukub' (7) chi cuxlanwa y quib' uxib' tra car, xche'tak. ");
INSERT INTO uspNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Kakaj Jesús xij rechak juntir cristian chi ticub'artak lak ulew. ");
INSERT INTO uspNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Xc'am mak wukub' (7) chi cuxlanwa pach quib' uxib' tra car y xc'omowaj re Kakaj Dios. Ajruc're' xq'uer mak cuxlanwa y xye' rechak yak ajtijol rib'ak chirij y rechak xjachtak chiwchak juntir cristian. ");
INSERT INTO uspNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Juntir cristian xwi'ntak asta xnojtak y cuando xcolajtak, xnojsajtakna wukub' (7) chicach chi q'uertak cuxlanwa y car ri ta' xq'uisc. ");
INSERT INTO uspNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Yak ri xwi'ntak raj wi' quejab' mil (4,000) xike winak, ta' xajlaj anm ni tral ac'l. ");
INSERT INTO uspNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Xantaj li jwi'l Kakaj Jesús xcan jch'ab'ej mak cristian, xjawb'i li barc y xe' lak luwar re Magadán. ");
INSERT INTO uspNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Mak fariseo pach mak saduceo xtawtak riq'ui Kakaj Jesús, pero pireke triltak wi kes tz'et Kakaj Diosi' takowinakch re, xtz'onajtak re chi tran jun c'utb'i jcwinel Kakaj Dios ri tipe lecj. ");
INSERT INTO uspNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Pero Kakaj Jesús xij rechak: Atak cuando tib'e k'ij, tab'ijtak: Tieli' sak'j jwi'l pur quiek xe' caj, atche'tak. ");
INSERT INTO uspNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Y cuando tisakarsanc, tab'ijtak: Tipeti' nimaktak k'alaj jwi'l pur k'ek sutz'ke xe' caj, atche'tak. Atak awetamaki' tawiltak wi tieli' sak'j o tipeti' jab', pero ta' tach'ob'tak chirijak mak c'utb'ire ri tijin tawiltak la' mak junab' lajori. ");
INSERT INTO uspNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Yak cristian ri wi'tak wich ulew la' mak junab' lajori mas etzl jno'jak y ta' suc'ul ranmak chiwch Kakaj Dios tijtz'onajtak tib'an jono c'utb'i jcwinel Kakaj Dios chiwchak, pero chiwch rechak ta' chiqui' tib'ansaj jono c'utb'i jcwinel Kakaj Dios, xike ri xansaj chirij Jonás, xche' Kakaj Jesús. Cuando xijmaj jwi'l jilonli, xcan jye' mak cristian y xec'. ");
INSERT INTO uspNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Cuando xk'axtakb'i ch'akap re nimlaj alagun yak ajtijol rib'ak chirij Kakaj Jesucristo ta' xcuxtaj jwi'lak xc'amtakb'i jcuxlanwaak. ");
INSERT INTO uspNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Xpe Kakaj Jesús, xij rechak: Atak cwentij ayb'ak re man jch'amk'orak mak fariseo y mak saduceo, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Y yak ajtijol rib'ak chirij Kakaj Jesucristo xoctak chi jb'ij chirib'il rib'ak: Xij jilonli jwi'l ta' xcuxtaj kawi'l xkac'amch kacuxlanwa, xche'tak. ");
INSERT INTO uspNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Kakaj Jesús xretemaji' nen tijin tijb'ijtak chirib'il rib'ak xtz'onaj rechak: ¿Nen chac tab'ijtak chawib'il ayb'ak chi ta' acuxlanwaak? Atak ta' kes tz'et cub'ul ach'olak chwij. ");
INSERT INTO uspNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Atak ajqui' chatatak jcholajl ri tijin tamb'ij. ¿Ta'c'u ticuxtaj awi'lak jurub' chicach chi q'uertak cuxlanwa ri xac'oltak cuando xinjach job' cuxlanwa chiwchak job' mil (5,000) chi winak? ");
INSERT INTO uspNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Y, ¿ta'c'u ticuxtaj awi'lak jurub' chicach chi q'uertak cuxlanwa ri xac'oltak cuando xinjach wukub' (7) cuxlanwa chiwchak quejab' mil (4,000) chi winak? ");
INSERT INTO uspNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿Nen chac atak ta' tatatak jcholajl chi in ma' chirij ta' cuxlanwa tijin inyolow? In ximb'ij chi tike acwentij ayb'ak riq'ui man jch'amk'orak mak fariseo y mak saduceo, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Ajruc're' rechak xtatak jcholajl chi ma' chirij ta' ch'amk'or re cuxlanwa tiyolow Kakaj Jesús, chiriji' mak jc'utu'nak mak fariseo pach mak saduceo. ");
INSERT INTO uspNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Kakaj Jesús cuando xtaw lak luwar re Cesarea re Filipo, xtz'onaj rechak yak ajtijol rib'ak chirij: ¿Nenc'u li ri Jc'ajol Kakaj Dios ri xwux pi cristianil ri tijb'ijtak yak cristian? xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Rechak xijtak re: Wi' jujun tijb'ijtak chi ati' Juan Ajb'anal Ja'tiox. Y wi' jujun chic tijb'ijtak chi ati' Elías. Y wi' jujun chic tijb'ijtak chi ati' Jeremías o ati' jun ajk'asal Jyolj Kakaj Dios chic, xche'tak re. ");
INSERT INTO uspNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Y Kakaj Jesús xtz'onaj rechak yak ajtijol rib'ak chirij: Ruc' atak, ¿nenc'u in tab'ij atak? xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Xpe Simón Pedro, xij re Kakaj Jesús: Ati' ri b'il jwi'l Kakaj Dios chi tina jtaknach wich ulew ri Jc'ajol Kakaj Dios ri yo'l, xche' re. ");
INSERT INTO uspNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Kakaj Jesús xij re: Tzi awe at Simón ri jc'ajol Jonás, jwi'l ma' jun cristian ta'ke xye'w retemaj chawe, ri' Inkaj ri wi' lecj xye'w retemaj chawe. ");
INSERT INTO uspNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Y in tamb'ij chawe chi ati' Pedro ri chapca' ab'aj. Xatincoj pi ajc'amal jb'eak yak ri ticojowtak tzilaj jtaquil chwij. Y chib' man ab'aj li tamb'an wa'x wichoch. Y ta' chiqui' ticwin man camic chi jsachic jwichak yak ajtakeltak we. ");
INSERT INTO uspNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Laj ak'b' tanjach mak law re jtakon Kakaj Dios lecj y nen ta' tacuy jmac neri wich ulew, ta' ticuysaj jmac riq'ui Kakaj Dios lecj y nen ri tacuy jmac neri wich ulew, ticuysaji' jmac riq'ui Kakaj Dios lecj, xche' re Pedro. ");
INSERT INTO uspNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Ajruc're' Kakaj Jesús xij rechak yak ajtijol rib'ak chirij chi mi jyoltak rechak cristian chi ri' re ri b'il jwi'l Kakaj Dios chi tina jtaknach wich ulew. ");
INSERT INTO uspNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","La' mak k'ij li xcholch Kakaj Jesús chi jb'ij jcholajl rechak yak ajtijol rib'ak chirij chi re tina b'ena Jerusalén y tina b'ansajna c'ax re jwi'lak yak ri wi' rekle'nak chijxo'lak yak rijajl Israel y jwi'lak mak jb'ab'alak yak ajc'amaltak jb'eak cristian riq'ui Kakaj Dios y jwi'lak yak ajtijoltak cristian re Jpixb' Kakaj Dios. Tina camsajna, pero tina c'astasajna jwich laj jcamnakl laj jrox k'ij. ");
INSERT INTO uspNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Xpe Pedro, xc'amb'i Kakaj Jesús pi ric'an y xoc chi jk'elic, xij re: ¡Wajawl, miti titaw chiwch chapca' tijin tab'ij! xche' re. ");
INSERT INTO uspNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Pero Kakaj Jesús cow xril Pedro, xij re: ¡Elamb'i chinwch at jb'ab'al etzl! Tike ak'at inwch. At ta' tachomorsaj lawi' raj Kakaj Dios tran, xike tachomorsaj lawi' ri tijchomorsajtak cristian, xche' re. ");
INSERT INTO uspNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Ajruc're' Kakaj Jesús xij rechak yak ajtijol rib'ak chirij: Wi wi' jonok raj tioc pire ajtijol rib' chwij, rajwaxi' jk'ele' rib' chi jb'anic lawi' ri raj re tran. Rajwaxi' tina jtijna c'ax laj jc'aslemal y tixamb'er chwij. ");
INSERT INTO uspNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Nen jono cristian ta' raj tijye' rib' pi camic jwi'lke tran lawi' raj Kakaj Dios tran, tisaachi' jwich, pero nen tijye' rib' pi camic inwi'l in, ticolmaji'n. ");
INSERT INTO uspNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Ta' nen tichacuj jwi'l jun cristian trechb'ej juntir kelen re wich ulew wi pi reke tisaach jwich. Jun cristian ta' nen ticwin chi jye'ic chi jcolic ranm pire ma' tisaach jwich. ");
INSERT INTO uspNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Jwi'l cuando tipe Jc'ajol Kakaj Dios ri xwux pi cristianil nic' jnimal jk'ij pach Jkaj y tipe pach yak ranjl, ajruc're' tiyuk jye' jq'uixel rechak cristian chi jujunalak chirij ri b'anal jwi'lak. ");
INSERT INTO uspNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Tz'etel tz'et tamb'ij chawechak chi wi' jujun rechak yak cristian ri wi'tak wiq'uil neri, ta' ticamtak asta tina riltakna Jc'ajol Kakaj Dios ri xwux pi cristianil titakon chib'ak cristian, xche' Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Raj wakakib' (6) k'ij jb'ij jwi'l Kakaj Jesús jilonli, xe' b'a jun witz naj rak'aneb'. Xc'amb'i Pedro, Santiago y Juan ri jk'un Santiago, xtosb'i rib'ak pi ric'anak. ");
INSERT INTO uspNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Y cla' chiwchak xjalmaj rilic Kakaj Jesús, jcayb'al tichak kopopon chapca' rilic k'ij y ritz'ik xan sakb'ot. ");
INSERT INTO uspNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Etke xriltak jwich Moisés pach Elías tijintak chi yoloj riq'ui Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Xpe Pedro, xij re Kakaj Jesús: Wajawl, jor tzi wojtak neri. Wi chawaj, tamb'an uxib' chinam, jun pi awe at, jun pi re Moisés y jun pi re Elías, xche'. ");
INSERT INTO uspNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Aj tijini' Pedro chi jb'ij jilonli re Kakaj Jesús cuando xpe jun sutz' tikopoponc, xch'uk rijak. Ri'chak xtatak xaanch jun ch'a'wem li sutz', xij: Ri' ri lok'laj Inc'ajol ri sub'laj inqui'cot chirij, tatak jyolj, xche'ch. ");
INSERT INTO uspNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Yak ajtijol rib'ak chirij Kakaj Jesucristo cuando xtatak chi jilonli xijsajch, rechak xt'oj rib'ak pi jupul lak ulew jwi'l sub'laj xtzaak jch'olak. ");
INSERT INTO uspNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Xpe Kakaj Jesús, xjutun chijc'ulelak y xye' jk'ab' chib'ak, xij rechak: B'iitentak, mi tzaak ach'olak, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Y cuando yak ajtijol rib'ak chirij Kakaj Jesucristo xb'it jb'aak xna'tuntak, ta' chiqui' nen xriltak jwich, xichak Kakaj Jesús wa'l ric'an. ");
INSERT INTO uspNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Cuando kesaltakch wich witz, Kakaj Jesús xij rechak yak ajtijol rib'ak chirij: Ma yoltakna re ni jun cristian juntir ri xawiltak, ajri' tayoltak cuando jorok c'astasaji' jwich laj jcamnakl xo'lak camnakib' Jc'ajol Kakaj Dios ri xwux pi cristianil, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Xpe yak ajtijol rib'ak chirij Kakaj Jesucristo, xtz'onajtak re Kakaj Jesús: ¿Nen chac tijb'ijtak yak ajtijoltak cristian re Jpixb' Kakaj Dios chi rajwaxi' nab'e tipe Elías? xche'tak re. ");
INSERT INTO uspNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Kakaj Jesús xij rechak: Tz'eti' chi rajwaxi' tipe Elías nab'e pire tiyuk chi jb'anic jwa'x juntir. ");
INSERT INTO uspNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Pero in tamb'ij chawechak chi Elías xyuki'n y rechak ta' xch'ob'tak jwich y xana'taka' c'ax re chapca' rajak xantak re. Y jilon Jc'ajol Kakaj Dios ri xwux pi cristianil tina jtijna c'ax laj jk'ab'ak, xche' Kakaj Jesús rechak. ");
INSERT INTO uspNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Ajruc're' yak ajtijol rib'ak chirij Kakaj Jesucristo xtatak jcholajl chi chiriji' Juan Ajb'anal Ja'tiox tijin tiyolow Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Cuando xyuktak lamas wi'tak sub'laj q'ui cristian, xpe jun winak xjutun chijc'ulel Kakaj Jesús, xxucar chiwch y xij re: ");
INSERT INTO uspNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Wajawl, il c'ur jwich inc'ajol sub'laj c'ax wi'w, tijye' quiek'ek' re y q'uilaj b'welt titzaak li k'ak' y li ja'. ");
INSERT INTO uspNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Xinc'amch riq'uilak yak ajtijol rib'ak chawij, pero rechak ta' xcwintak chi jtzib'sajc, xche' re Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Kakaj Jesús xij rechak: Atak cristian ri ta' cub'ul ach'olak chirij Kakaj Dios y xike tab'antak mak etzltak no'j, ¿jurub'c'u k'ij rajwax inwa'xna aac'lak pire ticub'ar ach'olak chwij? ¿Jurub'c'u k'ij rajwax atna incuytakna jwi'l ta' ticub'ar ach'olak chwij? C'amtakch man c'ojol winak neri, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Kakaj Jesús xk'el man etzl ri wi' laj ranm man c'ojol winak y xresajb'ic y laj or xtzib' man c'ojol winak. ");
INSERT INTO uspNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Xpetak yak ajtijol rib'ak chirij Kakaj Jesucristo, xtz'onajtak re Kakaj Jesús pi ric'anak: ¿Nen chac ta' xojcwin oj chi resaj man etzl ri wi' laj ranm man c'ojol winak? xche'tak re. ");
INSERT INTO uspNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Kakaj Jesús xij chic rechak: Atak ta' kes cub'ul ach'olak chwij, jwi'li'li ta' xatcwintak chi resaj man etzl ri wi' laj ranm man c'ojol winak. Kes tz'et tamb'ij chawechak witi cub'ul ach'olak chwij chapca' jnimal jun ra b'ak' jwich mostas, atcwintaka' tab'ijtak re man witz ri: Elamb'i neri, jat li jun jalan luwar chic, atche'tak re. Y man witz tieli'b'ic. Ta' ni jun kelen ma' atcwintak chi jb'anic witi cub'ul ach'olak chwij. ");
INSERT INTO uspNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Pero mak etzl chapca' man ri, xike jun cristian ticwin chi resaj ri tich'a'w riq'ui Kakaj Dios y tran ayun, xche' Kakaj Jesús rechak yak ajtijol rib'ak chirij. ");
INSERT INTO uspNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Kakaj Jesús wo'cotic trantak Galilea pach yak ajtijol rib'ak chirij, Kakaj Jesús xij rechak: Jc'ajol Kakaj Dios ri xwux pi cristianil tina jachsajna laj jk'ab'ak mak cristian. ");
INSERT INTO uspNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Tina jcamsajtakna y laj jrox k'ij tina c'astasajna jwich laj jcamnakl, xche' rechak yak ajtijol rib'ak chirij. Rechak cuando xtatak chi jilonli xijsaj rechak sub'laj xb'isontak. ");
INSERT INTO uspNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Cuando xtawtak Kakaj Jesús Capernaúm pach yak ajtijol rib'ak chirij, xpetak mak ajtz'onaltak alcabar re nimi richoch Kakaj Dios xe'tak riq'ui Pedro y xtz'onajtak re: ¿Ton jtoja' alcabar pire nimi richoch Kakaj Dios Jerusalén ajtijol awechak? xche'tak re. ");
INSERT INTO uspNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Pedro xij: Tijtoja'n, xche' rechak. Cuando xocb'i Pedro la ja, xpe Kakaj Jesús nab'e xch'ab'ej y xtz'onaj re: ¿Nen tab'ij at Simón? ¿Nen quiek re tijtz'onajtak alcabar mak rey neri wich ulew? ¿Rechakni' yak jwinakak o rechak yak ri ma' jwinakak ta'n? xche' re Pedro. ");
INSERT INTO uspNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Pedro xij re: Rechak yak ri ma' jwinakak ta'n, xche' re. Kakaj Jesús xij chic re: Tz'eti'n, yak jwinakak ta' luwar tijtojtak alcabar, ");
INSERT INTO uspNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","pero pire tikab'an nen rajak, jat chi' nimlaj alagun, t'ojta li ja' ac'am ri wi' chapb'i car la' y man nab'e car ri tachap, teb'a' jchi' y laj jchi' tata'ch jun pwak. C'amb'ic y tatoj walcabar in pach awe at la', xche' Kakaj Jesús re Pedro. ");
INSERT INTO uspNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Cuando xantaj li, xpetak yak ajtijol rib'ak chirij Kakaj Jesucristo xjutuntak riq'ui Kakaj Jesús xtz'onajtak re: ¿Nen chike ri mas nim jk'ij lamas titakonwi' Kakaj Dios? xche'tak re. ");
INSERT INTO uspNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Xpe Kakaj Jesús, xsiq'uij jun ral ac'l y xwab'a' laj xo'lak y xij rechak: ");
INSERT INTO uspNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Kes tz'etel tz'et tamb'ij chawechak chi atak wi ta' tab'antak chapca' jun ral ac'l, ta' atoctak lamas titakonwi' Kakaj Dios. ");
INSERT INTO uspNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Man ri mas nim jk'ij lamas titakonwi' Kakaj Dios ri' man ri ta' tijcoj jk'ij chapca' man ral ac'l ri. ");
INSERT INTO uspNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Nen tic'uluw laj imb'j, jun ri ta' tijcoj jk'ij chapca' man ral ac'l ri, ini' injc'ul. ");
INSERT INTO uspNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Nen jun cristian ri tran chi yak ri ta' mas nimak jk'ijak ri cub'ul jch'olak chwij tikejtak li mac, ri' mas tzi tiximsajb'i jun nimlaj ab'aj re que'm chi jkul y tit'ojsajb'i li mar. ");
INSERT INTO uspNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","C'ur jwichak mak cristian ri retake wich ulew ri quiek jwi'l wi' sub'laj cristian tikejtak li mac. Wi'ke nen tib'anow re jun cristian tikej li mac, pero ri' mas c'ur jwich jun cristian ri tib'anow rechak cristian tikejtak li mac, jwi'l masna c'ax tijtij. ");
INSERT INTO uspNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Jwi'li'li wi ak'b' o awakan tib'anow chawe atkej li mac, c'urb'ic, t'ojb'i chinaj chawe. Ri' mas tzi junchak ak'b' o junchak awakan tata' tzilaj c'aslemal riq'ui Kakaj Dios lecj ri ta' jq'uisic chiwch chi quib' awakan o chi quib' ak'b' att'ojsajb'i li k'ak' ri ta' jchupic. ");
INSERT INTO uspNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Y wi b'ak' awch tib'anow chawe atkej li mac, esajb'ic, t'ojb'i chinaj chawe. Ri' mas tzi junchak b'ak' awch tata' tzilaj c'aslemal riq'ui Kakaj Dios lecj ri ta' jq'uisic chiwch chi quib' b'ak' awch att'ojsajb'i laj jk'ak'al man luwar re tijb'i c'ax, xche' Kakaj Jesús rechak yak ajtijol rib'ak chirij. ");
INSERT INTO uspNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Kakaj Jesús xij chic rechak yak ajtijol rib'ak chirij: Ma xuttak ni jono rechak yak ri ta' mas jcowil ranmak chwij. In tamb'ij chawechak chi yak ranjlak nojel k'ij wi'tak chiwch Inkaj lecj. ");
INSERT INTO uspNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Jwi'li'li Jc'ajol Kakaj Dios ri xwux pi cristianil xpe chi jcolicak yak ri sache'ltak. ");
INSERT INTO uspNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Tatak impuch tamb'ij chawechak. Wi wi' jun winak wi' jun cient (100) jcarner y wi xsach rib' jun rechak cuando tijin chi jyuk'ic, re tican jye' mak junmuch' b'elejlajuj (99) wich tak'j y tib'e chi jtoquic man jun ri xsach rib'. ");
INSERT INTO uspNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Y cuando tib'e jte'ch man carner ri xsach rib', kes tz'etel tz'et tamb'ij chawechak chi ri' mas tiqui'cot chirij man jun li chiwchak mak junmuch' b'elejlajuj (99). ");
INSERT INTO uspNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Y ji'c'ulon Akajak ri wi' lecj ta' raj tisaach ni jun rechak yak ri ta' mas jcowil ranmak chwij, xche' Kakaj Jesús rechak yak ajtijol rib'ak chirij. ");
INSERT INTO uspNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Kakaj Jesús xij rechak yak ajtijol rib'ak chirij: Wi wi' jono awech'elxic chwij tib'anow c'ax chawe, ch'ab'ej pi ric'an, b'ij re pi utzil chi xmacuni' chiwch Kakaj Dios y wi tzi tijta ayolj y tijq'uex jno'j, xatcwini' chi jk'asaj laj jk'ab' Kakaj Dios. ");
INSERT INTO uspNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Y wi ta' tijta lawi' ri tab'ij re pi awic'an, toc quib' o uxib' apach y atb'etak chic riq'uil pire tib'e jte'tak juntir ri tab'ij re chirij jmac. ");
INSERT INTO uspNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Y wi ta' ticojon chiwchak yak apach, b'ij rechak yak ajtakeltak we cuando mulb'em ayb'ak y wi ta' ticojon chiwchak yak ajtakeltak we, wa'xb'a' cla', b'an re chapca' jun cristian ri ta' tijcoj Jyolj Kakaj Dios o chapca' jun ajxutul lawi' ri tzi. ");
INSERT INTO uspNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Kes tz'etel tz'et tamb'ij chawechak, nen ta' tacuytak jmac neri wich ulew, ta' ticuysaj jmac riq'ui Kakaj Dios lecj y nen ri tacuytak jmac neri wich ulew, ticuysaji' jmac riq'ui Kakaj Dios lecj. ");
INSERT INTO uspNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Ri' ri, ri tamb'ij in chawechak: Wi wi' quib' chawechak tiniq'uib' jwichak neri wich ulew chi ch'a'wem riq'ui Inkaj lecj chi jtz'onaj nen rajwax rechak, Inkaj tijya' rechak. ");
INSERT INTO uspNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Jwi'l lamas wi'tak quib' o uxib' c'amem rib'ak laj imb'j, in wini' riq'uilak, xche' Kakaj Jesús rechak yak ajtijol rib'ak chirij. ");
INSERT INTO uspNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Xpe Pedro, xjutun riq'ui Kakaj Jesús y xtz'onaj re: Kajawl, ¿jurub'c'u b'welt rajwax tancuy jmac jun wech'elxic chawij cuando tran c'ax chwe? ¿Rajwaxni' tancuy jmac wukub' (7) b'welt? xche' re. ");
INSERT INTO uspNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Kakaj Jesús xij re Pedro: In ta' tamb'ij chawe chi wukub'ke (7) b'welt tacuy jmac jun awech'elxic chwij. In tamb'ij chawe chi rajwaxi' tacuy jmac nojel b'welt cuando tran c'ax chwe, xche' Kakaj Jesús re Pedro. ");
INSERT INTO uspNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Kakaj Jesús xij rechak yak ajtijol rib'ak chirij: Jtakon Kakaj Dios chib'ak cristian jilon chapca' xan jun rey. Man rey raj trajlaj jurub' jc'asak yak mocom riq'uil. ");
INSERT INTO uspNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Kes tz'akat tijchol rajlaj cuando xc'amsajch jun mocom riq'uil ri wi' lajuj (10) mil talento jc'as riq'uil. ");
INSERT INTO uspNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Pero man mocom li ta' nen quiek la' tijtojwi' jc'as. Xpe man rey xij chi tic'ayajb'i man mocom li pach rixokl, juntir ralc'wal y juntir kelen re ri wi' pire tojb'ire jc'as. ");
INSERT INTO uspNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Xpe man mocom li, xxucar chiwch man rey y xtz'onaj tok'ob' re: Kaj, cuy immac, quinawulb'ejna junquitz riq'ui inc'as. In tantoja' juntir inc'as aac'l, xche' re. ");
INSERT INTO uspNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Man rey xrila' c'ur jwich man mocom li y xcuya' jmac riq'ui jc'as, xtakb'ic y man winak xe' chi richoch. ");
INSERT INTO uspNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Pero man mocom li, cuando b'esal lak b'e, xc'ul jun rich mocom ri wi' jun cient (100) denario jc'as riq'uil. Xpe re, xchap chi jkul, xoc chi jjitz'aj y xij re: Toj ac'as wiq'uil, xche' re. ");
INSERT INTO uspNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Xpe man jun ri wi' jc'as riq'uil, xxucar chiwch y xtz'onaj tok'ob' re: Cuy immac, quinawulb'ejna junquitz riq'ui inc'as, in tantoja' juntir inc'as aac'l, xche' re. ");
INSERT INTO uspNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Pero re ta' raj xcuy jmac man rich mocom, xsiq'uij li k'atb'itzij y xtak li cars asta tina jtojna juntir jc'as riq'uil. ");
INSERT INTO uspNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Y mak nic'j mocom chic sub'laj xc'axc'ob' laj ranmak, xpe rechak xe' jb'ijtak re man rey juntir nen xansaj re sic' rich mocomak. ");
INSERT INTO uspNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Xpe man rey, xtak chic jsiq'uij man mocom ri xcuy jmac riq'ui jc'as y xij re: ¡At etzl mocom, in xincuya' amac riq'ui juntir ac'as wiq'uil jwi'l xatz'onaj jcuyic amac chinwch! ");
INSERT INTO uspNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Y at, ¿nen chac ta' xawil c'ur jwich jun awich mocom chapca' rilic c'ur awch at ximb'an? xche' re. ");
INSERT INTO uspNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Sub'laj xpe retzal man rey chirij, xtak jb'anic sub'laj c'ax re asta tina jtojna juntir jc'as riq'uil. ");
INSERT INTO uspNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Y jilonli tran chawechak Inkaj ri wi' lecj wi ta' tz'et nojel awanmak tacuytak jmac jun awech'elxicak chwij neri wich ulew, xche' Kakaj Jesús rechak yak ajtijol rib'ak chirij. ");
INSERT INTO uspNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Cuando xijmaj juntir li jwi'l Kakaj Jesús xelb'i Galilea, xe' lak luwar re Judea ri wi'tak ch'akap re nimi ja' Jordán. ");
INSERT INTO uspNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Sub'laj q'ui cristian xamb'ertak chirij cla' y xtzib'saj cristian ri yajtak. ");
INSERT INTO uspNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Xpetak nic'j fariseo, xjutuntak chijc'ulel Kakaj Jesús, ri' rajak tijtoctak jono jmac pire tikej laj jk'ab'ak y xtz'onajtak re: ¿Ton jya' luwar Jpixb' Kakaj Dios chi jun winak tijjachb'i rixokl wi ta' tzi tril ri tran? xche'tak re Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Kakaj Jesús xtz'onaj rechak: ¿Ta'c'u ilan awi'lak ri tz'ib'al li wuj re Lok'laj Jyolj Kakaj Dios ri xanow nab'e cristian wich ulew, winak pach anm xan? ");
INSERT INTO uspNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Cuando Kakaj Dios xij jilonri: Jwi'li'li jun winak cuando tic'uli'yc, tican jye' jkaj jchuch y tic'uli'y riq'ui rixokl y chi quib' rib'ilak tiwuxtak pi juntakchak chi cristian chiwch Kakaj Dios, xche'. ");
INSERT INTO uspNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Y Kakaj Jesús xij chic: Ma' quib'tak ta' chiqui'n, juntakchak chi cristian chiwch Kakaj Dios, jwi'li'li jun winak ta' luwar tijjach rixokl ri quiek riq'uil xc'ulb'aj jwi'l Kakaj Dios, xche' Kakaj Jesús rechak mak fariseo. ");
INSERT INTO uspNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Mak fariseo xtz'onajtak chic re Kakaj Jesús: ¿Nenc'u chac Moisés xya' luwar chi tijna' tijjach rixokl jun winak, xike man winak tijtz'ib'aj jun wuj re jachb'i ib'? xche'tak re Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Kakaj Jesús xij chic rechak: Tz'eti' xye' luwar Moisés chawechak tajach awixoklak jwi'li' atak pur ab'aj awanmak, pero cuando xticarch k'ijsak ta' ye'l luwar jwi'l Kakaj Dios. ");
INSERT INTO uspNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Pero in tamb'ij chawechak nen jono winak tijjach rixokl y wi ma' jwi'l ta' xechb'ej jwi'l jun jalan winak chic y wi man winak li tic'uli'y chic riq'ui jun jalan anm chic, chiwch Kakaj Dios tijin trechb'ej jun anm ri ma' jc'ulajl ta'n. Y nen jono winak chic tic'uli'y riq'ui man anm ri jachal, chiwch Kakaj Dios tijin trechb'ej jun anm chic ri ma' jc'ulajl ta'n, xche' Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Xpetak yak ajtijol rib'ak chirij Kakaj Jesucristo, xijtak re: Wi jilonli c'ax wi' chijxo'lak jun winak riq'ui rixokl ri' mas tzi ta' tic'uli'ytak yaltir, xche'tak. ");
INSERT INTO uspNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Kakaj Jesús xij chic rechak: Ma' juntir ta' ticwintak chi jtaic jcholajl ri ximb'ij, xike yak ri cha'ltak jwi'l Kakaj Dios. ");
INSERT INTO uspNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Q'uiyi' ri quiek jwi'l ta' tic'uli'ytak jujun cristian. Wi' jujun winak tiq'uisi'ytak ri nic' riq'uil capunaltak y wi' jujun chic capunaltake jwi'l cristian y wi' jujun chic ri'ke ta' rajak tic'uli'ytak jwi'l ri' rajak trantak laj jc'aslemalak lawi' raj Kakaj Dios trantak. Y nen raj tran jilonli, rane' laj jc'aslemal, xche' Kakaj Jesús rechak yak ajtijol rib'ak chirij. ");
INSERT INTO uspNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Jun k'ij nic'j cristian xc'amtakch ralc'walak riq'ui Kakaj Jesús pire tijye' jk'ab' laj jb'aak y tich'a'w riq'ui Kakaj Dios chirijak. Pero yak ajtijol rib'ak chirij Kakaj Jesucristo xk'eltak yak cristian ri c'amalch ralc'walak jwi'lak. ");
INSERT INTO uspNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Xpe Kakaj Jesús, xij rechak: Ma k'eltak, ye'tak luwar rechak tral ac'l tipetak wiq'uil jwi'l jtakon Kakaj Dios chib'ak cristian pirechi' yak ri jilontak chapca' tral ac'l, xche' Kakaj Jesús rechak. ");
INSERT INTO uspNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Cuando xye'maj jk'ab' Kakaj Jesús laj jb'aak tral ac'l, xelb'i cla'. ");
INSERT INTO uspNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Xpe jun c'ojol winak, xjutun riq'ui Kakaj Jesús xtz'onaj re: Ajtijonl, ¿nen chi tzilaj kelen lal rajwax tamb'an pire tanta' tzilaj c'aslemal riq'ui Kakaj Dios lecj ri ta' jq'uisic? xche' re. ");
INSERT INTO uspNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Kakaj Jesús xtz'onaj re: ¿Nen chac tatz'onaj chwe lawi' ri tzi? Xike wi' jun ri tzi. Wi chawaj tata' tzilaj c'aslemal riq'ui Kakaj Dios lecj ri ta' jq'uisic, b'an lawi' ri tijb'ij Jpixb' Kakaj Dios, xche' Kakaj Jesús re man c'ojol winak. ");
INSERT INTO uspNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Man c'ojol winak xtz'onaj re Kakaj Jesús: ¿Nen chi pixab' lal tab'ij? xche' re. Kakaj Jesús xij re: Mat camsanc, ma wechb'ej jun jalan cristian wi ma' ac'ulajl ta'n, mat alk'anc, ma mol tzij chirij jun cristian, ");
INSERT INTO uspNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","coj jk'ij akaj achuch y lok'aj awijl atz'akt chapca' jlok'aj ayb' tab'an, xche' Kakaj Jesús re man c'ojol winak. ");
INSERT INTO uspNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Man c'ojol winak xij re Kakaj Jesús: Juntir li b'anali' inwi'l. ¿Nen mas rajwax tina imb'anna? xche' re. ");
INSERT INTO uspNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Kakaj Jesús xij chic re man c'ojol winak: Wi chawaj tatz'akatsaj jb'anic juntir chiwch Kakaj Dios, jat, c'ayta juntir kelen awe ri wi' y man rijil tajach chiwchak yak ri wi' rajwax rechak. Jilonli tiwa'xi' sub'laj utzil pi awe riq'ui Kakaj Dios lecj pi jq'uexwach ab'iomil y ajruc're' atpe wiq'uil pire atxamb'er chwij, xche' Kakaj Jesús re. ");
INSERT INTO uspNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Man c'ojol winak, cuando xta chi jilonli xijsaj re, sub'laj b'is jwich xec', jwi'l sub'laj b'iomi'n. ");
INSERT INTO uspNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Cuando xril Kakaj Jesús chi jilonli, xij rechak yak ajtijol rib'ak chirij: Kes tz'etel tz'et tamb'ij chawechak chi sub'laj c'axi' roquic jun b'iom lamas titakon Kakaj Dios chib'ak cristian. ");
INSERT INTO uspNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Tanca'mulaj chic jb'ij chawechak: Ri' ta' mas c'ax jk'axic jun camello laj b'ak' jwich jun acux chiwch roquic jun b'iom laj jk'ab' Kakaj Dios pire titakon chib', xche' Kakaj Jesús rechak yak ajtijol rib'ak chirij. ");
INSERT INTO uspNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Yak ajtijol rib'ak chirij Kakaj Jesucristo, cuando xtatak chi jilonli xij Kakaj Jesús rechak, sub'laj xsaach jch'olak, xijtak chirib'il rib'ak: Wi jilonli, ta' ni jun ticolmaj laj jk'ab' jmac, xche'tak. ");
INSERT INTO uspNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Cow xilsajtak jwi'l Kakaj Jesús y xij rechak: Pi rechak cristian ta' ni jonok ticwin chi jb'anic, pero Kakaj Dios ta' ni jun kelen ma' ticwin chi jb'anic, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Pedro xij re Kakaj Jesús: Oj xcani' kaye' juntir kelen ke ri wi' y xojxamb'eri' chawij. ¿Nenc'u tiye'saj chike oj? xche' re Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Kakaj Jesús xij rechak: Kes tz'etel tz'et tamb'ij chawechak cuando titaw k'ij tiq'uexsaj juntir kelen wich ulew, Jc'ajol Kakaj Dios ri xwux pi cristianil sub'laj nim jk'ij ticub'ar li man cub'arb' lamas titakonwi'. Y atak ri atxamb'ernaktak chwij, atcub'artak chib'ak mak cab'lajuj (12) cub'arb' chi jb'anic k'atb'itzij chib'ak yak cab'lajuj (12) k'at rijajl Israel. ");
INSERT INTO uspNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Juntir yak ri tican jye' richochak, jk'un ratzak, ranab'ak, jkaj jchuchak, ralc'walak o rulewak inwi'lke in, tijc'ula'taka' sub'laj nim jq'uixel chapca' ri xcan jye'tak y tijta'taka' tzilaj c'aslemal riq'ui Kakaj Dios lecj ri ta' jq'uisic. ");
INSERT INTO uspNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Pero sub'laj q'ui ri nab'etak lajori jwi'l nim jk'ijak, ri'taka' ticantak pi q'uisb'ire jwi'l ta' chiqui' ticojsaj jk'ijak. Y sub'laj q'ui ri q'uisb'ire lajori jwi'l ta' cojol jk'ijak, ri'taka' tinab'ertak jwi'l tina cojsajna jk'ijak, xche' Kakaj Jesús rechak yak ajtijol rib'ak chirij. ");
INSERT INTO uspNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Kakaj Jesús xij chic: Jtakon Kakaj Dios chib'ak cristian jilon chapca' xan jun patron ri xelb'i ak'ab' chi jtoquic nic'j mocom pire tichacuntak riq'uil chi jtoquic uva. ");
INSERT INTO uspNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Xchomorsaj riq'uilak yak mocom chi jujun denario tijye' rechak re jun k'ij chi chac y xtaktakb'i chi tocoj uva. ");
INSERT INTO uspNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Y man patron raj laj b'elejeb' (9) or re ak'ab' xel chicb'ic, xe' li c'ayb'l y cla' xta' chic nic'j cristian ri ta' jchacak. ");
INSERT INTO uspNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Man patron xij rechak: Jattak li chac wiq'uil chi tocoj uva y in twila' jcholajl atojb'lak, xche' rechak mak cristian. Y mak cristian xe'tak li chac riq'uil. ");
INSERT INTO uspNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Man patron xe' chic li c'ayb'l raj laj cab'lajuj (12) or re nic'aj k'ij y xe' chic raj laj jrox or re b'esal k'ij, xe' jte' chic nic'j cristian y xij rechak chi tib'etak li chac riq'uil chi tocoj uva. ");
INSERT INTO uspNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Y raj laj jjo' or re b'esal k'ij, xel chicb'i man patron xe' chic li c'ayb'l, xe' jte' chic nic'j cristian ri ta' jchacak, re xtz'onaj rechak: ¿Nen chac nerike watak jun k'ij y ta' chac tab'antak? xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Y rechak xijtak re man patron: Jwi'l ta' nen sujuwinak kachc, xche'tak. Y man patron xij chic rechak: Jattak li chac wiq'uil chi tocoj uva, xche' rechak. Y rechak xe'tak. ");
INSERT INTO uspNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Y cuando xoc uku'm, xpe man patron xij re man jun ri wi' pi jb'ab'al mocom: Siq'uijb'i juntir mak mocom, ye'b'i jtojb'lak. Ri' nab'e tachol jtojicak yak ri xoctak li chac b'esal k'ij y pi q'uisb'ire tatoj yak ri xoctak ak'ab', xche' re. ");
INSERT INTO uspNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Y mak mocom ri xoctak li chac laj jjo' or re b'esal k'ij xye'sajb'i jujun denario rechak. ");
INSERT INTO uspNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Y pi q'uisb'ire xtojsajtak yak ri xoctak li chac nab'e. Rechak ri' chijch'olak titojsajtaka' mas chiwchak yak nic'j jwi'l ak'ab'i' xoctak li chac, pero cuando xtojsajtak jujun denarioke xye'saj rechak. ");
INSERT INTO uspNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Cuando xc'ulmaj jtojb'lak jwi'lak xoctak chi yok'on chirijil man patron. ");
INSERT INTO uspNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Xpetak, xijtak re man patron: Mak nic'j b'esalchak k'ij xoctak li chac, jun orke xchacuntak y nic'ke katojic xab'an y oj jun k'iji' xojchacunc y xkacuya' juntir jk'ak'al k'ij, xche'tak re man patron. ");
INSERT INTO uspNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Man patron xij re jun rechak mak mocom: At wichc'ulchi', in ta' ni jun kelen ximb'an chawe ri ma' jcholajl ta'n. Xkachomorsaji'ca' aac'l chi jun denario tantoj ak'ij. ");
INSERT INTO uspNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","C'amb'i atojb'l. In iniliw jcholajl wi tanye'b'i jtojb'lak yak nic'j ri xoctak li chac b'esal k'ij, nic' chapca' tanye' chawe at, ");
INSERT INTO uspNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","jwi'l ini' iniliw jcholajl nen tamb'an riq'ui impwaak. At tipe awetzal chi rilic jwi'l tzi inno'j riq'uilak cristian, xche' man patron re man mocom, xche' Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Y Kakaj Jesús xij chic rechak yak ajtijol rib'ak chirij: Jwi'li'li yak ri q'uisb'ire lajori ri ta' cojol jk'ijak ri'taka' tinab'ertak jwi'l tina cojsajna jk'ijak. Y yak ri nab'etak lajori ri nim jk'ijak ri'taka' ticantak pi q'uisb'ire jwi'l ta' ticojsaj jk'ijak, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Kakaj Jesús cuando b'esaltak lak b'e pach yak ajtijol rib'ak chirij pire tib'etak Jerusalén, xsiq'uij yak cab'lajuj (12) pi ric'anak y xij rechak: ");
INSERT INTO uspNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","Lajori ojb'etak Jerusalén, cla' tijachsaj Jc'ajol Kakaj Dios ri xwux pi cristianil laj jk'ab'ak mak jb'ab'alak yak ajc'amaltak jb'eak cristian riq'ui Kakaj Dios y laj jk'ab'ak yak ajtijoltak cristian re Jpixb' Kakaj Dios. Rechak tijtz'onajtak k'atb'itzij chirij pire ticamsajc. ");
INSERT INTO uspNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Y tijjachtak laj jk'ab'ak yak ma' rijajl ta' Israel pire tritz'b'ejtak jwich, tijsec'tak y tijcamsajtak wich curs, pero laj jrox k'ij tina c'astasajna jwich laj jcamnakl, xche' Kakaj Jesús rechak yak ajtijol rib'ak chirij. ");
INSERT INTO uspNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Xpe rixokl Zebedeo pach yak quib' ric'lal, xjutun riq'ui Kakaj Jesús y xxucar chiwch chi jtz'onaj jun tok'ob' re. ");
INSERT INTO uspNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Kakaj Jesús xtz'onaj re: ¿Nen chawaj? xche' re anm. Y anm xij: Cuando attakon chib'ak cristian, ye' luwar chi yak wic'lal ticub'artak aac'l, jun ticub'ar laj apaach y jun ticub'ar laj amax, xche' re Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Kakaj Jesús xij rechak: Atak ta' awetamak nen attijintak chi jtz'onaj chwe. ¿Tonc'u acuya'taka' c'ax chapca' ri tina intijna in? xche' rechak. Rechak xijtak: Tikacuya'n, xche'tak. ");
INSERT INTO uspNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Kakaj Jesús xij chic rechak: Atak tacuya'taka' c'ax chapca' ri tina intijna in, pero ta' ye'l luwar chwe chi jcha'ic nen ticub'ar laj impaach o laj immax, jwi'l ri' tiye'saj rechak yak ri cha'ltak jwi'l Inkaj, xche' Kakaj Jesús rechak. ");
INSERT INTO uspNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Yak lajuj (10) ajtijol rib'ak chirij Kakaj Jesucristo cuando xtatak nen xijsaj re Kakaj Jesús, xpe retzalak chirijak yak quib' ri jk'un ratz rib'ak. ");
INSERT INTO uspNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Pero xpe Kakaj Jesús xsiq'uij yak ajtijol rib'ak chirij y xij rechak: Atak awetamaki' chi mak jb'ab'al jk'atb'itzijak yak ma' rijajl ta' Israel tijchomorsajtak chi wi' mas takon laj jk'ab'ak chib'ak yak jwinakak y mak nimaktak jb'ab'alak titakontaka' chib'ak. ");
INSERT INTO uspNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Pero chaxo'l atak, ma' ji'ta'lonli. Chaxo'l atak, nen raj ticojsaj jk'ij rajwaxi' rane' lawi' ri rajwax jb'anic pi rechak nic'j chic. ");
INSERT INTO uspNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Y wi wi' jono chawechak raj tioc pire b'ab'al, rajwaxi' tijye' rib' chi takem re juntir jpach chapca' jun cristian ri wi' rajw. ");
INSERT INTO uspNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Jilon chapca' xan Jc'ajol Kakaj Dios ri xwux pi cristianil, ta' xpe wich ulew pire tib'ansaj re lawi' ri raj re. Re xpe wich ulew pirechi' tiyuk rane' lawi' ri rajwax rechak cristian y tiyuk jache' rib' pi camic chi jcolicak sub'laj cristian laj jk'ab' jmacak, xche' Kakaj Jesús rechak yak ajtijol rib'ak chirij. ");
INSERT INTO uspNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Cuando xeltakb'i Kakaj Jesús Jericó pach yak ajtijol rib'ak chirij sub'laj q'ui cristian xamb'ertakb'i chirijak. ");
INSERT INTO uspNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Xpetak quib' moy ri cub'ultak chi' b'e, xtatak chi tijin tik'ax Kakaj Jesús chijc'ulelak, xch'ejejtak, xijtak: ¡Jc'ajol David, il c'ur kawch! xche'tak. ");
INSERT INTO uspNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Xpetak mak cristian, xk'eltak yak moy, xijtak rechak chi mi ch'a'wtak chic. Pero rechak sub'laj cow xch'ejejtak chic, xijtak: ¡Kajawl, Jc'ajol David, il c'ur kawch! xche'tak. ");
INSERT INTO uspNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Kakaj Jesús xwa'rc, xsiq'uijtakb'ic y xtz'onaj rechak: ¿Nen chawajak tamb'an chawechak? xche' rechak, ");
INSERT INTO uspNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Rechak xijtak: Kajawl, chikaj ojna'tun chic, xche'tak re Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Kakaj Jesús xril c'ur jwichak y xchap b'ak' jwichak y laj or xna'tuntak chic y xamb'ertakb'i chirij Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Cuando xtawtak chi nakaj re Jerusalén, wi'takchak Betfagé wich witz ri jb'ij Olivos. Kakaj Jesús xtakb'i quib' rechak yak ajtijol rib'ak chirij, ");
INSERT INTO uspNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","xij rechak: Jattak li man tilmit ri wi'b'i chawchak, cla' tib'e ate'tak jun ixok b'ur ximil y wi' jun ra jk'un riq'uil. Quirtakch man b'ur pach ra jk'un y c'amtakch. ");
INSERT INTO uspNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Wi wi' nen atch'ab'entak chirijak, b'ijtak re: Tike chocon jwi'l Kajawl y laj orke tiyuk jk'asaj, atche'tak re, xche' Kakaj Jesús rechak. ");
INSERT INTO uspNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Jilonli xan pire xtaw chiwch ri xcan jtz'ib'aj jun ajk'asal Jyolj Kakaj Dios ri tijb'ij jilonri: ");
INSERT INTO uspNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","B'ijtak rechak yak aj Sión: Iltak areyak petzal aac'lak y ta' tijcoj jk'ij, quejal jun ra b'ur jwi'l, tiche'. ");
INSERT INTO uspNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Xpetak yak quib' ajtijol rib'ak chirij Kakaj Jesucristo, xe'tak y xe' rane'tak chapca' xijsaj rechak. ");
INSERT INTO uspNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Xc'amtakch man ixok b'ur pach man ra jk'un, xye'takb'i ritz'ikak ri tijk'u'jtak chirij ra k'un b'ur y Kakaj Jesús xquejajb'ic. ");
INSERT INTO uspNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Y sub'laj q'ui cristian b'esaltak chirij, wi' nic'j xlic' ritz'ikak ri tijk'u'jtak laj b'e y nic'j chic xc'urtak xak che' y xye'tak laj jb'e. ");
INSERT INTO uspNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Cristian ri nab'etak pach ri tixamtak chirij Kakaj Jesús xoctak chi ch'ejejem, xijtak: ¡Nim jk'ij Jc'ajol David! ¡Kakaj Dios ri Kajawl wi' jk'ab' chib' ri petzal laj jb'ij! ¡Nim jk'ij Kakaj Dios lecj! xche'tak. ");
INSERT INTO uspNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Cuando xoc Kakaj Jesús Jerusalén juntir cristian xsaach jch'olak y sub'laj cristian xtz'onajtak chirib'il rib'ak: ¿Nen chiqui' chi winak lal ri? xche'tak. ");
INSERT INTO uspNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Y nic'j cristian xijtak: Ri' Jesucristo ri ajk'asal Jyolj Kakaj Dios ri aj Nazaret ri jun tilmit re Galilea, xche'tak. ");
INSERT INTO uspNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Kakaj Jesús xoc li nimi richoch Kakaj Dios y xruktajb'i mak ajc'ayb' pach mak ajlok'omanl ri wi'tak cla'. Xsolcopij mak jmexak mak ajq'uexeltak pwak ri wi'tak cla' pach mak jtemak mak ajc'ayaltak ut. ");
INSERT INTO uspNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Y xij rechak: Tz'ib'ali' li wuj re Lok'laj Jyolj Kakaj Dios ri tijb'ij jilonri: Wichoch rechi' lamas tib'an ch'a'wem wiq'uil, xche' Kakaj Dios, tiche'. Pero atak cojol pi molb'i rib'ak alk'om awi'lak, xche' Kakaj Jesús rechak. ");
INSERT INTO uspNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Xpetak yak moy pach yak co'x xtawtak riq'ui Kakaj Jesús li nimi richoch Kakaj Dios y xtzib'sajtaka' jwi'l Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Pero mak jb'ab'alak yak ajc'amaltak jb'eak cristian riq'ui Kakaj Dios pach yak ajtijoltak cristian re Jpixb' Kakaj Dios sub'laj xpe retzalak cuando xriltak mak nimaktak c'utb'i jcwinel Kakaj Dios ri xan y xtatak tich'ejejtak mak tral ac'l li nimi richoch Kakaj Dios ri tijb'ijtak: ¡Nim jk'ij Jc'ajol David! tiche'tak. ");
INSERT INTO uspNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Rechak xtz'onajtak re Kakaj Jesús: ¿Ton ata' nen tijin tijb'ijtak mak tral ac'l? xche'tak re. Kakaj Jesús xij rechak: Tanta'n. ¿Ta'c'u ilan awi'lak li wuj re Lok'laj Jyolj Kakaj Dios ri tijb'ij jilonri? At xab'an chi la' jb'ixak mak tral ac'l ri aj nuch'tak pach mak tral ac'l aj tijin titu'ntak tib'ixaj jnimirsaj ak'ij, tiche', xche' Kakaj Jesús rechak. ");
INSERT INTO uspNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Kakaj Jesús xcan jye' mak cristian cla' xe' Betania, cla' xe' wa'xok lak'ab'. ");
INSERT INTO uspNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Ak'ab' laj jcab' k'ij Kakaj Jesús xk'aj chic Jerusalén, cuando b'esal lak b'e xc'ok jwi'l wi'jal. ");
INSERT INTO uspNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Xrilb'i chi wi' jun jche'l higo chi' b'e. Xe' rile' wi wi' jwich, pero ta' ni jono jwich xe' jte'. Jwi'li'li xch'ab'ej man jche'l higo, xij re: Ni jun b'welt atwichin chic, xche' re. Y laj or xchekej man che'. ");
INSERT INTO uspNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Yak ajtijol rib'ak chirij Kakaj Jesucristo, cuando xriltak xchekej man jche'l higo, sub'laj xsaach jch'olak xtz'onajtak re Kakaj Jesús: ¿Nen chac laj or xchekej man jche'l higo? xche'tak re. ");
INSERT INTO uspNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Kakaj Jesús xij rechak: Kes tz'etel tz'et tamb'ij chawechak, atak wi kes tz'et cub'ul ach'olak chirij Kakaj Dios y ta' tran quib' awanmak, ma' xita'ke atcwintak chi jb'anic chapca' ximb'an in re man jche'l higo. Atak wi tab'ijtak re man witz ri: Elamb'i cla', t'ojta ayb' li mar, atche'tak re, ticojoni' chawchak. ");
INSERT INTO uspNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Juntir nen chawajak tatz'onajtak cuando atch'a'wtak riq'ui Kakaj Dios wi kes tz'et cub'ul ach'olak chirij Kakaj Dios, tacula'taka'n, xche' Kakaj Jesús rechak yak ajtijol rib'ak chirij. ");
INSERT INTO uspNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Kakaj Jesús xocb'i li nimi richoch Kakaj Dios. Cuando tijin chi jtijoj cristian cla', xpetak mak jb'ab'alak yak ajc'amaltak jb'eak cristian riq'ui Kakaj Dios pach yak ri wi' rekle'nak chijxo'lak yak rijajl Israel xjutuntak chijc'ulel Kakaj Jesús y xtz'onajtak re: ¿Nenc'u xattakow chi jb'anic jilonli? ¿Nen xye'w k'atb'itzij laj ak'b' pire tab'an jilonli? xche'tak re. ");
INSERT INTO uspNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Kakaj Jesús xij rechak: Jilon in chwaj tantz'onaj jun kelen chawechak: Wi tac'ululajtak inyolj, tamb'iji' chawechak nen xye'w k'atb'itzij laj ink'b' pire tamb'an jilonli. ¿Nenc'u xtakow re Juan Ajb'anal Ja'tiox chi jb'anic ja'tiox? ¿Kakaj Diosni' xtakow re o cristianke? xche' Kakaj Jesús rechak. ");
INSERT INTO uspNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Rechak xoctak chi jchomorsaj chirib'il rib'ak nen tijb'ijtak, xijtak: Wi tikab'ij re chi Kakaj Dios xtakowch re Juan Ajb'anal Ja'tiox, li tijb'iji' chike: ¿Nenc'u chac ta' xacojtak jyolj? tiche'. ");
INSERT INTO uspNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Tike tzaak kach'ol pent wi' nen trantak cristian chike wi tikab'ij chi cristianke takowinak re, jwi'l rechak tijb'ijtak chirij Juan Ajb'anal Ja'tiox chi ajk'asal Jyolji' Kakaj Dios, xche'tak. ");
INSERT INTO uspNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Jwi'li'li xijtak re Kakaj Jesús: Ta' ketam nen takowinakch re, xche'tak. Kakaj Jesús xij chic rechak: Jilon in ta' tamb'ij chawechak nen xye'w k'atb'itzij laj ink'b' chi jb'anic jilonli, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Kakaj Jesús xtz'onaj chic rechak: ¿Nen tab'ij atak chirij ri xantak quib' alc'walixelb'? Wi' jun winak wi' quib' jc'ajol. Xpe winak li, xij re man nab'eal: At inc'ajol, jat li chac lak uva, xche' re. ");
INSERT INTO uspNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Man jc'ajol li xij: Ta' chwaj imb'ec, xche'. Pero chi usil xq'uex jno'j y xe' li chac. ");
INSERT INTO uspNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Y xpe man winak li, xe' chic riq'ui man jcab'al y xij re chapca' xij re man nab'eal y man jcab'al xij: Tziyi' li, tat, imb'i'n, xche'. Pero ta' tz'et xec'. ");
INSERT INTO uspNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","¿Nenc'u rechak mak quib' xanowtak lawi' raj jkajak trantak? xche' Kakaj Jesús rechak. Rechak xijtak re Kakaj Jesús: Ri' man nab'eal, xche'tak. Kakaj Jesús xij chic rechak: Kes tz'etel tz'et tamb'ij chawechak chi ri' mak ajtz'onaltak alcabar re Roma pach mak tz'i'taklaj anm tioctak nab'e lamas titakonwi' Kakaj Dios chib'ak cristian chawch atak, ");
INSERT INTO uspNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","jwi'l Juan Ajb'anal Ja'tiox xyuki' jb'ij chawechak nen rajwax tab'antak laj ac'aslemalak pire tran suc'ul awanmak chiwch Kakaj Dios. Pero atak ta' xacojtak jyolj y yak ajtz'onaltak alcabar pach mak tz'i'taklaj anm xcoja'taka'n. Atak onque xawila'taka' juntir li, pero ta' xaq'uex ano'jak pire tab'antak lawi' raj Kakaj Dios tab'antak, xche' Kakaj Jesús rechak. ");
INSERT INTO uspNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Kakaj Jesús xij chic rechak: Tatak jcholajl jun esb'i no'j chic jilonri, wi' jun winak xtic uva laj rulew y xcoj corral chirij. Xc'ot jun luwar lamas xan man yetz'b'i uva y xan jun ja naj rak'aneb' pire tijchajaj jtico'n. Ajruc're' xcan jye' man rulew li chi kejom rechak nic'j ajchac y xe' chinaj li jun jalan tilmit chic. ");
INSERT INTO uspNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Cuando xtaw k'ij tik'anab' jwichak mak uva, xpe man rajw ulew xtakch nic'j jtako'n riq'uilak chi jtz'onaj rechak mak ajkejeltak ulew lawi' mak jwich uva ri tiye'saj re pire kejb'ire man ulew. ");
INSERT INTO uspNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Pero xpetak mak ajkejeltak ulew xchaptak mak tako'n li, jun xch'i'tak, jun xcamsajtak y jun chic xcamsajtak chi ab'aj. ");
INSERT INTO uspNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Xpe man rajw ulew, xtak chicch mas jtako'n chiwch nab'e b'welt chi jtz'onaj rechak mak ajkejeltak ulew lawi' mak jwich uva ri tiye'saj re pire kejb'ire man ulew. Pero mak ajkejeltak ulew xantak chicb'i rechak chapca' xantak re yak nic'j. ");
INSERT INTO uspNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Ajruc're' man rajw ulew xtakch jc'ajol chi jtz'onaj rechak lawi' mak jwich uva ri tiye'saj re pire kejb'ire man ulew jwi'l xchomorsaj chi ticojontaka' chiwch jc'ajol. ");
INSERT INTO uspNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Pero mak ajkejeltak ulew cuando xriltak xtaw jc'ajol man rajw ulew xijtak chirib'il rib'ak: Ri' re tiechb'en man ulew, lajori kacamsajtak pire tican man ulew ri pi ke oj, xche'tak mak ajkejeltak ulew. ");
INSERT INTO uspNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Xpetak, xchaptak, xresajtakb'i lak uva y xcamsajtak. ");
INSERT INTO uspNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Y cuando tipe man rajw ulew, ¿nenc'u tran rechak mak ri kejewinaktak man ulew? xche' Kakaj Jesús rechak. ");
INSERT INTO uspNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Rechak xijtak: Ta' chiqui' c'ax laj ranm tijcamsajtak mak etzltak ajkejeltak ulew li. Y tijye' chic rulew chi kejom rechak nic'j ajchac chic ri tijye'tak jwich uva pire kejb'ire man ulew cuando titaw k'ij tik'anab' jwichak mak uva, xche'tak re Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Kakaj Jesús xtz'onaj chic rechak: ¿Ta'c'u ilan awi'lak li wuj re Lok'laj Jyolj Kakaj Dios ri tijb'ij jilonri? Man ab'aj ri xcan jxute'tak yak ajb'analtak ja, ri' xoc pire man nab'e ab'aj pire jcowil man ja. Jilonli xan Kakaj Dios ri Kajawl y sub'laj ojqui'cot chirij, tiche'. ");
INSERT INTO uspNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Jwi'li'li in tamb'ij chawechak chi Kakaj Dios ta' chiqui' titakon chab'ak, ri'chak titakon chib'ak jalan cristian chic ri tijye'tak jwich tico'n pire kejb'i rulew man rajw ulew. ");
INSERT INTO uspNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Nen titzaak chib' man ab'aj li, tik'ajmaji'n. Y nen titzaak man ab'aj li chib', trana' pok, xche' Kakaj Jesús rechak. ");
INSERT INTO uspNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Cuando mak jb'ab'alak yak ajc'amaltak jb'eak cristian riq'ui Kakaj Dios pach mak fariseo xtatak jcholajl chi Kakaj Jesús tijin tijb'ij mak esb'i no'j li chirijaki' rechak, ");
INSERT INTO uspNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","sub'laj xpe retzalak rajak roj xchape'takb'i Kakaj Jesús. Pero tike tzaak jch'olak jwi'l sub'laj q'ui cristian retamaki' chi ajk'asal Jyolji' Kakaj Dios. ");
INSERT INTO uspNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Kakaj Jesús xoc chic chi yoloj riq'uilak mak cristian li la' nic'j esb'itak no'j, xij rechak: ");
INSERT INTO uspNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","Jtakon Kakaj Dios chib'ak cristian jilon chapca' xan jun rey ri xan jun nimak'ij cuando xc'uli'y jc'ajol. ");
INSERT INTO uspNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Re xtak mak jtako'n chi jsiq'uijcak yak ri quiek re xijwi' chi tipetak riq'uil chi wic', pero rechak ta' rajak xpetak. ");
INSERT INTO uspNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Xtak chicb'i nic'j jtako'n chic, xijb'i rechak: B'ij rechak chi xantaji' kaw. Xintaka' jcamsaj inwacx pach wawj ri chak'sal inwi'l y lajori jo'tak, tijtatak wa, atche'tak rechak, xche' re mak jtako'n. ");
INSERT INTO uspNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Pero mak cristian ta' rajak xe'tak riq'uil li nimak'ij. Jun rechak xe' chi jsolaj rulew y jun chic xe' chi c'ayinc. ");
INSERT INTO uspNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Y mak nic'j chic xchaptak mak jtako'n man rey xsec'tak y xcamsajtak. ");
INSERT INTO uspNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Man jb'ab'al k'atb'itzij sub'laj xpe retzal chirijak mak ri xcamsan rechak mak jtako'n, jwi'li'li xtak mak jsoldad chi jcamsajcak y xtak jc'atic jtilmitak. ");
INSERT INTO uspNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Xij rechak mak nic'j jtako'n chic: Juntir kelen ri tichocon re man nimak'ij re man c'ulniquil xantaji'n, pero mak cristian ri siq'uiltak ta' tic'ular rechak tipetak li man nimak'ij. ");
INSERT INTO uspNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Lajori jattak xo'lak b'e, juntir mak ri tata'tak, b'ijtak rechak chi tipetak li man nimak'ij re c'ulniquil, xche' rechak mak jtako'n. ");
INSERT INTO uspNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Y mak jtako'n xe'tak xo'lak b'e, xe' jsiq'uijtakch juntir cristian ri wi'tak xo'lak b'e chi tzi jno'jak y chi mita' tzi jno'jak. Jilonli xnoj man ja chi cristian. ");
INSERT INTO uspNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Cuando xocb'i man rey la ja chi rilicak mak ri siq'uiltak li nimak'ij, xril chi wi' jun winak cla' ta' cojol ritz'ik jwi'l re c'ulniquil. ");
INSERT INTO uspNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Xtz'onaj re: At wichc'ulchi', ¿nen chac xatocch neri wi mita' xacojch awitz'ik re c'ulniquil? xche' re. Y man winak li ta' chiqui' xch'a'wc. ");
INSERT INTO uspNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Xpe man rey, xij rechak mak ri tijintak chi jjachic wa: Ximtak rakan pach jk'ab', esajtakb'i lak uku'm rij ja. Cla' tib'e rok'b'ej rib' y tijkuch'uch'uj ree. ");
INSERT INTO uspNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Sub'laj q'ui ri siq'uiltak, pero quib' uxib'ke ri cha'ltak, xche' Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Cuando xantaj jb'ij jilonli jwi'l Kakaj Jesús, mak fariseo xe'tak y xniq'uib' jwichak, xchomorsajtak nen tijb'ijtak re Kakaj Jesús jwi'l ri' rajak chirijke jyolj tikej laj jk'ab'ak pire tijcojtak tzij chirij. ");
INSERT INTO uspNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Xtaktakb'i nic'j ajtijol rib'ak chirijak pach nic'j rechak mak jpach Herodes Antipas, xe' jb'ijtak re Kakaj Jesús jilonri: Ajtijonl, oj ketami' chi tz'etel tz'eti' ri tab'ij y tz'etel tz'eti' ri tijin tatijoj cristian pire trantak lawi' raj Kakaj Dios trantak y ta' jaljoj rilic cristian tab'an. ");
INSERT INTO uspNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","B'ij chike: ¿Tzini' tikatoj alcabar re César o ta'n? xche'tak re Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Kakaj Jesús retami' mak etzltak jchomorsa'nak, jwi'li'li xij rechak: Atak ajsolcopil acayb'alak, ¿nen chac tatoctak etzltak no'j pire inkej laj ak'b'ak? ");
INSERT INTO uspNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","C'uttakneca' jun pwak chinwch ri quiek la' tatojtakwi' alcabar, xche' rechak. Rechak xc'amtakch jun denario xc'uttak chiwch. ");
INSERT INTO uspNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Kakaj Jesús xtz'onaj chic rechak: ¿Nenc'u quiek jcayb'al ri wi' chiwch ri y nen quiek jb'ij ri tz'ib'al chiwch ri? xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Rechak xijtak: Rechi' César, xche'tak re. Kakaj Jesús xij chic rechak: Ye'tak re César lawi' re César y ye'tak re Kakaj Dios lawi' re Kakaj Dios, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Cuando xtatak chi jilonli xijsaj rechak jwi'l Kakaj Jesús sub'laj xsaach jch'olak, xcan jye'tak Kakaj Jesús, xe'tak. ");
INSERT INTO uspNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","La' man k'ij li xtawtak nic'j saduceo riq'ui Kakaj Jesús. Rechak ta' tijcojtak chi tina c'astasajna jwichak camnakib', jwi'li'li xijtak re Kakaj Jesús: ");
INSERT INTO uspNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Ajtijonl, Moisés xij chike chi wi wi' jun winak ticamc y ta' ralc'walak xwa'xc, rajwaxi' tic'uli'y chic jun jk'un riq'ui man anm li, ri camnak richjil pire tiwa'x ralc'wal riq'uil y ticojsaj pi ralc'wal man nab'e winak. ");
INSERT INTO uspNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Y chikaxo'l oj xwa'xi' wukub' (7) winak ri jk'un ratz rib'ak. Man nab'eal xc'uli'yc, pero xcamc, ta' ralc'wal xwa'xc y man rixokl xc'uli'y chic riq'ui man jcab'al. ");
INSERT INTO uspNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Y xcam man jcab'al y ta' ralc'wal xwa'xc. Xc'uli'y chic man jroxal riq'ui man anm y jilon re xcamke. Wukub' (7) chi winak ri jk'un ratz rib'ak xc'uli'ytak riq'ui man anm li y chi wukub' (7) rib'ilak xcamtak. ");
INSERT INTO uspNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Pi q'uisb'ire xcam man anm. ");
INSERT INTO uspNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Cuando tic'astasaj jwichak camnakib', ¿nenc'u rechak chi wukub' (7) winak li trixokolaj man anm li, jwi'l chi wukub'i' (7) rib'ilak xc'uli'ytak riq'uil? xche'tak re Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Kakaj Jesús xij rechak: Atak sachalcataka'n, jwi'l ta' awetamak nen tijb'ij li wuj re Lok'laj Jyolj Kakaj Dios y ta' awetamak juntir ri jcwinel Kakaj Dios ri wi'. ");
INSERT INTO uspNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Cuando tic'astasaj jwichak camnakib' chi winak chi anm ta' chiqui' tic'uli'ytak, ji'chaklontak chapca' yak anjl ri wi'tak lecj. ");
INSERT INTO uspNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","¿Ta'c'u ilan awi'lak li wuj re Lok'laj Jyolj Kakaj Dios ri xij chawechak chirij c'astajb'al? Kakaj Dios xij jilonri: ");
INSERT INTO uspNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Ini' ri in jDios Abraham, Isaac y Jacob, xche'. Kakaj Dios ma' jDios ta' yak camnakib', jDiosaki' yak ri yo'ltak, xche' Kakaj Jesús rechak. ");
INSERT INTO uspNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Cuando Kakaj Jesús xij jilonli, sub'laj q'ui cristian xsaach jch'olak chi jtaic jyolj ri xij. ");
INSERT INTO uspNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Cuando mak fariseo xtatak chi Kakaj Jesús xana' rechak mak saduceo chi ta' chiqui' xch'a'wtak, xmulb'a' rib'ak ");
INSERT INTO uspNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","y jun rechak, ri' jun ajtijol cristian re Jpixb' Kakaj Dios raj tijtoc nen tran pire tikej Kakaj Jesús laj jk'ab'ak xtz'onaj re: ");
INSERT INTO uspNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Ajtijonl, ¿nen chi pixab' lal mas rajwax ticojsaj chiwchak nic'j pixab' chic? xche' re. ");
INSERT INTO uspNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Kakaj Jesús xij re: Li wuj re Lok'laj Jyolj Kakaj Dios tijb'ij jilonri: Lok'aj Akaj Dios ri Awajawl riq'ui nojel awanm y xike chomorsaj chirij Kakaj Dios y b'an riq'ui nojel awanm lawi' raj tab'an, tiche'. ");
INSERT INTO uspNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Ri' man pixab' li mas rajwax ticojsaj chiwchak juntir pixab'. ");
INSERT INTO uspNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Y jcab' pixab' raquitz mita' nic' jtaic pach man jun li, tijb'ij jilonri: Lok'aj awijl atz'akt chapca' jlok'aj ayb' at tab'an, tiche'. ");
INSERT INTO uspNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Ri' mak quib' pixab' li ri tiye'wtak jcholajl juntir Jpixb' Kakaj Dios y ri xijtak yak ajk'asaltak Jyolj Kakaj Dios, xche' Kakaj Jesús re. ");
INSERT INTO uspNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Cuando aj mulantaka' mak fariseo xpe Kakaj Jesús xtz'onaj rechak: ");
INSERT INTO uspNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","¿Nen tab'ij atak chirij nen quiek rijajl jun ri b'il jwi'l Kakaj Dios chi tina jtaknach wich ulew? xche' rechak. Rechak xijtak: Rijajli' David, xche'tak. ");
INSERT INTO uspNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Kakaj Jesús xtz'onaj chic rechak: ¿Nenc'u chac David xijsaji' re jwi'l Lok'laj Jsantil Kakaj Dios chi tijb'ij Wajawl re? Re xij jilonri: ");
INSERT INTO uspNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Kakaj Dios ri Kajawl xiji' re Wajawl: Cub'ren laj impaach asta tina injachna laj ak'b' juntir yak ri atcontrinc, xche' re, tiche'. ");
INSERT INTO uspNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","¿Nen mo jun ri b'il jwi'l Kakaj Dios chi tina jtaknach wich ulew, rijajli' David, cuando David xiji' Wajawl re? xche' Kakaj Jesús rechak. ");
INSERT INTO uspNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Y ni jono rechak xcwintak chi jb'ij jono yoloj pire jc'ululaj Kakaj Jesús. Xcholmajb'i la' mak k'ij li ta' chiqui' ni jonok xc'otow chic jchi' Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Cuando Kakaj Jesús xijmaj jwi'l jilonli, xij chic jilonri rechak cristian ri wi'tak cla' pach yak ajtijol rib'ak chirij: ");
INSERT INTO uspNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","Yak ajtijoltak cristian re Jpixb' Kakaj Dios pach mak fariseo tiesantak chi sakil Jpixb' Kakaj Dios. ");
INSERT INTO uspNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Jwi'li'li cojontak chiwchak, b'antak juntir ri tijb'ijtak chawechak. Pero ma b'an awechak chapca' trantak rechak. Rechak tijb'ijtak lawi' rajwax tib'ansajc, pero jalan trantak chiwch ri tijb'ijtak. ");
INSERT INTO uspNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Rechak tijtijojtak cristian re nic'j pixab' sub'laj c'ax jb'anic, pero rechak ta' tit'o'ontak chi jb'anic ri nen tijb'ij, nic' riq'uil tijye'tak jun al laj ika'n chirij cristian ri mita' nen ticuyuw ralal, pero rechak ni la' jun b'a jk'ab'ak tit'o'ontak chi jc'amicb'ic. ");
INSERT INTO uspNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Juntir ri trantak ri'ke rajak tzi tiilsajtak jwi'l cristian. Tijc'amtak mak c'olb'itak wuj ri lamas tijc'oltak mak q'uer wuj ri tz'ib'al Jpixb' Kakaj Dios chiwch y tijximtakb'i chi' jwichak o wichak jtelb'ak y tijcojtak itz'ik ri nimak rakan ritz'ab'l. ");
INSERT INTO uspNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Y cuando tib'etak li jono nimak'ij mas kus triltak ticub'artak la' mak tem ri lamas ticub'artak yak ri wi' rekle'nak lak sinagog. ");
INSERT INTO uspNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Ri' rajak tic'amsaj rutzil jwichak lak c'ayb'l pi c'utb'ire chi nimi' jk'ijak y ri' rajak tib'ijsaj ajtijonl rechak. ");
INSERT INTO uspNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Pero atak ma ye'tak luwar tib'ijsaj ajtijonl chawechak jwi'lak cristian, jwi'l xike wi' jun Ajtijonl y atak juntir awech'elxiqui' ayb'ak. ");
INSERT INTO uspNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Y ma cojtak jun cristian pi akajak, jwi'l xike jun Akajak y re ji' wi' lecj. ");
INSERT INTO uspNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Y ma ye'tak luwar tib'ijsaj jb'ab'al chawechak jwi'l xike jun b'ab'al wi', ri' ri b'il jwi'l Kakaj Dios chi tina jtaknach wich ulew. ");
INSERT INTO uspNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ri mas nim jk'ij chaxo'lak, rajwaxi' rane' lawi' ri rajwax jb'anic pire nic'j chic. ");
INSERT INTO uspNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Jwi'l nen tijcoj jk'ij ric'an, ta' ticojsaj jk'ij y nen ta' tijcoj jk'ij, ri' li ticojsaj jk'ij. ");
INSERT INTO uspNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","¡C'ur awchak atak ajtijoltak cristian re Jpixb' Kakaj Dios y atak fariseo, ajsolcopil acayb'alak! Atak ta' taye'tak luwar tioc cristian laj jk'ab' Kakaj Dios pire titakon chib'ak, pero ni atak atoctak. ");
INSERT INTO uspNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","¡C'ur awchak atak ajtijoltak cristian re Jpixb' Kakaj Dios y atak fariseo, ajsolcopil acayb'alak! Atak tawesajtak kelen awechak chirijak yak anm ri camnak richjilak y pire b'amb'i awchak chiwchak cristian, sub'laj naj tab'antak chi ch'a'wem riq'ui Kakaj Dios. Jwi'li'li masna c'ax k'atb'itzij tib'ansaj chab'ak jwi'l Kakaj Dios. ");
INSERT INTO uspNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","¡C'ur awch atak ajtijoltak cristian re Jpixb' Kakaj Dios y atak fariseo, ajsolcopil acayb'alak! Atak atwo'cottak juntir luwar chi jtoquic jun ajtijol rib' chawijak. Cuando tata'tak, tatijojtak re ac'utu'nak y re masna etzl jno'j tiel chic chawchak. Jwi'li'li re quib' chi jilon c'axc'ol tijtij chapca' ri tatij atak li man luwar re tijb'i c'ax. ");
INSERT INTO uspNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","¡C'ur awchak atak ajc'amaltak b'e ri pur atak moy! Atak tab'ijtak: Nen jonok tijb'ij chi trana' jun kelen y wi tijcoj nimi richoch Kakaj Dios laj jyolj chi jb'ij chi tz'eti' tran ri tijb'ij, nic' riq'uil ta' ni jun kelen b'il jwi'l. Pero nen tijcoj mak oro re nimi richoch Kakaj Dios laj jyolj chi jb'ij chi tz'eti' tran ri tijb'ij, rajwaxi' tran, atche'tak. ");
INSERT INTO uspNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","¡Atak pur atak sons y pur atak moy! ¿Nenc'u mas nim jk'ij, roni' man oro o ri' nimi richoch Kakaj Dios ri quiek jwi'l nim jk'ij man oro? ");
INSERT INTO uspNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Y tab'ijtak: Nen jonok tijb'ij chi trana' jun kelen y wi tijcoj altar laj jyolj chi jb'ij chi tz'eti' tran ri tijb'ij, nic' riq'uil ta' nen b'il jwi'l. Pero nen tijcoj mak kelen ri sipal re Kakaj Dios ri wi' chib' man altar laj jyolj chi jb'ij chi tz'eti' tran ri tijb'ij, rajwaxi' tran, atche'tak. ");
INSERT INTO uspNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","¡Atak pur atak moy! ¿Nenc'u mas nim jk'ij, roni' mak kelen ri sipal re Kakaj Dios o man altar ri quiek jwi'l nim jk'ij mak kelen ri sipal re Kakaj Dios? ");
INSERT INTO uspNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Nen tijcoj man altar laj jyolj chi jb'ij chi tz'eti' tran ri tijb'ij, ma' xita'ke man altar tijcoj laj jyolj chi jb'ij chi trana'n, tijcoja' juntir ri wi' chib'. ");
INSERT INTO uspNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Y nen tijcoj nimi richoch Kakaj Dios laj jyolj chi jb'ij chi tz'eti' tran ri tijb'ij, ma' xita'ke nimi richoch Kakaj Dios tijcoj laj jyolj chi jb'ij chi trana'n, tijcoja' jb'ij Kakaj Dios ri wi' li nimi richoch. ");
INSERT INTO uspNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Nen tijcoj man luwar lecj lamas wi' Kakaj Dios laj jyolj chi jb'ij chi tz'eti' tran ri tijb'ij, ma' xita'ke man luwar lecj lamas wi' Kakaj Dios tijcoj laj jyolj chi jb'ij chi tz'eti' tran ri tijb'ij, tijcoja' jb'ij jcub'arb' Kakaj Dios laj jyolj chi jb'ij chi tz'eti' tran y tijcoja' jb'ij Kakaj Dios ri ticub'ar la' man cub'arb'. ");
INSERT INTO uspNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","¡C'ur awchak atak ajtijoltak cristian re Jpixb' Kakaj Dios y atak fariseo, ajsolcopil acayb'alak! Atak taya'taka' jlájuj kelen awechak re Kakaj Dios taya'taka' jlájuj mak woron ri jb'ij menta, anis y comino. Pero ta' tijin tab'antak lawi' ri mas rajwax jb'anic ri tijb'ij Jpixb' Kakaj Dios. Ri rajwax jb'anic ri' b'antak juntir pi jcholajl chiwch Kakaj Dios, iltak c'ur jwich jun cristian y b'antak laj ac'aslemalak lawi' raj Kakaj Dios tab'antak. Ri' li rajwax tab'antak y mi can aye'tak jb'anic. ");
INSERT INTO uspNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Atak ajc'amaltak b'e, pur atak moy. Atak jor tacwentij ayb'ak pire ma' tab'ik'tak jun usum, pero ta' tawic'ajtak tab'ik'a'taka'b'i jun camello. ");
INSERT INTO uspNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","¡C'ur awchak atak ajtijoltak cristian re Jpixb' Kakaj Dios y atak fariseo, ajsolcopil acayb'alak! Ataka' nic' riq'uil man vas pach man lak ri ch'ajal rij, pero tz'il jpam jwi'l alk'anc y mak etzltak rayb'l ri tab'antak. ");
INSERT INTO uspNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","¡Atak fariseo, pur atak moy! Ch'ajtak nab'e jpam man vas pach man lak y jilonli tisakab'i' rij. ");
INSERT INTO uspNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","¡C'ur awchak atak ajtijoltak cristian re Jpixb' Kakaj Dios y atak fariseo, ajsolcopil acayb'alak! Atak pur atak mak mukb'i camnak ri tz'ajal rij la' chun, sub'laj kus rilic rij, pero jpamak nojsali' chi jb'akeltak camnak y chi jtio'jlak cristian ri k'a'ysal. ");
INSERT INTO uspNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Y jilon atak, rilic chapca' suc'uli' awanmak chiwch Kakaj Dios, pero awanmak nojsali' chi solcopiltak yoloj y etzltak no'j. ");
INSERT INTO uspNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","¡C'ur awchak atak ajtijoltak cristian re Jpixb' Kakaj Dios y atak fariseo, ajsolcopil acayb'alak! Tab'antak jwa'x mak mukb'i camnak ri lamas mukultak yak ajk'asaltak Jyolj Kakaj Dios y tacojtak ritz'ab'l mak mukb'i camnak ri lamas mukultak yak cristian ri suc'ul ranmak chiwch Kakaj Dios. ");
INSERT INTO uspNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Y tab'ijtak: Witi wojchak wich ulew la' mak junab' cuando xwa'xtak kamam katit' wich ulew ta' roj xojt'o'on chi jcamsajcak yak ajk'asaltak Jyolj Kakaj Dios, atche'tak. ");
INSERT INTO uspNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Jilonli chirijke ayoljak tic'utun chi atak, ataka' rijajl mak ri xcamsantak rechak yak ajk'asaltak Jyolj Kakaj Dios. ");
INSERT INTO uspNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","¡Q'uistak jb'anic lawi' ri cholanch jb'anic jwi'lak amam atit'ak ojr! ");
INSERT INTO uspNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","¡Pur atak cumatz y rijajl cumatz ri ticamsanc! Ta' ni jono chawechak ticolmaj laj jk'ab' man c'axlaj jk'atb'itzij Kakaj Dios ri petzal chab'ak jwi'l ji' atb'etak li man luwar re tijb'i c'ax. ");
INSERT INTO uspNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Jwi'li'li in tantakch ajk'asaltak Jyolj Kakaj Dios chaxo'lak pach cristian ri wi' mas jno'jak jwi'l Lok'laj Jsantil Kakaj Dios pachak ajtijonl, pero atak tacamsajtak y tatz'onajtak chi ticamsaj jujun rechak wich curs. Y jujun chic tasec'tak lak sinagog y tatakejtak jb'anic c'ax rechak lak juntir tilmit. ");
INSERT INTO uspNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Ataka' attojowtak re jcamicak juntir tzitaklaj cristian ri xcamsajtak, ticholmajch rajlaj riq'ui jcamic Abel ri suc'ul ranm chiwch Kakaj Dios asta jcamic Zacarías ri jc'ajol Berequías ri xcamsaj jwi'l amamak laj xo'lak man luwar ri tosol re Kakaj Dios pach man altar re c'atb'i awaj. ");
INSERT INTO uspNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Kes tz'etel tz'et tamb'ij chawechak chi yak cristian ri wi'tak wich ulew lajori ri' rechak tic'uluwtak sub'laj c'ax chirij juntir mak mac li, xche' Kakaj Jesús rechak yak ajtijoltak cristian re Jpixb' Kakaj Dios y mak fariseo. ");
INSERT INTO uspNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","¡Atak aj Jerusalén, atak aj Jerusalén, ri tacamsajtak yak ajk'asaltak Jyolj Kakaj Dios y tacamsajtak chi ab'aj yak jtako'n Kakaj Dios ri takaltakch aac'lak! ¡Q'uilaj b'welt chwaj roj ximmulb'a' awchak chapca' tran jun chuch ac' tijmulb'a' tra jk'un ralaj jxic', pero atak ta' chawajak! ");
INSERT INTO uspNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Tatak jcholajl, awichochak tina canna pi cane'l ja. ");
INSERT INTO uspNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Y tamb'ij chawechak chi lajori ta' chiqui' tawiltak inwch, ajri' tawiltak chic inwch cuando tab'ijtak: ¡Nim jk'ij ri petzal laj jb'ij Kakaj Dios ri Kajawl! atche'tak, xche' Kakaj Jesús rechak. ");
INSERT INTO uspNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Kakaj Jesús xelb'i li nimi richoch Kakaj Dios, b'enamchak re cuando xpetak yak ajtijol rib'ak chirij xjutuntak chijc'ulel, xoctak chi jc'utic chiwch nen mo rilic nimi richoch Kakaj Dios. ");
INSERT INTO uspNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Xpe Kakaj Jesús, xij rechak: Xawila'taka' nen mo rilic juntir li, pero kes tz'etel tz'et tamb'ij chawechak chi tina tawna jun k'ij chi ta' chiqui' ni jono ab'aj tican chib' jun chic. Juntir li tina yojmajna, xche' Kakaj Jesús rechak yak ajtijol rib'ak chirij. ");
INSERT INTO uspNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Cuando Kakaj Jesús cub'ul b'a witz ri jb'ij Olivos, xpetak yak ajtijol rib'ak chirij xjutuntak chijc'ulel, xtz'onajtak re Kakaj Jesús pi ric'anak: Chikaj tab'ij chike nen or titaw chiwch ri xab'ij. ¿Nenc'u retal ri tiilsaj pire c'utb'ire cuando atpe chic y cuando titaw q'uisb'itak k'ij re jwich k'ijsak? xche'tak re Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Xpe Kakaj Jesús, xij rechak: Tike acwentij ayb'ak pire ma' atsub'sajtak, ");
INSERT INTO uspNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","jwi'l sub'laj q'ui tina petakna y tijcoj rib'ak chapca' in, tijb'ijtak: Ini' ri b'il jwi'l Kakaj Dios chi tina jtaknach wich ulew, tina che'takna y sub'laj cristian tina jsub'takna. ");
INSERT INTO uspNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Atak tina atatakna jtaquil chi tijini' nimaktak ch'o'j li jono luwar, pero mi tzaak ach'olak, jwi'l ajqui' chi taw k'ij re q'uisb'itak k'ij re jwich k'ijsak. ");
INSERT INTO uspNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Jun nimlaj tilmit tina ch'o'jinna riq'ui jun tilmit chic y jun rey tina ch'o'jinna riq'ui jun rey chic. Tina pena sub'laj wi'jal y tina ranna nimaktak cab'rakn lak jaljojtak luwar. ");
INSERT INTO uspNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Pero juntir li ajri' cholb'ire c'ax ri tina pena chib'ak cristian. ");
INSERT INTO uspNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Y ajruc're' atak, atna jachsajtakna laj jk'ab'ak mak etzltak cristian pire tib'ansaj c'ax chawechak y atna camsajtakna. Y juntir tilmit wich ulew atna retzelb'ejtakna y atna jcontrijtakna inwi'lke in. ");
INSERT INTO uspNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Cuando titaw mak k'ij li sub'laj cristian tijquib'aj ranmak chwij y tijcontrij rib'ak chirib'il rib'ak y tijjach jpachak li c'ax. ");
INSERT INTO uspNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Y sub'laj cristian tijcoj rib'ak chapca' ajk'asaltak Jyolj Kakaj Dios, pero ta' tz'et, ajsub'unltake y sub'laj cristian tijsub'tak. ");
INSERT INTO uspNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Tina wa'xna mas etzltak no'j laj ranmak cristian y sub'laj cristian ta' chiqui' tijlok'aj rib'ak chirib'il rib'ak. ");
INSERT INTO uspNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Pero nen ta' tijquib'aj ranm chwij asta ticamc, ticolmaji' laj jk'ab' jmac. ");
INSERT INTO uspNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Y tzilaj jtaquil ri re nen mo oquem laj jk'ab' Kakaj Dios pire titakon chib'ak cristian tina b'ijsajna rechak juntir cristian wich ulew pire tretemajtak, ajruc're' titaw k'ij re q'uisb'itak k'ij re jwich k'ijsak. ");
INSERT INTO uspNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Tina awiltakna li man luwar ri tosol pire Kakaj Dios jun ri ajb'anal c'ax ri xutul jwi'l Kakaj Dios chapca' xcan jtz'ib'aj Daniel ri ajk'asal Jyolj Kakaj Dios. Nen tril jwich wuj ri, jte' jcholajl. ");
INSERT INTO uspNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Cuando tawiltak jilonli yak cristian ri wi'tak Judea rajwaxi' laj or tielmajtakb'i b'ak witz. ");
INSERT INTO uspNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Y nen wi' b'a ja, mi oc chic chi resaj kelen re la ja. ");
INSERT INTO uspNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Y nen wi' lak chac, mi k'aj chic laj richoch chi jc'amic ritz'ik ri tijk'u'j. ");
INSERT INTO uspNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","C'ur jwichak yak yaj anm la' mak k'ij li pach yak ri wi' jne'ak tijtu'tzajtak, jwi'l rechak ta' tijna' tielmajtak laj or. ");
INSERT INTO uspNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Atak tz'onajtak re Kakaj Dios chi miti lak k'ij re riq'uil jab', ni lak k'ij re uxlan cuando atelmajtakb'ic, ");
INSERT INTO uspNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","jwi'l tina pena jun nimlaj c'ax ri ta' ni jun b'welt b'anal cuando xticarch jwich k'ijsak asta lajori y ni jun b'welt tran chic. ");
INSERT INTO uspNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Miti xchomorsaj Kakaj Dios chi ta' q'uilaj k'ij tran man c'ax li, ta' ni jono cristian roj ticolmajc. Kakaj Dios xchomorsaj jilonli jwi'lke tril c'ur jwichak yak ri cha'l jwi'l. ");
INSERT INTO uspNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Wi wi' nen tib'in chawechak: Iltak impuch, ri b'il jwi'l Kakaj Dios chi tina jtaknach wich ulew wi' neri o wi' jili, tiche'tak, ma cojtak, ");
INSERT INTO uspNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","jwi'l wi' cristian tijcoj rib'ak chapca' ri'taka' ri b'il jwi'l Kakaj Dios chi tina jtaknach wich ulew y wi' tijcoj rib'ak pi ajk'asaltak Jyolj Kakaj Dios, pero ta' tz'et. Rechak trana'taka' c'utb'i jcwinelak ri sachom ch'olal rilic, pero pireke tijsub'tak cristian asta yak ri cha'ltak jwi'l Kakaj Dios rajak tijsub'tak. ");
INSERT INTO uspNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Cojtak retal, in ximb'iji' juntir ri chawechak onque ajqui' chi taw chiwch. ");
INSERT INTO uspNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Wi wi' nen tib'in chawechak: Iltak impuch, ri b'il jwi'l Kakaj Dios chi tina jtaknach wich ulew wi' li jun luwar lamas ta' cristian, wi tiche', mat b'etak chi rilic o wi wi' nen tib'in chawechak: Iltak impuch, wi' li jun ja, wi tiche', ma cojtak, ");
INSERT INTO uspNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","jwi'l Jc'ajol Kakaj Dios ri xwux pi cristianil jilon jpetic chapca' jun coyop tijkopajch rib' jk'ak'al laj jsuc'lal lamas tielch k'ij y tib'e jsakab'saj asta laj jsuc'lal lamas tikej k'ij. ");
INSERT INTO uspNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Lamas wi' jun camnak awaj, cla' tijmulb'a' rib'ak mak c'uch, xche' Kakaj Jesús rechak yak ajtijol rib'ak chirij. ");
INSERT INTO uspNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Kakaj Jesús xij chic rechak yak ajtijol rib'ak chirij: Cuando jorok k'axi' juntir mak c'ax li ri ximb'ij, ajruc're' tran uku'm jwich k'ij, ic' ta' chiqui' tijye' jk'ak'al, mak ch'umil titzaaktakch lecj y juntir ri wi' lecj tina yucxijna laj jluwrak. ");
INSERT INTO uspNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Ajruc're' tic'utunch lecj retal jpetic Jc'ajol Kakaj Dios ri xwux pi cristianil. Juntir cristian wich ulew tijcamsaj rib'ak chi ok'ej jwi'l sub'laj c'ax ri petzal chib'ak. Juntir rib'ilak tina riltakna Jc'ajol Kakaj Dios ri xwux pi cristianil tikejch lecj li sutz' sub'laj tikopopon jk'ak'al jnimal jk'ij y wi' jcwinel. ");
INSERT INTO uspNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Cuando tiok'saj trompet, Kakaj Dios tijtakch yak ranjl chi jmolic jwichak juntir cristian ri cha'ltak jwi'l ri wi'tak lak juntir tilmit re wich ulew. ");
INSERT INTO uspNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Esaj ano'jak chirij man jche'l higo. Cuando tawiltak tiel chicch jxakak ac'al, atak awetamakchak chi petemchak re riq'uil sak'j. ");
INSERT INTO uspNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Y jilonli, cuando tawiltak chi tichak tijin titaw chiwch juntir ri ximb'ij chawechak, etemajtak chi Jc'ajol Kakaj Dios ri xwux pi cristianil petemchak re, chi' pwertchak wi'. ");
INSERT INTO uspNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Kes tz'etel tz'et tamb'ij chawechak chi ajqui' chi camtak juntir cristian ri wi'tak wich ulew re mak junab' ri cuando titaw chiwch juntir ri ximb'ij chawechak. ");
INSERT INTO uspNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Caj pach ulew tisaachi' jwichak, pero tina tawna chiwch juntir ri ximb'ij chawechak, xche' Kakaj Jesús rechak. ");
INSERT INTO uspNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Kakaj Jesús xij chic rechak: Pero ni jonok etemawinak nen chi k'ij lal o nen chi or lal tran ri ximb'ij chawechak, ni yak anjl ri wi'tak lecj retamak, ni Jc'ajol Kakaj Dios, xike Kakaj Dios retam. ");
INSERT INTO uspNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Chapca' xantak yak cristian la' mak junab' cuando xwa'x Noé wich ulew, jilon tina rantakna chic yak cristian la' mak junab' cuando tipe chic Jc'ajol Kakaj Dios ri xwux pi cristianil. ");
INSERT INTO uspNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","La' mak junab' li cuando ajqui' chi ran man nimlaj k'alaj, yak cristian tiwi'ntak, tik'ab'artak, tic'uli'ytak y tijc'ulb'a' ralc'walak asta cuando xtaw k'ij xjaw Noé li arc. ");
INSERT INTO uspNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Rechak ta' ric'ab'ak cuando xpe man nimlaj k'alaj, xc'amb'i juntir cristian. Y jilon cuando titaw k'ij tipe chic Jc'ajol Kakaj Dios ri xwux pi cristianil, ta' ric'ab'ak tiyuk. ");
INSERT INTO uspNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Cuando titaw man k'ij li, wi' quib' winak, nic' tijintak li chac, jun tic'amsajb'ic y jun tican ye'sajok. ");
INSERT INTO uspNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Y wi' quib' anm, nic' tijintak chi que'm, jun tic'amsajb'ic y jun tican ye'sajok. ");
INSERT INTO uspNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Atak chajintake jwi'l ta' awetamak nen or tipe Awajawlak. ");
INSERT INTO uspNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Pero atak tatak jcholajl, witi man rajw ja retam nen or titaw man alk'om laj richoch, ta' tiwar chi jchajajc y ta' tijye' luwar tioc man alk'om laj richoch chi ralk'aj kelen re. ");
INSERT INTO uspNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Y ji'c'ulon atak, ulb'entake, jwi'l ta' etemal nen or tipe chic Jc'ajol Kakaj Dios ri xwux pi cristianil. ");
INSERT INTO uspNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Jun mocom ri tzi tran laj jchac y tzi jno'j ticojsaji' pire jb'ab'alak mak nic'j mocom chic jwi'l jpatron y ri' re titzukuw rechak lak or re wic'. ");
INSERT INTO uspNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Tzi re man mocom li ri tiyuk ta'sajok jwi'l jpatron tijin chi jb'anic chapca' xcan b'ijsaj re. ");
INSERT INTO uspNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Kes tz'etel tz'et tamb'ij chawechak chi man patron tijcoja' man mocom li chi jchajaj juntir kelen re ri wi'. ");
INSERT INTO uspNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Pero wi man mocom li tran etzltak jno'j y tijb'ij laj ranm chi ta' tik'ajch jpatron laj or, ");
INSERT INTO uspNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","tioc chi jseq'uicak yak nic'j mocom chic, tioc chi wic' y tioc chi k'ab'ric xo'lak mak k'ab'reltak cristian, ");
INSERT INTO uspNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","pero titaw jun k'ij y titaw jun or ri ta' ric'ab' cuando tiyuk jpatron. ");
INSERT INTO uspNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Tipe man jpatron tijc'ur laj nic'ajl man mocom li y tijt'ojb'i li tijb'i c'ax laj xo'lak mak ajsolcopil jcayb'alak. Cla' tib'e rok'b'ej rib' y tijkuch'uch'uj ree, xche' Kakaj Jesús rechak yak ajtijol rib'ak chirij. ");
INSERT INTO uspNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Kakaj Jesús xij chic jun esb'i no'j rechak yak ajtijol rib'ak chirij jilonri: Jtakon Kakaj Dios chib'ak cristian jilon chapca' lajuj (10) k'apojtak anm ri xc'amtakb'i jcandilak, xe'tak chi jc'ulic man c'ojol winak ri tic'uli'yc. ");
INSERT INTO uspNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Job' rechak ta' jch'ab'ejcak y job' chic wi' jno'jak. ");
INSERT INTO uspNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Yak ri ta' jch'ab'ejcak xc'amtakb'i jcandilak, pero ta' xc'amtakb'i raceitak pire tijnojsajtak chic jcandilak wi tiq'uis jpam. ");
INSERT INTO uspNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Pero yak ri wi' jno'jak xnojsaji'b'i jcandilak y xc'amtak chicb'i jnejb'ak re raceitak pire tijnojsajtak chic jcandilak wi tiq'uis jpam. ");
INSERT INTO uspNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Pero xnajtin mas ak'ab', ta' jtawic man c'ojol winak ri tic'uli'yc, xpe sub'laj jwarjak y juntir rib'ilak xwartak. ");
INSERT INTO uspNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Raj tawem tran nic'aj ak'ab' cuando ri'chak xtatak xaan jun ch'a'wem, tijb'ij: ¡Xpeti' man c'ojol winak ri tic'uli'yc! ¡Elantak jol chi jc'ulic! xche'. ");
INSERT INTO uspNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Juntir yak k'apojtak anm li xb'iittak xoctak chi jye'ic jpam jcandilak. ");
INSERT INTO uspNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Xpetak yak job' ri ta' jch'ab'ejcak, xijtak rechak yak ri wi' jno'jak: Ye'tak junquitz kaceit jwi'l chupem tran kacandil, xche'tak. ");
INSERT INTO uspNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Xpetak yak ri wi' jno'jak, xijtak: Ta' tijna' tikaye' awechak jwi'l ta' na'l wi tran ke oj. Ri' mas tzi lok'ta awechak lamas tic'ayajwi', xche'tak rechak. ");
INSERT INTO uspNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Xe'tak yak job' ri ta' jch'ab'ejcak chi jlok'ic raceitak, pero cuando b'esaltak chi jlok'ic raceitak, xtaw man c'ojol winak ri tic'uli'yc. Yak k'apojtak anm ri b'anal jwa'x jcandilak jwi'lak xoctak li man nimak'ij re c'ulniquil nic' pach man c'ojol winak ri tic'uli'yc y xtz'apij man pwert. ");
INSERT INTO uspNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Ajruc're' xtawtak yak job' k'apojtak anm chic, xriltak chi tz'apilchak man pwert, xijtak: ¡Kaj, kaj! ¡Teb'a' man pwert chikawch! xche'tak. ");
INSERT INTO uspNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Pero man c'ojol winak ri tic'uli'y xij rechak: Kes tz'etel tz'et tamb'ij chawechak chi ta' tanch'ob' awchak, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Jwi'li'li atak tike acwentij ayb'ak, jwi'l ta' awetamak nen or tipe Jc'ajol Kakaj Dios, xche' Kakaj Jesús rechak yak ajtijol rib'ak chirij. ");
INSERT INTO uspNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Kakaj Jesús xij chic jun esb'i no'j rechak yak ajtijol rib'ak chirij jilonri: Ri jtakon Kakaj Dios chib'ak cristian jilon chapca' xan jun patron, xchomorsaj chi tib'e chinaj li jun jalan tilmit chic. Xsiq'uij yak jmocom y xcan jye' jpwaak laj jk'ab'ak pire tijyectak jwich asta cuando tik'aj chicch. ");
INSERT INTO uspNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Re jun xcan jye' job' chi talento y re jun chic xcan jye' quib' chi talento, re jun chic xcan jye' jun chi talento. Chi jujunalak xcani' ye'saj rechak nen jnimakl ticwintak chi jyequic jwich y xe' man patron chinaj. ");
INSERT INTO uspNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Man mocom ri xcan ye'saj job' chi talento re, xoc chi jyequic jwich y xch'eca' job' chi talento chic chirij mak talento li. ");
INSERT INTO uspNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Y man ri xcan ye'saj quib' chi talento re, xoc chi jyequic jwich y xch'eca' quib' chi talento chic chirij mak talento li. ");
INSERT INTO uspNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Pero man ri xye'saj jun chi talento re, ta' xyec jwich. Re xc'ot jun jul li ulew y xmuk man jpwaak jpatron cla'. ");
INSERT INTO uspNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Man patron li sub'laj naj xe' sacharok y cuando xyuk, xsiq'uij yak jmocom ri quiek riq'uil xcan jye' jpwaak, jwi'l ri' raj tretemaj nen xantak re man pwak. ");
INSERT INTO uspNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Nab'e xtaw man mocom ri xcan ye'saj job' chi talento re, xe' jache' mak talento ri xcan ye'saj re y xij re jpatron: Kaj, at xcan aye' job' chi talento chwe cuando xatb'ec y co' job' talento chic ri, ri xinch'ec chirij apwaak, xche' re. ");
INSERT INTO uspNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Man patron xij re: Tziyi' xab'an, ati' jun tzilaj mocom y pi jcholajli' xab'an. Jwi'l tziyi' xab'an re jun raquitz, lajori tanjach mas laj ak'b'. Oquen li qui'cotemal wiq'uil ri in apatron, xche' re. ");
INSERT INTO uspNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Ajruc're' xtaw man jun ri xcan ye'saj quib' talento re, xij re man patron: Kaj, at xcan aye' quib' talento chwe cuando xatb'ec y co' quib' talento chic ri, ri xinch'ec chirij apwaak, xche' re. ");
INSERT INTO uspNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Man patron xij re: Tziyi' xab'an, ati' jun tzilaj mocom y pi jcholajli' xab'an. Jwi'l tziyi' xab'an re jun raquitz, lajori tanjach mas laj ak'b'. Oquen li qui'cotemal wiq'uil ri in apatron, xche' re. ");
INSERT INTO uspNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Ajruc're' xtaw man jun mocom ri xcan ye'saj jun talento re, xij re man patron: Kaj, in wetami' chi mas at c'a'n y atoch'on lamas ta' nen tiquil awi'l. ");
INSERT INTO uspNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Jwi'li'li xtzaak inch'ol chawch, xinc'amb'i atalento ximmuk li ulew. Co' atalento ri, ri xcan aye' chwe, xche' re. ");
INSERT INTO uspNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Man patron xij re: ¡Pur at etzl mocom y pur atsak'or! Wi awetami' chi in, chwaj inoch'on lamas ta' tiquil inwi'l, ");
INSERT INTO uspNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","xac'amtene'b'i impwaak xe'tene' aye' pi kejom re jonok y cuando xinyuk wi'tene'chak ral impwaak roj xinc'ule', xche' re. ");
INSERT INTO uspNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Y xij rechak mak ri wi'tak cla': Majtak man jun talento re y ye'tak re man ri wi' lajuj (10) talento riq'uil. ");
INSERT INTO uspNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Nen wi' mas riq'uil, tiye'saj chiqui' mas re pire tiniman re, pero nen ta' re, asta raquitz ri wi' riq'uil, timajsaji' re. ");
INSERT INTO uspNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Man mocom ri, ta' nen tichacuj esajtakb'i ri ja, t'ojtakb'i lak uku'm chinaj. Cla' tib'e rok'b'ej rib' y tijkuch'uch'uj ree, xche' man patron, xche' Kakaj Jesús rechak yak ajtijol rib'ak chirij. ");
INSERT INTO uspNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Kakaj Jesús xij chic rechak yak ajtijol rib'ak chirij: Cuando tipe chic Jc'ajol Kakaj Dios ri xwux pi cristianil sub'laj nim jk'ij tipet pach juntir yak ranjl y tiyuk cub'ar laj jcub'arb' ri nim jk'ij lamas tranwi' jk'atb'itzij. ");
INSERT INTO uspNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Y juntir cristian re juntir tilmit wich ulew tiyuk jmulb'a' rib'ak chiwch. Y re tijtos yak ri suc'ul ranmak chiwch Kakaj Dios y tijtos yak ri ta' suc'ul ranmak chiwch Kakaj Dios chapca' tran jun ajyuk' cuando tijtos mak carner y tijtos mak q'uisic'. ");
INSERT INTO uspNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Tijye' mak carner laj jpaach y mak q'uisic' tijye' laj jmax. ");
INSERT INTO uspNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Tipe man rey li tijb'ij rechak mak cristian ri wi'tak laj jpaach: Tzaj atak ri wi' jk'ab' Inkaj chab'ak. Oquentak lamas titakonwi' Inkaj ri tosolch jwi'l pi awechak ojr cuando ajqui' chi ran caj pach ulew, ");
INSERT INTO uspNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","jwi'l cuando xinc'ok jwi'l wi'jal, atak xaya'taka' inw, cuando xchekej ínchi', atak xaya'taka' wuc'a', cuando ta' lamas inwa'x, atak xinac'ama'taka'b'i laj awichochak, ");
INSERT INTO uspNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","cuando rajwax witz'ik inwi'l, atak xaya'taka' witz'ik, cuando xinyajarc, atak xinawilb'ejtaka'n y cuando xinwa'x li cars, atak ximb'e asolajtaka'n, tiche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Tipetak yak ri suc'ul ranmak chiwch Kakaj Dios, tijtz'onajtak re man rey: Kaj, ¿nen or xatkil xatc'ok jwi'l wi'jal y oj xkaye' aw? Y, ¿nen or xatkil xatcam jwi'l chekej chi' y oj xkaye' awuc'a'? ");
INSERT INTO uspNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Y, ¿nen or xatkil chi ta' lamas atwa'x y xatkac'ama'b'i laj kichoch? Y, ¿nen or xatkil chi ta' awitz'ik y oj xkaya' awitz'ik? ");
INSERT INTO uspNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Y, ¿nen or xatkil xatyajarc o xatwa'x li cars y oj xatb'e kasolaj? tiche'tak. ");
INSERT INTO uspNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Man rey li tijb'ij rechak: Kes tz'etel tz'et tamb'ij chawechak chi juntir ri xab'antak re jono yak wech'elxic ri ta' mas nim jk'ijak, chweyi' in xab'antak, tiche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Ajruc're' man rey li tijb'ij chic rechak yak cristian ri wi'tak laj jmax: Elantakb'i chinwch, atak etzltak cristian, jattak li man k'ak' ri ta' jchupic, ri tosol pi re man jb'ab'al etzl pach mak ranjl ri xamb'ertak chirij, ");
INSERT INTO uspNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","jwi'l cuando sub'laj xinc'ok jwi'l wi'jal, atak ta' xaye'tak inw y cuando sub'laj xincam jwi'l chekej chi', atak ta' xaye'tak wuc'a'. ");
INSERT INTO uspNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Y cuando ta' lamas xinwa'x, ta' xinac'amtakb'i laj awichochak. Y cuando rajwax witz'ik inwi'l, atak ta' xaye'tak witz'ik. Y cuando xinyajarc o cuando xinwa'x li cars ta' ximb'e asolajtak, tiche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Y rechak tijtz'onajtak re man rey: Kaj, ¿nen or xatkil xatc'ok jwi'l wi'jal o xatcam jwi'l chekej chi' o ta' nen xatc'amowb'i laj richoch o ta' awitz'ik o atyaj o xatkil wat li cars y ta' xatkat'o'w? tiche'tak re. ");
INSERT INTO uspNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Y man rey li tijb'ij rechak: Kes tz'etel tz'et tamb'ij chawechak, juntir ri ta' xab'antak rechak yak wech'elxic ri ta' mas nim jk'ijak, chweyi' in ta' xab'antak, tiche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Yak ri ta' xantak utzil neri wich ulew ji' tib'etak li man luwar re tijb'i c'ax ri ta' jq'uisic y yak ri suc'ul ranmak chiwch Kakaj Dios ji' tib'etak li tzilaj c'aslemal riq'ui Kakaj Dios lecj ri ta' jq'uisic, xche' Kakaj Jesús rechak yak ajtijol rib'ak chirij. ");
INSERT INTO uspNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Cuando xijmaj juntir li jwi'l Kakaj Jesús, xij chic rechak yak ajtijol rib'ak chirij: ");
INSERT INTO uspNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","Atak awetamaki' chi pi quib' k'ijchak raj man nimak'ij Pascua y la' k'ij li tijachsaj pi camic wich curs Jc'ajol Kakaj Dios ri xwux pi cristianil, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","La' mak k'ij li xpetak mak jb'ab'alak yak ajc'amaltak jb'eak cristian riq'ui Kakaj Dios pach yak ri wi' rekle'nak chijxo'lak yak rijajl Israel, xmulb'a' rib'ak chuchja riq'ui Caifás ri man nimlaj jb'ab'alak yak ajc'amaltak jb'eak cristian riq'ui Kakaj Dios. ");
INSERT INTO uspNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Xchomorsajtak nen mo trantak chi jchapic Kakaj Jesús chi mukukil pire tijjachtak pi camic. ");
INSERT INTO uspNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Pero xijtak chirib'il rib'ak: Ta' tikachap la' man nimak'ij ri, pire ma' tijb'it rib'ak cristian chikij, xche'tak. ");
INSERT INTO uspNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Kakaj Jesús wi' Betania laj richoch Simón ri xwa'x yajel chirij ojr ri jb'ij lepra. ");
INSERT INTO uspNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Xtaw jun anm riq'uil, c'amalb'i jun nejb' jwi'l ri b'anal la' ab'aj ri jb'ij alabastro, nojsal chi jun perjum ri sub'laj pakal rijil. Cuando cub'ul Kakaj Jesús chi' mex, xpe man anm li, xoc chi jtz'ajic perjum laj jb'a Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Y yak ajtijol rib'ak chirij Kakaj Jesucristo cuando xriltak chi jilonli, xpe retzalak, xijtak chirib'il rib'ak: ¿Nen chac xan c'ax re man perjum li? ");
INSERT INTO uspNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Ri' mas tzi xc'ayajtene' pi sub'laj pakal rijil man perjum li pire tit'o'saj yak powr la' man pwak, xche'tak. ");
INSERT INTO uspNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Xta Kakaj Jesús nen tijin tijb'ijtak xtz'onaj rechak: ¿Nen chac tijin tayajtak man anm ri? Re utzili' xan chwe. ");
INSERT INTO uspNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Yak powr tiwa'xtaka' chaxo'lak nojel k'ij, pero in ta' naj inwa'x chaxo'lak. ");
INSERT INTO uspNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Ri xan anm ri, xtz'aj perjum laj imb' pi rechak mukb'i we xan. ");
INSERT INTO uspNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Kes tz'etel tz'et tamb'ij chawechak chi lak juntir luwar wich ulew lamas tib'ijsajwi' tzilaj jtaquil chwij ri, tib'ijsaji' nen xan anm ri chwe y jilonli jcuxtaj tib'anc, xche' Kakaj Jesús rechak yak ajtijol rib'ak chirij. ");
INSERT INTO uspNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Jun rechak yak cab'lajuj (12) ajtijol rib'ak chirij Kakaj Jesucristo ri jb'ij Judas Iscariote, re xe' riq'uilak mak jb'ab'alak yak ajc'amaltak jb'eak cristian riq'ui Kakaj Dios ");
INSERT INTO uspNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","y xtz'onaj rechak: ¿Jurub' inatojtak tanjach Jesús laj ak'b'ak? xche' rechak. Y mak jb'ab'alak yak ajc'amaltak jb'eak cristian riq'ui Kakaj Dios xijtak chi tijya'taka' junwinak lajuj (30) pwak ri b'anal la' plata re. ");
INSERT INTO uspNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Laj or xoc Judas Iscariote chi jtoquic nen mo tran chi jjachic Kakaj Jesús laj jk'ab'ak. ");
INSERT INTO uspNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Li nab'e k'ij re mak k'ij re man nimak'ij ri titijsaj cuxlanwa ri ta' ch'amk'or la', xpetak yak ajtijol rib'ak chirij Kakaj Jesucristo xjutuntak chijc'ulel Kakaj Jesús xtz'onajtak re: ¿Lamas chawaj tib'e kab'ane' jwa'x asinar re Pascua? xch'etak re. ");
INSERT INTO uspNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Kakaj Jesús xij rechak: Jattak Jerusalén laj richoch jun winak, b'ijtak re: Tijb'ij Kajtijonl: Tawem tran chiwch ri tib'an chwe, chwaj imb'e laj awichoch, tib'e imb'ane' insinar re Pascua pach yak ajtijol rib'ak chwij, tiche', atche'tak re, xche' Kakaj Jesús rechak. ");
INSERT INTO uspNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Yak ajtijol rib'ak chirij xantak chapca' ri xijsaj rechak jwi'l Kakaj Jesús. Xantak jwa'x sinar re Pascua cla'. ");
INSERT INTO uspNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Cuando xoc ak'ab', xtaw Kakaj Jesús, xcub'ar chi' mex pach yak cab'lajuj (12) ajtijol rib'ak chirij. ");
INSERT INTO uspNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Cuando tijintak chi wic' xij rechak: Kes tz'etel tz'et tamb'ij chawechak chi wi' jun chawechak injachow pi camic, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Rechak xpe sub'laj b'is laj ranmak chi jtaic y xoctak chi jtz'onaj re Kakaj Jesús chi jujunalak: Wajawl, ¿ma' ini'n ta'n? xche'tak re. ");
INSERT INTO uspNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Kakaj Jesús xij chic rechak: Jun ri xmu' jcuxlanwa wiq'uil li lak, ri' li injachow pi camic. ");
INSERT INTO uspNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Jc'ajol Kakaj Dios ri xwux pi cristianil jilon tib'an re chapca' tz'ib'al chirij li wuj re Lok'laj Jyolj Kakaj Dios, pero ri' mas c'ur jwich man ri tijachow re pi camic. Ri' mas tzi pire re mitne' xq'uisi'yc, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Xpe Judas ri tijachow re Kakaj Jesús pi camic, xtz'onaj re Kakaj Jesús: Kajtijonl, ¿ma' ini'n ta'n? xche' re. Kakaj Jesús xij chic re: Ati'n, xche' re. ");
INSERT INTO uspNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Ajruc're' Kakaj Jesús xc'am jun cuxlanwa, xc'omowaj re Kakaj Dios y xq'uer. Xye' rechak yak ajtijol rib'ak chirij, xij: Tij awechak, ri' ri intio'jl, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Y xc'am man nejb', xc'omowaj re Kakaj Dios. Xye' rechak yak ajtijol rib'ak chirij, xij: Tij awechak atak juntir ri wi' xilj man nejb' ri. ");
INSERT INTO uspNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Man ri wi' li nejb' ri' inquiq'uel ri quiek la' xaan man aac' chomorsa'n y tina tz'utuwna chi jtojic jmacak sub'laj cristian. ");
INSERT INTO uspNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Tamb'ij chawechak chi in ta' tantij vin re uva aac'lak asta ajri' chiqui' tantij aac' vin re uva aac'lak lamas titakonwi' Inkaj, xche' rechak yak ajtijol rib'ak chirij. ");
INSERT INTO uspNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Cuando xantaj jb'ixaj jun b'ix jwi'lak pire jnimirsaj jk'ij Kakaj Dios, xe'tak wich witz ri jb'ij Olivos. ");
INSERT INTO uspNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Xpe Kakaj Jesús, xij chic rechak yak ajtijol rib'ak chirij: Lak'ab' wica atak juntir tatil ayb'ak chwij jwi'l ta' chiqui' ticub'ar ach'olak chwij, jwi'l tz'ib'ali' li wuj re Lok'laj Jyolj Kakaj Dios ri tijb'ij jilonri: Tancamsaj man ajyuk' y juntir mak carner tijtil rib'ak, tiche'. ");
INSERT INTO uspNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Pero cuando tic'astasaj inwch laj incamnakl, innab'erb'i chawchak ojb'etak Galilea, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Xpe Pedro, xij re Kakaj Jesús: Onque juntir tijtil rib'ak chawij, pero in ta' imb'ec, xche' re. ");
INSERT INTO uspNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Kakaj Jesús xij re Pedro: Kes tz'etel tz'et tamb'ij chawe chi lak'ab' wica jorok ab'iji' oxmul chi ta' tach'ob' inwch cuando tiok' man puy, xche' re. ");
INSERT INTO uspNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Pedro xij chic re Kakaj Jesús: Onque incamsaj chawij, pero in ta' tamb'ij chi ta' tanch'ob' awch, xche'. Y juntir rib'ilak yak ajtijol rib'ak chirij jilon xijtak. ");
INSERT INTO uspNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Kakaj Jesús pach yak ajtijol rib'ak chirij xe'tak li jun luwar ri jb'ij Getsemaní y cuando xtawtak cla', xij re yak ajtijol rib'ak chirij: Cub'rentak neri, inna b'ena jili chi ch'a'wem riq'ui Kakaj Dios, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Y xc'amb'i Pedro chirij pach yak quib' jc'ajol Zebedeo. Kakaj Jesús xpe jun c'ax laj ranm jwi'l b'is. ");
INSERT INTO uspNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Xij rechak yak ajtijol rib'ak chirij: Wi' jun nimlaj b'is laj wanm, twic'aj in ri' incamsanc. Canentak atak neri, pero yo'rentak wiq'uil, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Ajruc're' Kakaj Jesús xjutumb'i junquitz, xxucar asta xtaw chi' jwich lak ulew, xoc chi ch'a'wem riq'ui Kakaj Dios, xij: At Inkaj, wi tijna' inacol laj jk'ab' juntir c'ax, pero ma' ri' ta' tab'an lawi' chwaj in, ri' b'an lawi' chawaj at, xche' re Kakaj Dios. ");
INSERT INTO uspNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Ajruc're' xk'ajch lamas xcantak yak uxib' ajtijol rib'ak chirij y cuando xtaw riq'uilak, rechak tijintak chi waraj, xij re Pedro: Ni jun or xacuytak xatyo'rtak wiq'uil. ");
INSERT INTO uspNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Yo'rentak y ch'a'wentak riq'ui Kakaj Dios pire ma' taye' ayb'ak attakchi'jtak chi macunc. Asantilak raji' atyo'rtak, pero ri' atio'jlak ta' raj, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Xe' chic Kakaj Jesús jca'mul chi ch'a'wem riq'ui Kakaj Dios, xij jilonri: At Inkaj, wi ta' tijna' inacol pire ma' incamc, ri' b'an lawi' chawaj at tab'an, xche' re Kakaj Dios. ");
INSERT INTO uspNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Cuando xk'aj chicch lamas wi'tak yak uxib' ajtijol rib'ak chirij, xe' jte'tak tijintak chi waraj jwi'l sub'laj c'ax waraj rechak. ");
INSERT INTO uspNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Xcan jye'tak cla' y xe' chic roxmul chi ch'a'wem riq'ui Kakaj Dios. Xe' jb'ij chic chapca' ri xij laj jca'mul. ");
INSERT INTO uspNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Ajruc're' xk'aj chicch lamas wi'tak uxib' yak ajtijol rib'ak chirij y xij rechak: Ajwichi' attijintak chi waraj y ajwichi' attijintak chi uxlan. Xtawi' chiwch tijachsaj Jc'ajol Kakaj Dios ri xwux pi cristianil laj jk'ab'ak yak ajmacb'. ");
INSERT INTO uspNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","¡B'iitentak! ¡Jo'tak! Xpeti' man ri injachow pi camic, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Aj tijini' Kakaj Jesús chi yoloj riq'uilak yak ajtijol rib'ak chirij cuando xtaw Judas ri jun rechak yak cab'lajuj (12) ajtijol rib'ak chirij Kakaj Jesucristo pach sub'laj q'ui cristian c'amalb'i espad y che' jwi'lak, ri takaltakb'i jwi'lak mak jb'ab'alak yak ajc'amaltak jb'eak cristian riq'ui Kakaj Dios y jwi'lak yak ri wi' rekle'nak chijxo'lak yak rijajl Israel. ");
INSERT INTO uspNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Judas ri tijachow re Kakaj Jesús pi camic xiji' rechak nen tran chi jc'utic Kakaj Jesús chiwchak, xij rechak jilonri: Nen ri tantz'ub'aj jk'otz', ri' li Jesús, chaptak, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Cuando xtawtak xpe Judas xjutun chijc'ulel Kakaj Jesús xij re: Xoc ak'ab' Kajtijonl, xche' re. Y xtz'ub'aj jk'otz'. ");
INSERT INTO uspNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Kakaj Jesús xij re Judas: At impach, b'an ri petzalcat chi jb'anic, xche' re. Ajruc're' xpetak mak cristian ri xamtak chirij Judas xjutuntak chijc'ulel Kakaj Jesús, xchaptakb'ic. ");
INSERT INTO uspNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Xpe jun rechak yak ajtijol rib'ak chirij Kakaj Jesucristo, xresajch respad y xc'urb'i jun jxicn man jmocom man nimlaj jb'ab'alak yak ajc'amaltak jb'eak cristian riq'ui Kakaj Dios. ");
INSERT INTO uspNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Kakaj Jesús xij re: C'ol awespad laj jluwr jwi'l juntir ri tich'o'jintak chi espad, chi espad ticamsajtak. ");
INSERT INTO uspNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿Ta'c'u awetam chi in tijna' roj tamb'ij re Inkaj chi injt'o'w y re laj or tijtakch oxc'al cab'lajuj mil (72,000) ranjl chi int'o'ic? ");
INSERT INTO uspNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Pero witi tamb'an jilonli, ta' titaw chiwch ri tijb'ij li wuj re Lok'laj Jyolj Kakaj Dios chi tina b'anna jilonli, xche' re. ");
INSERT INTO uspNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Ajruc're' xtz'onaj rechak mak cristian: ¿Nen chac xac'amtakch espad y che' chi inchapic? ¿In inc'u jun alk'om tawiltak? Nojel k'ij xintijoj cristian li nimi richoch Kakaj Dios y ta' xinachaptak. ");
INSERT INTO uspNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Pero juntir ri tijin tib'an pirechi' titaw chiwch ri xcan jtz'ib'ajtak yak ajk'asaltak Jyolj Kakaj Dios li wuj re Lok'laj Jyolj Kakaj Dios, xche' Kakaj Jesús rechak. Cuando xij jilonli juntir yak ajtijol rib'ak chirij Kakaj Jesucristo xelmajtak y xcan jye'tak Kakaj Jesús ric'an. ");
INSERT INTO uspNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Mak ri xchapowtakb'i re Kakaj Jesús xc'amtakb'i riq'ui Caifás man nimlaj jb'ab'alak yak ajc'amaltak jb'eak cristian riq'ui Kakaj Dios y cla' xmulb'a' rib'ak yak ajtijoltak cristian re Jpixb' Kakaj Dios pach yak ri wi' rekle'nak chijxo'lak yak rijajl Israel. ");
INSERT INTO uspNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Pedro xtakeji'b'i Kakaj Jesús, pero chinajchak b'esal asta xtaw chuchja re richoch man nimlaj jb'ab'alak yak ajc'amaltak jb'eak cristian riq'ui Kakaj Dios. Xcub'ar chijxo'lak mak ajchajaltak re nimi richoch Kakaj Dios, re ri' raj tril nen tib'an re Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Mak jb'ab'alak yak ajc'amaltak jb'eak cristian riq'ui Kakaj Dios pach juntir mak comontak jb'ab'alak yak rijajl Israel tijin tijtoctak jono cristian pire tijb'ij jun molb'i tzij chirij Kakaj Jesús pire ticamsaj. ");
INSERT INTO uspNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Pero ta' xta'tak ni jono jmac, onque wi' sub'laj q'ui xtawtak chi jcojic tzij chirij Kakaj Jesús, pero ta' tz'et ri xijtak. Pi q'uisb'ire xtaw chic quib' chi jcojic tzij chirij y ");
INSERT INTO uspNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","xijtak: Oj xkata' cuando xij man winak ri jilonri: In incwini' chi jyojic nimi richoch Kakaj Dios y li uxib' k'ij tamb'an jun chic, xche', xche'tak. ");
INSERT INTO uspNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Xpe man nimlaj jb'ab'alak yak ajc'amaltak jb'eak cristian riq'ui Kakaj Dios, xwa'rc, xtz'onaj re Kakaj Jesús: ¿Nen chac ta' tac'ululaj mak cristian li, ri ticojowtak tzij chawij? ¿Nen chac ta' nen tab'ij chirij amac ri tijin tijb'ijtak chawij? xche' re Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Pero Kakaj Jesús ta' xc'ululaj. Xpe man nimlaj jb'ab'alak yak ajc'amaltak jb'eak cristian riq'ui Kakaj Dios, xij re Kakaj Jesús: In tamb'ij chawe chi tab'ij chwe laj jb'ij Kakaj Dios ri yo'l, wi tz'etel tz'et ati' Jc'ajol Kakaj Dios ri b'il jwi'l chi tina jtaknach wich ulew, xche' re Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Kakaj Jesús xij re: Ini'n, jilon chapca' ri xab'ij y in tamb'ij chawechak, atak juntir tina awiltakna jwich Jc'ajol Kakaj Dios ri xwux pi cristianil tib'e cub'arch laj jpaach Kakaj Dios ri wi' jcwinel y tipe chic li sutz' lecj nen or, xche' re. ");
INSERT INTO uspNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Xpe man nimlaj jb'ab'alak yak ajc'amaltak jb'eak cristian riq'ui Kakaj Dios, xrech'b'i ritz'ik chirij jwi'l retzal y xij: ¡Man winak ri tijin tijcoj rib' pi Jc'ajol Kakaj Dios! Ta' chiqui' tichocon mas ajcojoltak tzij chirij kawi'l. Atak xata'taka' chi man winak ri tijin tijcoj rib' pi Jc'ajol Kakaj Dios. ");
INSERT INTO uspNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿Nen tab'ijtak atak chirij? xche' rechak mak cristian. Mak cristian xijtak: Pi jmaqui' ticamsajc, xche'tak. ");
INSERT INTO uspNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Xpetak, xoctak chi jchub'aj jcayb'al y xsec'tak chi k'ab' y nic'j chic xpak'tak jcayb'al chi k'ab'. ");
INSERT INTO uspNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Y xijtak re: At ri b'il jwi'l Kakaj Dios chi tina jtaknach wich ulew, b'ijneca' chike, ¿nen xatsec'owc? xche'tak re. ");
INSERT INTO uspNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Pedro cub'ul chuchja, xpe jun anm ajic' xjutun chijc'ulel y xij re: At, ati' jpach Jesús ri aj Galilea, xche' re. ");
INSERT INTO uspNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Pero Pedro xij chiwchak juntir cristian ri wi'tak cla' chi ta' tijch'ob' jwich Kakaj Jesús, xij: Ta' wetam nen quiek chirij tab'ij jilonli, xche' re man ajic'. ");
INSERT INTO uspNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Pedro xelb'i cla', xe' chi' oqueb' re chuchja y xilsaj chicb'i cla' jwi'l jun ajic' chic y xij rechak cristian ri wi'tak cla': Man winak ri jpachi' Jesús aj Nazaret, xche' man ajic'. ");
INSERT INTO uspNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Y Pedro xij chic chi ta' tijch'ob' jwich Kakaj Jesús, xij: Kes tz'etel tz'et tamb'ij chi ta' tanch'ob' jwich man winak li, xche' re man ajic'. ");
INSERT INTO uspNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Ajri'ke jun rat jb'ij jwi'l Pedro jilonli xpetak nic'j cristian chic ri wi'tak cla', xjutuntak chijc'ulel Pedro y xijtak re: Tz'etel tz'et, at, ati' jun rechak mak jpach Jesús, na'li' atyolowc, xche'tak re. ");
INSERT INTO uspNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Pedro xij chic chi tz'etel tz'eti' ri tijb'ij y wi mita' tz'et tijb'ij, tib'ani' k'atb'itzij chib' jwi'l Kakaj Dios, xij: Ta' tanch'ob' jwich man winak li, xche'. Cuando xijmaj jilonli jwi'l Pedro, xok' jun puy. ");
INSERT INTO uspNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Ajruc're' xcuxtaj jwi'l Pedro ri xijsaj re jwi'l Kakaj Jesús: Lak'ab' wica cuando ajqui' chi ok' man puy, at jorok ab'iji' oxmul chi ta' tach'ob' inwch, xche' re. Jwi'li'li Pedro tik'utut ranm, xelb'i cla', xe' jcamsaj rib' chi ok'ej. ");
INSERT INTO uspNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Cuando xsakarsanc, juntir mak jb'ab'alak yak ajc'amaltak jb'eak cristian riq'ui Kakaj Dios pach yak ri wi' rekle'nak chijxo'lak yak rijajl Israel xchomorsajtak jcamsaj Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Ximtakb'i Kakaj Jesús y xc'amtakb'ic. Xe' jache'tak laj jk'ab' Pilato ri man jb'ab'al k'atb'itzij re Judea. ");
INSERT INTO uspNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Judas ri xjachow re Kakaj Jesús pi camic, cuando xril chi xansaji' k'atb'itzij chirij Kakaj Jesús pire ticamsaj, xk'utut ranm jwi'l xan jilonli, xe' jk'asaj mak junwinak lajuj (30) chi pwak ri b'anal la' plata rechak mak jb'ab'alak yak ajc'amaltak jb'eak cristian riq'ui Kakaj Dios pach yak ri wi' rekle'nak chijxo'lak yak rijajl Israel. ");
INSERT INTO uspNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Xij rechak: Xintoca' immac chiwch Kakaj Dios jwi'l xinjach Jesús pi camic chi ma'qui' jmac, xche' rechak. Rechak xijtak re Judas: Ta' nen kacwent oj re li. Ati' xatchomorsan xab'an jilonli, xche'tak re. ");
INSERT INTO uspNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Xpe Judas, xcan jt'oje' man pwak li nimi richoch Kakaj Dios, xelb'ic, xe' jitz'aj rib'. ");
INSERT INTO uspNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Xpetak mak jb'ab'alak yak ajc'amaltak jb'eak cristian riq'ui Kakaj Dios, xb'ittak man pwak li y xijtak: Ta' tijna' tikaye' li cax re c'ulb'i pwak ri tisipaj re Kakaj Dios jwi'l man pwak li xchoconi' pire tojb'ire jun camsanc, xche'tak. ");
INSERT INTO uspNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Xchomorsajtak chirib'il rib'ak xlok'tak jun ulew la' man pwak li ri tib'ijsaj re, rulew man ajb'anal kelen la' xok'ol. Y xcan jye'tak pire mukb'i rechak yak ma' rijajl ta' Israel. ");
INSERT INTO uspNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Jwi'li'li lajori man ulew li aj tib'ijsaji' man ulew re tojb'ire jun camsan re. ");
INSERT INTO uspNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Jilonli xtaw chiwch ri xij Jeremías ri ajk'asal Jyolj Kakaj Dios ojrtaktzij cuando xij: La' mak junwinak lajuj (30) chi pwak ri b'anal la' plata ri rijil winak ri xlok'tak yak rijajl Israel, ");
INSERT INTO uspNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","la' man pwak li xlok'tak jun ulew ri tib'ijsaj re, rulew man ajb'anal kelen la' xok'ol chapca' xijsaj chwe jwi'l Kakaj Dios ri Kajawl, xche'. ");
INSERT INTO uspNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Kakaj Jesús xc'amsajb'i chiwch Pilato ri man jb'ab'al k'atb'itzij. Pilato xtz'onaj re: ¿Atni' jreyak yak rijajl Israel? xche' re. Kakaj Jesús xij re: Ini'n, jilon chapca' ri xab'ij, xche' re. ");
INSERT INTO uspNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Xpetak mak jb'ab'alak yak ajc'amaltak jb'eak cristian riq'ui Kakaj Dios pachak yak ri wi' rekle'nak chijxo'lak yak rijajl Israel xcojtak tzij chirij Kakaj Jesús, pero Kakaj Jesús ta' xc'ululanc. ");
INSERT INTO uspNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Xril Pilato chi Kakaj Jesús ta' tich'a'wc, xtz'onaj re: ¿Ta' tata juntir li ri tijb'ijtak chawij? xche' re. ");
INSERT INTO uspNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Pero Kakaj Jesús ta' xc'ululaj ni jun yoloj ri tijb'ijtak chirij, jwi'li'li man jb'ab'al k'atb'itzij sub'laj xsaach jch'ol chi rilic Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Man jb'ab'al k'atb'itzij re Judea nak'tali' nojel junab' re man nimak'ij tijtak jun prex lawi' rajak cristian titaksajc. ");
INSERT INTO uspNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","La' mak k'ij li wi' jun winak li cars ri jb'ij Barrabás. Man winak li etemali' chi sub'laj etzl jno'j. ");
INSERT INTO uspNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Cuando mulantak juntir cristian xpe Pilato xtz'onaj rechak: ¿Nen chi prex lal chawajak tantakb'ic? ¿Roni' tantakb'i Barrabás o ri' tantakb'i Jesús ri tib'ijsaj re chi ri' ri b'il jwi'l Kakaj Dios chi tina jtaknach wich ulew? xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Jilonli xij rechak jwi'l re retami' chi xjachtak Kakaj Jesús laj jk'ab' jwi'lke tijti'tijtak. ");
INSERT INTO uspNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Aj cub'uli' Pilato lamas tran jk'atb'itzij, xpe rixokl xtakb'i jb'ij re: Ma coj ayb' chi jb'anic c'ax re winak li ri ta' ni jun jmac, jwi'l lak'ab' mir wi' jun ichic' ximb'an chirij y sub'laj sachal inch'ol jwi'l, xche'b'i re. ");
INSERT INTO uspNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Pero xpetak mak jb'ab'alak yak ajc'amaltak jb'eak cristian riq'ui Kakaj Dios pach yak ri wi' rekle'nak chijxo'lak yak rijajl Israel xcwintaka' chi jtakchi'j cristian pire tijb'ijtak re Pilato chi tijtakb'i Barrabás y tijtak jcamsaj Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Xpe man jb'ab'al k'atb'itzij, xtz'onaj chic rechak: ¿Nenc'u rechak chi quib' chawajak tantakb'ic? xche' rechak. Rechak cow xch'ejejtak, xijtak: ¡Takb'i Barrabás! xche'tak. ");
INSERT INTO uspNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilato xtz'onaj rechak: ¿Nenc'u tamb'an re Jesús ri tib'ijsaj re chi ri' ri b'il jwi'l Kakaj Dios chi tina jtaknach wich ulew? xche' rechak. Juntir rechak cow xch'ejejtak, xijtak: ¡Camsaj wich curs! xche'tak. ");
INSERT INTO uspNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Pilato xtz'onaj rechak: ¿Nenc'u kes c'ax b'anal jwi'l? xche' rechak. Pero rechak sub'laj cow xch'ejejtak, xijtak chic: ¡Camsaj wich curs! xche'tak chic. ");
INSERT INTO uspNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Cuando Pilato xril chi ta' ticwin chi jcolic Kakaj Jesús jwi'l mak cristian cow xch'ejejtak y xpe mas retzalak, xtak jc'amic ja', xch'aj jk'ab' chiwchak juntir cristian y xij rechak: In ta' tantoj jcamic winak li riq'ui Kakaj Dios. Atak, atiliwtak nen tab'antak, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Y juntir rib'ilak xijtak: Oj pachak juntir kalc'wal ojtojow re jcamic riq'ui Kakaj Dios, xche'tak. ");
INSERT INTO uspNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Xpe Pilato, xtak resaj Barrabás li cars y xtak jseq'uic Kakaj Jesús. Ajruc're' xjachb'i pire tib'e jcamsajtak wich curs. ");
INSERT INTO uspNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Xpetak mak jsoldad man jb'ab'al k'atb'itzij, xc'amtakb'i Kakaj Jesús li nimlaj richoch man jb'ab'al k'atb'itzij y xmulb'a'tak juntir mak soldad ri wi'tak cla' chirij Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Xresajtak ritz'ik Kakaj Jesús chirij y ximtak jun nimlaj quiek itz'ik chirij. ");
INSERT INTO uspNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Xpach'ujtak jun coron la' q'uix y xcojtak laj jb'a y xye'tak jun che' laj jpaach jk'ab'. Xxucartak chiwch y xoctak chi ritz'b'ej jwich, xijtak re: ¡Nim ak'ij, at jreyak yak rijajl Israel! xche'tak re. ");
INSERT INTO uspNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Xoctak chi jchub'aj jwich y xc'amtak man che' laj jk'ab', xoctak chi jseq'uic laj jb'a la'. ");
INSERT INTO uspNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Cuando xantaj juntir li jwi'lak re Kakaj Jesús, xresajtak chic man nimlaj itz'ik chirij y xcojtak chic ritz'ik chirij y xc'amtakb'i pire tib'e jcamsajtak wich curs. ");
INSERT INTO uspNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Cuando b'esaltak lak b'e xc'ultak jun winak aj Cirene ri jb'ij Simón, xchaptak y xijtak re chi trikajb'i jcurs Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Cuando xtawtak li jun luwar ri jb'ij Gólgota, ri jcholajl tielwi', jb'akel jb'a camnak, ");
INSERT INTO uspNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","xye'tak vin re Kakaj Jesús chi tijem ri yujul pach c'alaj woron, pero Kakaj Jesús xike xric'aj la' raak' y ta' raj xtij. ");
INSERT INTO uspNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Cuando jorok tz'ocmaji' Kakaj Jesús wich curs, xpetak mak soldad xantak suert chirij ritz'ik nen chi itz'ik lal tijch'ectak chi jujunalak. ");
INSERT INTO uspNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Ajruc're' xcub'artak cla' chi jchajaj Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Y wich curs chib' Kakaj Jesús xcojsaj jun kelen tz'ib'al jwich ri lamas tijb'ij nen chac xcamsajtak wich curs ri tijb'ij: RI' RI JESÚS JREYAK YAK RIJAJL ISRAEL, tiche'. ");
INSERT INTO uspNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Y xtz'ocsaj quib' alk'om wich curs pi jpach Kakaj Jesús, jun laj jpaach y jun chic laj jmax. ");
INSERT INTO uspNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Mak cristian ri tik'axtak chijc'ulel Kakaj Jesús tritz'b'ejtak jwich, tijsutaj jb'aak chi jb'ij re: ");
INSERT INTO uspNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","¡At ri tab'ij chi tayoj nimi richoch Kakaj Dios y li uxib' k'ij tab'an chic jun, col ayb' awic'an! ¡Wi tz'etel tz'eti' at Jc'ajol Kakaj Dios, kejench wich curs! xche'tak re. ");
INSERT INTO uspNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Y jilon mak jb'ab'alak yak ajc'amaltak jb'eak cristian riq'ui Kakaj Dios pach yak ajtijoltak cristian re Jpixb' Kakaj Dios pach yak ri wi' rekle'nak chijxo'lak yak rijajl Israel xoctak chi ritz'b'ej jwich Kakaj Jesús, xijtak: ");
INSERT INTO uspNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Xcwini' chi jcolic cristian, pero re ta' ticwin chi jcolic rib' ric'an. Wi ri' jreyak yak rijajl Israel, kejokch wich curs ric'an, ajruc're' tikacoj ri tijb'ij. ");
INSERT INTO uspNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Cub'uli' jch'ol chirij Kakaj Dios, lajori colsajok jwi'l Kakaj Dios wi kes tz'et jor tilok'aj jwi'l Kakaj Dios jwi'l re xiji'n: Ini' Jc'ajol Kakaj Dios, xche', xche'tak. ");
INSERT INTO uspNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Y jilon mak alk'om ri xtz'ocsajtak wich curs pi jpach Kakaj Jesús xritz'b'ejtaka' jwich Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Raj tiq'uil k'ij re cab'lajuj (12) xoc uku'm juntir wich ulew asta laj jrox or re b'esal k'ij. ");
INSERT INTO uspNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Raj laj jrox or re b'esal k'ij cow xch'ejej Kakaj Jesús, xij: Elí, Elí, ¿lama sabactani? xche'. Ri jcholajl tielwi' tijb'ij: ¡At Inkaj Dios! ¡At Inkaj Dios! ¿Nen chac xincan aye' wic'an? tiche'. ");
INSERT INTO uspNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Jujun rechak mak ri wi'tak cla', cuando xtatak nen xij Kakaj Jesús, xijtak: Man winak ri, tijin tijsiq'uij Elías ri ajk'asal Jyolj Kakaj Dios, xche'tak. ");
INSERT INTO uspNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Laj or xpe jun rechak mak ri wi'tak cla', xe' jol chi jtoquic jun esponj y xmu'b'i li vinagre. Ximb'i chi jtzam jun che' y xye' laj jchi' Kakaj Jesús pire tijtij. ");
INSERT INTO uspNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Xpetak mak nic'j, xijtak: Wa'xna cla', kile'na wi tipe Elías chi jcolic, xche'tak. ");
INSERT INTO uspNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Kakaj Jesús cow xch'ejejc, xjach jsantil laj jk'ab' Kakaj Dios y xcamc. ");
INSERT INTO uspNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Cuando xcam Kakaj Jesús, xrech'maj laj nic'j man itz'ik re tosb'i jpam nimi richoch Kakaj Dios, quib' xelwi', xrech'majch pi ajsic asta iquim. Y xpe jun cab'rakn y mak ab'aj xpaxtak. ");
INSERT INTO uspNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Mak mukb'i camnak xtertak. Y sub'laj cristian camnaktak ri tosoltak pire Kakaj Dios xc'astasaji' jwichak laj jcamnaklak. ");
INSERT INTO uspNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Xeltakch lamas mukultakwi'. Cuando jorok c'astasaji' jwich Kakaj Jesús laj jcamnakl, ajruc're' xoctak li lok'laj tilmit Jerusalén y sub'laj cristian xiliwtak jwichak. ");
INSERT INTO uspNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Y man jb'ab'alak mak soldad pach mak jpach ri wi'tak chi jchajaj Kakaj Jesús cuando xric'ajtak man nimlaj cab'rakn y xriltak juntir ri xaanc, sub'laj xtzaak jch'olak, xijtak: ¡Kes tz'etel tz'et winak ri Jc'ajoli' Kakaj Dios! xche'tak. ");
INSERT INTO uspNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Sub'laj anm wi'takb'i chinaj chi na'tunc. Y ri'taka' yak anm li xpetak chirij Kakaj Jesús chi jt'o'ic cuando xelch Galilea. ");
INSERT INTO uspNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Chijxo'lak yak anm li, wi'taka' María Magdalena pach María ri jchuchak Santiago pach José pach jchuchak yak jc'ajol Zebedeo. ");
INSERT INTO uspNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Cuando oquem tran ak'ab' xpe jun winak b'iom aj Arimatea ri jb'ij José, re ajtijol rib'i' chirij Kakaj Jesucristo. ");
INSERT INTO uspNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Xpe José, xe' riq'ui Pilato chi jtz'onaj jcamnakl Kakaj Jesús. Pilato xij chi tiye'saj jcamnakl Kakaj Jesús re. ");
INSERT INTO uspNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Xpe José, xc'amb'i jcamnakl Kakaj Jesús, xb'atz'b'i la' jun itz'ik ri jb'ij lino ri ta' tz'il la' ");
INSERT INTO uspNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","y xe' jmuke' li jun nimlaj aac' jul ri c'otol li ab'aj re mukb'i camnak. Man jul li rechi' re b'anal jwi'l. Cuando xye'maj jcamnakl Kakaj Jesús jwi'l cla', xcan jtz'apij jchi' man jul la' jun nimlaj ab'aj y xec'. ");
INSERT INTO uspNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","María Magdalena pach jun María chic xcan cub'artak chiwch man jul lamas xye'saj jcamnakl Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Laj jcab' k'ij re jmukic Kakaj Jesús ri' k'ij re uxlan. La' man k'ij li xpetak mak jb'ab'alak yak ajc'amaltak jb'eak cristian riq'ui Kakaj Dios pach mak fariseo xe'tak riq'ui Pilato. ");
INSERT INTO uspNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Xijtak re: Kaj, xcuxtaj kawi'l chi man jo'slaj winak li cuando aj yo'lna xij chi tina c'astasajna jwich laj jcamnakl laj jrox k'ij. ");
INSERT INTO uspNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Jwi'li'li ri' mas tzi tatakb'i soldad chi jchajaj man jul lamas xmuksajwi' asta tiel uxib' k'ij, jwi'l ta' c'axre' wi tipetak yak ajtijol rib'ak chirij tiyuk resajtak jcamnakl lak'ab' tib'e jmuke'tak chic li jun jalan luwar y tijb'ijtak rechak cristian chi xc'astasaji'b'i jwich laj jcamnakl xo'lak camnakib'. Wi xantak jilonli man q'uisb'i jo'slaj tzij tib'e mas chi nim chiwch man nab'e jo'slaj tzij, xche'tak re Pilato. ");
INSERT INTO uspNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilato xij rechak: Co' nic'j soldad li, jattak, c'amtakb'ic y tzi jtz'apij man jul tib'e ab'ane'tak, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Rechak xe'tak xcojtak jun retal la' man ab'aj ri cojol chi' man jul pire tic'utun wi wi' nen titeb'an re y xcan jye'tak mak soldad li cla' chi jchajajc. ");
INSERT INTO uspNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Cuando xk'ax man k'ij re uxlan y xsakarsan li nab'e k'ij re xuman, María Magdalena pach jun María chic xe'tak chi' jul lamas xye'sajwi' jcamnakl Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Etke xpe jun nimlaj cab'rakn jwi'l wi' jun ranjl Kakaj Dios ri Kajawl xkejch lecj y xjutun chi' jul lamas xye'sajwi' jcamnakl Kakaj Jesús, xsolcopijb'i man ab'aj ri cojol chi' man jul y xcub'ar chib'. ");
INSERT INTO uspNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Man anjl li sub'laj tikopopon rij chapca' coyop y ritz'ik sub'laj sak chapca' jsakil chun tew. ");
INSERT INTO uspNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Mak soldad, cuando xriltak jwich anjl, sub'laj xtzaak jch'olak y tichak querquentak jwi'l tzakom ch'olal y xcantak chapca' camnaktak. ");
INSERT INTO uspNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Xpe anjl, xij rechak yak anm: Mi tzaak ach'olak. In wetami' chi ri' tijin tatoctak Kakaj Jesús ri xcamsaj wich curs. ");
INSERT INTO uspNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Re ta' chiqui' neri, xc'astasaji'b'i jwich laj jcamnakl chapca' ri b'il jwi'l. Tzajtak, yuk awile'tak lamas xye'saj jcamnakl, ta' chiqui' nen wi'. ");
INSERT INTO uspNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Jattak laj or, b'ijtatak rechak yak ajtijol rib'ak chirij chi xc'astasaji'b'i jwich laj jcamnakl y tinab'eri'b'i chawchak atb'etak Galilea, cla' tib'e awile'tak jwich. Xike li ri tamb'ij chawechak, xche' anjl rechak yak anm. ");
INSERT INTO uspNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Yak anm li, laj or xeltakb'i chi' jul lamas xye'sajwi' jcamnakl Kakaj Jesús. Junquitz tzakal jch'olak y junquitz tiqui'cottak, xe'tak jol xe' jb'ijtak rechak yak ajtijol rib'ak chirij Kakaj Jesucristo. ");
INSERT INTO uspNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Cuando b'esaltak yak anm li b'e, etke xc'ul rib'ak pach Kakaj Jesús y xc'amsaj rutzil jwichak. Rechak xjutuntak chijc'ulel, xxucartak, xk'alujtak rakan y xnimirsajtak jk'ij. ");
INSERT INTO uspNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Kakaj Jesús xij rechak: Mi tzaak ach'olak, b'ijtatak rechak yak ink'un chi tib'etak Galilea. Cla' tib'e rile'tak inwch, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Cuando b'esaltak yak anm li b'e, xpetak nic'j mak soldad ri wi'tak chi jchajaj man jul, xe'tak li tilmit chi jb'ij rechak mak jb'ab'alak yak ajc'amaltak jb'eak cristian riq'ui Kakaj Dios juntir ri xriltak. ");
INSERT INTO uspNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Xpetak mak jb'ab'alak yak ajc'amaltak jb'eak cristian riq'ui Kakaj Dios, xe' jch'ab'ejtak yak ri wi' rekle'nak chijxo'lak yak rijajl Israel, xchomorsajtak chirib'il rib'ak chi tijye'tak sub'laj pwak rechak mak soldad pire ma' tijb'ijtak ri xriltak. ");
INSERT INTO uspNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Xijtak rechak mak soldad: Atak b'ijtak jilonri: Lak'ab' cuando xe' kawarj, xtawtak mak ajtijol rib'ak chirij Jesús, xresajtak jcamnakl, xc'amtakb'ic, atche'tak. ");
INSERT INTO uspNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Y wi xta man jb'ab'al k'atb'itzij juntir ri xaanc, oj ojchomorsan riq'uil, atak mi tzaak ach'olak, atkacola'taka' pire ta' nen tran chawechak, xche'tak re mak soldad. ");
INSERT INTO uspNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Mak soldad xc'ultak man pwak y xantak chapca' ri xijsaj rechak. Jilonli xresajtak jtaquil chi ta' tz'et xc'astasaj jwich Kakaj Jesús laj jcamnakl, asta lajori ajwichi' jilon jtaquil chijxo'lak yak rijajl Israel. ");
INSERT INTO uspNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Yak junlajuj (11) ajtijol rib'ak chirij Kakaj Jesucristo xe'tak Galilea pire tib'etak la' man witz ri xijsaj rechak jwi'l Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Cuando xriltak jwich Kakaj Jesús xnimirsajtak jk'ij, pero wi' jujun rechak ta' kes tijcojtak wi ri' Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Xpe Kakaj Jesús, xjutun riq'uilak y xij rechak: Kakaj Dios xya' k'atb'itzij laj ink'b' pire intakon chib'ak juntir ri wi'tak lecj y juntir ri wi'tak wich ulew. ");
INSERT INTO uspNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Lajori jattak riq'uilak juntir cristian wich ulew, tijojtak pire tioctak pi ajtijol rib'ak chwij. B'antak ja'tiox rechak laj jb'ij Kakaj Dios, laj jb'ij Jc'ajol Kakaj Dios y laj jb'ij Lok'laj Jsantil Kakaj Dios. ");
INSERT INTO uspNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Y tijojtak chi jb'anic juntir ri ximb'ij chawechak. In, inwa'xi' aac'lak nojel k'ij asta tiq'uis jwich k'ijsak, xche' Kakaj Jesús rechak yak ajtijol rib'ak chirij.");
INSERT INTO uspNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Jilonri xticarch ri tzilaj jtaquil chirij Kakaj Jesucristo, ri Jc'ajol Kakaj Dios. ");
INSERT INTO uspNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Jilon xcan jtz'ib'aj Isaías ri ajk'asal Jyolj Kakaj Dios cuando Kakaj Dios xij jilonri: Tina intaknab'i intako'n nab'e chawch pire tijb'ij rechak cristian chi rajwaxi' tijq'uex jno'jak chinwch nic' riq'uil tran jwa'x jun ab'e. ");
INSERT INTO uspNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Y tina tasajna jun ri cow tich'ejej li jun luwar lamas ta' cristian, ri tijb'ij jilonri: B'antak jwa'x jb'e Kakaj Jesús ri Kajawl, teb'a'tak jb'e suc'ul laj awanmak, tiche', xche' Kakaj Dios, xche' Isaías. ");
INSERT INTO uspNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Jilonli, cuando xpe Juan Ajb'anal Ja'tiox chi jb'anic ja'tiox rechak cristian li jun luwar lamas ta' cristian, xij rechak chi rajwaxi' tijq'uex jno'jak pire ticuysaj juntir jmacak jwi'l Kakaj Dios y tib'ansaj ja'tiox rechak. ");
INSERT INTO uspNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Sub'laj cristian ri tipetak lak mac'ultak luwar re Judea y tipetak Jerusalén xtawtak chi jtaic jxolj Juan Ajb'anal Ja'tiox. Lawi' ri xc'am jk'ab'al jmacak chiwch Kakaj Dios, Juan Ajb'anal Ja'tiox xan ja'tiox rechak li nimi ja' Jordán. ");
INSERT INTO uspNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Ritz'ik Juan Ajb'anal Ja'tiox ri tijcoj b'anal la' rusumal camello y jpas b'anal la' tz'um y sac' pach cab' re lak che' tijtij pire jwa. ");
INSERT INTO uspNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Juan Ajb'anal Ja'tiox xij rechak cristian: Petzal chiqui' jun chwij mas jcwinel chinwch in. In ta' tic'ular pi we intacar chi jquiric jc'amul jxajb'. ");
INSERT INTO uspNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","In kes tz'et la' ja' ximb'an ja'tiox chawechak, pero re tina ranna ja'tiox chawechak la' Lok'laj Jsantil Kakaj Dios, xche' Juan Ajb'anal Ja'tiox rechak cristian. ");
INSERT INTO uspNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","La' mak k'ij li, Kakaj Jesús xelch Nazaret ri jun tilmit re Galilea y xtaw riq'ui Juan Ajb'anal Ja'tiox y re xan ja'tiox re Kakaj Jesús li nimi ja' Jordán. ");
INSERT INTO uspNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Cuando tijin tielch Kakaj Jesús ralaj ja', xril xtormaj caj y kesalch Lok'laj Jsantil Kakaj Dios chib' chapca' rilic jun ra ut. ");
INSERT INTO uspNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Xtasaj jun ch'a'wem xaanch lecj, xijch: Ati' ri lok'laj Inc'ajol, sub'laj inqui'cot chawij, xche'ch. ");
INSERT INTO uspNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Ajruc're' xpe Lok'laj Jsantil Kakaj Dios, xc'amb'i Kakaj Jesús li jun luwar lamas ta' cristian. ");
INSERT INTO uspNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Kakaj Jesús xwa'x ca'winak (40) k'ij cla' ric'an. Xwa'x xo'lak awaj re lak che'. Xpe man jb'ab'al etzl, xtakchi'j Kakaj Jesús chi macunc. Pero xpetak yak anjl xyuktak chi jt'o'ic Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Cuando wi'chak Juan Ajb'anal Ja'tiox li cars, Kakaj Jesús xe' Galilea chi jb'ij re juntir cristian tzilaj jtaquil chirij jtakon Kakaj Dios. ");
INSERT INTO uspNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Y xij rechak: Xtawi' k'ij, raquitzchak raj tijchol takon Kakaj Dios chib'ak cristian. Q'uex ano'jak chiwch Kakaj Dios y cojtak riq'ui nojel awanmak tzilaj jtaquil chwij, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Cuando Kakaj Jesús tijin tiwo'cot chi' nimlaj alagun re Galilea, xril jwichak Simón pach Andrés ri jk'un. Rechak ajchapaltak cartaka'n, tijin tijt'oj jc'aatak li ja' re chapb'i car. ");
INSERT INTO uspNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Kakaj Jesús xij rechak: Jo'tak chwij y in atincoja'taka' chi jtoquic cristian pire tioctak laj jk'ab' Kakaj Dios chapca' jchapic car tab'antak, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Rechak laj or xcan jye' jc'aatak re chapb'i car y xe'tak chirij Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Ajruc're' Kakaj Jesús xb'en chicb'i junquitz y xril chicb'i jwichak yak jc'ajol Zebedeo, ri'taka' Santiago pach Juan ri jk'un, rechak wi'tak li jun barc tijin tijc'ojaj jc'aatak re chapb'i car. ");
INSERT INTO uspNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Xpe Kakaj Jesús, xsiq'uijtakb'ic. Y rechak xcan jye'tak jkajak li barc pach yak jmocomak y xe'tak chirij Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Xtawtak Capernaúm. La' k'ij re uxlan Kakaj Jesús xoc li sinagog y xoc chi jtijojcak cristian. ");
INSERT INTO uspNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Cristian xsaach jch'olak chi jtaic, jwi'l wi' mas jno'j chi tijonc. Ma' ji'ta'lon chapca' titijontak yak ajtijoltak cristian re Jpixb' Kakaj Dios. ");
INSERT INTO uspNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Y li sinagog xtaw jun winak chijxo'lak ri wi' etzl laj ranm. Xpe man etzl, cow xch'ejejc, xij: ");
INSERT INTO uspNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","¡Nen ma b'an chike at Kaj Jesús aj Nazaret! Wetami' chi at tosolcati' jwi'l Kakaj Dios pire re y chi jb'aniqui' c'ax chike xatpetc, xche'. ");
INSERT INTO uspNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Kakaj Jesús xk'el man etzl ri wi' laj ranm man winak, xij re: ¡Tz'apij xa'w! ¡Elamb'i laj ranm winak ri! xche' re. ");
INSERT INTO uspNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Man etzl xye' jun quiek'ek' re man winak y cow xch'ejej cuando xelb'i laj ranm. ");
INSERT INTO uspNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Juntir cristian xsaach jch'olak. Xtz'onajtak chirib'il rib'ak: ¿Nen chiqui' ri? ¿Nen chiqui' jcholajl man aac' c'utu'n ri? Winak ri wi' k'atb'itzij laj jk'ab' pire titakon chib'ak mak etzl y ticojontaka' chiwch, xche'tak. ");
INSERT INTO uspNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Laj or xtaw jtaquil juntir ri xan Kakaj Jesús lak juntir luwar re Galilea. ");
INSERT INTO uspNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Cuando Kakaj Jesús pach Santiago y Juan xeltakb'i li sinagog, xe'tak laj richochak Simón Pedro y Andrés. ");
INSERT INTO uspNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Y sic' anm ri jji' Simón Pedro kesal laj jsoc jwi'l k'ak' chirij. Xijtak re Kakaj Jesús chi anm yaji'n. ");
INSERT INTO uspNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Xpe Kakaj Jesús, xjutun chijc'ulel jch'at sic' anm y xchap chi jk'ab' y xb'it. Laj or xel man k'ak' chirij y xoc chi jtzukicak juntir ri wi'tak la ja. ");
INSERT INTO uspNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Cuando xoc may, xpetak cristian aj Capernaúm, xc'amtakch riq'ui Kakaj Jesús juntir cristian ri wi' yajel rechak pach ri wi' etzl laj ranmak. ");
INSERT INTO uspNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Juntir cristian ri wi'tak li tilmit xmulb'a' rib'ak chuchja. ");
INSERT INTO uspNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Kakaj Jesús xtzib'saj sub'laj q'ui rechak re jaljojtak yajel ri wi' rechak y xresaj mak etzl ri wi' laj ranmak. Y Kakaj Jesús ta' xye' luwar rechak mak etzl tich'a'wtak jwi'l rechak retamaki' lamas xpe'w. ");
INSERT INTO uspNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Sub'laj ak'ab', aj uku'mna Kakaj Jesús xelb'i Capernaúm. Xe' li jun luwar ric'an lamas ta' cristian pire tich'a'w riq'ui Kakaj Dios. ");
INSERT INTO uspNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simón Pedro y mak jpach xe'tak chi jtoquic. ");
INSERT INTO uspNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Cuando xe' jte'tak Kakaj Jesús, xijtak re: Juntir cristian tijintak chi atoquic, xche'tak re. ");
INSERT INTO uspNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Xpe Kakaj Jesús, xij rechak: Jo'tak la' mak tra luwar chic chi nakaj. Inna b'ena chi jtijojcak cristian cla', jwi'l ri' li quiek jwi'l petzalquin, xche'. ");
INSERT INTO uspNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Jilonli Kakaj Jesús xwo'cot lak juntir luwar re Galilea chi jtijojcak cristian lak sinagog y xresaj mak etzl ri wi' laj ranmak cristian. ");
INSERT INTO uspNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Xpe jun sic' winak ri wi' yajel chirij ri jb'ij lepra, xjutun chiwch Kakaj Jesús, xxucar chi jtz'onaj tok'ob' re: Wi jilon chawaj, atcwini' chi intzib'saj, xche' re. ");
INSERT INTO uspNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Kakaj Jesús xril c'ur jwich, xye' jk'ab' chib', xij re: Chwaji'n, cattzib'ok, xche' re. ");
INSERT INTO uspNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Y laj or xel man yajel chirij sic' winak y xtzib'c. ");
INSERT INTO uspNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Ajruc're' Kakaj Jesús xij re: ");
INSERT INTO uspNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Ta impuch, ma yolow re jono cristian nen xattzib'sanc. Jat c'utta chiwch man ajc'amal jb'eak cristian riq'ui Kakaj Dios y c'amb'i man sipan pire tib'e asuje' re Kakaj Dios chapca' tijb'ij Jpixb' Kakaj Dios, ri' li c'utb'ire chiwchak juntir cristian chi xattzib'i'n, xche' Kakaj Jesús re. ");
INSERT INTO uspNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Man winak xec', pero ta' xcoj ri xijsaj re jwi'l Kakaj Jesús, xoc chi jyolic rechak juntir cristian ri nen xansaj re pire xtzib'c. Jwi'li'li Kakaj Jesús ta' chiqui' tijna' tioc xo'lak cristian, ni li jono tilmit. Ji'chak tiwo'cot chinaj lamas ri mita' cristian, pero tiyuktaka' cristian re jaljojtak luwar riq'uil. ");
INSERT INTO uspNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","K'asalchak quib' uxib' k'ij, cuando xtaw chic Kakaj Jesús Capernaúm, xtasaj jtaquil jwi'lak cristian chi wi'chak chic la ja. ");
INSERT INTO uspNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Xmol rib'ak sub'laj cristian, ta' chiqui' titz'akattak chi' pwert. Cuando Kakaj Jesús tijin tijb'ij Jyolj Kakaj Dios rechak, ");
INSERT INTO uspNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","xtawtak quejab' winak c'amalb'i jun winak jwi'lak b'a ch'atum che' ri siquirnak juntir jtio'jl. ");
INSERT INTO uspNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Pero ta' tijna' tioctak riq'ui Kakaj Jesús jwi'l sub'laj cristian wi'tak chi' pwert, rechak xjawtak chib' man ja. Xtortak junquitz mak xoot b'a ja laj jsuc'lal lamas wi' Kakaj Jesús y cla' xkesajtak sic' yaj b'a jch'atum che'. ");
INSERT INTO uspNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Cuando Kakaj Jesús xril chi cub'uli' jch'olak chirij, xij re sic' winak ri yaj: At walc'wal, amac xcuymaji'n, xche' re. ");
INSERT INTO uspNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Xpetak nic'j ajtijoltak cristian re Jpixb' Kakaj Dios ri cub'ultak cla', xchomorsajtak laj ranmak, xijtak: ");
INSERT INTO uspNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","¿Nen chac tijb'ij man winak ri jilonli? Re tijin tijcoj rib' pi Kakaj Dios. Ta' ni jun cristian ticwin chi jcuyic mac, xike Kakaj Dios, xche'tak. ");
INSERT INTO uspNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Pero Kakaj Jesús xretemaji' laj ranm nen tijin tijchomorsaj laj ranmak y xtz'onaj rechak: ¿Nen chac tijin tachomorsajtak laj awanmak jilonli? ");
INSERT INTO uspNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","¿Lac'umas wi' ri mas c'ax jb'ij re sic' yaj, amac xcuymaji'n o ri' mas c'ax jb'ij, b'iiten, c'amb'i ach'atum che' y wo'coten? ");
INSERT INTO uspNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Pero in tanc'ut chawchak chi Jc'ajol Kakaj Dios ri xwux pi cristianil wi' k'atb'itzij laj jk'ab' chi jcuyic mac neri wich ulew, xche' rechak. Ajruc're' xij chic re sic' winak ri siquirnak jtio'jl. ");
INSERT INTO uspNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Tamb'ij chawe at, b'iiten, c'amb'i ach'atum che' y jat laj awichoch, xche' re. ");
INSERT INTO uspNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Sic' winak ri yaj xb'iitc, xc'amb'i jch'atum che' y xelb'i chiwchak juntir cristian. Juntir cristian cuando xriltak jilonli, sub'laj xsaach jch'olak y xoctak chi jnimirsaj jk'ij Kakaj Dios, xijtak: ¡Ni jun b'welt ilan jun kelen kawi'l jilonri! xche'tak. ");
INSERT INTO uspNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Kakaj Jesús xe' chic chi' nimlaj alagun y sub'laj cristian xtawtak riq'uil. Re xtijojtak re Jyolj Kakaj Dios. ");
INSERT INTO uspNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","K'axem xan Kakaj Jesús cuando xrilb'i Leví ri jc'ajol Alfeo, cub'ul chi' mex lamas titojsaj alcabar y Kakaj Jesús xij re: Jo' chwij, xche' re. Leví xwa'rc y xe' chirij Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Cuando Kakaj Jesús tijin chi wic' laj richoch Leví, sub'laj q'ui ajtz'onaltak alcabar y sub'laj q'ui ajmacb' xcub'artak chi wic' riq'ui Kakaj Jesús pach yak ajtijol rib'ak chirij y sub'laj q'ui rib'ilak. ");
INSERT INTO uspNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Cuando yak ajtijoltak cristian re Jpixb' Kakaj Dios ri ri'taka' jun chijxo'lak mak fariseo xriltak chi Kakaj Jesús tijin tiwi'n chijxo'lak mak ajmacb' pach mak ajtz'onaltak alcabar, xsaach jch'olak y xtz'onajtak rechak yak ajtijol rib'ak chirij Kakaj Jesucristo: ¿Nen chac ajtijol awechak tijin tiwi'n chijxo'lak mak ajtz'onaltak alcabar pach mak ajmacb'? xche'tak. ");
INSERT INTO uspNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Cuando xta Kakaj Jesús chi jilonli xijsaj rechak yak ajtijol rib'ak chirij, xij rechak yak ajtijoltak cristian re Jpixb' Kakaj Dios ri ri'taka' jun chijxo'lak mak fariseo: Ta' rajwax ajcun rechak yak cristian ri ta' yajtak, ri' rajwax ajcun pi rechak yak ri yajtak. In ta' ximpe chi jtoquic yak cristian ri suc'ul ranmak chiwch Kakaj Dios, in ri' ximpe chi jtoquic yak ajmacb', xche' Kakaj Jesús rechak. ");
INSERT INTO uspNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Jun k'ij cuando yak ajtijol rib'ak chirij Juan Ajb'anal Ja'tiox pach mak ajtijol rib'ak chirijak mak fariseo tijin trantak ayun, xpetak nic'j cristian riq'ui Kakaj Jesús xtz'onajtak re: ¿Nen chac yak ajtijol rib'ak chirij Juan Ajb'anal Ja'tiox pach mak ajtijol rib'ak chirijak mak fariseo trana'taka' ayun y yak ajtijol rib'ak chawij at ta' trantak ayun? xche'tak re Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Kakaj Jesús xij rechak: Yak cristian ri b'il rechak chi tib'etak li jun tz'am, ta' tijna' tib'isontak cuando ajwi' man c'ojol winak chijxo'lak ri tic'uli'yc. ");
INSERT INTO uspNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Pero cuando titaw k'ij tic'amsajb'i man c'ojol winak chiwchak, ajruc're' trantak ayun. ");
INSERT INTO uspNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Ta' ni jono cristian tijc'ojaj jun tzay itz'ik la' jun q'uer aac' c'ojb'l, jwi'l man aac' c'ojb'l, tijc'ola' rib' y tike niman mas man rech'e'l re man tzay itz'ik. ");
INSERT INTO uspNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Ni ta' tijna' tiye'saj aac' vin lak tzaytak nejb' ri b'anal la' tz'um, jwi'l man aac' vin tijrech'a' mak tzaytak nejb' ri b'anal la' tz'um, jilonli titixi' man aac' vin y trana' c'ax mak nejb'. Jwi'li'li man aac' vin rajwaxi' lak aac'tak nejb' ri b'anal la' tz'um tiye'saj, xche' Kakaj Jesús rechak. ");
INSERT INTO uspNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Li jun k'ij re uxlan wo'cotic tran Kakaj Jesús xk'axtak lak tico'n pach yak ajtijol rib'ak chirij. Rechak pi k'axem trantak xtoctak jujun jwich trig y xtijtak. ");
INSERT INTO uspNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Xpetak mak fariseo, xijtak re Kakaj Jesús: ¡Il impuch! ¿Nen chac yak ajtijol rib'ak chawij tijin trantak ri ta' ye'l luwar tib'ansaj la' k'ij re uxlan? xche'tak re Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Kakaj Jesús xtz'onaj rechak: ¿Ta'c'u ilan awi'lak li wuj re Lok'laj Jyolj Kakaj Dios ri xan David ojr pach yak jpach cuando xc'oktak wi'jal? ");
INSERT INTO uspNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Re xoc li nimlaj chinam ri richoch Kakaj Dios cuando Abiatar wi' pi nimlaj jb'ab'alak yak ajc'amaltak jb'eak cristian riq'ui Kakaj Dios, xtij mak cuxlanwa ri sujul re Kakaj Dios y xye' chi tijem rechak yak jpach onque ta' ye'l luwar jwi'l Jpixb' Kakaj Dios chi titijsaj, xike rechak yak ajc'amaltak jb'eak cristian riq'ui Kakaj Dios ye'l luwar rechak tijtijtak. ");
INSERT INTO uspNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Man k'ij re uxlan xansaj pirechi' cristian y ma' cristian ta' xansaj pire man k'ij re uxlan. ");
INSERT INTO uspNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Jwi'li'li Jc'ajol Kakaj Dios ri xwux pi cristianil wi' laj jk'ab' nen raj tran la' man k'ij re uxlan, xche' Kakaj Jesús rechak. ");
INSERT INTO uspNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Kakaj Jesús xoc chic li sinagog. Cla' wi' jun winak ri siquirnak jun jk'ab'. ");
INSERT INTO uspNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Jujun rechak mak fariseo cow triltak Kakaj Jesús wi tijtzib'saji' man winak li la' k'ij re uxlan pire tijcojtak tzij chirij. ");
INSERT INTO uspNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Ajruc're' Kakaj Jesús xij re man winak ri siquirnak jun jk'ab': B'iiten, wa'ren laj kaxo'l, xche' re. ");
INSERT INTO uspNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Kakaj Jesús xtz'onaj rechak: ¿Nen ye'l luwar ri tib'ansaj la' k'ij re uxlan, jb'anic utzil o jb'anic c'ax? ¿Tzini' jcolic jun cristian laj jk'ab' camic o jsachic jwich? xche' rechak. Pero rechak ta' xch'a'wtak. ");
INSERT INTO uspNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Kakaj Jesús xpe retzal chi rilicak yak ri sutuwinaktak rij y xc'axc'ob' laj ranm jwi'l ta' rajak tijtatak jcholajl. Kakaj Jesús xij re sic' winak ri siquirnak jk'ab': Yuk ak'b', xche' re. Y sic' winak li xyuk jk'ab' y xtzib'c. ");
INSERT INTO uspNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Mak fariseo xike xeltakb'ic, xoctak chi jchomorsaj riq'uilak man k'at ri jpach Herodes nen trantak chi jcamsaj Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Kakaj Jesús pach yak ajtijol rib'ak chirij xe'tak chi' nimlaj alagun y sub'laj cristian aj Galilea xamb'ertak chirij. ");
INSERT INTO uspNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Y cuando xtatak jtaquil chirij juntir ri b'anal jwi'l Kakaj Jesús, sub'laj cristian xpetak chi rilic, wi' xpetak lak luwar re Judea, Jerusalén, Idumea, ch'akap nimi ja' Jordán y lak luwar re Tiro pach Sidón. ");
INSERT INTO uspNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Kakaj Jesús xril chi sub'laj cristian tijin tijmulb'a' rib'ak chirij. Xchomorsaj chi mas tilatz'ujc, jwi'li'li xij rechak yak ajtijol rib'ak chirij chi tijtoctak jun barc pire lamas tiwa'xwi'. ");
INSERT INTO uspNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Xtasaj jtaquil chi sub'laj cristian xtzib'saj jwi'l Kakaj Jesús, jwi'li'li xpetak mas cristian ri yajtak y tichak jtuc' rib'ak chi jchapic Kakaj Jesús jwi'l ri' rajak titzib'sajtak re jyajak. ");
INSERT INTO uspNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Y mak cristian ri wi' etzl laj ranmak cuando xriltak jwich Kakaj Jesús xxucaj rib'ak chiwch Kakaj Jesús y mak etzl ri wi' laj ranmak, xch'ejejtak chi jb'ijc: ¡Ati' Jc'ajol Kakaj Dios! xche'tak re. ");
INSERT INTO uspNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Kakaj Jesús xij rechak mak etzl chi mi jb'ijtak chi re Jc'ajoli' Kakaj Dios. ");
INSERT INTO uspNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Ajruc're' Kakaj Jesús xjaw b'a jun witz y xsiq'uij yak ajtijol rib'ak chirij ri raj xsiq'uij. ");
INSERT INTO uspNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Y jilonli xcha' cab'lajuj (12) winak y xcoj jb'ijak pi tako'n pire tiwa'xtak riq'uil y pire tijtakb'i chi jb'ij Jyolj Kakaj Dios. Jilonli xcan jb'ijak pi tako'n. ");
INSERT INTO uspNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Y xye' cwinel rechak chi resaj mak etzl ri wi' laj ranmak cristian. ");
INSERT INTO uspNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Ri'taka' ri yak cab'lajuj (12) ri xcha', Simón ri xcojsaj jb'ij pi Pedro jwi'l Kakaj Jesús, ");
INSERT INTO uspNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Santiago pach jk'un ri jb'ij Juan ri yak jc'ajol Zebedeo ri xcojsaj jb'ijak jwi'l Kakaj Jesús pi Boanerges, ri jcholajl tielwi' man b'ij Boanerges, ralc'wal quiekuljaw, ");
INSERT INTO uspNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andrés, Felipe, Bartolomé, Mateo, Tomás, Santiago ri jc'ajol Alfeo, Tadeo, Simón ri tib'ijsaj Zelote re ");
INSERT INTO uspNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","y Judas Iscariote ri xjachow re Kakaj Jesús pi camic. ");
INSERT INTO uspNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Kakaj Jesús xoc li jun ja. Xmulb'a' chic rib'ak sub'laj q'ui cristian la ja cla' y jwi'li'li Kakaj Jesús ta' chiqui' tijna' tijtij jwaak pach yak ajtijol rib'ak chirij. ");
INSERT INTO uspNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Cuando jchuch pach jk'un xtatak jtaquil chi wi'chak li jun ja cla', xe'tak chi jc'amic jwi'l tib'ijsaj chirij chi xta' jch'u'jarc. ");
INSERT INTO uspNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Y nic'j ajtijoltak cristian re Jpixb' Kakaj Dios ri xpetak Jerusalén, xijtak: Man winak li wi' Beelzebú laj ranm y la'ke jcwinel Beelzebú li, ri man jb'ab'alak mak etzl ticwin chi resaj mak etzl ri wi' laj ranmak cristian, xche'tak. ");
INSERT INTO uspNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Ajruc're' Kakaj Jesús xsiq'uij mak cristian y xij jun esb'i no'j rechak jilonri: Man jb'ab'al etzl ta' ticwin chi resaj man jb'ab'al etzl. ");
INSERT INTO uspNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Juntir k'atb'itzij, wi tijjach rib'ak y tioctak chi ch'o'j chirib'il rib'ak, tijsacha' jwichak. ");
INSERT INTO uspNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Y jun tilmit o yak ech'elxic li jun ja, wi tijtos rib'ak y tioctak chi ch'o'j chirib'il rib'ak ta' naj tijcuytak jilonli. ");
INSERT INTO uspNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Y ji'c'ulonli witi man jb'ab'al etzl tijin chi resaj man jb'ab'al etzl, tijini' tran c'ax rib' ric'an. Wi jilonli tran man jb'ab'al etzl, tisaachi' jwich ric'an. ");
INSERT INTO uspNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Jun cristian ri wi' mas jchok'b' ta' ni jonok ticwin tioc laj richoch chi resaj kelen re. Nab'e tina jximna, ajruc're' tijna' tresaj kelen re, xche' Kakaj Jesús rechak. ");
INSERT INTO uspNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Y xij chic: Kes tz'etel tz'et tamb'ij chawechak chi Kakaj Dios tijcuya' jmacak juntir cristian y juntir mak yok'on ri trantak chirij Jc'ajol Kakaj Dios ri xwux pi cristianil. ");
INSERT INTO uspNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Pero nen jonok tiyok'on chirij Lok'laj Jsantil Kakaj Dios ta' ni jun b'welt ticuysaj jmac jwi'l Kakaj Dios, xche' Kakaj Jesús rechak. ");
INSERT INTO uspNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Jilonli xij Kakaj Jesús jwi'l yak ajtijoltak cristian re Jpixb' Kakaj Dios tijin tijb'ijtak chi re wi' etzl laj ranm. ");
INSERT INTO uspNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Jchuch Kakaj Jesús pach yak jk'un xtawtak chi jch'ab'ej. Ji'ke xcantak chuchja y xtaktak jsiq'uij Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Sub'laj cristian cub'ultak chirij Kakaj Jesús, rechak xijtak re: Achuch pach yak ak'un wi'tak chuchja y rajak atjch'ab'ejtak, xche'tak re Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Pero Kakaj Jesús xij rechak: ¿Nenc'u inchuch y nenc'u ink'un? xche'. ");
INSERT INTO uspNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Y xril mak cristian ri cub'ultak chirij y xij: Ri'taka' rechak ri inchuch pach ink'un. ");
INSERT INTO uspNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Nen raj tran lawi' raj Kakaj Dios tran, ri' li ink'un, wanab' y inchuch, xche' Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Li jun k'ij chic xoc Kakaj Jesús chi jtijoj cristian re Jyolj Kakaj Dios chi' nimlaj alagun. Sub'laj cristian xmulb'a' rib'ak lamas wi' Kakaj Jesús. Jwi'li'li Kakaj Jesús xjaw li jun barc ri wi' chi' nimlaj alagun. Xcub'ar cla' y juntir cristian xcantak chi' nimlaj alagun chi jtaic nen tijb'ij rechak. ");
INSERT INTO uspNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Ajruc're' Kakaj Jesús xoc chi jtijojcak re sub'laj kelen la' esb'itak no'j, xij rechak: ");
INSERT INTO uspNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","Tatak impuch. Wi' jun ajticonl xe' ticonanok. ");
INSERT INTO uspNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Cuando tijin chi ticonanc, nic'j íjaj xkejtak li b'e y xpetak mak tz'iquin xtijtak. ");
INSERT INTO uspNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Nic'j íjaj chic xkejtak xo'lak ab'aj lamas ta' pim ulew. Mak íjaj li, laj or xeltakch jwi'l ta' mas naj jpam man ulew lamas xkejtakwi'. ");
INSERT INTO uspNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Pero jwi'l ta' lamas xe' ra'ak cuando xel sak'j, xchekejtak y xcamtak. ");
INSERT INTO uspNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Y nic'j íjaj chic xkejtak lak q'uix, xeltaka'ch, pero mak q'uix xq'uiytak laj or chiwchak, jwi'li'li xcam mak tico'n ralaj mak q'uix y ta' xwichintak. ");
INSERT INTO uspNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Nic'j íjaj chic xkejtak li tzilaj ulew. Mak íjaj li jor kus xwichintak. Wi' jujun íjaj xya'taka' junwinak lajuj (30) jwichak. Nic'j chic xya'taka' oxc'al (60) jwichak y nic'j chic xya'taka' jujun cient (100) jwichak. ");
INSERT INTO uspNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Nen titonc, jte' jcholajl ri tamb'ij, xche' Kakaj Jesús rechak cristian. ");
INSERT INTO uspNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Cuando xe'tak jq'uiyal cristian, Kakaj Jesús xcan xichak jpach yak cab'lajuj (12) ajtijol rib'ak chirij pach nic'j ri xamtak chirij xtz'onajtak re: ¿Nen jcholajl tieltakwi' mak esb'itak no'j ri xab'ij rechak mak cristian? xche'tak re Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Kakaj Jesús xij rechak: Atak, Kakaj Dios xya' retemaj chawechak jcholajl jtakon ri ta' etemal. Pero pi rechak mak nic'j cristian ri ta' tijcojtak Jyolj Kakaj Dios rajwaxna tamb'ij la' esb'itak no'j rechak, ");
INSERT INTO uspNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","jwi'l onque tina'tuntaka'n, pero ta' tijmajtak jcholajl nen tijin triltak. Tijta'taka' nen tib'ijsaj rechak, pero ta' tijtatak jcholajl nen tijin tijtatak pire ma' tijq'uex jno'jak y ma' tik'ajtak chic laj jk'ab' Kakaj Dios pire ma' ticuysaj jmacak, xche' Kakaj Jesús rechak. ");
INSERT INTO uspNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Kakaj Jesús xij chic rechak yak ajtijol rib'ak chirij: Atak wi mita' tatatak jcholajl nen tielwi' man esb'i no'j ri, ta' tatatak jcholajl mak nic'j esb'itak no'j chic. ");
INSERT INTO uspNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Ri titiquiw mak íjaj, ri' jun cristian ri tib'in Jyolj Kakaj Dios rechak cristian. ");
INSERT INTO uspNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Wi' jujun jilontak chapca' man b'e ri lamas xkejtakwi' mak íjaj. Tijc'ula'taka' Jyolj Kakaj Dios laj ranmak, pero tipe man jb'ab'al etzl tresaj chic Jyolj Kakaj Dios ri xc'ultak laj ranmak. ");
INSERT INTO uspNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Wi' jujun cristian chic jilontak chapca' man ulew lak ab'aj lamas xkejtakwi' mak íjaj. Rechak tijta'taka' Jyolj Kakaj Dios y tijc'ula'taka' pi qui'cotemal laj ranmak. ");
INSERT INTO uspNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Pero nic' riq'uil ta' tib'e ra' laj ranmak jwi'l ta' tijcub'a' mas jch'olak chirij. Quib' uxib' k'ijke tijcojtak, pero cuando titakchi'jtak chi macunc y cuando tib'ansaj c'ax rechak jwi'l tijcojtak Jyolj Kakaj Dios laj or tijquib'aj ranmak. ");
INSERT INTO uspNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Wi' jujun cristian chic jilontak chapca' man luwar lak q'uix ri lamas xkejtakwi' mak íjaj, rechak tijta'taka' Jyolj Kakaj Dios, ");
INSERT INTO uspNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","pero ri' mas tib'e ranmak chirijak mak kelen re wich ulew y tisub'sajtak jwi'l jb'iomilak y tijrayajtak tiwa'x sub'laj kelen rechak. Ri' li tik'atow jwich Jyolj Kakaj Dios pire ta' tiwichin laj ranmak. ");
INSERT INTO uspNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Wi' jujun cristian chic jilontak chapca' man kuslaj ulew lamas xkejtakwi' mak íjaj. Rechak tz'etel tz'et tijcoja'taka' Jyolj Kakaj Dios y tiwa'xi' laj ranmak chapca' kus tiwichin laj ranmak. Jilon chapca' jujun íjaj tijya'taka' chapca' junwinak lajuj (30) jwichak. Jujun chic tijya'taka' chapca' oxc'al (60) jwichak. Nic'j chic tijya'taka' chapca' jujun cient (100) jwichak, xche' Kakaj Jesús rechak. ");
INSERT INTO uspNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Kakaj Jesús xij rechak: Ta' ni jono cristian tijtzij jun candil pire tijye' ralaj jun cax o pire tijye' ralaj jun ch'at. Jun cristian tijtzij jun candil pirechi' tijcocb'a' lecj pire tijsakab'saj la ja. ");
INSERT INTO uspNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Ta' ni jono kelen ri tib'ansaj chi mukukil miti tina elna chi sakil. ");
INSERT INTO uspNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Nen titonc, jte' jcholajl ri tamb'ij, xche' rechak yak ajtijol rib'ak chirij. ");
INSERT INTO uspNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Y xij chic rechak: Atak, cojtak retal nen tijin tatatak. La' man pajb'l ri tacojtak rechak cristian, ri' ticojsaj chawechak jwi'l Kakaj Dios y tijya' chiqui' mas pi awechak. ");
INSERT INTO uspNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Nen wi' mas riq'uil, tiye'saj chiqui' mas re y nen ta' re, asta raquitz ri wi' riq'uil, timajsaji' re, xche' Kakaj Jesús rechak. ");
INSERT INTO uspNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Kakaj Jesús xij chic jun esb'i no'j rechak jilonri: Jtakon Kakaj Dios chib'ak cristian jilon chapca' jun winak ri titiconanc ");
INSERT INTO uspNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","y man winak li onque tiwar o tib'iitc, chi lak'j chi lak'ab' mak tra íjaj tijin tiel rac'al ric'anak. Y re ta' retam nen quiek jwi'l tijin tiq'uiy jtico'n. ");
INSERT INTO uspNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Tiq'uiy tico'n jwi'li' jchok'b' ulew. Nab'e tiwa'x jpatz'anl, ajruc're' tiwa'x roch'al y tiwa'x tra b'ak' jwich. Cuando ticowin b'ak' jwich, ");
INSERT INTO uspNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","tichekejc y man winak tib'e chi roch'ic jwi'l xtawi' jk'ijl re tioch'sajc, xche' Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Kakaj Jesús xij chic jun esb'i no'j rechak jilonri: ¿Nen quiek la' tiniq'uib'sajwi' jtakon Kakaj Dios chib'ak cristian? ¿Nen quiek la' tikaniq'uib'sajwi' pire esb'i no'j? ");
INSERT INTO uspNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Jtakon Kakaj Dios chib'ak cristian jilon chapca' jun ra íjaj re mostas. Cuando titicsaj lak ulew, ri' mas ra nuch' chijxo'lak juntir íjaj. ");
INSERT INTO uspNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Pero cuando tiquilchak mas tiq'uiyc y mas nim titaw chiwch juntir ichj y mak jk'ab' mas nimak titaw asta tz'iquin tijna' tran jsocak lak jk'ab' laj mujal mak xak, xche' Kakaj Jesús rechak. ");
INSERT INTO uspNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","La' esb'itak no'j xtijojwi' cristian Kakaj Jesús re Jyolj Kakaj Dios pire tijtatak jcholajl. ");
INSERT INTO uspNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Ta' ni jono yoloj xij rechak miti xijna esb'itak no'j. Pero cuando ric'anakchak pach yak ajtijol rib'ak chirij, ajruc're' xij jcholajl mak esb'itak no'j rechak. ");
INSERT INTO uspNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","La' man k'ij li cuando xoc ak'ab', Kakaj Jesús xij re yak ajtijol rib'ak chirij: Jo'tak ch'akap re nimlaj alagun, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Ajruc're' xcan jye'tak mak cristian y xjawtak li barc lamas wi' Kakaj Jesús y xc'amtakb'i Kakaj Jesús. Y xe' chic nic'j barc chirijak. ");
INSERT INTO uspNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Xpe jun quiek'ek' tew b'a ja'. Xritz'b'ej man ja' y mak retumb re man ja' xjawtak li barc. Man barc tichak tijin jnojic chi ja'. ");
INSERT INTO uspNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Kakaj Jesús tijin chi waraj chib' jun q'uisb'i tem li barc y ye'l jb'a chib' jun ch'iquet jwi'l. Yak ajtijol rib'ak chirij xb'ittak y xch'ejejtak, xijtak re: ¡Kajtijonl! Kuske chawe wi xojjik' li ja', xche'tak re. ");
INSERT INTO uspNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Kakaj Jesús xb'iitc. Xk'el tew, xij re ja': ¡Jun wa'xenwi'! ¡Mat silib' chic! xche'. Ajruc're' xk'ax quiek'ek' tew y xmay juntir. ");
INSERT INTO uspNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Kakaj Jesús xij re yak ajtijol rib'ak chirij: ¿Nen chac mas titzaak ach'olak? ¿Nen chac ta' cub'ul ach'olak chwij? xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Rechak sub'laj tzakal jch'olak chi rilic, xoctak chi jtz'onaj chirib'il rib'ak: ¿Nen chiqui' jcholajl winak ri, chi ji' quiek'ek' tew pach mak retumb re nimlaj alagun ticojontaka' chiwch? xche'tak. ");
INSERT INTO uspNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Kakaj Jesús pach yak ajtijol rib'ak chirij xtawtak ch'akap re nimlaj alagun laj jluwrak yak aj Gadara. ");
INSERT INTO uspNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Cuando xelch Kakaj Jesús li barc, xpe jun winak ri wi' etzl laj ranm, relicch li camposant. ");
INSERT INTO uspNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Man winak li ji' jekel li camposant. Ta' ni jun cristian ticwin chi jximic ni la' caden. ");
INSERT INTO uspNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Q'uilaj b'welt xximtak chi rakan y chi jk'ab' la' caden, pero ticwini' chi jk'atzic. Ta' nen ticwin chirij jwi'l wi' mas jchok'b'. ");
INSERT INTO uspNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Man winak li tiwo'cot chi lak'j chi lak'ab' tich'ejej b'ak witz y li camposant y tran c'ax rib' la' ab'aj. ");
INSERT INTO uspNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Man winak li, cuando xrilch jwich Kakaj Jesús chinaj, tijolin xpetc, xyuk jxucb'a' rib' chiwch chi jcojic jk'ij. ");
INSERT INTO uspNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Man etzl ri wi' laj ranm man winak xch'ejejc, xtz'onaj re Kakaj Jesús: ¿Nen chawaj chwe Kaj Jesús, at Jc'ajol Kakaj Dios lecj? ¡Chiwch Kakaj Dios b'an tok'ob' chwe, min ach'u'jursaj! xche'. ");
INSERT INTO uspNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Man etzl xij jilonli jwi'l Kakaj Jesús xij re: ¡At etzl, elamb'i laj ranm winak ri! xche'. ");
INSERT INTO uspNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Kakaj Jesús xtz'onaj re man etzl: ¿Nen ab'j? xche' re. Man etzl xij: Q'ui imb'j, jwi'l oji' sub'laj q'ui woj laj ranm winak, xche'. ");
INSERT INTO uspNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ajruc're' mak etzl li xtz'onajtak tok'ob' re Kakaj Jesús chi ta' titaksajtakb'i chinaj re man luwar li. ");
INSERT INTO uspNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Cla' wi' sub'laj aak tijin jyuk'icak wich witz. ");
INSERT INTO uspNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Mak etzl xtz'onajtak tok'ob' re Kakaj Jesús: Cojatake'b'i riq'uilak mak aak. Ye' luwar chike ojoc laj jtio'jlak, xche'tak re Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Kakaj Jesús xya' luwar rechak. Xeltakb'i mak etzl laj ranm man winak. Xe' octak laj jtio'jlak mak aak. Raj wi' quib' mil (2,000) chi aak y mak aak xch'u'jartak y xmajtak jol wich witz y xkejtakb'i pi xulan asta xe' tzaaktak li nimlaj alagun, cla' xjik'tak. ");
INSERT INTO uspNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Mak ajyuk'ultak aak xelmajtak, xe'tak li tilmit y lak luwar nakaj chi jyolic ri xaanc. Xpetak cristian chi rilic nen xan Kakaj Jesús chi resaj mak etzl laj ranm man winak. ");
INSERT INTO uspNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Cuando xtawtak lamas wi' Kakaj Jesús xriltak man winak ri xwa'x mak q'uitaklaj etzl laj ranm, cub'ulchak, cojolchak ritz'ik jwi'l y ta' chiqui' ch'u'j. Rechak xtzaak jch'olak chi rilic. ");
INSERT INTO uspNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Y mak cristian ri xiliwtak nen xan Kakaj Jesús re man winak ri xwa'x mak etzl laj ranm, xyoltak re mak cristian ri xtawtak cla' ri nen xan Kakaj Jesús re man winak ri xwa'x mak etzl laj ranm y ri nen xantak mak aak. ");
INSERT INTO uspNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Ajruc're' xoctak chi jtz'onaj sub'laj tok'ob' re Kakaj Jesús chi tielb'i laj jtilmitak. ");
INSERT INTO uspNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Cuando Kakaj Jesús tijin tijaw li barc, man winak ri xesaj mak etzl laj ranm xtz'onaj sub'laj tok'ob' re Kakaj Jesús chi tib'e chirij. ");
INSERT INTO uspNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Pero Kakaj Jesús ta' xye' luwar re man winak xe' chirij y xij re: Jat laj awichoch xo'lak awech'elxic y yolta rechak juntir ri nen xansaj chawe jwi'l Awajawl y nen mo xan chi rilic c'ur awch, xche' Kakaj Jesús re man winak. ");
INSERT INTO uspNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Ajruc're' man winak xec' y xoc chi jyolic rechak cristian re Decápolis juntir ri nen xan Kakaj Jesús re y juntir xsaach jch'olak chi jtaic jyolj. ");
INSERT INTO uspNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Cuando Kakaj Jesús xk'ax chicb'i li barc ch'akap re nimlaj alagun, xtaw sub'laj cristian riq'uil chi' nimlaj alagun lamas xtawi'. ");
INSERT INTO uspNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Ajruc're' xtaw jun winak ri jb'ij Jairo ri jun rechak mak jb'ab'alak man k'at ri tijmulb'a' rib'ak li sinagog. Cuando xril jwich Kakaj Jesús xxucb'a' rib' chiwch. ");
INSERT INTO uspNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Y xtz'onaj sub'laj tok'ob' re, xij: Inrab'in camic tran. B'an tok'ob', ye'ta ak'b' chib' pire titzib', xche' re. ");
INSERT INTO uspNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Ajruc're' Kakaj Jesús xe' riq'uil y sub'laj cristian xe'tak chirijak tichak jpitz' rib'ak chirij Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Y xo'lak cristian wi' jun anm yaj ri wi'chak cab'lajuj (12) junab' chi ticar chi coc'xo'lke tikej man ch'ojnic chirij. ");
INSERT INTO uspNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Mas c'ax tijil jwi'l. Poc q'ui ajcun quiek riq'uil xsachwi' juntir jpwaak ri wi', pero ta' ni jun xcwin chi jcunajc. Masne' xnima'tan jyaj. ");
INSERT INTO uspNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Cuando xta jtaquil chi Kakaj Jesús ticwini' chi tzib'sanc, man anm li xjutun chirij Kakaj Jesús xo'lak cristian y xchap raquitz ritz'ik Kakaj Jesús ");
INSERT INTO uspNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","jwi'l xchomorsaj laj ranm: Xike wi xincwin chi jchapic raquitz ritz'ik, intzib'i'n, xche'. ");
INSERT INTO uspNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Xike cuando xchap raquitz ritz'ik Kakaj Jesús, laj or xtanar man ch'ojnic chirij man anm y xric'aji' chi xtzib'i' re jyaj. ");
INSERT INTO uspNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Kakaj Jesús xric'aj chi xtzib'saji' jun cristian la' jcwinel, xsolcopij rib' y xtz'onaj: ¿Nen xchapow witz'ik? xche'. ");
INSERT INTO uspNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Yak ajtijol rib'ak chirij xtz'onajtak: ¿Nen chac tatz'onaj nen chi cristian lal xchapow awitz'ik? Juntir cristian atpitz'owc y atjtuc'tak, xche'tak re. ");
INSERT INTO uspNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Kakaj Jesús tijin tina'tun chirij chi rilic nen xchapow ritz'ik. ");
INSERT INTO uspNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Man anm tichak querquen jwi'l jtzakic jch'ol, jwi'l retami' chi ri' xchapow re ritz'ik Kakaj Jesús. Xxucb'a' rib' chiwch Kakaj Jesús y xij jcholajl re nen quiek jwi'l xchap ritz'ik. ");
INSERT INTO uspNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Kakaj Jesús xij re: At inrab'in, xattzib'i'n, jwi'l xcub'ar ach'ol chwij. Jat pi utzil, lajori ta' chiqui' at yaj, xche' re man anm. ");
INSERT INTO uspNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Aj tijini' Kakaj Jesús chi yoloj riq'ui man anm li cuando xtawtak nic'j winak jpeticak laj richoch Jairo ri jb'ab'alak man k'at ri tijmulb'a' rib'ak li sinagog y xijtak re: Xcami' arab'in. Ta' chiqui' nen tichacuj talatz'ab'saj jwich sic' ajtijonl, xche'tak mak winak re Jairo. ");
INSERT INTO uspNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Kakaj Jesús xan chapca' ta' tijta ri xijtak mak cristian re Jairo y xij re: Mi tzaak ach'ol, xike cub'a' ach'ol chwij, xche' re. ");
INSERT INTO uspNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Ta' xye' luwar xamb'er mas cristian chirij, xike Pedro, Santiago y Juan ri jk'un Santiago. ");
INSERT INTO uspNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Y cuando xtawtak laj richoch Jairo xtatak poc tich'ejejtak cristian chi ok'ej. ");
INSERT INTO uspNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Kakaj Jesús xoc la ja y xtz'onaj rechak: ¿Nen chac poc atch'ejejtak chi ok'ej? Man ra anm ta' camnak, warajke tran, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Mak cristian xtze'jtak jwich Kakaj Jesús cuando xtatak xij chi yo'li' man ra anm. Kakaj Jesús xij rechak cristian chi tieltak la ja, xike xcantak la ja jkaj jchuch man ra anm pach yak ri b'esaltak chirij. Xoctak lamas wi' man ra anm ri xcamc. ");
INSERT INTO uspNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Kakaj Jesús xchap chi jk'ab', xij re: ¡Talita cumi! xche' re. Ri jcholajl tielwi' mak yoloj talita cumi, noy, tamb'ij chawe, b'iiten. ");
INSERT INTO uspNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Man ra anm ri wi' cab'lajuj (12) junb', laj or xb'iitc y xoc chi wo'cotem. Juntir xsaach jch'olak chi rilic. ");
INSERT INTO uspNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Ajruc're' Kakaj Jesús xtz'onaj tok'ob' rechak chi mi jyoltak re cristian ri nen xriltak y xij rechak chi tijye'tak jwa man ra anm. ");
INSERT INTO uspNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Kakaj Jesús xelb'i cla' pach yak ajtijol rib'ak chirij, xe'tak laj jtilmit. ");
INSERT INTO uspNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Cuando xtaw k'ij re uxlan xoc chi jtijojcak mak cristian li sinagog. Sub'laj cristian xtatak jyolj Kakaj Jesús y xsaach jch'olak chi jtaic y xtz'onajtak chirib'il rib'ak: ¿La chiqui' mas xretemajwi' juntir ri, ri tijin tijb'ij? ¿Lac'umas xpe jno'j jilon tran li? ¿Nen chiqui' mo ticwin chi jb'anic mak c'utb'i jcwinel Kakaj Dios? ");
INSERT INTO uspNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Re ri' man ajc'ox, ri ric'lal María, ri ratzak Santiago, José, Judas, Simón y yak ranab' wi'taka' neri chikaxo'l, xche'tak. Jwi'li'li ta' rajak tijcojtak lawi' ri tijb'ij Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Kakaj Jesús xij rechak: Lak juntir luwar ticojsaji' jk'ij jun ajk'asal Jyolj Kakaj Dios, pero laj jtilmit ta' ticojsaj jk'ij, ni chijxo'lak yak rech'elxic, ni laj richoch, xche'. ");
INSERT INTO uspNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Kakaj Jesús ta' xna' xan mas c'utb'i jcwinel Kakaj Dios cla', xike xye' jk'ab' laj jb'aak quib' uxib' cristian ri yajtak y xtzib'tak. ");
INSERT INTO uspNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Kakaj Jesús xsaach jch'ol chi rilicak mak cristian jwi'l rechak ta' xcub'ar jch'olak chirij. Ajruc're' Kakaj Jesús xe' chi jtijojcak cristian lak luwar ri wi'tak chi nakaj re Nazaret. ");
INSERT INTO uspNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Kakaj Jesús xmulb'a' yak cab'lajuj (12) ajtijol rib'ak chirij y ajruc're' xchol jtakicak pi cacab' rib'ilak, xye' cwinel rechak chi resaj mak etzl ri wi' laj ranmak cristian. ");
INSERT INTO uspNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Xij rechak chi ta' nen tijc'amtakb'i pire laj jb'eak xike jujun jcarotak. Ta' tijc'amtakb'i jwaak, ni jchimak, ni jpwaakak. ");
INSERT INTO uspNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Xike tijc'amtakb'i jxajb'ak ri cojol jwi'lak y mi jc'amtakb'i jun túnica chic. ");
INSERT INTO uspNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Kakaj Jesús xij rechak: Cuando atoctak li jun tilmit y wi tata'tak aposadak li jun ja, wa'xentak cla' asta titaw k'ij ateltakb'i li man tilmit li. ");
INSERT INTO uspNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Y wi yak cristian li jono tilmit ta' atjc'ultak y ta' rajak tijtatak ayoljak, elantakb'i cla'. Can totojtak man pok la' awakanak pire c'utb'ire chiwchak chi ta' tzi xantak jwi'l ta' xatjc'ultak, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Ajruc're' yak ajtijol rib'ak chirij Kakaj Jesucristo xeltakb'i chi jtijoj cristian y xijtak rechak chi rajwaxi' tijq'uex jno'jak, ");
INSERT INTO uspNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","xresajtak sub'laj etzl ri wi' laj ranmak cristian y sub'laj cristian yajtak xcojtak aceit laj jb'aak y xtzib'sajtak. ");
INSERT INTO uspNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Man rey Herodes Antipas xta jtaquil nen tijin tran Kakaj Jesús jwi'l wi'chak jtaquil lak juntir tilmit. Jujun cristian xijtak: Ri' Juan Ajb'anal Ja'tiox ri xc'astasaj jwich laj jcamnakl xo'lak camnakib', jwi'li'li ticwin chi jb'anic c'utb'i jcwinel Kakaj Dios, xche'tak. ");
INSERT INTO uspNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Nic'j cristian chic xijtak: Ri' Elías, xche'tak. Nic'j chic xijtak: Ri' jun ajk'asal Jyolj Kakaj Dios ri nic' chapca' yak ajk'asaltak Jyolj Kakaj Dios ojrtaktzij, xche'tak. ");
INSERT INTO uspNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Cuando Herodes Antipas xta jtaquil ri tijin tran Kakaj Jesús, xij: Li ri' Juan Ajb'anal Ja'tiox ri xintak resaj jb'a. Lajori xc'astasaji' jwich laj jcamnakl, xche'. ");
INSERT INTO uspNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Jilonli xij Herodes Antipas jwi'l ri' re xtakow jchapic Juan Ajb'anal Ja'tiox y xtakow jximic la' caden li cars jwi'l Herodías ri xwa'x pi rixokl Herodes Felipe ri jk'un Herodes Antipas. Herodes Antipas xc'uli'y riq'ui man anm li. ");
INSERT INTO uspNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Jwi'li'li Juan Ajb'anal Ja'tiox xij re Herodes Antipas: Ta' tzi xab'an xatc'uli'y riq'ui rixokl ak'un, xche' re. ");
INSERT INTO uspNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Jwi'li'li Herodías xcontrij Juan Ajb'anal Ja'tiox. Jwi'l retzal raj roj xcamsaj, pero ta' xna'w. ");
INSERT INTO uspNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Jwi'l Herodes Antipas retami' chi tzilaj winaki' Juan Ajb'anal Ja'tiox y suc'uli' ranm chiwch Kakaj Dios, xtzaak jch'ol chi jcamsajc. Jilonli ta' xye' luwar xansaj c'ax re. Herodes Antipas ta' kes xta jcholajl nen xij Juan Ajb'anal Ja'tiox, pero nojeli' ranm xta jyolj. ");
INSERT INTO uspNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Pero xtawna jun k'ij chiwch Herodías xcamsaj Juan Ajb'anal Ja'tiox y ri' cuando Herodes xc'ul jk'ij. Xpe Herodes, xsiq'uij mak ri wi' rekle'nak pi jpach, mak jb'ab'alak mak soldad y mak winak ri cojol jk'ijak ri wi'tak Galilea, xantak jun comon wic'. ");
INSERT INTO uspNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Xpe man k'apoj anm ri ric'lal Herodías, xoc la ja lamas tijintak chi wic' y xoc chi xojoj chiwchak. Y Herodes Antipas pach mak winak ri tijintak chi wic' riq'uil b'a mex jor kus xriltak xojow man k'apoj anm. Ajruc're' man rey Herodes xij re man k'apoj anm: Tz'onaj chwe nen chawaj. In tanya' chawe, xche' re. ");
INSERT INTO uspNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Xsuj chi kes tz'et tijya' nen chi kelen lal titz'onaj re asta pajnic'j re juntir ri titakon chib' tijya' re. ");
INSERT INTO uspNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Man k'apoj anm xelb'i xe' jtz'onaj re jchuch: ¿Nen tantz'onaj? xche' re jchuch. Jchuch xij re: Tz'onaj jb'a Juan Ajb'anal Ja'tiox, xche' re. ");
INSERT INTO uspNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Man k'apoj anm xoc laj or lamas wi' man rey Herodes, xij re: Chwaj chi taye' chwe li jun nimlaj plat jb'a Juan Ajb'anal Ja'tiox, xche' re. ");
INSERT INTO uspNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Ajruc're' man rey Herodes jorchak tib'isonc, pero jwi'l xiji' chi kes tz'et tijya' nen titz'onaj re y jwi'l xtasaji' jwi'l mak winak ri siq'uil jwi'l, ta' xna'w xij chi ta' chiqui' tijye' ri xtz'onaj re jwi'l man k'apoj anm. ");
INSERT INTO uspNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Laj or xtakb'i jun soldad pire tib'e jc'ame'ch jb'a Juan Ajb'anal Ja'tiox li jun nimlaj plat. Man soldad li xe' resajch jb'a Juan Ajb'anal Ja'tiox li cars ");
INSERT INTO uspNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","y xye'ch li jun nimlaj plat, xc'amch. Xye' re man k'apoj anm y man k'apoj anm xe' jye' re jchuch. ");
INSERT INTO uspNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Cuando yak ajtijol rib'ak chirij Juan Ajb'anal Ja'tiox xtatak jtaquil ri xansaj re, xe' jc'ame'takch jcamnakl y xmuktak. ");
INSERT INTO uspNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Yak jtako'n Kakaj Jesús ri xk'ajtakch chi jb'ij Jyolj Kakaj Dios xmulb'a' rib'ak riq'ui Kakaj Jesús y xyoltak re nen b'anal jwi'lak y nen xantak chi jtijoj cristian re Jyolj Kakaj Dios. ");
INSERT INTO uspNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Jwi'l sub'laj cristian tib'etak y tipetak riq'uilak, ta' tijna' tiwi'ntak. Jwi'li'li Kakaj Jesús xij rechak: Tzajtak, coj uxlantak junquitz li jun luwar kic'an, xche'. ");
INSERT INTO uspNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Ajruc're' rechak xe'tak ric'anak li jun barc li jun luwar lamas ta' cristian ch'akap re nimlaj alagun. ");
INSERT INTO uspNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Sub'laj q'ui cristian xiliwtak re Kakaj Jesús pach yak ajtijol rib'ak chirij b'esaltak li barc b'a ja'. Xeltakch jol chi rakanak lak juntir tilmit xe' jc'ule'tak y nab'e xtawtak chi' nimlaj alagun chiwchak Kakaj Jesús pach yak ajtijol rib'ak chirij. ");
INSERT INTO uspNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Cuando Kakaj Jesús xelb'i li barc xril sub'laj q'ui cristian mulantak cla', xril c'ur jwichak jwi'l jilontak chapca' jun k'at carner ri ta' ajyuk' rechak. Xoc chi jtijojcak re sub'laj kelen chirij Jyolj Kakaj Dios. ");
INSERT INTO uspNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Cuando xe' k'ij yak ajtijol rib'ak chirij Kakaj Jesucristo, xjutuntak chijc'ulel y xijtak re: Xi' k'ij y la' man luwar ri ta' cristian. ");
INSERT INTO uspNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Q'uis ayolj riq'uilak cristian y b'ij rechak chi tib'e jlok'e' jwaak li mak tilmit y li mak ja ri wi'tak chi nakaj, xche'tak re Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Pero Kakaj Jesús xij rechak: Ye'tak jwaak atak, xche'. Rechak xijtak: Tichoconi' quib' cient chi denario pire tikalok' cuxlanwa pire tikatzuktak juntir rib'ilak, xche'tak re Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Kakaj Jesús xij rechak: Iltakneca', ¿jurub' chi cuxlanwa wi' aac'lak? xche' rechak. Cuando xriltak, xijtak re Kakaj Jesús: Job' chi cuxlanwa pach quib' chi car, xche'tak. ");
INSERT INTO uspNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Ajruc're' Kakaj Jesús xij re yak ajtijol rib'ak chirij chi tijb'ijtak re cristian chi ticub'artak b'ak q'uim y tijc'am rib'ak pitak mulaj. ");
INSERT INTO uspNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Mak cristian xcub'artak. Xc'am rib'ak pitak jujun cient (100) y pitak ca'winak lajuj (50) rib'ilak. ");
INSERT INTO uspNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Ajruc're' Kakaj Jesús xc'am mak job' cuxlanwa laj jk'ab' pach mak quib' car y xna'tun lecj. Xc'omowaj re Kakaj Dios, xq'uer mak cuxlanwa y xye' rechak yak ajtijol rib'ak chirij pire tijjachtak re juntir cristian. Y xye' mak quib' car rechak yak ajtijol rib'ak chirij pire xjachtak rechak cristian. ");
INSERT INTO uspNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Juntir cristian xwi'ntak asta xnojtak. ");
INSERT INTO uspNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Cuando xcolajtak juntir cristian, xnojsajtakna cab'lajuj (12) chicach chi q'uertak cuxlanwa pach car ri ta' xq'uisc. ");
INSERT INTO uspNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Job' miltaka' (5,000) chi winak ri xwi'ntak. ");
INSERT INTO uspNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Cuando xantaj li jwi'l Kakaj Jesús, xij rechak yak ajtijol rib'ak chirij chi tijawtakb'i li barc y tinab'ertakb'i pire tik'axtakb'i nab'e ch'akap re nimlaj alagun pire tib'etak Betsaida. Re xcanna jch'ab'ejna mak cristian. ");
INSERT INTO uspNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Ajruc're' xjaw b'a jun witz chi ch'a'wem riq'ui Kakaj Dios. ");
INSERT INTO uspNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Cuando xoc ak'ab', man barc b'esalchak laj jnic'ajl man ja'. Kakaj Jesús xcan ric'anchak chi' nimlaj alagun. ");
INSERT INTO uspNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Re xrilb'i chi mas usil jb'ic man barc jwi'l man tew ji' tijin jpetic laj jsuc'lal lamas b'esal man barc. Cuando sakaremchak re, xe' chi rilicak, b'e tran b'a nimlaj alagun xjutumb'i riq'uilak. Xan chapca' k'axem tramb'i chiwchak. ");
INSERT INTO uspNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Cuando yak ajtijol rib'ak chirij xriltak chi b'e tran Kakaj Jesús b'esal b'a nimlaj alagun, chijch'olak rechak ajtzakal ch'oli'n y xch'ejejtak. ");
INSERT INTO uspNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Juntir xiliwtak y sub'laj xtzaak jch'olak, pero Kakaj Jesús laj or xch'ab'ejtakb'ic, xijb'i rechak: Cowirsaj awanmak, ini'n, mi tzaak ach'olak, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Kakaj Jesús xjaw li barc riq'uilak yak ajtijol rib'ak chirij y xtanar man quiek'ek' tew. Xsaach jch'olak ");
INSERT INTO uspNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","jwi'l ajqui' chi retemajtak nen tijin tran Kakaj Jesús, jwi'l mas usil tijin tretemajtak onque xrila'taka' nen xan Kakaj Jesús chi jtzukic q'uilaj cristian la'ke quib' uxib' chi cuxlanwa. ");
INSERT INTO uspNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Cuando xk'axtakb'i ch'akap re nimlaj alagun, xtawtak li jun luwar ri jb'ij Genesaret y cla' ximtakwi' man barc chi' ja'. ");
INSERT INTO uspNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Xike cuando xkejtakch, mak cristian laj or xch'ob'tak jwich Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Jilonli xe'tak jol lak juntir luwar re Genesaret, xe' jc'ame'takch b'ak ch'atum che' yak ri yajtak. Xc'amtakb'i riq'ui Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Juntir luwar lamas tik'ax Kakaj Jesús li mak tilmit y lak luwar ri wi'tak chinaj re mak tilmit, xpetak yak cristian, xye'tak yak yaj chak' b'e y xtz'onajtak tok'ob' re Kakaj Jesús chi tijye' luwar rechak yak yaj tijchaptak raquitz chak'chi' ritz'ik. Juntir yak ri xchapowtak re xcani' tzib'tak re jyajak. ");
INSERT INTO uspNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Mak fariseo pach jujun yak ajtijoltak cristian re Jpixb' Kakaj Dios ri xpetak Jerusalén xtawtak riq'ui Kakaj Jesús ");
INSERT INTO uspNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","y xriltak chi jujun rechak yak ajtijol rib'ak chirij Kakaj Jesucristo tijtij kelen rechak chi mita' ch'ajal jk'ab'ak. ");
INSERT INTO uspNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Mak fariseo pach juntir yak rijajl Israel ri takel jc'utu'n jmam jtit'ak jwi'lak ta' tijtijtak ni jun kelen rechak wi mita' ch'ajal jk'ab'ak jwi'lak. ");
INSERT INTO uspNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Rechak cuando tik'ajtakch li c'ayb'l ta' tijtij kelen rechak miti tina jch'ajtakna jk'ab'ak. Y wi' mas jc'utu'n jmam jtit'ak tijtakejtak, rechak tina jch'ajtakna jlakak, jvasak, jxarak y nic'j nejb' chic ri b'anal la' ch'i'ch' re tijtijwi' kelen rechak la' asta jch'atak tijch'ajtak. ");
INSERT INTO uspNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Jwi'li'li mak fariseo pach yak ajtijoltak cristian re Jpixb' Kakaj Dios xtz'onajtak re Kakaj Jesús: ¿Nen chac yak ajtijol rib'ak chawij ta' tijtakejtak jc'utu'nak kamam katit'? ¿Nen chac rechak tijtijtak kelen rechak chi mita' ch'ajal jk'ab'ak jwi'lak? xche'tak re Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Kakaj Jesús xij rechak: Tz'eti' Jyolj Kakaj Dios ri xk'asaj Isaías chawijak chi ataka' ajsolcopil acayb'alak cuando xcan jtz'ib'aj jilonri: Yak cristian ri, jchi'ake tib'in chi tijnimirsajtaka' ink'ij, pero laj ranmak ta' tz'et trantak jilonli. ");
INSERT INTO uspNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Ta' nen tichacuj tijnimirsajtak ink'ij. Rechak tijtijojtak cristian re mak c'utu'n ri queneysalke jwi'lak, trantak chapca' ri' Impixb' tijb'ijtak, xche' Kakaj Dios, xche' Isaías, xche' Kakaj Jesús rechak. ");
INSERT INTO uspNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Kakaj Jesús xij chic: Atak xcan aye'tak Jpixb' Kakaj Dios jwi'l ri' chiqui' tatakejtak jc'utu'nak cristian. ");
INSERT INTO uspNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Atak tatakejtak mak ac'utu'nak pire xcan aye'tak jcojic Jpixb' Kakaj Dios. ");
INSERT INTO uspNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Moisés xij jilonri: Coj jk'ij akaj achuch, xche'. Y xij chic: Nen tijyok' jkaj jchuch, tina camsajna, xche'. ");
INSERT INTO uspNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Pero atak tab'ijtak: Jun cristian tijna' tijb'ij re jkaj o jchuch: Ta' incwin chi at'o'ic riq'ui nen rajwax chawe jwi'l juntir kelen we ri wi' corbani'n, atche'tak, xche' Kakaj Jesús rechak. Ri jcholajl tielwi' man yoloj corban, sujul re Kakaj Dios. ");
INSERT INTO uspNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Jwi'li'li atak taye'tak luwar re man cristian li chi ta' tijt'o' jkaj jchuch. ");
INSERT INTO uspNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Jilonli atak tasachtak jwich Jpixb' Kakaj Dios jwi'l ri' tatakejtak mak ac'utu'nak ri xcan ye'saj chawechak jwi'l amam atit'ak. Y wi' chiqui' sub'laj kelen ri tab'ijtak ri ta' tijb'ij Jyolj Kakaj Dios, xche' Kakaj Jesús rechak mak fariseo. ");
INSERT INTO uspNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Ajruc're' Kakaj Jesús xsiq'uij chic cristian, xij rechak: Atak juntir, tatak ri tamb'ij chawechak y tatak jcholajl. ");
INSERT INTO uspNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Ma' ri' ta' mak kelen ri tijtij jun cristian ri tib'anow re timacunc. Ri' ri tielch laj jchi' jun cristian ri tib'anow re timacunc. ");
INSERT INTO uspNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Nen titonc, jte' jcholajl ri tamb'ij, xche' Kakaj Jesús rechak. ");
INSERT INTO uspNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Kakaj Jesús xcan jye' mak cristian y xoctak li jun ja pach yak ajtijol rib'ak chirij. Xpetak yak ajtijol rib'ak chirij, xtz'onajtak re nen jcholajl tielwi' man esb'i no'j ri xij rechak mak cristian. ");
INSERT INTO uspNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Re xij rechak: Atak ta' tatak jcholajl juntir li. Juntir kelen ri tioc laj jchi' jun cristian, ma' ri' ta' li ri tib'anow re timacunc, jwi'l mak kelen li tike k'ax laj jch'ol, ");
INSERT INTO uspNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","ta' tioc laj ranm, tike k'axb'i laj jch'ol, ajruc're' tresajb'ic, xche'. Jilonli xij chi jc'utic chi ta' kelen ri tijel rij ri tib'anow chike ojmacunc. ");
INSERT INTO uspNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Ajruc're' Kakaj Jesús xij chic: Ri' ri tiel laj jchi' jun cristian ri tib'anow re timacunc. ");
INSERT INTO uspNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Jwi'l laj ranmi' jun cristian tipe'w mak etzltak chomorsa'n, mak etzltak rayb'l chi jb'anic tz'i'al, tialk'anc, ticamsanc, ");
INSERT INTO uspNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","trechb'ej jun cristian chic ri ma' jc'ulajl ta'n, tijrayaj kelen re jun cristian chic, wi' mas jno'j chi jb'anic juntir etzltak kelen, tijsub' jun cristian chic, tib'e il jwi'l jb'anic kelen ri ta' tzi, tijti'tij jun cristian chic ri wi' kelen re, tijmol tzij chirij jun chic, tijcoj jk'ij y xike tran kelen ri ta' nen tichacuj. ");
INSERT INTO uspNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Ri' juntir mak etzltak no'j li ri tipe laj ranm jun cristian ri tib'anow re timacunc, xche' Kakaj Jesús rechak. ");
INSERT INTO uspNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Kakaj Jesús xelb'i cla', xe' lak luwar re Tiro pach Sidón. Xoc li jun ja, ri' raj ta' nen tieteman re chi wi' cla', pero ta' xcwin chi jmukic rib' jwi'l xelna jtaquil. ");
INSERT INTO uspNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Jun anm ri wi' jun ric'lal ri wi' etzl laj ranm, cuando xta jtaquil chi wi'chak Kakaj Jesús cla', xpe riq'uil. ");
INSERT INTO uspNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Man anm li ma' rijajl ta' Israel y ji' tipe Sirofenicia, xxucb'a' rib' laj rakan Kakaj Jesús. Xtz'onaj tok'ob' re chi tiesaj man etzl laj ranm ric'lal. ");
INSERT INTO uspNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Kakaj Jesús xij re: Ulb'ejna, wi'ntakna yak alc'walixelb' nab'e. Ta' tzi timajsaj jwaak yak alc'walixelb' y tiye'saj rechak mak tz'i', xche' Kakaj Jesús re man anm. ");
INSERT INTO uspNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Man anm xij chic re Kakaj Jesús: Tz'eti'n, Wajawl, pero mak tz'i' ri wi'tak xe' mex tijtija'taka' mak tra jxerc' jwaak yak alc'walixelb' ri titzaakch b'a mex, xche' man anm re. ");
INSERT INTO uspNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Ajruc're' Kakaj Jesús xij chic re man anm li: Jwi'l mak yoloj ri xab'ij chwe, jat laj awichoch, man etzl xeli' laj ranm awic'lal, xche' re anm. ");
INSERT INTO uspNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Cuando xtaw man anm laj richoch, xe' jte' ric'lal tz'e'l b'a ch'at y man etzl jorok eli' laj ranm ric'lal. ");
INSERT INTO uspNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Kakaj Jesús xel chicb'i lak luwar re Tiro, xk'axb'i Sidón y li mak tilmit re Decápolis. Xtaw chi' man nimlaj alagun ri jb'ij Galilea. ");
INSERT INTO uspNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Y cla' mak cristian xc'amtakch jun winak riq'ui Kakaj Jesús tac y ta' kes ticwin chi yoloj. Xijtak re chi tijye' jk'ab' laj jb'a. ");
INSERT INTO uspNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Kakaj Jesús xresajb'i sic' winak li chijxo'lak cristian, xtosb'i rib'ak y xcoj b'a jk'ab' laj jxicn sic' winak li. Xc'am ra'l jchi' la' jk'ab' y xye' b'a raak'. ");
INSERT INTO uspNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Ajruc're' Kakaj Jesús xna'tun lecj, xjik'xinc y xij: ¡Efatá! xche'. Ri jcholajl tielwi' man yoloj efatá, teb'a' ayb'. ");
INSERT INTO uspNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Laj or xter jxicn sic' winak y tzichak tiyolowc. ");
INSERT INTO uspNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Kakaj Jesús xij rechak chi mi jyoltak re nic'j cristian chic nen xan. Mak cristian onque xijsaj rechak jwi'l Kakaj Jesús chi mita' tresajtak jtaquil, mas puchic xresajtak jtaquil. ");
INSERT INTO uspNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Mak cristian ri xiliwtak, sub'laj xsaach jch'olak, xijtak: ¡Juntir ri tran tziyi'n! ¡Ticwini' chi jtzib'saj jxicnak yak tac y yak mem tichak yolowtak jwi'l! xche'tak chirij Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","La' mak k'ij li xmulb'a' rib'ak sub'laj q'ui cristian chirij Kakaj Jesús y ta' nen tijtijtak. Kakaj Jesús xsiq'uij yak ajtijol rib'ak chirij y xij rechak: ");
INSERT INTO uspNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","Mas twil c'ur jwichak yak cristian jwi'l xana' uxib' k'ij wi'tak wiq'uil y ta' nen tijtijtak. ");
INSERT INTO uspNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Wi tantakb'i laj richochak chi mita' nen tijil jwi'lak, tib'e tukartaka' lak b'e jwi'l wi'jal jwi'l wi' jujun mas naj tipetak, xche' Kakaj Jesús rechak. ");
INSERT INTO uspNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Yak ajtijol rib'ak chirij Kakaj Jesucristo xtz'onajtak re: Pero, ¿lac'umas tikac'amwi' sub'laj cuxlanwa neri li man luwar ri ta' cristian pire tikatzuktak? xche'tak. ");
INSERT INTO uspNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Kakaj Jesús xtz'onaj chic rechak: ¿Jurub' chi cuxlanwa wi' aac'lak? xche' rechak. Rechak xijtak: Wukub' (7) chi cuxlanwa, xche'tak. ");
INSERT INTO uspNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Ajruc're' Kakaj Jesús xij rechak juntir cristian chi ticub'artak lak ulew. Xc'am mak wukub' (7) chi cuxlanwa y xc'omowaj re Kakaj Dios. Ajruc're' xq'uer mak cuxlanwa y xye' rechak yak ajtijol rib'ak chirij y rechak xjachtak chiwchak juntir cristian. ");
INSERT INTO uspNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Y wi' quib' uxib' tra car riq'uilak. Kakaj Jesús xc'omowaj re Kakaj Dios y xtak jachic chiwchak cristian. ");
INSERT INTO uspNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Juntir cristian xwi'ntak asta xnojtak y cuando xcolajtak, xnojsajtakna wukub' (7) chicach chi q'uertak cuxlanwa pach car ri ta' xq'uisc. ");
INSERT INTO uspNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Mak ri xwi'ntak raj wi' quejab' mil (4,000) chi cristian. Kakaj Jesús xcan jch'ab'ej mak cristian. ");
INSERT INTO uspNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Ajruc're' xjawtak li barc pach yak ajtijol rib'ak chirij. Xe'tak Dalmanuta. ");
INSERT INTO uspNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Xpetak mak fariseo, xtawtak riq'ui Kakaj Jesús, xoctak chi yoloj riq'uil, pero pireke triltak wi kes tz'et Kakaj Diosi' takowinakch re, xijtak re chi tran jono c'utb'i jcwinel Kakaj Dios ri tipe lecj. ");
INSERT INTO uspNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Kakaj Jesús sub'laj xjik'xin jwi'l jc'axc'ol laj ranm jwi'l mak cristian ta' tijcojtak jyolj ri tijb'ij, ta' tijcojtak jk'ij ri tijin tran y xij: Mak cristian ri wi'tak wich ulew la' mak junab' lajori tijtz'onajtak tib'an jono c'utb'i jcwinel Kakaj Dios chiwchak. Kes tz'etel tz'et tamb'ij chi chiwchak mak cristian li ta' chiqui' tib'ansaj jono c'utb'i jcwinel Kakaj Dios, xche'. ");
INSERT INTO uspNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Kakaj Jesús xcan jye' mak cristian y xec'. Xjawtak chic li barc pach yak ajtijol rib'ak chirij. Xe'tak chic ch'akap re nimlaj alagun. ");
INSERT INTO uspNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Yak ajtijol rib'ak chirij Kakaj Jesucristo ta' xcuxtaj jwi'lak xc'amtakb'i jcuxlanwaak. Xike jun chi cuxlanwa wi' riq'uilak li barc. ");
INSERT INTO uspNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Kakaj Jesús xij rechak: Atak cwentij ayb'ak re man jch'amk'orak mak fariseo y Herodes Antipas, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Yak ajtijol rib'ak chirij xoctak chi jb'ij chirib'il rib'ak: Kakaj Jesús xij chike jilonli jwi'l ta' kacuxlanwa, xche'tak. ");
INSERT INTO uspNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Kakaj Jesús xta' nen mo tijyoltak yak ajtijol rib'ak chirij, xtz'onaj rechak: ¿Nen chac tab'ijtak chawib'il ayb'ak chi ta' acuxlanwaak? ¿Aj tz'apilni' axicnak? ¿Ajqui'ni' chatatak jcholajl ri tijin tamb'ij? ");
INSERT INTO uspNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","¿Ta'c'u atna'tuntak la' b'ak' awchak? ¿Ta'c'u attontak la' axicnak? ¿Ta'c'u ticuxtaj awi'lak ");
INSERT INTO uspNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","cuando xinjach job' chi cuxlanwa chiwchak job' mil (5,000) chi winak? ¿Jurub'c'u chicach chi q'uertak cuxlanwa pach car xac'oltak chic ri ta' xq'uisc? xche' rechak. Rechak xijtak: Cab'lajuj (12) chicach, xche'tak. ");
INSERT INTO uspNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Kakaj Jesús xij chic: Cuando xinjach mak wukub' (7) chi cuxlanwa chiwchak quejab' mil (4,000) chi cristian, ¿jurub'c'u chicach chi q'uertak cuxlanwa pach car xac'oltak chic? xche' rechak. Rechak xijtak: Wukub' (7) chicach, xche'tak. ");
INSERT INTO uspNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Ajruc're' Kakaj Jesús xij rechak: Ajqui' chatatak jcholajl ri tijin tamb'ij, xche' rechak yak ajtijol rib'ak chirij. ");
INSERT INTO uspNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Ajruc're' xtawtak Betsaida. Mak cristian xc'amtakch jun sic' moy riq'ui Kakaj Jesús y xtz'onajtak tok'ob' re chi tijye' jk'ab' chirij pire tijtzib'saj. ");
INSERT INTO uspNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Jilonli Kakaj Jesús xchapb'i chi jk'ab' sic' moy, xresajb'i rij tilmit. Xye' ra'l jchub' laj jwich sic' moy, xye' jk'ab' laj jb'a y xtz'onaj re wi tichak ril jono kelen. ");
INSERT INTO uspNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Sic' moy xna'tunc, xij: Twila' mak cristian jilon rilicak chapca' mak che' tijin tiwo'cottak, xche'. ");
INSERT INTO uspNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Ajruc're' Kakaj Jesús xye' jk'ab' rij b'ak' jwich. Y sic' moy cow xna'tunc, xtzib' b'ak' jwich, tichak ril juntir kelen asta ri wi' chinaj. ");
INSERT INTO uspNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Ajruc're' Kakaj Jesús xtakb'i laj richoch, xij re: Mat oc li tilmit y ma b'ij re cristian, xche' re. ");
INSERT INTO uspNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Cuando xantaj li, xe'tak Kakaj Jesús pach yak ajtijol rib'ak chirij lak luwar re Cesarea re Filipo y li b'e xtz'onaj rechak yak ajtijol rib'ak chirij: ¿Nenc'u in ri tijb'ijtak mak cristian? xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Rechak xijtak: Jujun tijb'ijtak chi ati' Juan Ajb'anal Ja'tiox, jujun chic tijb'ijtak chi ati' Elías y jujun chic tijb'ijtak chi ati' jun rechak yak ajk'asaltak Jyolj Kakaj Dios, xche'tak re. ");
INSERT INTO uspNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Kakaj Jesús xtz'onaj rechak yak ajtijol rib'ak chirij: Ruc' atak, ¿nenc'u in tab'ij atak? xche' rechak. Xpe Pedro, xij re: Ati' ri b'il jwi'l Kakaj Dios chi tina jtaknach wich ulew, xche' re. ");
INSERT INTO uspNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Kakaj Jesús xij rechak chi mi jyoltak rechak cristian chi ri' re ri b'il jwi'l Kakaj Dios chi tina jtaknach wich ulew. ");
INSERT INTO uspNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Kakaj Jesús xoc chi jb'ij jcholajl rechak yak ajtijol rib'ak chirij chi Jc'ajol Kakaj Dios ri xwux pi cristianil tina jtijna sub'laj c'ax. Tina xutsajna jwi'lak yak ri wi' rekle'nak chijxo'lak yak rijajl Israel y mak jb'ab'alak yak ajc'amaltak jb'eak cristian riq'ui Kakaj Dios y jwi'lak yak ajtijoltak cristian re Jpixb' Kakaj Dios. Tina camsajna, pero tina c'astasajna jwich laj jcamnakl laj jrox k'ij, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Juntir li kes tzi jb'ij xan Kakaj Jesús rechak. Xpe Pedro, xc'amb'i Kakaj Jesús pi ric'an y xoc chi jk'elic. ");
INSERT INTO uspNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Kakaj Jesús xsolcopij rib', xrilb'i yak ajtijol rib'ak chirij y xk'el Pedro, xij re: ¡Elamb'i chinwch at jb'ab'al etzl! At ta' tachomorsaj lawi' raj Kakaj Dios tran, xike tachomorsaj lawi' ri tijchomorsajtak cristian, xche' Kakaj Jesús re. ");
INSERT INTO uspNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Ajruc're' Kakaj Jesús xsiq'uij yak ajtijol rib'ak chirij pach sub'laj cristian ri wi'tak cla' y xij rechak: Wi wi' jonok raj tioc pi ajtijol rib' chwij, rajwaxi' jk'ele' rib' chi jb'anic lawi' ri raj re tran. Rajwaxi' tina jtijna c'ax laj jc'aslemal y tixamb'er chwij. ");
INSERT INTO uspNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Nen jono cristian ta' raj tijye' rib' pi camic jwi'lke tran lawi' raj Kakaj Dios tran, tisaachi' jwich. Pero nen tijye' rib' pi camic inwi'l in y jwi'l jb'ij tzilaj jtaquil chwij, ticolmaji'n. ");
INSERT INTO uspNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Ta' nen tichacuj jwi'l jun cristian trechb'ej juntir kelen re wich ulew wi pi reke tisaach jwich. ");
INSERT INTO uspNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Jun cristian ta' nen ticwin chi jye'ic chi jcolic ranm pire ma' tisaach jwich. ");
INSERT INTO uspNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Wi wi' jono cristian tiq'uixib' inwi'l y tiq'uixib' jwi'l inyolj chiwchak mak cristian ri wi'tak re mak junab' lajori, ri tican jye'tak Kakaj Dios y tib'e ranmak chi jb'anic mak etzltak no'j. Jilon Jc'ajol Kakaj Dios ri xwux pi cristianil, tiq'uixib'i' jwi'l cuando tipet nic' jnimal jk'ij pach Jkaj y tipe pach yak ranjl ri tosol pire re, xche'. ");
INSERT INTO uspNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Kakaj Jesús xij chic rechak: Kes tz'etel tz'et tamb'ij chawechak chi wi' jujun rechak cristian ri wi'tak wiq'uil neri, ta' ticamtak asta tina riltakna jpetic jtakon Kakaj Dios chib'ak cristian la' jcwinel, xche' Kakaj Jesús rechak. ");
INSERT INTO uspNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Raj wakakib' (6) k'ij jb'ij jwi'l Kakaj Jesús jilonli, xe' b'a jun witz naj rak'aneb'. Xc'amb'i Pedro, Santiago y Juan, xtosb'i rib'ak pi ric'anak. Cla' xjalmaj rilic Kakaj Jesús chiwchak. ");
INSERT INTO uspNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Ritz'ik xan sakb'ot y tikopoponc. Ta' ni jono cristian ticwin chi jsakab'saj jun itz'ik chapca' jsakil xan ritz'ik Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Etke xriltak jwich Elías pach Moisés tijintak chi yoloj riq'ui Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Xpe Pedro, xij re Kakaj Jesús: Kajtijonl, jor tzi wojtak neri, tikab'an uxib' chinam, jun pi awe at, jun pi re Moisés y jun pi re Elías, xche' re Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Jilonli xij re Kakaj Jesús, pero ta' retam wi tzi o ta' tzi ri tijin tijb'ij jwi'l juntir rib'ilak tzakali' jch'olak. ");
INSERT INTO uspNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Etke xpe jun sutz', xch'uk rijak. Ri'chak xtatak xaanch jun ch'a'wem li sutz', xij: Ri' ri lok'laj Inc'ajol, tatak jyolj, xche'. ");
INSERT INTO uspNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Cuando xna'tuntak chic, ta' chiqui' xriltak jwich Moisés pach Elías, xichak Kakaj Jesús wa'l ric'an. ");
INSERT INTO uspNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Cuando kesaltakch wich witz, Kakaj Jesús xij rechak yak uxib' ajtijol rib'ak chirij chi mi jyoltak re ni jun cristian nen xriltak, ajri' tijyoltak cuando jorok c'astasaji' jwich laj jcamnakl xo'lak camnakib' Jc'ajol Kakaj Dios ri xwux pi cristianil. ");
INSERT INTO uspNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Jwi'li'li xwa'xna laj ranmak, ta' xyoltak. Rechak tijtz'onajtak chirib'il rib'ak nen jcholajl tielwi' ri tina c'astasajna jwich laj jcamnakl xo'lak camnakib'. ");
INSERT INTO uspNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ajruc're' xtz'onajtak re Kakaj Jesús: ¿Nen chac tijb'ijtak yak ajtijoltak cristian re Jpixb' Kakaj Dios chi rajwaxi' nab'e tipe Elías? xche'tak re Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Kakaj Jesús xij rechak: Tz'eti' chi rajwaxi' tipe Elías nab'e pire tiyuk chi jb'anic jwa'x juntir. Pero, ¿ta'c'u awetamak nen tz'ib'al li wuj re Lok'alaj Jyolj Kakaj Dios chirij Jc'ajol Kakaj Dios ri xwux pi cristianil chi rajwaxi' tijtij c'ax y tina xutsajna? ");
INSERT INTO uspNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Pero in tamb'ij chawechak chi Elías xyuki'n y rechak xana'taka' c'ax re chapca' rajak rechak xantak re chapca' tz'ib'al li wuj re Lok'laj Jyolj Kakaj Dios chirij, xche' Kakaj Jesús rechak. ");
INSERT INTO uspNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Kakaj Jesús xk'ajtakch pach yak uxib' ajtijol rib'ak chirij lamas wi'takwi' yak nic'j ajtijol rib'ak chirij. Xriltak sub'laj q'ui cristian mulantak chirijak yak ajtijol rib'ak chirij y yak ajtijoltak cristian re Jpixb' Kakaj Dios tijin tijc'ottak jchi'ak. ");
INSERT INTO uspNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Juntir cristian ri wi'tak chirijak yak ajtijol rib'ak chirij Kakaj Jesucristo, cuando xriltak jwich Kakaj Jesús, sub'laj xsaach jch'olak chi rilic chi xyuki'n. Laj or xe'tak riq'ui Kakaj Jesús y xc'amtak rutzil jwich. ");
INSERT INTO uspNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Ajruc're' Kakaj Jesús xtz'onaj rechak yak ajtijoltak cristian re Jpixb' Kakaj Dios: ¿Nen tijin tatz'onajtak rechak yak ajtijol rib'ak chwij? xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Y jun rechak mak cristian ri wi'tak cla' xij: Ajtijonl, xinc'ama'ch jun inc'ajol aac'l, wi' etzl laj ranm, ri' xanow mem re. ");
INSERT INTO uspNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Mac'ulke lamas wi', tipe man etzl tijtzak inc'ajol lak ulew y tiputzuw laj jchi' y tijkuch'uch'uj re y tican che' jtio'jl. Xintz'onaj tok'ob' rechak yak ajtijol rib'ak chawij chi tresajtak man etzl, pero ta' xcwintak chi resajc, xche' man winak re Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Kakaj Jesús xij rechak: Atak cristian ri ta' cub'ul ach'olak chirij Kakaj Dios, ¿jurub'c'u k'ij rajwax inwa'xna aac'lak pire ticub'ar ach'olak chwij? ¿Jurub'c'u k'ij rajwax atna incuytakna jwi'l ta' ticub'ar ach'olak chwij? C'amtakch man c'ojol winak, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Xc'amtakch man c'ojol winak riq'ui Kakaj Jesús. Y cuando man etzl xril jwich Kakaj Jesús xye' jun quiek'ek' re man c'ojol winak y xtzaak lak ulew. Xparantij rib' y xputzuw laj jchi'. ");
INSERT INTO uspNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Ajruc're' Kakaj Jesús xtz'onaj re jkaj: ¿Jurub' junab' jcholic jilon tran re ri? xche' re. Jkaj man c'ojol winak xij: Aj nuch'i' cuando xchol re. ");
INSERT INTO uspNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Q'uilaj b'welt xtzaksaj li k'ak' y li ja' jwi'l man etzl. Ri' raj tijcamsaj. Wi atcwin chi kat'o'ic, cojat'owe', il c'ur kawch, xche' man winak re Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Kakaj Jesús xtz'onaj re: ¿Nen chac tatz'onaj chwe wi incwin chi at'o'icak, jwi'l nen kes nojel ranm ticub'ar jch'ol chwij tiye'saji' re nen raj tiye'saj re? xche'. ");
INSERT INTO uspNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Ajruc're' jkaj man c'ojol winak cow xch'a'wc, xij: ¡Ticub'ari' inch'ol, pero quinat'owe' pire ticub'ar mas inch'ol chawij! xche' re Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Cuando Kakaj Jesús xril chi tijin tijmulb'a' rib'ak sub'laj q'ui cristian chirij, xk'el man etzl, xij re: At etzl ri at mem y tac, in tamb'ij chawe. ¡Can ye' man c'ojol winak ri! ¡Mat oc chic laj ranm! xche' Kakaj Jesús re man etzl. ");
INSERT INTO uspNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Y man etzl xch'ejejc. Xye' chic jun quiek'ek' re man c'ojol winak y xelb'ic. Man c'ojol winak xcan chapca' rilic camnakchak. Jwi'li'li mak cristian xijtak chi xcami'n. ");
INSERT INTO uspNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Pero xpe Kakaj Jesús, xchap chi jk'ab', xb'it. Y man c'ojol winak xwa'rc. ");
INSERT INTO uspNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Cuando Kakaj Jesús xoctak la ja pach yak ajtijol rib'ak chirij, rechak xtz'onajtak re pi ric'anak: ¿Nen chac ta' xojcwin oj chi resaj man etzl li? xche'tak re Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Kakaj Jesús xij rechak: Mak etzl chapca' man ri, xike jun cristian ticwin chi resaj ri tran ayun y tich'a'w riq'ui Kakaj Dios, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Cuando xeltakb'i Kakaj Jesús cla' pach yak ajtijol rib'ak chirij xk'axtakb'i Galilea. Ri' raj ta' tietemaj jwi'l cristian chi wi'chak chijxo'lak cla', ");
INSERT INTO uspNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","jwi'l tijini' chi jtijoj yak ajtijol rib'ak chirij. Tijin tijb'ij rechak chi Jc'ajol Kakaj Dios ri xwux pi cristianil tina jachsajna laj jk'ab'ak mak cristian, tina jcamsajtakna y laj jrox k'ij tina c'astasajna jwich laj jcamnakl. ");
INSERT INTO uspNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Pero rechak ta' xtatak jcholajl nen tielwi' ri xijsaj rechak y titzaak jch'olak chi jtz'onaj re nen tielwi' man yoloj ri xij rechak. ");
INSERT INTO uspNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Ajruc're' Kakaj Jesús pach yak ajtijol rib'ak chirij xtawtak Capernaúm. Cuando wi'takchak li jun ja, xpe Kakaj Jesús xtz'onaj rechak: ¿Nen xayoltakch li b'e? xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Pero ta' xch'a'wtak, jwi'l li b'e xyoltak chirib'il rib'ak nen rechak kes mas nim jk'ij chijxo'lak. ");
INSERT INTO uspNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Ajruc're' Kakaj Jesús xcub'ar y xij rechak yak cab'lajuj (12): Wi wi' jonok raj ticojsaj jk'ij, rajwaxi' mi jcoj jk'ij y jye' rib' chi takem re juntir jpach chapca' jun cristian ri wi' rajw, xche' Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Ajruc're' Kakaj Jesús xwab'a' jun ral ac'l laj xo'lak y xk'aluj, xij rechak: ");
INSERT INTO uspNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","Nen tic'uluw laj imb'j, jun ri ta' tijcoj jk'ij chapca' man ral ac'l ri, ini' injc'ul. Nen inc'uluw in, ri' tijc'ul ri xintakowch, xche' Kakaj Jesús rechak. ");
INSERT INTO uspNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Xpe Juan, xij re Kakaj Jesús: Kajtijonl, oj xkila' jun winak tijin tresaj etzl laj ranm cristian laj ab'j. Oj xkak'ela'n, jwi'l ma' kapach ta'n, xche'. ");
INSERT INTO uspNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Kakaj Jesús xij: Ma k'eltak jwi'l ta' ni jun cristian ticwin chi resaj mak etzl laj ranm cristian laj imb'j y ajruc're' tiyok'on chic chwij. ");
INSERT INTO uspNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Jwi'l nen jono cristian ri ta' ojjcontrij ri' jun kiq'uil. ");
INSERT INTO uspNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Nen jonok raj tijye' jun vas joron chawechak jwi'l ataka' re ri b'il jwi'l Kakaj Dios chi tina jtaknach wich ulew, kes tz'et tamb'ij chi tina jc'ulna jq'uixel nen or, xche' re yak ajtijol rib'ak chirij. ");
INSERT INTO uspNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Kakaj Jesús xij chic rechak: Nen jono ri tran chi yak ri ta' mas nimak jk'ijak ri cub'ul jch'olak chwij tikejtak li mac, ri' mas tzi tiximsajb'i jun nimlaj ab'aj re que'm chi jkul y tit'ojsajb'i li mar. ");
INSERT INTO uspNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Wi ri' ak'b' tib'anow chawe atkej li mac, c'urb'ic. Ri' mas tzi junchak ak'b' tata' tzilaj c'aslemal riq'ui Kakaj Dios lecj ri ta' jq'uisic chiwch wi' chi quib' ak'b' atb'e li man luwar re tijb'i c'ax ri lamas wi' man k'ak' ri ta' jchupic. ");
INSERT INTO uspNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Y cla' ta' ticamtak mak amol ri titijiwtak jtio'jl cristian y ta' jchupic man k'ak'. ");
INSERT INTO uspNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Wi awakan tib'anow chawe atkej li mac, c'urb'ic. Ri' mas tzi junchak awakan tata' tzilaj c'aslemal riq'ui Kakaj Dios lecj ri ta' jq'uisic chiwch wi' chi quib' awakan att'ojsajb'i li man luwar re tijb'i c'ax. ");
INSERT INTO uspNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Y cla' ta' ticamtak mak amol ri titijiwtak jtio'jl cristian y ta' jchupic man k'ak'. ");
INSERT INTO uspNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Wi ri' b'ak' awch tib'anow chawe atkej li mac, esajb'ic. Ri' mas tzi junchak b'ak' awch atoc lamas titakonwi' Kakaj Dios chiwch wi' chi quib' b'ak' awch att'ojsajb'i li man luwar re tijb'i c'ax. ");
INSERT INTO uspNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Y cla' ta' ticamtak mak amol ri titijiwtak jtio'jl cristian y ta' jchupic man k'ak'. ");
INSERT INTO uspNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Juntir cristian tina jtijtakna c'ax, nic' riq'uil tiatz'amajtak jwi'l k'ak'. ");
INSERT INTO uspNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Atz'am tziyi'n, pero wi man atz'am tiel jqui'l, ta' chiqui' tijna' tran qui'. Ji'c'ulon atak b'antak tzitaklaj no'j pire tiwa'x utzil chaxo'lak. Ri' li chapca' tran atz'am ri tiye'w jqui'l kelen pire tzi chi tijem, xche' Kakaj Jesús re yak ajtijol rib'ak chirij. ");
INSERT INTO uspNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Kakaj Jesús xelb'i Capernaúm, xe' lak luwar re Judea ri wi'tak ch'akap re nimi ja' Jordán. Cla' xmulb'a' rib'ak sub'laj q'ui cristian chirij y Kakaj Jesús xoc chic chi jtijojcak re Jyolj Kakaj Dios jwi'l nak'tali' jilon tran. ");
INSERT INTO uspNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Ajruc're' nic'j fariseo xjutuntak chijc'ulel Kakaj Jesús y ri'ke rajak tijtatak wi tijta'tak jun jmac laj jyolj, xtz'onajtak re: ¿Ton jya' luwar Jpixb' Kakaj Dios chi jun winak tijjachb'i rixokl? xche'tak re. ");
INSERT INTO uspNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Kakaj Jesús xtz'onaj rechak: ¿Nenc'u xij Moisés chawechak? xche' rechak mak fariseo. ");
INSERT INTO uspNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Rechak xijtak: Moisés xya' luwar chi tijna' tijjach rixokl jun winak, xike man winak tijtz'ib'aj jun wuj re jachb'i ib', xche'tak re Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Ajruc're' Kakaj Jesús xij rechak: Moisés xcan jtz'ib'aj jun pixab' jilonli jwi'l atak pur ab'aj awanmak. ");
INSERT INTO uspNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Pero cuando Kakaj Dios xchol jb'anic juntir ri wi'tak wich k'ijsak, Kakaj Dios xan winak pach anm, ");
INSERT INTO uspNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","jwi'li'li jun winak cuando tic'uli'yc, tican jye' jkaj jchuch ");
INSERT INTO uspNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","y tic'uli'y riq'ui rixokl y chi quib' rib'ilak tiwuxtak pi juntakchak chi cristian chiwch Kakaj Dios. Ma' quib'tak ta' chiqui'n, juntakchak chi cristian. ");
INSERT INTO uspNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Jwi'li'li jun winak ta' luwar tijjach rixokl ri quiek riq'uil xc'ulb'aj jwi'l Kakaj Dios, xche' Kakaj Jesús rechak mak fariseo. ");
INSERT INTO uspNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Cuando wi'takchak Kakaj Jesús la ja pach yak ajtijol rib'ak chirij, rechak xtz'onajtak re nen jcholajl tielwi' man yoloj ri xcan jb'ij rechak mak fariseo. ");
INSERT INTO uspNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Kakaj Jesús xij: Jun winak wi tican jache' rixokl y tic'uli'y chic riq'ui jun jalan anm chic, chiwch Kakaj Dios tijin trechb'ej jun jalan anm ri ma' jc'ulajl ta'n. ");
INSERT INTO uspNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Y jilon jun anm wi tican jache' richjil y tic'uli'y chic riq'ui jun jalan winak chic, chiwch Kakaj Dios tijin tiechb'ej jwi'l jun jalan winak ri ma' jc'ulajl ta'n, xche' Kakaj Jesús rechak. ");
INSERT INTO uspNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Jun k'ij nic'j cristian xc'amtakch ralc'walak riq'ui Kakaj Jesús pire tijye' jk'ab' chib'ak, pero yak ajtijol rib'ak chirij xk'eltak yak cristian ri c'amalch ralc'walak jwi'lak. ");
INSERT INTO uspNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Cuando Kakaj Jesús xril chi yak ajtijol rib'ak chirij xk'elontak, xpe retzal, xij rechak: Ma k'eltak, ye'tak luwar rechak mak tral ac'l tipetak wiq'uil jwi'l jtakon Kakaj Dios chib'ak cristian pirechi' yak ri jilontak chapca' tral ac'l ri. ");
INSERT INTO uspNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Kes tz'etel tz'et tamb'ij chawechak chi nen ta' tijc'ul jtakon Kakaj Dios chapca' jun ral ac'l, ta' tioc lamas titakon Kakaj Dios chib'ak cristian, xche' Kakaj Jesús rechak yak ajtijol rib'ak chirij. ");
INSERT INTO uspNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Ajruc're' xpe Kakaj Jesús, xk'aluj mak tral ac'l ri xjutuntak riq'uil y xye' jk'ab' chib'ak. ");
INSERT INTO uspNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","B'esal Kakaj Jesús li b'e cuando xpe jol jun winak b'iom. Xxucb'a' rib' chiwch xtz'onaj re: At, Tzilaj Ajtijonl, ¿nen rajwax tamb'an pire tanta' tzilaj c'aslemal riq'ui Kakaj Dios lecj ri ta' jq'uisic? xche' re Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Kakaj Jesús xtz'onaj re: ¿Nen chac tab'ij chwe chi ini' tzi? Ta' ni jun tzi, xike Kakaj Dios ri tzi. ");
INSERT INTO uspNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Awetamchak Jpixb' Kakaj Dios ri tijb'ij jilonri: Mat camsanc, ma wechb'ej jun jalan cristian wi ma' ac'ulajl ta'n, mat alk'anc, ma mol tzij chirij jun cristian, mat sub'unc, coj jk'ijak akaj achuch, tiche', xche' Kakaj Jesús re man winak b'iom. ");
INSERT INTO uspNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Man winak b'iom xij chic: Ajtijonl, juntir li xincoja'ch pi aj in ac'l, xche'. ");
INSERT INTO uspNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Kakaj Jesús sub'laj kus xril, xij re: Ajwi' jun kelen rajwax tina ab'anna. Jat, c'ayta juntir kelen awe ri wi' y man rijil tajach chiwchak yak ri wi' rajwax rechak. Jilonli tiwa'xi' sub'laj utzil pi awe riq'ui Kakaj Dios lecj pi jq'uexwach ab'iomil. Ajruc're' atpe wiq'uil pire atxamb'er chwij, xche' Kakaj Jesús re man winak b'iom. ");
INSERT INTO uspNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Cuando man winak xta jilonli xijsaj re jwi'l Kakaj Jesús, xjalmaj jcayb'al, sub'laj b'is jwich xec', jwi'l sub'laj b'iomi'n. ");
INSERT INTO uspNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Ajruc're' Kakaj Jesús xsolcopij rib' chi rilic yak ajtijol rib'ak chirij y xij: Sub'laj c'ax roquicak mak b'iom lamas titakon Kakaj Dios chib'ak cristian, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Yak ajtijol rib'ak chirij Kakaj Jesucristo xsaach jch'olak chi jtaic jyolj, pero Kakaj Jesús xca'mulaj chic jb'ij rechak, xij: Atak walc'wal, tamb'ij chawechak sub'laj c'ax roquic jun b'iom lamas titakon Kakaj Dios chib'ak cristian jwi'l xike tib'e ranm chirij jb'iomil. ");
INSERT INTO uspNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Tanca'mulaj chic jb'ij chawechak ri' ta' mas c'ax jk'axic jun camello laj b'ak' jwich jun acux chiwch roquic jun b'iom lamas titakon Kakaj Dios chib'ak cristian, xche' Kakaj Jesús rechak yak ajtijol rib'ak chirij. ");
INSERT INTO uspNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Yak ajtijol rib'ak chirij Kakaj Jesucristo, cuando xtatak chi jilonli xij Kakaj Jesús rechak, sub'laj xsaach jch'olak, xijtak chirib'il rib'ak: Wi jilonli, ta' ni jun ticolmaj laj jk'ab' jmac, xche'tak. ");
INSERT INTO uspNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Cow xilsajtak jwi'l Kakaj Jesús y xij rechak: Pi rechak cristian ta' ni jonok ticwinc, pero Kakaj Dios ta' ni jun kelen ma' ticwin chi jb'anic, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Xpe Pedro, xij re Kakaj Jesús: Oj xcani' kaye' juntir kelen ke ri wi' y xojxamb'eri' chawij, xche' re. ");
INSERT INTO uspNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Kakaj Jesús xij: Kes tz'etel tz'et tamb'ij chawechak, nen jun cristian tican jye' richoch, rech'elxic, jkaj jchuch, ralc'wal y rulew inwi'lke in y jwi'lke jb'ij tzilaj jtaquil chwij, ");
INSERT INTO uspNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","tijc'ula' sub'laj nim jq'uixel kelen re neri wich ulew chiwch ri xcan jye'. Tina wa'xna sub'laj nim jq'uixel chapca' richoch, rech'elxic, jchuch, ralc'wal y rulew onque tina jtijna c'ax y la' mak junab' ri tina pena tijta' tzilaj c'aslemal riq'ui Kakaj Dios lecj ri ta' jq'uisic. ");
INSERT INTO uspNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Pero sub'laj q'ui ri nab'etak lajori ri cojol jk'ijak, ri'taka' ticantak pi q'uisb'ire jwi'l ta' chiqui' ticojsaj jk'ijak. Y sub'laj q'ui ri q'uisb'ire lajori ri ta' cojol jk'ijak, ri'taka' tinab'ertak jwi'l tina cojsajna jk'ijak, xche' Kakaj Jesús rechak. ");
INSERT INTO uspNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","B'esaltak li b'e, xe'tak Jerusalén y Kakaj Jesús nab'e chiwchak yak ajtijol rib'ak chirij, rechak sachal jch'olak y yak ri xamtak chirijak tzakal jch'olak. Ajruc're' Kakaj Jesús xsiq'uij chicb'i yak cab'lajuj (12) ajtijol rib'ak chirij pi ric'anak y xoc chi jb'ij rechak nen mo tib'ansaj re. ");
INSERT INTO uspNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Xij rechak: Lajori ojb'etak Jerusalén, cla' tijachsaj Jc'ajol Kakaj Dios ri xwux pi cristianil laj jk'ab'ak mak jb'ab'alak yak ajc'amaltak jb'eak cristian riq'ui Kakaj Dios y laj jk'ab'ak yak ajtijoltak cristian re Jpixb' Kakaj Dios. Rechak tijtz'onajtak k'atb'itzij chirij pire ticamsajc. Y tijjachtak laj jk'ab' yak ma' rijajl ta' Israel, ");
INSERT INTO uspNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","tritz'b'ejtak jwich, tijchub'ajtak jwich, tijsec'tak y tijcamsajtak. Pero laj jrox k'ij tina c'astasajna jwich laj jcamnakl, xche' Kakaj Jesús rechak yak ajtijol rib'ak chirij. ");
INSERT INTO uspNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Xpetak Santiago pach Juan ri yak jc'ajol Zebedeo, xjutuntak riq'ui Kakaj Jesús, xijtak re: Kajtijonl, chikaj taye' chike ri tikatz'onaj chawe, xche'tak re. ");
INSERT INTO uspNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Xpe Kakaj Jesús, xtz'onaj rechak: ¿Nen chawajak tamb'an chawechak? xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Rechak xijtak re Kakaj Jesús: Taye' luwar chike chi cuando atcub'ar chi takon chib'ak cristian, jun ticub'ar laj apaach y jun ticub'ar laj amax, xche'tak re. ");
INSERT INTO uspNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Ajruc're' Kakaj Jesús xij rechak: Atak ta' awetamak nen attijintak chi jtz'onaj chwe. ¿Tonc'u acuya'taka' c'ax chapca' ri tina intijna in? xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Rechak xijtak: Tikacuya'n, xche'tak. Kakaj Jesús xij rechak: Atak tacuya'taka' c'ax ri chapca' ri tina intijna in, ");
INSERT INTO uspNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","pero ta' ye'l luwar chwe chi jcha'ic nen ticub'ar laj impaach o laj immax, jwi'l ri' tiye'saj rechak yak ri cha'ltak jwi'l Kakaj Dios, xche' Kakaj Jesús rechak. ");
INSERT INTO uspNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Cuando yak lajuj (10) ajtijol rib'ak chirij Kakaj Jesucristo xtatak nen xijsaj re Kakaj Jesús, xpe retzalak chirij Santiago pach Juan. ");
INSERT INTO uspNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Xpe Kakaj Jesús, xsiq'uij yak ajtijol rib'ak chirij, xij rechak: Atak awetamaki' chi mak jb'ab'al jk'atb'itzijak yak ma' rijajl ta' Israel tijchomorsajtak chi wi' mas takon laj jk'ab'ak chib'ak yak jwinakak y mak nimaktak jb'ab'alak titakontaka' chib'ak. ");
INSERT INTO uspNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Pero chaxo'l atak, ma' ji'ta'lonli. Chaxo'l atak nen raj ticojsaj jk'ij, rajwaxi' rane' lawi' ri rajwax jb'anic pi rechak nic'j chic. ");
INSERT INTO uspNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Y wi wi' jono chawechak raj tioc pire b'ab'al, rajwaxi' tijye' rib' chi takem re juntir jpach chapca' jun cristian ri wi' rajw. ");
INSERT INTO uspNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Jilon chapca' xan Jc'ajol Kakaj Dios ri xwux pi cristianil, ta' xpe wich ulew pire tib'ansaj lawi' ri raj tib'ansaj re re. Re xpe wich ulew pirechi' tiyuk rane' lawi' ri rajwax rechak cristian y tiyuk jache' rib' pi camic chi jcolicak sub'laj cristian laj jk'ab' jmacak, xche' rechak yak ajtijol rib'ak chirij. ");
INSERT INTO uspNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Kakaj Jesús xtawtak Jericó pach yak ajtijol rib'ak chirij. Cuando elamb'i rechak Jericó, sub'laj q'ui cristian xamb'ertakb'i chirijak y wi' jun sic' moy ri jb'ij Bartimeo ri jc'ajol Timeo cub'ul chi' b'e chi jtz'onaj limoxn. ");
INSERT INTO uspNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Cuando sic' moy xta chi ri' Kakaj Jesús ri aj Nazaret b'esal, xoc chi ch'ejejem chi jch'ab'ej Kakaj Jesús, xij: ¡Kaj Jesús, Jc'ajol David, il c'ur inwch! xche'. ");
INSERT INTO uspNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Sub'laj cristian xk'elewtak re ri' rajak ta' chiqui' tich'a'wc, pero re mas chiqui' cow xch'ejejc, xij chic: ¡Jc'ajol David, il c'ur inwch! xche'. ");
INSERT INTO uspNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Ajruc're' Kakaj Jesús xwa'rc, xij: Siq'uijtakch, xche'. Y xsiq'uijtakch sic' moy, xijtak re: Cowirsaj awanm, b'iiten. Atch'ab'ej jwi'l Kakaj Jesús, xche'tak mak cristian re. ");
INSERT INTO uspNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Ajruc're' sic' moy xcan jt'oje' man ritz'ik ri tijk'u'j, xb'iit jol y xjutumb'i riq'ui Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Ajruc're' xpe Kakaj Jesús, xtz'onaj re: ¿Nen chawaj tamb'an chawe? xche' re. Sic' moy xij: Ajtijonl, chwaj inna'tunc, xche' re. ");
INSERT INTO uspNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Kakaj Jesús xij re: Tichak jna' atb'ec, xatna'tuni' jwi'l xcub'ar ach'ol chwij, xche' re. Y sic' moy laj or xna'tunc y xamb'erb'i chirij Kakaj Jesús li b'e. ");
INSERT INTO uspNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Cuando xtawtak chi nakaj re Jerusalén, wi'takchak chijc'ulel Betfagé pach Betania ri wi'tak wich witz ri jb'ij Olivos. Kakaj Jesús xtakb'i quib' ajtijol rib'ak chirij, ");
INSERT INTO uspNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","xij rechak: Jattak li man tilmit ri wi'b'i chawchak. Cuando attawtak, tib'e ate'tak jun ra b'ur ximil cla', ajqui' ni jono cristian quejawinak re. Quirtak y c'amtakch. ");
INSERT INTO uspNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Wi wi' nen tib'in chawechak: ¿Nen chac taquirtak ra b'ur? wi tiche' chawechak, b'ijtak re: Tike chocon jwi'l Kajawl y laj orke tiyuk jk'asaj, atche'tak re, xche' Kakaj Jesús rechak. ");
INSERT INTO uspNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Rechak xe'tak, xe' jte'tak ra b'ur ximil chi' b'e nakaj re pwert. Rechak xquirtak ra b'ur. ");
INSERT INTO uspNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Xpe nic'j rechak mak cristian ri wi'tak cla', xtz'onajtak rechak: ¿Nen chac taquirtak ra b'ur li? xche'tak re yak quib' ajtijol rib'ak chirij Kakaj Jesucristo. ");
INSERT INTO uspNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Rechak xijtak rechak mak cristian chapca' ri xijsaj rechak jwi'l Kakaj Jesús. Ji'kelonli xye'saj luwar rechak xquirtak ra b'ur. ");
INSERT INTO uspNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Rechak xc'amtakb'i ra b'ur riq'ui Kakaj Jesús. Ajruc're' xye' ritz'ikak ri tijk'u'jtak chirij ra b'ur y Kakaj Jesús xquejajb'ic. ");
INSERT INTO uspNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Xpe sub'laj q'ui cristian, xlic' ritz'ikak ri tijk'u'jtak laj jb'e Kakaj Jesús. Nic'j chic xtoctak xaktak che' lak woron, xlic'tak laj jb'e Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Cristian ri nab'etak chiwch Kakaj Jesús pach ri tixamtak chirij xoctak chi ch'ejejem, xijtak: ¡Nim jk'ij Jc'ajol David! ¡Kakaj Dios ri Kajawl wi' jk'ab' chib' ri petzal laj jb'ij! ");
INSERT INTO uspNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","¡Kakaj Dios wi' jk'ab' chib' jtakon kamam David ri petzalc! ¡Nim jk'ij Kakaj Dios lecj! xche'tak cristian. ");
INSERT INTO uspNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Kakaj Jesús xoc Jerusalén y xe' li nimi richoch Kakaj Dios, xe' rile' nen mo jb'anic nimi richoch Kakaj Dios. Y cuando xril chi b'esalchak k'ij, xe'tak Betania pach yak cab'lajuj (12) ajtijol rib'ak chirij. ");
INSERT INTO uspNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Laj jcab' k'ij, cuando xeltakb'i Betania, Kakaj Jesús xc'ok wi'jal. ");
INSERT INTO uspNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Xrilb'i chinaj chi wi' jun jche'l higo ri wi' jxak. Xe' rile' wi wi' jwich, pero ta' jwich jwi'l ajqui' jk'ijl tiwichinc. ");
INSERT INTO uspNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Jwi'li'li Kakaj Jesús xch'ab'ej man che', xij re: Ta' chiqui' atwichin pire attijsaj, xche' re. Yak ajtijol rib'ak chirij xta'taka' ri xij Kakaj Jesús re man che'. ");
INSERT INTO uspNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Cuando xtaw chic Kakaj Jesús Jerusalén, xoc li nimi richoch Kakaj Dios y xoc chi ruktajb'i mak ajc'ayb' pach mak ajlok'omanl ri wi'tak li nimi richoch Kakaj Dios. Xsolcopij mak jmexak mak ajq'uexeltak pwak ri wi'tak cla' pach jtemak mak ajc'ayaltak ut. ");
INSERT INTO uspNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Ta' chiqui' xye' luwar rechak mak ajc'ayb' tioctak pach rika'nak li nimi richoch Kakaj Dios chi c'ayinc. ");
INSERT INTO uspNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Kakaj Jesús xoc chi jtijoj cristian, xij rechak: Tz'ib'ali' li wuj re Lok'laj Jyolj Kakaj Dios ri tijb'ij jilonri: Wichoch rechi' lamas tib'an ch'a'wem wiq'uil pi rechak juntir cristian re juntir tilmit, xche' Kakaj Dios, tiche'. Pero atak cojoli' awi'lak pi molb'i rib'ak mak alk'om, xche' Kakaj Jesús rechak. ");
INSERT INTO uspNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Mak jb'ab'alak yak ajc'amaltak jb'eak cristian riq'ui Kakaj Dios pach yak ajtijoltak cristian re Jpixb' Kakaj Dios xtatak jtaquil chi Kakaj Jesús xresaji'b'i mak ajc'ayb' li nimi richoch Kakaj Dios. Xoctak chi jchomorsaj chirib'il rib'ak nen mo trantak chi jcamsaj Kakaj Jesús. Pero tike tzaak jch'olak jwi'l sub'laj q'ui cristian jor tzi tijtatak jtijon Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Oquem tran uku'm xeltakb'i Jerusalén Kakaj Jesús pach yak ajtijol rib'ak chirij, xe'tak Betania. ");
INSERT INTO uspNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Ak'ab' laj jcab' k'ij Kakaj Jesús pach yak ajtijol rib'ak chirij xk'axtak chijc'ulel man jche'l higo. Xriltak chekjchak juntir jk'ab' pach ra'. ");
INSERT INTO uspNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Ajruc're' Pedro xcuxtaj jwi'l, xij re Kakaj Jesús: Kajtijonl, il impuch man jche'l higo ri xab'ij re chi ni jun b'welt tiwichin chic, xchekeji'n, xche' re Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Kakaj Jesús xij rechak yak ajtijol rib'ak chirij: Cub'a' ach'olak chirij Kakaj Dios. ");
INSERT INTO uspNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Kes tz'etel tz'et tamb'ij chawechak, wi wi' jono chawechak tijb'ij re man witz ri: Elamb'i cla', t'ojta ayb' li mar, tiche' re. Y wi kes tz'et tijcoj chi titawi' chiwch lawi' ri tijb'ij y wi mita' tijquib'aj ranm, titawi' chiwch. ");
INSERT INTO uspNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Jwi'li'li tamb'ij chawechak chi juntir ri tatz'onajtak re Kakaj Dios cuando atch'a'wtak riq'uil, wi tacoja'taka' chi tiye'saji' chawechak lawi' ri tatz'onajtak, tiye'saji' chawechak. ");
INSERT INTO uspNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Cuando attijintak chi ch'a'wem riq'ui Akajak Dios y wi ticuxtaj awi'lak chi wi' jonok b'anowinak c'ax chawechak, rajwaxi' tacuytak jmac pire ticuysaj amacak atak jwi'l Akajak Dios ri wi' lecj. ");
INSERT INTO uspNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Pero wi ta' tacuytak jmac jun cristian, Akajak Dios ri wi' lecj ta' tijcuy amacak, xche' Kakaj Jesús rechak yak ajtijol rib'ak chirij. ");
INSERT INTO uspNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Ajruc're' xtawtak chic Kakaj Jesús Jerusalén pach yak ajtijol rib'ak chirij. Cuando Kakaj Jesús tijin tiwo'cot li nimi richoch Kakaj Dios, mak jb'ab'alak yak ajc'amaltak jb'eak cristian riq'ui Kakaj Dios pach mak jb'ab'alak yak ajtijoltak cristian re Jpixb' Kakaj Dios pach yak ri wi' rekle'nak chijxo'lak yak rijajl Israel ");
INSERT INTO uspNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","xpetak, xtz'onajtak re Kakaj Jesús: ¿Nenc'u xattakow chi jb'anic jilonli? ¿Nenc'u xye'w k'atb'itzij laj ak'b' pire tab'an jilonli? xche'tak re. ");
INSERT INTO uspNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Kakaj Jesús xij rechak: Jilon in chwaj tantz'onaj jun kelen chawechak. C'ululajtak inyolj, ajruc're' tamb'ij chawechak nen xintakowch chi jb'anic jilonli. B'ijtak chwe: ");
INSERT INTO uspNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","¿Nenc'u xtakow re Juan Ajb'anal Ja'tiox chi jb'anic ja'tiox? ¿Kakaj Diosni' xtakow re o cristianke? xche' Kakaj Jesús rechak. ");
INSERT INTO uspNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Rechak xoctak chi jchomorsaj chirib'il rib'ak nen tijb'ijtak, xijtak: Wi tikab'ij chi Kakaj Dios xtakowch re Juan Ajb'anal Ja'tiox, li tijb'iji' chike: ¿Nenc'u chac ta' xacojtak jyolj? tiche'. ");
INSERT INTO uspNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Pero ta' tijna' tikab'ij chi mak cristianke xtakowtak re, xche'tak chirib'il rib'ak. Tike tzaak jch'olak jwi'l juntir cristian retamaki' chi Juan Ajb'anal Ja'tiox kes tz'etel tz'et ajk'asal Jyolji' Kakaj Dios. ");
INSERT INTO uspNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Ajruc're' xpetak, xijtak re Kakaj Jesús: Ta' ketam nen takowinakch re, xche'tak. Kakaj Jesús xij chic rechak: Jilon in ta' tamb'ij chawechak nen xye'w k'atb'itzij laj ink'b' chi jb'anic jilonli, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Ajruc're' Kakaj Jesús xoc chi jb'ij jun esb'i no'j rechak, xij: Wi' jun winak xtic uva laj rulew y xcoj corral chirij. Xc'ot jun luwar lamas xan man yetz'b'i uva y xan jun ja naj rak'aneb' pire tijchajaj jtico'n. Ajruc're' xcan jye' man rulew li chi kejom rechak nic'j ajchac y xe' chinaj li jun jalan tilmit chic. ");
INSERT INTO uspNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Cuando xtaw k'ij tik'anab' jwichak mak uva, xpe man rajw ulew, xtakch jun jtako'n riq'uilak chi jtz'onaj rechak mak ajkejeltak ulew lawi' mak jwich uva ri tiye'saj re pire kejb'ire man ulew. ");
INSERT INTO uspNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Pero mak ajkejeltak ulew xchaptak man tako'n li, xsec'tak y xk'asajtakb'i chi ta' nen xye'takb'i re. ");
INSERT INTO uspNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Ajruc're' xpe man rajw ulew, xtak chicch jun jtako'n chic riq'ui mak ajkejeltak ulew, pero rechak xchaptak man tako'n li, xch'i'tak laj jb'a y xyok'tak. ");
INSERT INTO uspNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Man rajw ulew xtak chicch jun jtako'n chic riq'ui mak ajkejeltak ulew y mak ajkejeltak ulew xcamsajtak man tako'n li. Ajruc're' man rajw ulew xtak chicch nic'j jtako'n. Nic'j rechak mak tako'n li xsec'sajtak y nic'j chic xcamsajtak jwi'lak mak ajkejeltak ulew. ");
INSERT INTO uspNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Y man rajw ulew ajwi' chiqui' jun jtako'n, ri' jun jc'ajol ri sub'laj tijlok'aj y ri' li xtak chicch pi q'uisb'ire chi jtz'onaj lawi' ri tiye'saj re kejb'ire man ulew. Re xij laj ranm: Lajori tantakb'i inc'ajol, pent tichak cojontak chiwch, xche' man rajw ulew. ");
INSERT INTO uspNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Pero mak ajkejeltak ulew cuando xriltak xtaw jc'ajol man rajw ulew, xijtak chirib'il rib'ak: Ri' re tiechb'en man ulew, lajori kacamsajtak pire tican man ulew ri pi ke oj, xche'tak. ");
INSERT INTO uspNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Xpetak, xchaptak y xcamsajtak. Camnakchak xresajtakb'i lak uva. ");
INSERT INTO uspNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","¿Nenc'u tran man rajw ulew rechak mak ajkejeltak ulew? Man rajw ulew tipetc, tiyuk jcamsaj mak ajkejeltak ulew y tijye' chic rulew chi kejom re nic'j chic. ");
INSERT INTO uspNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","¿Ta'c'u ilan awi'lak ri tijb'ij li wuj re Lok'laj Jyolj Kakaj Dios jilonri? Man ab'aj ri xcan jxute'tak yak ajb'analtak ja, ri' xoc pire man nab'e ab'aj pire jcowil man ja. ");
INSERT INTO uspNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Jilonli xan Kakaj Dios ri Kajawl y sub'laj ojqui'cot chirij, tiche', xche' Kakaj Jesús rechak. ");
INSERT INTO uspNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Xpetak mak jb'ab'alak yak ajtijoltak cristian re Jpixb' Kakaj Dios pach mak jb'ab'alak yak ajc'amaltak jb'eak cristian riq'ui Kakaj Dios pach yak ri wi' rekle'nak chijxo'lak yak rijajl Israel rajak roj xchape'takb'i Kakaj Jesús jwi'l retamaki' chi chirijaki' rechak xijsaj man esb'i no'j li. Pero tike tzaak jch'olak chiwchak sub'laj cristian ri wi'tak cla', jwi'li'li xcan jye'tak y xe'tak. ");
INSERT INTO uspNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Rechak xe' jtake'takch nic'j rechak mak fariseo pach nic'j rechak mak jpach Herodes Antipas riq'ui Kakaj Jesús, jwi'l ri' rajak chirijke jyolj tikej laj jk'ab'ak pire tijcojtak tzij chirij. ");
INSERT INTO uspNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Mak fariseo xpetak, xijtak re Kakaj Jesús: Ajtijonl, oj ketami' chi tz'etel tz'eti' ri tab'ij y ta' jaljoj rilic cristian tab'an. Jwi'li'li chikaj tikatz'onaj chawe: ¿Tzini' tikatoj alcabar re César o ta'n? xche'tak re. ");
INSERT INTO uspNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Kakaj Jesús retami' chi ajsolcopil jcayb'alake, jwi'li'li xtz'onaj rechak: ¿Nen chac tatoctak etzltak no'j pire inkej laj ak'b'ak? C'amtakneca'ch jun denario pire twil, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Xpetak, xye'tak jun pwak re Kakaj Jesús. Kakaj Jesús xtz'onaj rechak: ¿Nen quiek jcayb'al ri wi' chiwch ri y nen quiek jb'ij ri tz'ib'al chiwch ri? xche' rechak. Rechak xijtak: Rechi' César, xche'tak. ");
INSERT INTO uspNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Kakaj Jesús xij chic rechak: Ye'tak re César lawi' re César y ye'tak re Kakaj Dios lawi' re Kakaj Dios, xche' rechak. Mak winak xsach jch'olak chi jtaic jc'ulb'ej jyoljak xan Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Xpetak mak saduceo, xe'tak riq'ui Kakaj Jesús. Rechak ta' tijcojtak chi tina c'astasajna jwichak camnakib', jwi'li'li xijtak re Kakaj Jesús: ");
INSERT INTO uspNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Ajtijonl, Moisés xcan jtz'ib'aj pi ke oj chi wi wi' jun winak c'uli'nak ticamc y ta' ralc'walak xwa'xc, rajwaxi' tic'uli'y chic jun jk'un riq'ui man anm li, ri camnak richjil pire tiwa'x ralc'wal riq'uil y ticojsaj pi ralc'wal nab'e winak. ");
INSERT INTO uspNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Wi' jun b'welt wi' wukub' (7) chi winak ri jk'un ratz rib'ak. Man nab'eal xc'uli'yc, pero xcamc y ta' ralc'wal xwa'xc. ");
INSERT INTO uspNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Y man jcab'al xc'uli'y chic riq'ui man anm ri camnak richjil li y xcamc, ta' ralc'wal xwa'xc. Y jilon xan chic man jroxal. ");
INSERT INTO uspNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Y jilon xantak mak wukub' (7) chi winak ri jk'un ratz rib'ak, xc'uli'ytak riq'ui man anm li. Ni jono rechak xwa'x ralc'walak. Pi q'uisb'ire xcam man anm. ");
INSERT INTO uspNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Cuando tic'astasaj jwichak camnakib', ¿nenc'u rechak trixokolaj man anm li, jwi'l mak wukub' (7) chi winak xc'uli'ytak riq'uil? xche'tak mak saduceo re Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Kakaj Jesús xij rechak: Atak sachalcataka'n, jwi'l ta' awetamak nen tijb'ij li wuj re Lok'laj Jyolj Kakaj Dios y ta' awetamak juntir ri jcwinel Kakaj Dios ri wi'. ");
INSERT INTO uspNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Cuando tic'astasaj jwichak camnakib', chi winak chi anm ta' chiqui' tic'uli'ytak, ji'chaklontak chapca' yak anjl ri wi'tak lecj. ");
INSERT INTO uspNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Pero wi' chiqui' jun yoloj tamb'ij chawechak chirij camnakib' cuando tic'astasaj jwichak. Atak ilani' awi'lak li wuj ri xcan jtz'ib'aj Moisés cuando xch'ab'ejch jwi'l Kakaj Dios li jun nimlaj mat lo'quiej ri tijin tic'atc y xij re jilonri: Ini' ri in jDios Abraham, Isaac y Jacob, xche'. ");
INSERT INTO uspNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Atak sachalcataka'n, jwi'l Kakaj Dios ma' jDios ta' yak camnakib', jDiosaki' yak ri yo'ltak, xche' Kakaj Jesús rechak. ");
INSERT INTO uspNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Xpe jun rechak yak ajtijoltak cristian re Jpixb' Kakaj Dios, xta chi tziyi' ri xijsaj rechak mak saduceo jwi'l Kakaj Jesús. Y xpe re, xtz'onaj re Kakaj Jesús: ¿Nen chi pixab' lal mas rajwax ticojsaj chiwchak nic'j pixab' chic? xche' re Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Kakaj Jesús xij re man ajtijol cristian re Jpixb' Kakaj Dios: Tatak jcholajl atak rijajl Israel, xike jun Kakaj Dios ri Kajawl wi', ta' chiqui' jun chic. Man pixab' ri mas rajwax ticojsaj ri' ri: ");
INSERT INTO uspNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Lok'aj Akaj Dios ri Awajawl riq'ui nojel awanm y xike chomorsaj chirij Kakaj Dios y b'an riq'ui nojel awanm lawi' raj tab'an. ");
INSERT INTO uspNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Y jcab' pixab' tijb'ij jilonri: Lok'aj awijl atz'akt chapca' jlok'aj ayb' at tab'an, tiche'. Ta' chiqui' jono Jpixb' Kakaj Dios chic mas rajwax ticojsaj chiwchak mak quib' pixab' li, xche' Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Ajruc're' man ajtijol cristian re Jpixb' Kakaj Dios xij re Kakaj Jesús: Ajtijonl, kes tz'etel tz'eti' xab'ij chi junke chi Kakaj Dios wi' y ta' chiqui' jun Dios chic. ");
INSERT INTO uspNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Rajwaxi' tikalok'aj Kakaj Dios riq'ui nojel kanm y xike tikachomorsaj chirij re y riq'ui nojel kanm tikab'antak lawi' raj tikab'an y rajwaxi' tikalok'ajtak jun cristian chapca' jlok'aj kib' oj tikab'an. Ri' li mas rajwax tib'ansaj chiwchak juntir mak sipan ri tic'atsaj chib' man altar pire tisujsaj re Kakaj Dios re tojb'i mac, xche' re Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Kakaj Jesús xta chi jor tzi jc'ululaj xansaj jwi'l man winak li, xij re: Raquitzchak raj pire taye' luwar titakon Kakaj Dios chab', xche' Kakaj Jesús re. Ta' chiqui' ni jonok xcoj jcowil ranm chi jc'otic jchi' Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Kakaj Jesús tijin chi jtijojcak mak cristian li nimi richoch Kakaj Dios xij: ¿Nen chac tijb'ijtak yak ajtijoltak cristian re Jpixb' Kakaj Dios chi jun ri b'il jwi'l Kakaj Dios chi tina jtaknach wich ulew rijajli' David? ");
INSERT INTO uspNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Pero David xijsaji' re jwi'l Lok'laj Jsantil Kakaj Dios cuando xij jilonri: Kakaj Dios ri Kajawl xiji' re Wajawl: Cub'ren laj impaach asta tina injachna laj ak'b' juntir yak ri atcontrinc, xche' Kakaj Dios, xché David. ");
INSERT INTO uspNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","¿Nen mo jun ri b'il jwi'l Kakaj Dios chi tina jtaknach wich ulew, rijajli' David, cuando David xiji' Wajawl re? xche' Kakaj Jesús rechak. Sub'laj cristian ri mulb'em rib'ak cla' tziyi' xtatak jyolj Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Cuando Kakaj Jesús tijin chi jtijojcak cristian, xij chic rechak: Tacwentij ayb'ak riq'uilak yak ajtijoltak cristian re Jpixb' Kakaj Dios. Rechak ri' mas tzi tric'ajtak tijcojtak nimak rakan ritz'ikak cuando tiwo'cottak y mas tzi triltak tic'amsaj rutzil jwichak lak c'ayb'l pi c'utb'ire chi nimi' jk'ijak. ");
INSERT INTO uspNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Cuando tib'etak li sinagog mas kus triltak ticub'artak la' mak tem ri lamas ticub'artak yak ri wi' rekle'nak y mas kus triltak ticub'artak la' mak nab'etak tem lak comon wic'. ");
INSERT INTO uspNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Tresajtak kelen rechak chirijak yak anm ri camnak richjil y pire b'amb'i jwichak chiwchak cristian sub'laj naj trantak chi ch'a'wem riq'ui Kakaj Dios. Jwi'li'li masna c'ax k'atb'itzij tib'ansaj chib'ak jwi'l Kakaj Dios, xche' Kakaj Jesús rechak. ");
INSERT INTO uspNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Li jun k'ij cuando cub'ul Kakaj Jesús li nimi richoch Kakaj Dios chijc'ulel mak cax re c'olb'i pwak ri tisipaj re Kakaj Dios, tijin tril nen mo trantak mak cristian chi jye'ic pwak li cax. Xpetak nic'j b'iom, xye'tak sub'laj pwak li mak cax. ");
INSERT INTO uspNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Xpe jun anm powr ri camnak richjil, xye' li jun cax quib' tra pwak ri ta' nimak jwich. ");
INSERT INTO uspNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Xpe Kakaj Jesús, xsiq'uij yak ajtijol rib'ak chirij, xij rechak: Kes tz'etel tz'et tamb'ij chawechak chi sic' anm powr ri camnak richjil ri' xye'w mas chiwchak juntir ri tijye'tak pwak li cax re c'olb'i pwak ri tisipaj re Kakaj Dios. ");
INSERT INTO uspNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Juntir mak b'iom li, ri' tijye'tak ri mita' tijq'uistak chi sachem. Ruc' sic' anm powr ri camnak richjil xya' juntir ri wi' riq'uil re tzukb'i rib', xche' Kakaj Jesús rechak. ");
INSERT INTO uspNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Cuando Kakaj Jesús xelb'i li nimi richoch Kakaj Dios, xpe jun re yak ajtijol rib'ak chirij, xij re: Kajtijonl, il impuch mak nimaktak ab'aj ri cojol re nimi richoch Kakaj Dios y sub'laj nimi ja, xche' re Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Kakaj Jesús xij re man ajtijol rib' chirij: Xawila' jkusil nimi richoch Kakaj Dios ri, pero tina tawna jun k'ij chi ta' chiqui' ni jono ab'aj tican chib' jun chic. Juntir li tina yojmajna, xche' re. ");
INSERT INTO uspNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Cuando Kakaj Jesús cub'ulchak b'a witz ri jb'ij Olivos ri wi'b'i chiwch nimi richoch Kakaj Dios, xpetak Pedro, Santiago, Juan y Andrés, xijtak re Kakaj Jesús pi ric'anak: ");
INSERT INTO uspNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","Chikaj tab'ij chike nen or titaw chiwch ri xab'ij. ¿Nenc'u retal ri tiilsaj pire c'utb'ire chikawch chi tawem tran chiwch ri xab'ij chike? xche'tak re. ");
INSERT INTO uspNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Xpe Kakaj Jesús, xij rechak: Tike cwentij ayb'ak pire ma' atsub'sajtak, ");
INSERT INTO uspNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","jwi'l sub'laj q'ui tina petakna y tijcoj rib'ak chapca' in, tijb'ijtak: Ini' ri b'il jwi'l Kakaj Dios chi tina jtaknach wich ulew, tina che'takna y sub'laj cristian tijsub'tak. ");
INSERT INTO uspNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Atak cuando tatatak jtaquil chi tijini' nimaktak ch'o'j li jono luwar, mi tzaak ach'olak jwi'l jilonli tina b'anna, pero ajqui' chi taw k'ij re q'uisb'itak k'ij re jwich k'ijsak ");
INSERT INTO uspNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","jwi'l jun nimlaj tilmit tina ch'o'jintakna riq'ui jun tilmit chic y jun rey tina ch'o'jinna riq'ui jun rey chic. Tina ranna nimaktak cab'rakn lak jaljojtak luwar y tina pena sub'laj wi'jal. Pero juntir li ajri' cholb'ire c'ax ri tina pena chib'ak cristian. ");
INSERT INTO uspNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Tike acwentij ayb'ak, jwi'l inwi'lke in atna jachsajtakna laj jk'ab'ak mak comontak jb'ab'alak yak rijajl Israel. Atna sec'sajtakna lak sinagog y atna c'amsajtaknab'i chiwchak mak jb'ab'altak k'atb'itzij y chiwchak mak rey. Y jilonli tijna' tab'ijtak rechak chi tz'eti' ri ilan y tal awi'lak chwij. ");
INSERT INTO uspNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Rajwaxi' nab'e tina b'ijsajna tzilaj jtaquil chwij rechak juntir cristian wich ulew. ");
INSERT INTO uspNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Cuando atc'amsajtakb'ic y atjachsajtak laj jk'ab'ak mak jb'ab'altak k'atb'itzij, mat octak il chi jchomorsaj nen tab'ijtak. Cuando titaw k'ij li, xike tab'ijtak nen ri tib'ijsaj chawechak jwi'l Kakaj Dios, jwi'l ma' atak ta' atch'a'wtak, ri' Lok'laj Jsantil Kakaj Dios ri wi' laj awanmak tich'a'wc. ");
INSERT INTO uspNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Jun cristian tina jachna jk'un o ratz pi camic y jun chuchkajw tina jachna ralc'wal pi camic y yak alc'walixelb' tina jb'itna rib'ak chirij jkaj jchuchak y tina jachtakna pi camic. ");
INSERT INTO uspNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Juntir cristian ri ta' ticojontak chiwch Kakaj Dios atna retzelb'ejtakna y atna jcontrijtakna inwi'lke in, pero nen ta' tijquib'aj ranm chwij asta ticamc, ticolmaji' laj jk'ab' jmac, xche' Kakaj Jesús rechak. ");
INSERT INTO uspNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Y Kakaj Jesús xij chic rechak: Tina awiltakna li man luwar ri tosol pire Kakaj Dios jun ri ajb'anal c'ax ri xutul jwi'l Kakaj Dios. Ajruc're' yak cristian ri wi'tak Judea rajwaxi' laj or tielmajtakb'i b'ak witz. Nen tril jwich man wuj ri, jte' jcholajl. ");
INSERT INTO uspNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Y nen wi' b'a ja, mi oc chic chi resaj kelen re la ja. ");
INSERT INTO uspNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Y nen wi' lak chac mi k'aj chic laj richoch chi jc'amic ritz'ik ri tijk'u'j. ");
INSERT INTO uspNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","¡C'ur jwichak yak yaj anm la' mak k'ij li pach yak ri wi' jne'ak tijtu'tzajtak jwi'l rechak ta' tijna' tielmajtak laj or! ");
INSERT INTO uspNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Atak tz'onajtak re Kakaj Dios chi miti lak k'ij re riq'uil jab' cuando atelmajtakb'ic, ");
INSERT INTO uspNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","jwi'l tina pena jun nimlaj c'ax ri ta' ni jun b'welt b'anal cuando xticarch jwich k'ijsak asta lajori y ni jun b'welt tran chic. ");
INSERT INTO uspNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Miti xij Kakaj Dios ri Kajawl chi ta' q'uilaj k'ij tran man c'ax li, ta' ni jono cristian roj ticolmajc. Re xij jilonli jwi'lke yak ri cha'l jwi'l. ");
INSERT INTO uspNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Wi wi' nen tib'in chawechak: Iltak impuch, ri b'il jwi'l Kakaj Dios chi tina jtaknach wich ulew wi' neri o wi' jili, tiche', ma cojtak, ");
INSERT INTO uspNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","jwi'l wi' cristian tijcoj rib'ak chapca' ri'taka' ri b'il jwi'l Kakaj Dios chi tina jtaknach wich ulew y wi' tijcoj rib'ak pi ajk'asaltak Jyolj Kakaj Dios, pero ta' tz'et. Rechak trana'taka' c'utb'i jcwinelak ri sachom ch'olal rilic, pero pireke tijsub'tak cristian y asta yak ri cha'ltak jwi'l Kakaj Dios rajak tijsub'tak. ");
INSERT INTO uspNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Cwentij ayb'ak, in ximb'iji' juntir ri chawechak onque ajqui' chi taw chiwch, xche' Kakaj Jesús rechak Pedro, Santiago, Juan y Andrés. ");
INSERT INTO uspNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Kakaj Jesús xij chic rechak yak ajtijol rib'ak chirij: Cuando jorok k'axi' juntir mak c'ax li ri ximb'ij, ajruc're' tran uku'm jwich k'ij, ic' ta' chiqui' tijye' jk'ak'al, ");
INSERT INTO uspNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","mak ch'umil titzaaktakch lecj y juntir ri wi' lecj tina yucxijna laj jluwrak. ");
INSERT INTO uspNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Ajruc're' triltak Jc'ajol Kakaj Dios ri xwux pi cristianil tikejch lecj li sutz' sub'laj tikopopon jk'ak'al jnimal jk'ij y wi' sub'laj jcwinel. ");
INSERT INTO uspNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ajruc're' tijtakch yak anjl chi jmolic jwich juntir cristian ri cha'ltak jwi'l lak juntir luwar re wich ulew. ");
INSERT INTO uspNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Esaj ano'jak chirijak mak jche'l higo. Cuando tawiltak tiel chicch jxakak ac'al, atak awetamakchak chi petemchak re riq'uil sak'j. ");
INSERT INTO uspNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Y ji'c'ulonli, cuando tawiltak chi tichak tijin titaw chiwch juntir ri ximb'ij chawechak, etemajtak chi Jc'ajol Kakaj Dios ri xwux pi cristianil petemchak re, chi' pwertchak wi'. ");
INSERT INTO uspNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Kes tz'etel tz'et tamb'ij chawechak chi ajqui' chi camtak juntir cristian ri wi'tak wich ulew re mak junab' ri, cuando titaw chiwch juntir ri ximb'ij chawechak. ");
INSERT INTO uspNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Caj pach ulew tisaachi' jwichak, pero tina tawna chiwch juntir ri ximb'ij chawechak. ");
INSERT INTO uspNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Pero ni jonok etemawinak nen chi k'ij lal o nen chi or lal tran ri ximb'ij chawechak, ni yak anjl ri wi'tak lecj retamak, ni Jc'ajol Kakaj Dios, xike Kakaj Dios retam. ");
INSERT INTO uspNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Tacwentij ayb'ak y chajintake. Ch'a'wentak riq'ui Kakaj Dios jwi'l ta' awetamak nen or titaw man k'ij li. ");
INSERT INTO uspNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Jilon chapca' jun winak b'enam re chinaj. Nab'e tijb'ij rechak yak jmocom chi tijchajajtak richoch y tijye' jchacak chi jujunalak y tijb'ij re man ajteb'al pwert chi tike chajinc. ");
INSERT INTO uspNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Jwi'li'li tike acwentij ayb'ak jwi'l ta' awetamak nen or tiyuk man rajw ja. Pent tiyuk pi oquem re ak'ab' o nic'aj ak'ab' o sub'laj ak'ab' o sakchak. ");
INSERT INTO uspNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Jwi'li'li tike acwentij ayb'ak wi etke tipetc, atyuk jte'tak kus awarjak. ");
INSERT INTO uspNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Ri tamb'ij chawechak jilon tamb'ij rechak juntir cristian: Tacwentij ayb'ak, xche' Kakaj Jesús rechak. ");
INSERT INTO uspNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Quib' k'ijchak raj titaw man nimak'ij Pascua y man nimak'ij ri titijsaj cuxlanwa ri ta' ch'amk'or la'. Mak quib' nimak'ij li, li jun xumanke tik'ax. Mak jb'ab'alak yak ajc'amaltak jb'eak cristian riq'ui Kakaj Dios pach yak ajtijoltak cristian re Jpixb' Kakaj Dios tijintak chi jtoquic nen trantak chi jchapic Kakaj Jesús chi mukukil pire tijjachtak pi camic. ");
INSERT INTO uspNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Pero xijtak chirib'il rib'ak: Ta' tikachap la' man nimak'ij ri, pire ma' tijb'it rib'ak cristian chikij, xche'tak. ");
INSERT INTO uspNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Kakaj Jesús wi' Betania laj richoch Simón ri xwa'x yajel chirij ojr ri jb'ij lepra. Cuando cub'ul Kakaj Jesús chi' mex, xtaw jun anm c'amalb'i jun nejb' jwi'l ri b'anal la' ab'aj ri jb'ij alabastro, nojsal chi jun perjum ri jb'ij nardo sub'laj pakal rijil. Xpe man anm li, xk'ip man nejb' y xtz'aj perjum laj jb'a Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Nic'j cristian ri wi'tak cla' xpe retzalak chi rilic man anm y xijtak chirib'il rib'ak: ¿Nen chac xan c'ax re man perjum li? ");
INSERT INTO uspNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Quib' cienti' denario rijil. Ri' mas tzi xc'ayajtene' man perjum pire tit'o'saj yak powr la' man pwak, xche'tak. Poc xyajtak man anm li. ");
INSERT INTO uspNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Pero Kakaj Jesús xij: Can ye'tak anm ri. ¿Nen chac tijin tayajtak? Re utzili' xan chwe. ");
INSERT INTO uspNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Yak powr tiwa'xtaka' chaxo'lak nojel k'ij. Atak tijna' tab'antak utzil rechak cuando chawajak, pero in ta' naj inwa'x chaxo'lak. ");
INSERT INTO uspNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Anm ri, xana' lawi' ri xcwin chi jb'anic. Xtz'aja' perjum laj imb', pero perjum ri xtz'aj laj imb' pi rechak mukb'i we xan. ");
INSERT INTO uspNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Kes tz'etel tz'et tamb'ij chawechak chi lak juntir luwar wich ulew lamas tib'ijsajwi' tzilaj jtaquil chwij, tib'ijsaji' nen xan anm ri chwe y jilonli jcuxtaj tib'anc, xche' Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Xpe jun rechak yak cab'lajuj (12) ajtijol rib'ak chirij Kakaj Jesucristo ri jb'ij Judas Iscariote, xelb'ic, xe' jchomorsaj riq'uilak mak jb'ab'alak yak ajc'amaltak jb'eak cristian riq'ui Kakaj Dios chi tijjacha' Kakaj Jesús laj jk'ab'ak. ");
INSERT INTO uspNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Cuando xtatak chi Judas tijjacha' Kakaj Jesús laj jk'ab'ak, rechak sub'laj xqui'cottak. Xsujtak pwak re, ajruc're' Judas xoc chi jtoquic nen mo tran chi jjachic Kakaj Jesús laj jk'ab'ak. ");
INSERT INTO uspNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Li man nab'e k'ij re mak k'ij re man nimak'ij ri titijsaj cuxlanwa ri ta' ch'amk'or la' cuando tijcamsaj jun ra carner pire tijtijtak re sinar re Pascua, xpetak yak ajtijol rib'ak chirij Kakaj Jesucristo, xtz'onajtak re: ¿Lamas chawaj tib'e kab'ane' jwa'x asinar re Pascua? xche'tak re Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Xpe Kakaj Jesús, xtakb'i quib' re yak ajtijol rib'ak chirij, xij rechak: Jattak Jerusalén. Tib'e ac'ule'tak jun winak c'amalb'i jun k'ib' ja' jwi'l, takejtakb'ic. ");
INSERT INTO uspNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Y lamas tiocwi' tab'ijtak re man rajw ja: Tijb'ij Kajtijonl: ¿Lamas wi'w incwart lamas tantijwi' insinar re Pascua pach yak ajtijol rib'ak chwij? tiche', atche'tak re. ");
INSERT INTO uspNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Y re tijc'ut jun nimlaj cwart chawchak laj jcab' wik re ja ri jamalchak y b'analchak jwa'xc. B'antak jwa'x kasinar re Pascua cla', xche' Kakaj Jesús rechak. ");
INSERT INTO uspNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Y yak quib' ajtijol rib'ak chirij xe'tak, xtawtak Jerusalén. Xe' jte'tak juntir chapca' xijb'i Kakaj Jesús rechak y xantak jwa'x sinar re Pascua. ");
INSERT INTO uspNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Cuando xoc ak'ab', xtaw Kakaj Jesús pach yak cab'lajuj (12) ajtijol rib'ak chirij. ");
INSERT INTO uspNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Cuando cub'ulchak Kakaj Jesús chi' mex chi wic' pach yak ajtijol rib'ak chirij, xij: Kes tz'etel tz'et tamb'ij chawechak chi wi' jun chawechak ri tijin chi wic' wiq'uil, injachow pi camic, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Rechak xpe sub'laj b'is laj ranmak chi jtaic jilonli y xoctak chi jtz'onaj re Kakaj Jesús chi jujunalak: ¿Ma' ini'n ta'n? xche'tak re. ");
INSERT INTO uspNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Kakaj Jesús xij chic rechak: Ri' jun chawechak ri atak cab'lajuj (12) ri tijmu' jcuxlanwa wiq'uil li lak. ");
INSERT INTO uspNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Jc'ajol Kakaj Dios ri xwux pi cristianil jilon tib'an re chapca' tz'ib'al chirij li wuj re Lok'laj Jyolj Kakaj Dios, pero ri' mas c'ur jwich man ri tijachow re pi camic. Ri' mas tzi pire re mitne' xq'uisi'yc, xche' Kakaj Jesús rechak. ");
INSERT INTO uspNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Ajruc're' Kakaj Jesús xc'am jun cuxlanwa, xc'omowaj re Kakaj Dios y xq'uer. Xye' rechak yak ajtijol rib'ak chirij, xij rechak: Tij awechak, ri' ri intio'jl, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Ajruc're' xc'am jun nejb', xc'omowaj re Kakaj Dios y xye' rechak yak ajtijol rib'ak chirij y juntir xtijtak rechak. ");
INSERT INTO uspNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Kakaj Jesús xij rechak: Man ri wi' li nejb' ri' inquiq'uel ri quiek la' xaan man aac' chomorsa'n y tina tz'utuwna chi jtojic jmacak sub'laj cristian. ");
INSERT INTO uspNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Kes tz'etel tz'et tamb'ij chawechak chi in ta' tantij vin re uva aac'lak asta ajri' chiqui' tantij aac' vin aac'lak lamas titakonwi' Kakaj Dios, xche' rechak yak ajtijol rib'ak chirij. ");
INSERT INTO uspNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Cuando xantaj jb'ixaj jun b'ix jwi'lak pire jnimirsaj jk'ij Kakaj Dios, xe'tak wich witz ri jb'ij Olivos. ");
INSERT INTO uspNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Xpe Kakaj Jesús, xij chic rechak yak ajtijol rib'ak chirij: Lak'ab' wica atak juntir tatil ayb'ak jwi'l ta' chiqui' ticub'ar ach'olak chwij. Jwi'l tz'ib'al li wuj re Lok'laj Jyolj Kakaj Dios ri tijb'ij jilonri: Tancamsaj man ajyuk' y juntir mak carner tijtil rib'ak, tiche'. ");
INSERT INTO uspNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Pero cuando tic'astasaj inwch laj incamnakl, innab'erb'i chawchak ojb'etak Galilea, xche' Kakaj Jesús rechak. ");
INSERT INTO uspNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Xpe Pedro, xij re Kakaj Jesús: Onque juntir tijtil rib'ak, pero in ta' imb'ec, xche'. ");
INSERT INTO uspNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Kakaj Jesús xij re Pedro: Kes tz'etel tz'et tamb'ij chawe chi lak'ab' wica jorok ab'iji' oxmul chi ta' tach'ob' inwch cuando tiok' jca'mul man puy, xche' re. ");
INSERT INTO uspNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Pedro xcoj jchok'b' chi jb'ij re Kakaj Jesús, xij: Onque incamsaj chawij, pero in ta' tamb'ij chi ta' tanch'ob' awch, xche'. Y juntir rib'ilak yak ajtijol rib'ak chirij Kakaj Jesucristo jilon xijtak. ");
INSERT INTO uspNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Kakaj Jesús pach yak ajtijol rib'ak chirij xe'tak li jun luwar ri jb'ij Getsemaní. Kakaj Jesús xij rechak yak ajtijol rib'ak chirij: Cub'rentak neri, inna b'ena chi ch'a'wem riq'ui Kakaj Dios, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Kakaj Jesús xc'amb'i Pedro, Santiago y Juan chirij, xpe jun c'ax laj ranm jwi'l b'is. ");
INSERT INTO uspNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Y xij rechak yak ajtijol rib'ak chirij: Wi' jun nimlaj b'is laj wanm, twic'aj in ri' incamsanc. Canentak neri, pero yo'rentak wiq'uil, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Ajruc're' Kakaj Jesús xjutumb'i junquitz, xxucar asta xtaw chi' jwich lak ulew, xoc chi ch'a'wem riq'ui Kakaj Dios. Xtz'onaj re Kakaj Dios wi tijna' miti titaw chiwch man or re jcamic. ");
INSERT INTO uspNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Y xij: At Inkaj, juntir atcwini' chi jb'anic. Inacole' laj jk'ab' juntir c'ax, pero ma' ri' ta' tab'an lawi' chwaj in, ri' b'an lawi' chawaj at, xche' re Kakaj Dios. ");
INSERT INTO uspNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Ajruc're' xk'ajch lamas xcantak yak uxib' ajtijol rib'ak chirij y cuando xtaw riq'uilak, rechak tijintak chi waraj, xij re Simón Pedro: Simón atwari'n, ta' xacuy xatyo'r jun or wiq'uil. ");
INSERT INTO uspNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Yo'rentak y ch'a'wentak riq'ui Kakaj Dios pire ma' taye' ayb'ak attakchi'jtak chi macunc. Asantilak raji' atyo'rtak, pero ri' atio'jlak ta' raj, xche' re. ");
INSERT INTO uspNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Xe' chic Kakaj Jesús jca'mul chi ch'a'wem riq'ui Kakaj Dios. Xca'mulaj jb'ij ri xij nab'e b'welt. ");
INSERT INTO uspNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Cuando xk'aj chicch lamas wi'tak yak uxib' ajtijol rib'ak chirij, xe' jte'tak tijintak chi waraj jwi'l sub'laj c'ax waraj rechak. Rechak ta' chiqui' tijta'tak nen tijb'ijtak re Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Kakaj Jesús xe' chic laj roxmul chi ch'a'wem riq'ui Kakaj Dios. Cuando xk'aj chicch lamas wi'tak yak uxib' yak ajtijol rib'ak chirij, xij rechak: Ajwichi' attijintak chi waraj y ajwichi' attijintak chi uxlanc. Xtawi' chiwch tijachsaj Jc'ajol Kakaj Dios ri xwux pi cristianil laj jk'ab'ak mak ajmacb'. ");
INSERT INTO uspNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","¡B'iitentak! ¡Jo'tak! Xpeti' man ri injachow pi camic, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Aj tijini' Kakaj Jesús chi yoloj riq'uilak yak ajtijol rib'ak chirij cuando xtaw Judas ri jun rechak yak cab'lajuj (12) ajtijol rib'ak chirij pach sub'laj q'ui cristian c'amalb'i espad y che' jwi'lak ri takaltakb'i jwi'lak mak jb'ab'alak yak ajc'amaltak jb'eak cristian riq'ui Kakaj Dios pach yak ajtijoltak cristian re Jpixb' Kakaj Dios pach yak ri wi' rekle'nak chijxo'lak yak rijajl Israel. ");
INSERT INTO uspNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Judas ri tijachow re Kakaj Jesús pi camic xiji' rechak nen tran chi jc'utic Kakaj Jesús chiwchak, xij rechak jilonri: Nen ri tantz'ub'aj jk'otz', ri' li Jesús, chaptak. C'amtakb'ic, tzi jchapic tab'antak, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Cuando xtawtak, xpe Judas xjutun chijc'ulel Kakaj Jesús y xij re: Kajtijonl, xche' re. Y xtz'ub'aj jk'otz'. ");
INSERT INTO uspNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Ajruc're' xpetak mak cristian ri xamtak chirij Judas xchaptakb'i Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Xpe jun rechak yak ajtijol rib'ak chirij Kakaj Jesucristo, xresajch respad y xc'urb'i jun jxicn man jmocom man nimlaj jb'ab'alak yak ajc'amaltak jb'eak cristian riq'ui Kakaj Dios. ");
INSERT INTO uspNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Xpe Kakaj Jesús, xtz'onaj rechak mak cristian li: ¿Nen chac xac'amtakch espad y che' chi inchapic? ¿In inc'u jun alk'om tawiltak? ");
INSERT INTO uspNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Nojel k'ij xintijoj cristian li nimi richoch Kakaj Dios y ta' xinachaptak. Pero juntir ri tijin tib'an pirechi' titaw chiwch ri tijb'ij li wuj re Lok'laj Jyolj Kakaj Dios, xche' Kakaj Jesús rechak. ");
INSERT INTO uspNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Y juntir yak ajtijol rib'ak chirij xelmajtak, xcan jye'tak Kakaj Jesús ric'an. ");
INSERT INTO uspNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Wi' jun c'ojol winak xamb'er chirij Kakaj Jesús ri b'atz'al jun chi itz'ik chirij jwi'l. Xpetak mak cristian, roj xchaptak man c'ojol winak la' ritz'ik, ");
INSERT INTO uspNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","pero re xelmajb'i pi ch'analc, xcan elok man ritz'ik laj jk'ab'ak. ");
INSERT INTO uspNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Ajruc're' xc'amtakb'i Kakaj Jesús riq'ui man nimlaj jb'ab'alak yak ajc'amaltak jb'eak cristian riq'ui Kakaj Dios y cla' xmulb'a' rib'ak juntir mak jb'ab'alak yak ajc'amaltak jb'eak cristian riq'ui Kakaj Dios pach juntir yak ri wi' rekle'nak chijxo'lak yak rijajl Israel pach juntir yak ajtijoltak cristian re Jpixb' Kakaj Dios. ");
INSERT INTO uspNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pedro xtakeji'b'i Kakaj Jesús, pero chinajchak b'esal asta xtaw chuchja re richoch man nimlaj jb'ab'alak yak ajc'amaltak jb'eak cristian riq'ui Kakaj Dios. Pedro xcub'ar chi k'ak' chi jmik'ic rib' chijxo'lak mak ajchajaltak re nimi richoch Kakaj Dios. ");
INSERT INTO uspNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Mak jb'ab'alak yak ajc'amaltak jb'eak cristian riq'ui Kakaj Dios pach juntir mak comontak jb'ab'alak yak rijajl Israel tijin tijtoctak jono jmac Kakaj Jesús pire tijna' ticamsaj, pero ta' tijta'tak, ");
INSERT INTO uspNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","jwi'l sub'laj cristian xcojtak tzij chirij Kakaj Jesús chi wi' jmac. Pero ta' tz'et jwi'l ta' nic' jwich jyoljak ri tijb'ijtak. ");
INSERT INTO uspNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Xpe jujun rechak mak ajcojoltak tzij, xijtak jun molb'i tzij chirij Kakaj Jesús jilonri: ");
INSERT INTO uspNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","Oj xkata' cuando xij man winak ri jilonri: In tina inyojna nimi richoch Kakaj Dios ri cristianke b'anowinak y li uxib' k'ij tamb'an jun chic ri ma' cristian ta'ke tib'anow re, xche', xche'tak. ");
INSERT INTO uspNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Jilonli xijtak mak ajmololtak tzij chirij Kakaj Jesús, pero ta' nic' jwich jyoljak ri tijb'ijtak. ");
INSERT INTO uspNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Xpe man nimlaj jb'ab'alak yak ajc'amaltak jb'eak cristian riq'ui Kakaj Dios, xwa'r chijxo'lak mak cristian xtz'onaj re Kakaj Jesús: ¿Nen chac ta' tac'ululaj mak cristian li, ri ticojowtak tzij chawij? ¿Nen chac ta' nen tab'ij chirij amac ri tijin tijb'ijtak chawij? xche' re Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Y Kakaj Jesús ta' xch'a'wc. Man nimlaj jb'ab'alak yak ajc'amaltak jb'eak cristian riq'ui Kakaj Dios xtz'onaj chic re Kakaj Jesús: ¿Atni' Jc'ajol Kakaj Dios ri b'il jwi'l chi tina jtaknach wich ulew? xche' re. ");
INSERT INTO uspNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Kakaj Jesús xij re: Ini'n. Atak tina awiltakna jwich Jc'ajol Kakaj Dios ri xwux pi cristianil tib'e cub'arch laj jpaach Kakaj Dios ri wi' jcwinel y tipe chic li sutz' lecj nen or, xche' Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Man nimlaj jb'ab'alak yak ajc'amaltak jb'eak cristian riq'ui Kakaj Dios xrech'b'i ritz'ik chirij jwi'l retzal y xij: Ta' chiqui' tichocon mas ajcojoltak tzij chirij kawi'l. ");
INSERT INTO uspNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Atak xata'taka' chi man winak ri, tijin tijcoj rib' pi Jc'ajol Kakaj Dios. ¿Nen tab'ijtak atak chirij? xche'. Juntir cristian xijtak chi pi jmaqui' ticamsajc. ");
INSERT INTO uspNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Ajruc're' jujun xoctak chi jchub'aj jcayb'al. Xch'uktak b'ak' jwich, xsec'tak chi k'ab' y xijtak re: B'ijneca' chike, ¿nen xatsec'owc? xche'tak re. Y mak ajchajaltak re nimi richoch Kakaj Dios xsec'tak chi k'ab'. ");
INSERT INTO uspNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Pedro wi' chuchja cuando xtaw jun anm ri rajic' man nimlaj jb'ab'alak yak ajc'amaltak jb'eak cristian riq'ui Kakaj Dios. ");
INSERT INTO uspNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Xril chi tijin tijmik' rib' Pedro chi k'ak' chuchja. Cow xril y xij re: At, ati' jpach Jesús ri aj Nazaret, xche' re. ");
INSERT INTO uspNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Pero Pedro xij: Ta' tanch'ob' jwich. Ta' wetam nen quiek chirij tab'ij jilonli, xche' re man ajic'. Ajruc're' Pedro xelb'i cla', xe' chi' oqueb' re chuchja. ");
INSERT INTO uspNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Y man ajic' li xril chi ajwichke wi' Pedro cla', xij rechak cristian ri wi'tak cla': Man winak ri, ri' jun rechak mak jpach Jesús, xche'. ");
INSERT INTO uspNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Pedro xij chic chi ta' tijch'ob' jwich Kakaj Jesús. Ajri'ke jun rat jb'ij jwi'l Pedro jilonli xpetak nic'j cristian ri wi'tak cla', xijtak re Pedro: Tz'etel tz'et, at, ati' jun chijxo'lak yak ajtijol rib'ak chirij Jesús y ati' aj Galilea, xche'tak re Pedro. ");
INSERT INTO uspNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Ajruc're' Pedro xij chic chi tz'etel tz'eti' ri tijb'ij y wi mita' tz'et tijb'ij, tib'ani' k'atb'itzij chirij jwi'l Kakaj Dios, xij: Ta' tanch'ob' jwich man winak li ri tab'ijtak chwe, xche'. ");
INSERT INTO uspNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Cuando xijmaj jilonli jwi'l Pedro, xok' jca'mul man puy, ajruc're' xcuxtaj jwi'l Pedro ri xijsaj re jwi'l Kakaj Jesús: Lak'ab' wica cuando ajqui' chi ok' jca'mul man puy, at jorok ab'iji' oxmul chi ta' tach'ob' inwch, xche' Kakaj Jesús re Pedro. Jwi'li'li tik'utut ranm, xelb'i cla', xe' jcamsaj rib' chi ok'ej. ");
INSERT INTO uspNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Cuando xsakarsanc, mak jb'ab'alak yak ajc'amaltak jb'eak cristian riq'ui Kakaj Dios xmulb'a' rib'ak pach yak ri wi' rekle'nak chijxo'lak yak rijajl Israel pach yak ajtijoltak cristian re Jpixb' Kakaj Dios y juntir mak comontak jb'ab'alak yak rijajl Israel xchomorsajtak nen trantak re Kakaj Jesús, xximtakb'ic y xe' jache'tak laj jk'ab' Pilato. ");
INSERT INTO uspNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Xpe Pilato, xtz'onaj re Kakaj Jesús: ¿Atni' jreyak yak rijajl Israel? xche' re. Kakaj Jesús xij re: Ini'n, jilon chapca' ri xab'ij, xche' re Pilato. ");
INSERT INTO uspNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Mak jb'ab'alak yak ajc'amaltak jb'eak cristian riq'ui Kakaj Dios sub'laj tzij xcojtak chirij Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Pilato xtz'onaj chic jca'mul re Kakaj Jesús: ¿Nen chac ta' tac'ululaj jyoljak mak cristian li chirij amac ri tijb'ijtak? xche' re. ");
INSERT INTO uspNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Pero Kakaj Jesús ta' xc'ululaj ni jun yoloj y Pilato sub'laj xsaach jch'ol jwi'l ta' nen xij Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Pilato ri jb'ab'al k'atb'itzij nak'tali' nojel junab' re man nimak'ij tijtak jun prex lawi' rajak cristian titaksajc. ");
INSERT INTO uspNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Wi' jun winak li cars ri jb'ij Barrabás. Re wi' li cars pach mak jpach ri xantak camic cuando xch'o'jintak riq'ui man jb'ab'al k'atb'itzij. ");
INSERT INTO uspNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Xtawtak sub'laj cristian riq'ui Pilato xijtak re chi tresaj jun re mak prexb' chapca' tran nojel junab'. ");
INSERT INTO uspNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pilato xtz'onaj rechak: ¿Chawajakni' tantakb'i man jreyak yak rijajl Israel? xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Jilonli xij rechak jwi'l re retami' chi mak jb'ab'alak yak ajc'amaltak jb'eak cristian riq'ui Kakaj Dios xjachtak Kakaj Jesús laj jk'ab' jwi'lke tijti'tijtak. ");
INSERT INTO uspNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Mak jb'ab'alak yak ajc'amaltak jb'eak cristian riq'ui Kakaj Dios xtakchi'jtak sub'laj cristian pire tijb'ijtak re Pilato chi titaksajb'i Barrabás. ");
INSERT INTO uspNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pilato xtz'onaj rechak: ¿Nenc'u tamb'an re, ri tab'ijtak chi ri' man jreyak yak rijajl Israel? xche'. ");
INSERT INTO uspNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Rechak cow xch'ejejtak, xijtak: ¡Camsaj wich curs! xche'tak. ");
INSERT INTO uspNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pilato xtz'onaj rechak: ¿Nenc'u kes c'ax b'anal jwi'l? xche'. Pero rechak cow xch'ejejtak chic, xijtak: ¡Camsaj wich curs! xche'tak. ");
INSERT INTO uspNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pilato ri' raj tzi tiilsaj jwi'lak cristian, xtak resajb'i Barrabás li cars y xtak jseq'uic Kakaj Jesús. Ajruc're' xjachb'i pire tib'e jcamsajtak wich curs. ");
INSERT INTO uspNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Mak soldad xc'amtakb'i Kakaj Jesús li nimlaj richoch man jb'ab'al k'atb'itzij y xmulb'a'tak juntir mak soldad ri wi'tak cla'. ");
INSERT INTO uspNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Xximtak jun nimlaj quiek itz'ik chirij Kakaj Jesús. Xpach'ujtak jun coron la' q'uix y xcojtak laj jb'a. ");
INSERT INTO uspNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Xoctak chi ch'ejejem chi ritz'b'ej jwich y xijtak re: ¡Nim ak'ij, at jreyak yak rijajl Israel! xche'tak re. ");
INSERT INTO uspNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Xoctak chi jchub'aj jwich y xsec'tak laj jb'a la' jun che'. Xxucartak chiwch chi jcojic jk'ij, pero ta' tz'et rechak. ");
INSERT INTO uspNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Xantaj ritz'b'ej jwich Kakaj Jesús jwi'lak, xresajtak chic man nimlaj quiek itz'ik chirij y xcojtak chic ritz'ik chirij. Ajruc're' xc'amtakb'i pire tib'e jcamsajtak wich curs. ");
INSERT INTO uspNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Cuando b'esaltak lak b'e, xc'ultak jun winak ri jb'ij Simón aj Cirene ri jkaj Alejandro pach Rufo, b'enam re li tilmit Jerusalén, xchaptak y xijtak re chi trikajb'i jcurs Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Xc'amtakb'i Kakaj Jesús li jun luwar ri jb'ij Gólgota. Ri jcholajl tielwi' man yoloj Gólgota, jb'akel jb'a camnak. ");
INSERT INTO uspNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Xye'tak vin re chi tijem yujul pach mirra, pero Kakaj Jesús ta' raj xtij. ");
INSERT INTO uspNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Ajruc're' xtz'octak Kakaj Jesús wich curs y xantak suert chirij ritz'ik chi rilic nen chi itz'ik lal tijch'ectak chi jujunalak. ");
INSERT INTO uspNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Kakaj Jesús xtz'ocsaj wich curs laj b'elejeb' (9) or re ak'ab'. ");
INSERT INTO uspNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Y wich curs xcojsaj jun kelen tz'ib'al jwich ri lamas tijb'ij nen chac xcamsajtak wich curs, tijb'ij jilonri: RI' RI JREYAK YAK RIJAJL ISRAEL, tiche'. ");
INSERT INTO uspNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Y xtz'ocsaj quib' alk'om wich curs pi jpach Kakaj Jesús, jun laj jpaach y jun chic laj jmax. ");
INSERT INTO uspNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Jilon xansaj re Kakaj Jesús chapca' tijb'ij li wuj re Lok'laj Jyolj Kakaj Dios jilonri: Xansaji' re chapca' tib'ansaj rechak mak etzltak cristian, tiche'. ");
INSERT INTO uspNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Mak cristian ri tik'axtak chijc'ulel Kakaj Jesús tritz'b'ejtak jwich, tijsutaj jb'aak chi jb'ij re: ¡At ri tab'ij chi tayoj nimi richoch Kakaj Dios y li uxib' k'ij tab'an chic jun! ");
INSERT INTO uspNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","¡Col ayb' awic'an y kejench wich curs! xche'tak re. ");
INSERT INTO uspNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Jilonri ritz'b'ej jwich Kakaj Jesús xantak mak jb'ab'alak yak ajc'amaltak jb'eak cristian riq'ui Kakaj Dios pach yak ajtijoltak cristian re Jpixb' Kakaj Dios, xijtak chirib'il rib'ak: Xcwini' chi jcolic cristian, pero re ta' ticwin chi jcolic rib' ric'an. ");
INSERT INTO uspNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Wi ri' ri b'il jwi'l Kakaj Dios chi tina jtaknach wich ulew y wi ri' jreyak yak rijajl Israel, kejokch wich curs pire tikil y ojcojontak chiwch, xche'tak. Y jilon mak quib' ri xtz'ocsajtak wich curs pi jpach Kakaj Jesús xritz'b'ejtaka' jwich Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Raj tiq'uil k'ij re cab'lajuj (12) xoc uku'm juntir wich ulew asta laj jrox or re b'esal k'ij. ");
INSERT INTO uspNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Raj laj jrox or re b'esal k'ij cow xch'ejej Kakaj Jesús, xij: ¡Eloi! ¡Eloi! ¿Lama sabactani? xche'. Ri jcholajl tielwi' tijb'ij: ¡At Inkaj Dios! ¡At Inkaj Dios! ¿Nen chac xincan aye' wic'an? tiche'. ");
INSERT INTO uspNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Y jujun rechak mak ri wi'tak cla', cuando xtatak nen xij Kakaj Jesús, xijtak: Tatak impuch nen tijb'ij, tijin tijsiq'uij Elías ri ajk'asal Jyolj Kakaj Dios, xche'tak. ");
INSERT INTO uspNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Laj or xpe jun rechak mak ri wi'tak cla', xe' jol chi jtoquic jun esponj y xmu'b'i li vinagre. Ximb'i chi jtzam jun che' y xye' laj jchi' Kakaj Jesús pire tijtij y xij: Wa'xna cla' y kile'na wi tipe Elías chi jcolic, xche'. ");
INSERT INTO uspNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Ajruc're' Kakaj Jesús cow xch'ejejc y xcamc. ");
INSERT INTO uspNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Cuando xcam Kakaj Jesús, xrech'maj laj nic'j man tosb'i jpam nimi richoch Kakaj Dios, quib' xelwi', xrech'majch pi ajsic asta iquim. ");
INSERT INTO uspNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Cuando man jb'ab'alak mak soldad xril nen mo jcamic Kakaj Jesús, xij: ¡Kes tz'etel tz'et winak ri Jc'ajoli' Kakaj Dios! xche'. ");
INSERT INTO uspNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Y wi' nic'j anm tijin tina'tuntakch chinaj. Chijxo'lak mak anm li wi'taka' María Magdalena, María ri jchuch Santiago ri k'unixel y ri jchuch José y wi' Salomé chijxo'lak. ");
INSERT INTO uspNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Mak anm li xpachijtaka' Kakaj Jesús y xt'owa'taka' cuando re xwa'x Galilea y wi' chiqui' nic'j anm cla' ri jpach Kakaj Jesús xtawtak Jerusalén. ");
INSERT INTO uspNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Cuando oquem tran ak'ab' y jwi'l tawem tran or pire ticholmaj k'ij re uxlan pi rechak yak rijajl Israel, ");
INSERT INTO uspNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","xpe José aj Arimatea jun ri mas nim jk'ij chijxo'lak mak comontak jb'ab'alak yak rijajl Israel. Y re nojeli' ranm tijin chi rulb'ej titakon Kakaj Dios chib'ak cristian. Xcowirsaj ranm, xe' laj or riq'ui Pilato chi jtz'onaj jcamnakl Kakaj Jesús re. ");
INSERT INTO uspNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pilato xsaach jch'ol chi jtaic chi xcami' Kakaj Jesús. Xsiq'uij man jb'ab'alak mak soldad y xtz'onaj re wi tz'et camnakchak Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Cuando man jb'ab'alak mak soldad xij chi kes tz'et xcami'n, ajruc're' Pilato xye' luwar re José chi jkesaj jcamnakl Kakaj Jesús pire tib'e jmuke'. ");
INSERT INTO uspNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Xpe José, xkesaj jcamnakl Kakaj Jesús, xb'atz'b'i la' jun itz'ik ri xlok' ri jb'ij lino y xc'amb'ic. Xe' jmuke' li jun nimlaj jul ri c'otol li ab'aj. Ajruc're' xcan jtz'apij jchi' man jul la' jun ab'aj. ");
INSERT INTO uspNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","María Magdalena pach María ri jchuch José xrila'taka' lamas xcan ye'saj jcamnakl Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Cuando xk'ax man k'ij re uxlan, María Magdalena, María ri jchuch Santiago y Salomé xlok'tak perjum pire tijcojtak chirij jcamnakl Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Sub'laj ak'ab' li nab'e k'ij re xuman, xe'tak chi' jul lamas xye'sajwi' jcamnakl Kakaj Jesús. Xelch k'ij xtawtak cla'. ");
INSERT INTO uspNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Tijin tijb'ijtak chirib'il rib'ak: ¿Nen chiqui' tisolcopin man ab'aj chi' jul chikawch? xche'tak. ");
INSERT INTO uspNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Cuando xna'tuntak chi' jul, xriltak chi man ab'aj ri cojol pire ch'ukb'i chi' man jul ta' chiqui' laj jluwr, solcopilchakb'ic. ");
INSERT INTO uspNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Cuando xoctak li jul lamas xye'sajwi' jcamnakl Kakaj Jesús, xriltak jwich jun c'ojol winak cub'ul li paach re li jul cojol jun saklaj itz'ik chirij ri nim rakan. Rechak sub'laj xtzaak jch'olak chi rilic. ");
INSERT INTO uspNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Man c'ojol winak xij rechak mak anm: Mi tzaak ach'olak. Atak ri' tatoctak Kakaj Jesús aj Nazaret ri xcamsaj wich curs, pero xc'astasaji'b'i jwich laj jcamnakl. Re ta' chiqui' neri. Iltak lamas xye'saj jcamnakl, ta' chiqui'n. ");
INSERT INTO uspNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Jattak, b'ijtatak rechak Pedro pach yak nic'j ajtijol rib'ak chirij jilonri: Re tinab'eri'b'i chawchak atb'etak Galilea, cla' tib'e awile'tak jwich jilon chapca' ri b'il chawechak jwi'l, atche'tak rechak, xche' man c'ojol winak rechak. ");
INSERT INTO uspNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Ajruc're' yak anm li, laj or xeltakb'i li jul lamas xye'sajwi' jcamnakl Kakaj Jesús. Tichak querquentak jwi'l jtzakic jch'olak. Ta' chiqui' ni jun quiek re xijtakwi' nen xriltak. ");
INSERT INTO uspNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Cuando jorok c'astasaji' jwich Kakaj Jesús laj jcamnakl, ak'ab' li nab'e k'ij re xuman, nab'e xilsaj jwich jwi'l María Magdalena ri xesaj wukub' (7) etzl laj ranm jwi'l Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Y re xec', xe' jb'ij rechak yak ri xpachintak re Kakaj Jesús. Rechak jor tib'isontak y tiok'tak chirij Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Pero cuando xtatak chi yo'li' Kakaj Jesús y xilsaji' jwich jwi'l María Magdalena, rechak ta' xcojtak wi tz'eti'n. ");
INSERT INTO uspNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Kakaj Jesús xilsaj chic jwich jwi'lak yak quib' ajtijol rib'ak chirij cuando b'esaltak li b'e ri tib'e lak tra luwar, pero jalan chiqui' rilic jwich xantak. ");
INSERT INTO uspNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Rechak xe' jb'ijtak chic re yak nic'j jpachak chic, pero ta' xcojtak. ");
INSERT INTO uspNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Pi q'uisb'ire xilsaj chic jwich Kakaj Jesús jwi'lak yak junlajuj (11) ajtijol rib'ak chirij cuando cub'ultak chi wic' chi' mex. Kakaj Jesús xyaj yak ajtijol rib'ak chirij jwi'l ta' cub'ul jch'ol chirij y pur ab'aj ranmak, ta' tijcojtak jyoljak yak ri xiliwtak chi xc'astasaji' jwich laj jcamnakl. ");
INSERT INTO uspNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Ajruc're' Kakaj Jesús xij rechak: Jattak riq'uilak juntir cristian wich ulew y b'ijtak tzilaj jtaquil rechak chwij. ");
INSERT INTO uspNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Nen ticojow ri tab'ijtak y tib'ansaj ja'tiox re, ticolmaji' laj jk'ab' jmac. Pero nen ta' ticojow ri tab'ijtak, ji' tib'e li man luwar re tijb'i c'ax. ");
INSERT INTO uspNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Yak cristian ri ticojowtak ri tab'ijtak, tina inye'na jcwinelak chi laj imb'j tresajtak mak etzl ri wi' laj ranmak cristian y tina ch'a'wtakna li jaljojtak tzijb'al ri ta' etemal. ");
INSERT INTO uspNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Wi tijchaptak cumatz, ta' titi'sajtak. Wi tijtijtak jun kelen ri ticamsan, ta' tran c'ax rechak. Y wi tijye' jk'ab'ak laj jb'aak cristian ri yajtak, titzib'taka'n, xche' Kakaj Jesús rechak yak ajtijol rib'ak chirij. ");
INSERT INTO uspNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Cuando xantaj jb'ij jilonli jwi'l Kakaj Jesús rechak yak ajtijol rib'ak chirij, xc'amsajb'i lecj. Xe' cub'ar laj jpaach Kakaj Dios. ");
INSERT INTO uspNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Yak ajtijol rib'ak chirij Kakaj Jesucristo xe'tak chi jb'ij tzilaj jtaquil chirij Kakaj Jesucristo rechak juntir cristian lak juntir tilmit. Ri' Kakaj Jesús tit'o'w rechak chi jb'anic c'utb'i jcwinel Kakaj Dios pire c'utb'ire chi kes tz'eti' ri tijin tijb'ijtak.");
INSERT INTO uspNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Q'uiyi' cristian xtz'ib'antak nen kes jcholajl juntir ri xyuk rane' Kakaj Jesús chikaxo'l. ");
INSERT INTO uspNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Jilon chapca' ri xijsaj chike jwi'lak yak ri xiliwtak jwich Kakaj Jesús ri nen mo xcholmajch y xq'uisb'en juntir ri xan Kakaj Jesús, jwi'l xye'saj rekle'nak chi jb'ij juntir li. ");
INSERT INTO uspNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Y jilon in, chi usili' xinta jcholajl ri juntir nen mo xcholmajch juntir ri xan Kakaj Jesús y lajori ri' li tantz'ib'ajb'i jcholajl chawe li wuj, kaj Teófilo, ");
INSERT INTO uspNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","pire tawetemaj chi kes tz'eti' ri tzilaj jtaquil chirij Kakaj Jesucristo ri xattijojwi'. ");
INSERT INTO uspNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Cuando Nab'e Herodes wi' pire rey re Judea, xwa'x jun ajc'amal jb'eak cristian riq'ui Kakaj Dios ri jb'ij Zacarías. Y man k'at re yak ajc'amaltak jb'eak cristian riq'ui Kakaj Dios ri lamas wi' Zacarías, ri' man k'at re Abías. Y Elisabet ri rixokl Zacarías, rijajli' Aarón. ");
INSERT INTO uspNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Zacarías pach Elisabet pi jcholajli' juntir ri trantak y xcoja'taka' juntir Jpixb' Kakaj Dios ri Kajawl y xana'taka' lawi' raj re xantak. ");
INSERT INTO uspNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Rechak ta' ni jono ralc'walak wa'sal, jwi'l Elisabet ta' tialc'walanc y chi quib' rib'ilak ri'jtaklaj cristiantakchak. ");
INSERT INTO uspNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Cuando xtaw jun k'ij xta' jxumanak yak ajc'amaltak jb'eak cristian riq'ui Kakaj Dios ri man jk'at Abías pire tichacuntak li nimi richoch Kakaj Dios, Zacarías wi' chijxo'lak. ");
INSERT INTO uspNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Yak ajc'amaltak jb'eak cristian riq'ui Kakaj Dios nak'taltaka' tijcha'tak nen rechak tioc li nimi richoch Kakaj Dios ri Kajawl. Ri' Zacarías xcha'tak pire tioc li man luwar ri nim jk'ij re li nimi richoch Kakaj Dios chi jc'atic pom. ");
INSERT INTO uspNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Cuando xtaw or re tic'atsaj pom, yak rijajl Israel tijin tich'a'wtak riq'ui Kakaj Dios chiwch nimi richoch Kakaj Dios. ");
INSERT INTO uspNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Zacarías wi' chi c'ataj pom wich altar re c'atb'i pom li nimi richoch Kakaj Dios, etke xwab'a' rib' jun ranjl Kakaj Dios ri Kajawl chiwch li paach re man altar re c'atb'i pom, ");
INSERT INTO uspNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Zacarías cuando xril jwich anjl sub'laj xsaach jch'ol y xtzaak jch'ol chi rilic. ");
INSERT INTO uspNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Xpe anjl, xij re: Zacarías, mi tzaak ach'ol. Kakaj Dios xta' nen xatz'onaj re cuando xatch'a'w riq'uil. Elisabet awixokl tiwa'xi' jun ra ric'lal winak y tacoj jb'ij pi Juan. ");
INSERT INTO uspNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","At sub'laj atqui'cot laj awanm y sub'laj cristian tiqui'cottak cuando tiq'uisi'y ral ac'ajol. ");
INSERT INTO uspNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Y man ral ac'ajol li chiwch Kakaj Dios ri Kajawl, nimi' jk'ij. Ta' tijtij vin y ta' tijtij kelen ri tik'ab'arsanc. Y tinojsaji' ranm la' Lok'laj Jsantil Kakaj Dios cuando ajqui' chi q'uisi'yc. ");
INSERT INTO uspNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Y tran chi sub'laj rijajl Israel tik'ajtak chic laj jk'ab' Rajawlak ri jDiosak. ");
INSERT INTO uspNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Y ri' Juan tiyuk nab'e wich ulew chi jb'ij jtaquil chirij Kakaj Jesucristo ri Kajawl. Y Juan tiwa'xi' Lok'laj Jsantil Kakaj Dios laj ranm y tiwa'xi' jcwinel chapca' re Elías ri ajk'asal Jyolj Kakaj Dios pire tran chi tiwa'x utzil chijxo'lak yak chuchkajw pach yak ralc'walak. Y tran chi ticojontak chiwch Kakaj Dios yak ri ta' ticojontak pire tiniq'uib' jwichak yak ri suc'ul ranmak chiwch Kakaj Dios. Jilonli wi' sub'laj cristian tic'uluwtak re Kakaj Jesús ri Kajawl cuando tiyuk wich ulew, xche' anjl re Zacarías. ");
INSERT INTO uspNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Zacarías xtz'onaj re anjl: ¿Nen mo twetemaj wi tz'eti' ri xab'ij chwe? In inchak ri'jlaj winak y wixokl ri'jlaj anmchak, xche' re. ");
INSERT INTO uspNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Y anjl li xij re Zacarías: In ini' Gabriel. Tijin tamb'an lawi' raj Kakaj Dios tamb'an, ri' re xintakowch chi yoloj aac'l pire tiyuk imb'ij tzilaj jtaquil li chawe. ");
INSERT INTO uspNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Pero lajori jwi'l ta' tacoj inyolj ri ximb'ij chawe, ta' tijna' atyolow asta titaw chiwch juntir ri ximb'ij chawe, xche' anjl re Zacarías. ");
INSERT INTO uspNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Y juntir cristian ri wi'tak chiwch nimi richoch Kakaj Dios tijintak chi rulb'ej nen or tielch Zacarías y sub'laj sachal jch'olak tijin tijtz'onaj chirib'il rib'ak nen chac ta' relicch. ");
INSERT INTO uspNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Cuando xelch Zacarías, ta' chiqui' tijna' tiyolow riq'uilak. Rechak xye'tak cwent chi wi' jono kelen xril li nimi richoch Kakaj Dios chapca' li ichic'. Zacarías xichak jk'ab' tran chiwchak ta' chiqui' tijna' tiyolow riq'uilak. ");
INSERT INTO uspNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Cuando xtaw k'ij xq'uis jchac Zacarías li nimi richoch Kakaj Dios xk'aj laj richoch. ");
INSERT INTO uspNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Y la' mak k'ij li xcan yaj anm Elisabet ri rixokl Zacarías. Elisabet job' ic' xwa'x la ja, ta' chiqui' lamas xelwi'. ");
INSERT INTO uspNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Elisabet xij laj ranm: Kakaj Dios ri Kajawl xiliw c'ur inwch, jwi'li'li jilon imb'anic ri pire ta' chiqui' inyok'saj jwi'lak mak cristian, xche' laj ranm. ");
INSERT INTO uspNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Cuando Elisabet b'esalchak wakakib' (6) ic' jcanic yaj anm, Kakaj Dios xtak chicch anjl Gabriel li tilmit Nazaret re Galilea ");
INSERT INTO uspNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","chi jsolaj jun anm ri ajqui' ch'ob'ol winak jwi'l ri jb'ij María ri tz'onal jwi'l José ri rijajl David. ");
INSERT INTO uspNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Cuando xtaw anjl lamas wi' María, xij re: Tanye' rutzil awch María. Wi' jun nimlaj utzil pi awe. Kakaj Dios ri Kajawl wi' aac'l, xche' re. ");
INSERT INTO uspNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","María xsaach jch'ol chi jtaic nen xijsaj re. Xoc chi jchomorsaj nen tielwi' ri jc'amic rutzil jwich ri xansaj jwi'l anjl. ");
INSERT INTO uspNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Xpe anjl, xij chic re María: Mi tzaak ach'ol, xata' utzil riq'ui Kakaj Dios. ");
INSERT INTO uspNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Lajori atcan yaj anm y tiq'uisi'y jun ral awic'lal winak, tacoj jb'ij pi Jesús. ");
INSERT INTO uspNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Re tina nimirsajna jk'ij, tib'ijsaji' chirij chi Jc'ajoli' Kakaj Dios lecj y Kakaj Dios ri Kajawl tijya' takon laj jk'ab' chapca' takon ri xwa'x laj jk'ab' David ri jmam. ");
INSERT INTO uspNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Y ri' re titakon chib'ak yak rijajl Israel y ta' jq'uisic jwich jtakonc, xche' re María. ");
INSERT INTO uspNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","María xtz'onaj re: ¿Nen mo tiwa'x wic'lal cuando ajqui' ch'ob'ol winak inwi'l? xche' re. ");
INSERT INTO uspNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Xpe anjl, xij chic re: Kakaj Dios tijtakch Lok'laj Jsantil chab' y jcwinel Kakaj Dios lecj jilon jpetic chab' chapca' jmujal sutz'. Jwi'li'li ral awic'lal ri tiq'uisi'y tib'ijsaji' chirij chi tosoli' pire Kakaj Dios y Jc'ajoli' Kakaj Dios. ");
INSERT INTO uspNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Jilon Elisabet ri awech'elxic, ri'jlaj anmchak, re tina wa'xna jun ric'lal winak y wi'chak wakakib' (6) ic' jcanic yaj anm onque tib'ijsaj chirij chi ta' tiwa'x ralc'wal, ");
INSERT INTO uspNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","jwi'l Kakaj Dios ta' ni jono kelen ma' ticwin chi jb'anic, xche' anjl re María. ");
INSERT INTO uspNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","María xij re anjl: Ini' rajchac Kakaj Dios ri Kajawl rane' chimb' chapca' ri xab'ij, xche' re anjl. Cuando María xijmaj jwi'l jilonli, anjl xk'ajb'ic. ");
INSERT INTO uspNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","La' mak k'ij li María laj or xe' li jun tilmit re Judea ri wi' lak q'uiche'laj. ");
INSERT INTO uspNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Cuando xtaw María laj richoch Zacarías xc'am rutzil jwich Elisabet. ");
INSERT INTO uspNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Cuando xta Elisabet nen mo jc'amic rutzil jwich xansaj jwi'l María, etke xsilib' ra ne' laj jsantil y xnojsaj ranm Elisabet la' Lok'laj Jsantil Kakaj Dios. ");
INSERT INTO uspNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Elisabet sub'laj cow xch'a'wc, xij re María: Kakaj Dios xya' jk'ab' chab' chiwchak juntir anm. Y xya' jk'ab' chib' ral awic'lal ri tiq'uisi'yc. ");
INSERT INTO uspNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","¿Nenc'u incholajl in, inyuk solaj jwi'l jchuch Wajawl? ");
INSERT INTO uspNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Cuando xinta xac'am rutzil inwch man ral inne' xsilib' laj jsantil jwi'l jqui'cotem. ");
INSERT INTO uspNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Tzi awe jwi'l xacoja' chi titawi' chiwch ri xijsaj chawe jwi'l Kakaj Dios ri Kajawl, xche' Elisabet re María. ");
INSERT INTO uspNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Xpe María, xij: Nojel wanm tannimirsaj jcojic jk'ij Kakaj Dios ri Kajawl ");
INSERT INTO uspNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","y sub'laj tiqui'cot insantil chirij Kakaj Dios ri ajcolol we, ");
INSERT INTO uspNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","jwi'l xrila' c'ur jwich rajchac ri ta' cojol jk'ij. Lajori juntir cristian tina jb'ijtakna chi tzi re, tina che'takna chwij. ");
INSERT INTO uspNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Kakaj Dios ri wi' sub'laj jcwinel, sub'laj kelen kus b'anal chwe jwi'l y sub'laj nim jk'ij jb'ij. ");
INSERT INTO uspNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Kakaj Dios ta' ni jun b'welt miti tril c'ur jwichak juntir cristian ri nojel ranmak ticojontak chiwch. ");
INSERT INTO uspNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","La' jcwinel Kakaj Dios xresaj jno'jak yak ri tijchomorsajtak laj ranmak chi nimaki' jk'ijak. ");
INSERT INTO uspNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Y la' jcwinel xresaj rekle'nak mak jb'ab'altak k'atb'itzij, xnimirsaj jk'ijak yak ri ta' tijcoj jk'ijak. ");
INSERT INTO uspNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Kakaj Dios xye'w tzitaklaj kelen rechak yak ri wi' wi'jal rechak y xij rechak mak b'iom chi tib'etak y ta' nen xye'b'i rechak. ");
INSERT INTO uspNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Kakaj Dios xt'owa' yak rijajl Israel ri xanowtak lawi' raj Kakaj Dios trantak. Xcuxtaji' jwi'l chi rilic c'ur jwichak ");
INSERT INTO uspNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","chapca' ri b'il jwi'l re Abraham pach juntir rijajl, xche' María re Elisabet. ");
INSERT INTO uspNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","María raj xwa'xi' uxib' ic' riq'ui Elisabet, ajruc're' xk'aj chicch laj richoch. ");
INSERT INTO uspNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Cuando xtaw k'ij xye' Dios re Elisabet, xq'uisi'y jun ra ric'lal winak. ");
INSERT INTO uspNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Cuando xtatak yak jc'ulja pach yak rech'elxic nen mo rilic c'ur jwich Elisabet xansaj jwi'l Kakaj Dios ri Kajawl, sub'laj xqui'cottak riq'ui Elisabet. ");
INSERT INTO uspNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Cuando xtz'akat waxakib' (8) k'ij jq'uisi'y ra ne', xcojtak retal jtio'jl y roj xcojtak jb'ij pi Zacarías chapca' jb'ij jkaj. ");
INSERT INTO uspNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Pero jchuch ra ne' ta' xye' luwar xcojsaj jb'ij pi jilonli, xij: Ma' ji'ta'lonli jb'ij tikacojwi', tikacoj jb'ij pi Juan, xche'. ");
INSERT INTO uspNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Rechak xijtak re Elisabet: Pero ta' ni jono rechak yak awech'elxic Juan jb'ij, xche'tak. ");
INSERT INTO uspNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Xantak retal re Zacarías la' jk'ab'ak chi jtz'onaj re nen jb'ij ra ne' tijcoj. ");
INSERT INTO uspNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Zacarías xtz'onaj jun kelen pire tijtz'ib'aj chiwch nen jb'ij ra ne' tijcojwi' y xtz'ib'aj chi Juan jb'ij ra ne' tijcoj. Y yak cristian xsaach jch'olak chi jtaic nen jb'ij ra ne' ticojsajwi'. ");
INSERT INTO uspNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Laj or xel jyolj Zacarías y xoc chi jb'ixaj jnimirsaj jk'ij Kakaj Dios. ");
INSERT INTO uspNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Y juntir yak jc'ulja sub'laj xsaach jch'olak chi rilic juntir ri xaanc. Y juntir luwar ri wi' lak q'uiche'laj re Judea xtatak jtaquil ri xaanc. ");
INSERT INTO uspNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Juntir ri xtatak jtaquil tijtz'onajtak chirib'il rib'ak: ¿Nen chiqui' tran ra ne' li cuando tiwinakirc? xche'tak. Jilonli tijb'ijtak chirij ra ne' jwi'l na'li' chi Kakaj Dios ri Kajawl ri wi' jcwinel xanow juntir li. ");
INSERT INTO uspNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Zacarías ri jkaj ra ne', xnojsaj ranm la' Lok'laj Jsantil Kakaj Dios, xk'asaj Jyolj Kakaj Dios, xij: ");
INSERT INTO uspNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","¡Nimirsajok jk'ij Kakaj Dios ri Kajawl ri jDiosak yak rijajl Israel, jwi'l xpeti' chi jcolic yak jwinak laj jk'ab' jmacak! ");
INSERT INTO uspNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Kakaj Dios xtakch jun ajcolol ke ri wi' sub'laj jcwinel ri rijajl David, ri rajchac Kakaj Dios. ");
INSERT INTO uspNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Ri ajcolol ke li, b'ilchakch jwi'lak yak ajk'asaltak Jyolj Kakaj Dios ojrtaktzij ri tosoltak re Kakaj Dios chi ri' re tipe wich ulew chi kacolic. ");
INSERT INTO uspNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","B'ili'ch ojrtaktzij jwi'l Kakaj Dios chi ojna jcolna laj jk'ab'ak yak ri ojcontrintak. Y ojna jcolna laj jk'ab'ak yak ri oj tijin ojjxuttak. ");
INSERT INTO uspNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Y b'ili'ch jwi'l Kakaj Dios chi trila' c'ur jwichak kamam katit' ojrtaktzij. Y Kakaj Dios ta' tisaach re ri jchomorsa'n ri b'anal jwi'l. ");
INSERT INTO uspNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Ri' ri xij Kakaj Dios re kamam Abraham ojrtaktzij, chi kes tz'et tina ranna. ");
INSERT INTO uspNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Xij chi ojna jcolna laj jk'ab'ak yak ri ojcontrintak pire ma' titzaak kach'ol chi jb'anic nen raj Kakaj Dios tikab'antak ");
INSERT INTO uspNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","y pire tran suc'ul kanm chiwch nojel k'ij laj kac'aslemal. ");
INSERT INTO uspNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Y at inc'ajol, tina b'ijsajna chawij chi ati' ajk'asal Jyolj Kakaj Dios lecj, jwi'l at atnab'er chiwch Kajawl chi jsuc'ulb'isaj jb'e. ");
INSERT INTO uspNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Y at tib'e ab'ij jtaquil rechak yak jwinak chi ticolmajtaka' laj jk'ab' jmacak jwi'l ticuysaji' jmacak jwi'l Kakaj Dios. ");
INSERT INTO uspNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Kakaj Dios jwi'l sub'laj tril c'ur kawch, tina jtaknach jun ajcolol ke laj jk'ab' kamac chapca' ajri' relicch k'ij ");
INSERT INTO uspNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","pire tijc'ut jb'eak yak ri wi'tak li uku'mal jwi'l jmacak. Re tijc'ut chikawch nen rajwax tikab'antak pire tiwa'x utzil laj kanm y chikaxo'l, xche' Zacarías. ");
INSERT INTO uspNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Ral ac'l li tijin tiq'uiy y tijin tretemaj mas jb'anic lawi' raj Kakaj Dios tran. Y xe' wa'xok li jun luwar lamas ta' cristian asta xtaw k'ij xoc chi jb'anic lawi' ri xtaksaj jwi'l Kakaj Dios chi jb'anic chijxo'lak yak rijajl Israel. ");
INSERT INTO uspNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","La' mak k'ij li, Augusto César ri jb'ab'al k'atb'itzij re Roma, xtak jb'ij lak juntir tilmit ri titakon chib' chi rajwaxi' tiesaj jtz'ib'alak juntir cristian. ");
INSERT INTO uspNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Y ri' nab'e b'welt li xesaj jtz'ib'alak cristian la' mak junab' cuando Cirenio wi' pire jb'ab'al k'atb'itzij re Siria. ");
INSERT INTO uspNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Jilonli juntir cristian xe' jye' jtz'ib'alak laj jtilmitak. ");
INSERT INTO uspNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Y jwi'li'li José ri rijajl David xelb'i Nazaret ri jun tilmit re Galilea, xe' Belén ri jun tilmit re Judea ri jtilmit David ");
INSERT INTO uspNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","chi jye'ic jtz'ib'alak pach María ri quiek riq'uil tina c'uli'yna y María yaj anmchak. ");
INSERT INTO uspNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Y wi'tak Belén cuando xtaw k'ij tijye' Dios re María. ");
INSERT INTO uspNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Y cla' xq'uisi'y nab'e ric'lal winak. Xpe María, xpis ra ne' li itz'ik y xtz'eb'a' li jun canow re ye'b'i jlo' awaj jwi'l ta' xta'tak jposadak li man b'amb'i posad. ");
INSERT INTO uspNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Wi' nic'j ajyuk' tik'asintak ak'ab' wich tak'j chi nakaj re tilmit Belén chi jchajaj jcarnerak. ");
INSERT INTO uspNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Etke xwab'a' rib' jun ranjl Kakaj Dios ri Kajawl chiwchak y xrepaj rib' jk'ak'al jnimal jk'ij Kakaj Dios chirijak y sub'laj xtzaak jch'olak. ");
INSERT INTO uspNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Xpe anjl, xij rechak: Mi tzaak ach'olak, in ximpet pirechi' tiyuk imb'ij tzilaj jtaquil chawechak chi xyuki' jun nimlaj qui'cotemal pire juntir cristian wich ulew. ");
INSERT INTO uspNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Lajori xq'uisi'yi' jun ajcolol awechak ri b'il jwi'l Kakaj Dios chi tina jtaknach wich ulew y ri' Kajawl. Ji' xq'uisi'y Belén laj jtilmit David. ");
INSERT INTO uspNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Cojtak retal nen mo jta'ic man ra ne' tab'antak, na'li' pisil li itz'ik y tz'eb'al jwi'l jchuch li jun canow re ye'b'i jlo' awaj, xche' anjl rechak yak ajyuk'. ");
INSERT INTO uspNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Cuando tijin anjl chi yoloj riq'uilak yak ajyuk', etke xyuktak chic nic'j anjl riq'ui anjl ri tijin tiyolow riq'uilak yak ajyuk', jpeticak lecj, xb'ixajtak jnimirsaj jk'ij Kakaj Dios y laj jb'ixak xijtak: ");
INSERT INTO uspNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","¡Nim jk'ij Kakaj Dios ri wi' chikab' lecj! ¡Tiye'saji' jun nimlaj utzil laj ranmak juntir cristian wich ulew ri tzi tiilsajtak jwi'l Kakaj Dios! xche'tak yak anjl. ");
INSERT INTO uspNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Cuando xk'ajtakb'i yak anjl lecj, xpetak yak ajyuk' xoctak chi jb'ij chirib'il rib'ak: Jo'tak Belén, jo' kile'tak nen xijsaj chike. Kakaj Diosi' ri Kajawl xtakowch jb'ij chike, xche'tak. ");
INSERT INTO uspNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Ajruc're' yak ajyuk' li laj or xe'tak y xe' jte'tak María pach José y ra ne' tz'eb'al li jun canow re ye'b'i jlo' awaj. ");
INSERT INTO uspNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Cuando yak ajyuk' xriltak ra ne', xoctak chi jyolic nen xijsaj rechak jwi'l anjl chirij ra ne'. ");
INSERT INTO uspNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Y juntir yak ri xtatak ri tijb'ijtak yak ajyuk', sub'laj xsaach jch'olak chi jtaic. ");
INSERT INTO uspNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","María xwa'xke laj ranm juntir ri xijsaj rechak y tike tijin tichomorsan chirij. ");
INSERT INTO uspNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Y yak ajyuk' cuando xk'ajtak tichak tijin tijb'ixajtak y tijin tijnimirsajtak jk'ij Kakaj Dios chi jc'omowaj re juntir ri xyuk jte'tak y xyuk rile'tak, jwi'l jilon xyuk jte'tak chapca' ri xijsaj rechak jwi'l anjl. ");
INSERT INTO uspNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Cuando xtz'akat waxakib' (8) k'ij jq'uisi'y ra ne' xcojsaj retal jtio'jl y xcojsaj jb'ij pi Jesús chapca' jb'ij ri xijsaj re María jwi'l anjl Gabriel cuando ajqui' chi ran yaj anm. ");
INSERT INTO uspNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Cuando xtz'akat mak k'ij pire tran ch'ajch'oj jwich María chapca' tijb'ij Jpixb' Kakaj Dios ri Kajawl xe'tak li nimi richoch Kakaj Dios pach José pire tib'e jache'tak Kakaj Jesús laj jk'ab' Kakaj Dios. ");
INSERT INTO uspNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Jilon xantak chapca' tz'ib'al li wuj re Jpixb' Kakaj Dios ri tijb'ij jilonri: Juntir mak tra nab'etak ac'l ri tiq'uisi'ytak, ri winaktak, titosajtaka' pire Kakaj Dios ri Kajawl, tiche'. ");
INSERT INTO uspNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Xe'tak chi jsujic mak tra ca'n re Kakaj Dios chapca' tijb'ij Jpixb' Kakaj Dios ri Kajawl. Tijc'amtakb'i quib' tra ixmucur o quib' tra k'un ut pire tijsujtak re Kakaj Dios ri Kajawl. ");
INSERT INTO uspNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","La' mak junab' li wi' jun ri'jlaj winak li tilmit Jerusalén, Simeón jb'ij. Simeón suc'uli' ranm chiwch Kakaj Dios. Re trana' juntir lawi' raj Kakaj Dios tran y tijin chi rulb'ej ajcolol rechak yak rijajl Israel. Simeón wi' Lok'laj Jsantil Kakaj Dios laj ranm. ");
INSERT INTO uspNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Lok'laj Jsantil Kakaj Dios xij re Simeón chi ta' ticam laj or, asta tina rilna tiyuk wich ulew jun ri b'il jwi'l Kakaj Dios ri Kajawl chi tina jtaknach wich ulew. ");
INSERT INTO uspNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Y sic' ri'jlaj winak li takalb'i jwi'l Lok'laj Jsantil Kakaj Dios xe' li nimi richoch Kakaj Dios. Y jkaj jchuch ra ne' xpetak li nimi richoch Kakaj Dios chi jjachic ra ne' laj jk'ab' Kakaj Dios chapca' tijb'ij Jpixb' Kakaj Dios. ");
INSERT INTO uspNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Xpe Simeón, xk'aluj ra ne' y jnimirsaj jk'ij Kakaj Dios, xij: ");
INSERT INTO uspNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Kaj, ye' luwar chwe incam pi utzil ri in awajchac, xwila' chapca' ri b'il chwe awi'l. ");
INSERT INTO uspNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Xwila' la' b'ak' inwch ri ajcolol ke laj jk'ab' kamac, ");
INSERT INTO uspNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","ri xawesaj chi sakil chiwchak juntir cristian wich ulew, ");
INSERT INTO uspNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","ri' re chapca' jun k'ak' pire tijc'ut jb'eak yak ma' rijajl ta' Israel y pire ticojsaj jk'ijak yak rijajl Israel, xche' Simeón. ");
INSERT INTO uspNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Jkaj jchuch ra ne' xsaach jch'olak chi jtaic nen tijb'ij Simeón chirij ra ne'. ");
INSERT INTO uspNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Xpe Simeón, xye' jk'ab' chib' y xtz'onaj re Kakaj Dios chi tijye' jk'ab' chib'ak y xij re María ri jchuch ra ne': Man ral ac'l ri, cha'li' pire tijq'uex jno'jak nic'j rechak yak rijajl Israel pire tijcojtak Jyolj Kakaj Dios y pire tijsach jwichak nic'j rechak mak ri ta' tijcojtak Jyolj Kakaj Dios. Jilonli tic'utun chi wi' tixutuwtak re ");
INSERT INTO uspNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","pire tiel chi sakil juntir jchomorsa'nak ri wi' laj ranmak. Juntir li pi awe at niq'ui' chapca' jun espad tioc laj awanm jwi'l jc'axc'ol awanm chirij, xche' Simeón re María. ");
INSERT INTO uspNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Y cla' wi' jun anm ajk'asal Jyolj Kakaj Dios ri jb'ij Ana. Ana jrab'ini' Fanuel ri rijajl Aser ri jun k'at re yak cab'lajuj (12) k'at re yak rijajl Israel. Anm li ri'jlaj cristianchak, xc'uli'yna cuando aj k'apoj anm, pero wukub' (7) junab'ke xc'am rib'ak pach richjil. ");
INSERT INTO uspNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Y sic' anm li ri camnak richjil wi'chak junmuch' riq'ui quejab' (84) junb'. Re jekeli' li nimi richoch Kakaj Dios, chi lak'j chi lak'ab' tijin tran lawi' raj Kakaj Dios tran la' ayun y ch'a'wem riq'ui Kakaj Dios. ");
INSERT INTO uspNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Cuando xq'uis jyolj Simeón, xpe Ana xjutun chijc'ulelak y xoc chi jc'omowaj re Kakaj Dios. Ajruc're' xoc chi yoloj chirij ra ne' rechak juntir yak rijajl Israel ri tijin trulb'ejtak chi ticolmaj Jerusalén. ");
INSERT INTO uspNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Cuando xantaj juntir li jwi'lak ri chapca' tijb'ij Jpixb' Kakaj Dios ri Kajawl, José pach María xk'ajtakb'i Galilea, xe'tak laj jtilmitak Nazaret. ");
INSERT INTO uspNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Y Kakaj Jesús tijin tiq'uiyc y tijin jyu'ic jcowil ranm y tijin jyu'ic mas jno'j y sub'laj rutzil ranm Kakaj Dios chirij. ");
INSERT INTO uspNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Jkaj jchuch Kakaj Jesús nojel junab' tib'etak Jerusalén chi jk'asaj nimak'ij Pascua. ");
INSERT INTO uspNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Cuando xtz'akat cab'lajuj (12) junb' Kakaj Jesús, xe'tak Jerusalén chi jk'asaj nimak'ij Pascua jwi'l jilon nak'tisajem rib'ak. ");
INSERT INTO uspNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Cuando xq'uis man nimak'ij li, xk'ajtak laj richochak. Pero Kakaj Jesús xcan resaj rib' li tilmit Jerusalén y jkaj jchuch ta' xriltak lamas xcanwi'. ");
INSERT INTO uspNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Chijch'ol rechak petzali' xo'lak jpachak ri xk'ajtakch li nimak'ij. Xe' jun k'ij jb'eak, ajruc're' xoctak chi jtoquic xo'lak yak rech'elxicak y xo'lak yak richc'ulchi'ak. ");
INSERT INTO uspNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Cuando xriltak chi ta' Kakaj Jesús chijxo'lak, xk'ajtakb'i chi jtoquic li tilmit Jerusalén. ");
INSERT INTO uspNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Laj jrox k'ij, ajruc're' xe' jte'tak Kakaj Jesús li nimi richoch Kakaj Dios cub'ul chijxo'lak yak ajtijoltak cristian re Jpixb' Kakaj Dios, tijin chi jtaic nen tijb'ijtak y tijin tijtz'onaj rechak nen mo jcholajl tielwi' ri tijin tijb'ijtak. ");
INSERT INTO uspNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Juntir mak ri xtatak nen tijb'ij Kakaj Jesús sub'laj xsaach jch'olak chi jtaic jwi'l re wi' mas jno'j y ticwin chi jc'ululaj lawi' ri tijtz'onajtak re. ");
INSERT INTO uspNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Y jkaj jchuch cuando xriltak jwich Kakaj Jesús sub'laj xsaach jch'olak. Y jchuch xij re: At walc'wal, ¿nen chac xab'an chike jilonri? In pach atat ocsalcoj il chi atoquic, xche' re. ");
INSERT INTO uspNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Kakaj Jesús xtz'onaj rechak: ¿Nen tatoctak chwe? ¿Ta'c'u awetamak chi in tina imb'anna ri b'ilch chwe jwi'l Inkaj? xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Pero rechak ta' xmajtak jcholajl nen tielwi' ri xij Kakaj Jesús rechak. ");
INSERT INTO uspNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Ajruc're' xe' chic Kakaj Jesús chirijak jkaj jchuch, xk'ajtakb'i Nazaret. Nojel k'ij sub'laj ticojon chiwchak. Pero jchuch ta' tiel laj ranm juntir ri xan. ");
INSERT INTO uspNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Kakaj Jesús tijin tiq'uiyc y tijin jyu'ic mas jno'j. Sub'laj tzi tiilsaj jwi'l Kakaj Dios y jwi'lak cristian. ");
INSERT INTO uspNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Cuando xtz'akat jo'lajuj (15) junab' roquic Tiberio César pire jb'ab'al k'atb'itzij re Roma, Poncio Pilato wi' pire jb'ab'al k'atb'itzij re Judea. Y Herodes Antipas wi' pire rey re Galilea y Herodes Felipe ri jk'un Herodes Antipas wi' pire rey re Iturea pach Traconite y Lisanias wi' pire rey re Abilinia, ");
INSERT INTO uspNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","y Anás pach Caifás ri'taka' mak nimaktak jb'ab'alak yak ajc'amaltak jb'eak cristian riq'ui Kakaj Dios. La' mak junab' li Kakaj Dios xch'ab'ej Juan Ajb'anal Ja'tiox ri jc'ajol Zacarías li jun luwar lamas ta' cristian. ");
INSERT INTO uspNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Y ajruc're' Juan xk'ax la' juntir mak luwar ri wi' chi' nimi ja' Jordán, xij re juntir cristian chi tijq'uex jno'jak pire ticuysaj juntir jmacak jwi'l Kakaj Dios y tib'ansaj ja'tiox rechak. ");
INSERT INTO uspNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Jilon xan chapca' xcan jtz'ib'aj Isaías ri ajk'asal Jyolj Kakaj Dios, ri tijb'ij chi tina tasajna jun ri cow tich'ejej li jun luwar lamas ta' cristian, tijb'ij: B'antak jwa'x jb'e Kakaj Jesús ri Kajawl, teb'a'tak jb'e suc'ul laj awanmak. ");
INSERT INTO uspNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Juntir mak xo'lak witz tina nojsajna y juntir mak b'ak witz tina kesajna y tib'an tak'j re, juntir mak cotot b'e tina b'anna suc'ul re y juntir mak b'e ri ta' tiq'uilc, tina b'anna tiq'uil re. ");
INSERT INTO uspNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Y juntir cristian wich ulew tina riltakna ri ajcolol rechak laj jk'ab' jmacak ri tijtakch Kakaj Dios wich ulew, tiche'. ");
INSERT INTO uspNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Y Juan Ajb'anal Ja'tiox xril xtawtak mak cristian riq'uil pire tib'ansaj ja'tiox rechak, xij rechak: Atak, pur atak cumatz ri ticamsanc. Ta' nen xin chawechak chi atcolmajtaka' chiwch jk'atb'itzij Kakaj Dios ri tina ranna jwi'l retzal. ");
INSERT INTO uspNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","B'antak tzitaklaj no'j laj ac'aslemalak pire tic'utun chi kes tz'et xaq'uexa' ano'jak y xac'ama' jk'ab'al amacak chiwch Kakaj Dios y ma chomorsaj laj awanmak chi atcolmajtaka' jwi'l ataka' rijajl Abraham. Jwi'l in tamb'ij chawechak chi Kakaj Dios ticwini' chi tiwux mak ab'aj ri pi rijajl Abraham. ");
INSERT INTO uspNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Man iquej wi'chak laj ra' mak che' pire tic'ursajtakb'ic. Juntir mak che' ri ta' tzi tiwichintak, tic'ursajtaka'n y tit'ojsajtaka' li k'ak', xche' Juan rechak. ");
INSERT INTO uspNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Xpe yak cristian, xtz'onajtak re Juan Ajb'anal Ja'tiox: ¿Nenc'u rajwax tikab'an? xche'tak re. ");
INSERT INTO uspNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Juan Ajb'anal Ja'tiox xij rechak: Nen wi' quib' jtúnica, rajwaxi' tina jye'na jun re nen ri ta' ritz'ik. Y nen wi' jwa rajwaxi' tina jcomonajna jtijic pach nen ri ta' jwa, xche' Juan Ajb'anal Ja'tiox rechak. ");
INSERT INTO uspNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Y wi' nic'j ajtz'onaltak alcabar xe'tak riq'ui Juan Ajb'anal Ja'tiox pire tib'ansaj ja'tiox rechak. Y xtz'onajtak re nen rajwax trantak: Ajtijonl, ¿nen rajwax tikab'an oj? xche'tak re. ");
INSERT INTO uspNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Re xij rechak: Ma tz'onajtak mas pakal rijil alcabar, xike tatz'onajtak chapca' ri b'il chawechak, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Y nic'j soldad xtz'onajtak re Juan Ajb'anal Ja'tiox nen rajwax trantak: Y oj, ¿nen rajwax tikab'an? xche'tak. Re xij rechak: Ma b'antak alak'tak pwak chirij jun cristian, ma b'antak c'ax rechak, ma moltak tzij chirij cristian chi resaj pwak chirijak. Xike cub'a' ach'olak chirij nen jnimal tach'ectak, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Juntir cristian tijintak chi jchomorsaj laj ranmak chi Juan Ajb'anal Ja'tiox pent ri' ri b'il jwi'l Kakaj Dios chi tina jtaknach wich ulew. ");
INSERT INTO uspNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Pero Juan Ajb'anal Ja'tiox xij rechak: Kes tz'etel tz'et tamb'ij chawechak, in la' ja' tamb'an ja'tiox chawechak. Pero wi' chiqui' jun chic petzal chwij in, re masna jcwinel chinwch in y ta' tic'ular pi we tanquir jxajb'. Re tina ranna ja'tiox chawechak la' Lok'laj Jsantil Kakaj Dios y la' k'ak'. ");
INSERT INTO uspNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Re c'amali'ch jun kelen laj jk'ab' jwi'l ri quiek la' tijpu'w jwich trig y tijtos mak rakan ri tiel chijxo'l. Tijc'ol man trig li c'uja, pero mak rakan ri tiel chijxo'l tijc'at li jun k'ak' ri ta' jchupic. ");
INSERT INTO uspNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Jilonli xij Juan Ajb'anal Ja'tiox chi jye'ic jno'jak juntir cristian chirij tzilaj jtaquil chirij Kakaj Jesucristo li jun luwar lamas ta' cristian. ");
INSERT INTO uspNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Y chiwchak juntir cristian xk'el man rey Herodes Antipas jwi'l xc'uli'y riq'ui Herodías ri rixokl jk'un. Y xk'el chirij juntir mak etzltak no'j ri b'anal jwi'l. ");
INSERT INTO uspNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Pero Herodes Antipas xye' chic mas jb'a mak jmac ri b'anal jwi'l, xcoj Juan Ajb'anal Ja'tiox li cars. ");
INSERT INTO uspNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Cuando Juan Ajb'anal Ja'tiox tijin chi jb'anic ja'tiox rechak cristian, xan ja'tiox re Kakaj Jesús, Kakaj Jesús tijin chi ch'a'wem riq'ui Kakaj Dios cuando xtormaj caj ");
INSERT INTO uspNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","y xkejch Lok'laj Jsantil Kakaj Dios chib' chapca' rilic jun ra ut. Y xtasaj jun ch'a'wem xaanch lecj, xijch: Ati' ri Lok'laj Inc'ajol, sub'laj inqui'cot chawij, xche'ch lecj. ");
INSERT INTO uspNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Kakaj Jesús raj wi'chak junwinak lajuj (30) junb' cuando xchol jb'anic lawi' raj Kakaj Dios tran. Cristian tijb'ijtak chirij chi jc'ajoli' José, José jc'ajoli' Elí, ");
INSERT INTO uspNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Elí jc'ajoli' Matat, Matat jc'ajoli' Leví, Leví jc'ajoli' Melqui, Melqui jc'ajoli' Jana, Jana jc'ajoli' José, ");
INSERT INTO uspNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","José jc'ajoli' Matatías, Matatías jc'ajoli' Amós, Amós jc'ajoli' Nahúm, Nahúm jc'ajoli' Esli, Esli jc'ajoli' Nagai, ");
INSERT INTO uspNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai jc'ajoli' Máat, Máat jc'ajoli' Matatías, Matatías jc'ajoli' Semei, Semei jc'ajoli' Josec, Josec jc'ajoli' Judá, ");
INSERT INTO uspNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Judá jc'ajoli' Joanán, Joanán jc'ajoli' Resa, Resa jc'ajoli' Zorobabel, Zorobabel jc'ajoli' Salatiel, Salatiel jc'ajoli' Neri, ");
INSERT INTO uspNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri jc'ajoli' Melqui, Melqui jc'ajoli' Adi, Adi jc'ajoli' Cosam, Cosam jc'ajoli' Elmodam, Elmodam jc'ajoli' Er, ");
INSERT INTO uspNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er jc'ajoli' Josué, Josué jc'ajoli' Eliezer, Eliezer jc'ajoli' Jorim, Jorim jc'ajoli' Matat, Matat jc'ajoli' Leví, ");
INSERT INTO uspNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Leví jc'ajoli' Simeón, Simeón jc'ajoli' Judá, Judá jc'ajoli' José, José jc'ajoli' Jonám, Jonám jc'ajoli' Eliaquim, ");
INSERT INTO uspNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliaquim jc'ajoli' Melea, Melea jc'ajoli' Mainán, Mainán jc'ajoli' Matata, Matata jc'ajoli' Natán, Natán jc'ajoli' David, ");
INSERT INTO uspNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","David jc'ajoli' Isaí, Isaí jc'ajoli' Obed, Obed jc'ajoli' Booz, Booz jc'ajoli' Salmón, Salmón jc'ajoli' Naasón, ");
INSERT INTO uspNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Naasón jc'ajoli' Aminadab, Aminadab jc'ajoli' Aram, Aram jc'ajoli' Esrom, Esrom jc'ajoli' Fares, Fares jc'ajoli' Judá, ");
INSERT INTO uspNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Judá jc'ajoli' Jacob, Jacob jc'ajoli' Isaac, Isaac jc'ajoli' Abraham, Abraham jc'ajoli' Taré, Taré jc'ajoli' Nacor, ");
INSERT INTO uspNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nacor jc'ajoli' Serug, Serug jc'ajoli' Ragau, Ragau jc'ajoli' Peleg, Peleg jc'ajoli' Heber, Heber jc'ajoli' Sala, ");
INSERT INTO uspNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sala jc'ajoli' Cainán, Cainán jc'ajoli' Arfaxad, Arfaxad jc'ajoli' Sem, Sem jc'ajoli' Noé, Noé jc'ajoli' Lamec, ");
INSERT INTO uspNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamec jc'ajoli' Matusalén, Matusalén jc'ajoli' Enoc, Enoc jc'ajoli' Jared, Jared jc'ajoli' Mahalaleel, Mahalaleel jc'ajoli' Cainán, ");
INSERT INTO uspNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Cainán jc'ajoli' Enós, Enós jc'ajoli' Set, Set jc'ajoli' Adán y Adán jc'ajoli' Kakaj Dios. ");
INSERT INTO uspNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Kakaj Jesús nojsalchak ranm la' Lok'laj Jsantil Kakaj Dios, xelch li nimi ja' Jordán. Y xc'amsajb'i jwi'l Lok'laj Jsantil Kakaj Dios li jun luwar lamas ta' cristian. ");
INSERT INTO uspNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Cla' xwa'x ca'winak (40) k'ij, xtakchi'j chi macun jwi'l man jb'ab'al etzl y la' mak k'ij li ta' nen xtij. Cuando xk'ax ca'winak (40) k'ij li, ajruc're' xric'aj wi'jal. ");
INSERT INTO uspNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Xpe man jb'ab'al etzl, xtakchi'j Kakaj Jesús chi macunc, xij re: Wi kes tz'et ati' Jc'ajol Kakaj Dios, b'ij re man ab'aj ri chi tiwux pi cuxlanwa, xche' re. ");
INSERT INTO uspNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Kakaj Jesús xij re man jb'ab'al etzl: Tz'ib'ali' li wuj re Lok'laj Jyolj Kakaj Dios jilonri: Ma' jwi'l ta'ke cuxlanwa tiyo'rwi' jun cristian, tiche', xche' re. ");
INSERT INTO uspNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Y ajruc're' man jb'ab'al etzl xc'amb'i Kakaj Jesús b'a jun witz sub'laj naj rak'aneb' y laj or xc'ut juntir mak tilmit chiwch ri wi' wich ulew. ");
INSERT INTO uspNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Y xij re: In tanjacha' laj ak'b' juntir mak tilmit li y juntir mak kustaklaj kelen ri wi' chiwch, jwi'l juntir li jachali' laj ink'b' y tanya' re nen quiek re chwaj tanye'w. ");
INSERT INTO uspNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Wi atxucar chinwch y tacoj ink'ij, tanjacha' juntir li laj ak'b', xche' re. ");
INSERT INTO uspNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Kakaj Jesús xij re man jb'ab'al etzl: Tz'ib'ali' li wuj re Lok'laj Jyolj Kakaj Dios jilonri: Nimirsaj jk'ij Akaj Dios ri Awajawl y xike rajwax tab'an lawi' raj re tab'an, tiche', xche' Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Man jb'ab'al etzl xc'am chicb'i Kakaj Jesús Jerusalén, xe' jwab'a' li man luwar mas naj rak'aneb' re nimi richoch Kakaj Dios, xij re: Wi kes tz'et ati' Jc'ajol Kakaj Dios, t'ojb'i ayb' neri atb'e kej lak ulew, ");
INSERT INTO uspNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","jwi'l tz'ib'ali' li wuj re Lok'laj Jyolj Kakaj Dios ri tijb'ij jilonri: Kakaj Dios tijtaka'ch yak anjl chi at'o'ic. ");
INSERT INTO uspNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Y rechak atjc'ula'taka' la' jk'ab'ak pire ma' tib'e ach'i'ye' awakan la' jun ab'aj, tiche', xche' man jb'ab'al etzl re Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Kakaj Jesús xij chic re: Tz'ib'ali' li wuj re Lok'laj Jyolj Kakaj Dios ri tijb'ij jilonri: Ma tz'onaj re Akaj Dios ri Awajawl chi tran jun kelen pireke tawil wi kes tz'eti' tran ri tijb'ij, tiche', xche' re. ");
INSERT INTO uspNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Cuando xril man jb'ab'al etzl chi ta' chiqui' xta' ni jono no'j chic nen tran chi jtakchi'j Kakaj Jesús chi macunc, xelb'ic, xcan jye' jch'ab'ej Kakaj Jesús asta la' jun k'ij chic ri chijch'ol re ticwin chi jtakchi'j. ");
INSERT INTO uspNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Kakaj Jesús wi' jcwinel Lok'laj Jsantil Kakaj Dios laj ranm, xk'aj chic Galilea y juntir cristian lak juntir luwar re Galilea tijin tiyolowtak chirij Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Y Kakaj Jesús xoc chi jtijojcak juntir cristian re Jyolj Kakaj Dios lak sinagog re juntir tilmit y juntir cristian ri wi'tak cla' xnimirsajtak jk'ij Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Kakaj Jesús xe' Nazaret ri man tilmit lamas xq'uiywi'ch. La' k'ij re uxlan xoc li sinagog jwi'l nak'tali' jilon tran. Xwa'r pire tioc chi rilic jwich wuj re Jyolj Kakaj Dios chiwchak. ");
INSERT INTO uspNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Xjachsaj man b'otom wuj laj jk'ab' Kakaj Jesús ri xcan jtz'ib'aj Isaías ri ajk'asal Jyolj Kakaj Dios y cuando xquir jwich xe' jte' man luwar lamas tijb'ijwi' jilonri: ");
INSERT INTO uspNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Wi' Lok'laj Jsantil Kakaj Dios ri Kajawl laj wanm jwi'l cha'lquini' jwi'l pire tamb'ij tzilaj jtaquil rechak juntir ri wi' rajwax rechak. Takalquin chi jtakicak yak prexb', chi jtzib'saj b'ak' jwichak yak moy, chi jresajcak yak cristian ri wi'tak laj jk'ab' c'ax ");
INSERT INTO uspNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","y chi jb'ij jtaquil chi xtawi' man junab' chi tijye' rutzil ranm Kakaj Dios ri Kajawl rechak juntir cristian wich ulew, tiche', ri xril Kakaj Jesús wich man b'otom wuj. ");
INSERT INTO uspNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Xpe Kakaj Jesús, xb'ot chic jwich wuj re Lok'laj Jyolj Kakaj Dios y xk'asaj chic laj jk'ab' man ajt'o'ol man jb'ab'al man k'at ri tijmulb'a' rib'ak li sinagog y xcub'arc. Cow tiilsaj jwi'lak juntir cristian ri wi'tak cla'. ");
INSERT INTO uspNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Kakaj Jesús xij rechak: Lajori xtawi' chiwch ri quiek chirij tz'ib'al li wuj re Lok'laj Jyolj Kakaj Dios y lajori wi' aac'lak, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Juntir cristian tib'intak chirij Kakaj Jesús chi pi jcholajli' tijb'ij y sachal jch'olak chi jtaic juntir ri tijin tib'ijsaj rechak jwi'l Kakaj Jesús. Y xijtak chirib'il rib'ak: Re ri' jc'ajol José, xche'tak. ");
INSERT INTO uspNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Kakaj Jesús xij rechak: In kes tz'et tamb'ij chawechak chi atak li tab'ijtaka' man tzij ri chwij jilonri: Ajcun, cunaj ayb' awic'an, b'anneca' laj atilmit juntir ri tal kawi'l ri xab'an Capernaúm, atche'taka' li chwij, xche'. ");
INSERT INTO uspNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Y xij chic rechak: Kes tz'etel tz'et tamb'ij chawechak chi ni jono ajk'asal Jyolj Kakaj Dios tzi jc'ulic tib'an laj jtilmit. ");
INSERT INTO uspNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Tz'eti'n, jilon chapca' xaan ojr la' mak junab' cuando xwa'x Elías ri ajk'asal Jyolj Kakaj Dios, cuando ta' xan jab' uxib' junab' riq'ui pajnic'j y xan sub'laj wi'jal lak juntir luwar re Israel. Wi' sub'laj anm ri camnak richjilak Israel, ");
INSERT INTO uspNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","pero Elías ta' xtaksaj laj richoch jono rechak yak anm li chi jt'o'icak, xike xtaksajb'i laj richoch jun anm ri camnak richjil ri wi' Sarepta chijc'ulel Sidón. ");
INSERT INTO uspNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Y jilon chapca' xaan la' mak junab' cuando xwa'x Eliseo ri ajk'asal Jyolj Kakaj Dios, wi' sub'laj q'ui cristian yajtak Israel re man yajel ri jb'ij lepra, pero ta' ni jono rechak xcunajc, xike xcunaj jun winak ri jb'ij Naamán ri tipe Siria, xche' Kakaj Jesús rechak. ");
INSERT INTO uspNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Juntir yak cristian ri wi'tak li sinagog, cuando xtatak chi jilonli xijsaj rechak, sub'laj xpe retzalak. ");
INSERT INTO uspNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Laj or xresajtakb'i Kakaj Jesús li tilmit, xc'amtakb'i chi' witz re man tilmit pire tijt'ojtakb'i wich witz, jwi'l man tilmit li ji' wi' b'a witz. ");
INSERT INTO uspNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Pero Kakaj Jesús xk'axb'i laj xo'lak, xelb'ic. ");
INSERT INTO uspNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Kakaj Jesús, xe' Capernaúm ri jun tilmit re Galilea y la' k'ij re uxlan xoc chi jtijojcak cristian cla'. ");
INSERT INTO uspNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Cristian sub'laj xsaach jch'olak chi jtaic jtijonc, jwi'l wi' mas jtakon chi tijonc. ");
INSERT INTO uspNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Li sinagog wi' jun winak ri wi' jun etzl laj ranm, man etzl cow xch'ejejc, xij: ");
INSERT INTO uspNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","¡Nen ma b'an chike Kaj Jesús aj Nazaret! Wetami' chi at tosolcati' jwi'l Kakaj Dios pire re y chi jb'aniqui' c'ax chike xatpetc, xche' re Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Kakaj Jesús xk'el man etzl ri wi' laj ranm man winak, xij re: ¡Tz'apij xa'w! ¡Elamb'i laj ranm winak ri! xche' re. Ajruc're' man etzl xtzak sic' winak lak ulew chijxo'lak juntir cristian y xelb'i laj ranm y ta' xan c'ax re sic' winak. ");
INSERT INTO uspNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Juntir cristian xsaach jch'olak. Xoctak chi jtz'onaj chirib'il rib'ak: ¿Nen chiqui' jcholajl jyolj winak ri? Wi' k'atb'itzij laj jk'ab' pire titakon chib'ak mak etzl y mak etzl ticojontaka' chiwch, xche'tak. ");
INSERT INTO uspNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Juntir mak luwar ri wi'tak chi nakaj re Capernaúm xta'taka' jtaquil juntir ri xan Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Kakaj Jesús xel chicb'i li sinagog, xe' laj richoch Simón Pedro. Y sic' anm ri jji' Simón Pedro wi' sub'laj k'ak' chirij. Xpetak, xtz'onajtak tok'ob' re Kakaj Jesús chi tijtzib'saj sic' anm li. ");
INSERT INTO uspNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Kakaj Jesús xtacb'a' jb'a chib' sic' anm y xk'el man k'ak' chirij. Jilonli xel k'ak' chirij sic' anm li y laj or xb'iitc, xoc chi jtzukicak. ");
INSERT INTO uspNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Cuando xoc may, mak cristian xc'amtakb'i yak yaj re jaljojtak yajel riq'ui Kakaj Jesús. Y re xye' jk'ab' chib'ak chi jujunalak yak cristian ri yajtak y xtzib'sajtak. ");
INSERT INTO uspNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Sub'laj cristian xresaj etzl laj ranmak. Y mak etzl li ri xeltak laj ranmak mak cristian xch'ejejtak, xijtak: ¡Ati' Jc'ajol Kakaj Dios! xche'tak. Pero Kakaj Jesús xk'el mak etzl, ta' xye' luwar rechak xch'a'wtak jwi'l retamaki' chi re ri' ri b'il jwi'l Kakaj Dios chi tina jtaknach wich ulew. ");
INSERT INTO uspNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Cuando xsakarsanc, Kakaj Jesús xelb'i Capernaúm. Xe' li jun luwar ric'an lamas ta' cristian. Pero yak cristian xoctak chi jtoquic, cuando xe' jte'tak, xijtak re chi ta' tielb'i chijxo'lak, ");
INSERT INTO uspNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","pero Kakaj Jesús xij rechak: Inna b'ena chi jb'ij tzilaj jtaquil chirij jtakon Kakaj Dios rechak cristian li jalan tilmit chic pire tretemajtak nen mo titakon Kakaj Dios chib'ak. Ri' ri quiek jwi'l xintaksajch jwi'l Kakaj Dios wich ulew, xche' Kakaj Jesús rechak yak cristian. ");
INSERT INTO uspNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Y jilonli xan Kakaj Jesús chi jtijojcak cristian lak sinagog lak juntir luwar re Galilea. ");
INSERT INTO uspNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Jun k'ij cuando Kakaj Jesús wi' chi' nimlaj alagun ri jb'ij Genesaret, sub'laj cristian xmulb'a' rib'ak cla' y sub'laj latz'chakwi' Kakaj Jesús jwi'l rajak tijtatak Jyolj Kakaj Dios ri tijin tijb'ij. ");
INSERT INTO uspNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Kakaj Jesús xrilb'i quib' barc canal chi' nimlaj alagun jwi'lak yak ajchapaltak car, jwi'l rechak tijin tijch'aj jc'aatak re chapb'i car. ");
INSERT INTO uspNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Kakaj Jesús xjaw li man jbarc Simón y xij re chi tijjutunsajb'i junquitz man barc li ja'. Ajruc're' Kakaj Jesús xcub'arc, xoc chi jtijoj mak cristian. ");
INSERT INTO uspNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Y cuando xmay jtijojcak cristian, xij re Simón: C'amb'i man abarc li jono luwar re man nimlaj alagun ri naj jpam y t'oj mak ac'aatak re chapb'i car xilj, xche' re. ");
INSERT INTO uspNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simón xij re: Ajtijonl, jun ak'ab' xojk'asin chi chapoj car y ni jonok xkachap. Pero lajori jwi'l at atb'inc, tant'oj chic mak c'aat li ja', xche'. ");
INSERT INTO uspNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Xt'ojtak chic mak jc'aatak li ja' y cuando xoctak chi resaj ta' chiqui' ticwintak chi resajc, mak jc'aatak tichak tijin tik'atzmaj jwi'l ralal sub'laj car xelch. ");
INSERT INTO uspNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Jwi'li'li Simón pach mak jpach xsiq'uijtakb'i la' jk'ab'ak yak nic'j jpachak chic ri wi'tak li man jun barc chic pire tiyuk t'o'sajtak chi resaj mak car. Cuando xtawtak mak nic'j riq'ui man barc xoctak chi resaj mak car li mak c'aat. Xnojsajtak chi quib' barc chi car y tichak tijin tikej mak barc ralaj ja' jwi'l ralal sub'laj car. ");
INSERT INTO uspNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Cuando xril Simón Pedro chi jilonli, xxucar chiwch Kakaj Jesús y xij re: Wajawl, b'an tok'ob', elan chinc'ulel jwi'l in, ini' jun ajmac, xche'. ");
INSERT INTO uspNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Jilonli xij Simón jwi'l jsachic jch'olak pach yak jpach chi rilic sub'laj car ri xresajtak. ");
INSERT INTO uspNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Y jilon Jacob pach Juan ri yak jc'ajol Zebedeo ri yak jpach Simón, sub'laj xsaach jch'olak. Pero Kakaj Jesús xij re Simón: Mi tzaak ach'ol, lajori atoc chi jtoquic cristian pire tioctak laj jk'ab' Kakaj Dios chapca' jchapic car, xche' re. ");
INSERT INTO uspNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Rechak xc'amtakb'i mak barc. Cuando xtawtak chi' nimlaj alagun xcan jye'tak mak barc cla' pach juntir kelen rechak y xe'tak chirij Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Li jun k'ij cuando wi' Kakaj Jesús li jun tilmit, xpe jun winak ri wi' yajel chirij ri jb'ij lepra. Sic' winak li cuando xril jwich Kakaj Jesús, xxucar chiwch y xxulb'a' jcayb'al asta xtaw chi' jwich lak ulew chi jtz'onaj tok'ob' re Kakaj Jesús: Kaj, wi jilon chawaj, atcwini' chi intzib'saj, xche' re. ");
INSERT INTO uspNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Xpe Kakaj Jesús, xye' jk'ab' chib', xij re: Chwaji'n, cattzib'ok, xche' re. Y laj or xel man yajel chirij sic' winak. ");
INSERT INTO uspNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Kakaj Jesús xij re: Ma yolow re jono cristian nen xattzib'sanc. Jat y c'utta chiwch man ajc'amal jb'eak cristian riq'ui Kakaj Dios y c'amb'i man sipan pire tib'e asuje' re Kakaj Dios chapca' tijb'ij Jpixb' Kakaj Dios, ri' li c'utb'ire chiwchak juntir cristian chi xattzib'i'n, xche' Kakaj Jesús re. ");
INSERT INTO uspNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Pero ri tijin tran Kakaj Jesús, tijin tiel mas jtaquil. Y sub'laj cristian nak tijmulb'a' rib'ak chi jtaic jyolj y ri' rajak titzib'sajtak re jyajak, ");
INSERT INTO uspNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","pero Kakaj Jesús tieli'b'i chi ch'a'wem riq'ui Kakaj Dios ric'an lak luwar lamas ta' cristian. ");
INSERT INTO uspNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Li jun k'ij cuando Kakaj Jesús tijin chi jtijoj cristian re Jyolj Kakaj Dios, wi' nic'j fariseo cub'umantak cla' pach yak ajtijoltak cristian re Jpixb' Kakaj Dios ri tipetak li mak tilmit re Galilea, re Judea y re Jerusalén. Y jcwinel Kakaj Dios ri Kajawl wi' riq'ui Kakaj Jesús pire tijtzib'saj cristian ri yajtak. ");
INSERT INTO uspNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Y xtawtak nic'j winak, c'amalb'i jun winak jwi'lak b'a jun ch'atum che', siquirnak juntir jtio'jl y rechak rajak tijcojtak la ja pire tib'e jye'tak chiwch Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Pero ta' xta'tak lamas tioctak jwi'l sub'laj cristian. Jwi'li'li xjawtak chib' man ja y xtortak junquitz mak xoot b'a ja laj jsuc'lal lamas wi' Kakaj Jesús y cla' xkesajtakwi'ch sic' yaj b'a jch'atum che' asta xtaw lak ulew chiwch Kakaj Jesús xo'lak cristian. ");
INSERT INTO uspNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Cuando xril Kakaj Jesús chi cub'uli' jch'olak chirij, xij re sic' winak ri yaj: At wichc'ulchi', amac xcuymaji'n, xche' re. ");
INSERT INTO uspNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Yak ajtijoltak cristian re Jpixb' Kakaj Dios pach mak fariseo xoctak chi jchomorsaj laj ranmak, xijtak: ¿Nen chiqui' jb'anic ri, man winak ri tijin tijcoj rib' pi Kakaj Dios? Ta' ni jun cristian ticwin chi jcuyic mac, xike Kakaj Dios, xche'tak. ");
INSERT INTO uspNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Pero Kakaj Jesús retami' nen tijin tijchomorsaj laj ranmak xtz'onaj rechak: ¿Nen chac tijin tachomorsaj laj awanmak jilonli? ");
INSERT INTO uspNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","¿Lac'umas wi' ri c'ax jb'ij re sic' yaj ri, amac xcuysaji'n o ri' mas c'ax jb'ij re: B'iiten y wo'coten? ");
INSERT INTO uspNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Pero in tanc'ut chawchak chi Jc'ajol Kakaj Dios ri xwux pi cristianil wi' k'atb'itzij laj jk'ab' chi jcuyic mac neri wich ulew, xche' rechak. Ajruc're' xij chic re sic' yaj ri siquirnak juntir jtio'jl: Tamb'ij chawe at, b'iiten, c'amb'i ach'atum che' y jat laj awichoch, xche' re. ");
INSERT INTO uspNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Y sic' winak ri yaj xb'iit chiwchak. Xc'amb'i jch'atum che' ri quiek chib' tz'e'lwi', xe' laj richoch, tichak tijin chi jnimirsaj jk'ij Kakaj Dios. ");
INSERT INTO uspNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Juntir cristian sub'laj xsaach jch'olak chi rilic y xoctak chi jnimirsaj jk'ij Kakaj Dios. Sub'laj tzakal jch'olak, xijtak: ¡Lajori tijin tikiltak kelen ri sachom ch'olal rilic! xche'tak. ");
INSERT INTO uspNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Cuando xantaj li, xelb'i Kakaj Jesús y k'axem tran xril jun ajtz'onal alcabar ri jb'ij Leví, cub'ul chi' mex lamas titojsaj alcabar y xij re: Jo' chwij, xche' re. ");
INSERT INTO uspNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Leví xwa'rc, xcan jye' juntir mak kelen cla' y xe' chirij Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Y Leví xan jun nimlaj comon wic' laj richoch pire Kakaj Jesús. Y li man nimlaj comon wic' li sub'laj q'ui ajtz'onaltak alcabar xtawtak cla' pach nic'j cristian chic. ");
INSERT INTO uspNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Pero mak fariseo pach yak ajtijoltak cristian re Jpixb' Kakaj Dios ri ri'taka' jun chijxo'lak mak fariseo xoctak chi jyajic yak ajtijol rib'ak chirij Kakaj Jesucristo, xijtak rechak: ¿Nen chac atak atwi'ntak y atuc'a'jantak chijxo'lak mak ajtz'onaltak alcabar pach mak ajmacb'? xche'tak rechak. ");
INSERT INTO uspNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Kakaj Jesús xij rechak: Ta' rajwax ajcun rechak yak cristian ri ta' yajtak, ri' rajwax ajcun pi rechak yak ri yajtak. ");
INSERT INTO uspNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","In ma' ri' ta' ximpe chi jtoquicak yak ri suc'ul ranmak chiwch Kakaj Dios, in ri' ximpe chi jtoquic yak ajmacb', xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Rechak xtz'onajtak re Kakaj Jesús: ¿Nen chac yak ajtijol rib'ak chirij Juan Ajb'anal Ja'tiox pach mak ajtijol rib'ak chirijak mak fariseo, q'uilaj b'welt trantak ayun, pero yak ajtijol rib'ak chawij tiwi'ntaka'n y tiuc'a'jantaka'n? xche'tak re Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Kakaj Jesús xij rechak: Yak cristian ri b'il rechak chi tib'etak li jun tz'am, ta' tijna' tib'isontak cuando ajwi' chijxo'lak man cojol winak ri tic'uli'yc. ");
INSERT INTO uspNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Pero cuando titaw k'ij tic'amsajb'i man c'ojol winak chiwchak, ajruc're' trantak ayun, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Y Kakaj Jesús xij chic jun esb'i no'j rechak jilonri: Ta' ni jun cristian tijrech' jun q'uer aac' itz'ik pire tijc'ojaj jun tzay la' y wi jilon tran li, trana' c'ax re juntir man aac' itz'ik y man aac' c'ojb'l ta' tzi tican la' man tzay itz'ik. ");
INSERT INTO uspNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Ni ta' tijna' tiye'saj aac' vin lak tzaytak nejb' ri b'anal la' tz'um, jwi'l man aac' vin tijrech'a' mak tzaytak nejb' ri b'anal la' tz'um, jilonli titixi' man aac' vin y trana' c'ax mak nejb'. ");
INSERT INTO uspNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Jwi'li'li man aac' vin rajwaxi' lak aac'tak nejb' ri b'anal la' tz'um tiye'saj. ");
INSERT INTO uspNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Y ta' ni jono cristian tijtij nab'e man ojr vin, ajruc're' raj tijtij chic aac' vin jwi'l tijb'ij chi masna kus chi tijem man ojr vin, xche' Kakaj Jesús rechak. ");
INSERT INTO uspNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Li jun k'ij re uxlan wo'cotic tran Kakaj Jesús, xk'axtak lak tico'n pach yak ajtijol rib'ak chirij. Rechak pi k'axem trantak xtoctak jujun jwich trig y xpoch'tak la' jk'ab'ak y xtijtak. ");
INSERT INTO uspNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Xpetak nic'j rechak mak fariseo, xtz'onajtak rechak: ¿Nen chac atak tijin tab'antak ri ta' ye'l luwar tib'ansaj la' k'ij re uxlan? xche'tak. ");
INSERT INTO uspNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Kakaj Jesús xtz'onaj rechak: ¿Ta'c'u ilan awi'lak li wuj re Lok'laj Jyolj Kakaj Dios ri xan David ojr pach yak jpach cuando xc'oktak wi'jal? ");
INSERT INTO uspNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Re xoc li nimlaj chinam ri richoch Kakaj Dios, xtij mak cuxlanwa ri sujul re Kakaj Dios y xye' chi tijem rechak yak jpach y ta' ye'l luwar jwi'l Jpixb' Kakaj Dios chi titijsaj, xike rechak yak ajc'amaltak jb'eak cristian riq'ui Kakaj Dios, tiche', xche'. ");
INSERT INTO uspNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Y xij chic rechak: Jc'ajol Kakaj Dios ri xwux pi cristianil wi' laj jk'ab' nen raj tran la' k'ij re uxlan, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Li jun k'ij re uxlan xoc Kakaj Jesús li sinagog y xoc chic chi jtijojcak cristian re Jyolj Kakaj Dios y cla' wi' jun winak siquirnak jpaach jk'ab'. ");
INSERT INTO uspNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Yak ajtijoltak cristian re Jpixb' Kakaj Dios pach mak fariseo, cow tijin triltak Kakaj Jesús wi tijtzib'saj cristian la' k'ij re uxlan pire tijcojtak tzij chirij. ");
INSERT INTO uspNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Pero Kakaj Jesús retami' nen jchomorsa'nak, xij re man winak ri siquirnak jk'ab': B'iiten, wa'ren laj kaxo'l, xche' re. Man winak li xb'iit xwa'r laj xo'lak. ");
INSERT INTO uspNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Kakaj Jesús xij rechak mak fariseo y yak ajtijoltak cristian re Jpixb' Kakaj Dios: Chwaj tantz'onaj chawechak: ¿Nen ye'l luwar tib'ansaj la' k'ij re uxlan, jb'anic utzil o jb'anic c'ax? ¿Tzini' jcolic jun cristian laj jk'ab' camic o jsachic jwich? xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Y xril chic juntir cristian ri sutuwinak rij y xij re sic' winak ri siquirnak jk'ab': Yuk ak'b', xche' re. Sic' winak xyuk jk'ab' y xtzib'c. ");
INSERT INTO uspNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Pero mak cristian ri wi'tak cla' sub'laj xpe retzalak, xoctak chi jchomorsaj nen trantak chi jcamsaj Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","La' mak k'ij li, Kakaj Jesús xe' b'a jun witz y cla' xk'asin jun ak'ab' chi ch'a'wem riq'ui Kakaj Dios. ");
INSERT INTO uspNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Cuando xsakarsanc, xmulb'a' juntir yak ajtijol rib'ak chirij y xcha' cab'lajuj (12) chijxo'lak y xcoj jb'ijak pi tako'n. ");
INSERT INTO uspNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Yak cab'lajuj (12) li ri'taka': Simón ri xcojsaj jb'ij pi Pedro jwi'l Kakaj Jesús, Andrés ri jk'un Simón, Santiago, Juan, Felipe, Bartolomé, ");
INSERT INTO uspNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mateo, Tomás, Santiago ri jc'ajol Alfeo, Simón ri tib'ijsaj Zelote re, ");
INSERT INTO uspNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Judas ri jk'un Santiago y Judas Iscariote ri xjachow re Kakaj Jesús pi camic. ");
INSERT INTO uspNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Cuando xantaj li, Kakaj Jesús xkej chicch b'a witz jpach yak jtako'n y xyuk wa'xtak wich jun tak'j. Y cla' xc'ulwi' rib'ak sub'laj ajtijol rib'ak chirij y sub'laj cristian xpetak lak luwar re Judea y Jerusalén, wi' chiqui' nic'j xpetak lak tak'j re Tiro pach Sidón. Rechak xtawtak riq'ui Kakaj Jesús pire tib'e jte'tak nen tijb'ij y pire titzib'sajtak re jyajak. ");
INSERT INTO uspNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Juntir yak ri tijtijtak c'ax jwi'l wi' etzl laj ranmak, xtzib'sajtaka'n. ");
INSERT INTO uspNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Juntir cristian ri yajtak rajak tijchaptak ritz'ik Kakaj Jesús jwi'l retamaki' chi wi' jcwinel chi tzib'sanc. ");
INSERT INTO uspNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Kakaj Jesús xril yak ajtijol rib'ak chirij y xij rechak: Tzi awechak, atak ri wi' rajwax chawechak, jwi'lkeli atna atoctakna laj jk'ab' Kakaj Dios pire titakon chab'ak. ");
INSERT INTO uspNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Tzi awechak ri atc'oktak jwi'l wi'jal, atna nojtakna. Tzi awechak ri atok'tak lajori, nen or atna tze'ntakna. ");
INSERT INTO uspNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Tzi awechak, atak ri atetzelb'ejtak jwi'lak cristian, atresajtakb'i chijxo'lak, atyok'sajtak y atxutsajtak jwi'lke cub'ul ach'olak chirij Jc'ajol Kakaj Dios ri xwux pi cristianil. ");
INSERT INTO uspNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Cuando titaw k'ij li tib'ansaj c'ax chawechak, qui'cotentak, wa'xok jun nimlaj qui'cotemal laj awanmak jwi'l nimi' atojb'lak tac'ultak riq'ui Kakaj Dios lecj. Yak jmamak mak cristian li, jilonli xantak rechak yak ajk'asaltak Jyolj Kakaj Dios ojrtaktzij. ");
INSERT INTO uspNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Pero ri' c'ur awchak ri atak b'iom jwi'l xatija'taka'b'i utzil neri wich ulew. ");
INSERT INTO uspNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","C'ur awchak atak ri nojsalcatak, tina b'e acuye'takna wi'jal nen or. C'ur awchak atak ri atqui'cottak y attze'ntak, atna ok'takna nen or jwi'l jc'axc'ol awanmak. ");
INSERT INTO uspNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","C'ur awch, atak ri tzi atilsajtak jwi'l cristian jwi'l tina atijtakna c'ax. Jilonli xantak yak jmamak yak cristian li chi tziyi' xriltak mak ri xcoj rib'ak chapca' ajk'asaltak Jyolj Kakaj Dios ojrtaktzij, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Y xij chic: Atak ri tijin tatatak inyolj tamb'ij chawechak: Lok'ajtak mak acontrak y b'antak utzil rechak mak ri atetzelb'entak. ");
INSERT INTO uspNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","B'ijtak re Kakaj Dios chi tijye' jk'ab' chib'ak yak ri tijrayajtak tata'tak c'ax. Ch'a'wentak riq'ui Kakaj Dios chirijak yak ri tib'anowtak c'ax chawechak. ");
INSERT INTO uspNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Wi wi' nen atsec'ow la' acayb'al, ye' chic jun lad acayb'al re chi seq'uem. Wi wi' nen timajow awitz'ik ri tak'u'j, ye' luwar re tijc'am chicb'i atúnica. ");
INSERT INTO uspNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Wi wi' nen titz'onaj chawe jwi'l jono cristian, ye' re y wi wi' nen tialk'amb'i jono kelen awe, ma ta'jaj chirij. ");
INSERT INTO uspNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","B'antak rechak cristian chapca' chawajak trantak chawechak. ");
INSERT INTO uspNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Pero atak wi xike talok'ajtak yak ri atlok'intak, ta' jaljoj rilic ri tijin tab'antak. Ji'ne'lon trantak mak ajmacb' chirib'il rib'ak. ");
INSERT INTO uspNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Wi xike tab'antak utzil rechak nen tib'anow utzil chawechak, ta' jaljoj rilic ri tijin tab'antak. Ji'ne'lon trantak mak ajmacb' chirib'il rib'ak. ");
INSERT INTO uspNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Y wi xike taye'tak jkejomak mak cristian ri tijk'asaj jkejomak, ta' jaljoj rilic ri tijin tab'antak. Ji'ne'lon trantak mak ajmacb' chirib'il rib'ak, tijya'taka' jkejomak chi rib'il rib'ak y trulb'ejtaka' tik'asaj jq'uixel rechak nen jnimal xye'takb'i chi kejom. ");
INSERT INTO uspNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Pero atak, ri' lok'ajtak mak acontrak y b'antak utzil rechak, ye'tak jkejomak, pero ma tz'onajtak chic jq'uixel. Y wi jilon tab'antak li tac'ula'taka' sub'laj nim atojb'lak riq'ui Kakaj Dios lecj y atwuxtaka' pi ralc'wal, jwi'l Kakaj Dios trila' c'ur jwichak mak ri ta' tijc'omowajtak jun tok'ob' y mak etzltak cristian. ");
INSERT INTO uspNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Iltak c'ur jwichak juntir cristian chapca' tran Akajak Dios, trila' c'ur jwichak cristian, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Y xij chic: Ma coj ayb'ak pi k'atb'itzij chirijak cristian chi jb'ij chi ta' tzi tijin trantak pire Kakaj Dios ta' tran jk'atb'itzij chawijak. Ma b'an ak'atb'itzijak chib'ak cristian pire ta' tib'ansaj k'atb'itzij chawijak. Cuytak jmacak cristian y ticuysaji' amacak jwi'l Kakaj Dios. ");
INSERT INTO uspNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Ye'takb'i re jun cristian y Kakaj Dios tijya' chiqui' awechak tzi jpajic chapca' tzi jnojsaj jun nejb', tzi jch'ikxij y tzi jt'ub'ajajc. La' man pajb'l ri tacojtak rechak cristian, ri' ticojsaj chawechak jwi'l Kakaj Dios, xche' Kakaj Jesús rechak. ");
INSERT INTO uspNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Kakaj Jesús xij chic jun esb'i no'j rechak jilonri: Jun moy ta' ticwin chi jc'amic jb'e jun moy chic. Wi tran jilonli chi quib' rib'ilak tib'e tzaaktaka' li jono jul. ");
INSERT INTO uspNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Ni jono ajtijol rib' mas jno'j chiwch ajtijol re, pero cuando tiq'uis jtijoj rib' tiniq'uib'i' jno'j pach ajtijol re. ");
INSERT INTO uspNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","At tawila' jun ra jxerc' che' laj jwich jun awech'elxic y at ta' awetam chi wi' jun jtemal ja laj awch. ");
INSERT INTO uspNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","At tab'ij re: Nampuchna, wesajna jun ra jxerc' che' ri wi' laj awch, atche' re y at wi' jun jtemal ja laj awch. ¡At ajsolcopil acayb'al! Esajna nab'e man jtemal ja ri wi' laj awch at, ajruc're' tijna' tawil man ra jxerc' che' ri wi' laj jwich jun awech'elxic, xche' Kakaj Jesús rechak. ");
INSERT INTO uspNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Kakaj Jesús xij chic rechak: Ta' ni jono tzilaj che', tijye' jwich ri ta' tzi y ta' ni jono che' ri ta' tzi, tijye' jwich ri tzi. ");
INSERT INTO uspNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Juntir mak che' la'ke jwichak tich'ob'saj nen chi che' lal, jwi'l ta' q'uix tijye' higo pire jwich, ni ta' lo'quiej tijye' uva pire jwich. ");
INSERT INTO uspNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Y jun tzilaj cristian tijb'iji' tzitaklaj yoloj jwi'l wi' tzitaklaj no'j laj ranm y jun etzl cristian tijb'iji' etzltak tzij jwi'l wi' etzltak no'j laj ranm. Jwi'l laj ranmi' jun cristian tipe'w ri tijb'ij la' jchi', xche' Kakaj Jesús rechak. ");
INSERT INTO uspNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Kakaj Jesús xtz'onaj rechak: ¿Nen chac tab'ijtak Wajawl chwe y ta' tab'antak lawi' ri tamb'ij chawechak? xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Tanc'ut chawchak nen chi cristian lal tijmaj jun cristian ri tipe wiq'uil, ri tijta inyolj y tran lawi' ri tamb'ij, ");
INSERT INTO uspNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","niq'ui' chapca' jun cristian xan jun ja, nab'e xc'ot jluwr rakan richoch, naj xkesajwi' y xcoj man tz'aak chib' man ab'aj. Cuando xan nimlaj k'alaj, xq'uiych sub'laj ja', xpe jchok'b' man ja', xk'osaj rib' wich jxe' man ja, pero man ja ta' xtzaak jwi'l cowi' tiquil rakan li tz'aak. ");
INSERT INTO uspNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Pero jun cristian ri tijta inyolj y ta' tran lawi' ri tamb'ij re, jilon chapca' jun cristian xan richoch b'a ulewke, ta' xtz'ak jluwr rakan richoch, cuando xpe nimlaj k'alaj, xq'uiy sub'laj ja', xpe jchok'b' man ja', xk'osaj rib' wich jxe' man ja, laj or xtzaakc y xyojmajc, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Kakaj Jesús cuando xmay jb'ij juntir mak esb'itak no'j li rechak cristian ri tijin tijtatak jyolj, xoc Capernaúm. ");
INSERT INTO uspNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Y cla' wi' jun jb'ab'alak mak soldad y wi' jun jmocom ri sub'laj tijlok'aj y kesal re yajel camic re. ");
INSERT INTO uspNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Man jb'ab'alak mak soldad li cuando xta jtaquil chirij Kakaj Jesús, xtakb'i nic'j yak ri wi' rekle'nak chijxo'lak yak rijajl Israel chi jtz'onaj tok'ob' re chi tiyuk jtzib'saj man mocom ri yaj. ");
INSERT INTO uspNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Rechak cuando xtawtak riq'ui Kakaj Jesús xoctak chi jtz'onaj sub'laj tok'ob' re: Man jb'ab'alak mak soldad, rajwaxi' tab'an tok'ob' re, ");
INSERT INTO uspNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","jwi'l re masi' tijlok'aj katilmit y ri' re xtakow jb'anic kasinagog, xche'tak re. ");
INSERT INTO uspNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Xpe Kakaj Jesús, xe' chirijak chi rilic man winak ri yaj, pero cuando tawem trantak chijc'ulel man ja, xpe man jb'ab'alak mak soldad li, xtak chicch nic'j richc'ulchi' chi jb'ij jilonri re Kakaj Jesús: Kaj, mat oc il chi petem laj wichoch, jwi'l ta' tic'ular pi we atoc laj wichoch, ");
INSERT INTO uspNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","jwi'li'li ta' ximb'e in chi ach'ab'ejc, lajori xike tab'ijch chi titzib' wajchac, titzib'i'n. ");
INSERT INTO uspNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Jwi'l in wi' chiqui' nen titakon chimb' y wi' laj ink'b' intakon chib'ak mak soldad. Cuando tamb'ij re jonok chi tib'ec, tib'i'n y cuando tamb'ij chic re jonok chi tipetc, tipeti'n y cuando tamb'ij re wajchac nen chwaj tran, trana'n, xche', xche'tak mak richc'ulchi' re Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Cuando xta Kakaj Jesús xijsaj re jilonli, xsaach jch'ol chi jtaic y xsolcopij rib' y xij rechak yak cristian ri xamtak chirij: In tamb'ij chawechak chi ta' ni jono cristian ta'l inwi'l xo'lak yak rijajl Israel jilon jcub'ar jch'ol chwij chapca' winak ri, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Mak ri takal jwi'l man jb'ab'alak mak soldad xk'ajtak la ja y xe' jte'tak man ajchac ri yaj, jorok tzib'i'n. ");
INSERT INTO uspNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Cuando xantaj li jwi'l Kakaj Jesús, xe' chic li jun tilmit ri jb'ij Naín jpach yak ajtijol rib'ak y jpach sub'laj cristian. ");
INSERT INTO uspNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Cuando xtaw li man oqueb' re man tilmit, xril c'amalch jun camnak jwi'lak b'enam rechak chi jmukic y xike jun chi winak li ric'lal sic' anm ri camnak richjil y sub'laj cristian b'esal chirij chi jmukic. ");
INSERT INTO uspNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Cuando Kakaj Jesús ri Kajawl xril jwich sic' anm xril c'ur jwich y xij re: Mat ok'c, xche' re. ");
INSERT INTO uspNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Xjutun chijc'ulel camnak y xye' jk'ab' la' man ch'atum che' y yak ri c'amowinaktak re camnak xwa'rtak. Kakaj Jesús xij re camnak: At mu's, in tamb'ij chawe: ¡B'iiten! xche' re. ");
INSERT INTO uspNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Y camnak li, laj or xb'iitc y xoc chi yoloj riq'uilak. Xpe Kakaj Jesús, xjachb'i laj jk'ab' sic' jchuch. ");
INSERT INTO uspNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Juntir cristian cuando xriltak chi jilon xaan li, xtzaak jch'olak y xoctak chi nimirsaj jk'ij Kakaj Dios, xijtak: ¡Jun nimlaj ajk'asal Jyolj Kakaj Dios xyuk chikaxo'l! ¡Kakaj Dios xpeti' chi jb'anic utzil chijxo'lak yak rijajl Israel ri jwinak! xche'tak. ");
INSERT INTO uspNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Y jtaquil chirij Kakaj Jesús xtawi' lak juntir luwar re Judea y lak juntir luwar ri wi'tak li c'ulb'at' re Judea. ");
INSERT INTO uspNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Yak ajtijol rib'ak chirij Juan Ajb'anal Ja'tiox xyoltak re Juan juntir ri xtatak chirij Kakaj Jesús. Xpe Juan, xsiq'uij quib' rechak yak ajtijol rib'ak chirij ");
INSERT INTO uspNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","y xtakb'i riq'ui Kakaj Jesús ri Kajawl pire tib'e jtz'onajtak re jilonri: ¿Atni' ri b'il jwi'l Kakaj Dios chi tina jtaknach wich ulew o tina kulb'ejna jun chic? atche'tak re, xche'b'i Juan rechak. ");
INSERT INTO uspNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Cuando xtawtak yak ajtijol rib'ak chirij Juan Ajb'anal Ja'tiox riq'ui Kakaj Jesús xtz'onajtak re: ¿Atni' ri b'il jwi'l Kakaj Dios chi tina jtaknach wich ulew o tina kulb'ejna jono chic? xche'tak re. ");
INSERT INTO uspNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Y li man rat li Kakaj Jesús tijin chi jtzib'saj sub'laj cristian ri wi' yajel rechak y wi' nic'j chic tijin tresaj etzl laj ranmak y wi' nic'j moytak tijin chi jtzib'saj b'ak' jwichak. ");
INSERT INTO uspNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Xpe Kakaj Jesús, xij rechak: Jattak, b'ijtatak re Juan Ajb'anal Ja'tiox juntir ri xawiltak y xatatak. B'ijtatak re chi yak moy tichak na'tuntak, yak co'x tichak wo'cottak, yak ri wi' yajel chirijak ri jb'ij lepra xtzib'taka'n, yak tac tichak tontak, yak camnak xc'astasaji' jwichak laj jcamnaklak y yak powrtak xijsaji' tzilaj jtaquil rechak nen mo ticolmajtak laj jk'ab' jmacak. ");
INSERT INTO uspNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Y tzi re jun cristian ri ta' tijquib'aj ranm chwij, xche' Kakaj Jesús rechak. ");
INSERT INTO uspNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Cuando xk'ajtakb'i yak jtako'n Juan, Kakaj Jesús xoc chi yoloj riq'uilak cristian chirij Juan Ajb'anal Ja'tiox y xtz'onaj rechak: ¿Nen xe' awile'tak li jun luwar lamas ta' cristian? ¿Roni' xe' awile'tak jun aaj ri tiitz'b'ej jwi'l tew? ");
INSERT INTO uspNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Wi ma' ji'ta'lonli, ¿nenc'u xe' awile'tak? ¿Roni' xe' awile'tak jun winak ri cojol kustaklaj itz'ik jwi'l? Ma' ji'ta'lonli. Atak awetamaki' chi yak cristian ri ticojowtak kustaklaj itz'ik y wi' sub'laj kustaklaj kelen rechak, ji' wi'tak laj richochak mak rey. ");
INSERT INTO uspNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","¿Nenc'u xe' awile'tak? ¿Roni' xe' awile'tak jun ajk'asal Jyolj Kakaj Dios? Jiloni'n. Y in tamb'ij chawechak chi re masna nim jk'ij chiwch jun ajk'asal Jyolj Kakaj Dios. ");
INSERT INTO uspNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Jwi'l ri' re quiek chirij ri tz'ib'al li wuj re Lok'laj Jyolj Kakaj Dios ri tijb'ij jilonri: Tina intaknab'i intako'n nab'e chawch pire tijb'ij rechak cristian chi rajwaxi' tijq'uex jno'jak y tijc'am jk'ab'al jmacak chinwch nic' riq'uil tran jwa'x jun ab'e chawch, xche' Kakaj Dios. ");
INSERT INTO uspNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Kes tz'etel tz'et tamb'ij chawechak chi ta' ni jono cristian wa'sal xo'lak juntir cristian ri mas nim jk'ij chiwch Juan Ajb'anal Ja'tiox. Pero chiwch Kakaj Dios ri' mas nim jk'ij chiwch Juan jun cristian ri ta' mas nim jk'ij chijxo'lak yak ri titakon Kakaj Dios laj ranm. ");
INSERT INTO uspNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Juntir cristian pach mak ajtz'onaltak alcabar ri xansaj ja'tiox rechak jwi'l Juan Ajb'anal Ja'tiox, cuando xtatak chi jilonli xij Kakaj Jesús, xretemajtak chi pi jcholajli' ri tijb'ij Kakaj Dios. ");
INSERT INTO uspNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Pero mak fariseo pach yak ajtijoltak cristian re Jpixb' Kakaj Dios ta' xc'ul jwichak lawi' raj Kakaj Dios tran rechak. Rechak ta' rajak xansaj ja'tiox rechak jwi'l Juan Ajb'anal Ja'tiox. ");
INSERT INTO uspNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Jwi'li'li Kakaj Jesús xtz'onaj rechak: ¿Nen quiek la' tanniq'uib'saj yak cristian ri wi'tak re mak junab' lajori? ¿Nen jonok tijmajtak? ");
INSERT INTO uspNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Jilon jb'anicak chapca' mak tral ac'l ri ticub'artak chi itz' lak c'ayb'l y tich'ejejtakb'i chi jch'ab'ej yak jpachak y tijb'ijtak: Xkok'saji' su' chi axicnak, pero ta' xatxojowtak y xkab'ixaji' b'ix ri kes b'is jtaic, pero ta' xatok'tak, tiche'tak. ");
INSERT INTO uspNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Jwi'l cuando xyuk Juan Ajb'anal Ja'tiox, ta' tijtij wa y ta' tijtij vin, atak tab'ijtak chi re wi' jun etzl laj ranm. ");
INSERT INTO uspNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Y cuando xyuk Jc'ajol Kakaj Dios ri xwux pi cristianil, re tijtija' wa y tijtija' vin, atak tab'ijtak: Man winak li sub'laj tiwi'nc, sub'laj tik'ab'arc y richc'ulchi'yi' mak ajtz'onaltak alcabar pach mak ajmacb', atche'tak. ");
INSERT INTO uspNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Pero in tamb'ij chawechak chi jno'j Kakaj Dios tic'utuni' chirij yak ralc'wal, xche' Kakaj Jesús rechak. ");
INSERT INTO uspNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Xpe jun rechak mak fariseo ri jb'ij Simón, xij re Kakaj Jesús chi tib'e jtije' jwa riq'uil. Kakaj Jesús xe' laj richoch y xcub'ar chi' mex. ");
INSERT INTO uspNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Xtaw jun tz'i'laj anm ri wi' li man tilmit li, c'amalb'i jun nejb' jwi'l ri b'anal la' ab'aj ri jb'ij alabastro, nojsal chi perjum. ");
INSERT INTO uspNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Y man anm li cuando xtaw xjutun riq'ui rakan Kakaj Jesús, sub'laj xok' y la' ra'l b'ak' jwich xch'akarsaj rakan y xsu' la' rusumal jb'a, xtz'ub'aj y xtz'aj perjum rij rakan Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Y man fariseo ri xc'amowb'i re Kakaj Jesús cuando xril nen xan anm li, xij laj ranm: Witi kes tz'et ajk'asal Jyolj Kakaj Dios winak ri, titica' retemajre' chi man anm ri tichapow re rakan ri' jun tz'i'laj anm, xche' laj ranm. ");
INSERT INTO uspNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Pero xpe Kakaj Jesús, xij re: Simón, wi' jun kelen chwaj tamb'ij chawe, xche' re. Simón xij re Kakaj Jesús: Wajtijonl, b'ij chwe, xche' re. ");
INSERT INTO uspNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Kakaj Jesús xij re: Wi' jun winak xye' jpwaak chi kejom re quib' winak. Re jun xye' job' cient (500) denario y re jun chic xye' ca'winak lajuj (50) denario. ");
INSERT INTO uspNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Y jwi'l yak cristian li ta' chiqui' ticwintak chi jk'asaj jkejomak riq'uil, xpe man winak li, xcuy jmacak riq'ui jkejomak y ta' chiqui' xk'asajtak. B'ijneca' chwe: ¿Nenc'u rechak yak quib' ajkejom li, tilok'in mas man winak ri xye'w jkejomak? xche' Kakaj Jesús re Simón. ");
INSERT INTO uspNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simón xij re Kakaj Jesús: Tamb'ij in ri' man jun ri mas nim jkejom riq'uil, xche' re. Kakaj Jesús xij: Tz'eti'n, xche' re. ");
INSERT INTO uspNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Y xna'tun chic chi rilic man anm y xij re Simón: Xawila' nen xan anm ri. Cuando xinocch laj awichoch, at ta' xaye' ínja' re ch'ajb'i wakan, pero anm ri xch'akarsaji' wakan la' ra'l b'ak' jwich y xsu' la' rusumal jb'a. ");
INSERT INTO uspNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ta' xinatz'ub'aj chi jc'amic rutzil inwch, pero ruc' anm ri xike cuando xyuk, xoc chi jtz'ub'aj wakan y aj tijini' chi jtz'ub'aj lajori. ");
INSERT INTO uspNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ta' xaye' aceit laj imb', pero ruc' anm ri xtz'aja' perjum rij wakan. ");
INSERT INTO uspNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Tamb'ij chawe chi anm ri jwi'l sub'laj xinjlok'aj, ticuymaji' sub'laj jmac ri b'anal jwi'l. Pero nen ta' mas jmac ticuysajc, ta' mas tilok'inc, xche' Kakaj Jesús re Simón. ");
INSERT INTO uspNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Kakaj Jesús xij re man anm li: Juntir amac xcuymaji'n, xche' re. ");
INSERT INTO uspNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Y yak nic'j chic ri siq'uiltak jwi'l Simón xoctak chi jtz'onaj chirib'il rib'ak: ¿Nen chiqui' jb'anic winak ri, wi' laj jk'ab' tijcuy mac? xche'tak. ");
INSERT INTO uspNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Kakaj Jesús xij chic re man anm: Jwi'l xcub'ar ach'ol chwij xatcolmaji' laj jk'ab' amac. Jat pi utzil, xche' re. ");
INSERT INTO uspNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Cuando xe' quib' uxib' k'ij relicch Kakaj Jesús laj richoch Simón, xwo'cot lak sub'laj tilmit chi jb'ij tzilaj jtaquil chirij jtakon Kakaj Dios chib'ak cristian y yak cab'lajuj (12) jtako'n xamtak chirij ");
INSERT INTO uspNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","y wi' nic'j anm b'esaltak chirij. Yak anm ri b'esaltak chirij ri'taka' yak ri xtzib'sajtak re jyajak y ri xesaj mak etzl laj ranmak. Y chijxo'lak yak anm li b'esali' María ri tib'ijsaj Magdalena re, ri xesaj wukub' (7) etzl laj ranm jwi'l Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Y chijxo'lak yak anm li b'esali' jun anm ri jb'ij Juana ri rixokl jun winak ri jb'ij Cuza. Y Cuza ri' jun jb'ab'alak mak ajchacb' laj richoch Herodes Antipas. Y b'esali' jun anm chic ri jb'ij Susana y wi' chiqui' nic'j anm b'esaltak chijxo'lak. Y ri'taka' yak anm li ri xt'o'wtak re Kakaj Jesús riq'ui nen rajwax re. ");
INSERT INTO uspNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Jun k'ij sub'laj cristian re q'uilaj tilmit xmulb'a' rib'ak chi jtaic jyolj Kakaj Jesús. Re xoc chi jtijojcak y xij jun esb'i no'j rechak jilonri: ");
INSERT INTO uspNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","Wi' jun ajticonl xe' ticonanok. Cuando tijin chi ticonanc, nic'j íjaj xkejtak li b'e y xyak'saj jwi'l cristian y xtijsaj jwi'l tz'iquin. ");
INSERT INTO uspNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Nic'j íjaj chic xkejtak xo'lak ab'aj lamas ta' pim ulew. Cuando mak íjaj li xeltakch, xchekejtak jwi'l mas chekej ulew. ");
INSERT INTO uspNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Y nic'j íjaj chic xkejtak lak q'uix, pero mak q'uix xq'uiytak laj or chiwchak, ta' xye'tak luwar xq'uiytak mak tico'n, jwi'li'li mak tico'n xcamtak ralaj mak q'uix. ");
INSERT INTO uspNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Nic'j chic xkejtak li tzilaj ulew y xq'uiytaka'n. Jujun íjaj xya'taka' jujun cient (100) jwichak, xche' Kakaj Jesús rechak. Y cuando xijmaj jilonli jwi'l, ajruc're' cow xch'a'w chic, xij: ¡Nen titonc, jte' jcholajl ri tamb'ij! xche' Kakaj Jesús rechak cristian. ");
INSERT INTO uspNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Xpe yak ajtijol rib'ak chirij, xtz'onajtak re Kakaj Jesús nen jcholajl tielwi' man esb'i no'j ri xij. ");
INSERT INTO uspNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Kakaj Jesús xij rechak: Atak, Kakaj Dios xya' retemaj chawechak jcholajl jtakon ri ta' etemal, pero rechak ta' xye' luwar rechak tretemajtak. Pero pire mak nic'j cristian chic ri ta' tijcojtak Jyolj Kakaj Dios rajwaxna tamb'ij esb'itak no'j rechak, jwi'l rechak onque tina'tuntaka'n, pero ta' tijmajtak jcholajl nen tijin triltak. Tijta'taka' nen tib'ijsaj rechak, pero ta' tijtatak jcholajl nen tijin tijtatak, xche' Kakaj Jesús rechak. ");
INSERT INTO uspNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Kakaj Jesús xij chic: Jilonri jcholajl ri tielwi' man esb'i no'j ri ximb'ij. Ri jcholajl mak íjaj, ri' Jyolj Kakaj Dios. ");
INSERT INTO uspNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Ri b'e lamas xkejtakwi' mak íjaj, ri'taka' yak cristian ri tijtatak Jyolj Kakaj Dios, pero tipe man jb'ab'al etzl tresaj chic laj ranmak pire ma' tijye' luwar rechak tijcojtak pire ma' ticolmajtak laj jk'ab' jmacak. ");
INSERT INTO uspNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Man luwar lak ab'aj lamas xkejtakwi' mak íjaj, ri'taka' yak cristian ri sub'laj tiqui'cottak chi jtaic Jyolj Kakaj Dios y tijc'ula'taka'n, pero ta' tib'e ra' laj ranmak jwi'l quib' uxib' k'ijke tijcojtak y cuando titakchi'jtak jwi'l man jb'ab'al etzl chi macunc, tican jye'tak jcojic Jyolj Kakaj Dios. ");
INSERT INTO uspNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Man luwar lak q'uix ri lamas xkejwi' mak íjaj, ri'taka' yak cristian ri tijcojtak Jyolj Kakaj Dios quib' uxib' k'ij, pero chi usil tisaach laj ranmak, ri' tib'e ranmak chirij kelen rechak pach jpwaakak y trantak lawi' rajak rechak trantak. Ri' li tik'atow jwich Jyolj Kakaj Dios pire ta' tiwichin laj ranmak. ");
INSERT INTO uspNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Y man kuslaj ulew lamas xkejtakwi' mak íjaj, ri'taka' yak cristian ri nojel ranmak tijcojtak Jyolj Kakaj Dios y tijtatak jcholajl y ticub'ar jch'olak chi jb'anic ri tijb'ij Jyolj Kakaj Dios. Jilonli nic' riq'uil tiwichintaka'n, xche' Kakaj Jesús rechak yak jtako'n. ");
INSERT INTO uspNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Y Kakaj Jesús xij chic: Ta' ni jono cristian tijtzij jun candil pire tijye' ralaj jono kelen o tijye' ralaj ch'at. Jun cristian tijtzij jun candil pirechi' tijcocb'a' lecj pire tijsakab'saj jb'eak mak ri tioctak la ja. ");
INSERT INTO uspNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Ta' ni jono kelen ri tib'ansaj chi mukukil miti tina elna chi sakil. ");
INSERT INTO uspNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Atak, cojtak retal nen tijin tatatak jwi'l nen wi' mas riq'uil, tiye'saj chiqui' mas re y nen ta' re, asta ri tijchomorsaj chi wi' riq'uil, timajsaji' re, xche' Kakaj Jesús rechak. ");
INSERT INTO uspNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Jchuch pach yak jk'un Kakaj Jesús xtawtak lamas wi' Kakaj Jesús, pero ta' tijna' tioctak riq'uil jwi'l sub'laj cristian xmulb'a' rib'ak la ja chi jtaic jyolj. ");
INSERT INTO uspNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Xpe jun rechak yak ri wi'tak cla', xij re: Achuch pach yak ak'un wi'tak chuchja y rajak atjch'ab'ejtak, xche' re. ");
INSERT INTO uspNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Kakaj Jesús xij rechak: Juntir cristian ri tijtatak Jyolj Kakaj Dios y trantak lawi' tijb'ij, ri'taka' li inchuch pach ink'un, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Jun k'ij Kakaj Jesús pach yak ajtijol rib'ak chirij xtawtak chi' nimlaj alagun, Kakaj Jesús xij rechak: Jo'tak ch'akap re nimlaj alagun, xche' rechak. Jilonli xjawtak li barc y xe'tak. ");
INSERT INTO uspNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Cuando b'esaltak b'a ja', Kakaj Jesús xe' jwarj. Y etke xpe jun quiek'ek' tew b'a ja', xoc chi ritz'b'ej mak retumb re man nimlaj alagun y xoc ja' li man barc. Jwi'li'li tichak tijin tikej man barc ralaj ja'. ");
INSERT INTO uspNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Yak ajtijol rib'ak chirij xe'tak lamas tiwarwi' Kakaj Jesús y xb'ittak, xijtak re: ¡Kajtijonl! ¡Kajtijonl! ¡Ojjik'i' jwi'l tijin tikej man barc ralaj ja'! xche'tak re. Ajruc're' xb'iit Kakaj Jesús, xk'el man quiek'ek' tew y mak retumb re man nimlaj alagun, ajruc're' xk'ax quiek'ek' tew y xmay juntir. ");
INSERT INTO uspNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Ajruc're' xpe Kakaj Jesús, xtz'onaj rechak yak ajtijol rib'ak chirij: ¿Nen chac ta' cub'ul ach'olak chwij? xche' rechak. Yak ajtijol rib'ak chirij sub'laj xtzaak jch'olak y xsaach jch'olak, xoctak chi jtz'onaj chirib'il rib'ak: ¿Nen chiqui' jb'anic winak ri, ri tijk'el quiek'ek' tew pach mak retumb re nimlaj alagun y ticojontaka' chiwch? xche'tak. ");
INSERT INTO uspNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Ajruc're' Kakaj Jesús pach yak ajtijol rib'ak chirij xeltakb'i Galilea, xk'axtakb'i ch'akap re nimlaj alagun y xtawtak li man luwar ri jb'ij Gadara. ");
INSERT INTO uspNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Ajri'ke xelch Kakaj Jesús li barc, laj or xpe jun winak aj Gadara riq'uil. Man winak li q'uilaj junab'chak wi' etzl laj ranm, ta' tijcoj ritz'ik jwi'l ch'u'juric, ta' tiwa'x laj richoch y ji' jekel li camposant. ");
INSERT INTO uspNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Man winak li, cuando xril jwich Kakaj Jesús xxucaj rib' chiwch, cow xch'ejej man etzl ri wi' laj ranm, xtz'onaj re: ¿Nen chawaj chwe Kaj Jesús, at Jc'ajol Kakaj Dios lecj? ¡B'an tok'ob' chwe, min ach'u'jursaj! xche' re Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Man etzl li xij jilonli jwi'l Kakaj Jesús xij re chi tielb'i laj ranm man winak li. Re q'uilaj b'welt tich'u'jursaj jwi'l man etzl y q'uilaj b'welt tiximsaj rakan y jk'ab' la' caden y tzi jchajaj trantak, ri' rajak ta' lamas tib'e'w. Pero jwi'l jchok'b' man etzl ri ch'u'jursawinak re ticwini' chi jk'atzic mak caden y tic'amsajb'i lak luwar lamas ta' cristian jwi'l man etzl. ");
INSERT INTO uspNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Kakaj Jesús xtz'onaj re man etzl: ¿Nen ab'j? xche' re. Y man etzl xij: Q'ui imb'j, xche' re Kakaj Jesús. Man etzl xij jilonli re Kakaj Jesús jwi'l sub'laj q'ui ocsaltak laj ranm. ");
INSERT INTO uspNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Y mak etzl li xtz'onajtak tok'ob' re Kakaj Jesús chi ta' taksajtakb'i li xeleb'xan. ");
INSERT INTO uspNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Y wi' sub'laj aak tijin jyuk'icak wich witz, mak etzl xtz'onajtak sub'laj tok'ob' re Kakaj Jesús chi tiye'saj luwar rechak tioctak laj jtio'jlak mak aak li. Y Kakaj Jesús xya' luwar rechak. ");
INSERT INTO uspNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Mak etzl xeltak laj ranm man winak y xe' octak laj jtio'jlak mak aak. Juntir mak aak xmajtak jol wich witz y xkejtakb'i pi xulan asta xe' tzaaktak li nimlaj alagun, cla' xjik'tak. ");
INSERT INTO uspNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Mak ajyuk'ultak aak xelmajtak, xe'tak li tilmit y lak luwar nakaj chi jyolic juntir ri xaanc. ");
INSERT INTO uspNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Y mak cristian xe'tak chi rilic ri xaanc. Cuando xtawtak lamas wi' Kakaj Jesús, xriltak man winak ri xesaj mak etzl laj ranm, cub'ulchak chiwch Kakaj Jesús. Cojolchak ritz'ik jwi'l y ta' chiqui' ch'u'j. Rechak sub'laj xtzaak jch'olak chi rilic. ");
INSERT INTO uspNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Mak cristian ri xiliwtak nen xan Kakaj Jesús re man winak ri xwa'x mak etzl laj ranm, xyoltak rechak cristian ri xtawtak chi rilic. ");
INSERT INTO uspNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Y ajruc're' juntir cristian re man luwar ri jb'ij Gadara, xtz'onajtak tok'ob' re Kakaj Jesús chi tielb'i cla' jwi'l sub'laj jtzakic jch'olak. Ajruc're' Kakaj Jesús xjaw chicb'i li barc y xec'. ");
INSERT INTO uspNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Xpe man winak ri xesaj mak etzl laj ranm, xtz'onaj sub'laj tok'ob' re Kakaj Jesús chi tib'e chirij, pero Kakaj Jesús xij: ");
INSERT INTO uspNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","K'ajen laj awichoch y yolta rechak cristian juntir ri nen xansaj chawe jwi'l Kakaj Dios, xche' re. Man winak li xec' y xyol rechak cristian li tilmit juntir ri nen xan Kakaj Jesús re. ");
INSERT INTO uspNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Cuando Kakaj Jesús xk'aj chic ch'akap re nimlaj alagun, juntir yak cristian cla' sub'laj tiqui'cottak chi jc'ulic jwi'l juntir cristian tijintak chi rulb'ejc. ");
INSERT INTO uspNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Y xtaw jun winak riq'uil ri jb'ij Jairo. Re ri' jb'ab'al man k'at ri tijmulb'a' rib'ak li sinagog. Re xxucb'a' rib' chiwch Kakaj Jesús xtz'onaj tok'ob' re chi tib'e laj richoch, ");
INSERT INTO uspNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","jwi'l wi' jun jrab'in yaj y xike jun jrab'in wi', raj wi' cab'lajuj (12) junb', camic tran. Kakaj Jesús cuando b'esaltak li b'e, b'enam re chi rilic jrab'in Jairo, sub'laj tipitz'saj jwi'l sub'laj cristian ri b'esaltak chirijak. ");
INSERT INTO uspNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Y chijxo'lak cristian b'esali' jun anm yaj ri wi'chak cab'lajuj (12) junab' chi ticar coc'xo'lke tikej man ch'ojnic chirij, pero ni jonok xcwin chi jcunajc. ");
INSERT INTO uspNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Man anm li xjutun chirij Kakaj Jesús y xchap raquitz chak'chi' ritz'ik Kakaj Jesús y laj or xtanar man ch'ojnic chirij. ");
INSERT INTO uspNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Kakaj Jesús xtz'onaj rechak: ¿Nen xinchapowc? xche' rechak. Juntir cristian ta' tijb'ijtak nen xchapow re. Xpe Pedro, xij re Kakaj Jesús: Kajtijonl, yak cristianke atpitz'owc y atjtuc'tak, xche' Pedro re. ");
INSERT INTO uspNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Kakaj Jesús xij chic: In xwic'aji' chi xintzib'saji' jun cristian la' incwinel, xche'. ");
INSERT INTO uspNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Man anm li cuando xta chi xric'aji' Kakaj Jesús, tichak querquen jwi'l jtzakic jch'ol, xxucb'a' rib' chiwch Kakaj Jesús y chiwchak juntir cristian xij nen chac xchap ritz'ik Kakaj Jesús y xij re chi xike cuando xchap ritz'ik, laj or xtanar man ch'ojnic chirij. ");
INSERT INTO uspNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Kakaj Jesús xij re: At inrab'in, xattzib'i' jwi'l xcub'ar ach'ol chwij, jat pi utzil, xche' re. ");
INSERT INTO uspNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Aj tijini' Kakaj Jesús chi yoloj riq'ui man anm li cuando xtaw chic jun tako'n riq'ui Jairo y xij re: Xcami' arab'in. Ta' chiqui' nen tichacuj talatz'ab'saj jwich sic' ajtijonl, xche' re. ");
INSERT INTO uspNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Pero cuando xta Kakaj Jesús jilonli, xij re Jairo: Mi tzaak ach'ol, xike cub'a' ach'ol chwij, arab'in titzib'i'n, xche' re. ");
INSERT INTO uspNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Cuando xtawtak Kakaj Jesús la ja riq'ui Jairo, ta' xye' luwar xoctak jalan cristian riq'uilak la ja, xike Pedro xc'amb'i chirij pach Santiago, Juan y jkaj jchuch man ra anm. ");
INSERT INTO uspNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Juntir cristian ri wi'tak cla' sub'laj tijcamsaj rib'ak chi ok'ej jwi'l b'is chirij ra anm. Xpe Kakaj Jesús, xij rechak: Mat ok'tak chirij ra anm, re ta' camnak, warajke tran, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Rechak xtze'jtak jwich Kakaj Jesús jwi'l xrila'taka' chi xcami' ra anm. ");
INSERT INTO uspNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Xpe Kakaj Jesús, xchap chi jk'ab' ra anm y cow xch'ab'ejc, xij re: ¡Noy b'iiten! xche' re. ");
INSERT INTO uspNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Man ra anm xk'ajch jsantil y laj or xb'iitc. Xpe Kakaj Jesús, xij chi tijye'tak jwa ra anm. ");
INSERT INTO uspNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Sub'laj xsaach jch'olak jkaj jchuch chi rilic. Xpe Kakaj Jesús, xtz'onaj tok'ob' rechak chi mi jyoltak nen xan re ra anm. ");
INSERT INTO uspNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Kakaj Jesús xmulb'a' yak cab'lajuj (12) jtako'n y xye' cwinel rechak chi resaj juntir mak etzl ri wi' laj ranmak cristian y chi jtzib'saj cristian ri yajtak. ");
INSERT INTO uspNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Xtaksajtakb'i chi jb'ij Jyolj Kakaj Dios rechak cristian pire tretemajtak nen mo oquem laj jk'ab' Kakaj Dios pire titakon chib'ak y chi jtzib'saj cristian ri yajtak. ");
INSERT INTO uspNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Y xij rechak: Ta' nen tac'amtakb'i pire laj ab'eak, ta' tac'amtakb'i carot, ni chim, ni wa, ni pwak, ni awitz'ikak re jalb'i awijak. ");
INSERT INTO uspNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Cuando attawtak li jono ja li jun tilmit, wa'xentak cla' ajri' ateltakb'i cla' cuando ateltakb'i li man tilmit. ");
INSERT INTO uspNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Y wi yak cristian li jono tilmit ta' rajak atjc'ultak, elantakb'i cla', can totojtak man pok la' awakanak pire c'utb'ire chiwchak chi ta' tzi xantak jwi'l ta' xatjc'ultak, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Ajruc're' rechak xeltakb'ic, xe'tak lak juntir mak tra luwar re mak tilmit, xe' jb'ijtak tzilaj jtaquil chirij Kakaj Jesucristo rechak juntir cristian y xcunajtak cristian ri yajtak. ");
INSERT INTO uspNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Man rey Herodes Antipas xta jtaquil juntir ri tran Kakaj Jesús y ta' retam nen chi cristian lal. Wi' jujun tib'intak chi ri' Juan Ajb'anal Ja'tiox xc'astasaj jwich laj jcamnakl xo'lak camnakib'. ");
INSERT INTO uspNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Y wi' jujun tib'intak chi ri' Elías ajk'asal Jyolj Kakaj Dios ri xyuk chic wich ulew y wi' chiqui' jujun tib'intak chi ri' jono rechak yak ajk'asaltak Jyolj Kakaj Dios ri xcamtak ojrtaktzij ri xc'astasaj jwich laj jcamnakl. ");
INSERT INTO uspNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Herodes Antipas xij: Pero in xintakow resaj jb'a Juan Ajb'anal Ja'tiox. ¿Nen chiqui' chi cristian lal man jun li ri sub'laj jtaquil tijin tanta chirij ri tijin tran? xche'. Y jwi'li'li Herodes Antipas rajti ranm tril jwich Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Cuando xk'ajtakch yak cab'lajuj (12) jtako'n Kakaj Jesús, xyoltak re Kakaj Jesús nen xantak. Y xc'amsajtakb'i pi ric'anak jwi'l Kakaj Jesús li tilmit Betsaida. ");
INSERT INTO uspNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Pero cuando cristian xtatak chi xi'taka' li man tilmit li, xamb'ertakb'i chirijak y xc'ulsajtaka' pi qui'cotemal jwi'l Kakaj Jesús y xye'saj jtaquil Jyolj Kakaj Dios rechak pire tretemajtak nen mo oquem laj jk'ab' Kakaj Dios pire titakon chib'ak y xtzib'saj yak ri yajtak. ");
INSERT INTO uspNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Cuando xe' k'ij xpetak yak cab'lajuj (12) jtako'n Kakaj Jesús, xijtak re Kakaj Jesús: Q'uis ayolj riq'uilak cristian y b'ij rechak chi tib'e jtoque' jposadak, tib'e jlok'e' jwaak li mak tilmit y li mak ja ri wi' chi nakaj, jwi'l neri ta' kelen tic'ayaj, xche'tak re. ");
INSERT INTO uspNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Kakaj Jesús xij rechak: Ye'tak jwaak atak, xche' rechak. Rechak xijtak re Kakaj Jesús: Pero ta' nen wi' kiq'uil, xike job' chi cuxlanwa pach quib' chi car. ¿Tonc'u b'e kalok'e'na sub'laj cuxlanwa pire juntir cristian ri? xche'tak re. ");
INSERT INTO uspNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Sub'laj q'ui cristian wi'tak cla', wi'taka' raj job' mil (5,000) chi winak. Kakaj Jesús xij rechak yak ajtijol rib'ak chirij: B'ijtak rechak cristian chi ticub'artak y tijc'am rib'ak pitak ca'winak lajuj (50) rib'ilak, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Y jilon xantak yak ajtijol rib'ak chirij pire xcub'artak juntir cristian. ");
INSERT INTO uspNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Xpe Kakaj Jesús, xc'am mak job' cuxlanwa laj jk'ab' pach mak quib' car, xna'tun lecj y xc'omowaj re Kakaj Dios. Ajruc're' xq'uer mak cuxlanwa y xye' rechak yak ajtijol rib'ak chirij pire tijjachtak chiwchak juntir cristian. ");
INSERT INTO uspNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Juntir cristian xwi'ntak asta xnojtak. Y cuando xcolajtak, xpetak yak ajtijol rib'ak chirij xnojsajtakna cab'lajuj (12) chicach chi q'uertak cuxlanwa pach car ri ta' xq'uisc. ");
INSERT INTO uspNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Li jun k'ij tijin Kakaj Jesús chi ch'a'wem riq'ui Kakaj Dios y xike yak ajtijol rib'ak chirij wi'tak riq'uil, xtz'onaj rechak: ¿Nenc'u in ri tijb'ijtak cristian? xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Rechak xijtak re: Wi' jujun tijb'ijtak chi ati' Juan Ajb'anal Ja'tiox, jujun chic tijb'ijtak chi ati' Elías y jujun chic tijb'ijtak chi ati' jun rechak yak ajk'asaltak Jyolj Kakaj Dios ojrtaktzij ri xc'astasaj jwich laj jcamnakl, xche'tak re. ");
INSERT INTO uspNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Y xtz'onaj rechak yak ajtijol rib'ak chirij: Ruc' atak, ¿nenc'u in tab'ij atak? xche' rechak. Pedro xij re Kakaj Jesús: Ati' ri b'il jwi'l Kakaj Dios chi tina jtaknach wich ulew, xche' re. ");
INSERT INTO uspNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Kakaj Jesús xij rechak yak ajtijol rib'ak chirij chi mi jyoltak rechak cristian ri xtatak. ");
INSERT INTO uspNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Y xij rechak: Jc'ajol Kakaj Dios ri xwux pi cristianil tina b'ansajna c'ax re, tina xutsajna jwi'lak yak ri wi' rekle'nak chijxo'lak yak rijajl Israel y jwi'lak mak jb'ab'alak yak ajc'amaltak jb'eak cristian riq'ui Kakaj Dios y jwi'lak yak ajtijoltak cristian re Jpixb' Kakaj Dios. Tina camsajna, pero tina c'astasajna jwich laj jcamnakl laj jrox k'ij, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Ajruc're' Kakaj Jesús xij chic rechak juntir cristian: Wi wi' jonok raj tioc pi ajtijol rib' chwij, rajwaxi' jk'ele' rib' chi jb'anic lawi ri raj re tran. Rajwaxi' tina jtijna c'ax laj jc'aslemal y tixamb'er chwij. ");
INSERT INTO uspNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Nen jono cristian ta' raj tijye' rib' pi camic jwi'lke tran lawi' raj Kakaj Dios tran, tisaachi' jwich, pero nen tijye' rib' pi camic inwi'l in, ticolmaji'n. ");
INSERT INTO uspNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Ta' nen tichacuj jwi'l jun cristian trechb'ej juntir kelen re wich ulew wi pi reke tisaach jwich. ");
INSERT INTO uspNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Wi wi' jono cristian tiq'uixib' inwi'l y tiq'uixib' jwi'l inyolj, jilon Jc'ajol Kakaj Dios ri xwux pi cristianil, tiq'uixib'i' jwi'l cuando tipe chic sub'laj nim jk'ij y nic' jnimal jk'ij pach Jkaj pach jnimal jk'ij yak anjl ri tosol pire re. ");
INSERT INTO uspNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Kes tz'etel tz'et tamb'ij chawechak chi wi' jujun rechak cristian ri wi'tak neri, ta' ticamtak asta tina riltakna jtakon Kakaj Dios chib'ak cristian, xche' Kakaj Jesús rechak. ");
INSERT INTO uspNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Raj waxakib' (8) k'ij jb'ij jwi'l Kakaj Jesús jilonli, xc'amb'i Pedro, Juan y Santiago b'a jun witz chi ch'a'wem riq'ui Kakaj Dios. ");
INSERT INTO uspNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Cuando tijin tich'a'w Kakaj Jesús riq'ui Kakaj Dios xjalmaj rilic y ritz'ik xan sakb'ot y tikopoponc. ");
INSERT INTO uspNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Etke xriltak quib' winak tijintak chi yoloj riq'ui Kakaj Jesús, ri'taka' Moisés pach Elías. ");
INSERT INTO uspNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Sub'laj tikopopon ritz'ikak y tijin tijyoltak nen mo jk'ajic Kakaj Jesús lecj ri tawem tran chiwch, ri tina b'anna re li tilmit Jerusalén. ");
INSERT INTO uspNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Pedro pach yak jpach sub'laj c'ax waraj rechak, pero ta' xwartak, jwi'li'li xriltak chi sub'laj tikopopon rijak Kakaj Jesús pach yak quib' winak ri wi'tak riq'uil. ");
INSERT INTO uspNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Cuando elamchak trantakb'i yak winak riq'ui Kakaj Jesús, xpe Pedro, xij re Kakaj Jesús: Kajtijonl, jor tzi wojtak neri, tikab'an uxib' chinam, jun pi awe at, jun pi re Moisés y jun pi re Elías, xche' re. Pero Pedro ta' retam wi tzi o ta' tzi tijin tijb'ij. ");
INSERT INTO uspNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Aj tijini' Pedro chi jb'ij jilonli, cuando xpe jun sutz', xch'uk rijak. Sub'laj xtzaak jch'olak yak ajtijol rib'ak chirij Kakaj Jesucristo cuando xch'uksaj rijak jwi'l sutz'. ");
INSERT INTO uspNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Ri'chak xtatak xaanch jun ch'a'wem li sutz', xij: Ri' ri inc'ajol, ri cha'l inwi'l, tatak jyolj, xche'. ");
INSERT INTO uspNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Cuando xtatak jilonli, xriltak Kakaj Jesús ric'anchak. Rechak xwa'xke laj ranmak, ta' ni jono quiek re xyoltak nen xriltak. ");
INSERT INTO uspNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Laj jcab' k'ij cuando xkejtakch b'a witz, sub'laj q'ui cristian xpetak chi jc'ulic Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Y wi' jun winak chijxo'lak mak cristian sub'laj cow xch'a'wc, xij re Kakaj Jesús: Ajtijonl, b'an tok'ob' chwe, il inc'ajol, xike jun inc'ajol li wi'. ");
INSERT INTO uspNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Xoc jun etzl laj ranm. Etke tich'ejej, tijye' quiek'ek' re, tiputzuw laj jchi' y ta' tican ye'saj jwi'l man etzl. ");
INSERT INTO uspNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Xintz'onaji' tok'ob' rechak yak ajtijol rib'ak chawij chi tresajtak man etzl, pero ta' xcwintak chi resajc, xche' man winak re Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Kakaj Jesús xij rechak: ¡Atak cristian ri ta' cub'ul ach'olak chirij Kakaj Dios y xike tab'antak etzltak no'j! ¿Jurub'c'u k'ij rajwax inwa'xna aac'lak pire ticub'ar ach'olak chwij? ¿Jurub'c'u k'ij rajwax atna incuytakna jwi'l ta' ticub'ar ach'olak chwij? xche' rechak. Y xij re man winak: C'amch ac'ajol neri, xche' re. ");
INSERT INTO uspNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Pero cuando tawem tran man c'ojol winak riq'ui Kakaj Jesús xt'ojsaj lak ulew jwi'l man etzl y xye' jun quiek'ek' re. Pero Kakaj Jesús xk'el man etzl, xtzib'saj man c'ojol winak y xjach re jkaj. ");
INSERT INTO uspNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Juntir cristian xsaach jch'olak chi rilic jcwinel Kakaj Dios. Xpe Kakaj Jesús, xij rechak yak ajtijol rib'ak chirij: ");
INSERT INTO uspNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","Tatak jcholajl ri tamb'ij: Jc'ajol Kakaj Dios ri xwux pi cristianil tina jachsajna laj jk'ab'ak mak cristian, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Pero yak ajtijol rib'ak chirij ta' xtatak jcholajl nen tielwi', jwi'l ajqui' chi ye'saj luwar rechak jwi'l Kakaj Dios chi retemaj jcholajl. Y titzaak jch'olak chi jtz'onaj re Kakaj Jesús nen jcholajl tielwi' ri xijsaj rechak. ");
INSERT INTO uspNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Yak ajtijol rib'ak chirij Kakaj Jesucristo xoctak chi jyolic chirib'il rib'ak nen rechak mas nim jk'ij. ");
INSERT INTO uspNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Kakaj Jesús retami' nen tijin tijchomorsaj laj ranmak, jwi'li'li xc'am jun ral ac'l y xwab'a' riq'uil y xij rechak: ");
INSERT INTO uspNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Nen tijc'ul laj imb'j, jun ri ta' tijcoj jk'ij chapca' man ral ac'l ri, ini' injc'ul. Nen inc'uluw in, ri' tijc'ul ri xintakowch. Jwi'li'li nen ri ta' cojol jk'ij, ri' re mas nim jk'ij, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Xpe Juan, xij re Kakaj Jesús: Kajtijonl, xkila' jun winak tijin tresaj mak etzl laj ranm cristian laj ab'j. Oj xkak'ela'n, jwi'l ma' kapach ta'n, xche' re. ");
INSERT INTO uspNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Kakaj Jesús xij rechak: Ma k'eltak jwi'l nen ta' atcontrintak, ri' jun aac'lak, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Cuando tawem tran mak k'ij re tic'amsajb'i Kakaj Jesús lecj, xcoj jcowil ranm, xe' Jerusalén. ");
INSERT INTO uspNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Cuando b'esaltak lak b'e xtakb'i yak jtako'n li jun luwar re Samaria pire tib'e jtoque'tak lamas tiwa'xtakwi'. ");
INSERT INTO uspNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Pero yak cristian aj Samaria ta' rajak xc'ultak jwi'l retamaki' chi b'enami' re Jerusalén. ");
INSERT INTO uspNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Yak quib' ajtijol rib'ak chirij Kakaj Jesucristo, Santiago pach Juan cuando xriltak chi jilonli xansaj rechak, xtz'onajtak re Kakaj Jesús: Kajawl, ¿chawajni' tikatz'onaj re Kakaj Dios lecj chi tijtakch k'ak' chapca' xan Elías pire tic'atsaj juntir mak cristian ri? xche'tak re. ");
INSERT INTO uspNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Kakaj Jesús xsolcopij rib' chi rilicak, xk'elonc y xij rechak: Atak ta' awetamak nen chi santil titakon chab'ak. ");
INSERT INTO uspNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Jc'ajol Kakaj Dios ri xwux pi cristianil ta' xpe chi jsachic jwichak cristian, re chi jcolicaki' xpetc, xche' rechak. Y xantajtakb'i pach yak ajtijol rib'ak chirij xe'tak li jun jalan luwar chic. ");
INSERT INTO uspNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Cuando b'esaltak lak b'e, xpe jun winak, xij re Kakaj Jesús: Chwaj imb'e chawij lamas atb'e'w, xche' re. ");
INSERT INTO uspNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Kakaj Jesús xij re: Mak utiw wi' jjulak y mak tz'iquin wi' jsocak, pero Jc'ajol Kakaj Dios ri xwux pi cristianil ta' lamas tijtz'eb'a'wi' jb'a, xche' re. ");
INSERT INTO uspNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Y xij chic re jun chic: Jo' chwij, xche' re. Pero man winak xij re: Wajawl, ye' luwar chwe tib'e immuke'na inkaj nab'e, xche' re. ");
INSERT INTO uspNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Pero Kakaj Jesús xij chic re: Can ye'tak mak camnak jmuke'na jcamnakak, pero at b'ijta Jyolj Kakaj Dios rechak cristian pire tretemajtak nen mo tioctak laj jk'ab' Kakaj Dios pire titakon chib'ak, xche' re. ");
INSERT INTO uspNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Xpe chic jun, xij re Kakaj Jesús: Kajawl, in chwaj imb'e chawij, pero ye' luwar chwe tib'e inch'ab'ejtakna yak wech'elxic laj wichoch nab'e, xche' re. ");
INSERT INTO uspNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Kakaj Jesús xij chic re: Nen jonok tioc li chac chirij wacx chapalchak man arad jwi'l y tina'tun chic chirij, ta' tzi. Y jilon jun cristian ri raj tran lawi' raj Kakaj Dios y tijquib'aj ranm, ta' tzi pire tioc lamas titakonwi' Kakaj Dios chib'ak cristian, xche' re. ");
INSERT INTO uspNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Cuando xantaj li, Kakaj Jesús ri Kajawl xcha' oxc'al cab'lajuj (72) yak ajtijol rib'ak chirij pire tijtakb'i pi cacab' rib'ilak b'ak tilmit y lak luwar lamas tina b'ena. ");
INSERT INTO uspNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Kakaj Jesús xij rechak: Sub'laj nim man tico'n toquem raj jwich, pero quib' uxib'ke mak mocom. Atak tz'onajtak tok'ob' re Rajw tico'n chi tijtakch mocom chi jtoquic jwichak mak tico'n. ");
INSERT INTO uspNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Jattak, atintaktakb'i lak jaljojtak luwar, tamb'an chawechak chapca' jtakic carner chijxo'lak mak utiw. ");
INSERT INTO uspNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Ta' tac'amtakb'i achimak, ni c'olb'i apwaakak, ni axajb'ak y mat wa'rtak chi yoloj lak b'e pire ma' atb'aymajtak. ");
INSERT INTO uspNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Cuando atoctak li jono ja, nab'e tac'amtak rutzil jwichak cristian y tab'ijtak rechak: Atak juntir ri watak la ja neri, wa'xok utzil laj awanmak, atche'tak rechak. ");
INSERT INTO uspNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Wi wi' jono cristian cla' tic'ular pire tijc'ul utzil laj ranm, ri utzil ri tz'onal awi'lak ticani' riq'uil, pero wi ta' ni jono cristian cla' tic'ular pire tijc'ul utzil laj ranm, tik'aj chiqui'ch aac'lak. ");
INSERT INTO uspNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Wa'xentak la ja cla', tijtak wa pach ja' ri tiye'saj chawechak, jwi'l jun mocom pi jcholajli' titojsaj. Mat wo'cottak chak'ja. ");
INSERT INTO uspNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Cuando attawtak li tilmit lamas atc'ulsajtak pi utzil tijtak lawi' ri tiye'saj chawechak chi tijem. ");
INSERT INTO uspNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Tzib'sajtak yak cristian ri yajtak ri wi'tak cla' y b'ij rechak: Raquitzchak raj tijch'ol takon Kakaj Dios chab'ak, atche'tak rechak. ");
INSERT INTO uspNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Pero wi attawtak li jono tilmit y ta' atc'ulsajtak pi utzil, elantakb'i li b'e re man tilmit li y b'ijtak rechak: ");
INSERT INTO uspNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","Mak jpokal atilmitak ri xnac'arb'i la' kakan, ticani' katotoj pire c'utb'ire chawchak chi ta' tzi xab'antak xojaxuttak. Pero cojtak retal chi raquitzchak raj tijch'ol takon Kakaj Dios chib'ak cristian, atche'tak rechak. ");
INSERT INTO uspNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","In tamb'ij chawechak cuando titaw k'ij tran jk'atb'itzij Kakaj Dios chib'ak juntir cristian wich ulew, mak cristian li masna c'ax k'atb'itzij tib'an chib'ak chiwch xan chib'ak mak cristian aj Sodoma, xche' Kakaj Jesús rechak. ");
INSERT INTO uspNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Kakaj Jesús xij chic rechak: ¡C'ur awchak atak aj Corazín! ¡C'ur awchak atak aj Betsaida! Jwi'l witi ji' xansaj mak c'utb'i jcwinel Kakaj Dios riq'uilak yak cristian aj Tiro pach Sidón ri xansaj aac'lak, ojrtene're' xq'uex jno'jak y xcoja'taktene're' k'ektaklaj itz'ik roj xtila'taktene're' chaaj laj jb'aak pire c'utb'ire chi tib'isontaka' jwi'l jmacak. ");
INSERT INTO uspNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Pero cuando tran jk'atb'itzij Kakaj Dios chib'ak juntir cristian wich ulew, atak masna c'ax k'atb'itzij tib'an chab'ak chiwchak mak cristian aj Tiro y aj Sidón. ");
INSERT INTO uspNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Y atak aj Capernaúm, ri' chach'olak chi atc'amsajtaka'b'i riq'ui Kakaj Dios lecj, pero ji'c'une' atc'amsajtakb'i li man luwar ri lamas tic'olsaj jsantilak camnakib'. ");
INSERT INTO uspNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Nen tijta ayoljak, ini' injtatak y nen atxutuwtak, ini' injxuttak y nen inxutuw in, ri' tijxut ri intakowinakch wich ulew, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Yak oxc'al cab'lajuj (72) ajtijol rib'ak chirij Kakaj Jesucristo cuando xk'ajtakch, sub'laj tiqui'cottak, xijtak: Kajawl, asta mak etzl xcojontaka' chikawch laj ab'j, xche'tak re Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Kakaj Jesús xij rechak: Tz'eti'n, in xwila' man jb'ab'al etzl xtzaakch lecj. ");
INSERT INTO uspNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","In xinya' k'atb'itzij laj ak'b'ak pire wi tayak'tak mak cumatz pach mak sina'j ta' nen trantak chawechak y xinya' k'atb'itzij laj ak'b'ak pire atch'econtak chib' jcwinel man jb'ab'al etzl y ta' tib'ansaj c'ax chawechak. ");
INSERT INTO uspNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Pero mat qui'cottak jwi'l ticojon mak etzl chawchak. Ri' qui'cotentak jwi'l tz'ib'alchak ab'jak li wuj riq'ui Kakaj Dios lecj, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","La' man or li sub'laj nojsal ranm Kakaj Jesús chi qui'cotemal jwi'l Lok'laj Jsantil Kakaj Dios, xij: Tannimirsaj ak'ij at Inkaj, ri Rajawl caj pach ulew jwi'l at ta' xaye' luwar rechak yak ri wi' jno'jak chi tretemajtak jcholajl nen xab'ij. Pero xaya' luwar xretemajtak yak cristian ri jilon jno'jak chapca' mak tral ac'l. Jiloni' Kaj, jwi'l jilon chawaj, xche'. ");
INSERT INTO uspNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Kakaj Jesús xij re cristian: Inkaj xjacha' juntir laj ink'b'. Ta' ni jonok retam nen tran Jc'ajol Kakaj Dios, xike Kakaj Dios y ta' ni jonok retam nen tran Kakaj Dios, xike Jc'ajol Kakaj Dios pach yak cristian ri lawi' raj Jc'ajol Kakaj Dios tijye' retemaj rechak, xche'. ");
INSERT INTO uspNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Y xij rechak yak ajtijol rib'ak chirij: Tzi rechak yak cristian ri triltak lawi' ri tijin tawil atak. ");
INSERT INTO uspNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Tamb'ij chawechak chi wi' sub'laj ajk'asaltak Jyolj Kakaj Dios pach mak rey rajak roj xrile'tak ri tijin tawiltak lajori, pero ta' xriltak. Rajak roj xtatak lawi' ri tijin tatatak lajori, pero ta' xtatak, xche' Kakaj Jesús rechak. ");
INSERT INTO uspNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Li jun k'ij, jun rechak yak ajtijoltak cristian re Jpixb' Kakaj Dios xe' riq'ui Kakaj Jesús. Ri' raj tijta nen tib'ijsaj re pire tijcojtak tzij chirij, xtz'onaj re Kakaj Jesús: Ajtijonl, ¿nen rajwax tamb'an pire tanta' jun tzilaj c'aslemal riq'ui Kakaj Dios lecj ri ta' jq'uisic? xche' re. ");
INSERT INTO uspNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Kakaj Jesús xtz'onaj re man winak li: ¿Nenc'u tz'ib'al li wuj re Jpixb' Kakaj Dios? ¿Nenc'u jcholajl tiel chawch at? xche' re. ");
INSERT INTO uspNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Man winak li xij chic re Kakaj Jesús: Lok'aj Akaj Dios ri Awajawl riq'ui nojel awanm y xike chomorsaj chirij Kakaj Dios y b'an riq'ui nojel awanm lawi' raj tab'an y lok'aj awijl atz'akt chapca' jlok'aj ayb' at tab'an, xche'. ");
INSERT INTO uspNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Kakaj Jesús xij chic re: Tz'eti' xab'ij. Wi tab'an juntir li, tata' jun tzilaj c'aslemal riq'ui Kakaj Dios lecj ri ta' jq'uisic, xche' re. ");
INSERT INTO uspNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Man ajtijol cristian re Jpixb' Kakaj Dios xan chapca' ta' retam jcholajl, xtz'onaj re: ¿Nenc'u wijl intz'akt? xche' re Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Kakaj Jesús xij chic re: Wi' jun winak xelb'i Jerusalén b'enam re Jericó, xelch nic'j alk'om chirij, xk'attak jb'e, xresajtak juntir ritz'ik, xsec'tak y xsoctak. Cuando xriltak camicchak re sic' winak, ajruc're' xcan jye'tak. ");
INSERT INTO uspNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Y la' man b'e li b'esal jun ajc'amal jb'eak cristian riq'ui Kakaj Dios, pero cuando xril chi tob'ol sic' winak li b'e, xcot jb'e, naj xk'axwi' re, xec'. ");
INSERT INTO uspNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Y b'esal chic jun rijajl Leví. Re xril chi tob'ol sic' winak li b'e, xcot jb'e, naj xk'axwi', xec'. ");
INSERT INTO uspNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Y ajruc're' b'esal chic jun winak aj Samaria la' man b'e li, cuando xtaw chijc'ulel sic' winak tob'ol li b'e, sub'laj xril c'ur jwich. ");
INSERT INTO uspNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Xjutun chijc'ulel chi rilic nen c'ax re y xoc chi jcunaj mak soque'l la' aceit olivo, la' vin y xpis jwich mak soque'l y xye'b'i chirij jcwa'y y xc'amb'i li jun b'amb'i posad y xwa'x jun ak'ab' chi jchajajc. ");
INSERT INTO uspNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Cuando xsakarsan laj jcab' k'ij, xec', xcan jye' quib' denario re man rajw posad y xij re: B'an tok'ob', tacunaj sic' winak ri y tachajaj y wi wi' mas pwak tasach chirij, mat oc il re. In tiyuki' intoje' chawe cuando ink'aj chicch, xche' re. ");
INSERT INTO uspNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Kakaj Jesús xtz'onaj re man ajtijol cristian re Jpixb' Kakaj Dios: ¿Nenc'u rechak mak uxib' chi cristian li ri rijl jtz'akt sic' winak ri xansaj c'ax re jwi'l mak alk'om? xche' re. ");
INSERT INTO uspNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Man ajtijol cristian re Jpixb' Kakaj Dios xij re Kakaj Jesús: Ri' man jun ri xiliw c'ur jwich, xche' re. Kakaj Jesús xij chic re: Jat y b'an at chapca' xan man winak li, xche' re man ajtijol cristian re Jpixb' Kakaj Dios. ");
INSERT INTO uspNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Kakaj Jesús xe' chic pach yak ajtijol rib'ak chirij y xtaw li jun tilmit. Li man tilmit li xc'ulsaj la ja jwi'l jun anm ri jb'ij Marta. ");
INSERT INTO uspNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Y Marta wi' chiqui' jun jk'un jb'ij María. María xcub'ar riq'ui Kakaj Jesús chi jtaic nen tijb'ij. ");
INSERT INTO uspNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Pero Marta ta' xan jilonli jwi'l sub'laj latz' jwich chi jb'anic ropis. Marta xe' riq'ui Kakaj Jesús y xtz'onaj re: Kajawl, ¿kuskec'u tawil xincan ye'saj wic'an chi jb'anic wopis jwi'l ink'un? B'ijco' re chi injt'o'w, xche' re. ");
INSERT INTO uspNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Pero Kakaj Jesús xij re Marta: Marta, Marta, sub'laj atoc il chirij awopis, ");
INSERT INTO uspNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","pero junke chi kelen mas rajwax tib'ansajc, ri' xan María lawi' mas rajwax tib'ansajc y ta' nen tiesaj re, xche' re Marta. ");
INSERT INTO uspNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Jun k'ij Kakaj Jesús xoc chi ch'a'wem riq'ui Kakaj Dios li jun luwar. Cuando xmay ch'a'wem riq'ui Kakaj Dios xpe jun rechak yak ajtijol rib'ak chirij xij re: Kajawl, cojatijoj chi ch'a'wem riq'ui Kakaj Dios chapca' Juan Ajb'anal Ja'tiox xtijoji' yak ajtijol rib'ak chirij, xche' re. ");
INSERT INTO uspNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Kakaj Jesús xij re: Cuando atch'a'wtak riq'ui Kakaj Dios b'ijtak jilonri: At, Kakaj Dios, wat lecj chi jnimirsajti jcojic jk'ij ab'j. Petok attakon chib'ak juntir cristian. Y lawi' chawaj tab'an wich ulew, b'an jilon chapca' tab'an lecj. ");
INSERT INTO uspNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Ye' kaw nojel k'ij. ");
INSERT INTO uspNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Cuy kamac riq'ui mak etzltak no'j ri tikab'an chawch chapca' oj tikacuya' jmacak yak cristian ri tib'anowtak c'ax chike. Ma ye' luwar re man jb'ab'al etzl ojtakchi'j chi jb'anic etzltak no'j. Cojacole' laj jk'ab' man jb'ab'al etzl, atche'tak, xche' Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Y xij chic rechak: Wi wi' jono chawechak wi' jono richc'ulchi' y titaw laj richoch nic'aj ak'ab', tijb'ij re: B'an tok'ob' chwe injale' uxib' incuxlanwa chawe ");
INSERT INTO uspNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","jwi'lke wi' jun wichc'ulchi' ajri' xyuk, jpetic chinaj. Xtaw wiq'uil la ja lajori y ta' nen tanye' re, tiche' re. ");
INSERT INTO uspNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Y man ri wi' la ja ta' tib'iit chi rilic, xike tijb'ijch re: Ma wesaj kawarj xi' ak'ab' y tz'apili' man ja. Y in pach yak walc'wal tz'e'lcojchak, ta' tijna' imb'iit chi jye'ic jono kelen chawe, tiche' re. ");
INSERT INTO uspNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","In tamb'ij chawechak mine' tib'iit chi jye'ic re onque richc'ulchi'yi'n, tina jtana chi ta' tijmay jtz'onaj re, tiq'uistaj ranm chi jtaic. Ajruc're' tib'iit chi jye'ic juntir nen rajwax re. ");
INSERT INTO uspNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Jwi'li'li in tamb'ij chawechak: Tz'onajtak re Kakaj Dios nen chawajak y re tijya' chawechak. Toctak, tata'taka'n. Ch'a'wentak chi' pwert y titeb'aji' ja chawchak. ");
INSERT INTO uspNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Jwi'l nen titz'onin re Kakaj Dios nen raj, tiye'saji' re y nen titocow, tijta'n y nen tich'a'w chi' pwert, titeb'aji' ja chiwch. ");
INSERT INTO uspNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Atak kaj, ta' ni jun chawechak, cuando tijtz'onaj car ac'ajol, ta' taye' cumatz re chi tijem. ");
INSERT INTO uspNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Ta' taye' sina'j chi tijem re ac'ajol cuando tijtz'onaj sakmolb' chawe. ");
INSERT INTO uspNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Atak, onque ta' tzi ano'jak, awetamaki' taye'tak tzitaklaj kelen re awalc'walak chi tijem y ri'tic'u chic Kakaj Dios lecj ma' tijye' Lok'laj Jsantil rechak nen titz'onin re, xche' Kakaj Jesús rechak. ");
INSERT INTO uspNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Jun k'ij Kakaj Jesús tijin chi resaj jun etzl laj ranm jun sic' winak ri xanow mem re y cuando xel man etzl laj ranm sic' mem, xoc chi yoloj y sub'laj xsaach jch'olak cristian chi rilic. ");
INSERT INTO uspNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Wi' jujun cristian xijtak chirij Kakaj Jesús: Man winak li tresaji' mak etzl ri wi'tak laj ranmak cristian, pero la' jcwinel Beelzebú ri man jb'ab'alak mak etzl, xche'tak. ");
INSERT INTO uspNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Nic'j cristian chic ri' rajak triltak wi kes tz'et Kakaj Diosi' takowinakch re, xijtak re chi tran jono c'utb'i jcwinel Kakaj Dios ri tipe lecj. ");
INSERT INTO uspNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Y Kakaj Jesús retami' nen tijin tijchomorsajtak, xij rechak: Juntir k'atb'itzij, wi tijtos rib'ak y tioctak chi ch'o'j chirib'il rib'ak, tisaachi' jwichak. Y yak ech'elxic li jun ja, wi tijjach rib'ak y tioctak chi ch'o'j chirib'il rib'ak ta' naj tijcuytak jilonli. ");
INSERT INTO uspNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Y ji'c'ulonli tran man jb'ab'al etzl wi tijtos rib' chirib'il rib', tisaachi' jwich jk'atb'itzij. Jilonli tamb'ij jwi'l atak tab'ijtak chi in la'yi' jcwinel Beelzebú twesajb'i mak etzl. ");
INSERT INTO uspNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Wi la'yi' jcwinel Beelzebú twesaj mak etzl laj ranmak cristian, ¿nenc'u ye'winak jcwinelak yak ajtijol rib'ak chawijak pire tresajtak mak etzl laj ranmak cristian? Ri' rechak li tib'intak chawechak chi atak sachalcataka'n. ");
INSERT INTO uspNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Pero wi in twesaj mak etzl laj ranmak cristian la' jcwinel Kakaj Dios, ri' li tic'utuw chi jtakon Kakaj Dios chab'ak xyuki' aac'lak. ");
INSERT INTO uspNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Cuando jun winak wi' jchok'b' y wi' colb'i rib' laj jk'ab', tijchajaji' richoch y juntir kelen re ri c'olan jwi'l, ta' nen tioc re. ");
INSERT INTO uspNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Pero wi tipe jono chic ri wi' mas jcwinel chic chiwch re ticwini' chirij man jun y tijmaj man colb'i rib' ri cub'ul jch'ol chirij y tijjach kelen re chiwchak mak jpach. ");
INSERT INTO uspNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Nen ta' tzi tril ri tamb'an, ri' li incontrinc. Nen ta' injt'o' chi jmulb'aj jwichak cristian, ri' re tiuktamb'i rechak, xche' Kakaj Jesús rechak. ");
INSERT INTO uspNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Kakaj Jesús xij chic rechak: Cuando jun etzl tiel laj ranm jun cristian, tib'e lak chekej luwar, tijtoc lamas tiuxlanwi', pero cuando ta' tijta' jono luwar lamas tiuxlanwi', tijb'ij: Ink'aj chic laj wichoch lamas xinelwi'ch, tiche'. ");
INSERT INTO uspNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Y cuando tik'aj chic man etzl li, tiyuk jte' man cristian ri lamas xelb'i chapca' rilic jun ja, tzi jmesic jpam y tzi jb'anic jwa'xc. ");
INSERT INTO uspNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Tipe man etzl li, tib'e jc'ame'ch wukub' (7) jpach chic ri masna etzl jno'jak chiwch re y juntir rib'ilak tioctak laj ranm man cristian li. Y man cristian li tran chic mas etzl jno'j chiwch ojr, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Cuando tijin Kakaj Jesús chi jb'ij juntir li, xpe jun anm, ri wi' chijxo'lak juntir cristian sub'laj cow xch'ejejc, xij re: Tzi re anm ri xalc'walan awe y xatq'uitzanc, xche'. ");
INSERT INTO uspNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Pero Kakaj Jesús xij re: Ri' mas tzi rechak cristian ri tijtatak Jyolj Kakaj Dios y trantak nen tijb'ij, xche' re man anm. ");
INSERT INTO uspNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Cuando tijin tijmulb'a' rib'ak mas cristian chirij Kakaj Jesús, re xchol yoloj riq'uilak, xij rechak: Yak cristian re mak junab' lajori maschak etzl jno'jak, rajak tijtz'onajtak tib'an jono c'utb'i jcwinel Kakaj Dios chiwchak, pero chiwchak mak cristian li ta' chiqui' tib'ansaj jono c'utb'i jcwinel Kakaj Dios, xike ri xansaj chirij Jonás. ");
INSERT INTO uspNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Jilon chapca' Jonás re ri' jun retal pi rechak mak cristian ojr ri wi'tak Nínive y jilon Jc'ajol Kakaj Dios ri xwux pi cristianil ri' jun retal pi rechak juntir cristian ri wi'tak lajori, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Y man anm ri xwa'x pire reina re man luwar ri wi' li sur, re tipeti' cuando tran jk'atb'itzij Kakaj Dios chib'ak juntir cristian ri wi'tak lajori. Y tina yuk jtz'onajna k'atb'itzij chib'ak juntir mak cristian li, jwi'l sub'laj naji' xpe'w pire xyuk chi jtaic jno'j Salomón. Lajori neri chaxo'lak wi' jun masna jno'j chiwch Salomón. ");
INSERT INTO uspNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Yak cristian aj Nínive tina jb'itna rib'ak pire tijtz'onajtakna k'atb'itzij chib'ak mak cristian ri wi'tak lajori, jwi'l rechak xq'uexa' jno'jak cuando xijsaj Jyolj Kakaj Dios rechak jwi'l Jonás. Lajori neri chaxo'lak wi' jun masna nim jk'ij chiwch Jonás, xche' Kakaj Jesús rechak. ");
INSERT INTO uspNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Kakaj Jesús xij chic rechak: Ta' ni jono cristian tijtzij jun candil y tijye' li jun luwar ri ta' na'lc o tijye' ralaj jun cax. Jun cristian tijtzij jun candil ji' tijcocb'a' lecj pire tijsakab'saj jb'eak yak ri tioctak la ja. ");
INSERT INTO uspNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","B'ak' awch ri' jun candil pire atio'jl, wi tzi b'ak' awch, juntir atio'jl wi' chi sak. Pero wi ta' tzi b'ak' awch, juntir atio'jl wi' li uku'mal. ");
INSERT INTO uspNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Tike acwentij ayb' pire acandil re atio'jl ta' tran uku'm jwich. ");
INSERT INTO uspNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Wi wi' jk'ak'al acandil re juntir atio'jl, ta' ni junquitz canal li uku'mal, juntir atio'jl wi' chi sakil, jilon chapca' jun candil tijsakab'saji' la ja la' jk'ak'al, xche' rechak cristian. ");
INSERT INTO uspNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Cuando xmay yoloj Kakaj Jesús riq'uilak, xpe jun rechak mak fariseo xij re chi tib'e wi'n riq'uil laj richoch. Kakaj Jesús xoc laj richoch y xcub'ar chi' mex. ");
INSERT INTO uspNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Man fariseo li xsaach jch'ol chi rilic Kakaj Jesús jwi'l ta' xch'aj jk'ab' nab'e pire tijtij jwa chapca' jc'utu'nak rechak. ");
INSERT INTO uspNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Jwi'li'li xpe Kakaj Jesús ri Kajawl, xij rechak: Atak fariseo, pur atak mak vas y mak lak ri ch'ajal rij, pero tz'il jpam jwi'l alk'anc y mak etzltak rayb'l ri tab'antak. ");
INSERT INTO uspNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Atak, pur atak jip chi ch'ab'ejem, ¿ta'c'u awetamak chi Kakaj Dios ri xanow atio'jlak niq'ui' jb'anic xan pach awanmak? ");
INSERT INTO uspNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Atak, ye'tak riq'ui nojel awanmak ri wi' aac'lak rechak yak powr y jilonli juntir kelen saki' pi awechak. ");
INSERT INTO uspNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","¡C'ur awchak atak fariseo! Atak taya'taka' jlájuj kelen awechak pire Kakaj Dios, taya'taka' jlájuj mak woron ri jb'ij menta, arur y juntir jwich ichj, pero xcani' aye'tak jb'anic juntir lawi' ri pi jcholajl chiwch Kakaj Dios y ta' talok'ajtak Kakaj Dios. Ri rajwax jb'anic ri' b'antak juntir pi jcholajl chiwch Kakaj Dios. Ri' li ri rajwax tab'antak y mi can aye'tak jye'ic jlájuj kelen awechak. ");
INSERT INTO uspNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","¡C'ur awchak atak fariseo! Atak chawajak atcub'artak la' mak tem ri lamas ticub'artak yak ri wi' rekle'nak lak sinagog y chawajak tic'amsaj rutzil awchak lak c'ayb'l pi c'utb'ire chi nimi' ak'ijak. ");
INSERT INTO uspNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","¡C'ur awchak atak fariseo! Pur atak mak mukb'i camnak ri ta' chiqui' na'lc, tichak k'ax cristian chib' jwi'l ta' na'lc, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Xpe jun rechak yak ajtijoltak cristian re Jpixb' Kakaj Dios, xij re Kakaj Jesús: Ajtijonl, cuando tab'ij jilonli, jilon oj, ojayok'a'n, xche' re. ");
INSERT INTO uspNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Kakaj Jesús xij rechak: ¡C'ur awchak atak ajtijoltak cristian re Jpixb' Kakaj Dios! Atak tijin taye'tak nic'j pixab' sub'laj c'ax jb'anic, pero atak ta' att'o'ontak chi jb'anic ri nen tijb'ij, nic' riq'uil taye'tak jun al laj ika'n chirij jun cristian ri mita' nen ticuyuw ralal, pero atak ni la' jun b'a ak'b'ak att'o'ontak chi jc'amicb'ic. ");
INSERT INTO uspNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","¡C'ur awchak! Atak ri tab'antak tz'aak chib' ri lamas xmuksajtakwi' yak ajk'asaltak Jyolj Kakaj Dios ri xcamsajtak jwi'l amamak. ");
INSERT INTO uspNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","La'ke li tac'uttak chi niq'ui' awchak pach amamak. Rechak xcamsajtak y atak tab'antak jwa'x tz'aak ri lamas xmuksajtak. ");
INSERT INTO uspNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Jwi'li'li Kakaj Dios xchomorsaj, xij: Tantakb'i yak ajk'asaltak inyolj pach yak intako'n chijxo'lak, rechak ticamsaji' jujun y jujun chic titakej jb'anic c'ax rechak, xche'. ");
INSERT INTO uspNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Ri' mak cristian ri wi'tak wich ulew lajori, titojowtak jcamicak juntir yak ajk'asaltak Jyolj Kakaj Dios ri xcamsajtak cuando xticarch jwich k'ijsak. ");
INSERT INTO uspNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Xcholmajch rajlaj riq'ui jcamic Abel asta jcamic Zacarías ri xcamsaj laj xo'lak man altar pach man luwar ri tosol re Kakaj Dios. Pero in tamb'ij chawechak chi ri' mak cristian ri wi'tak wich ulew lajori titojowtak re juntir jcamicak. ");
INSERT INTO uspNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","¡C'ur awchak atak ajtijoltak cristian re Jpixb' Kakaj Dios! Atak ta' taye'tak luwar tiel jcholajl Jyolj Kakaj Dios chi sakil ri awetamak. Jilonli ta' taye'tak luwar tioc cristian laj jk'ab' Kakaj Dios pire titakon chib'ak y ni atak atoctak laj jk'ab' Kakaj Dios pire titakon chab'ak, xche' Kakaj Jesús rechak. ");
INSERT INTO uspNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Cuando elam tramb'i Kakaj Jesús, yak ajtijoltak cristian re Jpixb' Kakaj Dios pach mak fariseo sub'laj xpe retzalak chirij. Xoctak chi jc'otic jchi' Kakaj Jesús chirij sub'laj kelen ri xtz'onajtak re, ");
INSERT INTO uspNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","jwi'l rechak ri' rajak chirijke jyolj tikej laj jk'ab'ak pire tijcojtak tzij chirij. ");
INSERT INTO uspNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Cuando tijin Kakaj Jesús chi yoloj riq'uilak yak ajtijoltak cristian re Jpixb' Kakaj Dios pach mak fariseo, sub'laj q'ui cristian xmulb'a' rib'ak asta tichak jtuc' rib'ak. Kakaj Jesús nab'e xoc chi jb'ij rechak yak ajtijol rib'ak chirij: Atak, cwentij ayb'ak re man jch'amk'orak mak fariseo ri ajsolcopil jcayb'alak. Tijin tamb'ij jilonri chirijak mak solcopil yoloj ri trantak, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Y xij chic: Ta' ni jono kelen ri tib'ansaj chi mukukil miti tina elna chi sakil. ");
INSERT INTO uspNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Juntir ri tayoltak chawib'ilke ayb'ak tina elna chi sakil y juntir ri tab'ijtak pi jasjail tina ch'ejejna jonok b'ak ja chi jb'ijc, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Kakaj Jesús xij chic rechak: Atak, wichc'ulchi', in tamb'ij chawechak chi mi tzaak ach'olak chiwchak mak cristian ri ticamsan atio'jlak jwi'l xike li ticwintak, ta' chiqui' nen ticwintak chi jb'anic. ");
INSERT INTO uspNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","In tamb'ij chawechak nen quiek chiwch rajwax titzaak ach'olak: Ri' tzaak ach'olak chiwch jun ri wi' k'atb'itzij laj jk'ab' tresaj ac'aslemalak neri wich ulew y wi' k'atb'itzij laj jk'ab' atjt'ojtak chic li man luwar re tijb'i c'ax. Ri' li rajwax titzaak ach'olak chiwch. ");
INSERT INTO uspNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Job' chi nuch' tz'iquin tic'ayaji' chi quib' centaw, pero ta' ni jono rechak sachal re Kakaj Dios ");
INSERT INTO uspNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","y jilon rusumal áb'ak ajlali' jwi'l. Jwi'li'li mi tzaak ach'olak, atak masna atlok'ajtak chiwchak sub'laj q'ui tz'iquin, xche' Kakaj Jesús rechak. ");
INSERT INTO uspNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Kakaj Jesús xij chic rechak: In tamb'ij chawechak chi nen jonok tib'in chiwchak cristian chi tijch'ob'a' inwch, jilon Jc'ajol Kakaj Dios ri xwux pi cristianil tijb'iji' chiwchak ranjl Kakaj Dios chi tijch'ob'a' jwich. ");
INSERT INTO uspNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Pero nen jonok ta' raj tijb'ij chiwchak cristian chi tijch'ob'a' inwch, jilon in ta' tamb'ij chiwchak ranjl Kakaj Dios chi tanch'ob'a' jwich. ");
INSERT INTO uspNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Nen jonok tiyok'on chirij Jc'ajol Kakaj Dios ri xwux pi cristianil ticuysaji' jmac jwi'l Kakaj Dios. Pero nen jonok tiyok'on chirij Lok'laj Jsantil Kakaj Dios ta' ni jun b'welt ticuysaj jmac jwi'l Kakaj Dios. ");
INSERT INTO uspNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Cuando atak atc'amsajtakb'i lak sinagog pire tib'ansaj k'atb'itzij chab'ak o cuando atc'amsajtakb'i chiwchak mak jb'ab'altak k'atb'itzij y chiwchak mak k'atb'itzij, mat octak il chi jchomorsaj nen tab'antak chi jcolic ayb'ak o nen tab'ijtak, ");
INSERT INTO uspNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","jwi'l tib'ijsaji' chawechak laj awanmak jwi'l Lok'laj Jsantil Kakaj Dios nen tab'ijtak cuando atch'a'wtak, xche' Kakaj Jesús rechak. ");
INSERT INTO uspNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Xpe jun rechak yak winak, xij re Kakaj Jesús: Kajtijonl, b'ij re man wech'elxic chi tijjach we, ri textament ri xcan jye' inkaj, xche' re. ");
INSERT INTO uspNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Xpe Kakaj Jesús, xij re man winak li: At wichc'ulchi', in ta' cojolquin pire k'atb'itzij chab'ak, ni ta' takalquin chi jjachic textament chawchak, xche' re. ");
INSERT INTO uspNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Y xij chic rechak cristian: Iltak jcholajl nen tab'antak, tacwentij ayb'ak, ma rayajtak tiwa'x mas apwaakak o tiwa'x mas kelen awechak ri reke wich ulew. Jwi'l jun cristian ri wi' sub'laj kelen re, ma' ri' ta' li tiye'w jc'aslemal, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Xpe Kakaj Jesús, xij jun esb'i no'j rechak jilonri: Wi' jun winak sub'laj b'iom. Juntir jtico'n ri xtic laj rulew sub'laj kus xwichintak. ");
INSERT INTO uspNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Man b'iom li xoc chi jchomorsaj laj ranm, xij: ¿Nen tamb'an lajori? Ta' lamas tanc'olwi' juntir jwich intico'n, xche'. ");
INSERT INTO uspNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Y xij: Wetamchak nen tamb'an, tanyoj mak inc'újaj ri wi' y tamb'an chic nic'j mas nimak chic y cla' tanc'olwi' juntir jwich intico'n y juntir kelen we. ");
INSERT INTO uspNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Y tamb'ij re wanm: Wi' sub'laj kelen awe re atuxlan sub'laj junab', tij aw, tij awuc'a', uxlanok y qui'coten, inche' re, xche'. ");
INSERT INTO uspNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Pero Kakaj Dios xij re man winak li: At, atke sons, lak'ab' wica atcamc y juntir kelen awe ri c'olan awi'l, ¿nen quiek re ticanwi'? xche' re. ");
INSERT INTO uspNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Y jilon jun cristian ri tijmulb'a' jb'iomil xike pire re ric'an, ta' nen tichacuj, jwi'l chiwch Kakaj Dios powri'n, xche' Kakaj Jesús rechak. ");
INSERT INTO uspNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Kakaj Jesús xij rechak yak ajtijol rib'ak chirij: In tamb'ij chawechak chi mat octak il chirij nen tatijtak laj ac'aslemalak, ni mat octak il chirij awitz'ikak re tacojtak, ");
INSERT INTO uspNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","jwi'l ac'aslemalak masna nim jk'ij chiwch ri tatijtak y atio'jlak masna nim jk'ij chiwch man itz'ik. ");
INSERT INTO uspNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Ri' iltak nen mo yo'ltak mak joj, rechak ta' titiconantak y ta' tioch'ontak, ni ta' tijc'oltak jwich jtico'nak laj jc'ujaak, ri' Kakaj Dios titzukuw rechak. Y atak masna nim ak'ijak chiwchak mak tz'iquin li. ");
INSERT INTO uspNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Ta' ni jun chawechak ticwin chi jyo'rsaj rib' quib' uxib' or mas re jc'aslemal ri ye'l jwi'l Kakaj Dios jwi'lke tioc il chirij jc'aslemal. ");
INSERT INTO uspNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Y wi mita' atcwintak chi jb'anic mak tra nuch' kelen li, ¿nenc'u chac atoctak il chirijak mak nic'j nimaktak kelen chic? ");
INSERT INTO uspNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Iltak nen mo jq'uiyic mak cutz'i'j re lak tza'l, rechak ta' tichacuntak y ta' tiquemowtak itz'ik. Pero in tamb'ij chawechak chi Salomón sub'laj kustaklaj itz'ik xcoj, pero ta' ni jono ritz'ik xcoj jilon chapca' mak kustaklaj cutz'i'j li. ");
INSERT INTO uspNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Wi jilonli jwikic mak woron li tran Kakaj Dios ri lajori wi'tak lak tza'l y chwek' tic'atsajtak li jorn, kes tz'etel tz'et atjwika'taka' atak ri ta' mas cub'ul ach'olak chirij Kakaj Dios. ");
INSERT INTO uspNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Jwi'li'li atak mat octak il chi jtoquic awak y awuc'a'ak. ");
INSERT INTO uspNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Ri' juntir mak kelen li tioctak il mak cristian chirij ri ta' tijcojtak Jyolj Kakaj Dios, pero Kakaj Dios retami' chi juntir mak kelen li tichoconi' awi'lak. ");
INSERT INTO uspNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Pi jq'uexwach atoctak il chirij mak kelen li, ri' oquentak il chi jtoquic Kakaj Dios pire titakon chab'ak y b'antak lawi' raj Kakaj Dios tab'antak y juntir mak kelen li tiye'saji' chawechak jwi'l Kakaj Dios, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Kakaj Jesús xij chic rechak: Mi tzaak ach'olak atak incarner, ta' atak q'ui, pero Kakaj Dios nojeli' ranm tijye' luwar chawechak pire atoctak laj jk'ab' pire titakon chab'ak. ");
INSERT INTO uspNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Y c'ayajtak juntir kelen awechak ri wi' y sipajtak rijil rechak yak ri wi' rajwax rechak, ri' coj achok'b'ak chi jmolic jwich ab'iomilak ri ta' tik'ax jwich y ta' tisaach jwich. Mulb'a' ab'iomilak riq'ui Kakaj Dios lecj ri lamas ta' alk'om tioc, ni ta' poc' tib'anow c'ax re kelen. ");
INSERT INTO uspNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Lamas wi' ab'iomilak, cla' tiwa'x awanmak, jwi'l ri' b'esal awanmak chirij ab'iomilak, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Kakaj Jesús xij chic rechak: Atak, ulb'entake y tzijke ak'ak'ak ");
INSERT INTO uspNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","chapca' trantak yak mocom ri tike tijin chi rulb'ej jpatronak nen or ak'ab' tik'ajch li jun tz'am pire cuando tich'ab'ejtak, laj or tib'e jteb'a'tak pwert chiwch. ");
INSERT INTO uspNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Tzi rechak yak mocom ri tib'e ta'majtak jwi'l jpatronak, yo'ltak chi rulb'ej nen or tik'ajch. Kes tz'etel tz'et tamb'ij chawechak, laj or tipe man jpatronak tijcub'a'tak chi' mex y tioc chi jye'ic jwaak. ");
INSERT INTO uspNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Tzi rechak yak mocom ri tiyuk ta'majtak jwi'l jpatronak tijintak chi ulb'enc, wi tiyuk nic'aj ak'ab' o sakaremchak re cuando tiyuk. ");
INSERT INTO uspNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Pero tatak jcholajl, witi man rajw ja retam nen or titaw man alk'om laj richoch, re tiyo'ri' chi jchajajc, ta' tijye' luwar tioc alk'om laj richoch chi ralk'aj kelen re. ");
INSERT INTO uspNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Y ji'c'ulon atak, ulb'entake jwi'l ta' etemal nen or tipe chic Jc'ajol Kakaj Dios ri xwux pi cristianil, xche' Kakaj Jesús rechak. ");
INSERT INTO uspNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Xpe Pedro, xtz'onaj re Kakaj Jesús: Kajawl, mak esb'i no'j ri, ri attijin chi jb'ijc, ¿pi keke oj o pi rechaki' juntir cristian? xche' re. ");
INSERT INTO uspNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Kakaj Jesús ri Kajawl xij: Jun mocom ri tzi tran laj jchac y tzi jno'j ticojsaji' pire jb'ab'alak mak nic'j mocom chic jwi'l jpatron y ri' re titzukuw rechak lak or re wic'. ");
INSERT INTO uspNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Tzi re man mocom li, ri tiyuk ta'sajok jwi'l jpatron tijin chi jb'anic chapca' xcan b'ijsaj re. ");
INSERT INTO uspNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Kes tz'etel tz'et tamb'ij chawechak chi man patron tijcoja' man mocom li chi jchajaj juntir kelen re ri wi'. ");
INSERT INTO uspNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Pero wi man mocom li tijb'ij laj ranm chi ta' tik'ajch jpatron laj or, tioc chi jseq'uicak yak nic'j mocom chic pach mak ajic', tioc chi wic', tioc chi uc'a'janc y tioc chi k'ab'ric. ");
INSERT INTO uspNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Titaw jun k'ij y titaw jun or ri ta' ric'ab' cuando tiyuk jpatron. Man patron li tijye' jun c'axlaj c'achb'i wich re man jmocom li, tresaj chi jchajaj kelen re, tijtak chijxo'lak mak ri ta' ticojontak. ");
INSERT INTO uspNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Man mocom ri retam nen raj jpatron tran y ta' raj tran, tisec'saji' jwi'l jpatron pire c'achb'i jwich jwi'l ta' tzi tran. ");
INSERT INTO uspNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Man mocom ri ta' retam nen raj jpatron tran y tran kelen ri ta' tzi tiilsajwi' jwi'l jpatron, tisec'saji' pire c'achb'i jwich, pero ta' mas. Nen nim tiye'saj re, masna nim titz'onaj re. Nen wi' mas rekle'n, masna nim ri rajwax tran, xche' Kakaj Jesús rechak. ");
INSERT INTO uspNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Kakaj Jesús xij chic rechak: In ximpe chi jcojic k'ak' neri wich ulew. Y in ri' chwaj chi tichak tijin jc'atic man k'ak' li. ");
INSERT INTO uspNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Y rajwaxi' tina intijna jun nimlaj c'ax y sub'laj c'ax tantij asta titaw man k'ij li. ");
INSERT INTO uspNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Ma b'ij atak chi inwi'lke in tiwa'x utzil chijxo'lak cristian. Jwi'l inwi'lke in tijtos rib'ak yak cristian. ");
INSERT INTO uspNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Lajori ticholmajb'ic, wi wi' job' cristian li jun ja, tijcontriji' rib'ak, uxib' tijcontrijtak mak quib' y mak quib' tijcontrijtak mak uxib'. ");
INSERT INTO uspNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Jun winak tijcontrij jc'ajol y re ticontrij jwi'l jc'ajol. Jun k'apoj anm tijcontrij jchuch y jun alb' tijcontrij man alib'xel y man alib'xel tijcontrij ralb', xche' Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Kakaj Jesús xij rechak sub'laj q'ui cristian: Cuando tawiltak tipe sutz' laj jsuc'lal lamas tikej k'ij, atak tab'ijtak chi tipeti' jab' y tz'eti' tipe jab'. ");
INSERT INTO uspNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Y cuando tatatak tijub'ub' tew li sur tab'ijtak chi tieli' sak'j y tz'eti' tiel sak'j. ");
INSERT INTO uspNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Atak ajsolcopil acayb'alak, atak awetamaki' rilic nen tran caj pach ulew, pero ta' tach'ob'tak chirij mak ri tijin tawiltak la' mak junab' lajori, xche' Kakaj Jesús rechak. ");
INSERT INTO uspNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Kakaj Jesús xtz'onaj rechak: ¿Nen chac ma' tachomorsajtak pi awic'anak lawi' tzi y lawi' ri ta' tzi? ");
INSERT INTO uspNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Wi wi' nen atsiq'uin li k'atb'itzij, jat riq'uil, chomorsaj ayb'ak pi utzil riq'uil laj or cuando b'esalcatak li b'e pire ta' chiqui' atb'e jache' laj jk'ab' man k'atb'itzij, jwi'l wi atjjach laj jk'ab' man k'atb'itzij, tipe man k'atb'itzij atjjach laj jk'ab'ak mak mayor y rechak atjcojtak li cars. ");
INSERT INTO uspNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Tamb'ij chawe chi wi xatkej li cars, ta' atelb'i wi mita' tatoj man q'uisb'i centaw pire atesajb'ic, xche' Kakaj Jesús rechak. ");
INSERT INTO uspNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","La' mak k'ij li, xtawtak nic'j cristian chi rilic Kakaj Jesús y xijtak re nen mo xansaj rechak nic'j cristian aj Galilea ri xcamsajtak jwi'l Pilato cuando tijin tijsujtak awaj re Kakaj Dios. ");
INSERT INTO uspNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Kakaj Jesús xtz'onaj rechak: ¿Ri'c'u chach'ol atak xcamsajtak yak cristian aj Galilea jwi'l wi' mas jmacak chiwchak yak cristian laj jtilmitak? ");
INSERT INTO uspNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Ma' ji'ta'lonli jcholajl. Y jilon atak wi mita' taq'uex ano'jak y ta' tac'am jk'ab'al amacak chiwch Kakaj Dios, tib'ansaji' k'atb'itzij chab'ak chapca' xansaj re yak cristian li. ");
INSERT INTO uspNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","¿O ri'c'u chach'ol atak chi mak waxaklajuj (18) cristian ri xcamtak cuando xtzaakch man tz'aak ri naj rak'aneb' chib'ak ri wi' Siloé, jwi'li' wi' mas jmacak chiwchak juntir cristian ri wi'tak Jerusalén? ");
INSERT INTO uspNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Ma' ji'ta'lonli jcholajl. Pero wi atak ta' taq'uex ano'jak y ta' tac'am jk'ab'al amacak chiwch Kakaj Dios, jilon c'ax tatijtak chapca' xtijtak yak cristian li, xche' Kakaj Jesús rechak. ");
INSERT INTO uspNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Kakaj Jesús xoc chi jb'ij jun esb'i no'j rechak cristian jilonri: Wi' jun winak tiquil jun jche'l higo jwi'l laj rulew. Jun k'ij xe' rile' wi wi'chak jwich, pero ta' xta' ni jun jwich. ");
INSERT INTO uspNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Jwi'li'li xpe man rajw ulew li, xij re man jmocom ri tiak'inan re mak jtico'n: Xi' uxib' junab', nojel junab' tiyuk wile' man jche'l higo wi wi' jwich, pero ni jun b'welt xinta' jwich. Lajori tac'urb'ic, pire ma' tran latz', xche'. ");
INSERT INTO uspNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Pero man mocom xij re rajw man ulew: Kaj, wa'xna cla', re man junab' ri tzi jc'upic rij tamb'an y tanye' abono laj ra'. ");
INSERT INTO uspNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Y wi tiwichin la' man junab' ri, wa'xna cla' y wi mita' tiwichinc, ajruc're' tac'urb'ic, xche' man mocom re man rajw ulew, xche' Kakaj Jesús rechak. ");
INSERT INTO uspNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Li jun k'ij re uxlan, cuando tijin Kakaj Jesús chi jtijojcak cristian re Jyolj Kakaj Dios li jun sinagog ");
INSERT INTO uspNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","y cla' wi' jun sic' anm chijxo'lak cristian, wi'chak waxaklajuj (18) junab' yaj jwi'l jun etzl, t'ust'ic rij tib'en y ta' tijna' tiwa'r pi suc'ulc. ");
INSERT INTO uspNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Kakaj Jesús xril sic' anm li, xsiq'uij y xij re: At anm, lajori xatcolmaji' riq'ui ayaj, xche' re. ");
INSERT INTO uspNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Y xye' jk'ab' laj jb'a sic' anm y sic' anm laj or xtzib'c, xsuc'ulab' rij y xoc chi jb'ixaj jnimirsaj jk'ij Kakaj Dios. ");
INSERT INTO uspNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Pero man jb'ab'al man k'at ri tijmulb'a' rib'ak li sinagog cla', sub'laj xpe retzal chirij Kakaj Jesús jwi'l xtzib'saj sic' anm la' k'ij re uxlan. Jwi'li'li xij rechak juntir cristian: La' nojel xuman wi' wakakib' (6) k'ij pire chac. Y la' mak k'ij li petentak pire attzib'sajtak, ma' ajri' ta' atpetak la' mak k'ij re uxlan, xche' rechak cristian. ");
INSERT INTO uspNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Pero Kakaj Jesús ri Kajawl xij rechak: Atak, atake ajsolcopil acayb'alak, ¿ta'c'u ni jono chawechak ma' tijquirb'i jb'ur o jwacx laj richoch awaj pire tib'e jye' ruc'a' la' k'ij re uxlan? ");
INSERT INTO uspNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Y anm ri, rijajli' Abraham y xana' waxaklajuj (18) junab' jximic jwi'l man etzl la' man yajel ri, ¿ta'c'u tijna' titzib'saj re jyaj la' k'ij re uxlan? xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Cuando xij jilonli Kakaj Jesús rechak, juntir mak ri xcontrin re, xq'uixib'tak chiwch. Pero yak nic'j cristian chic sub'laj xqui'cot ranmak jwi'l xriltak chi Kakaj Jesús tran nimaktak kelen ri sachom ch'olal rilic. ");
INSERT INTO uspNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Kakaj Jesús xij: ¿Nen quiek la' tiniq'uib'sajwi' jtakon Kakaj Dios chib'ak cristian? ¿Nen quiek la' tanniq'uib'sajwi'? ");
INSERT INTO uspNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","In tamb'ij chawechak chi niq'ui' chapca' jun ra íjaj re mostas ri tijtic jun winak laj rulew. Cuando tiq'uiyc, sub'laj nim titaw chapca' rilic jun che' y mak tz'iquin tran jsocak lak jk'ab', xche' Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Kakaj Jesús xij chic: ¿Nen quiek la' tanniq'uib'sajwi' jtakon Kakaj Dios chib'ak cristian? ");
INSERT INTO uspNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Niq'ui' chapca' ch'amk'or ri tijc'am jun anm, tijyuj pach uxib' pajb'l chi c'aj pire tijch'amab'saj juntir man k'or, xche'. ");
INSERT INTO uspNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Kakaj Jesús b'esalc, b'enam re Jerusalén, pi k'axem tran, xk'ax lak jujun tilmit y lak jujun luwar chi jtijoj cristian re Jyolj Kakaj Dios. ");
INSERT INTO uspNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Xpe jun rechak, xtz'onaj re Kakaj Jesús: Kajawl, ¿quib' uxib'inke cristian ticolmajtak laj jk'ab' mac? xche' re. Kakaj Jesús xij re: ");
INSERT INTO uspNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Coj jcowil awanmak chi oquem la' man pwert nuch' jwich, jwi'l sub'laj cristian rajak tioctak la', pero ta' ticwintak. ");
INSERT INTO uspNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Cuando man rajw ja tib'iitc y tijtz'apij man pwert, atak ri watak rij ja, atoctak chi jc'osc'oj man pwert y tab'ijtak: Kaj, teb'a'cojo' man pwert chikawch, atche'tak. Pero re tijb'ij chawechak: Ta' tanch'ob' awchak y ta' wetam lamas atpetak, tiche' chawechak. ");
INSERT INTO uspNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Y atak tab'ijtak chic re: Oji' ri xojwi'n y xojuc'a'janc aac'l y lak b'e re katilmit xkatijoji' cristian re Jyolj Kakaj Dios, atche'tak re. ");
INSERT INTO uspNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Pero re tijb'ij chawechak: Tijin tamb'ij chawechak chi ta' tanch'ob' awchak y ta' wetam lamas atpetak. ¡Elantakb'ic, atak juntir ataka' ajb'analtak etzltak no'j! tiche' chawechak. ");
INSERT INTO uspNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Cla' tib'e awok'b'ej ayb'ak y takuch'uch'uj aweeak cuando tawiltak Abraham, Isaac, Jacob y juntir yak ajk'asaltak Jyolj Kakaj Dios wi'tak li man luwar lamas titakon Kakaj Dios y atak xatcan esajtak. ");
INSERT INTO uspNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","La' mak k'ij li tipetaka' mas cristian, wi' tipetak laj jsuc'lal lamas tielch k'ij y wi' tipetak laj jsuc'lal lamas tikej k'ij y wi' tipetak li norte y wi' tipetak li sur. Juntir rechak tib'e wa'xtak li man luwar lamas titakon Kakaj Dios chapca' ticub'artak chi' mex chi wic'. ");
INSERT INTO uspNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Jwi'li'li wi' jujun rechak ri q'uisb'ire lajori jwi'l ta' cojol jk'ijak, ri'taka' tinab'ertak jwi'l tina cojsajna jk'ijak y wi' jujun rechak ri nab'etak lajori jwi'l nim jk'ijak, ri'taka' ticantak pi q'uisb'ire jwi'l ta' chiqui' ticojsaj jk'ijak, xche' Kakaj Jesús rechak cristian. ");
INSERT INTO uspNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Laj or xtawtak nic'j fariseo riq'ui Kakaj Jesús y xijtak re: Elamb'i neri, Herodes Antipas raj atjcamsaj, xche'tak re. ");
INSERT INTO uspNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Kakaj Jesús xij rechak: Jattak riq'ui man utiwlaj k'atb'itzij y b'ijtatak re: In tina wesajna mak etzl laj ranmak yak cristian y tina intzib'sajtakna yak cristian ri yajtak lajori, chwek' y cab'ij tanq'uis jb'anic juntir inchc, tiche', atche'tak re. ");
INSERT INTO uspNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Pero lajori rajwaxi' tina intakejna jb'anic lawi' ri rajwax tamb'an, chwek' y cab'ij, jwi'l ta' ni jono yak ajk'asaltak Jyolj Kakaj Dios ticam li jun jalan luwar, rajwaxi' ji' ticam Jerusalén, xche'. ");
INSERT INTO uspNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Y xij chic chirijak mak cristian ri wi'tak Jerusalén: ¡Atak aj Jerusalén, atak aj Jerusalén, ri tacamsajtak yak ajk'asaltak Jyolj Kakaj Dios y tasec'tak chi ab'aj yak jtako'n Kakaj Dios ri takaltakch aac'lak! ¡Q'uilaj b'welt roj chwaj xinmulb'a' awchak chapca' tran jun chuch ac' tijmulb'a' tra jk'un ralaj jxic', pero atak ta' chawajak! ");
INSERT INTO uspNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Tatak jcholajl, awichochak tina canna pi cane'l ja. Y tamb'ij chawechak chi lajori ta' chiqui' tawiltak inwch, ajri' tawiltak chic inwch cuando tab'ijtak jilonri: ¡Nim jk'ij ri petzal laj jb'ij Kakaj Dios ri Kajawl! atche'tak, xche' Kakaj Jesús rechak. ");
INSERT INTO uspNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Li jun k'ij re uxlan Kakaj Jesús xe' chi wic' laj richoch jun rechak mak jb'ab'alak mak fariseo. Cla' wi' chiqui' nic'j fariseo xmukche'jtake nen tran Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Cla' wi' jun winak yaj, sub'laj sipo'l. ");
INSERT INTO uspNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Kakaj Jesús xtz'onaj rechak yak ajtijoltak cristian re Jpixb' Kakaj Dios y rechak mak fariseo ri wi'tak la ja cla': ¿Ton jna' titzib'saj jun cristian la' k'ij re uxlan o ta'n? xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Pero rechak ta' xch'a'wtak. Xpe Kakaj Jesús, xchap sic' winak ri yaj, xtzib'saj y xij re chi tib'ec. ");
INSERT INTO uspNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Y Kakaj Jesús xij chic rechak: Wi wi' jono chawechak titzaakb'i jc'ajol o jwacx li jun jul la' k'ij re uxlan, ¿ta'c'u atb'etak jol chi resajc? xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Yak ajtijoltak cristian re Jpixb' Kakaj Dios pach mak fariseo ta' xta'tak nen mo jc'ululaj jyolj Kakaj Jesús xantak. ");
INSERT INTO uspNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Kakaj Jesús cuando xril chi mak ri siq'uiltak chi wic', xcha'tak mak tem ri lamas ticub'artak yak ri wi' rekle'nak, xij jun esb'i no'j rechak jilonri: ");
INSERT INTO uspNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","Cuando wi' jono cristian tib'in chawe chi atb'e riq'uil li nimak'ij re jun tz'am, wi nab'e attaw, mat cub'ar la' man tem lamas ticub'artak yak ri wi' rekle'nak. Jwi'l wi cub'ulcatchak cla' cuando titaw jun mas nim jk'ij chic chawch at, ");
INSERT INTO uspNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","tipe man rajw ja ri xin chawe chi atb'e riq'uil pach man ajri' xtaw, tijb'ij chawe: B'an tok'ob', elan cla', can ye' man tem pire winak ri, tiche' chawe. Y at, atchak q'uixib'c, atb'e cub'ar chic la' man q'uisb'i tem. ");
INSERT INTO uspNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Y jwi'li'li wi tib'ijsaj chawe chi atb'e li nimak'ij re jun tz'am, cub'ren la' man q'uisb'i tem. Jilonli cuando atilsaj jwi'l man ri xin chawe chi atb'e li nimak'ij riq'uil tipe aac'l y tijb'ij chawe: At wichc'ulchi', cub'ren la' man tem ri lamas ticub'artak yak ri wi' rekle'nak, tiche' chawe. Y cuando tib'ansaj jilonli chawe, tinimirsaji' ak'ij chiwchak juntir mak cristian ri wi'tak cla'. ");
INSERT INTO uspNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Jwi'l nen tijcoj jk'ij ric'an, ta' ticojsaj jk'ij y nen ta' tijcoj jk'ij, ri' li ticojsaj jk'ij, xche' Kakaj Jesús rechak. ");
INSERT INTO uspNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Kakaj Jesús xij chic re man winak ri xin re chi tib'e wi'nok riq'uil: At, cuando tab'an jono comon wic' laj awichoch y tab'ij re cristian pire tiyuk wi'ntak aac'l, ma b'ij re yak awichc'ulchi', yak ak'un awatz, yak awech'elxic y yak ac'ulja ri b'iomtak, jwi'l rechak atjsiq'uij chiqui' at chi jtijic wa riq'uilak cuando trantak comon wic'. Jilonli trantak chic chi jye'ic jq'uixel chawe ri xaye' rechak. ");
INSERT INTO uspNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Pero at, cuando tab'an jono comon wic' laj awichoch y wi tab'ij re cristian chi tipetak chi wic' aac'l, b'ij re yak ri wi' rajwax rechak, yak ri ta' tz'akat rakan jk'ab'ak, yak co'x y yak moy. ");
INSERT INTO uspNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Y jilonli sub'laj tzi awe, jwi'l rechak ta' ticwintak chi jye'ic jq'uixel chawe ri taye' rechak. Ajri' tiye'saj jq'uixel chawe cuando tic'astasaj awch laj acamnakl pach yak cristian ri suc'ul ranmak chiwch Kakaj Dios, xche' Kakaj Jesús re. ");
INSERT INTO uspNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Y wi' jun winak cub'ul cla', cuando xta nen xij Kakaj Jesús, re xij: Tzi re jun cristian ri tiwi'n li man luwar lamas titakonwi' Kakaj Dios, xche' re. ");
INSERT INTO uspNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Kakaj Jesús xij: Wi' jun winak xan comon wic' laj richoch y raj roj xtzuke' sub'laj cristian, jwi'li'li xij rechak chi titawtak riq'uil la ja. ");
INSERT INTO uspNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Cuando xtaw or trantak man comon wic', xpe man winak xtak jun jtako'n chi jsiq'uij mak cristian ri quiek re xijwi' chi titawtak laj richoch chi wic' y man tako'n xec', xe' jb'ij rechak: Jo'tak, tijtatak wa laj richoch impatron, wa xantaji'n, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Pero juntir xoctak chi jtz'onaj jcuyb'i jmacak. Wi' jun xij: Cuy immac, ta' imb'antaj imb'ec, jwi'l wi' jun ulew ajri' xinlok' y rajwaxi' imb'e chi rilic, xche'. ");
INSERT INTO uspNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Y jun chic xij: Cuy immac, ta' imb'antaj imb'ec, jwi'l wi' job' yunt inwacx ajri' xinlok' y lajori rajwaxi' tib'e incoje'tak li chac pire twil nen mo tichacuntak, xche'. ");
INSERT INTO uspNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Y jun chic xij: Ta' tijna' imb'ec, jwi'l ajri' xkac'am kib' pach wixokl, xche'. ");
INSERT INTO uspNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Cuando xk'ajch man tako'n ri xtaksajb'i chi jsiq'uijcak, xyuk jb'ij re jpatron juntir nen ri xijsajch re. Man jpatron sub'laj xpe retzal chi jtaic y xij chic re man jtako'n: Lajori jat lak b'e y li c'ayb'l re tilmit, toctach juntir yak ri wi' rajwax rechak, yak ri ta' tz'akat rakan jk'ab'ak, yak moy y yak co'x, xche' re man jtako'n. ");
INSERT INTO uspNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Y cuando xk'ajch man jtako'n, xij: Kaj, xinc'ama'ch yak cristian ri xab'ij chwe, pero ajwi' mas tem, xche' re man jpatron. ");
INSERT INTO uspNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Y man jpatron xij chic re: Lajori jat lak nimaktak b'e y lak k'untak b'e, b'ijta rechak juntir yak cristian ri wi'tak xo'lak b'e chi tipetak laj wichoch, in ri' chwaj tinoj wichoch chi cristian, ");
INSERT INTO uspNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","jwi'l kes tz'etel tz'et tamb'ij chi ni jono rechak yak ri siq'uiltak inwi'l nab'e, tipetak chi wic' laj wichoch, xche' man patron, xche' Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Sub'laj cristian b'esaltak chirij Kakaj Jesús y re xsolcopij rib' chi rilicak y xij rechak: ");
INSERT INTO uspNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","Wi wi' jono ri xam chwij raj tioc pire ajtijol rib' chwij, pero wi masna tijlok'aj jkaj jchuch, rixokl, ralc'wal y rech'elxic o masna tijlok'aj jc'aslemal chinwch in, ta' tzi tioc pire ajtijol rib' chwij. ");
INSERT INTO uspNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Y nen ta' raj tijtij c'ax laj jc'aslemal y tixamb'er chwij, ta' tioc pire ajtijol rib' chwij. ");
INSERT INTO uspNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Wi wi' jono chawechak tran jono richoch sub'laj nim, ¿ta'c'u tijchomorsaj nab'e nen jnimal pwak tichocon jwi'l, wi ton rana' jpwaak o ta'n? ");
INSERT INTO uspNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Jwi'l wi mita' tran jpwaak, xike tijchol jb'anic y ta' tijq'uis jb'anic. Cuando tiilsaj jwi'l cristian chi ta' chiqui' ticwin chi jq'uisic, tijtze'jtak jwich ");
INSERT INTO uspNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","y tijb'ijtak chirij: Man winak xike xchol jb'anic man richoch, pero ta' chiqui' xcwin chi jq'uisic, tiche'tak chirij. ");
INSERT INTO uspNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Wi wi' jono rey raj tib'e ch'o'jin riq'ui jono rey chic, ¿ta'c'u tijchomorsaj nab'e wi ticwini' lajuj mil (10,000) chi soldad chi ch'o'j riq'ui junwinak mil (20,000) chi soldad? ");
INSERT INTO uspNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Tijchomorsaj wi mita' ticwin mak soldad chi ch'o'j, aj naji' ajqui' chi taw mak jcontre cuando tijtakb'i jono jtako'n chi jb'ij re man rey chi ticantak pi utzil pire ma' tich'o'jintak. ");
INSERT INTO uspNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Y ji'c'ulon atak wi wi' jono chawechak ta' tican jye' juntir kelen re ri wi', ta' tzi tioc pire ajtijol rib' chwij, xche' Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Man atz'am tziyi'n, pero wi man atz'am tiel jqui'l ta' chiqui' tijna' tran qui'. ");
INSERT INTO uspNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Ta' chiqui' nen tichacuj, ta' tzi re ulew ni ta' chiqui' tzi pire ticojsaj xo'lak abono, tichak t'ojsajb'ic. Nen titonc, jte' jcholajl ri tamb'ij, xche' Kakaj Jesús rechak cristian. ");
INSERT INTO uspNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Mak ajtz'onaltak alcabar pachak nic'j ajmacb' xjutuntak riq'ui Kakaj Jesús chi jtaic Jyolj Kakaj Dios ri tijin tijb'ij. ");
INSERT INTO uspNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Xpetak mak fariseo pach yak ajtijoltak cristian re Jpixb' Kakaj Dios, xoctak chi yok'on chirijil Kakaj Jesús, xijtak: Man winak ri tijc'ula' mak ajmacb' y tiwi'n riq'uilak, xche'tak chirib'il rib'ak. ");
INSERT INTO uspNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Jwi'li'li Kakaj Jesús xoc chi jb'ij jun esb'i no'j rechak jilonri: ");
INSERT INTO uspNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","Wi wi' jono chawechak wi' jun cient (100) jcarner y tib'e chi jyuk'icak y etke tican saach jun rechak, re tican jye' mak junmuch' b'elejlajuj (99) wich tak'j y tib'e chi jtoquic man jun ri xcan sachok asta tina jta'na. ");
INSERT INTO uspNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Y cuando tib'e jte'ch, tichak qui'cotc, tijt'ojch rij jkul, tipetc. ");
INSERT INTO uspNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Y cuando titaw laj richoch, tijtak jsiq'uij yak richc'ulchi' pach yak jc'ulja y tijb'ij rechak: Qui'cotentak wiq'uil jwi'l xinta' man incarner ri xsaachc, tiche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Kes tz'etel tz'et tamb'ij chawechak chi wi' mas qui'cotemal lecj cuando jun ajmac tijc'am jk'ab'al jmac chiwch Kakaj Dios chiwchak yak junmuch' b'elejlajuj (99) cristian ri q'uexelchak jno'jak jwi'lak y suc'ulchak ranmak chiwch Kakaj Dios, xche' Kakaj Jesús rechak. ");
INSERT INTO uspNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Kakaj Jesús xij chic: Wi wi' jono anm wi' lajuj (10) jpwaak y tijtzak jun jpwaak la ja, ¿ta'c'u tijtzij jk'ak' chi jtoquic? Y, ¿ta'c'u tioc chi jmesic jpam richoch y tijtoc jpwaak laj mes asta tina jta'na? ");
INSERT INTO uspNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Y cuando tijta' man pwak, tijtak jsiq'uij juntir yak richc'ulchi' pach yak jc'ulja y tijb'ij rechak: Qui'cotentak wiq'uil jwi'l xinta' impwaak ri xintzakc, tiche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Kes tz'etel tz'et tamb'ij chawechak, cuando wi' jono ajmac tijc'am jk'ab'al jmac chiwch Kakaj Dios, yak ranjl Kakaj Dios sub'laj tiqui'cottak, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Kakaj Jesús xij chic jun esb'i no'j rechak cristian jilonri: Wi' jun winak wi' quib' jc'ajol. ");
INSERT INTO uspNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Xpe man k'unixel, xij re jkaj: Tat, jach chwe lajori lawi' ri textament ri tajach chwe nen or, xche' re jkaj. Xpe jkajak, xjach chiwchak nen jnimakl tito'ntak chi quib' rib'ilak. ");
INSERT INTO uspNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Ajri'ke quib' uxib' k'ij jjachic textament rechak, xpe man k'unixel xoc chi jc'ayaj lawi' ri xjachsaj re. Xc'amb'i man pwak li, xe' chinaj li jun tilmit chic. Cla' xoc chi jsachic jpwaak lak etzltak kelen ri raj re tran laj jc'aslemal. ");
INSERT INTO uspNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Man c'ojol winak li xq'uis juntir jpwaak chi sachem. Xpe jun nimlaj wi'jal li tilmit ri lamas wi'w, re sub'laj xc'ok jwi'l wi'jal. ");
INSERT INTO uspNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Xe' jtz'onaj jchac riq'ui jun winak cla'. Xpe man winak li, xtakb'i chi rilb'ej aak laj rulew. ");
INSERT INTO uspNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Man c'ojol winak li sub'laj ticam jwi'l wi'jal, rajti ranm tijtij man jlo' aak, pero ta' tiye'saj luwar re tijtij. ");
INSERT INTO uspNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Ajruc're' xcuxtaj jwi'l, xoc chi jchomorsaj laj ranm y xij: Sub'laj mocom wi' riq'ui inkaj, rechak ta' ajlal jwaak tijtijtak y ruc' in incam jwi'l wi'jal neri. ");
INSERT INTO uspNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Lajori ink'aj la ja riq'ui inkaj y tamb'ij re: Tat, cuy immac, xintoca' immac chiwch Kakaj Dios y chawch at. ");
INSERT INTO uspNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Ta' chiqui' tic'ular pi we tab'ij chi ini' ac'ajol, in acoje' pi jun amocom, inche' re, xche' laj ranm. ");
INSERT INTO uspNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Jilonli xchomorsaj xk'aj la ja riq'ui jkaj. Aj naji' wi'w re ja cuando xilsajb'i jwi'l jkaj y jkaj cuando xril jwich jc'ajol, sub'laj xril c'ur jwich. Xe' jol chi jc'ulic, xk'aluj y xtz'ub'aj. ");
INSERT INTO uspNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Xpe jc'ajol, xij: Tat, cuy immac, xintoca' immac chiwch Kakaj Dios y chawch at. Ta' chiqui' tic'ular pi we tab'ij chi ini' ac'ajol, xche' re jkaj. ");
INSERT INTO uspNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Xpe jkaj, xij re yak jmocom: Esajtakch jono kuslaj itz'ik cla', cojtak chirij laj or y cojtak jun matk'ab' la' jk'ab' y jxajb' la' rakan. ");
INSERT INTO uspNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","C'amtatakch man tio'jlaj wacx, camsajtak, katije'tak, kab'ane'tak nimak'ij, ");
INSERT INTO uspNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","jwi'l inc'ajol ri chinch'ol in xcami'n, pero nic' riq'uil xc'astasaji' jwich laj jcamnakl. Xsaachna, pero lajori xk'aj chiqui'ch, xche'. Jilonli xcholtak jb'anic jun nimak'ij. ");
INSERT INTO uspNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Y man nab'eal re jc'ajol b'esali' li chac y cuando xk'ajch, xtaw chijc'ulel ja ri'chak tijta tichak tijin k'ojom re nimak'ij la ja y xojoj. ");
INSERT INTO uspNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Xpe re, xsiq'uij jun mocom, xtz'onaj re nen chac tijin nimak'ij la ja. ");
INSERT INTO uspNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Man mocom xij re: Jwi'l xyuki' ak'un, akajak xtak jcamsaj man tio'jlaj wacx y xan jun nimak'ij pi re jwi'l tziyi' jwich ta' nen xta'w, xche' re. ");
INSERT INTO uspNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Sub'laj xpe retzal man nab'eal cuando xta chi jilonli xijsaj re, ta' chiqui' raj tioc la ja. Xe'na jkaj chi jb'ij re chi tioc la ja. ");
INSERT INTO uspNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Re xij re jkaj: Sub'laj junab' inchacunak aac'l y ni jun b'welt miti b'anal inwi'l ri inatakwi'. Y ni jun q'uisic' sipal chwe awi'l pire tamb'an jono nimak'ij pach yak wichc'ulchi'. ");
INSERT INTO uspNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Ruc' lajori cuando xyuk ac'ajol ri, ri xe' jq'uise'ch apwaak chi sachem riq'ui mak tz'i'taklaj anm, xataka' jcamsaj man tio'jlaj wacx pire jnimak'j, xche' re jkaj. ");
INSERT INTO uspNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Jkaj xij re: At walc'wal, at wati' wiq'uil y juntir kelen we ri wi' awechi'n. ");
INSERT INTO uspNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Pero lajori pi jcholajli' tikab'an nimak'ij chirij ak'un jwi'l chinch'ol in xcami'n, pero nic' riq'uil xc'astasaji' jwich laj jcamnakl. Xsaachna, pero xk'aj chiqui'ch, xche' winak re jc'ajol, xche' Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Kakaj Jesús xij chic jilonri rechak yak ajtijol rib'ak chirij: Wi' jun winak sub'laj b'iom y wi' jun jmocom wi' pire jb'ab'al mocom chi jchajaj juntir kelen re. Xpetak nic'j cristian, xe' jb'ijtak re man b'iom chi man mocom li tijin tijq'uis juntir kelen re. ");
INSERT INTO uspNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Xpe man b'iom, xtak jsiq'uij man jb'ab'al mocom y cuando xtaw man jmocom riq'uil xtz'onaj re: ¿Nen tab'ij chirij ri xyuk b'ijsaj chwe jwi'l cristian chawij? Lajori chwaj twetemaj nen jb'anic juntir kelen we ri jachal laj ak'b' inwi'l, jwi'l lajori ateli' li chac wiq'uil, xche' re man mocom. ");
INSERT INTO uspNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Man jb'ab'al mocom xoc chi jchomorsaj laj ranm nen tran, xij: ¿Nen tamb'an lajori jwi'l impatron ta' chiqui' tijye' inchc? Y ta' chiqui' inchok'b' chi chac y wi tantz'onaj limoxn xo'lak b'e, q'uixib'al pi we, xche'. ");
INSERT INTO uspNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Etke xyuk laj ranm, xij: Lajori wetamchak nen tamb'an pire inc'ulsaj laj richoch jono cristian cuando inesajb'i laj inchc neri, xche'. ");
INSERT INTO uspNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Xtak jsiq'uijcak chi jujunal mak cristian ri wi' jc'asak riq'ui jpatron y xtz'onaj re man xtaw nab'e: ¿Jurub' ac'as riq'ui impatron? xche' re. ");
INSERT INTO uspNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Y man winak ri wi' jc'as, xij: B'elejeb' cient riq'ui oxc'al waxaklajuj (978) galón aceit olivo inc'as, xche'. Y xpe man jb'ab'al mocom, xij re: Co' ri jwujal man ac'as, lajori cub'ren y c'am man awuj y tz'ib'aj xilj chi quejab' cient riq'ui jun much' b'elejeb' (489) galónke ac'as, xche' re. ");
INSERT INTO uspNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Cuando xtaw chic man jun ri wi' jc'as, xtz'onaj re: Y at, ¿jurub' ac'as riq'ui impatron? xche' re. Man winak ri wi' jc'as, xij: Jun cient (100) quintal chi trig inc'as, xche'. Y xpe man jb'ab'al mocom, xij re: Co' ri jwujal man ac'as, lajori cub'ren y c'am man awuj y tz'ib'aj xilj chi junmuch' (80) quintalke ac'as, xche' re. ");
INSERT INTO uspNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Cuando xta man patron nen mo mak no'j ri tijin tran man jb'ab'al mocom, sub'laj xsaach jch'ol chi jtaic mak jno'j. Mak cristian ri retake wich ulew wi'na mas jno'jak chi jchomorsaj rij mak kelen ri, chiwchak yak cristian ri wi'takchak chi sak jwi'l wi'takchak laj jk'ab' Kakaj Dios. ");
INSERT INTO uspNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Tamb'ij chawechak chi cojtak mak ab'iomilak ri reke wich ulew pire atcwintak chi jta'ic mas awichc'ulchi'ak y cuando tiq'uis juntir ab'iomilak, wi' nen atc'uluwtak li jun luwar ri ta' jq'uisic lamas atjekertak. ");
INSERT INTO uspNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Nen jun cristian tzi tran re junquitz, tziyi' tran cuando tiye'saj mas re. Pero nen jun cristian ta' tzi tran re junquitz, ta' tzi tran cuando tiye'saj mas re. ");
INSERT INTO uspNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Atak wi ta' tzi tab'antak chirij ab'iomilak ri reke wich ulew, ¿nenc'u tiye'w tz'etel b'iomil re lecj chawechak ri ta' jq'uisic? ");
INSERT INTO uspNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Y wi mita' tzi ano'jak chirijak mak kelen ri ma' awechak ta'n, ¿nenc'u tiye'w chawechak lawi' ri awechak? ");
INSERT INTO uspNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Ta' ni jono mocom ticwin chi chac riq'ui quib' patron, jwi'l tina jxutna jun y tijlok'aj jun chic. Ticojon chiwch jun y ta' ticojon chiwch jun chic. Atak ta' atcwintak chi jb'anic lawi' raj Kakaj Dios tab'antak wi tib'e awanmak chirij b'iomil ri reke wich ulew, xche' Kakaj Jesús rechak. ");
INSERT INTO uspNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Mak fariseo cuando xtatak nen xij Kakaj Jesús, xritz'b'ejtak jwich jwi'l rechak ri' b'esal ranmak chirij jb'iomilak. ");
INSERT INTO uspNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Kakaj Jesús xij rechak mak fariseo: Atak tacoj ak'ijak chiwchak cristian chi suc'uli' awanmak chiwch Kakaj Dios, pero Kakaj Dios retami' nen achomorsa'n laj awanmak. Nen jono cojol jk'ij jwi'lak cristian xutuli' jwi'l Kakaj Dios, xche' Kakaj Jesús rechak mak fariseo. ");
INSERT INTO uspNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Kakaj Jesús xij chic rechak: Ojr ri' xijsaj rechak cristian ri tijb'ij Jpixb' Kakaj Dios pach ri xcan jtz'ib'ajtak yak ajk'asaltak Jyolj Kakaj Dios asta cuando xyuk Juan Ajb'anal Ja'tiox. Y la' mak junab' re Juan Ajb'anal Ja'tiox xticarch jb'ij tzilaj jtaquil re nen mo titakon Kakaj Dios chib'ak cristian. Jwi'li'li sub'laj q'ui tijin tijcoj jcowil ranmak chi jcojic jyolj Juan Ajb'anal Ja'tiox pire tioctak laj jk'ab' Kakaj Dios. ");
INSERT INTO uspNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Ta' mas c'ax wi tisaach jwich caj pach ulew chiwch tisaach jwich junquitz re Jpixb' Kakaj Dios pach ri xcan jtz'ib'ajtak yak ajk'asaltak Jyolj Kakaj Dios. ");
INSERT INTO uspNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Wi wi' jono winak tican jache' rixokl y tic'uli'y chic riq'ui jun anm chic, chiwch Kakaj Dios tijin trechb'ej jun anm ri ma' jc'ulajl ta'n. Y wi wi' jono winak tic'uli'y riq'ui man anm ri xcan jachsajok jwi'l richjil, chiwch Kakaj Dios tijin trechb'ej jun anm ri ma' jc'ulajl ta'n, xche' Kakaj Jesús rechak. ");
INSERT INTO uspNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Kakaj Jesús xij chic: Wi' jun winak sub'laj b'iom ri tijcoj kustaklaj itz'ik y nojel k'ij tran kustaklaj comon wic'. ");
INSERT INTO uspNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Y wi' jun sic' winak ri jb'ij Lázaro q'uisil rij li ch'a'c' y tijtz'onaj limoxn. Re ticub'ar lak ulew chi' pwert riq'ui man b'iom. ");
INSERT INTO uspNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Y sic' winak li ri' raj tijtij mak jxerc' wa ri titzaak xe' mex riq'ui man b'iom. Y tipetak mak tz'i' tioctak chi jrek'ic jwich mak ch'a'c' chirij sic' winak. ");
INSERT INTO uspNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Cuando xtaw jun k'ij xcam sic' winak li, xc'amsajb'i jwi'lak yak anjl lamas wi' Abraham. Y cuando xcam man b'iom xe' muksajok. ");
INSERT INTO uspNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Cuando man b'iom tijin tijtij c'ax li man luwar ri lamas tic'olsaj jsantilak camnakib', xna'tunb'ic, xrilb'i Abraham wi' li jun luwar sub'laj naj y wi Lázaro riq'uil. ");
INSERT INTO uspNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Y man b'iom sub'laj cow xch'a'wc, xijb'i re Abraham: Kaj Abraham, ilcojo' c'ur inwch. B'an tok'ob' chwe, b'ij re Lázaro chi tijmu'chcojo' b'a jk'ab' li ja' y tiyuk jorob'saj b'a wak' la', jwi'l in mas c'ax tijin tantij neri li k'ak', xche' man b'iom. ");
INSERT INTO uspNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Pero Abraham xij re: At walc'wal, cuxtaj awi'l chi at xatija' utzil laj ac'aslemal cuando xatwa'x wich ulew. Pero Lázaro sub'laj c'ax xtij cuando xwa'x wich ulew, ajri' neri xyuk jte' utzil y at ajri' cla' xyuk atije' c'ax. ");
INSERT INTO uspNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Pero lajori wi' jun nimlaj xeleb'xan laj kaxo'l aac'lak, jwi'li'li ta' ni jono rechak mak ri wi'tak neri tijna' tik'axtakb'i cla' y ta' ni jono rechak mak ri wi'tak cla' tijna' tik'axtakch neri, xche' Abraham re. ");
INSERT INTO uspNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Y man b'iom xij chic re Abraham: Kaj Abraham, b'an jun tok'ob' chwe, takb'i Lázaro laj richoch inkaj. ");
INSERT INTO uspNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Cla' ajwi'taka' job' yak wech'elxic chic y tib'e jb'ijcojo' rechak chi mi ran rechak chapca' ximb'an in pire ma' tipetak neri lamas titijsaj sub'laj c'ax, xche' re Abraham. ");
INSERT INTO uspNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Abraham xij chic re: Pi rechak wi' Jpixb' Kakaj Dios ri xcan tz'ib'aj jwi'l Moisés y wi' Jyolj Kakaj Dios ri xcan jtz'ib'ajtak yak ajk'asaltak Jyolj Kakaj Dios ojrtaktzij y ri' li jcoje'tak nen tijb'ij, xche' Abraham re. ");
INSERT INTO uspNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Y man b'iom xij chic: Tz'eti'n, Kaj Abraham, pero wi wi' jono tic'astasaj jwich laj jcamnakl xo'lak camnakib' titaw riq'uilak, rechak tijq'uexa' jno'jak chiwch Kakaj Dios, xche' re Abraham. ");
INSERT INTO uspNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Pero Abraham xij chic re: Wi ta' tijcojtak Jpixb' Kakaj Dios ri xcan jtz'ib'aj Moisés y Jyolj Kakaj Dios ri xcan jtz'ib'ajtak yak ajk'asaltak Jyolj Kakaj Dios ojrtaktzij, ri'tic'u chic tijcojtak jyolj jun ri tic'astasaj jwich laj jcamnakl xo'lak camnakib', xche' Abraham re, xche' Kakaj Jesús rechak yak ajtijol rib'ak chirij. ");
INSERT INTO uspNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Kakaj Jesús xij rechak yak ajtijol rib'ak chirij: Coc'xo'lke wi' nen tib'anow re jun cristian tikej li mac. Pero c'ur jwich jun cristian ri tib'anow re jun chic tikej li mac jwi'l masna c'ax tijtij. ");
INSERT INTO uspNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Ri' mas tzi tiximsajb'i jun nimlaj ab'aj re que'm chi jkul y tit'ojsajb'i li mar chiwch tran chi timacun yak ri ta' mas nim jk'ijak ri cub'ul jch'olak chwij. ");
INSERT INTO uspNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","¡Atak cwentijke ayb'ak! Wi wi' jono awech'elxic chwij tib'anow c'ax chawe, k'el chirij ri tijin tran y wi tijq'uex jno'j, cuy jmac. ");
INSERT INTO uspNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Y wi wi' jun k'ij tran wukub' (7) b'welt c'ax chawe y wukub' (7) b'welt tiyuk aac'l chi jtz'onaj jcuyic jmac chawch y tijb'ij: Cuy immac, ta' chiqui' tamb'an, tiche' chawe, cuy jmac, xche' Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Y yak jtako'n Kakaj Jesús ri Kajawl xijtak re: Ye' mas jcub'arb' kach'ol chawij, xche'tak re. ");
INSERT INTO uspNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Kakaj Jesús ri Kajawl xij rechak: Witi cub'ul ach'olak chwij chapca' jnimal jun ra b'ak' jwich mostas, atcwintaka' tab'ijtak re man nim che' ri, jilonri: B'uk'b'i ayb' neri y tib'e atique' ayb' li mar, atche'tak re y man che' ticojoni' chawchak, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Kakaj Jesús xij chic rechak yak jtako'n: Y wi wi' jono chawechak wi' jono jmocom tijtakb'i li chac chirij wacx o tijtakb'i chi jyuk'ic rawj y cuando tik'ajch man mocom li, ta' tijb'ij re man mocom: Tzaj, cub'ren, tij aw, ta' tiche' re. ");
INSERT INTO uspNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Re tijb'ij: B'an jwa'x wa re tantij re sinar y ye'ch b'a mex, incolajna in nab'e, ajruc're' tatij chic aw at, tiche' re. ");
INSERT INTO uspNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Y ta' rajwax tic'omowaj re man mocom li jwi'l ri' xan juntir nen ri xijsaj re. ");
INSERT INTO uspNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Y ji'c'ulon atak cuando tab'antak juntir ri tijb'ij Kakaj Dios chawechak, b'ijtak: Oj, ojke mocom ri ta' nen ojchoconwi', jwi'l xike xkab'an lawi' raj Kakaj Dios xkab'an, atche'tak, xche' Kakaj Jesús rechak. ");
INSERT INTO uspNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Kakaj Jesús cuando b'enam re Jerusalén xk'axb'i laj xo'lak Samaria pach Galilea. ");
INSERT INTO uspNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Cuando xtaw li jun luwar, xpetak lajuj (10) chi winak chi jc'ulic, wi' yajel chirijak ri jb'ij lepra. Mak winak li ta' xjutuntak chijc'ulel Kakaj Jesús, ji'ke xwa'rtakch chinaj re, ");
INSERT INTO uspNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","xijtakch re: Kaj Jesús Ajtijonl, il c'ur kawch riq'ui kayaj, xche'takch re Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Kakaj Jesús cow xrilb'i mak winak y xij rechak: Jattak, c'utta ayb'ak chiwchak yak ajc'amaltak jb'eak cristian riq'ui Kakaj Dios, xche' rechak. Rechak xe'tak y cuando b'esaltak lak b'e b'enam rechak riq'ui yak ajc'amaltak jb'eak cristian riq'ui Kakaj Dios, xel man yajel chirijak y xtzib'tak. ");
INSERT INTO uspNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Jun rechak mak winak li cuando xril chi xtzib'i'n, xk'aj riq'ui Kakaj Jesús, tichak ch'ejej chi jnimirsaj jk'ij Kakaj Dios. ");
INSERT INTO uspNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Y cuando xtaw riq'ui Kakaj Jesús xxucaj rib' chiwch y xxulb'a' jcayb'al asta xtaw chi' jwich lak ulew chi jc'omowaj re chi xtzib'i'n. Y man winak li aj Samariayi'n. ");
INSERT INTO uspNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Kakaj Jesús xij: ¿Miti lajuji' rib'ilak mak winak ri xtzib'tak? ¿Lac'umas xe'tak mak b'elejeb' chic? ");
INSERT INTO uspNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","¿Xic'uke jun winak ri, ri ma' rijajl ta' Israel xk'ajch chi jnimirsaj jk'ij Kakaj Dios chi xtzib'i'n? xche'. ");
INSERT INTO uspNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Kakaj Jesús xij re man winak: B'iiten y jat laj awichoch, xattzib'i' jwi'l xcub'ar ach'ol chwij, xche'. ");
INSERT INTO uspNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Mak fariseo xtz'onajtak re Kakaj Jesús nen or tipe jtakon Kakaj Dios chib'ak cristian wich ulew. Y Kakaj Jesús xij rechak: Jtakon Kakaj Dios chib'ak cristian wich ulew ta' tiilsaj cuando tipetc. ");
INSERT INTO uspNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Ni jonok tib'in chi wi' neri o wi' jili, jwi'l jtakon Kakaj Dios wi'chak chaxo'lak, xche' re mak fariseo. ");
INSERT INTO uspNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Y xij chic rechak yak ajtijol rib'ak chirij: Tina tawna jun k'ij atak rajti awanmak wi'ti chic chaxo'lak Jc'ajol Kakaj Dios ri xwux pi cristianil, pero ta' chiqui' tawiltak jwich. ");
INSERT INTO uspNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Y wi wi' cristian tib'in chawechak: Jc'ajol Kakaj Dios ri xwux pi cristianil wi' neri o wi' jili, tiche'tak, pero ma cojowtak y mat b'etak chi rilic. ");
INSERT INTO uspNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Jwi'l cuando titaw k'ij tipe chic wich ulew Jc'ajol Kakaj Dios ri xwux pi cristianil, jilon jpetic chapca' jun coyop tijkopajch rib' li jun lad re caj, tijsakab'saji' juntir xe' caj. ");
INSERT INTO uspNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Pero nab'e tina jtijna sub'laj c'ax y tina xutsajna jwi'lak mak cristian ri wi'tak re mak junab' lajori. ");
INSERT INTO uspNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Y cuando titaw k'ij tipe chic wich ulew Jc'ajol Kakaj Dios ri xwux pi cristianil, cristian trana'taka' chapca' xantak cristian la' mak junab' cuando xwa'x Noé wich ulew. ");
INSERT INTO uspNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Mak cristian li xtakejtak jb'anic lawi' rajak rechak trantak. Rechak tiwi'ntak, tik'ab'artak, tic'uli'ytak y tijc'ulb'a' ralc'walak asta cuando xtaw k'ij xjaw Noé li arc. Xchol jun nimlaj k'alaj y xsaach jwich juntir ri wi'tak wich ulew. ");
INSERT INTO uspNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Jilon trantak chapca' xantak mak cristian la' mak junab' cuando xwa'x Lot li tilmit Sodoma. Mak cristian li xe' ranmak chirij jwaak, chirij k'ab'ric, chirij lok'omanc, chirij c'ayinc, chirij tico'n y chi b'anojtak ja. ");
INSERT INTO uspNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Pero cuando xelb'i Lot li tilmit Sodoma xpe k'ol pach k'ak' lecj, xkej chib' man tilmit li y juntir mak cristian ri wi'tak li man tilmit xsaach jwichak li k'ak'. ");
INSERT INTO uspNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Y cuando tik'aj chicch wich ulew Jc'ajol Kakaj Dios ri xwux pi cristianil jilon c'ax li tijtijtak mak cristian ri ta' ticojontak chiwch Kakaj Dios. ");
INSERT INTO uspNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Y cuando titaw k'ij li, nen wi' b'a ja, mi oc chic chi resaj kelen re la ja y nen wi' lak chac mi k'aj chic laj richoch. ");
INSERT INTO uspNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Ri' cuxtaj awi'lak nen xansaj re rixokl Lot ojr. ");
INSERT INTO uspNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Nen jono cristian ta' raj tijye' rib' pi camic jwi'lke tran lawi' raj Kakaj Dios tran, tisaachi' jwich, pero nen tijye' rib' pi camic inwi'l in, ticolmaji'n. ");
INSERT INTO uspNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","In tamb'ij chawechak cuando titaw k'ij li, li jun ak'ab' wi'tak quib' chi waraj chib' jun ch'at, jun tic'amsajb'ic y jun tican ye'sajok. ");
INSERT INTO uspNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Y wi' quib' anm, nic' tijintak chi que'm, jun tic'amsajb'ic y jun tican ye'sajok. ");
INSERT INTO uspNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Y wi'tak quib' winak, nic' tijintak li chac, jun tic'amsajb'ic y jun tican ye'sajok, xche' Kakaj Jesús rechak yak ajtijol rib'ak chirij. ");
INSERT INTO uspNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Cuando xtatak yak ajtijol rib'ak chirij chi jilonli xij, xtz'onajtak re: Kajawl, ¿lac'umas tib'anwi' jilonli? xche' rechak. Kakaj Jesús xij rechak: Lamas wi' jun camnak awaj, cla' tijmulb'a' rib'ak mak c'uch, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Kakaj Jesús xij jun esb'i no'j rechak yak ajtijol rib'ak chirij pire tijc'ut chiwchak chi rajwaxi' coc'xo'lke tich'a'wtak riq'ui Kakaj Dios y ta' tijquib'aj ranmak. ");
INSERT INTO uspNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Xij rechak: Wi' jun k'atb'itzij xwa'x li jun tilmit, ta' tijcoj jk'ij Kakaj Dios y ta' tijcoj jk'ij ni jun cristian. ");
INSERT INTO uspNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Y li man tilmit li wi' jun anm ri camnak richjil, sic' anm li q'uilaj b'welt titaw riq'ui man k'atb'itzij chi jtz'onaj k'atb'itzij, re ri' raj tib'an k'atb'itzij chirij jun jcontre. ");
INSERT INTO uspNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Man k'atb'itzij xe' quib' uxib' k'ij ta' raj tran jk'atb'itzij chirij, pero cuando xtaw jun k'ij xq'uistaj ranm chi rilic sic' anm, xij laj ranm: Onque ta' tancoj jk'ij Kakaj Dios y ta' tancoj jk'ijak mak cristian, ");
INSERT INTO uspNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","pero jwi'l man anm ri, ri camnak richjil, nojel k'ij tiyuk chi jtz'onaj k'atb'itzij chwe, lajori tamb'an k'atb'itzij chirij man jcontre jwi'l wi mita' tamb'an k'atb'itzij chirij man jcontre tiq'uistaj wanm jwi'l nojel k'ij tiyuk wiq'uil, xche' man k'atb'itzij, xche' Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Y Kakaj Jesús ri Kajawl xij chic rechak: Tatak jcholajl nen xij man k'atb'itzij ri ta' suc'ul ranm chiwch Kakaj Dios. ");
INSERT INTO uspNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Y, ¿ri'tic'u chic Kakaj Dios ma' tijt'o' laj or yak cristian ri cha'l jwi'l ri tich'a'wtak riq'uil chi lak'j chi lak'ab'? ");
INSERT INTO uspNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Pero in tamb'ij chawechak chi atjt'owa'taka' laj or. Pero cuando tipe chic wich ulew Jc'ajol Kakaj Dios ri xwux pi cristianil, ta' etemal jurub' cristian tiyuk jte' ri cub'ul jch'olak chirij, xche' Kakaj Jesús rechak yak ajtijol rib'ak chirij. ");
INSERT INTO uspNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Wi' nic'j rechak mak cristian ri tijb'ijtak laj ranmak chi rechak suc'uli' ranmak chiwch Kakaj Dios, pero tijxuttak yak nic'j cristian chic, jwi'li'li Kakaj Jesús xij jun esb'i no'j rechak jilonri: ");
INSERT INTO uspNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Wi' quib' winak xe'tak li nimi richoch Kakaj Dios chi ch'a'wem riq'ui Kakaj Dios, jun fariseo y jun ajtz'onal alcabar. ");
INSERT INTO uspNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Man fariseo pi wa'l xoc chi ch'a'wem riq'ui Kakaj Dios, xij: At, Kakaj Dios, tanc'omowaj chawe chi in, ma' in ta' nic' chapca' mak nic'j cristian chic, pur alk'omtak y nic'j chic pur etzl jno'jak re cristian y nic'j chic tijrechb'ejtak jun cristian chic ri ma' jc'ulajlak ta'n y ma' in ta' nic' chapca' man jun ajtz'onal alcabar ri. ");
INSERT INTO uspNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","In tamb'ana' cacab' k'ij ayun re nojel xuman y nen jnimal tanch'ec, tanya' jlájuj chawe, xche' man fariseo. ");
INSERT INTO uspNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Pero man ajtz'onal alcabar xcan wa'r chinaj re man fariseo y cuando xch'a'w riq'ui Kakaj Dios xxulb'a' jcayb'al lak ulew. Re ta' xb'it jcayb'al lecj, xike xt'ic chi jch'ol chi k'ab' y xij re Kakaj Dios: At, Kakaj Dios, il c'ur inwch, cuy immac. In, ini' jun ajmac chawch, xche'. ");
INSERT INTO uspNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Kes tz'etel tz'et tamb'ij chawechak chi man ajtz'onal alcabar li, cuando xk'aj laj richoch, suc'ulchak ranm chiwch Kakaj Dios, pero man fariseo ta' xsuc'ulab' ranm chiwch Kakaj Dios. Jwi'l nen jonok tijcoj jk'ij ric'an, ta' ticojsaj jk'ij, pero nen ta' tijcoj jk'ij, ri' li ticojsaj jk'ij, xche' Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Jun k'ij xc'amsajtakb'i mak tral ac'l riq'ui Kakaj Jesús pire tijye' jk'ab' laj jb'aak, pero cuando xriltak yak ajtijol rib'ak chirij, xk'eltak mak cristian ri xc'amowtakb'i mak tral ac'l riq'ui Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Pero Kakaj Jesús xsiq'uij mak tral ac'l y xij rechak yak ajtijol rib'ak chirij: Ma k'eltak, ye'tak luwar rechak mak tral ac'l tipetak wiq'uil jwi'l jtakon Kakaj Dios chib'ak cristian pirechi' yak ri chapca' tral ac'l ri. ");
INSERT INTO uspNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Kes tz'etel tz'et tamb'ij chawechak chi nen ta' tijc'ul jtakon Kakaj Dios chapca' jun ral ac'l ta' tioc lamas titakon Kakaj Dios chib'ak cristian, xche' Kakaj Jesús rechak yak ajtijol rib'ak chirij. ");
INSERT INTO uspNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Jun winak ri nim jk'ij chijxo'lak yak rijajl Israel xtz'onaj re Kakaj Jesús: At, Tzilaj Ajtijonl, ¿nen rajwax tamb'an pire tanta' tzilaj c'aslemal riq'ui Kakaj Dios lecj ri ta' jq'uisic? xche' re. ");
INSERT INTO uspNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Xpe Kakaj Jesús, xtz'onaj re: ¿Nen chac tab'ij chwe chi ini' tzi? Ta' ni jun tzi, xike Kakaj Dios ri tzi. ");
INSERT INTO uspNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Awetami' Jpixb' Kakaj Dios ri tijb'ij jilonri: Ma wechb'ej jun jalan cristian wi ma' ac'ulajl ta'n, mat camsanc, mat alk'anc, ma' mol tzij chirij jun cristian y coj jk'ij akaj achuch, tiche', xche' re. ");
INSERT INTO uspNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Man winak li xij re Kakaj Jesús: Juntir li xincoja'ch pi aj in ac'l, xche'. ");
INSERT INTO uspNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Cuando xta Kakaj Jesús chi jilonli xij man winak, xij chic re: Ajwi' jun kelen rajwax tina ab'anna. C'ayta juntir kelen awe ri wi' y man rijil tajach chiwchak yak ri wi' rajwax rechak. Jilonli tiwa'xi' sub'laj utzil pi awe riq'ui Kakaj Dios lecj pi jq'uexwach ab'iomil, ajruc're' atpe wiq'uil pire atxamb'er chwij, xche' re. ");
INSERT INTO uspNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Man winak li, cuando xta chi jilonli xijsaj re, sub'laj xb'ison jwi'l sub'laj b'iomi'n. ");
INSERT INTO uspNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Kakaj Jesús cuando xril chi tichak b'isonc, xij: Sub'laj c'ax roquicak mak b'iom lamas titakon Kakaj Dios chib'ak cristian. ");
INSERT INTO uspNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Ri' ta' mas c'ax jk'axic jun camello laj b'ak' jwich jun acux chiwch roquic jun b'iom lamas titakon Kakaj Dios chib'ak cristian, xche'. ");
INSERT INTO uspNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Cuando mak cristian xtatak chi jilonli, xijtak re Kakaj Jesús: Wi jilonli, ta' ni jun ticolmaj laj jk'ab' jmac, xche'tak re. ");
INSERT INTO uspNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Kakaj Jesús xij chic rechak: Pi rechak cristian ta' ni jonok ticwinc, pero Kakaj Dios ta' ni jun kelen ma' ticwin chi jb'anic, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Xpe Pedro, xij re Kakaj Jesús: Oj xcani' kaye' juntir kelen ke ri wi' y xojxamb'eri' chawij, xche' re. ");
INSERT INTO uspNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Kakaj Jesús xij: Kes tz'etel tz'et tamb'ij chawechak nen jono cristian tican jye' richoch, jkaj jchuch, rech'elxic, rixokl y ralc'wal jwi'lke tijb'ij nen mo titakon Kakaj Dios chib'ak cristian, ");
INSERT INTO uspNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","tijc'ula' sub'laj nim jq'uixel neri wich ulew y tijta' tzilaj c'aslemal riq'ui Kakaj Dios lecj ri ta' jq'uisic, xche' Kakaj Jesús rechak. ");
INSERT INTO uspNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Kakaj Jesús xsiq'uijb'i pi ric'anak yak cab'lajuj (12) jtako'n y xij rechak: Lajori ojb'etak Jerusalén lamas titawi' chiwch juntir ri xcan jtz'ib'ajtak yak ajk'asaltak Jyolj Kakaj Dios chirij Jc'ajol Kakaj Dios ri xwux pi cristianil. ");
INSERT INTO uspNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Re tijachsaj laj jk'ab'ak yak ma' rijajl ta' Israel, rechak tritz'b'ejtak jwich, tijyok'tak y tijchub'ajtak jwich. ");
INSERT INTO uspNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Tijsec'tak y tijcamsajtak, pero laj jrox k'ij tina c'astasajna jwich laj jcamnakl, xche' Kakaj Jesús rechak. ");
INSERT INTO uspNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Pero rechak ta' xtatak jcholajl nen tielwi' ri xijsaj rechak jwi'l Kakaj Jesús, jwi'l ta' ye'l luwar rechak tretemajtak jcholajl. ");
INSERT INTO uspNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Cuando tawem tran Kakaj Jesús Jericó, wi' jun sic' moy cub'ul chi' b'e tijin tijtz'onaj limoxn. ");
INSERT INTO uspNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Cuando sic' moy xta chi sub'laj cristian tijin tik'axtak, re xtz'onaj rechak cristian nen tijin tib'anc. ");
INSERT INTO uspNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Mak cristian xijtak re chi Kakaj Jesús aj Nazaret tijin tik'ax cla'. ");
INSERT INTO uspNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Xpe re, cow xch'ejejc, xij: ¡Kaj Jesús, Jc'ajol David, il c'ur inwch! xche'. ");
INSERT INTO uspNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Xpetak mak cristian ri nab'etakb'ic, xk'eltak, ri' rajak ta' chiqui' tich'a'wc, pero mas chiqui' cow xch'ejejc, xij chic: ¡Jc'ajol David, il c'ur inwch! xche'. ");
INSERT INTO uspNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Kakaj Jesús xwa'rc, xtak jc'amic sic' moy. Cuando xtaw sic' moy chijc'ulel, xtz'onaj re: ");
INSERT INTO uspNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","¿Nen chawaj tamb'an chawe? xche' re. Sic' moy xij: Wajawl, chwaj inna'tunc, xche' re. ");
INSERT INTO uspNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Kakaj Jesús xij chic re: Na'tunok. Xattzib'i' jwi'l xcub'ar ach'ol chwij, xche' re. ");
INSERT INTO uspNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Y sic' moy laj or xna'tunc y xamb'erb'i chirij Kakaj Jesús, tichak tijin chi jb'ixaj jnimirsaj jk'ij Kakaj Dios. Y jilon juntir mak cristian ri xiliwtak nen xansaj re sic' moy, xb'ixajtak jnimirsaj jk'ij Kakaj Dios. ");
INSERT INTO uspNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Kakaj Jesús b'enam re xk'axb'i li man tilmit Jericó. ");
INSERT INTO uspNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Y cla' wi' jun b'iomlaj winak ri jb'ij Zaqueo, ri jb'ab'alak mak ajtz'onaltak alcabar. ");
INSERT INTO uspNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Y Zaqueo ri' raj tijch'ob' jwich Kakaj Jesús, pero ta' tijna' tril jwich chijxo'lak sub'laj cristian jwi'l re ta' naj rakan. ");
INSERT INTO uspNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Jwi'li'li xnab'er jol, ri' raj tril jwich, xe' jaw b'a jun che' ri jb'ij sicómoro ri wi' chi' b'e lamas tik'axwi' Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Cuando Kakaj Jesús xk'ax cla', xna'tunja' b'a che' y xij re Zaqueo: Zaqueo, kejench laj or, lajori rajwaxi' tamb'an imposad laj awichoch, xche' re. ");
INSERT INTO uspNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Ajruc're' Zaqueo xkejch laj or b'a che', tiqui'cot xyuk jc'ule' Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Y juntir cristian, cuando xriltak jilonli, xoctak chi yok'on chirijil Kakaj Jesús, xijtak: Winak ri xe' rane' jposad laj richoch jun ajmac, xche'tak. ");
INSERT INTO uspNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Xpe Zaqueo, xwab'a' rib' chiwch Kakaj Jesús, xij re: Wajawl, lajori pajnic'j re juntir kelen we ri wi' tanjacha' chiwchak yak ri wi' rajwax rechak y wi wi' cristian xinsub'tak pire xwesaj mas pwak chirijak, tank'asaji' jq'uixel cajmul rechak mas chiwch ri jnimal ri xwesaj chirijak, xche' re. ");
INSERT INTO uspNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Kakaj Jesús xij: Lajori yak cristian ri wi'tak la ja neri xcolmajtaka' laj jk'ab' jmacak, jwi'l winak ri tz'etel rijajli' Abraham. ");
INSERT INTO uspNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Jc'ajol Kakaj Dios ri xwux pi cristianil xpe wich ulew pirechi' tiyuk jtoque' yak ri sache'ltak jwi'l jmacak pire ticolmajtak laj jk'ab' jmacak, xche' Kakaj Jesús rechak. ");
INSERT INTO uspNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Cuando yak cristian tijin tijtatak nen tijb'ij Kakaj Jesús, xpe Kakaj Jesús xij chic jun esb'i no'j rechak jwi'l tawem trantak Jerusalén y yak cristian chijch'ol rechak laj or triltak titakon Kakaj Dios chib'ak. ");
INSERT INTO uspNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Kakaj Jesús xij rechak: Wi' jun winak nim jk'ij xe' chinaj li jun jalan tilmit chic pire tiye'saj rekle'n pire tioc re rey laj jtilmit, ajruc're' tik'aj chicch. ");
INSERT INTO uspNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Cuando b'enam tran xsiq'uij lajuj (10) rechak mak jmocom. Xcan jye' jujun pwak rechak chi jujunalak sub'laj nim jwich y xij rechak: Yecomantak la' man pwak ri asta cuando ink'aj chicch, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Pero mak cristian laj tilmit ta' rajak jwich man winak li y chirij re xtaktak chicb'i nic'j cristian chi jb'ij li man tilmit li, jilonri: Oj ta' chikaj tioc man winak li pire karey laj katilmit, xche'tak. ");
INSERT INTO uspNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Pero re xye'saji' rekle'n pire rey y xk'aj chicch laj jtilmit. Y cuando xtaw laj jtilmit, xtak jsiq'uijcak mak jmocom ri quiek re xcan jye' jpwaak cuando xec', jwi'l raj tretemaj nen jnimakl xch'ectak chirij man pwak chi jujunalak. ");
INSERT INTO uspNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Cuando xtaw man nab'e mocom ri quiek re xcan jye' pwak, xij re: Kaj, apwaak ri xcan aye' chwe, xch'eca' lajuj (10) jq'uiyal chapca' xcan aye' chwe, xche' re. ");
INSERT INTO uspNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Y man rey xij re: Tziyi' xab'an, ati' jun tzilaj mocom. Jwi'l tziyi' xab'an re jun raquitz, lajori atoc pire k'atb'itzij chib' lajuj (10) chi tilmit, xche' re. ");
INSERT INTO uspNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Xtaw man jcab' mocom chic, xij re: Kaj, apwaak ri xcan aye' chwe, xch'eca' job' jq'uiyal chapca' xcan aye' chwe, xche' re. ");
INSERT INTO uspNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Xpe man rey, xij re man mocom li: At, atoc pire k'atb'itzij chib' job' tilmit, xche' re. ");
INSERT INTO uspNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Pero xtaw man jun mocom chic, xij re: Kaj, co' apwaak ri. Ximpis li jun sut' y xinc'ol, ");
INSERT INTO uspNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","jwi'l xtzaak inch'ol chi jcojic jwi'l wetami' chi mas at c'a'n y atoch'on lamas ta' nen tiquil awi'l, xche' man mocom re man rey. ");
INSERT INTO uspNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Xpe man rey, xij re man mocom li: At, ati' jun etzl mocom y ayolj titz'onin k'atb'itzij chawij, jwi'l wi awetami' chi masi' in c'a'n y inoch'on lamas ta' tiquil inwi'l, ");
INSERT INTO uspNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","xac'amtene'b'i impwaak xe'tene' aye' pi kejom re jonok y cuando xinyuk wi'tene'chak ral impwaak roj xinc'ule', xche' re. ");
INSERT INTO uspNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Xpe man rey, xij rechak yak cristian ri wi'tak cla': Majtak man pwak re y ye'tak re man immocom ri xch'ecow lajuj (10) jq'uiyal chapca' ri jq'uiyal impwaak xcan inye' re, xche'. ");
INSERT INTO uspNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Y yak cristian ri wi'tak cla', xijtak re: Kaj, pero re wi'chak lajuj (10) jq'uiyal chapca' ri jq'uiyal apwaak xcan aye' re, xche'tak re. ");
INSERT INTO uspNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Man rey xij chic rechak: In tamb'ij chawechak nen wi' mas riq'uil, tiye'saj chiqui' mas re, pero nen ta' re, asta raquitz ri wi' riq'uil, timajsaji' re. ");
INSERT INTO uspNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Y tamb'ij chawechak chi mak cristian ri incontrintak ri ta' rajak inoc pire rey laj jtilmitak, c'amtatakch y tacamsajtak chinwch, xche' man rey rechak, xche' Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Cuando xijmaj jilonli jwi'l Kakaj Jesús, xnab'er chiwchak yak ajtijol rib'ak chirij xe' Jerusalén. ");
INSERT INTO uspNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Y cuando xtaw chijc'ulel man tilmit Betfagé y man tilmit Betania ri wi'tak wich witz ri jb'ij Olivos, xtakb'i quib' rechak yak ajtijol rib'ak chirij. ");
INSERT INTO uspNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Xijb'i rechak: Jattak li man tilmit ri wi'b'i chawchak. Cuando attawtak cla', tib'e ate'tak jun ra b'ur ximilc, ajqui' ni jono cristian quejawinak re, quirtak y c'amtakch. ");
INSERT INTO uspNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Y wi wi' nen titz'onin chawechak: ¿Nen chac taquirtak man ra b'ur? wi tiche' chawechak, tab'ijtak re: Tike chocon jwi'l Kajawl, atche'tak re, xche' Kakaj Jesús rechak. ");
INSERT INTO uspNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Yak ajtijol rib'ak chirij Kakaj Jesucristo xe'tak. Juntir nen xijsaj rechak jilon xe' jte'tak. ");
INSERT INTO uspNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Cuando tijintak chi jquiric man ra b'ur, xtawtak mak rajw chi rilic y xijtak rechak yak ajtijol rib'ak chirij Kakaj Jesucristo: ¿Nen chac taquirtak man ra b'ur? xche'tak rechak. ");
INSERT INTO uspNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Rechak xijtak rechak mak rajw: Tike chocon jwi'l Kajawl, xche'tak rechak. ");
INSERT INTO uspNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Xc'amtakch man ra b'ur riq'ui Kakaj Jesús, xye'takb'i ritz'ikak ri tijk'u'jtak chirij man ra b'ur, ajruc're' xjawsajtak Kakaj Jesús chirij. ");
INSERT INTO uspNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Y cuando tijin jb'ic Kakaj Jesús xpetak mak cristian xlic' ritz'ikak ri tijk'u'jtak laj jb'e Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Cuando xmajtakch man wich xulan re man wich witz ri jb'ij Olivos, juntir yak ajtijol rib'ak chirij Kakaj Jesucristo xcholtak ch'ejejem jwi'l jqui'cotemak y xnimirsajtak jk'ij Kakaj Dios jwi'l juntir mak c'utb'i jcwinel Kakaj Dios ri ilan jwi'lak, ");
INSERT INTO uspNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","xijtak: ¡Kakaj Dios ri Kajawl wi' jk'ab' chib' rey ri petzal laj jb'ij! ¡Wa'xok utzil lecj! ¡Nimirsajok jk'ij Kakaj Dios lecj! xche'tak. ");
INSERT INTO uspNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Y chijxo'lak mak cristian li, b'esaltaka' nic'j fariseo, rechak xijtak re Kakaj Jesús: Kaj, k'elcojo' yak ajtijol rib'ak chawij, xche'tak re. ");
INSERT INTO uspNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Xpe Kakaj Jesús, xij rechak: Kes tz'etel tz'et tamb'ij chawechak wi tijmaytak ch'ejejem rechak, ri' mak ab'aj tijcholtak ch'ejejem, xche' Kakaj Jesús rechak. ");
INSERT INTO uspNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Kakaj Jesús xtaw chijc'ulel Jerusalén. Cuando xrilb'i jwich man tilmit li, xrok'b'ej rib' chirijak mak cristian ri wi'tak cla' ");
INSERT INTO uspNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","y xij: Atak, ri watak Jerusalén, witi tawetemajtak la' man k'ij ri, nen tiye'w utzil laj awanmak, pero lajori mukuli' chawchak, ta' tijna' tawetemajtak. ");
INSERT INTO uspNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Tina tawna jun k'ij cuando acontrak trantak jun tusum ab'aj chirij juntir atilmitak y rechak tijsuttak awijak pire ma' atelmajtak. ");
INSERT INTO uspNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Y juntir awichochak tijyojtak y ta' chiqui' ni jono ab'aj tican chib' jun chic y atjcamsajtak, jilonli tib'ansaj chawechak jwi'l ta' xawetemajtak cuando xatyuk solajtak jwi'l Kakaj Dios, xche' Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Ajruc're' Kakaj Jesús xoc li nimi richoch Kakaj Dios y xoc chi ruktajb'i juntir mak ajc'ayb' ri wi'tak cla'. ");
INSERT INTO uspNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Xij rechak: Tz'ib'ali' li wuj re Lok'laj Jyolj Kakaj Dios ri tijb'ij jilonri: Wichoch rechi' lamas tib'an ch'a'wem wiq'uil, xche' Kakaj Dios, tiche'. Pero atak cojol pi molb'i rib'ak mak alk'om awi'lak, xche' Kakaj Jesús rechak. ");
INSERT INTO uspNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Kakaj Jesús nojel k'ij xtijojtak cristian re Jyolj Kakaj Dios li nimi richoch Kakaj Dios. Mak jb'ab'alak yak ajc'amaltak jb'eak cristian riq'ui Kakaj Dios y yak ajtijoltak cristian re Jpixb' Kakaj Dios pach mak cristian ri nim jk'ijak chijxo'lak yak rijajl Israel tijin tijtoctak nen mo trantak chi jcamsaj Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Pero ta' tijta'tak nen trantak chi jcamsaj, jwi'l juntir cristian sub'laj kus tijtatak nen tijb'ij Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Li jun k'ij cuando tijin Kakaj Jesús chi jtijojcak cristian li nimi richoch Kakaj Dios xij tzilaj jtaquil rechak nen mo ticolmajtak laj jk'ab' jmacak. Y xtawtak mak jb'ab'alak yak ajc'amaltak jb'eak cristian riq'ui Kakaj Dios, yak ajtijoltak cristian re Jpixb' Kakaj Dios y yak ri wi' rekle'nak chijxo'lak yak rijajl Israel. ");
INSERT INTO uspNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Xpetak rechak, xijtak re Kakaj Jesús: B'ij chike nen xattakow chi jb'anic jilonri y nen xye'w k'atb'itzij laj ak'b' pire tab'an jilonli, xche'tak re. ");
INSERT INTO uspNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Kakaj Jesús xij rechak: Jilon in chwaj tantz'onaj jun kelen chawechak. C'ululajtak inyolj: ");
INSERT INTO uspNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","¿Nen xtakow re Juan Ajb'anal Ja'tiox chi jb'anic ja'tiox? ¿Kakaj Diosni' xtakow re o cristianke? xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Rechak xoctak chi jchomorsaj chirib'il rib'ak, xijtak: Wi tikab'ij chi Kakaj Dios xtakow re Juan Ajb'anal Ja'tiox, li tijb'iji' chike: ¿Nenc'u chac ta' xacojtak jyolj? tiche'. ");
INSERT INTO uspNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Y ta' tijna' tikab'ij chi cristianke takowinakch re. Wi tikab'ij jilonli, mak cristian ojjcamsajtaka' chi ab'aj, jwi'l rechak tijcoja'taka' chi Juan Ajb'anal Ja'tiox ajk'asal Jyolji' Kakaj Dios, xche'tak chirib'il rib'ak. ");
INSERT INTO uspNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Y jwi'li'li xijtak re Kakaj Jesús: Ta' ketam nen takowinakch re, xche'tak. ");
INSERT INTO uspNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Kakaj Jesús xij chic rechak: Jilon in ta' tamb'ij chawechak nen xye'w k'atb'itzij laj ink'b' chi jb'anic jilonri, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Xpe Kakaj Jesús, xij chic jun esb'i no'j rechak cristian jilonri: Wi' jun winak xtic uva laj rulew y xcan jye' man rulew chi kejom rechak nic'j ajchac y xe' chinaj li jun jalan tilmit chic. ");
INSERT INTO uspNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Cuando xtaw k'ij tik'anab' jwichak mak uva, xpe man rajw ulew xtakch jun jtako'n riq'uilak chi jtz'onaj rechak mak ajkejeltak ulew lawi' mak jwich uva ri tiye'saj re pire kejb'ire man ulew. Pero mak ajkejeltak ulew xchaptak man tako'n li, xsec'tak y xk'asajtakb'i chi ta' nen xye'takb'i re. ");
INSERT INTO uspNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Xpe chic man rajw ulew, xtak chicch jun jtako'n chi jtz'onaj lawi' mak jwich uva ri tiye'saj re pire kejb'ire man ulew, pero mak kejewinaktak ulew xsec'tak, xyok'tak y xk'asajtakb'i chi ta' nen xye'takb'i re. ");
INSERT INTO uspNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Xpe chic man rajw ulew, xtak chicch jun jtako'n chic chi jtz'onaj lawi' mak jwich uva ri tiye'saj re pire kejb'ire man ulew. Xpetak chic mak ajkejeltak ulew, xsoctak y xresajtakb'i lak tico'n. ");
INSERT INTO uspNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Xpe man rajw ulew, xij: ¿Nen jono tantakb'ic? Lajori tantakb'i lok'laj inc'ajol chi jtz'onaj lawi' mak jwich uva ri tiye'saj chwe pire kejb'ire man wulew, pent tichak cojontak chiwch, xche'. ");
INSERT INTO uspNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Pero mak ajkejeltak ulew cuando xriltak xtaw jc'ajol man rajw ulew, xijtak chirib'il rib'ak: Ri' re tiechb'en man ulew, lajori kacamsajtak pire tican man ulew ri pi ke oj, xche'tak. ");
INSERT INTO uspNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Xresajtakb'i lak tico'n re uva y xcamsajtak. ");
INSERT INTO uspNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Y, ¿nenc'u tran man rajw mak uva rechak mak ajchac? Re tiyuk jcamsaj mak ajkejeltak ulew y tijye' chic rulew chi kejom re nic'j ajchac chic, xche'. Cuando xtatak mak cristian juntir ri xijsaj rechak, xijtak: ¡Miti tijye' luwar Kakaj Dios titaw chiwch ri xab'ij! xche'tak. ");
INSERT INTO uspNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Xpe Kakaj Jesús cow xril mak cristian y xtz'onaj rechak: ¿Nen mo tielwi' ri tz'ib'al li wuj re Lok'laj Jyolj Kakaj Dios ri tijb'ij jilonri? Man ab'aj ri xcan jxute'tak yak ajb'analtak ja, ri' xoc pire man nab'e ab'aj pire jcowil man ja, tiche'. ");
INSERT INTO uspNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Y nen titzaak chib' man ab'aj li, tik'ajmaji'n. Y nen titzaak man ab'aj li chib', trana' pok, xche' Kakaj Jesús rechak. ");
INSERT INTO uspNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Mak jb'ab'alak yak ajc'amaltak jb'eak cristian riq'ui Kakaj Dios pach yak ajtijoltak cristian re Jpixb' Kakaj Dios rajak roj xchape'tak Kakaj Jesús jwi'l xtatak jcholajl chi chirijaki' rechak xijsaj man esb'i no'j li, pero xtzaak jch'olak chiwchak mak cristian. ");
INSERT INTO uspNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Rechak xtaktakb'i nic'j cristian riq'ui Kakaj Jesús ri xcoj rib'ak chapca' wi' rajwax rechak, pero ta' tz'et, xike tijin tijtoctak nen mo tikej Kakaj Jesús laj jk'ab'ak chirij jono jyolj ri mita' tzi ri tijb'ij pire tijjachtak laj jk'ab' man jb'ab'al k'atb'itzij. ");
INSERT INTO uspNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Y mak winak xijtak re Kakaj Jesús: Ajtijonl, oj ketami' chi tz'etel tz'eti' ri tab'ij y tz'etel tz'eti' ri tijin tatijoj cristian y ta' jaljoj rilic cristian tab'an. ");
INSERT INTO uspNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","¿Tzini' tikatoj alcabar re César o ta'n? xche'tak re. ");
INSERT INTO uspNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Kakaj Jesús retami' mak etzltak jchomorsa'nak, jwi'li'li xij rechak: ");
INSERT INTO uspNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","C'uttakneca' chinwch jun pwak. ¿Nenc'u quiek jcayb'al ri wi' chiwch ri y nen quiek jb'ij ri tz'ib'al chiwch ri? xche' rechak. Rechak xijtak re Kakaj Jesús: Rechi' César, xche'tak re. ");
INSERT INTO uspNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Kakaj Jesús xij chic rechak: Ye'tak re César lawi' re César y ye'tak re Kakaj Dios lawi' re Kakaj Dios, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Y mak winak li ta' xta'tak jono jyolj Kakaj Jesús ri mita' tzi ri xij chiwchak cristian pire tijchaptak. Juntir rib'ilak xsaach jch'olak chi jtaic y ta' chiqui' nen xijtak re. ");
INSERT INTO uspNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Xpetak nic'j saduceo, xe'tak riq'ui Kakaj Jesús. Rechak ta' tijcojtak chi tina c'astasajna jwichak camnakib', jwi'li'li xijtak re Kakaj Jesús: ");
INSERT INTO uspNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Ajtijonl, Moisés xcan jtz'ib'aj pi ke oj chi wi wi' jun winak c'uli'nak ticamc y ta' ralc'walak xwa'xc, rajwaxi' tic'uli'y chic jun jk'un riq'ui man anm li, ri camnak richjil pire tiwa'x ralc'wal riq'uil y ticojsaj pi ralc'wal nab'e winak. ");
INSERT INTO uspNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Wi' jun b'welt wi' wukub' (7) chi winak ri jk'un ratz rib'ak. Man nab'eal xc'uli'yc, pero xcamc y ta' ralc'wal xwa'xc. ");
INSERT INTO uspNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Man jcab'al xc'uli'y chic riq'ui man anm li ri camnak richjil y re xcamc, ta' ralc'wal xwa'xc. ");
INSERT INTO uspNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Y jilon xan man jroxal, xc'uli'y chic riq'ui man anm li y re xcamc. Jilonli xantak chi wukub' (7) rib'ilak xc'uli'ytak riq'ui man anm li y chi wukub' (7) rib'ilak xcamtak y ni jono rechak xwa'x ralc'wal. ");
INSERT INTO uspNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Pi q'uisb'ire xcam man anm li. ");
INSERT INTO uspNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Cuando tic'astasaj jwichak camnakib', ¿nenc'u rechak mak winak trixokolaj man anm li, jwi'l chi wukub' (7) xc'uli'ytak riq'uil? xche'tak mak saduceo re Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Xpe Kakaj Jesús, xij rechak mak saduceo: Neri wich ulew tic'uli'ytaka' cristian. ");
INSERT INTO uspNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Pero yak ri tic'ular pi rechak tib'etak riq'ui Kakaj Dios lecj y tic'astasaj jwichak laj jcamnaklak xo'lak camnakib', rechak ta' chiqui' tic'uli'ytak. ");
INSERT INTO uspNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Rechak ta' chiqui' ticamtak jwi'l ji'chaklontak chapca' yak anjl. Ralc'wal takchak Kakaj Dios jwi'l c'astasalchak jwichak laj jcamnaklak. ");
INSERT INTO uspNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Moisés xin chi yak camnakib' tic'astasaji' jwichak laj jcamnaklak jwi'l re cuando xch'ab'ejch jwi'l Kakaj Dios li jun nimlaj mat lo'quiej ri tijin jc'atic, xijsaj re chi Kakaj Dios ri Kajawl, ri' ri jDios Abraham, Isaac y Jacob. ");
INSERT INTO uspNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Kakaj Dios ma' jDios ta' yak camnakib', jDiosaki' yak ri yo'ltak. Jwi'li'li juntir ri wi'tak laj jk'ab' Kakaj Dios onque ticamtak, pero chiwch Kakaj Dios, yo'ltaka'n, xche' Kakaj Jesús rechak. ");
INSERT INTO uspNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Xpetak nic'j ajtijoltak cristian re Jpixb' Kakaj Dios, xijtak re Kakaj Jesús: Ajtijonl, tz'etel tz'eti' ri xab'ij, xche'tak re. ");
INSERT INTO uspNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Y ta' chiqui' ni jonok xc'otow jchi' Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Xpe Kakaj Jesús, xtz'onaj rechak cristian: ¿Nen chac tib'ijsaj chi ri b'il jwi'l Kakaj Dios chi tina jtaknach wich ulew rijajli' David? ");
INSERT INTO uspNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Pero David xcan tz'ib'anok li wuj re Salmos ri tijb'ij jilonri: Kakaj Dios ri Kajawl xiji' re Wajawl: Cub'ren laj impaach ");
INSERT INTO uspNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","asta tina injachna laj ak'b' juntir yak ri atcontrinc, xche' re, tiche'. ");
INSERT INTO uspNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","¿Nen mo jun ri, ri b'il jwi'l Kakaj Dios tina jtaknach wich ulew, rijajli' David, cuando David xiji' Wajawl re? xche' Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Kakaj Jesús chiwchak juntir cristian ri tijin tijtatak jyolj xij rechak yak ajtijol rib'ak chirij jilonri: ");
INSERT INTO uspNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","Tacwentij ayb'ak riq'ui yak ajtijoltak cristian re Jpixb' Kakaj Dios. Rechak ri' mas tzi tric'ajtak tijcojtak nimak rakan ritz'ikak cuando tiwo'cottak y tzi triltak tic'amsaj rutzil jwichak lak c'ayb'l pi c'utb'ire chi nimi' jk'ijak. Rechak ri' tijtoctak mak tem ri lamas ticub'artak yak ri wi' rekle'nak lak sinagog. Y jilon trantak cuando tib'etak li jono nimak'ij. ");
INSERT INTO uspNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Tresajtak kelen rechak chirijak yak anm ri camnak richjilak y pire b'amb'i jwichak chiwchak cristian sub'laj naj trantak chi ch'a'wem riq'ui Kakaj Dios. Jwi'li'li masna c'ax k'atb'itzij tib'ansaj chib'ak jwi'l Kakaj Dios, xche' Kakaj Jesús rechak. ");
INSERT INTO uspNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Cuando wi' Kakaj Jesús li nimi richoch Kakaj Dios xril chi mak cristian b'iom tican jye'tak pwak li mak cax re c'ulb'i pwak ri tisipaj re Kakaj Dios. ");
INSERT INTO uspNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Y xril chic jun sic' anm powr ri camnak richjil, xye' li jun cax quib' tra pwak ri ta' nimak jwich. ");
INSERT INTO uspNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Xpe Kakaj Jesús, xij: Kes tz'etel tz'et tamb'ij chawechak chi sic' anm powr ri camnak richjil ri' xye'w mas chiwchak juntir ri tijye'tak pwak li cax re c'ulb'i pwak ri tisipaj re Kakaj Dios. ");
INSERT INTO uspNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Juntir mak b'iom li, ri' tijye'tak ri mita' tijq'uistak chi sachem. Ruc' sic' anm powr ri camnak richjil xya' juntir ri wi' riq'uil re tzukb'i rib', xche' Kakaj Jesús rechak. ");
INSERT INTO uspNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Nic'j ajtijol rib'ak chirij Kakaj Jesucristo tijin tiyolowtak chirij nimi richoch Kakaj Dios, tijb'ijtak chi poc kus rilic juntir ab'aj ri cojol re y poc kus rilic juntir mak tra ritz'ab'l ri sipal jwi'lak cristian. Xpe Kakaj Jesús, xij rechak: ");
INSERT INTO uspNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Tina tawna jun k'ij chi juntir ri tijin tawiltak lajori, ta' chiqui' ni jono ab'aj tican chib' jun chic. Juntir li tina yojmajna, xche' rechak yak ajtijol rib'ak chirij. ");
INSERT INTO uspNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Xpe yak ajtijol rib'ak chirij, xoctak chi jtz'onaj re Kakaj Jesús: Kajtijonl, ¿nen or titaw chiwch ri xab'ij? ¿Nenc'u retal ri tiilsaj pire c'utb'ire chikawch chi tawem tran ri xab'ij chike? xche'tak re Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Xpe Kakaj Jesús, xij rechak: Tike acwentij ayb'ak pire ma' atsub'sajtak, jwi'l sub'laj q'ui tina petakna y tijcoj rib'ak chapca' in, tijb'ijtak: Ini' ri b'il jwi'l Kakaj Dios chi tina jtaknach wich ulew y tichak taw q'uisb'itak k'ij re jwich k'ijsak, tina che'takna. Pero atak ma cojowtak y ma takejtak. ");
INSERT INTO uspNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Atak cuando tatatak jtaquil chi tijini' nimaktak ch'o'j li jono luwar, mi tzaak ach'olak jwi'l jilonli tina b'anna, pero ma' ri' ta' li k'ij re q'uisb'itak k'ij re jwich k'ijsak, ");
INSERT INTO uspNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","jwi'l jun nimlaj tilmit tina ch'o'jinna riq'ui jun tilmit chic y jun rey tina ch'o'jinna riq'ui jun rey chic. ");
INSERT INTO uspNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Tina ranna nimaktak cab'rakn, tina pena sub'laj wi'jal, tina pena sub'laj yajel lak jaljojtak luwar y tina c'utunna kelen sub'laj tzakom ch'olal rilic lecj. ");
INSERT INTO uspNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Pero cuando ajqui' chi b'ansaj juntir li, atak atna chapsajtakna y tina b'ansajna c'ax chawechak. Tina b'ansajna k'atb'itzij chawijak lak sinagog y atna cojsajtakna li cars y atna c'amsajtaknab'i chiwchak mak rey inwi'lke in. ");
INSERT INTO uspNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Jilonli tijna' tab'ijtak chi tz'eti' ri ilan y tal awi'lak chwij. ");
INSERT INTO uspNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Ma chomorsajtak nen tab'ijtak chi jcolic ayb'ak, ");
INSERT INTO uspNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","jwi'l tanya' ano'jak pach ayoljak nen tab'ijtak y yak acontrak ta' chiqui' tijta'tak nen mo trantak chi jk'atic jwich ayoljak. ");
INSERT INTO uspNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Pero atak, atna jachsajtakna li c'ax jwi'lak akaj achuchak, ak'un awatzak, awech'elxicak y awichc'ulchi'ak. Y wi' jujun chawechak tina jachsajtakna pi camic. ");
INSERT INTO uspNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Juntir cristian ri ta' ticojontak chiwch Kakaj Dios atna retzelb'ejtakna y atna jcontrijtakna inwi'lke in, ");
INSERT INTO uspNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","pero ta' ni jono rusumal áb'ak tisaachc. ");
INSERT INTO uspNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Wi mita' taquib'aj awanmak asta atcamtak, atcolmajtaka' laj jk'ab' amacak. ");
INSERT INTO uspNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Cuando tawiltak chi sutulchak rij Jerusalén jwi'lak soldad, cuxtaj awi'lak chi tichak yojsaj man tilmit li. ");
INSERT INTO uspNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Cuando tawiltak jilonli, yak cristian ri wi'tak lak luwar re Judea rajwaxi' laj or tielmajtakb'i b'ak witz y yak cristian ri wi'tak Jerusalén rajwaxi' laj or tielmajtakb'i cla' y yak cristian ri esaltakb'i li tilmit mi k'ajtak chic li tilmit, ");
INSERT INTO uspNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","jwi'l tina pena sub'laj c'ax chib'ak cristian pire titaw chiwch ri tz'ib'al li wuj re Lok'laj Jyolj Kakaj Dios. ");
INSERT INTO uspNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","¡C'ur jwichak yak yaj anm la' mak k'ij li pach yak ri wi' jne'ak tijtu'tzajtak, jwi'l rechak ta' tijna' tielmajtak laj or jwi'l wi' jun nimlaj c'ax petzal chib'ak cristian wich ulew y chib'ak juntir cristian li man tilmit li! ");
INSERT INTO uspNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Wi' jujun ticamsajtak chi espad y nic'j chic tic'amsajtakb'i li cars lak juntir tilmit. Y Jerusalén tiwa'x laj jk'ab'ak yak ri ma' rijajl ta' Israel pire titakontak chib'ak asta tina tz'akatna nen jnajtil ri ye'l rechak chi jilon trantak li, xche' Kakaj Jesús rechak yak ajtijol rib'ak chirij. ");
INSERT INTO uspNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Kakaj Jesús xij chic rechak yak ajtijol rib'ak chirij: Ajruc're' tiilsaj retal lecj ri sachom ch'olal rilic chirij k'ij y chirij ic' y chirij ch'umil. Juntir cristian wich ulew tisaach jch'olak y sub'laj titzaak jch'olak cuando tijtatak sub'laj tijumum mar pach mak retumb re b'a mar. ");
INSERT INTO uspNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Mak cristian timak'uj ranmak jwi'l tzakom ch'olal chi jchomorsaj nen tib'an wich ulew, jwi'l triltak chi juntir ri wi' lecj tiyucxij laj jluwrak. ");
INSERT INTO uspNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Ajruc're' triltak Jc'ajol Kakaj Dios ri xwux pi cristianil tikejch lecj li sutz' sub'laj tikopopon jk'ak'al jnimal jk'ij y wi' sub'laj jcwinel. ");
INSERT INTO uspNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Cuando tijchol juntir mak retal li ri b'il inwi'l, cowirsaj awanmak, b'it acayb'alak lecj jwi'l tawemchak tran man k'ij re atcolmajtak laj jk'ab' amacak, xche'. ");
INSERT INTO uspNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Kakaj Jesús xij chic jun esb'i no'j rechak yak ajtijol rib'ak chirij jilonri: Atak, cojtak retal jun jche'l higo o nic'j che' chic. ");
INSERT INTO uspNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Cuando tawiltak tiel chicch jxak ac'al, atak awetamakchak chi petemchak re riq'uil sak'j. ");
INSERT INTO uspNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Y ji'c'ulonli cuando tawiltak chi tichak tijin titaw chiwch juntir ri ximb'ij chawechak, etemajtak chi jtakon Kakaj Dios chib'ak cristian nakajchakwi'w. ");
INSERT INTO uspNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Kes tz'etel tz'et tamb'ij chawechak chi ajqui' chi camtak juntir cristian ri wi'tak wich ulew re mak junab' ri cuando titaw chiwch juntir ri ximb'ij chawechak. ");
INSERT INTO uspNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Caj pach ulew tisaachi' jwichak, pero tina tawna chiwch juntir ri ximb'ij chawechak. ");
INSERT INTO uspNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Tike acwentij ayb'ak, mi b'e awanmak chi jb'anic lawi' ri chawajak tab'antak y mi b'e awanmak chi k'ab'ric y chirij kelen awechak laj ac'aslemalak, jwi'l wi ri' tib'e awanmak chirij juntir li, ta' awic'ab'ak cuando titaw man k'ij li ");
INSERT INTO uspNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","chapca' jun chapb'i ca'n pi awechak y jilon jpetic man k'ij li chib'ak juntir cristian wich ulew. ");
INSERT INTO uspNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Chajintake y coc'xo'l ch'a'wentak riq'ui Kakaj Dios pire atcolmajtak laj jk'ab' juntir c'ax ri tina pena ri ximb'ij chawechak y pire tijna' attawtak chiwch Jc'ajol Kakaj Dios ri xwux pi cristianil, xche' Kakaj Jesús rechak yak ajtijol rib'ak chirij. ");
INSERT INTO uspNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Kakaj Jesús lak'j tijtijoj cristian li nimi richoch Kakaj Dios y lak'ab' ji' tib'e wa'xok b'a witz ri jb'ij Olivos. ");
INSERT INTO uspNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Y juntir cristian sub'laj ak'ab' titawtak li nimi richoch Kakaj Dios pire tib'e jte'tak Jyolj Kakaj Dios ri tijb'ij rechak. ");
INSERT INTO uspNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Tawem tran nimak'ij re titijsaj cuxlanwa ri ta' ch'amk'or la' y man nimak'ij li tib'ijsaji' Pascua re. ");
INSERT INTO uspNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Mak jb'ab'alak yak ajc'amaltak jb'eak cristian riq'ui Kakaj Dios pach yak ajtijoltak cristian re Jpixb' Kakaj Dios tijintak chi jtoquic nen mo trantak chi jcamsaj Kakaj Jesús chi mukukil jwi'l tike tzaak jch'olak chiwchak cristian. ");
INSERT INTO uspNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Xpe man jb'ab'al etzl, xoc laj ranm Judas ri tib'ijsaj Iscariote re. Judas ri' jun rechak yak cab'lajuj (12) ajtijol rib'ak chirij Kakaj Jesucristo. ");
INSERT INTO uspNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Xpe re, xe' rile' mak jb'ab'alak yak ajc'amaltak jb'eak cristian riq'ui Kakaj Dios pach mak jb'ab'alak mak ajchajaltak re nimi richoch Kakaj Dios y xchomorsaj riq'uilak nen mo tran chi jjachic Kakaj Jesús laj jk'ab'ak. ");
INSERT INTO uspNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Rechak sub'laj xqui'cottak, xijtak re Judas chi tijya'taka' pwak re wi tijjach. ");
INSERT INTO uspNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Judas sub'laj tzi xta y xoc chi jtoquic no'j nen mo tran chi jjachic Kakaj Jesús laj jk'ab'ak cuando ta' cristian riq'uil. ");
INSERT INTO uspNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Xtaw k'ij re man nimak'ij ri titijsaj cuxlanwa ri ta' ch'amk'or la' y cuando ticamsaj ra c'ojol carner pire man nimak'ij Pascua. ");
INSERT INTO uspNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Xpe Kakaj Jesús, xij rechak Pedro pach Juan: Jattak, b'antatak jwa'x kasinar re nimak'ij Pascua, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Rechak xtz'onajtak re Kakaj Jesús: ¿Lamas chawaj tib'e kab'ane' jwa'x? xche'tak re. ");
INSERT INTO uspNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Kakaj Jesús xij rechak: Cuando atoctak Jerusalén, tata'tak jun winak c'amalb'i jun k'ib' ja' jwi'l. Takejtakb'i asta la' man ja lamas tiocwi'. ");
INSERT INTO uspNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","B'ijtak re man rajw ja: Tijb'ij Kajtijonl: ¿Lamas wi' man cwart lamas tantijwi' insinar re Pascua pach yak ajtijol rib'ak chwij? tiche', atche'tak re, xche' Kakaj Jesús rechak. ");
INSERT INTO uspNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Y man rajw ja tijc'ut jun nimlaj cwart chawchak laj jcab' wik re man ja ri b'analchak jwa'xc, cla' tab'antak jwa'x kasinar, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Rechak xe'tak. Y jilon jta'ic, xe' rane'tak chapca' xijb'i Kakaj Jesús rechak y xantak jwa'x sinar re Pascua. ");
INSERT INTO uspNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Cuando xtaw or re sinar, Kakaj Jesús pach yak jtako'n xcub'artak chi' mex. ");
INSERT INTO uspNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Kakaj Jesús xij rechak: Sub'laj rayal inwi'l tantij sinar re Pascua aac'lak nab'e chiwch titaw or incamsajc. ");
INSERT INTO uspNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Tamb'ij chawechak chi ta' chiqui' ni jun b'welt tamb'an chic sinar re Pascua aac'lak, ajri' chiqui' cuando titaw chiwch ri jtakon Kakaj Dios chib'ak cristian, xche' Kakaj Jesús rechak. ");
INSERT INTO uspNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Ajruc're' Kakaj Jesús xc'am jun nejb', xc'omowaj re Kakaj Dios, xij: C'amtak ra nejb' ri y tij awechak ri wi' xilj, xche'. ");
INSERT INTO uspNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Tamb'ij chawechak chi in ta' chiqui' tantij vin re uva aac'lak asta ajri' cuando tipe jtakon Kakaj Dios chib'ak cristian, xche' Kakaj Jesús rechak. ");
INSERT INTO uspNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Ajruc're' xc'am jun cuxlanwa, xc'omowaj re Kakaj Dios y xq'uer. Xye' rechak yak ajtijol rib'ak chirij, xij: Ri' ri intio'jl ri ticamsaj chi jtojic amacak. B'antak jilonri pi cuxtib'iwe, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Y jilon xan re man nejb', cuando xcolajtak re sinar, xc'am man nejb' y xij: Man ri wi' li nejb' ri' inquiq'uel ri quiek la' xaan man aac' chomorsa'n y tina tz'utuwna chi jtojic jmacak sub'laj cristian. ");
INSERT INTO uspNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Man ri injachow pi camic lajori wi' wiq'uil chi' mex. ");
INSERT INTO uspNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Jc'ajol Kakaj Dios ri xwux pi cristianil jilon tib'an re chapca' ri b'il jwi'l Kakaj Dios ojr, pero ri' mas c'ur jwich man ri tijachow re pi camic, xche' Kakaj Jesús rechak yak ajtijol rib'ak chirij. ");
INSERT INTO uspNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Ajruc're' yak ajtijol rib'ak chirij Kakaj Jesucristo xoctak chi jtz'onaj chirib'il rib'ak nen rechak tib'anow jilonli. ");
INSERT INTO uspNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Xpetak yak ajtijol rib'ak chirij Kakaj Jesucristo, xoctak chi jtz'onaj chirib'il rib'ak nen rechak mas nim jk'ij chijxo'lak rechak. ");
INSERT INTO uspNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Xpe Kakaj Jesús, xij rechak: Mak jreyak yak ma' rijajl ta' Israel tijchomorsajtak chi wi' mas takon laj jk'ab'ak chib'ak yak jwinakak y mak nimaktak jb'ab'alak tib'ijsaji' chirijak chi tziyi' trantak. ");
INSERT INTO uspNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Pero chaxo'l atak, ma' ji'ta'lonli, ri mas nim jk'ij chaxo'lak, tina ranna chapca' jun ac'l ri ta' nim jk'ij y ri titakonc, tina ranna chapca' jun tako'n. ");
INSERT INTO uspNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","¿Nenc'u mas nim jk'ij? ¿Roni' ri man titzuksaj b'a mex o ri' man ri titzukunc? ¿Ma' ronta'c'u nim jk'ij ri titzuksaj b'a mex? Pero in win chaxo'lak jilon imb'anic chapca' jun tako'n. ");
INSERT INTO uspNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Atak xatwa'xtaka' wiq'uil chi jtijic c'ax, ");
INSERT INTO uspNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","jwi'li'li in tanya' takon laj ak'b'ak chapca' tiye'saj chwe in jwi'l Inkaj. ");
INSERT INTO uspNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Y atak, atwi'ntaka' y atuc'a'jantaka' wiq'uil b'a mex lamas intakon chib'ak juntir cristian. Tanye' k'atb'itzij laj ak'b'ak pire atcub'artak chib'ak mak cub'arb' chi jb'anic k'atb'itzij chib'ak yak cab'lajuj (12) k'at rijajl Israel, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Kakaj Jesús xij re Simón Pedro: Simón, Simón, man jb'ab'al etzl xatjtz'onajtaka' pire atjtostak chwij, tran chawechak chapca' jpu'ic mak b'ak' jwich trig. ");
INSERT INTO uspNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Pero in sub'laj tantz'onaj tok'ob' re Kakaj Dios chawij pire ma' taquib'aj awanm chwij. Y cuando taq'uex ano'j y ticub'ar chic ach'ol chwij, ye' jcowil ranmak yak apach ri xamtak chwij, xche' re. ");
INSERT INTO uspNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Simón Pedro xij re: Wajawl, chomorsali' inwi'l chi imb'i' chawij wi atb'e li cars y tanjacha' wib' pi camic pi apach wi atcamsajc, xche' re Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Kakaj Jesús xij re: Pedro, in tamb'ij chawe chi wica jorok ab'iji' oxmul chi ta' tach'ob' inwch cuando tiok' man puy, xche' re. ");
INSERT INTO uspNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Xpe Kakaj Jesús, xij rechak yak ajtijol rib'ak chirij: Cuando xatintaktakb'ic, ximb'ij chawechak chi ta' tac'amtakb'i c'olb'i apwaakak y ta' tac'amtakb'i achimak, ni ta' axajb'ak tac'amtakb'ic. ¿Ta'c'u xtz'akat ri xye'saj chawechak re juntir ri rajwax chawechak? xche' rechak. Y rechak xijtak: Xtz'akati'n, xche'tak. ");
INSERT INTO uspNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Y xij chic rechak: Pero lajori nen chawechak wi' jchim jc'ame'b'ic y nen wi' c'olb'i jpwaak jc'ame'b'ic y nen ta' respad jc'ayaj ritz'ik ri tijk'u'j y jlok'e' jono re. ");
INSERT INTO uspNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","In tamb'ij chawechak chi lajori titaw chiwch ri tz'ib'al li wuj re Lok'laj Jyolj Kakaj Dios chwij ri tijb'ij jilonri: Xcojsaji' laj rajlalak mak etzltak cristian, tiche'. Y juntir ri tz'ib'al li wuj re Lok'laj Jyolj Kakaj Dios chwij titawi' chiwch, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Y rechak xijtak re: Kajawl, neri wi' quib' espad, xche'tak re. Y re xij chic rechak: Trana' li, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Xpe Kakaj Jesús xel chicb'ic, xe' b'a witz ri jb'ij Olivos, jwi'l nak'tali' ji'kelon tran y yak ajtijol rib'ak chirij xamb'ertakb'i chirij. ");
INSERT INTO uspNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Cuando xtawtak li man luwar, xij re yak ajtijol rib'ak chirij: Ch'a'wentak riq'ui Kakaj Dios pire ma' atkejtak li mac, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Kakaj Jesús xelb'i riq'uilak xjutumb'ic, raj jilon najtil chapca' jnajtil titaw jun ab'aj ri tit'ojsaj y xxucar. Xoc chi ch'a'wem riq'ui Kakaj Dios, xij: ");
INSERT INTO uspNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Kaj, wi jilon chawaj, inacol laj jk'ab' juntir c'ax. Pero ri' b'an lawi' ri chawaj at y ma' ri' ta' ri chwaj in, xche'. ");
INSERT INTO uspNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Tijin tijb'ij jilonli cuando etke xril xwab'a' rib' jun anjl chiwch jpetic lecj, xyuk chi jye'ic jcowil ranm. ");
INSERT INTO uspNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Kakaj Jesús tichak tijin tric'aj sub'laj c'ax, jwi'li'li sub'laj xcoj jchok'b' chi ch'a'wem riq'ui Kakaj Dios y jc'atol ri tikej lak ulew ji'chaklon rilic chapca' tz'ut quic'. ");
INSERT INTO uspNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Cuando xmay ch'a'wem riq'ui Kakaj Dios xe' chic riq'uilak yak ajtijol rib'ak chirij y cuando xtaw riq'uilak, rechak tijintak chi waraj jwi'l mak'ul ranmak jwi'l b'is. ");
INSERT INTO uspNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Xpe Kakaj Jesús, xtz'onaj rechak: ¿Nen chac atwartak? ¡B'iitentak! Ch'a'wentak riq'ui Kakaj Dios pire ma' taye' ayb'ak attakchi'jtak chi macunc, xche' rechak yak ajtijol rib'ak chirij. ");
INSERT INTO uspNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Aj tijini' Kakaj Jesús chi yoloj riq'uilak yak ajtijol rib'ak chirij cuando xtaw jun k'at chi cristian. Man jun rechak yak cab'lajuj (12) ajtijol rib'ak chirij ri jb'ij Judas, ri' c'amowinakb'i jb'eak, re xjutun chijc'ulel Kakaj Jesús chi jtz'ub'aj jk'otz'. ");
INSERT INTO uspNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Pero Kakaj Jesús xij re: At Judas, la'ke jun tz'ub'aj k'otz' tajach pi camic Jc'ajol Kakaj Dios ri xwux pi cristianil, xche' re. ");
INSERT INTO uspNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Yak nic'j ri wi'tak riq'uil cuando xretemajtak chi ri' Kakaj Jesús tiyuk chapsajok, xtz'onajtak re: Kajawl, ¿tzini' tawil wi ojch'o'jin riq'uilak chi espad? xche'tak re. ");
INSERT INTO uspNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Xpe jun rechak yak ajtijol rib'ak chirij Kakaj Jesucristo, xc'urb'i jpaach jxicn man jmocom man nimlaj jb'ab'alak yak ajc'amaltak jb'eak cristian riq'ui Kakaj Dios, xresajb'i jpaach jxicn chi espad. ");
INSERT INTO uspNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Xpe Kakaj Jesús, xij re: Xana' li, ma b'an chic c'ax re, xche. Ajruc're' xchap jxicn man mocom y xtzib'saj. ");
INSERT INTO uspNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Y xij rechak mak jb'ab'alak yak ajc'amaltak jb'eak cristian riq'ui Kakaj Dios, mak jb'ab'alak mak ajchajaltak re nimi richoch Kakaj Dios y yak ri wi' rekle'nak chijxo'lak yak rijajl Israel ri xpetak chi jchapic: ¿Nen chac xac'amtakch espad y che' chi inchapic? ¿In inc'u jun alk'om tawiltak? ");
INSERT INTO uspNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Nojel k'ij xintijoj cristian li nimi richoch Kakaj Dios y ta' xinachaptak. Pero lajori xtawi' chiwch tab'antak lawi' chawajak tab'antak jwi'l ri' li raj man jb'ab'al etzl tab'antak, xche' Kakaj Jesús rechak. ");
INSERT INTO uspNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Xchaptak Kakaj Jesús y xc'amtakb'i laj richoch man nimlaj jb'ab'alak yak ajc'amaltak jb'eak cristian riq'ui Kakaj Dios. Pedro xtakeji'b'i Kakaj Jesús, pero chinajchak b'esalc. ");
INSERT INTO uspNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Nic'aj chuchja nuchuli' jun k'ak' y wi' cristian cub'ultak chi' k'ak' y Pedro xe' cub'ar riq'uilak. ");
INSERT INTO uspNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Xpe jun anm ajic', xril chi cub'ul Pedro chi' k'ak' cow xril y xij: Man winak ri, jpachi' Jesús, xche'. ");
INSERT INTO uspNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Pero Pedro ta' raj tijb'ij chi tz'eti'n, xij: At anm, in ta' tanch'ob' jwich winak li, xche' re. ");
INSERT INTO uspNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Mirchak jb'ij jwi'l Pedro jilonli cuando xpe chic jun, cow xril Pedro y xij re: At, ati' jun rechak mak jpach Jesús, xche' re. Pero Pedro xij chic: ¡No! ¡Tz'etel tz'et ma' impach ta'n! xche'. ");
INSERT INTO uspNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Raj jorok k'axi' jun or cuando xpe chic jun, xij re: Tz'etel tz'et tamb'ij chi winak ri jpachi' Jesús jwi'l ji' tipe Galilea, xche'. ");
INSERT INTO uspNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Pero Pedro xij chic: Ta' wetam nen tijin tab'ij chwe, xche'. Cuando tijin tijb'ij Pedro jilonli, xok' jun puy. ");
INSERT INTO uspNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Xpe Kakaj Jesús ri Kajawl, xsolcopij rib' y cow xril Pedro. Ajruc're' xcuxtaj jwi'l Pedro ri xijsaj re jwi'l Kakaj Jesús ri Kajawl jilonri: Lak'ab' wica cuando ajqui' chi ok' man puy, at jorok ab'iji' oxmul chi ta' tach'ob' inwch, xche' re. ");
INSERT INTO uspNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Pedro xelb'i cla', xe' jcamsaj rib' chi ok'ej. ");
INSERT INTO uspNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Mak winak ri wi'tak chi jchajaj Kakaj Jesús xoctak chi ritz'b'ej jwich y xsec'tak. ");
INSERT INTO uspNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Xch'uktak b'ak' jwich, ajruc're' xsec'tak y xijtak re: B'ijneca' chike, ¿nen xatsec'owc? xche'tak re. ");
INSERT INTO uspNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Y sub'laj yoloj xijtak re chi jyok'ic. ");
INSERT INTO uspNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Cuando xsakarsanc, xmulb'a' rib'ak yak ri wi' rekle'nak chijxo'lak yak rijajl Israel, mak jb'ab'alak yak ajc'amaltak jb'eak cristian riq'ui Kakaj Dios y yak ajtijoltak cristian re Jpixb' Kakaj Dios y xc'amsajb'i Kakaj Jesús chiwchak mak comontak jb'ab'alak yak rijajl Israel y cla' xtz'onajtak re: ");
INSERT INTO uspNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","B'ij chike, wi ati' Jc'ajol Kakaj Dios ri b'il jwi'l Kakaj Dios chi tina jtaknach wich ulew, xche'tak re Kakaj Jesús. Xpe Kakaj Jesús, xij rechak: Wi tamb'ij chawechak chi ini'n, ta' tacojtak chi tz'eti'n. ");
INSERT INTO uspNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Y wi wi' nen tantz'onaj chawechak ta' inac'ululajtak. ");
INSERT INTO uspNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Pero Jc'ajol Kakaj Dios ri xwux pi cristianil tina b'e cub'arna laj jpaach Kakaj Dios lecj ri wi' jcwinel, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Xpetak juntir rib'ilak, xtz'onajtak re: ¿Atni' Jc'ajol Kakaj Dios? xche'tak. Kakaj Jesús xij chic rechak: Ini'n, jilon chapca' ri xab'ijtak, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Xpe rechak, xijtak: Ta' chiqui' tichocon mas ajcojoltak tzij chirij kawi'l jwi'l oj xojtaw laj jchi' nen mo xij, xche'tak. ");
INSERT INTO uspNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Ajruc're' juntir rib'ilak mak comontak jb'ab'alak yak rijajl Israel xc'amtakb'i Kakaj Jesús riq'ui Pilato ri man jb'ab'al k'atb'itzij. ");
INSERT INTO uspNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Cla' xoctak chi jk'ab'aj tzij chirij, xijtak: Xkata'ch man winak ri, tijin tijtakchi'j kawinak, tijb'ij chi ta' chiqui' tikatoj alcabar re César. Y tijb'ij chi ri' re ri b'il jwi'l Kakaj Dios chi tina jtaknach wich ulew y ri' re jun rey, xche'tak re Pilato. ");
INSERT INTO uspNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Ajruc're' Pilato xtz'onaj re Kakaj Jesús: ¿Atni' jreyak yak rijajl Israel? xche' re. Kakaj Jesús xij: Ini'n, jilon chapca' ri xab'ij, xche'. ");
INSERT INTO uspNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Pilato xij rechak mak jb'ab'alak yak ajc'amaltak jb'eak cristian riq'ui Kakaj Dios y rechak juntir cristian: Ta' tanta' ni jono jmac winak ri, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Pero rechak xcoj jchok'b'ak chi jb'ijc: Tijin tijtakchi'j kawinak la' mak jc'utu'n, xcholch Galilea y lajori xk'ax lak juntir luwar re Judea jilon tijin tran neri Jerusalén, xche'tak re Pilato. ");
INSERT INTO uspNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Cuando Pilato xta chi jilonli xijsaj re, xtz'onaj re Kakaj Jesús wi tz'et ji' tipe Galilea. ");
INSERT INTO uspNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Cuando xta chi Kakaj Jesús ji' tipe lamas titakon Herodes Antipas, xtakb'i riq'uil. La' mak k'ij li Herodes Antipas ji' wi' Jerusalén. ");
INSERT INTO uspNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Herodes sub'laj xqui'cot cuando xril jwich Kakaj Jesús jwi'l ojrchak chi ticar rajti ranm tril jwich jwi'l tal jtaquil jwi'l chirij juntir ri b'anal jwi'l Kakaj Jesús y re ri' raj tril tran jun c'utb'i jcwinel chiwch. ");
INSERT INTO uspNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Jwi'li'li sub'laj xc'ot jchi' Kakaj Jesús, pero re ta' xc'ululaj ni jun yoloj. ");
INSERT INTO uspNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Y wi'taka' cla' mak jb'ab'alak yak ajc'amaltak jb'eak cristian riq'ui Kakaj Dios pach yak ajtijoltak cristian re Jpixb' Kakaj Dios. Rechak xcoj jchok'b'ak chi jk'ab'aj tzij chirij Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Herodes pach mak jsoldad sub'laj xretzelb'ejtak jwich Kakaj Jesús y pire xritz'b'ejtak jwich, xcojtak jun nimlaj itz'ik chirij Kakaj Jesús ri sub'laj kus rilic. Ajruc're' Herodes xtak chicb'i Kakaj Jesús riq'ui Pilato. ");
INSERT INTO uspNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Pilato pach Herodes jcontri' rib'ak, pero la' k'ij li xcan pi richc'ulchi'chak rib'ak. ");
INSERT INTO uspNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Ajruc're' Pilato xsiq'uij juntir mak jb'ab'alak yak ajc'amaltak jb'eak cristian riq'ui Kakaj Dios, yak ri wi' rekle'nak chijxo'lak yak rijajl Israel y juntir cristian pire tijmulb'a' rib'ak chiwch. ");
INSERT INTO uspNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Xij rechak: Xac'ama'taka' chiqui'ch winak ri wiq'uil ri tab'ijtak chirij chi tijin tijch'u'jursaj awinakak. Pero in xinc'ota' jchi' chawchak y xawila'taka' chi ta' xinta' ni jono jmac laj jyolj ri quiek jwi'l tacojtak tzij chirij. ");
INSERT INTO uspNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Y jilon Herodes ta' xta' ni jono jmac, jwi'li'li xtak chicch wiq'uil. Xawila'taka' chi ta' nen b'anal jwi'l ri quiek jwi'l ticamsajc. ");
INSERT INTO uspNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Lajori tanc'ach jwich y tantakb'ic, xche' Pilato rechak. ");
INSERT INTO uspNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Pilato nak'tali' nojel junab' re man nimak'ij Pascua tijtak jun prex lawi' rajak cristian titaksajc. ");
INSERT INTO uspNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Juntir cristian ri wi'tak cla' cow xch'ejejtak, xijtak re Pilato: ¡Camsaj! ¡Ri' takb'i Barrabás! xche'tak. ");
INSERT INTO uspNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Y man Barrabás cojol li cars jwi'l xtakchi'j cristian li tilmit chi tijb'it rib'ak chi ch'o'j riq'ui man jb'ab'al k'atb'itzij y jwi'l b'anal jun camic jwi'l. ");
INSERT INTO uspNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilato xch'ab'ej chic mak cristian y jwi'l ri' raj roj xtakb'i Kakaj Jesús xtz'onaj rechak chi wi tziyi' tijtakb'ic. ");
INSERT INTO uspNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Pero mak cristian sub'laj cow xch'ejejtak chic, xijtak: ¡Camsaj wich curs! ¡Camsaj wich curs! xche'tak. ");
INSERT INTO uspNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Laj jroxmul, Pilato xtz'onaj rechak mak cristian: ¿Nenc'u kes c'ax b'anal jwi'l? Ta' ni jono jmac tanta' chirij ri quiek jwi'l ticamsajc, lajori tanc'ach jwich y tantakb'ic, xche'. ");
INSERT INTO uspNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Pero mak cristian xtakejtak ch'ejejem chi jb'ij chi ticamsaj wich curs. ");
INSERT INTO uspNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Jwi'li'li Pilato xan lawi' ri rajak mak cristian tib'ansaj re Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Y jilonli xtakb'i Barrabás ri xtz'onajtak chi titaksajb'ic, re wi' li cars jwi'l tijin tijtakchi'j cristian li tilmit chi tijb'it rib'ak chi ch'o'j riq'ui man jb'ab'al k'atb'itzij y b'anal jun camic jwi'l. Ajruc're' xjachb'i Kakaj Jesús pire tib'ansaj re chapca' rajak tib'ansaj re. ");
INSERT INTO uspNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Xpetak mak soldad, xc'amtakb'i Kakaj Jesús pire tib'e jcamsajtak wich curs. Cuando b'esaltak lak b'e, xc'ultak jun winak ri jb'ij Simón aj Cirene b'enam re li tilmit Jerusalén y xijtak re chi trikajb'i jcurs Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Sub'laj cristian xamb'ertakb'i chirij Kakaj Jesús y wi' sub'laj anm tich'ejejtak chi ok'ej jwi'l jc'axc'ol ranmak chirij. ");
INSERT INTO uspNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Xpe Kakaj Jesús, xsolcopij rib' chi rilicak, xij rechak: Atak anm aj Jerusalén, mat ok'tak chwij in, ri' ok'aj ayb'ak y ok'entak chirij awic'lalak, ");
INSERT INTO uspNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","jwi'l tina tawna jun k'ij tib'ijsaj jilonri: Tzi rechak yak anm ri ta' tialc'walantak, tzi rechak yak anm ri ta' tiwuxtak yaj anm y tzi rechak mak jtu'ak yak anm ri ta' tu'tzal jono ac'l jwi'lak, tiche'tak. ");
INSERT INTO uspNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Ajruc're' tioctak chi jb'ij re nimaktak witz jilonri: Tzakentakch chikab', tiche'tak. Y tijb'ijtak re mak coc'aktak witz jilonri: Cojamuke'tak, tiche'tak. ");
INSERT INTO uspNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Jwi'l wi jilonli tib'ansaj re man rax che' y, ¿nen chiqui' mo tib'ansaj re man chekej che'? xche' Kakaj Jesús rechak. ");
INSERT INTO uspNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Y c'amal chicb'i quib' etzltak cristian jwi'lak pire tib'e jcamsajtak wich curs pi jpach Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Cuando xtawtak la' man luwar ri jb'ij Jb'akel Jb'a Camnak, xtz'octak Kakaj Jesús wich curs pach mak quib' etzltak cristian li, jun laj jpaach Kakaj Jesús y jun chic laj jmax. ");
INSERT INTO uspNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Ajruc're' Kakaj Jesús xij re Kakaj Dios: Kaj, cuy jmacak jwi'l ta' retamak nen tijin trantak, xche'. Y mak soldad xantak suert chirij ritz'ik chi rilic nen chi itz'ik lal tijch'ectak chi jujunalak. ");
INSERT INTO uspNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Wi' sub'laj cristian cla' chi rilic y mak jb'ab'alak yak rijajl Israel xritz'b'ejtak jwich Kakaj Jesús, xijtak: Xcwini' chi jcolic cristian y wi kes tz'et ri' re ri b'il jwi'l Kakaj Dios chi tina jtaknach wich ulew y ri cha'l jwi'l Kakaj Dios, jcole' rib' ric'an, xche'tak chirij. ");
INSERT INTO uspNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Y jilon mak soldad xritz'b'ejtaka' jwich, xjutuntak chijc'ulel y xsujtak vinagre re chi tijem ");
INSERT INTO uspNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","y xijtak re: Wi kes tz'et at jreyak yak rijajl Israel, colneca' ayb' awic'an, xche'tak re. ");
INSERT INTO uspNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Y wich curs chib' Kakaj Jesús xcojsaj jun kelen tz'ib'al jwich ri tijb'ij: RI' RI JREYAK YAK RIJAJL ISRAEL, tiche'. ");
INSERT INTO uspNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Y jun rechak mak etzltak cristian ri cocoltak cla', xritz'b'ej jwich Kakaj Jesús, xij: Wi ati' ri b'il jwi'l Kakaj Dios chi tina jtaknach wich ulew, col ayb' awic'an y cojacole' oj, xche' re. ");
INSERT INTO uspNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Pero man jun chic xyaj man jpach, xij re: Ta'cojo' tacoj jk'ij Kakaj Dios y nic'ke kacamsaj tib'anc. ");
INSERT INTO uspNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Oj pi jcholajli' jilonri tib'ansaj chike jwi'l tz'etel tz'eti' wi' kamac, ri' tijin tikatoj lajori mak etzltak no'j ri b'anal kawi'l. Pero winak ri ta' jmac, xche'. ");
INSERT INTO uspNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Ajruc're' xij re Kakaj Jesús: Wajawl, quincuxtaj awi'l cuando attakon chib'ak cristian, xche' re. ");
INSERT INTO uspNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Kakaj Jesús xij re: Tz'etel tz'et tamb'ij chawe chi lajori atb'i' wiq'uil li man kuslaj luwar lamas wi' Kakaj Dios, xche' re. ");
INSERT INTO uspNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Raj tiq'uil k'ij re cab'lajuj (12) xoc uku'm juntir wich ulew asta laj jrox or re b'esal k'ij. ");
INSERT INTO uspNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Xan uku'm jwich k'ij y xrech'maj laj nic'j man itz'ik re tosb'i jpam nimi richoch Kakaj Dios, quib' xelwi'. ");
INSERT INTO uspNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Kakaj Jesús cow xch'ejejc, xij: ¡Kaj, laj ak'b' tanjachwi' insantil! xche'. Cuando xijmaj jilonli jwi'l, xcamc. ");
INSERT INTO uspNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Cuando man jb'ab'alak mak soldad re Roma xril juntir ri xaanc, xoc chi jnimirsaj jk'ij Kakaj Dios, xij: ¡Kes tz'etel tz'et winak ri ta' nen jmac! xche'. ");
INSERT INTO uspNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Wi' sub'laj cristian cla' chi rilic. Cuando xk'ajtak laj richochak tichak jk'osaj chijch'olak la' jk'ab'ak jwi'l jc'axc'ol ranmak chirij Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Pero juntir yak richc'ulchi' Kakaj Jesús pach yak anm ri xpetak chirij cuando xelch Galilea, ji' xwa'xtakch chinaj chi rilic juntir ri xaanc. ");
INSERT INTO uspNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Wi' jun tzilaj winak ri jb'ij José y juntir ri tran pi jcholajli'n. José ri' jun chijxo'lak mak comontak jb'ab'alak yak rijajl Israel ");
INSERT INTO uspNT_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","y re ji' tipe Arimatea ri jun tilmit re Judea. Re cub'uli' jch'ol chi rulb'ej cuando titaw k'ij titakon Kakaj Dios chib'ak juntir cristian. Re ta' tijc'ul jwich lawi' ri xchomorsaj yak jpach y lawi' ri xantak. ");
INSERT INTO uspNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Xpe José, xe' riq'ui Pilato chi jtz'onaj jcamnakl Kakaj Jesús pire tiye'saj re. ");
INSERT INTO uspNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","José xkesaj jcamnakl Kakaj Jesús wich curs, xb'atz'b'i la' jun itz'ik ri jb'ij lino, xe' jmuke' li jun nimlaj jul ri c'otol li ab'aj ri ta' ni jun camnak mukul cla'. ");
INSERT INTO uspNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Y ri' man b'esal k'ij li tib'ansaj jwa'x juntir kelen ri tichocon jwi'lak la' k'ij re uxlan. ");
INSERT INTO uspNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Mak anm ri xpetak chirij Kakaj Jesús cuando xelch Galilea, xe'tak chirij José chi rilic man jul re mukb'i camnak y chi rilic nen mo xan José chi jye'ic jcamnakl Kakaj Jesús li jul. ");
INSERT INTO uspNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Cuando xk'ajtak laj richochak xoctak chi jb'anic jwa'x siminlaj perjum pire tijcojtak chirij jcamnakl Kakaj Jesús. Ajruc're' rechak xuxlantak la' man k'ij re uxlan chapca' tijb'ij Jpixb' Kakaj Dios. ");
INSERT INTO uspNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Y kes xsakarsan li nab'e k'ij re xuman, xe'tak yak anm chi' jul lamas xye'sajwi' jcamnakl Kakaj Jesús y xc'amtakb'i mak perjum ri xantak jwa'xc. ");
INSERT INTO uspNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Cuando xtawtak chi' jul, xriltak man ab'aj ri xcan cojsaj pi ch'ukb'i chi' jul, solcopilchakb'ic. ");
INSERT INTO uspNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Y rechak xoctakb'i li jul lamas xye'sajwi' jcamnakl Kakaj Jesús y ta' chiqui' xta'tak. ");
INSERT INTO uspNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Rechak ta' chiqui' tijta'tak nen trantak, etke xriltak wa'lchak quib' winak laj jxuctak sub'laj tikopopon ritz'ikak. ");
INSERT INTO uspNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Yak anm sub'laj xtzaak jch'olak, xxulb'a' jcayb'alak lak ulew. Xpetak yak quib' winak, xtz'onajtak rechak: ¿Nen chac tiyuk atoque'tak jun yo'l xo'lak camnakib'? ");
INSERT INTO uspNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Re ta' chiqui' neri, xc'astasaji'b'i jwich laj jcamnakl. Cuxtaj awi'lak nen xij chawechak cuando ajwi' Galilea. ");
INSERT INTO uspNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Xiji' chawechak chi Jc'ajol Kakaj Dios ri xwux pi cristianil tina jachsajna laj jk'ab'ak mak ajmacb' y tina camsajna wich curs, pero tina c'astasajna jwich laj jcamnakl laj jrox k'ij, xche'tak yak winak re yak anm. ");
INSERT INTO uspNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Ajruc're' xcuxtaj jwi'lak nen b'il rechak jwi'l Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Xeltakb'i lamas xye'sajwi' jcamnakl Kakaj Jesús, xe' jb'ijtak rechak yak junlajuj (11) chi jtako'n Kakaj Jesús y rechak yak nic'j jpachak chic. ");
INSERT INTO uspNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Yak ri xe' ye'wtak jtaquil rechak yak tako'n, ri'taka' María Magdalena, Juana, María ri jchuch Santiago y yak nic'j anm chic. ");
INSERT INTO uspNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Pero yak tako'n li ta' xcojtak jyoljak yak anm, chijch'ol rechak jb'anicke trantak. ");
INSERT INTO uspNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Pero Pedro laj or xe' jol chi rilic. Cuando xtaw chi' jul, xtacar chi rilic li jul y xichak mak q'uertak itz'ik ri jb'ij lino ri xb'atz'sajb'i Kakaj Jesús la', wi' cla'. Ajruc're' xk'aj chic la ja, jorchak sachal jch'ol jwi'l ta' chiqui' jcamnakl Kakaj Jesús cla'. ");
INSERT INTO uspNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","La' man k'ij li b'esaltak quib' rechak yak ajtijol rib'ak chirij Kakaj Jesucristo, b'enam rechak Emaús. Man tilmit li raj wi' uxib' lewa jnajtil re Jerusalén. ");
INSERT INTO uspNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Y rechak cuando b'esaltak li b'e, tijintak chi jyolic chirib'il rib'ak juntir ri xansaj re Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Cuando b'esaltak li b'e, etke xjutun Kakaj Jesús riq'uilak y xpachijb'i rib'ak riq'uil. ");
INSERT INTO uspNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Pero wi' nen xk'atow jwichak pire ma' jch'ob'tak jwich wi ri' Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Xpe Kakaj Jesús, xtz'onaj rechak: ¿Nen tijin tayoltak petzalcatak li b'e? xche' rechak. Rechak xwa'rtak, sub'laj b'is jwichak. ");
INSERT INTO uspNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Xpe jun rechak ri jb'ij Cleofas, xij: Xike at jun re mak ajsolinl ri wi'tak Jerusalén la' mak k'ij li, ri ta' awetam nen xansaj cla', xche'. ");
INSERT INTO uspNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Xpe Kakaj Jesús, xtz'onaj rechak: ¿Nenc'u xaan li tilmit? xche' rechak. Xpe rechak, xijtak re: Ri' ri xansaj re Kakaj Jesús aj Nazaret ri jun ajk'asal Jyolj Kakaj Dios ri cojol jk'ij jwi'l Kakaj Dios y jwi'lak cristian, jwi'l wi' jcwinel chi jb'anic nen raj Kakaj Dios tran y chi yoloj. ");
INSERT INTO uspNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Mak jb'ab'alak yak ajc'amaltak jb'eak cristian riq'ui Kakaj Dios pach yak k'atb'itzij re katilmit xantak k'atb'itzij chirij pire xjachtak pi camic wich curs. ");
INSERT INTO uspNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Oj cub'uli' kach'ol chi ri' re ticolow ke ri oj yak rijajl Israel laj jk'ab'ak yak kacontre, pero lajori xi' uxib' k'ij jcamic. ");
INSERT INTO uspNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Y wi' nic'j yak anm chikaxo'l xsachtak kach'ol. Ak'ab' xe'tak chi' jul lamas xye'sajwi' jcamnakl Kakaj Jesús, ");
INSERT INTO uspNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","pero ta' chiqui' xe' jte'tak jcamnakl cla'. Xk'ajtak la ja, xyuk jb'ijtak chike chi xwab'a' rib'ak nic'j anjl chiwchak chi jb'ij rechak chi Kakaj Jesús yo'li'n. ");
INSERT INTO uspNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Wi' nic'j kapach xe'tak chi rilic lamas xmuksajwi'. Xe' rile'tak jilon chapca' tijb'ijtak yak anm, pero ta' xriltak jwich Kakaj Jesús, xche'tak re. ");
INSERT INTO uspNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Xpe Kakaj Jesús, xij rechak: ¡Atak, pur atak tac! Ta' tatatak jcholajl juntir y ta' tacojtak juntir ri b'il jwi'lak yak ajk'asaltak Jyolj Kakaj Dios ojrtaktzij. ");
INSERT INTO uspNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Rajwaxi' jun ri b'il jwi'l Kakaj Dios chi tina jtaknach wich ulew tina jtijna c'ax nab'e, ajruc're' tinimirsaj jk'ij jwi'l Kakaj Dios, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Ajruc're' xoc chi jb'ij jcholajl rechak juntir ri tijb'ij lak jwuj Moisés pach lak jwujak yak ajk'asaltak Jyolj Kakaj Dios chirij re. ");
INSERT INTO uspNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Cuando xtawtak li man tilmit lamas rajak titawtak, xpe Kakaj Jesús xan chapca' tike k'axb'ic. ");
INSERT INTO uspNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Pero rechak ri' rajak tican Kakaj Jesús riq'uilak, xpwersijtak, xijtak re: Canen kiq'uil, jwi'l xi' k'ij y oquem tran ak'ab', xche'tak re. Jwi'li'li Kakaj Jesús xoc la ja riq'uilak pire tican riq'uilak. ");
INSERT INTO uspNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Y cuando cub'ulchak riq'uilak chi' mex, xc'am cuxlanwa, xc'omowaj re Kakaj Dios, xq'uer y xye' rechak chi tijem. ");
INSERT INTO uspNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Jilonli cuando xye'saj luwar rechak xch'ob'tak jwich chi ri' Kakaj Jesús, pero etke xsaach chiwchak. ");
INSERT INTO uspNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Xoctak chi jtz'onaj chirib'il rib'ak: ¿Miti xkic'ajtaka' chi xya' jcowil kanm lak b'e cuando xoc chi jb'ij chike ri jcholajl ri tz'ib'al li wuj re Lok'laj Jyolj Kakaj Dios chirij re? xche'tak. ");
INSERT INTO uspNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Cuando xriltak jilonli, laj or xk'ajtakch Jerusalén, xe' jte'tak yak junlajuj (11) jtako'n Kakaj Jesús pach nic'j jpachak chic c'amem rib'ak. ");
INSERT INTO uspNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Y yak ri wi'tak la ja xijtak jilonri rechak yak quib' ri xtawtak: Tz'etel tz'et xc'astasaji' jwich Kakaj Jesús ri Kajawl laj jcamnakl y xilsaji' jwich jwi'l Simón, xche'tak rechak. ");
INSERT INTO uspNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Xpetak yak quib' li, xoctak chi jb'ij rechak nen xantak li b'e y xyoltak chi ajri' xch'ob'tak jwich Kakaj Jesús cuando xq'uer man cuxlanwa. ");
INSERT INTO uspNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Aj tijintaka' chi jb'ij jilonli cuando xwab'a' rib' Kakaj Jesús laj xo'lak, xij rechak: Wa'xok utzil laj awanmak, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Rechak sub'laj xtzaak jch'olak, chijch'olak rechak jun ajtzakal ch'oli' xwab'a' rib' chiwchak. ");
INSERT INTO uspNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Xpe Kakaj Jesús, xij rechak: ¿Nen chac titzaak ach'olak? ¿Nen chac tachomorsajtak chi ini' jun ajtzakal ch'ol? ");
INSERT INTO uspNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Iltak ink'b' pach wakan chi kes tz'et ini'n. Inna chape'tak, tic'u awiltak chi jun ajtzakal ch'ol ta' jtio'jl y ta' jb'akel chapca' in, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Cuando xij jilonli, xc'ut jk'ab' pach rakan chiwchak. ");
INSERT INTO uspNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Y rechak onque tiqui'cottak y aj sachali' jch'olak, pero ajqui' chi xchomorsajtak wi ri' Kakaj Jesús. Xpe Kakaj Jesús xtz'onaj rechak: ¿Woni' kelen re tijel rij aac'lak neri? xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Ajruc're' xpetak, xye'tak jun q'uer b'olom car re ");
INSERT INTO uspNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","y re xc'ul y xtij chiwchak. ");
INSERT INTO uspNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Ajruc're' Kakaj Jesús xij rechak: Ri xansaj chwe, ri' ri ximb'ij chawechak cuando ajwini' aac'lak. Ximb'ij chawechak chi tina tawna chiwch juntir ri tz'ib'al lak jwuj Moisés, lak jwujak yak ajk'asaltak Jyolj Kakaj Dios y lak Salmos, xche' Kakaj Jesús rechak. ");
INSERT INTO uspNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Ajruc're' xan chi tijtatak jcholajl ri tijb'ij ri tz'ib'al li wuj re Lok'laj Jyolj Kakaj Dios. ");
INSERT INTO uspNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Y xij rechak: Jilonri tz'ib'al li wuj re Lok'laj Jyolj Kakaj Dios ri tijb'ij chi ri b'il jwi'l Kakaj Dios chi tina jtaknach wich ulew, tina camsajna y laj jrox k'ij tina c'astasajna jwich laj jcamnakl xo'lak camnakib'. ");
INSERT INTO uspNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Y laj jb'ij re rajwaxi' tina tijojna juntir cristian lak juntir tilmit chi rajwaxi' tijq'uex jno'jak y tijc'am jk'ab'al jmacak chiwch Kakaj Dios pire ticuysaj jmacak jwi'l Kakaj Dios. Ticholmajb'i jtijoj cristian neri Jerusalén. ");
INSERT INTO uspNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Atak xawila'taka' chi tz'eti' xaan juntir li. ");
INSERT INTO uspNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","In tantaka'ch chab'ak ri b'il jwi'l Kakaj Dios. Wa'xentak neri Jerusalén asta tina ac'ultakna laj awanmak ri cwinel ri tipe lecj, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Ajruc're' Kakaj Jesús xc'amb'i yak ajtijol rib'ak chirij Betania. Y cla' xb'it chi quib' jk'ab' lecj chi jye'ic utzil chib'ak. ");
INSERT INTO uspNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Cuando tijin tijye' utzil Kakaj Jesús chib'ak, xelb'i chijxo'lak, xc'amsajb'i lecj. ");
INSERT INTO uspNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Rechak xnimirsajtak jk'ij Kakaj Jesús. Cuando xantaj li jwi'lak, sub'laj tiqui'cottak xk'ajtak Jerusalén. ");
INSERT INTO uspNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Nojel k'ij wi'tak li nimi richoch Kakaj Dios chi jnimirsaj jk'ij Kakaj Dios.");
INSERT INTO uspNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Cuando xcholmajch jwich k'ijsak, wi'chak jun ri jb'ij Yoloj y ri jb'ij Yoloj ji' wi' riq'ui Kakaj Dios y Diosi'n. ");
INSERT INTO uspNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Y ri jb'ij Yoloj wi'chak riq'ui Kakaj Dios cuando xcholmajch jwich k'ijsak. ");
INSERT INTO uspNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Jwi'l re xansaj juntir ri wi'tak wich ulew y lecj jwi'l Kakaj Dios y ta' ni jono kelen ri xansaj jwi'l Kakaj Dios miti jwi'l re. ");
INSERT INTO uspNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Y jwi'lke re tita'maj tzilaj c'aslemal riq'ui Kakaj Dios lecj ri ta' jq'uisic y tzilaj c'aslemal li ri' chapca' jun k'ak' ri tisakab'san re ranmak juntir cristian wich ulew. ");
INSERT INTO uspNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Y man k'ak' li wi' jk'ak'al li uku'mal y man uku'mal ta' ticwin chi jchupic jk'ak'al. ");
INSERT INTO uspNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Kakaj Dios xtakch jun winak ri jb'ij Juan Ajb'anal Ja'tiox ");
INSERT INTO uspNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","pire xyuk jb'ij rechak cristian chirij man k'ak' li, pire tijcojtak ri tijb'ij chirij. ");
INSERT INTO uspNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Pero Juan Ajb'anal Ja'tiox ma' ri' ta' re man k'ak' li, re takalkech pire xyuk resaj chi sakil chi tz'eti' chirij man k'ak' li. ");
INSERT INTO uspNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Ri kes tz'etel k'ak' ri tisakab'san re ranmak juntir cristian yu'em tran wich ulew. ");
INSERT INTO uspNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Y ri jb'ij Yoloj xyuki' wa'xok xo'lak cristian wich ulew y jwi'l re xansaj juntir ri wi'tak wich ulew y lecj jwi'l Kakaj Dios ojr, pero mak cristian ri retake wich ulew ta' xch'ob'tak jwich. ");
INSERT INTO uspNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Y cuando xyuk wa'xok xo'lak yak jwinak wich ulew ta' xc'ulsaj jwi'lak yak jwinak. ");
INSERT INTO uspNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Pero juntir ri xc'uluwtak laj ranmak y xcub'ar jch'olak chirij, xana' rechak pire xwuxtak pi ralc'wal Kakaj Dios. ");
INSERT INTO uspNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Y rechak ralc'waltaka' Kakaj Dios jwi'l ajri' xq'uisi'ytak chic, pero ta' xq'uisi'ytak chapca' jq'uisi'ycak cristian, Kakaj Diosi' xalc'walan rechak. ");
INSERT INTO uspNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Y ri jb'ij Yoloj xwux pi cristianil y xwa'xi' chikaxo'l, xkila' jnimal jk'ij. Sub'laj nim jk'ij jwi'l xike re ri Jc'ajol Kakaj Dios y sub'laj rutzil ranm chikij y ri' kes tz'etel tzij. ");
INSERT INTO uspNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Juan Ajb'anal Ja'tiox ri xyolow chirij ri tipetc, xij: Ri' ri quiek chirij xinyolow cuando ximb'ij: Wi' jun tipe chic chwij masna nim jk'ij chinwch in, jwi'l wi'chak ojrtaktzij cuando ajqui' chi inq'uisi'y in, xche'. ");
INSERT INTO uspNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Y sub'laj rutzil ranm chikij, jwi'li'li sub'laj q'ui jwich utzil xkac'ultak, ");
INSERT INTO uspNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","jwi'l Moisés xye'w retemaj Jpixb' Kakaj Dios. Y rutzil ranm Kakaj Dios chikij y ri tz'etel tzij Kakaj Jesucristo xyuk esan chi sakil. ");
INSERT INTO uspNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Ni jonok iliwinak jwich Kakaj Dios. Kakaj Jesús jwi'l xike re Jc'ajol Kakaj Dios ri Diosi'n y juntake pach Kakaj Dios ri' re xyuk esan chi sakil chikawch nen jb'anic Kakaj Dios. ");
INSERT INTO uspNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Mak jb'ab'alak yak rijajl Israel ri wi'tak Jerusalén xtaktak yak ajc'amaltak jb'eak cristian riq'ui Kakaj Dios pach yak rijajl Leví riq'ui Juan Ajb'anal Ja'tiox chi jtz'onaj re nen jb'anic re. ");
INSERT INTO uspNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Juan Ajb'anal Ja'tiox xij ri kes tz'etel tz'et rechak: In ma' in ta' ri b'il jwi'l Kakaj Dios chi tina jtaknach wich ulew, xche'. ");
INSERT INTO uspNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Y mak tako'n li xtz'onajtak chic re: ¿Nenc'u atb'an? ¿Atni' Elías ri ajk'asal Jyolj Kakaj Dios? xche'tak re. Y Juan Ajb'anal Ja'tiox xij chic rechak: Ma' in ta'n, xche'. Y rechak xtz'onajtak chic re: ¿Atni' ajk'asal Jyolj Kakaj Dios ri b'il jwi'l chi tina jtaknach wich ulew? xche'tak chic re. Y Juan Ajb'anal Ja'tiox xij chic rechak: Ma' in ta'n, xche'. ");
INSERT INTO uspNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Y xijtak chic re: B'ij chike nen at, jwi'l oj tina kac'amb'i jtaquil rechak yak ri xojtakowch. ¿Nenc'u tab'ij chike chawij at? xche'tak re. ");
INSERT INTO uspNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Juan Ajb'anal Ja'tiox xij rechak: Ini' jun ri cow tich'ejej li jun luwar lamas ta' cristian ri tijb'ij jilonri: Teb'a'tak jb'e Kakaj Jesús ri Kajawl suc'ul laj awanmak, tiche', xche' rechak. Ri' li xij Isaías ojr ri ajk'asal Jyolj Kakaj Dios. ");
INSERT INTO uspNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Mak ri takaltakch jwi'lak mak fariseo riq'ui Juan Ajb'anal Ja'tiox ");
INSERT INTO uspNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","xijtak chic re Juan Ajb'anal Ja'tiox: Wi ma' at ta' ri b'il jwi'l Kakaj Dios chi tina jtaknach wich ulew y wi ma' at ta' Elías y wi ma' at ta' ajk'asal Jyolj Kakaj Dios ri b'il jwi'l chi tina jtaknach wich ulew, ¿nenc'u chac tab'an ja'tiox? xche'tak re. ");
INSERT INTO uspNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Y Juan Ajb'anal Ja'tiox xij chic rechak: In tamb'ana' ja'tiox la' ja', pero wi' jun chaxo'lak ri ta' tach'ob'tak jwich ");
INSERT INTO uspNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","y ri' re petzal chwij in. Y in ta' tic'ular pi we tanquir jxajb' jwi'l re masna nim jk'ij chinwch in. ");
INSERT INTO uspNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Juntir li ji' xan la' man luwar ri jb'ij Betania ri wi' ch'akap re nimi ja' Jordán lamas tijin Juan Ajb'anal Ja'tiox chi jb'anic ja'tiox. ");
INSERT INTO uspNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Laj jcab' k'ij Juan Ajb'anal Ja'tiox xril Kakaj Jesús tijin tijutun chijc'ulel, cow xch'a'wc, xij: ¡Iltak impuch, ri' ri Ra Jcarner Kakaj Dios ri titojow jmacak juntir cristian wich ulew! ");
INSERT INTO uspNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Ri' re ri quiek chirij xinyolow cuando ximb'ij chi wi' jun chic petzal chwij in masna nim jk'ij chinwch in jwi'l wi'chak ojrtaktzij cuando ajqui' chi inq'uisi'y in. ");
INSERT INTO uspNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","In ta' wetam nen chi cristian lal li, pero in tijin tamb'an ja'tiox la' ja' pire tretemajtak yak rijajl Israel nen jb'anic. ");
INSERT INTO uspNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Y in xwila' xkejch Lok'laj Jsantil Kakaj Dios lecj chapca' jun ra ut y xcan chib'. ");
INSERT INTO uspNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Y in ta' nen imb'anic, pero ri xintakow chi jb'anic ja'tiox la' ja' xij chwe: Cuando tawil tikejch Lok'laj Insantil lecj y tican chib', ri' li ri tib'anow ja'tiox la' Lok'laj Insantil, xche' chwe. ");
INSERT INTO uspNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Y in xwila' jwich, jwi'li'li in tamb'ij chi re ri' Jc'ajol Kakaj Dios, xche' Juan Ajb'anal Ja'tiox. ");
INSERT INTO uspNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Laj jcab' k'ij Juan Ajb'anal Ja'tiox wi' chic cla' pach quib' rechak yak ajtijol rib'ak chirij. ");
INSERT INTO uspNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Cuando xril xk'axb'i Kakaj Jesús, xij rechak: ¡Iltak impuch, ri' ri Ra Jcarner Kakaj Dios! xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Yak quib' ajtijol rib'ak chirij Juan Ajb'anal Ja'tiox xtatak chi jilonli xij Juan Ajb'anal Ja'tiox rechak, xamb'ertakb'i chirij Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Kakaj Jesús xna'tun chirij, ri'chak xril chi b'esal yak quib' cristian li chirij xtz'onaj rechak: ¿Nen tatoctak? xche' rechak. Y rechak xijtak re: Rabí, ¿lamas watwi'? xche'tak re. (Ri jcholajl tielwi' man yoloj rabí, ajtijonl.) ");
INSERT INTO uspNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Laj jcaj orchak re b'esal k'ij, Kakaj Jesús xij rechak: Tzajtak, iltatak, xche' rechak. Y rechak xe'tak chirij, xe' rile'tak lamas wi'w y cla' riq'uil xkesantakwi' k'ij. ");
INSERT INTO uspNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Jun rechak yak quib' ri xtatak nen xij Juan Ajb'anal Ja'tiox ri xe' chirij Kakaj Jesús, ri' Andrés ri jk'un Simón Pedro. ");
INSERT INTO uspNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Ajruc're' nab'e xe' chi jtoquic Simón ri ratz y xij re: Xkata' winak ri b'il jwi'l Kakaj Dios chi tina jtaknach wich ulew ri tib'ijsaj Mesías re, xche' Andrés re Simón. (Ri jcholajl tielwi' man b'ij Mesías, Cristo.) ");
INSERT INTO uspNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Xpe Andrés xc'amb'i Simón lamas wi' Kakaj Jesús. Xpe Kakaj Jesús, cuando xril jwich Simón, xij re: Ati' ri at Simón, jc'ajol Juan, lajori tioc ab'j pi Cefas, xche' re. (Ri jcholajl tielwi' man b'ij Cefas, Pedro.) ");
INSERT INTO uspNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Laj jcab' k'ij Kakaj Jesús xchomorsaj tib'e Galilea, xc'ul Felipe, xij re: Jo' chwij, xche' re. ");
INSERT INTO uspNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Felipe ji' tipe li tilmit Betsaida ri jtilmit Andrés pach Pedro. ");
INSERT INTO uspNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Xpe Felipe, xe' jtoque' Natanael y xij re: Xkata' winak ri quiek chirij ri xcan jtz'ib'aj Moisés lak wuj re Jpixb' Kakaj Dios y ri quiek chirij xcan jtz'ib'ajtak yak ajk'asaltak Jyolj Kakaj Dios. Ri' Kakaj Jesús aj Nazaret ri jc'ajol José, xche' Felipe re Natanael. ");
INSERT INTO uspNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Xpe Natanael, xij: Ta' ni jono winak aj Nazaret tib'anow utzil, xche' re Felipe. Xpe Felipe, xij re: Tzaj yuk awile', xche' re. ");
INSERT INTO uspNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Kakaj Jesús cuando xril petzal Natanael, xij: Neri petzal jun tz'etel rijajl Israel re ta' tisub'unc, xche'. ");
INSERT INTO uspNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Xpe Natanael, xtz'onaj re: ¿Nen mo xawetemaj nen imb'anic in? xche' re. Kakaj Jesús xij chic re: In xwila' awch, wat ralaj man jche'l higo cuando ajqui' chi atsiq'uij jwi'l Felipe, xche' re. ");
INSERT INTO uspNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Natanael xij chic re: ¡Kajtijonl, ati' Jc'ajol Kakaj Dios y ati' jreyak yak rijajl Israel! xche' re. ");
INSERT INTO uspNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Kakaj Jesús xij chic re: At xacoja'n, jwi'lke ximb'ij chawe chi xwila' awch cuando wat ralaj man jche'l higo. Tina awilna mas ri sub'laj sachom ch'olal rilic chiwch li, xche' re. ");
INSERT INTO uspNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Kakaj Jesús xij chic: Kes tz'etel tz'et tamb'ij chawechak chi atak tina awiltakna caj titer y tawiltak yak ranjl Kakaj Dios tiak'antakb'i lecj y tikejtakch pire tiwa'xtak riq'ui Jc'ajol Kakaj Dios ri xwux pi cristianil, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Laj jrox k'ij xansaj jun nimak'ij re c'ulniquil Caná re Galilea y jchuch Kakaj Jesús wi' cla'. ");
INSERT INTO uspNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Y Kakaj Jesús pach yak ajtijol rib'ak chirij xijsaj rechak chi tib'etak li man nimak'ij li. ");
INSERT INTO uspNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Y cuando xq'uis man vin xpe jchuch Kakaj Jesús, xij re: Xq'uisi' jvinak, xche' re. ");
INSERT INTO uspNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Kakaj Jesús xij re: At chuch, ma b'ij chwe nen tamb'an. Ajqui' titaw k'ij inoc chi jb'anic ri takalquinch chi jb'anic, xche' re. ");
INSERT INTO uspNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Pero jchuch xij rechak yak ri tijintak chi jjachic vin: B'antak juntir ri nen tijb'ij chawechak, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Y cla' wi' wakakib' (6) nimaktak k'ib' b'anal la' ab'aj, re c'olb'i ja' pire ch'ajb'i jk'ab'ak yak rijajl Israel, jwi'l jilon jc'utu'nak, ri' rajak tzi tiilsajtak jwi'l Kakaj Dios. Mak k'ib' li raj tijk'iya' oxc'al jo'lajuj (75) litro asta jun cient jo'lajuj (115) litro. ");
INSERT INTO uspNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Xpe Kakaj Jesús, xij rechak yak ajjachaltak vin: Nojsajtak mak k'ib' li chi ja', xche' rechak. Ajruc're' rechak xnojsajtak mak k'ib' chi ja' asta tic'alc'atzinc. ");
INSERT INTO uspNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Ajruc're' xpe Kakaj Jesús, xij chic rechak: Lajori esajtakb'i junquitz, ye'tatak re man ajc'amal b'e re man nimak'ij, xche' rechak. Rechak xantak chapca' xijsaj rechak. ");
INSERT INTO uspNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Xpe man ajc'amal b'e re man nimak'ij, xric'aj man ja' ri xwux pi vin, pero ta' retam lamas xpe'w, xike mak ajjachaltak vin retamak lamas xpe'w, jwi'l ri' rechak xesantak li k'ib'. Jwi'li'li man ajc'amal b'e re man nimak'ij xsiq'uij man c'ojol winak ri tic'uli'yc, xij re: ");
INSERT INTO uspNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Juntir cristian cuando trantak nimak'ij re c'ulniquil ri' nab'e tijye'tak man vin chi tijem ri pakal rijil. Cuando yak ri siq'uiltak re man nimak'ij jorok jtija'taka' sub'laj vin, ajruc're' pi q'uisb'ire tijye'tak man vin chi tijem ri ta' pakal rijil. Pero at xac'ola' man vin ri pakal rijil pire taye' chi tijem pi q'uisb'ire man nimak'ij, xche' man ajc'amal b'e re man nimak'ij re man c'ojol winak ri tic'uli'yc. ");
INSERT INTO uspNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Ri xan Kakaj Jesús Caná re Galilea ri' li nab'e c'utb'i jcwinel Kakaj Dios xan pire xc'ut chi sub'laj nimi' jk'ij, jwi'li'li yak ajtijol rib'ak chirij xcub'ar jch'olak chirij. ");
INSERT INTO uspNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Cuando xantaj li, Kakaj Jesús xe' Capernaúm pach jchuch, yak jk'un y yak ajtijol rib'ak chirij, xwa'xtak quib' uxib' k'ij cla'. ");
INSERT INTO uspNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Tawem tran jnimak'jak yak rijajl Israel ri jb'ij Pascua, Kakaj Jesús xe' Jerusalén. ");
INSERT INTO uspNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Y li nimi richoch Kakaj Dios xe' jte' mak ajc'ayaltak wacx, mak ajc'ayaltak carner, mak ajc'ayaltak ut y xe' jte' mak cristian ri cub'ultak chi' jmexak lamas tijq'uextakwi' jpwaakak cristian. ");
INSERT INTO uspNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Kakaj Jesús, cuando xril chi jilonli, xan jun chicot la' c'am y la' man chicot li xruktaj juntir mak ajc'ayb' li nimi richoch Kakaj Dios pach mak jwacxak y jcarnerak. Y xtilb'i jpwaakak mak ajq'uexeltak pwak y xsolcopij mak jmexak chiwchak lak ulew. ");
INSERT INTO uspNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Y xij rechak mak ajc'ayaltak ut: ¡Esajtakb'i mak ac'yak neri! ¡Ma cojtak richoch Inkaj pi c'ayb'l! xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Ajruc're' yak ajtijol rib'ak chirij xcuxtaj jwi'lak ri tz'ib'al li wuj re Jyolj Kakaj Dios ri tijb'ij jilonri: Jwi'l tanchajaj awichoch tina sachsajna inwch, tiche'. ");
INSERT INTO uspNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Xpe mak jb'ab'alak yak rijajl Israel, xtz'onajtak re Kakaj Jesús: ¿Nenc'u jono c'utb'i jcwinel Kakaj Dios ri tac'ut chikawch chi jc'utic chi wi' k'atb'itzij laj ak'b' chi jb'anic juntir li? xche'tak re. ");
INSERT INTO uspNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Kakaj Jesús xij rechak: Yojtak nimi richoch Kakaj Dios ri y in li uxib' k'ij tamb'an chic jwa'xc, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Mak jb'ab'alak yak rijajl Israel xijtak re: Chiwch ca'winak wakakib' (46) junab' xantajwi' nimi richoch Kakaj Dios ri y, ¿atc'u cwini' at chi jb'anic jwa'x li uxib' k'ij? xche'tak re. ");
INSERT INTO uspNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Pero Kakaj Jesús ma' chirij ta' nimi richoch Kakaj Dios xij cuando xij jilonli, chiriji' jtio'jl re. ");
INSERT INTO uspNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Jwi'li'li cuando xc'astasaj jwich Kakaj Jesús laj jcamnakl xo'lak camnakib', yak ajtijol rib'ak chirij xcuxtaj jwi'lak ri b'il jwi'l Kakaj Jesús, ajruc're' xcojtak nen tijb'ij li wuj re Lok'laj Jyolj Kakaj Dios y xcojtak jyolj Kakaj Jesús ri xij rechak. ");
INSERT INTO uspNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Cuando wi' Kakaj Jesús Jerusalén li man nimak'ij Pascua, sub'laj q'ui cristian xcub'ar jch'olak chirij jwi'l re sub'laj c'utb'i jcwinel Kakaj Dios xan chiwchak. ");
INSERT INTO uspNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Pero Kakaj Jesús ta' xcub'ar jch'ol chirijak, jwi'l re retami' nen jchomorsa'nak cristian laj ranmak. ");
INSERT INTO uspNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Re ta' rajwax tib'ijsaj re nen jb'anic ranmak cristian jwi'l re retami' nen jchomorsa'nak juntir cristian ri wi' laj ranmak. ");
INSERT INTO uspNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Wi' jun rechak mak fariseo ri jb'ij Nicodemo ri' jun winak sub'laj nim jk'ij chijxo'lak yak rijajl Israel. ");
INSERT INTO uspNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Re xe' chi jsolaj Kakaj Jesús lak'ab' y xij re: Kajtijonl, ketami' chi Kakaj Diosi' xattakowch chi katijoj jwi'l ta' ni jonok ticwin chi jb'anic c'utb'i jcwinel Kakaj Dios chapca' tab'an at wi mita' Kakaj Dios riq'uil, xche' re. ");
INSERT INTO uspNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Kakaj Jesús xij re Nicodemo: Tz'etel tz'et tamb'ij chawe chi nen jun cristian ri mita' tiq'uisi'y chic jca'mul ta' tijna' tioc laj jk'ab' Kakaj Dios pire titakon chib', xche' re. ");
INSERT INTO uspNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nicodemo xtz'onaj chic re Kakaj Jesús: ¿Nen mo tijna' tiq'uisi'y chic jun cristian jca'mul cuando ri'jlaj cristianchak? Ta' tijna' tik'aj chic laj jsantil jchuch pire tiq'uisi'y chic jca'mul, xche' re. ");
INSERT INTO uspNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Kakaj Jesús xij chic re: Kes tz'etel tz'et tamb'ij chawe chi nen ta' tijc'am ja'tiox y ta' tijc'ul Lok'laj Jsantil Kakaj Dios laj ranm chapca' tiq'uisi'y chic jca'mul, ta' tioc laj jk'ab' Kakaj Dios pire titakon chib'. ");
INSERT INTO uspNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Nen tiq'uisi'y riq'ui jkaj jchuch, cristianke. Pero nen tijc'ul Lok'laj Jsantil Kakaj Dios laj ranm chapca' tiq'uisi'y chic jca'mul, ri'chak Lok'laj Jsantil Kakaj Dios tiwa'x laj ranm. ");
INSERT INTO uspNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Mi sach ach'ol chi jtaic ri tijin tamb'ij chawe chi rajwaxi' juntir tina q'uisi'ytakna chic jca'mul. ");
INSERT INTO uspNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Tew tijub'ub'i' juntir luwar, tata' tijumum, pero ta' tawil lamas tipe'w ni ta' tawil lamas tib'e'w y ji'c'ulon juntir yak ri tiq'uisi'ytak jwi'l Lok'laj Jsantil Kakaj Dios. ");
INSERT INTO uspNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nicodemo xij chic re Kakaj Jesús: Ta' tijna' tib'an jilonli, xche' re. ");
INSERT INTO uspNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Kakaj Jesús xij chic re: Pero at ati' jun ajtijonl ri nim ak'ij chijxo'lak yak rijajl Israel y ta' tata jcholajl ri tijin tamb'ij chawe. ");
INSERT INTO uspNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Kes tz'etel tz'et tamb'ij chawe chi oj ri' tikab'ij ri ketam y tikab'iji' chi tz'eti' ri ilan kawi'l, pero atak ta' tacojtak lawi' ri tikab'ij chawechak. ");
INSERT INTO uspNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Atak ta' tacojtak ri tamb'ij chawechak chirijke mak kelen re wich ulew, ri'tic'u chic tacojtak inyolj cuando tanyol chawechak chirij kelen ri wi' lecj. ");
INSERT INTO uspNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Ta' ni jun cristian xjaw riq'ui Kakaj Dios lecj, xike Jc'ajol Kakaj Dios ri xwux pi cristianil ri xpe lecj. ");
INSERT INTO uspNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Jilon chapca' xan Moisés li chekej luwar cuando xcocb'a' man richb'al cumatz b'a che', jilon tib'ansaj re Jc'ajol Kakaj Dios ri xwux pi cristianil tina camsajna wich curs. ");
INSERT INTO uspNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Y juntir ri tijcub'a' jch'olak chirij tijta'taka' jun tzilaj c'aslemal riq'ui Kakaj Dios lecj ri ta' jq'uisic, xche' Kakaj Jesús re Nicodemo. ");
INSERT INTO uspNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Kakaj Dios jwi'l sub'laj tijlok'aj juntir cristian xtakch Kakaj Jesús wich ulew ri xike jun chi Jc'ajol wi'. Y juntir ri tijcub'a' jch'olak chirij ta' tisaach jwichak, tijta'taka' jun tzilaj c'aslemal riq'ui Kakaj Dios lecj ri ta' jq'uisic. ");
INSERT INTO uspNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Kakaj Dios ta' xtakch Jc'ajol wich ulew pire tiyuk rane' jk'atb'itzij chib'ak cristian, re xtakch Jc'ajol wich ulew pirechi' tiyuk jcole' cristian laj jk'ab' jmacak. ");
INSERT INTO uspNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Nen jonok tijcub'a' jch'ol chirij Jc'ajol Kakaj Dios ta' tib'an k'atb'itzij chib', pero nen jonok ta' tijcub'a' jch'ol chirij ri xike jun chi Jc'ajol Kakaj Dios li wi', xansaji' k'atb'itzij chib'. ");
INSERT INTO uspNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Ri' ri quiek jwi'l tran jk'atb'itzij Kakaj Dios chib'ak juntir cristian. Ta' rajak jwich k'ak' ri xyuk wich ulew jwi'l rechak ri' mas xe' ranmak chirij man uku'mal jwi'l ri' tijin trantak mak etzltak no'j. ");
INSERT INTO uspNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Nen jono cristian ri tib'anow mak etzltak no'j tijxuta' man k'ak' li, jwi'l ta' raj tiel chi sakil mak etzltak no'j ri tijin chi jb'anic. ");
INSERT INTO uspNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Pero nen jonok tib'anow tzitaklaj no'j tijtoca' man k'ak' li pire tic'utun chi tijin tran lawi' raj Kakaj Dios tran, xche' Kakaj Jesús re Nicodemo. ");
INSERT INTO uspNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Cuando xantaj li, Kakaj Jesús xe' Judea pach yak ajtijol rib'ak chirij y xwa'xtaka' cla' chi jb'anic ja'tiox. ");
INSERT INTO uspNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Y jilon Juan Ajb'anal Ja'tiox tijini' chi jb'anic ja'tiox rechak cristian Enón chijc'ulel Salim jwi'l cla' wi' sub'laj ja'. Y juntir cristian ri xtawtak riq'uil, re xana' ja'tiox rechak. ");
INSERT INTO uspNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Ri' li xansaj cuando ajqui' chi cojsaj Juan Ajb'anal Ja'tiox li cars. ");
INSERT INTO uspNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Xpe jujun rechak yak ajtijol rib'ak chirij Juan Ajb'anal Ja'tiox riq'ui jun rijajl Israel, xoctak chi jyolic chirij nen mas tzi trantak pire tisakab'tak chiwch Kakaj Dios. ");
INSERT INTO uspNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Xpe rechak, xe' jb'ijtak re Juan Ajb'anal Ja'tiox: Kajtijonl, winak ri xwa'x aac'l ch'akap re nimi ja' Jordán ri xayol chike, lajori tijin tran ja'tiox rechak cristian y juntir cristian titawtak riq'uil, xche'tak re Juan Ajb'anal Ja'tiox. ");
INSERT INTO uspNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Xpe Juan Ajb'anal Ja'tiox, xij rechak: Ta' ni jonok tiwa'x rekle'n wi ma' Kakaj Dios ta' tiye'w re. ");
INSERT INTO uspNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Pero atak xata'taka' ri ximb'ij chawechak chi in ma' in ta' ri b'il jwi'l Kakaj Dios chi tina jtaknach wich ulew, in xintaksajchke nab'e chiwch re. ");
INSERT INTO uspNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Li jun nimak'ij re c'ulniquil, man c'ojol winak ri wi' man k'apoj anm riq'uil, ri' re tic'uli'y riq'ui man anm y man richc'ulchi' man c'ojol winak ri tic'uli'y ri wi' cla' chi rilic man nimak'ij, re sub'laj tiqui'cot chi jtaic jyolj man c'ojol winak. Y jilon in lajori sub'laj inqui'cotc. ");
INSERT INTO uspNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Re rajwaxi' nojel k'ij tijin tiniman mas jk'ij y in tijin tikej ink'ij, xche' Juan Ajb'anal Ja'tiox rechak. ");
INSERT INTO uspNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Y Juan xij chic: Jun ri tipe lecj ri' re titakon chib' juntir ri wi'tak wich ulew y juntir ri wi'tak lecj. Nen jono ri reke wich ulew xike retam mak kelen re wich ulew y xike li tijyol. Pero jun ri tipe lecj, ri' re titakon chib'ak juntir. ");
INSERT INTO uspNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Re ri' tijyol juntir ri ilan y tal jwi'l, pero ta' ni jonok ticojow re nen tijb'ij. ");
INSERT INTO uspNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Pero wi wi' jonok ticojow jyolj, ri' li tic'utuw chi tz'etel tz'eti' ri tijb'ij Kakaj Dios. ");
INSERT INTO uspNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Jun ri takalch jwi'l Kakaj Dios wich ulew, Jyolji' Kakaj Dios ri tijb'ij, jwi'l nojsali' ranm la' Lok'laj Jsantil Kakaj Dios jwi'l Kakaj Dios. ");
INSERT INTO uspNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Kakaj Dios sub'laj tijlok'aj Jc'ajol y xya' juntir ri wi' wich ulew y juntir ri wi' lecj laj jk'ab'. ");
INSERT INTO uspNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Nen ticub'ar jch'ol chirij Jc'ajol Kakaj Dios tijta' jun tzilaj c'aslemal riq'ui Kakaj Dios lecj ri ta' jq'uisic. Pero nen ta' ticub'ar jch'ol chirij Jc'ajol, ta' tijta' tzilaj c'aslemal riq'ui Kakaj Dios lecj ri ta' jq'uisic. Sub'laj c'axi' k'atb'itzij tib'ansaj chib' jwi'l Kakaj Dios, xche'. ");
INSERT INTO uspNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Mak fariseo xtatak jtaquil chi Kakaj Jesús ri Kajawl wi' mas cristian xoctak pi ajtijol rib'ak chirij chiwch Juan Ajb'anal Ja'tiox y wi' mas xan ja'tiox rechak. ");
INSERT INTO uspNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Pero tz'etel tz'et ma' ri' ta' Kakaj Jesús tijin tib'anow ja'tiox rechak, ri'taka' yak ajtijol rib'ak chirij. ");
INSERT INTO uspNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Cuando Kakaj Jesús xta jtaquil chi jilonli xijsaj chirij, xelb'i Judea, xk'aj chic Galilea. ");
INSERT INTO uspNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Y rajwaxna tik'ax Samaria. ");
INSERT INTO uspNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Jilonli xtaw Sicar ri jun tilmit re Samaria, ri tican chijc'ulel man ulew ri xye' Jacob re José ri jc'ajol. ");
INSERT INTO uspNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Y cla' wi' man c'otob' ri tib'ijsaj jc'otb' Jacob re. Kakaj Jesús sub'laj cosol chi b'e xcub'ar chijc'ulel man c'otob' li chi uxlan, junquitz raj titic'ar k'ij re cab'lajuj (12). ");
INSERT INTO uspNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Y yak ajtijol rib'ak chirij xe'tak li tilmit chi jlok'ic kelen rechak re tijtijtak. Y xtaw jun anm aj Samaria chi jc'amic ja' li man c'otob' li. Xpe Kakaj Jesús, xij re: Ye' junquitz ínja', xche' re. ");
INSERT INTO uspNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Xpe man anm li, xtz'onaj re: ¿Nen chac tatz'onaj ja' chwe? At ati' rijajl Israel y in ini' aj Samaria, xche' re. Re xij jilonli jwi'l yak rijajl Israel ta' tiniq'uib' jwichak riq'uilak mak aj Samaria. ");
INSERT INTO uspNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Kakaj Jesús xij chic re anm: Witi awetam nen tijsipaj Kakaj Dios y witi awetam nen ri titz'onin ja' chawe, li tatz'onaji' ja' re y re tijya' ja' chawe ri tiye'w tzilaj c'aslemal riq'ui Kakaj Dios lecj ri ta' jq'uisic, xche' re. ");
INSERT INTO uspNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Xpe man anm li, xij chic re Kakaj Jesús: Kaj, ta' nen quiek la' tawesaj ája' y man c'otob' ri, naji' jkejeb'. ¿Lac'umas tac'am ja' ri tiye'w tzilaj c'aslemal riq'ui Kakaj Dios lecj ri ta' jq'uisic pire taye' chwe? ");
INSERT INTO uspNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","¿Masc'u nim ak'ij at chiwch kamam Jacob ri xcan ye'w man c'otob' ri chike, ri lamas xresaj jja' re pach ralc'wal ri xtijtak y xye' re rawjak? xche' re. ");
INSERT INTO uspNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Kakaj Jesús xij chic re man anm li: Juntir ri titijowtak re man ja' ri, tina jye'na chic chekej chi' rechak, ");
INSERT INTO uspNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","pero nen titijiw re ja' ri tanye' in, ta' chiqui' ni jun b'welt tijye' chekej chi' re, jwi'l man ja' ri tanye' in chi tijem tinimani' laj ranm jun cristian, trana' chapca' jun relexeb' ja' chi jye'ic jun tzilaj c'aslemal re riq'ui Kakaj Dios lecj ri ta' jq'uisic. ");
INSERT INTO uspNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Man anm xij chic re Kakaj Jesús: Kaj, ye' man ja' li chwe pire ma' tichekej chic ínchi' y ta' chiqui' impe neri chi resaj ja', xche' re. ");
INSERT INTO uspNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Kakaj Jesús xij chic re man anm: Jat, sic'tach awichjil y atk'aj chicch, xche' re. ");
INSERT INTO uspNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Man anm li xij: In ta' wichjil, xche' re. Kakaj Jesús xij re: Tz'eti' tab'ij chi ta' awichjil, ");
INSERT INTO uspNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","jwi'l job'chak chi winak quiek riq'uil xatc'uli'yc y man jun winak ri wi' aac'l lajori ma' awichjil ta'n. Tz'eti' ri xab'ij chwe chi ta' awichjil, xche' Kakaj Jesús re. ");
INSERT INTO uspNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Cuando xta man anm chi jilonli xijsaj re, xij: Kaj, tanta in ati' jun ajk'asal Jyolj Kakaj Dios. ");
INSERT INTO uspNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Yak kamam katit' aj Samaria xnimirsajtaka' jk'ij Kakaj Dios la' man witz ri, pero atak yak rijajl Israel tab'ijtak chi xike li tilmit Jerusalén tijna' tikanimirsajwi' jk'ij Kakaj Dios, xche' re. ");
INSERT INTO uspNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Kakaj Jesús xij chic re: At anm, coj ri tamb'ij chawe, tina tawna jun k'ij chi ta' chiqui' rajwax atpetak la' man witz ri y ta' chiqui' rajwax atb'etak Jerusalén chi jnimirsaj jk'ij Kakaj Dios. ");
INSERT INTO uspNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Atak aj Samaria ta' awetamak nen chi dios ri tanimirsajtak jk'ij, pero oj ri oj rijajl Israel ketami' chi ri' tz'etel Dios tikanimirsaj jk'ij jwi'lke jun rechak yak rijajl Israel ticolmajtak cristian laj jk'ab' jmacak. ");
INSERT INTO uspNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Pero tina tawna jun k'ij y lajori xtawi' man k'ij li cuando juntir yak ri tz'etel ajnimirsaltak jk'ij Kakaj Dios tijnimirsajtak jk'ij la' jsantilak y kes tz'etel tz'et tijnimirsajtaka' jk'ij, jwi'l Kakaj Dios ri' tijtoc yak ri tinimirsantak jk'ij la' jsantilak. ");
INSERT INTO uspNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Jwi'l Kakaj Dios santili'n, jwi'li'li yak ri tinimirsantak jk'ij rajwaxi' tijnimirsajtak jk'ij la' jsantilak chapca' raj Kakaj Dios tinimirsaj jk'ij, xche' re man anm. ");
INSERT INTO uspNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Man anm xij re: In wetami' chi tina pena jun ri b'il jwi'l Kakaj Dios chi tina jtaknach wich ulew ri tib'ijsaj Cristo re. Cuando re tipetc, tiyuki' jb'ij jcholajl chike juntir li, xche'. ");
INSERT INTO uspNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Kakaj Jesús xij chic re: Ini' ri tab'ij, ri intijin chi yoloj aac'l, xche' re. ");
INSERT INTO uspNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Aj tijini' Kakaj Jesús chi yoloj riq'ui man anm cuando xk'ajtakch yak ajtijol rib'ak chirij, rechak sub'laj xsaach jch'olak chi rilic chi Kakaj Jesús tijin tiyolow riq'ui jun anm. Pero ni jonok xtz'onin re nen raj o nen chac tijin chi yoloj riq'ui man anm li. ");
INSERT INTO uspNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Xpe man anm li, xcan jye' jk'ib' cla', xe' li tilmit chi jb'ij rechak cristian y xij rechak jilonri: ");
INSERT INTO uspNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","Jo' kile'tak jun winak ri xij chwe juntir nen ri b'anal inwi'l. Pent ri' ri b'il jwi'l Kakaj Dios chi tina jtaknach wich ulew, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Y sub'laj cristian li tilmit xe'tak chi rilic Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Cuando b'esal man anm chi jsiq'uij cristian, xpetak yak ajtijol rib'ak chirij Kakaj Jesucristo sub'laj xpwersijtak Kakaj Jesús chi tijtij jwa, xijtak re: Kajtijonl, tij aw, xche'tak re. ");
INSERT INTO uspNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Kakaj Jesús xij rechak: In wi' inw re tantij, atak ta' awetamak nen chi wa lal, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Yak ajtijol rib'ak chirij xoctak chi jtz'onaj chirib'il rib'ak: ¿Woninti jonok xc'amowch jwa? xche'tak. ");
INSERT INTO uspNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Pero Kakaj Jesús xij chic rechak: Pi jq'uexwach inw ri' tamb'an lawi' raj Kakaj Dios tamb'an ri in takowinakch y tina inq'uisna jb'anic ri xij chwe. ");
INSERT INTO uspNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Atak wi' jun ayoljak ri tab'ijtak: Aj raji' quejab' ic' pire tikachol jmolic jwich man tico'n, atche'tak. Pero in tamb'ij chawechak: Na'tuntak, iltak juntir mak tico'n k'anchak, tzichak pire timolsaj jwich. ");
INSERT INTO uspNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Jun ajmolol jwich tico'n tijc'ula' jtojb'l y ri jwich tico'n ri tijmol pirechi' jun tzilaj c'aslemal riq'ui Kakaj Dios lecj ri ta' jq'uisic, jwi'li'li man ajticonl pach man ajmolol tico'n tiqui'cottaka'n. ");
INSERT INTO uspNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Chapca' tijb'ij tzij: Jalan titiconanc y jalan timolow jwich man tico'n, tiche'. ");
INSERT INTO uspNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","In xatintaktakb'i pire atb'etak chi jmolic jwich man tico'n ri lamas ta' xatchacuntak. Jalan xchacuntak re y atak xatmolowtak jwich man tico'n li, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Sub'laj q'ui cristian re man tilmit li re Samaria xcub'ar jch'olak chirij Kakaj Jesús jwi'l ri xe' jb'ij man anm rechak, cuando xij rechak: Re xij chwe juntir nen ri b'anal inwi'l, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Cuando xtawtak mak aj Samaria riq'ui Kakaj Jesús, sub'laj pwers xantak re pire tican riq'uilak. Kakaj Jesús xcan quib' k'ij riq'uilak cla'. ");
INSERT INTO uspNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Y wi' chiqui' sub'laj q'ui cristian ri xcojtak ri xij Kakaj Jesús rechak. ");
INSERT INTO uspNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Mak cristian xijtak re man anm: Lajori xcub'ari' kach'ol chirij, ma' xita'ke jwi'l ri xab'ij chike, jwi'li' xkata' jyolj ri tijb'ij. Lajori xketemaji' chi ri' re ri ajcolol rechak juntir cristian laj jk'ab' jmacak, xche'tak. ");
INSERT INTO uspNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Cuando xk'ax mak quib' k'ij li, ajruc're' Kakaj Jesús xelb'i Samaria xe' Galilea. ");
INSERT INTO uspNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Kakaj Jesús b'ili' jwi'l chi jun ajk'asal Jyolj Kakaj Dios ta' ticojsaj jk'ij y ta' tic'ulsaj pi utzil laj jtilmit. ");
INSERT INTO uspNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Cuando xtaw Kakaj Jesús Galilea xc'ulsaji' pi utzil jwi'lak yak cristian, jwi'l rechak xpetaka' Jerusalén chi rilic nimak'ij Pascua y rechak xrila'taka' juntir ri xan cla'. ");
INSERT INTO uspNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Kakaj Jesús, cuando xtaw Galilea, xe' suc'ul Caná re Galilea lamas xan chi xwux ja' pi vin. Cla' wi' jun jb'ab'alak mak jsoldad man rey sub'laj yaj jun jc'ajol ri wi' Capernaúm. ");
INSERT INTO uspNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Y man jb'ab'al soldad li, cuando xta jtaquil chi Kakaj Jesús xtaw chiqui' Galilea ji' jpetic Judea, xe' rile' y xtz'onaj tok'ob' re chi tib'e riq'uil laj richoch pire tib'e jtzib'saj jc'ajol ri camic re. ");
INSERT INTO uspNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Kakaj Jesús xij re: Atak ajri' tacojtak asta tina awiltakna c'utb'i jcwinel Kakaj Dios, xche' re. ");
INSERT INTO uspNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Man jb'ab'al soldad xij chic re: Kaj, b'an tok'ob', nab'e jo' laj or wiq'uil chiwch ticam inc'ajol, xche' re. ");
INSERT INTO uspNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Kakaj Jesús xij chic re: Jat laj awichoch, ac'ajol yo'li'n, xche' re. Man jb'ab'al soldad li xe' laj richoch, xcoja' nen xijsaj re jwi'l Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Cuando tawem tran laj richoch, xeltakch mak jmocom chi jc'ulic, xijtak re: ¡Ac'ajol yo'li'n! xche'tak re. ");
INSERT INTO uspNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Y re xtz'onaj rechak nen chi or lal xcholmaj jtzib'ic. Rechak xijtak re: Li nab'e or re b'esal k'ij xel man k'ak' chirij, xche'tak re. ");
INSERT INTO uspNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Ajruc're' jkaj man ral ac'l li xcuxtaj jwi'l chi ri' man or li, ri xijsaj re jwi'l Kakaj Jesús chi jc'ajol yo'li'n. Re pach rixokl y juntir ralc'wal xcub'ar jch'olak chirij Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Ri' li jcab' c'utb'i jcwinel Kakaj Dios ri xan Kakaj Jesús cuando xtaw Galilea ji' jpetic Judea. ");
INSERT INTO uspNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Cuando xk'ax quib' uxib' k'ij jb'antaj juntir li jwi'l Kakaj Jesús, xe' Jerusalén jwi'l jun nimak'ij ri trantak yak rijajl Israel. ");
INSERT INTO uspNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Y li man tilmit li chijc'ulel man pwert re oqueb' ri tib'ijsaj Jpwert Mak Carner re, wi' jun nimlaj c'otob' b'anal cla' ri tib'ijsaj Betesda re li tz'ijb'al hebreo. Y chak'chi' man c'otob' li sutul rij la' job' chinam. ");
INSERT INTO uspNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Y laj jmujalak mak chinam li wi' sub'laj q'ui yaj tz'e'ltak, wi' moytak, co'xtak y siquirnak jtio'jlak tijin trulb'ejtak tisilib' man ja'. ");
INSERT INTO uspNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Jwi'l wi' jujun b'welt tikejch jun ranjl Kakaj Dios chi jsilib'saj man ja' li y nen jono rechak yak cristian ri yajtak ri nab'e tikej li man ja' cuando tisilib'saj jwi'l anjl, titzib'i' re nen chi yajel ri wi' re. ");
INSERT INTO uspNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Y cla' wi' jun winak yaj ri xana' junwinak waxaklajuj (38) junab' jta'ic jyaj jwi'l. ");
INSERT INTO uspNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Kakaj Jesús, cuando xril chi tz'e'l sic' winak cla' xretemaj chi ojrchak yaj, xtz'onaj re: ¿Chawajni' attzib'c? xche' re. ");
INSERT INTO uspNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Sic' winak yaj xij re Kakaj Jesús: Kaj, ta' nen inkesan li ja' cuando tisilib'saj man ja' jwi'l anjl. Nojel b'welt cuando chwaj inkej li ja', jalan tikej nab'e chinwch, xche' re. ");
INSERT INTO uspNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Kakaj Jesús xij re: B'iiten, c'amb'i ach'atum che' y wo'coten, xche' re. ");
INSERT INTO uspNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Y laj or xtzib' sic' winak, xc'amb'i jch'atum che' y xwo'cotc. Y jwi'l man k'ij li k'iji' re uxlan, ");
INSERT INTO uspNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","xpe mak jb'ab'alak yak rijajl Israel, xijtak re sic' winak li: Lajori k'iji' re uxlan, ta' ye'l luwar chawe tawikajb'i ach'atum che', xche'tak re. ");
INSERT INTO uspNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Sic' winak li xij rechak: Winak ri xintzib'sanc, xij chwe: C'amb'i ach'atum che' y wo'coten, xche' chwe, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Rechak xtz'onajtak re: ¿Nen xin chawe chi tac'amb'i ach'atum che' y atwo'cotc? xche'tak re. ");
INSERT INTO uspNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Y sic' winak ta' xcwin chi jc'utic nen xtzib'san re, jwi'l Kakaj Jesús xsach rib' xo'lak sub'laj q'ui cristian ri wi'tak cla'. ");
INSERT INTO uspNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Cuando xantaj juntir li, Kakaj Jesús xril chic jwich sic' winak b'atz'aak re nimi richoch Kakaj Dios y xij re: Ta jcholajl, lajori xattzib'i'n, mat macun chic pire ma' tipe jun ayaj mas c'ax chic chiwch ri xata', xche' re. ");
INSERT INTO uspNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Xpe sic' winak li, xe' jb'ij rechak mak jb'ab'alak yak rijajl Israel chi ri' Kakaj Jesús ri xtzib'san re. ");
INSERT INTO uspNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Mak jb'ab'alak yak rijajl Israel takel rij Kakaj Jesús jwi'lak pire trantak c'ax re asta tijcamsajtak jwi'l xtzib'saj sic' winak la' k'ij re uxlan. ");
INSERT INTO uspNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Kakaj Jesús xij rechak: Inkaj nojel k'ij tijin tran utzil y jilon in, tamb'ana' utzil, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Jwi'li'li xpe chic mas retzalak mak jb'ab'alak yak rijajl Israel chirij, rajak roj tijcamsajtak jwi'l re xan lawi' ri ta' ye'l luwar tib'an la' k'ij re uxlan y jwi'l re ri' raj tijniq'uib'saj rib' riq'ui Kakaj Dios jwi'l xij chi ri' Kakaj Dios Jkaj. ");
INSERT INTO uspNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Kakaj Jesús xij chic rechak: Kes tz'etel tz'et tamb'ij chawechak chi Jc'ajol Kakaj Dios ta' nen tran pi ric'an, xike tran lawi' ri tril ri tran Jkaj. Juntir ri tran Jkaj, jilon tran Jc'ajol. ");
INSERT INTO uspNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Kakaj Dios tijlok'aji' Jc'ajol y juntir ri tran tijc'uta' chiwch y tijc'uta' mas nimaktak kelen chiwch ri sub'laj sachom ch'olal rilic ri xawiltak lajori, ri tisachow mas ach'olak chi rilic. ");
INSERT INTO uspNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Jilon chapca' Kakaj Dios tijc'astasaj jwichak camnakib' pire tijye' chic jc'aslemalak y jilon Jc'ajol Kakaj Dios tijya' jc'aslemal nen quiek re raj tijye' jc'aslemal. ");
INSERT INTO uspNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Y Kakaj Dios ta' tran jk'atb'itzij chib' jono cristian, xjacha' juntir jk'atb'itzij laj jk'ab' Jc'ajol y ri' Jc'ajol tib'anow k'atb'itzij chib'ak juntir cristian wich ulew, ");
INSERT INTO uspNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","pire juntir cristian tijcojtak jk'ij Jc'ajol Kakaj Dios chapca' trantak chi jcojic jk'ij Kakaj Dios. Nen ta' tijcoj jk'ij Jc'ajol Kakaj Dios, ta' tijcoj jk'ij Kakaj Dios ri xtakowch re. ");
INSERT INTO uspNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Kes tz'etel tz'et tamb'ij chawechak, nen tijta inyolj ri tamb'ij y ticub'ar jch'ol chirij ri intakowinakch, tijta' tzilaj c'aslemal riq'ui Kakaj Dios lecj ri ta' jq'uisic. Y ta' tib'an k'atb'itzij chib', nic' riq'uil xcami'n y xc'astasaji' jwich laj jcamnakl. ");
INSERT INTO uspNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Kes tz'etel tz'et tamb'ij chawechak chi tina tawna jun k'ij y lajori xtawi' k'ij cuando yak cristian ri nic' riq'uil camnaktak tijtatak jyolj Jc'ajol Kakaj Dios. Y yak ri tijtatak jyolj Jc'ajol Kakaj Dios y trantak lawi' ri tijb'ij tiyo'rtaka'n. ");
INSERT INTO uspNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Jilon chapca' Kakaj Dios wi' jcwinel chi jye'ic jc'aslemal ric'an, xya' jcwinel Jc'ajol chi jye'ic jc'aslemal. ");
INSERT INTO uspNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Y xya' k'atb'itzij laj jk'ab' pire tran k'atb'itzij chib'ak juntir cristian jwi'l ri' Jc'ajol ri xwux pi cristianil. ");
INSERT INTO uspNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Mi sach ach'olak chi jtaic juntir ri, jwi'l tina tawna jun k'ij juntir camnakib' tina jtatakna jyolj Jc'ajol Kakaj Dios laj jluwrak lamas mukultak ");
INSERT INTO uspNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","y tina eltaknach lamas mukultak. Yak ri xantak tzitaklaj no'j tic'astasaj jwichak laj jcamnaklak pire tijta'tak tzilaj c'aslemal riq'ui Kakaj Dios lecj ri ta' jq'uisic. Pero yak ri xantak etzltak no'j tic'astasaj jwichak laj jcamnaklak pire tib'an k'atb'itzij chib'ak. ");
INSERT INTO uspNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","In, ta' tamb'an ink'atb'itzij pi wic'an. In tamb'an ink'atb'itzij chib' jun cristian jilon chapca' ri b'il chwe jwi'l Kakaj Dios y ink'atb'itzij ri tamb'an pi jcholajli'n. Jwi'l ma' ri' ta' tamb'an lawi' ri chwaj in, ri' tamb'an lawi' raj ri intakowinakch. ");
INSERT INTO uspNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Y wi inke imb'in chwij chi tz'eti' ri tijin tamb'ij, juntir ri tamb'ij ta' nen tichacuj. ");
INSERT INTO uspNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Pero wi' jun tib'in chwij in chi tz'eti' ri tamb'ij y in wetami' chi lawi' ri tijb'ij re chwij, kes tz'etel tz'eti'n. ");
INSERT INTO uspNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Atak xataktak jtz'onaj re Juan Ajb'anal Ja'tiox y juntir ri xij re kes tz'eti'n. ");
INSERT INTO uspNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Pero pi we in ta' rajwax jono cristian tib'in chwij chi tz'etel tz'eti' ri tamb'ij. In tamb'ij jilonli pirechi' atcolmajtak laj jk'ab' amacak. ");
INSERT INTO uspNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Juan Ajb'anal Ja'tiox jilon chapca' jun k'ak' tijumin jk'ak'al y tijsakab'saj juntir y atak xatqui'cottaka' quib' uxib' k'ij jwi'l jsakil ri xan. ");
INSERT INTO uspNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Pero wi' chiqui' nen tib'in chwij chi tz'etel tz'eti' ri tamb'ij. Re masna tresaj chi sakil chiwch ri xij Juan Ajb'anal Ja'tiox, jwi'l juntir ri tamb'an ri' ri xij Kakaj Dios chwe chi tamb'an y ri' li tic'utuw chi ri' Kakaj Dios ri intakowinakch. ");
INSERT INTO uspNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Y ri' Kakaj Dios ri intakowinakch tib'in chwij chi tz'etel tz'eti' ri tamb'ij y atak ta' tal jyolj awi'lak y ta' ilan jwich awi'lak. ");
INSERT INTO uspNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Witi tioc Lok'laj Jyolj Kakaj Dios laj awanmak, ticub'ari' ach'olak chirij ri takalch jwi'l Kakaj Dios. ");
INSERT INTO uspNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Atak tziyi' jtoquic jcholajl li wuj re Lok'laj Jyolj Kakaj Dios tab'antak jwi'l tab'ij laj awanmak chi cla' tijb'ij nen tab'antak chi jta'ic jun tzilaj c'aslemal riq'ui Kakaj Dios lecj ri ta' jq'uisic y ri' wuj re Lok'laj Jyolj Kakaj Dios li tib'in chwij chi tz'eti' ri tamb'ij. ");
INSERT INTO uspNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Pero ta' chawajak tatatak inyolj pire tata'tak tzilaj c'aslemal riq'ui Kakaj Dios lecj ri ta' jq'uisic. ");
INSERT INTO uspNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","In ta' chwaj tinimirsaj ink'ij jwi'lak yak cristian. ");
INSERT INTO uspNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Y wetami' ano'jak y wetami' chi ta' talok'ajtak Kakaj Dios. ");
INSERT INTO uspNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","In, Kakaj Dios intakowinakch y atak ta' tac'ultak inyolj, pero wi wi' jun chic laj jno'jke re tipetc, ri' li tac'ula'taka' jyolj pi utzil. ");
INSERT INTO uspNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Atak ta' tacojtak ri tamb'ij jwi'l ri' mas kus tawiltak tacoj ak'ijak chawib'il ayb'ak y ta' atoctak il chi jb'anic utzil pire ticojsaj ak'ijak jwi'l Kakaj Dios ri xike re jun chi Dios. ");
INSERT INTO uspNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Ma b'ij laj awanmak chi in, incojow tzij chawijak chiwch Kakaj Dios. Ri ticojow tzij chawijak chiwch Kakaj Dios, ri' Moisés ri cub'ul ach'olak chirij. ");
INSERT INTO uspNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Atak, witi tacojtak ri xij Moisés, titica' acojtakre' ri tamb'ij in jwi'l Moisés xtz'ib'aji' li wuj chwij in. ");
INSERT INTO uspNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Pero wi mita' tacojtak ri xtz'ib'aj Moisés, ta' tacojtak ri tamb'ij in chawechak, xche' Kakaj Jesús rechak mak jb'ab'alak yak rijajl Israel. ");
INSERT INTO uspNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Cuando xantaj li, Kakaj Jesús xe' ch'akap re nimlaj alagun ri jb'ij Galilea y ri tib'ijsaj Tiberias re. ");
INSERT INTO uspNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Sub'laj q'ui cristian xamb'ertak chirij jwi'l xrila'taka' mak c'utb'i jcwinel Kakaj Dios ri xan chi jtzib'saj cristian re jyajak. ");
INSERT INTO uspNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Xpe Kakaj Jesús, xjaw wich jun witz pach yak ajtijol rib'ak chirij y xcub'artak cla'. ");
INSERT INTO uspNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Tawem tran jnimak'jak yak rijajl Israel ri jb'ij Pascua. ");
INSERT INTO uspNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Kakaj Jesús xril chi sub'laj q'ui cristian xmulb'a' rib'ak chirij, xtz'onaj re Felipe: ¿Lamas tikalok' cuxlanwa pire tijtijtak juntir yak cristian ri? xche' re. ");
INSERT INTO uspNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Re xij jilonli ri'ke raj tijta nen tijb'ij Felipe. Re retami' nen tran chi jtzukicak. ");
INSERT INTO uspNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Felipe xij re Kakaj Jesús: Pero ni ta' tran quib' cient (200) denario pire tilok'saj cuxlanwa la' pire tijtijtak q'uitja' rechak chi jujunalak, xche' re. ");
INSERT INTO uspNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Xpe Andrés ri jk'un Simón Pedro, jun rechak yak ajtijol rib'ak chirij Kakaj Jesucristo, xij re Kakaj Jesús: ");
INSERT INTO uspNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","Neri wi' jun ral ac'l c'amalch job' cuxlanwa jwi'l b'anal la' cebada pach quib' car, pero ta' tran pire juntir cristian ri, xche' re. ");
INSERT INTO uspNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Kakaj Jesús xij rechak yak ajtijol rib'ak chirij: B'ijtak rechak juntir cristian chi ticub'artak, xche' rechak. Y la' man luwar li wi' sub'laj q'uim y chib' mak q'uim li xcub'artak juntir cristian, raj wi'taka' job' (5,000) mil xike winak. ");
INSERT INTO uspNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Xpe Kakaj Jesús, xc'am mak cuxlanwa li y xc'omowaj re Kakaj Dios, ajruc're' xij chi tijachsaj chiwchak juntir cristian ri xcub'artak y jilon xan re mak car. Y mak cristian xwi'ntak asta xnojtak. ");
INSERT INTO uspNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Cuando xcolajtak, xpe Kakaj Jesús xij rechak yak ajtijol rib'ak chirij: Moltak mak q'uer cuxlanwa ri ta' xq'uis pire ma' tican sachok, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Y rechak xc'oltak juntir mak q'uer cuxlanwa ri b'anal la' cebada y xnojsajtakna cab'lajuj (12) chicach ri ta' xq'uisc. ");
INSERT INTO uspNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Juntir cristian cuando xriltak man c'utb'i jcwinel Kakaj Dios ri xan Kakaj Jesús, xijtak: Tz'etel tz'et winak ri, ri' ajk'asal Jyolj Kakaj Dios ri tina pena wich ulew, xche'tak. ");
INSERT INTO uspNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Kakaj Jesús retami' nen jchomorsa'nak chi rechak ri' rajak tijchaptakb'i pire tijcojtak pire re rey, jwi'li'li xelb'i cla', xak'an chic mas b'a witz pi ric'an. ");
INSERT INTO uspNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Cuando xoc ak'ab' yak ajtijol rib'ak chirij Kakaj Jesucristo xkejtakb'i chi' nimlaj alagun. ");
INSERT INTO uspNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Y xjawtakb'i li jun barc pire tik'axtakb'i ch'akap re nimlaj alagun pire titawtak Capernaúm. Uku'mchak y ajqui' chi taw Kakaj Jesús riq'uilak. ");
INSERT INTO uspNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Xpe jun quiek'ek' tew b'a ja' y xoc chi ritz'b'ej mak retumb re man nimlaj alagun. ");
INSERT INTO uspNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Cuando xjutuntakb'i raj jun lewa pach pajnic'j b'a nimlaj alagun ri'chak xriltak Kakaj Jesús tijin tib'ench b'a nimlaj alagun y tijin tijutun chijc'ulel man barc, rechak sub'laj xtzaak jch'olak. ");
INSERT INTO uspNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Xpe Kakaj Jesús, xij rechak: Ini'n, mi tzaak ach'olak, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Ajruc're' rechak sub'laj xqui'cottak xijtak re Kakaj Jesús chi tijaw riq'uilak li barc. Y cuando xjaw Kakaj Jesús li barc, ri'chak xric'ajtak wi'takchak chi' nimlaj alagun la' man luwar lamas rajak titawtak. ");
INSERT INTO uspNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Laj jcab' k'ij mak cristian ri xcantak ch'akap re man nimlaj alagun xretemajtak chi yak ajtijol rib'ak chirij Kakaj Jesucristo xi'taka' li jun barc ri wi' chi' nimlaj alagun y xike jun barc li ri wi' cla' y Kakaj Jesús ta' xe' chijxo'lak. ");
INSERT INTO uspNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Y wi' nic'j barc chic ri tipetak Tiberias xtawtak chi' nimlaj alagun nakaj re lamas xtijtak mak cuxlanwa sub'laj q'ui cristian cuando Kakaj Jesús jorok jc'omowaji' re Kakaj Dios. ");
INSERT INTO uspNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Mak cristian, cuando xriltak chi ta' Kakaj Jesús cla' pach yak ajtijol rib'ak chirij, xjawtakb'i li mak barc li, xe'tak Capernaúm chi jtoquic Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Cuando mak cristian xtawtak ch'akap re man nimlaj alagun, xe' jte'tak Kakaj Jesús xtz'onajtak re: Ajtijonl, ¿nen or xatyuk neri? xche'tak re. ");
INSERT INTO uspNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Kakaj Jesús xij rechak: Kes tz'etel tz'et tamb'ij chawechak chi atak tijin inatoctak jwi'lke xatijtak mak cuxlanwa wiq'uil asta xatnojtak. Y ma' jwi'l ta' xawetemajtak jcholajl mak c'utb'i jcwinel Kakaj Dios ri ximb'an. ");
INSERT INTO uspNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Mat octak il chi chac pire jch'equic awak ri tike saach jwich, ri' oquentak il chi chac pire jch'equic awak ri ta' jsachic jwich ri tiye'w jun tzilaj c'aslemal chawechak riq'ui Kakaj Dios lecj ri ta' jq'uisic. Y ri' Jc'ajol Kakaj Dios ri xwux pi cristianil tiye'w wa li chawechak, jwi'l Kakaj Dios xc'uta' chi ri' re xtakowch re, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Jwi'li'li mak cristian xtz'onajtak re Kakaj Jesús: ¿Nenc'u rajwax tikab'an pire ojcwin chi jb'anic lawi' raj Kakaj Dios tikab'an? xche'tak re. ");
INSERT INTO uspNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Kakaj Jesús xij chic rechak: Ri raj Kakaj Dios tab'antak, ri' cub'a' ach'olak chirij jun ri takalch jwi'l, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Rechak xtz'onajtak chic re: ¿Nen jono c'utb'i jcwinel Kakaj Dios tac'ut chikawch pire tikil y tikacoj ayolj? ¿Nen jono kelen atcwin chi jb'anic? ");
INSERT INTO uspNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Kamam katit' ojrtaktzij xtija'taka' maná li chekej luwar chapca' tz'ib'al li wuj re Lok'laj Jyolj Kakaj Dios ri tijb'ij jilonri: Re xya' cuxlanwa re lecj rechak chi tijem, tiche', xche'tak mak cristian re Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Kakaj Jesús xij chic rechak: Kes tz'etel tz'et tamb'ij chawechak, ma' ri' ta' Moisés xye'w cuxlanwa re lecj rechak chi tijem, ri' Inkaj xye'w. Y lajori ri' tiye'w tz'etel cuxlanwa re lecj chi tijem chawechak. ");
INSERT INTO uspNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Jwi'l cuxlanwa ri tijye' Kakaj Dios chi tijem, ri' ri xkejch lecj y xyuk wich ulew y ri' re tiye'w jun tzilaj c'aslemal rechak cristian. ");
INSERT INTO uspNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Mak cristian xijtak chic re: Kaj, ye' man cuxlanwa li chike nojel k'ij, xche'tak re Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Kakaj Jesús xij chic rechak: Ini' man cuxlanwa ri tiye'w jun tzilaj c'aslemal. Y nen inc'uluw laj ranm ni jun b'welt tijye' chic wi'jal re y nen tijcub'a' jch'ol chwij ni jun b'welt tijye' chekej chi' re. ");
INSERT INTO uspNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Ximb'iji' chawechak chi xawila'taka' inwch, pero ta' ticub'ar ach'olak chwij. ");
INSERT INTO uspNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Juntir yak ri tijachsajtak laj ink'b' jwi'l Kakaj Dios tina petakna wiq'uil y nen tipe wiq'uil ta' twesajb'ic. ");
INSERT INTO uspNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Jwi'l in ji' impe lecj, ma' pire ta' tamb'an lawi' chwaj in, ri' tamb'an lawi' raj ri intakowinakch. ");
INSERT INTO uspNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Ri' ri raj tamb'an ri intakowinakch, re ta' raj tisaach jwich ni jono rechak yak ri jachal laj ink'b' jwi'l. Ri' raj tanc'astasaj jwichak laj jcamnaklak la' q'uisb'itak k'ij re jwich k'ijsak. ");
INSERT INTO uspNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Y ri' raj Inkaj chi juntir cristian ri tiiliwtak juntir ri tran Jc'ajol Kakaj Dios y ticub'ar jch'olak chirij, tijta'taka' jun tzilaj c'aslemal riq'ui Kakaj Dios lecj ri ta' jq'uisic y in tanc'astasaj jwichak laj jcamnaklak la' q'uisb'itak k'ij re jwich k'ijsak, xche' Kakaj Jesús rechak. ");
INSERT INTO uspNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Xpe yak rijajl Israel, xoctak chi yok'on chirijil Kakaj Jesús jwi'l xij: Ini' cuxlanwa ri xpe lecj, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Y yak rijajl Israel xijtak: Re jc'ajoli' José y oj tikach'ob'a' jwich jkaj jchuch. ¿Nen chac tijb'ij chi ji' xpe lecj? xche'tak. ");
INSERT INTO uspNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Kakaj Jesús xij chic rechak: Maytak yok'on chwijil. ");
INSERT INTO uspNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Ni jonok ticwin tipe wiq'uil wi ma' ri' ta' Kakaj Dios ri intakowinakch tijachow laj ink'b' y in tanc'astasaj jwich laj jcamnakl la' q'uisb'itak k'ij re jwich k'ijsak. ");
INSERT INTO uspNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Yak ajk'asaltak Jyolj Kakaj Dios xcan jtz'ib'ajtaka' chi juntir cristian titijojtaka' jwi'l Kakaj Dios. Juntir yak ri titawtak re ri tijb'ij Kakaj Dios y tretemajtak nen tijb'ij, tipetaka' wiq'uil. ");
INSERT INTO uspNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Ta' ni jonok iliwinak jwich Kakaj Dios, xike ri xpe lecj riq'ui Kakaj Dios ri iliwinak jwich Kakaj Dios. ");
INSERT INTO uspNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Kes tz'etel tz'et tamb'ij chawechak nen ticub'ar jch'ol chwij tijta' jun tzilaj c'aslemal riq'ui Kakaj Dios lecj ri ta' jq'uisic. ");
INSERT INTO uspNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","In ini' cuxlanwa ri tiye'w jun tzilaj c'aslemal. ");
INSERT INTO uspNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Yak amam atit'ak ojrtaktzij xtija'taka' maná ri xye'saj rechak li chekej luwar, pero xcamtaka'n. ");
INSERT INTO uspNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Pero ri tijin tamb'ij in chawechak ri' cuxlanwa ri xpe lecj, nen titijiw re, ta'chiqui' ticamc. ");
INSERT INTO uspNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Y in ini' cuxlanwa ri yo'l ri xpe lecj, nen titijiw re man cuxlanwa li, ta' chiqui' ticamc. Y man cuxlanwa li, ri' intio'jl ri tanye' pi camic pire tijta'tak jun tzilaj c'aslemal juntir cristian wich ulew, xche'. ");
INSERT INTO uspNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Yak rijajl Israel xpe retzalak, xoctak chi jtz'onaj chirib'il rib'ak: ¿Nen mo ticwin man winak ri, tijye' jtio'jl chike chi tijem? xche'tak. ");
INSERT INTO uspNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Kakaj Jesús xij chic rechak: Kes tz'etel tz'et tamb'ij chawechak wi mita' tatijtak jtio'jl y jquiq'uel Jc'ajol Kakaj Dios ri xwux pi cristianil, ta' tata'tak jun tzilaj c'aslemal. ");
INSERT INTO uspNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Y nen tijtij intio'jl y inquiq'uel tijta' jun tzilaj c'aslemal riq'ui Kakaj Dios lecj ri ta' jq'uisic y in tanc'astasaji' jwich laj jcamnakl la' q'uisb'itak k'ij re jwich k'ijsak. ");
INSERT INTO uspNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Jwi'l intio'jl ri' tz'etel wa y inquiq'uel ri' tz'etel uc'a'. ");
INSERT INTO uspNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Nen titijiw re intio'jl y inquiq'uel tiwa'xi' wiq'uil y inwa'xi' riq'uil. ");
INSERT INTO uspNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Kakaj Dios ri intakowinakch yo'li'n y jwi'l re yo'lquin in y ji'c'ulon nen ri titijow re intio'jl y inquiq'uel tiyo'ri' inwi'lke in. ");
INSERT INTO uspNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Tijin inyolow chirij man cuxlanwa ri xpe lecj. Amam atit'ak ojrtaktzij xtija'taka' maná, pero xcamtaka'n. Pero nen titijiw re man cuxlanwa ri, ta'chiqui' ticamc, xche'. ");
INSERT INTO uspNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Jilonli xij Kakaj Jesús chi jtijoj cristian li sinagog cuando wi' Capernaúm. ");
INSERT INTO uspNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Sub'laj q'ui rib'ilak yak ajtijol rib'ak chirij Kakaj Jesucristo xtatak ri xij Kakaj Jesús rechak, xijtak: Juntir ri tijb'ij sub'laj c'ax jtaic jcholajl. Ta' nen ticwin chi jb'anic juntir li, xche'tak. ");
INSERT INTO uspNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Kakaj Jesús retami' chi rechak ta' tzi xtatak ri xij rechak, xtz'onaj rechak: ¿C'axc'u xatatak ri ximb'ij chawechak? ");
INSERT INTO uspNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","¿Nen tab'antak wi tawiltak Jc'ajol Kakaj Dios ri xwux pi cristianil tik'aj lamas wi' nab'e? ");
INSERT INTO uspNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Ri' Lok'laj Jsantil Kakaj Dios ri tiye'w c'aslemal y jun cristian ta' ticwin chi jye'ic c'aslemal li. Mak yoloj ri ximb'ij chawechak, ri' ri xij Lok'laj Jsantil Kakaj Dios y ri' ri tiye'w c'aslemal. ");
INSERT INTO uspNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Pero wi' jujun chaxo'lak ta' tijcojtak ri tamb'ij, xche' Kakaj Jesús rechak yak ajtijol rib'ak chirij. Kakaj Jesús retamchakch ojrtaktzij nen jono mak ri ta' ticojowtak ri tijb'ij y retamchak nen tijachow re pi camic. ");
INSERT INTO uspNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Y Kakaj Jesús xij chic rechak: Jwi'li'li in ximb'ij chawechak chi ta' ni jonok tipe wiq'uil wi ma' Kakaj Dios ta' tijachow laj ink'b', xche' rechak yak ajtijol rib'ak chirij. ");
INSERT INTO uspNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Jwi'l xij Kakaj Jesús jilonli, sub'laj q'ui yak ajtijol rib'ak chirij xcan jye'tak, ta' chiqui' xamb'ertak chirij. ");
INSERT INTO uspNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Ajruc're' Kakaj Jesús xtz'onaj rechak yak cab'lajuj (12) ajtijol rib'ak chirij: ¿Miti jilon atak chawajaki' atb'etak? xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Xpe Simón Pedro, xij re: Wajawl, ¿nentic'u quiek riq'uil ojb'ec? Xike aac'l at wi' yoloj ri tiye'w jun tzilaj c'aslemal riq'ui Kakaj Dios lecj ri ta' jq'uisic. ");
INSERT INTO uspNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Oj tikacoja' ayolj y ketami' chi at ji' xatpe riq'ui Kakaj Dios y tosolcati' pire Kakaj Dios, xche' re Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Kakaj Jesús xij chic rechak: Ini' xincha'w awechak chi atak cab'lajuj (12), pero wi' jun chawechak etzli'n, xche'. ");
INSERT INTO uspNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Re tijin tiyolow chirij Judas Iscariote ri jc'ajol Simón Iscariote ri tijachow pi camic, Judas ri' jun rechak yak cab'lajuj (12) jtako'n Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Cuando xantaj li, Kakaj Jesús xwo'cot lak luwar re Galilea, ta' raj tib'e Judea jwi'l mak jb'ab'alak yak rijajl Israel rajak tijcamsajtak. ");
INSERT INTO uspNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Jwi'l tawem tran man nimak'ij ri jb'ij Tabernáculo jun jnimak'jak yak rijajl Israel, ");
INSERT INTO uspNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","xpe yak jk'un Kakaj Jesús, xijtak re: Mat wa'x neri, rajwaxi' atb'e Judea pire triltak yak ajtijol rib'ak chawij juntir ri tab'an. ");
INSERT INTO uspNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Ni jun cristian ri raj tich'ob'saj jwich tran kelen chi mukukil. At, wi tab'an mak kelen jilonli, b'an chiwchak juntir cristian, xche'tak re. ");
INSERT INTO uspNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Jilonli xijsaj re Kakaj Jesús jwi'lak yak jk'un jwi'l ta' tijcojtak ri tijin tran. ");
INSERT INTO uspNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Xpe Kakaj Jesús, xij rechak: Ajqui' chi taw k'ij pi we in, pero pi awe atak juntirke k'ij tzi. ");
INSERT INTO uspNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Mak cristian ri retake wich ulew, ta' atjxuttak. Pero in injxuta'taka' jwi'l in twesaji' chi sakil juntir mak etzltak no'j ri tijintak chi jb'anic. ");
INSERT INTO uspNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Jat atak li nimak'ij. In ta' imb'ec jwi'l ajqui' chi taw k'ij pi we in, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Cuando Kakaj Jesús xijmaj jilonli jwi'l rechak yak jk'un, xcan Galilea. ");
INSERT INTO uspNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Y Kakaj Jesús cuando jorok b'i' yak jk'un li nimak'ij, ajruc're' xe' chic re, chi mukukilke xe' rile' nimak'ij. ");
INSERT INTO uspNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Mak jb'ab'alak yak rijajl Israel xtoca'taka' Kakaj Jesús xo'lak cristian li nimak'ij, xijtak: ¿Lachiqui'mas wi' man winak? xche'tak. ");
INSERT INTO uspNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Y xo'lak cristian wi' nic'j tijintak chi yoloj chirib'il rib'ak chirijil Kakaj Jesús. Wi' jujun tijb'ijtak: Jun tzilaj winaki'n, tiche'tak. Y jujun chic tijb'ijtak: Ma' jun tzilaj winak ta'n, tike tijin tijsub' cristian, tiche'tak. ");
INSERT INTO uspNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Pero chirib'ilke rib'ak tiyolowtak chirij Kakaj Jesús jwi'l titzaak jch'olak chiwchak mak jb'ab'alak yak rijajl Israel. ");
INSERT INTO uspNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Cuando xnic'ajir man nimak'ij, ajruc're' Kakaj Jesús xjawb'i li nimi richoch Kakaj Dios y xoc chi jtijojcak cristian. ");
INSERT INTO uspNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Mak jb'ab'alak yak rijajl Israel sub'laj xsaach jch'olak chi jtaic, xijtak: ¿Lachiqui'mas xretemaj sub'laj jno'j y lachiqui'mas xtijojwi' rib'? xche'tak. ");
INSERT INTO uspNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Kakaj Jesús xij rechak: Ri tijon tamb'an ma' we ta' in, rechi' Kakaj Dios ri intakowinakch, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Wi wi' jonok raj tran lawi' raj Kakaj Dios tran, tijch'ob'a' wi ji' petzal riq'ui Kakaj Dios ri tijon tamb'an o laj imb'ke tipe'w ri tamb'ij. ");
INSERT INTO uspNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Jun ri laj jb'ake tipe'w ri tijb'ij, ri'ke raj ticojsaj jk'ij jwi'lak cristian, pero nen jonok tran jun kelen pire ticojsaj jk'ij ri xtakowch re, re tijb'iji' tz'etel tzij y ta' tijb'ij jo'slaj tzij. ");
INSERT INTO uspNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Moisés xcan jye' mak pixab' li chawechak, pero ni jono chawechak ticojow mak pixab' li. ¿Nen chac chawajak inacamsajtak? xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Mak cristian xijtak re: At wi' etzl laj awanm, ta' ni jun tijchomorsaj acamsaj, xche'tak re. ");
INSERT INTO uspNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Kakaj Jesús xij rechak: Jwi'lke jun chi c'utb'i jcwinel Kakaj Dios ximb'an la' k'ij re uxlan atak juntir sub'laj xsaach ach'olak chi rilic. ");
INSERT INTO uspNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Moisés xatjtaktak chi jcojic retal atio'jlak. Pero ma' ri' ta' re xcholow jb'anic jilonli, ri'taka' yak amamak xcholowtak jcojic retal jtio'jlak y atak la' k'ij re uxlan tacoja'taka' retal jtio'jlak yak ac'ajolak. ");
INSERT INTO uspNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Wi atak ma' jwi'l ta' tik'ax mas awechak chiwch Jpixb' Kakaj Dios cuando tacojtak retal jtio'jl yak ac'ajolak lak k'ij re uxlan, ¿nen chac xpe awetzalak chwij in jwi'l xintzib'saj jun cristian la' k'ij re uxlan? ");
INSERT INTO uspNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Atak ma b'ijtak chi jun cristian ta' tzi tran jwi'lke ri tawiltak, rajwaxi' tachomorsajtak nen tab'ijtak pire ma' tab'ijtak jun yoloj ri ma' pi jcholajl ta'n, xche'. ");
INSERT INTO uspNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Ajruc're' xpetak nic'j cristian aj Jerusalén xoctak chi jtz'onaj chirib'il rib'ak: ¿Ma' ron ta' winak li tijin jtoquic pire ticamsaj? ");
INSERT INTO uspNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Wi' quili tijin tiyolow riq'uilak cristian y ta' nen tib'ijsaj re. ¿Xcoja'takc'u mak jb'ab'alak yak rijajl Israel chi ri' re ri b'il jwi'l Kakaj Dios chi tina jtaknach wich ulew? ");
INSERT INTO uspNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Oj ketami' lamas tipe'w man winak li. Pero cuando tipet ri b'il jwi'l Kakaj Dios chi tina jtaknach wich ulew, ta' ni jonok tieteman re lamas tipe'w, xche'tak. ");
INSERT INTO uspNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Kakaj Jesús tijin chi jtijoj cristian li nimi richoch Kakaj Dios cuando xta chi jilonli tijin tib'ijsaj chirij, sub'laj cow xch'a'wc, xij: Atak tach'ob'a'taka' inwch y awetamaki' lamas impe'w, pero in ma' laj inno'j ta'ke ximpetc. In takalquinkech jwi'l jun ri kes tijna' ticub'ar jch'ol jun cristian chirij y atak ta' awetamak nen tran. ");
INSERT INTO uspNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","In wetami' nen tran jwi'l riq'uili' re petzalquinwi' y ri' re xintakowch, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Jwi'li'li rajak roj xchape'tak Kakaj Jesús, pero ni jonok xchapow re jwi'l ajqui' chi taw k'ij tichapsaj. ");
INSERT INTO uspNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Sub'laj q'ui cristian ri xcojowtak Jyolj, xijtak: Cuando tipe ri b'il jwi'l Kakaj Dios chi tina jtaknach wich ulew, ¿tonc'u rana' mas nimaktak c'utb'i jcwinel Kakaj Dios chiwch ri tran winak ri? xche'tak. ");
INSERT INTO uspNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Mak fariseo xtatak ri tijb'ijtak mak cristian chirij Kakaj Jesús. Xpe rechak pach mak jb'ab'alak yak ajc'amaltak jb'eak cristian riq'ui Kakaj Dios, xtaktak nic'j ajchajaltak re nimi richoch Kakaj Dios chi jchapic Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Xpe Kakaj Jesús, xij: In quib' uxib' k'ijke inwa'x aac'lak y ink'aj chic riq'ui ri xintakowch. ");
INSERT INTO uspNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Atak inatoca'taka' chiqui'n, pero ta' chiqui' inata'tak jwi'l ta' atcwintak chi b'enam lamas imb'e wa'xwi' in, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Ajruc're' xpe mak jb'ab'alak yak rijajl Israel, xoctak chi jtz'onaj chirib'il rib'ak: ¿Lamas chiqui' tib'e'w man winak ri, tijb'ij chi oj ta' ojcwin chi jta'ic? ¿Tonc'uti b'i' riq'uilak yak rijajl Israel ri tilem rib'ak chijxo'lak yak ma' rijajl ta' Israel pire tib'e jtijojtak yak ma' rijajl Israel? ");
INSERT INTO uspNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","¿Nen chiqui' jcholajl tielwi' ri xij chike chi atak inatoca'taka' chiqui'n, pero ta' chiqui' inata'tak jwi'l ta' atcwintak chi b'enam lamas imb'e wa'xwi' in? xche', xche'tak. ");
INSERT INTO uspNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Li man q'uisb'i k'ij re man nimak'ij, ri' man k'ij li ri mas nim jk'ij, xpe Kakaj Jesús xwa'r, sub'laj cow xch'a'wc, xij: Nen wi' chekej chi' re, petok wiq'uil jtije' ruc'a'. ");
INSERT INTO uspNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Nen ticojon chinwch chapca' ri tijb'ij li wuj re Lok'laj Jyolj Kakaj Dios, tina elexna ja' ri yo'l laj ranm, xche' Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Y ri jcholajl ri xij Kakaj Jesús rechak chiriji' Lok'laj Jsantil Kakaj Dios ri tijc'ultak laj ranmak yak cristian ri ticub'ar jch'olak chirij, pero ajqui' chi ye'saj Lok'laj Jsantil Kakaj Dios rechak jwi'l ajqui' chi k'ajb'i Kakaj Jesús lecj. ");
INSERT INTO uspNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Jujun rechak yak cristian, cuando xtatak chi jilonli xijsaj rechak, xijtak: Tz'etel tz'et winak ri, ri' ajk'asal Jyolj Kakaj Dios ri tina pena, xche'tak. ");
INSERT INTO uspNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Y nic'j chic xijtak: Ri' ri b'il jwi'l Kakaj Dios chi tina jtaknach wich ulew, xche'tak. Pero nic'j chic xijtak: Ri b'il jwi'l Kakaj Dios chi tina jtaknach wich ulew ma' ji'ta' tipe Galilea, xche'tak. ");
INSERT INTO uspNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Li wuj re Lok'laj Jyolj Kakaj Dios tijb'ij chi jun ri b'il jwi'l Kakaj Dios chi tina jtaknach wich ulew rijajli' David y ji' tipe Belén ri jtilmit David, xche'tak. ");
INSERT INTO uspNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Jwi'li'li mak cristian nak xtos rib'ak jwi'l ta' xniq'uib' jwich jyoljak chirij Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Y wi' jujun rechak rajak roj xchaptak Kakaj Jesús, pero ta' ni jonok xchapow re. ");
INSERT INTO uspNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Mak ajchajaltak re nimi richoch Kakaj Dios xk'ajtak chic riq'uilak mak fariseo pach mak jb'ab'alak yak ajc'amaltak jb'eak cristian riq'ui Kakaj Dios. Xpe rechak xtz'onajtak rechak mak ajchajaltak re nimi richoch Kakaj Dios: ¿Nen chac ta' xac'amtakch? xche'tak rechak. ");
INSERT INTO uspNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Mak ajchajaltak re nimi richoch Kakaj Dios xijtak: Ta' ni jono cristian tiyolow chapca' man winak li, xche'tak. ");
INSERT INTO uspNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Mak fariseo xtz'onajtak chic rechak: ¿Miti xaya' ayb'ak chi sub'em re man winak li? ");
INSERT INTO uspNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","¿Wonc'u jono rechak mak jb'ab'alak yak rijajl Israel o mak fariseo xcojowtak jyolj? ");
INSERT INTO uspNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Mak cristian ri ta' retamak nen tijb'ij Jpixb' Kakaj Dios, tib'ani' k'atb'itzij chib'ak, xche'tak rechak mak ajchajaltak re nimi richoch Kakaj Dios. ");
INSERT INTO uspNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nicodemo, jun rechak mak fariseo ri xe' solinok re Kakaj Jesús, xij rechak mak nic'j fariseo chic: ");
INSERT INTO uspNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","Kapixb' tijb'ij chi ta' tijna' tib'ansaj k'atb'itzij chib' jono cristian wi mita' titasaj nab'e nen b'anal jwi'l, xche' Nicodemo rechak mak jpach. ");
INSERT INTO uspNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Xpe mak jpach, xtz'onajtak re: ¿Atc'u aj Galilea? Toc impuch li wuj re Lok'laj Jyolj Kakaj Dios, tic'u awil chi ta' ni jono ajk'asal Jyolj Kakaj Dios tipe Galilea, xche'tak re. ");
INSERT INTO uspNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Ajruc're' juntir xe'tak laj richochak chi jujunalak. ");
INSERT INTO uspNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Pero Kakaj Jesús xe' b'a witz ri jb'ij Olivos. ");
INSERT INTO uspNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Y cuando xsakarsan laj jcab' k'ij, xk'aj chic li nimi richoch Kakaj Dios, sub'laj q'ui cristian xmulb'a' rib'ak chirij chi jtaic jyolj y re xcub'arc y xoc chi jtijojcak. ");
INSERT INTO uspNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Xpe yak ajtijoltak cristian re Jpixb' Kakaj Dios pach mak fariseo, xc'amtakch jun anm riq'ui Kakaj Jesús. Man anm li xe' jte'tak tijin tiechb'ej jwi'l jun jalan winak chic ri ma' jc'ulajl ta'n. Xwab'a'tak man anm li chiwchak juntir cristian ri wi'tak cla'. ");
INSERT INTO uspNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Y xijtak re Kakaj Jesús: Ajtijonl, man anm ri xkata'ch tijin tiechb'ej jwi'l jun jalan winak chic ri ma' jc'ulajl ta'n. ");
INSERT INTO uspNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Jpixb' Kakaj Dios tijb'ij chi ticamsaj chi ab'aj mak anm ri jilon trantak li. Y at, ¿nen tab'ij chirij? xche'tak re Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Rechak xijtak jilonli re Kakaj Jesús ri'ke rajak tijtatak wi ta' tzi tijb'ij chirij man anm li pire tijcojtak tzij chirij. Ajruc're' xpe Kakaj Jesús, xtacarc, xoc chi tz'ib'an lak ulew la' jb'a jk'ab'. ");
INSERT INTO uspNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Jwi'l rechak ta' tijmaytak jtz'onaj re Kakaj Jesús, xpe re xwa'rc y xij rechak: Nen jono chawechak ri ta' jmac, jt'oje' man nab'e ab'aj chirij man anm ri, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Xtacar chic xoc chic chi tz'ib'an lak ulew. ");
INSERT INTO uspNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Cuando xtatak yak ajtijoltak cristian re Jpixb' Kakaj Dios pach mak fariseo chi jilonli xijsaj rechak jwi'l Kakaj Jesús, xe'tak chi jujunalak. Ri' nab'e xe'tak mak ri'jab', ajruc're' xe'tak juntir mak jpachak. Xichak Kakaj Jesús xcan cla' pach man anm li. ");
INSERT INTO uspNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Kakaj Jesús xwa'r chic y xtz'onaj re man anm: At chuch, ¿lamas wi'takwi' mak ri xcojowtak tzij chawij? ¿Conta' jonok xanow jk'atb'itzij chawij? xche' re. ");
INSERT INTO uspNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Y man anm xij re: Ta' ni jonok, Kaj, xche' re. Kakaj Jesús xij re: Jilon in ta' tamb'an k'atb'itzij chawij. Jat y mat macun chic, xche' re. ");
INSERT INTO uspNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Kakaj Jesús xij rechak cristian: Ini' jun k'ak' pi rechak juntir cristian wich ulew. Nen titaken jb'anic lawi' ri tijb'ij inc'utu'n, tiwa'xi' chi sak ri tiye'w c'aslemal y ta' chiqui' tib'en li uku'mal, xche' Kakaj Jesús rechak. ");
INSERT INTO uspNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Xpetak mak fariseo, xijtak re Kakaj Jesús: Atke, atb'in chawij chi tz'eti' ri tijin tab'ij. Jwi'li'li ri tijin tab'ij ta' jcholajl, xche'tak re. ");
INSERT INTO uspNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Kakaj Jesús xij chic rechak: Tz'eti' chwijke in tijin tamb'ij, pero ri tijin tamb'ij kes tz'etel tz'eti'n, jwi'l in wetami' lamas ximpe'w y wetami' lamas imb'e'w. Pero atak ta' awetamak lamas ximpe'w, ni ta' awetamak lamas imb'e'w, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Atak tab'antak k'atb'itzij chirijak cristian la'ke mak no'j ri reke wich ulew, pero in ta' tamb'an k'atb'itzij chirij ni jono cristian. ");
INSERT INTO uspNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Y wi tamb'an k'atb'itzij chirij cristian, ink'atb'itzij ri tamb'an pi jcholajli'n, jwi'l in ta' tamb'an k'atb'itzij chirij cristian pi wic'an, impachi' Inkaj ri xintakowch. ");
INSERT INTO uspNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Lak wuj re apixb'ak tz'ib'ali' chi wi wi' quib' tib'intak nic' chirij ri ilan o tal jwi'lak ri' li ticojsajc. ");
INSERT INTO uspNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Tz'eti'n, ini' jun tijin tamb'ij chi tz'eti' ri tamb'ij. Y Kakaj Dios ri xintakowch ri' jun tib'in chwij chi tz'eti' ri tamb'ij, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Rechak xtz'onajtak chic re: ¿Lamas wi' akaj? xche'tak re. Kakaj Jesús xij chic rechak: Atak ta' awetamak nen tamb'an in y ta' awetamak nen tran Inkaj. Witi awetamak nen tamb'an in, awetamaki' nen tran Inkaj, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Kakaj Jesús xij juntir li cuando tijin chi jtijojcak cristian li nimi richoch Kakaj Dios la' man luwar lamas tiye'sajwi' pwak ri tisipaj re Kakaj Dios. Pero ni jonok xchapow re Kakaj Jesús jwi'l ajqui' chi taw k'ij tichapsaj. ");
INSERT INTO uspNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Kakaj Jesús xij chic rechak: In imb'i'n y atak inatoca'taka'n, pero ajwataka' laj jk'ab' amacak atcamtak. Atak ta' atcwintak chi b'enam lamas imb'e in, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Xpe mak jb'ab'alak yak rijajl Israel, xijtak: Re tijb'ij chi ta' ojcwin chi b'enam lamas tib'e'w, ¿tonc'u b'i jcamsaj rib'? xche'tak. ");
INSERT INTO uspNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Kakaj Jesús xij chic rechak: Atak ataka' aj neri wich ulew, pero in ji' impe lecj. Atak atake re wich ulew, pero in ma' in ta' re wich ulew. ");
INSERT INTO uspNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Jwi'li'li ximb'ij chawechak chi atak ajwataka' laj jk'ab' amacak atcamtak. Wi ta' tacojtak ri tamb'ij chwij in, ajwataka' laj jk'ab' amacak atcamtak, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Rechak xtz'onajtak re Kakaj Jesús: ¿Nenc'u ab'anic atb'an? xche'tak re. Y re xij chic rechak: Ojrchak xinticarch chi jb'ij chawechak nen imb'anic in. ");
INSERT INTO uspNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Wi' mas chwaj tamb'ij chawechak chirijak mak no'j ri ta' tzi ri tijin tab'antak. Ri intakowinakch tz'etel tz'eti' tijb'ij y ri tamb'ij in rechak juntir cristian ri' ri tal inwi'l ri tijb'ij ri intakowinakch, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Pero rechak ta' xmajtak chirij chi ri' Kakaj Dios ri tijin tijb'ij rechak. ");
INSERT INTO uspNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Jwi'li'li xij chic rechak: Cuando tacamsajtak wich curs Jc'ajol Kakaj Dios ri xwux pi cristianil, ajruc're' tawetemajtak nen imb'anic in. In ta' tamb'an jun kelen pi wic'an, in xike tamb'ij ri b'il chwe jwi'l Kakaj Dios. ");
INSERT INTO uspNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Kakaj Dios ri intakowinakch wi' wiq'uil, ta' canalquin wic'an jwi'l, jwi'l ri' tamb'an lawi' ri tzi tril re, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Cuando xij Kakaj Jesús jilonli, sub'laj q'ui cristian xcojowtak Jyolj. ");
INSERT INTO uspNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Kakaj Jesús xij rechak yak rijajl Israel ri xcub'ar jch'olak chirij: Atak wi kes tz'et tatakejtak jb'anic ri ximb'ij chawechak, tz'etel tz'et ataka' ajtijol ayb'ak chwij ");
INSERT INTO uspNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","y tawetemajtaka' tz'etel tzij ri quiek jwi'l attakmajtakb'ic, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Rechak xijtak re Kakaj Jesús: Oj oji' rijajl Abraham, ni jun b'welt xwa'x kajw. ¿Nen chac tab'ij at chi ojtakmajb'ic? xche'tak re. ");
INSERT INTO uspNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Kakaj Jesús xij chic rechak: Kes tz'etel tz'et tamb'ij chawechak, juntir cristian ri timacuntak, wi'taka' laj jk'ab' jmacak chapca' jun cristian wi' rajw. ");
INSERT INTO uspNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Jun cristian ri wi' rajw ta' tiwa'x pi ralc'wal ja, pero jun jc'ajol man patron tiwa'xi' jwi'l ralc'wal jai'n. ");
INSERT INTO uspNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Wi Jc'ajol Kakaj Dios atesantak laj jk'ab' amacak, kes tz'etel tz'et ateltaka' laj jk'ab' amacak. ");
INSERT INTO uspNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Wetami' chi atak ataka' rijajl Abraham, pero chawajak inacamsajtak jwi'l ta' tac'ultak inyolj. ");
INSERT INTO uspNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","In cuando inyolow, ri' tamb'ij ri c'utul chinwch jwi'l Inkaj y atak ri' tab'antak ri b'il chawechak jwi'l akajak, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Rechak xijtak chic re Kakaj Jesús: ¡Ri' kamam Abraham! xche'tak re. Kakaj Jesús xij chic rechak: Witi kes tz'et atak rijajl Abraham, titica' ab'antakre' chapca' xan re. ");
INSERT INTO uspNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","In ri' ximb'ij chawechak ri tz'etel tzij ri xij Kakaj Dios chwe y ajwichi' chawajak inacamsajtak. ¡Abraham ni jun b'welt xan jilonli! ");
INSERT INTO uspNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Atak jilon tab'antak chapca' tran akajak, xche' rechak. Rechak xijtak chic re Kakaj Jesús: Oj ma' oj ta' mak cristian ri ta' na'l nen jkajak, junke kakaj wi', xike Kakaj Dios, xche'tak. ");
INSERT INTO uspNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Kakaj Jesús xij chic rechak: Witi kes tz'et ri' Kakaj Dios akajak, intica' alok'ajtakre' jwi'l in ji' ximpe riq'ui Kakaj Dios y lajori win neri. In ta' ximpet laj inno'jke, Kakaj Diosi' xintakowch. ");
INSERT INTO uspNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Atak ta' tatatak jcholajl ri tamb'ij chawechak jwi'l ta' chawajak tatatak inyolj. ");
INSERT INTO uspNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Akajak ri' man jb'ab'al etzl y ri' chawajak tab'antak lawi' raj re tab'antak. Man jb'ab'al etzl ajcamsanli' cuando xcholmajch jwich k'ijsak. Ni jun b'welt tijb'ij tz'etel tzij jwi'l ta' tz'etel tzij laj jchi'. Cuando tijb'ij jun yoloj ri mita' tz'et jilon jb'ij tran chapca' tz'etel tzij, jwi'l re ajb'il jo'slaj tziji'n y ri' re jkajak mak ajb'il jo'slaj tzij. ");
INSERT INTO uspNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Jwi'l tz'etel tziji' tamb'ij chawechak, atak ta' tacojtak. ");
INSERT INTO uspNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","¿Nen jono chawechak ticwin chi jb'ij chi in wi' immac? Y wi tz'etel tziji' ri tamb'ij, ¿nen chac ta' tacojtak inyolj? ");
INSERT INTO uspNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Nen wi' laj jk'ab' Kakaj Dios tijcoja' Jyolj Kakaj Dios. Atak jwi'l ta' watak laj jk'ab' Kakaj Dios ta' chawajak tatatak Jyolj Kakaj Dios, xche' Kakaj Jesús rechak. ");
INSERT INTO uspNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Yak rijajl Israel xijtak chic re Kakaj Jesús: Tz'eti' ri tikab'ij chawij chi at ati' aj Samaria y wi' jun etzl laj awanm, xche'tak re. ");
INSERT INTO uspNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Kakaj Jesús xij chic rechak: In ta' ni jono etzl laj wanm. In ri' tancoj jk'ij Inkaj y atak ta' tacojtak ink'ij. ");
INSERT INTO uspNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","In ta' chwaj ticojsaj ink'ij, pero wi' jun ri raj ticojsaj ink'ij y re trana' jk'atb'itzij chirijak mak ri ta' tijcojtak ink'ij. ");
INSERT INTO uspNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Kes tz'etel tz'et tamb'ij chawechak chi nen jonok ticojow inyolj, ta' ticamc, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Yak rijajl Israel xijtak chic re Kakaj Jesús: Lajori ketamchak chi tz'eti' wi' jun etzl laj awanm. Abraham pach yak ajk'asaltak Jyolj Kakaj Dios xcamtaka'n y at tab'ij chi nen ticojow ayolj, ta' ticamc. ");
INSERT INTO uspNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","¿Masc'u nim ak'ij at chiwch kamam Abraham? Re xcami'n y yak ajk'asaltak Jyolj Kakaj Dios xcamtaka'n. ¿Nenc'u acholajl at? xche'tak re. ");
INSERT INTO uspNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Kakaj Jesús xij chic rechak: Witi tannimirsaj ink'ij in wic'an ta' nen tichacuj. Ri tinimirsan ink'ij ri' Inkaj ri tab'ij atak chi ri' aDiosak. ");
INSERT INTO uspNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Pero atak ta' awetamak nen tran, in wetami' nen tran y wi tamb'ij chi ta' wetam nen tran, ini' ajb'il jo'slaj tzij chapca' atak. Pero kes tz'etel tz'et wetami' nen tran y ri' tamb'an nen tijb'ij. ");
INSERT INTO uspNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Abraham ri amamak sub'laj xqui'cot cuando xta chi tina rilna titaw ink'ij. Cuando xril xtaw ink'ij sub'laj xqui'cotc, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Xpe yak rijajl Israel, xijtak chic re: Ajqui'ne' ca'winak lajuj (50) ajunb' y at tab'ij chi xawila' jwich Abraham, xche'tak re. ");
INSERT INTO uspNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Kakaj Jesús xij chic rechak: Kes tz'etel tz'et tamb'ij chawechak chi winchak cuando ajqui' chi q'uisi'y Abraham, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Xpe rechak, xe' jc'ame'tak ab'aj pire roj xcojtak re Kakaj Jesús. Pero re xmuk rib' xo'lak cristian xelb'i li nimi richoch Kakaj Dios. ");
INSERT INTO uspNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","K'axem tran Kakaj Jesús li b'e cuando xril jun sic' winak ri moychak cuando xq'uisi'yc. ");
INSERT INTO uspNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Xpe yak ajtijol rib'ak chirij Kakaj Jesucristo, xtz'onajtak re: Kajtijonl, ¿nen chac moychak winak ri cuando xq'uisi'yc? ¿Jwi'lni' xmacunc o jwi'li' jmac jkaj jchuch? xche'tak re Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Kakaj Jesús xij chic rechak: Ma' jwi'l ta' xmacunc, ni ma' jwi'l ta' xmacun jkaj jchuch. Pirechi' tiilsaj chirij re ri ticwin Kakaj Dios chi jb'anic. ");
INSERT INTO uspNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Cuando aj lak'ji'n, rajwaxi' tikab'antak neri wich ulew lawi' raj ri intakowinakch, jwi'l cuando tioc ak'ab' ta' chiqui' ni jonok ticwinc. ");
INSERT INTO uspNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Lajori in jwi'l ajwini' neri wich ulew, ini' jun k'ak' pi rechak juntir cristian wich ulew, xche' Kakaj Jesús rechak. ");
INSERT INTO uspNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Cuando xijmaj jilonli jwi'l Kakaj Jesús xchub'an lak ulew, xan jun raquitz xok'ol la' ra'l jchub', ajruc're' xtz'aj la' b'ak' jwich sic' moy. ");
INSERT INTO uspNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Y xij re: Jat ch'ajta acayb'al li man c'otob' ri jb'ij Siloé, xche' Kakaj Jesús re. (Ri jcholajl tielwi' man b'ij Siloé, takalb'ic.) Sic' moy xe' jch'aje' jcayb'al y cuando xk'ajch, tichak na'tunc. ");
INSERT INTO uspNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Xpetak mak jc'ulja pach mak cristian ri iliwinaktak re tijtz'onaj limoxn, xijtak: ¿Ma' ron ta' winak ri ticub'ar chi jtz'onaj limoxn? xche'tak. ");
INSERT INTO uspNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Wi' jujun rechak xijtak: Ri'n, xche'tak. Y wi' jujun chic xijtak: Ma' ri' ta'n, xike jilon rilic chapca' sic' moy, xche'tak. Pero sic' winak li xij: Tz'eti'n, ini'n, xche'. ");
INSERT INTO uspNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Xpetak mak cristian, xtz'onajtak re: ¿Nen mo li atchak na'tunc? xche'tak re. ");
INSERT INTO uspNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Re xij rechak: Ri' winak ri Jesús jb'ij xintzib'sanc. Xan jun raquitz xok'ol y xtz'aj la' b'ak' inwch y xij chwe: Jat la' man c'otob' ri jb'ij Siloé pire tib'e ach'aje' acayb'al cla', xche' chwe. Y in ximb'ec y cuando xch'ajmaj incayb'al, inchak na'tunc, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Xpetak mak cristian, xtz'onajtak re sic' winak li: ¿Lamas wi' man winak li? xche'tak re. Y re xij: Ta' wetam lamas wi'w, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Rechak xc'amtakb'i riq'uilak mak fariseo sic' winak ri xtzib'saj b'ak' jwich. ");
INSERT INTO uspNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","La' man k'ij li, cuando Kakaj Jesús xan xok'ol y xtzib'saj b'ak' jwich sic' moy, k'iji' re uxlan. ");
INSERT INTO uspNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Jwi'li'li xpe mak fariseo xtz'onajtak re nen xan pire xna'tunc. Re xij rechak: Xtz'aj xok'ol la' b'ak' inwch y in xinch'aj, jilonli inchak na'tunc, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Jujun rechak mak fariseo xijtak: Man winak ri xanow jilonli ma' riq'ui ta' Kakaj Dios tipe'w, na'li' ta' tijcoj jk'ij man k'ij re uxlan, xche'tak. Pero nic'j chic xijtak: ¿Nenc'u chac ticwin chi jb'anic c'utb'i jcwinel Kakaj Dios li wi ajmaqui'n? xche'tak. Jilonli ta' xniq'uib' jchomorsa'nak chirib'il rib'ak mak fariseo. ");
INSERT INTO uspNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Xtz'onajtak chic re sic' winak ri xtzib'saj b'ak' jwich: Y ruc' at, ¿nen tab'ij chirij man winak li ri xtzib'san b'ak' awch? xche'tak re. Y re xij rechak: Tamb'ij in ajk'asal Jyolji' Kakaj Dios, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Pero mak jb'ab'alak yak rijajl Israel ta' tijcojtak chi sic' winak li moyi' ojr y lajori tichak na'tunc, jwi'li'li xtaktakna jsiq'uij jkaj jchuch sic' winak li ");
INSERT INTO uspNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","y xijtak rechak: ¿Roni' awalc'walak ri, ri tab'ijtak chi moychak cuando xq'uisi'yc? ¿Nen chac tichak na'tunc? xche'tak rechak. ");
INSERT INTO uspNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Y jkaj jchuch xijtak: Ketami' chi ri' ri kalc'wal y moychak cuando xq'uisi'yc. ");
INSERT INTO uspNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Pero oj ta' ketam nen chac tichak na'tunc. Y ta' ketam nen xtzib'san re b'ak' jwich. Tz'onajtak re, re wi'chak junb', tichak cwin chi jb'ij chawechak nen xtzib'san re, xche'tak rechak. ");
INSERT INTO uspNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Jkaj jchuch xijtak jilonli jwi'l jtzakic jch'olak chiwchak mak jb'ab'alak yak rijajl Israel, jwi'l mak b'ab'al li chomorsalchak jwi'lak chi tresajtakb'i li sinagog nen jono cristian tib'in chi Kakaj Jesús ri' ri b'il jwi'l Kakaj Dios chi tina jtaknach wich ulew. ");
INSERT INTO uspNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Jwi'li'li jkaj jchuch xijtak: Tz'onajtak re, re wi'chak junb', xche'tak. ");
INSERT INTO uspNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Xpetak mak jb'ab'alak yak rijajl Israel, xtaktak chic jsiq'uij sic' winak ri moy ojr y xijtak re: B'ij tz'etel tzij chike chiwch Kakaj Dios, oj ketami' chi man winak li ajmaqui'n, xche'tak re. ");
INSERT INTO uspNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Sic' winak xij chic rechak: In ta' wetam wi ajmaqui'n o ta'n. In xike wetam chi ini' moy, pero lajori inchak na'tunc, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Y rechak xtz'onajtak chic re: ¿Nen xan chawe? ¿Nen xan chi jtzib'saj b'ak' awch? xche'tak chic re. ");
INSERT INTO uspNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Re xij chic rechak: Ximb'iji' chawechak y atak ta' tacojtak. ¿Nen chac chawajak tamb'ij chic jun b'welt chawechak? ¿Chawajakc'u atoctak pire ajtijol ayb'ak chirij? xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Xpetak rechak, xoctak chi jpetzaj retzal sic' winak, xijtak re: At, ati' ajtijol ayb' chirij man winak li, pero oj oji' ajtijol kib' chirij Moisés. ");
INSERT INTO uspNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Oj ketami' chi ri' Kakaj Dios xch'ab'en re Moisés, pero man winak li ta' ketam lamas tipe'w, xche'tak re sic' winak. ");
INSERT INTO uspNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Sic' winak xij chic rechak: Sub'laj tisaach inch'ol awi'lak, ta' awetamak lamas tipe'w, pero xtzib'saji' b'ak' inwch. ");
INSERT INTO uspNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Ketami' chi Kakaj Dios ta' tijta jyoljak yak ajmacb', xike tijta jyoljak yak ri tinimirsantak jk'ij y yak ri tib'anowtak lawi' raj re trantak. ");
INSERT INTO uspNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Ni jun b'welt tal jtaquil kawi'l chi wi' nen xtzib'san b'ak' jwich jun moy ri moychak cuando xq'uisi'yc. ");
INSERT INTO uspNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Winak li miti ji' petzal riq'ui Kakaj Dios, ta' roj ticwin chi jb'anic ni jono c'utb'i jcwinel Kakaj Dios, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Y rechak xijtak chic re: At, atchak jun ajmac cuando xatq'uisi'yc y, ¿ri'c'u chawaj ojatijoj? xche'tak re sic' winak. Y xresajtakb'i li sinagog. ");
INSERT INTO uspNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Kakaj Jesús xretemaj chi xesaji'ch sic' winak li sinagog. Cuando xta' chic rib'ak pach sic' winak xtz'onaj re: ¿Ton cub'ari' ach'ol chirij Jc'ajol Kakaj Dios ri xwux pi cristianil? xche' re sic' winak. ");
INSERT INTO uspNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Y sic' winak xij re: Kaj, b'ij chwe nen chi cristian lal pire ticub'ar inch'ol chirij, xche' re. ");
INSERT INTO uspNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Kakaj Jesús xij chic re: Xawila' jwich, ini' ri, ri quiek riq'uil attijin chi yoloj, xche' re. ");
INSERT INTO uspNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Xpe sic' winak, laj or xxucar chiwch Kakaj Jesús y xij re: Wajawl, ticub'ari' inch'ol chawij, xche' re. ");
INSERT INTO uspNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Kakaj Jesús xij chic re sic' winak li: In ximpe wich ulew pirechi' tiyuk wile' nen jb'anicak cristian, tzini' jb'anicak o ta'n pire tamb'an chi yak moy tina'tuntak y yak ri tina'tuntak tiwuxtak pi moy, xche'. ");
INSERT INTO uspNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Xpe jujun rechak mak fariseo ri wi'tak riq'uil, cuando xtatak chi jilonli xij Kakaj Jesús, xtz'onajtak re: ¿Ojc'u moy oj? xche'tak re Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Kakaj Jesús xij chic rechak: Witi atak moy ticuysaji' amacak ri tab'antak, pero jwi'l atak tab'ijtaka' chi ma' atak ta' moy, ta' ticuysaj amacak ri tab'antak, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Kakaj Jesús xij chic rechak: Kes tz'etel tz'et tamb'ij chawechak nen ta' tioc la' man pwert re jcorralak mak carner y jalan lad tioc, alk'omi'n y etzl cristiani'n. ");
INSERT INTO uspNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Pero nen tioc la' man pwert re jcorralak mak carner, ri' man ajyuk'. ");
INSERT INTO uspNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Man ajchajal re chi' corral tijteb'a' man pwert re man corral chiwch man ajyuk' y man ajyuk' tijch'ab'ej mak jcarner la' jb'ijak y mak carner tijch'ob'a'taka' laj jkul chi ri' tich'a'wc y tresajb'i mak carner laj jcorralak. ");
INSERT INTO uspNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Y cuando tiesmajb'i juntir mak carner jwi'l li corral, ajruc're' tinab'erb'i chiwchak tib'etak y mak carner tixamb'ertaka' chirij, jwi'l tijch'ob'a'taka' laj jkul chi ri' tich'a'wc. ");
INSERT INTO uspNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Rechak ma' kus ta'ke rechak tixamb'ertak chirij jono wi mita' tijch'ob'tak jwich, tike elmajtak chiwch jwi'l ta' tijch'ob'tak jwich y ta' tijch'ob'tak laj jkul chi ri' tich'a'wc, xche' Kakaj Jesús rechak. ");
INSERT INTO uspNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Kakaj Jesús xij man esb'i no'j ri rechak, pero rechak ta' xtatak jcholajl nen raj Kakaj Jesús xij rechak. ");
INSERT INTO uspNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Kakaj Jesús xij chic rechak: Kes tz'etel tz'et tamb'ij chawechak chi ini' man pwert re man corral lamas tioctak mak carner. ");
INSERT INTO uspNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Juntir mak ri xyuktak nab'e chinwch in, alk'omtaka'n y etzltak cristiantaka'n, pero mak carner ta' xtatak jyoljak. ");
INSERT INTO uspNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","In, ini' man pwert re man corral y nen tioc li corral inwi'l in, ticolmaji'n. Tijna' tioc y tiel la' man pwert re man corral y tijta' richaj. ");
INSERT INTO uspNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Man alk'om tipet pireke tiyuk ralk'aj mak carner y tiyuk jcamsajtak y tiyuk jsache' jwichak. Pero in ximpet pirechi' tanye' c'aslemal y pire tanye' jun tzilaj c'aslemal rechak. ");
INSERT INTO uspNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","In, ini' jun tzilaj ajyuk'. Jun tzilaj ajyuk' tijya' rib' pi camic chi jcolic jcarner. ");
INSERT INTO uspNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Jun mocom ri tijin chi chac jwi'lke jtojb'l cuando tril tipe man utiw tican jye' mak carner y tielmajb'i jwi'l ma' ri' ta' re tz'etel ajyuk' y ma' ri' ta' re rajw mak carner. Tioc man utiw li corral riq'uilak mak carner chi jchapicak y truktajtakb'ic. ");
INSERT INTO uspNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Man mocom li tielmaji'b'i jwi'l mocomke, xike tichacun jwi'l jtojb'l y re ta' tioc il chirijak mak carner. ");
INSERT INTO uspNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","In, ini' jun tzilaj ajyuk', tanch'ob'a' jwichak incarner y mak incarner tijch'ob'a'taka' inwch y tanya' wib' pi camic chi jcolic mak incarner. ");
INSERT INTO uspNT_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Jilon chapca' Kakaj Dios tijch'ob'a' inwch in y in tanch'ob'a' jwich re. ");
INSERT INTO uspNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Y wi' chiqui' nic'j incarner chic ri ta'taka' neri li corral, pero tina inc'amtaknach. Rechak tina jtatakna inyolj y tina jc'amna rib'ak li jun k'at y junke ajyuk' pi rechak. ");
INSERT INTO uspNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Kakaj Dios injlok'aji' jwi'l tanya' wib' pi camic, pero tic'astasaji' inwch laj incamnakl. ");
INSERT INTO uspNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Ta' ni jonok tiesan inc'aslemal, laj wanmi' tipe'w, tanjach wib' pi camic. In wi' laj ink'b' tanjach wib' pi camic y wi' laj ink'b' tanc'ul chic inc'aslemal. Ri' li ri takalquin jwi'l Inkaj chi jb'anic, xche' Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Yak rijajl Israel cuando xtatak chi jilonli xijsaj rechak jwi'l Kakaj Jesús, xjalmaj chic jchomorsa'nak chirib'il rib'ak. ");
INSERT INTO uspNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Sub'laj q'ui rechak xijtak: ¿Nen chac tacojtak ri tijb'ij? Re etzli' wi' laj ranm y ch'u'ji'n, xche'tak. ");
INSERT INTO uspNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Y mak nic'j chic xijtak: Mak yoloj ri tijin chi jb'ij ma' jyolj ta' jun cristian ri wi' etzl laj ranm. ¿Tonc'u cwini' jun etzl chi jtzib'saj b'ak' jwich jun moy? xche'tak. ");
INSERT INTO uspNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","La' mak riq'uil jab' tijin trantak jun nimak'ij Jerusalén pire jc'ulic jk'ij jurub' junab' jb'antaj jwa'x nimi richoch Kakaj Dios y xjachsaj re Kakaj Dios. ");
INSERT INTO uspNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Kakaj Jesús tijin tiwo'cot b'atz'aak re nimi richoch Kakaj Dios ri jb'ij Salomón. ");
INSERT INTO uspNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Xpe yak rijajl Israel, xsuttak rij Kakaj Jesús y xtz'onajtak re: ¿Nen or tawesaj chi sakil chikawch wi ati' ri b'il jwi'l Kakaj Dios chi tina jtaknach wich ulew? ¡B'ij chike lajori! xche'tak re. ");
INSERT INTO uspNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Kakaj Jesús xij rechak: Ximb'iji'n y ta' tacojtak inyolj. La' juntir ri b'anal inwi'l ri takalquin chi jb'anic jwi'l Inkaj chi tamb'an, ri' li tic'utuw chi ini'n. ");
INSERT INTO uspNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Pero atak ta' tacojtak inyolj jwi'l ma' atak ta' incarner. ");
INSERT INTO uspNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Mak incarner tijta'taka' inyolj y in tanch'ob'a' jwichak. Rechak tixamb'ertaka' chwij. ");
INSERT INTO uspNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","In tanya' jun tzilaj c'aslemal rechak riq'ui Kakaj Dios lecj ri ta' jq'uisic. Rechak ni jun b'welt tisaach jwichak y ta' ni jonok tiesantak laj ink'b'. ");
INSERT INTO uspNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Y Inkaj ri xjachow laj ink'b' juntir li, masna nim jk'ij chiwch juntir cristian ri wi' wich ulew y ni jonok ticwin chi resajcak yak ri wi'tak laj jk'ab'. ");
INSERT INTO uspNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","In pach Kakaj Dios ojke jun, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Xpetak yak rijajl Israel, xmoltak ab'aj pire roj xcojtak re Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Kakaj Jesús xij chic rechak: Sub'laj utzil b'anal chawchak inwi'l, jwi'l ri' li ri takalquinch jwi'l Kakaj Dios chi jb'anic. ¿Nenc'u quiek chirij chawajak tacojtak ab'aj chwe? xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Yak rijajl Israel xijtak chic re: Ma' jwi'l ta' ni jono utzil ri b'anal awi'l tikacoj ab'aj chawe, jwi'l tacoj ayb' pi Jc'ajol Kakaj Dios y atke cristian y tab'ij chi ati' Dios, xche'tak re. ");
INSERT INTO uspNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Kakaj Jesús xij chic rechak: Tz'ib'ali' li wuj re apixb'ak ri tijb'ij jilonri: Atak ataka' dios, tiche'. ");
INSERT INTO uspNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Y wi Kakaj Dios xij chi diostaka' yak cristian ri xcojowtak Jyolj, ta' tijna' tikab'ij chi ta' tz'et ri tijb'ij Kakaj Dios. ");
INSERT INTO uspNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Y wi Kakaj Diosi' xincha'w y xinjtakch wich ulew, ¿nenc'u chac tab'ij atak chi tijin tancoj wib' pi Dios jwi'l ximb'ij chi ini' Jc'ajol Kakaj Dios? ");
INSERT INTO uspNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Wi in ta' tamb'an chapca' tran Inkaj, ta' tacojtak inyolj. ");
INSERT INTO uspNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Pero wi tamb'an mak c'utb'i jcwinel Kakaj Dios chawchak y wi ta' chawajak tacojtak inyolj, xike cojtak mak c'utb'i jcwinel Kakaj Dios ri tamb'an pire tawetemajtak y tatatak jcholajl chi Kakaj Dios wi' laj wanm y in wini' laj ranm, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Rechak rajak roj xchape'tak Kakaj Jesús, pero re ta' xye' rib' chi chapem. ");
INSERT INTO uspNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Ajruc're' Kakaj Jesús xk'aj chicb'i ch'akap re nimi ja' Jordán, xwa'x la' man luwar lamas xwa'xwi' Juan Ajb'anal Ja'tiox chi jb'anic ja'tiox. ");
INSERT INTO uspNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Sub'laj q'ui cristian xtawtak chi rilic y xijtak: Juan Ajb'anal Ja'tiox ta' xan c'utb'i jcwinel Kakaj Dios, pero juntir ri xij chirij winak ri, tz'eti'n, xche'tak. ");
INSERT INTO uspNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","La' man luwar li sub'laj q'ui cristian xcub'ar jch'olak chirij Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Wi' jun winak sub'laj yaj ri jb'ij Lázaro aj Betania ri jtilmitak María pach Marta yak ranab'. ");
INSERT INTO uspNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","María ranab' Lázaro ri yaj, ri' María li ri xtz'ajow perjum rij rakan Kakaj Jesús ri Kajawl y xchekersaj chic la' rusumal jb'a. ");
INSERT INTO uspNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Xpetak yak ranab' Lázaro, xtaktak jb'ij re Kakaj Jesús jilonri: Kajawl, Lázaro ri lok'laj awichc'ulchi' yaji'n, xche'tak re. ");
INSERT INTO uspNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Kakaj Jesús, cuando xta chi jilonli xijsaj re, xij: Man yajel li ta' tijcamsaj Lázaro, pirechi' tijc'ut jnimal jk'ij Kakaj Dios y pirechi' tinimirsaj jk'ij Jc'ajol Kakaj Dios. ");
INSERT INTO uspNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Kakaj Jesús sub'laj tijlok'aj Marta, María y Lázaro. ");
INSERT INTO uspNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Pero cuando xta chi yaji' Lázaro ta' xe' laj or chi rilic, xwa'xna chic quib' k'ij cla'. ");
INSERT INTO uspNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Ajruc're' xij rechak yak ajtijol rib'ak chirij: Jo'tak chic Judea, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Yak ajtijol rib'ak chirij xijtak re: Kajtijonl, pero ajqui' ojr yak rijajl Israel ri wi'tak Judea rajak roj xatjcamsajtak chi ab'aj y lajori, ¿chawajc'u atb'e chic cla'? xche'tak re. ");
INSERT INTO uspNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Y Kakaj Jesús xij chic rechak: ¿Ta'c'u awetamak chi cab'lajuj (12) or wi' re lak'j? Wi jun cristian tiwo'cot lak'j ta' tijtop rakan jwi'l trila' jb'e la' jsakil ri tisakab'san wich ulew. ");
INSERT INTO uspNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Pero nen jono cristian tiwo'cot lak'ab' tijtopa' rakan jwi'l ta' na'l jb'e, xche'. ");
INSERT INTO uspNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Y xij chic rechak yak ajtijol rib'ak chirij: Kichc'ulchi' Lázaro xwari'n, pero in tib'e inc'astasaj jwich, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Xpe yak ajtijol rib'ak chirij, xijtak re: Kajawl, pero wi xwari'n, ri' c'utb'ire chi titzib'i'n, xche'tak re. ");
INSERT INTO uspNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Pero Kakaj Jesús tijin tijb'ij chi Lázaro xcami'n y yak ajtijol rib'ak chirij ri' chijch'ol rechak warajke tijin tran Lázaro. ");
INSERT INTO uspNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Jwi'li'li Kakaj Jesús xij jcholajl rechak jilonri: Lázaro xcami'n ");
INSERT INTO uspNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","y sub'laj inqui'cot jwi'l ta' xinwa'x cla' la' mak k'ij li, jwi'l jilonli tziyi' pi awechak pire ticub'ar ach'olak chwij. Lajori jo' kile'tak, xche' Kakaj Jesús rechak yak ajtijol rib'ak chirij. ");
INSERT INTO uspNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Xpe Tomás ri xcojsaj jb'ij pi Dídimo, xij rechak yak nic'j ajtijol rib'ak chic chirij Kakaj Jesús: Jo'tak chirij pire ojb'e camtak nic' riq'uil, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Cuando xtaw Kakaj Jesús Betania xta jtaquil chi xana' quejab' k'ij jmukmaj Lázaro. ");
INSERT INTO uspNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betania raj nic'aj lewa jnajtil jxo'l riq'ui Jerusalén. ");
INSERT INTO uspNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Sub'laj q'ui yak rijajl Israel ri wi'tak Judea ri jwinakak Marta pach María xtawtak chi jsolajcak pire tib'e jye'tak jcowil ranmak, jwi'l sub'laj tib'isontak chirij jxib'alak ri xcamc. ");
INSERT INTO uspNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Marta, cuando xta chi b'esali' Kakaj Jesús, laj or xelch chi jc'ulic, pero María xcan la ja. ");
INSERT INTO uspNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Marta xij re Kakaj Jesús: Wajawl, witi wat neri kiq'uil ta' roj xcam inxib'al. ");
INSERT INTO uspNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Pero in wetami' chi aj tijna' tijye' Kakaj Dios chawe lajori juntir nen tatz'onaj re, xche' re. ");
INSERT INTO uspNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Kakaj Jesús xij re: Axib'al tic'astasaji' jwich laj jcamnakl, xche' re. ");
INSERT INTO uspNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Marta xij chic re: Tz'eti'n, in wetami' chi tic'astasaji' jwich laj jcamnakl cuando tic'astasaj jwichak camnakib' la' q'uisb'itak k'ij re jwich k'ijsak, xche' re. ");
INSERT INTO uspNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Kakaj Jesús xij chic re: Ini' inc'astasan jwichak camnakib' y in inye'w c'aslemal. Nen ticub'ar jch'ol chwij onque ticamc, tic'astasaji' jwich laj jcamnakl. ");
INSERT INTO uspNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Y juntir yak cristian ri aj yo'ltak, wi ticub'ar jch'olak chwij ta' chiqui' ticamtak. ¿Ton acoja' at chi tz'eti'n? xche' re Marta. ");
INSERT INTO uspNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Marta xij chic re Kakaj Jesús: Tz'eti'n, Wajawl. In tancoja' chi ati' Jc'ajol Kakaj Dios ri b'il jwi'l chi tina jtaknach wich ulew, xche' re. ");
INSERT INTO uspNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Cuando xijmaj jilonli jwi'l Marta xe' laj richoch chi jsiq'uij María, xe' jb'ij re pi ric'an jilonri: Ajtijonl wi'chak jili y ri' raj atb'e riq'uil, xche' re. ");
INSERT INTO uspNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","María xike xta chi jilonli xijsaj re, laj or xwa'rc y xe' chi rilic Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Kakaj Jesús ajqui' chi oc li tilmit, ajwi' lamas xe' c'ulsaj jwi'l Marta. ");
INSERT INTO uspNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Yak rijajl Israel ri jwinakak María ri wi'tak cla' la ja chi jye'ic jcowil ranm, cuando xriltak chi xwa'r María y xelb'i jol, rechak xe'tak chirij. Ri' chijch'ol rechak ji' tib'e chi ok'ej chi' jul lamas xmuksajwi' jxib'al. ");
INSERT INTO uspNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","María, cuando xtaw lamas wi' Kakaj Jesús, xxucar chiwch y xij re: Wajawl, witi wat neri kiq'uil ta' roj xcam inxib'al, xche' re. ");
INSERT INTO uspNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Kakaj Jesús, cuando xril chi sub'laj tiok'tak María pach yak rijajl Israel ri jwinakak ri b'esaltak chirij, sub'laj xc'axc'ob' ranm chi rilicak y sub'laj xb'isonc. ");
INSERT INTO uspNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Xtz'onaj rechak: ¿Lamas xamuktakwi'? xche' rechak. Rechak xijtak chic re Kakaj Jesús: Kajawl, jo' ilta, xche'tak re. ");
INSERT INTO uspNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Kakaj Jesús xrok'b'ej rib'. ");
INSERT INTO uspNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Yak rijajl Israel ri jwinakak María ri wi'tak cla' xijtak: Iltak impuch na'li' chi sub'laj raj jwich, xche'tak. ");
INSERT INTO uspNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Pero nic'j rechak xijtak: Ri' re xtzib'san b'ak' jwich sic' moy, ¿ta'c'u roj xcwin nen xan re Lázaro pire ma' xcamc? xche'tak. ");
INSERT INTO uspNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Kakaj Jesús xc'axc'ob' chic laj ranm, xe' chi' jul lamas mukulwi' Lázaro y man jul li ch'ukuli' jchi' la' jun ab'aj. ");
INSERT INTO uspNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Kakaj Jesús xij: Esajtak man ab'aj, xche'. Xpe Marta ranab' Lázaro ri xcamc, xij: Wajawl, li chuchak jwi'l xana' quejab' k'ij jmukic, xche' re. ");
INSERT INTO uspNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Pero Kakaj Jesús xij chic re: ¿Ta'c'u ximb'ij chawe wi tacoj inyolj tawila' jnimal jk'ij Kakaj Dios? xche' re. ");
INSERT INTO uspNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Ajruc're' xresajtak man ab'aj chi jchi' man jul y Kakaj Jesús xna'tun lecj y xij: Kaj, tanc'omowaj chawe jwi'l xata' inyolj. ");
INSERT INTO uspNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","In wetami' chi tata' inyolj, pero in tamb'ij jilonri pire tijcojtak yak cristian ri wi'tak neri chi ati' attakowinakch we, xche'. ");
INSERT INTO uspNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Y cuando xijmaj jilonli jwi'l sub'laj cow xch'ejejc, xij: ¡Lázaro elanch cla'! xche'. ");
INSERT INTO uspNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Y laj or xelch Lázaro li jul ri xcamna, aj pisili' jk'ab' pach rakan la' itz'ik y jcayb'al aj pisili' la' jun sut', Kakaj Jesús xij rechak: Quirtak mak itz'ik ri pisil chirij y ye'tak luwar re tib'ec, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Sub'laj q'ui yak rijajl Israel ri wi'tak cla' chi jsolaj María, cuando xriltak nen xan Kakaj Jesús, xcub'ar jch'olak chirij. ");
INSERT INTO uspNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Pero nic'j rechak xe'tak riq'uilak mak fariseo y xe' jb'ijtak rechak nen xan Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Y xpetak mak fariseo pach mak jb'ab'alak yak ajc'amaltak jb'eak cristian riq'ui Kakaj Dios, xmulb'a' rib'ak pach mak comontak jb'ab'alak yak rijajl Israel, xijtak: ¿Nen tikab'antak? Man winak li tijin tran sub'laj c'utb'i jcwinel Kakaj Dios. ");
INSERT INTO uspNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Wi tican kaye' pi jilonli sub'laj q'ui cristian ticojowtak jyolj y tipetak mak jb'ab'altak k'atb'itzij re Roma tiyuk jyuje'tak nimi richoch Kakaj Dios y tijsachtak jwich katilmit, xche'tak. ");
INSERT INTO uspNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Jun rechak ri jb'ij Caifás, ri wi' pire nimlaj jb'ab'alak yak ajc'amaltak jb'eak cristian riq'ui Kakaj Dios la' man junab' li, xij rechak: Atak ta' nen awetamak. ");
INSERT INTO uspNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Ta'cojo' tachomorsajtak chi ri' mas tzi pi ke oj ticamsaj jun chi cristian chiwch tisachsaj jwich katilmit, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Caifás cuando xij jilonli, ma' laj no'j ta'ke re xpe'w. Jwi'l re ri' man nimlaj jb'ab'alak yak ajc'amaltak jb'eak cristian riq'ui Kakaj Dios la' man junab' li, jwi'li'li Kakaj Dios xye' luwar re xij chi Kakaj Jesús tina camna pi jq'uexwach yak rijajl Israel. ");
INSERT INTO uspNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Y ma' xita'ke pi rechak, chi ji' pi rechak yak ma' rijajl ta' Israel ri tilem rib'ak b'ak juntir tilmit pire tran jun rechak juntir yak ralc'wal Kakaj Dios. ");
INSERT INTO uspNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","La' man k'ij li xcholtak jchomorsaj mak jb'ab'alak yak rijajl Israel chi tijcamsajtak Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Jwi'li'li Kakaj Jesús ta' chiqui' mas xwa'x chijxo'lak yak rijajl Israel. Re xe' li jun tilmit ri jb'ij Efraín ri wi' chijc'ulel man chekej luwar, cla' xwa'x pach yak ajtijol rib'ak chirij. ");
INSERT INTO uspNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Ta' chiqui' naj raj titaw k'ij re jnimak'jak yak rijajl Israel ri jb'ij Pascua. Y sub'laj q'ui cristian re juntir tilmit tijin jtawicak Jerusalén pire tib'e rane'tak lawi' rajwax pire tijch'ajch'ob'ej jwichak nab'e chiwch Kakaj Dios, ajruc're' tiwa'xtak li nimak'ij. ");
INSERT INTO uspNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Rechak tijin tijtoctak Kakaj Jesús y cuando xmulb'a' rib'ak li nimi richoch Kakaj Dios tijb'ijtak chirib'il rib'ak: ¿Nen tab'ij atak, ton peti' li nimak'ij o ta'n? xche'tak. ");
INSERT INTO uspNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Mak fariseo pach mak jb'ab'alak yak ajc'amaltak jb'eak cristian riq'ui Kakaj Dios b'ilchak rechak cristian jwi'lak chi wi wi' jonok tretemaj lamas wi' Kakaj Jesús tib'e jye' jtaquil rechak pire tib'e chapsajok. ");
INSERT INTO uspNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Wakakib' (6) k'ij raj titaw k'ij re jnimak'jak yak rijajl Israel ri jb'ij Pascua. Kakaj Jesús xtaw Betania lamas wi' Lázaro ri xc'astasaj jwich laj jcamnakl xo'lak camnakib'. ");
INSERT INTO uspNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Cla' xye'tak jun jsinar Kakaj Jesús pire jnimirsaj jk'ij. Marta xoc chi jye'ic jwaak y Lázaro ri' jun rechak yak ri cub'ul chi wic' chi' mex riq'ui Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Xpe María, xc'amch jun ra nejb' nojsal chi perjum ri jb'ij nardo y sub'laj pakal rijil, xtz'aj rij rakan Kakaj Jesús y xsu' la' rusumal jb'a y juntir jpam man ja xnoj chi ruxb'l man perjum. ");
INSERT INTO uspNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Xpe jun rechak yak ajtijol rib'ak chirij Kakaj Jesucristo ri jb'ij Judas Iscariote, ri jc'ajol Simón, ri tijachow re Kakaj Jesús pi camic, xij: ");
INSERT INTO uspNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","¿Nen chac ma' xc'ayaj man perjum ri? Man perjum ri rijili' uxib' cient (300) chi denario. Ri' mas tzi xc'ayajtene' man perjum pire tit'o'saj yak powr la' man pwak, xche'. ");
INSERT INTO uspNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Pero Judas xij jilonli ma' jwi'l ta' tril c'ur jwichak yak powr, jwi'l re alk'omi'n. Ri' re ajc'olol pwak y tralk'aji' q'uitja' re la' man pwak ri tijc'ol. ");
INSERT INTO uspNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Kakaj Jesús xij re: Can ye' anm li pi utzil, man perjum li c'olani'ch jwi'l pire ticojsaj chwij cuando immuksaj. ");
INSERT INTO uspNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Yak powr tiwa'xtaka' chaxo'lak nojel k'ij, pero in ta' naj inwa'x chaxo'lak, xche' Kakaj Jesús rechak. ");
INSERT INTO uspNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Sub'laj q'ui yak rijajl Israel xtatak jtaquil chi wi' Kakaj Jesús Betania, jwi'li'li xe'tak chi rilic, pero ma' xita'ke Kakaj Jesús xe' rile'tak, ri' xe' rile'tak Lázaro ri xc'astasaj jwich jwi'l Kakaj Jesús laj jcamnakl xo'lak camnakib'. ");
INSERT INTO uspNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Xpetak mak jb'ab'alak yak ajc'amaltak jb'eak cristian riq'ui Kakaj Dios, xchomorsajtak chi tijcamsajtak Lázaro jwi'l, ");
INSERT INTO uspNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","jwi'lke re sub'laj q'ui yak rijajl Israel tijin tijtos rib'ak chirijak pire ticub'ar jch'olak chirij Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Sub'laj q'ui cristian xe'tak Jerusalén pire tib'e jk'asajtak nimak'ij Pascua cla'. Laj jcab' k'ij cuando xtatak jtaquil chi tawem tran Kakaj Jesús li tilmit cla', ");
INSERT INTO uspNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","sub'laj q'ui cristian xtoctak jxaktak palm y xeltakch chi jc'ulic Kakaj Jesús. Sub'laj cow xch'ejejtak, xijtak: ¡Nim jk'ij Kakaj Dios ri Kajawl! ¡Kakaj Dios ri Kajawl wi' jk'ab' chib' ri petzal laj jb'ij! ¡Tzi re ri jreyak yak rijajl Israel! xche'tak. ");
INSERT INTO uspNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Kakaj Jesús xta' jun ra b'ur li b'e y xquejajch chapca' tz'ib'al li wuj re Jyolj Kakaj Dios ri tijb'ij jilonri: ");
INSERT INTO uspNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Mi tzaak ach'olak atak aj Sión, iltak areyak petzalc, quejal jun ra b'ur jwi'l, tiche'. ");
INSERT INTO uspNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Yak ajtijol rib'ak chirij Kakaj Jesucristo ta' xmajtak jcholajl laj or ri xan Kakaj Jesús, pero cuando xnimirsaj jk'ij Kakaj Jesús, ajruc're' xcuxtaj jwi'lak chi juntir li tz'ib'ali' jwi'lak yak ajk'asaltak Jyolj Kakaj Dios ojr chi jilonli tina b'anna re. ");
INSERT INTO uspNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Yak cristian ri wi'tak riq'ui Kakaj Jesús cuando xsiq'uij Lázaro chi' jul lamas xmuksajwi' pire xc'astasaj jwich laj jcamnakl xo'lak camnakib', xyoltak re cristian ri ilan jwi'lak. ");
INSERT INTO uspNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Jwi'li'li xeltakch sub'laj q'ui cristian chi jc'ulic Kakaj Jesús jwi'l xretemajtaka' chi Kakaj Jesús xana' jun c'utb'i jcwinel Kakaj Dios. ");
INSERT INTO uspNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Xpetak mak fariseo, xijtak chirib'il rib'ak chirij Kakaj Jesús: Tawila'taka' chi lajori ta' chiqui' nen ojcwintak chi jb'anic re. Iltak, juntir cristian tixamb'ertaka' chirij, xche'tak. ");
INSERT INTO uspNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Chijxo'lak mak cristian ri xtawtak Jerusalén re man nimak'ij Pascua chi jnimirsaj jk'ij Kakaj Dios wi'taka' jujun yak ma' rijajl ta' Israel. ");
INSERT INTO uspNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Xpe rechak, xjutuntak chijc'ulel Felipe ri aj Betsaida ri jun tilmit re Galilea xtz'onajtak tok'ob' re Felipe: Kaj, chikaj tikil jwich Kakaj Jesús, xche'tak re. ");
INSERT INTO uspNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Xpe Felipe, xe' jb'ij re Andrés y xpetak chi quib' rib'ilak xe' jb'ijtak re Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Kakaj Jesús xij rechak: Xtawi' or pire tinimirsaj jk'ij Jc'ajol Kakaj Dios ri xwux pi cristianil. ");
INSERT INTO uspNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Kes tz'etel tz'et tamb'ij chawechak, wi jun b'ak' jwich trig ta' tikej ralaj ulew y ta' tiel rac'al, tican pi junke b'ak' jwich, pero wi tiel rac'al tijya' sub'laj jwich. ");
INSERT INTO uspNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Nen jono cristian ta' raj tijye' rib' pi camic jwi'lke tran lawi' raj Kakaj Dios tran, tisaachi' jwich. Pero nen jono cristian tijye' rib' pi camic jwi'lke jb'anic lawi' raj Kakaj Dios tran, tijta' jun tzilaj c'aslemal riq'ui Kakaj Dios lecj ri ta' jq'uisic. ");
INSERT INTO uspNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Nen jonok raj tran lawi' ri chwaj in tran, xamb'erok chwij y lamas inwa'xwi' in, cla' tiwa'x re. Y nen tib'anow lawi' ri chwaj in, tinimirsaji' jk'ij jwi'l Inkaj, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Kakaj Jesús xij chic: Lajori wi' sub'laj c'ax laj wanm. ¿Nenc'u tamb'ij? ¿Tonc'u imb'ij: Kaj, inacole' laj jk'ab' mak c'ax ri tantij la' mak k'ij ri? inche'. Ta' tamb'ij jilonli, jwi'l ri' li quiek jwi'l petzalquin, xche'. ");
INSERT INTO uspNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Ajruc're xij: Kaj, nimirsaj jk'ij ab'j, xche'. Ri'chak xtasaj xaanch jun ch'a'wem lecj, xijch: Xinnimirsaji' jk'ij imb'j y tannimirsaj chiqui'n, xche'ch. ");
INSERT INTO uspNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Mak cristian ri wi'tak riq'ui Kakaj Jesús, xta'taka'n. Nic'j xijtak chi quiekuljawi'n y nic'j chic xijtak chi jun anjli' xch'ab'ench re. ");
INSERT INTO uspNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Kakaj Jesús xij rechak: Ma' pire ta' utzil pi we in xansajch ch'a'wem, pirechi' utzil pi awechak. ");
INSERT INTO uspNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Ri' k'ij ri tib'an k'atb'itzij chirij cristian wich ulew y lajori tiesajb'i man ri wi' takon laj jk'ab' chib'ak juntir cristian wich ulew. ");
INSERT INTO uspNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Y cuando imb'itsaj lecj, juntir yak ri tijtatak jcholajl ri xansaj chwe tanc'ama'taka'b'i wiq'uil, xche'. ");
INSERT INTO uspNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Jilonli jb'ij xan Kakaj Jesús nen chi camic lal tioc re. ");
INSERT INTO uspNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Mak cristian xijtak re: Tali' kawi'l tijb'ij laj Jpixb' Kakaj Dios chi ri b'il jwi'l Kakaj Dios chi tina jtaknach wich ulew ta' jsachic jwich. Y, ¿nenc'u chac tab'ij at chi Jc'ajol Kakaj Dios ri xwux pi cristianil tib'itsaji' lecj? ¿Nenc'u li ri Jc'ajol Kakaj Dios ri xwux pi cristianil? xche'tak. ");
INSERT INTO uspNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Kakaj Jesús xij chic rechak: Ajwi'na man k'ak' chaxo'lak, pero ta' chiqui' naj tiwa'x chaxo'lak. Wo'cotentak laj jsakil jk'ak'al pire ma' etke atcantak lak uku'm, jwi'l nen tiwo'cot li uku'mal ta' retam lamas tib'e'w. ");
INSERT INTO uspNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Cub'a' ach'olak chirij man k'ak' li ri ajwi' chaxo'lak pire atwuxtak pi ralc'wal man k'ak' li, xche' Kakaj Jesús rechak. Cuando xijmaj jilonli jwi'l Kakaj Jesús xe' jmuke' rib' chiwchak. ");
INSERT INTO uspNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Kakaj Jesús xana' sub'laj c'utb'i jcwinel Kakaj Dios chiwchak yak rijajl Israel, pero rechak ta' xcub'ar jch'olak chirij, ");
INSERT INTO uspNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","jwi'l rajwaxi' tina taw chiwch ri xcan jtz'ib'aj Isaías ojr ri ajk'asal Jyolj Kakaj Dios ri tijb'ij jilonri: Kajawl, ta' ni jun cojowinak re ri ye'l jtaquil kawi'l. ¿Nen quiek chiwch xc'utsajwi' chi Kakaj Dios ri Kajawl wi' jcwinel? tiche'. ");
INSERT INTO uspNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Jilonli rechak ta' xcwintak xcub'ar jch'olak chirij Kakaj Jesús y Isaías xij chic: ");
INSERT INTO uspNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Kakaj Dios xanow moy rechak y xanow ab'aj re ranmak pire ma' tina'tuntak la' b'ak' jwichak y pire ma' tijchomorsajtak laj ranmak pire ta' tijq'uex jno'jak y ta' tik'ajtak wiq'uil pire tantzib'sajtak, xche'. ");
INSERT INTO uspNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Isaías xij jilonli jwi'l xrila' chapca' li jun ichic' chi nimi' jk'ij Kakaj Jesús y ri' li ri xcan jb'ij chirij. ");
INSERT INTO uspNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Pero wi' sub'laj q'ui yak rijajl Israel y jujun rechak yak ri wi' rekle'nak chijxo'lak xjach rib'ak laj jk'ab' Kakaj Jesús. Pero ta' rajak tijc'uttak chi sakil jwi'l titzaak jch'olak chiwchak mak fariseo pire ma' tiesajtakb'i li sinagog, ");
INSERT INTO uspNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","jwi'l rechak ri' mas rajak tzi tiilsajtak jwi'lak cristian chiwch tzi tiilsajtak jwi'l Kakaj Dios. ");
INSERT INTO uspNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Kakaj Jesús sub'laj cow xch'a'wc, xij: Nen ticub'ar jch'ol chwij, ma' xita'ke chwij in ticub'ar jch'ol, ticub'ari' jch'ol chirij ri intakowinakch. ");
INSERT INTO uspNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Y nen tiiliw inwch, trila' jwich ri intakowinakch. ");
INSERT INTO uspNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Jwi'l in ini' jun k'ak', in ximpe wich ulew pire nen ticub'ar jch'ol chwij ta' tican li uku'mal. ");
INSERT INTO uspNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Pero nen tijta inyolj y ta' tran lawi' ri tamb'ij, ma' in ta' imb'anow k'atb'itzij chirij, jwi'l in ta' ximpet pire tiyuk imb'ane' k'atb'itzij chirijak juntir cristian, in ximpet pirechi' tiyuk incole'tak laj jk'ab' jmacak. ");
INSERT INTO uspNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Nen inxutuwc y ta' raj tijcoj inyolj, wi' nen tib'anow k'atb'itzij chirij, ri' inyolj ri ximb'ij re tib'anow k'atb'itzij chirij la' q'uisb'itak k'ij re jwich k'ijsak. ");
INSERT INTO uspNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Jwi'l ma' laj inno'j ta'ke in tipe'w ri tamb'ij, ri' Kakaj Dios ri intakowinakch chi jb'ij nen tamb'ij y nen tantijoj cristian. ");
INSERT INTO uspNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Y wetami' chi juntir ri xinjtakch chi jb'ij ri' tiye'w jun tzilaj c'aslemal lecj riq'uil ri ta' jq'uisic. Jwi'li'li ri' tamb'ij lawi' raj Kakaj Dios tamb'ij, xche' Kakaj Jesús rechak. ");
INSERT INTO uspNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Cuando jun k'ijchak raj nimak'ij Pascua, Kakaj Jesús retamchak chi xtawi' or tielb'i neri wich ulew pire tik'aj riq'ui Kakaj Dios lecj. Pero Kakaj Jesús sub'laj xlok'aj juntir cristian ri cub'ul jch'olak chirij neri wich ulew asta xcamc. ");
INSERT INTO uspNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Kakaj Jesús pach yak ajtijol rib'ak chirij cub'ultak chi' mex tijintak chi wic' re sinar. Man jb'ab'al etzl tichak tijin chi jtakchi'j Judas Iscariote ri jc'ajol Simón pire tijjach Kakaj Jesús pi camic. ");
INSERT INTO uspNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Kakaj Jesús retami' chi ji' xpe riq'ui Kakaj Dios y ye'li' k'atb'itzij laj jk'ab' pire titakon chib'ak juntir ri wi'tak wich ulew pach lecj y retami' chi riq'uili' Kakaj Dios tik'aj chic. ");
INSERT INTO uspNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Pero cuando tijin Kakaj Jesús chi wic' chi' mex, xwa'r xresaj man itz'ik ri k'u'l jwi'l y xxim jun tway xe' jpam. ");
INSERT INTO uspNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Xye' ja' li jun nejb' y xoc chi jch'ajic rakanak yak ajtijol rib'ak chirij y xchekersaj la' man tway ri xxim xe' jpam. ");
INSERT INTO uspNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Cuando oquem re Kakaj Jesús chi jch'ajic rakan Simón Pedro, xpe Simón Pedro, xtz'onaj re: Wajawl, ¿at atch'ajow re wakan? xche' re. ");
INSERT INTO uspNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Kakaj Jesús xij re: Lajori ta' tata jcholajl nen tijin tamb'an, pero nen or tina atana jcholajl, xche'. ");
INSERT INTO uspNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Pedro cow xij chic re Kakaj Jesús: ¡Ni jun b'welt tanye' luwar chawe tach'aj wakan! xche'. Kakaj Jesús xij chic re: Wi ta' tanch'aj awakan, ta' tic'ular pi awe atwa'x wiq'uil, xche'. ");
INSERT INTO uspNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Ajruc're' xpe Simón Pedro, xij chic re: Kajawl, wi jilonli ma' xita'ke wakan tach'aj, ch'aj ink'b' pach imb', xche'. ");
INSERT INTO uspNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Pero Kakaj Jesús xij re: Nen ajri'ke xan ritin xike rakan rajwax tich'ajsaj jwi'l saki' juntir jtio'jl. Atak saki' juntir atio'jlak, onque ma' atak ta' juntir, xche'. ");
INSERT INTO uspNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Kakaj Jesús retami' nen rechak tijachow re pi camic, jwi'li' li xij chi ta' saktak juntir. ");
INSERT INTO uspNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Kakaj Jesús, cuando xch'ajmaj rakanak yak ajtijol rib'ak chirij jwi'l, xcoj chic man itz'ik ri k'u'l jwi'l chirij, xk'aj chic laj jluwr chi' mex y xij rechak: ¿Xata'takni' jcholajl nen ximb'an chawechak? ");
INSERT INTO uspNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Atak tab'ijtak Kajtijonl chwe y tab'ijtak Kajawl chwe. Kes pi jcholajli' tab'ijtak jwi'l ini'n. ");
INSERT INTO uspNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Ini' Awajtijonlak y Awajawlak, pero xinch'aja' awakanak, jwi'li'li atak rajwaxi' tach'aj awakanak chawib'il ayb'ak. ");
INSERT INTO uspNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","In xinc'uta' jun no'j chawchak y rajwaxi' jilon tab'an atak chapca' ximb'an in. ");
INSERT INTO uspNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Kes tz'etel tz'et tamb'ij chawechak chi ta' ni jono mocom mas nim jk'ij chiwch jpatron y ta' ni jono tako'n mas nim jk'ij chiwch ri xtakow re. ");
INSERT INTO uspNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Tzi awechak wi tatatak jcholajl juntir li y tab'antak nen tijb'ij. ");
INSERT INTO uspNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Wi' jun yoloj tamb'ij, pero ma' pi awechak ta' atak juntir. In wetami' nen nojo yak ri cha'ltak inwi'l, pero rajwaxi' tina tawna chiwch ri tz'ib'al li wuj re Lok'laj Jyolj Kakaj Dios ri tijb'ij jilonri: Ri tiwi'n wiq'uil chi' mex, tina jb'itna rib' chwij, tiche'. ");
INSERT INTO uspNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","In tamb'ij chawechak jilonli jwi'l ri'ke chwaj cuando titaw chiwch ri tamb'ij chawechak, ticuxtaj inyolj awi'lak chi ini' ri b'il jwi'l Kakaj Dios chi tina jtaknach wich ulew. ");
INSERT INTO uspNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Kes tz'etel tz'et tamb'ij chawechak nen tic'uluw ri tantakb'ic, in injc'ul y nen inc'uluw in, ri' tijc'ul ri intakowinakch, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Cuando xijmaj juntir li jwi'l Kakaj Jesús xpe sub'laj c'ax laj ranm y xresaj chi sakil chiwchak yak ajtijol rib'ak chirij, xij jilonri: Kes tz'etel tz'et tamb'ij chawechak chi wi' jun chawechak injachow pi camic, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Yak ajtijol rib'ak chirij Kakaj Jesucristo tichak ril rib'ak chirib'il rib'ak jwi'l ta' retamak nen rechak ri tib'ijsaj jwi'l Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Wi' jun rechak yak ajtijol rib'ak chirij Kakaj Jesucristo ri sub'laj tilok'aj jwi'l Kakaj Jesús cub'ul pi tzalan laj jxuct Kakaj Jesús chi' mex. ");
INSERT INTO uspNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Xpe Simón Pedro, la'ke jk'ab' xan retal re man ajtijol rib' li pire tijtz'onaj re Kakaj Jesús nen rechak ri tib'ijsajc. ");
INSERT INTO uspNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Xpe man ajtijol rib' li ri sub'laj tilok'aj jwi'l Kakaj Jesús, xjutun chijc'ulel Kakaj Jesús y xtzalb'a'b'i rib' xtz'onaj: Wajawl, ¿nen chike atjachow pi camic? xche' re. ");
INSERT INTO uspNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Kakaj Jesús xij re: Ri quiek re tanye'w man q'uer cuxlanwa ri tanmu'w, ri' li injachow pi camic, xche' re. Y xmu' jun q'uer cuxlanwa y xye' re Judas Iscariote ri jc'ajol Simón. ");
INSERT INTO uspNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Cuando xye'maj jun q'uer cuxlanwa re Judas jwi'l Kakaj Jesús, xoc man jb'ab'al etzl laj ranm Judas. Xpe Kakaj Jesús, xij re: Ri chawaj tab'an, b'an laj or, xche' re. ");
INSERT INTO uspNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Pero ni jono rechak yak ri cub'ultak chi wic' chi' mex xtatak jcholajl nen chac xij Kakaj Jesús jilonli. ");
INSERT INTO uspNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Judas ri' ajc'olol pwak chirijak, jwi'li'li jujun rechak xchomorsajtak ri xijsaj re Judas pirechi' tijlok' kelen ri tichocon re nimak'ij o tijye' pwak rechak yak powr. ");
INSERT INTO uspNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Xike xc'ulmaj man q'uer cuxlanwa jwi'l Judas, laj or xelb'ic y lak'ab'chak. ");
INSERT INTO uspNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Cuando jorok eli'b'i Judas, Kakaj Jesús xij: Lajori xtawi' or tic'utun jnimal jk'ij Jc'ajol Kakaj Dios ri xwux pi cristianil y jwi'l re tic'utun jnimal jk'ij Kakaj Dios. ");
INSERT INTO uspNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Y wi ri' Jc'ajol Kakaj Dios ri xwux pi cristianil tic'utuw jnimal jk'ij Kakaj Dios, Kakaj Dios tijc'uta' jnimal jk'ij Jc'ajol ri xwux pi cristianil y tichak jc'ut jnimal jk'ij. ");
INSERT INTO uspNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Atak walc'wal, ta' chiqui' naj inwa'x aac'lak. Atak inna atoctakna, pero in tamb'ij chawechak chapca' ximb'ij rechak mak jb'ab'alak yak rijajl Israel chi ta' ticwintak chi b'enam lamas imb'e'w. ");
INSERT INTO uspNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Ri' ri jun aac' pixab' tican inye' chawechak. Talok'aj ayb'ak chawib'il ayb'ak chapca' alok'ajcak tamb'an in, jilon jlok'aj ayb'ak tab'antak chawib'il ayb'ak. ");
INSERT INTO uspNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Wi kes tz'et talok'aj ayb'ak chawib'il ayb'ak, juntir cristian wich ulew tretemajtaka' chi ataka' ajtijol ayb'ak chwij, xche' Kakaj Jesús rechak. ");
INSERT INTO uspNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Xpe Simón Pedro, xtz'onaj re Kakaj Jesús: Wajawl, ¿lac'umas atb'e'w? xche' re. Kakaj Jesús xij re: Ri lamas imb'e in, at ta' atcwin chi xamb'erem chwij lajori, pero atna xamb'erna chwij nen or, xche' re. ");
INSERT INTO uspNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Pedro xtz'onaj re Kakaj Jesús: Wajawl, ¿nen chac ta' incwin chi xamb'erem chawij lajori? In tanjacha' wib' pi camic chi acolic, xche' re. ");
INSERT INTO uspNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Kakaj Jesús xtz'onaj chic re: ¿Kes tz'etni' tajacha' ayb' pi camic chi incolic? Kes tz'etel tz'et tamb'ij chawe chi lak'ab' wica jorok ab'iji' oxmul chi ta' tach'ob' inwch cuando tiok' man puy, xche' re. ");
INSERT INTO uspNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Kakaj Jesús xij rechak yak ajtijol rib'ak chirij: Mi c'axc'ob' laj awanmak jwi'l ri ximb'ij. Cub'a' ach'olak chirij Kakaj Dios y cub'a' ach'olak chwij in. ");
INSERT INTO uspNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Lecj lamas wi' Inkaj, wi' mas luwar lamas tib'an wa'xem y miti wi' mas luwar ta' roj tamb'ij chawechak, jwi'li'li lajori imb'e chi jb'anic jwa'x jun luwar pi awechak. ");
INSERT INTO uspNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Y cuando imb'ec, tib'e imb'ane' jwa'x jun luwar pi awechak, ajruc're' impe chic pire atyuk inc'ame'tak pire atb'etak wiq'uil y atwa'xtak lamas winwi' in. ");
INSERT INTO uspNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Atak awetamaki' lamas imb'e'w y awetamaki' man b'e, xche' Kakaj Jesús rechak. ");
INSERT INTO uspNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Xpe Tomás, xij re Kakaj Jesús: Kajawl, ta' ketam lamas atb'e'w, ¿nenc'u mo tiketemaj man b'e? xche' re. ");
INSERT INTO uspNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Kakaj Jesús xij re: Xike in, in jun chi b'e pi rechak cristian ri tib'etak riq'ui Kakaj Dios y ini' tz'etel tzij y ini' inye'w tzilaj c'aslemal riq'ui Kakaj Dios lecj ri ta' jq'uisic. Ta' ni jono cristian titaw riq'ui Kakaj Dios miti inwi'lke in. ");
INSERT INTO uspNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Atak wi tawetemajtak nen tamb'an in, tawetemajtaka' nen tran Inkaj y tichak tijin tawetemajtak lajori y tichak tijin tawiltak jwich, xche' Kakaj Jesús rechak. ");
INSERT INTO uspNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Xpe Felipe, xij re: Kajawl, c'ut Kakaj Dios chikawch, xike li rajwax chike, xche' re Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Kakaj Jesús xij re: Felipe, ojrchak win chaxo'lak y, ¿ajqui'c'u chawetemaj nen tamb'an in? Jwi'l nen tiiliw inwch in, trila' jwich Kakaj Dios. ¿Nen chac tab'ij chwe chi chawajak tanc'ut Kakaj Dios chawchak? ");
INSERT INTO uspNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","¿Ta'c'u tacoj chi in wini' laj ranm Kakaj Dios y Kakaj Dios wi' laj wanm in? Juntir inyolj ri tamb'ij chawechak ma' laj inno'j ta'ke in tipe'w, ri' Kakaj Dios ri wi' laj wanm tib'anow lawi' raj tran. ");
INSERT INTO uspNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Cojtak chi in wini' laj ranm Kakaj Dios y Kakaj Dios wi' laj wanm in. Wi mita' tacojtak, cojtak jwi'l juntir ri tamb'an. ");
INSERT INTO uspNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Kes tz'etel tz'et tamb'ij chawechak nen ticub'ar jch'ol chwij in trana' nen ri tamb'an in y trana' mas chiwch ri tamb'an in, jwi'l in imb'i' lamas wi' Kakaj Dios ");
INSERT INTO uspNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","y wi tatz'onajtak juntir ri chawajak laj imb'j, in tamb'ana'n y jilonli Jc'ajol Kakaj Dios tijnimirsaj jk'ij Kakaj Dios. ");
INSERT INTO uspNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Wi tatz'onajtak juntir ri chawajak laj imb'j, tamb'ana'n, xche' Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Kakaj Jesús xij chic: Atak wi kes tz'et inalok'ajtak, tab'ana'taka' lawi' tijb'ij impixb'. ");
INSERT INTO uspNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","In tantz'onaji' re Kakaj Dios chi tijtak chicch jun ajye'l jcowil awanmak y tiwa'x aac'lak y ta' atcan jye'tak. ");
INSERT INTO uspNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Y ri' Lok'laj Jsantil Kakaj Dios ri tib'in tz'etel tzij chawechak. Yak cristian ri b'esal ranmak chi jb'anic mak etzltak no'j, ta' tijna' tijc'ultak jwi'l ta' triltak jwich y ta' tretemajtak nen tiyuk rane'. Pero atak tawetemajtakna nen tiyuk rane', jwi'l wi' chaxo'lak y tiwa'xi' laj awanmak y ta' atcan jye'tak. ");
INSERT INTO uspNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Ta' atcan inye'tak awic'anak chapca' nib'a'. Inna k'ajna chicch pire inyuk wa'x aac'lak. ");
INSERT INTO uspNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Yak cristian ri b'esal ranmak chi jb'anic mak etzltak no'j ta' chiqui' naj triltak inwch, pero atak tawila'taka' chiqui' inwch. Jwi'l in yo'lquini'n y atak atyo'rtaka'n. ");
INSERT INTO uspNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","La' mak k'ij li atak tawetemajtak chi in wini' laj ranm Inkaj y atak wataka' laj wanm y in wini' laj awanmak. ");
INSERT INTO uspNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Nen tijcoj impixb' y tran nen tijb'ij, tijc'uta' chi kes tz'etel tz'et injlok'aji'n y nen inlok'in in tilok'aji' jwi'l Inkaj y in tanlok'aji'n y tanc'uta' chiwch nen tamb'an, xche' Kakaj Jesús rechak. ");
INSERT INTO uspNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Xpe Judas, ma' ri' ta' Judas Iscariote, xtz'onaj re Kakaj Jesús: Wajawl, ¿nen chac xike chikawch oj tac'ut nen tab'an y ta' tac'ut chiwchak juntir mak cristian ri retake wich ulew? xche' re Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Kakaj Jesús xij chic re Judas: Nen inlok'inc y tijcoj inyolj, tilok'aji' jwi'l Inkaj y Inkaj pach in ojpetc, ojyuk wa'x laj ranm. ");
INSERT INTO uspNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Nen ta' inlok'inc, ta' tijcoj inyolj ri tamb'ij. Mak yoloj ri xatatak ma' inyolj ta'ke in, Jyolji' Kakaj Dios ri intakowinakch. ");
INSERT INTO uspNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Juntir li ximb'iji' chawechak lajori cuando ajwini' chaxo'lak. ");
INSERT INTO uspNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Lok'laj Jsantil Kakaj Dios ri ajye'l jcowil awanmak ri tijtakch Kakaj Dios aac'lak laj imb'j, tijc'uta' juntir li chawchak y tijcuxtaji' juntir chawechak ri ximb'ij chawechak. ");
INSERT INTO uspNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","In, inelb'i chaxo'lak, tican inye' utzil laj awanmak. Pero in ta' tanye' utzil laj awanmak chapca' jye'ic utzil trantak mak cristian ri b'esal ranmak chi jb'anic mak etzltak no'j, jwi'li'li mi c'axc'ob' awanmak y mi tzaak ach'olak. ");
INSERT INTO uspNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Xata'taka' ximb'ij chi imb'i'n y ink'aj chiqui'ch pire inyuk wa'x chic aac'lak. Wi kes tz'et inalok'ajtak, atqui'cottaka' cuando xatatak chi imb'i' riq'ui Kakaj Dios ri masna nim jk'ij chinwch in. ");
INSERT INTO uspNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Lajori tamb'ij jilonli chawechak cuando ajqui' chi taw chiwch, pire cuando titaw chiwch, ajruc're' tacojtak inyolj. ");
INSERT INTO uspNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Ta' chiqui' mas nen tamb'ij chawechak jwi'l petemchak re man ri wi' k'atb'itzij laj jk'ab' pire titakon wich ulew. Re ta' k'atb'itzij laj jk'ab' pire titakon chimb', ");
INSERT INTO uspNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","pero rajwaxi' jilonli tib'an pire tretemajtak juntir cristian wich ulew chi tanlok'aji' Kakaj Dios y tamb'ana' lawi' raj re tamb'an. B'iitentak, cojeltakb'i neri, xche' Kakaj Jesús rechak yak ajtijol rib'ak chirij. ");
INSERT INTO uspNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Kakaj Jesús xij chic rechak yak ajtijol rib'ak chirij: In ini' tz'etel jche'l uva y ri' Inkaj tiak'inanc y tichajin re. ");
INSERT INTO uspNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Re tijc'urb'i juntir mak jk'ab' man che' ri ta' tiwichintak, pero mak ri tiwichintak xike tresaj mak tra jk'unal jk'ab' y trak'inaj pire tijye' chic sub'laj jwich. ");
INSERT INTO uspNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Jilon atak, xantaji' ak'in chawechak jwi'l mak yoloj ri ximb'ij chawechak. ");
INSERT INTO uspNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Ma tos ayb'ak chwij chapca' in ta' tantos wib' chawijak. Jun jk'ab' uva ta' chiqui' tiwichin wi jorok eli'b'i chiwch man jche'l. Y ji'c'ulon atak ta' chiqui' atwichintak wi tatos ayb'ak chwij. ");
INSERT INTO uspNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","In ini' man jche'l uva y atak ataka' mak jk'ab'. Nen ta' tijtos rib' chwij, in ta' tantos wib' chirij y tijya' sub'laj jwich. Atak ta' nen atcwintak chi jb'anic wi tatos ayb'ak chwij. ");
INSERT INTO uspNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Nen tijtos rib' chwij tiesaji'b'i chwij chapca' jun jk'ab' che' tic'ursajb'ic y cuando tichekej timulb'aj jwichak tit'ojsajtak li k'ak' pire tic'attak. ");
INSERT INTO uspNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Wi atak ta' tatos ayb'ak chwij y wi ta' tisaach chawechak juntir inyolj ri ximb'ij chawechak, tz'onajtak nen chawajak y tiye'saji' chawechak. ");
INSERT INTO uspNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Inkaj sub'laj tinimirsaj jk'ij cuando atak nic' riq'uil atwichintak y jilonli tic'utun chi kes tz'etel tz'et ataka' ajtijol ayb'ak chwij. ");
INSERT INTO uspNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","In atinlok'ajtaka' chapca' inlok'aj in tran Kakaj Dios. Atak, mi can aye'tak lok'in chapca' alok'ajcak tamb'an in. ");
INSERT INTO uspNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Wi tacojtak impixb', ta' tican aye'tak lok'in chapca' alok'ajcak tamb'an in, jilon chapca' in tancoja' jpixb' Inkaj y ta' tican inye' lok'in chapca' inlok'aj tran re. ");
INSERT INTO uspNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","In jilonli tamb'ij chawechak pire tiwa'x inqui'cotem aac'lak y tiwa'xi' sub'laj qui'cotemal laj awanmak. ");
INSERT INTO uspNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Ri' ri impixb' ri tamb'ij chawechak, lok'aj ayb'ak chawib'il ayb'ak chapca' alok'ajcak tamb'an in. ");
INSERT INTO uspNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Wi jun cristian tijye' rib' pi camic pi jq'uexwach yak richc'ulchi', ri' li jun lok'in ri mas nim chiwch juntir lok'inc. ");
INSERT INTO uspNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Atak, ataka' wichc'ulchi' wi tab'antak lawi' ri tamb'ij chawechak, ");
INSERT INTO uspNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","ta' chiqui' tamb'ij immocom chawechak jwi'l jun mocom ta' retam nen tran jpatron. Lajori tamb'ij chawechak chi ataka' wichc'ulchi' jwi'l xinya' retemaj chawechak juntir ri b'il chwe jwi'l Inkaj. ");
INSERT INTO uspNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Ma' atak ta' xatcha'wtak we, ini' xincha'w awechak y ximb'iji' chawechak chi atb'etak y b'antak chapca' jun che' ri sub'laj tiwichintak y man jwich ri ta' jsachic jwich. Jilonli Inkaj tijya' chawechak nen chawajak tatz'onajtak re laj imb'j. ");
INSERT INTO uspNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Ri' ri impixb' ri rajwax tab'antak, lok'aj ayb'ak chawib'il ayb'ak, xche' Kakaj Jesús rechak yak ajtijol rib'ak chirij. ");
INSERT INTO uspNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Kakaj Jesús xij rechak: Wi atcontrijtak jwi'lak mak cristian ri retake wich ulew, ri' cuxtaj awi'lak chi ini' nab'e xinjcontrijtak. ");
INSERT INTO uspNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Atak witi atake re wich ulew atjlok'ajtaka' chapca' jlok'aj rib'ak rechak trantak chirib'il rib'ak, pero in xatincha'taka' chijxo'lak mak cristian li, jwi'li'li atjcontrijtak jwi'l ma' atak ta' chiqui' nic' riq'uilak. ");
INSERT INTO uspNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Cuxtaj awi'lak ri ximb'ij chawechak, ta' ni jono mocom mas nim jk'ij chiwch jpatron. Wi tib'an c'ax chwe in, jilon atak tina b'anna c'ax chawechak y wi tijcojtak inyolj, jilon ayolj atak tijcoja'taka'n. ");
INSERT INTO uspNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Juntir li tib'ani' chawechak jwi'l ataka' we y jwi'l ta' retamak nen tran ri intakowinakch. ");
INSERT INTO uspNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Ta' roj jmacak miti ximpe in chi jb'ij rechak nen raj Kakaj Dios trantak, pero jwi'l ximpeti' in chi jb'ij rechak nen raj Kakaj Dios trantak lajori ri'chak rechak ajmacb'tak jwi'l ta' trantak nen raj Kakaj Dios trantak. ");
INSERT INTO uspNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Yak cristian ri incontrinc, tijcontrijtaka' Inkaj. ");
INSERT INTO uspNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Ta' roj jmacak miti ximb'an c'utb'i jcwinel Kakaj Dios chiwchak ri ni jono cristian chic b'anowinak chiwchak. Pero ruc' li xrila'taka' juntir mak c'utb'i jcwinel Kakaj Dios y ajwichi' injcontrijtak y tijcontrijtak Inkaj. ");
INSERT INTO uspNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Jilon trantak li jwi'l rajwaxi' tina tawna chiwch juntir ri tz'ib'al li wuj re Lok'laj Jyolj Kakaj Dios ri tijb'ij jilonri: Injcontrijtak chi ma'qui' jcholajl, tiche'. ");
INSERT INTO uspNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Cuando tipe Lok'laj Jsantil Kakaj Dios ri ajye'l jcowil awanmak ri tib'in tz'etel tzij, re tiyuk jb'ij chawechak juntir ri q'uis b'anal inwi'l. Ri Lok'laj Jsantil Kakaj Dios tantakch aac'lak ji' tipe riq'ui Kakaj Dios. ");
INSERT INTO uspNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Y jilon atak tina ab'ijtakna juntir ri q'uis b'anal inwi'l, jwi'l atak wataka' wiq'uil cuando xinchol jb'anic juntir li, xche' Kakaj Jesús rechak yak ajtijol rib'ak chirij. ");
INSERT INTO uspNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Kakaj Jesús xij chic rechak: Juntir ri tamb'ij chawechak pirechi' ma' tak'el ayb'ak chwij. ");
INSERT INTO uspNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Atna esajtaknab'i lak sinagog y tina tawna jun k'ij chi mak ri atcamsantak, ri' chijch'ol rechak tijin tijt'o'tak Kakaj Dios. ");
INSERT INTO uspNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Rechak jilon trantak li jwi'l ta' retamak nen tran Inkaj y ta' retamak nen tamb'an in. ");
INSERT INTO uspNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Tamb'ij juntir li chawechak pire cuando titaw k'ij tib'ansaj c'ax chawechak ticuxtaj awi'lak chi b'ilchak chawechak inwi'l. Ta' ximb'ij juntir li chawechak xanwi'ch jwi'l ajwini' chaxo'lak, xche' Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Kakaj Jesús xij chic: Pero lajori imb'i' riq'uil ri intakowinakch y ni jono chawechak titz'onin chwe lamas imb'e'w. ");
INSERT INTO uspNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Xoqui' sub'laj b'is laj awanmak jwi'l ximb'ij juntir ri chawechak. ");
INSERT INTO uspNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Pero in tz'etel tz'et tamb'ij chawechak, ri' mas tzi pi awechak imb'ec. Jwi'l wi ta' imb'ec, ta' tipe Lok'laj Jsantil Kakaj Dios ri ajye'l jcowil awanmak y wi ximb'ec, tantaka'ch. ");
INSERT INTO uspNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Cuando tipe Lok'laj Jsantil Kakaj Dios tiyuk jb'ij rechak cristian lawi' mac ri tijin trantak, tiyuk jb'ij rechak chi trantak lawi' ri tzi tril Kakaj Dios y tiyuk jb'ij rechak chi Kakaj Dios trana' jk'atb'itzij chirijak jwi'l jmacak ri trantak. ");
INSERT INTO uspNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Tijb'iji' rechak chi ajmacb'taka' jwi'l ta' ticub'ar ach'olak chwij. ");
INSERT INTO uspNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Tretemajtak chi rajwaxi' trantak lawi' ri tzi tril Kakaj Dios, jwi'l in ji' imb'e wa'xok riq'ui Kakaj Dios y atak ta' chiqui' tawiltak inwch. ");
INSERT INTO uspNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Tijb'iji' rechak chi Kakaj Dios trana' jk'atb'itzij chirijak juntir cristian wich ulew jwi'l xana' k'atb'itzij chirij man jb'ab'al etzl ri titakon chib'ak cristian wich ulew. ");
INSERT INTO uspNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Wi' mas chwaj roj tamb'ij chawechak, pero ta' chiqui' tican chawechak ri tamb'ij. ");
INSERT INTO uspNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Pero cuando tipe Lok'laj Jsantil Kakaj Dios ri tib'in tz'etel tzij, re atyuk jtijojtaka' re tz'etel tzij jwi'l re ma' laj jno'j ta'ke tipe'w ri tijb'ij. Re ri' tijb'ij lawi' tijta y tijye' retemaj lawi' ri tina ranna nen or. ");
INSERT INTO uspNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Re tijnimirsaji' ink'ij, jwi'l re ri' tijta ri tamb'ij y tijb'ij chic chawechak. ");
INSERT INTO uspNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Juntir ri wi'tak laj jk'ab' Kakaj Dios wi' laj ink'b' in, jwi'li'li ximb'ij chawechak chi Lok'laj Jsantil Kakaj Dios ri' tijta ri tamb'ij y tijb'ij chic chawechak, xche' Kakaj Jesús rechak yak ajtijol rib'ak chirij. ");
INSERT INTO uspNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Kakaj Jesús xij chic rechak yak ajtijol rib'ak chirij: Ta' chiqui' naj tawiltak inwch, pero ta' naj li tawiltak chic inwch, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Xpetak yak nic'j ajtijol rib'ak chirij, xoctak chi jtz'onaj chirib'il rib'ak: ¿Nen chiqui' jcholajl tielwi' ri tijb'ij Kakaj Jesús chike jilonri? Ta' chiqui' naj tawiltak inwch, pero ta' naj li tawiltak chic inwch, tiche', xche'tak. Y tijb'ij chic: Jwi'l ji' imb'e riq'ui Inkaj, tiche'. ");
INSERT INTO uspNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Y xijtak: ¿Nenc'u jcholajl tielwi' li ri tijb'ij chi ta' chiqui' naj? Ta' tikata jcholajl nen tielwi' ri tijb'ij, xche'tak chirib'il rib'ak. ");
INSERT INTO uspNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Kakaj Jesús xretemaji' ric'an chi rechak rajak tijtz'onajtak re nen tielwi' ri xij, jwi'li'li xij rechak: In ximb'ij chawechak chi ta' chiqui' naj tawiltak inwch, pero ta' naj li tawiltak chic inwch, xinche'. ¿Roni' li ri attijintak chi jtz'onaj chawib'il ayb'ak? ");
INSERT INTO uspNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Kes tz'etel tz'et tamb'ij chawechak, atak atna ok'takna y tina c'axc'ob'na awanmak jwi'l b'is. Pero mak cristian ri retake wich ulew sub'laj tina qui'cottakna. Pero tina tawna jun k'ij ri jc'axc'ol awanmak tina wuxna pi qui'cotemal. ");
INSERT INTO uspNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Jilon chapca' jun yaj anm cuando titaw k'ij tijye' Dios re sub'laj c'ax tijtij, pero cuando jorok q'uisi'yi' ra ric'lal ta' chiqui' ticuxtaj jwi'l ri jc'axc'ol ri xtij jwi'l jqui'cotem chirij ra ric'lal ri xq'uisi'yc. ");
INSERT INTO uspNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Y ji'c'ulon atak lajori wi' c'ax laj awanmak jwi'l b'is jwi'l ta' chiqui' tawiltak inwch, pero cuando ink'aj chicch chi awilicak, ajruc're' tiwa'x chic jun nimlaj qui'cotemal laj awanmak y ta' nen tiesan chawechak. ");
INSERT INTO uspNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","La' mak k'ij li ta' chiqui' nen tatz'onajtak chwe. Kes tz'etel tz'et tamb'ij chawechak chi Kakaj Dios tijya' juntir chawechak nen tatz'onajtak re laj imb'j. ");
INSERT INTO uspNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Y lajori ajqui' nen tz'onal awi'lak laj imb'j, tz'onajtak y tiye'saji' chawechak pire sub'laj atqui'cottakwi', xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Kakaj Jesús xij chic rechak: Ximb'iji' juntir ri chawechak la'ke esb'itak no'j. Pero tina tawna k'ij ri ta' chiqui' tamb'ij jono yoloj chawechak la' esb'itak no'j, tamb'iji' chawechak chi sakil chirij Kakaj Dios. ");
INSERT INTO uspNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","La' mak k'ij li tatz'onajtak re Kakaj Dios laj imb'j ri chawajak. In tamb'ij chawechak chi tina intz'onajna tok'ob' re Kakaj Dios chawijak, ");
INSERT INTO uspNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","jwi'l re atjlok'ajtaka'n, jwi'l atak xinalok'ajtaka'n y xacoja'taka' chi Kakaj Diosi' intakowinakch. ");
INSERT INTO uspNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Xinelch riq'ui Kakaj Dios pire xinyuk wa'x neri wich ulew, pero lajori inelb'i neri wich ulew pire ink'aj chic riq'ui Kakaj Dios, xche' rechak yak ajtijol rib'ak chirij. ");
INSERT INTO uspNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Y xpetak yak ajtijol rib'ak chirij, xijtak re: Lajori kes tz'etel tz'et tijin tab'ij chike chi sakil, ma' la' ta' chiqui' esb'itak no'j tab'ij chike. ");
INSERT INTO uspNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Lajori ketamchak chi awetami' juntir y ta' rajwax wi' jonok titz'onin chawe jwi'l awetami' nen wi' laj ranm. Jwi'li'li tikacoja' chi ji' petzalcat riq'ui Kakaj Dios, xche'tak re. ");
INSERT INTO uspNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Kakaj Jesús xij chic rechak: ¿Tonc'u acoja'taka' lajori? ");
INSERT INTO uspNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Tawem re man or y lajori xtawi' man or li, tatil ayb'ak incan aye'tak wic'an, pero ta' incan wic'an jwi'l wi' Kakaj Dios wiq'uil. ");
INSERT INTO uspNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Tamb'ij juntir ri chawechak pire tiwa'x utzil laj awanmak jwi'l ataka' jun wiq'uil. Atak tina atijtakna sub'laj c'ax neri wich ulew, pero wa'xok jcowil awanmak jwi'l in xincwini' chirij man jb'ab'al etzl ri titakon chib'ak cristian neri wich ulew, xche' Kakaj Jesús rechak yak ajtijol rib'ak chirij. ");
INSERT INTO uspNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Cuando xijmaj jilonli jwi'l Kakaj Jesús rechak yak ajtijol rib'ak chirij, xna'tun lecj y xij: Kaj, xtawi' or tanimirsaj jk'ij Ac'ajol pire tinimirsaj ak'ij jwi'l Ac'ajol. ");
INSERT INTO uspNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","At xatye'w k'atb'itzij laj jk'ab' Ac'ajol chib' juntir cristian pire tijye' jun tzilaj c'aslemal aac'l lecj ri ta' jq'uisic rechak juntir yak ri jachal laj jk'ab' awi'l. ");
INSERT INTO uspNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Ri' ri, ri tic'amomb'i li tzilaj c'aslemal lecj ri ta' jq'uisic, rajwaxi' tretemajtak nen tab'an at, ri xike at ri tz'etel Dios y ta' ni jono chic y tretemajtak nen tran Jesucristo ri takalch awi'l wich ulew. ");
INSERT INTO uspNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","In xinnimirsaji' ak'ij neri wich ulew y xinq'uisa' jb'anic juntir ri xinatakch chi jb'anic. ");
INSERT INTO uspNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Lajori, Kaj, nimirsaj ink'ij aac'l chapca' jnimal ink'ij ri wi' cuando ajwini' aac'l cuando ajqui' chi wa'x caj pach ulew. ");
INSERT INTO uspNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Y yak ri cha'l awi'l chijxo'lak mak cristian ri retake wich ulew pire xajach laj ink'b', ximb'iji' rechak nen ab'anic at. Rechak laj ak'b'i' wi'tak, pero xak'asaji' laj ink'b' in y lajori xcoja'taka' ayolj. ");
INSERT INTO uspNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Lajori retamakchak chi juntir ri xaye' chwe ji' petzal aac'l. ");
INSERT INTO uspNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Y ximb'iji' rechak ri xinatakch chi jb'ij y rechak xcoja'taka'n. Xretemajtaka' chi ji' ximpe aac'l y rechak xcoja'taka' chi ati' attakowinakch we. ");
INSERT INTO uspNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","In tantz'onaj tok'ob' chawe chirijak, ta' tantz'onaj tok'ob' chawe chirijak mak cristian ri retake wich ulew. In tantz'onaj tok'ob' chawe chirijak yak ri cha'l awi'l ri wi'tak laj ink'b' jwi'l awechi'n. ");
INSERT INTO uspNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Juntir ri we in, awechi' at y juntir ri awe at, wechi' in y yak cristian li xnimirsajtaka' ink'ij. ");
INSERT INTO uspNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","In ta' chiqui' naj inwa'x neri wich ulew, pero rechak tina cantakna wich ulew y in inelb'i neri pire imb'e wa'xok aac'l. At Lok'laj Inkaj, la' acwinel chajaj yak ri jachal laj ink'b' awi'l pire trantak junke jwichak chapca' in aac'l ojke jun. ");
INSERT INTO uspNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","In cuando win riq'uilak neri wich ulew, xinchajajtaka' la' acwinel juntir yak ri jachal laj ink'b' awi'l y xincola'taka'n, ni jono rechak xsaachtak. Pero xike jun ri tina saachna chijxo'lak jwi'l tina tawna chiwch ri tijb'ij li wuj re Lok'laj Ayolj. ");
INSERT INTO uspNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Lajori inchak b'e lamas watwi' at, pero jwi'l ajwinna chijxo'lak neri wich ulew tamb'ij juntir ri pire tiwa'x sub'laj qui'cotemal laj ranmak jilon chapca' ri wi' laj wanm in. ");
INSERT INTO uspNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","In ximb'iji' ri xinatakch chi jb'ij rechak, pero mak cristian ri retake wich ulew tijcontrijtaka' rechak jwi'l rechak ma' retak ta' wich ulew chapca' in ma' in ta' re wich ulew. ");
INSERT INTO uspNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","In ta' tantz'onaj tok'ob' chawe chi tawesajtakb'i neri wich ulew, in tantz'onaj tok'ob' chawe chi tacoltak laj jk'ab' man jb'ab'al etzl. ");
INSERT INTO uspNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Rechak ma' retak ta' wich ulew jilon chapca' in, ma' in ta' re wich ulew. ");
INSERT INTO uspNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Tostak pi awe la' atzij pire trantak lawi' chawaj trantak, atzij tz'etel tz'eti'n. ");
INSERT INTO uspNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Chapca' intakicch in xab'an chijxo'lak mak cristian ri retake wich ulew, jilon jtakicak rechak tamb'an chicb'i in chijxo'lak mak cristian ri retake wich ulew. ");
INSERT INTO uspNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Y jwi'l rechak tanjach wib' laj ak'b' pire kes tz'etel tz'et titosmajtak pi awe. ");
INSERT INTO uspNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Pero ma' xita'ke chirijak yak ajtijol rib'ak chwij ri, tantz'onaj tok'ob' chawe, jilon chirijak yak ri tina cub'arna jch'olak chwij nen or jwi'l ri tijb'ijtak rechak. ");
INSERT INTO uspNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","In tantz'onaj tok'ob' chawe chirijak juntir rib'ilak pire tiwuxtak jun kiq'uil chapca' in aac'l ojke jun jwi'l wati' laj wanm y in wini' laj awanm. Y tantz'onaj tok'ob' chawe chi tiwuxtak junke jwichak pire tretemajtak mak cristian ri retake wich ulew chi ati' attakowinakch we. ");
INSERT INTO uspNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","In xinnimirsaji' jk'ij rechak chapca' jnimal ink'ij in pire tiwuxtak junke jwichak chapca' in aac'l ojke jun. ");
INSERT INTO uspNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","In inwa'xi' laj ranmak rechak y at wati' laj wanm pire tiwuxtak chapca' juntake chi cristian, jilonli juntir mak cristian ri retake wich ulew tretemajtak chi ati' attakowinakch we y talok'ajtaka' rechak chapca' inlok'aj in tab'an. ");
INSERT INTO uspNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Kaj, at xatjachow rechak laj ink'b' y ri' chwaj tiwa'xtak rechak wiq'uil lamas imb'e wa'xok in, pire triltak jnimal ink'ij ri ye'l awi'l jwi'l lok'alquinchakch awi'l cuando ajqui' chi wa'x caj pach ulew. ");
INSERT INTO uspNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Kaj, ri atb'anow juntir ri kes pi jcholajl, mak cristian ri retake wich ulew ta' tretemajtak nen tab'an. Pero in wetami' nen tab'an y yak ri jachal laj ink'b' awi'l retamakchak chi ati' attakowinakch we. ");
INSERT INTO uspNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Xinya' retemaj rechak nen ab'anic at y tina imb'ijna chic rechak pire tilok'intak chapca' inlok'aj in tab'an y pire inwa'x laj ranmak, xche' Kakaj Jesús re Kakaj Dios. ");
INSERT INTO uspNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Cuando xantaj ch'a'wem riq'ui Kakaj Dios jwi'l Kakaj Jesús xeltakb'i pach yak ajtijol rib'ak chirij, xe'tak ch'akap re man b'e ja' ri jb'ij Cedrón. Y cla' wi' jun ra luwar lamas wi' tico'n, Kakaj Jesús xoc cla' pach yak ajtijol rib'ak chirij. ");
INSERT INTO uspNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Judas ri tijachow re Kakaj Jesús pi camic retami' man luwar li jwi'l Kakaj Jesús q'uilaj b'welt xmulb'a' rib'ak cla' pachak juntir yak ajtijol rib'ak chirij. ");
INSERT INTO uspNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Jwi'li'li Judas xe' cla' pach jun k'at soldad, nic'j rechak mak ajchajaltak re nimi richoch Kakaj Dios wikem rib'ak re ch'o'j takaltakb'i jwi'lak mak jb'ab'alak yak ajc'amaltak jb'eak cristian riq'ui Kakaj Dios pach mak fariseo y c'amalb'i candil y tzuq'uelb'i k'ak' jwi'lak. ");
INSERT INTO uspNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Kakaj Jesús retami' nen tib'an re, re xelch chi jc'ulicak y xtz'onaj rechak: ¿Nen tatoctak? xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Rechak xijtak re Kakaj Jesús: Ri' tijin tikatoc Jesús aj Nazaret, xche'tak re. Kakaj Jesús xij rechak: Ini'n, xche' rechak. Y man Judas ri xjachow re Kakaj Jesús pi camic wi' chijxo'lak. ");
INSERT INTO uspNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Cuando Kakaj Jesús xij: Ini'n, xche'. Rechak xk'aj chirijak y xtzaaktak lak ulew. ");
INSERT INTO uspNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Y Kakaj Jesús xtz'onaj chic rechak: ¿Nen tatoctak? xche' rechak. Rechak xijtak chic re Kakaj Jesús: Tijin tikatoc Jesús aj Nazaret, xche'tak re. ");
INSERT INTO uspNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Kakaj Jesús xij chic rechak: Ximb'iji' chawechak chi ini'n. Wi in inatoctak, ma chaptak yak nic'j ri, ye'tak luwar rechak tib'etak, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Kakaj Jesús xij jilonli pire titaw chiwch ri xij re Kakaj Dios: Juntir ri jachal laj ink'b' awi'l ta' xsaach ni jono rechak, xche'. ");
INSERT INTO uspNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Xpe Simón Pedro, xresajch man respad ri c'amal jwi'l, xc'urb'i jpaach jxicn jun rechak ri jb'ij Malco, ri jmocom man nimlaj jb'ab'alak yak ajc'amaltak jb'eak cristian riq'ui Kakaj Dios. ");
INSERT INTO uspNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Xpe Kakaj Jesús, xij re Simón Pedro: C'ol awespad laj jluwr. Wi Inkaj tib'in chi tina intijna man c'ax ri, ¿ta'c'u tantij b'an? xche' re. ");
INSERT INTO uspNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Ajruc're' xpetak mak soldad pachak man jb'ab'alak y yak rijajl Israel ri ajchajaltak re nimi richoch Kakaj Dios, xchaptak Kakaj Jesús y xximtak. ");
INSERT INTO uspNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Y xc'amtakb'i riq'ui Anás, Anás jji'yi' Caifás y la' man junab' li Caifás wi' pire nimlaj jb'ab'alak yak ajc'amaltak jb'eak cristian riq'ui Kakaj Dios. ");
INSERT INTO uspNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Y ri' Caifás li ri xin rechak mak jb'ab'alak yak rijajl Israel chi ri' mas tzi pi rechak ticamsaj jun chi cristian chiwch ticamtak juntir cristian laj jtilmitak. ");
INSERT INTO uspNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simón Pedro pach jun ajtijol rib' chirij Kakaj Jesús xamb'ertakb'i chirij. Man ajtijol rib' li chirij Kakaj Jesús, ch'ob'oli' jwich jwi'l man nimlaj jb'ab'alak yak ajc'amaltak jb'eak cristian riq'ui Kakaj Dios, jwi'li'li xocb'i chirij Kakaj Jesús asta chuchja. ");
INSERT INTO uspNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Pero Pedro ji' xcan wa'r chi' man pwert ri wi' chi' b'e, xpe man ajtijol rib' chirij Kakaj Jesús li ri ch'ob'ol jwich jwi'l man nimlaj jb'ab'alak yak ajc'amaltak jb'eak cristian riq'ui Kakaj Dios xelch y xch'ab'ej man anm ri ajchajal re man pwert li y jilonli xna' xcojb'i Pedro chuchja. ");
INSERT INTO uspNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Xpe man anm li ri ajchajal re man pwert, xij re Pedro: At, ati' jun ajtijol ayb' chirij man winak li, xche' re. Pedro xij re: ¡Ma' in ta'n! xche' re. ");
INSERT INTO uspNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Y jwi'l sub'laj jsical tew tijin tran, mak mocom pach mak ajchajaltak re nimi richoch Kakaj Dios cojol jun k'ak' jwi'lak chuchja, rechak wa'ltak chi' k'ak', tijin tijmik' rib'ak. Y jilon Pedro wi' riq'uilak tijin tijmik' rib' chi' k'ak'. ");
INSERT INTO uspNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Xpe man nimlaj jb'ab'alak yak ajc'amaltak jb'eak cristian riq'ui Kakaj Dios, xoc chi jtz'onaj re Kakaj Jesús nen nojotak yak ajtijol rib'ak chirij y nen chi c'utu'n lal tijin tijtijoj cristian. ");
INSERT INTO uspNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Kakaj Jesús xij re: In xinyolowi' riq'uilak juntir cristian y xintijojtaka' cristian lak sinagog y xintijojtaka' cristian li nimi richoch Kakaj Dios. In ta' ni jono yoloj b'il inwi'l chi mukukil. ");
INSERT INTO uspNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Y, ¿nen chac tatz'onaj chwe nen chi c'utu'n lal tijin tantijoj cristian? Ri' tz'onaj rechak yak ri xtawtak inyolj, rechak retamaki' nen chi c'utu'n lal b'il rechak inwi'l, xche' Kakaj Jesús re. ");
INSERT INTO uspNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Cuando xij Kakaj Jesús jilonli, xpe jun rechak mak ajchajaltak re nimi richoch Kakaj Dios ri wa'l chijc'ulel Kakaj Jesús, xsec'b'i Kakaj Jesús y xij re: ¿Nen chac jilon jc'ululaj nimlaj jb'ab'alak yak ajc'amaltak jb'eak cristian riq'ui Kakaj Dios tab'an? xche' re. ");
INSERT INTO uspNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Kakaj Jesús xij re: Wi wi' jono yoloj ri ta' tz'et xel laj ínchi', b'ij chwe lawi' ri ta' tz'et ri ximb'ij, pero wi tz'eti' ri ximb'ij, ¿nen chac inasec'? xche' re. ");
INSERT INTO uspNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Ajruc're' xpe Anás, xtakb'i Kakaj Jesús pi ximil riq'ui Caifás ri man nimlaj jb'ab'alak yak ajc'amaltak jb'eak cristian riq'ui Kakaj Dios. ");
INSERT INTO uspNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Simón Pedro aj wa'li' chi' k'ak' chi jmik'ic rib' cuando xtz'onajtak chic re: ¿Miti ati' jun ajtijol ayb' chirij man winak li? xche'tak re. Re ta' raj tijb'ij chi ri'n, xij: ¡Ma' in ta'n! xche'. ");
INSERT INTO uspNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Xpe jun rechak mak rajchac man nimlaj jb'ab'alak yak ajc'amaltak jb'eak cristian riq'ui Kakaj Dios, ri rech'elxic man jun ri xesaj jxicn jwi'l Pedro, xij re Pedro: Pero xattwila' chi wati' riq'uil la' man ra luwar lak tico'n, xche' re. ");
INSERT INTO uspNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Pedro ta' raj xij chi ri'n, etke xok' jun puy. ");
INSERT INTO uspNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Cuando xsakarsanc, xresajtakb'i Kakaj Jesús laj richoch Caifás, xc'amtakb'i la' man ja lamas tranwi' jk'atb'itzij man k'atb'itzij re Roma. Mak jb'ab'alak yak rijajl Israel ta' xoctak li k'atb'itzij pire ma' trantak kelen ri mac jb'anic chapca' tijb'ij jpixb'ak pire tijna' tijtijtak jwaak re man nimak'ij Pascua, ");
INSERT INTO uspNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","jwi'li'li Pilato xelch la ja chi jtz'onaj rechak: ¿Nen jmac winak ri chawchak? xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Rechak xijtak re Pilato: Miti wi' jmac b'anal jwi'l ta' roj xkac'amch aac'l, xche'tak re. ");
INSERT INTO uspNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Xpe Pilato, xij rechak: C'amtakb'ic y b'an ak'atb'itzijak chirij chapca' tijb'ij apixb'ak, xche' rechak. Mak jb'ab'alak yak rijajl Israel xijtak re Pilato: Pero ke oj ri oj rijajl Israel ta' ye'l luwar chike tikacamsaj jun cristian, xche'tak. ");
INSERT INTO uspNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Jilon xaan li pire xtaw chiwch chapca' ri b'il jwi'l Kakaj Jesús chirij nen mo jcamic. ");
INSERT INTO uspNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Pilato xoc chicb'i la' man ja lamas tranwi' jk'atb'itzij, xsiq'uij Kakaj Jesús y xtz'onaj re: ¿Atni' jreyak yak rijajl Israel? xche' re. ");
INSERT INTO uspNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Kakaj Jesús xtz'onaj re: ¿Atni'ke atb'in jilonli o wi' jujun cristian xintak chawe jilonli chwij? xche' re. ");
INSERT INTO uspNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilato xij chic re Kakaj Jesús: ¿Inc'u jun rijajl Israel tawil? Ri'taka' mak cristian ri awinak pach mak jb'ab'alak yak ajc'amaltak jb'eak cristian riq'ui Kakaj Dios ri xatjachowtak laj ink'b'. Y, ¿nenc'u b'anal awi'l? xche' re. ");
INSERT INTO uspNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Kakaj Jesús xij chic re: Ri takon ri wi' laj ink'b' ma' re ta' wich ulew. Witi intakon re tike wich ulew, yak intako'n titica' jtij jk'ijakre' pire ma' inchapsaj jwi'lak mak jb'ab'alak yak rijajl Israel. Pero intakon ma' re ta' wich ulew, xche'. ");
INSERT INTO uspNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Xpe Pilato, xtz'onaj chic re: ¿Atc'u rey? xche' re. Kakaj Jesús xij chic re: At xatb'in chi ini' rey. In ximpe neri wich ulew y xinyuk q'uisi'y pirechi' tiyuk imb'ij tz'etel tzij, juntir yak ri ticojowtak tz'etel tzij, tijta'taka' jcholajl lawi' ri tamb'ij, xche'. ");
INSERT INTO uspNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pilato xij chic re: ¿Nenc'u li tz'etel tzij? xche' re. Pilato cuando xijmaj jilonli re Kakaj Jesús jwi'l, xel chicch chi jch'ab'ejcak mak jb'ab'alak yak rijajl Israel y xij rechak: In ta' tanta' ni jono jmac winak ri. ");
INSERT INTO uspNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Pero atak nojel junab' la' man nimak'ij Pascua nak'talcataka' chi tatz'onajtak chwe chi tantakb'i jun prex. ¿Chawajakni' tantakb'i jreyak yak rijajl Israel? xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Juntir rib'ilak xch'ejejtak, xijtak: ¡Re ta' tatakb'ic! ¡Ri' takb'i Barrabás! xche'tak. Man Barrabás jun alk'omi'n. ");
INSERT INTO uspNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Xpe Pilato, xtak jseq'uic Kakaj Jesús chi chicot. ");
INSERT INTO uspNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Xpetak mak soldad, xpach'ujtak jun coron la' q'uix, xcojtak laj jb'a y xcojtak jun morad itz'ik chirij. ");
INSERT INTO uspNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Xjutuntak chijc'ulel y xoctak chi jb'ij re: ¡Nim ak'ij, at jreyak yak rijajl Israel! xche'tak re. Y xoctak chi jseq'uic chi k'ab'. ");
INSERT INTO uspNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pilato xel chicch la ja lamas tranwi' jk'atb'itzij y xij rechak mak jb'ab'alak yak rijajl Israel: Xwesajch neri pire tawiltak chi in ta' xinta' ni jono jmac, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Xelch Kakaj Jesús, cojolchakch jun coron laj jb'a ri pach'ul la' q'uix y cojolch man morad itz'ik jwi'l. Ajruc're' xpe Pilato, xij chic rechak: Co' winak ri, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Cuando xriltak mak jb'ab'alak yak ajc'amaltak jb'eak cristian riq'ui Kakaj Dios pach mak ajchajaltak re nimi richoch Kakaj Dios sub'laj cow xch'ejejtak, xijtak: ¡Camsaj wich curs! ¡Camsaj wich curs! xche'tak. Pilato xij chic rechak: C'amtakb'i atak y camsajtatak wich curs jwi'l in ta' ni jono jmac xinta'w, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Xpetak yak rijajl Israel, xijtak chic re Pilato: Oj wi' jun kapixb' y kapixb' tijb'ij chi rajwaxi' ticamsaj jwi'l xcoj rib' pi Jc'ajol Kakaj Dios, xche'tak. ");
INSERT INTO uspNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Cuando xta Pilato chi jilonli xijsaj re, sub'laj xtzaak jch'ol. ");
INSERT INTO uspNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Xoc chicb'i la ja lamas tranwi' jk'atb'itzij y xtz'onaj chic re Kakaj Jesús: ¿Lamas atpe'w? xche' re. Pero Kakaj Jesús ta' xc'ululaj. ");
INSERT INTO uspNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Ajruc're' Pilato xtz'onaj chic re: ¿Nen chac ta' inac'ululaj? ¿Ta'c'u awetam chi in wi' k'atb'itzij laj ink'b' atintakb'ic y wi' k'atb'itzij laj ink'b' atincamsaj wich curs? xche' re. ");
INSERT INTO uspNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Kakaj Jesús xij chic re: Ta' tijna' tab'an ak'atb'itzij chimb' miti xye'saj luwar chawe jwi'l Kakaj Dios. Jwi'li'li man ri xinjachow laj ak'b' wi' mas jmac chawch at, xche' re. ");
INSERT INTO uspNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Jilonli cuando Pilato xoc chi jtoquic nen roj xane' chi jtakicb'i Kakaj Jesús, pero yak rijajl Israel sub'laj cow xch'ejejtak chic, xijtak: ¡Wi tatakb'i man winak li, ma' at ta' richc'ulchi' César! ¡Nen tijcoj rib' pi rey chapca' xan man winak li, tijcontriji' César! xche'tak re Pilato. ");
INSERT INTO uspNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Pilato, cuando xta chi jilonli xijsaj re, xtak resajb'i Kakaj Jesús chuchja re man ja lamas tranwi' jk'atb'itzij. Re xcub'ar la' man jcub'arb' lamas tranwi' jk'atb'itzij. Man cub'arb' li ji' wi' li man luwar ri tib'ijsaj Tusum Ab'aj re, pero li tzijb'al hebreo tijb'ij Gabatá re. ");
INSERT INTO uspNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Y ri'chak chwek' nimak'ij Pascua, raj cab'lajuj (12) or, xpe Pilato cow xch'a'wc, xij rechak yak rijajl Israel: ¡Co' areyak ri! xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Pero rechak sub'laj cow xch'ejejtak, xijtak: ¡Camsajok! ¡Camsajok! ¡Camsajok wich curs! xche'tak re. Pilato xtz'onaj chic rechak: ¿Tonc'u incamsaj wich curs areyak? xche' rechak. Xpetak mak jb'ab'alak yak ajc'amaltak jb'eak cristian riq'ui Kakaj Dios, xijtak re Pilato: Oj ta' chiqui' jono karey chic titakon chikab', xike César karey, xche'tak re. ");
INSERT INTO uspNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Jilonli Pilato xq'uistaj ranm chi jta'icak, xjachb'i Kakaj Jesús laj jk'ab'ak pire tib'e jcamsajtak wich curs. ");
INSERT INTO uspNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Kakaj Jesús b'atelb'alb'i jcurs jwi'l, xc'amtakb'i la' man luwar ri jb'ij Jb'akel Jb'a Cristian ri tib'ijsaj Gólgota re li tzijb'al hebreo. ");
INSERT INTO uspNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Cla' xtz'octak Kakaj Jesús wich curs pach quib' winak y Kakaj Jesús xye'tak li xo'l. ");
INSERT INTO uspNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilato xtak jcojic jun kelen wich curs tz'ib'al jwich ri tijb'ij: RI' RI JESÚS AJ NAZARET RI JREYAK YAK RIJAJL ISRAEL, tiche'. ");
INSERT INTO uspNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Sub'laj q'ui yak rijajl Israel ri wi'tak Judea xriltak nen tijb'ij ri tz'ib'al wich man kelen, jwi'l man luwar lamas xe' camsajwi' Kakaj Jesús wich curs nakajke re man tilmit y man kelen ri cojol wich curs tz'ib'ali' jwich li uxib' jwich tzijb'al, li hebreo, li griego y li latino. ");
INSERT INTO uspNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Jwi'li'li xpetak mak jb'ab'alak yak ajc'amaltak jb'eak cristian riq'ui Kakaj Dios ri rijajl Israel, xijtak re Pilato: Ma tz'ib'aj chi ri jreyak yak rijajl Israel, tz'ib'aj chi ri'ke re xcoj rib' pi jreyak yak rijajl Israel, xche'tak re Pilato. ");
INSERT INTO uspNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pero Pilato xij rechak: Ri jtz'ib'aj ximb'an, jilon ticanwi', xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Cuando xtz'ocmaj Kakaj Jesús wich curs jwi'lak mak soldad, xc'amtak ritz'ik ri tijk'u'j, xoctak chi jjachic chiwchak chi quejab' rib'ilak jujun xc'amtak chi jujunalak mak soldad y xc'amtak man túnica ta' jtz'isb'al, quemelke tielch ajsic asta chi rakan. ");
INSERT INTO uspNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Jwi'li'li xpetak mak soldad, xijtak chirib'il rib'ak chirij man itz'ik li: Ta' tikarech'tak, katzake'tak suert chirij pire tikiltak nen chike tich'ecow re, xche'tak. Y xoctak chi jtzakic suert chirij. Y jilonli xantak pire xtaw chiwch ri tijb'ij li wuj re Lok'laj Jyolj Kakaj Dios jilonri: Xjachtak witz'ik chiwchak y xtzaktak suert chirij witz'ik chi rilic nen tich'econ re, tiche'. Jilonli xantak mak soldad. ");
INSERT INTO uspNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Chijc'ulel jcurs Kakaj Jesús wi' jchuch pach jk'un, María ri rixokl Cleofas y María Magdalena. ");
INSERT INTO uspNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Kakaj Jesús, cuando xril chi wa'l jchuch chijc'ulel pach jun ajtijol rib' chirij ri sub'laj tijlok'aj, xij re jchuch: Chuch, co' jun winak li nic' riq'uil ri' awic'lal, xche' re. ");
INSERT INTO uspNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Y xij chic re ri ajtijol rib' chirij: Niq'ui' riq'uil achuch anm ri, xche' re. Jilonli xpe man ajtijol rib' li xc'amb'i María laj richoch. ");
INSERT INTO uspNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Cuando xijmaj jilonli jwi'l Kakaj Jesús, re retami' chi xantaji' juntir y pire titaw chiwch juntir ri tijb'ij li wuj re Lok'laj Jyolj Kakaj Dios, xij: Tichekej ínchi', xche'. ");
INSERT INTO uspNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Y cla' wi' jun nejb' nojsal chi vinagre. Xpetak mak soldad, xmu'takb'i jun esponj li man vinagre y xye'takb'i man esponj chi jtzam jun jk'ab' che' ri tib'ijsaj hisop re y xye'takb'i laj jchi' Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Kakaj Jesús xtij man vinagre li y xij: Xantaji' juntir, xche'. Xxulb'a' jb'a, xjach jsantil laj jk'ab' Kakaj Dios y xcamc. ");
INSERT INTO uspNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Tawem tran or pire ticholmaj k'ij re uxlan. Mak jb'ab'alak yak rijajl Israel ta' rajak tican ye'sajtak wich curs yak winak li la' man k'ij re uxlan, jwi'l man k'ij li nimi' jk'ij jwi'l nimak'iji' re Pascua. Jwi'li'li xtz'onajtak re Pilato chi tijtak jk'ajic ra'ak yak ri tz'ocoltak wich curs pire ticamtak laj or y jilonli tijna' tijkesajtak. ");
INSERT INTO uspNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Xpetak mak soldad, xe'tak chi jk'ajic ra'ak yak ri tz'ocoltak wich curs. Nab'e xk'ajtak ra' jun, ajruc're' xk'ajtak chic ra' man jun chic ri xtz'ocsaj wich curs chijc'ulel Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Pero cuando xjutuntak chijc'ulel Kakaj Jesús pire roj xk'aje'tak ra', xriltak chi camnakchak, ta' chiqui' xk'ajtak ra'. ");
INSERT INTO uspNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Pero xpe jun rechak mak soldad xc'ob' laj jxucul Kakaj Jesús chi lans y laj or xelch jquiq'uel pach ja' lamas xc'ob'saj re chi lans. ");
INSERT INTO uspNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Y ri tiyolow li, ri' jun ri xiliw re y tz'etel tz'eti' ri tijb'ij. Re retami' chi tz'etel tz'eti' ri tijb'ij pire tacojtak. ");
INSERT INTO uspNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Jilonli xaan pire xtaw chiwch juntir ri tijb'ij li wuj re Lok'laj Jyolj Kakaj Dios jilonri: Ta' ni jun jb'akel tik'ajsaj, tiche'. ");
INSERT INTO uspNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Y li jun luwar re li wuj re Lok'laj Jyolj Kakaj Dios tijb'ij chic jilonri: Tina riltakna jwich ri xc'ob'tak laj jxucul, tiche'. ");
INSERT INTO uspNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Cuando xantaj li, xpe José aj Arimatea ri jun rechak yak ajtijol rib'ak chirij Kakaj Jesucristo, pero chi mukukilke jwi'l titzaak jch'ol chiwchak mak jb'ab'alak yak rijajl Israel. Re xtz'onaj re Pilato chi tiye'saj luwar re tijc'amb'i jcamnakl Kakaj Jesús. Pilato xya' luwar re y re xk'ax jc'ame'b'ic. ");
INSERT INTO uspNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Y cuando José ajqui' chi jkesaj jcamnakl Kakaj Jesús xtaw Nicodemo ri xe' solinok re Kakaj Jesús li jun ak'ab', c'amalb'i raj jun quintal chi perjum jwi'l, b'anal la' mirra yujul pach áloe. ");
INSERT INTO uspNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Y jilonli xpe José pach Nicodemo xc'amtak jcamnakl Kakaj Jesús y xb'atz'tak la' q'uertak itz'ik ri jb'ij lino ri ye'l man perjum li la'. Jilonli xantak jwi'l yak rijajl Israel nak'taltaka' jilon trantak cuando tijmuktak jun camnak. ");
INSERT INTO uspNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Chijc'ulel man luwar lamas xcamsaj Kakaj Jesús wich curs wi' jun ra luwar re tico'n y li man luwar li wi' jun aac' jul ri c'otol li ab'aj re mukb'i camnak ri ta' ni jun camnak mukul cla'. ");
INSERT INTO uspNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Jwi'l tawem tran or pire ticholmaj k'ij re uxlan pi rechak yak rijajl Israel y man jul li re mukb'i camnak nakajke wi'w, xmuktak jcamnakl Kakaj Jesús cla'. ");
INSERT INTO uspNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Li nab'e k'ij re xuman, María Magdalena sub'laj ak'ab', aj uku'mna, xe' chi' jul lamas xye'sajwi' jcamnakl Kakaj Jesús, ri'chak xril ta' chiqui' man nimlaj ab'aj laj jluwr ri cojol pire ch'ukb'i jchi' man jul. ");
INSERT INTO uspNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Re xe' jol lamas wi' Simón Pedro pach man jun ajtijol rib' chirij Kakaj Jesús ri sub'laj tilok'aj jwi'l Kakaj Jesús, xij rechak: ¡Xresajtaka'b'i Kakaj Jesús ri Kajawl lamas mukulwi' y ta' ketam lamas xe' jye'tak chic! xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Ajruc're' Pedro pach man jun chic ajtijol rib' chirij Kakaj Jesucristo xe'tak jol chi rilic chi' jul lamas xmuksajwi'. ");
INSERT INTO uspNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Chi quib' rib'ilak tijolin xe'tak chi rilic, pero man jun chic ajtijol rib' chirij Kakaj Jesús masna xjolin chiwch Pedro. Re nab'e xtaw chi' jul lamas xmuksajwi' Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Re xtacar chi rilic li jul, xril mak q'uertak itz'ik ri jb'ij lino ri xb'atz'sajb'i chirij Kakaj Jesús canali' li jul, pero re ta' xocb'i li jul chi rilic. ");
INSERT INTO uspNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Ajruc're' xtaw chic Simón Pedro ri xamb'erb'i chirij, re xocb'i li jul, ri'chak xril mak itz'ik ri xb'atz'sajb'i chirij Kakaj Jesús canal cla'. ");
INSERT INTO uspNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Y xril man sut' ri quiek la' xpisb'ejb'i jb'a Kakaj Jesús canali' cla', pero ta' c'amem rib' pach mak ri xb'atz'sajb'i chirij, man sut' li b'otol jwich canal li jun jalan luwar. ");
INSERT INTO uspNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Ajruc're' man jun chic ajtijol rib' chirij Kakaj Jesucristo ri xtaw nab'e chi' jul lamas xmuksajwi' Kakaj Jesús, xocb'i li jul. Xril juntir ri xaanc y re xcoja' chi xc'astasaji'b'i jwich Kakaj Jesús laj jcamnakl. ");
INSERT INTO uspNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Pero rechak ajqui' chi jmajtak jcholajl ri tijb'ij li wuj re Lok'laj Jyolj Kakaj Dios chi Kakaj Jesús tina c'astasajna jwich laj jcamnakl xo'lak camnakib'. ");
INSERT INTO uspNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Xpetak yak ajtijol rib'ak chirij Kakaj Jesucristo li, xk'ajtak la ja lamas wi'tak. ");
INSERT INTO uspNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","María Magdalena xcan chi' jul lamas xmuksajwi' Kakaj Jesús, re sub'laj tijcamsaj rib' chi ok'ej y cuando tijin chi ok'ej, xtacar chi rilic li jul lamas xmuksajwi' Kakaj Jesús ");
INSERT INTO uspNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","y xril quib' anjl cojol saklaj itz'ik jwi'lak cub'ultakch li jul lamas xye'sajwi' jcamnakl Kakaj Jesús. Jun cub'ul lamas xwa'xwi' jb'a y jun chic cub'ul lamas xwa'xwi' rakan. ");
INSERT INTO uspNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Xpetak yak anjl li, xtz'onajtak re María Magdalena: Chuch, ¿nen tawok'aj? xche'tak re. Y María Magdalena xij rechak: Inok' jwi'l xc'amsajb'i jcamnakl Kakaj Jesús ri Wajawl y ta' wetam lamas xye'sajwi', xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Cuando xijmaj jilonli jwi'l, xsolcopij rib', ri'chak xril Kakaj Jesús wi' chirij, pero re ta' xch'ob' jwich wi ri' Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Xpe Kakaj Jesús, xtz'onaj re: Chuch, ¿nen tawok'aj? ¿Nen tatoc? xche' re. Pero María Magdalena ta' xch'ob' jwich, ri' chijch'ol re ri' man ajchajal tico'n ri xch'ab'en re, xij re: Kaj, wi at xatc'amowb'i jcamnakl Kakaj Jesús, b'ij chwe lamas xaye'w pire tanc'amb'ic, xche' re. ");
INSERT INTO uspNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Ajruc're' Kakaj Jesús xij: ¡María! xche' re. María Magdalena, cuando xta chi jilonli xijsaj re, xna'tun riq'uil y xij re li tzijb'al hebreo: ¡Raboni! xche' re. (Ri jcholajl tielwi' man yoloj raboni, ajtijonl.) ");
INSERT INTO uspNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Kakaj Jesús xij re: Mina chapow, jwi'l in ajqui' injaw riq'ui Inkaj lecj. Jat, b'ijta rechak yak ink'un chi injawi' riq'ui Inkaj lecj ri Akajak, inDios y aDiosak, xche' re. ");
INSERT INTO uspNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Ajruc're' xpe María Magdalena, xe' jb'ij rechak yak ajtijol rib'ak chirij Kakaj Jesucristo chi re xrila' jwich Kakaj Jesús ri Kajawl y xij rechak nen xijsajch re. ");
INSERT INTO uspNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Y la' man k'ij li ri man nab'e k'ij re xuman cuando xoc ak'ab', yak ajtijol rib'ak chirij Kakaj Jesucristo xmulb'a' rib'ak la ja, xtz'apijtak mak pwert y xtoxajtak rij jwi'l jtzakic jch'olak chiwchak mak jb'ab'alak yak rijajl Israel. Etke xwab'a' rib' Kakaj Jesús chiwchak y xc'am rutzil jwichak, xij rechak: Wa'xok utzil laj awanmak, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Y cuando xijmaj jilonli jwi'l rechak, ajruc're' xc'ut jk'ab' pach jxucul chiwchak. Y rechak sub'laj xqui'cottak jwi'l xriltak chi ri' Kakaj Jesús ri Kajawl. ");
INSERT INTO uspNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Kakaj Jesús xij chic rechak: Chwaj chi tiwa'x utzil laj awanmak. Chapca' intakicch in xan Kakaj Dios jilon atakicak tamb'an in chi jb'anic lawi' raj Kakaj Dios tab'antak, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Xrub'ej chib'ak y xij rechak: C'ultak Lok'laj Jsantil Kakaj Dios. ");
INSERT INTO uspNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Wi atak tacuytak jmac jun cristian, ticuysaji' jmac jwi'l Kakaj Dios, pero wi atak ta' tacuytak jmac jun cristian, ta' ticuysaj jmac jwi'l Kakaj Dios, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Tomás ri xcojsaj jb'ij pi Dídimo, jun rechak yak cab'lajuj (12) ajtijol rib'ak chirij Kakaj Jesucristo ri ta' chijxo'lak cuando xtaw Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Xpetak yak nic'j ajtijol rib'ak chirij Kakaj Jesucristo, xijtak re: Xkila' jwich Kakaj Jesús ri Kajawl, xche'tak re. Tomás xij rechak yak nic'j: Wi ta' twil la' b'ak' inwch jjulel mak clawx laj jpam jk'ab' y wi ta' tancoj jb'a ink'b' xilj y wi ta' tancoj ink'b' li man jul laj jxucul, ta' tancoj chi ri' Kakaj Jesús, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Chi waxakib' (8) k'ij chic li yak ajtijol rib'ak chirij Kakaj Jesucristo mulb'em chic rib'ak juntir rib'ilak li jun ja y la' man k'ij li wi' Tomás chijxo'lak y tz'apil mak pwert jwi'lak. Kakaj Jesús etke xwab'a' rib' chiwchak y xc'am rutzil jwichak, xij rechak: Chwaj chi tiwa'x utzil laj awanmak, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Y xij re Tomás: Coj jb'a ak'b' neri laj jpam ink'b' y il jpam ink'b'. C'amch ak'b', coj li man jul laj inxucul. Can ye' jchomorsaj chi ta' tz'et xc'astasaj inwch laj incamnakl. ¡Lajori coj chi tz'eti'n! xche' re. ");
INSERT INTO uspNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Ajruc're' Tomás cow xch'a'wc, xij re: ¡At Wajawl y at inDios! xche' re. ");
INSERT INTO uspNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Kakaj Jesús xij chic re: Tomás lajori xacoja' chi tz'eti' xc'astasaj inwch laj incamnakl jwi'l xawilna inwch. Pero tzi rechak yak ri xcojtak chi tz'eti' xc'astasaj inwch laj incamnakl onque ta' xriltak inwch, xche' re. ");
INSERT INTO uspNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Kakaj Jesús xana' chiqui' sub'laj q'ui c'utb'i jcwinel Kakaj Dios chiwchak yak ajtijol rib'ak chirij, pero ta' chiqui' tz'ib'al li man wuj ri. ");
INSERT INTO uspNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Pero lawi' ri tz'ib'al li man wuj ri, tz'ib'ali' pire tacojtak chi Kakaj Jesús ri' ri b'il jwi'l Kakaj Dios chi tina jtaknach wich ulew, ri Jc'ajol Kakaj Dios y ticub'ar ach'olak chirij pire tata'tak tzilaj c'aslemal riq'ui Kakaj Dios lecj ri jq'uisic. ");
INSERT INTO uspNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Kakaj Jesús etke xwab'a' chic rib' chiwchak yak wukub' (7) ajtijol rib'ak chirij chi' nimlaj alagun ri jb'ij Tiberias y jilonri rilic Kakaj Jesús xantak. ");
INSERT INTO uspNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Cuando c'amem rib'ak Simón Pedro, Tomás ri xcojsaj jb'ij pi Dídimo, Natanael ri aj Caná re Galilea, yak jc'ajol Zebedeo y quib' chic yak ajtijol rib'ak chic chirij Kakaj Jesús, ");
INSERT INTO uspNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","xpe Simón Pedro, xij rechak: Imb'i' chi chapoj car, xche' rechak. Y rechak xijtak re Pedro: Oj ojb'i' chawij, xche'tak re. Xjawtakb'i li jun barc xe'tak, pero man ak'ab' li ta' ni jun car xchaptak. ");
INSERT INTO uspNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Cuando xsakarsanc, Kakaj Jesús wa'lchak chi' nimlaj alagun, pero yak ajtijol rib'ak chirij ta' retamak wi ri' re. ");
INSERT INTO uspNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Re cow xch'a'wc, xtz'onajb'i rechak yak ajtijol rib'ak chirij: Atak winak, ¿wonchak car chapal awi'lak? xche'b'i rechak. Rechak xijtak re: Ta'n, xche'tak re. ");
INSERT INTO uspNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Kakaj Jesús xij chic rechak: T'ojtak chic ac'aatak laj jpaach man abarcak, xche'b'i rechak. Y rechak xt'ojtak chic man jc'aatak laj jpaach man barc. Cuando xoctak chi resaj man jc'aatak li ja' ta' chiqui' ticwintak chi resaj jwi'l ralal sub'laj car. ");
INSERT INTO uspNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Xpe man jun ajtijol rib' chirij Kakaj Jesús ri sub'laj tilok'aj jwi'l Kakaj Jesús, xij re Pedro: ¡Ri' Kakaj Jesús ri Kajawl! xche' re. Xike xta Simón Pedro chi ri' Kakaj Jesús ri Kajawl, re laj or xcoj ritz'ik chirij y xximb'ic, jwi'l xike jpam ritz'ik cojol jwi'l y xt'ojb'i rib' li ja' pire tielb'i chi' ja'. ");
INSERT INTO uspNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Yak nic'j ajtijol rib'ak chirij Kakaj Jesucristo xc'amtaknab'i man barc asta chi' ja' y juralb'i man c'aat jwi'lak nojsal chi car. Y raj wi' jun cient (100) metro ajqui' chi eltakb'i li ja'. ");
INSERT INTO uspNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Cuando xeltakb'i li ja' xe' jte'tak jun k'ak' ri wi' richak y wi' jun car chib' pach cuxlanwa. ");
INSERT INTO uspNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Xpe Kakaj Jesús, xij rechak: C'amtakch nic'j car ri ajri' xachaptakch, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Simón Pedro xjaw li man barc, xe' jurajch man c'aat re chapb'i car asta xresajch chi' nimlaj alagun y man c'aat nojsali' chi jun cient riq'ui ca'winak oxlajuj (153) chi nimaktak car, pero man c'aat ta' xk'atzmaj jwi'l ralal mak car ri wi' xilj. ");
INSERT INTO uspNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Kakaj Jesús xij rechak: Tzajtak, b'an adesayunak, xche' rechak. Pero ni jono rechak yak ajtijol rib'ak chirij xtz'onin re nen chi cristian lal re, jwi'l retamakchak chi ri' Kakaj Jesús ri Kajawl. ");
INSERT INTO uspNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Kakaj Jesús xc'am cuxlanwa y xye' rechak chi tijem y jilon xan re man car. ");
INSERT INTO uspNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Ri' li roxmul b'welt xilsaj jwich Kakaj Jesús jwi'lak yak ajtijol rib'ak chirij cuando jorok c'astasaji' jwich laj jcamnakl xo'lak camnakib'. ");
INSERT INTO uspNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Cuando xcolajtak wic', Kakaj Jesús xtz'onaj re Simón Pedro: Simón, jc'ajol Juan, ¿inalok'ajni' mas in chiwchak yak nic'j winak ri? xche' re. Simón Pedro xij re: Wajawl, awetami' chi in chwaji' awch, xche' re. Kakaj Jesús xij chic re: Chajaj tral incarner, xche' re. ");
INSERT INTO uspNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Y xij chic jca'mul re: Simón, jc'ajol Juan, ¿inalok'ajni'n? xche' re. Simón Pedro xij chic re: Awetami' chi chwaji' awch, xche' chic re. Kakaj Jesús xij chic re: Chajaj tral incarner, xche' chic re. ");
INSERT INTO uspNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Y xij chic roxmul re: Simón, jc'ajol Juan, ¿chawajni' inwch? xche' re. Pedro laj or xpe jun c'ax laj ranm jwi'l chi roxmulchak titz'onaj re wi raji' jwich Kakaj Jesús, re xij chic: Wajawl, at awetami' juntir y awetami' chi chwaji' awch, xche' re. Kakaj Jesús xij chic re: Chajaj tral incarner. ");
INSERT INTO uspNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Kes tz'etel tz'et tamb'ij chawe, cuando aj ati' c'ojol winak at tacoj awitz'ik chawij y atb'i' lamas chawaj atb'e'w. Pero cuando atri'jab'c, xichak tatelej atelb' y jalanchak ticojow awitz'ik chawij y atjc'amtakb'i lamas ta' chawaj atb'e'w, xche' re. ");
INSERT INTO uspNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Kakaj Jesús xij jilonli re Pedro chi resaj chi sakil nen chi camic tioc re Pedro y jwi'l jcamic li tijnimirsaj jk'ij Kakaj Dios. Cuando xijmaj re Pedro jwi'l jilonli, xij chic re: ¡Xamb'eren chwij! xche' re. ");
INSERT INTO uspNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Simón Pedro b'esal chirij Kakaj Jesús xna'tun chirij, ri'chak xril man jun ajtijol rib' chirij Kakaj Jesús ri sub'laj tilok'aj jwi'l Kakaj Jesús b'esali' chirijak. Ri' re ri xtzalb'a'b'i rib' laj jxuct Kakaj Jesús cuando xwi'ntak re sinar y xin re Kakaj Jesús jilonri: Wajawl, ¿nen atjachow pi camic? xche' re. ");
INSERT INTO uspNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Pedro, cuando xril chi b'esali' chirijak, xij re Kakaj Jesús: Wajawl, ruc' jun ri, ¿nen tib'an re? xche' re. ");
INSERT INTO uspNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Kakaj Jesús xij re: Wi chwaj in aj yo'lna re cuando ink'aj chicch y at, ¿nen acwent re? At, xamb'eren chwij, xche' re. ");
INSERT INTO uspNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Xel jtaquil chijxo'lak juntir yak ajtakeltak re Kakaj Jesucristo chi man ajtijol rib' li ri sub'laj tilok'aj jwi'l Kakaj Jesús ta' ticamc, pero Kakaj Jesús ta' xij chi ta' ticamc, re xike xij jilonri: Wi chwaj in aj yo'lna re cuando ink'aj chicch y at, ¿nen acwent re? xche' Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Y ri' man jun ajtijol rib' li chirij Kakaj Jesucristo tib'in jcholajl juntir ri ilan jwi'l y juntir li xtz'ib'aji'n. Y ketami' chi juntir ri tijb'ij re tz'etel tz'eti'n. ");
INSERT INTO uspNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Ajwi' mas ri xan Kakaj Jesús ri ta' tz'ib'al li man wuj ri. Y witi xtz'ib'aj chi jujunal ri xan Kakaj Jesús, tamb'ij in, ta' chiqui' titz'akat mak wuj neri wich ulew ri lamas titz'ib'ajwi'.");
INSERT INTO uspNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","At wichc'ulchi' Teófilo, li nab'e inwuj ri xintz'ib'ajb'i pi awe, xintz'ib'aji' juntir ri b'analch jwi'l Kakaj Jesús y juntir tijon ri xan cuando xwa'x neri wich ulew ");
INSERT INTO uspNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","asta cuando xc'amsajb'i lecj jwi'l Kakaj Dios. Cuando ajqui' chi c'amsajb'i lecj, la' jcwinel Lok'laj Jsantil Kakaj Dios xcan jb'ij rechak yak jtako'n ri cha'l jwi'l chi trantak lawi' raj Kakaj Dios trantak. ");
INSERT INTO uspNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Chiwch ca'winak (40) k'ij cuando jorok c'astasaji' jwich Kakaj Jesús laj jcamnakl, q'uilaj b'welt xilsaj jwich pi cristianil jwi'lak yak jtako'n chi jc'utic chi kes tz'etel tz'et xc'astasaji' jwich laj jcamnakl. Y Kakaj Jesús xij rechak nen mo titakon Kakaj Dios chib'ak juntir cristian. ");
INSERT INTO uspNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Cuando ajwi' Kakaj Jesús riq'uilak, xij rechak: Mat eltaknab'i Jerusalén, ulb'ejtakna, tiye'saj Lok'laj Jsantil Kakaj Dios chawechak ri b'il jwi'l Kakaj Dios chapca' ximb'ij chawechak. ");
INSERT INTO uspNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Tz'eti'n, Juan Ajb'anal Ja'tiox xana' ja'tiox rechak cristian la' ja'. Pero atak pi quib' uxib' k'ij tina b'ansajna ja'tiox chawechak la' Lok'laj Jsantil Kakaj Dios, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Y yak jtako'n Kakaj Jesucristo ri mulb'em rib'ak riq'uil, xtz'onajtak re: Kajawl, ¿roni' k'ij ri tawesaj k'atb'itzij laj jk'ab'ak yak ri ma' kawinaktak ta'n y tajach k'atb'itzij laj kak'b' oj ri oj rijajl Israel? xche'tak re. ");
INSERT INTO uspNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Kakaj Jesús xij rechak: Atak ta' ye'l luwar chawechak tawetemajtak, xike Kakaj Dios retam nen or tran ri chomorsal jwi'l y xike re wi' k'atb'itzij laj jk'ab' chi jb'anic y atak ta' ye'l luwar chawechak tawetemajtak. ");
INSERT INTO uspNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Pero cuando tac'ultak Lok'laj Jsantil Kakaj Dios laj awanmak, ajruc're' tiye'saj acwinelak pire ateltak chi jb'ij li tilmit Jerusalén, juntir luwar re Judea, Samaria y juntir luwar re wich ulew chi kes tz'et xawila'taka' juntir ri ximb'an, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Xantaj jb'ij rechak jilonli jwi'l Kakaj Jesús, xc'amsajb'i lecj jwi'l Kakaj Dios chiwchak y xch'uksajb'i rij jwi'l jun sutz'. ");
INSERT INTO uspNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Y aj tijintaka' chi rilic nen mo jawic Kakaj Jesús lecj, etke xriltak wa'lchak quib' winak chijc'ulelak, sub'laj sak ritz'ikak. ");
INSERT INTO uspNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Y yak quib' winak li xijtak rechak: Atak winak aj Galilea, ¿nen tawiltak lecj? Kakaj Jesús ri xwa'x chaxo'lak ri xc'amsajb'i lecj, tina pena chic. Nen mo jb'ic cuando xe' lecj, jilon jpetic cuando tipe chic, xche'tak rechak. ");
INSERT INTO uspNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Yak jtako'n Kakaj Jesucristo xeltakch b'a witz ri jb'ij Olivos, xk'ajtak Jerusalén. B'a witz ri jb'ij Olivos raj wi' jun kilometro jnajtil re Jerusalén, ji'ke jnajtil chapca' jnajtil b'e ri ye'l luwar tib'emb'ej lak k'ij re uxlan chapca' tijb'ij Jpixb' Kakaj Dios. ");
INSERT INTO uspNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Cuando xtawtak Jerusalén, xjawtak laj jcab' wik re man ja lamas wi' jposadak. Yak ri xjawtak laj jcab' wik re man ja, ri'taka' Pedro, Juan, Santiago, Andrés, Felipe, Tomás, Bartolomé, Mateo, Santiago ri jc'ajol Alfeo, Simón ri tib'ijsaj Zelote re y Judas ri jc'ajol Santiago. ");
INSERT INTO uspNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Juntir rib'ilak tijmulb'a' rib'ak chi ch'a'wem riq'ui Kakaj Dios pach yak jk'un Kakaj Jesús, María ri jchuch Kakaj Jesús y nic'j anm chic. ");
INSERT INTO uspNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","La' mak k'ij li xmulb'a' rib'ak sub'laj ajtakeltak re Kakaj Jesucristo, raj wi'taka' jun cient pach junwinak (120) chi cristian ri xmulb'a' rib'ak. Xpe Pedro, xwa'r laj xo'lak, xij rechak jilonri: ");
INSERT INTO uspNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","Atak wech'elxic chirij Kakaj Jesucristo, awetamaki' chi lajori xtawi' chiwch juntir ri b'il jwi'l Lok'laj Jsantil Kakaj Dios chirij Judas ri xcan jtz'ib'aj David li wuj re Lok'laj Jyolj Kakaj Dios ri tijb'ij chirij Judas ri xc'amow jb'eak mak ri xtawtak chi jchapic Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Judas kapachi'n y ri' jun chi chac chikaxo'l. ");
INSERT INTO uspNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Xpe Judas, xlok' jun q'uer ulew la' man pwak ri jtojb'l ri xye'saj re jwi'l man etzl no'j ri xan. Xantaj li jwi'l, xtzaak pi xulan jb'a lak ulew, xpax jch'ol y xelch juntir rixcolb'. ");
INSERT INTO uspNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Juntir cristian Jerusalén xtatak jtaquil chirij Judas, xcojtak jb'ij man ulew pi Acéldama. Ri jcholajl tielwi' man yoloj Acéldama, luwar lamas xtix jquiq'uel camnak. ");
INSERT INTO uspNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Jwi'l tz'ib'ali' li wuj re Salmos ri tijb'ij jilonri: Rulew tican chi ta' chiqui' rajw, ta' chiqui' ni jonok tiwa'x chiwch. Y jalanchak tioc pi jq'uexwach, tiche', xche' Pedro rechak. ");
INSERT INTO uspNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Y Pedro xij chic: Lajori rajwaxi' ticha'saj jun rechak yak cristian ri xojjpachijtak cuando xwo'cot Kakaj Jesús ri Kajawl chikaxo'l ");
INSERT INTO uspNT_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","y cuando xansaj ja'tiox re jwi'l Juan Ajb'anal Ja'tiox asta cuando xc'amsajb'i lecj. Rajwaxi' jun rechak yak ri xiliwtak re juntir li tioc pi jq'uexwach Judas, pire tiwa'x laj kaxo'l chi jb'ij chi kes tz'eti' xc'astasaji' jwich Kakaj Jesús laj jcamnakl, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Ajruc're' yak ri mulb'em rib'ak cla' xcha'tak quib', xk'asajtak chijxo'lak. Yak quib' ri xcha'tak, ri'taka' José ri tib'ijsaj Barsabás y tib'ijsaj Justo re, pach Matías. ");
INSERT INTO uspNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Ajruc're' xch'a'wtak riq'ui Kakaj Dios, xijtak: Kajawl, at awetami' nen wi' laj ranmak juntir cristian. C'ut chikawch nen rechak yak quib' ri, ri cha'l awi'l ");
INSERT INTO uspNT_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","pire tioc pi tako'n chikaxo'l pi jq'uexwach Judas ri xkej li mac, ri xe' li man luwar ri tosol pire re, xche'tak. ");
INSERT INTO uspNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Ajruc're' xoctak chi jtzakic suert chirijak chi rilic nen rechak yak quib' tican pi jq'uexwach Judas y ri' Matías xcanc. Jilonli Matías wi'chak laj rajlalak yak junlajuj (11) chi jtako'n Kakaj Jesucristo. ");
INSERT INTO uspNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Cuando xtaw nimak'ij Pentecostés, juntir yak ajtakeltak re Kakaj Jesucristo c'amem rib'ak li jun ja. ");
INSERT INTO uspNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Etke xtatak jun kelen tijumum petzal lecj chapca' jtaic jun quiek'ek' tew y sub'laj xjumum la ja lamas cub'ultak. ");
INSERT INTO uspNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Ajruc're' chirib'il rib'ak xriltak nic'j kelen ri chapca' rilic jxak k'ak' xkej chib'ak chi jujunalak. ");
INSERT INTO uspNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Y juntir rib'ilak xnojsaj ranmak la' Lok'laj Jsantil Kakaj Dios y etke xretemajtak jaljojtak tzijb'al, tichak yolowtak lak jaljojtak tzijb'al chi jujunalak chapca' ri xye'saj rechak jwi'l Lok'laj Jsantil Kakaj Dios. ");
INSERT INTO uspNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Y la' mak k'ij re man nimak'ij li ri xaan li tilmit Jerusalén, wi'taka' sub'laj q'ui yak rijajl Israel ri tijcojtak Jpixb' Kakaj Dios jekeltak cla' ri tipetak lak juntir tilmit. ");
INSERT INTO uspNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Rechak, cuando xtatak xjumum lecj, xmulb'a' rib'ak riq'uilak yak ajtakeltak re Kakaj Jesucristo. Y sub'laj xsaach jch'olak jwi'l chi jujunalak yak ajtakeltak re Kakaj Jesucristo tichak ch'a'wtak laj jtzijb'alak chi jujunalak, ");
INSERT INTO uspNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","jilonli sub'laj xsaach jch'olak y xijtak chirib'il rib'ak jilonri: Mak cristian ri tijin tich'a'wtak aj Galileataka'n. ");
INSERT INTO uspNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","¿Nen mo ticwintak chi yoloj laj katzijb'al ri xojq'uiywi'ch chi kajujunal? ");
INSERT INTO uspNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Chikaxo'l neri wi'taka' cristian aj Partia, aj Media, aj Elam, aj Mesopotamia, aj Judea, aj Capadocia, aj Ponto, aj Asia, ");
INSERT INTO uspNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","aj Frigia, aj Panfilia, aj Egipto, yak ri tipetak lak luwar re Libia chi nakaj re Cirene, aj Roma, ");
INSERT INTO uspNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","wi' jujun rijajltaka' Israel, wi' jujun ri ma' rijajltak ta' Israel, pero xcoja'taka' Jpixb' Kakaj Dios, wi'taka' aj Creta y aj Arabia. Oj juntir laj katzijb'al tijb'ijtakwi' chike juntir ri kus jtaic ri xan Kakaj Dios, xche'tak chirib'il rib'ak. ");
INSERT INTO uspNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Juntir sachal jch'olak jwi'l ta' retamak jcholajl nen tijb'ijtak, xoctak chi jtz'onaj chirib'il rib'ak: ¿Nen chiqui' jcholajl li? xche'tak. ");
INSERT INTO uspNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Pero nic'j chic xtze'jtake y xijtak: K'ab'reltaka'n, xche'tak chirijak yak ajtakeltak re Kakaj Jesucristo. ");
INSERT INTO uspNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Ajruc're' xpe Pedro, xwa'r chijxo'lak yak junlajuj (11) jtako'n Kakaj Jesucristo, cow xch'a'wc, xij rechak juntir cristian: Atak rijajl Israel ri inwinak y juntir ri watak Jerusalén, tatak, tamb'ij jcholajl chawechak. ");
INSERT INTO uspNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Yak winak ri ta' k'ab'reltak chapca' tab'ijtak, lajori aj ak'ab'i'n, ajri'ne' b'elejeb' (9) or re ak'ab'. ");
INSERT INTO uspNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Ri' ri xtaw chiwch ri xcan jb'ij Joel ri ajk'asal Jyolj Kakaj Dios ri tijb'ij jilonri: ");
INSERT INTO uspNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Lak q'uisb'itak k'ij re jwich k'ijsak, Kakaj Dios xij jilonri: Tina intaknab'i Insantil chib'ak juntir cristian. Arab'inak y ac'ajolak tina jk'asajtakna Inyolj rechak cristian. Y yak winak ri ajqui' mas ri'jtak tina riltakna ri tanc'ut chiwchak, yak ri'jtaklaj cristian tina riltakna laj richc'ak ri tanc'ut chiwchak. ");
INSERT INTO uspNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Y la' mak k'ij li tantakch Insantil chib'ak, chi anm chi winak tik'asintak Inyolj. ");
INSERT INTO uspNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Lecj y wich ulew tina imb'anna kelen ri sachom ch'olal rilic, tina imb'anna c'utb'i incwinel y tina inc'utna quic', k'ak' y tib'ukuk sib'. ");
INSERT INTO uspNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","K'ij tina uku'marna jwich y tran quiek jwich ic' chapca' quic'. Ri' li retal tiilsaj nab'e, ajruc're' titaw k'ij tipet Kajawl, ri' jun k'ij li sub'laj nim jk'ij. ");
INSERT INTO uspNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Y juntir ri tich'a'wtak riq'ui Rajawl wi tijtz'onajtak re chi ticolsajtak, ticolsajtaka'n, xche' Kakaj Dios, xche' Joel, xche' Pedro rechak. ");
INSERT INTO uspNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Pedro xij chic rechak: Atak aj Israel, tatak jcholajl nen tamb'ij chawechak. Kakaj Jesús aj Nazaret xan nimaktak c'utb'i jcwinel Kakaj Dios y xan kelen sachom ch'olal rilic chaxo'lak. Ri' li retal xan chawchak pi c'utb'ire chi Kakaj Diosi' takowinakch re chaxo'lak y atak xawetemajtaka' chi re tz'etel tz'et Kakaj Diosi' takowinakch re. ");
INSERT INTO uspNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Pero atak, cuando xjachsaj Kakaj Jesús laj ak'b'ak, atak xachaptak y xajachtak laj jk'ab'ak mak cristian ri etzl jno'jak pire xcamsajtak wich curs. Jilon xab'antak re chapca' jchomorsa'n Kakaj Dios chirij ojrtaktzij. ");
INSERT INTO uspNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Onque jilonli xab'antak re Kakaj Jesús, xpe Kakaj Dios xresaj laj jk'ab' camic y xc'astasaj jwich laj jcamnakl xo'lak camnakib', jwi'l man camic ta' ticwin chirij. ");
INSERT INTO uspNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","David xij chirij Kakaj Jesús ojr jilonri: In coc'xo'l twil jwich Wajawl jwi'l re wi' laj impaach chi lak'j chi lak'ab' pire ma' tanquib'aj wanm. ");
INSERT INTO uspNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Jwi'li'li jor tiqui'cot wanm y imb'ixan jwi'l inqui'cotem y cuando incamc, cub'uli' inch'ol chi ta' tib'e intije' c'ax, li uxlani' tib'e'w wanm ");
INSERT INTO uspNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","jwi'l at, ma' kus ta'ke chawe tican insantil li man luwar lamas tic'olsaj jsantilak camnakib', ni ta' taye' luwar tik'a'y jtio'jl lok'laj atako'n. ");
INSERT INTO uspNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Xac'uta' b'e chinwch re tzilaj c'aslemal y wi' jun qui'cotemal laj wanm jwi'l wati' wiq'uil, xche' David chirij Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Pero in tz'etel tz'et tamb'ij chawechak atak inwinak ri ojtak rijajl Israel chi kamam David xcami'n, xmuksaji'n y aj na'li' lajori lamas xmuksajwi'. ");
INSERT INTO uspNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","David ajk'asal Jyolji' Kakaj Dios y re retami' chi b'ili' jwi'l Kakaj Dios chi kes tz'et re tina jcha'na jun rechak yak rijajl pire tijye' takon laj jk'ab' chapca' takon ri xwa'x laj jk'ab' re. ");
INSERT INTO uspNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","David cuando xijch ojr chapca' chi taem tichak tijin chi rilic ri xij chirij ri b'il jwi'l Kakaj Dios chi tina jtaknach wich ulew chi tina c'astasajna jwich laj jcamnakl y ta' tican jsantil li man luwar lamas tic'olsaj jsantilak camnakib' y xij chi ta' tijye' luwar tik'a'y jtio'jl li ulew. ");
INSERT INTO uspNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Ri' Kakaj Jesús li ri xc'astasaj jwich laj jcamnakl jwi'l Kakaj Dios y oj juntir xkila' chi tz'eti' xc'astasaji' jwich laj jcamnakl. ");
INSERT INTO uspNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Kakaj Dios xc'amb'i Kakaj Jesús lecj pire xcub'a' laj jpaach. Y xye' Lok'laj Jsantil re chapca' ri b'il jwi'l pire tijtakch chikab' ojtak juntir y ri' li ri attijintak chi rilic y attijintak chi jtaic lajori. ");
INSERT INTO uspNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Ma' ri' ta' David ri xe' lecj, pero ri' re xin chirij Kakaj Jesucristo jilonri: Kakaj Dios ri Kajawl xiji' re Wajawl: Cub'ren laj impaach asta ");
INSERT INTO uspNT_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","tina injachna laj ak'b' yak ri atcontrinc, xche' Kakaj Dios re, xche' David. ");
INSERT INTO uspNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Atak juntir rijajl Israel, etemajtak chi tz'etel tz'et Kakaj Jesús ri Kajawl ri xataktak jcamsaj wich curs, xye'saji' rekle'n pire titakon chib'ak juntir cristian y ri' re ri b'il jwi'l Kakaj Dios chi tina jtaknach wich ulew, xche' Pedro rechak. ");
INSERT INTO uspNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Cuando xtatak mak cristian chi jilon xijsaj rechak, xc'axc'ob' laj ranmak, xtz'onajtak re Pedro y rechak yak nic'j jtako'n Kakaj Jesucristo: Atak kawinak, ¿nen rajwax tikab'an lajori? xche'tak. ");
INSERT INTO uspNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Xpe Pedro, xij chic rechak: Lajori q'uex ano'jak y c'am jk'ab'al amacak chiwch Kakaj Dios pire ticuysaj amacak y tib'ansaj ja'tiox chawechak chi ajujunalak laj jb'ij Kakaj Jesucristo y Kakaj Dios tijya' Lok'laj Jsantil chawechak. ");
INSERT INTO uspNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Ri' li ri b'il jwi'l chi tina jye'na chawechak y tina ye'sajna re awalc'walak y tina ye'sajna rechak yak ri wi'tak chinaj y rechak juntir yak ri tisiq'uijtak jwi'l Kakaj Dios ri Kajawl pire tiwa'xtak riq'uil, xche' Pedro rechak. ");
INSERT INTO uspNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Pedro xij chic nic'j yoloj rechak chi jtijojcak y chi jye'ic jno'jak: Col ayb'ak re jk'atb'itzij Kakaj Dios ri tran chib'ak mak cristian ri wi'tak re mak junab' ri, ri tib'anowtak mak etzltak no'j, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Y jilonli yak ri xcojowtak tzilaj jtaquil chirij Kakaj Jesucristo ri xij Pedro, xansaj ja'tiox rechak. La' man k'ij li sub'laj xq'uiyantak yak ajtakeltak re Kakaj Jesucristo, raj xoctaka' uxib' mil (3,000) chi cristian chijxo'lak yak ajtakeltak re Kakaj Jesucristo. ");
INSERT INTO uspNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Y juntir rib'ilak, nojel ranmak chi jcojic ri tib'ijsaj rechak jwi'lak yak jtako'n Kakaj Jesucristo y juntir nic' jwichak. Tijc'am rib'ak chi ch'a'wem riq'ui Kakaj Dios y juntir tijmulb'a' rib'ak chi wic'. ");
INSERT INTO uspNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Juntir cristian sub'laj xsaach jch'olak chi rilic nimaktak c'utb'i jcwinel Kakaj Dios ri xansaj chiwchak jwi'lak yak jtako'n Kakaj Jesucristo. ");
INSERT INTO uspNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Juntir yak ri xjach rib'ak laj jk'ab' Kakaj Jesucristo nic' jwichak y xjach chiwchak juntir kelen rechak chirib'il rib'ak. ");
INSERT INTO uspNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Tijc'ayaj rulewak y juntir kelen rechak y tijjachtak man pwak li chiwchak pire tijlok'tak kelen ri rajwax rechak chi jujunalak. ");
INSERT INTO uspNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Nojel k'ij tijmulb'a' rib'ak li nimi richoch Kakaj Dios chi jnimirsaj jk'ij Kakaj Dios y tijmulb'a' rib'ak laj richochak chirib'il rib'ak y trantak comon wic'. Tijjach jwaak chiwchak chirib'il rib'ak pi qui'cotemal y ta' ni jun tiq'uixib' chiwch jun chic, jwi'l ta' ni jono rechak tijcoj jk'ij chiwch jun chic. ");
INSERT INTO uspNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Rechak tib'ixantak chi jnimirsaj jk'ij Kakaj Dios y jor tzi tiilsajtak jwi'lak juntir cristian y Kakaj Dios ri Kajawl tran chi nojel k'ij tijin tiq'uiyantak yak ajtakeltak re Kakaj Jesucristo pire ticolsajtak laj jk'ab' jmacak. ");
INSERT INTO uspNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Jun k'ij Pedro pach Juan xe'tak li nimi richoch Kakaj Dios laj jrox or re b'esal k'ij, ri or re tib'an ch'a'wem riq'ui Kakaj Dios. ");
INSERT INTO uspNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Y cla' wi' jun sic' winak co'x, sic' winak li co'xchak pi relexb'al. Nojel k'ij tic'amsajb'ic, tiye'saj chi' oqueb' ri tib'ijsaj Kus re, ri man oqueb' re man tz'aak ri wi' chirij nimi richoch Kakaj Dios. Cla' tijtz'onaj limoxn rechak cristian ri tib'etak li nimi richoch Kakaj Dios. ");
INSERT INTO uspNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Y sic' co'x, cuando xril tijin tioctakb'i Pedro pach Juan chi' man oqueb' re man tz'aak li, xtz'onaj limoxn rechak. ");
INSERT INTO uspNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Rechak cow xriltak, xpe Pedro, xij re: Ojawile', xche' re. ");
INSERT INTO uspNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Re cow xna'tun riq'uilak Pedro pach Juan, ulb'elchak jwi'l nen tiye'saj re. ");
INSERT INTO uspNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Xpe Pedro, xij re: Ta' nen tanye' chawe, ta' plata, ni oro, xike ri ye'l chwe, tanye' chawe. Lajori laj jb'ij Kakaj Jesucristo aj Nazaret, b'iiten y wo'coten, xche' re. ");
INSERT INTO uspNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Cuando xijmaj jilonli jwi'l Pedro, xchap la' jpaach jk'ab' sic' winak co'x, xb'it y etke xyuk jchok'b' jb'akel rakan. ");
INSERT INTO uspNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Y sic' winak co'x xch'opinc, xwa'rja', xchol wo'cotem y la'chak rakan xocb'i chirij Pedro y Juan li nimi richoch Kakaj Dios y tichak ch'opin chi jnimirsaj jcojic jk'ij Kakaj Dios. ");
INSERT INTO uspNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Juntir cristian ri wi'tak cla', cuando xriltak chi tichak wo'cot sic' winak y tichak tijin chi jnimirsaj jk'ij Kakaj Dios, ");
INSERT INTO uspNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","sub'laj xsaach jch'olak chi rilic nen xan sic' winak co'x, jwi'l ch'ob'oli' jwich jwi'lak y retamaki' chi ri' re ticub'ar chi jtz'onaj limoxn chi' man oqueb' ri jb'ij Kus. ");
INSERT INTO uspNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Sic' winak co'x ri xtzib'c, ta' chiqui' raj tican jye' Pedro pach Juan. Mak cristian aj sachali' jch'olak chi rilic ri xansaj, tijolin xe'tak riq'uilak Pedro pach Juan b'atz'aak re nimi richoch Kakaj Dios, la' man b'atz'aak ri cojol jb'ij pi b'atz'aak re Salomón. ");
INSERT INTO uspNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Pedro xril chi aj sachali' jch'olak yak cristian, xij rechak: Atak rijajl Israel, ¿nen chac sub'laj tisaach ach'olak? ¿Nen chac cow ojawiltak? Ri' chach'olak chi ojke xojtzib'san re winak ri la' kacwinel o jwi'lke sub'laj ojcojon chiwch Kakaj Dios xkab'an chi xwo'cotc. ");
INSERT INTO uspNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Ri jDios Abraham, Isaac, Jacob y kamam ri' li xye'w jnimal jk'ij Kakaj Jesús ri rajchac ri xajachtak laj jk'ab'ak mak k'atb'itzij. Cuando Pilato raj roj xtake', atak ta' xaye'tak luwar, ");
INSERT INTO uspNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","pi jq'uexwach xab'ijtak re Pilato chi titaksajb'i jun ri ta' jmac y suc'ul ranm chiwch Kakaj Dios, ri' chiqui' xab'ijtak chi titaksajb'i jun ajcamsanl pi jq'uexwach re. ");
INSERT INTO uspNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Atak xataktak jcamsaj Kakaj Jesús ri quiek jwi'l tikata'tak tzilaj c'aslemal. Pero Kakaj Dios xc'astasaji' jwich laj jcamnakl xo'lak camnakib'. Juntir li oj xkila'n y tijin tikab'ij lajori chi tz'eti'n. ");
INSERT INTO uspNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Winak ri, ri tach'ob'tak jwich, xtzib'i'n, pero laj jb'ijke Kakaj Jesús y jwi'l xcub'ar jch'ol chirij. Jilonli xtzib'c, xcan chapca' rilic tijin tawiltak lajori. ");
INSERT INTO uspNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Atak inwinak, in wetami' chi cuando xataktak jcamsaj Kakaj Jesús pach yak ab'ab'alak, ta' awetamak nen attijintak chi jb'anic. ");
INSERT INTO uspNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Jilonli xtaw chiwch chapca' ri b'il jwi'lak yak ajk'asaltak Jyolj Kakaj Dios ojr cuando xijtak chi tina camsajna Kakaj Jesús ri b'il jwi'l Kakaj Dios chi tina jtaknach wich ulew. ");
INSERT INTO uspNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Jwi'li'li lajori atak q'uex ano'jak, c'am jk'ab'al amacak chiwch Kakaj Dios ri Kajawl, oquentak laj jk'ab' Kakaj Dios y re tijcuya' juntir amacak ");
INSERT INTO uspNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","y Kakaj Dios ri Kajawl tijya' utzil laj awanmak jwi'l tina jtaknach Kakaj Jesucristo ri xijsaj chi tina taksajnach pi awechak. ");
INSERT INTO uspNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Lajori Kakaj Jesús wi' lecj, cla' tiwa'x asta tib'ansaj jwa'x juntir jwi'l Kakaj Dios chapca' ri b'il jwi'lak yak ajk'asaltak Jyolj ojrtaktzij. ");
INSERT INTO uspNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Moisés xiji' rechak kamam ojrtaktzij jilonri: Kakaj Dios ri Awajawlak tina jtaknach jun ajk'asal Jyolj chaxo'lak chapca' in. Re ji' tiq'uisi'y chijxo'lak yak awijajlak. Cojtak juntir nen tijb'ij chawechak. ");
INSERT INTO uspNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Y nen ri ta' tijcoj jyolj ri ajk'asal Jyolj Kakaj Dios li, tiesajb'i chijxo'lak yak jwinak Kakaj Dios pire tisachsaj jwich, xche' Moisés. ");
INSERT INTO uspNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Juntir ri tijin tamb'ij chawechak, b'ili'ch jwi'lak yak ajk'asaltak Jyolj Kakaj Dios ojrtaktzij, xcholmajch jb'ij jwi'l Samuel asta man q'uisb'i ajk'asal Jyolj Kakaj Dios. ");
INSERT INTO uspNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Atak tawechb'ejtaka' ri xijtak yak ajk'asaltak Jyolj Kakaj Dios ojrtaktzij y ri chomorsa'n ri xan Kakaj Dios riq'uilak kamam ojr cuando Kakaj Dios xij re kamam Abraham jilonri: Tina inye'na ink'b' chib'ak juntir cristian wich ulew nen or jwi'lke jun re yak awijajl, xche'. ");
INSERT INTO uspNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Kakaj Dios xc'astasaj jwich rajchac laj jcamnakl y nab'e xtak chaxo'lak pire tijye' jk'ab' chab'ak pire chi ajujunalak taq'uex ano'jak y tican aye'tak mak etzltak no'j ri tijin tab'antak pire ticuysaj amacak, xche' Pedro rechak. ");
INSERT INTO uspNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Aj tijintaka' Pedro pach Juan chi yoloj riq'uilak mak cristian cuando xtawtak yak ajc'amaltak jb'eak cristian riq'ui Kakaj Dios pach man jb'ab'alak mak ajchajaltak re nimi richoch Kakaj Dios y mak saduceo. ");
INSERT INTO uspNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Sub'laj xpe retzalak cuando xriltak chi tijintak Pedro pach Juan chi jtijoj cristian y tijin tijb'ijtak rechak chi xc'astasaji' jwich Kakaj Jesús laj jcamnakl. Ri' li tic'utuw chi tic'astasaji' jwichak camnakib'. ");
INSERT INTO uspNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Xpe rechak, xchaptak Pedro pach Juan y jwi'l b'esal k'ijchak xichak xcan jcoje'tak li cars pire tijchomorsajtak laj jcab' k'ij nen jmacak. ");
INSERT INTO uspNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Pero sub'laj cristian ri xtatak jyoljak, xjach rib'ak laj jk'ab' Kakaj Jesús y jilonli xq'uiyantak yak ajtakeltak re Kakaj Jesucristo, xike winak raj wi' job' mil (5,000) rib'ilak. ");
INSERT INTO uspNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Y laj jcab' k'ij mak jb'ab'alak y mak ajililtak jcholajl chijxo'lak yak rijajl Israel pach yak ajtijoltak cristian re Jpixb' Kakaj Dios xmulb'a' rib'ak Jerusalén. ");
INSERT INTO uspNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Y wi'taka' Anás cla' ri man nimlaj jb'ab'alak yak ajc'amaltak jb'eak cristian riq'ui Kakaj Dios, wi'taka' Caifás, Juan, Alejandro y juntir yak rech'elxicak mak nimaktak jb'ab'alak yak ajc'amaltak jb'eak cristian riq'ui Kakaj Dios. ");
INSERT INTO uspNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Xijtak chi tic'amsajtakch Pedro pach Juan riq'uilak. Cuando wi'takchak Pedro pach Juan riq'uilak, xwab'a'tak chijxo'lak y xtz'onajtak rechak: ¿Nen xatakowtak o nen quiek laj jb'ij xab'antak juntir li? xche'tak rechak. ");
INSERT INTO uspNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Y Pedro nojsali' ranm la' Lok'laj Jsantil Kakaj Dios, xij rechak: Atak b'ab'al y atak yak ajililtak jcholajl chijxo'lak yak rijajl Israel, ");
INSERT INTO uspNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","atak, wi ri' tijin tatz'onajtak chike nen xanow tok'ob' re sic' winak yaj y nen mo xtzib'wi', ");
INSERT INTO uspNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","lajori tawetemajtak atak juntir y tretemajtak juntir yak rijajl Israel chi winak ri, ri wi' kiq'uil xtzib'i'n, pero laj jb'ijke Kakaj Jesucristo aj Nazaret ri xacamsajtak wich curs y ri xc'astasaj jwich laj jcamnakl xo'lak camnakib' jwi'l Kakaj Dios. ");
INSERT INTO uspNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Kakaj Jesucristo ri' man ab'aj ri ta' xchocon awi'lak ri atak ajb'analtak ja. Pero man ab'aj li xchoconi' pire jcowil ja. ");
INSERT INTO uspNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Ta' chiqui' nen jono quiek jwi'l ojcolmajtak laj jk'ab' kamac, jwi'l Kakaj Dios ta' chiqui' tijtakch ni jono chic wich ulew ri quiek jwi'l ojcolmajtak laj jk'ab' kamac, xche' Pedro rechak. ");
INSERT INTO uspNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Mak jb'ab'alak yak rijajl Israel cuando xriltak chi Pedro pach Juan ta' titzaak jch'olak chi yoloj y xretemajtak chi ta' xtijoj rib'ak lamas xtijoj rib'ak yak ajtijonl, juntir rib'ilak xsaach jch'olak y xch'ob'tak chi ri'taka' yak ajtijol rib'ak chirij Kakaj Jesucristo. ");
INSERT INTO uspNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Y winak ri xtzib'c, wi' cla' pi jpachak, jwi'li'li rechak ta' chiqui' nen xijtak chirijak Pedro pach Juan. ");
INSERT INTO uspNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Mak jb'ab'alak yak rijajl Israel xijtak rechak chi tieltakb'i chijxo'lak. Cuando xcantak ric'anak xoctak chi jchomorsaj chirib'il rib'ak, ");
INSERT INTO uspNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","xijtak: ¿Nen tikab'an rechak mak winak ri? Juntir cristian Jerusalén xrila'taka' jun c'utb'i jcwinel Kakaj Dios ri xantak cuando xtzib'sajtak sic' winak co'x y oj ta' mo tikab'ij chi ta' tz'et. ");
INSERT INTO uspNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Pero pire ma' tiel mas jtaquil jwi'lak cristian, lajori kak'ele'tak, kab'ij rechak chi mi jcuxtajtak chic jb'ij Jesús rechak cristian, xche'tak. ");
INSERT INTO uspNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Cuando xijmaj jilonli jwi'lak, ajruc're' xsiq'uijtak Pedro pach Juan y xijtak rechak chi mi yolowtak chic y mi jtijojtak chic cristian laj jb'ij Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Pedro pach Juan xijtak rechak: Atak chomorsajtak wi pi jcholajli' ojcojon chawchak y tikaxut Kakaj Dios. ");
INSERT INTO uspNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Oj ta' tijna' tikamay jb'ij lawi' ri ilan y tal kawi'l, xche'tak rechak mak jb'ab'alak yak rijajl Israel. ");
INSERT INTO uspNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Y xpe mak jb'ab'alak yak rijajl Israel xijtak rechak chi wi mita' tican jye'tak jb'ij tzilaj jtaquil chirij Kakaj Jesucristo, tina b'ansajna c'ax rechak, ajruc're' xtaktakb'ic. Ta' xta'tak ni jono jmacak pire trantak k'atb'itzij chib'ak jwi'l juntir cristian tijintak chi jnimirsaj jk'ij Kakaj Dios jwi'l ri xantak. ");
INSERT INTO uspNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Raj wi'chak mas ca'winak (40) junb' man winak ri xtzib'saj la' jcwinel Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Cuando xtakmajtakb'i Pedro pach Juan, xe'tak chic lamas wi' yak jpachak xoctak chi jyolic rechak nen xijsaj rechak jwi'lak mak jb'ab'alak yak ajc'amaltak jb'eak cristian riq'ui Kakaj Dios y jwi'lak yak ajililtak jcholajl chijxo'lak yak rijajl Israel. ");
INSERT INTO uspNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Cuando xtatak juntir yak jpachak nen xansaj rechak, nic' xoctak chi ch'a'wem riq'ui Kakaj Dios, xijtak jilonri: At Kajawl, ati' xatb'anow caj, ulew, mar y juntir kelen ri wi' chiwchak, ");
INSERT INTO uspNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","xatak Asantil chi jk'asaj Ayolj re David ri atako'n ri xij jilonri: Ta' jcholajl tipe retzalak mak cristian wich ulew y trantak jun jchomorsa'nak ri ta' nen tichacuj. ");
INSERT INTO uspNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Mak rey re wich ulew xmol rib'ak chi jcontrij Kakaj Dios ri Kajawl pach jtako'n ri tina jtaknach wich ulew, xche'. ");
INSERT INTO uspNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Ri' li ri xantak Herodes Antipas pach Poncio Pilato, xmulb'a' rib'ak neri Jerusalén pach yak rijajl Israel y yak ma' rijajl ta' Israel chi jb'anic c'ax re Kakaj Jesús ri b'il awi'l chi tina ataknach wich ulew ri atako'n ri ta' ni jun b'welt xmacunc. ");
INSERT INTO uspNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Jilon xantak chapca' ri b'il awi'l chi tina b'anna. ");
INSERT INTO uspNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Y lajori, at Kakaj Dios ri Kajawl, il jcholajl nen tijin trantak chike y ye' jcowil kanm ri oj awajchac chi jb'ij Ayolj rechak cristian. ");
INSERT INTO uspNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","La' acwinel tzib'saj yak cristian ri yajtak y b'an c'utb'i acwinel y nimaktak retal ri sachom ch'olal rilic laj jb'ij Kakaj Jesús ri awajchac ri tosol pi awe, xche'tak re Kakaj Dios. ");
INSERT INTO uspNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Cuando xmaytak ch'a'wem riq'ui Kakaj Dios, sub'laj xquerquen man luwar lamas wi'takwi' y juntir rib'ilak xnojsaj ranmak la' Lok'laj Jsantil Kakaj Dios y wi'chak jcowil ranmak chi jb'ij Jyolj Kakaj Dios rechak cristian. ");
INSERT INTO uspNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Juntir yak ajtakeltak re Kakaj Jesucristo niq'ui' jchomorsa'nak. Juntir kelen rechak ri wi' chi jujunalak ni jonok tib'in chi rechi' ric'an, jwi'l tijcomonaji' kelen rechak chirib'il rib'ak. ");
INSERT INTO uspNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Wi' jcowil ranmak yak jtako'n Kakaj Jesucristo chi jb'ij chi tz'eti' xc'astasaji' jwich Kakaj Jesús ri Kajawl laj jcamnakl. Y Kakaj Dios xya' sub'laj rutzil ranm rechak juntir rib'ilak. ");
INSERT INTO uspNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Ni jono rechak yak ajtakeltak re Kakaj Jesucristo tijtij c'ax chi jtoquic nen rajwax re, jwi'l wi' jujun rechak tijc'ayaj rulewak o richochak ");
INSERT INTO uspNT_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","y tijjachtak man pwak li laj jk'ab'ak yak jtako'n Kakaj Jesucristo. Y yak jtako'n Kakaj Jesucristo tijjach chiwchak yak ri wi' rajwax rechak. ");
INSERT INTO uspNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Jilon xan José ri rijajl Leví ri tipe Chipre, ri xcojsaj jb'ij pi Bernabé jwi'lak yak jtako'n Kakaj Jesucristo. Ri jcholajl tielwi' man b'ij Bernabé, jc'ajol ajye'l jcowil kanm. ");
INSERT INTO uspNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Winak li wi' jun q'uer rulew xc'ayaj y xjach rijil laj jk'ab'ak yak jtako'n Kakaj Jesucristo. ");
INSERT INTO uspNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Wi' jun winak ri jb'ij Ananías y Safira jb'ij rixokl. Xpe rechak, xc'ayajtak jun q'uer rulewak. ");
INSERT INTO uspNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Pero Ananías xchomorsaj pach rixokl, xcan jmuke' nic'j pwak rijil rulewak y nic'j xjach laj jk'ab'ak yak jtako'n Kakaj Jesucristo. Xan chapca' xikeli man pwak. ");
INSERT INTO uspNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Xpe Pedro, xtz'onaj re Ananías: ¿Nen chac xaye' luwar re man jb'ab'al etzl xoc laj awanm y xab'an jo'slaj tzij chiwch Lok'laj Jsantil Kakaj Dios cuando xamuk nic'j pwak rijil awulew? ");
INSERT INTO uspNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","¿Ma' awech ta'c'u b'an man ulew ri xac'ayaj? ¿Ma' awech ta'c'u b'an man pwak? ¿Nen chac xab'an jilonli? Ma' re ta' cristian xab'an jo'slaj tzij, rechi' Kakaj Dios, xche' Pedro re Ananías. ");
INSERT INTO uspNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Cuando xijmaj jilonli re Ananías jwi'l Pedro, Ananías xtzaak lak ulew y xcamc. Y juntir yak ri xtatak jtaquil jcamic Ananías sub'laj xtzaak jch'olak chi jtaic. ");
INSERT INTO uspNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Ajruc're' xpetak nic'j c'ojolb', xpistakb'i jcamnakl li jun itz'ik, xc'amtakb'ic y xe' jmuke'tak. ");
INSERT INTO uspNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Raj uxib' orchak jb'antaj jilonli cuando xtaw chic rixokl Ananías. Re ta' retam wi xcami' richjil. ");
INSERT INTO uspNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Xpe Pedro, xtz'onaj re: B'ij chwe, ¿ji'ni'kelonri jq'uiyal pwak ri rijil awulewak ri xac'ayajtak? xche' re. Safira xij: Tz'eti'n, ji'ke jq'uiyal pwak li, xche'. ");
INSERT INTO uspNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Ajruc're' xpe Pedro, xij re: ¿Nen chac xniq'uib' awchak chi jb'anic jo'slaj tzij chiwch Lok'laj Jsantil Kakaj Dios ri Kajawl? Co'taka' yak c'ojolb' li wi'takchak chi' pwert, ajri' xyuktak xpetak chi jmukic awichjil y lajori atjc'amtak chicb'i at, xche' Pedro re. ");
INSERT INTO uspNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Cuando xijmaj jilonli re Safira, etke xtzaak lak ulew chiwch Pedro y xcamc. Y cuando xoctak chicch yak c'ojolb' ri xpetak chi jmukic Ananías, xe' jte'tak chic Safira camnakchak. Xresajtakb'ic, xe' jmuke'tak laj jxuct richjil. ");
INSERT INTO uspNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Y juntir yak ajtakeltak re Kakaj Jesucristo pach yak nic'j cristian chic, cuando xtatak jtaquil sub'laj xtzaak jch'olak. ");
INSERT INTO uspNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Sub'laj q'ui c'utb'i jcwinel Kakaj Dios xantak yak jtako'n Kakaj Jesucristo chiwchak cristian. Juntir yak ajtakeltak re Kakaj Jesucristo tijmulb'a' rib'ak b'atz'aak re nimi richoch Kakaj Dios ri cojol jb'ij pi b'atz'aak re Salomón chapca' ri nak'tisajem rib'ak. ");
INSERT INTO uspNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Juntir rechak jor tzi tiilsajtak jwi'lak cristian, pero ta' chiqui' ni jonok raj tioc riq'uilak yak ajtakeltak re Kakaj Jesucristo jwi'l jtzakic jch'olak. ");
INSERT INTO uspNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Sub'laj tijin tiq'uiyantak jwi'l sub'laj q'ui xjach rib'ak laj jk'ab' Kakaj Jesucristo. ");
INSERT INTO uspNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Y xresajtakch yak yaj, wi' xc'amtakch pach jch'atak y wi' b'ak ch'atum che'ke c'amalch jwi'lak, xyuk jye'tak lak b'e. Ri' rajak cuando tik'ax Pedro, onque jnachke tik'ax chib'ak, jujun yaj pire tican tzib'tak. ");
INSERT INTO uspNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Y sub'laj cristian ri tipetak lak jaljojtak tilmit chijc'ulel Jerusalén, tijc'amtakch jyowb'ak riq'uilak yak jtako'n Kakaj Jesucristo. Y wi' jujun ch'u'jursaltak jwi'l wi' etzl laj ranmak y juntir li xcan tzib'tak. ");
INSERT INTO uspNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Ajruc're' man nimlaj jb'ab'alak yak ajc'amaltak jb'eak cristian riq'ui Kakaj Dios pach juntir jpach, ri'taka' man k'at re mak saduceo, xti'tijtak yak jtako'n Kakaj Jesucristo, ");
INSERT INTO uspNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","xchaptak y xc'amtakb'ic, xe' jcoje'tak li man cars re tilmit. ");
INSERT INTO uspNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Y lak'ab' xtaksajch jun anjl jwi'l Kakaj Dios ri Kajawl chi jteb'aj man cars y xresaj yak jtako'n Kakaj Jesucristo li cars, xij rechak: ");
INSERT INTO uspNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","Lajori jattak li nimi richoch Kakaj Dios y b'ijtatak rechak cristian juntir nen tran Kakaj Dios chi jye'ic aac'laj c'aslemal rechak, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Jilon xantak chapca' ri xijsaj rechak jwi'l anjl. Laj jcab' k'ij xike xsakarsanc, xe'tak li nimi richoch Kakaj Dios, xoctak chi jtijoj cristian. Y ak'ab' li xpe man nimlaj jb'ab'alak yak ajc'amaltak jb'eak cristian riq'ui Kakaj Dios pach mak nic'j jpachak chic, xtaktak jsiq'uij mak comontak jb'ab'alak yak rijajl Israel y xtaktak jc'amicak yak jtako'n Kakaj Jesucristo ri wi'tak li cars. ");
INSERT INTO uspNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Pero cuando xtawtak yak ajchajaltak re nimi richoch Kakaj Dios chi jc'amicak, ta'taka' chiqui' li cars y jilonli xk'ajtak chi jb'ij rechak mak comontak jb'ab'alak yak rijajl Israel, ");
INSERT INTO uspNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","xijtak: Man cars tziyi' jtz'apij xojtawc y mak ajchajaltak re cars wi'taka' chi' pwert re cars chi chajinc, pero cuando xkateb'a' man cars, ta' chiqui' nen wi' li cars, xche'tak. ");
INSERT INTO uspNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Man jb'ab'alak mak ajchajaltak re nimi richoch Kakaj Dios pach man jb'ab'alak yak ajc'amaltak jb'eak cristian riq'ui Kakaj Dios, cuando xtatak jilonli, ta' chiqui' tijta'tak nen trantak, xijtak chirib'il rib'ak: Ta' ketam nen mo tiq'uisb'entak mak cristian li, xche'tak. ");
INSERT INTO uspNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Aj tijintaka' chi jb'ij jilonli cuando xtaw jun winak, xij rechak: Mak winak ri xacojtak li cars, wi'taka' li nimi richoch Kakaj Dios lajori, tijintaka' chi jtijoj cristian, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Ajruc're' man jb'ab'alak mak ajchajaltak re nimi richoch Kakaj Dios xe'tak pach mak jpach chi jtoquic yak jtako'n Kakaj Jesucristo. Y xe' jc'ame'takch pi utzil, ta' xantak c'ax rechak jwi'l jtzakic jch'olak pent ticamsajtak chi ab'aj jwi'lak cristian. ");
INSERT INTO uspNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Cuando xe' jc'ame'takch, xyuk jache'tak lamas mulb'emwi' rib'ak mak comontak jb'ab'alak yak rijajl Israel y xpe man nimlaj jb'ab'alak yak ajc'amaltak jb'eak cristian riq'ui Kakaj Dios, xij rechak: ");
INSERT INTO uspNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","Oj xkab'iji' chawechak chi ma tijojtak chic cristian laj jb'ij Jesús, pero atak xatcwintaka' chi jtijojcak juntir cristian Jerusalén re man c'utu'n li y tak'ab'a'tak chikij oj chi oj xojcamsan re Jesús, xche'tak rechak yak jtako'n Kakaj Jesucristo. ");
INSERT INTO uspNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Ajruc're' xpe Pedro pach yak nic'j jtako'n Kakaj Jesucristo chic, xijtak: Oj ri' mas rajwax nab'e ojcojon chiwch Kakaj Dios chiwch ojcojon chiwchak cristian. ");
INSERT INTO uspNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Ri' jDios kamam ri xc'astasan jwich Kakaj Jesús laj jcamnakl ri xacamsajtak wich curs. ");
INSERT INTO uspNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Pero Kakaj Dios xc'ama'b'i riq'uil y xe' jcub'a' laj jpaach y xcoj pi jb'ab'al y pi ajcolol rechak yak rijajl Israel pire tran chi tijq'uex jno'jak y pire ticuysaj jmacak jwi'l Kakaj Dios. ");
INSERT INTO uspNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Ri' li ri ojtijin chi jb'ij rechak cristian chi tz'eti'n y jilon Lok'laj Jsantil Kakaj Dios tijb'iji' chi tz'eti'n. Ri' Lok'laj Jsantil Kakaj Dios li tijye' Kakaj Dios rechak yak cristian ri ticojontak chiwch, xche' Pedro rechak. ");
INSERT INTO uspNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Mak comontak jb'ab'alak yak rijajl Israel cuando xtatak chi jilonli xijsaj rechak, sub'laj xpe retzalak chi jtaic y rajti ranmak roj xcamsajtak yak jtako'n Kakaj Jesucristo. ");
INSERT INTO uspNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Y chijxo'lak mak comontak jb'ab'alak yak rijajl Israel li, wi' jun fariseo ri jb'ij Gamaliel ri ajtijol cristian re Jpixb' Kakaj Dios y jor cojol jk'ij jwi'lak juntir cristian. Xpe re, xwa'r chijxo'lak, xtak resajcak junquitz yak jtako'n Kakaj Jesucristo rij ja. ");
INSERT INTO uspNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Ajruc're' xij rechak yak ri wi'tak cla': Atak rijajl Israel, iltak jcholajl nen tab'antak re yak winak ri. ");
INSERT INTO uspNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Ri' cuxtaj awi'lak nen xan Teudas ojr. Re xij chi re wi' rekle'n y jilonli sub'laj q'ui cristian xtakentak re, raj wi'taka' quejab' cient (400) chi cristian. Pero cuando xcamsaj Teudas, mak jpach ri xtakentak re xtil rib'ak, ta' chiqui' nen xantak. ");
INSERT INTO uspNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Y jilon xan Judas aj Galilea la' mak k'ij ri xesaj jtz'ib'alak juntir cristian, sub'laj q'ui cristian xtakentak re. Pero cuando xcamsaj Judas, juntir ajtijol rib'ak chirij xtil rib'ak. ");
INSERT INTO uspNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Jwi'li'li tamb'ij chawechak, wa'xtakb'a' mak winak li cla', ma coj ayb'ak chi jb'anic c'ax rechak. Wi reke cristian mak c'utu'n ri tijintak chi jc'utic, tike can pi jilonli, ");
INSERT INTO uspNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","pero wi rechi' Kakaj Dios ri c'utu'n ri tijin tijc'uttak, ta' tican jye'tak jb'ij man aac'laj c'utu'n li y ta' atcwintak chi jk'atic jwichak. Iltakna jcholajl, ma coj ayb'ak chi ch'o'j riq'ui Kakaj Dios, xche' Gamaliel rechak. Cuando xtatak mak comontak jb'ab'alak yak rijajl Israel chi jilonli xijsaj rechak, juntir rib'ilak ri' xantak lawi' ri xijsaj rechak jwi'l Gamaliel. ");
INSERT INTO uspNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Ajruc're' xtaktak chic jsiq'uijcak yak jtako'n Kakaj Jesucristo y xsec'tak chi xic'a'y y cuando xsec'maj jwi'lak, xijtak chi mi jtijojtak chic cristian laj jb'ij Kakaj Jesús, ajruc're' xtaktakb'ic. ");
INSERT INTO uspNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Yak jtako'n Kakaj Jesucristo, cuando xtaksajtak, xeltakb'i chiwchak mak comontak jb'ab'alak yak rijajl Israel, jorchak tiqui'cottak jwi'l Kakaj Diosi' xye'w luwar chi tijtijtak c'ax jwi'l Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Y rechak ta' xmaytak jtijoj cristian. Nojel k'ij tib'etak li nimi richoch Kakaj Dios y lak ja chi jtijoj y chi jb'ij tzilaj jtaquil chirij Kakaj Jesucristo rechak cristian. ");
INSERT INTO uspNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","La' mak k'ij li tijin tiq'uiyantak yak ajtakeltak re Kakaj Jesucristo y juntir rib'ilak rijajltaka' Israel. Wi' nic'j rechak tiyolowtak li tzijb'al griego y wi' nic'j chic rechak tiyolowtak li tzijb'al hebreo. Xpetak yak ri tiyolowtak li tzijb'al griego, xcojtak tzij chirijak yak ri tiyolowtak li tzijb'al hebreo chiwchak yak jtako'n Kakaj Jesucristo, xijtak chi ta' tiye'saj kelen rechak yak anm ri camnak richjilak ri tiyolowtak li tzijb'al griego cuando tijachsaj kelen nojel k'ij. ");
INSERT INTO uspNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Xpetak yak cab'lajuj (12) jtako'n Kakaj Jesucristo, xsiq'uijtak yak ajtakeltak re Kakaj Jesucristo, xijtak rechak: Ke oj ta' tijna' tikamay jtijoj cristian re Jyolj Kakaj Dios pire tikil jcholajl kelen awechak. ");
INSERT INTO uspNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Jwi'li'li atak kech'elxic chirij Kakaj Jesucristo, cha'tak chaxo'lak wukub' (7) chi tzitaklaj winak ri nojsal ranmak la' Lok'laj Jsantil Kakaj Dios y wi' mas jno'jak pire tikacojtak chi rilic jcholajl juntir kelen awechak. ");
INSERT INTO uspNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Y oj tikatakej ch'a'wem riq'ui Kakaj Dios y ta' tikamay jtijoj cristian re Jyolj Kakaj Dios, xche'tak. ");
INSERT INTO uspNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Juntir rib'ilak tziyi' xtatak, xcha'tak yak wukub' (7) winak. Xcha'tak Esteban, re sub'laj cub'ul jch'ol chirij Kakaj Jesucristo y nojsali' ranm la' Lok'laj Jsantil Kakaj Dios. Yak jpach ri'taka' Felipe, Prócoro, Nicanor, Timón, Parmenas y Nicolás aj Antioquía re Pisidia, re xoqui' pi rijajl Israel jwi'l xcoja' Jpixb' Kakaj Dios. ");
INSERT INTO uspNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Y xc'amtakb'i yak wukub' (7) winak li chiwchak yak jtako'n Kakaj Jesucristo y rechak xch'a'wtak riq'ui Kakaj Dios chirijak y xye' jk'ab'ak laj jb'aak chi jc'utic chi xye'saji' rekle'nak. ");
INSERT INTO uspNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Jilonli sub'laj tijin tiel jtaquil Jyolj Kakaj Dios y sub'laj tijin tiq'uiyantak yak ajtakeltak re Kakaj Jesucristo Jerusalén y sub'laj ajc'amaltak jb'eak cristian riq'ui Kakaj Dios xjach rib'ak laj jk'ab' Kakaj Jesucristo. ");
INSERT INTO uspNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Esteban nojsali' ranm la' rutzil ranm Kakaj Dios y la' jcwinel Kakaj Dios chi jb'anic nimaktak c'utb'i jcwinel Kakaj Dios y nimaktak retal ri sachom ch'olal rilic chiwchak cristian. ");
INSERT INTO uspNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Wi' jujun rechak yak rijajl Israel ri ta' tijcojtak Jyolj Kakaj Dios, xpetak, xoctak chi jk'atic jwich Esteban. Jujun rechak ri'taka' yak aj Cirene, aj Alejandría, aj Cilicia y aj Asia. Rechak tijmulb'a' rib'ak li jun sinagog cojol jb'ij pi Takaltakchak, jwi'l cla' tijmulb'a' rib'ak yak ri esaltakchak laj jk'ab' rajwak. ");
INSERT INTO uspNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Pero rechak ta' ticwintak chi jk'atic jwich jno'j y jcwinel Esteban jwi'l Lok'laj Jsantil Kakaj Dios ri wi' laj ranm. ");
INSERT INTO uspNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Rechak xtakchi'jtak nic'j cristian chi mukukil chi jcojic tzij chirij Esteban chi jb'ij jilonri: Xkata' cuando xyok'on chirij Moisés y chirij Kakaj Dios, xche'tak. ");
INSERT INTO uspNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Jwi'l jilonli xantak, xpetak mak cristian pach yak ajililtak jcholajl chijxo'lak yak rijajl Israel y yak ajtijoltak cristian re Jpixb' Kakaj Dios, xb'it rib'ak chirij Esteban y xchaptak, xc'amtakb'i riq'ui mak comontak jb'ab'alak yak rijajl Israel. ");
INSERT INTO uspNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Y xpetak, xtoctak chic nic'j cristian pire tijtz'akatsajtak jcojic tzij chirij Esteban ri ta' tz'et, rechak xijtak: Man winak ri, ta' tijk'el rib' chi yok'on chirij nimi richoch Kakaj Dios y chirij Jpixb' Kakaj Dios. ");
INSERT INTO uspNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Y tali' kawi'l tijb'ij chi Jesús aj Nazaret tina jyojna nimi richoch Kakaj Dios y tijq'uexa' mak c'utu'n ri xcan jb'ij Moisés, xche'tak chirij Esteban. ");
INSERT INTO uspNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Juntir rib'ilak mak comontak jb'ab'alak yak rijajl Israel ri cub'ultak cla', cuando xna'tuntak xriltak jcayb'al Esteban, ji'chaklon rilic chapca' jcayb'al jun anjl. ");
INSERT INTO uspNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Xpe man nimlaj jb'ab'alak yak ajc'amaltak jb'eak cristian riq'ui Kakaj Dios, xtz'onaj re Esteban: ¿Tz'etni' ri tijin tib'ijsaj chawij? xche' re. ");
INSERT INTO uspNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Xpe Esteban, xij: Atak kaj y atak inwinak, tatak impuch tamb'ij jcholajl chawechak. Kakaj Dios ri sub'laj nim jk'ij xwab'a' rib' chiwch kamam Abraham cuando ajwi' Mesopotamia, ajqui' chi b'e wa'xtak Harán ");
INSERT INTO uspNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","y xij re jilonri: Can ye' awulew pach yak awech'elxic. Y jat li man luwar ri tanc'ut chawch, xche' Kakaj Dios re. ");
INSERT INTO uspNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Jilonli Abraham xelb'i laj jluwrak mak aj Caldea y xe' wa'x Harán. Y cuando xcam jkaj Abraham, Kakaj Dios xc'am chicch Abraham la' man luwar ri jb'ij Canaán, lamas watakwi' atak lajori. ");
INSERT INTO uspNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Cuando xyuk neri ta' xjachsaj ni jun raquitz ulew laj jk'ab', pero xijsaji' re jwi'l Kakaj Dios chi man ulew ri, tina ye'sajna rechak yak rijajl nen or cuando camnakchak re. Y Abraham ajqui' jono ralc'wal la' mak k'ij li cuando xijsaj re jilonli. ");
INSERT INTO uspNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Xpe Kakaj Dios, xij re Abraham: Yak awijajl nen or tina b'e wa'xtakna li jun jalan tilmit ri ma' jtilmitak ta'n y tina wa'xna rajwak. Cla' tina b'ansajna c'ax rechak chiwch quejab' cient (400) junab'. ");
INSERT INTO uspNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","In tina imb'anna ink'atb'itzij chib'ak mak cristian re man tilmit li ri tijcoj rib'ak pi rajwak y rechak tina eltaknach cla' y tina jnimirsajtak ink'ij neri, xche' Kakaj Dios re Abraham. ");
INSERT INTO uspNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Kakaj Dios xan jun jchomorsa'n riq'ui Abraham re jcojic retal tio'jl pire retal ri jchomorsa'n ri xan. Y jwi'li'li cuando xq'uisi'y ra jc'ajol ri jb'ij Isaac, waxakib' (8) k'ij jq'uisi'y cuando xcoj retal jtio'jl y jilon xan chic Isaac re Jacob cuando xq'uisi'yc, xcoj retal jtio'jl. Y Jacob cuando xq'uisi'y yak cab'lajuj (12) jc'ajol, xcoj retal jtio'jlak y ri'taka' li yak cab'lajuj (12) jmamak yak rijajl Israel. ");
INSERT INTO uspNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Yak jc'ajol Jacob li, ri'taka' kamam ri xti'tijtak José ri jk'unak y xc'ayajtakb'i Egipto, pero Kakaj Dios wi' riq'ui José. ");
INSERT INTO uspNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Kakaj Dios xresaj José laj jk'ab' c'ax y xye' jno'j, jwi'li'li sub'laj tzi xilsaj jwi'l man faraón ri rey re Egipto. Xpe man faraón, xcoj José pi jcab' jb'ab'al k'atb'itzij re Egipto y xjach richoch y kelen re laj jk'ab'. ");
INSERT INTO uspNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Xpe jun nimlaj wi'jal Egipto y Canaán ri lamas wi'tak kamam, rechak ta' chiqui' nen tijtijtak. ");
INSERT INTO uspNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Cuando xta jtaquil Jacob chi wi' trig Egipto, xtakb'i kamam chi jlok'ic rechak cla', ri' li cuando kamam xe'tak nab'e b'welt Egipto. ");
INSERT INTO uspNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Y cuando xe'tak chic jca'mul, ajruc're' xij José rechak chi jk'unaki'n, ri' re ri xc'ayajtakb'i ojr y jilonli man faraón xretemaj nen jkaj José. ");
INSERT INTO uspNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Ajruc're' José xtak jc'amic Jacob ri jkaj pach yak ratz y jk'un y juntir ralc'walak, oxc'al jo'lajuj (75) rib'ilak xe'tak Egipto. ");
INSERT INTO uspNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Y jilonli xe' wa'x Jacob Egipto y cla' xcamwi' pach yak jc'ajol. ");
INSERT INTO uspNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Jcamnaklak Jacob pach José xesajtakb'i cla', xe' muksajtak li tilmit Siquem li ra luwar ri lok'an jwi'l Abraham riq'ui yak jc'ajol Hamor, xche' Esteban. ");
INSERT INTO uspNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Esteban xij chic: Jilonli xk'ax junab'. Cuando tawem tran k'ij tran Kakaj Dios ri b'il jwi'l re Abraham ojr, yak kamam sub'laj xq'uiyantak Egipto. ");
INSERT INTO uspNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Y xoc chic jun rey re Egipto ri ta' xch'ob' jwich José. ");
INSERT INTO uspNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Y man rey li xoc chi jb'anic c'ax rechak yak kawinak y xye' jun takon chi tijxuttak tra ralc'walak winak ri ajq'uisi'y pire ticamtak. ");
INSERT INTO uspNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Y la' mak k'ij li xq'uisi'y Moisés, jun ral ac'l ri jor tzi xilsaj jwi'l Kakaj Dios. Uxib' ic' xq'uitzaj jwi'l jkaj jchuch la ja. ");
INSERT INTO uspNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Pero cuando xresajtakb'i la ja, xpe man jrab'in man faraón, xc'amb'i laj richoch pire tijq'uitzaj chapca' ric'lal. ");
INSERT INTO uspNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Y xtijoj Moisés chirij jno'jak mak aj Egipto y wi' mas jno'j chi jb'ij nen raj tijb'ij y nen raj tran. ");
INSERT INTO uspNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Pero cuando xtz'akat ca'winak (40) junb' Moisés, xchomorsaj laj ranm xe' chi jsolajcak yak rijajl Israel ri jwinak. ");
INSERT INTO uspNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Y cuando xril Moisés chi jun aj Egipto tijin tran c'ax re jun rechak yak jwinak, xe' chi jcolic y xcamsaj man aj Egipto. ");
INSERT INTO uspNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Moisés ri' chijch'ol re chi tretemajtaka' yak jwinak chi Kakaj Diosi' takowinak re chi jcolicak. Pero yak jwinak ta' xretemajtak. ");
INSERT INTO uspNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Laj jcab' k'ij chic, Moisés xril quib' rechak yak jwinak tijintak chi ch'o'j, re raj roj xjache' jwichak, xij rechak: Atak, awinaki' ayb'ak, ¿nen chac tab'an c'ax ayb'ak chawib'il ayb'ak? xche' Moisés rechak. ");
INSERT INTO uspNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Xpe man ri tijin tran c'ax re jpach, xchikajb'i Moisés y xij re: ¿Nen xatcojow pi k'atb'itzij chikab'? Y, ¿nen xatcojow chi jb'anic k'atb'itzij chikab'? ");
INSERT INTO uspNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","¿Miti chawaj inacamsaj chapca' xab'an re jun aj Egipto iwr? xche' re Moisés. ");
INSERT INTO uspNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Cuando xta Moisés chi jilonli xijsaj re, xelmajb'ic, xe' wa'x li jun jalan luwar ri jb'ij Madián, xwa'x li jun tilmit ri ma' jtilmit ta'n y cla' xwa'x quib' jc'ajol. ");
INSERT INTO uspNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Y ca'winak (40) junab' jtawic Moisés cla', xwab'a' rib' jun ranjl Kakaj Dios ri Kajawl chiwch ri wi' laj jxak jk'ak'al jun mat lo'quiej li chekej luwar, chijc'ulel man nimlaj witz ri jb'ij Sinaí. ");
INSERT INTO uspNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Moisés sub'laj xsaach jch'ol chi rilic, xjutun chijc'ulel, ri' raj tran rilic nen chi kelen lal, ri'chak xta xch'a'w Kakaj Dios ri Kajawl, xij jilonri: ");
INSERT INTO uspNT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","Ini' ri in jDios amam, Abraham, Isaac y Jacob, xche'. Cuando xta Moisés xch'ab'ejc, tichak querquen jwi'l jtzakic jch'ol y ta' chiqui' raj xril. ");
INSERT INTO uspNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Y Kakaj Dios ri Kajawl xij chic re jilonri: Esaj axajb' jwi'l man luwar ri lamas watwi' tosoli' pi we. ");
INSERT INTO uspNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","In ilani' inwi'l nen c'ax tijin tijtijtak yak walc'wal Egipto y tanta' cuando tijb'ijtak chi sub'laj c'ax tijin tijtijtak, jwi'li'li xinkejch chi jcolicak. Lajori, tzaj impuch, atintakb'i Egipto, xche' Kakaj Dios re Moisés. ");
INSERT INTO uspNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Onque kamam nab'e xxuta'taka' Moisés cuando xijtak re: ¿Nen xatcojow pi k'atb'itzij chikab'? Y, ¿nen xatcojow chi jb'anic k'atb'itzij chikab'? xche'tak re. Pero Kakaj Dios xtakna pire k'atb'itzij chib'ak y pire ajcolol rechak cuando xwab'a' rib' jun anjl chiwch ri wi' laj jxak jk'ak'al jun mat lo'quiej. ");
INSERT INTO uspNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Y ri' Moisés li xesan rechak kamam Egipto y ri' xanow nimaktak c'utb'i jcwinel Kakaj Dios Egipto y li Mar Quiek y li chekej luwar chiwch mak ca'winak (40) junab'. ");
INSERT INTO uspNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Y ri' Moisés li xin rechak yak rijajl Israel: Kakaj Dios ri Kajawl tina jcha'na jun chijxo'lak yak awinakak pi ajk'asal Jyolj chaxo'lak chapca' in, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Y ri' Moisés xwa'x xo'lak yak rijajl Israel ri kamam li chekej luwar. Ri' re xch'ab'ej jwi'l anjl b'a witz Sinaí. Ri' re xtaw Jyolj Kakaj Dios ri tiye'w c'aslemal y xij chic chike oj, xche' Esteban rechak yak rijajl Israel. ");
INSERT INTO uspNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Esteban xij chic: Pero kamam ta' rajak xcojtak Jyolj Kakaj Dios ri tijb'ij Moisés, xxuttak Moisés, ri' rajak roj xk'ajtak chic Egipto. ");
INSERT INTO uspNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Xijtak re Aarón: B'an nic'j katiox pi jq'uexwach kadios pire tinab'ertak chikawch chi jc'amic kab'e jwi'l ta' ketam nen xan Moisés ri xojesanch Egipto, xche'tak re Aarón. ");
INSERT INTO uspNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Jilonli xantak jun tiox richb'al jun wacx, xcojtak pi jdiosak. Y xcamsajtak awaj pire tijsujtak re, xantak jun nimak'ij pire xc'ultak jk'ij man jtioxak ri ri'ke rechak xanowtak. ");
INSERT INTO uspNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Jwi'li'li xcan ye'sajtak jwi'l Kakaj Dios chi jcojic jk'ijak mak ch'umil pach k'ij pach ic' pi jdiosak. Jilon chapca' tijb'ij lak jwujak yak ajk'asaltak Jyolj Kakaj Dios ojr cuando Kakaj Dios xij jilonri: Atak rijajl Israel, ta' xacamsajtak awaj pire xasujtak chwe, ni xasipajtak kelen chwe cuando xatwa'xtak ca'winak (40) junab' li chekej luwar. ");
INSERT INTO uspNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Atak xawikajtakb'i man atioxak ri jb'ij Moloc pach man chinam ri richoch man atioxak, pach man atioxak richb'al jun ch'umil ri jb'ij Refán, ri mak tiox ri atake xatb'anowtak pire tacojtak jk'ij. Jwi'li'li atwesajtakb'i laj atilmitak y atintaktakb'i jilib'i re Babilonia, xche' Kakaj Dios, xche' Esteban rechak. ");
INSERT INTO uspNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Esteban xij chic: Cuando xwa'xtak kamam li chekej luwar ojr, wi' jun chinam riq'uilak ri richoch Kakaj Dios ri lamas tijc'oltakwi' mak tz'alam ab'aj ri tz'ib'al mak lajuj Jpixb' Kakaj Dios chiwch. Jilon jb'anic xantak re chapca' rilic man ri xc'utsaj chiwch Moisés jwi'l Kakaj Dios. ");
INSERT INTO uspNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Kamam katit' xc'ultak laj jk'ab'ak jmam jtit'ak man chinam li, ri richoch Kakaj Dios y aj c'amali' man chinam li jwi'lak pach Josué cuando xmajtak man ulew lamas xesajtak mak cristian jwi'l Kakaj Dios chiwchak pire tijachsaj man ulew rechak. Y man chinam li xwa'xna riq'uilak asta la' mak k'ij cuando xwa'x David. ");
INSERT INTO uspNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","David jor tzi xilsaj jwi'l Kakaj Dios, re xtz'onaj chi tiye'saj luwar re tran jun tz'etel ja lamas tiwa'xwi' Kakaj Dios ri jDios Jacob. ");
INSERT INTO uspNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Pero ta' xye'saj luwar re xan. Ri' Salomón ri jc'ajol xanow jwa'x man ja li. ");
INSERT INTO uspNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Pero Kakaj Dios lecj ta' tiwa'x li jun ja ri b'analke la' jk'ab'ak cristian chapca' xcan jtz'ib'aj ajk'asal Jyolj Kakaj Dios ojr cuando Kakaj Dios xij jilonri: ");
INSERT INTO uspNT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Caj tz'akatke tran pire lamas incub'arwi' chi uxlan y ulew xike tran pire jluwr wakan. Ta' ni jun ja atcwintak chi jb'anic pi we y ta' jun inluwr aac'lak lamas inuxlanwi'. ");
INSERT INTO uspNT_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Jwi'l la'yi' ink'b' b'analwi' caj pach ulew inwi'l, xche' Kakaj Dios. ");
INSERT INTO uspNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Atak, sub'laj atak jip, jilon axicnak y awanmak chapca' rechak yak ri ta' tijcojtak Jyolj Kakaj Dios, tak'attak jwich Lok'laj Jsantil Kakaj Dios. Atak atake nic' riq'ui amamak ojr. ");
INSERT INTO uspNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Juntir yak ajk'asaltak Jyolj Kakaj Dios xansaji' c'ax rechak jwi'l yak amamak. Rechak xcamsajtak ri tib'intak chi tina pena jun ri suc'ul ranm. Y cuando xyuk Kakaj Jesús jun winak ri suc'ul ranm, xajachtak pi c'ax y xacamsajtak. ");
INSERT INTO uspNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Atak xijsaji' Jpixb' Kakaj Dios chawechak ri xye'saj re Moisés jwi'l yak anjl, pero ta' xacojtak, xche' Esteban rechak. ");
INSERT INTO uspNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Mak comontak jb'ab'alak yak rijajl Israel cuando xtatak chi jilonli xijsaj rechak, sub'laj xkuch'uch'uj reeak jwi'l retzalak chi jtaic jyolj Esteban. ");
INSERT INTO uspNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Pero Esteban nojsali' ranm la' Lok'laj Jsantil Kakaj Dios, xna'tun lecj y xrilb'i jk'ak'al jnimal jk'ij Kakaj Dios y xrilb'i Kakaj Jesucristo wa'l laj jpaach Kakaj Dios. ");
INSERT INTO uspNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Ajruc're' Esteban xij: Iltak impuch lecj, twil in xteri' caj. In tijin twil Jc'ajol Kakaj Dios ri xwux pi cristianil wa'l laj jpaach Kakaj Dios, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Rechak xtz'apij jxicnak y sub'laj cow xch'ejejtak y juntir nic' jwichak xpetak chi jchapic Esteban. ");
INSERT INTO uspNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Xresajtakb'i Jerusalén. Ajruc're' xcholtak jcamsaj chi ab'aj. Y mak ri xk'ab'antak tzij chirij xrokxa'nijtak ritz'ikak ri tijk'u'jtak riq'ui jun c'ojol winak ri jb'ij Saulo. ");
INSERT INTO uspNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Y cuando tijintak chi jcamsaj Esteban chi ab'aj, Esteban xch'a'w riq'ui Kakaj Dios, xij: Kaj Jesús ri Wajawl, c'ul insantil, xche'. ");
INSERT INTO uspNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Ajruc're' xxucar y cow xch'ejejc, xij: ¡At Wajawl, cuy jmacak, ma ye' riq'ui awanm ri tijin trantak chwe! xche'. Xijmaj jilonli jwi'l, xcamc. ");
INSERT INTO uspNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Saulo jor tzi xril xcamsaj Esteban. La' k'ij li xpetak mak ri xcontrintak re Kakaj Jesucristo, xoctak chi jb'anic c'ax rechak juntir yak ajtakeltak re Kakaj Jesucristo ri wi'tak Jerusalén. Rechak juntir rib'ilak nak xtil rib'ak. Wi' jujun xe'tak lak luwar re Judea y wi' jujun xe'tak lak luwar re Samaria. Xike yak jtako'n Kakaj Jesucristo ta' xtil rib'ak. ");
INSERT INTO uspNT_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Xpetak jujun winak ajtakeltak re Kakaj Jesucristo, xe' jmuke'tak jcamnakl Esteban y sub'laj xok'tak chirij. ");
INSERT INTO uspNT_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Xpe Saulo, xoc chi jb'anic c'ax rechak yak ajtakeltak re Kakaj Jesucristo, ri' raj tijsach jwichak. Y xoc lak ja chi jchapicak chi anm chi winak pire tijc'amb'ic y tib'e jcoje' li cars. ");
INSERT INTO uspNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Pero yak ajtakeltak re Kakaj Jesucristo ri xeltakb'i Jerusalén xtil rib'ak b'ak tilmit y lamas titawtak tijb'ijtak tzilaj jtaquil chirij Kakaj Jesucristo. ");
INSERT INTO uspNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Jun rechak ri jb'ij Felipe xe' Samaria. Xtaw cla', xoc chi jb'ij rechak cristian tzilaj jtaquil chirij Kakaj Jesús ri b'il jwi'l Kakaj Dios chi tina jtaknach wich ulew. ");
INSERT INTO uspNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Cuando mak cristian xtatak ri tib'ijsaj rechak jwi'l Felipe y xriltak mak c'utb'i jcwinel Kakaj Dios ri tran, sub'laj cristian xmulb'a' rib'ak chirij y nojel ranmak tijtatak jcholajl ri tijb'ij Felipe rechak. ");
INSERT INTO uspNT_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Sub'laj cristian ri wi' etzl laj ranmak xtzib'sajtak jwi'l Felipe y mak etzl sub'laj cow tich'ejejtak cuando nak xeltakb'ic y sub'laj q'ui cristian ri siquirnak rakanak y jk'ab'ak y wi' co'xtak nak xtzib'sajtak. ");
INSERT INTO uspNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Jwi'li'li juntir cristian li man tilmit li sub'laj tiqui'cottak. ");
INSERT INTO uspNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Y li man tilmit li, ojrchak wi' jun ajitz cla' ri jb'ij Simón, jor xcwin chi jsub'icak cristian Samaria tijcoj jk'ij chi re nimi' jk'ij. ");
INSERT INTO uspNT_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Y juntir cristian, chi ac'l chi ri'jab' ticojowtak jk'ij y tijb'ijtak chirij: Man winak ri wi' jcwinel ri tib'ijsaj Nimlaj Jcwinel Kakaj Dios re, tiche'tak. ");
INSERT INTO uspNT_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Mak cristian jor tijcojtak nen tijb'ij, jwi'l ojri' sub'ultakch jwi'l la' mak itz ri tran. ");
INSERT INTO uspNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Pero cuando mak cristian xcojtak jyolj Felipe ri tijb'ij chirij tzilaj jtaquil chirij jtakon Kakaj Dios chib'ak cristian y chirij Kakaj Jesucristo, chi anm chi winak xansaj ja'tiox rechak. ");
INSERT INTO uspNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Y asta ri' jun Simón ri man ajitz xcoja' jyolj Felipe y xansaj ja'tiox re y xchol xamb'erem chirij Felipe, jor tisaach jch'ol chi rilic chi Felipe xan mak c'utb'i jcwinel Kakaj Dios. ");
INSERT INTO uspNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Cuando xtatak jtaquil yak jtako'n Kakaj Jesucristo ri wi'tak Jerusalén chi yak cristian aj Samaria xcoja'taka' Jyolj Kakaj Dios, xpetak xtaktakb'i Pedro pach Juan cla'. ");
INSERT INTO uspNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Cuando xtawtak Pedro pach Juan, xch'a'wtak riq'ui Kakaj Dios chirijak yak ajtakeltak re Kakaj Jesucristo ri wi'tak Samaria pire tijc'ultak Lok'laj Jsantil Kakaj Dios laj ranmak, ");
INSERT INTO uspNT_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","jwi'l ajqui' chi jc'ultak Lok'laj Jsantil Kakaj Dios laj ranmak, xike ja'tiox b'anal rechak laj jb'ij Kakaj Jesús ri Kajawl. ");
INSERT INTO uspNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Ajruc're' xpetak Pedro pach Juan, xye' jk'ab'ak laj jb'aak yak ajtakeltak re Kakaj Jesucristo, jilonli cuando xc'ultak Lok'laj Jsantil Kakaj Dios laj ranmak. ");
INSERT INTO uspNT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Cuando xril Simón chi yak cristian xc'ula'taka' Lok'laj Jsantil Kakaj Dios laj ranmak cuando xye' jk'ab'ak Pedro pach Juan laj jb'aak, xpe re, xsuj pwak rechak, ");
INSERT INTO uspNT_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","xij: Ye'tak chwe man cwinel li pire incwin chi jb'anic jilonli, pire cuando in tanye' ink'b' laj jb'a jono cristian tijc'ul Lok'laj Jsantil Kakaj Dios laj ranm, xche'. ");
INSERT INTO uspNT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Ajruc're' xpe Pedro, xij re: Chi saachti awch pach apwaak jwi'l at xachomorsaj chi wi'ke chi lok'em cwinel ri tijye' Kakaj Dios. ");
INSERT INTO uspNT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","At ta' tijna' tac'ul jcwinel Kakaj Dios jwi'l ta' suc'ul awanm chiwch Kakaj Dios. ");
INSERT INTO uspNT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Jwi'li'li q'uex ano'j y c'am jk'ab'al amac chiwch Kakaj Dios y tz'onaj jcuyic amac re, jilonli pent tijcuy amac chirij mak etzltak chomorsa'n ri xab'an. ");
INSERT INTO uspNT_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","In twil chi nojsali' awanm chi ti'tin jwi'l jc'axc'ol awanm chi rilic ri xkab'an y nic' riq'uil ximilcati' jwi'l amac, xche' Pedro re. ");
INSERT INTO uspNT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Xpe Simón, xij re Pedro pach Juan: Ch'a'wentak chwij riq'ui Kakaj Dios ri Kajawl pire ma' tipe man c'ax chimb' chapca' xab'ijtak chwe, xche'. ");
INSERT INTO uspNT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Pedro pach Juan, cuando xcan b'ijmaj jwi'lak rechak yak cristian nen xan Kakaj Jesucristo y xijtak Jyolj Kakaj Dios ri Kajawl rechak, xk'ajtak Jerusalén, pi k'axem rechak xk'axtak lak luwar re Samaria xcan jb'ijtak tzilaj jtaquil chirij Kakaj Jesucristo rechak cristian. ");
INSERT INTO uspNT_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Xpe jun ranjl Kakaj Dios ri Kajawl, xij re Felipe: Felipe, jat li sur, tib'e ate' man b'e ri tik'ax li chekej luwar ri tielb'i Jerusalén tib'e Gaza, xche' re. ");
INSERT INTO uspNT_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Felipe laj or xmajb'i jb'e, xec'. B'esal li b'e cuando xe' jte' jun winak aj Etiopía. Y ri' jun winak capunalc. Re nimi' rekle'n jwi'l ri' ajc'olol pwak chirij Candace, jun anm ri wi' pire reina re Etiopía. Man winak li jk'ajicch chi jnimirsaj jk'ij Kakaj Dios. ");
INSERT INTO uspNT_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","B'enam re laj jtilmit y cub'ul li jun carret juralb'i jwi'l cwa'y tijin chi rilic jwich wuj ri xcan jtz'ib'aj Isaías ri ajk'asal Jyolj Kakaj Dios. ");
INSERT INTO uspNT_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Ajruc're' xpe Lok'laj Jsantil Kakaj Dios, xij re Felipe: Jat, jutumb'i chijc'ulel man winak ri b'esal li carret, xche' re. ");
INSERT INTO uspNT_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Xpe Felipe, xe' jol chijc'ulel man winak li, xta chi tijin chi rilic jwich wuj ri xcan jtz'ib'aj Isaías ri ajk'asal Jyolj Kakaj Dios, xpe Felipe, xtz'onaj re: ¿Ton ata' jcholajl nen tijb'ij li wuj ri attijin chi rilic? xche' re. ");
INSERT INTO uspNT_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Man winak aj Etiopía xij re Felipe: Ta' tanta jcholajl jwi'l ta' nen tib'in chwe nen mo tielwi', xche' re. Ajruc're' xij re Felipe chi tijaw riq'uil li carret y ticub'ar riq'uil. ");
INSERT INTO uspNT_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Y man winak li tijin chi rilic li wuj re Lok'laj Jyolj Kakaj Dios ri lamas tz'ib'alwi' jilonri: Xc'amsajb'i pire ticamsaj chapca' tib'ansaj re mak tra carner y chapca' jun ra carner tike jye' rib' cuando tisocaj rij, ta' tich'ejejc y jilon xan re, ta' xch'a'wc. ");
INSERT INTO uspNT_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Re xye'ke rib' nen xansaj re, xansaj k'atb'itzij chirij onque ta' tz'et wi' jmac. Ta' ni jono cristian ticwin chi jyolic nen jnimal etzltak no'j ri wi' laj ranmak mak cristian la' mak junab' cuando xwa'x wich ulew, jwi'l xresajtakb'i jc'aslemal wich ulew, tiche'. ");
INSERT INTO uspNT_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Y man winak li xtz'onaj re Felipe: B'an tok'ob', b'ij chwe, ¿nen quiek chirij tijb'ijwi' ri tz'ib'al neri jwi'l ajk'asal Jyolj Kakaj Dios? ¿Chirijni' re o chirij jono chic? xche'. ");
INSERT INTO uspNT_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Ajruc're' xpe Felipe, xoc chi jb'ij jcholajl re nen tijin tril man winak li wuj y xij tzilaj jtaquil re chirij Kakaj Jesucristo. ");
INSERT INTO uspNT_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","B'esaltak li b'e, xk'axtak li jun luwar lamas wi' jun ja', xpe man winak, xij re Felipe: Neri wi' ja', ¿conta' tijna' tib'ansaj ja'tiox chwe? xche' re Felipe. ");
INSERT INTO uspNT_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Xpe Felipe, xij re: Wi kes tz'et nojel awanm ticub'ar ach'ol chirij Kakaj Jesucristo, tijna'n, xche' re man winak. Man winak xij: Lajori tancoja' chi Kakaj Jesucristo Jc'ajoli' Kakaj Dios, xche'. ");
INSERT INTO uspNT_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Ajruc're' xtak jwab'aj man jcarret y xkejtak li ja' chi quib' rib'ilak y Felipe xan ja'tiox re. ");
INSERT INTO uspNT_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Cuando xeltakch li ja' Felipe etke xc'amsajb'i jwi'l Lok'laj Jsantil Kakaj Dios ri Kajawl, ta' chiqui' xilsaj jwich jwi'l man winak li. Y man winak jorchak tiqui'cotc, xe' chic. ");
INSERT INTO uspNT_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Felipe ri'chak xric'aj wi'chak li man luwar ri jb'ij Azoto. Ajruc're' xe' chic, xmaj chicb'i jb'e. Xk'ax jb'ij tzilaj jtaquil chirij Kakaj Jesucristo asta xtaw Cesarea. ");
INSERT INTO uspNT_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Saulo xtakej jb'anic c'ax rechak yak ajtakeltak re Kakaj Jesucristo ri Kajawl, tijb'ij chirijak chi tina jcamsajtakna wi mita' tican jye'tak jcojic tzilaj jtaquil chirij Kakaj Jesucristo. Y Saulo xe' riq'ui man nimlaj jb'ab'alak yak ajc'amaltak jb'eak cristian riq'ui Kakaj Dios ri wi' Jerusalén. ");
INSERT INTO uspNT_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Xe' jtz'onaj jun wuj re pire tiye'saj k'atb'itzij laj jk'ab' pire tib'e lak sinagog re Damasco, pire tib'e chi jtoquic yak ri ticojowtak tzilaj jtaquil chirij Kakaj Jesucristo, chi anm chi winak tijchap pire tijc'amch prexil Jerusalén pire tib'an k'atb'itzij chirijak. ");
INSERT INTO uspNT_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Cuando b'esal li b'e tawem tran Damasco, etke xpe jun k'ak' lecj xrepaj rib' jk'ak'al chirij. ");
INSERT INTO uspNT_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Saulo xtzaak lak ulew y xta xaanch jun ch'a'wem lecj, xij: ¡Saulo, Saulo! ¿Nen chac takelquin awi'l pire tab'an c'ax chwe? xche'. ");
INSERT INTO uspNT_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Ajruc're' Saulo xtz'onaj re: ¿Nenc'u at li, Kaj? xche'. Kakaj Jesús xij chic: Ini' Jesús ri takel awi'l ri chawaj tab'an c'ax chwe. ");
INSERT INTO uspNT_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","¡B'iiten! Jat Damasco. Cla' tib'ijsajwi' chawe nen rajwax tab'an, xche' re Saulo. ");
INSERT INTO uspNT_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Y mak winak ri jpach Saulo b'esal, jor xtzaak jch'olak chi jtaic man ch'a'wem ri xaanc, pero ta' nen xriltak jwich. ");
INSERT INTO uspNT_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Saulo xb'iit lak ulew, xteb'a' b'ak' jwich, ta' chiqui' tina'tunc. Xpe mak winak ri jpach, xchaptakb'i chi jk'ab', xc'amtakb'i Damasco. ");
INSERT INTO uspNT_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Uxib' k'ij xwa'x cla', ta' xna'tunc, ni ta' xwi'nc, ni ta' xuc'a'janc. ");
INSERT INTO uspNT_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Cla' Damasco jekel jun winak ri ajtakel re Kakaj Jesucristo ri jb'ij Ananías, re xch'ab'ej chapca' li jun ichic' jwi'l Kakaj Jesús ri Kajawl, xij re: ¡Ananías! xche' re. Ananías xij: Wini' neri, Wajawl, xche'. ");
INSERT INTO uspNT_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Y Kakaj Jesús xij re Ananías: Jat, atb'e la' man b'e ri cojol jb'ij pi Suc'ul, attaw chi' richoch Judas. Cla' tatz'onaj lamas wi' Saulo, jun winak aj Tarso. Re tijini' chi ch'a'wem riq'ui Kakaj Dios. ");
INSERT INTO uspNT_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Re xril jwich jun winak chapca' li jun ichic' jb'ij Ananías, xocb'i riq'uil y xye' jk'ab' laj jb'a pire xtzib' chic b'ak' jwich, xche' Kakaj Jesús re Ananías. ");
INSERT INTO uspNT_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Cuando xta Ananías chi jilon xijsaj re, xpe re, xij: Wajawl, pero man winak li sub'laj cristian xintak chwe chi sub'laj c'ax b'anal jwi'l rechak cristian ri ticojowtak tzilaj jtaquil chawij ri wi'tak Jerusalén. ");
INSERT INTO uspNT_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Y lajori xpe neri, ye'lch k'atb'itzij laj jk'ab' jwi'lak mak jb'ab'alak yak ajc'amaltak jb'eak cristian riq'ui Kakaj Dios chi jchapicak juntir cristian ri tinimirsantak jk'ij ab'j, xche' Ananías re Kakaj Jesús. ");
INSERT INTO uspNT_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Pero Kakaj Jesús ri Kajawl xij: Jat, in xincha' winak li chi jb'ij intaquil rechak yak cristian ri ma' rijajl ta' Israel, rechak mak rey y rechak yak rijajl Israel. ");
INSERT INTO uspNT_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","In, tina inc'utna chiwch Saulo jurub' c'ax ri tina jtijna chi jye'ic intaquil, xche' Kakaj Jesús re Ananías. ");
INSERT INTO uspNT_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Ananías xe' la ja lamas wi' Saulo. Cuando xoc la ja xye' jk'ab' laj jb'a Saulo y xij re: Saulo ri at wech'elxic chirij Kakaj Jesucristo, Kakaj Jesús ri Kajawl ri xatch'ab'en li b'e lamas petzalcatwi', ri' re xintakowch aac'l pire atna'tunc y tijnojsaj awanm la' Lok'laj Jsantil Kakaj Dios, xche' re. ");
INSERT INTO uspNT_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Y laj or xtzaakch nic'j kelen laj jwich Saulo chapca' jmatz'ul ixm, jilonli cuando xtzib' chic b'ak' jwich, xb'iit chic y xansaj ja'tiox re. ");
INSERT INTO uspNT_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Y ajruc're' xwi'n chic y xuc'a'jan chic, ji'kelonli cuando xyuk chic jchok'b'. Ajruc're' Saulo xcan quib' uxib' k'ij chijxo'lak yak ajtakeltak re Kakaj Jesucristo ri wi'tak Damasco. ");
INSERT INTO uspNT_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Saulo xoc chi jb'ij rechak cristian lak sinagog chi Kakaj Jesús, Jc'ajoli' Kakaj Dios. ");
INSERT INTO uspNT_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Juntir ri xtatak jyolj sub'laj xsaach jch'olak chi jtaic y xoctak chi jtz'onaj chirib'il rib'ak: ¿Ma' ronin ta' winak ri, ri xanow c'ax rechak yak ajtakeltak re Kakaj Jesucristo ri wi'tak Jerusalén? Y, ¿miti ri' re ri xpe neri pire tiyuk jchape' yak ajtakeltak re Kakaj Jesucristo pire tijc'amb'i chiwchak mak jb'ab'alak yak ajc'amaltak jb'eak cristian riq'ui Kakaj Dios ri wi'tak Jerusalén? xche'tak. ");
INSERT INTO uspNT_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Pero Saulo sub'laj tijin tiyuk mas jcowil ranm chi jb'ij chi Kakaj Jesús ri' ri b'il jwi'l Kakaj Dios chi tina jtaknach wich ulew. Jwi'li'li yak rijajl Israel ri wi'tak Damasco xsaach jch'olak chi jtaic, ta' chiqui' tijta'tak nen trantak. ");
INSERT INTO uspNT_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Cuando xe' q'uilaj k'ij, yak rijajl Israel xniq'uib' jwichak, xchomorsajtak nen trantak chi jcamsaj Saulo, ");
INSERT INTO uspNT_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","pero Saulo xretemaji' nen jchomorsa'nak. Chi lak'j chi lak'ab' tijin tijchajajtak chi' man pwert re man tz'aak ri sutuwinak rij man tilmit pire tijcamsajtak. ");
INSERT INTO uspNT_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Pero xpetak yak ajtakeltak re Kakaj Jesucristo, xresajtakb'i Saulo lak'ab' xye'takb'i li jun nimlaj chicach y xkesajtakb'i chirij man tz'aak ri sutuwinak rij man tilmit Damasco, ji'chaklonli xcolmajb'i Saulo. ");
INSERT INTO uspNT_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Cuando Saulo xtaw Jerusalén, re raj roj xoc chijxo'lak yak ajtakeltak re Kakaj Jesucristo, pero juntir rib'ilak sub'laj titzaak jch'olak chiwch, jwi'l ta' tijcojtak chi Saulo xjacha' rib' laj jk'ab' Kakaj Jesucristo. ");
INSERT INTO uspNT_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Pero xpe Bernabé, xc'amb'ic, xe' jwab'a' chiwchak yak jtako'n Kakaj Jesucristo y xij rechak chi Saulo xrila' jwich Kakaj Jesús ri Kajawl li b'e y xij rechak chi xch'ab'eji' jwi'l Kakaj Jesús. Y Saulo wi'chak sub'laj jcowil ranm xij tzilaj jtaquil chirij Kakaj Jesucristo rechak cristian Damasco. ");
INSERT INTO uspNT_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Jilonli cuando xcan Saulo chijxo'lak yak ajtakeltak re Kakaj Jesucristo ri wi'tak Jerusalén, nic' tiwo'cottak y wi' jcowil ranm xij tzilaj jtaquil chirij Kakaj Jesucristo. ");
INSERT INTO uspNT_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Xpe Saulo, xoc chi yoloj pach yak rijajl Israel ri tiyolowtak li tzijb'al griego. Pero rechak xpe retzalak chirij Saulo jwi'l re tijin tiyolow chirij tzilaj jtaquil chirij Kakaj Jesucristo, jilonli rechak xoctak chi jtoquic nen trantak chi jcamsajc. ");
INSERT INTO uspNT_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Y cuando xretemajtak yak ajtakeltak re Kakaj Jesucristo nen jchomorsa'nak chirij Saulo, laj or xc'amtakb'i Cesarea y cla' xtaktakb'i Tarso. ");
INSERT INTO uspNT_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Y jilonli cuando xwa'x utzil pi rechak yak k'at ajtakeltak re Kakaj Jesucristo ri wi'tak lak luwar re Judea, Galilea y Samaria. Jilonli xb'it rib'ak chi jb'anic mas lawi' raj Kakaj Jesucristo, xtakejtak jcojic jk'ij Kakaj Jesucristo ri Kajawl, sub'laj xq'uiyantak yak ajtakeltak re Kakaj Jesucristo y ri' Lok'laj Jsantil Kakaj Dios xye'w jcowil ranmak. ");
INSERT INTO uspNT_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Cuando Pedro tijin chi jsolajcak yak ajtakeltak re Kakaj Jesucristo, xe' chi jsolajcak yak ri wi'tak li man tilmit Lida. ");
INSERT INTO uspNT_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Cla' xe' jte' jun winak ri jb'ij Eneas. Re wi'chak waxakib' (8) junab' jkejic laj jsoc jwi'l siquirnak jtio'jl. ");
INSERT INTO uspNT_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Xpe Pedro, xij re: Eneas, Kakaj Jesucristo attzib'sanc, b'iiten, can yujb'a' asoc, xche' re. Eneas laj or xb'iitc. ");
INSERT INTO uspNT_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Juntir cristian ri wi'tak Lida y Sarón, cuando xriltak chi xtzib'saji' Eneas, laj or xq'uex jno'jak y xoctak laj jk'ab' Kakaj Jesucristo ri Kajawl. ");
INSERT INTO uspNT_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Jope wi' jun anm ajtakel re Kakaj Jesucristo ri jb'ij Tabita. Ri jcholajl tielwi' man b'ij Tabita, Dorcas. Sic' anm li nojel k'ij sub'laj utzil tran, tijt'owa' yak cristian ri wi' rajwax rechak. ");
INSERT INTO uspNT_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Y la' mak k'ij li xpe jun jyaj Dorcas y xcamc. Mak cristian xantak ritin y cuando xantaj ritin jwi'lak, xye'tak li jun cwart laj jcab' wik re man ja. ");
INSERT INTO uspNT_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Jope ji' wi' nakaj re man tilmit Lida ri man tilmit lamas wi' Pedro. Jwi'li'li yak ajtakeltak re Kakaj Jesucristo cuando xtatak jtaquil chi wi' Pedro cla', xtaktakb'i quib' winak chi jtz'onaj tok'ob' re: ¡B'an tok'ob', tzaj laj or kiq'uil! xche'tak. ");
INSERT INTO uspNT_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Jilonli xe' Pedro chirijak. Cuando xtaw cla', xc'amtakb'i la' man cwart lamas wi' camnak. Y juntir yak anm ri camnak richjilak sub'laj tiok'tak, xmulb'a' rib'ak chirij Pedro y nak xoctak chi jc'utic túnica y mak ritz'ikak ri tijk'u'jtak chiwch ri cochal jwi'lak riq'ui Dorcas cuando aj yo'lna. ");
INSERT INTO uspNT_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Xpe Pedro, laj or xresajch juntir cristian ri wi'tak la ja cla'. Ajruc're' xxucar li man cwart y xoc chi ch'a'wem riq'ui Kakaj Dios. Ajruc're' xril sic' anm ri camnak y xij re: ¡Tabita, b'iiten! xche' re. Sic' anm li xteb'a' b'ak' jwich y cuando xril jwich Pedro, xb'iitc, xcub'ar b'a jch'at. ");
INSERT INTO uspNT_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Xpe Pedro, xchap chi jk'ab', xwab'a' y xsiq'uijb'i yak ajtakeltak re Kakaj Jesucristo pach yak anm ri camnak richjil. Xwab'a' Dorcas chiwchak, c'astasalchak jwich laj jcamnaklak. ");
INSERT INTO uspNT_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Y juntir li xetemaj jwi'lak cristian re Jope y sub'laj q'ui xjach rib'ak laj jk'ab' Kakaj Jesucristo ri Kajawl. ");
INSERT INTO uspNT_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Pedro xcan q'uilaj k'ij Jope. Xwa'x laj richoch jun ajb'anal jwa'x tz'um ri jb'ij Simón. ");
INSERT INTO uspNT_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Cesarea wi' jun winak ri jb'ij Cornelio, ri' jun jb'ab'alak man k'at mak soldad ri tib'ijsaj Italiano re. ");
INSERT INTO uspNT_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Man winak li pach rixokl y ralc'wal nojeli' ranmak tijcojtak jk'ij Kakaj Dios y trantak lawi' raj Kakaj Dios trantak. Re sub'laj pwak tijye' chi jt'o'icak yak cristian ri wi' rajwax rechak y coc'xo'l tich'a'w riq'ui Kakaj Dios. ");
INSERT INTO uspNT_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Li jun k'ij, raj laj jrox or re b'esal k'ij, Cornelio xril jwich jun anjl chapca' li ichic', xocb'i riq'uil lamas wi' y xij re: ¡Cornelio! xche'. ");
INSERT INTO uspNT_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Y Cornelio cow xril anjl y sub'laj xtzaak jch'ol, xtz'onaj re: Kaj, ¿nen chawaj? xche' re. Ajruc're' xpe anjl, xij re: Kakaj Dios xta' ayolj cuando xatch'a'w riq'uil y tziyi' xril xat'o' yak ri wi' rajwax rechak. ");
INSERT INTO uspNT_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Lajori takb'i jono cristian Jope chi jsiq'uij Simón ri tib'ijsaj Pedro re pire tipe aac'l. ");
INSERT INTO uspNT_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Ji' wi' jposad riq'ui jun winak ri jb'ij Simón ri ajb'anal jwa'x tz'um ri wi' richoch chi' mar, xche' anjl re Cornelio. ");
INSERT INTO uspNT_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Cuando xelb'i anjl ri xch'ab'en re Cornelio, xpe Cornelio xsiq'uij quib' rechak yak jmocom pach jun soldad ri ticojow jk'ij Kakaj Dios ri jun jtako'n ri cub'ul jch'ol chirij ");
INSERT INTO uspNT_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","y xyol rechak nen xij anjl. Cuando xyolmaj juntir rechak jwi'l, ajruc're' xtakb'i mak jtako'n Jope. ");
INSERT INTO uspNT_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Laj jcab' k'ij cuando yak jtako'n Cornelio b'esaltak lak b'e tawem trantak Jope, raj tiq'uil cab'lajuj (12) k'ij, Pedro xjaw b'a ja pire tich'a'w riq'ui Kakaj Dios. ");
INSERT INTO uspNT_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Tichak c'ok jwi'l wi'jal y raj roj xtij jwa, pero cuando tijin jb'anic jwa'x jwa, re xril jun kelen chapca' li ichic'. ");
INSERT INTO uspNT_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Xril xter caj y xkejch jun kelen lecj asta xtaw lak ulew chapca' rilic jun nimlaj sawn ximil chi quejab' jxiquinl. ");
INSERT INTO uspNT_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Y chiwch man itz'ik petzal juntir jwich awaj ri cajcaj rakanak pach ca'n ri tijjuraj rib'ak lak ulew cuando tib'entak y ca'n ri tirupuptak lecj. ");
INSERT INTO uspNT_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Y xta xaan jun ch'a'wem, xij re: B'iiten Pedro, camsaj mak awaj pach mak ca'n ri y tij, xche'. ");
INSERT INTO uspNT_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Pedro xij: Ta'n, Wajawl, in ni jun b'welt tijil kelen inwi'l ri ta' tijye' luwar Jpixb' Kakaj Dios, xche'. ");
INSERT INTO uspNT_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Ri'chak tijta xijsaj chic re: Lawi' kelen ri Kakaj Dios xye' luwar titijsaj, ma b'ij chi ta' tzi titijsaj, xche' re Pedro. ");
INSERT INTO uspNT_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Oxmul xijsaj re jilonli, ajruc're' xchol chic jawem man sawn lecj. ");
INSERT INTO uspNT_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Pedro aj tijini' chi jchomorsaj nen jcholajl tielwi' man kelen ri xril, cuando xtawtak mak winak chi' pwert, ri takaltakb'i jwi'l Cornelio chi jtoquic richoch Simón. ");
INSERT INTO uspNT_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Cuando xtawtak, xch'a'wtak y xtz'onajtak wi la'yi' man ja li wi' jposad winak ri jb'ij Simón ri tib'ijsaj Pedro re. ");
INSERT INTO uspNT_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Y Pedro aj tijini' chi jchomorsaj nen jcholajl tielwi' man kelen ri xril cuando xpe Lok'laj Jsantil Kakaj Dios xij re: Neri wi' uxib' winak tijintak chi atoquic. ");
INSERT INTO uspNT_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","B'iiten, kejench cla'. Jat chirijak, mi ran quib' awanm jwi'l ini' xintakowch rechak, xche' Lok'laj Jsantil Kakaj Dios re Pedro. ");
INSERT INTO uspNT_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Pedro xkejch y xij rechak mak uxib' winak ri jtako'n Cornelio: Ini' ri, ri tijin tatoctak. ¿Nen quiek jwi'l xatpetak chi intoquic? xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Rechak xijtak: Oj xojtaksajch jwi'l Cornelio ri jb'ab'alak mak soldad, ri' jun winak ri suc'ul ranm chiwch Kakaj Dios y tijcoja' jk'ij Kakaj Dios y mas tilok'aj jwi'lak juntir yak rijajl Israel. Y jun anjl xin re chi tijtak ac'amic pire atb'e laj richoch y pire tijta nen chawaj tab'ij re, xche'tak re Pedro. ");
INSERT INTO uspNT_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Ajruc're' xcojsajtak la ja jwi'l Pedro y cla' xwa'xtakwi' jun ak'ab'. Laj jcab' k'ij, xe' Pedro chirijak mak uxib' winak y xpachijb'i jwi'lak nic'j ajtakeltak re Kakaj Jesucristo ri wi'tak Jope. ");
INSERT INTO uspNT_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Y laj jcab' k'ij Pedro xtawtak Cesarea lamas tijin tiulb'ej jwi'l Cornelio pach nic'j yak rech'elxic y yak nic'j richc'ulchi' ri xtak jsiq'uijc. ");
INSERT INTO uspNT_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Cuando xocb'i Pedro chuch ja, xpe Cornelio, laj or xelch chi jc'ulic y xxucar chiwch chi jcojic jk'ij. ");
INSERT INTO uspNT_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Pero Pedro laj or xb'it Cornelio y xij re: B'iiten, wa'ren, in inke jun cristian chapca' at, xche' re. ");
INSERT INTO uspNT_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Pedro tijin chi yoloj riq'ui Cornelio cuando xoctakb'i la ja, xe' jte' sub'laj cristian mulb'em rib'ak la ja. ");
INSERT INTO uspNT_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Pedro xij rechak: Atak awetamaki' chi ta' tiye'saj luwar re jun rijajl Israel tijpachij o tib'e solin laj richoch jun cristian wi ma' rijajl ta' Israel. Pero Kakaj Dios xc'utuw chinwch chi juntir cristian ri b'anal jwi'l ta' luwar tikab'ij oj chi ta' tzi. ");
INSERT INTO uspNT_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Y jwi'li'li cuando xataktak insiq'uijc, ximpeti'n. Ta' ximb'ij chi ta' chwaj. ¿Nenc'u chawajak chwe xataktak inc'amic? xche' Pedro rechak. ");
INSERT INTO uspNT_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Y Cornelio xij re: Xana' quejab' k'ij lajori, raj jilon or chapca' or lajori, laj jrox or re b'esal k'ij in win la ja neri tijin inch'a'w riq'ui Kakaj Dios cuando ri'chak xwil xwab'a' rib' jun winak chinwch, cojol jun ritz'ik jwi'l pur tikopoponc. ");
INSERT INTO uspNT_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Y xij chwe: Cornelio, Kakaj Dios xta' ayolj cuando xatch'a'w riq'uil y retami' ri b'anal awi'l chi jt'o'icak yak ri wi' rajwax rechak. ");
INSERT INTO uspNT_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Tak jsiq'uij Simón ri tib'ijsaj Pedro re, ri wi' Jope ri wi' jposad riq'ui jun winak ri jb'ij Simón ri ajb'anal jwa'x tz'um ri wi' richoch chi' mar, xche' chwe. ");
INSERT INTO uspNT_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Jilonli xintak atoquic y at xab'ana' tok'ob' xatpetc. Y lajori woj neri. Chiwch Kakaj Dios chikaj tikata juntir ri b'il chawe jwi'l Kakaj Dios chi tab'ij chike, xche' Cornelio re Pedro. ");
INSERT INTO uspNT_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Pedro xchol yoloj riq'uilak y xij rechak: Lajori xwetemaji' chi Kakaj Dios tz'etel tz'eti' ta' jaljoj rilic jun cristian tran pach jun chic. ");
INSERT INTO uspNT_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Lak juntir tilmit re wich ulew Kakaj Dios tziyi' tril yak cristian ri ticojow jk'ij y trantak tzitaklaj no'j. ");
INSERT INTO uspNT_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Atak, awetamaki' tzilaj jtaquil chirij Kakaj Jesucristo ri xtaksaj jb'ij rechak yak rijajl Israel jwi'l Kakaj Dios, pire tiwa'x utzil laj ranmak jwi'l Kakaj Jesucristo ri Rajawlak juntir cristian. ");
INSERT INTO uspNT_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Atak, awetamaki' chi tzilaj jtaquil li, ji' xcholmajb'i jb'ij Galilea asta xtaw jtaquil lak juntir tilmit re Judea. Cuando jorok b'ijsaji' rechak cristian jwi'l Juan Ajb'anal Ja'tiox chi rajwaxi' tijq'uex jno'jak y tijc'am jk'ab'al jmacak chiwch Kakaj Dios pire tib'ansaj ja'tiox rechak. ");
INSERT INTO uspNT_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Awetamaki' chi Kakaj Dios xya' jcwinel y xya' Jsantil laj ranm Kakaj Jesús ri aj Nazaret. Kakaj Jesús xana' utzil chijxo'lak cristian y xtzib'saji' juntir cristian ri tijin tijtijtak c'ax laj jk'ab' man jb'ab'al etzl, jwi'l re wi' Kakaj Dios riq'uil. ");
INSERT INTO uspNT_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Y oj xkila' chi tz'eti' juntir ri xan Kakaj Jesús Jerusalén pach laj jluwrak yak rijajl Israel. Rechak xcamsajtak cocb'al wich curs. ");
INSERT INTO uspNT_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Pero Kakaj Dios xc'astasaji' jwich laj jcamnakl laj jrox k'ij y xan chi xwab'a' chic rib' chikawch oj pi cristianil. ");
INSERT INTO uspNT_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Kakaj Jesucristo ta' xilsaj jwich jwi'l juntir cristian, xike oj ri cha'lcoj jwi'l Kakaj Dios. Y xojwi'ni'n y xojuc'a'jani' riq'uil cuando jorok c'astasaji' jwich laj jcamnakl xo'lak camnakib'. ");
INSERT INTO uspNT_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Re xojjtak chi jb'ij rechak juntir cristian b'ak tilmit chi ri' re cha'l jwi'l Kakaj Dios pire tran jk'atb'itzij chib'ak juntir cristian ri yo'ltak y ri camnaktak. ");
INSERT INTO uspNT_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Juntir yak ajk'asaltak Jyolj Kakaj Dios xijtaka' chi nen tijcub'a' jch'olak chirij, ticuysaji' jmac jwi'l Kakaj Dios laj jb'ij Kakaj Jesucristo, xche' Pedro rechak. ");
INSERT INTO uspNT_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Aj tijini' Pedro chi jb'ij jilonli rechak cuando xkej Lok'laj Jsantil Kakaj Dios chib'ak yak ri tijintak chi jtaic jyolj Pedro. ");
INSERT INTO uspNT_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Y yak rijajl Israel ri jachem rib'ak laj jk'ab' Kakaj Jesucristo ri tijcojtak jk'ij man jcojic retal jtio'jl winak ri xamb'ertakch chirij Pedro, xsaach jch'olak chi rilic chi Kakaj Dios xya' Lok'laj Jsantil laj ranmak yak ma' rijajl ta' Israel. ");
INSERT INTO uspNT_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Rechak xretemajtak chi xc'ula'taka' Lok'laj Jsantil Kakaj Dios jwi'l xtatak tichak tijintak chi jnimirsaj jk'ij Kakaj Dios y tichak yolowtak lak jaljojtak tzijb'al. ");
INSERT INTO uspNT_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Xpe Pedro, xij rechak: Ta' ni jonok tib'in chi ta' tijna' tib'ansaj ja'tiox rechak yak cristian ri la' ja', ri xc'uluwtak Lok'laj Jsantil Kakaj Dios laj ranmak chapca' xkab'an oj, xche' rechak. ");
INSERT INTO uspNT_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Y Pedro xij chi tib'ansaj ja'tiox rechak laj jb'ij Kakaj Jesucristo. Y ajruc're' sub'laj xpwersijtak jb'ij re Pedro chi tiwa'x chic quib' uxib' k'ij riq'uilak. ");
INSERT INTO uspNT_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Yak jtako'n Kakaj Jesucristo pach yak ajtakeltak re Kakaj Jesucristo ri wi'tak Judea xta'taka' jtaquil chi yak ri ma' rijajl ta' Israel xcoja'taka' Jyolj Kakaj Dios. ");
INSERT INTO uspNT_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Jilonli cuando Pedro xk'aj chic Jerusalén, xpetak jujun rechak yak rijajl Israel ri ticojowtak Jyolj Kakaj Dios ri tijcojowtak jk'ij man jcojic retal jtio'jl winak, xyajtak Pedro. ");
INSERT INTO uspNT_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Y xijtak re: ¿Nen chac xe' asolaj mak cristian ri ma' rijajl ta' Israel ri ta' cojol retal jtio'jlak y xatwi'n riq'uilak? xche'tak re. ");
INSERT INTO uspNT_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Ajruc're' Pedro xoc chi jyolic rechak juntir ri ilan y b'anal jwi'l, xij rechak: ");
INSERT INTO uspNT_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","Cuando xinwa'x Jope, in tijin inch'a'w riq'ui Kakaj Dios cuando etke xc'ut rib' jun kelen chinwch chapca' li ichic'. Xwil jun kelen chapca' rilic jun nimlaj sawn ximil chi quejab' jxiquinl xkejch lecj asta lamas winwi'. ");
INSERT INTO uspNT_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Cow xwil, ri'chak xwil mak awaj wi' chiwch ri cajcaj rakanak pach mak c'a'ntaklaj ca'n pach ca'n ri tijjuraj rib'ak lak ulew cuando tib'entak pach mak ca'n ri tirupuptak lecj. ");
INSERT INTO uspNT_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Y ri'chak xinta xaanch jun ch'a'wem lecj, xij chwe: B'iiten Pedro, camsaj juntir ri y tij, xche' chwe. ");
INSERT INTO uspNT_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Pero in ximb'ij: Ta'n Wajawl, in ni jun b'welt tijil kelen inwi'l ri ta' tijye' luwar Jpixb' Kakaj Dios, xinche' re. ");
INSERT INTO uspNT_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Ri'chak xinta xinjch'ab'ej chic jca'mul lecj, xij chwe: Lawi' kelen ri Kakaj Dios xye' luwar titijsaj, ma b'ij chi ta' tzi titijsaj, xche' chwe. ");
INSERT INTO uspNT_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Oxmul xijsaj jilonli chwe, ajruc're' xchol chic jawem man nimlaj sawn lecj. ");
INSERT INTO uspNT_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Y laj or xtawtak uxib' winak la ja lamas winwi', takaltakb'i chi intoquic, ji' xeltakb'i Cesarea xtawtak wiq'uil. ");
INSERT INTO uspNT_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Y Lok'laj Jsantil Kakaj Dios xin chwe chi mi ran quib' wanm chi b'enam riq'uilak. Y xe'tak chwij yak wakakib' (6) kech'elxic chirij Kakaj Jesucristo y nic' xojoc laj richoch Cornelio. ");
INSERT INTO uspNT_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Re xij chike nen mo xril jun anjl wa'l laj richoch y xij re: Takb'i nic'j winak Jope pire tib'e jsiq'uij Simón ri tib'ijsaj Pedro re. ");
INSERT INTO uspNT_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Y re tiyuk jb'ij chawe pach juntir yak ri wi'tak laj awichoch nen tab'antak pire atcolmajtak laj jk'ab' amacak, xche', xche' Cornelio chwe. ");
INSERT INTO uspNT_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Cuando xinchol jch'ab'ejcak Cornelio pach yak ri wi'tak laj richoch, xkejch Lok'laj Jsantil Kakaj Dios chib'ak chapca' xan chikab' oj nab'e. ");
INSERT INTO uspNT_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Ajruc're' xcuxtaj inwi'l jyolj Kakaj Jesucristo ri Kajawl cuando xij: Juan Ajb'anal Ja'tiox xana' ja'tiox la' ja', pero tina ac'ultakna Lok'laj Jsantil Kakaj Di