﻿USE sofia;
DROP TABLE IF EXISTS sofia.usa_vpl;
CREATE TABLE usa_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES usa_vpl WRITE;
INSERT INTO usa_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Yawe Îtogo Abaramtaba téna, “Enamááqa, ení wayukagara, enaponi wayukagara yuwéya kemó emmó arátenna mararaqa wao. ");
INSERT INTO usa_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Kemá emma mamá ení márúqa anómma aurakeqa emmá atimua uyakanune. Ení awîqa mama anóni ona, abo emá yeráwápímmá atimuka inone. ");
INSERT INTO usa_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Náyumo atimuqó uyakainomma kemá atimu umayike, abo náyumo taiáimo umakaiyamma kemá taiáima umayikanune. Abo máte kayuka mamárábímmá ekáké kemá atimuqá umayikanune.” ");
INSERT INTO usa_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Abaramma tébéniqa tenikara móra tiyapa (75) auqa keena, Yawe Îtogo timamiteni-umá Abaramma Áráni maruqa yuwéna witana Rotima Abaramte uraiye. ");
INSERT INTO usa_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Abaram wení áanáqa Táraigara, wení ábákoni áanine, máten-otamo yemó aikumarakaraq abo Árániqo aikuyikara mayai wayukagaraq yiwiqmena Keinen mararaq marena uraiye. Abo yeráwáqá mareta Keinen koyarae. ");
INSERT INTO usa_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Mikánábímá Keinen marabimma wayuka maawata, Abaramya mareta Keinen marabi wéqéta Tekem maruqa anón tayaipi Móre aukapa koyarae. ");
INSERT INTO usa_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Yawe Îtogo Abaramka páquma weka téna, “Ení iyápórawaqa kemá ma-márá yimenune.” Miráitana, Abaramma Yawe Îtogoka yaare mika tarouraiye. ");
INSERT INTO usa_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Mikákémmá, Abaramma maréna Beter aabaumo utai aitabaqa uraiye. Aabaumo kuperaibaqa Beteriye, aabaumo utaibaqa Ááiye. Mami kaya marukoni aukapimma wení yuwaiq-namma uraiye. Mika Abaramma Yawe Îtogoka yaare tarourena monoqá timakaraiye. ");
INSERT INTO usa_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Abaramma mikáké kómarena Négébé wiwiuraiye. ");
INSERT INTO usa_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Mitupaa Keinen marabi koyaimmá aayawa maeuraiye, aayawagómá anónikeitaba, Abaramma maréna paaqyakanabi Ítípiq mainena kukaiye. ");
INSERT INTO usa_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Ítípiq wemá koyanekeena aanakomma Taraitaba tena, “Kemó aonaunama emá kateko ínímmá maane. ");
INSERT INTO usa_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Ítípiq wayukama emmó aoneta, yerawáqá miráitinoe, ‘mami nínímmá wenánáre.’ teta yeráwáqá kemmá tikameta emmá paa-ayuwaiya mainone. ");
INSERT INTO usa_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Kemá wení amanaqune tinata, abo kema enauyawataba iraqoniqu matiketa tiyuwaiya enáitaba maeno.” ");
INSERT INTO usa_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Aanibo Abaramma Ítípiqo witana, Ítípi wayuka wení aanaqa aonama aara-urane tirae. ");
INSERT INTO usa_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Abo miráitana, Peroni anókayuka wemmá aonama aara-urane téta Peromma timamituweta awiqmeta Peroni naaupa urae. ");
INSERT INTO usa_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Mamin-initaba Peroma Abaramma iraqoni keuyakena anaégáráq awai típítípíráóqá, mémeraoqa, purumakakáwáqá, pááqya ótirawaqa kémórórawakaraq, mayai wayuka, aaragáráq waagaraq amikaiye. ");
INSERT INTO usa_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Peroma Abaramni aanaqa mayai aitaba Yawe Îtogo tawi gari yuwaitana Perogara wení wayuka-annabi kukaiye. ");
INSERT INTO usa_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Miráitana Peroma Abaramma áyarena tiraiye, “Emá nóra umatikano? Nóraitawa emá íma enánáre teq timatimikano? ");
INSERT INTO usa_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Nóra-itawa emá wetaba ketímánáre tenara, ‘kemá awiqma ketínári urauno’? Abo îbeqa manna enánáqibo, awiqme kówao!” ");
INSERT INTO usa_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Abo Peroma wení anó kayuka timayimitata yerawáqá Abaramma wakuyakawana wení aanakara máten otakaraq kemayena kouraiye. ");
INSERT INTO usa_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Abo Abaram maréna Ítípike Négíbi utaiye, wenánákara mátetataqo wemó makai-kara, abo Roti wete utaiye. ");
INSERT INTO usa_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Abaram anón otanaqa aukaiye, wanitibi wakara, yaugara. ");
INSERT INTO usa_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Mi maruqa Négibikemma wemá maréna marutaba marutaba wéqéna Betel kaya (2) marukóni aukapi (Bétérikaraq Ái) emó-urai nakumorakaraq, yaaremo tarourai marukaq. ");
INSERT INTO usa_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","Abo mikáqá wemá Yawe Îtogoka monoqá tiyakaraiye. ");
INSERT INTO usa_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Abo Roti Abaramtemo uréré-émaimma wegáráq, poiyamma, wení nétuya yuwaiq-namma makaiye. ");
INSERT INTO usa_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Abo yenákámó mi-mórábímmó maiyoyamma íma marago kanaraq umayikaraiye, yenákátí kurubi wákáwáqá anó powata íma mimorabi mae-waniq uráye. ");
INSERT INTO usa_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Abo uniti áiqaimma Abaramte Rotini mayai wayukati aukapi páquraiye. Mi kánábímmá Kénánni wayukagaraq, Pérégít wayuka yeráwákáráq mi marabi máqe-urae. ");
INSERT INTO usa_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Abo Abaram Rotitaba tiráiye, “Kerátámá morá-naemuye, kerátátí aukapikaraq, kerátátí mayai kayukabimma, keta uniti áiqaimma íma ténátae. ");
INSERT INTO usa_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Anó maranamma kerátáyábá paa-maiye. Miráipowaka kerátá ókaoka-óyúye. Emá ayáánepaq winaqá kemá ayáánurapaq wonune. Emó áyáánurapaqo winaqá, kemá ayáánepaq wonune.” ");
INSERT INTO usa_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Roti múte aonama Yótén máte aruma nonárári-uráitana abo aonaraiye. Yawe Îtogoni yoka (Ítén yomma) éna Ítípíq Naer arura itana aonama Yówa aukapa-yukaiye. (Minna-íma Yawe Îtogoma Totomkaraq Komoraqa yikamma tawitawa urai-tupae.) ");
INSERT INTO usa_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Abo Rotima wetábá mátemma Yotenni aruma auyatuwena abo maréna aabaumo utai ááyápáq uraiye. Mikáké kaya (2) naka kúyotoqo émáyámma yatáqma ókaoka-uraye. ");
INSERT INTO usa_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Abaram Kénánni marara maitana, abo Rotima aru marukarawa-koni aukapi Yóten arugomma Tótom waqoka mainena wení nétuya terinamma uraiye. ");
INSERT INTO usa_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Totom wayuka anómma Yawe Îtogoka tawi aaima ke-eta kumiq aaima uyakarae. ");
INSERT INTO usa_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Rotima ayuwéna Abarammo kégoimma, Yawe Îtogo Abaramtaba tiráiye, “Múte auramma aonama áubáqá, anaaépaqa, aayánepaqa, aayánurapaqa, máte aukapaqa máánarakemma aonao. ");
INSERT INTO usa_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Mi-máte márámó emó aonanna kemá, ení iyápórawakaraq emá ákapaq aménúne. ");
INSERT INTO usa_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Kemá ení íyápó-anna mama taíbariq-ona maragoni káitora íyáta abo íma wayuka yorautinoe. ");
INSERT INTO usa_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Kómare-keewe maragoni ayátákaraq wení awaraqa kemó îbeqo emmó amunna marama aonao.” ");
INSERT INTO usa_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Miráitana Abaram wení netuya térínámmá yawítímena maréna Mamrini anó owak yarawakoni waqoka Íbáróni mainena uraiye. Mikaq Yawe Îtogoka yaare tarouraiye. ");
INSERT INTO usa_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","9","Mi-kánábímmá tiyaakagaraq kaya (12) aukomma Kinirawakaraq yetí wayuka Ketoraomani aménápá maqe-urammanibo tiyaakagaraq kaumo (13) auqo keimma yeráwáqá Ketoraomama aaiqa uyakaneta-urae. Móra-tiyapa (5) kinirawaqa yetí áái-wayukate yagarotareta Títími arubi aikutae, (Mipimma karakébarai unokoni arubine). Tiyaakagaraq kayaté kayate aukomma (1) Ketoraomagaraq kinirawaqa kaumo (3) ano maruka kíníráwáté yagarotareta aaiqa-umá móra tiyapa kini-rawaqa kótárae, repaim kayuka Átíróti Kanaim-kene, Yutim kayuka Amkene, Imini kayuka Kíríatam arubikékáráq. Orim kayuka Tiya aita marukake abo maréta yeráwáqá Eriparani kammáq-makoni awaba waqókáq áwátáq-urae. Mikákémó yemó yauwékámmá maréta tiyánepaq En-Mitiba yirae (mimaruqa îbeqa Katetire kete) abo yeráwáqá Áméréki kayukati máte-maragaraq abo mirauma Ámóri kayukamo Ayayona Tamaqo máqe-mamma yikama-táwitawa-urae. Abo Tótómqo, Kómóraqo, Ámaqo, Yiboikaraq, Berati kinirawaqa yetí aiwayukate yakarotareta Títími arubi aaiqa yokauma yitauqa-yuqmeta yaurae, Érémqo, Koimiqo, Tinakaraq Éráti kinirawaqa aaiqa umáyikaneta, móra tiyapa (5) kinirawaqa kayaté-kayate (4) kinirawaqa umayikaneta. Amurapema Tína waykatí kinie, Ariokima Éráti kayukati kinie, Ketoraoma Éréma kayukatí kinie, abo Titarima Kóími kayukatí kinie, Mami káyáté-káyáté (4) kíníráwáqá maréta-wurae móra-tiyapa (5) kinirawaqa aaiqa umayikaneta. Mi kíníráwáqá, Berae Tótom kayukatí kinie, Timepae Yíboi kayukati kinie, abo Berae Yowa kayukatí kinie. ");
INSERT INTO usa_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Títim arubimma ano kaaweq maikaraoko óriq uraitana abo minnamo Tótomkaraq Kómóra kinirawaqo kówata mátemma péqmareta anubata-owata, abo yaaima wayukarawaqa kaaweq maiqnobata metéqéta-ureta minnobaq pukae. ");
INSERT INTO usa_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Kayaté-kayate (4) kinirawaqa Tótómkara Kómóra kayukatí máte-otakaraq, máte-awaqa maméta kourae. ");
INSERT INTO usa_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Yeráwáqá Rotimma Abaramni anówaiko-powata wení ótakaraq wemma awíkae Tótom máqe-emaitata. ");
INSERT INTO usa_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Móramo (1) peqmarena yiwaigomma, Íbaru naaqa Abaramma timamikaiye máte-naimo paqima. Mikánábímmá Abaram Mámrini anó owaka yarawakoni waqoka máqe-uraiye (Mamri Amori nare). Mámri aunabakarata kayaqá (2) yikaraiye, Etikorogaraq Ana. Mami kaumo (3) watanonnama Abaramte yakarotáráe. ");
INSERT INTO usa_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Abo Abaramma wení anabaomma awíqma yetí anna-naka urae, mami-naimo keitena wemá kaumo ateretikaraq tiyaakagaraq eitiqa (318) aaiqa-iwayuka mátemma wení naaupaqo páquramma yááyama aikutena, abo Téni waoka uréta yetí namuro kayaté-kayate (4) kinirawaqa wakae. ");
INSERT INTO usa_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Noka-nawataqa Abaramma wení aai wayuka yaika-umá-yíkárena yíkaminena-itata kayaté-kayate (4) kinirawakaraq yetí aai wayuka péráwana Abaramma waqmena mirauma Ópa tiyánepaq aukapaq Támátikati koyarae. ");
INSERT INTO usa_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Abaramma yauweqma máte notakaraq, Rotigaraq, wení ótakarate, aararaókáráq, yaimma wayukagaraq, yiwikaiye. ");
INSERT INTO usa_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Abarammo aaiqo-umámo Ketoraomakaraq wetémo yakarotará kinirawaqa kégotamatuwaimma, Tótomuke kinigo Abaramma Taba arubi yiréna aonaraiye (minna kinirawati aruwe). ");
INSERT INTO usa_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Miráitana Tárem kayukatí kinigo Metiterekimma aawakaraq wáénigaraq Abaramma mamá-ámíkaiye. Métítérékima uyátámaqma Îtogoni mono-naaupaq mayai-naare. ");
INSERT INTO usa_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Métítéréki Abaramma atimuqá-uyakena tiraiye, “Uyátámaqma Îtogo maragárá wîyomo taroqurai Îtogo Abaramma iráqoni-uyakaniye. ");
INSERT INTO usa_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Amuramu-uyákao uyátámaqma Îtogoma noitababiyabo wemó aawaqna-ita abo aaiqo-umá ení namuro kótámakonna-aitaba.” Miráitana Abaramma máte-tatapikemma, móramora (1) máte-tiyaakabikemma Métítérékimma amikaiye. ");
INSERT INTO usa_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Tótomke kinigo Abaramtaba tiráiye, “Wayukarawaqa ketime mátetataqa etábá mayao”. ");
INSERT INTO usa_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Abaramma anonna-uraiye, “Kemá uyátámaqma Yawe Îtogoka ketí tiyaamma tikaq maraune, wîyokaraq maramó taroq-urai Îtogoka abo kemá araimma-tiyakaune, ");
INSERT INTO usa_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","Kemá íma-mórayataqa (1) ketábá mayánúne, íma móraqamma (1) keboqya tatagarare, kemá óta-naaqa aurakaune wemá timáti-kaiyaba. ");
INSERT INTO usa_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Kemá kimmora ketí aaiq wayukamo nátúwá nawaka kanaráré-ténúne. Abo náwamo ketémo uraiyamma Ánamo, Étíkoragaraq Mamri paa yiyuwaiyata yeráwátí ótamma-máyátao.” ");
INSERT INTO usa_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Aaiqa umá ánátatuwena Abaram yitana, Yawe Îtogo kainapaq wekáq páquma tiráiye. “Íma ikatí-uwo kemá ení weyure abo ení amuyataqa anón-uramma aménúne.” ");
INSERT INTO usa_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Mirátitana Abaram téna, “Anómo uyátámamma Yawe Îtogo nóina emá timinónó kemá íma iyápó makaunabowana Éréyáti Tamatikatike ketí máte notamma kemó makaunna mayáníye?” ");
INSERT INTO usa_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Abo Abaram téna, “Emá íma iyápó timikanabowana ketí mayái naako ótamma abowání-iniye.” ");
INSERT INTO usa_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Miráitana Yawe Îtogo Abaramtaba tiráiye, “Minaaqa íma abowání inibo enarupiké ení iyápógo máte notama abowání iniye.” ");
INSERT INTO usa_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Yawe Îtogo Abaramma awiqmena máápa Abaramma yaubarena abo timámíkaiye, “Mute aabayápáq wîyokarawaqa aonama abo yorautuo, kanarárá yorautínónópo.” Abo wemá timámíkaiye, “Ení iyápó-anna mirárá-ínóe.” ");
INSERT INTO usa_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Abaram Yawe Îtogotaba araine-tiyákáitana, mináítábá Îtogo Abaramtaba arupúnáre tiraiye. ");
INSERT INTO usa_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Yawe Îtogo ókaraq Abaramtaba tiráiye, “Kemá Yawe Îtogomo Úúqo Kárítián-kayukabike mami márá áména abowání-ikaeteq awiqme-iraune.” ");
INSERT INTO usa_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Abo Abaram ítáráiye, “Anommo uyátámáqma Yawe Îtogo, kemá mami márámó araimma abowáníqo-onunna, naara-umá itéqa-óné-onuno?” ");
INSERT INTO usa_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Yawe Îtogo anónná-uráiye, “Nateqá purumakakáráq, mémekaraq, awai típítípíkáráq mátemma kaummo (3) áúqó-uráiyamma mamé-iyo. Óqa máágárá, paaya numa mamé-iyo.” ");
INSERT INTO usa_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Abaram mimátémmá maména wekaq-iráiye, abo Abaramma máte kamma aukapike ataqma ókaoka-uráiye. Numarátámá paa-yukaiye. ");
INSERT INTO usa_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Abo akikíráókómá arabéna kúmókumo mami áráq wákátábá itana Abaram yikamma wáréwara-uráiye. ");
INSERT INTO usa_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Minnámo aabaumo kuqperaitana Abaram púkímma-waguráitana mikákékámmá anó kumayuyatako wemmá yawaq-uyakaraiye. ");
INSERT INTO usa_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Mikaq Yawe Îtogo Abaramka tiráiye, “Ení iyápó-anna óq marabi namu-wayukara ínówe, mi-marabi kayukati kakobe maiyata kayaté-kayate antreti (400) auqa tai aaima-umáyikainowe. ");
INSERT INTO usa_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Miráíyaq kemá mi káyúkámó kákóbérammo náyumo umáyikaiyamma meyámma ánná-yíménata abo mikákémmá ení iyápó-anna anó notakaraq mi márúqá yuwéta yawinowe. ");
INSERT INTO usa_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Abo emá (Abaramtaba téna) amurámuyatapi ayátágana matuwé emá púyínata abo utayákainowe. ");
INSERT INTO usa_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Kayaté-kayate antareti (400) auqa yáwínata ení iyápó-annama yauwéqme Kéinan yinowe mina Amoraiti kayukati kumi-aaimmo yemo-uramma íma ari-uráiye.” ");
INSERT INTO usa_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Minnámo aabaumo kupéráimma kumayuqá áúráitana Abaram aonaimma úmúpi iragó-tinibike irá-kamá yupayo-umáena kéqókéq wámmó Abarammo karama yáíka-umárái aukapi yáuraiye. ");
INSERT INTO usa_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Mitáo Yawe Îtogo Abaramte aamá tima-yarutuwena mirá-tiráiye, “Kemá Ítípike nokómmá maréna Ípáráiti anoo nokaq mami márá ení iyápó-anna yiménúne, ");
INSERT INTO usa_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","Kéni anna-kayukae, Kénat anna-kayukae, Kátmon anna-kayukae, ");
INSERT INTO usa_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","Éti anna-kayukae, Périt anna-kayukae, Répa anna-kayukae, ");
INSERT INTO usa_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","Ámóri anna-kayukae, Kéinan anna-kayukae, Kírígati anna-kayukagaraq Yébuti anna-kayukatí maramá kemá aménúne.” ");
INSERT INTO usa_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Anyie-téna, Abaramma aanako Tárái íma iyápó aakama amewani-uráiye. Miráitana Tárái wení mayai inaru Ítípike aawiqa Aagamma makaiye. ");
INSERT INTO usa_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Abo wemá Abaram-taba téna, “Yawe Îtogo iyápómo akáímó anamoriq umatikaiye. Uréya ketí mayai inarukote waténana iyápó ákáma timíno.” Abaram kanaráré téna, Táráitaba tiráiye. ");
INSERT INTO usa_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Abo Abaram Kéinan tiyááka (10) auqa umátúwaitana wení aanako Tárái Ítípike wení mayai inaruma Aagamma awíqma awaikomma amikaiye. ");
INSERT INTO usa_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Abaram Ágate wataitana, Ága amukarari uráiye. Minnámo Ágamo amukarariqo kéena wení ánákomma Taraimma aonama wemá mémápáq-yukaiye. ");
INSERT INTO usa_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Miráitana, Tarai Abaramtaba tiraiye, “Emá mami úqmá abowání inone, kemó mamirámó Ágamo umatikaimma kemá ketí mayai inaruma enayápi makaunana, abo íbêqa wemá aonaimma amukarariqo ikakemma aumamé-uyéna kemmá aonama wemá mémápá yuwaiye. Yawe Îtogo eqkáráq keqkaraq aukapi yainaniye. ");
INSERT INTO usa_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","“Ení mayai inaruma enayáápi maiye,” Abaram tiráiye. “Nóra-áaimmo auyanammo íténanamo kanaaraqo ína-áaimma umákao.” Tarai tai áainuramma taroqumákáítana, Ága ayuwéna kouraiye. ");
INSERT INTO usa_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Yawe Îtogoní énítóré (30) Ágamma kaqmáápa poqnokóní waqókaq aonaraiye. Mi póqnómmá, Túwa wí-áákóní aukapaq waiye. ");
INSERT INTO usa_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Énítóreko téna, “Ágao, Tarainí mayai inarugo emá nákakena iréya, nákaraq kewono?” “Kemá ketí kawaa inimma Táráinopake péqmare kégoune,” Ága anónná-uraiye. ");
INSERT INTO usa_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Mirá-titana, Yawe Îtogoní énítóreko wemmá timámíkaiye, “Yauwéqma Táráinopaq uréya abo wení aamá waraao.” ");
INSERT INTO usa_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Ókaraqa Yawe Îtogoní énítóreko tiráiye, “Kemá ení iyápó-anna mama néturiq umáyíkánata íma wayuka yorautinoe.” ");
INSERT INTO usa_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Yawe Îtogoní énítóreko keqnámmá Ágataba tiráiye, “Amukaraq emá íbêqa mannabowa emá inamaí akainone. Emá Ítímairiye-te áwîqa yamamiyo, mináaitaba Yawe Îtogo ení uqmamá ítáyamena emmá áwáqnaiye. ");
INSERT INTO usa_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Wemá Ítímairi abáq íyáká umá maniye, wemá máteq kayuka aaiqa umáyikainata abo máqte kayuka wemmá aaiqa uyákainoe, wemá nékaq ataaramá wení arainibike maniye. ");
INSERT INTO usa_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","“Yawe Îtogoma Aaga Er Roi awiqa amikaiye, minná miráténa, emá Îtogo kemmá timóné, abo yabitikane,” Agaa tiráiye. “Kemá íbêqa puqkónáq-únapike páá-maune, kemó timónai Îtogomma aónatuwaune.” ");
INSERT INTO usa_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Min áítábá, mi póqnókómmá Bíyá Ráqá Rói áwîqa keyae, Kátétikaraq Báréti marukoni aukapi íbêqa páá maiye. ");
INSERT INTO usa_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Miráitana, Aaga inámáí Abaramma ákáyamikaiye, abo Abaramma Ítímáiriye áwîqa miníyápógómmá yaamámikaiye. ");
INSERT INTO usa_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Abaram éítiqa tenigaraq móra tiyapakaraq móra (86) auqa keitana Aaga Ítímáirimma ákáyamikaiye. ");
INSERT INTO usa_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Ánibo Abarammo náinia tenigaraq náinia (99) auqo kéitana Yawe Îtogo wekáq páquréna tiráiye, “Kemá Îtogo Wenóqyae, máte-tataqó taroq-innapímmá kekáq amakakí-uréyá íráqó-maiyatapi máo. ");
INSERT INTO usa_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Kemá eté ketí aama-yarutuweka abo emá nétu íyápó-ánná aménúne.” ");
INSERT INTO usa_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Minnámo kéitena Abaramma óipake Îtogoka marabí awautaitana abo Îtogo tiráiye, ");
INSERT INTO usa_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“Kemó-itaqá pórómáti eté kemá umátuwaune. Emá nétuqya maruti yibowá máinone. ");
INSERT INTO usa_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Íma ókaraq Abaramue áwîqa yainowe, íbêqa ení augen áwîqa Abara-ámue. Kemá emmá nétuqya maruti yibowámó áúrákáúná áitaba, ");
INSERT INTO usa_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","kemá emmá maamá iyápó-anna néturiq uyákána mayáínóne, ení iyápó-annarawaqa anó maruqa áúráíyata abo kínirawaqa epíké páqinowe. ");
INSERT INTO usa_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Kemá ketí pórómáti yabíyénana matúmatu-íníye, eté ení iyápó-annaraokaraq abo yetí iyápórawate, kemá ekáráq ení iyápó-annarawatí Îto mánune. ");
INSERT INTO usa_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Máte Kéinan marabimmo íbêqo namuq nákáq-umá mánna kemá aménúne. Mi márá egáráq ení iyápó-annatí mara ákáqpaq aukiniye, abo kemá yeráwátí Îto mánune.” ");
INSERT INTO usa_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Abo Abara-ámma ókaraq Îtogo timámíkaiye, “Emá aamó-tima-yarumakaunnamo timámunna waraó, ekáráq ení iyápó-anna mikáqo páquqteta wínómma miráoro. ");
INSERT INTO usa_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Maminná ketí yarumata-aine eté abo ení iyápó-annamo, mamin aimmo-yarumatamma kéráwáqá yabíyéro: Máte inamáí árákáráwáqá ibôwáqá-umáyikao. ");
INSERT INTO usa_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Emá ení aukoni kebó-áúwárátí káráma awaméká-maraó abo mami áwáméqá kerátátí áúkápimmo timá-yarúmakauyane. ");
INSERT INTO usa_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Minnámo epikémmó máte inamái árákáráwáqó páquqteta-yínómma ibôwáqá-umáyikao náwamo éítiqa (8) kanamo-kéinna, náyumo ení náupaqo páquráiyammo, yaurákémmó ópaq nakake mayaniq-urénagaraq nayumo ímo epíkémmó páquráínae. ");
INSERT INTO usa_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Emá ibôwáqá-umáyikao nayumo ení náupaqo páquráinnakaraq, emó ení yaurakémmó meyání-uránae. Ketí yarumatan-naiko eté awaméká matúmatu-íníye. ");
INSERT INTO usa_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Náwamo ibôwáqó ímo-uráinna waraowaqa timákáíyata ketí wayukabike kóíno, wemá ketí yarumatan-aima arátuwaiye.” ");
INSERT INTO usa_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Îtogo ókaraq Abara-ámma timámíkaiye, “Íma emá ókaraq enánáqa Táráiye tiyó, íbêqa wenáwîqa Térae maniye. ");
INSERT INTO usa_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Kemá atimûqá-uyákánana abo wemá iyápó ákáma amíníye. Kemá atimûqá uyákánana abo minná wemá anó-marukarawatí yinówa mániye, kínirawaqa wení iyápó-annaraopike páqinowe.” ");
INSERT INTO usa_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Abara-ámma marabí ótípake awaúténa wíráke-ena abo we-áímmá tiráiye, “Kanaraq móra antareti (100) auqo-uráínna-nako iyápó máyání? Kanaráq Téra náínia teni (90) auqo-uráimma páá iyápó ákání?” ");
INSERT INTO usa_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Abo Abara-am Îtogomma ítáraiye, “Táyánámmá-itáúnna emá ketí iyápó Ítímaerima amammá ámínó?” ");
INSERT INTO usa_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Mirátitana Îtogo téna, “Ímiye, Téra inamáí akama amíníye, abo emá Áítíkiye-te yamáminone. Kemá weté ketí yarumakaunna-aimma maamá-páqonune, mami yarumata-aimma ekáráq ení iyápó-annabi matúmatu keráwáté iniye. ");
INSERT INTO usa_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Abo kemó Ítímaeritabamo itáúnama emmá ítáyamenune. Kemá áráimma íráqóni uyákanune. Kemá táíbaq améqa abo kemá ókaraq táíbaq iyápó anna aménúne. Wení tiyákagaraq kaya (12) íyápóráwáqá móramora ááiti-anómma auráíyana abo kemá maamá anó maruqa áúrakanune. ");
INSERT INTO usa_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Abo ketí yarumata-aimma kemá Áítíkite maamá páqonune, Térama mami kánárákémmá méyá áúkáq iyápó ákámá amíníye.” ");
INSERT INTO usa_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Minnámo Abara-ámtemo aamó timá-kánatatuwena Abara-ámma Îtogo áyukaiye. ");
INSERT INTO usa_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Mitáoq-uramma Abara-am Ítímaerimma káwirena, abo mátemmo waamo wení náupaqo páquraiyamma, meyákákémmó meyániq-uráíkaraq, mátemmo waamo wení náupaqo maemma wemá ibôwáqá umáyikaraiye Îtogomo timámíteniq. ");
INSERT INTO usa_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Abara-ámma náiniqa tenigaraq náiniqa (99) auqa-ke-ena ibôwáqá-uyákárae, ");
INSERT INTO usa_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","mikánáráqá wení ániko Ítímaeri tiyákagaraq kaummo (13) áúqá kéitana. ");
INSERT INTO usa_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Maaka mimórá kánáráq ibôwáqá-umáyikarae. ");
INSERT INTO usa_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","Yáimma wayuka mátemma waamá ibôwáqá umáyikarae, Abara-ámni náupaqo páqura-nabiyo ópaqnakake meyániq-uráímma weté ibôwáqá umáyíkárae. ");
INSERT INTO usa_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Yawe Îtogo anón owak tarawakoní ááikaq Mámari Abara-amka páqurai aine. Abara-am wení térinakoní oqta-ákáq aanónaqo-kamákenamo-íkaq maramáqe-uráiye. ");
INSERT INTO usa_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Abara-ám múte aónaimma kaumo (3) káyúká áúbáq itó-umakurae, minnámo kéyimonena wení térinamma yuwéna uyaténa koyimónarena, abo yeráwáká koma-marabí awáútaiye kayoné-áimma yirátiraiye. ");
INSERT INTO usa_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","Abara-ám móra waikotaba (1) mirátiráiye, “Ketí Anóko, kanaráq íráqóáimma-tirátima makáq ketí náoq máíyaq kemá tíwáqnaonó. Íma ení mayai-naqa kótao. ");
INSERT INTO usa_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Nommá kemá maméq-yená abo emá áítauqa tetekéya ma yágóní ááipi agao. ");
INSERT INTO usa_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Kemá ááwáqa maméq-mátímenaraq keráwáqá namá aqkonná-umátuweraq mikákémmá páá keráwátí ammá wínówe. Ketí naoqa yiráneteq kemá timurámu-maráune.” “Katekowé-íráqone,” yeráwáqá anónná-urae, “emó ónae-tinaiq uwo.” ");
INSERT INTO usa_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Abara-ám uyaténa térinaupaq uyápékurena Térámma timámíkaiye, “Kabequmá kaumo (3) tápéqa páráwaqa yaqmáwaq paretiráwáqá agayaó.” ");
INSERT INTO usa_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Abo wemá Abara-ámma uyaténa nákaqo wení purumakakáráwáqó mápaq-uréna abo móra (1) íbêyamma áínóara purumakamma áúyakaiye, kabeqitana Abara-ám wení mayai-naqa amitana wemá ikamma abo ááwáqa yokaaurae. ");
INSERT INTO usa_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Aqa ááwáqo yokaakeimma, Abara-ám ikaq nánánókáráq, auke nananokara abo purumakammo agama yokaaumátakaraq maména mamin ááwáqá máyímíkaiye. Minááwáqó-kénámmá Abara-ám itoumá yagóní áipi yetí waqokqa maena-yiwe-uraiye. ");
INSERT INTO usa_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","“Nákaraq enánáqa Téra maiyo?” yeráwáqá wemmá ítárae. “Térinaupaq maiye,” tiráiye. ");
INSERT INTO usa_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Mami kaumo (3) namu-wayukabike móra-waigo (1) Abara-ámtaba téna, “Kemá yauwémma mamirá-kánáráq méyá-náúkáq yénúne, abo enánáqa Téra iyápó mayaniye mi-kánáráqá.” Téra yinaepaq térinakoní otaraq maena ítáraiye. ");
INSERT INTO usa_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Mááka Abara-ámkaraq Téra áqa wayuka-ariqa aukuraye, abo Térama araqná-urapowana imá iyápó ákáwani-uráiye. ");
INSERT INTO usa_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Mirátitana Téra áúyánámá-kéitena wetábá wírá-uráiye. “Máákakorata wayuka-ariq aukurauye íma iyápó ákawaniq-uraubo kemá íbêqa iyápó akánú?” ");
INSERT INTO usa_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Yawe Îtogo Abara-ámma ítaraiye, “Nóra-itanawá Téra wírá-kenawa téna kemá araimma iyápó akánú, íbêqo kemó araqnámo aukúnnapikemma? ");
INSERT INTO usa_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Kemá Yawe Îtogoma íma mórayatako ummáyátikaniye. Kemá yauwéqma enopaq timákáúnna kana méyá áúká yenana abo Térama inamáí íyápó mayaniye.” ");
INSERT INTO usa_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Téra ikatíq-éna, “Íma wira-uraune téna,” kaqarí-tiráiye. Abo Yawe Îtogo téna, “Araimma emá wírá-uráne.” ");
INSERT INTO usa_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Mi káúmó (3) námú wáyúkámó itóuma kóinekéta yeráwáqá márúte yuqmá Tótóm aónarae, abo Abara-ám apaq yiyuwáínéna maréna yeráwáté uráiye. ");
INSERT INTO usa_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Minnámo maréta kéwowana, Yawe Îtogo wenáúyánánóbáq tiráiye, “Kemá kanaráq Abara-ámma yawáq-uyakanu kemó nóratatariqo ónúnna. ");
INSERT INTO usa_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Ímiye, nóínaitabiyabo Abara-ám anó imamukaraq marukarawatí yubiqá áráimma maniye, abo wetábáétéq máte marukarawakomma ma-márábímmá íráqoni umáyikanune. ");
INSERT INTO usa_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Kemá áqa wemmá tiyákátukaun-nabowana wemá wení iyápó-anna timáyiminata ketáá warainówe, yeráwáqá íráqon-aikaraq abo tágamayatari-oró. Miráíyana Yawe Îtogo Abara-ámmo wemó tiyákáraimma aminiye. ");
INSERT INTO usa_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Abo Yawe Îtogo Abara-ámma timámíkaiye, “Kemá Tótómkaraq Kómórati anónibiqa yáqyiqkámma itaune, yetí kúmi-áiko anóni-umá táwítawa-iye. ");
INSERT INTO usa_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Miráipowaqa kemá kukéq aónanune ááraimmo yetí táí áimmo taróqómma. ");
INSERT INTO usa_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Mikákémmá kaya (2) námúnákárátá Tótóm aukapaq wuráye abo Yawe Îtogo Abara-ámte páá mikáq máqe-uraiye. ");
INSERT INTO usa_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Abara-ám Yawe Îtogoní waqókáq yiréna ítáraiye, “Emá ááraimma kateko wayukate táwí wayuka yíkamino? ");
INSERT INTO usa_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Minnámo móra-tiyapaq tiyáka (50) kateko wayukamo máraiyamma, emá páá máte kayuka yíkame abo emá íyaq mami kátékó wáyúkátí áitaba yiwimmá kamayikaino? ");
INSERT INTO usa_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Ímiye, kúmiq wayukamo yíkaminema emá íma kateko wayukagaraq yikaminone, kúmiq wayukate kateko wayuka íma mimmóráwáí úqmá mayainowe. Emá íma mirárá-ínóne, kímmora (1) nááwamo mamárábí máte kayukamo yainánimma emá maane. Emá íráqón-áimma taróq-ínóne.” ");
INSERT INTO usa_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Yawe Îtogo anónná-uráiye, “Yeráwátábáé-téq íma kemá yíkamonune.” ");
INSERT INTO usa_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Abara-ámma yauwéqma Yawe Îtogotaba tiráiye, “Kemá íbêqa Anókote aámá ténáq íma ikátí-une, kemá pátátáune, káítóra-uráúne. ");
INSERT INTO usa_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Minnámo móra-tiyapaq (5) imó-maatabawte, kanaraq máte kayukate mami káyúká yíkamino?” Yawe Îtogo anónná-uráiye, kemá aónánana kayaté-kayate tiyakagaraq móra-tiyapaq (45) wayukamo maiyaqa, kemá íma yíkamonune. ");
INSERT INTO usa_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Móragaraq Abara-ám Yawe Îtogomma ítáraiye, “Abo kayatá-kayate tiyaka (40) wayukamo maiya emá náraq ínónó?” Yawe Îtogo téna, “Kayaté-kayate tiyaka (40) wayukayabaetéq íma kemá yíkamonune.” ");
INSERT INTO usa_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Abara-ám téna, “Kanaráqibo, Anóko íma áyataba umátike tiyúwénaq ókaraq emmá ítáno, emá náraq-ínónó minnámo kaumo tíyáká (30) kátékó wáyúkámó maraiyama?” Yawe Îtogo anónna-uráiye, “Kemó aónánanamo kaumo tíyáká (30) wáyúkámó maiyaqa kemá íma óqa yíkamonune” ");
INSERT INTO usa_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Abara-ám Yawe Îtogomma ítáraiye, “Kemá íma ikatí-éqa ókaraq aamáitanáq-úne, emá náraq umáyikainono minnámo kaya tíyáká (20) kátékó wáyúkámó mi márúpímmó maiyama?” Yawe Îtogo wemmá anónná-uráiye, “Mami káyáa tíyáká (20) kátékó wáyúkátí áitabae-téq íma kemá yíkamonune.” ");
INSERT INTO usa_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Ókaraq Abara-ám Yawe Îtogomma ítáraiye, “Kanaráré, Anókó íma ááyáqa-timiyó, tiyúwénaq paki mórákaraq ítáno. Náraq emá ínónó, tiyaka (10) wayuka-urammo mi márúpímmó maiya?” Yawe Îtogo anónná-uráiye, “Páá tiyáka-urammo (10) kateko wayuka mi márúpímmá maiyamma kemá íma yíkamonune.” ");
INSERT INTO usa_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Yawe Îtogo Abara-ámte aamo témáyámma kánatena, wemá mi márúqá kéyuwaimma Abara-ám yauwéqma naópaq kóuraiye. ");
INSERT INTO usa_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Mi énáíkáq kaya (2) énítórékó Tótóm kóyáráye. Rótima Tótóm marukomma uyáperai ákáq maraqmáqe uráiye. Minnámo kaya (2) énítóré-rátámó kéyimonenama ítoumá yenákátópaqa uréna wemá marabi ótipake yenákáráq awáutaye. ");
INSERT INTO usa_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","Rótí téna, “Timuqá-matikáúne ketí anókoratae. Ketí naaupa yekao. Kenáká títauqa tete-kékaq keté watáíyaq abo abéya máí nókápáq kenákátí ammá wiyoye.” Kaya (2) énítóré kórátá téta, “Ímiye, kerátá makáq máte kayukamo kaikuyo marukaq wáéyúye.” ");
INSERT INTO usa_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Mirá-kéteyataba Róti aqkonna-umá kétitaba yenáká maréta Rótite abo wení naaupaq koyaráye. Róti yenákátí ááwáqa yoká-umá abo (íma itoráí káná íma mai) pareti agamá yímítata naráe. ");
INSERT INTO usa_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Kaya (2) énítóré kórátá yú-waiyeta kéoyana máte wayanammá Tótómkemma, mapukáráq wayúka ariqa Rótiní nammá yáútúraq-umákae. ");
INSERT INTO usa_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Mami káyúká Rótimma áyarae, “Nákaraq kaya (2) námú-nákárátá enópaqo yéyamma mááyo? Naaupake yiwíqma máápaq yukénata yenákáté ketáá aaraukáríq onnatáó.” ");
INSERT INTO usa_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Róti yimónaibaq máápaq yáúbarena abo anaépake oqtá áúyakaiye. ");
INSERT INTO usa_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","Róti téna, “Ímiye, ketí wayukama, íma tai-áimma taroqoro.” ");
INSERT INTO usa_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Aónaro, kemá kaya (2) ínárú íma waté watayamma yíkáraune. Yukaiyaq kemá yimíqma máápaq márúte-tímíkanaq abo keráwáqá nówaitataqo tikáínna yeráwáté oro. Abo ketí namu náká íma moráyatariq umáyíkaro. Ketí naaupaq yiráyapowaqa yabíq-yikanune.” ");
INSERT INTO usa_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Abo yeráwáqá mirátirae, “Páábaq yááwao oqtarákémmá,” yeráwáqá téta. “Rótima íma maruq áinare. Abo íbêqa wemá ketáti kawáá máínénábiyo! Ketá yenáká kótámamqma emmá táwí-áaimma uyákanunatae.” Mirákéteta innene-umá Rótimma abúbúqma maré-kéwéta oqtá yokiránéta-urae. ");
INSERT INTO usa_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Mirámó-kéomma kaya (2) énítóré kórátá oqtaráké Rótimma yabitimá yauwéqma naaupaq kéyuweta oqtá áúyatukaye. ");
INSERT INTO usa_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Mi káyá (2) énítóré kórátá máte wayuka oqtaráqó mááqe-émámma maabukáráq wayuka ariqa maamá kumayuriq umáyíkáítata yeráwáqá íma oqta aónarae. ");
INSERT INTO usa_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Kaya (2) énítóré kórátá Rótitaba téta, “Íyaq emá yaimma anna wayuka maapi Tótóm maqa yíkárano, mirauma enairó-utama, ení ánimaqa enayámummaqa yaimma ení arainibíkémmá?” Máraiya-moema yiwíqme mamipíké kóró. ");
INSERT INTO usa_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","Kerátáa mami-márúqá maamá táwítawa-óyúye. Yawe Îtogo Tótóm kayukati ááyama ibiq-aimmo yaqyíkamma ítáímma anóni itana timátíkaitaka mami-márúqá maamá táwítawa-óyakae. ");
INSERT INTO usa_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Miráketeyataba, Róti maréna uréna wení ayamummatí aanabo-íyápóráóqá timáyímíkaiye. Róti téna, “Uyatéraq ma márúqá yúwaro, Yawe Îtogo áqa ma márúqá maamá táwítawa-ínékeiye!” Abo wení ayamummatí aanabo-íyápóráóqá ábê-aimma kétiye-téta yúyánápí tirae. ");
INSERT INTO usa_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Iráqma-tágaimma, kaya (2) énítóré kórátá Rótimma yokage-umá timámena, “Uyaté enánákaraq enayámúmmaqa yiwíqme kówao, ímo-iteqoweqa keráwákáráq Tótóm marukote aweké mayainówe.” ");
INSERT INTO usa_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Abo Rótimo mayámaramo kéimma, kaya (2) énítóré kórátá Rótimma ayákaqa yátoqma ánákokaraq, wení kaya (2) áyámúmmá yiwíqme yokege-umá Tótómke máápaq yáúbaraiye. Yawe Îtogo yeráwáqá áyáqa yímíkaiye. ");
INSERT INTO usa_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Minnámo kaya (2) énítóré kórátá yiwíqma máápaqo kéyiyuwena, móra (1) enitoreko téna, “Uyatéraq keráwátí túyaba kóro. Íma wáéqma aónaro, íma móra-aakapáqá mami árúbáqá agaro!” ");
INSERT INTO usa_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Abo Rótima anónna umá-téna, “Ímiye ketí anóko, timuqá-marakáúne. ");
INSERT INTO usa_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Emá íráqonni umátike abo emá anómma iraqon áimma ketí tááraqo yabítíkánna tiráténé. Abo kemá íma anubaqá uyónúne. Kemá mamin úmágó aapaq yátóráínaq puyónúne. ");
INSERT INTO usa_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Képi keboqyá maruqa aónao, íma népáq-urane, tiyúwéna péqmare mi kébóqyá márúkáqá wono. Miraonana kekáq puiyataqa íma yíkae.” ");
INSERT INTO usa_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Móra (1) enitoreko Rótitaba téna, “Kateko-úráné, kemá enááraqa kanaráré-tiyakaune. Emó ténná maruqa íma maamá-táwítawa onune. ");
INSERT INTO usa_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Ánibo uyaté-péqmare kówao mi marukaq. Kemá íma móra-yatariq urána emá mi márúkáqá kówao.” (Rótimo peqmarenamo urai marukoni áwîqa Yowa) ");
INSERT INTO usa_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Róti Yówa koyaitana áábáúmá utaráiye. ");
INSERT INTO usa_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Miráitana Yawe Îtogo wíyôpake iragáráq kawabába-oqtamma yúwaitana Tótómkaraq Kómóra kukaiye. ");
INSERT INTO usa_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Yawe Îtogo máte maruqa agamá táwítawa-uráiye, Yóten arukaraq wayukamo mi márúpímmó máékaraq, mátetataqo mi márábimmó waimma. ");
INSERT INTO usa_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Miramo-kéimma Rótiní ánáko anaepaq waéqma aónaimma, wemá maamá úgórá-ótákáq umákuraiye. ");
INSERT INTO usa_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Máí nókápáqá Abara-am itóurena yauwéqma Yawe Îtogokaq watá-tirái marukaqa-uráiye. ");
INSERT INTO usa_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Abara-ám márúte aónaimma Tótómkaraq Kómóraqa, Yóten arubimma abo máte marama aónaraiye, abo irabíkéká-umá anó-kairaya umumma mi márábíkémmá utaimma aónaraiye. ");
INSERT INTO usa_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Abo Îtogomo mi árúmáqá táwítawa kéumatuwena Abara-ámma áúyánámá-ítáyamikaiye, ááka-itana Îtogo Tótómkaraq Kómóra maruqo táwítawa kéena Rótimma áwîqma máápaq ayuwáitana íma aweké mataiye. ");
INSERT INTO usa_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Róti wení kaya (2) ayamukorátáté Yówa maiyaba ikatíqéna yeráóqá anubaq mainena utaiye. Wegáráq wení kaya (2) ayamukote muríánnóbáqá máqe-urae. ");
INSERT INTO usa_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Mórataoqa (1) ananowáá aukotaba téna, “Ketiborátá anónuqma-kaiye, mamarabi aaimmá máte-marabaqa, kerátáté mainomma íma-wá-mae. ");
INSERT INTO usa_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Kerátá táínomma ketibokárátá amiqma neginági uyákátuwekaq weté watéka iyápó mayáyúye.” ");
INSERT INTO usa_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Mi nókámmá yibowámma táínomma yenáká ámítuweta, ananowá maréna weté watáiye. Yibowá Róti wetemo waimma íma iteone-uráiye. ");
INSERT INTO usa_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Méyá mi énáíkáqa ananowá aukotaba téna, “Énai nokamma, kemá ketiboté wataune, kéqnamma íbê-nokamma kerátá táinomma amiqma neginági uyákátuwaya abo emá ure weté waténaka wekáké iyápó mayao.” ");
INSERT INTO usa_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Mi nókámmá kéqnamma táínomma yibowámmá ámímma neginági uyákátuweta, áukonaqa maréna abowáte wataiye. Kéqnamma yibowámá nóraq-oyamma íma itéone-uráiye. ");
INSERT INTO usa_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Miráútuweta kaya (2) ánánókórátá yibowákáké yímukarariq-uráye. ");
INSERT INTO usa_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Ananowámá inamáí ákáma abo Móáp awiqa ámikaye. Móap kayukati yibowá íbêqa-maiye. ");
INSERT INTO usa_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Áúkoma miráuma inamáí ákáma Péqámi awiqa yamámíkaiye, Ámónaiti kayukatí yibowá íbêqa maiye. ");
INSERT INTO usa_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Abo Abara-ám Mámrikémma maréna Négébéq aukapaq koyaréna, Kátétikaraq Túr aukapi máqe-uráiye. Páqya-kana Abara-ám Kéra kémaena ");
INSERT INTO usa_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","abo mikáqá Abara-ámma wení ánáqa Térataba, wemá “Ketímánare,” tiráiye. Abo Ápímérék Kéra wayukati Kíni-bowana, wení mayai wayuka timáyíkáitata Téramma koma áwîqmeta yewana Ápíméréki mayákáraiye. ");
INSERT INTO usa_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Miráowata, móra (1) nókámma Îtogo Ápímérékikaq kainapáqá páquma timámíkaiye, “Emá puyínóne, emó aaramó awiránna áitaba. Min ínímmá waataké íníne.” ");
INSERT INTO usa_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Mirá-kétitaba, Ápímérékima Térani waqóká íma wuré-nabowana, mirá tiráiye. “Îtogo emá kanaraq kekáráq yepímmó ummamó-ímo mai-kayuka yíkámínono? ");
INSERT INTO usa_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Abara-ám kekáráq timátimena, Térataba ketímánare titanawaq, abo Térama timátimena Abara-ámtaba ketiyóbíye tiráiyo. Kemá táágama tuyanakake mamitátáqá taroquráunanibo kemá íma tai-áimma taroquráune.” ");
INSERT INTO usa_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Miráitana Îtogoma kainapáqá timámíkaiye. “Áraine, itéq-aoneq-uráune, emá táágama auyanakake mirá-uráne, miráitaq kemá íma emmá ayuwauna ketúrakaqa táí áimma taroq-uráne. Mináítábá, kemá íma emmá ayuwauna wete watáne. ");
INSERT INTO usa_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Ánibo waa ánáqibo yauwéqma tiyákenana awaikókáq wíno. Wemá ketí óyáúqnare, nunamummá wemá tiyákaina páá mainone. Ánibo, emó ímo yauwéqma awaikókáqó timá-kemoema egáráq ení wayukagaraq puyínóe.” ");
INSERT INTO usa_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Óóqa máí nókápáqá Ápímérék wení anó-kayuka yáyama áíkuyikarena Îtogo kainapáq máte-naimo timámímma timáyímíkaiye, wení anó-kayuka anómma ikatí-uráe. ");
INSERT INTO usa_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Abo Ápímérék Abara-ámma áyarena tiráiye, “Emá nóraq ketámmá umátíkáráno? Kemá íma móra táí-áima taroq-uyákáraupo. Minnámma emá kekáráq ketí anó-maruqa anó tigaeta mamiráumá timénó. Emá íma taroqówai áimma taroq-umátikane.” ");
INSERT INTO usa_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Abo Ápímérékima Abara-ámma ítáraiye, “Nóra náitabawa emá mamirámá-uránó?” ");
INSERT INTO usa_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Abara-ámma anónná-uráiye, “Kemá túyáánápí-téqa mami márúkáq wáyúká íma Îtogoní áqa áraimma ínópowata kemmá ketínákake tíkatuweta ketínaqa mayainóe tiráúne. ");
INSERT INTO usa_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Móra-aayapaqo-itannama árainuramma mami ínímmá ketímánare. Wemá ketibokákémmíbo, íma ketinókakene. Miráitana ketí náqa wemá áúkaiye. ");
INSERT INTO usa_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Minnámo Îtogomo timátimenamo, enaboní márúqa yuwé kówáo titaqá kemá Térataba téqa, ‘Nánaukapaqo wóyúyamma emá ketábá keti-yóbíye tiyó,’ Emó ení íráqó-náimno mamiráuma tirátine-moema.” ");
INSERT INTO usa_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Abo Ápímérékima, tipitípikaraq, purumakakáráq, mayai wayukama, aragáráq wagaraq Abara-ámma kámena abo wení ánáqa Téramma yauwéqma ámíkaiye. ");
INSERT INTO usa_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Mirá-umátuwena Ápíméréki tiráiye, “Máte maramo kemó yabiyúnna aónatuwe yuwé emó akáínnaraq nákaqo mánáetinaráq áúyatuwe abo máo.” ");
INSERT INTO usa_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Térataba wemá téna, “Kemá téniqa antreti (100) ara tauma enayóbímma kámune. Kemó tái-áimmo emmó taróq-uyákáunaraqo ayumí ení wayukatí yúrakaqa amúne. Epímmá íma aweke maiye.” ");
INSERT INTO usa_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Miráitana, Abara-ám Îtogokaqa nunamummá-titana, Îtogo Ápímérékigaraq wení ánákogaraq, wení mayai-inarurawaqa íráqónni umáyikaitata yauwéqma iyápó yíkárae. ");
INSERT INTO usa_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","Ápímérékimo Abara-ámni ánáqo mátai-náitaba Ápímérékiní aara-iyápó Yawe Îtogo máte yííyáqa auyatukai. ");
INSERT INTO usa_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Yawe Îtogo wemá tiráiteniq-umá Téramma atimuqá-aména abo wemá Abara-ámmo pórómátimo-uyákáraimma kíqna-uramma taróquráiye. ");
INSERT INTO usa_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Mi kánáráq-úrámmá Yawe Îtogo Abara-ámmo pórómati-uráimma, wemá anónuqma-áúráitana, Téra ámûkarariq-uréna inamáí ákáma amíkaiye. ");
INSERT INTO usa_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Téramo ákáyami iyapo Abara-ám Áítíkiye áwîqa yamámíkaiye. ");
INSERT INTO usa_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Abo Áítíkimo móra-tiyapakaraq kaumo (8) kánámó kéimma, Abara-ám Îtogomo timámíkaiteni-umá Áítíkimma ubayammá-uyákáraiye. ");
INSERT INTO usa_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Abara-ám ántárétiqa (100) auqa itana abo Áítíki wekáké páquraiye. ");
INSERT INTO usa_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Téra tiraiye, “Îtogo wirágara amurámu timiye, abo máte-wayukamo iyápómo kemó akáúnnamo minná-itétama kete yeráwáqá wíra-inówe.” ");
INSERT INTO usa_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Aniyeténa Téra tiráiye, “Íma-mórawaigo Abara-ámtaba téna kettaba min íyápó ákáyaminiye tiraim-manibo, kemá íbêqa Abara-ám anónumma áúráípi iyápó ákáyamune.” ");
INSERT INTO usa_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Áítíki anómma-auréna abo ááwáqa naraiye. Mi kánáráqó Áítíkimo naammo némaimma yuwéna ááwáqo kénaimma Abara-ám anó nawaqa agayákáraiye. ");
INSERT INTO usa_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Téra aónáima weni mayai-íníkóni ánimma Ítímáeri Áítíkimma wíra-uyákáraiye. ");
INSERT INTO usa_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Miráitana Terá Kówánai-tena Abara-ámtaba tiráiye, “Mi máyáí íníkáráq wení ánimma wárénata kótao, íma Ítímáeri ení ótamma ketánikote yaináníye.” ");
INSERT INTO usa_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Minnámo Téramo ti-náikómma mamá anómma Abara-ámuní auyanakoma táwítawa-uráiye, nói-náitababiyabo Ítímáerima wenáni-karaqiye. ");
INSERT INTO usa_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Abo Îtogo Abara-ámtaba tiráiye, “Íma emá umma-áúyánámmá itaó enánikotabakaraq ení mayai ínímmá. Nówai-naimmo Téramo tína itaó, nówai-náitababiyo Áítíkikake kemó pórómáti-uyákáraunna emá iyápó-anna mayáínóne. ");
INSERT INTO usa_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Kemá Ítímáerimma nétuqya iyápó áménana yeráwáqá abo mamá anó maruqa-páqinowe, minna wema enánipowana.” ");
INSERT INTO usa_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Máí-nókápáqá aabêyanapimma Abara-ám yáimma awakaraq nonáná-yaqmá maténa Ágámma amikaiye. Wemá Áganí aqnókáq kauyakéna abo tiyákáitana wení ánikote kóuraye. Ága wení ammá maréna abo amáyukara-umaena kaqmáqmaqa Bétíba waqokaq uráiye. ");
INSERT INTO usa_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Ábo anabíké nommá ánátakitana, Ága ánikomma karanóbáq apaq ayuwéna ");
INSERT INTO usa_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","abo wemá maré waqónáwátáq kéra-nékaka wení ánikomo-máikake máena, wemá wetábá ááímá kétena, “Kemá íma kao-nanana puyíkae.” Abo Ága mérami wáqónáwátáqó máqemaikakemma wemá ibiqá átáma yakáiye. ");
INSERT INTO usa_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Îtogo Ítímaerimo ibiqó-yáráimma ítáraiye. Îtogoní énítóreko wíyôpake Ágamma áyarena abo wetábá tiráiye, “Nóraq-uránó, Ága? Íma ikatíq-uwó, Îtogo enánikoní ibiqá ítátuwaiye. ");
INSERT INTO usa_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Emá uréya enánimma awíqma enayáápi yoraó, kemá wení iyápó-anna mamá anó maruqa áúqyikanune.” ");
INSERT INTO usa_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Îtogo Áganí áúramma táagayakaitana abo wemá maiqnómmá áónaraiye. Ágama nonánábí nommá yakéna maré-uréna ánikomma nommá ámíkaiye. ");
INSERT INTO usa_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Îtogo Ítímáerima yabírákáraitana abo wemá anómma-aukaiye. Wemá kaqmá maqa maena abo aráábá-naqa aukaiye. ");
INSERT INTO usa_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Ítímaeri Páráni kaqmáq maqa maitana, wení anówa Ágama Ítípike aaramá aabá uyamikaiye. ");
INSERT INTO usa_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Mi-kánábímmá Ábrá-ámkaq aamá tínéna Abimereki iráiye Píkórite, wení ááíq-wayukatí kawáámá. Ábíméréki téna “Ítogo mátetataqo taroq-innabímmá ete mániye. ");
INSERT INTO usa_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Íbêqa Îtogoní áúrakaqa emá ayáámma aikaq márénaqa kemá aónéqa minná emá íma kete, ketí iyápórawakaraq, ketí iyápó-annarawate táwí áaimma taroq-ónúne-tiyo. Emó namuq-náká-umá mánna marukaqó kemó emmó arátiraunna iraqo-náaimma mirárá-umá kemmá tirátio.” ");
INSERT INTO usa_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Abara-ám téna “Kemá tiyáámma tikaq-maráúne.” ");
INSERT INTO usa_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Íbêqa Abara-ám Ábímérékimma kúruqa timákáraiye wemó móra noqmaiqo uqmakáimma Ábímérékini mayaí-wáyúkáráwáqá yabíma abowání-umatawana. ");
INSERT INTO usa_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Abo Ábíméréki téna, “Náwamo miraimmá íma kemá aónaraune. Emá íma mitaoqa timátimenaq ítárauna íbêquramma-itaúne.” ");
INSERT INTO usa_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Miráitana Abara-ámma tipitípi-garaq purumakamma maména Ábímérékimma ámíkaiye. Mikákémmá máákagorata móra-yiyaqa maakaye. ");
INSERT INTO usa_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Abara-ám móra-tiyapakaraq kaya (7) ánáé típítípíráwáqá mamá-ókaq tipítipi-rawapike makáiye. ");
INSERT INTO usa_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Abo Ábíméréki Abara-ámma ítáraiye, “Nówai náaitabawa mami mórá-tíyápákáráq kaya (7) típítípíráwáqá emó mamá-ókaq yenamáraqa makáánó?” ");
INSERT INTO usa_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Wemá anónna-uráiye, “Mami mórá-tíyápákáráq kaya (7) típítípíráwáqá mayaínónna áaraimma mi maíqnótábá keqtábá ukaíye-tínóne.” ");
INSERT INTO usa_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Mi-náaitaba mi-márúqá Bétibare áwîqa-yarae, nówaitababiyo kaya-náká (2) móra-yiyaqo makááyakare. ");
INSERT INTO usa_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Kaya (2) nákórátámó móra-yiyaqo maraí-áímmó Bétibaqo kánataimma, Ábímérékigaraq Píkori wení áai-wayukatí anómma yauwéqmeta Pírítáni marabaq uráiye. ");
INSERT INTO usa_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Abara-ám támárátiki yaama Bétíba uqmakéna abo mikáq wemá Yawe Îtogoka monoqá-tiyákáraiye, matuqmatuq Ítogokaq. ");
INSERT INTO usa_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Abo Abara-ám áayátá kanama Pírítaini marabimma máqe-uráiye. ");
INSERT INTO usa_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Yaímma kana yátámakitana, Îtogo Abara-ámma maqmá aónaraiye. Îtogo “Abara-ámma” timámítana, Abara-ám téna, “Maa-maúne” tiráiye. ");
INSERT INTO usa_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Îtogo téna, “Enánimma kímora arupikémmó akaín íyápó awîqme Móréya aukapaq winaq, móra (1) anuma arátena enánimma ikámma agaamá ôba umátikao.” ");
INSERT INTO usa_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Maí nókáápáqá Abara-ám itó-uréna, ôbamo í-íráámá yaímma atáqma kebóqya otikoní ámúraq kémarena, wení kaya (2) máyáí nákáráq ánikomma wemá yiwíkaiye. Yeráwáqá maréta Îtogo timáyímí marukaq urae. ");
INSERT INTO usa_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Kaya (2) wáágá yátámakitana, Abara-ám wonaeti márúqá aónama nékaq yukaiye. ");
INSERT INTO usa_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","“Kaya (2) mayaí nákáráq maakáq pááqya otikaraq maero,” Abara-ám timáyíkaraiye. “Kerátá Îtogokaq mérapaq wuréka monoqá mó-tiyákátuweka yauwéqma keráwátópaq yéyúye.” ");
INSERT INTO usa_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Abara-ám agaamá ôba umákai iraama mamá Áitikimma kábakena, wemá iraa-áakaraq púmá mataíye. Abo maákama móraitéta uráye. ");
INSERT INTO usa_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Áitiki téna, “Ketibo?” titana. “Owe ketáaniko?” Abara-ám anónná uráiye. Áitiki téna, “Iraa-áakaraq iraamáq maíbo, ánibo nákaraq áráa tipitipi agaamá ôbamo umákaima maiyo?” ");
INSERT INTO usa_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Abara-ám anónna uráiye, “Ketáaniko, Îtogoma wenamáríq móra (1) áráa tipitipi ôbamo agaamá amímá timini-karatae.” Abo maakama móraitéta maréta kóuraye. ");
INSERT INTO usa_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Abo yenákámá Îtogomo timáyíkai marukaq uréta Abara-ám yáaré taróqumá iraamaá áakumá ámúra makaíye. Wemá Áitikimma ánna ai-yayaka ataumá yaareraq iraa-ámúraq makaiye. ");
INSERT INTO usa_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Abo wemá ayáámma áarumma púmá maténa ánikomma ikamínéna uráiye. ");
INSERT INTO usa_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Abo wíyôpake Yawe Îtogoní énítóreko áayama téna, “Ábárá-ám! Ábárá-ám!” Abara-am anónna uráiye, “Ké-maúne” tiráiye. ");
INSERT INTO usa_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","“Íma min-íyápómá awekema amiyo, ánekuqma mórayatari-uwo (1),” tiráiye. “Íbêqa kemá aónáúnama emá Îtogoní áaqa ikatiqé mináítábá emá íma enánimma kímora iyapo yáátorane.” ");
INSERT INTO usa_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Abara-ám waéqma aónama yúwáimma awai-típítípí karanóbaq ituwena wení kómuraq maitana aónaraiye. Wemá uréna koma tipitípi maména ánikoní márúqa mamá agaamá óba ámíkaiye. ");
INSERT INTO usa_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Abo Abara-ám mi márúqá “Yawe Îtogo timíní marure” tiráiye. Íbe kanama “Yawe Îtogota timíní anuwe” tiráiye. ");
INSERT INTO usa_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Abo Yawe Îtogoní énítóreko wíyôpake Abara-ámma yauweréna kayataoriq-umá (2) áayaraiye. ");
INSERT INTO usa_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","“Kemá áaraimma akoqná aimma timamune, “Yawe Îtogo mirá téna tiye. “Emó kímora iyapo ímo yátóránna áitaba, ");
INSERT INTO usa_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","Kemá áarai-nuramma anó amuramuqa eqkáráq ení iyápó-anna mamá taíbariq íníye abayáákáq wiyóká éta nonáwábaqa kekébára ínóe. Ení iyápó-anna namurotí márúqa yíkamma yabiyínóe. ");
INSERT INTO usa_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Emó ketáámo waaránna áitaba, ení iyápó annarake máte marabaqa maa márábímmá (amurámuq marainoe).” ");
INSERT INTO usa_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Ániye téna, Abara-ám wení mayaí wayukate yauwéqma móraiteta maréta Bétíbaq kourae. Abara-ám Bétíbaq máqe uráiye. ");
INSERT INTO usa_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Yaímma kana yáwitana Abara-ámma timámíkaiye, “Mírkáma wekáráq iyápó anowae, enábáqa Náqakake wemá inamaíráwáqá yíkátukaiye. ");
INSERT INTO usa_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Útíma-ma áqnáekowe, Bútíma-ma ábákowe, Kémúeri (Árámuni abowae). ");
INSERT INTO usa_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Kététi, Áyo, Bírítáti, Yítírábu-garaq Bétúeriye.” ");
INSERT INTO usa_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Bétúeri Árébékani abowá aúraitana, Mirkáma mi eítiqa (8) inamaíráwáqá Abara-ámuni abako Náqakake yíkáraiye. ");
INSERT INTO usa_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Wení anaékaq (2) anaqa Reúmae, wegárá inamaí yíkáraiye. Yetí yíwíqa. Tápae, Gáqámue, Táqátigaraq mákae. ");
INSERT INTO usa_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","maannáma Ítuma yauwéqmataa tiwiraí-nákóní anáábútááe. Îtuma minnâ Tébitin-annabikene ánibo Tébitima minnâ Âabaraan-annabikene. ");
INSERT INTO usa_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Áabaraama minnâ Ááítekimma aboáé. ánibo Ááítekima Yáakobomma aboáé. ánibo Yáakoboma Yútaamma wení ábâqawaayugaraqa yeqtí yiboáé. ");
INSERT INTO usa_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yútaama Pérêtiyaa Téraati yiboámíye. ánibo yinóama Táámaae. ánibo Pérêtima Étaronimma aboáé. ánibo Étaronima Aráámma aboáé. ");
INSERT INTO usa_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","ánibo Arááma Aammínataamma aboáé. ánibo Aaammínataama Náátonimma aboáé. ánibo Náátonima Tárámonimma aboáé. ");
INSERT INTO usa_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","ánibo Tárámonima Bóáatima aboáé. anóama Aréaabie. ánibo Bóáatima Óbétimma aboáé. ánibo anóama Arútie. ánibo Óbétima Yétimma aboáé. ");
INSERT INTO usa_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","ánibo Yétima Tébitimma aboáé. Tébiti kínima máqte-marukaq yabíkái-kawaanare. ánibo Tébitima Tórómónimma aboáé. anóama naayóbáqa Yúrááíaama ánáakoma máqe-uraimanibo Tébiti moyámmá yabitiráine. ");
INSERT INTO usa_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","ánibo Tórómónima Aréábóamma aboáé. ánibo Aréábóama Abááíyaamma aboáé. ánibo Abááíyaa Étaamma aboáé. ");
INSERT INTO usa_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","ánibo Étaama Yeótabatimma aboáé. ánibo Yeótabatima Yóraamma aboáé. ánibo Yóraama Utááíamma aboáé. ");
INSERT INTO usa_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","ánibo Utááía Yótáámma aboáé. ánibo Yótááma Éaatimma aboáé. ánibo Yótááma Étékááiyamma aboáé. ");
INSERT INTO usa_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","ánibo Étékááiya Manáátaamma aboáé. ánibo Manáátaa Émonimma aboáé. ánibo Émonima Yótááíaamma aboáé. ");
INSERT INTO usa_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","ánibo Yótááíaama Yekóniyaa aboágáráq ábâqawaayugaraq yeqtí yiboábóana mi-kánáábíma Ítíráaeo-wayukama Bébírôniq móma ánná urááe. ");
INSERT INTO usa_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","yemá Bébírôniq móma ánná owana Yekóniyaa Téyaatiomma aboámá máqe-uraiye. Téyaatio Térúbabeomma aboáé. ");
INSERT INTO usa_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","ánibo Térúbabema Áábiutimma aboáé. ánibo Áábiutima Irááíakimma aboáé. ánibo Irááíakima Étomma aboáé. ");
INSERT INTO usa_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","ánibo Étoma Tétokimma aboáé. ánibo Tétokima Ékimma aboáé. ánibo Ékima Éríútimma aboáé. ");
INSERT INTO usa_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","ánibo Éríútima Éríétaamma aboáé. ánibo Éríétaama Máátaanimma aboáé. ánibo Máátaanima Yáakobomma aboáé. ");
INSERT INTO usa_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","ánibo Yáakoboma Yótêbimma aboáé. ánibo Yótébima Máríaamma awaikóé. ánibo Máríaama Ítumma marákáraiye. miráitata yemá Metáíya yauwéqmataa tiwiraí-náré téta áwîqa kéyaae. ");
INSERT INTO usa_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","miráitata Áabaraani máqten-anna-wayukama mamé yewana aqtóráqá Tébitikaq iráamma tiyááka umá kaayaqté-kaayaqte-yiboama máqe-uraae. ánibo máqtemma Tébitin-anna-wayukama máeta mi-kánááráqá Bébírôniqa ánnáma mó-uraama minnáma tiyááka umá kaayaqté-kaayaqte-yiboae. ánibo yemá Bébírôniq ánnáma mó-uraa-kanaarake Metáíya Îtuma mikáq pááq-uraimma minnágaraq mamá máqtemma tiyááka umá kaayaqté-kaayaqte-yiboae. ");
INSERT INTO usa_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Ítuma yauwéqma tiwiraí-nákóní watáama pááq-uraimma mirá-uraiye. anóama Máríaae. yemá Yótêbiqtaba mayaíkáae téta aúyarakaraane. miráitata yenákámá mórabi íma uréire urááye. miráitata aónaama Áánúqtuni Aokaq-Áágómá Máríaakaq awaamérîq itanabóana ámûkarariq uráiye. ");
INSERT INTO usa_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","awaikómá Yótêbi wemá íráqôn-auyanakaraqnapoana ánáakoma Máríaama abarokáq timá agaeráq akaí-ááqá íma ítaraiye. miráitana wemmá aúpáq kaayonébáké waqtuwánéna aúyánámmá ítaraiye. ");
INSERT INTO usa_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Yótêbima minnáyaba aúyánámmá itáíq-itaiq kéitana uyátárai-nakoni kaqtó-nakoma kainapáq iréna mi-káqtó-nákómá maará-tiraiye: “Yótêbio, Tébitin-annabike-nako, emá enánáakoma Máríaama mayaíyábá ikatîqa íuwo. itaao. min-íyápómá áyáqnobaqo máin-iyapoma minnâ Áánúqtuni Aokaq-Áágómá ámikaiye. ");
INSERT INTO usa_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","wemá inaamaí-íyápómá marakániye. miráinaama wení áwîqa Ítue té áwîqa yamámiyo. min-áwíkóní áaimma minnâ. wemá wení aarawaamá otaa-qtátáápí máapoana yemmá yiwirániye. ");
INSERT INTO usa_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","maami-máqté-qtátááqá pááq imá minnáma uyátárai-nakoma amuné-wáyúkátí yóyaukaq téna maamin-áíkómá arammá iyaíno tiráine. ");
INSERT INTO usa_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","ítáaro. mórama aúgen-inikoma ámûkarariq kéena iyápóma inaamaímá marakániye. miráinata wení áwîqa Imáánuerie téta áwîqa yamáminoe. min-áwíkóní áaikoma mirá-uraiye. ‘Áánúqtuma ketáátê máiye.’” téna naayóbáqá Áánúqtuni amuné-nákómá tiráine. ");
INSERT INTO usa_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","ánibo Yótêbima aú waguré máqena itó-urena uyátárai-nakoni kaqtó-nakoma timáminiq uráiye. miráitana Yótêbima wení ánáakoma mamá íráqôniq umá ákáraiye. ");
INSERT INTO usa_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","miráimanibo Yótêbima Máríaate íma naté náuraayana inaamaímá marákáraiye. min-íyápógóní áwîqa Îtue téna Yótêbima yamá ámikaiye. ");
INSERT INTO usa_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Érôtima anó-kinimma mái-kanaaraqa Máríaama Îtumma Béqteremubaqa Yúría-marupaq marákáraiye. ánibo min-íyápómá marákátuwaitata anaaékaqa wiyóqtábá ítaraa-kayukama aabaúmá utaipáké Yérútáárebaq iréta maará-tiraae: ");
INSERT INTO usa_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","“aúgen-iyapoma pááq imá Ítíráaeo-wayukati kínimma mánin-iyapoma náakaraq máiyo? ketáámá wení wiyókómá aúge-kinimma pááq itana awaaméqá immá aabaú utaipáké aónatuweqtaaboataa ketáá wekáq nunamummá timákanataa kéyune.” téta tirááe. ");
INSERT INTO usa_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Érôtima kínima min-áímmá ítátuwena wemá áaqa karáiye. máqtemma Yérútáare-wayukagaraq iyánáaq urááe. ");
INSERT INTO usa_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Érôtima máqtemma anón-i-wayukama mamá káikuyikena uyáta-maqma anó-monoq-wayukagaraq áíkuyikarena aammá aúmatan-aimma yirááti-wayukaboana wemá ítama aónaraiye: “Metáíya yauwéqma waayúkama yiwiránîn-naqa náakaraq Áánûqtuni amuné-wáyúkámá tiráámma pááq íníyô?” téna ítama yimónaraiye. ");
INSERT INTO usa_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","miráitata yemá timá-ameta: “maakáq Béqteremubaqa Yúría-marupare.” téta timá ámikaae. naayóbáqá Áánúqtuni amuné-wáyúkámá maará téta aúbabi agatááne: ");
INSERT INTO usa_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","“keráwáqá Béqteremu-wayukao, Yútaa-wayukati marabáqá máamma paá-marukaqa íma mááe. keráwáqtí márûpake anómma yabíkái-naqa pááq íniye. miráínana wemá ketí Ítíráaeo-wayukaraq yabiíniye.” téna naayóbáqá tiráine. ");
INSERT INTO usa_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","miráitana Érôtima aabaú utai-náúkápáké wiyóqtábá ítaraa-kayukama yaákarena aúpáq yááyaraiye. ánibo wemá miráitana mi-káyúkáráq ita-ita umá káonena: “mi-kíyóqá pááq-urai-kanaarakemma náaraq-uma-kanaawaq yáuraiyo?” téna ítama yimónaraiye. ");
INSERT INTO usa_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","yimónatuwena Érôtima mi-káyúkámá timáyíkáitata Béqteremubaqa kégowana tiráiye: “keráwáqá uréraq min-íyápóyábá abáá-uma arútáaro. ánibo keráwáqá aónamareqa ketôpaq yauwéqma má-tima-timero. miráinaq kegáráq uréq wemmá omáqá aónanune.” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","ánibo yemá kínin-aama ítátuweta kóuraae. aapaqá kéowana maami wiyóqá aabaúmá utaipáké aónaraa-waigoma mi-káyúkátí áqnáabaq wéqéna min-íyápómá máikaq ko máqe-uraiye. ");
INSERT INTO usa_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","wiyóqá káonaawana íyakoma íráqôniq uráiye. ");
INSERT INTO usa_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","miráitata min-náúpáq uyábéketa min-íyápógáráq anóama Máríaakaraq aónatuweta yemá awáúteta yiraayutaúmmá ayéta min-íyápógómmá omáqá aónaraae. ánibo yemá yeqtí kápiq-unamma ótureta yimuqá marakéta yaímma-yataaqa ámikaama mónekaraq íráqôn-akuqa i-kánámá íráqôn-akuqa i-mátáwékáráq ámikaae. ");
INSERT INTO usa_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","ááqibo kainapáqá Áánúqtuma mi-káyúkámá timá-yimena Érôtinopaqa yauwéqma íoro téna timá yímikaiye. miráitata yemá óq-apake yaútúmeta yetí naaópaq kóuraae. ");
INSERT INTO usa_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","wiyóqtábá ítaraa-kayukama yeqtí naaópaq kówana uyátárai-nakoni kaqtó-nakoma Yótêbinopaq kainapáq kukéna timá ámikaiye: “emá itóé iyápógaraq anóakaraq yiwíqme péqmare Íqtîbibaq kóaao. Érôtima iyápó abáá-uma ikamínénaboana abáá kéibo mibáq Íqtîbibaq márenaq keqnáámmá kemá timáménaa ‘kóaao’.” téna timá ámikaiye. ");
INSERT INTO usa_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","ánibo Yótêbima mikáké páátákáá itó-uma min-íyápógáráq anóakaraq yiwíqmena min-nókáámá Íqtîbibaq kóuraiye. ");
INSERT INTO usa_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Yótêbima Íqtîbibaq máqe-urai-kanaaraq Érôtima pukái-kanaabima Íqtîbibake yeqtí máápaqa kóuraae. miráitana uyátárai-nakoma amuné-wáyúkátí yóyaukaq tiráimma áraimma pááq uráiye. maará-tiraine: “ketáanikoma Íqtîbibake yíkáae téq wemmá ááyaraune.” téna agamatán-áúbábí tiráine. ");
INSERT INTO usa_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","ánibo íbêqa Érôtima ítaraiye wiyóqtábá ítaraa-kayukama aabaú utaipáké ye-káyúkámá Érôtimma amaníqá makááe. miráítana Érôtima anómma áyámma umáguraiye. wemá yaímma-wayukama timá yíkáitata Béqteremubaqa yaímma waaqókáq-márúpákégáráq inaamaí-íyápóráq áíqma yíkakaama miráuma pááqya-noiyapoma kaayarábi móra-karitimaatima yáurai-noiyapoma áíqma yíkakaae. minnáyababoata yíkakaae. wiyóqtábá ítaraa-kayukama Érôtimma timá ámikaamma áqnáabaqa wiyóqá aónaawana kaayaq-kárítímáátímá yáuraine. ");
INSERT INTO usa_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","miráitana naayóbáqá móra-aimma Áánûqtuma tiráimma móra amuné-náqá Yérémáaiani óyaukaq tiráimma áráimma pááq uráiye. maará-tiraine: ");
INSERT INTO usa_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Aráámaa-marupake móra-aimma ítáawana min-áíkómá anón-ibiqa yaréta Arétéroma wení iyápóyaba ibiqá kéyarainatama aarawaamá íma kanaaráq mamá áyáqa paru ínóe. máqtemma wení iyápóma pukurááwanaboana ibiqá kéyarainata aarawaamá wenáyaqa íma mamá paru ínóe.” téna Yérémáiya naayóbáqá tiráine. ");
INSERT INTO usa_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","anaaékaqa Érôtima pukitana Íqtîbibaq uyátárai-nakoni kaqtó-nakoma kainapáq Yótêbinopaq kukáiye. ");
INSERT INTO usa_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","mi-káqtó-nákómá maará-tiraiye: “emá itóé iyápógaraq anóakaraq yiwíqme Ítíráaeobaq yauwéqme kóaao. wemá min-íyápómá ikamínéna i-náqá áqa pukuráiye.” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","mirátitana Yótêbima iyápógaraq anóakaraq yiwíqmena Ítíráaeo-marabaq yauwéqme kóuraiye. ");
INSERT INTO usa_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","miráimanibo wemá ítáimma Áákéreaatima Érôtini áanikoma aboání náápaamma mayéna anónnáma kínimma Yúría-wayukabi máqe-uraipoana Yótêbima min-áúkápáq wíyábá ikatîq uráiye. miráimanibo móra kainapáqá Áánûqtuma Yótêbimma ámááma ámikaitana Kááriri-aukapaq yiwíqmena kóuraiye. ");
INSERT INTO usa_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","wemá móra-maruqa Náátárêtibare te-márúpáq ko máqe-uraiye. miráitana naayóbáqá Áánúqtuni amuné-wáyúkámá agatáán-aikoma áraimma pááq uráiye. maará-tiraane: “yemá Náátárêtibake-nare téta tínóe.” téta Metáíyaqtaba tirááne. ");
INSERT INTO usa_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","mi-kánááráqá Yóáanema nommá péqyikai-naqa pááq uráiye. ánibo wemá Yúríabaq kaqmáápaq máena watáama tiráiye. ");
INSERT INTO usa_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","wemá maará-tiraiye: “keráwáqá tirummá waéráaro. Áánúqtuma yabíkái-kanaama waaqókáq kéiye.” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","maamin-náqá Yóáaneqtaba naayóbáqá Áánúqtuma amuné-náqá Áítáíyan óyaukaq tiráine. minnáma maará-tiraine: “waayúkama íma máa-kaqmaapaqa móra-nakoma anókaq ááyama kétiye. ‘uyátárai-nakoni aammá yokaa oro.’” téna Âítáíya naayóbáqá yirummá waeraíyábá tiráine. ");
INSERT INTO usa_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Yóáanema móra oótiraa-kamma káámogoni áyáuraq wáqtôma tarôq umátamma itokéna aúkáapi purumakaakóní áúraq tarôq umátan-amurannama umátokaine. ánibo wemá karaanóbáké yaatárugaraq uwon ámûkaraq néwaine. ");
INSERT INTO usa_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","mi-kánáábímá yaímma-wayukama Yérútáárebake Yúríabaq-wayukama yaímma Yótaa-nokoni waaqókáké-káyúkágáráq Yóáanenopaq irááe. ");
INSERT INTO usa_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","miráitata yemá yeqtí kúmiq-yataaqtaba wemmá timá ámewana Yóáanema Yótaa-nopi nommá péqyikaraiye. ");
INSERT INTO usa_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Yóáanema aónaimma netuqyaammá Pérati-wayukagaraq Táátûti-wayukagaraq nommá peránátaae téta yewana wemá tiráiye: “keráwáqá iraakabayaakón áráakawaqa mááe. náawaq titaráq keráwáqá Áánûqtuni áyámma anaaékaq ínîqtabama kanaaráq péqmare kóino? ");
INSERT INTO usa_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","keráwáqtí kúmiq-yataapike tirummá waékáunataae téraq keqtáámá tiráátero. ");
INSERT INTO usa_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Áánûqtuma maamin-óqtánápó mamá kanaaráq Áabaraani iyápóma aúqyikanipoaq ‘Áabaraama ketááí tináábúóé.’ ítero. mirá tíyakakemma táí-meyamma ímayanoe. kemá keráwáqá kétima-timune. ");
INSERT INTO usa_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","yaagóní áaipima Áánûqtuni kummá yáúkáiye. miráipoana máqte-tagoma arammá íma iyaínatama ayáama kunnápó áaipike agáutuweta irabí agatúwáánikaa umá agatuwánóe. ");
INSERT INTO usa_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","kemá Yóáanema nonnápó keráwáqá kébetikaune. mirá éqa ketáá tirummá waeráunataae téq kétiraateqtaae. miráimanibo móra-naqa tinaaé yínîn-nakoni akoqnáágoma ketí akoqnááma uyátáraiye. kemá íma kanaaráq umaataráunaboaq wení aítauq-anaama múte mayánúne. awaaméqá keráwáqtí kúmiq-yataapike waeraígáae téq kemá nopí tíkaraunamanibo wemá keráwáqá Áánûqtuni Aokaq-Áágópí tikániye. náayubi yeqtí kúmiq-yataapike íwaeraiyanama yemmá irabí yíkarainana iragómá yeqtí kúmiq-yataaqa kamá kautíniye. ");
INSERT INTO usa_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","wení ayáápimma yáumma matokéna wítima kugébatuwaniye. miráumatuwena wení wíti-naupaqa wítima mamá áíkuiniye. miráimanibo wítigoni átima iramá káíq-kaiq umá kain-írábí agatuwániye.” téna Yóáane Áánûqtuma kugébama agatuwánîqtaba tiráiye. ");
INSERT INTO usa_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","mi-kánááráqá Îtuma Kááriri-maruqa yuwéna Yótaa-nopaq uráiye. Îtuma Yóáanenopaq uréna Yóáanema wenayáápike nommá pétikaikaae téna uráiye. ");
INSERT INTO usa_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","miráitana Yóáanema aúyánámmá ítáimma íma kanaaráq umaatarénaboana Îtumma nommá pérakane kéena tiráiye: “kanaaráq emá kemmá nommá pétikanone. nôraq itaawáq ketôpaqa kéyeno?” titana ");
INSERT INTO usa_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Îtuma yauwéqma tiráiye: “ibáqyuwaao. mi-kánááráqá miráráá óyáae. miráoyanama máqte-qtataaqa Áánûqtuma akáinaiq óyúye.” mirá titana Yóáanema Îtun áama waréna wemmá nommá pérakaraiye. ");
INSERT INTO usa_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Îtumma nommá pérakatuwaitana páátákáá nopíké yuwéna aabayámmá ígitana aónaimma Áánûqtuni Aágoma kukáimma miráuma móra-numama máagoraa umá kukéna Îtukaqa ku máqe-uraiye. ");
INSERT INTO usa_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","ánibo móra-aikoma Áánûqtunopake tiráiye: “maannáma ketáanikoe. kemá weqtábá ôriq umá kétikaiye. ketí tíyakoma weqtábá íráqôniq kéiye.” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","mi-kánááráqá Aágoma Îtumma awíqmena waayúkama íma máa-kaqmaapaq Tááqtaama makáqma aónaikaae téna uráiye. ");
INSERT INTO usa_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","miráitana Îtuma kaayaqté-kaayaqte-tiyaaka-wagaagaraq kaayaqté-kaayaqte-tiyaaka-nokaakaraq aáwaqa íma yaráiye. miráitana anaaékaqa Îtumma áama yaráiye. ");
INSERT INTO usa_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Îtumma makáqma aónai-naqa Tááqtaama waaqókáq-amakaq iréna tiráiye: “emá Áánûqtuni áanikomo máemoema emá tinata maaráin-oqtakoma waéqma yammá auraíno.” téna áama yaitana naíkáae téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","miráimanibo Îtuma yauwéqma tiráiye: “ímiye. Áánûqtun-aama agamatá-kánnáágómá maará kétiye. ‘aáwakoma wenamáa waayúkagomma matúq-matuq umá mái-auwaraimma íaminiye. ímiye. máqten-aimma Áánûqtun óyaupike yínna-aikake waayúkama matúq-matuq umá mái-auwaraimma mayánóe.’ mirá kétiye.” téna ");
INSERT INTO usa_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Îtuma mirá-timatuwaitana Tááqtaama Îtumma awíqmena aokaq-márúqá Yérútáárebaq uréna anó-monoq-nakoni ámûraaq mó-ito-umakaraiye. ");
INSERT INTO usa_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","ánibo Tááqtaama Îtumma timá ámikaiye: “emá Áánûqtuni áanikomo máema kanaaráq maakáké yaúme memapí metenanamá móra-yataakoma ayáámá íayakaniye. Áánûqtuni agamatá-kánnáágómá mirá kétiye. ‘Áánûqtuma wení kaqtó-wayukama timá-yiminata emmá iyáánapo yáqtokaiyana móra-oqtakoma enaítaupimma íataraniye.’ mirá kétiye.” téna Tááqtaama tiráiye. ");
INSERT INTO usa_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Îtuma Tááqtaamma yauwéqma timá ámikaiye: “ááqibo Áánûqtuni agamatá-kánnáágógáráq maará kétiye. ‘uyátárai-nakomma íma makáqma aónaao. wemá minnâ ení Áánûqtue.’ máqtemma keqtááyábá mirá kétiye.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Tááqtaama mikáké Îtumma awíqmena mórama uyátárain-anuraq utáiye. ánibo Tááqtaama wemá máqte-qtataakaq yabíkái-qtataaqa káraatena wení maa-márábín-íráqó-qtátáákáráq aráátiraiye. ");
INSERT INTO usa_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","miráitana Tááqtaama Îtumma timá ámikaiye: “emá araayutaúmmá ayé kekáq nunamummá timá tíkénaqa kanaaráq maami-máqté-qtátááqá emmá aménúne.” téna Tááqtaama tiráiye. ");
INSERT INTO usa_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Îtuma wemmá timá ámikaiye: “Tááqtaao, emá paábaq kóaao. Áánûqtuni watáa agamatá-kánnáágómá kétiye. ‘emá uyátárai-nakokaq nunamummá tiyo. minnâ wemá ení Áánûqtue. wenamáa wení mayaímá mayaao.’ máqtemma keqtááyábá mirá kétiye.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","miráitana Tááqtaama Îtumma ayuwéna kóuraiye. ánibo yaímma Áánûqtuni kaqtó-wayukama Îtumma aayáqtáá-kanaama aáwaqa íma naráitataboata yemá ya áwáqnaa urááe. ");
INSERT INTO usa_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Îtuma ítáimma Érôtimma Yóáanema aabi mayákáitataboata wemmá ánná-naupaq ákáraae-aimma ítátuwena mikáké Kááriri-marupaq uráiye. ");
INSERT INTO usa_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","ánibo mikáké Náátárêtibaq yuwéna Kápéranabaqa ko máqe-uraiye. Kápéranabaqa Kááriri-nokaayukoni áwábaq Yáakoboni áanikoratama Tébirunigaraq Náábataarigaraq yeqtí min-áúkápáq wáiye. ");
INSERT INTO usa_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","miráitana móra-aimma Áánûqtuma amuné-náqá Áítáíyani óyaukaq tiráimma áraimma pááq uráiye. maará-tiraiye: ");
INSERT INTO usa_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Tébirunini-marukaq-wayukao, Náábataarini-marukaq-wayukao, únókááyúkóní áwábaq uréna Yótááni-nomma aqtátuwena maami Yéqtaaeo-wayukama mibáq kémae. yeqtí Kááriri-marukaa-marure. ");
INSERT INTO usa_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","yema kumayuq-yátáápí kémaeta anón-omma kamá tágaimma aónaraae. aarawaamá yemá puí-yátáákóní amakaq máiyana yekáqá ómmá táganiye.” téna Ááítáia agamatá-kánnáábí tiráine. ");
INSERT INTO usa_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","mi-kánááráqá Îtuma áaimma átáma átê-wataama Áánûqtuqtaba tiráiye. wemá maará-tiraiye: “Áánûqtuma yabíkái-kanaama waaqókáq kéibo keráwáqá tirummá waéráaro.” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Îtuma Kááriri-nokaayukon-awabaq uréire kéena wemá kaayaq-wátámá yimónaraiye. Tááímoniqtabama óq-awiqa Pítaae téta kéyaae. ábâkoma Áánarue. yenákámá aati-aatimá nokaayúpíké kúqônnapo noyááqa yamá kéyabiteye. ");
INSERT INTO usa_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Îtuma yenákámá timá yímikaiye: “kenákámá ketinaaé wáráakao. miráíya kemá waayúkama yabitimáe ketôpaqa í-ááímmá tiráátenune.” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","ánibo yenákámá páátákáá noyááqa yáqtorai-kuqomma yuwéta Îtun anaaé wakááye. ");
INSERT INTO usa_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","wemá keqnáámmá kómare kéwena káqomma yewátámá Yêmitima Yéberimma áanikogaraq Yêmitima ábâkoma Yóáanekaraq ko yimónaraiye. yenákámá únópí-káárébí yetibomá Yéberigaraq yenákámá máeta kúqômma mamá aruta-aruta urááe. ánibo Îtuma mi-kááyáq-nákámá yááyaraiye. ");
INSERT INTO usa_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","páátákáá min-nákámá únópí-káárégáráq yiboákáráq kéyuweta Îtun anaaé wakááye. ");
INSERT INTO usa_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","wemá máqtemma Kááriri-aukapaq uréire kéena Îtuma mibáq yeqtí monoq-náúpáq yiráátiraiye. ánibo Áánûqtuma yabíkái-waigoni átê-wataama kétima-yimena máqtemma karí-wáyúkámá mamá kátobamayikena máqte-qtataakoma aarawaamá mamá táíq i-qtátááqá mamá arútáyikaraiye. ");
INSERT INTO usa_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Îtuni watáagoma máqtemma Tíríaaq-aukapaq uráiye. miráitata máqtemma ókon-oko-kari-wayukama yíqa ôriq umá i-káyúkámá táí-aagoma yirunóbáqá mái-kayukama waayúkama iyáátánaa yúma aráákagurai-kayukama máqtemma yiwíqme irááe. mi-káyúkámá yiwíqme yewana Îtuma mamá arútáyikaraiye. ");
INSERT INTO usa_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","ánibo netuqyaa-káyúkámá Kááriribakemma Tekááporitiq-aukapakemma Yérútáárebakema ópakemma Yútaabakekaraq Yótaa-nopaq uráin-aukapakema netuqyaammá Îtun anaaé waqmé urááe. ");
INSERT INTO usa_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Îtuma aónaimma netuqyaa-káyúkámá kéyeqtaba anuraq utáiye. wemá mikáq maraq máitata wení iyápó-annama wenôpaq irááe. ");
INSERT INTO usa_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","ánibo Îtuma mi-káyúkámá watáa timá-yimena tiráiye: ");
INSERT INTO usa_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“mi-káyúkámá Áánûqtuma áwáqnaa ínîqtaba kéeta wemá yabíkái-marupaqa mánoqtababoata yemá yimuqá kémaraae. ");
INSERT INTO usa_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","mi-káyúkámá ibiqá kéyareta máe-kayukama Áánûqtuma yetí íyaqa mamá paru íníqtababoata yemá yimuqá kémaraae. ");
INSERT INTO usa_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","mi-káyúkámá yeqtí yíwîqa márúte yuwéta yíwîqa íma múte yaúyô-kayukama Áánûqtuma timá akoqnáá urái-qtataaqa yemá mayánôqtababoata yemá yimuqá kémaraae. ");
INSERT INTO usa_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","mi-káyúkámá Áánûqtuma ákái-qtataariq ónáae te-káyúkámá yemmá Áánûqtuma ógiqma yimínîqtababoata yemá yimuqá kémaraae. ");
INSERT INTO usa_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","mi-káyúkámá káqo-kayukayaba paru-yátááqá yimíya-kayukama Áánûqtuma yemmá paru-yátááqá yimínîqtababoata yemá yimuqá kémaraae. ");
INSERT INTO usa_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","mi-káyúkámá íyaqnobaqa íráqôniq kéi-kayukama Áánûqtumma yemá aónainoqtababoata yemá yimuqá kémaraae. ");
INSERT INTO usa_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","waayúka aúkáapimma mi-káyúkámá mamá kaayoné-í-ááímmá tarôq kéo-kayukama Áánûqtuma ‘ketí iyápó-annae.’ téna timá-yikaniqtababoata yemá yimuqá kémaraae. ");
INSERT INTO usa_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","mi-káyúkámá Áánûqtuni arupú-amma kéwareta miráiyakake mamá táíq umáyikaiyatama Áánûqtuma yabíkái-maruqa minnâ yeqtí márûqa wániqtababoata yemá yimuqá kémaraae. ");
INSERT INTO usa_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","yemá aónáíyama keráwáqá ketinaaé kéwaraiyata keráwáqá táí-aimma timá-tiketa waqmá paábataa éta kaaqaari-túbí maréta kéráwákáq kéqokeriq kéowaqa keráwáqá timuqá maqmé kéuyoe. ");
INSERT INTO usa_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","miráráá umá yemá Áánûqtuni amuné-wáyúkámá áqnáabaqa waqmá táíq umáyíkáawata móra-mora urááne. keráwáqtí tíyakoma íráqôniq kéinaraq timuqá máráaro taákaq máráaro. keráwáqtí anó-meyamma Áánûqtuni márûpaqa wáiye. ");
INSERT INTO usa_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","keráwáqá miráuma maa-márábí-káyúkátí úráá kamá mááe. miráimanibo úgóní akoqnááma paábaq kóínataama nôraq onanatááwáq keqnáammá úmá káníyô? mirán úmá máqte-qtataapimma kanaaráq íinipoata waayúkama paábaq mamá yúwáawana aarawaatí yítaukoma yamá yatámínikaa umá Áánûqtu móraiq íniye. ");
INSERT INTO usa_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","keráwáqá miráuma maa-márábí-káyúkáti ókáá kamá mááe. móra-maruqa anuraq wáinna-maruqa íma aúyoqma wániye. ");
INSERT INTO usa_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","móraiq umá waayúkama ómmá kúraqma móra tawegóní aménáápáqá íma kémaraae. ímiye. yemá paá ómmá kúraqma abarokáq makáawana ókómá kamá tágaitata naaúpaqo máe-kayukama kanaaráq aónainoe. ");
INSERT INTO usa_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","miráráá umá tágáaro. keráwáqtí tágama-yataakoma aarawaatí yúrakaqa ókáá kamá kétagainata máqte-kayukama káoneta keráwáqtí íráqôn-aaimma káoneta Áánûqtuma keqtibomá wení márûkaqa mái-nakoni áwîqa múte yaúyóro. ");
INSERT INTO usa_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Mótetini aammá aúmatan-aikaraq Áánûqtuni amuné-wáyúkátí yáagaraq kemá Îtuma mamá paábaq yuwániye ítero. ímiye. minnáyaba kemá paábaq matuwánááq íkukaunamanibo kemá paá maamin-áímmá maqmá ánatanaa kukáune. ");
INSERT INTO usa_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","kemá áraimma kétima-timune. maa-márágógáráq Áánûqtuni márûpakaraq ánatani-kanaaraqa pááqyamma agamatán-áínábi Áánûqtuni aammá aúmata-kanaabimma wáina-yataaqa móra íma aúyoraniye. máqtemma aammá aúmatan-aimma paá wáinana máqte-qtataaqa pááq umá ánataniye. ");
INSERT INTO usa_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","miráinana móra-nakoma maami aammá aúmatan-aipike móra pááqyan-aimma mamá paábaq yuwéna káqo-nakomma ‘mirá-uwo’ téna aráátina-nakoma min-nákóní áwîqa Áánûqtu yabíkái-marupaqa pááqya-qtataakaa umá wániye. ánibo móra-nakoma ámáan-aimma waréna waayúkati yúyánámmá mamá itó éna ‘ámáan-aimma wáráaro’ ténama wení áwîqa Áánûqtu yabíkái-marupaqa anón-awiqa wániye. ");
INSERT INTO usa_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","kemá keráwáqá kétima-timune. keráwáqtí arupú-aaikoma ámáan-aimma yirááti-wayukagaraq Pérati-wayukagaraq yeqtí arupú-aaikoqtaba téta íma uyátainaq keráwáqá kanaaráq Áánûqtu yabíkái-marupaqa íma uyáberanoe. ");
INSERT INTO usa_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Mótetini áimma títaubikotaa matáan-aimma keráwáqá itaraae. minnâ ‘keráwáqá waayúka íma yíkamma púyoro.’ ánibo móra-nakoma waayúka yíkamma puyénama min-nákómá kanaaráq aamá ítama yainaí-áípí mániye. ");
INSERT INTO usa_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","miráimanibo kemá keráwáqá kétima-timune. náawabi móra-nakoma áyámma umákenama wemá aabi maéna ítama yainaí-yátáápí maíno. ánibo náawabi móra-nakomma áyoqa ayéna timá táíq umákenama wemá áqnáabaq anó-monoq-wayukayopaq ítama yainaí-áímmá ya itaíno. ánibo min-nákómá káqomma Áánûqturaa umá ítama yainénama min-nákómá kanaaráq iramá káíq-kaiq umá kain-írábí wíniye. ");
INSERT INTO usa_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","miráínaa emá Áánûqtukaq amí-yátááqá mamé iré aúyánámmá iténa móra-nakoma emmá timámi-aimma waínana Áánûqtukaq ");
INSERT INTO usa_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","amí-yátááqá paá amí-yááréráq mó make páátákáá aamá mó timá móra-tuyanakaq máráaro. mikáké yauwéqma iréraq Áánûqtukaq keráwáqtí amí-yátááqá mó áméro. ");
INSERT INTO usa_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","móra-nakoma emmá aamá timákanena ínaka kenákámá aapaqá kéwekama páátákáá emá mamá móra-tiyakaq wetê máráakao. ímo miráinanama wemá aamá ítama yainaí-nákókáq awíqme mó-akainana aamá ítama yainaí-nákómá i-wáyúkátí iyáápi akáinata i-wáyúkámá emmá ánná-naupaq akaíyábáé. ");
INSERT INTO usa_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","kemá keráwáqá kétima-timune. emá nôrabi uráínna-anonnama máqtemma yauwéqma íamema emá kanaaráq ánná-naupakema íma kumá yaúbanone. ");
INSERT INTO usa_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","naayóbáqá pááq-urain-aimma ítaraane. minnâ ‘kumari-ááímmá ítaroq oro.’ ");
INSERT INTO usa_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","miráimanibo kemá Îtuma maará téq keráwáqá kétima-timune. móra-nakoma móra-inimma aónáínana arunóbáqá weqtábá ákáin-nakoma minnâ wenamáárîq wení arunóbáqá mirán-ááíkómá mamá min-íníkáq kumari-ááímmá tarôq kéiye. ");
INSERT INTO usa_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","ánibo ítáaro. keráwáqtí móra-turakoma keráwáqá mamá kúmiq-yataapi kétiyuwainaqa kanaaráq mi-túrámmá kubíqma paábaq yúwáaro. keráwáqtí móra-tugoma íma wáinata keráwáqtí máqte-tugoma mamá iramá káíq-kaiq inírábí ítiyuwanoe. ");
INSERT INTO usa_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","ánibo keráwáqtí móra-tiyaakoma keráwáqá mamá kúmiq-yataapi kétiyuwainaqa kanaaráq keráwáqá mi-tíyáámmá kárama paábaq yúwáaro. keráwáqtí móra-aukapaq-tuma íma wáinatama iramá káíq-kaiq-irabima máqte-tugoma íwiniye. ");
INSERT INTO usa_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","naayóbáqá Mótetini maarán-áíkáráq pááq uráine. minnâ ‘móra-nakoma ánáakomma ayuwénama kanaaráq wemá móra-wannaama agamá kámena áqa maa káyuwaune tíno.’ ");
INSERT INTO usa_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","miráimanibo kemá keráwáqá kétima-timune. móra-nakoma ánáakomma kumari-ááímmá ítaroq uráinna-inimma ayuwénama min-nákómá ánáakomma mamá kúmiq-yataapi káyuwaimma maará-uraiye. min-íníkómá keqnáámmá waamá mayénama kumari-ááímmá tarôq kéitana min-nákógáráq kumari-ááímmá tarôq kéiye. miráitata yenákámá Áánûqtun-aurakaq kumari-ááímmá tarôq kéoye. ");
INSERT INTO usa_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","káqon-aimma ketááí títaubikoma titaq ítaraama maará-uraiye. ‘keráwáqá timá akoqnáá umákaiyan-aimma íma aratínómanibo keráwáqá móra-yataaqtaba áraine téq timá akoqnáá ínéqa kanaaráq keráwáqá tíya-qtataakoni anaaé waréraq uyátárai-nakoni aúrakaq áraimma tero.’ ");
INSERT INTO usa_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","ááqibo kemá keráwáqá kétima-timune. keráwáqá yanaammá awaaméqá umátuweq áraine ítero. keráwáqá Áánûqtuni márûkon-awiqa yaananatáá akoqnáá umátikaikaae ítero. Áánûqtuni márûpaqa wení abíqtátárákémá aamá kétima-timiye. ");
INSERT INTO usa_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","ánibo keráwáqá móra-yataaqtaba maa-márágóní áwîqa yaananatáá akoqnáá umátikaikaae ítero. ímiye. maa-márámá Áánûqtuni pááqyan-abiqtataraa kéitana wemá aítauqa maqmá arage kéiye. ánibo keráwáqá Yérútááre-marukon-awiqa maqmá móra-yataaqtabama yánátaae ítero. ímiye. Yérútááre-maruqa minnâ anó-kinima uyátárai-nakoni márûre. ");
INSERT INTO usa_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Áánûqtun-aurakaq tiqnókáq maqmá tenanatáá akoqnáá umátikaikaae téq ítero. keráwáqá kenamáárîq keráwáqtí tiqnótáuma mamá abutá tíqnótáúwábi kaatáu-tiqnotauma kanaaráq íma mamá auránoe. ");
INSERT INTO usa_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","miráimanibo keráwáqá maará tero. ‘owé. mirá-onune. ímiye. ímira-onune.’ tero. ókaraq aamá waayúkama awáágí-aimma minnâ Tááqtaanopake pááq kéiye. ");
INSERT INTO usa_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","keráwáqá naayón-áímmá iráimma ítaraane. ‘enaúramma kubíqtuwaiyainaama anónnáma kubíqtuwaao.’ ánibo ‘enáwáyaamma ikámma óqtuwainaama anónnáma wenáwáyaamma ikámma óqtuwaao.’ ");
INSERT INTO usa_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","miráimanibo kemá keráwáqá kétima-timune. móra-nakoma táí-yataariqo kéumatikainaqa wemmá yauwéqma awekémá íkuyakaaro. ímiye. móra-nakoma mórabaq táápáamo kéyuwituwainaqa kanaaráré kéteraq mórabaq-taapaama ámíyana mibákáráq yuwítuwaino. ");
INSERT INTO usa_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","ánibo móra-nakoma keráwáqá aamá matikéna keráwáqtí kúberai-unamma tíótaama mayánéna ínaqa kanaaráqíbo anó-tiotaagaraq áméro. ");
INSERT INTO usa_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","ánibo móra-nakoma akoqnáá éna keráwáqtê aammá uréire éna ummaamá mayánáae tínaqa kanaaráqíbo mamá ayáqtááq-amma uréire oro. ");
INSERT INTO usa_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","ánibo móra-nakoma keráwáqtábá móra-yataaqa ‘tímero’ tín-naqa kanaaráqíbo keráwáqá paá móra-yataaqa áméro. ánibo móra-nakoma téna atábááma umátikeq móra-yataaqa keráwáqá timénáae tín-naqa kanaaráqíbo keráwáqá tinaaémma íumakaaro. ");
INSERT INTO usa_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","keráwáqá maan-áímmá naayóbáqá iráimma ítaraane. ‘yaímma-wayukama keráwáqtí waaqókáq máiya-kayukama tirummá yiméraq kaayoné kéumayikeraq keráwáqtí namuro-wáyúkáma tíyamma umáyikáaro.’ ");
INSERT INTO usa_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","miráimanibo kemá keráwáqá kétima-timune. keráwáqá keráwáqtí namuro-wáyúkágáráq tirummá yiméraq Áánûqtukaq nunamupí itáiyana keráwákáq táí-aaimma tarôq kéiya-kayukagaraq yíwáqnaa éna mamá paá umáyikaniye. ");
INSERT INTO usa_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","miráinaq Áánûqtuma wení márûpaq mái-nakoni iyápóma auránoe. Áánûqtuma wení aabaúmá mamá íráqô-kayukaraqa táí-wayukagaraq yeqtí yímûraaq aaqá kégamayikaiye. móraiq umá Áánûqtuma arupú-wayukarakaraq mamá íma arupú kéo-kayukarakaraq aaqá yumá paru kéumayikaiye. ");
INSERT INTO usa_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","ánibo keráwáqá timuqá kémaqyikaa-kayukama yenamáa yemmá tirummá yimíyanama minnáyaba Áánûqtu meyámmá ítiminiye. aqá táákiti-moneqa moyámmá máyáa-kayukagaraq mirá kéoe. ");
INSERT INTO usa_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","ánibo kéráwáqá keráwáqtí tíbâqawaaraa-kayukama yenamáa miráó-maaraa kétimayikeqa nói-qtataakakenaq uyátano? aqá yemá Áánûqtuni aamá íma ítáa-kayukagararaq mirá kéoe. ");
INSERT INTO usa_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","miráinaq máqte-qtataaqtabama keráwáqtí túyánápímmá aati-aatimá arupú umá máero. miráuma keqtibomá Áánûqtuma wení márûpaqa aati-aatimá kateko umá máinikaa umá keráwákáráq mútûq katekoîq umá pááq umá ánatagoro.” téna Îtuma timá yímikaiye. ");
INSERT INTO usa_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","óq-aimma Îtuma timá yímikaiye: “keráwáqá atéráaro. keráwáqá Áánûqtukaq móra-yataariq ínéqa íma abarokáq mirá kéiyata máqte-kayukama kanaaráq timónanoe. keráwáqa waayúkayopake anó-meyaqtaba abáá kéiyanama ánibo keráwáqá mirá éqa keráwáqá móra-meyamma Áánûqtuma keqtibomá wení márûpaq máin-nakoma keráwáqá anó-meyamma ítiminiye. ");
INSERT INTO usa_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","ánibo keráwáqá móra-yataaqa áwáyoq-wayuka yimétaa yíwáqnaa ónáae téqa móra-naqa timákaiyana áqnáabaq kéwena anókaq ááyama ítíno. miráuma kaaqaari-wáyúkámá yeqtí monoq-náúpákáráq aapakáráq yemá mirán-ááímmá tarôq kéoe. yemá miráuma waabá-káyúkámá yeqtí yíwîqa múte yauwígáae téta mirá kéoe. kemá áraimma kétima-timune. mirá-káyúkámá yeqtí meyámmá minnâ áqa wáiye. káqomma anaaékaq íma mayánóe. ");
INSERT INTO usa_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","ánibo keráwáqá mórama áwáyoq-wayukama yíwáqnaa íné kéeqa kanaaráq aúpáq aúyoqma mirá-oro. ");
INSERT INTO usa_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","minnáyaba keráwáqtí túma íma mamé úyoro. ánibo keqtibomá Áánûqtuma aúpáq wái-qtataariq ommá káonaipoana wemá mi-wágóní íráqô-meyamma timíniye. ");
INSERT INTO usa_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","keráwáqá nunamummô kéteqa miráuma kaayaq-yóyáúkáráq-wáyúkáráá íoro. yeráwáqá itó-ureta nunamummá yeqtí monoq-náúpáqá tínétabi aapatáákaraqa miráuma waayúkama yimónaigaae téta miráoniq íoro. kemá keráwáqá áráimma kétima-timune. yemá mirá-káyúkámá yeqtí meyámmá áqa matááe. káqomma íma mayánóe. ");
INSERT INTO usa_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","miráimanibo keráwáqá nunamummô tínéqa keráwáqtí naaúpaq utéra oqtamá umá aúyaqmakeraq keqtibomá Áánûqtukaq nunamummá aúpáq aúyoqma tero. ánibo keqtibomá aúpáqá wái-qtataariq ónnama paá káonaipoana keráwáqá íráqô-meyamma timíniye. ");
INSERT INTO usa_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","keráwáqá nunamummô kéteqa netuq-áímmá Áánûqtun áama íma ítáa-kayukama teníkáá umá ítero. yemá yeqtí yúyánápímmá miráuma netuq-áítáá tenana ‘Áánûqtuma ketááí táama itániye.’ ");
INSERT INTO usa_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","téta mirá kétemanibo keráwáqá yeqtí yáaimma íma wáráaro. keqtibomá Áánûqtuma máqte-qtataaqa aqtórárîq o-qtátááqtábámá áqa ítaraiye. keráwáqá wekáqá íma móra-yataaqtaba ítaraawana wenókáá káonaiye. ");
INSERT INTO usa_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","keráwáqa maará téraq nunamummá tero. ‘keqtibotááo, emá yabíkáana-marukaq máanama enáwîkoma aokaq waíno. ");
INSERT INTO usa_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","ení yabi í-yátááqá maabáq kumíno. ení márûkaqa enaúyánámmá wáráanikaa umá maa-márábíkáráqá enaúyánámmá waránátaae. ");
INSERT INTO usa_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","íbêqa aáwaqtaba únnataama máqte-tupaama timiyo. ketááí otaa-qtátááqá mamá ");
INSERT INTO usa_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","paábaq kéyuwe awikátuwaao. miráuma otaa-qtátáárîq umátíkáa-kayukama yeqtí otaa-qtátááqá paábaq mamá kéyuwetaa tiwikátukaunataae. ");
INSERT INTO usa_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","emá keqtáá anómma makáqma aónai-yataaqa íma mamé. yéwaq Tááqtaaqtabama yabíqma akoqnáátaa umátikaao.’ ");
INSERT INTO usa_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","áre. ítáaro. keráwáqá káqo-yuti otaammá táí-yataaqa mamá paá umáyikaiyanama keráwákáráq keqtibomá Áánûqtuma wení márûpaq máena keráwáqtí otaammá táí-yataaqa mamá paá umátikaniye. ");
INSERT INTO usa_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","miráimanibo keráwáqá káqo-kayukati táí-otaa-qtataaqa íma mamá paá umáyikaiyanama kanaaráq keqtibomá Áánûqtuma wení márûpaq máena keráwáqtí táí-otaa-qtataaqa íma mamá paá umátikaniye. ");
INSERT INTO usa_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","ánibo keráwáqá aáwaqa awetá-ureq kanaaráq nunamummá tínéqa kaaqaari-wáyúkámá oníkáá umá táí-toiqa íma máráaro. yemá miráuma táí-yoiqa máráa-kayukama minnâ waayúkama yimónaamma yemá aáwaqa awetá-uraae. kemá áraimma kétima-timune. yemá yeqtí meyámmá áqa matááe. ókaraq meyámmá ímayanoe. ");
INSERT INTO usa_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","miráimanibo keráwáqá nunamummá tínópoaq aáwaqa awetá éqa kanaaráq keráwáqá tiqnópí tóiqa yotuwéraq tiqnótáuma mamá yaeq-yaeq oro. ");
INSERT INTO usa_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","miráinatama keráwáqa aáwaqa awetá-uraamma waayúkama íaonainoe. keqtibomá Áánûqtuma wenamáa wemá aónaniye. ánibo wemá móra-yataaqa aúpáq tarôq-o-qtataaqa káonaipoana keráwáqá meyámma timíniye. ");
INSERT INTO usa_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","keráwáqá íráqô-qtataaqa maa-márábímmá íma mamá áíkuyoro. maa-márábímmá kawanogómá kénaitana karogaro-nómmá káugitana máqte-qtataaqa mamá táíq kéitana moyá-káyúkámá kurumá yawítireta moyámmá kémayaae. ");
INSERT INTO usa_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","miráimanibo keráwáqá keráwáqtí íráqô-qtataaqa Áánûqtunopake mamá áíkuyoro. maami-qtátááqá kawanogómá íkénaitana karogaro-nómmá máqte-qtataakaqa ikáugitana moyá-káyúkámá kurumá yawítireta moyámmá íkémayaae. ");
INSERT INTO usa_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","keráwáqtí íráqô-qtataaqa kúmín-aukapaqa min-áúkápáqtábá aati-aatimá keráwáqá túyánámmá itéq mayánóe. ");
INSERT INTO usa_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","arukóní aúrakoma aúgoni óné. ánibo aúrakoma íráqôniq umá aónama kárutainanama ókómá máqtemma tirunóbáqá uyáberaniye. ");
INSERT INTO usa_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","ánibo keráwáqtí túrakoma táíq ínanama máqtemma keqtúraqa kumayuqá aurániye. miráinana min-ókómá keráwáqtí tirunóbáq wáin-okoma miráuma kumayukáá káurena mi-kúmáyúkómá mamá anómma aurániye. ");
INSERT INTO usa_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","móra-nakoma kanaaráq kaayaq-ánó-nákórátátí mayaímá móra-awaataq ímayaino. ánobo wemá móra-nakomma ítama táíq kéumakena móra-nakomma aati-aatimá yabíqma arútáyakaniye. ímo miráinanama móra-waigoqtaba kákainana móra-waigoqtabama íakaniye. keráwáqa mimórá táoqa Áánûqtukaq túyánámmá íma maréq mónekaqa túyánámmá íma kanaaráq maránóe. ");
INSERT INTO usa_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","miráitaq keráwáqá kétima-timune. keráwáqá keráwáqtí móneqnapo meyánîq ínóbo aáwaqtababi noqtábábi kéeqa mirá-i-qtataaqo mayánôqtaba taíbaq-tuyanamma íma ítáaro. aúwaraikoma minnâ nonábi aáwakomma uyátá-maqma anómma kateko-yátááré. unáákáqtôyataba taíbaq-tuyanamma íitaaro. miráitana aúgoma minnâ unáákáqtôgomma uyátá-maqma wáiye. ");
INSERT INTO usa_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","keráwáqá numamá aónaaro. yemá ánáyumma íkeubeta yemá aáwaqa mamá aáwaq-naupaq íkémaraae. miráimanibo keqtibomá Áánûqtuma wení márûpake numagómmá aáwaqa kéyimiye. keráwáqá numagómmá íyaq uyátáraao? aáwaqa íyaq kétimiyo? ");
INSERT INTO usa_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","keráwáqtí aúkáapikema náawaq taíbaq-auyanamma maqmá akoqnáá umá iténa aqtó-kánáámá arúbama wení aúwarai-kanaaraqa wíníyô? ");
INSERT INTO usa_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","ánibo keráwáqá nôraq itaráq unáákáqtôyabama netuq-túyánámmá kéitaao? keráwáqá túyánámmá ítama arútáaro. yaayúqnóbáqá wái-kiraati-yataakoma náaraq umábi kéuwibo aónaaro. yemá kammáa ígáaeta unáákáqtôma yenamáárîq íkáraataae. ");
INSERT INTO usa_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","miráimanibo kemá keráwáqá kétima-timune. naayóbáqá Tórómónima kíniboana wení íráqôn-otamma pááqyamma íma makáimanibo wemá íma íráqôn-unakaqtoma umátorena yaayúqnóbáké-kíráátí-yátáákóráá umá kéumatoraae. ");
INSERT INTO usa_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","owé. íbêqa námama yópí wái-qtataaqa aabáyaama yemá káráma irabí yuwánóe. ánibo mirá-káráá-qtátááqá minnâ Áánûqtuma ókon-okomma móqá amáyikaraiye. miráinaq keráwáqá aarawaamá wemá íyaq uyátá-maqma unáákáqtôma umátikaniyo? netuq-túyánámmá maami-qtátááqtábá kéitawanama keráwáqtí itáíq-itaiq umá yabi-í-yátáákómá pááqyamma wáiye. ");
INSERT INTO usa_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","miráinaq keráwáqá netuq-túyánámmá íma itéra ‘nóin-aawaraq nánúnataabiyo? nóin-nonaq nánúnataabiyo? ítero. ");
INSERT INTO usa_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","ímiye. máqtemma mi-qtátááqá Áánûqtun áama íma ítáa-kayukama mirá-qtátáákóní anaaé kéwaraae. miráimanibo keqtibomá Áánûqtuma wení márûpaq máena keráwáqá nói-qtataaqtababi ommá Áánûqtuma káonaiye. ");
INSERT INTO usa_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","miráimanibo keráwáqá túyánámmá ítama arútátuweraq Áánûqtuma yabíkái-qtataakoma máqte-qtataaqtaba uyátá-maqma tikaíno. ánibo keráwáqá wemá tiníq kéiyanama anaaékaqa maamin-óq-yátááqá keráwáqá timíniye. ");
INSERT INTO usa_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","miráinaq keráwáqá aabáyaayabama íma túyánámmá ítáaro. aabáyaa-kanaagoma wenamáárîq mi-kánááyábá taíbaq-ummaama wániye. móra-mora-kanaagoni ummaamá wé paá mi-kánáágónáé.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Îtuma óq-aimma timá yímikaiye: “keráwáqá yainaí-wáyúkáráá umá káqo-kayukama íma mamá yawááq-umayikaaro. anónnáma keráwáqá mamá yawááq-umatikanoe. ");
INSERT INTO usa_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","ánibo keráwáqá káqo-kayukama ítama yainaíyatama móraiq umá keráwáqá ítama yainaíyaniq umá keráwáqá ítama yainánoe. ");
INSERT INTO usa_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","nôraq itaráq keráwáqtí aanábógómá pááqyamma otaa-qtátáárîq kéowaqa keráwáqá anómma uyátá-maqma otaa-qtátáárîq kéoo? aanábógóní pááqyan-otaa-qtataaqa yaagetáraa umá wenaúrapi wáímanibo keráwáqtí anón-otaa-qtataaqa mútûq-yaraa umá túrakaq yawááq uráiye. ");
INSERT INTO usa_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","miráitaq keráwáqá tigaemá íyaq kéitaraq aanábógóqtábá maará kétimameo? ‘aanábô, enaúrapi táí-yataaq wáimma matuwánáae.’ téra kéteo? ");
INSERT INTO usa_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","kaayaq-tóyáúkáráq-wáyúkááo, áqnáabaq kenamáárîq túrapimma anó-qtataaqa wáimma paábaq matuwéro. anaaékaqa aanábógóní aúrapi wái-qtataaqa kanaaráq aónama aruté matuwaao. ");
INSERT INTO usa_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","keráwáqá móra íráqômma aokaq-yátááqá áwáábiqa kéta iyákáá-kayukama íma yíméro. ánibo keráwáqá Áánûqtuni áama íráqô-pateturaa umá mamá pógomma íma yíméro. mi-pátétúmá pógoma yítauqnapo yamá mapátuweta waéqma túpuinoe. ");
INSERT INTO usa_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","móra-nakoma akáinana mayánénama ítama aónaino. akáinana aónanenama abáá íno. oqtamá íyakaiyaba akáinanama oqtaráq paké-pake tíno. ");
INSERT INTO usa_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","miráinata máqte-kayukama Áánûqtukaq nunamupí ítama aónétama yemá wekáké mayánoe. máqte-kayukama móra-yataaqtaba Áánûqtumma abáá kéetama wemmá paá aónanoe. ánibo máqte-kayukama nunamupí téta Áánûqtunopaq ónátae tíyanama wemá yemmá iyuwáinata uyáberanoe. ");
INSERT INTO usa_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","keráwápíké móra-nakoni áanikoma aboáqtábá téna ‘yammá timiyo’ tínanama aboámá óqtamma mayamíníyô? ímiye. ");
INSERT INTO usa_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","ánibo iyápógoma aboáqtábá ‘noyááqa timiyo’ tínanama aboámá táí-iraakabayaamma amíníyô? minnágaraq ímiye. ");
INSERT INTO usa_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","miráitaq keráwáqá táí-wayukama kanaaráq kéitaamanibo keráwáqtí iyápógoma íráqô-qtataaqa yimíyábá kéitaae. uyátá-maqma móraiq umá keqtibomá Áánûqtuma wení márûpaq máin-nakoma wení iyápó-annama wekáq ítama aónaayuma íráqô-qtataaqa yimíyábá kéitaiye. ");
INSERT INTO usa_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","waayúkama nôrabi umátikaigaae tina-yátááríq kéumakaiyaama miráuma yekáráq móraiq umáyikaao. maaminnáma mákama Mótetini ámáan-aikaraq Áánûqtuni amuné-wáyúkágáráq tiráa-waigoni máqten-aaine. ");
INSERT INTO usa_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","keráwáqá pááqyan-amma wáráaro. aíta-marupaq uráin-aama anónapoana oyaaq uráitata netuqyaa-káyúkámá aarawaamá min-ámmá kéwaraabo min-ámmá íwáráaro. ");
INSERT INTO usa_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","káqon-amma matúq-matuq umá mái-auwaraimma mayaí-márúpáq uráin-akoma pááqyamma wáipoata yaímma arekáq-wayukama min-ámmá kammáa kaéta kéwaraae. ");
INSERT INTO usa_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","kaaqaari-ámúné-wáyúkáyábámá atéráaro. yemá yirunóbáqá abááq-íyákáá umá máapoata tipi-típigoni aúwaratima atáá-umaeta aúpáq-yááíkáráq keráwáqtôpaq kéye. ");
INSERT INTO usa_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","keráwáqá nôrabi iya-qtataaqa mikáq yeqtí yáaimma aónanoe. áwáábiq-annagoma íráqôn-aramma íkéiyaiye. ");
INSERT INTO usa_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","móraiq umá íráqô-tagoma íráqôn-aramma kéiyaiye. ánibo táí-yagoma táí-aramma kéiyaiye. ");
INSERT INTO usa_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","íráqô-tagoma táí-aramma kanaaráq íma iyániye. ánibo táí-yagoma íráqôn-aramma kanaaráq íma iyániye. waayúkagaraq móraiq urááe. ");
INSERT INTO usa_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","máqte-tagoma íráqôn-aramma íma iyaí-tagomma minnâ ayááma irabí kéiyaabotuwaae. ");
INSERT INTO usa_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","miráinaq keráwáqá aónaaro. kaaqaari-ámúné-wáyúkábíké keráwáqá áraimma yeqtí táí-yaaimma yimónainoe. táí-wayukama yirunóbáké íráqôn-aramma kanaaráq íma iyániye. ");
INSERT INTO usa_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","máqte-kayukama ‘uyátárai-nako, uyátárai-nako,’ mirá kétepoaq Áánûqtuma yabíkái-marupaqa íuyaberanoe. ímiye. paá náayubi ketibomá Áánûqtuma wení márûpaq máin-nakoni anaaé warétama kanaaráq Áánûqtuma yabíkái-marupaqa uyáberanoe. ");
INSERT INTO usa_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","mikáq anó-kanaamo pááq ínna-kanaaraqa aarawaamá maará téta timá-timinoe. ‘uyátárai-nako, uyátárai-nako, enáwîkaqtaa ketáámá amuné kúme uréire éwaunataae. enáwîkaketaa ketáámá táí-aagomma waayúka yúbikema mamá paábaq yuwéwaunataae. ánibo enáwîkaketa ketáá netuqyaan-áwááméq-yátáárîqa uráunataae.’ téta mirá tíyaqa ");
INSERT INTO usa_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","ánibo mi táoqa kemá yemmá abarokáq maará-tima-yimenune. ‘kemá keráwáqtí túrakaqa íaonewaunamiye. keráwáqá táí-wayukaao, paábataa kóoro’ tenúne.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","waéqma itaí-áímmá Îtuma tiráiye: “kanaaráq móra-nakoma maamin-áímmá iténa waraína-nakoma wemá miráuma áá-íté-wainapoana wení naammá óqtan-amuraaq kéumaraiye. ");
INSERT INTO usa_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","ánibo aaqá yuréna nommá aúgítana anón-uwaama yoréna mirái-qtataakoma min-námmá awétáraiye. miráimanibo min-námmá íma kuturáiye. min-námmá óqtakaq wáitanaboana yáqtoqma akoqnáá uráiye. ");
INSERT INTO usa_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","miráimanibo móra-nakoma ketáama kéitenamanibo ímo warénama minnâ wemá miráuma áíbôqnaaboq inápóana wemá wení naammá kegéba-amuraaq naammá kéiye. ");
INSERT INTO usa_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","ánibo aaqá yitana nommá augéna uwááma anómma yokáiye. ánibo mirái-qtataakoma min-námmá awétátuwaitana min-námmá kuturáiye. ‘pau’ titana anómma mútûq yawítíguraiye.” téna ");
INSERT INTO usa_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Îtuma maamin-áímmá timá ánatatuwaitata máqte-kayukama Îtun-aayaba iyánáaq éta yáaqa ôriq umá karáiye. ");
INSERT INTO usa_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","miráimanibo aamá yirááti-wayukaraa umá íma timá yímikaibo Îtuma akoqnááma náápaamma matokái-nakoraa umá aamá kétima-yimena yiráátiraiye. ");
INSERT INTO usa_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Îtuma anubakémmá yuwéna kúmítata netuqyaammá aarawaamá ókaraq anaaé waqmé kukááe. ");
INSERT INTO usa_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","mikáqá móra-naqa kárúyamma ákái-nakoma amakaq iréna araayutaúmmá ayéna tiráiye: “uyátáráana-nako, kanaaráq emmá akáinaama emá kemmá mamá éqtikanone.” titana ");
INSERT INTO usa_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Îtuma ayáámma árûqmarena tiráiye: “kemmá kétikaitaq miráona kéune. emmá érákaino.” titana mi-kárú-kárígómá ê mikáq ánataguraiye. ");
INSERT INTO usa_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","ánibo Îtuma mi-kárú-náqá timá ámikaiye: “emá atéqma arutaao. móra-nakomma timámenabo ímiye. emá uré enaúma anó-monoq-wayukama mó-yiraate naayóbáqá Mótetima tiráiniq umá Áánûqtukaq amí-yátááqá mó-amiyo. miráinata waayúkama aónéta ení karímá mikáq ánatagiye téta tero.” téna Îtuma timá ámikaiye. ");
INSERT INTO usa_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Îtuma Kápérana-marupaq uyábéráitana anón ááiq-i-naqa Arómani-marupake Îtunopaq iréna inaa téna timá ámikaiye: ");
INSERT INTO usa_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“ummaataráána-nako, ketí mayaí-náqá karímá mayéna naaúpaq waguréna máiye. ayáátákoma pukitana áíqa ôriq umá kéiye.” titana ");
INSERT INTO usa_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Îtuma yauwéqma timá ámikaiye: “wemmá kemá ko mamá érakanune.” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","miráitana ááiq-i-kawaa-nakoma yauwéqma timá ámikaiye: “ummaataráána-nako, kemá íráqôn-naqa íma máupo emá kanaaráq ketí naaúpaqa íma uyáberaao. emá paá aamá tinana ketí mayaí-náqá atóbáíno. ");
INSERT INTO usa_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","kegáráqá ketí anó-naapaamma wáiye. kemá mórama tiyááka ááiq-i-wayukati kawáá-náqá máune. miráitaq kegáráqá anó-kayukati yiménáápáqá máunata yemá yabítíkaraae. ketí timénáápáq máa-kayukama kemá timá-yimeq móra-naqtaba ‘emá waao’ túnanama wemá kanaaráq kéwiye. ánibo kemá káqo-waqtaba téq ‘emá maabáq iyo’ túnanama wemá kanaaráq kéiye. miráitaq kemá ketí mayaí-nákóqtábá ‘maa-máyáímá mayaao’ túnanama wemá paá kémayaiye.” téna titana ");
INSERT INTO usa_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Îtuma min-áímmá ítátuwena iyánáaq uráiye. ánibo wení anaaé wáráa-kayukama maará téna Îtuma timá yímikaiye: “keráwáqá áraimma kétima-timune. mórama Aánûqtuni waayúkabike Ítíráaeobake-naqa maan-nákómá maaráuma arummá tímínikaa-naqa íaonaraune. ");
INSERT INTO usa_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","ánibo kemá keráwáqá kétima-timune. netuqyaa-káyúkámá aabaú utaipáké íyata yaímma aabaú kupéráipake íyata uréta Áabaraagaraq Ááítekigaraq Yáakobogaraq mórabi yagaroqtamá Áánûqtu yabíkái-marupaq máeta aáwaqa nánóe. ");
INSERT INTO usa_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","miráimanibo Ítíráaeo-wayukama Áánûqtuma wemá yabíkái-marupaqa yeqtí yítaubikoma máamanibo yaímma Ítíráaeo-wayukama marabí máa-yuma yemá máápaq anó-kumayuqnobaq máeta ibiqá yaréta yíwáyaamma akégúnanoe.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","ánibo Îtuma ááiq-kawaa-naqa timá ámikaiye: “emá íbêqa kóaao. emá arummá timénaboana mirá ónaiq umá mi-qtátááqá pááq íniye.” téna Îtuma tiráiye. ánibo ê mi-kágáámá mi-kárí-náqá wení karígómá ayúwáitana atóbaraiye. ");
INSERT INTO usa_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","mikáké Îtuma Pitaani naaúpaq uyábékena aónaimma Pítaamma ánáakomma anóamma kokoqyámma ákáitana atípáaraq waguré máitana Îtuma aónaraiye. ");
INSERT INTO usa_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","ánibo Îtuma ayáákaq yáqtóráitana kokoqyámma érákáraiye. ánibo min-íníkómá itó-urena Îtuni aáwaqa mamá yokaa umákaraiye. ");
INSERT INTO usa_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","énaikaq taíbaq-wayukama táí-aagoma mái-kayukama yiwíqmeta Îtunopaq irááe. ánibo Îtuma paá aamá kétitana mi-káyúkábíkémmá waátá aágoma iyuwéna kóuraiye. ánibo Îtuma máqte-kari-wayukama mamá atóbamayikaraiye. ");
INSERT INTO usa_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","miráitana móra-aimma naayóbáqá Áánûqtuma móra amuné-náqá Áítáíyaan óyaukaq pááq íniye tiráimma minnâ pááq kéitana min-áíkómá maará-tiraiye: “wemá wenamáárîq ketááí karímá mamá paábaq kéyuwena ókon-okomma ketááí tiyáátáma íkui-yataaqa matukáiye.” téna agamatán-áúbágó tiráiye. ");
INSERT INTO usa_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","netuqyaa-káyúkáma Îtuma ikúyakaraawana yimónawaaena wení iyápó-annama timá yímikaiye: “nokaayúkómmá meranábápáq méwíyataao.” ");
INSERT INTO usa_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","titana mórama ámáan-aimma yirááti-nakoma iréna Îtumma timá ámikaiye: “yirááti-nako, emá náakarabi wíné inabáqá kegáráq waqmé ónúne.” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Îtuma yauwéqma timá ámikaiye: “abááq-íyákáwákómá yeqtí ánáamma maínarunobaq wáitana numaráwákóní ánáamma wáimanibo Waayúkagoni Áráaqa kemá Îtuma kemá wagéqa tiqnómmá maqmá arage ónúna-namma íma wáiye.” téna Îtuma timá ámikaiye. miráitana Îtuni anaaé waráina-waigoma wení naammá móraiq umá wániyo? ");
INSERT INTO usa_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","ánibo káqomma móra iyápó-annabike-nako Îtumma timá ámikaiye: “ummaataráána-nako, kemá kanaaráq awé uráanana ketibomá puínaq mó-uqtamakatuwerabiyo?” mirá titana ");
INSERT INTO usa_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Îtuma timá ámikaiye: “ibáqyuwaao. yemá pukáá-kayukama yenamáárîq matúq-matuq umá mái-auwaraiqtaba pukáiya-kayukama mamá arááq-yuma kanaaráq uqtamáyikanoe. emá paá ketinaaé ya waraao.” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","mikáké Îtuma únópí-káárébí úítata wení iyápó-annama anaaé wakááe. ");
INSERT INTO usa_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","anómma únóníyámá mi-nókááyúpímmá kémetena únóníyágómá únópí-káárémá yawááq inena uráiye. miráimanibo Îtuma paá waguréna máqe-uraiye. ");
INSERT INTO usa_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","ánibo yemá Îtumma ko awáútureta tirááe: “uyátárai-nako, emá keqtáá tíwáqnaa uwo. ketáámá yubékonataa kéune.” téta tewana ");
INSERT INTO usa_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Îtuma timá yímikaiye: “nôraq itaráq ikatîqa kéoo? keráwáqtí itáíq-itaiq umá yabi-í-yátááqá pááqyamiye.” timátuwena Îtuma itó-urena uwáágokaraq nokókáráq yiwáágúraiye. ánibo uwáágoma mó-áráwáá itana nokómá ókaraq íma noniyamá metaráiye. ");
INSERT INTO usa_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","minnáyabi iyápó-annama netuq-yúyánámmá kéiteta tirááe: “maaminnáma nóikaa-nare ténaq máitanawaq uwáágogaraq nokógáráqá wenáama kéwaraayo?” téta tirááe. ");
INSERT INTO usa_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Îtuma yetê nokaayúkómmá meranábápáq Káátarini-wayukati marabáq atamá uráiye. ánibo kaayaq-nákámá táí-aagoma yenákábí mái-nakorata Îtumma ya aónaraaye. yenákámá pukáa-kayukati mararaapáqá máátíq-máatipaq máqeta irááye. yenákámá anómma abááqá amáguraayataboata waayúkama min-ákáqá íma uréire urááe. ");
INSERT INTO usa_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","ánibo min-nákórátámá anókaq ááyama wááqa kéyeta tirááye: “Áánûqtuni áaniko, emá kekárátámá nôraq umátikaneq kéono? kanaamá íma pááq-uraitaa keqtáámá tíqa í-yátááqá má-timinetaa kéono?” téta tirááye. ");
INSERT INTO usa_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","mórama pó-annama nékaq máeta aúmá narááe. ");
INSERT INTO usa_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","ánibo táí-aagoma Îtukaq inaa téta tirááe: “kanaaráq emá keqtáámô tíkamma waréma emá kanaaráq timátíkénataa ketáámá mera-pó-ánnátí yirunóbátáá kobéráano.” téta tirááe. ");
INSERT INTO usa_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","ánibo wemá mi-táí-áágómmá timá yímikaiye: “keráwáqá kóoro.” téna Îtuma titata yemá mi-kááyáq-nákámá iyuwéta pó-annati yirunóbáq uyábékaae. mi-pó-ánnámá máqtepaq péqmareta mórama áítabaq metamá kukááe. ánibo yemá nokaayúpítáá metaréta nommá nawíketa máqtepaq pukááe. ");
INSERT INTO usa_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","ánibo pó-kawaa-wayukama péqmareta kóuraae. yemá anó-marupaq koyaréta yemá máqtemma min-áímmá tébakaq-wayukama timá yímikaae. miráitata kaayaq-nákábímá táí-aagoma pááq i kátáama tirááye. ");
INSERT INTO usa_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","ánibo min-ánó-márúpáké-káyúkámá netuqá iréta Îtuqtaba ya abáá-uraae. yemá Îtumma ya aónatuweta weqtábá mi-márábákémmá yuwéna káqo-marabaq kóikaae téta inaa tirááe. ");
INSERT INTO usa_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Îtuma únópí-káárébí yetê nokaayúkómmá meran-ábápáq yauwéqma uréta Îtuni márûpaq koyarááe. ");
INSERT INTO usa_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","mibáq yaímma-wayukama móra-kari-naqa Îtunopaqa awíqmeta iráama mi-kárí-nákóní ayáátákoma pukuráitana kúkutaaraq waguráitata yaagumé irááe. ánibo Îtuma mi-káyúkámá yimónaimma wekáq itáíq-itaiq kéowanaboana Îtuma mi-kárí-nákómmá timá ámikaiye: “iyápógo, enáyakoma kaayoné íno. ení kúmiq-yataaqa kemá paábaq kématuwaune.” téna Îtuma titata ");
INSERT INTO usa_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","yaímma ámáan-aimma yirááti-wayukama yeqtí yúyánánóbáqá “maan-nákómá Áánûqtumma aamá káwaagiye.” téta tirááe. ");
INSERT INTO usa_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","miráitana mi-káyúkátí yúyánánóbáqá Îtuma yimónatuwena wemá tiráiye: “keráwáqá nôraq itaráq keráwáqtí túyánánóbáqá ítama táíq kéoo? ");
INSERT INTO usa_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","nóin-aikowaq ketí náápaamma yiráátiniyo? ánibo kemá téqa ‘ení kúmiq-yataaqa mamá paábaq yuwaúne’ mirá túnawaq íma oyaaqá kéi aqá ánibo ‘emá itó-uma uréire uwo’ túnna-waigoma minnâ íma oyaaqá éna ummaa kéyaiye. ");
INSERT INTO usa_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Waayúkagoni Áráaqa náápaamma maa-márábímmá kanaaráq kúmiq-yataaqa mamá paábaq yuwánîqtaba yiráátenune.” téna tiráiye. miráitana Îtuma ayáátámma puki-nákómmá timá ámikaiye: “emá itó-ure ení kúkutaama mamé ení naaópaq kóaao.” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","miráitana mi-kárí-nákómá itó-uma wení naaópaq kóuraiye. ");
INSERT INTO usa_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","ánibo aarawaamá miráimma aónéta ikatîq ôriq urááe. yeráwáqá aónaraae. Áánûqtuma mirán-ákóqnáámá ámikaiqtababoana yemá Áánûqtun-awiqa múte yaútaae. ");
INSERT INTO usa_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Îtuma mibáké kéwena aónaimma móra-naqa táákiti-moneqa mayaí-náúpáq máqe-uraimma min-nákóní áwîqa Máátiyuma mi-kátáámá agatái-nare. ánibo Îtuma Máátiyumma timá ámikaiye: “emá ketinaaé ya waraao.” titana wemá itó-uma Îtun anaaé wakáiye. ");
INSERT INTO usa_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","anaaékaqa Îtuma naaúpaq máena aáwaqa kénaitata netuqyaa-káyúkámá táákiti-moneqa máyáa-kayukagaraq káqomma karere-káyúkágáráq ‘paátataare’ timá yíkáa-kayukagaraq Îtunopaq irááe. yemá Îtugaraq wení iyápó-annagaraq umá máeta aáwaqa narááe. ");
INSERT INTO usa_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","yemá Pérati-wayukama miráomma aónawaaeta yemá Îtuni iyápó-annama maará téta ítama aónaraae: “nôraq itanawáq keráwáqtí yirááti-nakoma kúmiq-wayukagaraq táákiti-moneqa máyáa-kayukatema aáwaqa kénaiyo?” téta ítama aónaraae. ");
INSERT INTO usa_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Îtuma min-áímmá ítátuwena wemá maará téna aúpáq-áímmá tiráiye: “waayúkama karímá ímo máyáa-kayukama tótaa-wayukayopaq íma kéoe. ímiye. paá karí-wáyúkámá tótaa-wayukayopaqa kéoe. ");
INSERT INTO usa_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","keráwáqá uréraq Áánûqtuni watáama agamatá-kánnáábíkén-áímmá ko ítáaro. ‘naí-wámmá ikáma kekáq timíyábá kemá íkétikaibo kaayoné-yátááqtábá kemmá kétikaiye.’ téna agamatá-kánnáágómá kétiye.” téna Îtu timátuwena tiráiye: “arupú-wáyúkámúne tíya-kayukama yááyanaaq íkukaune. ímiye. kemá paá kúmiq-wayukayaba yááyanaa kukáune.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","mi-kánááráqá Yóáanema nommá peraí-nákóní iyápó-annama Îtunopaq iréta tirááe: “nôraq itataawáq ketáágáráq Pérati-wayukagaraqa nunamummô ténátaama aáwaqa awetá kéunatataa ení iyápó-annama nunamummá tí-kánááráqá aáwaqa íma awetá kéoo?” ");
INSERT INTO usa_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","téta mirá tewana Îtuma timá yímikaiye: “móra-nakoma aaramá mayáné kéenama omákáqá paá wení aanábó-wáyúkáté máenama kanaaráq áyakoma táíq íníyô? íma aokarîq kéiye. anaaékaqa mi aaramô mayáné i-náqá paábaq matuwaíyanama min-nákómá ókaraq wení aanábó-wáyúkátêma íma mániye. miráuma aaramá mayánéna i-nákóráá umá mi-kánáámá ínaqa kemá kónatama íyakoma táíq ínipoata yemá aáwaqa awetá-inoe. ");
INSERT INTO usa_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","ítáaro. móra-nakoma wení naayó-kúbéráí-únámmá yakákitanama aúge-tabaraaberake maqmá aráátaimma íma aokarîq kéiye. miráinanama mi-tábáráábégómá keqnáámmá naayó-kúbéráí-únámmá yakáqma anó-kariq umáginiye. ");
INSERT INTO usa_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","keqnáámmá ítáaro. móra-nakoma naayó-mémégóní aúwarati-unapima wááéni-nomma aúgema íma áítewae kéiye. miráitata yemá aúge-kaaeni-nomma naayó-mémé-áúwárátíbí áíqtowanama íma aokarîq kéiye. miráitana méme aúwaratigoma yarákínana wááéni-nomma marabí aqtíma kugúbaginiye. miráimanibo áá ítaraa-kayukama aúge-memegoni aúwaratibi wááéni-nomma aqtímaraawana mákama íráqôniq umá paá kéwaiye.” téna Îtuma tiráiye. aúge-qtataakoma waéqma naayón-ááímmá íauraniye. ");
INSERT INTO usa_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","téna Îtuma maamin-áímmá kétima-yimikaq mórama anó-kawaa-naqa Îtun-amakaq iréna araayutaúmmá ayéna timá ámikaiye: “ketiyáámûmma paá íbêq pukuráiye. ánibo emá kanaaráq iré ayáámma aneq mó márénana atóbama yauwéqma paá maíno.” téna anó-kawaa-nako tiráiye. ");
INSERT INTO usa_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","ánibo Îtuma itó-uma mi-káwáá-nákóní anaaé waqmé kéwitata wení iyápó-annama móraiq umá wakááe. ");
INSERT INTO usa_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","uréire kéowana móra-inimma mikáqá máqe-uraimma máqte-tupaama inaautámma ákáitana inaaupaqá tiyááka umá kaayaq-kárítímáátímá máqe-uraiye. min-íníkómá Îtuni anaaépaq amakaq iréna Îtuni wáqtôgoni aqtóráq ayáámma yama yáqtokaiye. ");
INSERT INTO usa_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","min-íníkómá wenamáárîq wení aúyánánóbáqá maará-tiraiye: “Îtuni wáqtôraq tiyáámo ánékuyonanama túnobaq kanaaráq umátikaniye.” téna ánékukaiye. ");
INSERT INTO usa_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Îtuma waéqma wemmá aónatuwena tiráiye: “ketiyáámuko, enáyakoma kaayoné íno. ení itáíq-itaiq umá yabi-í-yátáákómá emmá miráuma mamá érákáraiye. mi táoqa min-íníkóní karímá ánataguraiye. ");
INSERT INTO usa_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Îtuma mi-káwáá-nákóní naaúpaq iréna waayúkama ibiq-ímá kéteta aamá anón-aimma kétewana yimónaraiye. ");
INSERT INTO usa_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","ánibo Îtuma tiráiye: “keráwáqá maí abátíkáaro. pááqyan-inaaruma íma pukáiye. wemá paá aúmá waguráiye.” téna Îtuma mirá-tiraimma áraimma pukuráitataboata mi-káyúkáma wíráa umákaraae. ");
INSERT INTO usa_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","ánibo yemá aarawaamá waqmá paábaq yúwáawana Îtuma mi-náúpáq uténa pukáin-inaarugoni ayáákaq yáqtorena ayáátóráitana itó-uraiye. ");
INSERT INTO usa_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","mi kátáagoma min-áúkápáq máqte-marabaq wéyáwé uráiye. ");
INSERT INTO usa_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Îtuma mi-márúqá yuwéna kóuraiye. ánibo kaayaqá yúramma karoparái-nakorata Îtun anaaé waqmé kéweta anókaq ááyama tirááye: “áe, naayóbáqá ketááí kínima Tébitin-annabike-nako, emá kekárátá arummá umátikaao.” ");
INSERT INTO usa_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","téyana Îtuma naaúpaq uyábéráitata yúrammo karopági-nakama wenôpaq utááye. Îtuma min-nákámá timá yímikaiye: “kenákámá itáíq-itaiq kéoyaqtaba kemá kenákámá kanaaráq mamá atóbatikanuno?” téna ítáitata yenákámá Îtumma yauwéqma timá ámikaaye: “owé. uyátáráana-nako.” téta tirááye. ");
INSERT INTO usa_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","ánibo Îtuma min-nákátí yúrapi ayáámma kánekuyena tiráiye: “kenákámá itáíq-itaiq óya-qtataaqtaba kemá kanaaráq miráona-yataakoma pááq íno.” téna Îtuma timá yímikaiye. ");
INSERT INTO usa_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","ánibo yenákátí yúrakoma tágaraiye. Îtuma akoqnáá-aimma timá-yimena min-nákáyábá tiráiye: “atéráakao. móra-nakoma maamináyabama itaínabotekao.” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","ááqibo min-nákámá máápaq yaúbareta máqtemma min-áúkápáq-márábáqá Îtuni watáama timáeta uréire urááye. ");
INSERT INTO usa_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","yenákámá kóiye kéeta yaímma-wayukama móra-naqa táí-aagoma wepí máinapoana aamá ítitata wemmá yemá awíqmeta yewana Îtunopaq iráiye. ");
INSERT INTO usa_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","ánibo Îtuma táí-aagomma matúwáitana min-nákómá aamá áaimma átáma tiráiye. minnáyaba aarawaamá iyánáaq uréta netuq-yúyánámmá kéiteta tirááe: “naayóbáqá maakáqá Ítíráaeobaqa maamirá-qtátááqá íma pááq uráine.” téta tirááe. ");
INSERT INTO usa_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","miráimanibo yaímma Pérati-wayukama maará-tiraae: “wemá táí-aagoni kawáá-nákómá wemmá akoqnááma ámikaitana wemá táí-aagomma kanaaráq kématuwaiye.” téta tirááe. ");
INSERT INTO usa_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Îtuma anó-marupakaraq pááqya-marupakaraq uréire kéena wemá monoq-náúpáqá kéyiraatena Áánûqtuma yabíkái-qtataaqtaba átê-wataama kétima-yimena máqte-karimo máyáa-kayukama mamá atóbamayikaraiye. ");
INSERT INTO usa_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","wemá aónaimma netuqyaammá aarawaamá yimónatuwena arummá umáyíkaraiye. miráuma taíbaq-yuyanamma itéta ‘náawaq tíwáqnaa íníyô? náakaraq ónúnataabiyo?’ téta miráuma tipi-típigoma yeqtí kawáá-náqá íma máitata oníkáá urááe. ");
INSERT INTO usa_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","miráitana Îtuma wení iyápó-annama aúpáq-áímmá timá yímikaiye: “netuqyaammá aáwaqa yópímmá wáimanibo mamá áíkuyaba íma netuqyaammá mayaí-wáyúkámá mááe. ");
INSERT INTO usa_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","miráinaq keráwáqá Áánûqtukaq nunamummá kétiyana wemá yókóní aboámá yaímma mayaí-wáyúkáma timáyikainata wení waayúkama ko mamá áíkuyoro.” téna Îtuma timá yímikaiye. ");
INSERT INTO usa_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Îtuma tiyááka umá kaayaq-íyápó-ánná-wáyúkámá yááyamaena iréna yemmá akoqnááma yiména táí-aagoma kématuweta máqte-karima mamá paá kéeta yúgoni ummaa-yátááqá mamá paá ígáae téna yímikaiye. ");
INSERT INTO usa_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","tiyááka umá kaayaq-íyápó-ánnátí yíwîqa maará-uraiye. áqnáabaq-nakoni áwîqa Tááímonie káqon-awiqa Pítaae. ánibo ábâkoma Áánarue. ánibo Yêmitima Yéberimma áanikoboana ábâkoma Yóáane. ");
INSERT INTO usa_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","ánibo Píripima Paatááromiyue. ánibo Tómáátie. Máátiyuma mi-kátáámá agatái-nare. wemá táákiti-moneqa mayaí-náré. ánibo Yêmitima Áápiatimma áanikoe. ánibo Tááqtiatie. ");
INSERT INTO usa_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","ánibo móra-Taaimonima ítápéniti (indipendens) karuwaaq-náré. ánibo Yúqtaati Itikááriotie. wemá Îtumma awîqma namuro-wáyúkátí iyáápi makái-nare. ");
INSERT INTO usa_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Îtuma tiyááka umá kaayaq-wáyúkámá timáyíkáitata kówana yímáamma yiména maará-tiraiye. “keráwáqá Yéqtaaeo-apaq káqon-anna-wayukabaqa íoro. Táméria-marupaqa ókaraq íma uyáberanomanibo ");
INSERT INTO usa_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","keráwáqá Ítíráaeo-tipi-tipi-annama máápaq oro. yemá Áánûqtuqtaba yeráwáqtí aammá yukááe. ");
INSERT INTO usa_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","keráwáqá uréraq aamá maará téraq mó tero: “Áánûqtuma yabíkái-kanaama waaqókáq kéiye. ");
INSERT INTO usa_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","miráinaraq keráwáqá karí-wáyúkámá mamá kátobamayikera pukáiya-kayukama mamá itómayikera kárú-wayukama mamá kátobamayikera táí-aagomma mamá paábaq kéyuwera oro. keráwáqá móra-yataaqa ketôpake mayaíyama minnâ keráwáqá paá yímero. miráinaraq keráwáqá maami-qtátááqá yemmá yiméraq keráwáqá íma meyámmá máyáaro. ");
INSERT INTO usa_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","keráwáqtí unáápímmá móneqa íma áítumaera uréire oro. ");
INSERT INTO usa_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","mónekaraq anó-moneq-awiqa yáíya-qtataakaraq ariroq-únápí áíti-unamma íma mamé uréire éra kaayaq-tíyótáámá íma kúberera títauq-anaamma íma kúberera yáumma amé uréire í-yátámá íma matóráaro. ímiye. mayaímá mayaína-nakomma kanaaráq wení aáwaqa áméro. ");
INSERT INTO usa_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","móra anó-maruparabi pááqya-marupaq uyábereqa kanaaráq keráwáqá aónaiyana mi-márúkákémmá móra-nakoma arupú éna wení naaúpaqa máqeraq mi-márúqá yuwé kóine kéeqa ayuwé yero. ");
INSERT INTO usa_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","ánibo keráwáqá móra-naupaqa uyábereqa mi-náúpáq-wáyúkámá miráo-maarao-aimma téraq ‘kaayoné-yátááqá keráwáqtôpaq waíno’ timá yíkáaro. ");
INSERT INTO usa_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","ánibo mi-náúpáq-wáyúkámá keráwáqtábá yetê máigaae téta tíyaqa keráwáqtí kaayoné-yátáákómá yeqtôpaq wínîmanibo yemá keráwáqtábá máigaae téta íma tíyaqa keráwáqtí kaayoné-yátáákómá yuwéqma keráwáqtôpaq íno. ");
INSERT INTO usa_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","móra-nakoma keráwáqa tiwíqmena ímo wéna keráwáqtí táama íma itaínaqa ánibo keráwáqá mi-márúrábi min-námmá ibáqyuwera keráwáqtí tibíkáké káítôma popoq umátuwe kóoro. ");
INSERT INTO usa_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","kemá keráwáqá áraimma kétima-timune. aarawaamá ítama Áánûqtuni yainaí-kánááráqá Komóraa-marukake táí-wayukagaraq Tótôma-marukake táí-wayukati anónnáma táí-meyamma wáipoata miráumaraa mi-márúkáq-wáyúkámá yeqtí táí-meyamma pááq íniye. ");
INSERT INTO usa_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","ítáaro. kemá keráwáqá miráuma tipi-típi áráakaa umá taáqa íwái-kama áwáábiq-iyakaa-kayukati aúkáapi timátikaunaq kéoe. miráinaraq keráwáqá miráuma iraakabayaakóráá umá yáakarera atéqma wiqmé kéweraq móra-yataariq ínéqa túyánámmá ítama arútátuwero. mimórá táoqa keráwáqá móra-numama máagoraa umá kaayoné umá máero. ");
INSERT INTO usa_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","keráwáqá waayúkayabama atéqma arútáaro. yemá yeqtí káánítôre-wayukaraq aamá ítama yainéta ánnáma timéta keráwáqá yeqtí monoq-náúpáqá tebûqa timéta ínóe. ");
INSERT INTO usa_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","ketíwîqa márúte yuwánéra kéowaa téta keráwáqá tiwíqmeta kínima anó-kamaani-wayukati yúrakaq wínóe. miráinaq keráwáqá aamá kétima-yimeqa Yéqtaaeo-wayukagaraq Îtíráaeo-annabike-kayukagaraq Áánûqtuni átê-wataama timá-yiminoe. ");
INSERT INTO usa_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","yemá keráwáqá tiwíqma aamá ítama yainaíyaqa keráwáqá ikatîq íéraq ‘ketáámá nóine ténúnô? ketáámá nóin-ainaq yauwéqma timá-yimenunataabiyo’ ítero. kíq-taoqa aamó tínón-aimma timínímma ");
INSERT INTO usa_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","kenamáa keráwáqá aamá ítinoe. ímiye. keqtibomá Áánûqtuni Aágoma keráwáqtí tóyaukaq aamá tíniye. ");
INSERT INTO usa_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","mi-kánááráqá móra-nakoma ábâkomma awíqmena yaímma-wayukati iyáápi mó-marainata ikámma puínóe. ánibo aboámá áanikomma móraiq umá waayúkati iyáápi mó-marainata ikámma puínóe. ánibo iyápóma yinóboyuma komarummá íyataboata namuro-wáyúkámá yíkamma puínóe. ");
INSERT INTO usa_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","keqtábábóata yaímma-wayukama keráwáqá ítama táíq umátikanoe. minnâ móra-nakoma akoqnáá umá máqena aqtó-kánááráqó wénama min-nákómmá Áánûqtuma yauwéqma awiraínana wemá Áánûqtuna mániye. ");
INSERT INTO usa_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","ánibo yemá keráwáqá móra-marukaq táí-aaimma tarôq umátikaiyaqa kanaaráq mikákémá péqmarera káqo-marukaq oro. kemá áraimma kétima-timune. keráwáqá máqtemma Ítíráaeo-marupaqa íma mayaímá mamá ánataraiyaqtaba Waayúkagoni Áráaqa kemá kumónúne. ");
INSERT INTO usa_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","tugaru-íyápógómá wení arááti-naqa íma kéuyataitana paá-mayaima máyáa-kayukama yeqtí kawáá-wáyúkámá íma kéuyataae. ");
INSERT INTO usa_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","mórama tugaru-íyápógómá wení arááti-naqa maínama minnâ kanaa íniye. ánibo paá-mayai-nakoma wení kawáá-náqá uyátá-maqma anómma maínama minnágaraqa kanaa íniye. kemá keráwáqtí kawáá-náqá kemmá táíq kéumatikaapoata keráwáqá anómma táíq umátikanoe. ketíwîqa Píétebue téta tíwîqa yaráamanibo kemmá táí-tiwiqa kéyetama keráwáqá náayuwabi ketí iyápó-annati tíwîqa uyátá-maqma anómma táí-tiwiqa yánoe. ");
INSERT INTO usa_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","miráinaq waayúkayaba keráwáqá íma ikatîqa oro. máqte-qtataaqa aúpáq wái-qtataakoma anaaékaqa abarokáq íniye. máqte-qtataaqa ánáákuma wáina-yataaqanibo anaaékaqa waayúkama aónainoe. ");
INSERT INTO usa_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","kemá Îtuma aamá kumayuqnóbáqô timá-timunama minnâ wágááma timá yíméro. ánibo aamá yaákareq táápikemo ítáama minnâ keráwáqá netuqyaa-káyúkátí yúrakaq itó-urera aamá timá yíméro. ");
INSERT INTO usa_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","waayúkama keráwáqtí túma tíkamma uqtánô-kayukayaba íma ikatíqa oro. keráwáqtí tirun-íyápómá íma tíkamma uqtánóe. ímiye. Áánûqtuqtaba ikátéro. keráwáqtí túgaraq tirun-íyápógáráq mákama kanaaráq Tááqtaani márûqa aítanobaq Áánûqtu kanaaráq tíkama aúyotuwaniqtaba Áánûqtuqtaba ikátéro. ");
INSERT INTO usa_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","keráwáqá kaayaq-númámá tarukíqa móneqa kímora-toeyaarake kanaaráq meyánîq ínoe. ánibo keqtibomá Áánûqtuma íakainanama kanaaráq móra miráuma pááqya-numama marabímmá íkuminiye. ");
INSERT INTO usa_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","ánibo keráwáré keráwáqtí tiqnótáuma máqtepaq Áánûqtuma yoráútukaiye. ");
INSERT INTO usa_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","miráinaq keráwáqá íma ikatíq oro. netuqá pááqya-numagoni meyámmá uyátáraapoana keráwáqá Áánûqtuma yabíqtíkáraiye. ");
INSERT INTO usa_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","móra-nakoma náawabi abarokáq timá tágena wemá kennaé téna máqte-kayukati yúrakaq tínna-nakomma ketêgaraq ketibomá Áánûqtun aúrakaq wení márûpaq wemmá móraiq umákanune. ");
INSERT INTO usa_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","ánibo móra-nakoma kemmá máqte-kayukati yúrakaq anaaémma umátikai-naqa kegáráq wemmá ketibon aúrakaq wení márûpaq tinaaémma umákanune. ");
INSERT INTO usa_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","maa-márábí kaayoné-yátááqá mamá maa-márábí-káyúkáyábá íma mamé kukáune. mirá túyánámmá íma ítáaro. kemá paá waayúkama yainaí-tókórú-yámmá ketáama íwáráa-kayukagaraq ketáama wáráa-kayukagaraq aúkáapike mamá yainanááq mamé kukáune. ");
INSERT INTO usa_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","ááiqa áanikokaraq yeqtibogáráq íyata ánibo ayáámukokaraq yinóakaraq íyata ánibo anáábukokaraq aítaakogaraq í-ááímmá átaraune. ");
INSERT INTO usa_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","waagóní we-áánínábóbí anómma uyátá-maqma namuromá aúqma mánoe. ");
INSERT INTO usa_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","ánibo móra-nakoma anóayaa aboáyábá arummá uyátá-maqma yiménama wemá kennámá auráíyábá íma umaataráiye. móraiq umá móra-nakoma áanikoyaa ayáámukoyaba arummá uyátá-maqma yiménama wemá kennámá auráíyábá íma umaataráiye. ");
INSERT INTO usa_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","ánibo móra-nakoma wení kaapaq-yámá íma maména ketinaaé íma waréna puínéna yokaa íenama wemmá kennámá auráíyábá íma umaataráiye. ");
INSERT INTO usa_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","móra-nakoma maamin-áúwáráímmá yáqtoqma akoqnáá énama wení matúq-matuq umá mái-auwaraimma aúyorainimanibo móra-nakoma keqtábá puyénama wemá matúq-matuq umá mái-auwaraimma mayániye. ");
INSERT INTO usa_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","móra-nakoma náawabi keráwáqá mamá íráqôniq umátikenama wemá kekáráq mamá íráqôniq kéumatikaiye. ánibo móra-nakoma náawabi kekáráq mamá íráqôniq umátíkái-nakoma wemmá Áánûqtuma timátíkarai-naqa mamá íráqôniq kéumakaiye. ");
INSERT INTO usa_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","máqtemma náayuwabi Áánûqtuma timáyíkarai-kayukama mamá íráqôniq kéumaketama Áánûqtuma timákaraiqtaba mirá kéumakaapoata yemá timákarai-nakoni íráqô-meyamma yáíkaaq umá mayánóe. ánibo náayuwabi aónáíyamma mórama arupú-naqa ínata yeqtí yúyánánóbáqá téta ‘arupú-naqa áwáqnaa ónáátae téta min-náqá awíqmeta yeqtí naaú wétama yemá miráuma arupú-nakoni íráqô-meyamma yáíkaaq umá mayánóe. ");
INSERT INTO usa_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","taákaq máráaro. móra-nakoma náawabi paá-nakomma ketinaaé wáráa-kayukabike áwáqnaa ónáae téna paá yaugiq-nómmá aqtíma wemmá aménama kemá áraimma keráwáqá kétima-timune. anaaékaqa min-nákóní íráqô-meyamma áraimma mayániye.” téna Îtuma wení iyápó-annamma timáyíkaraiye. ");
INSERT INTO usa_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Îtuma wení tiyááka umá kaayaq-íyápó-ánnámá mayaímá mayánón-aimma miráuma timá yímikaiye. aamá timá ánatatuwaitata yemá mi-márúqá yuwéta min-áúkápáq-márúpáq uréta Îtuma aarawaamá kéyiraatena aamá timá yímikaiye. ");
INSERT INTO usa_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Yóáanema nommá peraí-nákómá ánná-naupaq máena yauwéqma yiwiraí-nákóní mayaíyábá ítaraiye. miráitana Yóáanema yaímma wení iyápó-annabike timáyíkáitata Îtunopaq urááe. ");
INSERT INTO usa_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","ánibo yemá Îtunopaq uréta ítama aónaraae: “emá maamin-nátábáwáq Yóáanema anaaékaq móra-naqa yíniye tiráinaraq máa káqo-natabataaq awé ónúnataabiyo?” tewana ");
INSERT INTO usa_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Îtuma yauwéqma tiráiye: “keráwáqá uréraq Yóáanemma máqten-aimma itéq máqte-qtataaqa aónaamma mó-timamero. ");
INSERT INTO usa_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","minnâ yúramma koroparái-kayukama yúramma káonaawata yítauqa táíq urái-kayukama yítauq-uramma yamá uréire kéoe. ánibo kárúyamma yíkái-kayukama kátobaawata yaáqa atíragurai-kayukama aamá kéitaae. ánibo pukáa-kayukama kéitowata áwáyoq-wayukama Áánûqtuni átê-wataama aúgen-aimma kéitaawata kéoe. ");
INSERT INTO usa_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","ánibo móra-nakoma arummá kétimena keqtábá kaayaq-áúyánámmá íma itaí-waigoma wemá amuqá maraíno.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Yóáaneni iyápó-annama kówana Îtuma Yóáaneqtaba taíbaq aarawaamá timá yímikaiye: “naayóbáqá waayúka íma máa-kaqmaapaq keráwáqá urááma nói-qtataaraq ko aónaneraq uráánabiyo? keráwáqá móra-naqa kaayaq-áúyánákáráq ókáráákáá uwáágoma yaropamátúwáimma aónaneraq uráánabiyo? ímiye. ");
INSERT INTO usa_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","keráwáqá nói-qtataaraq aónaineraq uráánabiyo? aqá móra-nakoma íráqôn-unakaqtoma makáitaraq aónaineraq uráánabiyo? ímiye. yemá íráqôn-unakaqtomo máráa-kayukama yemá anó-kini-kayukati naaúpaq kémaae. ");
INSERT INTO usa_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","miráimanibo nôraq itaráq urááô? móra Áánûqtuni amuné-náráq aónaineraq urááô? owé. kemá keráwáqá kétima-timune. minnâ amuné-nápóana wemá yaímma Áánûqtuni káqon-amune-wayukama uyátáraiye. ");
INSERT INTO usa_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Áánûqtuni watáama agamatá-kánnáábí Áánûqtuma áanikomma maará téna timá ámikaiye. ‘ketááyabamo tínîn-naqa timákáanana ení áqnáabariq umá wíniye. wemá ení aammá awiyéna yokaa umákaniye.’ téna Yóáaneqtaba agamatá-kánáábí tiráine téna kétiye. ");
INSERT INTO usa_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","kemá áraimma kétima-timune. máqtemma maa-márábí-káyúkábíké Yóáane uyátá-maqma mú mikáqá anómma máimanibo Áánûqtuma yabíni-kanaaraqa móra paá-naqa mánin-nakoma wemá Yóáanemma uyátáraiye. ");
INSERT INTO usa_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Yóáanema nommá peraí-nákóní kanaaráké áaimma átárena yéqéna íbêqa Áánûqtuma yabíkáin-aukapaq uyáberanoqtaba anón-aaiqa kéoe. akoqnáá umá iraráá-káyúkámá Áánûqtuma yabíkái-qtataaqa yáqtoqma akoqnáá uréta mayánéta kéoe. ");
INSERT INTO usa_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","máqtemma Áánûqtuni amuné-wáyúkágáráq Mótetini ámáan-aikaraq yemá Áánûqtuma yabíkái-qtataaqtaba watáama mamá pááq umáeta Yóáaneni-kanaaraq irááe. ");
INSERT INTO usa_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","ánibo keráwáqá itánáae téqa kanaaráq ítáaro. Yóáane wemá Iráíyaraa-naqiye. min-náqá anaaékaq yíniye téta amuné kútaa-naqiye. ");
INSERT INTO usa_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","keráwáqá taáqa wáinaqa maamin-áímmá ítáaro! ");
INSERT INTO usa_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","nóinnae téraq íbêq-wayukayabama aamá ténúnô? yemá miráuma pááqya-noiyaporaa umá márûq aúkáapi máeta yemá káqo-noiyapoma yááyama maará téta kéte. ");
INSERT INTO usa_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","ketáámá keráwáqtábátáá káoyamma kéyunataa keráwáqá imá íkeyaae. ketáámá yirummá í-ímá kétunataamanibo keráwáqá ibiqá íma kéyaraae.’ óqa tíkái-qtataaqa íma pááq kéiye. ");
INSERT INTO usa_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Yóáane iráimma wemá aáwaqa íma néna wááéni-nomma íma naráitata yemá weqtábá ‘aíbôq-nare’ téta tirááe. ");
INSERT INTO usa_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","kemá Waayúkagoni Áráaqa iréq aáwaqa néq nommá néq únnayabama yemá maará kéte. ‘aónaaro. wemá aáwaqa ôriq umá netuqyaa naínápóana wemá wááéni-nomma netuqyaa kénaiye. ‘paátataare’ timá yíkáayuma táákiti-moneqa máyáa-kayukagaraq kúmiq-wayukagaraq wemá yeqtí aanábómíye.’ ááqibo anaaékaqa minnáyaba Áánûqtuni itaí-yátáákómá aónainoe.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","yaímma-marupaqa Îtuma awaaméq-yátáárîqa netuqyaapaq immá íma yirummá waékáae. miráitana mi-kánááráqá Îtuma aamá yiwáágéna ");
INSERT INTO usa_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","maará-tiraiye: “Tiyórátiniq-wayukao, náaraq-tai-yataaraq keráwápímmá pááq íníyô! Beqtáirapaq-wayukao, náaraq-tai-yataaraq keráwákáq pááq íníyô! anón-awaameq-yataariqa kemá keráwáqtí márûkaq únnaiq umá Tááyanabakaraq Tááíranapakaraq énama kanaaráq naayóbáqá Tááyanabaq-wayukagaraq Tááíranapaq-wayukagaraq yeqtí kúmiq-yataapike waeráunatae téta tiráá-tiraapoata yemá unáákáréq on-unapi yenamáárîq áítumatuweta káín ayáátóbí máeta yáaqa kaitata yirummá waékáae. ");
INSERT INTO usa_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","miráimanibo kemá keráwáqá kétima-timune. yirummá íwaekaapoata anaaékaqa keráwáqtí anónnáma táí-meyakoma yainaí-kánááráqá miráuma Tááyanabaq-wayukagaraq Tááíranapaq-wayukagaraq uyátá-maqma anómma pááq íniye. ");
INSERT INTO usa_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","ánibo keráwáqá Kápéranabaq-wayukao, keráwáqá Áánûqtuni márûpaqa tiwíqma yaúmeta uwínóe téra kéteo? keráwáqá iramá káíq-kaiq umá kain írábí kumínóe. minnâ kemá keráwáqtí márûpaq anón-awaameq-yataariq únnaiq umá Tótômabaq-marukaqa awaaméq-yátáárîq énama kanaaráq íbêqa Tótômabake táí-wayukama paá máneta oné. ");
INSERT INTO usa_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","miráimanibo kemá keráwáqá kétima-timune. anaaékaqa aarawaamá ítama yainaí-kánááráqá Áánûqtuma wení paru-yátááqá keráwáqá uyátá-maqma Tótômabaq-wayukama yimíniye.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","mi-kánááráqá Îtuma maará-tiraiye: “ketiboó, emá yabíkáana-marupakaraq maa-márágáráq uyátáráana-nakoe. emá aamá íma ítaraa-kayukama aúyánápí wáin-aaimma aamá kéyiraatenamanibo ítaraa-kayukayopakemma mamá káuyoraane. minnáyataba kemá ‘tíkáiye’ kétune. ");
INSERT INTO usa_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","owé. ketiboó, emá ákáiniq kéone. ");
INSERT INTO usa_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","ketibomá Áánûqtuma máqte-qtataaqa ketiyáápitaa makáiye. ánibo móra-nakoma min-íyápómá íaonaraiye. aboámá wenamáa min-íyápómá aónaraiye. ánibo móra-nakoma aboámmá Áánûqtumma íaonaraiye. kemá wení áanikoma kenamáa aónaraune. ááqibo wení áanikoma ákáinama yaímma-wayukama aboání áaimma kéyiraatiye. ");
INSERT INTO usa_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","keráwáqá tíbô kégaitaq ummaa-yátááqá kémayaa-yuma ketôpaq íyaraq kemá keráwáqá aagaí-yátááqá tíméno. ");
INSERT INTO usa_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","kemá kaayoné kéeq ánibo ketúma íma mamé kéuyune. miráinaq keráwáqá keráwáqtí ummaamá ketê yaagumá mayéraq kepíké itaí-yátááqá ítareq agánoe. ");
INSERT INTO usa_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","ketê yaaguyabí-yamma oyaaq kéinaq ummaa-yátááqá keráwápí maráana-waigoma oyaaq íniye.” mirá téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","anaaékaq móra-Tabaatiraqa Îtuma wíti-yokoni aúkáapi uréire uráiye. ánibo wení iyápó-annama yááyaba éta yemá wítigoni arammá putáqma narááe. ");
INSERT INTO usa_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","ánibo Pérati-wayukama minnâ aónatuweta Îtuma timá ámikaae: “aónaao. maamirán-ááímmô tarôq kéeq mayaímá kémayaamma Tabaatiráqá aammá aúmakaae.” ");
INSERT INTO usa_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","téta tewana Îtuma yauwéqma timá yímikaiye: “keráwáqá Tébitima miráurain-aimma íyaq yoráútaao? naayóbáqá Tébitigaraq wení waayúkagaraq yááyaba uráátaba kétune. ");
INSERT INTO usa_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","yemá monoq-náúpáq utéta yammá Áánûqtukaq amí-yááréráq wáimma uyátá-maqma anó-monoq-nakoma yímitata narááne. mi-támmá anó-monoq-wayukama kanaaráq nánópoata paá-wayukama naíyábá aammá aúkaiye. ");
INSERT INTO usa_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","anó-monoq-wayukama yeqtí mayaímá anó-monoq-naupaqa Tabaatiráqá yemá aammá aúmakaama yawítíraamanibo minnâ íma otaa-qtátáárîq urááe. maami aammá aúmatan-aimma wannaabíkémá íyaq ítaraanabiyo? Áánûqtun-aurakaqa Tabaatiráqá aammá aúmatan-aimma íma yawítíraae. ");
INSERT INTO usa_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","kemá keráwáqá kétima-timune. maannámo mái-waigoma anó-monoq-namma uyátáraiye. ");
INSERT INTO usa_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","keráwáqá Áánûqtuni agamátá-kánnáábíkén-áímmá ítareqa táwî-aimma téq otaamá íkuineq oné. maami agamatá-kánnáábíkén-áíkómá maará kétiye. ‘naí-wámmá timíyábá íketikaimanibo kaayoné-yátááqtábá kétikaiye.’ téna Áánûqtuma tiráiye. aammá aúmatan-aimma íyawitiraa-kayukama íma mamá yawááq-umayikaaro. ");
INSERT INTO usa_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Waayúkagoni Áráaqa Tabaatigóní uyátárai-napoana ketí iyápó-annama Tabaatiráqá mamá naráamma kanaaráq íye. ");
INSERT INTO usa_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Îtuma min-áúkápáqá yuwéna yeqtí monoq-náúpáq uráiye. ");
INSERT INTO usa_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","móra-naqa mibáqá máqe-uraimma ayáákoma aayámmá káguraiye. yaímma-wayukama Îtumma aabi mayakánétaboata wemmá ítama aónaraae: “Tabaatiráqá mayaímá kémayeta karí-wáyúkamá mamá atóbama-yikanunataabiyo?” téta ítama aónaraae. ");
INSERT INTO usa_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","ánibo Îtuma yauwéqma timá yímikaiye: “keráwápíké móra-nakoma tipi-típima makáitana mi-típí-típígómá Tabaatiráqá móra-maiqnobaq kumábékitanama kanaaráq min-nákómá íyaq paábaq múte kéyabitimatuwaiyo? owé. ");
INSERT INTO usa_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","ánibo móra-nakoma tipi-típima uyátáraiye. miráipoata ketááí ámáan-aikoma kanaaráré tiráipoataa Tabaatiráqá waayúkama yíwáqnaa ónúnataae.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","miráitana Îtuma min-áyáámmá aayá-kagurai-naqa timá ámikaiye: “ayáámma mamá arutaao.” téna titana min-nákómá ayááma mamá arupú itana ayáákoma keqnáámmá mamá íráqôniq umá móra-aukapaq-ayaakaa uráiye. ");
INSERT INTO usa_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","miráimanibo Pérati-wayukama Tabaatiráq Îtuma karí-náqá mamá atóbamakaitaba aónawaaeta Tabaatiráqá mayaíyá kémayaiyaa téta yemá móra-aukapaq áíkuteta Îtumma ikamí-áímmá téite urááe. ");
INSERT INTO usa_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","miráimanibo Îtuma min-áímmó temá ítátuwenaboana Îtuma mi-márúqá yuwéna kóuraiye. miráitata netuqyaa-káyúkámá Îtun anaaé kéwaraawana máqtemma karí-wáyúkámá mamá atóbamayikaraiye. ");
INSERT INTO usa_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","akoqnáá umá Îtuma timá yímikaiye: “keqtábá íma mamá abarokáq umátíkáaro.” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","miráitana Áánûqtuma móra-amune-naqa Áítáíyani óyaukaq naayóbáqá tiráimma íbêqa abarokáq kéiye. miráitana tiráin-aikoma maará-tiraiye: ");
INSERT INTO usa_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“maannáma ketí mayaí-náqíye. kemá wemmá awaaméqá umákaraune. weqtábá kétikaitaq timuqá kémaraane. kemá ketí Aágomma wekáq máráanana wemá ketí yainaí-áímmá Yéqtaaeo-wayukama timá-yiminiye. ");
INSERT INTO usa_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","wemá aamá íyiwaagena anókaq aamá ítiniye. wemá aapaq uréire kéena anókaq aamá ítiniye. ");
INSERT INTO usa_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","móra-nakoma áyaqnobaqa ummaa kéyainanama yawenáina-waigoma okáráákáá umá íma akáginiye. ánibo móra-nakomma ummaa-yátááqá wáina-waigoma pááqyamma ókómá putinánéna iníkáá umá íma márúte yuwánóe. wemá paá watáama kétinana yainaí-yátáákómá arupú umá pááq íniye. ");
INSERT INTO usa_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Yéqtaaeo-wayukama wekáq yirummá améta awé ínóe.” téna agamatá-kánnáágómá kétiye. ");
INSERT INTO usa_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","mi-kánááráqá yemá móra-naqa awíqmeta Îtukaq iráama min-nákómá táí-aagoma wepí máipoana aúramma karopágitana óyaukogaraqa aúyakuraiye. ánibo min-náqá Îtuma mamá atóbamakaitana aamá tiréna aúramma aónarena uráiye. ");
INSERT INTO usa_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","minnáyaba netuqyaa-káyúkámá aónama iyánáaq éta tirááe: “maannáma Tébitimma áanikowabi Metáíya íyabiyo?” téta ");
INSERT INTO usa_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","tewata Pérati-wayukama min-áímmá ítátuweta tirááe: “táí-aagoni uyátárai-naqa Píétebuma Îtumma akoqnááma ámikaipoana táí-aagomma kématuwaiye.” ");
INSERT INTO usa_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","téta kétewana Îtuma yeqtí yúyánámmá iténa tiráiye: “móra-marukaq-wayukama yatákaaq umá kaayaq-ánnáíq uréta ááiqa íyana mi-márúkómá táíq umáginiye. ánibo móra-marukaq-annawabi móra-naupaq-annama keqnáámmá yáíkaaq umá kaayaq-ánnáíq umá ááiqa íyana naammá yawítíginikaa umáginoe. ");
INSERT INTO usa_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","móraiq umá Tááqtaama yabíkái-qtataaqa yáíkaaq uréta ááiqa íyanama páátákáá wemá yabi-í-yátáákómá naammá yawítiginikaa umáginoe. ");
INSERT INTO usa_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","ánibo keráwáqá maará kétee Píétebuma tíwâqnaa itaq táí-aagomma kématuwaupo timá tíméro. náawaq keráwáqtí tinaaé wáráa-kayukama yíwáqnaa itatawáq táí-aagomma kématuwaao? miráinata tinaaé wáráa-kayukama keqtáámá kétiraatemma keráwáqtí táama áraimma íma wáiye. ");
INSERT INTO usa_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","ítáaro. Áánûqtuni Aágoma tíwáqnaa kéitapoaq kemá táí-aagomma kématuwaune. miráitana keráwáqá kétiraatimma Áánûqtuma yabíkái-qtataaqa áqa keráwákáq pááq umá wáiye. ");
INSERT INTO usa_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","náaraq umáwaq móra-nakoma newáqyáá-nakoni naaúpaqa uyábékena wení máqte-qtataaqa mayáníyô? wemmá mi-néwáqyáá-náqá ánnáma kúyakatuwenama wemá kanaaráq newáqyáá-nakoma Tááqtaani naaúpakema máqte-qtataaqa mayániye. ");
INSERT INTO usa_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","móra-naqa ketí aanábóráá umá íma mái-nakoma wemá minnâ ketí namuro-náqíye. móra-nakoma náawabi íma tíwáqnaa éna waayúkama aíqma yorupénama wemá waqmá paábataa kéumatuwaiye. ");
INSERT INTO usa_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","miráitaq kemá keráwáqá kétima-timune. waayúkama máqten-akayaama tiréta kúmiq-yataariq uréta kéo-qtataaqa Áánûqtuma máqtepaq mamá paá umáyikena awikátuwaniye. miráimanibo móra náawabi Áánûqtuni Aokaq-Áágómmá táí-aimma timákainanama mirá-kúmíq-yátááqá Áánûqtuma íma mamá awikátuwaniye. ");
INSERT INTO usa_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Waayúkagoni Áráaqa móra-nakoma timá táíq umákainanama wení kúmiq-yataaqa Áánûqtuma mamá paá umákena awikátuwaniye. miráimanibo móra-nakoma Áánûqtuni Aokaq-Áágóqtábá ‘Píetibuni aánapo kématuwaiye’ timákaiyanama mirá-kúmíq-yátááqá Áánûqtuma íma mamá paá umákena awikátuwaniye. íbêq-kanaarakaraq anaaéka-kanaarakaraqa wemá íma mirá-iniye. ");
INSERT INTO usa_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","yaagómá íráqô-tama wáinanama arakógáráqá íráqôn-aramma iyániye. ánibo táí-yama wáinanama arakógáráq táí-aramma iyániye. keráwáqá aónamma nói-qtataakowabi mamá pááq kéimma káonaae nói-qtataakoni áainabi minnâ abarokáq kéiye. ");
INSERT INTO usa_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","keráwáqá iraakabayaakóní áráakawaro, keráwáqá táí-wayukama máamanibo náaraq umáwaq íráqôn-aimma tínô? aamá kéqokeq-aimma tin-nákómá wení óyaupima mimórá-áúyánámmá arunóbákáráq ógikaiye. ");
INSERT INTO usa_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","móra íráqô-nakoma wemá netuqyaa íráqôn-auyanamma arunóbáqá wáiye. miráitana wemá íráqôn-aaimma mamá pááq kéiye. ánibo táí-nakoma wení táí-auyanamma netuqyaa wáiye. miráitana wemá táí-aaimma mamá pááq kéiye. ");
INSERT INTO usa_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","miráimanibo kemá keráwáqá kétima-timune. minnâ máqte-maqten-aimma aarawaamá kétemma anaaékaqa ítama yainaí-kánááráqá Áánûqtuma ítama aónéna yainániye. ");
INSERT INTO usa_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","keráwáqtí táarake Áánûqtuma keráwáqá ítama yainéna taáqa íma wáiyuwe otaammá kutáayuwe téna ítama yainániye. ");
INSERT INTO usa_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","mi-kánááráqá yaímma ámáan-aimma yirááti-wayukagaraq yaímma Pérati-wayukagaraq Îtumma timá ámikaae: “yirááti-nako, emá móra anón-awaameq-yataariq inataa aónatuwetaa ketáámá ekáq tirutáá áméno.” téta tirááe. ");
INSERT INTO usa_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","miráitana Îtuma yauwéqma timá yímikaiye: “táí-ini-naukaqa Áánûqtuqtaba íma ítaraan-ini-naukaqa anón-awaameq-yataaqtaba ítama káonaae. miráimanibo kemá móra anón-awaameq-yataaqa íyiraatenune. Áánûqtuni amuné-náqá Yónaani anón-awaameq-yataaqa wenamáa yiráátenune.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","naayóbáqá Yónaama anó-noyaakoni áyáqnobaqa kaumo-wágáágáráq kaumo-nókáámmá máqe-uraiye. miráumaraa Waayúkagoni Áráakoma maranóbáq kaumo-nókáákáráq kaumo-wágáágáráq mániye.” téna Îtuma wemá puyéna maranóbáq mániqtaba tiráiye. ");
INSERT INTO usa_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","ókaraq Îtuma tiráiye: “anaaékaqa Áánûqtuma aarawaamá yainániye. mi-kánááráqá Níníbeq-wayukama ítama yainaí-yátáápí itó-ureta keráwáqtí táí-taaiqtaba táí-tubi maránóe. minnâ Níníbeq-wayukama Yónaama tin-áímmá itéta yemá kúmiq-yataapike waékáae. maakáq mórama mái-waigoma wemá Yónaamma uyátáraunaqanibo keráwáqá tirummá íma kéwaeraae. ");
INSERT INTO usa_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Áánûqtuma waayúkama ítama yainání-kanaaraqa anómma yabíkáin-inikoma kúínima aabaú kupérái-waigoni kaapaq-áúkápáké anómma yabíkáin-inikoma iréna ítama yainaí-yátáápí itó-urena keráwáqá táí-tubi marániye. mi-kúínímá maa-márágóní aqtóráq naayóbáqá máqe-urena Tórómónima wení itaí-yátáákóní áaimma titana kúínima itánáae téna minnáyaba iráine. miráimanibo maannámo máin-nakoma minnâ wemá Tórómónimma uyátáraiye.” téna wetábá wenamáárîq Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Îtuma maará téna tiráiye: “móra-nakoma táí-aagoma ayúwáitanama wemá kokoq-márábáq uréire kéena móra-aukapaq aagánî-maruqtaba abáá kéiye. aagánî-maruqa íaonenama ");
INSERT INTO usa_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","min-áágómá wenaúyánápímmá kétiye. ‘kemá yauwéqma naayóbáqô kémauna-naupaq ko mánune.’ téna kétiye. mirá-timatuwena ko aónaimma min-námmá paá-namma wáitata kuyútuketa íráqôniq umá arútama wáitatamanibo kuyúqma agaro umákaae. ");
INSERT INTO usa_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","miráitana wemá káqomma abapaké kaayaqá táí-aagomma ko yiwíkaima táí-aaimma uyátá-maqma ókaraq tarôq ínéna itata yemá mi-táí-áágómá min-nákótê iréta yemá min-náúpáqá uyábéqma mááe. naayóbáqá min-nákómá uyátá-maqma anómma táíq umá máqe uráiniq umá íbêqa máiye. maa-kánááráqá máa-kayukabima móraiq umá miráuma táí-aaimma pááq íniye.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Îtuma aarawaamá watáa kétima-yimitana anóagaraq ábâqawaayuma iréta máápaq ya itó-uma máqe-uraae. yemá Îtute watáá-wataa tínéta urááe. ");
INSERT INTO usa_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","ánibo móra-nakoma Îtumma timá ámikaiye: “itaao. enanógaraq enábâqawaayuma máápaq ya awé uréta etê watáá-wataa tínéta kéoe.” téna Îtumma timá ámikaiye. ");
INSERT INTO usa_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","miráitana Îtuma yauwéqma min-náqá timá ámikaiye: “ketinógaraq ketíbâqawaagaraq yeqtábá kéteno?” timátuwena ");
INSERT INTO usa_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Îtuma wení iyápó-annama ayáánapo awaaméqá umátuwena tiráiye: “aónaaro. maannáma ketinógaraq ketíbâqawaayue. ");
INSERT INTO usa_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","náayuwabi ketibomá Áánûqtuma wení márûpaq mái-nakoni aúyánámmá waráiyayuma minnâ yemá ketíbâqawaama maéta ketúmma maéta ketinóma mááe.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","mi-kánááráqá Îtuma min-námmá yuwéna máápaq yaúbaraimma wemá nokaayúkóní áwabaq máena yiráátiraiye. ");
INSERT INTO usa_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","ánibo netuqyaa-káyúkámá amakaq ya áíkutaae. miráitana Îtuma móra-unopi-kaarebi uyáqtama máitata aarawaamá únón áwabaq itó-uma máqe-uraae. ");
INSERT INTO usa_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","ánibo Îtuma netuq-ááimmá téna waéqma itaí-áímmá téna waéqma itaí-áípí maqmá timá yímikaimma wemá maará-tiraiye: “ítáaro. móra-nakoma ánáyumma yópí móyukaiye. ");
INSERT INTO usa_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","min-nákómá ánáyumma mó yúwáitana yaímma aapi kuturáiye. miráitana numagómá ya áíqnatukaiye. ");
INSERT INTO usa_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","yaímma-anayukoma óqtamma wáin-aukapaq kuturáimma netuq-márámá íma wáqe-uraiye. maragómá íma anómma ummaatamá wáitanaboana námama páátákáá utamá anómma aúkáiye. ");
INSERT INTO usa_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","ánibo aaqá kégaitana aúgen-anuqa aayámmá kamágéna íma wáqe-uraiye. ");
INSERT INTO usa_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","yaímma áwáábiq-annagoni ááipi kuturáiye. ááqibo áwáábiq-annagoma mamá yawááq-umatukaiye. ");
INSERT INTO usa_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","yaímma-anayumma íráqô-marabi kuturéna arammá itáiye. yaímma-anayumma tiyááka naikamá-tiyaakama miráuma (100) arammá íyáitana yaímma-aramma abapaké móra-tiyaaka-aramma (60) íyáitana yaímma-aramma kaumo-tíyááká-árámmá (30) íyáitana urááe. ");
INSERT INTO usa_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","móra-nakoma aáqa wáinanama itaíno. ");
INSERT INTO usa_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","wení iyápó-annama Îtunopaq iréta timá ámikaae: “nôraq itaawáq waéqma itaí-áípímmá aamá kétima-yimeno?” téta Îtumma ítama aónaraae. ");
INSERT INTO usa_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Îtuma yauwéqma timá yímikaiye: “Áánûqtuma yabíkái-qtataakoni aúpáq-áíkón áaimma Áánûqtuma keráwáqá tirááti-matukaiye. miráimanibo maa-káyúkámá ímiye.” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","minnâ mórama Áánûqtunopake watáama matáina-waigoma min-ámúrááq móragaraq mayániye. miráinana wemá netuqyaa-qtátááqá kanaaráq marániye. ánibo móra-nakoma Áánûqtunopake pááqya-qtataaqa makáinanama minnámo matoraína-yataaqa paá aúyokiniye. ");
INSERT INTO usa_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","waéqma itaí-áímmá maamináyaba kemá kétune. maa-káyúkátí yúrakoma káonamanibo íkáonaae. ánibo yaákoma aamá kéitaimanibo íma ítama arutéta yúyánámmá kéitaae. ");
INSERT INTO usa_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","maami-nóínínáúkáqtábá naayóbáqá Áánûqtun-aama amuné-náqá Áítáíyama áraimma pááq íniye téna maará-tiraine. ‘keráwáqá aamá itánómanibo áaimma íma itánoe. keráwáqá túramma aónainomanibo móra-yataaqa íaonainoe. ");
INSERT INTO usa_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","maami-káyúkátí íyakoma akoqnáá umáguraitataboata yaákoma aamá itaíyábá yíbôgaitata yemá yúramma karoparááe. miráitana yúrakoma móra-yataaqa íma káonaitana yaákoma móra-yataaqtaba íma kéitaitataboata yúyánámmá íma kéitaae. yemá ketôpaqa íma ko yáútúmeta mamá íráqôniq umá tikaao téta íkéye.’ téna agamatán-áúbábí Áítáíyama tiráine. ");
INSERT INTO usa_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Îtuma ókaraq tiráiye: “miráimanibo keráwáqá íráqôniq umá mááe. keráwáqtí túrakoma móra-yataaqa káonaiye. ánibo keráwáqtí taákoma ketáama kéitaiye. ");
INSERT INTO usa_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","kemá Îtuma keráwáqá áraimma kétima-timune. naayóbáqá netuqyaammá Áánûqtuni amuné-wáyúkágáráq netuqyaammá wení arupú-wayukagaraq íbêqa keráwáqa aónaan-awaameq-yataaqa aónaiyaba ôriq umá yíkáraimanibo yemá íma aónaraane. ánibo yemá íbêqo ítáan-aimma itaíyábá ôriq umá yíkaraimanibo íma ítaraane. ");
INSERT INTO usa_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","móra-nakoma yópí ánáyumma yuqmé yáútúrai-waigoni aúpáq-áímmá ítáaro. ");
INSERT INTO usa_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","máqte-kayukama Áánûqtuma yabíkái-qtataakoni watáama kéitetamanibo minnáyaba yúyánámmá íma ítáama yemá ánáyukaa aapi kuturáitana numagómá ááqmena kóuraiye. móraiq umá Áánûqtuma wení watáama íyáqnobaq uqmáráimma Tááqtaama iréna páátákáá paábaq kématuwaiye. ");
INSERT INTO usa_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","yaímma-anayumma óqta-marabi kuturáimma yemá miráuma páátákáá aamá mayéta yimuqá makáane. ");
INSERT INTO usa_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","miráimanibo ánûqa íma wáitanaboana pááqya-kanaama kémaiye. anaaékaqa Áánûqtun-aayaba makatí-kánáámá kéyitata yemá páátákáá aamá kéyuwaae. ");
INSERT INTO usa_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","ánibo yaímma-anayumma áwáábiq-annagaraapimo kukáimma miráuma waayúkama aamá kéitamanibo maa-márábín-aúwáráíqtábá móneqa mayaíyábá yeqtí yúyánápímmá anómma aúráitata Áánûqtun áama mamá kéyawaaq-umatuweta yemá arammá íyáinikaa íkéoe. ");
INSERT INTO usa_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","ááqibo yaímma-anayumma íráqô-marabimo kukáimma miráuma waayúkama Áánûqtun áama itéta waqmá yúyánámmá kéitaae. yirunóbáqá arammá miráuma mákatiyaaka-tiyaakama (100) íyáawata yaímma miráuma abapaké móra-tiyaakama (60) íyáawata yaímma kaumo-tíyáákámá (30) arammá kéyaae.” téna Îtuma timá yímikaiye. ");
INSERT INTO usa_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Îtuma káqomma waéqma itaí-áímmá timá-yimena tiráiye: “Áánûqtuma yabíkái-qtataakoma miráuma móra-nakoma íráqôn-anayumma wení yópí yúwáinikaa uráiye. ");
INSERT INTO usa_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","miráimanibo aarawaamá yúmô kéwagowanama min-nákóní namuro-nákómá nokáámma iréna karaa-qtatáákóní ayummá wítigoni aúkáapimma má-yuqmarena kóuraiye. ");
INSERT INTO usa_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","anaaékaqa mi wítigoma utaréna arammá iyánáae téna aónaimma karaa-qtatáákáráq mipí wáqe-uraiye. ");
INSERT INTO usa_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","ánibo mayaí-wáyúkámá yókóní aanábóráq uréta yemá timá ámikaae. ‘anó-nako, emá ení yópímá íráqôn-anayumma yukááne. ánibo nôraq itanawáq námagaraamma karútaiyo?’ téta tewana ");
INSERT INTO usa_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","ánibo wemá timá yímikaiye. ‘móra-namuro-wayukama mirá-uraae.’ téna titata mayaí-wáyúkámá timá ámikaae. ‘ketáámá námagaraamma ko yubónúnataabiyo?’ téta ítama aónaraae. ");
INSERT INTO usa_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","miráitana yón-áánábó-nákómá yauwéqma timá yímikaiye. ‘ímiye. námama yubíyapaq wítigaraq yayútuwaabo. ");
INSERT INTO usa_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","keráwáqá paá yuwaíyata mákama wáeta naí-kánááráq úyotao. ánibo naí-kánááráq uínaqa mi-máyáíráq-wáyúkámá maará téq timá-yimenune. ‘keráwáqá námagaraanokaa yúqma atáá-uma irabí agayaíq umáráaro. miráimanibo wítigomma paá mamá ketí aáwaq-naupataa umátíkáaro.’ téna tiráiye.” téna Îtuma waéqma itaí-áípí timá yímikaiye. ");
INSERT INTO usa_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Áánûqtuma yabíkái-qtataakoma márû mikáq pááqyan-anayukaa (máqtaqti) uráiye. ");
INSERT INTO usa_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","miráitata waayúkama min-ánáyúmmá mamá yeqtí yópí uqmakáawana utamá máqtemma uqmakáa-qtataakoma uyátá-maqma anómma auréna yaagóráá uráiye. Áánûqtuma yabíkái-qtataakoma anómma auréna íniye. miráitana mi-tágóní amataqá numaráwákómá ánáamma má-uraiye. ");
INSERT INTO usa_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","keqnáámmá Îtuma káqomma waéqma itaí-áímmá timá-yimena tiráiye: “Áánûqtuma yabíkái-qtataakoma miráuma yíqtiraa uráiye. móra-inikoma maami yíqtima maténa anó-taapepi makéna yakaráq yíqtigaraq waékáiye. ánibo anaaékaqa yakómá itóqma anómma aúkáiye.” téna Îtuma tiráiye. mórama yakaráq waéqma agayaíyana itoraí-kánámá yíqtiboana Áánûqtuma yabíkái-qtataakoma miráráá kéiye. ");
INSERT INTO usa_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Îtuma máqten-aimma aarawaamá timá yímikaimma waéqma itaí-áípín áátuqma timá yímikaiye. móra-aimma abarokáq ítima-yimikaiye. ímiye. wemá paá waéqma itaí-áípín áátuqma tiráiye. ");
INSERT INTO usa_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","miráitana móra Áánûqtuni amuné-nákómá nóinabi naayóbáqá tiráimma íbêqa áraimma pááq kéiye. naayóbáqá maará-tiraine: “kemá tóyauqa ógaakeq aamá waéqma itaí-áímmá tenúne. maa-márámá paá kéitana aúpáq aúyoqma wáqe-urai-qtataaqtaba kemá timá-yimenune.” téna Áítáíya naayóbáqa tiráine. ");
INSERT INTO usa_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Îtuma aarawaamá mikáq iyuwéna naaúpaq uráiye. wení iyápó-annama Îtunopaq iréta tirááe: “táí-namama yópímô karútai-waigoni waéqma itaí-áímmá keqtáá áaimma timá tímînaqtaa ítáano.” téta tirááe. ");
INSERT INTO usa_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Îtuma maará téna tiráiye: “maamin-nákómá íráqôn-anayumma yúwáimma minnâ kemá Waayúkagoni Áráaqiye. ");
INSERT INTO usa_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","ánibo yómmá minnâ máqte-marure. íráqôn-anayumma minnâ miráuma Áánûqtumo yabíq yíkarai-kayukae. ánibo táí-namagaraamma minnâ miráuma Tááqtaani waayúkae. ");
INSERT INTO usa_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","mi-námúró-nákómá táí-namagaraamma yúwáimma minnâ Tááqtaae. aáwaqa yópíké ábu kaínata mayánô-kanaama minnâ anaaékaqa maa-márámá ánatani-kanaaraqa ketí kaqtó-wayukama Áánûqtunopake mirá-inoe. ");
INSERT INTO usa_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","ánibo yemá táí-namagaraamma yúqma áíkumareta máqtepaq irabí agatuwánómma minnâ miráráá umá anaaékaqa maa-márámô ánataniq-taoqa mirá-inoe. ");
INSERT INTO usa_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Waayúkagoni Áráakoma ketí kaqtó-wayukama timáyikaanata kemá yabíkáuna-yataapike náayubi káqo-yuma kúmiq-yataapi mamá kéyikaa-kayukagaraq ókaraq táí-aaimma tarôq kéo-kayukagaraq yiwíqma áíkuinoe. ");
INSERT INTO usa_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","ánibo Waayúkagoni Áráakoni kaqtó-wayukama Áánûqtunopake mi-káyúkámá mamá anón-irabi yuwánóe. min-írábí yemá máeta anón-ibiqa yaréta yíwayaamma akégûnanoe. ");
INSERT INTO usa_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","mi-kánááráqá Áánûqtuni arupú-wayukama yeqtibomá Áánûqtuma yabíkáin-aukapaqa tágama aakáá kánóe. móra-nakoma aáqa wáinanama maamin-áímmá ítama arutaíno.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Áánûqtuma yabíkái-qtataakoma miráuma anó-moneqa yawáánakaraq móra-yopi aúpáq makáánikaa kéiye. ánibo móra-nakoma mi-mónéq-yáwáámmá abatátuwena wemá yauwéqma yawááq-umarena amuqá ôriq umá kémarena wemá máqtemma makái-qtataaqa mamá káqo-kayukaraq maráitata yemá meyánîq urááe. miráitana wemá yauwéqma uréna mi-tópí móneqa wáitanaboana ko meyánîq uráiye. ");
INSERT INTO usa_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","móragaraq Áánûqtuma yabíkái-qtataakoma miráuma íráqô-puyaqa móra-nakoma anó-moneq-awiqa yéna áíqma áíkuinikaa kéiye. ");
INSERT INTO usa_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","wemá aónaimma móra íráqô-puyaqa wáitana abatátuwena wení máqte-qtataaqa yaímma-wayukabaq mó kéyimena meyánîq uráiye. ánibo wemá minnârake móneqa maména mi-púyáqá ko meyánîq uráiye. móraiq umá Áánûqtuma yabíkái-qtataakoma máqtemma íráqô-qtataaqtaba ákái-qtataakomma uyátáraiye. ");
INSERT INTO usa_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","móragarare. Áánûqtuma yabíkái-qtataakoma miráuma nokaayúpí kúqômma yukéta noyááqa yáqtóráánikaa kéiye. ");
INSERT INTO usa_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","noyáákoma kúqômma ógikitata yemá áwábaq mi-kúqómmá yabiti máeta kéye. ánibo yemá áwábaq má-maketa íráqô-noyaaqa áíqma ókaq kémareta táíq i-nóyááqá áíqma paábataa kéyuwaae. ");
INSERT INTO usa_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","anaaékaqa maa-márágóní aqtó-kánááráqá miráráá umá móraiq ínóe. Áánûqtunopake kaqtó-wayukama kukéta íráqô-kayukabimo táí-wayukamo maíyamma kunáíqma ");
INSERT INTO usa_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","anón-irabitaa yuwánóe. min-írábímmá mi-káyúkámá máeta anón-ibiqa yaréta yíwáyaamma akégûnanoe.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Îtuma maará téna ítama yimónaraiye: “keráwáqá maami-máqtén-áíkóní áaimma kéitaao?” téna titata yemá tirááe: “owé.” tewana Îtuma timá yímikaiye: ");
INSERT INTO usa_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","“miráitata máqtemma ámáan-aimma yirááti-wayukama Áánûqtuma yabíkái-qtataaqtabama ítaraapoata yemá miráuma kaayaqá naakóní anábóráá umá máitata wepíké aúgemma itaí-áíkáráq naayón-ítáí-áíkáráq matukááe.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Îtuma waéqma itaí-áímmá timá ánatatuwena mi-márúqá yuwéna wení ");
INSERT INTO usa_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","márûpaq kóurena Áánûqtun-aama yeqtí yirááti-naupaq áíkuyikarena Îtuma timá yímikaiye. miráitata mi-káyúkámá karámareta tirááe: “maan-nákómá awaaméq-yátáárábi itaí-yátááqá náakakenaq matáíyô? ");
INSERT INTO usa_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","maamin-náqá íyaq naammá-í-nákóní áanikowabiyo? Máríaama anóa íyaq máiyo? ánibo Yêmitima Yótêbima Tááímonima Yúqtaatima máqtemma yemá wení ábâqawaayue. ");
INSERT INTO usa_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","máqtemma anaanoámá áúkoma ketáátê mááe. ánibo maamirái-qtataaqa náakakenaq matáíyô?” ");
INSERT INTO usa_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","yemá mirá-timatuweta Îtumma ítama táíq umákaraae. miráimanibo wemá timá yímikaiye. “Áánûqtuni amuné-nákóní áwîqa máqte-marupaqa wáimanibo wení naa márûpakaraq wenánnábíkáráqá wení áwîqa anómma íma wáiye.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","mirá-timatuwena wenáama íma ítáawanaboana mi-márúkáqá taíbaq anón-awaameq-yataariqa íuraiye. ");
INSERT INTO usa_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","mi-kánááráqá anó-kinima Érôtima Îtuni watáama ítaraiye. ");
INSERT INTO usa_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","miráitana Érôtima wení kámááni-wayukama maará téna timá yíkaraiye: “min-náqá nommá peraí-náqá Yóáanemiye. wemá pukáipike yauwéqma itó-uraiye. miráitana anómma akoqnááma wenayáápike pááq kéiye.” téna Érôtima tiráiye. ");
INSERT INTO usa_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","miráitana Érôtima titata wení ááiq-i-wayukama Yóáanemma yáqtoqma téni-annanapo atáá-umatuweta ánná-naupaq ákáraae. Erótiatima Píripimma ánáakokake miráuraimma Píripima Érôtimma ábâkoboana Érôtima awekémá kuyéna ánáakomma yabitiráine. ");
INSERT INTO usa_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","naayóbáqá Yóáanema Érôtimma maará téna timá ámikaine: “min-ínímô mayáánama íarutaiye.” ");
INSERT INTO usa_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","téna titana Érôtima áyáqtaba umátuwena Yóáanemma ikamínéna uráimanibo aarawaatí yáaqa ikátaiye. aarawaamá Yóáaneqtaba ‘Áánûqtuni amuné-náqíye’ tewanabóana ikatîq uráiye. ");
INSERT INTO usa_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","móra-taoqa Érôtimma marákáraa-kanaama pááq itata waayúkama áíkutaae. miráitana mi-káyúkátí yúrakaq Erótiatima ayáámukoma imá yaráiye. ánibo min-ímô yaiqtábá Érôtima ôriq umá amuqá maréna ");
INSERT INTO usa_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","min-ínáárúgómmá maará téna Érôtima áraimma Áánûqtun aúrakaq timá akoqnáá umákaraiye: “emá keqtábá móra-yataaqa ‘timiyo’ tinna-yátááqá paá aménúne.” téna Érôtima tiráiye. ");
INSERT INTO usa_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","min-ínáárúgómmá anóama mirá té tiyó téna anóama timá-amitana maará-tiraiye: “emá Yóáanema nommá peraí-nákómmá ko ikámma aqnómmá aráqma móra-taapepi maré maakáq má timiyo.” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Erótiati mirá titana mi-kínímá Érôtini áyakoma ummaa yáguraiye. miráimanibo wení akoqnáá-aimma máqte-kayukama áíkuma máeta ítaraawanaboana Érôtima tiráiye: “mi-qtátááqá áméro.” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","timátuwena wení ááiq-i-wayukama timáyíkáitata ánná-naupaqa uréta nommá peraí-náqá Yóáanemma ko ikámma ánûaramma aráqma ");
INSERT INTO usa_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","aqnómmá mamá móra-taapepi matuwéta mamé iréta min-ínáárúmá má ámikaae. miráitana min-áqnómmá anóama máipaq mamé itana anóama téna áraimma Yóáanema ‘pukiye’ tiráiye. ");
INSERT INTO usa_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","ánibo Yóáaneni iyápo-annama iréta Yóáaneni arááq-auma mamá uqtarááe. uqtamákátuwetama Îtumma mó-tima-amikaae. ");
INSERT INTO usa_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Îtuma min-áímmá ítátuwena mi-márúqá yuwéna móra-unopi-kaarebi waayúkama íma máa-kaqmaa-karaanobaq wenamáa kóuraiye. miráimanibo aarawaamá min-áímmá ítátuweta yeqtí márûqa yuwéta marabí Îtun anaaé waqméta urááe. ");
INSERT INTO usa_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","anaaékaqa Îtuma áwábaq ko máena netuqyaa-káyúkámá yimónaimma arummá ôriq umágitana kaayoné umá yíkátuwena karí-wáyúkámá mamá atóbamayikaraiye. ");
INSERT INTO usa_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","énaikaqa Îtuni iyápó-annama marabí iréta tirááe: “aaqá kéekiye. maan-áúkápáqá waayúkama íma máán-aukapaqibo timá yíkénata kóoro. yemá máqte-marupaq uréire kéeta aáwaqa abáá-uma máyáaro.” téta tirááe. ");
INSERT INTO usa_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","mirá tewana Îtuma timá yímikaiye: “nôraq ínatawaq kóino? kenamáárîq keráwáqá aáwaqa yíméro.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","ánibo wení iyápó-annama timá ámikaae: “ketáámá netuq-ááwáqá íma matokáunataae. paá móra-tiyaapaq-yakaraq kaayaqá kátútai-noyaaqa matokáunataae.” téta tirááe. ");
INSERT INTO usa_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","ánibo Îtuma tiráiye: “kínna mamé ketôpaq yero.” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","ánibo máqte-kayukama aápêkaq ‘maraq máero’ timátuwena móra-tiyaapaq-yamma kémayena kaayaq-nóyááqá kémayena uréna Áánûqtunopaq múte káonena Áánûqtukaq ‘tíkáiye’ tiráiye. mirá-timatuwena yammá mapákena iyápó-annama yímikaiye. miráitata iyápó-annama matéta aarawaamá yímíqme urááe. ");
INSERT INTO usa_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","ánibo máqtemma min-ááwáqá naawana yímûqa yaráiye. yaímma aqtó-átó-ááwâqá áíqma tiyááka umá kaayaq-kámáágúq-únámmá áíturaae. ");
INSERT INTO usa_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","waayúkama aáwaqo naráamma miráuma netuq-wáyúkámá (5,000) narááe. aara iyápógaraqa íma yoráutaae. ");
INSERT INTO usa_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","íbêqa Îtuma wení iyápó-annama maará téna timá yímikaiye: “áqnáabaq únópí-káárébí utéra nokaayúpí atátuweraq meran-ábápáq kéwiyaraq kemá waayúkama timá yíkáanata ‘koíyaro.’” téna Îtuma timá yímikaiye. ");
INSERT INTO usa_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","ánibo Îtuma aarawaamá timá yíkáitata kówana wenamáa anubaq nunamummá tínéna utáiye. énaikaqa wenamáa anubaqá máqe-uraiye. ");
INSERT INTO usa_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","wení iyápó-annamo kóon-unopi-kaaregoma nokaayúkóní aúkáapi kóitana uwááma anómma yokéna nokómá kárááto kéena únópí-káárémá awéqtaraiye. ");
INSERT INTO usa_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","aaqá iraránéna aabayaamá máráimma Îtuma nokaayúkóní ámûraaqa maréna wení iyápó-annayopaq iráiye. ");
INSERT INTO usa_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","nonánánaakaq Îtuma maré kéyitata iyápó-annama aónatuweta ikatîq ôriq urááe. miráitata yemá tirááe: “waátáma kéiye.” kéteta yemá ikatîqa ôriq umá kéeta wááqa yurááe. ");
INSERT INTO usa_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","ánibo Îtuma paátákáá yááyama tiraíye: “keráwáqtí tíyakoma kaayoné kéinaq máero. kemá Îtuma kéyune. keráwáqá-ikatîqa íoro.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Pítaama maará téna yauwéqma tiráiye: “uyátáráana-nako, emô kéyema emá kemmá tááyenaq enôpaq nonánánaakaq ono.” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","ánibo Îtuma tiráiye: “maabáq iyo.” titana mikáké Pítaama únópí-káárémá yuwéna nonánánaakaq Îtunopaq uráiye. ");
INSERT INTO usa_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","miráimanibo Pítaama anón-uwaama yóráiqtaba áaqa ikaténa nonnóbáq kumá yubékine uráiye. miráitana Pítaama wááqa kéyena tiráiye: “uyátáráana-nako, tíwáqnaa uwo!” téna Pítaama tiráiye. ");
INSERT INTO usa_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Îtuma páátákáá Pítaamma káyaatoq-mayena tiráiye: “epímmá itáíq-itaiq i-yátááqá pááqyamma wáiye. nôraq itaawáq kaayaq-áúyánámmá kéitaano?” téna Îtuma Pítaamma ítama aónaraiye. ");
INSERT INTO usa_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","mirá-timatuwaitata yenákámá únópí-káárébí uyámetaayana uwáágoma mikáq yukáiye. ");
INSERT INTO usa_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","ánibo únópí-káárébímô máe-kayukama Îtuni anón-akoqnaama aónatuweta tirááe: “áraine. emá Áánûqtun-aanikoma máane.” téta tirááe. ");
INSERT INTO usa_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","yemá nokaayúmmá aqtátuweta Kénnétáaretiq-marabaq urááe. ");
INSERT INTO usa_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","min-áúkápáq-wáyúkámá maannâ Îtue téta ítaraae. ánibo mi-márúkóní waaqókáq máqte-kayukabaq aamá yúwáawana wéyáwé itata karí-wáyúkámá yiwíqmeta Îtunopataa irááe. ");
INSERT INTO usa_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","yemá Îtumma inaa téta iyuwáinata karí-wáyúkámá Îtuni paá wáqtôraq ánékuiyana ánibo máqtemma karí-wáyúkámá Îtuni wáqtôraqo ánékuyo-kayukati karígómá ánatagitata máqtemma kanaaráq atóbéqé urááe. ");
INSERT INTO usa_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","mi-kánááráqá yaímma Pérati-wayukagaraqa aammá aúmatan-aimma yirááti-wayukagaraq yemá Yérútááre-maruqa yuwéta Îtunopaq iréta maará-tiraae: ");
INSERT INTO usa_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“nôraq itatawáq ení iyápó-annama ketááí tináábútááma tímikaan-aaimma íma kéwaraao? aáwaqo nánétama iyáámma íma tete kéoe.” ");
INSERT INTO usa_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","tewana Îtuma yauwéqma timá yímikaiye: “nôraq itaráq keráwáqá keráwáqtí táaimma kéwareraq Áánûqtuni ámáan-aimma íma kéwaraao? ");
INSERT INTO usa_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Áánûqtuma maará-tiraiye. ‘emá enanó-enaboni aménáápáq máao. ánibo móra-nakoma anóanabi aboámmá timá táíq umákainaama min-náqá ikamíyana puíno.’ téna tiráine. ");
INSERT INTO usa_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","miráimanibo keráwáqá maará kéte. ‘móra-nakoma mónerabi móra-yataaqa makénama anóbomma áwáqnaa kéimanibo ‘maannáma monoq-náúpáqtábáé.’ kétenama ");
INSERT INTO usa_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","anóaboamma ayuwaíno. mirán-ááímmá tarôq kéeq Áánûqtun-aama márúte kéyuweq keráwáqtí táama múte kéyauyoe. ");
INSERT INTO usa_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","keráwáqá kaayaq-tóyáúkáráq-wáyúkáo, Áánûqtuni amuné-náqá Áítáíya Áánûqtuqtaba áraimma naayóbáqá maará-tiraine. ");
INSERT INTO usa_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘maan-ánná-ínínáúkáqá paá amegaa-yóyáúkáké tíwîqa múte kéyauyomanibo íyaqnobaqa keqtábá íma kéyikaiye. ");
INSERT INTO usa_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","yeqtábá Áánûqtuma maará-tiraine. ketí ámáan-aimma íkéwaraabo paá waayúkati ámáan-aimma kéwaretaboata keqtábámá paá oyaaq-yúyánámmá kéitaae.’ téna Áítáíya tiráine.” téna Îtuma timá yímikaiye. ");
INSERT INTO usa_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","mi-kánááráqá Îtuma aarawaamá yááyamae iréna iyáámma tete onáíqtábá timá yímikaiye: “keráwáqá itéraq túyánámmá ítama arútáaro. ");
INSERT INTO usa_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","óyauqnobaqa pérai-qtataakoma waayúkagomma mamá táíq íkéumakaiye. ímiye. ánibo túyánápíké pááq i-qtátáákómá waayúkama mamá táíq kéumakaiye. ");
INSERT INTO usa_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","mi táoqa Îtuni iyápó-annama iréta tirááe: “Pérati-wayukama min-áímmá itéta ôriq umá íyaqtaba kéoe. minnáyabama emá ítaraano?” téta Îtumma ítama aónaraae. ");
INSERT INTO usa_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Îtuma yauwéqma timá yímikaiye: “ketibomá mái-marupaqa wemá yabíkái-qtataaqa yokaa umá wáiye. mi tópímá máqte-qtataaqa wenamáárîq íuqmakaina-yataaqa áainakaraq yayútuwaniye.” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Îtuma ókaraq tiráiye: “keráwáqá iyuwáiyata máero. Pérati-wayukama yúramma karoparáakaa-kayukama aammá yirááti-wayukae. aúramma karoparáipoana káqo-nakomma aúramma karoparái-nakomma aammá aráátínata wenarááte-wenaraate íyamma íaoneta maipí metáyóye.” téna Îtuma tiraíye. ");
INSERT INTO usa_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Pítaama Îtumma timá ámikaiye: “waayúkama íma mamá táíq in-áíkóní waéqma itaí-áímmá waéqma abarokáq tinataa ítáano.” téna Pítaama tiráiye. ");
INSERT INTO usa_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","ánibo Îtuma tiráiye: “keráwáqá miráuma káqo-yuma aamá íma ítama arútáa-yuraa kéoe. keráwáqá íyaq kéitaao? ");
INSERT INTO usa_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","máqte-qtataakoma tóyaupike kumábékena tíyapi kumitana tíyakoma mamá márúte ayá-máípímá kéyuwaiye. ");
INSERT INTO usa_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","ááqibo óyaupike paábaq yaúbagima mi-qtátááqá túyánápíkékáráq tirunóbákékáráq kéuyena mi-qtátáákómá keráwáqá mamá táwíqa kéiye. ");
INSERT INTO usa_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","móra-nakoma áyáqnobake úí-qtataaqa mirá-uraiye. táí-auyanamma iténa waayúka ikámma puyena aaraukáqá mamá yataéna kumari-ááímá mamá pááq éna moyámmá mayéna kaaqaari-áúbí maréna akáyáámá téna kéiye. ");
INSERT INTO usa_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","máqtemma mirái-qtataakoma waayúkama kanaaráq mamá táwîqa íniye. ááqibo móra-nakoma ayáámma íma tete éna aáwaqa ánékuqma naimmá minnágoma waayúkamá Áánûqtun aúrakaq mamá táwîqa íkéiye.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","mi-kánááráqá Îtuma maami-márúqá yuwéna Tááya-marupakaraq Tááírana-marupakaraq uráiye. ");
INSERT INTO usa_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","ánibo móra Yéqtaaeo-inimma Kéinabakepoana min-áúkápáq máin-inikoma iréna ááyama tiráiye: “umaataráána-nako, emá Tébitin-annabike íniye tiráan-nako, kemmá emá arummá umátikaao. ketiyáámukomma táí-aagoma mamá táíq kéumakaiye.” téna min-íníkómá tiráiye. ");
INSERT INTO usa_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","miráitana Îtuma móra-aimma yauwéqma íma timá ámikaiye. ánibo wení iyápó-annama Îtumma timá ámikaae: “maan-íníkómá aamá kárame kéyena tinaaétaa waqmé kéiye. emá timákénana ‘kóíno’.” ");
INSERT INTO usa_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","téta tewana Îtuma yauwéqma tiráiye: “Ítíráaeobake tipi-típi-anna-wayukama aúyokoqtabae téna Áánûqtuma timátíkáitaq kemá yenamáa yeráwáqtábá kukáune.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","ánibo min-íníkómá iréna Îtuni aítaupi araayutaúmmá ayéna tiráiye: “umaataráána-nako, kemmá tíwáqnaa uwo.” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","ánibo Áánûqtun áama Ítíráaeo-wayukabi wáin-aiqtaba Îtuma yauwéqma tiráiye: “iyápógoni aáwaqa iyákómmá aménúnama minnâ íma arutániye.” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","ánibo min-íníkómá tiráiye: “umaataráána-nako, emá áraimma kétenamanibo aáwaqa aqtó-átómá anó-nakoni yaareráké marabí kutimmá iyákómá kénaae.” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","min-íníkómá mirá-timatuwaitana Îtuma yauwéqma tiráiye: “aaragô, emá arummá anómma timéne. nói-qtababi ákái-qtataaqa pááq umáminiye.” téna titana é mi táoqa ayáámukoni karígómá ánataguraiye. ");
INSERT INTO usa_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","íbêqa Îtuma mi-márúqá yuwéna Kááriri-nokaayukoni waaqókáq uréna anuraq ko máqe-uraiye. ");
INSERT INTO usa_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","ánibo netuqyaan-ánná-wáyúkámá ya ikúyakaraae. yemá máqte-kari-wayukama yítauqa táíq uráimma yúramma karoparáimma iyááqtámma kaékáimma yóyauqa aráápaguraimma yaímma-kari-wayukagaraqa Îtunopataa yiwíqmeta irááe. yemá mi-káyúkámá Îtun aítaupitaa máguyikaraae. ánibo Îtuma mamá atóbamayikaraiye. ");
INSERT INTO usa_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","miráitata aarawaamá iyánáaq éta yemá aónaamma yóyauqa aráápagurai-kayukama aamá kétewata iyáátámma kaékái-kayukama arupú kéowata yítauqa táíq urái-kayukama aammá uréire kéowata yúramma karoparái-kayukama yúramma káonaawata urááe. miráitataboata mi-káyúkámá Ítíráaeo-wayukati Áánûqtun-awiqa múte yaútaae. ");
INSERT INTO usa_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Îtuma wení iyápó-annama yááyamae iréna tiráiye: “maa-káyúkáyábá ôriq umá tirummá kéumayikaune. kaumo-yúpáámá ketê máqe-uraawanaboana yeqtí aáwaqa íma wáiye. yemá yáayaba kéiyanakaraq íma timáyíkáanata kóinoe. aapaqá yááyaba éta yúnááímmá íyábááé.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","ánibo wení iyápó-annama timá ámikaae: “maan-áúkápáqá waayúkama íma mááe. ketáámá náakakenaq netuq-ááwáqá mamátaawaq maami-nétúq-wáyúkámá yiménúnataabiyo?” ");
INSERT INTO usa_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","tewana Îtuma timá yímikaiye: “keráwáqá náaraq umá yanaq makááô?” titata yemá tirááe: “ketáámá abapaké kaayaq-yámmá maréta yaímma arekáq umá-noyaaqa makáunataae.” téta tirááe. ");
INSERT INTO usa_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","ánibo Îtuma mi-káyúkámá timáyíkáitata yemá marabí maraq máqe-uraae. ");
INSERT INTO usa_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","ánibo Îtuma maami abapaké kaayaq-yámmá kémayena noyááqa kémaye uréna Áánûqtukaq ‘tíkáiye’ timátuwena mapákena iyápó-annama yímitata yemá matéta mi-káyúkámá yímíqme urááe. ");
INSERT INTO usa_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","máqte-kayukama namá kanaaráq umátuweta yimuqá makááe. yaímma aqtómá wáimma abapaké kaayaq-kámáágúq-únámmá áíqturaae. ");
INSERT INTO usa_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","aáwaqo naa-káyúkámá miráuma netuqyaa-káyúkáé (4,000). ánibo aarawáá iyápóma íyorautaae. ");
INSERT INTO usa_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","ánibo Îtuma mi-káyúkámá timáyíkáitata kówana únópí-káárébí wemá uténa wení iyápó-annagaraq Máágataaniq-aukapaq-marabaq kóuraae. ");
INSERT INTO usa_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Pérati-wayukagaraq Táátûti-wayukagaraq Îtunopaq iréta makáqma aónaineta urááe. Îtuma móra anón-awaameq-yataariq ínataa aónanataae téta tiráámanibo ");
INSERT INTO usa_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Îtuma yauwéqma timá yímikaiye: “énaikaqa keráwáqá maará kéte. ‘aabayákómá karogarommá káuraitaqa íráqô-kanaama wániye.’ kétee. ");
INSERT INTO usa_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","ánibo aabáyaanapimma keráwáqá maará kéte. ‘konnákómá abúkitana aabayákómá karogarommá káuraipoana uwááma kéyorena aaqá yíniye.’ kétee. minnâ áraine. aabayákóní awaaméqá keráwáqá aónama kéyainaae. miráimanibo íbêqa maa-kánáágómá keqtábá awaaméqá immá íaonama kéyainaae. ");
INSERT INTO usa_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","íbêq-wayukama keráwáqá táí-noini-naukare. Áánûqtumma íaonaraa-kayukaraa-kayukae. kemmá anón-awaameq-yataaqtaba ítama káonaamanibo kemá móra awaaméq-yátáárîq onaq íaonainoe. keráwáqá paá Yónaani awaaméq-yátááqá mayánoe.” téna móraiq umá pukáipike itó-iniqtaba timátuwena Îtuma kóuraiye. ");
INSERT INTO usa_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","yemá iyápó-annama nokaayúmmá aqtátuweta kéwetamanibo yaímma yammá yiwikátuweta íma mayéta irááe. ");
INSERT INTO usa_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","ánibo Îtuma timá yímikaiye: “keráwáqá atéráaro! keráwáqá Pérati-wayukagaraq Táátûti-wayukati yammá itoraí-kánámá yíqtiyaba atéqma arútáaro.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","ánibo yeíyáá watáá-wataa téta: “ketáámá yammá íma mamé iráunataae. miráitanaboana kétiye.” téta iyápó-annama tirááe. ");
INSERT INTO usa_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Îtuma ítarenaboana tiráiye: “nôraq itaráq keíyááma netuq-túyánámmá itéraq ketáámá yammá íyaq makáunataabiyo kéteo? keráwáqtí itáíq-itaiq umá mái-yataaqa pááqyamma wáiye. ");
INSERT INTO usa_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","kemá móra-tiyaapaq-yamma mapamúnata netuqyaa-káyúkámá (5,000) naráaqtabama íyaq túyánámmá kéitaao? náaraq umá kamaaguq-unanaq áíqturaanabiyo? ");
INSERT INTO usa_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","ánibo abapaké kaayaq-yámmá mapamúnata netuqyaa-káyúkáma (4,000) narááe. miráuma áíkuteta nátúwááwaq aqtó-átó-ááwáqá áíqma náaraq umá kamaaguq-unanaq áíqturaanabiyo? ");
INSERT INTO usa_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","nôraq itaráq keráwáqá íma kéitaao? kemá yaqtabá íma timá tímikaune. keráwáqá Pérati-wayukagaraq Táátûtiq-wayukagaraqti yíqtiyaba atéráaro.” ");
INSERT INTO usa_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","téna Îtuma móragaraq tiráiye. miráitata iyápó-annama mikáq ítaraae. Îtuma yakaráq waéqma agayaí-yíqtíyábá íkétiye. ímiye. wemá paá Pérati-wayukagaraq Táátûtiq-wayukati yááyaba ‘atéráaro!’ téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Îtuma Tétáríá Píripai-aukapaq uréna mi-kánááráqá wení iyápó-annama ítama yimónéna tiráiye: “aarawaamá nóinae tétawaq Waayúkagoni Áráakoqtaba áwîqa kéyaao?” téna ítama yimónaraiye. ");
INSERT INTO usa_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","ánibo iyápó-annama tirááe: “yaímma-wayukama téta ‘Yóáanema nommá peraí-náré’ kétewata yaímma-wayukama téta ‘wemá Iráíyae.’ kétewata yaímma-wayukama téta ‘wemá Yérémáíyama káqomma Áánûqtuni amuné-náré’ kéte.” téta tirááe. ");
INSERT INTO usa_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","ánibo Îtuma iyápó-annama ítama yimónaraiye: “kenamáárîq keráwáqá keqtábámá náawae téraq tíwîqa kéyaao?” téna Îtuma ítama yimónaraiye. ");
INSERT INTO usa_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Tááímoni Pítaama yaúwéqma tiráiye: “emá yauwéqma yiwiraí-náqá Metáíyae Áánûqtuma matúq-matuq umá máin-nakoni áanimone.” téna Tááímoni Pítaama tiráiye. ");
INSERT INTO usa_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","minnáyaba Îtuma yauwéqma tiráiye: “Tááímonio, Yóáaneni áaniko amuqá maraao. mórama maa-márábí-nákómá íma maamin-áímmá timá ámikaiye. ímiye. ketibomá wení márûpaq mái-nakoma wenamáa maaminnáma emmá aráátiraiye. ");
INSERT INTO usa_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","kemá kétima-amune. emá Pítaamone. ení áwîkoni áaimma óqtamone. miráuma akoqnáá-oqtan-amuraaq naammá umáráanikaa umá enápó kemá ke-ánná-wáyúkámá áaimma átáma mamá áíkuyikanune. ánibo puí-yátáákómá ketí waayúkama íuyataniye. ");
INSERT INTO usa_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","kemá emmá Áánûqtuni márûpaq uyáberai-naapaamma kámune. kíma matokéna uyábéráinikaa umá kanaaráq uínóne. nóinawabi té emá máqten-amaan-aimma té ‘mirá íoro. maará íoro.’ tinna-ámáán-áímmá minnágaraq Áánûqtuni márûpaqa paá wániye. ánibo ení ámáan-aimma ‘miráoro-maaraoro.’ tinna-ámáán-áímmá móraiq umá Áánûqtuni márûpakaraq paá wániye. ");
INSERT INTO usa_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","ánibo Îtuma wení iyápó-annayaba akoqnáá-aimma timá-yimena: “keqtábá ‘Metáíya yauwéqma tiwiraí-náré’ ítero.” téna Îtuma timá yímikaiye. ");
INSERT INTO usa_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","mi-kánááráké Îtuma áaimma átárena wení iyápó-annama abarokáq timá yíkaraiye: “kemá Yérútáárebaq ónáae. mibáq uyátá-maqma anó-monoq-wayukagaraq kawáá-wáyúkágáráq ámáan-aimma yirááti-wayukagaraq yemá mirá umátikaiya-waigoma kemmá anómma tíqa íniye. yemá kemmá tíkamma puínomanibo kaumo-yúpáámá yauwéqma itó-ureq tú amá mánune.” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","ánibo Pítaama Îtumma áwábaq awíqme uréna káwaagena tiráiye: “uyátáráana-nako, emá ímira-uwo. mi-qtátááqá íma pááq íno.” téna Pítaa tiráimanibo ");
INSERT INTO usa_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Îtuma waéqma Pítaamma timá ámikaiye: “Tááqtaao, emá tinaaépaq yáwaao! emá ketúyánámmá mamá táíq-íné kéone. emá Áánûqtuni aúyánámmá íma kéitaane. emá paá waayúkati yúyánámmá kéitaane.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","mikáké Îtuma wení iyápó-annama timá yímikaiye: “móra-nakoma ketinaaé waránáae ténama wemá wení aúyánákóní akaí-yátááqá paábaq márúte yuwéna wení kaapaq-yámá maména puínéna yokaa énama tinaaé waraíno. ");
INSERT INTO usa_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","ánibo móra-nakoma wení maamin-áúwáráímmá yáqtoqma akoqnáá énama wení matúq-matuq umá mái-auwaraimma aúyokiniye. ááqibo móra-nakoma wení aúwaraimma keqtábáé téna puyénama wemá uyátá-maqma íráqôn-auwaraimma abatániye. ");
INSERT INTO usa_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","móra-nakoma maa-márábíké máqte-qtataaqtaba aúyánámmá itánîmanibo wení matúq-matuq umá mái-auwaraimma aúyokinanama mi-máqté-qtátáákómá náaraq umáq áwáqnaa íníyô? ánibo wení aúwaraimma nói-meyakakenaq yauwéqma meyánîq íníyô? ");
INSERT INTO usa_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Waayúkagoni Áráaqa kemá ketiboní akoqnáá-tagama-yataakaraq kumónúnama ketí kaqtó-wayukate Áánûqtunopake kumónúnatae. mi-kánááráqá kemá aarawaatí máqten-aaiqtaba meyámmá yiménúne. ");
INSERT INTO usa_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","kemá áraimma kétima-timune. yaímma-wayukama maannámo máa-kayukama íma pukéta paá máeta aónaraiyana Waayúkagoni Áráaqa anó-kinimma aúqma máena kumíniye.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","abapaké móra-kanaama yátámakitana Îtuma Pítaamma káwirena Yêmitiyaa mi-kátámá Yóáanete yiwíqmayaitata mórama uyátárain-anuraq utááe. yenamáa mibáq máqe-uraae. ");
INSERT INTO usa_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","ánibo Îtuni aúgoma yúrakaq mamá waéqma aokarîq uráiye. miráitana wení óikoma tágama aakáá kégaitana wení wáqtôgoma wayámmá kamá ókáá karáiye. ");
INSERT INTO usa_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","ánibo Mótetiyaa Íráíyama Áánûqtuni márûpake kumáeta Îtute watáá-wataa kéteyata yemá aónaraae. ");
INSERT INTO usa_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Pítaama minnáma aónatuwena Îtumma timá ámikaiye: “uyátáráana-nako, ketáámá maakáq máunataama íráqône. emmá akáinaqa kanaaráq kemá kaumomá kogonaagó-namma maakáq ónúne. mórama ení naané mórama Mótetini naané mórama Íráiyani naané téq miráuma ónúne.” téna Pítaama tiráiye. ");
INSERT INTO usa_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","mirá kétena máiqtaba mórama aakáá kaikónnákómá kumma yawááq umáyikaraiye. ánibo móra-aikoma mi-kónnápíké maará-tiraiye: “maannáma ketáanikoma tikáin-iyapoe. wení áaiqtabama ôriq umá kétikaiye. keráwáqá wenáama ítáaro.” téna aagómá mi-kónnápiké tiráiye. ");
INSERT INTO usa_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","ánibo iyápó-annama min-áímmá ítátuweta ikatîq kéetaboata yemá yóipake marabi yiqá agurááe. ");
INSERT INTO usa_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","miráitana Îtuma yimakaq iréna yineq kánekuyena timá yímikaiye: “keráwáqá itó-oro. keráwáqá ikatîq íoro.” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","ánibo yemá itó-uma aónaamma káqo-wamma íma aónaraabo paá Îtumma wenamáa aónaraae. ");
INSERT INTO usa_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","min-ánúmá yuwéta kégumowana aapaqá Îtuma akoqnáá umá timá-yimena tiráiye: “keráwáqá maami-qtátááqá aónaamma móra-nakomma íma timámeraq yukáiyana Waayúkagon-Araaqa kemá pukéq itó-onna kanaaráq wino.” téna Îtuma timá yímikaiye. ");
INSERT INTO usa_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","ánibo yemá iyápó-annama Îtumma ítama aónéta tirááe: “nôraq itatawáq ámáan-aimma yirááti-wayukama Íráiyaqtaba Metáíyani áqnáabaq yíno kéteo?” téta tirááe. ");
INSERT INTO usa_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","ánibo Îtuma yauwéqma timá yímikaiye: “owé. áraine. Íráiyama iréna máqte-qtataaqa mamá yokaa íniye. ");
INSERT INTO usa_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","miráimanibo kemá kétima-timune. Íráíyaraa-naqa áqa iráitata waayúkama wemmá íaonama arútaraae. ímiye. yemá paá yeqtí yikaí-yátáákáké yúyánámmá kéwareta táí-aaimma ókon-okomma tarôq umákaraae. miráráá umá Waayúkagoni Áráaqa kemmá min-áwáátárîq umátikanoe.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","mirá-timatuwaitata Îtuma nommá peraí-náqá Yóáaneqtaba kétiyaa téta wení iyápó-annama ítaraae. ");
INSERT INTO usa_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Îtuma wení iyápó-annagaraq yemá netuqyaa-káyúkábí yauwéqma koyamá kéowana móra-nakoma Îtunopaq iréna arayutaúmmá ayéna tiráiye: ");
INSERT INTO usa_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“uyataráána-nako, emá ketáanikomma arummá umákaao. wemmá augááyámma kákaiye. netuqyaa-kánáámá wemá irabí kégaugena nopí kémetagena kéiye. ");
INSERT INTO usa_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","ánibo kemá min-íyápómá awíqme ení iyápó-annayopaq únnama íma mamé érákáawaniq urááe.” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Îtuma yauwéqma timá ámikaiye: “keráwáqá min-ánná-wáyúkámá itáiq-itaiq í-yáqtááqá íma wáitana keráwáqtí tíyakoma íma kárutaiye. náaraq umá kanaawaq kemá keráwáqtêma máunaq Áánûqtuni akoqnááma matááô? náaraq umá kanaawaq kemá keráwáqtí ummaamá mayánúnô? keráwáqá min-íyápómá awíqmera maakáq ketôpaq yero.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","miráitana Îtuma mi-táí-áágómmá awáágítana min-iyápógómmá ayúwáitana ê kí-taoq wení karígómá ánatamakaraiye. ");
INSERT INTO usa_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","ánibo iyápó-annama Îtunopaq aúpáq iréta timá ámikaae: “nôraq itataawáq ketáámá maami-táí-áágómmá kanaaráq íma kéwaqtuwaunataabiyo?” téta tewana ");
INSERT INTO usa_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Îtuma yauwéqma timá-yimena tiráiye: “keráwáqtí itáíq-itaiq umá arummá timí-yátááqá pááqyapoaq keráwáqá kanaaráq ímira-inoe. kemá áraimma kétima-timune. karáwáqtí itáíq-itaiq umá arummá timí-yátááqá pááqyapoaq keráwáqá kanaaráq ímira-inoe. kemá áraimma kétima-timune. keráwáqtí itáíq-itaiq umá arummá timí-yátáákómá miráuma pááqyan-anayukoraa kéinaqa kanaaráq keráwáqá maan-ánúgómmá timákeraq ‘emá itó-uma merapaq waao’ tíyana kanaaráq wíniye. keráwáqá káqomma máqteniq inómanibo ");
INSERT INTO usa_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","mirá-táí-áágómmá matuwáiyaba paá nunamukáráq aáwaqa awetáigaraq yenamáa kanaaráq wániye.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Kááriri-marupaq uréire kéeta Îtuma iyápó-annama timá-yimena tiráiye: “yemá Waayúkagon-Araaqa kemmá namuro-wáyúkátí iyáápi áaimma átáma maránóe. ");
INSERT INTO usa_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","miráiyata tíkamiyaq puyéq kaumo-kánáámá maéq itó-onune.” téna titata iyápó-annati íyakoma ummaa yáguraiye. ");
INSERT INTO usa_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Îtuma wení iyápó-annagaraq anaaékaqa yemá Kápéranabaq koyaawana anó-monoq-naupaqtaba táákiti-moneqa máyáa-kayukama Pítaanopaq iréta maará téta timá ámikaae: “keráwáqtí tirááti-nakoma anó-monoq-naupaqtabama táákiti-moneqa kéyuwaiyo?” téta ítama aónaawana Pítaama yauwéqma tiráiye: ");
INSERT INTO usa_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","“owé.” téna tiráiye. ánibo Pítaama naaúpaq uyábéráitana áqnáabaq Îtuma Pítaamma ítama aónainoqtaba aamá timátuwena Pítaamma ítama aónaraiye: “Tááímonio, emá nóine té kéteno? maa-márábí-kíní-káyúkáráqá meyámmá táákiti-moneqa náayuwaq kámeo? maa-máráráké-káyúkáwábi óq-marabake-kayukabikena kémayaao?” téna Îtuma ítama aónaraiye. ");
INSERT INTO usa_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Pítaama tiráiye: “óq-marabake-kayukabikene.” téna tiráiye. ánibo Îtuma timá ámikaiye: “miráitana maa-máráráké-káyúkámá táákiti-moneqa íma kéyuwaamanibo ");
INSERT INTO usa_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Áánûqtuni iyápóboaqtaa táákiti-moneqa íma kanaaráq yiménúnataamanibo ketáámá maami-káyúkámá mamá íyamma íumayikanatae. miráinaq emá nokaayúpáq uré noyááqa mó-yaao. áqnáabaq yenna-nóyáákómmá óyauqa ógaarennama min-nóbáqá móneqa wániye. mi-mónéqá mayéma táákiti mayaí-wáyúkámá anó-monoq-naupaqa etê kerátáí táákitima mó yimiyo.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","mi-kánááráqá iyápó-annama Îtunopaq iréta tirááe: “Áánûqtu yabíkái-marupaqa náawaq tébakaqa uyátá-maqma anómma máiyo?” téta tirááe. ");
INSERT INTO usa_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Îtuma móra pááqyan-iyapoma awíqme iréna yeqtí aúkáapi má itó-umakaraiye. ");
INSERT INTO usa_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","ánibo Îtuma tiráiye: “kemá áraimma keráwáqá kétima-timune. keráwáqá íma waéqma pááqyan-iyaporaa éqa keráwáqá íma Áánûqtu yabíkái-marupaqa uyáberanoe. áraimma ímiye. ");
INSERT INTO usa_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","móra-nakoma wenaúma íma mamé uyéna maan-íyápóráá umá pááqyan-awiqa mayénama min-nákómá káqo-yuma uyátá-maqma Áánûqtu yabíkái-marupaqa mániye. ");
INSERT INTO usa_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","ánibo móra-nakoma ketíwîkaq maarán-iyápómá áwáqnaa énama kemmá móraiq umá tíwáqnaa kéiye. ");
INSERT INTO usa_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","maami pááqyan-iyapoma náayubi kekáq yirummá timíya-noiyapobike móra-nakoma ketôpakemma mamá paábaq waéq-yikenama min-nákómmá móra anón-oqtamma min-nákóní ánûwarapi kúmarena anó-nokoni aúkáapi iyaabótuwanimma minnâ pááqya-qtataare. Áánûqtuni táí-meyamma uyátá-maqma anómma mayániye. ");
INSERT INTO usa_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","maa-márábi-káyúkámá ketôpake yuwéta waéqma koíya-kayukama anaaékaqa táwíq umáginomanibo miráuma táí-aaimma pááq kéiye. áaqibo móra-nakoma ketôpake káqo-yuma mamá paábaq waéq-yikenama wemá uyátá-maqma anómma táwiq umáginiye. ");
INSERT INTO usa_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","keráwáqtí tiyáákowabi títaukoma keráwáqá mamá kéwaerena kúmiq-yataapi mamá kétikainaqa tíyáánaa títauqa aráqma paábaq yúwáaro. minnâ keráwáqá keráwáqtí tiyáánaa títauqa paá wárainana kúmiq-yataapi tiwíqme kéwinatama anaaékaqa keráwáqá iramá káíq-kaiq éna íma putínáí-írábí iyaabótuwanoe. ");
INSERT INTO usa_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","ánibo túrakoma mamá waéqma kúmiq-yataapi kétikainaqa kubíqma paábaq yúwáaro. kímora-turamma wáinaqa kanaaráq matúq-matuq umá mái-auwaraimma mayáínóbo kaayaq-túrámmá wáinatama keráwáqá yaúma iramá káíq-kaiq-irabi iyaabótuwanoe.” téna Îtuma timátuwena. ");
INSERT INTO usa_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","14","ókaraq tiráiye: “keráwáqá atéráaro. pááqya-noiyapoyabama kemmá itáiq-itaiq umá paátataare téq íma keráwáqtí aúkáapikemma móra-tuyanamma ítáaro. kemá keráwáqá kétima-timune. ketibomá Áánûqtunopaqa mórá-mora-yuma yeqtí kaqtó-wayukama aati-aatimá paá mááe. minnâ ketibomá maami-nóíyápóbíké mórama aúyoraiyaba íkákaiye. Waayúkagon-Araakoma waayúkama Áánûqtunopaken-amma yuwéta aúyokuraa-kayukama yauwéqma yiwiránéna kukáiye. keráwáqá nóine téraq kéitaao? móra-nakoma miráuma taíbaq tipi-tipima (100) makáinana móra-tipi-tipima aúyokinanama íyaq abáá-iniyo? owé. miráuma abapaké kaayaqté-kaayaqte-tiyaakagaraq móra-tiyaama naikamá kaayaqté-kaayaqte (99)-tipi-tipima iyuwaínata anubaq máiyana móramo aúyoki-waigoqtaba ko abáá-iniye. kemá áraimma keráwáqá kétima-timune. mi aúyoki-tipi-tipima abatátuwena awirénama mimórámô aúyokitana awírái-waigoni amuqá anómma marániye. ánibo (99) tipi-típima íma aúyokoyuti yimuqá íma kémarainiq umá amuqá marániye. miráráá umá ketibomá Áánûqtuma wení márûpaq máin-nakoma maa pááqya-noiyapoti aúkáapike mórama aúyoraiyaba íma kákaiye. ");
INSERT INTO usa_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","ítáaro. enábâkoraa-nakoma emmá kúmiq-yataariq kéumakainaama kanaaráq emá uréyaq kenákámá kenammáa maéka wení kúmiq-yataaqa aráátiyo. ánibo wemá enáama itáinnama miráuma enábâkoraa-naqa yauwéqma awiránóne. ");
INSERT INTO usa_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","ááqibo wemá enáama íma itáinaama emá kaayarábi móra-naqa awiqma yagaroqtamá okao. miráuma ‘kaayarábi kaumo-wáyúkámá kanaaráq mimórá-áikáq aamá tínóe.’ téna Áánûqtuni agamatá-kánnáábí kétipoana min-áíkomá akoqnáá umá wániye. ");
INSERT INTO usa_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","miráimanibo wemá yeqti yáama ímo itaínaama kanaaráq monoq-náúpáq áíkuiya-kayukabi mó-tero. ánibo monoq-náú áíkuyo-kayukati yáama itáíyábágáráq íakainaama minnâ wemá aamá íitainapoana monoq-náú áikuyo-kayukayopaq íuwininiq umákáaro. ");
INSERT INTO usa_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","kemá áraimma keráwáqá kétima-timune. máqte-qtataaqa maa-márábimô aúyaq-maraiyaq-qtataaqa Áánûqtuma wení márûpaqa aúyaq-maraniye. ánibo máqte-qtataaqa maa-márábimô timáyikaiya-qtataaqa Áánûqtuma wení márûpaqa timátikaniye. ");
INSERT INTO usa_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","kemá ókaraq keráwáqá áraimma kétima-timune. yenákámá kaayaq-nákórátámá keráwáqti aúkáapikema kenákámá mimórá-túyánákáq maréka nunamummá tiyamma kanaaráq ketibomá Áánûqtuma wení márûpaqa máin-nakoma yenákámá yimíniye. ");
INSERT INTO usa_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","taákaq máráaro! paá kaayaq-nákówábi kaumo-nákómá ketíwîqtaba áikuma maiyaqa kanaaráq kemá yeqtí aúkáapi mánune.” téna Îtuma akoqnáá-aimma tiráiye. ");
INSERT INTO usa_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","mi-kánááráqá Pítaama Îtunopaq iréna timá-amena tiráiye: “uyátárai-nako. náaraq umábaraq ketíbâkoma kúmiq-yataariq umátikainaq kemá wení kúmiq-yataaqa mamá paábaq matuwéq tiwikátuwanuno? abapaké kaayapárábiyo?” téna Pítaama tiráiye. ");
INSERT INTO usa_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Îtu maará téna yauwéqma timá ámikaiye: “abapaké mórabaqa ímiye. miráuma abapaké kaayaq-wáyúká aíyayaa-tiyaaka umá abapaké kaayapáq (77) wení kúmiq-yataaqa páabaq matuwéq awikátuwao. ");
INSERT INTO usa_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","miráinana Áánûqtuma yabikái-kayukama miráráá kéoe. kíniraa umá wení mayaí-wáyúkátê aqtábááma mamá arupú ínóe. ");
INSERT INTO usa_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","wemá aqtábááma áaimma átáma mamá arupú kéitata yemá móra-naqa awíqmeta wenôpaq irááe. min-nákóni aqtábááma ámikaamma miráuma netuqyaammá táwibaq-moneqa (10 tausen kina) aqtábááma wái-nare. ");
INSERT INTO usa_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","miráitana wení móneqa íma wáipoana anónnáma kanaaráq amíniye. miráitana kínima téna maami-nákáráq ánáakokaraq wení iyápógaraq wení máqte-qtataakaraq waayúkaraq maraíyata meyánîq kéiyaraq mirá-mónéqá mamá anónnáma aqtábááraq kínimma áméro tiráiye. ");
INSERT INTO usa_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","miráitana mi-máyáí-nákómá kínini aítaupi araayutaúmmá ayéna maará téna inaa tiráiye. ‘arummá umátike tiwé urénaro. kemá ení máqten-aqtabaaraq anónnáma ámíqma ánatanune.’ téna tínana ");
INSERT INTO usa_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","min-nákóní anó-nakoma arummá umákena wení aqtábááraq ayuwaítana anónnáma íma ámikaiye. ");
INSERT INTO usa_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","ánibo mi-máyáí-nákómá máápaq yaúbarena aónaimma móra-mayai-naqa tiyáákama (100 kina) aqtábááma ámikai-nare. minnáqá ánûwarapi yáqtoqma akoqnáá umátokena tiráiye. ‘aqtábááma ámikaunaraqtaba páátákáá anónnáma timiyo.’ téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","miráitana min-nákómá wetê mórabi mayaímá mayáaya-nakoma wekáq araayutaúmmá aténa maará téna inaa tiráiye. ‘emá arummá umátike tiwé urénaro. kemá ení aqtábááraq anónná aménúne.’ téna tiráimanibo ");
INSERT INTO usa_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","wemmá paá íákaraiye. min-náqá ánna/-naupaq mó ákaraimma wemá ánná-naupaq máena wení aqtábááma meyánîq umá ánataniye tiráiye. ");
INSERT INTO usa_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","ánibo káqo-mayai-wayukama miráin-aaimma aónatuweta íyaqnobaq ítama táíq umátuweta yemá yeqtí anó-nakaq uréta miráin-aimma mó timá abarokáq urááe. ");
INSERT INTO usa_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","miráitana anó-nakoma mi-máyáí-náqá anón-aqtabaama wái-naqa ááyarena maará téna timá ámikaiye. ‘emá táí-mayai-naqone. áqnáabaqa kekáq ibiqá yaráánaq kemá ení máqten-aqtabaama yuqmá paátataakaa uráune. ");
INSERT INTO usa_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","kemá emmá tirummá umákaraune. emá nôraq itaawáq ení móra-mayai-nakomma arummá íkéumakaano?’ téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","ánibo wení anó-nakoma áyámma itana min-náqá i-wáyúkátí iyáápi máráitata i-wáyúkámá ánnábi ákáawana máena kammáa káena wení aqtábááma anónná yauwéqma aminiye.” téna Îtuma mi-kátáámá ");
INSERT INTO usa_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","timátuwena tiráiye: “keráwáqtí tiyaqnobaqa máqtemma tíbáqawaaraa-kayukati kúmiq-yataaqa íma mamá paábaq kéyuwaapoana ketibomá Áánûqtuma wení márûpaq máin-nakoma móraiq umá keráwáqtí kúmiq-yataaqa íma mamá paábaq matuwéna awikátuwaniye.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Îtuma mi-máqtén-áímmá timá ánatatuwena Kááriri-maruqa yuwéna Yúría-marupaq yauwéqma Yótaa-nokomma móra-aukapaq uráiye. ");
INSERT INTO usa_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","netuqyaa-káyúkámá anaaé waqmé kéowana min-áúkápáqá karí-wáyúkámá Îtuma mamá atóbamayikaraiye. ");
INSERT INTO usa_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","yaímma Pérati-wayukama Îtunopaq iréta wemmá makáqma aónaraae. yemá maará-tiraae: “ámáan-aikoni aúrakaqa máqte-kayukama yínááqa waqtuwaí-ááímmá kanaaráq yínááqa waqtuwánô?” ");
INSERT INTO usa_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","téta tewana Îtuma yauwéqma tiráiye: “keráwáqá maamin-áímmá íyaq yoráútaao? maará-tiraine. naayóbáqá Áánûqtuma máqte-qtataaqa tarôq uráine. naayóbáqá aaragáráq waagaráq tarôq uráine. ");
INSERT INTO usa_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","tarôq umá yikátuwena maará-tiraiye. ‘miráinana waagómá anóaboamma ayuwéna ánáakote yagaroqtamá maéta yenákámá móra-yuma aúqma máyoye.’ téna Áánûqtuma tiráine. ");
INSERT INTO usa_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","miráitata yenákámá íma kaayaq-wáyúkáráá umá mááye. ímiye. yenákámá miráuma mi-mórá-yúmá aúqma mááye. miráinata Áánûqtuma yarúyikarainnama íma yatáétao.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","ánibo Pérati-wayukama Îtumma timá-ameta tirááe: “nôraq itanawáq Mótetima ámáan-aimma timénataa waagómá aaraukáqá yataí-áúbámá agamá ‘aaragómmá ámítuwe waqtuwaao’ tiráíyô?” téta itama aónaraae. ");
INSERT INTO usa_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","ánibo Îtuma timá yímikaiye: “minnâ tirunóbáqá akoqnáá kéeq keráwáqá aamá arátéwana Mótetima keráwáqti aammá awiyéna ‘aaramá waqtúwáaro’ tiráine. miráimanibo naayóbáqa maramá áaimma átarai-kanaaraqa mirán-ámmá íma wáqe-uraine. ");
INSERT INTO usa_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","kemá maará téq keráwáqtábá kétune. móra-nakoni ánáakoma kumari-ááímmá íma tarôq kéinana awaikómá paábaq kéwatuwena káqon-inimmo mayainama min-nákómá kumari-ááímmá tarôq kéiye.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","ánibo Îtuni iyápó-annama Îtumma timá ámikaae: “miráinatama aaramá íma mayánóma minnâ uyátá-maqma kanaaráq íye.” téta wení iyápó-annama tirááe. ");
INSERT INTO usa_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","tewana Îtuma maará-tima-yimikaiye: “máqte-noininaukaqa maamin-áímmá kanaaráq íma mayánómanibo yaímma-wayukaraq Áánûqtu yímikaiye. ");
INSERT INTO usa_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","ítáaro. yaímma-wayukama aaramá íma kanaaráq mayánómma minnâ yaímma-wayukama yeqtí yúgoma aúyakurainatama kanaaráq iyápóma íma maqyikánómma yeqtí yinóama mirápáq maqyikáraipoatabi waayúkama yikáma kareremá aúqyíkaraipoata aaramá íma kanaaráq mayánóe. ánibo yaímma-wayukama aaramá íma máyáamma miráuma yeqtí yúyánákáráq yirukaráq máqte-qtataaqa Áánûqtumma kámetaboata yemá aaramá íkémayaae. miráineqa keráwáqá kanaaráq mirá-inoe. maaminnámo tiraatíyan-aimma máyáaro!’ téna Îtu tiráiye. ");
INSERT INTO usa_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","mi-kánááráqá yaímma-wayukama pááqya-noiyapoma yiwíqmeta Îtunopaq irááe. wemá yineq ayáámma yínêkuyena nunamummá tíkáae téta irááe. miráimanibo Îtuni iyápó-annama aamá yiwááguraae. ");
INSERT INTO usa_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","ánibo Îtuma tiráiye: “keráwáqá pááqya-noiyapoma iyuwaíyata ketôpaq yero. keráwáqá íma yáqtoq-yikaaro. Áánûqtu yabíkái-marupaq mái-wayukama mirá-nóíyápótí márûqiye.” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","mirá-timatuwena ayáámma pááqya-noiyapoti yineq árúqmakaiye. miráumatuwena Îtuma min-áúkápáqá yuwéna kóuraiye. ");
INSERT INTO usa_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","móra-nakoma Îtunopaq iréna tiráiye: “yirááti-nako, kemá náaraq umáwaq íráqôn-aaimma tarôq éraq aati-aatimá matúq-matuq umá mái-auwaraimma mayánúnô?” téna ítama aónaraiye. ");
INSERT INTO usa_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","ánibo Îtuma timá ámikaiye: “nôraq itaawáq íráqô-qtataaqtabama kemmá ítama káonaano? aúyánánóbáqá arútama itaao. kímora-naqa wenamáa íráqô-naqiye. ánibo emá aúwaraimma mayánéma kanaaráq emá máqten-amaan-aimma waraao.” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","ánibo min-nákómá Îtumma timá ámikaiye: “nóin-amaan-ainabiyo?” téna tiráiye. Îtuma tiráiye: “ámáan-aikoma maará-uraiye. waayúkama íma ikámma puyuwo. aaraukáqá íma mamá yataiyo. moyámmá íma mayaao. káqo-wamma kaaqaarimá ítimakaao. ");
INSERT INTO usa_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","emá enanó-enaboni aménáápáq mááo. enamáárîq arummá amé kaayoné ónaiq umá náawabi enamakaq maína-naqa arummá amé kaayoné umákaao.” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","ánibo mi-mábú-nákómá Îtumma timá ámikaiye: “mi-máqtén-ámáán-áímmá kemá kéwaraune. kemá nói-qtataaqtabawaq aqtórárîqa kéuno?” téna ítama aónaraiye. ");
INSERT INTO usa_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Îtuma yauwéqma timá ámikaiye: “emá kanaaráq umá ánatanaae téma emá uré ení máqte-qtataaqa waayúkaraq marénata meyánîq kéiya minnárake móneqa maté áwáyoq-wayukama yímituwema Áánûqtuni márûpaqa íráqô-qtataaqa maránóne. emá ketinaaé ya-waraao.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","mi-mábú-nákómá min-áímmá itáá ena áyákoma ummaa kéyaipaq kóuraiye. miráimma wemá taíbaq-yataaqa makáiqtababoana mirá-uraiye. ");
INSERT INTO usa_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","ánibo Îtuma wení iyápó-annama timá yímikaiye: “kemá keráwáqá áraimma kétima-timune. móneqa netuqyaa makái-nakoma Áánûqtu yabíkái-marupaq uyáberaniqtabama kammáa kámagiye. ");
INSERT INTO usa_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","kemá keráwáqá ókaraq kétima-timune. móra-wamma káámoma oótiraa-kakoma wáqtô aráátai-waigoni aapimmá peránénama kammáa ainíkáá umá móneqa netuqyaa makái-nakoma Áánûqtu yabíkái-marupaq uyáberaniqtaba anómma uyátá-maqma kammáa kámagiye.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","yemá iyápó-annama maamin-áímmá ítátuweta iyánáaq urááe. yé maará-tiraae: “miráinana náawaq Áánûqtuni-marupaq wemá kanaaráq uíníyô?” téta tirááe. ");
INSERT INTO usa_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","ánibo Îtuma yúrapi karákéna timá yímikaiye: “waayúkama kanaaráq mirá íinoe. Áánûqtu wenamáa máqte-qtataariq kanaaráq íniye.” téna ");
INSERT INTO usa_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Îtuma mirá-timatuwaitana Pítaama yauwéqma tiráiye: “éqtukenaro. ketáámá máqte-qtataaqa yuqmá ánatetaa enanaaé ya kéwaraunataae. miráinataa ketáámá nói-qtataaraq mayánúnataabiyo?” téna Pítaama tiráiye. ");
INSERT INTO usa_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","ánibo Îtuma timá ámikaiye: “kemá áraimma keráwáqá kétima-timune. anaaékaqa máqte-qtataakoma aúgeniq íni-kanaaraqa kemá Waayúkagoni Áráaqa akoqnááma mayéqa kínin-abitataraq mánune. mi-kánááráqá keráwáqá tiyááka umá kaayaqá ketinaaémo kéwaraiya-kayukama tiyááka umá kaayaq-ábítátáráq mánoe. keráwáqá Ítíráaeobake tiyááka úma kaayaq-ánná-wáyúkámá mamá yainánóe. ");
INSERT INTO usa_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","máqte-kayukama ketíwîqtaba itéta yeqtí naammá yuwéta yíbâqawaanabi yímanaatoinabi yinóanabi yiboánábi iyápóabi yeqtí yónábi yukáíya-kayukama yemá ókaraq netuqyaammá matéta íráqô-qtataaqa anónnáma yiméta yemá aati-aatimá matúq-matuq umá mái-auwaraimma mayánóe. ");
INSERT INTO usa_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","ááqibo netuqyaa-káyúkámá maa-márábí uyátá-maqma anómma máiya-kayukama anaaékaqa aqtóráqá íyata ánibo netuqyaa-káyúkámá íbêqa anaaékaqo kéiya-kayukama Áánûqtuni-marupaq uyátá-maqma anómma máno-kayukama wínóe.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Îtuma óq-aimma tiráiye: “Áánûqtuma yabíkái-qtataaqa mirá-uraiye. móra-nakoma anó-marama makáinikaa uráiye. ánibo aabáyaanapimma min-nákómá uréna wení wááéni-yopi mayaímá mayaí-wáyúkámá ko yiwíkaiye. ");
INSERT INTO usa_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","min-nákómá yaímma-mayai-wayukate aamá téite umátuweta móra-iyakaq maréta mayaírákémá ‘tiyááka-tiyaaka umá móneqa (1 kína) mayánúnataae’ tirááe. ánibo mirá-timatuweta wááéni-yopitaa mi-máyáí-wáyúkámá timáyíkaraiye. ");
INSERT INTO usa_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","miráuma aabaúgómmá aabayaaráq uyáwitana (9 kíróki) kawáá-nákómá ko aónaimma yaímma paá-wayukama paá itó-uma máákéti-marupitaa mááwana yimónaraiye. ");
INSERT INTO usa_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","ánibo min-nákómá mi-káyúkámá timá yímikaiye: “kanaaráq keráwákáráq wááéni-yopi mayaímá ko kémayaiyaq meyámmá arútâma timénúne.” ");
INSERT INTO usa_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","titata yemá urááe. móraiq umá wágááwabi énaikaqa (miráuma 12 kírókigaraq 3 kírókigaraq) wemá uráiye. ");
INSERT INTO usa_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","ánibo énaikaq (aabaúgómá 5 kíróki) keqnáámmá ko aónaimma yaímma-wayukama paá itó-uma mááwana min-nákómá timá yímikaiye: “nôraq itaráq íbêq-wagaama paámá itó-uma mááo?” ");
INSERT INTO usa_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","téna titata mi-káyúkámá timá ámikaae: “móra-nakoma móra-mayaima íma kétimitaqtaae.” téta tirááe. ánibo min-nákómá timá yímikaiye: “keráwákáráq wááéni-yopi mayaímá ko máyáaro.” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","aabaúgómá énaikariq itana wááéni-yokoni aboámá wení mayaíráq-káwáá-náqá timá ámikaiye: “emá mayaíráq-wáyúkámá yááyare meyámmá yimiyo. emá anaaékaq mayaí ya matáiya-kayukarake áaimma átáma meyámmá yímike áqnáabaq-wayukaraq waao.” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","ánibo énaikaqa (5 kíróki) mayaímá áaimma átáma máyáa-kayukagaraq iréta meyámmá móneqa tiyááka-tiyaaka umá matááe. ");
INSERT INTO usa_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","áqnáabaq áaimma átáma mayaímá matáá-kayukama iréta ‘ketáámá anó-moneqa mayánúnataae’ téta yúyánápí tirááe. miráimanibo ímiye. yegáráq meyámmá tiyááka-tiyaaka umá móraiq umá matááe. ");
INSERT INTO usa_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","yemá miráuma meyámmá maméta yókóní aboámmá awáágúraae. ");
INSERT INTO usa_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","yemá mirá-tiraae: “mi-káyúkámá yinaaémo mayaí máyáa-kayukama yemá pááqya-kanaama mayaí matááe. miráuraawaa emá yemmá móraiq umá ketááí meyákáá umá kéyimene. ánibo ketáámá ayáqtáá-kanaama anó-naqa kaikáq ummaa-máyáímá kémayetaa aaqá káutaune.” téta tirááe. ");
INSERT INTO usa_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","mirá-timatuwaawana yókóní aboámá yeqtí aúkáapike móra-nakomma timá ámikaiye: “ketí aanábó-nákô, emmá íma mamá táíq umákaraune. meyámmá móneqa tiyáákama mayáánayaba íyaq aamá timá móra-tiyakaq makáúyô? ");
INSERT INTO usa_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","máqtemma keráwáqá paá mamé kóoro! kemá meyámmá keráwáqá timúnna-meyakaa umá móraiq umá tinaaémo íya-kayukama meyámmá yiménúne. ");
INSERT INTO usa_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","nôraq inábiyo? ketí móneqnapo nôrabi ónááqa paá miráonu íyabiyo? kemá yemmá íráqô-qtataariq kéumayikaunaraq minnáyaba kárún-aaimma kéteo?” téna yókóní aboámá tiráiye. ");
INSERT INTO usa_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","miráuma anaaékaqo iráa-kayukama anó-nakoma uyátá-maqma anómma yímikaiye. áqnáabaqo iráa-kayukama anó-nakoma yemmá márû mikákáá pááqyamma yímikaiye. miráitaq kemá kétune. anaaékaq iráiya-kayukama áqnáabaq wíyata ánibo áqnáabaq iráiya-kayukama aqtóúrákáq wínóe.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Îtuma Yérútáárebaq uwíné kéena wení tiyááka umá kaayaq-íyápó-ánnámá yiwíq-mayaitata wetê kóuraae. ánibo yemá aapaq kéweta Îtuma maará téna timá yímikaiye: ");
INSERT INTO usa_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“ítáaro. íbêqa ketáá Yérútáárebaq uyónúnatae. mikáqá kemmá Waayúkagoni Áráaqa yemá uyátá-maqma anó-monoq-wayukagaraq ámáan-aimma yirááti-wayukagaraq yeqtí iyáápi maráiyata yemá aabi matikéta tíkamma puí-áímmá téite éta yawááq-umatikanoe. ");
INSERT INTO usa_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","mirá éta yemá kemmá káqon-anna-wayukama Yéqtaaeo-wayukama yimíyata akáyáámmá timátiketa tebûqa timéta kaapaq-yátáq tíkamma ítikanoe. miráiyaq pukéq kaumo-kánáámá ánatainaq pukáanabike itó-uma paá mánune.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Yéberima áanikokaratama yinóama yiwíqmena Îtunopaq iráiye. min-íníkómá Îtuni aítaupi araayutaúmmá aténa móra-yataaqtaba Îtukaq akoqnáá umá ítama aónaraiye. ");
INSERT INTO usa_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Îtuma timá ámikaiye: “emmá nóiqtabaq kákaiyo?” téna ítáitana min-íníkómá wemmá timá ámikaiye: “emá anaaékaqa anó-kinimma máinona-kanaaraqa ketí maa-kááyáq-íyápógórátámá enamakaq mááyoye. té minnáyaba akoqnáá umá timá-timiyo.” ");
INSERT INTO usa_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","mirá téna timátúwáitana Îtuma yauwéqma maará-tiraiye: “emá akoqnáá umá ítama aónáána-yataaqtabama íitaraane. káápuma awaaméqá tú-tiqa éna ummaa ôriq umá yáni-kaapubikema kanaaráq náyóyô?” téna titata yenákámá yauwéqma tirááye: “mipíké kerátá kanaaráq nayúye.” téta tirááye. ");
INSERT INTO usa_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","ánibo Îtuma kaayaq-nákámá timá yímikaiye: “áraine. kenákámá ketí káápubike aíqa í-yátááqá nayóye. miráimanibo náawaq kanaaráq ketimakaq mániyo? maamin-áímmá kennámá íma wáiye. ímiye. min-ábíqtátámá yaímma-wayukayaba ketibomá Áánûqtuma yokaa umáyíkaraiye.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","iyápó-annabike tiyááka-wayukama min-áímmá ítátuweta kaayaq-wátámá Yêmitiyaa Yóáanema yiwáágúraae. ");
INSERT INTO usa_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","ánibo Îtuma iyápó-annama máqtemma yááyarena timá yímikaiye: “keráwáqá káonaawata waayúkati kíni-kayukama yemmá mamá márúte yuwéta anómma máeta kéyabiqyikaae. ánibo yemá anó-kayukama akoqnáá umá aarawaayábá yeqtáama itaígáae kéte. ");
INSERT INTO usa_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","miráimanibo mirán-ááímmá keráwápimmá íma waíno. ímiye. keráwáqtí aúkáapike móra-nakoma anómma uyátá-maqma mánaae ténama wemá kanaaráq mayaí-nákáá umá máena keráwáqá tíwáqnaa íno. ");
INSERT INTO usa_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","móra-nakoma keráwáqtí áqnáabaq-naqa mánaae ténama wemá kanaaráq paá keráwáqtí kaqtó-nakaa umá maíno. ");
INSERT INTO usa_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","kemá Waayúkagoni Áráakoma móraiq kéune. kemmá waayúkama mamá tíwáqnaa ígáae téq íkukaune. ímiye. kemá yekáq mayaímá mayéq yíwáqnaa kéeq netuqyaa-káyúkámá ketúnapo yemmá meyánîq umá yauwéqma yiwiránáá kukáune.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","yemá Yérikoqa yuwéta kóuraae. ánibo taíbaq-wayukama Îtun anaaé wakááe. ");
INSERT INTO usa_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","kaayaqá yúramma karoparái-nakorata aanáwábaq máeta Îtuqtaba kéiye-aimma ítátuweta yenákámá ááyama tirááye: “umaataráána-nako, emá Tébitin-annabike-nako, kekárátámá arummá umátikaao.” téta tirááye. ");
INSERT INTO usa_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","ánibo aarawaamá ‘páátí máákao’ téta tirááe. miráimanibo yenákámá uyátá-maqma anókaq ááyama tirááye: “umaataráána-nako, Tébitin-annabike-nako, kekárátá arummá umátikaao.” téta tirááye. ");
INSERT INTO usa_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","ánibo Îtuma mikáq kepágurena min-nákámá yááyama tiráiye: “kenákámá nôraq umátikaikaae téka kéteyo?” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","ánibo min-nákórátá Îtumma timá ámikaaye: “umaataráána-nako, emá kerátáí túramma mamá kabári-tikaikaae téka kétuye.” téta tirááye. ");
INSERT INTO usa_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","ánibo Îtuma min-nákámá arummá umáyikena min-nákátí yúrapi ayáánapo yínékuitana é mikáq yúramma aónaraaye. miráitata yenákámá Îtun anaaé waqméta urááye. ");
INSERT INTO usa_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","yemá Yérútáárebaq waaqókáq iréta Béqtápégibaq yayátuweta Óríbêti-anuraq irááe. miráitana Îtuma wení iyápó-annabike kaayaqá timáyikena áqnáabaqa ");
INSERT INTO usa_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","timá yímikaiye: “kenákámá pááqya-marupaq uréka mikáq aónaakao. mikáqá mórama oótiraa-kamma áráakaraq ánnáma kú-yakaraae. miráinaka ánná ayútuweka awíqme ketôpaq yekao. ");
INSERT INTO usa_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","ánibo móra-nakoma kenákáyábá móra-aimmo tínakama maará-tima-amekao. ‘anó-nakoma maamin-oótíráákáqtábá kéiye.’ mirá tíyanama wemá páátákáá timínaka awíqma íyóye.” tena Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","mi-qtátááqá áraimma pááq imá naayóbáqá Áánûqtuni watáama Tékáráiyama amuné-nákómá anaaékaq pááq íniye téna maará-tiraine: ");
INSERT INTO usa_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“keráwáqá aarawaamá Yérútáárebaq áíkuyo-kayukama maará téra timá yíméro. aónaaro. keráwáqtí kínimma keráwáqtôpaq kéimanibo wemá kaayoné-ááímmá tarôq kéena oótiraa-kakoni ámûraaq máena kéiye. ótamma mayaí-ótíráá-kákóní áráakon ámûraaq máena kéiye.” téna tiráiniq uráiye. ");
INSERT INTO usa_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","maami kaayaq-íyápó-ánnábíké-nákórátámá Îtuma timá yímíniq áqnáabaq mó-ureta ");
INSERT INTO usa_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","yenákámá oótiraa-kamma anóakaraq áráakaraq awíqmeta iréta yeqtí kúberai-unamma ayúqma ámûraaq abákáraae. ánibo Îtuma min-ótíráá-kákóní ámûraaq uyáqtama máqe-uraiye. ");
INSERT INTO usa_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","netuqyaammá aarawaamá yeqtí kúberai-unamma ayúqma aapitáá wíqmaketa miráuma éwaoniq umá omáqá kémayeta yaímma-wayukama kóbé-tágóní amamá ánagaraq ayáama aapitáá wíqmakaae. ");
INSERT INTO usa_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","ánibo aarawaamá áqnáabaq o-káyúkágáráq anaaé o-káyúkágáráqá maará téta ááyama tirááe: “otáánaa, yauwéqmetaa tiwiraí-nákô, Tébitin áráako, Áánûqtuma íráqôniq umákaino. maan-nákómá uyátárai-nakoni áwîkaq kéiye. otáánaa yanaa uyátárai-naqiye.” téta tirááe. ");
INSERT INTO usa_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Îtuma Yérútáárebaq uyáberaitata mi-márúpáké-káyúkámá máqtemma iyánáaq umáreta anókaq tirááe: “maan-náqá náawabiyo?” téta tirááe. ");
INSERT INTO usa_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","ánibo aarawaamá aakaq uréire o-káyúkámá tirááe: “wemá Áánûqtuni amuné-náqá Îtue Náátárêtibaq Kááriribake-nare.” téta tirááe. ");
INSERT INTO usa_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Îtuma anó-monoq-naupaq uyábékena mi-káyúkámá meyánîq kéowana waqtukáiye. wemá móneqa makéta waerémáa-taaregaraq numamá makéta maraq máeta meyánîq émáan-abiqtatagaraq máqtepaq ayáú-tááyáú umá pípéban umátukaiye. ");
INSERT INTO usa_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Îtuma miráumatuwena timá yímikaiye: “Áánûqtuni watáa agamatán-áíkómá maará kétiye. ‘ketí naakóqtábámá nunamummá tí-náné tínóe.’ miráimanibo keráwáqá mamá moyá-káyúkátí aúpáq-márúkáá kéoe.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Îtuma anó-monoq-naupaq máitata yaímma-wayukama yúramma karopágitana yimúqtámmá akúgitata máe-kayukama wenôpaq yewana mamá atóbamayikaraiye. ");
INSERT INTO usa_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","miráimanibo uyátá-maqma anó-monoq-wayukagaraq ámáan-aimma yirááti-wayukagaraq yemá Îtuma anón-awaameq-yataariq immá káoneta anó-monoq-naupake iyápóma anókaq ááyama téta “otáánaa Tébitin áráakoe.” téta temmá ítátuweta íyaqa ítama táíq kéeta ");
INSERT INTO usa_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Îtumma timá ámikaae: “maamin-áímmô téta enáwîqa múte yaúyomma áraq kéitaano?” téta ítama aónaraae. ánibo Îtuma yemmá timá yímikaiye: “owé. kéitaune. keráwáqá maarán-áímmá Tébitima ibí naayóbáqá maará-tiraimma íyaq yoráútaao? ‘Áánûqtuo, emá pááqya-noiyapogaraq náákaqo máraiya-noiyapogaraq yeqtí yóyaupike ení áwîqa múte yaúma kánataae.’ téna ibí tiráine.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","ánibo Îtuma iyuwéna márûpaq yaúbarena mi-nókáámmá Béqtanibaq ko máqe-uraiye. ");
INSERT INTO usa_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","aabáyaanapimma nokáápaq yaúbatuwena Îtuma yauwéqma márûpaq itana áama yaráiye. ");
INSERT INTO usa_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","ánibo Îtuma móra píki-yama aakaq aónatuwena ááipaq uráiye. ánibo mórama naí-yátááqá arammá íaonaraiye. ímiye. áná-aatuqma wáqe-uraiye. mi-píkí-yágómmá maará-tima-amikaiye: “ókaraq arammá íma iyaao. áraimma ímiye.” titana páátákáá maami-píkí-yágómá aayá-kaguraiye. ");
INSERT INTO usa_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","iyápó-annama minnáma aónatuweta iyánáaq urááe. miráitata yemá tirááe: “nôraq itanawáq píki-yagoma páátákáá aayámmá kégagiyo?” téta tirááe. ");
INSERT INTO usa_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","ánibo Îtuma yauwéqma timá yímikaiye. kemá áraimma keráwáqá kétima-timune. keráwáqá tirummá timéq kaayaq-tíyáqá íma wáinanama kanaaráq keráwáqá kemá píki-yaraq únaikaa ínóe. keráwáqá mimórá maami-qtátáárîq íinoe. ímiye. keráwáqá téq maan-ánúgóqtábá ‘emá meqtátuwe únópí kumuwo’ tíyanama kanaaráq mirá-iniye. ");
INSERT INTO usa_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","ánibo keráwáqá tirummá ámíqma itáíq-itaiq kéeq nunamummá téq máqte-qtataaqa mayánáae tíya-qtataaqa paá mayánóe.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Îtuma yauwéqma anó-monoq-naupaq uréna aarawaamá yiráátiraiye. ánibo uyátá-maqma anó-monoq-wayukagaraq anó-kawaa-wayukagaraq Îtunopaq iréta tirááe: “emá nói-naapaanaq yokéyaq maami-máyáímá kémayaano? náawaq maami-náápáámmá ámikaiyo?” téta tirááe. ");
INSERT INTO usa_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","ánibo Îtuma yeqtáaraq yauwéqma maará-tiraiye: “kegáráqá kemá keráwákáq móra-yataaqtaba ítama aónanaa kéune. keráwáqá yauwéqma ketáaraqo tíyaqa kanaaráq keráwáqá kemá timá-timenune kemá nói-naapaanaq yokéraq maami-máyáímá kémayauno. ");
INSERT INTO usa_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","timá tíméro. Yóáanema nommá waayúkama péqyikaraimma náakakena mi-náápáámmá matáíyô?” mi-qtátááqá Áánûqtunopake-qtataarabi paá waayúkati minnáwabiyo?” téna tiráiye. yemá min-áímmá ítátuweta yeíyáá aamá maará-tiraae: “ketáá téqtaa minnâ Áánûqtunopake-qtataare tenanatáámá maará ténataa timá-timiniye. ‘nôraq itaráq keráwáqá wekáqá íma itáíq-itaiq kéo?’ téna tíniye.” téta tirááe. ");
INSERT INTO usa_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","ánibo ketáá téqtaa minnâ ‘paá waayúkagon-amiye.’ téqtaama aarawaatí yáaqa ikaténúnatae. minnáma yemá ‘Yóáaneqtaba Áánûqtuni amuné-náré.’ téta kéte.” téta tirááe. ");
INSERT INTO usa_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","miráitata yemá Îtun áaraq yauwéqma maará-tiraae: “ketáá íaonoraunatae.” téta tirááe. ánibo Îtuma yauwéqma timá yímikaiye: “kegáráqá íma timá-timenunama kemá nói-naapaanabi matokéq maami-máyáímá kémayaune.” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Îtuma tiráiye: “miráimanibo keráwáqá nóinae kéteo? móra-nakoma kaayaq-íyápómá yíkaraiye. ánibo min-nákómá áqnáabaq-iyapogonopaq uréna timá ámikaiye. ‘ketáaniko, íbêqa emá uré wááéni-yopi mayaímá ko mayaao.’ tiráiye. ");
INSERT INTO usa_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","ánibo min-íyápógómá yauwéqma tiráiye. ‘ítíkáiye.’ timátuwena anaaékaqa aúyánámmá waéqma itáá ena uráiye. ");
INSERT INTO usa_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","ánibo keqnáámmá yiboámá uréna móra-aanikokaqa mimórá-áímmá mó-tiraiye. ánibo min-íyápógómá yauwéqma tiráiye. ‘owé. ketiboó.’ mirá-timatuwena íuraiye. ");
INSERT INTO usa_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","min-íyápórátábíkémá náawaq yiboání aúyánámmá wakáíyô?” titata yemá “áqnáaekoe.” téta tirááe. ókaraq Îtuma timá yímikaiye: “kemá keráwáqá áraimma kétima-timune. táákiti-moneqo máyáa-kayukagaraq kumari-nóíníkáráq yirummá kéwaeraapoata keráwáqtí túbáqá áqnáabaq Áánûqtuma yabíkái-qtataaqa mayánóe. ");
INSERT INTO usa_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","minnâ Yóáane nommá peraí-náqá keráwákáq iréna arupú-amma má tiráátiraimanibo minnáyaba keráwáqá wenáama íma ítaraae. ááqibo táákiti-moneqa mayaí-wáyúkágáráq kumari-nóíníkáráq wenáama ítaraae. keráwáqá minnáma aónaraamanibo túyánámmá waéqma itáá eq wenáama íma ítaraae.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","káqomma waéqma itaí-áímmá Îtuma tiráiye: “ítáaro. móra waéqma itaí-áímmá tenúne. móra-nakoma wení anó-marama wáitana wááéni-yomma yoqmaréna kurumá umá ikúmakaiye. ánibo arunóbáqá wááéni-nomma kaí-táápékóní maiqá uqmaréna ayáqtááq-namma wení yókáq kawáá-ínámmá umákaiye. miráitana mi-tókóní aboámá wení yómmá yaímma-wayukati iyáápi maréna ‘kawáá oro.’ tiráiye. ánibo mirá-timatuwena móra-aukapaq marabaq ayáqtááq-amma kóuraiye. ");
INSERT INTO usa_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","anaaékaqa wááéni-yokoma ábû kaí-kánááráqá wení mayaí-wáyúkámá timá yíkáitata wááéni-yopima mayaímô máyáa-kayukayopaq urááe. wení wááéni-yopike yaímma mamá maraíyata mamé ígáae téna timá yíkáitata urááe. ");
INSERT INTO usa_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","mi-tókáqô mayaí máyáa-kayukama yiwíketa móra-naqa yáánápó ikaméta móra-naqa ikámówana púítata móra-waigomma óqtatannapo ikámma waréta urááe. ");
INSERT INTO usa_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","mi-tókóní aboámá óqa mayaí-wáyúkámá timáyíkáitata irááe. áqnáabaqa pááqya-kayukama timá yíkáitata iráábo íbêqa netuqyaakáá timá yíkáitata írááe. ánibo wááéni-yopima mayaí máyáa-kayukama keqnáámmá áqnáabaqo uráániq umá yíkaraae. ");
INSERT INTO usa_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","anaaékaqa mi-tókóní aboamá maará-tiraiye. ‘yemá kanaaráq ketí iyápógon áama itánóe.’ téna timátuwena wenáanikomma timákáitana mi-káyúkáyópáq uráiye. ");
INSERT INTO usa_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","miráimanibo wááéni-yokaq mayaímá máyáa-kayukama áanikomma aónatuweta yeíyáá maará-tiraae. ‘maan-nákómá wemá aboání máqte-qtataaqa mayániye. mayaíyataao. maamin-náqá ikámónanataa puínataa wení yómmá mayánúnatae.’ téta tirááe. ");
INSERT INTO usa_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","miráitata min-íyápómá yáqtoketa mi-tópíké márúte waqmá paábaq yukéta ikámówana pukáiye. ");
INSERT INTO usa_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","ánibo keráwáqá nóinaeq kéteo? anaaékaqa wááéni-yokoni aboámá iréna wááéni-yopimo mayaí máyáa-kayukabima nôraq má-umayikaniyo?” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","ánibo yemá timá ámikaae: “wemá mi-táí-wáyúkámá arááq yíkamma uqtátuwena wááéni-yomma mamá káqon-anna-wayukama yimínata kawáá uréta arammá ábûma kaíkánááráqá yemá ábûma kaínatama aanábógómmá yaímma mamá amínoe.” téta tirááe. ");
INSERT INTO usa_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","ánibo Îtuma timá yímikaiye: “keráwáqá naayóbáq Tébitima Áánûqtuni watáama agamatá-kánnáábí tirái-kannaama íyaq yoráúma ítaraao? maará-tiraine. ‘maamin-óqtámmá naammá í-máyáí-wáyúkámá paábaq matúwááma íbêqa naakóní áwáámoyakaqa anómma akoqnáá-oqtamma wáiye. uyátárai-nakoma maami-qtátááqá mamá pááq-umaraitataa ketáá aónáúnataama íráqôniq kéiye.’ téna agamatá-kánáábímmá kétiye. ");
INSERT INTO usa_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","miráitaq kemá keráwáqá kétima-timune. Áánûqtuma yabíkái-qtataaqa mi-kánáámá kánatagitana móra-anna-wayukama maami-kánááyábá íráqôn-aramma mamá pááq kéiya-kayukama yimíniye. ");
INSERT INTO usa_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","móra-nakoma min-óqtákóní ámûraaqo metaína-nakoma wemá yubámma púbúyaginiye. minnágoma móra-nakoni ámûraaqo kumína-waigoma min-nákómmá igárîq umá obamá aúqtuwaniye.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","uyátá-maqma anó-monoq-wayukagaraq Pérati-wayukagaraq Îtuma waéqma itaí-áímmá timmá ítáamma Îtuma yepí maqmá kétitataboata ítaraae. ");
INSERT INTO usa_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","yemá ítátuweta Îtumma yáqtoraneta ommánibo yemá aarawaatí yáaqa ikátaae. aarawaamá téta Îtuqtaba ‘Áánûqtuni amuné-náqíye’ tewataboata ikatîq urááe. ");
INSERT INTO usa_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Îtuma keqnáámmá waéqma itaí-áímmá tiráiye: ");
INSERT INTO usa_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Áánûqtuma yabíkái-qtataakoma miráuma móra-kinini áaikoraa uráiye. kínimma áanikoma aaramá mayánéna itana kínima anón-aawaqa yokaa uráiye. ");
INSERT INTO usa_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","naayóbáqá yaímma min-ááwákáqó yíno-kayukama timá yíkaraine. ánibo aáwaqa naí-kánááráqá kínima wení mayaí-wáyúkámá timáyíkáitata uréta naayóbáqô timáyíkarai-kayukama ko yááyama yiwiránéta iráámanibo mi-káyúkámá íyábá íma yíkaraiye. ");
INSERT INTO usa_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","keqnáámmá káqo-mayai-wayukama timáyíkátuwena tiráiye. ‘keráwáqá uréra kemá yááyarauna-wayukama maará téraq mó-tima-yimero. aáwaqa yokaa umátukaune. awai-púrúmáákáámmá kéikameq aínógaraqa naí-wámmá ikámakaune. ánibo máqte-qtataaqa yokaa umátukaune. keráwáqá aaramá iyakaí-ááwákáq yero.’ téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","ááqibo mayaí-wáyúkámá uréta min-áímmá mó-tima-yimemanibo mi-káyúkámá min-áíkáq itaíyábá yíbô kaitata wéyáwé umáguraae. móra-nakoma wení yópáq kóitana móra-waigoma wení mayaíráq kóuraiye. ");
INSERT INTO usa_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","yaímma-wayukama kínima timáyíkáitata o-máyáí-wáyúkámá yáqtoketa táíq kéumayiketa yíkamowata pukááe. ");
INSERT INTO usa_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","miráitana kínima wení ááiq-i-wayukama timáyíkáitata uréta mayaí-wáyúkámá yíkamma púyó-kayukama ko yíkamma ánatatukaae. miráumatuweta yeqtí márûqa iramá agamá kaútukaae. ");
INSERT INTO usa_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","miráitana kínima wení mayaí-wáyúkámá timá yímikaiye. ‘aaramá iyakaí-ááwáqá yokaa umákaunataamanibo waayúkama yááyauna-wayukama kanaaráq íuraapoata íyinoe. ");
INSERT INTO usa_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","miráinaq keráwáqá anón-akaq uréire kéera waayúkama yimónáíya-kayukama yááyama yiwíqmera aaramá iyakaí-ááwákáq yero.’ ");
INSERT INTO usa_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","téna kínima timátúwáitata mayaí-wáyúkámá máqten-apaq wéyáwé uréta aarawaamá yimónaa-kayukama táíq uráa-kayukagaraq íráqôniq uráa-kayukagaraq mamá yoruparááe. ánibo aaramá iyakaí-náúpáqá taíbaq-wayukama ya ógikaae. ");
INSERT INTO usa_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","aarawaamá maraq ya máewana kínima uténa yimónaraiye. móra-naqa aónaimma aaramá iyakaí-kánááráq íráqôn-unakaqtoma íumatokaitana aónaraiye. ");
INSERT INTO usa_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","ánibo kínima min-náqá timá ámikaiye. ‘ketí aanábó-nákô, nôraq itaawáq emá aaramá iyakaí-kánááráq-únákáqtôma íma umátore paá maan-náúpáqá utáánô?’ titana min-nákómá aamá ítiraiye. ");
INSERT INTO usa_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","miráitana kínima wení mayaí-wáyúkámá maará téna timá yímikaiye. ‘keráwáqá maamin-náqá yáqtoqma aíyayaakaq atáá-umatuwera máápaq márú iyaabótuwaiyana mibáq kumayuqnóbáq maíno. kumayuqnóbáq waayúkama wááqa kéyeta yíwáyaamma akégúnanoe.’ ");
INSERT INTO usa_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","ítáaro. Áánûqtuma máqte-kayukama kéyaayaimanibo wemá móra-mora-waigomma aónama awaaméqá kéumaraipoana wemá Áánûqtuma yabíkái-marupaqa uyáberaniye.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Pérati-wayukama aamá ko téite umá tirááe. “ketáámá nóin-ainaq tenanatááwáq Îtumma wenáagoma íarutainataawaq yáqtoranunataabiyo?” téta tirááe. ");
INSERT INTO usa_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","ánibo yemá yaímma yeqtí iyápó-annagaraq Érôtini waayúkagaraq timáyíkáawata Îtunopaq uréta tirááe: “yirááti-nako, emá áraimma téna-naqone. ketáámá káonaunatae. ánibo emá árain-aikake aarawaamá Áánûqtuni áaimma kéyiraatene. emá móra-nakoma mirá-maara uwo tináíqtábámá aúyánámmá íma kéitaane. ímiye. emá máqte-kayukama mimórá-áín áátuqma kétima-yimene. ");
INSERT INTO usa_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","miráinaa emá keqtáá timá-timiyo. emá nóine kéteno? kanaaráq táákiti-moneqa uyátá-maqma anó-nakoma Títaamma aménúnataabiyo?” téta tirááe. ");
INSERT INTO usa_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","miráimanibo Îtuma yeqtí táí-yaaimma aónatuwena tiráiye: “keráwáqá kaayaq-tóyáúkáráq-wáyúkáé. nôraq itaráq kemmá makáqma kaónaao? ");
INSERT INTO usa_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","keráwáqá mórama táákiti-moneqa tiráátero.” mirá titata yemá móra-moneqa mamá aráátiraae. ");
INSERT INTO usa_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","ánibo Îtuma yemmá ítama aónaraiye: “maami-mónékáqá amammá waéna áwîqa waéna uráimma minnâ náawanabiyo?” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","ánibo yemá tirááe: “Títaannae.” téta tirááe. ánibo Îtuma timá yímikaiye: “miráuma Títaannama kanaaráq Títaamma áméro. ánibo Áánûqtunnama Áánûqtumma áméro.” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","yemá min-áímmá ítátuweta iyánáaq urááe. ánibo yemá Îtumma ayuwéta kóuraae. ");
INSERT INTO usa_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","mi táoqa Táátûti-wayukama Îtunopaq irááe. yemá min-ánná-wáyúkámá téta pukáa-kayukama íma kéito-owe téwaone. yemá Táátûti-wayukama iréta Îtumma ítama aónaraae. ");
INSERT INTO usa_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","yemá maará-tiraae: “yirááti-nako, Móteti maará-tiraine. ‘móra-nakoma wení iyápóma íma marákéna pukínanama kanaaráq ábâkoma ánáakomma maténa iyápóma akaínana awaaóní anónnáma mániye.’ tiráimanibo ");
INSERT INTO usa_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","naayóbáqá abapaké kaayaq-wátánónáámá keqtáábí máqe-uraane. ánibo áqnáaekoma móra-inimma mamaré máqena pukuráimanibo mórama iyápóma íma marákáraiye. miráitana ábâkoma awaaóní ánáaqa mayákaraine. ");
INSERT INTO usa_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","ábâkoma móraiq umá iyápóma íma marákáraiye. miráuma pukitana káqomma yíbâkoma mayákareta puku-puku umá ánataguraae. ");
INSERT INTO usa_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","máqtemma miráumma puqmá ánatagoana anaaékaq min-íníkógáráq pukuráiye. ");
INSERT INTO usa_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","ánibo emá kétene pukáiya-kayukama itó-ino-kanaaraqa min-íníkómá abapaké kaayaq-wátánónáábímá náawani ánáaraq mániyo? emá aónaraane. máqtemma min-ínímmá matááne.” téta tirááe. ");
INSERT INTO usa_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","ánibo Îtuma yauwéqma yemmá timá-yimena tiráiye: “keráwáqá Áánûqtuni watáá agamatá-kánnáábímmá íyaq aónaraao? ánibo keráwáqá Áánûqtuni akoqnáágaraqa íyaq aónaraao? miráitaq keráwáqá yobonaabo-áímmá kéte. ");
INSERT INTO usa_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","pukáa-kayukama itó-i-kanaaraqa aaramá íma mayéta aaraukárîq í-wátáámá ítinoe. ímiye. yemá paá Áánûqtuni márûpake kaqtó-wayukaraa umá mánoe. ");
INSERT INTO usa_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","miráimanibo pukáapike itó-inon-aimma keráwáqá ítama aónanaae. maamin-áímmá Áánûqtuma naayóbáqá timá tímikaimma íyaq ítaraao? Áánûqtuma maará-tiraine. ");
INSERT INTO usa_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘naayóbáqá ibêkaraqa kemá Áabaraani Áánûqtue. wení áráaqa Ááítekima Yáakoboma kemá yeqtí Áánûqtumune.’ miráuma matúq-matuq umá mái-auwaraiqtaba pukáiya-kayukama yeqtí Áánûqtuma íma maíye. ímiye. wemá minnâ waayúkama pukáamanibo paá matúq-matuq umá yúwaraa-kayukati Áánûqtue.” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","aarawaamá min-áímmá ítátuweta Îtun áayaba iyánáaq urááe. ");
INSERT INTO usa_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","min-áíqtábámá Îtuma Táátûti-wayukati yóyauqa mamá aúyaqyikaraiye. ánibo yemá Pérati-wayukama minnâ itáá eta wenamakaq ya áíkutaae. ");
INSERT INTO usa_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","ánibo mi-káyúkátí aúkáapimma mórama ámáan-aimma ítarai-naqa máena Îtumma makáqma aónéna maará téna ítama aónaraiye: ");
INSERT INTO usa_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“yirááti-nako, nóin-amaan-aikowaq káqon-amaan-aimma uyátá-maqma anómma wáiyo?” téna ítama aónaraiye. ");
INSERT INTO usa_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","ánibo Îtuma timá ámikaiye: “uyátárai-naqtaba tikaíno. Áánûqtumma máqte-tugaraq máqten-aaikaraq máqte-tuyanakaraq áméro. ");
INSERT INTO usa_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","maamin-ámáán-áímmá minnâ uyátá-maqma anómma katekoé. ");
INSERT INTO usa_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","ánibo anaaékaq-amaan-aikoma móraiq uráiye. minnágoma mirá-uraiye. ‘kenamáárîq keráwáqtábá tíkáiniq umá móraiq umá móra náayubi keqtimakaq maíyayuyaba tikaínaq kaayoné umáyíkáaro.’ ");
INSERT INTO usa_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","maami-kááyáq-ámáán-áíkómá Mótetini ámáan-aikaraq Áánûqtuni amuné-wáyúkátí yáagaraqa yeqtí yáaimma ábokaa umá waíye.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","yemá Pérati-wayukama paá áíkumareta máawana Îtuma maará téna ítama yimónaraiye: ");
INSERT INTO usa_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Metáíyaqtabama keráwáqá nóine kéteo? wé náawani iyápó-annabikene kéteo?” titata ánibo yé timá ámikaae: “Tébitini iyápó-annabike-nakoe.” téta tirááe. ");
INSERT INTO usa_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","mikáké Îtuma timá yímikaiye: “kanaaráqîbo nôraq itanawáq Aokaq-Áágómá titana Tébitimma anaaékaq yínîn-nakoqtaba ‘uyátárai-nakoe’ tiráíyô naayóbáqá Tébiti maará-tiráine. ");
INSERT INTO usa_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘ketí uyátárai-nakomma uyátárai-nakoma maará téna timá ámikaiye. emá ketiyáánurapaq maraq márenaq anaaékaqa kemá ení namuro-wáyúkámá enaítauq aménáápáq yikánúne. téna tiráine. ");
INSERT INTO usa_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Tébitima wenamáárîq ‘uyátárai-nako’ tiráimanibo Tébitima naayóbáqá pukuráine. ánibo náaraq itanawáq wemá Tébitin-annabikema anaaékaq kanaaráq yíníyô?” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","móra-nakoma maamin-áíkáqá Îtumma íma timá ámikaiye. ánibo mi-kánááráqá yemá áaimma átáma Îtuni áaqa ikatéta anaaékaqa móra-aimma íma Îtukaqa ítama aónaraae. ");
INSERT INTO usa_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","anaaékaqa Îtuma aarawaagáráq wení iyápó-annagaraq watáama timá-yimena ");
INSERT INTO usa_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","maará-tiraiye: “aammá aúmatan-aimma yirááti-wayukagaraq Pérati-wayukagaraqa Mótetini ámáan-aimma ítaraa-kayukae. ");
INSERT INTO usa_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","miráitata máqten-aimma yemá timá tímémma keráwáqá ítama arutéraq anaaé waránómanibo yemá oníkaa íoro. yemá netuq-áímmá kétetamanibo yemá min-áímmá íma anaaé kéwaraae. ");
INSERT INTO usa_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","yeqtí watáarake yemá anón-ataanamma atáá-uma waayúkati yíbúkaq káqyiketamanibo yemá móra iyáamma ánékuqma waayúkama yíwáqnaa umá yiráátéta ummaa-yátááqá mayaíyábá íma kéitaae. ");
INSERT INTO usa_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","yemá máqte-qtataariq ommá minnâ waabá-káyúkámá timónaigaae téta mirá kéoe. waayúkama yeqtí íráqôn-aaimma aónaamma Áánûqtuni watáama agamatá-kánnáábíké yaímma-wataama agatuwéta yúwáayakaq káqtoraae. ayáqtááq-waqtoma marabí yuyu umá kéitoraae. ");
INSERT INTO usa_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","yemá omáq-óní aáwakoni-amakaq íráqô-kannaaraqa máiyaba kéyikaitata yirááti-naupaqa yenamáa aokaq-ábíqtátáráq máiyaba kéyikaiye. ");
INSERT INTO usa_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","waabá-káyúkátí aúkáapimma yeqtábá ‘anó-nako’ ‘yirááti-nako’ téta tíyábá ôriq umá kéyikaiye. ");
INSERT INTO usa_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","miráimanibo waayúkama keráwáqtábá ‘yirááti-nare’ ítero. ímiye. kímora-nakoma keráwáqtí tirááti-naqa maínaq keráwáqá paá ábâqawaaraa umá máero. Pérati-wayukama mirá kéoe. ");
INSERT INTO usa_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","ááqibo móra maa-márábíké anó-nakoqtaba ‘ketiboé’ ítero. ímiye. paá kímora-naqa Áánûqtuma keqtibobóana wení márûpaq máiye. ");
INSERT INTO usa_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","ánibo keráwáqtábámá ‘áqnáabaq-nare’ ítero. ímiye. keráwáqtí áqnáabaq-naqa kímora máimma Metáíya yauwéqmataa tiwiraí-náré. ");
INSERT INTO usa_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","miráimanibo keráwáqtí aúkáapike anó-nakoma paá keráwáqtí mayaí-náqá maíno. ");
INSERT INTO usa_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","móra-nakoma wení áwîqa múte yauwína-nakoma anaaékaqa wení áwîkoma pááqyamma wániye. ánibo móra-nakoma wení áwîqa mamé kumína-nakoma wemá anaaékaqa anón-awiqa mayániye. ");
INSERT INTO usa_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","keráwáqá ámáan-aaimma yirááti-wayukagaraq Pérati-wayukagaraq keráwáqá atéráaro! keráwáqá kaayaq-tóyáúkáráré. aarawaatí yóípimma Áánûqtuma yabíkái-qtataakomma oqtamá káuyaraae. keráwáqá kenamáárîq íma kémayaae. ánibo aarawaamá mayánéta kéomma minnâ keráwáqá íma iyúwááwata kémayaae. ");
INSERT INTO usa_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","keráwáqá ámáan-aimma yirááti-wayukagaraq Pérati-wayukagaraq keráwáqá atéráaro! keráwáqá kaayaq-tóyáúkáráré. ketoq-nóínítí naammá kémayeq waabá-káyúkátí yaákaqa keráwáqá ayáqtááq-nunamumma kéte. miráipoaq keráwáqá áraimma anómma táí-meyamma mayánóe. ");
INSERT INTO usa_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","keráwáqá ámáan-aimma yirááti-wayukagaraq Pérati-wayukama keráwáqá atéráaro! keráwáqá kaayaq-tóyáúkáréré. keráwáqá únópínábi paá-marabaqa uréire kéeq móra-naqa awíqma keráwáqtí iyápó-annama káurakaae. miráimanibo keráwáqá wemmá uyátá-maqma táí-aaipi mamá kákaae. min-nákómá keráwáqtí iyápó-annama aúkuraipoaqa wemmá keráwáqá mamá iramá káíq-kaiq inírábí-wí-náqá káurakaamma miráuma keráwákáá kéoe. ");
INSERT INTO usa_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","keráwáqá túramma karoparáitaq káqo-yuma aammá yiráátine kéo-kayukama atéráaro. keráwáqá árain-aimma timá akoqnáá kéomanibo íkewaraae. keráwáqá maará téq kéyiraate. miráráá umá móra-nakoma aokaq-nákóní áwîqa yéna yanaané téna akoqnáá íma immá ‘paátataaqiye’ kétemanibo móra-nakoma áwáárara kai-qtátááqá aokaq-náúpáqtábá téna yanaan-áímmá timá akoqnáá ínna-nakoma kanaaráq tiníq íno. ");
INSERT INTO usa_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","keráwáqá aíbôqnaaboq umá túramma karopágurai-kayukae. nói-qtataaraq uyátá-maqma anómma wáiyo? aokaq-náúpáké áwáárara kai-qtátáákóáq anó-monoq-naupaqa áwáárara kai-qtátááqá mamá aokarîq immá minnâ uyátá-maqma anónabiyo? ");
INSERT INTO usa_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","ánibo keráwáqá maará téq kéyiraate. móra-nakoma Áánûqtukaq amí-yátááqá amí-yáárégóní áwîqa yamá yanaané téna akoqnáá ínnama paátataare. miráimanibo amí-yátááqá amí-yááréráq wáinanama téna áwîqa yamá yanaa akoqnáá ínna-waigoma kanaaráq tínaiq íno. ");
INSERT INTO usa_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","keráwáqá túgaroqa mááe. nói-qtataaraq anómma wáiyo? Áánûqtukaq amí-yátááráq uyátá-maqma anómma wái amí-yááréráq aokaq-náúpáq wái-taaregoaq uyátá-maqma minnâ anónabiyo? ");
INSERT INTO usa_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","miráitana móra-nakoma Áánûqtukaq amí-yááréyábá yanaa áwîqa yamá akoqnáá éna áraine ténama wemá yaarerákáráq máqte-qtataaqa wái-qtataakaraq wenáama mamá akoqnáá kéiye. ");
INSERT INTO usa_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","ánibo móra-nakoma aokaq-nákóní áwîqa yanaa yamá áraine téna akoqnáá énama anó-monoq-nakaraq aanábómá Áánûqtutabagaraq wenáama timá akoqnáá kéiye. ");
INSERT INTO usa_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","ánibo móra-nakoma Áánûqtuni márûpare téna áwîqa yátuwena yanaané téna árain-aimma timá akoqnáá immá minnâ Áánûqtuni abíqtátágáráq min-náqá abíqtátáráqô mái-nakokaraq wenáama timá akoqnáá kéiye. keráwáqá túyánámmá kéite paátataare te-qtátáákómá minnâ akoqnáá-yataaqiye. ");
INSERT INTO usa_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","keráwáqá ámáan-aimma yirááti-wayukagaraq Pérati-wayukagaraq keráwáqá atéráaro! keráwáqá kaayaq-tóyáúkáráré. máqte-qtataaqa yópíkén-ááwáqá tiyáákabike yaímma móra-aukapaqa Áánûqtukaq kámemanibo keráwáqá anón-amaan-aimma máqtepaq yukáama miráuma uyátá-maqma anómma anó-kayukarakaraq pááqya-kayukarakaraq arupú-aain-aikaraq kaayoné-áíkáráq itáíq-itaiq umá arummá amí-áíkáráq íkéwaraae. maamin-ámáán-áímmá íma yuwaínópoaq máqten-amaan-aimma paá waraínoe. ");
INSERT INTO usa_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","keráwáqá túramma karoparáitaq káqo-yuma aammá yiráátineq kéoe. keráwáqá waatimmá nawíkaiyaba ítíkaitaq aáwapike kugétama kéyuwaamanibo pógoma keráwáqtí aáwapi uréire immá íkaonaae.” téna waéqma itaí-áípí tiráiye. ");
INSERT INTO usa_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","keráwáqá ámáan-aimma yirááti-wayukagaraq Pérati-wayukagaraq keráwáqá atéráaro! keráwáqá kaayaq-tóyáúkáráq-wáyúkáé. keráwáqá nommá naí-náwígónábi aáwaqa ikánai-taapekomma amegaa-áúráq tete oníkáá umá íráqôniq kéowata kétimonaamanibo keráwáqtí tirunóbáqá ááiqa í-yátáákáráq aúyababa umá mayaí-yátááqá keráwápímmá ógikaiye. ");
INSERT INTO usa_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","keráwáqá Pérati-wayukao, keráwáqá túramma karoparái-kayukae. áqnáabaq-yataaqa keráwáqtí tirunóbákémá miráuma nommá naí-náwíbíkékáá umá araatámma tete íyana amegaa-áúgógáráqá íráqôniq íno. ");
INSERT INTO usa_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","keráwáqá ámáan-aimma yirááti-wayukagaraq Pérati-wayukagaraq atéráaro! keráwáqá kaayaq-tóyáúkáráq-wáyúkámá mááe. keráwáqá miráuma pukáa-kayukati aúge-mararaakaa urái-kayukamoe. amegaa-áúráqá íráqôniq umá wáipoata waayúkama aónainobo arunóbáqá pukáa-kayukati iyáátákaraq kabiramá táwîgoniq i-qtátááqá ógikaiye. ");
INSERT INTO usa_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","keráwákáráqá móraiq urááe. waayúkama keráwáqtí amegaa-túráq káoneta keráwáqá arupú-wayukawaq máawaa kétemanibo keráwáqtí tirunóbáqá kaaqaari-tí-ááímmá waéna ámáan-aimma aratí-ááímmá ógikaiye. ");
INSERT INTO usa_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","keráwáqá ámáan-aimma yirááti-wayukagaraq Pérati-wayukagaraq atéráaro! keráwáqá kaayaq-tóyáúkáráq-wáyúkámá mááe. Áánûqtuni amuné-wáyúkámá naayóbáq pukáa-kayukayaba íráqô-mararaamma tarôq kéumayikeqa arupú-wayukati-mararaakaq íráqôniq umá wíráatima kéumayikaae. ");
INSERT INTO usa_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","ánibo keráwáqá maará kéte. ‘ketáámá naayóbáqá tináábútááma máqe uráá-kanaaraqo máqe uráunarakaa kanaaráq ketáámá íma yíwáqnaa onatatáá amuné-wáyúkámá yíkamma puínéta oné.’ téq ");
INSERT INTO usa_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","min-áímmô kétema minnâ keráwáqá keráwáqtí táaimma abarokáq umá kétema keráwáqá Áánûqtuni amuné-wáyúkámá yíkamma utaí-ánnábíké-káyúkámóe. ");
INSERT INTO usa_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","kanaaráq keráwáqtí tináábútááti yáaimma áaimma átáma paá miráuma ánataaro. ");
INSERT INTO usa_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","keráwáqá iraakabayaakáráq iraakabayaakóní áráakaware. Áánûqtuma ítama yainéna Tááqtaani-marupaq iramá káíq-kaiq in-áúkápáq yawááq umátikaniye. náaraq umáwaq péqmare kóiyana ítama yainaí-yátáákómá íma yáqtoraniyo? ímiye. keráwáqá íma péqmareq kóinoe. ");
INSERT INTO usa_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","miráinaq keráwáqá ítáaro. kemá Áánûqtuni amuné-wáyúkágáráq aamá ítaraa-kayukagaraq yirááti-wayukagaraq timáyíkáánata keráwáqtôpaq wínóe. yeqtí aúkáapikema yaímma-wayukama keráwáqá yíkamiyata képuiyaq yaímma-wayukama kaapaq-yátáq yíkamma kéiyikeq yaímma-wayukama keráwáqtí yirááti-naupaqa tebûqa yimínóe. ánibo mirágêq yemmá móra-marukake waqmá káqo-marupaq iyuwánóe. ");
INSERT INTO usa_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","miráinana arupú-wayukama maa-márábí máraiyata yíkamma pukáiya-kayukati anónnáma máqtemma minnâ keráwápí wániye. owé. arupú-naqa Éboma pukáikake yéqéna Tékáráíyama Berekáíyani áanikomma anó-monoq-naupaqa Áánûqtukaq amí-yáárégáráq waayúkama máirakaraq aúkáapi ikákaane. aúkáapi ikámówana pukáimma mi-wágóní anónnáma keráwápí aráápama wániye. ");
INSERT INTO usa_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","kemá keráwáqá áraimma kétima-timune. máqtemma mi-wágóní anónnáma maannáma íbêqo máa-kayukama táí-meyamma mayánóe. ");
INSERT INTO usa_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","keráwáqá Yérútáárebaq-wayukao. keráwáqá Áánûqtuni amuné-wáyúkámá yíkamma kébuyeq keráwáqtôpaq Áánûqtuma mayaí-wáyúkámá timáyíkái-kayukama óqtatanapo kéyikamoe. netuqyaa-kánáámá keráwáqá mamá kokórigoma áráákawaqa aáyanobataa áíkuinikaa umá áíkutikanaae téq túnnamanibo keráwáqá minnáyaba íma kétikaiye. ");
INSERT INTO usa_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","keráwáqá ítáaro. íbêqa keráwáqtí márûqa yuwéq paábaq kóíyana paá-maruqa wániye. ");
INSERT INTO usa_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","owé. kemá maará téq keráwáqá kétima-timune. keráwáqá ókaraq kemmá ítimoneq anaaékaqa maará tínoe. ‘maan-náqá uyátárai-nakoni áwîkaq i-náqá Áánûqtuo, wemmá íráqôniq umákaao. téq tínoe. mi táoqa ókaraq kemmá timónanoe.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Îtuma anó-monoq-naupake yuwéna kóitata wení iyápó-annama wenôpaq irááe. yemá Îtumma yaímma anó-monoq-namma aráátineta uráámanibo ");
INSERT INTO usa_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Îtuma yauwéqma timá-yimena tiráiye: “keráwáqá maami-máqté-qtátááqá aónaraao? kemá áraimma keráwáqá kétima-timune. yemá káqomma móra-oqtamma íma yuwaíyana maan-óqtákóní ámûraaqa káqon-oqtamma wániye. namuro-wáyúkámá maamin-óqtámmá máqtepaq yubámma paábaq yuwánóe.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Óríbêti-anuraq máitata wení iyápó-annama yenamáa Îtunopaq iréta tirááe: “emá keqtáá timá-timiyo. min-óqtámmá paábaq yubámma yuwánô-kanaama nói-kanaararaq mi-qtátááqá pááq íníyô? nóin-awaameraq áqnáabaqa pááq ínataa ketáá káonetaa emá yauwéqma kéguminana maa-márámá ánatanena kéiye tenúnataabiyo?” téta wení iyápó-annama tirááe. ");
INSERT INTO usa_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Îtuma yauwéqma yemmá timá-yimena tiráiye: “keráwáqá atéráaro. móra-nakoma keráwáqá kaaqaari-áímmá timá-timena makatínéna íniye. ");
INSERT INTO usa_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","netuqyaa-káyúkámá iréta ketíwîkaq iréta maará tínoe. ‘kemá Metáíyama yauwéqma yiwiraí-náqúne’ kéteta aarawaamá kaaqaari-áímmá timá-yimeta yemmá makatínoe. ");
INSERT INTO usa_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","ánibo keráwáqá ááiqa éta aamá karaíyamma itéq ááiqa kéiyaq uwáá-aimma itánóe. keráwáqá atéráaro! minnáyabama íma iyánáaqa oro. mirá-qtátááqá pááq ínimanibo aqtó-kánáámá íma wániye. ");
INSERT INTO usa_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","móra-anna-wayukama káqon-anna-wayukama ááiqa umáyikanoe. miráiyata móra-kinini waayúkama móra-kinini waayúkate ááiqa ínóe. yaímma-aukapaqa waayúkama anómma yáayaba kéiyata anómma márúma yorániye. ");
INSERT INTO usa_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","mi-maqté-qtátáákómá miráuma aaragómá iyápó marakánéna itana áqnáabaq aíqa iníkáá íniye. ");
INSERT INTO usa_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","mi-kánááráqá kéráwáqá tíq í-yátááqá timéta ummaa-yátááqá timéta tíkamma utánóe. miráiyata ketíwîqa keráwápí wáipoata máqtemma aarawaamá ítama táíq umátikainoe. minnâ ketíwîqa keráwápí wáipoata mirá-inoe. ");
INSERT INTO usa_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","ánibo mi-kánááráqá netuqyaa-káyúkámá itáíq-itaiq umá arummá amí-yátááqá yuwéta yíbâqawaamma mamá namuro-wáyúkátí iyáápi maréta yegáráqá namuroîq umáyiketa ítama táíq umáyikanoe. ");
INSERT INTO usa_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","ánibo kaaqaari-ámúné-wáyúkámá netuqyaa pááq uréta taígani-kayukama makatínoe. ");
INSERT INTO usa_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","táí-aaikoma anómma pááq kéinata taíbaq-wayukama kaayoné-yátááqá yuqmá ánatanoe. ");
INSERT INTO usa_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","miráimanibo móra-nakoma akoqnáá umá máqena aqtó-kánááráq kekáq aúyánámmá iténa kémainana wemmá Áánûqtuma yauwéqma awirániye. ");
INSERT INTO usa_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","máqte-marabaqa Áánûqtuma yabíkái-qtataakoni aúgemma átê-wataama abarokáq timáeta wéyáwé umátuwaiyata máqten-anna-wayukama kéitaiyana mi táoqa aqtó-kánáámá pááq íniye. ");
INSERT INTO usa_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","ánibo anómma táíq í-yátááqá aokaq-márúkáq itó-urainaq aónainomma naayóbáqá Áánûqtuni amuné-náqá Táánioma tirái-qtataaqa áraimma pááq íniye. náawabi maamin-áímmá yorauténama wemá aúyánámmá ítama arutaíno. ");
INSERT INTO usa_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","maami-kánááráqá aarawaamá Yúríabaq máraiya-kayukama péqmareta anubaq kóoro. ");
INSERT INTO usa_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","ánibo móra-nakoma márûkaq yaúbama máqe-ina-waigoma óqa íma wení naaúpaq uyábékena táítawaa-yataaqa mayaíno. ");
INSERT INTO usa_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","ánibo móra-nakoma yópáq máqe-ina-nakoma íma yauwéqma uténa wení kúberai-unamma mayaíno. ");
INSERT INTO usa_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","mi-kánááráqá yímûkaraq-noinimma iyápóma náámma kéyime-noinikaraqa tirunô. ");
INSERT INTO usa_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","keráwáqá mi-kánááráqá nunamummá téqa yaugi-kánáárárábi Tabaatiráqá táaqa kaínaq íma pékinoe. ");
INSERT INTO usa_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","mi-kánááráqá uyátá-maqma anómma ummaa-yátááqá pááq íniye. naayóbáqá aúge-marama pááq-uraikaqa yéqéna íbêkaraq mirán-úmmáá-yátááqá íma pááq uráine. ánibo anaaékakaraqa mirán-úmmáá-yátááqá móragaraq íma wániye. ");
INSERT INTO usa_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Áánûqtuma mi-kánáámá íma mamá awaararîq ínatama máqtemma aarawaamá aúyokinoe. miráimanibo Áánûqtuma aarawaamá awaaméqá umáyíkárenaboana aúyánámmá ítaraiye. miráitana Áánûqtuma maami-kánáámá mamá awaararîq kéiye. ");
INSERT INTO usa_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","mi-kánááráqá móra-nakoma téna “aónaaro. Metáíyama yauwéqma tiwiraí-náqá maa maíye. merapaq máiye” tínaqa keráwáqá min-áímmá íma ítáaro. ");
INSERT INTO usa_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","ánibo yaímma kaaqaari-Métáíyágáráq kaagaari-ámúné-wáyúkámá itó éta anón-awaameq-yataaqa tarôq éta ókon-okomma mayaímá mayánóe. yemá mirá étama Áánûqtuma yiwíkai-kayukama wenôpake makatéta paábaq waqmá tiyuwánoe. ");
INSERT INTO usa_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","ítáaro. maaminnáma pááq ínîqtaba keráwáqá timá tímikaune. ");
INSERT INTO usa_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","miráinata yemá téta “aónaaro. Metáíyama waayúka íma máa-kaqmaapaq máiye.” tíyaqa keráwáqá min-áúkápáqá íoro. ánibo yemá téta “aónaaro. wemá maabáq aúpáq máiye.” tíyaqa yeqtáama íma ítáaro. ");
INSERT INTO usa_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","aabayákáq aabáyuraa yoqména yáútínikaa umá páátákáá kemá Waayúkagon Áráaqa kumónúne. ");
INSERT INTO usa_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","pukáa-kayukati arááq-yuma wáipaqa akikígómá ya áíkuiniye. ");
INSERT INTO usa_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","mi-kánáágóní ummaa-yátááqá ánataginana páátákáá aabaúgoma mamá kumayuqá káurainana wíyomma wíyokoma íma kamá kétagainana aabayákákémá yaímma wiyóqá yaráqmena kumínatama tébakaq aabayákáqá wáiya-qtataakoma yaráqma pípéban umáginoe. ");
INSERT INTO usa_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","mi-kánááráqá Waayúkagon Áráakoni awaaméqá aabayákáq pááq kéinana maa-márábín-ánná-wáyúkámá yáaqa kégainata ibiqá kéyareta waayúkagoni Áráaqa Áánûqtunopake konnákóní ámûraaq kéguminata aónainomma akoqnáágaraq tágama-yataakaraq kumíniye. ");
INSERT INTO usa_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","ánibo weróq-anabike anókaq yúgayaiyana anómma áama anó-kaapaukaa kétinata wení kaqtó-wayukama Áánûqtunopake timáyikainata wetábá awaaméqá umáyíkaraina-wayukama mamá áíkuinoe. ánibo yemá máqte-maragoni aqtóbáké yiwiránóe. ");
INSERT INTO usa_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","keráwáqá píki arakaráq-yáráq aónaaro. amagómá anommá wáitana aúgen-anama kéyaitaq keráwáqá káonaae íbêqa íráqôn-abayaqa téna aaqá kánéna kéiye. ");
INSERT INTO usa_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","miráraa umá anaaékaqa máqte-qtataaqa pááq ínimma keráwáqá mikáq aónainoe. áaimma átama Waayúkagoni Áráaqa kumínî-kanaagoma waaqókáq wáiye. ");
INSERT INTO usa_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","keráwáqá kemá áraimma kétima-timune. maamin-ánnámá íma pukáiyana maami-máqté-qtátááqá pááq íniye. ");
INSERT INTO usa_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","aabaya-márúkáráq maragáráqá ánatanimanibo ketáama íma ánataniye.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Îtuma óq-aimma tiráiye: “móra-nakoma mi-kánááyábámá íma kéitaiye. Áánûqtuni márûpake kaqtó-wayukagaraqa Áánûqtuni áanikogaraq íma kéitaae. aboámá Áánûqtu wenamáa minnáyabama kéitaiye. ");
INSERT INTO usa_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","naayóbáqá Nóaani kanaaráqá táí-aaimma tarôq uráamma móraiq umá mirán-ááímmá Waayúkagon Áráaqa yauwéqma kumínî-kanaaraqa tarôq ínoe. ");
INSERT INTO usa_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","naayóbáqá anó-nomma íautaikaqa yemá anón-aawaqa néta aíbôq-nomma néta aaramá mayéta aaraukárîq í-wátáámá téta miráuqte kéuyowana Nóaama wení únópí-káárébí uyábékaiye. ");
INSERT INTO usa_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","yemá minnáyaba yúyánámmá íma itéta paá miráuma máawana anó-nomma auténa máqtemma aarawaamá yawááq-umatukaiye. Waayúkagon-Araaqa yauwéqma kumínî-kanaaraqa mirá-inoe. ");
INSERT INTO usa_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","mi-kánáaráqá kaayaq-nákámá yópí máqe-iya-nakoratama Áánûqtuma móra-naqa awiréna móra-naqa ayuwániye. ");
INSERT INTO usa_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","móraiq umá kaayaq-íníkórátá yammá anémáíyapikema Áánûqtuma móra-inimma káwirena móra-inimma mikáq ayuwániye. ");
INSERT INTO usa_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","miráinaq keráwáqá atéráaro! keráwáqtí anómma uyátárai-naqa kumínî-kanaama íma kéitaae. ");
INSERT INTO usa_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","keráwáqá maamináyaba túyánámmá ítáaro. naakóní aanábó-nákómá itáinama moyá-náqá nói-kanaararabi yíné ínanama wemá íma aúma waínímanibo wemá paá itó-uma máena wení naakáqá yabíqtuwena mániye. ");
INSERT INTO usa_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Waayúkagoni Áráaqa móra-kanaaraq íma kumíniye tíya-kanaaraqa kumíniye. miráinaq keráwákáráq yokaa oro. ");
INSERT INTO usa_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","móra-mayai-nakoma íráqón-auyanamma wáitana wení mayaíráqá yabíqma kárutaitanaboana anó-kawaa-nakoma min-nákóqtábá wení yaímma mayaí-wáyúkágáráq yabíkéna wení kanaaráq aáwaqa yimíkáae tíniye. ");
INSERT INTO usa_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","anaaékaqa wení anón-nakoma yauwéqma iréna min-náqá aónáínama naayóbáqô timá ámikainaiqo énama kanaaráq mi-máyáí-nákómá amuqá ôriq umá maráiniye. ");
INSERT INTO usa_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","kemá keráwáqá áraimma kétima-timune. mi-máyáí-nákómmá wení anón-nakoma téna “emá ketí máqte-qtataakaq anómma yabíqma mááo.” téna timákaniye. ");
INSERT INTO usa_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","miráimanibo mi-táí-máyáí-nákómá wení áyaqnobaqa téna ‘ketí anón-nakoma páátákáá yauweréna íyiniye.’ kétena ");
INSERT INTO usa_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","wení móra-mayai-wayukama áaimma átáma kéyikamena anón-aawaqa kénena aíbôq-nomma naa-káyúkátê aíbôq-nomma kénena neginaagí kéena ");
INSERT INTO usa_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","mi-máyáí-nákómá wení anón-nakoma yíniye téna aúyánámmá íma ítáina-kanaaraq yíniye. ");
INSERT INTO usa_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","miráitana mi-máyáí-nákóní anón-naqa iréna min-nákómmá mamá táíq umá kátuwena mamá kaayaq-yóyáúkáráq-wáyúkátê táí-meyamma mayániye. miráitana wemá min-áúkápáqá máena wááqa yéna áwayaamma akégúnaniye.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Îtuma óqa waéqma itaí-áímmá tiráiye: “maami-kánááráqá Áánûqtuma yabíkái-qtataakoma kumína-kanaama miráuma tiyáákaa-noinaaruraa uráiye. móra-naqa íbêqa aaramá máyái-nakoma yínéna miráitata min-nóínáárúmá yeqtí-ómmá kúraqme uréta aapaké min-náqá ko awíqme yínéta urááe. ");
INSERT INTO usa_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","ánibo móra-tiyaapaq-noinaaruma aíbôqnaaboq owata móra-tiyaapaq-noinaaruma áá itéta yúyánámmá íráqôniq umá ítaraae. ");
INSERT INTO usa_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","aíbôqnaaboq o-nóínáárúmá ómmá kúrarai-yataaqa mamé yemánibo matawé-nokaraq íma maméta irááe. ");
INSERT INTO usa_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","miráimanibo yúyánámmô ítáa-noinaaruma yemá yeqtí áráamubima matawé-nokaraq aqtíma matoréta irááe. ");
INSERT INTO usa_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","minnámo aaramá máyái-naqa paátákáámá íma itana máqte-noinaaruti yúrakoma yúgábaaq itata yúmá wagurááe. ");
INSERT INTO usa_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","nokáán-aukaama móra-nakoma ááyama tiráiye. ‘aaramô mayaí-náqá áqa iyé. ánibo keráwáqá aapaké ko awíqmera yero.’ téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","min-nóínáárúmá máqtepaq itó-ureta yeqtí ómmá mamá yokaa urááe. ");
INSERT INTO usa_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","ánibo yemá aíbôqnaaboq o-nóínáárúmá aa ítaraa-noinaaruma timá yímikaae. ‘keráwáqá matawé-nomma yaímma tíméro. ketááí ókómá putíkinena kéiye’. téta tirááe. ");
INSERT INTO usa_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","ánibo aa ítaraa-noinaaruma yauwéqma timá yímikaae. ‘ímiye. maami-mátáwé-nókómá keqtáágáráq keráwákáráqá íma umaatátikaniqtaae. keráwáqá kanaaráq títúwaapaq uréra meyánîq oro.’ téta tirááe. ");
INSERT INTO usa_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","ánibo min-nóínáárúmá títúwaapake meyánîq ínéta kóuraawana aaramô máyái-naqa iráiye. miráitata yokaa umáreta máqeo-noinaaruma min-nákógáráq anón-aawaqo yokaa umáráa-naupaq uyábékuraae. miráowana oqtagómá aúyakuraiye. ");
INSERT INTO usa_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","anaaékaqa tébakaq-noinaaruma iréta tirááe. ‘uyátárai-nako, uyátárai-nako, emá keqtáá oqtamá ítikaao.’ téta tirááe. ");
INSERT INTO usa_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","miráitana uyátárai-nakoma tiráiye. ‘kemá keráwáqá áraimma kétima-timune. kemá keráwáqá ítimonaraune.’ téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","miráinaq keráwáqá atéráaro! nói-kanaawabi nóin-aabaurarabiyo keráwáqá íma kéitaae.” téna Îtuma waéqma itaí-áípí tiráiye. ");
INSERT INTO usa_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","káqomma waéqma itaí-áímmá Îtuma tiráiye: “móra-nakoma óq-aukapaq ayáqtááq-amma wínéna iníkáá kéena miráitana min-nákómá wení mayaí-wáyúkámá yááyarena wení máqte-qtataaqa iyáápi makáiye. ");
INSERT INTO usa_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","min-nákómá móra-mora-mayai-wayukati yáainaa akoqnááma aónawaaena wení móneqa yáátáá umá yímikaiye. ánibo móra-waigomma miráuma netuqyaa-mónéqá (5,000) aména móra-waigomma miráuma netuqyaa-mónéqá (2,000) aména móra-waigomma miráuma netuqyaammá (1,000) aména uráiye. miráuma yímiqtuwena wemá kóuraiye. ");
INSERT INTO usa_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","miráumatuwena kóitatama netuqyaa-mónéqô (5,000) máyái-nakoma páátákáá uréna minnárake móneq-mayaima maténa amuq-yáúmá miráuma káqomma ámûraaq netuqyaa-mónéqá (5,000) matáiye. ");
INSERT INTO usa_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","ánibo móra-nakoma netuqyaa-mónéqô (2,000) máyái-nakoma wegáráq amuq-yáúmá miráuma mi-mónékáké mayaímá maténa káqomma netuqyaa-mónéqá amuq-yáúmá (2,000) ámûraaq matáiye. ");
INSERT INTO usa_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","miráitana móra-waigoma netuqyaa-mónéqá (1,000) matái-nakoma marabí maiqá mó-ukena wení anó-nakoni móneqa aúpáq utamákaraiye. ");
INSERT INTO usa_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","ayáqtáá-kanaama kóitana anaaékaqa mi-máyáí-nóíyápótí anó-naqa yauwéqma iráiye. miráitana wemá naayóbáqá móneqa yímikai-kayukate watáama timá arutánéna uráiye. ");
INSERT INTO usa_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","ánibo min-nákómá móneqa miráuma netuqyaa-mónéqá (5,000) matái-nakoma iréna wení móneqa (5,000) amuq-yáúgáráq (5,000) mamé iréna tiráiye. ‘uyátárai-nako, emá netuqyaa-mónéqá miráuma (5,000) tímikaanamiye. aónaao. íbêqa minnárake mayaímá matéq amuq-yáúmá káqomma 5,000 matáune.’ téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","wení anó-nakoma timá ámikaiye. ‘emá amúna-yataaqa yabíqma akoqnáá kée íráqô-mayai-naqa máane. maa pááqyaa-qtataakaraq yabíqma akoqnáá uráánaboaq kemá emmá anó-qtataaqtaba yabi íkáae téq kawáámá kémayamune. maabáq iyo. emá ení anó-nakote amuqá kémare iyo.’ téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","keqnáámmá káqo-nakoma netuqyaa-mónéqá (2,000) matái-nakogaraq iréna tiráiye. ‘uyátáráana-nako, emá naayóbáqá netuqyaa-mónéqá (2,000) tímikaanae. aónaao. íbêqa minnárake móneq-mayaima matéq amuq-yáúmá káqomma 2,000 matáune.’ téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","ánibo wení anó-nakoma tiráiye. ‘emmá amúna-yataaqa yabíqma akoqnáá kée íráqô-mayai-naqa máane. maa pááqya-qtataakaraq yabíqma akoqnáá uráánaboaq kemá emmá anó-qtataaqtaba yabi íkáae téq kawáámá kémayamune. maabáq iyo. emá ení anó-nakote amuqá maqmé iyo.’ téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","ánibo móra-naqa netuqyaa-mónéqá (1,000) matái-nakoma wegáráq iréna maará-tiraiye. ‘uyátáráana-nako, kemá emmá aónaraune. iragayá-náqône. káqo-nakoma yómmá yoqmáráimma ábû kaí-kánááráqá kémayaane. ánibo káqo-nakoma móra-aukapaq-marabima ánáyumma uqmáráipikemma arammá kégutone. ");
INSERT INTO usa_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","miráitana kemmá táaqa kaitaq ení móneqa maranóbáq utamákaune. aónaao. ennámá maa waíbo mayaao.’ téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","miráimanibo wení anó-nakoma maará téna timá ámikaiye. ‘emá táí-mayai-naqone. emá ayáátámma íguyona-naqone. áraimma timónaraane káqo-wama yómmá yoqmáráipike aáwaqa kémayeq káqo-nakoma móra-aukapaq-marabi ánáyumma yuqmáráipike arammá kégutune. mirá kéuno?’ ");
INSERT INTO usa_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","kanaaráqíbo nôraq itaawáq ketí móneqa móneq-naupaq íma tíkaraano? miráitaq kemá yauwéqma iréq ketí mónekaraq yaímma amuq-yáúgáráqá matáune. ");
INSERT INTO usa_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","kanaaráq íbêqa keráwáqá maami-mónéqá 1,000 yabíma maan-nákómá móneqa 10,000 makái-nakomma áméro. ");
INSERT INTO usa_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","minnâ máqte-kayukama matokáiya-kayukama min-ámúrááq ókaraq yimínata mayánóe. miráimanibo móra-nakoma pááqya-qtataaqo matokáina-nakomma wenôpake yabímayaniye. ");
INSERT INTO usa_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","ánibo maami-táí-máyáí-náqá waqmá máápaq kumayuqnóbáq yúwáaro. miráinata min-áúkápáqá wááqa anómma yéta yíwayaamma akégúnainoe.’ téna anó-nakoma tiráiye.” téna Îtuma maami waéqma itaí-áípí tiráiye. ");
INSERT INTO usa_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","ókaraq Îtuma tiráiye: “anaaékaqa Waayúkagoni Áráaqa wení tágama-yataakaraq kínima máena kumínata máqtemma wení kaqtó-wayukagaraq Áánûqtunopake kumínómma mi-kánááráqá anón-akoqnaagaraq wemá yabíkáin-abiqtataraq mániye. ");
INSERT INTO usa_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","ánibo máqten-anna-wayukama aúbáq ya áíkuinoe. wemá yaímma kaayaq-ánnáíq umáyikena miráuma tipi-típi-kawaa-nakoma tipi-típima yaímma merapaq akéna mémema maabáq akéna iníkáá íniye. ");
INSERT INTO usa_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","wemá tipi-típi-annama áíqma ayáánurapaq yikéna méme-annama áíqma ayáánepaq yikániye. ");
INSERT INTO usa_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","miráinana Waayúkagoni Áráaqa anó-kinimma máena ayáánurapaqo maíya-kayukama maará téna timá-yiminiye. ‘yero. ketibommá ákái-kayukao, keráwáqti waaroqá ketibonôpake ya máyáaro. naayóbáqá maa-márámá aúgemma pááq kéitana ketibomá keráwáqtí márûqa tarôq umá yokaa umátíkátuwena keráwáqá aúyatikaraine. ");
INSERT INTO usa_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","naayóbáqá kemá táayaba kéunaq keráwáqá aáwaqa tímikaane. kemmá nonáá tíkáitaq nommá tímikaane. kemá káqo-marupake-napoaq keráwáqá tiwíqme keráwáqtí naaópaq urááne. ");
INSERT INTO usa_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","kemá wáqtôma íma itokáunaq wáqtôma tímikaane. kemmá karímá tíkáitaq mamá íráqôniq umátíkaraane. kemá ánná-naupaq máunaq ya timónaranne.’ ");
INSERT INTO usa_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","miráinata yemá arupú-wayukama maará téta Waayúkagon-Araakomma yauwéqma timá áminoe. ‘uyátáráana-nako, emá nói-kanaararaq ááyabama kéonataawaq aáwaqa ámikaunataabiyo?’ nói-kanaararaq nonáá ákáitataa nommá ámikaunataabiyo?’ ");
INSERT INTO usa_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","minnáyaba ítama aónainoe. ‘nói-kanaararaq ketáámá aónáunataama emá káqo-marupake-napoataa ketáámá awíqmetaa ketááí-naaupaqa iráunataabiyo? ánibo nói-kanaararaq ení wáqtôma íma itokáánataa ketáámá wáqtôma ámikaunataabiyo? ");
INSERT INTO usa_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","nói-kanaararaq ketáámá emmá aónáunataama emmá karímá ákarai ánná-naupaqa máanataa ketáámá ko aónaraunataabiyo?’ téta ítama aónainoe. ");
INSERT INTO usa_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","ánibo anó-kinima máena maara téna yemmá timá-yiminiye. ‘kemá keráwáqá áraimma kétima-timune. keráwáqá mórama ketinaaé wáráa-kayukabike márû mikákáá umá maína-nakomma mirá-umayikaraamma minnâ kemmá móraiq umátíkaraae.’ ");
INSERT INTO usa_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","miráinana mikáké wemá téna ayáánepaq maíya-kayukama timá-yiminiye. ‘ketôpake paábaq kóoro. Áánûqtuma keráwáqá yawááq-umatukaiye. keráwáqá yuwéraq iramá aati-aatimá káíq-kaiq inírábí oro. min-írámá ketibomá Áánûqtuma Tááqtaagaraq wení kaqtó-wayukagaraq yokaa umáyíkaraine. ");
INSERT INTO usa_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","naayóbáqá kemá táayaba kéunaqa aáwaqa íma tímikaane. kemmá nonáá kétikaitaq máunaqa nommá íma tímikaane. ");
INSERT INTO usa_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","kemá káqo-marupake-napoaq kemmá íma tiwíqme keráwáqtí naaúpaqa urááne. ketí wáqtôma íma wáitaqa keráwáqá kemmá wáqtôma íma tímikaane. kemmá karímá tíkáitaq ánná-naupaq máunaq keráwáqá íma ya timónaraane.’ ");
INSERT INTO usa_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","miráinata yegáráqá maará téta yauwéqma tínoe. ‘uyátáráana-nako, nói-kanaararaq ketáámá emmá aónáunaataa emá áayaba éabi nonáá ákáitaawabi emá káqo-marupake-narabi emá wáqtôma íma makéyabi emmá karímá ákáitaawabi emá ánná-naupaq máanataawaq ketááma emmá íma mamá íráqôniq umá káraunataabiyo?’ téta tínoe. ");
INSERT INTO usa_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","ánibo kínima yauwéqma maará téna timá-yiminiye. ‘kemá keráwáqá áraimma kétima-timune. keráwáqá móra ketinaaé wáráa-kayukabike márû mikákáá umá maína-nakomma miráuma yíkáiyaba íma yíwáqnaa ónúne tiráámma minnâ kemmá móraiq umátíkaraae.’ ");
INSERT INTO usa_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","miráinata min-ánná-wáyúkámá táí-meyamma ko mayánómma minnâ yíqa í-yátááqá watúq-watuq umá wánibo arupú-wayukama matúq-matuq umá mái-auwaraimma ummayéta aati-aatimá matúq-matuq umá mánoe.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Îtuma maami-máqtén-áímmá timá ánatatuwena mi-kánááráqá wení iyápó-annama maará téna timá yímikaiye: ");
INSERT INTO usa_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“kaayaq-kánáámá yáwínana kótámaki-aawaqa naí-kánáámá pááq íniye. maannâ kéitaae. ánibo yemá kemmá Waayúkagoni Áráaqa waayúkati iyáápi maraíyata kaapaq-yátáq tíkaminoe.” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","mi-kánááráqá uyátá-maqma anó-monoq-wayukagaraq Ítíráaeobake anó-kayukagaraq mú mikákáá anó-monoq-nakoni naaúpaq áíkutaamma min-nákóní áwîqa Kááyapatie. ");
INSERT INTO usa_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","ánibo yemá kaaqaari-áímmá téite umá wááyáímmá téta Îtumma aupaq yáqtoqma ikamínôn-aimma tirááe. ");
INSERT INTO usa_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","miráráá umá yemá tirááe: “ayúmá maqmá naíyan-onitaakaqa mirá-qtátáárîqa íonunataae. aarawaamá ááiq-yataaqa mamá pááq íyábae.” téta tirááe. ");
INSERT INTO usa_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Béqtanibaqa Tááímonima kárû-naqa wení karímá ánataguraitana wení naaúpaqa Îtuma máqe-uraiye. ");
INSERT INTO usa_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","ánibo móra-inikoma Îtunopaq iráimma mórama íráqôn-oqta-motorebima anó-moneq-awiqa yaan-áté-ákúq-mátáwémmá mamé iráiye. Îtuma yaareráq máitana min-íníkómá átê-kuyumma i-mátáwémmá Îtun aqnópí atíyakaraiye. ");
INSERT INTO usa_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","yemá iyápó-annama miráimma aónatuweta ítama táíq urááe. miráitata yemá maará-tiraae: “nôraq itanawáq maamin-ákúq-mátáwémmá áyókima kéiyo? ");
INSERT INTO usa_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","maamin-áté-ákúq-mátáwémmá waayúkama kéyimetaa anó-moneqa matétaa áwáyoq-wayukama nôraq itataa íkéyimunataabiyo?” téta tirááe. ");
INSERT INTO usa_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Îtuma yeqtáama ítarenaboana maará-tima-yimikaiye: “nôraq itaráq maan-íníkómmá ítama ummaamá kéyamakaao? wemá kemmá íráqô-qtataariq umátíkaraiye. ");
INSERT INTO usa_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","aati-aatimá áwáyoq-wayukama keráwáqtê mánomanibo kemá aati-aatimá keráwáqtê íma mánune. ");
INSERT INTO usa_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","maan-íníkómá átê-akuq-matawemma ke tineq aqtítikaimma wemá miráuma kemmá uqtamátikanokaqtaba yokaa kéumatikaiye. ");
INSERT INTO usa_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","kemá keráwáqá áraimma kétima-timune. máqten-aukapaq-marabaqa maamin-áté-wátáámá abarokáq timáeta wéyáwé kéete maamin-íníkómá maami-qtátáárîqo íqtábá yúyánámmá itánóe.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","mi-kánááráqá tiyááka umá abapaké kaayaq-íyápó-ánnábíké móra-waigoni áwîqa Yúqtaati Itikáárioti wemá uyátá-maqma anó-monoq-wayukayopaq uráiye. ");
INSERT INTO usa_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","ánibo wemá maará mó tiráiye: “keráwáqá nói-qtataaraq timínóqtabawaq kemá Îtumma awíqma keráwáqtí tiyáápimma maránúnô?” téna tiráiye. ánibo yemá móneqa miráuma kaumo-yátámá (30) ámikaae. ");
INSERT INTO usa_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","mi-kánááráké áaimma átárena móra-kanaaraqa Îtumma mamá namuro-wáyúkátí iyáápimmo maránîqtaba abáá-uraiye. ");
INSERT INTO usa_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","áqnáabaq-yupaama kótámaki-kanaaraqa yammá íma itoraí-ómákáqá iyápó-annama Îtunopaq iréta tirááe: “náakaraq mamá yokaa kéumakaanataawaq kótámaki-aawaqa naínónô?” téta tirááe. ");
INSERT INTO usa_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","ánibo Îtuma tiráiye: “keráwáqá anó-marupaq uyábékeraq móra-nakokaqa maará-tero. ‘yirááti-nakoma téna ketí kanaamá waaqókárîq kéiye. miráipoaq ketí iyápó-annate kótámaki-aawaqa ení-naaupaq nánáá kéune.’ tiyé téraq mó-tima-amero.” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","ánibo Îtuma tinîq umá iyápó-annama kótámaki-aawaqa yokaa urááe. ");
INSERT INTO usa_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","ánibo énaikaqa Îtuma wení tiyááka umá kaayaq-íyápó-ánnáté aáwaqa nai-yááréráq máqe-uraae. ");
INSERT INTO usa_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","yemá aáwaqa kéneta máawana Îtuma tiráiye: “kemá keráwáqá áraimma kétima-timune. keráwápíké móra-nakoma kemmá mamá namuro-wáyúkábí marániye.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","ánibo yemá netuq-yúyánámmá ítaraae. káqowa-kaqowama wenita-wenita éta Îtumma timá ámikaae: “uyátáráana-nako, keyábiyo?” kétimma “keyábiyo?” kétimma urááe. ");
INSERT INTO usa_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","miráimanibo Îtuma yauwéqma tiraíye: “min-nákómá aáwaq-taapepi ayáámma ketê ánékuina-naqa minnâ wemá kemmá mamá namuro-wáyúkátí iyáápi marániye. ");
INSERT INTO usa_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","owé. minnâ Waayúkagoni Áráaqa ‘puíniye’ téna Áánûqtuni agamatá-kánnáágómá tiráiniq íniye. miráimanibo min-nákómá wemmá mamá namuro-wáyúkátí iyáápi marání-nakoni táí-meyamma ôriq umá wániye. wemmá anóama íráqôniq umá íma marákáraitanaboana kemmá mamá namuro-wáyúkátí iyáápi maraínata tíkaminoe.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Yúqtaatima namuro-wáyúkátí iyáápi Îtumma maránín-nakoma maará-tiraiye: “yirááti-nako, keábiyo?” titana Îtuma tiráiye: “emá enamáárîq kétene.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","yemá aáwaqa kéneta máawana Îtuma yammá maténa Áánûqtukaq “tíkáiye” timátuwena mapámma iyápó-annama yímikaiye. ánibo wemá tiráiye: “keráwáqá mamá naaro. maaminnáma ketúmiye.” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","ánibo móra-nawibike wááéni-nomma maténa Áánûqtukaq “tíkáiye” timátuwena kéyimena tiráiye: “keráwáqá máqtemma maaminnâ naaro. ");
INSERT INTO usa_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","maannáma ketí naaebóaq timá akoqnáá ínoe. taíbaq aarawaatí kúmiqa mamá paá íkáae téq maami-nááémá aqtí énana kumíniye. ");
INSERT INTO usa_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","keráwáqá kemá kétima-timune. íbêkaraqa anaaékakaraq maa-márábímmá wááéni-nomma ínanune. ketibomá Áánûqtu yabíkái-marupaqa keráwákáráq móragaraq kegárátáá nommá nanúnataae.” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","yemá móra imá timátuweta yemá máápaq kumá yaúbareta Óríbêti-anubaq urááe. ");
INSERT INTO usa_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Îtuma wení iyápó-annamma timá yímikaiye: “keráwáqá ibêq-nokaamma kenamáa tiyuwéq peréqé wínóe. miráuma Áánûqtuni watáama agamatán-áíkómá téna ‘kemá tipi-típi-kawaa-naqa ikámónata tipi-típi áráakawaqa pípéban umáginoe’ mirá téna ágámátán-áíkómá kétiye. ");
INSERT INTO usa_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","miráimanibo kemmá pukáanabike keqnáámmá itó-umatikainaq Kááriri-marupaq keráwáqtí áqnáabaq ónúne.” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Pítaama yauwéqma tiráiye: “máqte-kayukama emmá ayuwéta kóíyaqa kemá emmá íayuwanune.” téna Pítaama tiráiye. ");
INSERT INTO usa_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Îtuma Pítaamma timá ámikaiye: “kemá áraimma kétimamune. íbêq-nokaamma kokórigoma áama íma tiráínaa emá kaumobáq ketíwîqtabama íaonaraune té wakaránóne.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Pítaama Îtumma timá ámikaiye: “kekáráq tíkaminomma enáwîqa íma aúpáq yuwánune. áraimma ímiye.” téna titata máqtemma wení iyápó-annama mimórá áín áátuqma tirááe. ");
INSERT INTO usa_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","mikáké Îtuma wení iyápó-annate Keqtêmanibaq urááe. mibáq wení iyápó-annama Îtuma timá yímikaiye: “keráwáqá maakáq yayááikaq maraq máiyaraq kemá mérápáq uréq nunamummá mó-teno.” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","ánibo Îtuma Pítaakaraq Yéberini kaayaq-íyápórátágáráq yiwíqmeta urááe. Îtumma mibáq áyakoma anómma ummaa kéyaitana áúnobaqa anón-ummaa yágitana ");
INSERT INTO usa_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","timá yímikaiye: “ketíyakoma anómma ummaa kéyagiye. miráuma kemá puyónúnaiq kéiye. keráwáqá maakáq máera kawáá urááiyaro.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","wemá pááqyamma abákáq uréna marabí aipaké aguréna nunamummá téna tiráiye: “ô ketiboó, emmá akaínaama kanaaráq káápuma tíqa ínímma paábaq matuwaao. miráimanibo kemmá tíkái-qtataaqa íma waraao. ímiye. emá enamáárîq enaúyánámmá waraao.” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","ánibo Îtuma wení iyápó-annayopaq yauwéqma iréna aónaimma yúmá wagurááe. wemá Pítaamma awáuturena timá ámikaiye: “nôraq íyô? keráwáqá keqtábá pááqya-kanaama kanaaráq íma yabíqma máéwaniraq kéoo? ");
INSERT INTO usa_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","keráwáqá yabíqma arútárera nunamummá tero. keráwáqá makáqma aónai-yataakoma keráwápí pááq íyábámíye. áraine. keráwáqtí aágoma keráwáqtábá kákaimanibo keráwáqtí túgoma akoqnááma íma wáitanaboana íkakaiye.” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Îtuma yauwéqma anaaékaqa uréna móragaraq nunamummá téna tiráiye: “ketiboó, maami-káápúgómá tú-tiqa íyábá ketôpake kanaaráq íma mamá tiyúwénana kóínaama emá enamáárîq ení áuyánámmá waraao.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","ánibo keqnáámmá yauwéqma yaónaimma yúmá waguréta máqe-uraae. yúrakoma íma kanaaráq karáqma aónaawaniq urááe. ");
INSERT INTO usa_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","ánibo Îtuma iyápó-annama iyuwéna keqnáámmá kaumobáq uréna nunamummá tiráiye. mi-núnámúmmá wágáabaqo tináíkáq keqnáámmá tiráiye. ");
INSERT INTO usa_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","anaaékaq wení iyápó-annayopaq iréna timá yímikaiye: “keráwáqá keqnáámmá waguréraq káágaao? aónaaro. kanaamá pááq-umaguraipoata kemmá Waayúkagoni Áráaqa mamá kúmiq-wayukati akoqnáábi maránóe. ");
INSERT INTO usa_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","keráwáqá itó íyataa kóono. aónaaro. kemmá mamá namuro-wáyúkátí iyáápimmo maránô-kayukama áqa irááe.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Îtuma aamá kétinakaraq Yúqtaatima tiyááka umá kaayaq-ánná-wáyúkábíké wemá iráiye. netuqyaa-káyúkámá tokóru-yakaa-puma mútûq-yamma maméta irááe. uyátá-maqma anó-monoq-wayukagaraq Îtíráaeo-anna-wayukati anó-kayukagaraq timáyíkáawata irááe. ");
INSERT INTO usa_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","ánibo min-nákómá Îtumma mamá namuro-wáyúkátí iyáápimmo maránín-nakoma móra awaaméq-áímmá téna tiráine: “kemá móra-naqa ámóqnaannama minnâ Îtue. keráwáqá wemmá yaqtóráaro.” téna Yúqtaatima timátuwena ");
INSERT INTO usa_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","máqtemma yagáikuyowana páátákáá Îtunopaq Yúqtaatima iréna tiráiye: “yirááti-nako, kaayoné-yátááqá etê waíno.” téna mirá-timatuwena Îtumma ámóqnaraiye. ");
INSERT INTO usa_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Îtuma timá ámikaiye: “ketí aanábógô, nôrabi ónáae ténaiqa páátákáá mirá uwo.” téna titata yemá waaqókáq iréta iyáámma ánékuqma Îtumma yáqtoqma akoqnáá urááe. ");
INSERT INTO usa_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","móra-naqa Îtute yagaroqtamá máqei-nakoma ayáámma yúwáitana kúmitana wení tokóru-yakaa-puma matáiye. mú mikákáá anó-monoq-nakoni kaqtó-nakomma ikámma aáqa yakátúwáitana marabí kuturáiye. ");
INSERT INTO usa_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","miráimanibo Îtuma min-náqá timá ámikaiye: “ení tokóru-yakaa-puma wení amáákaq maraao. máqte-kayukama tokóru-yakaa-punapo ááiqa íyamma káqo-kayukama tokóru-yakaa-punapo yemmá yíkamma puínoe. ");
INSERT INTO usa_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","aqá kemá ketibommá ááyaanana netuqyaammá kaqtó-wayukama Áánûqtunopake tiyááka umá kaayaq-ánnámá ááiq-i-wayukama uyátá-maqmagaraq timínímma minnáyaba páátákáá íyaq ítaraano? ");
INSERT INTO usa_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","miráimanibo kemá miráonanama Áánûqtuni agamatán-áíkómá náaraq umáwaq arammá iyáníyô? Áánûqtuni watáama agamatán-áíkómá maami-qtátááqá pááq íniqtaba kétiye.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","é mi táoqa Îtuma mi-káyúkámá timá yímikaiye: “keráwáqá kemmá moyá-nákáá umá ya kéyatoreq tokóru-yakaraq mútûq-yakaraq maméraq tibá umáeraq kéyeo? máqte-kanaaraqa kemá anó-monoq-naupaq máeq aarawaamá kéyiraatunaqa miráuma kemmá íma yáqtokaamiye. ");
INSERT INTO usa_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","miráimanibo Áánûqtuni amuné-wáyúkámá maami-máqté-qtátááqtábá Áánûqtuni agamatá-kánnáábí keqtábá agatáamma íbêqa pááq kéoe.” téna Îtuma tiráiye. ánibo máqtemma wení iyápó-annama Îtumma ayuwéta wéyáwé umáguraae. ");
INSERT INTO usa_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Îtumma yaqtóráa-kayukama wemmá awíqmeta mú mikákáá anó-monoq-naqa Kááyapatikaq wení naaúpaq urááe. ánibo ámáan-aimma yirááti-wayukagaraq anó-kayukagaraq mibáq áíkumareta máqe-uraae. ");
INSERT INTO usa_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Pítaama Îtumma anaaé waqména wimánibo wemá nékaq ko máqe-uraiye. mú mikákáá anó-monoq-nakoni naakóní kurunóbáq wemá uyábékena i-wáyúkáté máqe-urena mi-qtátááqô pááq immá aónanaae téna máqe-uraiye. ");
INSERT INTO usa_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","uyátá-maqma anó-monoq-wayukagaraq máqtemma káánítôre-wayukagaraq kaaqaari-áúbí maráiyata Îtumma ikámma puínôqtaba abáá-uraae. ");
INSERT INTO usa_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","netuqyaa-káyúkámá iréta Îtumma kaaqaari-áúbí má-makaamanibo yemá móra ikámma puínôn-aaimma íabaa-uraae. anaaékaq kaayaq-nakórátámá iréta ");
INSERT INTO usa_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","yenákámá maará-tiraaye: “maan-nákómá maará-tiraiye. ‘kemá kanaaráq Áánûqtuni anó-monoq-namma yawítítukeq kaumo-yúpáámá kóinaq keqnáámmá kanaaráq umá ánatanune.’ téna Îtuma tiráiye.” téta min-nákórátámá tirááye. ");
INSERT INTO usa_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","ánibo mú mikákáá anó-monoq-nakoma itó-urena Îtumma timá ámikaiye: “maamin-áímmá enaúbimo máráátabama nóine kéteno?” téna tiráimanibo ");
INSERT INTO usa_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Îtuma aamá ítiraiye. ánibo mú mikákáá anó-monoq-nakoma Îtumma móragaraq timá ámikaiye: “kemá emmá Áánûqtu matúq-matuq umá mái-Aanuqtun áwîkaq ítama káonaune. emá yauwéqma yiwiraí-náqá Metáíyama Áánûqtuni áanikowaq máanaa emá keqtáá timá-timiyo.” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Îtuma timá ámikaiye: “emá ténnama mi*** emíye. miráimanibo kemá keráwáqá kétima-timune. íbêkaraq anaaékakaraqa Waayúkagoni Áráaqa akoqnáá-Aanuqtuni amakaq máenaq keráwáqá aónainoe. ánibo wemá Áánûqtuni márûpake konnákáq máena kumíniye.” téna Îtuma yauwéqma tiráiye. ");
INSERT INTO usa_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","mirá-timatuwaitana mú mikákáá anó-monoq-nakoma áyámma ôriq umá itanabóana wenamáárîq wení wáqtôma yakáqnáákáq umátuwena tiráiye: “Áánûqtumma áyôqa káyaiye tiráiye. óqa káqo-kayukama íma yiwíráanatataa wení áayabama má-tinoe. ímiye. wemá Áánûqtumma áyôqa ayéna timá táíq umákáitaq keráwáqá íbêq kéitaae. ");
INSERT INTO usa_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","keráwáqá nói-tuyananaq kéitaao?” téna titata yemá tirááe: “wepímmá otaa-qtátááqá wáipoana paá puíkáae.” téta tirááe. ");
INSERT INTO usa_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","ánibo mikáké Îtuni óipi wiráátima kéwiraketa ikákaae. yaímma-wayukama Îtumma aápáaraq kéyeta ");
INSERT INTO usa_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","tirááe: “Metáíyao, amuné-áímmá keqtáá timá-timiyo. emmá náawaq kéikamiyo?” téta aábê-aimma tirááe. ");
INSERT INTO usa_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Pítaama máápaq máqe-uraimma wemá naakóní kurugóní arunóbáq máqe-uraimma mórama mayaí-ínímmá wenamakaq iréna tiráiye: “emá egáráq Îtuma Kááriribake-nakotema máqe-uraane.” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","miráimanibo Pítaama máqte-kayukati yúrakaq wakaréna maará-tiraiye: “keráwáqá mamin-áímmô temmá kemá íma ítaraune.” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","mirá-timatuwena oqtabí kumá yaúbama ko itó-uraiye. ánibo káqomma mayaí-íníkómá Pítaamma aónatuwena waaqókáqô máe-kayukama maará téna timá yímikaiye: “maan-nákómá Îtuma Náátárêtibake-nakote máqe-uraine.” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","keqnáámmá Pítaama wakaréna tiráiye: “áráinurane. Áánûqtuni aúrakaqiye. kemá maan-náqá íma aónaraune.” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","anaaékaqa pááqya-kanaama yaímma-wayukama waaqókáq itó-uma máe-kayukama Pítaamma maará téta má-tima-amikaae: “áraine. emá Kááriribake-naqone. emá aamá téna-waigoma emmá mamá abarokáq kákaiye.” téta tirááe. ");
INSERT INTO usa_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","ánibo íbêqa Pítaama aamá akoqnáá umá téna tiráiye: “árainurane. kaaqaari-áímmá kétenanama Áánûqtuma kemmá tíkaminiye. kemá maan-náqá íma aónaraune. áraimma ímiye.” téna timátúwáitana kokórigoma áama tiráiye. ");
INSERT INTO usa_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","ánibo Îtuma tiráiniq itana Pítaama yauwéqma aúyánámmá ítaraiye. Îtuma téna “kokórigoma áama íma tiráínaa keqtábá íaonaraune té kaumobáq tínóne.” téna tiráine. miráitana Pítaama máápaq yaúbarena ibiqá yakáiye. ");
INSERT INTO usa_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","aaqá irákitata máqtemma uyátá-maqma anó-monoq-wayukagaraq Ítíráaeobake anó-kayukagaraq Îtumma ikámma puínéta waayaímmá tirááe. ");
INSERT INTO usa_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","yemá Îtumma ánnáma atáá-umatuweta awíqmeta anó-kamaani-naqa Pááíratimma mó ámikaae. ");
INSERT INTO usa_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Yúqtaati wemmá mamá namuro-wáyúkátí iyáápimmo makái-nakoma Îtumma aónaimma yemá aamá timá uyáteta anón-ummaa-yataaqa mayámikaae. miráitana Yúqtaatima aúyánámmá waéqma itáá ena móneqa kaumo-yátámá maména uyátá-maqma anó-monoq-wayukagaraq anó-kayukayopaqa yauwéqma iráiye. ");
INSERT INTO usa_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","miráitana wemá tiráiye: “kemá kúmiq-yataariq uráune. mórama otaa-qtátááqá íma wái-naqa mamá keráwáqtí tiyáápi makáunaboana puíniye.” téna tiráiye. ánibo yemá tirááe: “minnâ ketáái otaammá íma wáiye. emá enamáa ení otaammíye.” téta tirááe. ");
INSERT INTO usa_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","ánibo Yúqtaatima mi-mónéqá anó-monoq-naupaq mó kéiyaabotuwena máápaq wenamáárîq ánnáma amáguraiye. ");
INSERT INTO usa_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","yemá uyátá-maqma anó-monoq-wayukama mi-mónéqá matéta tirááe: “maami-mónéqá waayúkama ikámma uqtaí-méyámíye. maami-mónéqá anó-monoq-naupake-monekaraqa mórabi íma maránúnatae. keráwáqtí aúmatan-aimma mirá kétiye.” téta tirááe. ");
INSERT INTO usa_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","ánibo yemá móra-aimma téite umátuweta mi-mónéqnápó tawemá tarôq í-nákóní maramá meyánîq urááe. káqo-mapake-kayukati máátíq-máatiq-marama tarôq umáyíkaraae. ");
INSERT INTO usa_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","miráitata min-áúkápáq-márágóní áwîqa “naae-máráé.” téta áwîqa yarááwata min-áwíqá íbêqa paá wáiye. ");
INSERT INTO usa_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","miráitana naayóbáqá Áánûqtuma amuné-náqá Yérémáíyani óyaukaq tiráimma áraimma pááq uráimma maará-tiraine. “yemá kaumo-tíyááká-mónéqá matááe. yemá Ítíráaeo-wayukama awaaméqá maréta maamin-náqá meyánîq í-méyáné tirááe. ");
INSERT INTO usa_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","ánibo maami-mónéqnápó tawemá tarôq í-nákóní maramá meyánîq urááe. miráuma uyátárai-nakoma timá tímikainiq ínóe.” téna Yérémáíyama tiráine. ");
INSERT INTO usa_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","yemá Îtumma mamá anó-kamaani-nakoni aúbáq itó-umakaraae. ánibo wemá Îtumma maará téna ítama aónaraiye: “emá Ítíráaeo-wayukati anó-kininaq máano?” titana Îtuma tiráiye: “emá ténnama minnâ emíye.” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Îtuma paá otaa-qtátáárîqa íurenaboana uyátá-maqma anó-monoq-wayukagaraq anó-kayukagaraq yeqtí yáaraqa Îtuma móra-aimma yauwéqma ítiraiye. ");
INSERT INTO usa_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","miráitana Pááíratima Îtumma timá ámikaiye: “aqá emá máqte-qtataaqtaba aamá timákaan-aimma íyaq ítaraano?” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","ánibo Îtuma Pááíratimma móra yauwéqma aamá íma timá ámitana anó-kamaani-nakoma iyánáaq uráiye. ");
INSERT INTO usa_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","máqte-karitimaatiraq ayú maqnaí-kánááráqá anó-kamaani-nakoma móra-mora-naqa ánná-naupake ayúbakewaine. aarawaamá yenamáárîq ‘min-náqá ayuwaao’ tewana Pááíratima minnámo te-náqá ayúwáitana wéwaine. ");
INSERT INTO usa_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","ánibo mi-kánááráqá mórama táí-naqa áwîqa Baráábatie ánná-naupaqa máqe-uraiye. ");
INSERT INTO usa_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","aarawaamá áíkuyowana Pááíratima timá yímikaiye: “kemá náawanaq ayúwáananawaq keráwáqtôpaqa wíkáae téraq keráwáqá kéteo? kemá Baráábatinaq ayuwánú Îtumma yauwéqma tiwirái-náré te-náráq ayuwánúnô?” téna ítama yimónaraiye. ");
INSERT INTO usa_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Pááíratima ítáimma yemá áyoqa káyetaboata Îtumma íyámma umáketa aabi mayákáraae. ");
INSERT INTO usa_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Pááíratima aamá ítama yainaí-ábíqtátáráq máitana ánáakoma maará téna aamá yúwáitana iráiye: “maamin-árúpú-nákómmá móra-yataariq íumakaao. nokáámma wekáq mórama kaimmá aónatuweq anómma ítama ummaa kéyaune.” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","yemá anó-monoq-wayukagaraq anó-kayukagaraq aarawaamá íyaqa timá utaéta Pááíratima ááyama tíyana “Baráábatimma ánnábike káyuweta Îtumma ikámma púyoro.” téta tirááe. ");
INSERT INTO usa_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","ánibo anó-kamaani-nakoma ókaraq maará-tiraiye: “maa-kááyaq-nákábíkémá náawanaq ayúwáananawaq keráwáqtôpaqa wíkáae kéteo?” téna ítama aónaitata yemá “Baráábatine.” tirááe. ");
INSERT INTO usa_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pááíratima timá yímikaiye: “miráinaqa Îtumma yauwéqma yiwiraí-náré ten-náqá kemá náaraq ónúnô?” titata máqte-kayukama téta: “ikámma kaapaq-yátáq íyakaao.” téta tirááe. ");
INSERT INTO usa_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","ánibo Pááíratima tiráiye: “nôraq inábiyo? wemá nóin-otaanaq kutáíyô?” titata yemá ókaraq ááyama tirááe: “kaapaq-yátáq ikámmá íyakaaro.” téta tirááe. ");
INSERT INTO usa_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pááíratima mikáq ítaraiye. wenáagoma íma kanaaráq itana anón-aaiqa ínéta urááe. miráitana máqte-kayukati yúrakaq nommá maténa ayáámma tete uráiye. miráumatuwena tiráiye: “kepímmá maan-náqá ikámma puí-ánónnámá íma wáiye. keráwáqtí minnáe.” téna Pááíratima tiráiye. ");
INSERT INTO usa_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","ánibo máqtemma aarawaamá yauwéqma tirááe: “mi-wágóní anónnáma keqtáábí yéna ketááí iyápóbi yíniye.” téta tirááe. ");
INSERT INTO usa_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","miráitana Pááíratima Baráábatimma ayúwáitana yeqtôpaq uráiye. ánibo wemá Îtumma tebûqa ámíqtuwena ááiq-i-wayukama ikámma kaapaq-yátáq íyakaigaae tena iyáápi yímikaiye. ");
INSERT INTO usa_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","anó-kamaani-nakoni ááiq-i-wayukama Îtumma awíqmeta kámááni-naupaq utéta min-ánná-ááíq-i-wáyúkámá máqtemma Îtun-amakaq yaikútaae. ");
INSERT INTO usa_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","ánibo yemá wení unáákáqtôma ayútuketa mórama karogaron-únákáqtómá umáketa “anó-kinine” teta awaaméqá umákaraae. ");
INSERT INTO usa_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","kínini náápaakaraq kámokaa umá mórama áwáábiq-annarake atoyumá kámoqa tarôq umátuweta aqnókáq kúberakaraae. ánibo kínini náápaakaraq yataraa umá yemá móra-yatama ayáánurapaq-ayaapi yorákaraae. ánibo yemá Îtun-amakaq yiraayutaúmmá ayéta akáyáámmá timáketa tirááe: “Ítíráaeo-wayukati kínio wení mái-auwaraimma ayáqtáákaq maíno.” téta aati-aatimá kíniqtaba téwaon-aimma tirááe. ");
INSERT INTO usa_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","ánibo yemá wiráátima kéwiraketa mi-tátámá yabíteta aqnókáq ikákaae. ");
INSERT INTO usa_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","ááiq-i-wayukama akáyáámmá timá kátuweta minnámo umákáan-unakaqtoma káyutuweta wení unáákáqtôma ayúqtúwáámma mamá umákaraae. mikáké kaapaq-yátáq ikámma aráápaneta awíqme kóuraae. ");
INSERT INTO usa_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","yemá kéweta aapaqá aónaamma mórama Tairínibake-naqa áwîqa Tááímonimma aónaraae. ánibo min-nákóqtábá Îtuni kaapaq-yámá mayaíkáae téta wakúyakaraae. ");
INSERT INTO usa_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","yemá móra-marukaq iráamma mi-márúkóní áwîqa Íbaru-aipimma Kórákóta-anue. min-áwíkóní áaimma mirá-uraiye. aqnón-ayaata-marupare ");
INSERT INTO usa_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","aíqa íma íkáae tétaboata yemá wááéni-nomma ikaaq-yátáákáráq awígíyoq umáráa-nomma Îtumma naíkáae téta ámíkaamanibo Îtuma namá aónawaaena íma naráiye. ");
INSERT INTO usa_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","ánibo yemá Îtumma kaapaq-yátáq níri amá íyakatuweta Îtuni unáákáqtôraq aábêmma yamá náawabi uyátainna-waigoma mayániye tirááe. ");
INSERT INTO usa_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","ánibo yemá mi-márúkáq máeta Îtumma yabíqtuweta máqe-uraae. ");
INSERT INTO usa_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","naayóbáqá Îtuni aqnókáqá aamá ítama kéyaineta tiráan-aimma agatáámma yemá maará téta agatááe: “maannáma Îtue Ítíráaeo-wayukati kínie.” téta agatááe. ");
INSERT INTO usa_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Îtuni amakaqá kaayaqá ááiq-nakaraq moyá-nákáráq níri amá íyikaraae. mórama Îtuni ayáánurapaq íyaketa mórama ayáánepaq íyaketa urááe. ");
INSERT INTO usa_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","ánibo aarawaamá aakaqá kótayata kéeta timá yawááq-umaketa yemá yiqnótáq yumátuweta tirááe: ");
INSERT INTO usa_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“emá anó-monoq-namma yawítítuke kaumo-yúpáámá keqnáámmá umá ánatainaqopo enamáárîq íbêqa emmá áwáqnaa uwo. emá Áánûqtuni áanikomo máema kanaaráq kaapaq-yátáké yuwé marabí kumuwo.” téta tirááe. ");
INSERT INTO usa_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","uyátá-maqma anó-monoq-wayukagaraq ámáan-aimma yirááti-wayukagaraq anó-kayukagaraq aábê-aimma téta maará-tiraae: ");
INSERT INTO usa_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“wemá káqo-kayukama yíwáqnaa éwaimanibo wemá wenamáárîq íma kanaaráq áwáqnaa kéiye.” wemá íyaq Ítíráaeo-wayukati kíniyabiyo? kanaaráq wemá kaapaq-yáráké yuwéna marabí kumínataa ketáá itéqtaa tirummá ámeno. ");
INSERT INTO usa_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","wemá Áánûqtukaq arummá kámena tiráiye: “kemá Áánûqtumma áanikomune.” tiráibo kanaaráq Áánûqtumma akaínanama áwáqnaa íno.” téta tirááe. ");
INSERT INTO usa_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","kaayaq-nákámá ááiq-nakaraq moyá-nákáráq wení kaapaq-yágóní amakaq íyikaa-nakorata yenákágáráq móraiq umá Îtumma timá yawááq-umakaraaye. ");
INSERT INTO usa_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","aabaúgómá aáwaqa naí-kánáá itana máqte-marabaqa aaqá ékurena wáitana aabaúgómá kaumotá uráiye. ");
INSERT INTO usa_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","ánibo aabaúgómá kaumotá ínéna kéitana Îtuma anókaq ááyama wááqa yená tiráiye: “eri, eri, aréma taabaakatááni?” téna Íbaru-aipi mirá-tiraimma minnâ maará-tiraiye: “ketí Áánûqtuo, ketí Áánûqtuo, nôraq itaawáq kemmá tiyuwáánô?” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","miráimanibo yaímma-wayukama waaqókáq itó-uma máe-kayukama yemá min-áímmô timmá ítátuweta tirááe: “maan-nákómá Iráíyamma kááyaiye.” téta tirááe. ");
INSERT INTO usa_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","ánibo mi-káyúkábíké móra-nakoma páátákáá aináámmá yáákátena ikaaq-wááéní-nópí yamá atímma óqtátábí apirátuwena Îtuqtaba naíkáae téna ámikaiye. ");
INSERT INTO usa_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","miráimanibo yaímma-wayukama tirááe: “awé uráiyata aónatuwetaao. Áánûqtuni amuné-náqá Iráíyama pukáipike ya áwáqnaa íní íyabiyo?” téta tirááe. ");
INSERT INTO usa_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Îtuma anókaq ááyama keqnáámmá wááqa yumátuwena arun-íyápómá yúwáitana kóitana pukáiye. ");
INSERT INTO usa_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","é mi táoqa anó-tabaraabegoma anó-monoq naupaq ikáqnûqtuwena wáqeimma yakáqma yanaapáq-áqtóbáké napaq-áqtóbáq kukéna mamá kaayaq-áqtóîq uráiye. mirá kéitana márûma kéyitana anón-oqtamma kíqtígitana ");
INSERT INTO usa_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","máátíq-máatikoma yawákitana taíbaq Áánûqtuni waayúkama naayóbáqá pukuráa-kayukama yeqtí yúgaraq itó-uraae. ");
INSERT INTO usa_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","yemá máátíq-máatipakemma yuwéta anaaékaqa Îtuma pukáipike itó-uma kóitata yemá aokaq-márúqá Yérútáárebaq anó-marukaq úyówata netuqyaa-káyúkámá pukáa-kayukama yimónaraae. ");
INSERT INTO usa_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","ááiq-i-wayukati kawáá-nákáráq ááiq-i-wayukama mikáq máeta Îtumma kawáá umátuweta máqeo-kayukama márûma yimmá aónéta máqte-qtataaqa pááq-imma káoneta yáaqtaba kéeta yemá maará-tiraae: “áraine. maan-náqá Áánûqtuni áanikoma maéwaine.” téta tirááe. ");
INSERT INTO usa_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","taíbaq aaramá mikáq máqeo-noinimma Îtumma anaaé waqméta Kááriri-maruqa yuwéta ya áwáqnaa ínéta irááe. yemá mi-nóínímmá nékakaa itó-uma máeta karáqtuwe máqe-uraae. ");
INSERT INTO usa_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","mi-nóínítí aúkáapike móra-inimma Máríaa Máátarinie. mórama minnâ Máríaama Yêmitiyaa Yótêbiti yinóae. ánibo mórama kaayaq-íyápórátátí yinóama Yéberimma áanikoratae. ");
INSERT INTO usa_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","énaikaq mórama netuqyaa-mónéqá makái-naqa Aarimatéabake iráimma wení áwîqa Yótêbima iráiye. wegáráqá Îtuni iyápó-annama máqe-uraine. ");
INSERT INTO usa_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","wemá Îtuni arááq-auma mayánîqtaba Pááíratikaq ya ítaraiye. miráitana Pááíratima ááiq-i-wayukayaba titana Îtuni arááq-auma Yótêbimma ámikaae. ");
INSERT INTO usa_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","ánibo Yótêbima Îtuni arááq-auma maténa wayámmá aúge-tabaraaberake múqmúma útúyakatuwena ");
INSERT INTO usa_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Îtuni arááq-auma maména óqtama wení mayaí-wáyúkátê wenamáárîq wetábá aúgemma kubáumakai-maipi mó uqtamákarena anón-oqtamma waéqma ótaq aúyaqmarena kóuraiye. ");
INSERT INTO usa_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Máríaa Máátarinigaraq káqo-Mariaagaraq yenákámá maraq máeta muríámmá wáin-aukapaq yóíqa umátuweta máqe-uraaye. ");
INSERT INTO usa_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","aabáyaama Tabaatiráq yokaa í-yátááqá ánatagitata uyátá-maqma anó-monoq-wayukagaraq Pérati-wayukagaraq Pááíratinopaq koma áíkuteta ");
INSERT INTO usa_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","maará-tiraae: “anó-nako, Îtuma kaaqaari-nákómá paámô máenama maará-tiraine. ‘kaumo-kánáámá ánataginaq pukáánabike yauwéqma itó-onune.’ téna tiráimma paá taákaq wáiqtaae. ");
INSERT INTO usa_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","miráinaa emá ááiq-i-wayukama timá yíminata mi-máátíq-máátíkóní ótaqa yabíkáiyana kaumo-kánáámá yáwíno. miráinata wení iyápó-annama kanaaráq íureta arááq-auma moyámmá matéta máqte-kayukama timá-yimeta ‘Ituma pukáipike itó-uma kóuraiye.’ téta kaaqaari-áímmá timá-yimiyabae. ánibo anaaékaq kaaqaari-áíkómá áqnáabaq kaaqaari-áímmá uyátaiyabae.” téta tirááe. ");
INSERT INTO usa_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pááíratima timá yímikaiye: “keráwáqá yaímma kawáá ínó-kayukama yíwíkeraq mi-múríámmá ko aúyaqma akoqnáá umá keráwáqá teníq umáráaro.” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","miráitata yemá uréta mi-múríákóní ótaqa anón-oqtanapo káwéqa yamá akoqnáá umáreta awaaméqá umáketa yaímma ááiq-i-wayukama kawáá umáyíkaraae. ");
INSERT INTO usa_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Tabaatimá ánatagitana Tótaagoni áqnáabaq-kanaabimma Máríaa Máátarinigaraq káqo-Mariaa yenákámá muríákóní ótaq aónayeta irááye. ");
INSERT INTO usa_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","páátákáá é mikáq anó-maruma yokáiye. uyátárai-nakoni kaqtó-nakoma Áánûqtunopake kukéna anón-oqtamma kunaukáqma waéqmarena ámûraaq máqe-uraiye. ");
INSERT INTO usa_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","óíkoma tágama konnákómá tágainikaa umá tágaitana wení wáqtôgoma wayámmá karáiye. ");
INSERT INTO usa_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","yemá ááiq-i-wayukama áaqa ikatéta anómma iyánáaq umá aqteqte umáreta waayúkama pukáa-kayukaraa umáguraae. ");
INSERT INTO usa_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","mi-káqtó-nákómá kaayaq-íníkámá maará timá yímikaiye: “kenákámá ikatîq íokao. Îtumma ikámma kaapaq-yátáq aráápamaretaa-nakoqtaba ya abáá kéoyaq kemá káonaune. ");
INSERT INTO usa_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","wemá maapímmá íma máibo wemá itó-umaguraiye. miráuma wemá naayóbáqá tiráiniq uráiye. Îtuma waguré máqe-urai-marukaqa kenákámá iréka ya aónatuweka ");
INSERT INTO usa_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","páátákáá uréka wení iyápó-annama Îtuqtaba pukáipike itó-umaguraiye téka mó-tima-yimekao. ‘ítáákao. Îtuma Kááriri-marupaq áqnáabaq kéwipoaq keráwáqá min-áúkápáq wemmá aónainoe!’ timá-timuna-aimma taákaq máráákao.” téna kaqtó-nakoma tiráiye. ");
INSERT INTO usa_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","ánibo min-íníkórátá ikatîq kéetamanibo anómma yimuqá maqméta páátákáá máátíq-máatipakemma yuwéta Îtuni iyápó-annama timá-yimineta uyaaté kóuraaye. ");
INSERT INTO usa_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","aapaqá Îtuma páátákáá abarokáq uréna yimónatuwena tiráiye: “kaayoné-yátááqá kenákátê waíno.” téna tiráiye. ánibo min-íníkórátá Îtuni amakaq uréta aítaukaq yáqtoketa wenáwîqa múte yaútaaye. ");
INSERT INTO usa_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Îtuma min-íníkórátámá timá-yimena tiráiye: “kenákámá ikatîqa íokao. kenákámá uréka tíbâqawaayuma mó-tima-yimiyata Kááriribaq oro. yemá mibáq kemmá timónanoe.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","kaayaq-íníkámá aapaq kéoyaqtaba yaímma ááiq-i-wayukama máátíq-máatikaq yabíqtuwe máqeo-kayukama anó-marupaq uréta máqte-qtataaqo pááq-itaba anó-monoq-wayukama mó-tima-yimikaae. ");
INSERT INTO usa_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","ánibo anó-monoq-wayukama anó-kayukate áíkuteta móra-aimma timá ítaraae. minnâ yemá móneqa nétuqyaa ááiq-i-wayukama kéyimeta ");
INSERT INTO usa_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","tirááe: “keráwáqá maará-tero. ‘wení iyápó-annama nokáa iréta arááq-auma moyámmá tútáá waguráunayaba maméta kóuraae.’ tero. ");
INSERT INTO usa_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","anó-kamaani-nakoma maamin-áímmô itaínataama kanaaráq ketáá yaímma-aimma timá yíménataa keráwáqá aamá íma mayánóe.” téta uyátá-maqma anó-monoq-wayukagaraq anó-kayukagaraqa tirááe. ");
INSERT INTO usa_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","miráitata ááiq-i-wayukama mi-mónéqá maméta minnámo teníq urááe. ítáaro. min-áíkómá máqtemma Íbaru-aukapaq wéyáwé itata ítaraapoata íbêkaraqa mimórá-áímmá paá kéte. ");
INSERT INTO usa_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","yemá tiyááka umá móra-iyapo-annama Kááriri-anuraq uréta Îtuma “mibáq oro.” téna tiráin-anuraq urááe. ");
INSERT INTO usa_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","yemá Îtumma aónatuweta Îtuni áwîqa múte yaútaamanibo yaímma-iyapo-annama kaayaq-yúyánámmá ítaraae. ");
INSERT INTO usa_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","ánibo Îtuma waaqókáq iréna watáama timá-yimena tiráiye: “Áánûqtuma kemmá máqte-naapaamma wení márûpakaraq maa-márábíkáráq tímikaiye. ");
INSERT INTO usa_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","miráinaq keráwáqá uréraq máqten-anna-wayukama ko mamá ketí iyápó-annaiq umáyíkáaro. ánibo ketiboní áwîkakaraq áanikoma ketí tíwîkakaraq Áánûqtuni Aokaq-Áágóní áwîkakaraq nommá péqyikaaro. ");
INSERT INTO usa_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","keráwáqá naayóbáqá máqte-qtataaqtaba timá tímikaunaiq umá kéiteraq wáráaro. kemá keráwáqtê máqte-tupaama máraanana maa-kánáágóní aqtóráq wíniye.” téna Îtuma wení iyápó-annama timá yímikaiye. ");
INSERT INTO usa_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Îtu Káríqto, Áánûqtuni áanikoma, wení átê-wataagoni áaimma mirá-imiye: ");
INSERT INTO usa_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","weqtábámá Áánûqtu timákaraitana Áítáíya Áánûqtuni watáá-wataa-naqa miráuma agatáiye: “aónaao. kemá ketí watáá-wataa-naqa timá áménana enaúbáqá kéena wemá ení aammá yokaa-yokaa umákaniye. ");
INSERT INTO usa_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","kaqmáápaqa móra-nakoma watáá-wataa timá kabámarena kétiye, ‘uyátárai-nakoni aammá yokaa-yokaa umákaaro! wení aammá mamá arupú oro!’” titana agatáiye. ");
INSERT INTO usa_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","agatáinapoana Yóáane nommá peraí-náqá kaqmáápaqa iréna tiráiye: “keráwáqtí áaimma waéqmáráaro! waéqma nommá péráaro! pétikaina keráwáqtí kúmiq-yaqtaaqa kebó-yáqtáákáráqá paábaq yúwáaro! paá yuwénama atóbagenana ánataginiye.” titata ");
INSERT INTO usa_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","máqte-kayukama Yúría-marupakekaraq Yérútáárebakekaraq Yóáane máipaqa kóuraae. kóureta abarokáq tirááe: “ketááí áaimma táígoma uréna kúmikoma uréna kebógómá uráitataa ketáámá aíbôqnaaboq urétaa táígoma uráunataae. urétaa maa-wáí-táígóqtábámá mútûqa tinaaépaqa kémaraunatae.” tewana Yóáane nommá péqyikarena Yótaa-nopi péqyikaraiye. ");
INSERT INTO usa_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","ááqibo Yóáane oótiraa-kakoni aúwaratima áyaugaraqa kúberena mi-kákóní áwîqa káámoma aúwarati-amurannama umátokena yaatáruraa-kamma uwon ámûkaraqa néwaimiye. ");
INSERT INTO usa_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","ááqibo wemá abarokáq tiráiye: “tinaaépaqa uyátárai-nakoma kéiye. ketí mú mikáq-náqá kemá wení maqnémá maqnégánópóaqa wení aítauq-anaa-annae íma kanaaráq uwaénúnamiye. ");
INSERT INTO usa_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","kemá paá nokáráqá kébetikaunana wemá aágogaraqa pétikaniye. Áánûqtuni Aokaq-Áágómíye.” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","mi-kánáámá Îtuma iréna Náátárêtibake anón-awiqa Kááriribaqa iráitana Yóáane nommá pérakarena Yótaa-nopi pérakaraiye. ");
INSERT INTO usa_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","pérakaitana Îtuma nopíké kéuwitana káonaitana wíyómma abayámmá kéigitana aágoma máaraa kukéna Îtuni aúraqa atáitana aónaraiye. ");
INSERT INTO usa_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","wíyôkake aagómá tiráiye: “emá ketáanikoma máane. eqtábámá timuqá kémarakaune.” titana ");
INSERT INTO usa_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","aágoma páátákáá Îtuma kaqmáápaqa waqtukáiye. ");
INSERT INTO usa_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","waqtukáitana kaqmáápaqa móra-wiyomma tiyááka-yupaama (40) máqe-uraiye. máqe-uraitana webó-wámmá Tááqtaama Îtuni kanaa inayaba maqmá aónaraitana wemá abááq-wákáráqá máqe-uraitata Áánûqtuni kaqtó-wayukama áwáqnaa urááe. ");
INSERT INTO usa_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","ááqibo Yóáane kaarabúti matáitana Îtuma Kááriribaqa iréna Áánûqtuni átê-wataama abarokáq timá yímikena tiráiye: ");
INSERT INTO usa_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","“Áánûqtuni kawáá kéi-kanaama íbêqa kéyabita wenôpaqa kéiye. kéyabita keráwáqá kúmiq-yaqtaaqa kebó-yáqtáákáráqá yuqmá ánataaro. táígon-aaimma kúmiq-aaimma kebó-ááímmá waéqmáráaro. Áánûqtuni átê-wataama arunóbáqá arupú umá ítáaro. áyakoma tágaino!” timáqtuwena ");
INSERT INTO usa_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Kááriri-nokayukoni agínaupaqa uréire kéena kaayaq-nákómá yimónaraitata noyááqa abááóya-nakoratama yíwîqa awaómá Tááímoni ábâkoma Áánaru Îtuma yimónaraitata kúqônapo noyááqtabama abáá kéoye. ");
INSERT INTO usa_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","kéoyana Îtuma tiráiye: “kenákámá tinaaépaqa yekaao. ketí watáá-wataa timá yímiyata waayúkama itéta ketinaaépaqa yínobo! miráuma waayúka-amaa ínákámá auráyóye.” ");
INSERT INTO usa_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","titata yenákámá páátákáá kúqômma kéyuwetarata Îtuni anaaépaqa urááye. ");
INSERT INTO usa_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","uyéq éna waaqókáqá uréire kéena kaayaq-wátámá yimónaraitata yíwîqa Yêmitiyaa Yóááne iboán áwîqa Yébere. yemá nópí-káárébí kúqômma yarákuraitata amuqá kéyoraae. ");
INSERT INTO usa_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","kéowana Îtuma yimónaqtuwena yááyaraiye. yááyaqtuwaitata páátákáá Îtute kóureta Yébere yenákáti iboámá wení káágóbégaraqa nópí-káárébí iyúwáawata máqe-uraae. ");
INSERT INTO usa_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","máqe-uraawata Îtute kóureta Kápéranabaqa iréta Tabaatiráqá aapinaa-náúpáqá pékaae. pékaawana Îtuma aapinaammá timá yímikaiye. ");
INSERT INTO usa_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","timá yímikaitana wení aapinaaqtábámá waayúkama yáaqa karáiye. wemá abarokáqá akoqnáágogaraqa kéyiraa téna timá yímikaitata ááqibo aapinaa-káyúkámá aapinaammá akoqnáágogaraqa ítiraawana wemá aapinaa-káyúkáráá ítima-yimikena wemá uyátárai-nakoraa náápaa wái-nakoraa umá timá yímikaitata waayúkama yáaqa karáiye. ");
INSERT INTO usa_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","ááqibo aapinaa-náúpáqá móra-nakoma kuti-áágógáráqá máitana kuti-áágómá arunóbáqá wáqe-urena ");
INSERT INTO usa_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","aamá kabámarena tiráiye: “Îtuo! é Náátárêtibake-nakoe. keqtááyábá nôraq kéono? emá arááq tíkamine iráánô? eqtábámá kéitauna emá Áánûqtuni-nakoe. aítaa í-yátááqá íma wái-nakoe. aokaq-náqá máane.” titana ");
INSERT INTO usa_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Îtuma áá awáágurena tiráiye: “páátí mááo! wení arunóbáké yáubaao!” titana ");
INSERT INTO usa_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","kuti-áágómá min-nákóní aúma kaepú-kaapun uréna wááqa yuréna yáubaraiye. ");
INSERT INTO usa_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","yáubaguraitata waayúkama yáaqa karéta tirááe: “nóinabiyo? wé abarokáqá kuti-áágóqtábámá aamá káwaagena akoqnáá umá timá ámitana kaqtó umá yáubaguraiye. nóin-aainabiyo? aúgenabiyo?” tiréta ");
INSERT INTO usa_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Îtuqtabama watáá-wataa tíq-tiq urááwana mi-kátáámá páátákáá máqte-Kááriri-marupaqa kóuraiye. ");
INSERT INTO usa_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","urááwana aapinaa-náúpáké yáubarena Tááímoniyaa Áánaruni naaúpaqa Yêmitigaraqa Yóáanegaraqa pékaae. ");
INSERT INTO usa_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","pékaitana Tááímonini ánáakoni anóama karímá kákaitana kokoq yámma kákaitata yemá wení karíyábámá Îtumma ya timá ámíkaawana ");
INSERT INTO usa_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","wemá iréna ayáákaqa yáqtoqma awáuturaitana kokoq yámma érákáitana wemá aáwaqa agamá yímikaiye. ");
INSERT INTO usa_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","karáákáq kúmitana abaúmá pékuraitata waayúkama máqte-kari-kakai-kayukama kuti-áágó wái-kayukagaraqa yíwîqmeta Îtunopaqa irááe. ");
INSERT INTO usa_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","iréta naa márûpake máqte-kayukama oqtaráqá áíkutaawana ");
INSERT INTO usa_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Îtu káqo-kaqo-karima atóbamayikaitata netuqyaa-káyúkátí karímá atóbaguraawana kuti-áágómá netuqyaa-káyúkátí irunóbáké waqtukáitata kuti-áágómá Îtuni áaimma ítáraawana kuti-áágótábá wemá timá yímikaiye: “páátí mááro! waayúkamá ítima-yimero!” titata páátí máqe-ureta aamá ítiraae. ");
INSERT INTO usa_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","ááqibo nokáá-nokaapaqa aaqá ítágaraitana Îtuma wenamáa itó-urena yáubarena nunamummá mó titata ááqibo ");
INSERT INTO usa_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Tááímoni wení aanábó-wáyúkágáráqá wenanaaépaqa wakéta abáá kéeta ");
INSERT INTO usa_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","káoneta tirááe: “máqte-kayukama eqtábámá abáá kéoe.” tewana ");
INSERT INTO usa_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Îtuma tiráiye: “káqo-marukaqa kónunatae. abarokáqá maa-kátáá-wátáá keqnáámmá ko timá-yimenune. miráunaboaqa kukáune.” téna ");
INSERT INTO usa_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","máqte-Kaariri-marukaqa uréire uréna yetí aapinaa-náúpátáá aapinammá abarokáqá timá yímikena kuti-áágómá waayúkati irunóbáké waqtukáiye. ");
INSERT INTO usa_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","ááqibo kárú-naqa Îtunopaqa iréna araayukaqá yó peréna egaa aréna tiráiye: “é akáinaama tú kégayubi-karima kanaaráq atóbatikanone.” titana ");
INSERT INTO usa_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Îtuma arummá kéitana ayáámma árúqtuwena ánékukuqa uréna tiráiye: “tíkáiye. atóbagaao!” titana ");
INSERT INTO usa_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","páátákáá atóbaguraiye. karímá érákáitana ");
INSERT INTO usa_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Îtuma akoqnáá umá timá ámikaiye: “kóaao! ");
INSERT INTO usa_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","waayúkama ítima-yimiyo! monoq-nákómá ení aúwaratimma ko aráátiyo. érákái-qtataaqa Móteti timá yímikai-qtataaqa awaaméq náámeq-yaqtaaqa márû-amiyo! ámínatama waayúkama aónáíyana ení karímá érákáinata itánoe.” ");
INSERT INTO usa_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","titana kóurena kaqtó íurena máqte-kama tíq-tiq umá timá yímikaitana Îtuma naa márûkaqa abarokáqá íma kanaaráq uráimiye. íurena kaqmáápaqa máitata waabámmá máqte-marupake wé máipaqa yó-yo urááe. ");
INSERT INTO usa_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","pááqya-kagaama púítana Îtuma Kápéranabaqa yauweré uráitata waayúkama timá aúgen-augen umátukaapoata ítáraawana naaúpaqa máqe-uraiye. ");
INSERT INTO usa_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","máqe-uraitata taíbaq-wayukama yó-yo éta áíkutaawana naaúpaqa titipáá uráitana máápaq oqtarákáráqá titipáá uráiye. wáátima áíkutaawana Îtuma watáá-wataa abarokáq timá aapinaammá timá yímitata ");
INSERT INTO usa_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","aú aráákagurai-nakogaraqa kéyeta kaayaqté-kaayaqte-wayukama yaagu yaqméta irááe. ");
INSERT INTO usa_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","iréta waaqókáqá kanaaráqá íma yewata taíbaq-wayukama oqtaráqá mááwana miráinapoata waaqókáqá íma yéta oáráqá óqtakaan-oaraqa yaagu yaqméta utéta óqtakaan-oama Îtuni yanaa yawátááwana kúkutaaraqa aú aráákagurai-nakoma kéwaitata wemmá oáráké kúkutaagaraqa ánnáraqa yuwáka-yuwaka kéowana kukáiye. ");
INSERT INTO usa_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","kukáitana Îtuma oáráq máa-kayukama káonaitata írunóbáqá ôriq umá tágama ítááwana yetí irunóbáqá itaígómá iténa tiráiye: “ketáaniko, eni kúmiq-yaqtaaqa kebó-yáqtáákáráqá paábaq kémaraunana ánataguraiye.” titata ");
INSERT INTO usa_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","ááqibo aapinaa-káyúkámá máeta yúyánánóbáqá itéta ");
INSERT INTO usa_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","maaráuma yúyánámmá ítáraae: “nôraq itana mirá kétiyo? tiráinapoana wemmá Áánûqtun áwîqa táíq umá yamá káraapaiye. paá-wayukama kúmiq-yaqtaaqa timá áminanama íma atóbaginana íma ánataginibo Áánûqtu wenamáa kanaaráq timá áminiye.” ");
INSERT INTO usa_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","ítáawana Îtuma yetí yúyánámmá ítárena tiráiye: “nôraq itaráq keráwáqtí túyánánóbáqá miráuma kéitaao? ");
INSERT INTO usa_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","ááqibo min-áú-áráákágúráí-nákóqtábámá kemá ‘ení kúmiq-yaqtaaqa atóbagiye’ túnana oyaaq kéiyo? ááqibo ‘itó-uma kúkutaagaraqa uréire uwo’ túnanawaq oyaaq kéiyo? nóine tenanawáq mú oyaaq íníyô? ");
INSERT INTO usa_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","ááqibo ké Waayúka-Araakoma maéq kúmiq-yaqtaaqa marabí kanaaráq atóbamakanaa onata itáiyaqa anón-awaameq umá tiráátenata itánoe.” ");
INSERT INTO usa_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","téna aú aráákagurai-nakoqtabama timá ámikaiye: “ké kétimamune. itóaao ení kúkutaama aqmé naaópaqa kóaao!” titana ");
INSERT INTO usa_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","itó éna kúkutaama yáumena páátákáá kóuraitata máqtekoma aónaawana yemmá yáaqa kaitata Áánûqtuni áwîqa múte yaúteta tirááe: “mirái-qtataaqa íaonewaunataae.” téta tirááe. ");
INSERT INTO usa_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","tewana Îtuma nokaayúkóní agínaupaqa móragaraqa kóuraitata waabámmá yewana aapinaammá timá yímikaiye. ");
INSERT INTO usa_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","timá yímiqtuwena uréire kéena móra óqtamma mayaí-nákómá káonaitana áwîqa Aríbae. Áápiateni áanikoma kéena opíqtiraqa máqe-uraitana Îtuma ááyaraiye: “tinaaépaqa iyo!” titana Aríbae itó éna wenanaaépaqa kóuraiye. ");
INSERT INTO usa_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","kó éta Aríbaeni naaúpaqa irááwana Îtuma wení iyápó-annagaraqa aáwaqa kénaawata óqtamma mayaí-wáyúkámá netuqyaa kúmikaraq-wayu-kagaraqa Îtuni anaaépaqa kégoeta yaímma yaareráqá Îtugaraqa wení iyápó-annagaraqa máqe-uraae. ");
INSERT INTO usa_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","máqe-uraawata apinaa-káyúkámá Pérati-wayukagaraqa káoneta tirááe: “nôraq itaná wemá óqtamma moyá-káyúkágáráqá kúmikaraq-wayukagaraqa aáwaqa kénaiyo?” tewana ");
INSERT INTO usa_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Îtuma iténa tiráiye: “karí íwái-kayukama tótaa-nakoqtabama kéyikaitana karí-nákómá wenamáa tótaa-nakoqtabama kákaiye. ááqibo keqnáámmá kemá kúmiq-yaqtaaqa íwái-kayukama íkááyaune. kúmiq-yaqtaaqa wái-kayukama kááyeqa kéyune.” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","ááqibo móra-taoqa Yóáane nommá peraí-nákóní iyápó-annae Pérati-wayukati iyápó-annagaraqa aáwaqa íkénai-kanaama máitata íkénaawata waayúkama Îtunopaqa iréta ítama aónaraae: “Yóáaneni iyápó-annama Pérati-wayukati iyápó-annagaraqa aáwaqa íkénaawata nôraq itata ení iyápó-annama paá kénaao?” tewana ");
INSERT INTO usa_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Îtuma yauwéqma tiráiye: “aaramá mayánî-nakoma paá kémainatama wení namuq-wáyúkámá aáwaqa íyaq nanô? ímiye. kénaae. ");
INSERT INTO usa_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","káqo-taoqa íma máinanama irummá kéitana aáwaqa íkénai-kanaama ínata ínanoe. ");
INSERT INTO usa_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","ááqibo waayúkama aúge-kannaagaraqa naayón-únákáqtógáráqá íma arááqtata kéiye. yakákuraipaqa arááqtata ínanama móragaraqa yarákínana aammá mú mikáqá yaráqma anómma aurániye. ");
INSERT INTO usa_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","keqnáámmá waayúkama aúgen-uqtekaa-aran-nomma naayón-áúwárátí-ánáápí íma atíme kéiye. aúgen-uqtekaa-aran-nomma miráuma atíme ínanama nommá naayón-ánáámmá yarákínana atígena káqnáginiye. káqnáginana ánáamma táíq umáginiye. miráipoana aúgen-anaapi aúge-nomma ati íno.” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","ááqibo móra-Tabaatiraqa Îtuma yópáqá uréna wení iyápó-annate kénaeta arammá kéguqtowata ");
INSERT INTO usa_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Pérati-wayukama tirááe: “aónaao! nôraq itaráq Tabaatiráqá ímira í-yátáárîqa kéoo?” tewana ");
INSERT INTO usa_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Îtu tiráiye: “íyaq ítáraao? aúbabi Tébitiqtabama agamatámmá íyaq yoráútaao? ááqibo wemá áa kéyainana wení waayúkagaraqa yáa kéyaitana ");
INSERT INTO usa_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Áánûqtuni naaúpaqa pékena Áánûqtuni yammá naráiye. Abíaqtara mú mikákáá anó-monoq-naqa máqe-uraitana Tébiti miráuma aammá aúkai-qtamma kénena wení waayúkama yímîtata narááe. ááqibo mi-qtámmá monoq-nákómá wenamáa kanaaráqá kénaiye.” téna ");
INSERT INTO usa_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","28","Îtu tiráiye: “Tabaatiráqá aagaí-kánááé aagamá waayúkama áwáqnaa íyábá wáibo waayúkama Tabaatigóní aammá aúmakain-aimma kawáá-íyábá íma wáiye. miráuma ké Waayúka-Araakoma Tabaatiyábá uyátárai-nakoma máune.” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","móragaraqa aapinaa-náúpáqá pékaitana móra-nakoma wení ayáámma ayákagitana máqe-uraiye. ");
INSERT INTO usa_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","ayákaguraitata waayúkama Îtuqtabama yúramma karáqtuwe máqe-uraawana ááqibo Îtuma Tabaatiráqá ayáámma atóbamakainatama aamá amínétae. ");
INSERT INTO usa_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Îtuma ayáán ayákagurai-naqa timá ámikaiye: “maabáqá iyo!” téna ");
INSERT INTO usa_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","waayúkayabama ítama yimónaraiye: “ááqibo Tabaatiráqá áwâqnaa ínama kanaarárábiyo? táígoni ínama kanaarárábiyo? karímá atóbamakainama kanaarárábiyo? arááq ikamíníma kanaarárábiyo?” titata yemá páátí máeta íma abarokáq umá timá ámikaae. ");
INSERT INTO usa_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","ítiraawana Îtuma áyámma kéitana karáqma yimónaima yeráwáqá weganokanoqtábá yirunóbáqtábámá Îtuma arummá kéitana ayáán ayákagurai-naqa timá ámikaiye: “ayáámma arúqtuwaao!” titana arúqtuwaitana atóbagurena kanaaráqá uráiye. ");
INSERT INTO usa_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","uráitata Pérati-wayukama naaúpake yáubareta páátákáá Érôtini-wayukagaraqa áíkuteta Îtumma arááq ikamínô-kataama tíq-tiq urááe. ");
INSERT INTO usa_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","ááqibo Îtuma wení iyápó-annagaraqa Kááriri-nokaayukaqa kéowata waabámmá yetinaaépaqa wakááe. ");
INSERT INTO usa_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Kááriribake Yúríabake Yérútáárebake Iruméabake Yótaa-nokoma meran-ábápáké Tááyabake Tááíranapake taíbaq-wayukama irááe. máqte-qtataariq Îtuma kéi-qtataaqa itéta yó-yo umá irááe. ");
INSERT INTO usa_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","waabámmá taíbaq áíkumaraawana non agínaupaqa titipáá uráitana Îtuma iyápó-annayabama timá yímikaiye: “nópí-kááré yokaa-yokaa umátikaaro.” téna miráinata waabámmá íma wemmá yatamínóe. ");
INSERT INTO usa_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","netuqyaa-kárí-wáyúkámá atóbamayikaraitata máqte kari kéyikai-kayukama kutéta ánekukuqa ínéta urááe. ");
INSERT INTO usa_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","ááqibo kuti-áágómá yirunóbáq máeta Îtumma káoneta yáaqa karáipoata marabí wenôpaqa kuméta aabarokáq tirááe: “emá Áánûqtuni áanikoma máane.” tewana ");
INSERT INTO usa_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","áá yiwáágurena “pááti mááro!” titata wenáaiqtabama ítima-yiminewana tiráiye. ");
INSERT INTO usa_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","ááqaanibo wemá anubaqá uténa yaímma-wayuka aúkáapikena wenôpaqa irááe. ");
INSERT INTO usa_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","tiqtaupake kaayaq-wáyúkámá yááyarena tiráiye: “tiké mánoe. ké timá tímênaq watáá-wataa aabarokáqá mó-tinoe. ");
INSERT INTO usa_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","kuti-áágómá waayúkati yirunóbáke kanaaráq waqtuwánóe.” téna minnáyaba yááyaraiye. ");
INSERT INTO usa_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","yááyai-kayukati yíwîqa maaráuma wáiye. Tááímoni aúgen-awiqa ámikena Pítaa téna yaráiye. ");
INSERT INTO usa_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Yêmitiyaa Yóáane Yébereni áanikoratama yenákámá káqon-awiqa yímikena Póáánêti yaráitana maan-áwíkóní áaimma wíyôn-aagon-araaqa miráuma aráámáómá aúkáiye. ");
INSERT INTO usa_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Áánaru ááyarena Píripi ááyarena Paatááromiyu ááyarena Mááqtiyu ááyarena Tómááti ááyarena Yêmiti Áápiateni áanikoma ááyarena Tááqtiate ááyarena Tááímoni kámáániyaba watáá-wataa tin-náqá ááyarena ");
INSERT INTO usa_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Yúqtaati-Itikáárioti ááyaraitana wemá kutaruríq-í-náqá aúkáiye. yááyarena ");
INSERT INTO usa_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Îtuma naaópaqa yauweré kóuraiye. kóuraitata waabámmá móragaraqa áíkutaawanaboana Îtuma iyápó-annagaraqa aáwaqa kanaaráq ínaraamiye. ");
INSERT INTO usa_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","ínaraawata Îtuni noganéq-wáyúkámá itéta tirááe: “wemá aún-ááímmá kéiye.” téta iréta áwîqme ínéta irááe. ");
INSERT INTO usa_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Yérútáárebake aapinaa-káyúkámá tirááe: “wení aúnobaqa webó-áágómá Tááqtaani aágoma máiye.” tirááwata tébakaqa tirááe: “kuti-áágóní aboágáráqá wemá maqné-kútí-áágómá kéwaqtuwaiye.” tewata ");
INSERT INTO usa_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Îtuma waayúkama yááyarena tiráiye: “náaraq umá webó-wámá wenamáárîq kanaaráq kéwaqtuwaiyo? ");
INSERT INTO usa_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","ááqibo móra-marukoma yáíkaaqa umáqtuwainata tébákáq-tebakaq ááiqa íyana mi-márúkóní waayúkama paá íma mánibo ánataginoe. ");
INSERT INTO usa_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","miráuma ááqibo keqnáámmá waayúka-annama yáíkaaqa umáqtuwainata tébákáqá-tebakaq ááiqa íyana min-ánnámá paá íma mánobo ánataginoe. ");
INSERT INTO usa_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","keqnáámmá Tááqtaama wenamáárîq kéwaqtuwena wegáráq íma paá maéna arááq-auma aurániye. ");
INSERT INTO usa_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","waayúkama imaamu-nákóní naaúpaqa wení oótamma moyámmá mayánéna íma kanaaráq perániye. áqnáabaqa naakóní aboámá yáqtoqma ánnáma ámîqtuwena moyámmá kanaaráq mayániye. ");
INSERT INTO usa_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","áraimma kétima-timune. taákaqa máráaro! máqtemma kúmiq-yataakoma máqtemma kebó-yátáákómá máqten-awiqa yamá aráápain-aimma paábaq maráinana atóbaginiye. ");
INSERT INTO usa_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","ááqibo waayúkama Áánûqtuni Aokaq-Áágótábámá áwîqa yamá aráápainanama kí-kumiq-yaqtaaqa paábaq ímarainana íma atóbaginibo paá wániye. min-nákóní negígómá paá wáinana máqte-kanaama aákaq yoqmá aónaniye.” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","ááqibo weqtábámá “kuti-áágómá arunóbáqá wáiye” aapinaa-káyúkámá tiráápoana Îtuma mi-wáéqmá-ítáí-áípí tiráiye. ");
INSERT INTO usa_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","anóama ábâkoutaagaraqa iréta naa mátûpaqa máeta wemmá ááyaraae. ");
INSERT INTO usa_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","yááyaawata waayúkama yaayorupamá wenaukápáqá maraq máeta timá ámikaae: “enanóama ábâkoutaagaraqa máápaq máeta kááyaae.” tewana ");
INSERT INTO usa_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Îtuma tiráiye: “ketinó náawabiyo? ketíbâkoutaa náayubiyo?” téna ");
INSERT INTO usa_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","maraq máe-kayukama karáqma kéyimonena tiráiye: “aónaaro! ketinóma ketibâkoutaagaraqa maa mááe. ááqibo ");
INSERT INTO usa_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Áánûqtuni kaqtó kéina-nakoma wé ketíbâqa ketímanaaqa ketinóma miyé.” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","aapinaammá non agínaupaqa móragaraqa timá yímitata ôriq umá aaraukáqá yorupamá áíkutaawana wemá nópí-káárébí nopí ko máitata waayúkama yorupamá agínaupaqa maraq máqe-uraae. ");
INSERT INTO usa_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","ááqibo Îtuma wení iyápó-annama netuqyaa-kátáámá timá yímikaiye. waéqma itaí-áímmá taíganimma timá yímikena wení aapinaapí tiráiye: ");
INSERT INTO usa_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“ítáaro! móra-nakoma ubín-nákómá ayummá iyaabítaaqa ínínapoana kóurena ");
INSERT INTO usa_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","ayummá iyaabítaaqa itana tébakaq-ayumma aapi kuqturáitata numagómá yama narááe. ");
INSERT INTO usa_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","yaímma-ayumma óqta-marabi kuqturáitana pááqya-marama wáitanaboana páátákáá utáitana ");
INSERT INTO usa_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","ááqibo ánûqa íma wáitana aabaúmá utáitana aayákaguraiye. ");
INSERT INTO usa_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","yaímma-ayumma námagaraan aúkaapi kuqturáitana námama ôriq uráitana karaan aúkáapi titipáá umá wáenaboana ayummá aayákaguraitana arammá íma itáiye. ");
INSERT INTO usa_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","tébakaq-ayumma íráqô-mararaqa kuqturáitana arammá ôriq umá itáiye.” téna tiráiye: ");
INSERT INTO usa_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","“ááqibo aáqa wái-nakoma itaíno!” ");
INSERT INTO usa_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","ááqibo wemá iyápó-annagaraqa yaímma-wayukagaraqa paá máeta Îtumma wení íyápó-annama waéqma itaí-áíqtábá ítama aónaraae. ítama aónaawana tiráiye: ");
INSERT INTO usa_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","“keráwáqá kenamáa Áánûqtuni márûqtabama waéqma itaí-áípí itánéqa itánóe. ááqibo tébakaq-wayukama paá-waayukama íma arútama itánóe. waéqma itaí-áípí íma kéitaawana ");
INSERT INTO usa_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Áánûqtu yeqtábá mirá-tiraiye: ‘yemá yúrapike káonetamanibo yirunapó íkáonaae. aónáíq-aonaiq kéeta íaonanoe. itáíq-itaiq kéeta íma itánóe. ááqibo yaákake íma itétama yirukógáráqá íma itáiyana íyakoma íma tágaginiye. ítaiyakakaatati kúmiq-yataapikema kebó-yátáápíkékáráqá waeráné oné. waekáiyakakaatati yetí kúmiq-yataaqa kebó-yátáákáráqá paábaq maréq atóbamayikanaa únnae.’” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","yemmá Îtuma ítama aónaraiye: “wágáábaq tiráuna waéqma itaí-áímmá íyaq kéitaao? ááqibo íma itéqa náaraq umáwaq máqtemma waéqma itaí-áímmá itánô? íma itéqa íma itánóe.” téna tiráiye: “maami waéqma itaí-áíkóní áaimma miráuma wáiye. ");
INSERT INTO usa_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","ayummá ubín-nákómá Áánûqtuni wátáama ayukáá iyaabítaa kéiye. ");
INSERT INTO usa_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","kéitana aakáá-káyúkámá Áánûqtuni wátáama kéitaawana ááqibo webó-wámá Tááqtaama numagóráá páátákáá yirunóbáké Áánûqtuni wátáama moyámmá kémayaiye. ");
INSERT INTO usa_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","ááqibo óqta-mararaa-kayukama Áánûqtuni wátáama itéta yirukaké yáqtoqma yimuqá maréta kéitaae. ");
INSERT INTO usa_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","kéiteta ááqibo kogonaagó umá máqe-ureta uwáyu matéta pááqya-kanaama kéyaqtoraawata waayúkama Áánûqtuni wátáayaba yíkamowatama páátákáá Áánûqtuni wátáayabama yíbô kégaitata yinaaémma kéumayikaae. ");
INSERT INTO usa_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","tébakaq-wayukama náma-mararaa máeta Áánûqtuni wátáama kéiteta ");
INSERT INTO usa_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","ááqibo yópáq-yátááqtábámá maqné-yátááqtábámá yúyánámmá kéitaapoata óqtamma oótakaraqa kéyikaipoata kéqokeq-yaqtaaqa kéyikaipoata yirunóbáqá titipáá kéitana Áánûqtuni wátáama kááyakaitana arammá yirukaqá íma itáiye. ");
INSERT INTO usa_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","ááqibo káqo-kayukama íráqô-mararaa mááwana Áánûqtuni wátáama kéitaawana yirukaké yáqtokaawana íráqôn-aramma yirukaqá ôriq umá itáiye.” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","móra-nakoma iramá kúraqma aúpáqá kémaraiyo? ímiye. abarokáqá kémaraitana kégaiye. ");
INSERT INTO usa_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","keqnáámmá máqtemma aúpáqá wái-qtataaqa abarokáqá aurániye. máqtemma kumayupí wái-qtataakaq ómmá kamá yupayo ínata aónanoe. ");
INSERT INTO usa_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","aáqa wáina-nakoma itaíno!” téna tiráiye: ");
INSERT INTO usa_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","“máqtemma itaígómá arupú umá ítáaro! náaraq umá-yataarabi améqa mimórá-yátááqá mayánóe. mú mikákáa umá mayánóe. ");
INSERT INTO usa_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","ááqibo móra-nakoma taíbaq-yataaqa wáinanama keqnáámmá taíbaqa mayániye. ááqibo móra-nakoma íma wáinanama ímaya inana wení kéqokeq-yataaqa káqo-wama mayániye.” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Îtu óq-aimma tiráiye: “Áánûqtuma kawáá kéi-maruqa nóikaa-maruraq wáiyo? maaráuma wáiye. ááqibo móra-nakoma ayummá yópáqá iyaabítaaqa uréna ayúkóní óq-mayaima íkemayaiye. ");
INSERT INTO usa_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","nokáámma waguréna wágááma itó-uma uréire kéena ayummá paá kéitorena anómma kéumitana maan-nákómá íma ítaraiye. náaraq umá pááq kéiyo? ");
INSERT INTO usa_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","maragómá wenamáárîq áwáqnaa itana karaa-qtatááqá kéitorena arammá kéiyena émma áqnáabaqa árûma kéutena anaaékaqa anómma aurániye. áqnáabaqa pááqyamma kéutena mú mikáq kéuyena anómma múkáurena arámma kéiyaiye. ");
INSERT INTO usa_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","naí-kánáámá arammá ábuma kamágitana kégaraiye.” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","óq-aimma tiráiye: “Áánûqtuma kawáá kéi-maruqa nóikaa-maruqa wáiyo? minnáyaba waéqma itaí-áímmá nóine ténúnô? ");
INSERT INTO usa_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","maará kéiye. pááqyan-ayumma marabí ukáitana ");
INSERT INTO usa_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","anaaékaqa anómma yaaráá umá itoráinata anón-amama yáinata numamá iréta ánáamma amaraqá kéoe. Áánûqtuma kawáá kéi-maruqa miráráá kéena wenôpaqa mirá kéiye.” ");
INSERT INTO usa_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","téna wemá abarokáq timá yímikena maami waéqma itaí-áímmá taíbaqa timá yímikaitata ááqibo waayúkama ítáawanama wemá timá yímikaiye. ");
INSERT INTO usa_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","ááqibo paá waéqma itaí-áípí timá yímikena ááqibo káqoyu yiyuwéna wení iyápó-annagaraqa máápaq-urena waéqma itaí-áíkóní áaimma abarokáq timá yímikaiye. ");
INSERT INTO usa_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","aabaúmá karáákáq kúmitana Îtuma tiráiye: “meran-ábápáq-ágínáúpáqá kó-onataae!” titata ");
INSERT INTO usa_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","yaayorupamá paá máqe-uraawata waabáqtábá naaúpaqa kóoro timátuweta iyápó-annagaraq Îtugaraqa nópí-káárébí péketa wekáráq awîqmeta kóuraae. káqomma óq-nopi-kaarema yeráwáqtê urááe. kégowana ");
INSERT INTO usa_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","yaugikómá anón-uwaama kéyoraitana karááqtoqa ôriq umá kéitana káárenobaqa nokómá ôriq umá ya kéogiraitana ááqibo ");
INSERT INTO usa_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Îtuma nópí-kárégóní ayárepaqa kunúraqa aú waguráitata awáutureta tirááe: “tiráátinako, képuyunataama arummá íyaq kéiyo?” tewana ");
INSERT INTO usa_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","itó-urena nokóqtábámá tiráiye: “paá mááo!” titana uwáágoma ánatagena paá yaákare wáqe-uraiye. wáqe-uraitana ");
INSERT INTO usa_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Îtuma tiráiye: “nôraq itanáq táaqa karáiyo? nôraq itaráq tirunóbáqá íkéitaao? íyaq tágaguraiyo?” titana ");
INSERT INTO usa_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","yáaqa paá kégaitata tirááe: “maan-nákómá náawabiyo? wemá timá yímikaitata uwáágoma nokógáráq kaqtó urááye.” téta tirááe. ");
INSERT INTO usa_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","nokaayúkóní meran-ábápáq-ágínáúpáqá iréta Kerátínêti-marukaqa irááe. ");
INSERT INTO usa_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","irááwana Îtuma nópí-káárébíké yáubaraitana móra-nakoma máátíq-máatiq-murianobake yáubarena min-nákómá kuti-áágógáráqá máqe-urena aíboqnaaboqa uréna ");
INSERT INTO usa_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","máátíq-máatipaqa kéwaitata waayúkama kanaaráqá ánnáma íkégutomiye. ");
INSERT INTO usa_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","ááqibo waayúkama akoqnáá-annagaraqa kútówana wemá paá yarákéna máqten-annama wemá akoqnáá mú mikákáámmá máqe-urena máqte-kayukama wemá imaamumá mú mikákáámmá máqe-uraitata waayúkama wemmá íma kanaaráqá yáqtoqma áyabaa kéomiye. ");
INSERT INTO usa_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","wágááraqa nokáákaraqa wemá anubaqá muríánóbáqá uréire kéena wááqa kéyena óqtanapo wenamáárîq kégaraiye. ");
INSERT INTO usa_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","ááqibo wemá ayáqtáákake Îtumma káonena kabe-kabe umá uréna araayukaqá yó peréna ");
INSERT INTO usa_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","akoqnáá-aagaraqa tiráiye: “Îtuo, emá Áánûqtuni áanikoma máane. Áánûqtu wemá mú mikákáá utái-manikoma máiye. kemmá nôna umátikainono? ketí anónnáma ítimiyo! ítikamuwo!” ");
INSERT INTO usa_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","miráuma kétitana Îtuma tiráiye: “kuti-áágô, wenaúnobake yáubaao! ");
INSERT INTO usa_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","enáwîqa náawabiyo?” titana “netuqyaa máunaboataa ketíwîqa Waabámáunatae.” téna ");
INSERT INTO usa_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","tiráiye: “maakáqá mánataa máunatae. káqo-marabaqa kóiyaba íkétikaitaae ítaa timátikao!” titana ");
INSERT INTO usa_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","taíbaq-poma anuraqá kénaawana ");
INSERT INTO usa_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","wemá tiráiye: “timá tíminataa mi-pógóní íyaqnobaqa pékonunatae.” titana ");
INSERT INTO usa_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Îtuma tiráiye: “pékoro!” titata yáubareta pógoni íyaqnobaqa pékaawata máqte-pogoma tiyáápa-wayuka áíyayaa-poma (2,000-poma) aítabaqa péketa nopí péketa pukurááe. pukurááwata ");
INSERT INTO usa_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","pórawaqti yiboámá kaba-kabe umá kóureta máqte-kayukama timá yímikaawata waayúkama aón irááe. ");
INSERT INTO usa_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Îtunopaqa irááwana kuti-áágómá naayóbáqá wepí máqe-urai-nakoma unáákáqtôgaraqa maraq máqe-uraitana aákoma kanaaráqá uráitata káonaawana yemá yáaqa kégaiye. ");
INSERT INTO usa_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","ko aónatuweta ye-káyúkámá kuti-áágógáráq-nákóqtábámá pógoqtabama timá yímikaawata ");
INSERT INTO usa_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Îtumma timá ámikaae: “ketááí timáápake kóaao!” tewana ");
INSERT INTO usa_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Îtuma nópí-káárébí kéberaitata kuti-áágógáráq máqe-urai-nakoma tiráiye: “etê kóonaare.” titana ");
INSERT INTO usa_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Îtu tiráiye: “ímiye. enamáápaqa ení waayúkagaraqa yauweré kóaao! uyátárai-nakoma emmá umákai-qtataaqtaba timá yímiyo! wemá íráqôniq úmákaitaba timá yímiyo!” titana ");
INSERT INTO usa_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","kóurena tiyááka-naa-marupaqa uréire uréna Îtu nôrabi umákaiqtabama timá yímikaitana máqtemma ítaraawana yáaqa karáiye. ");
INSERT INTO usa_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","ááqibo Îtuma móragaraqa meran-ábápáq-ágínáúpáqá iráitata waayúkama yaayorupamá nokaayúkóní agínaupaqa wenôpaqa áíkutaae. ");
INSERT INTO usa_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","áíkutaawana móra-nakoma Yááírati aapinaan-nááópáké anó-naqa iréna Îtumma káonenama arupi yauwaguréna ");
INSERT INTO usa_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","tiráiye: “ketiyáámûkoma képukiye. emá ayáánapo ánêkukuqa inanamá érákainana atóbena paá mániye. miráuma yínónô?” titana ");
INSERT INTO usa_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","wegáráqá kóuraiye. waayúkama ôriq umá yayorupamá wenanaaépaqa wakéta wekáqá áíkutaawana ");
INSERT INTO usa_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","móra-inikoma naaegárímá títaupake kaayaq-kárítímáátíráqá ákaraitana ");
INSERT INTO usa_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","netuqyaa-tótáá-wáyúkámá óqtamma áwáqnaa íyábá yímimanibo karímá íma érákaitana paá mayáíq-mayaiq umá kémayaitanaboana wení óqtamma ánataguraiye. ");
INSERT INTO usa_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","ááqibo wemá Îtuqtabama ítárena yaayoruparáá-kayukagaraqa ya máena aúyánánóbáqá ítaraiye: ");
INSERT INTO usa_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","“Îtuni unáákáqtômma ánêkukuqa onanamá ketí karímá étikaniye.” téna wení unáákáqtômma ánêkukuqa uráitana ");
INSERT INTO usa_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","naaegómá páátákáá káqnáguraitana wenaúnobaqa wení karímá atóbaguraiye téna ítaraiye. ");
INSERT INTO usa_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Îtuni imaamugómá kóuraitana ítarena tiráiye: “náawa ketí unáákáqtôraqa ánêkukuqa uráiyo?” titata ");
INSERT INTO usa_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","wení iyápó-anna-wayukama tirááe: “yaayorupamá áíkutaawa yimónarema nôraq itaa tirááno? ‘náawa ánêkukuqa uráiyo?’” tewana ");
INSERT INTO usa_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Îtuma paá abáá-urena ánékukuq-nakoma aónane ínana ");
INSERT INTO usa_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","aaragómá karímá atóbamakaraitana ítáimma karáitana aqtete kéena aúbáq arupi yauwaguréna máqte-qtaqtaaqa Îtumma timá ámikaitana Îtu tiráiye: ");
INSERT INTO usa_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","“ketiyáámûko, ení áyaqa timí-yátáákómá arunóbáqá ítaraanaboana ení karímá érakaraiye. kanaaráqá kóaao! ení karímá ánatagiye.” ");
INSERT INTO usa_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","kétitata waayúkama Yááíratini naaópake iréta timá ámikaae: “enayáámûkoma pukuráiye. aúba-naqtaba ibáqyuwaao téq timá ámiyo.” tewana ");
INSERT INTO usa_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Îtuma yetí watáama ibáqyukena tiráiye: “áaqa ígáino! áyako tágagino! arummá amíno!” ");
INSERT INTO usa_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","téna tébakaq-wayukayabama tiráiye: “máaro! tinaaépaqa íma yeró!” titata Pítaa Yêmitigaraqa Yóáanegaraqa wenanaaépaqa kóuraae. ");
INSERT INTO usa_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","kóureta aapinaa-nááópáke anó-nakoni naaópaqa irááwata waayúkama wááqa kéowana aónaraitata anókaqa ibiqá kéyaraae. ");
INSERT INTO usa_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","naaúpaqa pékena tiráiye: “nôraq owata wááqa kéyoo? nôraq owata ibiqá yáráánabiyo? iyápóma íma pukuréna paá aú waguráiye.” titata ");
INSERT INTO usa_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","waayúkama kaaqaari kétene téta wíraama urááwana tiráiye: “máápaqa yáubaaro!” téna iyápógoni aboágáráqá anóagaraqa Pítaagaraqa Yêmitigaraqa Yóáanegaraqa inaarúgómá wayákáa uréta ");
INSERT INTO usa_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","wení ayáákaqa yáqtokena tiráiye: “tarítá kúmi!” maa-kátáágóní áaimma miráuma kétiye: “inaarúgô, ké kétupo itóaao!” ");
INSERT INTO usa_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","titana itó-urena uréire uráiye. anómma aúkurainaboana (12-karitimaatima) uréire uráitata waayúkama páátákáá yáaqa ôriq umá karáitata ");
INSERT INTO usa_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Îtu akoqnáá umá tiráiye: “waayúkama ítima-yimero.” téna timá yímikaiye: “maan-ínáárúmá aáwaqa amiyo!” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","mikáké kóurena wenamáápaqa iráitata wení iyápó-annae wenanaaé wakááe. ");
INSERT INTO usa_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","ááqibo Tabaatiráqá aapinaan-náúpáqá wemá aapinaammá kétima-yimitata netuqyaa-káyúkámá ítáawana yáaqa kaitata tirááe: “maan-nákómá náakakenaq maan-áápínáámmá matáiyo? nóikaan-itaigoma ámitanaq matáiyo? náaraq umáwaq anón-awaameqa wenayáánapo kémaiyaiyo? ");
INSERT INTO usa_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","wemá káámûqtaa-naqiye. Máríaani áanikoe. wenábâkon áwîqa Yêmiti Yóteti Yúqtaati Tááímonigaraq wáiye. wenáukoyaama ketáágáráqá kémaae.” téta weqtábámá áá awááguraawana ");
INSERT INTO usa_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Îtuma tiráiye: “Áánûqtuni watáá-wataa-nakon áwîqa máqte-mapaqa anómma uwíniye. ááqibo wenamáápaqa wení wáátigogaraqa wenánnágáráq kíkaqa anómma íma kéuwiye.” ");
INSERT INTO usa_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","téna mikáqá wemá anón-awaameqa kanaaráqá íma maténa ááqibo pááqya-kari-wayukama ánêkukena yetí karímá atóbamayikaiye. ");
INSERT INTO usa_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","ááqibo waayúkati yíyako íma tágaguraawana yeráwáqá irummá íma ítáraapoana Îtuma karáitaiye. anaaékaq káqo-kaqo-marupaqa aapinaammá ko kétima-yimiye. ");
INSERT INTO usa_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","wení iyápó-annama títaupake kaayaqá yááyaraitata kaaya-kaaya umá kówana timáyíkaraiye. kuti-áágómmá kanaaráqá waqtuwaígáae téna imaamumá yímikena ");
INSERT INTO usa_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","tiráiye: “koéqa taíbaq ímáyáaro! paá yáumma mamé kóoro! kamááma unáámmá óqtamma íma mayéra paá kóoro! ");
INSERT INTO usa_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","maqné-áítáúq-ánáámá kanaaráq éra ááqibo kímora kúberai-unaakoqtoma kúberaaro!” téna ");
INSERT INTO usa_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","timá yímikaiye: “móra-naupaqa peréqa mi-márúkáqá maéq mi-nááúpáqá wáero. ");
INSERT INTO usa_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","ááqibo móra-marukaqa waayúkama íma agoyáá umátiketa keráwáqtí wátáama íma itétama mi-márágóní kaítôgomma títaupike ayúmóro. ayúqtuwaiyanama yetí negi-yáqtááqá paá wániye.” ");
INSERT INTO usa_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","titata kóureta abarokáqá tirááe: “waayúkao, keráwáqtí kebó-yátáápíké waérááro!” téta ");
INSERT INTO usa_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","taíbaq-kuti-aagoma waqtukéta netuqyaa-kárí-wáyúkáma matawékaraqa péketa atóbamayikaraae. ");
INSERT INTO usa_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","maannááyaba Érôti anómma yabíkái-nakoma ítaraiye. Îtuni áwîqa anómma utáitana ítaraiye. yaímma-wayukama tirááe: “Yóáane nommá peraí-nákómá pukuráipike itó-urena imaamugárágá kéiye.” tewata ");
INSERT INTO usa_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","yaímma-wayukama tirááe: “Íráíyamiye.” tewata tébakaqa tirááe: “naayó-kátáá-wátáá-nákáánákómá wemá watáá-wataa-naqa máiye.” tewana ");
INSERT INTO usa_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Érôti ítarena tiráiye: “Yóáanema kemá aqnómmá arákáunana wemá keqnáámmá itó-uraiye.” ");
INSERT INTO usa_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","téna aáqa ítarena aanibo wemá wení waayúkama Yóáaneqtabama naayóbáqá timáyímikaitata uréta Yóáanemma yáqtoqma kaarabútibi ánnáma kútaane. miráipoana Yóáane kaarabúti matáiye. Érôtini ábâkoma Píripini ánáakoma Erótiati Érôti yabitimá moyámmá matáitana minnáyaba ");
INSERT INTO usa_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Yóáane naayóbáqá tiráiye: “enábâkoni ánáakoma yabitimá mayáánabo! ímayaao!” ");
INSERT INTO usa_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","miráipoana Erótiatini áyámma itana Yóáanema ikámma puínéna kéiye. ááqibo íma kanaaráqá ikamíniye. ");
INSERT INTO usa_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Érôti Yóáaneqtabama áaqa kégaitana Yóáaneni kateko-ááítábámá ítaraitana aokaq-náré téna ítaraipoana Érôti kawáá umákaraiye. Yóáaneni watáa ítaraimma áaqa kégaitana amukaráq maqmá kéitaiye. ");
INSERT INTO usa_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","mi táoqa Érôti wení marákárai-kanaayaqa óniqa kauténa wení maqné-wáyúkáyábámá mú mikáq anó-kayukayabama Kááriribake anó-kayukayabama kaumá yímikaitana ");
INSERT INTO usa_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Erótiatini ayáámûkoma imá yamáyíkaitana Érôti amuqá marakéna tiráiye: ");
INSERT INTO usa_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","“emá akáinaama ítama timónaao! ítama timónenaqa aménúne. kemá yabíkáuna-yataaqtaba tínaqa aúkáapike aráqma mórabaq aménúne.” téna tiráiye: “máqtemma ítama timónenai-yataaqa aménúne.” titana ");
INSERT INTO usa_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","wemá yáubarena anóama ítama aónaraiye: “nóiqtabawaq timiyó ténúnô?” titana anóama yauwéqma tiráiye: “Yóáane nommá peraí-nákóní aqnóné.” titana ");
INSERT INTO usa_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","ayáámûkoma páátákáá kóéna Érôti máipaqa iréna ítama aónena tiráiye: “Yóáane nommá peraí-nákóní aqnómmá táápepi timíyábá kétikaiye.” titana ");
INSERT INTO usa_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Érôti arummá ôriq umá kéitana ááqibo namuq-wáyúkátí yúbáq wenáama tiráinapoana íma kaaqaarí téna ");
INSERT INTO usa_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","páátákáá wení kawáá-náqá timá ámikaiye: “aqnómmá ko mamé iyo!” téna timákáitana kóurena kaarabútibike aqnómmá ko aráqmena ");
INSERT INTO usa_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","táápepi mamé iréna inaarúgómmá má ámikaitana inaarúgómá anóamma ámikaiye. ");
INSERT INTO usa_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","miráitata Yóáaneni iyápó-annama ítátuweta iréta arááq-auma ya matéta máátiq-máatiq-muriapi mó-uqtamakaraae. miráuma Érôti aákaqa makéna Îtuqtabama tiráiye: “Yóáane pukáipike itó-uraiye.” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Îtuni iyápó-annama wenôpaqa yauweréta máqteniq aráátababi máqten-aimma timá yímikaataba timá ámikaae. ");
INSERT INTO usa_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","ááqibo taíbaq-wayukama kéyewata Îtuma wení iyápó-annagaraqa aáwaqa íma kanaaráq naráámiye. íma narááwana Îtuma iyápó-annama timá yímikaiye: “kenamáataa káqopaqa ayáqtáákaqa ónúnatae. keráwáqá aagaq-naagáq téq mikáq aagaínoe.” titata ");
INSERT INTO usa_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","nópí-káárébi yenamáa Îtugaraq kaqmáápaqa kóuraae. ");
INSERT INTO usa_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","ááqibo kéowata taíbaq-wayukama yimónareta yeqtábámá ítareta máqte-marupake marabí yó-yo umá yetí áqnáabaqa kaqmáápaqa irááe. ");
INSERT INTO usa_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Îtuma nópí-káárébíké marabí kukénama netuqyaa-wáábámmá kéyimonena arummá umayíkaraiye. yetí yabi-í-náqá íma máitata tipi-típiraa umá mááwana miráuma yimónarena netuqyaan-áápínáámmá kétima-yimiye. ");
INSERT INTO usa_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","aaqá ékitata wení iyápó-annama iréta tirááe: “aaqá kéekibo kaqmáápapoana ");
INSERT INTO usa_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","emá timá yíminata kó éta aáwaqa naa márûpake ko meyámmá máyáaro.” téta tewana ");
INSERT INTO usa_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Îtu tiráiye: “keráwáqá aáwaqa yímero!” titata yemá ítama aónaraae: “nóinapi aáwaqa meyámmá mayánúnataabiyo? kaayaq-tíyááká-wáyúká aíyayaan-oqtakoma (200-kína) íumaataraiye.” tewana ");
INSERT INTO usa_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Îtuma tiráiye: “yammá nôraq umá wáiyo? ko aónaaro!” titata aónatuweta timá ámikaae: “morá-tiyaapaq-yamma kaayaq-nóyáákáráqá wááe.” ");
INSERT INTO usa_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","tewana Îtuma wení iyápó-annama timá yímikaiye: “máqte-kayukama áápêpaakaqa maraq máero téra timá yímero!” titata ");
INSERT INTO usa_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","araamá máqe-uraae. yaímma-wayukama tiyááka-wayuka áíyayaakaraqa (100) maraq mááwata yaímma-wayukama kaayaq-áíyáyáákáráqá tiyáákagaraqa (50) máqe-uraae. ");
INSERT INTO usa_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","mááwana Îtuma móra-tiyaapaq-yakaraq kaayaq-nóyáákáráqá maténa wíyôkaqa karáqma káonena amuqá makéna nunamupí “tíkáiye” tiráiye. tiréna yammá kíqtíraaq umá wení iyápó-annama yímikaitata yemá waayúkama yímikaae. kéqnáámmá kaayaq-nóyááqá yáíkaaq umá yímikaiye. ");
INSERT INTO usa_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","yakaráq noyáákaraq yímikaitata máqte-kayukama nátuweta yímûqa yaitata ");
INSERT INTO usa_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","wení iyápó-annama yuqáan-aqto-atoma aíqma aíqturaawata títaupake kaayaq-únámmá ógiqma aíqturaae. ");
INSERT INTO usa_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","yagaroqtamá naa-káyúkámá títaupake kaayaq-wáyúkámá naikamá tiyááka áíyayaa-kayukama narááe (5,000). ");
INSERT INTO usa_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","natúwáawana Îtuma páátákáá wení iyápó-annama timá yímikaiye: “nópí-káárébí Beqtáirapaqa meran-ábápáq-ágínáúpáqá áqnáabaqa kóoro! kemá anaaékaqa yénúne.” téna waabá-káyúkámá timá yímikaiye: “kóoro!” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","timátuwena anuraqá nunamummá mú tiráiye. ");
INSERT INTO usa_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","enáinobaqa iyápó-anna-wayukama nópí-káárébí nokaayúkóní aúkáapimma mááwana Îtuma wenamáa iyuwéna marabí máqe-uraiye. ");
INSERT INTO usa_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","uwáágoma ôriq umá kéyoraitata wení iyápó-annama nópí-káárébí íma kanaaráq kéowana Îtuma yimónarena nokáá-nokaamma non ánanaakaqa yeqtôpaqa kéyena yátamakitata káonaawana ");
INSERT INTO usa_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","50","yáaqa kégaitata ikatîqa kéeta yúyánánóbáqá “waátáe!” tirááe. yurááwana Îtuma páátákáá tiráiye: “ké kéyune. táaqa ígáino!” téna ");
INSERT INTO usa_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","nópí-káárébí yetê pékaitana uwáágoma yoqmá ánataguraiye. iyápó-annama yáaqa ôriq umákaitata yúyánákó taítawaa kéiye. ");
INSERT INTO usa_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","yakaq awaaméqá in-ááímmá íkéitaawana yetí yáakoma ummaamá ôriq uráiye. ");
INSERT INTO usa_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","nokaayúkóní meran-ábápáq-ágínáúpáqá iréta mararáqá Kénnétáaretibaqa yáá amakéta nópí-káárémá ánnáraqa kútaae. ");
INSERT INTO usa_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","nópi-káárébíké yáubaraawata waayúkama páátákáá Îtumma káoneta ítaraae. ");
INSERT INTO usa_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","ítareta máqte-marukaqa uréta karí-wáyukámá kúkutaaraqa maréta maméta Îtu máipaqa irááe. ");
INSERT INTO usa_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","máqte-mapaqa Îtuma uréire uráipaqa naa-márûkaqa yópáqá máqtepaqa waayúkama yetí karí-wáyúkámá meyámmá kémayai-marukaqa mamé iréta egaa aéta tirááe: “ayúwénata ení wáqtôraqa karí-wáyúkámá ánekuyoro!” tewata máqtemma ánêkuyowana yetí karímá éqyíkaitata atóbaguraae. ");
INSERT INTO usa_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Pérati-wayukama yaímma aamá aúmakaan-aimma ítaraa-kayukagaraq Yérútáárebake iréta Îtunopaqa áíkutaae. ");
INSERT INTO usa_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","yaímma Îtuni iyápó-annama iyáámma íma tete éta aáwaqa kénaawata yimónaraae. ");
INSERT INTO usa_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","ááqibo Pérati-wayukagaraqa máqtemma Ítíráaeo-wayukagaraqa yetí yítaubikoma timáyímikaawata iyáámma íma kateko umá tete étama aáwaqa ínewaomiye. ");
INSERT INTO usa_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","keqnáámmá aáwaqa meyámmá matéta íma tete étama ínewaomiye. yítaubikoma taíbaq aammá aúkai-kataama yímikaawata yemá mirá kéoe. táápeqa tete íyábá nawimmá tete íyábá taawemá tete íyábá kéqokeq-yaqtaaqa tete íyábá miráuma tete kéoe. ");
INSERT INTO usa_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","miráitata Pérati-wayukama aamá aúmatan-aimma yirááti-kayukagaraqa Îtumma ítama aónaraae: “nôraq itata ení iyápó-annama ketááí-títaubikoni aamá íkeiteta iyáá-paigaraqa kénaao?” tewana Îtu yauwéqma tiráiye: ");
INSERT INTO usa_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","“Áítáíya keráwáqtábámá áraimma tiráitaq kaaqaari-wáyúkámá mááe. naayóbáqá wemá miráuma agatáiye. Áánûqtu kétiye. ‘maa-káyúkámá paá yóyaukake tíwîqa múte kéyauyoe. yetí yirummá ketôpaqa íma kémaraae. ");
INSERT INTO usa_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","aamá aúmatan-aimma waayúkama ye túyánápíké kétiraatewaq yeráwáqá Áánûqtuni aamá aúmatan-aikaa kéitaae. miráipoana ketíwîqa múte yawíyawaigoma yíwáqnaa kanaaráq íiniye.” téna agatáitata ");
INSERT INTO usa_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Îtuma tiráiye: “keráwáqá Áánûqtuni aammá aúkai-qtataaqa keráwáqtí tinaaépaqa yuwéq wáátigoni maníqá paá yáqtoqme kéoe.” téna tiráiye: ");
INSERT INTO usa_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","“keráwáqtí maníkóní watáama yáqtoqme kéeta Áánûqtuni watáama yuwéta íkeitaae. ");
INSERT INTO usa_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","naayóbáqá Móteti tiraíye. ‘enabommá enanókaraqa kaayoné umá yíwîqa múte yauyuwo! kaqtó umá yabíqyikaao! ááqibo móra-nakoma wenaboqtábámá wenanóqtabama táí-aimma tínanama arááqa ikamínana puíniye.’ tiráitaq ");
INSERT INTO usa_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","ááqibo keráwáqá kétee. ‘móra-nakoma wenaboqtábábi wenanóaqtabama timá-yimena ‘kemá íma kanaaráq timénúne. timúna-yataaqa tíwaqnaa-yaqtaaqa kóbaanie. Íbaru-aipi kóbaani wenáaimma mirá wáiye Áánûqtunnae.’ mirá ténama ");
INSERT INTO usa_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","aboámmá íma yíwáqnaa íniye. ");
INSERT INTO usa_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","keráwáqá Áánûqtuni watáama kéyuweq keráwáqtí aamá aúmakaan-aikaraq kéyuwaae. maami wáí-qtátáárîqa taíbaqa kéoe.” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Îtuma waabámmá wenôpaqa yááyarena timá yímikena tiráiye: “ítáaro! ");
INSERT INTO usa_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","máqte-qtaaqa arunóbáqá koínama íma kanaaráq táíq éna ááqibo arunóbáké yáubatuwena yáwína-yataakoma minnáma táíq kéiye. ");
INSERT INTO usa_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","taáqa wáinaaqa ítáaro!” tiréna ");
INSERT INTO usa_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","waabá-káyúkáyôpake kóurena naaúpaqa pékaitata wení iyápó-annama ítama aónaraae: “maa-kátáágón áaimma nóinabiyo?” tewana yauwéqma tiráiye: ");
INSERT INTO usa_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","“tébakaq íma ítáane umá íyaq keráwáqá ítaraao? ");
INSERT INTO usa_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","ááqibo máqtemma kégumibo paá áyapi kégumena miráipoana ayábopike kéyutugiye.” miráuma Îtuma tiráiye: “máqtemma naí-yáqtááqá kanaaráq nánoe.” ");
INSERT INTO usa_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","móragaraqa tiráiye: “arunóbáké yáubagurai-qtataaqa waayúkama táíq umá kéyiraatiye. ");
INSERT INTO usa_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","aúpáq arunóbáké táí-auyanamma iténa kebó-yátáákárîq kéena moyámmá kémayena waayúkama kéikamena ");
INSERT INTO usa_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","aaramá moyámmá yabitimmá kémayena aúrananna káena taíbaq-kumiq-yaqtaaqa wáitana kaaqaari kétena negígómá kéena kéwakarena áwîqa yama aráápena táí-weganokanoqa kéen ");
INSERT INTO usa_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","maami-kútí-yátáákómá waayúkagoni arunóbáké kéyaubena waayúkama táíq umá káraatiye.” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Îtuma kóurena Tááya-marukaqa iréna móra-naupaqa pékena wemá máitata yemá aónaiyaba íkákaiye. ááqibo aúpáqá íma kanaaráq máqe-uraiye. ");
INSERT INTO usa_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","móra-inikoni ayáámûkoma kuti-áágógáráqá máitana min anóama Îtuqtabama ítarena páátákáá wenôpaqa iréna Îtuni aítaupi aípaq aguráiye. ");
INSERT INTO usa_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","min-íníkómá íma naaóq-inimibo wemá Pinítia Tírîabake iréna mibáqá wenanóama marákáraitana mibáké iréna Îtuqtabama egaa aráiye: “ketiyáámûkoni arupiké kuti-áágómá waqtuwaao!” titana Îtuma tiráiye: ");
INSERT INTO usa_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","“ááqibo áqnáabaqa naaópaq-iyapogotaa aáwaqa yímiketae. iyápógoni aáwaqa mamá iyákómá amíyábá minnáma íma íráqô-qtataaqiye.” téna tiráiye min-íníkómá tiráiye: ");
INSERT INTO usa_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","“téna. ááqibo iyán áráaqa yaare-aménáápáqá maéta iyápógoni aáwaqa araaqtáma ábûpuma kénaae.” titana ");
INSERT INTO usa_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Îtuma tiráiye: “kateko-áímmá tiráánaboana kuti-áágómá enayáámûkoni arupiké yáubagina ení naaópaqa kóaao!” titana ");
INSERT INTO usa_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","wení naaópaqa kóurena ayáámûkoma aónaraitana wemá waí-yááréráqá kanaaráq máitana kuti-áágómá arupiké yáubama ánatama kóuraiye. ");
INSERT INTO usa_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Îtuma Tááya-marupake Tááíranabaqa kóurena Tááíranabake Kááriri-nokaayukaqa iréna Tekááporitipake tiyááka-marupakene iráiye. ");
INSERT INTO usa_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","iráitata tébakaq-wayukama aíbôq-naqa awíqme Îtunopaqa irááwana wemá aamá íkéitena íma arupú umá kétitata egaamá arááe: “ayáánapo ánêkuinanama atóbamakaniye.” tewana ");
INSERT INTO usa_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Îtuma wegáráqá waabápíké áwîqme kóurena ayáán-amama min-aíbóq-nákóní áárarapi makéna wiráátima wikéna amáábîraq ánêkukena ");
INSERT INTO usa_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","wiyôkaqa aónarena karagíkáráqá yumákáraiye: “yarótáyakaao!” wemá Áárámê-aipike tiréna “íbaqta” tiráiye. min-áíkón áaimma aáqa yarótáyakao. ");
INSERT INTO usa_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","tiráitana páátákáá min-nákóní ááraramma yarótáguraitana óyauqa oyaaq uráitana wemá aamá kanaaráq kétiye. ");
INSERT INTO usa_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","miráitana Îtuma akoqnáá umá timá yímikaiye: “atóbamakaiqtabama ítima-yimero!” titata máqtemma abarokáqá anókaqa timá yímikaiye. timá yímikaitata ");
INSERT INTO usa_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","máqte-kayukama ítáawanama yáaqa karáiye. yáaqa ôriq umá karáitata tirááe: “wemá máqte-qtataaqa katekoîq kéiye. aíbôqnaaboq-nakoma timá ámikaitana aamá kéitena kanaaráq kétiye.” téta tirááe. ");
INSERT INTO usa_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","pááqyamma anaaékaqa káqomma waabámmá anómma áíkutaae. áíkutaawana yetí aáwaqa ánataguraitana Îtuma wení iyápó-annama yááyarena tiráiye: ");
INSERT INTO usa_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“maa-káyúkáyábámá tirummá kéumayikaunaboata ketê kaumo-yúpáámá máqe-ureta aáwaqa íkénaawaqa ");
INSERT INTO usa_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","kemá timá yíménatama naaópaqa! kóétama ayáqtáákaqa kéyepoaqa aáwaqa íma yíménatama yúnááímmá ínóe.” titata ");
INSERT INTO usa_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","wení iyápó-annama tirááe: “kááyûq-mapaqibo taíbaq waqmé o-káyúkámá náakakena miráuma-aawaqa taíbaq mamá yiménúnataabiyo?” tewana ");
INSERT INTO usa_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Îtu tiráiye: “ení yammá nôraq-umabiyo?” titata “abapaké kaayaré.” téta yauwéqma ");
INSERT INTO usa_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","tewana Îtuma “maraq máaro!” timá yímituwena mi-qtámmá abapaké kaayaqá maténa nunamupí Áánûqtuqtabama amuqá makéna “tíkáiye” tiréna kíqtíraaqa uréna wení iyápó-annama yímikaitata waabámmá yímikaae. ");
INSERT INTO usa_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","keqnáámmá noyááqa yakaráqá maténa nunamupí “tíkáiye” tiréna iyápó-annama yímikena timá yímikaiye: “yímero!” titata yímikaae. yímikaawata ");
INSERT INTO usa_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","máqtemma nátúwáawana yímûqa yaráiye. taíbaq-wayukama títaupake kaayaq-wáyúká-áíyáyáámmá (4,000) nátúwáawata ");
INSERT INTO usa_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","iyápó-annama ábûpuma araaqtáma abapaké kaayaq-únápí aíqturaawana Îtuma timá yímikaiye: “naaópaqa kóoro!” ");
INSERT INTO usa_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","timátuwena nópí-káárébí iyápó-annagaraqa péketa Táámánûtaa-marupaqa kóuraae. ");
INSERT INTO usa_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","tébakaqa Pérati-wayukama utéta aagaren áimma kéteta ítama aóna-aona urááe: “wíyôkakena-awaameqa tiráátiyo!” tewana ");
INSERT INTO usa_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Îtuma karagíqa kéyena tiráiye: “nôraq itata íbêq-wayukama aati-aatimá ‘awaaméqá timiyo!’ kéteo? ké kétune awaaméqá íma yiráátéq íyimenune.” téna ");
INSERT INTO usa_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","yeqtôpake yiyuwé kóurena nópí-káárébí móragaraqa pékena yanaapáq agínááúpáqá kóuraiye. ");
INSERT INTO usa_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","15","Îtuni iyápó-annama aáwaqa yiwikáqtuweta yewana kímora-yamma nópí-káárébí wáqe-uraitana Îtu tiráiye: “keráwáqá Pérati-waayukati yammá itoraí-yátáákáraq Érôtini yammá itoraí-yáqtááqtábámá aónama kawáá oro!” titata ");
INSERT INTO usa_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","minnáyaba watáá-wataa yé-íyáá tirááe: “nôraq itanáq mirá kétiyo? yammá íma wáitana mirá kétiye.” tewana Îtu yetí watáayabama ítarena ");
INSERT INTO usa_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","tiráiye: “nôraq itaráq yammá íma wáiqtabama watáá-wataa kéteo? íyaq ítaraao? póraanabono? aíbôqnaaboq kéoo? ");
INSERT INTO usa_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","túramma wáimma íyaq káonaao? tááraramma wáimma íyaq kéitaao? íyaq taákaqa makááo? ");
INSERT INTO usa_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","kemá móra-tiyaapaq-yamma taíbaq-waayukama kíqtí-giti umáyíkaraupo nôraq umá unáápímmá tébakaq aqtó-ááwáqá aíturaao?” titata “títaupake kaayaré.” téta yauwéqma tirááe: ");
INSERT INTO usa_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“ááqibo abapaké kaayaq-yámmá kíqtí-giti umáyíkaraunata nôraq umá unáápí abûpuma aíqturaao?” titata “títaupake kaayaré.” téta yauwéqma tirááe. tewana ");
INSERT INTO usa_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Îtuma ítama yimónaraiye: “paá íyaq arútama ítaraanabiyo?” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Béqtáirabaqa irááwata mikáqá tébakaq-wayukama aúramma karopágurai-nakoma áwîqme Îtunopaqa iréta egaa arááe: “emá ánekuinanama atóbamakaniye.” téwana ");
INSERT INTO usa_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Îtuma ayáákaqa yáqtoqma yabitimá márûpake áwîqme kóurena aúrapi wiráátima wiqmakéna ayáánapo ánêkukena ítama aónaraiye: “ára káonaano?” titana ");
INSERT INTO usa_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","min-nákómá káonena tiráiye: “kemá waayúkama yaaráá umá uréire kéowaq káonaune.” titana ");
INSERT INTO usa_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Îtuma móragaraqa aúrakaqa ayáámma makáitana íbêqa min-nákómá akoqnáá umá aónaraitana aúramma atóbamakarainana máqte-qtataaqa káonaitama ");
INSERT INTO usa_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Îtuma timá ámikaiye: “ení naaópaqa kóé! mi-márúpáké yéna márûpaqa móragaraqa íma yauweré iyo!” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","ááqibo Îtuma wení iyápó-annagaraqa Tétáríá Píripai-marupaqa kégoweta Îtuma ítama yimónaraiye: “timá tíméro! waayúkama keqtábámá nóinae kéteo! náawabuno?” titata yauwéqma tirááe: ");
INSERT INTO usa_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","“yaímma kétee emá Yóáane nommá pérakarai-nakoe kétewata yaímma emá Iráíya máane téta kétee. tébakaqa emá Áánûqtuni watáá-wataa-nakomone kétee.” tewana Îtuma ítama yimónaraiye: ");
INSERT INTO usa_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","“keráwáqá nóine kéteo? náawabuno?” titana Pítaa yauwéqma tiráiye: “emá Áánûqtuni aúyánámmá Metáíya máane.” titana ");
INSERT INTO usa_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Îtu timá yímikaiye: “keqtábámá waayúkama ítima-yimero!” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Îtuma mirá-timatuwena wení iyápó-annama miráuma kéyiraatena timá yímikaiye: “ké Waayúka-Araaqa máune. taíbaq-yataaqtabama tíqa íniye. ketááí anó-kayukama uyátáráa-monoq-wayukagaraqa aapinaa-káyúkágáráqá anaaéma umátiketa tíkamiyaqa pukónúne. púyónana kaumo-yúpáámá ánataginana tiwáutinaqa paá mánune.” ");
INSERT INTO usa_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","miráuma abarokáq titana Pítaa ítátuwena Îtumma áwîqme nékaqa mó áá awáágitana ");
INSERT INTO usa_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","ááqibo Îtu wení iyápó-annama yimónarena Pítaamma áá awááguraiye: “emá webó-náqá máane. ketinaaépaq yáwaao! enaúyánámmá paá waayúkagoni aúyánámíye. íma Áánûqtuni aúyánámíbo!” ");
INSERT INTO usa_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","timátuwena wemá wení iyápó-annama waabákáráqá wenôpaqa yááyaraiye. yááyarena timá yímikaiye: “ááqibo móra-nakoma akáínana tinaaépaqa yínénama wemá wení akáígómá awikátuwena yuwáino! wenáuma mamé uwí-yátááqtábá kéyuwenawaq wení máárîpuma múte kémayena tinaaé mamé yíno! ");
INSERT INTO usa_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","móra-nakoma paá mánaae ténama wení paá mái-yataaqa aúyoraniye. ááqibo móra-nakoma keqtábámá puyéna ketí átê-wataayabama puyénama wení paá mái-yataaqa mayániye. ");
INSERT INTO usa_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","ááqibo móra-nakoma máqtemma mararáq wái-qtataaqa matokáinanama wení paá mái-yataaqa aúyokinanama nôraq íníyô? ");
INSERT INTO usa_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","nóinapo wení paá mái-yataaqa móragaraqa meyánîq íníyô? ");
INSERT INTO usa_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","ketí watáayabama íbêqa kebó-yúpááráqá keqtábá agaemá ínaqa ké Waayúka-Araaqa maéqa weqtábámá kemá yéna-taoqa ketiboní tágagi-yataakaraqa wení aokaq-káqtó-wáyúkágáráq yéqa mikáq kemá tigaemá umákanune.” téna Îtuma ");
INSERT INTO usa_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","tiráiye: “taákaqa máráaro! tébakaqa maakáq itó-uma paá máa-kayukama íma puíyana Áánûtuma kawáá kéi-kanaama akoqnáágaraqa yínata aónéta puínoe.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","abapaké móra-wagaama pukitana Îtuma Pítaagaraqa Yêmitigaraqa Yóáanekaraqa yíwîqmena anón-anuraqa utéta yenamáa máneta urááe. mikáqá Îtumma káonaawana wemá káqowaraa aúkitata ");
INSERT INTO usa_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","wení unáákáqtôma waéqma tágagurena mú mikákáá wayámmá aúkitataa waayúkama tete umátúwáakakaatati íma miráuma wayákayana umá tágagine iné. ");
INSERT INTO usa_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","mirá umátuweta Iráíya Mótetigaraqa Ítugaraqa watáá-wataa kétewata yimónaraawana ");
INSERT INTO usa_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Pítaa tiráiye: “yirááti-nako, maakáq mánunataama iráqôniq kéinataa kaumo-námmá taróq onúnataama mórama ennáé. mórama Mótetinnae. mórama Iráíyanna tarôq onúnatae.” titana ");
INSERT INTO usa_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","yáaqa karáitata Pítaa tínîn-aimma íma ítaraipoana mirá-tiraiye. ");
INSERT INTO usa_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","ááqibo konnámá kukéna yemmá yawááq uráitana aagómá konnánóbáké tiráiye: “tíkái-ketaanikoma máiye. máinaraq wenáama ítáaro!” ");
INSERT INTO usa_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","yemá yúrapike abáá uréta Îtumma wenamáa aónaraae. ");
INSERT INTO usa_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","anuraké kukááwana Îtuma timá yímikaiye: “káqo-kayukama aónaraawaigoqtabama ítima-yimero! ááqibo kemá Waayúka-Araaqa pukuráipike awaútinana itoínaqa mikáq kanaaráq timá yímero!” titata ");
INSERT INTO usa_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","wenáama ítareta kaqtó uréta ááqibo maannáyaba watáá-wataa tirááe: “pukuráipike awaúturaigoma nóin-aainabiyo!” téta ");
INSERT INTO usa_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Îtumma ítama aónaraae: “aapinaa-káyúkámá kétee ‘Iráíya áqnáabaqa yíniye.’ nôraq itatáq mirá kéteo!” titana ");
INSERT INTO usa_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Îtuma yauwéqma tiráiye: “Iráíya áqnáabaqa kéyena máqte-qtataaqa yokaa-yokaa kéiye. ááqibo nôraq itana Waayúka-Araaqtabama Áánûqtuni agamátán-áípí mirá kétiyo? ‘wemá anón-aiqa mayáinatama waayúkama wemmá ayúqma ánatainoe.’ ");
INSERT INTO usa_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","titaqá kemá kétima-timune. Iráíya wágáábaqa iráinapoata waayúkama weqtábámá Áánuqtuni agamatán-áípí tiráiniq uréta máqte-qtataariq ónaae yíkái-qtataariq wekáq urááe.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","kukéta tébakaq iyápó-annaraqa irááwata anómma waabá-káyúkámá yeqtôpaqa áíkutaawata yimónaraae. aapinaa-káyúkámá Îtuni iyápó-annagaraqa aagaren áimma kétewata ");
INSERT INTO usa_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","waabámmá Îtumma káoneta iyánáaq umáreta uyaaté uréta agoyáá umákaraae. ");
INSERT INTO usa_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Îtu wení iyápó-annama ítama yimónaraiye: “nóiqtabama yegáráqá aagaren áimma kéteo?” titana ");
INSERT INTO usa_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","waabápíké móra-nakoma tiráiye: “yirááti-nako, ketáanikoma enôpaqa áwîqme uráunana wení arupi kuti-áágómá máitana aamá íketitana ");
INSERT INTO usa_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","kuti-áágómá yáqtoqma marabí kéyuwaitana wemá áwaayaamma agíkíqa kéitana óyaukaqa agaregómá ôriq kétena arááteru-teru kéiye. kemá ení iyápó-annama ítama aónaraune. ‘kuti-áágómá arupiké waqtuwánô téq itáunata kanaaráq íma waqtukááe.’” titana ");
INSERT INTO usa_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Îtu tiráiye: “íma ítáa-araakotaama mááe. nôraq umá yupaawaq keráwáqtê mánuno? keráwáqtí íitai-yataakoma tíbô kégaitaqa nôraq umá yupaawaq miráuma ónúnô? iyápóma áwîqme kekáqá yero!” titata ");
INSERT INTO usa_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","iyápóma áwîqme irááwana Îtuma máitana kuti-áágómá wemmá aónarena iyápóma yáqtoqma marabí yukáitana aúgoma kaipú-kaapu uráitana óyaukake agaremá arááteru-teru uráiye. ");
INSERT INTO usa_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Îtu wenaboámmá ítama aónaraiye: “nôraq umá yupaawaq wegáráqá máqe-uraiyo?” titana aboámá yauwéqma tiráiye: “pááqyan-iyapoma máikakene. ");
INSERT INTO usa_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","taíbaq-kanaama irabí yukéna nopí yukéna arááqa ikámita ááqibo emá arummá umátikaao! emá kanaaráq énnaraq tíwáqnaa uwo!” titana ");
INSERT INTO usa_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Îtu tiráiye: “náawabi keqtábá arupi ítama aruténama máqte-qtataaqa kanaaráq íniye.” titana ");
INSERT INTO usa_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","aboámá ibiqá yaréna tiráiye: “kemá tirupi kéitaupo ketí itaígómá pááqyamma itaígóqtábámá tíwáqnaa uwo!” titana ");
INSERT INTO usa_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Îtuma waabámmá yimónaraitata ya áíkutaawana kuti-áágóqtábámá abarokáqá akoqnáá umá tiráiye: “aíbôqnaaboq kuti-áágó, kemá timá ámenaa iyápógoni arunóbáké yaúbagaao! yaúbarema móragaraqa arunóbáq íperaao!” titana ");
INSERT INTO usa_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","wááqa yumátuwena iyápóma marabí yukáitana aúgoma kaipú-kaapu uráitana yáubaguraiye. yáubaraitana iyápóma pukurénaraa máqe-uraitata waayúkama tirááe: “pukuráiye!” tewana ");
INSERT INTO usa_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Îtuma ayáámma yáqtoqma awaútitana itó-uraiye. ");
INSERT INTO usa_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Îtuma naaúpaqa pékuraitata wení iyápó-annama aúpáq ítama aónaraae: “nôraq itatáá ketáámá íma kanaaráq waqtukáunataabiyo?” tewana ");
INSERT INTO usa_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","tiráiye: “nunamunápó maa-wáín-áágómá kanaaráq waqtuwáinoe. káqo-qtataaqnapo kanaaráq waqtuwáinoe.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","mikáké kóureta Kááriribaqa kégowata waayúkama itánéowana Îtuma itaíyábá íkákaipoana wení iyápó-annama kétima-yimena tiráiye: ");
INSERT INTO usa_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","“Waayúka-Araaqa yáqtoqma áwîqma yimíyatama ikamíyana puyéna kaumo-yúpáámá ánataginana itó-iniye.” titata ");
INSERT INTO usa_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","wemá tin-áíkón áaimma íma ítareta ikaqtíq uréta ítama íma aónaraae. ");
INSERT INTO usa_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Kápéranabaqa iréta naaúpaqa maéta máawana Îtuma ítama yimónaraiye: “nóiqtabama aakaqá uréire uréta watáá-wataa tirááo?” titata ");
INSERT INTO usa_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","timá abarokáqá íma tirááe. aakaqá uréire umá maéta yemá aagaren áimma tiráápoata náawabi áqnáaenariq íyábá aagaren áimma tiréta timá abarokáqá íma tirááwana ");
INSERT INTO usa_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Îtuma maraq maéna títaupake kaayaq-íyápó-ánnágómá yááyarena tiráiye: “ítáaro! áqnáabataba akáina-nakoma aqtóbáq maíno! máqtekoni maqnémá auraíno!” tiréna ");
INSERT INTO usa_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","iyápóma áwîqma yetúbáqá ákarena áyabaa uréna tiráiye: ");
INSERT INTO usa_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“móra-nakoma kebóana maaráá-íyápómá yabírakenaraa kemmá yabítikane íniye. yabítikanenaraa kenamáa íma yabítikanibo timátíkarai-naqa yabírakane íniye.” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Yóáane Îtumma timá ámikaiye: “yirááti-nako, móra-nakoma enáwîqa tiráinapoana kuti-áágómá waqtukáitataa ketáámá aónaretaa timá ámikaunatae ‘éqaao! ímira-uwo!’ tirétaa ení iyápó-annabike íma ketáátê íma máitataaboataa mirá-tiraunatae.” tewana ");
INSERT INTO usa_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Îtu tiráiye: “ímira timá áméro! ‘éqaao!’ ítero! ááqibo ketíwîqa yáninapoana akoqnáá-yataaqa umá inéna min-nákómá keqtábámá táí-aimma íma kanaaráq tíniye. ");
INSERT INTO usa_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","ááqibo íma namuroîq kéumatikenataama wemá aanábó máena íniye. ");
INSERT INTO usa_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","ááqibo keráwáqá Îtu Káríqtoni iyápóma máapoana móra-nakoma keqtababóana pááqya-qtataaqa miráumaraa nommá nawááena timénama wení íráqô-qtakaakoni anónnámma mayániye.” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Îtu tiráiye: “móra-nakoma ketáama ítarain-iyapoma kaaqaari-ááímmá aráátínanama min-íyápógómá ketáama yuwáinanama anón-oqtamma kaaqaari-nákóní ánúwarakaqa atáá-ataa umá nopí óqtakaraqa yuwáiyana pékena nommá nawîkama pukínanama minnâ kateko umá íni ááqibo iyápóma tinaaépaqa yuwáné ínanama mú mikákáá táígoma íniye. ");
INSERT INTO usa_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","ááqibo tiyáákoma táígo-qtataariqo kéinaqa keráwáqá tinaaépaq yuwáneqa tiyáámma aráráaro! áánibo kímora-ayaakaraqa mú mikákáá íráqômma keráwáqá tágagurai-marukaqa wínóe. kaayaq-áyáákáráqá márú mikákáá táígoma keráwáqá puí-márúkáqá ");
INSERT INTO usa_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","irabí wínóe. ");
INSERT INTO usa_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","ááqibo aítaukoma táí-apima áwîqmena kéwinaama tinaaépaq yuwánéqa títauqa aráráaro! kímora-aitaukaraqa mú mikákáá íráqômma tágaruraipaqa yínéqa kaayaq-áítáúkáráqá márú mikákáá táígoma ína puíbáqá wínóe. ");
INSERT INTO usa_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","ááqibo túrakoma kúmiq-yataariqo kéinaqa tinaaépaq yuwánéqa túramma kubíqtúwáaro! Áánûqtuni kurubáqá kímora-aurakaraqa mú mikákáá íráqômma yínéqa kaayaq-áúrákáráqá márú mikákáá táígoma ínaq puíbáqá irabí wínóe. ");
INSERT INTO usa_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","puí-márúkáqá marikómá íma ánatainana irágómá íma kama ánataniye. ");
INSERT INTO usa_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","úmá irabí agatuwáinana anaaékaq yaímma íráqô-qtataaqa paá wániye. móraiq umá ketáá maqmá aóna-aona onanatáá yaímma íráqô-qtataaqa paá wániye. ");
INSERT INTO usa_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","ááqibo úmá ikaaq kétena aáwakaraqa átê kéinana ááqibo ikaaqá íma tínanama nóinapo móragaraqa átê íníyô? miráuma tirupí úmá-úráá-qtátááqá wáinaqa máqte-kayukagaraqa aarawaamá paá máaro!” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","mibáqá kóurena Yúría-marupaqa kóurena Yótaa-nomma atamá kóuraitata waabámmá móragaraqa áíkutaawana wemá keqnáámmá aapinaammá timá yímikaitata ");
INSERT INTO usa_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","tébakaq Pérati-wayukama wenôpaqa iréta yoqmá aónaneta ítama aónaraae: “ketááí monoq watáabi yaaguyabí-áípí awaaikómá wenánáakoma kanaaráq ayuwáníyô?” tewana ");
INSERT INTO usa_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Îtu ítama aónarena tiráiye: “Móteti nóineq timá tímikaiyo?” titata ");
INSERT INTO usa_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","yé tirááe: “Móteti tiráiye. ‘akáinama awaaikómá ayúkai-kanaamma agayéná ánáakoma kanaaráq ayuwániye.’” tewana ");
INSERT INTO usa_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Îtu tiráiye: “kaúbîq uráápoana Móteti miráuma timá tímikena agatáitana ");
INSERT INTO usa_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","áqnáabaqa Áánûqtu ímira-uraiye. Áánûqtu áqnáabaqa awaaikógáráqá ánáakogaraqa tarôq uráiye. ");
INSERT INTO usa_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","ááqibo waagómá anóama aboámá iyuwéna ánáakote iyikááyata kónanaratama ");
INSERT INTO usa_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","mi-káyákómá kímora-auma auráyóye. kaayakómá íma paá maéta kímoragoma aúgemma mániye. ");
INSERT INTO usa_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","ááqibo Áánûqtu mi-móráráq makáinata waayúkama íma yataínoe.” titata ");
INSERT INTO usa_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","naaúpaqa wení iyápó-annama maannáyaba ítama aónaraawana ");
INSERT INTO usa_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","wemá tiráiye: “ánáakoma ayúwái-nakoma káqon-inimma mayánénama wemá morímá yamákárena moyámmá mayéna ánáakoma agaemá amíniye. ");
INSERT INTO usa_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","keqnáámmá awaaikó ayúkain-inimma wemá káqokanokoma mayánénama wemá morímá yamákárena moyámmá kémayaiye.” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","ááqibo pááqya-noiyaporawaqa yiwîqme Îtunopaqa ánêkuku íkáae téta irááwata Îtuni iyápó-annama áá yiwááguraawana ");
INSERT INTO usa_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Îtuma aónaimma áyámma uráitana tiráiye: “paá máaro! iyápóma ketôpaqa kanaaráq kéyee. áá íma yiwáágoro! Áánûqtuma kawáá kéi-maruqa miráráá umá iyápógoni márûqa wáiye. ");
INSERT INTO usa_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","túwááyakaq máráaro! Áánûqtuni watáama iyápóraa umá arupi kéitai-nakoma Áánûqtuma kawáá kéi-marukaqa kóiniye. miráumaraa íkéitenama íma kóine iné.” téna ");
INSERT INTO usa_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","iyápóma yirákena íyóbaruqma uréire kéena tiráiye: “eqtábámá íráqôniq umákaniye.” mirá téna íráqôn-aimma timá yíkaraiye. atimuqá ámikaiye. ");
INSERT INTO usa_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","kégoitana móra-nakoma uyááténa Îtunopaqa marabí araayutaúmá aténa ítama aónaraiye: “íráqô-yiraati-nako, nóin-iraqo-qtataariraq éraq kemá íma ánatagena tágagigoma mayánááq únabiyo?” titana ");
INSERT INTO usa_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Îtu tiráiye: “nôraq itaa keqtábámá íráqône tiráano? kímora-iraqokoma máena Áánûqtu wenamáa íráqômma máena kéiye. ");
INSERT INTO usa_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","emá máqtemma yaaguyabí-áímmá ítaraane. aaramá moyámmá morímá yamákaanabo! íyamakaao! waayúka ikámma puyónabo! íikamuwo! moyámmá mayáánabo! ímayaao! kaaqaari-áímmá ténabo! ítiyo! wakaráánabo! íwakaraao! aboámá anóagaraqa kaayonéma umá yíwîqa múte yauyuwo. kaqtó umá yabíqyikaao!” titana ");
INSERT INTO usa_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","anó-nako tiráiye: “yirááti-nako, maa yaaguyabí-yátááqá máqtemma iyápó máqe uráuna-kanaarake íbêkaraqa kaqtó kéune.” titana ");
INSERT INTO usa_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Îtu aónaraitana wenaúyánámmá wenôpaqa kóuraitana tiráiye: “kímora-yataaqa íarutaiye. ení máqte-qtataaqa oótamma íma wái-kayukama yimiyo. yiméma Áánûqtugaraq ení oótamma taíbaqa anómma aurániye. yímituwe tinaaépaq iyo!” titana ");
INSERT INTO usa_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","mi-kátááyábá arummá ôriq uráitana wení oótamma taíbaq wáinapoana karagíqá yumáena kóuraiye. ");
INSERT INTO usa_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","kóuraitana Îtuma karáqme uré karáqme iré kéena wení iyápó-annama timá yímikaiye: “anó-nakoma taíbaq oótamma makáina-nakoma Áánûqtuni-marupaqa umaagáráqá kóiniye.” titata ");
INSERT INTO usa_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","iyápó-annama wení watáayatabama yáaqa karáitana Îtuma móragaraqa tiráiye: ");
INSERT INTO usa_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","“oótiraa-kakoma (káámo) waigóní-aapi péránéna iníkáámá oóta-nakoma Áánûqtuni márûpaq uínénama kamáa ániye.” titana ");
INSERT INTO usa_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","yáaqa ôriq kégaitata tirááe: “náawa kanaaráq peráníyô?” tewana ");
INSERT INTO usa_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Îtuma karáqma káonena tiráiye: “ááqibo umaa-yátááqá waayúkama íma kanaaráqá ínana Áánûqtu kanaaráq íniye.” titana ");
INSERT INTO usa_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Pítaa tiráiye: “ketáámá máqte-qtataaqa yukétaa enanaaépaqa kéyunatae.” titana ");
INSERT INTO usa_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","tiráiye: “ááqibo kétima-timune ááqibo keqtábámá maan átê-wataayabama móra-nakoma naaópaqa yuwánénama awaaómá ábâkogaraqa yuwánénama anaanoámá aúkogaraqa yuwánénama aboámá anóagaraqa yuwánenama áanikoma ayáámûkogaraqa yuwánénama yókáráq yuqmá ánatatuwenama ");
INSERT INTO usa_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","móragaraq-moragaraqa mayániye. taíbaq mayánéna íbêq-kanaama naammá taíbaq mayéna awaaútááma ábâkotaagaraq taíbaq mayéna anaanoútááma aúkoutaagaraqa taíbaq mayéna anóautaama taíbaq mayánéna aíkaraqa mayániye. mayéna anaaéka-kanaama íma ánatagena tágagigoma mayániye. ");
INSERT INTO usa_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","íbêq-ano-kayukama maqnémá ínana íbêq-maqne-wayukama uyátaneta yínóe.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","aapaqá máeta Yúrútáárebaq kégowana Îtuma áqnáabaqa kégoitana wení iyápó-annama yáaqa kégaitata wenanaaépaqa kégowata tébakaq-wayukama yinaaépaqa kéyewana yáaqa ôriq umá karáiye. Îtuma móragaraqa wení iyápó-annama wenôpaqa yáárena máqtemma yínê-qtataaqa timá yímikaiye: ");
INSERT INTO usa_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“aónaaro! Yérútáárebaqa kéuyonatama mikáqá monoq-wáyúkámá aapina-káyúkágáráqá Waayúka-Araaqa yáqtoqma ánnáma amínéta aa íitai-wayukama yimíyata ");
INSERT INTO usa_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","weqtábámá makatéta wirááti wekáqá wituwéta ikamíq-ikamiq umá ikamíyana puyéna kaumo-yúpáámá ánataginana itó-uma paá mániye.” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Yêmiti Yóáanegaraqa Yéberen áanikoma wenôpaqa iréta ítama aónaraaye: “yirááti-nako, móra-yataaqa ítama aónayaa kekárátá mirá-umatikanono?” téyana tiráiye: ");
INSERT INTO usa_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","“tikaí-yátááqá nôraq umátikanuno?” titata ");
INSERT INTO usa_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","tirááye: “emá ení tágagi-marupaqa yénaka kerátámá enaukápáqá maraq máyaakae. meran-áúkápáqá maan-aukapaqa anó-kayukati yibíqtátáráq maraq máyaakae.” teyana ");
INSERT INTO usa_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","tiráiye: “ítama aónááya-qtataaqa kenákámá íma ítaraaye. kemá naúna-yataaqa kanaaráq náyóyô? kemá peraúna-yataaqa peráyóyô?” titata ");
INSERT INTO usa_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","tirááye: “kanaaráqá mirá-oyuye.” téyana tiráiye: “keqnáámmá kínnamo naúna-yataaqa náyóye. kínnamo peraúna-yataaqa peráyóye. ");
INSERT INTO usa_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","ááqibo ketukápáqá kemá íma kanaaráqá ‘maraq máékao!’ tenúne. Áánuqtu wenamáa maannáyaba tíniye.” titata ");
INSERT INTO usa_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","tébakaq iyápó-anna-wayukama ítaraawana Yêmitiqtabama Yóáaneqtabama íyámma uráitata ");
INSERT INTO usa_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Îtu yááyarena tiráiye: “aa íitai-wayukagoni áaimma keráwáqá ítaraae. yetí uyátárai-kayukama kawáá-wáyúkágáráqá náápaakaraqa imaamugáráq-áímmá kétepoaq ");
INSERT INTO usa_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","keráwáqá ímira-inoe. uyátaiyaba kákainanama tébakaqa yíwâqnaa íno! ");
INSERT INTO usa_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","mú mikákáá áqnááemma mánae téna kákainanama máqtekoni maqnémá maíno! ");
INSERT INTO usa_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Waayúka-Araaqa wemmá áwáqnaa íyábá íma kukáibo máqtekoma yíwâqnaa umá wenamáárîq uyéna yauwéqma meyánîq inéna kukáiye.” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Yérikobaqa irááwana Îtuma wení iyápó-annagaraqa anó-kaabakaraqa Yérikobake kégowana móra aúra karopágurai-naqa Páátáméati Timéyati áanikoma pari-páriakoni áwábaqa maéna óqtataba inaa-inaa kétitana ");
INSERT INTO usa_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Náátárêtibake Îtuma kéyataitana ítarena akoqnáá umá ááyama tiráiye: “Îtuo! Tébitini áanikoo! keqtábámá arummá umátikaao!” titana ");
INSERT INTO usa_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","taíbaq-wayukama áá awáágureta “páátí máao!” kétewana mú mikákáá akoqnáá umá tiráiye: “Tébitini áanikoo! arummá umátikaao!” titana ");
INSERT INTO usa_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Îtuma paá máena tiráiye: “ááyaaro!” titata aúra karopágurai-nakoma ááyareta tirááe: “áaqa ígáino! kááyaina itóaao!” tewana ");
INSERT INTO usa_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","unáákáqtôma ámuraake kabe-kabe umá káyutuwena itó-uma Îtunopaqa iráitana ");
INSERT INTO usa_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Îtuma ítama aónaraiye: “akaígómá nôraq umá umákanuno?” titana tiráiye: “tikái-tiraati-nako! keqnáámmá túrama aónanaare.” titana ");
INSERT INTO usa_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","“kóaao!” téna tiráiye: “enarupi ítaraiwaigoma atóbamakaraiye.” titana páátákáá kanaaráq káonena Îtuni anaaépaqa pari-páriakaqa kóuraiye. ");
INSERT INTO usa_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","ááqibo Yérútáárebaq waaqókáqá iréta Óríbêti-anuraqa Béqtápégibaqa Béqtanibaqa irááwana Îtuma kaayaq-íyápó-ánná-wáyúkáyátábámá timá yímikaiye: ");
INSERT INTO usa_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","“kenákámá mi-márúpáqá kóokao! uréka oóti-araaqa aónéka waayúkama íma ayááqme uréire uráiyamma min-árááqá ayúqma áwîqme yekaao! ");
INSERT INTO usa_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","ááqibo móra-waigoma aónéna ‘nôraq kéoyo?’ tínakama mirá-tima-amekao. uyátárai-nakoma kákaipoana páátákáá yauwéqma uwáyu amíniye.” titata ");
INSERT INTO usa_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","yenákámá kóureta oóti-araaqa abarokáqá ánnáraqa aónareta káyuboyata ");
INSERT INTO usa_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","tébakaq-wayukama ítama yimónaraae: “nôraq kéoyo? nôraq itaka min-árááqá káyuboyo?” tewata ");
INSERT INTO usa_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Îtuma timá yímikain-aimma yauwéqma timá abarokáqá tirááyata “kanaarapaq íye” tirááe. ");
INSERT INTO usa_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","oóti-araaqa Îtunopaqa áwîqme iréta yetí unáákáqtôma oóti-araaq-amuraaqa akéta Îtuma ámûraaqa kéuyataitata ");
INSERT INTO usa_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","tébakaq-wayukama unáákáqtôma aakaqá ákaraamma mú mikákáá anómma yabíkái-naqa kéitata mirá éwaoniq umá mirá-uraae. tébakaqa yaayamamá ánagaraqa akáteta aakaqá ákaraawana wemá yínîtaba mirá-umakaraae. ");
INSERT INTO usa_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","ááqibo aakaqá áqnáabaq o-káyúkágáráq anaaé ye-káyúkágáráq kabámareta tirááe: “atóbatikai-naqa otáána yi-nákóqtábámá anón-uyatarai-nakon áwîkaq kéyenana Áánûqtu amuqá kémarakaiye. ");
INSERT INTO usa_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Tébiti ketibotáámá wení kawáá kéi-maruqa uyátárai-nakon áwîkaq wení yabi-í-yátááqá Áánûqtuo, wemmá íráqôniq umákaao! ya-matiyuwaao!” mirá-timatuwaawana ");
INSERT INTO usa_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Îtuma Yérútáárebaq utáiye. anó-monoq-naupaqa pékena karáqme uré karáqme iré kéena máqte-qtataaqa aónaimanibo aa ékitana yáubama Béqtanibaqa wení iyápó-annagaraqa kóuraae. ");
INSERT INTO usa_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","aaq iráráimma Béqtanibake yauwaré kéyewana Îtumma áa-yaitana ");
INSERT INTO usa_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","kopaakáá-qtámá taíbaq-anagaraqa ayáqtáákaqa aónarena waaqókáqá uréna araqtabámá aónarena ááqibo abáá-abaa immá uráitana arammá íkéiyai-kanaaboana paá ánáma wáqe-uraiye. ");
INSERT INTO usa_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Îtuma yaayamagómmá timá ámikaiye: “ekáqá yaa-yarammá íma iyaíno! waayúkama móragaraqa ení arammá íma nánoe!” titata wení iyápó-annama ítaraae. ");
INSERT INTO usa_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Yérútáárebaqa irááwana Îtuma anó-monoq-naupaqa kurubáqá pékaitata mibáq meyámmá kémayaawata meyámmá kémaraawana yemmá Îtuma kurunóbáké waqtukéna óqtamma waékáa-kayukati yaaremá waéqtukena wáqwaaimma kémayaa-kayukati yibíqtátámá waéqtukaiye. ");
INSERT INTO usa_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","máqte-kayukama íma iyúwáitata oótama aqméta anó-monoq-namatupaqa kótawe-yatawe urááe. ");
INSERT INTO usa_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","mikáq yiráá téna tínoe: “Áánûqtuni agamatán-áípí agataíye! ‘ketí naaúpaqa máqte-kayukati nunamu-námmá téq ááqibo ketí naaúpaqa moyá-káyúkágoní naakáá ke máqtemma káuqmaraae.’” titata ");
INSERT INTO usa_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","uyátárai-monoq-wayukama aapinaa-káyúkágáráqá ítareta Îtuma ikamíyábá téite urááe. ááqibo waabámmá máqtemma wení aapinaaqtábámá yáaqa karáinapoana yáaqa karáiye. ");
INSERT INTO usa_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","ááqibo énaikaqa Îtuma Yérútáárebake kóuraiye. ");
INSERT INTO usa_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","aaq iráráimma aakaqá uréire kéeta kopaakáá-qtámá aónaraawana mútûqa aayákagurena ánûpake aayákaguraitana ");
INSERT INTO usa_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Pítaa aákaqa mákena tiráiye: “yirááti-nako! aónaao! emá áá awááguraana-yama aayákaguraiye.” titaana ");
INSERT INTO usa_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Îtu tiráiye: “itaao! arupi Áánûqtuqtabama yáqtoqma akoqnáá uráánama ");
INSERT INTO usa_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","maan-ánúyábámá náawabi tíniye. ‘anugô, itó-uma únópí pékaao!’ tíyanama arupi káqon-auyanamma íma wáinama wenáimma pááq ínîn-aikoma mirá-umakaniye. ");
INSERT INTO usa_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","miráinaqa kemá timá-timenune. kerawáqá tirummá améq móra-yataaqtabama nunamupí ítama aónáiyana máqtemma ítama aónaa-qtataaqa mayánóe. ");
INSERT INTO usa_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","ááqibo nunamummá kétiyanama káqo-yama táígo-qtataariq kéumatikaiyaqa tíyámma kéinaqa tíyámma paábaq yúwéraq! tirummá umákáaro! miráuma keqtibomá Áánûqtu keráwáqtí kúmiq-yataaqa paá umátikaniye. ");
INSERT INTO usa_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","íma káqo-yuti kúmiq-yataaqa paá umákaiyanama keráwáqtí kúmiq-yataaqa keqtibomá Áánûqtu íma mamá paá umátikaniye.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Yérútáárebaqa yauweréta irááe. Îtuma anó-monoq-naupaqa uréire kéitata uyátárai-monoq-wayukama aapinaa-káyúkágáráqá anó-kayukagaraqa wenôpaqa iréta ");
INSERT INTO usa_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","ítama aónaraae: “nói-naapaakaraqa maa-qtátáárîqa kéono? náawa mi-náápáámmá ámikaiyo?” tewana ");
INSERT INTO usa_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Îtuma yauwéqma timá yímikaiye: “móraiq umá kemá móra-yaqtaaqa kímorama ítama timónaanaqa yauwéqma abarokáqá timá-timiyaqa kemá nói-naapaakararaq kéyunopoaq timá-timenune. ");
INSERT INTO usa_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","timá tímero! Yóáane nói-naapaakaraqa nommá péqyikaraiyo? náawa mi-náápáámmá ámikaiyo. Áánûqtu ámikaiyo? waayúkama ámikaao?” titata ");
INSERT INTO usa_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","yenamáárîq aamá kégareta tirááe: “nóine tenúnataabiyo? ááqibo Áánûqtu ámikaiye tenanatáámá wemá tíniye. ‘nôraq itata wenáama tirupi íma ítaraao?’ tínataa ");
INSERT INTO usa_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","ááqibo ‘waayúkama ámikaae’ tenanatáámá waayúkama íyako táíq kéinata yé máqtemma Yóáaneqtabama yirummá amétama tínoe. ‘wemá Áánûqtuni watáá-wataa-naqa aúkáiye.’” mirá waayúkayaba téta yáaqa kaitata ");
INSERT INTO usa_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Îtumma timá ámikaae: “íma ítaraunatae.” tewana Îtu tiráiye: “móraiq umá kemá ketí náápaaqtabama ítima-yimenune.” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","timátuwena waéqma itaí-áímmá timá yímikaiye: “móra-nakoma yómmá uqtékáán-áráqtómmá yoqmakéna kurumá umá ikútena arammá igáriq í-máíqá ukéna yawáákaa-namma tarôq umákena yabi-í-wáyúkámá yabi-ígáae téna yímikaiye. yímituwena óq-marupaqa kóuraitana ");
INSERT INTO usa_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","arammá ábûma kaitana kuqtí-kánááráqá wemá wení maqné-kánókómá timákáitana tébakaq-aramma yabi-í-wáyúkáráké mamé kóuraiye. ");
INSERT INTO usa_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","kóuraitata yabi-í-wáyúkámá maqné-nákómá yáqtoqma ikámma waqtúwáawana yauweréna arammá ímayena paá kóuraiye. ");
INSERT INTO usa_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","ááqibo yókóní aboámá káqo-maqne-nakomma uréna mó-timaanikitana iráitata yabi-í-wáyúkámá aqnókáq kéikameta timákaawana kóuraitana ááqibo ");
INSERT INTO usa_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","yókóní aboámá káqo-maqne-nakomma timákáitana kóurena iráitata yemá arááqa ikámôwana pukáiye. miráuma keqnáámmá káqomma timá ámikaitata kóuraawata tébakaqa yikákaawata pukááe. ");
INSERT INTO usa_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","ááqibo yókóní aboámá kímora-aanikoma márainanama aboámá aúyánámmá ítarena ‘yemá ketáanikomma íma ikamínóe’ téna ítarena wemá írêkaqa wenáanikoma timá ámikaitana kóurena iráitata ");
INSERT INTO usa_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","yabi-í-wááyúkámá tirááe: ‘minnâ yókóní aboáni áanikoma ínataama ikámónanataa puínataa ketáámá yómmá mayánúnatae.’ téta ");
INSERT INTO usa_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","ikámôwana púítata arááq-auma yónaaumepaqa yaúma iyaabótukaae. ");
INSERT INTO usa_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","ááqibo yókóní aboámá nôraq íníyô? wemá yabi-í-wáyúkámá yíkaminata pukíyana wemá káqomma yabi-í-wáyúkámá yómmá yimínye.” ááqibo téna ");
INSERT INTO usa_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Îtuma mirá-timatuwena ítama yimónaraiye: “Áánûqtuni agamatán-áípí íyaq yoráutaao? mirá kétiye. ‘óqtakaraqa naammá taróq urááwana móra-oqtamma taróq kéo-kayukama maqné téta ayúkaawana mi-máqné-óqtákómmá mú mikákáá uyátárain-oqtamma aúkáitana ");
INSERT INTO usa_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","maannâ anón-uyatarai-nakonopake kéitataa káonaunataama ketúrakaq átê kéiye.’” titata ");
INSERT INTO usa_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","anó-kayukama waéqma itaígóní áaimma ítareta yeqtábámá tiráitata ánnáma amíyataba maqmá aónaraamanibo waabáqtábámá yáaqa kégaitata paá ayuwéta kóuraae. ");
INSERT INTO usa_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","tébakaq Pérati-wayukama Érôtini waayúkagaraqa timáyímikaawata Îtumma wenáayaba waakápi akánéta irááe. ");
INSERT INTO usa_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","wenôpaqa iréta timá ámikaae: “yirááti-nako, emá kateko umá máanaqtaa ítaraunataama emá waayúkayatabama áaqa íkégaitaa Áánûqtuni aammá áraimma káraatiye. ááqibo waayúkama káqo-yuyaba yúyánámmá itánôqtaba emá paá abarokáq umá áraimma kétene. miráuma kéyenataa ketáámá ítama káonaunatae. ‘Arómani-kamaani-nakomma óqtamma kanaaráq aménúnataabiyo?’” tewana ");
INSERT INTO usa_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","aménúnataabi íyaq aménúnataabiyo?” téta tirááe. Îtuma yeqtí yáaimma ítarena tiráiye: “nôraq itaráq waakápi mó-tikaneraq kéoo? móra-oqtamma mamé íyaraq kemá aónaano.” titata ");
INSERT INTO usa_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","maméta má ámikaawana ítama aónaraiye: “óqtakaqa náawani amammá áwîkaraqa wáiyo?” titata yauwéqma tirááe: “mú mikákáá anó-kamaani-nakonae.” tewana ");
INSERT INTO usa_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Îtuma tiráiye: “kámááni-nakon-nama kámááni-nakomma áméro! ááqibo Áánûqtun-nama Áánûqtumma áméro!” titata weqtábámá yáaqa karáiye. ");
INSERT INTO usa_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","tébakaqa Táátûti-wayukama Îtunopaqa iréta mi-káyúkámá yúyánánóbáqá tirááe: “waayúkama pukuráapike íma kéitoe.” téta Îtumma ítama aónareta tirááe: ");
INSERT INTO usa_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“yirááti-nako, Móteti aúbama agamátíkarena tiráiye. ‘ááqibo móra-nakoma puínanama wenánáakoma paá máena iyápóma ímo máinanama min-nákóní ábâkoma ánáakoma mayaíno! awaaóqtábámá iyápóma marakaíno!’ ááqiye téna ");
INSERT INTO usa_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","móra-taoqa abapaké kaayaq-wátámá máqe-uraae. máqe-uraawana áqnáabaqa yiwaaómá aaramá maténa iyápóma ímarakena pukuráiye. ");
INSERT INTO usa_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","pukuráitana ábâkoma min-ínímmá mayákarena iyápóma ímarakena pukitana wenanaaéken-aoma keqnáámmá ánáakoma maténa iyápóma ímarakena pukuráiye. ");
INSERT INTO usa_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","tébakaq-watama keqnáánîq urááe. ye-wátámá máqtemma min-ínímmá mayákareta iyápóma íma marakéta pukurááe. ááqibo pukowana írêqa min-íníkómá pukuráiye. ");
INSERT INTO usa_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","pukuráiyapike itó-i-kanaama min-ínímmá náawani ánáako aurániyo? yé abapaké kaayaq-wátámá matááe!” tewana ");
INSERT INTO usa_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Îtu yauwéqma tiráiye: “keráwáqá íarutain-aimma kétee. monoq-áúbámá íkéiteta Áánuqtuni akoqnáágoma íma ítaraae. ");
INSERT INTO usa_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","ááqibo pukuráipike itó-iyamma Áánûtuni kaqtó-wayuka auránoe. awaikómá ánáakoma mórabi íma mánoe. paá aokaq-aokaq mánoe. ");
INSERT INTO usa_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","ááqibo pukuráipike itó-iyabama Mótetini aúbabi íyaq yoráutaao? wemá abamá móra-yaa-wannama kaipáq máitana Áánûqtu timá ámikaiye. ‘kemá Áabaraama Ááítekima Yáakobouyaati manikómá máune.’ téna ");
INSERT INTO usa_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","wemá íma pukurái-kayukagoni maníkómá máibo wemá paá mái-kayukagoni maníkómá máiye. keráwáqá arábaguraae.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","móra-aapinaa-nakoma máena mi-kátáá-wataa ítarena Îtuni kateko-áímmá abarokáq timá ítaraiye. iténa ítama aónaraiye: “nóin-aare-aimma mú mikákáámmá yaaguyabí-áínábiyo?” titana ");
INSERT INTO usa_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Îtu tiráiye: “minnáma Ítíráaeo-wayukaao! ítáaro! Áánûqtu ketááí manikómá wenamáa anómma utái-nakoma máiye. ");
INSERT INTO usa_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Áánûqtu keráwáqtí maníkóqtábámá tikaíno! wenôpaqa túyánámmá koíno! tirupikékáráqá taákogaraqa akoqnáágoraraqa máqtekaraqa weqtábámá tuyánámmá itaíyana tikaíno!’ maannâ áqnáaen-aare-aimma ");
INSERT INTO usa_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","ááqibo keqnáámmá mórama kétiye. keráwáqtí waaqókáq-nákómá keqtábáráá umá tikaíno!’ mi-kááyáq-ámáán-áíkárátámá mú mikákáámmá wáitana maannáratati mú mikákáámmá yaaguyabí-áímmá íma wáiye.” titana ");
INSERT INTO usa_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","aapinaa-nákómá tiráiye: “yirááti-nako, téna emá áraimma kétene. Áánûqtu wenamáa anómma utái-manikoma káqo-manikoma íma máitana wenamáa máiye. ");
INSERT INTO usa_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","máinana wenôpaqa aúyánámmá kóinana arupikékáráqá aágogaraqa akoqnáágogaraqa akáina ení waaqókáq-nákóqtábámá enamáárîq akáiniq umá minnáyaba Áánûqtu ôriq umá amuqá kémaraiye. kéqokeq-wamma mamá irabí agamá Áánûqtuma ámînanama maannâ maqné-yátáápóana maaminnáyaba Áánûqtu pááqyan amuqá kémaraiye.” titana ");
INSERT INTO usa_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Îtuma wení kateko-áíqtábámá ítarena tiráiye: “emá Áánûqtuma kawáá kéi-marukaqa waaqókáqá máane.” titana máqte-kayukama yáaqa karáitata móragaraqa íma ítama aónaraae. ");
INSERT INTO usa_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","monoq-náúpáqá aapinaammá kétena Îtuma ítama aónaraiye: “náaraq umá aapinaa-káyúkámá Metáíyaqtabama kéteo ‘wemá Tébitini áanikoe’? kétewana ");
INSERT INTO usa_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","ááqibo Áánuqtuni Aágoma timá ámikaitana Tébiti tiráiye! ‘anómma utái-nakoma ketí utái-nakokaq timá ámikaiye ketukápáqá maraq máao! maínaq ení namurommá enaítaukaqa akánúne.’ ");
INSERT INTO usa_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","keqnáámmá Tébiti ‘utái-nakoe’ téna yaráinapoana náaraq umá Metáíya Tébitini áanikoabiyo?” téna tiráiye. waabámmá yimuqá kémareta ítaraae. waabámmá anómma áíkuteta Îtun-aama ítátuweta yimuqá marákáraae. ");
INSERT INTO usa_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","ááqibo wemá timá yímikaiye: “aapinaa-kááyúkáyáqtábámá yabíqma akoqnáá oro! yemá ayáqtááq-unaakaqtogaraqa uréire íyábá kéyikainata meyánîq í-márúpáqá kaayonéma umáyîkaayaba kéyikainata ");
INSERT INTO usa_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","aapinaa-náúpáqá mú mikákáá íráqôn-abiqtatamma kémayeta ónikaqa mú mikákáá íráqôpoaqa kémayeta ");
INSERT INTO usa_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","keqtoq-nóínítí naammá moyámmá kémayeta ayáqtááq-nunamumma awaaméq-núnámúmmá kéteta yeqtí anónnáma mú mikákáá anómma yíkaraqa íniye.” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","monoq-náúpáqá Îtuma óqtakoni yawáákaqa maraq máqe-uraitata waayúkama yeqtí ámikaan-oqtamma yáwáápi kémaraawana karáqma aónaraiye. taíbaq-wayukama taíbaq-oqtamma wái-kayukama taíbaq-oqtamma yawáápi makááwana ");
INSERT INTO usa_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","ááqibo móra-keqtoq-inikoma iréna kímora karogaron-óqtámá yawáápi makáitana ");
INSERT INTO usa_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Îtuma wení iyápó-annama timá yímikaiye: “aónaaro! kín-inima oótamma íma wáin-inimma keqtoq-íníkómá wemá mú mikákáá anómma ámikaitata ");
INSERT INTO usa_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","tébakaq-wayukama taíbaq-otapike ámikaawana wemá íma wáipike mútûqa ámikena máqte-qtaqtaaqa ámikena nóikararaq paámá mániyo?” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Îtuma anó-monoq-naupake kéyaubaitana mórama iyápó-annabike-nakoma tiráiye: “yirááti-nako, aónaao! anó-monoq-namma naakómá mú mikákáá íráqôniq kéitana naan-óqtákáráqá íráqôniq kéiye.” titana ");
INSERT INTO usa_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Îtu tiráiye: “naammá máqtemma káonaano? maan-ánón-námmá yawítíginana máqten-oqtakoma yawítíma okaq-okaqa iyaabógínana kaayaq-kaayaq umá íma paá wániye.” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Îtuma Óríbêti-anuraqa maraq máena anó-monoq-naopaqa karáqma káonaitata Pítaa Yêmitigaraqa Yóáanegaraqa Áánarugaraqa yenamáa wetê máeta ítama aónaraae: ");
INSERT INTO usa_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“nói-taoraq mi-kánáámá pááq íníyô? nóin-awaameqyataaraq pááq íníyô? minnáyaba timá timiyo!” tewana ");
INSERT INTO usa_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Îtuma yauwéqma tiráiye: “yabíqma akoqnáá oro. káqowama ubaayammá umátikainabo! ");
INSERT INTO usa_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","taíbaq-wayukama iréta ubaayammá umátikanoe. miráinata ketíwîkaq iréta tínoe. ‘wemúne’ téta kaaqaari tínoe. ");
INSERT INTO usa_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","miráinaq uwáá-aimma ááiqtabama itéqa waaqókáqá ááiqa éta nékaq ááiqa éta íyan-aimma itáíyanama táaqa ígáino! mirán-ááíqá yínîmanibo mi-kánáámá maramá ánatai-kanaama íma pááq uráiye. ");
INSERT INTO usa_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","móra-marukaq-wayukama itó-uma káqo-marukaq-wayukama ááiqa kéumayikaiyata móra-marukaq anó-nakoni waayúkama itó-uma káqo-nakoni waayúkama kéyikamiyata yaímma-aukapaqa márûma kéyinana yáa kéyainana mirá-qtátáákómá yíqa éna aaragómá iyápó marakánéna iníkáá íniye. ");
INSERT INTO usa_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","yabíqma akoqnáá oro! keráwáqá koti-áímmá timátiketa ánnama timéta tebûqa timínoe. aapinaa-náúpáqá tíkameta ókaq-okaq tíkameta keráwáqá anó-kayukayopaq mú mikákáá anó-kayukayopakaraq ketíwîkake yúbáqá itó-umatikayaqa ketí átê-watama timá yíménata mirá-inoe. ");
INSERT INTO usa_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","áqnáabaqa máqte-marupaq-wayukama átê-wataama waayúka abarokáq timá-yiminoe. ");
INSERT INTO usa_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","ááqibo ánnáma timí-kánáámá ‘nóin-ainaq ténúnô?’ ítero! anaaékaqa keqtúyánápíkén-áímmá ítero! áama tí-kánáámá timá-timin-aimma tero! ketááq maqma ítinobo Áánûqtuni Aágoma timá-timina-aimma tínóe. ");
INSERT INTO usa_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","mi-kánáámá yiwaaómá yíbâkoma yíkamigaae téta yiboámá yeqtí iyápóma kutarurîq ínóe. iyápóma yetinóboyuma kutarurîq ínopoata yetinóboyuma yíkaminoe. ");
INSERT INTO usa_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","miráíyata ketíwîqtababoata keráwáqá tíyamma ôriq umátikanoe. ááqibo ánatagini-kanaama ketíwîkaq akoqnáá umá yáqtoraiya-kayukama paá atóbamayikaniye.” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","óq-aimma tiráiye: “kabiramá táíguyun ínna-yataakoma pááq ínanama yawitíniye. aónáiyana mibáq íma waínabaq anubaq uyaatéra kóoro!” téna ááqibo aúbama yorautíya-kayukama ítáaro! tiráiye: “aammá aúkaipaqa máinata máqtemma Yúríabaq máiya-kayukama uyaatéta anubaq kóoro! ");
INSERT INTO usa_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","ááqibo móra-nakoma naan-ámútáqá maína-nakoma íma naaúpaqa ku péqma táitawaa-yataaqa mayéna paá kóíno. ");
INSERT INTO usa_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","ááqibo móra-nákoma yópáqá máinama íma naaópaqa yauwéqma unáákáqtôma ko mayéna paá koíno! ");
INSERT INTO usa_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","mi-túpááráqá ámûkaraq-inimma iyápóma náámma kámina-inikaraqa anómma aíq-yaqtaaqa mayáíyana yirummá ôriq íniye. ");
INSERT INTO usa_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","ááqibo yaugiq kéi-kanaama wáinatama yíqa anómma íné ínatama nunamupí íbêqa ítama aónaaro! ‘Áánûqtuo, mi-qtátááqá yaugiq-kánáábí ímira-uwo!” tíyana márû mikákáá íniye. ");
INSERT INTO usa_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","ááqibo mi-táígó-kánáámá mú mikákáá táígoma ínama ááqibo naayóbáqá Áánûqtu máqte-qtataaqa tarôq urái-kanaarake íbêkaraqa íma mirá-uraiye. keqnáámmá móragaraqa íma mirá-kánáámá aurániye. ");
INSERT INTO usa_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","ááqibo mi-kánáámá íma ánataginaraatata máqte-kayukama íma paá máne oné. miráitana Áánûqtu maa-kánááyábámá pááqya-kanaama iyo téna timákárena wení awaaméq-wáyúkáytábámá timáyíkaraiye.” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Îtuma timá yímikaiye: “ááqibo mi-táí-kánáámá ínana móra-nakoma timá-ámena ‘Metáíyama maabáqá máibo aónaao! mibáqá máiye.’ tínaama íma arupi itaao! ");
INSERT INTO usa_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","taíbaq kaaqaari-Métáíyá kaaqaari-wátáá-wáyúkágáráqá auréta awaaméqá aráátineta Áánûqtuni waayúkama ubaayammá umáyiketaraa ínóe. miráuma kanaaráq inéta ínóe. ");
INSERT INTO usa_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","ááqibo karáqtuwe paá máaro! kemá áqnáabaqa kétima-timune. ítáaro!” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Îtuma óq-aimma tiráiye: “ááqibo táígo-kanaama aíqa urái-kanaama ánatatuwena aabaúmá kumayuqá aukéna wíyômma móragaraqa íma tágaginana ");
INSERT INTO usa_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","wiyóqa wíyôpake kutínana wíyôkoni akoqnáágoma popoq umáginiye. ");
INSERT INTO usa_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","umáqtuwena Waayúka-Araakoma konnákáqá kuména anón-akoqnaagaraqa tágagigogaraqa kumíniye. ");
INSERT INTO usa_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","kukéta Áánûqtuni kaqtó-wayukama timá-yiminata múqtûq maragóní aqtóbáké íyata Áánûqtuma awaaméqá umáyíkarai-kayukama yiwíqme yínoe. ");
INSERT INTO usa_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","yaagómá aapinaammá yiráátínata ítáaro! ááqibo yaayamamá yaa ánagaraqa yáinatama miráini-kanaama ítaraae. ");
INSERT INTO usa_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","móraiq uma maa-wáí-qtáqtááqá auráínatama kemá kumónúna-kanaama waaqókárîq íniye. ");
INSERT INTO usa_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","ááqibo taákaq máráaro! íbêqa paá máa-kayukama tébakaqa íma puíyana maa-wáí-qtátááqá máqtemma auránóe. ");
INSERT INTO usa_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","wíyôkaraqa maragáráqá ánataginamanibo ketáama íma ánataginiye.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Îtuma timá yímikaiye: “ááqibo aabaúmá nôraq umá mi-kánáámá íníyô? nói-kagaama íníyô? máqte-kamma máqte-kayukagaraqa Áánûqtuni kaqtó-wayukama áanikogaraqa íkéitaae. aboámá wenamáa kéitaiye. ");
INSERT INTO usa_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","mi kumíni-kanaama mi-kágáámá íma ítaraabo yabíqma akoqnáá oro! ");
INSERT INTO usa_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","miráraa umá wáiye! móra-nakoma naaópake aammá kóinena wení maqne-wáyúkámá yeqtí iyáánikaraqa iyuwéna kóitata yemá yabikááe. ááqibo wemá oqtaráq yabikái-nakoqtabama timá ámikaiye. ‘kawáá uwo! karáqtuwe mááo!’ téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","keráwáqá keqnáámmá karáqtuwe máaro! naakóní aboámá nói-tupaawaq yíníyô? énaikaraq yíníyô? aabáyaanapimma nokáán-aukaanaq yíníyô? iráqma tágaina-kanaararaq yíníyô? íma ítaraapoana ");
INSERT INTO usa_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","páátákáá yínibo wagobo! ");
INSERT INTO usa_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","ké kétima-timune. keqnáámmá máqte-kayukayabama kétima-yimune ‘karáqtuwe máaro!’” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","kaayaq-yúpáámá paá wáinana kótámaki-oniqa íma itóraitan-onikaraqa yínata uyátárai-monoq-wayukama aapinaa-káyúkágáráqá Îtumma aúpáq yáqtoqma arááqa ikaméta náaraq umákainoqtababi abáá kéoe. ");
INSERT INTO usa_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","abáá kéeta tirááe: “óniqa kaugi-kánáámá miráonatataama waayúkama ááiqa ínópoataa mi-kánáámá íma kanaaráq ónúnatae.” téta tirááe. ");
INSERT INTO usa_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Îtuma Tááímoni kárú-nakoni naaúpaqa Béqtanibaqa nammáqá ya máitata aáwaqa kénaawana móra-inimma uyábékena anón-oqtanawiqa yaan-ákúq-mátáwékáráqá óqta-motorema yubáqtukena Îtuni aqnókáqá atíma pérakaraitata ");
INSERT INTO usa_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","tébakaq-wayukama íyámma ôriq umá uráitata tirááe: “nôraq itana min-áté-ákúq-nómmá paá atíma pérakaraiyo? kaumo-tíyááká-tíyááká-óqtámmá (300) wáiye. nôraq itana min-áté-ákúq-nómmá íma kéyimenawaq meyámmá matáiyo? ");
INSERT INTO usa_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","ááqibo meyámmá matáikakaatati mi-méyámmá oótamma íma wái-kayukama kanaaráq yiminé iné.” téta áá awááguraawana ");
INSERT INTO usa_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Îtuma timá yímikaiye: “wemmá ayúwáaro! nôraq itaráq áá awááguraao? wemá keqtábámá íráqôniq uráiye. ");
INSERT INTO usa_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","áwáyoq-wayukama keráwáqtê máqte-kanaama paá mánobo! tikáinama aati-aatimá yíwáqnaa kanaaráq ínoe. ááqibo kemá keráwákáráqá máqte-kanaama íma paá mánune. ");
INSERT INTO usa_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","wemá kanaa uráiye. wemá áqnáabaqa ketúraqa átê-akuq-nokaraqa puyónúna-kanaayaba pétikaraiye. ");
INSERT INTO usa_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","ítáaro! máqtepaqa ketí átê-wataama abarokáq timá yímikai-marukaqa wení íbêq mirái-waigoma abarokáq timá-yimiyana wenáwîqa íma awikáinoe.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","titana Yúqtaati Itakáárioti iyápó-aanabike-nakoma uyátárai-monoq-wayukayopaqa kóurena tiráiye: “kemá tíwáqnaa onaq Îtumma yáqtoqma áwîqme ínóe.” ");
INSERT INTO usa_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","titata yimuqá ôriq umá makéta meyámmá amínéta tirááe. tewana Yúqtaatima aúyánámmá iténa “nói-tupaama Îtumma oyaa umá yiráátenuno?” téna ítama táíq uréna kanaayábá abáá-abaa kéiye. ");
INSERT INTO usa_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","yammá itoraí-óníq-kánááráqá áqnáae-wagaabaqa kótáma-ki-kanaaraqa tipi-típi-araaqa ikákaawata Îtuni iyápó-annama ítama aónaraae: “náakaraqa ení kótámaki-oniqa ko kauma akánúnataabiyo?” tewana ");
INSERT INTO usa_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Îtuma iyápó-annabike kaayaq-wáyúkámá mayaí-áímmá timáyímikena tiráiye: “naa márûkaqa peráiyana móra-nakoma nommá yaqména kéyinaka wenanaaépaqa okaao. ");
INSERT INTO usa_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","naammá peráinaka min-náákóní aboámá timá ámekaao ‘tirááti-nakoma kétiye ketí naaúpaqa ketí iyápó-annagaraqa kótámaki-oniqa naí-námmá náakarabiyo?’ timáqtuwena ");
INSERT INTO usa_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","wemá anón-amuraaq-namma tiráátiniye. máqte-qtataaqa yokaa-yokaa umátikarainaka mikáqá kótámaki-oniqa kaumá tíkáakaao!” timáqtuweta ");
INSERT INTO usa_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","kóureta naa márûkaqa péketa máqtemma Îtu timá yími-qtataaqa paá aónareta kótámaki-oniqa kaumakááye. ");
INSERT INTO usa_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","énaikaqa Îtu wení iyápó-annagaraqa iráitata ");
INSERT INTO usa_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","yaareráqá aáwaqa kénaawana Îtu tiráiye: “keráwápíké móra-nakoma ítama táíq umátikanena wemá kemmá kutarurîq íniye. aáwaqa ketê náina-nakoma mirá-iniye.” titana ");
INSERT INTO usa_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","yirummá ôriq kéitata móra-mora-yuma ítama aónaraiye: “keábiyo?” titana káqomma “keábiyo?” titana ");
INSERT INTO usa_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Îtu yauwéqma tiráiye: “eé títaupake kaayapíké móra-nakoma mimórá-táápépíké kegáráqá aáwaqa kénai-nakoe. ");
INSERT INTO usa_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","agamátán-áípí Waayúka-Araakoni aamá tiráiniq umá miráuma ínana ááqibo kutarurîq í-nákóní anónnáma mú mikákááné. min-nákómá íma marákaraikakaatati mú mikákáá íráqôniq íne iné.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","aáwaqa kénaawana Îtuma yammá maténa nunamupí amuqá makéna “tíkáiye” timátuwena yímikena tiráiye: “máyáaro! ketúmiye.” téna ");
INSERT INTO usa_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","wááéni-nomma káápubi maténa nunamupí amuqá makéna “tíkáiye” timátuwena yímikaitata máqtemma nátukaawana ");
INSERT INTO usa_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Îtu timá yímikaiye: “maannáma ketí naaegómíye. taíbaq-wayukayabama atíma kéguminana ónipi nokáá umáyikanena kaayóqá kémayikaiye. ");
INSERT INTO usa_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","kemá kétima-timune. aran-nómmá móragaraqa ínanupo! ínanaaqa káqo-taoqa Áánûqtuni kawáá kéi-marukaqa káqomma nánúne.” timátuwaitata ");
INSERT INTO usa_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","imá tiréta yúbareta Óríbêti-anubaqa kóuraae. ");
INSERT INTO usa_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Îtu timá yímikaiye: “keé keráwáqá máqtemma íbêq-nokaamma táaqa káinaqa tiyuwé kóinoe. Áánûqtuni agamatán-áípí kétiye! ‘kemá tipi-típi yabi-í-náqá ikámónata tipi-típima ókaq-okaq kóinoe.’ tiráinapoata tiyuwéta kóinoe. ");
INSERT INTO usa_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","kemá tiwáutumatuwainaqa itó-uma kenókáámá Kááriribaqa ónúne.” tiráitana ");
INSERT INTO usa_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Pítaa tiráiye: “ááqibo máqtemma tébakaq-wayukama ayuwéta kóiyaqa kemá íma ayuwéqa kónune.” titana ");
INSERT INTO usa_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Îtu tiráiye: “íbêq-nokaamma kokóregoma áama íma kaayapáq tínaama emá kaumo táoqa keqtábámá tínóne. ‘min-nákómmá kemá íaonareqa íkéitaune.’” titana ");
INSERT INTO usa_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Pítaa akoqnáá umá tiráiye: “ímiye! kemá puí-kánááráqá etê puyónúne. imá ayuwéqa kónune.” titata máqtemma miráráá umá tirááe. ");
INSERT INTO usa_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Kéqtêmani-yopaqa irááwana Îtu tiráiye: “maakáq máraiyaro! nunamummá tenáá úne.” tiréna ");
INSERT INTO usa_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Pítaa Yêmitigaraqa Yóáanegaraqa yíwíqmena kéyana áaqa kaitana táíq umá yáumetaraitana arummá ôriq umá kéitana ");
INSERT INTO usa_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","tiráiye: “tirummá ôriq umá kéitaqa túyánámmá kéitaqa pukónúne. máraiyaro! waagobo! karáqtuwe máaro!” titata ");
INSERT INTO usa_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","waaqókáqá marabí aipaq aguréna aíqa mayánénaboana nunamummá tiráiye: ");
INSERT INTO usa_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","“apááô! ketiboó! máqte-qtataaqa kanaaráq kéena maa-qtátááqá paábaq-matikaao! ááqibo ení akaígómá wárááo. ketí tikaígómá íwaraao.” téna ");
INSERT INTO usa_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","yauwéré immá yú wagurááwana aónaraiye. Pítaaqtabama tiráiye: “Tááímonio! aú waguráánô? kímora-abauma íma kanaaráq karáqtuwe máqe-uraano? ");
INSERT INTO usa_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","karáqtuwe mááo! nunamummá tiyo! íma karáqtuwe máiya íma nunamummá tiráánaboaq Tááqtaan áama itánóne. aágoma kaqtó kéimanibo túgoma aqnúmmá kéena túgáibaa kéiye.” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","móragaraqa keqnáámmá nunamummá timátuwena ");
INSERT INTO usa_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","yauwéréna immá keqnáámmá yúgáibaa ôriq kéitata íma kanaaráq karáqtuwe máqe urétapoata yú wagurááwana aónaraiye. wemmá yauwéqma timá ámínon-aimma íma ítaraae. ");
INSERT INTO usa_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","wemá kaumobáq yauwaré iréna tiráiye: “waguréqa paá wagoro! áágaaniye. íbêqa aabaúmá umáguraiye, Waayúkagon-Araaqa kemmá kutarurîq i-nákómá kúmiq-wayukati iyáápi kémaraiye. ");
INSERT INTO usa_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","itó-uma kónunatiabo! aónaaro! kutarurîq umátíkarai-nakoma kéiye.” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","kétitana páátákáá Yúqtaati iyápó-annabike-nakoma iráitata wegáráqá waabámmá yáákáráqá waqtáákáráqá iréta uyátárai-monoq-wayukabike aapinaa-káyúkábíké anónuqma-wayukabikekaraq irááe. ");
INSERT INTO usa_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","kutarurîq i-nákómá awaaméqá yímikena tiráiye: “kemá ámóqnaana-nakomma yáqtoqma ánnáma áméro! áwîqmeta yaákare kóoro!” tiráiye. ");
INSERT INTO usa_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Yúqtaati iréna páátákáá Îtunopaqa kéena kaayonébáké ámóqnaraitata ");
INSERT INTO usa_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","yáqtoqma ánnáma ámiketa akoqnáá umá yáqtokaae. ");
INSERT INTO usa_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","ááqibo móra-nakoma maéna yáámmá maténa mú mikáq anó-monoq-nakoni maqné-nákóní ááraramma agáuqtukaiye. ááqaanibo téna ");
INSERT INTO usa_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Îtuma tiráiye: “nôraq itaráq maaráuma yáákáráq waqtáákáráq yáqtoraneraq kéyeo? kemá íma moyán-árááq-náqá maéqa ");
INSERT INTO usa_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","máqte-tupaaraqa keráwákáráqá anó-monoq-naupaqa maéqa aapinaammá abarokáq tiráunaqa kemmá íma yáqtoqma ánnáma ítíkikaae. ááqibo Áánûqtuni agamatán-áímmá áraimma auraíno!” titata ");
INSERT INTO usa_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","máqtemma iyápó-anna-wayukama ayuwéta péqmare kóuraae. ");
INSERT INTO usa_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","ááqibo móra-maabugoma wáqtô itokáikaraq Îtun-annaepaqa kégoitata yáqtorakaraawana ");
INSERT INTO usa_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","wemá wáqtôma ayúqtukena unáákáqtôma aneqá íma wáikaraqa awaapáá uyaaténa kóuraiye. ");
INSERT INTO usa_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","ááqibo yemá Îtumma awíqmeta mú mikákáá anó-monoq-nakoni naaúpaqa irááwata mikáqá máqtemma uyátárai-monoq-wayukama anó-kayukagaraqa aapinaa-káyúkágáráqá áíkutaawana ");
INSERT INTO usa_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","ááqibo Pítaa Îtun-anaaepaqa ayáqtáápake wakéna mú mikákáá anó-monoq-nakoni naamátûpaqa pékena kawáá-wáyúkágáráqá iraráqá maraq máena kégaanitata ");
INSERT INTO usa_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","ááqibo uyátárai-monoq-wayukama máqtemma káánítôre-wayukagaraqa Îtumma ikamínéta aítaa umá abáá kéomanibo íma máqe-uraiye. ");
INSERT INTO usa_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","taíbaq-wayukama kaaqaari-áímmá Îtuqtabama timákáreta ááqibo mimórá-wátáámá íma kéteta káqo-kaqon-aimma netuqyaa tirááe. ");
INSERT INTO usa_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","ááqibo tébakaq-wayukama itó-uma kaaqaari-áípí tirááe: ");
INSERT INTO usa_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“wemá tiráitata ítaraawana tiráiye: “maamin-ánó-mónóq-námmá waayúkama tarôq uráá-namma kemá yauwítíyuwaiyaqa kaumo-wágáábí aúgemma tarôq ónááq únnae waayúkama íma tarôq kéiya-namma tarôq ónúne.” tirááwana ");
INSERT INTO usa_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","yeqtí watáagoma íma móraiq uráiye. ");
INSERT INTO usa_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","mú mikákáá anó-monoq-nakoma yeqtí aúkáapimma itó-urena Îtumma aítaa umá aónarena tiráiye: “wení watáayaba yauwéqma íma kanaaráq timá abarokáq tinónô?” titana ");
INSERT INTO usa_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Îtuma páátí máqe-urena aamá ítiraitana mú mikákáá anó-monoq-nakoma móragaraqa ítama aónaraiye: “emá Metáíyabono? mú mikákáá uyátárai-manikoni áanikobono?” tiráitana Îtuma yauwéqma tiráiye: ");
INSERT INTO usa_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","“máune.” téna “Waayúka-Araakoma Áánûqtuni ayáánurapaqa maraq máena wíyokoni konnákáq kumínata aónanoe.” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","mú mikákáá anó-monoq-nakoma áyámma uráitana unáákáqtômma yuráqtukena tiráiye: “nôraq itatáá káqo-kataama itánétaa kéunataabiyo? ");
INSERT INTO usa_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","wenamáárîqa kaaqaari-áímmá tiqtábámá nói-tuyananaq kéitaao?” titata máqtemma yauwéqma tirááe: “wemá mú mikákáá táíq uréna puíno.” tewata ");
INSERT INTO usa_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","tébakaqa Îtumma wirááti wirákáreta aúramma yawááq-ureta ikamíq-ikamiq kéeta tirááe: “náawa ikákaiyo?” tirááwata kawáá-wááyúkámá áwîqmeta iyáán-arunapo ikákaae. ");
INSERT INTO usa_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Pítaa naamátûpaqa paá máitana móra-inaaruma mú mikákáá anó-monoq-nakoni maqné-ínáárúgómá ");
INSERT INTO usa_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Pítaamma iraráqá aónarena wemmá karáqma káonena tiráiye: “emá Îtuma Náátárêtibake-nakote máqe-uraane.” titana ");
INSERT INTO usa_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Pítaa tiráiye: “ímiye. enáama íkéiteqa íma ítaraune.” téna oqtaráq kóuraitana kokóregoma áama tiráiye. ");
INSERT INTO usa_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","anaaékaqa min-ínáárúgómá móragaraqa káonena móra-nakoma amakaq mái-nakomma timá ámikaiye: “wemá min-nákóní iyápómiye.” titana Pítaa ");
INSERT INTO usa_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","“ímiye.” tiráiye. ááqibo pááqyamma anaaékaqa mikáq máa-kayukama Pítaamma timá ámikaae: “Kááriribake-nakoma máeboaa emá iyápó-annabike mórabi máane.” tewana ");
INSERT INTO usa_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Pítaa timá akoqnáá uréna tiráiye: “ááqibo kemá kaaqaari kétunaraa Áánuqtu tíkamine iné. min-nákómá íaonareq íkéitaune!” titana ");
INSERT INTO usa_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","kokóregoma móragaraqa áama tiráitana Pítaa Îtuma tiráin-aikoma aákaq itana ítaraiye: “kokóregoma áama kaayapáq íma tíráinaama emá kaumo táoqa keqtábámá wemmá íkéitaune tínóne.” tiráin-aimma Pítaama yauwéqma aúyánámmá ítaraiye. ánibo ibiqá ôriq umá yakáiye. ");
INSERT INTO usa_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","aabáyaanapimma nokáápaqa uyátárai-monoq-wayukama anó-kayukagaraqa aapinaa-kááyúkágáráqá káánítôre-wayukagaraqa watáá-wataa timátuweta Îtumma yáqtoqma ánná kúmeta anó-kamaani-nakonopaqa mó ámikaawana min-ánó-nákóní áwîqa Pááíratima ááqibo téna ");
INSERT INTO usa_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pááírati Îtumma aítaa umá aónarena tiráiye: “emá Ítíráaeo-wayukati mú mikákáá anómma yabíkáánabono?” titana Îtuma yauwéqma tiráiye: “téne.” titata ");
INSERT INTO usa_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","uyátárai-monoq-wayukama weqtábámá tirááe: “wemá taíbaq-taigo-qtataariq uráiye.” tewana ");
INSERT INTO usa_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Pááírati móragaraqa ítama aónaraiye: “yauwéqma íyaq timá-yiminono? eqtábámá taíbaq-taigon-aimma kétee.” titana ");
INSERT INTO usa_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Îtuma páátí máena móragaraqa yauwéqma ítima-amitana Pááíratima ítama iyánáaq uráiye. ");
INSERT INTO usa_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","ááqibo kótámaki-onikaqa aati-aatimá Pááíratima móra ánná-naupaqa mái-nakoma ayuwéwaimiye. wáátigoma awaaméqá maréta tewana Pááíratima ayúwáitana ánná-naupake kanaaráq ayúbákáitana kó éwaimiye. ");
INSERT INTO usa_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","ááqibo mi táoqa kaarabútibi móra-nakoma áwîqa Baráábatima máqe-urena anón-aaiqa wemá taíbaq-wayúkagaraqa uréna wemá móra-nakomma arááq ikámítana pukitana kaarabútibi máqe-uraiye. ");
INSERT INTO usa_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","ááqibo waabámmá áíkuteta Pááírati ánná-naupake ayúwái-nakoqtabama ítama aónaraae. aónaraawana ");
INSERT INTO usa_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pááírati ítama yimónaraiye: “Ítíráaeo-wayukati mú mikákáá anómma yabíkái-naqa ayúbakanuno?” téna ");
INSERT INTO usa_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","uyátárai-monoq-wayukati yáaimma ítareta paá yirunóbáqá kárún-aimma kétetaboata Îtumma ánnáma ye ámikaae. miráuma ítarena tiráitata ");
INSERT INTO usa_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","uyátárai-monoq-wayukama waabámmá timá yímikaae: “Baráábatiqtaba kétikaiqtaae tero!” miráitata waabámmá timá yímikaae: “Baráábatimma ayúqmataa timiyo!” tewata keqnáámmá ");
INSERT INTO usa_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pááírati móragaraqa timá yímikaiye: “ááqibo Ítíráaeo-wayukati mú mikákáá anó-nakoqtabama nôraq ónúno?” titata ");
INSERT INTO usa_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","waabámmá kabámareta tirááe: “yaaraqá nírigaraqa ikámíyana puíno?” tewana ");
INSERT INTO usa_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pááírati ítama yimónaraiye: “nóin-otaaniraq uréna nói-taigoniraq uráinabiyo?” titata mú mikákáá anókaq kabámareta tirááe: “yaaraqá nírigaraqa ikámíyana puíno!” tewana ");
INSERT INTO usa_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pááírati waabá-káyúkátí yimuqá máráinapoana Baráábatimma ayúbákaraiye. miráumatuwena Îtumma i-wáyúkámá yímikena timá yímikaiye: “akoqnáá-annanapo ikámoro! ikáqtuwera yaaraqá nírigaraqa ikámíyana puíno!” téna Pááírati tiráiye. ");
INSERT INTO usa_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","timátuweta i-wáyúkámá Îtumma áwîqmeta kámááni-nakoni naamátûpaqa iréta tébakaq-i-wayukama yááyareta ");
INSERT INTO usa_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","tokô-kaqtoma mú mikákáá anó-nakoni wáqtôraa-katoma matéta áwáábiq-annama matéta mú mikákáá anó-nakoni kámokaa-kamoqa atoyumá tarôq uréta Îtuni aqnókáqá abákareta ");
INSERT INTO usa_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","paá awaaméqá umá kaaqaarigó kaayoné umákareta tirááe: “Ítíráaeo-wayukati mú mikákáá anó-nakoni áwîqa múte yaúyoro! wemá anó-kanaama ayáqtáákaqa paá maíno!” téta ");
INSERT INTO usa_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","oótátánápó aqnókáq kéikameta kaáqá kémareta yiraayutaúmá ayéta kaayoné umáketa ");
INSERT INTO usa_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","ámiyoq-naayoq éta tokô-kaqtoma yukéta wení wáqtôma móragaraqa umáketa áwîqmeta yaaraqá nírigaraqa ikamínô-marupaq kóuraae. ");
INSERT INTO usa_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","kégoeta móra-nakomma yáqtokaamma wenáwîqa Tááímoni Tááírínipake-nare. Érékáánarayaa Árûbatiti yiboámá wemá yópáké kéitata yemá Îtuni kaapaq-yámá ámiketa timákaawana aqména kóuraiye. ");
INSERT INTO usa_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Îtumma áwîqmeta móra-anuraqa iréta min-ánúgóní áwîqa Kórákóta-anue. áwîkoni áaimma aqnón-ayaatapare. ");
INSERT INTO usa_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","mibáqá iréta wááéni-nomma yaagóní anókáráq waéqma ámikaawana ínaraitata yaaraqá nírigaraqa aráápama ikákaae. ");
INSERT INTO usa_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","ikáqtuweta wení unáákáqtôma yáíkaaq umá uréta aábê yaréta unáákáqtôma móra-mora umá matááe. ");
INSERT INTO usa_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","ááqibo nírima ikákaan-abauma (9.00 kiroki) aabáyaanapimma aabaúmá kéuitata ikákaae. ");
INSERT INTO usa_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","yaaraqá aúbama wení táígoqtabama agáyáan-aikoma tiráiye: “Ítíráaeo-wayukati mú mikákáá anómma yabíkái-nare.” titata ");
INSERT INTO usa_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","ááqibo wegáráqá kaayaqá moyánákáratámá yíkaketa Îtuni aukápáq mórama ayáánurapaq maréta mórama ayáánuropaq maréta urááe. ");
INSERT INTO usa_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","ááqibo miráuma monoq-áúbábí naayóbáqá agamátán-áíkómá tiráiniq umá íbêqa áraimma mirá kéiye: “wemmá otaa-káyúkábí makááe.” téna tiráine. ");
INSERT INTO usa_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","yaaraqá máitata waayúkama kótayata kéeta iyáátaq-iyaataq yumá ámiyoq-naayoq kéeta aamá káwaageta tirááe: “enamáárîq anó-monoq-namma yawítíyuwe kí-kaumo-yupaama móragaraqa keqnáámmá tarôq ínáq óne ");
INSERT INTO usa_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","ááqibo yaaraké enamáárîq kumuwo! enamáárîq kuméma ípuinone.” tewata ");
INSERT INTO usa_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","keqnáámmá uyátárai-monoq-wayukama aapinaa-káyúkágáráqá ámiyoq-naayoq kéeta tirááe: “wemá káqo-yuma yíwâqnaa uráitata íma pukáábo wenamáárîq íma kanaaráq áwâqnaa éna miráipoana puíniye. ");
INSERT INTO usa_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","ááqibo Metáíyama máikakaatati Ítíráaeo-wayukati mú mikákáá anó-nakoma yaaraké kumínataa aónétaa mikáq itánúnatae.” tewata keqnáámmá wegáráqá yíkakaa-nakorata ámiyoq-naayoq-aimma timákaraaye. ");
INSERT INTO usa_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","ááqibo wágááma aabaúmá aúkáapi uyáwitana kumayuqá aúqma máqte-maruqa yawááquraiye. ");
INSERT INTO usa_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","aabaúmá kaumoráq kégumitana Îtuma kabámarena anókaq wááqa kéyena tiráiye: “Érói, Érói, arááma tebákátáni?” téna wenáabike mirá kétiye: “ketí Áánûqtuo, ketí Áánûqtuo, nôraq itaa tiyúkáano?” titata ");
INSERT INTO usa_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","tébakaqa máqeo-kayukama ítareta tirááe: “ítáaro! wemá Iráíyamma kááyaiye.” tewana ");
INSERT INTO usa_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","móra-nakoma uyaaté iréna parubaru-wánnáámá ikaaq-nókáráqá yátaraq makéna Îtumma ámitana nátúwáitana min-nákómá tiráiye: “éqtukaiyanao! Iráíyama yaaraké yamatuwáinana kumínaayaba aónaaro!” titana ");
INSERT INTO usa_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Îtuma anókaq wááqa yumátuwena pukuráiye. ");
INSERT INTO usa_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","pukitana ááqibo anó-monoq-naupaqa oqtaráq tabaraáberaa-kannaama abí kúmakaama wenamáárîq aúkáapike kabááqma yakákuraiye. ");
INSERT INTO usa_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","ááiq-i-wayukati kawáá-nákómá máitana Îtu aúbáqá itó-uma máitana Îtuma wááqa yumátuwena pukitana aónatuwena wemá tiráiye: “áraine. min-nákómá Áánûqtuni áaniko máqe-uraiye!” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","ááqibo aaranaamá mikáqá nékaq máeta káoneta Tárômeyaa Máríaa Máátariniyaa Máríaa maqné Yêmitiyaa Yótéti anóaratama máqe-ureta ");
INSERT INTO usa_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Kááriribaqa yemá Îtuni anaaé waqmé kéweta áwâqnaa urááe. taíbaq-kaqon-noinima Îtugaraqa Yérútáárebaq uráán-noinima mibáq nékaq máqe-uraae. ");
INSERT INTO usa_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","ááqibo aabaúmá karaakáq kúmitana Tabaatiráqá yokaa-yokaa-í-yúpáámá wáitanaboana Yótêbi Aarimatéabake-nakoma iréna wemá káánítôre uyátárai-naqa maéna Áánûqtuni kawáá kéi-kanaayabama awé kéiye. ");
INSERT INTO usa_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","mimórá-nákómá Pááíratinopaqa ikatîq íma uréna Îtuni arááq-auyabama ítama aónaraiye: “timínónó?” tíminaq mó-uqtamakaano.” titana ");
INSERT INTO usa_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pááírati aúyánámmá ítarena “árainaq pukuráinabiyo?” téna i-wáyúkátí kawáá-nákómá ááyarena ítama aónarena tiráiye: “ara pukáiyo?” titana kawáá-nákómá timá ámikaiye: “owé pukáiye.” téna ");
INSERT INTO usa_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Pááírati iyánáaq umárena ítátuwena Yótêbimma timá ámikaiye: “kanaaráqíye. arááq-auma mayaao.” titana ");
INSERT INTO usa_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Yótêbi kateko-wánnáámá meyánîq umá maténa yaaraké aúma maténa wannaabí atáá-umakena óqtanobaqa maipí uqtamákena anón-oqtamma muríákóní ótaqa makéna yawááq-uraiye. mirá umáqtuwaitata ");
INSERT INTO usa_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Máríaa Máátariniyaa Máríaa Yótétini anóagaraqa máeta uqtamákaraipaqa aónaraaye. ");
INSERT INTO usa_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Tabaatimá ánatagitata Máríaa Máátariniyaa Máríaa Yêmitini anóama Tárômegaraq átê-kuyumma i-qtáqtááqá meyámmá maqméta Îtumma pérakaneta matááe. ");
INSERT INTO usa_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Tóqtaaraqa iráqma tágagikaqa uqtamákaraapaqa kóureta ");
INSERT INTO usa_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","kégoeta watáá-wataa tiréta “náawa oqtaráké óqtamma mamá páabaq “aukátikanitaabiyo?” ");
INSERT INTO usa_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","anón-oqtapoana ummaa yánitata tirááe. kéteta ko aónaamma óqtamma páabaq aukákuraitata aónaraae. ");
INSERT INTO usa_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","miráitata muríyánóbáqá péketa aónááyama móra-mabugoma wayán-únákáqtôgaraqa mibáqá maraq máqe-uraitana aónaraawana yáaqa ôriq umá karáitana min-nákómá tiráiye: ");
INSERT INTO usa_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","“táaqa ígáino! Îtuma Náátárêtibake-nakomma kaapaq-yátáráq ikámaraa-nakomma abáá kéoyamma wemá pukáipike itó-urena íma máiye. uqtamá káraapaqa aónaaro! ");
INSERT INTO usa_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","ááqibo wení iyápó-anna ko timá yímero! Pítaagaraqa timá áminata timá yímero! ‘Îtuma we-nókáámmá Kááriribaqa kégoitata mibáqá aónanowana keqnáámmá wemá keráwáqá miráuma timá tímikaiye.’” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","aanibo yemá yáubareta muríyápáké uyaaté kóureta ikatéyana yáaqa karáitatapoata páátí máqe-ureta máqte-kayukama íma timá yímikaae. ");
INSERT INTO usa_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Îtuma pukuráipike itó-umatuwena Tóqtaa-abayaanapimma nokáápaqa wemá áqnáabaqa Máríaa Máátarininopaqa iráiye. naayóbáqá min-íníkóní arunóbáké abapaké kaayaq-kútí-áágómá Îtuma waqtukáiye. ááqibo iráitana aónarena ");
INSERT INTO usa_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Îtuni aanábómá ibiqá kéyaraawana ko timá yímikaiye Îtuma paá máitana aónarena ");
INSERT INTO usa_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","timá yímiqtuwena kéiteta wenáama irunóbáqá íma ítaraae. ");
INSERT INTO usa_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","anaaékaqa waéqma káqon-nakaa umá kaayaq-nákórátá yeqtôpaqa iráitata karaa-márúkáqá kégowana iráitata aónareta ");
INSERT INTO usa_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","yauwaréta tébakaqa timá yímikaawata kanaaráq íma ítaraae. ");
INSERT INTO usa_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","ákaqa Îtuma wení iyápó-annama yeqtôpaqa iráitata ye títaupake móra-anna-wayukama aáwaqa kénaawana Îtuma iréna áá yiwááguraiye. yemá irupí íkéiteta káúbîq uréta wemá pukáipike itó-itata aónaraa-kayukama temmá íkéitaawanaboana áá yiwááguraiye. ");
INSERT INTO usa_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","wemá timá yímikaiye: “máqte-marukaqa kóoro! máqte-kayukama maan-áté-wátáámá mó-tima-yimero! ");
INSERT INTO usa_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","máqtemma yirupi kéitaa-kayukama nommá peráiyaqa atóbamayikanune. íkeitaa-kayukama yawááq-umayikanune. ");
INSERT INTO usa_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","aamá kéitaiya-kayukama maamin-áwááméq-yátááqá mayéta ketíwîkake kuti-áágómá waqtuwánoe. aúgen-aimma mayénama aúgen-aikaraq tínana ");
INSERT INTO usa_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","puí-íráákábáyáámá yáqtoraiyana ípuinana uwaatagááq-yátááqá naínama ípuinana karí-wáyúkámá ánekuiyanama karímá éqyikainata atóbaginoe.” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","timátuwena áwíkaitana Áánûqtuni kawáá kéi-marukaq uténa Áánûqtuni aukápáqá maráq máqe-uraitata ");
INSERT INTO usa_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","wení iyápó-annama máqtepaqa ko timá yímikaae. abarokáq timá yímikaawata uyátárai-nakoma yegáráq yíwâqnaa uréna yé tiráama áraimma kéitana uyátárai-nakoma awaaméqá yímikaiye. ");
INSERT INTO usa_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Tíópiratio, naayóbáqá netuq-wáyúkámá iyááté-íyááté umá ketááí aúkáapi Áánûqtuma máqte-qtataaqa tarôq urái-kataama agatáane. ");
INSERT INTO usa_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","yemá mi-qtátááqá yúrapike aónaraa-kayukati yáama naayóbákáráq aati-aatigáráqá wakáane. yemá mi-káyúkámá Áánûqtun áaraqa wení mayaí-wáyúkámá máeta yemá maami-kátáámá keqtáá timá tímikaataae. ");
INSERT INTO usa_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","anó-nako, miráitaq kegáráq kemá maami-kátáámá agamá enôpaq yuwánáae téq kétune. maami-máqté-qtátááqtábámá áaimma ítátukaune. íbêqa kemá arupú umá agatáunamanibo miráuma áqnáabaq-kanaarake iráinikaa uráiye. ");
INSERT INTO usa_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","miráinaa emá ítama arutánóne min-áímmá emmá aráátíyamma minnâ áraine. ");
INSERT INTO usa_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Érôtima Yúría-marukaq kínima mái-kanaaraqa mórama monoq-náqá máqe uráimma min-nákóní áwîqa Tékáráíyae. wemá Ábááíyan-annabike monoq náqiye. ánáakoma Éronin-annabikemma min-íníkón awîqa Irítabetie. ");
INSERT INTO usa_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","yenákámá Áánûqtuni aúrakaqa íráqôniq urááye. yenákámá máqten-amaan-aimma waréta uyátárai-nakoni áama kéwaraayanaboana yepímmá otaa-qtátááqá íma wáqe-uraiye. ");
INSERT INTO usa_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","miráimanibo yenákámá mórama iyápóma íma ákáraaye. Irítabetima iyápóma íma kanaaráq marákáitata yenákámá araaqná anónuqma kamáguraaye. ");
INSERT INTO usa_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Tékáráíyan-anna-wayukama mayaírátáá owana Tékáráíyama Áánûqtuni aúbáq monoq-máyáímá matáiye. ");
INSERT INTO usa_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","anó-monoq-wayukati yáaimma waraíkáae téta Tékáráíyamma awaaméqá umáketa weqtábá uyátárai-nakoni aokaq-náúpáqá uténa átê-kuyumma i-qtátááqá agamá ákûq íkáae. ");
INSERT INTO usa_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","agamá ákûq-umumma í-kánááráqá mi táoqa taíbaq Íbaru-wayukama máápaq áíkuteta nunamummá kéteta máqe-uraae. ");
INSERT INTO usa_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","ánibo Tékáráíyama aónaimma uyátárai-nakoni kaqtó-nakoma agamá ákûq íyáárégóní ayáánurapaq itó-uma máqe-uraiye. ");
INSERT INTO usa_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Tékáráíyama kaqtó-naqa aónatuwena iyánáaq umárena ikatîq uráimanibo ");
INSERT INTO usa_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","kaqtó-nakoma Tékáráíyamma timá ámikaiye: “Tékáráíyao, emá ikatîq íuwo. Áánûqtuma ení nunamummá ítátukaiye. enánáakoma Irítabetima iyápóma inaamaímá marakániye. ánibo emá min-íyápógóní áwîqa Yóáane té yamámiyo. ");
INSERT INTO usa_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","enáyakoma íráqôniq umá wáinaa amuqá maránóne. netuqyaa-káyúkámá wemá pááq í-nayaba yimuqá maránóe. ");
INSERT INTO usa_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","uyátárai-nakoni aúrakaqa anón-awiqa wániye. ánibo wemá wááéni-nokaraq akoqnáá-nokaraqa íma nániye. ánibo wemá anóani áyaqnobaqo márainanama Áánûqtuni Aokaq-Áágómá wepímmá ógiraniye. ");
INSERT INTO usa_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","wemá taíbaq Íbaru-wayukama mamá yirummá waeráiyana yeqtí uyátárai-naqa Áánûqtunopataa yauwéqma yíwíqme íniye. ");
INSERT INTO usa_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","wemá Áánûqtuni watáagaraq mamé wéna wení akoqnááma maména Iráíyaraa umá mamé wínímma Áánûqtuni naayóbáq-ámúné-nákáá umá mániye. wemá anóboyugaraq yeqtí yíráabitigaraq yíwíqmena mórabi máá áíkuiniye. Áánûqtuni aammá íma wáráiya-kayukama yeqtí yúyánámmá mamá waeráinata yemá keqnáámmá mamá yokaa umáyíkarainana Îtuma kumíniye.” ");
INSERT INTO usa_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Tékáráíyama kaqtó-nakomma maará téna timá ámikaiye: “kemá náaraq ínaraq maamin-áímmá áraine téq itánúnô? kemá anónuqma kamágúnana ketínáakogaraq araaqná kamáguraiye.” téna Tékáráíyama tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","ánibo kaqtó-nakoma yauwéqma tiráiye: “kemá Kébariomune. Áánûqtunopaq itó-uma kémaune. maamin-íráqón-áímmá wemá timátíkáitaq emmá timámena kukáunamanibo ");
INSERT INTO usa_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","ketáama íma itáánaboana óyáukoma aráápaginaa aamá íma tínónaboana wéqéna aamá túnnayataakoma pááq ínnaraq wíniye.” téna kaqtó-nakoma tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","aarawaamá paá Tékáráíyani awé uréta netuq-yúyánámmá ítaraae. ‘aokaq-náúpáqá nói-qtataaraq pááq uráitanawaq átáyaaqa minnóbáqá máiyo?’ téta tirááe. ");
INSERT INTO usa_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","anaaékaqa Tékáráíyama máápaq yaúbarena aarawaamá aamá íma timá yíméwaniq uráiye. miráitana paá ayáánapo awaaméqá umá watáama timá yímikaibo óyáuqa aúyakuraiye. yemá ítaraae Tékáráíyama móra óq-yataaqa aokaq-náúpáqá aónaitana óyaukoma aúyakuraiye. ");
INSERT INTO usa_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","anaaékaqa Tékáráíyani mayaí-kánáámá ánatagitana wení naaópaqa yauwéqma kóuraiye. ");
INSERT INTO usa_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","anaaékaq ánáakoma Irítabetima araaqnágoma ámûkarariq urénaboana aúpáq máitana móra-tiyaapaq-wiyomma yáuraiye. ");
INSERT INTO usa_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Irítabeti wenáúyánápímmá maará téna tiráiye: “uyátárai-nakoma kaayoné umátikena aarawaatí yúrakaq tigae íyábá mamá paá kéumatikaiye.” téna tiráimanibo móra-inikoma iyápóma íma kanaaráq ákáin-inikomma Íbaru-wayukama wemmá timá agaeráq kákaae. ");
INSERT INTO usa_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","abapaké móra-wiyokaqa Áánûqtuma kaqtó-naqa Kébariomma timákáitana móra-maruqa Kááriribaq kukáimma áwîqa Náátárêtibare. ");
INSERT INTO usa_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","mórama inaarúmá áwîqa Máríaa móra-nakoma mayániye téta ataa makáan-inikonopaq kukáiye. minnámo aúyarakaraa-nakon áwîqa Yótêbie. min-náqá Tébitin-annabikene. ");
INSERT INTO usa_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","kaqtó-naqa Áánûqtunopake Kéberioma min-íníkónôpaq uréna tiráiye: “kaayoné-yátááqá etê waíno. Aánûqtuma etê máena íráqô-qtataariq kéumakaiye.” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Máríaama min-áímmá ítátuwaitana aúyánákómá ummaa yáguraiye. ánibo áyáqnobaqa maará téna aúyánámmá ítaraiye: “maaminnáma nóin-ainabiyo?” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","ánibo kaqtó-nakoma timá ámikaiye: “Máríaao, emá ikatîqa íuwo. Áánûqtuni áyákoma emmá íráqôniq kéumakaiye. ");
INSERT INTO usa_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","itaao. emá ámûkarariq uré iyápóma inaamaí marakaínónama emá áwîqa Îtue té yamámiyo. ");
INSERT INTO usa_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","wemá anó-naqa mániye. mú mikákáá anó-naqa Áánûqtuma wení áanikoe téta áwîqa yánóe. áítaubikoma Tébitiraa umá anó-kinima wemmá uyátárai-nakoma Áánûqtuma tarôq umákaniye. ");
INSERT INTO usa_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","wemá Yáakobon-anna-wayukati anó-kinima aati-aatimá mániye. miráinana wemá yabíkáí-qtataaqa íma ánataniye.” téna Áánûqtuni kaqtó-nakoma tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Máríaama kaqtó-nakomma maará téna timá ámikaiye: “mi-qtátááqá náaraq umáwaq pááq íniyo? kemá móra-naqa íma matáune.” téna Máríaama tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","ánibo Áánûqtuni kaqtó-nakoma yauwéqma timá ámikaiye: “Áánûqtuni Aokaq-Áágómá enámûraaq kumínana Áánûqtuni uyáta-maqma akoqnáá-yataakoma ekáq pááq íniye. miráinata min-áókáq-íyápómá anaaékaq emá marákénatama maará téta áwîqa yánóe ‘Áánûqtuni áanikoe.’ tínóe. ");
INSERT INTO usa_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","itaao. enanógaaoma Irítabetima araaqná kamágimanibo áyáqnobaqa iyápóma inaamaímá matokáiye. naayóbáqá téta ‘wemá iyápóma kanaaráq íakaniye.’ tiráámanibo íbêqa ámûkaraq máitana abapaké móra-wiyomma kóiye. ");
INSERT INTO usa_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Áánûqtuma kanaaráq máqte-qtataariq íniye. ");
INSERT INTO usa_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","ánibo Máríaama tiráiye: “kemá uyátárai-nakoni mayaí-ínímúne. kanaaráq Áánûqtuma kemmá emá ténnaiq umátikaniye.” téna titana Áánûqtuni kaqtó-nakoma mikáké ayuwéna kóuraiye. ");
INSERT INTO usa_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","mi-kánááráqá Máríaama páátákáá itó-uma Yúríabaq móra-maruqa anuáráaq-mapaq uráiye. ");
INSERT INTO usa_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","ánibo wemá Tékáráíyani naaúpaq uréna Irítabetimma áwátiraiye. ");
INSERT INTO usa_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Irítabetima Máríaama áwátin-aimma ítátuwena iyápóma Irítabetini áyaqnobaq máin-iyapogoma kanageq uráiye. Áánûqtuni Aokaq-Áágómá Irítabetimma ógikaitanaboana ");
INSERT INTO usa_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","anókaq ááyama tiráiye: “máqte-noiniti aúkáapikemma emmá Áánûqtuma awaaméqá umákena awíkaita min-íyápómá marákánónama wemmá Áánûqtuma awaaméqá umákena awíkaiye! ");
INSERT INTO usa_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","kemá nôraq uráunanawaq ketí uyátárai-nakoni anóama ketôpaqa iráíyô? ");
INSERT INTO usa_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","taákoma emá tíwátennama kéitaitana tíyáqnobaq iyápóma mái-waigoma amuqá maréna kanageq uráiye. ");
INSERT INTO usa_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","uyátarai-nakoni watáama emmá timá ámikain-aimma áraimma pááq íniqtaba itáíq-itaiq ínónaboa emá amuqá kémaraane.” téna Irítabetima mirá tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","maamin-ímá Máríaama maará tiráiye: “kemá ketirupikémmá uyátárai-nakon áwîqa múte kéyauyune. ");
INSERT INTO usa_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Áánûqtuma wemá kemmá mamá paá kéumatikaiye. weqtábábóana tirun-íyápógómá amuqá kémaraiye. ");
INSERT INTO usa_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","kemá paá wení mayaí ínímánibo wemá keqtábá aákaq matokáiye. ");
INSERT INTO usa_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","kekáqá anó-qtataaqa uyátá-maqma tarôq uráipoata máqte-marabi-kayukama maa-kánááráké yemá keqtábámá téta ‘Áánûqtuma awaaméqá umákena awíkaiye.’ téta tínóe. Áánûqtuma wenáwîkoma aokaríq kéiye. ");
INSERT INTO usa_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","yemá náayubi weqtábá ikatîqa móra-wayukati-kanaagaraq káqo-kayukati kanaayábágáráq kéo-kayukama yemmá wemá arummá kéumayikaiye. ");
INSERT INTO usa_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","wemá wení akoqnáá-ayaamma arúqtuwena waayúkama yetí yúma mamé kéuyeta mirá onaae teq-qtátáákáráq wemá mamá pípêban umátuwaniye. ");
INSERT INTO usa_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","kateko-yáínáí-nákáá umá kíni-kayukama yetí akoqnáágaraq náápaakaraq-yibiqtatama mamá paábaq yukéna káqomma paá-wayukama yemmá múte yaútaiye. ");
INSERT INTO usa_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","ánibo yáayaba kéo-kayukama wemá mamá íráqô-qtataaqnapo. maqmá ógikaimanibo taíbaq-otamma makáa-kayukama yetí iyáápima móra-yataaqa íma yiména timá yíkaraiye. ");
INSERT INTO usa_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","ketááí títaubikokaq wemá timá akoqnáá umákaimma Áánûqtu paá matokáine. Ítíráaeoma wení kaqtó-nakoma naayóbáqá áwáqnaa uréna ");
INSERT INTO usa_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Áabaraakaraq wenánnágáráq arummá umáyikena minnáyaba aati-aatimá aúyánámmá ítame utáine.” téna Máríaama ibí tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Máríaama Irítabetite kaumo-wíyómmá máqena anaaékaqa wenamáápaq yauwéqma koúraiye. ");
INSERT INTO usa_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Irítabetima iyápó marakání-kanaama yáwitana iyápóma inaamaí marákáraiye. ");
INSERT INTO usa_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Irítabetin-anna-wayukagaraq móra-marukaq-wayukagaraq uyátárai-nakoma Irítabetimma nôrabi umákái-qtataaqtaba ítátuweta yimuqá marákáraae. ");
INSERT INTO usa_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Áánûqtuni waayúkati yáaimma waréta abapaké kaumo-kánááráqá min-íyápógóní áúma karánéta urááe. min-íyápógóní áwîqa aboán áwîkaq ‘Tékáráíyae’ téta áwîqa yamámineta uráámanibo ");
INSERT INTO usa_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","min-íyápógóní anóama téna “ímiye.” tiráiye. “ketáámá Yóáane tétaa áwîqa yamámenunatae.” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","ánibo waayúkama tirááe: “mórama maamirán-áwíqá enawaammá íma wáiye.” téta tirááe. ");
INSERT INTO usa_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","mirá-timatuweta Tekáráíyama íma kanaaráq aamá titatabóata yemá awaaméqá iyáánapo umátuweta aboámmá ítama aónaraae. ‘nóin-awiraq maamin-íyápógómmá yamáminono?’ téta tirááe. ");
INSERT INTO usa_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","ánibo Tékáráíyama aúba agayaí-yátááqá ítama maténa maará téna agatáiye: “min-íyápógóní áwîqa Yóáane.” titata yemá iyánáaq urááe. ");
INSERT INTO usa_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","ánibo é mikáq Tékáráíyama aamá keqnáámá áaimma átama kétena Áánûqtuni áwîqa múte yaútaiye. ");
INSERT INTO usa_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","miráitata máqtemma wení móra-marukaq-wayukama ikatîq urááe. ánibo mi máqte-qtataaqo pááq i-wáígóní watáagoma Yúríabaqa anuáráaq-marupakaraq wéyáwé uráiye. ");
INSERT INTO usa_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","máqte-kayukama maami-kátáámá ítáa-kayukama íyaqnobaqa netuq-yúyánámmá itéta maará-tiraae: “anaaékaqa maan-íyápógómá náaraq umáwaq mániyo?” téta tirááe. ánibo uyátárai-nakoni akoqnááma wepí wáitataboata máqte-kayukama ítaraae. ");
INSERT INTO usa_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","min-íyápógóní aboámá Tékáráíyama Áánûqtuni Aokaq-Áágómá ógikaitanaboana amunémá kuténa tiráiye: ");
INSERT INTO usa_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“ketáámá anómma uyátárai-naqa Íbaru-wayukati Áánûqtuma wenáwîqa múte yauyónátae. wemá wení waayúkama yíwáqnaa kéena mamá paá kéumayikaiye. ");
INSERT INTO usa_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","móra-nakoma akoqnáá umá ketááí kúmiq-yataaqa mamá paábaq yuwánéna kukáiye. min-náqá wemá Áánûqtuni kaqtó-naqa Tébitin-annabike náqiye. naayóbáqá ");
INSERT INTO usa_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Áánûqtuni aokaq-ámúné-wáyúkátí yáanapo minnáyaba Áánûqtu mirá-tiraine. ");
INSERT INTO usa_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","ketááí namuro-wáyúkágáráq yaímma íyamma umátíkáa-kayukagaraq yetí akoqnáábikema keqtáámá mamá paábaq tiyuwánitae. téna timá akoqnáá uráine. ");
INSERT INTO usa_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","ketááí títaubikoqtaba arummá umáyikena wení anón-anon-aimma timá yarúmakaiqtabama ‘aákaq maranúne’ téna Áánûqtuma tiráine. ");
INSERT INTO usa_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","74","ketááí namuro-wáyúkábíkémmá mamá paá umátikenataa túawaaq tuqmá mái-aimma akoqnáá umá ketááí tíbaubikomma Áabaraamma timá ámikaiye. wemá paá tiyúwáitaqtaa wení mayáímá kémayetaa ketáámá weqtábá ikatîqa íma éta tirummá kámunanataa ");
INSERT INTO usa_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","wemá ketááí kateko-ámmá awítíkaraitaqtaa wenáurakaqa arupú umátaa ketááí túwarauna-kanaaraqtaama kémaunatae. ");
INSERT INTO usa_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","ánibo emá ketí pááqyan-iyapoma eqtábámá ‘mú mikákáá anón-naqa Áánûqtuma wení amuné-náré’ téta tínoe. anómma uyátárai-nakoni aakaqá emá áqnáabaq kéoe. wení aammá mamá yokaa kéumake ");
INSERT INTO usa_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","wení waayúkama timá yíminata náayuwabi uyátárai-nakoma yetí kúmiq-yataaqa mamá paábaq kéyuwena awikátuwainayuma yemá yetí kúmiq-yataapikemma atóbanoe. ");
INSERT INTO usa_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","ketááí Áánûqtuma keqtáámá arummá kéumatikenata kaayoné kéiye. wemá keqtáyábá atóbaigae téna miráurai-waigoma aabaúmá utaréna kamá tágainikaa umá ");
INSERT INTO usa_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","ketááráqá Áánûqtuni márûpake ómmá kamá kétagaiye. náayuwabi íbêqa puí-yátáákóní amakaq máawana Áánûqtuni márûpake ókómá kamá kétagainata yemá kanaaráq káoneta kaayoné-ákáq kanaaráq uréire ínoe.” téna Tékáráíyama tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","anaaékaqa min-íyápógómá anómma aúkitana wení aúgaraq arun-íyápógáráq akoqnáá urááye. ánibo Yóáanema waayúkama íma máa-kaqmaapaq máqena abarokáq Ítíráaeo-wayukati yúrakaq pááq umá iráiye. ");
INSERT INTO usa_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","mi-kánááráqá Títaa Ogáátatima móra ámáan-aimma maréna máqte-kayukama yorau téta yíwîqa agayaíkaae tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","minnáma áqnáaba-kanaama yíwîqa matáámma mi-kánááráqá Kiríniatima anó-kamaani-naqa Tíriabaqa máqe-uraiye. ");
INSERT INTO usa_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","miráitata máqtemma aarawaamá yeqtí márûpaq wéyáwé uréta yíwîqa mayánéta urááe. ");
INSERT INTO usa_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Yótêbima Tébitini móra-annabike móra-naaemiye. miráitana Yótêbima Náátárêtibake Kááriri-maruqa yuwéna Yúríabaq Tébitini márûqa Béqtaremubaqa uráiye. ");
INSERT INTO usa_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","ánáakoma Máríaama ámûkaraq máitata wetê kóuraaye. ");
INSERT INTO usa_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","yenákámá mi-márúpáq paá máayana Máríaama iyápó akání-kanaama pááq uráiye. ");
INSERT INTO usa_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","ánibo purumakaakóní naúpaqa Máríaama áqnáabaq-iyapoma inaamaímá marákátuwena tabarááberake múqmútuwena purumakaakóní aáwaq-ketibi ákáraiye. minnâ waayúkama ópake ya wáí-námmá netuq-wáyúkámá ógikuraawanaboana yenákátí waíyóya-namma íma wáqe-uraiye. ");
INSERT INTO usa_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","mi-náúkápáqá yaímma tipi-típi-kawaa-wayukama anó-marukoni áwábaq máeta nokáámma yeqtí tipi-típiraq kawáá umátuweta máqe-uraae. ");
INSERT INTO usa_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","ánibo mórama uyátárai-nakoni kaqtó-naqa yeqtôpaq kúmitana uyátárai-nakoni tágama-yataakoma yekáqá tágaitata yemá ikatîq uráámanibo ");
INSERT INTO usa_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","kaqtó-nakoma timá yímikaiye: “keráwáqá ikatîqa íoro. ítáaro. kemá keráwáqtôpaq átê-wataama maméq kéyunaboana wemá mamá máqte-kayukabima yimuqá marániye. ");
INSERT INTO usa_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","mi-nókáámmá Tébitini márûkaqa móra-inikoma iyápóma marákáraiye. minnáma yauwéqma keráwáqá tiwiraí-náré. wemá Káríqtoma uyátárai-nare. ");
INSERT INTO usa_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","ánibo keráwáqá min-íyápómá aónanon-awaameqa maará íniye. minnâ keráwáqá aónáiyama min-íyápómá tabaráábebi múqmúyakaawana purumakaakóní aáwaq-taapepi waguréna máiye.” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","kaqtó-nakoma mirá-timatuwaitata páátákáá taíbaq kaqtó-wayukama Áánûqtunopake pááq uréta wágáábaq máqei kaqtó-nakote ku máqe-uraae. ánibo yemá Áánûqtuni áwîqa múte yauyéta ibí maará-tiraae: ");
INSERT INTO usa_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Áánûqtuma mú mikákáá uyáta-maqma anó-naapaakaraq wenáwîqa anókaq múte yaúyoro. ánibo maa-márábí-káyúkáyábá Áánûqtuma amuqá kémaqyikaipoana kaayoné-yátááqá yeráwátê waíno.” téta tirááe. ");
INSERT INTO usa_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","yemá kaqtó-wayukama iyuwéta yauwéqma Áánûqtuni márûpaq kówata tipi-típi-kawaa-wayukama maará-tiraae: “uyátárai-nakoma timá tími-qtataaqa pááq i-qtátááqá Béqtaremubaq uréta aónanunatae.” téta tirááe. ");
INSERT INTO usa_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","mirá-timatuweta yemá páátákáá kóuraae. ánibo yemá ko aónaamma Máríaayaa Yótêbima máayana iyápóma purumakaakóní aáwaq-taapepi waguré máqe-uraiye. ");
INSERT INTO usa_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","ánibo yemá min-íyápómá ko aónatuweta yemá Áánûqtuni kaqtó-nakoma min-íyápóyábá timá yímín-aimma tirááe. ");
INSERT INTO usa_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","tipi-típi-kawaa-wayukama ten-áímmá máqtemma náayuwabi ítáa-kayukama yemá minnáyaba yúyánámmá ítaraae. ");
INSERT INTO usa_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","yúyánámmá ítaraamanibo Máríaama máqtemmo ten-áímmá ítama arunóbátáá maréna netuq-áúyánámmá ítama aákaq maréna máqe-uraiye. ");
INSERT INTO usa_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","anaaékaqa tipi-típi-kawaa-wayukama yauwéqma kóureta máqtemma itéta aónaa-qtataaqtaba Áánûqtun áwîqa ibí múte yaútaae. kaqtó-nakoma timá yími-qtataaqa miráuma pááq uráiye. ");
INSERT INTO usa_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","anaaékaqa abapaké kaumo-kánáámá yáwitata min-íyápógóní áúma kégareta áwîqa ‘Îtue’ téta yamá ámikaae. Îtuma íma pááq uréna anóani áyáqnobaq máitana kaqtó-nakoma min-áwíqá yaráine. ");
INSERT INTO usa_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","anóakaraq wení iyápógaraq mamá íráqôniq umá aúgen-augen í-kánáámá ánatagitata miráuma Mótetini ámáan-aikoma tiráiniq umátuweta anóayaa aboámá Yérútáárebaq min-íyápómá uyátárai-nakomma amíyéta awíqmeta urááye. ");
INSERT INTO usa_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","uyátárai-nakoni ámáan-aipima agamatán-áíkómá mirá-uraiye: “áqnáabaq-iyapoma inaamaímá marakéqa minnâ máqtemma uyátárai-nakomma anóayaa aboámá ámetao.” téna ámáan-aikoma tiráine. ");
INSERT INTO usa_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","yenákágáráqá anó-monoq-nakomma amí-yátááqá amíyéta urááyamma miráuma uyátárai-nakoni ámáan-aikoma maará-tiraine: “kaayaqá anómma máaraa-numawabi káqomma kaayaqá ápôq-numaratama mamé yíno.” téna ámáan-aiko tiráine. ");
INSERT INTO usa_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","ánibo móra-naqa Yérútáárebaq máqe-uraimma áwîqa Tímionie. wemá arupú-napoana Áánûqtaba áaqa kéikatenapoana wemá Ítíráaeo-wayukama atóba iyaba awé urái-naqiye. Áánûqtuni Aokaq-Áágómá wetê máena ");
INSERT INTO usa_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","min-Áágómá wemmá timá akoqnáá umá ámikaiye: “Metáíyama uyátárai-nakoma timákáanana wíniye téna timá akoqnáá uráuna-naqa ení puínóna-kanaama íma pááq uráina wemmá aónainone.” téna tiráine. ");
INSERT INTO usa_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","miráitana Áánûqtuni Aaokaq-Áágómá Tímionimma timákáitana anó-monoq-naupaq uyábékaiye. ánibo Îtumma anóayaa aboámá awíqmeta ámáan-aikoma ti-qtátááríq íyéta óyana ");
INSERT INTO usa_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Tímionima Îtumma awíqtokena Áánûqtuni áwîqa múte kéyauyena maará-tiraiye: ");
INSERT INTO usa_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“uyátárai-nako, emá timá akoqnáá umákaana-aimma paá matokétaa íbêqa kemmá ení kaqtó-naqa tiyúwénaq kemá timuqá kémareq púyono. ");
INSERT INTO usa_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","ketí túrapike atóbamatikai-yataaqa ");
INSERT INTO usa_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","máqte-marabi-kayukayopaq emá mamá yokaa óna-naqa íbêqa kemá káonaune. ");
INSERT INTO usa_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","uyátárai-nako, maami atóbamatikai-naqa emá mamá yokaa ónama ókóráá kamá tágama Yéqtaaeo-wayukayaba ení aammá kéyiraatena ení-wayukama Ítíráaeo-wayukama anón-awiqa kéyimiye.” téna Tímioni tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Îtumma aboáyáá anóama Tímionima tin-áíqtábá iyánáaq urááye. ");
INSERT INTO usa_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","ánibo Tímionima yemmá íráqôniq kéumayikena min-íyápógóní anóama Máríaamma maará téna timá ámikaiye: “taíbaq Ítíráaeo-wayukayaba yíkama ánatanoqtabagaraq paá yiwiréta ínôqtabagaraq Áánûqtuma maamin-íyápómá awaaméqá umákena awíkaiye. wemá Áánûqtuni awaaméqá mánipoata taíbaq-wayukama wemmá áyóqa ayéta ");
INSERT INTO usa_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","aúpáq-yúyánámmá abarokáq pááq íniye. ánibo mórama tokóru-yakaa-pugoma aru-qtátááqá ení ámáabopi agaibániye.” téna Tímionima Máríaamma timá ámikaiye. ");
INSERT INTO usa_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","mórama Áánûqtuni amuné-ínímmá máqe-uraimma áwîqa Áánaae. wemá araaqnáe. naayóbáqá waamá maténa abapaké kaayaq-kárítímáátímá awaikóté máqe-uraiye. ");
INSERT INTO usa_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","anaaékaqa awaikómá pukitana ketoqá paá máqe-uraiye. ánibo abapaké kaumogáráq kaayaqté-kaayaqte-karitimaatima yáuraiye. miráitana min-árááqnágómá anó-monoq-naupaqa íma awikátuwena wéwaine. wemá aáwaqa awetá-urena nunamummá kétena Áánûqtuni áwîqa wágáagaraq nokáákaraqa múte yauyéwaine. ");
INSERT INTO usa_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","mi-kánááráqá Áánaagaraq waaqókáq iréna Áánûqtukaq ‘tíkáiye’ tiráiye. anaaékaq mi-káyúkámá Yérútáárebaq awé uráíyana yauwéqma yiwiráníqtaba yemmá min-íyápóyábá timá yímikaiye. ");
INSERT INTO usa_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","yemá máqte-qtataaqa uyátárai-nakoni ámáan-aikoma tiráiniq umá ánatatuweta kanaaráq yauwéqma Kááriribaq yeqtí naaópaqa Náátárêtibaqa kóuraae. ");
INSERT INTO usa_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","mikáqá min-íyápógómá anómma auréna akoqnáá ínéna uráiye. wemá itaí-yátááqá wepímmá ógikaitana wemmá Áánûqtuma amuqá marákáraiye. ");
INSERT INTO usa_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Îtumma anóayaa aboámá aati-aati-kárítímáátíráqá Yérútáárebaq utéta aokaq-kánáámá kótámaki-kanaae te-kánáámá aónéwaoyane. ");
INSERT INTO usa_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Îtuma yuwaaqnógoma wení karitimaatimá tiyááka umá kaayapóana wegáráq aokaq-kánáágóní áaimma waréta Yérútáárebaq utááe. ");
INSERT INTO usa_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","anaaékaqa kótámaki-kanaama ánatagitata yauwéqma kóuraamanibo min-íyápómá Îtuma paá Yérútáárebaq máqe-uraiye. ánibo anóayaa aboámá paá Yérútáárebaq Îtuma máiqtabama íaonaraaye. ");
INSERT INTO usa_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","anóayaa aboámá téta káqo-kayukate uréire kéiyaa téta tirááye. miráitata anóayaa aboámá móra-wagaama uréire umá yeqtí aanábóyóparabi móra-marukaq-wayukayopaqa abáá urááye. ");
INSERT INTO usa_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","anóayaa aboámá abáá óyamanibo íaonaraaye. miráitata Yérútáárebaq yauwéqma uréta Îtumma abáá urááye. ");
INSERT INTO usa_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","yenákámá abáá kéoyana kaumo-kánáámá yáwitata anaaékaqa aónááyamma anó-monoq-naupaq yirááti-wayukati aúkáapi máqe-uraiye. ánibo Îtuma aamá temmá kéitena yemmá anónnáma yauwéqma yekáráq ítama aónaraiye. ");
INSERT INTO usa_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Îtun áama kéiteta yemá Îtuni itaí-yátááqtábámá wemmá aamá ítáawana yauwéqma tin-áítábágáráqá ítama iyánáaq urááe. ");
INSERT INTO usa_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","ánibo anóayaa aboámá Îtumma aónatuweta anómma iyánáaq urááye. anóama Îtumma timá ámikaiye: “ketáaniko, emá nôraq itaawáq kekárátámá mirá kéumatikaano? enabotê kekárátámá anómma umaayágitaka kerátámá eqtábá abáámá kéuye.” téna Îtumma anóama tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","miráimanibo Îtuma yauwéqma maará téna timá yímikaiye: “kenákámá nôraq itakawáq keqtábámá tibáá kéoyo? aqá kemá ketiboní naaúpaqo mánunayabama kenákámá íyaq ítaraayo?” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","ááqibo Îtuma min-áímmá tiqtábámá anóayaa aboámá áaimma íma ítama arútaraaye. ");
INSERT INTO usa_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","ánibo Îtuma anóayaa aboátê kóureta Náátárêtibaq uréta aati-aatimá Îtuma anóayaa aboátí yáama wakáiye. wenanóama aákaq íní-qtataaqa aúyánápí matokáiye. ");
INSERT INTO usa_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","ánibo Îtuma anómma aúkitana wení itaí-yátáákógáráq wenáúgogaraq íráqôniq urááye. Áánûqtugaraq maa-márábíké-káyúkágáráq aónaamma íráqôniq uráiye. ");
INSERT INTO usa_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Títaama Táíbíriati tiyááka umá móra-tiyaapaq-karitimaatimo kéimma Pótíátí Pááíratima Yúría-wayukati anó-kamaani-naqa máqe-uraiye. ánibo mi-kánááráqá Érôtima anó-kinima Kááriribaq máqe-uraiye. ánibo ábâkoma Píripima Itúria-marupakaraq Térékónáítibakaraq anó-kawaama máqe-uraiye. Aráíténiama anó-kawaa-naqa Áábiriniq-marukaq máqe-uraiye. ");
INSERT INTO usa_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","mú mikákáá anó-monoq-nakaratama Áánatiyaa Kááyapatima máqe-uraaye. mi-káyúkámá kawáámá máawana áraimma mi-kánááráqá Yóáanema Tékáráíyama áanikoma waayúkama íma máa-kaqmaapaqa máitana Áánûqtuni aagómá Yóáanenopaq iráiye. ");
INSERT INTO usa_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","miráitana Yóáanema máqtemma Yótaa-nomma wáin-aukapaq uréna aarawaamá yirummá mamá waeréta nommá peraíyana Áánûqtuma yeqtí kúmiq-yataaqa mamá paá umáyikaikae téna watáama mó timá yímikaiye. ");
INSERT INTO usa_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Áánûqtuni watáama amuné-náqá Áítáíyama naayóbáqá agatáima maará téna wáiye: “waayúkama íma máa-kaqmaa-karaanobaqa móra-nakoma ááyama kétiye. ‘uyátárai-nakoni aammá yokaa oro. aammá mamá arupú oro. ");
INSERT INTO usa_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","aammá kubáutainabi maqmá ógiraaro. anumá uyátaina-maruqa mamá márûte áráwáá oro. kaé káína-amma mamá arupú oro. aumáraamaq uráina-amma mamá arútáá oro. ");
INSERT INTO usa_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","máqte-marabi-kayukama Áánûqtuma mamá atóbamayikani-arupu-yataaqa aónanoe.’” téna Áítáíyama naayóbáqá agatáine. ");
INSERT INTO usa_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","netuqyaa-káyúkámá Yóáaneqtaba nommá pétikaikaae téta yewana Yóáanema tiráiye: “keráwáqá táí-iraakabayaakoni áráakawaqoe. náawaq titaráq anaaékaqa áyámma í-yátááqá pááq íní-waigomma kanaaráq kótámatuweraq péqmare kónaae téraq kéoo? ");
INSERT INTO usa_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","keráwáqtí kúmiq-yataapike tirummá abarokáq waerá íno-qtataariq oro. keráwáqá keqtúyánápíkémmá ‘Áabaraama ketibotááé.’ ítero. téq áaimma átáma ítero. kemá keráwáqá kétima-timune. Áánûqtuma kanaaráq maamiráin-oqtamma mamá Áabaraani iyápó-annama aúrakaniye. ");
INSERT INTO usa_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Áánûqtuni kukómá yaagóní ánûpi yokaa umá wáiye. ítáaro. máqte-tagoma íarutama arammá iyaínatama kanaaráq mi-támá ayáama irabí agatuwánóe.” téna Yóáanema timá tága-yimikaiye. ");
INSERT INTO usa_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Yóáanema mirá-timatuwaitata yaímma-wayukama ítama aónaraae: “ketáámá náaraq ónúnataabiyo?” téta ítama aónaraae. ");
INSERT INTO usa_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","ánibo Yóáanema maará téna yauwéqma timá yímikaiye: “móra-nakoma kaayaqá kúberai-unamma makénama kanaaráq kúberai-unamma ímo makáína-nakomma mórama amíno. ánibo móra-nakoma taíbaq-aawaqo wáinanama mamá móraiq íno.” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","yaímma táákiti-moneqa máyáa-kayukagaraq nommá peraínéta iréta tirááe: “yirááti-nako, ketáámá náaraq ónúnataabiyo?” téta Yóáanemma ítama aónaraae. ");
INSERT INTO usa_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","ánibo Yóáanema timá yímikaiye: “móneqa ókaraq uyátá-maqma íma máyáaro.” téna Yóáanema tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","miráitata yaímma ááiq-i-wayukagaraq Yóáanemma ítama aónaraae: “ketáágáráqá náaraq ónúnataabiyo?” téta tirááe. ánibo Yóáanema timá yímikaiye: “keráwáqtí náápaatabama túma íma mamé uyéraq waayúkati móneqa íma máyáaro. keráwáqá otaa-káyúkámá íma mamá yawááq-umayikeraq móneqa máyáaro. keráwáqtí meyámmá kanaaráq umá máyáaro.” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","aarawaatí yúyánákómá itó-uma akoqnáá itata yemá íyáqnobaq maará téta yúyánámmá kóita-yaita urááe: “Yóáanema Metáíyama yauwéqmataa tiwiraí-nárábí íyabiyo?” téta tirááe. ");
INSERT INTO usa_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","miráitana Yóáanema yauwéqma timá yímikaiye: “kemá nopí nommá péqtikanune. anaaékaqa móra-naqa yínímma wení akoqnáágoma ketí akoqnááma uyátáraiye. kemá íma íráqô-naqa máunaboaq kemá kanaaráq wení aítauq-anaamma íma ayubónúne. wemá iragáráq Áánûqtuni Aokaq-Áágókáráq keráwáqá nommá pétikaniye. ");
INSERT INTO usa_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","wemá wení yáunapo wítima agáqtuwaniye. miráumatuwena wení wíti-naupaq wítima áíkuinimanibo táíq ínnama waráríma aati-aatimá káíq-kaiq in-írábí agatuwániye.” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Yóáanema yaímma káqon-aikaraq timá yúyánámmá mamá itó kéena mirái-waigoma aarawaabímmá Metáíyaqtaba átê-wataama tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","miráimanibo Yóáanema Érôtimma awááguraiye. yeqtí anó-kamaani-naqanibo Érôtima Erótiatikaq otaa-qtátááríq éna ábâkoni ánáaqa kéyabitena yaímma táí-aaimma tarôq uráiye. ");
INSERT INTO usa_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","miráitana Érôtima máqten-otaa-qtataariqo kéenama ókaraq uyátá-maqma anón-otaamma kuyéna Yóáanemma ánná-naupaq ákaraiye. ");
INSERT INTO usa_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","aarawaamá nommá kéberaawana Îtugaraq nommá pékaiye. ánibo Îtuma nommá pétuwena nunamummá kétena máitana Áánûqtuni márûpaq agaro uráiye. ");
INSERT INTO usa_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Áánûqtuni Aokaq-Áágómá máaraa umá Îtukaq kukáiye. ánibo Áánûqtunopake móra-aikoma ááyama maará-tiraiye: “emá ketáanimone. eqtábámá kemá timuqá ôriq umá kémaraune. ketíyakoma eqtábámá kanaa kéiye.” téna aagómá Áánûqtuni márûpake ááyama tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Îtuma wení mayaímá áaimma átáma matáima wení karitimaatimá miráuma kaumo-tíyáákámá uráiye. aarawaamá téta Îtuma Yótêbimma áanikowabiyaa téta tirááe. ");
INSERT INTO usa_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Yótêbima Érimma áanikoe. Érima Máátáátimma áanikoe. Máátáátima Aríbaemma áanikoe. Aríbaema Mérekimma áanikoe. Mérekima Yáánaimma áanikoe. ");
INSERT INTO usa_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Yáánaima Yótêbimma áanikoe. Yótêbima Matáátiatimma áanikoe. Matáátiatima Émotimma áanikoe. Émotima Néamumma áanikoe. Néamuma Étarimma áanikoe. Étarima Náágaemma áanikoe. ");
INSERT INTO usa_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Náágaema Máátimma áanikoe. Máátima Matáátiatimma áanikoe. Matáátiatima Tímíenimma áanikoe. Tímíenima Yótekimma áanikoe. Yótekima Yóramma áanikoe. ");
INSERT INTO usa_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Yórama Yóáánaanimma áanikoe. Yóáánaanima Arétamma áanikoe. Arétama Terúbabeomma áanikoe. Terúbabeoma Téyaatiomma áanikoe. Téyaatioma Nérimma áanikoe. ");
INSERT INTO usa_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Nérima Mérekimma áanikoe. Mérekima Áárimma áanikoe. Áárima Kóutaamma áanikoe. Kóutaama Éramaraamma áanikoe. ");
INSERT INTO usa_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Éramaraama Éramma áanikoe. Érama Yótuamma áanikoe. Yótuama Eriétamma áanikoe. Eriétama Yóraamma áanikoe. Yóraama Máátáátimma áanikoe. ");
INSERT INTO usa_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Máátáátima Aríbaemma áanikoe. Aríbaema Tímionimma áanikoe. Tímionima Yútaamma áanikoe. Yútaama Yótêbimma áanikoe. Yótêbima Yónamumma áanikoe. Yónamuma Irááíakimma áanikoe. ");
INSERT INTO usa_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Irááíakima Mériamma áanikoe. Mériama Ménnamma áanikoe. Ménnama Mátáatamma áanikoe. Mátáatama Nétaanimma áanikoe. Nétaanima Tébitimma áanikoe. ");
INSERT INTO usa_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Tébitima Yétimma áanikoe. Yétima Óbétimma áanikoe. Óbétima Póáatimma áanikoe. Póáatima Tárámonimma áanikoe. Tárámonima Náátonimma áanikoe. ");
INSERT INTO usa_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Náátonima Aammínataamma áanikoe. Aammínnataama Ááraminimma áanikoe. Ááraminima Ááranimma áanikoe. Ááranima Étaronimma áanikoe. Étaronima Pérêtimma áanikoe. Pérêtima Yútaamma áanikoe. ");
INSERT INTO usa_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Yútaama Yáakobomma áanikoe. Yáakoboma Ááítekimma áanikoe. Ááítekima Áabaraamma áanikoe. Áabaraama Téraamma áanikoe. Téraama Néomma áanikoe. ");
INSERT INTO usa_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Néoma Térúkimma áanikoe. Térúkima Aréumma áanikoe. Aréuma Apéregimma áanikoe. Apéregima Ébérimma áanikoe. Ébérima Tíraamma áanikoe. ");
INSERT INTO usa_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Tíraama Kénaanimma áanikoe. Kénaanima Áárápáqáarimma áanikoe. Áárápáqáarima Têmimma áanikoe. Têmima Nóaamma áanikoe. Nóaama Aráámekimma áanikoe. ");
INSERT INTO usa_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Aráámekima Metúteramma áanikoe. Metúterama Énôkimma áanikoe. Énôkima Yérarimma áanikoe. Yérarima Maaérierimma áanikoe. Maaérierima Kénaanimma áanikoe. ");
INSERT INTO usa_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kénaanima Énotimma áanikoe. Énotima Têtimma áanikoe. Têtima Áátaamma áanikoe. ánibo Áátaama Áánûqtumma áanikoe. ");
INSERT INTO usa_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Áánûqtuni Aokaq-Áágómá Îtupimma ógikaitana Îtuma Yótaa-nopike yuwéna Aokaq-Áágómá wemmá awîqmena waayúkama íma máa-kaqmaapaq kóuraiye. ");
INSERT INTO usa_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","mibáqá Îtuma kaayaqté-kaayaqte-tiyaaka-kanaama máitana Tááqtaama wemmá makáqma aónaraiye. ánibo mi-kánááráqá Îtuma aáwaqa íma naráitanaboana anaaékaqa máqte-kanaama ánatagitana Îtumma áama yaráiye. ");
INSERT INTO usa_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","ánibo Tááqtaama Îtumma timá ámikaiye: “emá Áánûqtuni áanikomo máema kanaaráq maan-óqtákóqtábá tinana waéqma yammá mamá auraao.” téna Tááqtaama mirá-timatuwaitana ");
INSERT INTO usa_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Îtuma yauwéqma Tááqtaamma timá ámikaiye: “Áánûqtuni agamatá-kánnáágómá téna ‘yakómá wenamáa matúq-matuq umá paá mái-auwaraimma íma amíniye.’” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","ánibo Tááqtaama Îtumma awíqmena móra-anuma uyátárain-anuraq uténa páátákáá Îtumma máqtemma maa-márábí-márúqá aráátimatuwena ");
INSERT INTO usa_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Îtumma timá ámikaiye: “máqtemma maamin-ákóqnáámá anó-awikaraq emmá aménúne. máqtemma maami-qtátááqá kennábóaq ánibo mora náawanabi aménááqa kanaaráq aménúne. ");
INSERT INTO usa_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","ánibo emá kekáq araayutaúmmá ayé ketíwîqa múte yaúwínaqa maaminnáma máqtemma emmá aménúne.” téna Tááqtaama tiráimanibo ");
INSERT INTO usa_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Îtuma yauwéqma Tááqtaamma timá ámikaiye: “Áánûqtuni watáama agamatán-áíkómá maará kétiye. ‘emá uyátárai-nakokaq nunamummá té wenáwîqa múte kéyauye ení Áánûqtuma wenamáa wení mayaímá mayaao.’” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","mikáké Tááqtaama Îtumma awíqmena Yérútáárebaq anó-monoq-nakoni amutaq múma ákárena tiráiye: “emá Áánûqtuni áanikoma máema kanaaráq emá maakáké yaúme méma marabí metaao. ");
INSERT INTO usa_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Áánûqtuni agamatá-kánnáágómá maará-tiraiye. ‘Áánûqtuma tínata wení kaqtó-wayukama emmá kawáá umákanoe. ");
INSERT INTO usa_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","ánibo yemá emmá yeqtí iyáápi yáqtokaiyana mórama óqtakoma aítaupimma íma atarániye.’ Áánûqtuni watáama agamatán-áípí kétiye.” téna Tááqtaama tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Îtuma yauwéqma Tááqtaamma timámena tiráiye: “aamá maaráuma wáiye. ‘uyátárai-naqa ení Áánûqtumma íma makáqma aónaao.’” téna Îtuma yauwéqma tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","ánibo Tááqtaama máqte-qtataariq umá Îtumma makáqma aónawaaena óq-taoqtaba awé uráiye. ");
INSERT INTO usa_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","anaaékaqa mirá-umatuwaitana Áánûqtuni Aokaq-Áágóní akoqnááraq Îtuma yauwéqma Kááriri-marupaq iráiye. ánibo Îtuni watáagoma máqtemma min-áúkápáq wéyáwé uráiye. ");
INSERT INTO usa_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","aarawaatí monoq-náúpáq kéyiraatena aamá timá yímitata máqte-kayukama wenáwîqa múte yaútaae. ");
INSERT INTO usa_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Îtuma Náátárêtibaq uráiye. naayóbáqá Îtuma pááqyan-iyapoma máenama mi-márúkáq máqe-uraipoana anómma aúráikaq uráiye. ánibo Tabaatiráqá Îtuma monoq-náúpáq uyábékena aati-aatimá mirá éwainiq uráiye. Îtuma itó-urena Áánûqtuni watáama yorautínéna uráiye. ");
INSERT INTO usa_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","ánibo yemá amuné-náqá Áítáíyani agamatá-kánnáámá Îtumma mayámíkaae. wemá aúba-wannaama agátarena agamatán-áíkómá maará-tiraimma aónaraiye: ");
INSERT INTO usa_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“uyátárai-nakoni Aokaq-Áágómá kekáq máiye. wemá kemmá awaaméqá umátikena áwáyoq-wayukabi ‘Metáíyaqtaba átê-wataama mó tiyo.’ tiráiye. ánnábi máa-kayukama yemmá watáama timá-yimeq paábaq ayúqyikanunayaba timátíkaraiye. yúramma karoparáina-wayuka yúramma káonaiyata náayubi ummaa-yátááqá kémayaayuma mamá ayúqyikanunayaba uyátárai-nakoma timátíkaraiye. ");
INSERT INTO usa_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","minnámo pááq íni-kanaaraq uyátárai-nakoma wení waayúkama yauwéqma mamá atóbamayikani-kanaayaba abarokáq timá-yimiyo timátíkaraiye.” téna naayóbáqá Áánûqtuni amuné-náqá Aítáíya agatáiye. ");
INSERT INTO usa_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Îtuma aúba-wannaama aráápatuwena yauwéqma kawáá-náqá ámítuwena wemá yiráátinena maraq máqe-uraiye. ánibo máqtemma monoq-náúpáq máe-kayukama Îtumma wenamáa wemmá aayoq urááe. ");
INSERT INTO usa_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","ánibo Îtuma mikáq áaimma átáma aamá timá yímikaiye. maará-tiraiye: “Áánûqtuni watáama agamatá-kánnáágómá íbêqa yorautúnama abarokáq kéiye.” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","mirá téna timátúwáitata yemá Îtuni áwîqa múte yauyéta Îtuma íráqôn-aimma tiqtábá yemá netuq-yúyánámmá ítéta iyánáaq urááe. miráimanibo yemá tirááe: “nôraq kéiyo? maan-náqá Yótêbini áráaqa íyaq máraniyo?” téta tirááe. ");
INSERT INTO usa_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","ánibo Îtuma maará téna timá yímikaiye: “áraine. keráwáqá keqtábá maará tínoe. ‘tótaa-nako, enamáárîq téq ónaiq umá mirá uwo. emá mirán-ááímmá Kápéranabaqa tarôq ónama minnâ ketáámá ítaraunataama emá móraiq umá maakáqá ení márûkakaraq mirá-uwo.’ téq keráwáqá tínomanibo ");
INSERT INTO usa_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","kemá keráwáqá áraimma kétima-timune. waayúkama yeqtí márûkake móra amuné-nákón áama íma kéitaane. ");
INSERT INTO usa_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","kemá árainuramma keráwáqá kétima-timune. Íráíyani kanaaráqá taíbaq keqtoq-nóínímmá Ítíráaeobaq máawata mi-kánááráqá aabayámmá aúyakitana kaumo-kárítímáátígáráq móra-tiyaamma-naikama móra-wiyomma aaqá íma yuráiye. ánibo máqten-aukapaqa anómma yáayaba urááe. ");
INSERT INTO usa_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","miráimanibo mórama Ítíráaeobake-kayukayopaqa Íráiyama yíwáqnaa íyábá íuraine. ímiye. Áánûqtuma Íráíyamma Térabatibaq timákáitana Tááíranapaq-marupaq móra-inimma awaikómá pukitana ketoqá máin-inikonopaq uráimiye. ");
INSERT INTO usa_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","miráitana Áánûqtuni amuné-náqá Iráítaani kanaarákáráqá netuqyaammá kárú-wayukama Ítíráaeobaq máqe-uraamanibo min-áúkáápímmá íma móra-nakomma íráqôniq uráine. ímiye. Néímenima Tíriabake-nakoma wenamáa wení karígómá atóbamakaraine.” téna Îtuma Yéqtaaeo-inikoqtaba tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","máqte-kayukama monoq-náúpáq máe-kayukama min-áímmá ítáama yeqtábá titatabóata anómma íyaqtaba urááe. ");
INSERT INTO usa_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","páátákáá yemá Îtumma yabitimá máápaq yukááe. yeqtí mi-márúqá móra-anuraq awíqmeta min-ánúgóní ámûrake áaimma átáma awéqtátuwaneta uráámanibo ");
INSERT INTO usa_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","wení kanaamá íma pááq uráitanaboana yeqtí aúkáapike Îtuma yúqtúyuwena kóuraiye. ");
INSERT INTO usa_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Îtuma Kápéranabaq Kááriri-marupaq kukéna Tabaatiráqá aarawaamá yiráátiraiye. ");
INSERT INTO usa_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","ánibo yemá Îtun áagaama tewata tébakaq-wayukama iyánáaq urááe. minnáma Îtun áagoma akoqnááma wáitataboatae. ");
INSERT INTO usa_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","monoq-náúpáqá móra-naqa máqe-uraimma wepímmá táí-aagoma máqe-uraiye. min-nákómá anókaq ááyama tiráiye: ");
INSERT INTO usa_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Náátárêtibake-naqa Îtuo, emá nóinawaq mayánéq ketááyôpaqa iráánô? keqtáámá mamá táíq umátikanetaawaq iráánô? kemá eqtábámá kéitaune. emá Áánûqtuni aokaq-náqóne.” téna táí-aagoma wepí mái-nakoma tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","miráitana Îtuma táí-aagomma awáágéna tiráiye: “emá paátí mááo. min-nákónôpakemma yuwé kóaao.” téna tiráiye. ánibo mi-táí-áágómá min-náqá yaúma waayúka aúkáapi iyaabóma marabí yubámmarena min-náqá ayuwéna íma mamá táíq umákaraiye. ");
INSERT INTO usa_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","minnáyaba máqte-kayukama iyánáaq urááe. ánibo yeíyáá maará-tiraae: “maaminnáma nóikaan-ainabiyo? miráuma náápaakaraq akoqnáágaraq wái-nakoma táí-aagoqtaba watáama tináíkáán-áímmá kétitata táí-aagoma waayúkama iyuwéta kégoe.” téta tirááe. ");
INSERT INTO usa_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","miráitana Îtuma tarôq i-qtátááqtábámá watáagoma min-áúkápáqá máqte-marupaq wéyáwé uráiye. ");
INSERT INTO usa_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Îtuma mi-mónóq-námmá yuwéna itó-uma Tááímonini naaúpaq uyábékaiye. Tááímonimma aítáako-araaqnagoma kokoq yámma karímá ákaraiye. ánibo Îtuqtaba áwáqnaa íkáae téta ááyaraae. ");
INSERT INTO usa_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","miráipoana Îtuma min-árááqnágóní amakaq ko itó-urena mi-kárígómá awááguraiye. ánibo mi-kókóq yákoma ayúkaiye. miráitana min-árááqnágómá páátákáá mikáq itó-urena yeqtí aáwaqa yokaa umáyíkaraiye. ");
INSERT INTO usa_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","aabaúmá kuperáné kéitana Tabaaqtimá ánatagitana waayúkama yeqtí aanábómá ókon-oko-karima máyáa-kayukama Îtunopataa yiwíqmeta irááe. ánibo Îtuma máqte-kayukama mórá-mora-yuma yemmá yínêkuyena keqnáámmá mamá atóbamayikaraiye. ");
INSERT INTO usa_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","táí-aagoma máqte-kayukama iyuwéta kóuraae. ánibo mi-táí-áágómá maará téta ááyama tirááe: “emá Áánûqtumma áanikomone.” téta tirááe. mirá-tiraamanibo Îtuma Metáíya máenaboana yiwáágéna íma iyúwáitata aamá tirááe. ");
INSERT INTO usa_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","aabáyaanapimma nokáápaq yaúbatuwena mi-márúqá yuwéna móra-aukapaqa waayúkama íma máa-kaqmaapaqa nunamummá tínéna kóuraiye. ánibo aarawaamá aónatuweta wenôpaq urááe. ánibo Îtuma iyuwéna kóiyabae téta yáqtotoq uráámanibo ");
INSERT INTO usa_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Îtuma timá yímikaiye: “kemá Áánûqtuma yabíkái-maruqtaba átê-wataama kétima-timeq káqo-marupakaraq mó timá-yimenaaq kéune. Áánûqtuma maaminnáyaba timátíkaraiye.” téna Îtuma timá yímikaiye. ");
INSERT INTO usa_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","ánibo Îtuma Yúría-wayukati monoq-náúpáq watáama timá yímikaiye. ");
INSERT INTO usa_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","móra-taoqa Kénétáaretiqa nokaayúkóní kegébabaqa Îtuma itó-uma máitata taíbaq-wayukama Áánûqtuni watáama itánéta ikúma yageq-yageq urááe. ");
INSERT INTO usa_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Îtuma aónaimma kaayaqá pááqyamma únópí-káárérátá únókóní áwábaq wáitana aónaraiye. ánibo noyááqa yaí-wáyúkámá únópí-káárémá yuwéta kúqômma tete urááe. ");
INSERT INTO usa_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Îtuma móra-unopi-kaarebi uyátáraimma minnâ Tááímoni Pítaani únópí-kááré. ánibo Îtuma Tááímoniqtaba ‘únópí-káárémá pááqyamma awétáme nékakaa mó maraao’ tiráiye. ánibo Îtuma únópí-káárébí uyátáma máena aarawaamá watáama timá yímikaiye. ");
INSERT INTO usa_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","miráumatuwena Îtuma watáama timá yímituwena anaaékaqa Tááímonimma timá ámikaiye: “únópí-káárémá yabitimáe non-aúkáapi uré kúqômma yúwénana kumínaa noyááqa yaao.” téna Îtuma Tááímoniqtaba tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Tááímonima yauwéqma tiráiye: “íbêq-nokaamma ketáá máqtemma kamáa káetaa noyááqamaa únataamanibo mórama noyááqa íma yaráunataae. miráimanibo emá ténaboaq kemá kúqômma yúwáánana kumíniye.” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","yemá miráumatuweta taíbaq netuqyaa-nóyááqá aúyaqma yáqtóráawana kúqômma ummaa yamá yararáné uráiye. ");
INSERT INTO usa_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","miráitata yemá yaímma yeqtí aanábómá móra-unopi-kaarebi máe-kayukama tíwáqnaa ígáae téta yááyaraae. ánibo yemá iréta noyááqa mamá kaayaq-únópí-káárégómmá maqmá ógikaae. ánibo mi-kááyáq-únópí-káárégórátámá ummaa yamá únópí kumá yuberáyéta urááye. ");
INSERT INTO usa_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Tááimoni Pítaama miráimma aónatuwena Îtuni aítaupi araayutaúmmá aténa maará-tiraiye: “uyátárai-nako, emá kemmá tiyuwé kóaao. kemá kúmiq-naqune.” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Tááímonima aónaimma máqtemma maami-nóyááqá yáqtóráataba aónawaaena ikatîq uráiye. ánibo yaímma-wayukama wetê máqeo-kayukagaraq ikatîq urááe. ");
INSERT INTO usa_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","kaayaqá Yéberimma áanikoratama Yêmitiyaa Yóáanema yenákámá Tááímonimma ábárawaaoboata yenákágáráqá iyánáaq urááye. ánibo Îtuma Tááímonimma maará téna timá ámikaiye: “emá ikatîq íuwo. anaaékaqa emá waayúkama yáqtorainone.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","mikáké yemá únópí-káárémá yabitimá áwábaq má kémareta yemá máqte-qtataaqa kéyuweta Îtuni anaaé wakááe. ");
INSERT INTO usa_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Îtuma móra-marukaq máitana móra-naqa máqe-uraimma kárú-karigoma áúnobaq ógikai-nare. min-nákómá Îtumma aónatuwena óípake araayutaúmmá aténa nunamupí maará téna tiráiye: “uyátárai-nako, kanaaráq emmá akáinaama ketí karímá kanaaráq mamá atóbamatikanone.” téna kárú-nakoma tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Îtuma ayáámma árútukena ánêkuyena tiráiye: “kemmá tíkáiye. emá atóbagaao.” téna Îtuma tiráiye. páátákáá é mikáq kárú-karigoma ánatamakaraiye. ");
INSERT INTO usa_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","ánibo Îtuma akoqnáá-aimma timá-amena tiráiye: “móra-nakomma íma timá-amiyo. ímiye. emá uré anó-monoq-nakomma enáúma mó-araate Áánûqtukaq naí-wámmá mó agamá ákûq uwo. miráuma Mótetimo tiráiniq uwo. miráinata waayúkama mikáq aónaaro ení karímá ánatagiye.” téta tínóe téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","miráitana Îtuma máqten-awaameq-yataariq ináíkómá ókaraq wéyáwé uráiye. miráitata netuqyaa-káyúkámá Îtun áama yama kéitaawana karímá mamá atóbamayikaraiye. ");
INSERT INTO usa_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","miráimanibo anaaékaqa aati-aatimá Îtuma waayúka íma máa-kaqmaapaq uréna nunamummá mó téwae kéiye. ");
INSERT INTO usa_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","móra-taoqa Îtuma máena aarawaamá kéyiraatitata yaímma Pérati-wayukagaraq ámáan-aimma yirááti-wayukagaraq maraq máqe-uraae. yemá máqten-aukapaqa Kááriribakemma Yúríabakemma Yérútáárebakekaraq yama áíkutaae. ánibo uyátárai-nakoni akoqnáágoma karí-wáyúkámá mamá atóbaikaae téna Îtupi wáqe-uraiye. ");
INSERT INTO usa_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","ánibo yaímma-wayukama móra-naqa kúkutaaraq yaaguyaqméta irááe. min-nákóní ayááqtákoma aráákaguraiye. yemá min-náqá yaagumé naaúpaq utéta Îtun-amakaq maránéta urááe. ");
INSERT INTO usa_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","aarawaamá taíbaq aammá aúyakowata karí-náqá maméta Îtunopaq uínón-amma íma wáqe-uraiye. miráitata yemá naaúpaq utéta naanamubiké mú-kapotaraae. ánibo mi-kárí-náqá kúkutaaraq wayákareta aarawaatí aúkáapi múte yaagumá Îtuni aúbáq makááe. ");
INSERT INTO usa_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Îtuma yeqtí yirummá améta yikaí-yátááqá aónawaaena tiráiye: “ketí aanábógô, kemá ení kúmiq-yataaqa paábaq matukáune.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","yemá ámáan-aimma yirááti-wayukagaraq Pérati-wayukagaraq yeíyáá netuq-áímmá téta maará-tiraae: “maamin-náqá náawawaq wemá Áánûqtumma maamin-ákáyáámmá kétimakaiyo? móra-nakoma íma umaataráipoana kanaaráq íma kúmiq-yataaqa matuwániye. wé minnâ Áánûqtu wenamáa wení mayáímíye.” téta tirááe. ");
INSERT INTO usa_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Îtuma mi-káyúkátí yúyánápímmá aónatuwenaboana wemá yauwéqma timá yímikaiye: “keráwáqá nôraq itaráq tíyaqnobaqa táí-tuyanamma móite-maite kéoo? ");
INSERT INTO usa_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","nóin-ainaq tenúnô? ‘ení kúmiq-yataaqa mamá paá umátukaune’ ténú kemá téq ‘emá itó-uma kóaao’ tenúnô? ");
INSERT INTO usa_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","miráinaq keráwáqá itaígáae téq kétune. maa-márábímmá Waayúkagoni Áráaqa náápaamma matokáipoana wemá kanaaráq kúmiq-yataaqa mamá paá íniye.” téna Îtuma wenamáárîq wetábá tiráiye. miráitana min-ayááqtámô aráákagi-nakoqtaba Îtuma maará téna tiráiye: “kemá emmá kétimamune. emá itó é ení kúkutaa-yagaraq mamé ení naaúpaq kóaao.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","miráitana min-ayááqtámmô aráákagi-nakoma aarawaatí yúrakaq páátákáá itó-uraiye. ánibo kúkutaa-yama waguréna máqeimma yawátámena wení naaúpaq kégoena Áánûqtuni áwîqa múte yaútaiye. ");
INSERT INTO usa_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","ánibo máqte-kayukama iyánáaq urááe. yemá Áánûqtuni áwîqa múte kéyauyeta yeqtí íyakoma iyánáaq kéitata maará-tiraae: “íbêqa ketáámá óq-yataaqa kateko-yátááqá aónáunataae.” téta tirááe. ");
INSERT INTO usa_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","anaaékaqa Îtuma kéwana aónaimma móra-naqa táákiti-moneqa máyái-nakoma táákiti-moneq mayái-opitipaq máitana aónaraiye. min-nákóní áwîqa Aríbae. ánibo Îtuma min-náqá timá ámikaiye: “emá ketinaaé ya waraao.” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","ánibo Aríbaema máqte-qtataaqa mipí kéyuwena Îtun anaaé wakáiye. ");
INSERT INTO usa_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Aríbaema Îtumma anón-aawaqa wení-naaupaqa agayákáitata yaímma táákiti-moneqa máyáa-kayukagaraq yaímma káqo-kayukagaraq Aríbaeyaa Îtute máeta aáwaqa narááe. ");
INSERT INTO usa_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","ánibo Pérati-wayukagaraq ámáan-aimma yirááti-wayukagaraq Îtuni iyápó-anna-wayukayaba netuq-áímmá téta maará-tiraae: “nôraq itaráq keráwáqá táákiti-noneqa máyáa-kayukagaraq kúmiq-wayukagaraqa aáwaqa kénaao?” téta yemá tirááe. ");
INSERT INTO usa_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","ánibo Îtuma yauwéqma timá yímikaiye: “waayúkama karímá íma matáa-kayukama tótaa-nakonopaqa íma kéoe. ímiye. paá karí-wáyúkámá tótaa-nakonopaqa kéoe. ");
INSERT INTO usa_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","kemá arupú-wayukama yirummá waeráígáae téq íma kukáune. ímiye. kemá kúmiq-wayukama yemá yirummá waeraígáae téq kukáune.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","móra-taoqa yaímma-wayukama yemá Îtumma maará téta timá ámikaae: “yemá Yóáaneni iyápó-annama aáwaqa awetá-ureta taíbaq-kanaama nunamummá tirááe. ánibo yemá Pérati-wayukati iyápó-annagaraqa móraiq kéoe. miráimanibo ení iyápó-annama paá nommá néta aáwaqa néta kéoe.” téta tirááe. ");
INSERT INTO usa_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Îtuma yauwéqma tiráiye: “mórama keráwáqtí aanábó-nákómá keráwáqtê maéna aaramá mayánéna kéinaq aáwaqa keráwáqá awetá-ino? ímiye. ");
INSERT INTO usa_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","miráinata anaaékaqa min-ínímô mayáné i-náqá mamá paábaq yuwáiyana ókaraqa wení aanábó-wáyúkátêma íma mániye. mi-kánááráqá kanaaráq keráwáqá aáwaqa awetá-inoe.” téna Îtuma tiráimma waéqma itaí-áípí téna wenamáárîq wetábá ‘aaramá mayáné iníkáá-náqúne’ téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Îtuma mórama waéqma itaí-áíkáráq maará téna timá yímikaiye: “móra-nakoma wení naayómmá aqtábáá-kuberai-unamma yakákitanama aúgen-aqtorake yakáqma naayón-áqtábáá-únákáqá íma káraataiye. ímiye. íma aokaríq kéiye. mirá énama aúgemma kúberai-unamma mamá táíq umáginana aúgen-unakoma paá wáinana naayón-únákómá paábaq áikiniye. ");
INSERT INTO usa_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","móraiq umá móra-nakoma mémegoni naayón-áúwárátíbí íma aúgema wááénima yaqmá káitiye. naayón-áúwárátíbí áítinanama aúgemma wááéni-nokoma naayón-áúwárátímá kabááqtuwena marabí atíginiye. miráinana méme áúwaratigogaraqa táíq umáginiye. ");
INSERT INTO usa_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","ímiye. íma aokaríq íniye. mémegoni aúgen-auwaratibi aúge-waaeni-nomma áítino. ");
INSERT INTO usa_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","ánibo móra-nakoma naayó-kááéní-nómmá nátuwenama aúge-waaeni-noqtabama íma kákaiye. wemá maará téna kétiye. ‘naayó-kááéní-nómmá minnâ íráqône kétiye.’” téna Îtuma waéqma itaí-áípí wení aúge-kataayaba tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","móra-Tabaatiraqa wíti-yokoni aúkáapi Îtuma wení iyápó-annate uréire uráiye. ánibo wení iyápó-annama yaímma wítigoni arammá nánéta matéta wítima iyáákaq makéta kategátúbatuweta narááe. ");
INSERT INTO usa_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","minnáyaba yaímma Pérati-wayukama tirááe: “Tabaatiráqá aammá áúmakaae. keráwáqá minnâ nôraq itaráq mirá kéoo?” téta tirááe. ");
INSERT INTO usa_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Îtuma yauwéqma timá-yimena tiráiye: “Tébitima naayóbáqá tiráin-aimma íyaq yoráútaao? Tébitigaraq wení waayúkate yáamo yarái-kanaaraqtaba kétune. ");
INSERT INTO usa_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Tébitima Áánûqtuni aokaq-náúpáq uténa Áánûqtuni aúbáq yammá waíma matáine. mi-támmá paá-wayukama naíyábáq aammá áúkaapoata anó-monoq-wayukama kanaaráq nánóe. miráimanibo Tébitima mi-támmá mamá kénena wení waayúkama yímítata naráane. keráwáqá min-áímmá íyaq yóráútaanabiyo?” téna Îtuma kétenama ókaraq ");
INSERT INTO usa_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","timá yímikaiye: “Waayúkagoni Áráaqa Tabaatigóní uyátárai-naqiye.” téna Îtuma wenamáárîq wetábá tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","káqo-Tabaatiraq Îtuma monoq-náúpáq uténa aarawaamá watáama timá yímikaiye. ánibo móra-naqa máqe-uraimma ayáánurapaq-ayaakoma aayákagena táíq umáguraiye. ");
INSERT INTO usa_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","ámáan-aimma yirááti-wayukagaraq Pérati-wayukagaraq Îtumma aatómaq urááe. yemá Îtuqtaba téta “Tabaatiráqá karí-wáyúkámá mamá atóbaniyopoataa aónanunatae.” téta aatómaq urááe. mirá kéeta Îtumma aabi mayakánón-aqtaba abáá urááe. ");
INSERT INTO usa_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","miráitana Îtuma wenamáárîq mi-káyúkátí yúyánánóbáqá ítátuwenaboana téna ayáámmo aayákagi-nakoqtaba aúkáapi “yúbáq unitóaao” titana min-nákómá itó-uraiye. ");
INSERT INTO usa_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","10","ánibo Îtuma máqte-kayukati yúrapi karáqme kéyautena min-náqá timá ámikaiye: “ayááma arupú uwo.” téna tiráiye. ánibo min-nákómá ayáámma árútuwaimma ayáákoma arupú umáguraiye. miráitana Îtuma ítama yímónaraiye: “kemá keráwáqá ítama aónanaa kéune. Tabaatiráqá ketáámá íráqôn-aainaq tarôq ónúnataabi táí-aainaq tarôq ónúnataabiyo? waayúkama yíwáqnaa onatatáá paá máno-kayukama ketáá mamá táwîq umáyikanunataabiyo?” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","miráimanibo yemá anómma íyaqtaba urááe. mirá kéeta yeíyáá maará-tiraae: “ketáámá Îtuqtaba nôraqtaawaq umákanunataabiyo?” téta tirááe. ");
INSERT INTO usa_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","mi-kánááráqá Îtuma nunamummá tínéna anubaq utáiye. mi-nókáámmá Îtuma Áánûqtukaq nunamummá tíq-tiq kéitana aaqá irákáiye. ");
INSERT INTO usa_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","aabaúmá utáitana aabáyaanapimma Îtuma wení iyápó-annama yááyaitata yewana tiyááka umá kaayaq-wáyúkámá awaaméqá umáyíkátuwena yíwîqa awaaméqá umátike tiwiráune tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","móra-nakoni áwîqa Tááímoniboana Pítaae téna áwîqa yamá ámikaiye. ánibo Áánaruma Tááímonimma ábâkoe. ánibo Yêmitiyaa Yóáane. ánibo Píripiyaa Paatááromiyue. ");
INSERT INTO usa_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","ánibo Máátiyuyaa Tómáátie. ánibo Yêmitima Áápiatimma áanikoe. ánibo Tááímonin áwîqa karuwaaq-náré. ");
INSERT INTO usa_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","ánibo Yúqtaatima Yêmitimma áanikoe. ánibo Yúqtaatima Itikááriotima anaaékaq Îtumma namuroíq umákáa-kayukati iyáápi kutarurîq uráine. ");
INSERT INTO usa_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","18","mi-káyúkámá iréta watáama kéitaawana Îtuma karímá mamá atóbamayikaraiye. aarawaabí waátáma táí-aagoma mái-kayukama Îtuma mamá íráqôniq umáyíkaraiye. ánibo Îtuma yeráwáqtê kukéna wení taíbaq-iyapo-anna-wayukate móra-arubaq kunitó-uma máqe-uraae. netuqyaamá aarawaamá Yúríabakema Yérútáárebakema únón áwábaqa waaqókáq Tááyabakema Tááíranapaqa taíbaq-wayukagaraq mikáq máqe-uraae. ");
INSERT INTO usa_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","ánibo taíbaq-wayukama Îtuma iyáánapo ánekuiyana Îtuni akoqnáágoma mi-káyúkámá mamá íráqôniq umáyikaniye. ");
INSERT INTO usa_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Îtuma wení iyápó-annama kéyimonena tiráiye: “keráwáqá áwáyoqa máiyayuma timuqá máráaro. keráwáqá matúq-matuq umá mái-auwaraimma keráwáqtí minnáe. ");
INSERT INTO usa_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","keráwáqá íbêqa táayaba kéiyayuma annaékaqa ógiranoe. keráwáqá íbêqa ibiqá kéyaraayuma keqnáámmá wíráa ínóe. ");
INSERT INTO usa_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","ítáaro. Waayúkagoni Áráakoqtaba waayúkama keráwáqá íyamma umátiketa tiwétátuweta aamá timá pááqyaniq umátikanoe. yemá mirámô kéiyaqa keráwáqá timuqá maraínoe. ");
INSERT INTO usa_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","timuqá kémareraq iráá yamá yaúmeta-meta umá timuqá máráaro. keráwáqtí anó-meyamma Áánûqtuma wemô máipaq maqtokáiye. mi-káyúkámá keráwáqá mamá táíq kéumatikaamma naayóbáqá yeqtí yítaubikoma miráuma móraiq umá Áánûqtuni watáama yirááti-wayukama mamá táíq umáyíkaraane. ");
INSERT INTO usa_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","keráwáqá náayuwabi taíbaq ótamma kémaraawanama keráwáqtí túwaraikoma íbêqa oyaaq kéimanibo anaaékaqa anómma táí-yataakoma keráwákáq yíniye. ");
INSERT INTO usa_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","keráwáqá náayuwabi tímûqa yaiyúmá annaékaqa táayaba ínóe. íbêqa náayuwabi wíráa kéiyayuma annaékaqa ibiqá yaránóe. ");
INSERT INTO usa_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","máqte-kayukama keráwáqtábá íráqôn-aimma kétiyama atéráaro. naayóbáqá yeqtí yítaubikoma miráuma kaaqaari-ámúné-wáyúkámá mimórá-yátááríq umáyíkaraane. ");
INSERT INTO usa_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","óq-aimma Îtuma wení iyápó-annama timá yímikaiye: “kemá keráwáqá kétima-timune. móra náayubi ketáama itéqa keráwáqtí namuro-wáyúkámá tirummá yímero. náayubi keráwáqá íyamma umátikaiya-kayukama mamá íráqôniq umáyíkáaro. ");
INSERT INTO usa_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","náayubi keráwáqá uwaatagáárîq umátikaneta íya-kayukama keráwáqá yemmá mamá íráqôniq umáyíkáaro. ánibo keráwáqá akáyáámmá timá tiwáágíya-kayukama nunamummá timáyíkáaro. ");
INSERT INTO usa_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","móra-nakoma táápááraqo yumá tíkaminaqa kanaaráq mórabaq-taapaama yimíyata tíkamoro. ánibo móra-nakoma keráwáqtí kúberai-unamma mamayaínaqa ókaraq keráwáqtí wáqtôma áméro. ");
INSERT INTO usa_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","máqtemma nói-qtababi ítama káonaiyaqa itaíya-qtataaqa paá yímero. ánibo móra-nakoma keráwáqtí nói-qtataarabi maiyaíyaqa kanaaráq ‘yauwéqma timiyo’ téraq ítimakaaro. ");
INSERT INTO usa_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","keráwáqá miráiyaniq umá káqo-yuma mirá-umayikaaro. keráwáqá íráqôniq ónáae teníq umátikaiyaqa yemá íyaniq umá íráqôniq umáyíkáaro. ");
INSERT INTO usa_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","tirummá yímê-kayukama yenamáa keráwáqá yirummá timíyaqa Áánûqtuni íráqô-meyamma nóiqtabaq mayánéraq kéoo? paá kúmiq-wayukagaraq yirummá yímê-kayukama yemmá yirummá kéyime. ");
INSERT INTO usa_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","móraiq umá waayúkama keráwáqá íráqôniq umátikaiyayuma keráwáqá yenamáa íráqôniq umáyikeqa Áánûqtuni anónnáma meyámmá tíkái-qtataaqa nói-qtataaqtaba abáá kéoo? kúmiq-wayukagaraq mirá kéoe. ");
INSERT INTO usa_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","ánibo keráwáqá móra-yataaqa waayúkaraq inaatimá matêqa anaaékaqa yauwéqma yiménúnatae téqa Áánûqtuni anónnáma meyámmá tikái-qtataaqa nóiqtaba abáá kéoo? kúmiq-wayukagaraq kúmiq-wayukaraq inaatimá kémayeta anaaékaqa yauwéqma mimórá-yátááqá paá kéyime. ");
INSERT INTO usa_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","ímiye. keráwáqá keráwáqtí namuro-wáyúkámá tirummá yímeraq mamá íráqôniq umáyíkáaro. keráwáqá waayúkama móra-yataaqtaba inaatíya-qtataaqa paá yímikera anaaékaqa yauwéqma mayaíyábá íabaa oro. keráwáqá miráiyanama anaaékaqa keráwáqtí anó-meyamma waínaq Áánûqtuma mú mikákáá anómma uyátárai-nakoni áanimaaqa mánoe. táí-wayukagaraq Áánûqtukaq ‘tíkáiye’ íte-kayukagaraqa Áánûqtuma paru-yátáákáráq kéyabiqyikaiye. ");
INSERT INTO usa_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","miráipoana keráwáqá waayúkayabama paru-yátááqá yímero. keqtibomá Áánûqtuma waayúkama paru-yátááqá yíminiq umá móraiq umá keráwáqá yemmá keráwáqtí paru-yátááqá yímero. ");
INSERT INTO usa_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","keráwáqtí yainaí-yátááqnápómá káqo-kayukama íma mamá kéyainaiyana Áánûqtuma keráwáqá íma mamá yainaíno. káqó-nakoqtabama waabáqtí yúrakaqa ‘wemá íma árútáyiniq kéiye’ ítero. min-áímmá tíyamma keráwáqá wemmá mamá yawááq kéumakaae. káqó-yuma íma yawááq kéumayikaiyanama Áánûqtuma keráwáqá íma mamá yawááq umátikaniye. keráwáqá waayúkati kúmiq-yataaqa mamá paábaq yuwé tiwikátuwaiyanama Áánûqtuma keráwáqtí kúmiq-yataaqa mamá paábaq yuwéna awikátuwaniye. ");
INSERT INTO usa_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","káqo-kayukama yimíyanama paá Áánûqtuma keráwáqá timíniye. keráwáqá ógiqma-awaataq mayánoe. kópiqa unáápí aguyumá káíqtowana ógiqmena kugúbainikaa umá móraiq umá yauwéqma ókaraq matéq kanaaráq umá mayánoe. mimórá-áwáátáq káqo-kayukama yímêmma Áánûqtuma min-áwáátáq keráwáqá timíniye.” ");
INSERT INTO usa_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Îtuma káqomma mórama waéqma itaí-áíkáráq timá-yimena tiráiye: “mórama aammá íma aónarai-nakoma káqomma aammá íma aónarai-naqa aammá íma kanaaráq aráátiniye. móraiq umá mórama aúgaroq-nakoma káqomma aúgaroq-naqa íma kanaaráq awirániye. yenákámá yúgaropoata máka-nakama áítanobaq metáyóye. ");
INSERT INTO usa_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","ánibo mórama itaí-yátááqá máyái-nakoma wení itaí-yátááqá arááti-nakomma íma kéuyataiye. máqtemma mayaí-wáyúkámá itaí-yátááqá ítama ánatetama yeqtí yirááti-wayukaraa aúránoe. ");
INSERT INTO usa_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","keráwáqá nôraq itaráq keqtíbâkoni pááqyamma otaa-qtátáátáqbámá aúrapi araatákaa umá túyánámmá kéitaamanibo keráwáqá anómma otaa-qtátááqtábámá aúrapi mútûq-yaraa umá túyánámmá íma kéitaao? ");
INSERT INTO usa_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","nôraq itaráq keráwáqtí tíbâkoqtabama maará kéteo. ‘ketíbâko, enaúrapike araatá-qtataaqa mamá paábaq yuwaao’ kéteo keráwáqtí túrapimma mútûq-yama waímma íyaq káonaao? ureqáráaq-wayukaao, áqnáabaqa keráwáqtí túrapike mútûq-yama paábaq matuwéraq mikáké keráwáqá kanaaráq aónama arútáreq keráwáqtí tíbâkoni aúrapike araatámma kanaaráq paábaq matuwánóe. ");
INSERT INTO usa_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Îtuma káqomma waéqma itaí-áímmá tiráiye: “íráqô-tagoma táí-aramma íma kéiyaiye. móraiq umá táí-yagoma íráqôn-aramma íma kéiyaiye. ");
INSERT INTO usa_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","waayúkama yaagóní aranókáá aónatuweta mikáq íráqô-tawabi táí-yawabiyo téta káonaae. ánibo píki-yagoni arammá waayúkama áwáabiq-annarakema íma arammá kégutoe. ánibo áwáábiq-annarakema wááéni-aramma íma kégutoe. ");
INSERT INTO usa_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","miráuma íráqô-nakoma taíbaq íráqôn-aimma áyáqnobake mamá pááq kéimanibo táí-nakomma táí-aimma áyáqnobake mamá pááq kéiye. mirán-áúyánámmá áyáqnobaqa ógikaitana óyaupike mamá abarokáq téwae kéiye.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","móragaraq waéqma itaí-áímmá Îtuma tiráiye: “nôraq itaráq keqtábámá ‘uyátárai-nako, uyátárai-nako,’ kéteqanibo ketáama íma kéwaraao? ");
INSERT INTO usa_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","móra-nakoma ketôpaq yéna ketáama iténa waráina-waigomma kemá wenáaimma abarokáq tiráátenune. ");
INSERT INTO usa_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","minnâ min-nákómá miráuma móra-nakoma naammá ínéna iníkáá uráiye. min-nákómá maiqá uqmá mémánóbáq yuwéna maranóbáq anón-oqtakoni ámûraaq umá akoqnáá umákaiye. anón-oqtakoni ámûraaq akoqnáá-namma tarôq uráiye. anaaékaqa anómma aaqá yuréna anón-nomma aúténa min-námmá awétáraimanibo akoqnáá umákaitanaboana íma yawítíraiye. ");
INSERT INTO usa_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","ááqibo móra-nakoma ketáama iténa íma wáráimma miráráá umá móra-nakoma paá-mararaq yón-agamoqnakaa-namma umá itó-umakaraiye. anaaékaqa nommá auténa min-námmá páátákáá yawítítuwaitana ‘pau’ titana yubákuraiye.” téna Îtuma waéqma itaí-áímmá tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Îtuma min-áímmá aarawaamá timá yímíqma ánatatuwena Kápéranabaq koyaráiye. ");
INSERT INTO usa_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Arómani ááiq-i-wayukati kawáá-náqá máqe-uraimma wemá mórama mayaí-náqá ákaraiye. mi-káwáá-nákómá wení mayaí-nákóqtábá ôriq umá ákáinapoana mi-máyáí-nákómá anó-karima mayéna puíné uráiye. ");
INSERT INTO usa_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","ánibo ááiq-i-kawaa-nakoma Îtuqtaba máiye-aimma ítátuwena yaímma Íbaru-wayukati anó-kayukama timáyikena Îtuma mó timá-amiyana ketí mayaí-náqá ya mamá atóbáíno tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","miráitataboata mi-káyúkámá Îtunopaq iréta anegáq-naagaq kéeta akoqnáá umá ítama aónaraae: “wemá íráqô-napoa áwáqnaa ínónama íráqômiye ");
INSERT INTO usa_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","wemá keqtáá Íbaru-wayukama kaayonétaa umátíkái-nare. wemá wenamáárîq monoq-námmá umátíkaraitaae.” téta tewana ");
INSERT INTO usa_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Îtuma mi-káyúkátê yagaroqtamá uráiye. naakóní waaqókáq itana ááiq-i-wayukati kawáá-nákómá yaímma aanábó-wáyúkámá watáama timá yímitata Îtunopaq uréta maará-tiraae: “uyátáraana-nako, emá kammáa íaao. kemá umaatamá íma kanaaráq uráunaboa ketí naaúma íma yínóne. ");
INSERT INTO usa_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","ánibo kegáráqá túyánámmá itáunama íma íráqô-naqa máunaboaq enôpaqa íma ónúne. miráinaa emá paá aamá tinana ketí mayaí-náqá keqnáámmá atóbáíno. ");
INSERT INTO usa_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","kegáráqá anómma náápaamma matokái-nakoni aménáápáq máunana mayaímá mayaao titaq kémayaune. ánibo kegáráqá ááiq-i-wayukama yíkáraunata ketiménáápáq mááe. ánibo kemá móra-nakomma ‘emá kóaao’ túnanama kanaaráq kéwiye. ánibo móra-waigoqtaba téq ‘emá maabáq iyo’ túnanama kanaaráq wemá kéiye. ketí mayaí-nákóqtábá ‘emá maa-máyáímá mayaao’ túnanama kanaaráq mi-máyáímá kémayaiye.” téna titata má-tima-amikaae. ");
INSERT INTO usa_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Îtuma min-áíqtábá iyánáaq umátuwena taíbaq-wayukama anaaé waqméta ye-káyúkámá waeréna maará téna timá yímikaiye: “kemá keráwáqá kétima-timune. Ítíráaeo-wayukati aúkáapimma mórama maamirá-náqá itáíq-itaiq umá arummá tímî-naqa íma aónaraune.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","ánibo ááiq-i-kawaa-nakoma timáyíkáitata ye-káyúkámá yauwéqma naaópaq uréta aónaamma mi-máyáí-náqá atóbaguraitata aónaraae. ");
INSERT INTO usa_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","pááqya-kanaama anaaékaqa Îtuma móra-marupaq uráimma mi-márúkón áwîqa Nénibare iyápó-annagaraq taíbaq-wayukagaraq Îtute urááe. ");
INSERT INTO usa_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","mibáqá mi-márúkóní oqtaráq waaqókáq owata mórama pukái-naqa maméta irááe. mi pukái-nakoni anóama kímora-iyapoma wenamáa ákáraine. ánibo awaikógáráqá naayóbáq pukuráine. taíbaq mi-márúpáké aaramá waamá min-íníkótê irááe. ");
INSERT INTO usa_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","uyátárai-nakoma min-ínímmá aónaimma arummá ôriq umágitana min-íníkóqtábá ‘ibiqá íma yaraao’ téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","ánibo Îtuma waaqókáq uréna pukái-nakoni kúkutaa-yataq ayáámma ánékuitata waayúkama pukái-naqo mamé ye-káyúkámá itó-uma máqe-uraae. Îtuma maará-tiraiye: “maabugô, kemá emmá kétimamune. emá itóaao.” téna titana ");
INSERT INTO usa_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","mi puki-nákómá itó-uma máena aamá áaimma átáma tiráiye. miráitana Îtuma mi-mábúmá anóamma awíqma ámikaiye. ");
INSERT INTO usa_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","miráitata máqtemma aarawaamá ikatîq éta Áánûqtuni áwîqa múte yauyéta maará-tiraae: “ketááí aúkáapimma mórama Áánûqtuni anómma amuné-náqá pááq kéiye.” téta ókaraq maará-tiraae: “Áánûqtuma wení waayúkama yíwáqnaa ínéna iráiye.” téta tirááe. ");
INSERT INTO usa_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","maamin-áíkómá Îqtuqtaba máqtemma Yúría-aukapaq uréire kéena máqten-aukapaq wéyáwé uráiye. ");
INSERT INTO usa_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","máqtemma maami-qtátááqtábámá Yóáaneni iyápó-annama Yóáanemma mó timá ámikaae. ");
INSERT INTO usa_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","ánibo Yóáanema wení kaayaq-íyápó-ánnámá yááyarena maará mó-tekao téna timáyíkáitata uyátárai-nakonopaq uréta maará mó-tiraaye: “naayóbáqá téta móra-naqa yíniye tiráa-naraq iráá káqo-nakoqtaba awé ónúnataabiyo?” téta tirááe. ");
INSERT INTO usa_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","mi-kááyáq-nákórátámá Îtunopaq iréta maará-tiraaye: “Yóáanema nommá peraí-nákómá kekárátámá enôpaq timátíkáitaka yúyana maará-tiye. eqtabá anaaékaq yíniye tiráa-naraq iráá káqo-nakoqtaba awé ónúnataabiyo?” téna tiyé téta Îtumma timá ámikaaye. ");
INSERT INTO usa_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","mi-kánááráqá taíbaq ókon-okomma karímá matáa-kayukama Îtu mamá atóbamayikaraiye. mi-káyúkábíkémá netuqá waátáma táí-aagomma watukáiye. taíbaq yúgaroq-wayukama mamá yúramma karáq yíkaraiye. ");
INSERT INTO usa_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Îtuma min-nákátí yáaraq maará téna yauwéqma tiráiye: “kenákámá máqte-qtataaqa káoneka itááya-qtataaqtabama Yóáanemma mó-tima-amekao. yúgaroq-wayukama yúramma káonaawata yítauqa akúgurai-kayukama aammá uréire kéoe. kárú-wayukama mamá íráqôniq kéowata yaáqa atíragurai-kayukama aamá kéitaae. pukáa-kayukama itó kéowata áwáyoq-wayukama Áánûqtuni átê-wataama kéitaae. ");
INSERT INTO usa_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","itáíq-itaiq umá yirummá tímê-kayukama keqtábá íma ité-maqne kéetaboata yimuqá kémaraae. ");
INSERT INTO usa_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","kaayaq-nákámá Yóáanen áamo mamé yéya-nakama kóyana aarawaamá Yóáaneqtabama Îtuma maará-tiraiye: “naayóbáqá waayúkama íma máa-kaqmaapaq uráamma keráwáqá nóinawaq aónaneraq uráanabiyo? aqá mórama ómmá uwááma yoqmá awétátuwainaq aónaneraq uráanabiyo? ");
INSERT INTO usa_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","keráwáqá nói-qtataaraq aónaneraq uráanabiyo? aqá móra-nakoma íráqôn-unakaqtowaq mamaré máitaraq ko aónaraao? yemá íráqôn-unakaqtoma umátoreta yineqá íráqô-qtataaqa mamáráa-kayukama yemá anó-kayukati naaúpaq kémae. ");
INSERT INTO usa_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","miráimanibo keráwáqá nóinawaq aónaneraq uráanabiyo? keráwáqá móra amuné-náráq aónaneraq uráanabiyo? owé. kemá keráwáqá kétima-timune. Yóáanema wemá káqon-amune-wayukama yemmá uyátáraiye. ");
INSERT INTO usa_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","min-náqá Yóáaneqtaba Áánûqtuni agamatán-áúbá-wánnáábímá maará-tiraine: “kemá ketáama mamé kumíní-naqa timákáanana áqnáabaq keráwáqtí túbáq wíniye. Áánûqtuma agamátán-áúbábí téna wemá ení aammá awírakaniye.” téna kétiye. ");
INSERT INTO usa_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","kemá Îtuma keráwáqá kétima-timune: “Yóáanema máqtemma maa-márábí máa-kayukama uyátáraimanibo Áánûqtu yabíkái-aukapaqa márû mikákáá kumáta-maqma mái-nakoma Yóáanemma uyátáraiye.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Îtuma mirá-tin-aimma máqtemma aarawaagáráq táákiti-moneqa mayaí-wáyúkágáráq ítaraae. yemá Áánûqtuni áaikoma arupú uráitata yemmá Yóáane nommá péqyikaraimanibo ");
INSERT INTO usa_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Pérati-wayukagaraq ámáan-aimma yirááti-wayukagaraq Yóáanen ayáápikema nommá íma pékaae. miráitana yemmá Áánûqtuma íráqôn-amma yiráátimma yinaaéma umámikaae. ");
INSERT INTO usa_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","ánibo Îtuma maará-tiráiye: “maami-kánááráqá nói-kayukawaq mááe téraq awaaméqá ónúnô? yemá nóikaa-kayukawaq mááo? máqte-qtataaqa yemá íma yimuqá kémaraae. ");
INSERT INTO usa_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","yemá miráuma iyápóma márûpi áíkuteta káqo-noiyapoyaba maará-tiraae. ‘ketáámá keráwáqtábá káoyamma kéyunataa keráwáqá imá íma kéyaae. ketáámá ibiq-ímá kétunataa keráwáqá ibiqá íma kéyaraae.’ ");
INSERT INTO usa_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","ánibo Yóáanema nommá peraí-náqá iráimma wemá aáwaqa awetá éna wááéni-nomma íma néna uráiye. miráuraitaq keráwáqá ‘aíboq-nare’ téq tirááe. ");
INSERT INTO usa_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","íbêqa Waayúkagoni Áráaqa kukéna aáwaqa néna nommá néna iqtábámá keráwáqá ‘aónaaro. maan-nákómá aáwaqa ôriq umá néna wááéni-nomma ôriq umá kénaiye. wemá táákiti-moneqa máyáa-kayukagaraq kúmiq-wayukagaraq yetí aanábóé.’ keráwáqá téq tirááe. ");
INSERT INTO usa_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","miráimanibo waayúkama maará téta kéte. yemá itaí-yátáákóní áráabitiaq mááo? ímiye. itaí-yátáákóní áráabitimo máetama móra-nakoni áaikoma árain-aaimma wáinatama yemá ‘árain-aine’ téta itánoe.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","móra Pérati-nakoma ááyama awíqmena wetê aáwaqa má-naraaye. ánibo Îtuma mi-Pérátí-nákóní naaúpaq uréna aáwaqa nánéna maraq máqe-uraiye. ");
INSERT INTO usa_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","mórama kúmiq-inimma mi-márúkáqá máena ítáimma Îtuma mi-Pérátí-nákóní naaúpaq máena aáwaqa kénaiye-aimma ítaraiye. miráitana mi-kúmíq-íníkómá mórama íráqôn-oqta-motorebima átê-akuq-matawemma wáitana mamé iráiye. ");
INSERT INTO usa_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","ánibo min-íníkómá Îtuni anaaépaq aítaupi ya itó-uma máena ibiqá yakáiye. ánibo kumari-íníkóní aqnugómá Îtuni aítaukaqtaa yaráqme kúmitana min-íníkómá wen-aqnótáurake aqnumá Îtun aítaukaqo kukáimma ayúnakatuwena wemá Îtuni aítaukoma kámoqnena ákûq-matawemma pérakaraiye. ");
INSERT INTO usa_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","mi-Pérátí-nákómá wení naaúpaqa Îtumma awíqme i-nákómá mirái-qtataaqa aónatuwena maará téna aúyánámmá ítaraiye: “maamin-náqá áraimma Áánûqtuni amuné-náqô máenama kanaaráq maamin-íníkómá Îtumma ánékuiqtabama kéitena wenáaiqtabama itáníyô? maamin-ínímmá wé kumari-ínímíye.” téna Pérati-nakoma aúyánámmá ítaraiye. ");
INSERT INTO usa_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","miráimanibo Îtuma min-nákóní aúyánámmá iténa yauwéqma maará-tima-amikaiye: “Tááímonio, kemá móra-aimma yokáunaboaq timá ámenaae.” titana ánibo Tááímoni tiráiye: “yirááti-nako, enaúyánámmá tiyo.” tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","“itaao, kaayaq-nákórátámá mórama móneqa makái-nakonopake inaatimá móneqa matááyamma móra-nakoma taíbaq-moneqa (500) máyaitana káqo-nakoma móra-tiyaapaq-yatama (50) matáiye. ");
INSERT INTO usa_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","min-nákórátámá yenákátí aqtábááma yauwéqma íma kanaaráq ámewaniq óyana min-nákómá yenákátí aqtábááma paá awikamá-yikena iyúkaiye. ánibo yenákábíkémmá náawawaq móneqa makái-nakoqtabama wemmá uyátá-maqma akáníyô?” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Tááímonima yauwéqma maará-tiraiye: “minnámo anón-aqtabaama mamá paá i-nákówábiyaa kétune.” téna titana Îtuma timá ámikaiye: “arupú umá aúyánámmá itááne.” téna Îtuma timátuwena ");
INSERT INTO usa_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","min-íníkónôpaq kéwaerena Tááímonimma timá ámikaiye: “emá maan-ínímmá káonaano? kemá ení-naaupaq yúnaa emá ketááí áaimma waré títauqa tete í-nómmá íma tímikaanamanibo maan-íníkómá aúran-anokake títauqa tete umátikarena wení aqnótáurake ayúmma kokoq umátikaraiye. ");
INSERT INTO usa_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","emá kemmá íma tímôqnama tótó umátikaraanamanibo kemá wágáabaqo ya máqe-unarake áaima átarena maamin-íníkómá ketítaukomma tímôqnemaimma paá kétimoqnaiye. ");
INSERT INTO usa_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","emá matawémma ketiqnópímá ketáá éwaunaiq umá íma atíma pétikaraanamanibo wemá átê-kuyumma i-mátáwékáké títaukaqa kébetikaiye. ");
INSERT INTO usa_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","miráitaq kemá emmá kétimamune. maamin-íníkómá wení taíbaq-kumiq-yataakomma paá tiwikamákeqa káyuwaunanaboana keqtábá uyátá-maqma arummá kétimiye. ánibo Áánûqtuma móra-nakoni kúmiq-yataaqa arekáq umá matuwaínanama min-nákómá pááqyamma arummá kámiye.” téna Îtuma timátuwena ");
INSERT INTO usa_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","min-íníkómmá timá ámikaiye: “kemá ení kúmiq-yataaqa mamá paábaq kématuweq kétiwikatuwaune.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","waayúkama aáwaqa naí-yááréráqá Îtugaraq máqeo-kayukama yeíyáá aamá maará téta kóté-yáté urááe: “maamin-náqá náawaq máena kúmiq-yataaqa mamá paábaq kéyuwena káwikatuwaiyo?” téta tirááe. ");
INSERT INTO usa_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","ááqibo Îtuma min-íníkómmá timá ámikaiye: “emá itáiq-itaiq umá yáqtoraana-yataakoma emmá kúmiq-yataapike yauwéqma káwiraiye. kaayoné-yátáápí waao.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","anaaékaqa Îtuma anó-marupakaraq pááqya-marupakaraq uréire kéena watáama Áánûqtuma yabíkái-marukoni átê-wataama aarawaamá timá yímikaiye. ánibo yemá tiyááka umá kaayaq-íyápó-ánnámá Îtuni anaaé waqmé uréire urááe. ");
INSERT INTO usa_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","ánibo yaímma-noinimma naayóbáqá Îtuma waátáma táí-aagomma kéwaqtuwena karímá mamá paá kéumayikena urái-noinikaraq Îtuni anaaé waqmé uréire urááe. móra-inimma Máríaa Máátarini naayóbáqá min-íníkópíkéma abapaké kaayaqá waátáma táí-aagomma Îtuma matukáine. ");
INSERT INTO usa_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Tútaama kíni Érôtini naaúpaqa kawáá-nákómá wenánáakoni áwîqa Yóáanaama min-íníkókáráq Tútáánakaraq taíbaq káqo-noinikaraq Îtugaraq wení iyápó-annagaraq yeqtí ótataba áwâqnaa urááe. ");
INSERT INTO usa_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","mórá-mora-marupake taíbaq aarawaamá ya yorupágowata Îtunopaq irááe. ánibo Îtuma móra waéqma itaí-áímmá timá-yimena tiráiye: ");
INSERT INTO usa_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“móra-nakoma ánayumma yópí mó-yukaiye. mó yúwáitana yaímma-anayukoma aapi kuqturáiye. ánibo min-ánáyúmmá waayúkama yítauqa yamá kéyatamowana numagómá áíqma nátukaiye. ");
INSERT INTO usa_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","ánibo yaímma-anayumma óqta-marabi kuqturáiye. mikáké áruma utaráimanibo óqta-maraboana maragóní anommá íma wáitana ánayumma aayámmá kamáguraiye. ");
INSERT INTO usa_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","yaímma-anayumma áwáábiq-anna-karaakoni ááipi kuqturáiye. ánibo áwáábiq-anna-karaakogaraq karúma ánayumma mamá táíq umátukaiye. ");
INSERT INTO usa_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","tébakaq-anayumma íráqô-marabi ku karútena mórá-mora-waigoma taíbaq-aramma (100) itáiye.” téna Îtuma tiráiye. óq-aimma arúbama tiráiye: “keráwáqá taáqa wáinaqa maamin-áímmá ítáaro.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","yemá Îtuni iyápó-annama waéqma itaí-áíkóní áaiqtaba Îtumma ítama aónaraae. ");
INSERT INTO usa_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","ánibo Îtuma maará-tiraiye: “Áánûqtuma wenamáárîq wemá yabíkái-marukoni aúpáq-áíkón áaimma keráwáqá tiráátiraiye. miráimanibo yaímma-wayukama waéqma itaí-áímmá itánóe. miráinata yúramma aónanomanibo móra-yataaqa íma aónainoe. ánibo yemá aamá itánómanibo mi-wágóní áaimma íma itánóe. ");
INSERT INTO usa_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","maami waéqma itaí-áíkóní áaimma maará-uraiye. maamin-ánáyúmmá minnâ Áánûqtun áamiye. ");
INSERT INTO usa_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","yaímma-anayumma aapimô kuqturáimma miráuma waayúkama aamá ítáamanibo anaaékaqa Tááqtaama iréna mi-káyúkátí íyáqnobake mamá paábaq kéyuwaiye. Tááqtaama téna yemá min-áímmá itáíq-itaiq kéiyana Áánûqtuma yauwéqma yiwiráinabo téna Tááqtaama min-áímmá kématuwaiye. ");
INSERT INTO usa_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","yaímma-anayumma óqta-marabimo kuqturáimma miráuma waayúkama aamá itéta yimuqá makáane. miráuraamanibo min-áíkómá íma ánûqa yamá marabímá kukáiye. yemá pááqya-kanaabi itáíq-itaiq kéowana mórama maqmá aónai-yataakoma makáqma yimónaitatama páátákáá Áánûqtun-aagoma paábaq kégoiye. ");
INSERT INTO usa_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","mi yaímma-anayumma áwáábiq-anna-karaakoni áainobaqo kukáimma miráuma waayúkama aamá ítátuweta aammá kéowana ókon-okomma ummaa-yátááqá mónerabi maa-márábímá amuqá maraí-yátáákómá yúyánámmá mamá yawááq kéumatuwaiye. miráitana yeqtí arammá íma arútama kéiyaiye. ímiye. arammá paá aayámmá kégamagiye. ");
INSERT INTO usa_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","miráimanibo ánayumma íráqô-mararaqo kuqti-wáígómá miráuma waayúkama aamá itéta yáqtoqma akoqnáá urááe. miráo-kayukati íyakoma arupú éna íráqôniq umá akoqnáá uréta arammá íyáinikaa umá arammá kéiyaae. ");
INSERT INTO usa_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","waayúkama ómmá kúraqmareta tawegóní aménáápáqá atípáá aménáánóbákáráqá íma káuyoq-maraae. ímiye. yemá ómmá kúraqma yanaa yaareráq makáawata waayúkama mi-náúpáqô kéuyetama yemá min-ómmá aónanoe. ");
INSERT INTO usa_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","máqte-qtataaqa aúpáq wái-qtataakoma anaaékaqa abarokáq íniye. máqte-qtataaqa waayúkama aúpáq makáíya-qtataakoma anaaékaqa abarokáq ínata waayúkama aónanoe. ");
INSERT INTO usa_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","keráwáqá atéqma arutéqa keráwáqá aamá ítama arutánóe. ánibo móra-nakoma móra-yataaqa matokáinanama Áánûqtu min-nákómá ókaraq amínímanibo káqo-nakoma móra-yataaqa íma matokáinanama kanaaráq min-nákómá téna pááqya-qtataaqa matokáúnáa tínnama minnâ Áánûqtu matuwániye.” téna Îtuma waéqma itaí-áímmá tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","mi-kánááráqá Îtumma anóagaraq Îtuni ábâqawaayugaraq Îtunopaq irááe. iráamanibo taíbaq-wayukama iyáá umágowata yemá Îtunopaqa kanaaráq íma úyôwaniq urááe. ");
INSERT INTO usa_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","yaímma-wayukama Îtumma maará téta timá ámikaae: “enanógaraq enábâqawaayugaraq máápaq enawé kéeta emmá aónaneta kéoe.” téta tirááe. ");
INSERT INTO usa_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","ánibo Îtuma yauwéqma maará-tiraiye: “aaramá waamá náayubi Áánûqtun áama itéta anaaé waráiyayuma minnâ yemá ketinógaraq ketíbâqawaayue.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","móra-taoqa Îtuma wení iyápó-annate únópí-káárébí uyátarena timá yímikaiye: “nokaayúkómmá meran-ábápáq wíyataao.” téna tiráiye. mirá titata yemá únópí-káárébí kóuraae. ");
INSERT INTO usa_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","únópí-káárégómá uyaaténa kégoitana Îtuma aúwaguraiye. ánibo anón-uwaagoma nokaayúpímá ôriq umá kéyoraitana nokómá únópí-káárébímá kéogiraitata yemá únópí kumá yubékineta urááe. ");
INSERT INTO usa_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","ánibo yemá Îtumma ko awáutureta tirááe: “kawáá-nákô, kawaa-nákô, ketáá kéyubekunatae.” téta tirááe. ánibo Îtuma itó-urena uwááma yóráiwaigokaraq únón-íyámá metaikáráq yiwááguraiye. ánibo anón-uwaagogaraq únón-íyágógáráq kégaragebaitana nokómá waráa íuraiye. ");
INSERT INTO usa_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","wení íyápó-annama Îtuma timá yímikaiye: “keráwáqtí itáíq-itaiq umá yáqtorai-yataaqa náakaraq wáiyo?” titata yemá ikatîq éta iyánáaq urááe. ánibo yeíyáá maará-tiraae: “maamin-náqá náawabiyo? wemá uwáágokaraq nokókáráq yiwáágítata wenáama kéwaraaye.” téta tirááe. ");
INSERT INTO usa_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","anaaékaqa yemá Kerátínêti-marupaq irááe. Kááriri-maruqa nokaayúkómmá meran-ábápáq wáitana maan-ábápáqá mi-márúqá wáqe-uraiye. ");
INSERT INTO usa_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Îtuma únópí-káárémá yuwéna mi-márúkáq witana mórama mi-márúkáké-náqá mikáq iráiye. átáyaa-kanaama yáuraimma wáqtôma aneqá íma itokáiye. min-nákómá naaóqa íma maéwaimibo paá pukuráa-kayukati maiqnóbáqá maéwaine. ");
INSERT INTO usa_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","taíbaq-yupaama waátáma táí-aagoma wemmá yáqtoqma akoqnáá uráiye. aati-aatimá waayúkama kawáá umákáreta ánnánapo ayáákaraa aítaukaqa ánná atáá umákewaone. miráimanibo min-nákómá ánnáma paá yaráqtúwaitana mi-táí-áágómá waqmá waayúka íma máa-kaqmaapaq ayuwéwaine. miráitana min-nákómá Îtumma aónatuwena wááqa kéyena Îtuni aítaupi waaqókáq marabí aipaq aguréna anókaq ááyama maará-tiraiye: “Îtuo, mú mikákáá anómma uyátárain-Aanuqtuma áanikoma kemmá nôraq umátikane kéono? tíqa í-yátááqá ítimiyo.” mi-káátágómá mirá téna inaa-inaa tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","ánibo Îtuma min-nákómmá maará téna ítama aónaraiye: “enáwîqa náawabono?” téna Îtuma titana ánibo wé tiráiye: “ááiq i-wayukamune.” téna yauwéqma tiráiye. netuqyaamá táí-aagoma min-nákóní arunóbáq péqma máeta ");
INSERT INTO usa_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Îtukaq inaa-inaa téta ‘abeyúmmá íma wái-maiqnobaqa mibáqá Áánûqtuma keqtáá táí-meyamma timíniqtaaibo ítiyuwaikaae’ tirááe. ");
INSERT INTO usa_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","mi-márúkóní waaqókáqá pááqyan-anubaq netuqyaa-pó ánnámá aúmá naté utááe. miráitana mi-káátámá Îtukaq inaa-inaa téta yemmá iyuwáinata pó-annabi ko peránááe tewana Îtuma iyúwáitata kóuraae. ");
INSERT INTO usa_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","ánibo mi-táí-áágómá min-nákópíkémmá ayuwéta pó-anabitaa uyábékaae. péqmareta áítanobaq metaráamma anó-nokaayupi metaréta nommá nawíketa máqtemma pukááe. ");
INSERT INTO usa_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","miráitata pógoni kawáá-wáyúkámá mirái-qtataaqa aónatuweta yemá péqmareta uréta anó-maruparabi máqte-naukapaqa mó-tima-yimikaae. ");
INSERT INTO usa_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","miráitata aarawaamá nôrabi o-qtátááqá ko aónaraae. ánibo mikáké Îtunopaq uréta waátáma wepí máqe-urai-nakomma ya aónaamma wáqtôma kéiyena aúyánákómá tágaitana wemá Îtuni aítaupi waaqókáq máitata aónatuweta aarawaamá ikatîq urááe. ");
INSERT INTO usa_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","ánibo waayúkama mi-qtátááqô aónaa-kayukama náayuwabi aónayuma yemá min-nákómá atóbain-aimma tébakaq-wayukama timá yímikaae. ");
INSERT INTO usa_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","ánibo Kerátínêti-aukapaq-wayukama Îtumma maará téta timá ámikaae: “emá keqtáá tiyuwé kóaao.” téta tirááe. yemá ôriq umá ikatîq kéetaboata mirá-tiraae. miráitana Îtuma únópí-káárébí uyákébereta wení iyápó-annagaraq yauwéqma kóuraae. ");
INSERT INTO usa_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","min-náqá táí-aagoma ayúwái-nakoma Îtukaq inaa-inaa téna tiráiye: “kemá etê ónááq kéune.” téna tiráiye. miráimanibo Îtuma yauwéqma kétimakena timá ámikaiye: ");
INSERT INTO usa_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“emá ení márûpaq yauwéqma uré Áánûqtuma mi-qtátááríqo umákáiqtabama watáama mó tiyo.” téna Îtuma min-náqá timá ámikaiye. miráitana min-nákómá kóurena wení márûpaqa uréna máqte-qtataariqa Îtumo miráumakai-qtataaqtabama máqte-kayukama mó-tima-yimikaiye. ");
INSERT INTO usa_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Îtuma yauwéqma naaópaq itata aarawaamá awé umá máqe-uraapoata anómma yimuqá marákáraae. ");
INSERT INTO usa_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","42","ánibo móra-naqa pááq uráimma min-nákóní áwîqa Yááíratie. wemá móra monoq-náú-káwáá-náqíye. miráitana min-nákómá Îtuni aítaupi aipaq agéna kímora-ayaamukoma miráuma tiyááka umá títaupake kaayáq-kárítímáátímá uráin-inaaruma pukáitanaboana wemá Îtukaq inaatitana wení naaúpaq uráiye. ");
INSERT INTO usa_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Îtuma kó-mare kéwitata taíbaq-wayukama yageq-yageq urááe. ánibo móra-inimma mikáq máqe-uraimma min-íníkómmá inaautámma ákáitana tiyááka umá kaayaq-kárítímáátímá máqe-uraiye. miráitana móra-nakoma mi-kárímá íma kanaaráq atóbamakaraiye. ");
INSERT INTO usa_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","min-íníkómá Îtuni anaaépake iréna amakaq Îtuni kúberai-unakoni aqtóráq ayáámma ánékukaiye. miráitana páátákáá min-ínááú-kárígómá ánatamakaitana ókaraqa karímá íma ákáraiye. ");
INSERT INTO usa_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","ánibo Îtuma ítama aónaraiye: “náawaq tineqá ayáámma ánekukaiyo?” téna tiráiye. yaímma-wayukama téta ‘kemá ímiye’ kétimma ‘kemá ímiye’ kétimma urááe. ánibo Pítaama maará-tiraiye: “kawáá-nákô, taíbaq-wayukama itó-uma emmá ikúyakaraae.” téna Pítaama titana ");
INSERT INTO usa_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Îtuma tiráiye: “móra-waigoma tineq ayáámma ánékukaiye. miráitaq kemá túnobaq maqmá aónáúnama ketí akoqnááma yaímma tiyuwéna kóuraiye.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","min-íníkómá mi-qtátááqá káonenama aúpáq íyukaiye. miráitana wemá iyánáaq umárena Îtuni amakaq araayutaúmmá má atena mikáq máqte-kayukati yúrakaq Îtun-aneq ayáámma noiqtababi ánékuin-aaimma má kétena wení karígómá páátákáá ánataguraiye.” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","ánibo Îtuma maará-tima-amikaiye: “ketiyáámûko, emá arummá itáíq-itaiq umá yáqtorai-yataakoma ení karímá mamá ánatamakaiye. kaayoné-yátáápí waao.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","aamá kétena máitana mi-mónóq-náúké-káwáá-nákóní mayaí-náqá Yááíratikaq iréna timá ámikaiye: “enayáámûkoma áqa pukuráiye. minnáyaba yirááti-nakomma ummaamá íamiyo.” téna min-nákómá tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","ááqibo Îtuma min-áímmá ítátuwena yauwéqma timá-amena tiráiye: “emá ikatîq íuwo. emá paá itáíq-itaiq inanamá ení iyápóma atóbéna itó-iniye.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","ánibo Îtuma mi-káwáá-nákóní naaúpaq uyéna aarawaamá íma iyúwáitata min-náúpáqá íutaae. ímiye. Îtuma Pítaamma káwirena Yóáanemma káwirena Yêmitimma káwirena min-ínáárúgóní anóaboamma kéyiwirena umá kíra umá yiwîqmena Îtuma utáiye. ");
INSERT INTO usa_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","ánibo máqte-kayukama min-íyápóyábá ibiqá kéyareta máqe-uraae. miráimanibo Îtuma mi-káyúkámá timá yímikaiye: “keráwáqá ibiqá íma yáráaro. min-íyápómá íma pukáiye. wemá paá aúwaguraiye.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","ánibo mi-káyúkámá Îtumma akáyáámmá timáketa yemá ítaraae min-íyápómá pukuráitataboata wíráa urááe. ");
INSERT INTO usa_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","miráimanibo Îtuma min-ínáárúgóní ayáákaq múte káyaaqtorena tiráiye: “inaarúo, itóaao.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","ánibo min-ínáárúgóní aágoma yauwéqma itana páátákáá itó-itana Îtuma yeráwáqtábá ‘aáwaqa áméro’ tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","ánibo min-ínáárúgóní anóayaa aboáma anómma iyánáaq urááyamanibo Îtuma akoqnáá-aimma timá-yimena ‘maami-qtátááqtábámá keráwáqá móra-waigomma íma timá áméro’ tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Îtuma tiyááka umá kaayaq-íyápó-ánnámá yááyama yorupamá yíkarena Îtuma akoqnáágaraq náápaaakaraq yímikaimma yemá waátáma mútûq táí-aagomma waqtukéta ókon-oko-karima mamá atóbamayikareta ígáae téna yímikaiye. ");
INSERT INTO usa_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","mikáké mi-káyúkámá uréta Áánûqtuma yabíkái-kayukayaba mó kéteta karí-wáyúkámá mamá atóbamayikaigaae téna Îtuma timáyíkaraiye. ");
INSERT INTO usa_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","ánibo Îtuma maará-tima-yimikaiye: “keráwáqá máqte-qtataaqa ímáyáaro. yáumma amé uréire í-yátááqá íma mayéra kápiq-unamma íma mayéra naí-yátáákáráq mónekaraqa íma mamé uréire oro. kúberai-unamma kaayaqá íma mamé oro. ");
INSERT INTO usa_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","ánibo keráwáqá móra-naupaq uyábereqa paá min-náúpáq máéro. ");
INSERT INTO usa_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","ánibo mi-káyúkámá yeqtí-naaupaq ímo tiwíqme wíyaqa keráwáqá timá tága-yimeraq tibíkáké obamá popoq umátuweraq kóéraq yauwéqma ókaraq íma oro.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","miráitata iyápó-annama máqte-marupaqa yemá kóureta átê-wataama Áánûqtuqtaba kétima-yimeta karí-wáyúkámá mamá atóbamayikaraae. ");
INSERT INTO usa_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","kíni Érôtima Îtuma máqte-qtataariq i-wáígóní watáama ítátuwaitana aúyánákómá mibáq kóuraiye. yaímma-wayukama téta ‘Yóáanema pukáipike itó-uraiye.’ téta tirááe. ");
INSERT INTO usa_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","káqo-kayukama tirááe: “Iráíyama pááq iyé tirááe.” ánibo tébakaq-wayukama tirááe: “mórama naayón-ámúné-náqá yauwéqma pukáipike itó-uraiye.” téta tirááe. ");
INSERT INTO usa_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","miráitana Érôtima maará-tiraiye: “kemá Yóáaneni aqnómmá arátukaunamanibo min-náqá náawaq máitaraq kemá weqtábá mirán-áímmá kéitauno?” timátuwena mikáké Îtumma aúrapi aónane uráiye. ");
INSERT INTO usa_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Îtuma awaaméqá umáyikena yiwíkai-kayukama yauwéqma iréta máqte-qtataariq on-ááímmá Îtukaq má-tima-amikaae. ánibo Îtuma yiwíkai-kayukama mibáq yiwíqmeta yenamáa móra-marupaq Beqtáirapaq urááe. ");
INSERT INTO usa_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","anaaékaqa taíganimma aarawaamá aónaraa-kayukama Îtun anaaé waqméta urááe. ánibo Îtuma kéyimonena amuqá maqyíkátuwena yemmá Áánûqtuma yabíkái-kayukayaba watáama timá yímikaiye. ánibo mikákémá karí-wáyúkámá mamá atóbamayikaraiye. ");
INSERT INTO usa_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","aabaúgómá kuperánéna kéitata kaayaq-ánná-wáyúkámá Îtunopaq iréta tirááe: “emá maa-káyúkámá timáyíkénata yaímma-maruparaa meraráipaq wéyáwé umá watéta aáwaqa abáá-uma naaro. maan-áúkápáqô máunataama waayúkama íma máa-kaqmaapare.” téta tirááe. ");
INSERT INTO usa_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","miráimanibo Îtuma maará-tima-yimikaiye: “keráwáqá kenamáárîq maami-káyúkámá aáwaqa yímero.” téna Îtuma tiráiye. ánibo yemá tirááe: “ketáámá netuq-ááwáqá íma makáunataae. móra-tiyaapaq-yakaraq kaayaq-nóyáákáráq makáunataae. ketáámá maami-káyúkátí aáwaqa ko meyáníq ónúnataabiyo?” téta ítama aónaraae. ");
INSERT INTO usa_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","miráuma taíbaq-wayukama (5,000) máqe-uraae. ánibo Îtuma wení iyápó-annama maará-tima-yimikaiye: “keráwáqá timá-yimiyata yemá áíkuma móra-tiyaapaq-tiyaaka-tiyaaka umá áíkuma máéro.” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","miráuma iyápó-annama mi-káyúkámá timá yímewata teníq umá aarawaamá áíkuma máqe-uraae. ");
INSERT INTO usa_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","miráitana Îtuma móra-tiyaapaq-yamma kémayena kaayaqá kátútai-noyaakaraq maténa Áánûqtukaq aúramma múte káonena ‘tíkáiye’ tiráiye. ánibo mi-nóyáákáráq yakaráq mapámma wení iyápó-annama yímitata yemá mamá aarawaamá yímikaae. ");
INSERT INTO usa_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","ánibo máqte-kayukama namá kanaaráq owata iyápó-annama aqtó-áqtó-ááwáqá áiqma tiyááka umá kaayaq-únámmá áíqturaae. ");
INSERT INTO usa_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","móra-taoqa Îtuma wenamáa nunamummá kétena máitata wení iyápó-annama Îtute máqe-uraae. ánibo Îtuma iyápó-annama ítama yimónaraiye: “aarawaamá keqtábá náawae kéteo?” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","ánibo íyápó-annama yauwéqma tirááe: “yaímma-wayukama eqtábá Yóáanema nommá peraí-náré kéte. ánibo yaímma-wayukama téta Iráíyae kéte. ánibo tébakaq-wayukama téta naayóbáq móra amuné-náqá pukáimma itó-uraiye kéte.” téta tewana ");
INSERT INTO usa_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Îtuma yauwéqma tiráiye: “keráwáqá kenamáárîq keqtábámá náawae téraq kéteo?” téna ítáitana Pítaama yauwéqma tiráiye: “emá Áánûqtuni Metáíyama yauwéqma tiwiraí-náqóne.” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","mirá-timatuwaitana Îtuma akoqnáá umá téna káqo-kayukama maamin-áímmá íma timá yíméro téna iyápó-annama aammá áunikaraiye. ");
INSERT INTO usa_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Îtuma móragaraq timá yímikaiye: “Waayúkagoni Áráaqa aíqa í-yátááqá mayáínata anó-kayukagaraq anó-monoq-wayukagaraq ámáan-aimma yirááti-wayukagaraq yemá yinaaémma umáketa ikamíyana pukéna kaumo-kánáámá ánatainana keqnáámmá itó-iniye.” téna Îtuma wenamáárîq wetábá tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","ánibo Îtuma wení iyápó-annama máqtemma maará téna timá yímikaiye: “náawabi ketinaaé waránáae ténama wemá wenamáárîq wetábá awikátuwena wení kaapaq-yámá maména aati-aatimá mamé wínna-nakoma tinaaé waraíno. ");
INSERT INTO usa_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","náawabi wení aúwaraiqtaba aúyánámmá iténa yáqtoqma akoqnáá ínna-waigoma wení aúwaraimma aúyoranimanibo náawabi keqtábá aúwaraimma yuwénama wení matúq-matuq umá mái-auwaraimma paá yáqtoraniye. ");
INSERT INTO usa_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","ítáaro. móra-nakoma wetábá máqte-qtataaqa maa-márábíké kémayenamanibo matúq-matuq umá mái-auwaraimma ímáyáimma wení oótakoma nôro umákaniyo? ");
INSERT INTO usa_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","ánibo móra-nakoma keqtábágáráq yiráátén-aiqtabagaraq agaeyábá énama Waayúkagoni Áráakoma wemá wetábá wení tágama-yataakaraq aboámá Áánûqtuni tágama-yataakaraq wení aokaq-káqtó-wáyúkágáráq kumínna-yupaama min-nákóqtábámá agaeyábá umákaniye. ");
INSERT INTO usa_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","kemá keráwáqá áraimma kétima-timune. yaímma-wayukama maanámo itó-uma máa-kayukama íma pukéta Áánûqtuma yabíkái-kayukama aónainoe.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","min-áímmá timátuwena anaaékaqa miráuma abapaké kaumo-kánáámá yáwitana Îtuma Pítaama káwirena Yóáanema káwirena Yêmitima káwirena umáena anubaq nunamummá tínéna yiwíqme utáiye. ");
INSERT INTO usa_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","nunamummá kétena máitana Îtun óíkoma mamá aokaríq kéitana wení wáqtôgoma wayámmá auréna miráuma ókáá kamá tágaraiye. ");
INSERT INTO usa_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","ánibo kaayaq-nákórátá Îtute watáama tirááye. min-nákámá Mótetiyaa Iráíyae. ");
INSERT INTO usa_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","yenákámá tágama-yataakaraq kukéta máqte-qtataariq éna Îtuma Yérútáárebaq puíníqtaba watáama tirááe. ");
INSERT INTO usa_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Pítaagaraq kaayaq-nákátí yúrakoma yúgáibaaq itata yú wagínéta urááe. miráimanibo yemá waguréta máqeta anaaékaq itó-uma máeta Îtuni tágama-yataakaraq Mótetiyaa Iráíyati tágama-yataaqa aónaraane. ");
INSERT INTO usa_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Mótetiyaa Iráíyama Îtumma ayuwéta kóiye. kéoyana Pítaama Îtumma maará-tima-amikaiye: “kawáá-nákô, ketáámá maakáq máunataama minnâ íráqône. ketáámá kaumo-námmá ónúnataae. móra-namma ení naané. móra-namma Mótetini naané. ánibo móra-namma Iráíyana naané.” téna Pítaama tiráiye. ánibo Pítaama íma ítama arútárenaboana min-áímmá tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Pítaama min-áímmá kétena máiqtaba móra-konnakoma yawááq-umayikaitata yemá yáaqtaba urááe. ");
INSERT INTO usa_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","ánibo móra-aikoma maará téna mi-kónnápíké tiráiye: “maannáma ketáanine. kemá wemmá awaaméqá umákaraune. keráwáqá wenáama ítáaro.” téna min-áíkómá tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","min-áíkómá mirá-timatuwaitata yemá aónaamma Îtuma wenamáa máqe-uraiye. ánibo yemá yóyau kawaa urááe. mi-kánááráqá mi-qtátááqô aónaaqtabama móra-nakomma íma timá ámikaae. ");
INSERT INTO usa_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","aabáyaama min-ánúmá yuwéta kúmówana taíbaq-wayukama Îtumma aapaké kun aónaraae. ");
INSERT INTO usa_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","ánibo mi-káyúkábíkémmá móra-nakoma anókaq wááqa yumátuwena maará-tiraiye: “yirááti-nako, kemá inaa kétune. emá ketáanikomma aónaao. kemá wemmá wenamáa kímora-iyapoma ákáraune. ");
INSERT INTO usa_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","ánibo mórama táí-aagoma min-íyápómá yáqtoqma akoqnáá uráitana páátákáá wááqa kéitana mamá aíbôriq kéumakaitana óyaupikema wayán-ágárégómá ôriq kéiye. mi-táí-áágómá áú-aiqa aména íma yuwéna kégoiye. ");
INSERT INTO usa_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","kemá ení iyápó-annayaba mi-káátágómá matuwaígáae téq inaa túnnamanibo yemá kanaaráq íma kématuwaae.” téna Îtumma timá ámikaiye. ");
INSERT INTO usa_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Îtuma yauwéqma tiráiye: “keráwáqá aarawaamá maa-kánááráq-wáyúkámá itáíq-itaiq íkéowanaboana keráwáqtí tíyakoma táíq éna íkárutaiye. kemá náaraq umá kanaawaq keráwáqtéma máeraq keráwáqtí ummaamá mayánúnô? mirá-timatuwena min-nákómmá timá ámikaiye: “ení iyápóma awíqme maabáq iyo.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","min-íyápómá aapaqá kéiqtaba mi-táí-áágómá min-íyápómá mamá awéqtáma iyaabótukaiye. miráitana Îtuma waátáma aamá awáágútuwena min-íyápómá mamá atóbama aboámmá ámikaiye. ");
INSERT INTO usa_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","minnáyaba máqte-kayukama Áánûqtuni anón-akoqnaama aónatuweta iyánáaq urááe. ánibo mi-káyúkámá Îtuma máqteniq i-qtátááqtábá netuq-yúyánámmá kéitaawana Îtuma wení iyápó-annama maará téna timá yímikaiye: ");
INSERT INTO usa_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“keráwáqá maan-áímmô túnnama taákau makéra ítama arútáaro. pááqya-kanaabima anaaékaqa Waayúkagoni Áráaqa waayúkati iyáápi maránóe.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","miráimanibo iyápó-annama min-áímmá íma ítaraae. min-áíkóní áaikoma yepímmá aúyokuraitataboata íma ítama arútáraae. miráitata yemá ikatîq éta Îtumma min-áíkóní áaiqtabama íma ítama aónaraae. ");
INSERT INTO usa_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","yemá iyápó-annama itó-uma ánateta aamá téite éta náawaq anómma uyátá-maqma máiyo tirááe. ");
INSERT INTO usa_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","ánibo mirá-yúyánámmá iyápó-annati íyáqnobaq wáitana pááqyan-iyapoma awíqmena má-ito-umakaraiye. ");
INSERT INTO usa_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","ánibo Îtuma maará téna timá yímikaiye: “móra-nakoma ketíwîkaq maa-pááqyán-íyápómá áwáqnaa énama minnâ kemmá tíwáqnaa íniye. ánibo móra-nakoma kemmá tíwáqnaa énama minnâ kemmá timátíkáitaq yúnna-waigomma Áánûqtuma áwáqnaa kéiye. máqtemma keráwáqtí aúkáapikemma móra-nakoma miráuma pááqyan-iyaporaa umá maénama wemá uyátá-maqma anó-naqa mániye.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Yóáanema yauwéqma tiráiye: “kawáá-nákô, ketáá móra-naqa aónáúnataama enáwîkake táí-aagomma kématuwaiye. miráimanibo wemá ketááí tinaaémma íma kéwaraipoataa ketáá aammá áunakaraunatae.” téna Yóáane tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","miráitana Îtuma timá ámikaiye: “keráwáqá min-nákómmá íma aammá áunakaaro. móra-nakoma keráwáqá namuroíq íumatikenama wemá minnâ keráwáqtí aanábómíye.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Áánûqtuma Îtumma awíqmena wenôpaq uwínî-kanaama waaqókáq uráiye. miráitana Îtuma Yérútáárebaq ónáae téna mimórá aúyánámmá ítama yarútaiye. ");
INSERT INTO usa_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","ánibo Îtuma yaímma-wayukama timáyíkáitata aamá maméta áqnáabaq urááe. aamá maméta kó-kayukama Taméria-wayukati pááqya-marupaq uyábéketa Îtumma yokaa umákaneta urááe. ");
INSERT INTO usa_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","miráimanibo mi-márúkáq-wáyúkámá Îtumma awíqmeta yeqtí naaúpaq uwíyábá íma yíkaraiye. yemá ítaraae. Yérútáárebaq yeqtí namuro-wáyúkámá máápaq witatabóata Îtumma íawikaae. ");
INSERT INTO usa_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","kaayaq-íyápó-ánnámá Yêmitiyaa Yóáanema min-ááímmá yenákámá aónatuweta Îtumma maará-tima-amikaaye: “uyátárai-nako, ketáá Áánûqtnopake iramá ááyaananataa mi-káyúkámá kun agamá kautíníyô?” téta tirááye. ");
INSERT INTO usa_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","miráimanibo Îtuma waeréna min-nákámá min-ááíqtábá yiwááguraiye. ");
INSERT INTO usa_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","ánibo yemá mikáké ôq-marupaq urááe. ");
INSERT INTO usa_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","yemá aapaq maré kéowana móra-nakoma Îtumma maará-tima-amikaiye: “máqte-marupaq wíné innabáqá kegáráq anaaé waqmé ónúne.” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","ánibo Îtuma wemmá makáqma aónanena timá ámikaiye: “abááq-íyákómá muríánóbáq kémaitana numagómá ánáamma umárena kéwaimanibo Waayúkagoni Áráaqa waénúna-namma íma wáiye.” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","ánibo Îtuma káqo-nakokaraq timá ámikaiye: “emá ketinaaé waraao.” téna titana min-nákómá maará-tiraiye: “kanaaráq tiyúwénaq ketibomá ko mamá uqtamá kátuwerabiyo?” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","ánibo Îtuma timá ámikaiye: “ibáqyuwaao. yemá keqtábá íma itéta pukáa-kayukaraa-kayukama iyúwénata pukáíya-kayukama uqtamáyíkáaro. ánibo emá uré Áánûqtuma yabíkái-kayukayaba átê-wataama mó-tima-yimiyo.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","ánibo keqnáámmá móra-nakoma tiráiye: “uyátáraana-nako, kemá enanaaé waránáá kéunamanibo emá kanaaráq tiyúwénaq ketí waayúkama tiyááma mó yímíqma máéro timá yíkátuwero.” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","ánibo Îtuma maará-tima-amikaiye: “waayúkama náayubi Áánûqtuni aakaq áaimma átáma wínéna kéimanibo aati-aatimá anaaépaq naayón-ááíqtábá waéqma káonaipoana Áánûqtuma yabíkái-kayukabimma kanaaráq íuwiniye.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","anaaékaqa uyátárai-nakoma abapaké kaayaq-tíyááká-wáyúkámá ókaraq awaaméqá umáyikena kaayaq kaayaq umá timá yíkáitata áqnáabaq urááe. ánibo máqtemma anó-maruparabi pááqya-marupaqa Îtuma wíné i-márúpáq timáyíkáitata kówana anaaékaq Îtuma wíníqtaba uráiye. ");
INSERT INTO usa_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","ánibo Îtuma mi-káyúkámá maará-tima-yimikaiye: “taíbaq aáwakoraa umá yópí âbuma karáimanibo taíbaq-mayai-wayukama íma mááe. miráínaq keráwáqá yókóní aboákáq nunamummá tíyana wemá Áánûqtuma yaímma mayaí-wáyúkámá timáyikainata wení aáwakaa ko mamá áíkuyikaino. ");
INSERT INTO usa_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","kéráwáqá kóoro. ánibo ítáaro. akikérá umá máa-kayukati aúkáapi kaayoné-wámmá kokóri-araakaa umá timá-tikaunaq kégoe. ");
INSERT INTO usa_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","keráwáqá aapaqá yaímma-yataaqa títauq-anamma kápiq-unamma móneqa íma mamé oro. ánibo keráwáqá aapaqá íma aagamá waayúkate watáama tero. ");
INSERT INTO usa_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","móra-naupaqa uyábereq áqnáabaqa maará-tero. ‘maan-náúpáq-wáyúkábímmá kaayoné-yátááqá waíno.’ téra tero. ");
INSERT INTO usa_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","ánibo móra-nakoni áyákoma kaayoné ínna-naqa min-náúpáq máinaqa minnámo kaayoné-yátááqá waíno tíyan-aikoma min-nákópí yuwáiyanaq ko waíno. ááqibo móra-nakoma ímo mirá énama kaayoné-yátááqá waíno tíyan-aikoma yauwéqma keráwátôpaq yíno. ");
INSERT INTO usa_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","keráwáqá mimórá-náúpáq áátuma máéro. ánibo min-náúpáq máiyata yemá aáwaqa timéta nommá timéta íyamma naaro. mayaíráq-nákómá kanaaráq wení meyámmá mayániye. miráínaq keráwáqá óq-naupaqa móra-mora umá íoro. ");
INSERT INTO usa_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","ánibo keráwáqá mera-márúkáq uyáberaiyata mi-márúkáq-wáyúkámá yeqtí naaúpaq tiwíqme wíyaqa kanaaráq uréraq yemô timíyan-aawaqa naaro. ");
INSERT INTO usa_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","ánibo mi-márúkáq karí-wáyúkámá mamá kátobamayikeraq mirá kéeqa yemmá maará téraq timá yíméro. ‘Áánûqtuma yabítikani-waigoma keráwáqtí waaqókáq maíye.’ timá yímero. ");
INSERT INTO usa_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","ánibo keráwáqá móra-marukaq wíyata mi-márúkáq-wáyúkámá yeqtí naaúpaq íma tiwíqme wíyaqa kanaaráq keráwáqá mi-márúkóní aakaq ko itó-uma máera maará-tero. ");
INSERT INTO usa_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘keráwáqtí maa-márúkáké kaítôgoma ketááí tibíkáq aráápaimanibo ketáámá popoq umátuwaunanataa keráwáqtôpaq yauwéqma wiyé. atéráaro. Áánûqtuma yainaí-kánáágómá keráwáqtí táí-meyakaraq waaqókáq kéiye.’ tero. ");
INSERT INTO usa_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","kemá keráwáqá kétima-timune. mi-márúkómá keráwáqá íma tiwiráiya-marukoma Tótôma-marukoma uyátá-maqma anómma táí-aimma wánipoana aqtó-kánááráqá Áánûqtuma Tótôma-marukomma paru umáyikena íma tiwiráiya-marukomma íma paru umáyikaniye.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Îtuma óq-aimma tiráiye: “keráwáqá Ítíráaeo-marupaq-wayukao, ítáaro. Tiyórátini-wayukao, keráwákáq táí-yataaqa anómma pááq íniye. Beqtáira-wayukao, keráwákáq táí-yataaqa anómma pááq íniye. ánibo kemá keráwáqtí márûkaq awaaméq-yátáárîq únnaiq umá móra-nakoma Tááíranapaq Tááyabakaraq awaaméq-yátáárîq énama kanaaráq naayóbáq yemá unáá káréqomma wáqtôraa yáútúma itoréta kanabí máeta yirummá waeráune téta yiráátiraae. ");
INSERT INTO usa_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","aarawaamá mamá yainánéna ínna-kanaaraqa Tááyabaq-wayukagaraq Tááíranapaq-wayukagaraq yemmá anónnáma táí-meyamma Áánûqtuma yimínímanibo keráwákáq uyátá-maqma anómma anónnáma táí-meyamma timíniye. ");
INSERT INTO usa_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","ánibo keráwáqá Kápéranabaq-wayukao, keráwáqá múte yaúmeq Áánûqtukaq uwínô? miráinomanibo keráwáqá paá Tááqtaani márûpaqa iyaabótuwanoe.” téna min-áímmá Îtu tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Îtuma wení iyápó-annama maará-tima-yimikaiye: “móra-nakoma keráwáqtí táama itaína-nakoma minnâ ketáama kéitaiye. ánibo móra-nakoma keráwáqá anaaémma umátikenama minnâ kemmá anaaémma umátikaniye. ánibo móra-nakoma anaaémma umátikenama min-nákómá kemmá timátíkáitaq yúnna-naqa Áánûqtumma anaaémma kéumakaiye.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","anaaékaqa abapaké kaayaq-tíyááká-wáyúkámá Îtuma timáyíkaraimma yauwéqma iréta yimuqá ôriq umá kémareta maará-tiraae: “uyátáraana-nako, ketáá enáwîqa yaúnanataa táí-aagoma waayúkabike paábaq yá-uraae.” téta Îtumma timá ámikaae. ");
INSERT INTO usa_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","ánibo Îtuma timá yímikaiye: ‘kemá Áánûqtuni márûpake Tááqtaama aabáyúraa yoqména páátákáá kuqtitaq aónaraune. ");
INSERT INTO usa_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","ítáaro. kemá keráwáqá akoqnááma tímikaunaboaq keráwáqá kanaaráq iraakabayaakógáráq áwáábiq-uwabaaikokaraq títauqnapo yamá káraapeq Tááqtaani akoqnááma uyátánoe. ánibo móra-yataakoma kanaaráq íma mamá keráwáqá táíq umátikaniye. ");
INSERT INTO usa_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","miráimanibo keráwáqá táí-aagoma keráwáqtí táama ítáiqtabama timuqá íma maránómanibo Áánûqtuma máipaq keráwáqtí tíwîqa kágamaraibo minnáyaba timuqá máraaro.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","mi-kánááráqá Áánûqtuni Aokaq-Áágómá Îtun áyáqnobaq mamá amuq-yatááqá pááq itana Îtuma maará-tiraiye: “ketiboó, ení márûpaq-wayukagaraq maa-márábí-káyúkágáráq uyátárai-nare. kemá minnáyaba ‘tíkáiye’ kétune. emá maami-qtátááqá itaí-yátááqá itéta ‘aamá ítaraunatae’ kéte-kayukabima mamá áuyoqyike aamá íma itéta paá-wayukama kéyiraatene. owé. ketiboó, ení akaí-yátáákómá mirá-uraiye. ");
INSERT INTO usa_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","ketibomá máqte-qtataaqa ketiyáápitaa makáiye. ánibo móra-nakoma kemmá áanikomma íma timónaraibo ketibomá wenamáa kemmá áanikomma kétimonaiye. móraiq umá móra-nakoma ketibommá Áánûqtumma íma aónaraibo áaniko kemá kenamáa káonaune. ánibo waayúkama náayuwabi áanikoma kemá yiráátenaaq únna-wayukama yegáráq ketibommá Áánûqtumma káonaae.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","yemá iyápó-annama yenámáa Îtute máawana yeqtôpaq waeréna Îtuma maará-tiraiye: “náayuwabi keráwáqá aónaa-qtataaqtaba yemá yimuqá kémaraae. ");
INSERT INTO usa_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","kemá keráwáqá kétima-timune. naayóbáqá taíbaq amuné-wáyúkáwábi taíbaq kíni-kayukama keráwáqá íbêqa aónaa-qtataaqa aónanaae temánibo yemá kanaaráq íaonaraae. ánibo keráwáqá íbêqa ítáan-aimma itánáae temánibo yemá íma ítaraae.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","mikáké mórama ámáan-aimma yirááti-nakoma itó-urena Îtumma makáqma aónanena uráiye. ánibo wé Îtumma timá ámikaiye: “yirááti-nako, kemá náaraq éraq matúq-matuq umá mái-auwaraimma mayánúnô?” téna ámáan-aimma yirááti-nakoma tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","ánibo Îtuma yauwéqma timá ámikaiye: “nóinae ténawaq Áánûqtuni watáama agamatán-áíkómá kétiyo? emá náaraq umá kéyorautono?” ");
INSERT INTO usa_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","titana min-nákó yauwéqma tiráiye: “mútûq arummá káme ení akoqnáágaraq arun-íyápógógáráq máqtemma aúyánákáráq ení uyátárai-nakomma Áánûqtumma weqtábá akaíno. ánibo enamáárîq eqtábá ákáiniq umá enamakaq náawabi maína-waigoqtaba akaíno.” téna agamatán-áíkómá tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","ánibo Îtuma timá ámikaiye: “emá áraimma arupú umá téne. emá miráuma ténaiq emá kanaaráq matúq-matuq umá mánone.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","miráimanibo mi ámáan-aimmo yirááti-nakoma wenamáárîq wenáwîqa mamá íráqôniq íyábá ákáitana timá ámikaiye: “ánibo ketimakaqô mái-naqa minnâ náawabiyo?” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","ánibo Îtuma maará téna yauwéqma tiráiye: “móra-nakoma Yérútáárebake yuwéna Yérikobaq kukáiye. ánibo moyá-káyúkámá aapaq aónatuweta máqte-qtataaqa yabímayeta ikámma taítawaa umákaraae. yemá miráumatuweta kóuraae. anaaékaqa min-náqá aapi máena wemá puíné uráiye. ");
INSERT INTO usa_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","ánibo mi-kánááráqá móra monoq-káwáá-nákómá min-ámmá waqmé kukáiye. Táméria-naqa aónawaaena yuwéna kótámaqtuwena aan áwábake kóuraiye. ");
INSERT INTO usa_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","móraiq umá móra Aríbae-annabike-nakogaraq min-ápáq iréna min-náqá ya aónatuwena kótámaqtuwena aan áwábaq maréna kóuraiye. ");
INSERT INTO usa_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","miráimanibo Támériabake móra-naqa ikámaraa-nakoni namuro-nákómá min-ápáq maréna min-náqá máikaq iráiye. ánibo wemmá aónaimma áyáqnobaqa aruqtabá umákaraiye. ");
INSERT INTO usa_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","ánibo amakaq uréna matawékaraq wááéni-nokaraq atíma náopi atáá-umakatuwena min-náqá mûte yaúma wení ótiraa-kakoni ámûraaq abímmá ayákaraiye. ánibo awíqmena min-náqá waabá-káyúkámá kówate-yawate o-náúpáq mó ákarena yabírákaraiye. ");
INSERT INTO usa_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","ánibo min-náúpáq wamarááyakake aabáyaanapimma mi kówate-yawate-nakoni aboámmá móneqa móra-wayukama ámíqtuwena maará-tiraiye: “emá maa-nákókáq yabíqma arútárenana yaímma ení móneqa maami-nákókáqô kóí-naqa kemá yauwéqma yéqa yaímma-meyamma yauwéqma aménúne.” téna tiráine. ");
INSERT INTO usa_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","íbêqa emá náaraq téq aúyánámmá kéitaano? kaumo-wáyúkámá maréta yewana moyá-káyúkámá ikámaraa-nakomma náawaq amakaq máitana áwáqnaa iníkáámá uráiyo?” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","ánibo ámáan-aimma yirááti-nakoma maará-tiraiye: “min-nákómá arummá itana áwáqnaa i-náré.” titana Îtuma timá ámikaiye: “emá uré min-nákómá iníq uwo.” téna namuro-wáyúkáyábágáráq wemmá Îtuma timá ámikaiye. ");
INSERT INTO usa_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","yemá maré owana Îtuma wení iyápó-annate móra-marupaq uyábékaae. móra-inikoni áwîqa Máátaae. wemá Îtumma awíqmena wení naaúpaq uráiye. ");
INSERT INTO usa_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Máátaani áúkoma wení áwîqa Máríaae. ánibo Máríaama iréna uyátárai-naqa Îtuni aítaupi maraq ya máena Îtun áama ítaraiye. ");
INSERT INTO usa_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","miráimanibo Máátaama uri-uri kéena aáwaqa mamá yokaa kéitana aúyánákómá wéyáwé uráiye. miráitana Máátaama Îtunopaq uréna maará-tiraiye: “uyátáraana-nako, ketúkoma kenamáa tiyúwáitaq máeq aáwaqa mamá yokaa kéune. minnáyabama emá íyaq aúyánámmá kéitaano? emá Máríaamma timá ámínana wemá ya tíwáqnaa íno.” téna Máátaama tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","miráitana uyátárai-naqa Îtuma Máátaamma maará-tima-amikaiye: “Máátaao, emá netuq-áúyánámmá kéite máqte-qtataaqtaba ummaa kéyaane. ");
INSERT INTO usa_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","miráimanibo móra-yataaqtaba íma wáitana abáá kéiye. ánibo Máríaama íráqô-qtataaqa mayánéna kéiye. Máríaanopake íráqô-qtataaqa íma paábaq matuwániye.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Îtuma móra-aukapaq nunamummá kétena máqe-uraiye. ánibo anaaékaqa nunamummá timá ánatatuwaitana mórama wení iyápó-annabike-nakoma maará-tima-amikaiye: “uyátáraana-nako, nunamummá tí-ááímmá keqtáá timá tiráátiyo. miráuma naayóbáqá Yóáanema wení iyápó-annama timá yiráátiraine.” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","ánibo Îtuma maará-tima-yimikaiye: “keráwáqá nunamummá tínéqa maará tero. keqtibotááo, emá yabíkáánna-marukaq máanana enáwîkoma aokaq wáiye. emá yabíkáánna-yataaqa maabáq kumíno. ení márûkaqa enaúyánámmá wáráanikaa umá maa-márábíkáráqá enaúyánámmá waránátaae. ");
INSERT INTO usa_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","íbêqa aáwaqtaba únnataama máqte-tupaama timiyo. ");
INSERT INTO usa_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","ketááí otaa-qtátááqá mamá paábaq kéyuwe awikátuwaao. miráuma otaa-qtátáárîq umátíkáa-kayukama yeqtí otaa-qtátááqá paábaq mamá kéyuwetaa tiwikátukaunataae. emá keqtáá anómma makáqma aónai-yataaqa íma mamé iyo.” téna Îtuma wení iyápó-annama nunamummá timá yiráátiraiye. ");
INSERT INTO usa_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","ánibo Îtuma maará-tima-yimikaiye: “ánibo keráwáqtí aúkáapike móra-nakoma wení aanábómá máinaboana min-nákómá nokáámma uréna wení aanábógómmá maará téna mó-tima-amikaiye. ‘ketí aanábógô, kemmá aáwaqa timiyo. ");
INSERT INTO usa_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","ketí aanábó-nákómá ayáqtááqa-amma uréire éqéna ketôpaq yimmá aáwaqa aménúna-yataaqa íma makáune.’ téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","ánibo naaúpaqo máitana yaqtabá ko ítái-nakoma maará téna yauwéqma tiráiye. ‘kemmá ummaa-yátááqá ítime ítiwautuwo. oqtamá aúyakuraitana ketí iyápó-annagarataa túmá waguráunataae. kemá íma itó-ureq móra-yataaqa aménúne.’ téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","ánibo nôraq uráiyô? min-nákómá wení aanábóé téna íma itó-urena aáwaqa íaminiye. kemá kétima-timune. emmá agaemá íma ínaaboaa ókaraq itaa-itaa inanamá wemá itó éna máqte-qtataaqtaba ónna-yataaqa emmá amíniye. ");
INSERT INTO usa_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","ánibo kemá keráwáqá kétima-timune. keráwáqá Áánûqtukaq nunamummá tíyana Áánûqtuma móra-yataaqa keráwáqá timíno. keráwáqá móra-yataaqtaba abáá kéeqa kanaaráq aónainoe. oqtaráq pagé-page tíyanama Áánûqtuma oqtamá ítikaniye. ");
INSERT INTO usa_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","máqte-kayukama Áánûqtukaq nunamummá tétama yemá mayaínoe. móra-nakoma nóiqtababi abáá énama wemá aónaniye. ánibo náawabi oqtaráq pagé-page tínanama Áánûqtuma oqtamá íyakaniye. ");
INSERT INTO usa_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","keráwáqtí aúkáapikema móra-nakoni áanikoma aboáqtábá ‘noyááqa timiyo’ tínanama aboámá kanaaráq iraakabayaammá amíníyô? ");
INSERT INTO usa_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","ánibo áanikoma aboáqtábá ‘kokóri-amuqa timiyo’ tínnayaba kanaaráq aboámá áwáábiq-wamma uwabaaimmá amíníyô? minnágaraqa ímiye. ");
INSERT INTO usa_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","ánibo keráwáqá táí-wayukamanobo íráqô-qtataaqa keráwáqtí iyápóma yimí-áímmá káonaae. miráinataa ketáá minnáyabataa káonaunataae. ketibotáá Áánûqtuma wení márûpaq máin-nakomma wekáq nunamupí itaíyanama yemmá wení Aokaq-Áámá yimíniye.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","móra-nakoma aamá íma téna máin-nakopike Îtuma táí-aama waqtukáiye. ánibo mi-káátámá paábaq kóitana óyauqo aúyaki-nakoma aamá áaimma átáma tiráiye. miráitata aarawaamá taíbaq iyánáaq urááe. ");
INSERT INTO usa_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","ááqibo yaímma-wayukama maará-tiraae: “Piétebuma táí-aagoni kawáá-nápóana Tááqtaani akoqnáárake Îtuma waátáma kématuwaiye.” téta tirááe. ");
INSERT INTO usa_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","ánibo yaímma-wayukama Îtumma makáqma aónaineta Îtuqtaba mórama anón-awaameq-yataariq ínataa aónaano tirááe. ");
INSERT INTO usa_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","miráimanibo Îtuma mi-káyúkátí yúyánámmá aónatuwena maará téna mi-káyúkámá timá yímikaiye: “móra-marukaq-wayukama yaíkaaq uréta ááiqa íyana mi-márúqá íma íráqóniq umá paá wániye. móra-anna-wayukama yaíkaaq uréta wenikamé-wenikame étama min-ánná-wáyúkámá íma íráqôniq umá paá mánoe. ");
INSERT INTO usa_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","keráwáqá téq keqtábá Piétebuni akoqnáárake táí-aagomma kématuwaane kétewaq minnáyaba kétune. ánibo Tááqtaani waayúkama yaíkaaq umá kaayaq-ánnáíq uréta ááiqa íyanama Tááqtaani akoqnáámá íma wániye. ");
INSERT INTO usa_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","móra-nakoma Tááqtaani akoqnáánapo táí-aagomma íma kanaaráq kématuwaiye. Ítíráaeo-wayukao, áraimma Piétebuma tíwáqnaa kéi-naqo waátáma kématuwaananama kanaaráq náawaq keráwáqtí iyápóma yíwáqnaa ínatawaq yemá táí-aama matuwánô? miráinata keráwáqtí iyápóma iyuwáiyata min-áímmá árainabi íabiyo téta ítama aónaaro. ");
INSERT INTO usa_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","miráimanibo Áánûqtuni akoqnáárake táí-aama kématuwaunaboana minnáyaba Áánûqtuma yabíkai-waigoma keráwákáq áqa iráiye. ");
INSERT INTO usa_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","ítáaro. Tááqtaama mórama akoqnáá-nakoraa umá iyebó umátorena wení naaóq yabítuwena máinanama kanaaráq wení máqte-qtataaqa paá wániye. ");
INSERT INTO usa_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","miráimanibo káqomma uyátá-maqma akoqnáá-nakoma iréna min-nákótê ááiqa umá uyátenama min-nákóní tokóruyakaa-puma wení iyebómá máqtepaq min-nákómá aúyánámmá itáíq-itaiq i-qtátááqá maténa máqte-qtataaqa yaímma káqo-kayukama yimíniye. ");
INSERT INTO usa_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","ítáaro. móra-nakoma ketí aanábómá ímo maénama minnâ wemá ketí namuro-náqíye. móra-nakoma ketê íma mamá áíkuyenama wemá ketí waayúkama mamá waqmé wéyáwé kéumatuwaiye.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","óqa waéqma itaí-áímmá Îtuma timá yímikaiye: “ánibo táí-aagoma móra-nakopike yuwéna paábaqo kégowenama kokoq-márábáq kóurena aagamá máni-maruqtaba abáá kéiye. mi-táí-áágómá máni-maruqa ímo aónénama wé maará kétiye. ‘kemá yauwéqma maéwauna-naupaq ko mánune.’ téna kétiye. ");
INSERT INTO usa_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","ánibo mirá-timatuwena yauwéqma ko aónaimma naayóbáqô maéwai-namma kuyúqtuketa yokaa umákaae. ");
INSERT INTO usa_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","miráitana mi-táí-áágómá uréna káqomma abapaké kaayaqá uyátá-maqma táí-aama ko yiwíkena min-nákópí ya máqe-uraae. ánibo naayóbáqá min-nákómá táíq umá máqe-uraipoana íbêqa wemá uyátá-maqma anómma táíq umáguraiye.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Îtuma min-áímmá ti-kánááráqá taíbaq aarawaamá máqe-uraae. ánibo móra-inimma mi-káyúkátí aúkáapi máin-inikoma maará téna ááyama tiráiye: “móra-inikoma naayóbáqá marákáraitaa wení nááma naráána-inikoma ké itaúnama wemá amuqá kémaraiye.” téna min-íníkómá tiráimanibo ");
INSERT INTO usa_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Îtuma maará-tiraiye: “mirá íma téaq maará tiyo. Áánûqtun áama itéta anaaé waraíya-kayukama yemá yimuqá kémaraae.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","taíbaq-wayukama ayú yagéguyowana Îtuma maará-tima-yimikaiye: “íbêqa maa-kánááráq-wáyúkámá táí-wayukamoe. yeráwáqá móra anómma awaaméq-yátááqá aónanaae kéte. miráimanibo kemá móra anómma awaaméq-yátááqá íma yiráátenunamanibo kímora Yónaama anómma awaaméq-yátááqá yiráátenune. ");
INSERT INTO usa_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","naayóbáqá Yónaama Áánûqtuni awaaméqá máena Nínibeq-wayukabi timá tágayimikai-qtataaqa pááq uráine. móraiq umá Waayúkagoni Áráaqa Áánûqtuni awaaméqá íbêq-wayukabima pááq uráiye. ");
INSERT INTO usa_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","anaaékaqa Áánûqtuma aarawaamá mamá kéyainainana móra-inikoma kaapaq-áúkápáké (kúínima) itó-uma iréna íbêq-anna-wayukati táí-aaimma mamá pááq íniye. min-íníkómá maa-márágóní aqtóráké wemá iréna Tórómónima wení itaí-yátáákóní áaiqtaba timmá ya ítaraimanibo keráwáqá íbêq-kanaama íkeitaae. maakáqá Tórómónimma uyátáni-naqa maa maíye. ");
INSERT INTO usa_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Áánûqtuma aarawaamá yainánéna ínna-kanaaraqa Nínibeq-wayukama itó éta keráwáqtí kúmiq-yataaqtabama awaaméqá ínoe. ánibo Nínibeq-wayukama Yónaama aamá timmá itéta yirummá waékáae. miráimanibo íbêqa Yónaamma uyátáni-naqa maa máiye.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","waéqma itaí-áímmá Îtuma tiráiye: “waayúkama ómmá kúraqma yaaregóní aménáápárábi tawegóní aménáápáqá íma kémaraae. ímiye. yemá ómmá kúraqma abarokáq yaareráqá makáawata waayúkama min-náúpáqô kéyetama ómmá kamá tágaimma káonaae. ");
INSERT INTO usa_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","túramma keráwáqtí túgoni óné. ánibo túrakoma íráqôniq uráinanama keráwáqtí máqte-tuyanamma táganiye. ánibo túrakoma táíq umágínanama keráwáqtí máqte-tuyanamma kumayuqá aurániye. ");
INSERT INTO usa_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","miráinaq keráwáqá yabíqma arútáaro. keráwápímô tágain-okoma kumayuqá auráinabo ");
INSERT INTO usa_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","keráwáqtí máqte-tuyanamma tágama wáinana móra-aukapaq-turapimma íma kumayuqá auráinanama kanaaráq miráuma ókómá tirunóbáké kamá tágainikaa umá táganiye.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Îtuma min-áímmá timátúwáitana móra Pérati-nakoma Îtumma ááyama awíqmena wení naaúpaqa aáwaqa naínéna uráiye. miráitana Îtuma aáwaqa naí-yááréráq ko máqe-uraiye. ");
INSERT INTO usa_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","ánibo mi-Pérátí-nákómá aónaimma Îtuma áqnáabaq ayáámma íma tete éna paá aáwaqa mamá kénaiqtaba aónawaaena Pérati-nakoma iyánáaq uráiye. ");
INSERT INTO usa_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","miráitana uyátárai-nakoma Îtuma timá ámikaiye: “keráwáqá Pérati-wayukama keráwáqtí tirunóbáqá miráuma káápuwabi táápekoni amegaa-áúráqá tete umá íráqôniq umátúwáanikaa uráiye. ánibo keráwáqtí tirunóbáqá táí-aaikoma ógikaiye. ");
INSERT INTO usa_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","keráwáqá aíbôq-wayukae. móra-nakoma Áánûqtuma amegaa-áúrákáráq arunóbákáráqá íyaq tarôq kéiyo? ");
INSERT INTO usa_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","ánibo keráwáqtí táápepi wái-qtataaqa yáayaba o-káyúkámá yimíyana mikáké máqte-qtataakoma tirunóbáqá íráqôniq umátikaniye. ");
INSERT INTO usa_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","keráwáqá máqtemma anónabi pááqyan-aawapikema yoráuma tiyáákabike kímora mamá Áánûqtumma kámemanibo aammá kárabaae. Áánûqtuma tirummá amí-ámmá yukááe. mi-kááyáq-yátááqá waránómma Áánûqtumma tirummá améq ámáan-aimma wáráaro. ");
INSERT INTO usa_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","keráwáqá Pérati-wayukao, atéráaro. keráwáqá monoq-náúpáq aarawaatí yúbáq máiyaba ôriq umá kétikaitana waayúkama áíkuiyakaq ‘anón-nare’ téq miráó-maarao timá-tikaiyaba ôriq umá kétikaiye. ");
INSERT INTO usa_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","keráwáqá atéráaro. keráwáqá miráuma pukáa-kayukama uqtamáyíkáraa-mararaama aúpáq maranóbáq wáitata waayúkama yúramma íma aónéta ámûraaq yítauqa yamáe uréire oníkáá-káyúkámá keráwáqá Pérati-wayukama mááe.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","mórama ámáan-aimma yirááti-nakoma Îtun áaraq yauwéqma téna maará-tiraiye: “yirááti-nako, emá mirá té ketáágáráq timá táwîq kéumatikaane.” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","ánibo Îtuma maará-tiraiye: “keráwáqá ámáan-aimma yirááti-wayukao, atéráaro. keráwáqtí ummaa-ámáán-áímmá aarawaatí yímûraaqa mûte kémaraawata yemá mûte mayánôqtabama kammáa kámagoe. miráitaq keráwáqá móra tiyáánapo íma ánékuqma min-úmmáá-yátááqá mûte mayánóniq éq yíwáqnaa kéoe. ");
INSERT INTO usa_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","keráwáqá atéráaro. keráwáqtí títaubikoma naayóbáqá Áánûqtuni amuné-wáyúkámá yíkamowaq keráwáqá mi-káyáukáyábá mararaakaqá íráqô-kuruma umá kéikuyikaae. ");
INSERT INTO usa_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","keráwáqtí títaubikoma naayóbáqá nôrabi uráá-qtataaqtaba paá mimórá túyánámmá kéitaae. Áánûqtuni amuné-wáyúkámá yíkamma uqtamá yíkátuweq yeqtí mararaakaq íráqô-kuruma umáyíkaraae. ");
INSERT INTO usa_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","miráitana Áánûqtuma íráqômma itaí-yátáápíké maará téna tiráine: “ketí amuné-wáyúkámá kemá awaaméqá umáyikeq timáyikanune. yaímma mamá táíq umáyiketa yaímma yíkamma puínóe. ");
INSERT INTO usa_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","51","miráiyata íbêq-kanaaraq-wayukama yeqtí yítaubikoni anónnáma táí-meyamma mayánóe. áqnáabaq-kanaarake aqtó-kánááráqá Êboyaa Tékáráíyaama yíkakaane. Tékáráíyamma anó-monoq-naupaqa Áánûqtukaq amí-yáárégáráq waayúkama máirakaraq aúkáapimma ikákaane. ketí amuné-wáyúkámá yíkakaa-kayukayaba íbêq-kanaaraq-wayukama yemá anómma táí-meyamma mayánóe. ");
INSERT INTO usa_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","keráwáqá ámáan-aimma yirááti-wayukama keráwáqá atéráaro. aamá ítama arutaí-óqtáráké kíma matokáamanibo íuyaberaamma aammá aúyakaawata káqo-yuma uyáberanaae temmá keráwáqá aammá káuyaraae.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Îtuma min-námmá yuwéna máápaq kumá yaúbaitata ámáan-aimma yirááti-wayukagaraq Pérati-wayukagaraq Îtun-aubi maránôqtaba kammáa amáguraae. ánibo yemá máqten-aimma ítama aónaineta makáqma aónaraae. ");
INSERT INTO usa_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","miráitata yemá Îtumma kawáá umátuweta máeta móra-aimma tínata Îtuni áúbi maréta aamá ítama yainánéta urááe. ");
INSERT INTO usa_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","netuqyaa taíbaq-wayukama titipáá umá waayúkama ámûraaq-amuraaq éta yaímma yatámówaniq umá áíkuma máqe-uraae. ánibo mi-kánááráqá Îtuma wení iyápó-annama áqnáabaq maará-tima-yimikaiye: “keráwáqá Pérati-wayukati pááqya-qtataakoma (yíqti) anómma auraíyábá atéráaro. Pérati-wayukati kaaqaari-yááíqtábá kemá kétune. ");
INSERT INTO usa_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","máqte-qtataaqa aúpáq aúyoqma wáinna-yataakoma anaaékaqa abarokáq pááq íniye. máqte-qtataaqa yawááq umá wáinna-yataaqa anaaékaqa waayúkama aónainoe. ");
INSERT INTO usa_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","miráinaq keráwáqá máqten-aimma nokáa kumayupí máeq tíyan-aimma wágááma tínoe. ánibo keráwáqá máqten-aimma yaákareq timú-timun-aimma naaúpake tíyan-aimma máápaq máeta ááyama tínoe. ");
INSERT INTO usa_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","ketí aanábó-wáyúkáo, kemá Îtuma keráwáqá maará téq kétima-timune. keráwáqtí amegaa-túmá waayúkama tíkamma kanaaráq puínôqtabama ikatîqa íoro. anaaékaqa mi-káyúkámá ókaraq móra-yataariqa kanaaráq íumatikanoe. ");
INSERT INTO usa_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","keráwáqá áaqa ikatínô-waigomma kemá tiráátenune. minnámô Áánûqtumma áaqa keráwáqá ikátéro. wemá wení náápaamma wáipoana anaaékaqa waayúkama iramá káíq-kaiq-irabi yaúma iyaabótuwaniye. owé. kemá Îtuma keráwáqá kétima-timune. wenáaqa ikátéro. ");
INSERT INTO usa_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","keráwáqá káonaae. waayúkama móra-tiyaapaq-numama karogaro-mónéqá kaayakáké meyánîq kéoe. miráimanibo mórama pááqya-numagoqtabama Áánûqtuma íma awimmá kégamakaiye. ");
INSERT INTO usa_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","keráwáqtábá Áánûqtu máqte-qtataaqa kawáá kéenapoana keráwáqtí tiqnótáuma wemá yoráutukaiye. keráwáqá ikatîqa íoro. keráwáqá taíbaq pááqya-numagoni meyámmá uyátá-makuraae. ");
INSERT INTO usa_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","ánibo kemá keráwáqá kétima-timune. móra-nakoma aarawaatí yúrakaq ketíwîqa yéna ‘emá kennáé’ tínna-waigomma waayúkagoni Áráakoma Áánûqtuni kaqtó-wayukati yúrakaq wemmá móraiq umákanune. ");
INSERT INTO usa_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","ánibo móra-nakoma aarawaatí yúrakaq keqtábá ‘kemá íma wenámúne’ téna mi wakaráinna-nakomma waayúkagoni Áráakoma weqtábá móraiq umá Áánûqtuni kaqtó-wayukati yúrakaq wemmá wakárakaniye. ");
INSERT INTO usa_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Waayúkagoni Áráaqa móra-nakoma timá táíq umákainanama Áánûqtuma mi-kúmíq-yátááqá paábaq matuwéna awikátuwanimanibo wení Aokaq-Áágóqtábá móra-nakoma timá táíq énama min-nákóní kúmiq-yataaqa Áánûqtuma íma paábaq matuwéna awikátuwaniye. ");
INSERT INTO usa_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","taákaq máráaro. yemá keráwáqá ketinaaé waráiyataba tiwíqmeta Íbaru-monoq-nauparabi kámááni-wayukati yúrakarabi anómma náápaakaraq matokáiya-kayukati yúrakaqo tiwíqme wíyaqa keráwáqá ikatîqa íma éraq ‘ketáámá nóine ténúnataabiyo’ téq ítero. ");
INSERT INTO usa_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Áánûqtuni Aokaq-Áágómá é mi-kánáábí tiráá tínna-aimma tínoe.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","mi taíbaq-wayukabike móra-nakoma Îtumma maará-tima-amikaiye: “yirááti-nako, emá ketiwaammá timá ámínana ketiborátáí oótamma ketáá tímikaimma yaíkaaq umá kemmá timíno.” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","ánibo Îtuma min-nákómma maará-tima-amikaiye: “nôraq íyo? náawaq keráwáqtí táama ítama yainaí-náqá kemmá awaaméqá umátíkárai keráwáqtí oótamma mamá yainaí-náqá awaaméqá umátíkaraiyo?” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","ánibo Îtuma maará-tima-yimena tiráiye: “keráwáqá atéráaro. atéqma keráwáqá máeraq móra-yataaqtabama íma túran-anna-aaro. keráwáqtí árain-auwaraimma maa-márábín-ótámmá nôraq umá-yataarabi makáána-waigoqtabae téna íma wáiye. ");
INSERT INTO usa_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","ánibo Îtuma mórama waéqma itaí-áímmá maará téna timá yímikaiye: “mórama móneqa taíbaq makái-nakoni yópímmá taíbaq-aawaqa áyóki uráiye. ");
INSERT INTO usa_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","wemá aúyánánóbáqá maará-tiraiye. ‘íbêqa kemá náaraq ónúnô? ketí máqten-aawaqa mamá maránúnama anón-namma íma wáiye’ téna ");
INSERT INTO usa_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","aúyánánóbáqá timátuwena ‘kemá maará-onune’ tiráiye. ‘kemá ketí naammá yawítíma anón-namma umákeq min-náúpáqá ketí aáwaqa wítima kémareq ketí íráqô-qtataaqa min-náúpátáá mamá maránúne.’ téna aúyánámmá ítaraiye. ");
INSERT INTO usa_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","ánibo kemá keti-makómmá maará téq timá ámenune. ‘timakô, taíbaq ení íráqô-qtataaqa taíbaq wáena netuqyaan-áúqá yáwiye. ánibo emá íbêqa aagamá mááo. emá aáwaqa né nommá né kée amuq-yatáápí mááo.’ téna aúyánánóbáq tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","miráimanibo Áánûqtuma maará-tima-aminiye: ‘emá aíbôq-naqone. emá íbêqa-nokaa puínóne. ánibo máqte-qtataaqa yokaa umáraanama minnâ náawaq mayáníyô?’ téna tíniye. ");
INSERT INTO usa_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","miráráá umá waayúkama yeqtí máqte-qtataaqa yetábá maqmá ayúmá kéguyomanibo Áánûqtuni aúrakaqa áwáyoq-wayukama mááe.” téna Îtuma waéqma itaí-áímmá tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Îtuma wení iyápó-annama maará-tima-yimikaiye: “miráitaq kemá keráwáqá kétima-timune. keráwáqá keráwáqtí tú-araiqtabama netuq-túyánámmá íma itéraq ketáámá nóinawaq nánúnataabiyo? ítero. ánibo keráwáqá keráwáqtí túyabama netuq-túyánámmá itéraq ketááí túraqa nóinawaq yawááq-onunataabiyo? ítero. ");
INSERT INTO usa_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","túwaraimma minnâ aáwaqa íma wáiye. ánibo keráwáqtí túma minnâ íma unáákáqtôma wáiye. ");
INSERT INTO usa_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","keráwáqá numagóqtábámá túyánámmá ítama aónaaro. yemá yómmá yoréta ánáyumma íma kéubetaboata aáwaq-naupaqa íma mamá káikuyoe. yeqtí aáwaq-namma íma waéna máqte-qtataaqa maránô-namma íma wáimanibo Áánûqtuma aáwaqa kéyimiye. kéráwáqá aarawaamá numagómmá umaatamá uyátáraae. ");
INSERT INTO usa_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","keráwáqtí aúkáapike náawaq netuq-áúyánámmá iténama kanaaráq wení pááqya-kanaama mamá ayátáákakaa umá paá mániyo? ");
INSERT INTO usa_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","netuq-túyánámmá itéq keráwáqá móra pááqya-qtataariq íma ínómanibo nôraq itaráq keráwáqá yaímma-yataaqtabama netuq-túyánámmá kéitaao? ");
INSERT INTO usa_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","keráwáqá wírááti-yataaqa yópí wái-qtataakaq túyánámmá ítáaro. yemá mayaímá íma mayéta wáqtôma íma tarôq kéoe. miráimanibo kemá keráwáqá kétima-timune. keráwáqá kéitaae. naayóbáqá Tórómónima miráuma íráqô-qtataaqa taíbaq makáimanibo maami-kíráátí-yátáákáá umá íráqô-qtataaqa íma makáine. ");
INSERT INTO usa_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","wé íbêqa námá-karaa-qtataaqa yópí wáitata aabáyaama káráma irabí kágatuwaae. ánibo mirá-námá-káráá-qtátááqá minnâ Áánûqtuma yaqnammá kéyabiqyikaiye. miráinaq keráwáqá mikáq aónainoe. Áánûqtuma miráráá umá keráwákáráq yabítikaniye. keráwáqá keráwáqtí itáíq-itaiq umá mái-yataaqa pááqyamiye. ");
INSERT INTO usa_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","miráinaq keráwáqá ‘nóin-aawaraq nánúnataabi nói-nonaq nánúnataabiyo’ téqa netuq-túyánámmá íma ítáaro. ");
INSERT INTO usa_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","maa-márábímmá aamá íma itaí-wáyúkámá mi-máqté-qtátááqá mayaínôqtaba abáá kéoe. miráimanibo keqtibomá Áánûqtuma keráwáqá nóiqtataarabi mayánéq ommá wemá kéitaiye. ");
INSERT INTO usa_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","keráwáqtí túyánámmá Áánûqtuni aúyánákáq mórabi maréra kéitaiyana Áánûqtuma mirái-qtataaqa keráwáqá timíno. ");
INSERT INTO usa_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","ketí pááqya-tipi-tipi-anna-wayukao, ikatîqa íoro. keqtibomá Áánûqtuma wé keráwáqá yabíqtikanena kéiye. ");
INSERT INTO usa_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","keráwáqtí oótanaa máqte-qtataaqa waayúkaraq maráiyata meyáníq kéiyaq minnárake móneqa matéra áwáyoq-wayukama yíwáqnaa éra yíméro. ánibo móneq-unamma íma yararéna akoqnáá umá wái-unaqtaba abáá oro. ánibo Áánûqtunopaqa íráqô-qtataaqa íma aúyokena paá wáni-qtataaqa mamá keráwáqá áíkuyoro. ánibo Áánûqtunopaqa mórama moyá-káyúkámá waaqókáqá íma kanaaráq kéuyowana táí-wakoma íma máqte-qtataaqa namá táíqa kéumatuwaiye. ");
INSERT INTO usa_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","keráwáqtí íráqô-qtataaqo wái-marupaqa keráwáqtí tíyakogaraq mi-márúpáq wániye. ");
INSERT INTO usa_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","yokaa umá máero. keráwáqtí wáqtôma awaarakáq umá itéraq tímûrannama umá kárutera ómmá kúraqma yokaa umá máero. ");
INSERT INTO usa_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","keráwáqá miráuma yeqtí kawáá-nákómá aaramá íyáan-omaq-aawapaq kóuraitata mayaí-wáyúkámá awé urááwana yauwéqma iníkáá oro. ánibo mi-káwáá-nákómá oqtaráqá mamá pagé-page tínatama páátákáá oqtamá íyakanoe. ");
INSERT INTO usa_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","ánibo kawáá-nákómá wení mayaí-wáyúkámá ya yimónáinnama yúmá íwaguraiyana yimónáinnatama mi-máyáí-wáyúkámá yimuqá maránóe. kemá keráwáqá áraimma kétima-timune. mi-kánááráqá uyátárai-nakoma yeqtí kaqtó-nakoraa íniye. uyátárai-nakoma wenamáárîq wení wáqtôma awaarakáríq umá itokéna wení ámûrannama uréna wenamáárîq timáyikainata aáwaqa naí-yááréráq maraq máiyanama wenamáárîq aáwaqa márú-yiminiye. ");
INSERT INTO usa_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","uyátárai-nakoma nokáan-aukaamma iréna ya yimónáinnama mi-máyáí-wáyúkámá yokaa umá máqe-uretama yimuqá ôriq umá maránóe. ");
INSERT INTO usa_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","keráwáqá maa-qtátááqtábá túyánámmá ítama arútáaro. naakóní aboámá áqnáabaqa ‘moyá-káyúkámá yínóe’ téna kanaaráq íma iyuwáinata naammá yawítíyuweta uyáberanoe. ");
INSERT INTO usa_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","keráwákáráqá yokaa umá máero. keráwáqá túyánámmá itéq Waayúkagoni Áráaqa íma kumíniye tíya-kanaabi kumíniye.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","ánibo Pítaama maará-tiraiye: “uyátárai-nako, maami waéqma itaí-áímmá kenamáa ketááwáq kétima-time máqte-kayukayabagararabiyo?” téna Îtumma ítama aónaraiye. ");
INSERT INTO usa_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","anibo uyátárai-nakoma Îtu tiráiye: “náawaq aamá iténa akoqnáá umá yabíkái-kawaa-naqa máiyo? minnámo wemá wení mayaíráqá kawáá umá arútáraitana wení kawáá-nákómá mayaí-wáyúkáráq yabíqma máikae téna awaaméqá umákáitana wení kanaaráq aáwaqa kéyimiye. ");
INSERT INTO usa_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","anaaékaqa wení uyátárai-naqa yauwéqma yéna aónáinnama naayóbáqá timá ámikainaiqa wení mayaí-nákómá énama kanaaráq mi-máyáí-nákómá amuqá marániye. ");
INSERT INTO usa_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","kemá keráwáqá áraimma kétima-timune. wení anón-nakoma wení máqte-qtataakaqa min-nákómmá kawáá umákaniye. ");
INSERT INTO usa_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","miráinamanibo mi-máyáí-nákómá maará téna aúyánámmá áyáqnobaqa itániye. ‘ketí uyátárai-nakoma íma páátákáá yauwéqma yíniye.’ mirá-timatuwena mikáké áaimma átárena mayaí-wáyúkáwábi mayaí-nóínímmá tebûqa kéyimena anón-aawaqa kénena aíbôq-nomma naréna aíbôqnaaboq kéenama ");
INSERT INTO usa_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","mi-káwáá-nákómá wení anón-nakoqtabama íma awé éna neginaagí ínna-kanaabi anón-nakoma yauwéqma kumíniye. wení kawáá-nákómá timá ámíniq íma itanabóana anó-nakoma wemmá yawááq umákena karatábáyáá kutukáiye. ");
INSERT INTO usa_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","mórama mayaí-nákómá wení kawáá-nákóní áaimma aónatukenamanibo mi-máyáí-nákómá máqte-qtataaqa íma yokaa éna anó-nakoni aúyánámmá íma kéwaraipoana wení uyátárai-nakoma ôriq umá tebûqa kámena táíq umákaniye. ");
INSERT INTO usa_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","ááqibo mi-máyáí-nákómá wení anón-nakoni aúyánámmá íma iténa tínnaiq ínanama wení uyátárai-nakoma yaákarena tebûqa kámena táíq umákaniye. waayúkama taíbaq-yataaqo uyátárai-nakonopake matáiya-kayukama yemá keqnáámmá taíbaq-yataaqa yauwéqma amínoe. ánibo aarawaamá taíbaq-yataaqa uyátá-maqma anómma matétama kanaaráq uyátá-maqma anómma yauwéqma áméro. ");
INSERT INTO usa_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","kemá maa-márábí-káyúkábíké táí-yataaqa agamá kautónaq kukáunana min-írágómá áaimma ataíkáae téq kemá kétune. ");
INSERT INTO usa_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","kemá kímora-yataaqa keqtábá pááq ínimanibo minnáyaba ketíyakoma ôriq umá ummaa kéyaiye. ");
INSERT INTO usa_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","keqtábámá maa-márábí kaayoné-yátááqá mamé kukáiye kéteo? ímiye. kemá maa-márábí aarawaamá mamá yataénááq kukáune. ");
INSERT INTO usa_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","ánibo íbêkaraq anaaékakaraqa móra-tiyaapaq-wayukama móra-naupaqa máqe-iya-kayukama yaíkaaq umá ketíwîqtaba kaayaq-ánnáíq ínoe. kaumo-yúmá kaayaq-waígómmá namuroíq umáyikaiyata kaayaq-wáímá kaumo-yúmá namuroíq umáyikanoe. ");
INSERT INTO usa_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","yemá yaíkaaq umágéta aboámá áanikomma namuroíq umákainana áanikoma aboámmá namuroíq umákaniye. ánibo anóama ayáámûkomma namuroíq umákainana ayáámûkoma anóamma namuroíq umákaniye. ánibo móra-nakoni anóama min-nákóní ánáakomma namuroíq umákainana min-íníkómá awaaikómmá anóamma namuroíq umákaniye.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Îtuma aarawaayábágáráq maará téna timá yímikaiye: “keráwáqá abutá konnámmá utaitaq aónatuweq páátákáá keráwáqá maará kéte. ‘aaqá yínéna iyé’ tewanamá áraimma aaqá kéiye. ");
INSERT INTO usa_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","ánibo keráwáqá ítáawana anómma uwááma yóráitaq keráwáqá maará kéte. ‘íbêqa aaqá kániye’ tewana áraimma mirá-teniq kéiye. ");
INSERT INTO usa_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","keráwáqá túyánámmá íma wáiq-kayukae. maa-márábín-áwáámékáráq aabayákáq-áwáámékáráq aónama kárutaamanibo nôraq itaráq íbêqa maa-kánááráq-áwááméqá íma aónama kárutaao? ");
INSERT INTO usa_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","nôraq itaráq keráwáqá kenamáárîq túyánámmá ítama arutéq arupú-aaimma mamá kéyainaao? ");
INSERT INTO usa_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","móra-nakoma emmá aabi mayakéna aamá ítama yainánéna i-nákótêma yagaroqtamá urékama kanaaráq kenákámá aapaq kéweka aamá timá arútáakao. móraiq umá Áánûqtuma emmá aabi mayakéna aamá ítama yainánéna kéinaama páátákáá wetêma yagaroqtamá urékama aamá timá arútáakao. wemá emmá yabitimáena aamá ítama yainaí-wáyúkátí iyáápi mó-marainata aamá ítama yainaí-wáyúkámá i-wáyúkátí iyáápi mamá maráiyata i-wáyúkámá mamá ánná-naupaq tikaíyábámíye. ");
INSERT INTO usa_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","kemá keráwáqá kétima-timune. keráwáqá kanaaráq í-uraapoaq ánná-naupakemma íma páátákáámá paábaqa yáwinoe. ánná-naupaq máyana keráwáqtí kanaamá ánataniye.” téna Îtuma waéqma itaí-áípí yainaí-kánááyábá tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","mi-kánááráqá yaímma-wayukama máeta Îtumma timámeta yaímma Kááriri-wayukayaba Áánûqtukaq agamá amí-yátáárîq kéumakenama Pááíratima wení waayúkama yíkakaiye mirá téta tirááe. ");
INSERT INTO usa_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","ánibo Îtuma yauwéqma maará-tima-yimikaiye: “keráwáqá túyánámmá ítáamma maami-Káárírí-wáyúkámá káqo-Kaaririq-wayukama uyátá-maqma kúmiq-wayukaboata ummaa-yátááqá mái-waigoni áaine téraq keráwáqá kéteo? ");
INSERT INTO usa_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","áraimma kétima-timune. ímiye. ánibo keráwáqá tirummá ímo waeréqa keráwákáráq máqtemma móraiq umá puínóe. ");
INSERT INTO usa_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","naayóbáqá tiyááka umá abapaké kaumo-wáyúkámá Táéróabaqa ayáqtááq-nakoma yawítímena yíkamitata pukáama minnâ yeqtí otaa-qtátáákómá káqo-kayukama Yérútáárebaq máa-kayukati otaa-qtátááqá uyátáraiye téraq túyánámmá kéitaao? ");
INSERT INTO usa_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","kemá keráwáqa kétima-timune. áraimma ímiye. ánibo keráwáqá tirummá ímo waeréqá keráwákáráq móraiq umá miráuma pukínóe.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Îtuma móra waéqma itaí-áímmá maará téna tiráiye: “móra-nakoma wení yópí píki-yama uqmakéna anaaékaqa arammá kutínéna iráimanibo mórama arammá íma itáitana aónaraiye. ");
INSERT INTO usa_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","miráitana min-nákómá maará téna mayaí-nákómmá timá ámikaiye. ‘itaao. kaumo-áúqá yáwitaq maami-píkí-yágóní arammá kutónáae téq yúnnamanibo arammá íma itáiye. miráinaa emá ayáatuwaao. paáyaba maragóní anommá namá kánataiye.’ tínana ");
INSERT INTO usa_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","ánibo mi-tókáq-máyáí-nákómá wení anón-nakomma maará téna timá ámikaiye. ‘umaataráána-nako, íbêqa maan-áúqá yúwénana matáainaao. áaipikemma maramá agáúme kéyauteq purumaakaakóní ayámá abákáma agamoqá má kumaránúne. ");
INSERT INTO usa_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","yanaapáq-áúqá arammá iyánímanibo arammá ímo iyáinaama ayáatuwanone.’” téna mi-máyáí-nákómá tiráiye. téna Îtuma waéqma itaí-áípí tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Tabaatiráqá mórama yirááti-naupaq Îtuma aarawaamá watáama timá yímikaiye. ");
INSERT INTO usa_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","ánibo móra-inimma máqe-uraimma wepímmá waátáma min-íníkóní arunóbáq máena karíma ámikaimma tiyááka umá abapaké kaumo-áúqá máqe-uraiye. miráitana min-íníkóní arótááukoma yawékuraitana itó-uma arupú íowaniq uráiye. ");
INSERT INTO usa_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Îtuma min-ínímmá aónatuwena ááyamae iréna maará-tima-amikaiye: “aaragô, kemá ení karímá mamá paá umákaune.” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","ánibo min-íníkómmá Îtumma kaayaq-áyáánápó wemmá ánekuitana páátákáá min-íníkómá itó-uma arupú umáguraiye. miráitana min-íníkómá Áánûqtun-awiqa múte yaútaiye. ");
INSERT INTO usa_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Tabaatiráq Îtuma karí-ínímmá mamá atóbamakaiqtaba monoq-náúpáq-káwáá-nákómá Îtumma áyamma umákaraiye. miráitana kawáá-nákómá maará téna aarawaamá timá yímikaiye: “abapaké móra-kanaama mayaí mayánô-kanaama wáiye. ánibo móra-nakoqtaba karímá mamá paá íkáae téqa keráwáqá kanaaráq mayaí-kánáábí yero. mi-qtátááqtábámá Tabaatiráqá íma yero.” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","ánibo Îtuma yauwéqma min-nákómmá maará téna timá ámikaiye: “keráwáqá túyánámmá íma wái-kayukae. Tabaatiráqá keráwáqá maará-máyáímá kémayae. keráwáqtí purumaakaakóní naaúpaq uréq purumakaanábi oótiraa-kamma nommá naígáae téq yiwíqme kéoe. ");
INSERT INTO usa_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","17","miráimanibo maan-ínímmá Áabaraan-annabiken-inimiye. Tááqtaama tiyááka umá abapaké kaumo-kárítímáátímá ánná umákáitana máqe-uraine. miráinaq Tabaatiráqá ánnámo kúyakaraamma kemá ayúbakanune.” téna Îtuma tiráiye. Îtuma mirá-timatuwaitata wení namuro-wáyúkámá yigaeyábá urááe. ánibo máqte-kayukama Îtuma íráqôniq i-qtátááqtábá yimuqá makááe. ");
INSERT INTO usa_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Îtuma ókaraq maará-tiraiye: “Áánûqtuma yabíkái-qtataaqa nói-qtataakaanaq umá wáiyo? kemá minnáyabama nóikaraq awaaméqá umá ténúnô? ");
INSERT INTO usa_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","wemá miráuma pááqyan-anayukaa (máqtaqti) uráiye. móra-nakoma min-ánáyúmmá maténa wení yópí uqmakáiye. ánibo anaaékaqa anómma auréna yaaráá uráitana numagómá amataqá máqe-uraae.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","ókaraq Îtuma maará-tiraiye: “Áánûqtuma yabíkái-qtataaqtabama kemá nói-qtataakaraq maqmá ténúnô? ");
INSERT INTO usa_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","wemá miráuma anómma auraí-yátááré. móra-inikoma mi anómma auraí-yátááqá (yíqtima) maténa anó-taapepi makéna yammá tarôq í-kánágáráq makéna waékáiye. ánibo anaaékaqa mi-kánágómá máqtepaq itóqma anómma aúkáiye.” téna Áánûqtuma yabíkái-qtataakoma miráuma pááqya-kayukarake áaimma átárena anaaékaqa taíbaq-wayukama yiwirániye. Îtuma téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Îtuma yaímma anó-maruparaa pááqya-marupaqa uréire uráiye. wemá aarawaamá kéyiraatena watáama timá yímíqmena Yérútáárebaq wíné uráiye. ");
INSERT INTO usa_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","ánibo móra-nakoma Îtumma maará-tima-amikaiye: “umaataráána-nako, Áánûqtuma keqtáá máqtemma yauwéqma íyaq tiwiráníyô?” téna tiráiye. miráimanibo Îtuma maará téna timá yímikaiye: ");
INSERT INTO usa_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“ímiye. keráwáqá tiyáátámma kuyéqa pááqyan-oqtabi ko péráaro. kemá keráwáqá kétima-timune. taíbaq-wayukama pááqyan-oqtabimma uyáberanomanibo ímiye. yemá kanaaráq íuraae. ");
INSERT INTO usa_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","anaaékaqa naakóní aboámá itó éna oqtamá umá aúyatuwaniye. ánibo keráwáqá máápaq ya itó-uma máeq oqtaráq kéikameq maará téq ááyama tínoe: “umaataráána-nako, emá keqtáá oqtamá ítikaao.” tíyana wemá yauwéqma keráwáqá maará timá-timiniye: “keráwáqá náakakenaq irááô kemá minnâ íaonaraune.” téna tíniye. ");
INSERT INTO usa_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","ánibo keráwáqá maará timá áminoe: “ketáámá etê anón-aawaqa nétaa nommá nétaa kéunaataa emá ketááí aapi itó-uma máe keqtáá tiráátéwaonamiye.” téq tínoe. ");
INSERT INTO usa_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","miráinana naakóní aanábó-nákómá maará tíniye: “keráwáqá náakake-kayukawaq mááo minnâ kemá keráwáqá íma timónaraune. otaa-káyúkámá máabo nékaq máero.” téna tíniye. ");
INSERT INTO usa_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","keráwáqá aónáíyata Áabaraama Ááítekima Yáakoboma máqtemma amuné-wáyúkámá Áánûqtuma yabíkái-marupaq máinomanibo keráwáqá kenamáárîq máápaq mánoe. mibáq máeq anómma ibiqá yaraíyana tíwáyaakake kóqá iyániye. ");
INSERT INTO usa_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","taíbaq aarawaamá aabaú utaipáké íyata aabaú kupéráipake uyéta íya-kayukagaraq téba-tebaq-aukapake íya-kayukagaraq Áánûqtuma yabíkái-marupaq umáeta aáwaqa naínoe. ");
INSERT INTO usa_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","ánibo yaímma-wayukama íbêqa írêqa kéye-kayukama maa-márábí pááqyan-iwiqa wáipoata áqnáabaq wínoe. ánibo íbêqa yaímma-wayukama áqnáabaqo kéo-kayukama maa-márábí anón-iwiqa wáipoata írêqa yínoe.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","é mi-kánáábí yaímma Pérati-wayukama iréta Îtumma maará-tima-amikaae: “emá maa-márúqá yuwé káqon-aukapaq kóaao. Érôtima emmá ikámma puínéna kéiye.” téta tirááe. ");
INSERT INTO usa_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","ánibo Îtuma yemmá maará timá yímikaiye: “keráwáqá uréraq Érôtima min-ábááq-íyákómmá maará mó-tima-amero. ‘itaao. íbêkaraq aabáyaagaraq kemá táí-aagomma matuwéq kemá karí-wáyúkámá mamá atóbamayikanune. anaaékaq kaumo-kánááráq ketí mayaímá mamá ánatanune.’ ");
INSERT INTO usa_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","íbêrabi aabáyaagaraq ayukágaraq Érôtini márûpakemma kemá yuwéq kónaa kéune. yemá óq-marupaqa Áánûqtuni amuné-wáyúkámá íma yíkamma puyónáae kéte. ímiye. yemá paá Yérútáárebaq-wayukama aatuma amuné-wáyúkámá yíkamma puyónáae kéte.” téna yemmá íyóqa atáiye. ");
INSERT INTO usa_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Îtuma ókaraq timá yímikaiye: “Yérútááre-wayukaao, Yérútááre-wayukaao, keráwáqá Áánûqtuni amuné-wáyúkámá yíkamma kébuyeq Áánûqtuma keráwáqtôpaq timáyíkáitata ye-káyúkátí yímûraapaq óqtatamma kéiyaabotuwaae. taíbaq-kanaama kemá keráwáqá áíqma miráuma kokóregoma áráaqa áíqma aayan aménáápáq ákáinikaa umá keráwáqá áíqma tikánáae téq kétunamanibo minnáyabama keráwáqá íma kétikaiye. ");
INSERT INTO usa_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","miráitana Áánûqtuma keráwáqtí waaqókákémá tiyúkaiye. kemá keráwáqá kétima-timune. kemmá ókaraq ítimonaiya-kanaaraqa maará tínoe. ‘maan-náqá uyátárai-nakoni náápaakaraq i-náqá kéiye. Áánûqtuo, íráqôniq umákaao.’” tínoe téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","móra-Tabaatiraqa Pérati-wayukati anón-nakote Îtuma aáwaqa ko-man naráiye. ánibo yemá Îtumma kawáá-umatuweta máqe-uraae. ");
INSERT INTO usa_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","móra-naqo áíyayaamma itórái-naqa Îtun-amakaq iráiye. ");
INSERT INTO usa_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Îtuma min-náqá ónawaaena ámáan-aimma yirááti-wayukagaraq Pérati-wayukagaraq maará téna ítama aónaraiye: “ámáan-aikoma téna Tabaatiráqá karí-wáyúkámá mamá atóbamayikanunataabi íyabiyo?” téna ítama aónaraiye. ");
INSERT INTO usa_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","miráitata yemá ókaraq aamá ítiraae. miráitana Îtuma min-náqá mamá atóbamakatuwena timákáitana kóuraiye. ");
INSERT INTO usa_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","ánibo Îtuma yemmá maará-tima-yimikaiye: “keráwáqtí aúkáapike móra-nakoni iyápógowabi purumaakaakómá maiq-nópímá kuturáinanama Tabaatiráqo íyaq múte atínakaniyo?” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","yemá min-áíkáqá kanaaráq yauwéqma ítiraae. ");
INSERT INTO usa_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Îtuma yimónaimma anón-aawakaq ye-káyúkámá kateko-ábíqtátáráq máiyaba urááe. miráitana Îtuma móra waéqma itaí-áímmá timá-yimena maará-tiráiye: ");
INSERT INTO usa_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“móra-nakoma aaramá iyaí-ómáq-ááwákáq ááyainaa wina-nákómá kateko-ábíqtátáráqá íma maraqá mááo. minnámo ááyai-nakoma enáwîqa uyátá-maqma anón-awiqa wáinna-nakomma kateko-ábíqtátáráqá akáné ínayaba enókáá kateko-ábíqtátáráqá mánone. ");
INSERT INTO usa_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","ánibo enókáá kateko-ábíqtátáráqô márenana minnámo ááyaina-nakoma maará téna ‘emá maa-kátékó-ábíqtátámá maan-nákómmá ámínana wemá maíno’ tíniye. ánibo mikáq emmá anómma agae-yátááqá pááq ínaa emá agaeyábá umátuwe áwánobaq yinaaépaq kumánone. ");
INSERT INTO usa_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","miráinana móra-nakoma aaramá iyaí-ómáq-ááwákáq ááyainaa kéwema áwánobaq yinaaépaq ko maraq mááo. emá miráinanama minnámo ááyaitaa yénna-nakoma aónawaaena maará téna má-tima-aminiye. ‘ketí aanábógô, emá maakáq uyátá-maqma íráqôn-abiqtataraq ummááo.’ tíniye. mirá tínaama máqte-kayukama etê máeta aáwaqa naíya-kayukati yúrakaq ení anón-awiqa uwíniye. ");
INSERT INTO usa_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","taákaq máráaro. móra-nakoma wení áwîqa mamé uwína-nakoma Áánûqtuma wenáwîqa márûte yuwániye. ánibo móra-nakoma wenáwîqa márûte yuwaína-nakoma Áánûqtuma wenáwîqa múte yaúma méyákáq akániye.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","ánibo min-nákómá aaramá iyaí-ómáq-ááwákáqô ááyaitana i-nákómmá Îtuma maará timá ámikaiye: “emá móra-aawaqo mamá yokaa kéema ení aanábó-wáyúkáwábi enábâqawaanabi ení móra-annawabi ení móra-marukaq-wayukama taíbaq-moneqa makáiya-kayukama íma yááyama aáwaqa yimiyo. miráinata emmá ááyaiya yeqtí naaú winata ení aáwakaq anónnáma yauwéqma amíyábáé. ");
INSERT INTO usa_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","ímo miráinaama emá anón-aawaqo yokaa kéema kanaaráq áwáyoq-wayukama yúgoma táíq uráínna-wayukawabi yítauqa táíq uráiya-kayukawabi yúgaroq-wayukama yááyama aáwaqa yimiyo. ");
INSERT INTO usa_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","yemá mirá-káyúkámá ení aáwakoni anónnáma íma kanaaráq yauwéqma amínoe. anaaékaqa arupú-wayukama pukáapike itó íya-kanaaraqa Áánûqtuma ení aáwakoni anónnáma yauwéqma amíniye.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","mi-káyúkátí aúkáapike móra-nakoma Îtute máena aáwaqa némái-nakoma min-áímmá ítátuwena Îtumma maará-tima-amikaiye: “yemá Áánûqtuma yabíkái-marupaq máeta aáwaqa naínô-kayukama yimuqá ôriq umá kémaraae.” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","miráitana Îtuma min-nákómmá maará téna timá ámikaiye: “móra-nakoma anón-aawaqa mamá yokaa ínéna uráiye. ánibo wemá taíbaq-wayukama min-ááwákáq yígáae téna yááyaraiye. ");
INSERT INTO usa_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","aáwaqa naí-kánáámá pááq itana naayóbáqô yááyarai-kayukama wení mayaí-wáyúkámá titata ko yááyaraae. min-nákómá maará téna timá yímikaiye: “keráwáqá yero. máqte-qtataaqa yokaa umáguraiye.” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","miráitata máqte-kayukamo yááyai-kayukama itó-uma ánáteta móra-morama ‘ítaa ónúne’ tirááe. móra-nakoma maará-tima-amikaiye. ‘kemá móra-yomma meyánîq umátukaunaboaq mi-tómmá ko aónanune. timuqá marakáunaboaq ení aáwakaq íonune.’ tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","ánibo káqo-nakoma maará-tima-amikaiye. ‘kemá tiyááka-purumakaamma meyánîq umákaunaboaq kemá ko maqmá aónanune. kemá timuqá marakáunaboaq íonune.’ tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","ánibo káqo-nakoma maará-tiraiye. ‘kemá íbêq aaramá matáune. miráipoaq kemá kanaaráq íonune.’ tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","miráitana mikáké mi-máyáí-nákómá yauwéqma uréna wení anón-nakomma máqte-qtataaqtabama mó-tima-amikaiye. ánibo naaúpaq anón-nakoma áyámma umátuwena wení mayaí-nákómmá maará-tima-amikaiye. ‘emá uré maa-márúkóní anón-aparabi pááqyan-apaqa uréire kée áwáyoq-wayukama yúma táíq uráinna-wayukama yúramma karopágurainna-wayukama yítaukarerema uráá-kayukagaraq máqtemma yiwíqme ketí naaúpaqa iyo.’ téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","anaaékaqa mi-máyáí-nákóma maará-tiráiye. ‘uyátárai-nako, kemá enáama waréq máqte-kayukama yiwíqme iráunamanibo yaímma-abiqtatama paá wáiye.’ téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","ánibo anó-nakoma wení mayaí-nákómmá maará-tima-amikaiye. ‘emá máqtemma anónapaq uré yókóní kuruwánapakaraq uré yópímá máiya-kayukama aapaqô uréire kéiya-kayukagaraq yabitimáe iyo. ketí naakómá ógiraikaae. ");
INSERT INTO usa_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","kemá emmá kétima-amune. kemá máqte-kayukamo yááyarauna-wayukama ketí naaúkemma aáwaqa íma nánóe.’ téna tíniye.” téna Îtuma maami waéqma itaí-áípí tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","taíbaq aarawaamá Îtun anaaé waqmé kéowana Îtuma ko waeréna maará-tima-yimikaiye: ");
INSERT INTO usa_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“móra-nakoma ketôpaq yínénama aboámmá anóamma ánáakomma wení aánikoma ábâkomma ámánaakomma kemmá uyátá-maqma yeráwáqtábá akáinanama wemá kanaaráq ketí iyápó-annabi íma mániye. ");
INSERT INTO usa_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","náawabi wení kaapaq-yámá maména tinaaé íwaraina-nakoma wemá ketí iyápó-annabi kanaaráq íma mániye. ");
INSERT INTO usa_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","nôraq íyô? keráwáqtí aúkáapike móra-nakoma mórama ayáqtááq-namma umáe yanaa uwínénama kanaaráq min-nákómá áqnáabaqa máena min-námmô íní-waigoni meyáqtábá aúyánámmá kéitaiye. wemá min-nákómá ‘kanaaráq tíwáqnaa ínaq maamin-námmá umá ánatanune’ téna aúyánámmá kéitaiyo? ");
INSERT INTO usa_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","ánibo min-nákómá áqnáabaq aúyánámmá ímo ítama aruténama anaaékaqa paá yaímma tarôq umárena min-námmá íma páátákáá umá ánatanena iné. ánibo máqte-kayukama min-námmô káonetama akáyáámmá timákaneta oné. ");
INSERT INTO usa_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","yemá maará-tinoe. ‘maan-nákómá naammá ínéna áaimma átámaraimanibo páátákáá í umá kánataiye.’ tínóe. ");
INSERT INTO usa_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","ítáaro. móra-kinima káqo-kinite ááiqa mó-inenamanibo áqnáabaq-yataaqa máena aúyánámmá ítama kárutaiye. mi-kínímá wení ááiq-i-wayukama (10,000) yíkáitana ánibo káqo-kinima wení ááiq-i-wayukagaraq (20,000) yagaroqtamá yiwíqme iráiye. miráitana áqnáabaq-yataaqa mi-kínímá aúyánámmá ítaraiye. uyátá-maqma taíbaq-aaiq-i-wayukagaraq yiwíqmena i-kínímmá ikámma watuwání íyabiyo? ");
INSERT INTO usa_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","wemá yeráwátê kanaaráq ááiqa íma owánîq urénama wení namuro-wáyúkámá nékaq máraiyaqtaba yaímma-wayukama timáyikainata uréta yááyama watáama timá móraraq maréta ááiqa mamá kaayoné ínóe. ");
INSERT INTO usa_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","móraiq umá keráwáqtí aúkáapike móra-nakoma wení máqte-qtataakomma anaaémma í umámenama kanaaráq wemá íma ketí iyápó-annabi mániye. ");
INSERT INTO usa_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","úmá íráqô-qtataare. miráimanibo úmá ímo kaínataama náaraq onanatááwáq átêma íníyô? ");
INSERT INTO usa_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","mirán-úmá maragómmá íma íráqôniq umákanipoata yópímmá agamoq-yátáákáráq íma kémaraae. yemá paábaqtaa kéyuwaae. aamá itaí taáqa wáinaqa aamá ítáaro.” téna Îtuma tiráiye. úgómá átê iníkáá umá keráwáqá karuwaaq umá máero. ");
INSERT INTO usa_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","táákiti-moneqa máyáa-kayukagaraq kúmiq-wayukagaraq Îtuni amakaq iréta watáama timmá ítaraae. ");
INSERT INTO usa_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","ánibo Pérati-wayukagaraq ámáan-aimma yirááti-wayukagaraq náru-narun-aimma téta maará-tiraae: “maan-nákómá kúmiq-wayukate yagaroqtamá aanábóîq umá uréire kéena yetê aáwaqa kénaiye.” téta tirááe. ");
INSERT INTO usa_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","miráitana Îtuma maará téna waéqma itaí-áímmá timá yímikaiye: ");
INSERT INTO usa_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“keráwáqtí aúkáapike móra-nakoma taíbaq tipi-típima (100) ákárainabike kímora-tipi-tipima aúyokinanama kanaaráq tipi-típigomma aboámá máqtepaq iyuwáinata móra-aukapaq máeta kénaiyana minnámo kímorama aúyoki-waigoqtabama abáá íniye. ánibo min-nákómá abáá éqéna awirániye. ");
INSERT INTO usa_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","ánibo mi-típí-típímá awirénama kanaaráq múte áíqtaabi ákátuwena awíqme kóiniye. ");
INSERT INTO usa_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","naaópaq awíqme wénama wení aanábó-wáyúkámá kéyaayena wení móra-marukaq-wayukagaraq yááyainata yama áíkuinoe, ánibo wemá maará-tima-yiminiye. ‘keráwáqá ketê timuqá máráaro. ketí móra-tipi-tipima aúyokuraitaq abáá éqé awiráune.’ téna mirá-tiniye. ");
INSERT INTO usa_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","kemá Îtuma keráwáqá kétima-timune. móraiq umá Áánûqtuni márûpaqa taíbaq arupú uráá-kayukama yirukómá íráqôniq umáguraitababoata ókaraq íma yirummá waeránômanibo kímora-nakoma kúmiqnapoana arummá waeraínatama Áánûqtuni márûpaq weqtábá anón-amuq-yataaqa mamá pááq íniye. ");
INSERT INTO usa_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","móra-inikoma móneqa tiyáákama makáinabike kímorama aúyokurainanama min-íníkómá wení naaúpaq ómmá kúraqme uténa araatámma kuyútukena aónama arútatuwena abáá éqéna mayániye. ");
INSERT INTO usa_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","min-íníkómá mi-mónéqá maménama kanaaráq wení aanábó-wáyúkágáráq wení móra-naoq-wayukagaraq yááyainata ya áíkuinoe. ánibo maará-tima-yiminiye. ‘keráwáqá kegáráq timuqá maráiyataao. mórama ketí móneqa aúyokuraimanibo kemá abáá éqé mayaúne.’ téna tíniye. ");
INSERT INTO usa_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","kemá Îtuma keráwáqá kétima-timune. mórama kúmiq-nakoma arummá waéráitatama móraiq umá Áánûqtuni kaqtó-wayukama yimuqá maránóe.” téna Îtuma waéqma itaí-áípí tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Îtuma Ítíráaeo-wayukama náru-narun-aimma te-káyúkáyábá maará-tiraiye: “móra-nakoma kaayaqá inaamaí-íyápórátá yíkaraiye. ");
INSERT INTO usa_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","ánibo maqné-íyápógómá aboáqtábá maará-tiraiye. ‘ketiboó, emá móneqa yaíkaaq umá kekárátámá timiyo. kanaaráq kemá mayánúna-yataakomma yaímma kemmá timiyo.’ tiráiye. ánibo aboámá wení máqte-qtataaqa yaíkaaq umá yímikaiye. ");
INSERT INTO usa_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","ayáqtáá kanaama íma kóuraitana maqné-íyápógómá wení máqte-qtataaqa yokaa kéipike mórama ayáqtááq-marupaq ko máqe-uraiye. wemá mi-márúpáqá ko máena aweké-ááímmá tarôq éna wení móneqa yuqmá áyóki umátukaiye. ");
INSERT INTO usa_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","miráitana min-íyápógómá wení máqte-qtataaqa yuqmá ánatatuwaitana anaaékaqa áama yaí-yátááqá mi-márábímmá pááq uráiye. ánibo min-iyápógómá móra-yataaqa íma makáiye. ");
INSERT INTO usa_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","miráitana mórama maa-márábí-nákókáq mayaímá ko matáiye. ánibo min-nákómá min-íyápómá timákáitana wení pó-kawaa umátuwe máqe-uraiye. ");
INSERT INTO usa_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","aáwaraa máqte-qtataaqa íma ámikaiye. máqtemma pó-annama aáwakoni átima kénaawana min-íyápógómá min-ááwákóní átima nánáae téna aúyánámmá ítaraiye. ");
INSERT INTO usa_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","miráitana mikáq mi-mábúgóní aúyánákómá tágaitana maará-tiraiye. ‘ketiboní máqtemma mayaí-wáyúkámá taíbaq-aawaqa áyóki uráitata kénaae. miráitaq kemá maakáqá máeq táayabama kéune. ");
INSERT INTO usa_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","ibáqyuwaao. kemá ketibonôpaq kónune. ánibo kemá uréq ketibommá maará téq mó-tima-amenune. ketiboó, kemá Áánûqtun aúrakaraqa enaúrakakaraqa kúmiq-yataariq uráune. ");
INSERT INTO usa_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","íbêqa kemá íma íráqô-naqa máunaboa emá keqtábá ketí iyápóe íma tínóne. emá kemmá miráuma móra-mayai-nakaa umátikaao.’ ténúne téna mi-mábúgómá tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","ánibo wemá itó-uma aboánôpaq uráiye. miráitana mi-mábúgómá nékaq kéwiqtaba aboámá aónaraiye. ánibo aboání áyakoma arummá ôriq umáitana aboámá uyaaté uréna áanikomma ko áyábaa uréna ámóqnaraiye. ");
INSERT INTO usa_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","ánibo áanikoma maará téna aboámmá timá ámikaiye. ‘ketiboó, kemá Áánûqtuni aúrakakaraq enaúrakakaraqa kúmiq-yataariq uráune. kemá íma íráqô-naqa máunaboa emá kanaaráq ketí iyápóe ítinone.’ tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","aboámá wení mayaí-wáyúkámá maará timá yímikaiye. ‘keráwáqá uréraq ketí kateko-áyáqtááq-wáqtómá páátákáá mamé má kéiyakeraq ayáápikaraqa waatammá umákáaro. ánibo aítauq-anaakaraq mamé má-umakaaro. ");
INSERT INTO usa_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","keráwáqá naatéq-púrúmákáámmá ikáme íyataa aáwaqa agamá kénetaa timuqá marakánúnatae. ");
INSERT INTO usa_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","ketáanimma pukuráimanibo íbêqa keqnáámmá aúwaraiye. wemá aúyokuraimanibo ketáámá yauwéqma awiráunatae.’ tiráiye. ánibo mikáké áaimma átáma yimuqá makááe. ");
INSERT INTO usa_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","ááqibo áqnáaen-iyapogoma yópáq máqe-uraiye. anaaékaqa yauwéqma naaópaq min-áqnááén-íyápógómá naamátûpaq kéyena ítáimma kaapaúmma kéteta imá yarááe. ");
INSERT INTO usa_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","ánibo wemá móra-mayai-naqa ááyarena naaúpaqa nôraq kéo?’ téna ítama aónaraiye. ");
INSERT INTO usa_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","mayaí-nákómá maará téna timá ámikaiye. ‘enábâkoma yauwéqma iráitana enabomá móra naatéq-púrúmákáámmá ikákaiye. wemá wení áanikomma yauwéqma awíkaimma paá íráqôniq umá máitana awíkaiye.’ téna timá ámikaiye. ");
INSERT INTO usa_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","miráimanibo áqnáaen-iyapogoma áyamma umágitana naaúpaqa íutaibo máápaq máqe-uraiye. aboámá máápaq kumá yaúbarena íráqôn-aimma timá ámikaiye. ");
INSERT INTO usa_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","miráitana aboámmá maará téna timá ámikaiye. ‘taíbaq-karitimaatima ení mayaímá miráuma mayaí-nákóráá umá paá-mayaima kémayaune. móra-kanaabima ení ámáan-aimma íma káratune. miráita emá paá pááqyan-omaqa íma timénaq ketí aanábó-wáyúkáte timuráamuq íkémaraune. ímiye. ");
INSERT INTO usa_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","miráimanibo enáanikoma ení máqte-qtataaqa kumari-nóínítí yúraq yuqmá ánataraiye. ánibo wemá miráumatuwena yauwéqma itaa weqtábá aúyánámmá ité naatéq-púrúmákáámmá ikamóne.” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","aboámá maará téna yauwéqma timá ámikaiye. ‘ketáaniko, aati-aatimá etê kerátámá móraraq kémauye. ánibo ketí máqte-qtataaqa minnâ ennámiye. ");
INSERT INTO usa_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","íbêqa kerátámá tíyakoma íráqôni kéinaka timuqá maráyáae. enábâkoma pukuráimanibo yauwéqma paá máiye. aúyokuraimanibo íbêqa ketáámá wemmá aónaraunatae.’ téna aboáma tiráiye.” téna waéqma itaí-áípí Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Îtuma wení iyápó-annama maará téna timá yímikaiye: “mórama móneqa ôriq umá makái-nakoma wení kawáá-náqá ákaraiye. ánibo yaímma-wayukama móneqa ôriq umá makái-nakokaq iréta kawáá-nákóqtábá kaaqaari-áúbí maréta maará téta makákáae. ‘ení mayaíráq-káwáá-nákómá máqte-qtataaqa mamá móramara umátúwáiye.’ tirááe. ");
INSERT INTO usa_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","ánibo min-nákómá mayaíráq-káwáá-náqá ááyaitana mikáq itana maará-tima-amikaiye. ‘enáama itaúnama náaraq uráánô? emá ketí máqte-qtataaqa enayáápimo wái-qtataaqtabama wannaabí agamé má-timiyo. emá ókaraq íma kawáá-náqá mánone.’ tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","mi-káwáá-nákómá áyáqnobaqa maará téna aúyánámmá ítama tiráiye. ‘kemá náaraq ónúnô? ketí anón-nakoma kawáá-máyáírákémá íbêqa watuwánéna iyé. ketí akoqnááma íma wáipoaq kanaaráq yómmá íma yoránúne. káqo-kayukayaba aáwaqa tíméro téq inaa tennamá tigae íniye. ");
INSERT INTO usa_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","miráimanibo kemá móra-yataaqtaba túyánámmá itáunaboaq mi-qtátááríqo onatamá ketí anón-nakoma kawáá-máyáírákémá waqtuwáinatama waayúkama mamá aanábóîq onatamá yemá tiwíqmeta yeqtí naaúpaq wínóe.’ tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","mi-káwáá-nákómá móra-mora-mayai-wayukama anón-nakoma anónnáma yímíkai-kayukama yááyaitata irááe. móra-nakoma áqnáabaq itana kawáá-nákómá ítama aónaraiye. ‘epímmá ketí anón-nakoni anónnáma náaraq umáq wáiyo?’ téna ítama aónaraiye. ");
INSERT INTO usa_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","ánibo min-nákómá tiráiye. ‘tiyááka-tiyaakae (100).’ tiráiye. ánibo kawáá-nákómá maará-tima-amikaiye. ‘emá maa-kánnáámá maté ení atábááyabama páátákáá maraq máe paá móra-tiyaapaq-tiyaakama (50) agayaao.’ tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","anaaékaqa móra-naqa itana kawáá-nákómá ítama aónaraiye. ‘ení atábááma náaraq umáwabiyo?’ téna ítama aónaraiye. ánibo min-nákómá téna miráuma tiyááka-tiyaakama (100) matáune.’ tiráiye. ánibo kawáá-nákómá maará-tima-amikaiye. ‘emá ení anónnáma maa-kánnáámá maté abapaké kaumo-tíyáákámá (80) agayaao.’ tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","mi-táí-káwáá-nákómá wenamáárîq wenáúgoma áwáqnaa uréna wení anón-nakoma áwîqa múte yaútaiye. miráuma aamá ítarai-nakoraama uréna wení anón-naqa makákáiye. maa-márábí-káyúkámá yeíyáá maamirá-káyúkátê mayaímá kémayeta mirán-ááímmá komarumá éta Áánûqtuni waayúkama ópí uréire o-káyúkámá kéuyataae. ");
INSERT INTO usa_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","kemá Îtuma keráwáqá kétima-timune. keráwáqá maa-márábí-mónéqnápó áwáyoq-wayukama yiméraq mamá aanábóîq oro. ánibo anaaékaqa móneqa mayaí-kánáámá ánatainanama keráwáqá Áánûqtuma tiwíqmena aati-aatimá matúq-matuq í-márúkáq mú-tikaniye. ");
INSERT INTO usa_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","ánibo móra-nakoma pááqya-qtataaqa kawáá umá arútái-nakoma kanaaráq anó-qtataakaraq yabíqma kárutaiye. ");
INSERT INTO usa_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","maa-marábí-mónéqá íma yabíqma arutáiyanama náawaq kanaaráq umá Áánûtuni óq-yataaqa kawáá ínô? ");
INSERT INTO usa_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","ánibo emá káqowani minnáma íma yabíqma arúténanama náawaq emmá ennámá amíníyô? ");
INSERT INTO usa_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","móra-mayai-nakoma kaayaq-káwáánákáq mayaímá íma kanaaráq mayániye. ánibo móra-nakomma ítama táíq kéumakena káqomma ítama íráqôniq umákaniye. kaayaq-káwáánákáq itáíq-itaiq umá íma kanaaráq mánoe.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Pérati-wayukama móneqtabama ôriq umá kéyikaitataboata Îtumma aábê-aimma timá ákaraae. ");
INSERT INTO usa_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","ánibo Îtuma maará-tima-yimikaiye: “keráwáqá waabá-káyúkátí yúrakaqa kateko-ááímmá tarôq kéiyata yemá keráwáqtí tíwîqa mamé uíkáae kétemanibo Áánûtuma keráwáqtí tíyaqnobaqa káonaiye. mi-qtátááqá waayúkati yúrakaq anó-qtataaqa wáimanibo Áánûqtuni aúrakaqa paátataakaa kéiye. ");
INSERT INTO usa_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Áánûqtuma naayóbáqá Áabaraamma timá ámikaiye. wení aráábitima netuqyaamá abarokáq umá mánoe. titata minnáyaba aati-aatimá yeráwáqá naí-wámmá Áánûqtukaq ámikaataba Mótetigaraq Áánûqtuni amuné-wáyúkágáráq agatááe. Áánûqtuma wení aúyánápímmá minnâ Yóáaneni kanááyábá wáqe-uraiye. ánibo Yóáaneni kanaaráké yéqéna íbêqa átê-wataagoma Áánûqtuma yabíkái-qtataaqtaba máqte-marabaqa wéyáwé uráitata máqte-kayukama kéyikaitataboata mayánéta inaamu kéguyoe. ");
INSERT INTO usa_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","ítáaro. aabayákáráq maa-márágáráq ánatani-waigoma ummaamá kéyaimanibo mórama ámáan-aikoni pááqyan-aqtoma ánatani-waigoma ummaa uyátá-maqma kéyaiye. ");
INSERT INTO usa_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","máqte-kayukama yínáaqa kéyuweta káqon-inimmo kémayaamma yemá aaraukáqá mamá kéyataae. móra-nakoma naayóbáqá awaikómá ayúkain-inimma máyái-nakoma aaraukáq-ámáámmá mamá kéyawaaqiye. ");
INSERT INTO usa_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","naayóbáqá mórama móneqa ôriq umá makái-naqa máena aati-aatimá kateko-únákáqtómá kúbekena anó-moneq-awiqa yaan-únákáqtô áátuma umátokaiye. ánibo aati-aatimá kateko-ááwáq áátuma mamé má-naraiye. ");
INSERT INTO usa_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","ánibo min-nákóní oqtaráqá naakóní waaqókáq mórama áwáyoq-naqa máqe-uraimma min-nákóní áwîqa Aráátaratie. min-nákóní áúraqa náomma kerémmá karái-nare. ");
INSERT INTO usa_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","min-áwáyóq-nákómá oqtaráqá máqe-uraimma móneqa ôriq umá makái-nakoni yaaregóní aménáápáq aqtó-ááwáqá kuqtínama áíqma namá tímûtanaae téna éwaine. ánibo iyákómá iréna min-nákóní aneke náomma umánaraae. ");
INSERT INTO usa_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","anaaékaqa min-áwáyóq-náqá púítata Áánûqtuni kaqtó-wayukama yaaguméta mó ákááwana Áabaraate yagaroqtamá máqe-uraiye. ánibo mi móneqa ôriq umá makái-nakogaraq púítata maméta mó uqtamákaraae. ");
INSERT INTO usa_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","ánibo móneqa makái-nakoma áítanobaq máena aíq-irayaba ôriq uráiye. ánibo min-nákómá múte aónaimma Áabaraama nékaq máitana Aráátaratima amakaq máqe-uraiye. ");
INSERT INTO usa_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","móneqa makái-nakoma maará téna ááyama tiráiye. ‘ketibomá Áabaraao! emá keqtábá arummá umátike Aráátaratimma timákénana ayáánaubiqa nopí márú yamátuwena timáábíraq maraínana yatí umátikaino. timáábíraq iramá kégaitana ôriq uma tíqa kéiye.’ tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","miráitana Áabaraama maará-tiraiye. ‘ketáaniko,’ aákaq maraao. naayóbáqá emá paámó máema íráqô-qtataaqa matáánamanibo Aráátaratima ananna-yátááqá mayéwaine. íbêqa maa-márúkáqá Aráátaratimma áyákoma íráqôniq kéitana amuq-yatáápí máitaa emá aíqa í-yátáápí máane. ");
INSERT INTO usa_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","óq-yataare. ketáágáráq keráwákáráqtí aúkáapimma Áánûqtuma móra non-ómá áitaba uqmá kubáumakaiye. miráipoata maabáqó máa-kayukama maami non-ómá aqtátuweta keráwáqtôpaq ónáae temánibo yemá kanaaráq íuraae. ánibo yaímma-wayukama min-ábápáqá máa-kayukama non-ómá íma kanaaráq aqtátuweta ketáá máunabaqa yínoe.’ téna Áabaraama tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","ánibo móneqa makái-nakoma maará-tiraiye. ‘miráinaa ketiboó, kemá emmá ítama káonaune. emá Aráátaratimma timákénana ketiboní naaúpaq wíno. ");
INSERT INTO usa_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","mibáq kemá móra-tiyaapaq ketíbâtiwaayuma yíkaraune. ánibo Aráátaratima akoqnáá-aimma yepímmá móma tíno. yegáráq maa áwáábiq-marupaq iréta yíqa í-yátááqá mayaíyábáé.’ tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","miráitana Áabaraama maará-tiraiye. yemá Mótetini watáagaraq Áánûqtuni amuné-wáyúkátí yáagaraq ítaraamiye. iyúwénata yemá min-áímmá waqmá ítáaro.’ téna Áabaraama tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","ánibo móneqa makái-nakoma maará-tiraiye. ‘ímiye. ketibomá Áabaraao, wé minnâ kanaaráq íiniye. miráimanibo mórama pukáinabike itó-uma yetôpaqo wínatama yemá kanaaráq yirummá waeránóe.’ tiráimanibo ");
INSERT INTO usa_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Áabaraama maará téna timá ámikaiye. ‘yemá Mótetin-aagaraq Áánûqtuni amuné-wáyúkátí yáagaraq ímo ítaretama kanaaráq móra-nakoma pukáinabike yauwéqma itó ínatama minnágaraq yirummá íma waeréta íma itánoe.’ téna Áabaraama tiráiye.” téna Îtuma maamin-áímmá waéqma itaí-áípí tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Îtuma maará téna wení iyápó-annama timá yímikaiye: “yaímma-yataakoma pááq énama aarawaamá mamá kúmiq-yataapi yuwánimanibo náawabi yemmá mamá kúmiq-yataapi iyuwaína-waigomma weqtábá táí-meyamma anaaékaqa wániye. ");
INSERT INTO usa_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","keráwáqtí aúkáapike móra-nakoma káqo-nakomma mamá kúmiq-yataapi ayuwáné kéinaqa kanaaráq áqnáabaq min-nákómmá anón-oqtamma matéraq ánûwarapi ánná kútuweraq nopí yuwaíyana íma táí-aaimma mamá pááq íniye. ");
INSERT INTO usa_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","keráwáqá atéqma arútáaro. enábâkoma kúmiq-yataariqo kéinaama emá wemmá aá awáágúo. ánibo wemá arummá waeraínaama emá wení kúmiq-yataaqa mamá paábaq yuwé awikamákaao. ");
INSERT INTO usa_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","wemá emmá mimórá táoqa abapaké kaayapáq otaa-qtátááríq umákena abapaké kaayapáq enôpaqa yéna wemá maará téna ‘kemá tirummá waeráune’ tínaama kanaaráq wení kúmiq-yataaqa aati-aatimá mamá paábaq yuwé awikátuwaao.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","awaaméqá umáyikena yiwíkai-kayukama uyátárai-naqa Îtumma maará téta timá ámikaae: “emá ketááí itáíq-itaiq umá yabi-í-yátááqá mamá uyátá-maqma anókariq umátikaao.” téta tirááe. ");
INSERT INTO usa_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","ánibo uyátárai-nakoma yauwéqma maará-tiraiye: “keráwáqti itáíq-itaiq umá yabi-í-yátááqá paá pááqyan-anayukaa umá wáinaqa kanaaráq keráwáqá mi-tágómmá maará-tima-aminoe. ‘emá áaipike enamáárîq agíqme únópí koma karuyuwo.’ tíyanama paá keráwáqtí táama warániye. ");
INSERT INTO usa_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","ítáaro. keráwáqtí aúkáapike móra-nakoma móra mayaí-náqá meyámmá íma aména paá-mayai-naqa ákaraitana yómmá kéyorenawabi tipi-típi kawaa umátuwe máqena anaaékaqa naaúpaq yauwéqma ínana wení kawáá-nákómá téna ‘emá páátákáá maraq yamáe aáwaqa naao.’ téna tíníyô? ");
INSERT INTO usa_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","ímiye. wé maará-tima-aminiye. ‘emá ketí aáwaqa yokaa umátíkare emá ámûranna umá arútare ketí aáwaqa ikámme má-timiyo. kenókáá aáwaraa nommá nátúwáanaa emá anaaékaq aáwaraa nommá nánóne.’ téna tíniye. ");
INSERT INTO usa_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","ánibo meyámá íma mayéna kaayóq-nákóqtábá wení kawáá-nákómá aamá wáráiqtaba ‘tíkáiye’ tíníyô? ímiye. ");
INSERT INTO usa_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","miráinaq keráwákáráqá ‘Aánûqtuma máqte-mayaiyaba ti-qtátááqá mamá ánatatuweqa kanaaráq keráwáqá maará tero. ‘ketáámá paá-mayai-wayukamunataae. ketáá paá ketááí mayaímá mamá ánataraunatae’ tero.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Îtuma Yérútáárebaq urái-nakomma waqména kéwena Kááriri-aukaapikaraq Táméria-aukaapikaraq uráiye. ");
INSERT INTO usa_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","móra-marukaq witata tiyááka-karu-wayukama aapaq Îtumma ya aónaraae. ánibo yemá nékaq ya itó-ureta ");
INSERT INTO usa_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","anókaq ááyama tirááe: “Îtuma kawáá-nákô, emá keqtáá arummá umátikaao.” téta tirááe. ");
INSERT INTO usa_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Îtuma yemmá yimónawaaena maará-tima-yimikaiye: “keráwáqá uréraq anó-monoq-wayukaraq keráwáqtí túma mó-yiraatero.” téna Îtuma timá yímikaiye. ánibo mi-kárú-wáyúkámá aapaq kéowana yeqtí yúgoma íráqôniq umáguraiye. ");
INSERT INTO usa_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","tiyááka-karu-wayukati aúkáapike mórama Táméria-nakoma aónaimma wení aúgoma íráqôniq umágitana yauwéqma Îtunopaq uréna anókaq ááyama Áánûqtuni áwîqa múte yaútaiye. ");
INSERT INTO usa_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","mi-kárú-nákómá Îtuni aúbáq óípake marabí aténa ‘tíkáiye’ téna tiráiye. Támériabake Yéqtaaeo-nare. ");
INSERT INTO usa_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Îtuma minnáma aónatuwena maará-tiraiye: “tiyááka-karu-wayukama atóbamayikaraunamanibo abapaké kaayaqté-kaayaqte Ítíráaeo-wayukama náakaraq mááo? ");
INSERT INTO usa_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","káqo-kayukama iréta Áánûqtun-awiqa íyaq múte yauyô? maamin-náqá wenamáa káqo-mapake-nakoma wenamáawaq Áánûqtuni áwîqa múte yauwíyô?” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","ánibo Îtuma min-náqá maará-tima-amikaiye: “emá itó-uma kóaao. keqnáámmá ení itáíq-itaiq umá yáqtoraanna-yataakoma emmá mamá atóbamakaraiye.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Pérati-wayukama Îtumma maará téta ítama aónaraae: “Áánûqtuma yabíkái-maruqa nói-kanaararaq kumíníyô?” téta tewana Îtuma yauwéqma maará-tima-yimikaiye: “Áánûqtuma yabí íni-kanaama kumínatama aarawaamá yúrapikema íma aónainoe. ");
INSERT INTO usa_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","aónaaro. Áánûqtuma yabíkái-naqa maa máiye aqá mera máiye.’ téta máqtemma ítinoe. ímiye. Áánûqtuma yabíkái-qtataaqa keráwáqtí aúkáapi wáiye.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","ánibo wení iyápó-annama maará téna timá yímikaiye: “anaaékaqa móra-kanaama pááq ínaqa keráwáqá ibiqá yaréq maará-tinoe. ‘móra-kanaama Waayúkagoni Áráakoni-kanaama ókaraq páátákáá pááq ínaq aónanae tínômanibo íma aónainoe.’ ");
INSERT INTO usa_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","yaímma-wayukama maará téta keráwáqá timá-timinoe. ‘merapaq aónaaro. maabáq aónaaro.’ tínômanibo keráwáqá íma min-áímmá wáráaro. ");
INSERT INTO usa_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","aabáyúma yoqmá ikáqmena aabayákáqá maan-áúkápáké móra-aukapaq wéyáwé iníkáá umá Waayúkagoni Áráaqa kumíní-kanaaraqa móraiq umá miráitata máqtemma aónanoe. ");
INSERT INTO usa_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","miráimanibo áqnáabaq-yataaqa Waayúkagoni Áráakoma aíqa í-yátááqá taíbaq mamayaínata íbêq-kanaaraq-wayukama awéqtáma yuwánoe. ");
INSERT INTO usa_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","naayóbáqá Nóaani kanaaráqá uráinikaa umá Waayúkagoni Áráaqa wení kanaaráqá móraiq íniye. ");
INSERT INTO usa_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Nóaani kanaaráqá yemá anón-aawaqa néta aíbôq-nomma néta aaramá mayéta kéowana Nóaama únópí-káárénóbáq uyábékuraiye. ánibo mikáqá anón-nomma auténa máqtemma aarawaamá yawááq-umatukaiye. ");
INSERT INTO usa_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","keqnáámmá Arótini kanaarákáráqá móraiq urááne. yemá yokaa íeta anón-aawaqa néta aíbôq-nomma néta máqte-qtataaqa meyánîq éta máqte-qtataaqa káqo-kayukama kéyimeta meyámmá mayéta yómmá yoréta yemá naammá éta urááe. ");
INSERT INTO usa_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","ánibo Arótima Tótômabaq yuwéna ópaq kóitana é mi táoq iragógáráq abááq-írágómá aabayápáké aaqá yumáena kúmínikaa umáe kukéna aarawaamá máqtepaq kamá kaútukaiye. ");
INSERT INTO usa_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","móraiq umá Waayúkagoni Áráaqa abarokáq kumíní-kanaaraqa miráiniye. ");
INSERT INTO usa_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","mi-kánááráqá móra-nakoma márûpaq yaúbama máinana wení ótamma naaúpaq wáinnama kanaaráq naaúpaq uyábékena wení ótamma ímayaino. móraiq umá móra-nakoma yópáqô máqe-inna-nakoma yauwéqma naaópaqa íwíno. ");
INSERT INTO usa_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","keráwáqá Arótimma ánáákoqtabama túyánámmá ítáaro. (naayóbáqá Áánûqtuma Tótômabaq Komóraabakaraq yawítíma iramá agatuwáné kéena Arótiqtaba téna ‘ení aara-iyápómá yiwíqme péqmare paábaq kóaao. ánibo yuwé inna-márúpáqá ókaraq waéqma íaonaao.’ titata kégopike Arótimma ánáakoma anaaépaq waéqma aónénaboana mikáq óqtamma aúkéna pukáine.) ");
INSERT INTO usa_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","náawabi wení paá mái-auwaraiqtaba akáinna-nakoma wení aúwaraimma aúyokiniye. ánibo náawabi wení aúwaraimma yuwénama kanaaráq wení aúwaraimma mayániye. ");
INSERT INTO usa_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","kemá Îtuma keráwáqá kétima-timune. mi-nókáámmá kaayaq-nákórátá yagaroqtamá waguráiyapike Áánûqtuma móra-naqa awíqmayena káqo-naqa mikáq ayuwániye. ");
INSERT INTO usa_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","ánibo kaayaq-íníkórátá aáwaqa kágayaiyapikemma Áánûqtuma móra-inimma káwirena káqon-inimma ayuwániye. ");
INSERT INTO usa_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","ánibo kaayaq-nákórátá yópí máraiyapikemma móra-naqa Áánûqtuma káwirena káqo-naqa mikáq ayuwániye.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","miráitata yemá Îtuni iyápó-annama min-áímmá itáa eta maará-tiraae: “uyátárai-nako, mi-qtátááqá náakaraq pááq íníyô?” téta tewana Îtuma maará téna yauwéqma tiráiye: “pukáa-kayukati arááq-yuma wáin-aukapaqa akikígómá yagáikuyoe.” téna atékéraq min-áwááméqtábá aónama arútáaro. Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Îtuma wení iyápó-annama móra waéqma itaí-aímmá timá yíménata aati-aatimá íma yiwikéta nunamummá tíq-tiq kéyana Áánûqtuma yemmá yauwéqma timá-yiminiye. ");
INSERT INTO usa_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Îtuma maará-tiraiye: “móra-marukaqa aamá ítama yainaí-náqá máqe-uraiye. ánibo min-nákómá Áánûqtun áaqa íma ikaténa waayúkayabagaraqa íma ikatîq uráiye. ");
INSERT INTO usa_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","ánibo móra keqtoq-ínímmá mimórá-márúkáqá máqe-uraiye. aati-aatimá min-íníkómá aamá ítama yainaí-nákókáq iréna maará má-tiraiye. ‘ketí namuro-wáyúkámá kemmá mamá táíq kéumatikaae. emá kemmá tíwáqnaa umá aamá ítama yainaao.’ téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","áqnáabaqa aamá ítama yainaí-nákómá min-ínímmá íma áwáqnaa uráimanibo anaaékaqa maará téna aúyánánóbáqá tiráiye. ‘kemá Áánûqtuni áaqa íma ikatîq waayúkati yáakaraqa íma kéikatunamanibo ");
INSERT INTO usa_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","maami keqtoq-íníkómá kemmá ummaa-yátááqá kétimipoaq áwáqnaa umá aamá ítama yainánúne. aati-aatimá yúwáanana yóyo kéinana tíbô ka-íyábábóaq áwáqnaa ónúne.’ téna aúyánánóbáqá tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","ánibo uyátárai-nakoma ókaraq maará-tiraiye: “keráwáqá maami ítama yainaí-táí-nákóní áama ítáaro. ");
INSERT INTO usa_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","min-áímmá waayúkaraq íma yabíqma arútái-kawaa-nakoni watáae. miráimanibo aarawaamá Áánûqtuma wetábá awaaméqá umáyíkái-kayukama aati-aati-nókáánábi aati-aati-wágáámá Áánûqtuqtaba ibiqá yaraíyanama wemá áráwáábakena yíwáqnaa íní íyabiyo? ");
INSERT INTO usa_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","owé. keráwáqá kétima-timune. Áánûqtuma yeráwáqá páátákáá yíwáqnaa íniye. ááqibo anaaékaqa Waayúkagoni Áráaqa kumíní-kanaaraqa maa-márábí-káyúkámá yirummá améta itáíq-itaiq umá yáqtorai-yataakaraq máiyanawaq yimónaniyo?” téna keráwáqtí tirummá mamá akoqnáá iyábá Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","yaímma-wayukama téta ‘ketáámá arupú-wayukama máunataamibo káqo-kayukama paá-wayukama mááe’ téta yúyánámmá kéitaae. máqtemma mi-káyúkátí waéqma itaí-áímmá Îtuma tiráiye: ");
INSERT INTO usa_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“kaayaq-nákórátámá nunamummá tíyéta anó-monoq-naupaq utááye. móra-naqa Pératibake-nare. káqo-naqa táákiti-moneqa máyái-nare. ");
INSERT INTO usa_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","ánibo Pérati-nakoma itó-urena aúyánánóbáqá maará téna nunamummá tiráiye. ‘Áánûqtuo, kemá káqo-kayukaraa umá íma máepoaq kemá ekáq ‘tíkáiye’ kétune. yemá moyámmá kémayeta táí-aaimma tarôq kéeta aaraukáqá mamá kéyataae. miráimanibo kemá yemó oníqa íkéune. ánibo kemá maan-náqá táákiti-moneqa máyái-nakaa umá íma máeq ekáq ‘tíkáiye’ kétune. ");
INSERT INTO usa_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","máqte-totaaraqa kaayaq táoqa aáwaqa awetá kéeq máqte-qtataaqo mayáunnama yoraúma tiyáákabike akáma emmá mórama kámune.’ téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","miráimanibo táákiti-moneqa mayaí-nákómá nékaq ya itó-urena Áánûqtunopaq íma múte aónaraiye. wemá paá awaútena maará-tiraiye. ‘Áánûqtuo, kemá kúmiq-naqune. emá arummá umátikaao.’ téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","kemá keráwáqá kétima-timune. táákiti-moneqo mayaí-nákómmá wení naaópaq yauwéqmena wimmá Áánûqtun-aurakaqa arupú-naqa máqe-uraimanibo Pérati-nakoma Áánûqtun-aurakaq íma arupú umá máqe-uraiye. ítáaro. náawabi wetábá wení áwîqa múte yauwínna-nakomma Áánûqtuma mamá márûte yuwániye. náawabi wetábá wení áwîqa márúte yuwaína-nakoni áwîqa Áánûqtuma múte yauwíniye.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","yaímma-wayukama yemá pááqya-noiyapoma yiwíqmeta Îtunopaq irááe. yemá téta Îtuqtaba min-nóíyápóráq ayáánapo yínêkuikaae tirááe. miráimanibo Îtuni iyápó-annama minnâ aónawaaeta mi-káyúkámá aamá yiwááguraae. ");
INSERT INTO usa_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","ánibo Îtuma iyápórawaqa yááyama amakaq iréna maará-tiraiye: “keráwáqá iyuwáiyata iyápóma ketôpaq íyaraq íma yaqtóráaro. Áánûqtuma yabíkái-marupaqa miráuma iyápóraa-kayukati minnáe. ");
INSERT INTO usa_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","kemá keráwáqá áraimma kétima-timune. iyápógomma aboámá aati-aatimá áwáqnaa kéipoana miráráá umá móra-nakoma pááqyan-iyaporaa íma aurénama Áánûqtuma yabíkái-marupaqa íma uyáberaniye. áraimma ímiye.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","móra anó-nakoma Îtumma maará téna ítama aónaraiye: “íráqô-yiraati-nako, kemá náaraq umáwaq aati-aatimá matúq-matuq umá mái-auwaraimma mayánúnô?” téna ítama aónaraiye. ");
INSERT INTO usa_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","ánibo Îtuma maará téna tiráiye: “nôraq itaawáq keqtábámá íráqô-nako kéteno? Áánûqtu wenamáa íráqôniq kéiye. ");
INSERT INTO usa_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","emá ámáan-aimma ítaraane. aaraukáqá íma yataiyo. waayúkama íma ikámma puyuwo. moyámmá íma mayaao. káqon-nakomma kaaqaarimá ítimakaao. emá enanó-enaboni aménáápáq mááo.” téna Îtuma titana ");
INSERT INTO usa_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","anón-nakoma maará-tiraiye: “naayóbáqá kemá iyápóma máqe-uraunarake áaimma átáma min-ámáán-áímmá máqtemma anaaé wakáunamiye.” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Îtuma min-áímmá itáá ena maará-tima-amikaiye: “emá móra-yataaqtaba aqtórárîq urááne. ení máqte-qtataaqa waayúkama yímínata meyáníq kéiyaa mi-mónéqá mamá *wáyoq-wayukama yaímma yimiyo. emá miráumatuwena Áánûqtuni-marupaq kateko-yátááqá maránóne. ánibo emá miráumatuwe ketinaaé waraao.” téna Îtuma timá ámikaiye. ");
INSERT INTO usa_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","miráitana min-ánó-nákómá min-áímmá itáá ena áyákoma ummaa yáguraiye. wemá móneqa ôriq umá makáinapoana wení móneqtaba ítama ummaa yaráiye. ");
INSERT INTO usa_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","min-náqá aónawaaena Îtuma maará-tiraiye: “waayúkama taíbaq-yataaqo makáa-kayukama Áánûqtu yabíkái-marupaq uwínóqtabama kammáa kámagoe. ");
INSERT INTO usa_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","káámoma oótiraakakoma waigóní aapi peránénama kammáa ainíkáá umá miráuma móneqa taíbaq makái-nakoma Áánûqtu yabíkái-marupaq uíníqtaba kammáa kámagiye.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","waayúkama min-áímmá itáá eta maará-tiraae: “miráinanama kanaaráq náawawaq matúq-matuq umá mái-auwaraimma mayáníyô?” téta tirááe. ");
INSERT INTO usa_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","ánibo Îtuma maará-tiraiye: “waayúkama móra-yataariqa kanaaráq íma ínômanibo Áánûqtu kanaaráq miráininiye.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Pítaama maará-tiraiye: “itaao. ketáámá ketááí márûkaraq ketááí ótakaraqa yuwétaa enanaaé kéwaraunataae.” téna titana ");
INSERT INTO usa_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Îtuma maará-tima-yimikaiye: “kemá keráwáqá áraimma kétima-timune. máqte-kayukama Áánûqtuma yabíkái-qtataaqtaba naammá yuwéta aaramá ábâqawaamma aboámmá anóamma iyápóma yuwaíyanama ");
INSERT INTO usa_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","kanaaráq Áánûqtuma íbêqa maa-kánááráqá uyátá-maqma taíbaq yauwéqma yimíniye. ánibo anaaéka-kanaama pááq ínatama yemá matúq-matuq umá mái-auwaraimma mayánoe.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Îtuma wení tiyááka uréna títaupake kaayaq-nóíyápómá yiwíqma yíkarena maará-tima-yimikaiye: “ítáaro. íbêqa ketáámá Yérútáárebaq uyónúnatae. ánibo naayóbáqá Áánûqtuni amuné-wáyúkámá Waayúkagoni Áráakoqtaba agatáan-aikoma áraimma pááq éna arammá iyániye. ");
INSERT INTO usa_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","yemá wemmá mamá Yéqtaaeo-wayukati iyáápi maránoe. ánibo yemá wemmá aábê-aimma timáketa áyoqa ayéta wirááti wirakánoe. ");
INSERT INTO usa_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","ánibo yemá tebûqa améta ikámma utánómanibo kaumo-kánááráqá itó-iniye.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","miráimanibo wení iyápó-annama Îtuma min-áímmô timmá íma ítama arútaraae. Ítíráaeo-wayukati kínimma aónaigae téna timánibo min-áíkóní áaimma aúyokuraitataboata íma ítama tágaraae. ");
INSERT INTO usa_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Îtuma Yérikobaq waaqókáq úítana mórama aúgaroq-nakoma aakóní áwábaq máena móneqtaba aarawaamá yááyama ita-ita uráiye. ");
INSERT INTO usa_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","min-áúgáróq-nákómá ítáimma taíbaq-wayukama kéyewana ítátuwena maará téna yaímma-wayukaraq ítama aónaraiye: “yemá nôraq kéoo?” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","ánibo yemá maará-tima-amikaae: “Îtuma Náátárêtibake-naqa kéiye.” téta tirááe. ");
INSERT INTO usa_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","ánibo min-áúgáróq-nákómá maará téna ááyama tiráiye: “Îtuo, emá Tébitimma áanikomopo emá kemmá arummá umátikaao.” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","áqnáabaq ye-káyúkámá maará téta aamá awááguraae: “emá paátí mááo.” téta tirááe. miráimanibo min-aúgáróq-nákómá ókaraq ááyama maará-tiraiye: “emá Tébitimma áanikomopo kemmá arummá umátikaao.” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","ánibo Îtuma waaqókáq ya itó-urena mará-tima-yimikaiye: “keráwáqá min-náqá ketôpaq awíqme yero.” téna tiráiye. min-áúgáróq-náqá waaqókáq itana Îtuma maará téna ítama aónaraiye: ");
INSERT INTO usa_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“kemá emmá nôraq umákanuno?” téna tiráiye. ánibo min-áúgáróq-nákómá maará-tiraiye: “uyátáraana-nako, kemá keqnáámmá túramma aónanaae téq kétune.” téna titana ");
INSERT INTO usa_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Îtuma maará téna timá ámikaiye: “karáqma aónaao. ení itáíq-itaiq umá yabi-í-yátáákómá emmá mamá atóbamakaiye.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","miráitana páátákáá min-nákóní aúrakoma íráqôniq umágitana aúramma aónarena Îtun anaaé kéwarena Áánûqtuni áwîqa múte yaútaiye. ánibo aarawaamá minnáraq aónawaaeta Áánûqtuni áwîqa múte yaútaae. ");
INSERT INTO usa_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Îtuma Yérikobaq uyábékaimma ");
INSERT INTO usa_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","mikáq móra-naqa máqe-uraimma min-nákóní áwîqa Takíatie. wemá táákiti-moneqa mayaí-wáyúkátí kawáá-nápóana móneqa taíbaq makáiye. ");
INSERT INTO usa_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","ánibo Takíatima Îtumma aónainena uráimanibo wemá awaaraq-nápóana taíbaq-wayukabikema kanaaráq Îtumma íma aónaraiye. ");
INSERT INTO usa_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","ánibo Takíatima taíbaq-wayukati yúbáq uyaaté uréna móra-yaraq uyátárena Îtumma aónainena uráiye. ánibo wemá ‘Îtuma maan-ákáq íniye’ téna aúyánámmá ítaraiye. ");
INSERT INTO usa_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Îtuma min-áúkápáq iréna múte aónatuwena maará-tiraiye: “Takíatio, emá páátákáá marabí kumuwo. íbêqa kemá ení naaúpaq mánune.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","miráitana Takíatima páátákáá kukéna amuqá kémaraipike Îtumma awíqmena wení naaúpaqa kóuraiye. ");
INSERT INTO usa_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","ánibo máqte-kayukama minnáma aónatuweta aamá awáágéta maará-tiraae: “Îtuma móra kúmiq-nakoni naaúpaqa ko kéwaiye.” téta tiráámanibo ");
INSERT INTO usa_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Takíatima itó-urena uyátárai-nakomma maará-tima-amikaiye: “uyátáraana-nako, emá itaao. íbêqa máqte-qtataaqa yaíkaaq uréq áwáyoq-wayukama yiménúne. ánibo kemá móra-nakomma kaaqaarigónîq umákéq wení máqte-qtataaqa moyámmô matáana-yataaqa kanaaráq yauwéqma kaayaqté-kaayaqte-kanaaráq aménúne.” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","miráitana Îtuma maará-tima-amikaiye: “íbêqa maan-náúpáké-káyúkámá Áánûqtu yauwéqma kéyiwiraiye. maan-nákógáráqá Áabaraan-annabikemanibo íbêqa arummá waeráiye. ");
INSERT INTO usa_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","minnâ Waayúkagoni Áráaqa iréna aúyokuraa-kayukama yibáá umá yauwéqma yiwiránáae téna uráiye.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","yemá min-áímmá ítátuwaawana Îtuma móra waéqma itaí-áímmá timá yímikaiye. Yérútáárebaq waaqókáq yitatabóata Áánûqtuma yabíkáin-aimma íbêqa abarokáq ínítana kétiye téta yúyánámmá ítaraae. ");
INSERT INTO usa_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","ánibo Îtuma maará-tiraiye: “mórama anó-nakoma móra ayáqtááq-mapaq kínimma tarôq umákane owana kóuraiye. anaaékaqa min-nákómá yauwéqma yíniye. ");
INSERT INTO usa_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","íurena min-ánó-nákómá wení tiyááka-mayai-wayukama yiwíkena móneqa tiyááka-wayukama yímika-yimika uráiye. maará-tima-yimikaiye. ‘keráwáqá maami-mónéqnápó mayaímá mamá amuq-yáúmá kémayaiyaq yauwéqma yeno.’ téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","miráitata wení márûkaq-wayukama yaímma íyamma umákaraae. miráitana wemá kóitata yaímma-wayukama timáyíkáawata anaaé waqmé urááe. ánibo yemá maará mó-tiraae. ‘maamin-nákómá ketááí kínimma máiyaba íkétikaitaae.’ téta tirááe. ");
INSERT INTO usa_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","min-nákómmá kínimma tarôq umákáawana máqena anaaékaqa yauwéqma iráiye. ánibo wé maará-tiraiye. ‘naayóbáqá móneqa yímikaunna-wayukama yááyaiyata yero. móra-mora-yuma náaraq umáq amuq-yáúmá matááwáa aónanaae.’ téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","áqnáabaq-nakoma iréna maará-tiraiye. ‘uyátáraana-nako, ema tiyááka-wayukama tímikaanna-monekake matéq mayaímá kémayeq amuq-yáúmá (200) matáune.’ téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","ánibo kínima maará-tiraiye. ‘emá íráqô-mayai-napoa emá kateko-máyáímá matááne. emá pááqya-qtataakaraqa kawáá umá kárutaanaboaq íbêqa kemá emmá náápaamma kámunaboaa tiyááka-ano-marukaqa yabi ínóne.’ téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","anaaékaq móra-nakoma iréna maará-tiraiye. ‘uyátáraana-nako, kemá ení tiyááka-wayukarake mayaímá matéq amuq-yáúmá (100) matáune.’ téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","ánibo kínima maará-tiraiye. ‘móra-tiyaapaq anó-marukaq-kawaama yabi iyo.’ téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","káqo-mayai-nakoma iréna maará-tiraiye. ‘uyátáraana-nako, ení móneqa tiyááka-wayukama maa wáiye. kemá móra-wannaabi atáá-umatuweq ákaraune. ");
INSERT INTO usa_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","kemá emmá aónáunama emá iragayá-náqá máane. móra-nakoma márái-qtataaqa emá paá kémaye. káqo-nakoma yómmá yoqmáráipikemma aáwaqa paá kémayaane. miráitaq kemá enáaqa kéikatune.’ téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","ánibo kínima mi-máyáí-nákómmá maará-tima-amikaiye. ‘emá táí-mayai-naqone. enáarake kemá emmá aabi mayakánúne. áraimma kétimonaane. kemá iragayá-náqá máepoaq káqo-nakoma márái-qtataaqa kémayeq káqo-nakoma yómmá yoqmáráipikemma aáwaqa paá kémayaune. miráwáq kéuno? ");
INSERT INTO usa_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","ánibo nôraq itaawáq ketí móneqa móneq-naupaqa íma tíkáraanaq yauwéqma yéqa amuq-yáúgáráqá íma mayáúnô?’ téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","mi-kínímá waaqókáq itó-uma máe-kayukama maará-tima-yimikaiye. ‘keráwáqá min-nákóní ayáápike tiyááka-wayukama yabíma taíbaq matokái-nakomma áméro.’ téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","ánibo yemá maará-tima-amikaae. ‘uyátáraana-nako, wemá áqa taíbaq (200) matokáiye.’ téta tewana ");
INSERT INTO usa_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","mi-kínímá maará-tiraiye. ‘kemá keráwáqá kétima-timune. máqte-kayukama taíbaq matokáiyayuma yemmá ókaraq yiménúne. miráimanibo móra-nakoma pááqyamma matokáinna-nakomma wení pááqya-qtataaqa ayáápike yabítuwanune. ");
INSERT INTO usa_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","ánibo ketí anmuro-wáyúkámá keqtábá téta ketááí kínimma máiyaba ‘íkétikaitaae’ tiráá-kayukama yiwíqme maakáq iréra ketúrakaq yíkamma púyoro.’ téna kínima tiráiye.” téna Îtuma waéqma itaí-áímmá tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Îtuma min-áímmá timá ánatatuwena áqnáabaq kéwena Yérútáárebaq uráin-amma arááyamaena uráiye. ");
INSERT INTO usa_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","ánibo Îtuma Béqtápégibaqa waaqókákáráq Béqtanibaqa waaqókákáráq iráimma min-ánúmá áwîqa Óríbêti-anuraq iréna wení iyápó-annabike kaayaqá timáyíkáitata áqnáabaq urááye. ");
INSERT INTO usa_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Îtuma maará téna min-nákámá timá yímikaiye: “kenákámá mera-márúpáq uréka mórama naatéqá oótiraa-kamma ánnáraq kúyakaraabo aónaakao. naayóbáqá min-ótíráá-kákóní ámûraaqa íma ayááqmeta uréire uráámibo ánná ayútuweka awíqme yekao. ");
INSERT INTO usa_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","ánibo móra-nakoma kenákámá ítama aónéna ‘nôraq itakawáq min-ótíráá-kámmá ánná káyuboyo?’ tínakama kanaaráq kenakámá yauwéqma maará tekao. ‘uyátárai-nakoma maaminnáyaba itakaé tekao.’ téna Îtuma timá yímikaiye. ");
INSERT INTO usa_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Îtuma kaayaq-nákámá timá yíkáitata yenákámá kóureta timá yíminiq umá mi-qtátááqá wáitata aónaraaye. ");
INSERT INTO usa_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","yenákámá uréta naatéqá oótiraa-kamma ánnáma káyuboyata min-ótíráá-kákóní aanábó-nákómá iréna maará-tima-yimikaiye. ‘nôraq itakawáq naatéqá oótiraa-kamma ánnáma káyuboyo?’ téna titata ");
INSERT INTO usa_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","yenákámá maará-tiraaye. ‘uyátárai-nakoma maaminnáyaba itakaé.’ téta timátuweta ");
INSERT INTO usa_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","naatéqá oótiraa-kamma awíqmeta Îtunopaq iréta min-ótíráá-kákóní ámûraaq wáqtôma abákáreta Îtumma min-ámúrááq ákáawana máqe-uraiye. ");
INSERT INTO usa_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","ámûraaq máena kéwitata aarawaamá yeqtí unáákáqtôma maméta aapitáá wíqmakaae. ");
INSERT INTO usa_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Îtuma Yérútáárebaq waaqókáq Óríbêti-anubake kukáin-apataaq iréta máqtemma wení iyápó-annama anómma yimuqá makááe. Îtuma máqten-awaameq-yataariq itata káoneta minnáyaba anókaq ááyama Áánûqtuni áwîqa múte yaútaae. ");
INSERT INTO usa_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","yemá maará téta ááyama tirááe: “anó-kinima uyátárai-nakoni áwîkaq kéitana Áánûqtuma íráqôniq kéumakaiye. kaayoné-yátááqá Áánûqtuni márûpaq wáinaq Áánûqtukaq anómma tágama-yataaqa wáiye.” téta tirááe. ");
INSERT INTO usa_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","ánibo yaímma Pérati-wayukama mi-táíbáq-wáyúkánóbáq máqeokake Îtumma maará téta timá ámikaae: “yirááti-nako, emá ení iyápó-annama ‘paátí máero’ timá yimiyo.” téta tirááe. ");
INSERT INTO usa_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","ánibo Îtuma maará téna yauwéqma timá yímikaiye: “kemá keráwáqá kétima-timune. paátí máiyanama kanaaráq óqtakoma aamá ááyama tínoe.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Îtuma Yérútáárebaq waaqókáq iréna márûqa káonena ibiqá yakáiye. ");
INSERT INTO usa_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Îtuma maará-tiraiye: “ketáama kaayoné-yátááqtábá keráwáqá itaígáae téq túnnamanibo keráwáqá íma ítaraane. keráwáqtí taákoma kanaaráq íkéitaiye. ");
INSERT INTO usa_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","keráwáqá ítáaro. anaaékaqa móra-kanaama pááq ínatama keráwáqtí namuro-wáyúkámá iréta tíqa umá ikútiketa máqten-aukapaqa ikúma aúyatikanoe. ");
INSERT INTO usa_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","keráwákáráq keráwáqtí waayúkagaraq máqtepaq tíkamma ánatatuwanoe. yemá mórama keráwáqá íma tiyuwaíyaq paámá mánoe. íbêqa Áánûqtuma keráwáqá mamá atóbamatikani-kanaayabama túyánámmá íma ítaapoata namuro-wáyúkámá keráwáqá máqtepaq tíkameqe yuwánóe.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Îtuma anó-monoq-naupaq uténa Áánûqtukaq amí-wámmá maméta meyánîq o-káyúkámá áaimma átáma yíkamma paábataa waqtukáiye. ");
INSERT INTO usa_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Îtuma maará téna mi-káyúkámá timá yímikaiye: “Áánûqtuni watáama agamatá-kánnáágómá maará-tiraiye. ‘ketí naakómá paá nunamummá tí-námmá waíno.’ tiráine. mirá-tiraimanibo keráwáqá mamá moyá-káyúkátí-aúpáq-nákáá kéumatuwaae.” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","aati-aatimá Îtuma anó-monoq-naupaq kéyiraatena timá yímikaiye. ánibo uyátárai-monoq-wayukagaraq ámáan-aimma yirááti-wayukagaraq aarawaatí anó-kayukagaraq Îtumma ikámma puínón-aqtaba abáá-uraae. ");
INSERT INTO usa_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","miráimanibo máqte-kayukama Îtun áama itáíyábá ôriq umá yíkáitataboata anó-kayukama ikamínón-amma íma abáá-uraae. ");
INSERT INTO usa_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","móra-taoqa Îtuma anó-monoq-naupaq watáama aarawaamá kétima-yimena átê-wataagaraq Áánûqtutabagaraq timá yímikaiye. ánibo uyátárai-monoq-wayukagaraq ámáan-aimma yirááti-wayukagaraq anó-kayukagaraqa Îtunopaq irááe. ");
INSERT INTO usa_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","yemá maará téta Îtumma timá ámikaae: “emá keqtáá timá-timiyo. emá nói-naapaanaq matokéyaq maami-máyáímá kémayaano? náawaq maami-náápáámmá ámikaiyo?” téta ítama aónaraae. ");
INSERT INTO usa_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","ánibo Îtuma maará téna yauwéqma timá yímikaiye: “kegáráqá keráwákáq móra-aiqtaba ítama aónanaaq kéune. keráwáqá kemmá timá tíméro. minnâ ");
INSERT INTO usa_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Yóáanema nommá péqyikai-qtataaqa minnâ Áánûqtunawabi waayúkagonawabiyo?” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","ánibo yeíyáá aamá kóté-yáté kéeta maará-tiraae: “ketáá maará téqtaa minnáma ‘Áánûqtunae.’ tenanatáámá Îtuma maará-tiniye. keráwáqá nôraq itaráq itáíq-itaiq umá tirummá íma kámeo tíniye. ");
INSERT INTO usa_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","ánibo ketáá téqtaa minnáma paá ‘waayúkati minnáe.’ tenatatáámá máqte-kayukama keqtáá óqtatanapotaa tíkaminotaae. ánibo yemá Yóáaneqtaba Áánûqtuni amuné-náré téta kéitaapoata óqtatanapo tíkaminotaae.” téta tirááe. ");
INSERT INTO usa_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","miráitata yemá maará téta Îtun-aaraq yauwéqma tirááe: “Yóáanema nommá pérái-qtataaqa náakakenaq iráiyô minnâ ketáá íaonaraunataae.” téta tirááe. ");
INSERT INTO usa_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","ánibo Îtuma maará-tima-yimikaiye: “móraiq umá kegáráqá keráwáqá íma timá-timenune kemá nói-naapaanaq matokérabi mi-máyáímá kémayaune.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Îtuma mirá-timatuwena aarawaamá móra waéqma itaí-áímmá timá yímikaimma maará-tiraiye: “móra-nakoma wááéni ara-tómmá yoqmakáiye. ánibo min-nákómá wááéni-aramma uqmá yaímma-wayukati iyáápi mi-tómmá maréna min-nákómá káqo-marabaq ko máqe-uraiye. ");
INSERT INTO usa_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","anaaékaqa wááéni-aramma ábuma-kaitana arammá kutí-kánááráqá móra-naqa timákáitana wááéni ara-tókáqô yabíkáa-kayukayopaq uráiye. anón-nakoma téna min-nákómmá yaímma mi-tópíkén-ááwáqá amígáae téna timákáitana uráiye. ánibo wááéni ara-tókáq yabíkáa-kayukama mi timákáitana i-náqá ikámma waqtúwáawana aáwaqa íma mayéna paá kóuraiye. ");
INSERT INTO usa_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","keqnáámmá anó-nakoma káqo-mayai-naqa timákáitana uráiye. miráitata wekáráq ikámma waqtúwáawana aáwaqa íma mayéna paá yauwéqme kóuraiye. ");
INSERT INTO usa_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","ánibo keqnáámmá mikáq móra-mayai-naqa timákáitana uráiye. miráitata keqnáámmá ikámma yaúma paábaq iyaabótukaae. ");
INSERT INTO usa_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","miráitana wááéni ara-tókóní aboámá maará-tiraiye. ‘kemá náaraq ónúnô? ketáanikoqtaba ôriq umá tíkáin-iyapoma minnâ timákáanana wíniye. ánibo yemá min-íyápógón áama itánóe.’ tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","miráitata wááéni ara-tókáqô mayaí máyaa-kayukama aónaamma anó-nakoni áanikoma kéiqtaba yeíyáá maará-tiraae. ‘maan-nákómá anaaékaqa aboání máqte-qtataaqa mayániye. mayaíyataao. maamin-náqá ikámma puyónatae. miráinataa maami-tómmá ketáá mayánúnatae.’ tirááe. ");
INSERT INTO usa_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","ánibo mi-káyúkámá anó-nakoni áanikomma wááéni ara-tókóní áwábaq márúte yukéta ikámówana pukáiye. ítáaro. wááéni ara-tókóní aboámá mi-káyúkámá náaraq umáyikaniyo? ");
INSERT INTO usa_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","yókóní aboámá iréna wááéni ara-tókáqô mayaí máyáa-kayukama yíkamma puyéna wááéni ara-tómmá mamá káqo-kayukama yimíniye.” téna Îtuma tiráiye. ánibo waayúkama min-áímmá itáá eta maará-tiraae: “wemá miráinabo áraimma ímiraino.” téta tirááe. ");
INSERT INTO usa_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","miráitana Îtuma mi-káyúkámá yimónawaaena maará-tiraiye: “Áánûqtuni watáama agamatá-kánnáábímmá wáin-aikoma nóin-aainaq wáiyo? ‘maamin-óqtámmá mayaí-wáyúkámá paábaq matúwáan-oqtakoma íbêqa naakóní akoqnáá-abokaa kéiye.’ ");
INSERT INTO usa_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","maqte-kayukama maamin-óqtákóní ámûraaqo kuqtétama yemá ikámma púbuyaginoe. ánibo maamin-óqtákómá móra-nakoni ámûraaqo kuqténama min-nákómmá ikámma púbúyama obamá aúqtuwaniye.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","ánibo ámáan-aimma yirááti-wayukagaraq anó-monoq-wayukagaraqa yemá ítáamma Îtuma yeqtí yúbi maréna waéqma itaí-áímmá tiráiye. miráitata é mi táoq Îtumma yáqtoraneta urááe. miráitata aarawatí yáaqa ikatéta Îtumma íma yáqtokaae. ");
INSERT INTO usa_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","ámáan-aimma yirááti-wayukagaraq uyátárai-monoq-wayukagaraq Îtumma aatómáq urááe. kuqtarurîq o-káyúkámá arupú-wayukaraa umá kaaqaari-áímmá timátuweta Îtumma wenáarake yáqtoqma anó-kamaani-wayukati iyáápi maréta aamá ítama yainánéta urááe. ");
INSERT INTO usa_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","ánibo yemá maará téta ítama aónaraae. ‘yirááti-nako, ketáá kéitaunataae. enáagoma arupú kéitaaboaa aarawaamá arupú-aimma kétima-yimene. anó-kayukati anón-iwiqtabama íma ikatîq kéemanibo aarawaamá Áánûqtuni áaimma kéyiraate árain-aimma kétima-yimene. ");
INSERT INTO usa_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","emá nóine téq aúyánámmá kéitaano? Títaamma” Arómani anó-kawaa-naqa táákiti-moneqa aménúnataabi íyabiyo?” téta Îtumma ítama aónaraae. ");
INSERT INTO usa_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","miráimanibo Îtuma mi-kaaqaari-áímmô temmá ítaraiye. miráitana maará-tima-yimikaiye: ");
INSERT INTO usa_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","móra-moneqa tiráátero. maannáma amakaráq áwîkaraq waímma náawabiyo?” téna tiráiye. ánibo yemá maará-tima-amikaae: “Títaani amané.” téta tirááe. ");
INSERT INTO usa_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","ánnibo Îtuma maará-tima-yimikaiye: “móra-yataaqa Títaannamo wárainaqa kanaaráq Títaamma áméro. ánibo Áánûqtuni móra-yataaqo wáinaqa kanaaráq Áánûqtumma áméro.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","miráitata Îtun áarakemma aarawatí yúbáqá Îtumma íma yáqtóráawaniq urááe. Îtuma min-áímmá yauwéqma timá yímiqtaba yemá taíbaq-yuyanamma ítáá eta aamá íma téta paátí máqe-uraae. ");
INSERT INTO usa_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","yaímma Táátûti-annabike-kayukama Îtunopaq irááe. yemá Táátûti-wayukama téta pukáa-kayukama íma itó-inoe. téwaone. ");
INSERT INTO usa_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","ánibo yemá maará téta Îtumma ítama aónaraae: “yirááti-nako, Mótetima naayóbáqá maamin-ámáán-áímmá agatáine. ‘móra-nakoma aaramá makáinna-naqa iyápóma íakena pukínanama kanaaráq ábâkoma min-ínímmá maténa awaaóní anónnáma móra-iyapoma marakániye.’ tiráine. ");
INSERT INTO usa_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","itaao. mórama ye wátánónáámá miráuma abapaké kaayaqá máqe-uraae. áqnáaekoma móra aaramá maténa iyápóma íma marakéna pukuráiye. ");
INSERT INTO usa_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","anaaékaq ábâkoma min-ínímmá matáiye. ");
INSERT INTO usa_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","anaaékaqa mamá mikáq-ábákómá keqnáán-ínímmá maténa móraiq umá pukuráiye. ánibo keqnáámmá móraiq umá abapaké móra-watanonaama mimórá-ínímmá matéta iyápóma íma marakéta máqtemma pukurááe. ");
INSERT INTO usa_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","miráitana min-íníkógáráq pukuráiye. ");
INSERT INTO usa_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","ánibo pukáa-kayukama itó-i-kanaaraqa min-íníkóma náawani ánáaraq mániyo? abapaké kaayaq-wátánónáámá min-ínímmá matááne.” téta Îtumma ítama aónaraae. ");
INSERT INTO usa_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","minnáyaba Îtuma maará-tima-yimikaiye: “aaragáráq waagaráq íbêqa maa-kánááráqá mamá aaraukáqá káuraae. ");
INSERT INTO usa_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","anaaékaqa aarawaamá pukáiyapike Áánûqtuma itó-oro tínata itó étama yemá ókaraq aaraukáqá íma auránoe. ");
INSERT INTO usa_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","ókaraq íma puínoe. yemá miráuma kaqtó-wáyúkáráá umá maéta íma kanaaráq puínoe. Áánûqtuma pukáíyapike mamá itó-umayikanipoata yemá Áánûqtuni áráabitie. ");
INSERT INTO usa_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","ánibo Mótetigaraqa keqtáá tirááténataa pukáa-kayukama pukáiyapike itó-inoe téna tiráátiraitaae. pááqya-tabikemma iramô karái-waigoni watáagoma maará-tiraiye. ‘uyátárai-naqa minnâ Áabaraani Áánûqtugaraq Ááítekini Áánûqtugaraq Yáakoboni Áánûqtue.’ ");
INSERT INTO usa_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Mótetima wení anáábútááma pukowana maamin-áímmá ítaraine. miráitana Áánûqtuma íma pukáa-kayukati Áánûqtuma máiye. ímiye. wemá minnâ paá yú aréta máa-kayukati Áánûqtue. wení aúrakaqa máqte-kayukama paá yú aréta mááe.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Îtuma mirá-timatuwaitata yaímma ámáan-aimma yirááti-wayukama maará téta yauwéqma tirááe: “yirááti-nako, emá íráqôn-aimma téne.” téta tirááe. ");
INSERT INTO usa_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","ánibo yemá ikatîq éta ókaraq Îtumma íma ítama aónaraae. ");
INSERT INTO usa_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Îtuma Pérati-wayukama makáqma aónéna maará-tima-yimikaiye: “nôraq itatawáq yemá Metáiyama Tébitimma áanikoe kéteo? ");
INSERT INTO usa_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","naayóbáqá agamatán-áúbábí Tébitima maará-tiraine. ‘uyátárai-nakoma ketí uyátárai-nakomma maará téna timá ámikaine. emá ketiyáán-urapaq márenaraq ");
INSERT INTO usa_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","anaaékaqa kemá ení namuro-wáyúkámá mamá ení aítauq aménáápáq yíkáanata wínoe.’ téna Tébitima agamatá-kánnáábí mirá-tiraine. ");
INSERT INTO usa_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Tébitima wenamáárîq wemá ketí uyátárai-nare tiráimanibo náaraq umá Metáiyama Tébitini áanikoma máiyo?” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","máqtemma aarawaamá máeta Îtun áama ítaraae. ánibo Îtuma maará téna wení iyápó-annama timá yímikaiye: ");
INSERT INTO usa_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“keráwáqá ámáan-aimma yirááti-wayukayabama atéráaro. yemá ayáqtááq-unakaqtoma umáreta uréire íyábá ôriq umá kéyikaiye. yemá téta waayúka áíkuiyakaqa uyátárai-nare téta aarawaamá miráó-maarao timá-tikaigaae téta kéte. ánibo yemá monoq-náúpáqá aarawaatí yúbáq aokaq-ábíqtátámá yokaa umáyikaiyata anón-aawaqo naí-kánááráqá kateko-ábíqtátáráq maétaa aáwaqa nánátaae kéte. ");
INSERT INTO usa_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","ketoq-nóínímmá yetí naammá íma meyáníq ínôwataboata máqtepaq kémayeta yemá kaaqaari téta ayáqtááq-nunamumma kéte. aamá ítama yainaí-kánááráqá yemá anómma táí-meyamma mayánoe.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Îtuma aónama kéyautena aónaimma móneqa ôriq umá makáa-kayukama Áánûqtukaq yimuqá marakéta móneqa maraí-yáwáápí móneqa má-makaae. ");
INSERT INTO usa_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","ánibo Îtuma aónaimma mórama keqtoq-ínímmá awaikómá pukuráin-inikoma kaayaqá pááqya-monekarata móneq-yawaapi mó-makaiye. ");
INSERT INTO usa_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Îtuma maará-tiraiye: “kemá keráwáqá áraimma kétima-timune. maa-kéqtóq-íníkómá awaikómá pukuráin-inipoana wemá anó-moneqa yuwéna yaímma-wayukama uyátáiye. ");
INSERT INTO usa_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","máqtemma maa-káyúkámmá yemá taíbaq-moneqa makétaboata yaímma Áánûqtukaq yimuqá marakéta káme. miráimanibo maan-íníkómá íma taíbaq-moneqa makénaboana wemá máqtemma máyuwena aáwaqa meyánîq umá nání-moneqa íma matokáiye.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","yaímma-wayukama anó-monoq-naqtaba íráqôn-oqtakake min-námmá umáreta máqte-qtataaqa Áánûqtukaq yimuqá marakéta ámêqtaba tewana Îtuma maará-tiraiye: ");
INSERT INTO usa_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“máqtemma maami-qtátááqá íbêqo aónaamma móra-kanaama pááq ínatama keráwáqtí namuro-wáyúkámá íma móra-oqtamma yuwáiyana káqon-oqtakoni ámûraaqa wániye. máqtepaq yawítítuwaiyana marabí kumíniye.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","yemá Îtumma maará téta ítama aónaraae: “yirááti-nako, náa-kanaararaq mi-qtátááqá pááq íníyô? áqnáabaqa nóin-awaameraq pááq ínataa aónétaa mi-qtátááqá pááq íné iyé ténúnataabiyo?” téta tirááe. ");
INSERT INTO usa_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","ánibo Îtuma maará-tiraiye: “keráwáqá yabíqma arútáaro. yemá keráwáqá kaaqaari téta makátébo. taíbaq-wayukama ketíwîkaq iréta maará-tinoe. ‘kemá wemúne. maami-kánáámá íbêqa pááq kéiye.’ tínômanibo kerawáqá íma yinaaémma ko wáráaro. ");
INSERT INTO usa_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","anaaékaqa webómá kéeta anón-aaiqa kéoe tíyan-aimma itánómanibo kanaaráq íma ikatîqa oro. mirái-qtataaqa áqnáabaq pááq ínîmanibo aqtó-kánáámá páátákáámmá íma pááq íniye.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","móragaraq Îtuma maará-tima-yimikaiye: “móra-anna-wayukama káqon-anna-wayukama itó-uma ááiqa umáyikanoe. ánibo móra-kinini waayúkama itó-uma káqo-kinini wayúkate ááiqa ínoe. ");
INSERT INTO usa_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","ánibo maa-márábímmá anómma márûma kéyinana yaímma-aukapaq-marabaqa aáwaqa ánataginata yáayaba kéeta anó-karima mayánoe. ánibo taíbaq anómma táí-yataaqa aabayákáqá anón-awaameq-yataaqa pááq kéinana kéqokeq-yataaqa pááq ínna-waigoma keráwáqá mamá táaqa kamátikaniye. ");
INSERT INTO usa_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","miraímanibo mirái-qtataaqa íma pááq uráinayaba yemá keráwáqá yáqtoketa mamá táíq umátiketa monoq-náúpáq mamá tíkareta aamá ítama yainéta mamá ánná-naupaq tikánoe. yemá téta ketíwîqtaba mamá kíni-kayukararabi kámááni-wayukaraq tiwíqmeta wínoe. ");
INSERT INTO usa_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","ánibo mirá íya-waigoma keráwáqá mamá keqtábá kámááni-wayukama timá-yiminoe. ");
INSERT INTO usa_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","miráinaq keráwáqá mi-kánááráqá átê-wataama Áánûqtutaba kanaaráq timá-yiminoe. ");
INSERT INTO usa_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","kemá kenamáárîq arupú-aimma túyánákáq mamáráanana itaí-yátááqá timíniye. ánibo minnámo timá tíménna-aimma keráwáqtí namuro-wáyúkámá kanaaráq íaratinoe. ");
INSERT INTO usa_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","keqtibomá keqtinóma keráwáqtí móra-naaegoma keráwáqtí tibâqawaayuma keráwáqtí aanábómá mamá keráwáqtí namuro-wáyúkátí iyáápi mamá tikáiyata keráwáqá tíkamma keráwápikémá yaímma puínoe. ");
INSERT INTO usa_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","kekákéné téta máqte-kayukama keráwáqá tiwáágínomanibo ");
INSERT INTO usa_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","keráwáqtí tiqnótáugoma mórama íma múkiniye. íma tíkamma puínoe. ");
INSERT INTO usa_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","keráwáqá akoqnáá umá kéyaqtoraapoata keráwáqtí túwaraimma paá mánoe. ");
INSERT INTO usa_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","miráimanibo anaaékaqa keráwáqá aónáíyata ááiq-i-wayukama Yérútááre-maruqa yaikutíyaqa keráwáqá kanaaráq mikáq aónéq márûqa mamá táíq í-kánáámá pááq iyé tínoe. ");
INSERT INTO usa_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","mi-kánááráqá Yúría-marupaqo máraiya-kayukama péqmareta anubaq kóoro. ánibo yaímma-wayukama Yérútááre-marupaqo máiya-kayukama mi-márúqá yuwéraq ôpaq kóoro. ánibo márûkoni aaumépaqo máiya-kayukama ókaraq yauwéqma mi-márúpáqá íma úyoro. ");
INSERT INTO usa_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","maami-kánáámá anónnáma táí-meyamma mayaí-kánáábóana máqten-aimma Áánûqtuni watáama agamatá-kánnáábímá wáin-aikoma abarokáq pááq éna arammá iyániye. ");
INSERT INTO usa_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","mi-kánááráqá aaramá yímûkaraq máa-noinikaraq iyápóma náámma kéyime-noinikaraqa tirunô. anómma ummaa-yátááqá maa-márábímmá pááq ínatama mi-kánááráq Ítíráaeo-wayukama Áánûqtuma áyámma umáyikaniye. ");
INSERT INTO usa_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","yaímma-wayukama tokóru-yakaa-punapo yemá yíkamma képuyeta yaímma-wayukama namuro-wáyúkámá yemmá ánnáma yímituweta Yéqtaaeo-wayukati aúkáapi mó-yikanoe. ánibo káqo-kayukati yítaukoma Yérútááre-maruqa yamá igárîq kéiyana mi-káyúkátí kanaamá ánataniye. ");
INSERT INTO usa_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","ókon-okomma awaaméq-yátááqá aabaúrárábi wíyokakaraq wiyókákáráqá pááq íniye. ánibo maa-márábímmá únókómá anó-iyama kémetainata máqten-anna-wayukati íyákoma táíq kéinata ikatîq ínoe. ");
INSERT INTO usa_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","maa-márábí máqte-qtataaqa pááq inéna ínayaba taíbaq-yuyanamma kéiteta ikatîq kéiyana yúgabaaq ínata kekaaq ínoe. aabayákákémmá wiyókómá kanageq ínípoata yeqtí aakakémá yaráqme wéyáwé ínoe. ");
INSERT INTO usa_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","mi-qtátááqá pááq ínata káonaiyana Waayúkagoni Áráaqa móra-konnakaq kumínímma anómma akoqnáágaraq tágama-yataakaraq kumíniye. ");
INSERT INTO usa_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","anaaékaqa mi-qtátááqá áaimma átáma pááq ínaqa mi-kánááráqá keráwáqá itó-ureq múte aónaaro. Áánûqtuma yauwéqma tiwirání-kanaama íbêqa waaqókáq wáiye.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","móra waéqma itaí-áímmá Îtuma maará téna timá yímikaiye: “keráwáqá warímukaraq káqo-tagaraq aónaaro. ");
INSERT INTO usa_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","aónáawana aúgen-anama amúmma máráitaqa ‘íbêqa yó-kánáámá iyé’ téq káonaae. ");
INSERT INTO usa_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","móraiq umá keráwáqá aónáiyana mi-qtátááqá pááq ínaqa kanaaráq keráwáqá aónanoe. Áánûqtuma yabíkái-maruqa waaqókáq áaimma átáma yínéna kéiye. ");
INSERT INTO usa_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","kemá keráwáqá áraimma kétima-timune. aarawaamá maa-kánááráqá íma pukáiyata máqtemma mi-qtátááqá Yérútáárebaq pááq ínoe. ");
INSERT INTO usa_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","aabayákáráq maa-márágáráq ánatanimanibo ketáagoma íma ánataniye. ");
INSERT INTO usa_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","miráimanibo keráwáqá atéráaro. keráwáqá paá túraq wáni-qtataaqtaba taíbaq-tuyanamma ítáabo. íma netuqá omáq-ááwákáqá wááéni-nokaraq íma nánómanibo mirá-qtátáákómá mamá yawááq-umatikainanama kanaaráq uyátárai-nakoni kumíní-kanaagoma páátákáá keráwáqá yáqtoraniye. ");
INSERT INTO usa_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","mirá-kánáámá maa-márábí máiya-kayukaraq waakákoraa umá pááq íniye. ");
INSERT INTO usa_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","aati-aatimá keráwáqá kawáá umátuwe máero. miráinaq keráwáqá mirái-qtataaqa pááq ínna-waigomma kótanoqtabama Áánûqtukaq nunamummá tíq-tiq kéiyana akoqnááma timíno. Waayúkagoni Áráakoni aúbáq kanaaráq itó-inoe.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","máqte-kanaaraqa Îtuma anó-monoq-naupaq aarawaamá kéyiraatena nokáámma Óríbêti-anuraq aúmá ko kéwaine. ");
INSERT INTO usa_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","ánibo aarawaamá nokáapaq itó-uma Îtunopaq iréta wení watáama anó-monoq-naupaq yama itéwaone. ");
INSERT INTO usa_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","aokaq-kánáámá yammá paá irabí agamá naí-kánáámá áwîqa kótámaki-kanaama pááq inéna uráiye. ");
INSERT INTO usa_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","uyátárai-monoq-wayukagaraq ámáan-aimma yirááti-wayukagaraq Îtumma ikamínónaqtaba abáá-uraamanibo aarawaatí yáaqa ikátaae. ");
INSERT INTO usa_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","ánibo Tááqtaama Yúqtaatini áyáqnobaq pékaima óq-awiqa Itikááriotie. wemá tiyááka umá abapaké kaayaq-íyápó-ánnábíkéné. ");
INSERT INTO usa_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","ánibo wemá Yúqtaatima uréna uyátárai-monoq-wayukagaraq anó-monoq-naupake kawáá-wáyúkágáráq watáama téna Îtumma mamá yeqtí iyáápi maránín-aimma mó-tiraiye. ");
INSERT INTO usa_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","miráitata yemá yimuqá kémareta yaímma-moneqa Yúqtaatimma amínón-aimma téite urááe. ");
INSERT INTO usa_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","ánibo yeqtí yáaraq Yúqtaatima kanaaráré timátuwena Îtumma awíqma iyáápi maránín-aqtaba abáá-uraiye. taíbaq aarawaamá Îtute íma yagaroqtamá máiyana-awaatare téna awé uráiye. ");
INSERT INTO usa_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","aokaq-kánáámá yammá paá irabí agamá naí-kánáámá pááq uráiye. mi-kánááráqá mórama tipi-típi-naateqa ikaméwaone. ");
INSERT INTO usa_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","miráitana Îtuma Pítaayaa Yóáanemma timáyíkáitata óyana maará-tima-yimikaiye: “kenákámá uréka kótámaki-kanaaraq-aawaqa móma yokaa íyataa naano.” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","ánibo yenákámá maará-tiraaye: “kerátámá náakaraq aáwaq mó-yokaa óyúyô?” téta tirááye. ");
INSERT INTO usa_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","ánibo Îtuma maará-tima-yimikaiye: “ítáakao. kenákámá anó-marupaqa Yérútáárebaq uyáberaiyana móra-nakoma anó-tawebi nommá yaqména kéinarake aapaqá kenákámá timónáí-nakama kenákámá min-nákóní anaaé waqmé wíyana wemá ko peraínna-naupaq ko péráákao. ");
INSERT INTO usa_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","min naakóní aboámmá maará téka timá ámekao: “yirááti-nakoma eqtábá maará-tiye. ‘ketí iyápó-annate kótámaki-aawaqa nánúnnama umá aráqmata-namma náanaq wáiyo? tiyé téka timá ámekao.’ ");
INSERT INTO usa_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","mirá tíyana yanaa móra amá aráqmatama anón-namma aáwaqa naí-yáárégáráq abíqtátágáráq wái-namma tiráátíno. miráinaka kenákámá min-náúpáq kótámaki-aawaqa mamá yokaa okao.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","ánibo min-nákámá uréta Îtuma tiníq umá aónatuweta yenákámá kótámaki-aawaqa yokaa urááye. ");
INSERT INTO usa_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","kanaamá pááq umágitata Îtuma wení iyápó-annagaraq yaareráq máqe-uraae. ");
INSERT INTO usa_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","ánibo Îtuma maará-tima-yimikaiye: “kemmá keráwáqtábá ôriq umá tíkáipoaq kótámaki-aawaqa áqnáabaq keráwátê nátuweq anaaékaqa tíqa í-yátááqá mayánúne. ");
INSERT INTO usa_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","kemá keráwáqá kétima-timune. kemá kótámaki-aawaqa ókaraq íma nanúnamanibo kótámaki-kanaagoni awaaméqá pááq ínna-yupaama Áánûqtuma yabíkái-marupaqa ókaraq nánúne.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","ánibo Îtuma móra-kaapuma maténa Áánûqtukaq ‘tíkáiye’ timátuwena maará-tiraiye: “keráwáqá maaminnáma matéraq yaímma timakaq oro. ");
INSERT INTO usa_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","kemá keráwáqá kétima-timune. wááéni-nomma ókaraq íma nánúnamanibo Áánûqtuma yabíkái-qtataakoma pááq íni-kanaaraqa wááéni-nomma ókaraq nánúne.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","ánibo keqnáámmá Îtuma yammá maténa Áánûqtukaq ‘tíkáiye’ timátuwena mapámma yímítuwena Îtuma maará-tiraiye: “maannáma ketúmiye. keráwáqtábáé téq kétimune. keráwáqá mirá kéeraq keqtábá túyánámmá ítáaro.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","anaaékaqa yemá nátuweta keqnáámmá wááéni-nokaraq káápuma maténa maará-tiraiye: “maa-káápúmá Áánûqtuni aúgemma anón-anon-aimma timá kéyarutikaitana ketí naaenápó mamá káraapaiye. miráitana ketí naaegómá keráwáqtábá kátigiye. ");
INSERT INTO usa_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","miráimanibo aónaaro. paá-tubi maránî-nakoma ketê aáwaqa naí-yááréráq máiye. ");
INSERT INTO usa_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","owé. Waayúkagoni Áráaqa naayóbáqá Áánûqtuma timákárain-amma waránéna kéiye. miráimanibo min-nákóma kemmá mamá namuro-wáyúkátí iyáápimmo maránî-nakoma anómma táí-meyamma wemá mayániye.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Îtuma mirá-timatuwaitata iyápó-annama yeíyáá wenita-wenita kéeta “náawaq mirán-ááímmá tarôq íníyô?” tirááe. ");
INSERT INTO usa_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","ánibo iyápó-annama móra aamá téite kéeta náawabi yeqtí aúkáapimma uyátá-maqma anómma máiye téta téite kéowana ");
INSERT INTO usa_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Îtuma maará-tima-yimikaiye: “káqon-anna-wayukati anó-kinimma wení akoqnáárake waayúkama yabíqyíkarena maami uyátáraa-kayukama ‘waayúkati aanábóé’ téta yenamáárîq yetábá kéte. ");
INSERT INTO usa_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","miráinaq keráwátê móraiq íuraiye. ímiye. keráwáqtí aúkáapimma uyátá-maqma anó-nakoma paá-nakoraa umá maíno. áqnáabariq umá maínna-nakoma wemá paá kaayóq-nákáá umá maíno. ");
INSERT INTO usa_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","náawaq uyátá-maqma anómma máiyo? aáwaqa naíráqô mái-narabi mayaí-nákómá aáwaqa ikámmena máma ámínarabiyo? min-náqá aáwaqa naíráqô maraq mái-nakoma wemíye. miráimanibo kemá keráwáqtí aúkáapi kaayóq-nákóráá umá máune. ");
INSERT INTO usa_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","taíbaq-kanaama kekáq táí-yataakoma pááq kéitaq keráwáqá ketê máqe uréq kemmá íma tiyúkaane. ");
INSERT INTO usa_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","ketibomá Áánûqtuma wé yabíkái-maruqtaba náápaamma kemmá tímikainiq umá keráwáqá móraiq umá kétimune. ");
INSERT INTO usa_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","annaékaqa kemá yabíkáuna-marupaqa aáwaqa naí-yááréráq máeq aáwaqa néq nommá néq ínoe. ánibo keráwáqá náápaakaraq-abitataraq maéq Ítíráaeobake tiyááka umá kaayaq-ánná-wáyúkátí aamá ítama yainaí-wáyúkámá mánoe.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Pítaamma Îtuma timá ámikaiye: “Tááímonio, Tááímonio, emá itaao. Tááqtaama keráwáqá makaténa ítama aónéna itana Áánûqtuma ‘mirá-uwo’ timá ámikaiye. ");
INSERT INTO usa_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","kemá Áánûqtukaq nunamummá tiráunaboana áwáqnaa ínana ení itáíq-itaiq-yataakoma íma puíniye. anaaékaqa emá yauwéqma kekáq yéma kanaaráq enabáqâwaayuma mamá akoqnáá umáyikaao.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","ánibo Pítaama maará-tima-amikaiye: “uyátáraana-nako, kemá etê ánná-naupaq ónáae téq yokaa kéune. kemá etê puyónáae téq yokaa kéune.” téna Pítaama Îtumma timá ámikaiye. ");
INSERT INTO usa_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","ánibo Îtuma maará-tiraiye: “Pítaao, kemá emmá kétimamune. íbêq-nokaamma kokórigoma áama ítirainaa emá té ‘kemá Îtumma íaonaraune’ té kaumobáq tinóne.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","maa-márábíké ummaa-yátááqá yeráwákáq pááq ínitanapoana Îtuma maará-tima-yimikaiye: “naayóbáqá kemá móra-aukapaq keráwáqá timátikaunaq uráamma keráwáqá kápi-unamma anó-unamma títauq-anaakaraqa íma mamé uráamma mi-kánááráqá móra-yataaqtabama uráanabi íyabiyo?” téna ítama aónaraiye. ánibo yemá yauwéqma maará-tiraae: “ímiye.” téta tirááe. ");
INSERT INTO usa_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","miráitana Îtuma maará téna timá yímikaiye: “íbêqa móra-nakoma kápi-unamma makénama paá mayaíno. anón-unamma makénama paá mayaíno. ánibo móra-nakoma tokóru-yakaa-puma ímo makénama wení kúberai-unamma mamá waayúkama kéyimena minnárake móneqa maténa mórama tokóru-yakaa-puma mayaíno. ");
INSERT INTO usa_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Áánûqtuni agamatá-kánnáágómá keqtábá maará kétiye. ‘otaa-káyúkábí ákaraae.’ tiráiniq umá maamin-áíkómá kekáqô pááq ína-yaqtaaqtabama áraimma pááq éna arammá iyaíno. owé. máqten-aimma keqtábá timá agatáan-aikoma íbêqa arammá iyáné iyé.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","ánibo yemá maará-tiraae: “uyátáraana-nako, emá aónaao. ketáámá tokóru-yakaa-puma kaayaqá matokáunatae.” téta tirááe. ánibo Îtuma yauwéqma maará-tima-yimikaiye: “kínna kanaaráqíye.” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Îtuma máápaq kumá yaúbarena aati-aatimá mirá éwainiq umá Óríbêti-anuraq uráiye. ánibo wení iyápó-annama anaaé waqmé urááe. ");
INSERT INTO usa_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","min-áúkápáq iréna Îtuma wení iyápó-annama maará-tima-yimikaiye: “keráwáqá Áánûqtukaq nunamummá kétiyana keráwáqá makáqma aónai-yataakoma keráwáqá íma makáqma aónáíno.” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","mikáké Îtuma mirá-timatuwena wení iyápó-annama iyuwéna pááqyamma abákákáá uráiye. mibáq araayutaúmmá aténa nunamummá téna maará-tiraiye. ");
INSERT INTO usa_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“ketiboó, emmá akáinaama kemmá tíqa í-yátááqá káápubikema ketôpake paábaq matuwaao. ááqibo ketí túyánámmá íma waréaq enaúyánámmá waraao.” téna Îtuma nunamupí tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","ánibo mórama Áánûqtunopake kaqtó-naqa kukéna Îtumma mamá akoqnáá umákaraiye. ");
INSERT INTO usa_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Îtuma áúnobaq maqmá aónaimma ôriq umá ummaa yamágitana nunamummá akoqnáá umá kétitana áúnobakemma imutigómá naaegóráá nommá auména marabí kuqturáiye. ");
INSERT INTO usa_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","nunamummá timátuwena itó-uma wení iyápó-annama máápaq uráiye. ánibo uréna aónaimma yemá yú waguráawana yimónaraiye. yeráwáqtí íyákoma ummaa yamágitataboata yúmá wagurááe. ");
INSERT INTO usa_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","ánibo Îtuma maará-tima-yimikaiye: “nôraq itaráq keráwáqá túmá wagurááô? keráwáqá itó-urera keráwáqá makáqma aónai-yataakoma makáqma aónaiyaba Áánûqtukaq nunamummá tero.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Îtuma aamá kétena máitata taíbaq-wayukama Yúqtaatini anaaé irááe. min-náqá Yúqtaati wemá minnâ tiyááka umá kaayaq-íyápó-ánnábíkénápóana wemá Îtuni-amakaq iréna ámôqnanena uráiye. ");
INSERT INTO usa_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","miráimanibo Îtuma maará-tima-amikaiye: “Yúqtaatio, Waayúkagoni Áráaqa paá-aubi maré á/môqnane kéono?” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","iyápó-annama Îtute máqeo-kayukama mi-qtátááqá áaimma átáma pááq íné immá aónatuweta maará-tiraae: “uyátáraana-nako, tokóru-yakaa-purake maami-káyúkámá yíkamonunataabiyo?” téta tirááe. ");
INSERT INTO usa_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","ánibo iyápó-annati aúkáapike móra-nakoma uyátárai-monoq-nakoni mayaí-náqá ikákena ayáánurapake aáqa áaipike agáutukaimanibo ");
INSERT INTO usa_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Îtuma minnâ aónatuwena maará-tiraiye: “ímira uwo.” téna tiráiye. ánibo Îtuma min-nákóní aákaq ayáámma ánékuitana min-áárárákómá keqnáámmá íráqôniq uráiye. ");
INSERT INTO usa_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","uyátárai-monoq-wayukayabagaraq anó-monoq-naupaq-kawaa-wayukayabagaraq anó-kayukayabagaraq iréta Îtumma yáqtorane o-káyúkáyábá Îtuma maará-tiraiye: “keráwáqá tokóru-yakaa-pugaraq yaákáráq umá mamé iréq kemmá otaan-áráq yákéikuto?” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","máqte-kanaama kemá keráwáqtê anó-monoq-naupaq máqe uráunamanibo kemmá íma tínêkukaane. miráimanibo maamin-áwáátáqá minnâ keráwákaráq kumayuq-yátáákóní akoqnáágaraq pááq iyé.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Îtuma mirá-timatuwaitata yáqtoqma awíqmeta kóuraae. yemá Îtumma awíqmeta mú mikákáá anó-monoq-nakoni naaúpaq urááe. ánibo Pítaama anaaé waqména uréna nékaq ko máqe-uraiye. ");
INSERT INTO usa_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","kurumá umá yáútúmakaapapoana naamátûpaq iramá agamaréta yaímma-wayukama máawana Pítaama mibáq ya máqe-uraiye. ");
INSERT INTO usa_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","móra-inikoma aónaimma Pítaama iraráq máitana min-ínímmá mayaí ínípóana Pítaamma káonena maará-tiraiye: “maa-nákógáráq Îtute máqe-uraiye.” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","miráitana Pítaama ‘ímiye’ tiráiye: “maan-íníkô, kemá Îtumma íaonaraune.” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","anaaékaqa pááqya-kanaama matáaena káqo-nakoma Pítaamma káonena maará-tiraiye: “egáráqá emá Îtun-annabikemone.” téna tiráiye. miráitana Pítaama maará-tiraiye: “maan-nákô, kemá ímiye.” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","anaaékaqa pááqyamma aayáqtáá-kanaama yáwitana móra-nakoma akoqnáá-aimma téna maará-tiraiye: “áraine. maan-nákómá Îtute máqe-uraine. wemá Kááriribake-naqiye.” téna tiraíye. ");
INSERT INTO usa_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","ánibo Pítaama maará-tiraiye: “maan-nákô, minnámô ténnama kemá íma káonaune.” téna Pítaama kétitana páátákáá kokórigoma áama tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","ánibo uyátárai-naqa Îtuma waéqma Pítaamma aónaraiye. naayóbáqá wemá maará téna Pítaaqtaba tiráine. ‘mi-nókáámmá kokórigoma áama íma tiráinaa kaumobáq té keqtábá íaonaraune tinóne.’ tiráin-aimma Pítaama yauwéqma aúyánámmá ítaraiye. ");
INSERT INTO usa_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","ánibo Pítaama máápaq kumá yaúborena ibiqá ôriq umá yakáiye. ");
INSERT INTO usa_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Îtumma yáqtóráa-kayukama aábê-aimma kétimaketa ikákaae. ");
INSERT INTO usa_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","yemá tabaráábenapo Îtuni aúrapi yawááq-umakareta maará téta ítama aónaraae: “emá amuné kutuwo. emmá náawa kéikamiyo?” téta tirááe. ");
INSERT INTO usa_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","ókaraq-okaraq umá táí-aimma timá awááguraae. ");
INSERT INTO usa_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","aaqá utamákaitata Ítíráaeobake anó-kayukagaraq ámáan-aimma yirááti-wayukagaraq uyátárai-monoq-wayukagaraq mórabi áíkuteta yemá Îtumma awíqmeta yeqtí káánítóre-wayukaraq uréta maará-tiraae: ");
INSERT INTO usa_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","“emá keqtáá timá-timiyo. emá Metáiyabono?” téta Îtumma ítama aónaraae. ánibo Îtuma maará-tiraiye: “kemá keráwáqá timá tíménaqa íma ítama arutéq tirummá timínoe. ");
INSERT INTO usa_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","ánibo kemá keráwákáq yaímma-aimma ítama aónaanaqa keráwáqá ketáaraqa íma yauwéqma tínoe. ");
INSERT INTO usa_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","miráimanibo íbêkaraq anaaékakaraqa aati-aatimá Waayúkagoni Áráaqa máqten-akoqnaagaraqa Áánûqtuni ayáánurapaq maraq mániye.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","máqtemma maará-tiraae: “miráitaa emá enamáárîq Áánûqtumma áanikowabono?” téta Îtumma ítama aónaraae. ánibo Îtuma maará-tima-yimikaiye: “keráwáqá mi kête. minnâ kemúne.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","ánibo yemá maará-tiraae: “ketáámá ókaraqa nóin-ainaq itánátaawaq kéuno? wenóyaupike min-áímmá titaqtaa áqa ítátuwaunataae.” téta tirááe. ");
INSERT INTO usa_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","miráitata máqtemma itó-uma ánateta Îtumma awíqmeta Pááíratikaq urááe. ");
INSERT INTO usa_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","yemá áaimma átáma aamá ítama yainéta maará-tiraae: “ketáá maan-náqá aónáunataama ke-ánná-wáyúkábímmá túyánátáá mamá táítawaa kéiye. táákiti-moneqa Títaamma amíyábá aammá káutikaitaae. ánibo wenamáárîq wetábá téna ‘kemá Metáiyama kínimune kétiye.’ téta tirááe. ");
INSERT INTO usa_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","ánibo Pááíratima Îtumma maará téna ítama aónaraiye: “emá Ítíráaeo-wayukati kíninabono?” téna tiráiye. ánibo Îtuma maará téna yauwéqma timá ámikaiye: “emá enamáárîq mi kétene.” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","miráitana Pááíratima uyátárai-monoq-wayukagaraq aarawaamá maará-tima-yimikaiye: “maan-nákóní otaa-qtátááqá íma káonaune.” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","ááqibo yemá akoqnáá umá maará-tiraae: “wemá aarawaamá watáama kétima-yimitata Yúría-aukapaq-wayukama yaíkaaq uréta ááiqa urááe. Kááriri-aukapake áaimma átárena mirán-ááímmá tarôq umáena maa iráiye.” téta tirááe. ");
INSERT INTO usa_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pááíratima min-áímmá itáá ena maará téna yemmá ítama aónaraiye: “maan-náqá Kááriribake-narabiyo?” téna Pááíratima tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","ánibo Pááíratima ítaraimma Îtuma min-áúkápáqá Érôtima yabíkáin-aukapakenapoana Îtumma timákáitana Érôtinopaq uráiye. mi-kánááráqá Érôtima Yérútáárebaq máqe-uraine. ");
INSERT INTO usa_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Érôtima Îtumma aónatuwena amuqá ôriq umá kémarena naayóbáqá wemá Îtun áama ítátuwena ‘wemmá aónanaae’ tiráine. Érôtima téna Îtuqtaba móra awaaméq-yátáárîq ínaq aónanaae tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","miráitana Érôtima máqte-qtataaqtaba Îtukaq ítama aónaraiye. miráimanibo Îtuma íma móra-aimma yauwéqma Érôtimma timá ámikaiye. ");
INSERT INTO usa_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","uyátárai-monoq-wayukagaraq ámáan-aimma yirááti-wayukagaraq Îtuni amakaq ya itó-ureta akoqnáá umá Îtumma aamá timákaraae. ");
INSERT INTO usa_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","ánibo Érôtigaraq wení ááiq-i-wayukagaraq Îtumma mamá aábê-aimma timáketa ánnánaiq kéumaketa yemá mórama íráqô-kaqtoma matéta Îtumma iyákátuweta Pááíratinopaq timákáawana yauwéqma uráiye. ");
INSERT INTO usa_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","naayóbáqá Érôtima Pááíratite namuroíq urááyane. ánibo íbêqa maan-áwáátáqá min-nákámá aanábómá aúkááye. ");
INSERT INTO usa_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pááíratima uyátárai-monoq-wayukama kawáá-wáyúkámá aarawaamá yááyaitata ya áíkutaae. ");
INSERT INTO usa_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","ánibo Pááíratima maará-tima-yimikaiye: “keráwáqá maan-náqá ketôpaq awíqme iréq maará kéte ‘aarawaatí yúyánámmá mamá táíq kéiye.’ kéte ánibo min-áíqtábá keráwáqtí túrakaq wemmá ítama aónaraune. ánibo ítáaro. keráwáqá aamá ítama yaínáa-waigoni áaimma maami-nákópíkémmá otaa-qtátááqá íma káonaune. ");
INSERT INTO usa_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Érôtigaraqa miráuma otaa-qtátááqá íma aónaraiye. miráitana wemá ketôpaq timákáitana yauwéqma iráiye. ítáaro. maan-nákómá móra-yataariq íuraipoataa íma ikámma puyónúnataae. ");
INSERT INTO usa_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","miráinaq kemá tebûqa ámîtuweq timákáanana wíniye. ");
INSERT INTO usa_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","miráimanibo mórama maarán-ááímmá wáiye. máqtemma kótámaki-aawaqa naí-kánááráqá Pááíratima móra ánnábike-naqa ayúbákainana kóiniye. ");
INSERT INTO usa_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","ánibo máqtemma aarawaagáráq yemá maará téta anókaq ááyama tirááe: “min-náqá ikámínana képuinaa Baráábatima ayúbákénana ketôpaqtaa yíno.” téta ááyama tirááe. ");
INSERT INTO usa_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Baráábatima móra-marukaq kámááni-wayukate ááiqa umátuwena móra-naqa ikámítana púitata ánná-naupaq ákáraane. ");
INSERT INTO usa_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","ánibo Pááíratima ókaraq mi-káyúkámá aamá timá yímikaiye. wemá Îtumma ayúwáanana kóikaae tiráimanibo ");
INSERT INTO usa_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","yemá maará téta ááyama tirááe: “kaapaq-yátáq ikámma aráápaao. kaapaq-yátáq ikámma aráápaao.” téta ókaraq-okaraq umá tirááe. ");
INSERT INTO usa_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","ánibo kaumobáq Pááíratima timá yímikaiye: “nôraq inábiyo? maamin-nákómá nóin-otaanaq kutáíyô? mórama otaa-qtátááqá wepímmá íma káonaunaboataa íma ikámma puyónúnatae. miráinaq kemá tebûqa ámítuweq ayúwáanana kóiniye.” téna Pááíratima tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","miráimanibo yemá uyátá-maqma akoqnáá anókaq ááyama téta ‘kaapaq-yátáq ikámma íyakaao.’ tirááe. ánibo yeqtí yáagoma Pááíratin áama uyátáraiye. ");
INSERT INTO usa_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","miráitana Pááíratima aamá ókaraq íma téna yeráwáqá teníq uráiye. ");
INSERT INTO usa_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","min-nákómá kámááni-wayukate ááiqa umátuwena móra-naqa ikámítana púitata ánnáma ámíkaa-naqa yauwéqma awiránáae téta aarawaamá tewana Pááíratima ayúwáitana yetôpaq uráiye. ánibo aarawaatí yúyánámmá waréna Pááíratima Îtumma yeqtí iyáápi makáiye. ");
INSERT INTO usa_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","yemá Îtumma awíqmeta kówana móra-naqa Tááímonimma Tairínibake-naqa yáqtokaamma min-nákómá íbêq wení naaópake iréna anó-marupaq wínéna kéitata yemá min-nákóní ábûkaq kaapaq-yámá abákáawana aqména Îtuni anaaé waqmé uráiye. ");
INSERT INTO usa_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","taíbaq-wayukama Îtuni anaaé waqmé kéowata taíbaq-noinimma ibiqá kéyareta yiruqtabá umákaraae. ");
INSERT INTO usa_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","miráitana Îtuma waeréna maará-tima-yimikaiye: “keráwáqá Yérútáárebake-noinine. keráwáqá keqtábámá ibiqá íma yáráaro. paá keráwáqtábábi keráwáqtí iyápóyaba ibiqá yáráaro. ");
INSERT INTO usa_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","ítáaro. anaaékaqa mi-kánáámá pááq ínatama keráwáqtí iyápóyaba ibiqá yaráiya-kanaaraqa maará tínoe. ‘aaramá íma kanaaráq iyápóma ákáraiyamma anaamoq-nóínímmá iyápóma náámma ímo kámiya-noinimma yemá yimuqá maránóe tiráine.’ ");
INSERT INTO usa_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","mi-kánááráqá anugóqtábá maará tínoe. ‘keráwáqá kítímera tímûraataa yama yawááq oro’ tínoe. ánibo pááqyan-anugoqtaba maará-tinoe. ‘keráwáqá keqtáá yawááq oro.’ tínoe. ");
INSERT INTO usa_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","íbêqa kemá íráqô-tagoma anommá wáinna-yagoqtabama mirá éqa keráwáqá aayámmá kamáguraina-yagoqtabama anaaékaqa náaraq ínô?” téna Îtuma mirá-tiraiye. ");
INSERT INTO usa_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","yemá káqo-nakaratagaraq otaamá kuyóyanakaboata yiwíqmeta urááe. mi-kááyáq-nákárátágáráq Îtukaraq mórabi yíkamineta urááe. ");
INSERT INTO usa_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","yemá móra-marukaq uráámanibo mi-márúkóní áwîqa aqnón-ayaaqtapare. mi-márúkáq Îtumma ikámma kaapaq-yátáq íyakaraae. ánibo yemá otaa-nákárátágáráq yíkamma kaapaq-yátáq ítaae. móra-waigomma Îtuni ayáánurapaq ikámma iyéta káqomma ayáánepaq ikámma íyaketa urááe. ");
INSERT INTO usa_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","ánibo Îtuma maará-tiraiye: “ketiboó, emá yeqtí kúmiq-yataaqa mamá paábaq yuwé awikátuwaao. maami-qtátáárîq o-wáígóní áaimma yemá íaonaraae.” téna Îtuma tiráiye. ánibo yemá aábêma yaréta Îtuni unáákáqtôma yáátáá urááe. ");
INSERT INTO usa_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","aarawaamá itó-uma máeta karáqtuwe máqe-uraae. ánibo kawáá-wáyúkámá Îtumma akáyáámmá timáketa maará-tiraae: “wemá káqo-kayukama yíwáqnaa éwaimanibo wemá Metáiyamo máenama kanaaráq wemá wenamáárîq áwáqnaa íno.” téta tiraae. ");
INSERT INTO usa_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","ááiq-i-wayukagaraq Îtumma aábê-aimma timákaraae. yemá waaqókáq iréta ikaaq-wááéní-nómmá amínéta ");
INSERT INTO usa_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","maará-tiraae: “áraimma emá Ítíráaeo-wayukati anó-kinimma máema kanaaráq enamáárîq áwáqnaa uwo.” téta tirááe. ");
INSERT INTO usa_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","aqnókáq agamáráa-waigoma maará-tiraiye: “maan-náqá Ítíráaeo-wayukati anómma yabíkái-nare.” ");
INSERT INTO usa_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","mi-kááyáq-nákámô yíkamma ímaraa-nakaratabike móra-nakoma maará téna Îtumma áyoqa atáiye: “Metáiyawabono? kanaaráq emá enamáárîq áwáqnaa kée kekárátágáráqá tíwáqnaa uwo.” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","miráitana káqomma móra-nakoma min-áímmá ítátuwena maará téna awááguraiye: “emá wetê móraiq umá ummaa-yátááqá kémayaane. emá Áánûqtuní áaqa íya kéikateno? ");
INSERT INTO usa_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","kerátátí anónnáma ummaatamá mayaúye. miráimanibo maan-nákómá Îtuma otaa-qtátáárîq íuraiye.” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","min-nákómá keqnáámmá Îtumma timá ámikaiye: “Îtuo, anaaékaqa emá anó-kinimmo auréma mi-kánááráqá emá keqtábá aúyánámmá itaao.” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","ánibo Îtuma yauwéqma timá ámikaiye: “kemá áraimma kétimamune. íbêqa emá Áánûqtuma yabíbái-marupaqa ketimakaq mánone.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","íbêqa aabaúgómá aúkáamakaa kéitana aabaúmá pékitana máqte-marabaqa kumayuqá aúqma wáqe-itana aabaúgómá kaumoráq kumáwéna énáikariq uráiye. ");
INSERT INTO usa_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","ánibo Áánûqtunopaqa aammá aúmareta oqtaráq anó-tabaraabema anó-monoq-naupaq abíkúmaraamma aúkáapike yakáqma kaayaq-átóîq uráiye. ");
INSERT INTO usa_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","ánibo Îtuma anókaq maará téna ááyama tiráiye: “ketiboó, kemá ketí taáma enayáápi kémaraune.” kétena Îtuma pukáiye. ");
INSERT INTO usa_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","ááiq-i-wayukati kawáá-nákómá mi-qtátááqá pááq immá aónawaaena Áánûqtuni áwîqa múte yauyéna maará-tiraiye: “áraine. maan-náqá arupú-nare.” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","máqte-kayukama yagutéta omáqá aónémáa-kayukama mi-qtátááqô pááq immá aónatuweta yiruqtábá kéeta yaákaq kéyabiteta naaúpaq kóuraae. ");
INSERT INTO usa_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","máqtemma Îtuni aanábó-wáyúkágáráq yaímma-noinimma Kááriribake iréta Îtuni anaaé waqmé ye-nóíníkáráq yemá nékaq ya itó-uma máeta máqte-qtataaqa pááq immá aónaraae. ");
INSERT INTO usa_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","móra-naqa máqe-uraimma áwîqa Yótêbie. wemá Ítíráaeo-wayukati móra-maruqa Aarimaatéabake-nare. wemá íráqômma arupú-napoana káánítóre-naqiye. ");
INSERT INTO usa_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","miráitana wemá káqo-kaanitore-wayukati yúyánámmá íma warénamanibo Áánûqtuma yabíkái-kanaama awé éwaine. ");
INSERT INTO usa_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","miráitana min-nákómá Pááíratikaq uréna Îtuni arááq-auma mayánîqtaba ítama aónaraiye. ");
INSERT INTO usa_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","miráitana min-nákómá arááq-auma maména kukéna wayá-tábáráábénápó múqmútuwena móra-oqta-murianobaqa mó-utamakaraiye. mi-múríánóbáqá anmón-oqtamma kubaútuweta tarôq urááe. ánibo naayóbáqá móra-naqa íma uqtamákáraapine. ");
INSERT INTO usa_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","minnáma aokaq-kánáágóní kótámaki-aawaqa yokaa kéiyana Tabaatimá pááq inéna uráiye. ");
INSERT INTO usa_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Kááriribake iréta Îtute ye-nóinímmá yemá Yótêbimma anaaé waqmé uréta mi-múríánóbáqá aónaraae. ánibo Yótêbima náaraq umáwaq Îtuni arááq-auma uqtamákaniyo téta minnágaraq ko aónaraae. ");
INSERT INTO usa_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","yemá aónatuweta yeqtí-naaopaq yauwéqma kóureta átê-akuqa i-mátáwémmá Îtuni arááq-auraq pérakaneta mamá yokaa urááe. ánibo ámáan-aikoma tiráiniq umá Tabaatiráqá paá aagarááe. ");
INSERT INTO usa_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Tótaaraqa nokáapaq yaúbatuweta aaranaammá Îtumma uqtamákaraa-murianobaqa urááe. yemá áqnáabaqa átê-akuqa i-mátáwémmá yokaa umáráapoata maméta urááe. ");
INSERT INTO usa_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","yemá aónaamma óqtamma muríákóní ótaq aúyaqmaraan-oqtamma paábaq aukátukaae. ");
INSERT INTO usa_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","ánibo yemá mi-múríánóbáqá kumábéketa aónaamanibo uyátárai-naqa Îtuni arááq-auma íaonaraae. ");
INSERT INTO usa_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","yemá minnáyaba taíbaq-yuyanamma kéitaawana páátákáá kaayaq-nákórátá yimakaq itó-uraayamma yeqtí unáákáqtôrakemma aakáá kamá tágaraiye. ");
INSERT INTO usa_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","mi-nóínímmá ikatîq éta awaúteta yúramma marabí aónarae. miráitata mi-kááyáq-nákórátá maará-tima-yimikaaye: “pukáa-kayukati aúkáapimma nôraq itaráq paá mái-nakoqtaba abáá kéoo? ");
INSERT INTO usa_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","wemá maakáqá íma máibo wemá yauwéqma itó-umaguraiye. naayóbáqá Îtuma Kááriribaq máena keráwáqá timá tímikain-aimma túyánámmá ítáaro. ");
INSERT INTO usa_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","wemá téna ‘yemá Waayúkagoni Áráaqa kúmiq-wayukati iyáápi mamá yikaíyata yemá ikámma kaapaq-yátáq ímaraiyana kaumo-kánáámá ánatainanama itó-iniye.’ tiráine.” téta tirááye. ");
INSERT INTO usa_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","naayóbáqá Îtuma mirá-tiraipoata yúyánámmá ítátuweta ");
INSERT INTO usa_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","yemá muríánóbáké yuwéta yauwéqma kóuraae. ánibo mi-qtátááqá aónatuwe yeqtábámá tiyááka umá títaupake móra-iyapo-annagaraq yaímma paá-wayukagaraq mó-tima-yimikaae. ");
INSERT INTO usa_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Maríaa Máátarini Yóáanaama Maríaama Yêmitimma anóama min-nóínímmá yemá máqe-uraae. min-nóíníkáráq káqo-noinimma yetê máqeokake yemá Îtuma awaaméqá umáyikena yiwíkai-kayukama mó-tima-yimikaae. ");
INSERT INTO usa_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","miráitata Îtuma awaaméqá umáyikena yiwíkai-kayukama téta paá aaramá uwáá-aimma kéte tiráámanibo min-áíqtábámá íma itáíq-itaiq umá yirummá yímikaae. ");
INSERT INTO usa_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","miráitanamanibo Pítaama itó-uma muríánóbáqá aónanena uyaaténa uréna ko awaútena kúreq umá aónaimma paá tabaráábe-waqtoma múqmúyakaama wáqe-uraiye. ánibo Pítaama yauwéqma naaúpaq ko máena minnáyaba taíbaq-auyanamma ítaraiye. ");
INSERT INTO usa_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","mi táoq yeqtí aúkáapike kaayaq-nákórátá maréta móra pááqya-maruqa Eméati urááye. min-ákómá Yérútáárebaqa yuwéna Eméatibaq uráimma ayáqtááqa (11 km) ayátáákakaane. ");
INSERT INTO usa_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","yenákámá kéweta aapaqá mi-qtátááqô pááq iqtábá téite umáeta urááye. ");
INSERT INTO usa_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","yenákámá aapaq kéweta wenita-wenita utéta kéoyana Îtuma wenamáárîq yimakaq iréna yenákátê yagaroqtamá uráiye. ");
INSERT INTO usa_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","miráimanibo Îtue téta yenákámá kanaaráq íaonaraaye. ");
INSERT INTO usa_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","ánibo Îtuma min-nákámá maará-tima-yimikaiye: “kenákámá nói-qtataaqtabawaq aamá téite umáekawaq aapaqá kéoyo?” téna ítama aónaraiye. Îtuma mirá-timatuwaitata min-nákórátátí íyakoma ummaa yamágitana yóikoma waemmá amáguraiye. ");
INSERT INTO usa_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","ánibo móra-nakoni áwîqa Karíopaatie. wemá yauwéqma maará-tiraiye: “taíbaqa ópaken-opake-kayukama Yérútáárebaqa máamanibo emá enamáa maami-qtátááqá Yérútáárebaq íbêqa pááq i-qtátááqá íyaq aónaraano?” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","mirá-timatuwaitana Îtuma maará téna min-nákámá ítama aónaraiye: “nói-qtataarabiyo?” téna titata yenákámá maará-tima-amikaaye: “mi-qtátááqá Îtuma Náátárêtibake-nakokaq pááq uráiye. wemá Áánûqtuni amunénápóana wemá Áánûqtuni aúrakarabi aarawaatí yúrakaqa akoqnáá-aimma tiréna akoqnáá-mayaima maténa kéiye. ");
INSERT INTO usa_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","ánibo ketááí uyátárai-monoq-wayukawabi anó-kawaa-wayukama yemá kámááni-wayukati iyáápi mamá ákáraae. ánibo kámááni-wayukama ikámôwana púítata yemá kaapaq-yátáq níri amá íyakaraae. ");
INSERT INTO usa_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","miráimanibo naayóbáqá maará téqtaa tiruqtáá ámikaunae. wemá maamin-nákómá yauwéqma Ítíráaeo-wayukama tiwiránénataa tiráine. ánibo móra-aikaraq wáiye. máqtemma mi-qtátááqá pááq urái-waigoma minnâ íbêqa kaumo-kánááráqá pááq kéiye. ");
INSERT INTO usa_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","ánibo íbêqa keqtáábíké yaímma-noinimma Îtuni anaaé waráa-noinimma yaímma-aimma timá tíméwataa iyánáaq kéunataae. aabáyaanapimma nokáapaq yaúbatuweta muríánóbáqá uréta ");
INSERT INTO usa_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Îtuni arááq-auma íaonaraae. ánibo yemá yauwéqma iréta maará-tiraae: “ketáá yaímma Áánûqtunopake kaqtó-wayukama yimónáunatataa kaqtó-wayukama maará-tiraae. ‘Îtuma paá máiye tirááe.’ téta tirááye. ");
INSERT INTO usa_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","ánibo keqtáábiké yaímma-wayukamma muríánóbáqá uréta aónaamma aaramô teníq umá paá wáqtôma aónaraae. yemá wemmá Îtumma íaonaraae.” téta tirááye. ");
INSERT INTO usa_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","ánibo Îtuma maará téna min-nákámá timá yímikaiye: “kenákámá íma túyánámmá kéitaaye. naayóbáqá Áánûqtuni amuné-wáyúkámá máqten-aimma tiráa-waigomma tirummá amíyábámá kenákátí tíyakoma yaáka-yaaka kéiye. ");
INSERT INTO usa_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","minnâ yauwéqma tiwiraí-náqá Metáiyama áqnáabaqa áíqa í-yátááqá maména anaaékaqa wení tágama-yataaqa mayánîqtabama íyaq kenákámá ítaraayo?” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","mikáké áaimma átárena Mótetini watáagaraq yaímma Áánûqtuni amuné-wáyúkátí watáama Îtuma timá yímikaiye. máqtemma agamatá-kánnáágómá wemá Îtuqtaba tiráimma máqtepaq áaimma timá yímikaiye. ");
INSERT INTO usa_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","óya-marupaq mi-káúmómá uráámanibo Îtuma miráuma abákákáá wínéna uráiye. ");
INSERT INTO usa_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","miráitata kaayaq-nákámá Îtumma timá yáqtoreta maará-tiraaye: “emá kerátátê mááo. aabaúmá kumáberane ipóana pááqya-kanaabi aaqá enániye.” téta tirááye. ");
INSERT INTO usa_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","anaaékaqa aáwaqa nánéta owana Îtuma yenákátê maraq máqe-uraiye. ánibo Îtuma yammá maténa Áánûqtukaq ‘tíkáiye’ timátuwena mapámma min-nákámá yímikaiye. ");
INSERT INTO usa_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Îtuma mirá-umatuwaitana min-nákátí yúrakoma tágamagitata Îtumma aónaraaye. ánibo Îtuma páátákáá aúyokena náakarabi kóitata min-nákámá íaonaraaye. ");
INSERT INTO usa_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","ánibo maará-tiraaye: “kerátámá aapaq kéyuyana wemá watáama kétima-timenarata agamatá-kánnáábíkén-áímmá áaimma titaka kétauyana kerátáí tíyakoratama íráqôniq uráiye.” téta tirááye. ");
INSERT INTO usa_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","mirá-timatuweta é mi táoq itó-uma Yérútáárebaq urááye. ánibo yenákámá tiyááka umá títaupake móra-iyapo-annagaraq yaímma yeqtí aanábó-wáyúkágáráq áíkuma máawata yimónaraaye. ");
INSERT INTO usa_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","mi-káyúkámá maará-tima-yimikaae: “áraine. uyátárai-nakoma yauwéqma itó-umaguraiye. Tááímonima wemmá aónatukaiye.” téta timá yímikaae. ");
INSERT INTO usa_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","miráitata min-nákámá máqte-qtataaqa aapaqô pááq itata aónááya-waigoni watáama téta wemá Îtuma yammá kítíma yímitata kéneta mikáké wemmá aónááyan-aimma tirááye. ");
INSERT INTO usa_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","yemá min-áímmá kéteta máawana Îtuma yeqtí aúkáapi itó-uraiye. ");
INSERT INTO usa_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","miráitata yemá iyánáaq umáreta waátáwaq káonaunaa téta ikatîq urááe. ");
INSERT INTO usa_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","ánibo Îtuma maará-tima-yimikaiye: “keráwáqá nôraq itaráq kégarateo? keráwáqá nôraq itaráq kaumo kááyaq-tuyanamma kéitaao? ");
INSERT INTO usa_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","keráwáqá tiyáánaa títauqa aónaaro. kemá Îtuma máune. tiyááma yuwaíyana ínaq maqmá aónaaro. kemmá túwaa tiyáátámma wáiniq umá waátágomma áúwaa ayáátámma íma wániye.” ");
INSERT INTO usa_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Îtuma mirá-timatuwena ayáánaa aítauqa níri-abuma yiráátiraiye. ");
INSERT INTO usa_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","yemá ‘áraine’ téta yimuqá kémaretamanio yirummá íma améta yemá netuq-yúyánámmá kéitaawana Îtuma maará-tima-yimikaiye: “keráwáqá yaímma-aawaqa maakáqá makááô?” téna ítama yimónaraiye. ");
INSERT INTO usa_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","ánibo yemá noyááqa agamáráamma áméwana ");
INSERT INTO usa_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Îtuma mi-nóyááqá mamá naitata mikáq aónaraae. ");
INSERT INTO usa_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","ánibo Îtuma maará-tima-yimikaiye: “kemá naayóbáq keráwáqtê máeq keráwáqá timá tímíqma ánataraunae. naayóbáqá Mótetini ámáan-aipinabi yaímma Áánûqtuni amuné-wáyúkátí agamatá-kánnáábímá Tébitigaraqa keqtábá tiráama minnâ máqten-aimmo tiráa-waigoma arammá iyaíno.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","ánibo Îtuma iyápó-annati yúyánámmá mamá tágamayikaitata yemá Áánûqtuni agamatán-áúbámá yoráuma aónaraae. ");
INSERT INTO usa_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","ókaraq Îtuma maará-tima-yimikaiye: “Áánûqtuni watáama agamatá kánnáágómá maará-tiráiye. ‘Metáiyama yauwéqma yiwiraí-nákómá aíqa í-yátááqá mayéna pukáinabike kaumo-kánááráqá yauwéqma itó-iniye.’ ");
INSERT INTO usa_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","ánibo áwîqtabama máqten-anna-wayukabi kétiyata yemá yirummá waeraíyana Áánûqtuma yeqtí kúmiq-yataaqa mamá paábaq matuwéna awikamáyikaniye. maamin-áímmá Yérútáárebake áaimma átáma téraq ");
INSERT INTO usa_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","keráwáqá aónaraa-qtataaqtabama min-áímmá timá yíméro. ");
INSERT INTO usa_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","ítáaro. naayóbáqá ketibomá Áánûqtuma akoqnáá umá tirái-qtataaqa keráwákáq kenamáárîq timákáanana kumíniye. ááqibo keráwáqá mi-márúkáq máiyana Áánûqtuni akoqnáágoma keráwáqtôpaq kumíno.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Îtuma wení iyápó-annama yiwíqmena Béqtanibaq uráiye. wení ayáámma múte yaútena wení iyápó-annaraq waaroqá yímikaiye. ");
INSERT INTO usa_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","wemá Îtuma waaroqá kéyimitana Áánûqtuma Îtumma awíqmena wení márûpaq utáiye. ");
INSERT INTO usa_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","miráitata yemá Yérútáárebaq yauwéqma uréta yimuqá makááe. ");
INSERT INTO usa_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","ánibo taíbaq-kanaama yemá anó-monoq-naupaq máeta Áánûqtuni áwîqa múte yaútaae. ");
INSERT INTO usa_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","maramá tarôq íma urái-tupaama Aagómá mi-kánááráqá máqe-uraitana Aagómá Áánûqtute maa-kááyáqá máqe-uraaye. ");
INSERT INTO usa_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Aagómá Áánûqtugaraq máqe-uraayana Aagómá Áánûqtuma mimórámá máqe-uraiye. maramá tarôq íma urái-kanaama ");
INSERT INTO usa_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Aanapó máqte-qtaataqa abarokáq aúkáiye. wenamáárîq máqte-qtataaqa abarokáq íaukaiye. ");
INSERT INTO usa_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Aagómá áyaqnobake wemá kéqokeq-wamma aúwaraimma yímikaiye. miráipoata paá mááe. kéqokeq-karui-yataaqa tarôq uráiye. miráipoana paá wáiye. Aagómá wenáyaqnobaqa aúwaraimma wáqe-uraitana min-áúwáraímmá waayúkagoni arunóbáqá ómmá tágama wáqe-uraiye. ");
INSERT INTO usa_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","maan-ómmá kumayupí tágagiye. kumayupí tágagitana maan-ómmá mú mikákáá akoqnáá-kumayuqa wáiye. ");
INSERT INTO usa_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Áánûqtu móra-nakoma timákáraitana tágai-yataaqtaba timá yímikaiye. Áánûqtuni watáá-wataa-naqa wemá máqe-uraiye. maa-nákónáwîqa Yóáane téta ááyaraae. ");
INSERT INTO usa_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","maan-nákómá tágai-nakoqtabama timá-yiminena iráiye. iráitata wenáarake máqte-kayukama yirummá amínoe. ááqibo maamin-áítábá iráiye. ");
INSERT INTO usa_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Yóáane tágainaqa wemá íma máiye. paá tágagi-aimma mamé iráiye. ");
INSERT INTO usa_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","árai-tagainaqa mararáq yínana máqte-kayukaraqa tágaginiye. maannáyaba Áánûqtuni áraimma tágai-yataaqtaba téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","mararáqá Aagómá máqe-uraitana Aanapó maramá Áánûqtu tarôq uráimma aarawaamá Aamá kéiteta íma ítaraae. ");
INSERT INTO usa_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Aagómá wení waayúkaraq iráimma mi-káyúká weqtábámá íawikaae. ");
INSERT INTO usa_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","miráimanibo yaímma óq-wayuka weqtábámá kéyikainata Áánûqtu yemmá náápaamma yímikaitata wení iyápó aúkáae. maan-íyápó-ánnámá Áánûqtuni wenáwîkaq kéitaae. ");
INSERT INTO usa_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","yeráwáqá maqíkáraimma naaerákén-íyápóráá íma ákáraimibo Áánûqtu maqíkáraiye. waayúkati yimuq-yatááqnápó íma ákáraimibo Áánûqtu maqíkáraiye. aarawaabíké íma marákáraitana Áánûqtu wenamáárîq wení iyápó-annama maqíkáraiye. ");
INSERT INTO usa_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Aagómá waékáimiye. Aagómá aúma wemá pááq uráiye. mararáq kukéna watáiye. ketááráqá kukéna watáiye. mirái-nakoma wení tágama-yataaqa Yóáane netuqyaa-káyúkágáráq aónaraae. Áánûqtuni kímora áanikoni tágama-yataaqa aónaraae. Aagómá aúgaraq-naqa wení tágama-yataaqa aboánôpake akoqnáá matáiye. maaminnâ tágama-yataaqa kaayoné-í-yátááqá ógikaima ôriq umá wáitana ááqibo maami-káayóné-í-yátááqá aati-aatimá paá wáiye. ");
INSERT INTO usa_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Yóáane wetábá mirá téna wenáá-wenaa tiráiye: “Aagómá aúgaraq yínítabama mirá téq kemá Yóaane timá tímikaune. Aagómá naayóbágá máqe-uraimma maramá tarôq íma urái-kanaama máqe-uraiye. miráipoaq wenáaimma yaaguyaqmé kéyune. ááqibo íbêq-kanaayataba Aagómá aúgaraq-naqa tinaaépaq kéinnama aanibo tágagiyabama min-náqá tinaaépaq íma kéiye. tágagiyabama uyátárai-naqa ketúbáqá máiye.” téna Yóáane tiráiye. ");
INSERT INTO usa_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","min-áúgáráq-náqá arunábáqá kaayoné-yátááqá ógikaiye. kaayoné-yátááqá ógikaipike ketáá matáunatae. ayúgutaipike ketáá matáunatae. wení kaayoné-yátááqá ókaraq-okaraq umá ketáá kétimitae. naayón-ámáán-áímmá yuwéna Áánûqtuma aúgen-amaan-aimma timá waéqma akoqnáá uráiye. ");
INSERT INTO usa_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Áánûqtuma Móteti aammá aúmakain-aikaraa aammá yawítíqtukain-aikaraqa ámikaitana káqo-qtataaqa kaayoné umá aati-aatimá wái-yataaqa Îtuma mamé iráiye. ");
INSERT INTO usa_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","móra-nakoma Áánûqtuma íma aónéwaimiye. Áánûqtu wemá wenamáa wení áanikoma máiye. wenamáa kímora áanikoma ákáin-iyapoma aati-aatimá amakaq máitana áanikoma wenaboáqtábámá paá tiráátiraiye. ");
INSERT INTO usa_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","aanibo Yóáanenopaqa anó-monoq-wayukama Aríbaeti-annagaraq Yérútááre-wayukama timáyíkaraae. Yérútáárebake yaímma-wayukati yíwîqa Aríbaeti-annama monoq-káwáá-wáyúkámá máqe-uraae. Yóáanenopaqa kukéta ítama aónaraae: “emá náawabono?” téta tirááe. ");
INSERT INTO usa_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Yóáane wemá paá tiráiye: “kemá Metáíya íma máune.” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","móragaraq Aríbaeti-annama Yérútáárebake ítama aónaraae: “ááqibo emá paá náawabono? Irááiya máano?” téta ítaraae. Yóáane tiráiye: “ímiye” tiráiye. Aríbaeti-annama móragaraqa ítama aónaraae: “emá Áánûqtuni amuné-náqá máano?” téta ítaraae. Yóáane timá yímikaiye: “aaqáo” tiráiye. ");
INSERT INTO usa_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Aríbaeti-annama ááqaanibo ítama aónaraae: “timá timiyo! é náawabono? timá tíminataa ketáá timátíkaa-kayukata mó timá-yimenunatae. etábámá enamáárîq nóinae kéteno?” téta ítama aónaraae. ");
INSERT INTO usa_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","wé Yóáane wetábá téna Áítáíyani watáama yauwéqma timá yímikaiye: “kemá paá aagómá kaqmáápaqa máune. ketáagoma pááqya-kanaama abarokáq kétaayaiye. uyátárai-nakoni aammá kaqmáápaqa mó tarôq oro! min-ánón-ámmá arupú oro!” mirá téna timá yímikaiye ");
INSERT INTO usa_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Pérati-wayukayopake óq-wayukama iréta móragaraq ítama aónaraae: ");
INSERT INTO usa_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","“emá tirááne ‘kemá Metáíya íma máune. íma Írááiya máune. íma Áánûqtuni amuné-náqá máune.’ té emá timá tímikaanatae. ááqibo nôraq itaaq nommá kébeqyikaano?” tewana ");
INSERT INTO usa_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Yóáane timá yímikaiye: “paá nokáráqá kébeqyikaune. maa taíbaq-wayukati aúkáapimma móra-naqa máitata yeráwáqá íma ítaraamanibo wemá ");
INSERT INTO usa_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","uyátárai-nakoma tinaaépaqa kéitaq ketí mú mikáq-náqá kemá wení maqné-náqá maqnégánópóaqa wení aítauq-anaan-annama íma kanaaráq uwaénúnamiye.” téna Yóáane Béqtanibaqa timá yímikaiye. ");
INSERT INTO usa_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","miráuraitana Yótaa-non-abapaqa mikáqá Yóáane nommá péqyikewaipaqa pááq uráiye. ");
INSERT INTO usa_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","miráuma aabáyaama Yóáanen-opaqa Îtuma kéitana Yóáane Îtumma aónarena maará téna abarokáq tiráiye: “aónaaro! maannáma Áánûqtuni tipi-típi áráakaa-naqa máiye. wemá maa-márábí-kúmíq-yátááqá kebó-yátáákáráq mamá matuwánéna kukáiye.” ");
INSERT INTO usa_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","wetábámá keráwáqá timá tímikaune: “tinaaépaq uyátárai-nakoma kéitana ketí mú mikáq-náqá kemá naayóbáqá pááq uráune wemá máqe-urainana miráipoana wemmá yaaguyaqmá kéyune.” téna Yóáane tiráiye. ");
INSERT INTO usa_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Yóáane óqa tiráiye: “áqnáabaqa kemá kenamáárîqa íaonaraune.wemá náawabiyo? nóiqtaba kemá iráúnábô? nommá má kébeqyikaunaboata ááqibo miráuma Ítíráaeo-wayukama wemmá aónanoe. ");
INSERT INTO usa_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Yóáane ókaraq tiráiye: “kemá Áánûqtuni Aágoma kégumita aónaraune máaraa kukéna Aágoma wekáqá ku máqe-uraiye. ");
INSERT INTO usa_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","aanibo kemá kenamáárîqa wemmá íma ítaraunamanibo kemô nokáráqá péqyikao téna timátíkáí-nakoma mémá-kánáábímá timá tímikaiye. ‘emá aónenanamo Áánûqtuni Aágoma kumínama móra-nakoni aúraqa ku máinama anaaékaqa min-nákómá Áánûqtuni Aágogaraqa pérakaniye.’ tena ");
INSERT INTO usa_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","kemá kenamáárîq aónareq tiráune. ‘min-náqá Áánûqtuni mú mikákáá-náqá máiye.’” téna Yóáane tiráiye. ");
INSERT INTO usa_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","aabáyaama Yóáane wenanaaé warááya-nakaratama máeta ");
INSERT INTO usa_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","áánibo Îtuma paá ureíre kéitata aónaraae. Yóáane abarokáq tiráiye: “aónaakao! maannáma Áánûqtuni tipi-típi-araare.” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","kaayaq-nákórátá yegárágá ítaarayapoata Îtumma anaaé ");
INSERT INTO usa_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","waqmé kéoyana Îtuma waéqma yimónaraaye. maa-kááyáqá Îtuma ítama aónaraiye: “kenákámá nóiqtaba abáá kéoyo?” téna yenáká timá yímikaiye. aanibo yenákámá tirááye: “Aráábaeo, náakaraq kéwaeno? teta (Aráábae wenáaimma yirááti-naqa máiye.) ");
INSERT INTO usa_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Îtuma tiráiye: “ketê iréka yaónaakao!” téna tiráiye. miráimanibo yenáká iréta Îtugaraqa mi-nókáámá máqe-uraaye aabaúmá énaikaqa waaqókáqá kaayaqté-kaayaqte (4.00 kiroki) inéna uráiye. ");
INSERT INTO usa_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","yenákábíké móra-nakoma wemá Yóáane ítaraipoana Îtuma anaaéma wakáiye wenáwîre Áánaru Tááímoni Pítaa wenábâkoe. ");
INSERT INTO usa_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Áánaru páátákáá awaaómmá Tááímoni ko aónatuwena timá ámikaiye téna “Metáíya kerátámá aónarauye” (Metáíya wenáaimma Áánûqtunopake mú mikákáá mái-naqa). ");
INSERT INTO usa_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Tááímoni Áánaru áwíqmena Îtukaqa uráiye. Îtuma wemmá aónarena tiráiye: “emá Tááímonio, Yóáanen áaniko, ení aúgen-awiqa Tépati wániye.” téna tiráiye. ááqibo paá Pítaa min-áwíqá ááyanunatae. Tépati wenáaimma “óqtamma” wáiye. ");
INSERT INTO usa_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","aabáyaama Kááriri-marupaqa Îtuma uínéna kéena kóuraiye. Píripima aónarena timá ámikaiye: “ketinaaé waraao!” ");
INSERT INTO usa_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Píripi Beqtáirapake kéiye. mimórá-márúkáqá Áánaruyaa Pítaa yeqtí márûkare. ");
INSERT INTO usa_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","anaaékaq Píripi Natáániomma aónarena timá ámikaiye: “móra-nakoma Móteti Áánûqtuni amuné-nákáráq naayóbáq wetábá agatááe mimórá-nákómá aónaraunatae. wemá Îtuma Yótêbi wení áanikoma Náátárêtibake máiye.” Píripi téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Natáánio íkéitamma maará wemá tiráiye: “Náátárêtibakenabiyo? aaqáo! mikáké íráqô-qtataaqa paá íma kéimiye.” téna tiráiye. Píripi timá ámikaiye: “enamáárîq iré aónaao!” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Îtunopaqa Natáánio kéena Îtuma káonaiye.wemmá káonena Îtuma abarokáqá tiráiye: “aónaaro! maan-nákómá Ítíráaeobake-nakoma máena wení agaemá íma wáiye.” téna Îtuma Natáánioqtabama mirá-tiraiye. ");
INSERT INTO usa_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Natáánio ítama aónaraiye: “ketábámá náaraq umá ketí áaimma ítaraano?” téna tiráiye. ááqibo Îtuma tiráiye: “Píripi emmá íma ááyaraitaq yaa áménaapaqa máanaq túyánápí aónaraunamiye.” téna tiráiye. (mi-tágón-áwîqa “píki”). ");
INSERT INTO usa_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","aanibo Natáánio timá ámikena: “Aráábaeo, emá Áánûqtuni áanikoma máane. Ítíráaeo-mararaqa máqte-qtataakaqa anómma máane.” kétena tiráiye. ");
INSERT INTO usa_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Îtuma yauwéqma tiráiye: “emá píki yaa áménaapaqa máanaqa aónaraune maará téqo túnnama minnáyabama kétima-timeno? múte anó-qtataaqa anaaékaq ôriq umá aónanoe.” Îtuma mirá téna ");
INSERT INTO usa_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","óq-aimma tiráiye: “áraine. keráwáqá abaayámmá yawákínaqa abo Áánûqtuni márûpake wení kaqtó-wayukama wíyokakaa-kama taígani mú mikáq-náqá Waayúkagon-Araakaq wenôpaqa kuké ute íyaq aónanoe.” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","kaumo-yúpáámá ánatagitata móra-innima iyakánéta Kááriri-marukaq kéoe. pááqya márûkon-awiqa Kéinabare. Îtuma wenanóama mibáq máqe-uraiye. ");
INSERT INTO usa_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Îtuma wení iyápó-annagaraqa min-íníkóní waayúkagaraq awaikóní waayúkagaraqa yááyaawata ya aónaraae. ");
INSERT INTO usa_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","wááéni-nomma ánatanena itana Îtuma anóama timá ámikaiye: “wááéni-nomma ánataguraiye.” wenanóama titana ");
INSERT INTO usa_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Îtuma yauwêqma tiráiye: “aaragô! etábámá ketábámá nóinabiyo? ketí kanaamá íma pááq uráiye.” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","6","wenanóama aáwaqa mamé kéye-kayukama maará téna timá yímikaiye: “timá-timinaiqa-oro!” téna Îtuqtabama tiráiye. abapaké móra óqta-tawema wáqe-uraae. Ítíráaeo-wayukati nommá peraí-ámmá yawítítukain-aiqtabama miráipoana min-óqtá-táwémá mibáq wáqe-uraae. móra-mora óqta-tawebima móraiq-moraiq umá waaqókákáá kaayaqté-kaayaqte káápaa-tawebima yaqmá ógiqma wáiye (113 aríta). ");
INSERT INTO usa_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Îtuma tiráiye: “mirá-oro! mi-táwérápí nommá yábóro!” wemá téna tiráiye. aáwaqa mamé kéye-kayukama nommá yaqmá ógiqma ótaqa makááe. ");
INSERT INTO usa_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Îtuma óq-aimma tiráiye: “íbêqa yaímma yaqmá aáwakaq-kawaa-naqa mó ámêro!” téna titana mirá-uraae. ");
INSERT INTO usa_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","aáwakaq-kawaa-nakoma wemá namá aónaraitana naréna wááeni-none téna ítaraiye. ááqibo náakakenabiyo téna íma ítaraiye. aanibo aáwaqa mamé kéye-kayukama yemá ítaraae. iyakánéta on-íníkóní awaikómá aáwakaq yabíkái-naqa ááyarena ");
INSERT INTO usa_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","timá ámikaiye: “máqte-kayukama íráqô-waaeni-nomma áqnáabaq-taoqa yímituwaitana anaaékaqa yeráwáqá aáwaqa kénaawata paá-waaeni yimínoe. ááqibo emá íráqô-waaeni-nomma maráánama íbêqa kéyimene.” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","maa-qtátááqô Îtuma miráuraimma nommá wááeni-nomma aúkáitana kéena maannáma Îtuni áqnáabaq-awaameqa Kéinabaqa Kááriri-marukaqa mirá-uraiye. Îtuma wení iyápó-annama Îtuni tágama-yataaqa aónareta wemmá yirummá ámikaae. ");
INSERT INTO usa_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","anaaékaqa mirá-umaqtuwaawata Îtuma wenanóagaraq wenábâkogaraq wení iyápó-annagaraqa Kápéranabaqa urááe. mibáq pááqya-kanaama ko máqe-uraae. ");
INSERT INTO usa_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","ayú maqnánó-kanaama awaaraq kéitata min-áyú maqnánéta owana wenáwîqa kótámakini-kanaama (páátoba) miráipoana Îtuma Yérútáárebaqa utáiye. ");
INSERT INTO usa_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","anó-monoq-naupaqa waayúkama yetí purumakaamá tipi-típima máama meyámmá maránéta iráawana Îtuma aónaraiye. óq-wayukama maraq máeta óqtama waékáae. ");
INSERT INTO usa_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","kéwaeraawana Îtuma ánnama maténa pú yoqmá tebûqa yímiqma waqtúwáitata pípéban umáqtukaiye. monoq-naúpáké máqtemma purumakaakáráqá tipi-típigaraqa pípéban umáguraae. óqtama waékáa-kayukati yaaremá waéqtukaitana yeqtí móneqa kugúbaguraiye. ");
INSERT INTO usa_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","ááqaanibo máama meyámmámáráá-kayukama Îtuma timá yímikaiye: “maéqé páapaq kóoro!” téna wemá tiráiye: “ketiboní naammá íma mamá meyá-námmá aúráaro!” téna Îtuma timá yímikaiye. ");
INSERT INTO usa_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Áánûqtutaba agatáinabi wení iyápó-annama yeráwáqá yúyánákáqá makááe. minnáma agatáimma mirá kétiye: “ení monoq-náútábámá tirupi irá kamáguraiye.” téna agatáimma minnâ yúyánákáqá makááe. ");
INSERT INTO usa_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","anó-monoq-naupaqa kuyúqtúwáitaba Ítíráaeo-wayukama Îtumma ítama aónaraae: “nóin-awaameraq umá tiráátinonataabiyo? náápaamma matokéaq mirá kéono? náápaamma náawa ámikaiyo? tiráátiyo!” téta ítama aónaraae. ");
INSERT INTO usa_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Îtuma yauwéqma tiráiye: “keráwáqô, yawítítuwaiyaqa maa-mónóq-námá kaumo-yúpáá maéqa kemá móragaraqa múte itó-umaranune.” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Ítíráaeo-wayukama wenáama íma ítareta maará téta tirááe: “kanaaráq ayáqtáá-kanaama maa-mónóq-námmá umá múte itó-uyakaraae. kaayaqté-kaayaqte-wayukati yíyiyaamma naaikamá abapaké móra aúqa urááe (46 karitimaatimá). ááqibo miráinama kanaaráq kaumo-yúpáámá enamáa múte itó-umaranono?”. Ítíráaeo-wayukama téta tirááe. ");
INSERT INTO usa_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","áánibo anó-monoq-naqtaba Îtuma tiráíyábô wenaúyataba tiráiye. ");
INSERT INTO usa_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","anaaékaqa Îtuma pukáipikemo itó-urai-taoqa wení iyápo-annama wenáama yúyánákáqá makéta Áánûqtuqtaba agatáin-aikaraqa Îtun-aagaraqa áráitabaae téta tirááe. ");
INSERT INTO usa_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","keqnáámmá kótai-kanaama itana Îtuma Yérútáarebaqa máqe-uraitata taíbaq-wayukama wení awaaméqá aónaraapoana wenáwîkaqa yirummá ámikaae. ");
INSERT INTO usa_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Îtuma wenamáárîq yaímma-wayukati táí-yaaiqtabama ítaraipoana yemmá wenáaiqtabama yaákarena yiráátiraiye. ");
INSERT INTO usa_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","máqte-kayukati yirupimmá káonaipoana waayúkati yáaiqtabama káqowama wemmá kanaaráq ítimaminiye. ");
INSERT INTO usa_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","ááqibo Pérati-wayukabikemma anó-nakoma Níkótímati ");
INSERT INTO usa_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Îtunopaqa nokáámma wemá iréna timá ámikaiye: “Aráábaeo, emá timá-yiminaqa Áánûqtunopake máane. minnâ ketáá kéitaunatae. Aánûqtu etê ímo máráinaama emá íma anómma uyáqtárain-awaameqa kanaaráq ínóne.” téna Níkótímati tiráiye. ");
INSERT INTO usa_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Îtuma wenáaraqa yauwéqma tiráiye: “kemá áraimma kétima-amune. móra-nakoma íma móragaraq marakáinama wemá Áánûqtuni márûqa íaonaniye.” Îtuma mirá téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Níkótímati Îtumma timá ámikaiye: “wemá náaraq umáwaq waayúkago ááyaqnobakemma yauwéqma marakániyo? wenanóani ááyaqnobaqa móragaraq ku peráínana ámûkarariq umá máena móragaraq marakáníyô?” téna Níkótímati Îtumma ítama aónaraiye. ");
INSERT INTO usa_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Îtuma móragaraq tiráiye: “kemá áraimma kétima-amune. móra-nakoma íma Áánûqtuni márûpaqa wemá uyáberenamoenama wemmá nokáráq Áánûqtuni Aágogaraq marakániye. ");
INSERT INTO usa_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","aúgoma aúgomma ákáraitana Aágoma aágomma ákáraimiye. ");
INSERT INTO usa_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","íma karatiyo! kemó timámunayatabama keráwáqá móragaraq matikaíno! ");
INSERT INTO usa_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","uwáágoma uwáá yoqmá wemá náabarabi ónááe tipáqá kéuiye. wenáama kéitaane. ááqibo náakakena kéuiyo? náakaraq kéiyo té íma káonaane. mimóráráá waayúkama Áánûqtuni Aágoma kémaqyikaiye.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Níkótímati ítama aónaraiye: “náaraq umá maami-qtátáákómá pááq íníyô?” téna Níkótímati ítama aónaraiye. ");
INSERT INTO usa_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Îtuma yauwéqma tiráiye: “Ítíráaeo-wayukati anó timá-yimi-naqa máanana ááqibo maami-qtátáákóqtábámá íyaq ítaraano?” Îtuma óq-wataama tiráiye: ");
INSERT INTO usa_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","“kemá áraimma kétima-amune. ketáá kéitauna-yataaqtaba kétunanataa káonauna-yataaqtabataa kétima-yimunatae. ááqibo keráwáqá ketáí táaraqa taákaq íma kémaraae. ");
INSERT INTO usa_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","ímo itéq oweqa maa-márábi-qtátááqtábá timá-timunama Áánûqtuni márûpaq-yataaqtabama timá-timunama náaraq umá itánô? ");
INSERT INTO usa_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","ááqibo áraimma móra-nakoma Áánûqtuni márûpaqa aati-aatimá íma utáiye. paá kímora-nakoma Áánûqtuni márûpake kukáimma wenáwîqa Waayúkagon-Araaqune kemá. ");
INSERT INTO usa_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","kaqmáápaqa káápaa-augaraq-iraakabayaamma Móteti tarôq uráimma múte yaútaiye. waayúkama iraakabayaamá káonaawana yemmá Áánûqtu yíwáqnaa uráiye. móraiq umá Waayúkagon-Araaqa múte yaúteta kaapaq-yátáqá ikámakaae. waayúkama wemmá káonaawanama yemmá Áánûqtu yíwáqnaa kéiye. miráráá umá Waayúkagon-Araaqa múte yauwínoe. ");
INSERT INTO usa_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","miráipoata yeráwáqá Áánûqtuni áanikoma yirummá amétama yemmá káqon-auwaraimma yímikaiye. ");
INSERT INTO usa_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","owé. Áánûqtu máqte-marabi-kayukayatabama ámáabopike ákaraipoana wení kímora áanikoma yímikaiye. yeráwáqá wenáanikoma yirummá amétama yeráwáqá Áánûqtuni ayáápike íma aúyoretama ípuinoe. wenáanikoma aúgen-auwaraimma yimínama máqte-kanaama yeráwáqá paá mánoe. yirun-íyápómá matúq-matuq umá mánoe. ");
INSERT INTO usa_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Áánûqtu wenáanikoma aarawaamá yawááq umáikaiyabae téna íkukaiye. paá aarawaamá atóbamaikaiyaba timákáitana kukáiye. ");
INSERT INTO usa_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","móra-mora-nakoma arummô amínanama Áánûqtu wemmá íma yawááq kéumakaiye. ááqibo móra-mora-nakoma íbêqa arummô ímo kámitanama Áánûqtu wemmá íbêqa yawááq kéumakaiye. miráipoana wemmá kímora Áánûqtuni áanikon-awikaqa arummá íkamitanama min-nákómá íkákaitana Áánûqtu wemmá yawááq kéumakaiye. ");
INSERT INTO usa_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","íbêqa Áánûqtu maannáyabama yawááq kéumaikaiye. ómmá anómma marabí tágaguraiye. ááqibo waayúkama kumayuq-yátááqtábá kéyikaitata ómmá yupayo umá tágaiqtaba íkéyikaiye. yeráwáqtí yáaimma táígoni kéopoana ómmá yupayo iqtábá íkéyikaiye. ");
INSERT INTO usa_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","móra-mora-nakoma táígo-qtataaqa kéenama ómmá yupayo iqtábá íkákaiye. wení mayáígómá abarokáq yínipoana ómmá yupayo ikáqá waaqókáq íkuminiye. ");
INSERT INTO usa_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","móra-mora-nakoma áraimma íráqô-qtataaqa kéenama ómmá kamá yupayo ikáqá yíniye. Áánûqtun anaaé kéwaraipoana wení mayáígómá ókáá kamá tágaginana wemá yupayo iqtábá áaqa íkegaiye.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","anaaékaq Îtugaraq wení iyápó-annagaraq maréta Yúría-marukaq ko mááwana pááqya-kanaama mááwana mibáqá nommá péqyikaraae. ");
INSERT INTO usa_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Înonibaq waaqókáqá Téiramapaq taíbaq nommá wáqe-uraitata Yóáane mibáq nommá kébeqyikaiye. waayúkama nommá peráíyábá kéyikaipoata wekáqá yíq-yiq kéoe. ");
INSERT INTO usa_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Yóáane ánná-naupaqa íákaraabo. ");
INSERT INTO usa_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","maakáqá Înonibaq Yóáane wení iyápó-annama Ítírááéo-wayukagaraqa nóbíq-naabiq-aimma kétee. Ítírááéo-wayukati nommá peraí-ámmá yawíqtítukain-aiqtabama téta nóbíq-naabiq-aimma kétee. ");
INSERT INTO usa_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Yóáanen-opaqa iréta tirááe: “Aráábaeo, min-nákómá egáráq Yótaa-non-abapaqa mimórá-nákómá wetábámá tímikaanatae.kanaaráqá wemá íbêqa nommá kéberakaipoana máqte-kayukama wenôpaqa yageg-yageg kéoe. ");
INSERT INTO usa_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Yóáane maaráá téna yauwéqma tiráiye: “máqte-qtataaqa wení márûpake Áánûqtu ámikaipoana móra-nakoma kéqokeq-yataaqa paá íma mayáníbo.” Yóáane téna tiráiye: ");
INSERT INTO usa_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","“keráwáqá kenamáárîq tiníq umá kemá timá tímikaune. kemá Metáíya íma máune. paá timákai-naqa wenáaraqa áqnáabaq téqa tiráune. wágáábaqa maannáma timá tímikaune. ");
INSERT INTO usa_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","ítáaro! móra-nakoma ánáakoma kémayaitana yenáká yimuqá kémaraaye. maannáyaba min-nákóní ábárawaoma awé kéena káonena wegáráqá amuqá kémarakaiye. miráráá umá Îtuqtaba tíyaqnobaqa ógikaipike timuqá kémaqtuwaune. ");
INSERT INTO usa_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","wenáwîkoma íbêqa uíno ááqibo ketíwîkoma paá kumíkáae. ");
INSERT INTO usa_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","móra-nakoma yanaaké kéena wenáaimma máqte-qtataaqtabama yanaamá wáiye. káqo-nakoma marabíké kéena wemá paá marabí-qtátááqtábámá kétiye. móra-nakoma Áánûqtuni márûpakemo kéyenama ");
INSERT INTO usa_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","aónarena ítarai-qtataaqtaba Áánûqtuni márûpaqa wemá kétiye. ááqibo keráwáqá wenáaraqa taákaq íkemaraae. ");
INSERT INTO usa_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","waayúkama wenáaraqa yáqtoqma akoqnáá urétama yíyaqnobaqa mirá kétee. ‘Áánûqtu árai-naqa máiye.’ yíyaqnobaqa maami-káyúkámá mirá téta kétee. ");
INSERT INTO usa_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","móra-nakoma Áánûqtu timákaraitana wemá Áánûqtuni watáama kétiye. Áánûqtuni Aágogaraqa wenááyaqnobaq aati-aatimá ógiqma wáiye. ");
INSERT INTO usa_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","aboámá wenáanikoma kaayoné umákena máqte-qtataaqa wení akoqnááraq ámikaiye. ");
INSERT INTO usa_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","móra náawawaq Áánûqtuni áanikoqtabama arummá aménama áanikoma wemmá aúgen-auwaraimma amíniye. móra náawawaq áanikoqtabama kaúbîq kéena aúgen-auwaraimma íaonaniye. wekáqá Áánûqtuni áyámma umá watúq-watuq umá wániye.” Îtuma téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","3","Yóáane netuqyaan-íyápó-ánnámá nommá péqyikaraiye. ááqibo Îtuma mú mikáq netuqyaan-íyápó-ánnámá nommá péqyikaraiye. Pérati-wayukama minnâ ítaraapoana Îtuma Yúríabake itátuwena kóuraiye. Îtuma nommá íma péqyikaraiye. paá wení iyápó-annama yenamáárîq waayúkama nommá péqyikaraae. Îtuma Kááriribaqa móragaraq yauweré uráiye. ");
INSERT INTO usa_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Îtuma Táméria-marukaqa aúkáapi kótáma-kuraiye. ");
INSERT INTO usa_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","móra márûqa Táméria-wayukati márûkaqa iráiye. pááqya márûkon-awiqa Tékemabaq waaqókáq mi-márúqá Yáakoboma wenáanikoma Yótêbi ámikaiye. ");
INSERT INTO usa_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","mibáq nááyóbáqá Yáakoboni nommá yabí-máíqá wáqe-uraima íbêqa paá wáiye. aanibo Îtumma ábô-kaitana nommá yabí-máíkáqá ya máqe-uraiye. aáwaqa naí-kánáámá waaqókáq kéitata ");
INSERT INTO usa_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","wení iyápó-annama aáwaqa ko meyánîq ínéta kóuraae. móra-inikoma Támériabake nommá yabínéna iráiye. Îtuma timá ámikaiye: “nommá tíminaq naano!” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","ááqibo maamin-íníkómá yauwéqma tiráiye: “emá Ítírááéo-naqopo kemá Táméria-inimune. nôraq itaawáq kekáqá noqtábámá kéteno?” mirá téna timá ámikaiye. ");
INSERT INTO usa_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","anaaékaqa Îtuma maará tiráiye: “ááqibo emá Áánûqtunopake ámî-qtataaqtabama kéitaanama ekáqá náawabi noqtábámá ítama káonaiye emá kekáqá íténaq akoqnáá umá mái-nomma áméno.” Îtuma mirá téna timá ámikaiye. ");
INSERT INTO usa_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Táméria-inikoma yauwéqma tiráiye: “anóko, maa-nómmá yabí-máíqá mémá-nóbáqá wáiye. ááqibo ení tawemá íma wáiye. náakakenaq maami kúmi-nomma yabínónô? ");
INSERT INTO usa_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","ketáái títaubikoma Yáakoboma mú mikáq anó-naqa amé méqa kéono? wemá maami-nómmá yabí-máíqá tímikaiqtaae. wemá áanimaakaraqa wení tipi-típigaraqa mipíké narááe.” min-íníkómá mirá téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Îtuma waéqma itaí-áímmá wemmá timá ámikaiye: “máqtemmo maamipíké-nómmá naíyama óqa noqtábá yikániye. ");
INSERT INTO usa_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","máqtemma kemó yíména-nomma akoqnáá umá mái-nomma nétama anaaékaq ókaraq noqtábá íyikaniye. ááqibo kemó nommá amúnama arunóbáqá metiráá yubáma kumíniye. maami-métímá yubáma piri-piri téna kúminiye. máqtemma matúq-matuq umá mái-auwaraimma mayétama matúq-matuq umá mái-yataaqa matáápoana arunóbáqá ummaa íyaniye.” mirá téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","maamin-íníkómá timá ámikaiye: “anóko, mirá-nómmá timiyo! anaaékaq noqtábá ítikainaqa keqnáámmá maakáqá noqtábámá yauweré íyenune.” wemá téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Îtuma yauwéqma timá ámikaiye: “enawaikómá ko ááyama timá amítuwe yauweré yekao.” Îtuma mirá-tiraiye. ");
INSERT INTO usa_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","maamin-íníkómá tiráiye: “ketiwaikómá íma máiye.” Îtuma akoqnáá umá tiráiye: “áraine. enawaikómá íma máiye kétene. ");
INSERT INTO usa_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","áraimma kétune. emá móra-tiyaapaq-naqa matáánamiye. áánibo íbêqa mayáánama minnâ enawaiqá íma máiye. áraiqtabama paá yaímma emá kétene. tébakaq kenamáa tiráune.” téna Îtuma tiráiye. maamin-íníkómá yauwéqma timá ámikaiye: ");
INSERT INTO usa_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","“uyátáráana-nako! Áánûqtuni amuné-náqá máane. maannâ aónanaa únnae. ");
INSERT INTO usa_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","itaao! ketááí títaubikoma maan-ánúráqá nunamummá Áánûqtukaqa tirááe. ááqibo emá ení waayúkagaraq miráuma kétee. ‘Yérútáárebaq mibáqá nunamummá mó tero!’” téna wemá tiráiye. ");
INSERT INTO usa_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Îtuma minnáyaba óq-aimma tiráiye: “aaragô, itaao! óq-kanaama yínaamoema mi-kánááyábá íma anuraqá íma Yérútáárebaq nunamummá tinóne. ");
INSERT INTO usa_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","emá ení waayúkagaraq nunamuqtábámá íkéitaae. paá-wataama kétee. atóbamayikai-yataaqa Ítíráaeo-wayukarake kéipoana nunamummá-tí-yátááqtábá arupú umá ketáá kéitaunatae. ");
INSERT INTO usa_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","mi-kánáamá yíniye. áraimma mi-kánáámá íbêqa wáiye. waayúkama árai-nunamuqtabama yeráwáqá mútûq yirummá améta Áánûqtuni árain-aikaraqa nunamummá ketibotáá Áánûqtukaqa tínoe. owé. ketibotáá Áánûqtu yeráwáqá mútûq yirummá améta Áánûqtuni árain-aikaraqa téta mirá-káyúkábá Áánûqtuma kákaiye. ");
INSERT INTO usa_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Áánûqtu wenamáárîq aágoma máipoana waayúkati yirunóbáqá aágoma Áánûqtu wenamáa maqikáné iné. Áánûqtu aágoma máinapoana máqtemma yetí aágogaraq wekáqá nunamummá tínobo. aágogaraq tétama mútûq yirummá ámiketa Áánûqtuni árain-aikaraq nunamummá tínobo.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","maamin-íníkómá timá ámikaiye: “Metáíya (Káríqto) kumínayaba kéitaune. wemá kuména máqte-qtataaqa kéitaipoana máqte-qtataatabama timá-timinitae.” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Îtuma abarokáq timá ámikaiye: “kemá kétima-amune minnâ kemúne.” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","mikáqá wení iyápó-annama irááe. iréta Îtuma maamin-íníkótê watáá-wataa kétitata wení iyápó-annama ya káoneta yáaqtaba urááe. yeráwápíké móra-nakoma íma ítama aónaraiye: “nóiqtaba kákaiyo?” téna “nôraq itaa wetê watáá kéteno?” mirá téna móra-nakoma ítiraiye. ");
INSERT INTO usa_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","miráitana min-íníkómá no-táwémá mikáq yuwéna anó-marupaqa uréna mibáq waayúkama timá yímikaiye: ");
INSERT INTO usa_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“iréra! móra-nakoma ya aónaaro! wemá máqte-qtataariq naayóbákáráq íbêkaraq kéuna-yataaqtaba wemá timá tímikaiye. wemá Metáíyawabiyo?” min-íníkómá téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","ááqibo waayúkama anó-marupake yuwéta Îtunopaqa kéowata ");
INSERT INTO usa_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","mi-kánááráqá wení iyápó-annama waku-waku tirááe: “Aráábaeo, pááqyamibo paá naao!” téta tirááe. ");
INSERT INTO usa_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","ááqibo Îtuma yauwéqma timá yímikaiye: “ketí kaawéqá wáitaq abo keráwáqá maannáyaba íkeitaae.” Îtunopaqa kéowata ");
INSERT INTO usa_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","mi-kánááráqá wení iyápó-annama wemmá kéitaimma wemmá kéitaimma urááe: “móra-nakoma aáwaqa maméta irááô?” wemmá kéitaimma wemmá kéitaimma urááe. ");
INSERT INTO usa_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Îtuma miráráá téna timá yímikaiye: “ketí aáwaqa miráuma wáiye. kemá timátíkárai-nakoni aúyánámmá waránááre waqmá mayaímá tímikaimma mamá ánatanaare.” téna Îtuma tiráiye. Támériabake-kayukama kéowana Îtuma yimónarena óqa waéqma itaí-áímmá tiráiye: ");
INSERT INTO usa_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","“keráwáqá tiráama miráuma kétee. ‘kaayaqté-kaayaqte-wiyokoni mi-kánáágóní arupimmá yómmá anagánoe.’ abo kétune tú maréra! yómmá aónaaro! yókómá íbêqa anagégaiye. ");
INSERT INTO usa_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","íbêqa arammá kúqtín-nakoma wení ápêqa kémayaitana arammá watúq-watuq umá wánin-aramma kútúma ayúgutaiye. miráumaraa úbî-nakogaraq arammá kúqtín-nakogaraq yimuqá maráyóye. ");
INSERT INTO usa_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","tiráama áraine ‘móra-nakoma arammá ánayumma kéubitana káqo-nakoma arammá kútúma ayúgutaiye.’ ");
INSERT INTO usa_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","ááqibo keráwáqá arammá kútúma ayúmá kúyoro téqa timá tíkaraune. ááqibo min-áráqtábámá keráwáqá íma uqmakéqa íma kawáá urááe. káqo-yuma maamin-árákáqtábá ôriq umá mayaímá matááwaqa ááqibo keráwáqá paá ya ayúgéguyoe.” téna Îtuma tiráiye. Îtuma mi-kátáagóní áaimma abarokáq ítiraiye. mirá-uraiye. ánayumma wení watáama wáiye. waayúkama yókáá mááe. móra-nakoma Îtuni watáama waayúkati yirupi kéubitana anaaékaq káqo-nakoma wení iyápó-annabike íráqôn-aaimma arakáá waayúkati yirupiké aónaniye. ");
INSERT INTO usa_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","maamin-íníkóní watáaboana netuqyaa Táméria-wayukama anó-marupake Îtuqtabama yirupi kéitaae. min-íníkó tiráiye: “wemá timá tímikaiye kemá máqte-qtataariq naayóbákáráq íbêkaraq kéuna-yataaqtaba wemá timá tímikaiye.” téna máqtemma min-íníkó timá yímikaiye. ");
INSERT INTO usa_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","miráipoana maami Táméria-wayukama Îtunopaqa kégumeta inaa-inaa tirááe: “ketáátê ya mááo!” téta tirááe. kaayaq-yúpáámá yéráwátê máqe-uraimma wení watáama tiráitata ");
INSERT INTO usa_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","óq-wayukama netuqyaamá yirummá ámikaae. ");
INSERT INTO usa_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","anaaékaqa maamin-íníkómmá yemá timá ámikaae: “áqnáabaq emá ténayababoaqtaa Îtuqtabama tirummá ámikaunatae. íbêqa ketáá kenamáárîq ítaraunatae. tirupi kéitaunatae maan-nákómá áraine wemá máqtemma yirummá amíya-kayukama yeqtí atóbamaqyikai-naqa máiye.” mirá téta tirááe. ");
INSERT INTO usa_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","kaayaq-yúpáámá ánatagitana wemá iyuwéna Kááriribaqa kégoena ");
INSERT INTO usa_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Îtuma wenamáárîq tiráiye: “Áánûqtuni amuné-nákómá wenamáápaqa íma anón-awiqa wáiye.” téna tiraiye. ");
INSERT INTO usa_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Kááriribaqa itata mibáq-wáyúkámá wemmá yiqtábá yimuráámuq marákáraae. yeráwáqá yenamáárîq ayú maqnánó-kanaabimma Yérútáárebaq máqe-uraawana máqte-qtataariq kéi-qtataariq mibáq immá aónaraae. ");
INSERT INTO usa_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","anaaékaq Îtuma môragaraq Kéinabaqa Kááriri-marukaqa yauweré iráiye. mibáq áqnáabaqa nommá waéqma wááéni-nomma aúkáiye. móra-ano-naqa Kápéranabake wenáanikoma karímá ákaraiye. ");
INSERT INTO usa_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Îtuma Yúríabake Kááriribaqa yináímmá ítátuwena miráipoana Îtunopaqa min-ánó-nákómá ko tiráiye: “ketáanima puiné kéibo. iré mamá atóbamakao!” téna min-ánókómá timá ámikaiye. ");
INSERT INTO usa_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","maaráá Îtuma tiráiye: “paá kéqokeq-awaameqa íaonareq keráwáqá tirummá íaminoe.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","anó-nakoma mibáq tiráiye: “anoko! ketí iyápómá puínabo kuké aónaao!” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Îtuma timá ámikaiye: “kóaao! ení áanikoma paá mániye.” téna tiráiye. miráuma min-ánó-nákómá Îtun áama ítama arupi maréna Îtunopake kóuraiye. ");
INSERT INTO usa_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","min-ánókómá kégumitata wení kaqtó-wayukama aapaq wenaitaatán uréta timá ámikaae: “ení iyápóma íbêqa paá máiye.” téta tirááe. ");
INSERT INTO usa_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","min-íyápógóní aboámá ítama aónaraiye: “nóin-aabauma wení kokoq yámma ánatayakaraiyo?” téna ítama aónaraiye. kaqtó-wayukama minnáma yauwéqma tirááe: “aabaúmá yotéqma móraitana kokoq yámma ánatamakaraiye.” téta tirááe. ");
INSERT INTO usa_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","min-ábáúmá mimórá-kánááráq Îtuma timá ámikaiye: “enáanikoma paá mániye.” téna aboámá aákaq makáiye. aboágáráq máqten-araabanogaraq ábâqawaagaraqa yirupi kéitaae. ");
INSERT INTO usa_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","áqnáabaq-awaameq-yataaqa Kéinabaq wááéni-nokaq uráiye. ááqibo Yúríabake yuwéna Îtuma Kááriribaq mikáq keqnáámmá mi káqon-awaameqa uráiye. ");
INSERT INTO usa_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","anaaékaq Ítíráaeo-wayukati óq-oniqtabama Îtuma Yérútáárebaq utáiye. ");
INSERT INTO usa_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Yérútáárebaq mibáq nokaayúkáqá wenáwîqa Batétara waaqókáq tipi-típigoni oqtaráqá wáiye. mi-nókááyún áwábaqa móra-tiyaapaq púgágîq-nama wáqe-uraiye. ");
INSERT INTO usa_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","mi púgágîq-naupaqa taíbaq-wayukama yipaq atááe. yaímma yúrama karoparáiye. yaímma yítauqa arúkeq-arukeqa urááe. yaímma yítauqa yabitimáguraiye. tébakaq-wayukama yíyiyaa-kareremma urááe. nommá karááqto ínayabae téta awé urááe. áqnáabaq náawabi nommá karááqto ipí kukáitana wení áiyayaakoma akoqnáá íniye téta waayúkama yúyánápí ítaraae. ");
INSERT INTO usa_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","yúyánápíké tiráama kaqtó-wamma Áánûqtunopake móra-mora-taoqa nommá waéqma uréire uráiye. ");
INSERT INTO usa_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","abo mórama karí-náqá kaumo-tíyáákágáráq abapaké kaumo aúqá (38 karitimaatimá) karí maéna máqe-uraiye. ");
INSERT INTO usa_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Îtuma aúyánámmá ítaraiye min-nákómá karímá naayóbáq matáiye. ááqibo mibáq min-náqá aipaq atáitana aónatuwena Îtuma ítama aónaraiye: “emá atóbaiyaba kákaiyo?” téna Îtuma ítama aónaitana ");
INSERT INTO usa_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","karí-nákómá yauwéqma tiráiye: “anón-nako! yaímma-wayukama kemmá íma tiyáátoqma nokayúpímmá nommá karááqto ipímmá tikéwae íkéoe. kenamáárîq mi-nópímô kumónae téqo kéunama káqo-yu yenókáá ketí aammá kunaúyakewae kéoe.” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Îtuma timá ámikaiye: “itóaao! itó éyaq ení yuwaiqá yawátama mamé minnágaraq uréire uwo!” téna akoqnáá umá tiráiye. ");
INSERT INTO usa_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","páátákáá min-nákómá kátobakena wení yuwaikáráq yawátamena kóuraiye. aanibo mi-túpáámá Taabati-yúpáámá aagaí-yúpáámá wáqe-uraiye. ");
INSERT INTO usa_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","miráipoana Ítíráaeo anó-monoq-wayukama timá amíqmeta urááe: “íbêq-yupaama Tabaati-yúpááráré. emá ení yuwaikáráq íma mamé uréire uwo aagaí-yúpááráré!” téta timá ámikaae. ");
INSERT INTO usa_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","wemá timá arútá-yimikaiye: “mamá atóbatikai-nakoma ení yuwaiqá yawátáma mamé waao titaq mamé kéyune.” téna timá yímikaiye. ");
INSERT INTO usa_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","anó-monoq-wayukama ítama aónaraae: “min-nákómá timákáitaa mamé yénama náawabiyo?” téta ítama aónaraae. ");
INSERT INTO usa_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","ááqibo atóbai-nakoma íma ítama arútaraiye Îtuqtabama náawabiyo téna Îtuma taígani-kayukabike péqma yútúgitana atóbai-nakoma íaonaraiye. Îtuqtabama íma ítaraiye wé náawabiyo. ");
INSERT INTO usa_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","anaaékaq min atóbamakai-nakoma Ítíráaeo-wayukati anó-monoq-naopaqa Îtuma aónatuwena timá ámikaiye: “aákaq maraao! emá kátobaane. móragaraq ení kebó-yátááqá kúmiq-yataaqa íma uwo! íbêqa pááqya-karima matááne. anaaékaq anópi wíyátábámá yabíqma arutaao!” téna Îtuma timá ámikaiye. ");
INSERT INTO usa_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","min atóbai-nakoma yuwéna Ítíráaeo anó-monoq-wayukama timá yímikaiye: “min-nákómá wenamáárîq kemmá atóbamatikaraiye.” téna Îtuqtabama timá yímikaiye. ");
INSERT INTO usa_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","karí kátobamayikena mirá-qtátáárîq Îtuma kéinapoana Tabaati-yúpááráqá anó-monoq-wayukama wemmá áaimma átáma waqmá ikamínéta abáá-uraae. ");
INSERT INTO usa_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","ááqibo Îtuma yauwéqma timá yímikaiye: “ketiboó, íbêqa mayaí kémayaitaqa miráipoana mayaímá mimóráíq umá kémayaune.” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","min-áíqtábá Ítíráaeo anó-monoq-wayukama ókaraq-okaraq umá wemmá abáá-uma uréire urááe. Tabaatiráqá aammá aúmakaan-aimma araténa Áánûqtutaba “kenamáa ketiboé” téna tiráiye. min-áíkómá mamá wekáráq Áánûqtukaraq móraiq uráitata anó-monoq-wayukama abáá-uma ikamínéta urááe. ");
INSERT INTO usa_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Îtuma maannáyaba yauwéqma tiráiye: “kemá túyánámmá ítama kateko umá keráwáqá kétima-timune. áanikoma wenamáa wenamáárîq máqte-qtataaqa íma íné imíye. paá aboámá kéi-qtataaqa káonena minnáma áanikoma mimóráíq kéiye. ");
INSERT INTO usa_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","aboámá áanikomma ôriq umá weqtábámá amuqá kémarakaipoana kákaitana aboámá máqte-qtataariq kéi-qtataaqtabama áanikomma káraatiye. ");
INSERT INTO usa_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","aboámá pukáipike kátobamakaitana paá áanikomma pukáípike mimórá miráuma kátobamakaiye. miráuma móraiq umá aúwaraimma aboámá ámikaitana paá áanikoma móraiq umá aúwaraimma mórá náawanabi ákái-naqa ámikaiye. ");
INSERT INTO usa_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","ítáaro! aboámá máqte-kayukama yawááq íma umáyikaniye. ímiye! áanikoma yawááq-umayikai-aiqtaba wemmá ayuwáinana tíniye. ");
INSERT INTO usa_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","miráipoana wé náayuwabi áanikoqtabama áwîqa múte kéyauyowana miráuma móraiq umá aboán áwîkaa kéuwiye. náayuwabi áanikon-awiqa múte íkéyauyowana miráuma móraiq umá aboámá wemmá timákái-naqa wenáwîkaa íkéuwiye. ");
INSERT INTO usa_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","kemá túyánámmá ítama ôriq umá kateko umá keráwáqá kétima-timune. náawabi ketáama iténama kemmá timátíkárai-naqa arummá aménama aúgen-auwaraimma matúq-matuq umá mái-yataaqa kémayaiye. wemá íma yawáá kéena ímiye! arummá amína-nakoma áqnáabaq arun-íyápómá pukáipike itó-urena matúq-matuq umá paá mániye. ");
INSERT INTO usa_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","kemá túyánámmá ítama ôriq umá kateko umá keráwáqá kétima-timune. mi-kánáámá yínatama áraine. mi táoqa áaimma kátenama mibáq yirun-íyápómá pukuráá-kayukama Áánûqtuni áanikon-aama itétama náayu-naayubi yirummá amétama yeráwáqá matúq-matuq umá paá mánoe.” Îtuma téna tiráiye. óq-wataama timá yímikaiye: ");
INSERT INTO usa_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","“áraine. ketibomá Áánûqtu wenamáárîq aúwarai-qtataaqa áqnáabaq pááq-urainapoana miráuma móraiq umá kemá áanikoma aúwarai-qtataaqa móraiq umá tirunóbáqá wáiye. ");
INSERT INTO usa_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","kemá Waayúka-Araakoma máunaboana ketibomá kemmá áanikoma akoqnáá-yataaqa tímikaitaq waayúkama mamá yainánúne. ");
INSERT INTO usa_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","maannáyaba íma iyánáaq uwo! ááqibo mi-kánáámá yínatama yúma pukuráá-kayukama maiqnóbáq máetama áama itánópoata ");
INSERT INTO usa_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","muríánóbákénábi maiqnóbákémá utátuweta uínoe. máqte-kayukama itó-inoe. yaímma íráqô-qtataariqo uráá-kayukama paá matúq-matuq umá mánoe. tébakaq-wayukama táígo-qtataariqo uráá-kayukama yawááq-uma-ikanune. ");
INSERT INTO usa_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","kenamáa kenamáárîq máqte-qtataaqa íma onááq únnae. kemá tíkái-qtataariqa íkeune. ááqibo timátíkái-nakoni ákái-qtataariqa kéune. miráipoana paá kéiteq ítama kéyainaunana ketí yaináuna-yataakoma arupú kéiye.” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Îtuma óq-aimma tiráiye: “keráwáqá kemmá kenamáárîq áraimmo timá tímênaqa tirummá íaminobo paá kaayaq-wáígóbi kaumo-wáígómô timá-timiyaatama mikáq itánúnatae. ");
INSERT INTO usa_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","ááqibo óq-nakoma ketibomá wemá ketáaiqtabama áraimma keráwáqá kétima-timitaq wenáama árain-aimma kétítaqtaa ketáá kéitaunatae. kenamáa ketábámá íketune. ");
INSERT INTO usa_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","keráwáqá Yóáane nommá peraí-nákónôpaqa taíbaq-wayukama timáyíkaraiye. mi-káyúkámá Yóáanema ítama aónaraawana wemá arupú umá yauwéqma tiráiye. ");
INSERT INTO usa_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","paá-wayukama Yóáane máqe-uraipoana wenáayabama kemá túyánámmá íkéitaune. maamin-áímmô túnnama keráwáqá tíwâqnaa umá atóbamatikaiyabae téq kétune. ");
INSERT INTO usa_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Yóáane wemá ókáá kamá tágaraitaq pááqya-kanaama keráwáqá min-ópí timuqá kémaraae. ");
INSERT INTO usa_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Yóáane ketáaiqtabama akoqnáá umá ítaraiye. ááqibo óq-yataakoma ketí mayaímá mú mikáq akoqnáá umá keqtábámá kétee. mayaímá mamá ánataao téna ketibomá tímikaitaq maami-máíyáímô mayáunama áraimma ketibó timá tíkaraitaq káonaae. ketibomá mayaao téna timátíkáitaq iráune. ");
INSERT INTO usa_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","aanibo ketibomá timátíkáimma wenamáárîq káqo-yu ketáaiqtaba timá yímikaiye. ");
INSERT INTO usa_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","wenáama aati-aatimá íkéiteqa wenóíkaqa aati-aatimá íkaoneqa kemmá timátíkárái-nakaq tirummá íkamepoaqa keráwáqá ketiboní aagómá watúq-watuq umá tirupi íma wáiye. ");
INSERT INTO usa_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Áánûqtun áama agamatán-áípí ketáaiqtaba kétiye. keráwáqá anó-monoq-wayukamo maamin agamatán-aimma abáá-abaa kéeqa áaimma íkeitaabo watáama paá kéyorautopoaqa min-aúgén-áúwáráímmá mayánúne téq túyánámmá kéitaae. ááqibo paá kéyorautopoana keráwáqa min-aúgén-áúwáráímmá íma yíniye. ");
INSERT INTO usa_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","ókaraq-okaraq timá yímíkaimanibo máqtemma keráwáqá ketôpaqa iréq maamin-áúwáráímmá mayáítááqá íma kéitaae. ");
INSERT INTO usa_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","kemá íma keráwáqtábámá ketíwîqa múte yaúyóro téqa íketune. ");
INSERT INTO usa_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","minnâ keráwáqtí táaimma káoneqa Áánûqtuni akaí-yátááqá tirupi íma wáiye. ");
INSERT INTO usa_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","ketiboní náápaakaraq mamé kéyune. ááqibo keráwáqá kemmá íkétiwiraae. móra-nakoma paá wení náápaakaraq mamé yínaqa keráwáqá wemmá awiránóe. ");
INSERT INTO usa_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","keráwákáán uráá-kayukama náaraq umáwaq tirummá kanaaráq timínô? kanaaráq ítiminoe. keráwáqá yiyuwáíyata keráwáqtí tíwîqa wenámí-kenamin umá múte yaúyóro. ");
INSERT INTO usa_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","kemá keráwáqá ketibon-áúbáqá túbi marániye ítero. Móteti tirummá umátikena tíwâqnaa íniye téq túyánámmá kéitaao Móteti wenamáa keráwáqtí túbi marániye. ");
INSERT INTO usa_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","keráwáqá Mótetima tirummô kámeqa kemmá tirummá timínoe. ááqibo wení aúbabi keqtábámá agatáiye. ");
INSERT INTO usa_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","agatáímma tirummô íkámeqa náaraq umáwaq ketáama tirummá amínéq onábiyo?” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","anaaékaq Îtuma anó-nokayukon áwîqa Kááriribaqa nopí-káárébí meran-ábápáq uráiye. ");
INSERT INTO usa_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","ááqibo Îtuma kégoitata karí atóbamayikain-awaameqa aónawaeta taíbaq-wayukama anaaé wakááe. miráitata ");
INSERT INTO usa_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Îtuma anuraqá wení iyápó-annagaraq umáqe-uraae. ");
INSERT INTO usa_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Ítíráaeo-wayukati kótámaki-kanaama waaqókárîq uráiye. ");
INSERT INTO usa_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Îtuma múte aónaimma taígani-kayukama wenôpaqa kéyewana káonena Píripiqtaba timá ámikaiye: “náakakena taíbaq-awaaqa meyáníq umátaawaq maami-káyúkámá yiménúnataabiyo?” téna Îtuma Píripimma ítama aónaraiye. ");
INSERT INTO usa_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Îtuma wemô miráini-qtataaqa ítáreboana paá Píripimma kumá yumá ítarena ");
INSERT INTO usa_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Píripi yauwéqma Îtumma timá ámikaiye: “abapaké kaayaq-wíyókón arupi óqta-mayaima mamátaa móra-mora-nakoma móra-mutaaqa yínî-kaaweqa yiménúnatae.” téna yauwéqma tiráiye. ");
INSERT INTO usa_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Îtuni iyápó-annabike móra-waigon-awiqa Áánaru Tááimoni Pítaan ábâkoma Îtumma timá ámikaiye: ");
INSERT INTO usa_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“móra-iyapogoma móra-tiyaapaq-yakaraq kaayaqá káqtútai-noyaakaraqa matokáiye” téna “ááqibo kágínagoma íma maami-máqté-káyúkábímmá kanaaráq íiniye.” téna Áánaru tiráiye. ");
INSERT INTO usa_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","tiyáápaq-tiyaapaq-tiyaakagaraq-wayukama (5,000) máqe-uraawana íráqôn-aapeqa netuqyaa wáitana wení iyápó-annama timá yímikaiye: “máqte-kayukama tíyata maraq máero.” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","ááqibo Îtuma yammá maténa “Áánûqtuo, maan-ááwáqô timénayabataa timuqá kémarakaune” timátuwena mikáq-mikaq umá yímíqme uréna keqnáámmá káqtútai-noyaaqa maténa mikáq-mikaq umá yímíqme uráiye. ");
INSERT INTO usa_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","yeráwáqá kanaaráq umá mi-kááwéqá mamá yáawana wení iyápó-annama timá yímikaiye: “aqtó-átómá aíqma aíkuyoro yaímma páabaq íyúwáaro.” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","waayúkama móra-tiyaapaq-yamma nátuweta aqtó-átómá tiyááka uréna títaupake kaayaq-kámáágúq-únámá aíqtuma ógiqmakaae. ");
INSERT INTO usa_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","waayúkama min-ánón-áwááméqá immá káoneta tirááe: “áraine. maan-nákómá Áánûqtuni amuné-náqá marabí ku máiye.” téta tirááe. ");
INSERT INTO usa_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Îtuma mi-qtátáátábámô kéitenama anuraqá páátákáá wenamáa utáiye. wemmá awíqmeta koma yeráwáqtí anón-naqa tarôq umá máena yabíqyikaikaae téta kétewana Îtuma ítátuwena páátákáá yiyuwéna anuraq utáiye. ");
INSERT INTO usa_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Îtuma anuraq máitana aaqá enánéna yúmárán immá wení iyápó-annama yenamáa Kááriri-nokayukaq kukááe. ");
INSERT INTO usa_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","nopí-káárébí utéta aqtamá Kápéranabaq wínéta urááe. Îtuma paá anuraq máena yeráwáqtôpaqa íiraiqtaba aaqá ékáiye. ");
INSERT INTO usa_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","akoqnáá-uwaa kéyoraitana nokómmá ôriq umá karááqto uráiye. ");
INSERT INTO usa_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","ayau-yatáráké non aúkáapi warárítuqme kéyeta nopí-káárébíké Îtuma non ámûraaqa yetôpaq kéitata aónaraae. yeráwáqá ikatîq urááe. ");
INSERT INTO usa_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","ááqibo Îtuma timá yímikaiye: “kemíbo ikatîq íoro!” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","yeráwáqá Îtumma nopí-káárébí auwiránéta urááe. kéowana ááqibo páátákáá yeqtí nopí-káárégómá min-ábápáq wínéta opáqá áqa irááe. ");
INSERT INTO usa_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","íbêqa iyápó-annama yuwéta nópí-káárébímô kéowatama taígani-kayukama yimónaraae. óq-aabayaanapimma yeráwáqá mi-káyúkámá aónaraamma kímora nopí-káárábímmá iyápó-annama yenamáa máeta kóuraae. ");
INSERT INTO usa_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Îtuma móra-tiyaapaq-yakaraq kaayaq-nóyáákáráq yímikai-marukaqa waaqókáqá Táíbíriati mibáké káqo-nopi-kaarema irááe. ");
INSERT INTO usa_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","maa-táígání-káyúkámá Îtugaraq wení iyápó-annagaraq aónaamma íma máawata miráitata yeráwáqá Kápéranabaqa nopí-káárébí maréta Îtumma abáá ineta urááe. ");
INSERT INTO usa_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","“aanibo yeráwáqô Îtummo káonetama nokómmá meran-ábápáq máitata ítama aónaraae: “Aráábaeo, náa-taoraq maamibáqá yénnabiyo?” téta Îtumma ítama aónaraae. ");
INSERT INTO usa_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Îtuma yauwéqma tiráiye: “áraimma kétima-timune. keqtábámô tibáá kéomma kemô anón-awaameq-yataariq únnayataba íma tibáá kéobo ááqibo kemô timúna-kaaweqa namá tímûqa yaitaq ókaraq kaawéqá timíkáae téqa tibáá kéoe. ");
INSERT INTO usa_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","keráwáqá wáqena kabiránin-aawakoni mayaímá íma máyáaro. máqte-kabirani-qtataakoma íma mamá túbáqá máráaro! keráwáqá aáwakoma watúq-watuq umá wánin-aawakoma kétikaiyo. kemá Waayúkagon-Araaqa ketôpaq ketibomá Áánûqtu wenáwîqa ikámakaipoana mirán-ááwáqá watúq-watuq umá wánin-aawaqa timénúne.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Îtumo kaawéqtábámô timá waayúkama íma ítama arútareta yeráwáqá Îtumma ítama aónaraae: “náaraq umátaawaq Áánûqtuni mayaímá wení amuq-yatááqá kanaaráq mayanúnataabiyo?” mi-káyúkámá mirá téta Îtumma ítama aónaraae. ");
INSERT INTO usa_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Îtuma yauwéqma tiráiye: “maami-máyáímá Áánûqtuni mayaíyé. keráwáqtábá timákáitana kúminakaq tirummá áméro.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","waayúkama timá ámikaae: “nóin-anon-awaameqa inataawáq ketáámá emmá tiruqtáá aménúnataabiyo? ení mayaímá nóinabiyo? ");
INSERT INTO usa_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","ketááí títaubikoma kokoq-márúkáq karaaqtatááqá íma wáikaq Áánûqtuni aúbabimma miráuma maannáe. ‘aáwaqa wíyôpake wemá yimíq-yimiq uráiye.’” Áánûqtuni aúbabi mirá téna kétiye. ");
INSERT INTO usa_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","miráitana Îtuma mi-káyúkámá timá yímikaiye: “áraimma kétima-timune. maamin-ááwáqá wíyôpake Móteti wemá íyímikaiye. ááqibo Áánûqtunopake árai-kaaweqa ketibó íbêqa keráwáqá kétimiye. ");
INSERT INTO usa_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","aáwaqa Áánûqtunopake yuwéna maa-márábí kuména maa-márábí-káyúkámá aaramá waamá wemá yeráwáqtí yirun-íyápógóní kaawéqá kéyimiye.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","waayúkama inaa-inaa tirááe: “anóko, maamirá-kááwéqá aati-aati étaa keqtáámá timíkááe.” téta tirááe. ");
INSERT INTO usa_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Îtuma timá arúta yímikaiye: “kemá kenamáárîq matúq-matuq umá mái-aawaqune. náawabi-naawabi ketôpaqo yénama íma áa yániye. náawa-naawabi kemmá arummô timénama íma non-áá akániye. ");
INSERT INTO usa_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","kemá keráwáqá kétima-timune. kemmá kétimoneqanibo íma keráwáqá kemmá tirummá kétime. ");
INSERT INTO usa_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","máqtemma ketibomá tími-qtataaqa ketôpaqtaa yínoe. náawabi-naawabi ketôpaqa yínaqa wemmá íma watuwánúne. ");
INSERT INTO usa_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","ketúyánákáq tikáinaiq íonaaq Áánûqtunopake kukáupo paá wemô timátíkái-nakoni aúyánákáq kuké-mayaune. ");
INSERT INTO usa_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","timátíkái-nakoma wení aúyánámmá miráuma wáiye. máqte-qtataaqa tímímma móra íyuwanunaboaqa ááqibo ánatai-yupaama máqtemma tími-qtataaqa múte itó-umayikanune. ");
INSERT INTO usa_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","ketibon-áúyánákó mirá kéiye. máqtekomo kemmá ketáanima káoneq tirummô kétimeqa aúgen-auwaraimma matúq-matuq umá paá mái-yataaqa íbêqa áaimma átáma kéimma ánatai-yupaama yemmá múte itó-umayikanune.” téna Îtuma tiraiye. ");
INSERT INTO usa_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Îtuma tiráipoana “kemá Áánûqtunopake árai-kaaweqa máune.” téna titata Ítíráaeo anó-monoq-wayukama timú-timun-aimma kótéyáté urááe. ");
INSERT INTO usa_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","maan-áímmá tíq-tiq umá tirááe: “maaminnâ Îtuma Yótêbin áanikobiyo? wenaboámá wenanóagaraqa ketáámá ítaraunataabiyo? nôraq itana ‘Áánûqtunopake kukáune’ kétiyo?” mi-káyúkámá téta tirááe. ");
INSERT INTO usa_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Îtuma yetí yúyánámmá ítátuwena timá yímikaiye: “keráwáqá íma náru-narun-aimma tero!” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","óq-aimma Îtuma tiráiye: “ketibomá timátíkái-nakoma wemô móra-nakoma ketôpaq yabiti máena yíniye. ááqibo ketibomá móra-nakoma íyabiti máena wemmá ketôpaq íma yíné iné. náawabi ketôpaq yin-náqá ánatai-yupaama wemmá múte itó-umakanune. ");
INSERT INTO usa_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Áánûqtuni wannaabí Áánûqtu wení amuné-wáyúkámá agatááe. máqte-kayukama Áánûqtu yiráátiniye. minnáyaba yemá náayubi ketibon áama itétama náayubi yemmô yirááti-qtataaqa ítama arutétama yeráwáqá ketôpaq kéeye. ");
INSERT INTO usa_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","móra-nakoma ketibommá íaonaraane. kímora-naqa Áánûqtunopake kúmîn-nakoma wenamáa ketibommá aónaraiye. ");
INSERT INTO usa_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","48","áraimma kétima-timune. náawabi arummá kétimenama aati-aatimá matúq-matuq umá kémaiye. kemá matúq-matuq umá mái-aawaqune. ");
INSERT INTO usa_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","keráwáqtí títaubikotaa kaqmáápaqa yímikain-aawakon áwîqa máánna Áánûqtunopake kúmitata nátuweta pukurááe. ");
INSERT INTO usa_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","náawabi maakáq-ááwáqá Áánûqtunopake kúmin-aawaqa nénama wemá ípuiniye. ");
INSERT INTO usa_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","kemá kenamáárîq Áánûqtunopake kukáunama aati-aatí paá mái-aawaqune. náawabi maamin-ááwáqá nénama aati-aatí paá matúq-matuq umá mániye. min-ááwáqá timúnnama minnâ ketúmiye. maa-márábí-káyúkáyábáé téq kukáune. ááqibo ketúma yiménúnaboata yemá aúgen-auwaraimma mayánóe.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","maami-qtátááqtábá anó-monoq-wayukama aamá móté-máté umá tirááe: “náaraq umá wenaúma timínataaq nanúno?” téta tirááe. ");
INSERT INTO usa_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","ááqibo Îtuma timá yímikaiye: “ítama arútáaro! Waayúkagon-Araakon aúma íma néqa wení naaegáráqá íma néqa aúwaraimma keráwáqá paá íma mayáinoe. ");
INSERT INTO usa_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","náayu-naayubi ketúma néta ketí naaemá néta íya-kayukama aati-aatimá matúq-matuq umá mánopoata ánatai-yupaa máqtemma ketúma naíyaqa yemmá múte itó-umayikanune. ");
INSERT INTO usa_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","ketúma kateko-ááwáqá wáitana ketí naaemá áraimma naí-yátááqá wáiye. ");
INSERT INTO usa_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","náawa-naawabi ketúmo néna ketí naaemô néna ína-waigomma wení aágoma tirunóbáqá mánipoaqa ketaágoma wenarunóbáqá mániye. ");
INSERT INTO usa_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","máqten-auwaraimma ketibomá timátíkái-nakoma wenaúyánákáráq kéena miráuma móraiq umá ketiboní paá mái-yataaqa ketê wáiye. miráipoana móra-nakoma ketúma nénama arunóbáqá ketí mái-yataaqa mayániye. ");
INSERT INTO usa_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","maamin-ááwáqá Áánûqtunopake kukáiye. títaubikotaa kaqmáápaqa nátuweta pukurááe. mirán-ááwáqá íma wáiye. ááqibo náawabi maamirán-ááwáqá nénama matúq-matuq umá mániye.” ");
INSERT INTO usa_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Îtuma Kápéranabaqa monoq-náúpáqá kéyiraatena mirá téna timá yímikaiye. ");
INSERT INTO usa_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","ááqibo yaímma wení iyápó-annama maamin-áímmá kéiteta yé tirááe: “maamin-áímmá ummaamá kéyaiye. náawa kanaaráqá itáné inábiyo?” téta tirááe. ");
INSERT INTO usa_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Îtuma wenáúyánánóbáqá wení iyápó-annamo aamô káráán-aimma ítaraiye. miráitana wé timá yímikaiye: “maamin-áíkómmá túyánámmá ítama yuwánéraq kéoo?” téna Îtuma timá yímikaiye. óq-aimma Îtuma tiráiye: ");
INSERT INTO usa_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","“ááqibo keráwáqá aónáíyanamo Waayúkagon-Araaqa naayóbáqô maéwai-marupaqa uínaqa nôraq íno? ");
INSERT INTO usa_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Áánûqtuni aágoma mái-yataaqa waayúkama yetôpaq kéyimiye. ááqibo túgotaa íma tíwáqnaa íné iné. maamin-áímmá keráwáqá timá tímikaunama Áánûqtuni mái-yataakaraq wení aágogaraq paá máiye. ");
INSERT INTO usa_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","aanibo keráwáqtí aúkáapimma yaímma-wayukama yirummá íma kétime.” téna Îtuma óq-aimma tiráiye: ");
INSERT INTO usa_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","“miráipoaq timá tímikaune minnâ ketibomá móra-naqa íma timákainena ínanama wemá ketôpaqa íma yíné iné.” téna Îtuma tiráiye. naayóbáqá Îtuma aónatukaiye yaímma-wayukama íma yirummá kámeta anaaéma íkéwareta kéo-kayukama ááqibo wemá webómô agayakánín-naqa wemmá aónaraiye. ");
INSERT INTO usa_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","maamin-áímmá ánatagitata taíbaq Îtuni iyápó-annabike ayuwéta yauwéqma kóuraae. ááqibo kó éta íma wetêma ókaraqa uréire urááe. ");
INSERT INTO usa_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","miráitana Îtuma min-ánnámá tiyááka naikamá kaayaq-wáyúkámá áqnáábaq yááyarena timá yímikaiye: “keráwákáráqá tiyuwéra kégo?” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Tááímoni Pítaa maará téna timá ámikaiye: “uyátáraana-nako, náawanoparaq ónúnataabiyo? aati-aatimá paá matúq-matuq umá mái-aimma ení áama matokááne. ");
INSERT INTO usa_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","ááqibo ketáámá tirummá ámikaunatae. enamáa emá Áánûqtuni katekomá aokaq-náqá máanataa ketáá kéitaunatae.” téna Pítaa tiráiye. ");
INSERT INTO usa_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Îtuma ye táaraqa yauwéqma timá yímikena tiráiye: “nôraq inábiyo? kemá kenamáárîq keráwáqá tiyááka umá kaayaqá ketúyánákó kétikaipoaq matáunama móra-naqa Tááqtaan-aagogaraq máiye.” téna tiráin-naqa ");
INSERT INTO usa_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","wemá Yúqtaati aboámá Tááímoni Itikáárioti wemá wenamáa tiyáákagaraqa kaayaq-íyápó-ánnábíkémá wemá anaáekaq namuro-wáyúkábí Îtumma awíqmena wíniye. ");
INSERT INTO usa_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","anaaékaq Îtuma Kááriri aúkáapi márûtaba-marutaba uréire uwáena uráiye. Ítíráaeo anó-monoq-wayukama Îtumma ikamínéta owana Yúríabaq íuraiye. ");
INSERT INTO usa_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","ááqibo Ítíráaeo-wayukati ayú maqnáno-kanaama áwîqa pórábónakaa-naupaq ayú maqnarááe mi-kánáámá waaqókárîq itanabóana ");
INSERT INTO usa_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","wení ábâqawaama timá ámikaae: “ení iyápó-annama mibáq emô mayáana-mayaima aónanobo maa-márúqá yuwé Yúríabaqa waao. ");
INSERT INTO usa_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","móra-nakoma wé máqte-kayukama wemô náawabiyo téta wemmá aónaineta íyanama wé íma aúpáqá mirá íiniye. ááqibo maami-qtátááríqô ínéma máqte-kayukati yúrakaq itó-ure mirá kéinata emmá aónaaro.” téta timá ámikaae. ");
INSERT INTO usa_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","áraine. wenábâqawaayugaraqa íma yirummá améta anaaémma íwakaae. ");
INSERT INTO usa_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Îtuma timá yímikaiye: “ketí kanaamá íma pááq uráiye. ááqibo máqte-kanaama minnâ keráwáqti kanaamíye. ");
INSERT INTO usa_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","maa-márábí-káyúkámá keráwáqá íma webó kágatikaae. ááqibo kemá yeqtí táígoniq on-ááímmá timá abarokáq kéunataboata kemmá webó kágatikaae. ");
INSERT INTO usa_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","keráwáqá kenamáárîq ayú maqnáíbáq ko aónaaro. ketí kanaamá íma pááq uráipoaq kemá ígo-aonanune.” ");
INSERT INTO usa_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","maamin-áímmá ánatagitana Kááriribaq wemá máqe-uraiye. ");
INSERT INTO usa_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","ááqibo áqnáabaqa ábâqawaayuma ayú maqnáíbáq kówana wemá anaaékaq aúpáq utáiye. miráipoana waayúkama wemmá íaonanoe. ");
INSERT INTO usa_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","máqtemma Ítíráaeo-wayukama ayú maqnaapí weqtábá abáá urááe: “náakaraq min-náqá máiyo?” téta ítama aónaraae. ");
INSERT INTO usa_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","waayúka-aukaapimma yaímma-wayukama wé kanaa-náré kétewata yaímma-wayukama wé kaaqaari-náré kétewata miráuma nóbíq-naabiq-aimma tirááe. ");
INSERT INTO usa_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","ááqibo waayúkama anó-monoq-wayukati yáaqa kéikatetaboata móra-nakoma íma abarokáq umá aá tiráiye. ");
INSERT INTO usa_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","ayú maqnaa-kánáámá ánatanena aúkáa-makaariqa itana Îtuma anó-monoq-naupaqa uténa aarawaamá kéyiraatena kétima-yimiye. ");
INSERT INTO usa_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Ítíráaeo-wayukama yúyánámmá ítama netuqnaatúq kéeta tirááe: “náaraq umáwaq maamin-nákómá aúbabimma aónarenaawaq aúbama kéyorautiyo? wemá naayóbáqá íma tugarú tiráiye.” téta tirááe. ");
INSERT INTO usa_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","miráitana Îtuma yauwéqma timá yímikaiye: “kemô kétiraatunnama íma ketôpake íkeiye. paá timátíkái-nakonopake kéiye. ");
INSERT INTO usa_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","náawabi timátíkái-nakoni aúyánámmá itaínana wemá kemô aráátúnnayataba ítama aruténama Áánûqtunopakena kukáíyô ketááq maqmawa kétuno téna ítama arutániye. ");
INSERT INTO usa_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","náawabi wenáúyánápíkén-áímmô ténama aanábógó wenáwîqa múte yauwínéna tíniye. ááqibo náawabi timátíkái-nakon áamo ténama wení watáama árain-aine. aanibo watáama kaaqaari-áímmá arunóbáqá íma wáiye. ");
INSERT INTO usa_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","naayóbáq Móteti aammá aúmakain-aimma íyaq tímikainabiyo? ááqibo móra-nakoma keráwápíkémá íma maamin-áímmá yáqtoqma akoqnáá uráiye. nôraq itaráq kemmá tíkaminera tibáá kéoo?” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","aarawaamá yauwéqma tirááe: “epímmá kuti-áágómá wáiye. náayuq emmá ikamínéta kéowaawaq aíbôqnaaboq-aaikon-aimma kéteno?” téta tirááe. ");
INSERT INTO usa_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Îtuma yauwéqma tiráiye: “Tabaati-yúpááráqá kemá móra anón-awaameqa únnayaba keráwáqá káoneq iyánáaqa kéoe. ");
INSERT INTO usa_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","maamináyaba Mótetima áumo karaí-ááímmá tímikaine. áraine. min-ááímmá íma Mótetikaqa pááq uráiye. wé tináábútáá títaubikokaqa pááq uráiye. miráimanibo keráwáqá Tabaati-yúpááráqá pááqyan-iyapogon aúma karéwaone. ");
INSERT INTO usa_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","24","keráwáqá Mótetini aammá aúkain-aaimma íráqôniq umá waqmá itánúnatae kéteo. keráwáqá Tabaati-yúpárááqô iyápótí yûmo karéwaomano. aónaaro! Tabaati-yúpááráqá kemá móra-naqa mútûq atúbamakaraune. ááqibo nôraq itaráq keráwáqá tíyamma kéumatikaao? keráwáqá íma túrakakemma aónama yaínááro. máqte-qtataakon-aaimma arútáraina-yataaqtaba ítama yaínááro.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","ááqibo yaímma Yérútáárebake-noinin-aukaqa tirááe: “wé maamin-náráq ikamínéta kéoo? ");
INSERT INTO usa_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","ááqibo aónaaro! wemá abarokáq aamá kétiye. ááqibo yé íma móra-aimma kétimakaae. áraine. máqtemma anó-kayukama yé ítaraae wé Metáíyabiyo? ");
INSERT INTO usa_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","miráimanibo ketáá wemó yi-márúqá aónaraunatae. ááqibo Metáíyamo ínaqtaama móra-nakoma íma wemô kúmi-maruqa íaonaraiye.” téta tirááe. ");
INSERT INTO usa_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Îtuma monoq-náúpáqá máena waayúkama kéyiraatena timá yímikaiye. wemá ááyataa umá tiráiye: “keráwáqá kemmá kétimoneraq kemô yúnna-maruqa aónaraune kéteo? miráimanibo kemá kenamáárîqa ke-túyánákáqá íkukaune. áraine. timátíkái-nakon aúyánápíké timátíkáitaqa kukáune. wenáaimma áraine. miráimanibo keráwáqá wemmá íaonaraae. ");
INSERT INTO usa_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","ké kemá wemmá aónaraune. kemá wetê máqe-uraune. ááqibo wetê máunana wé timátíkáitaqa kukáune.” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","miráitata yé wemmá ánná amínéta urááe. miráimanibo wení kanaamá íma pááq uráiye. miráitana móra-nakoma íma aneqá ayáámma ánékukaiye. ímiye. ");
INSERT INTO usa_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","taígani-kayukama aúkáapikemma yaímmma-wayukama yirummá améta tirááe: “Metáíya yénama óq-anon-awaameqa mú mikáq anón-awaameqa íníyô?” téta tirááe. ");
INSERT INTO usa_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Îtuqtabama waayúkama netuqnaatúq-aimma káráán-aimma Pérati-wayukama ítátuweta uyátárai-monoq-wayukagaraqa Pérati-wayukaqaraqa i-wáyúkámá timáyíkááwata Îtumma ánná amínéta urááe. ");
INSERT INTO usa_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Îtuma tiráiye: “kemá keráwátê pááqya-kanaama mánunaboaq kemá timátíkái-nakonopaqa kónune. ");
INSERT INTO usa_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","ááqibo keráwáqá kemmá tibáá kéomanibo keráwáqá kemmá íkétimonaae. keráwáqá kenamáárîq kemá máuna-marupaqa íma kanaaráq uínoe.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","miráitata yé Ítíráaeo-wayukama ye-íyáá aayó-aayo kéteta tirááe: “wé náakaraq kóínaqtaa íaonanunataabiyo? wemá Karíki-marupaq íyaq uráíyô? káqomma Ítíráaeo-wayukama mibáq máapoana kémaena mibáq Karíki-wayukama timá yiráátiniyo? ");
INSERT INTO usa_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","wé kétiye. ‘keráwáqá kemmá kétibaaoe. miráimanibo keráwáqá íkétimonaae’ ááqibo ‘keráwáqá kemô máuna-marukaqa íma kanaaráq uínoe.’ téna kétiye. maamin-áíkón áaimma nóinabiyo?” téta tirááe. ");
INSERT INTO usa_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","ánatainna-taoqa mú mikáq anó-taoqa ayú maqnaapí Îtuma itó éna waéqma itaí-áímmá ááyataa umá anón-aimma tiráiye: “móra náawa-naawabi non-áámô akaína-naqa ayuwáíyanawaq ketôpaq yíno kéyenawaq wemá naíno. ");
INSERT INTO usa_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Áánûqtuni áa agamatán-áúbábí kétiye. ‘arunóbáké matúq-matuq umá mái-noko metiráá yubátuwena kumíniye’ mirá kétiye.” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","maamin-áímma Îtuma Áánûqtun-aagotaba kétiye. máqtemma náayubi wenáaraqo itétama Áánûqtuni aáma mayánoe. Îtuma pukáipike íma itó-uraipoana mi táoqa Áánûqtuni aáma íma yímikaiye. ");
INSERT INTO usa_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","yaímma-wayukama min-áímmá kéiteta mamá tirááe: “wé maamin-náqá áraimma Áánûqtuni amuné-náqíye.” téta tirááe. ");
INSERT INTO usa_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","yaímma-yu tirááe: “wemá áraimma Metáíyae” kétewata ááqibo yaímma-yuma “ímiye” kétewata “Metáíyaraatati wé miráuma Kááriri-marupake íyine iné.” téta ");
INSERT INTO usa_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","“íyaq Áánûqtuni áa agamatán-áúbábí Metáíyaqtaba tiráinabiyo? móra-aaniko Tébitin-annabike Béqtaremubaqa Tébitini pááqya-marupake kéiye.” téta tirááe. ");
INSERT INTO usa_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","ááqibo miráitata Îtuqtabae téta máqtemma aaraukáqá mamá yáíkaaq urááe. ");
INSERT INTO usa_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","yaímma-wayukama aneq yáqtoraineta kéetamanibo ááqibo móra-nakoma íma wenaneqá ko yáqtokaiye. ");
INSERT INTO usa_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","miráitana anó-monoq-naupake i-wáyúkámá yauwéqma yewata uyátárai-monoq-wayukagaraq Pérati-wayukagaraq min-í-wáyúkámá ítama yimónaraae: “nôraq itaráq keráwáqá wemmá íawiqme irááo?” téta ítama yimónaraae. ");
INSERT INTO usa_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","i-wáyúká yauwéqmá tirááe: “móra-nakoma maan-nákó tiníq umá íketimiye.” téta tirááe. ");
INSERT INTO usa_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Pérati-wayukama yetábámá mirá téta timá yímikaae: “wemá keráwákáráq tímioq-naayoq kéiyo? ");
INSERT INTO usa_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","keráwáqá aónaraawaqtaawaq móra ketáábíké uyátárai-monoq-wayukabi Pérati-wayukabikemma yirummá ámikaa íyabiyo? ");
INSERT INTO usa_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","ímiye! paá maami-káyúkámá aá íma ítaraa-kayukama Áánûqtuni áa Móteti agatáimma íma kéitaae. Áánûqtu yawááq-umayikaniye.” téta timá yímikaae. ");
INSERT INTO usa_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","ááqibo yeráwápíké móra-nakon-awiqa Níkótímati wemá naayóbáq Îtunopaq ko aónaraiye wemá timá yímikaiye: ");
INSERT INTO usa_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“ketááí Ítíráaeo-wayukati aammá aúkain-aikoma móra-nakomma íma ketáá yawááq-umakaraananataa wemô naayóbáqô nôrabi uráina-yataaqtaba tínataa itánatae.” téna Níkótímati tiráiye. ");
INSERT INTO usa_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","yeráwáqá yauwéqma tirááe: “egáráq Kááriribakenabono? emá Áánûqtuni aúba-wannaabin-aimma yorautíq-yorautiq umá aónaao! mipí móra Áánûqtuni amuné-náqá íma Kááriri-marupake íma pááq íniye.” téta tirááe. ");
INSERT INTO usa_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","máqte-kayukama yeqtí naaópataa wéyáwé umágoana Îtuma Óríbêti-anuraq utáiye. ");
INSERT INTO usa_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","aabáyaanapimma nokáápaq anó-monoq-nama kuru aúkáanobaq wáipaq móragaraq yauwéqma kéuwitata máqtemma wenôpaqa iráawana maraq máena aarawaamá kéyiraatena timá yímikaiye. ");
INSERT INTO usa_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","móra-inikoma máqtemma aá itaí-wáyúkágáráq Pérati-wayukagaraq min-ínímmá awíqmeta irááe. min-íníkómá aaraukáqá mamá kéyainaitataboata yetúbáq aúkáapi mú itó-umakaraae. ");
INSERT INTO usa_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","yé Îtuma timá ámiketa tirááe: “tirááti-nakotao, maan-íníkómá kiyaamorîqa kéena aaraukáqá mamá kéyainaibo wemmá aónaaro! ");
INSERT INTO usa_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","aammá aúmakain-aipimma Móteti mirá téna timá tímikaitae. mirámô íyan-ininaukaqa óqtatanapo ikámóro téna timá tímikaitae. emá é nóina kéteno?” téta tirááe. ");
INSERT INTO usa_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","yé mirá téta wemmá makáqma aónaraae. yeráwáqá móra-aimma abáá-uma aá timákanetaboata mirá-tiraae. miráitana Îtuma aítaubitaukaq máqe-urena ayáánaubiqnapo marabí aúbama agatáiye. ");
INSERT INTO usa_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","yemá ókaraq-okaraq umá itaa-itaa urááe. aanibo wé itó-urena timá yímikaiye: “waayúka-aukaapikemmo móra-nakoma kúmiq-yataaqa kebó-yátááqá otaammá kuí-qtataaqa íma wárainanama áqnáabaqa móra-oqtatama min-íníkómá aneqá iyaabóma ikamíno.” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","ááqibo keqnáámmá aítaubitaukaq máqe-urena ayáánaubiqnapo mararáqá aúbama agatáiye. ");
INSERT INTO usa_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","yé miráuma ítátuweta máqtemma máápaqtaa móra-mora yáubaguraae. máqtemma anó-kayukama áqnáabaqa kówata yinaaémma tébakaq-wayukama yáubaguraae. ááqibo Îtumma wenamáa ayuwéta kóuraae. kówana wenamáa min-íníkógáráq máqe-uraiye. wemá Îtun aúbáq itó-uma máitana ");
INSERT INTO usa_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Îtuma itó-urena min-íníkómá timá ámikaiye: “maan-íníkô, yé náakaraq mááo? móra-nakoma enôpaqa íyaq óqtatamma iyaabótukaiyo?” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","min-íníkómá tiráiye: “anó-nako, móra íma máiye.” téna tiráiye. ááqibo Îtuma timá ámikaiye: “kegáráqá íma yawááq kéumakaune. emá kóaao. kóure anaaékaq íma móragaraq kebó-yátááqá uwo!” Îtuma maamin-íníkómá timá ámikaiye. ");
INSERT INTO usa_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","anaaékaqa Îtuma keqnáámmá tiráiye: “kemá maa-márábín-ómmúne. náawabi ketinaaémo warénama wemá matúq-matuq umá mái-omma kémayena kumayuqnóbáq aati-aatimá íma uréire íniye.” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Pérati-wayukama wemmá timá ámikaae: “emmá enamáárîq timá waéqme uréire kéone. emô téna-yataaqa íma áraimiye.” téta tirááe. ");
INSERT INTO usa_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Îtuma yauwéqma tiráiye: “kemá kenamáárîq ketáayaba tennamá áraine. káqo-nakomo máena ketáayaba tínnama árain-aimma tíniye. kemá náakakenabi iréq náakarabi kemá ónúnama kéitaune. miráipoana ketáama árain-aimma wáiye. ááqibo náakakenabi iréq náakarabi kemá ónúnama keráwáqá íkéitaae. ");
INSERT INTO usa_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","keráwáqá maa-márábí-káyúkámá paá maa-márábín-ááíqtábámá ítama kéyainaabo kemá móraiq umá móra-nakoma íma yawááq kéumakaune. ");
INSERT INTO usa_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","kemá íma kenamáa máune. timátíkái-nakoma minnâ ketibomá ketimakaq máiye. miráipoana kemô móra-yataaqa kéyainaunama árain-aaimma kéyainaune. ");
INSERT INTO usa_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Ítíráaeo-wayukati aammá aúkain-aipimma kétiye. kaayaq-nákórátámô móra-aimmo tíyamma minnâ yenákámô nóinabi tíyamma árain-aine. mirá téna kétiye. ");
INSERT INTO usa_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","kemá kenamáárîq ketábá kétunama ketibomá timátíkái-nakoma ketábágáráq kétiye.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","yeráwáqá ítama aónaraae: “enabomá náakarabiyo?” téta ítama aónaraae. Îtuma yauwéqma tiráiye: “minnámo kemmô kétimonaama minnâ ketiboé. ááqibo kemmô kétimoneqa minnâ ketibo aónainoe.” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Îtuma maamin-áímmá anó-monoq-naupaqa kéyiraatena waaqókáq Áánûqtuma yimuqá marakéta áme-moneqa wáinaukapaqa timá yímikaiye. wení kanaamá íma iráipoata móra-nakoma íma ánná ámikaiye. ");
INSERT INTO usa_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","miráitana keqnáámmá Îtuma timá yímikaiye: “kemá kégounaboaqa keráwáqá kemmá tibáá inomanibo keráwáqá keráwáqtí kúmiq-yataapikaraq kebó-yátáápíkáráq uínoe. kemá kónabaqa keráwáqá kenamáárîq íma kanaaráq uínoe.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","miráitata máqtemma Ítíráaeo-wayukama tirááe: “minnâ wenamáárîqa íyaq ikámma puínéna kéiyo? nôraq inábiyo wé tiráiye ‘kemó koúna-marupaqa keráwáqá íma kanaaráq uínoe?’” téta tirááe. ");
INSERT INTO usa_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","ááqibo Îtuma óq-aimma timá yímikaiye: “keráwáqá napakémíbo kemá yanaapákémúne. keráwáqá minnâ maa-márábí-káyúkámóbo kemá maa-márábíké-náqá íma máune. ");
INSERT INTO usa_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","miráitaq keráwáqá timá tímíqma ánataraune. keráwáqá keráwáqtí kúmiq-yataapikaraq kebó-yátáápíkáráq puínoe. keráwáqá tirummô timíyaqa náawabi MÁUNE. kegáráq Áánûqtute mórabi máune. áraimma keráwáqá keráwáqtí kúmiq-yataapikaraq kebó-yátáápíkáráq puínoe.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","yé timá ámikaae: “ááqibo é náawabono?” téwana Îtuma timá yímikaiye: “minnâ áqnáabaqa kemá nóine térabi timá tímikaune. ");
INSERT INTO usa_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","netuqyaan-áímmá keráwáqtábá kenamáárîq timá keráwáqá yawááq-umatikanaa únnae. ááqibo óq-aimma tenúne. máqten-aimma kemá marabí-káyúkámá kétima-yimunama mútûqa timátíkái-nakoma wenôpake itáunama wemá aati-aatimá áraimma kétiye.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","aboáqtábá kétitata yemá íitaraae. ");
INSERT INTO usa_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","miráitana Îtuma timá yímikaiye: “anaaékaqa kemá Waayúkagon-Araakokaqo kaapaq-yátáqá múte yauyéqa mikáqá kemmá náawabi MÁUNE timónanoe. máqte-qtataariqo kéunama kenamáa kenamáárîq íkeune. ímiye. kemá maami árain-aimmo túnnama ketibomá kétiraatena timá tímin-aimma kétune. ");
INSERT INTO usa_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","maaminámo timátíkái-nakoma wemá ketê máiye. máqte-qtataariq únnayaba wemá amuqá kématikaipoana wemá kemmá ítiyuwaitaq kenamáa íureire kéune.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","wemá aamô kétitama taíbaq-wayukama wemmá yirummá ámikaae. ");
INSERT INTO usa_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","móragaraq Îtuma Ítíráaeo-wayuka wemmô yirummá ámê-kayukayaba tiráiye: “kerawáqô ketáabimmo máeqa áraimma keráwáqá ketí iyápó-annama mááe. ");
INSERT INTO usa_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","keráwáqô ketáabimmo máeqa keráwáqá máqten-arai-qtataaqa aónéqa árain-aaimma ítaraunama keráwáqá ánnábike ayútikaiyaqa kóinoe.” téna Îtuma timá yímikaiye. ");
INSERT INTO usa_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","mirá téta yemá timá ámikaae: “ketáámá Áabaraan-annabike-kayukataa máunatae. óq-wayukama keqtáámá íyaqtorewaone. ‘keráwáqá ánnábike ayútikaiyaqa kóinoe’ nôraq itaawáq kéteno?” téta tirááe. ");
INSERT INTO usa_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Îtuma yauwéqma tiráiye: “árain-aimma kétima-timune. kúmiq-yataariq i-nákómá otaammá kuína-nakokaraqa minnâ otaammá kuína-yataakoma wemmá yáqtoqma ánná kámiye. ");
INSERT INTO usa_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","yáqtorai-nakoma ábâqawaan aúkáapimma íma máiye. ááqibo paá áanikoma ábâqawaan aúkáapimma wemá aati-aatimá máiye. ");
INSERT INTO usa_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","otaammá kuína-yataakoma keráwáqô yáqtorainaqa kemá áanikoma aati-aatimá ketibotê kémaunaboaq kemô yabítuwanaqa kóinoe. miráipoana áraine móra-nakogaraq móra-yataakaraq keráwáqá íma kanaaráq yáqtoraniye. ");
INSERT INTO usa_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","kemá ítaraune. Áabaraan-annama mááe. ááqibo kemô timátimuna-yataaqa íma kémaiyeq kemmá tíkamino-kanaayaba abáá kéoe. ");
INSERT INTO usa_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","ketibonôpaq wái-qtataaqtaba aónareqa kétima-timune. nóinainabi ketibonôpakemo ítáama miraíno.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Ítíráaeo-wayukama miráuma tirááe: “ketibotáá Áabaraama máiye.” téta tirááe. Îtuma yauwéqma tiráiye: “Áabaraan-annama máeq oweqa wemô mayaímá máyáinikaa umá mayaíné oné. ");
INSERT INTO usa_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","kemá árain-aimma Áánûqtunopake ítama timá tímikaunaboaqa keráwáqá kemmá tíkamineqa tibáá kéoe. Áabaraama mirá íuraiye. ");
INSERT INTO usa_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","keráwáqá Tááqtaama keqtiboní mayaímá kémayaabo!” téna Îtuma kétitata waayúkama agaren áaimma tirááe: “aguyáán-iyaporaa íma máunatae. Áánûqtu wenamáa ketibotáá máiye.” téta mi-káyúkámá tirááe. ");
INSERT INTO usa_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Îtuma timá yímikaiye: “Áánûqtuqtaba ketiboé téq oweqa kemmá túyánámmá timíné oné. kemá Áánûqtunopake iréqa íbêqa maami máunaboaqa kemmá túyánámmá timíné oné. kemá íma ketúyánápíkémmá kukáupo Áánûqtu timátíkáitaq kukáune. ");
INSERT INTO usa_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","nôraq itaráq ketáama íma ítama kárutao? ketáama íkétikaipoaqa keráwáqá íma kanaaráq ítama kárutaae. ");
INSERT INTO usa_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","keqtibomá Tááqtaama máitaq ákái-qtataariq kéoe. Tááqtaama naayóbáqá áqnáabaqa káqo-nakomma ikákaiye. aboámá máiye. wepímmá árain-aaimma íma wáitanaboana wemá aati-aatimá árain-aaikon-anaaema íkéwaraiye. wemô kaaqaari-áímmô kétena wenáabike mirá téwaine. maami-kááqáárí-nákómá kaaqaarimô kétenama kaaqaari-áíkón aboámá máiye. ");
INSERT INTO usa_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","ááqibo kemá áraimma kétima-timunaqanibo kemmá íma keráwáqá tirummá kétime. ");
INSERT INTO usa_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","kanaaráq móra-waigoma keqtábá kúmiq-yataariq kéone tíníyô? kemô áraimmo kétima-timunaqa nôraq itaráq ketáama íkéitaao? ");
INSERT INTO usa_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","náawabi Áánûqtuni iyápóma máenama wemá Áánûqtuni áama kéitaiye. keráwáqá íma Áánûqtuni iyápó máepoaqa íma wenáaraqa kéitaae.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Ítíráaeo anó-monoq-wayukama yauwéqma tirááe: “emá Táméria-napoa kuti-áágón áaraan-aimma kéteno? ketáámá árain-aimma kétunataabiyo?” téta anó-monoq-wayukama tirááe. ");
INSERT INTO usa_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Îtuma yauwéqma tiráiye: “kuti-áágómá tirunóbáqá íma máiye. ááqibo ketibon áwîqa múte kéyauyune. áánibo keráwáqá ketíwîqa múte yauwínôqtaba kammáa kámagoe. ");
INSERT INTO usa_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","51","kemá ketíwîqa íma múte yauyónáá kéune. ááqibo móra-nakoma ketíwîqa múte yauwínéna kéena wemá mamá kéyainikaiye. áraimma keráwáqá kétima-timune. móra-nakomo ketáama warénama wemá aati-aatimá ípuiniye.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","anó-monoq-wayukama miráuma tirááe: “árain-uramma íbêqa itáunatae. epímmá kuti-ááqómá arunóbáqá wáiye. Áabaraama pukuráitata Áánûqtuni amuné-wáyúkágáráq pukurááe. ááqibo emá kétene ‘móra-nakoma ketáamo warénama ípuiniye.’ ");
INSERT INTO usa_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","54","nôraq inábiyo? ketibotáá Áabaraamma pukitaa mú mikákáán-ánómmá emá máano? Áabaraama pukuráiye. Áánûqtuni amuné-wáyúkágáráq máqtemma pukurááe. emá náawana káureq kéteno?” téta tirááe. Îtuma yauwéqma tiráiye: “kemô ketíwîqo múte yauyéqa minnâ ketíwîqa paátataaqiye. móra-nakomo ketíwîqo múte yauyénama minnâ ketibomíye. keráwáqô temmá minnâ keráwáqtí ítóe. ");
INSERT INTO usa_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","keráwáqá wemmá íaonaraabo kemá wemmá aónaraune. kemá téqa wemmá íma aónaraune tennamá keráwákáá ónúne. kaaqaari-náqá mánune. owé. kemá wemmá aónareqa wenáama matokéq mirá kéone. ");
INSERT INTO usa_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","keqtítaubikoma Áabaraama kemá kukáuna-kanaama aónanipoana Áánûqtu aráátiraipoana ôriq umá amuqá makáiye. káonena amuqá makáiye.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Ítíráaeo anó-monoq-wayukama timá ámikaae: “emá íma móra-tiyaapaq-tiyaaka-auqa uráápo emá Áabaraamma náaraq umá aónaraano?” téta tirááe. ");
INSERT INTO usa_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Îtuma yauwéqma timá yímikaiye: “naayóbáq Áabaraamo íma máikaqa kemá kenókáá náawabi máqe-uraunama MÁUNE.” téna Îtuma timá yímikaiye. ");
INSERT INTO usa_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","miráitata yemá óqtatamma múte matéta Îtumma iyaabóma ikamínéta urááe. ááqibo wemá aúpáq péqmarena anó-monoq-naupake yaákarena aa íwáimma yaúbaguraiye. ");
INSERT INTO usa_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Îtuma uréire kéena mórama aúgaroq-naqa aónaraiye. wemá naayóbáqá anóama kémarakaitanama aúramma karopáguraiye. ");
INSERT INTO usa_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","3","máqtemma Îtuni iyápó-annama wemmá ítama aónaraae: “Aráábaeo, náawaq kúmiq-yataariq itanawáq anóama aúgaroq-iyapoma marákárainabiyo? maamin-nákóáq kúmiq-yataariqa uráí anóaboawaq kúmiq-yataariqa uráíyô?” téta ítama aónaraae. ááqibo Îtuma maará téna timá yímikaiye: “maamin-nákóní kúmiq-yataakoma íma wemmá mamá aúgaroq-naqa aúkáiye. wenanóboyuti kúmiq-yataakoma íma wemmá mamá aúgaroq-naqa aúkáibo mi-wágón áaimma miráuma íma wáiye. ímiye. maami-qtátááqá Áánûqtuni maiyáígómá abarokáq maan-nákókáq pááq íniye. ");
INSERT INTO usa_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","íbêqa aabaúmá wáinagaraq timátíkái-nakoni mayaímá máyáanatao. miráipoana aaqô enáinanama móra-nakoma mayaímá íyaonena kanaaráq ímayaniye. ");
INSERT INTO usa_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","kemá maa-márábímô máunama kemá maa-márábín-ómmúne.” mirá téna Îtuma timátuwena ");
INSERT INTO usa_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Îtuma mararáq wirááti wiqmakéna maramá abákátena wirááti-maragaraq mamá yogarí-karaariq umátuwena Îtuma yomá tarôq uráiye. tarôq umátuwena Îtuma mi-tónápó min-nákóní aúnáakaq pérakatuwena ");
INSERT INTO usa_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","miráitana Îtuma wemmá timá ámikaiye: “emá Táéróa-nokaayupi nommá koberaao.” téna tiráiye. maamin-áwíqá waéqma yarááe “timákáawana kóuraiye”. miráitana wemá uréna nommá kobékaiye. nommá pétuwena mikáké aúramma karáqma aónamaena yauwéqma iráiye. ");
INSERT INTO usa_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","ááqibo máqtemma wení márûpaq-wayukagaraqa wemmá káonaa-kayukagaraq naayóbáqá wemá aáwaqtaba aarawaamá ítama yimónéwaine téta yé tirááe: “nôraq inábiyo? aqá maamin-nákómá maraqô máena waayúkaraqa áa kéyaitana aáwaqtabama itaa-itaa éwainabiyo?” tewata ");
INSERT INTO usa_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","yaímma-wayukama tirááe: “owé. wemá maamin-náqíye.” téta tirááe. ááqibo yaímma-wayukama tirááe: “ímiye. wemá paá miráuma móraiq urái-naqiye.” tewana aanibo aanábógó wé tiráiye: “minnâ áraimma kemúne.” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","yé timá ámikaae: “nôraq itanawáq aúramma kabáríkaiyo?” tewana ");
INSERT INTO usa_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","wé yauwéqma timá yímikaiye: “min-náqá Îtue téta áwîqa kéyaae. wemá yomá tarôq umátuwena túnáakaq tótaa umátíkátuwena wé timá tímikena tiráiye ‘emá Tááéróa-nokaayupi nommá koberaao’ téna titaqá ááqibo kemá nommá kogéberaunana túrakoma íráqôniq kéitaq kéqokeq-yataaqa íbêqa káonaune.” téna titata ");
INSERT INTO usa_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","yé timá ámikaae: “min-náqá náakaraq máiyo?” tewana maará téna wemá tiráiye: “kemá paá íaonaraune.” téna yauwéqma tiráiye. ");
INSERT INTO usa_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","maamin-náqá naayóbáqá aúramma karopáguraimiye yemá Pérati-wayukaraq awíqmeta urááe. ");
INSERT INTO usa_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","mi-túpáámá Îtuma yomá tarôq umátuwena aúgaroq-naqa mamá aúramma tágayakaraiye mi táoqa Tabaati-yúpááráré. ");
INSERT INTO usa_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","mikáq Pérati-wayukama ítama aónaraae: “enaúrakoma náaraq umá íráqôniq uráiyo?” tewana wé timá yímikaiye: “wemá túnáakaq yomá pétikaitaq nommá kobéqtuwe íbêqa kanaaráq káonaune.” téna timá yímikaiye. ");
INSERT INTO usa_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","miráipoana yaímma Pérati-wayukama tirááe: “Tabaati-yúpáámá íma kawáá kéipoana maamin-nákómá Áánûqtunopake íiraiye.” téta tirááe. káqo-Perati-wayukama tirááe: “wemô kúmiq-araaq-naqa máenamoenama wemá náaraq umáwaq anón-awaameqa kanaaráq iné inábiyo?” téta timátuweta yaíkaaq umá kaayaq-ánnáé urááe. ");
INSERT INTO usa_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","miráitata min-nákómá keqnáámmá ítama aónaraae: “enaúramma wemá kékabarirakaitaa wetábámá nóineq tinóno?” téta ítama aónaraae. wé tiráiye: “wemá Áánûqtuni amuné-náqíye.” téna yauwéqma tiráiye. ");
INSERT INTO usa_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","ááqibo wemá naayóbáqá aúgaroq-naqa marákáraamanibo íbêqa kanaaráq káonaitata anó-monoq-wayukama minnáyaba yirummá íkámetaboata anóboyuma yááyareta ítama yimónaraae: ");
INSERT INTO usa_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","“maaminnâ keqtáaninabiyo? árainaq kenákámá aúgaroq-naqa marákáraayanabiyo? owé. kéteyamanibo náaraq umáwaq íbêqa wemá aúramma kanaaráq káonaiyo?” téta ítama yimónaraae. ");
INSERT INTO usa_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","anóboyuma yauwéqma timá yímikaaye: “ketáanikorataboaka aónarauyama anóama aúgaroqa marákáraimiye. ");
INSERT INTO usa_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","ááqibo wé náaraq umá aúramma kanaaráq káonaiyo? kerátá íma ítarauye. náawa aúramma mamá kabárírakaraiyo? kerátámá íaonarauye. wemmá ítama aónaaro! wemá anópoana wenamáárîq aamá timá-timiniye.” téta tirááye. ");
INSERT INTO usa_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","wenanóboyuma Ítíráaeo anó-monoq-wayukayataba yáaqa kéikatetaboata mirá-tiraaye. anó-monoq-wayukama yeráwáqá wágáábaq timá akoqnáá umákaae: “móra-nakoma Îtuqtaba Metáíyae tínna-naqa monoq-náúpáké watuwánúnatae.” ");
INSERT INTO usa_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","minnáyababoata wenanóboyuma tirááye: “wemá anómibo wekáq ítama aónaaro.” téta tirááye. ");
INSERT INTO usa_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","miráitata kaayaq táoqa keqnáámmá maamin-nákómá naayóbáqá anóama kémarakaitanama aúramma karopáguraimiye wemmá Pérati-wayukama ááyareta yé timá ámikaae: “emá Áánûqtun-awiqa múte yauyuwo! ketáá káonaunatae maamin-náqá Îtuma kúmiq-yataariq i-náqíye.” téta tirááe. ");
INSERT INTO usa_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","minnáyabo min-nákómá yauwéqma tiráiye: “wemá kúmiq-yataariq inárábi íyabiyo kemá íma ítaraune. kemá móra-yataaqa áraimma kéitaune. kemá naayóbáqá túgaroq-naqa máqe-uraunamibo íbêqa kanaaráq káonaune.” téna wé timá yímikaiye. ");
INSERT INTO usa_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","yé ókaraq-okaraq itaa-itaa umá ítama aónaraae: “wemá emmá nôraq umákáraiyo? wemá náaraq umá aúramma kabárírakaraiyo?” téta ítama aónaraae. ");
INSERT INTO usa_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","yauwéqma wé timá yímikaiye: “kemá keráwáqá timá tímikaunaqanibo íma kéitaae. nôraq itaráq keráwáqá keqnáámmá itánéra kéoo? áqa keráwákáráráq kétikaitaraq wení iyápó-annama auránéra kéoo?” téna yauwéqma tiráiye. ");
INSERT INTO usa_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","yé wemmá aá awáágureta tirááe: “emáaq wení iyápó-annama mááne. ááqibo ké ketáá Mótetini iyápó-annataa máunatae. ");
INSERT INTO usa_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Áánûqtuma Mótetima aamá ámikaiye minnáyaba kéitaunatae. miráimanibo min-náqá náakakena iráiyo? ketáá íaonaraunatae.” téta tirááe. ");
INSERT INTO usa_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","min-nákómá yauwéqma timá yímikaiye: “keráwáqá anó-kayukamanobo wé náakakena kéiyo íaonaraunatae téq kétee. aanibo wemá wenamáárîq ketúramma mamá kabárítikaraiye.” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","yé timá ámikaae: “túyánámmá kéitaunatae. Áánûqtuma kúmiq-wayukati yáama íma kéitaibo paá wenaúyánámô ítama kaqtó umá máyáa-kayukama yetáama Áánûqtu kéitaye. ");
INSERT INTO usa_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","maa-márámô tarôq urái-kanaarake íbêq-kanaarakaraq aúramma karoparáin-iyapoma marákáitana móra-nakoma íma kabárírakewaine. móra-nakoma íma kanaaráq mirá-iniye. ");
INSERT INTO usa_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","maamin-náqá Áánûqtunopake íirenama wemá anón-awaameqa kanaaráq íiniye.” téna wé tiráiye. ");
INSERT INTO usa_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","yé akoqnáá umá tirááe: “nóinabiyo! emá kúmiq-yataapi paá marákáraa íbêqa ketáá kétiraa-tennataabiyo?” téta yé timátuweta min-náqá yabitimátukaae. ");
INSERT INTO usa_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Îtuma min-náqá yabitimátúwáan-aimma ítátuwena yaónatuwena tiráiye: “emá Waayúka-Araakomma arummá káme íyabiyo?” téna ítama aónaraiye. ");
INSERT INTO usa_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","min-nákómá yauwéqma tiráiye: “anóko, wemá náawabiyo? timá tíminaq wemmá tirummá áméno.” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Îtuma timá ámikaiye: “wemmá aónatukaane. minnâ íbêqa etê watáá-wataa kéteq máune.” téna Îtuma timá ámikaiye. ");
INSERT INTO usa_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","uyátáraana-nako, kemá emmá tirummá kámune.” timátuwena Îtukaqa araayutáúmmá aténa nunamupí Îtun-awiqa múte kéyauyena timá ámikaiye. ");
INSERT INTO usa_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","miráitana Îtuma tiráiye: “maa-márábí kemá árain-aaiqtaba kaaqaari-ááíqtábá yainaíyábá kukáune. miráitata íkaonaa-kayukama kanaaráq aónanoe. ááqibo káonaa-kayukama yúgaroq-wayukama auránóe.” téna Îtuma waéqma itaí-áímmá tiráiye. ");
INSERT INTO usa_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","yaímma Pérati-wayukama wenamakaq máeta timá ámikaae: “kekáráqtáá túramma kégaropaiye. íyaq kéteno?” téta timá ámikaae. ");
INSERT INTO usa_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Îtuma yauwéqma tiráiye: “keráwáqô paá túgaroqo máeq oweqa keráwáqá íma kúmiq-yataakaraqa íineq oné. ááqibo íbêqa keráwáqá ‘kanaaráq káonaunatae’ téq kétee. miráipoana keráwáqtí kúmiq-yataaqa paá wáiye.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Îtuma mirá tiráiye: “áraimma kétima-timune. náawabi móra-nakoma tipi-típigoni kurubí oqtabákémá íuyenamo óq-aukapakemmo uyénama maami uyábéráina-naqa moyá-náqá máiye. ");
INSERT INTO usa_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","móra-nakoma oqtabákémô uyábérái-naqa wemá tipi-típi-kawaa-nare. ");
INSERT INTO usa_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","kawáábóana oqtaráq yabí-nakoma oqtamá kéiyakaiye. miráitata tipi-típima yeqtí kawáá-nákón áama kéitaae. wení tipi-típima yíwîq-yiwiqa yátuwena mi-kánóqá máápaq áqnáabaq kóitata anaaé waqmé kégumoe. ");
INSERT INTO usa_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","wení tipi-típima yiwíqma márúte yuwéna wemá áqnáabaq kégumitata wenáama kéitetaboata tipi-típi-annama anaaé wakááe. ");
INSERT INTO usa_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","káqo-wan anaaé íkewaraae. káqo-wan áama íiteta wenáaq ikátéta peréqé wínoe.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","waéqma itaí-áímmá Îtuma timá yímimanibo yeráwáqá nóin-aainabiyo téta íma ítama arútaraae. ");
INSERT INTO usa_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","ááqibo Îtuma keqnáámmá timá yímikaiye: “áraimma kétima-timune. kemá tipi-típigoni oqtamúne. ");
INSERT INTO usa_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","máqtemma áqnáabaqa ye-káyúkámá yeráwáqá moyámmá mayaí-wáyúkáé. ááqibo tipi-típigoma íma yetáama kéitaae. ");
INSERT INTO usa_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","kemá oqtamúne. náawabi oqtaráq wéna arummá tiména kurunóbáq uyáberaina wemmá kawáá umákanune. wemá uyábekena yaúbagure umá uréire kéena aáwaqtaba abáá umá mayániye. ");
INSERT INTO usa_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","moyá-nákómá moyámmá kémayena kéikamena kéqokeq-yataaqa mamá táíq inéna kéiye. kemá yúnnama minnâ yeráwáqá matúq-matuq umá mái-auwaraimma óqiqma yiménáae téq iráune.” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","óq-aimma Îtuma tiráiye: “kemá íráqô-tipi-tipi-kawaa-naqupo ketiyáánaubiqa aóna-mayaaro. íráqô-tipi-tipi-kawaa-nakoma wemá tipi-típi-annayabae téna puíniye. ");
INSERT INTO usa_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","móra-nakoma paá meyáqtábá mayaímá kémayena wemá kawaa-náqá íma máena tipi-típima íma yabíqma kárutaiye. áwáábiq-iyammo ínanama wemá iyuwéna péqmare kóinana áwáábiq-iyakoma tipi-típima yúpuqma pípéban éqé kéyuwaiye. ");
INSERT INTO usa_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","wemá paá móneqtaba mayaímá kémayena tipi-típi-yatabama íma arummá kéumayikaiye. ");
INSERT INTO usa_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","kemá tipi-típigoni íráqô-kawaa-naqune. ketí tipi-típi-annama kéyimonaunata kemmá kétimonaae. ");
INSERT INTO usa_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","móraiq umá ketibomá kemmá kétimonaitaq kemá wemmá káonaune. aanibo maami-típí-típí-ánnáyábáé téq ketí aúwaraimma yetôpaqa kéyimune. ");
INSERT INTO usa_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","ketí óq-tipi-tipima íma maami-tíqnóbákémíbo minnágaraq kemá áqnáabaq kéweq yíwíqme onata ketáama itánoe. miráíyata kímora tipi-tipi-annama máiyana kímora-kawaa-nakoma yabíqyikaniye. ");
INSERT INTO usa_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","ketí aúwaraimma kéyimune. minnágon-aaiqtaba ketibomá keqtábámá kákaiye. miráinaq anaaékaq ketí aúwaraimma yauwéqma mayánúne. ");
INSERT INTO usa_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","móra-nakoma ketí aúwaraimma íma kanaaráq matuwániye ímiye. kenamáárîq ketí aúwaraimma kéyimune. kemá ketí akoqnáárake ketí aúwaraimma kanaaráq yukéq ketí akoqnáárake kanaaráq yauwéqma mayánúne. maamin-áímmá ketibonôpake matáune.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Ítíráaeo anó-monoq-wayukama maamin-áíqtábá keqnáámmá yaíkaaq umá kaayaq-ánnáíq urááe. ");
INSERT INTO usa_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","netuqyaa-káyúkámá tirááe: “kuti-áágómá wepímmá máitana wemá aíbôqnaaboq kéiye. nôraq itaráq wenáama kéitaao?” téta tirááe. ");
INSERT INTO usa_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","yaímma-wayukama tirááe: “maamin-áímmá íma aíbôq-nakon-aamiye. móra kuti-wákómá aúgaroq-nakoni aúramma mamá íyaq kanaaráq kabárírakaniyo?” téta tirááe. ");
INSERT INTO usa_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","anaaékaq Yérútáárebaqa ayú maqnaí-kánáámá pááq uráiye. mi-kánáámá naayóbáqá monoq-námmá yimuráámuq kémareta monoq-nákóní oqtamá ítaae. mi-kánáámá yaugi-kánáámíye. ");
INSERT INTO usa_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Îtuma anó-monoq-naupaqa yítaubikoma Tórómóni-oqtaraqa uréire kéitata ");
INSERT INTO usa_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Ítíráaeo anó-monoq-wayukama amakaq yagutéta timá ámikaae: “emá Metáíyamo máema kanaaráq timá abarokáq umá-timinonatae. náaraq umá-taoraq awé ónúnataabiyo?” téta timá ámikaae. ");
INSERT INTO usa_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Îtuma maará téna yauwéqma tiráiye: “kemá timá tímîqma ánatatukaun-aqanibo keráwáqá íma tirummá tímikaae. máqte-mayaima ketibon áwîkaqa kémayaunama ketáaiqtaba kétiraatiye. ");
INSERT INTO usa_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","miráimanibo keráwáqá íma ketí tipi-típi-annama máepoaqa íma tirummá kétime. ");
INSERT INTO usa_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","máqtemma ketí tipi-típi-annama ketáama kéitaawaqa kemá yemmá kéimonaunata ketinaaéma kéwaraae. ");
INSERT INTO usa_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","kemá matúq-matuq umá paá mái-auwaraimma kéyimune. miráipoata yemá íma aúyokinoe. móra-nakoma ketiyáápikema yemmá íma yabítuwaniye. ");
INSERT INTO usa_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","nói-qtataarabi ketibomô tímîmma minnâ mú mikáq anókaapoana móra-nakoma ketibon ayáápikema yemmá kanaaráq íyabituwaniye. ");
INSERT INTO usa_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","ketibotê kegáráq kerátámá kímoramuye.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Ítíráaeo anó-monoq-wayukama keqnáámmá óqtatama mamá ikamínétamo kéowanama ");
INSERT INTO usa_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Îtuma timá yímikaiye: “netuqyaammá íráqô-mayaima ketibonôpake tiráátiraune. keráwáqá nói-mayaiyabawaq óqtatamma iyaabóma tíkaminera kéoo?” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","anó-monoq-wayukama yauwéqma timá ámikaae: “ketáámá íma móra íráqô-mayaiyabata óqtatanapo ikamónátaa kéunatae. ímiye. emá Áánûqtuma áyóqa káyaanatae. emá paá-naqanopo ‘kemá Áánûqtumune’ kétenaqtae.” téta tirááe. ");
INSERT INTO usa_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Îtuma yauwéqma tiráiye: “‘tiráune keráwáqá Áánûqturaa-moe.’ miráuma agamatámmá keráwáqtí aammá aúmatan-aipimma íyaq agatáíyô? ");
INSERT INTO usa_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","wannaabímmá Áánûqtu yemmá timá yímikena mera-káyúkáyábámá Áánûqturaane. téna yeqtábá tiráine. Áánûqtuni watáama agamatá kátáámá aati-aatimá wení akoqnááma íma kanaaráq aúyoraniye. ");
INSERT INTO usa_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","ketibomá móra-aukapaq kétikena maa-márábí timátíkaraiye. miráipoana ‘kemá Áánûqtun áanikomune’ túnnama keráwáqá keqtábámá áyóqa káyaiye kéteo? ");
INSERT INTO usa_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","ketiboní mayaímá ímo kémayaanaqa kanaaráqíbo ketáaraqa tirummá ítíméro. ");
INSERT INTO usa_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","ááqibo ketiboní mayaímá kémayaanaqa keráwáqá ketáaraqa íma tirummá kétimeq oweqa kemá mayaímá mayáunaraq káonera mi-máyáígómá tirummá kámera anaaékaq ítama arutánoe minnâ ketibomá tirunóbáqá máitaqa kemá wenarunóbáqá máune.” téna Îtuma timá yímikaiye. ");
INSERT INTO usa_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","miráitata móragaraq yáqtoqma ánná amínéta ománibo wemá iyáápike akarupátuwena kóuraiye. ");
INSERT INTO usa_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","keqnáámmá Îtuma yauwéqma uréna Yótaa-nomma atátuwe uréna naayóbáqá Yóáane nommá péqyikewaipaqa mibáq ko máqe-uraiye. ");
INSERT INTO usa_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","mibáq máitatama wenôpaqa aarawaamá netuqyaa irááe. iréta tirááe: “Yóáane íma móra-awaameq-yataariqa uráimanibo máqten-aiqtaba maami-nákótábá Îtuqtaba timá áraimma tiráiye.” téta tirááe. ");
INSERT INTO usa_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","ááqibo mibáqá netuqyaa-káyúkámá Îtumma yirummá ámikaae. ");
INSERT INTO usa_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","ááqibo móra-naqa karímá matáiye. minákón-áwîqa Aráátaratie. wemá Béqtanibake Máríaa wenaúko Máátaa yeqtí márûpake kukáiye. ");
INSERT INTO usa_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","wemá mi Máríaa ákûq-nomma Îtun-aitaukaq pérakarena aqnótáunapo áyúnakarain-inikoma ayóbíyoma Aráátarati karímá matáiye. ");
INSERT INTO usa_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","miráitata kaayaq-ánáánómá aamá yuwááyana Îtunopaqa win-áíkómá mirá-tiraiye: “uyátáraana-nako emá maannáqtábá akái-naqa karíma kémayaiye.” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Îtuma min-áímmá ítátuwena tiráiye: “wení karímá puí-kárímá íma wáiye. paá Áánûqtuni tágama-yataaqa mamá pááq ínéna kéipoana minnâ Waayúkagon-Araakon-awiqa múte yauwínoe.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Îtuma Máátaaqtabama wenaúkoqtabama Aráátaratiqtabagaraqa Îtuma ôriq umá yeqtábáma kákaiye. ");
INSERT INTO usa_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","aanibo wemá Aráátarati karí máyáiye-aimma iténa wé kaayaq táoqa ókaraq mibáq máqei-marupaq paá máqe-uraiye. ");
INSERT INTO usa_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","anaaékaqa wení iyápó-annama timá yímikaiye: “yauwéqma Yúríabaqa kónatae.” titata ");
INSERT INTO usa_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","wení iyápó-annama timá ámikaae: “Aráábaeo, íbêqa Ítíráaeo-wayukama óqtatanapo emmá ikamínéta kéoe. ááqibo emá keqnáá-márúpáráq yauwéqma ónáae téq kéteno?” tewana ");
INSERT INTO usa_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Îtuni-kanaama awaararîq kéitanaboana yauwéqma tiráiye: “íyaq tiyááka umá kaayaq-ábáúmá aaqá kamátágaraiyo? ááqibo waayúkagoma wágááma uréire kéenama maa-márábín-ókómá tágaraitana káonaipoana íma aítauqa yurarániye. ");
INSERT INTO usa_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","miráimanibo waayúkagoma nokáámmo uréire kéetama ómmá yirunóbáqá íma tágaraitanapoata yítauqa yuraránoe.” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","mirá-timatuwena anaaékaqa Îtuma timá yímikaiye: “ketááí aanábómá Aráátarati waguráiye. ááqibo kemá ko itó-umakanune.” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","máqtemma iyápó-annama timá ámikaae: “uyátáraana-nako, aanibo wemá aú wagurénama keqnáámmá paá mániye.” téta tirááe. ");
INSERT INTO usa_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Îtuma Aráátarati pukáiqtaba kétitata ááqibo wení iyápó-annama paá waguráitana kétiyaa téta yé tirááe. ");
INSERT INTO usa_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","miráitana ‘Aráátarati pukuráiye’ téna Îtuma abarokáq umá timá yímikaiye: ");
INSERT INTO usa_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","“ááqibo kemá keráwáqtábá túyánámmá kéiteqa timuqá kémaraune. kemá mi táoqa íma wetê máqe-uraune. miráinaqa keráwáqá mikáqá tirummá timínoe. íbêqa wenôpaqa ónátae.” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Tómááti wenáwíkon áaimma ábárawaoma wemá máqten-noiyapo-annayaba timá yímikaiye: “méwíyataa wegáráq ko púyonataao!” Tómááti téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","ááqibo Îtuma uráiye. wemá uréna ítaraiye Aráátarati kaayaqté-kaayaqte-yupaama muríánóbáqá (máátíq-máatinobaq) máqe-uraiye. ");
INSERT INTO usa_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Yérútáárebaqa waaqókáq Béqtanibaqa (3 km) wáiye. miráuma íma ayáqtáákaqa wáiye. paá awaarakáqíye. ");
INSERT INTO usa_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","ááqibo Ítíráaeobakemma netuqyaa-nóínínáúkáqá Máátaayaa Máríaanopaqa irááe. yetiyóbímo púiqtabama yenákátí yíyaqa mamá íráqôniq ínéta irááe. ");
INSERT INTO usa_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Máátaama Îtumo in-áímmá ítátuwena aapaq ko aónaraiye. miráitana Máríaa paá yaákarena naaúpaqa máqe-uraiye. ");
INSERT INTO usa_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","ááqibo Máátaa Îtuma timá ámikaiye: “uyátáraana-nako, maakáqô máanarakaa ketiyóbíma ípuinena iné. ");
INSERT INTO usa_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","íbêkaraqa kemá káonaune. aanibo emá nóiqtababi Áánûqtukaqo íténanama emmá paá amíniye.” téna Máátaa tiráiye. ");
INSERT INTO usa_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Îtuma timá ámikaiye: “enayóbíma paá kanaaráq itó-iniye.” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Máátaa timá ámikaiye: “kemá ítaraune. ánatai-yupaaraqa mi-túpáámá máqtemma aarawaamá keíto-iyana wemá itó-iniye.” téna Máátaa tiráiye. ");
INSERT INTO usa_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Îtuma timá ámikaiye: “pukáipike itói-aaimma paá mái-auwaraikaraqa kemúne. náawabi kemmá arummá tiména wemá puínamanibo wemá paá itó-uma mániye. ");
INSERT INTO usa_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","máqte-kayukama paá máetamo kekáq yirummó timíyamma yeráwáqá aati-aatimá ípuinoe. Máátaao, emá minnáyaba aúyánámmá kéitaano?” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","ááqibo Máátaa Îtumma timá ámikaiye: “owé, uyátáraana-nako, kemá ekáqá tirummá ámíqtukaune. emá Metáíyama máane. eqtábá Áánûqtun-aanikoma maa-márábímmá kumíniye téta naayóbáqá amuné-wáyúkámá tiráane.” téna Máátaa timá ámikaiye. ");
INSERT INTO usa_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Máátaa mirá-timatuwena aúkoma Máríaa ko ááyaraiye. ko ááyama áwábaq uréna yaákarena timú-timun-aipike timá ámikaiye: “yirááti-naqa ya máena emmá kááyaiye.” téna timá ámikaiye. ");
INSERT INTO usa_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Máríaa maamin-áímmô kéitenama páátákáá itó-uma Îtunopaqa uráiye. ");
INSERT INTO usa_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Îtuma márûpaqa íma utáibo paá wágáábaqa Máátaa aónaipaq máqe-uraiye. ");
INSERT INTO usa_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","máqtemma Ítíráaeo-wayukama Máríaagaraqa naaúpaqa máeta wenáyaqa mamá íráqôniq émáa-kayukama aónaamma wemá iyánáaq umárena páátákáá máápaq yaúbagitata yemá anaaé waqméta kukááe. wemá pukái-nakoma muríánóbáq móyukaapaq ibiqá márú-yaranenawaq kéiyaa téta waqmé kukááe. ");
INSERT INTO usa_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Máríaa Îtu máipaqo irénama Îtumma káonena aítaupi aipaq aténa timá ámikaiye: “uyátáraana-nako, emá maakáqô máanarakaatati ketiyóbíma ípuine iné.” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Îtuma aónaimma min-íníkómá ibiqá kéyaraitana Ítíráaeo-wayukama yimónaimma yegáráq ibiqá kéyaraawana arummá ôriq umágitana karagíqá wenarúnóbáqá yuráiye. ");
INSERT INTO usa_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Îtuma timá yímikaiye: “keráwáqá náakaraq wemmá ákáraao?” téna titata yé timá ámikaae: “uyátáraana-nako, iré ya aónaao.” téta tirááe. ");
INSERT INTO usa_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Îtuma ibiqá yaránéna kéiye. ");
INSERT INTO usa_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","miráipoata Ítíráaeo-wayukama tirááe: “aónaaro. weqtábá ôriq éna kákaitanaboana ibiqá kéyaraiye.” téta tirááe. ");
INSERT INTO usa_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","ááqibo yaímma-wayukama tirááe: “wemá aúgaroq-nakon-auramma kabárírakaraiye. kanaaráq wemá óq-yataariq umákainana Aráátarati ípuiniyo?” téta tirááe. ");
INSERT INTO usa_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Îtuma keqnáámmá arummá ôriq kéitana min-náqá muríánóbáq móyukaapaq iráiye. muríánôtaqa óqtanapo ayá yumákaawana wáqe-uraiye. ");
INSERT INTO usa_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Îtuma tiráiye: “keráwáqá min-óqtámá paábaq matúwáaro.” titana Máátaa puki-nákóní ámánaakoma timá ámikaiye: “uyátáraana-nako, wemá pukitana kaayaqté-kaayaqte-yupaama kóuraiye. miráipoana íbêqa táí-akuqa kéiye.” téna Máátaa tiráiye. ");
INSERT INTO usa_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","ááqibo Îtuma timá ámikaiye: “emá arummá timéma Áánûqtuni tágama-yataaqa aónanone íyaq timá ámikauno?” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","maamin-óqtámá aukáqtúwááwana Îtuma yanaa múte káonena tiráiye: “ketiboó, ketáama itáánayaba timuqá kémarakaune. ");
INSERT INTO usa_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","áraine. kemá aónaraune. aati-aatié emá ketáama kéitaane. ááqibo máqtemma aarawaamá maakáqá itó-uraapoata itaígáae téq kétune. yeráwáqá emá timátíkaraane téta mikáq emmá yirummá amínoe téq kétune.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","mirá-timatuwenama wemá anón-aiq timá ááyaraiye: “Aráátaratio! yaúbatuwe kumuwo!” téna Îtuma ááyaraiye. ");
INSERT INTO usa_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","pukái-nakoma yaúbatuwena kukáiye. wenayáámma mórabi maqmá atáá-umakareta ánná-tabaraabenapo wenaítaukaq atáá-uma mórabi maqmá móraiq umá wenaqnókáqá keqnáámmá óq-tabaraabenapo útûyakaraae. Îtuma timá yímikaiye: “wemmá uwáqtuweraq ayuwáíyana kóíno.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","minnáyaba taíganimma Ítíráaeo-wayukama Máríaamma aónaineta ye-káyúkámá Îtuma nôrabi i-qtátááqá káoneta yirummá ámikaae. ");
INSERT INTO usa_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","yaímma-wayukama uyaatéta Pérati-wayukaraq uréta Îtuma nói-qtataarirabi immá mó-tima-yimikaae. ");
INSERT INTO usa_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","aanibo Pérati-wayukagaraq anó-monoq-kawaa-wayukagaraq káánítóre-wayukama ya áíkuteta káánítóre áwîqa Táánítarani maará téta tirááe: “ketáámá náaraq ónúnataabiyo? wé maamin-nákómá netuqyaa anón-awaameq-yataariqa kéiye. ");
INSERT INTO usa_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","ááqibo ketáá ayúwáananataa miráuqtenamo uínatama máqte-kayukama wekáq yirummá kámiyatama Árómani-wayukama ketááí anó-monoq-namma ketááí waayúkagaraq yama mayáinoe.” téta tirááe. ");
INSERT INTO usa_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","yepíké móra-nakon-awiqa Kááyapati wemá maa-kárítímáátíráqá mú mikákáá anó-monoq-nakoma máena wé timá yímikaiye: “keráwáqá íma maami-qtátááqá aónaraae! ");
INSERT INTO usa_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","maamináyaba keráwáqá íyaq túyánámmá kéitaao? maannâ móra-naqo puyéna máqtemma aarawaamá yíwáqnaa ínímma minnâ kanaaráqíye. móra-naqa puínatama máqte-kayukama íauyoranoe.” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","áraimma wenááq-maqma ítiraiye. ímiye. wemá mú mikákáá anó-monoq-naqa maa-kárítímáátíráqá máqe-uraiye. miráínana Îtuma puyéna Ítíráaeo-wayukama yíwáqnaa íniye téna amunémá kégutena tiráiye. ");
INSERT INTO usa_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","ááqibo íma paá ketááí wayúkayataba yíwáqnaa ínéna pukáiye. ímiye. Áánûqtuni-iyapo-annama máqte-naukapaqo máa-kayukama mamá mórabi áíkuyikanena puíniye. ");
INSERT INTO usa_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","aanibo miráitata mi táoqa Îtumma ikamínéta waayaímmá timáeta uréire urááe. ");
INSERT INTO usa_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","miráitana Îtuma móragaraqa íma Ítíráaeo-aukaapimma uréire uráiye. wemá mi-márúqá yuwéna kaqmáápaqa uréire uráiye. kaqmáápaq waaqókáq móra-marukon-awiqa Íparama mibáqá wení iyápó-annate máqe-uraiye. ");
INSERT INTO usa_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","íbêqa Ítíráaeo-wayukati kótamaki-kanaama awaaraq kéitataboata áwábake taígani-kayuka maréta Yérútáárebaq múma yirummá maqmá tágaiyaqtaba utááe. ");
INSERT INTO usa_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","yeráwáqá Îtuqtaba arútama aónaqteta kéuyoata anó-monoq-namatupaqa máe-kayukama aamá timá wenamí-kenamin urááe: “é náaran-auyananaq kéitaano? kaawéqá naíbáq íyaq yíniyo?” téta wemmá kétaimma wemmá kétaimma urááe. ");
INSERT INTO usa_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","missing? ");
INSERT INTO usa_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","abapaké móra-kanaama awaaraq kéitana kótámaki-kanaama pááq inéna uráiye. Îtuma Béqtanibaq uráiye. mi-márúkáq Aráátaratima pukáipike mamá itó-umakaraiye. ");
INSERT INTO usa_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","mikáq yeráwáqá kaawéqá amínéta urááe. Máátaa aáwaqa kéikamitana Aráátarati yaareráqá Îtugaraq máqe-uraiye. ");
INSERT INTO usa_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Máríaa anón-oqtanawiqa yaan-ákúq-mátáwémá maténa Îtun-aitaukaqa atímma pérakarena Îtun-aituqa wenaqnótáurake ayúnakaraiye. miráitana átê-kuyukoma mi-náúpáqá ôriq uráiye. ");
INSERT INTO usa_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","wení iyápó-annabike móra-naqa Yúqtaati Itikáárioti wemá Îtumma mamá namuro-wáyúkátí iyáápimma anaaékaq maránéna wé Yúqtaati tiráiye: ");
INSERT INTO usa_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“nôraq itataawáq maamin-ákúq-mátáwémá íma kéyimetaa meyámmá matáunataabiyo? mipímmá kaumo-tíyááká-tíyááká-óqtámmá (300) wáiye. ááqibo meyámmá matáunarakaatati mi-méyámmá áwáyoq-wayukataa kanaaráq yiménaqtaa únnae.” Yúqtaati téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","áwáyoq-wayukama yimíyátábá ítiraibo paá moyánápóana wemá moyámmá mamá wenamáárîq moyámmá mayáinayaba tiráiye. wemá mónekaq yabíkéna wenamáárîq máyáinapoana wemá tiráiye. ");
INSERT INTO usa_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","miráitana Îtuma tiráiye: “wemmá min-íníkómmá ayuwáaro. minnâ maqtokéna kemmá uqta mátikaino-kanaaraqtaba kémaqtoraiye. ");
INSERT INTO usa_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","áwáyoq-wayukama keráwáqtê aati-aatimá mánobo kemá keráwáqtê aati-aatimá íma mánune. ");
INSERT INTO usa_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","taíbaq Ítíráaeo-wayukama Îtuma Béqtani-marupaqo máin-aimma itátuweta yeráwáqá mibáq urááe. yeráwáqá uráámanibo Îtuqtabae téta íuraabo Aráátaratimma aónainetaae. Îtumo náawanabi pukáipike mamá itó-umakaimma aónaineta urááe. ");
INSERT INTO usa_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","miráitata anó-monoq-kawaa-wayukama ");
INSERT INTO usa_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Aráátaratiqtabae téta taíbaq Ítíráaeo-wayukama anó-monoq-wayukama iyuwéta yirummá Îtumma ámikaae. ");
INSERT INTO usa_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","óq-taoqa netuqyaa aarawaamá kótámaki-kanaaraq ayú maqnáíyama aónaneta ya máeta ítaraae. miráuma Îtuma Yérútáárebaq ínéna kéiye-aimma ítátuweta ");
INSERT INTO usa_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","yeráwáqá kóbékáátágóní amamá akáteta utín-utin umá aapaké awiránéta urááe. wááqa yumáe kéweta tirááe: “atóbatikai-nako, ótáánao, yéna-nakoqtabama anómma uyátárai-nakon-awikaq kéyenana Áánûqtu amuqá kémarakaiye. Ítíráaeo-wayukati mú mikáq anómma yabíqyikai-naqa (kíni) Áánûqtu weqtábá amuqá kémarakaiye.” téta tirááe. ");
INSERT INTO usa_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Îtuma móra naatéq-ótíráákákóní ámûraaq máena kéiye. Áánûqtun-aama agamatá-kátáágó tiráiniq umá kéiye. mirá kétiye: ");
INSERT INTO usa_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Tááíoni-maruko, áaqa ígáíno! aónaaro. keráwáqtí mú mikáq anómma yabíyikai-naqa kéiye. naatéq-ótíráákákóní ámûraaq máena kéiye.” Áánûqtuni agamatá-kátáágó téna kétiye. ");
INSERT INTO usa_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","maamin-áímmá Áánûqtuni agamatá-kánnáágó tiráimma áqnáabaq Îtuni iyápó-annama íma ítaraae. aanibo anaaékaqa Îtumma pukáipike Áánûqtuma tágama-yataapi mamá atóbamakaitata mikáq yeráwáqá yúyánákáq maréta tirááe. Áánûqtuni agamatá-kánnáágó tiráimma yaákaq urááe. ");
INSERT INTO usa_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","taíbaq Îtute máqeo-kayukama Îtuma Aráátaratimma ááyaitana utátuwena úin-aimma timá abarokáq kéiteta nôrabi i-náíkáráq tirááe. ");
INSERT INTO usa_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","taíbaq óq-wayukama maami anón-awaameqa in-áímmá ítaraapoata yeráwáqá aapaq yaónaineta irááe. ");
INSERT INTO usa_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","minnáyaba Pérati-wayukama yeíyáá téite urááe: “káonaao? ketáataa íma itánoe. aónaaro! máqtemma maa-márábí-káyúkámá wenanaaé kéwaraae.” téta Pérati-wayukama tirááe. ");
INSERT INTO usa_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","yaímma Karíki-wayukama maréta Yérútáárebaqa aapinaammá tíyaqtaba ayú maqnaapí utááe. ");
INSERT INTO usa_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","yeráwáqá Píripikaq urááe. wemá Beqtáirapake Kááriri-marupaq iráiye. wemmá yeráwáqá ítama aónanaqtaa: “anóko, ketáámá Îtumma aónaqtaa kéyunataae.” téta tirááe. ");
INSERT INTO usa_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","miráitana Píripi maréna Áánarukaq kéwena timá ámitata keqnáámmá mákanakama marétarata Îtukaq kéwetarata mó-tima-amikaaye. ");
INSERT INTO usa_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Îtuma yauwéqma tiráiye: “mi-kánáámá íbêqa kéyitata kemá Waayúkagon-Araakoma anómma tágama-yataaqa káme. ");
INSERT INTO usa_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","kemá áraimma kétima-timune. mórama wíti-yumma marabí íkumena ípuinama kímora pááqyan-ayumma wenamáa wániye. minnâ wemá puínamanibo taíganimma uta-uta umá ôriq umá arammá iyániye. ");
INSERT INTO usa_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","móra-nakoma wení aúwaraiqtaba ôriq umá akáinanama wemá wení aúwaraikoma páátataakaa íniye. móra-nakoma wení aúwaraiqtaba maa-márábí mái-yataaqtaba íakainanama anaaékaq matúq-matuq umá aati-aatimá mái-auwaraimma maqtorániye. ");
INSERT INTO usa_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","náawa-naawabi kekáqô mayaímô mayanénama ketinaaé waraíno! kemá máuna-marukaqa ketí mayaímá matikáí-náqá mániye. ketí mayaímá matikáína-nakoma ketibomá wenáwîqa múte yauwíniye.” téna tiráiye. Îtuma óq-aimma tiráiye: ");
INSERT INTO usa_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“íbêqa tíyakoma ummaa kéyaiye. ááqibo nóineq tenúno? ‘ketiboó, ketí ánatagina-kanaama íma yúwénana kumíno tenúno?’ ímiye. minnáyaba paá kukáune. ");
INSERT INTO usa_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","ketiboó, tágama-yataaqa enáwîkaq akoqnáá umá mamá maa-márábí-káyúkámá yiráátinonama enáwîqa anómma uyátá-maqma mimórá mái-waigonamiye.” téna Îtuma mirá-timatuwaitana aagómá wíyôpake kukéna tiráiye: “kemá tágama-yataaga ketíwîkaq mamá múte yaútaunnama móragaraq múte yauyónúne.” téna maamin-áíkómá tiráiye. ");
INSERT INTO usa_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","waayúkama máqeo-kayukama min-áímmá ítátuweta tirááe: “wíyonaa kétiye.” téta kétewata yaímma-wayukama tirááe: “Áánûqtunopakekako kétiye.” téta mi-káyúká tirááe. ");
INSERT INTO usa_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Îtuma yauwéqma tiráiye: “aagómá wíyôpake keqtábá ítiraibo keráwáqtábá itaígáae téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","íbêqa máqtemma maa-márábí-káyúkámá Áánûqtu kéyainaiye. maa-márá áaikoni anó-naqa Tááqtaama íbêqa ikámma waqtuwániye. ");
INSERT INTO usa_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","aanibo kemá maa-márábíkémô múte itó éqa máqtemma yiwíqma ketôpaqtaa ónúne.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","wemá min-áímmô tiráimma minnâ náaraq umá puíníyo minnáyataba yiráá téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","ááqibo aarawaamá yauwéqma tirááe: “miráuma aammá aúmakaan-aipitaa ítaraunataa miráuma Metáíya paá matúq-matuq umá mániye. nôraq itaawáq Waayúkagon-Araakokaq múte yauwínoe kéteno? náawawaq Waayúkagon-Araakoma máiyo?” téta ítama aónaraae. ");
INSERT INTO usa_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","mirá téna Îtuma timá yímikaiye: “pááqya-kanaabi ómmá keráwáqtê mániye. keráwáqá ómmá wáinagaraq ókáqá íma máíyanama keráwáqá kumayukómá yawááq-umatikaniye. móra-nakoma kumayuqnóbáqá uréire ínna-nakoma ‘náakaraq kéi náakaraq kéwiyo’ téna wemá kanaaráq íkáonaiye. ");
INSERT INTO usa_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","ómmá wáinaq ókómmá tirummá áméro! miráinaq keráwáqá ókón áráaqa mánoe.” téna Îtuma tiráiye. Îtuma min-áímmá timátuwenama yemmá iyuwéna aúpáq kóuraiye. ");
INSERT INTO usa_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Îtuma netuqyaa anón-awaameqa yetúrakaqa imánibo yeráwáqá paá íma Îtumma yirummá ámikaae. ");
INSERT INTO usa_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","netuqyaa-káyúkámá Îtumma yirummá íámikaapoata Áítáíya Áánûqtuni amuné-náqá wenáama áraine téna kéyiraatiye. Áítáíya naayóbáqá tiráine: “uyátáraana-nako, náawaq ketáái táaraqa ítáraiyo? náawakaraq uyátárai-nakoma wení akoqnááma aráátitanawaq kanaaráq aónaraiyo?” téna Áítáíya tiráiye. ");
INSERT INTO usa_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","maami-qtátáátábábóata yeráwáqá kanaaráq yirummá íma káme miráipoana Áítáíya tiráine: ");
INSERT INTO usa_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Áánûqtu yeráwáqtí yúramma mamá karopamáyikena yúyánámmá mamá óqtakaa umátukaiye. miráitata yé íma yúramma káoneta yúyánámmá íma kéitaae. yeqtí yúrakakema íkáonaapoata yúyánámmá íma ítama káruteta kéopoata íma ketôpaqa waéqma íyaqa yemmá mamá atóbamayikanune.” téna Áítáíya naayóbáqá tiráine. ");
INSERT INTO usa_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Áítáíya uyátáraana-nakoni tágama-yataaqa aónaraipoana weqtábá wenáaimma tiráiye. ");
INSERT INTO usa_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","ááqibo netuqyaa-káyúkámá yaímma Táánítarani-kaanitori-wayukagaraq wemmá yirummá ámikaamanibo Pérati-wayukati yáaqa kéikatetaboata yeráwáqá yirummá áme-kayukama íma abarokáq umá tirááe. abarokáqô tíyatama monoq-náúpáké paábaq waqtuwánoe. ");
INSERT INTO usa_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","yenamáárîq yeráwáqtábá yetíwîqa múte yauwígáae kétetamanibo Áánûqtuni tágama-yataaqtabama abarokáq umá íketee. ");
INSERT INTO usa_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","ááqibo Îtuma yááyama tiráiye: “náawabi arummá kétimenama kenamáa kekáqá íma arummá kétimibo ketibomá timátíkái-nakokaraq arummá kámiye. ");
INSERT INTO usa_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","náawabi kemmá kétimonenama wemmá ketibomá timátíkái-naqa káonaiye. ");
INSERT INTO usa_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","kemá maa-márábí-ómmá kukáune. miráipoana náawabi kekáqá arummá timénama wemá íma kumayupímmá mániye. ");
INSERT INTO usa_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","móra-nakoma ketáama kéitena ketáama íkémayainama kemá kenamáárîq wemmá íma yawááq-umakanune. aanibo maa-márábí yawááq-umayikanaaq íkukaune. ímiye. kemá aarawaamá yááyabo umáyikanaaq kukáune. ");
INSERT INTO usa_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","náawabi kemmá anaaéma umátikenama ketáama ímayenama íbêqa yainaí-yátááqá wemmá kéyainaiye. minnámo ánatai-yupaama máqtemma túnna-aikoma wemmá mamá yawááq-umatikanoe. ");
INSERT INTO usa_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","kemá ke-túyánápíkén-áímmá íkétune. ímiye. ketibomá timátíkái-nakoma wenamáárîq timá tímin-aimma kétunaboaqa máqten-aimma kétima-timune. ");
INSERT INTO usa_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","ááqibo kemá ítaraune. ketiboní watáama aati-aatimá matúq-matuq umá mái-auwaraimma mamá paá kéiye. miráitaqa máqten-aimma túnnama minnâ ketibó timá tímin-aimma kétune.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","kótámaki-kanaama waagókárîq kéitana Îtuma maa-márábíké yuwéna aboánôpaqa uínî-kanaama yimmá ítaraiye. maa-márábí máena wení aanábó-wáyúkáyábá ôriq umá kákaitana yeqtábá yikáíq-yikaiq umáe kéuyena wení puíni-kanaaraq uráiye. ");
INSERT INTO usa_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Tááqtaama Yúqtaatin aúyánámmá waéqma Îtuni kutarurîq webó-náqá aúrákaraiye. ááqibo aáwaqa kénaawana ");
INSERT INTO usa_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Îtuma ítaraiye máqte-qtataaqa Áánûqtuma wenayáápi ámikaitanaboana wemá Áánûqtunopake kukáunaboaq yauweré uyónúne téna aúyánámmá ítaraiye. ");
INSERT INTO usa_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","aanibo Îtuma aáwaqa naí-yááréráq máqeikake itó-urena wení ámûraake aqtoraí-wáqtómá ayúqma mikáq kéyuwena óíqa ayumí-wánáámá (táúrima) maténa ámûrana uráiye. ");
INSERT INTO usa_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","káqomma wemá nommá táápepi atímakena wení iyápó-annati yítauqa tete umáyíkarena ayumí-wánáánápó yítauqa ayúnikanena uráiye. ");
INSERT INTO usa_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","áqnáabaqa Tááímoni Pítaakaq yitana Pítaa tiráiye: “uyátáraana-nako, ketítauraq tete umátikane kéono?” téna Pítaa ítama aónaitana ");
INSERT INTO usa_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Îtuma yauwéqma tiráiye: “íbêqa emá íaonaraanaiq ónáa kéune. ááqibo anaaékaqa emá aónanone.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Pítaa akoqnáá-aimma abarokáq tiráiye: “emá íma ketítauqa tete ínóne.” téna titana Îtuma yauwéqma tiráiye: “ááqibo kemô enaítuqa ímo tete onaamá emá íma ókaraq ketí iyápó-annama mánone.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Pítaa timá ámikaiye: “uyátáraana-nako, ketítauqa wenamáa ítete é mútûq tiyáánaa tiqnókáráq tete umátikaao!” téna Pítaa timá ámikaiye. ");
INSERT INTO usa_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Îtuma mikáq tiráiye: “móra-nakoma máqten-aubakaraqo nommá pétukenama íma óqa peránibo paá wenaítauqa tete íno. mútûq keráwáqtí túgogaraq tirunóbáqá íráqôniq uráibo kímora-nakone.” téna Îtuma timá yímikaiye. ");
INSERT INTO usa_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","móra-naqa waéqma kutarurîq webómá aukái-naqa Îtuma aónatukaipoana tiráiye: “kímora-nakone.” ");
INSERT INTO usa_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Îtuma wení iyápó-annati yítauqa tete umáyíkátuwena wení ámûraaq aqtoraí-wáqtómá mamá aqména yauwéqma yaareráq umáena tiráiye: “kemô umátíkauna-yataaqtaba ítama kárutao? ");
INSERT INTO usa_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","keráwáqá keqtábá yirááti-nare kéte ‘uyátáraana-nako’ kéte kéoma minnâ áraine. miráipoana minnâ kemúne. ");
INSERT INTO usa_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","ááqibo kemá keráwáqtí títauqo tete umátikaunama kemá yirááti-naqa uyátárauna-nakoma tete kéumatikaune. móraiq umá keráwápíké káqowa-kaqowan-aituqa tete ínôqtaba ketiyáánaubiqa aóna-mayaaro. wenáítauq-wenaitauqa tete íné oné. ");
INSERT INTO usa_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","íbêqa keráwáqá umá tiráá túnnaiq kemá nôrabi umátikaunayaba mimóráíq umá keráwáqá íné oné. ");
INSERT INTO usa_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","éqtukena timámeno áraine. móra mayaímá máyái-nakoma aati-aatimá wení mayaímá mayákái-nakomma íma uyátá-maqma anómma kémaiye. móra-nakoma watáama mamé i-nákómá timákáitana yi-nákómmá íma uyátá-maqma anómma kémaiye. ");
INSERT INTO usa_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","keráwáqá ítama arútama miráeq oweqa mikáq timuqá maránoe. ");
INSERT INTO usa_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","kemá nóinabi íma máqtemma keráwáqtábá ketí iyápó-annama máqtemma ye táaimma káoneq yiwíkaunama taíbaq-wayukabike yíwíkeq Áánûqtuni agamatá-kátáámá áraine téq kéyiraatune. min-ágámátá-kátáágó kétiye. ‘móra-nakoma ketí aáwaqa ketê nai-nákómá wenáítagegunapo múte yaáqma tímûraaq yániye.’” téna Áánûqtuni watáa agamatán-áíkómá mirá kétiye. Îtuma óq-aimma tiráiye: ");
INSERT INTO usa_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","“mi-qtátááqá pááq iné kéitaq íbêqa aamá kétima-timune. mi-qtátááqá pááq ínaqa keráwáqá mikáq tirummá amínomma minnâ náawabi MÁUNE. ");
INSERT INTO usa_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","akoqnáá umá kétima-timune. kemá timákauna-naqa náawabi awirénama kekáráq kétiwiraiye. náawabi kemmá tiwirénama timátíkarai-nakokaraq káwiraiye.” téna ");
INSERT INTO usa_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","min-áímmá Îtuma timátuwena amakó ôriq umá ummaa yágitana wé tiráiye: “áraimma kétima-timune. keráwápíké móra-nakoma kemmá mamá namuro-wáyúkábí tikániye.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","wení iyápó-annama wenaúrapi-kenaurapi káoneta yúyánápí náawaqtaba kétiyo téta íaonaraae. ");
INSERT INTO usa_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","iyápó-annabike móra-naqtaba Îtuma ôriq umá ákái-naqa Îtun-amakaq yaareráqá máena aíqtaaraqa agebamá máqe-uraiye. ");
INSERT INTO usa_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","miráitana Tááímoni Pítaa aqnótáq yumátuwena ‘náawaqtaba kétiyaa wekáq itaao’ téna awaaméqá umá timá ámikaiye. ");
INSERT INTO usa_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Îtun-aiqtaabi agebaréna tiráiye: “uyátáraana-nako, náawaqtaba kéteno?” téna ítama aónaitana ");
INSERT INTO usa_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Îtuma yauwéqma tiráiye: “kemá yammá aáwaq-anopi yamá atîmma áménama minnáqíye.” téna Îtuma timátuwena yammá aáwaq-anopi yamá atíkena Yúqtaati Tááímoni Itikááriotini áanikoma ámikaiye. ");
INSERT INTO usa_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","mikáq Yúqtaati min-ááwáqá mamáyáitana Tááqtaama wepí yabékitana Îtuma timá ámikaiye: “nôrabi ínéma páátákáá mirá-uwo!” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","máqtemma yaareráqá máe-kayukabike móra-nakoma Yúqtaatima nóin-ainabi timá ámin-aimma íma ítama arútaraiye. ");
INSERT INTO usa_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Yúqtaati móne-ketima matóráiqtaba kétiyaa téta yaímma-wayukama tirááe: “kótámaki-kanaaraq-yataaraq meyánîq uwo kéti kéqokeq-yataaraq áwáyoq-wayukama yimiyówaq” kétiyaa téta tirááe. ");
INSERT INTO usa_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Yúqtaati min-aáwáqá kémayenama máápaqa kumayupí yáubaguraiye. ");
INSERT INTO usa_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Yúqtaati ayuwéna kóitana Îtuma tiráiye: “íbêqa Waayúkagon-Araakoni tágama-yataaqa mamá abarokáq kéumakena Áánûqtuni tágama-yataaqa Waayúkagon-Araakokaq kéumakaiye. ");
INSERT INTO usa_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Waayúkagon-Araakoma Áánûqtuni tágama-yataaqa abarokáq mamé ínana wení tágama-yataaqa Áánûqtu waéqma wenamáárîq wepí páátákáá abarokáq mamé íniye. ");
INSERT INTO usa_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","ketí pááqyan-iyaqo! kemá keráwáqtê pááqya-kanaama mánune. keráwáqá tibáá-inoe. ááqibo keqnáámmá Ítíráaeo-wayukamma timá yímikaunaiq umá kemá kétima-timune. keráwáqá kenamáárîq kemá kóúnabaqa íma kanaaráq uínoe. ");
INSERT INTO usa_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","íbêq-kanaayaba kemá aúgen-amaan-aimma kétimune. kemá keráwáqtábá tíkáiniq umá keráwáqá móraiq umá weqtábá kákaina weqtábá kákaina umá máero. miráuma keráwákáráq káqowaqtaba kákaina káqowaqtaba kákaina tíkáiniq únnaiq umá máero. ");
INSERT INTO usa_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","akaí-yátááqá keíyáátaa wenámí-kenamin umá maíyata ketí iyápó-annae téta máqte-kayukama aónainoe.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Tááímoni Pítaa tiráiye: “uyátáraana-nako, náakaraq kéono?” téna wé timátuwaitana Îtuma yauwéqma tiráiye: “kemá koúna-marupaqa íbêqa emá íma kanaaráq tinaaéma waráínóne. ááqibo anaaékaq ketinaaéma waráínóne.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Pítaa timá ámikaiye: “uyátáraana-nako, nôraq ínaraq enanaaéma íbêqa kanaaráq íwaranuno? kemá eqtábáé téq áqa puyónúne.” téna Pítaa titana ");
INSERT INTO usa_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Îtuma yauwéqma tiráiye: “emá keqtábáé téaq áqa puíné kéono? kemá akoqnáá umá kétima-amune. kokóregoma áa tiné kéinaa emá keqtábá kaumobáqá ‘wemmá íaonaraune’ té wakaránóne.” téna Îtuma Pítaamma timá ámikaiye. ");
INSERT INTO usa_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Îtuma wení iyápó-annama timá yímikaiye: “íma yuwáiyana tíyako ummaa yaíno. miráinaq Áánûqtukaq tirummá kámeraq ááqibo kekákáráq tirummá tíméro. ");
INSERT INTO usa_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","ketiboní naaúpaqa taígani-maqa wáiye. ímo wárainaqa kemá keráwáqtábá wágáábaq timátikanaa únnae. kemá kóureqa keráwáqtí márûqa ko tarôq umá óqtaa umátikanune. ");
INSERT INTO usa_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","kemó kówéqa keráwáqtí márûqa ko tarôq umá óqtaa umátíkátuweq kemá yauwéqma iréq kenamáárîq yatiwiranúne. kemá máuna-marupaqa keráwákáráq mánoe. ");
INSERT INTO usa_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","kemá ónááqo únna-maruqtaba aammá keráwáqá kéitaae.” téna Îtuma wení iyápó-annama timá yímikaiye. ");
INSERT INTO usa_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tómááti timá ámikaiye: “uyátáraana-nako, náakaraq kóinono minnâ ketáá íaonaraunatae? náaraq umátaawaq maamin-ámmá kanaaráq aónanunataabiyo?” téna Tómááti timá ámikaiye. ");
INSERT INTO usa_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Îtuma yauwéqma tiráiye: “kemá kenamáárîq ketibonôpaq wíámúne. kemá áraimma tí-ááímúne. kemá aati-aatimá paá matúq-matuq umá mái-aaimune. móra-nakoma ketibonôpaqa kéyena káqon-amma íma mamá awi íniye. ímiye. kemá kenamáamune. ");
INSERT INTO usa_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","kemmô kétimoneqa ketibokáráqá káonaae. íbêqake wemmá aónatukeqa wemmá keqtúrapike aónaraae.” téna Îtuma yauwéqma tiráiye. ");
INSERT INTO usa_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Píripi timá ámikaiye: “uyátáraana-nako, emá enaboqtáá tiráátinana keqtáá kanaaráq íno.” téna Píripi timá ámikaiye. ");
INSERT INTO usa_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Îtuma yauwéqma tiráiye: “Píripao, kemá ayáqtáá-kanaama keráwáqtê máqe-uraune. emá íyaq kemmá timónaraano? náawabi kétimonenama ketibokáráqá káonaiye. nôraq itaawáq ‘enaboqtáá tiráátiyo’ kéteno? ");
INSERT INTO usa_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","kemá ketibopí máunana wemá ketibomá kepí máiye. minnáyaba íyaq kekáqá arummá kétimeno? aamô timá-timunama íma ketááq-maqma kétune. ketibomá kepí máena wení mayaímá kémayaiye. ");
INSERT INTO usa_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","keráwáqá maan-áíkáqá tirummá áméro. kemá ketibopí máunana ketibomá kepí máiye. ááqibo ímo miráinaqa kemá máqtemma anón-awaameq-yataariq únnama aónaraabo minnáyaba kekáq tirummá tíméro. ");
INSERT INTO usa_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","kemá áraimma kétima-timune. móra-nakoma arummá timénama móraiq umá anón-awaameq-yataariq íniye. kemá ketibonôpaq uyátá-maqma anón-awaameq-yataariq íniye. ");
INSERT INTO usa_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","aanibo máqte-qtataaqtabama ketíwîkaqa nunamupí itáíyaqa kemá paá mirá-onune. miráonana ketiboní tágama-yataakoma kemá áanikokaqa yíniye. ");
INSERT INTO usa_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","ááqibo ketíwîkaqa nunamupí móra-yataariq uwó tíyaqa kemá paá mirá-onune.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Îtuma óq-aimma tiráiye: “keráwáqô, keqtábá tikáinaqa ketí ámáan-aimma taákaq matokéra mirá-inoe. ");
INSERT INTO usa_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","ketibommá ítama aónaanana wemá káqomma tíwâqnaa í-náqá wení Aokaq-Áágómmá timákainana keráwáqtê ku matúq-matuq umá mániye. ");
INSERT INTO usa_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Aágoma wení árain-aikoni áaimma máiye. maa-márábí-káyúkámá wemmá íkaoneta íkéiteta kéopoata wemmá íma kanaaráq awiránóe. wemá keráwáqtê máipoana keráwápí mániye. ááqibo keráwáqá kenamáárîq wemmá káonaae. ");
INSERT INTO usa_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","miráinaq kemá ítiyuwaanaq keráwáqá kenamáa anóbo íma máin-iyapogoraan umá íma mánobo kemá yauwéqma keráwáqtôpaq yenúne. ");
INSERT INTO usa_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","pááqya-kanaabi maa-márábí-káyúkámá kemmá móragaraq ítimonainobo kemmá matúq-matuq umá mái-auwaraimma matokáunaboaq keráwákáráq miráuma mayáinopoaq miráinaqa kemmá timónanoe. ");
INSERT INTO usa_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","mi-kánáámô yínaqa keráwáqá itánoe. minnâ kemá ketibopí máunaq aanibo keráwáqá kepí máápoaq kemá keráwápí máune. ");
INSERT INTO usa_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","náawabi ketí aúgen-amaan-aimma aákaq matokéna mirá énama wemá keqtábá ôriq umá kákaiye. keqtábámô ôriq umá akáina-nakoma ketibomá weqtábá ôriq umá akániye. kegáráq ketí tikaí-yátááqá aménúnaboaq kemá kenamáárîq ketáaimma aráátenune.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Îtuma óq-Yuqtaatimma timá ámikaiye íma Yúqtaati Itikááriotimibo: “uyátáraana-nako, náaraq umáwaq enáaimma keqtáá kétiraatetaa maa-márábí-káyúkámá íma yiráátenune kéteno?” téna Yúqtaati tiráiye. ");
INSERT INTO usa_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Îtuma yauwéqma tiráiye: “náawabi keqtábá akáinanama kemá túnna-aimma aákaq matokéna mirá-iniye. ketibomá weqtábá akaínakama ketibotê kegáráq wenôpaq iréka wetê kerátá ya matúq-matuq umá máyuye. ");
INSERT INTO usa_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","náawabi íma keqtábá akáinanama kemá túnna-aimma íma aákaq matokéna miráinipoaq wemmá ketáaimma íaraatenune. aamô kéitaamma íma kennáé. ááqibo min-áímmá ketibó timátíkarai-nakonopake kéiye.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","wení iyápó-anamma Îtuma timá yímikaiye: “keráwáqtê máeqa maami-qtátááqá timá tímikaune. ");
INSERT INTO usa_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Áánûqtuni Aokaq-Áámá tíwáqnaa í-náqá ketibomá ketíwîkaq timákainana kégumena wemá máqte-qtataaqa kétiraatena wemá tímikauna-aimma túyánákáq mamá marániye. ");
INSERT INTO usa_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","kaayoné-yátááqá keráwáqtê yuwáune. ketí kaayone-yátááqá keráwáqá kétimune. maa-márábí-káyúkámá mirá-kááyóné-yátááqá íyokaa-qtataaqa kétimune. íma yuwáiyana tíyako ummaa kéyainaraq íma ikatîqa oro! ");
INSERT INTO usa_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","keráwáqá ítaraawaq timá tímikaune. minnâ ‘kemá koúreqa yauwéqma keráwáqtôpaq yenúne.’ keqtábá tikáinaqa timuqá maránóe. kemá ketibonôpaqa kégounama ketibomá kemmá uyátá-maqma máiye. ");
INSERT INTO usa_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","íbêqa mi-qtátááqá íma pááq iné kéitaq paá aamá kétima-timune. mi-qtátááqá pááq ínaqa mikáq tirummá timínoe. ");
INSERT INTO usa_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","kemá íma keráwáqtê ayaqtáá-kanaama watáá-wataa tenúne. maa-márágón áai-nakoma (Tááqtaama) kéimanibo wení akoqnáá-yataaqa kemmá íma kanaaráq uyátá-maqma yokáiye. wení akoqnáárakemma kemmá ánná ítiminiye. ");
INSERT INTO usa_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","maa-márábí-káyúkámá timónainoe. minnâ ketiboqtábá ôriq umá kétikaitaq wemá máqten-aimma timá tímímma taákaq yokéq mirá kéune. itó-oro! maa-márúkáké yuwéqtaa kónatae.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Îtuma wenamáárîq ánnágon áaimma wení iyápó-annama timá yímikaiye: “kemá árain-annagon ábô máunana ketibomá yókón aboámíye. ");
INSERT INTO usa_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","amagómá arammá íma íyáitanama akáma kéiyaabotuwaiye. ááqibo arakaráq-ámámá ayááma tágatukena amumá yaákarena aráka-araka égé yuwáitana anaaékaq óq-aupaqa arammá iyánîqtaba mirá kéiye. ");
INSERT INTO usa_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","ketáa timá tímikaunaboaq íbêqa keráwáqá aúgen-augen urááe. ");
INSERT INTO usa_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","kemá keráwápímmô máunaiq umá keráwáqá kepímmá móraiq umá máero. amagómá ábôraqa íaraaparenama wemá arammá íma iyániye. miráínaqa keráwákáráq kekáq íma máeqa keráwáqá arammá íma iyánoe. ");
INSERT INTO usa_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","kemá ánnágon-abomune. keráwáqá ánnágon-amamoe. miráipoana náawabi kepí máinaqa kemá wepí máenana wemá arammá netuqyaa iyániye. ááqibo kekáké yuwéq ókaqo maéqa keráwáqá móra-yataariqa kanaaráq íma ínoe. ");
INSERT INTO usa_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","móra-nakoma kepí ímo maínanama wemá amamó ayááma iyaabótúwáanikaa umá yuwáiyana aayákaginata máqtemma aúqma irabí agatuwánoe. ");
INSERT INTO usa_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","keráwáqá kepí maíyanama ketáagoma keráwápí maínaqa keráwáqá kemmá kenamáárîq nunamupí máqte-qtataaqtaba itáiya-qtataakoma mamá pááq umátiminoe. ");
INSERT INTO usa_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","keráwáqá taíganin-aramma iyéqo ketí iyápó-annamo auráiyanama ketiboní tágama-yataakoma múte yauwíniye. ");
INSERT INTO usa_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","ketibomá keqtábá ôriq umá kákaitaqa móraiq umá kemmá keráwáqtábá ôriq umá kétikaiye. ketí tikaí-yátáákón aúkáapi máero. ");
INSERT INTO usa_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","kemá ketiboní ámáan-aimma taákaq matokéq miráuraunaboaq kemá wení akaí-yátáápí máune. móraiq umá keráwáqô ketí ámáan-aimma taákaq matokéq miráíyama ketí tikaí-yátáápí máinoe. ");
INSERT INTO usa_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","kemá timá tímikaune. minnâ ketí timuq-yatááqá keráwáqá mayánoe. ketí timuq-yatááqá keráwápí ógiqma mániye. ");
INSERT INTO usa_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","maaminnáma ketí ámáan-aimmibo. keqtábá tíkáiniq umá weqtábá kákaina weqtábá kákaina umá máero. ");
INSERT INTO usa_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","mú mikáq anómma akai-yátááqá íma wáiye. minnâ móra-nakoma ákáina-wayukayabae téna puíniye. káqo-nakoni akáí-yátáákómá íma uyátá-maqma wáiye. ");
INSERT INTO usa_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","kemá ámáan-aimma túnna-yataariq owéqa keráwáqá tíkái-kayukamoe. ");
INSERT INTO usa_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","mayaí-nákómá wemá mayaímô ámî-nakomma nôrabi i-qtátááqá íma kéitaiye. miráipoana kemá íma keráwáqtábá ókaraq ‘ketí mayai-wáyúkáé’ téqa tenúne. máqte-qtataaqa ketibonôpake itáuna-yataaqa keráwáqá timá tímikaunaboaq keráwáqtábá íbêqa ‘kemmá tíkái-kayukae’ kétune. ");
INSERT INTO usa_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","keráwáqá íma kemmá máqte-kayukabike tíkáimma íma tiwíkaabo kemá kenamáárîq keráwáqá máqte-kayukabike tíkáimma tiwíkaune. kemá mi-máyáíráq keráwáqá timátíkaraunaboaq keráwáqá koma matúq-matuq umá mái-aramma ko iyáíq-iyaiq umá máraiyana ketibomá keráwáqá nói-qtataaqtababi ketíwîkaq itaíyanama wemá timíniye. ");
INSERT INTO usa_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","keráwáqá maami-qtátáárîqa oro! weqtábá kákaina weqtábá kákaina umá máero.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","óq-aimma Îtuma wení iyápó-annama timá yímikaiye: “maa-márábi-káyúkámá keráwáqtábá ítikaiyaqa minnáma taákaq máráaro! áqnáabaq keqtábá íyikaitata anaaékaq keráwáqtábá íkéyikaiye. ");
INSERT INTO usa_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","keráwáqá maa-márágóní waayúkamo máraiyatama yemá keráwáqtábá yikániye. ááqibo kemá keráwáqá maa-márábíké tíkáimma tiwíkaunapoana íbêqa maa-márágóní waayúkama íma mááe. miráipoana yemá keráwáqá íyamma kéumatikaae. ");
INSERT INTO usa_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","timá-timuna-aimma taákaq máráaro! ‘móra mayaímá máyái-nakoma aati-aatimá wení mayaímá mayákái-nakomma íma uyátá-maqma anómma kémaiye.’ miráipoana yeráwáqô kemmá tíkamma kéwaretama keráwákáráq tíkamma waránóe. yemá ketáamo keíteta mirá étamo-etama yemá keráwáqtí táagaraq kéiteta mirá-inoe. ");
INSERT INTO usa_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","yemá timátíkáin-nakomma íaonaraapoata ketíwîqtabae téta maami-qtátáárîq umátikanoe. ");
INSERT INTO usa_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","kemá ímo iréqo aamá timá yímenatama yeqtí yigae-yátááqá íwane imánibo íbêqa yeqtí kúmiq-yataaqa íma kanaaráq aúpáq yuwánóe. ");
INSERT INTO usa_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","náawabi kemmá áyámma umátikaina-nakoma móraiq umá wemmá ketibokáráq áyámma kéumakaiye. ");
INSERT INTO usa_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","kemá anón-awaameqa káqo-kayukama ikéoniq umá kenamáa yiráátiraunaboata yeqtí yigae-yátááqá íma wániye. ááqibo íbêqa yeráwáqá aónaretamanibo kemmá ketibokáráq paá íyámma kéumatikaakarataae. ");
INSERT INTO usa_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","ááqibo yeráqwátí agamatá-kánnáábí áraimma yíniye. ‘yeráwáqá paáyaba kemmá íyámma umátíkaraae.’ ");
INSERT INTO usa_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","akoqnáá umá tíwáqnaa ínîn-naqa árain-aain-Aagoma ketibonôpake timákáanana kumínama ketí árain-aaimma má tínaq keráwáqá itánoe. ");
INSERT INTO usa_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","ketê keráwáqá áqnáabake mamé iráapoaq keráwákáráq keqtábá árain-aimma tínoe.” téna Îtuma wení iyápó-annama timá yímkaiye. ");
INSERT INTO usa_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Îtuma ókaraq íyamma umáyikanoqtaba téna tiráiye: “keráwáqá kemmá tirummô timí-yátááqá íyuwaigae téq maa-qtátááqtábá timá tímikaune. ");
INSERT INTO usa_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","keráwáqá monoq-náúpáké waqtuwánóe. áraine. mi-kánáámá yínanama keráwáqô tíkamiya-kayukama ‘Áánûqtuni mayaímá kémayaunatae’ téta tínoe. ");
INSERT INTO usa_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","ketibokáráq kekáráq ítimonaraapoata mi-qtátáárîq umátikanoe. ");
INSERT INTO usa_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","ááqibo timá tímikaune. mi-kánáámá yínaqa timá tímitukaiqtaae téq mikáq túyánámmá ítama taákaq ínoe.” téna Îtuma tiráiye. óq-aimma Îtuma tiráiye: “áqnáabaqa keráwáqtê máqe-uraunaboaq keráwáqá maami-qtátááqá íma timá tímikaune. ");
INSERT INTO usa_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","ááqibo íbêqa timátikáitaq kukáuna-nakonopaqa koúne. miráitana keráwápíké móra-nakoma ‘náakaraq kégono’ téna íma ítama kétimonaiye. ");
INSERT INTO usa_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","kemá maamin-áímmá kétunana keráwáqtí tíyakoma ummaa kéyaiye. ");
INSERT INTO usa_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","paá árain-aimma kétima-timune. kemá kónanama íráqôniq umátikaniye. íma kónanama keráwáqtôpaqa Tíwáqnaa Í-náqá íyiniye. ááqibo kemá kowéqa Tíwáqnaa Í-náqá timákáánana keráwáqtôpaqa kumíniye. kumínama ");
INSERT INTO usa_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","waayúkagoni kúmiq-yataaqtaba wemá yainániye. kateko-yátáákón áaimma má téna yainaí-yátáákón áaimma má téna íniye. ");
INSERT INTO usa_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Tíwáqnaa Í-náqá yénama miráuma kaumo-yátááqtábá tíniye. minnâ áqnáabaq yeráwáqá íma kemmá yirummá kétimepoata maami-kúmíq-yátáákóní táígon-aaiqtabama wemá yiráátiniye. ");
INSERT INTO usa_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","ketibonôpaqa koúnaboaq ókaraq ítimonanopoana kateko-ááíqtábá wemá tiráátiniye. ");
INSERT INTO usa_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","maa-márágón áai-nakoma (Tááqtaama) yawááq-umatukaipoana yainaí-yátáákón áaiqtaba Tíwáqnaa Í-náqá tiráátiniye. ");
INSERT INTO usa_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","kemá taígani-qtataaqtaba timá timenaa únnamanibo íbêqa maamin-áíkó keráwáqá mamá ummaa yamátikaniye. ");
INSERT INTO usa_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","wemá yénama Árain-aain-Aagoma máipoana wemá máqtemma árain-aain-aimma má téna taákaq mamá tikániye. wenamáárîq wenááq-maqma ítinibo paá ítáin-aimma tínana anaaékaq pááq ínî-qtataaqtaba timá-timiniye. ");
INSERT INTO usa_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","nóin-ainabi ketôpakemmo kéitenama timá-timinipoana ketí tágama-yataaqa wemá múte yauwíniye. ");
INSERT INTO usa_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","máqtemma ketibomá matokái-qtataaqa minnâ kennámiye. miráipoaq kemá timá tímikaune. ‘nóin-ainabi keráwáqá timá-timinama ketôpake kémayaiye.’” mirá téna Îtuma tiráiye. iyápó-annama yiru-qtatáákómá anaaékaq waéqma yimuq-yatááqá aurániye. ");
INSERT INTO usa_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Îtuma wení iyápó-annama timá yímikaiye: “pááqya-kanaabimma keráwáqá kemmá ítimonainoe. ááqibo pááqya-kanaabimma móragaraq kemmá timónainoe.” téna Îtuma wení iyápó-annama timá yímikaiye. ");
INSERT INTO usa_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","maannáyaba yaímma wení iyápó-annama ye íyáá tirááe: “wenáaimma nóiqtaba kétiyo? wemá kétima-timiqtaae. ‘pááqya-kanaabimma kemmá ítimonainoe.’ ááqibo ‘pááqya-kanaabimma móragaraq kemmá timónainoe.’ wemá ókaraq tiráiye. ‘ketibonôpaq koúnaboaq kétiye.’” téta ");
INSERT INTO usa_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","wení iyápó-annama tirááe: “nôraq téna ‘pááqya-kanaabine’ kétiyo?” téta yeráwáqá kaumo kááyaq-yuyanamma ítaraae. wení iyápó-annama ókaraq tirááe: “nóin-aaiqtaba kétiyo? ketáá íma ítama kárutaunatae.” téta tirááe. ");
INSERT INTO usa_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Îtuma aónaraimma yeráwáqá wemmá ítama aónaineta kéowana timá yímikaiye: “keráwáqá kaumo kááyaq-tuyanamma kéiteq kemmá ítama timónaineraq kéoo? kemô túnnama ‘pááqya-kanaabimma móragaraq kemmá timónainoe’ maaminnáyatababoaq keráwáqá wemmá kéitaimma wemmá kéitaimma kéoo?” téna Îtuma timá yímikaiye. ");
INSERT INTO usa_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","óq-aimma Îtuma tiráiye: “áraimma kétima-timune. keráwáqá ibiqá kéyareq keráwáqá mi-kánááráq ketoqá máíyana miráíyata mimórá táoqa maa-márábi-káyúkámá yimuq-yatáápí mánoe. keráwáqá tirumá ínomanibo anaaékaq tiru-qtatáákómá waéqma timuq-yatáápí mánoe. ");
INSERT INTO usa_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","aaragómá iyápómo akáínéna kéenama wení kanaamá kéitanaboana wemá arummá ôriq kéiye. ááqibo anaaékaq iyápóma marákátuwenama amuqá kémarena wení aíqo éwai-qtataaqa wemá káwikatuwaiye. ");
INSERT INTO usa_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","miráitaq íbêqa keráwáqá tirummá kéoe. ááqibo móragaraq keráwáqá kétimonaanana keráwáqtí tíyakoma kanaa íniye. keráwáqtí timuq-yatááqá náawabi móra-nakoma keráwápíké ímatuwaniye. ");
INSERT INTO usa_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","mi táoqo pááq ínaqa keráwáqá móra-yataaqtaba íma kekáq itánóe. áraimma kétima-timune. keráwáqá móra-yataaqa ketibokáq itáíyana ketíwîkaq wemá timíniye. ");
INSERT INTO usa_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","naayóbákáráq móra-yataataqa ketíwîkaq íma ítama aónaraae. íbêqa ítama aónéra kéqokeq-yataaqa kémayaiyana keráwáqtí timuq-yatáákómá ógiqma wániye. ");
INSERT INTO usa_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","maami-qtátááqá taíganimma waéqma itaí-áípí timá tímikaune. mi táoqa yínaqa íma waéqma itaí-áípí timá-timenupo paá ketiboqtábámá abarokáq timá-timenune. ");
INSERT INTO usa_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","27","ketibomá wenamáárîq keráwáqtábábá kákaipoana mi táoqa keráwáqá ketíwîkaq itáíyaqa ketibokáq ‘ítatikanune’ téq kétune. keráwáqá keqtábámá tíkáitababoaq kemá ketibonôpake kukáunaq tirummá tímikaapoana minnáyaba ketibomá keráwáqtábá kákaiye. ");
INSERT INTO usa_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","29","kemá ketibommá ayuwéq maa-márábí kukéq íbêqa keráwáqá tiyuwéq ketibonôpaq yauweré kégoune.” Îtuma mirá téna titata wení iyápó-annama timá ámikaae: “mi aónaao! íbêqa waéqma itaí-áímmá íkétepo paá abarokáq kétene. ");
INSERT INTO usa_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","íbêqa ketáá káonaunatae. minnâ emá máqte-qtataaqtaba ítareboaa náawabi móra-nakoma paá íma awé kéonana emmá ítama káonaiye. minnáyabataa ‘Áánûqtunopake kukááne’ téqtaa ekáq tirummá kámunatae.” téta wení iyápó-annama tewana ");
INSERT INTO usa_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Îtuma yauwéqma tiráiye: “íbêqa keráwáqá árainaq kéwareraq tirummá kétimeyo? ");
INSERT INTO usa_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","ítáaro! mi-kánáámá kéyena íbêqa yábaaq kéipoaq keráwáqá móra-mora umágíyaqa kenamáa mánune. ááqibo kenamáa íma mánupo ketibó ketê máiye. ");
INSERT INTO usa_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","kaayoné-yátááqá mayaígáae téq maami-qtátááqá timá tímikaune. maa-márábímmá tú-tiq-yataapi máinomanibo akoqnáá umá máero! maa-márábí-qtátáákón áaikoma kemá uyátámakuraune. ");
INSERT INTO usa_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Îtuma maará-timatuwena yanaa wíyôpaq aúramma káonena tiráiye: “ketiboó, íbêqa kanaamá pááq umáguraiye. tágama-yataaqa enáanikokaq múte kéyauwinana tágama-yataaqa ekáq áanikoma kanaaráq múte yauwíniye. ");
INSERT INTO usa_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","miráipoaa emá náápaamma máqte-kayukati anómma ámitukaane. ááqibo wemá yemmá tiména-wayukama matúq-matuq umá mái-auwaraimma kanaaráq yimíniye.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","matúq-matuq umá mái-auwaraimma miráuma wáiye. móra-nakoma ekáráq kemá Îtu Káriqtokaraq káonaiye. emá enámáa árai-manikoe. ááqibo Îtu Káríqtomma emá timákaanana kukáiye. ");
INSERT INTO usa_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Îtuma óq-aimma nunamupí tiráiye: “mayaí mayaaó té tiména-mayaima mamá ánatatukaune. minnáyababoaq ení tágama-yataaqa maa-márábí-káyúkámá kéyiraatune. ");
INSERT INTO usa_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","ketiboó, naayóbáqá maa-márámá íma pááq uráitaq kemá etê máeqa anó-tagama-yataaqa egáráq kegáráq matokáuyane. ááqibo mirá-tágámá-yátááqá íbêqa keqnáámmá timiyo. ");
INSERT INTO usa_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","maa-márábí-káyúkámá tímikaana-wayukama enáwîkon áaimma yiráátiraune. naayóbáqá ení waayúkama máqe-uraamanibo kemmá tímikaanata enáaraq kéiteta mirá-uraae. ");
INSERT INTO usa_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","íbêqa yemá ítama kárutaae. minnâ máqte-qtataaqa ketê wáimma timénaq matokáunama enôpake iráiye. ");
INSERT INTO usa_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","irááti-yataaqa timá tímikaanama yeráwáqá timá yímitukaunata yeráwáqá matááe. naayóbáqá etê máqe-uraune. enôpake yúnaa enamáárîq timátíkaraanata minnáyaba áraimma ítama arútaraanata yirummá tímikaae. ");
INSERT INTO usa_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","kemmá yirummá tímê-kayukayaba nunamummá kétimayikaune. kemá íma maa-márábí-káyúkáyábá nunamummá kétune. yemá áraimma enabóata paá tímikaana-wayukayaba nunamummá kétimayikaune. ");
INSERT INTO usa_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","máqtemma kemá matokáunama ennámiye. móraiq umá máqtemma emá yokááná-yataaqa kennámiye. tiména-wayukama yirummá timéta ketí tágama-yataaqa múte yaútaae. ");
INSERT INTO usa_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","íbêqa kemá íma maa-márábí máune. enôpaqa kéyunatama yeráwáqá maa-márábí mááe. mú mikáq aokaq-kétíbóo, emá enáwîkoni akoqnááraq tímikaanana enáwîpi tímikaana-wayukama kawáá umá yabíqyikaao. miráinaka kerátámá úyaniq umá miráuma yeráwáqá kímoraiq ígáae téq kétune. ");
INSERT INTO usa_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","kemá yeráwáqtê máeqa enáwîkoni akoqnááraq tímikaanaq maamin-ákóqnááráké yemmá yabíqyíkaraune. kemá yabíqyíkaraunaboata máqtemma emá tímikaana-wayukabike mórama enayáápike íyukaune. paá kímora-nakoma aúyokurena Áánûqtuni agamatá-kánnáágómá tiráiniq umá áraimma iráiye. ");
INSERT INTO usa_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","íbêqa enôpaq kéyunamanibo maa-márábí paá máeqa maa-qtátááqtábá kétunaboata timuq-yatááqá yirupi kémayaiyanama yimuq-yatááqá ógiqma wániye. ");
INSERT INTO usa_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","enáama yímikaunatamanibo maa-márágóní waayúkama kekáá umá íma máápoata yeráwáqá maa-márágóní waayúkama yemmá íyámma umáyíkaraae. ");
INSERT INTO usa_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","timénna-wayukama eqtábá ‘maa-márábíkémmá íma yiwíqma paábaq yuwaao’ téq íkéitaupo paá Táí-nakoqtaba kawáá umá ‘íráqôniq umáyikaao’ téq ítama káonaune. ");
INSERT INTO usa_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","kemá íma maa-márábí-náqá máunata yeráwáqá móraiq umá maa-márábí-káyúkámá íma mááe. ");
INSERT INTO usa_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","yeráwáqá aokaq-aokaq umá árain-aain-aipi mamá yikaao. enáagoma árain-aain-aimma wáiye. ");
INSERT INTO usa_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","kemmá maa-márábímmô timátíkáráanaiq umá yeráwáqá móraiq umá maa-márábí timáyíkaraune. ");
INSERT INTO usa_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","keráwáqtábááé téq kenamáárîq mamá aokaq-aokaq kéune. miráipoata yeráwákáráq mamá aokaq-aokaq umá árain-aain-aipi kanaaráq mánoe.” mirá téna Îtuma nunamupí tiráiye. ");
INSERT INTO usa_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Îtuma ókaraq nunamummá tiráiye: “yenamáa yeráwáqtábá íma maami-núnámúmmá kétimayikaupo ááqibo yeráwáqtí yáamo ítáa-kayukayabagaraq kétimayimenata yirummá amínoe. ");
INSERT INTO usa_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","emá ketiboó, kepí maénaq kemá epí máunaiq umá yeráwáqá mimóráíq umá kímora-nakoraa umá kerátábí máigaae téq kétune. ");
INSERT INTO usa_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","kemmá tímikaana-tagama-yataaqa yímikaunaboata yeráwáqá kímora-nakoraa umá kerátámá máuyaniq umá mánoe. ");
INSERT INTO usa_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","kemá yepí máunaa emá kepí máane. miráuma komaé-yamae umá mórabi íráqôn-aaiqtaba ánatatuwenata máigaae téq kétune. máiyata maa-márábí-káyúkámá aónanoe. minnâ emá timátíkarema keqtábá ‘ákarainiq umá’ yeráwáqtábá ‘ákaraine’ téta tínoe. ");
INSERT INTO usa_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","ketiboó, emá yeráwáqá kemmá tímîqtukaanaq yeráwáqá kemá máennabaq máigaae téq kétune. tágama-yataaqa emô tímikaanama maa-márámá íma pááq uráitaama emá keqtábá ôriq umá ákaraine. miráinata yeráwáqá ketí tágama-yataaqa yimónanaae téq kéune. ");
INSERT INTO usa_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","kateko-kétíbóo, maa-márábí-káyúkámá emmá íma aónaraabo kemá emmá aónaraune. maami-káyúkámá ‘é timátíkaraane’ téta íbêqa kétimonaae. ");
INSERT INTO usa_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","enáwîkon áaimma yiráátiraune. ókaraq-okaraq yiráátimaeq onúne téq miráuma keqtábá tíkái-qtataaqa yokáánama yeráwápí maínaq kegáráq yeráwápí mánune.” Îtuma mirá téna nunamupí tiráiye. ");
INSERT INTO usa_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Îtuma mirá-timatuwena wení iyápó-annate Kítaroni-kokubi ko atátuweta mórama yópí máqtemma utááe. ");
INSERT INTO usa_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Îtuma netuqyaa-túpáá wení iyápó-annate mi-tómmá wáipaq wéwainapoana Yúqtaati namuro-wáyúkátí iyáápimmo Îtumma ma ayuwaí-nákómá wemá naayóbáqá mi-qtómmá aónaraine. ");
INSERT INTO usa_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","ááqibo Yúqtaati ááiq-wayukama yiwíqmena i-wáyúkágáráq uyátáraa-monoq-wayukabikekaraq Pérati-wayukabikegaraq yiwíqmena iráiye. ááiq-yataakaraq maméta ókáráq kúraqma mamé irááe. ");
INSERT INTO usa_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Îtuma máqte-qtataaqa wenaneq pááq ínimma aónaraiye. miráitana wemá waaqókáq uréna timá yímikaiye: “keráwáqá náawaqtaba abáá inera kéoo?” téna ítama aónaitata yemá tirááe: ");
INSERT INTO usa_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","“ketáámá Îtumma Náátárêtibake-nakoqtabataa kábaa-unnatae.” tewana Îtuma tiráiye: “kemúne.” téna tiráiye. Yúqtaati namuro-wáyúkátí iyáápi Îtumma mayuwáí-nákómá yeráwáqtê itó-uma máqe-uraiye. ");
INSERT INTO usa_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Îtuma “kemúne” kétitata yemá abákaq-abakaq umááe kéweta yinaaépake marabí ko wagéqé urááe. ");
INSERT INTO usa_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","keqnáámmá Îtuma ítama yimónaraiye: “keráwáqá náawaqtaba abáá inera kéoo?” téna titata yemá tirááe: “Îtuma Náátárêtibakene.” téta móragaraq tirááe. ");
INSERT INTO usa_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Îtuma maará téna yauwéqma timá yímikaiye: “kemá timá tímitukaune. minnâ kemíye. ááqibo kenamáa kemmá kétibaaeqa iyuwáíyata tébakaqa kóoro.” téna timá yímikaiye. ");
INSERT INTO usa_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Îtuma naayóbáq tiráiye: “máqtemma emá tímikaana-wayukabike mórama enayáápike íyuwaunana pukuráiye.” téna tiráimma min-áíkómá íbêqa kímora-nakoma Yúqtaatikaq áraimma pááq kéiye. ");
INSERT INTO usa_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","mikáq Tááímoni Pítaa yáákáá-qtátááqá yabitiréna mú mikáq anó-monoq-nakoni mayaí-nákómmá ikámma aáq aqtómá káratukaiye. maami-máyáí-nákón áwîqa Máárakatie. ");
INSERT INTO usa_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","ááqibo Îtuma Pítaamma timá ámikaiye: “mi-táákáá-qtátááqá yauwéqma ánáanobaqa maraao. ketibomá tímikai-kaapubike tú-tiq-yataaqa íyaq mayánúnô?” Îtuma mirá téna Pítaamma timá ámikaiye. ");
INSERT INTO usa_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","minnáyataba ááiq-wayukagaraq i-wáyúkágáráq Îtumma yáqtoqma ánná atáá urááe. ");
INSERT INTO usa_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","áqnáabaq Îtumma awíqmeta Áánatikaq urááe. Áánati wemá Kááyapatimma ánáakon aboáé. mú mikákáá anó-monoq-naqa mi-kárítímáátíráqá máqe-uraiye. ");
INSERT INTO usa_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","taákaq máráaro! Kááyapati wemá naayóbáq tiráine: “móra-naqo puyéna máqtemma aarawaamá yíwáqnaa ínímma minnâ kanaaráqíye. móra-naqa puínatama máqte-kayukama íauyoranoe.” téna Kááyapati naayóbáq tiráiye. ");
INSERT INTO usa_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Tááímoni Pítaayaa iyápó-annabike móra-waigote Îtumma anaaé waqméta urááye. yenákábíké móra-waigomma mú mikákáá anó-monoq-nakoma aónama arútaraimiye. yenákábíké keqnáá-nákómá Îtugaraq anó-nakoni naaúpaqa utááye. ");
INSERT INTO usa_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","ááqibo Pítaa máápaq oqtaráq itó-uma máqe-uraiye. miráitana móra-waigoma mú mikákáá anó-monoq-nakoma aónama arútarai-nakoma yauwéqma kukéna oqtaráq yabíkáin-inikoma márúmma timá ámituwena Pítaama awíqmeta uyábekaaye. ");
INSERT INTO usa_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","oqtaráq yabíkáin-inikoma Pítaamma timá ámikaiye: “egáráq min-nákóní iyápó-annawabono?” téna titana Pítaa yauwéqma tiráiye: “kemá ímiye.” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","yaugiq itata máqtemma mayaí-wáyúkágáráq i-wáyúkágáráq iramá agamaréta iraráq itó-uma máawana aanibo Pítaa yeráwáqtê ya itó-uma máena iramá káánuraiye. ");
INSERT INTO usa_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","mú mikákáá anó-monoq-nakoma Îtumma wení yirááti-yataaqtababi wení iyápó-annayataba ítama aónaraiye. ");
INSERT INTO usa_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Îtuma yauwéqma maará téna timá ámikaiye: “abarokáq umá máqtemma maa-márábí-káyúkámá timá yímikaune. aati-aatimá monoq-náúpáqá anó-monoq-nama wái-marupi máqtemma Ítíráaeo-wayukama ya aíkuyo-marupimma timá yímikaune. ketáayataba aupaq-áímmá ítiraune. ");
INSERT INTO usa_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","nôraq itaa kekáqá ítama káonaano? timá-yimunata ítaraa-kayukama ítama yimónaao. kemá túnna-aimma yeráwáqá ítararanoe.” téna Îtuma yauwéqma timá ámikaiye. ");
INSERT INTO usa_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","23","mirá-tin-aiqtaba móra-i-nakoma óyauga yuráqtuwena wemá akoqnáá umá tiráiye: “miráumawaq mú mikákáá anó-monoq-nakokaq timáminono?” téna titana Îtuma yauwéqma timá ámikaiye: “otaammá kuí-aímmô tiráán-aama máqte-kayukama timá yíminata ítáaro. ááqibo árain-aimmo kétun-aama nôraq itaawáq kétikamono?” téna Îtuma timá ámikaiye. ");
INSERT INTO usa_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","miráitana Îtumma ánná atáá-umakaamma paá wáinakaraq Kááyapati mú mikákáá anó-monoq-nakaq Áánati timákáitana uráiye. ");
INSERT INTO usa_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","mimórá táoqa Tááímoni Pítaa iraráqá itó-uma máena kégaanitata ítama aónaraae: “egáráq wení iyápó-annabikenabono?” tewana Pítaa yauwéqma tiráiye: “kemá ímiye.” téna wakákáiye. ");
INSERT INTO usa_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","móra-mayai-nakoma wemá Pítaa aárarammo káratukain-annabiken-nakoma Pítaamma ítama aónaraiye: “egáráráq Îtutema yópímmá máanaraq aónaraunabiyo?” téna ítama aónaitana ");
INSERT INTO usa_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Pítaa móragaraq wakaréna mimórá táoqa “ímiye” titana mikáq kokóregoma áa tiráiye. ");
INSERT INTO usa_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","aaqá iráráitata Kááyapatinopake Îtumma awíqmeta anó-kamaani-nakoni naaópaqa urááe. kámááni-nakoni naaúpaqa íma uyábékaae. uyáberetama kótámaki-kanaaraq-aawaqa kanaaráq ínanoe. ");
INSERT INTO usa_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","miráipoana Pááírati kumá yaúbama yeráwáqtôpaq kukéna tiráiye: “nóiqtabawaq keráwáqá wenaúbimma kémaraao?” Pááírati ítama yimónaitata ");
INSERT INTO usa_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","yeráwáqá yauwéqma ten-áíkómá maará-tiraae: “wemá íma otaammô kúi-nakaa íma enôpaqtaa awíqme má ayuwánáá únnatae.” téta tirááe. ");
INSERT INTO usa_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","ááqibo Pááírati timá yímikaiye: “keráwáqá kenamáárîq mamá Ítíráaeo-wayukati aammá aúmakaan-aipi wemmá yaínáaro!” Pááírati téna titata Ítíráaeo anó-monoq-wayukama tirááe: “móra-nakoma ikamíyábámá ketááí mayaímá íma wáiye.” téta tirááe. ");
INSERT INTO usa_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","naayóbáqá Îtuma náaraq umá puyónúnô tiráina-aikoma áraimma pááq inéna kéiye. ");
INSERT INTO usa_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Pááírati kámááni-naupaqa yauwéqma uyábékena Îtumma ááyarena ítaraiye: “emá Ítíráaeo-wayukati mú mikákáá anómma yabíkáána-naraq (kíni) máano?” téna ítama aónaitana ");
INSERT INTO usa_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Îtuma yauwéqma tiráiye: “keqtábámá enamáárîraq enááq-maqma ítama káonaa waayúka naayóbáráq timá ámikaan-ainaq ítama káonaano?” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pááírati yauwéqma Îtumma timá ámikaiye: “kemá Ítíráaeo-narabuno? ení waayúkagaraq uyátáraa-monoq-wayukagaraq emmá awíqmeta má tímikaae. emá nôraq uráánatabiyo?” téna Pááírati Îtumma ítama aónaitana ");
INSERT INTO usa_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Îtuma yauwéqma tiráiye: “ketí márûqa maa-márágónnámá íma wáiye. ketí márûqa maa-márágónnámô wáikakaa ketinaaémma wáráa-kayukama ááiqa éta íma kemmá tiwíqma anó-monoq-wayukati iyáápi maráné oné. ímiye. ááqibo ketí márûqa maa-márágónnámá íma wáiye.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Pááírati tiráiye: “emá anómma yabíkáána-narabono?” téna ítama aónaitana Îtuma yauwéqma tiráiye: “emá keqtábá anómma yabíkáána-nare kétene. ketinóma matíkáitaq maa-márábí kukáunama árain-aain-aimma ténááq kukáune. máqtemma árain-aain-annama ketáaraq kéitaae.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","minnáyaba Pááírati yauwéqma tiráiye: “aanibo árain-aain-aimma nóinabiyo?” téna Pááírati tiráiye. mirá-timatuwena Pááírati keqnáámmá kumá yaúbama anó-monoq-wayukayopaq kukéna tiráiye: “kemá otaammá kutáín-aaimma wepímmá íkáonaune. ");
INSERT INTO usa_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","taákaq máráaro. keráwáqá móra-aaimma yokáapoaq móra-naqa ayúwáanana kótámaki-kanaaraq wíniye. miráinaq ‘Ítíráaeo-wayukati anómma yabíkái-naqa’ ayúqtikanuno?” téna Pááírati tiráiye. ");
INSERT INTO usa_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","mikáq yeráwáqá anókaq timá ámikaae: “wemá ímiye. ketáá Baráábatiqtaba kétikaiqtaae.” téta ááyaqtaa umá tirááe. Baráábati wemá otaammá kumá waayúka ikákena moyámmá maténa i-náqíye. ");
INSERT INTO usa_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","miráitana Pááírati timá yíkáitata Îtumma tebûqa ámikaae. ");
INSERT INTO usa_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","ááiq-wayukama áwáábiq-annama kárama atoyumá aqnókáq kámokaa umá kuyákareta tokô-kaqtoma matéta anómma yabíkái-nakokaa umá aneq abákaraae. ");
INSERT INTO usa_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","yemá ókaraq-okaraq umá iréta tirááe: “‘Ítíráaeo-wayukati anómma yabíkái-nakoqtaba’ máqtemma miráono-maraaono téra tíyaqtaao.” téta timátuweta wemmá óyauqa yurákááe. ");
INSERT INTO usa_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","keqnáámmá Pááírati kumá yáubarena timá yímikaiye: “aónaaro! otaa-qtátááqá wepímmá íma káonaunaboaq wemmá awíqma márúte máápaq keráwáqtôpaq kumónúne.” téna Pááírati timá yímikaiye. ");
INSERT INTO usa_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Îtuma áwáábiq-annagaraq tokô-kaqtogaraq umátokainakaraq kumá kéyaubaitanama Pááírati timá yímikaiye: “aónaaro! maan-náqá wemíye.” téna timá yímikaiye. ");
INSERT INTO usa_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","uyátáraa-monoq-wayukagaraq anó-monoq-naupaken-i-wayukagaraq wemmá káonetama anókaq ááyaqtaa umá tirááe: “wemmá kaapaq-yátáq ikámma aráápa maraao! wemmá kaapaq-yátáq ikámma aráápa maraao!” téta tewana Pááírati timá yímikaiye: “keráwáqá kenamáárîq wemmá awíkera kaapaq-yátáq ikámma aráápa máráaro! kemá aónáúnama íma otaammá kutáiye.” téna Pááírati titata ");
INSERT INTO usa_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Ítíráaeo anó-monoq-wayukama yauwéqma timá ámikaae: “wemá ‘Áánûqtun áanikomune’ tiráipoana minnáyaba ketááí aammá aúmatan-aikoma maan-náqá puíno kétiye.” téta timá ámikaae. ");
INSERT INTO usa_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","ááqibo Pááírati min-áímmá ítáimma wemmá ókaqma-aaqa kamáguraiye. ");
INSERT INTO usa_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Pááírati yauwéqma kámááni-naupaqa uténa Îtumma ítama aónaraiye: “emá náakakena iráánô?” téna ítáitana Îtuma aamá ítiraiye. ");
INSERT INTO usa_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Pááírati timá ámikaiye: “nôraq itaawáq íma ketáaraq yauwéqma kéteno? ketí akoqnáárake emmá kanaaráq ayúkeq kéti akoqnáárake emmá kaapaq-yátáqá ikámma aráápa-yakanune. íyaq minnâ káonaano?” téna titana ");
INSERT INTO usa_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Îtuma yauwéqma timá ámikaiye: “Áánûqtu ení akoqnáá-yataaqa ámikaipoaa ení akoqnáárake kemmá kanaaráq mirá-umatikanone. miráipoana kemmá tiwíqmena enayáápi má márái-nakopi wái-kumiq-yataakoma ení kúmiq-yataaqa uyátá-maqma wáiye.” téna Îtuma yauwéqma timá ámikaiye. ");
INSERT INTO usa_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","min-áímmá ítátuwena Pááírati Îtumma ayuwáínana kóinin-aiqtaba abáá kéitata Ítíráaeo anó-monoq-wayukama anókaq ááyaqtaa umá tirááe: “emá ayúwénana kóínaama Títaama” Arómani mú mikáq anó-naqa wení ‘aanábómá’ íma mánone. móra-nakoma wenamáárîq anómma yabíkái-nakon amé mékaan énama wemá Títaani webó-náqá mániye.” téta tirááe. ");
INSERT INTO usa_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Pááírati yeráwáqô ten-áímmá ítátuwena Îtumma awíqma yainaí-nákóní abíqtáráq óqtamma maréq-uraapimma Ítiráaeo-wayukati yáabimma Káábatae tekáq Pááírati maraq máqe-uraiye. ");
INSERT INTO usa_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","taákaq máráaro. mi táoqa kótámaki-kanaaraq máqte-qtataaqa mamá óqtaa í-yúpáámíye. miráuma abaúgómá aúkáa-makaaq itana (12:00) Pááírati timá yímikaiye: “aónaaro! keráwáqtí anómma yabíkái-naqa maannámiye.” téna Pááírati tiráiye. ");
INSERT INTO usa_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","min-áímmá ítátuweta waayúkama ááyaqtaa umá tirááe: “nékaq akaao! nékaq akaao! wemmá kaapaq-yátáq ikámma aráápa maraao!” téta tewana Pááírati akáyáámá timá wíráabe umákena timá yímikaiye: “nóinabiyo! keráwáqtí anómma yabíkái-naqa kemá kaapaq-yátáq ikámma aráápa-makanuno?” téna titata uyátáraa-monoq-wayukama yauwéqma tirááe: “Títaama wenamáa ketáái anómma yabíkáimiye.” téta tirááe. ");
INSERT INTO usa_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","ááqibo miráitana Pááírati Îtumma yeqtiyáápi maréna kaapaq-yátáq ikámma aráápa-maraigaae téna yímikaiye. miráitata Îtumma awíqme yewana ");
INSERT INTO usa_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","wenamáárîq kaapaq-yámá aqména uráiye. ááqibo móra-anugon-awiqa “áqnón-ayaatane” ten-ánúráq kóuraiye. Ítíráaeo-wayukati yáabimma Kórákótá-anue. ");
INSERT INTO usa_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","mibáq Îtumma kaapaq-yátáq ikámma níri amá aráápa-makaraae. káqomma kaayaq-nákárátámá téba-tebaq kaayaq-káápáq-yátáq yíkamma níri amá aráápaq-mayiketa Îtumma aúkáapi ikámma kaapaq-yátáq aráápa-makaraae. ");
INSERT INTO usa_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pááírati móra-aubama agamá kaapaq-yátáq aráápa-makaiye. min-áúbágómá mirá-tiraiye: “Îtuma Náátárêtibakene Ítíráaeo-wayukati anómma yabíkái-nare.” wemá mirá téna agatáiye. ");
INSERT INTO usa_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","min-áúkápáq Îtumma kaapaq-yátáq ikámma aráápa-makaraae. waaqókáq anó-marukapoata taígani-kayukama min-áúbámá yoráútaae. Pááírati Ítíráaeo-wayukati yáabikaraq” Arómani-aipikaraq Karíki-aipikaraqa agatáiye. ");
INSERT INTO usa_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","miráitata uyátáraa-monoq-wayukama Pááíratimma timá ámikaae: “‘Ítíráaeo-wayukati anómma yabíkái-nare’ té íagayaao! emá maará té agayaao. ‘maan-nákómá Ítíráaeo-wayukati anómma yabíkáuna-naqune tiráiye’ té agayaao!” téta tewana ");
INSERT INTO usa_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pááírati yauwéqma tiráiye: “kemá agamaráuna-aubama minnâ agamakáune.” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","ááiq-i-wayukama Îtumma kaapaq-yátáq ikámma níri amá aráápa-makatuwetama wení unáákáqtôma mamá yakáqma kaayaqté-kaayaqte-aqtoiq umáketa móra-mora umá yáátáá umátaae. wení aneke-káqtókáráq matáamma íma arááqtama-qtamma meyabaké kumátamakuraine. ");
INSERT INTO usa_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","wení aneke-káqtóyátábámá ááiq-i-wayukama ye íyáá téite urááe: “maaminnâ íma yakaráíyaqtaao! minnáraq aábêma kéyaananatanaa móra uyátainna-nakoma mayániye.” téta aábê yarááe. naayóbáq Áánûqtuni agamatá-kánnáábí tiráine. minnâ “ketí unáákáqtôma mamá yátáá umáyeta ketí unáákáqtôraq aábê yamá móra uyátainna-nako mayániye.” téna tiráiniq ááiq-i-wayukama mirá-uraae. ");
INSERT INTO usa_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","ááqibo Îtuni kaapaq-yátágóní waaqókáqá wenanóagaraq wenanóani aúkogaraq wenáwîqa Máríaa Kárópatin ánáako Máríaa Máátarinigaraq itó-uma máqe-uraae. ");
INSERT INTO usa_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Îtuma wenanóakaraq wení iyápó-annabike ôriq umá ákái-nakaraq mikáq itó-uma mááyana yimónatuwena wenanóamma timá ámikaiye: “aaragô, enáanima maamíye.” téna Îtuma wení iyápó-annabike móra ákái-nakoqtaba timátuwena ");
INSERT INTO usa_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","wení iyápó-annabike ákái-nakomma timá ámikaiye: “enanôma maamíye.” téna titana mikáké min-íyápó-ánnábíké-nákómá Îtuni anóama awíqmena mó yabírákaraiye. ");
INSERT INTO usa_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","íbêqa aónaimma máqte-mayaima wenaboámá ámikai-mayaima mamá ánatagitana Îtuma tiráiye: “kemmá nonáá kétikaiye.” téna tiráiye. mirá kétimatuwenama máqtemma Áánûqtuni agamatán-áíkómá pááq íniye tiráiniq umá ánatagitana áraimma mirá-uraiye. ");
INSERT INTO usa_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","tawebímmá wááéni-nokaraq waaqókáq wáqe-uraiye. aináákáá-qtátááqnápó wááeni-nopi yamá atímma yátábi apiramá múte mamá Îtun óyaukaq makááe. ");
INSERT INTO usa_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","wááéni-nomma yaímma nátuwena mirá téna tiráiye: “maaminnâ ánatagiye.” mirá-timatuwena aqnómmá mamá awáutena pukuráiye. ");
INSERT INTO usa_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","mi táoqa kótámaki-kanaaraq máqte-qtataaqa mamá óqtaa í-yúpáárápóata Ítíráaeo anó-monoq-wayukama “arááq-yuma íma kaapaq-yátáq wáikaae” téta tirááe. aabáyaama Taabati-yúpáábóata anón-aawaqa naí-yúpáárápóata “yúma kaapaq-yátáráq íma wáikaae” téta tirááe. miráipoata min-Ítírááéó-wáyúkámá Pááíratimma ko ítama aónaraae: “yítauqa ko akáma yúma mamé mó yúwáaro téaq timáyikaao.” téta tirááe. ");
INSERT INTO usa_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Pááírati ááiq-i-wayukama timáyíkáitata iréta Îtute yíkamo-nakoratati yítauqa ya akátaae. ");
INSERT INTO usa_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","ááqibo Îtukaq iréta aónaamma wemá pukuráitataboata wenaítauqa íma akátaae. ");
INSERT INTO usa_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","aanibo ááiq-i-wayukabike móra-nakoma wení waqtáánápó Îtun arautapí atáqtúwáitana mikáqá nokáráq naaegáráq aumé kukáiye. ");
INSERT INTO usa_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","minnáma kemmá timónai-nakoma watáa tiráimma min-áímmô timá minnâ áraimma tiráiye. kemmá timónai-nakoma wenamáárîq aónaraimma minnâ áraine. miráinaq mikáq keráwáqá tirummá amínoe. ");
INSERT INTO usa_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Áánûqtuni agamatá-kánnáábí tiráiye: “íma móra wenayááqtáma akatínoe.” Áánûqtuni agamatá-kánnáábí tiráimma minnâ áraimma kéyipoana mi-qtátááqá pááq uráiye. ");
INSERT INTO usa_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","káqomma Áánûqtuni agamatá-kátáágómá kétiye: “waayúkama agaibamáráa-naqa aónainoe.” min-áíkómá mirá téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","anaaékaq Yótêbi Aarimatéabake-nakoma wenamáárîq Pááíratikaq Îtun aúma mamé mó uqtamákainayaba ítama aónaraiye. Yótêbi Îtun anaaé wárái-naqanibo wemá Ítíráaeo anó-monoq-wayukati yáaqa kéikatenaboana aúpáq mirá-uraiye. Pááíratima kanaaráq mayániye téna titana Yótêbi Îtun-auma mamé kóuraiye. ");
INSERT INTO usa_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Níkótímaatigaraq Îtumma ko aónainena nokáámma urái-nakoma wemá káwekaa-qtataakaraqa óq-yarake kugáqmatakaraqa mákama íráqôn-akuq-yataaqa ko maména uráiye. taíganipoana miráuma óqtakoraan-ummaa (34 kg) yaráiye. ");
INSERT INTO usa_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","miráitata máqtemma Ítíráaeo-wayukati yáaimma pukáa-kayukama kéuqtaani umá Îtumma uqtamákaiyeta urááye. yenákámá Îtun-auma matétarata paru-baru-wáqtóráké máqte-qtataaqa mamé i-qtátááqnápógáráq múqmûma útúyuweta ákûq-matawekaraq umá uqtamákaiyaqtaba mamá óqtaa urááye. ");
INSERT INTO usa_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Îtuma pukái-marukaqa mipímmá yómmá wáqe-uraiye. mi-qtópímmá móra aúgen-oqtapi muríámmá waayúkama uqtamáyikaima wáqe-uraiye. min-óqtá-múríápímmá naayóbáqá móra-naqa íma uqtaráápine. ");
INSERT INTO usa_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Ítíráaeo-wayukati máqte-qtataaqa óqtaa í-yúpáá pááq iné kéitataboata Îtumma min-óqtá-múríápímmá mó uqtamákaraaye. ");
INSERT INTO usa_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","áqnáabaq-yupaama Tótaaraqa maí-nókáápáqá paá íma aaqá iráqma tágaraitana Máríaa Máátarini Îtumma uqtamákaraa-muriamma waípaq iráiye. ya aónaimma muríán ótaken-oqtama paábaq matukááe. ");
INSERT INTO usa_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","miráitana wemá uyaaténa yauwéqma Tááímoni Pítaayaa min-íyápó-ánnábíké Îtuma ôriq éna ákái-nakonopaq uréna timá yímikaiye: “yeráwáqá uyátárai-nakomma uqtamákaraa-murianobake mamá náakarabi ketáá íaonaunabaqtaa wemmá ákaraae.” téna timá yímikaiye. ");
INSERT INTO usa_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Pítaayaa káqon-iyapo-annabike Îtuma ôriq éna ákái-nakote mikáq yuwéta uqtamákaraa-muriamma waípaq urááye. ");
INSERT INTO usa_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","yenákámá móraiq-moraiq umá uyaatéyamanibo káqon-iyapo-annabike Yóáane wemá Pítaamma kótamaqtuwena uqtamákaraa-muriakaq wenókáá iráiye. ");
INSERT INTO usa_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","awaútena kúreq umá aónaimma Îtumma útúyakaa-qtataaqa paá mibáq wáqe-uraitana aónaimanibo íma kumábékuraiye. ");
INSERT INTO usa_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","anaaékaq Pítaa iréna uqtamákaraa-murianobaq íma ko awé uráibo páátákáá kumábékuraiye. wemá útúyakaa-qtataaqa aónaimma mibáq wáqe-uraitana ");
INSERT INTO usa_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","aqnókáqô útúyakaa-qtataakoma íma tébakaqa útúyakaa-qtataakote wáqe-uraibo aokaq wenamáárîq útûma wáqe-uraiye. ");
INSERT INTO usa_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Pítaan anaaépaq keqnáámmá wenókáámô yin-íyápó-ánnábíké-nákómá mi-múríánóbáqá kumábékena “Îtuma pukáipike itó-uma kóuraiye” téna wemá arummá ámikaiye. ");
INSERT INTO usa_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","taákaq máráaro. yeráwáqá mi táoqa íma ítama arútaraae. Áánûqtuni agamatá-kánnáágó téna “wemá pukáinabike itó-iniye” tiráine. ");
INSERT INTO usa_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","miráitata yenákámá yauwéqma naaópaq kóuraaye. ");
INSERT INTO usa_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","pááqya-kanaabi anaaékaq Máríaa muríánôtaq itó-uma máena ibiqá yakáiye. paá ibiqá kéyarena wemá awaútena uqtamákaraa-murianobaq kúreq umá aónaimma ");
INSERT INTO usa_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","kaayaqá Áánûqtunopake kaqtó-nakoratama wayánúná káqtô mamarétarata Îtuni aúma wáqe-uraikaq máqe-uraaye. aqnómmá wáqe-uraikaq móra-naqa maraq máiten káqo-nakoma aítuqo wáqe-uraikaq maraq maéta urááye. ");
INSERT INTO usa_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Áánûqtunopake-nakabike móra-nako tiráiye: “aaragô, nôraq itaawáq ibiqá kéyaraano?” téna ítama aónaitana min-íníkómá yauwéqma tiráiye: “yeráwáqá ketí uyátárai-nakomma maméta náabarabi wemmá mó-yukaawaq íkáonaune.” téna timá ámikaiye. ");
INSERT INTO usa_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","mirá-timatuwena Máríaa waéqma aónaimma Îtuma mikáq itó-uma máqe-uraiye. miráimanibo wemá íma Îtue téna aónaraiye. ");
INSERT INTO usa_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Îtuma wemmá ítama aónaraiye: “aaragô, nôraq itaawáq emá ibiqá kéyaraano? náawaqtabawaq emá abáá kéono?” téna Îtuma ítama aónaitana Máríaa yó-káwáá-nákó kétiyaa téna aúyánámmá ítátuwena wemá Îtumma yauwéqma timá ámikaiye: “anóko, emá wenaúmo mamé mó-yukema náakarabiyaa tiráátinaq wemmá ko máyáano.” téna min-íníkó timá ámikaiye. ");
INSERT INTO usa_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Îtuma wemmá timá ámikaiye: “Máríaao!” titana waéqma Îtumma káonena timá ámikaiye: “Aráábuni!” wenáaimma “tirááti-naqa tíkáinare” téna timá ámikaiye. ");
INSERT INTO usa_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Îtuma Máríaamma timá ámikaiye: “kemá ketibonôpaq paá íutaupo kemmá íyaqtoraao! ááqibo ketíbâqawaanopaq uréaq mó-tima-yimiyo. ‘kemá ketibogáráq keráwáqá keqtibogáráq ketí Áánûqtuma keráwáqtí Áánûqtuma máipaq kéuyune.’” téna Îtuma timá ámikaiye. ");
INSERT INTO usa_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Máríaa Máátarinima Îtuni iyápó-annama mó-tima-yimikaiye: “kemá uyátárai-nakomma aónaraune!” téna timátuwena wemá Îtuma timámin-aimma timá yímikaiye. ");
INSERT INTO usa_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","mimórá-Tótáágóní áqnáabaq-yupaaraq aabaúmá kupékinobaqa Îtuni iyápó-annama anó-monoq-wayukayaba yáaqa ikatétaboata máqeo-marukoni oqtamá umá aúyaqma akoqnáá umákaae. akoqnáá umákaamanibo Îtuma yúbáq ya itó-urena miráóo téna tiráiye; “kaayoné-yátááqá karáwáqtê waíno.” téna ");
INSERT INTO usa_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","timátuwena wenayáákaraq arautakáráq yirááténa itata wení iyápó-annama yeqtí uyátárai-nakoma aónéta ôriq umá yimuqá makááe. ");
INSERT INTO usa_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","keqnáámmá Îtuma timá yímikaiye: “kaayoné-yátááqá keráwáqtê waíno. ketibomá kemmá maa-márábímô timátíkárainiq umá keráwáqá móraiq umá maa-márábí kétimakaune.” téna ");
INSERT INTO usa_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","23","mirá-timatuwena yetôpaq aáma kéyimena tiráiye: “Aokaq-Áámá máyáaro. keráwáqô waayúkati kúmiq-yataaqa iyaabótuweqa ókaraq taákaq ímaraiyanama miráinata yeráwáqtí kúmiq-yataaqa áraimma íma wániye. ááqibo yeqtí kúmiq-yataaqa keráwáqá yáqtoqtoraiyatama yeráwáqtí kúmiq-yataaqa áraimma paá wániye.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Îtuni iyápó-annabike móra-naqa Tómááti wenáwíkón áaimma “ábárawaaoma” tébakaqtema íma máitana Îtuma mikáq iráiye. ");
INSERT INTO usa_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","miráitata tébakaq-noiyapo-annama ókaraq-okaraq timá ámikaae: “uyátárai-nakoma aónatukaunatae.” téta tewana Tómááti maará téna yauwéqma timá yímikaiye: “ayáápimma níri-abuma íaoneq níri-apimma tiyáánaubiqa íguyeq tiyáámma watáán-ápímmá íguyeq éqa íma tirummá aménúne.” téna Tómááti timá yímikaiye. ");
INSERT INTO usa_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","ááqibo abapaké kaumo-yúpáámá ánatagitana Îtuni iyápó-annama keqnáámmá naaúpaqa mááwana Tómááti mikáq yetê máqe-uraiye. máqten-oqtama umá akoqnáá-umareta mááwana Îtuma yetúbáq ya itó-urena tiráiye: “kaayoné-yátááqá keráwátê waíno.” téna timátuwena ");
INSERT INTO usa_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Tómáátimma timá ámikaiye: “ayáánaubiqa arúqma yúwénana ínaa tiyáámma aónaao. ayáámma arúqma yúwénana ínaa tirautapí kuyuwo. íbêkakemma arummá íámî-nakaan íyé arummá timiyo.” téna Îtuma Tómáátimma timá ámikaiye. ");
INSERT INTO usa_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tómááti yauwéqma tiráiye: “ketí uyátáraana-nakoma ketí Áánûqtumone!” téna Tómááti titana ");
INSERT INTO usa_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Îtuma timá ámikaiye: “kemmá kétimoneboaa arummá kétimene. kemmá ítimonaa-kayukama yirummá kétimeta yimuq-yatáápí mánoe.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Îtuma netuqyaa anón-awaameq-yataaqa wení iyápó-annati yúrakaq imánibo máqtemma maa-kánnáábímmá íagataune. ");
INSERT INTO usa_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","ááqibo Îtuma minnâ “Metáíyae. Áánûqtun Áanikoe.” téq keráwáqá tirummá kámeqa wenáwîkake matúq-matuq umá mái-auwaraimma kanaaráq mayánóe. miráipoaq maamin-áímmá agataúne. ");
INSERT INTO usa_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","anaaékaq Táíbíriati-nokayukaq Îtuma wenamaarîq keqnáámmá ókaraq yiráátiraiye. maaminnâ náabarabi uráine. ");
INSERT INTO usa_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Tááímoni Pítaa Tómááti wenáwíkon áaimma “ábárawaaoma” Natáánio Kéinabaq Kááriri-marupakene Yéberi áanikoratagaraq káqomma kaayaqá Îtuni iyápó-annabike-karatagaraq máqtemma komáé-yamae umá máqe-uraae. ");
INSERT INTO usa_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Tááímoni Pítaa tébakaqa timá yímikaiye: “kemá noyááq-amaataq kégoune.” téna titata tébakaqa tirááe: “ketáágáráqtáá etê ónúnatae.” téta timámiqtuweta yeráwáqá máqtemma kóureta nopí-káárébí ko uyáqtama máeta uráámanibo yeráwáqá mi-nókáámmá íma móra-noyaaqa yáqtokaae. ");
INSERT INTO usa_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","aabáyaanapimma aabaú utáné kéitana Îtuma mikáq non áwábaq itó-uma máqe-uraimanibo wení iyápó-annama “Îtue” téta íaonaraae. ");
INSERT INTO usa_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Îtuma yááyama timá yímikaiye: “iyáqô, yaímma-noyaaqa nanúna-yataaqtaa keráwáqá íyaq yáqtokaao?” téna titata yeráwáqá tirááe: “ímiye.” téta yauwéqma tewana ");
INSERT INTO usa_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Îtuma timá yímikaiye: “keráwáqtí kúqômma nopí-káárégómá tiyáánuran-aukapaq yukéraq aónaaro. keráwáqá yaímma-noyaaqa yabitínoe.” téna titata yeráwáqá mi-kúqómmá yukéta yabitemmá noyáákoma ógikaitataboata íma kanaaráq yabitirááe. ");
INSERT INTO usa_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Pítaa aneq-wáqtómá itokéna émáipoana Îtuni iyápó-annabike móra-naqtaba ákái-nakoma karámarena Pítaamma timá ámikaiye: “uyátárai-nakoe!” téna titana Pítaa ítátuwena wení óq-waqtoma mamá yatánáátá umá kéiyaipike nokaayúpí yáumeq-tagurena nokótaaqa yumáena Îtuma máipaq uráiye. ");
INSERT INTO usa_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","miráitata tébakaq-iyapo-annama nopí-káárébí iréta noyááqa ôriq éna ógikai-kuqomma yabitirááe. yeráwáqá non áwábakemma nékaqa ímiye (91 míta). paá waaqókápóana Îtuma non áwábake kanaaráq yááyama timá yímikaiye. ");
INSERT INTO usa_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","yeráwáqá paábaq ya aqtaréta aónaamma ira ámûraaqa noyáákaraq yakaráq wáqe-uraaye. ");
INSERT INTO usa_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","ááqibo Îtuma timá yímikaiye: “yaímma-noyaaqa yáqtoraiyama mamé yero.” téna titana ");
INSERT INTO usa_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Tááímoni Pítaa nopí-káárébí uréna taíbaq (153) anó-noyaaqnatomma mi-kúqópímmá ógikaimma yabitimá áwábaq móte yukáimanibo mi-kúqómmá íyarakuraiye. ");
INSERT INTO usa_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Îtuma timá yímikaiye: “aabáyaanapin-aawaqa yama nátuwero!” téna titata yeráwáqá aónaraae. wemá uyátárai-nare. tétaboata yúyánánóbáqá móra wení iyápó-annabike-nakoma íma “emá náawabono?” téna ítama íaonaraiye. ");
INSERT INTO usa_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Îtuma iréna yammá mámá yímikaiye. miráuma keqnáámmá noyáákaraq yímikaiye. ");
INSERT INTO usa_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","maaminnáma kaumobáq Îtuma pukáipike itó-urena wení iyápó-annama wenamáárîq yiráátiraiye. ");
INSERT INTO usa_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","aabáyaanapin-aawaqa nátuwetama Îtuma Tááímoni Pítaamma timá ámikaiye: “Tááímonio, Yóáanen áaniko, áqnaabaq maami-qtátááqtábámá mú mikákáán umá keqtábá kákaiyo?” téna ítama aónaitana Pítaa yauwéqma timá ámikaiye: “uyátáraana-nako, emá káonaane. kemá ení aanábóbóana ôriq éna kétikaiye.” téna titana Îtuma timá ámikaiye: “miráínaa ketí máqte-tipi-tipi-araaqa aáwaqa yimiyo.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","keqnáámmá kaayapáq Îtuma Pítaamma timá ámikaiye: “Tááímonio, Yóáanen áaniko, kemmá emá ákáinaraq máuno?” téna ítama áonaitana Pítaa yauwéqma timá ámikaiye: “owé. uyátáraana-nako, emá káonaane. kemá ení aanábóbóana ôriq éna kétikaiye.” téna titana Îtuma timá ámikaiye: “miráínaa ketí tipi-típiraq yabíqma arutaao.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","kaumobáq Îtuma Pítaamma ítama aónaraiye: “Tááímonio, Yóáanen áaniko, ketí aanábó máano? téna Îtuma kaumobáq ítama aónaitanaboana Pítaamma arummá ôriq kéiye. miráitana Pítaa timá ámikaiye: “uyátáraana-nako, máqte-qtataaqtaba káonaane. emá áraimma káonaane. kemá ení aanábóbóana ôriq éna kétikaiye.” Pítaa téna timá ámitana Îtuma yauwéqma tiráiye: “miráínaama ketí tipi-típima aáwaqa yimiyo. ");
INSERT INTO usa_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","kemá áraimma kétima-amune. emá maabumô máema ení ámûrannama umááe. náakarabi ónááe ténabaq paá urááne. ááqibo anónuqma kéma kaapaq ayáámma árúqtuwe márenata yeráwáqá miráuma-katuweta ámûrannama umá kátuweta emá ‘íonaae’ tinnamánibo yeráwáqá náakarabi emmá awíqmeta wínoe.” téna Îtuma Pítaamma timá ámikaiye. ");
INSERT INTO usa_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Îtuma min-áípí Pítaama náarabi umá puíniqtaba tiráiye. miráinana Áánûqtuni tágama-yataaqa múte yauwíniye. maamin-áímmá timátuwena Îtuma Pítaamma timá ámikaiye: “tinaaé waraao.” téna Îtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Pítaama waéqma káqomma móra iyápó-annabike Îtuma ôriq éna ákái-naqa náawabi kaawéqá naapí Îtumma áiqtaabi agebaréna tiráiye: “uyátáraana-nako, náawawaq emmá namuro-wáyúkátí iyáápi maraí-náqá máiyo?” téna ítama aónarai-naqa yinaaé waqmé kéiye. ");
INSERT INTO usa_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Pítaama aónatuwenama Îtumma timá ámikaiye: “uyátáraana-nako, wemmá nôraq inábiyo?” téna Pítaa Îtumma ítama aónaitana ");
INSERT INTO usa_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Îtuma yauwéqma tiráiye: “ááqibo paá márainaq mi-kánááráq kemá yenúnama minnâ ení mayaíyábiyo? ení mayaímá paá ketinaaé waraao.” téna Îtuma timá ámikaiye. ");
INSERT INTO usa_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","miráipoata timá uréire máqtemma yirummá ámê-kayukabi urááe. maamin-íyápó-ánnábíké-náqá “íma puíniye” téta timá uréire urááe. ááqibo Îtuma íma weqtábá puíniye téna timá ámikaibo wemá tiráiye: “paá márainaq mi-kánááráq kemá yenúnama minnâ ení mayaíyábiyo?” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","iyápó-annabike-naqa mimórá maami-qtátááqtábá aónaraipoana agatáiye. wemô tiráimma árain-aain-aimma ítaraunatae. ");
INSERT INTO usa_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","paá taígani-qtataaqa Îtuma uráimanibo móra-moramo agamaráiyanama mútûq maa-márábímmá min-áúbágómá titipáá ínata yeráwáqá íma kanaaráq íráqôniq umá maránoe. ");
INSERT INTO usa_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Tíópiratio, naayóbáqá maami-kánnáábímmá watáama agatáunama minnâ Îtuma mi-qtátááqá tarôq uréna aarawaamá yiráátirai-qtataaqtaba agatáune. ");
INSERT INTO usa_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","naayóbáké áaimma átárena íbêq-kanaaraqa Îtuma wenamáárîq awaaméqá umáyikena timáyíkarai-kayukama yiwíkena aamá áúmatan-aimma kéyiraatiye. wemá mayaímá mamá ánataigae téna Áánûqtuni Aokaq-Áágóní akoqnááraq timá yímikaiye. mikáké Áánûqtuma Îtumma awíqmena Áánûqtuma yabíkái-marupaqa utáiye. ");
INSERT INTO usa_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","naayóbáqá Îtuma wenamáárîq aú-aiqa maténa pukáipoana anaaékaqa netuq-kánáámá wemá iyápó-annaraq wenaúma má-yiraatiraiye. miráuma kaayaq-wáyúká ái-ayaa-kanaama (40 kanaama) Îtuma yetôpaqa uréna Áánûqtuma yabíkái-qtataaqtaba timá yímikaiye. ");
INSERT INTO usa_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","mirá téna Îtuma yeráwáqtê aáwaqa naí-yááréráq maraq máena timá yímikaiye. keráwáqá Yérútáárebaq íma yuwéraq kóoro. keráwáqá paá yaákareq aboámá ‘timénúne’ téna timá akoqnáá tiráine. naayóbáqá Îtuma maará-tiraine: “kemá timá tímikaunna-yataaqaba awé oro. ");
INSERT INTO usa_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Yóáane wemá aarawaamá nommá péqyikaraimanibo anaaékaqa pááqya-kanaabimma nommá peránómma Aokaq-Áágómá péqtikaniye.” téna Îtuma tiráine. ");
INSERT INTO usa_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","ánibo mi-kánááráqa iyápó-annama mórabi áíkuma máqe-uraae. yeráwáqá maará téta Îtuma ítama aónaraae: “uyátáraana-nako, íbêqa emá káámááni yabíkáanna-yataaqa yauwéqma ketáámá Ítíráaeo-wayukama yimínónô?” téta yemá tirááe. ");
INSERT INTO usa_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","ánibo wemá yauwéqma yeráwáqá timá yímikaiye: “maami-qtátááqá keráwáqtí minnâ íma wáipoaq mi-kánááwábi mi-túpááyábámá itánóe. ímiye. ketibomá aúyánápí kéitana wenamáa mi-qtátááqtábámá kéitaiye. ");
INSERT INTO usa_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","miráimanibo anaaékaqa Áánûqtuni Aokaq-Áágómá keráwáqtê kumáinaq keráwáqá akoqnááma mayánoe. ánibo keráwáqá ketáama maméq Yérútáárebakaraq Yúríabakaraq Támériabakaraq máqten-aukapaq-marabaqa mamé wéyáwé umá ínóe. ");
INSERT INTO usa_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Îtuma wemá maamin-áímmá timá ánatatuwaitata wení iyápó-annama aónraawana aboání marûpaq Îtuma utáiye.mórama waayá-kónnákómá awíqmena utáiye. miráitata móra-konnakoma awíqmena kóitata yeráwáqá ókaraq wemmá íma aónaraae. ");
INSERT INTO usa_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Îtuma aboání marûpaq kóitata yeráwáqá paá karáqtuwe máawana yeráwáqtí yimakaqá kaayaq-nákárátá itó-uma máqe-uraaye. yenákámá wayán-únákáqtôma umátoketa maará téta tirááye: ");
INSERT INTO usa_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","“keráwáqá Kááriri-wayukama nôraq itaráq itó-uma máeraq aabayápáqá karáqtuweraq mááo? maami Îtuma káonaawana Áánûqtuma wení márûpaq yauwéqma awíráitana kóiniq umá anaaéqa wemá miráráá umá yauwéqmena kumínaq aónanoe.” téta yenákámá tirááye. ");
INSERT INTO usa_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","miráitata yemá Óríbêti-anuraq máqeta yuwéta Yérútáárebaq waaqókáq uréire urááe. ");
INSERT INTO usa_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","ánibo yemá uréta naayóbáqá máqe-uraan-namma yanaammá aráqmata-naupaq máqtemma máqe-uraae. min-íyápó-ánnámá mibáq máqe uráa-yuti yíwîqa Pítaae. Yóáane. Yêmitie. Áánarue. Píripie. Tómáátie. Paatááromiyue. Máátiyue.anibo Yêmitima Áápiatimma áanikoe. ánibo Tááímonima káámááni-ayubike karuwaaq-náré. Yúqtaatima Yêmitimma áanikoe. mirá-uraiye. ");
INSERT INTO usa_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","maami-káyúkámá yemá máqtemma móra-iyakaq maréta nunamummá tíq-tiq urááe. ánibo yaímma aaranaammá Máriaama Îtuma anóama wení ábâqawaaraayugaraq máqtemma nunamummá tirááe. ");
INSERT INTO usa_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","mi-kánááráqá Pítaama itó-urena máqtemma wení ábâqawaaraayuma Îtun anaaé wáráa-kayukati yúrakaq móra-aimma tiráiye. mi-káyúkámá miráuma netuqyaammá (120) máqe-uraae. ");
INSERT INTO usa_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","Pítaama maará-tiraiye: “keráwáqá ketíbâqawaayuo, ítáaro.naayóbáqá móra-aimma maará téna Aokaq-Áágómá Tébitini óyaukaq tiráine. maamin-nákómá Yúqtaatima aammá yiráátiqtata Îtumma yáqtokaae. min-áímmá Yúqtaatitaba arammá iyaíno. tiráimma íbêqa abarokáq kéiye. ");
INSERT INTO usa_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Yúqtaatima ketáátê yagaroqtamá máqe-uraimma wemá maami-máyáímá matáiye.” téna Pítaama mirá-tiraiye. ");
INSERT INTO usa_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","maamin-nákómmá Yúqtaatima naayóbáqá wenamáárîq wení otaa-mónéqnápó maramá meyaníq uráine. min-áúkápáqá wenamáárîq ikákuraine. ko yutákitana yarákéna áyaqa kugúbagitana pukuráine. ");
INSERT INTO usa_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","minnáyaba máqtemma Yérútáárebaq máa-kayukama ítaraane. miráitata min-áúkápáqtábámá yeqtí yáabikemma Aaketááma miráuma ‘naae-márábáré’ kéte. ");
INSERT INTO usa_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","ánibo Pítaama maará-tiraiye: “maamin-áímmá Táámupi agatáin-aikoma maará kétiye. ‘wení naammá paá-namma wániye. móra-nakoma íma min-áúpáqá maíno.’ téna kétiye. ánibo ókaraq Táámuni wannaabí téna ‘káqo-nakoma ayuwáiyana wení mayaímá mayaíno.’ téna kétiye. ");
INSERT INTO usa_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","miráinataa íbêqa ketáámá móra-naqa uyátárai-naqa Îtute uréire uráiya-kayukabike aónama awiránúnatae. ");
INSERT INTO usa_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","naayóbáqá Yóáanema áaimma átárena nommá waayúkama péqyikaraikake Îtuma mayaímá áaimma átáma maténa aqtóráq itana Áánûqtuma yauwéqma wení márûpaq awíqmena úitata aónaraiya-kayukabike móra-naqa awiránúnatae. miráinana Îtuma pukáipike itó-urai-waigoni ketáátê watáama tíniye.” tená Pítaama tiráiye. ");
INSERT INTO usa_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Pítaama mirá-timatuwaitata yemá kaayaq-náqá yiwíkaae. móra-waigon-awiqa Yótêbi Yátatie. wení káqon-awiqa Patáábatie.morá-nakon áwîqa Máátáíyatie. ");
INSERT INTO usa_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","miráitata yeráwáqá nunamummá maará tétá tirááe: “uyátárai-nako, emá máqte-kayukati íyaqnobaqa kanaaráq káonaane. maa-kááyáq-nákábíkémmá náawanaq awiránónáa keqtáámá tiráátiyo. ");
INSERT INTO usa_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","miráinana min-nákómá Yúqtaatini mayaíráq mayániye. wemá mórama ení iyápó-annabi mániye. ánibo Yúqtaatima maami-máyáímá yuwéna puí-márúpáq kói-nakoni mayaíráq mayániye.” téta nunamupí tirááe. ");
INSERT INTO usa_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","mi máka-nakoratama kanaaráq mi-máyáímá máyáawaniq urááyataboata yemá nunamummá kéteta yátáma maqmá akátémma Áanûqtuma mi-tátámá mamá Máátáíyatinopaq makáiye. mikáké Máátáíyatima wemá uyátáitata wemmá awíqma tiyááka umá móra timáyíkáan-annate yagaroqtamá ákáraae. ");
INSERT INTO usa_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Îtuma pukéna itó-urai-kanaarake áaimma átárena kaayaq-wáyúkágáráq tiyááka-kanaaraq (áwíqa Péqtekoti-omaqa) yeráwáqá móra-naupaq yama áíkutaae. ánibo ");
INSERT INTO usa_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","anókaq áama ayéna akoqnáá uwáágoraa umá Áánûqtunopake kukéna maraq máa-naupaqa ógikaiye. ");
INSERT INTO usa_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","ánibo irautakáá-qtátááqá aónaraae. mi-qtátáákómá yabí-tábí umá móra-mora-yuti yiqnókáq kukáiye. ");
INSERT INTO usa_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","ánibo Áánúqtuni Aokaq-Áágómá yepí máqtemma ógiqme uráiye. mi táoqa yeráwáqa áaimma átáma óq-aipike Aokaq-Áágómá yímitata tirááe. ");
INSERT INTO usa_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","mi-kánááráqá yaímma Yérútáárebaq yamáa-kayukama yemá monoq-wáyúkábóata yemá máqte-marabake-kayukae. ");
INSERT INTO usa_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","maamin akoqnáá-uwaagoraan-aimma timá abarokáq itata máqtemma aarawaamá mórabita áíkutaae. miráitata yemá máqtemma móra-mora-yuma iyápó-annama yimónaamma óq-ain oq-aipike aamá kétewata ôpake ya máe-kayukama yeqtáábike aamá kétewataboata yimurere urááe. ");
INSERT INTO usa_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","ánibo yemá máqtemma iyánáaq umá kánateta yúyánámmá ôriq umá itéta tirááe: “yemá maami-káyúkámá máqtemma aamó te-káyúkámá Kááriri-marupake-kayukamoe. ");
INSERT INTO usa_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","náaraq íyô? ketáá móra-mora-yutaama ketááí táabikenaq kéitaunataabiyo?” téta tirááe. ");
INSERT INTO usa_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","ketáá máqtemma miráuma Páátíya-wayukama Maríya-wayukama Írama-wayukama Metapotémia-wayukama Yúría-wayukama Kaaparótia-wayukama Pááqtati-wayukama Étia-wayukama ");
INSERT INTO usa_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Parítiya-wayukama Paapíriya-wayukama Íqtîbi-wayukama Aríbiya-wayukama Tairíni-marupaq waaqókáre Aróma-wayukama Íbarugaraq Yéqtaaeo-wayukagaraq Karíti-wayukama Arébiya-wayukama itáunataama ");
INSERT INTO usa_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","ketáámá káqo-kaqo-marupake yemmá máqtemma ketááí táabike watáama Áánûqtuni anó-qtataatriq iqtábá kéte. ");
INSERT INTO usa_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","máqte-kayukama iyánáaq umá ánataraamanibo móra-nakoma mi-qtátáákón áaimma íma kanaaráq timá yímikaiye. yemá yeíyáá maará téta tirááe: “maami-qtátááqá nói-qtataakoni áainabiyo?” téta tiráámanibo ");
INSERT INTO usa_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","yaímma-wayukama akáyáámmá téta maará-tiraae: “yemá taíbaq-aipike téta taíbaq aúgemma wááéni-nomma naréta neginaagí kéoe.” téta tirááe. ");
INSERT INTO usa_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","miráimanibo Pítaama tiyááka umá móra-iyapo-annate itó-uma máena anókaq ááyama máqte-kayukama watáa timá-yimena tiráiye: “keráwáqá Ítíráaeo-wayukao, Yérútáárebaqa máa-kayukama ketáama itéraq maami-wágóní áaimma keráwáqá ítama arútáaro. ");
INSERT INTO usa_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","keráwáqá túyánámmá ítáama keqtááyábá ‘aíbôq-nomma naréta neginaagí kéoe’ téq kétemanibo íbêqa paá aabayaaráq (9 kirokiraq) kéuyawiye. ");
INSERT INTO usa_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","miráimanibo maami-qtátááqtábá naayóbáqá Áánûqtuni amuné-náqá Yóéroma maará-tiraine. ");
INSERT INTO usa_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Áánûqtu tiráine. ‘aqtó-kánáámá waaqókárîq kéinaqa ketí Aágoni akoqnááma yúwáanana máqtemma aarawaabí kumíniye. miráinata keqtáanimaarabi keqtiáámûmaaqa amuné-áímmá tínoe. keráwáqtí awaayatí-wayukama yúramma karákéta kainapákáá umá aónaiyata keráwáqtí anónuqma-wayukama kaimmá aónanoe. ");
INSERT INTO usa_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","mi-kánááráqá ketí mayaí-mákónábi mayaí-íníkómmá ketí Aágoni akoqnááma yíménata yeráwáqá amuné-áímmá tínoe. ");
INSERT INTO usa_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","kemá aabayákáqá awaaméq-yátááqá yiráátéq aménáápáqá maa-márábímmá awaaméq-yátááqá yiráátenune. naaegógáráq iragáráq úmukaraq wánoe. ");
INSERT INTO usa_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","uyátárai-nakoni anó-kanaama íma pááq uráinana aabaúgómá kumayuqá auráinana wíyokoma mamá naaemá aurániye. ");
INSERT INTO usa_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","mi-kánááráqá náayubi uyátárai-nakon áwîkaq yaíya-kayukama Áánûqtuma yeráwáqá yauwéqma yiwiraínata yemá wenná mánoe.’ téna Áánûqtuni amuné-nákomá Yóéro mirá-tiraine.” téna Pítaama tiráiye. ");
INSERT INTO usa_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Pítaama ókaraq tiráiye: “keráwáqá Ítíráaeo-wayukao, maamin-áímmá ítáaro. Îtuma Náátárêtibake-nakoqtaba aamá timá-timenaa kéune. ");
INSERT INTO usa_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","wemá keráwáqtí aúkáapi máitanama Áánûqtuma wepí taígani awaaméq-yátáákáráq amuné-áíkáráq tarôq itaq keráwáqá kenamáárîq aónaraae. naayóbáqá Áánûqtuma wenamáárîq aúyánámmá ítarena maamin-náqá Îtumma keráwáqtí tiyáápikaraq maréna keráwáqá ámáam-aimma arátê-kayukama iyáápi tímitaq wemmá kaapaq-yátáq ikámôwana pukáiye. ");
INSERT INTO usa_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","miráimanibo Áánûqtuma min-náqá yauwéqma pukáipike múte itó-umakaraiye. ánibo wemmá aú-aiqa éna puí-yátáápíké mamá paábaq ayúkaiye. miráuma puí-yátáákómá min-náqá íma kanaaráq yáqtokaiye. ");
INSERT INTO usa_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Tébitima min-nákóqtábá pukáipike itó-iniqtaba maará téna tiráine. ‘kemá máqte-tupaama uyátárai-nakoma ketí túbáq aati-aatimá máetaq aónaraunaboana wemá ketimakáq máipoana kemmá móra-yataakoma íma tiweqtániye. minnáyaba timuqá ôriq umá kémaraunana ");
INSERT INTO usa_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","ketáagoma amuq-yatáákáráq tóyaupikemma anókaq ááyama kétiye. ");
INSERT INTO usa_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","emá íma ketí tirun-íyápómá yúwénana puí-márúpáq wíniye. ítaraunboana ketí túgogaraq aagániye. minnâ kemá ení Aokaq-náqá íma ayúwénana kabiraíno. ");
INSERT INTO usa_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","matúq-matuq umá mái-apaq wí-ámmá kemmá tiráátiraanama kemá kétê máeboaa kepímmá timuq-yatááqá ógitikaraane.’ téna ketináábútáá Tébitima tiráine. ");
INSERT INTO usa_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","ketíbâqawaaraayuo, ketináábútáámá Tébitima púítata uqtamákaraane. wení mararaamá ketáátê íbêqa paá wáiye. ");
INSERT INTO usa_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","miráimanibo Tébitima Áánûqtuni amuné-náqá máenaboana kéitaitana Áánûqtuma árain-aimma akoqnáá umá maará-tiraine. mórama ‘enánnábíké-nákómá ení márûqa yabíkái-yataaqa mayániye’ téna Áánûqtuma Îtuqtaba Tébitimma timá ámikaiye. ");
INSERT INTO usa_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","naayóbáqá Áánûqtuma nôrabi ínéna i-qtátááqá Tébitima aónatuwena Îtuma pukéna itó-iniqtaba tiráine. Îtu Káríqtoma wemá min-nákóqtábá Áánûqtu íma ayúwáitana puí-márúpáqá máena wení aúgoma íma kabiraráiye. ímiye. ");
INSERT INTO usa_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Îtuma pukáipike Áánûqtuma mamá itó-umakaraiye. miráitaqtaa ketáámá aónareqtaa kétunatae. ");
INSERT INTO usa_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","íbêqa wemá Áánûqtuni márûpaq uténa Áánûqtuni Aokaq-Áágómá mayéna aboání aayáánurapaq máiye. ánibo naayóbáqá Áánûqtuma téna ‘Aokaq-Áámá aménúne’ téna tiráiniq umá íbêqa aboámá Aokaq-Áámá keqtáábí atítikaraitaq íbêqa keráwáqá káonaae. ");
INSERT INTO usa_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Tébitima Áánûqtuni márûpaqa Áánûqtuni aayáánurapaq ímamanimanibo wemá maará téna tiráine. ‘uyátárai-nakoma ketí uyátárai-nakoqtaba maará-tiraine. emá ketiyáánurapaq maraq mááo. ");
INSERT INTO usa_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","ánibo anaaékaqa kemá ení namuro-wáyúkámá mamá ení aítauq aménáápáq yikánúne.’ téna Tébitima tiráine. maamin-áimmá téna anaaékaq Áánûqtuma Îtuni namuro-wáyúkámá yítábí mayuwánîqtaba amuné-áípí tiráiye. ");
INSERT INTO usa_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","miráinataa ketáámá máqtemma Ítíráaeo-anna-wayukama maaminnáyabama ketáámá ítama arutánátae.maamin-náqá Îtumma keráwáqá kaapaq-yátáq ikámôwana pukáimma minnâ Áánûqtuma wemmá mamá anómma uyátárai-naqa Metáíyamma aúrákaraiye.” téna Pítaama tiráiye. ");
INSERT INTO usa_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","yemá maamin-áímmá ítáawana min-áíkóma yeqtí íyaqa atákáiye. yeráwáqá Pítaakaraq yaímma iyápó-annama maará téta timá yímikaae: “ketíbâtiwaayuo, ketááí túnabaro íbêqa ketáámá náaraq ónúnataabiyo?” téta tirááe. ");
INSERT INTO usa_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Pítaa maará téna timá yímikaiye: “keráwáqá máqtemma móra-mora-wayukama tirummá waeréraq monoq-nómmá Îtu Káríqton áwîkaq kéberaiyanawaq keráwáqti kúmiqa mamá paá umátikaino. keráwáqá mirá kéiyanawaq Áánûqtuma wení Aokaq-Áámá timíniye. ");
INSERT INTO usa_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","naayóbáqá Áánûqtuma maami-qtátááqá keráwákáráq keráwáqtí iyápógaraq yaímma nékaq máiya-kayukagaraq ‘timénúne’ téna timá akoqnáá uráine. owé. Áánûqtuma ketááí uyátárai-nakoma ‘timénúne’ ténaboana máqtemma yááyarai-kayukama Aokaq-Áámá yimíniye.” téna Pítaama tiráiye. ");
INSERT INTO usa_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","ánibo Pítaama aayáqtáákaq watáama akoqnáá umá maará tiraiye: “keráwáqá atéráaro! keráwáqá íma arupú o-káyúkátí táí-aaikake nékaq mááero. yetí táí-meyamma anómma aurániye.” téna Pítaama tiráiye. ");
INSERT INTO usa_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","miráitata máqte-kayukama Pítaan áama ítáa-kayukama monoq-nómmá pékaae. mi táoqa taígani-kayukama yirummá waékáamma (miráuma 3,000) mórabi yorupamá yoráutaiye. ");
INSERT INTO usa_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","mi-káyúkámá íráqôniq umá timáyíkáan-annati yáama kéiteta yíbâqawaayuma yíwáqnaa éta yeráwáqtê mórapike aáwaqa kéneta nunamummá tirááe. ");
INSERT INTO usa_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","miráitana Áánûqtuma taíbaq-awaameq-yataaqa iyápó-annabi tarôq uráitataboata máqte-kayukama ikatíq urááe. ");
INSERT INTO usa_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","máqte-kayukama Îtu Káríqtokaq itáíq-itaiq uráá-kayukagaraq mórabi máqe-uraae. ánibo yemá yeqtí máqte-qtataaqtabama mórabi maqmá yaíkááe. ");
INSERT INTO usa_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","miráitata yemá yeqtí máqte-qtataaqa waayúkaraq máráawata meyáníq kéowata móneqa matááe. mi-mónékáké yeqtí waayúkama móra-mora-yuma nóiqtababi o-qtátááqá meyáníq urááe. ");
INSERT INTO usa_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","máqte-tupaama yemá máqtemma mórabi anó-monoq-naupaq uráámanibo yemá óq-naun oq-nauke Îtuma naayóbáqá yímikainikaa umá yammá wááéni-nokaraq mórabike narááe.yeráwáqá yimuqá kémareta máqtemma yímikaae. ");
INSERT INTO usa_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","máqte-kanaaraqa yemá Áánûqtun áwîqa múte kéyauyowana káqo-kayukama yeqtí yáaimma yimónéta ‘íráqôniq kéoe’ tirááe. máqte-kanaabimma uyátárai-nakoma yauwéqma yiwírái-kayukama ókaraq-okaraq yoráutaiye. ");
INSERT INTO usa_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","móra-taoqa Pítaayaa Yóáanema anó-monoq-naupaq nunamummô téqo-kanaa énaikaq (3 kiroki) kéitata utááye. ");
INSERT INTO usa_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","ánibo móra-naqa aítauqa táíq urái-naqa mikáq awíqmeta utááe. min-náqá anóama miráuraimma marákáraine. máqte-tupaama anó-monoq-nakoni oqtaráqá aati-aatimá máitata min-óqtáyábá ‘íráqôn-auramma aónaiye’ téta tirááe. máqte-kayukama yemá wemmá káonaawana máqte-kanaaraqa móneqtaba waayúkaraq inaa-inaa tiráiye. ");
INSERT INTO usa_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","ánibo maamin-nákómá Pítaayaa Yóáanemma yumónaimma anó-monoq-naupaq uyáberaiyeta kéoyana min-nákómá oqtaráq máena yenákáráq yaímma-yataaqa timígáae téna ítama aónaraiye. ");
INSERT INTO usa_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Pítaama mi kárú-nakomma aúrapi karáqma akoqnáá kéitana Yóáanegaraqa miráuma aúrapi karákáitana Pítaama maará téna tiráiye: “emá kekárátá timónaao.” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","ánibo “móra-yataaqa yenákámá timíyéta kéoye” téna wemá waéqma yenákátí yúrapi karákáiye. ");
INSERT INTO usa_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","miráimanibo Pítaama maará téna tiráiye: “kemá móneqa íma matokáunnamanibo kemá móra-yataaqa matokáunnama kanaaráq emmá aménúne. minnâ Náátárêtipake-naqa Îtu Káríqton áwîkaq emá itó-uma aammá waao.” téna timá ámikaiye. ");
INSERT INTO usa_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","min-nákóní ayáákaq yáqtoqma itó-umakaitana páátákáá min-nákóní áíyayaakoma arupú umágéna akoqnáá uráiye. ");
INSERT INTO usa_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","ánibo min-nákómá yaúmetameta kéena uréire éna yenákátí yinaaé waqména anó-monoq-naupaqa uténa wemá yáumetameta kéena Áánûqtun áwîqa múte yaútaiye. ");
INSERT INTO usa_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","ánibo máqtemma aarawaamá min-náqá káonaawana uréire kéitata yemá Áánûqtun áwîqa múte yaútaae. ");
INSERT INTO usa_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","miráitata aarawaamá min-nákómá anó-monoq-nakoni íráqôn-oqtaraqa máena máqte-kayukaraq móneqtaba inaa-inaa téwai-nakoma aarawaamá íbêqa káonaawana atóbamagitata aónama iyánáaq kéeta taíbaq-yuyanamma ítaraae. ");
INSERT INTO usa_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","maami aítauqa táíq urái-nakoma Pítaayaa Yóáaneti iyáákaq toto umá aarawaamá anó-monoq-namma ‘Tórómónini naamátûpare’ tenn-áúkápáq uyaatéta yama áíkutaae. ");
INSERT INTO usa_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Pítaa mi-káyúkámá kéyimonena maará téna watáama timá yímikaiye: “keráwáqá nôraq itaráq maami-qtátááqtábámá netuqyaa-túyánámmá kéitaao? nôraq itaráq kerátátí túrapimma kégararaao? keráwáqá túyánámmá ítáama kerátámá kerátátí akoqnáágaraq aokaq-ááíkákénáq maamin-náqá mamá itó-umakarauyo? áraimma ímiye. ");
INSERT INTO usa_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","keráwáqá Ítíráaeo-wayukao, Áabaraagaraq Ááítekigaraq Yáakoboma yeráwáqá ketááí títaubikotaai Áánûqtuma wení mayaí-íyápógón áwîqa múte yaútaimma Îtue. wemá min-nákómmá keráwáqá awîqma ááíq-wayukati iyáápi máráawana anó-kawaa-nakoma Pááíratima aónaimma otaa-qtátááqá íma wáitanaboana yauwéqma paá timákanena uráimanibo ímiye. keráwáqá wemmá tinaaéma umákaraane. ");
INSERT INTO usa_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","miráita keráwáqá wemá arupú éna Aokaq-náqá íráqôniq umá yainaí-náqá aabi mayákaraae. keráwáqá waayúkama ikámma puí-náqá ayúkaamanibo ");
INSERT INTO usa_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","aúwaraikoni áai-naqa wemmá ikákaae. miráimanibo Áánûqtuma wemmá pukáipike mamá itó-umakaraitaka yauwéqma kerátámá minnáyaba wení watáama timáe uréire kéuye. ");
INSERT INTO usa_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","miráitaka kerátámá weqtábá itáíq-itaiq kéuye. miráitana Îtun áwîkaqa maamin-náqá mamá akoqnáá kéumakaitaq keráwáqá wemmá káoneq ítama kárutaae. Îtuma wenamáárîq kerátátí itáíq-itaiq í-yátááqá kétimitaka maami itaí-yákáákómá maan-nákókáqá keráwáqtí túrakaq íráqôn-akoqnaa-yataaqa abarokáq kéiye. ");
INSERT INTO usa_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","áraine. ketíbâtiwaayuo, kemá itáunnama maami-qtátááqá keráwákáráq keráwáqtí anó-kayukagaraq Îtu Káríqtomma íma ítama arútarepoaq keráwáqá mirá-uraane. ");
INSERT INTO usa_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","miráimanibo naayóbáqá Áánûqtuma maará téna wení amuné-wáyúkátí yóyaukaq tiráine. ketí timákai-naqa Káríqtoma aíqa í-yátááqá mayániye.’ tirááne. keráwáqá mirá kéowanaibeqa min-ááímmá abarokáq kéitana naayóbáqá Áánûqtuma tiráin-aikoma arammá kéiyaiye. ");
INSERT INTO usa_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","miráínaq túyánámmá waéqma itéraq tirummá waeraíyana Áánûqtuma keráwáqtí kúmiq-yataaqa mamá paábaq yuwéna awikátuwaniye. ");
INSERT INTO usa_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","miráiyanama Áánûqtuma keráwáqá aúgen-akoqnaama tiména Îtumma Káríqtoma timákainana kerawaqtôpaq kumínímma Áánûqtuma naayóbáq Îtumma awaaméqá umákaraine. ");
INSERT INTO usa_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","íbêqa wemá Áánûqtuni márûpaq máena Áánûqtuma máqte-qtataaqa keqnáámmá mamá aúgeniq íní-kanaayaba awé ínímma miráuma naayóbáqá Áánûqtuma wení aokaq-ámúné-wáyúkátí yóyaukaq tiráine. ");
INSERT INTO usa_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Móteti maará-tiraine. ‘Áánûqtuma uyátárai-nakoma keráwáqtí tíbâqawaayupike mórama amuné-náqá kekáá umá mamá timíniye. keráwáqá wenáama anaaé waqmá kéiteraq keráwáqtábá tínna-yataakoni anaaé wáráaro. ");
INSERT INTO usa_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","náayuwabi min-ámúné-nákón áama íma itáiyanama Áánûqtuma yeráwáqá yíkaminata puínoe. miráinata yemá ókaraq Ítíráaeo-wayukate móragaraq íma mánoe.’ téna Mótetima tiráine. ");
INSERT INTO usa_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","naayóbáqá Áánûqtuni amuné-wáyúkámá maamin-áímmá tiráamma Táámuyogaraq yaímma anaaékaqo abarokáq uráa-kayukagaraq yeráwáqá maamin-áímmá tiráamma íbêq-kanaaraqa wáiqtaba tirááne. ");
INSERT INTO usa_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","keráwáqá Áánûqtuni amuné-wáyúkátí iyápó-annama mááe. keráwáqtí tináábútáábi Áánûqtuma aamá timá yarúmakai-qtataaqa matáa-kayukae. Áánûqtu maará téna Áabaraamma timá ámikaine. ‘ení iyápógokake máqtemma maa-márábí-káyúkámá kemá yemmá íráqôniq umáyikanune.’ tiráine. ");
INSERT INTO usa_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Áánûqtuma áqnáabaq wení iyápóma Îtumma timákaitana keráwáqá mamá íráqôniq kéomatikena keráwáqtí táí-aaipike mamá waétikanena iráine.” téna Pítaama tiráiye. ");
INSERT INTO usa_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Pítaayaa Yóáanema yenákámá máqte-kayukabi watáama kéteyaqtaba anó-monoq-wayukagaraq monoq-náúpáq-káwáá-nákáráq Tááqtûti-wayukagaraq mikáq irááe. ");
INSERT INTO usa_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","ánibo anó-monoq-wayukama maamin-nákámá aarawaamá watáama kétima-yimeta ‘Îtu Káríqtoma pukáipike itó-urai-waigoni watáama kétima-yimeta yaímma pukáa-kayukama itó-inoe’ téta tiráiye. ");
INSERT INTO usa_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","miráitata yemá maamin-nákámá yáqtoqma ánná yiméta íbêqa énaikariq itata aabáyaamma aamá ítama yainánúnatae’ téta yiwíqmeta urááe. ");
INSERT INTO usa_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","miráimanibo netuqyaa-káyúkámá aaramá waamá yenákátí Îtuqtaba téyan-aimma itéta yirummá waékáamma yemá netuqyaa-káyúkáé (miráuma 5,000). ");
INSERT INTO usa_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","aabáyaamma anó-kayukagaraq anó-monoq-wayukagaraq yaímma ámáan-aimma yirááti-wayukagaraq máqtemma Yérútáárebaq áíkutaae. ");
INSERT INTO usa_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","ánibo máqtemma anó-monoq-wayukagaraq Áánatima Kááyápatima Yóáanegaraq Érékáánara yeráwákáráq yeqtí móra-annagaraq yeráwáqá mórabita Yérútáárebaq áíkutaae. ");
INSERT INTO usa_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","mi-kááyáq-íyápórátámá yemá yeqtí yúbáq mamá itó-umayikareta yemá maará téta ítama aónaraae: “kenákámá náawan áwîkarabi akoqnááraraq maami-qtátááqá tarôq kéoyo?” téta tirááe. ");
INSERT INTO usa_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","ánibo Aokaq-Áágómá Pítaani arupimmá ógiraitana wemá maará téna tiráiye: “keráwáqá Ítíráaeo-wayukati anómma kawáá-wáyúkágáráq waayúkati áaimma kawáá uráa-kayukagaraq keráwáqô, ");
INSERT INTO usa_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","kekárátá ítama aónéq ‘naayóbáqá maamin-náqá aítauqa táíq uráimanibo nôraq itanawáq aítaukoma íráqôniq uráiyo’ téq keráwáqá kétemanibo ");
INSERT INTO usa_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","keráwáqá káonaiyata máqtemma Ítíráaeo-wayukama aónaaro. maamin-náqá wemá keráwáqtí túbáq itó-uma mái-nakoma Îtu Káríqtoma Náátárêtibake-nakoni áwîkaq atóbama íráqôniq kéiye. min-náqá keráwáqá kaapaq-yátáq ikámôwana púitana Áánûqtuma wemmá yauwéqma itó-umakaraiye. ");
INSERT INTO usa_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","maamin-náqá Îtuqtaba Áánûqtuni watáama agamatá-kánnáágómá maará kétiye. ‘keráwáqá mayaí-wáyúkámá naammá inéq maamin-óqtáqtábá táí-oqtane téq tiráámanibo akoqnáá uráitata naakóní áwáá moyakaq makéta káqon-oqtamma min-ámúráq kémaraae.íbêqa maamin-óqtákómá akoqnáá-oqtama káuraiye.’ kétiye. ");
INSERT INTO usa_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","máqte-marabaqa Áánûqtuma íma káqon-awikaq keqtáámô yauwéqma tiwirániqtaama tiráátiraae. paá Îtun áwîkarapi akoqnááraraq tímikaiye. ");
INSERT INTO usa_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","ánibo káánítôre-wayukama yemá Pítaayaa Yóáanema yimónaamma yenákámá íma ikatîqa éta akoqnáá umá watáama tiráiye. miráitata monoq-káánitóré-wáyúkámá yenákámá yimónaamma naayóbáqá íma aúba-namma pékaaye. yenákámá paá Îtugaraq yagaroqtamá uréire uréta yaákaq urááe. ");
INSERT INTO usa_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","miráitata yemá aónaamma minnámo aítauqa táíq uráimma mamá íráqôniq umákaayan-nakoma yenákátê itó-uma yagaroqtamá máitata aónawaeta káánítôre-wayukama yemá tínón-aimma íma wáitata ókaraq íma watáama tirááe. ");
INSERT INTO usa_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","miráitata yemá min-nákámá timáyikaayata min-námmá yuwéta máápaq yaúbama mááyata yemá naaúpaqa watáama yeíyáá téite urááe: ");
INSERT INTO usa_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","“ketáámá maamin-nákámá nôraq umáyikanunataabiyo? yenákámá móra-awaameq-yataaqa tarôq óyata máqtemma Yérútáárebaq-ininaukaqa yemá aónama ánataraapoata ketáámá minnâ kanaaráq íma mamá aúyoranunatae. ");
INSERT INTO usa_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","miráimanibo maamin-áíkómá móragaraq anóniq umá máqte-kayukabi wéyáwé ínîpoaqtaa ketáá yenákámá yiwíkeqtaa ókaraq Îtuni áwîqa íma káqo-kayukama timá yíméro téqtaa akoqnáá-aimma timá-yimenunatae.” téta yemá tirááe. ");
INSERT INTO usa_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","ánibo yeráwáqá maamin-nákámá yiwíketa akoqnáá-aimma téta “kenákámá móragaraq maamin-náqá Îtun áwîkaqa káqo-kayukama íma timá yímekao.” téta tirááe. ");
INSERT INTO usa_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","miráimanibo Pítaayaa Yóáanema yenákámá maará téta tirááye: “kerátámá Áánûqtun aúrakaqa arupú-aainaq tarôq óyú keráwáqtí táawaq itáyúyô? keráwáqá kenamáárîq yainaí-wáyúkáráá umá máeqa timá tíméro. ");
INSERT INTO usa_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","kerátámá maami kateko-yátááqá káoneka ítarauyatabama íma kanaaráq paátí máyubo abarokáq timá-yimeyuye.” téta Pítaayaa Yóáanema tirááye. ");
INSERT INTO usa_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","máqtemma anó-monoq-wayukama akoqnáá umá iragáráq-áímmá téta maamin-nákámá timáyikayata kóuraaye. miraitata yeráwáqá máqte-kayukati yáaqa ikatîq urááe. ánibo anó-monoq-wayukama maamim-nákámá ánná yimínônaqtaba abáá uwaeta ibáqyukaae. máqte-kayukama maami-qtátááqá tarôq kéoyata káoneta yemá Áánûqtun áwîqa múte yaútaae. ");
INSERT INTO usa_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","ánibo aítauqa táíq uráimma mamá íráqôniq umákaraaya-nakoni-karitimaatima uyátá-maqma kaayaq-wáyúká áíyayaamma (40 karitimaatima) máqe-uraiye. ");
INSERT INTO usa_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","iyuwáiyatama yauwéqma yenákátí aanábó-wáyúkámá máápaq uréta anó-monoq-wayukama ten-áímma máma timá-yimikaaye. ");
INSERT INTO usa_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","ánibo yemá maamin-áímmá kéiteta yeráwáqá móra-iyakaq maréta nunamummá maará téta tirááe: “anó-nako, enamáárîq wíyôkaraq maragáráq únókáráq tarôq kée máqte-qtataaqa arunóbáqá wáimma tarôq urááne. ");
INSERT INTO usa_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","naayóbáqá ení Aokaq-Áágómá ketááí títaubikomma ení mayaí-náqá Tébitimma maará téna timá ámikaiye. ‘nôraq itatawáq Yéqtaaeo-wayukama íma Íbaru-wayukama íyamma yeráwáqá kéitatawaq nôraq itatawáq waayúkama aamá íma ítaraa-kayukaraa umá kéitao? ");
INSERT INTO usa_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","maa-márábí yabíkái-kayukama (kíni) yeráwáqá yokaa umá ánateta anó-kayukama mamá áíkuyeta Áánûqtumma wení Metáíyakaraq namuroíq umákaraae.’ téna Aokaq-Áágómá Tébitini ibí tiráiye. ");
INSERT INTO usa_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","áraain-uraane. kínima Érôtigaraq anó-kamaami-naqa Pááqtati Pááíratigaraq yaímma Yéqtaaeo-wayukagaraqa Ítíráaeo-wayukate yeráwáqá yagaroqtaréta máqtemma Îtumma ení Metáíyama namuroíq umákáraae. ");
INSERT INTO usa_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","miráimanibo yemá áíkuteta emá túyánápíké timá akoqnáá uráán-aimma abarokáq mamá pááq urááe. ");
INSERT INTO usa_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","uyátáráana-nako, íbêqa emá itaao.maamin-áíqtába yeráwáqá akoqnáá-aimma téta iragáráq-áímmá kéte. ení watáama abarokáq ikatîq íma éqtaa timá yiménúnayabataama tíwáqnaa uwo. ");
INSERT INTO usa_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","ení ayáámma múte yaúte waayúkama mamá atóbamayikeaq enamáárîq ení Aokaq-náqá Îtumma wenáwîkaqa anón-awaameq-yataakaraq kateko-yátáárîq uwo.” téta nunamupí tirááe. ");
INSERT INTO usa_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","miráitana yeráwáqá áíkuma máqeo-nakoma waráá-waraa kéitana yeráwápímmá Aokaq-Áágómá ógikaiye. miráipoata yeráwáqá ókaraq íma ikatîqa éta yeráwáqá akoqnáá umá Áánûqtuni watáama abarokáq áaimma átáma timá yímikaae. ");
INSERT INTO usa_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","máqtemma Îtukaq yirummá ámê-kayukama móra-iyakaq maréta móra-nakoma íma móra-yataaqtabama ‘kennáe’ téna tiráibo máqte-qtataaqa minnâ ‘máqte-kayukati minnáe’ téta yeráwáqá tirááe. ");
INSERT INTO usa_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","ánibo timáyíkarai-wayukama yeráwáqá Îtuma pukéna itó-urain-aimma téta wení akoqnáá-yataaqtabagaraq tirááe.miráitana máqtemma Áánûqtuma wení íráqô-yataa yímikaiye. ");
INSERT INTO usa_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","ánibo yeráwápíkémmá móra-nakoma íma aáwaqtabama áama yaráiye. miráitata máqtemma yeráwáqtí marawábi naammá waayúkaraq maráawata meyáníq urááe. minnárake móneqa matéta timáyíkarai-wayukama yímikaae. ");
INSERT INTO usa_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","ánibo timáyíkarai-wayukama yemá móneqa matéta aqtórárîq o-qtátááqá íma makáá-kayukama yaímma yímikaae. ");
INSERT INTO usa_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","ítáaro. móra-naqa máqe-uraimma wenáwîqa Yótêbie. wemá Aríbae-annabike abarokáq uráimanibo timáyíkarai-wayukama weqtábá Páánabati téta tirááe. min-áwíkon áaimma umá yíqtaiq í-árááré’. ");
INSERT INTO usa_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","wení maramá Táíparatibaq wáitana waayúkaraq máraitata meyáníq urááe. minnárake móneqa maténa timáyíkarai-wayukama má yímikaiye. ");
INSERT INTO usa_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","móra-naqa máqe-uraimma min-nákón áwîqa Áánánáíyatie. ánibo ánáakon áwîqa Tapáírae. miráitana Áánánáíyatima wení yaímma-yataakaraq maragáráq yaímma-wayukaraq maráyata meyáníq ígáae tirááye. ");
INSERT INTO usa_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","miráitana Áánánáíyatima mikáké móneqa maténa yaímma wetábá aúpáq máráimma ánáakogaraq aónaraiye. tébakaq-moneqa iyápó-annati yítaupi má-makaiye. ");
INSERT INTO usa_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","ánibo Pítaama maará téna tiráiye: “Áánánáíyatio, nôraq itaawáq emá Tááqtaamma ayuwáánanawaq ení áyaqnobaqa ógiraitaa emá Aokaq-Áágómmá kaaqaari-áímmá timá ayuwé mi-máráráké enamáárîq yaímma-moneqa aúpáq makáánô? ");
INSERT INTO usa_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","maami-márámá ení maramá íyaq wáqe-uraiyo? anaaékaqa maami-márámá meyáníq kéowana móragaraq ení maramá íma wáqe-uraimanibo móneqa maténa ennámíbo mónekaraq arupú íma urááne. nôraq itaawáq mirán-ááímmá tarôq uráano? emá morá-wayukama íma kaaqaari-áímmá timákáraapo Áánûqtuma kaaqaari timákáraane.” téna Pítaama tiráiye. ");
INSERT INTO usa_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","ánibo Áánánáíyatima maamin-áímmá kéitena marabí yutákéna pukuráiye. miráitata min-áímmá ítáa-kayukama ôriq umá yáaqtaba urááe. ");
INSERT INTO usa_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","miráitata yaímma awaayatí-wáyúkámá wení arááq-auma tabaráábe wáqtôbi múqmúmeta mó-uqtamakaraae. ");
INSERT INTO usa_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","anaaékaqa aabaúgómá kaumotá kéitana Áánánáíyatimma ánáakoma nói-qtaarabi abarokáq immá íma ítarena min-náúpáqá utáiye. ");
INSERT INTO usa_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","ánibo Pítaama maará téna: “Tapáírao, timá-timiyo. mararákémmá móneqa káginnawaq enawaikótêma matááyô?” téna Pítaa titana Áánánáíyatimma ánáakoma maará-tiraiye: “owé. kínnamiye.” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","ánibo Pítaama maará téna timá ámikaiye: “nôraq itakawáq kenákámá aamá timá móraraq marékawaq uyátárai-nakomi Aágómmá kémakateyo? emá itaao. enawaikómmá maaméta mó-uqtamakatuweta ye-káyúkámá yemá waaqókáq oqtaráq máanapoata yemá ekáráq maméta mó-uqtanoe.” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","miráitana Tapáírama wemá min-áímmá kéitena páátákáá marabí yutákéna pukuráitata awaayatí-wáyúkámá min-náúpáq utéta aónaamma Tapáírama pukuráitata yemá min-ínímmá maméta awaikómmá uqtamákáraa-waigoni waaqókáq mó-uqtamakaraae. ");
INSERT INTO usa_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","miráitata máqtemma yirummá ámê-kayukama káíkuyogaraq yaímma-waayukagaraq maamin-áímma kéiteta yeráwáqá yáaqa ôriq umá karáiye. ");
INSERT INTO usa_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","timáyíkarai-wayukama aarawaatí aúkáapimma netuqyaamá awaaméq-yátááqá ókon-okomma tarôq urááe. miráitata máqtemma itáíq-itaiq kéo-kayukama yeráwáqá móra-iyakaq maréta Tórómónini naamátûpare téta áwîqa yaakáq ya áíkutaae. ");
INSERT INTO usa_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","yaímma káqo-kayukagaraqa yemá ikatéta íma yeráwáqtê yagaroqtamá máqe-uraae. miráimanibo yemá aarawaamá maami-káyúkátí arupú-yaaimma aónaraae. ");
INSERT INTO usa_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","taíbaq-wayukama uyátárai-naqa Îtukaq itáíq-itaiq kéeta yeráwáqtê yagaroqtamá mórabi yorupamá yoráutaae. ");
INSERT INTO usa_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","miráitata máqtemma aarawaamá karí-wáyúkámá yíwíqmeta aakaq mó yíkaraae. miráinana Pítaama aakaq uréire kéinana amakómá mi-kárí-wáyúkámá yúgeqtaaq íniye. ");
INSERT INTO usa_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","yaímma aarawaamá máqte-marupakemma Yérútááre-marukoni waaqókáq-wáyúkágáráq yemá yama áíkutaae. mi-káyúkámá yemá karí-wáyúkágáráq yaímma táí-aagoma yeráwápí mái-kayugaraq yíwíqmeta irááe. miráitata máqtemma mi-kári-wáyúkámá atóbageqe urááe. ");
INSERT INTO usa_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","miráitata anó-monoq-wayukagaraq yaímma yeráwáqtê yagaroqtamá máa-kayukama yemá Táátûtiq-wayukaboata tímáyíkarai-wayukama anómma íyamma umáyíkaraae. ");
INSERT INTO usa_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","miráitata anó-monoq-wayukama yemá íyamma itata timáyíkarai-wayukama kárún-aaimma timáyiketa yáqtoqma ánná-naupaq otaa-káyúkágáráq yagaroqtamá yíkáawata máqe-uraae. ");
INSERT INTO usa_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","miráimanibo nokáámma uyátárai-nakonopake kaqtó-nakoma ánná-naupake oqtamá ítuwena máápaq yiwíqma márûte kéiyuwena maará-tiraiye: ");
INSERT INTO usa_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“keráwáqá anó-monoq-naupaq uréraq maami máqtemma aúgen aúwarai-waigoni áaiqtaba ítáamma abarokáq máqte-kayukama mó timá yíméro.” téna uyátárai-nakoni kaqtó-nakoma Áánûqtunopake iréna tiráiye. ");
INSERT INTO usa_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","yemá iyápó-annama maamin-áímmô kéitetama aabáyaanapaq yaúbama iréta anó-monoq-naupaq watáama máqte-kayukama má timá yímikaae. ánibo anó-monoq-wayukagaraq yaímma yeráwáqtê yagaroqtamá máa-kayukagaraq káánítôre-wayukagaraq yaímma Ítíráaeobake anó-kayukagaraq yeráwáqá mórabi áíkutaae. miráitata yemá ánná-naupaq aamá yuwéta iyápó-annama yíwíqme yero.” téta tirááe. ");
INSERT INTO usa_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","miráitata yaímma i-wáyúkámá ánná-naupaq uréta aónaamma min-náúpáqá iyápó-annama íma máqe-uraae. miráitata yemá yauwéqmeta anó-monoq-wayukaraq uréta maará-tiraae: ");
INSERT INTO usa_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“ketáámá ánná-nakoni oqtamá aónáunataama akoqnáá umá aúyaqmaketa ánná-wayukaraq yabi-í-wáyúkámá yemá máqten-oqtaraq yabíqtuweta máqe-uraae. miráitaqtaa ketáámá min-nákóní oqtamá íma aónáunataama min-náúpáqá móra-naqa íma máqe-uraiye.” téta tirááe. ");
INSERT INTO usa_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","ánibo i-wáyúkatí monoq-káwáá-nákógáráq wayúkati yaímma anó-monoq-wayukagaraq yemá maamin-áímmá ítátuweta yeráwáqá netuq-yúyánámmá kéiteta maará téta tirááe: “mi-qtátááqá náaraq umá pááq uráiyo?” téta tirááe. ");
INSERT INTO usa_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","miráitana móra-nakoma yeqtôpaq iréna timá yímikaiye: “ítáaro. maami-káyúkámá keráwáqá ánná-naupaq yíkáa-kayukama yeráwáqá anó-monoq-naupaq máeta máqte-kayukama watáama kétima-yime.” téna wemá tiráiye. ");
INSERT INTO usa_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","miráitata yaímma i-wáyúkágáráq yeqtí anó-kawaa-nakogaraq yeráwáqá anó-monoq-naupaq uréta iyápó-annama yíwíqmeta iráamanibo íma yíkakaae. ímiye. yemá máqte-kayukati yáaqa kéikatetaboata yeráwáqá tíkaminoqtaae téta ikatîq urááe. ");
INSERT INTO usa_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","28","miráitata i-wáyúkámá iyápó-annama yíwíqmeta káánítôre-wayukati aúkáapi máma yíkaraawata anó-monoq-makoma maará téna timá yímikaiye: “ketáámá akoqnáá-aimma téqtaa keráwáqtábámá ‘Îtun áwîqa íma yamá máqte-kayukama timá yíméro’ téqtaa ketáámá tiráunatae. miráimanibo keráwáqtí watáagoma Yérútááre-marupaq máa-kayukabimma wéyáwé umá anóniq kéitaq keráwáqá keqtááyábá maamin-náqá Îtumma ikámôwana pukáiye téq keqtááyábá kaaqaari-túbí kémaraae.” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","miráimanibo Pítaagaraq yaímma timáiyíkarai-wayukama yemá maará-tiraae: “ketáámá Áánûqtun áama waránúnatae. maa-márábí-káyúkátí yáama íma waránúnatae. ");
INSERT INTO usa_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","keráwáqá Îtumma kaapaq-yátáq ikámma puyówana ketibotáámá Áánûqtu mamá itó-umakaraiye. ");
INSERT INTO usa_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Áánûqtuma Îtuma kun áwíqmena wení márûpaqa wení waaqókáq múma akáitana wétê máiye. miráitana wemá keqtáámá kétiwirai-naqa áqnáabariq umátikenataa wemá ketááí anómma máena Ítíráaeo-wayukagaraq ketááí táí-aaipike mamá waétikenaqtaa kúmiqataapike mamá paá kéumatikaitaae. ");
INSERT INTO usa_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","maami-qtátááqtábá ketáámá Aokaq-Áágógáráq aónaraunatae. aarawaamá Áánûqtun-aimma wáráa-kayukama wení Aokaq-Áámá kéyimiye. ");
INSERT INTO usa_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","maamin-áímmá kéitaawana íyámma ôriq itata yíkama puyónúnatae tirááe. ");
INSERT INTO usa_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","móra-naqa Kaméírioma anó-monoq-naqa káánítôre-wayukati yúrapaq itó-uraiye. miráitana Kaméírioma wemá naayóbáqá ámáan-aimma yirááténa timá yímikaipoana máqte-kayukama wenáwîqa múte yaútaae. ánibo Kaméírio tiráiye: “iyápó-annama paá máápaq iyuwáiyata kóoro.” téna ");
INSERT INTO usa_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","káánítôre-wayukama timá yímikaiye: “Ítíráaeo-wayukao, keráwáqá maami-káyúkámá nôrawabi umáyikanae téqa túyánámmá ítama arútáaro. ");
INSERT INTO usa_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Tiútatiqtabama táakaq máráaro. wemá tiráiye. ‘kemá akoqnáá-naqa máune’ téna titata netuqyaa-káyúkámá (400) wenanaaé kéwaraawata yeqtí namuro-wáyúkámá Tiútatima ikámôwana képuiqtaba wení máqte-kayukama yuwéta pípéban umá péqmare kóuraane. ");
INSERT INTO usa_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","anaaékaqa kámááni-wayukama máqte-kayukati yíwîqa agataí-kánááráqá káqo-nakoma Yúqtaati Kááriri-marupake-nakoma wemá miráuma ‘akoqnáá-naqune’ téna titata taíbaq-wayukama wenanaaé wakáamanibo wemmá ikámôwana képuiqtaba wení waayúkama pípéban umá péqmareta kóuraae. ");
INSERT INTO usa_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","miráitaq kemá keráwáqá kétima-timune. maami-káyúkámá paá iyuwáiyataq mááero. yeqtáaraqa taíbaq-wayukama wáraamma paá waayúkagon-ama wáinanama paá ánataginiye. ");
INSERT INTO usa_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","miráimanibo yeqtáama Áánûqtunopake kukáinama keráwáqá íma kanaaráq aúyaqyikanoe. aúqyikaneqo éq oeqa Áánûqtuni namuró aúráabo.” téna Kaméírioma tiráiye. ");
INSERT INTO usa_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","miráitata anó-monoq-wayukama yemmá tebûqa yímíqtuweta ókaraq ‘Îtun áama íma máqte-kayukama timá yíméro’ timátuweta timáyíkarai-wayukama timá yíkáawata kóuraae. ");
INSERT INTO usa_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Kaméírioma wenáama waráiyata yeráwáqá káánítôre-wayukama iyuwéta kégoeta yeqtí yú-aiqa í-yátááqá Îtun áwîkake maétaboata yemá íma yiruqtabá urááe. ímiye. Áánûqtuma yemmá Îtun áwîkake yú-aiqa í-yátááqá mayaígáae téna yíwíkaiqtaba yemá yimuqá makááe. ");
INSERT INTO usa_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","miráitata máqte-tupaama anó-monoq-nauparabi waayúkati-naupaqa aarawaamá mamá áíkuyikareta Îtuma keqtáá yauwéqma tiwiránîn-nakoni átê-wataama íma yuwéta paá timá yímikaae. ");
INSERT INTO usa_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","mi-túpáámá Îtun anaaé wáráa-kayukama netuqyaa abarokáq urááe. miráitata yaímma min Ítíráaeo-wayukama Karíki-aimma ítaraa-kayukama Íbaru-aimma ítaraa-kayukaraq maará-tiraae: “máqte-tupaama keráwáqá Karíki-wayukati keqtoq-nóínímmá umaatamá aáwaqa íma yíméwata kémayaae.” téta tirááe. ");
INSERT INTO usa_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","miráitata Îtuni tiyááka umá timáyíkarai-wayukama máqtemma Îtun anaaé wáráa-kayukama yááreta yeráwáqá maará-tiraae: “ketáámá Áánûqtuni mayaímá yuwéqtaa aáwaqa yaímma yímíqmetaa uréire onatáámá íarutaniye. ");
INSERT INTO usa_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","miráinaq tíbâtiwaayuo, abapaké kaayaq-wáyúkámá yiwíráaro. yemá ketoq-nóínímmá aáwaqa kanaaráq yimínoe. keráwápíkémmá aabapaké kaayaq-wáyúkámá aaraukáqtí yúrakaqa yepímmá Áánûqtuni Aokaq-Áágógáráq itaí-yátáákógáráq ógikaina-wayukama yiwíráaro. yemmá yetí mayaímá ketáámá yiménúnatae. ");
INSERT INTO usa_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","miráinata ketáámá kenamáárîqtaa nunamummá kétetaa aarawaamá Áánûqtun áama yiráátenunatae.” téta tirááe. ");
INSERT INTO usa_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","ánibo máqte-kayukama min-áíqtábá yimuqá makááe. miráitata yemá mórabi áíkuteta abapaké kaayaqá yiwíkaae. móra-naqa Tíbeni wemá akoqnáá umá Áánûqtukaq itáíq-itaiq kéitana wepímmá Aokaq-Áágómá ógikai-nakagaraq Píripikaraq Parókaratikaraq Níkaanogaraq Tímonigaraq Paaménatikaraq mórama káqon-annabike-naqa Níkorautie. Níkorautima wemá Áátioki márûpakemma Yéqtaaeo-naqa áqnáabaqa máqe-uraimanibo anaaékaqa wemá mórama Íbaru-naqa yama aúqma máqe-uraiye. ");
INSERT INTO usa_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","miráitata yemá maami abapaké kaayaq-wáyúkámá mamá iyápó-annati yúbáq itó-umayikareta iyááma yínêkuyeta nunamummá timá yíkaraae. ");
INSERT INTO usa_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","miráitana Áánûqtun áagoma wéyáwé kéitana taíbaq-wayukama Yérútááre-aukapaqa iyápó-annagaraq yorupamá yoráutaae. yaímma anó-monoq-wayukagaraq min-áímmá kéiteta Îtun anaaé áaimma átáma wakááe. ");
INSERT INTO usa_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Tíbenimma Áánûqtuni íráqô-qtataakaraq akoqnáágaraq ógikaitana máqte-kayukati yúrakaqa taígani awaaméq-yátáákáqá ôriq uma tarôq uráiye. ");
INSERT INTO usa_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","miráimanibo yaímma-wayukama Tíbenimma aamá káwaageta namuroíq umákaraae. yeráwáqá Îbaru-wayukama Arómani-wayukati paá-mayaima mayéwao-kayukama máqe-uraane. yemá Tairínibakekaraq Érékáánarabakekaraq Tirítiabakekaraq Étiabakekarare. yemá Tíbenimma aamá timákaraamanibo wemá yeqtí itaí-yátááqá uyátáraitana Aokaq-Áágómá aamá tínín-aimma aráátitana tiráiye. miráitata paá-mayai-wayukati monoq-náúké-káyúkámá yemá Tíbenimma íma uyátáawaniq urááe. ");
INSERT INTO usa_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","miráimanibo Tíbenimma Áánûqtuni Aokaq-Áágómá akoqnáá umá itaí-yátááqá kámitataboata wenáaraqa yemá kanaaráq íma uyátáraae. ");
INSERT INTO usa_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","miráitata mi-mónóq-wáyúkámá yeráwáqá yaímma-wayukama aúpáq yiwíráawata maará téta kaaqaari-áímmá tirááe: “ketáá kéitaunanataa wemá Mótetikaraq Áánûqtun áwîkaraq timá táwîq uráiye.” téta yeráwáqá tirááe. ");
INSERT INTO usa_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","ánibo yeráwáqá mirá téta aarawaagáráq anó-monoq-wayukagaraq ámáan-aimma yirááti-wayukagaraq íyaqa timá atáráawata yeráwáqá Tíbenimma yáqtoqma awíqmeta káánítôre-wayukati yúrakaq urááe. ");
INSERT INTO usa_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","miráitata mi-mónóq-wáyúkámá yeráwáqá Tíbenimma kaaqaari-áúbí maránô-kayukama maará-tiraae: “aati-aatimá maan-nákómá maan aokaq-námá ámáan-aiqtabagaraq timá táíq kéiye. ");
INSERT INTO usa_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","ketáá kéitaunana wemá maará-tiraiye. ‘Îtuma Náátárêtabake-nakoma maan anó-monoq-naopaqa mamá táíq umátuwena Móteti naayóbáqá ámáan-aimma tímikaitaama mamá waéqma tawîq íniye.’ téna tiráiye.” téta yemá kaaqaari-áímmá tirááe. ");
INSERT INTO usa_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","miráitata káánítôre-wayukama yeráwáqá máqtemma Tíbenini óipi aónaamma Áánûqtunopake kaqtó-nakoni óikoraa uráiye. ");
INSERT INTO usa_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","ánibo uyátá-maqma anó-monoq-nakoma Tíbenimma ítama aónaraiye: “árainaq maamin-áímmá emá tiráánô?” téna tiráiye. ");
INSERT INTO usa_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","ánibo Tíbenima yauwéqma tiráiye: “ketíbâqawaayugaraq ketibóutaagaraq keráwáqá ítáaro. naayóbáqá ketináábútáámá Áabaraama Éraamuqa íurena paá Métápótémia mái-kanaaraqa tágama-yataaqa wáin-Aanuqtuma wekáq kukáine. ");
INSERT INTO usa_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","mi-kánááráqá Áánûqtuma Áabaraamma maará timá ámikaiye. ‘ení maragáráq ení waayúkagaraq iyuwé móra-aukapaq aúge-marama aráátenaaq únnabaq waao’ téna Áánûqtuma tiráiye. ");
INSERT INTO usa_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","miráitana Áabaraama wemá Káátía-maruqa yuwéna móra-maruqa Éraamubaq ko máqe-uraiye. ánibo anaaékaq Áabaraamma aboámá pukitana Áánûqtuma wemá timákáitana maami íbêqa keráwáqô máa-mararaq timákáitana iráine. ");
INSERT INTO usa_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","mi-kánááráqá Áánûqtuma Áabaraamma íma móra-marama ákaq wemmá ámikaine. ímiye. miráimanibo Áánûqtu wemá aamá timá akoqnáá éna téna Áabaraaqtaba ‘anaaékaqa maami-márámá matoké ení iyápó-annagaraq téna Áánûqtuma tiráine. miráimanibo mi-kánááráqá Áábaraama wemá iyápóma íma maqyíkaraitana Áánûqtuma akoqnáá-aimma tiráine. ");
INSERT INTO usa_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Áánûqtu maará téna Áabaraamma timá ámik